﻿USE sofia;
DROP TABLE IF EXISTS sofia.eka_vpl;
CREATE TABLE eka_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES eka_vpl WRITE;
INSERT INTO eka_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Go mbomannahb Esowo limi elbung abola ndi. ");
INSERT INTO eka_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ndi jolo nnehme nehme, agburu alab bulu ndi kpee, a akpang enye jolem, al ahb bulu njini kpee, ejannge konngo edi ajehng ajehng, Etohko ji Esowo jo fonngo yannge go ero alahb ma bulu o kpee. ");
INSERT INTO eka_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Esowo kehm bungu re, <<Nong ellennge jol>>, ellennge soro jol. ");
INSERT INTO eka_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Esowo nyehne re ellennge nˈnob, á kehm yabe ellennge yehke go ejannge. ");
INSERT INTO eka_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Esowo lungu ellennge re, <<Efung,>> fere lung ejannge re, <<Atv.>> Elgung jˈjol, efungfu jˈjol, owo jolo ngbokambang efung. ");
INSERT INTO eka_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Esowo kehm bungu re, <<Nong ewuungu jol yab alahb ma li go ero, a ma li ga ndi. ");
INSERT INTO eka_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ano wo Esowo limi ewuungu, yab alahb mako tv go ero, maka jol ga ndi. Ano wo jolo no. ");
INSERT INTO eka_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Esowo kehm lungu ewuungu re, <<Elbung.>> Elgung jˈjol, efungfu jˈjol, owo biingi etoono efung. ");
INSERT INTO eka_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Esowo kehm bungu re, <<Nong alahb ma li ga nla elbung temme feere edi anyehng, nong ndi nyi ma wum lohng.>> Ano wo jolo no. ");
INSERT INTO eka_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Esowo lungu ndi nyi ma wum re, <<Ndi,>> fere lung alahb ma temme feere edi ajehng re, <<Agburu aya.>> Esowo nyehne re ebnob. ");
INSERT INTO eka_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Esowo kehm bungu re, <<Nong nti a ajele jini go ndi, ajele nya kpo kab amohk, a nti nyi kpo kab akab, a amohk atahng, go nkohnankohn.>>Ano wo jolo no. ");
INSERT INTO eka_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nti a ajele kehm kehme eljini go ndi, ajele nya kpo kab amohk go nkohnankohn, a nti nyi kpo kab akab, a amohk atahng, go nkohnankohn. Esowo nyehne re ebnob. ");
INSERT INTO eka_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Elgung jˈjol, efungfu jˈjol, bi biingi nfung era. ");
INSERT INTO eka_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Esowo kehm bungu re, <<Nong nsol nyi bahke jo ka ellennge jol go ewuungu, eji lˈyabe efung, a atv, nong jol elliingi ni bahke jo tib ngare, afung, a nnya. ");
INSERT INTO eka_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Nong bo jol nlennge go elbung, jo ka ellennge ga ndi. Ano wo jolo no. ");
INSERT INTO eka_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Esowo kehm limi agburu nlennge na abal, ni ga gbal jo ya efung, ni ki ga gbal jo ya atv. Á tob limi alonlo. ");
INSERT INTO eka_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Esowo bumu bo go elbung re ka ellennge ga ndi. ");
INSERT INTO eka_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Eji lˈjo fili efung, a atv, fere yab ellennge a ejannge. Esowo nyehne re ebnob. ");
INSERT INTO eka_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Elgung jˈjol, efungfu jˈjol, bi biingi nfung eni. ");
INSERT INTO eka_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Esowo kehm bungu re, <<Nong ajoobo enyam nya li go elkpin rur go alahb, nong nruk jol jo fonngo yannge go ero elbung.>> ");
INSERT INTO eka_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ano wo Esowo limi agburu enyamalahb, a ajoobo enyam elahb bi bahke ruru go alahb, go nkohnankohn, nruk jolo go nkohnankohn. Esowo kehm nyehne re ebnob. ");
INSERT INTO eka_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Esowo kehm fuulu bo, fere bung re, <<Jelen, wahn jol go nfange, rur go alahb, nong nruk jel rur go njini.>> ");
INSERT INTO eka_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Elgung jˈjol, efungfu jˈjol, bi biingi nfung elon. ");
INSERT INTO eka_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Esowo kehm bungu re, <<Nong enyam jini go ndi, bi li nkohnankohn, atohkondi, a enyam bi kpo tohng ala go ndi, a enyam ekulugbe go nkohnankohn. Ano wo jolo. ");
INSERT INTO eka_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ano wo Esowo limi enyam ekulugbe, go nkohnankohn, atohkondi go nkohnankohn, a enyam bi kpo tohng ala go ndi go nkohnankohn. Esowo kehm nyehne re ebnob. ");
INSERT INTO eka_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Esowo kehm bungu re, <<Nong wahr limen nne go egahre elfoongo, á jol ana wahr, nong bo jo fili nsahre nyi li go alahb, a nrur nyi kpˈfonngo go elbung, a atohkondi, bo tob jo fili njini kpee, a enyam bi kpo tohng ala go ndi.>> ");
INSERT INTO eka_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Esowo kehm limi nne go ege elfoongo, go elfoongo ni Esowo ni á lim-e no. Á limi bo, nnenlum, a nnenkal. ");
INSERT INTO eka_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Esowo kehm fuulu bo, fere tong bo re, <<Jolen wahn jel rur go njini, wahn jo fili. Jo fili nsahre nyi li go alahb, nruk, nyi kpˈfonngo go ero, a nnyam anyehng anyehng nyi kpˈjene go ndi.>> ");
INSERT INTO eka_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Esowo kehm bungu re, <<M ma-n ka elkohn eljele anehng anehng ni kpo kab amohk, a eti ajehng ajehng ji kpo kab akab, a amohk go atahng, go njini kpee. Bahke jolo nsol alehke ka-n ");
INSERT INTO eka_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Me ka elkohn ajele anyehng anyehng re jol nsol alehke ka enyam kpee bi li njini, a nruk kpee nyi kpˈfonngo go ero, a enyam bi kpo tohng ala go ndi, go ejum ajehng ajehng ji kpi elkpin. Ano wo jolo. ");
INSERT INTO eka_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Esowo kehm seenge nsol kpee nyi á ma lim nyehn re ebnob sehng. Elgung jˈjol, efungfu jˈjol, bi biingi nfung erakera. ");
INSERT INTO eka_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ana wo Esowo limi elbung abola ndi mal, a nsol kpee nyi wob atahng. ");
INSERT INTO eka_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Re kehm biingi nfung esehma, Esowo eblim eltum kpee mal. Efung bi biingi nfung esehma, Esowo kehm reke ekv. ");
INSERT INTO eka_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Esowo kehm fuulu efung bio bi biingi nfung esehma, fere lim re jol saang, tibre efung bio bi á re ekv go eltum ni á limi njini. ");
INSERT INTO eka_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","wo li ntooba nnyo mi Esowo limi elbung abola ndi. Ngare nyi Jehova limi elbung abola ndi, ");
INSERT INTO eka_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ngare nyio nti, a ajele ka kehme elgbale a ndi, tibre Jehova ka na elahb wohngo go ndi, nnene jolem no bahke bahme ndi. ");
INSERT INTO eka_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ebohng bi bi jo lohng go ndi jo suku ndi kpee. ");
INSERT INTO eka_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Owo Jehova kehm koko ebtohko bi ndi lim nne, fere v elv ni elkpin kak-e go atangewul. Nne kehm bele elkpin. ");
INSERT INTO eka_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Jehova Esowo limi etahngga go Eden ji jolo ero nfam, owo á kake nne no á lim-e no. ");
INSERT INTO eka_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Jehova Esowo kehm limi ajoobo nti gbal lohng go ndi nya fuumu fuumu amahr, fere nˈnob go ellehke. Go elka elka etahngga eti jolo o ji elkpin, a eti ji elkahne ebi, a nnoobo. ");
INSERT INTO eka_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Go Eden wo aya jo fab ba ka elnaange go etahngga jio, aya mao yaame o fere jol efabe alahb emni. ");
INSERT INTO eka_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ngbokambang efabe bo kpo lung re Pison, kpo fab sennge ejang ndi bi bo kpo lung re Havila, edi ji agul li no. ");
INSERT INTO eka_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Agul nya li o kpˈsahb nˈnob. Ajoobo alahb nti ma esˈsv eleenge tob jolo o, a anobnobo atal nya bo kpo lung re onik. ");
INSERT INTO eka_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Etoono efabe jehko bo kpo lung re Gihon, kpo fab sennge ejang ndi bi bo kpo lung re Kus. ");
INSERT INTO eka_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Go Efabe ebra bo kpo lung re Taigris, kpo fab go ejang ero nfam bi Asur. Go etoono efabe na ebni bo kpo lung re Yufratis. ");
INSERT INTO eka_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Jehova Esowo bumu nne no á lim-e no go etahngga ji Eden re á jo lim eltum, fere jo kuuru edi jio. ");
INSERT INTO eka_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Jehova Esowo kehm kake nne noa ejehke re, <<Á bahke ma jo li akab nti anyehng anyehng etahngga jia; ");
INSERT INTO eka_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","sehngem re eti jio ji elkahne ebi, a nnobo nobo. Tibre efung bi a lˈsi lˈli, a bahke tiki kpoko.>> ");
INSERT INTO eka_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Owo Jehova Esowo kehm bungu re, <<Fuumem re nnenlum jol ntahngtahng, m bahke limi nkakebo no bahke fuumu a ne ka-e. ");
INSERT INTO eka_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Jolo re Jehova Esowo ko ndi lim ejoobo nnyam anyehng anyehng nyi li ekulugbe, a nruk a nruk kpee nyi kpo fonngo, á kehm koko bo ba goji nnenlum re á nyehn ana a bahke gungu bo abing, mbing anyehng anyehng nyi nne noo gungu nnyam anyehng anyehng, nyi nyi jolo mbing enye. ");
INSERT INTO eka_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ano wo nne noo gungu atohkondi abing kpee, a nruk, a nruk nyi kpˈfonngo go ero, a enyam ekulugbe. Ngare nyia Adam ka bel nkakebo no fuumu a ne. ");
INSERT INTO eka_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Jia limi Jehova Esowo kehm bumu Adam ellu, á lal kpˈkpoodo, eji á jo lal Esowo kehme yehke nkˈkehb anyehng fere feere edi jio bulu. ");
INSERT INTO eka_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ano wo Jehova Esowo ko nkˈkehb nyi á ma yehke goji nnenlum lim nnenkal, fere ko-e ba ka nnenlum. ");
INSERT INTO eka_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nne noo kehm bungu re, <<A wo li ekahb ji lohng egame ekahb, a ngubjing nyi lohng egame ngubjing, bo bahke jo lung-e re nnenkal tibre á lohng goji nnenlum.>> ");
INSERT INTO eka_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Esi jia ji wahnge nne bahke tahme nde a nnyehn sa, bo song jol ajehng a nkal ewe, bo bahke fere jol ngubjing anyehng. ");
INSERT INTO eka_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nnenlum a nkal ewe, bo jolo ebun ebun jol ndon joom fili bo. ");
INSERT INTO eka_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Go ellong enyam ekulugbe bi Jehova Esowo limi no, nnyo nyi ga wake sehnge bo kpee. Nnyo kehm bungu tong nnenkal re, <<Anv, Esowo lˈlohko bung re, <Kana li nkab eti go eti ajehng ajehng go etahnggaa?>>> ");
INSERT INTO eka_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nnenkal kehm faange nnyo nyio re, <<Akab nti nya li etahngga e bahke ma li, ");
INSERT INTO eka_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","wo Esowo bungu re, <Kana tiki li nkab go eti ji yim go elka ni etahngga, jol kana lak abo, tohko jol ano ḿ bahke kpoko.>>> ");
INSERT INTO eka_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nnyo nyio kehm tongo nnenkal re, <<Ń nehm lohko kpoe.>> ");
INSERT INTO eka_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","<<Esowo kpˈkahne re ń lˈli, amahr enyahne bahke lennge ḿ bahke kahne ana Esowo, ḿ bahke kahne ji kpˈnobo, a ji kpˈsabe.>> ");
INSERT INTO eka_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Eji nnenkal nyehne re nkab eti nyio ebfuumu go amahr, fere nˈnob ellehke, fvfo bahke kake nne ngbere, á kehm bongo li fere song ka nlum no jolo a ne, á tob li. ");
INSERT INTO eka_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Owo amahr ebo kehm lennge, bo soro liingi elbo re bo li ebun ebun; bo kehm banne abahmbahm efik kanne kpee ko bobo bulu elbo. ");
INSERT INTO eka_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Owo nnenlum a nkal ewe kehm wuku erehm eljen akpade ni Jehova Esowo go etahngga ngare nyi edi ma naange, bo be biiri nti nyi jolo etahngga. ");
INSERT INTO eka_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Jehova Esowo kehm lungu nnenlum re, <<Wo nona?>> ");
INSERT INTO eka_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Á kehm faange re, <<Nyehn me ga, eji n wuk-a no á kpˈbake go etahngga, n jo fˈfahl, tibre n jolo ebun ebun, n kehm beke biiri.>> ");
INSERT INTO eka_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Esowo kehm bungu re, <<Nne awo tong-a re a li ebun ebun? Wobli nkab eti go eti ji n ka-a ejehke re wo kˈlia?>> ");
INSERT INTO eka_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nnenlum kehm faange re, <<Nnenkal no a ka-m no re á jol aname, ye wo ka-m nkab eti nyi lohng eti jio, owo li no.>> ");
INSERT INTO eka_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Jehova Esowo kehm tongo nnenkal re, <<Ejum ajii a ma lim a?>> Nnenkal kehm bungu re, <<Nnyo nyi ma-m nehm, m ma li.>> ");
INSERT INTO eka_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Owo Jehova Esowo kehm tongo nnyo re, <<Tib eji a ma lim ana, <<Nkuk a na go nllong atohkondi kpee, a enyam ekulugbe kpee, a bahke jo tohng ala go ndi, fere jo li ebtohko ndi afung nya a bahke jolo go elkpin. ");
INSERT INTO eka_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","M bahke limi ń jol go ekv atemtem, wo a nnenkal, m bahke tob lim abon eba, a ba be jol go ekv, mmon ewe no nlum bahk-a wake esi, wo bahk-e kehre eselsel.>> ");
INSERT INTO eka_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Eji nnenkal á tong-e re, <<M bahke limi jo sahb yam-a yam a lˈkehme abon jel, a bahke jo jel abon ano a elyame elyame nio. Ekor eja kpee bahke jolo ka nnenlum, ye wo bahke jo fil-a.>> ");
INSERT INTO eka_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Go eyaame ji Adam, á tong-e re, <<Tib eji a wuku nkal ewa taame li nkab eti, go eti ji n ka-n erehke re <Kana tiki lio.> <<Ndi ebbel nkuk tib esi eja; a bahke jo lim eltum sahb riid-a riidi kehm jo bel li go afung nya a bahke jolo go elkpin. ");
INSERT INTO eka_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ndi bahke jo mahng ajoongo, a abarembv ka-a, a bahke jo li akab nti, a anyane go ekulugbe. ");
INSERT INTO eka_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","A bahke jo lim eltum yehke nwuuru kehm jo li, tete a kpo feere yel ndi, tibre n ko ndi lim-a; Wo, bo ko ndi lim-a, fvfo a bahke feere yel ndi nyi a lohng no.>> ");
INSERT INTO eka_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam kehm gungu nkal ewe mbing re Iv, tibre ye wo bahke jolo nnyehn no ane kpee. ");
INSERT INTO eka_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Owo Jehova Esowo kehm koko agunyam jamme nsol ka Adam abola Iv nkal ewe, bulu bo. ");
INSERT INTO eka_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Jehova Esowo kehm bungu re, <<Anv nne ebjol ana wahr, yebkahn ji kpˈnobo, a ji kpˈsabe. Wahr ki-e nongo a kpe song bong nkab eti go eti jio ji elkpin li, fere sa kpin nkahlkahl.>> ");
INSERT INTO eka_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Owo Jehova Esowo kehm-e kame yehke o etahngga jio ji Eden re á song, song lim eltum go ndi nyi á lohng no. ");
INSERT INTO eka_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Eji Esowo kame nne yehke etahngga, á kehm bumu enjel nyi bo kpo lung-e Serubim go ejang ero nfam bi etahngga ji Eden, a ekahngkahng bi jo fokko enyahng enyahng jo se agun, baabe mbang nyi li rehng go eti ji elkpin. ");
INSERT INTO eka_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Owo Adam kehm noongo a Iv nkal ewe á kehm sake ela. Eji ngare rehnge no, á kehm soro jel Ken. Iv kehm bungu re, <<Go ekakebo ji Jehova, me n jel nnenlum.>> ");
INSERT INTO eka_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Eji ma kang a, á kehm kpe jel etoono mmon no nlum, kehm-e gungu mbing re, Ebel. Ebel jolo nne no jo le ebul, Ken jolo mbahmgbe. ");
INSERT INTO eka_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Efung abehng eji nkpake egbe ma rehng, Ken kehm koko nsol mbahmandi enye re á ba lim njom ka Jehova. ");
INSERT INTO eka_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel kehm tob jak atingi agbokombang ebul re á tob ba lim njom ka Jehova. Jehova bele eyebatahng a Ebel a njom enye, ");
INSERT INTO eka_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","a belem eyebatahng a Ken a njom enye. Owo Ken eltim kehm-e sahb rˈrak, á fere go guunu. ");
INSERT INTO eka_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Jehova kehm bahbe Ken re, <<Jenji wahnge eltim kp-a rake ano? Nˈnan a kpˈguunu? ");
INSERT INTO eka_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","A lˈlim ji kpˈnobo, bo wa nehm koa? A tohko fere lim ji kpˈnobo, kunu ekpu, tibre abiafem yim na yim rib rib go ga mbutahk kp-a siki, re boba, a bahke ma ga abiafem nyao. ");
INSERT INTO eka_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ken kehm tongo Ebel mmonannyehn re, <<Wahr tahm ekulee.>> Eji bo jolo go ekulugbe, Ken kehm noko a Ebel mmonannyehn wul-e. ");
INSERT INTO eka_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Owo Jehova kehm bahbe Ken re, <<Mmonanne Ebel mee?>> Á kehm faange re, <<Me n nehme kahn. Anv, me wo kpo kpur mmonaneea?>> ");
INSERT INTO eka_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Jehova kehm bahbe re, <<Jenji a ma lim? Wuungu atung! Alung mmonanne kpˈlingi tob-m go atahng ndi. ");
INSERT INTO eka_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nkuk a na. M ma-a kam go ndi nyio nyi lennge nnyo wo alung mmonanne go ega ebo. ");
INSERT INTO eka_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","A lˈlim eltum, ndi nehm kpe jo lak nsol gbˈgbal ka-a. A bahke jolo nne no ki kpi ekehnge go njini nyia, a bahke fere jo yannge na yannge adi adi.>> ");
INSERT INTO eka_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ken kehm bungu tong Jehova re, <<Erem ebame ebgbal sehng ana m bahke ma sol.>> ");
INSERT INTO eka_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lela a ma-m kam yehke go ndi, m bahke jo biiri go ega esamahr. A ma-m lim re me n jo yannge na yannge, kˈbel erekekv. Nne awohng awohng no nyehn-m no, bahk-m wulu. ");
INSERT INTO eka_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Jehova kehm-e faange re, <<Bo wa nehm wul, tibre nne awohng awohng no wul-a no, m bahk-e bongo nkpel esehma.>> Owo Jehova kehm kake Ken elliingi, eji nne awohng awohng no lˈnyehn-e, á lˈki-e wul. ");
INSERT INTO eka_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ken kehm soro mehl lohng esamahr ni Jehova, fere song lene go ndi nyi Nod, go ero nfam nyio nyi Eden. ");
INSERT INTO eka_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Owo Ken kehm noonga nkal ewe, á soro sa ela jel Enok. Ngare nyio Ken jo si ejahbe, á koo mbing a mmon ewe Enok gungu ejahbe. ");
INSERT INTO eka_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok wo jolo nde no Irad, Irad jol nde no Mehujael, Mehujael jol nde no Metusael, Metusael jol nde no Lamek. ");
INSERT INTO eka_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek baange akal abal. Awohng bo jo lung-e re, Ada, noko Jila. ");
INSERT INTO eka_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada jele mmon no nlum no bo jo lung-e re Jabal; Ye wo jolo ngbokambang nne no jo lene go nkpatahk, jo le atohkondi. ");
INSERT INTO eka_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Mmonannyehn no nlum bo jo lung-e re Jubal. Ye wo jolo ngbokambanga nne no kub ebuk, fere jo wor efiri. ");
INSERT INTO eka_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Jila ji jolo nfahb no Ada, jele Tubal Ken. Ye wo gbo mbang jo tahl ajoobo akuungu, a abilikpi. Mmonannyehn Tubal Ken no nkal bo jo lung-e re Naama. ");
INSERT INTO eka_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek kehm tongo akal ebe, Ada abola Jila re, wuung-m wahn atung nobnob, wahn akal ba Lamek, wahn wuk-m. Me n wul nne no ba kehme elnoko aname, njankun nyi lim-m nsol. ");
INSERT INTO eka_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Lˈjol re nne no wulu Ken, bo bahk-e bongo nkpel esehma, Noo nne no lˈwul Lamek bo bahke bongo nkpel atahl ara a nkpel elku ebal. ");
INSERT INTO eka_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Owo Adam kehm kpe noongo a nkal ewe, á kehm kpe jel mmon no nlum. Iv gung-e mbing re Set. Tibre Iv bungu re, <<Esowo ma-m ka mmon no nlum, enyo ji Ebel ji Ken wul-e no. ");
INSERT INTO eka_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set tob bele mmon no nlum, á gung-e mbing re Enos. Ngare nyio o wo, ane kehme ellungu mbinga Jehova nyi li saang go elkake. ");
INSERT INTO eka_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","A wo li etoora nnyo mi bo yeele bade etˈtohngo ji Adam. Eji Esowo limi nne, á lim-e go elfoongo ni Esowo. ");
INSERT INTO eka_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Á limi bo nnenlum, a nnenkal, kehm fuulu bo, fere lung bo re, <<Nne.>> ");
INSERT INTO eka_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam kange nnya atahl arakera a nnya ewubu, kehm jele mmon no foong-e no, kehm-e gungu mbing re Seti. ");
INSERT INTO eka_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Eji bo ma jel Set, Adam kpe kang nnya atahltahl nkpel ebal, fere kpe jel abon ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Aya kpee nya Adam kange no jolo nnya atahltahl nkpel ebal a nnya atahl arakera a nnya ewubu, kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Eji Set ma kang nnya atahl alon a nnya elon, á kehm jele Enos mmon ewe no nlum. ");
INSERT INTO eka_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Eji bo jele Enos, Set kpe kang nnya atahltahl nkpel ebal a nnya esehma, kpe jel abon ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Aya kpee nya Set kange no jolo nnya atahltahl nkpel ebal nnya atahl alon, a nnya ewubbal, kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos kange nnya atahl ani a nnya ewubu, kehm jele Kenan, mmon ewe no nlum. ");
INSERT INTO eka_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Eji bo jele Kenan, Enos kpe kang nnya atahltahl nkpel ebal a nnya elku, fere kpe jel abon ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Aya kpee nya Enos kange no jolo nnya atahltahl nkpel ebal, a nnya atahl alon, a nnya elon, kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Eji Kenan kange nnya atahl ara, a nnya ewubu, á kehm jele Mahalalel mmon ewe no nlum. ");
INSERT INTO eka_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Eji Kenan ma jel Mahalalel, á kpe kang nnya atahltahl nkpel ebal, a nnya atahl abal, fere kpe jel abon ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Aya kpee nya Kenan kange no jolo nnya atahltahl nkpel ebal, a nnya atahl alon a nnya ewubu, kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Eji Mahalalel ma kang nnya atahl ara a nnya elon, á kehm jele Jared mmon ewe no nlum. ");
INSERT INTO eka_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Eji Mahalalel ma jel Jared á kpe kang nnya atahltahl nkpel ebal a eltahl a nnya ewubu, fere jel abon ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Aya kpee nya Mahalalel kange no jolo nnya atahltahl nkpel ebal a nnya atahl ani, a nnya elku, kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Eji Jared ma kang nnya atahl anehkeni, a nnya ebal, á kehm jele Enok mmon ewe no nlum. ");
INSERT INTO eka_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Eji Jared ma jel Enok, á kpe kang nnya atahltahl nkpe ebal, fere kpe jel abon ba nlum, a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Aya kpee nya Jared kange no jolo nnya atahltahk nkpel ebal, a nnya atahl anehkeni, a nnya ebal, kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Eji Enok ma kang nnya atahl ara, a nnya elon, á kehm jele Metusela mmon ewe no nlum. ");
INSERT INTO eka_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Eji Enok ma jel Metusela, á bele eljini ni jo kor Esowo go nnya atahlku, fere kpe jel abon ba nlum, a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Aya kpee nya Enok kange no jolo nnya atahlku, nnya atahl ara, a nnya elon. ");
INSERT INTO eka_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok bele eljini ni jo kor Esowo. Esowo rod-e tahm a ne, á kpeem jol, tibre Esowo rod-e tahm a ne. ");
INSERT INTO eka_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela kange nnya atahl asehmwubu, a nnya esehma, kehm jele Lamek, mmon ewe no nlum. ");
INSERT INTO eka_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Eji Metusela ma jel Lamek, á kpe kang nnya atahltahl atahlku a nnya atahl ani, a nnya ebal, fere kpe jel abon ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Aya kpee nya Metusela kange no jolo nnya atahltahl nkpel ebal, a nnya atahl anehkeni a nnya esehmwubu, kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Eji Lamek ma kang nnya atahl asehmwubu, a nnya ebal kehm jele mmon no nlum. ");
INSERT INTO eka_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek gung-e mbing re Noa, kehm bungu re, <<Ye wo bahk-r kake eltim go ejahkjahk eltum ni e kpˈlimi egahre abo go ndi nyi Jehova ma su.>> ");
INSERT INTO eka_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Eji Lamek ma jel Noa, á kpe kang nnya atahltahl, a nnya atahl asehmwubu, a nnya elku, fere kpe jel abon ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Aya kpee nya Lamek kange no jolo nnya atahltahl, a nnya atahlku a nnya atahl ara a nnya elku ebal, kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ngare nyi Noa kange nnya atahltahl atahl alon, á jele abon ba nlum na ara. Abing ebo nya a; Sem, Ham, a Jafed. ");
INSERT INTO eka_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Eji aneblum kehme elnyabe go njini, bo fere jo jel abon ba nkal ka bo. ");
INSERT INTO eka_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Abon ba nlum ba Esowo nyehne kan re anebkal ebjol anebe ano, bo kehm kehme akal baange ana koro bo. ");
INSERT INTO eka_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Owo Jehova kehm bungu re, <<Elv ename ni kpi elkpin nehm kpe jol atahng nne, go njinanjini, tibre nne lohko li na ngubjing nyi kpo kpo, afung elkpin nya nne, nehm kpe jo sehnge nnya atahl arakera.>> ");
INSERT INTO eka_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Agbungulu ane jolo njini ba bo jo lung re Nefilim, bomo ngare nyio asongo, eji abon ba nlum ba Esowo jo noongo a anebkal ba ane, bo jel abon ka bo, bo jolo atakuru nya mahne mahne nya bele elgahm. ");
INSERT INTO eka_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Jehova kehm nyehne re abˈbi nya ane jo lim ebgbal sehng go njini, fere kahn re ntir nyi nne go ge eltim abˈbi abˈbi nya ngare anyehng anyehng. ");
INSERT INTO eka_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Jehova yame go eltim sehng re yeblim nne go njini. Ejum jia yame Esowo sehng. ");
INSERT INTO eka_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Owo Jehova kehm bungu re, <<M bahke feenge ane kpee ba m ma lim. M bahke tob feenge enyam kpee, a ejum ajehng ajehng ji kpo tohng ala go ndi, a nruk nyi kpo fonngo go ero, tibre ma-m yam sehng re me n tohko lˈlim bo.>> ");
INSERT INTO eka_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Wo Noa limi ji jo kor Esowo. ");
INSERT INTO eka_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","A wo li ntoora nnyo mi li bada Noa. Noa jolo etingitingi nne, ebi ajehng ajehng á limem go ane ba jolo go egea ngare. Á bele eljini ni jo kor Esowo. ");
INSERT INTO eka_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa bele abon ba nlum na ara: ngbokambang bo jo lung-e re Sem, etoono Ham, a Jafed. ");
INSERT INTO eka_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ngare nyio njini jolo abˈbi abˈbi go esamahr Esowo, atongtong jolo edi ajehng ajehng. ");
INSERT INTO eka_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Esowo kehm seenge nyehn ana njini ma rannge, tibre ane kpee ba jolo go njini rˈrannge abang ebo. ");
INSERT INTO eka_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Owo Esowo kehm bungu tong Noa re, m bahke feenge ane kpee, tibre boblim atongtong ebgbal sehng go njini. Etingitingi m bahke feenge bo, fere tane njini. ");
INSERT INTO eka_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ko eti ji bo kpo lung re sipress, wo kono egbang bi nlen, kak akimi, lim jol sahd sahd wo ko nnyake elak roongo go atahng a alatahk. ");
INSERT INTO eka_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ana wo a bahke sehke egbang: Alab egbang bahke jolo erula atahltahl erula atahl abal, erula ebwubu, akpang enye bahke jolo, erula atahl ara, erula elku, elwahre bahke jolo erula atahl abal erula eblon. ");
INSERT INTO eka_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Lim elbulu ene, yake edi jo foong, bomo nkahl egbang rehng elbulu, jol ejum erula ajehng kunu esi, kak mbutahk go nkpe egbang, wo lim nkpake era go atahng, nyi li reed, a etoono, a nyi kpˈwahre. ");
INSERT INTO eka_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","M bahke koko nnyel ba bulu njini nyia kpee nyi bahke rannge ejum ajehng ajehng ji li go elkpin. Ejum ajehng ajehng go njini bahke kpoko. ");
INSERT INTO eka_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","M bahke limi egbanngalung ejame a na. A bahke yele egbang bia a abon eba ba nlum, a nkal ewa, a akal abon eba. ");
INSERT INTO eka_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","A bahke koko ejum ajehng ajehng ji li go elkpin, nlum, a nkal, bo ba woomo a na go egbang. Eji bo lˈkˈkpo. ");
INSERT INTO eka_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Elkohn ebruk abehng abehng, a nnyam anyehng anyehng, nkal a nlum, a ejum ajehng ajehng ji kpo tohng go ndi, bo bahke bake a bum bo go elkpin. ");
INSERT INTO eka_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ko nsol ellehke anyehng anyehng nyi ḿ bahke jo li, wo kuuru go egbang, eji ḿ bahke jo li a enyam enyam bio. ");
INSERT INTO eka_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ano wo Noa limi ejum ajehng ajehng ana Esowo tong-e no. ");
INSERT INTO eka_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Jehova kehm tongo Noa re, <<Mehl wo song yel egbang, wo a ebangenahb eja kpee, tibre me n kahn re, wo wo li etingi nne go eying jia ");
INSERT INTO eka_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Rod enyam bi li saang esamahr Esowo, enyam esehma esehma, nlum a nkal, a elkohn enyam bi ki li saang esamahr Esowo, enyam ebal ebal, nlum a nkal, ");
INSERT INTO eka_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","tob ko ajoobo nruk esehma esehma, nlum a nkal, kpur bo bo jol elkpin, eji bo lˈjel behnjehle go njini. ");
INSERT INTO eka_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Bomo anv asongo, lˈrehng nfung esehma, m bahke tumu elahb tv ndi, bahke nake nfung atahl abal, atv atahl abal, m bahke rannge ejum ajehng ajehng ji li go elkpin, ji n limi no bum go njini.>> ");
INSERT INTO eka_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa limi ejum ajehng ajehng ji Jehova tong-e no. ");
INSERT INTO eka_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa kange nnya atahltahl a nnya atahl awubu ngare nyi nnyel ba go njini. ");
INSERT INTO eka_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Owo Noa a abon ebe ba nlum, nkal ewe, go akal abon ebe kehm yele egbang re bo tahre elbo go nnyel nyio. ");
INSERT INTO eka_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Enyam bi jolo saang esamahr Esowo, a bi ki jol saang esamahr Esowo, nkal a nlum, nkal a nlum, nruk a ajoobo enyam bi kpo tohng ala go ndi, ");
INSERT INTO eka_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","nlum a nkal, kehm bake goji Noa ba yel egbang, ana Esowo kaa Noa ejehke. ");
INSERT INTO eka_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Eji ma sehng nfung esehma, nnyel kehm bake go njini. ");
INSERT INTO eka_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Go elku a nfung ebal mi etoono nnyahng, elya ni Noa kpˈrehnge nnya atahltahl a nnya atahl awubu, efung bˈnehm o bi abˈbehl alahb nya atahng ndi bohngo lohng, abuk alahb nya elbung lennge. ");
INSERT INTO eka_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Elahb kehm nake nfung atahl abal, a atv atahl abal. ");
INSERT INTO eka_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Efung bˈnehm o bi Noa a abon ebe ba nlum, Sem, Ham, a Jafed, a nkal ewe, akal abon ebe na ara mehle yel egbang. ");
INSERT INTO eka_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ajoobo enyam nkohnankohn woomo a bo o egbang ana ajoobo atohkondi go nkohnankohn, a ajoobo enyam bi kpo tohng ala go ndi, a ajoobo nrur go nkohnankohn, go ejum ajehng ajehng ji kpi akpungkpung. ");
INSERT INTO eka_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ejum ajehng ajehng ji kpi elkpin, nlum a nkal, ba goji Noa ba yel go egbang. ");
INSERT INTO eka_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ana wo jolo no, ejum ajehng ajehng ji kpi elkpin nlum a nkal, yele go egbang ana Esowo kaa Noa ejehke. Owo Jehova kehm bame bo tv. ");
INSERT INTO eka_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Go nfung atahl abal nnyel kehm kpe jo yel na budu go ndi, ana alahb jo yel ano wo jo mehl egbang bio go ndi wahre. ");
INSERT INTO eka_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Alahb kehm sahb yˈyel, egbang jo fuungu go ero alahb. ");
INSERT INTO eka_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Alahb soro asi jo yel bulu awahre wahre awong kpee go ndi. ");
INSERT INTO eka_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Alahb yele bulu awong nya sahb wˈwahre, kpe wahre na sehnge erula eltahl. ");
INSERT INTO eka_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ejum ajehng ajehng ji jolo go elkpin, ji kpo jen ndi rannge kpee, nruk, atohkondi, enyam ekulugbe, a anyam nyame kpee nya kpo fonngo go elbung, a ane ane kpee. ");
INSERT INTO eka_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ejum ajehng ajehng ji kpo v elv, ji jolo egbuk, kpo kpee. ");
INSERT INTO eka_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ejum ajehng ajehng ji jolo go elkpin rannge kpee go ndi, ane, enyam, a ejum ajehng ajehng ji kpo tohng ala go ndi, nruk nyi kpo fonngo go ero, rannge bo kpee. Noa ntahng ntahng wo sa, a ane ba woomo a ne go egbang. ");
INSERT INTO eka_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nnyel bulu ndi kpee go nfung atahl asehma a nfung ewubu. ");
INSERT INTO eka_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Owo Esowo kehm buumu Noa, a enyam ekulugbe bi woomo a ne go egbang, a atohkondi atohkondi. Á kehm tumu elfeb tv go njini, nnyel alahb kehm kehme elrede. ");
INSERT INTO eka_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Abˈbehl alahb nya jolo go atahng ndi, a abuk alahb nya ya no go elbung sˈsahd, elahb tob rahke elnake. ");
INSERT INTO eka_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Owo alahb ma yele bulu njini kehm kehme elrede, eji ma kang nfung atahl asehma a nfung ewubu alahb ebsahb rˈrede. ");
INSERT INTO eka_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Go elku a nfung ebal nyi nnyahng esehma, egbang kehm ba kuumu go agburu awong nya Ararad. ");
INSERT INTO eka_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Alahb soro na asi jo rede tete rehng nnyahng ewubu, go ngbokambang efung bi nnyahng ewubu aro awong kehme ellohngo. ");
INSERT INTO eka_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Eji ma kang nfung atahl abal, Noa kehm lennge ewindu go egbang bi a limi no, ");
INSERT INTO eka_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kehm tumu nyakenyake mbare emel ebruk bi jo fonngo yannge na yannge tete alahb ka go ndi kpee. ");
INSERT INTO eka_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Á kehm tumu ebbehl re á song kpur joare alahb ebka mal go ndi. ");
INSERT INTO eka_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Jol ebbehl belem na edi ji á bahke ma kuumu, tibre alahb bulu ndi kpee, owo ebbehl kehm feere goji Noa egbang, Noa kehm tanne ebo ebe, ana ebbehl kuum-e go ebo á feere a ne kak go egbang. ");
INSERT INTO eka_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Kpe kang kan nfung esehma, á kehm kpe yehke ebbehl tum. ");
INSERT INTO eka_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Eji ebbehl feere no ba ngare elgung, á ko elyane oliv ni mbir mbir go ege a nnyo, ba a ni. Noa kehm kahne re alahb ebsahb rˈrede go ndi. ");
INSERT INTO eka_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Eji ma kpe kang nfung esehma yehko, á kpe tum ebbehl, wo esennge jia ebbehl kpeem feere goji Noa. ");
INSERT INTO eka_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Go ngbokambang efung bi ngbokambang a nnyahng, eji Noa ma kang nnya atahltahl, atahl awubu a elya anehng, ngare nyia alahb ebka go ndi, owo Noa kehm laade elkong egbang kehm seenge nyehn re ndi ebwum. ");
INSERT INTO eka_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Go eltahl a nfung esehma go etoono nnyahng ndi gohro wum kpee. ");
INSERT INTO eka_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Owo Esowo kehm bungu tong Noa re, ");
INSERT INTO eka_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","<<Lohng go egbang, wo a nkal ewa, a abon eba, go akal abon eba. ");
INSERT INTO eka_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Yehke elkohn ejum ajehng ajehng go egbang ji li go elkpin, nrur, enyam, a nsol kpee nyi kpo tohng ala go ndi, eji bo lˈjel sahb rˈrur go njini. ");
INSERT INTO eka_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Owo Noa kehm lohngo go egbang, a nkal ewe, a abon ebe, go akal abon ebe. ");
INSERT INTO eka_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Enyam kpee, a nsol kpee nyi kpo tohng ala go ndi, a nruk kpee, go ejum ajehng ajehng ji kpo jen go ndi, bo kehm jo lohng go egbang nkohnakohn. ");
INSERT INTO eka_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Owo Noa kehm limi egudu njom alimi ka Jehova. Go ellong enyam, a nruk kpee nyi jolo saang ka Esowo, Noa yehke nyandiki, ko lim njom nyi eljahme fi ka Jehova, egudu njom jio. ");
INSERT INTO eka_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Jehova njom nyio kehme vohko esvsv eleenge, á kehm bungu go ege eltim re, <<N nehm kpe tiki su ndi tib esi ji nne, jol eji li li re ntir anyehng anyehng nyi nne go ge eltim tiki li ebi ntir, bomo ese ese. N nehm kpe tiki rannge nsol nyi li go elkpin kpee ana m ma lim a. ");
INSERT INTO eka_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","<<Ana ndi tik kpe li, ngare elbahme a ngare elkpake, ngare alohk a ngare ewannge, elum a nnale, afung, a atv.>> ");
INSERT INTO eka_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Esowo kehm fuulu Noa, a abon ebe fere tong bo re, <<Jelen, wahn gbal, nyab rur go njini. ");
INSERT INTO eka_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Enyam kpee bi li go njini bahke jo fahl-n fahl, ń fere jo mennge bo, fvfo nruk nyi kpo fonngo go ero, a ejum ajehng ajehng ji kpo tohng ala go ndi, a nsahre kpee nyi wob alahb. Nsol nyia kpee me nfaake kak-n go abo. ");
INSERT INTO eka_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ejum ajehng ajehng ji kpi elkpin, ji kpo jen go ndi ma-n ka re jol nsol alehke enyahne. Ana n ka-n nsol nyi lohng go nti, a ajele, ana nsol alehke, ano wo m ma-n tob ka ejum ajehng ajehng anv. ");
INSERT INTO eka_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","<<Ka tiki li nnyam a alung eme go atahng, alung ma li elkpin ene. ");
INSERT INTO eka_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","M bahke bahbe alung ema, alung ma elkpin ena abo ejum ajehng ajehng ji wul-a no. M bahke tob bahb go abo nya nnyam anyehng anyehng nyi wul-a no, m bahke bahbe alung go abo nne no wulu nne noko. ");
INSERT INTO eka_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","<<Nne no lˈwul nne, nne bahke tob wul-e, tibre Esowo limi nne go ege elfoongo. ");
INSERT INTO eka_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ka wahn, jelen, wahn rur go nfange, wahn sahb nyˈnyab go njini.>> ");
INSERT INTO eka_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Esowo kehm bungu tong Noa a abon ebe re; ");
INSERT INTO eka_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","<<Anv n kpˈlimi agbanngalung ejame a na, a etˈtohngo eja ji kpa-a toono, ");
INSERT INTO eka_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","a nsol kpee nyi li elkpin nyi jolo a na, nruk, atohkondi, a enyam ekulugbe, bo kpee ji lohngo go egbang a na, a ejum ajehng ajehng ji li go elkpin go njini. ");
INSERT INTO eka_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Me n lim egbanngalung a nahne: Nnyel nehm kpe tiki jol nyi bahke tane elkpin ejum ajehng ajehng ji li go elkpin, jol elkohn nnyel ana nyio nehm kpe tiki jol nyi bahke rannge njini.>> ");
INSERT INTO eka_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Esowo kehm bung re, <<A wo li elliingi ni egbannalung ji n kpˈlimi me a na, a ejum ajehng ajehng ji li go elkpin a na, egbanngalung jia bahke jolo ano ano ka aying nya kpˈbake: ");
INSERT INTO eka_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Me n bum ebangenjok go akparesemsem, ji ji bahke jolo elliingi ni egbanngalung ka-m a njini. ");
INSERT INTO eka_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ngare anyehng anyehng nyi akparesemsem lˈlohng go elbung, ebangenjok fere lohng go akparesemsem, ");
INSERT INTO eka_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","m bahke buumu egbannalung ejame ji n limi a na, a ejum ajehng ajehng ji li go elkpin. Alahb nehm kpe tiki yel rannge nsol kpee nyi li elkpin. ");
INSERT INTO eka_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ngare anyehng anyehng nyi ebangenjok lˈsi lˈlohng go akparesemsem, m bahke nyehne fere buumu egbanngalung ejame ji n limi no a ejum ajehng ajehng ji li go elkpin go njini, egbanngalung ejame li nkahlkahl. ");
INSERT INTO eka_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Esowo kehm tongo Noa re, <<Ebangenjok jio ji li elliingi ni egbanngalung ejame ji m ma lim a ejum ajehng ajehng ji li go elkpin go njini.>> ");
INSERT INTO eka_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Abone Noa ba lohngo go egbang, jolo Sem, Ham, go Jafed. Ham wo jolo nde no Kenan. ");
INSERT INTO eka_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Abon ara ba Noa ba a. Ane kpee ba ma rur go njini, lohng goji bo. ");
INSERT INTO eka_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa bahme egbe agreb, á kehm tahme song bahm etahngga avain. ");
INSERT INTO eka_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Eji á wo amahm agreb, á kehm soro gbo njok, song noongo go ege mmobkpatahk ebun ebun. ");
INSERT INTO eka_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham ji jolo nde no Kenan kehm song nyehn nde nong ebun ebun, kehm lohngo ba tong abonanyehn abal ga alatahk. ");
INSERT INTO eka_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Owo Sem abola Jafed kehm rodo ekpawobo konngo elbo go akpakebahk, fere jo jen njahm njahm song yake ekpawobo jio bulu nde abo, bo jo seenge go nkpe, bo sebem re bo nyehn ana nde bo nong ebun ebun. ");
INSERT INTO eka_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Eji Noa nyahme no go ellu amahm, fere seb kahn ji nkalla mmon ewe ma lim tob-e, ");
INSERT INTO eka_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","á kehm bungu re, <<Elsu li ka Kenan, á bahke jolo nju nyi sahb rˈrede ka abonanyehn.>> ");
INSERT INTO eka_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Á kpe bung re, <<Elfuulu jol ka Jehova, ye ji li Esowo bi Sem, nong Kenan jol eju ka Sem. ");
INSERT INTO eka_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nong Esowo lim Jafed á nyange, nong Jafed lene go nkpatahk nyi Sem, nong Kenan jol eju ka-e.>> ");
INSERT INTO eka_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Eji nnyel ma sehng, Noa kange nnya atahlku, a nnya atahl abal a nnya ewubu. ");
INSERT INTO eka_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nnya kpee nyi Noa kange no jolo nnya atahltahl nkpel ebal, nnya atahl asehma a nnya ewubu, kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","A wo li ntoora nnyo mi li bade abone Noa ba nlum, Sem, Ham, a Jafed. Bofono tob jele abon ngare nyi nnyel ma sehng. ");
INSERT INTO eka_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Abon ba nlum ba Jafed ba a: Goma, Magog, Madayi, Javan, Tubal, Mesek, go Tiras. ");
INSERT INTO eka_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Abon ba nlum ba Goma ba a: Askenas, Rifad, a Togama. ");
INSERT INTO eka_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Abon ba nlum ba Javan ba a: Elisa, Tarsis, go anebe Kitim, go anebe Rodan. ");
INSERT INTO eka_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","E bo atˈtohngo wo ane ba lene nkpe alahb nkpe alahb lohng no, yaame ni ellong song kak elsi nˈne, a elatahkgur jˈje, a ejahbe jˈje, a nfam a nfam ebo. ");
INSERT INTO eka_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Abon ba nlum ba Ham ba a: Kus, Mijraim, Pud, go Kenan. ");
INSERT INTO eka_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Abon ba nlum ba Kus ba a: Seba, Havila, Sabta, Raama, go Sabteka. Abon ba nlum ba Raama ba a: Seba abola Dedan. ");
INSERT INTO eka_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus wo jolo nde no Nimrod, ji gbale jol egburu ntakuru a nne go njini. ");
INSERT INTO eka_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Á jolo egburu egbaji ebim go esamahr bi Jehova, owo wahnge bo jo bung re, <<Ana Nimrod, ji jolo egburu mbimi ebim go esamahr Jehova.>> ");
INSERT INTO eka_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Agbokambanga aji etul nya Nimrod kake no jolo Babilon, Erek, Akad, a Kalne ji jolo go Sinar. ");
INSERT INTO eka_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrod lohngo o ndi nyio fere song lene go Asiria, owo á kpe song kak nsi nyehko nyi Nineve, Rehobod Ir, Kala, ");
INSERT INTO eka_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","go Resen ji jolo elka elka ni Nineve abola Kala ji jolo egburu ejahbe. ");
INSERT INTO eka_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mijraim wo jolo nde no anebe Lud, a anebe Anam, a anebe Lehab, a anebe Nabtu, ");
INSERT INTO eka_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","a anebe Patrus, a anebe Kashlu (a wo anebe Filistia lohng no) a anebe Kabto. ");
INSERT INTO eka_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenan wo jolo nde no Sidon, Sidon wo jolo ngbokambang mmon ewe no nlum. Kenan tob jolo nde no anebe Hid. ");
INSERT INTO eka_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Anebe Jebus, anebe Amor, anebe Girgasa, ");
INSERT INTO eka_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","anebe Hiv, anebe Ark, anebe Sin, ");
INSERT INTO eka_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","anebe Arvad, anebe Jemar, a anebe Hamad. Eji ma kang, anebe Kenan kehm nyange, ");
INSERT INTO eka_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","nkonandi nyi Kenan bomo go Sidon asongo go Gerar, tete rehng go Gaja, sehng o rehng go Sodom, Gomora, Adma, Jeboyim tete rehng Lasa. ");
INSERT INTO eka_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","A wo li abon ba nlum ba Ham. Ana wo bo jolo no song kak elsi ni bo, a elatahkgur nya bo, a ejahbe ji bo, a nfam a nfam ebo. ");
INSERT INTO eka_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem ji jolo mmonannyehna Jafed no nkul tob jele abon ba nlum. Sem wo jolo nde nne no nkul go abon kpee ba Eber. ");
INSERT INTO eka_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Abon ba nlum ba Sem ba a: Elam, Asur, Arfasad, Lud, a Aram. ");
INSERT INTO eka_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Abon ba nlum ba Aram ba a: Uju, Hul, Geter, a Mesek. ");
INSERT INTO eka_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfasad wo jolo nde no Sela, Sela tob jol nde no Eber. ");
INSERT INTO eka_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber jele abon ba nlum abal, ngbokambang bo jo lung-e re Peleg, tibre egea ngare wo njini yabe no, mmonannyehn bo jo lung-e re Joktan. ");
INSERT INTO eka_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan wo jolo nde no Almodad, Selef, Hajarmaved, Jera, ");
INSERT INTO eka_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Ujal, Dikla, ");
INSERT INTO eka_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO eka_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, abola Jobab. Ane baa kpee jolo abon ba nlum ba Joktan. ");
INSERT INTO eka_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ejang bi bo lene no, bomo go Mesa tete song rehng go Sefar, go ejahbe ewong ji ero nfam. ");
INSERT INTO eka_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Abon ba nlum ba Sem ba a. Ana wo bo jolo no song kak elsi ni bo, a elatahkgur nya bo, a ejahbe ji bo, a nfam a nfam ebo. ");
INSERT INTO eka_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","A wo li ajahbe nya abon ba nlum ba Noa, Go ellong nia wo ajahbe yaame yel go njini kpee, ngare nyi nnyel ma sehng. ");
INSERT INTO eka_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Njini kpee bele ejahbe ajehng, jo bung elkohn ellum anehng. ");
INSERT INTO eka_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Eji ane kpee mehle jo jen asongo go ero nfam, bo kehm song nyehn edi ji li balebale go Sinar kak elsi o. ");
INSERT INTO eka_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Bo kehm bungu tong atemtem re, <<Baan, wahr koon ndi, so, fere wo go agun nˈnob.>> Bo ko abahk ndi nyao, atal bo koom, bo ko nnyakenyake elak jo lang. ");
INSERT INTO eka_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Bo kehm kpe bung re, <<Nong wahr siin ejahbe ka elnahre, fere tob si nkahmbungubungu etahk ji bahke rehnge go elbung, eji mbing enyahre lˈlohng, tohko jol ano, e bahke yaame atemtem sa rehng go nkpohka njini anyehng anyehng. ");
INSERT INTO eka_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Jehova kehm badde ba nyehn ejahbe jio, a nkahmbungubungu etahk ji ane bao jo si. ");
INSERT INTO eka_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Jehova kehm bungu re, <<Eji ane baa li ajehng, kpˈbungu ejahbejahbe ajehng ma kehme ellimi a na, jio ejumjum limm ji ane baa lˈseb re bo lim, bo lˈkˈma lim. ");
INSERT INTO eka_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Nong wahr badden song lim ejahbe ji bo kpˈbungu bil bo amahr. ");
INSERT INTO eka_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Jehova kehm limi bo, bo yaame o edi jio faade kpee go njini, fere rahke ejahbe jio go elsehke. ");
INSERT INTO eka_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Owo wahng ka bo jo lung ejahbe jio re Bebel, tibre edi jio wo Jehova limi re bil bo amahr. Edi jˈnehm o wo Jehova limi re bo yaame faade go njini kpee. ");
INSERT INTO eka_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","A wo li ntoora nnyo mi li bade etˈtohngo ji Sem. Eji ma kang nnya ebal nyi nnyel ma sehng, ngare nyia Sem ebkang nnya atahl alon, á jele mmon no nlum no bo jo lung-e re Arfasad. ");
INSERT INTO eka_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ngare nyi Sem ma jel Arfasad, á kange nnya atahltahl atahl alon, kpe jel abon bako ba nlum, a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Eji Arfasad ma kang eltahl a nnya elku, á jele Sela. ");
INSERT INTO eka_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Eji Arfasad jele Sela, á kange nnya atahltahl a nnya era. Á kpe jel abon bako ba nlum, a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Eji Sela ma kang eltahl a nnya ewubu, á kehm jele Eber. ");
INSERT INTO eka_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eji Sela ma jel Eber á kange nnya atahltahl a nnya era, kpe jel abon bako ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eji Eber ma kang eltahl a nnya ewubu a nnya eni, á kehm jele Peleg. ");
INSERT INTO eka_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eji Eber ma jel Peleg, á kange nnya atahltahl kunu eltahl a nnya ewubu, kpe jel abon bako ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Eji Peleg ma kang eltahl a nnya ewubu, á kehm jele Reu. ");
INSERT INTO eka_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Eji Peleg ma jel Reu, á kange nnya atahl awubu a nnya esehmwubu, kpe jel abo bako ba nlum, a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Eji Reu ma kang eltahl a nnya ewubu a nnya ebal, á kehm jele Serug. ");
INSERT INTO eka_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Eji Reu ma jel Serug, á kange nnya atahl awubu a nnya esehma, kpe jel abon bako ba nlum, a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Eji Serug ma kang eltahl a nnya ewubu, á kehm jele Nahor. ");
INSERT INTO eka_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Eji Serug ma jel Nahor, á kange nnya atahl awubu, kpe jel abon bako ba nlum, a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Eji Nahor ma kang eltahl a nnya esehmwubu, á kehm jele Tera. ");
INSERT INTO eka_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Eji Naho ma jel Terah, á kange nnya atahl alon a nnya elku nnya eni, á kpe jel abon bako ba nlum a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Eji Tera ma kang nnya atahl ara a nnya ewubu, á kehm jele Ebram, Nahor a Haran. ");
INSERT INTO eka_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","A wo li ntoora nnyo mi ettohngo ji Tera. Tera wo jele Ebram, Nahor a Haran. Haran wo jele Lot. ");
INSERT INTO eka_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran kpo go Ur ji li go Kaldia, edi ji bo jel-e no. Ngare nyio nde Tera kpeka li go elkpin. ");
INSERT INTO eka_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ebram abola Nahor kehm ba ko akal. Mbing nyi nkala Ebram bo jo lung-e re Sarayi, no Nahor bo jo lung-e re Milkah; Haran wo jolo nde no Milkah abola Iskah. ");
INSERT INTO eka_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi jolo ngum, mmon awohng awohng á belem. ");
INSERT INTO eka_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera kehm rodo Ebram mmon ewe, a Lot ji Haran jel-e no, ji jolo mmon no mmon ewe, go Sarayi ji jolo nkala mmon ewe Ebram, bo kpee kehm mehle o Ur ji li go Kaldia jo tahm asongo go Kenan, eji bo song rehng go edi ji bo jo lung re Haran, bo kehm sake jol o. ");
INSERT INTO eka_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nnya kpee nyi Tera kange no jolo nnya atahl awubu a nnya elon, o Haran wo á kpo no. ");
INSERT INTO eka_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Jehova tongo Ebram re, <<Lohng ega ejahbe, wo yake ane eba, fere tob yake nlaaga nyi nso, wo song, m bahk-a tibi edi ndi ji a bahke jolo. ");
INSERT INTO eka_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","<<M bahk-a koko lim egburu ejahbe, m bahk-a fuulu; m bahke limi mbing enya gbal, a bahke jolo efuulu fuulu nne ka ane bako. ");
INSERT INTO eka_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","M bahke fuulu ane ba lˈfuul-a, nne awohng awohng no lˈsua, m bahk-e tob su; wo wo bahke wahnge ane kpee ba li go njini bel elfuulu.>> ");
INSERT INTO eka_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ebram kehm tahme ana Jehova tong-e no; Lot tob tahme toon-e. Ngare nyio nyi Ebram mehle o Haran asongo yebkang nnya atahl ara a nnya elku. ");
INSERT INTO eka_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ebram rodo Sarayi nkal ewe, a Lot ji jolo nfun ewe, a nsol a nsol ebo kpee, a ane ba bo bele no go Haran tahm asongo go ndi nyi Kenan, lohko song rehng go. ");
INSERT INTO eka_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ebram jene eljen go ndi nyio tete song rehng go ejang bi egburu eti ji jolo go ejahbe ji bo jo lung re Moreh ji li kohlo Sekem. Ngare nyio anebe Kenan baa kpeka lene o. ");
INSERT INTO eka_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Jehova kehm ba kpiri Ebram, kehm-e tongo re, <<Edi ndi jia m bahke kake abon eba. Ebram kehm limi egudu njom alimi ka Jehova, ye ji lohngo ba kpir-e. ");
INSERT INTO eka_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ebram mehle o asongo go awong nya li ero nfam bio bi Betel, song si ebkpatahk ebe o. Betel jolo erede, Ai jol go ero nfam. Ona wo á limi egudu njom ji Jehova, jo lung mbing nyi Jehova. ");
INSERT INTO eka_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ebram kehm kpe tahm o tete asongo go Negev. ");
INSERT INTO eka_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ngare nyia njal jolo go ndi nyio, Ebram kehm tahme go Ijib re a tohko song jol go, tibre njal gbale sehng. ");
INSERT INTO eka_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Eji a yahke rehng go Ijib, a kehm tongo Sarayi nkal ewe re, <<N kpˈkahne re wo nne ano wo. ");
INSERT INTO eka_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Anebe Ijib lˈsi nyehn-a nyehn, bo bahke bungu re, <Nkal ewe wo a.> Bo bahk-m wulu, wo bo bahk-a yake. ");
INSERT INTO eka_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Lub bung re wo mmonannee wo, eji bo lˈki-m wul, bo lˈfil-m nob nob tib esi eja.>> ");
INSERT INTO eka_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Eji Ebram rehnge go Ijib, anebe Ijib nyehne re Sarayi gbo egbahme sehng. ");
INSERT INTO eka_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ana atubesi abalimeltum Fero nyehn-e no, bo kehm song tehke tong Fero, bo kehm-e rodo tahm a ne go ekpasiki Fero. ");
INSERT INTO eka_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Fero fili Ebram nob nob tib esi Sarayi, Ebram gbo afang bel ejoro, adahmagbudu, a ebvankang, alum a akal, a akamel go alokeltum ba nlum, a ba nkal. ");
INSERT INTO eka_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Owo Jehova kehm tubu Fero abi ayam, a nlaaga a nlaaga enye, tib esi Sarayi nkala Ebram. ");
INSERT INTO eka_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Fero kehm tumu tv Ebram re a ba. Kehm bungu re, <<Nˈnan a ma-m lim ana?>> Jenji wahnge a ki-m tong re nkal ewa wo? ");
INSERT INTO eka_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nˈnan a kehm bungu re, <Mmonanne wo,> ma wahng m me-e ko ana nkal ewame? Anv, nyehn nkal ewa a, rod-e song a ne!>> ");
INSERT INTO eka_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Fero kehm kake alokeltum ebe nsahm bade Ebram a ane ebe. Bo kehm-e song tv mbang, a nkal a nsol kpee nyi Ebram bele no. ");
INSERT INTO eka_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ebram kehm lohngo go Ijib tahm go Negev, a nkal ewe, a nsol nyi a bele no, Lod tob tahme toon-e. ");
INSERT INTO eka_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ngare nyia Ebram ebgbo afang nya atohkondi, a nya asilva, a agul. ");
INSERT INTO eka_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A mehle go Negev jo yannge adi adi, tete ba rehng go Betel, go elka elka ni Betel a Ai edi ji a tohko si ebkpatahk, ");
INSERT INTO eka_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","edi ji a gbo mbang lim egudu njom. Owo Ebram jo kak Jehova. ");
INSERT INTO eka_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ngare nyia Lod ji jo yannge toono Ebram, tob bele atohkondi, a nkpatahk. ");
INSERT INTO eka_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Atohkondi ebo nsol alehke joom kpe biingi bo, eji bo jolo edi ajehng, tibre nsol nyi bo bele no gbale sehng, wahnge bo ma-m kpe jol edi ajehng. ");
INSERT INTO eka_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ntaange kehm gboko abaabebul ba Ebram, a ba Lod. Ngare nyio anebe Kenan, a anebe Peris tob jolo ndi nyio. ");
INSERT INTO eka_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Owo Ebram kehm bungu tong Lot re, <<Nong wahr kˈtaange, jol alokeltum ebahre kˈbel nfem, tibre wahr akunu nya. ");
INSERT INTO eka_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ndi sang nong-r a kpeea? Nong wahr yab elnahre. A lˈje go ejang ebobkal, me m bahke jeke ejang eboblum; a lˈfere yehke ejang eboblum, m bahke jeke ejang ebobkal.>> ");
INSERT INTO eka_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot kehm tabe esamahr seenge, nyehn re edamme Jodan jolo alahb alahb, ana etahngga ji Jehova, tob jolo ana ndi nyi Ijib feere go ejang Joa. (Jia tohko jol Jehova kehm rannge Sodom a Gomora) ");
INSERT INTO eka_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Owo Lod kehm yehke edamme ji Jodan asongo go ero nfam. Aneblum abal baa kehm yabe elbo: ");
INSERT INTO eka_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ebram lene go ndi nyi Kenan, Lod song si nkpatahk enye kohlo Sodom, ellong ajahbe nyao nya jolo go edi ji jolo ebale ebale. ");
INSERT INTO eka_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ngare nyio anebe Sodom jolo abˈbi ane, ba jo lim abˈbi gbalee go esamahr bi Jehova. ");
INSERT INTO eka_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Eji Lod ma tahm fi, owo Jehova kehm bungu tong Ebram re, <<Tab esamahr eba edi ji a yim o, wo seenge go ejang ebobkal, a ejang eboblum, tob seenge ero nfam a erede nfam. ");
INSERT INTO eka_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","M bahk-a kake ndi nyia kpee nyi a kpˈnyehne, a etˈtohngo eja go njinanjini. ");
INSERT INTO eka_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","M bahke limi etˈtohngo eja nyab fere sahb rˈrur ana erikehndi. Lˈjol re nne bahke ma fange erikehndi, lohngo re bo bahke ma fange etˈtohngo eje. ");
INSERT INTO eka_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Mehl wo jen alab, a akpang akpang nya ndi nyia, n kpˈyake na a ka-a.>> ");
INSERT INTO eka_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Owo Ebram kehm kpudu nkpatahk enye, song kak elsi kohlo agburu nti nya li ka Mamre nya li go Hebron owo á limi egudu njom ji Jehova. ");
INSERT INTO eka_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ngare nyia Amrafel ji jolo ntul no Sinar, a Ariok ji jolo ntul no Elasa, Kedolaoma ji jolo ntul no Elam, go Tidal ji jolo ntul no Goyim, ");
INSERT INTO eka_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","bo je ebta a Bera ji jolo ntul no Sodom, a Birsa ji jolo ntul no Gomora, a Sinab ji jolo ntula Adma, Semeber ntul no Jeboyim, a ntul no Bela (Ji li Joar). ");
INSERT INTO eka_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Etoono ellong atul baa ba kono go edamme ji Sidim, ji li aya elkang. ");
INSERT INTO eka_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Go ewuba nnya ebal bo woomo elwo ni Kedolaoma, eji biingi ewuba nnya era bo yiimi etahnsi. ");
INSERT INTO eka_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Go ewuba nnya eni, Kedolaoma a atul ba kpa njahm a ne, kehm tahme ebta song nok ga anebe Refa go Asterot Karnadim, anebe Juja bo ji li go Ham, anebe Emm bo ji li go Saveh Kiriateim, ");
INSERT INTO eka_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","go anebe Hor ba jolo go ejahbe ewong ji Seir, tete song rehng go El Paran kohlo go elka emahng. ");
INSERT INTO eka_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Bo kehm feere njahm tahm go En Mishpad, ji li Kadish, bo ga bo ko ndi nyio nyi anebe Amalek kpee, a anebe Amor ba lene go Hajajon Tamar. ");
INSERT INTO eka_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Owo ntul no Sodom, a ntula Gomora, a ntul no Adma, a ntula Jeboiim, go ntula Bela, ji li Joar, kehm mehle eljen asongo song yiimi nti nti re bo nok ebta go edamme ji Sidim ");
INSERT INTO eka_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","re bo nok ebta a Kedolaoma ji ntula Elam, a Tidal ntula Goyim, go Amrafel ntula Sinar, a Ariok ntula Elasar, bo atul ani je elnoko a atul alon. ");
INSERT INTO eka_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Edamme ji Sidim abing jolo o tvv nya bo jo ramme yehke anyake elak, eji ntula Sodom, a no Gomora jo be, ane bandiki jo gbo yel abing nyao, bako be tahm go awong. ");
INSERT INTO eka_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Atul ani bao kehm taare nsol anebe Sodom kpee, a nyi anebe Gomora, a nsol alehke ebo kpee, feere ebo kehnge ");
INSERT INTO eka_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Bo tob bobo Lod ji nfuna Ebram tahm a ne, a nsol a nsol enye kpee, tibre á lene Sodom. ");
INSERT INTO eka_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Nne awohng no be go ebta, kehm ba tong Ebram ji nnea Hibru. Ebram lene kohlo agburu nti nya Mamre ji nne Amor, ye ji jolo mmonannyehn no Esikol, a Aner, bo kpee ji jolo njahm a Ebram. ");
INSERT INTO eka_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Eji Ebram wuku re nfun ewe bo me-e bob fi a ne, owo á kehm kuku ane ebe ba á ma tib bo ebnere ebta, ane atahlku ane elku ane ara, bo kpee bo jele bo go nlaaga nyi Ebram, bo kehm tahme jo kam bo tete rehng go Dan. ");
INSERT INTO eka_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ngare atv Ebram kehm yabe ane ebe go nlong a nlong, re bo nok a ane ba bobo Lod, bo kehm kame anebekv yehke, toono bo tete rehng go Hobah, ejang ebobkal bi Damaskus ");
INSERT INTO eka_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ebram fere taare nsol kpee nyi bo da no a Lod ji nfun ewe, a nsol a nsol enye kpee, feere a ne kehnge, a anebkal, a ane bako fvfo. ");
INSERT INTO eka_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Eji Ebram kehnge ebta bi á noko ga Kedolaoma a atul ba á kpa njahm a bo, owo ntula Sodom kehm bake re á ba wan-e go edamme ji Saveh ji li Edamme ji Ntul. ");
INSERT INTO eka_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Owo Melkijedek ntula Salem kehm koko nsol alehke, a amahm ba a ma. Á jolo nlimajom no Esowo bi ga wahre, ");
INSERT INTO eka_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","á kehm fuulu Ebram kehm bungu re, <<Nong Esowo bi ga wahre, ye ji limi elbung a ndi, fuulu Ebram. ");
INSERT INTO eka_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Nong eltehke jol ka Esowo bi ga wahre, ye ji yake anebekv eba kak-a go ebo. Owo Ebram kehm kake Melkijedek ellong anehng go ellong nsol ewubu ewubu. ");
INSERT INTO eka_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ntula Sodom kehm bungu tong Ebram re, <<Ka-m ane ebame, wo ko nsol nyi a da go ebta.>> ");
INSERT INTO eka_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Owo Ebram kehm bungu tong ntula Sodom re, <<N tabe ebo ebame ton go ero ko nwongo go mbinga Jehova, Esowo bi ga wahre, ye ji limi elbung abola ndi, ");
INSERT INTO eka_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","re me nehm tiki ko ejum ajehng ajehng, ji li jˈja, jol elv afi nlehke ekpaketa n nehm ko, eji a lˈkˈtiki ma bung re, <Me wo limi re Ebram gbo afang.> ");
INSERT INTO eka_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","N nehm ko ejumjum, sehngem jio ji ane ebame ma li, a mbake nyi li ka ane ba toon-m no, Aner, Eskol, go Mamre. Nong bo ko mbake nyi bo. ");
INSERT INTO eka_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Eji nsol nyia kpee ma mal, Jehova kehm bungu tong Ebram go elfoongo nlem, re, <<Ebram ka fahl, Me wo li ekum eba, eltuuru ena bahke sahb gbˈgbal. ");
INSERT INTO eka_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ebram kehm faange re, <<O Jehova, Ntubesi ewame, jenji a bahk-m kake, ga na me mmon n kpimm? Nne no bahk-m elkv li Eliesa wo ji lohng go Damaskus!>> ");
INSERT INTO eka_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ebram kehm bungu re, <<Abon m-e a ka ka, nlokeltum no li egama nlaaga wo bahke jolo nlehkelkv ewame.>> ");
INSERT INTO eka_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Owo Jehova kehm kpe bung tong-e re, <<Nne noa sang bahke jolo nlehkelkv ewa, mmon no a bahke jele, wo bahke jolo nlehkelkv ewa.>> ");
INSERT INTO eka_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Á kehm lohngo elatahk a Ebram, kehm-e tongo re, <<Tab esamahr eba, wo seenge go elbung. Fange alonlo, lˈjol re a bahke ma fange.>> Owo Jehova kehm tongo Ebram re, <<Ano wo abon eba bahke ruru. ");
INSERT INTO eka_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ebram bumu Jehova go etingitingi, owo wahnge Esowo kehm-e koko ana etingitingi nne. ");
INSERT INTO eka_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Á kpe bung re, <<Me wo li Jehova, ji lung-a yehke go ejahbe jio ji Ur go ndi nyio nyi anebe Kaldia, re me m ba ka-a ndi nyia, fere jol nyi nya.>> ");
INSERT INTO eka_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ebram kehm bungu re, <<O Jehova Ntubesi ewame, anv m bahke limi renan kehm kahne re ndi nyia bahke lohko jol nyˈnyame?>> ");
INSERT INTO eka_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Jehova kehm-e tongo re, <<Ko mmon a nfong ba, a mbul, go nkom, bo bahke jolo bo ji ma kang nnya era era, tob ko elbehl ba ani, a mmon etomtom.>> ");
INSERT INTO eka_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ebram kehm koko nsol nyia kpee ba ka-e. Á jo ba enyam bio, yang go ejang ebbal. Ano wo Ebram rodo ajang enyam nyao bum go edi ebbal, jol wane atem, sehngem re, nruk nyi á ki yang bo. ");
INSERT INTO eka_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Nruk nyi kpo li atem enyam jo seb re bo ba li enyam bio, wo Ebram jo kame na bo. ");
INSERT INTO eka_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Eji njul yahke lahm a, Ebram kehm gboko ellu, lal kpˈkpoodo kpˈkpoodo, emennge ejannge jia kehm tahle na tahl ba bul-e. ");
INSERT INTO eka_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Owo Jehova kehm bungu tong-e re, <<Loko kahn re etˈtohngo eja bahke jolo ajenne go njen ejahbe. Bo bahke rodo bo bum aju, fere jo nohk bo go nnya atahltahl. ");
INSERT INTO eka_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","M bahke kake ejahbe jio ji bo bahke jo loko bo erem, owo bo bahke lohngo ejahbe jio tahm, a agburu afang. ");
INSERT INTO eka_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Wo bahke sahb kˈkul, kehm kpoko soom, bo kpa-a kak, a song kpiri babnso. ");
INSERT INTO eka_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Go eying ebni, etˈtohngo eja bahke feere ba a. Tibre abiafem nya anebe Amor ka rur ebtuku. ");
INSERT INTO eka_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Eji njul ma lahm, ejannge fere gbo Ebram kehm nyehne nkpangenyo nyi atˈtohk jo lohng, a enyaale ji jo lul, ma lohng ba sehng go elka elka ni enyam bio bi á bumu go edi ebbal. ");
INSERT INTO eka_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Efung bio Jehova limi egbanngalung a Ebram re, <<Etˈtohngo eja ji m ma ka bo edi ndi jia, bomo go aya ma Ijib, tete rehng go agburu aya ma Yufrati. ");
INSERT INTO eka_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ndi nyio nyi anebe Ken, a nyi anebe Keniji, a anebe Kadmon, ");
INSERT INTO eka_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","a anebe Hid, anebe Periji, a anebe Refa, ");
INSERT INTO eka_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","a anebe Amor, a anebe Kenan, a anebe Girgasi, go anebe Jebusi. ");
INSERT INTO eka_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ngare nyia Sarayi nkala Ebram ka jel mmon awohng awohng ka-e. Á bele mmon no nkal no lohng go Ijib no jo lok-e, bo jo lung-e re Hagar. ");
INSERT INTO eka_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarayi kehm tongo Ebram re, <<Jehova eblim re me n kˈjel abon. Song noongo a Hagar nloketum ewame, fundiki bahke limi o re me n bom nnahba njel go ege. Ebram tˈtaame tv ji Sarayi bungu no. ");
INSERT INTO eka_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ngare nyi Ebram ma kang nnya ewubu go Kenan, Sarayi nkal ewe kehm rodo mmona Ijib no nkal no jo lok-e, no bo jo lung-e re Hagar ka nlum we, re á jol nkal ewe. ");
INSERT INTO eka_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Á kehm noongo a Hagar, á soro sa ela. Eji Hagar sebe kahn re yebsa ela, nnyehn no á jo lok-e we joom kpe lub. ");
INSERT INTO eka_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Owo Sarayi kehm tongo Ebram re, <<Wo wo elfeeme nia li a na go ebi ji n kpˈnyehne erem a. N yake nloketum ewame kak-a go elwo, anv eji á ma kahn re yebsa ela, á me-e nehme kpe kpunu, nong Jehova lam-r awahra na. ");
INSERT INTO eka_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ebram kehm-e tongo re, nlokeltum ewa tiki wob go ega abo, lim-e ana a tiri no. Sarayi kehm-e bibi elfili, á soro be eje tahm. ");
INSERT INTO eka_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Enjel nyi Jehova kehm nyehne Hagar jehk kohlo elbing alahb ni jolo go elka emahng, elbing alahb nio jolo kohlo mbang nyi li rehng go Sur. ");
INSERT INTO eka_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Enjel kehm bungu re, <<Hagar nlokeltum no Sarayi, gan wo a lohng no kpˈbake, anv, gan wo a fi no? Hagar kehm-e faange re, <<N kpˈbeke goji Sarayi, nnee ejame no n kp-e loko.>> ");
INSERT INTO eka_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Enjel nyi Jehova kehm-e tongo re, <<Feere song goji nnee no a kp-e loko wo song woom-e go elwo. ");
INSERT INTO eka_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Enjel kehm kpe bung re, <<M bahke nyange etˈtohngo eja, bo bahke gbale sehng, jol a nehm ma fange.>> ");
INSERT INTO eka_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Enjel nyi Jehova kpe-e tong re: <<Anv, a li ela, a bahke jele mmon no nlum, a bahk-e gungu mbing re Ismeel, tibre Esowo ebwuk erem eba. ");
INSERT INTO eka_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Á bahke jolo njoba nne no li ana mbvankang nyi ekulegbe, abo enye bahke kuumu nne awohng awohng, ebo bi nne awohng awohng bahke tob kuum-e, á bahke jolo ebib bib elkpin a abonanyehn kpee. ");
INSERT INTO eka_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar kpiiki Jehova ji bungu a ne mbing re: <<Wo wo li Esowo bi kp-m nyehne,>> tibre á bungu re, <<Anv, me n nyehn nne no kp-m nyehne.>> ");
INSERT INTO eka_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Owo wahnge bo jo lungu elbing alahb nio re, Beer Lahayi Royi. Nia kpeka li go elka elka ni Kedesh abola Bered. ");
INSERT INTO eka_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Owo Hagar kehm jele mmon no nlum ka Ebram, Ebram kehm-e gungu mbing re Ismeel. ");
INSERT INTO eka_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ebram kange nnya atahl ani, a nnya erakera eji Hagar jele Ismeel ka-e. ");
INSERT INTO eka_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ngare nyi Ebram ma kang nnya atahl ani a nnya elku, a nnya eni, Jehova kehm ba kpir-e, fere tong-e re, <<Me wo li Esowo Bi Kpi Nsahm Kpee; jo toono abang enyame ka lim ebi ajehng ajehng. ");
INSERT INTO eka_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","M bahke tibi re egbanngalung ejame a na ebyiimi, fere sahb lˈlim eji a lˈgbal go nrur.>> ");
INSERT INTO eka_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ebram kehm gboko kohk esamahr go ndi, Esowo kehm-e tongo re, ");
INSERT INTO eka_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","<<Egame, egbanngalung ejame ji a, a na: A bahke jolo nde no ajahbe gbalee. ");
INSERT INTO eka_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Bo wa-a nehm kpe lung re Ebram, mbing enya bo bahke fere jo lung-a re Ebraham, tibre m ma-a lim nde no ajahbe gbalee. ");
INSERT INTO eka_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","M bahk-a limi a sahb rˈrur, ajahbe gbalee bahke lohngo go ega, atul bahke tob lohng go ega fvfo. ");
INSERT INTO eka_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Egbanngalung ji m ma lim a na bahke jolo nkahlkahl, bahke jolo ka me a na, a etˈtohngo eja, a aying nya kpˈbake. A wo li egbanngalung, m bahke jolo Esowo ba, a Esowo bi etˈtohngo eja ji kpˈbake. ");
INSERT INTO eka_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ndi nyia kpee nyi Kenan, nyi lela a li njenne, m bahk-a kake jol erohko ndi jˈja nkahlkahl, a etˈtohngo eja ji kpˈbake, m bahke jolo Esowo ebahne.>> ");
INSERT INTO eka_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Owo Esowo kehm bungu tong Ebraham re, <<Wofono, tiki li re, wo bum egbanngalung ejame, wo a etˈtohngo eja, ji kpˈbake, aying nya kpˈbake. ");
INSERT INTO eka_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","A wo li egbanngalung ejame ji m ma lim a na, a etˈtohngo eja ji kpˈbake, ji li re wo tiki bum: Nnenlum awohng awohng go egahne ellong bahke yehke nrur. ");
INSERT INTO eka_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Wofono antahng yehke elna nrur, eji lˈjol elliingi ni egbanngalung ji me ma lim a na. ");
INSERT INTO eka_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Go aying nya kpˈbake, bo bahke jo yehke mmon awohng awohng no nlum go egahne ellong nrur, eji mmon noo ma kang nfung enehkeni, nrur nyia bahke jolo ka abon ba bo bahke jele bo ega etahk, jol afi bo gunu na bo go akpohko go njahm ejahbe, jol afi go ega etˈtohngo bo lohngem. ");
INSERT INTO eka_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Jol afi bo jele bo go ega etahk, afi a gunu na bo go ega akpohko, bo bahke tiki yehke nrur. Egbanngalung ejame go ega ngubjing bahke jolo nkahlkahl. ");
INSERT INTO eka_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Nnenlum awohng awohng no tohko yehke nrur, bo bahke yehke go ellong ane ebe; tibre yeb rannge egbannalung ejame.>> ");
INSERT INTO eka_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Esowo kehm kpe tong Ebraham re, <<Ana Sarayi nkal ewa, ke-e kpe jo lung re Sarayi, fere jo lung-e re Sara. ");
INSERT INTO eka_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","M bahk-e fuulu, m bahke limi á tiki jel mmon no nlum ka-a, m bahk-e fuulu eji á lˈjol nnyehn no ajahbe tvv, atul ba ajahbe gbalee bahke lohngo go ege. ");
INSERT INTO eka_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ebraham kehm gboko kohk esamahr go ndi; kehm wolo fere tong elne re, <<Nnenlum no ma kang nnya atahl alon bahk kpe jol nde mmona? Anv, Sara ji ma kang nnya atahl ani, a nnya ewubu bahke ma jel mmona?>> ");
INSERT INTO eka_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ebraham kehm bungu tong Esowo re, <<Lˈlub jol re Ismeel bahke tob woomo go elwo ni elfuulu ena!>> ");
INSERT INTO eka_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Esowo kehm bungu re, <<Ee, li ano, wo Sara nkal ewa bahke jele mmon no nlum ka-a, a bahke jo lung-e re Aisik, m bahke limi egbanngalung ejame a ne, ji bahke jolo nkahlkahl, a etˈtohngo ji kpˈbake. ");
INSERT INTO eka_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Go eyaame ji Ismeel, m ma-a wuk; m bahk-e tiki fuulu, m bahk-e limi á jol njˈjel, njel enye bahke ruru. Á bahke jolo nde nne no ewubu ane abal ba bahke jo fili adi, m bahke fere ko-e lim á jol egburu ejahbe. ");
INSERT INTO eka_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Go eji Aisik wo m bahke limi Egbanngalung ejame, ye ji Sara bahk-e jele ka-a yabv anana.>> ");
INSERT INTO eka_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ana Esowo bungu a Ebraham mal, á kehm-e tahme sa. ");
INSERT INTO eka_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Efung bˈnehm o, Ebraham kehm rodo Ismeel mmon ewe, a abon ba nlum ba bo jele no go ege etahk, afi ba á gunu no go ege akpohko, bo aneblum kpee ba jolo go ege etahk, á song yehke bo nrur, ana Esowo tong-e no. ");
INSERT INTO eka_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ebraham jolo nnya atahl ani a nnya elku a nnya eni ngare nyi á yehke nrur, ");
INSERT INTO eka_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ismeel mmon ewe jolo ewubu a nnya era; ");
INSERT INTO eka_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ebraham, a Ismeel mmon ewe bo yehke nrur efung bˈnehm. ");
INSERT INTO eka_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Nnenlum awohng awohng go nlaaga nyi Ebraham, afi bo jele bo o, afi bo gunu na bo go njahm ejahbe, bo kpee yehke nrur a Ebraham. ");
INSERT INTO eka_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Jehova kehm ba kpiri Ebraham kohlo go agburu arahn nti nya li ka Mamre, ngare nyi á jehk go mbutahk mi ebkpatahk ebe, ngare nyi njul ma fub. ");
INSERT INTO eka_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ebraham kehm tabe esamahr seenge nyehn ane ara yim kohl-e kpidi kpidi. Eji á nyehne bo, á kehm foomo mehl go mbutahk, re á song kpiri bo, kehm song gong go ndi. ");
INSERT INTO eka_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Á kehm bungu re, <<Ntubesi ewame, lˈjol re ḿ ma-m nyehn ndon, kana sehng nlokeltum ewahne sa. ");
INSERT INTO eka_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nong bo ko abon alahb ba ka-n wahn ru akpade, fere re ekv go enˈnang ji eti jia. ");
INSERT INTO eka_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nong me n seb mmojum alehke ka-n wahn li bob ala, bel eko, kehm sehnge song, eji li re wahn ebba goji nlokeltum ewahne.>> Bo kehm faange re, <<Ebnob sehng, lim ana a ma bung.>> ");
INSERT INTO eka_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Owo Ebraham kehm foomo yel ebkpatahk, goji Sara, kehm-e tongo re, foomo elwaare wo nyahk ngbugu abe era, nya kpˈnobo, bonngo lim abred. ");
INSERT INTO eka_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Á kehm beke rehng ege ega, song yehke mmona nfong no nno a nno, ba ka nlokeltum ewe, no foomo song wul-e, fere lam. ");
INSERT INTO eka_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Á kehm koko nnyama nfong nyi bo lame no, á koo alahbbel nfong ma kpˈkpehde, a alahbbel ma li wiri wiri ba ka bo. Eji bo jo li, yefono yiimi kohlo bo o nnahb eti. ");
INSERT INTO eka_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Bo kehm-e bahbe re, <<Sara nkal ewa nona?>> Á faange bo re, <<Sara wob go ebkpatahk.>> ");
INSERT INTO eka_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Jehova kehm bungu re, <<M bahke tiki kpe feere ba go ega yabv ngare anana, Sara nkal ewa bahke jele mmon no nlum.>> Ngare nyio Sara jol-e go njahm jo wuungu atung, á ji go mbutahk ebkpatahk.>> ");
INSERT INTO eka_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ngare nyia Ebraham abola Sara, bobsahb kˈkul, nyˈnyehnge. Sara ebkul sehng ana fuumu re á kpe jel mmon. ");
INSERT INTO eka_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Owo Sara kehm wolo atahng atahng eji á jo tir bade re, <<Anv eji m ma faade mal, nlum ewame go ebtob kul, m bahke ma kpe wuk elyebe nioa?>> ");
INSERT INTO eka_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Owo Jehova kehm tongo Ebraham re, <<Jenji wahnge Sara ma wol fere bung re, <M bahke lohko jel mmon anv eji m ma kula?> ");
INSERT INTO eka_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Anv ejum jia ji kpo riidi goji Jehovaa? M bahke feere ba go ega yabv, ana m ma kunu afung, Sara bahke jele mmon no nlum.>> ");
INSERT INTO eka_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara jo fˈfahl, á kehm gbaame re, <<N wolem.>> Jehova kehm-e tongo re, <<Ee, á wˈwol.>> ");
INSERT INTO eka_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Eji bo ma mehl re bo yahke tahm, bo seenge go edamme ji Sodom. Ebraham kehm tob tahm jo jen a bo re á song tv bo. ");
INSERT INTO eka_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Owo Jehova kehm bungu re, <<Anv nˈnob re me n behr Ebraham ejum ji n yahke lima? ");
INSERT INTO eka_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ebraham jia bahke gbalao, fere jol egburu ejahbe, ji kpi eko, ajahbe njini kpee bahke bele elfuulu sehng go ege. ");
INSERT INTO eka_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Tibre m me-e yehke re á tib abon ebe, a nlaaga enye, re bo toono mbang nyi Jehova, jo lim ji kpˈnobo, a ji li go nseenga nseenge. Eji Jehova lˈlim ana á nyame no tong-e. ");
INSERT INTO eka_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Owo Jehova kehm bungu tong Ebraham re, <<Aling nya li bade Sodom a Gomora ebgbal sehng, abiafem ebo ebmaange sehng, ");
INSERT INTO eka_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","owo wahnge n fi o re me n song nyehn ji bo ma lim lˈjol re ebsab ana aling nya ma-m rehng ga. Tohko jol ano m bahke kahne.>> ");
INSERT INTO eka_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Aneblum bao sennge tahm asongo go Sodom, wo Ebraham sa yiimi o esamahr Jehova. ");
INSERT INTO eka_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ebraham kehm jeere kohl-e kehm bungu re: <<A bahke feenge atingi ane semme a abi ane wohng goa? ");
INSERT INTO eka_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Anv lˈfere jol re, atingi ane atahl abal ane awubu baa o ejahbe jio mee? A bahke tiki kpe rannge, a nehm yake edi jio bum, tib esi atingi ane atahl abal ane awubu ba li oa? ");
INSERT INTO eka_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ndan gbaaa re, wo lim elkohn ejum ana jia, wul atingi ane semme abi ane, re wo kak atingi ane, a abi ane erem jang jang. Ndan gbaaa! Anv, Nlˈlame no njini nyia kpee nehm ma lim ejum ji nnoa?>> ");
INSERT INTO eka_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Jehova kehm bungu re, <<N lˈfere nyehn atingi ane atahl abal ane awubu, ejahbe jio ji Sodom, m bahke yake edi jio kpee bum tib esi atingi ane bao.>> ");
INSERT INTO eka_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ebraham kehm kpe bung re: <<Anv eji m ma bel esahb bung a Ntubesi ewame, jol ejumjum me n lohngem, n li ana ebtohko, a atong. ");
INSERT INTO eka_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Lˈjol re ane alon eblohng go atingi ane atahl abal ane awubu, a bahke tiki rannge ejahbe jio kpee tib ane alon ba ma lohng go nfange nyioa? Jehova kehm bungu re, <<N lˈnyehn atingi ane atahl abal ane alon o, n nehm tiki rannge ejahbe jio.>> ");
INSERT INTO eka_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ebraham kehm kpe bung tong-e re, <<Anv, a lˈlub nyehn atingi ane atahl abal o mee? Jehova kehm-e tongo re, <<Tib esi atingi ane atahl abal bao, n nehm lim ano.>> ");
INSERT INTO eka_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ebraham kehm bungu re, <<Ntubesi ewame eltim ki-a rak, nong me m bung, lˈjol eltahl atingi ane awubu ba ba mee?>> Jehova kehm faange re, n lˈ nyehn eltahl atingi ane awubu o, n nehm lim ano. ");
INSERT INTO eka_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ebraham kehm bungu re, <<Anv eji m ma bel esahb re me n bung a Ntubesi, anv atingi ane eltahl ba ba lˈjol o mee?>> Jehova kehm faange re, <<Tib esi atingi ane eltahl, n nehm rannge ejahbe jio.>> ");
INSERT INTO eka_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ebraham kehm bungu re, <<Ntubesi ewame, eltim ki-a rak, nong me n gohro bung nkpel nkpel anyehng nyia. A lˈfere nyehn atingi ane awubu ba ba o mee?>> Jehova kehm faange re, <<Tib esi atingi ane awubu, n kehm rannge ejahbe jio.>> ");
INSERT INTO eka_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ana Jehova ma bung a Ebraham mal, á kehm tahme eje. Ebraham kehm feere kehnge go etahk. ");
INSERT INTO eka_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Enjel ebal nyio rehnge go Sodom ngare elgung, Lod jii go eti mbu ji ejahbe jio. Á nyehne bo kan a me, á kehm mehle tahm re á song kpiri bo, fere gbo kohk esamahr ebe go ndi. ");
INSERT INTO eka_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Á kehm bungu re, <<Atubesi ebame, ba tahm-n go etahk nlokeltum ewahne. M Bahke ma ru akpade, fere kang o. Behna efungfu behre behre wahn lohng song mbang enyahne.>> Bo kehm-e faange re, <<Eˈee, e bahke kange go elatahkgur.>> ");
INSERT INTO eka_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Á fanne bo tˈtahne, bo kehm tahme toon-e song yel ege etahk. Á lame nsol ka bo, fere lim abred nya ki kpi ayist, bo li. ");
INSERT INTO eka_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Re bo kehm tahme song noongo, aneblum go nkpohka Sodom anyehng anyehng kpee, anebkul, a ajangkun ajangkun lohngo ba sennge etahk jio kak. ");
INSERT INTO eka_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Bo kehm lungu Lod bahb-e re, <<Ane ba ba go ega atv maa, bo bana? Yehke bo ba ka-r, wahr noongo a bo.>> ");
INSERT INTO eka_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lod kehm lohngo elatahk, bam mbu song kpiri bo, ");
INSERT INTO eka_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","kehm bungu re, <<Eˈee ate ebame, kana lim elkohn ebi ejum ana jia. ");
INSERT INTO eka_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nyehnen ga, n kpi abon ba nkal na abal, ba aneblum kala nˈnoongo a bo, nong me n ko bo ba ka-n, wahn lim bo ji kp-n koro. Kana lim ane baa ejumjum, tibre ane baa ebba, ajenne enyame nya, bo wob go egame ebo. ");
INSERT INTO eka_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bo kehm faange re, <<Ka-r eyake go mbang,>> Fere tob bung re, <<Nne noa ba a ana njenne, anv á yahke fere jol nlamalam! E bahk-a limi ji kpˈsabe, sehnge ji e bahke limi bo.>> Bo soro na asi kpe jo temme Lod, fere jo gbul asongo re bo song wa mbutahk. ");
INSERT INTO eka_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Aneblum bao sa go atahng ekpˈkpa tanne abo tohng Lod feere kak ekpˈkpa, bam mbu. ");
INSERT INTO eka_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Bo wa ane ba yiimi go mbutahk amahr, anebkul, a ajankun, ajankun, mbutahk bo kpeem jo nyehn. ");
INSERT INTO eka_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ane abal bao kehm tongo Lod re, <<A kpˈkpi nne awohng awohng a, ana abon ba li anar eba, abon ba nlum, a ba nkal, afi nne awohng awohng a ejahbe jia no li ka woa? Yehke bo a kpee, ");
INSERT INTO eka_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","tibre e bahke rannge edi jia, tib aling nya ma lohng song kpiri Jehova bade ane ba li ejahbe jia ebgbal sehng, owo wahnge Jehova ma-r tum re wahr ba rannge edi jia.>> ");
INSERT INTO eka_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Owo Lod kehm tahme song tong abon anar ebe ba lame re bo bahke koko abon ebe ba nkal go elbal. Á song tongo bo re, <<Foomen wahn lohng edi jia, tibre Jehova yahke rannge ejahbe jia.>> Wo abon anar ebe jo tiri re, á jo limi ayok. ");
INSERT INTO eka_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ana efungfu kpi nseke nseke, enjel nyao kehm kehme Lot sohko, fere tong-e re, <<Foomo wo rod nkal ewa, a abon ebal eba ba nkal, ba li a, tohko jol ano, bo bahk-a tob rannge budu, ejahbe jia lˈkehme elrannge. ");
INSERT INTO eka_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Eji Lod jo laange, aneblum bao kehm-e jabbe go ebo, fere tob jabbe nkal, a abon abon ebe, enangebeem yehke go ejahbe jio, tibre bo fili Jehova ndon. ");
INSERT INTO eka_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ana bo lohngo a bo, njenne anyehng kehm tongo bo re, <<Been, wahn tahre elkpin enahne! Kana keebe go njahm, jol kana yiimi edi ji li balebale! Been, song go awong; tohko jol ano bo bahk-n rannge kpee!>> ");
INSERT INTO eka_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lod kehm faange bo re, <<Eˈee ntubesi titi wahn! ");
INSERT INTO eka_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nlokeltum ewahne ma-n fili ndon, m ma-m tib nnoobo eljini, eji ḿ ma tahre elkpin ename. N nehm ma be rehng awong nyao; elrannge nia bahk-m kpiri, m bahke kpoko. ");
INSERT INTO eka_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nyehnen ejahbe ga ji li kpidi kpidi, ji m bahke ma be song rehng, mojahbe no nse wo. Nong me m be song o, mojahbe kpˈseke, ano sanga? Eji n lˈtahre elkpin ename. ");
INSERT INTO eka_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Enjel kehm bungu tong Lod re, <<Ebnob sehng, m bahke kpe lim, n nehm tob rannge ejahbe ji a ma bung bade. ");
INSERT INTO eka_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Fvfo be song elwaare, n nehm lim ejumjum tete a song rehng o.>> Owo wahng ejahbe jio bo jo lung re Joar. ");
INSERT INTO eka_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ngare nyi Lod rehnge go Joar, njul eblohng. ");
INSERT INTO eka_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Jehova kehm nake agun asulfor go elbung wohngo Sodom, a Gomora. ");
INSERT INTO eka_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ano wo Esowo rannge ajahbe nyao, a adi nyao kpee nya li go ebal, budu ane ba lene ajahbe nyao, a nsol kpee nyi kpo mahng go ndi. ");
INSERT INTO eka_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Wo nkala Lod keebe njahm, wahnge á siingi ego akang. ");
INSERT INTO eka_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Efungfu behrebehre, etoono efung Ebraham kehm mehle feere go edi ji nyaane á yiimi no a Jehova. ");
INSERT INTO eka_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Á kehm seenge ejang bio bi Sodom a Gomora, á tob seenge go ndi nyio nyi li balebale kpee, á kehm nyehne anyaake atˈtohk kpˈlohngo go ndi ana atˈtohk erehmengun. ");
INSERT INTO eka_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Eji Esowo rannge ajahbe nyao go ndi nyi jolo balebale, á bˈbuumu Ebraham, song yehke Lod go elrannge ni gbo tub edi ji á jolo no. ");
INSERT INTO eka_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lod, a abon abal ebe ba nkal, mehle go Joar, fere song lene go awong, tibre á jo fˈfahl ellene go Joar. Ye a abon abal ebe ba nkal lene go egohng atal. ");
INSERT INTO eka_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Efung abehng ngbokambang a mmon no nkal kehm tongo etoono re, <<Nsoo ejahre ebkul, nnenlum awohng awohng a limm no bahke noongo a nahre, ana eljini nio li go njini kpee. ");
INSERT INTO eka_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Nong wahr ka nsoo ejahre á wo amahm, eji e lˈnoongo a ne, eji elˈlim ebangenahb ejahre kˈtan, sehng goji nso ejahre. ");
INSERT INTO eka_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Atv mao bo kehm limi nde bo wo amahm, ngbokambanga mmon song noongo a nde, nde kahnem ngare nyi mmon song noongo a ne, a ngare nyi mmon mehle no. ");
INSERT INTO eka_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Etoono efung behko, ngbokambanga mmon kehm tongo etoono re, <<Atv ma nyaane n noongo a nsoo, nong wahr kp-e ka atv maa, á kpe wo amahm, wo tob song noongo a ne, eji elˈlim ebangenahb ejahre kˈtan, sehng goji nso ejahre.>> ");
INSERT INTO eka_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Owo bo kehm kpe ka nde amahm atv mao. Etoono mmon noko tob song noongo a ne. Á kpeem tob kahn ngare nyi mmon noongo a ne, a ngare nyi á mehle no. ");
INSERT INTO eka_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Owo abon abal abal ba Lod kehm sake ela tib eji nde noongo a ebo. ");
INSERT INTO eka_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ngbokambanga mmon jele mmon no nlum, fere gung-e mbing re, Moab. Ye wo li nde no anebe Moab ba li lela; ");
INSERT INTO eka_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Etoono mmon tob jele mmon no nlum, gung-e mbing re, Ben-Ami. Ye wo li nde no anebe Amon ba li lela. ");
INSERT INTO eka_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ebraham kehm tahme o edi jio song rehng go ekidi edi ji Negeb song lene go elka elka ni Kadesh abola Sur. Á tohko jol mmongare ntiil go Gerar, ");
INSERT INTO eka_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","eji Ebraham jolo o wo á bungu re Sara nkal ewe, <<Mmonanyehn wo.>> Owo Abimelek, ntula Gerar kehm tumu re bo song ko Sara ba, á ko-e ana nkal ewe. ");
INSERT INTO eka_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Esowo kehm bake goji Abimelek atv amehng go nlem, kehm ba tong-e re, <<Á li jang jang ana ekpakv nne, eji á song rod nnenkal noo; tibre nnenkal noo ebbal nlum.>> ");
INSERT INTO eka_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ngare nyia Abimelek ka lak nnenkal noo abo, owo á kehm bungu re, <<O ntubesi a bahke rannge ejahbe ji ki kak afema? ");
INSERT INTO eka_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Anv Ebraham me-e tong-m re, <Sara mmonannee no nkal woa? Sara tobem bung a re, <Ebraham mmonannee no nlum woa?> Ji n limi a, ntir enyame li saang, fvfo abo enyame li saang.>> ");
INSERT INTO eka_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Owo Esowo kehm-e tongo go nlem re, <<Etingitingi ji, n kpˈkahne re a limi jia a ntir enya saang. Owo wahnge n ki taame re wo lim ebi tob-m. Jˈnehm ji wahnge n ki taame re wo koor-e abo. ");
INSERT INTO eka_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Anv, feera nkala nnenlum noo song ka-e, tibre nnenlum noo nnyehnamahr Esowo wo, á bahke kake ero ka-a, a bahke kpini. Á tohko feere a ne, kahn na kahn re wo a ane eba kpee, ḿ bahke kpoko.>> ");
INSERT INTO eka_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Njahm fungfu, efungfu behrebehre, Abimelek kehm lungu atubesi anebeltum ebe, eji á ma tong bo kpee ji ma jol, bo ane kpee bele elfahle sehng. ");
INSERT INTO eka_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Owo Abimelek kehm tumu re lung Ebraham, fere tong-e re, <<Jenji wahnge á ma-r lim ana. Ebi ajii m ma-a lim, ji wahnge á ma ko egburu ebi ana jia ba kun-m, a eti etul ejame. A ma-m lim nsol nyi ki fuumu re wo lim.>> ");
INSERT INTO eka_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek kehm bahbe Ebraham re, <<Jenji wahng ka a limi ejum ana jia?>> ");
INSERT INTO eka_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ebraham kehm faange re, <<N bungu tong elname re, <Etingitingi elfahle ni Esowo edi jia limm, bo bahk-m wulu tib esi nkal ewame.> ");
INSERT INTO eka_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Nne lˈ bum jio go nkpe, á lohko li mmonanee no nkal, e lohng nde awohng, sehngem re eblohngo ni e ki lohng nnyehn awohng. ");
INSERT INTO eka_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Eji Esowo sebe re me n lohng nlaaga nsoo sa, n tong-e re, <Ana wo a bahk-m tibi elkoro ena: Edi ajehng ajehng ji e lˈjee, jo tong ane re, me mmonanee no nlum wo.>>> ");
INSERT INTO eka_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Owo Abimelek kehm koko ejoro, a efong, go aju aneblum, a anebkal ba ka Ebraham, fere feera Sara nkal ewe ba ka-e. ");
INSERT INTO eka_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek kehm bungu re, <<Nyehn ndi enyame ga nong no, edi ajehng ajehng ji lˈkor-a song lene.>> ");
INSERT INTO eka_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Á bungu tong Sara re, <<N kpˈkake mmonanne no nlum asilva akpohko, atahltahl nkpel ebal atahl awubu, nyaa li re wo ko bulu nsoodo nyi li bada na, go esamahr ane eba kpee, ba li a na; re wo ebˈbi ajehng ajehng a ka lim.>> ");
INSERT INTO eka_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ebraham kehm kake ero bahb Esowo, á lim Abimelek á nob, a nkal ewe, a aju abon ba nkal, re bo kpe jo jel abon, ");
INSERT INTO eka_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","tibre Jehova bˈbulu ejˈjele ajehng ajehng ji nnenkal awohng awohng no li go nlaaga Abimelek, tib esi Sara nkala Ebraham. ");
INSERT INTO eka_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Jehova tibi Sara egburu ndon ana á bungu no, á limi ka Sara ana á nyame no. ");
INSERT INTO eka_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara kehm sake ela jel mmon no nlum ka Ebraham, go ngare nyˈnehm nyi Esowo nyame no tong-e, ngare nyio Ebraham ebkul. ");
INSERT INTO eka_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ebraham gungu mmon no Sara jele no ka-e mbing re Aisik. ");
INSERT INTO eka_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Eji Aisik mmon ewe ma kang nfung enehkeni, Ebraham kehm-e yehke nrur ana Esowo tong-e no. ");
INSERT INTO eka_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ebraham kange nnya atahl alon ngare nyi Sara jele Aisik mmon ewe ka-e. ");
INSERT INTO eka_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara kehm bungu re, <<Esowo ma-m kak asol go nnyo, nne awohng awohng no lˈwuk bade ejum jia á bahke tob tob-m elwolo.>> ");
INSERT INTO eka_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Á kpe bung re, <<Nne awoo jol tongo Ebraham re, Sara bahke yabe abon? Wo ga, me n jel mmon ka-e eji á ma kul.>> ");
INSERT INTO eka_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aisik mmon ewe kehm gbale fere kimi abel. Efung bˈnehm bi mmon kimi abel, Ebraham limi egburu elkak. ");
INSERT INTO eka_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ismeel mmon no Hagar nnea Ijib jele no ka Ebraham, jo nyoko Aisik, Sara kehm nyehne, ");
INSERT INTO eka_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","owo Sara kehm tongo Ebraham re, <<Kam nju a nnenkal noa a mmon ewe, tibre mmon a nju a nnenkal noa, nehm tiki jol nlehkelkv semme a Aisik mmon ewame. ");
INSERT INTO eka_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ejum jia gbiingi Ebraham sehng tib esi mmon ewe Ismeel. ");
INSERT INTO eka_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Owo Esowo kehm tongo Ebraham re, <<Ka taame ejum jia bada mmon noa, a njua nlokeltum ewa gbiing-a, wuungu Sara nkal ewa atung go ejum ajehng ajehng ji á kpa-a tongo, tibre go abon ba Aisik wo etˈtohngo eja bahke lohngo. ");
INSERT INTO eka_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","M bahke koko mmona njua nnenkal noo lim ejahbe, tibre ye fvfo mmon ewa wo.>> ");
INSERT INTO eka_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Toono efung, efungfu behrebehre, Ebraham kehm rodo nsol alehke, a ekpˈkpuk alahb ji bo ko ngunyam lim song ka Hagar. Á kehm rodo nsol nyio kunu Hagar go akpakebahk, kehm-e tumu a mmon re bo song. Á kehm mehle eje tahm song kehme eldaale go elka emahng ni Beerseba. ");
INSERT INTO eka_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Eji alahb ma mal go ekpˈpuk, á kehm rodo mmon noo song bum go mmonnahb eti. ");
INSERT INTO eka_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Á kehm tahme song ji eje kpidikpidi, tahm edi ji á ji no rehng edi ji mmon jolo no, li ana nne bahke ma ro eltal rehng, á bungu re, <<N nehm ma ji o nyehn ana mmon noa bahke kpoko.>> Ana á song ji kohlo o, á jo lingi wulu wulu wulu. ");
INSERT INTO eka_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Esowo kehm wuku mmon noo kpˈlingi, enjel nyi Esowo kehm sake go ero lung Hagar, kehm bungu tong-e re, <<Hagar nfem anyii? Ka kpe fahl; Esowo ebwuk eling mmon noo, edi ji á nong o. ");
INSERT INTO eka_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Song mehl mmon noo yiimi, wo jabbe go ebo, tibre m bahk-e koko lim egburu ejahbe.>> ");
INSERT INTO eka_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Esowo kehm-e lennge amahr, á soro nyehn elbing alahb. Á song tuk alahb rurur go ekpˈkpuk, song ka mmon, á wo. ");
INSERT INTO eka_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Esowo jolo a mmon noo eji á jo gbal. Á lene go elka emahng, á jolo nne no jo ta mban. ");
INSERT INTO eka_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ana á lene o elka emahng ni Paran, nnyehn song ko nkal go Ijib ba ka-e. ");
INSERT INTO eka_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ngare nyio Abimelek, a Fikol ji ntubesia nsoja enye kehm tongo Ebraham re, <<Esowo li a na go ejum ajehng ajehng ji a ma lim. ");
INSERT INTO eka_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tir tong-m go esamahr Esowo re, a nehm nehmem go mbang anyehng anyehng, afii jol abon ebame, afii etˈtohngo ejame. Tib-m nnoobo eljini, wo tob tib ejahbe ji a lene a ana njenne, elkohn ana ni m ma-a tib. ");
INSERT INTO eka_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ebraham kehm bungu re, <<Me n taame, m bahke tiri.>> ");
INSERT INTO eka_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ebraham kehm tooro tong Abimelek bade elbing alahb ni alokeltum ebe ma taare. ");
INSERT INTO eka_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek kehm bungu re, <<N nehme kahn nne no ma lim ejum jia. Wo m-e a ka tong, lela wo n kpˈwuku na.>> ");
INSERT INTO eka_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Owo Ebraham kehm koko ejoro, a efong ba ka Abimelek, bo ane abal abal kehm tiri lim egbanngalung atemtem. ");
INSERT INTO eka_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ebraham yehke nkala njoro na esehma nyi nse bum eje eje go ellong atohkondi enye, ");
INSERT INTO eka_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek kehm bahbe Ebraham re, <<Nkal a njoro esehma nyi nse nyi a ma yehke bum eje eje lohngo renan?>> ");
INSERT INTO eka_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Á kehm faange re, <<Ko nkala njoro nyia na esehma nyi nse go egame ebo, jol ntianse re, me wo rahme elbing alahb nia.>> ");
INSERT INTO eka_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Owo wahnge edi jio bo jo lung re Beerseba, tibre edi jio wo, aneblum abal baa lim egbanngalung. ");
INSERT INTO eka_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Eji bo limi egbanngalung jio o Beerseba mal, Abimelek, a Fikol ji ntubesia nsoja enye, kehm feere kehnge go ndi nyi anebe Filista. ");
INSERT INTO eka_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ebraham bahme elrahn eti ni bo kpo lung re tamaris go Beerseba, edi jio wo, á jo lung mbing nyi Jehova, ye ji li Esowo bi li njinanjini. ");
INSERT INTO eka_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ebraham kange gbalee go ndi nyi anebe Filista. ");
INSERT INTO eka_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Eji ma kang a, Esowo kehm wuungu Ebraham. Á kehm-e lungu re, <<Ebraham!>> Á kehm faange re, <<Nyehn me ga.>> ");
INSERT INTO eka_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Owo Esowo kehm-e tongo re, <<Rod Aisik mmon ewa, mmon mmon awohng, no kpo kor-a, wo song go ekidi ndi jio ji Moriya. Ko-e wo lim njom nyi bo kpo jahm fi go ewong ajehng go ellong awong nyao, ji m bahk-a tibi.>> ");
INSERT INTO eka_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Etoono efung, efungfu behre behre, Ebraham kehm mehle toobo mbvankang enye. Á rodo alokeltum ebe na abal tahm a bo, a Aisik mmon ewe, á kehm rak nkun nyi á bahke koko lim njom nyio nyi bo kpo jahm fi, á kehm mehle asongo edi jio ji Esowo tong-e no bade. ");
INSERT INTO eka_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Eji ma kang nfung era, Ebraham kehm tabe esamahr ebe seenge nyehn edi jio go fee. ");
INSERT INTO eka_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Á kehm tongo alokeltum ebe re, <<Jolen a, a mbvankang, me a mmon, wahr tohko je go esˈsong. E bahke tohko song kak Esowo go, kehm feere ba kpir-n.>> ");
INSERT INTO eka_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ebraham kehm rodo nkun nyi bo bahke koko lim njom nyi eljahme fi, si mmon ewe Aisik, yefono antahng fili agun, a ntahme. Eji bo ane abal abal jo jen asongo, ");
INSERT INTO eka_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisik kehm bungu tong Ebraham nde re, <<Nsoo?>> Ebraham kehm faange re, <<Ee, mmon ewame.>> Aisik kehm bungu re, <<Wo nyehn nkun a, agun fvfo nyaa a, mmonjoro nona no a bahke koko lim njom nyio nyi eljahme fi? ");
INSERT INTO eka_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ebraham kehm faange re, <<Mmon ewame, yefono Esowo antahng wo bahke kake mmonjoro no njom nyio nyi bo kpo jahm fi,>> Bo ane abal abal soro asi jo jen asongo. ");
INSERT INTO eka_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Eji bo ma rehng edi ji Esowo tong-e no. Ebraham kehm limi egudu njom o, fere kono nkun kpee, á kehm gbake Aisik mmon ewe alehke fere rod-e kunu egudu njom jio, go ero nkun, go egudu njom. ");
INSERT INTO eka_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Á kehm tanne ebo rod ntahme re á wul mmon ewe. ");
INSERT INTO eka_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Owo enjel nyi Jehova kehm rabe lung-e go ero re, <<Ebraham! Ebraham!>> Á kehm-e faange re, <<Nyehn me ga.>> ");
INSERT INTO eka_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Enjel kehm-e tongo re, <<Ka lak mmon noo ebo, ke-e lim ejumjum. Anv, me n kahn re a kpˈfahle Esowo, tib eji a ka-m mmon ewa, a kiim tahre mmon ewa, mmon mmon awohng ewa.>> ");
INSERT INTO eka_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ebraham kehm tabe esamahr seenge, soro nyehn nkom go arakrak nti ma fehre atang enye. Á kehm song jabbe nkom ko-e ba a ne, ba lim njom nyi bo kpo jahm fi, soongo esi mmon ewe. ");
INSERT INTO eka_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Owo Ebraham kehm lungu edi jio re, Jehova wo bahk kake. Tete tub bi lela, bo kpo bung re, <<Go ewong ji Jehova, Jehova bahk-r kake.>> ");
INSERT INTO eka_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Enjel nyi Jehova kehm lungu Ebraham go ero, etoono nkpele, ");
INSERT INTO eka_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","kehm bungu re, <<Jehova wo ma bung, <Me n tir elname tib ejum ji a ma lim a, a ki tahre mmon ewa bum, mmon mmon awohng ewa, ");
INSERT INTO eka_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","m bahk-a lohko fuulu, fere lim etˈtohngo eja rur ana alonlo nya li go elbung, bo bahke tob rur ana erikehndi bi li go nkpe aya. Etˈtohngo eja ji bahke taare ajahbe nya anebekv ebo fere lene, ");
INSERT INTO eka_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","sehng goji mmon ewa, ajahbe kpee go njini bahke bele elfuulu, tib eji a ma-m kpunu. ");
INSERT INTO eka_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ebraham kehm feere ba kpiri alokeltum ebe, bo kpee kehm feere kehnge go Beerseba. Ebraham lene o Beerseba. ");
INSERT INTO eka_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Eji ma kang a, bo kehm tongo Ebraham re, <<Milka ji nkala mmonanne, yebtob jol nyehn abon, yeb jel abon ba nlum ka mmonanne: ");
INSERT INTO eka_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uji wo li ngbokambang, Buji ji mmonannyehn, Kemuel (nde no Aram), ");
INSERT INTO eka_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hajo, Pildash, Jidlaf, a Betuel.>> ");
INSERT INTO eka_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel wo jolo nde no Rebeka. Milka jele abon ba nlum na anehkeni baa ka Nahor ji mmonannyehna Ebraham. ");
INSERT INTO eka_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nne elkora Nahor no bo jo lung-e re Reumah, a tob jele abon ba nlum: Tebah, Gaham, Tahas, a Maaka. ");
INSERT INTO eka_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara, kange nnya atahl arakera a nnya esehma. ");
INSERT INTO eka_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara kpoo go Kiriati Aba (ji li Hebron) go ndi nyi Kenan. Ebraham kehm tahme re á song ling Sara, fere noongo elkv ene. ");
INSERT INTO eka_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Owo Ebraham kehm mehle yiimi o edˈda elkv nkal ewe, kehm tahme song bung a anebe Hid re, ");
INSERT INTO eka_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","<<Me njenne nyi, n li nne ajahmjahm go egahne ellong. Gung-m wahn edi ndi a, ji bahke jolo eyele akvne, ji m bahke jo kak akvne enyame.>> ");
INSERT INTO eka_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Owo anebe Hid kehm faange Ebraham re, ");
INSERT INTO eka_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","<<Nsoo, wuung-r atung. Wo egburu mmona ntul wo go egahre ellong. Jo kak akvne enya go eyele akvne ejahre ji nno. Nne ewahre awohng awohng limm no bahke sahde re wo kˈkak akvne enya go ege eyele.>> ");
INSERT INTO eka_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ebraham kehm mehle yiimi gong go ndi, ka anebe Hid ba li afono ndi, ");
INSERT INTO eka_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","kehm bungu tong bo re, <<Joare kp-n lohko kor re me n jo kak akvne enyame a, wuung-m wahn atung, wahn fere tob-m gboongo Efron mmona Johar ka-m. ");
INSERT INTO eka_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Eji á lˈgung-m egong jio ji Makipela, ji li jˈje ka-e, ji li ege esi egbe. Bahb-n ye á gung-m go ekun bi fuumu no, eji n lˈko lim eyele akvne go egahne ejahbe.>> ");
INSERT INTO eka_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron nnea Hid ji o ellong ane ebe, á kehm faange Ebraham go elkab anebe Hid kpee ba ba go eti mbu ejahbe eje. ");
INSERT INTO eka_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Á bungu re, <<Eˈee nsoo, wuung-m atung; M ma-a ka edi jio, fere tob ka-a egohng ji li o. M ma-a ka go esamahr ane ebame. Kpa nkvne enya kak o.>> ");
INSERT INTO eka_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ebraham kehm kpe gong go ndi ka afono ejahbe bao, ");
INSERT INTO eka_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","kehm tongo Efron go ebo esamahr re bo wuk, <<Wuung-m atung, lˈfere kor-a, m bahk-a kake ekun bi edi jio, taame wo ko, eji n lˈjo kak akvne enyame o.>> ");
INSERT INTO eka_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron kehm faange Ebraham re, ");
INSERT INTO eka_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","<<Wuung-m atung nsoo; edi ndi jio rehnge asilva akpohko atahltahl, jia lohngo jen, me, a wahra na? Kpa nkvne enya kak o. ");
INSERT INTO eka_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ebraham kehm taame tv ekun bi Efron gahme no. Ebraham ka-e asilva akpohko atahltahl go esamahr anebe Hid, toono ana ekun akpohko jolo no go ellong abajenare ngare nyio. ");
INSERT INTO eka_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ano wo edi ndi ji Efron ji jolo go ejahbe bo kpo lung re Makipela kohlo ejahbe Mamre, edi ndi, a egohng ji jolo o, go arahnti kpee nya jolo o, bo yake kpee, ");
INSERT INTO eka_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ka Ebraham re jol edi eje, go esamahr anebe Hid kpee ba ba go eti mbu ji ejahbe jio. ");
INSERT INTO eka_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Eji Ebraham ma gunu edi ndi, ona wo á kake Sara nkal ewe, go egohng ji li go ejahbe Makipela, edi ndi ji jolo kohlo ejahbe Mamre, ji li go Hebron, go ndi nyi Kenan. ");
INSERT INTO eka_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ano wo edi ndi jio, a egohng jio, ji jolo ka anebe Hid, fere jol ka Ebraham ana eyele akvne eje. ");
INSERT INTO eka_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ngare nyio Ebraham ebkul, sahb kˈkul, Jehova me-e fuulu ejang abehng abehng. ");
INSERT INTO eka_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Á kehm bungu tong ntubesia abalokeltum go nlaaga enye, ye ji nsol kpee nyi Ebraham wob-e go elwo re, <<Kak ebo eba go egame nla eyo. ");
INSERT INTO eka_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","N kpˈsebe re wo tir go esamahr Jehova, ye ji li Esowo bi elbung abola ndi, re a nehm ko nnenkal go ellong anebkal Kenan ka mmon ewame, bo ji n li a, go ebo a ndi, ");
INSERT INTO eka_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","a bahke feere egame ejahbe, go egama nnahb, song ko nkal ba ka Aisik mmon ewame.>> ");
INSERT INTO eka_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Nlokeltum noo kehm-e bahbe re, <<Lˈfere jol re nnenkal we nehm kor re á toon-m ba ndi nyia, anv, m bahke koko na mmon ewa feere a ne go ejahbe ji a lohngo no ba aa?>> ");
INSERT INTO eka_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ebraham kehm-e tongo re, <<Tiki yiimi re a nehm rod mmon ewame feere a ne go.>> ");
INSERT INTO eka_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jehova, ye ji li Esowo bi li go ero, ye ji yehk-m no go nlaaga nyi nsoo, a ejahbe ji n lohng no, á bungu tong-m, fere nyam ko nwongo a name re, <Mmon ewa wo m bahk-e kake edi ndi jia.> Jehova bahke tumu enjel enye gbo-a mbang, eji a lˈsong ko nkal go, ba ka mmon ewame. ");
INSERT INTO eka_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Lˈfere jol re nnenkal we nehm kor re á toon-a ba, wob for go nwongo nyi a tiri no go egame esamahr. Fvfo ka tiki feere a mmon ewame go.>> ");
INSERT INTO eka_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Owo nlokeltum noo kehm kake ebo ebe go nla eyo nyi nde Ebraham, kehm koko nwongo bade ejum jia. ");
INSERT INTO eka_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Owo nlokeltum noo kehm rodo ekamel na ebwubu bi nde, á tob rodo anoobo ajoobo nsol nya nde bele no budu, kehm mehle eljen asongo go Aram Naharaim, song rehng go ejahbe ji Nahor lene no. ");
INSERT INTO eka_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Á limi re akamel nyao jamme alahng kohlo elbing alahb ni li ga esi ejahbe jio, jolo ngare elgung nyi anebkal kpo song tuk alahb. ");
INSERT INTO eka_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Owo nlokeltum noo kehm kake ero re, <<O Jehova, Esowo bi nsoo Ebraham, nong eljen ni n fi a lela nob, wo fere tib Ebraham nso ewame nnoobo enya. ");
INSERT INTO eka_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nyehn ana n yim a kohlo elbing alahb, abon ba nkal ba anebe ejahbe jia, kpˈbake ba tuk alahb. ");
INSERT INTO eka_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nong jol re n lˈtong mmon no nkal re, <Radde etu elahb eja ka-m me n jahm nnyo, nong á lub bung re, <Ko wo, me n tob tuk ka akamel enya, nong lub jol re, ye wo á me-e yehke ka nlokeltum ewa Aisik. Lˈjol ana, m bahke kahne re wob tib nso ejame nnoobo enya.>> ");
INSERT INTO eka_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Re á kehm kake ero mal, owo Rebeka kehm soro lohng ba, a etulahb go ekpakebahk. Á jolo mmon no nkal no Betuel, Betuel jolo mmon no nlum no Milka, Milka wo jolo nkal a mmonannyehn Ebraham no bo jo lung-e re Nahor. ");
INSERT INTO eka_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mongbahme noa nobo sehng, á jolo mongunga nnenkal; nnene ka nˈnoongo ane. Á kehm badde yel go elbing alahb song tuk alahb kak etu lohng a ma. ");
INSERT INTO eka_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Nlokeltum noo kehm foomo song kpir-e, fere tong-e re, <<Titi ka-m abon alahb go ega etu me jahm nnyo.>> ");
INSERT INTO eka_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Á kehm bungu tong-e re, <<Wo me nsoo, á kehm soro radde etulahb fili go abo, kehm-e kake á wo. ");
INSERT INTO eka_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Eji á me-e ka, á ma wo, á fere tong-e re, <<M bahke tob tuk alahb ka akamel enya, tete bo wo biingi bo.>> ");
INSERT INTO eka_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Á soro foomo yaange alahb go etu kak ejum ji bo kpo kak akamel alahb, fere kpe be tahm go elbing song tohng alahb mako ba a ma, ano wo á tohngo no ka akamel enye biingi bo kpee. ");
INSERT INTO eka_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Jol nlokeltum noa ellum anehng anehng á bungem, á jo baab-e re á nyehn lˈjol re eljen ene Jehova eblim re nob ka-e, afii kˈnob. ");
INSERT INTO eka_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Eji akamel ma wo alahb mal, nnenlum noa kehm yehke abangetung nwul nya agul nya jo lub egram eblon kunu ejang, a ebil ebo agul ebbal nya jo lub egram atahl alon a egram ebwubu. ");
INSERT INTO eka_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Owo á kehm-e bahbe re, <<Mmonse nkal, wo mmona nyehne wo? Titi tong-m, ekpˈkpa jiaa go etahk nso ji e bahke bake ba kanga?>> ");
INSERT INTO eka_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Á kehm faange re, <<Me mmon no Betuel wo, ye ji Milka jel-e no ka Nahor.>> ");
INSERT INTO eka_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Á kehm kpe bung re, <<Wahr kpi akpawake ajele gbalee, a nsol nyi enyam, a ekpˈkpa ji a bahke ma kang atv.>> ");
INSERT INTO eka_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nnenlum noa kehm gongo go ndi kak Jehova, ");
INSERT INTO eka_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","rea, <<Eltehke jol ka Jehova, ye ji li Esowo bi nsoo Ebraham, ye ji ki ten nnoobo enye, á jolo go etingitingi ka nsoo ewame. Ana me, Jehova ma-m tv go mbang eljen tete rehng etahk abonanyehn nsoo.>> ");
INSERT INTO eka_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mmongbahme noo kehm beke song tong nnyehn, a anebe etahk ebe bada nsol nyia. ");
INSERT INTO eka_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka bele mmonannyehn no nlum no bo jo lung-e re Leban, á kehm foomo re á song kpiri nne noa go elbing alahb. ");
INSERT INTO eka_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Ana á nyehne abangetung nwul nyao, a ebil ebo go abo nya mmonannyehn no nkal, fere wuk Rebeka kpˈtongo ji nnenlum noa me-e tong, á kehm lohngo tahm song nyehn-e á yim no go ellong akamel kohlo elbing alahb. ");
INSERT INTO eka_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Á kehm-e tongo re, <<Ba, wo ji Jehova ma-a fuulu, jenji wahnge a yim a? Me n toobo etahk bum-a, a edi ji akamel bahke jolo.>> ");
INSERT INTO eka_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Owo nlokeltum noa kehm tahme etahk, bo kehm fannge akamel nsol go boa njahm, fere ko akpawake ajele, a nsol alehke akamel, tob ko alahb ba ka-e, a ane ebe re bo ru akpade ebo. ");
INSERT INTO eka_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Eji bo ko nsol alehke ba ka-e, á tongo bo re, <<N nehm tiki li nsol alehke tete n tong-n ji li re me n tong-n.>> Leban kehm bungu re, <<Tong-r me.>> ");
INSERT INTO eka_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Á kehm bungu re, <<Me nlokeltum no Ebraham wo. ");
INSERT INTO eka_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Jehova ebfuulu nsoo ewame go mbuda nkunu, yeb gbo afang, Esowo me-e ka ejoro, efong, asilva, a agul,alokeltum ba nlum, a ba nkal, go akamel, a ebvankang. ");
INSERT INTO eka_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nkala nsoo ewame Sara ebjel mmon no nlum ka-e tvtv eji á ma kul o, á me-e ka ejum ajehng ajehng ji á kpi no. ");
INSERT INTO eka_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nsoo Ebraham lim-m n tir ko nwongo re, <Ka tiki ko nkal goji anebe Kenan ka mmon ewame go ellong abonse nkal ba anebe Kenan, bo ji ń lene go ebo a ndi, ");
INSERT INTO eka_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","song go nnahb a nsoo, go egame ejahbe, wo song ko nkal ba ka mmon ewame.> ");
INSERT INTO eka_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Owo n kehm bahbe nsoo Ebraham re, <<Anv nnenkal tohko taame toon-m mee? ");
INSERT INTO eka_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Á kehm-m faange re, <<Jehova ji m ma jen a ne, bahke tumu enjel enye á jol a na go ega eljen, eji lˈnob a na,eji a lˈko nkal ba ka mmon ewame, go ejahbe nsoo, á bahke lohngo go ebangenahb nsoo. ");
INSERT INTO eka_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Jol a lˈsi jˈje go ejahbe nsoo, wob for go nwongo nyia, jol afii bo taamem yake nnenkal ka-a, a bahke foro go egama nwongo.>> ");
INSERT INTO eka_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Eji m ba rehng elbing alahb lela, m bungu re, <O Jehova, Esowo bi nsoo ewame Ebraham, titi nong eljen nia nob aname, ");
INSERT INTO eka_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","nyehn me ga yim kohlo elbing alahb; mmon no nkal lˈfere ba alahb tuk go ege etu, n lˈtong-e re, <<Titi, nong me n tohko wo abon alahb go ega mmotu, ");
INSERT INTO eka_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","á lˈfere tong-m re, <<Wo, m bahke tob tuk ka akamel enya, nong jol re, ye wo Jehova me-e yehke ka mmona nsoo ewame. ");
INSERT INTO eka_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Re me n rahke ero akake go egame eltim, Rebeka soro lohng ba, a etulahb go ekpakebahk, sehng re á song tuk alahb go elbing alahb, n kehm-e tongo re, <Titi, ka-m alahb me n wo.> ");
INSERT INTO eka_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Á kehm soro foomo radde etu eje go ekpakebahk kehm bungu re, <Wo me, m bahke tob tuk alahb ka akamel enya. N kehm woko, á lohko tob tuk alahb ka akamel enyame. ");
INSERT INTO eka_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","N kehm-e bahbe re, <Mmonse nkal, wo mmona nyehne?> <<Á kehm faange re, <Me mmon no Betuel wo, ye ji Milka jel-e no ka Nahor.> N kehm soro kak-e ebil go nwul, kak-e abil nyako go abo, ");
INSERT INTO eka_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","n kehm gongo go ndi kak Jehova, n tehke Jehova, Esowo bi Ebraham nsoo ewame, ye ji ma-m tv sehng go mbang nyi nno re me n ko mmona mmonannyehna nsoo Ebraham ba ka mmon ewe. ");
INSERT INTO eka_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Anv lˈjol re ḿ bahke tibi nsoo nnoobo eljini, fere lim etingitingi, tong-m wahn, afii ano nehm jol tong-m wahn, eji n lˈkahn esi mbang ji m bahke toono.>> ");
INSERT INTO eka_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Leban, a Betuel kehm faange re, <<Jia lohng goji Jehova, wahr wa nehm ma tong ejum ajehng ajehng go mbang anyehng anyehng. ");
INSERT INTO eka_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nyehn Rebeka ga, rod-e song a ne, á song jol nkala mmona nso, ana Jehova ma tong re jol.>> ");
INSERT INTO eka_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Eji nlokeltuma Ebraham wuku ji bo ma bung, á kehm gongo ndi go esamahr Jehova. ");
INSERT INTO eka_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Owo nlokeltum kehm yehke agul, a asilva nya jolo nsol elliibi, go abomo ka Rebeka, á tob ka Leban mmonannyehn, a nnyehna Rebeka nsol nyi sahb kˈkim ekun. ");
INSERT INTO eka_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Owo nlokeltum Ebraham noa, a aneblum ba toon-e no ba kehme nsol alehke li, fere wo, bo sa o kang. Eji bo nyahme no etoono efungfu, nlokeltum Ebraham kehm bungu re, <<Yak-m wahn, me n feere song goji nsoo ewame.>> ");
INSERT INTO eka_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Owo Leban, a nnyehna Rebeka kehm-e faange re, <<Nong mmongbahme noa tohko kpe kang a nahre nfung ewubu, afii sehnge ano; wahn kehm tahme song.>> ");
INSERT INTO eka_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Á kehm bungu tong bo re, <<Kama wahn kpe laange, anv eji Jehova ma lim re eljen aname nob. Yak-m wahn me n song kehnge, song kpiri nsoo ewame.>> ");
INSERT INTO eka_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Owo bo kehm bungu re, <<Nong wahr tohko lung mongbahme fere bahb-e bade ejum jia.>> ");
INSERT INTO eka_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Bo kehm lungu Rebeka bahb-e re, <<Á bahke toono nnenlum noa tahma?>> Á kehm bungu re, <<Ee, m bahke tahme.>> ");
INSERT INTO eka_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Owo bo kehm tumu Rebeka mmonannyehn ebo, a nlokeltum ewe, a nlokeltuma Ebraham noo, a aneblum ba toon-e no ba, bo feere kehnge. ");
INSERT INTO eka_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bo fuulu Rebeka, fere tong-e re, <<Mmonannee ewahre, nong wo lub nyange mbuda nkunu, abon eba jo nok ga ajahbe nya anebekv ebo.>> ");
INSERT INTO eka_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Owo Rebeka, a alokeltum ebe kehm toobo nsol eltahme, bo gbade akamel nsol tahm toono nnenlum noo. Nlokeltum noo ko Rebeka, bo tahm. ");
INSERT INTO eka_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ngare nyia Aisik eblohng go Negev edi ji á jolo no, ba ga Beer Lahayi Royi. ");
INSERT INTO eka_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Á kehm lohngo song rehng go emahng elgung anehng, song ji re á tir bada nsol, ana á tabe esamahr wahre, á kehm nyehne akamel kpˈbake. ");
INSERT INTO eka_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka tob seenge mbuksong, á kehm nyehne Aisik. Á kehm badde go ekamel ji á kuumu no, ");
INSERT INTO eka_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","á kehm bahbe nlokeltum noo re, <<Nne awoo kpˈbake o re á ba wan-r ga emahng?>> Á kehm-e faange re, <<Nsoo wo o, Rebeka kehm rodo mbomo esi bulu elne. ");
INSERT INTO eka_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nlokeltum noo kehm tongo Aisik nsol kpee nyi á ma lim. ");
INSERT INTO eka_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Aisik kehm-e koko ba a ne go ebehre ji nnyehn Sara, fere ko-e go elbal, á jol nkal ewe, á jo kor-e kor, Rebeka jolo ejum ekakeltim eji nnyehn ma kpo. ");
INSERT INTO eka_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ebraham kehm kpe ko nkal noko, no bo jo lung-e re Ketura. ");
INSERT INTO eka_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Á jele Jimran, Joksan, Medan, Midian, Isbak, go Sua ka Ebraham. ");
INSERT INTO eka_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan wo jolo nde no Seba a Dedan; etˈtohngo ji Dedan ji li anebe Asur, anebe Letus, a anebe Lewum. ");
INSERT INTO eka_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Abon ba nlum ba Midian ba a, Efa, Efer, Hanok, Abida, a Eldaa. Bo kpee lohng go etˈtohngo ji Ketura. ");
INSERT INTO eka_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ebraham yake ejum ajehng ajehng kpee ji á bele no ka Aisik. ");
INSERT INTO eka_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Eji Ebraham kpeka li elkpin, á kaa abon anebe elkang ebe nsol, fere tum bo, bo tahm Aisik sa, tahm go ero nfam. ");
INSERT INTO eka_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Nnya kpee nyi Ebraham kange no, jolo nnya atahl anehkeni a nnya elku. ");
INSERT INTO eka_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Owo Ebraham gohro v elv ene, kehm kpoko, á kange nnya tvv, sahb kˈkul. Bo kehm-e kpake kak go eyele ji ane ebe. ");
INSERT INTO eka_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Aisik abola Ismeel, abon ebe ba nlum kehm-e kpake kak go egohng ji li ejahbe ji Makipela ji li kohlo ejahbe ji Mamre, go egbe ji Efron ji mmona Johar ji nnea Hid, ");
INSERT INTO eka_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","edi egbe jia Ebraham gunu goji anebe Hid, owo bo kpa Ebraham a nkal ewe, Sara kak. ");
INSERT INTO eka_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Eji Ebraham ma kpo, Esowo kehm fuulu Aisik mmon ewe. Ngare nyio Aisik lene kohlo Beer Lahayi Royi. ");
INSERT INTO eka_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","A wo li ntoora nnyo mi Ismeel mmona Ebraham, ye ji nlokeltuma Sara no bo jo lung-e re Hagar ji lohng go Ijib jel-e no ka Ebraham. ");
INSERT INTO eka_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Abing abon ba nlum ba Ismeel ba a, bo gamme bo, bomo nnenkul feere ndi: Nebayod wo jolo ngbokambanga mmon no Ismeel, noko Kedar, a Adbeel, a Mibsam, ");
INSERT INTO eka_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","a Mishma, a Duma, a Masa, ");
INSERT INTO eka_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","a Hadad, a Tema, a Jetur, a Nafis, go Kedema. ");
INSERT INTO eka_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","A wo li abon ba nlum ba Ismeel, go bo abing, a ajahbe nya bo lene no, a nsi, a nsi ebo, a arohko arohko ajahbe nya bo lene no. Bo ba jolo atubesi ebo, ewubu etˈtohngo ebbal ebo. ");
INSERT INTO eka_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Nnya kpee nyi Ismeel kange no jolo nnya atahl arakera, a nnya elku a nnya ebal, kehm kpoko, bo kpa-e kak eyele ji ane ebe. ");
INSERT INTO eka_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Etˈtohngo eje ji kake elsi ebo go elka elka ni Havila rehng go Sur, kohlo nkonandi nyi Ijib, ana a kpˈtahme asongo go Asur. Bo jo bibi eljini a abonanyehn ebo kpee. ");
INSERT INTO eka_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","A wo li ntoora nnyo mi Aisik mmona Ebraham. Ebraham wo jolo nde no Aisik, ");
INSERT INTO eka_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisik jolo nnya atahl abal kehm koko Rebeka go elbal, ye ji jolo mmona Betuel, nne Aram no lohng go Padan Aram. Rebeka jolo mmonannyehn no Leban ji lohng go Aram. ");
INSERT INTO eka_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisik kake ero tong Jehova, bada nkal ewe, tibre nkal jolo ngum, Jehova kehm faange ero ebe, Rebeka nkal ewe kehm soro sa ela. ");
INSERT INTO eka_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Abon jo nokko etemtem go atahng ala. Á kehm bungu re, <<Jenji wahnge elkohn ejum ana jia kp-m lˈlim?>> Á kehm tahme re á song bahb Jehova. ");
INSERT INTO eka_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Jehova kehm bungu tong-e re, <<Esi ejahbe ebbal wob-a go ala, ejahbe ebbal bi bahke lohngo go ga ala bahke yabe, ejahbe ajehng bahke tahne sehnge jehko, nne no li nnenkul bahke jo loko mmonse. ");
INSERT INTO eka_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Eji ngare ejel enye rehnge no, á jele ayafele abon abal ba nlum. ");
INSERT INTO eka_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","No gbo mbang lohng jolo mbilibili, ngubjing enye jolo anyar anyar, jolo are bo kak-e na ewobo ji li agv agv; ye bo gung-e mbing re Eso. ");
INSERT INTO eka_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Owo mmonannyehn kehm lohngo toon-e, ebo ebe jabbe go eselsel ji Eso, ye bo gung-e mbing re Jekob. Aisik jolo nnya atahl ara Rebeka kehm jele bo. ");
INSERT INTO eka_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Abon bao kehm gbale, Eso jolo agbaji ebim, á jolo nne no jo woomo go emahng. Wo Jekob jolo nne no jolo soom, jo woomo go abon nkpatahk. ");
INSERT INTO eka_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Tib eji nnyam jo kor Aisik, Eso wo jo ga-e kor. Wo Rebeka, Jekob wo jo kor-e. ");
INSERT INTO eka_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Efung abehng Jekob jo lame mbed, Eso kehm kehnge emahng ba, njal yame sˈsehng, akahb jo kahm-e kahm. ");
INSERT INTO eka_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Á kehm tongo Jekob re, <<Kam mbilibila mbed nyio me n li! Tibre njal ma-m yam sehng!>> (Ji ji wahnge bo tob jo lung-e re Edom.) ");
INSERT INTO eka_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jekob kehm-e faange re, <<Gbo mbang gung-m ekul eba.>> ");
INSERT INTO eka_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Owo Eso kehm bungu re, <<Ga n nong go emel elkv, anv, nsehng anyii ekul ebame bahk-m kake?>> ");
INSERT INTO eka_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jekob kehm bungu re, <<Tohko gbo mbang tir tong-m.>> Owo Eso kehm tiri ko nwongo, fere gungu Jekob ekul ebe. ");
INSERT INTO eka_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Owo Jekob kehm soro ka Eso ebred, a mbed nyi a ko amohk nti nya bo kpo lung re lentil lam. Eso li mbed nyia, wo alahb, mehl eje tahm. Ano wo Eso rodo ekul ebe daange. ");
INSERT INTO eka_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Njal jolo go ndi nyia, njal nyi jolo ngare nyi Ebraham jolo eje eje. Owo Aisik kehm tahme goji Abimelek ntul no Filista gona Gera, ");
INSERT INTO eka_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Owo Jehova kehm ba kpiri Aisik, kehm-e tongo re, <<Ka je go Ijib, lene go ndi nyi n tong-a no re wo lene. ");
INSERT INTO eka_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Jol go ndi nyia mongare ntiil. M bahke jolo a na, fere fuul-a. Wo wo m bahk-a kake ndi nyia a etˈtohngo eja, m bahke lohko lim enyam bi n nyame no, eji n tiri ka Ebraham nso. ");
INSERT INTO eka_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","M bahke limi etˈtohngo eja bahke ruru ana alonlo nya li go elbung, m bahke fere ka bo ndi nyia kpee. Ajahbe njini kpee bahke bele elfuulu, sehng goji etˈtohngo eja. ");
INSERT INTO eka_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Tibre Ebraham kpun-m kpunu, fere lim nsol nyi n tong-e re á lim, fere bum atahm enyame, a ajehke enyame, go nle enyame.>> ");
INSERT INTO eka_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Aisik sa lene o Gerar. ");
INSERT INTO eka_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Eji aneblum ba ejahbe jio bahb-e no bada nkal ewe, á kehm faange re, <<Ye mmonannee wo.>> Tibre á jo fˈfahl re á bung re, <<Ye nkal ewame wo.>> Á tiri go ege eltim re, <<Aneblum ba li edi jia bahk-m wulu tib go esi Rebeka, tib eji á li nne ano.>> ");
INSERT INTO eka_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Eji Aisik ma kang afung gbalee edi jio, owo Abimelek ntula Filista kehm seenge sehng go ewindu, kehm soro nyehn Aisik kpi elkoro lim a Rebeka nkal ewe. ");
INSERT INTO eka_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Owo Abimelek kehm tumu bo lung Aisik, kehm-e tongo re, <<Nkal ewa wo, go etingitingi! Nˈnan wahnge a tongo re, <Ye mmonannee wo?>>> Aisik kehm faange re, <<Tibre n tiri re m bahke tane elkpin ename tib esi eje.>> ");
INSERT INTO eka_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Owo Abimelek kehm bungu re, <<A elkohn ejum ajii a ma-r lim ana. Nnenlum awohng awohng noongo noongo a nkal ewa, kehn wob ko na ko ebi jia ba kun-r mbol mbol.>> ");
INSERT INTO eka_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Owo Abimelek kehm jehke ntahm ka ane kpee re, <<Nne awohng awohng no lˈgbiingi nnenlum noa, afi fere jolo nkal ewe, bo bahk-e tiki wulu na.>> ");
INSERT INTO eka_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisik bahme nsol go ndi nyia, kehm kpake mbuda nkunu go elya nˈnehm o, tibre Jehova fuul-e fuulu. ");
INSERT INTO eka_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Aisik kehm gboko afang, afang enye soro asi jo gbal na tete á sahb fˈfang. ");
INSERT INTO eka_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Á bele ejoro, a ebul gbalee, a adahmagbudu adahmagbudu. Á tob bele alokeltum gbalee, toono o, á jo teele anebe Filista ala. ");
INSERT INTO eka_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Abing alahb kpee nya alokeltum nde rahme no ngare nyi Ebraham nde kpeka li go elkpin, anebe Filista song kpu ndi sahd. ");
INSERT INTO eka_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Owo Abimelek kehm bungu tong Aisik re, <<Mehl wo song ka-r eyake, tibre wob bel atahne sehng-r.>> ");
INSERT INTO eka_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Owo Aisik kehm mehle o, song rehng go edamme ji Gerar, song kak elsi o. ");
INSERT INTO eka_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aisik kehm kpe lennge abing alahb nya bo rahme no ngare nyi Ebraham nde kpeka li, nya anebe Filista sahde no eji Ebraham ma kpo. Á tik kpe gungu abing alahb nyao abing nyanehm nya Ebraham nde ka no. ");
INSERT INTO eka_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Alokeltum ba Aisik rahme elbing elahb go edamme, kehm song nyehn mbˈbehl alahb o. ");
INSERT INTO eka_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Abaabebul ba anebe Gerar kehm kehme eltaange a abaabebul ba Aisik. Bo jo bungu re, <<Alahb ma mahre ma!>> Wahng ka á lungu elbing elahb nio re, Esek tibre bo taange a ne o. ");
INSERT INTO eka_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Owo bo kehm kpe rahm elbing nehko. Anebe Filista kpe ba yiimi ntaange o; owo á lungu elbing alahb nio re Sitna. ");
INSERT INTO eka_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Á kehm mehle tahm edi jio sa, kpe song rahm nehko, nio nnene taangem a ne. Á kehm lungu nio re Rehobod, ji lohngo re, <<Anv Jehova ma-r ka edi, e bahke tebe a ndi nyia.>> ");
INSERT INTO eka_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Á kehm mehle o tahm go Beerseba. ");
INSERT INTO eka_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Atv mao, Jehova kehm ba kpiri Aisik, kehm-e tongo re, <<Me wo li Esowo bi Ebraham nso. Ka fahl tibre me n li a na. M bahk-a fuulu, fere lim etˈtohngo eja rur, tib go esi Ebraham nlokeltum ewame. ");
INSERT INTO eka_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Owo Aisik kehm limi egudu njom o, jo kak Jehova. Á si mobkpatahk o, alokeltum ebe tob rahme elbing alahb o. ");
INSERT INTO eka_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ngare nyˈnehm o, Abimelek eblohng go Gerar ba go ege, a Ahusa ntubelle ewe, a Fikol ji jolo ntubesia nsoja enye. ");
INSERT INTO eka_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aisik kehm bahbe bo re, <<Ḿ ba jen ga egame, wahn sang jo bib aname fere kam-m yake goa? ");
INSERT INTO eka_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Bo kehm-e faange re, <<Wahr ebnyehn gbuul re Jehova li a na, owo wahnge e bungu re, fuumu re wahr koon nwongo tir atemtem, wahr anebe Filista a na, nong wahr koon nwongo a na, ");
INSERT INTO eka_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","re wahn nehm lim-r ebi ajehng ajehng, ana wahr ki-n gbiingi go mbang anyehng anyehng, e jo gbaam-n na, fere yak-n re wahn song go elkoono. Anv Jehova ma-a fuulu.>> ");
INSERT INTO eka_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Owo Aisik kehm limi eyiiki ka bo, bo li, fere wˈwo. ");
INSERT INTO eka_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Efungfu behre behre, etoono efung, bo kehm koko nwongo tir atemtem. Aisik kehm song bo re bo song, bo soro tahm-e sa asongo go elkoono. ");
INSERT INTO eka_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Efung bio alokeltum Aisik kehnge ba tong-e bade elbing alahb ni bo ma rahm. Bo bungu re, <<Wahr ebnyehn alahb.>> ");
INSERT INTO eka_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Aisik lungu elbing alahb nio re Siba, tete sik lela, bo kpo lung mbing ejahbe jio re Beerseba. ");
INSERT INTO eka_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Eji Eso ma kang nnya atahl abal, á baange Judid, ye ji jolo mmona Beeri ji nnea Hid, á tob ko Basemad mmon no Elon ji nnea Hid fvfo. ");
INSERT INTO eka_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Bo jo ka Aisik a Rebeka erakatahng. ");
INSERT INTO eka_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Eji Aisik ma kul, amahr me-e kehme elbamme, á kpeem jo ma nyehn. Á kehm lungu Eso ji jolo mmon ewe no nkul, kehm-e tongo re, <<Mmon ewame.>> Eso kehm faange re, <<Ee, nyehn me ga.>> ");
INSERT INTO eka_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aisik kehm bungu re, <<Anv me kul na a, jol efung elkv ename n nehme kahn. ");
INSERT INTO eka_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Rod nsol ebim enya, elban a ekpukpuk ji atake elban kpo woomo, wo song go emahng song bim nnyam ekulugbe ba ka-m. ");
INSERT INTO eka_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Lam elkohn ayebeyebe nsol alehke nyi kpo kor-m, wo ko ba ka-m me n li eji n lˈfuul-a kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka jo wuungu atung eji Aisik jo bung a Eso mmon ewe. Eji Eso tahme go ekul re á song bim nnyam ba a nyi, ");
INSERT INTO eka_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","owo Rebeka kehm tongo Jekob mmon ewe re, <<Nyehne, me n wuk nso kpˈbungu tong Eso mmonanne re, ");
INSERT INTO eka_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","<Ko nnyam ekulugbe, wo ba lam ayebeyebe nsol alehke ka-m me n li, eji n lˈka-a elfuulu ename go elwo ni Jehova kehm kpoko.> ");
INSERT INTO eka_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Wuung-m atung nˈnob mmon ewame, wo lim ji m bahk-a tongo re wo lim, ");
INSERT INTO eka_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","song go ega ebul, wo song yehke abonbul abal ba nno, ko ba ka-m, me n lam ayebeyebe nsol alehke ana nyi kpo kor nso ka-e. ");
INSERT INTO eka_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","A bahke koko song ka nso re á li, eji á lfuul-a kehm kpoko.>> ");
INSERT INTO eka_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jekob kehm faange Rebeka nnyehn re, <<Wo Eso mmonannee li anyar anyar, me ga anyar ngubjing n kpimm. ");
INSERT INTO eka_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nsoo lˈfere koor-m abo mee? M bahke jolo nne enehm ka-e, ji kehn m bahke bele elfuulu, m bahke fere bel na elsu.>> ");
INSERT INTO eka_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nnyehn kehm-e tongo re, <<Mmon ewame, nong elsu nio jol ka me, lub lim na lim ji n tong-a no; song ko abon mbul ba ka-m.>> ");
INSERT INTO eka_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Owo á kehm tahme song ko abon mbul abal bao ba ka nnyehn. Á kehm lame ayebeyebe nsol alehke, jang jang ana jo kor nde. ");
INSERT INTO eka_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Owo Rebeka kehm song jak anoobo nsol ebjing nya Eso mmon ewe no nkul nya jolo a ne go etahk, ba kak Jekob mmon ewe no nse. ");
INSERT INTO eka_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Á kehm fere rod ngunyama mbul bulu Jekob go abo a emel eje ji anyar ki jol. ");
INSERT INTO eka_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Owo á kehm rodo ayebeyebe nsol alehke nyi á ma lam kak Jekob go ebo, a ebred ji á limi no. ");
INSERT INTO eka_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Á kehm rodo tahm goji nde kehm song lung-e re, <<Nsoo.>> Nde kehm faange re, <<Ee, mmon ewame, wo nne awoo?>> ");
INSERT INTO eka_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jekob kehm bungu tong nde re, <<Me Eso ji ngbokambanga mmon ewa wo. Me n lim ana á tong-m no. Mehl ji, wo li nnyam ebim enyame, eji a lˈka-m elfuulu. ");
INSERT INTO eka_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aisik kehm bahbe mmon ewe re, <<A limi renan kehm ware bel nnyam ana, mmon ewame?>> Jekob kehm faange re, <<Jehova ji li Esowo eba, ye wo limi re ware ano ka-m.>> ");
INSERT INTO eka_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Owo Aisik kehm tongo Jekob re, <<Mmon ewame, jeere ba, me n koor-a abo, eji n lˈkahn ejoare a lohko li Eso mmon ewame. ");
INSERT INTO eka_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jekob jeere kan a kohlo Aisik nde, á kehm-e kooro abo, kehm bungu re, <<Ellum ni Jekob ni, ga abo nya Eso nya.>> ");
INSERT INTO eka_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Á we liingem, tibre abo enye jolo anyar anyar ana nya Eso mmonannyehn. Owo á kehm-e fuulu. ");
INSERT INTO eka_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Á kehm-e bahbe re, <<Anv, etingitingi wo Eso mmon ewame woa?>> Jekob kehm-e faange re, <<Ee, me wo.>> ");
INSERT INTO eka_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aisik kehm-e tongo re, <<Ko nnyam enya ba ka-m, me n li, mmon ewame, eji n lˈka-a elfuulu ename.>> Jekob kehm koko ba ka-e, á li. Á tob ko amahm ba ka-e, á wo. ");
INSERT INTO eka_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Owo Aisik nde kehm bungu re, <<Ba, mmon ewame, wo ba sod-m nnyo.>> ");
INSERT INTO eka_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Á kehm jeke go ege song sod-e nnyo. Eji Aisik wuku esˈsv ewobo eje, á kehm-e fuulu, fere bung re, <<Esˈsv mmon ewame li ana esˈsv egbe jio ji Jehova ma fuulu. ");
INSERT INTO eka_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Esowo ka-a ebohng bi kpo na go elbung, a afang nya ndi. Á ka-a amohk nti gbalee, a amahm nfenfe. ");
INSERT INTO eka_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ajahbe jo lok-a, nong ane ba lohng ajahbe gbalee jo gong ka-a, jol ntubesi ka abonane, nong abon ba nlum ba lohng ala nya nne jo gong kak-a, nong elsu jol ka ane bao ba lˈsua, elfuulu jol ka ane ba lˈfuul-a. ");
INSERT INTO eka_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisik fuulu kan Jekob a mal me, ana Jekob lohngo nde sa, ano wo Eso mmonannyehn kehnge ebim. ");
INSERT INTO eka_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ye fvfo tob lame ayebeyebe msol alehke ko re á ba ka nde. Owo á kehm bungu re, <<Nsoo, mehl ji, wo li nnyam ebim enyame, eji á lˈka-m elfuulu ena. ");
INSERT INTO eka_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aisik nde kehm-e bahbe re, <<Wo nne awoo?>> Á kehm faange re, <<Me Eso wo, ngbokambanga mmon ewa.>> ");
INSERT INTO eka_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aisik kehm kehme elkahme gbohk gbohk gbohk, kehm bungu re, <<Anv, nne awoo no je ebim no ma ko nnyam ebim ba ka-m! N li fere fuul-e, a kehm soro lohng ba. M me-e fuulu, á bahke lohko bel elfuulu. ");
INSERT INTO eka_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Eso wuku kan alum nya nde bungu no a me, á kehm rabe eling wahre wahre are eltim yahke fooro, fere jo tong nde re, <<Fuul-m, tob fuul-m nsoo.>> ");
INSERT INTO eka_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Wo á faange na re, <<Mmonnane ebko enehm, ba ko elfuulu ena.>> ");
INSERT INTO eka_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Eso kehm bungu re, <<Ji sang wahnge bo gung-e mbing re Jekoba? Nkpel ebal nyi a, nyi á ma-m nehm. Á ko ekul ebame, anv yebgohro ko elfuulu ename. Á kehm kpe bahb nde re, <<Anv, elfuulu anehng anehng a m-e bum-ma?>> ");
INSERT INTO eka_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisik kehm faange Eso re, <<M me-e lim re á jol ntubesi ewa, fere lim re akunu enye kpee jol alokeltum ebe. M m-e ka elfuulu nio ni amohk nti, a amahm ma nfenfe. Anv, jenji m bahke ma lim ka-a, mmon ewame. ");
INSERT INTO eka_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eso kehm bungu tong nde re, <<Nsoo, anv a kpi elfuulu anehng ni nia? Nsoo tob fuul-m! Eso jo lingi wahre wahre. ");
INSERT INTO eka_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Owo Aisik nde kehm-e faange re, <<Edi ellene eja bahke jo jol fee go nvemma ndi, bahke jolo edi jio ji elahb kil jo na. ");
INSERT INTO eka_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","A bahke jo ko ekahngkahng nok, kehm kpini, a bahke jo loko mmonanne. Ngare nyio nyi a lˈkˈma kpe kpuumu, a bahke laade elsol ene go ega emel tub go.>> ");
INSERT INTO eka_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Eso bele ebi ntir atahng bada Jekob tib go elfuulu ni nde fuulu Jekob. Owo á kehm bungu tong elne re, <<Afung nya e bahke noongo elkv nsoo ebkabbe, owo m bahke wulu Jekob mmonannee.>> ");
INSERT INTO eka_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Eji bo tongo Rebeka ejum ji Eso mmon ewe no nkul bungu no, á kehm tumu lung Jekob mmon ewe no nse, kehm-e tongo re, <Eso mmonanne kpi elne eltim kak, a ntir atahng nyi á kpi no re á wul-a. ");
INSERT INTO eka_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mmon ewame, anv lim ji n kp-a tongo a: Be tvtv anv, wo song go Haran eji Leban mmonannee. ");
INSERT INTO eka_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Jol a ne o mmongare ntiil, tete mmonane eltim gbo-e. ");
INSERT INTO eka_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ngare nyi eltim lˈgbo mmonane, á fere yini ji a lim-e no, m bahke tiingi etib tv-a re wo kehnge. Jenji wahnge me m bahke tane wahn abon abal abal efungfung abehng?>> ");
INSERT INTO eka_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Owo Rebeka kehm bungu tong Aisik re, <<Elkpin ma-m kpen tib esi anebkal Hid baa. Jekob lˈko nkal go anebkal Hid, go ellong anebkal ba lene ndi nyia, fuumu re me n kˈkpe jol elkpin.>> ");
INSERT INTO eka_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Owo Aisik kehm tumu bo lung Jekob, kehm-e fuulu, fere ka-e erehke re, <<Ka baange nnenkala Kenan awohng awohng. ");
INSERT INTO eka_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Song tvtv anv go Padan Aram, go etahke Betuel ji li nde no jele nne. Song ko nkal o, go ellong abone Leban ba nkal, ye ji li mmonannyehn nne. ");
INSERT INTO eka_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nong Esowo bi kpi nsahm kpee fuul-a, fere lim-a wo jel njel, rur go nfange, tete wahn jol ajahbe tvv. ");
INSERT INTO eka_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Nong á ka-a, a etˈtohngo eja, elfuulu ni á ka Ebraham, eji a lˈtaare ndi nyio nyi a lene no anv ana njenne, ndi nyio nyi Esowo ka Ebraham.>> ");
INSERT INTO eka_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Owo Aisik kehm tumu Jekob re á song. Á kehm tahme go Padan Aram, goji Leban ji mmona Betuel. Leban ji li nnea Aram wo jolo mmonannyehna Rebeka, ji nnyehna Jekob, a Eso. ");
INSERT INTO eka_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Eso kehm sebe kahn re Aisik ebfuulu Jekob, fere tum-e tv go Padan Aram re á song ko nkal go, á tob sebe kahn re eji Aisik fuul-e no, á fere rehke Jekob re, <<Ka ko nnenkal no lohng go Kenan.>> ");
INSERT INTO eka_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Á fere wuk re Jekob ebwuk nde, a nnyehn, tahm go Padan Aram. ");
INSERT INTO eka_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Owo Eso kehm-e lennge re anebkal Kenan baa, joom ka Aisik nde eyebeltim ajehng ajehng. ");
INSERT INTO eka_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Á kehm tahme goji Ismeel, song baange mmona Ismeel ji jolo mmona Ebraham, no bo jo lung-e re Mahalad, ye ji jolo mmonannyehna Nebayod no nkal. Á ko-e budu akal bako ba á bele no. ");
INSERT INTO eka_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jekob kehm mehle o Beerseba asongo go Haran. ");
INSERT INTO eka_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Eji á song rehng edi ajehng, á kehm sake kang o, tibre njul eblahm. Á kehm rodo eltal bum noongo kunu esi lal. ");
INSERT INTO eka_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Á leeme nlem nyi á nyehne elkpakengbe ni jahme go ndi, lab tete rehng go elbung. Enjel nya Esowo jo wahre go elkpakengbe nio, bako jo badde na. ");
INSERT INTO eka_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Go ero elkpakengbe nio, Jehova yiimi o. Á kehm bungu re, <<Me wo li Jehova, ji li Esowo bi Ebraham nso, a bi Aisik. M bahk-a kake ndi nyi a nong a, a etˈtohngo eja. ");
INSERT INTO eka_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Etˈtohngo eja bahke jolo ana erikehndi go nrur, a bahke nyange, je go erede nfam, a ero nfam, go ejang ebobkal, a ejang eboblum. Go ega abo, a abo nya abon eba, wo anebe njini kpee bahke sehnge bel elfuulu. ");
INSERT INTO eka_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Me n li a na. M bahke jo baab-a edi ajehng ajehng ji a je no, m bahke feere a na ba go ndi nyia. Me wa nehm yake, tete n lim jio ji m ma nyam tong-a.>> ");
INSERT INTO eka_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Eji Jekob nyahme go ellu, á kehm bungu go ege eltim re, <<Etingitingi Jehova li edi jia, jol me n kahnem.>> ");
INSERT INTO eka_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Á jo fˈfahl, kehm bungu re, <<A wo li emennge emennge edie! Jol a edidi sang, etahk Esowo ji. A mbuga mi ejahbetul Esowo mi.>> ");
INSERT INTO eka_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Efungfu behre behre bi etoono efung, Jekob kehm rodo eltal ni á noongo no kunu esi, fere jahm ana ego, kehm yaange akehng wohngo ero eltal nio. ");
INSERT INTO eka_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Á lungu edi jio re Betel, wo wuku wuku bo jo lungu ejahbe jio re Lus. ");
INSERT INTO eka_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Owo Jekob kehm nyame enyam re, <<Esowo lˈjol aname, fere baab-m go eljen ni n fi a, fere ka-m nsol alehke re me n li, a nsol ebjing re me n kak, ");
INSERT INTO eka_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","tete n feere nseenga nseenge ba go etahk nsoo, Jehova bahke jolo Esowo ebame. ");
INSERT INTO eka_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Eltal nia ni m ma jahm a, ana ego, bahke jolo etahk Esowo, nsol nyi a bahk-m kake kpee, m bahk-a kake ejum ajehng go nsol ewubu. ");
INSERT INTO eka_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jekob kehm soro asi go ege eljen tete a ba rehng go ndi nyio nyi anebe ero nfam. ");
INSERT INTO eka_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Owo á kehm nyehne elbing alahb go emahng, a nlong ejoro na era nya noongo o, tibre owo bo jo ka enyam alahb elbing nio. Eltal ni bo ko bulu nnyo elbing alahb nio jolo egburu eltal. ");
INSERT INTO eka_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ngare nyi bo ma ko ejoro kpee ba wane o, mbaabe ebul kehm bannge eltal nio lennge nnyo elbing alahb, bo ka ejoro alahb, kehm kpe feere a eltal nio bulu. ");
INSERT INTO eka_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jekob kehm bahbe abaabe ebul re, <<Abonanee, gan wo ń lohng no?>> Bo kehm-e faange re, <<Wahr lohng go Haran.>> ");
INSERT INTO eka_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Á kehm kpe bahb bo re, <<N kpˈkahne Leban ji mmona Nahor jel-e noa?>> Bo kehm faange re, <<Ee, e kp-e kahne.>> ");
INSERT INTO eka_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Owo Jekob kehm bahbe bo re, <<Ye noa nob noba?>> Bo kehm-e faange re, <<Ee, á noa nob nob, nyehn Rasel mmon ewe ga kpˈbake a ejoro. ");
INSERT INTO eka_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Á kehm tongo bo re, <<Njul ga kpeke li ero, ngare ka rehng nyi kehn enyam bahke ba kono edi ajehng, kaan ejoro alahb, wahn feere a bo, bo song li nsol.>> ");
INSERT INTO eka_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bo kehm-e faange re, <<E nehm ma lim ano, tete bo lˈko atohkondi kpee ba edi ajehng fere bannge eltal nio lennge nnyo elbing alahb. Ngare nyio nyi e bahke ma ka bo alahb.>> ");
INSERT INTO eka_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ana á kpi mbungu mbungu, ano wo Rasel kehm soro ba rehng a ejoro nde, tibre á jolo mbaabe ebul. ");
INSERT INTO eka_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Eji Jekob nyehne Rasel mmona Leban ji jolo mmonannyehn no nnyehn ewe, a ejoro bi Leban, á kehm song bannge eltal nio lennge nnyo elbing alahb, fere ka ejoro Leban mmonannyehn nnyehn alahb. ");
INSERT INTO eka_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Owo Jekob kehm bingi Rasel, fere kehm kehme ellingi wahre wahre. ");
INSERT INTO eka_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ngare nyio yebtong Rasel re ye ekunu nde ji, fere tong-e re ye mmon no Rebeka wo. Á kehm beke song tong nde. ");
INSERT INTO eka_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ana Leban wuku bada Jekob mmona mmonannyehn, á kehm soro be song wan-e. Á kehm-e kake nnyo fere bing-e, kehm-e soro ko ba go ege etahk. Owo Jekob kehm-e tongo nsol kpee bade elkpin ene. ");
INSERT INTO eka_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Owo Leban kehm-e tongo re, <<Wo a me alung amehng ma.>> Eji Jekob ma kang a Leban nnyahng kohro kohro, ");
INSERT INTO eka_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Leban kehm bungu tong-e re, <<Anv, a bahk-m lohko loko na loko a na mbol mbol tib esi ji a li ekunu ejama? Tong-m ekun eba, ana m bahk-a jo kpi. ");
INSERT INTO eka_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Leban bele abon abal ba nkal. No nkul bo jo lung-e re Lia, no nse bo jo lung-e re Rasel. ");
INSERT INTO eka_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lia kpoolo amahr, wo Rasel jolo nkpooda ngbahme, fere nˈnob. ");
INSERT INTO eka_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Rasel wo jo kor Jekob. Á kehm bungu re, <<M bahke limi eltum ka-a go nnya esehma, eji a lˈka-m Rasel, mmon ewa no nse.>> ");
INSERT INTO eka_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Leban kehm bungu re, <<Ga nob re me n ka-a ye, sehnge re me rod-e ka nne nondiki. Jol aname a.>> ");
INSERT INTO eka_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Owo Jekob kehm loko Leban nnya esehma, eji á lˈko Rasel, jolo na are abon afung ba ka Jekob, tib go elkoro ni Rasel jo kor-e. ");
INSERT INTO eka_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Owo Jekob kehm bungu tong Leban re, <<Ka-m nkal ewame. Ngare enyame ebbiingi, n kpˈsebe re me n noongo a ne.>> ");
INSERT INTO eka_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Leban kehm lungu ane ba lene ejahbe re bo ba, kehm ba lim elkak elbal. ");
INSERT INTO eka_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Elgung ba kan a me, á kehm rodo Lia, mmon ewe no nkul ka Jekob, Jekob soro noongo a ne. ");
INSERT INTO eka_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Leban rodo monse nkal no jolo nlokeltum ewe, no bo jo lung-e re Jilpa, ka mmon ewe re á jol nlokeltum ewe. ");
INSERT INTO eka_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Efungfu se kan a me, nyehn Lia nong a Jekobe! Jekob kehm bungu tong Leban re, <<A elkohn ejum ajii á ma-m lim ana? Rasel sang n lok-a no re wo ka-m yea? Jenji wahnge á ma-m nehm?>> ");
INSERT INTO eka_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Owo Leban kehm-e faange re, <<Go egahre eljini, e kpehme gbo mbang rod mmon no nse ka go elbal, kehm tange mmon no nkul. ");
INSERT INTO eka_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Nong erahde ji elkak elbal nia mal, owo e bahk-a kake Rasel a lˈkpe lim eltum go nnya esehma. ");
INSERT INTO eka_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jekob lohko lim ano. Eji á ma mal erahde ji elkak elbal Lia, owo Leban kehme kake Rasel mmon ewe go elbal. ");
INSERT INTO eka_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Leban rodo monse nkal no jolo nlokeltum ewe, no bo jo lung-e re Bilha ka Rasel mmon re á jol nlokeltum ewe. ");
INSERT INTO eka_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Owo Jekob kehm tob noongo a Rasel, á jo kor-e sehnge Lia. Á kpe lim eltum ka Leban go nnya esehma. ");
INSERT INTO eka_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Eji Jehova nyehne no re Lia joom kor nlum we, á kehm-e lennge ala njel. Rasel jolo ngum. ");
INSERT INTO eka_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lia kehm sake ela, jel mmon no nlum. Á gung-e mbing re Ruben, tib á bungu re, <<Jehova ebnyehn erem ebame. Anv, m bahke lohko kor nlum ewame.>> ");
INSERT INTO eka_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Á kehm kpe sa ela. Á jele kan mmon no nlum a, á kehm bungu re, <<tib Jehova wuku re n nehme kor nlum ewame, ji ji wahnge á ma-m kpe ka mmon noa.>> Wahng ka á lung-e re Simion. ");
INSERT INTO eka_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Á kehm kpe sa ela behko. Eji á jele mmon no nlum, á kehm bungu re, <<Anv, nlum ewame bahke jolo bad bad aname, tibre me n jel abon ara ba nlum ka-e.>> Bo gung-e mbing re Levayi. ");
INSERT INTO eka_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Á kehm kpe sa ela. Eji á jele mmon no nlum, á kehm bungu re, <<Anv, m bahke tehke Jehova.>> Owo á kehm-e gungu mbing re Juda. Á kehm rahke njel. ");
INSERT INTO eka_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Eji Rasel nyehne re á nehme jel mmon awohng awohng ka Jekob, á bele eteelala a mmonannyehn, á kehm bungu tong Jekob re, <<Ka-m abon, tohko jol ano, m bahke kpoko!>> ");
INSERT INTO eka_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jekob atahng kehm-e rake tob-e, á kehm-e tongo re, <<Me wo ma ko nji nyi Esowoa, ye ji ma-a lim re wo kˈjel-a? ");
INSERT INTO eka_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Owo Rasel kehm bungu re, <<Nyehn Bilha nloketum ewame ga, song kang a ne eji á lˈjel abon ka-m, toono o ege n tob bom ebangennahb. ");
INSERT INTO eka_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rasel kehm yake Bilha á jol nkala Jekob, Jekob kehm song kang a ne, ");
INSERT INTO eka_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","á kehm sake ela jel mmon no nlum ka-e. ");
INSERT INTO eka_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Owo Rasel kehm bungu re, <<Esowo ebkim eno ka-m, fvfo yeb wuk elgboongo ename, fere ka-m mmon no nlum.>> Tib esi jia, á gung-e mbing re Dan. ");
INSERT INTO eka_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha nlokeltum a Rasel kehm kpe sa ela, jel etoono mmon no nlum ka Jekob. ");
INSERT INTO eka_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Owo Rasel kehm bungu re, <<Me n bel egburu enok a mmonannee no nkal, me n nok ga, Rasel kehm-e gungu mbing re Naftali. ");
INSERT INTO eka_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Eji Lia nyehne re yeb rahke njel, á fere rod nlokeltum ewe no nkal Jilpa ka Jekob á jol nkal. ");
INSERT INTO eka_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nlokeltuma Lia, Jilpa jele mmon no nlum ka Jekob. ");
INSERT INTO eka_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lia kehm bungu re, <<A wo li enobesi.>> Á kehm-e gungu mbing re Gad. ");
INSERT INTO eka_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nlokeltuma Lia, Jilpa kpe jel etoono mmon no nlum ka Jekob. ");
INSERT INTO eka_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lia kehm bungu re, <<Elkohn eyebatahng ji m ma bel ji nse sang. Anebkal bahke jo lung-m re, eyebatahng. Owo wahnge á gung-e mbing re Aser. ");
INSERT INTO eka_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ngare nyi bo jo kiimi nkohl nyi bo kpo lung re wid, Ruben kehm tahme je go emahng song wob eti ji bo kpo lung re mandrak ba ka nnyehn Lia, Rasel kehm tongo Lia re, <<Titi tob yehke abon mandrak mmon ewa ka-m me. ");
INSERT INTO eka_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lia kehm-e faange re, <<Wa-a ka tiki gbal eji a ma-m taare nluma? A bahke kpe taare mandrak nyi mmon ewama? Rasel kehm bungu re, <<Ebnob sehng, atv ma lela nong á kang ega tib esi eti mandrak mmon ewa. ");
INSERT INTO eka_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Eji Jekob kehnge egbe ba elgung, Lia kehm song kpir-e, kehm-e tongo re, <<Lela a bahke kange ename, tibre me n ko eti mandrak mmon ewame ka ekun re wo kang aname. Jekob lohko kang a ne atv mao. ");
INSERT INTO eka_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Esowo wˈwuk ji Lia bungu no, á sa ela jel mmon no nlum ka Jekob no biingi abon alon. ");
INSERT INTO eka_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lia kehm bungu re, <<Esowo ma-m tuuru eji m ma ka nlum ewame nlokeltum ewame no nkal.>> Owo á kehm-e gungu mbing re Isakar. ");
INSERT INTO eka_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lia kehm kpe sa ela jel mmon no nlum ka Jekob, mmon noa wo biingi abon nlum na arakera. ");
INSERT INTO eka_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Owo Lia kehm bungu re, <<Esowo ma-m yare ka ayare nya nno. Anv nlum ewame bahk-m kpunu, tibre me n jel abon arakera ba nlum ka-e.>> Lia kehm-e gungu mbing re Jebulon. ");
INSERT INTO eka_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Eji kpe kang a, Lia kpe jel mmon no nkal, bo jo lung-e re Dayina. ");
INSERT INTO eka_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Esowo kehm buumu Rasel, wuung-e atung, fere lennge ejˈjele eje. ");
INSERT INTO eka_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Á sa ela jel mmon no nlum, á kehm bungu re, <<Esowo ma-m yehke go ndon.>> ");
INSERT INTO eka_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Á gung-e mbing re Josef, kehm bung re, <<Nong Jehova kpe-m budu mmon no nlum nondiki.>> ");
INSERT INTO eka_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Eji Rasel jele Josef, Jekob kehm tongo Leban re, <<Tum-m me n song kehnge go egame ejahbe. ");
INSERT INTO eka_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ka-m akal ebame, a abon abon, bo ba wahnge m ma-a loko, me n tahm ejame. A kpˈkahne elkohn eltum ni m ma lim ka-a. ");
INSERT INTO eka_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Leban kehm-e tongo re, <<Lˈjol re a kpˈkpi eyebatahng aname, titi tohko kpe jol aname, tibre me bu kahn re, Jehova ma-m fuulu tib esi eja. ");
INSERT INTO eka_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Á kpe bung budu re, <<Tong-m ana m bahk-a kpiki, me n kpi-a.>> ");
INSERT INTO eka_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jekob kehm-e tongo re, <<Wob kahn eltum ni m ma lim ka-a, ana atohkondi enya li nob nob, fere nyˈnyab go egame abo. ");
INSERT INTO eka_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Atohkondi enya jolo ntiil, anv bob rur gbalee, Jehova ma-a fuulu go edi ajehng ajehng ji m ba jol. Anv, ngare anyii fuumu re me n tob bom ejum alimi ka elname? ");
INSERT INTO eka_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Leban kehm-e tongo re, <<Anv me n ka-a jen? Jekob kehm-e faange re, <<Kama ka ejumjum.>> A lˈfere lim ejum ajehng jia ka-m, m bahke soro asi jo le atohkondi enya, fere jo kpur bo. ");
INSERT INTO eka_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nong lela me n feede go ellong atohkondi enya kpee, fere jak ejoro bi kpi anyono, a bo ji kpi adebbe, a abon njoro ba kpˈremme, a ebul bi kpi anyono, a bo ji kpi a adebbe, bo ba bahke jolo nsehng enyame. ");
INSERT INTO eka_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Behnjehle, ngare anyehng anyehng nyi a lˈba nyehn ana a kpi-m no, a bahke kahne re n jolo etingi nne. Mbul baange anyehng anyehng nyi li nyˈnyame, nyi ki kpi anyono, afii adebbe, afii mmona njoro awohng awohng no ki remme, bahke lohngo re me n v na. ");
INSERT INTO eka_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Leban kehm bungu re, <<Me n taame, nong jol ana a ma bung.>> ");
INSERT INTO eka_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Efung bˈnehm o Leban kehm yehke afahmbul kpee nya kpi anyono, a ba bele adebbe, a ebul baange kpee bi kpi adale, a bi kpi adebbe, bo ji kpi abarebare adale, a ejoro kpee bi kpˈremme, faake abo kpee kak abon ebe go abo. ");
INSERT INTO eka_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Leban a abon ebe mehle eljen ejum nfung era, tahm Jekob sa edi ji á jolo no. Jekob sa soro asi jo kpur erik atohkondi nya Leban. ");
INSERT INTO eka_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Fvfo Jekob song kiimi ajoobo abˈbo nti, go nti nyi bo kpo lung re poplar, Almon, a eplen, go abˈbo nyao kpee, laade akpake nyandiki, eji bo lˈnyehn nnyam eti nyi kpˈbare go elatahk. ");
INSERT INTO eka_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Á kehm rodo abˈbo nyao kpee song bum kohlo go ejum ji atohkondi nyao kpo wo alahb, eji lˈjol songo songo wane go ebo mbuksong atohkondi, ngare nyi atohkondi kpo ba alahb wo owo bo kpo kuumu atemtem, ");
INSERT INTO eka_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","bo kpo ba gbehl abˈbo nyao go mbuksong jo kuumu atemtem, jo jel abon ba kpi anyono, adebbe, a adale. ");
INSERT INTO eka_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jekob rodo abon mbul bao bum eje eje, á limi bo jehko kpee jo seenge atohkondi nya Leban nya kpi anyono, a remme, eji bo jo kuumu atem. Ano wo á limi no yehke atohkondi nya bahke jolo ka-e á semmem bo go ellong enyam bi Leban. ");
INSERT INTO eka_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ngare anyehng anyehng nyi atahntahn enyam bi nkal, lˈba elkuumu atemtem, Jekob jo rodo abˈbo nti nyao yahke go edi ji bo kpo wo alahb, go ebo esamahr, eji bo kpˈkuumu atemtem kohlo abˈbo nti. ");
INSERT INTO eka_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Wo lˈfere jol re enyam bio eko bo kpimm, Jekob nehm sahd abˈbo nyao o. Ano wo bo ji ki bel eko jo jol ba Leban, bo ji jolo eko eko jol ka Jekob. ");
INSERT INTO eka_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Go mbang nyia nyi Jekob koo gbo afang, nya sahb gbˈgbal, fere bel ellong atohkondi, alokeltum ba nkal, a ba nlum, akamel, a ebvankang. ");
INSERT INTO eka_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jekob kehm wuku re, abone Leban ba nlum kpˈbungu re, <<Jekob ebrod ejum ajehng ajehng ji nsoo ewahre kpi no, afang kpee nya Jekob ma bel, lohng go nsol nyi nsoo ewahre, ");
INSERT INTO eka_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jekob sebe kahn re eljini ni Leban jolo a ne wuku wuku, anv ebyaange. ");
INSERT INTO eka_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Jehova kehm tongo Jekob re, <<Feere song go ndi a nso, go nnahb enya, m bahke jolo a na.>> ");
INSERT INTO eka_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Owo Jekob kehm tumu ellum tv Rasel abola Lia re bo lohng ba kpir-e go emahng edi ji atohkondi enye li no. ");
INSERT INTO eka_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Á kehm tongo bo re, <<Me n seb kahn re eljini ni nso ewahne kpi no aname anv ebyaange, kpeem li ana wuku wuku jolo no, wo Esowo bi nso ewame noa aname. ");
INSERT INTO eka_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Wahn kpˈkahne re me n lim eltum ka nso ewahne a eko eko ejame, ");
INSERT INTO eka_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","jol tvtv o, nso ewahne ma-m nehm fere yaange eltuuru ename nkpel na ewubu. Wo Esowo taamem re á lim-m ejum. ");
INSERT INTO eka_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Leban lˈfere tong re atohkondi nya kpi adale nya nya li eltuuru ename, atohkondi kpee jo jele nya kpi adale, afi á fere tong re bo ji kpi anyono, bo ba li eltuuru ename, atohkondi kpee jo jele bo ji kpi anyono. ");
INSERT INTO eka_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Owo wahnge Esowo ma taare nso ewahne atohkondi feere a nya ka-m. ");
INSERT INTO eka_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ngare nyi atohkondi kpo sa ela, n leeme nlem n nyehne re, afahmbul nya jo kuumu ebul baange bo bele anyono, adebbe, a adale. ");
INSERT INTO eka_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Enjel nyi Jehova tong-m go nlem re, <Jekob,> N kehm faange re, <Nyehn me ga.> ");
INSERT INTO eka_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Enjel nyio kehm bungu re,<<Seenge wo nyehn re, afahmbul kpee nya kpˈkuumu akal, bo jehko bahke bele anyono, bo jehko bel adebbe, bo jehko bel a adale, tibre me n nyehn nsol kpee nyi Leban jo lim-a. ");
INSERT INTO eka_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Me wo li Esowo bi Betel, edi jio ji a wohngo akehng go ego, jˈnehm ji a nyame no tong-m. Tahm anv anv wo yake ndi nyia, fere song go ega ejahbe.>>> ");
INSERT INTO eka_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Owo Rasel abola Lia kehm faange re, <<Fono anv wahr kpˈkpe kpi ebo abehng abehng go nsol elehke elkv nyi etahk nsoo ewahr-a? ");
INSERT INTO eka_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Anv, á wahr kpehme ko ana ajahmjahma? Saam go elgungu no á ma-r gungu, yeb tob li kpee ji bo ka go egahre esi. ");
INSERT INTO eka_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Etingitingi ji re nsol afang nyi Esowo ma taare nsoo ewahre li ka wahr a abon ebahre. Fvfo lim ajehng ajehng ji Esowo tong-a no. ");
INSERT INTO eka_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Owo Jekob kehm rodo abon ebe, a akal ebe kunu go akamel, ");
INSERT INTO eka_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","tahm a bo, atohkondi enye gbo-e mbang, á tahma nsol kpee nyi á bele no o Padan Aram, asongo goji nde Aisik go ndi nyi Kenan. ");
INSERT INTO eka_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Eji Leban tahme re á song kpud ejoro ebe anyar, Rasel v alokelom etahk nde. ");
INSERT INTO eka_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Fvfo Jekob nehme Leban nnea Aram eji á ki-e tong re, á kpˈtahme. ");
INSERT INTO eka_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jekob bee a nsol kpee nyi á bele no, song siiri aya Yufrat, asongo go ejahbe ewong ji Gilied. ");
INSERT INTO eka_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Go nfung era, bo kehm tongo Leban re Jekob ebbe fio. ");
INSERT INTO eka_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Leban kehm rodo abonanyehn ebe, bo jo kam Jekob go nfung na esehma song bob-e go ejahbe ewong ji Gilied. ");
INSERT INTO eka_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Esowo kehm ba kpiri Leban nne no lohng go Aram go nlem atv, kehm-e tongo re, <<Kunu ekpu, ka tiki bung ejum ajehng ajehng bada Jekob, afi jolo ji kpˈnobo, afi ji kpˈsabe.>> ");
INSERT INTO eka_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jekob tohko si ebehre eje go ejahbe ewong ji Gilied, Leban kehm ba kpir-e. Leban a abonanyehn kehm tob ba si abehre nya bo o. ");
INSERT INTO eka_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Owo Leban kehm tongo Jekob re, <<Jenji wahnge a ma-m lim ana me? A ma-m nehm, wob kpu abon ebame, ana nne bobo ane go ebta ba bum eju. ");
INSERT INTO eka_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nˈnan a kehm weele na be fere nehm-m, nˈnan a ki-m tong eji n lˈtuma go eyebatahng, a ekahn ase ji bo jol jo kub asoongo, a akpasake toon-a. ");
INSERT INTO eka_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Jol a nongem re me n bingi abon abon ebame nnyo, a yefono abon ebame ba nkal, fere tong bo re wahn songo. Woblim egboongo ejum. ");
INSERT INTO eka_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","N kpˈkpi nsahm nyi m bahk-a ma lim ejum, wo nyaane atv Esowo bi nso tong-m re, <<Kunu ekpu, ka tiki bung ejumjum bada Jekob, afi jolo ji kpˈnobo, afi jolo ji kpˈsab. ");
INSERT INTO eka_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Anv wob tahm eja, tibre ma-a kor re wo feere go etahk nso, jenji wahnge a kehm vohko asowo enyame? ");
INSERT INTO eka_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jekob kehm faange Leban re, <<N jo fˈfahl, tibre n tiri re a bahk-m taare abon eba ba nkal go eko. ");
INSERT INTO eka_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","A lˈfere nyehn nne awohng awohng no rodo asowo enya a bahke kpoko. Go ellong nnahb enyame, kpur antahng wo nyehng joare ejum eja ajehng ajehng jia aname, lˈfere jol ano rod. Jekob kahnem re Rasel wo v asowo nyao. ");
INSERT INTO eka_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Leban kehm yele ebehre ji Jekob, a ji Lia, go ji aloketum abal bao ba nkal, ejumjum á nyˈnehm. Eji á lohngo go ebehre ji Lia, á kehm song yel goji Rasel. ");
INSERT INTO eka_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ngare nyio Rasel ebrod asowo etahk nde kunu go njahm nyi ekamel rod ejum bo kpo koongo ekamel go njahm bulu ji tv. Leban feede ejum ajehng ajehng o ebehre kpee á nyehnem ejumjum. ");
INSERT INTO eka_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasel kehm tongo nde re, <<Atahng ki-a rak nsoo re m maam mehl yiimi go ega esamahr, me ga me n gbo alung.>> Leban feede kpee á tikem nyehn asowo etahk eje. ");
INSERT INTO eka_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jekob atahng kehm-e rake, á rod Leban song kak elam, kehm bahbe Leban re, <<Ebi ajii m ma lim? Abiafem anyaa m ma lim, nya wahnge a kp-m bimi abake? ");
INSERT INTO eka_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Anv eji a feede go egama nsol, jenji a ma nyehn ji lohng go ega etahk? Lohng aji a esamahr nnahb enyame, a nnahb enyame, bo lam-r, me a wahra na. ");
INSERT INTO eka_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Me n jol a na go nnya na eltahl, ejoro eba, a ebul eba, anyehng anyehng tikem fumu, jol n tikem li nkom anyehng anyehng go ellong atohkondi enya. ");
INSERT INTO eka_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","N tikem ko nnyam enya anyehng anyehng ba a nyi re, ebi nnyam me-e jaake, me wo jo nyehn erem bio antahn, anv a kpˈsebe re me n gal-a ji bo v a njul afii bo v atv. ");
INSERT INTO eka_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ji jo jol aname ji a, njul jo ya-m ngara njul, alohk jo fil-m ngare atv, ellu n joom lal. ");
INSERT INTO eka_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ana wo jolo aname go ejum nnya eltahl nyi n jolo go ega etahk. N limi eltum ka-a go ewuba nnya eni tib abon eba ba nkal, fere kpe ko nnya erakera jo kpur atohkondi enya, á fere yaange eltuuru ename nkpel na ewubu. ");
INSERT INTO eka_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ki li re Esowo bi nsoo, Esowo bio bi Ebraham, ye ji Aisik jo fahl-e ki jol aname, a jol-m lohko tum n kehnge abo abo. Wo Esowo ebnyehn ana jo riid-m, fere jo nyehn ji n jo ko abo enyame lim, atv ma nyaane Esowo kak-a erehke.>> ");
INSERT INTO eka_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Leban kehm faange Jekob re, <<Anebkal baa abon ebame ba nkal ba, abon baa, abon abon ebame ba, atohkondi nyaa, atohkondi enyame nya. Nya a kpˈnyehne a kpee a nyame nya, fono anv jenji m bahke limi lela a abon ebame ba nkal, afi abon ba bo ma jel? ");
INSERT INTO eka_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Anv wahr lim egbanngalung, jol ejum ntianse ka wo, a me.>> ");
INSERT INTO eka_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Owo Jekob kehm rodo eltal lo ana ego. ");
INSERT INTO eka_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jekob kehm tongo nnahb enye re, <<Kpu-n atal ba a nya, bo kehm solo atal ba luk ebim, bo ji go nkpe ebim atal jo li nsol. ");
INSERT INTO eka_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Leban lungu edi jio re, Jegar Sahaduta, Jekob tob lungu edi jio re, Galed. ");
INSERT INTO eka_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Leban kehm bungu re <<Ebim atal jia ebjol ntianse ka me a wo lela.>> Owo wahnge bo jo lung re Galed. ");
INSERT INTO eka_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Fvfo bo jo tob lungu re Mijipah, tibre á bungu re, Nong Jehova jo baab-r eji e ma yaame atemtem. ");
INSERT INTO eka_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","A lˈfere sab abon ebame ba nkal go elfili, afii a lˈsong ko akal bandiki sehnge abon ebame baa ba nkal jol afi nnene jolem, buumu re Esowo bi li ntianse enya, a me. ");
INSERT INTO eka_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Leban tob tongo Jekob re, <<Nyehn ebim atal ga, tob nyehn eltal ga m ma lo ana ego ka wo a me. ");
INSERT INTO eka_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ebim atal jia ji li ntianse, ego jia ji tob li ntianse re me nehm tiki siiri ebim atal jia rehng ega ejang ba lim-a ejum, re wo fvfo, a nehm siiri ebim atal jia a, a ego jia ba rehng ga egame ejang ba lim-m ejum. ");
INSERT INTO eka_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nong Esowo bi Ebraham, a Esowo bi Nahor, Esowo bio bi babnde ebo lam-r a wahra na.>> Owo Jekob kehm koko nwongo go mbing nyio nyi Esowo bio bi Aisik nde kpo fahl. ");
INSERT INTO eka_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jekob limi njom o ejahbe ewong, fere tiingi nnahb enye re bo ba li nsol. Eji bo ba li nsol bo sa kang o atv mao. ");
INSERT INTO eka_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Njahm efungfu, efungfu behre behre Leban kehm bingi abon abon ebe, a yefono abon ebe ba nkal fere fuulu bo, kehm feere kehnge. ");
INSERT INTO eka_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jekob kehm tob tahm eje, babenjel nya Esowo kehm-e kpiri go mbang. ");
INSERT INTO eka_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Eji Jekob nyehne bo, á kehm bungu re, <<A wo li ebehre ji Esowo.>> Á kehm lungu edi jio re Mahanayim. ");
INSERT INTO eka_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jekob tumu atiingi etib re bo gbo-e mbang tv Eso mmonannyehn, go ndi nyi Seir ji li ejahbe ji Edom. ");
INSERT INTO eka_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Á tubu bo elle re, ana wo ḿ bahke tongo nsoo ewame Eso: <Jekob nlokeltum ewa re, me n jol a Leban, fere sa a ne tete rehng anv. ");
INSERT INTO eka_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Me n bel efong, ebvankang, ejoro, ebul, alokeltum ba nlum, a ba nkal. Anv n kpˈtumu etib tv wo ntubesi ewame, re me lub fil-a ndon go ega esamahr. ");
INSERT INTO eka_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Eji atiingi etib feere no ba kpiri Jekob, bo tong-e re, <<Wahr ebje goji Eso mmonanne, anv á kpˈbake ba kpir-a, a aneblum atahltahl ba kp-e toono.>> ");
INSERT INTO eka_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jekob bele egburu elfahle gbalee,eko fere jo tane, owo á kehm yabe ane ba jolo a ne go nlong na ebal, á tob yabe ebul ebe, akamel, a ebvankang. ");
INSERT INTO eka_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Á tiri re, <<Eso lˈfere ba nok a ellong anehng, ellong ni lˈsa, bo lub be for. ");
INSERT INTO eka_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Owo Jekob kehm kake ero re, <<O Esowo bi nsoo Ebraham, Esowo bi nsoo Aisik, O Jehova, wo ji tong-m re, <Feere song go ega ejahbe, go ega ebangenahb, m bahke limi nob a na.> ");
INSERT INTO eka_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Me n tohkem fˈfuumu go nnoobo eljini, a ekakesehk ji a ma tib me nlokeltum ewa, m bele ebti efilebo bi bi, eji n siiri aya ma Jodan maa, wo anv me n jol nlong ebal. ");
INSERT INTO eka_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","N kpˈkake ero re, wo tahr-m go abo nya mmonanee Eso, tibre n kpˈfahle re á bahke ba nok aname, tob nok a bab nnyehn, a abon abon. ");
INSERT INTO eka_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Wo wo ma bung re, <Etingitingi m bahke limi nob a na, m bahke fere lim etˈtohngo eja jol ana erikehndi aya bi nnene lˈkˈma fange.>>> ");
INSERT INTO eka_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jekob kange o atv mao, nsol enye nyi á bele no, á yehke o re á song yare mmonannyehn Eso: ");
INSERT INTO eka_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ebul baange atahl awubu, efahmbul eltahl, ejoro atahlawubu, ekom eltahl, ");
INSERT INTO eka_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","eltahl ekamel ebwubu bi jolo akal budu abon, edahmagbudu atahl abal, nfong ewubu, akal ebvankang jolo eltahl, alum jolo ewubu. ");
INSERT INTO eka_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Jekob yake bo kpee kak alokeltum ebe go ebo re bo jo kpur bo, nne awohng awohng no jo jen a bo, bele ellong nˈne, á kehm tongo alokeltum ebe re, <<Gbo-m wahn mbang, jo jenen wahn jo ka ane baa, a enyam eyake.>> ");
INSERT INTO eka_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Á tubu nne no gbo bo mbang elle re, <<Mmonanee Eso lˈkpir-a fere bahb re, <Wo li ka nne awoo, fvfo gan wo a kpˈtahme? Nne awoo kpi enyam bi li-a go mbuksong o?> ");
INSERT INTO eka_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Á bahk-e tongo re, <<Enyam bio bi Jekob nlokeltum ewa bi, ayare nya á ma tum tv ntubesi ewe Eso nya a. Yefono kpˈbake go njahm. ");
INSERT INTO eka_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jekob tob tubu etoono ane abal, a etoono ane ara elle, a ane bako kpee ba kpˈtoono ane ba kpo jen a enyam re, <<Wahn ane kpee bungen nnyo nnyo amehng tong Eso ń lˈwan-e go mbang. ");
INSERT INTO eka_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Jo kunen ekpu wahn bung re, <Yefono Jekob nlokeltum ewa kpˈbake toon-r go njahm. Jekob jo tiri re, <<M bahk-e gono go ayare nya n kpˈtumu tv-e, n lˈnyehne, fundiki á bahk-m koko.>> ");
INSERT INTO eka_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Owo Jekob kehm tumu ayare nyao bo gbo mbang a nya, yefono sa kang o ebo ebehre. ");
INSERT INTO eka_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Atv mao Jekob kehm mehle rod akal ebe na abal, a alokeltum ba nkal abal, go abon ebe, ewubu a mmon awohng, kpee ba nlum bo song siiri ebgba bi bo jo lung re Jabok. ");
INSERT INTO eka_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ngare nyi á ma tum bo siiri ebgba, á tob tumu nsol enye kpee. ");
INSERT INTO eka_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jekob sa ntahngtahng, owo nnenlum kehm ba gong ebrahng a ne tete efungfu se. ");
INSERT INTO eka_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Eji nnenlum noo nyehne re á nehme mal a ne, á kehm kooro Jekob go ebrudu, ebrudu soro radde, eji á jo gong ebrahng a ne. ");
INSERT INTO eka_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nnenlum noo tong-e re, <<Nong me n song tibre efungfu yahke se.>> Jekob kehm faange re, <<Me wa-a nehm yake á song tete á fuul-m. ");
INSERT INTO eka_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nnenlum noo kehm-e bahbe re, <<Mbing enya mee?>> Á kehm-e faange re, <<Me Jekob wo,>> ");
INSERT INTO eka_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nnenlum noo kehm bungu re, <<Bo wa-a nehm kpe jo lung re Jekob, bo bahke fere jo lung-a re Isreel, tibre wob nok a Esowo, tob nok a ane fere ga bo.>> ");
INSERT INTO eka_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jekob kehm bungu re, <<Titi tong-m mbing enya.>> Nnenlum noo kehm bungu re, <<Jenji wahnge a kehm bahbe mbing enyame? Nnenlum noo kehm-e fuulu o. ");
INSERT INTO eka_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Owo Jekob kehm lungu edi jio re Peniel. Á kehm bungu re, <<Tibre me n nyehn Esowo gbul gbul gbuul, tvtv o yebkpe kuuru elkpin aname.>> ");
INSERT INTO eka_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Njul rehnge ero tv-e o ana á sehnge Peniel, á fere jo feebe na tibre ebrudu ebradde. ");
INSERT INTO eka_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Owo wahnge anebe Isreel kˈlˈli njahb nyi li kohlo ebrudu, tibre ebrudu bi Jekob rˈradde eji nnenlum noo koor-e kohlo o njahb ebrudu. ");
INSERT INTO eka_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jekob kehm tabe amahr nyehn Eso kpˈbake a aneblum atahltahl ebe, Jekob kehm yabe abon ebe, bako jolo a Lia, bako jolo a Rasel, bako jolo a alokeltum ebe ba nkal na abal. ");
INSERT INTO eka_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Á tongo alokeltum ba nkal bao bo gbo mbang a abon ebo, Lia a abon ebe bo toono, Rasel abola Josef bo ba kahle njahm. ");
INSERT INTO eka_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yefono antahng gbo mbang, ana á jo jen asongo goji mmonannyehn á gongo go ndi nkpel esehma. ");
INSERT INTO eka_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Eso bee song kpiri Jekob, fere bing-e, á kpehre abo go emel walle. Bo ane abal abal kehme ellingi. ");
INSERT INTO eka_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Owo Eso kehm seenge nyehn anebkal a abon, kehm bahbe Jekob re, <<Ane a ba a, ba li a na? Jekob kehm faange re, <<Abon ba Esowo ma lim nnoobo ka me nlokeltum ewa ba a. ");
INSERT INTO eka_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Owo alokeltum ba nkal a abon ebo kehm tob jeere ba kohl-e gong ndi. ");
INSERT INTO eka_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Etoono, Lia a abon ba gong go ndi. Esˈkohro Josef a Rasel, bo fvfo tob ba gong ndi. ");
INSERT INTO eka_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Eso kehm bahbe re, <<Nlong atohkondi nyaa kpee nya m ma wane a lohngo renan?>> Jekob kehm faange re, <<Li tib eji ntubesi ewame lˈbel eyebatahng aname. ");
INSERT INTO eka_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Eso kehm bungu re, <<Me n kpˈkpi wuku wuku gbalee mmonannee, bum ji a kpi no jol ka wofono antahng. ");
INSERT INTO eka_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jekob kehm faange re, <<Eˈee, titi joare a kpˈkpi eyebatahng aname, ko ayare nyaa go egame abo. Re me n nyehn esamahr eba, li ana m ma nyehn esamahr bi Esowo, Anv eji a ma-m ko eyebatahng. ");
INSERT INTO eka_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Titi ko ji bo ma ko ba bum-a go alata, tibre Esowo eblim nnoobo gbalee ka-m, me n bel nsol kpee nyi n kpˈsebe.>> Tib eji Jekob jo tiki ten, Eso kˈko nsol nyio. ");
INSERT INTO eka_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Owo Eso kehm bungu re, <<Nong wahr tahm, m bahke jene a na. ");
INSERT INTO eka_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jekob kehm-e faange re, <<Ntubesi a kpˈkahne re abon kpˈseke, fvfo li re me n kpur ejoro, adahmagbudu nya kpˈyabe abon ebo, nne lˈga jen a bo elwaare jol efung kohro kohro enyam bia kpee bahke kpoko. ");
INSERT INTO eka_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ntubesi ewame wo gbo nloketum ewa mbang, m bahke jo jen bembem a enyam, a abon baa, tete m ba rehng goji ntubesi ewame go Seir.>> ");
INSERT INTO eka_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Eso kehm bungu re, <<Nong me n tahm aneblum ebame bako sa-a a.>> Jekob kehm bungu re, <<Nsehng limm re wo kpe gbiingi elna>> N lub sebe na seb re ntubesi ewame bel eyebatahng a aname. ");
INSERT INTO eka_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Owo Eso kehm bomo eljen ene efung bio asongo go Seir. ");
INSERT INTO eka_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jekob tob tahme go Sokod, go wo á song lim edi jol fere tob lim edi ji enyam ebe bahke jo kang. Owo wahnge edi jio bo jo lung re Sokod. ");
INSERT INTO eka_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Bomo ana Jekob lohng go Padan Aram á rehnge o ejahbe Sekem nob nob go Kenan ba sa jol go nkpe ejahbe jio. ");
INSERT INTO eka_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Jekob gunu erohko ndi goji abone Hamor nde no Sekem ka akpohko asilva atahlalon. Owo á si ebehre ji á jolo no. ");
INSERT INTO eka_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Jekob kehm limi egudu njom, fere lung edi jio re, El Elohe Isreel (ji lohngo re Esowo bi Isreel kpˈgbale). ");
INSERT INTO eka_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Efung abehng Dayina, mmon no nkal no Lia jele no ka Jekob kehm lohngo tahm elbong goji anebkal ba lene ejahbe jio. ");
INSERT INTO eka_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hamor ji nnea Hiv, ye ji jolo ntubesi ejahbe, á bele mmon no bo jo lung-e re Sekem, eji Sekem nyehne Dayina, á kehm-e rodo tahm a ne, song bobo sahb nne. ");
INSERT INTO eka_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Eltim ene kpee lohngo toono Dayina mmona Jekob. Mmonse nnenkal noa kor-e sehng, á jo bungu a ne yebe yebe. ");
INSERT INTO eka_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sekem tongo Hamor nde re, <<Ko mmonse nnenkal noa ka-m, á jol nkal ewame. ");
INSERT INTO eka_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Eji Jekob wuku re Dayina mmon ewe no nkal bo me-e rannge, abon ebe ba nlum jolo go emahng jo kpur atohkondi, owo á belle eje tete bo kehnge. ");
INSERT INTO eka_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor nde no Sekem kehm tahme song bung a Jekob. ");
INSERT INTO eka_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ngare nyia abone Jekob ebtob kehnge na kehnge, soro ba wuk ji ma lim, atahng rake bo sehng, sahb rˈrak bo tibre Sekem eblim ejum esono go Isreel, eji á noongo a mmona Jekob ejum ji ki fuumu re nne lim. ");
INSERT INTO eka_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor tongo bo re, <<Sekem mmon ewame ebyehke eltim ene kunu mmon ewa no nkal, titi yak-n ye, á jol nkal ewe. ");
INSERT INTO eka_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Semm-n elbal anahre, Kaan wahr abon ebahne ba nkal, wahr bahke tob ka-n abon ebahre. ");
INSERT INTO eka_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ḿ bahke ba lene tob-r, ndi nyia nong gbalee ka-n. Ba jolen, wahn jo jen are, fere bel ndi gbalee. ");
INSERT INTO eka_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Owo Sekem kehm tongo ndea Dayina a abonanyehn re, <<Nong me n fil-n ndon go egahne esamahr. M bahk-n kake ejum ajehng ajehng ji ń lˈbahb. ");
INSERT INTO eka_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tong-m wahn ekun elaame, a ayare nya kpˈsahb gbˈgbal nya bahk-n koro, m bahke kpiki ejum ajehng ajehng ji ń lˈtong-m. Sehngem re, lub ka-m wahn mmonse nkal noa, á jol nkal ewame. ");
INSERT INTO eka_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tib eji Dayina mmonannyehn ebo ma rannge, abone Jekob jo bungu alum enehm nyaa tong Sekem a Hamor nde abo. ");
INSERT INTO eka_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Bo tongo bo re, <<Wahr nehm ma yake mmon ewahre no nkal ka nnenlum no kala yehke nrur, ejum ana jia bahke jolo esono sehng ka-r. ");
INSERT INTO eka_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","E bahke ma taame tv-n ń lˈlim ejum ajehng jia ji ji, ḿ bahke jolo ana wahr, ń bahke yehke aneblum kpee nrur. ");
INSERT INTO eka_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Owo wahr bahk-n kake abon ebahre ba nkal, fere tob ko ebahne, wahr bahke lene anahne, wahn a wahr bahke jolo ajehng. ");
INSERT INTO eka_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ń tohko fere taame yehke nrur, wahr bahke koko mmonannee ejahre tahm ejahre. ");
INSERT INTO eka_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ntoobo abo kˈkor Hamor, a Sekem mmon ewe. ");
INSERT INTO eka_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Njangkun nyia nyi ga bel ekpunu go nlaaga nde, á laangem ellimi ji bo tong-e no, tibre ntir enye á yehke kunu mmona Jekob noa no nkal. ");
INSERT INTO eka_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Owo Hamor a Sekem mmon ewe, kehm tahme song rehng go eti mbu ji ejahbe ebo re, bo song tong ane ebo. ");
INSERT INTO eka_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Bo tongo bo re, <<Ane baa li go elkoono a nahre, nong bo lene egahra ndi, fere jo jen are a, tibre ndi nyia gbalee nyi bo bahke ma jol a nahre, e bahke ma ko abon ebo ba nkal go elbal, bo tob ko ba bahre. ");
INSERT INTO eka_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Wo aneblum bao re, <<Bo bahke lene anahre fere jol ajehng anahre, go ejum jia re, aneblum ebahre yehke nrur tob jol ana bo. ");
INSERT INTO eka_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Anv atohkondi ebo, a nsol ebo go enyam ebo kpee nehm tob jol nsol enyahra? Nong wahr limen ana ji bo ma bung, bo bahke lene anahre a. ");
INSERT INTO eka_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Aneblum kpee ba lohngo je go eti mbu ji ejahbe jio, bo taame tv ji Hamor, a Sekem mmon ewe bungu no, nnenlum awohng awohng go ejahbe jio yehke nrur. ");
INSERT INTO eka_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Eji ma kang nfung era, ngare nyio nrur nyi bo yehke no kpi bo nnyame nnyame, abon ba nlum abal ba Jekob, Simion abola Levi abonanyehn Dayina, bo kehm rodo akahngkahng ebo song kehme elnoko a ejahbe jio ji ki kunu ekpu, fere wul nnenlum awohng awohng o. ");
INSERT INTO eka_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Bo tob wulu Hamor a Sekem mmon ewe go ekahngkahng, fere yehke Dayina go etahk Sekem tahm ebo. ");
INSERT INTO eka_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Abone Jekob kehm jeke ejahbe ji bo wulu ane bao, song da nsol, tibre o wo bo rannge mmonannyehn ebo no nkal. ");
INSERT INTO eka_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Bo soro ba kpu ejoro, a ebul ebo, a efong, ebvankang, a ejum ebo ajehng ajehng ji bo bele no, go ejahbe jio, a nya li go emahng. ");
INSERT INTO eka_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bo kpu nsol afang ebo a anebkal ebo kpee a abon abon ana aju ebta, fere da ejum ajehng ajehng go ntahk. ");
INSERT INTO eka_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jekob kehm tongo Simion a Levi re, <<Wahn ebseb nfem ba ka-m, wahn eblim, me njol ana ebi nrabe ka anebe Kenan a anebe Peris bo ji li ane ba lene a ndi nyia a bo. Wahr nehme rur, bo lˈfere fadde elbo ba nok aname, me a etahk ejame, bo bahk-r rannge kpee.>> ");
INSERT INTO eka_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bo kehm faange Jekob re, <<Anv, fˈfuumu re Sekem lim mmonannee ejahre ana nne asˈsaa?>> ");
INSERT INTO eka_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Esowo kehm tongo Jekob re, <<Song go Betel wo song jol o, lim egudu njom o ka Esowo, ye ji jo ba kpir-a eji a jo be Eso mmonanne. ");
INSERT INTO eka_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jekob kehm tongo anebe etahk ebe, a ane ba lene a ne re, <<Yehken, ajen asowo nya ń kpi no, wahn ru elnahne, fere yannge abomo. ");
INSERT INTO eka_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Baan, wahr tahmen go Betel, go wo m bahke limi egudu njom ka Esowo, ye ji jo faang-m afung nya ejahkjahk jo jol aname, ye ji jo tob jol aname go edi ajehng ajehng ji n je no.>> ");
INSERT INTO eka_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Owo bo kehm koko ajen asowo a abangetung nya jolo go ebo atung, ba ka Jekob, á kpa kak nnahb eti nyi bo kpo lung re oak go Sekem. ");
INSERT INTO eka_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Owo bo kehm lohngo tahm, egburu efahle ni lohng goji Esowo jolo a ajahbe nya jolo sennge bo kak, jol nnene lohngem kam bo. ");
INSERT INTO eka_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jekob a ane ebe kpee jene ba rehng go Lusi, ji li Betel, go ndi nyi Kenan. ");
INSERT INTO eka_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","O edi jio wo á limi egudu njom, á jo lungu edi jio re, El Betel, tibre o edi jio wo Esowo lennge elne ka-e, eji á jo be Eso mmonane. ");
INSERT INTO eka_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nnenkal no jo rennge Rebeka, no bo jo lung-e re, Debora kehm kpoko, bo kpa-e kak go nnahb eti nyi bo kpo lung re Ok kohlo Betel, ano wo wahnge edi jio bo jo lung re, Alon Bakud. ");
INSERT INTO eka_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ngare nyi Jekob lohngo go Padan Aram, Esowo kehm kpe ba kpiri Jekob fere fuul-e. ");
INSERT INTO eka_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Esowo kehm-e tongo re, <<Mbing enya bo kpo lung-a re Jekob, bo wa-a nehm kpe lung re Jekob; Bo bahke fere jo lung-a re Isreel. Owo á fere gung-e mbing re Isreel. ");
INSERT INTO eka_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Esowo kehm-e tongo re, <<Me wo li Esowo Bi Kpi Nsahm Kpee, jel wo rur wahn jol go nfange gbˈgbal. Ejahbe, a abon ajahbe ba bahke lohngo go ega elwo, a atul atul kpee bahke lohngo go ega ngubjing. ");
INSERT INTO eka_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ndi nyi n ka Ebraham a Aisik, me n tob faake anyi ka-a, m bahke kake etˈtohngo eja ji kpa-a toono ndi nyia. ");
INSERT INTO eka_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Esowo kehm feere go ero, tahme sa edi jio ji á jolo a ne. ");
INSERT INTO eka_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jekob kehm loko eltal ana ego, edi jio ji Esowo jo bung a ne, kehm yaange njom nyio nyi elwoko wohngo o, á tob yaange akehng wohngo o. ");
INSERT INTO eka_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jekob lungu edi ji Esowo bungu a ne re Betel. ");
INSERT INTO eka_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Bo kehm mehle o Betel asongo, edi jio ekidi kpˈkpeka lab nne kehm rehnge go Efrad, Rasel kehm kehme ejel rahng, ejel jo riid-e sehng. ");
INSERT INTO eka_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ana ejel jo sahb riid-e riidi go eljele, owo nnenkal no jo bob-e ejel kehm-e tongo re, <<Ka kpe fahl, wob bel mmon no nlum noko. ");
INSERT INTO eka_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ana á gohro v elv ni elkv, á lungu mmon noo re Ben Oni, wo nde lung-e re Benjamin. ");
INSERT INTO eka_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Owo Rasel kehm kpo, bo kpa-e kak go mbang eji bo jo tahm Efrad, ji li Betlehem. ");
INSERT INTO eka_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","O ero elahm bi Rasel, Jekob loo ego o, tete rehng lela ego jio kpˈtibi elahm bi Rasel. ");
INSERT INTO eka_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isreel kehm mehle o asongo, song si ebehre eje go esˈsong, nne lˈsehng Migdal Eder. ");
INSERT INTO eka_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Eji Isreel lene o edi jio, Ruben kehm tahme song noongo a nne elkora nde Bilha, Isreel wˈwuk bade. Jekob bele ewubu abon abal ba nlum: ");
INSERT INTO eka_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Abon ba nlum ba Lia ba a: Ruben wo jolo ngbokambang a mmona Jekob, Simion, Levi, Juda, Isaka a Jebulon. ");
INSERT INTO eka_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Abon ba nlum ba Rasel ba a: Josef abola Benjamin. ");
INSERT INTO eka_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Abon ba nlum ba Bilha nlokeltum Rasel jele no ba a, Dan abola Naftali. ");
INSERT INTO eka_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Abon ba nlum ba Jilpa jele no ba a, ye ji jolo nlokeltum a mmon no nkal no Lia, Gad abola Aser. A wo li abon ba nlum ba bo jele no ka Jekob go Padan Aram. ");
INSERT INTO eka_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jekob feere kehnge goji nde Aisik ga Mamre, kohlo Kiriad Arba, ji li Hebron, edi ji Ebraham abola Aisik tohko lene. ");
INSERT INTO eka_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisik kange nnya atahl asehmwubu. ");
INSERT INTO eka_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Á gohro v esˈkohro elv soro kpo, bo rod-e song kak eyele ane ebe, á sahb kˈkul go nnya tvv. Eso abola Jekob, bo ji jolo abon ebe ba rod-e song kpa kak. ");
INSERT INTO eka_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ana wo li ntoora nnyo mi li bade Eso, ji li Edom. ");
INSERT INTO eka_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Eso koo akal ebe goji anebkal Kenan: Adah mmon no nkal no Elon nnea Hid, a Oholibama mmon no nkal no Anah, ye ji jolo mmon a mmon no Jibion nnea Hiv, ");
INSERT INTO eka_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","á tob ko Basemad mmon no nkal no Ismeel, á jolo mmonannyehn no nkal no Nebayod. ");
INSERT INTO eka_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah jele Elifas ka Eso, Basemad jel Reuel, ");
INSERT INTO eka_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama tob jele Jewus, Jalam a Korah. Abon ba nlum ba a, ba bo jele ka Eso go Kenan. ");
INSERT INTO eka_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Eso kehm rodo akal ebe, a abon ebe ba nlum, a ba nkal, a ane kpee ba jolo go egea nlaaga, atohkondi enye, go enyam behko, a nsol enye kpee nyi á bele no o Kenan, tahm song jol edi ji li fee a kehm rehnge edi ji Jekob mmonannyehn li no. ");
INSERT INTO eka_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nsol ebo nyi bo bele no gbale sehng re bo maam jol edi ajehng, edi ndi ji bo jolo no biingem bo, ane abal abal tib ntohkondi ebo. ");
INSERT INTO eka_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Owo Eso, ji li Edom kehm tahme song jol go ejahbe ewong ji Seir. ");
INSERT INTO eka_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ana wo li ntoora nnyo mi li bade Eso, nde no anebe Edom go ejahbe ewong ji Seir. ");
INSERT INTO eka_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","A wo li abing nya abone Eso ba nlum, Elifas ji Ada nkala Eso jele no, a Reuel ji Basemad nkala Eso jele no. ");
INSERT INTO eka_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Abon ba nlum ba Elifas ba a: Tema, Omar, Jefo, Gatam a Kenas. ");
INSERT INTO eka_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Mmona Eso noa no nlum Elifas tob bele nne elkoro no bo jo lung-e re Timna, ye wo jele Amalek ka-e. A wo li abon abon ba Ada nkala Eso. ");
INSERT INTO eka_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Abon ba nlum ba Reuel ba a: Nahad, Jera, Sama, a Mija. Bo ba jolo abon ba nlum ba abone Basemad nkala Eso. ");
INSERT INTO eka_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Abon ba nlum ba Oholibama nkala Eso ji mmona Ana ba a, ye ji jolo mmon no mmona Jibion, ba á jele ka Eso: Jewus, Jalam a Kora. ");
INSERT INTO eka_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ane ba jolo atubesi go etˈtohng ji Eso ba a: Abon ba nlum ba Elifas ji jolo ngbokambanga mmon no Eso: Ntula Teman, ntula Omar, ntula Jefo, a ntula Kenas, ");
INSERT INTO eka_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ntula Kora, ntula Gatam, a ntula Amalek, bo ba jolo atul ane go etˈtohngo ji Elifas go Edom, bo jolo abon ba abon Ada. ");
INSERT INTO eka_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Abon ba nlum ba mmona Eso Reuel: Atula Nahad, ntula Jera, ntula Sama, a ntula Mija. Bo ba jolo atubesi etˈtohngo ji Reuel gona Edom; Bo ba jolo abon ba abon nkala Eso nobo jo lung-e re Basemad. ");
INSERT INTO eka_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Abon ba nlum ba nkala Eso, Oholibama: Ntula Jewus, ntula, ntula Jalam, a ntula Kora, bo ba jolo atul go etˈtohngo ji nkala Eso Oholibama mmon no Ana. ");
INSERT INTO eka_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Baa kpee jolo abon ba Eso, ji li Edom, bo jˈnehm ba jolo atul ebo. ");
INSERT INTO eka_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Abon ba Seir nnea Hor, bo ji lene erohko jio ba a: Lotan, Sobal, Jibion, Ana, ");
INSERT INTO eka_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Ejer a Disan. Abon baa ba Seirba nlum go Edom, bo ba jolo atul anebe Hor. ");
INSERT INTO eka_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Abon ba nlum ba Lotan ba a: Hori abola Homam. Timna jolo mmonannyehn Lotan no nkal. ");
INSERT INTO eka_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Abon ba nlum ba Sobal ba a: Alvan, Manahad, Ebal, Sefo a Onam. ");
INSERT INTO eka_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Abon ba nlum ba Jibion ba a: Aya abola Ana. Ana jia wo, song nyehn elbing alahb ni jo fub go elka emahng, eji á jo jen ebvankang nde Jibion bo jo li nsol. ");
INSERT INTO eka_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Abon ba Ana ba a: Dison mmon no nlum, a Oholibama mmon no nkal. ");
INSERT INTO eka_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Abon ba nlum ba Dison ba a: Hemdan, Eshban, Itran a Keran. ");
INSERT INTO eka_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Abon ba Ejerba nlum ba a: Bilhan, Jaavan, a Akan. ");
INSERT INTO eka_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Abon ba Disan ba nlum ba a: Uju abola Aran. ");
INSERT INTO eka_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ane ba jolo atul ba anebe Hor ba a: Lotan, Sobal, Jibion, Ana, ");
INSERT INTO eka_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Ejer a Disan. Ane baa ba jolo atul ba anebe Hor, ana bo yabe elbo ndi nyi Seir. ");
INSERT INTO eka_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","A wo li atul ba jo fili Edom anebe Isreel kehm tob bel atul ba bo. ");
INSERT INTO eka_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mmon no Beyo ba jolo ntul no Edom. Ejahbe eje bo jo lungu re Dinhaba. ");
INSERT INTO eka_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Eji Bela kpoo no, Jobab mmon no Jera no lohng go Bojra wo ko nji etul ebe. ");
INSERT INTO eka_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Eji Jobab kpoo no Husam ji lohng go ndi nyi anebe Teman wo ko nji etul ebe. ");
INSERT INTO eka_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Eji Husam kpoo no Hadad mmona Bedad ye ji noko ga anebe Midia go ejahbe Moab, ye wo fere ba ko nji etul ebe. Elsi ene bo jo lungu re Avid. ");
INSERT INTO eka_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Eji Hadad kpoo no, Samla ji lohng go Masreka wo ko nji etul ebe. ");
INSERT INTO eka_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Eji Samla kpoo no, Sawul ji lohng go Rehobod go ejang aya wo ko nji etul ebe. ");
INSERT INTO eka_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Eji Sawul kpoo no, Bal Hanan mmon no Akbor wo ko nji etul ebe. ");
INSERT INTO eka_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Eji Bal Hanan mmona Akbor kpoo no, Hadad wo ko nji etul ebe. Elsi ene bo jo lung re Pawu, nkal ewe bo jo lung-e re Mehetabel ji mmona Matred, ji jolo mmona Me-Jahab no nkal. ");
INSERT INTO eka_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","A wo li ane ba jolo atubesi go etˈtohngo ji Eso, a abing ebo, ana arohko abangenahb ebo li no, a adi nya bo lene no: Timna, Alva, Jethed, ");
INSERT INTO eka_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO eka_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaji, Teman, Mibjar, ");
INSERT INTO eka_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidiel a Iram. Ane baa ba jolo atul ba Edom, toono ana bo kake nsi ebo go ndi nyi bo ji no. Eso wo jolo nde no anebe Edom. ");
INSERT INTO eka_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jekob lene ndi nyi nde jolo no, go ndi nyi Kenan. ");
INSERT INTO eka_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ntoora nnyo mi li bade Jekob mi a. Josef jolo mmonjangkun no ma kang elku a nnya ebal, á jo jene toono abonanyehn, bo jo le atohkondi, abon ba nlum ba Bilha, a ba Jilpa akal ndea bo. Josef jo ba tooro asabsab nsol nya abonanyehn jo kono ellimi. ");
INSERT INTO eka_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ana jolo o, Isreel nde, Josef wo jo ga-e kor sehnge abon ebe bako nlum, tibre Josef bo jele ka-e ngare nyi á ma kul; Owo wahnge á jahme ekpawobo ji jolo anyono anyono ka-e. ");
INSERT INTO eka_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Eji abonanyehn sebe kahn re Josef wo jo ga kor nde ebo sehnge bo kpee, bo ko-e ekv, bo joom kpe bung a ne yebe yebe. ");
INSERT INTO eka_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Josef kehm leeme nlem tooro tong abonanyehn, bo kpe-e ko na ekv budu. ");
INSERT INTO eka_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Á kehm tongo bo re, <<Wuungen atung wahn wuk nlem nyi n leeme no. ");
INSERT INTO eka_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","E jolen go emahng jo gba agan nkohl, tvtv ngan nyˈnyame kehm mehle yiimi nsunsu, agan nya nyahne kehm bake ba yiimi sennge nyˈnyame kak, fere gong ka nyˈnyame.>> ");
INSERT INTO eka_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Abonanyehn kehm-e tongo re, <Anv, a kpˈtiri re wo wo bahke jolo ntul ewahr-a? Wo bahke lohko jo fil-ra? Bo kpe-e jo ko na ekv budu tib go nlem nyia nyi á lake bo, a ji á tongo bo. ");
INSERT INTO eka_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Josef kehm kpe leeme nlem nyehko tong abonanyehn re, <<Wuungen atung, me n kpe leeme nlem nyehka, anv jolo re njul a ebareka, go ewubu elonlo ajehng gongo ka-m.>> ");
INSERT INTO eka_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Eji á tongo nde, fere tob tong abonanyehn, nde kehm-e nyame, fere tong-e re, <<Nlem nyi a ma leeme a, lohngo renan? Anv, nne a me, go abonane bahke bake ba gong go ndi ka-a?>> ");
INSERT INTO eka_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Josef kpe sahb lˈli na abonanyehn ala, wo nde kuuru ejum ajehng ajehng go ege atahng. ");
INSERT INTO eka_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ngare nyia abonanyehn ebrod atohkondi ndea bo song kehme bo nsol alehke kaa kohlo Sekem, ");
INSERT INTO eka_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isreel kehm tongo Josef re, <<A kpˈkahne re abonane kpi atohkondi kpur kohlo go Sekem. Ba, me n tum-a tv bo.>> Á kehm faange re, <<Ebnob sehng.>> ");
INSERT INTO eka_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Isreel kehm-e tongo re, <<Song wo song nyehn abonane joare bo baa go efel, afi atohkondi nyaa tob li nseenge, wo feere ba tong-m.>> Owo Isreel kehm-e tumu, á mehl o edamme ji Hebron asongo. Eji Josef rehnge go Sekem, ");
INSERT INTO eka_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","nne awohng kehm-e nyehne á kpˈdaale yannge go elka emahng, nne noo kehm-e bahbe re, <<Jenji a kpˈsebe?>> ");
INSERT INTO eka_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Á kehm-e faange re, <<N kpi abonanee kpur. A bahk-m ma tib edi ji bo li no kpˈkpuru atohkondi eboa?>> ");
INSERT INTO eka_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nne noo kehm-e faange re, <<Bob mehl ao, n jo wuku eji bo jo bung re, <E tahmen go Dotan.>>> Owo Josef kehm tahme jo seb abonanyehn asongo, song nyehn bo kohlo go Dotan. ");
INSERT INTO eka_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Eji bo sa nyehn-e go fee, re á kehm ba rehng o eji bo, bob toobo ana bo bahk-e wulu. ");
INSERT INTO eka_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Bo jo bungu tong atemtem re, <<Nyehn monleeme alem ga kpˈbake!>> ");
INSERT INTO eka_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Nong wahr wulen ye ro kak ekpabingi ajehng a, fere bung re ebi nnyam nyi me-e li, wahr kehm nyehne ana ji alem enye bahke jolo. ");
INSERT INTO eka_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Eji Ruben wuku ano, á sebe re a á tahr-e yehke go ebo abo, á tongo bo re, <<Nong wahr ki-e wul.>> ");
INSERT INTO eka_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kana faade alung amehng amehng, roon na ye kak ekpabingi a elka emahng, kana lak ye ebo abehng abehng. Ruben bungu jia re á tahr-e go ebo abo, feere a ne song ka nde. ");
INSERT INTO eka_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Eji Josef ma rehng goji abonanyehn, bo kehm-e yehke ekpawobo eje ji jolo anyono anyono ji á kake no, ");
INSERT INTO eka_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","bo kehm-e rodo ro kak ekpabingi, ekpabingi jolo nnehme nehme, alahb jolem. ");
INSERT INTO eka_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Eji bo ji no jo li nsol alehke, bo kehm nyehne ellong anebe Ismeel ba lohng go Giled, kun go ebo akamel kpˈbake, akamel solo nsol are, ana akehng ma kpo yebe abehne, a ajoobo akehng eltaame ma kpo lim ane nob ayam, a alahb eti esˈsvv ma lohng eti ji bo kpo lung re Merr, bo jo tahm go Ijib. ");
INSERT INTO eka_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda kehm tongo abonanyehn re, <<Anv nsehng anyii e bahke lehke, e lˈwul mmonannee ewahre fere bulu alung eme? ");
INSERT INTO eka_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nong wahr gungen na ye ka anebe Ismeel, wahr kiin ye abo lak, gana ye mmonannee ewahre wo, e kpi alung amehng.>>Abonanyehn soro taame. ");
INSERT INTO eka_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Eji anebe Ismeel ba lohng go Midia ba jo jen are ba no, abonanyehn kehm tohngo Josef yehke go ekpabingi jio, fere rod-e gungu anebe Ismeel go akpohko asilva eltahl, ane bao rod-e tahm a ne go Ijib. ");
INSERT INTO eka_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Eji Ruben feere no song kpur go ekpabingi jio, Josef o kpeem jol, á yare elne nsol nyi á kake no. ");
INSERT INTO eka_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ruben kehm jeke goji abonanyehn kehm song bung re, <<Mmon njangkun noo o kpeem li, anv gan wo m bahke jeke?>> ");
INSERT INTO eka_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Bo kehm wulu mmombul, fere rod ekpawobo Josef behde go alung mao. ");
INSERT INTO eka_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bo kehm rodo ekpawobo anyono anyono song tib ndea bo, fere tong-e re, <<Wahr ebnyehn ekpawobo jia. Feede wo nyehn joare ekpawobo mmon ewa ji.>> ");
INSERT INTO eka_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Á kehm liingi soro bung re, ekpawobo mmon ewame ji. Ebi nnyam me-e li. Josef bo me-e lohko jaake arohko arohko. ");
INSERT INTO eka_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Owo Jekob kehm yare nsol nyi á kake no, fere kak anyake nsol, noongo elkv mmon ewe afung tvv. ");
INSERT INTO eka_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Abon ebe kpee, ba nlum a ba nkal ba re bo ba kak-e eltim, á ten fere bung re, <<Eˈee, m bahke soro asi noongo elkv tete n yel elahm toono mmon ewame.>> Jekob soro na asi jo ling mmon ewe. ");
INSERT INTO eka_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Eji ma jol ano, anebe Media rodo Josef gungu Potifa, ji jolo ntubesi awohng go ellong atubesi abalimeltum Fero. Potifa wo jolo ntubesi ababˈbaabe. ");
INSERT INTO eka_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ngare nyio Juda yake abonanyehn ebe kehm tahme re á song jol a nnelohng Adulam no bo jo lung-e re Hira. ");
INSERT INTO eka_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Gona wo Juda kpiri mmonse no nkal, nde bo jolung-e Sua ji lohng go Kenan. Á ko-e go elbal, kehm noongo a ne, ");
INSERT INTO eka_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","á sa ela jel mmon no nlum no á gung-e mbing re Er. ");
INSERT INTO eka_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Á kpe sa ela jel mmon no nlum no á gung-e mbing re Onan. ");
INSERT INTO eka_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Á kpe bulu kpe sa ela jel mmon no nlum no á gung-e mbing re Sela, á jel-e go Kejib. ");
INSERT INTO eka_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda ko nkal ka ngbokambang a mmon ewe no nlum Er, mbing enye bo jo lung-e re Tamar. ");
INSERT INTO eka_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ngbokambang a mmon ewe Er jolo nne no jo lim abˈbi go ejang bi Jehova, wahng ka Jehova wul-e. ");
INSERT INTO eka_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Owo Juda kehm bungu tong Onan re, <<Song noongo a nkala mmonanne, wo ruru eltum ene ana nnar a mmonanyehn nne, eji a lˈjel abon ka mmonanne.>> ");
INSERT INTO eka_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan kahne kpee re, mmon noo nehm jol no we. Owo wahnge ngare anyehng anyehng nyi á lˈnoongo a nkala mmonannyehn, á jo fere fonngo ebjing wohng go ndi, eji á lˈkˈjel abon ka mmonannyehn. ");
INSERT INTO eka_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ji Onan jo lim o jolo ebˈbi go ejang bi Jehova, Jehova tob wul-e. ");
INSERT INTO eka_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Juda kehm tongo Tamar nnar ewe re,<<Jol go etahk nso ana nkal ebun tete mmon ewame Sela gbal,>>Á bele ntir re, á bahke tob kpo, ana abonanyehn.>> Ano wo Tama mehle no song lene go etahk nde. ");
INSERT INTO eka_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Eji ma kang afung gbalee nkala Juda, mmon no nkal no Sua, kehm kpoko. Eji Juda ma noongo elkv mal, á mehle tahm go Timna, goji ane kpo kpud anyar ejoro ebe, nte ewe Hira ji lohng go Adulam toon-e je o. ");
INSERT INTO eka_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ana bo tongo Tama re, Nde nlum wa fi mbang mbang asongo go Timna re á song kpud anyar ejoro ebe,>> ");
INSERT INTO eka_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tama kehm yehke nsol nkalebun, kehm rodo mbomo konngo bulu elne eji nnene lˈki-e liingi, mehl song ji go mbang nyi li rehng go Enayim go mbang nyi li tahm go Timna. Á sebe kahn re jol eji Sela ma gbˈgbal o, bo we nehme ka á jol nkal ewe. ");
INSERT INTO eka_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Eji Juda nyehn-e no, Juda tiri re nne asˈsa wo, tib yebkonngo esamahr ebe. ");
INSERT INTO eka_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Juda kahnem re nkala mmon ewe wo, á song kpir-e o nkpe a mbang, kehm bungu re, <<Ba me, me n nkang a na.>> Tama kehm-e bahbe re, <<Jenji á bahk-m kake a lˈnoongo aname?>> ");
INSERT INTO eka_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Juda kehm-e faange re, <<M bahke tumu mmon mbul no nse tv-a go ellong ebul ebame. Tama kehm-e tongo re, <<Á bahk-m ma yahke ejum ji m bahke bumu ana ejum ntianse tete á tum mmona mbul noo tv-m?>> ");
INSERT INTO eka_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Juda kehm bungu re, <<Ejum ajii á kpˈsebe re me ka-a ana atianse? Tama kehm faange re, <<Yake ejum elliingi eja a nlehke eme, a ebti efilebo bi wob-a ebo ka-m.>> Á kehm-e kake, noongo a ne, á soro sa ela ka Juda. ");
INSERT INTO eka_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Eji ma jol ano, Tama kehm feere go etahk, song lennge mbomo mi á konngo elne, rod abomo nkalebun bobo ana wuku wuku. ");
INSERT INTO eka_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Eji ejum jio ma sehng, Juda kehm kake nte ewe Hira ji lohng go Adulam mombul re á song ka nnenkal noo fere ko nsol enye ba ka-e. Eji Hira je no á we kpeem nyehn. ");
INSERT INTO eka_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Owo á kehm bahb aneblum ba lene o re, <<Nne a asˈsa no jo kono eljehke nkpe a mbang nyi li asongo Enayim mee? Bo kehm-e faange re, <<E ka bˈbel nne asˈsa ao.>> ");
INSERT INTO eka_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Owo Hira kehm feere song tong Juda re,<<M we nyehnem edi ajehng ajehng, aneblum ba li ejahbe jio kpˈbungu re nne asˈsa ka jˈjol ona.>> ");
INSERT INTO eka_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda kehm bungu re, <<Nong á bum nsol nyi n ka-e no, eji e lˈk jol ejum asol. Kehn n tˈtumu mombul ana e toobo no, á we nyehnem.>> ");
INSERT INTO eka_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Eji yahke biingi nnyahng era, bo kehm tongo Juda re, <<Tama nkala mmon ewa kpˈjene yannge ana nne asˈsa, anv, tib esi jia, yebsa ela.>>Juda kehm bungu re, <<Koon ye ba, wahn ba jahm-e agun á kpo!>> ");
INSERT INTO eka_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Eji bo me-e rod re bo song wul, owo á tumu etib tv nde nlum re, <<Nne no kpi nsol nyia, ye wo ma-m kak ela. Seenge nˈnob. Nne awoo kpi ejum elliingi jia a nlehke eme, a ebti efilebo bia?>> ");
INSERT INTO eka_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda soro liingi nsol nyio tvtv, kehm bungu re, <<Tama wo ga li etingitingi nne sehnge me, tib m taam-m re Sela mmon ewame ko-e go elbal.>> Juda kpeem tiki noongo a Tama. ");
INSERT INTO eka_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Eji ba rehng ngare ejel, bo sebe kahn re Tama jolo ela ayafele. ");
INSERT INTO eka_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ana á jo rahng ejel, mmon awohng gbo mbang yehke ebo ebe. Mbohngo ejel kehm tubu mmon noo ejahm, gba-e mbila mbomo go ege ebo, kehm bungu re, <<Noa wo gbo mbang lohng.>> ");
INSERT INTO eka_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Á kehm fere tohng ebo ebe kak atahng, mmonannyehn fere lohng! Mbohngo ejel kehm biingi re, <<Lohngo renan!>> Á limi renan a ma bohngo lohng?>> Bo kehm gungu mbing re Pereji ");
INSERT INTO eka_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Owo mmonannyehn no bo kahn-e mbila mbomo go ebo kehm lohngo, bo ka-e mbing re Jera. ");
INSERT INTO eka_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Eji bo ko Josef song rehng a ne go Ijib, Potifa ji jolo nnea Ijib, ji jolo ntubesi awohng go ellong atubesi abalimiltum Fero, a ntubesi ababˈbaabe, ye wo gunu Josef goji anebe Ismeel ba ko-e no rehng o. ");
INSERT INTO eka_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Jehova jolo a Josef owo wahnge edi jo nob a Josef, á jolo go etahk ndeju ewe nnea Ijib. ");
INSERT INTO eka_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Eji ndeju ewe nyehne re Jehova jolo a ne, go fvfo Jehova tob ka-e efa go ejum ajehng ajehng ji á jo lim. ");
INSERT INTO eka_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifa bele eyebatahng a Josef, owo wahnge á rod-e lim ntubesi go ege a nlaaga. Á jolo nne no jo lim eltum a ne bad bad.Á lim-e Á lim-e á jo kpur nlaaga enye, fere yake nsol enye kpee kak-e go ebo nyi á bele no. ");
INSERT INTO eka_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Bomo ngare nyi á lim-e ntubesi fere yake nsol nlaaga kake go ebo, Jehova fuulu nlaaga nyi nnea Ijib tib esi Josef. Elfuulu ni Jehova jolo go ejum ajehng ajehng ji Potifa bele no, jolo go nlaaga afi go ekulugbe. ");
INSERT INTO eka_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifa yake ejum ajehng ajehng ji á bele no ka Josef, tib esi ji Josef jo kpur nsol, Potifa joom kpe kunu ekpu go ejum ajehng ajehng, sehngem nsol alehke nyi nyi á jo li. Josef gbo eljini fere nˈnob. ");
INSERT INTO eka_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Eji jolo ano nkala ndeju ewe yehke amahr kun-e, fere tong-e re, <<Ba noongo aname!>> ");
INSERT INTO eka_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Josef tˈten fere tong-e re, <<Tib eji nsol kpee wob-m go ebo, ntubesi ewame ejumjum lim ji ye kpo kpe gbiingi elne go ege etahk, ejum ajehng ajehng yeb yake kak-m go ebo. ");
INSERT INTO eka_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nnene limm no kpˈgbale etahk jia ana me, ejumjum limm ji ntubesi ewame kala yake kak-m go ebo, sehngem wo ntahng ntahng, tibre wo nkal ewe wo. Bahke limi renan me n kehm limi elkohn ebi ejum ana jia, fere lim abiafem soodo Esowo. ");
INSERT INTO eka_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Jol ana á jo bˈbung a Josef efung abehng abehng, Josef jo tˈten elnoongo a ne, jol Josef lubem jol na a ne. ");
INSERT INTO eka_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Efung abehng Josef kehm yele ekpˈkpa re á song lim eltum ene, aloketum ba etahk jio kpee nnene jolem o ekpˈkpa. ");
INSERT INTO eka_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Á kehm-e jabbe go ege ekpawobo, kehm bungu re, <<Ba noongo aname!>> Josef kehm yehke ekpawobo tv-e go, be lohng alatahk. ");
INSERT INTO eka_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Eji á nyehne re yebyake ekpawobo tv-e ebo, fere be lohng alatahk, ");
INSERT INTO eka_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","á kehm lungu alokeltum ba etahk jio, kehm tongo bo re, <<Nyehnen nnea Hibru no bo ko-e ba ka-r re á ba nyok-r, nyehn ye go ma ba re á ba noongo aname, n kehm rabe. ");
INSERT INTO eka_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Eji á wuku ana m ma rabe re tob-m wahn, owo á ma tahm ekpawobo sa go egame ejang, fere be lohng alatahk.>> ");
INSERT INTO eka_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nnenkal noo bumu ekpawobo jio tete nlum ewe kehnge ba etahk. ");
INSERT INTO eka_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Owo á kehm-e tubu eka re: <<Nju nnea Hibru no á ko-e ba ka-r eblohng ba re á ba nyok-m. ");
INSERT INTO eka_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ana n soro kehme elrabe re tob-m wahn, á soro tahm ekpawobo eje sa go egame ejang, fere be lohng alatahk.>> ");
INSERT INTO eka_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Eji Potifa wuku eka jio ji nkal ewe tub-e no re, <<Ana wo nju enya lim-m no,>> atahng kehm-e sahb rˈrak. ");
INSERT INTO eka_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Á kehm rodo Josef nju enye song kak go ngbekobo, edi jio ji Fero kpo bum anebe agbekobo ebe. Ana Josef woomo o ngbekobo, ");
INSERT INTO eka_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Jehova jolo a ne. Á tib-e nnoobo eljini, fere lim mbaaba ngbekobo jol eyebatahng a ne. ");
INSERT INTO eka_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Owo mbaaba agbekobo kehm limi re Josef fere jo kpur anebe agbekobo ba wob o kpee, fere tob jo kpur ejum ajehng ajehng ji bo kpˈlimi o. ");
INSERT INTO eka_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mbaaba agbekobo joom kpe kunu amahr go ejum ajehng ajehng ji á ma yake kak Josef go ebo, tibre Jehova jolo a ne, fere lim-e á li efa go ejum ajehng ajehng ji á jo lim. ");
INSERT INTO eka_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Eji ma kang afung, nfili ebtuka ntul abola nlima abred no ntula Ijib, soodo ndea bo, ntul no Ijib. ");
INSERT INTO eka_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Fero atahng rak-e sehng tob atubesi ane abal ebe baa, ntubesia abafili ntuku abola ntubesia abalima abred, ");
INSERT INTO eka_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","á rodo bo kak ngbekobo go etahk jˈnehm ji ntubesia mbabˈbaabe, go ngbekobo nyˈnehm nyi Josef woomo no. ");
INSERT INTO eka_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ntubesia mbˈbaabe yake agbekobo nyao ka Josef re á jo kpur bo, Josef jo kpˈkpur bo. Eji bo ma jol o ngbekobo ma kang afung ntiil, ");
INSERT INTO eka_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","aneblum abal bao nfili ebtuku abola nlima abred ka ntula Ijib, bo ji woomo o ngbekobo, bo leeme nlem atv manehm, bo ane abal abal, nlem anyehng anyehng lohngo eje eje. ");
INSERT INTO eka_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Eji Josef ba nyehn bo njahm efungfu, á sebe kahn re bo joom bang. ");
INSERT INTO eka_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Owo á kehm bahbe atubesi alokeltum Fero bo ji woomo go ngbekobo go etahk ntubesi ewe re, <<Jenji wahnge ń kil bange lela?>> ");
INSERT INTO eka_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Bo kehm-e faange re, <<Wahr ane abal abal leeme alem, wo nnene limm no bahke tooro tong-r ana lohngo no.>> Josef kehm tongo bo re, <<Esowo sang kpˈkahne ana ntooro alem lohngo noa?. Tong-m wahn alem enyahne. ");
INSERT INTO eka_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Owo ntubesia nfili ntuku kehm tongo Josef nlem enye. Á tong-e re, <<Egama nlem n nyehne eti ji bo kpo lung re nlehke egreb, yim go egama mbuksong, ");
INSERT INTO eka_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nlehke mio bele njad era, ana kake anyane o, soro fem lim atasok agreb fere bil. ");
INSERT INTO eka_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ebtuku Fero woomo egame abo, n kehm bongo akaba greb nyao, fere kaame kak go ebtuku, fere rod ebtuku bio kak Fero go ebo.>> ");
INSERT INTO eka_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josef kehm-e tongo re, <<Ana wo nlem enya lohngo no. Njad era nyio lohngo nfung era. ");
INSERT INTO eka_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Re kang nfung era, Fero bahk-a yehke go ngbekobo, fere feere a na go ega nji eltum, a bahke feere jo song kak Fero ebtuku go ebo ana a jo lim wuku wuku, eji a jolo nfili ebtuku ewe. ");
INSERT INTO eka_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Lˈfere nob a na buum-m wo tib-m nnoobo eljini, gahm-m go esamahr Fero wo kak-m ebo me n lohng go ngbekobo nyia. ");
INSERT INTO eka_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bo bob-m na yehke go ndi nyi anebe Hibru, jol edi ji n li a ejumjum n limem ji fuumu re bo kak-m go ngbekobo elbing.>> ");
INSERT INTO eka_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Eji ntubesia abalima abred nyehne re Josef ebtooro ntooro nyi nno, á kehm tongo Josef re, <<Me fvfo n tob leeme nlem, ejeere ebra kuum-m go esi bi abred woomo no.>> ");
INSERT INTO eka_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ejeere ji gohro kuumu go ero, ajoobo akaange kaange nsol ellehke woomo atahng nya jolo ka Fero, nruk jo suudu nsol nyio li go atahng ejeere ji n solo go egame esi. ");
INSERT INTO eka_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josef kehm-e tongo re, <<Ana wo nlem enya lohngo no, ejeere ebra bio lohngo nfung era. ");
INSERT INTO eka_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Lˈkang nfung era, Fero bahke kimi esi eja, fere rod-a song kahn tohko go eti, nruk bahke bake ba suudu nnyama ngubjing enya li kpee.>> ");
INSERT INTO eka_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Sa nfung era Fero bahke buumu efung bi bo jel-e no, á limi elkak ka atubesi abalimeltum ebe. Á kehm tumu bo song yehke ntubesia abafili ntuku, a ntubesia abalima abred go ngbekobo, ba a bo go esamahr atubesi abalimeltum ebe. ");
INSERT INTO eka_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Fero feere a ntubesia abafili ntuku jehke ege a nji eltum, eji á lˈkpe jo kak Fero ebtubu go ebo, ");
INSERT INTO eka_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","fere rod ntubesi abalima abred song kahn ekehd tohko go eti. Ana wo alem nyao lohko jol jangjang ana Josef tooro no tong bo. ");
INSERT INTO eka_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ntubesia abafili ntuku kpeem buumu Josef; á yin-e yini. ");
INSERT INTO eka_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Eji ma sehng nnya ebal, Fero kehm leeme nlem: Á leeme no, á yiimi go nkpe aya Nayel, ");
INSERT INTO eka_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","edahmagbudu na ebsehma kehm lohngo o aya nya sahb jˈjok fere fˈfeele, ba kehme ajele li go nkpe aya. ");
INSERT INTO eka_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Eji ma jol ano edahmagbudu na ebsehma behko kehm kpe lohng aya mao toono bo. Adahmagbudu nyao jolo akpuk kpuk fere sˈsab ba yiimi kohlo ajokojoko nyao go nkpe aya. ");
INSERT INTO eka_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Akpuk kpuk adahmagbudu nyao fere sˈsab kehm lehke edahmagbudu bio na ebsehma bi joko fere fˈfeele. Fero kehm nyahme go ellu. ");
INSERT INTO eka_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Á kehm kpe gbo ellu kehm kpe leeme etoono nlem, elrahn nkohl anehng lake abon na asehma fere gbal egburu arum nkohl sahb nˈnob. ");
INSERT INTO eka_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Eji ma jol ano, akpuudu akpuk kpuk nkohl esehma kehm tob kpe kehme elgbale sahb fˈfiiri, elfeb ero nfam ba lim fi akohl nyao. ");
INSERT INTO eka_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Akpuudu afiiri akohl nyao fere mele agburu arum anoobo akohl nyao, Fero soro nyahme, na ga nlem nyi. ");
INSERT INTO eka_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Eji efungfu ma se, eltim jo gbiing-e sehng, á kehm tumu re bo lung anebe ntaane kpee a akahnkahn ane ba Ijib bo ba. Fero kehm lake bo alem enye, nnene we maam tong ana alem nyao lohngo no. ");
INSERT INTO eka_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Owo ntubesia abafili ntuku kehm tongo Fero re, <<Lela me mbuumu abˈbi enyame. ");
INSERT INTO eka_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ngare jˈjol nyi a rake atahng tob alokeltum eba, fere tum-m ngbekobo awahra ntubesia abalima abred go etahk ntubesia mbˈbaabe. ");
INSERT INTO eka_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Wahr ane abal abal leeme alem atv manehm na amehng, nlem anyehng anyehng jo lohngo eje eje. ");
INSERT INTO eka_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Njangkun, nnea Hibru awohng jolo anahre, á jolo nlokeltum no ntubesia mbˈbaabe. Ye wo e lake alem enyahre, á tong-r ana lohng no, no nne á tong-e ana nlem enye lohngo no. ");
INSERT INTO eka_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Nsol nyio lohko jol ana á tooro no tong-r, me feere go egama nji eltum, nne noko bo song kahn-e ekehd. ");
INSERT INTO eka_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Fero kehm tumu tv Josef, bo soro yehk-e go ngbekobo elbing. Ngare nyi á ma kpud elne fere yaange abomo elkake, á kehm ba yiimi go esamahr Fero. ");
INSERT INTO eka_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fero kehm tongo Josef re, <<N leeme nlem, nnene me-e nehme ma tong ana lohngo no, me n wuk bob bung bada na re a lˈwuk nlem, a bahke ma tooro ana lohngo no.>> ");
INSERT INTO eka_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josef kehm faange Fero re, <<Me n nehm ma lim, wo Esowo bahke kake Fero nfaange nyi bahk-e koro.>> ");
INSERT INTO eka_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Owo Fero kehm tongo Josef re, <<Go egama nlem, n yiimi go nkpe aya Nayel, ");
INSERT INTO eka_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","edahmagbudu na ebsehma kehm lohngo o aya, bo sahb jˈjok fere fˈfeele ba kehme ajele li. ");
INSERT INTO eka_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Edahmagbudu ebsehma behko kehm tob kpe lohng o aya, bo sahb kpˈkpuk, fere fˈfiiri, n ka nyehn a nyehn adahmagbudu ana nyao a ndi nyi Ijib kpee. ");
INSERT INTO eka_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Akpuk kpuk adahmagbudu nyao nya fere sˈsahb sˈsab kehm lehke ajokojoko adahmagbudu nyao na ebsehma nya gbo mbang lohng aya. ");
INSERT INTO eka_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Jol tvtv o, eji bo ma li bo o, jol nnene nehm ma tong re bob lim ano, bo kpake yim ano kpuk kpuk kpuk kpuk ana wuku wuku. N kehm soro nyahme. ");
INSERT INTO eka_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","<<Go egame a nlem n nyehne agburu arum nkohl na esehma sahb nˈnob go elrahn anehng. ");
INSERT INTO eka_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Eji jolo ano n kehm kpe nyehn akpuudu- akpawake akohl na esehma kpˈgbale sahb fˈfiiri, elfeb ero nfam ba fi. ");
INSERT INTO eka_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Afiiri fiiri akohl nyao jo mele arum nyao na esehma nya sahb nˈnob. Me n tong anebe ntaane, bo ane kpee nnene lim no male no tong-m ana lohngo no.>> ");
INSERT INTO eka_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Owo Josef kehm tongo Fero re, <<Alem nya Fero li elkohnkohn anehng, Esowo eblennge ka Fero ejum ji á yahke lim. ");
INSERT INTO eka_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Anoobo adahmagbudu na ebsehma lohngo nnya esehma, anoobo arum akohl nyao na esehma lohngo nnya esehma; li na anehng fvfo li elkohn nlem anyehng. ");
INSERT INTO eka_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Akpuk kpuk adahmagbudu na ebsehma nya sabb fˈfiiri fere sˈsab nya lohngo toono, tob lohngo re nnya esehma, ano wo akpuudu akpawake akohl nya elfeb ero fi no: Nya li nnya esehma nyi njal. ");
INSERT INTO eka_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","<<Li na li jang jang ana n tong-a no Fero, Esowo ebtib Fero ejum ji á yahke ba lim. ");
INSERT INTO eka_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Egburu nnya esehma nyi nsol ndi bahke lake tv fad kpˈbake go ndia Ijib. ");
INSERT INTO eka_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Wo nnya esehma nyi njal bahke toono, Bo bahke yini bade nlaka nsol nyi jolo a Ijib, njal nyi bahke fere ko nji a ndi nyia. ");
INSERT INTO eka_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bo nehm kpe buumu nlaka nsol nyi jolo go ndi nyia, tib re njal nyi bahke toono, bahke sabe sehng, ");
INSERT INTO eka_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ejum ji wahnge Esowo tibi Fero go nlem mbang ebal li re ejum jio Esowo ebtoobo sahb tˈtahne, fvfo Esowo bahke gulu ellimi. ");
INSERT INTO eka_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","<<Eji ma jol ana, nong Fero kpur nne no kpi ngbere a elkahne, fere rod-e kak á jo kpur ndia Ijib. ");
INSERT INTO eka_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Nong Fero yehke atubesi ane kak go ndi nyia nyi Ijib, bo jo yehke ejum ajehng go nsol elon anyehng anyehng, go ngara nsol akpake go nnya esehma nyi nsol bahke lake tv fad. ");
INSERT INTO eka_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Bo ko nsol alehke nyio go nnooba nnya na esehma nyi kpˈbake, bo kuuru nkohl go elwo ni Fero, bo kuuru nsol alehke nyio go ajahbe ajabe ajahbe. ");
INSERT INTO eka_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nsol alehke nyia bo bahke kuuru bum ejahbe, eji behnjehle bo lˈjo ko li, go nnya esehma nyi njal kpˈbake a Ijib, eji ejahbe lˈkˈnyehn erem njal.>> ");
INSERT INTO eka_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ntoobo nyia kˈkor Fero a atubesi alokeltum ebe. ");
INSERT INTO eka_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Owo Fero kehm bahbe bo re,<<Anv wahr bahke ma bel elkohn nne ana noa, no etohko ji Esowo li a nea?>> ");
INSERT INTO eka_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Fero kehm tongo Josef re,<<Eji Esowo ma lim re wo kahn nsol nyia kpee, nnene lim no kpe kpi ngbere a elkahne ana wo. ");
INSERT INTO eka_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ekpasiki ejame bahk-a woomo go ebo, ane ebame kpee bahke tob woom-a go ebo, fere jo wuk ajehke enya. Sehngem ga eti etul wo, me n bahke gbale sehng-a.>> ");
INSERT INTO eka_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Owo Fero kehm tongo Josef re,<<Me n yake ndi a Ijib kpee kak ega ebo, re wo jo kpur.>> ");
INSERT INTO eka_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Owo Fero kehm yehke ebil nsahm enye go ege ebnyohkobo, fere kak Josef go ege ebnyohkobo. Á fere liib-e ekpawobo ji etul, fere kak-e nlehke agul go emel. ");
INSERT INTO eka_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Fere lim-e re bo sol-e go mmvtv akuungu ana etoono ntubesi, ane fere jo rabe re, <<Tahmen go mbango.>> Mbang nyia wo Fero ma yake ndi nyi Ijib kpee kak Josef go ebo re á jo kpur. ");
INSERT INTO eka_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Owo Fero kehm tongo Josef re, <<Me wo li Fero, tohko jol re ellum ena ni, nnene lim no bahke tabe ebo afi ekpade go ndi nyi Ijib kpee.>> ");
INSERT INTO eka_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Fero kehm kake Josef mbing re Jafena-pania fere ka-e Asenad mmon no nkal no Potifera, ye ji jolo nlimanjom go On re á jol nkala Josef. Josef yannge kpee go ndi nyi Ijib. ");
INSERT INTO eka_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ngare nyia Josef ebkang eltahl a nnya ewubu eji á yele eltum aloko goji Fero ntul no Ijib. Josef jo tahme o esamahr Fero jo yannge go ndi nyio nyi Ijib kpee. ");
INSERT INTO eka_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Go nnya esehma nyi nsol bahke lake, nsol sahb lˈlak gbalee go ndi nyio. ");
INSERT INTO eka_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Josef jo jene ko nsol alehke nyio nyi bo jo bel go nnya esehma nyio nyi nsol lake no tv fad go Ijib, fere jo kuuru go ajahbe, ajahbe. Go ejahbe ajehng ajehng nsol mbahmandi nyi bo jo bahm o á jo ko kuuru o. ");
INSERT INTO eka_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josef kuuru abim nkohl jolo are erikehndi aya ma. Gbale sehng re nfange á joom kpe ma kak go nwer, tibre siiri eso. ");
INSERT INTO eka_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Re nnya nyio nyi njal kehm rehnge, Asenad mmon no nkal no Potifera nlimanjom no On, ebjel abon ba nlum abal ka Josef. ");
INSERT INTO eka_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josef gungu ngbokambang a mmon ewe mbing re Manase, kehm bungu re, <<Tibre Esowo eblim re me n yini afemfem enyame kpee, a nya nlaaga nsoo kpee.>> ");
INSERT INTO eka_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Etoono mmon no nlum a gung-e mbing re Efriim, kehm bungu re, <<Tibre Esowo ma-m ka nrur go ndi nyi m ma nyehn erem.>> ");
INSERT INTO eka_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Owo nnya esehma nyi nsol alehk tv fad go Ijib kehm male. ");
INSERT INTO eka_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Nnya esehma nyi njal kehm bomo ana Josef bungu no. Njal jolo adi nyako kpee, wo go ndi nyi Ijib kpee nsol alehke jˈjol. ");
INSERT INTO eka_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Eji anebe Ijib kpee kehme njal wa, bo kehm lingi tob Fero bade nsol alehke, Fero tongo aneb Ijib kpee, re <<Songen goji Josef wahn lim ajehng ajehng ji á bahk-n tongo.>> ");
INSERT INTO eka_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Eji njal ma rehng edi ajehng ajehng go ejahbe kpee, Josef kehm lennge abutahk ntahk nyi á kuuru nsol alehke, jo gungu anebe Ijib nsol alehke, tibre njal gbale sehng go ndi nyi Ijib kpee. ");
INSERT INTO eka_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ane kpee jo lohngo go ajahbe ajahbe ba go Ijib ba gunu nsol alehke goji Josef, tibre njal gbale sehng go edi ajehng ajehng. ");
INSERT INTO eka_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Eji Jekob wuku re nsol alehke nyia go Ijib, á tongo abon ebe re, <<Jenji wahnge ḿ ma sa kpi atemtem seenge?>> ");
INSERT INTO eka_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Á kpe soro asi bung re, <<Me n wuk re alehke nyia go Ijib, songen go wahn song gunu ba ka-r, eji e lˈkpin, kˈkpo.>> ");
INSERT INTO eka_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Owo abonanyehn Josef na awubu kehm tahme re bo song gunu alehke go Ijib. ");
INSERT INTO eka_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Wo Jekob tumem Benjamin mmonanyehna Josef a ane bako, tibre á jo fahle re, ejum ki-e lim. ");
INSERT INTO eka_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Abon Isreel kehm tahme a ellong ane bako re, bo song gunu nsol alehke, tibre njal tˈtob jol go ndia Kenan. ");
INSERT INTO eka_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Josef wo jolo nne no jo fili ndi nyio, ye wo jolo nne no jo gungu anebe ejahbe bao kpee nsol alehke. Eji abonanyehn Josef bao rehnge o, bo gongo asamahr ebo go ndi ka-e. ");
INSERT INTO eka_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ana Josef nyehne abonanyehn, á lˈliingi bo, fere lim awini ana njenne, bung a bo egban egban re, <<Wahn lohng gan?>> Bo kehm-e faange re, <<Wahr lohng go ndi nyi Kenan, e ba re wahr ba gunu nsol alehke.>> ");
INSERT INTO eka_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Jol eji Josef liingi liingi abonanyehn, bo we-e liigem ");
INSERT INTO eka_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Josef kehm buumu nlem enye bada bo, kehm bungu tong bo re, <<Wahn ane ba kpo weele nyehn egahbe ba, ḿ ba re wahn ba nyehn nkpe ejahbe anyehng anyehng nyi nne bahke ma sehng yel,>> ");
INSERT INTO eka_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bo kehm faange re, <<Eˈee ntubesi wahr alokeltum eba, e ba re wahr ba gunu nsol alehke. ");
INSERT INTO eka_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wahr kpee abon ba nlum ba nne awohng ba, wahr alokeltum eba ane ba kpi ekpunu ba, abaweele nyehn ejahbe sang.>> ");
INSERT INTO eka_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Josef faange bo re <<Eˈee, ḿ ba re wahn ba nyehn nkpe ejahbe anyehng anyehng nyi nne bahke ma sehng yel.>> ");
INSERT INTO eka_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Bo kehm faange re, <<Wahr alokeltum eba jolo ewubu abonanyehn ba nlum na abal, abon nne awohng, bo lene go ndi nyi Kenan, monkalla li a nsoo ewahre, noko kpeem li.>> ");
INSERT INTO eka_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josef kehm tongo bo re, <<Tiki li ana n kp-n tongo re, wahn abaweele nyehn ejahbe ba! ");
INSERT INTO eka_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ana wo bo bahk-n wunngu, Go mbing nyi Fero ji li go elkpin, ń nehm tiki tahm a tete monkalla mmonanne ewahne ba a. ");
INSERT INTO eka_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tumen nne awohng wahne a song ko mmonanne wahne á ba; wahn egom jehka kpee ḿ bahke woomo go ngbekobo, eji bo lˈwuungu alum enyahne fere seb kahn joare ń kpˈbung etingitingi. Lˈjol re ń kpi kimi efahne, go mbing nyi Fero ji li go elkpin, wahn abaweele nyehn ejahbe ba!>> ");
INSERT INTO eka_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Á kehm kake bo kpee go ngbekobo go nfung era. ");
INSERT INTO eka_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Eji ma biingi nfung era Josef kehm tongo bo re, <<Limen jia wahn jol go elkpin, tibre me n kpˈfahle Esowo. ");
INSERT INTO eka_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Joare ń lohko li ane ba kpi ekpunu, nong mmonanne ewahne awohng jol o ngbekobo, wahn ga roden nsol alehke wahn song kehnge, song ka anebe njal go etahk. ");
INSERT INTO eka_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Koon mmonkalla mmonanne ewahne ba ka-m, eji alum enyahne lˈlohko jol ano, fvfo eji ń lˈkˈkpo.>> Bo tˈtaame re bo bahke limi ano. ");
INSERT INTO eka_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Bo kehm bungu tong atemtem re, <<Etingitingi e kpˈnyehne erem bia tib esi mmonannee ewahre, e nyˈnyehn erem bi jolo a ne, eji á jo gboong-r tib esi elkpin ene, wo e we wukem, ano wo wahnge erem bia ma feere ba kuum-r.>> ");
INSERT INTO eka_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben kehm tongo bo re, <<Wahn tong-ma, re wahn kˈlim abiafem tob mmonse nlum noa? Ń wukem, anv wahr ba bahke gale mbong alung eme.>> ");
INSERT INTO eka_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Bo joom kahn re Josef kpˈwuku ana bo kpˈ bungu, eji jolo re nne jo tooro na tong bo. ");
INSERT INTO eka_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Josef kehm tahme bo sa song kehme ellingi, eji á ma rahke eling á kehm feere ba kehme elbungu a bo. Á kaa nsahm bo gba Simion go ebo esamahr. ");
INSERT INTO eka_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josef kehm tongo aloketum re bo kak bo nsol alehke rur go ebo abam, fere feere akpohko asilva ebo kak nne awohng awohng go ege ebam, fere toobo nsol eljen ka bo. Ngare nyi bo ma lim ano ka bo, ");
INSERT INTO eka_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","bo kehm gbade ebvankang, abam nsol alehke soro tahm. ");
INSERT INTO eka_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Edi ji bo kange no wo, nne awohng kehm fannge ebam eje re á ka mbvankang nsol alehke, soro nyehn akpohko silva enye go egea nnyo ebam. ");
INSERT INTO eka_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kehm tongo abonanyehn re, <<Akpohko silva enyame, bob fere a nya kak-m egame ebam. Nyehnen nya ga egame ebam.>>Ntim kehm kimi bo, bo keebe seenge atemtem fere kehme elkahme kehm bungu re, <<Jenjii a ji Esowo ma-r lim anae?>> ");
INSERT INTO eka_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Bo kehm ba rehng eji Jekob ndea bo, go ndi nyi Kenan, bo tongo ndea bo nsol kpee nyi ma lim bo. ");
INSERT INTO eka_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Bo kehm bungu re, Nne no li ntubesi a ndi jo bungu anahre egbangban, fere jo ko-r are wahr ane ba kpo weele nyehn ndi ba. ");
INSERT INTO eka_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Wo wahr tong-e re, <Wahr ane ba kpi ekpunu ba; wahr abaweele nyehn adi sang.> ");
INSERT INTO eka_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","E tong-e re, <E jolo ewubu abonanyehn abal, abon nde awohng, na awohng kpeem li, monkalla noa a nsoo ewahre go Kenan.> ");
INSERT INTO eka_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","<<Owo nne no li ntubesia ndi kehm-r tongo re, <Ana wo ḿ bahke kahne re wahn ane ba kpii ekpunu ba: Yaken mmonanne ewahne awohng bum a egame, wahn jehko ko nsol alehke song ka anebe njal go egahna ntahk. ");
INSERT INTO eka_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Koon monkalla mmonanne ewahne ba ka-m, eji n lˈkahn re wahn abaweele nyehn edi sang, ane ba kpi ekpunu ba. M bahke feere a mmonannee ewahne kaan, ń fere jo jen are go ndi nyia.>>> ");
INSERT INTO eka_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ana bo jo yaange nsol alehke go ebo abam, nne awohng awohng nyehne ebgba akpohko silva enye go ege ebam! Eji bo a ndea bo ma nyehn ebgba akpohko silva ano, bo kehme elfahle. ");
INSERT INTO eka_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Owo Jekob ndea bo kehm tongo bo re, <<M ma-m lim re me n kˈkpe bel mmon awohng awohng. Josef kpeem li, Simion kpeem tob li, anv ń yahke kpe rod Benjamin tahm a ne. Me wo nsol nyia kpee ma sennge kuumu me!>> ");
INSERT INTO eka_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben kehm tongo nde re, <<A bahke ma wul abon nlum abal ebame, n tohko ko Benjamin ba ka-a, yak-e kak-m go ebo re me n kpur-e, m bahke feere a ne.>> ");
INSERT INTO eka_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jekob kehm bungu re, <<Mmon ewame wahn nehm toono je go; mmonannyehn ebkpo, ye ntahng ntahng wo ma sa, ejum ajehng.>> Ajehng lˈsong lim-e go mbang eljen eji ń fi a ne, ḿ bahke limi abi enyame yel go elahm ndon ndon. ");
INSERT INTO eka_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ngare nyia njal kpˈkpake gbal go ndi nyio. ");
INSERT INTO eka_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Owo eji bo ma li nsol alehke kpee nyi bo gunu go Ijib, ndea bo kehm tongo bo re, <<Feeren song Ijib wahn kpe song gunu nsol alehke ntiil ba ka-r.>> ");
INSERT INTO eka_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juda kehm bung tong nde re, <<Nne noo sahb rehk-r rehke tˈtahne re, <Ń nehm kpe nyehn esamahr ebame, ń tohko tiki ko nkalla ewahne ba a ne.> ");
INSERT INTO eka_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Á lˈtum mmonannee ewahre á toon-r ba, wahr bahke jeke song gunu nsol alehke ba ka-a. ");
INSERT INTO eka_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Á tohk-e tum á toon-r, wahr nehm je, tibre nne noo tong-r re, <Ń nehm kpe nyehn esamahr ebame, ń tohko tiki ko mmonanne ewahne ba a ne.>>> ");
INSERT INTO eka_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isreel kehm tongo bo re, <<Jenji wahnge ń kehm koko nfem nyia ba ka-m, eji ń tong-e re ń kpi mmonanne ewahne ga?>> ");
INSERT INTO eka_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Bo kehm-e faange re, <<Nne noo bahb-r abahbe bade elnahre fere bahb-r bade a nnahb enyahre, á bahb-r nyehko re anv nso ewahne noa kpeka li go elkpina?> Fere kpe bahb re, <Ń kpˈkpi mmonanyehn nokoa?> Wahr tob faang-e na faange abahbe enye, e bahke limi renan kehm kahne re, á bahk-r tongo re, koon mmonanne ewahne ba a ne?>>> ");
INSERT INTO eka_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda kehm tongo Isreel nde re, <<Yake mmonse nlum noa kak-m go ebo, wahr bahke tahme tvtv, eji wahr, a wo, a abon ebahre e kpin kˈkpo njal. ");
INSERT INTO eka_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mefono antahng m bahke yiimi nkpaneka tahr-e; me wo a bahk-m jabbe antahng. N tohk-e ko feere a ne ba yiimi a ne a go ega esamahr, me wo bahke solo elfeeme go egame elkpin kpee antahng. ");
INSERT INTO eka_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ana li a, ki li re wahr eblaange, kehn wahr ebje na kpe feere je nkpel ebal.>> ");
INSERT INTO eka_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Owo Isreel ndea bo kehm tongo bo re, <<Lˈjol ano, limen jia: kaken akab nti nya nno go egahne abam nya lohng egahna ndi, wahn ko je a nya song ka nne noo ana ayare. Koon afubfub akehng, akehng ekon, a nsol nyi kpo lim nsol alehke yebe, a alahb eti ma kpo v esˈsvv eleenge, ma lohng eti ji bo kpo lung re Merr, mmohka pistasio, mmohka almond. ");
INSERT INTO eka_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Roden akpohko asilva nyao edi ebbal, tibre ḿ bahke tiki song ka asilva nya bo kake egahne anyo abam, fundiki elsoodo ni. ");
INSERT INTO eka_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Tob roden mmonanne ewahne, wahn song a ne anv anv goji nne noo. ");
INSERT INTO eka_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nong Esowo Bi Kpi Nsahm Kpee lim wahn fili nne noo ndon go ege esamahr, eji á lˈyake mmonanne ewahne noko, a Benjamin bo fere toon-n kehnge. Ana me, lˈjol re abon ebame bahke kpoko nong bo kpo.>> ");
INSERT INTO eka_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Owo ane bao kehm rodo nsol ayare nyao, fere rod akpohko asilva edi ebbal, a Benjamin fvfo. Bo kehm foomo tahm song rehng go Ijib, song tib elbo go esamahr Josef. ");
INSERT INTO eka_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Eji Josef nyehne Benjamin a bo, a kehm bungu tongo ntubesi alokeltum no etahk eje re,<<Rod ane baa song a bo egame etahk, song wul nyam o wo lam nsol alehke, bo bahke lehke nsol aname ngare efin.>> ");
INSERT INTO eka_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nne noo limi ana Josef tong-e no, lohko rod ane bao tahm a bo go etahk Josef. ");
INSERT INTO eka_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ane baa jo fˈfahl, eji bo rodo bo tahm a bo go etahk Josef. Bo jo tiri re, <<Bo ma-r ko ba a, tib akpohko silva nya bo kake go ebo anyo abam ngbokambang efung. Á yahke nok anahre fere ga-r, red-r fere ko-r ana aju fere taare ebvakanng ebahre.>> ");
INSERT INTO eka_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Owo bo kehm tahme toono atubesi alokeltuma Josef, fere bungu a ne, eji bo yahke yel etahk. ");
INSERT INTO eka_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Bo tong-e re, <<Titi nsoo, nyanjehle e ba a ba gunu nsol alehke. ");
INSERT INTO eka_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Go edi ji e kange no atv, efannge anyo abam enyahre fere nyehn akpohko asilva wob ebam nne awohng awohng ewahre, go nseenga seenge wahr ebko feere a nya. ");
INSERT INTO eka_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Wahr ebkpe ko akpohko silva nyako ba re wahr ba gunu nsol alehke, wahr nehme kahn nne no kake akpohko silva go egahre abam.>> ");
INSERT INTO eka_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","A kehm bungu re, <<Ebnob sehng,>> <<Kana kpe fahl. Esowo ebahne, Esowo bi nso ejahne, ye wo ma-n ka afange go egahne abam; n kˈko akpohko asilva enyahne.>> Owo á kehm yehke Simion feere a ne ba ka bo. ");
INSERT INTO eka_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","A kehm koko ane bao tahm a bo go etahk Josef, song ka bo alahb bo ru akpade, fere tob toobo nsol alehke ebvankang ka bo. ");
INSERT INTO eka_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Bo kehm toobo nsol ayare bum jo sik re Josef ba ngare efin, tib re bo wuku re bo bahke lehke nsol o. ");
INSERT INTO eka_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Eji Josef ma kehnge ba, bo kehm-e kake ayare nya bo ko no ba, bo gongo go ndi ka-e. ");
INSERT INTO eka_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Á kehm bahbe bo ana bo li no, fere tong bo re, <<Ekˈkulu nso ewahne no ń tong-m no bada ne, á li rejen? Á noa kpaka li go elkpina?>> ");
INSERT INTO eka_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Bo kehm faange re <<Nlokeltum ewa nsoo ewahre noa kpaka li elkpin. Fvfo ye noa nob nob.>> Bo kehm gongo go ndi, sahb gˈgong ka-e ekpunu. ");
INSERT INTO eka_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Eji a kpuru no fere nyehn Benjamin mmonannyehn, mmon no nlum no nyehn jele no, a kehm bahbe re, <<Monkalla mmonane ewahne no ń tong-m no bade wo aa?>> Á kehm bungu re, <<Nong nnoobo nyi Esowo jol a na, mmon ewame.>> ");
INSERT INTO eka_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Eji Josef nyehne mmonannyehn á kpeem ma bob elne, á kehm soro mehl esamahr abonanyehn tahm bo sa, foomo lohng, re á song seb edi ling. Á song yele ege a nkimi song ling. ");
INSERT INTO eka_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Á ru esamahr ebe, kehm lohngo jo bob elne, fere tong re <<Bak nsol alehke.>> ");
INSERT INTO eka_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Bo bake nya nye ka-e eje eje, abonanyehn bo ka bo ebo ebo, anebe Ijib ba li nsol a bo, bo tob bake ka bo eje eje, tibre aneb Ijib joom li nsol semme a aneb Hebru, tibre jolo ebi ejum ka aneb Ijib re bo lim ano. ");
INSERT INTO eka_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ane bao bo jehke bo nti go esamahr Josef toono esi ekul ebo, bomo nnenkul tete song rehng nkalla; bo jo seenge atemtem eko fere jo tan bo. ");
INSERT INTO eka_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Eji bo jo bak nsol go ekpˈkuru ji Josef, nsol nyi bo jo ka Benjamin jo gbale nkpel elon sehnge nya nne awohng awohng ga. Bo li fere wo fannge ngubjing a Josef. ");
INSERT INTO eka_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Josef kehm kake ntubesi alokeltum etahk ewe elle re <<Kak nsol alehke go abam ane baa, ana bo bahke ma sol, wo feere a akpohko asilva nya nne awohng awohng kak go ege nnyo ebam, ");
INSERT INTO eka_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","wo kak ebtuku ebame, ebtuku asilva go nnyo ebam mi nkalla. Tob kak akpohko asilva nya á ko gunu nsol alehke go ege ebam.>> Ano wo á limi no ana Josef tong-e no. ");
INSERT INTO eka_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Re efungfu se, bo song tv bo re bo song a ebvankang ebo. ");
INSERT INTO eka_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Jol eji bo lohngo ejahbe jio bo gaam jen fee, Josef tongo ntubesia nlokeltum ewe re, <<Song toono ane baa anv anv, a lˈkpiri bo, tong bo re, <Jenji wahnge ḿ ma ko ebi, feere a nnoobo? ");
INSERT INTO eka_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ebtuku asilva bia sang nsoo ewame kpo ko jo wo, fere jo bu elbua? Esab sab ejum ji ḿ ma lim.>>> ");
INSERT INTO eka_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Eji á song kpiri bo, alum nyanehm o nya á tongo bo. ");
INSERT INTO eka_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bo kehm-e faange re, <<Jenji wahnge nsoo kpˈbungu elkohn ejum ana jia? Ndan gbaa re wahr alokeltum eba lim elkohn ejum ana jia! ");
INSERT INTO eka_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kehn wahr lˈlohng go ndi a Kenan feere a akpohko silva ba ka-a nya e nyehne egahra abam. Jenji wahnge wahr bahke kehm vohko silva afii agul etahk nso? ");
INSERT INTO eka_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Lˈfere jol re nlokeltum ewa awohng awohng noa no bo bahke nyehne go ege, nong á kpo; wahr egom jehka bahke jolo alokeltum ba nsoo.>> ");
INSERT INTO eka_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","<<Á kehm bungu re ebnob sehng, <<Nong jol ana a ma bung. Nne no bo lˈnyehn go ege ye wo bahke jolo nju enyame; wahn egom jehko ń nehm kpe li ebi.>> ");
INSERT INTO eka_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Bo nne awohng awohng foomo radde abam eje bum ndi fere fange anyo abam. ");
INSERT INTO eka_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Owo ntubesi alokeltum kehm kehme elfeede, bomo goji nnenkul abo tete ba rehng eji nkalla. Etuku bio bo nyehne go ebam ji Benjamin. ");
INSERT INTO eka_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Eji jolo ano bo kehm, yare abomo ebo. Owo bo kehm feere a nsol gbade ebvankang, fere feere go ejahbe. ");
INSERT INTO eka_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ngare nyio Josef noa kpake li etahk, Juda a abonanyehn kehm ba gbo noongo go ege alata. ");
INSERT INTO eka_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josef tongo bo re, <<Jen ji wahnge ḿ ma lim ana? Ń nehme kahn re nne ana me bahke ma seb ejum kahn go elbua?>> ");
INSERT INTO eka_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda kehm faange re, <<Jenjii e bahke tongo nsoo ewame? Jenji e bahke bungu? Anv e bahke tibi renan re wahr nehme kahn? Esowo eblennge abˈbi nya alokeltum eba, anv a wahr aju nya nsoo nya, wahr fono antahng a nne no bo nyehne nkob ege ebam.>> ");
INSERT INTO eka_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Owo Josef kehm bungu re, <<Ndan gbaa re, me n lim elkohn ejum ana jio! Nne no bo nyehne ebtuku go ege wo wo bahke jolo nju enyame, egom jehko feeren song tob nso ewahne go elkoono.>> ");
INSERT INTO eka_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Owo Juda kehm song kpir-e fere tong-e re, <<Ntubesi ewame, nong nlokeltum ewa fil-a ndon. Nong me nlokeltum ewa bung moblum, Atahng ki-a rahk tob nlokeltum ewa, n kpˈkahne re, a li jang jang ana yefono Fero. ");
INSERT INTO eka_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Wo, ntubesi bahbe nlokeltum ewe re a kpˈkpi ndea afii mmonannyehn?> ");
INSERT INTO eka_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","E faange re, <E kpˈkpi nde, yebkul, mmon no nse no nlum noa no bo jele ka-e, eji á ma kul, mmonannyehn noko ebkpo, ye ntahng ntahng wo ma sa go mmon a nnenkal noo. Á kpo kor nsoo sehng.> ");
INSERT INTO eka_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","<A tongo nlokeltum ewa re, <<Ko-e ba, eji me n lˈnyehn-e antahng.>> ");
INSERT INTO eka_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","E tongo ntubesi ewame re <<mmonse nnenlum noo nehm ma tahm nde sa; á lˈtahm-e sa, nde bahke kpoko.>> ");
INSERT INTO eka_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Wo a tongo nlokeltum ewa re, <Tohko tiki jol re, nkalla toon-n ba a, ń nehm kpe tiki nyehn esamahr ebame.> ");
INSERT INTO eka_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Eji e feere no kehnge goji nlokeltum ewa no li nsoo, e song tong-e ji ntubesi tong-r no. ");
INSERT INTO eka_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","<<Owo nsoo ewahre kehm-r tongo re, <Songen wahn kpe song gunu abon nsol alehke.> ");
INSERT INTO eka_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Wo wahr tong-e re <<Wahr nehm feere je o, sehngem re no nkalla mmonnannee ewahre toon-r na, owo e bahke jeke. E nehm ma nyehn esamahr nne noo, tohko jol re nkalla mmonannee ewahre jolo anahre o.> ");
INSERT INTO eka_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","<<Nlokeltum ewa nsoo ewame tong-r re, <Ń kpˈ kahne re, nkal ewame jele abon ba nlum abal ka-m. ");
INSERT INTO eka_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Awohng tahm-m a sa, n bungu re <<Etingitingi bo me-e jaake arohko arohko,>> We n nehme kpe tiki nyehn. ");
INSERT INTO eka_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Á lˈkpe rod noa tahm-m sa, ejum lˈlim-e, a bahke rodo esi abi ejame yel go elahm ndon ndon. ");
INSERT INTO eka_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Elkpin nsoo li are bob kpennge atem a elkpin monse nlum noa. Anv mmonse nlum noa tohko jol anahre, n lˈfeere goji nlokeltum ewa no li nsoo, ");
INSERT INTO eka_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","a lˈnyehn re, mmonse nlum noa lim anahre, á bahke kpoko, alokeltum eba bahke rodo esi abi nsoo ewahre song kak elahm ndon ndon. ");
INSERT INTO eka_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Me nlokeltum ewa ko mmonse nlum go nkpaneka re m bahk-e kpuru ka nsoo ewahme. N tongo nsoo re, n tohk-e ko feere a ne ba ka-a, me wo bahke lehke ebi go ega esamahr, elkpin ename kpee. ");
INSERT INTO eka_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","<<Anv titi nong me nlokeltum ewa sa a ana njua nsoo, go esi mmonse nlum noa, nong mmonse nlum toono abonanyehn song. ");
INSERT INTO eka_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","M bahke limi renan kehm tahme kehnge goji nsoo ewame, mmonse nlum noa tohko jol aname? E,ee! Ka nongo me n nyehn ejum ndon ji bahke limi nsoo.>> ");
INSERT INTO eka_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Josef kpeem ma bob elne go esamahr ane ebe, á kehm rabe re,<<Nong nne awohng awohng tahm-m esamahr!>> Nnene jolem a ne eji á lennge elne ka abonanyehn. ");
INSERT INTO eka_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Á kehm lingi wahre wahre, anebe Ijib wˈwuk, anebe etahk Fero tˈtob wuk bade. ");
INSERT INTO eka_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josef kehm tongo abonanyehn re, <<Me Josef wo! Nsoo noa kpeka li go elkpina?>> Wo abonanyehn we ma-m faange, tib re eko tˈtan bo go ege esamahr. ");
INSERT INTO eka_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Owo Josef kehm tongo abonanyehn re, <<Jeeren kohl-m wahn.>> Eji bo ma lim ano, á kehm bungu re, <<Me Josef mmonanne ewahne wo, ye ji ń gung-e ka Ijib. ");
INSERT INTO eka_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Anv ki-n kpe mennge, jol kana kpe rak atahng tob elnahne tib eji ń gung-m no ka a, tib re jolo re me n tahre elkpin ane, ano wo wahnge Esowo tum-m re, me n gbo-n mbang. ");
INSERT INTO eka_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nnya ebal nyi a nyi njal li ndi nyia, nnya elon nyi ma sa, mbahmandi nehm jol, elkpake nehm jol. ");
INSERT INTO eka_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Wo Esowo tum-m, n gbo-n mbang re me n ko egburu mbang eltahre nia kuuru nkpin enyahne eji n lˈkˈ kpo wahn ane kpee go njini. ");
INSERT INTO eka_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","<<Fvfo wahn sang tum-m tv a, Esowo bi tum-m. Esowo ma-m lim me n jol nde no Fero, ntubesi no nlaaga enye kpee, a nfiladi no Ijib kpee. ");
INSERT INTO eka_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Anv foomen wahn feere song goji nsoo, tong-n ye re, <Ji ji a, ji Josef mmon ewa ma bung: re, Esowo ma-m lim ntubesi go Ijib kpee, mehl ba ga egame; ka laange. ");
INSERT INTO eka_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ḿ bahke ba lene nkpohko nyi Gosen, jol o kohlo me, wahn a abon ebahne, a abon abon ebahne, ejoro a ebul, a adahmagbudu enyahne a nsol kpee nyi n kpi no. ");
INSERT INTO eka_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","M bahke jo kpur-n kpur o, tibre ebsa nnya elon nyi njal kpeka li. Tohko jol ano wahn a anebe etahk ebahne, a ane ba li ka-n kpee ḿ bahke gboko ekpak.> ");
INSERT INTO eka_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","<<Wahnfono a Benjamin mmonannee kpˈnyehne re me Josef wo kpˈlohko bung anahne. ");
INSERT INTO eka_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tong-n nsoo ewame bade ekpunu ji bo ma-m ka ga Ijib, a ejum ajehng ajehng ji ḿ ma nyehn, wahn ko nsoo ewame ba a ne a elwaare.>> ");
INSERT INTO eka_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Á kehm bingi Benjamin mmonannyehn fere kehme ellingi, Benjamin tob bing-e, tob jo ling. ");
INSERT INTO eka_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Á fere tob bingi abonanyehn kpee fere ling a bo. Eji ma jol ano abonanyehn kehme elbungu a ne. ");
INSERT INTO eka_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Eji eka jia rehnge go ekpasiki Fero re, abonanyehn Josef ebba, Fero a atubesi alakeltum ebe kpee koro bo sehng. ");
INSERT INTO eka_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Fero kehm tong Josef re, <<Tong abonane re, <Lim-n jia: Gbaden enyam ebahne nsol, wahn feere go ndia Kenan, ");
INSERT INTO eka_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","wahn song ko nso ewahne a nnahb enyahne ba ka-m. M bahk-n kake edi ji ga nob ga ndia Ijib, ń tob li afom ebno ndi.> ");
INSERT INTO eka_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","<<A bahke tob tong bo re, lim-n jia: Rod-n nsol nyi kpo sol nsol a Ijib, wahn sol abon ebahne, a akal ebahne, a nso jahne, wahn ko bo ba a. ");
INSERT INTO eka_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kana tiiri bade nsol nyi li ka-n, tibre nsol nyi ga nob ga Ijib bahke jolo nyˈnyahne.>>> ");
INSERT INTO eka_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ano wo abone Isreel limi no, Josef ka bo nsol nyi kpo sol nsol, ana Fero ka ntahm, á tob toobo nsol alehke ka bo go ebo eljen. ");
INSERT INTO eka_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Josef ka bo nne awohng awohng ewobo nfenfe, wo eji Benjamin á ka-e akpohko asilva atahlku fere ka-e ewobo eblon. ");
INSERT INTO eka_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A wo li ji á tumu tv nde, mbvankang ewubu solo atingi anoobo nsol nya Ijib, akal ebvankang ewubu solo nsol alehke a abred go nsol nyehko nyi jolo ka eljen ene. ");
INSERT INTO eka_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Á kehm tumu abonanyehn re bo song, eji bo jo tahm, á tongo bo re, kana taange go mbango. ");
INSERT INTO eka_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Owo bo kehm tahme lohng go Ijib, song kpiri Jekob ndea bo go ndi nyi Kenan. ");
INSERT INTO eka_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Bo kehm-e tongo re, <<Etingitingi Josef noa kpeka li go elkpin, ye wo li nne no kpˈfili Ijib kpee.>> Jekob eko tan-e tan, á ma-m taame tv bo. ");
INSERT INTO eka_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Wo eji bo tong-e ejum ajehng ajehng ji Josef tongo bo, á fere tob nyehn nsol nyi kpo sol nsol, nyi Josef tumu re bo ba sol-e feere a ne, etohko ji Jekob ndea bo kehm yahme. ");
INSERT INTO eka_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isreel kehm bungu re, <<Ma-m lohko lennge! Josef mmon ewame noa lohko li go elkpin. M bahke tahme song nyehn-e kehm kpoko.>> ");
INSERT INTO eka_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Owo Isreel kehm mehle tahm a nsol a nsol enye kpee, eji á rehnge go Beer-seba a kehm limi ajom ka Esowo bi nde Aisik. ");
INSERT INTO eka_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Esowo kehm bungu tong Isreel atv, jolo elfoongo nlem re, <<Jekob! Jekob!>> Á kehm faange re, <<Nyehn me ga.>> ");
INSERT INTO eka_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Esowo kehm bungu re, <<Me wo li Esowo, Esowo bio bi nso, ka fahl eljeke go Ijib, tibre m bahk-a koko lim egburu ejahbe o. ");
INSERT INTO eka_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","M bahke jeke a na go Ijib, etingitingi m bahke tiki feere a na. Josef wo a bahke naange kake go ebo.>> ");
INSERT INTO eka_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Owo Jekob kehm mehle o Beer-seba, abon Isreel ba nlum kehm soro rod Jekob ndea bo, a abon ebo, a akal ebo, kak go amvtv nya Fero tumu tv re ba sol bo. ");
INSERT INTO eka_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Fvfo bo tob rodo atohkondi ebo a nsol kpee nyi bo bele go Kenan. Jekob a abon ebe kpee mehle tahm go Ijib. ");
INSERT INTO eka_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jekob rodo abon ebe ba nlum, a abon abon ebe ba nlum, a tob rodo abon ebe ba nkal, a abon abon ebe ba nkal, etˈtohngo eje kpee tahm a bo go Ijib. ");
INSERT INTO eka_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","A wo li abing abon ba nlum ba Isreel ba tahme go Ijib: Ruben wo Jekob gbo mbang jel-e. ");
INSERT INTO eka_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Abon ba nlum ba Ruben ba a: Hanok, Palu, Hejiron a Karmi. ");
INSERT INTO eka_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Abon ba nlum ba Simion ba a: Jamuel, Jamin, Ohad, Jakin, Johar, a Sawul ji nnenkala Kenan wo jele ka-e. ");
INSERT INTO eka_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Abon ba nlum ba Levi ba a: Gerson, Kohad a Merari. ");
INSERT INTO eka_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Abon ba nlum ba Judah ba a: Er, Onan, Sela, Pereji a Jerah, (Er, a Onan bo kpo go ndi nyi Kenan) Abon ba nlum ba Pereji: ba a, Hejiron a Hamul. ");
INSERT INTO eka_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Abon ba nlum ba Isaka ba a: Tola, Pua, Jasub a Simron. ");
INSERT INTO eka_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Abon ba nlum ba Jebulun ba a: Sered, Elon a Jaleel. ");
INSERT INTO eka_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Abon ba nlum baa, ba Lia jele ka Jekob go Padan Aram, a lˈyehke Dayina mmon ewe no nkal. Abon ba nlum, a ba nkal ebe kpee jolo eltahl ane awubu ane ara. ");
INSERT INTO eka_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Abon ba nlum ba Gad ba a: Jefon, Hagi, Suni, Ejibon, Eri, Arodi a Areli. ");
INSERT INTO eka_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Abon ba nlum ba Aser ba a: Imna, Isva, Isvi, a Beria, mmonannyehn ebo no nkal no bo jo lung-e re Sera. Abon ba nlum ba Beria ba a: Heber a Malkiyel. ");
INSERT INTO eka_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Abon kpee ba Jilpa jele no ka Jekob ba a, Jilpa ji Laban rod-e no ka Lia mmon ewe no nkal, bo kpee jolo elku a nne awohng. ");
INSERT INTO eka_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Abon ba nlum ba Rasel nkala Jekob jele no ba a: Josef a Bejamin. ");
INSERT INTO eka_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Gona Ijib wo Asenad mmon no nkal no Potifera ji jolo nlimajom no On, jele Manase, a Efriim ka Josef. ");
INSERT INTO eka_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Abon ba nlum ba Benjamin ba a: Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, a Ard. ");
INSERT INTO eka_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Bo ba jolo abon ba nlum ba Rasel jele no ka Jekob, bo kpee jolo ewubu ane ani. ");
INSERT INTO eka_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mmon no nlum no Dan wo a: Husim. ");
INSERT INTO eka_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Abon ba nlum ba Naftali ba a: Jajiyel, Guni, Jejer a Silem. ");
INSERT INTO eka_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Abon ba nlum ba Bilha jele ka Jekob ba a, Bilha ji Laban rod-e no ka Rasel mmon ewe no nkal, bo kpee jolo ane asehma. ");
INSERT INTO eka_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ane ba toono Jekob je go Ijib, bo jolo ane atahl ara, ane arakera, bo kpee jolo etˈtohngo eje, a lˈyehke akal abon ebe bum nkpe. ");
INSERT INTO eka_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","A lˈbudu abon ba nlum abal ba Josef jele go Ijib, etˈtohngo Jekob, jolo ane atahl ara ane awubu kpe kpe. ");
INSERT INTO eka_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jekob tumu Judah á gbo-e mbang, song goji Josef, eji á lˈsong kahn ana bo bahke sehnge song rehng go Gosen. Eji bo rehnge go ejang bio bi Gosen, ");
INSERT INTO eka_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josef toobo mmvtv akuungu enye tahm go Gosen song wane Isreel nde go mbang. Ana Josef nyehne nde, á kehm song bingi nde, bahk emel kun-e go ekpakebahk, soro kehme ellingi ekidi tete. ");
INSERT INTO eka_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isreel kehm tongo Josef re, <<Anv wo fuumu re me n kpo, eji m ma ba nyehn antahng re wo noa kpeke li go elkpin.>> ");
INSERT INTO eka_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Owo Josef kehm tongo abonanyehn a anebe etahk nde kpee re, <<M bahke tahme song bung a Fero, m bahk-e tongo re, <Abonanee, a anebe etahk nsoo kpee, bo ji lene go ndi nyi Kenan, bob ba, ba tob-m. ");
INSERT INTO eka_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Aneblum baa, abaabebul ba, bo kpo le enyam, bob ko efong, ejoro, a ebul baange ebo ba a bi, a ejum ajehng ajehng ji bo kpi no.> ");
INSERT INTO eka_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Fero lˈlung-n fere bahb re, <Eltum anii ń kpo lim?> ");
INSERT INTO eka_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Li re wahn faang-e re, <Alokeltum eba kpo le atohkondi bomo ese ese tete ba rehng anv, ana babnsoo ejahre jo lim. Á bahk-n yake re wahn song jol go ejang bi Gosen, tibre eltum ebul abaabe li ebi eltum ka anebe Ijib.>> ");
INSERT INTO eka_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josef kehm tahme song tong Fero re, <<Nsoo, a abonanee, boblohng go ndi nyi Kenan ba, bo ba a efong, ejoro, a ebul baange ebo, go ejum ajehng ajehng ji bo kpi no kpee, anv bo li go ndi nyi Gosen.>> ");
INSERT INTO eka_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Josef yehke abonanyehn ebe na alon ko bo song tib Fero. ");
INSERT INTO eka_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Fero kehm bahbe abonanyehn Josef re, <<Ń kpo lim eltum anii?>> Bo kehm faange Fero re, <Alokeltum eba abaabebul ba, jang jang ana babnsoo ejahre jolo no.>> ");
INSERT INTO eka_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Bo kpe-e tong re, <<Wahr ebba re wahr ba jol a mongare ntiil, tibre njal kpˈgbale go Kenan atohkondi nya alokeltum eba nehme kpe bel nsol li. Titi nong alokeltum eba song jol go Gosen.>> ");
INSERT INTO eka_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Fero kehm tongo Josef re, <<Nso, a abonane ebba a ega, ");
INSERT INTO eka_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ndi nyi Ijib li go ega elwo; song bum nso a abonane go edi ji ga nob. Nong bo jol go Gosen. Joare nne awohng awohng go ebo ellong noa no kpi ekahmekahme ebo eltum nong bo jo kpur atohkondi nya nyame.>> ");
INSERT INTO eka_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Owo Josef kehm koko Jekob nde ba tib Fero. Owo Jekob kehm fuulu Fero, ");
INSERT INTO eka_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Fero kehm-e bahbe re, <<Wob kang renan?>> ");
INSERT INTO eka_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Owo Jekob kehm tongo Fero re, <<Me n kang nnya atahl arakera a nnya ewubu. Aya enyame li ntiil fere rur ajahkjahk, aya nyaa biingem a aya ekul nya babnsoo ba bame.>> ");
INSERT INTO eka_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Owo Jekob kehm fuulu Fero, soro lohng eje tahm. ");
INSERT INTO eka_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Josef kehm toobo edi ji nde a abonanyehn bahke jolo o Ijib, fere ka bo edi ndi, go ejang ejahbe ji ga nob, jolo ejang bio bi Rameses ana Fero tibi no. ");
INSERT INTO eka_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Fvfo Josef tob ka nde a abonanyehn go anebe etahk nde kpee nsol alehke, toono ana nfange abon ebo jolo no. ");
INSERT INTO eka_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ngare nyia nsol alehke ebmal go ajahbe nyao kpee, tibre njal gbale sehng, anebe Ijib, a anebe Kenan ebgbo awo tib njal. ");
INSERT INTO eka_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josef ko akpohko kpee nya jolo go Ijib, a Kenan, nya bo jo gunu nsol alehke, ba a nya go ekpasiki Fero. ");
INSERT INTO eka_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Eji akpohko nya anebe Ijib, a anebe Kanan ma mal bo, ane kpee ba Ijib kehm bake goji Josef ba tong-e re, <<Ka-r nsol alehke! Anv wahr kpo go ega esamahra? Akpohko enyahre ebmal kpeeo.>> ");
INSERT INTO eka_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Owo Josef kehm tongo bo re, <<Koon atohkondi enyahne ba, m bahke koko gung-n nsol alehke, yaange asi go akpohko, eji akpohko enyahne ma mal.>> ");
INSERT INTO eka_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Owo bo kehm koko atohkondi bo ba, Josef jo ko anyˈya, ejoro, ebul baange, a adahmagbudu, a ebvankang Josef jo yaange ka bo nsol alehke. Á koo ano go elya nio jo ka bo nsol alehke, á jo ko atohkondi ebo go esi akpohko. ");
INSERT INTO eka_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Eji elya nio ma sehng, bo kpe ba etoono elya, ba tong-e re, <<Wahr nehm ma behr elnahre go esamahr nsoo wahre, eji ma jol re akpohko enyahre ebmal, atohkondi enyahre li ka wo, ejumjum wahr kpeem kpi, sehngem re agubjing enyahre, a ndi enyahre. ");
INSERT INTO eka_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","A bahk-r yake e kpoa, ndi enyahre sa ekpehle kpehla? Gun-r, a ndi enyahre wo ko yaange fere jo ka-r nsol alehke, wahr a ndi enyahre e bahke jolo aju ka Fero. Ka-r amohk nti nya elbahme, eji e lˈkpin kˈkpo, fvfo eji ndi lˈkˈsa nnehme nehme.>> ");
INSERT INTO eka_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ano wo Josef gunu ndi nyi Ijib kpee ka Fero. Anebe Ijib kpee gungu ebgbe ebo, tibre njal gbale a bo sehng. Ndi fere jol ka Fero. ");
INSERT INTO eka_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Josef limi ane bo jol aju bomo esi ejahbe Ijib jehko tete ba rehng esˈkohlo jehka. ");
INSERT INTO eka_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Fvfo Josef gunem adi ndi nya abalimajom, tibre abalimiajom jo bele ekakebo goji Fero jo ka bo. Bo jo bele nsol alehke gbalee go ekakebo jio ji Fero jo kak bo, owo wahnge bo ki gungu adi ndi ebo. ");
INSERT INTO eka_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Josef kehm tongo ane bao re, <<Anv eji m ma-n gunu a adi ndi enyahne ka Fero, kehm-n koko amohk nti elbahme wahn song bahm. ");
INSERT INTO eka_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ngare nyi ń lˈkehme elkpake nsol enyahne, ḿ bahke jo yehke ejum ajehng go nsol elon anyehng anyehng ba ka Fero. Wahnfono ko nsol eni eni bum elnahne go, ana amohk nya elbahme, a nya ellehke ka alaaga enyahne, a abon ebahne.>> ");
INSERT INTO eka_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Bo kehm bungu re, <<Wob tahre nkpin enyahre, nsoo nong wahr jol go eyebatahng a na; wahr bahke jolo aju ka Fero.>> ");
INSERT INTO eka_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Josef limi jia jol ntahm go ndi nyi Ijib, ntahm nyio nyia kpeke yim tete rehng lela re ejum ajehng go nsol elon, go nsol nkpakandi jol ka Fero. Sehngem re ndi nyi abalimajom nyi nyi ki jol ka Fero. ");
INSERT INTO eka_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ngare nyio kpee anebe Isreel jolo go Ijib go ejang erohko ji Gosen. Bo bele adi ndi gbalee, jo jel, fere sahb gbˈgbal go nrur. ");
INSERT INTO eka_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jekob kange elku nnya ebal o Ijib, nnya kpee nyi Jekob kange no go ege elkpin jolo nnya atahl asehma a nnya esehma. ");
INSERT INTO eka_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Eji ngare nyi Jekob yake kpo ma kabbe, á kehm lungu Josef mmon ewe fere tong-e re, <<Lˈjol re m bahke bele nnoobo go ega, kak ebo eba go egame a nla eyo wo nyam re, a bahk-m tibi nnoobo a ekakesehk. Kama kpa kak a ndi nyi Ijib, ");
INSERT INTO eka_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","n lˈtahm song re ekv a babnsoo, sol-m a Ijib lohng aname, wo song kak-m go eyele babnsoo.>> Josef kehm bungu re, <<M bahke limi ana a ma bung.>> ");
INSERT INTO eka_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","<<Á kehm bungu re, <<Tir go egame esamahr,>> Josef kehm tiri tong-e, Isreel kehm gongo yakke esinong kak Esowo. ");
INSERT INTO eka_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ba jolo mongare ntiil, bo kehm tongo Josef re, <<Nso kpˈyame.>> Owo Josef kehm rodo abon abal ebe Manase abola Efriim tahm a bo goji nde. ");
INSERT INTO eka_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Eji bo tongo Jekob re, <<Josef mmon ewa ebba re á ba nyehn-a,>> Isreel soro bel eko, mehl ji ege edilnong. ");
INSERT INTO eka_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jekob kehm tongo Josef re, <<Esowo Bi Kpi Nsahm Kpee tib-m elne go Luji, go ndi nyi Kenan, edi jio wo á fuul-m no. ");
INSERT INTO eka_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Fere tong-m re, <M bahk-a limi a gbal fere rˈrur go nfange. M bahk-a koko lim ejahbe ji ane gbalee, m bahk-a kake ndi nyia ana edi jˈja go njinanjini, bahke jolo ka etˈtohngo eja ji bahk-a toono.> ");
INSERT INTO eka_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","<<Anv, abon abal eba ba nlum ba bo jele bo ka-a a Ijib, me n kehm bake a ega, bo bahke fange bo ana abon ebame; Efriim abola Manase bahke jolo ka me jang jang ana Ruben abola Simion bo li ka-m. ");
INSERT INTO eka_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","A lˈkpe bel abon bandikandiki, bo bahke jolo ba ba, ejum elehkelkv ebo bahke sehnge goji Efriim abola Manase. ");
INSERT INTO eka_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Eji n lohngo go Padan jo kehnge, n jolo ndon ndon ana Rashel kpo go ndi nyi Kenan ngare nyi e kpeke li go mbang, ekidi kpeem ga lab tahm rehng Efrad. N kpa-e kak nkpe a mbang nyi nne kpˈtahme go Efrad, (ji lohngo re Betlehem). ");
INSERT INTO eka_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Eji Isreel nyehne abon ba nlum ba Josef, á kehm bahbe re, <<A ane abaa?>> ");
INSERT INTO eka_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josef kehm faange nde re, <<Abon ba nlum ba Esowo ma-m ka a, ba a.>> Owo Isreel kehm bungu re, <<Ko bo ba ka-m, eji n lˈfuulu bo.>> ");
INSERT INTO eka_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ngare nyia Isreel amahr enye ebkehme elbamme, á nehme ga kpe nyehn tib eji á ma kul. Josef kehm jeere abon ebe kohlo nde, nde kehm sodo bo nnyo fere bingi bo. ");
INSERT INTO eka_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isreel kehm tongo Josef re, <<Me n kpeem bum re m bahke kpe nyehn esamahr eba, wo anv Esowo eblim re me fere tob nyehn abon eba fvfo.>> ");
INSERT INTO eka_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Owo Josef kehm tabe bo go ayo Isreel nde, kehm gongo esamahr ebe go ndi. ");
INSERT INTO eka_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Josef kehm koko bo ane abal abal ba, Efriim á jabb-e go eboblum á jol go ejang ebobkal bi Isreel, Manase á jabb-e go ege egang ebobkal, a jol go ejang eboblum bi Isreel, kehm jeere bo kohlo nde Isreel. ");
INSERT INTO eka_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Isreel kehm tanne eboblum ebe kunu Efriim go esi, jol eji á jolo jol monkalla fere siiri ebobkal ebe kunu Manase go esi, jol eji á jolo jol ngbokambang. ");
INSERT INTO eka_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Owo á kehm fuulu Josef kehm bungu re, <<Nong Esowo bio bi babnsoo Ebraham, a Aisik jo lok-e, Esowo bio bi ma jol mbˈbaabe no elkpin ename tete rehng lela, ");
INSERT INTO eka_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Engel nyi ma-m tahre yehke go nsol nyi jol-m limi, nong á fuulu abonse nlum baa, nong bo jo lung bo go egama mbing, a abing nya babnsoo Ebraham a Aisik, nong bo sahb gbˈgbal go njini.>> ");
INSERT INTO eka_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Eji Josef nyehn re nde tabe eboblum ebe kunu Efriim go esi, atahng we yebem; owo á kehm jabbe nde go ebo re á radde ebo bio go esi ji Efriim feere a bi kunu Manase. ");
INSERT INTO eka_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Josef kehm tongo nde re, <<Eˈee, nsoo noa wo li ngbokambang, kun-e eboblum eba go ege esi.>> ");
INSERT INTO eka_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Wo nde tˈten fere tong-e re, <<N kpˈkahne! Mmon ewame, n kpˈkahne, ye fvfo bahke tob jol ejahbe, ye fvfo bahke tob gbal. Jol ana li o, monkalla mmonannyehn wo bahke ga gbal sehng ye, ellong ajahbe gbalee bahke lohngo ege etˈtohngo.>> ");
INSERT INTO eka_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Á fuulu bo efung bio fere bung re, <<Ega mbing wo anebe Isreel bahke jo tooro elfuulu nia re: <Nong Esowo lim-n wahn jol ana Efriim a Manase.>>> Ano wo jolo re, á rodo Efriim bum ngbokambang ka Manase. ");
INSERT INTO eka_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Owo Isreel kehm tongo Josef re, <<N yahke ba elkpoko, Esowo bahke jolo a nahne, fere ko-n feere a nahne go ndi nyi babnso. ");
INSERT INTO eka_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Wo wo m ma-a ka erohko ndi ajehng kpele, sehnge ji abonane bako, erohko ndi ji n taare anebe Amor go egame ekahngkahng, a elban ename.>> ");
INSERT INTO eka_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Owo Jekob kehm lungu abon ebe ba nlum kehm bungu re: <<Ba jiin senng-m wahn kak me n tong-n nsol nyi bahk-n limi go afung nya kpˈbake. ");
INSERT INTO eka_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","<<Ba kon-n asi wahn wunngu atung, abon ba nlum ba Jekob; wuungen Isreel nso ewahne atung. ");
INSERT INTO eka_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","<<Ruben wo wo li ngbokambang a mmon ewame, eko ejame, ngbokambang elliingi ni nsahm anyame, wob gbal go ekpunu, fere gbal go nsahm. ");
INSERT INTO eka_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Wo wo li alabb ma kil jo yiimi edi ajehng, ekpunu a nehm kpe bel, tibre wob song noongo go edilnong ji nso, wob fili edilnong ji nso rannge. ");
INSERT INTO eka_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simion abola Levi bo abonanyehn ba. Bo kpo ko akahngkahng ebo jo rannge edi. ");
INSERT INTO eka_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Nong me n kˈwoomo go ebo ellong, nong me n kˈkono asi a bo, tibre bob wul ane tib go ebo erakatahng fere banne efong akpade ana koro bo. ");
INSERT INTO eka_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nong nkuk jol ka erakatahng ebo ji kpˈsahb sˈsum, nong nkuk jol ka erakatahng ebo ji kil elgbodo. M bahke limi bo yaame, jol go ndi nyi Jekob, fere lim bo jol adi adi go ellong ni anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","<<Judah, abonanne bahk-a tehke; abo enya bahke jolo go emel anebekv eba. Abon ba nlum ba nso bahke jo gong ka-a. ");
INSERT INTO eka_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah, mmon ewame, wo li ana mmona egabe. Wob wul nnyam enya kehnge a nyi, ba rehng go ega elbad. A nong go ndi ana egabe, a kp-e lehke ana nkal egabe. Nne awoo bahke ma nyeenge egabe elkohn ngare ana nyia? ");
INSERT INTO eka_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ejehm jio ji etul nehm tiki jo lohng go etˈtohngo ji Juda. Abon ebe bahke tiki jo jol atul, tete nfono ejehm noo no etul bahke bake, ye ji ajahbe kpee bahk-e kpunu. ");
INSERT INTO eka_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Juda bahke tohko mbvankang enye go elˈlehke egreb, á bahke kahne mmon a mbvankang go nnobo noba mbˈbo mi greb, á bahke suku akpawobo enye go amahm, esubu eje go akehng greb ");
INSERT INTO eka_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Juda bahke bele amahm elwoko gbalee, bahke wahnge amahr enye bamme, á bahke bele alahbbel ma elwoko gbalee, wahnge amahn enye bahke sahb bˈbar tib esi alahbbel. ");
INSERT INTO eka_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","<<Jebulon bahke lene go nkpe aya, edi eje bahke jolo elga ni asohkkahng bahke jo ba tehme, nkonandi enye bahke jolo rehng go Sidon. ");
INSERT INTO eka_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka li ana mbvankang nyi kpˈsahb tˈtahne, á nong go elka elka ni abam nsol. ");
INSERT INTO eka_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Á lˈnyehn ana edi erekekv eje kpˈnobo, fere nyehn ana ndi enye kpˈtob nob, á bahke tahnge akpakebo enye ka go elsol asolo, fere yake elne ka eltum ni bo bahk-e bobo re a lim. ");
INSERT INTO eka_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","<<Dan bahke lame ane ebe go nseenga nseenge, ana etˈtohngo ajehng go ellong atˈtohngo nya Isreel. ");
INSERT INTO eka_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan bahke jolo nnyo go nkpea nlum mbang, ekumbad go alabmbang, ji bahke jo tokko anyˈnya go aselsel, eji ane ba kun bo bahke jo tuulu gbo feere njahmjahm. ");
INSERT INTO eka_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","<<N kpˈsiki eltahre ena O Jehova. ");
INSERT INTO eka_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","<<Gad, ellong abanokabohng bahke noko a ne, wo á bahke sehnge go njahm jo nok a bo. ");
INSERT INTO eka_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","<<Edi ndi ji Aser, owo nsol alehke nyi nno bahke lohngo, ye wo bahke toobo nsol nyi bahke jo fuumu a ntul. ");
INSERT INTO eka_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","<<Naftali li ana mbilikpa nyi bo me-e fannge go ekehd, ye ji kpo jel anobonobo abon. ");
INSERT INTO eka_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","<<Josef nlehke egreb mi bahke jo kab, ji yim kohlo elbing alahb, ji ayal enye ma taare kuumu go egbunggbung. ");
INSERT INTO eka_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Go ebiltim wo anebelkv ba nok a ne; bo bahk-e take elban go eblum eblum. ");
INSERT INTO eka_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Wo elban ene bahke sake ano ano, atahntahn abo enye bahke sake kpan yiimi, tib go ebo bi Etahntahn Nne no Jekob, tib esi Mbaabebul: ye ji li Ekpartal ji Isreel. ");
INSERT INTO eka_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tib esi ji Esowo bi nso, ye ji kak-a ebo, tib esi ji Nne no Gbale Sehng, ye ji ka-a nfuulu nyi lohng go ero, a nfuulu nyi wob go atahng ndi, nfuulu nyi abel a ejˈjele. ");
INSERT INTO eka_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Elfuulu ni nso kpˈgbale sehnge elfuulu ni babnsoo ejame, sehnge rehng go ero egburu ewong ji ma sahb kˈkul. Nong elfuulu nia kpee kuumu Josef go esi, go elka esi ji nne bo m-e ga kpunu go ellong abonanyehn. ");
INSERT INTO eka_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","<<Benjamin li ana ejo ji kpo bob atem enyam jaake, efungfu á kpo li nnyam nyi á bobo no, ngare elgung á kpo bak bi á ma da.>> ");
INSERT INTO eka_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ane baa kpee ba li ewubu etˈtohngo ebbal bi anebe Isreel, a wo li nsol nyi ndea bo tongo bo, á fuulu nne awohng awohng elkohn elfuulu ana ni fuumu a ne. ");
INSERT INTO eka_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Owo á kehm tubu bo elle nia re, <<M bahke gulu eltahme song kpiri ane ebame, song kak-m wahn go eyele ji babnsoo wob no, go egohng atal, go ekulugbe ji Efron nnea Hid, ");
INSERT INTO eka_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","egohng atal jio li go Makipela kohlo Mamre go Kenan, edi ji Ebraham gunu ekulegbe budu edi eyele akvne goji Efron nne Hid. ");
INSERT INTO eka_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","O edi jio wo bo kake Ebraham abola Sara nkal ewe, o edi jio wo bo kake Aisik abola Rebeka nkal ewe, o edi jˈnehm wo n kake Lia. ");
INSERT INTO eka_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Edi egbe jio a egang ji li o bo gunu goji nne a Hid.>> ");
INSERT INTO eka_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Eji Jekob ma tub abon ebe ba nlum elle mal, á kehm fehde akpade enye kunu edilnong soro v esˈkohro elv kpo song kpiri ane ebe. ");
INSERT INTO eka_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josef kehm gboko bulu nde fere jo ling-e. ");
INSERT INTO eka_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Josef kehm tongo abalimakahm ba jolo o re, bo rod nde taame akehng nkvne kuuru go ekpˈkpa eji á lˈkˈrannge. Owo abalimakahm kehm lohko lim ano, ");
INSERT INTO eka_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Bo ko nfung atahl abal kohro kohro nyi li afung nya bo kpo ko kuuru akvne go ekpˈkpa. Anebe Ijib noongo elkv ene nfung atahl ara a nfung nfung ewubu. ");
INSERT INTO eka_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Eji afung elkv anoongo ma sehng, Josef kehm tongo anebe etahk Fero re, <<Ń lˈjol go eyebatahng a name, lub tongen Fero ka-m, tong-n ye re ");
INSERT INTO eka_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","<Nsoo limi re me n tir ko nwongo a ne re, <<N yake ba elkpoko; song kak-m go elahm bi n rahme bum elname go ndi nyi Kenan.>> Anv, nong me n tahm go song kak Nsoo; m bahke feere ba.>>> ");
INSERT INTO eka_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Fero kehm-e tongo re, <<Song wo song kak Nso, ana á lim-a no a ko nwongo a ne.>> ");
INSERT INTO eka_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Owo Josef kehm tahme re a song kak nde. Atubesi alimeltum ba Fero kpee mehle toon-e, anebkul etahk Fero a alahmlahm anebe Ijib. ");
INSERT INTO eka_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ane kpee ba jolo nlaaga nyi Josef, a abonanyehn ba nlum, go ane ba jolo ka nlaaga nyi nde je a ne, sehngem abon ebo, a efong, ejoro, a ebul baange, bo ba sa go Gosen. ");
INSERT INTO eka_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Amvtv akuungu a ane ba kpo fing bo, bo tob toon-e, jolo egburu ellong ane. ");
INSERT INTO eka_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Eji bo rehnge go edi ji bo kpo ruumu nkohlsal go Atad kohlo aya Jodan bo kpe kehme ellingi wahre wahre wahre sahb mˈmaange bo. O edi jio Josef bumu nfung esehma nyi a ko noongo elkv nde. ");
INSERT INTO eka_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Eji anebe Kenan ba lene o nyehne elkohn aling nya jolo edi ji bo kpo ruumu nkohlsak go Atad bo bungu re, <<Anebe Ijib kpi egburu elkv lim o.>> Owo wahnge edi jio ji jolo kohlo aya Jodan bo kpo lung re, Abel Mijiraim. ");
INSERT INTO eka_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ana wo abon ba nlum ba Jekob limi ana á tongo bo: ");
INSERT INTO eka_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Bo sol-e tahm a ne go ndi nyi Kenan song kake go egohng edi egbe ji Makipela, kohlo Mamre, ji Ebraham gunu budu edi egbe goji nnea Hid, re jol eyele akvne. ");
INSERT INTO eka_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Eji Josef ma kak nde, á kehm feere go Ijib, a abonanyehn, go ane kpee ba toon-e je re á song kak nde. ");
INSERT INTO eka_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Eji abonanyehn Josef nyehne re ndea bo ebkpo, bo kehm bungu re, <<Anv Josef lˈrak atahng tob-r, fere bong-r go asoodo kpee nya e m-e soodo mee?>> ");
INSERT INTO eka_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Owo bo kehm tumu ellum tv Josef re, <<Nso tahme nle nyia sa, kehm kpoko: ");
INSERT INTO eka_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","<Ji ji a ji ḿ bahke bungu tong Josef: m bahb-a re wo tahm ka abonane go abˈbi, a asoodo nya bo lim-a no, eji bo sab-a go elfili.> Anv, titi lub tahm ka abˈbi, nya alokeltum ba Esowo bio bi nso.>> Eji etib ba kpiri Josef, á kehme ellingi. ");
INSERT INTO eka_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Abonanyehn kehm bahke ba gbo noong-e alata, kehm bungu re, <<Wahr aju enya nya.>> ");
INSERT INTO eka_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Josef kehm tongo bo re, <<Kana kpe fahl. Anv me n ko nji nyi Esowoa? ");
INSERT INTO eka_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ń gare re wahn lim-m ebi ejum, wo Esowo ebfere kpiidi lim nnoobo re jol ji kpˈlimi a, eltahre ni elkpin ane gbalee. ");
INSERT INTO eka_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Fvfo kana kpe fahl. M bahk-n leke, a abon abon ebahne.>> Á kpe tuungu bung a bo, á bungu a bo yebe yebe. ");
INSERT INTO eka_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josef jolo o Ijib, a nnahb a nde kpe. Á kange nnya atahlalon a nnya ewubu. ");
INSERT INTO eka_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Fere nyehn etoono eying ebra ji abon ba nlum ba Efriim. Fvfo a abon ba nlum ba Makir mmon a Manase jele kunu Josef go ayo. ");
INSERT INTO eka_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Josef kehm tongo abonanyehn re, <<N yahke ba elkpoko. Fvfo Esowo bahke bake ba tob-n fere yehk-n ndi nyia tahm a nahne go ndi nyi á nyame ko nwongo a Ebraham, Aisik go Jekob.>> ");
INSERT INTO eka_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Josef limi abon ba nlum ba Isreel tir ko nwongo bung rea,<<Esowo bahke tiki ba ba tob-n, ḿ bahke solo akahb enyame lohng a nya edi jia.>> ");
INSERT INTO eka_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Josef kpoo eji á ma kang nnya atahl alon a nnya ewubu. Bo taame ngubjing enye akehng nkvne kak-e ekpˈkpa, bo kak-e go elkohl o Ijib.");
INSERT INTO eka_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Alum nya a nya Mosis bungu no tong anebe Isreel kpee go elka emahng, go ejang ero mfam bi Jodan, ji jolo go edamme ji Araba. Edi jio jolo wane a Suf, go elka elka ni Paran abola Tofel, Laban, Hajaroti a Dijahab. ");
INSERT INTO eka_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Nne lˈsehng mbang nyi egburu ewong ji Sia, bahke koko nne ewubu efung abehng re á mehl go Horeb song rehng go Kadesi Benia. ");
INSERT INTO eka_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Eji ma kang nnya atahl abal, go ngbokambang efung bi ewuba nnyahng amehng, owo Mosis kehm tiingi anebe Isreel nsol kpee nyi Jehova ka-e elkahn bada bo. ");
INSERT INTO eka_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Ngare nyia yeb sehnge Sihon ji jolo ntul no anebe Amor go ebta, ye ji kuumu etul go Hesbon. Go Edreyi, á tob sehnge Og ji jolo ntul no anebe Besan go ebta, ye ji kuumu etul go Astaroti. ");
INSERT INTO eka_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Go ero mfam bio bi Jodan wo Mosis bomo ellennge atahm nyaa ka bo, go ndi nyi anebe Moab re: ");
INSERT INTO eka_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Jehova ji li Esowo ebahre bungu tong-r go Horeb re, <<Wahn ebkang go ewong jia afung gbalee. ");
INSERT INTO eka_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Mehlen wahn soro asi asongo, song yel go ndi nyi anebe Amor, a ajahbe nya li kohlo bo kpee: go edamme ji Araba, go ejahbe ewong, a nya li go ejang ndi erikindi bi eboblum mfam, wahn song yel go ndi nyi anebe Kenan kpee, a awong Lebanon tete song rehng go agburu aya ma Yufriti. ");
INSERT INTO eka_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Nyehnene, m ma-n ka ndi nyia. Song yelen, wahn ko ndi nyio, nyi Jehova tiri re á bahke kake babnso ewahne, - Ebraham, Aesik abola Jekob - a abon abon ebo ba bo bahke jele.>> ");
INSERT INTO eka_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Mosisi tongo anebe Isreel ngare nyio re, <<Ḿ ma-m lub sehng re me n sol-n ana elsol antahng. ");
INSERT INTO eka_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Jehova Esowo ebahne ma-n lim wahn ebrur, wahngka lela ń kpꞌruru ana alonlo nya li go elbung. ");
INSERT INTO eka_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Nong Jehova, Esowo bio bi babnso ewahne kpe-n lim wahn nyab go nkpel atahltahl nkpel ebal atahl awubu, fere fuul-n, ana á nyame no! ");
INSERT INTO eka_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Wo me, m bahke limi renan kehm ma sol atongtong enyahne, a elsol enahne, fere jo toobo afaabe kpee nya ḿ kpꞌbele antahng? ");
INSERT INTO eka_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Yehken akahnkahn ane, ba kpi ngbere, bao ba kpi ekpunu, go etꞌtohngo ajehng ajehng ejahne. M bahke bo kunu ana atubesi ebahne.>> ");
INSERT INTO eka_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Ń faang-m re, <<Ejum ji a ma tir re wo lim, kpꞌnobo. ");
INSERT INTO eka_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Owo n kehm yehke atubesi ane go egahne atꞌtohngo, akahnkahn ane bao ba kpi ekpunu, fere kunu bo re bo jo fil-n, ana atubesi ane atahltahl nkpel ebal atahl awubu, a ba ane atahl alon, a ba ane atahl abal ane awubu, atubesi ane awubu, ana atubesi ba atꞌtohngo. ");
INSERT INTO eka_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Owo n kehm rehke abalamalam ebahne re, <<Jo wuken atongtong nya ma gbo abonane ebahne, wahn jo lam go nseenga nseenge. Jol afi elam jio jolo a nnea Isreel a nnea Isreel noko, afi jol a nne a Isreel a nne ajahmjahm, no lene anahne. ");
INSERT INTO eka_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Kana lam elam njahm anyehng. Wuk ntooro nyi mmonse, jangjang ana a bahke wuku ntooro nyi nnenkul. Kana jo fahl nnene, tibre Esowo bi kpi elam akimi. Elam ji lˈfere gbal sehng-n, ko-n ba ka-m wahn, m bahke toobo ka-n. ");
INSERT INTO eka_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Ngare nyio, n tong-n ejum ajehng ajehng ji jolo re wahn jo lim. ");
INSERT INTO eka_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Owo e kehm mehle go Horeb asongo go ndi awong, ana Jehova Esowo ebahre ka-r elkahn. E sehnge go emenngo nkpaange edi erikendi nyi li wum wum nyio nyi ḿ ma nyehn tete li ba rehng go Kadesi Benia. ");
INSERT INTO eka_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Owo n kehm bungu tong-n re, <<Wahn ebrehng edi awong ji anebe Amor, ji Jehova Esowo ebahre kp-r kake. ");
INSERT INTO eka_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Nyehnen! Jehova Esowo ebahne ma-n ka ndi nyia. Songen, wahn song ko, ana Jehova, Esowo bi babnso ewahne tong-n no. Kana fahl, jol eko ki-n tan. ");
INSERT INTO eka_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Owo wahn ane kpee ḿ ba no ba kpir-m, kehm bungu re, \"Nong wahr tumen ane, bo gbo mbang song feede ndi nyio, bo lˈfeere ba, bo bahk-r tongo bada ajahbe nya e bahke yele, a abang nya e bahke sehnge rehng o. ");
INSERT INTO eka_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Go egame, ntoobo nyio nꞌnob. Owo n kehm yehke ewubu ane na abal, go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Bo kehm tahme, jo wahr asongo go ndi awong. Bo kehm song rehng go edamme ji Esikol, jo yannge jo feede. ");
INSERT INTO eka_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Bo ko akab nti nyandiki nya lohng ndi nyio ba ka-r, kehm bungu ntoorannyo re, <<Ndi nyi Jehova Esowo ebahre kp-r kake, etingi ndi nyi.>> ");
INSERT INTO eka_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Wo wahn joom kor re wahn wahr ewong tahm o, ń yiimi ekungu, tahne esi go elkahn ni Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Ń jo memme go egahna nkpatahk, fere jo bung re, \"Wahr ebtehn Jehova sehng, ji ji wahnge á yehk-r go Ijib, re á ba yak-r kak anebe Amor go abo, eji bo lꞌwul-r. ");
INSERT INTO eka_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Anv, gan wo e bahke kehm jeke? Abonanee ebahre eblim re eko tan-r go elfahle. Bo bungu re, <Ane bao kpꞌtahne, bo li akolo ane sehng-r, ajahbe ebo kpꞌgbale, akahme ebo sahb wˈwahre. Egom ebo jindiki lohng etˈtohngo ji Anak, bo li alabe labe ane fere jˈjok.ˈ \" ");
INSERT INTO eka_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Owo n kehm bungu tong-n re, <<Ki-n mennge, jol kana fahl bo. ");
INSERT INTO eka_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Jehova Esowo ebahne, ye ji ma-n gbo mbang asongo bahke noko ka-n, ana á limi no go Ijib, wahnfono nyꞌnyehn go amahr, ");
INSERT INTO eka_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","a go ndi erikendi nyi li wum wum. Ona ń nyˈnyehn ana Jehova Esowo ebahne rod-n no, ana nde nne kpo rod mmon ewe go mbang eljen enahne kpee tete ḿ ba rehng edi jia.>> ");
INSERT INTO eka_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Jol eji jolo jol ano, ń tikem bum Jehova Esowo ebahne go etingitingi, ");
INSERT INTO eka_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ye ji jo gbo-n mbang asongo go egahne eljen, á jo ka-n agun ngare atv, fere jo jen anahne go ekparesemsem ngara njul. Á jo sebe adi ka-n nya ḿ bahke reke ekv, fere jo tib-n mbang nyi ḿ bahke sehnge. ");
INSERT INTO eka_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Eji Jehova wuku ji ḿ bungu no, eltim rake sehng, á kehm nyame fere sahb tˈtir re, ");
INSERT INTO eka_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","<<Nne awohng awohng limm no wob go eying abꞌbi ane baa, no bahke nyehne nnooba ndi nyi n tiri no re m bahke kake babnso ewahne ba nkul a nkul, ");
INSERT INTO eka_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","sehngem Keleb wo, ji mmona Jefune. Á bahke nyehne ndi nyio, m bahk-e kake ndi nyio nyi á kadde akpade, fere tob ka etꞌtohngo ji abon ebe, tibre á toono Jehova a eltim eltim ene kpee.>> ");
INSERT INTO eka_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Tib go egahne esi, Jehova tob rake atahng a name, fere bung re, <<Wo fvfo, a nehm tob yel. ");
INSERT INTO eka_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Sehngem Josua mmon no Nun, ye ji li nkakebo ewa, ye wo bahke yele. Kak-e eltim, tibre ye wo bahke jene anebe Isreel rehng go edi elehkelkv. ");
INSERT INTO eka_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Abonse ba ń tongo re bo bahke bobo bo go ebta, abon ebahne ba kala kahn ebi, afi kahn eno, bo ba bahke yele ndi nyio. M bahke bo ka, bo bahke koko fere jol nyi bo. ");
INSERT INTO eka_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Wo wahn, senngen njahm, wahn feere asongo go ndi erikendi nyi li wum wum, mbang mbang nyi aya nkpafa.>> ");
INSERT INTO eka_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Owo ń kehm-m faange re, <<Wahr eblim abiafem bada Jehova, e bahke tahme song nok ebta, ana Jehova Esowo ebahre ka-r elkahn. Ano wo nne awohng awohng ewahne rodo nsol ebta gbade, tib ń jo tiri re bahke jolo nkpoodo ejum ka-n re wahn wahr ewong tahm go ndi awong. ");
INSERT INTO eka_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Wo Jehova bungu tong-m re, <<Tong bo re, <Kana tahm ebta, tibre n nehm jol anahne. Anebekv ebahne bahk-n sehnge ebta. ");
INSERT INTO eka_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ano wo n tong-n no, wo m me-e wuungem atung. Ń yiimi ekungu a elkahn ni Jehova ka no, fere mehl egahne agabbe tahm ebta, asongo go ndi awong. ");
INSERT INTO eka_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Owo anebe Amor ba lene o ajahbe awong nyao kehm lohngo ba bom ebta enahne. Bo kam-n ana ekon kpo kam ane, fere wul-n tuubu, bomo mbang mbang nyi Siya song rehng go Horma. ");
INSERT INTO eka_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ń feere ba, jo ba ling go esamahr bi Jehova, jol Jehova bumem na ntir go egahne eling, á bulu na atung enye. ");
INSERT INTO eka_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Ano wo ń kange o Kadesi afung gbalee, ana ń ko ngare jol o. ");
INSERT INTO eka_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Owo e kehm-n sennge, fere kunu asongo, mbang mbang nyi aya nkpafa, ana Jehova tong-m no. E ko afung gbalee jo jen sennge ndi awong nyi Sia. ");
INSERT INTO eka_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Owo Jehova kehm bungu tong-m re, ");
INSERT INTO eka_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","\"Ebko afung tvv nya ń kehme eljene sennge ndi awong nyia. Anv senngen feere go ejang ebobkal. ");
INSERT INTO eka_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Ka ane baa elkahn nia re, <Anv , ń yahke sehng go ndi nyi abonane ebahne, etꞌtohngo ji Eso, Bo ji lene go Sia. Bo bahk-n jo fꞌfahl, wo wahn fvfo, sahb kunen kunu ekpu. ");
INSERT INTO eka_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Kana lim re bo nok ebta anahne. Tibre me wahn nehm ka ndi a bo anyehng anyehng; jol morohko no nne bahke ma kadde ekpade, wahn nehm ka. Me n ka Eso ndi awong nyi Sia, re jol ka-e. ");
INSERT INTO eka_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","M bahke kpiki bo asilva go nsol alehke nyi ḿ bahke lehke, a alahb ma ḿ bahke woko. ");
INSERT INTO eka_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Jehova Esowo ebahne ma-n fuulu go ntum abo enyahne kpee. Á ma-n baabe go eljen enahne sehng go nkpaange ndi erikendi nyi li wum wum. Go nnya atahl abal nyia, Jehova, Esowo ebahne ebjol anahne, jol ejumjum wahn rinem. ");
INSERT INTO eka_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Ano wo e soro asi asongo, song sehng abonanee ebahre, etꞌtohngo ji Eso bo ji lene go Sia. E gbake mbang nyi li ndi nyi li rede rede nyi Araba sa, nyi lohngo go Elati a Ejiyon Geber, fere jo toono mbang ndi erikendi nyi li wum wum nyi Moab. ");
INSERT INTO eka_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Owo Jehova kehm bungu tong-m re, <<Kana lim ntong a anebe Moab, jol kana lim re bo nok ebta anahne. Tibre me wahn nehm ka ejang ndi ebo ajehng ajehng. Me n ka mfam nyi Ar, re jol ejum elehkelkv ebo.>> ");
INSERT INTO eka_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Anebe Emim jo lene o, bo ji jolo go nrur, fere tˈtahne. Bo jolo akola ane ana anebe Anak. ");
INSERT INTO eka_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Ana anebe Anak, bo fvfo bo jo ko bo ana anebe Refati, wo anebe Moab jo lungu bo re anebe Emim. ");
INSERT INTO eka_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Anebe Hor jo tob lene go Siya, wo etˈtohngo ji Eso kˈkam bo yehke. Bo tane anebe Hor, fere lene go ebo edi, ana anebe Isreel tob lim go ndi nyi Jehova ka bo re jol nyi bo. ");
INSERT INTO eka_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Owo Jehova kehm bungu tong-r re, <<Mehlen wahn siiri edamme ji Jered.>> Ano wo e tahme song siiri edamme jio. ");
INSERT INTO eka_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Bomo ngare nyi e mehle go Kadesi Benia tete e ba siiri Edamme ji Jered, ebsehnge eltahl a nnya elku a nnya era. Ngare nyio, eying anebe ebta anoko kohrokohro ebkpo mal go egahre ellong, ana Jehova tiri tong bo. ");
INSERT INTO eka_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Ebo bi Jehova noko a bo, tete ˈa tane bo egahre ellong kpee. ");
INSERT INTO eka_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Eji erik abanoko ebta bao ba woomo egahre ellong ma gohro kpo, ");
INSERT INTO eka_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Jehova kehm bungu tong-m re, ");
INSERT INTO eka_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","<<Lela ḿ bahke sehnge go Ar, go ejang ndi nyi Moab. ");
INSERT INTO eka_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ń lꞌba goji anebe Amon, kana lim mfem a bo, jol kana lim re bo nok ebta anahne. Tibre me wahn nehm ka ejang ndi ajehng ajehng ji anebe Amon re jol jꞌjahne. Me n ka etꞌtohngo ji Loti, re jol ji bo. ");
INSERT INTO eka_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Ndi nyio fvfo, bo jo tob ko ana ndi nyi anebe Refa, bo ji jo lene o. Wo anebe Amon jo lungu bo re anebe Jamjum. ");
INSERT INTO eka_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Bo jolo go nrur ane, fere tꞌtahne. Bo jolo akola ane ana anebe Anak. Jehova rannge bo go esamahr bi anebe Amon. Anebe Amon kehm kame bo yehke fere ba lene go ebo a ndi. ");
INSERT INTO eka_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Jehova tob limi ano ka abon etꞌtohngo Eso, bo ji lene go Siya, eji á rannge anebe Hor go ebo esamahr. Bo kame bo yehke, fere song lene go ndi anebe Hor tete sik lela. ");
INSERT INTO eka_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Ana anebe Av ba no ba lene go abon ajahbe tete song rehng go Gaja, anebe Kabtor ba lohngo go Kabtor, ba rannge bo, fere lene go ebo a ndi. ");
INSERT INTO eka_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","<<Jehova tob bungu>> re, <Mehlen anv, wahn song siiri edamme ji Arnon. Me n jabbe Sihon ji nnea Amon, ye ji li ntul no Hesbon kak-n go ebo, a ejahbe eje. Bom elkoko ndi enye, wo fere bohk-e ebta. ");
INSERT INTO eka_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Lela lela, m bahke nehke ajahbe kpee nya li go njini, fere kak bo elfahle ena. Bo bahke wuku eka bade anahne fere jo kˈkahm, a egburu elfahle tib go ejahne esi. ");
INSERT INTO eka_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","N sa go ndi erikendi nyi li wum wum nyi Kedemoti tiingi etib tv Sihon ji jolo ntul no Hesbon a alum elkoono, fere tong-e re, ");
INSERT INTO eka_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","<<Nong wahr sehng go ega ejahbe. E bahke jo sehng mbang mbang, jol e nehm gahl yange ejang ebobkal afi ejang eboblum. ");
INSERT INTO eka_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Gung-r nsol alehke a alahb go ekun bi asilva, lub yak-r wahr jen akpade sehng. ");
INSERT INTO eka_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Ana abon ba Eso, bo ji lene go Siya, a anebe Moab ba lene go Ar limi no, tete n siiri aya Jodan song yel ndi nyi Jehova Esowo ebahre kp-r kake.>> ");
INSERT INTO eka_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Wo Sihon ji ntula Hesbon taamem re wahr sehng. Tibre Jehova Esowo ebahne limi re á bel etahnsi go etohko, fere bel etahneltim, eji á lˈyak-e kak-n go egahne abo, ana á ma lim anv. ");
INSERT INTO eka_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Jehova kehm bungu tong-m re, <<Nyehne! Me n bom elyake Sihon, a ejahbe eje ka-n. Bom-n bo esehngebta, wahn fere ko ndi enye.>> ");
INSERT INTO eka_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Eji Sihon a nsoja enye kpee lohngo no ba elnoko anahre go Jahaji, ");
INSERT INTO eka_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Jehova Esowo ebahre, yak-e ka-r, ano wo e wul-e no, a abon ebe, a nsoja enye kpee. ");
INSERT INTO eka_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Ngare nyio e ko agburu ajahbe enye kpee, fere rannge kpee, aneblum, anebkal a abonse. Jol e yakem nne awohng awohng, a jol go elkpin. ");
INSERT INTO eka_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Sehngem re atohkondi nya e da ka elnahre, a nsol nyi e da go agburu ajahbe nya e noko ebta ko. ");
INSERT INTO eka_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Bomo gona Arowe ji li go nkpe edamme ji Anon, a a egburu ejahbe ji li o edamme, tete rehng go Giled, egburu ejahbe anyehng anyehng jolem ji akahme enye wahre sehng-r, Jehova Esowo ebahre yake kpee kak-r go ebo. ");
INSERT INTO eka_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Toono ana Jehova Esowo ebahre ka-r elkahn re, Kana yel go ndi anyehng anyehng nyi anebe Amon, jol go ndi nyi li nkpe nkpe aya ma Jabok, afi ajahbe nya li sennge ajahbe awong. ");
INSERT INTO eka_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Owo e kehm feere sennge asongo jo wahr mbang mbang asongo go Basan, fvfo Og ntula Basan kehm lohngo abake a nsoja enye kpee, re á ba nok ebta anahre go Edireyi. ");
INSERT INTO eka_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Jehova kehm bungu tong-m re, <<Kana ye fahl, tibre m m-e yake kak-n go abo, a nsoja enye kpee a ndi a ndi enye. Limen ye ana ń limi Sihon ji ntul anebe Amor, ye ji jo fili edi go Hesibon.>> ");
INSERT INTO eka_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Ano wo Jehova Esowo ebahre tob yake Og ntula Basan kak-r ebo a nsoja enye kpee. E wulu bo ane kpee, jol nnene saam. ");
INSERT INTO eka_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Ngare nyio, e ko ajahbe enye kpee. Egburu mfam anyehng anyehng saam, go ellong ejahbe atahlara nyao, nya jolo kpee go ejang erohko ndi nyi Arigob, go nji etul nyi Og go Basan, ji wahr kii ko. ");
INSERT INTO eka_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Agburu ajahbe nyaa kpee bo si awahre wahre akahme sennge kak, fere kak atimbu nya bo jo ko alahmlahm akuungu bam. E tob ko abon ajahbe bako gbalee ba bo kii si akahme sennge, jol nfange wobem. ");
INSERT INTO eka_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","E rannge bo kpee, ana e limi Og ji ntula Hesibon. E rannge egburu ejahbe ajehng ajehng, wul aneblum a anebkal, abonse abonse. ");
INSERT INTO eka_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Wo atohkondi kpee, a nsol nyi bo da go ebta go agburu ajahbe ebo, e ko fere jol nya nyahre. ");
INSERT INTO eka_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Ano wo ngare nyio e ko ndi nyi li feere go ero mfam nyi aya Jodan, bomo go edamme Arnon tete rehng go egburu ewong ji Hermon go abo nya atul abal bao ba Amor. ");
INSERT INTO eka_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Anebe Sidon kpo lung Hermon re Sirion, anebe Amor kpo lung re Seni) ");
INSERT INTO eka_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","E ko ajahbe kpee nya li go ndi ebale bale, go ero ewong, a Giled kpee, go Basan kpee tete rehng go Saleka a Edireyi, nya jolo ajahbe nya nji etul nyi Og go Basan. ");
INSERT INTO eka_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Og ji ntula Basan ntahngtahng wo sa, go ellong ane ba bo jo lung bo re Refa. Elkohl nkvne ene bo ko akuungu lim, labe sehnge ewubu efiti ebra, fere kpange sehnge efiti ebrakebra. Jia tiki kpe li go Raba ji anebe Amon. ");
INSERT INTO eka_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Bada ndi nyi e ko no ngare nyio, n ka anebe Ruben a anebe Gad ndi nyi bomo go ejang ebobkal mfam bi Aroye, go nkpe nyi Edamme ji Arnon, a ejang ndi nyi ndi awong nyi Gilead, nyi m bake jangjang go edi ebbal, a abon ejahbe ebo kpee. ");
INSERT INTO eka_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Ejang Giled jehko a Basan kpee, ji jolo ejahbe Og, n ka ejang etˈtohngo ji Manase. (Erohko ndi nyio nyi Basan kpee bo jo lungu re ndi nyi anebe Refa. ");
INSERT INTO eka_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jayir ji lohngo etˈtohngo ji Manase wo ko ndi nyi Arigob kpee nyi li Basan, tete rehng go nseenge nyi anebe Gesu, a anebe Maaka. Bo rodo ndi nyio gung-e ebehn, ji ji wahnge tete sik lela bo kpo lung re abona ajahbe ba Jayir.) ");
INSERT INTO eka_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Giled, n ka Makir. ");
INSERT INTO eka_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Wo anebe Ruben a anebe Gad, n ka bo ejang ndi ji bomo go Giled rehng go edamme ji Arnon. Nseenga bo jolo elka elka ni edamme jio, sehng ano song rehng go aya ma Jabok ma li nseenge nyi anebe Amon. ");
INSERT INTO eka_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Nseenge nyi erede mfam jolo go Jodan gona edamme ji Araba, bomo go Kenereti rehng go agburu aya ma Araba (Aya Elkv) nkpe ewong ji Pisiga ji li ero mfam. ");
INSERT INTO eka_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Ngare nyio n ka-n elkahn re, <<Jehova Esowo ebahne ma-n ka ndi nyia re jol nyˈnyahne. Wo alahmlahm aneblum ebahne kpee bahke gboko anebe Isreel mbang, a nsol ebta ebo, song siiri Jodan. ");
INSERT INTO eka_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Limi limi kan, akal ebahne a abon ebahne, go atohkondi enyahne <<n kpˈkahne re ń kpi atohkondi gbalee>> bo bahke ma sa go ajahbe nya m ma-n ka. ");
INSERT INTO eka_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Ḿ bahke tahme a abonane abahne, tete Jehova tob ka anebe Isreel ebahne bako erekekv, ana á ma-n ka, bo fvfo tob ko ndi nyi Jehova Esowo ebahne ma ka bo go egbuk Jodan jehko. Jia lꞌjol ano, owo nne awohng awohng ewahne bahke ma feere go ndi enye nyi n ka-e no. ");
INSERT INTO eka_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Ngare nyio n ka Josua elkahn re, <<Wobko amahr enya nyehn nsol kpee nyi Jehova Esowo eba ma lim atul abal baa. Ejum jꞌnehm ji Jehova bahke limi ajahbe etul kpee nya ń kpˈsiiri song yel. ");
INSERT INTO eka_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Kahna fahl bo, Jehova Esowo ebahne antahng, ye wo bahke noko ka-n.\" ");
INSERT INTO eka_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Ngare nyio n gboongo Jehova re, ");
INSERT INTO eka_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","<<Jehova ji gbale sehng, wobbom na eltibi nlokeltum ewa agbal enya a egburu nsahm enya. Anv, Esowo abii li go elbung afi go ndi, bi bahke ma lim ntum ana nyia, a agburu nsol nya wo kpo lim? ");
INSERT INTO eka_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Titi, nong me n lub siiri song nyehn nnooba ndi nyio, go egbuk ji Jodan, nnooba ndi awong nyio, a Lebanon.>> ");
INSERT INTO eka_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Wo tib esi ejahne, Jehova rake atahng a name, jol á m-e wuung-m atung. Jehova faang-m na re <<Jio ebgbal.>> Ka kpe tiki bung aname bade ejum jia. ");
INSERT INTO eka_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Wahr, wo song go ero ewong ji Pisiga, wo keebe seenge go erede mfam, a ejang ebobkal, tob seenge ejang eboblum a ero mfam. Ko amahr enya wo seenge ndi nyio, tibre a nehm siiri Jodan jia. ");
INSERT INTO eka_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Wo ka Josua nsahm, fere kak-e eltim, ka-e atahne. Tibre ye wo bahke koko ane baa song siiri aya ma Jodan, fere lim re bo ko ndi nyio nyi wo bahke nyehne. ");
INSERT INTO eka_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Ano wo e jol-n o edamme kohlo Beti Peor. ");
INSERT INTO eka_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Owo Mosisi kehm bungu tong ane bao re, <<Wuken anv, ajehke a atahm nya n yahk-n tib. Jo toonen atahm nyao, eji ń lꞌkpin, fere song ko ndi nyio nyi Jehova, Esowo bi babnso ewahne kp-n kake.>> ");
INSERT INTO eka_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Kana budu ejumjum go nkahn nyi n kp-n kake, jol kana yehke. Bumen nkahn nyi n kp-n kake, nyi Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Wahn ebko amahr enyahne nyehn ji Jehova limi no go ewong ji Por. Jehova Esowo ebahne rannge ane kpee go egahne ellong, bo ji tahme no toono esowo bi baal go ewong ji Por, ");
INSERT INTO eka_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","wo wahn kpee, wahn jio ji yiimi tꞌtahne a Jehova Esowo ebahne, ń li go elkpin lela. ");
INSERT INTO eka_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Nyehnen, m ma-n tib atahm a eltibi ana Jehova Esowo ebame ka-m elkahn, eji ń lˈjo toono atahm nyao, go ndi nyi ń kpꞌyele re wahn song ko jol nyi nyahne. ");
INSERT INTO eka_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Jo kunen ekpu wahn jo bum atahm. Tibre ano wo ajahbe nyako bahke nyehne ngbere a ekahnafem ejahne; bo bahke wuku bade ajehke nyaa kpee, fere jo bung re, <<Etingitingi, egburu ejahbe jia, bo li akahnkahn ane ba kpi ngbere.>> ");
INSERT INTO eka_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ejahbe ajii kpeka li go, ji gbale ana, bo ji asowo ebo li badbad a bo ana Jehova Esowo ebahre li a nahre ngare anyehng anyehng nyi e kake ero ka-e? ");
INSERT INTO eka_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Ejahbe ajii kpeka li go, ji gbale ana, ji kpi atingi atahm a eltibi ana nya n kpˈkoko ba ka-n lela. ");
INSERT INTO eka_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Lub jo kunen na ekpu, wahn fere jo sahb bˈbaabe elnahne, eji ń lꞌkꞌyini nsol nyi amahr enyahne ma nyehn, afi jol lꞌki-n lohng go eltim ana ń li go elkpin. Jo tiben abon ebahne nsol nyia, a abon abon ebahne ba bahke toono bo. ");
INSERT INTO eka_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Buumen efung bi ń yiimi esamahr bi Jehova Esowo ebahne go egburu ewong ji Horeb, eji á bungu tong-m re, <<Lung ane kono edi ajehng go egame esamahr, eji ń lꞌwuk alum enyame, eji bo lꞌkahn ana bo bahke jo ka-m egburu kpunu ngare kpe kpe nyi bo li elkpin go ndi nyia, fere tob jo tib abon ebo. ");
INSERT INTO eka_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ḿ baa, ba yiimi go mbangenahb ewong jio, ngare nyio agun jo lulu ewong tete rehng go elbung, nnyakenyake ekparesemsem tob jolo o, a nlum ejannge. ");
INSERT INTO eka_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Owo Jehova kehm sake o ellul agun nio bung anahne. Wahn wuku ewahl alum alum, jol nnene ń nyehnem, sehngem ellum ni ni ḿ wuku no. ");
INSERT INTO eka_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Á lennge nwongo enye ka-n, nkahn na ewubu nyio, nya á jehke ka-n re wahn jo toono, nya á fere nyon go ekpake taale na abal. ");
INSERT INTO eka_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Ngare nyio Jehova tong-m re me n tib-n atahm a eltibi ni ḿ bahke jo toono go ndi nyio nyi ń kpꞌsiiri Jodan song ko. ");
INSERT INTO eka_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Ń nyehnem elfoongo ni ejum ajehng ajehng efung bio bi Jehova jo bung anahne gona ellula agun go Horeb. Fvfo, jo kunen elnahne ekpu nꞌnob, ");
INSERT INTO eka_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","eji ń lꞌkꞌrannge elnahne fere lim elom ka elnahne, elkohn elok elom ji kpi elfoongo anehng anehng, ji li go elfoongo ni nnenlum, afi elfoongo ni nnenkal, ");
INSERT INTO eka_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","afi ji li ana ejum ajehng ajehng ji kpꞌjene go ndi, afi ana ebruk bi kpꞌfonngo go elbung, ");
INSERT INTO eka_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","jol kꞌjol ana ejum ajehng ajehng ji kpo tohng ala go ndi, afi ana nsahre anyehng anyehng nyi wob go atahng alahb. ");
INSERT INTO eka_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ń lꞌkpiidi amahr enyahne seenge go elbung, fere nyehn nsol nyio nyi li go elbung, ana njul a ebareka, afi alonlo, ka bel elgaare go ega eltim re wo gong ka bo fere jo kak nsol nyio nyi Jehova Esowo ebahne ma bak ka ajahbe kpee nya li go nla elbung. ");
INSERT INTO eka_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Wo wahn, Jehova ba ko-n, fere yehk-n go agun nyao nya kpo nyane akuungu, á yehk-n go Ijib re wahn jol ejum elehkelkv eje, ana ń li no lela. ");
INSERT INTO eka_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Jehova eltim rak-e tob-m tib go egahne esi, á sahb tꞌtir re me n nehm siiri Jodan fere yel go nnooba ndi nyio nyi Jehova Esowo ebahne kp-n kake ana ejum elehkelkv. ");
INSERT INTO eka_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Me m bahke kpoko go ndi nyia; n nehm siiri Jodan; Wo anv, wahn yahke siiri song ko nnooba ndi nyio. ");
INSERT INTO eka_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Jo kunen ekpu, wahn kꞌyini egbanngalung ji Jehova Esowo ebahne ji á limi a nahne. Kana rahm elokelom ka elnahne go elfoongo ni ejum ajehng ajehng ji Jehova Esowo ebahne ma ten. ");
INSERT INTO eka_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Tibre Jehova Esowo ebahne, ye agun nya kpo lul fere fꞌfi nya, á li Esowo bi kpo kpu elkahre. ");
INSERT INTO eka_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Ngare nyi ḿ ma bel abon, a abon abon ebahne, eji ḿ ma lene ndi nyio ekidi ma lab, ń lꞌfere rannge, fere jo rahm elkohn elokelom ajehng ajehng fere jo lim abꞌbi go esamahr bi Jehova Esowo ebahne eji eltim lꞌrak-e, ");
INSERT INTO eka_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","me n lung elbung a ndi re bo yiimi ntianse bada anahne lela re, ń bahke gulu elkpoko tan go ndi nyi ń kpꞌsiiri Jodan re wahn song ko, ngare nehm lab nyi ḿ bahke lene o, bo bahk-n lohko wul. ");
INSERT INTO eka_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Jehova bahk-n yaame kak go ellong ajahbe nyako, sehngem abon amohk ane abik abik ba bahke sake, ba bahke jolo go elkpin go ajahbe nya Jehova bahk-n kame kak. ");
INSERT INTO eka_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ona, ḿ bahke jo kak asowo nya ane ko nti a atal rahm, nyao nya lꞌkꞌma nyehn, fere wuk, afi fere li nsol, jol bo nehm ma wuk esꞌsvv. ");
INSERT INTO eka_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Wo ń lꞌfere seb Jehova Esowo ebahne go ajahbe nyao nya ń li no, ḿ bahk-e nyehne, ń lꞌsebe a ntim a ntim enahne kpee a atohko atohko enyahne kpee. ");
INSERT INTO eka_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ngare nyi ń li go akanya, eji nsol nyia kpee ma gbo tub-n, owo behnjehle go, ḿ bahke feere goji Jehova Esowo ebahne fere jo wuk-e. ");
INSERT INTO eka_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Tibre Jehova Esowo ebahne li Esowo bi ane kpo fil-e ndon. Á wahn nehm ten, á wahn nehm wul, jol a nehm yini enyam bi á nyame no tong babnso ewahne, ji á ko nwongo lim re yiimi. ");
INSERT INTO eka_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Bahben anv, bade afung nya mahne mahne nya jolo no ngare enyahne kehm rehnge, bomo go afung nya Esowo limi nne bum go ndi nyia. Bahben go ejang njini ajehng tete rehng ajehko. Egburu ejum ana jia ebjꞌjola? Afi ane ebwꞌwuk ejum ana jiaa? ");
INSERT INTO eka_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ejahbe ajehng ajehng go ebwꞌwuk ellum ni Esowo kpꞌbungu a bo go ellul agun ana wahn ma wuk, fere jol go elkpina? ");
INSERT INTO eka_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Anv esowo abehng abehng ebgꞌgaare re á yehke ejahbe go atahng ejahbe jehko ka elne a elgare ni a jo ko wuungu bo, a nliingi, a akpokosi nsol, a nta, a egburu eko eje a nsahma? Afi esowo bio eblˈlim ano a atahntahn amennge nsol nya a limi no, ana nsol kpee nyi Jehova Esowo ebahne limi no ka-n go Ijib go egahne Esamahr? ");
INSERT INTO eka_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Jehova tib-n nsol nyia, eji ń lꞌkahn re Jehova Esowo bi. A lꞌsehng ye sa, Esowo abehng abehng kpeem li. ");
INSERT INTO eka_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Á sa go elbung jo lim-n re wahn wuk alum enye, eji á lꞌgonen. Ga ndi, a tib-n agburu agun enye, ń fere wuk alum enye nya jo bung go atahng agun. ");
INSERT INTO eka_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Tibre babnso ewahne ba nkul jo kor-e kor, jiji wahnge á yehke etꞌtohngo abon ebo, fere ko Elwo ene a egburu eko eje, yehk-n go Ijib, ");
INSERT INTO eka_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","re á gbo-n mbang song kam ajahbe nya kpꞌgbale fere tꞌtahne sehng-n, fere ko-n ba kak go ebo a ndi, eji á lꞌka-n ana ejum elehkelkv ana li no lela. ");
INSERT INTO eka_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Jo liingen ye, wahn fere ko kak egahna ntim lela re, Jehova wo li Esowo gona ero elbung, a atahng ndi. Esowo abehng abehng go kpeem li. ");
INSERT INTO eka_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Jo bumen atahm enye, a nkahn enye, nya n kp-n kake lela, eji lꞌnob anahne, a abon ebahne ba bahke jini toon-n, eji ń bel nlaabe elkpin go ndi nyi Jehova Esowo ebahne kp-n kake re jol enyahne nkahl nkahl. ");
INSERT INTO eka_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Owo Mosis kehm yabe ejahbe era bum eje eje, nya jolo go ero mfam bi Jodan, ");
INSERT INTO eka_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","nyao nya nne awohng awohng no ma wul nne, bahke ma be song yel, lꞌfere jol re á wulu nnebjing ewe go efin, jol bo limm na go ekv wuku wuku. Á bahke ma be yel mfam ejahbe anyehng, go ajahbe nyaa a, tahre elne. ");
INSERT INTO eka_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Agburu ajahbe nyao nya a: Bejer ji li go ndi ebalebale nyi ero ewong, jolo ka anebe Ruben; Ramoti ji li go Giled, jolo ka anebe Gad; a Golan ji jolo go Basan, jolo ka anebe Manase. ");
INSERT INTO eka_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ntahm nyia nyi Mosis lennge ka anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","A wo li nkahn, atahm a eltibi ni Mosis ka bo, eji bo lohngo go Ijib asongo, ");
INSERT INTO eka_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","eji bo jolo go edamme kohlo Beti Peor ero mfam nyi Jodan, go ndi nyi Sihon ji jolo ntul no anebe Amor. Ye wo jo fili Hesibon, ye ji Mosis a anebe Isreel ga-e no go ebta, eji bo lohngo go Ijib asongo. ");
INSERT INTO eka_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Bo song ko ndi enye, a nyi Og ji jolo ntul no Basan, bo ane abal abal jolo atul anebe Amor go ero mfam nyi Jodan. ");
INSERT INTO eka_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Ndi nyia bomo go Aroye, go nkahl nyio nyi edamme ji Arnon, song rehng go egburu ewong ji Siriyon ( ji li Hebron.) ");
INSERT INTO eka_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Tob budu ndi nyi Araba kpee go ero mfam nyi Jodan tete rehng go aya akang go edamme ji Pisiga. ");
INSERT INTO eka_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Owo Mosis kehm kuku anebe Isreel kpee, kehm bungu tong bo re, <<Anebe Isreel, wuken atahm a eltibi ni n kpꞌbungu re wahn wuk lela. Kpilen, wahn fere jo kunu ekpu jo toono. ");
INSERT INTO eka_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Jehova Esowo ebahre limi egbanngalung anahre go ewong Horeb. ");
INSERT INTO eka_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Babnso ewahre sang Jehova limi egbanngalung jia a bo, á limi anahre, á limi a wahr ane kpee ba li go elkpin a lela. ");
INSERT INTO eka_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Yefono Jehova wo ba bung anahne, sehng go ellulagun go ewong. ");
INSERT INTO eka_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Ngare nyio n yiimi elka elka ni Jehova a wahn jo lennge alum nya Jehova ka-n, tibre ń jo fahle agun nyao, ń wahrem je go ewong. Jehova bungu re, ");
INSERT INTO eka_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","<<Me wo li Jehova Esowo ebahne bi yehk-n go Ijib, go ndi nyi ń jolo aju. ");
INSERT INTO eka_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Kana bel asowo nyako buda name. ");
INSERT INTO eka_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Kana lim elok elom ka elnahne, ji li go elfoongo ni ejum ajehng ajehng go elbung, afi go ndi, afi go alahb ma li go ndi. ");
INSERT INTO eka_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ń nehm gong ka bo, jol ń nehm gong kak bo. Tibre me, Jehova Esowo ebahne, n li Esowo bi kpo kpu elkahr. N kpo kak abon erem go abiafem nya babnde ebo rehng go eying ebra, a eying ebni bio bi ane ba n kil jo kor bo. ");
INSERT INTO eka_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Wo n kpo tib ane bao ba n kpo kor bo elkoro, bo ji kpo bum nkahn enyame rehng eying atahltahl nkpele ebal atahl awubu. ");
INSERT INTO eka_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Kana rod mbing nyi Jehova Esowo ebahne daange, tibre Jehova nehm ka nne awohng awohng eno, no kpo rod mbing enye daange. ");
INSERT INTO eka_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Jo bumen efung Erekekv, wahn fere jo bum saang, ana Jehova Esowo ebahne ma-n ka elkahn. ");
INSERT INTO eka_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Nfung erakera nyi ḿ bahke koko jo lim ntum enyahne kpee. ");
INSERT INTO eka_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","wo efung bi biingi nfung esehma bahke jolo efung erekekv ka Jehova Esowo ebahne. Efung bio, a nehm lim eltum anehng anehng - Wofono afi mmon ewa no nlum, afi no nkal, afi nlokeltum ewa no nlum afi no nkal, jol nluma mfong enya, jol afi mbvankang, afi nnyam anyehng anyehng enya, afi njenne nyi ma ba lene tob-n go egahne ejahbe. Eji nlokeltum ewa no nlum a no nkal, bo lꞌtob re ekv ana wahn. ");
INSERT INTO eka_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Buumen re wahn jolo aju go Ijib, re Jehova Esowo ebahne wo tanne etahntahn ebo ebe yehk-n o. Fvfo Jehova Esowo ebahne ma-n ka elkahn re wahn jo bum Efung Erekekv. ");
INSERT INTO eka_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Jo kpunen babnso abola babnne, ana Jehova Esowo ebahne ma-n ka elkahn, eji lꞌnob anahne, ń fere bel nlaabe elkpin go ndi nyi Jehova Esowo ebahne kp-n kake. ");
INSERT INTO eka_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Kana wul nne. ");
INSERT INTO eka_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Kana lim erehbe. ");
INSERT INTO eka_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Kana v ejv. ");
INSERT INTO eka_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Kana yiimi ntianse efahnge bade nnebjing ewahne. ");
INSERT INTO eka_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Kana baare nkala nnebjing ewahne amahr. Kana yehke ntir atahng enyahne kunu go etahk nnebjing ewahne, afi ndi enye, afi nlokeltum ewe no nlum, afi no nkal, afi mfong enye, afi mbvankang enye, afi jol ejum ajehng ajehng ji nnebjing ewa. ");
INSERT INTO eka_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Nkahn nyi a, nyi Jehova jo bung wahre wahre ka ellong ane ebahre kpee go agun nya jo lul go ewong jio, ekparesemsem jolo o, a nlum ejannge, jol a kpeem bung ejum budu. Owo á kehm nyono go ekpake taale ebbal, faake ka-m. ");
INSERT INTO eka_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Eji ń wuku ellum nio ni lohngo go nlum ejannge, eji agun jo lul go ewong jio, atubesi ane kpee ba atꞌtohngo enyahne, a anebkul ebahne lohngo ba kpir-m. ");
INSERT INTO eka_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Ń kehm bungu re, <<Jehova Esowo ebahre ma-r tib ellub ene, a agbal enye, wahr ebwuk ellum ene ni jo bung go agun. Lela wahr ebnyehn re nne bahke ma kpin, jol afi Esowo bungu a ne. ");
INSERT INTO eka_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Wo anv, jenji wahnge wahr bahke kpoko? Agburu agun nyaa, bahk-r fehke, e bahke kpoko e lꞌfere kpe wuk ellum ni Jehova Esowo ebahre. ");
INSERT INTO eka_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Nne awoo no li go elkpin, no ma wꞌwuk ellum ni Esowo bi li go elkpin kpꞌbungu go agun ana wahr ma wuk a, fere kpe jol go elkpin? ");
INSERT INTO eka_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Wo jeere kabbe, wo wuungu atung ejum ajehng ajehng ji Jehova Esowo ebahre bahke bungu. Wo ba tong-r ajehng ajehng ji Jehova Esowo ebahre tong-a no. Wahr bahk-a wuungu atung, fere lim.>> ");
INSERT INTO eka_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Jehova wuk-n wuk eji ḿ bungu aname, owo Jehova kehm bungu tong-m re, <<Me n wuk ji ane baa ma bung tong-a. Ejum ajehng ajehng ji bo bungu no, bo bungu nseenge. ");
INSERT INTO eka_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Eye, li re ntim ebo bahke lub sennge feere go egame bo jo fahl-m, fere jo bum nkahn enyame ngare anyehng anyehng, eji lꞌnob abo, a abon ebo go njinanjini! ");
INSERT INTO eka_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","<<Song, wo song tong bo re bo feere song go eboa nkpatahk. ");
INSERT INTO eka_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Wo, wo bahke jolo aname a, eji n lˈka-a nkahn kpee a ajehke, a atahm nya a bahke tibi bo re bo jo toono go ndi nyi n kpˈkake bo re bo ko, fere jol nyi bo. ");
INSERT INTO eka_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Belen ekunukpu wahn jo lim ji Jehova Esowo ebahne ma-n ka elkahn; kana sennge feere go ejang eboblum afi ejang ebobkal. ");
INSERT INTO eka_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Jo jenen a ekpunu go nsol kpee nyi Jehova Esowo ebahne ma-n ka elkahn, eji ń lˈjol go elkpin, bahke tob nob anahne, afung enyahne bahke labe go ndi nyi ń fi song ko, fere jol nyˈnyahne. ");
INSERT INTO eka_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","<<A wo li nkahn, atahm a eltibi, nya Jehova Esowo ebahne tong-m re me n tib-n wahn jo bum, go ndi nyi ń kpꞌsiiri Jodan song ko, ");
INSERT INTO eka_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","eji wahn a abon ebahne, a abon ebo, ba bahke toono bo, bahke fahle Jehova Esowo ebahne, ngare kpee nyi ḿ bahke jolo go elkpin, fere jo bum ajehke enye kpee a nkahn nyi n kp-n kake, eji ń lꞌbel nlaabe elkpin. ");
INSERT INTO eka_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Wuken, wahn anebe Isreel, wahn fere jo kunu ekpu jo kpunu, eji lˈnob anahne, eji ń lꞌsahb nyꞌnyab go ndi nyia nyi alahbbel kpꞌfabe a akehng ekon ana Jehova Esowo bi babnso ewahne nyame tong-n. ");
INSERT INTO eka_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Isreel wukeno! Jehova Esowo ebahre, ye antahngtahng wo li Jehova. ");
INSERT INTO eka_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Nong Jehova Esowo ebahne jo kor-n, a ntim a ntim enyahne kpee, a atohko atohko enyahne kpee, a atahne atahne enyahne kpee. ");
INSERT INTO eka_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Nong nkahn nyia, nyi n kp-n kake lela, woom-n go egahna ntim. ");
INSERT INTO eka_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Kaken alum nyao go ntim nyi abon ebahne. Jo bungen bade o ngare nyi ń jehk go etahk, a ngare nyi ń kpˈjene go alab mbang, ngare nyi ḿ ma noongo, go ngare nyi ḿ ma nyahme. ");
INSERT INTO eka_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Kahnen go egahne abo, a abuk enyahne ana ejum elbuumu. ");
INSERT INTO eka_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Nyonen go ntimbu nyi ntahk enyahne, a ntimbuga enyahne. ");
INSERT INTO eka_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Ngare nyi Jehova Esowo ebahne lˈko-n ba kak go ndi nyi á tiri tong babnso ewahne, Ebraham, Aesik, a Jekob re á bahk-n kake ndi nyꞌnehm o, ndi nyi kpi agburu ajahbe nya ane kpꞌruru , nya wahn kii si, ");
INSERT INTO eka_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ntahk nyi elkohn anoobo nsol anyehng anyehng li no, nya wahn ki kak, mbing elahb nyi wahn ki rahm, ebgbe bio bi agreb a oliv, nya wahn kii bahm. Ngare nyio nyi ḿ ma li fere wꞌwohngo, ");
INSERT INTO eka_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","jo kunen ekpu, eji ń lꞌkꞌyini Jehova, ye ji yehk-n no lohng go ndi nyi Ijib, go ndi nyi ń woomo eju. ");
INSERT INTO eka_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Jo fahlen Jehova Esowo ebahne, jo loken ye ntahngtahng, wahn jo ko nwongo go egea mbing. ");
INSERT INTO eka_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Kana toono asowo nyako, asowo nya ajahbe nya li senng-n kak, ");
INSERT INTO eka_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","tibre Jehova Esowo ebahne, ye ji li go egahne ellong, a li Esowo bi kpo kpu elkahr, erakatahng eje bahke jo fi-n ana agun, á bahk-n wulu tane. ");
INSERT INTO eka_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Kana wuungu Jehova Esowo ebahne, ana ń limi no go Masa. ");
INSERT INTO eka_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Jo sahb kahnen kahn re ń kpˈbumu nkahn kpee nyi Jehova, a atahm, go nle nyi á ma-n ka. ");
INSERT INTO eka_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Jo limen jio ji li go nseeenge, fere nˈnob go esamahr bi Jehova eji lꞌnob anahne, ń fere song ko nnooba ndi nyi Jehova nyame no, go nwongo tong babnso ewahne, ");
INSERT INTO eka_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","fere kam anebekv ebahne kpee yehke go egahne esamahr ana Jehova bungu no. ");
INSERT INTO eka_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Behnjehle go, mmon ewa lꞌbahb-a re, <<Anv ajahng nyaa, a nle, atahm a ntibi nyia nyi Jehova Esowo ebahre ka elkahn, lohngo renan?>> ");
INSERT INTO eka_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Tong-e re, <<Wahr jolo aju nya Fero go Ijib, wo Jehova ko etahntahn ebo ba yehk-r go Ijib. ");
INSERT INTO eka_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Go egahre esamahr Jehova tumu amennge akpokosi nsol tv anebe Ijib, tv Fero a ane ebe kpee. ");
INSERT INTO eka_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Wo á yehk-r, lohng anahre o, ko-r ba ka ndi nyi á nyame no, ko nwongo a babnsoo ewahre ba nkula nkul. ");
INSERT INTO eka_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Jehova ka-r elkahn re wahr jo kpunu atahm enye kpee, fere jo fahl Jehova Esowo ebahre, eji lˈtiki jo nob anahre, e fere kpin, ana li no lela. ");
INSERT INTO eka_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","E lˈfere bel ekunukpu jo kpunu atahm kpee go esamahr bi Jehova Esowo ebahre, ana á ma-r ka elkahn, jio bahke jolo eno ejahre.>> ");
INSERT INTO eka_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","<<Ngare nyi Jehova Esowo ebahne bahk-n koko ba go ndi nyi ń kpˈyele re wahn song ko, ngare nyi a ma kam ajahbe gbalee yehke go egahne esamahr, ajahbe nya anebe Hiti, anebe Girga, anebe Amor, anebe Kenan, anebe Pereji, a anebe Hiv, go anebe Jebusi, ajahbe na ebsehma bi kpˈkpange fere tahne sehng-n. ");
INSERT INTO eka_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Ngare nyi Jehova Esowo ebahne ma yake bo kak-n go ebo, ń fere ga bo, ḿ bahke rannge bo kpee, kana ko nwongo anyehng anyehng a bo, jol bo ki-n fili ndon anyehng anyehng. ");
INSERT INTO eka_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Kana ko atem atem go mbal. Kana tang abon ebahne ba nkal ka bo, jol kana baange abon ebo ba nkal ka abon ebahne. ");
INSERT INTO eka_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Tibre bo bahke sennge abon ebahne eltim tv go, re bo ki-m kpe toono. Bo bahke fere jo loko asowo nyako. Erakatahng ji Jehova bahk gulu elgboko tub-n, á fere wul-n. ");
INSERT INTO eka_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ji ḿ bahke bo lim ji a, waan agudu njom ebo, wahn fere wa atal eblom ebo, gbakken ago Asera ebo, wahn fere jamme alokelom ebo fi. ");
INSERT INTO eka_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Tibre wahn li ane ba li saang ka Jehova Esowo ebahne. Jehova Esowo ebahne ma-n yehke go ellong anebe ejahbe kpee ba li njini re wahn jol ane ebe, ana etingi ejum ji nne kpi no, ji á kpo yehke ntir enye kunu. ");
INSERT INTO eka_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Jehova yehkem ntir atahng enye kun-n fere yehk-n tibre wahn ba ga rur sehnge ajahbe nyako, tibre wahn ba ga jol mobsak sehnge ajahbe nyako kpee. ");
INSERT INTO eka_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Wo jia jolo ano tibre ń koro Jehova, á fere seb re á bum nwongo nyi á ko tir tong babnsoo ewahne ba nkul. Owo wahnge á yehk-n no a etahntahn ebo, fere fak-n yehke go ndi nyi ń woomo eju, fere tob yehk-n go nsahm nyi Fero ji ntul no Ijib. ");
INSERT INTO eka_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Kahnen fvfo re Jehova Esowo ebahne, Esowo bi. Á li nkakesehk Esowo bi kpo bum egbanngalung ji elkoro tete rehng eying atahltahl nkpel ebal atahl awubu ji ane bao ba ye kpo kor bo, bo fere jo bum nkahn enye. ");
INSERT INTO eka_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Wo ane bao ba á kpo sab bo, á bahke tuuru bo go ebo esamahr eji á bahke rannge bo, jol á nehm laange ebrannge ane bao ba ye kpo sab bo. ");
INSERT INTO eka_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Fvfo kunen ekpu, wahn jo toono nkahn, atahm a ntibi nya n kp-n kake lela. ");
INSERT INTO eka_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Ń lꞌjo kunu ekpu go atahm nyaa, fere jo toono go nseenga nseenge, owo Jehova Esowo ebahne bahke bumu egbanngalung eje ji elkoro a nahne, ana a tiri tong babnso ewahne ba nkul. ");
INSERT INTO eka_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Ḿ bahk-e jo kor, á fere fuul-n, fere lim-n ń jol go nrur. Á bahk-n fuulu ka njel, a mbahmandi, nkohl enyahne, a amahm emahne ma mfemfe, a akehng ma oliv, abon efong ba lohng go ellong efong ebahne, a abon ejoro a ebul baange ba lohng go ellong enyam ebahne, go ndi nyi á nyame tong babnso ewahne re á bahk-n kake. ");
INSERT INTO eka_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Á bahk-n fuulu sehnge ane bako kpee. Aneblum afi anebkal nehm gbo egum, jol etohkondi ejahne ajehng ajehng nehm jol ji lꞌkꞌbel abon. ");
INSERT INTO eka_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Jehova bahk-n yehke go eyam abehng abehng. Á wahn nehm tub amennge ayam nya ń wuku go Ijib, á bahke tuubu ane kpee bao ba wahn kpo sab bo ayam. ");
INSERT INTO eka_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Ḿ bahke tiki wul ane kpee ba ajahbe nyaa Jehova Esowo ebahne yake kak-n ebo. Jol kana be bo ndon, kana loko asowo ebo tibre jia bahke jolo ana ekpoko ka-n. ");
INSERT INTO eka_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Ń bahke ma bung tong elnahne re, <<Ajahbe nyaa kpꞌtahne sehng-r. E bahke limi renan kehm kame bo yehke? ");
INSERT INTO eka_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Wo kana jo fahl bo. Jo buum-n nobnob ji Jehova Esowo ebahne limi Fero a anebe Ijib kpee. ");
INSERT INTO eka_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Ń nyˈnyehn go egahne amahr, agburu arem, a nliingi a akpokosi, go egburu eko a nsahm nyi Jehova Esowo ebahne tanne no, bi á ko no yehk-n. Jehova Esowo ebahne bahke tob lim ano a ajahbe nya ń kpi bo fahl. ");
INSERT INTO eka_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Budu o, Jehova Esowo ebahne bahke tumu egburu ntong sehng go anyam nyame nya bo kpo lung re Hornet tv bo go ellong, tete jol erik ebo ji bahke beke biiri, bahke gohro kpo tan. ");
INSERT INTO eka_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Nong bo ki-n nehke, tibre Jehova Esowo ebahne bi wob-n go ellong, á li egburu emennge Esowo. ");
INSERT INTO eka_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Jehova Esowo ebahne bahk-n gboko mbang jo kam ajahbe nyao ebrik ebrik. Á nehm taame re wahn wul na wul bo nkpel nkpel anyehng tane, lꞌjol ano enyamkulugbe bahke nyabe go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Jehova Esowo ebahne bahke yake bo kak-n go ebo, á bahke kake bo egburu abilamahr go ebo ellong, tete bo rannge mal. ");
INSERT INTO eka_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Á bahke yake atul ebo kak-n go egahne ebo. Ḿ bahk fvvdv abing ebo go njini ana nne fvvdv ejum ji bo nyono no. Nnene nehm ma yiimi abohng anahne. Ḿ bahke bo wul. ");
INSERT INTO eka_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Ḿ bahke jamme alokelom asowo ebo fi. Kana baare amahr go asilva a agul nya bo ko liibi bo, jol kana rod na bum elnahne. Tohko jol ano, bahk-n bobo ana ekpoko, tibre li asabsab nsol ka Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Kana ko ejum ji kpo sab Esowo ba go egahna ntahk. Tohko jol ano, wofono antahng bo bahk-a tob yab tv go ejang elrannge, ana ejum jꞌnehm. Ko ana ejum eltehb, nong sahb sab-a sab, tibre bobyab bum go nkpe re bo rannge. ");
INSERT INTO eka_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","<<Jo kunen ekpu wahn jo toono nkahn kpee nyi ń kp-n kake lela, eji ń lꞌkpin, fere nyꞌnyab, eji ń lꞌyel ko ndi nyi Jehova ko nwongo nyam tong bahbnso ewahne ba nkul. ");
INSERT INTO eka_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Buumen ana Jehova Esowo ebahne gbo-n mbang sehng go ndi erikendi nyi li wum wum. go nnya atahl abal nyia, re á gon-n kak ege elwo, fere wuung-n. Á limi ano eji á lꞌkahn ji wob-n go eltim, joare ḿ bahke bumu nkahn enye afi ń nehm bum. ");
INSERT INTO eka_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Á gon-n, lim-n njal jo yam-n, fere le-n a mmana nyi wahn a babnso ewahne ba nkul kii kahn, eji á lˈtib-n re nsol alehke nyi nyi sang nne kpo kpin, á kpo kpin go ellum anehng anehng ni lohngo go nnyo mi Jehova. ");
INSERT INTO eka_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Abomo enyahne jakem, jol akpade enyahne tungem go nnya atahl abal nyia. ");
INSERT INTO eka_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Kahnen go egahna ntim fvfo re, ana nne kpo kak mmon ewe erem re a soong-e, ano wo Esowo ebahne kpo kak-n erem re a soong-n. ");
INSERT INTO eka_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Jo bumen nkahn nyi Jehova Esowo ebahne, wahn jo jen jo wuk-e, fere jo ka-e egburu kpunu. ");
INSERT INTO eka_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Tibre Jehova Esowo ebahne kp-n koko ba nnooba ndi, ndi nyi kpi ngbalahb, a abing alahb, go ngba nyi mbˈbehl alahb kpꞌlohngo, jo fab asongo go adamme a awong, ");
INSERT INTO eka_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ndi nyi kpi akohl nya bo kpo lung re awid a bali, alehke greb a nrahn efig, pomegreneti tob li o, a akehng oliv, go akehng ekon. ");
INSERT INTO eka_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Ndi nyio nyi nsol alehke lꞌki-n jo rin, jol ejumjum wahn nehm jo lehng. Ndi nyio akpartal enye akuungu nya, ḿ bahke ma jo kpa abilikpi yehke go awong. ");
INSERT INTO eka_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ngare nyi ḿ ma li fere wꞌwohngo, tehken Jehova Esowo ebahne, go nnooba ndi nyi á ma-n ka. ");
INSERT INTO eka_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Jo kunen ekpu wahn kꞌyini Jehova Esowo ebahne, fere kane elbumu nkahn enye, a atahm enye go nle, nya n kp-n kake lela. ");
INSERT INTO eka_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Tohko jol ano, ń lꞌsi li fere wꞌwohngo, ngare nyi ḿ ma si atingi ntahk fere lene o, ");
INSERT INTO eka_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ngare nyi nlong efong ebahne a nlong ejoro a ebul ebahne ma rur, ń fere bel asilva a agul gbalee, nsol kpee nyi ń kpi no, ma kpe gbal budu. ");
INSERT INTO eka_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","Owo ntim enyahne bahke kehme ellimi agabbe, ḿ bahke yini Jehova Esowo ebahne, ye ji yehk-n go Ijib, go ndi nyio nyi ń jolo aju. ");
INSERT INTO eka_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Á gbo-n mbang sehng go nkpaange ndi erikendi nyi li wum wum. ni jolo wum wum, ndi ekor lahb nyi ane lˈkˈma bel alahb, ndi nyi kpi enyo a enang bi kpi afa. Á limi alahb lohng go etahntahn ekpartal ka-n. ");
INSERT INTO eka_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Á ka-n mmana re wahn li go ndi erikendi nyi li wum wum. jolo wumwum, ejum ji babnso ewahne kii kahn bade, eji á lˈgon-n kak ege elwo, fere jo wuung-n, eji go esꞌkohro, lꞌnob na anahne. ");
INSERT INTO eka_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","A li ma bung tong elna re, \"Eko ejame, a atahne nya abo enyame nya ma lim afang nyaa a ka-m.\" ");
INSERT INTO eka_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Wo buumen Jehova Esowo ebahne, tibre ye wo kpo ka-n eko ji emallimi bel afang, eji lꞌtib re egbanngalung eje ji á tiri ka babnso ewahne ebyiimi ana li no lela. ");
INSERT INTO eka_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Ń lꞌfere yini Jehova Esowo ebahne fere jo toono asowo nyako, jo kak bo, jo gong ka bo, ń kpꞌyiimi ntianse ka elnahne lela re, go etingitingi, bo bahk-n rannge. ");
INSERT INTO eka_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Ana Jehova rannge ajahbe nyaa go egahne esamahr, ano wo bo bahke tob ranng-n tib eji ń ki jo wuk Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","<<Wuken wahn anebe Isreel: Anv, ń yahke siiri Jodan song yel ko ndi nyi ajahbe nya gbale sehng-n fere tahne sehng-n, agburu ajahbe nya akahme ebo kpꞌwahre are yahke rehng elbung. ");
INSERT INTO eka_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Ane bao anebe Anak ba. Bo li akolo (alabelabe) ane, fere tꞌtahne. Ń kpꞌkahne bada bo, wahn ebwuk ana ji ane kpo bung re, <<Nne awoo bahke ma yiimi abohng a anebe Anak?>> ");
INSERT INTO eka_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Bumen lela go egahna ntim re Jehova Esowo ebahne, wo kp-n gboko mbang siiri asongo go egbuk jehko ana agun nya kpo fi nsol. Á bahke rannge bo, á bahke koko bo elfono go egahne esamahr. Ḿ bahke kame bo yehke, fere tane mbing ebo elwaare, ana Jehova ma nyam tong-n. ");
INSERT INTO eka_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Ngare nyi Jehova Esowo ebahne ma kam bo egahne esamahr tv go, ka bung go ega eltim re, <<Jehova ma-m ko ba a, re me m ba ko ndi nyia tib go egame etingi eljini. Eꞌee! Tib go ebi eljini ni ajahbe nyaa, jiji wahnge Jehova bahke kame bo yehke egahre esamahr. ");
INSERT INTO eka_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Etingi eljini enahre sang wahnge, afi ana ḿ male bum elnahne a ekpunu sang wahnge, ń kpꞌyele song ko ndia bo, wo tib go esi ebi eljini ni ajahbe nyaa, jiji wahnge Jehova Esowo ebahne bahke bo kam yehke tv go eji á lꞌlim ji á nyame tong babnso ewahne, Ebraham, Aesik, a Jekob. ");
INSERT INTO eka_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Jo gberen fvfo re, tib go egahne etingi eljini sang wahnge Jehova Esowo ebahne kp-n kake nnooba ndi nyia re wahn ko, tibre wahn li atahnsi ane. ");
INSERT INTO eka_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Jo buumen jia, kana tiki yini ana ń limi no, ka Jehova Esowo ebahne erakatahng go ndi erikendi nyi li wum wum. ni jolo wum wum. Bomo go efung bi ń tahme go Ijib abake, tete ḿ ma ba rehng a, ń kpꞌyiimi etahnsi a Jehova. ");
INSERT INTO eka_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Gona Horeb ń limi re erakatahng eje melle, wahng ka á rake eltim tete rehng ji á bahk-n wulu. ");
INSERT INTO eka_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Ngare nyi n wahre go egburu ewong re me n song ko nkpake taale, akpake taale nya nwongo nyi Jehova limi anahne. N sa go egburu ewong atv atahl abal a nfung atahl abal. Nsol alehke n liim, jol alahb n woom. ");
INSERT INTO eka_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Jehova ka-m nkpake taale na ebal nya Esowo ko ebnyohkobo ebe fik. O wo bo nyono atahm kpee nya Jehova jo bung tong-n go ewong, jo lohngo go atahng agun nyao, efung bio bi ḿ ba kono edi ajehng. ");
INSERT INTO eka_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Eji ma biingi afung atahl abal a atv atahl abal, Jehova ka-m ekpake taale na ebal nyao, akpake taale nya egbanngalung. ");
INSERT INTO eka_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Owo Jehova kehm-m tongo re, \"Mehl wo badde song elwaare, ane eba ba á yehke bo go Ijib ebrannge. Bobtahr sꞌsennge njahm, tahm nsol nyi n ka elkahn sa, fere lim elokelom ka elbo.\" ");
INSERT INTO eka_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Jehova kehm kpe bung tong-m re, \"Me n nyehn ane baa, bo lohko li atahnsi ane go etingitingi. ");
INSERT INTO eka_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Yak-m, eji n lˈwul bo, fere fvvdv mbing abo go njini. M bahk-a limi a jol ejahbe ji kpꞌtahne fere rꞌrur sehnge bo. ");
INSERT INTO eka_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Ano wo n sennge no, jo badde ewong ji jo lul agun agun abake, a akpake taale ebal ebal nya egbanngalung go egame abo. ");
INSERT INTO eka_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Ana n tabe amahr seenge, n nyehne re wahn eblim abiafem bada Jehova Esowo ebahne, ń limi elokelom ji ḿ mongo go elfoongo mmona mfong ka elnahne, wahn ebtahr sꞌsennge njahm, tahm mbang nyi Jehova ka-n elkahn sa. ");
INSERT INTO eka_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Ano wo, n rodo akpake taale nyao na abal ro tub go ndi, kehm wake ajang ajang go egahne esamahr. ");
INSERT INTO eka_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Owo n kehm kpe gbo noongo tanne go esamahr bi Jehova nfung atahl abal a atv atahl abal. Ejum alehke n liim, jol alahb n woom, tib go abiafem kpee nya ń limi no, eji ń limi jio ji ki nob go esamahr bi Jehova, ń jo lim-e re eltim rake. ");
INSERT INTO eka_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","N jo fˈfahl esumsum erakatahng a erem bi Jehova tibre eltim rak-e bada nahne sehng re jol á wul-n na. Wo Jehova wuung-m wuungu atung. ");
INSERT INTO eka_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Jehova eltim rak-e bada Eron sehng re á wul-e, wo ngare nyio, n tob kake ero ka Eron. ");
INSERT INTO eka_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","N rodo ejum abiafem ejahne jio, mmona mfong no ń limi no, jahm fi go agun. N wa fere goko rꞌrere fere jol ana atong, sahb rꞌrere ana ebtohko. N kehm yaange ebtohko bio kak go ebgba bi jo fab asongo go edamme ewong. ");
INSERT INTO eka_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Ń tob limi Jehova eltim rak-e go Tabera a Masa, a go Kibroti Hatava. ");
INSERT INTO eka_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Ngare nyi Jehova yehk-n go Kedesi Benia tum, a bungu re, <<Songen, wahn song ko ndi nyio nyi m ma-n kaa, fere jol nyˈnyahne, wo ń yiimi etahnsi ten elkahn ni Jehova Esowo ebahne. Ń yehkem ntir enyahne kunu go ege, jol ń we-e wukem. ");
INSERT INTO eka_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Ń kpo yiimi etahnsi a Jehova bomo go eji me n kahn-n no. ");
INSERT INTO eka_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","N noongo tanne go esamahr bi Jehova nfung atahl abal a atv atahl abal, tibre Jehova bungu re á bahk-n wulu. ");
INSERT INTO eka_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","N jo kake ero ka Jehova , fere jo bung re, <<Jehova ji gbale sehng, ka wul ane eba, bo ji li nsol elehkelkv enya, bo ji á ma ko egburu eko eja tahre bo, fere yehke bo go Ijib a etahntahn ebo. ");
INSERT INTO eka_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Buumu Ebraham, Aesik a Jekob, bo ji jolo alokeltum eba. Lub rod na rod etahnsi ji ane baa, a abꞌbi ebo, go abiafem ebo bum daange daange daange. ");
INSERT INTO eka_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Tohko jol ano, ane bao ba á yehk-r go ebo ejahbe ba, bahke bungu re, <<Tib eji Jehova kii ma ko bo song yel go ndi nyi á nyame tong bo tib goji bo kil jo kor-e, jiji wahnge á yehke bo ba, re á ba wul bo go ndi erikendi nyi li wum wum. ");
INSERT INTO eka_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Wo ga, bo ane eba ba, nsol elehkelkv enya nyi, bo ji á ko egburu nsahm a eko, tanne song yehke bo.>> ");
INSERT INTO eka_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","<<Ngare nyio Jehova bungu tong-m re, <Fik ekpake taale na ebal yehke ana nya ngbokambang, wo ko bo ba ka-m ero ewong. Tob ko ajangenti wo lim mobkohl. ");
INSERT INTO eka_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","M bahke nyono go ekpake taale alum nyanehm nya jolo go agbokambang akpake taale nya a wa no. Owo a bahke rodo akpake taale nyao kak go mobkohl noo. ");
INSERT INTO eka_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Ano wo n ko eti ji bo kpo lung re akasia lim mobkohl fere fik ekpake taale na abal ana nya ngbokambang. N kehm wahre tahm go ewong a akpake taale nyao na abal go egama abo. ");
INSERT INTO eka_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Jehova kehm nyono nkahn na ewubu go akpake taale nyao na abal, ana á tohko nyon, nyao nya á jo rabe tiing-n go ewong, go agun efung nkon bio. Jehova kehm-m kake akpake taale nyao. ");
INSERT INTO eka_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Owo n kehm feere badde ewong ba kak akpake taale nyao go elkohl ni m ma lim ana Jehova ka-m elkahn. Fvfo tiki wob o tete sik anv. ");
INSERT INTO eka_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Anebe Isreel kehm tabe eljen ebo go mbing elahb nyi anebe Jaakan song rehng go Mosera. O wo Eron kpo no, bo kpa-e kak. Eleaja mmon ewe wo fere ba yiimi go ege enyo ana nlimanjom. ");
INSERT INTO eka_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Bo kpe mehl eljen o tete rehng go Gudgoda sehng song rehng go Jotibata, go ndi nyi kpi mbing elahb gbalee. ");
INSERT INTO eka_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Ngare nyio Jehova yabe etˈtohngo ji Levi re bo jo sol elkohl ni egbanngalung ji Jehova, fere jo yiimi go esamahr bi Jehova jo loko eltum, fere jo tob bung elfuulu go egea mbing, ana bo kpˈtiki kpe lim lela. ");
INSERT INTO eka_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Jiji a ji wahnge anebe Levi kii kpi mbaangansol, afi elehkelkv go ellong abonanyehn ebo. Jehova wo li ejum elehkelkv ebo ana Jehova Esowo ebahne tongo bo. ");
INSERT INTO eka_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Ngare nyia fvfo, n kange go ero ewong atv atahl abal a nfung atahl abal ana n kange no ngare egbokombang. Jehova wuung-m atung go ngare nyia fvfo. Ntir atahng enye, we jolem re á wul-n. ");
INSERT INTO eka_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Jehova kehm bungu tong-m re, \"Song wo song tv ane baa go ebo a mbang, eji bo lꞌyel song ko ndi nyio nyi n nyame tong babnde ebo ba nkul re m bahke kake bo.>> ");
INSERT INTO eka_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Wo anv Isreel, ji Jehova Esowo ebahne kpˈsebe li re, wahn jo fahl Jehova Esowo ebahne, jo jen go abang enye kpee, á jo kor-n, wahn jo loko Jehova Esowo ebahne, a ntim a ntim enyahne , a etohko etohko ejahne, ");
INSERT INTO eka_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","fvfo wahn fere jo buumu nkahn a eltibi ni Jehova nya n kp-n kake lela, eji lꞌnob anahne? ");
INSERT INTO eka_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Jehova Esowo ebahne bi kpi elbung a nsol kpee nyi li o, ye wo kpi elbung ni ga wahre a ndi, a nsol nyi li go njini kpee. ");
INSERT INTO eka_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Tvtv o, Jehova yehke elkoro ene kunu babnso ewahne. Bo jo kor-e, á fere yehk-n, wahn abon abon ebo, fere rod-n wahre sehnge ajahbe kpee, ana li no lela. ");
INSERT INTO eka_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Yehken asabsab nsol kpee go egahna ntim nya kpo lim re wahn kˈjo kpunu Jehova. Kana kpe tahne esi. ");
INSERT INTO eka_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Tibre Jehova Esowo ebahne li Esowo bi asowo, fere jol Nde no babnde aju, egburu Esowo bi kpi nsahm, fere mꞌmonngo, ye ji kil jo rang ane, jol ngu á kpehme ko. ");
INSERT INTO eka_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Á kpo yiimi ane ba ki kpi babnde, a akalebun njahm, go ebo atongtong. Ajahmjahm kpo kor-e ba lene go egahne ellong, á fere jo ka bo nsol alehke a nsol ebjing. ");
INSERT INTO eka_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Nong ajahmjahm jo kor-n, tibre wahnfono jolo ajenne go Ijib. ");
INSERT INTO eka_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Jo fahlen Jehova Esowo ebahne, wahn jo lok-e. Gbo-n ye ejahm wahn toon-e, fere jo ko nwongo go egea mbing. ");
INSERT INTO eka_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Ye wo li nne no ḿ bahke tiki jo tehk-e, ye wo li Esowo ebahne, ye ji limi agburu amenngo akpokosi nsol ka-n, nya ń ko amahr enyahne nyehn. ");
INSERT INTO eka_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Babnso ewahne ba nkul ba tahme song yel go Ijib jolo ane atahl ara ane awubu ba ba. Wo anv, Jehova Esowo ebahne ma-n lim wahn ebrur ana alonlo nya li go elbung. ");
INSERT INTO eka_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","<<Nong Jehova Esowo ebahne jo koren, wahn fere jo lim nsol nyi li re wahn lim, a eltibi ene, a atahm enye, a nkahn enye, ngare anyehng anyehng. ");
INSERT INTO eka_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Buumen lela, re abon ebahne baa sang nyehne erem bi Jehova Esowo ebahne kan-n no, ano nya etul ebe, egburu eko eje a atahne enye. ");
INSERT INTO eka_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","Nliingi nyi á tibi no, a nsol nyi á limi no go atahng Ijib, nya á limi Fero ntula Ijib, a ejahbe Ijib kpee; ");
INSERT INTO eka_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","nsol nyi á limi nsoja nyi Ijib, ebvankang ebo, a amvtv nta ebo, fvfo ana Jehova ko nnyel alahb go aya nkpafa tane bo eko eji bo jo kam-n, fere mal bo tete lela. ");
INSERT INTO eka_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Abon ebahne sang nyehne ji á limi ka-n go elka emahng tete ń rehng a edi jia, ");
INSERT INTO eka_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","a ji á limi Datan abola Abiram, abon ba nlum ba Eliyab ji lohng go etꞌtohngo ji Ruben, eji ndi lennge nnyo eme go ellong anebe Isreel, mele bo, a anebe etahk ebo, a ejum ajehng ajehng ji li elkpin ji bo bele no. ");
INSERT INTO eka_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Wo amahr nya nyahne nya nyehne agburu nsol nyaa kpee, nya Jehova ma lim. ");
INSERT INTO eka_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Fvfo jo bumen nkahn kpee, nya n kp-n kake lela, eji ń lˈbel atahne song yel ko ndi nyi ń kpꞌsiiri Jodan re wahn song ko fere bel. ");
INSERT INTO eka_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","Eji ń lˈbel nlabe elkpin go ndi nyi Jehova tiri tong babnso ewahne ba nkul a nkul, re á bahke kake bo a abon abon ebo. Ndi nyꞌnehm o alahb bel a akehng ekon kpˈfabe ana alahb. ");
INSERT INTO eka_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Ndi nyi ń kpˈyele re wahn song ko, limm ana ndi nyi Ijib, nyi ń lohngo no ba, nyi ń jo bahm amohk nti fere jo ko akpade enyahne jo rahm adi nya alahb bahke jo fab sehng, ana etahngga anyane. ");
INSERT INTO eka_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Wo ndi nyi ń kpˈsiiri Jodan re wahn song ko jol enyahne, li ndi nyi agburu awong a adamme nya kpo wo elahb ji kpˈnake go elbung abake. ");
INSERT INTO eka_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Ndi nyi Jehova Esowo ebahne kpo kpur nyi, amahr nya Jehova Esowo ebahne tiki kun o, bomo ana elya kpꞌbomo tete rehng esꞌkohro. ");
INSERT INTO eka_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Ń lˈfere soro asi jo bum nkahn nyi n kp-n kake a lela, re Jehova Esowo ebahne jo kor-n wahn fere jo lok-e a eltim eltim enahne, a etohko etohko ejahne, ");
INSERT INTO eka_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","owo m bahke nake elahb wohngo go egahna ndi, go ngare enye, ngare nyi elum yahke mal, a ngare nyi elum yahke se, eji n lˈbanne nkohl, a amahm mfemfe a akehng oliv bum elnahne. ");
INSERT INTO eka_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","M bahke limi re ajele jo gbal go egahne ebgbe ka efong ebahne, ḿ bahke jo li, fere wˈwohngo. ");
INSERT INTO eka_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Jo kunen ekpu, no bo bahk-n were re wahn sennge go nkpe, fere jo kak asowo nyako, fere jo gong ka bo. ");
INSERT INTO eka_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Owo erakatahng ji Jehova bahke nyaale tob-n ana agun. Á bahke bulu elbung eji elahb lˈkˈkpe na, ndi nehm kpe kab nsol ndi. Jol ḿ bahke gulu kpoko go nnooba ndi nyi Jehova kp-n kake. ");
INSERT INTO eka_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Rod alum nyaa kak go egahne eltim a ntir atahng enyahne. Gba go ega abo ana ejum elliingi, wahn fere jo gba go egahna mbuk. ");
INSERT INTO eka_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Tiben abon ebahne nsol nyia, jo bungen bade eji ń jehk etahk, a eji ń kpˈjene go mbang, a eji ń nong no, a ngare nyi ḿ ma mehl. ");
INSERT INTO eka_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Nyonen go egahne ati mbu etahk a ati mbuga, ");
INSERT INTO eka_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","owo wahn a abon ebahne, m bahke bele nlabe elkpin go ndi nyi Jehova Esowo ebahne nyame no re á bahke kake babnso ewahne ba nkul. Ḿ bahke lene o eji elbung kpeka li go ero ndi kpeka li ga. ");
INSERT INTO eka_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","N lˈfere kunu ekpu bum nkahn nyia nyi n kp-n kake re wahn toono, re Jehova Esowo ebahne jo kor-n, wahn jo jen go ege abang kpee, fere jo tahm tonng-e, ");
INSERT INTO eka_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","Owo Jehova bahke kame ajahbe nyaa kpee yehke, ḿ bahke taare ajahbe nya kpꞌgbale, fere tahne sehng-n ndi abo. ");
INSERT INTO eka_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Edi ajehng ajehng ji ń lꞌjade akpade bahke jolo ejahne. Ndi enyahne bahke bomo go elka emahng rehng go Lebanon. Fere bom go aya ma Yufritis rehng agburu aya ma erede mfam, ma bo kpo lung re Mediterania. ");
INSERT INTO eka_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Nnene limm no bahke ma yiimi abohng anahne. Jehova Esowo ebahne bahke limi re elmenngo a elfahle enahne jol go ndi nyio kpee, a edi ajehng ajehng ji ń je no ana á nyame no. ");
INSERT INTO eka_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Nyehneno, n kp-n bumu elfuulu a nkuk go egahne esamahr lela re wahn yehke, ");
INSERT INTO eka_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","ḿ bahke bele elfuulu, ń lꞌfere kpunu nkahn nyi Jehova Esowo ebahne nyi n kp-n kake lela; ");
INSERT INTO eka_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Nkuk, ń lꞌfere ten elkpunu nkahn nyi Jehova Esowo ebahne fere sennge njahm go mbang nyi n kp-n kake elkahn lela, fere jo toono asowo nyako nya ń ki nyi. ");
INSERT INTO eka_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Ngare nyi Jehova Esowo ebahne ma-n ko ba go ndi nyi ń kpꞌyele re wahn ko, ḿ bahke yiimi go egburu ewong ji Gerijim jo tiingi bada nfuulu, a go egburu ewong ji Ebal jo tiingi bade akuk. ");
INSERT INTO eka_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Ń kpꞌkahne re awong nyaa li go egbuk Jodan jehko, go ejang erede mfam bi mbang nyi li asongo goji njul kpo lahm. Tob li kohlo agburu nti nya More, go ejang ndi nyi anebe Kenan ba lene go edamme ji Araba, go ejang bi Gilgal. ");
INSERT INTO eka_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Anv, ń yahke ba elsiiri Jodan song yel ko ndi nyi Jehova Esowo ebahne kp-n kake. Ngare nyi ḿ ma song ko ndi nyio fere lene o, ");
INSERT INTO eka_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","jo bumen re, ḿ bahke jo bum atahm a ntibi kpee nyi n kp-n kake lela. ");
INSERT INTO eka_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","<<Atahm a eltibi nya a, nya ḿ bahke jo kunu ekpu jo toono go ndi nyi Jehova, ye ji li Esowo babnso ewahne ma-n ka, re wahn ko fere jol nya nyahne, go ngare kpee nyi ḿ bahke lene go ndi nyio. ");
INSERT INTO eka_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Ranngen kohrem kohrem kohrem, adi kpee nya li go ero awahre wahre awong, a nya li go ero awong, a nya li go nla eti ajehng ajehng ji ma nyange abˈbo, nya ajahbe nya ń kpꞌkoko kpo kak asowo bo. ");
INSERT INTO eka_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Waan agudu njom ebo, wahn tob far akahme kahme atal ebo, fere jahmen ago asera go agun; kiimi alokelom asowo ebo tuubu go, wahn fere fvvdv yehke abing ebo go adi nyao. ");
INSERT INTO eka_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Wahn, kana jo kak Jehova Esowo ebahne go mbang ana nyi bo kpo kak. ");
INSERT INTO eka_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Wo, ḿ bahke sebe edi ji Jehova Esowo ebahne bahke yehke go egahne atꞌtohngo kpee re á kak mbing enye o, ana edi ellene eje. Edi jio ji ḿ bahke jo je. ");
INSERT INTO eka_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Jo koon ayare enyahne nya bo kpo jahm fi je o, a ajom enyahne, a ejum ajehng go nsol ewubu, a akahmekahme nsol nya elkake Esowo, nsol nyi ń ko nwongo re ḿ bahk-e kake, a ayare nya nne toobo eltim ene, go agbokombang abon ba ellong efong ebahne, a ellong ejoro ebahne. ");
INSERT INTO eka_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Ona wo, go elwo ni Jehova Esowo ebahne, wahn a ebangenahb ejahne bahke jo li, fere jo geere kak ejum ajehng ajehng ji ń kunu ebo ebahne re wahn lim. Tibre Jehova Esowo ebahne ma-n fuulu. ");
INSERT INTO eka_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Ń nehm jo lim ana e kpꞌlimi a lela, re no nne jo lim ana kp-e koro. ");
INSERT INTO eka_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","eji ń kala si rꞌrehng go edi erekekv a ejum elehkelkv ji Jehova Esowo ebahne kp-n kake. ");
INSERT INTO eka_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Wo ḿ bahke siiri Jodan song lene go ndi nyi Jehova Esowo ebahne kp-n kake ana ejum elehkelkv. Fvfo á bahk-n kake erekekv go abo nya anebekv ebahne kpee ba lene senng-n kak, eji abi nsol lˈki-n toono. ");
INSERT INTO eka_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Go edi jio ji Jehova Esowo ebahne bahke yehke ana edi ji ḿ bahke jo kak mbing enye fere kpun-e, owo ḿ bahke koko ejum ajehng ajehng ba, ana n ka-n elkahn. Nsol ana ayare nya bo kpo jahm fi, a ajomjom, ejum ajehng go nsol ewubu enyahne, a ekahmekahme nsol nya ń ko ba yare Esowo, a atingi nsol enyahne kpee nya ḿ ma ko nwongo re ḿ bahk kake Jehova, ");
INSERT INTO eka_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Jo geeren o, go esamahr bi Jehova Esowo ebahne, wo a abon eba ba nlum, a ba nkal, alokeltum eba ba nlum a ba nkal, a ane ba lohng go etˈtohngo Levi ba li egahna mfam ba bo ki ka bo edi ndi, afi ejum elehkelkv ji bo. ");
INSERT INTO eka_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Jo kunen ekpu, wahn kˈlim njom nyio nyi ayare nya bo kpo jahm fi go edi ajehng ajehng ji kor-n no. ");
INSERT INTO eka_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Jo Limen go edi jio ji Jehova bahke yehke ji ji, go etꞌtohngo ajehng, go egahna atˈtohngo, owo ḿ bahke limi ejum ajehng ajehng ji n ka-n elkahn. ");
INSERT INTO eka_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Limi limi kan, ń li ma wul nnyam enyahne go mfam ejahbe anyehng anyehng fere li nnyam ana kor-n no, jolafi jolo mbilikpa afi ebrahng, ana Jehova Esowo ebahne fuul-n no. Ane bao ba li saang, a ba ki li saang bahke ma li. ");
INSERT INTO eka_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Wo ka tiki li alung ma nnyam anyehng anyehng, yaange wohng go ndi ana alahb. ");
INSERT INTO eka_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Kana li go egahna ajahbe, ejum ajehng jio ji nsol ewubu, nyio nyi nkohl enyahne go mfam ejahbe, a nyi amahm mfemfe, afi akehng oliv, afi nyi ngbokambang a mmon no ellong efong a ejoro a ebul ebahne, afi ejum ajehng ajehng ji á ma lim nwongo re a bahke kake, afi ayare nya ń toobo egahna ntim, afi akahme kahme nsol elkake Esowo nyehko. ");
INSERT INTO eka_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Sehngem re ḿ bahke jo li go elwo ni Jehova Esowo ebahne go edi ji Jehova bahke yehke. A bahke jo li a abon eba ba nlum a ba nkal, alokeltum ebahne ba nkal a ba nlum, a abalimajom ba li go egahne ejahbe. Ḿ bahke jo geere go esamahr bi Jehova Esowo ebahne, go ejum ajehng ajehng ji ń kunu ebo ebahne re wahn lim. ");
INSERT INTO eka_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Jo kunen ekpu, wahn kꞌyini etˈtohngo ji Levayi, ngare kpee nyi ń li go ndi nyio. ");
INSERT INTO eka_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Ngare nyi Jehova Esowo ebahne ma lim re edi ndi ejahne kpe kpange budu ana á nyame no, nnyam lꞌkor-n, á fere bung re, \"Nnyam ma-m kor, ń li ma li ana kor-n no. ");
INSERT INTO eka_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Lꞌjol re edi ji Jehova Esowo ewahne yehke re á kak mbing enye kpꞌlabe mbang sehng bomo go edi ji a li no, á bahke ma wul enyam go ellong efong a ejoro, a ebul bi Jehova ma-a ka ana n ka-n elkahn. Fvfo go egahna mfam ejahbe, ḿ bahke ma li ana kor-n no. ");
INSERT INTO eka_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Liin ana á kpo li mbilikpa afi ebrahng. Ane bao ba li saang, a ba ki li saang, bahke ma li. ");
INSERT INTO eka_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Wo jo kunen ekpu, wahn kꞌli alung, tibre alung ma li elkpin, fvfo ń nehm tiki li nnyam a elkpin. ");
INSERT INTO eka_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Kana tiki li alung ma nnyam anyehng anyehng, yaangen wohngo go ndi ana alahb. ");
INSERT INTO eka_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Ka li alung eji lꞌnob anahne, a abon ebahne ba bahk-n toono, ano wo ḿ bahke jo lim ji kpꞌnobo go esamahr bi Jehova. ");
INSERT INTO eka_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Roden nsol nyi á ma yab bum ejeje ka Esowo, a ejum ajehng ajehng ji ḿ ma ko nwongo re ḿ bahke kake, wahn song edi ji Jehova bahke yehke. ");
INSERT INTO eka_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Limen njom ayare enyahne nyi eljahme fi go egudu njom ji Jehova Esowo ebahne, jolo ayare nya nsol alehke, afi nya alung. Alung ma nnyam njom ebahne, ḿ bahke jo yaange wohngo go nkpe egudu njom nyi Jehova Esowo ebahne, wo ḿ bahke ma li nnyam nyio. ");
INSERT INTO eka_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Kunen ekpu wahn jo kpunu ajehke kpee nya n kp-n kake, eji lꞌjo nob anahne ngare kpe kpe, a abon ebahne ba bahk-n toono. Tibre lꞌjol ano, ḿ bahke jo lim ji kpꞌnobo go esamahr bi Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Jehova Esowo ebahne bahke tane ajahbe kpee nya ń yahke yel re wahn song ko. Wo ngare nyi ḿ ma kam bo yehke, fere lene go eboa ndi, ");
INSERT INTO eka_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","fvfo ngare nyi Esowo ma rannge bo go egahne esamahr, jo kunen ekpu eji ń lꞌkꞌgbo yel ekpoko, jo song bahb bade asowo ebo re, <<Anv, ajahbe nyaa kpo loko asowo ebo renanee? E bahke tob jo loko bo. ");
INSERT INTO eka_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Kana tiki jo kak Jehova Esowo ebahne go mbang ana nyi bo kpo lim, tibre bo kpo lim elkohn asabsab nsol kpee nyi kil jo kor Jehova, bo lꞌkehme asowo ebo loko. Bo kpo jahm abon ebo ba nlum a ba nkal fi go agun ana ajom nya bo kpꞌlimi ka asowo ebo. ");
INSERT INTO eka_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Kunen ekpu wahn lim nsol kpee nyi n ka-n elkahn, kana budu ejumjum, jol kana yehke. ");
INSERT INTO eka_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","<<Nnyehnamahr lˈfere lohng go egahne ellong, afi nne no kpo leeme alem, ba tong-n bade elliingi, afi nkpokosi anyehng anyehng, ");
INSERT INTO eka_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","lˈjol re elliingi, nio, afi nkpokosi nyio, nyi á bungu no, eblohko lim, á soro bung re, <<Wahr tahmen song toono asowo nyako, fere jo kak bo.>> (asowo nya ń kil kahne) ");
INSERT INTO eka_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","Kana wuungu atung, go alum nya nnyehnamahr noo, afi nleemalem noo. Jehova Esowo ebahne kp-n wuungu, re á kahn joare re á kp-n koro a ntim a ntim enyahne kpee, a atohko atohko enyahne kpee. ");
INSERT INTO eka_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Jehova Esowo ebahne ye wo ḿ bahke jo toon-e, fere jo kpun-e. Jo bumen nkahn enye wahn jo kpun-e, jo loken ye, wahn fere gbo-e ejahm tꞌtahne. ");
INSERT INTO eka_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Nnyehnamahr noo, afi nleemalem noo, ḿ bahk-e tiki wul na, tibre yebtib ana ane bahke jo yiimi etahnsi a Jehova Esowo ebahne, ye ji yehk-n lohng anahne go Ijib fere faken yehke go edi ji ń jolo aju. Nnyehnamahr noo, afi nleemalem noo ebgare re á senng-n, wahn kꞌkpe toono mbang nyi Jehova Esowo ebahne ka-n elkahn re wahn jo toono. Ḿ bahke tiki yehke abꞌbi nyao go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Mmonanne antahng antahng, afi mmon ewa no nlum, afi mmon ewa no nkal, afi nkal ewa no kpo kor-a, afi ekpondahme eja, lꞌfere weele jo wer-a re, <<Wahr tahm song kak asowo nyako, asowo nyao nya wahnfono, afi babnso ewahne ki nyi, ");
INSERT INTO eka_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","asowo nya ane ba lene senng-n kak, fere jolo nya li a edahl dahle, afi nya li fee go ejang njini behko, ");
INSERT INTO eka_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","ka taame tv bo, jol kana bo atung wuungu. Nong bo ki-n fili ndon. Kana bo yake, jol kana bo behr. ");
INSERT INTO eka_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Ḿ bahke tiki wul na bo. Wo wo bahke gboko mbang ko ebo eba bom bo elwulu, ane bako kehm tob kak abo ebo. ");
INSERT INTO eka_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Tuuben bo atal wul, tibre bo kpˈgare re bo senng-n yehke ntim enyahne goji Jehova Esowo ebahne, ye ji yehk-n go Ijib, go edi ji ń jolo aju. ");
INSERT INTO eka_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Owo anebe Isreel kpee bahke wuku, fere jo fahl. Fvfo nnene go egahne ellong nehm kpe lim ebꞌbi ejum ana jio. ");
INSERT INTO eka_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Ń lꞌwuk bade mfam ejahbe anyehng anyehng nyi Jehova Esowo ebahne kp-n kake re wahn lene, ");
INSERT INTO eka_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","re abi ane eblohng go egahne ellong, kpꞌtohko anebe mfam ejahbe nyio go mbang nyi ki li nyi nno, fere jo tong bo re, \"Nong wahr tahmen song kak asowo nyako>> (asowo nyako nya ń ki nyi), ");
INSERT INTO eka_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","owo ḿ bahke bahbe, feede, fere seb kahn nob nob. Lꞌfere jol etingitingi, eji ḿ ma seb kahn re boblim ebꞌbi jia ji kpo sab Esowo go egahne ellong, ");
INSERT INTO eka_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","Ḿ bahke wulu ane kpee ba lene go mfam ejahbe nyio. Ranngen ejahbe jio kpee, ane a atohko ndi atohko ndi. ");
INSERT INTO eka_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Kpu-n nsol kpee nyi ḿ bahke dake, wahn ba luk go elatahkgur ji ejahbe jio, fere jahm mfam nyio kpee fi go agun a nsol nyi ń da no, ana ayare eljahme fi ka Jehova Esowo ebahne. Mfam nyio bahke jolo ana ebimbim go njinanjini, jol nnene kꞌkpe tiki si. ");
INSERT INTO eka_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Kana bum ejum ajehng ajehng ji li ka Jehova, ranngen kpee. Eji Jehova bahke sennge njahm go ege erakatahng, ń fere jo fil-e ndon. Fvfo á fere be-n ndon, lim-n, ń jol go nrur, ana á nyame no ko nwongo tong babnso ewahne ba nkul. ");
INSERT INTO eka_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","Jia bahke jolo ano tib eji ń kpunu Jehova Esowo ebahne, fere jo bum nkahn enye kpee nyi n kp-n kake lela, fere jo lim jio ji li nob nob go ege esamahr. ");
INSERT INTO eka_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","<<Wahn abon ba Jehova Esowo ebahne ba. Kana jo gbannge elnahne alok, jol kana jo kpoongo mbuk emahne tib eji ń nong elkv, ");
INSERT INTO eka_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","tibre ń li saang ka Jehova Esowo ebahne. Jehova ma-n yehke go ellong ane kpee ba li go njini re wahn jol akahmekahme ane ba li ka ye. ");
INSERT INTO eka_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Kana li ejum ajehng ajehng ji ki li saang go esamahr bi Esowo. ");
INSERT INTO eka_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Enyam bi a na, bi ḿ bahke ma jo li: edamagudu, njoro, mbul, ");
INSERT INTO eka_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","ebrahng, mbilikpa, nrun, mbulemahng, etohk, ngu, a njoro nyi kpo jol go ewong. ");
INSERT INTO eka_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Ń li ma li nnyam anyehng anyehng nyi kpi ajiki nya yange ejang ebbal, nyi kpo li nsol kuuru go elbehr fere jo yehke li. ");
INSERT INTO eka_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Limilimi kan, kana li enyam bia a, bi kpo jab nnyo afi bi kpi ajiki, nnyam ana ekamel, ebeso afi ebeso afukatal. Jol eji bo kpo jˈjab nnyo, bo kpimm ajiki, bo limm saang ka-n. ");
INSERT INTO eka_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Ekuk tobem li saang, Jol eji ekuk kpi ajiki, á kpehme jab nnyo. Ń nehm jo li nnyam ekuk, jol kana lak ekuk ji ma kpo ebo. ");
INSERT INTO eka_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","Go enyam kpee bi li go alahb, ḿ bahke ma li bo ji kpi ekong a akpake. ");
INSERT INTO eka_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Wo ejum ajehng ajehng ji tohko bel ekong a akpake, ń nehm li. Li ejum ji ki li saang ka-n. ");
INSERT INTO eka_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Ḿ bahke ma li ebruk abehng abehng bi li saang. ");
INSERT INTO eka_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Wo nruk nyi a, nyi ń lꞌkꞌli: Ekpi, ebtere, nnyake ebtere, ");
INSERT INTO eka_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","mbilibili ekumgbakela, nnyake nyake ekumgbakela, elkohn egor ajehng ajehng, ");
INSERT INTO eka_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","elkohn ebruk abehng abehng bi bo kpo lung re raven ");
INSERT INTO eka_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","Erꞌkohng akpatange, erꞌkohng ji kpo ran na, ebruk bi bo kpo lung re gol, ye ji kpo jol go egburu aya, elkohn ekumgbakela ajehng ajehng, ");
INSERT INTO eka_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","Mmorꞌkohng a egburu erꞌkohng, mbarebare erꞌkohng, ");
INSERT INTO eka_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","erꞌkohng emahng, ji kpo bim nsahre, ji bo kpo lung-e re ospehre, egburu erˈkohng aya ji bo kpo lung re komoranti, ");
INSERT INTO eka_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","Nlabannyo ebruk bi bo kpo lung re Stok, ajoobo abarebare nruk nyi kpo v elv alahb, ngon a esahnge. ");
INSERT INTO eka_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Anyamnyame kpee nya kpo fonngo, bo limm saang ka-n, kana jo li bo. ");
INSERT INTO eka_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Wo nnyam anyehng anyehng nyi kpi akpungkpung fere jol saang, ḿ bahke ma jo li. ");
INSERT INTO eka_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Kana jo li ekpakv nnyam anyehng anyehng nyi ń tingi no. Ḿ bahke ma rod ka nne ajahmjahm no lene mfam ejahbe anyehng anyehng enyahne. Ye bahke ma li, afi ń li ma gungu nne ajahmjahm. Wahn li ane ba li saang ka Jehova Esowo ebahne. Kana ko alahb bel nnyehn mbul lam mmona mbul. ");
INSERT INTO eka_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Jo kunen ekpu, wahn jo baange nsol nkpakandi enyahne go edi ebwubu, yehke ngꞌgabe anyehng, bum eje eje go elya elya. ");
INSERT INTO eka_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","Jo liin nsol enyahne, ejum ajehng go nsol ewubu, ana nkohl enyahne, amahm mfemfe, akehng oliv, fvfo a agbokombang abon ba ellong efong ebahne, a ba ellong ebul ebahne, go esamahr bi Jehova Esowo ebahne, go edi ji á bahke yehke re ane jo kak Mbing enye. Ano wo ḿ bahke kpili ana ḿ bahke jo kak mbing enye fere jo kpunu Jehova Esowo ebahne ngare kpe kpe. ");
INSERT INTO eka_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Lꞌfere jol re edi jio kpꞌlabe sehng, wo ga Jehova ma-a fuulu ana a lꞌkꞌma sol nsol nyio je a nyi o, (tibre edi ji Jehova ma yehke fere kak Mbing enye kpꞌlabe mbang sehng), ");
INSERT INTO eka_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","Yaange agꞌgabe nsol enya nyao tv go akpohko, wo kuuru akpohko nob nob go ega ebo wo song go edi ji Jehova Esowo bahke yehke. ");
INSERT INTO eka_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Ń lˈrehng go, ko akpohko nyao wo gunu ejum ajehng ajehng ji kor-a no, lꞌkor-a mfong, njoro, amahm, afi ekang amahm, afi ejum ajehng ajehng ji kor-a no. Owo, wo a ebangenahb eja bahke lehke fere jo geere go elwo ni Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Kana yini ane ba lohng go etˈtohngo ji Levi ba lene go egahna mfam, tibre bo kpimm edi ndi ji bo bake bo, afi ejum elehkelkv ebo. ");
INSERT INTO eka_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Eji nnya era anyehng anyehng ma biingi, koon ejum ajehng go nsol ewubu enyahne, nyi nkpakandi nyi elya nio, song kak ekpꞌkpa ekuuru nsol go egahna mfam, ");
INSERT INTO eka_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","eji ane ba lohng go etˈtohngo ji Levi ba ki kpi edi ndi ji bo bake bo, afi ejum elehkelkv ji bo, a ajenne, a abon ba babnde ma kpo bo sa, a akalebun ba lene go egahna mfam bahke ma ba, ba li, fere wohngo eji Jehova Esowo ebahne bahk-n fuulu, go abo ntum enyahne kpee. ");
INSERT INTO eka_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","<<Eji ma biingi nnya esehma anyehng anyehng, ḿ bahke yake abong nya ane kpi-n no ka bo. ");
INSERT INTO eka_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Ana wo ḿ bahke jo lim. Nne awohng awohng no bongo nnea Isreel akpohko bahke yake mbong nyio ka-e. Á nehm kpe fung nnea Isreel afi mmonannyehn re á kpi-e, tibre a wo li elya ni Jehova ma fa ane nnyo re bo yake abong ka go. ");
INSERT INTO eka_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","A li ma fung nne ajahmjahm mbong. Wo a bahke yake mbong anyehng anyehng nyi mmonanne nnea Isreel kpi-a no. ");
INSERT INTO eka_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","Wo nkpak nehm tiki jol go egahne ellong. Tibre go ndi nyio nyi Jehova kp-n kake re wahn ko ana ejum elehkelkv, á bahk-n fuulu gbˈgbal, ");
INSERT INTO eka_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","ń lꞌfere jo kpunu Jehova Esowo ebahne, fere jo kunu ekpu jo toono nkahn nyia nyi n kp-n kake lela. ");
INSERT INTO eka_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Tibre Jehova Esowo ebahne bahk-n fuulu ana á ma nyam, ḿ bahke jo bong ajahbe gbalee nsol, jol bo wahn nehm jo bong. Ḿ bahke jo fili ajahbe gbalee, jol ejahbe ajehng ajehng wahn nehm fili. ");
INSERT INTO eka_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Nne awohng awohng lˈfere gbo ekpak go ellong ni Isreel abonane ebahne, go mfam ejahbe anyehng anyehng nyi ndi nyi Jehova Esowo ebahne kp-n kake, kana jo tahne ntim, afi jo laake abo a mmonanne ewahne noo. ");
INSERT INTO eka_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Ji li no li re, ḿ bahke jo lennge na abo enyahne, fere bong bo ejum ajehng ajehng ji bo sebe no. ");
INSERT INTO eka_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Jo kunen ekpu, wahn kꞌbel ebi ntir nyia go egahne atahng re, <<Elya ni kpꞌbiingi nnya esehma ebrehng mal, ni bo kpo yake abong ka goˈ eji ń lꞌkꞌ bel ebi ntir bada abonane ebahne anebe Isreel ba li elehng nsol kˈka bo ejumjum. Lꞌjol ano, bo li ma ling tong Jehova bada anahne, ń fere li ebi go esamahr Esowo. ");
INSERT INTO eka_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Jo ka-n wehr abo enyahne ka bo, jol ka ka bo a elmoongo go eltim. Tib esi jia ji Jehova Esowo ebahne bahk-n fuulu go abo ntum enyahne kpee, a ejum ajehng ajehng ji a lake abo re wahn lim. ");
INSERT INTO eka_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Akpak bahke tiki jo jol go egahna ndi. Jiji wahnge n kp-n kake elkahn re wahn jo lennge abo ka abonnnane ebahne anebe Israel, a akpak go ane ba nsol ma lehng bo go egahne ejahbe. ");
INSERT INTO eka_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Lꞌjol re nne ewahne awohng awhng no li nnea Hibru, jolo nnenlum afi jolo nnenkal, ebgungu elbo ka-n, fere lok-n go nnya na erakera, eji ma biingi nnya esehma, ḿ bahke tiki yake bo, bo for. ");
INSERT INTO eka_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Wo ń lꞌyake bo re bo song, kana yake bo abo abo. ");
INSERT INTO eka_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Wehr abo enyahne wahn yehke go ellong atohkondi enyahne, ka-n bo nkohl a amahm gbˈgbal. . Ka-n bo ana Jehova Esowo ebahne ma-n fuulu. ");
INSERT INTO eka_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Buumen re, ń jolo aju go Ijib. Jehova Esowo ebahne bi tahr-n yehke. Owo wahnge, n kp-n kake elkahn nia lela. ");
INSERT INTO eka_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Wo nlokeltum ewa lꞌfere tong-a re, <<N nehme seb re me ń tahm-a sa,>> tibre wo a ebangenahb eja kp-e koro, budu o, tibre a kp-e fili nob nob. ");
INSERT INTO eka_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","Rod ebkehb wo lahm-e etung bade go mbutahk, á bahke fere jol nlokeltum ewa afung elkpin enye kpee. Ano wo a bahke tob lim nlokeltum ewa no nkal. ");
INSERT INTO eka_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Nong ki-a jol ejahk jahk ejum re wo yake nlokeltum ewa re á song eje. Tibre elloko ni á ma-a loko nnya erakera nyia, ebbiingi ntum nyi a lake ane go nkpel ebal. Jehova Esowo eba bahk-a fuulu go ejum ajehng ajehng ji a limi no ");
INSERT INTO eka_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Jo bumen ngbokambang abon efong ba nlum, a ba ebul go ejoro, bo jol ka Jehova Esowo ebahne. Kana rod ngbokambang a mmon a mfong ewahne kak go eltum egbe, jol ka kpud ngbokambanga mmon a njoro ewa anyar. ");
INSERT INTO eka_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Elya elya, wo, a ebangenahb eja, ḿ bahke lehke bo go esamahr bi Jehova Esowo ebahne, go edi ji Jehova bahke yehke. ");
INSERT INTO eka_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Nnyam lꞌfere bel elem, afi á wa amahr, afi yebbanne, afi á kpi ejum ji m-e ka ebi egahme, ń nehm ko-e lim njom ka Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Ḿ bahke lehke nyio go egahna mfam. Ane bao ba li saang a ba ki li saang, bahke ma li, jang jang ana nne bahke ma li ebrahng afi mbilikpa . ");
INSERT INTO eka_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Wo kana tiki li alung nyam, yaangen wohng go ndi ana alahb. ");
INSERT INTO eka_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","<<Jo buumen, wahn bum nnyahng mi Abib, wahn jo lim elkak ni Elsiiri Sehng Sa, ni Jehova Esowo ebahne, tibre go nnyahng mio wo á yehk-n no go ndi nyi Ijib ngare atv. ");
INSERT INTO eka_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Yehk-n nnyam go ellong ebul afi efong ebahne wahn lim njom nyi Elsiiri Sehng Sa ka Jehova Esowo ebahne, go edi ji Jehova bahke yehke ana edi ji bo bahke jo kak Mbing enye fere jo kpun-e. ");
INSERT INTO eka_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Kana li semme a ebred ji bo ko ayisi lim, wo nfung na esehma, jo liin a ebred ji bo ki kak ayis, ebred ji elnohko, tibre ń mehle lohng go Ijib, go elfoomo. Jia li ano eji ń lꞌjo buumu go afung elkpin enahne kpee, bade ellohngo ni ń lohngo no go Ijib. ");
INSERT INTO eka_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Nong eyisi kˈtiki jol anahne go ndi enyahne kpee go nfung na esehma. Kana yake re nnyam anyehng anyehng nyi ń ko lim njom go elgung ni ngbokambang efung, sa erik tete rehng efungfu. ");
INSERT INTO eka_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Kana lim njom nyi Elsiiri sehng Sa go mfam ejahbe ajehng ajehng ji Jehova Esowo ebahne kp-n kake, ");
INSERT INTO eka_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","sehngem edi jio ji ye bahke yehke ana edi ji bo bahke jo kak Mbing enye fere jo kpun-e. O wo ḿ bahke tiki lim njom nyi Elsiiri sehng Sa, ngare elgung eji nnv ma ji egbiri. Efung bio bi kpo se efung bi ń lohngo go Ijib. ");
INSERT INTO eka_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Woon na nnyam nyio, wahn fere li nsol edi jio ji Jehova Esowo ebahne bahke yehke. Efungfu wahn kehm feere go abon nkpatahk ebahne. ");
INSERT INTO eka_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Go nfung na erakera, jo liin ebred ji ki kpi ayisi, go efung bi biingi nfung na esehma, belen nkon ka Jehova Esowo ebahne, kana lim eltum. ");
INSERT INTO eka_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Fangen erahde ebsehma yehke, bomo ngare nyi ḿ bomo elkoko abontahme kiimi nkohlsak. ");
INSERT INTO eka_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Ngare nyio nyi ḿ bahke limi elkak ni Arahde ka Jehova Esowo ebahne. Mbang nyi ana nyi ḿ bahke jo lim. ḿ bahke jo ka ayare ana nne toobo ege eltim, jangjang ana Jehova Esowo ebahne ma-n fuulu. ");
INSERT INTO eka_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","Jo geeren go esamahr bi Jehova Esowo ebahne, go edi ji á bahke yehke ana edi ji bo bahke jo kak Mbing enye, fere jo kpun-e. Ḿ bahke limi ano, wahn a abon ebahne ba nlum a ba nkal, alokeltum ebahne ba nlum a ba nkal, a anebe etˈtohngo ji Levi, a ajahmjahm, go ane ba ki kpi babnde, a akalebun ba lene go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Buumen re, ń jolo aju go Ijib, wahn jo kunu ekpu toono atahm nyaa. ");
INSERT INTO eka_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Limen elkak ni abonkpatahk go nfung na esehma ngare nyi ḿ ma fv nsol enyahne, fere kaame mahm bum. ");
INSERT INTO eka_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Jo geeren, go egahne elkak, wahn a abon ebahne ba nlum a ba nkal, alokeltum ebahne ba nlum a ba nkal, a anebe etˈtohngo ji Levi, ajenne, abon ba ki kpi babnde, a akalebun, ba lene go egahna mfam. ");
INSERT INTO eka_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Jo limen elkak nio nfung na esehma ka Jehova Esowo ebahne, go edi ji Jehova bahke yehke, tibre Jehova Esowo ebahne bahk-n fuulu go nsol kpee nyi ḿ bahke fohko, a eltum abo enahne kpee, ano eyebatahng ejahne bahke biingi rehng nseenge. ");
INSERT INTO eka_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Aneblum ebahne bahke tiki ba wane go esamahr bi Jehova Esowo ebahne nkpel na era go elya, go edi ji ye bahke yehke. Bahke jolo go elkak ni ebred ji eyisi ki wob; go elkak ni Arahde, a elkak ni abonkpatahk. Nnene kꞌba yiimi esamahr bi Jehova abo abo. ");
INSERT INTO eka_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","M bahke koko ayare ba a nya, no nne, jangjang ana Jehova Esowo ebahne ma-n fuulu. ");
INSERT INTO eka_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Yehken abalamalam kunu, a atubesi ntum go etꞌtohngo ajehng ajehng go mfam anyehng anyehng nyi Jehova Esowo ebahne kp-n kake. Bo bahke jo lam ane go mbang nyi nno. ");
INSERT INTO eka_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Kana jo bvvrv elam, jol kana jo rang ane. Kana jo ko ngu, tibre ngu akoko kpo wa ebangbang nne amahr, fere yaange alum nya nne a mbolmbol. ");
INSERT INTO eka_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Jo toono mbang nyi elam alame ji nno nyi nyi, eji ń lꞌkpin fere ko ndi nyi Jehova Esowo ebahne kp-n kake. ");
INSERT INTO eka_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Kana tiki lo eti elokelom ji Asera, kohlo egudu njom ji ḿ bahke sehke ka Jehova Esowo ebahne, ");
INSERT INTO eka_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","Jol kana lo eltal ni li re nne jo kak, tibre nsol nyia nyi kpo tehn Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","<<Kana ko mmona mfong, afi njoro nyi kpi elem ajehng ajehng, afi nyi kpi akpafeme lim njom ka Jehova Esowo ebahne, tibre jio li ejum ji kpo sahb sab-e sab. ");
INSERT INTO eka_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Lˈjol nnenlum, afi nnenkal no lene go egahne mfam anyehng anyehng nyi Jehova Esowo ebahne kp-n kake, kpꞌlimi abꞌbi go esahmahr bi Jehova, jo daange nwongo nyi Jehova, ");
INSERT INTO eka_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","eji á ma sennge njahm go nkahn enyame, fere kpˈ kake asowo nyako, jo gong ka bo, afi á jo kak njul, afi ebareka, afi alonlo nya li go elbung, ");
INSERT INTO eka_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","bo lꞌba tong-n ejum ana jia, ḿ bahke feede nob nob. Bo lꞌfeede kahn re etingitingi ji, re yeblohko lim esabsab ejum ana jia go Isreel, ");
INSERT INTO eka_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","Roden nnenlum afi nnenkkal noo no ma lim ebꞌbi ejum ana jia song go etimbu mfam ejahbe enyahne, wahn song tuub-e atal wul. ");
INSERT INTO eka_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Ane abal afi, ane ara, lꞌyiimi ntianse lohng nne njahm, ḿ bahke wulu nne noo. Kana toono ntianse nyi nne awohng nyi nyi wul nne. ");
INSERT INTO eka_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Atianse nya bahke gboko mbang bom-e elwulu, ane bako kpee kehm tob kak ebo. Go mbang nyia ḿ bahke tiki kam na abꞌbi yehke go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","<<Ngare nyi bo lꞌko atongtong ba go ntahk alam enyahne, nya kpꞌtahne sehng-n re wahn lam, afi jolo ji bo limi nne ejum, afi ewulunne, afi jolo re nne ebgbo ntahm, afi jolo ji nne noko a ntem, roden bo song go edi ji Jehova Esowo ebahne bahke yehke. ");
INSERT INTO eka_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","Songen go eji ane ba kpo lim ajom, bo ji li anebe Levi, a nlamalam no kun ngare nyio. Bahben bo, bo bahk kimi elam. ");
INSERT INTO eka_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","Ḿ bahke limi ana bo kimi elam ka-n, go edi ji Jehova bahke yehke. Jo kunen ekpu, wahn lim nsol kpee nyi bo tiben re wahn lim. ");
INSERT INTO eka_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Limen ana bo tib-n no, fvfo ana bo kimi elam ka-n. Kana ten ellimi ji bo tong-n no, sennge feere eboblum afi ebobkal kˈlim ji bo tong-n no. ");
INSERT INTO eka_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Nne no lꞌlim edaangenne a nlamalam, afi njomanjom no kpo yiimi jo loko Jehova Esowo ebahne, ḿ bahk-e wulu. Go mbang nyia ḿ bahke tiki yehke abiafem go Isreel. ");
INSERT INTO eka_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","Ane kpee bahke wuku, fere jo fahl, bo nehm kpe jo lim edaangenne. ");
INSERT INTO eka_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Ngare nyi ḿ ma yel go ndi nyi Jehova Esowo ebahne kp-n kake, eji ḿ ma ko, fere lene o, ń lꞌbung re, <<Wahr bob-n ntul kunu á jo fil-r ana ajahbe nyako kpee nya li senng-r kak.>> ");
INSERT INTO eka_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","Kunen ekpu, wahn bob ntul no Jehova Esowo ebahne me-e yehke re á fil-n. Á bahke tiki lohng go ellong abonane ebahne Isreel . Kana rod njenne kunu etul re á jo fil-n, ye ji ki li nnea Isreel no li mmonanne ewahne. ");
INSERT INTO eka_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Budu o, ntul noo nehm da anyꞌnya gbalee bum elne, jol á nehm lim re ane kpe feere go Ijib song ko anyꞌnya, tibre Jehova ma-n tong re, <<Wahn nehm kpe tiki feere song sehng go mbang nyio.>> ");
INSERT INTO eka_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Á nehm baange akal gbalee, eji á lꞌkꞌ sennge eltim ene tv go. Á kꞌtiki da asilva a agul gbalee luk elne. ");
INSERT INTO eka_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Ngare nyi á ma ji eti etul ji ejahbet eje, á bahke nyono atahm nyaa go nlaba nwer, nya á ko goji anebe levi ba li abalimajom. ");
INSERT INTO eka_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Bahke jolo a ne, á jo lung afung kpe kpe nya á li go elkpin, eji á lꞌkpili ana á bahke jo kpunu Jehova Esowo ebe, fere jo kunu ekpu toono alum kpee nya ntahm nyia, a nle nyia. ");
INSERT INTO eka_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Eji á lꞌkꞌ jo nyehn elne re á kpꞌnobo sehnge abonanyehn Isreel, fere sennge njahm go ntahm feere go ejang eboblum, afi ejang ebobkal. Owo ye, a etˈtohngo eje bahke fili ane ekidi lˈlab go ege eti etul go Isreel. ");
INSERT INTO eka_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","<<Abalimajom ba li anebe Levi, a etˈtohngo ji Levi kpee, bo nehm bel mbaangandi afi ejum elehkelkv a anebe Isreel. Bo bahke jo kpin go ayare nya anebe Isreel bahke jo lim ajom ka Jehova, tibre nya nya li ejum elehkelkv ebo. ");
INSERT INTO eka_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Bo nehm bel ejum elehkelkv go ellong abonanyehn ebo, anebe Isreel. Jehova wo li ejum elehkelkv ebo, ana á nyame tong bo. ");
INSERT INTO eka_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","A wo li mbaka nsol nyi li ka abalimajom go abo nya ane ba ko mfong, afi njoro lim njom: ebo, ala a ajoobo nya wob atahng, a esi. ");
INSERT INTO eka_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Ḿ bahke jo ka bo agbokombang akabenti nya nkohl enyahne, amahm mfemfe, a akehng oliv, go anyar nya ń gbo mbang kpud ejoro ebahne. ");
INSERT INTO eka_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Tibre Jehova Esowo ebahne ebyehke bo, a abon ebo ba bo bahke jele toono bo, go egahna atꞌtohngo kpee re bo jo yiimi jo loko go Mbing nyi Jehova ngare kpe kpe. ");
INSERT INTO eka_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","Nnea Levi lꞌlohng go mfam ejahbe enyahne anyehng go edi ajehng ajehng ji á lene no go Isreel, ba go eltim anehng edi ji Jehova bahke yehke, ");
INSERT INTO eka_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","á li ma loko eltum go Mbing nyi Jehova Esowo ebe, ana anebe Levi bako kpo loko o elwo ni Jehova. ");
INSERT INTO eka_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","Bo bahke tob bak ka-e jang jang go mbaange anyehng anyehng nyi li no, jol afi yebko akpohko nya bo gungu ndi nyi ebangenahb eje. ");
INSERT INTO eka_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Ngare nyi ḿ ma yel go ndi nyi Jehova Esowo ebahne kp-n kake, kana kpili ana ḿ bahke leeme asabsab abang nya elkpin nya ane bao ba ajahbe nyao nya li o. ");
INSERT INTO eka_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Nong nnene kꞌjol go egahne ellong no kpo rod mmon ewe no nlum afi no nkal lim njom nyi eljahme fi, afi no kpo bu mbu, nnea ntaane, nne no kpo lennge ana ebi ejum ji ma gbo tub nne lohng no, afi nne no kpo lim aje, ");
INSERT INTO eka_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","afi nne no kpo jahng ane, afi nnyehnamahr akvne, nne no kpo bung a atohko, afi nne no kpo bung a akvne. ");
INSERT INTO eka_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Nne awohng awohng no kpo lim nsol nyia li esabsab ejum ka Jehova, tib go asabsab nsol ana nyaa, Jehova Esowo ebahne bahk-n gboko mbang song kam ajahbe nyao yehke go egahne esamahr. ");
INSERT INTO eka_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Ḿ bahke jolo ane ba lꞌkꞌbel ebi egahme go esamahr bi Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Ajahbe nya ń fi song taare bo ndi, kpo wuungu anebe ntaane a abuku mbu atung. Wo ana wahn, Jehova Esowo ebahne wahn ka yake re wahn jo lim ano. ");
INSERT INTO eka_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Jehova Esowo ebahne bahk-n kake nnyehnamahr ana me, no bahke lohngo go egahne ellong, goji abonane ebahne Isreel. Ḿ bahke jo wuung-e atung. ");
INSERT INTO eka_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Tibre ejum ji a, ji ḿ bahbe Jehova Esowo ebahne go ewong Horeb efung nkon bio, eji ḿ bungu no re, <<Nong wahr kꞌkpe wuk ellum ni Jehova Esowo ebahre, jol wahr kꞌkpe nyehn agburu agun nyaa, tohko jol ano e bahke kpoko. ");
INSERT INTO eka_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Jehova bungu tong-m re, <<Ejum ji bo ma bung a, ebnob. ");
INSERT INTO eka_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","M bahke kake bo nnyehnamahr no li ana wo, no bahke lohngo go ellong abonanyehn ebo Isreel, m bahk-e kake alum enyame go egea nnyo, á bahke jo tong bo ejum ajehng ajehng ji n ka-e elkahn. ");
INSERT INTO eka_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Nne awohng awohng no tohko wuungu atung go alum enyame nya nnyehnamahr noo bahke bungu go egama Mbing, mefono antahng m bahk-e jabbe. ");
INSERT INTO eka_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Wo nnyehnamahr no lꞌyiimi jo kiimi afahnge, go egama Mbing, eji n ki-e tum na, afi nnyehnamahr no bungu go mbing asowo nyako, bo bahk-e tiki wul na.>> ");
INSERT INTO eka_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Anv, ḿ bahke jo bung tong elnahne re, <<E bahke limi renan, kehm kahne, etib tohko fere lohng goji Jehova?>> ");
INSERT INTO eka_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Lꞌjol re ejum ji nnyehnamahr noo kpꞌtooro go Mbing nyi Jehova, limem ano, afi lim go etingitingi, lohngo re etib bio, bi Jehova ki tum. Nnyehnamahr noo kpꞌtob bung na bung go egea nsahm. Kana ye fahl. ");
INSERT INTO eka_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","<<Ngare nyi Jehova Esowo ebahne ma rannge ajahbe nya á kp-n kake ndi a bo, ngare nyi ḿ ma kam bo yehke fere lene go ebo mfam ajahbe a ntahk ebo, ");
INSERT INTO eka_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","Ḿ bahke yehke egburu mfam ejahbe na era ka elnahne, go ndi nyi Jehova Esowo ebahne kp-n kake. ");
INSERT INTO eka_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","Gaben ana mbang bahke labe , wahn fere baange ndi nyi Jehova Esowo ebahne kp-n kake ana ejum elehkelkv go edi ebra, eji nne awohng awohng no wulu nne bahke beke song biirimfam ejahbe anyehng nyio. ");
INSERT INTO eka_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","Atahm nya a, nya li bada nne no wulu nne fere be song yel o, re á tahre elkpin ene. Nne no lˈwul nnebjing ewe go efin, eji á ki lohko toobo na go eltim re á wul-e, jol go ekv bo limm wuku wuku. ");
INSERT INTO eka_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","Ntugare li re, nne bahke ma tahm ekulugbe a nnebjing ewe re á song gbakke nti. Ana á fohko elfuk ene bahke ma juk song tub nnebjing ewe noo, á soro kpo. Nne noo bahke ma be song yel ejahbe ajehng go ejahbe ebra bio for. ");
INSERT INTO eka_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","Tohko jol ano, mmonannyehn nne no li re á bongo go ewul bio, bahk-e kame go eraketahng song kpiri, lꞌjol re mbang kpꞌlabe sehng, fere wul-e, jol eji li li re fuumem re bo wul-e. Tibre á limi nnebjing ewe ejum jia, jol ekv bo limm ");
INSERT INTO eka_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","Jia ji wahnge n kp-n kake elkahn nia re wahn yehke ejahbe na ebra bum elnahne. ");
INSERT INTO eka_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","Jehova Esowo ebahne lꞌfere lim re edi ndi ejahne kpe yange budu, ana á nyame no go nwongo tong babnso ebahne ba nkul, fere ka-n ndi kpee nyi á nyame tong bo, ");
INSERT INTO eka_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","tib eji wahn kpꞌkunu ekpu jo toono atahm nyaa kpee nya n kp-n kake elkahn lela re Jehova Esowo ebahne jo kor-n, wahn fere jo jen go abang enye ngare kpe kpe, owo ḿ bahke kpe yab mfam ejahbe na era nyehko bum eje eje. ");
INSERT INTO eka_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","Limen jia eji ane lꞌkꞌjo wul ane, alung mbol mbol jo lohng go ndi enyahne nyi Jehova Esowo ebahne kp-n kake ana ejum elehkelkv, eji ń lꞌkꞌli ebi ji ḿ ma yehke alung mbol mbol. ");
INSERT INTO eka_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","Wo, lꞌjol re nnebjing a nne kp-e sabe, á song biiri jo sik nnebjing ewe noo, nok a ne, fere wul-e, á lꞌbe song yel mfam ejahbe anyehng nyia, ");
INSERT INTO eka_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","Anebkul ejahbe eje bahke tumu ane tv-e, bo ko-e go mfam nyio feere a ne ba yake kak mmonannyehn no li re á bongo go ewul bio. ");
INSERT INTO eka_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","Á ki-n fili ndon anyehng anyehng. Ḿ bahke kame ebi alehke jio ji alung nne a mbol mbol yehke go Isreel, eji lꞌnob a nahne. ");
INSERT INTO eka_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","Ka yehke eltal nkonandi ni nnebjing ewa ni ane ba gbo mbang jol o, ni bo lo no go ndi nyi á li elkv, nyi Jehova Esowo ebahne kp-a kake re wo ko. ");
INSERT INTO eka_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Ntianse nyi nne awohng, gbalem re wahn ko, ka nne ebi go ejum ajehng ajehng ji á limi no. Elbungu bahke yiimi go nnyo elam mi ntianse ebal afi ntianse era. ");
INSERT INTO eka_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","Nkimfahnga ntianse lˈba yiimi elam re á bung ka nne ebi, re nne noo eblim esabsab ejum, ");
INSERT INTO eka_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","ane abal ba kpi elam jio bahke tiki yiimi na, go esamahr bi Jehova, fvfo go elwo ni nlimajom, a abalamalam ba li eltum ngare nyio. ");
INSERT INTO eka_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","Abalamalam bahke kunu ekpu feede nob nob, lꞌfere jol re ntianse nyio bob seb kahn re á li nkimfahnge nyi kpˈyiimi ntianse efahnge ka mmonannyehn nnea Isreel, ");
INSERT INTO eka_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","Limen ye, ana ye tiri re á lim mmonannyehn. Ḿ bahke tiki kam na abꞌbi nyao yehke go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","Erik ane bako bahke wuku ejum jia soro jo fahl. Nnene nehm kpe tiki lim ebi ejum ana jio go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Kana be nne ndon: Ḿ bahke jo ko elkpin gal elkpin, ko elmahr gal elmahr, ko elmahn gal elmahn, ko ebo gal ebo, fere ko ekpade gal ekpade. ");
INSERT INTO eka_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","<<Ń lˈtahm ebta anoko a anebekv ebahne, ń lꞌsong nyehn anyꞌnya a amvtv ebta, a nsoja nyi kpꞌruru sehng-n, kana fahl bo, tibre Jehova Esowo ebahne bi ko-n no go Ijib ba, á bahke jolo anahne. ");
INSERT INTO eka_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","Ngare nyi ń yahke bom ebta anoko, nlimajom bahke lohngo yiimi, bung a nsoja. ");
INSERT INTO eka_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","Á bahke bungu re, <Anebe Isreel wuk-m wahn! Anv, lela ń yahke nok ebta a anebekv ebahne. Nong ntim ki-n kim go ala, jol kana fahl bo, kana taame ntim gbehk-n afi bo menng-n . ");
INSERT INTO eka_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","Tibre Jehova Esowo ebahne wo fi a nahne, re á song nok a anebekv ebahne ka-n, eji á lꞌka-n esehngebta.>> ");
INSERT INTO eka_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","Atubesi abalimeltum bahke bungu tong nsoja re, <<Nne awohng awohng noa no ma si etahk mfemfe ji á kala rod kak Jehova go eboa? Nong a feere kehnge, tohko jol ano, á li ma kpo go ebta, fvfo nne nondiki bahke feere song bom ellene o. ");
INSERT INTO eka_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","Nne awohng awohng ebbahm abgbe agreb ji á kala kehme ellehka? Nong á feere kehnge, tohko jol ano, á li ma kpo go ebta nne nondiki song ting li. ");
INSERT INTO eka_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","Nne awohng awohng eblim ellennge go esi nnenkal no á kal-e baang-a? Nong á feere song kehnge, tohko jol ano, á li ma kpo go ebta, nne nondiki fere song baang-e.ˈ ");
INSERT INTO eka_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","Atubesi nsoja bahk kpe bung re, <<Nne awohng awohng noa no kpꞌfahla, afi no eko kp-e tana? Nong á feere song kehnge, eji atem asoja lꞌkˈtob gbo eltim. ");
INSERT INTO eka_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","Ngare nyi atubesi nsoja ma bung a nsoja mal, bo bahke yehke atubesi nsoja ba bahke jo fili bo go nlong a nlong. ");
INSERT INTO eka_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","Ngare nyi ḿ ma tahm eljen asongo re wahn song nok a ejahbe, bungen ane bao re, ń yahke lim elkoono a bo. ");
INSERT INTO eka_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","Bo lꞌtaame, fere lennge ati mbu ebo ane ba lene o kpee bahke jolo jolo aju enyahne fere jo lok-n, bo bahke jo lim eltum ka-n. ");
INSERT INTO eka_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","Bo lꞌfere ten elkoono alimi, fere yiimi re bo yahke nok a nahne, noongen sennge mfam nyio kak wahn kohko bo tv. ");
INSERT INTO eka_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","Jehova Esowo ebahne lꞌjabbe kak-n go ebo, wulen aneblum kpee ba li o. ");
INSERT INTO eka_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","Wo anebkal, abonse a atohkondi go ejum ajehng ajehng ji li mfam nyio. Ḿ bahke ma ko nyao ka elnahne ana nsol nyi ń da go ebta. Ḿ bahke ma ko nsol nyio nyi Jehova ka-n no, nyi ń da go ebta lim ji kor-n no. ");
INSERT INTO eka_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","Ana wo ḿ bahke jo lim ajahbe kpee nya li go fee nya ki li kohl-n, nya ki li ka ajahbe nya li kpidikpidi. ");
INSERT INTO eka_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","Wo go agburu ajahbe nyao nya ajahbe nya Jehova kp-n kake ana ejum elehkelkv, kana yake ejum ajehng ajehng ji kpꞌvohko elv, re jol go elkpin. ");
INSERT INTO eka_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","Malen na mal bo kpee, ana Jehova Esowo ebahne ka-n elkahn. Ajahbe nyao nya a: anebe Hiti, anebe Amor, anebe Kenan, anebe Periji, a anebe Hivi, go aneb Jebusi. ");
INSERT INTO eka_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","Tohko jol ano, bo bahk-n tibi re wahn jo toono asabsab nsol ebo nyi bo kpo lim eji bo kpo kak asowo ebo toono o, ń lim abiafem bade Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","Ń lꞌnoongo sennge ejahbe afung gbalee, eji ń kpˈnoko, re wahn ko, kana ko elfuk gbakke nti nyi li o rannge, tibre ḿ bahke ma li akab nti nyao. Kana gbakke nti nyio tub. Anv, nti nyio ane baa, nyi ḿ bahke song noongo sennge bo kaka? ");
INSERT INTO eka_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","Limi limi kan, ń li ma gbakke nti nyi ń kpꞌkahne re kpehme kab akab, eji ń lꞌko si adi elkuumu tete mfam ejahbe nyio nyi kpꞌnoko ebta anahne gbo. ");
INSERT INTO eka_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","<<Ń lꞌnyehn nne no bo me-e wul, nong go ekane, go ndi nyi Jehova Esowo ebahne kp-n kake re jol nyˈnyahne wahn, lꞌjol ji ń kil elkahne nne no wul-e no, ");
INSERT INTO eka_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","anebkul ebahne, a abalamalam, bahke song gaare ana labe no, bomo edi ji nkvne nong no, tete rehng go mfam ejahbe nyi li kohlo o. ");
INSERT INTO eka_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","Anebkul ba mfam ejahbe nyi ga kabbe ekv nne jio, bo bahke koko mmona mfong no bo kala kꞌko lim eltum, jol bo w-e ka kꞌkak ebˈbini go emel. ");
INSERT INTO eka_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","Bo bahk-e kohko song rehng go edamme ji bo kala job, jol bo ka bahm nsol, edi ji ebgbalahb bi kpˈfabe li no. O edamme jio wo, bo bahke bahne mmona mfong noo emel. ");
INSERT INTO eka_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","Abalimajom, anebe Levi, bahke lohngo yiimi, tibre bo ba Jehova ma yehke bo re, bo jo lim eltum, fere jo biri elfuulu go mbing nyi Jehova, fere jo toobo atongtong nya nfaabe, a abohng. ");
INSERT INTO eka_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","Anebkul kpee, ba lene mfam nyi li kohlo ekv nne jio, bahke ruku abo ebo wohngo mmon a mfong no bo bahn-e emel go edamme, ");
INSERT INTO eka_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","fere bung re, \"Abo enyahre sang yehke alung maa, jol wahr nyehnem na, nne no limi no. ");
INSERT INTO eka_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","Jehova, ko elgongo nia, go esi Isreel ane eba, bo ji á ma fak bo. Ka jabbe ane eba re bobli ebi go alung nnea mbol mbol.\" Owo bo bahke gongo, go alung ma bo yehke no. ");
INSERT INTO eka_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","Ano wo ḿ bahke fulu elnahne ebi jio ji ḿ ma yehke alung mbol mbol tib eji ḿ ma lim ji li nseenge go esamahr bi Jehova. ");
INSERT INTO eka_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","Ń lˈje re wahn song nok ebta a anebekv ebahne, Jehova Esowo ebahne lꞌyake bo kak-n go ebo, ń fere bob anebekv kehnge a bo, ");
INSERT INTO eka_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","a l nyehn nnobonoba nnenkal go ellong ane ba bo bobo no, á lꞌfere kor-a, a bahk-e ma ko ana nkal ewa. ");
INSERT INTO eka_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","Ko-e kehnge a ne go ega etahk, tong bo kpud-e esi, fere kiim-e anyaange, ");
INSERT INTO eka_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","Bo yehk-e nsol ebjing nyi á kake no, ngare nyi bo bob-e no. Eji á ma lene go ega etahk, noongo elkv nde a nnyehn go nnyahng amehng kohro kohro, owo a bahke ma noongo a ne, á jol nkal ewa, wo jol nlum ewe. ");
INSERT INTO eka_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","Á tohk-a fere kor, nong á song eje, edi ajehng ajehng ji kor-e no. A w-e nehm gungu, jol k-e ko ana nju, eji li re a me-e rod daange. ");
INSERT INTO eka_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","Nnenlum lꞌfere ko akal abal, nkal awohng lꞌjo kor-e sehnge noko, bo ane abal abal lꞌjel abon ba nlum ka-e, lꞌjol re ngbokambang a mmon noo, nkal no kil jo kor-e wo jel-e, ");
INSERT INTO eka_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","ngare nyi á kpꞌnyono nwer bak abon ebe ba nlum bada nsol enye, á nehm tiki rod ekul bi ngbokambanga mmon no nnenkal no ki jo kor-e, ka mmon no nnenkal no jo kor-e, fere tahm ngbokambang sa, no nnenkal no kil jo kor-e. ");
INSERT INTO eka_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","Á bahke tiki liingi mmon no nkul ewe no nnenkal no ki-e jo kor, ana ngbokambanga mmon, fere ka-e nsol kpee nyi á kpi no, go edi ebbal. Mmon noo wo li ngbokambang elliingi ni atahne nya nde. Ekul bi ngbokambanga mmon li ka-e. ");
INSERT INTO eka_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","Nne lꞌbel mmon no kpo tahne esi, no kpo yiimi etahnsi kꞌjo kpunu nde ewe a nnyehn, no kil jo wuk bo lꞌkak-e erem. ");
INSERT INTO eka_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","Nde abola nnyehn bahk-e tubu ejahm ko-e ba go eji anebkul go eti mbu mfam. ");
INSERT INTO eka_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","Bo bahke bungu tong anebkul re, <<Mmon ewahre noa kpo tahne esi, jo yiimi etahnsi anahre. Jol á wahr kpehme kpunu. Á li nne elwur a nwokamahm a nne. ");
INSERT INTO eka_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","Owo aneblum kpee ba mfam ejahbe enye bahke tuubu mmon noo atal wul. Ḿ bahke tiki ful ebꞌbi yehke go egahne ellong. Anebe Isreel kpee bahke wuku bade, fere jo fahl. ");
INSERT INTO eka_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","Nne no ma li ebi go elam, ji li re bo wul-e, bo lꞌkahn-e nlehke wul, ekv eje bahke tokko o eti, ");
INSERT INTO eka_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","ń nehm tiki yake ekv eje re tokko o eti sene etoono efung. Kahnen re, nobo re wahn kpa-e kak efung bꞌnehm, tibre nne awohng awohng no bo kpak-e go eti, elsu ni Esowo li a ne. Kana tiki lim ndi nyi Jehova Esowo ebahne kp-n kake ana ejum elehkelkv kˈjol saang. ");
INSERT INTO eka_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","<<Ń lˈnyehn mfong nyi mmonanne nnea Isreel, afi njoro enye nyi ma tan, kana tong re, ˈˈO ntong enyahre sang>>. Bumen go egahna ntim re wahn ko nnyam nyio feere song ka mfono. ");
INSERT INTO eka_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","Lꞌjol re bo lenem kohl-a, afi á nyimm nne no li mfono, ko nnyam nyio kehnge anyi go ega etahk, ba bum-e tete á seb-e ba. Fvfo, feere anyi ka-e. ");
INSERT INTO eka_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","Tob limen ano, ń lꞌnyehn mbvankanga mmonanne ewahne, afi mbomo elbulu esi eme, afi ejum ajehng ajehng ji tan-e no. Kana tong re o ˈNtong enyahre sangˈ. ");
INSERT INTO eka_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","Ń lꞌnyehn mbvankang nyi mmonanne ewahne nnea Isreel, afi mfong enye, eji á ma gbo go mbang, kana tong re, o ntong enyahre sang. Toben mfono, wahn mehl-e yiimi. ");
INSERT INTO eka_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","Nnenkal kꞌtiki kak nsol ebjing nyi aneblum, jol nnenlum kꞌkak nyi nnenkal. Tibre Jehova Esowo ebahne nne awohng awohng no limi nsol nyia kpo sabe sehng. ");
INSERT INTO eka_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","Ń lꞌnyehn etahk ebruk go nkpea mbang, afi jolo eti, afi go ndi, eji nnyehn ebruk kehm walle abon, afi aje, kana bob nnyehn ebruk a abon. ");
INSERT INTO eka_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","Ń li ma bob abon, tiki yaken nnyehn a song, eji lˈnob anahne, ń fere bel nlabe elkpin. ");
INSERT INTO eka_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","Ń lꞌsi etahk mfemfe, siin mmokahme sennge elbulu etahk enahne ni bale bale, eji nne lꞌkꞌfooro o gbo, toono o, ko ebi alehke ji alung ba ka-n egahne ntahk. ");
INSERT INTO eka_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","Kana bahm nkohn amohk nti na abal go egahne ebgbe agreb. A lꞌlim ano, mbahmandi nyio nyi nyi sang bahke jolo ejum eltehb go esamahr Esowo, yefono egbe agreb nyao fvfo bahke tob jol eltehb eltehb. ");
INSERT INTO eka_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","Kana rod mfong a mbvankang, kak bo eb'bini fadde re bo jo job ndi ka-n. ");
INSERT INTO eka_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","Kana kak nsol ebjing nyi bo ko av a abomo jahm semme. ");
INSERT INTO eka_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","Kanen akpud, kak go nsongo eni nyi ekpawobo ji elkonngo. ");
INSERT INTO eka_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","Nne lꞌko nkal, eji á ma noongo a ne, lꞌjol re nnenkal noo we-e nehme kpe kor, ");
INSERT INTO eka_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","á lꞌkehme eltooro nnenkal noo yannge fere ka-e ebi mbing re, <<M baange nnenkal noa, wo eji n noongo a ne, n nyehnem elliingi ni tib-m no re á ka sahb nne.>> ");
INSERT INTO eka_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","Owo nde abola nnyehn no mmonse nkal noo bahke koko ejum ji tibi re á ka sahb nne, ba goji anebkul mfam go eti mbu. ");
INSERT INTO eka_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","Nde mmonse nkal noo bahke bungu tong anebkul re, <<N tange mmon ewame no nkal ka nnenlum noa, wo mmon ewame we-e nehme kpe kor. ");
INSERT INTO eka_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","Anv, á kp-e tooro yannge fere jo bung re, <Me n nyehn re, mmon ewa no nkal ebsahb nne.> Wo ejum ji a ji kpˈtibi re mmon ewame sahbem nne. <Babnde bahke tanne mbomo mio bum go esamahr bi anebkul mfam, ");
INSERT INTO eka_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","fvfo anebkul bahke jabbe nnenlum noo kak-e erem. ");
INSERT INTO eka_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","Bo bahk-e kimi ngale re á gal ebahk esekel asilva atahl alon, nya bo bahke faake kak nde mmonse nkal go ebo. Tibre nnenlum noa ebka mongunga nnenkal ebi mbing go Isreel. Á bahke soro asi jol nkal ewe, jol á nehm yehk-e go elbal afung kpee nya á li go elkpin. ");
INSERT INTO eka_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","Wo lꞌfere jol re ebi ji bo ka-e no lohko li go etingitingi, ejumjum limm ji bahke tibi re mmonse nnenkal noo sahbem nne. ");
INSERT INTO eka_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","Bo bahk-e koko ba go mbutahk mi etahk nde, edi jio wo aneblum ba mfam ejahbe enye bahk-e tuubu atal wul. Tibre yeblim ejum esono go Isreel tib eji á jo famme yannge ngare nyi á kpeka li go etahk nde. Ḿ bahke tiki yehke ebꞌbi go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","Ń lꞌbob nnenlum no kpꞌnoongo a nkala nne, nnenlum noo no noongo a ne, a nnenkal noo, bo ane abal abal bo bahke bo wul. Ḿ bahke tiki yehke ebꞌbi jia go Isreel. ");
INSERT INTO eka_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","Nne lꞌsong noongo a mongunga nnenkal go mfam, no bo ma lam elbal a ne, ");
INSERT INTO eka_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","Ḿ bahke koko bo ane abal abal tahm go etimbu ji mfam ejahbe nyio, song tuubu bo atal wul. Mmonse nkal noo bahke kpoko tibre eji á jolo jol o mfam ane, á rabem lung ane, nnenlum noo bahke kpoko tibre yebrod nkala ntem daange. Ḿ bahke tiki yehke ebꞌbi jia go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","Wo, lꞌfere jol re go ekulugbe wo nnenlum song nyehn mmongunga nnenkal no bo ma lam elbal a ne, fere bob-e noongo a ne, nnenlum noo, ye ji limi ejum jia, ye wo bahke kpoko antahng. ");
INSERT INTO eka_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","Kana lim mmonse nkal noo ejumjum, abiafem á ka lim nya fuumu re á kpo. Elkohn elam jia li ana nne no song bohko nnebjing ewe abohng, wul-e. ");
INSERT INTO eka_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","Tibre nnenlum noo nyehne mmonse nkal no bo ma lam elbal a ne go ekul, jol afi á rabe na, nnene jolem no bahk-e tahre. ");
INSERT INTO eka_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","Nnenlum lꞌsong kpiri mongunga nnenkal no bo kala lam elbal a ne, bob-e noongo a ne, bo lꞌbob bo, ");
INSERT INTO eka_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","á bahke kpiki nde mmonse nkal noo ebahk asilva atahl ebal ewubu. Á bahke tiki ko monse nkal noo, tibre á me-e rod daange. Jol á nehm ma tiki mal elbal a ne, afung kpee nya nnenlum noo li go elkpin. ");
INSERT INTO eka_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","Nong nne kꞌko nkala nde, á kꞌtiki song lennge ngubjinga nde sa ebun ebun. ");
INSERT INTO eka_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","<<Nne awohng awohng no ma wa amohk nfahn, afi no bo yehk-e bo na kim-e eri, nehm yel go ellong ni ane ba Jehova. ");
INSERT INTO eka_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","Nnene kˈyel go ellong ane ba Jehova, no bo jele go elbal ni ki toono ntahm nyi Jehova, afi abon abon ebe ba, jol afi kange rehng eying na ebwubu. ");
INSERT INTO eka_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","Nnea Amon awohng awohng, afi nnea Moab, afi jolo anebe etˈtohngo ebo, kˈyel go ellong ane ba Jehova. Jol afi kange rehng eying na ebwubu. ");
INSERT INTO eka_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","Tibre bo wahn wanem go mbang a nsol alehke go alahb, eji ń lohngo go Ijib asongo . Bo song yaame na Balam ji mmona Beor, ye ji lohngo go Peto ji li Aram Naharem re á ba su-n. ");
INSERT INTO eka_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","Limi limi kan, JEHOVA Esowo ebahne wuungem Balam atung; á fere kpiidi na nkuk nyio tv elfuulu ka-n, tibre wahn kpꞌkoro Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","Kana ko nwongo nyi etem a bo, afung kpee nya ń li go elkpin. ");
INSERT INTO eka_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","Nong nnea Edom ki-n jo daange go amahr, tibre ye ekunu ejahne ji. Nong nnea Ijib ki-n jo daange go amahr, tibre wahn lene ana ajahmjahm go ebo ejahbe. ");
INSERT INTO eka_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","Abon ebo bao ba bo jele ka bo, tete rehng eying ebra, bo bahke ma yel go ellong ane ba Jehova. ");
INSERT INTO eka_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","Ń lꞌjol go edi erekekv ji nsoja go emahng ebta, kpꞌsiki anebekv ebahne, yaben elnahne go ejum ajehng ajehng ji ki li saang. ");
INSERT INTO eka_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","Lꞌjol re nnenlum awahne awohng awohng limm saang tib go ebjing bi long-e no go ngare atv, á bahke lohngo tahm edi erekekv sa song jol fee. ");
INSERT INTO eka_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","Elgung lꞌkehme elbake, á bahke wuumu alahb, eji njul ma lahm, á feere go edi erekekv. ");
INSERT INTO eka_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","Yehken edi go nkpe edi erekekv ji ḿ bahke jo je esuku. ");
INSERT INTO eka_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","Go nsol ebta nyi ḿ bahke bele, tob belen ejum ji ḿ bahke jo ko kpa ndi. A lꞌje abahng nyi kpa elbing, wo nyi kak, tamme ndi bulu. ");
INSERT INTO eka_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","Tibre Jehova Esowo ebahne kpꞌjene yannge go egahne edi erekekv, eji á lꞌbaab-n, fere jabbe anebekv ebahne kak-n go ebo. Edi erekekv bahke tiki jo jol saang, eji á lꞌkꞌnyehn ejum eltehb ajehng ajehng go egahne ellong, fere sennge njahm. ");
INSERT INTO eka_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","Lꞌjol re nju ebbe yel etul go egahne, kana yake ye kak nde ewe go abo. ");
INSERT INTO eka_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","Nong á lene anahne edi ajehng ajehng ji kor-e no, a mfam anyehng anyehng nyi á yehke no. Kana ye fili nyaame nyaame. ");
INSERT INTO eka_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","Nnenlum, afi nnenkala Isreel awohng awohng kˈjol nne asˈsa etahk elom. ");
INSERT INTO eka_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","Kana ko akpohko nya bo kpi nnenkal asˈsa, afi nnenlum asˈsa, ba a nya go etahk Esowo ebahne re wahn ba ka nwongo nyi á ń ko no, tibre Jehova Esowo ebahne ane baa kpo sab-e sehng. ");
INSERT INTO eka_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","Kana ko mmonanne nnea Isreel nsehng go ejum ajehng ajehng ji ḿ bong-e no, afi jolo go akpohko afi nsol alehke, jol go ejum ajehng ajehng ji bahke kuumu nsehng. ");
INSERT INTO eka_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","Ḿ bahke ma ko nsehng goji anebe ajahmjahm, wo goji nnea Isreel mmonanne ewahne sang, eji Jehova Esowo ebahne, lꞌfuul-n go ejum ajehng ajehng ji a lake ebo re wahn lim go ndi nyi ń kpꞌyele re wahn song ko. ");
INSERT INTO eka_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","Ń lꞌko nwongo a Jehova Esowo ebahne, kana laange elkake ejum jio, tibre Jehova Esowo ebahne bahke tiki bahb-n ejum jio, ngare nyio ḿ bahke ebi li, re woblim abiafem. ");
INSERT INTO eka_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","Wo ń lˈfere kpuumu kꞌko nwongo, ń nehm li ebi. ");
INSERT INTO eka_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","Ejum ajehng ajehng ji ń lˈlennge nnyo emahne bung, jo bum ntir re wahn tiki lim, tibre ń ko nnyo emahne antahng ko nwongo nyio a Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","Ń lꞌyel go egbe agreb ji nnebjing ewahne, a li ma li akab enye ana kor-n no, sehngem re, kana rod nkab anyehng anyehng kak go egahna ejeere. ");
INSERT INTO eka_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","Ń lꞌyel go egbe nkohl ji nnebjing ewahne, ḿ bahke ma fohko go egahne abo nya ma gbo go ndi, kana tiki ko ntahme ja arahn nkohl ebo nya yim na. ");
INSERT INTO eka_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","<<Nnenlum lꞌ ko nnenkal, lꞌjol re nnenkal noo w-e nehme kpe kor, tib eji á ma nyehn ejum bade nnenkal noo ji kil-e ebkpe kor. á lˈnyon nwer elbal amale ka nnenkal noo, kam-e yehke go ege etahk, ");
INSERT INTO eka_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","ngare nyi á ma lohng elbal nio, tahm etahk nnenlum noo sa, á lꞌfere song bal nnenlum nondiki, ");
INSERT INTO eka_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","á tohko kpe kor etoono nlum we noo, nlum tob nyon nwer elbal amale ka-e fere kam-e yehke go ege etahk, afi etoono nlum noo lꞌfere kpo na, ");
INSERT INTO eka_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","ngbokambanga nnenlum noo no male elbal a ne, we nehm ma kpe ko go elbal eji bo m-e lim re a kˈkpe jol saang. Jia bahke jolo esabsab ejum go esamahr bi Jehova. Kana ko abiafem ba kak go ndi nyi Jehova Esowo ebahne kp-n kake ana ejum elehkelkv. ");
INSERT INTO eka_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","Lꞌjol re nne kpehna koko nkal, ń we-e nehm tum tv ebta, jol kana ye ka eltum anehng anehng. Á bahke jolo etahk go elya kohro kohro jo ka nkal ewe no á ma baange eyebatahng. ");
INSERT INTO eka_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","A l'bong nne ejum, kana ko eltal egoko nsol ni nne yahk-a na, jol mmon eltal noo go nkpaneka. Tibre jia li ana a ma ko ejum ji kpo ka nne ejum alehke. ");
INSERT INTO eka_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","Ń l'bob nne no ma weele bob nnea Isreel mmonannnyehn ewahne, fere jo bum-e ana nju, afi á gung-e na, nvohkane noo bahke tiki kpo. Ḿ bahke tiki ful abꞌbi nyao yehke go egahne ellong. ");
INSERT INTO eka_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","Go atongtong nya li bade eyam abili, jo kunen ekpu wahn lim jang jang ana abalimajom, bo ji li anebe Levi, tuben elle. Ḿ bahke tiki kunu ekpu toono ji m ma ka bo elkahn. ");
INSERT INTO eka_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","Buumen ji Jehova Esowo ebahne limi Meriam go mbang, eji ń lohngo go Ijib abake. ");
INSERT INTO eka_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","Ń lꞌbong nnebjing ewahne ejum ajehng ajehng, kana yel go ege ekpꞌkpa song rod ejum ji á kp-a yahke ana nkpaneka. ");
INSERT INTO eka_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","Yiimi elatahk, nong nne no a kp-e bongo ejum, ko ejum ji á kp-a yahke ba ka-a. ");
INSERT INTO eka_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","Lꞌjol re nne noo nkpak nyi, ka rod mbomo elkonngo eme mi á yahk-a no song bum tete sene efungfu. ");
INSERT INTO eka_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","Feere a mbomo elkoongo eme, song ka-e, njul kehm lahme, eji nneljing ewa lˈkonngo elne kehm lale. Owo á bahk-a kake saam, bahke jolo etingi ejum go esamahr bi Jehova Esowo eba. ");
INSERT INTO eka_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","Kana jo seb re wahn jo li nne no ń lak-e eltum nsehng, ye ji li nkpak nyi nsol m-e rin, jol afi á jolo nnea Isreel mmonanne ewahne, afi nne ajahmjahm no lene go mfam ejahbe anyehng enyahne. ");
INSERT INTO eka_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","Jo kpi-n bo akpohko eltum ebo efung efung, njul kehm lahme. Tibre ye nkpak nyi, amahr enye kpee kun o. Tohko jol ano, á li ma ling ka Esowo bada na, a fere li ebi. ");
INSERT INTO eka_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","Babnde nne, bo nehm jo wul bo tib esi ji abˈbi nsol nya abon ebo, jol abon bo nehm jo wul tib esi ji abˈbi bahb nsol nya babnde ebo. Nne awohng awohng bahke kpoko go ege abiafem. ");
INSERT INTO eka_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","Kana taare njenne, afi mmon no ki kpi nde eno elam. Jol kana ko mbomo eme mi elkonngo nkalebun ana ejum nkpaneka. ");
INSERT INTO eka_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","Buumen re wahn jolo aju go Ijib, Jehova Esowo ebahne wo tahr-n yehke o. Owo wahnge n kp-n kake elkahn re wahn jo lim jia. ");
INSERT INTO eka_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","Ń lꞌkehm elfohko nsol go egahne ebgbe,, ń lꞌnyehn agba nya ḿ ma sehng sa, kana feere song rod. Yake bum aneb ajahmjahm, ane ba ki kpi babnde, a akalebun, eji Jehova Esowo ebahne lꞌfuul-n go ntum abo enyahne kpee. ");
INSERT INTO eka_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","Ń lꞌkum akabe oliv go elrahn, kana kpe feere song feede abꞌbo. Yaken nya ma sa o ka aneb ajahmjahm, ane ba ki kpi babnde, a akalebun. ");
INSERT INTO eka_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","Ń lꞌbong agreb go egahne ebgbe agreb, kana kpe feere song feede agreb nyao.Yaken nya ma sa o ka ajenne, ane ba ki kpi babnde, a akalebun. ");
INSERT INTO eka_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","Buumen re wahn jolo aju go Ijib. Owo wahnge n kp-n kake elkahn re wahn jo lim jia. ");
INSERT INTO eka_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","<<Ane lꞌbel mfaabe nyi ma jol ntong, bo bahke koko tahm go etahk elam, abalamalam bahke toobo mfem nyio. Bo bahke kake nne a mbol mbol eno re á song eje, nne no li ebi, bo ka-e ebi. ");
INSERT INTO eka_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","Lꞌjol re nne no li ebi, fuumu re bo dv-e na, nlamalam bahk-e tongo re, á noongo. Bo bahk-e dohko nfanga nti ana ebi eje gbale no rehng, go esamahr bi nlamalam, ");
INSERT INTO eka_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","wo nlamalam nehm yake re bo dv-e sehnge nti atahl abal. Bo lꞌdv-e sehnge ano, mmonanne ewahne, nnea Isreel noo bahke fere daange go egahne esamahr. ");
INSERT INTO eka_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","Kana jo gba mfong nnyo ngare nyi á kpꞌdohko nkohl. ");
INSERT INTO eka_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","Abonanyehn nne lꞌlene edi ajehng, awohng lꞌkpo, no ki kpi mmon, nkalebun ewe nehm tiki tahm ebangenahb jio sa song bal nlum go njahm. Mmonannyehn nlum we bahk-e koko fere baang-e, jo lim eltum nio ni nnara nne ka-e. ");
INSERT INTO eka_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Ngbokambanga mmon no nlum no nnenkal noo bahke jele ka-e, bahke jo taame mbing nyi mmonannyehn no ma kpo, eji mbing enye lꞌkꞌtan go Isreel. ");
INSERT INTO eka_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","Lꞌfere jol re nne nehme seb re á baange nkala mmonannyehn, nnenkal noo bahke tahme song kpiri anebkul go eti mbu ji mfam, tongo bo re, <<Mmonannyehn nlum ewame ebten re á nehm soro asi a mbinga mmonannyehn go Isreel. Á nehm lim eltum nio ni nnara nne ka-m.>> ");
INSERT INTO eka_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","Owo anebkul mfam enye bahk-e lung fere bung a ne. Á lꞌfere soro asi yiimi re, <<N nehme seb re me m baang-e,>> ");
INSERT INTO eka_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","nkalebun noo bahke jene song kpiri mmonannyehn nlum go esamahr anebkul mfam kpee, yehke nnenlum noo ekpade ekpaketa ajehng, fere so atel wohng-e go ege esamahr, kehm bungu re, <<Ejum ji a ji bo kpo lim nne no kil sebe re ebangenahb ji mmonannyehn gbal.>> ");
INSERT INTO eka_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","Anebe Isreel bahke jo lung abangenahb ji nnenlum noo re, ebangenahb nne no bo yehk-e ekpaketa go akpade. ");
INSERT INTO eka_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","Aneblum abal lꞌkehme abohng nok, nkala nne awohng ebo, lꞌba re á ba tahre nlum ewe yehke go abo nya nne no kp-e dohko, nnenkal noo lꞌjabb-e go elfahn, ");
INSERT INTO eka_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","ḿ bahke kimi nnenkal noo ebo, á ki-n fili ndon. ");
INSERT INTO eka_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","Kana jo bel ejum edumu nsol ebbal go egahne ebam, ji kpꞌlubu a ji kpꞌyaare. ");
INSERT INTO eka_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","Kana jo bel ejum nsol agaare ebbal go egahne etahk, ji kpꞌgbale a ji kpꞌseke. ");
INSERT INTO eka_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","Ḿ bahke tiki bel nsol eldumu, nya li songo songo fere jol go nseenge, eji ń lꞌbel nlabe elkpin go ndi nyi Jehova Esowo ebahne kp-n kake. ");
INSERT INTO eka_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","Tibre Jehova Esowo ebahne, nne awohng awohng no kpo lim nsol nyia we kpehme kor, jol nne awohng awohng no kpo lim nsol enehm. ");
INSERT INTO eka_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","Buumen ji anebe Amalek lim-n no go mbang eji ń lohngo go Ijib abake. ");
INSERT INTO eka_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","Ngare nyi ń lahnge no fere kꞌkooko, bo kpir-n go mbang jo gboro ane kpee ba sa go njahm. Elfahle Esowo bo belem. ");
INSERT INTO eka_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","Ngare nyi Jehova Esowo ebahne ma-n ka erekekv go abo anebekv kpee ba lene no senng-n kak, go ndi nyi á kp-n kake re wahn ko ana ejum elehkelkv, ḿ bahke yehke mbing nyi anebe Amalek go njini. Kana yinao! ");
INSERT INTO eka_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","<<Ngare nyi ḿ ma yel go ndi nyi Jehova Esowo ebahne kp-n kake ana ejum elehkelkv, eji ḿ ma ko, fere lene o, ");
INSERT INTO eka_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","nong no nne ko agbokombang akabe nti nyandiki go nsol nkpakandi kpee nyi ń fv go ndi nyio nyi Jehova Esowo ebahne kp-n kake, wahn kak go ejeere. Songen go edi ji Jehova Esowo ebahne bahke yehke re bo jo kak Mbing enye, ");
INSERT INTO eka_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","wo bung tong nlimajom no bahke kuumu ngare nyio re, <<N kpꞌbungu gbul gbul gbuul lela tong Jehova Esowo eba re, me m ba go ndi nyi Jehova tiri no, ka babnso ewahre ba nkul re á bahk-r kake.>> ");
INSERT INTO eka_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","Nlimanjom bahke taare ejeere jio go ega abo, song jehke go mbuksong egudu njom ji Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","Owo a bahke bungu gbul gbul gbuul esamahr bi Jehova Esowo eba re, <<Nsoo ewame jolo nne Aram no jo jen yannge. Á tahme song jol go Ijib, a abon amohk ane, song lene o, kehm fere jol egburu ejahbe ji kpi eko, fere rˈrur go nfange. ");
INSERT INTO eka_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","Wo anebe Ijib jo fil-r mbang nyi kii nob, fere jo kak-r erem tib go atahntahn ntum nya bo jo kak-r. ");
INSERT INTO eka_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","Owo e kehm lingi tong Jehova Esowo bi babnsoo ewahre. Jehova kehm wuku aling enyahre, fere nyehn akanya enyahre, a erem bi e jo nyehn go elfili ni bo jo fil-r nyaame nyaame. ");
INSERT INTO eka_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","Jehova koo etahntahn ebo ebe yehk-r go Ijib, a ekv ebo ji á tanne no, a amenngo nsol, a nliingi, go akpokosi. ");
INSERT INTO eka_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","Á ko-r ba edi jia, fere ba ka-r ndi nyia nyi alahbbel, a akehng ekon, ma tv fad. ");
INSERT INTO eka_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Anv Jehova me n ko agbokombang akab nti nya ndi nyia, nya a ma-m ka, ba a nyaˈˈ. Bum ejeere jio go esamahr bi Jehova Esowo eba, wo fere gbo kohk, go ege esamahr. ");
INSERT INTO eka_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Wo, a ane ba lohng go etˈtohngo ji Levi, go ajahmjahm nya lene go egahne ellong, ḿ bahke geere kak anoobo nsol kpee nya Jehova Esowo ebahne ma-n ka, a ebangenahb eja. ");
INSERT INTO eka_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","Ngare nyi ḿ ma mal elyabe nsol nkpakandi enyahne, go elya ni limi nnya era, ni li elya ni ejum ajehng go nsol ewubu enyahne kpee, ḿ bahke kake anebe Levi, ajahmjahm, a ane ba ki kpi babnde, akalebun, eji bo lꞌli nsol go mfam ajahbe enyahne kpee fere wohngo. ");
INSERT INTO eka_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","Owo ḿ bahke bungu tong Jehova Esowo ebahne re, <<Me n yehke ekahmekahme ejum ji li ka Esowo go egame etahk. Me n ka anebe Levi, a ajahmjahm, a ane ba ki kpi babnde, go akalebun jang jang ana á ka elkahn. Jol n ka gbake feere go nkpe, tahm nkahn enya sa, jol n ka yini ejumjum. ");
INSERT INTO eka_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","N ka li ekahmekahme ejum ajehng ajehng ji li ka Esowo ngare nyi n noongo elkv, jol n yehkem ejum ajehng ajehng, ngare nyi n ki jol saang, jol n rodem ajehng ajehng lim njom ka akvne. Me n kpunu Jehova Esowo ebame, me n lim ejum ajehng ajehng ji wo ka-m elkahn. ");
INSERT INTO eka_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","Sa go elbung go ega edi ellene ji li saang, wo seenge, fuulu Isreel ane eba, a ndi nyi a ma-r ka, ana a nyame no ko nwongo ka babnso ewahre ba nkul, a ndi nyi alahbbel a akehng ekon ma tv fad.>> ");
INSERT INTO eka_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","Jehova Esowo ebahne kp-n kake nkahn lela, re wahn toono ntibi nyia, a atahm. Jo kunen ekpu, wahn jo bum atahm nyaa, a ntim ntim enyahne, a atohko atohko enyahne. ");
INSERT INTO eka_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Wahn ebbung gbul gbul gbuul lela re Jehova wo li Esowo ebahne, re ḿ bahke jo jen a ne , ḿ bahke jo bum ntibi enye, a nkahn go atahm enye, ḿ bahke jo wuk-e. ");
INSERT INTO eka_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","Jehova ebbung gbul gbul gbuul lela re, wahn ane ebe ba, ba a ma-n bum ka elne, ana á nyame no, re wahn bahke jo bum nkahn enye kpee. ");
INSERT INTO eka_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Yebbung gbul gbul gbuul re, á bahk-n mehle wahre, sehnge ajahbe kpee nya á ma lim, bo bahke jo tehk-n, jo ka-e elgahm a ekpunu. Fvfo ḿ bahke jolo ejahbe ji li saang ka Jehova Esowo ebahne, jang jang ana á nyame no. ");
INSERT INTO eka_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","<<Mosis a anebkul ba Isreel kehm kake ane elkahn re, <<Jo bumen nkahn nyia kpee nyi n kp-n kake lela. ");
INSERT INTO eka_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","Ngare nyi ḿ ma siiri Jodan song yel go ndi nyi Jehova Esowo ebahne kp-n kake, loon agburu atal, wahn fere kpeele. ");
INSERT INTO eka_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","Nyonen alum kpee nya ntahm nyia, go atal nyao, ngare nyi ḿ ma siiri song yel go ndi nyi Jehova Esowo ebahne kp-n kake, ndi nyi alahbbel a akehng ekon ma tv fad, jang jang ana Jehova Esowo babnso ewahne nyame no tong-n. ");
INSERT INTO eka_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","Ń lꞌsiiri Jodan, loon atal nyaa ewong Ebal wahn kpeele, ana n kp-n kake elkahn lela. ");
INSERT INTO eka_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","Limen egudu njom ji atal o ka Jehova Esowo ebahne. Kana ko ejum eltum ajehng ajehng ji bo limi go akuungu lim eltum o. ");
INSERT INTO eka_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","Limen egudu njom ji Jehova Esowo ebahne, go atal nya bo ki soongo na, wahn jo lim njom nyi eljahme fi o, ka Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","Jo limen njom nyi ayare, nya elkoono o, wahn jo li fere jo geere go esamahr bi Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","Ḿ bahke nyono alum kpee nya ntahm nyia gbul gbul gbuul, go atal nyao nya ḿ ma lo.>> ");
INSERT INTO eka_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","Owo Mosis a abalimajom, bo ji li anebe Levi, kehm bungu tong anebe Isreel kpee re, <<Wahn anebe Isreel, rahken ewok, wahn wuungu atung! Anv wahn ebjol ane ba Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","Jo kpunen Jehova Esowo ebahne, wahn fere jo toono nkahn a ntibi enye, nya n kp-n kake lela.>> ");
INSERT INTO eka_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","Efung bꞌnehm o, Mosis kehm kake anebe Isreel elkahn re. ");
INSERT INTO eka_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","Ngare nyi ḿ ma siiri Jodan, atꞌtohngo nyaa bahke yiimi go ewong ji Gerijim jo fuulu ane; Etꞌtohngo ji Simion, a ji Levi, a ji Juda, a ji Isaka, a ji Josef, go etꞌtohngo ji Benjamin. ");
INSERT INTO eka_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","Atꞌtohngo nyaa bahke yiimi go ewong Ebal jo su akuk; Etꞌtohngo ji Ruben, a ji Gad , ji Asa, a ji Jebulon, a ji Dan go ji Naftali. ");
INSERT INTO eka_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","Anebe Levi ba bahke gboko mbang jo bung ka anebe Isreel kpee wahre wahre re, ");
INSERT INTO eka_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","<<Nkuk li ka nne no rahme elok elom ji li esabsab ejum ka Jehova, rod jehke go edi elbiiri, ji li eltum ni anebe agbˈgbe.>> Owo ane kpee bahke faange re, << Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","Nkuk li ka nne no kil jo kpunu nde ewe, afi nnyehn ewe. Ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","Nkuk li ka nne no lˈrennge eltal go nseenga ndi nyi nnebjing ewe. Owo ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","Nkuk li ka nne no limi nwakamahr tan mbang. Ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","Nkuk li ka nne no ki lam elam go nseenge, ka nne ajahmjahm, afi nne no nde ma kpo, afi akalebun. Owo ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","Nkuk li ka nne no noonga nkala nde, tibre á kpunem edilnong nde ewe. Owo ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","Nkuk li ka nne no noonga nnyam anyehng anyehng. Owo ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","Nkuk li ka nne no noonga mmonannyehn no nkal, mmon no nkal no nde, afi mmon no nkal no nnyehn. Owo ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","Nkuk li ka nne no noonga nnyehn nkal ewe. Owo ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","Nkuk li ka nne no weele no wul nnebjing ebe. Owo ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","Nkuk li ka nne no ko ngu re a wul nnea mbol mbol. Owo ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","Nkuk li ka nne no kil jo yiimi go alum nya ntahm nyia, kꞌfere jo lim. Owo ane kpee bahke bungu re, <<Jol ano!>> ");
INSERT INTO eka_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","<<Ń lˈjo kpunu Jehova Esowo ebahne ngare kpe kpe, fere jo kunu ekpu jo toono nkahn enye kpee nyi n kp-n kake lela, Jehova Esowo ebahne bahk-n mehle wahre sehnge ajahbe kpee nya li go njini. ");
INSERT INTO eka_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","Nfuulu nyia kpee bahke bake go egahne fere jo toon-n, ń lꞌjo kpunu Jehova Esowo ebahne: ");
INSERT INTO eka_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","Jehova bahk-n fuulu go mfam, fere fuul-n go egahne ebgbe. ");
INSERT INTO eka_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","Abon ebahne bahke bele elfuulu, a nsol mbahmandi enyahne, a atohko ndi enyahne, abon efong ba nlong efong enyahne a abon ejoro ba nlong ejoro enyahne. ");
INSERT INTO eka_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","Jehova bahke fuulu ajeere nkohl enyahne, a agbojok abred enyahne. ");
INSERT INTO eka_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","Elfuulu bahke jolo anahne ń lˈlohng, fere tob jol anahne ń lˈfeere kehnge. ");
INSERT INTO eka_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","Jehova bahke limi re wahn jo ga anebekv ba bahke yiimi abohng anahne. Bo bahke lohngo ejang abehng ba yiimi abohng anahne, fere be yaame toono mbang na esehma. ");
INSERT INTO eka_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","Jehova bahke fuulu abuungu enyahne, a ejum ajehng ajehng ji ń lake abo re wahn lim. Jehova Esowo ebahne bahk-n fuulu go ndi nyi á kp-n kake. ");
INSERT INTO eka_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","Jehova bahke limi re wahn jol afuulu fuulu ane ebe, ana á nyame no ko nwongo, ń lˈfere jo bum nkahn nyi Jehova Esowo ebahne, fere jo jen jo kpun-e. ");
INSERT INTO eka_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","Owo ajahbe njini kpee bahke nyehne re bo kpo lung-n kpiida mbing nyi Jehova, bo fere jo fahl-n. ");
INSERT INTO eka_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","Jehova bahk-n kake afang gbˈgbal. Á bahk-n kake abon gbalee, go atohkondi gbˈgbal, fere tob ka-n nsol mbahmandi gbˈgbal, go ndi nyi á tiri no tong babnso ewahne ba nkul re á bahk-n kake. ");
INSERT INTO eka_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","Jehova bahke lennge elbung, etahk ekuuru nsol enye, tum elahb tv go egahna ndi ngare nyi nno, fere fuulu ntum abo enyahne kpee. Ḿ bahke jo bong ajahbe gbalee nsol, wo, wahn nehm jo bong goji nne awohng awohng ebo. ");
INSERT INTO eka_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","Jehova bahke limi re wahn jol esi, ń nehm jo jol elsil. Ń lˈjo wuungu atung go nkahn nyi Jehova Esowo ebahne, nya n kp-n tongo lela, fere jo kunu ekpu jo toono, ḿ bahke tiki jo jol agbokombang, ń nehm jol akahlenjahm. ");
INSERT INTO eka_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","Kana kane ellimi nkahn anyehng anyehng nyi n kp-n kake lela. Kana sennge bum go nkpe, jol go ejang ebobkal, afi go ejang eboblum. Kana toono esowo abehng abehng behko, jol kana loko bo. ");
INSERT INTO eka_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","Limi limi kan, ń tohko jo kpunu Jehova Esowo ebahne, fere jo kunu ekpu jo toono nkahn enye kpee, a ntibi nyi n kp-n kake lela, akuk nyaa kpee bahke gboko tub-n, fere ko-n elfono: ");
INSERT INTO eka_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","Ḿ bahke bele nkuk go mfam, fere bel nkuk go egahne ebgbe. ");
INSERT INTO eka_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","Á bahke suku ajeere nkohl enyahne, a agbojok abred enyahne. ");
INSERT INTO eka_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","Jehova bahke suku abon abahne, a nsol mbahmandi enyahne, a abon efong ebahne, a abon ejoro ebahne go abon ebul baange. ");
INSERT INTO eka_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","Jehova bahk-n suku, ń lˈjo feere kehnge, á bahk-n suku ń lˈlohng asongo. ");
INSERT INTO eka_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","Jehova bahke tumu akuk tv-n, a ebilamahr, fere sare agan go ejum ajehng ajehng ji ń lˈlak abo enyahne re wahn lim, tete á ranng-n, ń kpo tan tvtv. Jia bahke jolo ano tib go abˈbi nya ḿ ma lim eji ḿ me-e ten. ");
INSERT INTO eka_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","Jehova bahk-n tuubu ayam tete á ranng-n yehke go ndi nyi ń kpˈyele re wahn song ko. ");
INSERT INTO eka_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","Jehova bahk-n tuubu afubu ayam, arumbum, go afahl, á bahke tumu elum a efubfub elfeb re ba rannge mbahmandi enyahne. Mbaare nyi bake rannge nsol enyahne, bahke jolo anahne tete ń kpo tan. ");
INSERT INTO eka_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","Elbung go egahne esi bahke jolo ana abilikpi, eji elahb lˈkˈma kpe na, ndi nyi ń kun no jol ana ekuungu, ejumjum nehm ma kpe mahng o. ");
INSERT INTO eka_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","Jehova bahke limi re elahb ji bahke nake go egahne ejahbe fere siingi ebtohko a atong. Bahke jo na go elbung abake, tete ń kpo tan. ");
INSERT INTO eka_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","Jehova bahke limi re anebekv ebahne jo ga-n go ebta. Ḿ bahke lohngo go ejang abehng re wahn ba nok a bo, ḿ fere be yaame sehng mbang esehma. Ḿ bahke jolo emennge emennge ejum ka ajahbe kpee nya li go njini. ");
INSERT INTO eka_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","Akv enyahne bahke jolo nsol alehke ka nruk kpee nyi kpo fonngo go elbung, a enyam ekulegbe bi li go ndi, jol nnene nehm jol no bahke kame bo tv go. ");
INSERT INTO eka_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","Jehova bahk-n tuubu afahl nya jo yam anebe Ijib, atungu tungu, ngubjing bahk-n jolo akpakolo akpakolo, fere gbo akpake, jol ń nehm bel enobayam. ");
INSERT INTO eka_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","Jehova bahk-n bumu esahl, fere wa-n amahr, fere kak-n ebilamahr go eltim. ");
INSERT INTO eka_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","Ngare efin, ḿ bahke jo dam yannge ana nwakamahr go ejannge. Ejum ajehng ajehng ji ń limi no, nehm jo nob, efung abehng abehng, bo bahk-n jo nyede na tv, fere jo v nsol enyahne, jol nnene nehm jol no bahk-n tahre. ");
INSERT INTO eka_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","A bahke lame elbal re wo ko nnenkal, wo nne nondiki wo bahk-e fere bob, jo noongo a ne. A bahke sehke etahk jol a nehm lene. A bahke bahme egbe agreb, jol a nehm lub bom na elbongo akab enye. ");
INSERT INTO eka_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","Bo bahke wulu nlum a mfong enya ega esamahr, jol bo wa-a nehm ka re wo li. Bo bahk-a taare mbvankang enya go egban, jol bo nehm kpe feere a nyi. Bo bahke rodo ejoro eba, ka nnekv ewa, jol nnene nehm tahre bo. ");
INSERT INTO eka_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","Bo bahke rodo abon eba ba nlum, a ba nkal, ka go njahm ejahbe nyehko. A bahke jo kpur bo go mbang efung efung tete a lahng, jol eko a nehm bel ji á bahke ma yiimi abohng. ");
INSERT INTO eka_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","Ane ba a kii nyi bo bahke lehke nkpakandi enya a nsol abo ntum enya. Ejumjum a nehm bel, sehngem re bo bahk-a jo lim eblum, afung kpee nya elkpin ena. ");
INSERT INTO eka_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","Nsol nyi ḿ bahke jo nyehn go egahna amahr, bahk-n bumu esahl. ");
INSERT INTO eka_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","Jehova bahk-n tuubu afahl nya kpˈsahb yˈyam go alahng, a akpade jol nehm kpo, bahk-n limi bomo go adabkpade tete rehng go egahne elka esi. ");
INSERT INTO eka_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","Jehova bahk-n kame, a ntul no ń kun-e re á jo fil-n, tv go ejahbe ji ń kii nyi, jol babnso ewahne kii kahn. Owo ḿ bahke jo loko asowo nyako, asowo nti a nya atal. ");
INSERT INTO eka_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","Ḿ bahke jolo emennge ejum, a ejum enyok, a asol, ka ajahbe kpee nya Jehova bahk-n kame tv. ");
INSERT INTO eka_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","Ḿ bahke jo bahm amohk nti gbalee go egbe, wo ḿ bahke jo fv ntiil, tibre agohrobi bahke jo lˈli. ");
INSERT INTO eka_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","Ḿ bahke jo bahm ebgbe agreb, jol ń nehm jo fohko akab enye, afi jo wo amahm, tibre aroongo bahke jo lˈli. ");
INSERT INTO eka_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","Ḿ bahke bele nrahna oliv go egahne ajahbe kpee, wo akehng oliv ń nehm jo bel, tibre akab bahke jo kum anyod anyod. ");
INSERT INTO eka_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","Ḿ bahke bele abon ba nlum a ba nkal, wo bo nehm jo jol anahne, tibre bo bahke bobo bo ana aju ebta. ");
INSERT INTO eka_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","Nkpa agohrobi bahke lehke nti enyahne kpee, a nsol mbahmandi enyahne. ");
INSERT INTO eka_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","Anebe ajahmjahm ba lene go egahne ellong, bahke jo gbal go afang sehng-n, fere bel eko sehng-n. Wo wahn bahke sahb gbˈgbo ekpak, jol eko ń nehm bel. ");
INSERT INTO eka_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","Bo bahk-n jo bong nsol, wo bo nehm jo bong egahne. Bo ba bahke jolo asi, wahn jol nsil. ");
INSERT INTO eka_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","Akuk nyaa kpee bahke gboko tub-n. Bahk-n jo kam, fere kpir-n tete ń kpo tan, tibre ń kpunem Jehova Esowo ebahne, fere jo bum nkahn, a ntibi nyi á ka-n no. ");
INSERT INTO eka_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","Akuk nyaa bahke jolo elliingi a nkpokosi ka-n, a abon ebahne go njinanjini. ");
INSERT INTO eka_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","Tibre ń lokem Jehova Esowo ebahne go eyebatahng a elgeere go ngare nyi ń jolo go efel. ");
INSERT INTO eka_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","Fvfo, go ngara njal a ekorlahb, ngare nyi ń li ebunjuku a egburu ekpak, ḿ bahke jo loko anebekv ba Jehova tumu re bo ba nok anahne. Á bahk-n kake ebˈbini ekuungu go egahne amel tete á ranng-n. ");
INSERT INTO eka_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","Jehova bahke koko ejahbe ji lohng go ejang njini behko, re bo ba nok anahne, ana ekpi ji kpˈfooro na fooro abake, ejahbe ji ń lˈkˈjo wuk ebliki ebo. ");
INSERT INTO eka_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","Ane bao kpˈmennge go esamahr, jol bo kpehme kpunu ekˈkulu nne, jol mmonse kpehme fili bo ndon. ");
INSERT INTO eka_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","Bo bahke lehke abon atohkondi ebahne a nsol mbahmandi enyahne tete bo ranng-n. Bo nehm tahm erik nkohl, afi amahm mfemfe, afi akehng sa-n, jol abon efong ebahne afi ejoro, a ebul, tete bo ranng-n. ");
INSERT INTO eka_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","Bo bahke bake ebta, ba senng-n kak, kohk-n tv go egahne ejahbe tete atahntahn awahre wahre akahme nya ń si sennge mfam ejahbe, nya n kpo yehke ntir enyahne kunu gbo. Bo bahke ba sennge ajahbe kpee nya li ndi nyi Jehova Esowo ebahne kp-n kake. ");
INSERT INTO eka_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","Tib go erem bi anebekv ebahne bahk-n kake ngare nyi bo bahke sennge mfam ejahbe kak, ḿ bahke jo li abon ebahne. Ḿ bahke jo li agubjing nya abon ebahne, ba nlum a ba nkal ba Jehova Esowo ebahne ma-n ka. ");
INSERT INTO eka_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","Jol nne no ga naange eljini go egahne ellong, no ejum kpo fil-e ndon, mmonannyehn ewe w-e nehm fili ndon, afi nkal no kpo kor-e, afi abon ebe ba kpeka li elkpin, ");
INSERT INTO eka_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","á nehm ka nne awohng awohng ebo, nnyama ngubjing abon ebe, nyi á kpˈlehke. Nnyam nyio nyi nyi bahke jolo ejum alehke kpee, ji ye kpi no, tib go erem bi anebekv bahk-n kake ngare nyi bo bahke ba sennge ajahbe kpee kak, kohk-n tv. ");
INSERT INTO eka_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","Nnenkal no ga naange eljini kpee go egahne ellong, no ejum kpo fil-e ndon, ye ji lˈkˈma kadde ekpade eje tˈtahne go ndi, á bahke jo baare nlum we no kpo kor-e amahr, afi mmon ewe no nlum, afi no nkal, ");
INSERT INTO eka_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","nkpahde ejel enye, a abon ba á jele no. tibre á tiri re á weele wul bo li, tib go egburu erem bi anebekv kp-m kake eji bo ma sennge ejahbe kak fere kohk-n tv. ");
INSERT INTO eka_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","Ń tohko kunu ekpu, bum alum ntahm nyia kpee, nya bo nyono go nwer nyia, kˈfere jo kpunu mbing nyia nyi kpi ellub, fere mˈmennge, mbing a Jehova Esowo ebahne, ");
INSERT INTO eka_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","Jehova bahk-n tubu amennge ayam, a abangenahb enyahne, atong tong nya bahke jo ko ngare, fere jo sahb yam-n yam, a ariidi ayam, nya lˈkˈjo mal. ");
INSERT INTO eka_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","Á bahk-n tuubu ayame Ijib kpee, nya ń jo fahl, ano wo bahk-n laake. ");
INSERT INTO eka_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","Jehova bahk-n tob tuubu nkohn ayam kpee nya bo ki nyon nwera ntahm nyia a agburu atong tong tete ń kpo tan. ");
INSERT INTO eka_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","Wahn ji ruru na, ana alonlo nya li go elbung, ḿ bahke fere sa amohk ane abik abik, tibre ń kpunem Jehova Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","Ana jo yebe Jehova atahng re á lim-n wahn jol efel, fere jo nyab go nrur, ano wo eltim bahk-e jo yebe re á ranng-n fere demm-n. Bo bahk-n melle ana arahn nti, yehke go ndi nyi ń kpˈyele re wahn song ko fere jol nyˈnyahne. ");
INSERT INTO eka_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","Owo Jehova bahk-n kame faade kak ajahbe kpee, bomo go ejang njini ajehng rehng ajehko. Owo ḿ bahke jo kak asowo nyako, nya nti a nya atal nya wahn, afi babnso ewahne ki nyi. ");
INSERT INTO eka_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","Go ellong ajahbe nyao, erekekv ń nehm bel, jol ń nehm bel edi erekekv ji m bahke kadde akpade. O wo Jehova bahk-n kake egbiingi eltim, ḿ bahke jo seb re wahn nyehn ejum ji ń kpˈsebe, wo amahr enyahne nehm nyehn, fvfo ntim enyahne bahk-n woono. ");
INSERT INTO eka_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","Eltim bahk-n jo kahd ngare anyehng anyehng, fere jol elfahle elfahle atv a njul, ń nehm tiki jo kahn ana elkpin enahne li li. ");
INSERT INTO eka_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","Ngare efungfu, ḿ bahke jo bung re, \"Li re elgung eblub ba, elgung ḿ bahke bungu re li re efungfu eblub se, tib go amennge nsol nya bahk-n ruru go nltim a nsol nyi amahr enyahne bahke jo nyehn. ");
INSERT INTO eka_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","Jehova bahk-n tumu ń feere go Ijib go asohkkahng, go eljen ni m bungu re, ń nehm kpe tiki je. O wo ḿ bahke jo seb re wahn gungu elnahne ana aju nya nlum a ba nkal, ka anebekv ebahne, wo nnene wahn nehm gunu. ");
INSERT INTO eka_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","Awo li alum go ntoora nti nya egbanngalung ji Jehova limi ka Mosis elkahn re á lim a anebe Isreel go ejahbe Moab, budu a egbanngalung ji á tohko lim a anebe Isreel go Horeb. ");
INSERT INTO eka_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","Mosis kehm kuku anebe Isreel kpee, kehm tongo bo re, <<Wahn ebnyehn go egahne amahr nsol kpee nyi Jehova limi Fero go Ijib, a atubesi abalimeltum ebe kpee, a ndi enye kpee. ");
INSERT INTO eka_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","Ń nyehne go egahne amahr agburu ngaare, a agburu nliingi, a agburu akpokosi. ");
INSERT INTO eka_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","Wo ga, tete sik lela, Jehova wahn ka ka eltim ni ngbere, afi amahr nya kpo nyehn, jol atung nya elwuku. ");
INSERT INTO eka_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","Wo Jehova bungu re, <<Go nnya atahl abal nyi n rod-n sehng anahne go elka emahng, nsol ebjing enyahne alahb kpoom, jol akpaketa nya ń kake no go akpade jakem kpee. ");
INSERT INTO eka_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","Ebred ń liim, amahm ḿ woom, afi nkang amahm. N limi jia, eji ń lꞌkahn re me wo li Jehova Esowo ebahne.>> ");
INSERT INTO eka_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","Eji ń rehnge edi jia, Sihon ji jolo ntula Hesbon a Og ji jolo ntula Basan, bo lohngo ba re bo ba nok anahre, wo e gꞌga bo go ebta. ");
INSERT INTO eka_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","E taare ndia bo, rod ka anebe etꞌtohngo ji anebe Ruben a ji Gad, go ejang etꞌtohngo ji Manase, ana ejum elehkelkv. ");
INSERT INTO eka_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","Kunen ekpu, wahn toono agbak nya nwongo nyia, eji lꞌnob anahne, go ejum ajehng ajehng ji ń limi no. ");
INSERT INTO eka_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","Wahn ane kpee ń yim go esamahr bi Jehova Esowo ebahne lela. Atubesi ebahne, atubesi aneblum, anebkul ebahne, a atubesi abalimeltum, go aneblum Isreel bako kpee, ");
INSERT INTO eka_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","budu abon ebahne, a akal ebahne a ajahm jahm nya lene go egahne nsi erekekv, bo ji kpo rak nkun, fere jo tuk alahb ka-n. ");
INSERT INTO eka_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","Ń yim ana, eji ń lꞌko nwongo a Jehova Esowo ebahne, nwongo nyi Jehova yahke ko anahne lela, fere tir kak elliingi, ");
INSERT INTO eka_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","eji á lꞌtaame lela re wahn ane ebe ba, eji ye lꞌjol Esowo ebahne ana á nyame no tong-n, fere tir tong babnso ewahne, Ebraham, a Aesik go Jekob. ");
INSERT INTO eka_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","Wahn wahn sang Jehova kpˈkoko nwongo nyia a nahne, fere tir, ");
INSERT INTO eka_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","wahn ji yim a anahre lela, go esamahr bi Jehova Esowo ebahre, wo Jehova kpꞌtob ko a ane ba ki li a lela. ");
INSERT INTO eka_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","Wahnfono antahng kpꞌkahne ana e lene no go Ijib, fere kahn ana e sehnge ajahbe nyako sa, ba rehng a. ");
INSERT INTO eka_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","Ń nyehne asabsab alokelom go ebo ellong, a asowo nya bo ko nti lim, a nya bo ko atal lim, nya asilva, a nya agul. ");
INSERT INTO eka_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","Seben kahn re nnenlum limm afi nnenkal, esi ejahbe, afi etꞌtohngo go egahne ellong lela, no ma sennge fere yehke eltim ene goji Jehova Esowo ebahre re á jo song kak asowo nya ajahbe nyao. Seben kahn re, jol nlohk anyehng anyehng limm go egahne ellong nyi kpo kab alul lul afa ana nyaa. ");
INSERT INTO eka_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","Elkohn nne ana noo lꞌwuk alum nwongo nyaa, á lꞌkak ero jo biri elfuulu tv elne fere tir re, \"M bahke jolo go edi elforo, jol afi n soro asi jo toono abang enyame\", á bahke koko egburu elrannge ba go ndi nyi li alahb alahb, a nyi li wumwum. ");
INSERT INTO eka_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","Jehova nehm tiki seb re á tahm ka bo. Erakatahng a elkahra akpuku ene bahke gboko tub bo. Akuk kpee nya bo nyono kak nwer nyia bahke gboko tub bo. Jehova bahke fvvdv abing ebo yehke go njini. ");
INSERT INTO eka_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","Jehova bahke jake bo yehke go ellong atꞌtohngo nya Isreel kpee re bo nyehn ebi erem bio, ana nkuk anyehng anyehng nyi nwongo nyi bo nyono go Nwer nyia nyi Ntahm li no ");
INSERT INTO eka_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","Abon ebahne ba bo bahke jele bo, toon-n eying jehko, a ajahmjahm nya lohng go fee ba, bahke nyehne atongtong nya ma gbo tub ejahbe ejahne, a ayam nya Jehova ma tub bo. ");
INSERT INTO eka_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","Ndi kpee bahke rannge ana ndi akang a asolfo, ejumjum bo nehm ma bahm, ejumjum nehm ma mahng, jol ejumjum nehm ma gbal o. Bahke jolo ana bo rannge Sodom a Gomora, Adˈma abola Jeboyim, ajahbe nyao nya Jehova rannge no go ege egburu erakaktahng. ");
INSERT INTO eka_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","Ajahbe kpee bahke jo bahb re, <<Jenji wahnge Jehova ma lim ejum jia go ndi nyia?>> Jenji wahnge egburu erakatahg eje ma maange anae? ");
INSERT INTO eka_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","Owo bo bahke faange re, <<Ebjol ano tibre ane baa senng-e njahm, ten nwongo nyi Jehova ji li Esowo bi babnde ebo, nyi á ko a bo eji á yehke bo go ndi nyi Ijib. ");
INSERT INTO eka_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","Bo tahme fere song kehme asowo nyako kak, fere jo gong kak bo, asowo nya bo ki nyi, nya Jehova ki ka bo. ");
INSERT INTO eka_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","Ano wo wahnge Jehova eltim kehm-e rake gbalee bada ndi nyia. Owo wahnge a kehm suku bo akuk kpee nya bo nyono go nwer nyia. ");
INSERT INTO eka_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","Ana eltim maang-e no, a egburu erakatahng, Jehova melle bo ana arahnti go eboa ndi, fere song ro bo kak go ndi nyindiki, ana li no anv. ");
INSERT INTO eka_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","Nsol nyi li mbehr mbehr, li ka Jehova Esowo ebahre, wo nsol nyio nyi bo ma lennge, li ka wahr a abon abon ebahre go njinanjini, eji e lꞌtoono alum kpee nya ntahm nyia. ");
INSERT INTO eka_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","<<Ngare nyi nfuulu nyia, a akuk nyaa kpee, nya m ma lennge ka-n, lˈgbo tub-n go edi ajehng ajehng ji Jehova ma-n kam kak ajahbe nyako, n lˈ buumu go egahna ntim. ");
INSERT INTO eka_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","Ń lꞌfeere goji Jehova a abon ebahne fere kpun-e a ntim a ntim enyahne, a atohko atohko enyahne jang jang ana n ka-n elkahn lela, ");
INSERT INTO eka_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","owo Jehova Esowo ebahne bahke feere efa ebahne ka-n. Ḿ bahk-e fili ndon, á fere ku-n yehke go ajahbe nya á kam-n no kak, ń fere egahna ndi. ");
INSERT INTO eka_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Jol afi bo kam-n tv go ejahbe ji li go ejang njini ji ga lab, Jehova Esowo ebahne bahk-n kuku o, feere go egahna ndi. ");
INSERT INTO eka_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","Á bahke feere anahne ba go ndi nyi babnso ewahne, ḿ bahke koko ndi nyio fere jol nyˈnyahne. Á bahk-n limi ń sahb gbˈgbo afang, fere rˈrur sehnge babnso ewahne. ");
INSERT INTO eka_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Jehova Esowo ebahne bahke limi ntim enyahne a ntim nyi abon ebahne bo jo wuk-e, eji ye, lꞌjo kor-n, a ntim a ntim enyahne kpee, a atohko atohko enyahne kpee, eji ń lꞌkpin. ");
INSERT INTO eka_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Jehova Esowo ebahne bahke rodo akuk nyao kpee kunu anebekv ebahne, bao ba kpo ko-n ekv, fere jo gbak-n. ");
INSERT INTO eka_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Ḿ bahke kpe kehme Jehova kpunu, fere jo toono nkahn enye kpee nya n kp-n kake lela. ");
INSERT INTO eka_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Owo Jehova Esowo ebahne bahke limi re wahn sahb gbˈgbo afang go egahne abo ntum kpee, a abon bahne, a atohkondi enyahne, fvfo nkpakandi enyahne bahke gbale budu. Jehova eltim bahk-e kpe yebe bade anahne, a fere lim re wahn gbo afang, ana eltim yeb-e tob babnso ewahne, ");
INSERT INTO eka_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","ń lꞌfere jo wuk Jehova Esowo ebahne, fere jo bum nkahn enye, a ntibi nyi bo ma nyon go Nwer nyia nyi Atahm, fere feere goji Jehova Esowo ebahne, a ntim a ntim enyahne kpee. ");
INSERT INTO eka_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","<<Elkahn ni n kp-n kake anv lela nehm ga riidi sehng-n, jol lim na fee ji ń lꞌkꞌma rehng. ");
INSERT INTO eka_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","Limm na go elbung, ji ḿ bahke bahbe re, <<Nne awoo bahke wahre tahm go elbung song ko, feere ba tiing-r eji e lꞌkpunu? ");
INSERT INTO eka_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","Jol lim na go egbuk aya jehko, ji ḿ bahke bahbe re, \"Nne awoo bahke siiri agburu aya song ko ba tiing-r, eji e lꞌkpunu? ");
INSERT INTO eka_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Eꞌee, ellum nio li-n kpidi kpidi. Wob-n go egahna nnyo a ntim enyahne, eji ń lꞌkpunu. ");
INSERT INTO eka_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","Nyehne! Lela me n rod elkpin a afang bum-n go egahne esamahr, fere tob bum-n elkv a elrannge. ");
INSERT INTO eka_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Anv lela, m ma-n ka elkahn re, Jehova Esowo ebahne jo kor-n. Jo jenen wahn jo kpun-e, fere jo bum nkahn enye, a ntibi enye, a atahm enye, ano wo ḿ bahke kpini fere nyab, fvfo Jehova Esowo ebahne bahk-n fuulu go ndi nyi ń kpꞌyele re wahn song ko jol nyˈnyahne. ");
INSERT INTO eka_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Wo ntim enyahne lꞌfere sennge go, ń kꞌjo kpun-e, ń lꞌfere yehke ntir enyahne tv go re wahn jo gong kak asowo nyako, fere jo loko bo. ");
INSERT INTO eka_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","N kpꞌlennge tong-n lela re bo bahk-n lohko rannge. Ń nehm ga kang go ndi nyi ń kpꞌsiiri aya Jodan song yel re wahn ko. ");
INSERT INTO eka_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","Lela n kpꞌlungu elbung a ndi re yiim-m ntianse bade anahne, me n rod elkpin a elkv, go elfuulu a nkuk bum-n go egahne esamahr. Anv yehken elkpin, eji wahn a abon ebahne ń lꞌkpin. ");
INSERT INTO eka_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","Nong Jehova Esowo ebahne jo kor-n, wahn jo wuungu atung go ellum ene, fere gbo-e ejahm tꞌtahne. Tibre Jehova wo li elkpin enahne. Á bahk-n kake aya gbalee, go ndi nyi á tiri no re á bahke kake babnso ewahne, Ebraham, Aesik a Jekob. ");
INSERT INTO eka_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Owo Mosis kehm tahme song bung alum nyaa kpee tong anebe Isreel re, ");
INSERT INTO eka_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","<<Anv me n kang nnya atahl arakera. Me wahn nehm ma kpe gbo bang asongo. Jehova ma-m tong re, ˈÁ nehm siiri aya ma Jodan.ˈ ");
INSERT INTO eka_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Yefono Jehova Esowo ebahne wo bahk-n gboko mbang song siiri aya mao. Á bahke song rannge ajahbe nyao go egahne esamahr. Ń bahke song ko ndia bo, fere jol nyˈnyahne. Josua bahke tob gbo-n mbang song siiri, ana Jehova bungu no. ");
INSERT INTO eka_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Jehova bahke limi bo, ana á limi Sihon abola Og, atul ba anebe Amor, bo ji á rannge bo a ajahbe ebo. ");
INSERT INTO eka_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Jehova bahke yake bo kak-n go ebo. Ḿ bahke tiki lim bo nsol kpee ana m ma-n ka elkahn re wahn lim. ");
INSERT INTO eka_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Belen atahne a ekakelltim. Kana fahl bo. Jol bo ki-n mennge, tibre Jehova Esowo ebahne kpꞌjene anahne. Á wahn nehm tiki yake, jol á wahn nehm ten.>> ");
INSERT INTO eka_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Owo Mosis kehm tumu bo lung Josua, kehm-e tongo go ellong anebe Isreel kpee re, <<Bel atahne a ekakeltim. Tibre á bahke tiki rod ane baa tahm abo go ndi nyi Jehova tiri tong babnde ba nkul re, á bahke kake bo. Wo wo bahke tiki bak bo ndi nyio ana ejum elehkelkv ebo. ");
INSERT INTO eka_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Yefono Jehova kp-n gboko mbang asongo. Á bahke jolo anahne; á wahn nehm tiki yake, jol á wahn nehm ten. Ka bel elfahle, jol eltim ki-a woono. ");
INSERT INTO eka_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Mosis kehm nyono ntahm nyia, kehm faake ka anebe Levi ba li abalimajom, bo ji kpo sol elkohl egbanngalung ji Jehova, fvfo jolo ka anebkul ba Isreel kpee. ");
INSERT INTO eka_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","Owo Mosis kehm kake bo elkahn re, <<Eji nnya esehma anyehng anyehng ma biingi, go elya nio ni ane kpo yake abong ka, go ngare Elkak Abonkpatahk, ");
INSERT INTO eka_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","ngare nyi anebe Isreel kpee ma ba yiimi go esamahr bi Jehova Esowo ebahne, gona edi jio ji á bahke yehke, a bahke lungu atahm nyaa eji bo lꞌwuk. ");
INSERT INTO eka_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Ku ane kpee bo ba kono asi, aneblum a anebkal, abonse, go ajahmjahm nya lene go egahna mfam ejahbe bo ane kpee, eji bo lˈwuk fere kpili ana bo bahke jo fahl Jehova Esowo ebahne, fere kunu ekpu jo toono alum kpee nya ntahm nyia. ");
INSERT INTO eka_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Abon ebo ba ki nyi ntahm nyia bahke wuku, eji bo lꞌkpili ana bo bahke jo fahl Jehova Esowo ebahne go ngare kpee nyi ń lene go ndi nyio nyi ń kpꞌsiiri Jodan re wahn song ko. ");
INSERT INTO eka_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Owo Jehova kehm bungu tong Mosis re, <<Efung bi a bahke kpoko ebkabbe. Lung Josua, wahn ba go ebkpatahk bi elwane, edi ji m bahk-e fake nnyo. Mosis a Josua kehm song yiimi go Mbuksong Ebkpatahk bi Elwane. ");
INSERT INTO eka_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","Owo Jehova kehm bake go ebkpatahk. Á ba go ekparesemsem. Ano wo ekparesemsem yiimi no, go ero mbutahk mi ebkpatahk bio. ");
INSERT INTO eka_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Jehova kehm bungu tong Mosis re, <<A bahke kpoko, tahm goji babnso ba nkul. Ane baa bahke gulu asꞌsa jen, bo bahke jo toono ajen asowo nya ajahbe nya bo kpꞌyele. Bo bahk-m tene, fere range nwongo nyi n ko a bo. ");
INSERT INTO eka_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Efung bio, m bahke rake eltim a bo, fere ten bo. M bahke fake esamahr ebame go nkpe, bo bahke rannge bo. Agburu atongtong gbalee a ajahkjahk nsol bahke gboko tub bo. Fvfo efung bio bo bahke jo bahb re, <<Anv, eji atongtong ana nyaa kpꞌgboko tub-r, jia nehme tib re Esowo limm anahra? ");
INSERT INTO eka_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","M bahke yehke esamahr ebame go ebo ejang, tib go abꞌbi ebo kpee nya bo kpꞌlimi eji bo ma sennge kpꞌfere toono asowo nyako. ");
INSERT INTO eka_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","Anv nyon ese jia, wo fere tib anebe Isreel, bo jo yim. Eji ese jꞌnehm lꞌyiim-m ntianse bada bo. ");
INSERT INTO eka_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Ngare nyi n ma koko bo ba yel go ndi nyi alahbbel a akehng ekon kpˈfabe, nyi n nyame no, fere tir tong babnde ebo, ngare nyi bo ma li wohngo, fere jo gbal, bo bahke sennge, fere jo kak asowo nyako. Bo bahk-m tene fere range nwongo enyame. ");
INSERT INTO eka_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","Ngare nyi agburu atongtong a ajahkjahk nsol ma lim bo, ese jia bahke yiimi ntianse bada bo, tibre atˈtohngo ebo nehm yini. N kpꞌkahne ji li go ebo eltim re bo lim, jol tvtv re me n kehm koko bo ba ndi nyi n nyame tong bo fere tir. ");
INSERT INTO eka_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","Owo Mosis kehm nyono ese jia efung bio fere tib anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Jehova kehm kake Josua mmona Nun elkahn nia re, <<Bel atahne, wo bel ekakeltim. Tibre a bahke koko anebe Isreel ba go ndi nyi n nyame no, fere tir re m bahke kake bo. Mefono antahng m bahke jolo a na. ");
INSERT INTO eka_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Eji Mosis ma nyon alum atahm nyaa kpee kak go nwer mal, bomo mbomo tete rehng esˈkohlo, ");
INSERT INTO eka_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","á kehm kake anebe etꞌtohngo ji Levi ba kpo sol elkohl atahm ni nwongo Jehova elkahn nia re, ");
INSERT INTO eka_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","<<Koon Nwer Atahm nyia, wahn bum go nkpe elkohl ni Nwongo nyi Jehova Esowo ebahne. O, wo bahke jolo ntianse bada nahne. ");
INSERT INTO eka_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Tibre n kpꞌkahne re ń li atahnsi ane ba kil jo wuk nyi etung. Lꞌjol re wahn ebtahne asi a Jehova ngare nyi me n kpeka li anahne go elkpin, lꞌlim rejen n lꞌgohro kpo tahm.>> ");
INSERT INTO eka_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","Kuun anebkul ba atꞌtohngo enyahne kpee, a atubesi abalimeltum, ba go egame, eji n lꞌbung alum nyaa kak go ebo atung. ");
INSERT INTO eka_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","Tibre n kpꞌkahne re n lꞌkpo tahm, ḿ bahke rannge abang enyahne, fere sennge njahm go mbang nyi n ka-n elkahn. Go afung nya kpꞌbake, egburu ntong bahk-n limi, tibre ḿ bahke jo lim abꞌbi go esamahr bi Jehova. M bahke jo ka-e erakeltim tib go nsol nyi abo enyahne ma lim. ");
INSERT INTO eka_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Mosis kehm bungu alum ese jia tong nkon nyi anebe Isreel kpee, bomo go mbomo tete rehng go esꞌkohlo. ");
INSERT INTO eka_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","<<Wuungen atung wahn elbung, n yahke bung, wuken wahn, ndi, alum nnyo emame. ");
INSERT INTO eka_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","Nong eltibi ename jo na ana elahb, fvfo alum nnyo enyame ana ebohng, ana mmolahb no nyeme wohngo ajele, ana egburu elahb kpˈnake wohngo abon arahn nti. ");
INSERT INTO eka_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","M bahke tooro bada mbing nyi Jehova. Kaan Esowo ebahre agburu agbal. ");
INSERT INTO eka_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","Ye wo li Ekpartal. Ntum enye li go nseenga nseenge, abang enye kpee li go etingitingi. Esowo bi kpi ekakesehk, ye ji kil jo lim ebi, á li go nseenga nseenge a li go etingitingi. ");
INSERT INTO eka_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","Bobrannge, fvfo bo kpeem li abon ebe; Esono limm a bo, fvfo bo li eying ji li galle galle galle. ");
INSERT INTO eka_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","Wahn agboolo ane ba ki kpi ngbere, anv mbang nyi a, nyi ń kpꞌsebe re wahn feere kpi Jehovaa? Ye sang li Nso ewahna, ji gun-n noa, ye ji lim-n no, fere lim-n re wahn jol ejahba? ");
INSERT INTO eka_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","Buumen afung nya mahne mahne. Tiren bada aying nya jolo mahne mahne. Bahb nso ewa, á bahk-a tongo; bahb anebkul ebahne, bo bahke lennge tong-n. ");
INSERT INTO eka_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","Ngare nyi Esowo bi Gbale sehng jo bak ajahbe nsol elehkelkv ebo, ngare nyi á yabe ane, á jo kake nseenga ndi ka ane, ana nfange nyi abon ba Isreel jolo no, baben anebkul bo bahke lennge tongen ");
INSERT INTO eka_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","Tibre ane ebe ba li ejang mbake nyi Jehova. Jekob wo jolo ejum elehkelkv ji Jehova. ");
INSERT INTO eka_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","Á ting-e go emahng ji ajele ki li, go ndi nyi li nehme nehme, ndia mbol mbol. Á konng-e ana ekum, fere kpur-e, Jehova jo baab-e ana mon nehm nehm elmahr ene, ");
INSERT INTO eka_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","ana ekpi ji kpˈtibi abon ebe ana bo bahke jo fonngo, fere jo babbe sennge abon ebe kak. Ye ji kp'solo bo ege akpungkpung re bo k'gbo, fere jo fili bo go ege anyaange. ");
INSERT INTO eka_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","Jehova antahng wo jo tv-e. Jol njen esowo jolem a Jekob. ");
INSERT INTO eka_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","Á lim-e re á jo fonngo go awahre wahre adi nya ndi, fere jo ko akab nti nya egbe jo le-e. Á ka-e elfo nio ni akehng ekon ma akpartal, a akehng ma lohng ekpartal ji ma bahnge, ");
INSERT INTO eka_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","Á ka-e alahbbel efong ma ma kang, a alahbbel nfenfe ma ejoro a ebul; Á le-e a abon ejoro a ebul; a ekom bi nno a nno bi Basan, a amohk awid nya ga nob, a woo amahme greb ma jo tub nfahl, ma bili ana alung. ");
INSERT INTO eka_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","Anebe Jehova ba kpˈjene go nseenge kehm gboko afang fere jok. Eji bo wohngo no, bo kehm lubu go ngubjing fere jol yanng. Bo tahme Esowo bi lim-e bo sa, fere ten Ekpartal ji li ntꞌtahra abo. ");
INSERT INTO eka_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Bo ko ajen asowo ebo jo lim-e re á jo kpu elkahre, fere jo ko asabsab alokelom ebo jo ka-e erakatahng. ");
INSERT INTO eka_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Bo jo fuulu ajom ka asowo, bi ki li Esowo, asowo nya bo ki nyi, asowo nya kpehna lohngo ba, asowo nya babnso ewahne ki jo fahl. ");
INSERT INTO eka_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Ń tahme Ekpartal sa, ye ji jolo nso ewahne, ń yini Esowo bi jel-n no. ");
INSERT INTO eka_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","Jehova nyehne kan ano, á kehm tene bo, tibre abon ebe ba nlum, a ba nkal ka-e erakatahng. ");
INSERT INTO eka_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Á kehm bungu re, <<M bahke behre bo esamahr ebame, nyehn ana esˈkohro ebo bahke jolo. Tibre bo li eying ji kpˈtahne asi, bo li ebon ba ki kpi ekakesehk. ");
INSERT INTO eka_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Bo ko nsol nyi ki li esowo jo lim-m re me n jo kpu elkahre, fere ko alokelom ebo jo ka-m arakatahng. M bahke koko ane ba ki li ejumjum lim, re bo bel eteelala. M bahke koko ejahbe ji ki kpi ngbere, ka bo erakatahng. ");
INSERT INTO eka_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Tibre erakatahng ejame bahke kimi ellulu, agun nyao bahke lulu rehng go nnahbandi nyi ejahbe akvnne. Bahke lulu ndi a akab enye, fere lul abangenahb akahme nya awong. ");
INSERT INTO eka_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","<<M bahke kunu bo agburu atongtong go esi, fere ta mban enyame kpee tv bo. ");
INSERT INTO eka_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","M bahke tumu egburu njal tv bo, m bahke tumu abi ayam tv bo a ayam elkv; M bahke tumu nlong abˈbi enyam a enyo bi kpi afa bi kpo tohng ndi. ");
INSERT INTO eka_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","Ekahngkahng bahke wulu abon ebo go afak mbang, bo bahke jolo go egburu elfahle go ebo a ntahk. Ajangkun a agbahme bahke kpoko tan, ano wo abon mbili a akꞌkulu ane bahke tob kpo. ");
INSERT INTO eka_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","M bungu re, m bahke kame bo faade fere fvvdv mbinga bo go ellong ane, ");
INSERT INTO eka_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","wo gana n fahle enyok bi anebekv, eji anebekv lˈkˈkahn bung re, abo enyahre nya ma-r ka esehnge ebta. Jehova sang ma lim nsol nyia kpee.ˈ \" ");
INSERT INTO eka_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","Bo li ejahbe ji ki kpi ekahnafem, jol ngbere bo kpimm. ");
INSERT INTO eka_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Jol-m koro re bo jol bange, fere bel ngbere a ekahnafem, bade ana esˈkohlo ebo bahke jolo! ");
INSERT INTO eka_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","Anv, bahke limi renan, nne awohng kehm ma kam ane atahltahl nkpel ebal atahl awubu, afi ane abal fere kam ane atahltahl nkpel ewubu, tohko jol re Ekpartal ji ma gungu bo. Afi Jehova wo ma yake bo? ");
INSERT INTO eka_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Tibre ekpartal ebo limm ana Ekpartal jˈjahre. Bofono anebekv ebahre kpꞌtaame ano. ");
INSERT INTO eka_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","Agreb ebo lohng go elrahn agreb ni Sodom, tob lohng go egbe ji Gomora. Akab egreb ebo li afa afa, atasok ebo kp'lulu. ");
INSERT INTO eka_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","Amahm ebo, afa nya nnyo nya, afa nya ebgbodo, nya kpo wul. ");
INSERT INTO eka_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","<<Anv, me sang kuuru nsol nyia buma, fere behr go edi nsol akuuru ejama? ");
INSERT INTO eka_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Me wo li mbꞌbongo, m bahke bongo. Ngare lꞌbiingi, bo bahke roongo go akpade, efung ntong ebo ebkabbe, elrannge kpꞌbake ka bo ana nfehre alahb.>> ");
INSERT INTO eka_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","Jehova bahke foro ane ebe yake, á bahke beke alokeltum ebe ndon, á lꞌsi nyehn re eko ebtan bo, fere nyehn re nnene beem for jolo nju afi nne no ma for. ");
INSERT INTO eka_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","Á bahke bahbe re, <<Anv asowo ebo nya na? Akpartal nya bo jo be biiri nya na? ");
INSERT INTO eka_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","asowo nyao nya jo li afom enyam nya ajomjom ebo, fere jo wo amahm ma ayare amahm ebo. Nong bo mehl yiimi tob-n, nong bo ka-n edilkang. ");
INSERT INTO eka_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","Nyehnen anv, me wo li Esowo! esowo bindiki go kpeem li, buda name. Me n kpo wul, fere ka elkpin, me n kpo yehke nne alok, fere lim kpo. Nnene limm no bahke ma tahre nne yehke go egame ebo. ");
INSERT INTO eka_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","Me n tab abo enyame ton go elbung, fere tir tˈtahne re, etingitingi ana me n li no go njinanjini, ");
INSERT INTO eka_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","n lꞌsi bꞌbange nnyane nyane ekahngkahng ebame, fere rod fili re me n lam elam, m bahke bongo anebe ejahng ebame, m bahke kpiki ane ba n kpo sab bo. ");
INSERT INTO eka_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","M bahke limi re atake mban enyame leele alung alung, wo ekahngkahng ebame bahke lehke agubjing ebo, fere wo alung ane ba bo ma wul, a ane ba bo ma bob go ebta, bahke tob li asi nya atubesi anebekv. ");
INSERT INTO eka_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","Ajahbe Wahn, geeren a ane ba Jehova, tibre á bahke bongo ane, tib go alung ma alokeltum ebe. Á bahke bongo anebekv ebe, fere gongo ndi enye a ane ebe. ");
INSERT INTO eka_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","Owo Mosis kehm bake, a Josua ji mmona Nun, kehm ba bung alum ese nyaa kpee tong ane. ");
INSERT INTO eka_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","Eji Mosis ma bung alum ese nyaa ka anebe Isreel kpee, ");
INSERT INTO eka_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","Á tongo bo re, \"Roden alum nyaa kpee nya m ma lennge tˈtahne tong-n lela kak go egahna ntim, eji ń lꞌka abon ebahne elkahn, re bo jo kunu ekpu, jo kpunu alum atahm nyaa kpee. ");
INSERT INTO eka_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","Alum nyaa, alum mbol mbol sang ka wahn, nya nya li elkpin enahne, nya nya m bahke koko lim afung elkpin enyahne lab, go ndi nyi ń kpꞌsiiri Jodan re wahn song ko fere jol nyˈnyahne. ");
INSERT INTO eka_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Efung bꞌnehm o, Jehova kehm bungu tong Mosis re, ");
INSERT INTO eka_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","<<Wahr song, go elkudu ni Abarim, wo song go ero ewong ji Nebo ji li go Moab, go egbuk Jeriko jehko, wo seenge nyehn ndia Kenan, ndi nyio nyi n kpꞌkake anebe Isreel ana ejum elehkelkv ebo. ");
INSERT INTO eka_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","Go ewong jio ji a bahke wahre, o wo a bahke kpoko tahm eji ane eba, ana Eron mmonanne kpo no go ewong ji Hor. Tahm goji ane ebe ");
INSERT INTO eka_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","Jia li ano, tib go nsoodo nyi ń sood-m no, go elkab ni anebe Isreel, go alahb ma Meriba ji li go Kadesi, go emahng ji Jin, ḿ m-e kpunem ana n li saang go ellong anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","Fvfo, a bahke sake nyehn ndi nyio go fee, wofono nehm yel go ndi nyio nyi n kp'kake anebe Isreel.>> ");
INSERT INTO eka_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","Elfuulu ni a, ni Mosis nne Esowo biri tv anebe Isreel kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","Á bungu re, Jehova lohngo go ewong Sinayi ba, kehm sake go Siya ya ellennge tub bo. Ano wo á ya no go ewong ji Paran abake. Jehova lohngo go ejang eboblum mfam ba, go ege egbunggbung ewong, a ellong enjel atahl aku akuu enye ba jolo a ne, a agun nya jo lul go ejang eboblum ebe. ");
INSERT INTO eka_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","Bo kp'toono ariidi akpade enya. Etingitingi ji re wo wo ane kor-a no, abarebare ane kpee, wob-a go abo. Go ega akpade wo bo kpee kpo gong go ndi, fere ko elle go ega, ");
INSERT INTO eka_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","Nyia nyi li ntahm nyi Mosis ka-r no, nyi sahb l'li ejum ekpunu ji et'tohngo ji Jekob ma bel. ");
INSERT INTO eka_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","Á jolo ntul no anebe Isreel, ngare nyi atubesi ane ba kono edi ajehng, a atꞌtohngo nya Isreel. ");
INSERT INTO eka_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","<<Nong Ruben lub kpin na, á kꞌkpo, jol ane ebe kꞌjol ntiil.>> ");
INSERT INTO eka_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","Ejum ji a ji á bungu no bada Juda; Jehova wuk eling bi Juda; wo ko-e ba goji ane ebe. Juda kpꞌkoko abo enye antahng jo nok ka elne. Jehova tob-e nok a anebe ejahng ebe! ");
INSERT INTO eka_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","Bada et'tohngo ji Levi, á bungu re, <<Nsol elfaange atubu enya, nya bo kpo lung re Tumim abola Urim li ka nkakesehka nlokeltum ewa. A wuung-e go Massa; fere nok a ne go nkpe alahb ma Meriba. ");
INSERT INTO eka_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","A bungu bade nde a nnyehn re, <Bo me-e nehme lub.> Á liingem abonanyehn ba nlum jol abon ebe á kahnem bo. Wo á kpo baabe alum enya, fere jo kunu amahr go nwongo enya. ");
INSERT INTO eka_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","Bo kpo tib Jekob ajehke enya, fere tib Isreel atahm enya. Bo kpo lim ajom nya insen go ega esamahr, fere lim njom nyi bo kpo jahm fi kpee go ega egudu njom. ");
INSERT INTO eka_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","Jehova lub fuulu agbꞌgbe enye kpee. Nong eltum abo enye jo kor-a. Rum ane ba kp'mehle abohng a ne tub ndi. Raade anebekv ebe bo k'kpe mehl abohng. ");
INSERT INTO eka_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","Bada et'tohngo ji Benjamin, á bungu re, <<Nong akor-m ji Jehova bel erekekv ji lohng go elbaabe ni Jehova. Tibre á kpo konng-e ekum efung kpe kpe. Nong nne noo no kpo kor Jehova kuumu soom, go akpakebahk nya Jehova. ");
INSERT INTO eka_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","Bada et'tohngo ji Josef, á bungu re, <<Nong Jehova ko ebohng bi nno a nno bi kpo na elbung fuulu ndi abo, a alahb ma wob go nla ndi; ");
INSERT INTO eka_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","Nong ndia bo bel elfuulu ni akab nti nya njul ma lim ma bil, fvfo bahke bele akab nti nya nno nnyahng amehng amehng; ");
INSERT INTO eka_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","Nong nti nyi li agburu awong ebo nya mahne mahne nya bo yehke no tokko akab, a nlak nyio nyi awong nya li njinanjini; ");
INSERT INTO eka_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","Nong anoobo nsol rur eboa ndi, elfuulu ni nnoobo nyi Jehova, ye ji bungu alum go ekulegbe ji jo lul agun. Nong nsol nyia kpee gbo kuumu et'tohngo ji Josef. Tibre á jolo ntubesi, go ellong abonanyehn. ");
INSERT INTO eka_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","Go atahne, á li ana ngbokambanga mmona mfong no nlum. Á kpi atang nya mfong nkul. Nyanya á bahke koko jamme ajahbe, afi fere jolo go ejang njini jehko. Ano wo ane atahltahl nkpel ewubu ba Efriim li no, ano wo ane atahla nku aku ba Manase li no. ");
INSERT INTO eka_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","Bada et'tohngo ji Jebulon, a ji Isaka á bungu re, <<Jebulon, jo geeren go egahne ellohngo ni ń kpꞌlohngo. Fvfo nong et'tohngo ji Isaka tob geere go ege abonkpatahk. ");
INSERT INTO eka_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","Bo bahke jo ku ane ba atˈtohngo nyako tahm go awong, wo owo bo bahke song lim ajomjom nya atingi ane; Bo bahke koko anobo nobo nsol go agburu aya jo le elbonya ma, jo le elbo, a atingi nsol afang nya bo behre go erikendi.>> ");
INSERT INTO eka_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","Bada etˈtohngo ji Gad, á bungu re, <<Eltehke ELFUULU jol ka Jehova, ye ji bahke limi re ndi nyi Gad nyanye, Gad lene o ana Egabe, ji kp'jaake abo afi esi ji nnyam anyehng anyehng nyi jene kabb-e. ");
INSERT INTO eka_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","Ka anebe Isreel, á yehke edi ndi ji ga nob ka anebe Isreel. Bo bum-e erohko ndi ji li ka ntubesi. Eji atubesi ane wane no, á limi nnooba ntoobo nyi Jehova, a elam ji Jehova toobo no bada anebe Isreel.>> ");
INSERT INTO eka_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","Bada etˈtohngo Dan, á bungu re, <<Dan mmon egabe wo, no kpꞌyehbe lohng go Basan. ");
INSERT INTO eka_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","Bade etˈtohngo Naftali, á bungu re, <<Nnoobo nyi Jehova kpꞌgbale asongo asongo ka Naftali. Jehova me-e fuulu gbalee. Ye bahke lehke elkv go ejang eboblum mfam, tete rehng go eto Galili. ");
INSERT INTO eka_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","Bada etˈtohngo ji Aser, á bungu re, <<Aser wo bo ga-e fuulu, go abon ba nlum. Nong abonanyehn jo lim-e nnoobo, á fere ru akpade enye go akehng. ");
INSERT INTO eka_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Fvfo abil eti mbu nya bahke jolo akuungu, a abil ekpi, fvfo atahne enya bahke kange ana afung kpee nya elkpin ena. ");
INSERT INTO eka_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","Nnene limm no li ana Esowo bi Isreel. Ye ji kun go elbung re á tob-n, fvfo go akparesemsem go ege atahne. ");
INSERT INTO eka_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","Esowo bi li go njinanjini, ye wo li edi elbiiri eja. Abo enye nya kpa-a fili go njinanjini. Á bahke kame anebekv eba, yehke go ega esamahr, fere bung re, <<Ranngen bo.>> ");
INSERT INTO eka_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","Ano wo anebe Isreel bahke jolo go elforo; Et'tohngo ji Jekob bahke jolo go elforo go ndi nyi nkohl a amahm mfemfe, edi ji elbung bahke jo na ebohng. ");
INSERT INTO eka_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","Elfuulu li ka anebe Isreel! Nne awo li ana wo, ane bao ba Jehova ma tahre boa? Ye wo li ekum a ekakebo eja, go ekahngkahng eba bi kpi ellub. Anebekv eba bahke jo kahn gub gub gub ega esamahr. A bahke jo jade bo go akpade. ");
INSERT INTO eka_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Owo Mosis kehm mehle edi ebalebale ji Moab, song wahr ewong ji Nebo, song rehng go ero ewong jio ji Pisiga ji jolo songo songo wane Jeriko. O edi jio wo Jehova sa tib-e ndi nyio kpee, bomo go Giled, rehng go Dan, ");
INSERT INTO eka_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ndi nyi Naftali kpee, a ejang mbakandi nyi Efriim a Manase a ndi Juda kpee tete rehng go agburu aya ma nlen ma bo kpo lung re Mediterenia. ");
INSERT INTO eka_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Tob rehnge go Emahng ji ejang ebobkal a erohko ndi jio kpee, ji bomo go edamme ji Jeriko ji li ejahbe mbohng asongo tete rehng go Joar. ");
INSERT INTO eka_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Owo Jehova kehm bungu tong-e re, <<Ndi nyi a, nyi n nyame no ko nwongo a Ebraham, Aesik abola Jekob re, <M bahke kake ebangenahb ejahne.> M ma-a yake re wo ko amahr amahr nyehn, jol wo á nehm siiri song yel o. ");
INSERT INTO eka_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Mosis nlokeltuma Jehova kpo o Moab, ana Jehova bungu no. ");
INSERT INTO eka_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Jehova kpa-e kak go edamme ji li songo songo wane Beti Peor go Moab. Tete sik lela, jol nnene nehme kahn edi ji elahm ebe li no. ");
INSERT INTO eka_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Mosis kange nnya atahl arakera kehm kpoko. Jol amahr enye bammem, jol á kohkem go ngubjing. ");
INSERT INTO eka_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Anebe Isreel noongo elkv Mosis gona edi ebalebal ji Moab eltahl a nfung na ewubu, tete ngare eling a elkv anoongo nyio sehng. ");
INSERT INTO eka_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Etohko ji elkahne jolo a Josua ji mmon no Nun, tibre Mosis kun-e kunu abo enye. Anebe Isreel jo wuung-e wuungu atung, fere jo lim ji Jehova ka Mosis elkahn. ");
INSERT INTO eka_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Bomo ngare nyio go Isreel, nnyehnamahr awohng awohng ka kpe jol ana Mosis, ye ji Jehova jo bung a ne gbul gbul gbuul. ");
INSERT INTO eka_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Ye ji limi akpokosi nyaa kpee, a nliingi nyi Jehova tum-e re á lim go Ijib, nya á limi tib Fero a atubesi ntum ebe kpee, go ndi nyi Ijib kpee. ");
INSERT INTO eka_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Tibre nnene limm, no ma tꞌtib egburu eko jio, fere lim amennge mennge nsol nya Mosis limi no, go esamahr bi anebe Isreel kpee.");
INSERT INTO eka_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Ngare nyi Mosis nlokeltum no Jehova ma kpo, owo Jehova kehm bungu tong Josua mmona Nun, ekpeele ji Mosis re: ");
INSERT INTO eka_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","<<Mosis nlokeltum ewame ebkpo. Wo, a ane baa kpee, tooben ebjing, wahn song siiri aya ma Jodan, rehng go edi ndi ji m bahke kake anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Edi ajehng ajehng ji a kadde akpade enya, m bahke faake kak-a go abo, ana n nyame tong Mosis. ");
INSERT INTO eka_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Edi ndi ejahne bahke bomo go elka emahng ejang eboblum rehng go awong Lebanon go ejang ebobkal, fvfo bomo go agburu aya ma Yufritis go ero nfam, song rehng go ndi nyi anebe Hid, rehng aya ma ki kpi egbuk go erede nfam. ");
INSERT INTO eka_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Nnene limm no bahke ma yiimi abohng a na, afung nya a kpeka li go elkpin. Ana n jolo a Mosis, ano wo fvfo m bahke tob jol a na. Me wa nehm tiki yake abo, jol wa nehm tiki ten. ");
INSERT INTO eka_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","<<Bel atahne, a ekakeltim, tibre wo wo li nne no bahke tohko ane baa tete bo song yel go edi ndi elehkelkv, ji n nyame tong babnde ebo ba nkul re, m bahke kake bo. ");
INSERT INTO eka_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Bel na bel atahne, wo sahb bˈbel esahbeltim, jo kunu ekpu wo bum atahm nya Mosis nlokeltum ewame ka-a no. Ka gbake je ejang eboblum, afi ejang ebobkal, eji lˈnob a na edi ajehng ajehng ji a fi no. ");
INSERT INTO eka_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Ka tiki rahke nwer atahm nyia go ellungu ngare anyehng anyehng. Jo tir bade, atv a njul, eji a lˈjo kunu ekpu fere jo lim ejum ajehng ajehng ji bo nyono o. Owo a bahke gboko afang, fere nˈnob a na. ");
INSERT INTO eka_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Wa n ka ka elkahna? Bel atahne, wo bel esahbeltim. Ka fahl, abo ki-a woono, tibre Jehova Esowo eba, bahke jolo a na edi ajehng ajehng ji a fi no.>> ");
INSERT INTO eka_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Owo Josua kehm kake atubesi abanoko ebta ba kpo fili ane elkahn re: ");
INSERT INTO eka_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","<<Song yelen go atahng edi erekekv, wahn tong ane re, <Tooben nsol alehke enyahne bum, lˈbiingi nfung era, ḿ bahke siiri Jodan, song ko edi ndi ji Jehova Esowo ebahne ka-n no re jol jˈjahne.> >> ");
INSERT INTO eka_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Josua kehm lungu ane ba lohng go etˈtohngo ji Ruben, a ji Gad, a ejang etˈtonhgo ji Manase, kehm tongo bo re, ");
INSERT INTO eka_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","<<Buumen ejehke ji Mosis nlokeltuma Jehova ka-n no: <Jehova Esowo ebahne bahk-n kake erekekv. Á ma-n ka edi ndi jia.> ");
INSERT INTO eka_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Akal ebahne, a abon ebahne, a atohkondi atohkondi enyahne kpee bahke ma jol go edi ji Mosis ka-n no, go ero bio bi aya ma Jodan. Abanokebta ebahne kpee, a nsol ebta ebo kpee go ebo abo, bahke gboko atˈtohngo nyako mbang siiri Jodan. Wahn bahke kake abonane ebahne ebo, ");
INSERT INTO eka_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","tete Jehova ka bo erekekv ana á ma-n ka, eji bo lˈko nji go edi ndi ebo, ji Jehova Esowo ebahne bahke kake bo. Ń lˈlim ano, wahn kehm feere go egahna ndi nyi Mosis nloketuma Jehova ka-n no, go egbuk jehko ji aya ma Jodan, ejang bio bi njul kpo lohng. ");
INSERT INTO eka_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ane bao kehm faange Josua re, <<Ejum ajehng ajehng ji a lꞌka elkahn re wahr lim, e bahke limi, fvfo edi ajehng ajehng ji a lꞌtum-r, e bahke jeke. ");
INSERT INTO eka_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Ana e jo wuku Mosis go ejum ajehng ajehng, ano wo fvfo e bahke tob jo wuk-a. Nong lub jol re Jehova Esowo eba bahke jolo a na ana á jolo a Mosis. ");
INSERT INTO eka_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Nne no lˈsiir-a go asi, kˈbum alum enya, go ejum ajehng ajehng ji a lꞌtong bo, bo bahk-e wulu. Li re wo bel atahne, a esahbeltim. >> ");
INSERT INTO eka_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Josua mmon no Nun kehm tumu ane abal mbehrbehr eji bo jolo go Sitehm re bo song weele nyehn edi ndi jio, asehngesehnge Jeriko. Owo bo kehm tahme, song yel etahk nnenkal asˈsa no bo jo lung-e re Rehab, song jol o. ");
INSERT INTO eka_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Bo kehm tongo ntula Jeriko re, <<Nyehno! anebe Isreel bandiki ebba a atv maa, re bo ba weele nyehn ejahbe.>> ");
INSERT INTO eka_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Ntula Jeriko kehm tiingi tv Rehab re, <<Yehke ane bao ba ma ba yel go ega etahk, tibre bo ba re bo ba weele nyehn ejahbe kpee.>> ");
INSERT INTO eka_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Wo Rehab ebrod ane abal bao behr, kehm bungu re, <<Ee, aneblum baa lˈlohng ba a egame, me n kahnem edi ji bo lohngo no ba. ");
INSERT INTO eka_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Bo feere ebo ngare elgung, ngare nyi bo kpo bam eti mbu. N kahnem esi mbang ji bo sehnge sehng tahm. Toonen bo elwaare elwaare. Ḿ bahke ma kpiri bo go mbang.>> ");
INSERT INTO eka_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Wo, ga yebrod aneblum bao song kunu go ero elbulu, fere behr bo go nkahr nyi bo yale go ero elbulu. ");
INSERT INTO eka_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Ane ba ntul tumu no kehm mehle asongo re bo song seb abaweele nyehn ejahbe mbang mbang nyi li feere elga ni bo kpo siiri aya ma Jodan. Ana ane ba jo seb bo mehle asongo, ano wo bo bame eti mbu. ");
INSERT INTO eka_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Re abaweele nyehn adi kehm noongo lal, Rehab song kpiri bo go ero elbulu, ");
INSERT INTO eka_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","kehm tongo bo re, <<N kpˈkahne re, Jehova ma-n ka edi ndi jia, e kpi egburu elfahle bade anahne. Wo ane kpee ba li ejahbe jia, ebgbo awo, tib eji e kp-n fahle. ");
INSERT INTO eka_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Tibre wahr ebwuk ana ji Jehova limi no, Aya nkpafa ka wum kpee, ka-n mbang eji ń lohngo go Ijib abake, fere wuk bade ana ń limi Sihon, a Og atul abal ba anebe Amor ba jolo go ero nfam bi aya ma Jodan, bo ji ń wulu ane ebo kpee. ");
INSERT INTO eka_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Eji e wuku nsol nyia kpee, ntim enyahre ebrannge, eko ma-r tan, tib eji e kp-n fahle. Tib Jehova, Esowo ebahne, ye ntahng ntahng wo li Esowo go elbung a ndi. ");
INSERT INTO eka_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Wahn fvfo tiren tong-m anv, go mbing nyi Jehova re ḿ bahke tibi ane ebame nnoobo, eji m ma lim nnoobo ka-n. Tib-m wahn ellingi ni m bahk kahne re, ");
INSERT INTO eka_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ń nehm wul nsoo, nnee, a abonanee ba nlum a ba nkal , a ane kpee ba bo kpi no, re a bahk-r tahre yehke go elkv.>> ");
INSERT INTO eka_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Owo aneblum bao kehm-e tongo re, <<Wahr ebtoobo ebjing re wahr ka elkpin enahre go egahne elkpin, jol tete e kpo. A tohko tong nne awohng awohng ji e ba a, ngare nyi Jehova lꞌka-r ndi nyia e bahk-a fili nobnob, fere fil-a go etingitingi.>>. ");
INSERT INTO eka_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Eji etahk Rehab kuumu go ekahme ji bo si sennge ejahbe kak, Rehab kehm koko ekehd, kahn ewindu ane bao taare badde njahm ekahme nyehko. ");
INSERT INTO eka_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Rehab kehm tongo ane bao re, <<Songen go awong, wahn song biiri o nfung era, eji ane ba kp-n sebe lꞌki-n nyehn. Bo lꞌfeere wahn kehm lohngo song.>> ");
INSERT INTO eka_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Aneblum bao kehm bungu tong-e re, <<Nwongo nyi a lim-r no e tir, wahr nehm tuunu, ");
INSERT INTO eka_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","sehngem re eji e ma yel go ejahbe, e bahke nyehne mbilibili ekehd jia , ji a ma kahn go ewindu ji a yehk-r no yake, a bahke tob ko nso, nne, a abonane ba nlum, a anebe etahk nso kpee, ba bum go ega etahk. ");
INSERT INTO eka_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Nne awohng awohng no lˈlohng go ega etahk jo yannge go mbang, alung eme bahke kuumu go ege esi. Ebi jˈjahre nehm jol. Nne awohng awohng no lˈwoomo etahk a na, alung eme bahke kuumu go egahre esi, ebo abehng abehng lˈkoor-e. ");
INSERT INTO eka_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Wo a lˈfere tooro ejum ji e kpꞌlimi a tong nne awohng awohng, e bahke foro go nwongo nyi e limi a na.>> ");
INSERT INTO eka_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Rehab kehm faange re, <<Me n taame ji ḿ ma bung.>> A kehm yake bo, bo tahm kehnge. Rehab kehm kahne mbilibili ekehd go ewindu. ");
INSERT INTO eka_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Eji bo tahme no, bo song biiri go awong, kang nfung era o, tete ane bao ba jo seb bo mbang mbang, feere kehnge, bo nyehnem bo. ");
INSERT INTO eka_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Ano wo ane abal baa soro badde go ero awong, jo feere ebo kehnge. Bo ba siiri aya ma Jodan, kehm ba tong Josua mmon no Nun nsol kpee nyi ma lim bo. ");
INSERT INTO eka_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Bo kehm bungu tong Josua re, <<Jehova ebfaake ejahbe jia kpee go etingitingi kak-r go egahre abo. Ane kpee eko ebtan bo, tib go elfahle ni bo kp-r fahle.>> ");
INSERT INTO eka_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Efungfu behre behre Josua a Isreel kpee kehm mehle go Sitehm song rehng go Jodan, edi ji bo gohro song re ekv kehm siiri aya ma Jodan. ");
INSERT INTO eka_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Eji nfung era ma sehng, atubesi abanoko nta kehm mehle jo jen yannge edi erekekv, ");
INSERT INTO eka_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","kehm kehme ane elkahn ka re, <<Ń lˈnyehn Elkohl Atahm ni egbanngalung ji Jehova Esowo bahne, a abalimajom ba li anebe Levi ma sol, mehlen go adi nya ń jehk no wahn toono elkohl atahm nio. ");
INSERT INTO eka_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Ngare nyio nyi, ḿ bahk kahne mbang nyi ḿ bahke sehnge, tibre ń ka sehnga sehng go mbang nyia. Kana jen kabbe elkohl atahm nio, ka-n eyake fee ejum ntahme atahltahl nkpel elon.>> ");
INSERT INTO eka_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Josua kehm tongo ane re, <<Bumen elnahne saang, tibre behna Jehova bahke limi nkpokosi go egahne ellong.>> ");
INSERT INTO eka_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Josua kehm bungu tong abalimajom re, <<Roden elkohl atahm ni egbanngalung, wahn gbo ane mbang. Ano wo bo rodo elkohl, gbo bo mbang. ");
INSERT INTO eka_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Jehova kehm bungu tong Josua re, <<Lela wo m bahk-a bomo elmehle wahre go esamahr anebe Isreel kpee, ano wo bo bahke kahne re n li a na, ana n jolo a Mosis. ");
INSERT INTO eka_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Tong abalimajom ba solo elkohl atahm re: Bo lˈrehng go nkpe aya mao ma Jodan, bo song yiimen go elka alahb.>> ");
INSERT INTO eka_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Josua kehm bungu tong Isreel kpee re, <<Baan a, wahn ba wuungu atung go alum nya Jehova ma bung, ye ji li Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Ana wo ḿ bahke kahne re, Esowo bi li go elkpin wob go egahne ellong. Á bahke kame anebe Kenan, Hid, Hiv, Peres, Girgas, Amor, a anebe Jebus. ");
INSERT INTO eka_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Nyehnen, elkohl atahm ni egbanngalung ji Ntul no njini kpee, ni ni bahk-n gboko mbang eji ń kpˈsiiri Jodan. ");
INSERT INTO eka_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Anv, yehken ewubu ane abal, nne awohng awohng, go etˈtohngo ajehng ajehng. ");
INSERT INTO eka_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Ana abalimajom ba solo elkohl atahm ni Jehova, ye ji li Ntul no njini kpee, bahke behde akpade ebo go aya ma Jodan, alahb bahke kimi ekpidi ebbal, ma kpˈfabe abake bahke ba yiimi gbo ekahme.>> ");
INSERT INTO eka_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Ngare nyi ane ma mehl go edi ekv areke ebo re bo siiri aya ma Jodan, abalimajom ba solo elkohl atahm ni egbanngalung gbo ane mbang. ");
INSERT INTO eka_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Jolo ngara nnyel nyi bo kpo kpa nsol ndi, ana akpade nya abalimajom ba solo elkohl atahm rehnge nkpe aya, ana bo behde akpade go nkpe alahb, ");
INSERT INTO eka_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","alahb ma jo fab ero abake rahke elfabe sa yiimi, lim ekahme bomo go fee go ejahbe ji bo kpo lung re Adam, ji li kohlo Jaretan. Ma jo fab erede erede, fab song yel aya Akang. Ma sa yiimi kpeem jo fab. Ano wo ane male bel mbang siiri sehng aya asongo go Jeriko ji jolo go bo a mbuksong. ");
INSERT INTO eka_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Abalimajom ba solo elkohl atahm ni egbanngalung ji Jehova, sa yiimi ndi nyi ma wum, elka aya ma Jodam, tete anebe ejahbe Isreel kpee siiri ewumwum ndi rehng egbuk aya jehko. ");
INSERT INTO eka_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Eji ejahbe Isreel kpee ma siiri aya mao ma Jodan mal, owo Jehova kehm bungu tong Josua re, ");
INSERT INTO eka_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","<<Yehke ewubu aneblum abal, go ellong ane baa, nne awohng awohng go etˈtohngo. ");
INSERT INTO eka_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Tong ane bao, bo song rod ewubu atal abal, go yefono edi jio ji abalimajom yiimi no, go elka efabe aya ma Jodan, song bum go edi ji e bahke reke ekv atv ma lela.>> ");
INSERT INTO eka_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Josua kehm lungu ewubu ane abal, ba á ma yehke, nne awohng awohng go etˈtohngo, ");
INSERT INTO eka_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","kehm bungu tong bo re, <<Songen go efabe ji Jodan, esꞌsong bi elkohl atahm ni Esowo yim no, wahn song rod, no nne eltal anehng kunu ekpakebahk, etˈtohngo ajehng ajehng rod eltal anehng anehng, ");
INSERT INTO eka_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","bahke jolo ejum elliingi go egahne ellong. Go ngare esˈsong, abon ebahne lˈbahb-n re, <Atal nyaa lohngo jen?> ");
INSERT INTO eka_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Ḿ bahke tongo bo re, aya ma Jodan kimi ekpidi ebbal. Atal nyaa bahke jolo ejum elbuumu ka anebe Isreel, ngare kpe kpe. ");
INSERT INTO eka_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Owo anebe Isreel kehm limi ana Josua ka bo elkahn. Bo yehke ewubu atal abal go elka efabe ji Jodan, jang jang ana nfange atˈtohngo nya Isreel li no, ana Jehova ka Josua elkahn. Bo solo song bum go edi ji bo jo re ekv atv mao, owo bo bumu atal nyao. ");
INSERT INTO eka_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Josua fvfo tob lo ewubu atal abal go elka efabe aya ma Jodan, go edi jio ji abalimajom ba solo elkohl atahm ni Esowo yiimi no. Li o tete rehng efung bi lela. ");
INSERT INTO eka_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Abalimajom ba solo elkohl atahm ni Esowo yiimi go elka efabe aya Jodan tete ane lim nsol kpee nyi Jehova ka Josua elkahn, ana Mosis tibi Josua. Ane jene elwaare siiri aya, ");
INSERT INTO eka_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","eji nne awohng awohng ma siiri rehng go egbuk jehko, owo abalimajom tob siiri, a elkohl atahm ni Jehova, ga ane kpee yiimi jꞌrii jo seenge. ");
INSERT INTO eka_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Aneblum ba etꞌtohngo ji Ruben a ba Gad, a ejang etꞌtohngo ji Manase tob siiri aya a nsol ebta ebo go ebo abo. Bo gbo anebe Isreel mbang, ana Mosis ka bo elkahn. ");
INSERT INTO eka_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Atahntahn ane baa jolo ane atahltahl nkpel atahl alon (40,000), bo siiri aya song rehng go emahng ji Jeriko ji li ebal ebal re bo song nok ebta, fvfo Jehova jolo a bo. ");
INSERT INTO eka_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Efung bio Jehova mehle Josua wahre go esamahr bi Isreel kpee. Israel ka Josua ekpunu tete á kpo, ana bo ka Mosis. ");
INSERT INTO eka_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Owo Jehova kehm bungu tong Josua re, ");
INSERT INTO eka_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","<<Ka abalimajom ba solo elkohl Ntianse elkahn re bo lohng go efabe aya Jodan, ba ga egbuk. ");
INSERT INTO eka_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Josua kehm kake abalimajom elkahn re, <<Lohngen go efabe aya Jodan, wahn ba yiimi ga egbuk.>> ");
INSERT INTO eka_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Abalimajom kehm lohngo a elkohl atahm ni Jehova ni bo solo no. Ana bo kpˈlohngo go efabe alahb akpade bo ba rehng egbuk, ano wo alahb ma Jodan kpe kehme elfabe, yel rehng egbuk ana wuku wuku. ");
INSERT INTO eka_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Nfung ewubu nyi ngbokambanga nnyahng, owo anebe Isreel siiri aya ma Jodan, bo bumu edi erekekv go Gilgal ji li nkonandi nyi Jeriko, ero nfam. ");
INSERT INTO eka_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","O Gilgal wo Josua lange ewubu atal abal nya bo yehke go elka efabe aya ji Jodan. ");
INSERT INTO eka_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Josua kehm bungu tong anebe Isreel re, <<Ngare esˈsong, abon ebahne bahke bahbe babnde re, <Atal nyaa lohngo rejen?> ");
INSERT INTO eka_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Tong bo re, <Anebe Isreel siiri efabe Jodan go ewumwum ndi.> ");
INSERT INTO eka_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Tibre Jehova, Esowo ebahne, ye wo limi aya ma Jodan ka go egahne esamahr, tete wahn siiri sehng. Jehova Esowo ebahne limi aya ma Jodan, jang jang ana á limi go aya nkpafa, eji á limi no ka egahre esamahr tete e siiri sehng. ");
INSERT INTO eka_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Á limi jia eji ane ba njini kpee lˈkahn re ebo bi Jehova kpi nsahm, á tob limi eji wahn fvfo lˈtob jo fahl Jehova ji li Esowo ebahne go njinanjini.>> ");
INSERT INTO eka_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Eji atul bao kpee ba anebe Amor, bo ji li feere erede nfam aya ma Jodan, a atul ba anebe Kenan kpee, bo ji jolo nkpe aya Mediterinian, wuku ana Jehova ma lim aya ma Jodan ma ka, ka anebe Isreel mbang bo siiri efabe aya Jodan, bo kehm kehme elfahle. Bo kpeem bel esahb ji bo bahke yiimi nok a anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Ngare nyˈnehm o, Jehova kehm tongo Josua re, <<Ko atahntahn atal wo lim abon ntahme, bange yehke anebe Isreel nrur, bo ji bo ki yehke bo nrur wuku wuku.>> ");
INSERT INTO eka_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Owo Josua kehm koko atahntahn atal lim abontahme, yehke anebe Isreel nrur go Gibiad Haaralod, ji lohngo re Ewong Nrur ayehke . ");
INSERT INTO eka_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Jia ji wahnge Josua limi ano: Tibre ane kpee ba lohngo go Ijib, aneblum kpee ba rehnge ekul bi bo bahke ma je ebta, kpoo kpee go elka emahng ana bo lohngo go Ijib mbang mbang abake. ");
INSERT INTO eka_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Aneblum kpee ba lohngo go Ijib, bo yꞌyehke bo nrur. Wo aneblum ba bo jele bo go elka emahng ana bo lohngo go Ijib jo jen asongo go Kena, bo yehkem bo nrur. ");
INSERT INTO eka_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Anebe Isreel jene elka emahng nnya atahl abal, tete aneblum kpee ba rehnge ekul bi bo bahke ma je ebta ngare nyi bo lohngo go Ijib, ma kpoo, tib eji bo ki jo kpunu Jehova. Tibre Jehova ko nwongo fere tir re, bo nehm tiki nyehn edi ndi ji á nyame tong babnde re á bahke kake bo. Ndi nyi alahbbel a akehng ekon kpꞌfabe. ");
INSERT INTO eka_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Jehova kehm koko abon ebo ba nlum le bo woongo asi nya babnde, bo ba Josua yehke bo nrur, ngare nyio bo ka yehke nrur, tibre bo yehkem bo nrur go mbang. ");
INSERT INTO eka_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Eji bo ma yehke aneblum nrur kpee go ejahbe, bo sa o edi erekekv tete alok nrur ebo kpo kpee. ");
INSERT INTO eka_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Owo Jehova kehm tongo Josua re, “Lela, me n yehke esono ji ń jolo aju go Ijib go egahne ellong. Bo soro lung edi jio re Gilgal ji lohngo re elyehke wohng go tete rehng lela. ");
INSERT INTO eka_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Go ewubu a nfung eni mi nnyahng, ngare elgung, anebe Isreel kehm limi elkak ni Elsehnge Sa, ngare nyi bo kpeka li go edi erekekv ji Gilgal ji li adi ebal ebal nya Jeriko. ");
INSERT INTO eka_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Etoono efung, eji elkak Elsehnge Sa ma mal, efung bˈnehm o, anebe Isreel li nsol nyindiki nyi lohng o ndi nyi Kenan: Abred nya bo ki kak ayist, a awokowoko nkohl. ");
INSERT INTO eka_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Ana bo li nsol ndi nyia, etoono efung, ano wo mmana rahke no. Mmana kpeem jol ka anebe Isreel, elya nio kpee bo jo li nsol nyi lohng go ndi nyi Kenan. ");
INSERT INTO eka_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Ngare nyi Josua ma rehng kohlo Jeriko, á kehm tabe amahr enye kehm nyehne nnenlum no yim go egea mbuksong, a ekahngkahng bi á ma wob go mbak. Josua kehm song kpir-e, kehm-e bahbe re, <<A li go egahre ejanga, afi go ejang anebekv ebahre? ");
INSERT INTO eka_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Á kehm-e faange re, <<Eˈee n limm ka bo, jol n limm ka wahn. Me wo li ntubesi no abanoko ebta no Jehova, ano wo wahnge m ma ba. Josua kehm gboko kohk esamahr ndi kak-e, kehm-e bahbe re, <<Ntubesi etib abii a kpi no ka nlokeltum ewe?>> ");
INSERT INTO eka_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Owo ntubesi no abanoko ebta no Jehova kehm faange re, <<Yehke akpaketa go ega akpade, tib edi ji a yim a, li saang.>> Owo Josua kehm limi no. ");
INSERT INTO eka_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Ngare nyia Jeriko ebsahd ati mbu ebo kpee, tib esi ji anebe Isreel. Nnene kpeem jo lohng, jol nnene kpeem jo yel. ");
INSERT INTO eka_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Owo Jehova kehm tongo Josua re, <<Nyehne! Me n yake Jeriko kpee kak-a go abo, a ntula bo, a abanoko ebta. ");
INSERT INTO eka_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Jen sennge Jeriko nkpel anyehng a abanoko ebta kpee. Limen ana, go nfung erakera. ");
INSERT INTO eka_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Nong abalimajom na asehma ba fili atang nkom, gbo elkohl atahm mbang. Go efung bi ma biingi nfung esehma, ḿ bahke jene sennge ejahbe jio nkpel na esehma, abalimajom bahke jo wor atang. ");
INSERT INTO eka_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Ń lˈwuk abalimajom ma wor atang ekidi ma lab, nong ane biiki wahre wahre; Ekahme ji Jeriko bahke gboko, abanoko ebta bahke sehnge yel go atahng ejahbe, nne awohng awohng bahke jene tor tor yel. ");
INSERT INTO eka_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Owo Josua mmona Nun kehm lungu abalimajom, kehm tongo bo re, <<Roden elkohl atahm ni Jehova, nong abalimajom na asehma gbo elkohl atahm nio mbang, fili atang go ebo abo.>> ");
INSERT INTO eka_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Josua kehm tongo ane re, <<Mehlen! Jenen sennge ejahbe kak, nong abanoko ebta ba fili nsol ebta gbo elkohl atahm ni Jehova mbang.>> ");
INSERT INTO eka_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Eji Josua ma bung abo ano mal, owo abalimajom na asehma, no nne a ntang go esamahr bi Jehova, kehm kehme atang ebo wor ana bo kpˈjene asongo. Elkohl atahm Jehova jo toono bo go njahm. ");
INSERT INTO eka_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Abanoko ebta kehm gboko abalimajom ba jo wor atang mbang, egom jehko jo toono elkohl atahm. Ngare nyia kpee bo jo woro atang. ");
INSERT INTO eka_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Wo Josua kehm kake ane elkahn re, <<Nnene kˈbiiki ebta, nnene kˈmehl alum wahre, jol nnene ellum ki-e lohng go nnyo tete efung bi á bahke tongo bo re bo biiki, bo kehm biiki. ");
INSERT INTO eka_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Á kehm tongo bo rod elkohl atahm ni Jehova jen sennge ejahbe nkpel anyehng efung bio. Ane bao kehm feere kehnge go ebo edi erekekv, song kang atv mao o. ");
INSERT INTO eka_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Josua kehm mehle etoono efung, efungfu behre behre, abalimajom kehm rodo elkohl atahm ni Jehova. ");
INSERT INTO eka_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Abalimajom na asehma, ba fili ntang esehma gbo mbang, jo jen jo wor atang, go mbuksong nyi elkohl atahm ni Jehova. Nsoja nyehko gbo bo mbang, nyehka jo toono elkohl atahm ni Jehova. Abalimajom soro asi jo wor atang ngare kpe kpe. ");
INSERT INTO eka_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Go nfung ebal, bo jene sennge ejahbe nkpel anyehng, bo kpee feere song rehng go ebo edi erekekv. Ano wo bo limi no, go nfung na erakera. ");
INSERT INTO eka_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Go efung bi biingi nfung esehma, bo nyahme efungfu atv atv, jen sennge ejahbe jio ana bo jo kono ellimi. Sehngem re efung bia bi bo jene sennge ejahbe nkpel esehma. ");
INSERT INTO eka_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Eji ma biingi nkpel esehma nyi bo ma jen sennge ejahbe efung bia, ngare nyi abalimajom ma wor atang nya sahb wˈwahre, Josua kehm kake ane elkahn re, <<Raben! Tibre Jehova ma-n ka ejahbe jia! ");
INSERT INTO eka_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Ḿ bahke rannge ejahbe jia kpee, a ejum ajehng ajehng ji li go atahng. Sehngem Rehab ji li nne asˈsa, a ane kpee ba li go ege a nlaaga ba bahke sake, tibre á behre ane ba weele song nyehn ejahbe ba e tumu no. ");
INSERT INTO eka_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Kana lak abo go ejum ajehng ajehng ji bo bahke rannge kpee, eji ń lꞌkꞌko elrannge ba ka elnahne tib ano. Ń lꞌlak abo bahke koko abꞌbi a afemfem ba kak edi erekekv. ");
INSERT INTO eka_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Ejum ajehng ajehng ji bo limi go asilva a agul, a abrons, a akuungu li nsol nyi li saang ka Jehova. Nsol nyio kpee bo bahke koko song bum go etahk ji bo kpo kuuru nsol Jehova. ");
INSERT INTO eka_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Eji bo woro atang nyao, ane kehm biiki, eji atang wahle no, ane kehm rabe wahre wahre, ekahme kehm soro gbo. Nnenlum awohng awohng kehm gehre yel songo songo ejahbe jio, ano wo bo ko ejahbe jio. ");
INSERT INTO eka_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Bo yake ejahbe jio kpee ka Jehova, fere ko akahngkahng rannge nsol kpee nyi li go elkpin ana aneblum, anebkal, ba nse a ba nkul, go adahmagbudu, ejoro, a ebvankang. ");
INSERT INTO eka_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Josua kehm tongo aneblum abal bao ba weele song nyehn ejahbe re, <<Songen go etahk nnenkal asˈsa noo, wahn song yehk-e, a ane ebe kpee, ana ń nyame no tong-e. ");
INSERT INTO eka_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Ano wo njangkun ebal nyio, bo ji song weele nyehn ejahbe, kehm song yel yehke Rehab, nde, nnyehn, abonanyehn ba nlum a ba nkal, a ane kpee ba li a ne. Bo yehke ebangenahb eje kpee song bum edi ji li kohlo edi erekekv ji anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Owo anebe Isreel kehm jahme ejahbe jio kpee fi, a nsol kpee nyi jolo go atahng. Wo bo kpu asilva, agul, a nsol nyi bo ko abrons go akuungu lim, song kak go etahk ji bo kpo kuuru nsol nyi Jehova. ");
INSERT INTO eka_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Wo Josua yake Rehab nnenkal asꞌsa, a ebangenahb eje, go ane kpee ba jolo ka-e, á wulem bo, tibre á behre ajangkun nya Josua tumu re bo weele song nyehn Jeriko. Á lene go ellong ni anebe Isreel tete tub lela. ");
INSERT INTO eka_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Ngare nyio Josua kehm nyame ko nwongo re: Go esamahr bi Jehova nne awohng awohng no lꞌgare re á tuungu ejahbe Jeriko jia si nkuk a ne: Re á bum nnahb ekahme, agbokambang a mmon ewe no nlum bahke kpoko; re á lim eti mbu, nkahla mmon ewe no nlum bahke kpoko. ");
INSERT INTO eka_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Jehova jolo a Josua, elgahm ene yerre na yerre go ejahbe jio kpee. ");
INSERT INTO eka_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Wo anebe Isreel taamem bum ntahm nyi jolo re bo rannge nsol kpee go Jeriko. Ekan ji mmon no Kami, ji mmon no Jimri ji mmon no Jera, ji lohng go etˈtohngo ji Juda. Á rodo abon nsol o. Owo Jehova kehm rake atahng a anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Josua kehm tumu ane o Jeriko re bo song go Eai, ji li kohlo Bet-Aven, ji li go ero nfam nyi Betel. Á kehm tongo bo re, <<Weelen song nyehn erohko ejahbe.>> Owo aneblum bao kehm tahme, fere song weele nyehn Eai. ");
INSERT INTO eka_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Eji bo feere no ba kpiri Josua, bo kehm-e tongo re, <<Nsoja kpee sang bahke jeke song nok a Eai. Tum ane atahltahl nkpel elon, afi ane atahltahl nkpel esehma, a ane atahl awubu, bo song ko ejahbe jio. Ka gbiingi ane kpee, tibre li abon amohk ane abik abik go ejahbe jio.>> ");
INSERT INTO eka_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Bo kehm tumu ane atahltahl nkpel esehma a ane atahl awubu, anebe Eai ga bo kpee, ");
INSERT INTO eka_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","bo fere wul eltahl nne elku, a nne awohng. Aneblum Eai kame anebe Isreel bomo go eti mbu tete rehng go adi nya bo kpo wa atal, fere wul bo go agbunggbung. Eji jolo ano eko tane anebe Isreel efung bia, ntim woono bo go elfahle, fere jol ana alahb. ");
INSERT INTO eka_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Owo Josua, kehm yare nsol ebjing enye, gbo kohk asamahr go ndi, go mbuksong elkohl atahm ni Jehova, sa o tete elgung. Ano wo anebkul ba Isreel tob lim, kpu ebtohko wohngo elbo go ebo esi. ");
INSERT INTO eka_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Josua kehm bungu re, <<O Ntubesi Jehova, jenji wahng ka a tohk kˈko ane baa ba siiri aya ma Jodan, re wo ba yak-r kak abo anebe Amor re bo wul-r? Jol nobo e sa sa go egbuk aya Jodan jehko! ");
INSERT INTO eka_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Ntubesi, anv m bahke bungu rejen, eji anebekv ma kam anebe Isreel?. ");
INSERT INTO eka_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Anebe Kenan, a ane bako ba li go edi jia bahke wuku bade ejum jia, bo bahke ba senng-r kak, fere wul-r, fvvdv mbing enyahre go njini. Ejum ajii a bahke limi tib go ega egburu mbing?>> ");
INSERT INTO eka_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Owo Jehova kehm tongo Josua re, <<Mehl yiimi! Nˈnan a nong ana, esamahr eba go ndi? ");
INSERT INTO eka_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Anebe Isreel eblim abiafem, bob soodo egbanngalung ji n jehke ntahm ka bo re bo bum. Bob rod nsol nyindiki nyi n tongo bo re bo rannge; bob v, fere rod behr go ebo a nsol, bob kim afahnge. ");
INSERT INTO eka_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Ano wo wahnge anebe Isreel lˈkˈma yiimi a anebekv ebo. Bob sennge ajahm be, anv, wahn ebyehke mbang elrannge. N nehm ma kpe jol anahne tete ń rannge nsol nyi li egahne ellong nya li ka-n re wahn rannge. ");
INSERT INTO eka_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","<<Mehl! wo song nange ane. Tong bo re, <Bo nange elbo, toobo ebjing bi behna; Jia ji Jehova Esowo bi Isreel kpˈbungu: Isreel go egahne ellong wahn ebbehr ejum ji n tong-n re wahn rannge. Ń nehm ma kpe tiki yiimi a anebekv tete ń yehke nsol nyio egahne ellong. ");
INSERT INTO eka_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","<< <Go efungfu, ḿ bahke lohngo ba etˈtohngo etˈtohngo; etˈtohngo ji Jehova bahke yehke, bahke lohngo ba esi ejahbe esi ejahbe; esi ejahbe ji Jehova bahke yehke bahke lohngo ba ebangenahb ebangenahb; ebangenahb ji Jehova bahke yehke, bahke lohngo ba nnenlum awohng awohng. ");
INSERT INTO eka_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Nnenlum no bo lˈkpiri nsol nyi jolo re bo rannge go ege ebo, bo bahk-e fehke go agun, a ejum ajehng ajehng ji á kpi no, tibre yebgbo ntahm nyi Jehova, fvfo yeblim ejum esono go Isreel.> >> ");
INSERT INTO eka_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Etoono efungfu atv atv Josua limi Isreel bo lohng etˈtohngo etˈtohngo, etˈtohngo ji Juda ji bo yehke no. ");
INSERT INTO eka_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Asi ajahbe nya Juda kehm lohngo ba, anebe Jera ba gbo tub bo. Eji anebe Jera lohngo ebangenahb ebangenahb, gbo tub ebangnahb nyi Jimri. ");
INSERT INTO eka_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Joshua kehm tongo ebangenahb ji Jimri re bo lohng nnenlum awohng awohng, kehm gboko tub Ekan mmon no Kami, ji mmon no Jimri, ji mmon no Jera, á lohng go etˈtohngo ji Juda. ");
INSERT INTO eka_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Josua kehm tongo Ekan re, <<Ekan mmon ewame, ka Jehova ellub, Esowo Isreel, wo fere jo tehk-e. Tong-m ji a ma lim; kam-a tiki behr.>> ");
INSERT INTO eka_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Owo Ekan kehm faange re, <<Etingitingi ji, me n lim abiafem bada Jehova Esowo bi Isreel. Ejum ji a, ji m ma lim: ");
INSERT INTO eka_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Eji n nyehne nnobo nobo ekpawobo ji bo limi go Babilon, a ekpohko asilva atahl awubu, a ebahk agul jolo ana mmona nsob, ellubu ene jolo ejang ekilo, kor-m sehng, n kehm dake. Nsol nyia kpee nyia behr go atahng ndi go egame ebehre, akpohko asilva wob nla nsol nyio. ");
INSERT INTO eka_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Josua kehm tumu atiingi etib, bo be song rehng ebehre, song nyehn behr go ege ebehre, a akpohko asilva nyao wob go nla nsol nyio. ");
INSERT INTO eka_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Bo yehke nsol nyio go ebehre, ko ba goji Josua, go esamahr bi Isreel kpee. Bo rod yale gbuul go esamahr bi Jehova. ");
INSERT INTO eka_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Owo Josua , a Isreel kpee kehm rodo Ekan mmon no Jera, a asilva akpohko nyao, a ebahk agul ji jolo ana mmon a nsob, a abon ebe ba nlum a ba nkal, a efong ebe, ebvankang, ejoro, ebehre eje, a ejum ajehng ajehng ji á bele no, tahm a nya go edamme ji Ako. ");
INSERT INTO eka_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Josua kehm bahbe Ekan re, <<Jenji wahnge a ma ko ntong nyia ba kun-r esi? Jehova bahk-a kunu ntong lela.>> Owo anebe Isreel kpee kehm-e tuubu atal, bo tob tuubu ane ebe bako atal, fere jahm bo fi. ");
INSERT INTO eka_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Bo kpu atal bul-e luk ebim, nya sa o tete rehng lela. Egburu erakatahng ji Jehova kehm feere go ndi. Owo wahnge bo lungu edamme jio re, edamme Ako wuku wuku. ");
INSERT INTO eka_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Owo Jehova kehm tongo Josua re, <<Ka kpe fahl, jol eltim ki-a woono. Rod nsoja kpee a na, wo song nok a Eai. Tib m ma-a kak ntula Eai go ega ebo, ane ebe, ejahbe eje, a ndi enye. ");
INSERT INTO eka_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","A bahke limi Eai a ntula bo, ana a limi Jeriko a ntula bo, elyaange ni bahke jolo a, ḿ bahke kpuku nsol nyi ḿ bahke dake a atohkondi ebo ka elnahne. Song noongen, go ebo ajahm ntahk.>> ");
INSERT INTO eka_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Owo Josua a nsoja kpee kehm mehle re bo song nok a Eai. Á jake nsoja enye atahltahl nkpel atahl ara, a nkpel elku(30,000) nyi kpo sahb nˈnok nta, fere tum bo ngare atv, ");
INSERT INTO eka_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","a elkahn nia re: <<Wuungen atung nˈnob. Tumen ane bo song noongo go ebo ajahm ntahk. Kana je fee go njahm ntahk, wahn kpee jolen wake wake wahn jo sik. ");
INSERT INTO eka_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Me, a ane ba li aname bahke song bohko ejahbe ebta, aneblum lˈlohng jo kam-r ana bo limi nyanjehle, e bahke jo be bo. ");
INSERT INTO eka_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Bo bahk-r kame je fee tete e were bo yehke go ejahbe, wo bo bahke bungu re, <Bo kp-r beke ana bo be no nyanjehle.> Wo e lˈbe feere njahm, ");
INSERT INTO eka_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","owo ḿ bahke mehle adi nya ń nong no, song ko ejahbe. Jehova Esowo ebahne, bahk-n kake ejahbe jia go egahna abo. ");
INSERT INTO eka_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Ngare nyi ń lˈko ejahbe jia, kaken agun jahm fi. Limen ji Jehova ma ka elkahn. Nyehnen; m ma-n ka elkahn.>> ");
INSERT INTO eka_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Josua kehm song tv bo, bo kehm mehle atv mao song rehng adi elnoongo, go elka elka ni Betel a Eai, feere go erede bi Eai. Josua kange atv mao go ellong ane. ");
INSERT INTO eka_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Efungfu behre behre etoono efung, Josua kehm mehle a ane ba be, ye, a anebkul Isreel gbo bo mbang asongo go Eai. ");
INSERT INTO eka_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Nsoja kpee nyi jolo a ne jene asongo go ajahbe, song rehng go mbuksong ejahbe. Bo song limi edi erekekv ebo go ejang ebobkal bi Eai, edamme jolo go ebo elka, a ejahbe jio. ");
INSERT INTO eka_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Josua rodo ejum ane atahltahl nkpel ewubbal, a ane atahl awubu re bo song noongo go elka elka ni Betel a Eai, feere erede bio bi ejahbe. ");
INSERT INTO eka_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Bo limi nsoja song yiimi go ebo adi, bo jio kpee ji jolo edi erekekv feere go ejang ebobkal bi ejahbe, bo ji noongo no jolo ejang erede bi ejahbe. Atv mao Josua song yele go edamme. ");
INSERT INTO eka_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Eji ntula Eai nyehne nsoja nyi Isreel, ye a aneblum kpee ba li ejahbe jio kehm mehle elwaare efungfu behre behre re bo nok a anebe Isreel edi ji li kohlo Araba. Wo á kahnem re bob noongo go ebo ajahm ntahk. ");
INSERT INTO eka_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Josua a anebe Isreel kpee yake elbo jo be go ebo esamahr feere njahm njahm, bo jo be asongo go elka emahng. ");
INSERT INTO eka_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Bo kehm lungu aneblum kpee go Eai re bo lohng ba kam anebe Isreel. Elkame ni bo jo kam Josua, ano wo nsoja nyi Isreel were bo yehke go ejahbe. ");
INSERT INTO eka_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Nnenlum awohng awohng kpeem sa go Eai, afi go Betel no ki lohng jo kam anebe Isreel, bo lohngo ejahbe sa nnehme nehme lohng jo kam anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Owo Jehova kehm tongo Josua re, <<Ton elkong ni wob-a go ebo tv go Eai, tib go ega ebo wo m bahk-a kake ejahbe jio.>> Ano wo Josua tono elkong ene tv go Eai. ");
INSERT INTO eka_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Tvtv ana Josua tono elkong nia, ane ba noongo go ekul, kehm lohngo elwaare abahl abahl go adi nya bo noongo no asongo mbuksong mbuksong. Bo yele go ejahbe, song ko ejahbe jio, fere jahm elwaare go agun. ");
INSERT INTO eka_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Aneblum ba Eai keebe kan go njahm me, bo nyehne atˈtohk go ejahbe ma rehng wahre wahre go elbung, bo kpeem bel edi ji bo bahke kpe be tahm. Tib anebe Isreel ba jo be njahm njahm yel go emahng, ebfeere kpˈnoko a ane ba kpi bo kam. ");
INSERT INTO eka_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Eji Josua a anebe Isreel kpee nyehne re ane ba noongo go ajahm ntahk, ebsong yel ko ejahbe, fere nyehn atˈtohk kpˈlohngo go ejahbe, bo kehm sennge fere jo nok a aneblum Eai. ");
INSERT INTO eka_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Ane ba noongo no, eji bo song yel ejahbe jahm fi, kehm feere lohng ba kehme elnoko a anebe Eai, bo sa go elka elka, anebe Isreel go esi ebbal ebbal, Isreel kehm wulu bo jol nnene saam go elkpin, jol nnene bo we-e bobem ana nju. ");
INSERT INTO eka_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Wo ntula Eai wo bo bob-e no bum go elkpin, fere ko-e ba ka Josua. ");
INSERT INTO eka_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Eji anebe Isreel ma wul ane kpee ba bo jo kam go ekulugbe a ekpawumu emahng ,bo ji bo kame bo song rehng, eji bo ma wul nne awohng awohng ebo go ekahngkahng, Isreel kpee kehm feere go Eai song wul erik ane ji jolo go atahng ejahbe. ");
INSERT INTO eka_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Aneblum a anebkal ba bo wulu efung bio jolo ane atahltahl, eltahl a nkpel ewubu (12,000) bo kpee ba lene go Eai. ");
INSERT INTO eka_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Josua tikem feere ebo bi jabbe elkong go ndi bi á tono go ero, tete bo wul nne awohng awohng no lene go Eai. ");
INSERT INTO eka_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Anebe Isreel dˈdaa nsol kpee go ejahbe jia bum elbo, ana ntohkondi, a nsol afang ebo, jang jang ana Jehova tubu Josua elle. ");
INSERT INTO eka_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Ano wo Josua jahme Eai go agun fi kpee, fere lim ejahbe jio fere sa ana ebimbim nkahlkahl. Sa ano nnehme nehme tete rehng efung bia. ");
INSERT INTO eka_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Josua kehm rodo ntula Eai kahn-e ekehd go eti, á sa tokko eti tete elgung. Ngare nyi njul ma lahm Josua kehm tongo bo re, bo fannge ngubjing go eti, rod-e song tahnge tub go ndi go eti mbu jio ji ejahbe. Bo kpu atal song bul-e luk ebim li o tete tub bi lela. ");
INSERT INTO eka_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Josua kehm limi egudu njom ka Jehova Esowo bi Isreel, go ewong ji Ebal, ");
INSERT INTO eka_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","ano wo Mosis nlokeltuma Jehova tongo anebe Isreel. Á limi ana bo nyono go nwer atahm nyi Mosis, egudu njom ji bo ki kiimi atal, nya bo ki ko ekuungu soongo. Egudu jio wo bo limi ajom nya bo kpo jahm fi, a ajom nyao nya elkoono ka Jehova. ");
INSERT INTO eka_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","O, esamahr bi anebe Isreel Josua fiki atahm nya Mosis go atal, nyao nya Mosis nyono ka bo. ");
INSERT INTO eka_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Isreel kpee, ajenne, afono ejahbe, anebkul ebo, atubesi nsoja, a abalamalam, bo yiimi ejang ebbal ebbal bi elkohl atahm ni Jehova, jo seenge ane ba solo no, abalimajom, bo ji li anebe Levi. Egom ane jehko yiimi go mbuksong ewong ji Garisim, bo jehko yiimi go mbuksong ewong ji Ebal, ana Mosis nlokeltuma Jehova ma tohko tong bo, eji á ka bo elle ni elfuulu abone Isreel. ");
INSERT INTO eka_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Eji ma jol ano, Josua kehm ba lung alum atahm nya Jehova kpee, nya elfuulu, a nya elsu, ful ful fuul ana Mosis yeele go nwer atahm. ");
INSERT INTO eka_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Ellum anehng anehng jolem ni Mosis ka elkahn, ni Josua ki lung go ka anebe Isreel kpee, budu anebkal, abonse, a ajenne ajenne nya lene go ebo ellong. ");
INSERT INTO eka_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Eji atul bao ba li feere erede bi aya Jodan wuku bade nsol nyia, ntula Hid, Amor, Kenan, a no Peres, a no Hiv, a no Jebus, bo ji lene go edi awong awong nya li feere erede, agbung gbung awong go erede nfam, fvfo go nkpe agburu aya ma a lꞌkꞌma nyehn egbuk jehko, tete rehng go Lebanon, ");
INSERT INTO eka_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","bo bungu bum nnyo amehng re bo ba nok a Josua a anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Wo eji anebe Gibion wuku ji Josua ma lim anebe Jeriko, a Eai, ");
INSERT INTO eka_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","anebe Gibion kehm toobo re bo nehm anebe Isreel, eji bo lˈtahre elbo. Bo tahme ana ane ba bo tumu bo, bo kake nsol go agbajake abam rod gbade ebvankang ebo, a ayahbe nya ma kul, bo ma baade adi adi. ");
INSERT INTO eka_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Bo kake agbajake nsol go bo agubjing, a akˈkulu akpaketa go akpade nya bo ma baade adi adi. Bo rodo akpawake abred nya ma tub amvmv. ");
INSERT INTO eka_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Bo kehm song kpiri Josua go edi erekekv ji Gilgal, bo kehm tongo Josua a anebe Isreel re, <<E lohng mbang alab. Koon nwongo anahre.>> ");
INSERT INTO eka_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Anebe Isreel kehm bahbe anebe Hiv re, <<Anv, Bahke ma jol re ń lohng a kpidi kpidi, bahke limi renan e bahk kehm koko nwongo anahne?>> ");
INSERT INTO eka_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Bo kehm bungu tong Josua re, <<Wahr aloketum ebahne ba.>> Josua kehm bahb bo re, “Wahn ane a baa? Ń lohng gan ba?” ");
INSERT INTO eka_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Bo kehm bungu re, <<E lohng fee ba. Wahr ebwuk bade egburu nsahm nyi Jehova Esowo ebahne. Wahr ebwuk aka bada ne: nsol kpee nyi á limi go Ijib, ");
INSERT INTO eka_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","wahr ebtob wuk bade ana á limi atul abal ba anebe Amor, bo ji jolo feere ero nfam bio bi aya ma Jodan. Sihon ntul no Hesbon, a Og ntul no Basan, ye ji kuumu go Astarod. ");
INSERT INTO eka_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Anebkul ebahre, a ane ba lene go egahre ejahbe tong-r re, <<Tooben ebjing wahn mehl eljen song kpiri anebe Israel fere tong bo re, <<Wahr aloketum ebahne ba, Koon nwongo anahre.>> > ");
INSERT INTO eka_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Abred enyahre nyaa jolo elfu elfu, eji e gbade elkpang go etahk, efung bi e mehle eljen kpꞌbake go egahne. Wo anv ebwuumu, fere tub amvmv. ");
INSERT INTO eka_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Ayahbe enyahre nyaa jolo nfenfe, anv, ebkul, fere bahnge. Nsol ebjing enyahre nyia a akpaketa jolo nfenfe nfenfe, anv ebkpo alahb fere jak, tib go alaaba mbang nyi e lohng abake. ");
INSERT INTO eka_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Anebe Isreel kehm ba feede nsol ebo kpee, jol bo bahbem Jehova. ");
INSERT INTO eka_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Owo Josua kehm limi elkoono fere ko nwongo a bo, re bo nehm wul bo. Anebkul nfam taame tv, fere ko nwongo. ");
INSERT INTO eka_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Eji ma biingi nfung era nyi anebe Isreel limi elkoono fere ko nwongo a anebe Gibion, anebe Isreel kehm ba wuk re ane baa lene kpidi kpidi kohlo bo, bo lenem fee. ");
INSERT INTO eka_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Owo anebe Isreel kehm mehle asongo, go nfung era bo kehm song rehng go ebo ajahbe: Gibion, Kefira, Biirot, a Kiriad Jearim. ");
INSERT INTO eka_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Anebe Isreel nokem a bo, tibre atubesi anebe Isreel ebko nwongo a bo go mbing nyi Jehova, Esowo bi Isreel. Anebe Isreel kpee kehme elmemme bade atubesi ebo, ");
INSERT INTO eka_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","owo atubesi anebe Isreel kpee kehm faange bo re, <<Wahr ebko nwongo abo go esamahr bi Jehova, Esowo bi Isreel, e nehm ma lak bo abo anv. ");
INSERT INTO eka_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Ejum ji a, ji e bahke bo lim: Nong wahr yaken bo, bo jol go elkpin, eji erem lˈkˈgbo tub-r e lˈgbo go nwongo nyi e ma ko a bo.>> ");
INSERT INTO eka_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Atubesi anebe Isreel kehm bungu re, <<Nong bo jol go elkpin, jo gbakke nkun, fere jo tuk alahb ka ejahbe kpee. Go mbang nyio ji atubesi bungu no bade abo, bo lꞌlim. ");
INSERT INTO eka_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Owo Josua kehm lungu anebe Gibion, kehm bungu a bo re, <<Jenji wahng ka ń kehm ba nehm-r, eji ń tong-r re, <E lohng fee,> na nyehne ga ń lohko lene a kpidi kpidi?” ");
INSERT INTO eka_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Wahn ebbel elsu: Bomo anv asongo, ḿ bahke jo lok-r ana abarake nkun, fere jol abatukalahb ka go etahk Esowo ebame.>> ");
INSERT INTO eka_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Bo kehm faange re, <<Wahr aloeltum eba e limi jia, tibre bo tong-r re, <<Bo tongo alokeltum eba gbul gbul gbuul re, Jehova Esowo bi Isreel ebtong Mosis nloketum ewe re, á ka-n ndi nyia kpee, fere wul nne awohng awohng no lene o egahne esamahr. Wo e bele elfahle ni nkpin enyahre tib esi ejahne, owo wanhge e limi ejum jia. ");
INSERT INTO eka_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Anv e li go egahna abo. Lim-r ejum ajehng ajehng ji kpˈnobo a ji li nseenge go egahne esamahr. ");
INSERT INTO eka_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Ano wo Josua tahre bo go abo nya anebe Isreel, fvfo anebe Isreel wulem nne Gibion awohng awohng. ");
INSERT INTO eka_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Go efung bio Josua limi anebe Gibion bo jol abarake nkun, a abatukalahb ka anebe Isreel kpee, a edi egudu njom ji Jehova, edi jio ji Jehova bahke yehke re bo si. Ano wo bo jo lim tete sik lela. ");
INSERT INTO eka_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Anv eji Adoni-Jedek ntula Jeusalem wuku re Josua ebko Eai, fere rannge ejahbe jio kpee, yeblim Eai a ntula bo ana á limi Jeriko a ntula bo, fvfo ana anebe Gibion ma lim elkoono a anebe Isreel, bobfere jol kohlo bo. ");
INSERT INTO eka_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Ntul noa, a ane ebe bele elfahle gbalee eji bo wuku nsol ana nyia, tibre Gibion jolo egburu ejahbe ji kpi ekpunu, jolo ajahbe etul; gbale sehnge Eai. Aneblum ebo kpee jolo abanokebta ba nno a nno. ");
INSERT INTO eka_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Owo Adoni-Jedek ntula Jeusalem kehm lungu Hoham ntula Hebron, Piram ntula Jamud, Jafia ntula Lakis, Debir ntula Eglon, kehm kpake njahm a bo. ");
INSERT INTO eka_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","Á kehm tongo bo re, <<Baan, wahn ba tob-m nok a Gibion, tibre boblim elkoono a Josua, a anebe Isreel.>> ");
INSERT INTO eka_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Owo atul baa na alon ba anebe Amor, atul ba Jeusalem, Hebron, Jamud, Lakis, Eglon kehm kono asi. Bo kpee kehm mehle, a nsoja ebo, song rod ebo ebta a anebe Gibion kehme elnoko a bo. ");
INSERT INTO eka_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Anebe Gibion kehm tumu ellum tv Josua go edi erekekv ji Gilgal: <<Kana wahr yake, wahr aloketum ebahne ba. Baan ga elwaare, wahn ba tahr-r. Kak-r ebo, tibre atul baa ba anebe Amor bo jio ji kun go ejahbe awong ebkpa njahm re bo ba nok anahre.>> ");
INSERT INTO eka_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Wo Josua kehm mehle go Gilgal a nsoja enye kpee, nyi semme a atahntahn ane kpee ba kpo sahb nˈnok ebta. ");
INSERT INTO eka_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Jehova kehm bungu tong Josua re, <<Ka tiki bel elfahle bada bo; Me n faake bo kak-a go ebo. Jol nnene limm no bahk-a ma yiimi go abo.>> ");
INSERT INTO eka_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Eji Josua ma jen atv atv mao, bomo go Gilgal asongo, Josua song gbede nsoja Amor eji bo ki kahn. ");
INSERT INTO eka_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Jehova limi amahr bil bo go esamahr anebe Isreel, Isreel ga bo go egburu elgake go Gibion. Isreel soro asi jo kam bo mbang mbang nyio nyi Bet Horon, bo wulu bo gbalee mbang mbang nyio nyi Ajeka abola Makkeda. ");
INSERT INTO eka_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Ana bo kpˈbeke go esamahr bi Isreel go mbang nyi lohngo go Bet-Horon asongo go Ajeka, Jehova kehm nake elahb atal go elbung wul ane gbalee. Ba kpo go elahb atal ba ga gbal sehnge ba anebe Isreel wulu akahngkahng. ");
INSERT INTO eka_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Efung bi Jehova faake anebe Amor kak anebe Isreel go abo, Josua bungu tong Jehova go esamahr bi Isreel re, <<Njul sa yiimi go ero bi Gibion, ebareka sa yiimi o, ero edamme ji Aijalon.>> ");
INSERT INTO eka_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Ano wo njul sa no yiimi, wo ebareka sa yiimi, tete anebe Isreel nok ga anebekv ebo, ana bo nyono go Nwer nyi Jasa. Njul sa yiimi go elka elka ni elbung, lahmem ejum efung kohro kohro. ");
INSERT INTO eka_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Efung ana efung bio ka jˈjol, bomo efung bio efung ana bio ka kpe tiki jol, efung bi Jehova wuungu atung go ellum ni nne. Etingitingi Jehova jo nˈnok ka Isreel! ");
INSERT INTO eka_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Owo Josua kehm feere a nsoja enye kehnge go edi erekekv ji Gilgal. ");
INSERT INTO eka_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Ngare nyia atul baa na alon ebbe song biiri go nkpaltal nyi li go Makkeda. ");
INSERT INTO eka_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Wo eji bo ba tong Josua re bobnyehn atul baa na alon behr go nkpaltal nyi li go Makkeda, ");
INSERT INTO eka_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","á kehm bungu tong bo re, “Banngen, agburu atal wahn sahd go nkpaltal nyio, wahn fere yehke ane bum jo baabe. ");
INSERT INTO eka_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Kana rahke! Kamen anebekv ebahne, jo noken toono bo go njahm, kana taame bo yel go ebo ejahbe, tibre Jehova Esowo ebahne, ebfaake bo kak-n go ebo. ");
INSERT INTO eka_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Ano wo Josua a nsoja nyi Isreel soro asi jo wul bo, sa na mmobsake, bo ji male be song yel go ebo ajahbe nya bo si akahme sennge kak. ");
INSERT INTO eka_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Nsoja nyi Isreel kpee feere kehnge, nnene ejum we limem, ba rehng goji Josua edi erekekv, ngo Makkeda, , jol nnene bungem ebi ellum anehng anehng bada anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Josua kehm bungu tong bo re, <<Lennge nnyo nkpaltal nyio wahn yehke atul alon bao ba ka-m.>> ");
INSERT INTO eka_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Owo bo kehm yehke atul alon bao go nkpaltal, ntul no Jeusalem, Hebron, Jamod, Lakis, a Eglon. ");
INSERT INTO eka_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Eji bo ma ko atul bao ba ka Josua, á kehm lungu nsoja Isreel kpee kehm bungu tong atubesi nsoja ba ba a ne re, <<Baan, wahn ba rod akpade enyahne kunu atul baa go bo amel. Owo bo kehm bake ba kunu bo akpade go ebo amel>> ");
INSERT INTO eka_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Josua kehm bungu tong bo re, <<Kana fahl; ntim enyahne ki-n woono. Yiimi tˈtahne, wahn bel esahbeltim. Elkohn ejum ana jia ji Jehova bahke limi anebekv ebahne kpee ba ḿ bahke noko a bo.>> ");
INSERT INTO eka_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Josua kehm wulu atul alon bao kpee, rod bo kpake go nti na elon tete ngare elgung. ");
INSERT INTO eka_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Eji njul ma lahm, Josua kehm kake bo elkahn re bo song fono bo go nti, bo kehm song fono bo, song ro bo kak go nkpaltal nyi bo biiri no. Go nnyo nkpaltal nyio bo bannge agburu atal bum o, nyaa luk o tete rehng lela. ");
INSERT INTO eka_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Efung bio Josua rannge ejahbe Makkeda kpee, fere wul ntula bo, a nne awohng awohng no li go ejahbe jio. Nnene á yakem no sa go elkpin. Á limi ntula Makkeda , ana á limi ntula Jeriko. ");
INSERT INTO eka_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Josua kehm mehle a anebe Isreel go Makkeda song rehng go Libna song nok a bo. ");
INSERT INTO eka_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Jehova tob faake ejahbe jia a ntula bo kak Isreel go ebo. Josua koo ekahngkahng rannge ejahbe jio, fere wul nne awohng awohng. Nnene á yakem no sa go elkpin o. Á limi ntula a bo ana á limi ntula Jeriko. ");
INSERT INTO eka_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Josua kehm kpe sehng o Libna, a Isreel kpee song rehng go Lakis song sennge bo, nok a bo. ");
INSERT INTO eka_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Jehova faake Lakis kak Isreel go ebo, ano wo Josua ga ejahbe jia etoono efung. Ejahbe jia, a nne awohng awohng no jolo o, á wulu bo ekahngkahng jangjang ana á limi go Libna. ");
INSERT INTO eka_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Gana Horam ntula Gejer ebba re á ba tob Lakis, wo Josua nok ga-e a nsoja enye, tete nnene kpeem jol no sa go elkpin. ");
INSERT INTO eka_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Owo Josua, a anebe Isreel kpee kehm mehle a ne o Lakis, asongo go Eglon; song sennge bo, nok a bo. ");
INSERT INTO eka_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Bo bobo ejahbe jia efung bˈnehm bi bo bomo elnoko a bo, wul bo go akahngkahng, fere rannge nne awohng awohng ana bo limi go Lakis. ");
INSERT INTO eka_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Owo Josua a Isreel kpee kehm mehle go Eglon song rehng go Hebron, song nok a bo. ");
INSERT INTO eka_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Bo ko ejahbe jio, fere wul bo go akahngkahng, a ntula bo, a abon ajahbe ebo, a nne awohng awohng no lene o. Nnene bo yakem no sa elkpin. Ana bo limi Eglon, bo tob rannge Hebron kpee a nne awohng awohng go atahng. ");
INSERT INTO eka_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Wo Josua a anebe Isreel kpee mehle a ne, sennge song nok a Debir. ");
INSERT INTO eka_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Bo ko ejahbe jia, a ntula bo, a abon ajahbe ba nse, fere wul bo go akahngkahng. Bo rannge nne awohng awohng no li o kpee. Nnene bo yakem no sa go elkpin. Bo rannge Debir a ntula bo, jang jang ana bo rannge Libna a ntula bo, fvfo ana bo limi Hebron. ");
INSERT INTO eka_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Ana wo Josua ga ajahbe nyaa kpee go erohko jia, a edi awong awong, emahng ji ejang eboblum, a abangenahb awong nya erede nfam, a akpe kpe agburu awong, a atul ebo kpee. Nnene á yakem no sa go elkpin. Josua wulu, ejum ajehng ajehng kpo v elv, jang jang ana Jehova Esowo bi Isreel ka-e elkahn. ");
INSERT INTO eka_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Josua wulu bo, bomo go Kedes Bania tete song rehng go Gaja, sehng o rehng go arohko kpee nya Goseen tete rehng go Gibion. ");
INSERT INTO eka_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Atul baa kpee, a ndi abo, Josua mehle nok a bo go ellohngo anehng ni á mehle ebta a bo, tibre Jehova Esowo bi Isreel, noko ka Isreel. ");
INSERT INTO eka_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Owo Josua kehm feere kehnge a Isreel kpee go edi erekekv ji Gilgal. ");
INSERT INTO eka_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Eji Jabin ntula Hajo wuku bada esehnge ebta bi anebe Isreel, á kehm tumu ellum tv Jobab ntula Madon, a atul ba Simron a Akisaf, ");
INSERT INTO eka_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","á tob tumu tv atul bako ba li li ejang ebobkal ero awong, fere tob tumu tv atul ba Araba ji li ejang eboblum bi Kinered, a atul ba li go abangenahb awong nya li erede nfam, a bao ba li go Nafod Dor ji li feere erede nfam; ");
INSERT INTO eka_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","á tob tumu tv atul ba anebe Kenan, ero a erede nfam; a atul ba anebe Amor, Hid, Peres, Jebus ba li go edi awong awong; a atul ba anebe Hiv ba li go edamme ji Hemon ji li go elwo ni Mijipa. ");
INSERT INTO eka_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Bo lohngo a nsoja ebo kpee, nlong anyˈnya, go amvtv akuungu gbalee. Egburu nlong nrur nsoja, bo ji ruru ana eriki bi nkpe aya. ");
INSERT INTO eka_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Atul baa kpee ba ko nsoja ebo ba kono asi edi ajehng, bo ba limi edi ererkekv ebo go alahb ma Merom, re bo nok a anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Owo Jehova kehm bungu tong Josua re, <<Kana bel elfahle anehng anehng bada bo. Behna ngare nyia, m bahke faake bo kak Isreel go abo, bo kpee bahke jolo akvne akvne. A bahke kiimi anyˈnya ebo alumlum ajahb kpade, wahn fere jamme amvtv akuungu ebo fi.>> ");
INSERT INTO eka_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Owo Josua a nsoja enye kpee kehm ba gbehl bo kohlo alahb ma Merom, kehm noko a bo, ");
INSERT INTO eka_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","wo Jehova kehm yake bo kak Isreel go ebo. Bo ga bo, fere kehm kehme bo kam mbang mbang nyio nyi rehng go Egburu Sidon tete rehng go Misrefod Main, song rehng go edamme ji Mijipa go ero nfam, tete nnene kpeem sa no jolo go elkpin. ");
INSERT INTO eka_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Josua limi bo ana Jehova tong-e no. Á kehm kiimi anyˈnya ebo alumlum ajahb kpade kpee, fere fi amvtv akuungu ebo. ");
INSERT INTO eka_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Ngare nyia Josua feere njahm ba bob Hajo, fere wul ntula bo go ekahngkahng. Hajo jia ji tohko jol ntubesi ejahbe, ji ajahbe atul nyaa kpee. ");
INSERT INTO eka_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Nne awohng awohng ejahbe jia bo wul-e go ekahngkahng, Isreel rannge bo kpee, jol ejum ajehng ajehng ji kpi elv, bo yakem sa. Josua jahme Hajo fi. ");
INSERT INTO eka_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Josua ga ajahbe atul nyaa kpee, a atul ebo, fere wul bo akahngkahng. Á rannge bo kpee, ana Mosis nlokeltum Jehova ka bo elkahn. ");
INSERT INTO eka_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Wo Isreel ejahbe ajehng ajehng bo jahmem fi ji bo si kunu abuntahk, sehngem re Hajo ji Josua jahme no fi. ");
INSERT INTO eka_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Anebe Isreel da nsol nyi ajahbe nyaa kpee, a ntohkondi atohkondi ebo. Wo ane baa kpee, bo wulu bo go akahngkahng, tete bo rannge bo kpee, jol ejumjum saam ji bele elv. ");
INSERT INTO eka_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Ana Jehova ka Mosis nlokeltum ewe elkahn, ano wo Mosis tob ka Josua elkahn, Josua limi kpee, ejumjum jolem ji Josua ki lim, go nsol kpee nyi Jehova ka Mosis elkahn re á lim. ");
INSERT INTO eka_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Ano wo Josua noko ko ndi nyia kpee: edi awong awong, a awumwum adi nya li go ejang eboblum, a ndi nyi Goseen kpee, go abangenahb awong nya li go erede nfam, a edamme ji Araba, a agburu awong kpee nya li go Isreel, a abangenahb awong ebo, ");
INSERT INTO eka_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","bomo go ewong ji Halak ji li feere go Seya tete song rehng go Baal Gad ji li go edamme Lebanon nnahb egburu ewong nyi Hemon. Josua bobo atul ebo kpee, fere wul bo. ");
INSERT INTO eka_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Josua noko ebta a atul bao ekidi sahb lˈlab. ");
INSERT INTO eka_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Nnene limem elkoono a anebe Isreel, sehngem re anebe Hiv ba lene go Gibion ba ba, Isreel ga bo kpee go ebta. ");
INSERT INTO eka_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Jehova antahng antahng wo limi re ntim ebo tahne, eji bo lˈyiimi abohng a Isreel, eji á lˈsehng o wul bo kpee, fere yehke bo jol ndon á beem, ana Jehova ka Mosis elkahn. ");
INSERT INTO eka_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Ngare nyio Josua wulu etˈtohngo ji Anak kpee, bo ji lene go edi awong awong: Hebron, Debir, Anab, go edi awong awong kpee nya li go Juda, a edi awong awong nya li go Isreel. Josua wulu bo kpee, fere rannge ajahbe ebo kpee. ");
INSERT INTO eka_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Go ndi nyi Isreel, nne awohng awohng no Anak saam, go Gaja, Gati, a Asdod wo wo abon amohk anebe Anak sa no. ");
INSERT INTO eka_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Owo Josua kehm koko ndi kpee, jang jang ana Jehova tongo Mosis. Josua bake edi ndi jia ka anebe Isreel ebangenahb ebangenahb ana ejum elehkelkv. Owo ndi bele erekekv go nta anoko. ");
INSERT INTO eka_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","A wo li Atul ba ndi nyia, ba anebe Isreel noko a bo, fere ga bo, fere taare adi ndi ebo go ero bi Jodan, bomo go edamme ji Anon rehng go egburu ewong ji Hemon, tob budu ero nfam bio bi Araba: ");
INSERT INTO eka_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","Sihon ntul no anebe Amor, ye ji kuumu go Hesbon. Á jo fili edi bomo go Aroe ji li nkpe edamme nyi Anon. Bomo go elka edaame, rehng go aya Jabok ma li nkonkon nyi anebe Amon. Ejang ejahbe ji Giled jolo budu o. ");
INSERT INTO eka_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Á tob jo fili ero bio bi Araba bomo go aya ma Kinered tete rehng go agburu aya Araba ma li aya akang, song rehng go Bet-Jesimod, fere feere ejang eboblum, edamme jio ji Pisga. ");
INSERT INTO eka_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Go ejang ndi bi Og ntula Basan, esˈkohro ntul no anebe Refa, ye ji jii jo fili Astarot abola Edrei. ");
INSERT INTO eka_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","Á fili edi bomo go ewong Hemon rehng go Saleka, Basan kpee tete rehng go nkonkon nyi anebe Gesur a Maaka, a ejang Giled rehng go nkonkon nyi Sihon ntula Hesbon. ");
INSERT INTO eka_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Mosis nlokeltuma Jehova, a anebe Isreel ga bo. Wo Mosis faaka ndi ebo ka anebe Ruben, Gad, a ejang etˈtohngo ji anebe Manase, re jol ndi abo. ");
INSERT INTO eka_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Atul ba ndi nyia ba a, ba Josua a anebe Isreel noko a bo, fere ga bo, go ejang erede bi Jodan, bomo go Baal Gad ji li edamme ji Lebanon song rehng go ewong Halak ji li feere go Seir. Josua ka bo ndi atˈtohngo atˈtohngo ana ejum elehkelkv ebo. ");
INSERT INTO eka_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Ndi nyi Josua bake no nya a; edi awong awong, a nya li go abangenahb awong erede nfam, Araba, a nkpale nkpale ewong, a elka emahng feere ejang eboblum - ndi nyio nyi anebe Hid, anebe Amor, anebe Kenan, anebe Pereji, anebe Hiv, a anebe Jebus: ");
INSERT INTO eka_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","ntula Jeriko, ntula Eai( ji li kohlo Betel) ");
INSERT INTO eka_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","ntula Jeusalem, ntula Hebron, ");
INSERT INTO eka_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ntula Jamud, ntula Lakis, ");
INSERT INTO eka_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ntula Eglon, a ntula Geja, ");
INSERT INTO eka_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ntula Debir, ntula Geda, ");
INSERT INTO eka_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ntula Homa, a ntula Arad, ");
INSERT INTO eka_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ntula Libna, ntul Adulam, ");
INSERT INTO eka_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ntula Makkeda, ntula Betel, ");
INSERT INTO eka_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ntula Tapua, ntula Hefa, ");
INSERT INTO eka_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","ntula Afek, ntula Lasaron, ");
INSERT INTO eka_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ntula Madon, ntula Hajo, ");
INSERT INTO eka_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ntula Simron Meron, ntula Akisaf, ");
INSERT INTO eka_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ntula Taanak, ntula Megido, ");
INSERT INTO eka_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ntula Kedesh, ntula Joknam go Kamel, ");
INSERT INTO eka_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ntula Dor ji jolo go Nafod Dor, ntula Goyim go Gilgal, ");
INSERT INTO eka_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","a ntula Tirja. Bo kpee jolo eltahl atul awubu, a ntul awohng. ");
INSERT INTO eka_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","Eji Josua ma sahb kˈkul, owo Jehova kehm-e tongo re, <<Anv wobsahb kˈkul, wo gana adi ndi nyaa kpeka li gbalee ka-n re wahn ko. ");
INSERT INTO eka_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","Adi ndi nya a, nya ma sa: Ajang ndi kpee nya anebe Filista a anebe Gesu: ");
INSERT INTO eka_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","bomo go aya ma Siho, ero bi Ijib, feere ndi nyi Ekron ejang ebobkal. Ndi nyia kpee jolo ndi nyi anebe Kenan: Adi ndi nya jolo ka atul na alon ba Filista nya a, Gaja, Asdod, Askelon, Gati, a Ekron. Ndi nyi anebe Avva; ");
INSERT INTO eka_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","bomo ejang eboblum, ndi kpee nyi anebe Kenan, bomo Ara ji anebe Sidon, sehng tete rehng go Afek, ejang bi anebe Amor, ");
INSERT INTO eka_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","edi jio ji anebe Gebal, a Lebanon kpee, nyi li ero nfam, bomo go Baal Gad ji erede egburu ewong Hemon tete rehng go Lebo Hamad. ");
INSERT INTO eka_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","Bade ane bao ba lene go ajahbe nya kun agburu awong, bomo go Lebanon tete rehng go Misrefod Maim, anebe Sidon bao kpee. Mefono antahng bahke kame bo yehke go esamahr anebe Isreel. Tiki nok wo ka anebe Isreel edi ndi jia ana ejum elehkelkv, ana n tong-a no, ");
INSERT INTO eka_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","fvfo bak ana ejum elehkelkv ka etˈtohngo na ebsehmwubu a ejang etˈtohngo ji Manase.>> ");
INSERT INTO eka_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Ejang etˈtohngo Manase jehko, anebe Ruben, a anebe Gad, bobko ejum elehkelkv bo ji, Mosis ka bo go ero bi aya ma Jodan, Mosis nlokeltuma Jehova wo ka bo. ");
INSERT INTO eka_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","Ndi ebo bomo go Aroe, go nkpe nyi edamme Anon, bomo ejahbe ji li go elka edamme tete rehng go nwahre wahre edi ji li ebale ebale ji Medeba sehng o song rehng go Dibon, ");
INSERT INTO eka_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","fvfo ajahbe kpee nya ntula Amor no bo kpo lung-e re Sihon, ye ji jolo go Hesbon jo fili ane, tete rehng go nkonkon nyi anebe Amon. ");
INSERT INTO eka_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","Giled tob woomo go atahng, ejang bio bi Gesu, a Maaka, a ejang egburu ewong bi Hemon kpee, ndi Basan kpee tete rehng go Saleka, ");
INSERT INTO eka_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","a wo li edi ndi kpee ji ntula Og jo fili go Basan, ye ji kuumu go Astarot abola Edrei, á jolo esˈkohro ntul no anebe Refa. Mosis noko a bo, ga bo, fere ko ndi ebo. ");
INSERT INTO eka_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","Wo anebe Isreel Kamem anebe Gesu, a anebe Maaka, bo soro asi lene go ellong anebe Isreel tete tub bi lela. ");
INSERT INTO eka_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Wo Mosis Kaam etˈtohngo ji Levi edi ndi ajehng ajehng, eji jolo re ayare anyehng anyehng nya bo jo jahm na fi ka Jehova Esowo bi Isreel, nya nya jolo ejum elehkelkv ebo, ana Jehova nyame no tong bo. ");
INSERT INTO eka_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","Ana wo Mosis ka etˈtohngo ji Ruben edi ndi go ebangnahb ebangenahb: ");
INSERT INTO eka_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","Bomo Aroe ji li go nkahl nyi edamme ji Anon, fvfo bomo ejahbe ji wob go elka elka ni edamme, song rehng go nwahre wahre edi ji jolo ebal ebal ji li sehng go Medeba, ");
INSERT INTO eka_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","song rehng go Hesbon, a ajahbe nyaa nya li edi ebal ebal: Dibon, Bamod Baal, Bed Baal Meon, ");
INSERT INTO eka_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","Jahaji, Kedemot, Mefaat, ");
INSERT INTO eka_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","Kiriatayim,a Sibma, a Jeret Saha ji li go ewong ji li go edamme, ");
INSERT INTO eka_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","Bet-peor, agbung gbung nya ewong Pisga abola Bet-Jesimot, ");
INSERT INTO eka_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","budu ajahbe kpee nya li go awahre wahre adi nya li ebal ebal, a ajahbe kpee nya ntula Sihon jo fili. Sihon wo jolo ntul no anebe Amor, ye ji lene go Hesbon, Mosis wul-e wul budu a atul bako ba Media, ana ntula Evi, Rekem, Jur, Hur, Reba, atubesi baa jolo jo fili adi a ntula Sihon. ");
INSERT INTO eka_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","Anebe Isreel wulu Balam mmon no Beor go ekahngkahng, ye ji jolo nnea ntaane, budu ane ba bo wulu go ebta. ");
INSERT INTO eka_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","Nkonandi nyi etˈtohngo ji Ruben jolo nkpe nkpe nyi aya ma Jodan. Ajahbe, a abon ajahbe ba jolo a kpee jolo ejum elehkelkv ka etˈtohngo Ruben, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","Edi ndi ji a, ji Mosis ka etˈtohngo ji Gad ebangenahb abanganahb: ");
INSERT INTO eka_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","Edi ndi ji Jaje, a ajahbe kpee nya li Giled, a ejang nfam ji anebe Amon tete asongo go Aroer ji li kohlo Rabba, ");
INSERT INTO eka_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","fvfo bomo go Hesbon song rehng go Rama Mijipa, a Betonim, sehng go Mahanayim tete song rehng go edi ndi ji Debir, ");
INSERT INTO eka_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","Beth Aram, Bet-nimra, Sukot, a Jafon nya li go edamme, a erik ajahbe nya jolo go elwo ni ntula Sihon ji lene go Hesbon. Nseenge ebo jolo erede ajahbe nyao, sehnge go aya ma Jodan, sehng asongo tete rehng go edi ji agburu aya ma Kineret kohlo no. ");
INSERT INTO eka_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","Ajahbe nyaa a abon erik ajahbe ba jolo a kpee, jolo ejum elehkelkv ka etˈtohngo ji Gad, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","Edi ndi ji a ji Mosis kaa ejang etˈtohngo ji Manase. Ji lohngo re, á kaa ejang abon ba Manase, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","Ndi ebo bomo go Mahanayim, Basan kpee woomo atahng, adi kpee nya woomo ntula Og ji jolo go Basan go elwo, a nsi kpee nyi jolo go Jair, ji Basan, kpee jolo nsi atahl ara, ");
INSERT INTO eka_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","ejang ejahbe Giled, a Estarod abola Endreyi nya li ajahbe nya ntula Og jo fili, ye ji lene go Basan) . Nyaa kpee li ka etꞌtohngo ji Maki ji jolo mmona Manase, jolo ka ejang abon ba Maki, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","Adi elehkelkv nya a, nya Mosis bake no go edi ebale bal ji Moab, a lꞌsiiri aya ma Jodan ero bi Jeriko. ");
INSERT INTO eka_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Wo Mosis kaam etꞌtohngo ji Levi edi ajehng ajehng, tibre Jehova, Esowo bi Isreel, ebnyam re ye wo bahke jolo ejum elehkelkv ebo. ");
INSERT INTO eka_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","A wo li adi nya anebe Isreel ko no ana ejum elehkelkv ebo, go ndi nyi Kenan, nya Elieja nlimanjom, a Josua mmona Nun, a atubesi atˈtohngo Isreel bake ka anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Bo tubu elfaange bake ndi nyio ka etˈtohngo ebsehmwubu kunu ejang, ana Jehova ka Mosis elkahn. ");
INSERT INTO eka_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","Mosis ebtohko ka etˈtohngo ebbal kunu ejang edi elehkelkv ebo go ero aya ma Jodan. Wo Mosis kaam anebe Levi edi elehkelkv ajehng ajehng semme atˈtohngo nyako. ");
INSERT INTO eka_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","Wo abon ba Josef ebjol etˈtohngo na ebbal, Manase abola Efriim. Abone Levi bo bakem ndi anyehng anyehng ka bo, bo ka bo agburu ajahbe nya nya re bo lene, a edi ndi enyam aleke. ");
INSERT INTO eka_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Ano wo abone Isreel baange adi ndi ana Jehova ka Mosis elkahn. ");
INSERT INTO eka_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Owo aneblum ba Juda kehm ba kpiri Josua ngare nyi á li go Gilgal, wo Keleb mmona Jefune ji lohng go Keniji, kehm tongo Josua re, Á kpˈkahne ji Jehova bungu tong Mosis nne Esowo nlokeltum ewe bada a wo a me go Kedes Bania. ");
INSERT INTO eka_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Ngare nyio n jolo nnya atahl abal eji Mosis nlokeltuma Jehova tum-m go Kedes Benia re me n song feede edi ndi jio. N ko ji n nyehne no ba tong-e, ana ntir atahng enyame jolo no. ");
INSERT INTO eka_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Wo abonanee ba e je ano bungu nsol nyi kake ane elfahle. Me, n toono Jehova a eltim eltim ename kpee. ");
INSERT INTO eka_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Fvfo efung bio Mosis tir tong-m re, <<Ndi nyi akpade enya jene no bahke jolo ejum elehkelkv eja, a ji abon eba go njinanjini, tib eji a ma toono Jehova Esowo ebame a eltim eltim ena. ");
INSERT INTO eka_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","Anv ana Jehova ko nwongo, a ma-m bum go elkpin go nnya atahl abal a nnya elon nyia, bomo ngare nyi á bungu nsol nyia sehng go nnyo mi Mosis, ngare nyio nyi Isreel jo yannge go elka emahng ni ki kpi ajele. Nyehn me a lela, m ma kang nnya atahl ani, a nnya elon. ");
INSERT INTO eka_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","N kpeka li eko eko ana n jolo ngare nyi Mosis tum-m no, m bahke ma kpe je ebta anv ana n jo ngare nyio. ");
INSERT INTO eka_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Anv, ka-m edi awong awong jia, ji ji Jehova ko nwongo efung bio. Wofono wˈwuk re anebe Anak lene o, ajahbe ebo jolo agburu ajahbe, bo si akahme sennge ejahbe ebo kak. Wo go ekakebo ji Jehova, m bahke kame bo yehke ana Jehova bungu no. ");
INSERT INTO eka_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Owo Josua kehm fuulu Keleb mmona Jefune, fere ka-e Hebron ana ejum elehkelkv eje. ");
INSERT INTO eka_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Fvfo bomo go ngare nyio Hebron li ka Keleb mmona Jefune, ye ji jolo nnea Keneji, tib eji á toono Jehova Esowo bi Isreel a eltim eltim ene. ");
INSERT INTO eka_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Hebron bo jo lungu wuku wuku re Kiriat Arba, Arba wo lini ebehn mbing nyia, á jolo etahntahn nne no lohng go Anak. Owo ndi re ekv go nta anoko. ");
INSERT INTO eka_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Bo tubu elfaange bak edi ndi ka etˈtohngo ji Juda ji a, ebangenahb ebangenahb, kpange rehng go Edom tete song rehng go elka emahng Jiin ni ki kpi ajele, feere go esˈkohlo ji ejang eboblum. ");
INSERT INTO eka_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","Nseenge nyi ejang eboblum, bomo go nkpe nyi ejang eboblum nyi Aya Akang, ");
INSERT INTO eka_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","sehnge eboblum eboblum bi mbang nyi li go eyake agburu awong Akrabim, song rehng go Jiin, tete song rehng go ejang eboblum bi Kedes-Bania. Tob sehnge go Hejiron rehng go Ada, gahl song rehng go Karka. ");
INSERT INTO eka_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","Ano wo sehnge no, song rehng go Ajimon, kehm song yel go ebgba bi Ijib, song fel go agburu ma a lˈkˈma nyehn egbuk jehko. Nseenge ebo nyi ejang eboblum nyi a. ");
INSERT INTO eka_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","Nseenge nyi ero nfam, jolo go aya akang ,tete song rehng go nnyo mi aya Jodan. Nseenge nyi ejang ebobkal bomo go nkpe aya akang nnyo aya Jodan, ");
INSERT INTO eka_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","sehng asongo ero ero Bet-Hogla, sehng ano ebobkal ebobkal bio bi Bet-Araba, song rehng go eltal ni Bohan ji mmon no nlum no Ruben. ");
INSERT INTO eka_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","Nseenge nyio bomo go edamme ji Ako, asongo go Debir, sehng ebobkal ebobkal asongo go Gilgal, nyi jolo songo songo go mbang nyi li eyake eyake agburu awong nyi bo kpo lung re Adumin. A wo sehnge rehng go ejang eboblum bi edamme, soro asi alahb ma En Semes, tete ba lohng ga En Rogel. ");
INSERT INTO eka_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","Tob sehnge go edamme ji Ben Hinom, feere go edamme ji ejang eboblum bi Jebus ji li Jeusalem. Sehnge asongo, wahr go ewong ji li go erede edamme ji Hinom, song rehng go ekahlsi, ejang ebobkal bi edamme ji Refayiim. ");
INSERT INTO eka_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","Nseenge nyio soro asi go ero ewong song rehng go mbˈbehl alahb ma Neftoa tete ba lohng ga ajahbe nya ewong Efron, feere song rehng go Baala, ji li Kiriat-Jearim. ");
INSERT INTO eka_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","Nseenge kehm kpe sehng erede erede bio bi Baala asongo go egburu ewong ji Seya, sehng nkpe ewong ejang ebobkal, bi Jearim, ji li Kesalon, , sehng asongo go Bet-Semes siiri rehng go Timna. ");
INSERT INTO eka_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","Nseenge nyio soro asi asongo go ejang ebobkal nyi Ekron, sennge asongo go Sikeron, song rehng egburu ewong Baala, song rehng Jabnel. Nseenge song fele agburu aya ma nne lˈkˈnyehn ma egbuk jehko. ");
INSERT INTO eka_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","Nseenge nyi jolo erede nfam, jolo nkpe agburu aya, ma nne lˈkˈma nyehn egbuk jehko. Nseenge nyi jolo sennge anebe Juda nyi a, go ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Ana Jehova Ka Josua elkahn re á ka Keleb ji mmona Jefune, edi ndi go Juda. Josua kehm kake Keleb ejahbe ji bo kpo lung re Kiriat-Aba ji li Hebron. Aba ji jolo nde no nkul no Anak. ");
INSERT INTO eka_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Keleb wo kame anebe Anak yehke go Hebron, bo ane na ara, Sesayi, Ahiman, a Talmayi, bo kpee lohng go ebangenahb ji Anak. ");
INSERT INTO eka_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Edi jio wo á mehle song nok a ane ba lene goDebir wuku wuku bo jo lungu edi jio re Kiriat- Sefer. ");
INSERT INTO eka_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Keleb kehm bungu re, <<Nne awohng awohng no lˈnok a Kiriat Sefer fere ga bo, m bahk-e kake mmon ewame no nkal no bo kpo lung-e re Aksa go elbal.>> ");
INSERT INTO eka_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Otꞌniel mmon no nlum no Kenaji, ji jolo mmonannyehna Keleb wo je song nok a bo fere ga bo. Keleb kehm-e kake Aksa mmon ewe go elbal. ");
INSERT INTO eka_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Efung abehng eji Aksa ba goji Otˈniel, á kehm fanne Otˈniel re á bahb Keleb nde re á ka-e edi ndi. Ana Aksa kpꞌbadde go mbvankang, owo Keleb nde kehm-e bahbe re, <<Jenji a kpꞌsebe re me n lim ka-a?>> ");
INSERT INTO eka_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","Owo á kehm-e faange re, <<Lim ekahmekahme ejum ka-m. Nong me n fil-a ndon, eji a ma-m ka edi ndi ji li go ejang eboblum, tob ka-m mbꞌbehl alahb.>> Owo Keleb kehm-e kake abing alahb nya li go ewong, a edamme. ");
INSERT INTO eka_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","Edi ndi elehkelkv ji a ji bo bake ka etꞌtohngo Juda, go ebangenahb ebangenahb: ");
INSERT INTO eka_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","Ajahbe nyaa nya ga li go ejang eboblum,go etꞌtohngo ji Juda, go emahng ji ejang eboblum, feere go nkonandi nyi Edom: Kabjeel, Ada, Jagu, ");
INSERT INTO eka_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","Kina, Dimona, Adada, ");
INSERT INTO eka_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","Kedes, Hajo, Itꞌnan, ");
INSERT INTO eka_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","Jif, Telem, Bealod, ");
INSERT INTO eka_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","Hajo Hadata, Keriot Hejiron ji li Hajo, ");
INSERT INTO eka_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","Amam, Sema, Molada, ");
INSERT INTO eka_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","Haja Gada, Hesmon, Beti-Peleti, ");
INSERT INTO eka_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","Haja Sual, Beseba Bisiotiya, ");
INSERT INTO eka_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","Baala, Iyim, Ejem, ");
INSERT INTO eka_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","Eltolad, Kesil, Homa, ");
INSERT INTO eka_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","Jiklak, Madmana, Sansana, ");
INSERT INTO eka_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","Lebaoti, Silhim, Ayin, a Rimon, kpee jolo eltahl ejahbe ebsuwubu bi nnen, a abon ajahbe bako ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","Ajahbe nyako nya jolo nnahb ewong nya jolo feere go erede, nya bo tob ka Juda: Estaol, Jora, Asna, ");
INSERT INTO eka_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","Janoa, En Ganim, Tapua, Enam, ");
INSERT INTO eka_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","Jamuti, Adulam, Soko, Ajeka, ");
INSERT INTO eka_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","Saarayim, a Aditayim, a Gedara ji ji tob li Gederotayim, jolo ewubu ejahbe ebni, a abon ajahbe ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","Jenan, Hadasa, Mikdal Gad, ");
INSERT INTO eka_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","Dilen, Mijipa, Joktel, ");
INSERT INTO eka_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","Lakis, Bojikati, Eglon, ");
INSERT INTO eka_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","Kabon, Lamas, Kitlis, ");
INSERT INTO eka_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","Gederoti, Bet Dagon, Naama, Makeda, kpee jolo elku ejahbe ajehng, a abon ajahbe ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","Libna, Eteri, Asan, ");
INSERT INTO eka_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","Ibta, Asna, Nejib, ");
INSERT INTO eka_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","Keila, Akijib, Maresa, ejahbe ebsehmwubu, a abon ajahbe ebo bako ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","Ekron, a nsi nyi senng-e kak, a abon ajahbe ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","Bomo go Erede bi Ekron, ajahbe kpee nya jolo sennge Asdod, a nsi nyi sennge kak, a abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","Asdod, a nsi nyi li senng-e kak, a abon ajahbe ebo ba nse, Gaja, a nsi nyi senng-e kak, a abon ajahbe ebo ba nse, bomo go abongba ba Ijib, tete rehng go abongba Ijib, nkpe nkpe agburu aya ma nne lꞌkꞌma nyehn egbuk ma li Mediterinian. ");
INSERT INTO eka_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","Fvfo go edi awong awong: Samir, Jatir, Soko, ");
INSERT INTO eka_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","Dana, Kiriati Sana ji li Debi, ");
INSERT INTO eka_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","Anab, Estemo, Anim, ");
INSERT INTO eka_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","Gosen, Holon, a Gilo, ewubu ejahbe ajehng, abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","Arab, Duma, Esan, ");
INSERT INTO eka_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","Janim, Bet-Tapua, Afeka, ");
INSERT INTO eka_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","Humta, Kiriat-Abaji li hebron a Jior, ejahbe ebsuwubu, a abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","Maon, Kamel, Jif, Juta, ");
INSERT INTO eka_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","Jejirel, Jokdim, Janoa, ");
INSERT INTO eka_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","Kain, Gibea, a Timna, jolo ejahbe ebwubu, a abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","Halhul, Beti Jur, Gedo, ");
INSERT INTO eka_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","Maarat, Beti Anoti, a Eltekon, ejahbe ebrakebra, a abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","Kiriati Baal ji li Kiriati Jearim, a Raba, ejahbe ebbal, a abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","Go emahng ji ajele kꞌlꞌmahng: Beti Araba, Midin, Sekaka, ");
INSERT INTO eka_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","Nibsan, ejahbe akang, a En Gedi, ejahbe ebrakebra, a abon ajahbe ebo bako ba nse. ");
INSERT INTO eka_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Anebe Juda maam kam anebe Jebus yehke, bo ji lene go Jeusalem, tete sik anebe Jebus baa kpeka lene semme a anebe Juda tete sik lela. ");
INSERT INTO eka_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","Bo tumu elfaange bak edi ndi ka etˈtohngo ji Josef, edi elehkelkv ebo bomo go aya ma Jodan, ero bio bi ngba nyi Jeriko, sehng go elka emahng ji kꞌlꞌmahng ajele tete song rehng go edi awong awong ji Betel. ");
INSERT INTO eka_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","Sehng o Betel ji bo jo lung re Luji siiri song rehng go Ataroti ji li go elwo ni anebe Arki, ");
INSERT INTO eka_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","feere ejang erede erede bio bi anebe Jafleti, tete rehng go ejang erede bi Beti Horon, song rehng go Gejer, tete song fel go agburu aya ma nne lꞌkꞌma nyehn egbuk jehko ji li Mediterinian. ");
INSERT INTO eka_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","Ano wo Manase, a Efriim bo ji lohng go etˈtohngo ji Josef ko edi elehkelkv ebo. ");
INSERT INTO eka_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","Ana wo bo bake ndi nyia ka Efriim, bo bake ebangenahb ebangenahb: Nseenge edi elehkelkv ebo, bomo go Ataroti Ada jio ji li go ero bi Beti Horon, ");
INSERT INTO eka_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","sehng song yel agburu aya ma nne lꞌkꞌma nyehn egbuk jehko. Bomo go Mikmetad, ji li go ejang ebobkal, gahl feere go ero nfam asongo go Taanati Silo, nkpe nkpe song rehng go Janoa ji li go ero nfam. ");
INSERT INTO eka_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","Ano wo sehnge nkpe nkpe nyio nyi Janoa song rehng go Ataroti, a Naara, sehng song kooro Jeriko, fere ba lohng go aya ma Jodan. ");
INSERT INTO eka_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","Bomo go Tapua, nseenge feere erede erede, toono nrabbe ebgba bi Kana, fere song fel go agburu aya ma nne lꞌkꞌma nyehn egbuk jehko. Ana wo etˈtohngo ji Efriim ko ndi ebo ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","Bo tob ka bo abon ajahbe ba nlen, a ba nse, nya bo bumu eje eje ka anebe Efriim go ellong nsol elehkelkv nyi anebe Manase. ");
INSERT INTO eka_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","Bo kamem anebe Kenan ba jolo go Geja; Tete tub lela anebe Kenan baa go lene ellong anebe Efriim, wo anebe Efriim kpo ko bo fubu eltum. ");
INSERT INTO eka_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","Bo tubu elfaange bak edi ndi ka ejang etˈtohngo ji Manase. Manase ana ngbokambang a mmon no Josef. Makiri wo ko ejum elehkelkv, ye ji jolo ngbokambang a mmon no Manase. Makiri wo li nde no anebe Giled. Yeb tohko ko Giled, a Basan, tibre anebe Makiri jolo atahntahn abanokebta. ");
INSERT INTO eka_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","Mbake nyia joko ka erik ane bako go ellong anebe Manase, go abangenahb nyaa, Abieja, Helek, Asriel, Sekem, Hefa, a Semida. A wo li erik aneblum bako etˈtohngo ji Manase mmona Josef, go ebo ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","Ana jolo o, Selofehad mmon no Hefa, ye ji Giled jel-e no, Giled ji jolo mmon no Makiri, ye ji Manase jel-e no, jelem mmon awohng awohng no nlum. Á jele abon ba nkal ba ba . Abing ebo nya a, Mala, Noa, Hogla, Milka, a Tisa. ");
INSERT INTO eka_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","Abon ba nkal baa kehm mehle song kpiri Elieja nlimanjom, a Josua mmona Nun, a atubesi ejahbe ba Isreel, kehm bungu re, <<Jehova ka Mosis elkahn re, á ka-r mbaka ndi nyˈnyahre ana bo ka abonanyehn ba nlum go egahre ellong. Josua kehm kake bo ejum elehkelkv semme a ellong abonanyehn nde ebo, jang jang ana Jehova bo elkahn. ");
INSERT INTO eka_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","Manase bo bake ka-e erohko ndi na ewubu, kehm budu ejang bi Giled, a bi Basan, ji li ero bi aya ma Jodan, ");
INSERT INTO eka_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","tibre abon ba nkal go etˈtohngo ji Manase ko mbake ana abon ba nlum. Edi ndi ji Giled, li ka erik etˈtohngo ji Manase. ");
INSERT INTO eka_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","Edi ndi ji Manase bomo go Aser, rehng go Mikmetati go ero bi Sekem. Nseenge nyio feere eboblum eboblum bio bi Mikmetati sehng goji ane ba lene kohlo elbing alahb ni En Tapua. ");
INSERT INTO eka_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","Ndi nyi Tapua li ka Manase, yefono Tapua li go nseenge nyi Manase, li ka anebe Efriim. ");
INSERT INTO eka_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","Nseenge sehnge asongo eboblum eboblum, song rehng go nrabbe ebgba bi Kana. Ajahbe jˈjol nya jolo ka anebe Efriim nya li nkpe nkpe nyi ajahbe nya Manase, wo nseenge nyi Manase jolo go nkpe nyi ejang ebobkal bi nrabbe ebgba tete song rehng agburu aya ma nne lˈkˈ ma nyehn egbuk jehko. ");
INSERT INTO eka_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","Ejang eboblum ndi nyio jolo ka aneb Efriim, go ejang ebobkal jol ka anebe Manase. Ndi nyi Manase kpange rehng go aya ma nne lˈkˈma nyehn egbuk jehko, á kpi nseenge a Aser go ejang ebobkal, go ero nfam nseenge rehnge go Isaka. ");
INSERT INTO eka_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","Atahng ajahbe nya Isaka, a Aser, Manase tob kpi Beti-San, Ibleyam, a anebe Dor ji li anebe Dor, Endo, Taanak, Megido, a nsi nyi li sennge kak. (Etoono ebra jolo Nafod) ");
INSERT INTO eka_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","Jol tvtv o, etˈtohngo ji Manase maam lene abon ajahbe bao kpee. Tib anebe Kenan bumu ntir abo re bo tiki lene erohko ndi jio. ");
INSERT INTO eka_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","Wo eji anebe Isreel gbale go atahne. Bo rodo anebe Kenan bum aju, bo jo loko bo. Bo kamem bo kpee yehke go ebo ejang ejahbe. ");
INSERT INTO eka_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","Owo etˈtohngo ji Josef kehm ba kpiri Josua, kehm-e bahbe re, <<Jenji wahnge a bahk-r kake edi ndi ajehng ji ji ana edi elehkelkv? Wahr ebjol go nrur, Jehova ma-r fuulu gbˈgbal. ");
INSERT INTO eka_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Josua kehm faange re, <<Lˈjol re wahn ebrur sehng, lˈfere jol re edi ndi ji edi awong awong ji Efriim gbalem ka-n, song-n go ekulugbe wahn song ja edi ndi ka enahne, go edi ji anebe Peres, a anebe Refa.>> ");
INSERT INTO eka_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Anebe Josef kehm bungu re, <<Edi awong awong wahr gbalem, ga anebe Kena ba li go ebal kpi amvtv akuungu, bo ji lene go Beti San, a nsi ebo, a bo ji li go edamme ji Jejireel. ");
INSERT INTO eka_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Wo, Josua kehm tongo etˈtohngo ji Josef, ji li Efriim a Manase, <<Wahn ebrur, fere tˈtahne, ń nehm bel edi ndi ajehng ji ji, ");
INSERT INTO eka_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","bo bahke tob ka-n ekulugbe jio ji edi awong awong. Ja-n ana bahk-n gbale, jol jˈjahne; Jol afi anebe Kenan bele amvtv akuungu, afi bo bele atahne, ḿ bahke ma kam bo yehke.>> ");
INSERT INTO eka_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","Anebe Isreel kpee kehm ba kono edi ajehng go Silo, kehm sehke Ebkpatahk Elwane, ngare nyia Isreel ebko ndi nyio kpee. ");
INSERT INTO eka_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","wo ngare nyia ebsa etˈtohngo na ebsehma bi bo kala ka bo edi ndi ji elehkeltv ebo. ");
INSERT INTO eka_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Josua kehm tong anebe Isreel re, <<Bahke kange renan, ji ń kpꞌsiki, kehm mehle song ko adi ndi nya Jehova, Esowo bi babnso ejahne ka-n no?>> ");
INSERT INTO eka_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Yehken ane ara ara, go etꞌtohngo ajehng ajehng. M bahke tumu bo re, bo song feede edi ndi jia fere nyon bade ana bo bahke bake ejum elehkelkv ka etꞌtohngo etꞌtohngo. Bo bahke feere ba tong-m. ");
INSERT INTO eka_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","Bo bahke bake edi ndi jio edi na ebsehma. Anebe Juda bahke sake go ebo a ndi, ejang eboblum, a anebe Josef go ebo a ndi, ejang ebobkal. ");
INSERT INTO eka_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Eji ḿ ma nyon bade ana edi ndi ebsehma bio li no, ko-n ba ka-m, me n tub elfaange ka-n go esamahr bi Jehova Esowo ebahre. ");
INSERT INTO eka_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","Anebe Levi belem edi elehkelkv ajehng ajehng semme anahne, tibre eltum ni njom alimi ni li ejum elehkelkv ebo, ni bo kpo lim ka Jehova. Etꞌtohngo ji Gad, a ji Ruben, a ejang etꞌtohngo ji Manase, bob ko mbake ebo go ero nfam , ejang bio bi Jodan. Mosis nlokeltuma Jehova, wo ka bo. ");
INSERT INTO eka_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Ana ane baa mehle asongo re bo song nyehn edi ndi, Josua tubu bo elle re, <<Songen, wahn song nyehn edi ndi, fere nyon ana edi ndi jio li no. Ko-n ba kam, m bahke tubu elfaange ka-n a Silo, go esamahr bi Jehova.>> ");
INSERT INTO eka_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Ano wo aneblum bao mehle no yannge kpee go ndi nyio, fere nyon ana bo nyehne no ejahbe ejahbe kak go nwer. Bo bake ndi nyio go edi na ebsehma, feere ba kpiri Josua go edi erekekv go Silo. ");
INSERT INTO eka_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Josua kehm tubu elfaange ka bo go esamahr Jehova go Silo, kehm bake anebe Isreel edi ndi jio ana bo li no, etꞌtohngo etꞌtohngo. ");
INSERT INTO eka_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","Ngbokambang elfaange gbo tub etꞌtohngo ji Benjamin, ebangenahb ebangenahb. Edi elehkelkv ebo li go elka elka ni etꞌtohngo ji Juda abola Josef: ");
INSERT INTO eka_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","Nseenge nyi jolo ejang ebobkal, bomo go aya ma Jodan, sehng ano go ejang ebobkal bi Jeriko, sehng feere erede asongo go edi awong awong, tete ba lohng go elka emahng ni kꞌlꞌmahng ajele ni Beti Aven. ");
INSERT INTO eka_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","Siiri o song rehng go ejang eboblum, asongo go Lujiji li Betel, sehng asongo go Ataroti Ada ji kun go ewong, ejang eboblum bi Beti Horon ji rede rede. ");
INSERT INTO eka_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","Nseenge sehnge ejang eboblum go erede, bomo ewong ji li mbuksong nyi Beti Horon, tete song kohlo go ejahbe ji bo kpo lung re Kariati Baal(ji li Kariat Jearim, ejahbe jia wob go ellong ajahbe nya li ka Juda. A wo li erede nfam . ");
INSERT INTO eka_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","Nseenge nyi ejang eboblum bomo go esi ejahbe ji Kariati-Jearim, sehnge ano erede nfam, erede nfam, tete ba lohng go mbꞌbehl alahb nyi Neftoa. ");
INSERT INTO eka_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","Nseenge sehnge asongo nkpe ewong nkpe ewong nyi li wane edamme jio ji Ben Hinom, ejang ebobkal bi edamme ji Refiam. Ano wo sehnge go edamme ji Hinom, mbang nyi fi nkpale nkpale go ejahbe ji anebe Jebus, tete rehng go En-Rogel. ");
INSERT INTO eka_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","Fere gahl feere ebobkal asongo go En-Semes, tete rehng go Gelilod ji li songo songo mbang awong nyi Adumim, song rehng go eltal ni Bohan ji mmon no nlum no Ruben. ");
INSERT INTO eka_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","Sehnge o asongo nkpe nkpe egburu ewong ji Beti Araba, tete song rehng Araba. ");
INSERT INTO eka_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","Tob sehnge asongo ejang ebobkal, nkpe nkpe egburu ewong ji Beti Hogla, tete ba lohng go efabe agburu aya akang ma a lˈkˈma nyehn egbuk jehko, ma ba wane go nnyo aya ma Jodan. Nseenge nyi ejang eboblum nyi a. ");
INSERT INTO eka_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","Aya ma Jodan ma jolo nseenge go ero nfam. Adi ndi nya a, nya tibi nseenge nyi ejum elehkelkv ji abangenahb nya Benjamin ajang kpe kpe. ");
INSERT INTO eka_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","Agburu ajahbe nya a, nya bo ka etꞌtohngo ji Benjamin: Jeriko, Beti Hogla, Emek-Kejii, ");
INSERT INTO eka_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","Beti Araba, Jemarayim, Betel, ");
INSERT INTO eka_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","Avim, Para, Ofra, ");
INSERT INTO eka_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","Kefa Amoni, Ofni, a Geba, kpee jol egburu ejahbe ewubu ejahbe ebbal a abon ajahbe ba nse. ");
INSERT INTO eka_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","Gibion, Rama, Beeroti, ");
INSERT INTO eka_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","Mijipa, Kefira, Moja, ");
INSERT INTO eka_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","Rekem, Ipiil, Tarala, ");
INSERT INTO eka_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","Jela, Haelef, a ejahbe anebe Jebus ji li Jeusalem, Gibea, a Kiriati, jolo ewubu ejahbe ebni, a abon ajahbe ba nse. Nyaa nya jolo ejum elehkelkv ji etꞌtohngo ji Benjamin a ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","Etoono elfaange ni bo tubu no gbo tub etˈtohngo ji Simion, ebangenahb ebangenahb. Edi elehkelkv ebo woomo ejang ejahbe ji etˈtohngo ji Juda. ");
INSERT INTO eka_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","Ajahbe nya a, nya wob go atahng: Beeseba a Seba, Molada, ");
INSERT INTO eka_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","Haja-Sual, Bala, Ejem, ");
INSERT INTO eka_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","Eltolad, Betul, Homa, ");
INSERT INTO eka_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","Jiklag, Beti-Makaboti, Haja-Susa, ");
INSERT INTO eka_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","Beti-Lebaoti, a Saruhen, kpee jolo ewubu ejahbe ebra, a abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","Ain, Rimon, Ede, a Asan, egburu ejahbe ebni, a abon ajahbe ebo ba nse, ");
INSERT INTO eka_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","ajahbe kpee nya li sennge agburu ajahbe song rehng go Baalati Beer ji li Rama go elka emahng ni kˈlˈ mahng ajele. A wo jolo edi elehkelkv ji etˈtohngo ji Simion, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","Edi elehkelkv ji li ka etˈtohngo ji Simion lohng go edi elehkelkv ji etˈtohngo ji Juda, tibre edi ndi ji bo ka etˈtohngo ji Juda gbale sehng ana bo jol-e kake. Ano wo anebe Simion ko edi elehkelkv ebo go atahng edi elehkelkv ji etˈtohngo ji Juda. ");
INSERT INTO eka_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","Go elfaange ebra nyi bo tubu no, gbo tub etˈtohngo ji Jebulon, ebangenahb ebangenahb. Nseenge edi elehkelkv ebo jolo tete rehng Sarid. ");
INSERT INTO eka_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","Sehng o jo tahm erede erede, song rehng go Marala, sehng kooro Dabeseti, ano wo sehnge song rehng abongba ba li kohlo Jokneam. ");
INSERT INTO eka_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","Ano wo sehnge asongo go Sarid, ero nfam, ero nfam, ji njul kpo lohng, tete song rehng nseenge nyi Kisloti Tabor, sehnge asongo go Daberati tete rehng go Jafia. ");
INSERT INTO eka_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","Owo soro asi ano, ero nfam, ero nfam, rehng Gati-hefa, a Eti Kajin, ba lohng ga Rimon, song gahl asongo go Nea. ");
INSERT INTO eka_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","Nseenge nyi ejang ebobkal sehnge Hanaton tete song rehng go edamme ji Ipta El. ");
INSERT INTO eka_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","Ajahbe nya jolo o nya a, Kata, Nahalal, Simron, Idala, a Betlehem, agburu ajahbe jolo ewubu ejahbe ebbal, a abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","Ajahbe, a abon ajahbe ba edi elehkelkv nya bo bake ka Jebulon nya a, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","Go elfaange eni nyi bo tubu no gbo tub etˈtohngo ji Isaka, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","Nseenge ebo nyi sehnge go Jejireel, Kesuloti, Sunem, ");
INSERT INTO eka_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","Hafarayim, Sion, Anaharati, ");
INSERT INTO eka_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","Rabiti, Kision, Ebeji, ");
INSERT INTO eka_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","Remeti, En-ganim, En-hada, Beti-Pajiji, ");
INSERT INTO eka_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","Nseenge ebo kooro Tabo, Sahajuma, Beti-Semes, sehnge ano tete song kohlo go aya ma Jodan, jolo elku egburu ejahbe ajehng, a abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","Agburu ajahbe nyaa, a abon ajahbe ebo ba nse, nya nya jolo edi elehkelkv ji etˈtohngo ji Isaka, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","Go elfaange na elon, nyi bo tubu no gbo tub etˈtohngo ji Aser, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","Ajahbe nyaa nya tob woomo go atahng: Helkati Hali, Beten, Aksaf, ");
INSERT INTO eka_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","Alammelek, Amad, a Misal. Nseenge nyi jolo go erede nfam sehnge go Kamel song rehng go Siho-libnati. ");
INSERT INTO eka_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","Tob sennge asongo ero bi Beti-Dagon, tob kooro Jebulon, Edamme ji Ipta El, fere feere ejang ebobkal asongo go Beti-Emek, a Neiel, ano wo yabe Kabul tv ejang ebobkal. ");
INSERT INTO eka_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","Sehnge song rehng go Abdon, Rehob, Hamon, a Kana tete song rehng go Sidon ji kpˈgake gbal. ");
INSERT INTO eka_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","Nseenge nyio fere sehnge asongo go Rama, sehng asongo go Taya ji si ekahme sennge elbo kak, ba rehng go Hosa, fere sehng song lohng aya ma nne lˈkˈ nyehn egbuk jehko, go ejang ndi nyi Akjib, ");
INSERT INTO eka_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","Uma, Afek, a Rehob. Jolo eltahl egburu ejahbe ebbal, a abon ajahbe ebo ba nse. ");
INSERT INTO eka_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","Agburu ajahbe nyaa, a abon ajahbe ebo ba nse, nya nya jolo edi elehkelkv ji etˈtohngo ji Aser ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","Go elfaange erakera ni bo tubu no, gbo tub etˈtohngo ji Naftali, ebangenahb ebangenahb: ");
INSERT INTO eka_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","Nseenge ebo bomo go Helef a egburu eti ji Jaananim, sehng asongo go Adami Nekeb, a Jabnel rehng go Lakum, song fel go aya ma Jodan. ");
INSERT INTO eka_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","Nseenge sehnge feere erede, sehng go Ajinoti Tabor tete ba lohng go Hukok. Nseenge kooro Jebulon go ejang eboblum, go erede kooro Aser, a Aya ma Jodan go ero nfam. ");
INSERT INTO eka_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","Ajahbe nya bo si akahme sennge kak nya a, Jidehm, Jer, Hamati, Rakati, Kinereti, ");
INSERT INTO eka_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","Adama, Rama, Hajo, ");
INSERT INTO eka_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","Kedes, Edrei, En Hao, ");
INSERT INTO eka_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","Iron, Mikdal El, Horem, Beti-Anati, Beti Semes, jolo elku egburu ejahbe ebni, a abon ajahbe ebo ba nse . ");
INSERT INTO eka_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","Agburu ajahbe nyaa, a abon ajahbe ebo ba nse, nya nya jolo edi elehkelkv ji etˈtohngo ji Naftali, ebangenahb ebangehb. ");
INSERT INTO eka_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","Go elfaange esehma nyi bo tubu no gbo tub etˈtohngo ji Dan, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","Nseenge nyi edi elehkelkv rehng: Jora, Estaol, Ir Semes, ");
INSERT INTO eka_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","Saalabin, Aijalon, Itla, ");
INSERT INTO eka_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","Elon, Timna, Ekron, ");
INSERT INTO eka_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","Elteke, Gibeton, Baalati, ");
INSERT INTO eka_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","Jehud, Bene Berak, a Gati Rimon, ");
INSERT INTO eka_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","Me Jakon, a Rakon, a edi ji li go mbuksong nyi Jopa. ");
INSERT INTO eka_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","Riidi etˈtohngo ji Dan sehng re bo kehm koko edi ebo go ebo ane ba tohko jol o. Bo mehle song nok a Lesem, wul nne awohng awohng o, fere ko ndi bo fere jol o. Bo lene go Lesem, feere yaange mbing ejahbe nyio, jo lung re Dan, mbing nyi nde ebo no nkul. ");
INSERT INTO eka_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","Agburu ajahbe nyaa, a abon ajahbe ebo ba nse, nya nya jolo edi elehkelkv ji etˈtohngo ji Dan, ebangenahb ebangenahb. ");
INSERT INTO eka_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","Eji bo ma baange ndi nyia kpee mal, arohko arohko, anebe Isreel kehm kimi edi tob ka Josua mmona Nun, edi elehkelkv á tob jol o a bo, ");
INSERT INTO eka_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","ana Jehova ka bo elkahn. Ajahbe nya á bahbe re bo ka-e nya nya bo ka-e no, ana Timnati Sera ji li go edi awong awong ji Efriim. Josua si ejahbe jio fere lene o. ");
INSERT INTO eka_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","Adi ndi nya a, nya Elieja nlimanjom, a Josua mmona Nun, a atubesi ba abangenahb ba atˈtohngo nya anebe Isreel, bake go elfaange ni bo tubu go Silo, go esamahr Jehova. Bo yiimi go mbuga mi Ebkpatahk Elwane. Ano wo mbake nyi adi ndi nyaa kohlo no. ");
INSERT INTO eka_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Owo Jehova kehm bungu tong Josua re, ");
INSERT INTO eka_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","<<Tong anebe Isreel bo yehke ajahbe elbeke biiri, ana m bungu tong-n sehng go nnyo mi Mosis, ");
INSERT INTO eka_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","ngare anyehng anyehng nyi nne lˈwul nne go efin, eji á ki-e wul elrang, á bahke beke song yel o, eji akunu nya nkvne lˈki-e ba wul, bongo go alung ma ma fad. ");
INSERT INTO eka_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","Á lꞌbe asongo go ekahmekahme ajahbe nyao , á bahke sake yiimi go eti mbu ji ejahbe jio, tooro ajehng ajehng ana jolo no tong anebkul nfam ba ejahbe jio. Owo bo bahk-e koko ka-e edi re á jol a bo ejahbe bo. ");
INSERT INTO eka_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","Ababꞌbongo ba kpˈsebe re bo bongo go alung ma ma fad, kpe-e kame lꞌba, anebkul ejahbe kꞌtiki yehke nne noo ka, tibre nne noo wulem nne ebjing ewe go elrang, afi go ebi ntir. ");
INSERT INTO eka_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","Nne noo bahke sake ejahbe jio tete bo lam elam eje gbul gbul gbuul, fvfo tete ngare nyi Ntubesi nlimanjom no jolo no ngare nyi efin bio limi no kpo. Owo á bahke feere kehnge go ege etahk, go ege ejahbe ji a be no. ");
INSERT INTO eka_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Bo yehke Kedes ji li go Galili, edi awong awong ji Naftali, a Sekem edi ndi ji Efriim ji jolo awong awong, a Kariati-Abaji li Hebron li go edi awong awong ji Juda. ");
INSERT INTO eka_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","Go ero bi aya ma Jodan kohlo Jeriko, bo yehke Bejar ji li go elka emahng ni ki kpi ajele, go ero ewong ji li ebal ebal, go etꞌtohngo ji Ruben, bo tob yehke Ramoti ji li go Giled ji etꞌtohngo ji Gad, a Golan ji li go Basan, ji li go etꞌtohngo ji Manase. ");
INSERT INTO eka_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","Nne Isreel awohng awohng, afi jolo njenne, nyi lene a bo, lꞌwul nne go efin bahke ma be, song yel go ajahbe nya bo ma yehke, abꞌbongo ba bahke sebe re bo bongo alung mao, bo kehm lame elam eje gbul gbul gbuul, nehm ma lim ano. ");
INSERT INTO eka_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","Atubesi ba anebe Levi kehm ba kpiri Elieja nlimanjom, a Josua ji mmona Nun, a atubesi bako ba atˈtohngo nyako nya Isreel ");
INSERT INTO eka_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","kehm ba tong bo go Silo go Kenan re, <<Jehova bungu sehng go nnyo mi Mosis re, wahn ka-r agburu ajahbe wahr lene, a edi ndi ji enyam aleke. ");
INSERT INTO eka_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Owo anebe Isreel kehm kake anebe Levi ajahbe nyao, a edi ndi ji enyam aleke, go ebo ejum elehkelkv ana Jehova ka elkahn: ");
INSERT INTO eka_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","Ngbokambanga elfaange ni bo tubu no gbo tub anebe Kohad, ebangenahb ebangnahb. Anebe Levi, bo ji lohng ebangenahb ji Eron nlimanjom, bo ka bo ewubu egburu ejahbe ebra. Ajahbe nyaa kpee lohng go atˈtohngo nyaa; Juda, Simion, a Benjamin. ");
INSERT INTO eka_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","Erik etˈtohngo ji anebe Kohati, bo ka bo agburu ajahbe na ebwubu, nya lohng go atˈtohngo nya Efriim, Dan, go ejang etˈtohngo ji Manase. ");
INSERT INTO eka_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","Ebangenahb ji Gosen bo ka bo ewubu egburu ejahbe ebra, nya jolo go etˈtohngo ji Isaka, Asa, Naftali, a ejang etˈtohngo ji Manase ji li go Basan. ");
INSERT INTO eka_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","Go ebangenahb ji Merari, go ebangenahb ebangenahb, bo ko ewubu egburu ejahbe ebbal, nya lohng go etˈtohngo ji Ruben, Gad, a Jebulon. ");
INSERT INTO eka_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","Ana wo anebe Isreel ka anebe Levi ajahbe nyaa, a edi ndi ji enyam aleke, ana Jehova ka Mosis elkahn. ");
INSERT INTO eka_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","Go etˈtohngo ji Juda, a Simion, bo bake agburu ajahbe nyao, go mbing a mbing. ");
INSERT INTO eka_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","Ajahbe nyaa bo bake ka ebangenahb ji Eron, bo ji lohng go ebangenahb ji Kohati, ji lohng go ebangenahb ji Levi. Tibre bo ba ngbokambang elfaange ni bo tubu no, gbo tub bo. ");
INSERT INTO eka_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","Bo ka bo Kiriati-Arba ji li Hebron. A edi ndi ji enyam aleke, ji li sennge bo kak, li go edi awong awong ji Juda. (Aba wo jolo ndea nde no nkul no Anak). ");
INSERT INTO eka_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","Wo adi ndi, a abon ajahbe ba li sennge ejahbe jia bob tohko ka Keleb ji mmona Jefune, ana edi elehkelkv eje. ");
INSERT INTO eka_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","Go ebangenahb ji Eron nlimanjom, bo ka Hebron ejahbe ji nne no bo tongo re yeb wul nne, á bahke bake song biiri). Bo tob ka bo Libna, ");
INSERT INTO eka_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","Jati, Estemoa, ");
INSERT INTO eka_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","Holon, Debir, ");
INSERT INTO eka_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","Ain, Juta, a Beti Semes, semme edi ndi ji enyam aleke, jolo egburu ejahbe ebsuwubu bi lohng etˈtohngo jia na ebbal. ");
INSERT INTO eka_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","Go etˈtohngo ji Benjamin, bo ka bo Gibion, Geba, ");
INSERT INTO eka_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","Anatoti, a Almon, semme edi ndi ji enyam aleke, jolo egburu ejahbe ebni. ");
INSERT INTO eka_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","Nfange ajahbe nyi, jolo ka abalimajom, bo ji lohng go ebangenahb ji Eron, jolo ewubu ejahbe ebra, semme edi ndi ji enyam aleke. ");
INSERT INTO eka_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","Erik ebangenahb ji Kohati ji lohng go etˈtohngo ji Levi, bo ka bo ajahbe nyaa, nya lohng go etˈtohngo ji Efriim: ");
INSERT INTO eka_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","Go edi awong awong ji Efriim, bo ka bo Sekem, ejahbe ji nne lˈwul nne, á bahke bake biiri bo tob ka bo Gejar, ");
INSERT INTO eka_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","Kibjayim, Beti Horon, semme edi ndi ji enyam aleke, jolo egburu ejahbe ebni. ");
INSERT INTO eka_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","Fvfo go etˈtohngo ji Dan bo ka bo Elteke, Gebeton, ");
INSERT INTO eka_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","Aijalon, Gati rimon, a edi ndi ji enyam aleke, jolo egburu ejahbe ebni. ");
INSERT INTO eka_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","Go ejang etˈtohngo ji Manase, bo ka bo Taanak, Gati Rimon, a edi ndi ji enyam aleke, jolo egburu ejahbe ebbal. ");
INSERT INTO eka_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","Ejahbe ebwubu bio kpee, a edi ndi enyam aleke, bo ka erik ebangenahb ji Kohati. ");
INSERT INTO eka_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","Ajahbe nya a nya bo ka ebangenahb ji Gerson go etˈtohngo ji Levi: go ejang etˈtohngo ji Manase, bo ka bo Golan ji li go Basan, ejahbe ji nne lˈwul nne, á bahke bake biiri. Bo tob ka bo Estara, semme a edi ndi ji enyam aleke, jolo ejahbe ebbal; ");
INSERT INTO eka_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","go etˈtohngo ji Isaka, bo ka bo Kision, a Daberati, ");
INSERT INTO eka_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","Jamuti, Ganim, a edi ndi ji enyam aleke, jolo ejahbe ebni. ");
INSERT INTO eka_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","Go etˈtonhgo ji Aser, bo ka bo Misal, Abdon, ");
INSERT INTO eka_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","Helkati, Rehob, a edi ndi ji enyam aleke, jolo egburu ejahbe ebni, ");
INSERT INTO eka_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","go etˈtohngo ji Naftali, bo ka bo Kedes ji li go Galili, ejahbe ji nne lˈwul nne, á bahke bake biiri. Bo tob ka bo Hamoti Dor, a Katan, a edi ndi ji enyam aleke, jolo ejahbe ebra. ");
INSERT INTO eka_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","Ajahbe nya bo ka anebe Gerson kpee jolo ewubu ejahbe ebra, a edi ndi ji enyam aleke. ");
INSERT INTO eka_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","A wo li ajahbe nya bo ka ebangenahb ji Merari, erik ebangenahb ji Levi: Go etˈtohngo ji Jebulon bo ka bo Jokneam, Karta, ");
INSERT INTO eka_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","Dimna, a Nahalal, budu edi ndi ji enyam aleke, jolo ejahbe ebni; ");
INSERT INTO eka_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","go etˈtohngo ji Ruben, bo ka bo Bejer, a Jahaji, ");
INSERT INTO eka_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","Kedemoti, a Mefaati, a edi ndi ji enyam aleke, jolo ejahbe ebni. ");
INSERT INTO eka_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","Go etˈtohngo ji Gad, bo ka bo Ramoti ji li go Giled, ejahbe ji nne lˈwul nne, á bahke bake biiri, bo tob ka Mahaneam, ");
INSERT INTO eka_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","Hesbon, Jajer, a edi ndi ji enyam aleke, jolo ejahbe ebni kpee. ");
INSERT INTO eka_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","Ajahbe kpee nya bo ka ebangenahb ji Merari, bo ji jolo erik anebe Levi jolo ewubu ejahbe ebbal. ");
INSERT INTO eka_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","Ajahbe nya anebe Isreel ka anebe Levi nya jolo go elwo ni Isreel jolo ejahbe atahl abal ejahbe ebnehkemni kpee , a edi ndi ji enyam aleke. ");
INSERT INTO eka_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","Ejahbe ajehng ajehng jio bele edi ndi ji enyam aleke semme kak. Jolo ano go etingitingi ajahbe nyaa kpee. ");
INSERT INTO eka_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Ana wo Jehova ka anebe Isreel edi ndi jia kpee ana á nyame tong babnde ba nkul re á bahke kake bo. Ano wo bo ko ndi nyio kpee fere lene o. ");
INSERT INTO eka_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Owo Jehova kehm kake bo erekekv go ejang abehng abehng, jang jang ana á nyame tong babnde ebo. Nnekv ebo awohng awohng limm no male yiimi a bo, tibre Jehova yake bo kpee kak go ebo abo. ");
INSERT INTO eka_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Nnoobo enyam abehng abehng bi Jehova limm, bi á nyame tong Isreel bi kane no, kpee lˈlim. ");
INSERT INTO eka_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Owo Josua kehm lungu etˈtohngo ji Ruben, a etˈtohngo ji Gad, a ejang etˈtohngo ji Manase re bo ba kono edi ajehng, ");
INSERT INTO eka_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","kehm bungu tong bo re,“Wahn eblim nsol kpee nyi Mosis nlokeltuma Jehova ka-n elkahn, wo go ejum ajehng ajehng ḿ me-e faabem nnyo ana n ka-n elkahn. ");
INSERT INTO eka_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Bomo go njahm tete ba rehng efung bia, ń tikem be abonane ebahne sa, wahn ebtoono alum nya Jehova, Esowo ebahne ka-n no. ");
INSERT INTO eka_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Anv Jehova, Esowo ebahne, ebka abonane ebahne erekekv ana á nyame no, feeren, kehnge go egahna ajahbe, go ndi nyi Mosis nlokeltuma Jehova ka-n no go egbuk aya jehko ji Jodan. ");
INSERT INTO eka_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Wo belen ekunukpu, wahn bum ajehke a atahm nya Mosis nloketuma Jehova ka-n no, á tong-n re Jehova Esowo ebahne jo kor-n, wahn fere jo jen go mbang enye anyehng anyehng, tob jo bum atahm enye. Jabben ye tˈtahne, wahn fere jo lok-e a ntim a ntim enyahne kpee, a atohko atohko enyahne kpee. ");
INSERT INTO eka_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","Owo Josua kehm fuulu bo , fere tong bo re bo song. Bo kehm tahme go ebo ajahbe. ");
INSERT INTO eka_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","Mosis wo ka ejang etˈtohngo ji Manase edi go Basan, Josua ka erik etˈtohngo jia edi go erede nfam bi Jodan a abonanyehn ebo. Ana Josua tumu bo re bo song, á fuulu bo, ");
INSERT INTO eka_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","kehm fere bung re, <<Feeren kehnge go egahna ajahbe, a agburu afang enyahne, atohkondi enyahne, asilva, agul, abrons a akuungu, agburu nkohl abomo nya li tolok tolok. Song baange nsol nyia a abonane ebahne, nyi ḿ ma da goji anebekv ebahne.>> ");
INSERT INTO eka_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Owo etˈtohngo Ruben, Gad, a ejang etꞌtohngo ji Manase kehm yake erik anebe Isreel o Silo ji li go Kenan, kehm jo feere go Giled ji li edi ndi ebo, ji bo ka bo, ana Jehova ka bo elkahn sehng go nnyo mi Mosis. ");
INSERT INTO eka_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","Eji etˈtohngo ji Ruben, a ji Gad, a ejang etˈtohngo ji Manase ba rehng go Geliloti kohlo Jodan, go ndi nyi Kenan, bo kehm limi egburu egudu njom go nkpe aya Jodan. ");
INSERT INTO eka_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","Eji anebe Isreel wuku re boblim egudu njom go nkonkon nyi Kenan go Geliloti, kohlo Jodan, ejang bi Isreel ");
INSERT INTO eka_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","Isreel kpee kehm mehle song kono go Silo, re bo song nok ebta a bo. ");
INSERT INTO eka_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","Anebe Isreel kehm tumu Finehas ji mmon no nlum no Elieja nlimanjom, tv go ndi nyi Giled, re á song kpiri anebe Ruben, anebe Gad, a ejang etˈtohngo ji Manase. ");
INSERT INTO eka_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","Ane ba toon-e no jolo atubesi ane na awubu, no nne go etˈtohngo jˈje go Isreel, fvfo no nne jolo ntubesi go ege ebangenahb go ellong abangenahb nya anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Eji bo je go Giled, goji anebe Ruben, anebe Gad, a ejang etˈtohngo ji Manase, bo kehm tongo bo re: ");
INSERT INTO eka_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","<<Ane kpee ba Jehova kpˈbungu re: <Nˈnan ḿ ma yab elnahne a Esowo bi Isreel mbang ana nyia? Nꞌnan wahnge ḿ ma sennge Jehova njahm, fere lim egudu njom ka elnahne anv, fere kpe-e tibi etahnsi? ");
INSERT INTO eka_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","Anv, abˈbi nya e limi go Peor wahr gbalema? Jol e ka tiki ru elnahre tete tub lela go abiafem nyao, jol eji li li re erem bia gbo tub ane ba Jehova! ");
INSERT INTO eka_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","<< <Ń yahke sennge na Jehova njahma? Ń lˈtib etahnsi a Jehova lela, behna erakatahng eje bahke gboko tub anebe Isreel kpee. ");
INSERT INTO eka_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","Lˈjol re abˈbi ebjol go edi ndi ji ń ko no, feeren ba ga edi ndi ji Jehova, edi ji etahk ji Jehova li no, wahn ba baange ndi anahre. Kana nok a Jehova, afi a nahre re wahn song lim egudu njom ka elnahne, kˈsehnge egudu njom ji Jehova Esowo ebahre. ");
INSERT INTO eka_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Eji Ekan, mmon no Jera da nsol nyi Esowo tongo re bo rannge, ń nyˈnehm ana erakatahng gbo tub Isreel kpeea? Ye ntahngtahng sang kpo no tib abiafem enye.> >> ");
INSERT INTO eka_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","Owo anebe Ruben, anebe Gad, go ejang etˈtohngo ji Manase kehm faange atubesi abangenahb nya Isreel re: ");
INSERT INTO eka_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","<<Nne no kpi Nsahm, Esowo, Jehova! Nne no kpi nsahm, Esowo Jehova. Á kpˈkahne! Nong Isreel kahn! Lˈfere jol re wahr ebten Esowo, fere senng-e njahm, kana wahr yake lela. ");
INSERT INTO eka_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","Lˈjol re e limi egudu njom ka elnahre re wahr yake Jehova, jo lim njom nyi eljahme fi, a nyi amohk nti. Afi fere lim ajom nya elkoono, nong yefono Jehova lim-r ji kor-e no. ");
INSERT INTO eka_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","Eˈee! E limi jia, a elfahle re behnjehle go abon ebahne bahke bungu tong ba bahre re, <Ejum ellimi ajii ń kpi a Jehova Esowo bi Isreel? ");
INSERT INTO eka_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","Jehova eblim aya Jodan re jol nseenge enyahre a wahn, wahn anebe Ruben, wahn anebe Gad! Ebo bahne wobem goji Jehova.> Wahngka etˈtohngo ejahne, bahke limi etˈtohngo ejahre re bo kˈkpe fahl Jehova . ");
INSERT INTO eka_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","Ejum jia ji wahnge e bungu re, ‘Wahr tooben lim egudu njom, wo nehm jol ka njom nyi bo kpo jahm fi, afi ajom nyako. ");
INSERT INTO eka_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","Tohko fere jol ano, bahke fere jol ejum ntianse ka wahr, a wahn, a aying nya kpˈbake njahm re, e bahke kake Jehova go ege etahk go ajom enyahre nya eljahme fi, a ajom nyako, a nya elkoono. Owo go esˈsong etˈtohngo ejahne nehm ma bung tong etˈtohngo ejahre re, Bo kpimm ebo abehng abehng goji Jehova. ");
INSERT INTO eka_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","Wo e bungu re, bo lˈfere bung jia tong-r, afi fere tong etˈtohngo ejahre, e bahke faange re, <Seengen, wahn nyehn elfoongo egudu njom ji Jehova ji babnsoo ejahre limi no, bo limem tib esi njom nyi eljahme fi, a ajom nyako, bo limi re jol ejum ntianse ka-r njahm ebal ebal.> ");
INSERT INTO eka_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","Ndan gbaa re wahr nok a Jehova, fere senng-e njahm lela, fere ba lim egudu jia re wahr jo lim ajom nya bo kpo jahm fi, a nya amohk nti, a ajom nyako, sehnge egudu njom jio ji Jehova, Esowo ebahre, ji yim go esamahr ebkpatahk Jehova. ");
INSERT INTO eka_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","Eji Finehas ji nlimanjom, a abafili ajahbe bo ji li atubesi abangenahb Isreel, wuku ana etˈtohngo ji Ruben, Gad, a ji Manase bungu no, yebe bo atahng sehng. ");
INSERT INTO eka_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","Owo Finehas mmon no Elieja ji nlimanjom kehm bungu tong anebe Ruben, Gad, a Manase re, <<Lela wahr ebkahn re Jehova li a nahre, tibre ń ka ten Jehova fere senng-e njahm go ejum jia. Wahn eblim re erakatahng ji Jehova kˈgbo tub anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","Owo Finehas mmon no Elieja ji nlimanjom, a abafili ajahbe, feere kehnge go Kenan, go eboa nkon nyi bo je no, a anebe Ruben, Gad go Giled song tooro tong anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","Bo bele eyebatahng sehng, fere tehk Esowo go nfaange nyi bo wuku no. Ntoobo nyi ebta kpeem jol bo go atahng re bo song rannge ajahbe nya Ruben a Gad lene no. ");
INSERT INTO eka_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","Fvfo anebe Ruben, a anebe Gad kehm kake egudu njom jia mbing: Bo jo lungu re, ntianse nyi a, go elka elka enahre re Jehova Esowo bi. ");
INSERT INTO eka_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Eji ma kang afung gbalee, Jehova ma ka Isreel erekekv go esamahr anebekv ebo, Josua ntubesi ebo ebsahb kˈkul, ");
INSERT INTO eka_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","á kehm lungu anebe Isreel kpee ba kono edi ajehng, anebkul nfam, atubesi nsoja, abalamalam, a atubesi abailimi ntum, kehm bungu tong bo re: Anv, me n sahb kˈkul. ");
INSERT INTO eka_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Wahnfono antahng ebnyehn ejum ajehng ajehng ji Jehova Esowo ebahne ma lim a nfam ajahbe nyaa. Jehova Esowo ebahne antahng antahng wo noko ka-n. ");
INSERT INTO eka_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Buumen ana m ma bak adi alehkelkv ka atˈtohngo enyahne, adi ndi kpee, nya nfam ajahbe nya ma sa, nya m ma ga go ebta, bomo go aya ma Jodan tete song rehng go agburu aya ma nne lˈkˈma nyehn egbuk jehko go erede nfam. ");
INSERT INTO eka_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Jehova, Esowo ebahne, yefono antahng bahke kame bo yehke egahne esamahr. Á bahke temme bo yehke go egahne elbohngo, ń fere ko adi ndi ebo, ana Jehova Esowo ebahne nyame no. ");
INSERT INTO eka_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","<<Yiimen tˈtahne, belen ekunukpu, wahn toono ajehng ajehng ji bo nyono go nwera ntahm nyi Mosis. Kana gbake feere ejang eboblum afi ejang ebobkal. ");
INSERT INTO eka_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Gberen, wahn kˈrod elnahne semme a erik nfam ajahbe nya ma sa egahne ellong, kana toono asowo ebo, jol kana lung abing asowo ebo, afi tir bo. Kana jo loko bo, jol kana gong kak bo. ");
INSERT INTO eka_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Wo Soren asi wahn tub Jehova Esowo ebahne ejahm ana ń kp-e toono wuku wuku, tete rehng anv. ");
INSERT INTO eka_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Jehova ebkam agburu, a atahntahn nfam ajahbe go egahne elbohngo. Tete rehng lela, nnene limm no ma mal yiim-n go egahne esamahr. ");
INSERT INTO eka_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Nne awohng go egahne ellong jo kame ane atahltahl nkpe ebal atahl awubu, tibre Jehova Esowo ebahne bi jo nok ka-n, ana á nyame tong-n. ");
INSERT INTO eka_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Gberen, nong Jehova, Esowo ebahne jo kor-n. ");
INSERT INTO eka_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","Wo ń lˈfere sennge Esowo njahm, song semme a erik ane ji sa nfam ejahbe nyia, fere song ko abon ebo go elbal, afi song bal abon ebo, jo lim nsol semme a bo. ");
INSERT INTO eka_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","Kahnen re Jehova Esowo ebahne nehm kpe kam nfam ajahbe nyao yehke go egahne esamahr. Fvfo bo bahke jolo na ana arim a akpoko ka-n, a nrꞌrare nyi bahke jo ruum-n go njahm, a ajoongo nya bahke jo jamme go amahr, tete ń tan go nnooba ndi nyi Jehova Esowo ebahne ka-n no. ");
INSERT INTO eka_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","Anv, n yahke ba eltahme ebim ejok. Ń kpꞌkahne kpee a ntim a ntim enyahne kpee, a atohko enyahne re, enyam na abehng limm go anoobo anyam kpee nya Jehova Esowo ebahne nyame no tong-n, bi ma kꞌkane. Anyam kpee ebbiingi go nseenge. Jol na abehng kanem. ");
INSERT INTO eka_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Wo ana anoobo anyam kpee nya Jehova Esowo ebahne, ma jol go nseenge ka-n, ano wo Jehova bahke koko abˈbi nsol kpee nya á tong-n no, ba kun-n, tete á ranng-n go nnooba ndi nyi á ka-n no. ");
INSERT INTO eka_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Ń lꞌsoodo egbanngalung ji Jehova Esowo ebahne, nyi á ka-n elkahn, fere tahm song loko asowo nyandiki, fere gong kak bo, erakatahng ji Jehova bahke gboko kuum-n ana agun, fvfo ḿ bahke kpoko elwaare go nnooba ndi nyi á ka-n no. ");
INSERT INTO eka_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Owo Josua kehm kuku atˈtohngo nya Isreel kpee re bo lohng ba go Sekem. Á lungu anebkul, atubesi, abalamalam, a atubesi nsoja ba Isreel, bo ba yiimi go esamahr bi Esowo. ");
INSERT INTO eka_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Josua kehm bungu tong bo re, <<Ji ji a ji Jehova Esowo bi Isreel kpˈbungu: Mahne mahne babnso ewahne, lene go egbuk aya Yufritis jehko jo kak asowo nyako, nne awohng go ebo ellong bo jo lung-e re Tera ji jolo nde no Ebraham abola Naho. ");
INSERT INTO eka_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","N yehke nso ewahne Ebraham go egbuk aya jio, tv-e ba rehng go Kenan. N ka-e abon gbalee. N ka-e Aesik, ");
INSERT INTO eka_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","n ka Aisik, Jekob abola Eso. Eso n ka-e edi awong awong ji li Siya. Jekob a abon ebe mehle song lene go Ijib. ");
INSERT INTO eka_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","<< <Wo n kehm tumu Mosis abola Eron tv go Ijib. N kake anebe Ijib arem, go nsol nyi n limi o, n kehm-n yehke. ");
INSERT INTO eka_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Eji n yehke babnso ewahne go Ijib, ń ba rehng go aya nkpafa anebe Ijib rodo amvtv akuungu, a abafingi anyˈnya ebo kam anebe Isreel tete rehng go aya nkpafa. ");
INSERT INTO eka_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Bo rabe lung-m Jehova n kak bo ebo. Owo n kehm tumu ejannge tv go elka elka nꞌnahne a anebe Ijib. N tob limi aya nkpafa mele bo kpee. Ń tob nyehne go egahne amahr, nsol kpee nyi n limi anebe Ijib. Ń kange aya tvv go elka emahng ni kꞌlꞌmahng ajele. ");
INSERT INTO eka_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","<< <N ko-n tete ba rehng go ndi nyi anebe Amor, bo ji lene ero bio bi aya Jodan. Bo noko a nahne, n faake bo kak-n go egahne abo, n rannge bo go egahne esamahr, fvfo ń song ko ndi abo. ");
INSERT INTO eka_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Eji Balak ji mmona Jipo, ntula Moab, toobo ebjing bi á yahke ba elnoko a Isreel. Á kehm lungu Balam mmon no Beor re a ba biri nkuk tv-n. ");
INSERT INTO eka_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Me, n wuungem Balam atung. Wo á soro na asi jo fuul-n, ano wo n tahr-n yehke go abo nya Balak. ");
INSERT INTO eka_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Owo ń kehm siiri aya ma Jodan ba rehng go Jeriko. Anebe Jeriko kehm noko a na, a Amor, Peres, Kenan, Hiti, Gigas, Hivi, a Jebus, wo n yake bo kpee kak-n go abo. ");
INSERT INTO eka_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","N tumu agbunggbung, nya gbo-n mbang song kam bo go egahne esamahr, fvfo a atul abal ba anebe Amor. Ń limem jia go egahne ekahngkahng, a elban. ");
INSERT INTO eka_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","N ka-n ndi nyi ń ki lim eltum kehm bele, fere ka-n agburu ajahbe nya ń ki si, ń lene o, kpꞌlehke akab agreb a akab oliv, nya ń ki bahm. ");
INSERT INTO eka_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Anv, fahlen Jehova, wahn fere lok-e, a ntim a ntim enyahne kpee. Roon asowo nya babnso ewahne jo kak go egbuk aya jehko, a Ijib, wahn fere jo kak Jehova. ");
INSERT INTO eka_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Yehken lela nne no ḿ bahke kake. Lˈfere jol re wahn nehme yebe atahng re wahn kak Jehova. Ń kpˈsebe re wahn kak asowo nya babnso ewahne jo kak go egbuk aya Yufritis jehko , afi asowo nya anebe Amor kpo kak, bo ji ń lene go ebo a ndi? Wo, me a etahk etahk ejame e bahke kake Jehova. ");
INSERT INTO eka_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Wo bo kehm faange re, <<Ndan gbaa re, wahr ten Jehova, fere kak asowo nyako! ");
INSERT INTO eka_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Jehova Esowo abahre wo yehk-r antahng, a babnsoo ewahre go Ijib, ndi nyi e woomo eju. Á limi agburu akpokosi go egahre amahr, fere baab-r go eljen enahre kpee, go ellong nfam ajahbe nya e jo sehng ebo alatahkgur. ");
INSERT INTO eka_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Jehova kame ajahbe kpee yehke go egahre esamahr, a anebe Amor ba lene go ndi nyia. Wahr fvfo, e bahke loko Jehova, tib ye wo li Esowo ebahre.>> ");
INSERT INTO eka_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Josua kehm bungu tong ane re, <<Wahn nehm ma loko Jehova. Á li Esowo bi li saang, á kpo kpu elkahre. Á nehm tiki tahm ka-n go egahne etahnsi, a abiafem enyahne. ");
INSERT INTO eka_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Ń lꞌten Jehova, fere jo kak asowo nyandiki, á bahke sennge fere ko elrannge ba ka-n, fere ranng-n, jol eji á ma-n tohko tib nnoobo enye. ");
INSERT INTO eka_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Ane bao kpee kehm faange Josua re, <<Eꞌee, wahr ebyehke re e bahke loko Jehova.>> ");
INSERT INTO eka_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Josua kehm bungu re, <<Wahnfono ba li atianse ka ji ḿ ma bung re, ḿ bahke loko Jehova.>> Bo kehm-e faange re, <<Wahr li atianse a ji e ma bung.>> ");
INSERT INTO eka_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Josua kehm tongo bo re, <<Ebnob, anv ro-n asowo nya ajahbe nyako go egahne ellong, wahn fere sennge ntim enyahne feere goji Jehova, Esowo bi Isreel.>> ");
INSERT INTO eka_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Bo kehm bungu tong Josua re, <<E bahke loko Jehova, ye wo li Esowo ebahre. Ye ntahngtahng wo e bahke jo kpun-e.>> ");
INSERT INTO eka_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Efung bio Josua ko nwongo a ane. O Sekem wo, á ka bo ajehke a atahm ");
INSERT INTO eka_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Josua yeele nsol nyia kpee go nwer atahm nyi Esowo. Á kehm bannge ekahmeltal song bum go nnahb eti oak nyi jolo kohlo ebkpatahk Jehova bi li saang. ");
INSERT INTO eka_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Josua kehm bungu tong bo kpee re, <<Nyehn-n! Eltal nia bahke yiimi ntianse bada nahre. Eltal nia ebwuk alum kpee nya Jehova ma bung anahre eltal nia bahke yiimi ntianse bade anahne, ń tohko jol go etingitingi a Esowo ebahne. ");
INSERT INTO eka_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Josua kehm yaame ane, nne awohng awohng feere kehnge go ege edi elehkelkv. ");
INSERT INTO eka_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Eji nsol nyia kpee ma sehng, Josua mmon no Nun, nlokeltuma Jehova kehm ba kak elkv kpo. Á kange nnya atahl alon, a nnya ewubu kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Bo kpa-e kak go Timnati Sera ji li edi awong awong ji Efriim , ejang ebobkal nfam bi egburu ewong Gaas. ");
INSERT INTO eka_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Anebe Isreel kake Jehova nobnob ngare elkpin kpee ni Josua, a ngare elkpin kpee nyi anebkul ba kange sehnge Josua bo ji nyehne akpokosi nya Jehova ma lim ka anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Akahb nya Josef, nya anebe Isreel rodo go Ijib ngare nyi bo mehle go Ijib, bo ba kpa kak go Sekem, go eji ndi ji Jekob gunu goji abone Hamo, ye ji jolo nde no Sekem. Bo gunu edi ndi jia go ebahk asilva atahl alon. Edi jia fere jolo edi elehkelkv ji ebangenahb, ji Josef. ");
INSERT INTO eka_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Owo fvfo Elieja mmona Eron kehm ba kpo, bo kake go Gibia, edi jio ji bo ka Finehas mmon ewe, edi awong awong ji Efriim.");
INSERT INTO eka_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Ngare nyio nyi Josua ma kpo, abone Isreel kehm bahbe Jehova re, \"Anv, nne awoo bahk-r gboko mbang song nok a anebe Kenan?\" ");
INSERT INTO eka_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Owo Jehova kehm faange re, \"Nong etˈtohngo ji Juda gboon mbang, m m-e kak edi ndi jia go ebo abo.\" ");
INSERT INTO eka_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Etˈtohngo ji Juda kehm tongo abonanyehn ba lohng go etˈtohngo ji Simion re, \"Ba tob-r nok a anebe Kenan ba wob go ejang ndi ji bo ka-r no, e bahke tob ba tob-n nok a anebe Kenan ba tob li go egahna ndi.\" Etˈtohngo ji Simion kehm song tob bo. ");
INSERT INTO eka_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","Ana anebe Juda tahme ebta, Jehova kehm faake anebe Kenan, a anebe Peres kak bo go abo. Efung bio bo wulu ane atahltahl go eltahl a nkpel elon ejahbe jio ji Besek. ");
INSERT INTO eka_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","O wo bo nyehne nne no bo kpo lung-e re Adoni-Besek, kehm kehme elnoko a ne. Bo kame anebe Kenan, a anebe Peres yehke ajahbe nyao. ");
INSERT INTO eka_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","Adoni-Besek bˈbe. Bo kam-e song bob, fere kiimi anyohkobo nlumlum, a anyohkgung nlumlum. ");
INSERT INTO eka_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","Á kehm soro bung re, \"Ana n kiimi atul atahl ara a atul awubu bao anyohkobo nlumlum, a anyohkgung nlumlum bo fere jo kpiimi nsol alehke go egame nla ekpukuru, ano wo Esowo ma-m tob bongo.\" Bo ko-e ba go Jeusalem, owo á ba kpo. ");
INSERT INTO eka_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","Anebe Juda kpe sehng o song nok a Jeusalem, wul ane o kpee, fere jahm ejahbe jio fi. ");
INSERT INTO eka_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","Bo kpe sehng ona, song kehme elnoko a anebe Kenan ba lene go ero ewong, a adi nya li go elka emahng go ejang eboblum ejahbe jio, a akpe kpe awong nya li feere erede nfam. ");
INSERT INTO eka_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","Bo soro asi ona, song nok a anebe Kenan ba lene go ejahbe ji bo kpo lung re Hebron (bo tohko jo lung ejahbe jio re, Kiriat Aba) bo tob , ga Sesayi, a Ahiman, ngo Talmayi ");
INSERT INTO eka_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","Bo kpe sehng o nok anebe Diber (bo tohko jo lung ejahbe jia re, Kiriat Sefer). ");
INSERT INTO eka_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","Eji bo ba ebyele ejahbe jio, Keleb tongo abone Isreel re, \"Nne awohng awohng no bahke noko a Kiriat Sefer fere sehnge bo, m bahk-e kake Akisa mmon ewame no nkal á ko-e go elbal.\" ");
INSERT INTO eka_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","Otinel, mmon no Kenas, ji jolo mmonannyehna Keleb no nse, song noko a bo, sehng ejahbe jio. Keleb kehm faake mmon ewe Akisa ka-e go elbal. ");
INSERT INTO eka_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","Efung abehng Akisa kehm bungu tong Otinel nlum we re, song bahb nsoo, á ka-a edi egbe. Eji bo song rehng eji nde, Akisa badde kan a me go njahm enyˈnya, nde kehm-e bahbe re, \"Anv, me n lim jen ka-a?\" ");
INSERT INTO eka_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","Á kehm faange nde re, \"Eji a ma-m ka ndi go ejang eboblum bi alahb ki li, tob ka-m edi go ejang bio bi alahb li gbalee.\" Nde kehm-e kake mbingilahb nyi li go ero egbe, a nnahb gbe. ");
INSERT INTO eka_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","Etˈtohngo jio ji nde nkala Mosis, nne a Ken mehle go ejahbe ji bo jo lung re, ejahbe nsakoro ji bo kpo lung re Jeriko. Bo tahme toono anebe Juda re bo song lene a bo kohlo Arad ji jolo go elka emahng Juda ji li go elka emahng ejang eboblum, . ");
INSERT INTO eka_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","Anebe Juda kehm tob tahm song tob abonanyehn, anebe Simion, bo song nok a anebe Kenan ba jolo go Sefat bo rannge ejahbe jio kpee a ane ba lene o kpee. Bo lungu ejahbe jio re Homa (ji lohngo re elrannge). ");
INSERT INTO eka_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","Anebe Juda kehm noko ebta fere sehnge Gasa, Askelon, Ekron, fere taare ndi bo kpee. ");
INSERT INTO eka_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","Jehova jolo a anebe Juda. Bo taare ajahbe kpee nya kuumu go ero awong. Wo ajahbe nya jolo go ebal, bo maam kam bo, tib bo bele amvtv ebta nya jolo akuungu akuungu nya anyˈnya jo tohng. ");
INSERT INTO eka_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","Tib go enyam bi Mosis, bo faake Hebron ka Keleb, ye wo kame abon ba Anak na ara yehke go ejahbe jia. ");
INSERT INTO eka_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","Anebe Benjamin ana jolo o, bo maam kam anebe Jebus, ba jolo go Jeusalem, tete rehng efung bia. Bo baa kpe lene go ellong ni anebe Benjamin. ");
INSERT INTO eka_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","Etˈtohngo ji Josef ba noko ebta a ejahbe ji bo kpo lung re Betel, Jehova jolo a bo. ");
INSERT INTO eka_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","Bo tumu anebe mbehrbehr re bo song weele feede Betel (Betel bo jo lungu re Lus wuku wuku). ");
INSERT INTO eka_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","Anebe mbehr mbehr bao kehm wane nne no kpˈlohngo abake go ejahbe jio, bo kehm-e tongo re, \"Tib-r mbang nyi e bahke yele go ejahbe jia, a lˈtib-r e wa nehm lim ebi ajehng ajehng.\" ");
INSERT INTO eka_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Owo á kehm tibi bo mbang bo kehm wulu ane kpee ba li go ejahbe jio, sehngem nne no tibi bo mbang, a ebangenahb eje kpee. ");
INSERT INTO eka_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","Nne noa no tibi bo mbang mehle tahm go ndi nyi anebe Hit. Á si ejahbe o, ji á gungu mbing re Lus, mbing nyio nyi bo kpo lung ejahbe jio tete rehng lela. ");
INSERT INTO eka_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","Etˈtohngo Manase tobem kam ane ba jolo go Bet San, Taanak, Dor, Iblem, Megido, a ane ba lene sennge ajahbe nyao, tibre anebe Kenan yehke ntir ebo re bo bahke tiki jol o. ");
INSERT INTO eka_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","Ngare nyia Isreel bele atahne, bo kamem anebe Kenan yehke kpe kpe, Isreel limi bo bo jol aju jo lim ntum ka bo. ");
INSERT INTO eka_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","Jol Efrem tobem kam anebe Kenan ba jolo go Gesar, bo soro asi jo lene a bo. ");
INSERT INTO eka_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","Etˈtohngo Sebulon fvfo tobem kam anebe Kenan ba jolo go Kitron, afi Nahalol, bo yake bo re bo lene a bo,wo, go ebo eko, bo rod bo bum aju, jo lim ntum ka bo. ");
INSERT INTO eka_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","Jol etˈtohngo Aser kamem anebe Kenan ba jolo go Ako, Sidon, Ahlab, Aksib, Helbbah, Afek, a Rehob. ");
INSERT INTO eka_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","Tib esi jio wo etˈtohngo Aser lene edi ajehng a anebe Kenan ba jolo o. ");
INSERT INTO eka_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","Etˈtohngo Naftali fvfo kamem anebe Kenan ba lene go Bet Semesh, afi Bet Anat, anebe Naftali tob lene tob anebe Kenan ba jolo afono ejahbe. Anebe Naftali go ebo eko rodo anebe Kenan ba lene go Bet-Semesh, a Bet Anat, bum aju, jo lim ntum . ");
INSERT INTO eka_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","Anebe Amor sahde etˈtohngo ji Dan tv go ero ewong, bo kpeem jo taame re bo badde ba ga ebal. ");
INSERT INTO eka_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","Anebe Amor tob jabbe tˈtahne ewong ji Heres, a ejahbe ji bo kpo lung re Aijalon, a Saalbim, eji etˈtohngo ji Josef ba bel atahne sehnge bo, bo fere jabbe bo jol aju, jo lim ntum ka bo. ");
INSERT INTO eka_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","Nseenge nyi anebe Amor bomo go mmon ntoora mbang no bo kpo lung re Akrebim, no li go eyake awong. Soro asi ano tete rehng go Sela asongo. ");
INSERT INTO eka_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Enjel nyi Jehova mehle go Gilgal tahm go Bokim, kehm bungu tong anebe Isreel re, \"N yehk-n go Ijib, fere tv-n ba rehng edi ndi ji n nyame tong bahbnso ejahne re m bahke bo ka. M bung tong bo re, ˈN nehm tiki rannge egbanngalung a nahne, ");
INSERT INTO eka_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","wahn fvfo kana tiki lim egbanngalung ajehng ajehng a ane ba lene go edi jia, waan agudu njom ebo.ˈ Ḿ m-e wukem. Jenji wahnge ń limi ano? ");
INSERT INTO eka_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Anv, n kp-n tongo re, n nehm tiki kam bo yehke go egahne ellong, bo bahke jolo ana ajoongo ka-n, asowo ebo bahke jolo akpoko fvfo.\" ");
INSERT INTO eka_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Eji Enjel ma bung nsol nyia kpee tong abone Isreel, bo kehm kehme ellingi wahre wahre. ");
INSERT INTO eka_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Bo kehm soro lung edi jio re Bokim (ji lohngo re abalingaling). Owo bo limi ajom gbalee ka Jehova. ");
INSERT INTO eka_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Eji Josua ma yaame anebe Isreel kpee, no nne feere song yel go edi elehkekv eje. ");
INSERT INTO eka_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Nne awohng awohng jo kake Esowo go ngare nyi Josua kpaka li go elkpin, a anebekul ba kpe jol ngare nyi Josua ma kpo, bo ji nyehne akpokosi nya Esowo ma lim ka anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Josua mmon no Nun, nlokeltuma Jehova tahme ebim ejok eji á ma kang nnya atahl alon a nnya ewubu. ");
INSERT INTO eka_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Bo kpa-e kak go edi ji á li elkv, ji bo kpo lung re, Timnat Heres, ji jolo go ejahbe awong ji Efrem, ejang ebobkal bi ewong Gaas. ");
INSERT INTO eka_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Eji eying jio ji Josua ma kpo kpee mal, owo eying ji nfenfe kehm kpe ba ji ki kahn Jehova, jol nsol enye nyi á ma lim ka anebe Isreel nnene kahnem. ");
INSERT INTO eka_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Bo limi abiafem gbalee go esamahr Esowo, fere jo loko Baal. ");
INSERT INTO eka_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Bo tene Jehova, Esowo bio bi babnde ebo, ye ji yehke bo go ndi nyi Ijib. Bo tahme toono, jo loko asowo nya ane ba lene sennge bo kak. Bo limi Jehova jol erakatahng a bo, ");
INSERT INTO eka_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","tib eji bo ten-e no, fere jo loko Baal, a asowo nya Asterot. ");
INSERT INTO eka_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Go erakatahng ji Jehova bele a Isreel, á tumu ane ba kpo da nsol tv bo, bo ba taare nsol ebo kpee. Á tob faake bo kak anebekv kpee ba li sennge bo go abo. Bo maam kpe yiimi bo go abo. ");
INSERT INTO eka_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Ngare anyehng anyehng nyi Isreel lohngo tahm ebta, erakatahng ji Jehova ji jo toono bo, jang jang ana á nyame no. Ejum ajehng ajehng joom kpe nob a bo. ");
INSERT INTO eka_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Owo Jehova kehm yehke abalamalam ba tahre bo yehke go abo ane ba jo da bo nsol. ");
INSERT INTO eka_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Tvtv o, bo joom wuk abalamalam bao, bo kpe jo soro na asi, jo toono asowo nyako fere jo kak bo. Bo ware elyake mbang nyi babnde ebo sehng, bo ji jo kpunu atahm nya Jehova. ");
INSERT INTO eka_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Ngare anyehng anyehng nyi Jehova lˈyehke nlamalam no bahke fili bo, á bahke jolo a ne, fere tahre anebe Isreel yehke go abo anebekv ebo, ngare nyio kpee nyi nlamalam noo kpeka li go elkpin. Tibre jo fili Jehova ndon sehng tib go elnohko, a arem nya abone Isreel jo nyehn fere jo rˈruunu go abo nya anebekv ebo. ");
INSERT INTO eka_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Nlamalam noo lˈkpo, abone Isreel kpe fere jo lim abˈbi nya sehnge nya babnde ebo jo lim, jo toono, jo kak, fere jo loko asowo nyako. Bo tene elyake abi abang ebo. ");
INSERT INTO eka_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Erakatahng ji Jehova kpe gbal na bada Isreel. Owo á kehm bungu re, \"Tib eji ejahbe jia ma ten egbanngalung ejame ji n limi a babnde ebo, eji bo kiim wuungu atung, ");
INSERT INTO eka_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","n nehm kpe kam ajahbe nyao kpee nya Josua ki kam bo kehm kpoko. ");
INSERT INTO eka_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Bo ba n bahke koko wuungu anebe Isreel, ejoare bo bahk-m toono ana babnde ebo toon-m no.\" ");
INSERT INTO eka_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Jehova yake ajahbe nyao bum, tib esi jia. Owo wahnge á ki kam bo nkpel nkpel anyehng sehng go abo nya Josua. ");
INSERT INTO eka_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","Ajahbe nya a nya Jehova yake no re bo jol, eji á lˈ ko bo jo wuungu Isreel jio ji ki kahn bade ebta abehng abehng bi jolo Kenan. ");
INSERT INTO eka_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","Jehova limi jia, eji abone Isreel ba ki nyi ebta, lˈkpili bade ebta. ");
INSERT INTO eka_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","Ajahbe nyao nya a; Atul na alon ba anebe Filistia, anebe Kenan kpee, anebe Sidon, a anebe Hiv, bo ji lene go awong nyao nya Lebanon, bomo go ewong ji Baal Hemon song rehng go nnyo ewong ji Lebo Hamat. ");
INSERT INTO eka_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","Bo sa o, eji Jehova lˈko bo jo wuungu Isreel, ejoare Isreel bahke kpunu atahm nya á ka babnde ebo sehng go abo nya Mosis. ");
INSERT INTO eka_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","Ane ba a, ba abone Isreel lene a bo, anebe Kenan, anebe Hit, anebe Amor, anebe Peres, anebe Hiv, a anebe Jebus. ");
INSERT INTO eka_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","Abone Isreel ko mbal semme na semme a bo, fere jo kak asowo ebo. ");
INSERT INTO eka_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Abone ba Isreel limi abiafem go esamahr bi Jehova. Bo yini Jehova Esowo ebo, fere tahm jo loko asowo, Baal abola Asera. ");
INSERT INTO eka_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Jehova kehm bele egburu erakatahng bada anebe Isreel kehm faake bo kak ntul no Aram Naharim go ebo, no bo jo lung-e re Kusan-Risatem, ye wo Isreel jolo aju enye go nnya enehkeni. ");
INSERT INTO eka_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Eji anebe Isreel lingi tong Jehova re á tob bo, owo á kehm yehke nnenlum awohng, re á song tahre bo. Bo jo lung-e re Otˈniel, á jolo mmona mmonannyehn no Keleb no nse, no bo jo lung-e re Kenas. ");
INSERT INTO eka_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Etohko ji Jehova kehm ba jol a ne, á jol nne no bahke lame Isreel. Á kehm ba tahm ebta, song nok a ntula Kusan Risatem, ye ji jolo ntul no Aram. Esowo ka Otˈniel esehngebta go abohng nyao. ");
INSERT INTO eka_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Elkoono jolo ejahbe jio nnya atahl abal, tete Otˈniel ji mmona Kenas kpo. ");
INSERT INTO eka_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Owo abone Isreel kehm kpe lim abiafem go esamahr bi Jehova. Tib go esi abiafem ebo, Jehova ka ntula Moab nsahm, no bo jo lung-e re Eglon á ba nok sehnge Isreel. ");
INSERT INTO eka_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Ntul noa ko anebe Amon, a anebe Amalek budu elne, ba nok a Isreel, taare bo Jeriko ejahbe nsakoro. ");
INSERT INTO eka_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Anebe Isreel jolo aju ka Eglon ntul no Moab go elku a nnya era. ");
INSERT INTO eka_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Eji abone Isreel lingi tong Jehova re á kak bo ebo. Á kehm kake bo nnenlum awohng no jo lim ebobkal, no bo jo lung-e re Ehud mmon no Gera, á lohng go etˈtohngo ji Benjamin. Abone Isreel kehm-e kake akpohko etak re á song ka Eglon ntula Moab. ");
INSERT INTO eka_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","Ehud limi ekahngkahng njahmbal, labe ana eyake ebnyohkobo ebbal. Á rodo gba go eyo ji ejang eboblum, kak nsol bulu. ");
INSERT INTO eka_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","Á song faake akpohko nyao kpee ka Eglon, Eglon jolo njokojoka nne. ");
INSERT INTO eka_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","Eji Ehud m-e ka akpohko nyao, á kehm feere song tv ane ba solo akpohko nyao ba a nya. ");
INSERT INTO eka_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","Eji á song rehng edi ji bo jo ko atal ramme asowo, kohlo Gilgal, owo á kehm feere ba kpiri ntula Eglon kehm-e tongo re, \"Nsoo ntul, n kpi etib bi m bahk-a tongo mbehrmbehr.\" Ntul kehm tongo ane ba kpo lok-e re , ˈTohk-m ka wahn eyake.ˈ Bo kehm mehle lohng alatahk. ");
INSERT INTO eka_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","Ntul jii antahng go ekpˈkpa ji kpˈnaange go ero nkimi nyi li ege etahk, owo Ehud kehm jeere kohl-e, kehm-e tongo re, \"N ko etib bi lohng goji Esowo re me m ba ka-a. Ana ntul mehle go ege eti, ");
INSERT INTO eka_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","ano wo Ehud kehm koko ebobkal wob ekahngkahng ebe go eyo eboblum, kehm jahme ntul ekahngkahng bio sa o , ");
INSERT INTO eka_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","lahme tete ekpare yel go atahng, afom tahl bulu. Ano wo Ehud yake ekahngkahng bio sa-e go ala, lahme tete bohngo njahm. ");
INSERT INTO eka_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","Ehud kehm bame abu nyao nya eyong, fere ta, fere sehng nkpaame nkpaame badde eje tahm. ");
INSERT INTO eka_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","Eji Ehud ma tahm, owo alokeltum ntul feere no ba, kehm ba nyehn abutahk bo ma ta. Ntir atahng nyi bo jolo re, \"Yebtahm esuku go nkimi nyi atahng.\" ");
INSERT INTO eka_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","Eji bo ma sik ekidi ma lab, ntul ki lennge mbutahk, limi bo ndon, bo kehm ba rod egbokoro, ba lennge abu, nyehn ntula bo nong go ndi ma kpo. ");
INSERT INTO eka_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","Ngare nyio nyi alokeltum ji jo sik nyi nyi Ehud be for. Á song sehnge edi atal ji bo jo ramme elokelom sa, song rehng go Seira. ");
INSERT INTO eka_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","Eji á rehnge , á kehm woro ntang, anebe Isreel kehm lohngo gbalee, á kehm gboko bo mbang jo badde asongo. ");
INSERT INTO eka_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","Á kehm tongo bo re, \"Toon-m wahn, Jehova ebfaake anebe Moab ba li anebekv ebahne kak-r go abo.\" Bo kehm-e toono song taare elga anehng anehng ni bo kpo siiri aya ma Jodan tahm go Moab, re nne ekv awohng awohng kˈsiiri. ");
INSERT INTO eka_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","Ano wo bo noko a anebe Moab, fere wul ane atahltahl go eltahl a nkpel elon. Ane bao ba jolo nsoja ebo nyi jo sahb tˈtahne. Nne awohng awohng go ebo ellong forem. ");
INSERT INTO eka_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","Efung bio bi, anebe Isreel ga anebe Moab, anebe Moab fere jol aju ka bo, bomo ngare nyio asongo anebe Isreel jolo go elkoono nnya atahl ani. ");
INSERT INTO eka_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","Eji Ehud ma kpo, Samga mmon no Anat wo tob ba lam anebe Isreel.Ye fvfo tob tahre anebe Isreel. Á ko ebti bi bo kpo jamme adamagbudu, wul ane atahltahl, atahl awubu ba Filistia. ");
INSERT INTO eka_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Eji Ehud ma kpo, abone Isreel kpe feere song kehme abˈbi lim go esamahr bi Jehova. ");
INSERT INTO eka_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Jehova faake bo ka ntula Kenan, no bo jo lung-e re Jabin ji lohng go Hasor. Ntubesi nnea nsoja ewe, bo jo lung-e re Sisera, á jolo go ejahbe ji bo jo lung re Haroset Hagoyim. ");
INSERT INTO eka_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Sisera bele amvtv ebta nya bo limi akuungu akuungu nya anyˈnya jo tohng, nya jolo amvtv atahltahl nkpel ebal a amvtv atahl alon. Á nohko abone Isreel go nnya eltahl. Abonee Isreel kehm lingi tong Jehova re á kak bo ebo. ");
INSERT INTO eka_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Ngare nyia Debora nnyehnamahr no jolo nkala Lapidot, ye wo jo lam Isreel. ");
INSERT INTO eka_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Á jo lame ane go ala nsakoro nya Debora, edi ji jolo elka elka ni ejahbe ji Rama a Betel, edi ndi ji Efrem ji jolo awong awong, edi jio ji anebe Isreel kpee jo ba kpir-e á jo toobo atong tong ebo. ");
INSERT INTO eka_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Efung abehng á kehm tumu tv Barak mmona Abinoam, ye ji jolo go ejahbe ji Kedesh ji li go edi ndi ji Naftali. Á kehm-e tongo re, \"Ejum ji a, ji Jehova, ye ji li Esowo bi Isreel kpa-a tongo re wo tiki lim: ˈSong wo song yehke anebelum atahltahl go eltahl a nkpel elon, bo ji li atakuru, go etˈtohngo ji Naftali, a ji Sebulon, wo tahm abo go ewong ji bo kpo lung re Tabor. ");
INSERT INTO eka_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","M bahke melle Sisera ntubesi nne a nsoja no Jabin go eltim re á rod amvtv ebta enye, a abanokebta ebe, ba wan-n go aya ma Kison. O wo m bahk-e faake kak-a go ebo, a sehng-e go ebta.ˈ \" ");
INSERT INTO eka_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Barak kehm-e faange re, \"A tohk-m toono me n nehm je, a lˈtoon-m, m bahke jeke.\" ");
INSERT INTO eka_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Debora kehm-e tongo re, \"Ebnob sehng, m bahke jeke a na. Eji a ma yiimi re me m ba, ekpunu nehm jol jˈja. Nnenkal wo Jehova bahke faake Sisera kak-e go abo.\" Debora kehm toono Barak tahm go Kedesh. ");
INSERT INTO eka_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Eji bo rehnge go Kedesh, Barak kehm kuku etˈtohngo ji Sebulon, a ji Naftali, anebelum atahltahl eltahl a nkpel elon, bo lohng toon-e tahm ebta. Debora fvfo tˈtob je a bo. ");
INSERT INTO eka_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Ngare nyia Heber ji lohng go ebangenahb ji Ken, á lohng go etˈtohngo ji Hobab, nnar a Mosis, yeblohng go elwo ni ane ebe song si etahk go egburu nnahb eti nyi li go Saananim ji li kohko Kedesh. ");
INSERT INTO eka_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Eji bo tongo Sisera re Barak mmona Abinoam ebrehng go ewong ji Tabor, ");
INSERT INTO eka_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","á kehm rodo abanokebta ebe, a amvtv akuungu akuungu nya á jo ko nok ebta, jolo mmvtv atahltahl nkpel ebal, a mmvtv atahl alon. Bo bomo eljen ebo go ejahbe ji bo kpo lung re Haroset Hagoyim asongo go aya ma Kison. ");
INSERT INTO eka_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Owo Debora kehm tongo Barak re, \"Toobo ebjing. Lela Jehova ma-a gbo mbang, yebfaake Sisera kak-a go ebo, ebta bia.\" Barak kehm soro mehl a nsoja enye, bo jolo asoja atahltahl eltahl, a nkpel elon, fere jo badde ewong Tabor asongo go edi ebta. ");
INSERT INTO eka_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Ana Barak bomo ebta, Jehova kehm kake Sisera elsemme go ellong nsoja enye, a amvtv ebta enye bo be faade.Tete yefono Sisera yehb gbo go ege mmvtv ebta nyi á woomo no, be akpade akpade akpade. ");
INSERT INTO eka_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Owo Barak kehm kehme nsoja enye kam, a amvtv ebta ebo, mbang mbang tete rehng go Haroset-Hagoyim. Bo wulu nsoja Sisera kpee, jol na wohng saam. ");
INSERT INTO eka_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Yefono Sisera be akpade akpade song yel go mobkpatahk no Jayel nkal no Heber ji lohng go etˈtohngo Ken, tibre ntul a Hasor no bo jo lung-e re Jabin jolo etem a ejahbe ji Heber nne a Ken ");
INSERT INTO eka_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Jayel kehm lohngo go ege mmobkpatahk song wane Sisera kehm bungu tong-e re, \"Ba nsoo, ba ka fahl. Á kehm song yel go ege ebkpatahk, Jayel kehm-e konngo egbvgbv. ");
INSERT INTO eka_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Sisera kehm-e tongo re, “Alahb ma-m kor, ka-m alahb me n wo.\" Jayel kehm lennge ekpukpuk ji bo ko ngunyam lim ka-e alahbbel nfong re á wo, fere feere egbvgbv konng-e. ");
INSERT INTO eka_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Sisera kehm tongo Jayel re, “Yiimi mbutahk, nne awohng awohng lˈba bahb-a re, ˈNne noa aa?ˈ Tong-e re nnene limm.\" ");
INSERT INTO eka_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Eji Sisera ma gbo ellu tib go ellahnge ni á ma lahng, Jayel nkala Heber kehm rodo efamfam, a ngan, kehm nyaabe song kum Sisera go nwonngo etung bade ndi, á kpo. ");
INSERT INTO eka_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Eji Barak ba rehng, kpi Sisera seb, Jayel kehm song wan-e, kehm-e tongo re, \"Ba, m bahk-a tibi nne no a kp-e sebe.\" Á kehm-e toono yel go mmobkpatahk, song nyehn Sisera nong no, bo m-e kum ebfamfam go nwonngo etung, á ma kpo. ");
INSERT INTO eka_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Efung bio Esowo ga Jabin ji ntula Kenan, go esamahr bi anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Abone Isreel kpe bel atahne gbalee sehnge Jabin ntula Kenan, tete bo wul-e. ");
INSERT INTO eka_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","Efung bio Debora, a Barak mmona Abinoam yimi ese jia; ");
INSERT INTO eka_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","\"Ngare nyi atubesi anebe Isreel lˈgbo mbang, lˈtob kor ane fvfo re bo rod elbo lim eltum, tehken Jehova!. ");
INSERT INTO eka_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","\"Wuungen atung, wahn atul, wuungu wahn ji kpi ane fili. M bahke yimi tehk Jehova, m bahke yimi, m bahke kubu ase ka Jehova, ye ji li Esowo bi Isreel. ");
INSERT INTO eka_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","\"O Jehova, ngare nyi á mehle go Seir jo sehng go nla ejahbe nyi Edom, ndi gbˈgbehke, elbung na elahb, akparesemsem tob na alahb. ");
INSERT INTO eka_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","Awong gbehke go esamahr Jehova, Esowo bi Sinayi, ano wo jolo go esamahr bi Jehova, Esowo bi anebe Isreel ");
INSERT INTO eka_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","\"Go afung nyao nya Samga mmona Anat, go afung nya Jayel, ane yaange abang, ane ba yaange abang jo sehng go abang ekulugbe. ");
INSERT INTO eka_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","Abonea ane abikabik sa go abon ajahbe ba Isreel, tete Debora kehm bake ana nnyehn nne go Isreel. ");
INSERT INTO eka_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","Eji abone Isreel yehke asowo nfenfe, ebta ba rehng go bo ati mbu. Jol go ellong atakuru ane ebo, ba jolo ane atahltahl nkpel atahl alon, ejum ebta ajehng ajehng jolem ana ekum, afi elkong ");
INSERT INTO eka_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","Eltim ename li go eji atubesi ba Isreel, a ane ba bele ekor rod elbo ka. Tehken Jehova! ");
INSERT INTO eka_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","“Wuungen atung, wahn ji jehk abarebare ebvankang go njahm, nya bo ma kunu agbvgbv nya kpˈkpoodo, a wahn ji kpˈjene go akpade. ");
INSERT INTO eka_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","wuungen abayimase atung bo ji jehk go abingilahb , bo kpˈfange anoobo nsol nya Jehova ma lim, a esehnge ebta, ji á ma ka atahntahna anebe Isreel. \"Ane ba Jehova jene tete song rehng go ati mbu. ");
INSERT INTO eka_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","ˈDebora mehl mehl, mehl wo yim ase. Mehl yiimi Barak! Rod anebekv eba ba a ma bob song, mmona Abinoam.ˈ ");
INSERT INTO eka_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","Ane bao ba sa no, feere ba kpiri atubesi ebo. Bo ji jolo ka Jehova ba kpir-m, a etoobo ebjing ji bo bahke noko ebta a atakuru nya njahm nyehko. ");
INSERT INTO eka_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","Ane bako lohng go etˈtohngo ji Efrem, edi jio ji tohko jol ka anebe Amalek; etˈtohngo ji Benjamin fvfo tob woomo go ellong ane ba jo toon-n. Bomo go etˈtohngo ji Makir, atakuru bomo eljene abake, bo johko lohng go etˈtohngo ji Sebulon ji jolo atubesi ebta. ");
INSERT INTO eka_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","Atubesi ba Aisaka tob jolo a Debora, a Barak, jo toono bo asongo go edamme. Go nfam nyi Ruben nne ne bumem ntir nyi eljeke. ");
INSERT INTO eka_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","Jenji wahnge a sa go njahm go etahngga ebul, re wo wuk ana abaabebul kpi afiri wor kon ebul re bo ba kono edi ajehnga? Go ejahbe ji Ruben, a nnene bumem ntir nyi eljeke. ");
INSERT INTO eka_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","Anebe Gilied sa go egbuk aya Jodan jehko. Jenji wahnge anebe Dan sa go edi ji bo kpo bum asohkkahng? Anebe Aser sa go edi ebo, ji li go elga, edi ji bo kpo bum agbang ebo. ");
INSERT INTO eka_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","Anebe Sebulon yake elkpin ebo ka, ana anebe Naftali ka go emahng ebta. ");
INSERT INTO eka_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","\"Atul lohngo ba nok. Atul bao ba ajahbe nya Kenan lohngo ba nok ebta go Taanak nkpe aya ma Megido, bo maam da asilva. ");
INSERT INTO eka_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","Go elbung alonlo sa nok ebta, bo sa go adi bo nok a Sisera. ");
INSERT INTO eka_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","Aya ma Kison ma feenge bo tahm, akˈkulu aya mao. Bel ekakeltim, etohko ejame, wo jen song. ");
INSERT INTO eka_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","Akpade nya anyˈnya kehm jo jahre na jahre go ndi jo wahl , bo jo ware abahl, bo jolo atahntahn anyˈnya nya ebta. ");
INSERT INTO eka_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","Enjel nyi Jehova kehm bungu re, ˈNkuk nyi nnen jol ka ejahbe ji bo kpo lung re Meros, a ane ebe, tibre bo baam ba kak Jehova ebo, eji atakuru ane baa a jo nok a bo.ˈ ");
INSERT INTO eka_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","\"Nong elfuulu ga jol ka Jayel go ellong anebkal, ye ji li nkal no Hebar, nne no lohng etˈtohngo ji Ken. Elfuulu ga jol ka-e, go ellong anebkal ba lene go abonkpatahk. ");
INSERT INTO eka_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","Eji Sisera bahb-e alahb re á wo, Jayel ka-e alahbbel nfong ma bo ki semme alahb. Á kak-e go mmohk nyi atul kpo wo. ");
INSERT INTO eka_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","Jayel rodo efamfam, go eboblum, á rodo ngan. Á kehm kumu kak Sisera go esi, lahm bohngo njahm nyehko. ");
INSERT INTO eka_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","Á gbo, sa noongo o ndi, á gbo go ege alata, edi ji á gbo no owo á noongo no kpo. ");
INSERT INTO eka_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","“Nnyehn no Sisera jo seenge sehng go ewindu, eji á li go ege atahng ekpˈkpa, á ji re á nyehn re mmon kpˈfeere kehnge, á kehm kehme elbungu re, “Nˈnan mmvtv akuungu akuungu enye ma laange go elkehnge? Nˈnan n kala tiki wuk agare mmvtv akuungu akuungu enye kpˈbake? ");
INSERT INTO eka_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","\"Nfaange lohngo anyo nya akahnkahn anebkal ba jolo jo limi eltum a ne, á jo bungu ntahngtahng re: ");
INSERT INTO eka_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","ˈBahke jolo re, bo kpˈbaange nsol nyi bo ma da . Nnenlum awohng awohng bahke ma bel ngbahme anyehng, afi ebal ebal. Bahke ma jol re bo kpˈbaange abomo nya bo ma tub go nkpiida nkpiidi ka Sisera, nyandiki bo bahke koko ba ka-m.ˈ ");
INSERT INTO eka_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","\"Jehova, nong anebekv eba kpee kpo ana Sisera. Nong nne awohng awohng no wo kp-e koro jol ana njul nyi ma ta elbange lohng go eko eje.\" Nnya atahl abal Isreel jolo ebo soom. ");
INSERT INTO eka_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Abone Isreel kehm kpe lim abiafem go esamahr bi Jehova. Go nnya esehma, Jehova yake bo, bo song jol aju go elwo ni anebe Midia. ");
INSERT INTO eka_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Tib go esi ji anebe Midia jo sab bo go elfili , abone Isreel be rehng go ero awong, song biiri go akpatal, agohng, a eko ebta. ");
INSERT INTO eka_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Ngare anyehng anyehng nyi abone Isreel lˈbahm nsol, anebe Midia, a anebe Amalek, a ane bako ba lohng ero nfam, bahke bake ba kehme elnoko a bo. ");
INSERT INTO eka_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Bo sa o kak elsi, jo rannge nsol alehke ebo tete rehng go Gasa. Jol ejum ajehng ajehng ji ellehke, bo kpeem jo yake ka Isreel, ejoro, adamagbudu, a ebvankang, ebvankang kpee. ");
INSERT INTO eka_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Bo jo ba a atohkondi atohkondi ebo, a nkpatahk, ana elkpa agohrobi. Jol a nehm ma fange bo, a akamel akamel ebo. Tete bo li nsol kpee mal, kehm feere. ");
INSERT INTO eka_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Eji anebe Midia ma li nsol abone Isreel kpee mal, owo abone Isreel kehm lingi tong Jehova re, á kak bo ebo. ");
INSERT INTO eka_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Eji abone Isreel lingi tong Jehova tib go esi ji anebe Midia, ");
INSERT INTO eka_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","á tumu bo nnyehnamahr no bungu re, \"Ji ji a, ji Jehova, Esowo bi Isreel bungu no: n yehk-n go eju bi ń jolo go Ijib. ");
INSERT INTO eka_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","N tahr-n yehke go elnohko ni anebe Ijib, a ane kpee ba jo nohk-n. N kame anebekv ebahne, fere ka-n ndi abo. ");
INSERT INTO eka_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","N bungu tong-n re, ˈMe wo li Jehova, bi li Esowo ebahne; kana tiki kak asowo nya anebe Amor, bo ji ń lene eboa ndi.ˈ Jol ḿ m-e wukem.\" ");
INSERT INTO eka_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Owo enjel nyi Jehova kehm ba ji go nnahb eti nyi bo kpo lung re oak ji li nfam nyi Ofra. Edi jio jolo ka Joas ji lohng ebangenahb ji Abieser. Gidion mmon a Joas jo ruumu nsam o edi ji bo kpo kaame amahm yehke go akab greb, eji anebe Midia lˈkˈnyehn. ");
INSERT INTO eka_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Owo enjel nyi Jehova kehm ba kpir-e kehm-e tongo re, \"Jehova li a na, wo egburu ntakuru.\" ");
INSERT INTO eka_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Gidion kehm faange re, \"Nsoo, lˈjol re Jehova li anahre, jenji wahnge nsol nyia kpee kp-r limi? Akpokosi nyanehm nya na, nya babnsoo tong-r bade, eji bo bungu re, anv Jehova sang yehk-r go ndi nyi Ijiba? Á ma feere ba tahng-r tub, faak-r kak anebe Midia go ebo. ");
INSERT INTO eka_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Owo Jehova kehm sennge fere go ege, kehm bungu re, \"Song go nsahm nyi a kpi no, song tahre anebe Isreel yehke go ebo bi anebe Midia. Me wo kp-a tumu.\" ");
INSERT INTO eka_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Gidion kehm faange re, \"Anv, Jehova m bahke limi renan, kehm tahre anebe Isreel? Ebangenahb ejame ji li morennge ebangenahb go etˈtohngo ji Manase, ga me n li erennge nne go egame ebangenahb.\" ");
INSERT INTO eka_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Jehova kehm bungu tong-e re, \"M bahke jolo a na. Á bahke noko a anebe Midia rannge bo, are a kpˈnoko a nne awohng.\" ");
INSERT INTO eka_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Gidion kehm faange re, \"Lˈjol go etingitingi re a bahk-m kake ebo, tib-m elliingi re wo wo kpˈbungu aname. ");
INSERT INTO eka_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Ka tahm tete me n song ko ejum elyare ejame ba kaa. Jehova kehm faange re, \"M bahke jolo a tete, a je feere.\" ");
INSERT INTO eka_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Owo Gidion kehm yange go ege etahk, song wul mmombul baange, fere rod abe nya bahke ruru eltahl a ngbugu ebal lim abred nya ayist ki wob go atahng. Á kake nnyam go ejeere, kak abehne go mmotu, kehm koko ba ka enjel nyi ji go nnahb eti nyi bo kpo lung re Oak. ");
INSERT INTO eka_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Enjel nyi Esowo kehm bungu tong-e re, \"Rod nnyam nyio, a abred nyao nya ayist ki wob atahng kunu go ekpartal, yaange abehne nyao wohngo.\" Gidion kehm limi ano. ");
INSERT INTO eka_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Enjel kehm rodo ebti bi á fili go ebo, kooro nnyam, a abred nyao. Agun kehm seke go ekpartal jio fere fi nnyam nyio, a abred. Enjel nyi Jehova soro lamme. ");
INSERT INTO eka_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Eji Gidion sebe kahn re enjel nyi Jehova nyi, á kehm rabe, \"Nsoo Jehova! Me n nyehn enjel nyi Jehova gbul gbul gbuul!\" ");
INSERT INTO eka_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Jehova kehm bungu re, \"Elkoono jol a na, ka fahl, a nehm kpo.\" ");
INSERT INTO eka_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Gidion kehm limi egudu njom ka Jehova edi jio, fere jo lung re, Jehova wo li Elkoono. Jia yim tete tub lela go ejahbe ji Ofra, go edi ndi ji ebangenahb ji Abieser. ");
INSERT INTO eka_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Atv manehm o, Jehova kehm-e tongo re, \"Yehke etoono mmona nfong no nlum no ga gbal, go ellong enyam nso, no ma kang nnya esehma. Far egudu njom Baal ji nso, tob kim ego ji Asera ji li kohlo o tub go ndi. ");
INSERT INTO eka_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Lim egudu njom ji nno a nno ka Jehova edi ewong jia. Ko nfong , wo lim njom nyi bo kpo jahm na fi. Ko ego ji Asera ji a kimi no tub, ana nkun. ");
INSERT INTO eka_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Gidion kehm rodo alokeltum ebe na awubu, bo song lim jang jang ana Jehova tong-e no. Á Limem jia a, njul á limi atv, tibre elfahle jol-e jol bade ebangenahb eje, a ane ba jolo go nfam. ");
INSERT INTO eka_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Efungfu eji ane ma nyahme, bo kehm sebe kahn re, egudu njom ji Baal bobwa, tob kim ego Asera tub go ndi, bo limi egudu njom ji nfenfe, fere ko etoono mmona nfong no nlum no ga gbal lim njom kunu o. ");
INSERT INTO eka_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Ane kehm kehme elbahbe atemtem, \"Nne awo limi ejum jia? Eji bo feede nobnob, bo kehm tongo bo re, Gidion mmon a Joas wo limi.\" ");
INSERT INTO eka_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Anebelum ba ejahbe jio kehm tongo Joas re, yehke mmon ewe ba a ne, á bahke tiki kpo na, tibre yebwa egudu njom ji Baal, fere kim ego ji Asera ji jolo kohlo o tub go.\" ");
INSERT INTO eka_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Owo Joas kehm faange agbanne bao ba lohngo no ba re, \"Wahn ba kpˈgboko siki ka Baala? Wahn ba bahke noko ka-ea? Nne no lˈnok ka-e, bo bahke ye wul behna efungfu! Lˈjol re Baal esowo bi, nong á nok a nne no rannge egudu njom eje antahng.\" ");
INSERT INTO eka_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Bomo efung bio asongo, bo jo lungu Gidion re, Jerubaal, ji lohngo re, \"Nong Baal nok ka elne antahng.\" Tibre á wa egudu njom ji Baal. ");
INSERT INTO eka_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Gaam kpe kang nsoja nyi Midia, a nyi Amalek, a nyehko nyi lohng go ero nfam kpa njahm mehl ebta a abone Isreel. Bo siiri aya ma Jodan, ba kak elsi ebo, jolo go edamme ji Jesreel. ");
INSERT INTO eka_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Owo Etohko ji Jehova kehm ba yel Gidion. Á kehm ba wor ntang a nnyam, yehke ane re bo tahm ebta, ane ba lohng go nnahb ji Abieser lohng ba go ege ");
INSERT INTO eka_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Á tumu abatiingetib tv etˈtohngo ji Manase, , Aser, Sebulon, a Naftali, re bo rod nsol ebta, bo kpee lohng song kpir-e. ");
INSERT INTO eka_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Gidion kehm bungu tong Esowo re, \"Lˈjol re a bahke tahre abone Isreel sehng go egame ebo, ana a nyame no, ");
INSERT INTO eka_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","tib-m go mbang nyia, m bahke bumu ngunyam go edi ji bo kpo ruumu nsam, ebohng lˈna suku ngunyam nyi nyi, ndi jol wum wum, m bahke kahne re, a bahke tahre abone Isreel sehng go egame ebo ana a ma bung.\" ");
INSERT INTO eka_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Ano wo jolo no ful ful fuul. Gidion kehm nyahme etoono efung, song rod ngunyam nyio kaame, rur na go ekpingi erukabo. ");
INSERT INTO eka_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Gidion kehm bungu tong Jehova re, \"Titi nong atahng ki-a rak tob-m. Nong me n kpe ko ngunyam nyia bahb-a ejum ajehng. Anv, lim ngunyam nyia jol wumwum, nong ebohng suku go ndi kpee.\" ");
INSERT INTO eka_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Atv mao Esowo limi ano, efungfu ngunyam jolo wum wum, ndi kpee suku tib ebohng. ");
INSERT INTO eka_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Gidion (ye ji tob li Jerubaal) a nsoja enye kehm mehle efungfu behre behre jen song rehng go elbing alahb ni bo jo lung re Harod. Nsoja nyi Midia ebbum elsi ebo go ejang ebobkal ebo, feere go edamme ji li kohlo ewong ji More ");
INSERT INTO eka_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Owo Jehova kehm bungu tong Gidion, \"Atakuru anebe ebta ba li a na ebrur sehng. N lˈyake bo ane kpee re bo song nok a anebe Midia, anebe Isreel bahke woro nnyo re eko ebo ji ma ka bo esehngebta. ");
INSERT INTO eka_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Tong abone Isreel re, ˈNne awohng awohng no kpˈfahle, nobo re á yake ewong Gilied feere kehnge.ˈ \" Nsoja atahltahl nkpel atahl abal a nkpel elku, kim kuuk feere kehnge. Nsoja nyi sa no jolo atahltahl, eltahl a nkpel elon. ");
INSERT INTO eka_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Jehova kehm kpe bung tong Gidion re, \"Erik nsoja ebkpe tiki gbal sehng. Rod bo wo song go ebgba, go wo m bahke jeke, nne no n lˈtong re ye wo bahke jeke á je a na, nne no n lˈtong re á kˈje á nehm je.\" ");
INSERT INTO eka_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Gidion kehm koko ane bao tahm ebgba. Jehova kehm-e tongo re, \"Ane ba jamme alahng, kohk nnyo jo wo alahb ana mbv nong bo yiimi ejang abehng.\" ");
INSERT INTO eka_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Ane atahlku ba jo ko abo jo kpe alahb wo, egom jehko kpee jamme na alahng kohk nnyo jo wo alahb. ");
INSERT INTO eka_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Jehova kehm tongo Gidion re, “Ane atahlku baa ba jo ko abo jo kpe alahb wo, bo ba m bahk koko, nok ga anebe Midia, fere tahr-a. Tum ane bako kpee bo kehnge.\" ");
INSERT INTO eka_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Ane atahlku ba sa goji Gidion, bako a taare bo nsol ebta, a atang, fere tum bo kehnge. Elsi ni anebe Midia jolo edamme, Gidion a ane ebe bo kuumu ewong ");
INSERT INTO eka_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Atv mao Jehova kehm tongo Gidion re, \"Mehl wo song go elsi ni Midia, tibre n kpˈsebe re me n rod bo kak-n go abo. ");
INSERT INTO eka_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Lˈjol re a kpˈfahle eljeke go ebo elsi, song a nlokeltum ewe no bo kpo lung-e re Pura, ");
INSERT INTO eka_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","wuungu atung wo wuk ji bo kpˈbungu, eji a lˈbel esahb ji a bahke song nok a bo.\" Ano wo Gidion abola Pura nlokeltum ewe badde tahm song rehng kohlo go ebo elsi. ");
INSERT INTO eka_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Anebe Midia, a anebe Amalek, a ane bako kpee ba lohng go ero nfam, bo ebba rur go edamme, bo jolo ana ellong agorobi. Akamel ebo ruru ana erikehndi bi li go nkpe aya. ");
INSERT INTO eka_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Eji Gidion rehnge o, á wuku nne no kpi ntem nlem lak re, \"N leeme nlem, n nyehne ebred ji jolo bannge bannge, ji bo ko abe nya lohng go bali lim, kpˈbannge abake go elsi ni anebe Midia, bannge ba kahd ebkpatahk eko eko tete ebkpatahk bio tuulu gbo. ");
INSERT INTO eka_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Owo nte we kehm-e faange re, \"Nlem nyia, jol ejumjum sang, sehnge ekahngkahng bi Gidion mmon no Joas nne a Isreel. Esowo ebfaake anebe Midia, a ane kpee ba kpo tob bo ebta nok, kak Gidion go ebo.\" ");
INSERT INTO eka_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Eji Gidion wuku nlem nyio, fere wuk ana lohngo no á tehke Esowo. Á kehm feere ba ga elsi ni abone Isreel, kehm ba ku ane.\"Lohngen! Lohngeno! Tibre Jehova ebfaake elsi ni anebe Midia kak-n go abo ");
INSERT INTO eka_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Gidion kehm yabe nsoja atahlku nyio edi ebra. Á rodo atang nya elworo, a abon atu ba enyaale wob atahng kak nne awohng awohng go ebo. ");
INSERT INTO eka_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Á kehm tongo bo re, \"Seeng-m wahn.\" N lˈrehng kohlo n kon kon elsi, \"Ajehng ajehng ji ń lˈnyehn-m n kpˈlimi, tob limen ano. ");
INSERT INTO eka_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Ń lˈwuk-m, a ane ba li aname ma wor atang, tob woren, wahn kpee ji li sennge elsi nia, wahn rabe re, “Li ka Jehova, a Gidion.ˈ \" ");
INSERT INTO eka_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Eji Gidion a nsoja atahl alon nyi jolo a ne ma rehng go nkpe elsi nio ni anebe Midia, jolo nlum atv, eji bo ma yaange ababˈbaabe. Bo kehm kehme atang wor, fere wa abon atu ba wob bo go abo. ");
INSERT INTO eka_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Owo bo kpee kehm kehme atang wor, fere wa atu ebo. No nne kehm rodo enyaale go ebobkal, ntang eboblum jo rabe re, “Ekahngkahng bi Jehova, a bi Gidion.\" ");
INSERT INTO eka_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Nne awohng awohng yiimi edi ji bo bum-e no sennge elsi nio kak, anebe Midia kehm kehme elbeke ayambu ayambu aling aling go nnyo. ");
INSERT INTO eka_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Eji nsoja atahlku nyio woro atang ebo, Jehova limi nsoja nyi anebe Midia kpee go bo elsi, bo fere jo nok atemtem go akahngkahng. Egom ji bo ki wul bo, yaame be rehng go Bet Sita mbang mbang nyio nyi Serera rehng go nseenge ejahbe nyi Abel Mehola ji li kohko Tabat. ");
INSERT INTO eka_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Gidion tumu etib tv nsoja nyi Isreel nyi li go Naftali, a nyi Aser, a nyi Manase, bo lohng kpee ba kam anebe Midia. ");
INSERT INTO eka_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Gidion tob tumu abatiingetib tv, ejahbe awong ji Efrem, tong bo re, \"Badden, wahn ba bam anebe Midia go mbang alahb Jodan, tete rehng go Beth Bara.\" Ano wo nsoja kpee nyi Efrem lohngo no, ba taare ndi nkpe nkpe nyi aya ma Jodan, tete rehng go Beth Bara. ");
INSERT INTO eka_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Bo bobo agburu anebe nsoja na abal ba anebe Midia, noko bo jo lung-e re, Oreb, noko Seeb. Oreb bo wul-e go ekpartal ji Oreb, Seeb bo wul-e go edi amahm akaame ji Seeb. Bo kame anebe Midia ekidi lˈlab, eji bo jo feere, bo ko esi Oreb, a ji Seeb ba ka Gidion . Ngare nyio á kpeka li go egbuk aya jehko. ");
INSERT INTO eka_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","Anebe Efrem kehm bahbe Gidion re, “Nˈnan a ma-r lim ana? A ki-r lung , eji a jo tahm elnoko a anebe Midia? Ano wo bo taange tˈtahne a Gidion ");
INSERT INTO eka_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","Gidion kehm faange bo re, \"Anv, elkohn ejum aji m ma lˈlim sehnge jˈjahne? Ń nehme kahn re, abiini akabe greb nya sa go egbe ji Efrem nya kpˈgaka nob sehnge egbe kpee ji bo kpa no go ebangenahb ji Abiesar? ");
INSERT INTO eka_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","Esowo ka-n Oreb abola Seeb, atubesi anebe Midia. Jenji m ma lim, e lˈdumu, a jio ji jahne?\" Eji Gidion bungu alum nyao , ntim ebo kehm naange bo. ");
INSERT INTO eka_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","Gidion, a nsoja atahlku enye, ba siiri Jodan, a ellahnge ellahnge ebo, bo kpe soro asi jo kam anebekv. ");
INSERT INTO eka_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","Eji bo rehnge go Sokot, Gidion kehm tongo anebekul Sukot re, “Ka-n nsoja enyame nsol alehke, bob gbo ewo. N kpi nkame nkame atul bao ba anebe Midia, Seba abola Salmuna. ");
INSERT INTO eka_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","Atubesi ba Sukot kehm-e faange re, \"Wo a ka bob Seba abola Salmuna, nˈnan wahnge e bahke kake nsoja enya nsol alehke?\" ");
INSERT INTO eka_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","Gidion kehm faange bo re, \"Ebnob, Jehova lˈyake Seba abola Salmuna kak-m go ebo, m bahke koko ajoongo asohkonso, a akpiri, ba jaake agubjing enyahne. ");
INSERT INTO eka_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","Gidion sehnge o song rehng go ejahbe ji bo kpo lung re Peniel, tob song bahb bo nsol alehke, bo faange Gidion ana anebe Sukot faang-e no. ");
INSERT INTO eka_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","Á kehm bungu tong anebe Peniel re, “N lˈfeere a esehngebta ejame, m bahke wake nkahmbungubungu etahk ejahne ji ń kpo kuumu baabe ejahbe.\" ");
INSERT INTO eka_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","Ngare nyia, Seba abola Salmuna, a nsoja ebo, nyi li, ane atahltahl nkpel eltahl, a nkpel elkubal a ane atahl awubu, li go Karkor, bo ma sa go ellong nsoja nyi lohng go ero nfam. Tibre nsoja atahltahl nkpel atahlku,bob wul bo. ");
INSERT INTO eka_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","Gidion kehm sehnge mbang mbang jo tahm ero nfam, ajahbe nya bo jo lung re Nobah, a Jogbehah, bo song kpiri nsoja nyi anebe Midia nyi ki kunu ekpu, fere nok a bo. ");
INSERT INTO eka_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","Atul abal ba anebe Midia, Seba abola Salmuna be, Gidion kam bo song bob, nsoja ebo be yaame. ");
INSERT INTO eka_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","Eji Gidion mmona Joas ma bob bo, á kehm feere kehnge go emahng ebta, á sehnge montoora mbang no li go ewong, no bo lung re Heres. ");
INSERT INTO eka_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","Gidion bobo monjangkun no lohng go Sukot, á bahb-e abahbe, njankun nyio kehm yeele abing ane atahl ara, ane elku ane abal ba jolo atubesi, a anebekul Sukot, ka Gidion . ");
INSERT INTO eka_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","Gidion kehm feere ba rehng go Sukot, kehm ba bung tong anebe Sukot re, \"Nyehnen Seba abola Salmuna gana. Wuku ń jo nyok-m re, ˈWo Seba abola Salmuna a ka bob bo, nˈnan a kpˈsebe re wahr ka nsoja enya nyi ma lahng nsol alehke?ˈ \" ");
INSERT INTO eka_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","Á koo asohkonso, a akpiri dv anebekul bao nˈnob, jolo ana elle ka bo. ");
INSERT INTO eka_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","Nkahmbungubungu etahk Peniel, á wa tub, fere wul anebelum ba li ejahbe jio. ");
INSERT INTO eka_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","Gidion kehm bahbe Seba abola Salmuna re, \"Ane ba ń wulu go Tabor, bo jolo elkohn ane abaa?\" Bo kehm-e faange re, \"Bo jolo ana wo, bo foongo abone ntul.” ");
INSERT INTO eka_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","Gidion kehm faange bo re, “Abonanee ba o, e lohng nnyehn awohng a bo. Etingitingi, ana Jehova li go elkpin, li re ń wulem bo, kehn wahn nehm wul.\" ");
INSERT INTO eka_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","Á kehm sennge seenge mmon ewe no nkul no bo kpo lung-e re Jeta, kehm-e tongo re, \"Wul bo.\" Jol Jeta wobem ekahngkahng ebe, tibre á jo fˈfahl eji á jolo njankun. ");
INSERT INTO eka_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","Seba abola Salmuna tongo Gidion re, \"Á lˈjol nnenlum wul-r antahng.ˈ Ano wo Gidion soro wul bo, ane abal abal. Á yehke nsol nyi bo kpo ko liibi akamel ebo go amel. Gidion limi ebulungang ji nlimanjom ");
INSERT INTO eka_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Abone Isreel kehm tongo Gidion re, \"Wo jo fil-r, mmon ewa, a mmon a mmon ewa, tibre wo wo ma-r tahre yehke go abo nya anebe Midia.\" ");
INSERT INTO eka_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Owo Gidion kehm faange bo re, \"Me nehm jol nne no bahk-n fili, jol mmon ewame nehm jol. Jehova wo bahk-n fili! ");
INSERT INTO eka_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","N kpi ejum ajehng ji n kp-n bahbe, \"Nong, nne awohng awohng ewahne ka-m ebangetung, nsol nyi ń da no goji anebekv ba ń ma sehnge bo.\" (Eljini ni anebe Ismael ni re bi jo kak abangetung nya agul). ");
INSERT INTO eka_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Bo kehm faange re, \"E bahke kake go eyebatahng.\" Owo bo kehm yale mbomo, no nne kehm koko ebangetung ba kak. Bo yehke go ellong nsol nyi bo ma da. ");
INSERT INTO eka_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Ellubu ni abangetung nyao lubu no jolo ejum ekilo eltahl. Bo tob ka-e alahm lahm nsol nyako nya kpo kim ekun. Nsol ana nyia nyi bo kpo liibi, nya bo kpo kak emel, a nsol elkake nyi ntul no Midia kpo liibi, fvfo asinimel nya bo kpo kak akamel go emel. ");
INSERT INTO eka_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Gidion rodo nsol nyio kpee lim ebulungang ji nlimanjom jo kak. Á song bumu ejum jia go ege ejahbe, ji bo kpo lung re Ofra. Jol gaam kang anebe Isreel kpee yake Jehova fere jo song gbo jamme alahng jo kak ebulungang jio. Fere jolo na ekpoko ka Gidion, a ebangenahb eje. Elkv ni Gidion ");
INSERT INTO eka_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Ana wo Isreel kadde anebe Midia tv go ndi, bo kpeem tiki mehl esi emehle mehle. Go nnya atahl abal nyi Gidion kpe jol go elkpin, Isreel jolo go elkoono. ");
INSERT INTO eka_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","Owo Gidion (ji li Jerubaal) kehm feere kehnge go ege ejahbe. ");
INSERT INTO eka_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","Á bele abon atahl ara, abon awubu, ba nlum, tibre á bele akal gbalee. ");
INSERT INTO eka_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","Nnenkal awohng jolo go Sekem no á jo bum elkang a ne, nnenkal noo jele mmon no nlum ka-e, no bo jo lung-e re Abimelek. ");
INSERT INTO eka_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Gidion mmon no Joas kpoo eji á ma sahb kˈkul. Bo song kake go eyele nde, go ejahbe ji bo kpo lung re Ofra, go ebangenahb ji Abieser. ");
INSERT INTO eka_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Anebe Isreel yake Esowo, feere song kehme Baal loko ngare nyi Gidion ma kpo. Bo ko Baal Berit jol esowo ebo, fere lim alokelom enye nya bo jo kak.. ");
INSERT INTO eka_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","Bo yini Jehova, ye ji li Esowo ebo, ye ji ma tahre bo yehke go ellong anebekv ba sennge bo kak. ");
INSERT INTO eka_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Jol bo tibem ebangenahb ji Jerubaal (ye ji li Gidion) nnoobo anyehng anyehng go anoobo nsol nya á limi ka Isreel. ");
INSERT INTO eka_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","Efung abehng Abimelek mmon no Gidion kehm tahme go Sekem , edi ji abonanyehn nnyehn li no, kehm song tong ejahbe nnyehn re, ");
INSERT INTO eka_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","\"Bahben anebe Sekem, lˈjol re bo kpˈsebe re abone Gidion ba li ane atahl ara, ane awubu, ba bahke fili bo, afi nne awohng wo bahke fili bo? Buumen re, me, a wahn abonanyehn ba.\" ");
INSERT INTO eka_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","Eji abonanyehn nnyehn bungu ejum jia tong anebe Sekem, bo bumu ntir re bo bahke toono Abimelek, tibre bo bungu re, \"Ye mmonannee ejahre wo.\" ");
INSERT INTO eka_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","Bo yehke akpohko go etahk elom Baal Berik, jolo akpohko esilva atahl ara, esilva ebwubu, ka Abimelek, á yaame nsoja jo toon-e. ");
INSERT INTO eka_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","Á mehle tahm go etahk nde ji li go Ofra, song ko afun ebe, ba jolo ane atahl ara, ane awubu ba wul bo kpee go eltal. No ga se, no bo kpo lung-e re Jotam wo be for song biiri. ");
INSERT INTO eka_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","Owo nfam ejahbe nyi Sekem, a Bet Milo kehm ba kono asi go egburu nnahb eti nyi li kohlo ego ji li go Sekem, re bo bob Abimelek etul. ");
INSERT INTO eka_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","Eji Jotam wuku bade, á kehm wahre go ewong Gerisim, kehm rabe tong anebe Sekem re, \"Wuungen atung wahn anebe Sekem eji Esowo bahk-n tob wuungu atung.\" ");
INSERT INTO eka_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","Efung abehng nti kehm tahme re bo song bob ntula bo, bo gbo mbang tong eti ji bo kpo lung re Oliv re, \"Jol ntul ewahre.\" ");
INSERT INTO eka_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","Á kehm tene, kehm bungu re, “Anv me n yake akehng ma n kpo lim, ma kpo ka asowo, a ane elfuula, fere jo yannge ana ntul no ntia?\" ");
INSERT INTO eka_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","Nti kehm kpe bung tong efig, ˈBa wo ba jol ntul ewahre.ˈ ");
INSERT INTO eka_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","Efig kehm faange bo re, ˈAnv, me n kˈkpe kab anobonobo akab enyame fere jo yannge ana ntul no ntia? ");
INSERT INTO eka_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","Nti kehm ba tong elˈlehke greb, ˈBa jol ntul ewahre.ˈ ");
INSERT INTO eka_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","Owo elˈlehke greb kehm faange re, ˈAnv, me n kˈkpe lim amahm, ma kpo lim asowo, a ane bel eyebatahng, song yannge ana ntul no ntia?ˈ ");
INSERT INTO eka_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","Esˈkohro nti kehm bungu tong eti ajoongo ji ma sahb tˈtahb re, ˈBa jol ntul ewahre.ˈ ");
INSERT INTO eka_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","Á kehm faange bo re, ˈŃ l seb re me n jol ntul ewahne, ba woomen go egama enˈnang. Tohko jol ano, nong agun go egame song fi nti nyi li go Labenon kpee.ˈ ");
INSERT INTO eka_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","\"Anv, wahn eblim nobnob, a ekpunu re wahn bob Abimelek, á jol ntul ewahna? Ń lˈlim nob nob ka Gidion, a ebangenahb ejea? Ń tib-e tib nnoobo eljini ana fuumu noa?. ");
INSERT INTO eka_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","Kana yini re, nsoo noko ka-n gbalee, eji á fili elkpin ene go ebo, tahr-n yehke go abo anebe Midia, fere ga bo. ");
INSERT INTO eka_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","Wo lela, ń kpˈfere nok a etahk nsoo. Abone ebe ba li ane atahl ara ane awubu, ń wulu bo go eltal anehng fere rod Abimelek ji li mmon a nju, bob-e etul ka anebe Sekem, tibre mmonanne ejahne wo. ");
INSERT INTO eka_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","Lˈjol re ji ń ma lim a, ń limi nobnob, a ekpunu ka Gidion a ebangenahb eje, nong Abimelek lim-n wahn bel eyebatahng, wahn tob lim-e á bel eyebatahng. ");
INSERT INTO eka_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","Fvfo, lˈjol re, ń limem go nseenge, nong agun lohng goji Abimelek ba fi-n, wahn anebe Sekem, a anebe Bet Milo, nong agun tob lohng go egahne wahn anebe Sekem, a anebe Bet Milo ba fi Abimelek!\" ");
INSERT INTO eka_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","Jotam kehm beke song lene go Beer, tibre á jo fahle Abimelek mmonannyehn. ");
INSERT INTO eka_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","Eji Abimelek ma fili Isreel go nnya era, ");
INSERT INTO eka_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","Esowo kehm yake ebi etohko, ji ba yel go ellong ni atubesi anebe Sekem, a Abimelek, bo we joom kpe wuk. ");
INSERT INTO eka_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","Esowo limi jia, eji a lˈbongo Abimelek eji á wulu abonanyehn, ane atahl ara ane awubu ba jolo abone Gidion, fere tob bongo anebe Sekem ba tob-e no wul abonanyehn. ");
INSERT INTO eka_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","Anebe Sekem ba ki woomo njahma ntul tumu ane re bo song biiri go ero awong. Nne awohng awohng no lˈsehng o bo taare nsol. Nne jˈje song tooro tong Abimelek. ");
INSERT INTO eka_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","Ngare nyˈnehm o, Gaal mmon no Ebed mehle a abonanyehn song rehng go Sekem, ana bo je no, yebe anebe Sekem sehng, ye wo bo yehke amahr ebo kun-e. ");
INSERT INTO eka_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","Eji bo ma je go ebo ebgbe, song bong akab greb ba kaame, bo kehm limi elkak go etahk asowo bo. Eji bo jo li fere wˈwo, bo kehm kehme Abimelek su. ");
INSERT INTO eka_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","Gaal ji mmona Ebed kehm kehme elbungu re, \"Nne awoo li li Abimelek? Ejum ajii wahr anebe Sekem kpi no a Abimelek, ji wahr bahk-e loko?. Ye sang li mmon no Gidiona, Sebul sang li ekpeele ejea? Nong wahr loken etˈtohngo ji Hamor ye ji li nde no Sekem . Jenji wahnge wahr bahke jolo alokeltum ba Abimelek? ");
INSERT INTO eka_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","Li re me wo kpˈfili ane baa, kehn m bahk-e yehke. M bahke tongo Abimelek re, ˈYehke nsoja enya kpee ba!ˈ \" ");
INSERT INTO eka_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","Eji Sebul ji jolo ntubesi ejahbe wuku alum nya Gaal mmona Ebed bungu no, atahng rake sehng. ");
INSERT INTO eka_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","Á kehm tumu atiingi etib mbehr mbehr tv Abimelek go Aruma re, \"Gaal mmona Ebed, a abonanyehn ebba ga Sekem, bob ba melle ane re bo kˈkpe koono a na. ");
INSERT INTO eka_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","N kpˈsebe re ngare atv wo, a ane eba, wahn ba biiri go mbang jo sik bo. ");
INSERT INTO eka_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","Efungfu, ngare nyi njul ma ta elbange, jo jeeren asongo go ejahbe. Gaal a ane ba li a ne, lˈmehl a nahne, limen bo ajehng ajehng ji ń lˈmal.\" ");
INSERT INTO eka_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","Ngare nyi atv ma behde, Abimelek a ane ebe kehm yabe elbo nlong eni, biiri kohlo Sekem. ");
INSERT INTO eka_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","Ngare nyi Abimelek a ane ebe ma lohng go edi ji bo biiri no Gaal yiimi go eti mbu. ");
INSERT INTO eka_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","Eji Gaal nyehne bo, á kehm tongo Sebul re, \"Nyehn ane go kpˈbadde ewong abakae!\" Sebul kehm-e faange re, \"N kpˈnyehne atohko awong ana ane.\" ");
INSERT INTO eka_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","Gaal kehm kpe bung re, \"Nyehn ane go kpˈlohngo abake go elka emahng, ellong nehko kpˈlohngo abake go nnahb eti nyi ane ba kpo bu mbu kpo ji. ");
INSERT INTO eka_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","Sebul kehm bahbe a esahb esahb re, \"Nnyo mi a jo wor mehna? Wo sang bungu re, ˈNne awo li li Abimelek ji wahr bahk-e loka?ˈ Ane baa sang a jo nyok boa? Song nok a bo!\" ");
INSERT INTO eka_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","Gaal kehm mehle a anebe Sekem, kehm kehme elnoko a Abimelek. ");
INSERT INTO eka_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","Abimelek kehm-e kehme elkame, anebe Sekem gbalee,jo gbo nsol jo lim bo, mbang mbang asongo go eti mbu. ");
INSERT INTO eka_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","Abimelek sa go Aruma, Sebul wo wo kame Gaal, a abonanyehn yehke go Sekem ");
INSERT INTO eka_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","Etoono efung behko anebe Sekem kpe mehl ebta, eji Abimelek wuku ano, ");
INSERT INTO eka_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","á kehm yabe ane ebe go nlong era, bo kehm song biiri. Eji Abimelek ma nyehn ane kpˈlohngo go ejahbe abake, bo kehm lohngo edi ji bo biiri no jo nok a bo. ");
INSERT INTO eka_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","Abimelek a ellong ane ebe song sahd eti mbu re anebe Sekem kˈbel mbang yel, nlong ebal nyehko jo wulu ane bako go emahng. ");
INSERT INTO eka_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","Efung bio kpee Abimelek noko a bo, tete á wul ane kpee, ko ejahbe. Á rannge ejahbe jio kpee, fere sale akang wohngo o. ");
INSERT INTO eka_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","Eji ane ba li go Sekem ba kun go nkahmbungubungu etahk ebta wuku ji ma jol, bo be song biiri go eko ebta jio ji etahk El Berith. ");
INSERT INTO eka_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","Eji bo song tong Abimelek ana ane bao ma song kono edi ajehng. ");
INSERT INTO eka_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","Ye a nsoja enye wahre go ewong Salmon. Á rodo elfuk kiimi abˈbo nti, fere rod kunu ebahk, kehm tongo nsoja enye re, \"Limen elwaare ana m ma lim a!\" ");
INSERT INTO eka_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","Ano wo ane ebe kpee kiimi abˈbo nti jo toon-e. Bo song sahde mbu mi eko ebta, kak agun tv bo go atahng. Ane kpee ba woomo etahk jio, bo rehnge ejum ane atahltahl nkpel ebal atahl awubu, anebelum, a anebkal anebkal. ");
INSERT INTO eka_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","Abimelek kehm kpe tahm go Tebes song nok ga bo fere ko ejahbe. ");
INSERT INTO eka_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","Go atahng ejahbe, nkahmbungubungu etahk ebta jolo o, ji anebelum, a anebkal, a ane kpee biiri no. Bo bame elbo tv atahng, fere song wahr go nkpake nyi jolo go ero. ");
INSERT INTO eka_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","Eji Abimelek mehle re á song nok a bo o. Ana á jo niiri asongo, eji á ma rehng kohlo eti mbu ji etahk ebta re a song kak agun edi jio, ");
INSERT INTO eka_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","nnenkal no kuumu go ero kehm yake mmon eltal ngoko tub Abimelek esi, esi bahnge. ");
INSERT INTO eka_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","Abimelek kehm tongo nne no jo sol nsol ebta enye re, \"Wob ekahngkahng eba wo wul-m, bo kˈbung re, ˈNnenkal wo wulu Abimelek.ˈ \" Nlokeltum ewe kehm wobo ekahngkahng wul-e. ");
INSERT INTO eka_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","Eji anebe Isreel nyehne re Abimelek ebkpo, bo kpee feere kehnge. ");
INSERT INTO eka_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","Ana wo Esowo ko bongo Abimelek go ebi ji á limi go nlaaga nyi nde, eji á wulu ane atahl ara ane awubu, ba jolo afun ebe. ");
INSERT INTO eka_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","Esowo tob bongo anebe Sekem go abˈbi ebo. Elsu ni Jotam mmon a Gidion lohko jol go etingitingi. ");
INSERT INTO eka_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","Eji Abimelek kpo no, nne no lohng go eˈtohngo ji Isaka, no bo jo lung-e re Tola, mmon no Pua, ji jolo mmon no Dodo. Ye wo lohngo ba Isreel tahre. Ejahbe eje jolo go ejahbe awong ji Efrem, ji bo kpo lung re Samir. ");
INSERT INTO eka_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","Á kpoo eji á ma fili Isreel go eltahl a nnya era, bo kpa-e kak go Samir. ");
INSERT INTO eka_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","Eji Tola ma kpo, Jair ji lohng go Gilied tob ba fili Isreel eltahl a nnya ebal. ");
INSERT INTO eka_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","Á bele eltahl abon awubu ba nlum, bo bele eltahl edonki ebwubu bi bo jo fing. Bo jo fili ejahbe ebwubu go Gilied, nya bo kpˈlungu tete sik lela re abon ajahbe ba Havot Jair. ");
INSERT INTO eka_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","Eji Jair kpoo no, bo kpa-e kak go Kamon. ");
INSERT INTO eka_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","Abone Isreel kehm kpe lim abiafem go esamahr bi Jehova. Bo jo toono Baal, a Astarot, asowo nya anebe Aram, a anebe Sidon, a anebe Moab, a anebe Amon, a nyao nya anebe Filisia. Tib eji abone Isreel tene Jehova, bo we kpeem jo loko, ");
INSERT INTO eka_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","Jehova bele erakatahng a bo. Á faake bo kak go abo nya anebe Filisia, a anebe Amon. ");
INSERT INTO eka_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","Elya nio, bo bomo anebe Isreel go elnohko, ano wo bo nohko bo go elku nnya era, bo ji jolo go ero nfam bio bi aya ma Jodan, go Gilied ndi nyi anebe Amor ");
INSERT INTO eka_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","Anebe Amon tob siiri egbuk aya ma Jodan song nok a anebe Juda, a anebe Benjamin, a anebe Efrem. Anebe Isreel jolo egburu erem. ");
INSERT INTO eka_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","Owo anebe Isreel kehm lingi go esamahr Jehova re, \"Wahr eblim abiafem bada a na, tibre e ma-a yake, fere kpˈtoono jo loko Baal.\" ");
INSERT INTO eka_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","Jehova kehm faange re, \"Eji anebe Ijib, a anebe Amor, a anebe Amon, a anebe Filisia, ");
INSERT INTO eka_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","a anebe Sidon, a anebe Maon jo nohk-n, ń lingi no tong-m, wahn n tahr-m yehke go ebo aboa? ");
INSERT INTO eka_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","Ń ma-m ten, fere kpˈtoono asowo, wahn nehm kpe tahre. ");
INSERT INTO eka_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","Songen wahn song ling tong asowo nya ḿ ma yehke. Nong bo tahr-n yehke go egahna ntong!\" ");
INSERT INTO eka_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","Anebe Isreel kehm kehme elgboongo Jehova re, \"Wahr eblim abiafem, kak-r erem abehng abehng bi a kp-r kake, lub tahr-r anv yehke go ebo abo.\" ");
INSERT INTO eka_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","Anebe Isreel kehm roko asowo ebo kpee go fere jo loko Jehova, kehm-e kehme eltim gbiingi go erem bi anebe Isreel kpˈnyehne. ");
INSERT INTO eka_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","Eji anebe Amon mehle ebta, ba gba ji go Gilied. Anebe Isreel tob lohngo ba gba ji go Mispa. ");
INSERT INTO eka_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","Atubesi ba Gilied kehm bungu tong atemtem re, \"Nne no lˈgbo mbang mehl song nok ebta a anebe Amon, ye wo bahke jolo ntubesi ka ane kpee ba lene go Gilied.\" ");
INSERT INTO eka_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","Ngare nyio egburu etahntahn nne jolo go Gilied no bo jo lung-e re Jefta. Nde bo jo lung-e re Gilied; Nnyehn jolo nne asˈsa. ");
INSERT INTO eka_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","Nkal no Gilied tob jele abon ba nlum ka-e, ngare nyi bo ma gbal, bo kehm kame Jefta nfun abo yehke go ebo ellong. Bo kehm bungu tong-e re, \"A nehm tiki sa a, ba li elkv nsoo a nahre, tibre nne no jel-a no nne asˈsa wo.\" ");
INSERT INTO eka_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","Owo Jefta kehm soro be goji afun ebe tahm go ndi nyi Tob, go wo á song bel ellong atahnsi ane ba ki bel ejum ajehng ajehng ji ellimi. ");
INSERT INTO eka_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","Eji ma kang abon afung ntiil, anebe Amon kehm ba kehme elnoko a anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","Anebekul nfam ba Gilied kehm tahme go ndi nyi Tob re bo song ko Jefta. ");
INSERT INTO eka_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","Bo kehm song tong-e re, \"Ba wo ba jol ntˈtohko ewahre wahr song nok a anebe Amon.\" ");
INSERT INTO eka_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","Jefta kehm faange bo re, \"Me wahn korem, owo wahnge ń kam-m go nlaaga nyi nsoo. Nˈnan ḿ bahke bake go egame anv, eji ń wob go ntong?\" ");
INSERT INTO eka_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","Bo kehm-e faange re, \"Jio ki-a gbiingi anv, wahr ebfeere ba re wo ba tob-r nok a anebe Amon. Á bahke jolo ntubesi no anebe Gilied kpee.\" ");
INSERT INTO eka_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","Jefta faange bo re, \"Lˈjol re wahn ebfeere aname re me song nok a anebe Amon, Jehova faake abo kak-m go ebo, m bahke lohko jol ntubesi ewahna?\" ");
INSERT INTO eka_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","Bo kehm-e faange re, \"Wahr ebnyam re e bahke limi ana a bungu no, Jehova li ntianse enyahre.\" ");
INSERT INTO eka_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","Owo Jefta tahme toono anebekul nfam a Gilied, bo lim-e a jol ntubesi no jo gbo bo mbang go ebta. Go Mispa Jefta kpe bung nsol nyia kpee go esamahr bi Jehova nyi á bungu tong anebekul ejahbe. ");
INSERT INTO eka_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","Jefta kehm tumu abatiingetib tv ntul no Amon re á seb kahn ji wahng ka á ma bom abohng a anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","Ntul no Amon kehm faange abatiingetib bao re, \"Ngare nyi Isreel lohngo go Ijib, bo taare ndi enyahre, bomo go aya ma Amon tete song rehng go aya ma Jobok, mbang mbang asongo go Jordan. Anv, feeren anyi ka-r enangebeem.\" ");
INSERT INTO eka_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","Jefta kehm tumu eltib tv ntul no Amon, ");
INSERT INTO eka_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","\"Ji ji a ji Jefta kpˈbungu: Ndi nyi Moab, afii nyi anebe Amon, Isreel taarem. ");
INSERT INTO eka_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","Ngare nyi bo lohngo go Ijib, bo sehnge elka emahng asongo go Abili Aya tete song rehng go Kadesh. ");
INSERT INTO eka_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","Bo tumu eltib tv ntul no Edom re á lub fa bo nnyo bo sehng go ege ejahbe, á taamem. Ano wo bo tob bahb ntul no Moab, á tob ten. Isreel ba sa go Kadesh. ");
INSERT INTO eka_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","\"Isreel sehnge nkpe nkpe nyio nyi elka emahng nio ni Edom abola Moab, bo sehnge ero nfam, ero nfam nyio nyi Moab, song rehng go nkpe aya ma Anon. Bo tikem siiri aya ma Anon rehng Moab tib o wo nkona ndi jolo no. ");
INSERT INTO eka_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","\"Isreel kehm tumu eltib tv Sihon ntul no anebe Amor, ye ji kuumu go Hesbon re, ˈÁ fa bo nnyo bo sehng go ege ejahbe song rehng edi ji bo fi no.ˈ ");
INSERT INTO eka_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","Sihon, taamem tv bo re bo sehng go ege ejahbe. Á toobo nsoja enye bum go Jahas nyi jo nok a Isreel. ");
INSERT INTO eka_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","\"Jehova, ye ji li Esowo bi Isreel, yake Sihon, a ane ebe kak Isreel abo. Ndi nyio nyi anebe Amor lene no kpee. ");
INSERT INTO eka_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","Anebe Isreel ko edi ndi, bomo go aya ma Anon song rehng go aya ma Jabok, sehng o rehng go elka emahng tete rehng go Jodan. ");
INSERT INTO eka_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","\"Eji Jehova, Esowo bi Isreel ma kam anebe Amor, taare ndi abo ka Isreel. Jenji wahng ka á kpˈsebe re wahr rod ka-a? ");
INSERT INTO eka_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","Anv á nehm ko ji Kemosh, esowo eba ka-a noa? Ano wo fvfo ji Jehova, Esowo ebahre ka-r no, ji ji e bahke koko. ");
INSERT INTO eka_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","Anv, wo wo ga nob sehnge Balak mmon no Sippo ji ntul no Moaba? Á tˈtaange a Isreela, afi nok a bo? ");
INSERT INTO eka_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","Nyehn ejum nnya atahlku ma sehng, nyi Isreel ma lene go ndi nyia, bomo go Hesbon rehng go Aroer, a ajahbe kpee nya li go nkpe aya nyi Anon. Nnya nnya nyia kpee nˈnan a kala ko ndi nyia wuku wuku. ");
INSERT INTO eka_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","Me, n wa ka soodo, á kp-m limi ebi anv ebta bi a ma-r bohko. Nong Jehova, ye ji li nlˈlame no nno, toobo ntong nyia ka-r lela.\" ");
INSERT INTO eka_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","Etib bi Jefta tumu tv ntul no Amon, jol we lubem. ");
INSERT INTO eka_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","Owo, Etohko ji Jehova kehm ba yel Jefta, á kehm yele go atahng ejahbe nya Gilied, Manase, a Mispa ji li go Gilied, song ku nsoja nyi bahke noko a anebe Amon. ");
INSERT INTO eka_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","Jefta kehm koko nwongo go esamahr Jehova re, \"A lˈka-m esehngebta go esamahr anebe Amon, ");
INSERT INTO eka_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","ejum ajehng ajehng ji gbo mbang lohng go egame etahk ba wan-m, eji m ma nok ebta ga anebe Amon, bahke jolo ji Jehova, m bahk-e rodo lim njom nyio nyi bo kpo jahm fi.\" ");
INSERT INTO eka_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","Jefta kehm tahme song nok a anebe Amon, Jehova rodo bo kak-e go ebo. ");
INSERT INTO eka_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","Á rannge ejahbe na eltahl, bomo go Aroer tete rehng go Minit, sehng rehng go Abel Keramim. Ana wo Isreel ga anebe Amon. ");
INSERT INTO eka_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","Re Jefta feere rehng etahk, mmon mmon awohng ewe no nkal wo lohngo ba wan-e, fere jo bahn ase nya bo jo kub. Ki li ye mmon awohng awohng noko á belem. ");
INSERT INTO eka_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","Eji Jefta nyehn-e no, á kehm jabbe nsol ebjing nyˈnye yare, fere biingi tiim, \"Mmon ewame, eltim ename ebrannge kpee eji á lohngo ba wan-m. Me n nyam enyam tong Jehova bi n lˈkˈma kane.\" ");
INSERT INTO eka_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","Mmon kehm faange re, \"Nsoo wobnyam tong Jehova, rod-m lim ana a nyame no. Eji ntul Esowo ma-a ka esehngebta go esamahr anebe Amon, ba li anebekv eba. ");
INSERT INTO eka_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","Tohko lim ejum ajehng jia ka-m ji n kpˈsebe, \"Me n song yannge a ate ebame go ero awong, ling a bo ejum nnyahng ebal, tibre n nehm tiki kpe bal nlum.\" ");
INSERT INTO eka_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","Á kehm-e fake nnyo re á song, \"Song yannge a ate ebe go nnyahng ebal.\" Ate ebe kehm-e toono rehng go ero ewong, song ling a ne, tibre á nehm tiki bal nlum. ");
INSERT INTO eka_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","Eji nnyahng ebal mio ma mal, á kehm feere ba goji nde, á rod-e lim ana á nyame no. Á sa mmongungu. Ana wo eljini ni Isreel fere jol, ");
INSERT INTO eka_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","go elya anehng anehng abongungu anebkal jo lohngo go nfung eni song buumu bada mmon a Jefta ji lohng go Gilied. ");
INSERT INTO eka_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","Anebe Efrem kehm song melle nsoja ebo, siiri song rehng go Safon. Bo kehm tumu etib bia tv Jefta re, \"Jenji wahnge a kehm-r sehnge sa song nok a anebe Amon, a ki-r lung re wahr ba tob-a nok a bo? E bahke jahme etahk eja, a na na fi.\" ");
INSERT INTO eka_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","Jefta kehm faange re, \"Me a ane ebame jo noko egburu enok a anebe Amon, n lung-n lung, m m-e tahrem yehke go ebo abo. ");
INSERT INTO eka_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","Eji n sebe kahn re ḿ m-e nehm tob, n rodo elkpin ename go egame abo, siiri song nok a anebe Amon. Jehova ka-m ka esehnge ebta, n ga bo. Jenji wahnge ń yahke ba nok aname lela?\" ");
INSERT INTO eka_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","Owo Jefta kehm lungu anebe Gilied bo ba kono edi ajehng, kehm song nok a anebe Efrem. Anebe Gilied kehm wulu na wul anebe Efrem, tibre anebe Efrem ebbung re, \"Wahn anebe Gilied, ń li na ane ba Efrem abola Manase ma ten.\" ");
INSERT INTO eka_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","Anebe Gilied ba taare elga ni bo jo siiri rehng go Efrem,edi ji kil ga rahbe, go aya ma Jodan. Nne Efrem no kpˈbeke lˈba elsiiri, anebe Gilied bahk-e sahde go mbang, fere bahb-e re,\" Wo nne a Efrem woa?\" Á lˈfaange re \"Eˈee,\" ");
INSERT INTO eka_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","bo bahk-e tongo re, \"Ebnob,\" lung re, \"Siboled.ˈ \" Á lˈfere lung re Siyiboled, tib eji á ki ma lung nobnob, bo bahk-e bobo song wul go elga Jodan. Anebe Efrem ba kpo ngare nyio jolo ane atahltahl nkpel atahl alon, a nkpel elon. ");
INSERT INTO eka_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","Jefta ji lohng go Gilied fili Isreel nnya erakera, kehm kpoko, bo kpa-e kak go Gilied. ");
INSERT INTO eka_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","Eji Jefta ma kpo owo Ibsan ji lohng go Betlehem bomo Isreel go elfili. ");
INSERT INTO eka_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","Abone ebe ba nlum jolo eltahl abon awubu, ba nkal jolo eltahl abon awubu fvfo. Á rodo abon ebe ba nkal tang abangenahb nyandiki. Á tob ko agbahme go abangenahb nyako ba ka abone ebe ba nlum. Ibsan fili Isreel go nnya esehma. ");
INSERT INTO eka_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","Elkohro, Ibsan kehm kpoko, bo kp-e kak go Betlehem. ");
INSERT INTO eka_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","Eji Ibsan kpo no, Elon ji lohng go Sebulon bomo Isreel go elfili. Á fili Isreel go nnya ewubu. ");
INSERT INTO eka_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","Elon kehm tob kpo, bo kpa-e kak go Aijalon ji li ndi nyi Sebulon. ");
INSERT INTO eka_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","Eji Elon kpo no, Abdon mmon no Hilel ji lohng go Piraton, bomo Isreel go ellame. ");
INSERT INTO eka_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","Á bele abon atahl abal ba nlum, abon abon ebe jolo eltahl abon awubu, bo jo kuumu go ebvankang bi jolo atahl ara ewubu. Á lame Isreel go nnya enehkeni. ");
INSERT INTO eka_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","Abdon mmon no Hilel kehm kpoko, bo kpa-e kak go Piraton ji li go Efrem, ejahbe ewong ji anebe Amalek. ");
INSERT INTO eka_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Anebe Isreel kehm kpe lim abˈbi go esamahr bi Jehova, á kehm faake bo kak Filisia go abo, go nnya atahl abal. ");
INSERT INTO eka_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Nne awohng jolo go no bo kpo lung-e re Manoa, á lohng go Sora ji li go elwo Dan. Nkal ewe jolo ngum, mmon awohng awohng á jelem. ");
INSERT INTO eka_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Efung abehng enjel nyi Jehova kehm lohngo ba go ege kehm ba tong-e re, \"A li ngum, mmon awohng awohng a kpimm. A bahke sake ela jel mmon no nlum. ");
INSERT INTO eka_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Ka wo amahm ewoko woko, jol ejum elwoko ajehng ajehng ji kpo lim, ka tob li ejum ajehng ajehng ji ki li saang, ");
INSERT INTO eka_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","tibre a bahke sake ela jel mmon no nlum. A nehm kun-e elsem go ege esi, tibre bo bahk-e rodo kak Esowo go ebo. Bomo efung bi bo jel-e no, bo bahke koko nwongo re á bahke jolo eje eje ka Esowo. Á bahke tahre Isreel yehke go abo nya Filisia.\" ");
INSERT INTO eka_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Nnenkal noa kehm soro mehl song kpiri nlum we, kehm-e tongo re, \"Nne Esowo awohng baa ba kpir-m, á jolo are enjel nyi Esowo nyi, nne lˈseeng-e á bahke bele elfahle. We m bahbem edi ji á lohng no ba, jol mbing enye á me-e tongem. ");
INSERT INTO eka_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Á bungu aname re, ˈA bahke sake ela jel mmon no nlum. Bomo anv asongo, ka tiki wo amahm ewoko woko, a ejum ajehng ajehng ji ma mang ji bo kpo wo, fvfo ka tiki li ejum ji ki li saang, tibre mmon no nlum no a bahke jele bahke jolo mmon no bo ma lim nwongo re bo bahk-e rodo á jol eje eje ka Esowo, bomo go efung bi bo bahk-e jele tete á kpo.ˈ \" ");
INSERT INTO eka_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Owo Manoa kehm kake ero tong Jehova re, \"Nsoo, n kp-a gboongo , lub lim nne Esowo noo kpe feere ba, ba tib-r ana e bahke fili mmon noa no e bahke jele.\" ");
INSERT INTO eka_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Esowo kehm faange Manoa. Enjel nyi Esowo kehm kpe ba kpiri nnenkal noa eji á li go egbe. Manoa nlum we jolem o a ne. ");
INSERT INTO eka_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Nnenkal noa kehm beke song lung nlum re, \"Nne no ba tiing-m etib nyanjehle, yeb kpe ba.\" ");
INSERT INTO eka_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Manoa kehm feere toono nkal, ba kpiri nnenlum noo, kehm-e bahbe re, \"Wo ba bung a nkal ewame nyanjehla?\" Á kehm faange Manoa re, \"Me wo.\" ");
INSERT INTO eka_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Manoa kehm-e bahbe re, \"Anv, alum nya a ma-r tong lˈlohko jol ano, e bahke jo fili mmon noa renan, eltum anii á bahke jo lim?\" ");
INSERT INTO eka_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Enjel nyi Jehova kehm faange Manoa re, \"Lim eji nkal ewa lˈtoono ajehng ajehng ana m me-e tong.\" ");
INSERT INTO eka_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Á kˈtiki li ejum ajehng ajehng ji lohng go nlehke avain, á kˈwo amahm amehng amehng, afi ejum ajehng ajehng ji ma mang, jol á kˈli ejum ajehng ajehng ji ki li saang. Nong á tiki bum ajehng ajehng ji n tong-e re á bum. ");
INSERT INTO eka_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","Manoa kehm bungu tong enjel nyi Jehova re, \"Ji a wahr tohko song wul mbul, lam nsol ka-a.\" ");
INSERT INTO eka_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","Enjel nyi Jehova kehm-e faange re, \"Jol afi a bob-m na bum a, n nehm tiki li ejum alehke eja. A lˈfere toobo re wo lim njom nyi bo kpo jahm na fi, lim ka Jehova.\" ");
INSERT INTO eka_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Manoa kehm bahbe enjel nyi Jehova re, \"Mbing enya mee? Eji ejum ji a ma-r tong lˈjol ano e lˈkpun-a.\" ");
INSERT INTO eka_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Owo enjel nyi Jehova kehm-e tongo re, \"Nˈnan a kpˈbahbe mbing enyame, n lˈtong-a a nehm kahn.\" ");
INSERT INTO eka_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Manoa kehm koko mombul, a ayare nya nkohl, kehm song lim njom go ekpartal ka Jehova. Jehova limi nkpokosi ejum ji Manoa abola nkal jo seenge: ");
INSERT INTO eka_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","Ana agun jo lohng go edi njom, mehle tortor ton esi go elbung, enjel nyi Jehova tob mehl toono ebliki agun asongo go elbung. Eji Manoa a nkal nyehne ano bo gboko kohk asamahr ebo go ndi. ");
INSERT INTO eka_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Eji enjel nyio ki kpe feere ba goji Manoa abola nkal, owo Manoa ba kahn re enjel nyi Jehova nyi. ");
INSERT INTO eka_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Manoa kehm tongo nkal ewe re, \"E bahke kpokao, tibre wahr ebnyehn Esowo!\" ");
INSERT INTO eka_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Owo nkal kehm-e faange re, \"Li re Jehova sebe re á wul-r, kehn á jolem koko ayare nya bo kpo jahm fi, a nya nkohl go egahre abo, jol á wahr jolem tibi nsol nyia, fere tob tong-r nsol nyia.\" ");
INSERT INTO eka_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Nnenkal noo kehm jele mmon no nlum, kehm-e kake mbing re Samson. Mmon noo kehm gbale, elfuulu ni Jehova jolo a ne. ");
INSERT INTO eka_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Etohko ji Jehova kehm kehme ellimi eltum go ege elkpin eji á jolo go Mahane Dan, go elka elka no Sora abola Estaol. ");
INSERT INTO eka_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Efung abehng, Samson je go Timna, song nyehn ngbahme, á jolo nne a Filisia. ");
INSERT INTO eka_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Eji Samson feere ba rehng etahk, á ba tongo nde abola nnyehn re, \"Me n nyehn mmon a Filisia no nkal go Timna, koon ye ka-m, á jol nkal ewame.\" ");
INSERT INTO eka_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Nde abola nnyehn kehm-e faange re, \"Anv, nnenkal awohng awohng a nyehnem go ellong akunu enyahre, a ane ebahre kpeea? Jenji wahnge a bahke tahme goji anebe Filisia ba kˈlˈyehke nrur song seb nkal? Samson kehm tongo nde re, \"Ko-e ka-m, ye wo n kpe-e sebe.\" ");
INSERT INTO eka_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","(Jol nde abola nnyehn kahnem re Jehova kpˈsebe na mbang nyi á bahke koko ntong ba ka Filisia, tib ngare nyio bo ba jo fili Isreel). ");
INSERT INTO eka_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Samson tahme go Timna, a nde, go nnyehn, eji bo rehnge edi egbe agreb ji anebe Timna. Owo egabe kehm ba kehme elnoko a Samson. ");
INSERT INTO eka_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Ngare nyˈnehm o, Etohko ji Jehova kehm ba yel-e fere ka-e nsahm á kehm jabbe egabe yare abo abo, are á yare mombul. Jol nde abola nnyehn a tongem bo ji á ma lim. ");
INSERT INTO eka_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Eji Samson song rehng go Timna, á kehm song bung a nnenkal. Samson nnenkal noo jo kor-e kor. ");
INSERT INTO eka_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Eji ma kang abon afung, á kehm feere re á song lim elbal ebo, á kehm yange go ekul re á song nyehn ekpakv egabe jio. Á song nyehne ekon ma yel o, bi ma lim akehng, ");
INSERT INTO eka_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","á sa o kehme, rod abo song raabe akehng ekon jo yab mbang mbang. Eji á song kpiri nde abola nnyehn, á kehm tob ka bo, bo yab. Á tongem bo re akehng ekon mao lohng go ekpakv egabe. ");
INSERT INTO eka_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Ana nde tahme song kpiri nnenkal, ano wo Samson song lim elkak ana eljini ajangkun jolo no ngare nyi bo kpˈlimi elbal ebo. ");
INSERT INTO eka_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Eji Samson ba no anebe Timna ka-e eltahl atem awubu ba bahke jo jen a ne. ");
INSERT INTO eka_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Samson kehm bungu re, Tong-m wahn ana elgan nia lohngo no. Ń lˈtong-m go nfung esehma nyi elkak nia bahke jolo, m bahk-n kake eltahl ebehn ebwubu, a eltahl a mbomo ewubu. ");
INSERT INTO eka_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Ń tohkem ma tong ana lohngo no, ḿ bahk-m kake eltahl ebehn ebwubu, a eltahl ajoobo abomo ewubu. Bo kehm-e tongo re, \"Tong-r elgan ena.\" ");
INSERT INTO eka_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Á kehm bungu re, \"Nsol alehke eblohng goji nne no kpo li, go etahntahn edi nnyebeyebe ejum eblohng.\" Go nfung era kohro kohro, bo maam tiki kahn ana lohngo lohng. ");
INSERT INTO eka_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Eji ma biingi nfung eni, bo kehm tongo nkala Samson re, \"Leebe nlum wa á tong-a, wo ba tong-r elgan ni á tong-r no. Tohko jol ano e bahk-a fehke a ane kpee ba li go etahk nso. Anv, ń tiing-r na elkak re wahr ba gbo ekpaka? ");
INSERT INTO eka_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Owo nkala Samson kehm bake a abonngo go amahr, kehm tongo nlum re, \"N wa nehme kor, n kp-a sabe! Wob tub ane ebame elgan, m-e a tong-m ana lohngo no. Á kehm-e faange re, \"Jol nsoo abola nnee n ka tong bo, jenji wahnge m bahk-a tongo?\" ");
INSERT INTO eka_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Ano ano wo nkal jo ling go nfung esehma nyi elkak nio. Esˈkohro efung bi biingi nfung esehma á kehm-e tongo tibre á gbiing-e sehng. Ano wo á feere no song tong ane ebe. ");
INSERT INTO eka_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Ntuumu nyi elgung esˈkohro efung bio, afono ejahbe bao kehm ba tong-e re, \"Ejum aji kpˈyebe sehnge akehng ekon? Jenji kpˈtahne sehnge egabe? \"Samson kehm bungu tong bo re, \"Ki li re wahn, a nne no li badbad a name, kehn ḿ m-e jolem ma tong ana elgan ename lohngo no.\" ");
INSERT INTO eka_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Etohko ji Jehova kehm ba yele fere ka- nsahm, á kehm song rehng go Askelon, song wul eltahl ane awubu go ejahbe jio, fere taare bo nsol ebo kpee. Á koo abomo ane bao, ba ka ane ba tong-e ana elgan nio lohngo no. Eji ma jol ano, rake Samson atahng sehng, á soro mehl o kehnge etahk nde. ");
INSERT INTO eka_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Nkala Samson bo rod-e ka ekpondahme Samson ji jolo o elkak. ");
INSERT INTO eka_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Eji ma kang abon afung ntiil, ngare nyi kpo banne nkohl, Samson kehm rodo mmona mbul, tahm re á song nyehn nkal ewe. Á tongo nde nkal re á kpˈsebe re á song kang a nkal ewe. Nde nkal taamem. ");
INSERT INTO eka_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Nde nkal kehm-e tongo re, \"N tiri re, á wa nehme kor, n rod-e ka ekpondahme eja. Nyehn mmonannyehn no nse, ye wo kpˈgaka nob, feere wo ba ko ye go elbal.\" ");
INSERT INTO eka_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Samson kehm bungu re, \"Anv, Nnene m-e nehm ma ka ebi ajehng ajehng, n lˈlim Filisia ebi.\" ");
INSERT INTO eka_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Samson kehm lohngo song bob mbehr atahlku, jabbe ebbal ebbal go eboa nsil kanne, á tob jo gbade nkahr semme go eboa nsil ebal ebal. ");
INSERT INTO eka_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Á kehm kake agun go nkahr nyio, fere yake bo, bo jo be go atahng egbe nkohl ji anebe Filisia. Ano wo á limi no fi nkohl nyi anebe Filisia kpee wohng go ndi, a nya bo gba agan agan. Bo tob rannge ebgbe agreb, a ebgbe oliv kpee. ");
INSERT INTO eka_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Anebe Filisia kehm bahbe re, \"Nne awo limi ejum jia?\" Bo kehm faange bo re, \"Samson wo, ye ji ko mmon no nne a Timna, tibre bo m-e taare nkal ka nte ewe. Anebe Filisia kehm tahme song jahm nnenkal noo, a nde fi go agun. ");
INSERT INTO eka_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Samson kehm bungu tong bo re, ˈˈEji ḿ ma lim ana, n nehm tiki rahke tete m bong-n kpee biing-m.\" ");
INSERT INTO eka_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Á mehle a egburu erakatahng song nok a bo, wul ane gbalee. Á mehle song woomo go nkpaltal nyio go Etam. ");
INSERT INTO eka_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Anebe Filisia kehm ba bum elsi ebo go Juda, bo nyange elsi ebo rehng go Lehi. ");
INSERT INTO eka_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Anebe Juda kehm bahbe anebe Filisia re, \"Jenji wahnge ḿ ma ba elnoko a nahre?\" Bo kehm faange bo re, \"E ba re wahr ba bob Samson, fere bong-e ana ji á ma-r lim.\" ");
INSERT INTO eka_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Ane atahltahl nkpel esehma, ane atahl awubu ba Juda kehm tahme song kpiri Samson go nkpaltal nyi jolo go ewong ji Etam. Bo tongo Samson re, \"Á nehme kahn re Filisia ji kp-r fila? Jenji a kp-r limi ana?\" Samson kehm faange bo re, \"Elbongo ni m bongo bo.\" ");
INSERT INTO eka_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Bo kehm tongo Samson re, \"E ba re wahr ba gba-a, rod-a song faake kak anebe Filisia go abo.\" Samson kehm bungu re, \"Nyamen tong-m re, wahn m-e nehm wul antahng.\" ");
INSERT INTO eka_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Bo kehm-e faange re, \"E wa nehm wul, e bahk-a gbake na gba abo, faak-a kak bo abo.\" Bo kehm gbake Samson go alehke nfenfe na abal, lohng a ne go nkpaltal nyio. ");
INSERT INTO eka_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Eji anebe Filisia ba rehng a Samson go Lehi, bo kehm kimi abohk, jo rabe ana bo m-e bel. Etohko ji Jehova kehm ba ko nji go ege elkpin ba ka-e eko. alehke nya bo gba-e no kehm geebe are ngbakehrebo nyi, lohng-e go abo gbo. ");
INSERT INTO eka_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Á kehm soro lamme rod elyar mbvankang nyi noongo go ndi, nyi bo kpehn-e wulu, wul ane atahltahl nkpel ebal atahl awubu ba Filisia. ");
INSERT INTO eka_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Samson kehm bungu re, \"A elyar enyˈnya go egame ebo, me n wul bo bum abim abim. A elyar mbvankang me n ko wul ane atahltahl nkpel ebal atahl awubu.\" ");
INSERT INTO eka_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Eji á ma bung ano kpee mal, á kehm roko elyar mbvankang nyio go. Bo gungu edi jio mbing re, Ramat-Lehi. (ji lohngo re ewong elyar nnyam) ");
INSERT INTO eka_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Eji alahb m-e kor, á kehm rabe lung Jehova re, \"Wob nok ebta bia sehng go abo nya nlokeltum ewa. Anv, me n kpo ekor lahba, fooro yel abo ane ba kˈlˈyehke nrura?\" ");
INSERT INTO eka_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Jehova kehm limi alahb lohng go elbing anehng go Lehi, ana Samson wo no , ano wo á feere bel eko ana wuku wuku. Bo jo lungu elbing alahb nio re En Hakore (lohngo re elbing alahb ni nne lingi no ane wuk). ");
INSERT INTO eka_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Samson lame Isreel go nnya eltahl, ngare nyio anebe Filisia ba jo fili edi. ");
INSERT INTO eka_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Efung abehng Samson tahme song rehng go Gasa. Á song nne asˈsa awohng soro bum elkang a ne. ");
INSERT INTO eka_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Etib kehm rehnge anebe Gasa re Samson li o. Anebe Gasa kehm gbake elbo toobo bum nnyo amehng re bo song biiri go eti mbu jo sik-e. Bo jolo o soom atv atv mao kpee, jo bung re efunfu lˈba elseke, e bahk-e wulu. ");
INSERT INTO eka_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Samson noongo o tete atv kul. Á kehm mehle song melle ati mbu nya ejahbe, ebbal ebbal, a mbil a mbil enye. Á melle kunu go ebahk, sol song kunu go ero ewong ji li mbuksong nyi Hebron. ");
INSERT INTO eka_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Eji ma kang abon afung, Samson ba bele nnenkal go ejahbe ji jolo edamme ji bo kpo lung re Sorek. Bo jo lung-e re Delila. ");
INSERT INTO eka_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Owo atubesi anebe Filisia kehm bungu tong Delila re, \"Were Samson á tong-a edi ji eko eje behr no, eji e bahk-e ma ko elfono, fere gba-e, taare eko eje. Nne awohng awohng ewahre bahk-a kake ebahk asilva atahltahl nkpel ebal, ebahk atahlku. ");
INSERT INTO eka_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Efung abehng Delila kehm tongo Samson re, “Tong-m ejum ji kpo ka-a elkohn eko ana jia, tob tong-m ana nne bahk-a ma gba ko-a elfono.” ");
INSERT INTO eka_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Samson kehm-e faange re, \"A lˈko nlehke na esehma bi mbir mbir gba-m, m bahke fere jol ana nne noka noka.\" ");
INSERT INTO eka_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Owo anebekul Filisia kehm koko alehke mbir mbir nyao na esehma ba ka Delila, á rod gba-e. ");
INSERT INTO eka_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Ane biiri o ekpˈkpa ajehng etahk jio. Delila kehm rabe, \"Samson, anebe filista ma-a ba elbo bao! Samson tohngo na tohng alehke nyao were na were go abo, are bo tono nlehke mio go agun. Edi ji eko eje behr no bo kahnem. ");
INSERT INTO eka_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Delila kehm tongo Samson re, \"Á kp-m koko na lim mbene, fere kp-m tongo afahnge. Titi anv, tong-m ana m bahk-a ma gba, fere ko-a elfono.\" ");
INSERT INTO eka_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Samson kehm-e faange re, \"Bo lˈgba-m alehke nfenfe nya bo kala kˈko gba ejum, m bahke jolo ana nne noka noka.\" ");
INSERT INTO eka_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Owo Delila kehm koko alehke nfenfe ba a nya ba gba-e. Eji ane ba biiri go ekpˈkpa ana bo biiri ngare nyehko wuku Delila ma rabe, \"Samson, anebe Filisia ma-a ba elbo bao.\" Samson tohng alehke nyao kiimi go ege abo are av nya. ");
INSERT INTO eka_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Delila kehm bungu tong Samson re, \"Tete rehng anv, a kpˈlimi na mbene aname, fere jo tong-m afahnge! Tong-m ana m bahk-a gbake . \" Á kehm faange re, \"A lˈtahng alvsi na esehma fere fer go ejum ji bo kpo tub abomo, fere kahn ekud, m bahke jolo ana nne noka noka. Eji á jo lal, Delila kehm ba tahng alv asehma nyao fere tub, ");
INSERT INTO eka_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","fere kahn ekpud, bade go ejum, tub abomo baade tv. Owo Delila kehm kpe rabe lung-e, \"Samson, anebe Filisia ma-a ba elbobao!\" Á kehm yahme go ellu, wob nga nyio nyi bo baade alv esi tv go edi ji kpo tub abomo. ");
INSERT INTO eka_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Delila kehm-e tongo re, ˈJenji wahnge a kpˈbungu re, \"N kp-a koro, eji a kalem tong nsol nyi behr-a go eltim? Anv, eblim nkpel era nyi a ma-m nehm. A ma-m ten eltongo edi ji egburu eko eja behr no. ");
INSERT INTO eka_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Ano wo efung abehng abehng á jo gbiing-e tete á lahng fere jo yam go ngbˈgbiingi nyi á kp-e gbiingi. ");
INSERT INTO eka_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Esˈkohro Samson lennge ejum ajehng ajehng ka-e, kehm-e tongo re, \"Alv esi enyame bo ka kˈkiimi go esem. Tibre n li eje eje ka Esowo, bomo eji bo jel-m no. Bo lˈkiimi alv esi enyame, eko ejame bahke lohngo. M bahke jolo ana ane baka baka.\" ");
INSERT INTO eka_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Eji Delila sebe kahn re á me-e tong etingitingi, á kehm tumu etib tv atubesi Filisia re, \"Kpe-n feere ba anv, á ma-m tong ejum ajehng ajehng. Ana bo ba no, bo ba a akpohko nya bo taame no. ");
INSERT INTO eka_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Delila kehm were Samson lal-e go ayo. Á kehm lungu nne ba yel, no ba kpud-e alv esi enye, ano wo eko eje gbodo no, soro yak-e abo. ");
INSERT INTO eka_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Owo Delila kehm rabe re, \"Samson anebe Filisia ma-a ba elbobao! Á nyahme kan a me, \"Á kehm tiri re, a bahke lohngo ana á kpo kono ellohngo wuku wuku, gbehre eje for. Jol á tikem kahn re Jehova m-e yake abo. ");
INSERT INTO eka_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Owo anebe Filisia kehm-e bobo, luud-e amahr, rod-e tahm go Gasa. Bo kak-e afarebok abrons go abo, fere bum-e á jo gok nsol go ngbekobo go eltal ngoko. ");
INSERT INTO eka_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Eji ma abon afung, esi ji bo m-e kpud kehm kehme elkohdo. ");
INSERT INTO eka_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Atubesi Filisia kehm ba gba ji, ba lim egburu elkak ni bo bahke limi egburu njom ka Dagon ji jolo esowo ebo, fere geere re, \"Esowo ebahre ebga Samson nnekv ewahre, faak-e kak-r go abo.\" ");
INSERT INTO eka_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Ana ane nyehn-e no bo kehm kehme esowo ebo tehk, fere jo bung re, \"Esowo ebahre ebfaake nnekv ewahre kak-r go abo. Nne no wulu ane ebahre gbalee wob go egahre abo.\" ");
INSERT INTO eka_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Eji bo ma wo fere kpˈbuumu, bo bungu re, \"Koon Samson ba a ne, á ba bahn ase ka-r wahr nyehn. Bo kehm yehke Samson go ngbekobo ba a ne, á ba kehme elbahne. Bo bum-e á yiimi kohlo ago. ");
INSERT INTO eka_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Samson kehm bungu tong nlokeltum no jabb-e ebo jo jen a ne re, \"Tv-m me n song jabbe ago nya kpˈtobo etahk elom jia.\" ");
INSERT INTO eka_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Ngare nyio anebelum, a anebkal anebkal, a atubesi Filisia kpee wob go etahk jia, go enyong bo jolo ane atahltahl nkpel esehma ane atahl awubu bo jo nyehne ana Samson kpˈbahne ase tib bo. ");
INSERT INTO eka_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Samson kehm kake ero ka Ntula Jehova re, \"Jehova, wo wo ga kpi nsahm, kpe-m buumu nkpel nyia, kpe-m ka atahne nkpel nyia nyi nyi, eji n lˈbongo anebe Filisia go esi amahr enyame.\" ");
INSERT INTO eka_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Samson kehm nyange abo enye jabbe ago nya etahk elom jia kun no. Á jabbe ego jehko go eboblum, jehka ebobkal. ");
INSERT INTO eka_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","Á kehm bungu re, \"Nong me n kpo a anebe Filisia!\" Á kehm nyaame ago nyao, etahk jio gbo bulu abafili ane a ane bao kpee ba wob go atahng. Go ege elkv wo á ga wul ane sehnge ana á jolo go elkpin. ");
INSERT INTO eka_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Abonanyehn, a ebangenahb nde kpee kehm ba rod ngubjing enye tahm a nyi kehnge. Bo song kpa-e kak go elka elka ni Sora abola Estaol, kohlo elahm nde Manoa. Á fili Isreel nnya atahl abal. ");
INSERT INTO eka_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","Nne awohng no bo lung-e re Maika, á lohng go ewong ejahbe ji Efrem, ");
INSERT INTO eka_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","á bungu tong nnyehn re, <<Me wo rodo abahk asilva atahltahl nkpel ebal atahlku nyao nya a jo su re bo ma-a v, nyaa go egame.\" Nnyehn kehm bungu re, \"Jehova fuula mmon ewame.\" ");
INSERT INTO eka_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","Eji á feere asilva nyao ba ka nnyehn, nnyehn kehm bungu re, \"N bahke faake asilva nyaa kpee ka Jehova tib esi mmon ewame. M bahke rodo lim asowo, konngo a silva feere a nya ba ka-a.\" ");
INSERT INTO eka_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","Maika feere asilva nyao song ka nnyehn. Nnyehn kehm rodo abahk asilva atahl awubu ka nfohkotahl, á kehm koko lim asowo fere konngo asilva. Bo rodo asowo nyao bum go etahk Maika. ");
INSERT INTO eka_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","Maika limi ekahnlom, á tob limi nkpehrekabe ewobo ji njomanjom kpo kak, fere lim asowo. Á rodo mmon ewe awohng re á jol nlimanjom. ");
INSERT INTO eka_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","Ngare nyio, Isreel ntul bo belem, nne awohng awohng jo limi ji kpe-e koro. ");
INSERT INTO eka_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","Ngare nyˈnehm o njankun anyehng jolo go nyi lohng go etˈtohng ji Levi, á lene go Betlehem ji li go Juda. ");
INSERT INTO eka_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","Á mehle Betlehem re á song seb edi jindiki lene. Ana á kpˈjene mbang mbang asongo, á kehm ba rehng go etahk Maika ji li go ejahbe ewong ji Efrem. ");
INSERT INTO eka_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","Maika kehm-e bahbe re, \"Gan wo a lohng no kpˈbake a?\" Á kehm faange Maika re, \"Me nne no lohng go etˈtohngo ji Levi wo, ejahbe ejame Betlehem ji li go Juda ji. N kpˈsebe edi ji m bahke lene.\" ");
INSERT INTO eka_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","Maika kehm bungu tong-e re, \"Jol a name a, wo jol nsoo, a nlimanjom ewame. Go elya m bahk-a kake akpohko asilva na ebwubu, a nsol alehke, go nsol elkake nyi ngubjing.\" ");
INSERT INTO eka_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","Njangkun nyia nyi lohng go etˈtohngo ji Levi ba taame re á bahke lene a ne. Á jolo a ne are mmon ewe wo. ");
INSERT INTO eka_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","Maika kehm rodo njangkun nyia á jol nlimanjom ewe, á lene o etahk Maika. ");
INSERT INTO eka_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","Maika kehm bungu re, \"N kpˈkahne re, Jehova bahke limi nsol nob a name, tib nnea Levi noa ebba jol nlimanjom ewame.\" ");
INSERT INTO eka_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","Ngare nyio Isreel ntul bo belem. Etˈtohngo ji Dan jo sebe re, bo bel edi ellene, tibre ngare nyio bo ka tiki bel edi ndi ji bo ellong atˈtohngo nya Isreel. ");
INSERT INTO eka_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","Anebe Dan kehm tumu atakuru ane na alon ba lohng go Sora abola Estaol re bo song weele kpur edi ji bo bahke song lene. Ane baa jolo go esi enyo ebangenahb ebo. Bo yele go ejahbe ewong ji Efrem, kehm ba rehng go etahk ji Maika fere kang o. ");
INSERT INTO eka_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","Re bo kehm rehnge go etahk Maika, bo liingi ellum ni njangkun nyio nyi lohng go etˈtohngo ji Levi, ano wo bo yange go etahk jio. Bo rod-e feere a ne go nkpe, kehm-e bahbe re, \"Nne awo ko-a ba a? Jenji a kpˈlimi edi jia? Jenji wahnge a li li a?\" ");
INSERT INTO eka_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","Á kehm ba tong bo bade ana Maika m-e bum, anv ye wo li nlimanjom no Maika. ");
INSERT INTO eka_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","Bo kehm bungu tong-e re, \"Bahb Esowo, joare eljen enahre nia bahke nobo, afi nehm nob.\" ");
INSERT INTO eka_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","Nlimanjom noo kehm faange bo re, \"Songen soom, Jehova bahk-n gboko mbang.\" ");
INSERT INTO eka_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","Atakuru ane alon bao kehm mehle ba rehng go Lais, edi ji bo ba kpiri ane ba jolo elkpin nehka nehka jol ejumjum joom lub bo, ana anebe Saidon. Ntong anyehng anyehng kpeem jol. Bo jolo go elkoono kpee sennge bo kak. Bo jolo afangane, tibre bo bele nvemma ndi nyi jo lak nsol. Tob jolo re bo jolo fee, jol bo kpidem Sidon, afi bel ekpakebjing ajehng ajehng a ane ba jolo kpidi kpidi. ");
INSERT INTO eka_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","Eji bo feere no ba rehng go Sora, a Estaol, abonanyehn kehm bahbe bo re, \"Nsol go jolo renan?\" ");
INSERT INTO eka_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","Anebelum bao kehm bungu re, \"Wahr noken a bo! Wahr ebyehn re ndi nyia kpˈnobo. Kana laange, e tahmen song koon edi jio. ");
INSERT INTO eka_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","Ń lˈrehng o, ḿ bahke nyehne ane kpˈlimi nsol nyi kpi bo kor, ejumjum kpehme lub bo. Esowo ma-r ka nvemma ndi nyia, elehng ajehng ajehng e limm.\" ");
INSERT INTO eka_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","Owo ane atahltahl atahl awubu ba lohng go etˈtohng ji Dan kehm kake nsol ebta. Bo lohng go Sora, a Estaol. ");
INSERT INTO eka_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","Bo bumu elsi ebo go erede bi Kiriat-Jearim ji li go Juda. Owo wahnge bo kpo lung edi jio re Mahane Dan tete rehng lela. ");
INSERT INTO eka_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","Bo kehm mehle o tahm go ejahbe ewong ji Efrem sehng song rehng go etahk Maika. ");
INSERT INTO eka_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","Atakuru ane alon bao, ba song feede ndi go Lais kehm bungu tong ane bako re, \"Ń kpˈkahne re, etahk ejehng go ntahk nyia kpi ebulungang ji nlimanjom kpo kak, a abon asowo, go ji bo limi go eti, a ji bo mongo na. E kpˈkahne ana e bahke limi.\" ");
INSERT INTO eka_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","Ane bao na alon kehm tahme go etahk ji Maika, edi ji njangkun nyia nyi lohng go etˈtohngo ji Levi lene no song kak-e nnyo. ");
INSERT INTO eka_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","Ana atakuru ane bao, ane atahltahl atahl awubu ba lohng go etˈtohngo ji Dan yim go alatahk, ");
INSERT INTO eka_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","atakuru ane alon ba song feede edi kehm yele go ekahnlom song rod elokelom, a ebulungang jio, alokelum nya li ka ebangenahb, a elokelom jehko ji bo mongo na. Ngare nyio, nlimanjom, a ane atahltahl atahl awubu ba fili nsol ebta yim go mbuga. ");
INSERT INTO eka_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","Eji nlimanjom noo nyehne ana bo kpˈrodo elokelum go etahk Maika ji bo rahme na, a ebulungang a asowo nyako nya li ka ebangenahb, a elokelom jehko ji bo mongo na, á kehm bungu re, \"Jenji ń kpˈlimi a?\" ");
INSERT INTO eka_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","Bo kehm-e tongo re, \"Bulu nnyo, wo tahm toon-r! Ba jol nsoo, a nlimanjom ewahre. Anv jinji ga nob! re wo jol nlimanjom ka etˈtohngo kohro kohro, afi wo jol ka nne awohng?\" ");
INSERT INTO eka_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","Nlimajom noo bele eyebatahng sehng. Á rodo ebulungang ji nlimanjom, a elokelom ji bo rahme na, tahm toono ane bao. ");
INSERT INTO eka_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","Bo rodo abon ebo, a ntohkondi ebo, a nsol nyi bo kpi no bum go mbuksong, sennge elbo tahm. ");
INSERT INTO eka_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","Eji bo ma lohng go etahk Maika jen mmokv ntiil, owo ane ba lene kohlo etahk Maika kehm fohko elbo, kehm kehme anebe Dan kam. ");
INSERT INTO eka_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","Ana bo kpˈrabe jo toono bo go nnahb, owo anebe Dan kehm sennge bung tong Maika re, \"Jenji wahng ka a ma lung ane eba re bo ba nok anahre?\" ");
INSERT INTO eka_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","Á kehm faange bo re, \"Wahn ebrod asowo enyame nya n limi no, a nlimanjom ewame fi a ne. Jenji kpe-m li go abo? Nˈnan ń kp-m bahbe re, ˈJinji kp-a kake elgbiingi?ˈ \" ");
INSERT INTO eka_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","Anebe Dan kehm bungu re, \"Jo kunen ekpu ejum ji ń kpˈbungu. Ane ba kpo rak atahng sohksohk li egahre ellong. Bo bahke ma rak atahng ba wul-a, a ebangenahb eja.\" ");
INSERT INTO eka_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","Anebe Dan soro asi go eljene asongo. Eji Maika nyehne re ane bao kpˈtahne sehng-e, á feere eje kehnge go ege etahk. ");
INSERT INTO eka_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","Bo rodo asowo Maika, a nlimanjom ewe song rehng go Lais re bo song nok a bo ji ki jo seb atong, bo belem ebaabe ebjing. Bo song noko a bo, wul bo kpee, fere jamme ntahk ebo fi. ");
INSERT INTO eka_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","Nnene jolem no bahke tahre bo. Bo jolem kohlo Saidon, jol ekpakebjing ajehng ajehng bo belem a nne awohng awohng. Ejahbe jio jolo go edamme kohlo Bet-Rehob. Anebe Dan tuungu ejahbe jio si, fere lene o. ");
INSERT INTO eka_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","Bo fere gungu ejahbe jio mbing re Dan ana bo jo lung nde bo, ye ji Isreel (Jekob) jel-e no. Ejahbe jia wuku wuku bo lungu re Lais. ");
INSERT INTO eka_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","Anebe Dan kehm limi egudu ji bo kunu asowo, Jonatan mmon no Gesom ji jolo mmon no Mosis, a abon ebe ba jolo abalimajom ka etˈtohngo ji Dan, tete ngare nyi bo rodo bo tahm eju. ");
INSERT INTO eka_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","Bo soro asi jo rod alokelom nyaa nya Maika ma lim, ngare kpe kpe nyi etahk Esowo jolo go Silo. kake asowo nyaa nya Maika limi no, eji etahk Esowo jolo go Silo. ");
INSERT INTO eka_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","Afung nyao Isreel ntul bo belem. Nne awohng jolo go no lene go ejahbe awong ji Efrem. Á lohng go etˈtohngo ji Levi. Á ko nne elkang awohng go Betlehem ji Juda ba a ne. ");
INSERT INTO eka_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","Nnenkal noo joom kpunu nlum mbang anyehng anyehng. Á be nlum sa, feere song kehnge go etahk nde ji li go Betlehem ji Juda. Eji ma kang ejum nnyahng eni, ");
INSERT INTO eka_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","nlum we kehm tahme re á song ko-e feere a ne. Á je a aloketum ebe, bo fili mbvankang ebal. Nnenkal kehm ba wan-e go mbang, fere ko-e song yel a ne go ekpˈkpa nde, eji nde nyehn-e no, atahng yebe sehng. ");
INSERT INTO eka_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","Nde nnar, nde no mmonse nkal jo sebe re á kang a bo, á sa a bo o nfung era, ano wo á jo li, jo wo, fere jo noongo lal. ");
INSERT INTO eka_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","Eji ma rehng nfung eni, á kehm mehle efunfu behre behre re á tahm, nde nkal kehm-e tongo re, \"Tohko li nsol wo kehm tahme.\" ");
INSERT INTO eka_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","Bo ane abal abal kehm ba ji edi ajehng li nsol fere jo wo. Nde nnenkal kehm-e tongo re, \"Kpe kang atv amehng a nahre, wo li fere jo geere.\" ");
INSERT INTO eka_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","Ana á mehle re á tahm, ano wo nde nkal kpanne no re á kang, á fere kang atv mao. ");
INSERT INTO eka_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","Efunfu behre behre bio bi biingi nfung elon, á kpe mehl re á tahm, ano wo nde nkal kpe-e kpanne re, \"Tohko li nsol, eman eji nnv ma ren wo kehm tahme. Ano wo bo kpe ji li nsol edi ajehng. ");
INSERT INTO eka_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","Eji nnenlum noo, a nne elkang ewe, a nloketum no nnenlum noo mehle re bo tahm, nde nkal kehm kpe bung tong nlum a mmon re, \"Nyehn ga elgung yahke ba,kang a wo li nsol a nahre, efunfu behre behre wo mehl kehnge.\" ");
INSERT INTO eka_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","Eji nnenlum noo bumu go ege eltim re á nehm kpe kang, á mehle asongo go Jebus (ji li Jeusalem), a ebvankang ebe na abal bi solo nsol, a nne elkang ewe. ");
INSERT INTO eka_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","Eji bo yahke ba elrehnge go Jebus, atv yahke behde, owo nlokeltum ewe kehm bungu tong nde re, \"Nong wahr kangen go ejahbe jia atv maa.\" ");
INSERT INTO eka_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","Owo nde kehm-e faange re, \"E nehm kang a, ejahbe ji ane ebahre Isreel ki li. E bahke tahme go Gibea.\" ");
INSERT INTO eka_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","Á kpe bung re, \"Nong wahr noken rehng go Gibea, afi Rama song kang go.\" ");
INSERT INTO eka_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","Bo kehm mehle asongo. Njul kpˈlahme ngare nyi bo kpˈrehnge go Gibea, ji li go ndi nyi Benjamin. ");
INSERT INTO eka_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","Ana bo rehnge Gibea, bo sebe re bo kang o. Bo kehm mehle song ji go elatahkgur nne ne jolem no vvrv bo kak go ebo ntahk. ");
INSERT INTO eka_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","Elgung nio nkˈkula nnenlum awohng no jo kehnge elimijum, á lohng go ejahbe ewong ji Efrem. Á lene o Gibea, ji jolo ejahbe ji etˈtohngo Benjamin. ");
INSERT INTO eka_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","Eji á nyehne ajenne nyao, á kehm bahbe bo re, \"N gan wo ń lohng no? N gan wo ń kpˈtahme?\" ");
INSERT INTO eka_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","Á kehm faange bo re, \"E lohng go Betlehem ji li go Juda, e kpˈtahme go ejahbe ewong ji Efrem, edi ji n lene no. N je go Betlehem ji li go Juda, anv, n fi go Etahk Esowo. Nne ne limm no ma-m vvrv kak go ege etahk. ");
INSERT INTO eka_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","Wahr kpi amahm, a nsol nyi e bahke lehke, go nsol nyi mbvankang bahke lehke, fere noongo lal. E nehme seb ejum ajehng ajehng. ");
INSERT INTO eka_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","Nnenkul noo kehm tongo bo re, \"Baan, wahn ba kang go egame. M bahk-n kake ejum ajehng ajehng ji ń li elehng. Mbang anyehng anyehng, kana kang go alatahkgur.\" ");
INSERT INTO eka_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","Á kehm rodo bo tahm go ge etahk. Nfontahk ka abvankang ebo nsol alehke. Eji á ma ru bo akpade, á kehm koko nsol alehke ba, bo li egom egom. ");
INSERT INTO eka_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","Ana bo jehk no kpˈlehke nsol, abˈbi ane ba li ejahbe jio kehm ba sennge etahk jio kak. Bo jo ruumu mbutahk, fere jo rabe tong nnenkul noo re, \"Ko nnenlum no ma ba a ega etahk wahr noongo a ne.\" ");
INSERT INTO eka_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","Nnenkul noo kehm lohngo ba kpiri bo go alatahk, kehm bungu tong bo re, \"E,ee, ate ebame, kana lim elkohn ebi ejum ana jia, nne noa njenne enyame nyi, bahke jolo ejum esono. ");
INSERT INTO eka_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","Nyehnen mmon ewame no li mongunga nnenkal, a nnelkang ewe, m bahke koko bo ba ka-n. Lim-n bo ajehng ajehng ji kp-n koro. Kana lim nnenlum noa ejum ajehng ajehng.\" ");
INSERT INTO eka_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","Jol anebelum baa we wuungem atung. Owo nnenlum no lohng go etˈtohngo ji Levi kehm yehke nnelkang ewe ka bo go alatahk, bo noongo a ne atv mao kpee. Eji efungfu ma se, bo nyehk-e yake. ");
INSERT INTO eka_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","Ana efungfu kpˈseke, ano wo nnenkal noo feere ba rehng etahk ji nnelkang nde ewe jolo no, kehm ba fooro gbo go egudu mbutahk, sa noongo o tete edi gohro bang. ");
INSERT INTO eka_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","Eji nnelkang ewe mehle ba lennge mbu lohngalatahk mi á yahke soro asi go ege eljen, á kehm ba nyehn nnelkang ewe no nkal nong go mbutahk, á ma tub ejahm go mbu. ");
INSERT INTO eka_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","Á kehm-e tongo re, \"Mehl yiimi, wahr tahm.\" Jol ellum go nnyo we lohngem. Á kehm-e tubu ejahm, rod-e kunu go njahm edonki, tahm a ne kehnge. ");
INSERT INTO eka_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","Eji á song rehng go etahk, á kehm rodo ntahme kiimi nnelkang ewe bum go ewubu ejang ebbal. Á kehm yehke ngabe anyehng anyehng tum tv etˈtohngo Isreel ajehng ajehng. ");
INSERT INTO eka_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","Nne awohng awohng no nyehne no bungu re, \"Elkohn ejum ana jia ka jˈjol go Isreel, bomo go ngare nyi Isreel lohngo go Ijib. Keren bade ejum jia. Tooben, wahn ba tong-r ji e bahke limi.\" ");
INSERT INTO eka_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","Owo Isreel kpee, bomo go Dan tete song rehng go Beseba, bo ji tob lohng go Gilied, kehm ba kono a eltim anehng. Bo ba kpee go Mispa, ba yiimi go esamahr bi Esowo. ");
INSERT INTO eka_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","atubesi ba Isreel go atˈtohngo ebo kpee kehm lohngo, bo jolo atahntahn ane. bo jolo go nfange ane atahltahl nkpel atahltahl nkpel ebal atahl awubu(400,000), bo rodo nkahngkahng ebo ba ji go ebo a nji go esamahr bi Esowo. ");
INSERT INTO eka_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","(Anebe Benjamin ba wuku re atˈtohngo Isreel nyako kpee ebrehng go Mispa.) Owo anebe Isreel kehm bungu re, \"Tong-r ana ejum jia jolo jol.\" ");
INSERT INTO eka_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","Nne a Levi no jolo nnelkang a nnenkal noa no bo wul-e no kehm bungu re, \"Me, a nnelkang ewame ba rehnge go Gibea ji jolo go Benjamin re wahr ba kang o atv. ");
INSERT INTO eka_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","Nlum atv, anebe Gibea kehm ba sennge etahk ji n jolo no kak, a ntir re bo wul-m. Bo bobo nnelkang ewame noongo a ne, á ma kpo. ");
INSERT INTO eka_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","N kehm ba rod ngubjing enye kiimi akv akv, tum tv etˈtohngo ajehng ajehng ji li go Isreel, tibre bo limi ejum esono jia, go elwo ni Isreel. ");
INSERT INTO eka_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","Anv, wahn anebe Isreel kpee lohngen wahn bung ana ejum jia bahke jolo.\" ");
INSERT INTO eka_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","Owo ane kpee kehm mehle bung bum nnyo amehng re, \"Nnene go egahre ellong limm, afi jolo re á wob go ebkpatahk, afi fere jolo go etahk no bahke feere go ege etahk. ");
INSERT INTO eka_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","Anv ji e bahke limi anebe Gibea ji a, a bahke tubu elfange, kahn nne no bahke gboko mbang song bohk-e abohng. ");
INSERT INTO eka_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","Etˈtohng ajehng ajehng ji kpi ane atahl alon bahk-r kake anebelum awubu; Etˈtohngo ji kpi ane atahltahl nkpel ebal ane atahl awubu bahk-r kake anebelum atahl alon; Etˈtohngo ji kpi ane rehng ane atahltahl go eltahl a nkpel elon, bahk-r kake anebelum atahltahl nkpel ebal ane atahl awubu. Ane baa ba bahke jo ko nsol alehke, a nsol nyehko ba ka nsoja. Wahr ji ma sa e bahk-n tahme go Gibea ji li go Benjamin song bongo bo go elkohn ebi ejum ana jia ji bo ma lim go Isreel.\" ");
INSERT INTO eka_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","Ano wo Isreel kpee taame bum nnyo amehng, re bo nok a ejahbe jio. ");
INSERT INTO eka_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","Atˈtohngo nyaka nya Isreel kpee kehm tumu etib tv etˈtohng ji Benjamin rea, \"Elkohn ebˈbi ajii, ji bo ma lim go egahne ellong? ");
INSERT INTO eka_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","Faaken abi ane bao ka-r, eji e lˈwul bo, eji ebˈbi jia lˈkˈkpe jol go elwo ni Isreel.\" Jol anebe Benjamin faangem bo. ");
INSERT INTO eka_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","Ji bo limi no jolo re, bo lohng na go ebo ajahbe, ba rehng go Gibea re bo ba nok a Isreel. ");
INSERT INTO eka_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","Bo jolo ane atahltahl nkpel atahl ara a nkpel elon, ba lohngo go etˈtohngo ji Benjamin bo ji fili nkahngkahng, ba budu a ane atahltahl atahlku bo ji ma bel elnere abohng anoko ba lene go Gibea. ");
INSERT INTO eka_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","Ane atahltahl atahlku bao ba Benjamin jolo ane ba jo lim abobkal, bo bahke ma ro eltal tub ejum ajehng ajehng afi jolo ana ellv esi jol nehm foro go nkpe. ");
INSERT INTO eka_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","A lˈyehke anebe Benjamin, Isreel jolo ane atahltahl go nkpel atahltahl nkpel ebal atahl awubu, ba jolo atakuru ane. ");
INSERT INTO eka_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","Anebe Isreel je go Betel song bahb Esowo. Bo bahbe re, \"Etˈtohngo ajii bahke gboko mbang bohko anebe Benjamin ebta?\" Jehova kehm faange re, “Juda wo bahke gboko mbang.\" ");
INSERT INTO eka_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","Efunfu behre behre anebe Isreel kehm mehle song kak elsi ebo kohlo Gibea. ");
INSERT INTO eka_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","Owo Isreel lohngo jo song nok a anebe Benjamin, bo yiimi aji nta ebo jo nok a bo go Gibea. ");
INSERT INTO eka_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","Anebe Benjamin ba lohngo go Gibea wulu ane atahltahl nkpel atahl abal tahlku, ba anebe Isreel efung bio. ");
INSERT INTO eka_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","Anebe Isreel kehm kake atemtem eltim, kpe lohng eji ji bo yiimi no nyaane. ");
INSERT INTO eka_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","Bo mehle tahm go Betel song yiimi go esamahr Esowo jo ling tete elgung ba. Bo song bahbe Jehova re, \"Wahr song nok a anebe Benjamin abonanee ejahra?\" Jehova kehm faange bo re, \"Song noken a bo.\" ");
INSERT INTO eka_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","Anebe Israel kehm kpe lohng song nok a anebe Benjamin go etoono efung. ");
INSERT INTO eka_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","Efung bia eji anebe Benjamin kpe ba kehme elnkok, bo kpe wul ejum ane atahltahl nkpel atahl abal a nkpel elon ba Isreel, bo kpee jolo atahntahn ane ba jo fili nkahngkahng. ");
INSERT INTO eka_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","Owo Isreel kpee kehm go Betel song kehme ellingi go esamahr bi Jehova, bade elbo njal tete rehng go elgung. Bo tob limi ajomjom, nya bo kpo jahm fi, a nya elkoono ka Jehova. ");
INSERT INTO eka_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","27","Anebe Isreel bahbe Jehova. (Ngare nyio elkohl atahm jolo o, ");
INSERT INTO eka_vpl VALUES ("JG20_28","008_20_28","JDG","20","28","28","Finehas mmon no Eliesa, ye ji jolo mmon no Eron, ye wo jo lim njom ngare nyio.) Bo kehm bahbe re, \"Wahr song noken a anebe Benjamin abonanee ebahra, afi wahr kˈje?\" Jehova kehm faange re, \"Songen, behna m bahke faake bo kaken go abo.\" ");
INSERT INTO eka_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","Anebe Isreel kehm tahme song biiri go ekulugbe sennge Gibea kak. ");
INSERT INTO eka_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","Bo kehm mehle ebta bia efung bi biingi nfung era re bo song nok a anebe Benjamin, song yiimi go ebo adi ebta nya bo kpo kono elyiimi re bo nok a Gibea. ");
INSERT INTO eka_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","Eji anebe Benjamin lohngo ba elnoko anebe Isreel, anebe Isreel jo feere njahmjahm, tohng bo yehke go ebo ejahbe. Ana bo jo kono ellimi, bo kpe kehme anebe Isreel wul ana jolo nyanjehle. Mbang mbang nyio nyi Betel, a Gibea, bo wulu eltahl ane awubu ba Isreel. ");
INSERT INTO eka_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","Ana nsoja nyi anebe Benjamin kpˈ bungu re, “Wahr ebkpe kehme bo wul ana nyanjehle.” Anebe Isreel kpˈbungu re, \"E feeren njahmjahm, eji e lˈtohng bo yehke go ebo ejahbe feere go esi mbang.” ");
INSERT INTO eka_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","Eji anebe Isreel mehle go aji nya bo jolo no song rehng go Baal Tema, owo ane ba biiri go ekul kehm mehle go erede bio bi Gibea. ");
INSERT INTO eka_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","Atakuru nsoja nyi ga tahne nyi Isreel, bo jolo ane atahltahl go eltahl a nkpel elon mehle mbuksong ebta a anebe Gibea. Abohng tahne sehng, jol anebe Benjamin tikem kahn re, efung bia ebi efung bi ka bo. ");
INSERT INTO eka_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","Jehova kake Isreel ebo eji bo jo nok a anebe Benjamin. Efung bio anebe Isreel wulu ane atahltahl nkpel atahl ara a nkpel ebal a ane atahlku ba Benjamin. Bo kpee jolo ane ba kpo fili nkahngkahng. ");
INSERT INTO eka_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","Anebe Benjamin lohko nyehn re Isreel ebsehnge bo. Anebe Isreel jo be njahmjahm go esamahr bi anebe Benjamin, tib ekunukpu ebo jolo go eji ane ba biiri go ekulugbe jio ji Gibea. ");
INSERT INTO eka_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","Ane bao ba biiri go ekulugbe kehm lohngo go aji nya bo behr no, ba wul nne awohng awohng no li go Gibea go nkahngkahng. ");
INSERT INTO eka_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","Anebe Isreel toobo a ane ba biiri go ekulugbe re bo jahm ejahbe jio fi, bo nyehn atˈtohk go eji ji bo li no, ");
INSERT INTO eka_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","jio bahke tob lim anebe Isreel yiimi fere jo nok a bo. Ngare nyia anebe Benjamin ebkpe wul anebe Isreel (ejum eltahl ane awubu), bo soro kehme elbungu re, \"E kpˈgake bo ana nyanjehle.\" ");
INSERT INTO eka_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","Eji atˈtohk ma tohko nti asongo go elbung nya kpˈlohngo go ejahbe jio, owo anebe Benjamin kehm keebe nyehn ana atˈtohk kpˈlohngo go ebo ejahbe asongo go elbung. ");
INSERT INTO eka_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","Anebe Isreel ba jo be njahmjahm kehm feere jo nok a anebe Benjamin. Ngare nyia nyi anebe benjamin liingi re ebˈbi ejum yahke lim bo. ");
INSERT INTO eka_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","Bo kehm kehme elbeke go esamahr bi Isreel asongo go elka emahng, bo maam for go ebta bia. Anebe Isreel kehm lohngo go ebo ejahbe ba kehme bo wul go elka emahng. ");
INSERT INTO eka_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","Anebe Isreel sennge anebe Benjamin kak, fere jo kam bo asongo asongo, bo kehm song bob bo go ero nfam nyio nyi Gibea. ");
INSERT INTO eka_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","Ane atahltahl nkpel atahl abal a nkpel elon ba Benjamin, ba jolo atahntahn ane ba kpo ebta bia. ");
INSERT INTO eka_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","Ana bo jo be asongo go eltal ni Rimon ni jolo go elka emahng. anebe Isreel wulu ejum ane atahltahl nkpel ewubal ane atahl awubu mbang mbang. Ano wo bo soro asi jo kam anebe Benjamin tete rehng go Gidom, wul ane atahltahl nkpel elon kpe budu. ");
INSERT INTO eka_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","Efung bio ane atahltahl nkpel atahl ara a nkpel ebal a atahl awubu ba Benjamin ba kpo fili nkahngkahng kpo go ebta, bo kpee jolo atahntahn ane. ");
INSERT INTO eka_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","Ane atahltahl atahl awubu be rehng go elka emahng song yel go nkpaltal nyi Rimon, bo jolo o nnyahng eni. ");
INSERT INTO eka_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","Anebe Isreel feere sehng song rehng go Benjamin. Bo wulu nne awohng awohng go ekahng kahng. Bo wulu, a enyam enyam kpee, a ejum ajehng ajehng ji bo nyehne no. Ejahbe ajehng ajehng ji bo yele no bo jo jahm fi. ");
INSERT INTO eka_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","Anebe Isreel ebko nwongo, ngare nyi bo jolo go Mispa: \"Nnene nehm tiki ka nne a Benjamin mmon ewe no nkal go elbal.\" ");
INSERT INTO eka_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","Bo kpee je go Betel, song ji go esamahr Esowo song rabe aling wahre wahre tete elgung ba. ");
INSERT INTO eka_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","Bo lingi rea, \"Jehova, wo li Esowo bi Isreel, jenji wahng ka jia ma lim Isreel? Jenji wahnge etˈtohngo ajehng ma tan go egahre ellong lela?\" ");
INSERT INTO eka_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","Etoono efung, efungfu behre behre, bo kehm limi njom nyi bo kpo jahm fi, a nyi elkoono. ");
INSERT INTO eka_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","Anebe Isreel kehm bahbe elbo re, \"Nne awoo go atˈtohngo nya Isreel no ki lohng ba go esamahr bi Jehova.\" Tibre bo ko nwongo go re, nne awohng awohng no tohko lohng ba go esamahr Jehova go Mispa, bo bahk-e wulu. ");
INSERT INTO eka_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","Anv, erakatahng ji Isreel, tib esi ji anebe Benjamin ji abonanyehn. Bo kehm bungu re, \"Lela etˈtohngo ajehng kpeem li go Isreel. ");
INSERT INTO eka_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","Eji e ma ko nwongo go esamahr Esowo re wahr kˈka bo abon ebahre ba nkal go elbal. Ane ba ma sa e bahke limi renan kehm kake bo akal?\" ");
INSERT INTO eka_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","Bo kehm bahbe re, \"Nne awoo ki ba go atˈtohngo nya Isreel, ba ji go esamahr Jehova eji e je go Mispa?\" Bo ba seb kahn re nne ne go Jabes Gilied lohngem ba. ");
INSERT INTO eka_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","Eji bo fange nrur ane, bo sebe kahn re nne ne lohngem go Jabes Gilied ba. ");
INSERT INTO eka_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","Owo nkon nyi anebe Isreel kehm tumu ane atahltahl nkpel eltahl, a nkpel ewubu abanokabohng a elle re, bo song wul nne awohng awohng no li o go ekahngkahng, anebkal, a abon abon kpee. ");
INSERT INTO eka_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","Bo bungu tong bo re, \"Ji ji a, ji ḿ bahke limi. Ḿ bahke wulu nnenlum awohng awohng, wahn tob wul nnenkal awohng awohng no ma sahb nne.\" ");
INSERT INTO eka_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","Go Jabes Gilied bo bele ane atahltahl ba kala sahb ane, bo ko agungu anebkal bao kpee ba go Silo ji jolo go ndi nyi Kenan. ");
INSERT INTO eka_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","Anebe Isreel tumu anebe elkoono tv anebe Benjamin go nkpaltal nyi Rimon re bo rahke ebta. ");
INSERT INTO eka_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","Anebe Benjamin kehm feere, bo kehm kake bo anebkal ba bo ki wul bo, jol anebkal bao biingem bo. ");
INSERT INTO eka_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","Jo gbiingi anebe Isreel sehng, tibre Esowo eblim re eyake jol ji nne ne ki li go atˈtohngo nya Isreel. ");
INSERT INTO eka_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","Owo atubesi ba Isreel kehm bahbe re, \"Anv, eji e ma wul anebkal ba etˈtohngo ji Benjamin kpee, nnenkal awohng awohng kpeem li no e bahke kake anebe Benjamin, e bahke limi renan kehm sebe anebkal ka bo.? ");
INSERT INTO eka_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","Bo kehm bungu re, \"Anebe Benjamin ba sa no bahke tiki bel abon eji etˈtohngo lˈkˈtan go Isreel. ");
INSERT INTO eka_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","Wahr nehm ma ka bo abon ebahre re bo jol akal ebo, eji wahr Isreel ma ko nwongo nyio: Elsu bahke jolo ka nnea Isreel no bahke kake nne no lohng go etˈtohngo ji Benjamin nkal. ");
INSERT INTO eka_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","Bo kehm bungu re, \"Elkak ni e kpo lim-n go elya elya ka Jehova go Silo ebkabbe, \"Silo li ejang ebobkal bi Betel, a ejang eboblum bi Lebona, a lˈlohng go Betel kpˈtahme Sekem, Silo li ero nfam.\" ");
INSERT INTO eka_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","Bo kehm tubu anebe Benjamin elle re, \"Songen, wahn song biiri go ebgbe agreb bi li go mbang, ");
INSERT INTO eka_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","wahn jo kpur. Abonse nkal ba lohng go Silo lˈlohng ba semme anahne jo bahn ase, lohngen go edi ji ń behr no, no nne ba tub mmonse nkal no bahke jolo nkal ewe ejahm go ellong abonse nkal ba lohng go Silo, wahn be abo tahm go edi nyi Benjamin. ");
INSERT INTO eka_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","Babnde, a abonanyehn ebo lˈba bahr-r, e bahke tongo bo re, ˈTib-r nnoobo eljini, wahn kak bo ebo, tibre nnenkal awohng awohng e belem ka bo ngare ebta. Ebi ejahne sang, eji ń ki ka bo abon ebahne ba nkal.ˈ \" ");
INSERT INTO eka_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","Ano wo anebe Benjamin limi no. Ngare nyi abonse nkal kpˈbahne ase, no nne bahke beke song tub mmonse nkal awohng ejahm tahm a ne re á song jol nkal ewe. Owo bo kehm feere go eji elehkelkv ebo song tuungu ejahbe ebo si, fere lene o. ");
INSERT INTO eka_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","Ngare nyio anebe Isreel kehm yake edi jio, feere kehnge go ebo ejahbe, no nne feere go edi elehkelkv eje. ");
INSERT INTO eka_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","Ngare nyio ntul awohng awohng jolem go Isreel, nne awohng awohng jo limi ji jo kor-e.");
INSERT INTO eka_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Ngare nyi abalamalam jo fili adi, njal jolo go ndi nyi Isreel. Nne awohng jolo go no lohng go Betlehem ji jolo go Juda, a nkal ewe, a abon ebe ba nlum na abal. Bo mehle tahm re bo song lene mmongare ntiil go ejahbe ji Moab. ");
INSERT INTO eka_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Nne noo bo jo lung-e re Elimelek, nkal ewe bo jo lung-e re Naomi. Abon ebo ba nlum bo jo lungu bo re, Malon, a Kilion. Bo lohng go nnahb nyi Efrat, bo lene o Betlehem ji Juda. Bo mehle song lene go Moab. ");
INSERT INTO eka_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Owo Elimelek nluma Naomi kehm ba kpo, Naomi kehm ba sa, a abon abal ebe ba nlum. ");
INSERT INTO eka_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Abon baa kehm ba ko anebkal Moab go elbal, nnenkal noko bo jo lung-e re Opa, noko Rut. Eji bo ma kang o ejum nnya ewubu, ");
INSERT INTO eka_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","abon abal ebe, Malon abola Kilion tob ba kpo, Naomi ba sa ntahngtahng, nlum limm, abon limm. ");
INSERT INTO eka_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Eji Naomi wuku go Moab re Jehova ebtob ane ebe ka bo nsol alehke, á kehm toobo ebjing a akal abon ebe re bo feere kehnge go ege ejahbe. ");
INSERT INTO eka_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Á kehm mehle a akal abon ebe bao na abal go edi ji á jolo no asongo mbang mbang nyi li asongo go ndi nyi Juda. ");
INSERT INTO eka_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Owo Naomi kehm bungu tong akal abon bao na abal re, <<Feeren, wahn song kehnge goji babnne ejahne. Nong, Jehova tib-n ndon enye ana ḿ ma tib ane ba ma kpo, a me. ");
INSERT INTO eka_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Nong Jehova lim eji wahn lˈbel alum ba ḿ bahke bale, fere ji go egahna ntahk soom.>> Á kehm soro bingi bo, bo lingi wahre wahre, ");
INSERT INTO eka_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","bo kehm bungu tong-e re, <<E bahk-a toono rehng goji ane eba.>> ");
INSERT INTO eka_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Naomi kehm bungu re, <<Feeren kehnge abon ebame. Jenji wahnge ḿ bahk-m toono? Anv, m bahk kpe jel na abon ba nluma, bo ji bahke ba jol alum ebahna? ");
INSERT INTO eka_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Feeren kehnge abon ebame; me n kul sehng re me n kpe bel nlum nondiki. Li re kpe li nyi m bahke koko nlum, n kehm ba bel nlum lela, kehm ba jel abon ba nlum, ");
INSERT INTO eka_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","anv, ḿ bahke siki bo tete bo gbala? Ḿ bahke siki, nlum awohng awohng ń nehm ko tib esi eboa? Eˈee abon ebame. Egame wo ga bib sehnge egahne, tibre ebo bi Jehova bia a, kpˈnoko a name.>> ");
INSERT INTO eka_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Eji bo kpe wuk jia, bo kpe kehme ellingi. Opa kehm bingi nnyehn nlum kehm feere eje. Wo Rut feerem, á sa a nnyehn nlum. ");
INSERT INTO eka_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomi kehm bungu tong Rut re, <<Nyehne, nfahbwa ebfeere goji ane ebe. Á tob fi song toono asowo ebo. Toon-e wo song kehnge.>> ");
INSERT INTO eka_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Rut kehm-e faange re, <<Kam-a kpe kpanne re me n yak-a, afi me ki-a kpe toono. Edi ajehng ajehng ji a fi no, m bahke tob ba, edi ji a bahke jolo, m bahke tob jol o. Ane eba bahke jolo ane ebame, Esowo eba bahke tob jol Esowo ebame. ");
INSERT INTO eka_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Edi ji a lˈkpo, owo m bahke tob kpo, bo bahke tob kpa-m kak o. Nong Jehova demm-m, n lˈfere yak-a abo, tohko jol ano elkv ni ni bahk-r yaame. ");
INSERT INTO eka_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Eji Naomi lohko seb kahn re Rut ebyehke ntir enye re á bahk-e toono, á we kpeem kpanne re á feere. ");
INSERT INTO eka_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Bo anebkal abal abal kehm soro asi asongo, tete bo ba rehng go Betlehem, eji bo rehnge go Betlehem ejahbe kpee kehm mehle a eyebatahng tib esi ebo. Anebkal kehm kehme elbahbe re, <<Lohko li re Naomi woa?>> ");
INSERT INTO eka_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Á kehm tongo bo re, <<Kama wahn kpe lung re, Naomi. Jo lung-m wahn re, Mara, tibre Esowo bi Gbale Sehng eblim elkpin ebsab aname. ");
INSERT INTO eka_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Eji m mehle a tahm, n tahme a ane ebame kpee, anv, Jehova ebfeere a name abo abo. Nˈnan ń kp-m lungu re Naomi? Esowo bi Gbale Sehng bi ma-m lim jia, ye wo ma rod akanya nyaa ba nyed-m.>> ");
INSERT INTO eka_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ana wo Naomi feere go Moab kehnge go Betlehem a Rut, nnenkal a Moab, nkala mmon ewe no toon-e no ba rehng go Betlehem. Jolo ngare nyi bo ma kehme arasi nya bo kpo lung re bali kiimi. ");
INSERT INTO eka_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi bele ekunu nlum ji bo jo lung-e re Boas, á jolo efangene ji jolo mmon elfvvrv, á lohng go etˈtohngo ji Elimelek. ");
INSERT INTO eka_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Efung abehng Rut nnenkal a Moab kehm bungu tong Naomi re, <<Nong me n song go emahng arasi, song kpiimi arasi toono nne no lˈtaame re me n toon-e.>> Naomi kehm bungu tong-e re, <<Song mmon ewame.>> ");
INSERT INTO eka_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Owo á kehm tahme song kehme elkpiimi, jo toono ane ba kpˈkiimi arasi. Ana ejum ba jol me, go egbe ji Boas wo á jo kpiimi arasi, ye ji lohng go etˈtohngo ji Elimelek. ");
INSERT INTO eka_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Eji Boas lohngo go Betlehem ba rehng egbe arasi, kehm ba kak ane ba jo kiimi arasi nnyo re, <<Nong Jehova jol a nahne.>> Bo tob faang-e re, <<Nong, Jehova fuul-a.>> ");
INSERT INTO eka_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boas kehm bahbe ntubesi abakiimi arasi re, <<Mmon no nkal noa no nyehne wo?>> ");
INSERT INTO eka_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ntubesi noo kehm-e faange re, <<Ye wo li ngbahme nyi lohng go Moab, no toono Naomi ba. ");
INSERT INTO eka_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Á tong-r efungfu bia re, <Titi, yak-m wahn me n kpiimi arasi toon-n, wahn ji kpˈlimi eltum. Yeblim eltum gbalee bomo efungfu rehng anv, sehngem re, yeb re mmokv ntiil go mmobkpatahk.>>> ");
INSERT INTO eka_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Boas kehm tongo Rut re, <<Wuung-m atung mmon ewame, jol a, wo jo kpiimi arasi, ka je go egbe ajehng ajehng jehko. Jo jen toono anebkal, bo ji li alokeltum ebame. ");
INSERT INTO eka_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Jo nyehn ana abalimeltum kpˈkiimi asongo, wo jo toono abonse nkal. Me n tong ajangkun re bo kˈlim ntong a na. Ngare anyehng anyehng nyi alahb lˈkor-a, song wo alahb go etu, ma bo ma tuk.>> ");
INSERT INTO eka_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rut kehm soro gong esamahr go ndi, kehm bungu re, <<Nˈnan m ma-a fili ndon, a ma fere lim nnoobo ana nyia ka-m, ga me njenne nyi?>> ");
INSERT INTO eka_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas kehm-e faange re, <<Bo ma-m tong kpee bada anoobo nsol nya a ma lim ka nnyehn nlum wa, bomo ngare nyi nlum ewa kpo no, ana a ma yake nso, a nne, go ejahbe eja kpee ba lene go ellong ane ba a ki nyi bo. ");
INSERT INTO eka_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Nong, Jehova tuur-a, nong Jehova ye ji li Esowo bi Isreel, ye ji a ma ba woom-e go elwo tuur-a sahb gbˈgbal ana a ma lim.>> ");
INSERT INTO eka_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut kehm faange re, <<Nsoo nong me n soro asi jo bel nnoobo go ega esamahr, a ma-m kak eltim, go anoobo alum nya a ma bung a nlokeltum ewa, jol eji n ki bˈbik ana nlokeltum nnenkal ewa na awohng.>> ");
INSERT INTO eka_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Ngara nsol alehke, Boas kehm bungu tong-e re, <<Mehl ba ga, ba ko ebred, wo tv go abehne.>>Eji Rut ji go ellong abakiimi arasi, Boas ba ka-e nkohl nyi bo ma wo, á li wohngo sa erik. ");
INSERT INTO eka_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Eji Rut kpe feere song kehme arasi kpiimi, Boas kehm tongo ajangkun re, <<Afi jolo re á kpiimi na yel go abim arasi, kana ye gbiingi. ");
INSERT INTO eka_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Fuumu na re wahn jo yehke go ebim tuubu go nkpe jo bum-e á jo ba fohko, kana ye sahde.>> ");
INSERT INTO eka_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut kpiimi arasi nyao tete rehng elgung. Eji á ba ruumu akpiimi kpiimi arasi nyao nya bo kpo lung re bali, ruru ejum ngbojok. ");
INSERT INTO eka_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Á solo tahm a nya go etahk, nnyehn nlum kehm ba nyehn elkohn arasi nya á kpiimi no. Á tob ko erik nsol alehke nyi á li wohngo sa erik, song ka nnyehn nlum go etahk. ");
INSERT INTO eka_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomi, nnyehn nlum kehm-e bahbe re, <<Nyaa a kpiimi gan lela? Gan wo a limi eltum? Elfuulu bahke jolo ka nne no ma-a nyehn ndon kak-a ebo!>> Rut kehm tongo nnyehn nlum kpee bada nne no á kpˈlimi eltum go ege egbe. Rut bungu tong-e re, <<Nne no n limi eltum go ege egbe lela, bo kpo lung-e re Boas.>> ");
INSERT INTO eka_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi kehm bungu tong Rut nkala mmon ewe re, <<Nong Jehova fuul-e! Á ka tiki yake eltibi nnoobo eljini ene a ane ba li go elkpin, a ba ma kpo. Nnenlum noa li nne no li nnea nnahb ewahre, ye wo li nlehkelkv go egahre ebangenahb.>> ");
INSERT INTO eka_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rut nnenkala Moab kehm bungu re, <<Á tob tong-m re, <Me n kpe feere jo song lim eltum a alokeltum ebe tete eltum arasi nio mal.>>> ");
INSERT INTO eka_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi kehm bungu tong Rut, nkal mmon ewe re, <<Mmon ewame, bahke nobo sehng ka-a re wo jo song toono agbahme nya li alokeltum ebe, tib a lˈje go egbe jindiki, bo bahk-a ma lim ebi ejum.>> ");
INSERT INTO eka_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ano wo Rut jo toono agbahme nya jo loko Boas jo lim eltum arasi nya bo kpo lung bali, a nya bo kpo lung re wid tete mal. Rut tiki lene eji nnyehn nlum. ");
INSERT INTO eka_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Efung abehng Naomi, nnyehn nlum kehm bungu tong Rut re, <<Mmon ewame, ngare ebbiingi nyi fuumu re me n seb nlaaga ka-ao, nyi bo bahke jo kpur-a nob nobo? ");
INSERT INTO eka_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Boas ji a jo toono alokeltum ebe ba nkal jo lim eltum, nnea nnahb ewahre wo. Elgung nia, á bahke jo febe nkahr yehke go arasi nya bo kpo lung re bali gona ebud bud. ");
INSERT INTO eka_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Wuumu alahb, wo taame akehng ma kpi esˈsvv ji nno, liibi nsol nyi kpˈsahb nˈnob, wo song go ebud bud arasi. Ka lim á kahn re a li o, tete á li nsol alehke mal, fere wo amahm. ");
INSERT INTO eka_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Á lˈnoongo, seb kahn edi ji á nong no, ngare nyi á ma lal, wo song gbib mbomo lenng-e akpade fere noongo o. Á bahk-a tongo ji a bahke limi. >> ");
INSERT INTO eka_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut kehm-e faange re, << M bahke limi ajehng ajehng ji a ma-m tong. >> ");
INSERT INTO eka_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Rut kehm tahme go ebud bud arasi song lim jang jang ana nnyehn nlum tong-e no re á lim. ");
INSERT INTO eka_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Eji Boas ma li nsol kpee mal, fere wo wohngo nˈnob, eyebatahng gbale sehng. Á kehm mehle song noongo go nkpe ebim arasi nyehko jo lal. Rut kehm weele song lenng-e mbomo go akpade noongo o. ");
INSERT INTO eka_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ngare nyi nlum atv ma kul, Boas kehm nehke nyahme seb kahn re nnenkal nong-e go ege nnahberedakpade. ");
INSERT INTO eka_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Á kehm-e bahbe re, <<Wo nne awoo?>> Rut kehm bungu re, <<Me Rut wo, ji li nlokeltum ewa. Konng-m ejang ekpa ewobo eja, tib wo wo li nlehkelkv.>> ");
INSERT INTO eka_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boas kehm-e faange re, <<Jehova fuul-a mmon ewame. Nnoobo eljini ni a ma tib anv ebnob sehnge ni a tibi wuku: A beem toono ajangkun nya li afangene, afi bo ji li akpak. ");
INSERT INTO eka_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Mmon ewame, ejum jia ki-a ka elfahle, m bahke limi ejum ajehng ajehng ji a kpˈsebe, tibre nne awohng awohng go ejahbe jia kpˈkahne re a kpi eljini ni nno. ");
INSERT INTO eka_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Etingitingi ji re n li nnea nnahb, nnea nnahb noko noa no ga fuumu sehnge me. ");
INSERT INTO eka_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Noongo atv maa, efungfu lˈse m bahk-e tongo, lˈfere jol re á bahk-a lehke elkv, ebnob, nong á li-a elkv. Lˈjol re we nehme kor re á li-a elkv, n kpˈnyame tong-a go mbing nyi Jehova re m bahk-a lehke elkv. Noongo a, efungfu tohko se. ");
INSERT INTO eka_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ano wo Rut noongo go nnahberedakpade nyi Boas tete efungfu se. Á mehle o ngare nyi mmojannge kpeka li, ji nne lˈkˈma liingi nne. Tibre Boas tong-e re, <<Nne awohng awohng kˈkahn re nnenkal ebba a edi ji e kpo ruumu arasi.>> ");
INSERT INTO eka_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boas kehm kpe bung tong-e re, <<Ko egbakesi eja wo ba yal.>> Eji á ma lim ano, á kehm gare ekpingi erukabo arasi ebrakebra nya bo kpo lung re bali, fere rod si-e go esi. Boas kehm tahme kehnge go ejahbe. ");
INSERT INTO eka_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ana Rut feere song rehng goji Naomi, nnyehn nlum, á kehm-e bahbe re, <<Jolo renan mmon ewame?>> Rut kehm-e tongo nsol kpee nyi Boas ma lim ka-e. ");
INSERT INTO eka_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Rut kpe bung re, <<Á ka-m ekpingi arasi ebrakebra nya bo kpo lung re bali, fere bung re, <Ka feere abo abo goji nnyehn nlum wa.> >> ");
INSERT INTO eka_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Owo Naomi kehm bungu re, <<Bel elkpuumu mmon ewame, wo nyehn ji bahke jolo. Boas nehm tiki bel erekekv tete á lim ejum jia lela.>> ");
INSERT INTO eka_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Owo Boas kehm mehle tahm go esi ejahbe song ji go eti mbu ji nfam kpo kono elwane. Eji nne no bahke lehke elkv, no á jo bung ba no,, Boas kehm bungu re, <<Ba, wo ba ji ga mbi.>> Á kehm bake ba ji. ");
INSERT INTO eka_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boas koo anebkul nfam na awubu kehm bungu re, <<Jiin a.>> Bo kehm ba ji. ");
INSERT INTO eka_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Owo Boas kehm bungu tong nlehkelkv re, <<Naomi ji kpehna kehnge go Moab kpi erohko ndi ji á bahke gungu ji mmonannee ewahre no bo jo lung-e re Elimelek. ");
INSERT INTO eka_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","N gbo ntir re me n ko ejum jia ba go ega alata, ba tong-a re wo gunu go esamahr anebkul, a ane kpee ba jehk a. Lˈjol re a bahke fake, a fak, tohko jol ano tong-m eji n lˈkahn.>> Á kehm bungu re, <<Nnene go limm no fuumu re á fak sehnge wo, me wo li etoono nne.>> A kehm bungu re, <<M bahk-e fake.>> ");
INSERT INTO eka_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Boas kehm bungu re, <<Efung bi a lˈgunu edi ndi jia go abo nya Naomi, Rut ji li nkalebun no lohng go Moab, a bahk-e koko go elbal, eji mbing nyi nne no ma kpo, a nsol enye bahke sake go ebangenahb.>> ");
INSERT INTO eka_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Eji nlehkelkv wuku jia, á kehm bungu re, <<N nehm ma fak, n lˈlim ano, ebangenahb ejame bahke jolo efin efin. Me nehm ma fak, wo song fak.>> ");
INSERT INTO eka_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Jolo eljini mahne mahne go Isreel bade elehkelkv, a ejum ayaange re, nne no kpˈfaake ejum elehkelkv ka nne noko, bahke yehke ekpaketa eje ka nne no kpˈkoko. Jia ji ane bahke liingi re woblim ana fuumu no. ");
INSERT INTO eka_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Nne no jol lˈli elkv nio kehm bungu tong Boas re, <<Fak antahng.>> Á kehm soro yehke ekpaketa eje ka Boas. ");
INSERT INTO eka_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Owo Boas kehm bungu tong anebkul nfam, a ane bako kpee re, <<Wahn ba li atianse lela re me n gunu nsol nyi Elimelek, nyi Kilion, a nyi Malon go abo nya Naomi. ");
INSERT INTO eka_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Me n tob ko Rut ji lohng go Moab, ye ji jolo nkal no Malon ana nkal ewame, eji mbing nyi Malon, a nsol a nsol enye lˈkˈtan go ge ebangenahb, a ejahbe eje. Wahn ba li atianse lela.>> ");
INSERT INTO eka_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Anebkul, a ane kpee ba ji go eti mbu kehm bungu re, <<Wahr atianse enya nya.>>Nong Jehova lim nnenkal no kpˈbake go ega etahk ana Rasel abola Lea, bo ji limi nfam nyi Isreel kpee. Nong wo gbal go Efrat, bo kahn-a go Betlehem. ");
INSERT INTO eka_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Sehng go etˈtohngo ji Jehova ma-a ka, go elwo ni ngbahme nyia, nong ebangenahb eja jol ana ji Peres ji Tema jele ka Juda. ");
INSERT INTO eka_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Boas kehm rodo Rut, á jol nkal ewe. Eji Boas noongo a ne, Jehova ba lennge ejˈjele eje, á ba sa ela jel mmon no nlum. ");
INSERT INTO eka_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Anebkal kehm bungu tong Naomi re, <<Nong ellub jol ka Jehova, ye ji ki-a yake abo abo, á ma-a ka nlehkelkv go ega ebangenahb. Nong bo kahn-e kpee go Isreel. ");
INSERT INTO eka_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Á bahke limi elkpin ena nyamme, fere kpur-a ngare nyi a ma kul. Ye wo li mmon no nkala mmon ewa no a kpo sahb kor-e kor, me-e jel. Nkal a mmon ewa noa wo ga nob sehnge abon ba nlum na asehma.>> ");
INSERT INTO eka_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi kehm rodo mmon kunu elne go ayo jo kpur-e. ");
INSERT INTO eka_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Anebkal ba lene o kehm kehme elbungu re, <<Naomi ebbel mmon no nlum.>> Bo gung-e mbing re Obed, ye wo jolo nde no Jesi, Jesi jol nde no Devid. ");
INSERT INTO eka_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Etˈtohngo ji Peres ji a, Peres jolo nde no Hesron, ");
INSERT INTO eka_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron jol nde no Ram, Ram jol nde no Aminadab ");
INSERT INTO eka_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab jol nde no Nason, Nason jol nde no Salmon, ");
INSERT INTO eka_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon jol nde no Boas, Boas jol nde no Obed, ");
INSERT INTO eka_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed jol nde no Jesi, Jesi jol nde no Devid.");
INSERT INTO eka_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Nne awohng jolo go Ramatayim, nnea Jufiti, á lohng go ejahbe ewong ji Efriim, mbing enye bo jo lung-e re Elkana, mmona Jeroham mmon no Elihu, ji mmona Tohu, mmona Jufi, nnea Efriim. ");
INSERT INTO eka_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Á bele akal abal, awohng bo jo lung-e re Hanna, noko Penina. Penina bele abon, Hanna belem. ");
INSERT INTO eka_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Go elya anehng anehng nnenlum noa jo lohng ege ejahbe song kak Esowo, fere song lim njom ka Jehova ji Kpˈfili Elbung a Ndi go Sayilo, go edi ji Hofini a Finihas, abon abal ba Eli jolo abalimajom ba Jehova. ");
INSERT INTO eka_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Ngare anyehng anyehng nyi efung lꞌrehng bi Elkana bahke limi njom, á bahke kimi nnyam a jom ka Penina, a abon ebe ba nkal, a ba nlum. ");
INSERT INTO eka_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Wo goji Hanna á jo ka-e bꞌbudu, tibre á jo kor-e sehng, wo Jehova bꞌbulu ejˈjele eje. ");
INSERT INTO eka_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Tib eji Jehova bulu ejꞌjele Hanna, nfahb we jo lim-e eji á lˈjo rak atahng. ");
INSERT INTO eka_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Jia jo jolo elya elya. Ngare anyehng anyehng nyi Hanna lꞌje go etahk Jehova, nfahb we, bahk-e limi á jo ling, jol nsol alehke a nehm taame li. ");
INSERT INTO eka_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Elkana nlum ewe bahke bungu tong-e re, <<Hanna jenji wahngka a kpꞌlingi? Jenji wahngka a kil lehke nsol? Jenji wahnge eltim ena li go ndon? Anv, n wa-a nehme gbal sehnge abon ba nlum na awuba?>> ");
INSERT INTO eka_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Efung abehng eji bo li nsol mal, fere wꞌwo go Sayilo, Hanna soro tahm yiimi. Ngare nyia Eli ji nlimanjom ji go egbiri go nkpea mbutahk etahk Jehova. ");
INSERT INTO eka_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Go ege eyam eltim, Hanna kake ero ka Jehova, fere jo sahb lꞌling. ");
INSERT INTO eka_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Owo á kehm koko nwongo re, <<Jehova ji Kpˈfili Elbung a Ndi , li re a bahke lub seenge nyehn nlokeltum ewa no ki kpi eyebatahng fere buum-m kꞌyini nlokeltum ewa, lub ka-e mmon no nlum, m bahk-e rodo ka Jehova go afung kpee nya á bahke jolo go elkpin, jol elsen bo we-e nehm kooro go ege esi. ");
INSERT INTO eka_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Eji á soro asi jo kak ero ka Jehova, Eli jo baab-e go kpakebibi nnyo. ");
INSERT INTO eka_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Hanna jo kake ero go ege eltim, akpakebibi nnyo enye nya jo jehbe, jol ellum bo joom wuk, Eli tiri re á kpi amahm buumu, ");
INSERT INTO eka_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","á kehm bungu tong-e re, <<Bahke labe renan re wo sa go amahm abuumu ema maa? Rahke amahm maa.>> ");
INSERT INTO eka_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Hanna kehm faange re, <<Ano sang nsoo, me nnenkal no eltim kp-m sahb gbꞌgbiingi wo. Amahm sang m ma wo, afi amahm ma kpo lim nne jo buumu, me n fannge eltim ename ka Jehova. ");
INSERT INTO eka_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Ka ko nlokeltum ewa ana ebi nnenkal, n kpi ero kak a, tib go egburu eyameltim a ndon. ");
INSERT INTO eka_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Eli kehm faange re, <<Song go elkoono, nong Esowo bi Isreel lim ka-a ana a bahb-e no.>> ");
INSERT INTO eka_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Hanna kehm bungu re, <<Nong nlokeltum ewa lub li efa go ega esamahr. Owo Hanna kehm tahme eje song li ejum alehke, á joom kpe guunu go ege esamahr. ");
INSERT INTO eka_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Njahm efungfu bo kehm mehle song kak Jehova, kehm feere ebo kehnge go Rama. Elkana kehm noongo a Hanna nkal ewe, Jehova buumu Hanna. ");
INSERT INTO eka_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Eji ma kang abon afung Hanna kehm sake ela jel mmon no nlum, gung-e mbing re Samuel, fere bung re, <<Tibre ye wo m bahb-e Jehova.>> ");
INSERT INTO eka_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Eji Ekana nlum ewe, kpe tahm a nnahb enye kpee re á song lim njom nyi elya ka Jehova, fere lim ana á ko nwongo, ");
INSERT INTO eka_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Hanna jeem. Á bungu tong nlum ewe re, <<Ngare nyi mmon noa lꞌkimi abel, m bahk-e rodo song yake ka Jehova, á bahke lene o go elkpin ene kpee. ");
INSERT INTO eka_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Elkana nlum ewe kehm-e tongo re, <<Lim ana fuum-a no.>>Jol a tete wo kim-e abel, nong ellum Jehova lub jol nob nob. Ano wo nnenkal noo sa no etahk yabe mmon noo, tete á kim-e abel. ");
INSERT INTO eka_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Eji á me-e kimi abel, á kehm rodo mmon no nlum noo, ana á se se o tahm a ne, a mmonanfong no ma kang nnya era, go ebohk ebam abe, a eyahbe amahm, ko mmon noa tahm a ne go etahk Jehova go Sayilo. ");
INSERT INTO eka_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Eji bo ko mmona nfong ba wul lim njom, bo kehm koko mmon noo song ka Eli. ");
INSERT INTO eka_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Hanna kehm-e tongo re, <<Nsoo, nyehne! A kp-m kpeka buuma? me wo li nnenkal no yiimi a kohl-a nnya nyi ma sehng go, jo kak ero ka Jehova. ");
INSERT INTO eka_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","N jo kake ero bahb Jehova re á kam mmon noa, wo anv Jehova ma-m faange ji n bahb-e no. ");
INSERT INTO eka_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Anv, n kp-e yake ka Jehova. Go afung kpee nya á bahke jolo go elkpin,>> owo mmon no sa no jo loko Jehova, á kehm gongo kake Jehova edi jio. ");
INSERT INTO eka_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Owo Hanna kehm kake ero re, <<Eltim ename kpꞌgeere goji Jehova, Jehova eblim me mbel ekpunu. M kpˈworo nnyo goji anebekv ebame, tibre ma-m sahb yꞌyebe sehng goji a ma-m yehke yake . ");
INSERT INTO eka_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Nnene limm no li saang ana wo Jehova, nnene limm no sehnge wo, ekpartal limm ji li ana Esowo ebahre. ");
INSERT INTO eka_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Kana sa ji o jo bung elgeere elgeere, afi taame nnyo ema jo bung agabbe, tibre Jehova ye wo li Esowo bi kpꞌkahne nsol kpee, sehng go ege, ye kpo feede ejum ajehng ajehng nne awohng wohng. ");
INSERT INTO eka_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Mban nyi atakuru ebbanne, wo egom ji ma seele gbo, ebfere bel eko. ");
INSERT INTO eka_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Ane ba bele nsol gbalee nyi ellehke, mehle tahm eltum asebe ka elbo eji bo lˈbel nsol alehke li, wo ane ba jo wa njal, njal kpeem jo yam bo. Wo nnenkal no jolo ngum, ebjel abon asehma, wo ye ji bele abon ba nlum gbalee, yebfere kpuk sa abo abo, ");
INSERT INTO eka_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Jehova wo kpo ko elkv ba, fere tob ka elkpin, ye wo kpo kak go elahm, kpe fere nyahme. ");
INSERT INTO eka_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Jehova wo kpo tum ekpak, a afang, ye wo kpo rede, fere mehl wahre. ");
INSERT INTO eka_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Ye wo kpo mehl akpak go ebtohko, fere yehke go ebimatong ane ba li elehng nsol, á kpo fere jehke bo go ellong atubesi, fere lim bo, bo li elkv eti etul ji ekpunu. Tibre Jehova wo kpi abangennahb ekahme nya njini, ona wo á kunu njini nyia. ");
INSERT INTO eka_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Á bahke baabe akpade eljen nya akakesehk alokeltum ebe, wo aneb abꞌbi bahke belle go edi ejannge, tibre go eko sang nne kpo nok bel; ");
INSERT INTO eka_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Jehova bake rannge ane kpee ba kpo yiimi nfaabe a ne, Á bahke take ndan go elbung rannge bo. Jehova bahke lame njini nyia kpee tete rehng go ekahlsi. <<Á bahke kake ntul ewe eko, fˈfo esehnge ebta li ka ntul ewe no á me-e kak akehng go esi.>> ");
INSERT INTO eka_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Owo Elkana kehm tahme kehnge go Rama, wo Samwel mmon noo sa jo loko Jehova go elwo ni Eli ji jolo nlimanjom. ");
INSERT INTO eka_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Abone Eli jo limi abꞌbi; jol Jehova joom lub bo. ");
INSERT INTO eka_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Eljini ellimi ni abalimajom jolo re, ngare nyi nne awohng awohng lꞌba lim njom, nlokeltum no nlimanjom bahke fili egbehm ji kpi ntake era go ege ebo eji bo kpi nlame nlame nnyam go agun, ");
INSERT INTO eka_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","á lꞌjahm egbehm jio kak go ekpaseenge, afi ekpangenyo, afi ejongobil, afi etu, nnyam anyehng anyehng nyi á lꞌtung yehke, bahke jolo ka ye nlimajom. Ano wo bo jo lim anebe Isreel kpee ba jo ba go Sayilo re bo ba lim njom. ");
INSERT INTO eka_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Jol eji bo kala fi afom, nlokeltum no nlimanjom bahke bake ba tong nne no kpi njom lim re, <<Ka nlimanjom nnyam á wo go agun, á nehm taame ko nnyam nyi bo ma lam go ega abo. Sehngem nnyam nyi li mbir mbir nyi á bahke koko.<< ");
INSERT INTO eka_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Nne noo lꞌfere tong-e re, <<Nong nne gbo mbang jahm afom fi, wo yehke nya kor-a no, nlokeltum noo bahke faange re, Eꞌee, yake kpee ka-m, a tohko yake, m bahke koko go egban. ");
INSERT INTO eka_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Abiafem nya abon Eli baa baa gbale sehng go ejang bi Jehova, tibre bo jo fili ayare nya Jehova, ekpunu bo joom kak. ");
INSERT INTO eka_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Ngare nyio, Samwel jolo go Silo jo loko Jehova. Á jolo mmon no nse, fvfo á ajo kake monkpehrekahbe ewobo no nlimajom. ");
INSERT INTO eka_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Elya anehng anehng nnyehn jo kono eljahme mmokpawobo no nse, fere ko song ka-e, á lꞌjee a nlum ewe re bo song lim njom elya. ");
INSERT INTO eka_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Ngare anyehng anyehng nyi bo je, Eli jo fuulu Elkana a nkal ewe, fere bung re, <<Nong Jehova ka-a abon sehng goji nnenkal noa, eji bo lꞌko nji nyi mmon no á kake ero bade, fere rod-e ka Jehova.>> Owo bo kehm feere kehnge. ");
INSERT INTO eka_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Jehova limi nnoobo ka Hanna, á jele abon ba nlum ara, jel ba nkal abal. Gana fvfo Samuel soro asi jo gbale go esamahr bi Jehova. ");
INSERT INTO eka_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Anv Eli, ye ji ma sahb kˈkul wuku bade nsol nyi abon ebe kpˈlimi anebe Isreel kpee, ana bo kpo noongo a anebkal ba jo loko go mbuga mi li rehng go Ebkpatahk Elwane. ");
INSERT INTO eka_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Ano wo á bungu a bo re, <<Jenji wahnge ń kpˈlimi elkohn nsol ana nyia? Me n wuk go ji ane kpee bade abˈbi nsol nya ń kpꞌlimi. ");
INSERT INTO eka_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Eꞌee, abon ebame, nsol nyi n kpꞌwuku ebyeere na yeere go ellong ane ba Jehova, nehme nob ano. ");
INSERT INTO eka_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Nne awohng lꞌlim abiafem tob nne noko. Esowo bahke ma gbo siki ka nne no ma soodo, wo lꞌfere jol re nne awohng awohng eblim abiafem tob Jehova, nne awoo bahke gboongo ka bo? Jol abon bao wuungem atung go enyam bio bi nde ebo, tibre jolo ntir nyi Jehova re á wul bo. ");
INSERT INTO eka_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Mmon noa re Samuel jo soro na asi jo gbal agbal nya ngubjing, á jolo nob nob go ejang bi Jehova, a ejang bi ane. ");
INSERT INTO eka_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Owo nnyehn amare Esowo kehm bake goji Eli ba tong-e re, <<Ji ji a ji Jehova ma bung: <Anv me, n tikem lennge elname ka ebangennahb babnso ewahne, eji bo jolo aju go ji ntula Ijiba? ");
INSERT INTO eka_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","N yehke nso ewahne go atꞌtohngo nya Isreel kpee re á jol nlimanjom ewame, re á jo je go egudu njom, song jahm insen fi, fere jo kak nkpehrekabe ewobo ji nlimanjom go egame elbohngo. N fere tob ka ebangennahb babnso, ayare nsol alehke kpee nyi anebe Isreel ko ba lim njom. ");
INSERT INTO eka_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Jenji wahnge ń kpꞌnyoko njom enyame a ayare nya n tibi re jol ka edi ellene ejame? Jenji wahnge á kpꞌkpunu abon eba sehnge me, eji ń kpˈrodo atingi afv nnyam, nya ayare anyehng anyehng nya Isreel ane ebame kpˈkake, ń jo li fere jo jˈjok? ");
INSERT INTO eka_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Fvfo, me Jehova, ji li Esowo bi Isreel ebbung rea, <N nyame re, ane go ega ebangennahb bahke jo lok-m ano ano.> Wo anv, Jehova eblennge re: <Ndan gbaa aname! Ane ba lꞌkpun-m, bo ba m bahke tob kpunu bo, wo ane ba lꞌnye-m bo ba m bahke nye bo. ");
INSERT INTO eka_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Ngare kpꞌbake nyi m bahke rede afung elkpin ena, a afung elkpin nya anabe etahk babnso, eji nne awohng awohng ewahne lꞌkꞌkpe jo kul, ");
INSERT INTO eka_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","a bahke nyehne ejahk jahk go egame edi ellene. Jolo jolo kan re bo bahke limi nnoobo ka anebe Isreel, nnene nehm kpe jol go ega etꞌtohngo, no bahke jo kul. ");
INSERT INTO eka_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Nne awohng awohng ewahne no n tohk-e ten re á kꞌkpe loko go egame egudu njom, m bahk-e yake, rannge amahr enye, fere rede eko eje, etꞌtohngo eja kpee bahke jo kpo go enyod. ");
INSERT INTO eka_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","<<Ji bahke limi Hofini a Finihas, abon abal eba bahke jolo elliingi ka-a re ji m bungu no bake loko jol go etingitingi, bo bahke kpoko efung efung abehng. ");
INSERT INTO eka_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","M bahke yehke nkakesehk nlimanjom nondiki ka elname no bahke jo lim ana ji wob-m ga eltim, a ntir enyame. M bahke sahb lꞌlim nlaaga enye nyange, bo bahke jo loko go elwo ni nne no m me-e kak akehng go esi ngare anyehng anyehng. ");
INSERT INTO eka_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Owo nne awohng awohng no bake sake go ega ebangennahb bahke jo ba gong ndi gboongo ebahk asilva a ebgbu re, <<Titi lub kak-m eltum edi njom alimi eji n bel nsol alehke jo li.>> ");
INSERT INTO eka_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Mmon noa Samuel jo limi eltum esamahr Jehova go elwo ni Eli. Go afung nyao alum nya Jehova jo rꞌriidi, elfoongo nlem gbalee gaam kpe jol. ");
INSERT INTO eka_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Atv amehng Eli, ye ji amahr ma kehme elbamme, á kil kpe ga nyehn, á noongo go ege edi ji á jo kono elnoongo. ");
INSERT INTO eka_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Enyaale ji Esowo ka si lꞌlahme, wo Samuel noongo go etahk Jehova, edi ji elkohl atahm ni Esowo jolo no. ");
INSERT INTO eka_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Owo Jehova kehm lungu Samuel. Samuel kehm faange re, <<Nyehn me ga.>> ");
INSERT INTO eka_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Á kehm beke je goji Eli, fere tong-e re, <<Nyehn me ga; ji a lung-m no.<< Wo Eli kehm bungu re, <<Me wa-a n ka lung; feere song noongo go ndi.>> Á lohko feere song noongo. ");
INSERT INTO eka_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Wo Jehova kehm kpe lung, <<Samuel!>> Samuel kehm mehle tahm goji Eli, kehm bungu re, <<Nyehn me ga, ji a lung-m no.>> Eli kehm bungu re, <<Mmon ewame, n wa-a n ka lung; feere song, wo song noongo ndi.>> ");
INSERT INTO eka_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Ngare nyia Samuel ka kahn Jehova: Jehova ka lennge ellum ene ka-e. ");
INSERT INTO eka_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Go nkpel era Jehova kehm kpe lung Samuel! Owo Samuel kehm mehle tahm goji Eli, kehm bungu re, <<Nyehn me ga; ji a lung-m no. Owo Eli ba seb kahn re Jehova wo kpꞌlungu mmon noo. ");
INSERT INTO eka_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Owo Eli kehm tongo Samuel re, <<Song noongo, á lꞌkpe-a lung faange re, ˈBung Jehova, nlokeltum ewa kpꞌwuungu atung.ˈ >> Ano wo Samuel kehm feere song noongo go ege edilnong. ");
INSERT INTO eka_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Jehova kehm bake ba yiimi o edi jio, ba kehme ellungu ana á jo kono ellung ngare nyehko, <<Samuel! Samuel!>> Owo Samuel kehm faange re, <<Bung, nlokeltum ewa kpꞌwuungu atung.>> ");
INSERT INTO eka_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Owo Jehova kehm tongo Samuel re, <<Nyehne, n yahke ba ellimi ejum go Isreel ji bahke limi nne awohng awohng no lꞌwuk bade, bahke nehke. ");
INSERT INTO eka_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Go ngare nyio, ejum ajehng ajehng ji m bungu bade Eli a ebangennahb je, m bahke lohngo a nya, bomo go mbomannahb tete ba rehng go ekahlsi. ");
INSERT INTO eka_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Tibre n tong-e re m bahke lame ebahngnahb enje nkahlkahl, tib go abiafem nya á kpꞌkahne bade, abon ebe jo su Esowo, á maam tiki sahde bo. ");
INSERT INTO eka_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Fvfo, me n tir bade etahk Eli, <Ebi ji etahk Eli elgboongo nehm jol go njom alimi, afi go ayare.> >> ");
INSERT INTO eka_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuel noongo eje o tete efungfu se, owo á kehm lennge abu etahk Jehova. Á jo fꞌfahl eltongo Eli elfoongo nlem nyio. ");
INSERT INTO eka_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Wo Eli kehm-e lungu tong-e re, <<Samuel, mmon ewame.>> Samuel kehm faange re, <<Nyehn me ga.>> ");
INSERT INTO eka_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Eli kehm-e bahbe re, <<Ejum aji o ji Jehova bungu tong-a no?>> Kam-a behr ejum ajehng ajehng ji á tong-a no, nong Esowo lim-a ebi ji sahb gbꞌgbal, á lꞌfere behr-m ejum ajehng ajehng ji á tong-a no. ");
INSERT INTO eka_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Owo Samuel kehm-e tongo ejum ajehng ajehng, á we-e behrem ejum ajehng ajehng. Owo Eli kehm bungu re, <<Ye wo li Jehova, nong á lim ji fuumu go ege esamahr.>> ");
INSERT INTO eka_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Jehova jolo a Samuel eji á jo gbal asongo, Jehova tikem taame re ellum anehng anehng ni Samwel bungu no sehnge nkpe. ");
INSERT INTO eka_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Anebe Isreel kpee, bomo go Dan tete rehng go Beeseba liingi re Samuel ebjol nnyehnamahr no Jehova. ");
INSERT INTO eka_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Jehova soro asi jo tib elne go Silo, o edi jio wo, á lennge elne ka Samuel sehng go ege ellum. ");
INSERT INTO eka_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Wo Samuel bungu alum nyaa kpee tong anebe Isreel. Anebe Isreel lohngo re bo song nok a anebe Filista. Anebe Isreel si ebehre ebo go Ebenejer, wo anebe Filista tob si abehre ebo go Afek. ");
INSERT INTO eka_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Anebe Filista kehm yehke nsoja ebo re bo song nok a anebe Isreel. Eji ebta nyange no, Filista nok ga anebe Isreel, fere wul bo ejum ane atahltahl atahlawubu go emahng ebta. ");
INSERT INTO eka_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Eji nsoja feere kehnge go ebo ebehre, anebkul ba Isreel kehm bahbe re, <<Jenji wahnge Jehova ma yake anabe Filista re bo ga-r go ebta lela, wahr anebe Isereel? Nong wahr song koon elkohl atahm ni egbanngalung ji Jehova go Silo, eji á bahke ma jo jen anahre tahr-r yehke go ebo bi anebekv ebahre.>> ");
INSERT INTO eka_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Owo bo kehm tumu ane tv go Silo, bo kehm song ko elkohl atahm ni egbanngalung ji Jehova ji Kpˈfili Elbung a Ndi feere a ni, ye ji jehk go eti etul, go elka elka ni Aserubim. Abon abal ba Eli, Hofni a Finehas bo jolo o a elkohl atahm ni egbanngalung ji Esowo. ");
INSERT INTO eka_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Eji elkohl atahm ni Jehova ba no go abehre, anebe Isreel kpee mehle song kehme elwahle gꞌgingi, ndi gbꞌgbehke. ");
INSERT INTO eka_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Eji anebe Filista wuku ejooko jio, bo kehm bahbe re, <<Elkohn ewahl ajii go abehre nya anebe Hibru? Eji bo sebe kahn re elkohl atahm Jehova ni bo ma ko ba a ni go abehre, ");
INSERT INTO eka_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","anebe Filista kehm kehme elfahle. Bo bungu re, <<esowo ebba go abehre. E li go ntong! <<Euu anareǃ>> Ejum ana jia ka lꞌlim. ");
INSERT INTO eka_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Wahr ebdemmao! Nne awoo bahk-r tahre yehke go ebo bi atahntahn asowo nyao? Bo ba li asowo, bo ji tumu ajoobo ayam nya wulu anebe Ijib go elka emahng. ");
INSERT INTO eka_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Belen atahne ana aneblem wahn Filista! Tohko jol ano, ḿ bahke woomo anebe Hibru go elwo ana bo ma-n tohko woomo. Belen atahne ana aneblum, wahn nok!>> ");
INSERT INTO eka_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Ano wo anebe Filista noko no ga anebe Isreel, anebe Isreel be yel go ebo ebehre. Elwulu ni bo wulu bo gbale sehng. Isreel tane nsoja nyi jo jen akpade efung bio, ane atahltahl nkpe atahlara a nkpel elku. ");
INSERT INTO eka_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Elkohl atahm Esowo bo taare, abon abal ba Eli, Hofni a Finehas bo tˈtob wul bo. ");
INSERT INTO eka_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Efung bꞌnehm o, nne no lohng go etꞌtohngo ji Benjamin, be go emahng ebta tahm go Silo, nsol me-e yare go ngubjing, a ebtohko go ege esi. ");
INSERT INTO eka_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Eji á ba rehng, Eli ji go ege egbiri go nkpe a mbang jo baabe, tibre elfahle gbal-e go eltim bade elkohl atahm Esowo. Eji nnenlum noo ba yel ejahbe, ba tooro ji ma jol, ane kpee go nfam nyio kehm kehme aling ling. ");
INSERT INTO eka_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Eli kehm wuku ewahl aling jio kehm bahbe re, <<Ewahl aling nyao lohngo rejen? Nne noo kehm foomo song tong Eli ejum ji ma lim, ");
INSERT INTO eka_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","ngare nyia Eli ekang nnya atahl ani a nnya elku a nnya era, ye ji amahr enye ma kehme elbamme, á kil ga kpe nyehn. ");
INSERT INTO eka_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Á tongo Eli re, <<me nne no lohngo go emahng ebta abake wo; m be na efungfu bia. <<Eli kehm bahbe re, <<Mmon ewame, jenji ma jol go?>> ");
INSERT INTO eka_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Nne no ko etib bio ba a bi kehm faange re,<<Isreel ebbe anebe Filista. Anebe Filista ebwul nsoja nyi Isereel gbalee. Fvfo abon abal eba Hofni a Finehas bobkpo, elkohl atahm Esowo bob taare fi a ni. ");
INSERT INTO eka_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Eji á gahme elkohl atahm Esowo, Eli kehm tuulu gbo nkpiidankpa go egbiri ji á ji no go nkpe ega, emel eje bahne, á kpo, tibre á jolo nnenkul, gana yeblub. Á fili Isreel go nnya atahl abal. ");
INSERT INTO eka_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Nkala mmon ewe, nkal no Finehas jolo ela, ebrehng ngare nyi á yahke jel. Eji á wuku etib bio re elkohl atahm Esowo bob taare fi a ni, fere tob wuk re nde nlum a nlum ewe bob kpo, á soro tahm song kehme ejel rahng soro jel, eko tan-e tan go ejel bio. ");
INSERT INTO eka_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Eji á kehme elkpoko, anebkal ba bob-e eje bungu re, <<Ka yini ekpu, wob jel mmon no nlum. Jol á faangem, afi wuungu atung. ");
INSERT INTO eka_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Á gung-e mbing re Ikabod, tibre á bungu re, <<Ellub ni Esowo eblohng go Isreel.>> Á bungu jia tibre bob taare elkohl aatahm ni Esowo, fvfo nde nlum a nlum ewe bob. ");
INSERT INTO eka_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","Á bung re, <<Ellub ni Esowo eblohng go Isreel, tibre elkohl atahm Esowo bob taare fi a ni.>> ");
INSERT INTO eka_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Eji anebe Filista ma taare elkohl atahm Esowo, bo rodo go Ebenejer song bum go Asdod. ");
INSERT INTO eka_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Owo bo kehm rodo Elkohl nio song kak go etahk elom Dagon, song bum kohlo Dagon. ");
INSERT INTO eka_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Eji ane ba Asdod lohngo no njahm efungfu, bo nyehne re elokelom Dagon ebgbo kohk esamahr go ndi go esamahr elkohl atahm ni Jehova. Bo song rod Dagon feere a ji jehke edi ji wuku wuku. ");
INSERT INTO eka_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Wo efungfu behko re bo ba lohng je me, Dagon ebgbo kohk esamahr go ndi, go esamahr elkohl atahm ni Jehova! Esi eje a abo ebbakke kpee noongo go egudu mbu, sehngem ekehre-nkv ji ji sa. ");
INSERT INTO eka_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Owo wahnge tete rehng lela, jol afi nlimanjom no Dagon wo, afi nne nondiki wo no lˈyel etahk elom Dagon go Asdod á nehm kpehme kaade akpade go egudu mbu. ");
INSERT INTO eka_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Ebo bi Jehova sabe sehng a anebe Asdod, go adi nya jolo sennge o kak, Jehova koo elrannge ba ka bo go mbang nyi abˈbi afahl ba tuubu bo. ");
INSERT INTO eka_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Eji anebe Asdod nyehne ji kpˈlimi, bo kehm bungu re, <<Elkohl atahm ni Esowo bi anebe Isreel nehm kpe jol egahre, tibre ebo ebe ebbib anahre sehng a Dagon ji li esowo ebahre.>> ");
INSERT INTO eka_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Owo bo kehm lungu atubesi Filista kpee ba kono, kehm bahbe bo re, <<E bahke limi renan a elkohl atahm ni Esowo bi anebe Isreel? Bo kehm faange re, <<Nong wahr roden elkohl atahm ni Esowo bi Isreel song bum go Gati. Owo bo kehm rodo elkohl atahm ni Esowo bi Isreel song bum o. ");
INSERT INTO eka_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Wo ana bo rodo no tahm a ni go Gati, ebo bi Jehova sabe sehng a ejahbe jio, abˈbi afahl kehm gboko tub bo, a elfahle. Jehova kake ejahbe jio erem gbalee, ajangkun a anebkul anebkul, Esowo tumu abˈbi afahl tv bo. ");
INSERT INTO eka_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Owo bo kehm tumu elkohl atahm Esowo tv go Ekron. Ana elkohl atahm jo yel go Ekron, anebe Ekron kehm kehme elrabe re, <<Bob ko elkohl atahm Esowo ni Isreel ba bum-r, re ba wul-r, a ane ebahre. ");
INSERT INTO eka_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Bo kehm lungu atubesi ba Filista ba kono edi ajehng, kehm bungu re, <<Tumen elkohl atahm Esowo ni Isreel tv go, nong feere song go edi ji jolo no, tohko jol ano bahk-r wulu a ane ebahre kpee.>> Tibre elkv ebko elfahle ba go ejahbe; ngare nyio Esowo ebkehme bo erem kak gbalee. ");
INSERT INTO eka_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Ane ba ki kpo, gbo abˈbi afahl, wahnge aling ebo rehnge go ero elbung. ");
INSERT INTO eka_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Eji elkohl atahm Jehova ma jol go ejahbe anebe Filista nnyahng esehma, ");
INSERT INTO eka_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","anebe Filista lungu nlimajom a anebe abuku nbu, kehm tongo bo re, <<Anv, e bahke limi rejen a elkohl atahm ni Jehova? Tong-r ana e bahke feere a ni go ege edi.>> ");
INSERT INTO eka_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Bo kehm faange re, <<Ń lꞌfeere elkohl atahm ni Esowo bi anebe Isreel, kana feere tum tv-e ki-e tob ka nsol njom, mbang anyehng anyehng tumen nsol njom aka nyi ḿ ma li ebi tv-e. Owo ḿ bahke nobo ayam enyahne, ḿ bahke tob kahn ji wahnge á kpeh-n kpaka kak erem.>> ");
INSERT INTO eka_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Anebe Filista kehm bahbe re, <<Elkohn nsol njom aka a nyaa, nya e bahke tumu tv-e? Bo kehm faange re, << Ebahk agul eblon, emongo agul eblon nya bo limi go elfoongo afahl, toono ana nfange atubesi Filista li no, tibre elkohn ayam nya nehm nya gbo tub-n, wahn, a atubesi ebahne. ");
INSERT INTO eka_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Tahl nsol go elfoongo ni akpˈkpudu, a enyamatv bi kpˈrannge ejahbe, wo ko ka Esowo bi anebe Isreel ellub. Fundiki á bahk-n yake abo, tob yake asowo enyahne a ndi enyahne. ");
INSERT INTO eka_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Jenji wahnge ń kpꞌtahne ntim enyahne ana anebe Ijib limi no a Fero? Ngare nyi Esowo bi anebe Isreel bibi a bo, anv, bo tongem anebe Isreel re bo lohng, song mbang nyi boa? ");
INSERT INTO eka_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Anv a, tooben mmvtv akpakenti nyi nfenfe bum, a edamagbudu ebbal, bo ji kpi abon, nong jol bo ji kala sꞌsol nsol, kanne adamagbudu nyao go mmvtv akpakenti, fvfo roden abon ebo wahn kak bo go ega. ");
INSERT INTO eka_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Roden elkohl atahm Jehova wahn kak go mmtv akpakenti, kaken nsol njom aka nya ń yake tum go elkohl, fvfo kaken elkohl nio go nkpe. Nong adamagbudu sol song ntahng tahng, ");
INSERT INTO eka_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","soro asi jo baabe. Lꞌfere je go ege abuntahk, asongo go Beti Semes, eblohng re Jehova wo ma ko egburu ayam nya ba ka-r. Fvfo tohko fere jol ano, owo e bahke kahne re ebo ebe sang ma-r kim ndab, lohngo re jia ma-r tob lim na lim. ");
INSERT INTO eka_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Ano wo bo limi jia. Bo ko elkohn efong bio na abal kanne bo go mmvtv akpakenti, fere rod abon ebo song kak go ega. ");
INSERT INTO eka_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Bo kehm rodo elkohl atahm Jehova kunu o mmvtv akpakenti, budu elkohl ni bo kake enyamatv agul, amongo agul nya li go elfoongo afahl. ");
INSERT INTO eka_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Owo adamagbudu kehm lohko tahm asongo go mbang nyio nyi Beti Semesi, jo biingi mbang mbang, bo tikem yange feere ejang eboblum afi ejang ebobkal. Atubesi anebe Filista jo toono bo tete bo song rehng nkonandi nyi Beti Semesi. ");
INSERT INTO eka_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Wo anebe Beti Semesi jo kiimi arasi go edamme, eji bo tabe asamahr nyehn elkohl atahm, bo bele eyebatahng sehng eji bo nyehne ano. ");
INSERT INTO eka_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","Mmvtv akpakenti nyio kehm song yange go egbe ji Josua nnea Beti Semesi, edi jio wo sa no yiimi kohlo egburu eltal. Ane bao kehm wake akpakenti nya mmvtv nyio, ko kono agun, ko efong bio, lim njom nyi eljahme fi, ka Jehova. ");
INSERT INTO eka_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","Anabe etˈtohngo ba Levi kehm yehke elkohl atahm Jehova bum ndi, a nsol nyi bo ko agul mong kunu go egburu ekpartal. Efung bio anebe Beti Semesi limi njom nyi eljahme fi, a ajom nyako ka Jehova. ");
INSERT INTO eka_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Atubesi alon ba anebe Filista, nyehne nsol nyia kpee, owo bo kehm feere ebo efung bˈnehm o kehnge go Ekron. ");
INSERT INTO eka_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","A wo li nsol njom aka agul nya anebe Filista tumu no tv Jehova, nya bo ma lim ebi nya nya a, anyehng jolo ka Asdod, nyako jol ka Gaja, nyako jol ka Askelon, nyako jol ka Gati a Ekron. ");
INSERT INTO eka_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Nfange enyamatv agul jolo toono ana nfanga nsi Filista jolo no, nya jolo ka atubesi alon ebo, nsi nyia nyi jolo agburu nsi nya bo lange akahme sennge, go abon ejahbe ba nse. Egburu ekpartal ji abalimajom bumu elkohl atahm Jehova li ntianse tete rehng lela go edi egbe ji Josua nnea Beti Semesi. ");
INSERT INTO eka_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Wo Esowo wulu ane bandiki ba lene o Beti Semesi, ane atahl ara ane ewubu ba kpo no, tib eji bo fahnge go atahng elkohl atahm Jehova. Ane bao jolo ndon ndon sehng tib go egburu nfem nyi Jehova ma lim abo ");
INSERT INTO eka_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","wo anebe Beti Semesi kehm bahbe re, <<Nne awoo bahke ma yiimi go esamahr bi Jehova, Esowo bia bi li saang? Eji nne awoo elkohl atahm nia bahke jˈje song jol a ne, lˈtahm a?>> ");
INSERT INTO eka_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Owo bo kehm tumu atiingi etib tv anebe Kiriad Jearim rea, <<Anebe Filista ebfeere elkohl atahm Jehova. Baan, wahn ba rod song ani go egahne ejahbe.>> ");
INSERT INTO eka_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Ano wo anebe Kiriati Jearim kehm bake ba rod elkohl atahm Jehova. Bo ko song bum go etahk Abinadab go ewong, fere yehke Eleaja mmon ewe re á jo baabe elkohl atahm Jehova. ");
INSERT INTO eka_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Ngre nyio elkohl atahm nio jolo go Kiriati Jearim ekidi lꞌlab, jolo o nnya eltahl kohro kohro. Owo anebe Isreel kpee, kehm fere sennge, feere ba tob Jehova. ");
INSERT INTO eka_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Wo Samuel kehm tongo anebe Isreel kpee re, <<Lˈjol re wahn ebsennge feere goji Jehova a ntim a ntim enyahne, yaken ajen asowo nyako kpee, a Astoreti, wahn fere yake elnahne ka Jehova, fere jo loko ye ntahng ntahng, á bahk-n tahre yehke go ebo bi anebe Filista.>> ");
INSERT INTO eka_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Ano wo anebe Isreel lohko yake Baal ebo, a Astoreti fere jo loko Jehova ntahng ntahng. ");
INSERT INTO eka_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Owo Samuel kehm bungu re, <<Nong anebe Isreel kpee kono asi edi ajehng go Mijipa, m bahke gboongo Jehova ka bo. ");
INSERT INTO eka_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Eji bo ba kono asi go Mijipa, bo kehm tohngo alahb ba wohngo go esamahr bi Jehova ana ejum njom, efung bio bo bade njal, fere fvvrv abiafem re, <<Wahr eblim abiafem bade Jehova.>> Ngare nyia Isreel jo kono elwane edi ajehng go Mijipa, Samuel wo jolo ntubesi abo. ");
INSERT INTO eka_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Eji anebe Filista wuku re, anebe Isreel ebsong kono go Mijipa, atubesi anebe Filista kehm bake re bo ba nok a bo. Eji anebe Isreel wuku ano, bo jo fꞌfahl tib anebe Filista. ");
INSERT INTO eka_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Bo bungu tong Samuel re, <<Ka tiki rahke ellingi tob Jehova ka-r, ye ji li Esowo ebahre, eji á lꞌfor-r yehke go ebo bi anebe Filista. ");
INSERT INTO eka_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Owo Samuel kehm koko mmonjoro no kpꞌkpeka yab abel, lim njom nyi eljahme fi kpee ka Jehova. Á lingi tob Jehova tib go esi ji anebe Isreel. Jehova faang-e faange. ");
INSERT INTO eka_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Eji Samuel jo lim njom nyio nyi eljahme fi, anebe Filista kpꞌjeere kabbe anebe Isreel re bo ba bohko bo ebta. Wo efung bio Jehova ta ndan nyi sahb wꞌwahl tv anebe Filista nyi ka bo egburu elfahle ni Esowo limi anebe Filista bo be go esamahr anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Anebe Isreel bohngo lohng go Mijipa jo kam anebe Filista, jo wul bo mbang mbang tete kabbe edamme ji ejahbe Beti Kar. ");
INSERT INTO eka_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Owo Samuel kehm rodo eltal lo go elka elka ni Mijipa a Sen. Á lungu eltal nio re, Ebenejer, fere bung re, <<tete anv, Jehova kp-r kake ebo.>> ");
INSERT INTO eka_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Ana wo anabe Isreel ga anebe Filista, bo kehm rahke elnoko go ndi anebe Isreel. Go afung nya Samuel jolo go elkpin, ebo bi Jehova tiki kuumu anebe Filista. ");
INSERT INTO eka_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Ajahbe nya bomo go Ekron song rehng Gati nya anebe Filista noko no ko go ji anebe Isreel, Isreel fere taare anebe Filita kpee, Isreel tahre abon ajahbe ba li sennge bo kak go ebo bi anebe Filista. Owo elkoono kehm jolo anebe Isreel a anebe Amor. ");
INSERT INTO eka_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Samuel soro asi jol ntubesi no anebe Isreel go afung kpee nya á jolo go elkpin. ");
INSERT INTO eka_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Go elya anehng anehng á jo sehnge go ntoora mbang, bomo go Betel rehng go Gilgal, tete tob rehng go Mijipa, jo lam anebe Isreel go adi nyao kpee. ");
INSERT INTO eka_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Wo fvfo á jo tiki feere go Rama ji jolo ejahbe eje, edi ji etahk eje jolo no, fvfo o wo á jo lam anebe Isreel. Á si egudu njom o ka Jehova. ");
INSERT INTO eka_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Eji Samuel ma kul, á yehke abon ebe ba nlum re bo jol atubesi anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Ngbokambang a mmon ewe bo jo lung-e re Jowel, etoono bo jo lung-e re Abija, bo jolo abalamalam go Beeseba. ");
INSERT INTO eka_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Wo abon ebe joom toono abang nya nde ebo jo toono, bo yaange jo lim nsol nyi jo ka bo nsehng akpohko, jo ko ngu, fere jo bvvrv alam. ");
INSERT INTO eka_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Owo anebkul Isreel kpee kehm kono asi lohng ba goji Samuel go Rama. ");
INSERT INTO eka_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Bo ba tong-e re, <<Wobkul, abon eba ba nlum nehme toono abang enya, anv yehke ntul no bahk-r fili, elkohn ni ajahbe nyako kpee kpi no. ");
INSERT INTO eka_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Eji bo tongo re, <<Ka-r ntul no bahk-r fili,>> ejum jia Samuel atahng we-e yebem; á kehm kake ero ka Jehova. ");
INSERT INTO eka_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Owo Jehova tong-e re, <<Wuungu atung go nsol kpee nyi ane baa kpa-a tongo, wo sang bo kpa-a tene, me wo bo ma-m ten ana ntula bo. ");
INSERT INTO eka_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Ano wo bo ma limi bomo efung bi n yehke bo lohng go Ijib tete ba rehng lela, bo ma-m ten, kpˈfere song loko asowo nyako, ano wo bo kp-a tob lim. ");
INSERT INTO eka_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Anv wuungu bo atung, fvfo sahb rˈrehke bo tˈtahne wo tong bo, ana elkohn ntul noo bahke jolo, á lˈkehme bo fili. ");
INSERT INTO eka_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Samuel tooro alum nya Jehova tong ane ba jo bahb-e re á ka bo ntul. ");
INSERT INTO eka_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Á bungu re, <<Ji ji a ji ntul no bahk-n fili bahke koko ana jꞌje, á bahke koko abon ebahne ba nlum lim bo jo loko go mmvtv akuungu a anyꞌnya, bo bahke jolo go mbuksong mmvtv akuungu enye ana abˈbaabe. ");
INSERT INTO eka_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Bo jimongo á bahke yehke bo re bo jol atubesi nsoja jo fili ane atahltahl atahltahl, bo jimongo bahke jo fili ane atahlabal ewubu, atahlabal ewubu, bo jimongo bahke bahm egbe eje, fere jo kpa, jol tvtv o, bo jehko bahke jo tahl nsol ebta a nsol nyi li ka mmvtv akuungu. ");
INSERT INTO eka_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Á bahke rodo abon ebahne ba nkal bum, bo jo lim akehng esˈsvv eleenge, fere jol abalame nsol a abakaange nsol. ");
INSERT INTO eka_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Á bahke koko adi ndi enyahne nya ga nob, a adi ebgbe oliv enyahne, egbe avaen, a abohko oliv, faake a nya ka alokeltum ebe. ");
INSERT INTO eka_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Á bahke jo yehke ejum ajehng go nsol ewubu anyehng anyehng ana nkohl, agreb faake a nya ka alokeltum ebe, a atubesi abalimeltum ebe. ");
INSERT INTO eka_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Alokeltum ba nlum a alokeltum anebkal ebahne, a adamagbudu enyahne nya nno, a ebvankang, á bahk-n taare jol nyanye. ");
INSERT INTO eka_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Á bahke koko ejum ajehng jio go nsol ewubu anyehng anyehng, go egahne atohkondi, wahnfono antahng bahke jolo aju enye. ");
INSERT INTO eka_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Efung bio lꞌrehng, ḿ bahke lingi re bo tahr-n yehke go abo ntul no ń yehke no. wo Jehova wahn nehm faange. ");
INSERT INTO eka_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Wo ane bao tꞌten elwuungu Samuel atung. Bo kehm bungu re, <<Eꞌee!>> <<Wahr kpꞌsebe ntul no bahk-r fili. ");
INSERT INTO eka_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Owo e bahke jolo ana ajahbe nyako kpee, eji e kpi ntul no bahke jo tv-r, fere jo lohng anahre jo nok nta enyahre.>> ");
INSERT INTO eka_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Eji Samuel wuku nsol nyi ane bao bungu no, á tooro nsol nyio kpee tong Jehova. ");
INSERT INTO eka_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Jehova kehm faange re, <<Wuungu bo atung, wo ka bo ntul.>> Owo Samuel kehm bungu tong anebe Isreel re, <<Nne awohng awohng song kehnge go ege ejahbe.>> ");
INSERT INTO eka_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Nne awohng jolo go, no lohng etꞌtohngo ji Benjamin, á gbale eljini, mbing enye bo jo lung-e re Kisi mmon no Abiel ji jolo mmon no Jeror, ji jolo mmona Bekorati mmona Afia ji lohng go etˈtohngo ji Benjamin. ");
INSERT INTO eka_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kisi bele mmon no nlum no bo jo lung-e Sol, á gbo ejangkun, bi nnene ki kpe jol ana ye go Isreel, á labe elkul ero sehnge nne awohng awohng. ");
INSERT INTO eka_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Ngare nyia, ebvankang bindiki bi nde no Sol ye ji bo jo lung re Kisi kehm tane, Kisi kehm tongo Sol mmon ewe no nlum re, <<Ko nlokeltum awohng, wo song a ne, song kpur ebvankang bio.>> ");
INSERT INTO eka_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Owo bo kehm song sehng go ejahbe ewong ji Efriim, sehng tete rehng ejang erohko bi Salisa, wo bo nyehnem bo. Bo sehng rehng erohko ji ejang Saalim, wo ebvankang o jolem. Owo á fere sehng go nkpohko ejang ejahbe Benjamin, wo bo tikem nyehn bo. ");
INSERT INTO eka_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Eji bo rehnge erohko ejahbe ji Juf, Sol kehm tongo nloketum no jolo a ne re, <<Ba, wahr feere njahm, tohko jol ano nsoo bahke rahke eltiiri bade ebvankang, eltim bahk-e kehme elgbiingi bade anahre.>> ");
INSERT INTO eka_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Wo nlokeltum noo faang-e re, <<Nyehne, ejahbe jia nne Esowo li o, á kpi ekpunu gbalee, ejum ajehng ajehng ji á lꞌbung kpo lohko jol go etingiting. Nong wahr tahm go anv. Fundiki á bahk-r tibi mbang nyi e bahke sehnge.>> ");
INSERT INTO eka_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Sol kehm tongo nlokeltum ewe re, <<E lꞌje, jenji e bahke kake nne noo? Nsol alehke ebmal egahre abam. Ayare e kpimm nya e bahke koko song ka nne Esowo. Ejum ajii e kpi no?>> ");
INSERT INTO eka_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Nlokeltum kehm kpe faange re, <<Nyehne n kpi ebahk asilva a, m bahke kake nne Esowo, eji á lꞌtong-r mbang nyi e bahke sehnge.>> ");
INSERT INTO eka_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","Mahne mahne, go Isreel nne lꞌtong re á bahb Esowo ejum, bo kpo bung re, <<Ba wahr tahm goji nne no kpo nyehn, tibre anyehnamahr ba lela bo kpo lung-e re anyꞌnyehne. ");
INSERT INTO eka_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Sol kehm tongo nlokeltum ewe re, <<Ebnob sehng, nong wahr tahm.>> Owo bo kehm tahme asongo ejahbe ji nne Esowo jolo no. ");
INSERT INTO eka_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Eji bo jo wahr ewong asongo go ejahbe, bo wane ellong agbahme kpꞌlohngo abake re bo ba tohng alahb, bo kehm bahbe bo re, <<Nne no kpo nyehn amahr noa oa?>> ");
INSERT INTO eka_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Bo faang-e re, <<Ye noa, go egahna mbuksong. Foomen anv; yeb tob ba egahre ejahbe lela, tibre ane kpi njom lim edi njom alimi. ");
INSERT INTO eka_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Ń lꞌsi yꞌyel ejahbe, ḿ bahk-e nyehne á kehm tahme go edi njom alimi song li nsol. Ane nehm bom nsol alehke tete á ba, tibre á bahke tiki fuulu njom; á lˈlim ano mal, ane ba bo tiingi bo bahke kehm lehke. Songen go anv, ḿ bahk-e nyehne ngare nyꞌnehm a. ");
INSERT INTO eka_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Ana bo jo jen asongo go ejahbe re bo song yel me, nyehn Samuel ga kpꞌjene abake goji bo, ana á jo tahm go edi njom alimi. ");
INSERT INTO eka_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Anv efung bi sene efung bi Sol kpˈbake, Jehova ebtohko lennge ka Samuel re, ");
INSERT INTO eka_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","<<Behna ngare anana, m bahke tumu nne no lohng etˈtohngo ji Benjamin tv-a. Kak-e akehng go esi, á jol nne no bahke fili ane ebame Isreel. Á bahke tahre bo yehke go ebo bi anebe Filista. Me n seenge ane ebame, tib aling ebo ma-n rehng.>> ");
INSERT INTO eka_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Eji Samuel keebe amahr song nyehn Sol, Jehova kehm-e tongo re, <<A wo li nne no n tong-a no bade a ne; ye wo bahke fili ane ebame.>> ");
INSERT INTO eka_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Sol kehm song gbede Samuel go eti mbu, kehm-e bahbe re, <<Titi á bahk-m ma tib edi ji etahk nne no kpo nyehn amahr li noa?>> ");
INSERT INTO eka_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Samuel kehm faange re, <<Me wo li nnyꞌnyehne.>> Song tahm go edi njom alimi, go edi njom limi, lela á bahke lehke nsol aname, wo efungfu m bahk-a tumu a song, fere tong-a nsol kpee nyi wob go ega eltim. ");
INSERT INTO eka_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Ana ebvankang bi tane no lela nfung era nyi ma sehng, ka kpe tiiri bada bo, bobnyehn bo. Nne awoo no, anebe Isreel kpee ma yehke ntir ebo kunu, wo sanga a etꞌtohngo eja kpeea? ");
INSERT INTO eka_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Sol kehm faange re, <<Me sang lohng go nnahb nyi Benjamina, go etꞌtohngo ji Isreel ji ga sea, me sang nnahb enyame ga rennge go etꞌtohngo ji Benjamina? Jenji wahnge a kpꞌbungu elkohn ejum ana jia tob-m?>> ");
INSERT INTO eka_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Owo Samuel kehm koko Sol, a nlokeltum ewe ba yel ekpꞌkpa fere jehke bo go mbuksong ane ba bo tiingi no, bo jolo ejum eltahl ane awubu go nfange. ");
INSERT INTO eka_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Samuel kehm tongo nlamansol re, <<Ko mmofv nyam no n ka-a no ba, no n tong-a no re wo bum eje eje. ");
INSERT INTO eka_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Owo nlamansol kehm rodo eyo enyam a mmofv nnyam song bum go alata nya Sol. Samuel kehm bungu re, <<Ji ji a ji m bum-a no. Li tibre m bumu eje eje ka wo go elkak nia bomo ngare nyi n tongo re, <Me n tiingi ane.>>> Sol li nsol a Samuel efung bio. ");
INSERT INTO eka_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Ngare nyi bo fere badde edi njom alimi ba rehng go ejahbe, Samuel bung a Sol go ege ero etahk. ");
INSERT INTO eka_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Bo kehm mehle ngare nyi edi yahke lennge, Samuel kehm lungu Sol go ero etahk, <<Tahm toobo ebjing, m bahk-a tumu a feere kehnge go ega eljen. Eji Sol toobo ebjing, ye a Samuel, bo kehm lohngo elatahk. ");
INSERT INTO eka_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Eji bo jo jen asongos go esi ejahbe, Samuel kehm tongo Sol re, <<Tong nlokeltum ewa re, á tohk-r gbo mbansg song tahm.>> wo, tohko sa a mmongare ntiil, eji n lꞌtiing-a etib bi lohng goji Esowo. Ano wo nlokeltum no limi no. ");
INSERT INTO eka_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Owo Samuel kehm rodo elom akehng oliv yaange wohngo Sol go esi, fere sod-e nnyo, kehm bungu re, <<Nyehne Jehova ma-a wohngo akehng re wo jol ntubesi no ane ba á ma li elkelkv.>> ");
INSERT INTO eka_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","A lꞌtahm-m sa a lela, a bahke wane aneblum abal kohlo elahm Rasel, go Jelja go nkonandi nyi Benjamin. Bo bahk-n tongo re, ˈEbvankang bi a lohngo re wo song seb bobnyehn bo. Anv nso ebrahke ebtiri bade a bo, yeb fere kpꞌgbiingi bade a na. Á kpꞌbahbe re, <<Jenji m bahke limi bada mmon ewame?>> ");
INSERT INTO eka_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Wo a bahke soro asi o asongo tete a rehng go egburu elrahn eti Tabor. Ane era ba kpꞌtahme song kak Esowo go Betel bahk-a kpiri o. Awohng bahke solo abon mbul baange ara, noko abon ngbu abred ara, noko bahke fili eyahbe ji bo ko ngu nyam lim. ");
INSERT INTO eka_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Bo bahk-a kake nnyo, fere yar-a ka ngbu ebred ebbal, nyi a bahke koko go ebo abo. ");
INSERT INTO eka_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Lꞌjol ano, a bahke jeke go Gibea go ewong ji Esowo, go edi ji atimbu anebe Filista li no. Eji a kpꞌyele ejahbe jio a bahke wane ellong abanyehnamahr kpꞌlohngo na edi njom alimi abake, bo fili atalehk, agehmegehme, atang, a abuk kpꞌkubu go ebo esamahr, bo bahke kehme amahr nyehn. ");
INSERT INTO eka_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Etohko ji Jehova bahke bake a na nsahm nsahm, a bahke kehme amahr nyehn a bo; wo, a bahke yaange jol nne nondikandiki. ");
INSERT INTO eka_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Nliingi nyia lˈsi jˈjol ano a na , lim ajehng ajehng ji abo enya sebe re wo lim, tib Esowo li a na. ");
INSERT INTO eka_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Gbo-m mbang wo song go Gilgal. M bahke tiki ba o ba lim ajom nya eljahme fi, a ajom nya elkoono, wo a bahke jehke sik go nfung na esehma tete m ba go ega, ba tong-a ji a bahke limi.>> ");
INSERT INTO eka_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Ana Sol sennge re a yake Samuel, Esowo soro yaange eltim Sol, nliingi nyia kpee lohko jol ano efung bio. ");
INSERT INTO eka_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Eji ye a nlokeltum ewe rehnge go Gibea ellong abanyehnamahr soro ba kpir-e, Etohko ji Esowo ba bul-e a nsahm a nsahm, á soro semme a bo jo nyehn amahr. ");
INSERT INTO eka_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Eji ane kpee ba kpe-e kahne wuku wuku nyehne no re á kpꞌnyehne amahr a abanyehnamahr, bo jo bahbe atemtem re, <<Jenji ma jol a mmon no nlum no Kisi? Anv, Sol fvfo tob wob go ellong abanyehnamahra?>> ");
INSERT INTO eka_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Nnenlum no lene o kehm faange re, <<Nne awoo li nde abo? Kehm fere jol ejum elbungu re, <<Anv Sol tob wob ellong abanyehnamahra?>> ");
INSERT INTO eka_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Eji Sol ma rahke amahr anyehne, á tahme edi njom alimi. ");
INSERT INTO eka_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Owo mmonannyehn nde kehm-e bahbe a nlokeltum ewe re, <<Gan wo ń je no?>> Á kehm faange re, <<E song sebe ebvankang. Wo eji e sebe kahn re e nehme nyehn bo, e sehnge je goji Samuel.>> ");
INSERT INTO eka_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Mmonannyehn nde tong-e re, <<Tong-m ji Samuel bungu no tong-a.>> ");
INSERT INTO eka_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Sol faange re, Á lim-r re wahr kahn re, bobnyehn ebvankang. Wo á tongem mmonannyehn nde bade ana Samuel tong-e no bade etul alehke. ");
INSERT INTO eka_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Samuel kehm kuku anebe Isreel re bo ba kono edi ajehng go esamar Jehova go Mijipa. ");
INSERT INTO eka_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Kehm bungu tong bo re, <Ji ji a ji Jehova Esowo bi anebe Isreel kpꞌbungu re, <<Me wo yehke anebe Isreel go Ijib lohng a bo, fere tahr-n yehke go nsahm nyi Ijib, tob tahr-n yehke go abo nya atul kpee ba jo nohk-n.> ");
INSERT INTO eka_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Wo anv wahn ebten Esowo ebahne, ye ji kpo tahr-n yehke go atongtong a ajoobo arem. Wahn ebbung re, <<Eꞌee yehke ntul no bahk-r fili.>> Anv, konen elnahne go esamahr Jehova, go etꞌtohngo etꞌtohngo, a ebangenahb ebangenahb.>> ");
INSERT INTO eka_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Eji Samuel ma lim re anebe Isreel kpee lohng ba go etˈtohngo etˈtohngo, etˈtohngo Benjamin ji elfaange gbo tub bo. ");
INSERT INTO eka_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Á kehm yehke etꞌtohngo Benjamin lohng aji go esꞌsong, ebangenahb, abangenahb, ebangenahb ji Matri ji bo yehke no, esꞌkohro jolo Sol mmon no nlum no Kisi ye wo bo yehk-e no. Wo eji bo kpur-e no, bo w-e nyehnem. ");
INSERT INTO eka_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Owo bo kehm kpe bahb Jehova re, ˈAnv, nne noa ebtiki rehng a? Jehova re <<Ee, yebbehr elne go ellong nsol.>> ");
INSERT INTO eka_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Bo kehm beke song yehk-e lohng a ne, ana á ba yiimi go ellong ane bao, ye wo ga lab, fere yˈyoongo sehnge ane bako. ");
INSERT INTO eka_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Samuel kehm bungu tong ane kpee re, <<Wahn ebnyehn nne no Jehova ma yehka? Nnene limm no li ana ye go ellong ane kpee.>> Owo ane bao kehm rabe re, <<Nlaabe elkpin jol ka ntul!>> ");
INSERT INTO eka_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Samuel kehm lennge ka ane, eljini ni li ka eti etul, a ntum etul. Á nyono kak nwer nyi bo kpo fehd na, rod song bum esamahr bi Jehova. Owo Samuel kehm yaame ane, re bo song kehnge bo eboa ntahk. ");
INSERT INTO eka_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Sol fvfo tob tahm eje kehnge go ege etahk go Gibea, a ellong ane ba toon-e no, ba bele etahneltim ba Esowo ma kooro bo. ");
INSERT INTO eka_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Abvvrv ane bandiki bungu re, <<Yaaa, ye jia bahk-r ma tahra yeke go abo nya anebe ekv ebahra? Bo ten-e, bo w-e yarem ka ejum ajehng ajehng. Wo Sol belle eje.>> ");
INSERT INTO eka_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Nahasi nnea Ammon kehm mehle tahm song bohko Jabesi Giled ebta. Aneblum Jabesi kehm-e tongo re, <<Ba ko nwongo anahre, wahr fere jo lok-a.>> ");
INSERT INTO eka_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Wo Nahasi nnea Ammon kehm faange re, <<M bahk koko nwongo anahne tib ejum, m bahke luudu nne awohng awohng ewahne elmahr eboblum ene eji lˈjol esono ka anebe Isreel kpee.>> ");
INSERT INTO eka_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Anebkul Jabesi kehm-e tongo re, <<Ka-r nfung esehma eji e lꞌmal tum atiingetib tv anebe Isreel; nnene tohko fere ba tahr-r, wahr bahke yake elnahre ka-a.>> ");
INSERT INTO eka_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Eji atiingetib je go Gibea ejahbe ji Sol lene no, song tooro nsol nyia tong ane, bo kpee soro kehme ellingi wahre wahre wahre. ");
INSERT INTO eka_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Ngare nyio Sol kpꞌtob kehnge na kehnge go gbe jo toono efong ebe go njahm, á kehm bahbe re, <<Jenji ma gbo a ane bao? Jenji wahnge ane bao kpꞌlingi? Bo tooro tong-e ana aneblum Jabesi ma ba bung. ");
INSERT INTO eka_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Eji Sol wuku alum ebo, Etohko ji Esowo soro ba a ne, a nsahm a nsahm, atahng soro rake. ");
INSERT INTO eka_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Á rodo alum efong ebal, ja bo jed jed jed, fere tum atiingetib re bo song a nyi goji anebe Isreel kpee, fere jo tooro re, <<Ji ji a ji bahke limi efong bi nne awohng awohng no tohko toono Sol a Samuel.>> Owo elfahle ni Jehova kehm gboko tub ane, bo kehm lohngo ba rur edi ajehng, are nne awohng wo. ");
INSERT INTO eka_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Eji Sol fange bo go Bejek, aneblum ba Isreel jolo ane atahl alon alon nkpel atahl asehma ane atahl ewubu, (300,000), go Juda jolo atahl alon alon nkpel atahltahl atahl awubu. (30,000) ");
INSERT INTO eka_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Bo kehm tongo atiingetib ba ba no re, <<Tongen aneblum Jabesi Giled re, <Ngare nyi njul lꞌfub behna, bo bahk-n tahre.>> Ngare nyi atiingetib bao feere no, song tong aneblum ba Jabesi, ka bo eyebatahng. ");
INSERT INTO eka_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Bo kehm tongo anebe Ammon re, <<Behna e bake yake elnahre ka-n, ń lim-r ejum ajehng ajehng ji kor-n no.>> ");
INSERT INTO eka_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Njahm fungfu nyehko Sol kehm yabe ane ebe go nlong era; N kpese efungfu bo ya yel go ebehre ji anebe Ammon, fere wul bo tete njul fub, bo ji foro no be yaame, jol ane abal jolem ba kpe sa edi ajehng. ");
INSERT INTO eka_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Ane kehm tongo Samuel re, <<Ane a baa jo bahb re, ˈAnv, Sol wo bahk-r fila?ˈ Koon ane baa ba ka-r, wahr wul bo.>> ");
INSERT INTO eka_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Wo Sol bungu re, <<Tibre Lela nnene bo we nehm wul, lela Jehova eltahre anebe Isreel!>> ");
INSERT INTO eka_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Owo Samuel kehm tongo ane re, <<Baan, wahr tahmen go Gilgal kpe song tuungu liingi etul bi Sol.>> ");
INSERT INTO eka_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Ano wo ane kpee kehm mehle tahm go Gilgal song liingi Sol ana ntul go esamahr bi Jehova. Owo bo limi ajom nya elkoono ka Jehova, Sol a anebe Isreel kpee limi egburu elkak. ");
INSERT INTO eka_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Samuel kehm bungu tong Isreel kpee re, <<Me n wuungu atung wuk ejum ajehng ajehng ji ń ma bung tong-m, m ma-n ka ntul no bahke jo fil-n. ");
INSERT INTO eka_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Anv, wahn ebbel ntul ana nne no bahke jo tv-n. Wo ana me a, me n kul mahng abi, abon ebame ba nlum baa anahne, me n jol nne no ma-n fili bomo eji n li njangkun tete tub lela. ");
INSERT INTO eka_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Nyehn me ga yim no. Sahben bung ebi bade aname go esamahr bi Jehova a nne ewe no á kak-e akehng go esi. Nne awoo me, no m ma taare nluma nfong enye? Nne awoo me, no m ma taare mbvankang enye? Nne awoo m me-e nehm? Nne awoo me, no m me-e kak erem. Go abo nne awoo no, m ma ko ngu nyi bahk-m bulu amahr? Lꞌjol re me n lim ejum ajehng ajehng go nsol nyia, m bahke tuungu lim nob.>> ");
INSERT INTO eka_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Bo kehm faange re, <<Wahr a ka nehm, jol wahr a ka kak erem. A ka kˈko ejum ajehng ajehng go abo nne.>> ");
INSERT INTO eka_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Samuel kehm tongo bo re, <<Jehova kpˈyiimi ntianse ka-n, nne no á kake akehng go esi kpꞌtob yiimi ntianse lela re, ejumjum go egame abo ń nyehnem.>> Bo kehm bungu re, <<Á li ntianse.>> ");
INSERT INTO eka_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Owo Samuel kehm tongo ane re, <<Jehova wo yehke Mosis abola Eron, bo song yehke babnso ejahne go Ijib. ");
INSERT INTO eka_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Anv, yiimen tibre m bahk-n gbiiri go akpade, go esamahr bi Jehova go atingi nsol kpee nya Jehova ma lim ka wahn a babnso ejahne ji nkul. ");
INSERT INTO eka_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","Eji Jekob yele go Ijib, bo lingi tob Jehova re, á kak bo ebo, Jehova tumu Mosis abola Eron, bo ba yehke babnso ejahne ji nkul go Ijib, bo ba lene edi jia. ");
INSERT INTO eka_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Wo bo yini Jehova Esowo ebo; ano wo á gungu bo kak abo nya Sisera, ye ji jolo ntubesi nnea nsoja no Hajo, a abo nya anebe Filista, a ntul no Moab, ye ji noko a bo. ");
INSERT INTO eka_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Bo kehm lingi tob Jehova re, <Wahr eblim abiafem; wahr ebten Jehova, fere kpꞌloko Baal a Astoreti.> Anv tahr-r yehke go abo nya anebekv ebahre, wahr bahke fere jo lok-a.> ");
INSERT INTO eka_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Owo Jehova kehm tumu Jerubaal, Barak, Jefta a Samuel, á tahr-n yehke go abo nya anebekv ebahne kpee ba li senng-n kak, wahng ka n jol go elforo. ");
INSERT INTO eka_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","Wo eji ń nyehne re, Nahasi ntul no Amon jo ba elnoko anahne, ń tong-m re, <Eꞌee e kpꞌsebe ntul no bahk-r jo fili.> Jol tvtv o re Jehova Esowo ebahne wo li ntul ewahne. ");
INSERT INTO eka_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Anv, nyehnen ntul no wahn fono yehke no, ye ji ḿ bahbe no; nyehnee Jehova ma-n ka ntul. ");
INSERT INTO eka_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Ń lꞌfere fahl Jehova, lok-e fere wuk-e, kꞌjo nok a atahm enye, lꞌfere jol re, wahn afi ntul no kp-n fili, ń bahke toono Jehova Esowo ebahne, jio bahke nobo! ");
INSERT INTO eka_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Wo ń tohko fere wuk Jehova, ń lꞌfere jo nok a atahm enye, ebo ebe bahk-n kuumu ana kuumu babnso ewahne ba nkul. ");
INSERT INTO eka_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Anv yiimen tꞌtahne wahn nyehn egburu ejum ji Jehova yahke lim egahne esamahr. ");
INSERT INTO eka_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Anv ngare nkohl sak akiimi sanga? M bahke lungu Jehova, á tum ndan a elahb. Owo ḿ bahke liingi elkohn ejum ji ḿ ma lim go esamahr bi Jehova, eji ḿ bahbe re ń kpꞌsebe ntul. ");
INSERT INTO eka_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Owo Samuel kehm lungu Jehova efung bꞌnehm, Jehova tumu ndan a elahb. Ane bao kpee fahle Jehova, a Samuel. ");
INSERT INTO eka_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Bo ane kpee kehm tongo Samuel re, <<Kak ero ka Jehova Esowo eba, go esi alokeltum eba, eji e lꞌkꞌkpo, tibre wahr ebkpe budu elnahre abiafem nyako kpee, ebi ji e bahbe re wahr bel ntul.>> ");
INSERT INTO eka_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Samuel kehm faange re, <<Kana kpe fahl. jol afii wahn eblim abiafem nyaa kpee, jol kana sennge Jehova njahm, wo jo loken Jehova kpee a ntim a ntim enyahne. ");
INSERT INTO eka_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Kana tiki sennge toono alokelom nya ki lohng ejumjum. Bo nehm lim ejum ji nno ka-n, jol bo wahn nehm ma tahr-r, tibre bo lohngem ejumjum. ");
INSERT INTO eka_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Tib go esi ji egburu mbing enye, Jehova nehm tiki ten ane ebe, tibre Jehova atahng yebe sehng re á lim-n wahn jol ane ba be. ");
INSERT INTO eka_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Ana me, ndan gbaa re, me n lim abiafem tob Jehova, kꞌkak ero ka-n. M bahk-n tibi mbang nyi kpꞌnobo, a nyi li go nseenge. ");
INSERT INTO eka_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Wo fvfo lohko jol re ń kpˈfahle Jehova, fere bel ekakesehk jo lok-e, a ntim a ntim enyahne kpee; jo gbo-n ntir bade elkohn agburu nsol nya á ma lim ka-n. ");
INSERT INTO eka_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Wo ń lꞌfere soro asi go abꞌbi alimi, lohngo re wahn, a ntul ewahne, ḿ bahke kpoko tan. ");
INSERT INTO eka_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Sol kange eltahl a nnya ewubu bo kehm-e bobo etul, á fili anebe Isreel go nnya atahl abal a nnya ebal. ");
INSERT INTO eka_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Sol jake aneblum Isreel, ane atahl alon alon eltahl a edi ewubu, ane atahl alon alon go edi eltahl, jolo a ne go Mikmasi, go awong nya ejahbe Betel jolo no, ane atahl alon alon edi ebwubu. jolo a Jonatan go Gibea ji Benjamin. Erik aneblum bako á tumu bo, bo feere kehnge go eboa ntahk. ");
INSERT INTO eka_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Jonatan jo noko a anebe Filista go ebud ji nse ji Geba, anebe Filista wˈwuk. Owo Sol kehm woro ntang go ndi nyio re, <<Nong anebe Hibru wuk!<< ");
INSERT INTO eka_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Ano wo anebe Isreel kpee wuku etib bio re, <<Sol kp'noko a anebe Filista go ebud ji nse, jia limi re, anebe Filista bel etehne bade anebe Isreel,>> Bo kehm kuku ane re bo kpiri Sol go Gilgal. ");
INSERT INTO eka_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Anebe Filista lohngo ba kono asi re bo nok ebta a anebe Isreel, amvtv ebta jolo atahl alon alon go eltahl edi ebwubu (3000), ane ba woomo amvtv ebta jolo ane atahl alon alon edi atahlara (6000), nsoja ruru are erikendi nkpe aya bi. Bo mehle song noongo edi erekekv ji Mikmasi, go ero nfam bi Beti Aven. ");
INSERT INTO eka_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Eji anebe Isreel nyehne re edi ebnyaame bo, nsoja ebo edi ebriidi bo, bo be biiri agohng, mbad, jolo go akpartal, go abing, a abing nya bo kpo kuuru alahb. ");
INSERT INTO eka_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Egom anebe Hibru jindiki siiri aya Jodan song rehng ndi nyi Gad a Giled, Sol sa go Gilgal, ellong nsoja kpee nyi jolo a ne, gbo ngbabohngo elfahle. ");
INSERT INTO eka_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Á ji sik go nfung esehma, ngare nyi Samuel kake no, wo Samuel tikem ba ga Gilgal, aneblum ba jolo a Sol kehme elyaame. ");
INSERT INTO eka_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Owo Sol kehm tongo re, <<Koon nsol njom nyi eljahme fi, a njom nyi elkoono ba ka-m. Sol kehm limi njom nyi eljahme fi. ");
INSERT INTO eka_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Ana á limi njom nyio mal, Samuel kehm soro ba rehng, Sol je re á song kak-e nnyo. ");
INSERT INTO eka_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Samuel kehm-e bahbe re, <<Jenji á ma lim?>> Sol faange re, <<Eji n nyehne re aneblum ebkehme elbeke yaame, wo nehme ba, ngare nyi e kake no, ga anebe Filista ebkono asi go Mikmasi, ");
INSERT INTO eka_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","n tiri, <Anv anebe Filista bahke badde ba kpir-m go Gilgal, gana n ka bahb ekakebo ji Jehova.> Owo wahnge m bobo lim njom nyi eljahme fi.>> ");
INSERT INTO eka_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Samuel kehm bungu re, <<Woblim egboolo ejum. Á bumem elkahn ni Jehova Esowo eba ka-a no; li re a bumu bum, Esowo jol limi eti etul eje gbal kpee ngare anyehng anyehng go Isreel. ");
INSERT INTO eka_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Wo anv etul eba nehm kpin, Jehova ebseb nnenlum no kp-e koro go ege eltim, yehk-e re, ye wo bahke fili ane ebe, tibre a taamem bum elkahn ni Jehova.>> ");
INSERT INTO eka_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Samuel soro tahm o Gilgal song rehng go ejahbe Gibea ji li go erohko ji et'tohngo ji Benjamin. Sol fange aneblum ba sa a ne. Bo jolo ane atahl alon alon edi ebrakebra. ");
INSERT INTO eka_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Sol a Jonatan mmon ewe, go ane ba jolo a ne, bo sa go Gibea ji li go Benjamin, anebe Filista jolo go Mikmasi. ");
INSERT INTO eka_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Abanoko ebta mbehre mbehre lohngo go edi erekekv ji anebe Filista, bo jolo nlong era. Ellong anehng sennge asongo go Ofra go nkpohko nyi Sual, ");
INSERT INTO eka_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","ellong nehko lohng asongo go Beti Horon, go ellong ni biingi nlong era, bo mehle asongo go nkonandi jo seenge edamme ji Jeboyim ji li feere go elka emahng. ");
INSERT INTO eka_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Nne etahl awohng awohng kpeem jol kpee go ndi nyi anebe Isreel, tibre anebe Filista ebbung re, <<Tohko jol ano anebe Hibru bahke limi akahngkahng, afi nkong!>> ");
INSERT INTO eka_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Anebe Isreel jo badde tahm go Filista re bo song bange agburu eblu, eblu bi nse, nfuk, a ebtahme. ");
INSERT INTO eka_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Ekun bi kimi go elbange, eblu bi nnen, eblu bi nse, jolo ejum esikel ebbal, nfuk, elkong arange, a nfuk, a nkong nyi bo kpo ko kam adahmagbudu jolo esikel ajehng. ");
INSERT INTO eka_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Wo efung ebta nne a nsoja awohng awohng no jolo a Sol a Jonatan, jolem no bele ekahngkahng afi elkong go ege ebo; Sehngem Sol a Jonatam mmon ewe, bo ba bele. ");
INSERT INTO eka_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Ngare nyia anebe Filista tumu nsoja ebo re bo song sahd mbang nyi li elka elka ni abon awong ba li asongo go Mikmasi. ");
INSERT INTO eka_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Efung abehng Jonatan mmona Sol kehm tongo njangkun nyi jo fili nsol ebta enye re, <Ba, wahr siiri edamme tahm go edi erekekv ji anebe Filista go ejang behko. Wo Sol nde á we-e tongem. ");
INSERT INTO eka_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Sol jolo ga esi ejahbe ji Gibea go nnahb pomegranati go Mikron. Aneblum ba jolo a ne jolo rehng ane atahltahl atahlawubu, ");
INSERT INTO eka_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","go ellong ane bao, noko bo jo lung-e re Ahija, ye kake nkpehrekahbe ewobo ji nlimanjom. Á jolo mmon no nlum no mmonannyehna Ikabod, no bo jo lung-e re Ahitub, Ahitub mmon no Finehas mmon Eli, ye ji jolo nlimanjom no Jehova go Silo. Nnene kahnem re Jonatan eblohng eje fi. ");
INSERT INTO eka_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Mbang mbang nyi Jonatan jo seb re á ta mbang sehng song rehng go edi erekekv ji nsoja anebe Filista,agbung gbung awong jolo ejang abbal abbal. Ewong jehko bo jo lungu re Bojeji, jehko bo jo lung re Sene. ");
INSERT INTO eka_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Eltal noko yiimi go ejang ebobkal nfam kohlo ejahbe ji bo jo lung re Mikmasi, nehko go ejang eboblum kohlo ejahbe ji bo kpo lung re Geba. ");
INSERT INTO eka_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Jonatan tongo njangkun nyi jo fili nsol ebta enye re, <<Ba wahr tahm go ebud ji nse ji aneblum ba ki nyi Esowo, bo ji kil jo yehke nrur, fundiki Jehova bahke limi ejum tib go egahre esi. Ejumjum limm ji bahke ma kpan Jehova kꞌtahre, afi jolo ellong ni kpꞌgbale, afii ni kpꞌseke.>> ");
INSERT INTO eka_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Nfꞌfila nsol ebta enye bungu re, lim ejum ajehng ajehng kpee ji wob-a go eltim, song a ne, me n li a na eltim anehng, a etohko.>> ");
INSERT INTO eka_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Jonatan re, ba no lun, wahr siiri song kpiri bo, nong bo nyehn-r. ");
INSERT INTO eka_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Bo lꞌbung tong-r re, <<Yiimen o tete wahr ba kpir-n,ˈ e bahke sake edi ji e li no, e nehm je goji bo. ");
INSERT INTO eka_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Wo bo lꞌfere tong-r re, ˈBaan ga egahre,ˈ e bahke wahre je, tibre jia ji bahke jolo elliingi enahre re Jehova ebjabbe bo kak-r go abo.>> ");
INSERT INTO eka_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Owo bo egom egom kehm lohngo gbuul go ebud ji anebe Filista. Anebe Filista re, <<Nyehnen!>> <<Anebe Hibru kpꞌtohngo lohng abing nya bo biiri no.>> ");
INSERT INTO eka_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Aneblum ba jolo go ebud kehm rabe tob Jonatan, a nfila nsol ebta ewe re, <<Baan ga egahre, e bahk-n tibi ń nyehn ejum.>> Owo Jonatan kehm tongo nfila nsol ebta ewe re, <<Wahr, toon-m, Jehova ebyake bo kak ebo bi anebe Isreel.>> ");
INSERT INTO eka_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Jonatan jo ko abo enye a akpade enye wahr, nfila nsol ebta ewe jo wahr toon-e go njahm. Anebe Filista gbo yel go ebo abo. Jonatan wulu anebe Filista ba jo nok a ne go mbuksong, fvfo nfili nsol ebta ewe wulu ane ba jo nok a ne ga njahm. ");
INSERT INTO eka_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Go ngbokambang enok bia Jonatan a nfila nsol ebta ewe, bo wulu aneblum eltahl go morohko edi ntiil no efong bahke ma job efung abehng. ");
INSERT INTO eka_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Elfahle kehm gboko tub nsoja kpee nyi jolo go edi erekekv, a nyi jolo go ekulugbe, bo jolo go ebud ji nse, a nlong nyehko, fvfo ndi gbehke. Esowo bi tumu elfahle nia tv bo. ");
INSERT INTO eka_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Anebe Sol ba kpo baabe adi go Gibea ji Benjamin, nyehne nsoja ma yal elkpa kpˈbeke asongo adi adi. ");
INSERT INTO eka_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Owo Sol kehm tongo aneblum ba jolo a ne re, <<Fange nsoja wahr seb kahn nne no ma lohng egahre ellong. Eji bo limi ano, bo sebe kahn re Jonatan a nfila nsol ebta ewe, bo ba ki li. ");
INSERT INTO eka_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Sol kehm tongo Ahija re, <<Ko elkohl atahm Esowo ba a ni.>> (Ngare nyio elkohl atahm jolo goji anebe Isreel.) ");
INSERT INTO eka_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Eji Sol kpi mbungu mbungu a nlimanjom, ejooko kpe gbal na budu go abud nya anebe Filista. Wo Sol feere tong nlimanjom re, <<Yehke ebo eba ka wake ko elkohl atahm ba.>> ");
INSERT INTO eka_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Owo Sol kehm lungu aneblum kpee ba kono edi ajehng, mehl tahm ebta. Bo nyehne re anebe Filista kpee amahr ebbil bo, bo jo kehme atemtem boomo go ebo akahngkahng. ");
INSERT INTO eka_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Anebe Hibru ba tohko jol wuku wuku a anebe Filista, bo ji jolo a bo go ebo ebud, bo be lohng song yel anebe Isreel ba jolo a Sol go Jonatan. ");
INSERT INTO eka_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Eji anebe Isreel kpee ba biiri go ejahbe ewong ji etˈtohngo ji Efriim wuku re anebe Filista kpˈbeke asongo, bo tob yele ebta sahb fˈfub jo kam bo. ");
INSERT INTO eka_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Go mbang ana nyia nyi Jehova tahre anebe Isreel, ebta bia soro asi siiri Beti Aven. ");
INSERT INTO eka_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Efung bio jolo ejahkjahk efung ka anebe Isreel, tibre Sol gbaange ane kpee ko nwongo rea, <<Nkuk jol a nne awohng awohng no lˈli nsol, elgung kehm bake, tete me n tohko bongo anebekv ebame go nsol nyi bo ma-m lim!>> ellong nsoja anehng anehng tikem li nsol efung bio kpee. ");
INSERT INTO eka_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Ellong nsoja nio kpee kehm yele ekulugbe, akehng ekon jolo o ndi. ");
INSERT INTO eka_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Eji bo yele ekulugbe nti, bo nyehne akehng ekon kpˈfabe lohng, jol nnene behdem kak nnyo, tibre bo jo fahle nwongo nyio. ");
INSERT INTO eka_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Wo Jonatan tikem wuk bade nwongo nyi nde ma gbaange ane, owo á kehm lohko esi ebti bi á fili go ege ebo go akpake ekon, behde ebo ebe kak nnyo, amahr soro bang-e. ");
INSERT INTO eka_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Owo nne a nsoja awohng kehm-e tongo re, <<Nso ko nwongo nyi sahb tꞌtahne, gbaange ane rea, <<Nkuk li a nne no lꞌli nsol lela!> Owo wahnge ane ma gbo ewo a.>> ");
INSERT INTO eka_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Jonatan kehm bungu re, <<Nsoo ebseb mfem ka ejahbe, nyehn ana amahr ma-m bang eji n lahbe akehng ekon ntiil. ");
INSERT INTO eka_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Ji jol ga nob, li re ane li nsol nyi bo da lela goji anebekv ebo. Wob bum re elwulu ni e wulu anebe Filista jolem gbale sehnga?>> ");
INSERT INTO eka_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Efung bio, eji anebe Isreel wulu anebe Filista bomo go Mikmasi song rehng go Ajalon, bo lꞌlahng. ");
INSERT INTO eka_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Bo bꞌbe a nsol nyi bo da no, bo rodo ejoro, adahmagbudu, a efong song wul, bo jo li, a alung alung.>> ");
INSERT INTO eka_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Nne kehm tongo Sol re, <<Nyehn ana ane baa kpꞌlimi abiafem tob Jehova, eji bo kpꞌlehke nnyam alung alung. Sol kehm tongo bo re, <<Eltaame enahne ebgbo. Banngen eltal ni nnen bulu a tvtv.>> ");
INSERT INTO eka_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Á kehm bungu re, <<Songen go ellong ane bao wahn song tong bo re, ˈNo nne ko edahmagbudu a njoro, wahn ba wul bo a, fere li bo. Kana kpe lim abiafem tob Jehova jo li nnyam alung alung.>> Owo nne awohng awohng kehm koko nfong atv mao, song wul-e o. ");
INSERT INTO eka_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Owo Sol soro lim egudu njom ka Jehova. A wo li ngbokambang egudu njom ji á lange no. ");
INSERT INTO eka_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Sol kehm tongo re, <<Nong wahr tahmen song kam anebe Filista atv maa, fere da nsol ebo tete efungfu se, wahr kꞌyake nne awohng sa go elkpin. Bo faang-e re,<<Lim ana fuum-a no.>> Wo nlimanjom bungu re, <<Nong wahr tohko seb kahn goji Esowo a.>> ");
INSERT INTO eka_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Ano wo Sol bahbe Esowo, <<Me n song kam toono anebe Filistaa? A bahke yake bo kak anebe Isreel go eboa?>> Wo Esowo we-e faangem efung bio. ");
INSERT INTO eka_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Sol kehm bungu re, <<Baan a, wahn atubesi nsoja kpee, wahr seben kahn, abiafem nya bo ma lim a lela. ");
INSERT INTO eka_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Etingitingi ana Jehova ji foro anebe Isreel yake li go elkpin, afi ebˈbi jio li a Jonatan mmon ewame, á bahke tiki kpo.>> Jol nne na awohng ellum bungem. ");
INSERT INTO eka_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Sol kehm tongo anebe Isreel kpee re, <<Wahn yiimen go, me a Jonatan mmon ewame, e bahke yiimi ga. Bo faang-e re, <<Lim ana fuum-a no.>> ");
INSERT INTO eka_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Owo Sol kehm kake ero ka Jehova, Esowo bi anebe Isreel. Jenji wahng ka a ki faange nlokeltum ewa lela? Lꞌjol re ebi li ka me, afii Jonatan mmon ewame, faange go elfaange atubu ni bo kpo lung re Urim, wo lꞌfere jol re ebi ji aneblum Isreel ji, tob faange go elfaange ni bo kpo lung re Tumim.>> Jonatan abola Sol bo ba elfaange gbo tub bo, aneblum fˈfor lohng go elfaange nio. ");
INSERT INTO eka_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Sol bungu re, <<Tuben elfaange nia ka me a Jonatan mmon ewame, elfaange nia gbo tub Jonatan. ");
INSERT INTO eka_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Owo Sol kehm tongo Jonatan re, <<Tong-m ejum ji a ma lim.>> Jonatan tong-e tong re, <<N wuungu abon akehng ekon, go egame esi ebti. Wo anv m bahke kpoko!>> ");
INSERT INTO eka_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Sol re, <<Nong Esowo bib aname, sahb bˈbib, wo Jonatan a tohko kpo.>> ");
INSERT INTO eka_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Wo aneblum kehm tongo Sol re, <<Jonatan kpoa, ye ji ma ko egburu elforo nia ba ka anebe Isreela? Nehm jol ano! Etingitingi, ana Jehova li go elkpin, jol ellv esi ene nehm gbo ndi, á limi jia lela tib ekakebo ji Esowo. go mbang nyia aneblum bao tahre Jonatan, bo we-e wulem. ");
INSERT INTO eka_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Owo Sol kehm rahke anebe Filista go elkame, bo fere feere ga eboa ndi. ");
INSERT INTO eka_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Eji Sol ba jol ntul no Isreel, á jo noko a anebekv ebo ejang abehng abehng: anebe Moab, anebe Amon, anebe Edom, atul ba Joba, a anebe Filista. Ejang abehng abehng bi á sennge feere, á jo nohko bo fere kak bo erem. ");
INSERT INTO eka_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Á jo noko sahb tꞌtahne ga anebe Amalek, tahre anebe Isreel yehke go abo ane ba jo da nsol ebo. ");
INSERT INTO eka_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Abon ba Sol ba nlum ba a, Jonatan, Isivi a Malki-Sua. Mbing nyi mmon ewe no nkal, no jolo no nkul bo jo lung-e re, Merab, mmon no nse bo jo lung-e Mikal. ");
INSERT INTO eka_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Mbing nyi nkal ewe bo jo lung-e re, Ahinoam mmon no nkal no Ahimasi. Mbing nyi ntubesi nnea nsoja ewe bo jo lung-e re Abner mmon no nlum no Ner, Ner jolo mmonannyehn ndea Sol. ");
INSERT INTO eka_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Ndea Sol Kisi, a ndea Abner Ner, bo ba jolo abon ba nlum ba Abiel. ");
INSERT INTO eka_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Afung kpee nya Sol jolo no, ebta jo sumu sehng a anebe Filista ngare anyehng anyehng nyi á lꞌnyehn etahntahn nne, afii nne no kpi esahb, á jo ko-e kak ege eltum. ");
INSERT INTO eka_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Samuel kehm bungu tong Sol re, <<Me wo li nne no Jehova tumu re me n ba kak-a akehng go esi wo jol ntul ka ane ebe Isreel; Anv, wuungu atung go etib bi lohng goji Jehova. ");
INSERT INTO eka_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Ji ji a ji Jehova ji Kpˈfili Elbung a Ndi kpˈbungu: <M bahke kake anebe Amalek erem go ejum ji bo limi anebe Isreel, eji bo biiri sik bo go mbang, eji bo lohngo go Ijib jo tahm. ");
INSERT INTO eka_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Anv song wo song nok a anebe Amalek, rannge ejum ajehng ajehng ji li ka bo kpee. Ka yake bo, wul aneblum, a anebkal, a abonse, a abonbili, adahmagbudu a ejoro, akamel a ebvankang.>> ");
INSERT INTO eka_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Owo Sol kehm lungu aneblum, bo ba kono, fere fange bo go Telem- nsoja nyi jo jen akpade jolo ane atahl alon alon nkpel tahltahl nkpel elon,(200,000) ane atahl alon alon nkpel atahl alon,(10,000) nyi lohngo Juda. ");
INSERT INTO eka_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Sol kehm tahme go ejahbe anebe Amalek song biiri sik bo go edamme. ");
INSERT INTO eka_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Owo á kehm tongo anebe Ken re, <<Lohngen song yaken anebe Amalek eji n lꞌki-n tob rannge semme a bo, tibre ń tibi anebe Isreel nnoobo eljini eji bo lohngo go Ijib jo ba.>> Ano wo anebe Ken kehm tahme lohng anebe Amalek sa. ");
INSERT INTO eka_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Sol kehm noko ebta a anebe Amalek ga bo, bomo go Havila tete rehng go Sur, kohlo nkonandi ero nfam nyi Ijib. ");
INSERT INTO eka_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Á bobo Agag ntul no anebe Amalek mbir mbir kehnge a ne, á wulu ane ebe kpee go ekahngkahng. ");
INSERT INTO eka_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Wo Sol a nsoja enye wulem Agag a ejoro bi nno, a adahmagbudu, agburu efong, a abonjoro, ejum ajehng ajehng ji jolo ji nno. Nyaa joom kor bo re bo rannge kpee, wo ejum ajehng ajehng ji bo ma ten, a nya li lenge lenge, bo rannge kpee. ");
INSERT INTO eka_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Owo Jehova kehm bungu tong Samuel re: ");
INSERT INTO eka_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","Me n gbo ntir re n tohko na bob Sol etul, tibre á ma-m sennge njahm, á limem ana n tib-e no,<< Samuel bele erakatahng, á lingi tob Jehova atv mao kpee. ");
INSERT INTO eka_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Efungfu behre behre Samuel kehm lohngo tahm re á song kpiri Sol, wo bo tong-e re, <<Sol ebtahm go ejahbe Kamel. Yebmong ejum bum elne ji bo bahke jo buum-e, fere soro o tahm go Gilgal. ");
INSERT INTO eka_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Eji Samuel kpir-e no, Sol bungu re, <<Jehova fuul-a! Me n lim nsol nyi Jehova tongo no.>> ");
INSERT INTO eka_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Wo Samuel re, <<Jenji wahnge n kpꞌwuku ebiingi ejoro go egame atung?>> fere wuk ebiingi adahmagbudu? ");
INSERT INTO eka_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Sol faange re, <<Nsoja nyi ko bo goji anebe Amalek, bo yake atingi ejoro, a adahmagbudu re bo ko ba lim njom ka Jehova Esowo ebahne, wo nsol nyehko e rannge kpee.>> ");
INSERT INTO eka_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Samuel kehm tongo Sol re, <<Ebgbal! nong me tong-a ji Jehova bungu no tong-m nyaane atv.>> Sol kehm faange re, <<Tong-m me.>> ");
INSERT INTO eka_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Samuel re, <<Jol tvtv o, eji a jolo nne no kpꞌseke ega esamahr, anv wo sang ma jol ntubesi go atꞌtohngo nya anebe Isreela? Jehova kak-a akehng go esi re wo jol ntul ka anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Á fere tum-a eltum re, <Song, wo song rannge anebe Amalek, aneb eblum bao, nok ebta a bo tete wo nyehn re wob feenge bo kpee yehke. ");
INSERT INTO eka_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Jenji wahnge a ki kpunu ji Jehova bungu no? Jenji wahnge a song da nsol fere lim abꞌbi go esamahr bi Jehova? ");
INSERT INTO eka_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Sol re, <<N wꞌwuk Jehova, n jꞌje eltum ni Jehova tum-m no, n lꞌlohko rannge anebe Amalek, n ko Agag ntula bo kehnge a ne. ");
INSERT INTO eka_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Nsoja daa ejoro, a adahmagbudu, atingi nya bo yehke no ka Esowo, eji bo lꞌko ba lim njom ka Jehova Esowo eba go Gilgal. ");
INSERT INTO eka_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Wo Samuel faange re, <<Wo kpꞌtiri re Jehova kpo bel eyebatahng go njom nyi eljahme fia a ajomjom yako, sehnge re nne kak Jehovaa? Etingitingi, ekake nne ji ga gbal sehnge njom alimi, ewuku nne gbale sehnge afom ekom. ");
INSERT INTO eka_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Tibre abiafem nya a kpˈnoko a Jehova li ana aje alimi, elkuudu li ana abiafem eblom ajomo, tib eji a ma ten ellum ni Jehova, á ma-a tob ten ana ntul.>> ");
INSERT INTO eka_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Owo Sol kehm tongo Samuel re, <<Me n lim abiafem. Me n daange ntahm nyi Jehova a elle ena. N jo fꞌfahl aneblum bao, owo wahnge n limi ji bo tong-m no. ");
INSERT INTO eka_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Anv, n kp-a gboongo, tahm ka-m egame abiafem, wo fere ba toon-m, eji n lꞌsong kak Jehova.>> ");
INSERT INTO eka_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Wo Samuel tong-e re, <<N nehm feere ba toon-a, wob ten ellum ni Jehova, Jehova ma-a tob ten ana ntul no anebe Isreel.>> ");
INSERT INTO eka_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Ana Samuel sennge re á tahm, Sol soro jabbe esꞌsili ekpawobo eje, soro yare. ");
INSERT INTO eka_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Samuel kehm-e tongo re, <<Jehova ebyare etul bi Isreel go ega lela, yebrod ka nnebjing ewa no nobo sehnge wo. ");
INSERT INTO eka_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Go nsol kpee ye wo li ellub ni anebe Isreel, efahnge á kpehme kim, afi yaange ntir enye, tibre ye nne sang no bahke yaange ntir enye.>> ");
INSERT INTO eka_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Sol kehm faange re, <<Me n lim abiafem. Titi kpun-m go esamahr anebkul ane ebame, a anebe Isreel, feere toon-m ba eji n lꞌsong kak Jehova ye ji li Esowo eba.>> ");
INSERT INTO eka_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Owo Samuel kehm feere toono Sol, Sol song kak Jehova. ");
INSERT INTO eka_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Samuel kehm bungu re, <<Koon Agag ntul no anebe Amalek ba ka-m, Agag lohngo ba agbekobo go ebo. Á tiri re elmaange ni elkv ebsehng.>> ");
INSERT INTO eka_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Wo Samuel bungu rea, <<Ana ekahngkahng eba ma lim anebkal ki kpe kpi abon, ano wo nne no wa, bahke tob sa abon go ellong anebkal.>> Samuel wulu Agag go esamahr bi Jehova go Gilgal. ");
INSERT INTO eka_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Samuel mehl tahm go Rama, wo Sol mehle eje kehnge go ege etahk go Gibea ejahbe eje. ");
INSERT INTO eka_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Tete efung bi Samuel kpo no, á kpeem tiki je song nyehn Sol, jol tvtv o Samuel jo lingi Sol gbalee. Jehova gbo ntir re á jolem limi Sol jol ntul no anebe Isreel. ");
INSERT INTO eka_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Jehova kehm tongo Samuel re, <<Bahke kange renan ji a bahke lingi Sol, eji m me-e ten re á kˈkpe jol ntul no anebe Isreel? Kak akehng rur go ega ntang, wo mehl song, m bahk-a tumu tv Jese ji Betlehem, me n yehke mmon ewe awohng no nlum re á jol ntul.>> ");
INSERT INTO eka_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Wo Samuel kehm bungu re, <<M bahke jeke renan? Sol lˈfere wuk bade ejum jia, á bahk-m wulu.>> Jehova kehm bungu re, <<Rod mmona nfong no nkal tahm a ne, wo bung re, <M ba re me m ba lim njom ka Jehova.> ");
INSERT INTO eka_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Tong Jese á tob ba go njom alimi nyio, m bahk-a tibi ji a bahke limi. A bahke kake nne no n lꞌtib-a akehng go esi bob-e etul ka me.>> ");
INSERT INTO eka_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Samuel limi ana Jehova bungu no. Eji á rehnge go Betlehem, anebkul nfam akahb kahme bo eji bo ba kpir-e. Bo kehm bahbe re, <<A ba go elkoona?>> ");
INSERT INTO eka_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Samuel kehm faange re, <<Ee, go elkoono wo m ba no. M ba re me m ba lim njom ka Jehova. Yaben elnahne bum ejahne ejahne, wahn toon-m ba go njom alimi.>> Á kehm yabe Jese a abon ebe ba nlum, bum ebo ebo, fere tiingi bo re bo je njom alimi. ");
INSERT INTO eka_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Bo rehnge kan a me, Samuel nyehne Eliab, á kehm tiri re, <<Etingitingi, Á wo li etingi nne no Jehova me-e kak akehng go esi, ma ba yiimi a, go esamahr bi Jehova.>> ");
INSERT INTO eka_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Wo Jehova tongo Samuel re, <<Ka tiiri bade elbohngo ene, afi agbal ero enye, tibre ye m me-e ten. Jehova kpehme seenge nsol ana ane kpo seenge. Ane kpo seenge go elbohngo ni alatahk, wo Jehova kpo seenge go eltim.>> ");
INSERT INTO eka_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Owo Jese kehm lungu Abinadab, tong-e re á sehng go mbuksong mi Samuel, wo Samuel bungu re, <<Jol noa, Jehova we-e ka yehke.>> ");
INSERT INTO eka_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Jese limi re Sama tob ba sehng, wo Samuel bungu re, <<Jol ye Jehova we-e yehkem.>> ");
INSERT INTO eka_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Jese limi ano ano abon ebe ba nlum na asehma, bo sehng go esamahr bi Samuel, wo Samuel kehm-e tongo re, <<Jehova ka yehke nne awohng awohng go ebo ellong.>> ");
INSERT INTO eka_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Owo á bahbe Jese re, <<A wo li abon ba nlum ba a kpi no kpeea?>> Jese kehm faange re, <<Ebsa mmonkahla, á kpi ejoro kpur.>> Samuel re, <<Tumen tv-e, wahr nehm tiki ji ndi tete á ba rehng a.>> ");
INSERT INTO eka_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Owo á kehm tumu bo song ko Jese ba a ne. Á jolo biki biki fere bel elbohngo ni nno, á gbo ejangkun. Jehova kehm bungu re, <<Nne noo wo a, mehl wo kak-e akehng go esi.>> ");
INSERT INTO eka_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Owo Samuel kehm rodo ntang yaange akehng kak-e go esi go esamahr abonanyehn ba nlum. Bomo efung bio asongo etohko ji Jehova kehm bake goji Devid a nsahm a nsahm. Samuel soro mehl tahm go Rama. ");
INSERT INTO eka_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Ngare nyia Etohko ji Jehova ebyake Sol abo, ebi etohko ji lohng goji Jehova ji kpo gbiing-e. ");
INSERT INTO eka_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Alokeltum ba Sol kehm tongo Sol re, <<Nyehn ana ebi etohko ma lohng goji Esowo ba kehm-a elgbiingi. ");
INSERT INTO eka_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Nong nsoo ewahre tong alokeltum ebe bo seb nne no bahke ma kub egehmegehme. Á bahke jo kub ngare nyi ebi etohko lꞌlohng goji Esowo ba a na, bahk-a tele.>> ");
INSERT INTO eka_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Owo Sol kehm tongo alokeltum ebe re, <<Seben nne no kpo mal elkubu egehmegehme, wahn ko-e ba ka-m. ");
INSERT INTO eka_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Nlokeltum awohng go ellong abalokeltum kehm faange re, <<Me n nyehn mmon no nlum no Jese ji Betlehem, ye ji kpꞌkahne ana bo kpo kub egehmegehme nobnob. Á li nne no kpi etahne eltim, a li ntakuru. Á kpo bung nobnob, á li nne no gbo ejangkun. Jehova li a ne.>> ");
INSERT INTO eka_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Owo Sol kehm tumu atiingi etib tv Jese fere bung re, <<Tum Devid mmon ewa no nlum tv-m, ye ji kpo kpur ejoro. ");
INSERT INTO eka_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Owo Jese kehm rodo mbvankang, gbad-e nsol alehke, a eyahbmahm ji bo ko ngunyam lim, ji amahm ma rur, a mmombul baange, kehm tumu bo a Devid mmon ewe no nlum tv Sol. ");
INSERT INTO eka_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Devid kehm bake goji Sol, ba jol nlokeltum ewe. Á jo koro Sol s'sehng. Devid woomo go ellong ane ba jo fili nsol ebta enye. ");
INSERT INTO eka_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Owo Sol kehm tumu ellum tv Jese re, <<Yake Devid, á samme sa jo lim eltum aname, tibre á ma-m kor s'sehng.>> ");
INSERT INTO eka_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Ngare anyehng anyehng nyi ebi etohko lꞌlohng goji Esowo ba yel Sol, Devid bahke rodo egehmegehme soro kehme elkubu, Sol bahke naange, fere jol nobnob, ebi etohko bahk-e yake. ");
INSERT INTO eka_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Ngare nyia anebe Filista lungu nsoja ebo ba kono go Soko ji Juda re bo nok ebta. Bo bumu ebud nsoja ebo go Efesi Damim go elka elka ni Soko a Ajeka. ");
INSERT INTO eka_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Sol a anebe Isreel kono fere bum ebud nsoja ebo go edamme ji Ela, jo toobo elbo re bo song nok a anebe Filista. ");
INSERT INTO eka_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Anebe Filista kuumu ewong ajehng, anebe Isreel kuumu ajehko, edamme jol bo elka elka. ");
INSERT INTO eka_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Ntubesi ebta, mbing enye bo jo lung-e re Golaya, á lohng go Gati, kehm lohngo go ebud nsoja ji anebe Filista ba yiimi. Elkul ero ene, a labe rehng ntahme elon, fere jꞌjok. ");
INSERT INTO eka_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Á konngo ekpasi ebilekpi go esi, á kake ewobo ebta ji bo ko ebilekpi lim, kpꞌlubu rehng esikel atahltahl nkpel ewubbal atahl awubu,(57kilogram) ");
INSERT INTO eka_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","go ege akpade á kpennge ebilekpi, fvfo go njahm á leenge elkong ebilekpi. ");
INSERT INTO eka_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Ebti bi elkong ene jolo ana ebti ntubansol, esi elkong bahke rehnge <<esikel>> atahltahl atahl awubu nne lˈdumu. (7 kilogram) Nne no jo fili ekum ebe gbo-e mbang. ");
INSERT INTO eka_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Golaya yiimi jo rabe tob atubesi nsoja nyi anebe Isreel re, <<Jenji wahnge ń lohngo ba noongo ebta? Me n nne Filista sanga, wahn alokeltum ba Sol sanga? Yehken nne á ba kpir-m ga edamme ba nok aname.>> ");
INSERT INTO eka_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Á lꞌfere mal nok wul-m, wahr bahke fere woom-n go elwo, wo me n lꞌnok sehng-e fere wul-e, wahn bahke fere woom-r go elwo fere jo lok-r.>> ");
INSERT INTO eka_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Nne Filista noo jo bungu re, <<Lela me n rede nsoja nyi anebe Isreel, ka-m wahn nnenlum awohng wahr nok atemtem.>> ");
INSERT INTO eka_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Eji Sol a anebe Isreel kpee jo wuk ana nnea Filista jo bung alum nyaa, eko jo tane bo, bo jo kahme na kahm. ");
INSERT INTO eka_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Devid jolo mmona nnenlum no bo jo lung-e re Jese ji lohng go Efrat go Betlehem ji Juda. Jese bele abon ba nlum na anehkeni, ngare nyio nyi Sol, Jese ebsahb kꞌkul. ");
INSERT INTO eka_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Abon ebe ba nlum na era toono Sol je ebta: Ngbokambang bo jo lung-e re Eliab; etoono Abinadab, etoono ane ara Sama. ");
INSERT INTO eka_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Devid wo jolo nkalla. Ara baa ba nkul jo toono Sol, ");
INSERT INTO eka_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","wo Devid jo lohngo etahk Sol jo song kpur ejoro nde go Betlehem. ");
INSERT INTO eka_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Go nfung atahl abal nyi nnea Filista noa jo lohng ba yiimi, efungfu a elgung. ");
INSERT INTO eka_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Efung abehng Jese kehm tongo Devid mmon ewe no nlum re, <<Rod nsahke nyia, a awokowoko nkohl, nya nne l'dumu bahke rehnge ekilogram ebwubu wo foomo song ka abonane go ebud nsoja. ");
INSERT INTO eka_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Tob ko alahbbel nfong ma bo ma ban wum, ebahk ebwubu wo ka ntubesi no ellong ebo. Nyehn abonane ana bo li no, wo feere ba tong-m. ");
INSERT INTO eka_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Bo li a Sol, a aneblum Isreel kpee go edamme ji Ela kpꞌnoko a anebe Filista.>> ");
INSERT INTO eka_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Efungfu behre behre Devid yake ejoro ka mbꞌbaabe, kpu nsol gbade mehl asongo ana Jese nde tong-e no. Á rehnge go ebud nsoja eji nsoja kpꞌlohngo tahm edi ji ebta li no, bo kpꞌbiiki ebiiki ebta. ");
INSERT INTO eka_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Anebe Isreel a anebe Filista kpꞌjeere ebo ebta kabbe atem. ");
INSERT INTO eka_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Devid yake nsol enye ka nne no kpo kpur nsol, be song rehng go edi ji ebta fi no re á song bahb ana abonanyehn li no. ");
INSERT INTO eka_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Eji á jo bung a bo, Golaya ntubesi ebta no anebe Filista, ye ji lohng go Gad, kehm lohngo yiimi go mbuksong ebta nyi anebe Filista, kehm kehme elrabe, Devid kehm wuku. ");
INSERT INTO eka_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Ngare anyehng anyehng nyi anebe Isreel lꞌnyehn nnenlum noa, bo kpee jo be a egburu elfahle. ");
INSERT INTO eka_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Anebe Isreel jo bungu re, <<Ń kpꞌnyehne ana nnenlum noa kpo kono ellohngo ba, jo ba rede anebe Isreel. Ntul n Israel bahke kake nne no lꞌwul nnenlum noa agburu afang, fere ka-e mmon ewe no nkal, á ko-e go elbal, tob yehke nnahb enye bo nehm kpe jo tahb etak go Isreel.>> ");
INSERT INTO eka_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Devid kehm bahbe ane ba yiimi kohl-e re, <<Jenji bahke jolo ka nne no lꞌwul nnenlum noa, fere yehke esono jia go esamahr anebe Isreel? Ye elkohn nnea Filista awoo no kala yehke na nrur, bahke jo ba nyok nsoja nyi Esowo bi li go elkpin? ");
INSERT INTO eka_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Bo kpe tooro tong-e ana bo kpꞌbungu, <<Jia ji bo bahke limi ka nne no wulu nnenlum noo.>> ");
INSERT INTO eka_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Eji Eliab ji jolo mmonannyehn no Devid wuku ana á kpˈbungu a aneblum bao, atahng rak-e tob Devid , á kehm bahbe re, <<Jenji wahnge a ba a? Nne awoo a tahme abonjoro bao sa-e go elka emahng? N kpꞌkahne elkohn elgeere ni a kpi no, ana eltim ena li eblum eblum, a ba re wo ba nyehn ana ebta li no.>> ");
INSERT INTO eka_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Devid kehm bungu re, <<Anv, me n lim jen? N nehm ma bung elluma?>> ");
INSERT INTO eka_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Á kpe sehng song bahb ane bandiki ejum jˈnehm, aneblum bao kp-e faange ejum jꞌnehm. ");
INSERT INTO eka_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Ane kehm wuku ji Devid jo bung, bo kꞌko song tong Sol, Sol kehm tumu re bo lung Devid tv-e. ");
INSERT INTO eka_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Devid bungu tong Sol re, <<Nnene eltim ki-e gbehke tib elbungu ni nnea Filista noa. Me, nlokeltum ewa bahke song nok a ne.>> ");
INSERT INTO eka_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Sol faange re, <<Wo nehm ma lohng song nok a nnea Filista, wo mmonjangkun wo, yeb jol ntakuru nnoko ebta bomo eji á li njangkun.>> ");
INSERT INTO eka_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Wo Devid tongo Sol re, <<Me nlokeltum ewa jo kpuru ejoro nsoo, ngbe afii ebea lohngo ba, ba bob njoro go ebo ellong, ");
INSERT INTO eka_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","n kame toon-e song rum-e, fere tahre njoro nyio yehke go ege a nnyo, á lꞌsennge toon-m n jo bob-e ege anyar fere wul-e. ");
INSERT INTO eka_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Me nlokeltum ewa me n wul ngbe a ebea, nnea Filista noa, ye ji ki yehke nrur bahke jolo ana enyam bio, tibre yeb nyok nsoja nyi Esowo bi li go elkpin. ");
INSERT INTO eka_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Jehova ji kpo tahr-m yehke go akpade ngbe a akpade ebea, bahk-m tahre yehke go ebo nnea Filista noa. Sol kehm tongo Devid re song, Jehova jol a na. ");
INSERT INTO eka_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Owo Sol kehm liibi Devid eblahme ebta ebe, á kak-e ewobo ebta fere konng-e ekpasi ebilekpi go ege esi. ");
INSERT INTO eka_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Devid kehm gbade ekahngkahng bi Sol, go ekpawobo ji á kake no, gaare eljene yannge o, tibre ye kpehme kono elkake nyao. Á kehm tongo Sol re, <<N nehm ma je a nsol nyiao, tibre me-e ka kpuuru. Owo á kehm yehke.>> ");
INSERT INTO eka_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Owo á kehm rodo ebti ebe fili, á jake afeele atal na alon, go ebgba kak go ege ebam ji á kpo leenge jo kpur ebul, fere fili egbasad go ebo kabbe nnea Filista. ");
INSERT INTO eka_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Wo ga nnea Filista a nne no jo fili ekum ebe go egea mbuksong kpꞌ jeere kabbe Devid ");
INSERT INTO eka_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Á seenge Devid too, fere nyehn re, Devid se sehng, mmonse no nlum, a gbo ejangkun fere nꞌnob, Golaya Devid we foongem ejumjum go ege amahr. ");
INSERT INTO eka_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Á kehm tongo Devid re, <<Me mbv nyia, ji wahnge á kpꞌbake egame a ebtia?>> Nnea Filista noa su Devid bade asowo enye. ");
INSERT INTO eka_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Á bungu re, <<Ba a, m bahke yare ngubjing enya ka nruk a enyamkulugbe bo li!>> ");
INSERT INTO eka_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Devid bungu tong nnea Filista re, <<Á kpꞌbake ga egame a ekahngkahng, go elkong, budu molkong no nse, wo me n kpꞌbake go ega go mbing nyi Jehova ji kp'fili Elbung abola Ndi , Esowo bi nsoja nyi anebe Isreel, ye ji á kp-e rede. ");
INSERT INTO eka_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Lela Jehova bahk-a jabbe kak-m go abo, m bahk-a rumu tub ndi fere kim-a esi. Lela jia, ngubjing enyahne wahn nsoja nyi anebe Filista, m bahke kake nruk a enyam ekulugbe, njini kpee bahke kahne re, Esowo bia go Isreel. ");
INSERT INTO eka_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Bo jio kpee ji ma rur a, bahke kahne re, go ekahngkahng, a elkong sang Jehova kpo tahre, ebta bi Jehova bi, á bahk-r kake wahn kpee egahre abo. ");
INSERT INTO eka_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Ana nnea Filista jo jeere kohl-e re á nok a ne, Devid soro be elware asongo go mbuksong ebta re á song kpir-e. ");
INSERT INTO eka_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Á Lohko ebo go ege ebam, yehke eltal kehm mahde tub nnea Filista go ege a mbuk. Eltal nio yel-e go mbuk, á gbo koongo esamahr go ndi. ");
INSERT INTO eka_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Go mbang ana nyia wo Devid ko egbasad a eltal ga nnea Filista, eji á sade wul-e, jol ekahngkahng á filem. ");
INSERT INTO eka_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Devid kehm beke song wahr kuum-e, song jabbe ekahngkahng ebe, tohng wob go mbak eji á me-e wul, á kim-e esi go ekahngkahng. Eji anebe Filista nyehne re, ntubesi ebo ebkpo, bo soro sennge be. ");
INSERT INTO eka_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Owo nsoja nyi Isreel, a nyi Juda kehm soro be asongo jo rabe, kam anebe Filista tete song rehng edi elyele ji Gad a eti mbu ji Ekron. Akvne jo noongo mbang mbang nyi Saaram tete rehng Gad a Ekron. ");
INSERT INTO eka_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Eji anebe Isreel jo feere kehnge go elkame ni bo kame anebe Filista, bo ba da nsol go ebud nsoja. ");
INSERT INTO eka_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Devid koo esi nnea Filista noo ba a ji go Jeusalem, nsol ebta nyi nnea Filista, á song kake go ege etahk. ");
INSERT INTO eka_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Eji Sol jo baabe Devid eji á lohngo re a song kpiri nnea Filista, a tongo Abner ji jolo ntubesi a nsoja re, Abner nne awoo li nde mmonjangkun noo? Abner faange re, <<Etingitingi ana wo li go elkpin, nsoo ntul, me n nehme kahn.>> ");
INSERT INTO eka_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Ntul bungu re, <<Seb kahn nne no li nde mmonjangkun noa.>> ");
INSERT INTO eka_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Ana Devid kehnge no eji á song wul nnea Filista, Abner soro ko-e ba a ne goji Sol, Devid kpeka kpi esi nnea Filista go ebo. ");
INSERT INTO eka_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Sol kehm-e bahbe re, <<Wo mmon a nyehne, njangkun?>> Devid re, <<Me mmon no nlum no nlokeltum ewa, Jese ji lohng go Betlehem.>> ");
INSERT INTO eka_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Eji Devid ma bung a Sol mal, Jonatan ba jolo ajehng go etohko abola Devid, Devid jo kor-e ana ebjing ebe antahng. ");
INSERT INTO eka_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Bomo efung bio Sol bumu Devid re á jol a ne, á kpeem taame re Devid feere song go etahk nde. ");
INSERT INTO eka_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Jonatan bo gbannge alung abola Devid, tibre á jo kor-e ana ebjing ebe. ");
INSERT INTO eka_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Jonatan yehke ekpawobo eje ji á kake no feere aji ka Devid, a ewobo ebta, go ekahngkahng ebe, elban ene, a atake elban. ");
INSERT INTO eka_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Eltum anehng anehng ni Sol tumu Devid, Devid jo limi go nseenga nseenge, wahng ka Sol ka Devid nji nyi kpꞌwahre go nsoja. Jia koro nlong nsoja kpee, a atubesi abalimeltum ba Sol fvfo. ");
INSERT INTO eka_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Eji nsoja jo feere kehnge eji Devid wulu nnea Filista, anebkal kehm lohngo go ajahbe Isreel kpee re bo song wane ntula Sol, bo jo yimi ase fere jo bahn, bo jo yimi ase eyebatahng jo kub atalehk a agehmegehme. ");
INSERT INTO eka_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Ana bo jo bahn, bo jo yimi re, <<Sol ebwul ane atahltahl ba be, Devid ebwul ane atahla nku a nkuu ba be.>> ");
INSERT INTO eka_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Sol atahng rak-e sehng, eltim we yebem tib go elkohn elbungu nia, á tiri re, bob ka Devid nfange nyi kpˈwahre, ane atahla nku a nku, wo me atahltahl nya nya. Jenji á bahke kpe bel, kˈsehnge eti etul? ");
INSERT INTO eka_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Bomo ngare nyio asongo, Sol kehme Devid amahr kunu. ");
INSERT INTO eka_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Njahm efungfu nyehko, ebi etohko kehm lohngo goji Esowo eko eko ba yel Sol. Á kehme amahr nyehn go ege etahk. Devid jo kubu egehmegehme ana á jo kono ellimi, ngare nyi ejum jio lˈba a ne. kehm rodo egehmegehme jo kub ana á jo kono ellimi. Sol fili elkong go ege ebo. ");
INSERT INTO eka_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Á ro elkong nio tv Devid, tibre á tiri re m bahk-e jahme bade ekahme, <<M bahke jahme Devid bade ekahme.>> Wo Devid fehme nkpel ebal. ");
INSERT INTO eka_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Sol kehme Devid fahl, tibre Jehova jolo a Devid, wo yeb yake Sol. ");
INSERT INTO eka_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Owo á kehm tumu Devid fere ka-e nsahm re á jol ntubesia nsoja atahltahl nkpel ebal atahlawubu. Devid rod nsoja nyio lohng a bo tahm edi emahng ebta ebo. ");
INSERT INTO eka_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Go ejum ajehng ajehng ji Devid jo lim jo nˈnob a ne, tibre Jehova jolo a ne. ");
INSERT INTO eka_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Eji Sol jo nyehne re Devid nsol jo nˈnob a ne, á jo fahl-e fahl. ");
INSERT INTO eka_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Wo ane kpee ba Isreel, a ba Juda Devid jo koro bo sehng, tibre Devid jo ko bo song rehng ebo emahng ebta. ");
INSERT INTO eka_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Sol kehm tongo Devid re, <<Nyehn mmon ewame no nkal no nkul Merab, m bahk-a kake ye, a ko-e go elbal, lub lok-m esahb esahb, wo nok ebta bi Jehova.>> Wo Sol bungu tong elne re, <<N nehm kpe tiki tab ebo kun-e, nong anebe Filista lim-e go!>> ");
INSERT INTO eka_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Wo Devid tongo Sol re, <<Me elkohn nne awoo, nnahb enyame li jen, afii ejahbe ejame li jen go Isreel ji bahke wahnge me n jol nnara ntul?>> ");
INSERT INTO eka_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Owo eji ngare rehnge no nyi Merab mmon no nkal no Sol, nyi jolo re bo ka-e Devid á jol nkal ewe, bo fere rod Merab ka Andril ji lohng go Mehola. ");
INSERT INTO eka_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Mmona Sol no nkal Mikal bo jolo go elkoro abola Devid eji bo tongo Sol, Sol kor-e kor. ");
INSERT INTO eka_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Á tiri ano re, <<M bahk-e kake ye, eji á lꞌ jol esi eti mbang ka-e eji ebo bi anebe Filista lˈkuum-e.>> Owo Sol kehm tongo Devid re, <<Anv wobbel etoono eyake re wo jol nnar ewame. ");
INSERT INTO eka_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Owo Sol kehm kake anebe etahk ebe nsahm re, Bungen a Devid mbehr mbehr re, <<Nyehn me, ntul a kp-e koro, ane ebe kpee a kpꞌtob kor bo, nobo re wo jol nnar ewe.>>> ");
INSERT INTO eka_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Bo jo tongo Devid alum nyaa nkpela nkpele. Wo Devid bungu re, <<Wahn kpꞌtiri re ejum ji nse jia, re nne jol nnara ntula? Me ga, nkpak nyi, bo me-e nehme ga kahn.>> ");
INSERT INTO eka_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Eji alokeltum Sol tong-e ji Devid ma bung, ");
INSERT INTO eka_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Sol faange re, <<Tongen Devid re, ˈNtul nehme seb ekun elaame abehng abehng, sehnge re bo wul anebe Filista, kiimi bo adokodoko, atahl alon bongo anebekv ebe.>> Ntoobo nyi Sol jolo re, eji Devid lꞌgbo yel ebo anebe Filista bo wul-e. ");
INSERT INTO eka_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Eji abalimeltum Sol, song tong Devid ejum jia, kor-e kor re á jol nnara ntul. Eji afung elbal nya bo kake no lꞌkꞌsehng, ");
INSERT INTO eka_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","Devid kehm rodo nsoja enye, bo tahm ebta song wul anebe Filista atahl awubu fere kiimi bo adokodoko ba anya. Bo fange nfange nyio jang jang tib ntul, eji Devid lꞌjol nnara ntul. Owo Sol kehm yake mmon ewe no nkal Mikel re bo jol elbal. ");
INSERT INTO eka_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Eji Sol sebe kahn re Jehova li a Devid, mmon ewe no nkal Mikal Devid kpe-e koro, ");
INSERT INTO eka_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","Sol jo kpe fahl na Devid budu, á sa jol nne ekv no Devid tete afung enye nya á jolo go elkpin. ");
INSERT INTO eka_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Atubesi nsoja ba anebe Filista soro asi jo lohng tahm ebta, ngare anyehng anyehng nyi bo lꞌlim ano, jo tiki nob a Devid, sehnge atubesi nsoja bako kpee ba Sol, fvfo mbing nyi Devid kpe lohng egburu elgahm. ");
INSERT INTO eka_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Sol tongo Jonatan mmon ewe no nlum a anebe etahk ebe kpee re, bo wul Devid. Wo Jonatan ga Devid jo kor-e sehng. ");
INSERT INTO eka_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","Jonatan sahb rꞌrehke Devid re, <<Nsoo ewame Sol kpꞌsebe mbang nyi á bahk-a wulu, baabe elna behna efungfu seb edi wo song biiri sa o. ");
INSERT INTO eka_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","M bahke jeke ekulugbe song yiimi bung a nsoo, edi ji a behr no, m bahke bungu nobnob bade a na, m bahke ba tong-a n lꞌseb kahn.>> ");
INSERT INTO eka_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Jonatan bungu nobnob bada Devid tong nde Sol re, <<Nong ntul kꞌlim ebi a nlokeltum ewe Devid, á wa-a ka soodo, ji ye ma lim ma-a ka egburu elgahm. ");
INSERT INTO eka_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Á fili elkpin ene go ege ebo, eji á wulu nnea Filista. Toono o Jehova ka anebe Isreel kpee egburu esehngebta, fvfo a ny'nyehn fere bel eyebatahng. Jenji wahnge anv a yahke lim ebi tob nnea mbol mbol, eji a yahke wul Devid mbol mbol?>> ");
INSERT INTO eka_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Sol wuungu Jonatan atung, fere ko nwongo nyia re, <<Etingitingi ana Jehova li go elkpin Devid bo we-e nehm wul. ");
INSERT INTO eka_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Owo Jonatan kehm lungu Devid fere tub-e eka jia. Á ko-e ba a ne goji Sol, Devid fere jol a Sol ana wuku wuku. ");
INSERT INTO eka_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Ngare anyehng ebta kehm kpe gbo, Devid lꞌlohng song nok a anebe Filista. Á noko a bo tꞌtahne wul bo, egom jehko be. ");
INSERT INTO eka_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Wo ebi etohko lohngo goji Jehova ba yel Sol, eji á jehk no ege ekpꞌkpa fili elkong ege ebo. Ana Devid jo kub egehmegehme, ");
INSERT INTO eka_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Sol gaare re á jahm-e elkong ene bade go ekahme, wo Devid fehme, eji Sol ro elkong sehng song jahm yel ekahme. Atv mao Devid noko sehng be for. ");
INSERT INTO eka_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Sol tumu aneblum tv go etahk ji Devid re, bo song baabe eji bo lꞌwul Devid efungfu. Wo Mikal nkala Devid rehk-e re, <<a tohko be tahre elkpin ena atv maa, behna bo bahk-a wulu.>> ");
INSERT INTO eka_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Owo Mikal kehm yehke Devid yake go mmombu a nkpe ekahme, á be for. ");
INSERT INTO eka_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Mikal kehm rodo elokelom bum edilnong, konngo mbomo fere kpu anyar mbul bul-e go esi. ");
INSERT INTO eka_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Eji Sol tumu aneblum re bo ba bob Devid, Mikal tongo bo re, <<Á kpꞌyame.>> ");
INSERT INTO eka_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Sol kpe tum aneblum re bo song nyehn Devid, á tongo bo re, <<Roden ye a edilnong edilnong ba a ne eji n lꞌwul-e.>> ");
INSERT INTO eka_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Wo eji aneblum yele ekpꞌkpa, bo nyehne elokelom kun edilnong, go ege esi anyar mbul nya, bo nyehne no. ");
INSERT INTO eka_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Sol kehm tongo Mikal re, <<Jenji wahnge a ma-m nehm ana me, yake nnekv ewame á be for?>> Mikal tong-e re, <<Á tong-m re, Tob-m me m be for, tohko jol ano m bahk-a wulu.>>> ");
INSERT INTO eka_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Eji Devid ma be for, á tahme goji Samuel go Rama, song tong-e nsol kpee nyi Sol me-e lim. Owo ye abola Samuel kehm tahme go Noati fere song sa o. ");
INSERT INTO eka_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Ellum kehm song kpiri Sol re, Devid li go Naoti nyi Rama;>> ");
INSERT INTO eka_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Owo á kehm tumu aneblum re bo song bob-e. Wo eji bo song nyehn ellong abanyehnamahr kpi amahr nyehn, Samuel yim o ana ntubesi abo, etohko ji Esowo kehm ba yel aneblum ba Sol tumu no, bo fvfo tob kehme amahr nyehn. ");
INSERT INTO eka_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Sol bo song tong-e bade ano, á kpe tum aneblum bako, bo fvfo tob kehme amahr nyehn. Sol kpe bulu tum aneblum go nkpel era, bo fvfo tob song kehme amahr nyehn. ");
INSERT INTO eka_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Esꞌkohro yefono tahme antahng go Rama sehng song rehng go egburu elbing alahb ni Seku. Song bahb re, <<Samuel abola Devid bo ba na?>> Bo tong-e re, <<Bo li go Noati nyi Rama,>> ");
INSERT INTO eka_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Owo Sol kehm tahme go Noati nyi Rama, Etohko ji Esowo tob ba a ne á jo jen yannge jo nyehn amahr tete á song rehng go Noati. ");
INSERT INTO eka_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Á jaake ekpawobo eje, ye fvfo tob nyehn amahr go esamahr bi Samuel. Á noongo ebun ebun efung kohro kohro, atv kohro kohro. Owo wahnge ane bungu re, <<Sol fvfo tob wob go ellong abanyehnamahra?>> ");
INSERT INTO eka_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Owo Devid kehm beke Noati nyi Rama tahm goji Jonatan song bahb re, <<Fono me n lim jen? Jenji li ebi ejame? Mbang anyii m ma soodo nso, ji wahnge á kpꞌgaare re á wul-m? ");
INSERT INTO eka_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Jonatan faange re, <<Kpak, a nehm kpo, nyehne, nsoo no ewame kpehme lim ejum ajehng ajehng ji nlen afii ji nse, ki-m lim me n kahn. Jenji wahnge á bahk-m behre ejum ana jia? Ano sanga!>> ");
INSERT INTO eka_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Wo Devid ko nwongo bung re, <<Nso no ewa kpꞌsahb kꞌkahn nobnob re a kpi nnoobo eljini aname, yeb bung tong elne re, <Jonatan nehm tiki kahn jia, tohko jol ano bahk-e maange sehng.> Etingitingi ana Jehova li go elkpin, wo tob li go elkpin, me n nong na go emel elkv. ");
INSERT INTO eka_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Jonatan kehm tongo Devid re, <<Ejum ajehng ajehng ji a l'seb re me n lim ka-a, m bahke limi ka-a.>> ");
INSERT INTO eka_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Owo Devid kehm bungu re, <<Nyehne, behna wo li nnyahng nfenfe mi elkak alimi, jol fuumu re me n li nsol a ntul, wo nong me n song, song biiri go ekul tete elgung ni njahmfunfu nyehko. ");
INSERT INTO eka_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","L'jol re nso me-e nehm tiki nyehn, tong-e re Devid sahb gb'gboongo re me n yak-e á be je go Betlehem go ege ejahbe, tibre nnahb enye kpee bahke limi njom nyi elya. ");
INSERT INTO eka_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Á lꞌfere tong re <Ebnob sehng.> Eblohng re me nlokeltum ewa ebfor. Wo lꞌfere rak-e, a bahke kahne re á kpꞌlohko seb re á lim-m ejum. ");
INSERT INTO eka_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Ana wofono antahng, tib me nlokeltum ewa nnoobo eljini, tibre wo wo ko-m ba, ba ko nwongo go esamahr bi Jehova. Lꞌjol re me n li ebi wul-m antahng. Jenji wahnge a bahk-m yake ka nso.? ");
INSERT INTO eka_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Jonatan re, <<Kpak. Lub li re me n wuk ejv bio re, nsoo no ewame kpꞌtiki seb re á lim-a ejum, kehn me wa-a nehm tong-a?>> ");
INSERT INTO eka_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Devid kehm bahbe re, << Nso lˈfaang-a egban egban, nne awoo bahk-e ba tong-m?>> ");
INSERT INTO eka_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Jonatan kehm bungu re, <<Ba wahr tahm go ekul, owo bo kehm toono ano tahm.>> ");
INSERT INTO eka_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Jonatan kehm tongo Devid re, <<Me n tir Jehova ye ji li Esowo bi anebe Isreel re, m bahke nyame nsoo, egolgol ji anv, njahm efungfu nyi behna. Lꞌjol re á bahke bungu nobnob bade a na, m bahke tumu ellum tv-a lim-a a kahn. ");
INSERT INTO eka_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Wo lꞌfere jol re nsoo kpꞌtiki seb re á lim-a ejum, nong Jehova bib aname, sahb sꞌsab, n tohk-a lim a kahn fere tum-a a song go eyebatahng. Nong Jehova jol a na ana á ma jol a nsoo. ");
INSERT INTO eka_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Wo, tib-m nnobo eljini ni lꞌkꞌkane ana elkohn nnoobo eljini ni Jehova, ana me n li elkpin, eji bo lꞌki-m wul. ");
INSERT INTO eka_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","Ka tiki yake nnoobo eljini ena, a nnahb enyame, jol afii fere jolo re Jehova ebwul nne awohng awohng no li nnekv no Devid go esamahr njini nyia. ");
INSERT INTO eka_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Owo Jonatan kehm koko nwongo anebe etahk Devid bung re, <<Nong Jehova lung anebekv ba Devid elam.>> ");
INSERT INTO eka_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Jonatan limi re Devid kpe tuungu riini aba go nwongo tib go elkoro ni á kpi a ne, tibre á jo kor-e ana yefono antahng. ");
INSERT INTO eka_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Jonatan kehm tongo Devid re, <<Behna efung nnyahng nfenfe mi elkak, ane bahke jo bahb re Devid li gan? tibre eti eja bahke sake nnehme nehme. ");
INSERT INTO eka_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Njahm fungfu yehko, ngare elgung, song go edi ji a biiri no ngare nyi ntong nyia bomo no, yiimi sik go eltal ni Ejel. ");
INSERT INTO eka_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","M bahke take ntake elban na era tv ejang bio, bahke jolo are n kpꞌtake tv edi ji bo tibi no. ");
INSERT INTO eka_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","M bahke tumu mmon no nlum, fere tong-e re, <Song wo song seb atake elban nyao.> N lꞌfere tong-e re, <Nyehne, atake elban nyao li ejang bia, song ko ba,> Wo lohng ba, etingitingi ana Jehova li go elkpin, wobfor; efin abehng abehng limm. ");
INSERT INTO eka_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Wo n lꞌfere tong mmon no nlum noo re, <<Nyehne, atake elban nyao ma-a siiri sa,>> A bahke songo, tibre Jehova ma-a tum re wo song. ");
INSERT INTO eka_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Bade nwongo nyi li ka wo a me nyi e ma toobo, buumu re Jehova wo li ntianse enyahre tete go njinanjini. ");
INSERT INTO eka_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Owo Devid kehm biiri go ekul, eji nnyahng nfenfe mi elkak ba no, ntul kehm jehke re á li nsol. ");
INSERT INTO eka_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Á jii go edi ji á jo kono eljehke go nkpe ekahme wane a Jonatan. Abner jii kohlo Sol, wo eti ji Devid jolo nnehme nehme. ");
INSERT INTO eka_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Sol bungem ejumjum efung bio, á tiri re, ejum ji ma lim Devid, ji wahng ka á ki li saang, etingitingi á lohkem jol saang. ");
INSERT INTO eka_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Wo njahm efungfu nyehko, etoono efung nnyahng, eti ji Devid kpe tiki jolo nnehme nehme. Owo Sol kehm tongo Jonatan mmon ewe re, <<Jenji wahnge mmona Jese ki ba, ba li nsol, jol nyaane afii lela?<< ");
INSERT INTO eka_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Jonatan faange re, <<Devid sahb gboong-m gboongo ko nsahm re, ye tohko je go Betlehem. ");
INSERT INTO eka_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","Á bungu re, <<Nong me n tohko je, tibre nnahb enyahre kpꞌbumu njom alimi go egahre ejahbe, fvfo abonanee tong-m re me n tob jol o. Nyehn-m ndon me n song, song nyehn abonanee ebame. Jia ji wahnge á ki ba go ekpukuru ji ntul. ");
INSERT INTO eka_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Sol atahng kehme rake tob Jonatan, á kehm bungu tong-e re, <<Wo mmona nnenkal no kpo bvvrv edi fere jo lim edaangenne go elrang wo, wo nehme kahn re me n kpꞌkahne re, a yim mmona Jese njahma, ji li esono ka wo-a, ji tob li esono ka nnenkal no jel-e noa? ");
INSERT INTO eka_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Ana mmona Jese li go elkpin go njini nyia, jol wo, jol etul eba nehm yiimi. Anv tum nne, bo song ko-e ba ka-m, á bahke tiki kpo!<< ");
INSERT INTO eka_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Jonatan kehm bahbe nde re, <<Jenji wahnge á bahk-e wulu?>> Jenji á ma lim?>> ");
INSERT INTO eka_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Wo Sol kehm roko elkong ene tv Jonatan re á wul-e. Owo Jonatan kehm lohko kahn re nde kpꞌlohko seb re á wul Devid. ");
INSERT INTO eka_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Jonatan kehm mehle o ekpukuru a egburu erakatahng, etoono efung bi elkak nio, nsol á liim, tibre eltim maange sehng tob nde, tib go esono ji nde jo ko fili Devid. ");
INSERT INTO eka_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Efungfu Jonatan soro lohng tahm ekul re á song kpiri Devid. Á fili mmonse no nlum, ");
INSERT INTO eka_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","á tongo mmonse noo rea, <<Be song seb atake elban nya n kpꞌtake a.>> Ana mmonse noo jo be asongo, á taa ntake elban siir-e sa. ");
INSERT INTO eka_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Eji mmonse song rehng edi ji ntake elban ni Jonatan gbo no, á kehm-e lungu, fere tong-e re, ntake elban li-a go esˈsong, jen song>> ");
INSERT INTO eka_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Owo á kehm rabe re, <<Foomo! Song elwaare! Ka yiimi!<< Mmonse noo rodo ntake elban nio feere a ni ba ka nde nju. ");
INSERT INTO eka_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Mmonse noo joom kahn ejumjum bade ejum jia, sehngem Jonatan abola Devid, bo ba jo kahn. ");
INSERT INTO eka_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Owo Jonatan kehm kake mmonse noo nsol ebta enye, fere tong-e re, <<Song, rod nsol nyia wo song bum go ejahbe.>> ");
INSERT INTO eka_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Eji mmonse noo ma tahm fi, Devid kehm lohngo go nkpohko ejang eboblum eltal, ba gong ndi ka Jonatan nkpel era a esamahr ebe go ndi. Owo bo kehm bingi atemtem fere jo ling, wo Devid wo ga ling. ");
INSERT INTO eka_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Owo Jonatan kehm tongo Devid re, <<Song go elkoono, tibre wahr ebtir ekpondahme go mbing nyi Jehova, fere bung re, <<Jehova wo li ntianse enyahre, ye jꞌnehm wo tob li ntianse nyi etꞌtohngo eja a etꞌtohngo ejame go njinanjini.> << Devid soro tahm, Jonatan tob feere ga ejahbe.>> ");
INSERT INTO eka_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Devid kehm tahme go Nob re á song nyehn Ahimelek ji nlimanjom, Ahimelek jo kꞌkahm eji á ba kpir-e, á bahb-e re, <<Jenji wahnge a li a antahng? Jenji wahnge nnene ki li a na?>> ");
INSERT INTO eka_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Devid faange Ahimelek nlimanjom re, <<Ntul wo tum-m eltum, á tong-m re, <<Nnene kꞌkahn ejum ajehng ajehng bade eltum ni n kpa-a tumu.>> Bade aneblum ebame, me n tong bo re, bo ba kpir-m ekahmekahme edi. ");
INSERT INTO eka_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Anv a, jenji a kpi no go ega ebo, ka-m ebred eblon me, afii ana a lꞌbel. ");
INSERT INTO eka_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Wo nlimanjom faange Devid re, <<N kpimm abred nyehka nyehka, jol tvtv a, abred nya bo ma bum saang li a. Bo bahke ma li l'jol re aneblum bao ebyehke elbo go elnoongo anebkal.>> ");
INSERT INTO eka_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Devid faange re, <<Eyaame ji elnoongo anebkal wahr ebbum go fee, ana wuku wuku kpo jol n l'si l'lohng. Agubjing nya aneblum baa li saang, Jol afi jolo ngare nyi ki li re bo jol saang, gohro t'tong lela.!<< ");
INSERT INTO eka_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Owo nlimanjom kehm-e kake ngbu nyi jolo saang, eji jolo re ngbu nyindiki jolem. Sehngem ngbu nyi jo jol go esamahr bi Jehova nyi bo ma yehke, fere yaange ngbu nyi kpˈfubu go efung bi bo rodo no. ");
INSERT INTO eka_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Ana jolo o, nlokeltum awohng no Sol jolo o efung bio, bo tohk-e bum o esamahr bi Jehova, bo jo lung-e re Doeg, nne Edom, á jolo ntubesia mbaabe ebul ewe. ");
INSERT INTO eka_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Devid kehm bahbe Ahimelek re, <<Anv a, á kpimm elkong afii ekahngkahng aa? N fil-m ekahngkahng ebame a nsol ebta nyehko tibre eltum ni ntul tumu no jolo go elfoomo sehng.>> ");
INSERT INTO eka_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Nlimanjom faange re, <<Ekahngkahng bi Golayad nnea Filista no a wul-e no go edamme ji Ela bia a; bo kpennge mbomo li o njahma nkpehrekahbe ewobo nyi nlimajom. Joare a kpꞌsebe rod, ekahngkahng abehng abehng a kpeem li sehngem Devid kehm bungu re, <<Bindiki kpeem li ana bio, ka-m ga.>> ");
INSERT INTO eka_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Efung bio Devid bee for go abo nya Sol tahm goji Akisi ntul no Gati. ");
INSERT INTO eka_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Wo aloketum ba Akisi tong-e re, <<Devid ntul no ndi nyia sang a? Ye sang bo kpo yim-e go ebo asea re: << <Sol ebwul atahltahl ba be, wo Devid ebwul atahla nku a nkuu ba be?>> ");
INSERT INTO eka_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Devid rodo alum nyaa kuuru go ege eltim lim-e, á kehme Akisi ntul no Gati fahl. ");
INSERT INTO eka_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Owo á kehm soro yaange go ebo esamahr tvtv, eji á jolo o ebo abo, a fere jo lim ana ngbokosahla nne, jo tennge alok go abutahk eti mbu, eron jo lohng-e faabe ege elahng. ");
INSERT INTO eka_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Akisi kehm tongo alokeltum ebe re, <<Nyehnen, nnenlum noa, yeb joobo. Jenji wahnge ń ko-e ba ka-m? ");
INSERT INTO eka_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Me wo agbokosahla ane ma lehng egama, ji wahnge ń ko nne noa ba kehme nsol nyia lim go egame esamahra? Nne noa fꞌfuumu re á ba egame etahka?>> ");
INSERT INTO eka_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Devid kehm tahme o Gati, be tahm go egohng ji Adulam. Eji abonanyehn a anebe etahk nde wuku ano, bo soro tahm song kpir-e o. ");
INSERT INTO eka_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Ane kpee ba edi jo riidi bo afii bo bele abong, afii bo jo nyehne erem, bo kame ba rur senng-e kak, á fere jol ntubesi no jo tv bo. Jolo rehng aneblum atahltahl ba jolo a ne. ");
INSERT INTO eka_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","O edi jio wo Devid tahme song rehng go Mijipa nyi Moab, song tong ntula Moab re, <<Titi, nongo nsoo, a nnee, bo ba jol a na tete me n kahn ji Esowo bahke limi ka-m.>> ");
INSERT INTO eka_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Owo á tahme bo sa goji ntula Moab, bo jolo a ne go afung nya Devid jolo go ekobta. ");
INSERT INTO eka_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Wo nnyehnamahra Gad tongo Devid re, <<Ka sa o ekobta. Song go ndi nyi Juda.>> Owo Devid kehm tahme go ekulugbe ji Hereti. ");
INSERT INTO eka_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Ngare nyia Sol kehm wuku re, Devid a aneblum ebe bob nyehn bo. Sol noa jehk a elkong go ebo go nnahb eti ji bo kpo lung re tamarisk, go ewong ji Gibea a atubesi alimi eltum ebe kpee yim go ege a nkpe. ");
INSERT INTO eka_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","Á kehm tongo bo re, <<Wuungu atung aneblum ba Benjamin! Anv mmon no nlum no Jese bahk-n ma ka adi ebgbe kpee a adi ebgbe agreba? Á bahk-n limi ń jol atubesi nsoja ane atahltahl atahltahla a atubesi nsoja ane atahl alon alona? ");
INSERT INTO eka_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","Ano wo wahnge wahn kpee ma lam kak-ma? Nnene me-e tongem egahne ellong ngare nyi mmon ewame koo nwongo a mmona Jese. Nne awohng awohng ewahne lim no tiir-m no afii tong-m re mmon ewame yim njahm nyi nlokeltum ewame re bo noongo sik nok aname, ana á kpꞌlimi lela. ");
INSERT INTO eka_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Wo Doeg nnea Edom, ye ji yiimi a atubesi alimi eltum ba Sol, kehm bungu re, <<N nyehne mmona Jese ma ba goji Ahimelek ji mmona Ahitub go Nob. ");
INSERT INTO eka_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Ahimelek wo bahbe Jehova ka-e. Á tob ka-e nsol alehke, a ekahngkahng bi Golayad nnea Filista. ");
INSERT INTO eka_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Owo ntul kehm tumu tv Ahimelek ji nlimanjom ji mmona Ahitub a aneblum kpee ba jolo nnahb enye, bo ji jolo abalimajom go Nob, bo kpee kehm bake goji ntul. ");
INSERT INTO eka_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Sol bungu re, <<Wuung-m atung anv, mmona Ahitub.>> Á kehm-e faange re, <<Ee nsoo ewame.>> ");
INSERT INTO eka_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Sol kehm bungu tong-e re, <<Jenji wahnge a ma lam kak-m, wo a mmona Jese, á ka-e abred a ekahngkahng, fere bahb ntir nyi Esowo ka-e, ebwahng anv, á kpꞌnoongo sik re á nok aname, ana á kpꞌlimi lelaa?>> ");
INSERT INTO eka_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Ahimelek kehm faange ntul re, <<Nne awoo go ellong alokeltum eba no nne bahke bumu go etingitingi ana Devid, ye ji li nnara ntul, ntubesi abꞌbaabe eba no kpi ekpunu go nlaaga enya kpee? ");
INSERT INTO eka_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Efung bio bi li na ngbokambang efung bi m ma bahb Jehova ka-ea? Jol efung bio bi bi sang. Nong ntul kꞌka me nlokeltum ewa ebi, afii nnahba nde, jol me nlokeltum ewa nehme kahn ejumjum bade nsol nyia kpee.>> ");
INSERT INTO eka_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Wo ntul kehm bungu re, <<Wo Ahimelek á bahke tiki kpo na a nnahb a nnahb enya kpee.>> ");
INSERT INTO eka_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Owo ntul kehm kake abꞌbaabe ebe ba yim-e nkpe re, <<Senngen wahn wul abalimajom ba Jehova, tibre bo fvfo tob yim njahma Devid. Bo kahne re, á jo be na, jol bo me-e tong-m.>> Wo atubesi alimi eltum joom kor bo re, bo tab ebo wul abalimajom ba Jehova. ");
INSERT INTO eka_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Ntul kehm kake Doeg eko re, wo sennge, wo wul abalimajom.>> Owo Doeg nnea Edom kehm sennge wul bo. Efung bio á wulu ane atahl ani ane alon ba liibi akpehrekahbe awobo nya abalimajom. ");
INSERT INTO eka_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Fvfo á tob wulu anebe Nob go ekahngkahng, ejahbe ji abalimajom, aneblum, anebkal, abonse a abonbili, adahmagbudu, ebvankang go ejoro. ");
INSERT INTO eka_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Wo mmon awohng no Ahimelek mmona Ahitub no bo jo lung-e re Abiata, á be for song tob Devid. ");
INSERT INTO eka_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","Á tongo Devid re, Sol ebwul abalimajom ba Jehova. ");
INSERT INTO eka_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Owo Devid kehm tongo Abiata re, <<Efung bio eji Doeg nnea Edom jolo o, n kpꞌkahne re, á bahke tiki tong Sol. Me wo wahnge ewul ma yel tob nnahb enya kpee. ");
INSERT INTO eka_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Jol aname a, ka kpe fahl. Nnenlum no kpꞌsebe re á wul-a, kpꞌtob gaare re á wul-m fvfo. A bahke foro aname aname.>> ");
INSERT INTO eka_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Efung abehng, eji bo tongo Devid re, <<Nyehnee, anebe Filista kp'noko a anebe Keyila fere jo kpu nsol mbahma ndi ebo, edi ji bo kpo febe nkohl.>> ");
INSERT INTO eka_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","Owo Devid kehm bahbe Jehova re, <<Me n song nok a anebe Filistaa?>> Jehova faang-e re, <<Song, wo song nok a anebe Filista fere tahre ejahbe Keyila.>> ");
INSERT INTO eka_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Wo aneblum ba jolo a Devid tong-e re, <<A na Juda e kpꞌfahle, kehm jolo renan re, wahr tahm go Keyila song nok a nsoja nyi anebe Filista!>> ");
INSERT INTO eka_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","Devid kpe bahb Jehova, Jehova faange re, <<Song go Keyila, tib m bahke yake anebe Filista kak ega ebo.>> ");
INSERT INTO eka_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Owo Devid a nsoja enye, bo kehm tahme go Keila, song nok a anebe Filista fere wul atohkondi ebo. Devid tane anebe Filista gbalee, tahre anebe Keyila. ");
INSERT INTO eka_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","<<Ngare nyia Abiata mmona Ahimelek rodo nkpehrekahbe ewobo ji nlimanjom ba a ji, eji á be ba tob Devid go Keyila.>> ");
INSERT INTO eka_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","Bo tongo Sol re, <<Devid ebtahm go Keyila, fvfo á kehm bungu re, <<Esowo me-e yake kak-m go egame abo, tibre Devid ebkak elne ngbekobo, eji á song yel ejahbe ji kpi ati mbu akuungu.>> ");
INSERT INTO eka_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Sol kehm lungu nsoja enye kpee re bo tahm ebta go Keyila song kohko Devid tv a aneblum ebe. ");
INSERT INTO eka_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Eji Devid sebe kahn re Sol kpˈlame kak-e, á kehm tongo Abiata ji nlimanjom re, <<Ko nkpehrekahbe ewobo ji nlimanjom ba a ji.>> ");
INSERT INTO eka_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Devid bungu re, <<Jehova Esowo bi anebe Isreel, me nlokeltum ewa ebwuk riirii re, Sol kpꞌtoobo re á ba a Keyila ba rannge ejahbe tib esi ejame. ");
INSERT INTO eka_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Anv afono ejahbe baa ba Keyila, bahk-m jabbe ka-e? Sol bahke lohko ba ana nlokeltum ewa ma wuka? Jehova, Esowo bi anebe Isreel, tong nlokeltum ewa.>> Jehova bungu re, <<Á bahke bake.>> ");
INSERT INTO eka_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","Devid kpe bulu bahb re,<<Anv anebe Keyila bahk-m jabbe a aneblum ebame ka Sola?>> Jehova bungu re, <<Bo bahke limi ano.>> ");
INSERT INTO eka_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Owo Devid a aneblum ebe, bo jolo rehng ane atahltahl ane atahl awubu, bo kehm yake Keyila jo jen yannge adi adi. Eji bo tongo Sol re Devid ebbe go Keyila, á kpeem je o. ");
INSERT INTO eka_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Devid song jolo go elka emahng ni ekobta, a awong nya emahng ji Jif. Efung abehng abehng Sol jo bimi Devid. Wo Esowo tikem yake Devid kak-e abo. ");
INSERT INTO eka_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Ana Devid jolo go ejahbe Horesi go emahng ji Jif, á sebe kahn re Sol eblohng re á song wul-e. ");
INSERT INTO eka_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","Jonatan mmona Sol kehm tahme goji Devid go Horesi song kak-e ebo, á bel atahne goji Esowo. ");
INSERT INTO eka_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","Á tong-e re, <<Ka kpe Fahl.>> <<Nsoo ewame Sol wa-a nehm kunu ebo. Á bahke jolo ntul no anebe Isreel. Me m bahke jolo ekpeele eja. Jol nsoo ewame kpꞌkahne jia.>> ");
INSERT INTO eka_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Bo ane abal abal ko nwongo gbanngalung atemtem. Owo Jonatan kehm feere kehnge, wo Devid sa go Horesi. ");
INSERT INTO eka_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Anebe Jif kehm tahme goji Sol go Gibea song tong-e re, << Nyehne Devid ebsong biiri go egahre ekobta go Horesi, go ewong ji Hakila go ejang eboblum bi Jesimon. ");
INSERT INTO eka_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Anv, ntul Agbal Enya, ba ngare anyehng anyehng nyi lꞌkor-a re wo lim ano, wahr bahke yiimi re wahr yak-e kak-a abo.>> ");
INSERT INTO eka_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Sol faange re, <<Nong Jehova fuul-n.>> go egahne eltiiri ni ḿ ma-m tiiri. ");
INSERT INTO eka_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","Songen, wahn kpe song seb kahn nobnob. Seben kahn edi ji Devid kpo kono eljeke a nne no me-e nyehn o. Bo tong-m re, á kpꞌwake sehng. ");
INSERT INTO eka_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","Seben kahn adi elbiiri enye kpee nya á kpo biiri, wahn feere ba tong-m nobnob. m bahk-e sebe go ndi nyi Juda kpee, a abon ajahbe Juda. ");
INSERT INTO eka_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Owo bo kehm feere go Jif gbo Sol mbang. Devid a aneblum ebe bo jolo elka emahng ni Maon go edamme ji Araba ejang eboblum bi Jesimon. ");
INSERT INTO eka_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","Sol a aneblum ebe kehm tahme song kehme elbimi, eji bo tongo Devid bade ano, á mehle tahm go agburu atal song jol go elka emahng ni Maon. Eji Sol wuku jia, á tahme asongo go elka emahng ni Maon jo kam Devid. ");
INSERT INTO eka_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Sol jo jene asongo go nkpe ewong, Devid a aneblum ebe jol go nkpe ewong nyehka jo foomo re bo be goji Sol. Ana Sol a nsoja enye jo kabbe Devid a aneblum ebe re bo bob bo, ");
INSERT INTO eka_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","ntiingi etib kehm bake goji Sol ba bung re, <<Ba elwaare anebe Filista ebbohngo ga kpꞌnoko ebta a Isreel.>> ");
INSERT INTO eka_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Sol rahke elkame ene, ni á jo kam Devid, feere song re á song kpiri anebe Filista. Owo wahnge bo kpo lung edi jio re, Ekpartal ji Elyaame . ");
INSERT INTO eka_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","Fvfo, Devid tahme edi jio song lene go edi ekobta ji En Gedi. ");
INSERT INTO eka_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Ngare nyi Sol ma feere kehnge eji á jo kam anebe Filista, bo tong-e re <<Devid li go elka emahng ni En Gedi.>> ");
INSERT INTO eka_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Owo Sol kehm rodo, ane atahl alon alon go eltahl a nkpel ewubu,(3,000) ajangkun nya li eko eko go Isreel kpee, lohng a bo jo seb Devid a nsoja enye, kohlo go Akpartal nya Ebulemahng. ");
INSERT INTO eka_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Á kehm bake go edi ellong ejoro mbang mbang, egohng jolo o. Sol yele o re á song re ekv. Devid a aneblum ebe, bo jolo go fee njahm egohng jꞌnehm. ");
INSERT INTO eka_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Nsoja nyi Devid kehm bungu tong Devid re, Aneblum bao bungu re, <<A wo li efung bi Jehova bungu no, eji á bungu tong-a re, <<M bahk-a kake anekv ewa go ega abo, eji a lꞌlim-e ana kor-a no.>> Owo Devid kehm tohngo sehng edi ji bo ki kahn, song kim esꞌsili ekpawobo ji Sol. ");
INSERT INTO eka_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Eji ma jol ano sehng, ntir nyi Devid kehm-e kehme elgbiingi, tib eji á kimi esꞌsili ekpawobo ji Sol. ");
INSERT INTO eka_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Á tongo aneblum ebe re, <<Jehova kꞌtaame re me n lim elkohn ejum ana jia tob nsoo ewame nju, nne no Jehova kak-e akehng go esi, afii kun-e ebo ebame, tibre ye nne no Jehova kak-e akehng go esi wo bob-e etul.>> ");
INSERT INTO eka_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Go alum nyaa Devid sahb rꞌrehke aneblum ebe, á taamem re bo nok a Sol. Sol lohngo egohng jio tahm mbang enye. ");
INSERT INTO eka_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Owo Devid kehm lohngo go egohng jio, kehm lungu Sol, <<Nsoo ntul ewame!>> Eji Sol keebe go njahm, Devid kehm gongo go ndi fere tanne elne, a esamahr ebe go ndi. ");
INSERT INTO eka_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Á bungu tong Sol re, <<Jenji wahnge a kpo wuungu atung, aneblum lꞌbung re, <<Devid jehk kpꞌsiki, re á lim-a ejum? ");
INSERT INTO eka_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Lela wobnyehn go ega amahr antahng ana Jehova ma-a jabbe kak-m egame abo a egohng. Egom jehko nyar-m re me n wul-a, wo n tab-a yake, m bungu re, <<M nehm rod ebo ebame kunu nsoo ewame nju, tibre ye nne no Jehova kak-e akehng go esi wo re á jol ntul. ");
INSERT INTO eka_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Nyehn me nsoo ewame, seenge esˈsili ekpawobo eja ga egame ebo, n kimi esꞌsili ekpawobo eja, wo n wa-a wulem. seenge nyehn re, ejumjum egame ebo wobem ji bahke tibi re me n li ebi go esabe ellimi afii go elnoko. N wa-a ka soodo, wo ga a kp-m bimi re wo ko elkpin ename. ");
INSERT INTO eka_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Nong Jehova lam-r a wahra na, nong Jehova bongo nsoodo nyi a ma-m lim, wo ebo ebame wa-a nehm kooro. ");
INSERT INTO eka_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Ana bo bungu mahne re, <<Goji abalimabibi wo ebi ellimi kpo lohng,” ebo ebame wa-a nehm kooro. ");
INSERT INTO eka_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","<<Nne awoo no ntul no anebe Isreel ma lꞌlohng toon-e? Nne awoo a kpꞌkame toon-e, ekpakv mbva? Ntakpehla? ");
INSERT INTO eka_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Nong Jehova jol nlamalam ewahre fere toobo ka-r. Nong á tir bade nfem enyame fere fili o, nong á bib aname, nong á tahr-m yehke go ega ebo. ");
INSERT INTO eka_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Eji Devid ma bung mal, Sol kehm bahbe re, <<Ellum ena ni oa, Devid mmon ewama?>> Á kehm rabe eling wahre wahre wahre. ");
INSERT INTO eka_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Á kehm bungu re, <<Wo wo ga li etingi nne sehnge me, wo ma-m fili nobnob. Me ma-a bib elfili. ");
INSERT INTO eka_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","A ma-m tong anv anv bade nnoobo nyi a ma lim ka-m, Jehova yak-m kak go ega abo, wo me-e a wulem. ");
INSERT INTO eka_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Nne lꞌsong nyehn nnekv ewe, á kpo yak-e yaka ki-e lim ejuma? Nong Jehova tuur-a nobnob go mbang nyi a ma-m fili lela. ");
INSERT INTO eka_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","N kpꞌkahne re a bahke jolo ntul go etingitingi, etul bi Isreel bahke gbale ega abo. ");
INSERT INTO eka_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Anv, tir tong-m go mbing nyi Jehova re, á nehm wul etꞌtohngo ejame kpee, afii fvvdv mbing enyame go nnahba nsoo.>> ");
INSERT INTO eka_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Ano wo Devid kehm koko nwongo enye a Sol. Owo Sol kehm feere kehnge, wo Devid a aneblum ebe feere go edi ekobta. ");
INSERT INTO eka_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Samuel kehm ba kpo, anebe Isreel kpee lohng ba kono asi ling-e, tete bo kpa-e kak ege etahk ji Rama. /s Devid mehl feere go elka emahng ni Paran ");
INSERT INTO eka_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","Nne awohng jolo go Maon, no bele nsol o Kamel, á gbo afang gbalee. Á bele ebulbaange, atahl alon alon go nkpel ewubu (1,000), ejoro atahl alon alon go eltahl a nkpel ewubu (3,000), bi á jo kpud bo anyar go Kamel. ");
INSERT INTO eka_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","Mbing anye bo jo lung-e re Nabal, mbing nyi nkal ewe Abigail. Abigail bele elkahne, á jolo nnenkal no gbo egbahme, wo nlum ewe jolo ntehne eljina nne, fere bel esabel eljini go nnahb nyi Keleb. ");
INSERT INTO eka_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Eji Devid jolo o elka emahng, á wuku re Nabal kpi ejoro anyar kpud. ");
INSERT INTO eka_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","Owo á kehm tumu njangkun ewubu fere tong bo re, <<Songen goji Nabal go Kamel wahn song kak-e nnyo go egama mbing. ");
INSERT INTO eka_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","Tongen ye re, ˈNlaabe elkpin jol ka-a! Nong nob a na, a anebe etahk eba kpee, tob nob a ejum ajehng ajehng eja kpee! ");
INSERT INTO eka_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","<< ˈAnv me n wuk re ngare nyi bo kpo kpud ejoro anyar nyi a. Eji abaabe ebul eba jolo anahre e bibem bo go elfili ngare kpee nyi bo jolo anahre go Kamel, ejum ebo ajehng ajehng limm ji tane no. ");
INSERT INTO eka_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Bahb alokeltum eba, bo bahk-a tongo. Fvfo nong aneblum ebame fil-a ndon, eji li re, wahr ebba go ngare nyi nno. Titi ka alokeltum eba a Devid mmon ewa ajehng ajehng ji a bahke ma bel ka bo.ˈ << ");
INSERT INTO eka_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Eji aneblum ba Devid rehnge go ji Nabal, bo song tiingi Nabal etib bio go mbing nyi Devid. Bo fere ji sik. ");
INSERT INTO eka_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Nabal faange alokeltum re, <<Nne awoo li Devid jia? Nne awoo li mmona Jese noo?. Alokeltum gbalee kpˈbeke babnde nju ebo sa lela. ");
INSERT INTO eka_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Nˈnan m bahke rodo ngbu a alahb a enyam bi m ma wul re me n ka abakpudu ejoro anyar ka aneblum ba lohngo ba edi ji nne kil kahne? ");
INSERT INTO eka_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Aneblum ba Devid sennge feere. Eji bo rehnge no, bo tooro ellum anehng anehng tong Devid. ");
INSERT INTO eka_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Devid kehm tongo aneblum ebe re, <<Nne awohng awohng gbade ekahngkahng ebe.<< Bo lohko lim, Devid tob gbade bˈbe fvfo. Jolo ejum ane atahltahl ba toono Devid, ane atahl awubu sa jo kpur nsol. ");
INSERT INTO eka_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","Nlokeltum awohng kehm tongo Abigel nkala Nabal re, <<Devid tumu abatiingi etib go elka emahng re bo kak nsoo ewahre nnyo, wo á koo akuk faange bo. ");
INSERT INTO eka_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Fvfo aneblum bao jolo nobnob anahre. Bo wahr bibem elfili, ngare kpee nyi wahr jo lohng je go emahng kohlo bo, ejumjum tikem tan. ");
INSERT INTO eka_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Atv a njul bo jolo ekahme senng-r kak ngare anyehng anyehng nyi e jo kpur ejoro kohlo bo. ");
INSERT INTO eka_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Anv, tir bade wo nyehn ji wo bahke ma lim, tibre ebi ejum tohk nsoo ewahre nju go nnahb, a anebe nlaaga ebe kpee. Á li elkohn ebi nnenlum no nne lꞌkˈbung a ne. ");
INSERT INTO eka_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Abigel soro mehl tvtv. Á rodo ebred atahl awubu, ekpasake amahm ebbal, ejoro elon bi bo ma lam, ebam awoko akohl eblon, abane bane ngbu atahlalon, abred atahlawubu nyi bo ko efig lam, á kpu gbade ebvankang. ");
INSERT INTO eka_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Á kehm tongo alokeltum re, <<Song tahmen; M bahk-n toono njahm.<< Wo Nabal nlum ewe á we-e tongem. ");
INSERT INTO eka_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Ana á kuumu mbvankang song rehng go ewong ji bele akpafuku, nyehn Devid kpꞌbadde abake a aneblum ebe, Abigel song wane bo. ");
INSERT INTO eka_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","Devid kpꞌbungu na re, <<Jolo ejum mbol mbol, eji n jo baabe nsol nne noa go elka emahng re ejum ajehng ajehng eje kꞌtan. Á feer-m ebi go nnoobo nyi n limi no. ");
INSERT INTO eka_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Nong Esowo bib a Devid, sahb sꞌsab, joare efungfu m bahke yake nnenlum awohng jol go elkpin, go ellong ane ba li ba be. ");
INSERT INTO eka_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Eji Abigel nyehne Devid, á soro badde mbvankang elwaare ba gong ka Devid a esamahr ebe go ndi. ");
INSERT INTO eka_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Abigel gbo-e go akpade fere bung re, <<Nong me nlokeltum ewa fil-a ndon nsoo ewame, nong me nlokeltum ewa bung a na, wuk ji nlokeltum ewa yahke bung. ");
INSERT INTO eka_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Titi nsoo ewame, ka wuk ebi nnenlum noo re Nabal. Á li ana mbing enye, mbing enye lohngo re Egboolo, fvfo á kpo lim agboolo nsol. Ana me nlokeltum ewa, n nyehnem aneblum ba wo nsoo ewame tumu no. ");
INSERT INTO eka_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","Wo anv nsoo ewame, ana li go etingitingi, Jehova ye ji li Esowo eba, á li go elkpin, wo tob li go elkpin, eji Jehova ma-a yehke re, wo kꞌsong fad alung, fere yehk-a re wo kꞌbongo go ega ebo antahng, nong anebekv eba, a ane kpee ba kpꞌtiri re bo lim wo nsoo ewame nju ejum, jol ana Nabal. ");
INSERT INTO eka_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Nong ayare nya me nlokeltum ewa ma ko ba ka wo nsoo ewame nju, nong bo ka aneblum ba toon-a no. ");
INSERT INTO eka_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","Titi tahm ka me nlokeltum ewa go ege elsoodo ni á ma lim. Jehova, ye ji li Esowo eba, bahke tiki lim efilane eja lab ka nsoo ewame nju, tibre á kpˈnoko ebta bi Jehova, bo nehm nyehn esabe ellimi anehng anehng go ega ejang go afung nya a li go elkpin. ");
INSERT INTO eka_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Jol tvtv o, eji nne kpꞌsꞌseb re á ko elkpin ena, elkpin ni nsoo ewame nju bob behr go elwo ni elkpin goji Jehova, ye ji li Esowo eba, bahke bulu elkpin ena go ellong ane ba li go elkpin, wo elkpin ni anebekv eba, á bahke gbahbe tub ana eltal ni wob egbasad. ");
INSERT INTO eka_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Ngare nyi Jehova ma lim anoobo nsol biingi ka nsoo ewame nju, nya á nyame no bada ne fere yehk-e re, ye wo bahke fili anebe Isreel, ");
INSERT INTO eka_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","wo nsoo ewame nju, we-e nehm ga kpo esi, go ege a ntir re, alung afade lohngem ejumjum, afi jol re á bongo antahng. Eji Jehova, ye ji li Esowo ebo ma ka nsoo ewame nju efa, buumu me nlokeltum ewa. ");
INSERT INTO eka_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","Devid kehm tongo Abigel re, <<Eltehke jol ka Jehova, Esowo bi anebe Isreel, ye ji ma-a tum lela re wo ba kpir-m. ");
INSERT INTO eka_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Nong elfuulu jol a na go ega nnoobo a ntoobo, a elyehke ni a ma-m yehke re me n kꞌfad alung lela, a elbongo ni n jol koko abo enyame bongo. ");
INSERT INTO eka_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Ki li ano, etingitingi ana Jehova, ye ji li Esowo bi anebe Isreel bi li go elkpin, ye ji ma-m yehke re me n ki-a lim ejum, ki li re wob ba elwaare ba kpir-m, jol nnenlum awohng awohng no li ka Nabal jolem kpe jol go elkpin efungfu lꞌse. ");
INSERT INTO eka_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Owo Devid kehm koko ji á ko go ege ebo re á ba ka-e, fere tong-e re, <<Song kehnge go elkoono, me n wuk alum enya, fere lim ji a bahb-m no.<< ");
INSERT INTO eka_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Eji Abigel feere goji Nabal, Nabal jo limi elkak go etahk ana elkak ntul. Nabal gbale go eyebatahng eji á wo jo buumu. Abigael we-e tongem ejumjum tete efungfu se. ");
INSERT INTO eka_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Efungfu eji Nabal amahm me-e ter, nkal ewe kehm-e tongo nsol nyio kpee, eltim gbo-e, á fere jol are eltal ni. ");
INSERT INTO eka_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Kange ejum nfung ewubu, Jehova rum Nabal tub, á kpo. ");
INSERT INTO eka_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","Eji Devid wuku re Nabal ebkpo, á bungu re, <<Eltehke jol ka Jehova, ye ji ma toobo elam ejame a Nabal, go ebibi elfili edaange nne. Yeb yehke nlokeltum ewe go ebi alimi, fere rod ebi ji Nabal kun-e go esi. Owo Devid tumu ellum tv Abigel, bahb-e re á jol nkal ewe. ");
INSERT INTO eka_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","Alokeltum Devid kehm tahme go Kamel song tong Abigel re, <<Devid wo tum-r re, wahr ba ko-a wo ba jol nkal ewe.<< ");
INSERT INTO eka_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","Á kehm gongo esamahr ebe go ndi kehm bungu re, <<Me nlokeltum ewa wo, me n toobo ebjing re me n lok-a fere ru akpade nya alokeltum ba nsoo ewame nju. ");
INSERT INTO eka_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","Abigel soro foomo tvtv kuumu mbvankang a alokeltum anebkal ebe na alon, bo toono atiingi etib Devid, á song jol nkala Devid. ");
INSERT INTO eka_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","Devid tob ko Ahinoam nnea Jejirel, bo ane abal abal bo jol akal ebe. ");
INSERT INTO eka_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","Wo Sol rodo Mikel mmon ewe, nkala Devid, ka Paltiyel mmona Laisi ye ji lohng go Galim. ");
INSERT INTO eka_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Anebe Jifi kehm jeke goji Sol go Gibea song tong-e re, <<Devid sang ma ba biiri go ewong ji Hakila ji li songo songo wane a Jesimona?<< ");
INSERT INTO eka_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Owo Sol kehm tahme go elka emahng ni Jifi a nsoja nyi anebe Isreel, bo jolo ane atahl alon alon go eltahl a nkpel ewubu (3000) ba bo jake no, re bo song seb Devid. ");
INSERT INTO eka_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","Sol bumu ebehre eje kohlo nkpea mbang go ewong ji Hakila jo seenge Jesimon, wo Devid jolo go elka emahng, eji á nyehne re Sol me-e toono rehng o, ");
INSERT INTO eka_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","á tumu ane ba kpo weele nyehn edi, lohko kahn re, Sol ebsi rꞌrehng o. ");
INSERT INTO eka_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Owo Devid kehm tahme edi ji Sol bo si ebehre. Á nyehne edi ji Sol a Abne mmon a Ner, ye ji jolo ntubesi a nsoja noongo no. Sol noongo go atahng ebehre, nsoja woomo ebehre senng-e kak. ");
INSERT INTO eka_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Devid bahbe Ahimelek nnea Hiti go Abisayi mmona Jerua, ye ji jolo mmonannyehna Joab re, <<Nne awoo bahke jeke aname go abehre goji Sol? Abisayi re, <<Me m bahke jeke.<< ");
INSERT INTO eka_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Owo Devid a Abisayi kehm tahme goji nsoja nyio atv.. Bo nyehne Sol nong no, á ma lal go atahng ebehre, a elkong ene, á jahme kohlo ege esi. Abne a nsoja noongo senng-e kak. ");
INSERT INTO eka_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Abisayi kehm tongo Devid re, <<Lela Esowo ebyake nnekv ewa kak ega ebo, nong me n jahm-e elkong nkpel anyehng bade ndi. N we-e nehm jahm nkpel ebal.<< ");
INSERT INTO eka_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Wo Devid tongo Abisayi re ke-e rannge, nne awoo bahke lake nne no Jehova me-e kak akehng go esi kꞌli ebi? ");
INSERT INTO eka_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Á bungu re, <<Etingitingi ana Jehova li go elkpin, Jehova antahng wo bahk-e rumu, afii ngare enye rehng, á kpo, afi á je ebta song kpo ebta tan. ");
INSERT INTO eka_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Wo Jehova kꞌtaame re, me n lak nne no á me-e kak akehng go esi ebo. Rod elkong a ekpꞌkpuk alahb ji nong kohl-e go esi wahr tahm. ");
INSERT INTO eka_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Owo Devid kehm rodo elkong a ekpˈkpuk alahb ji jolo kohlo ege esi, bo tahm. Nnene nyehnem bo, afi kahn bade, jol nnene nyahmem. Bo kpee jo lꞌlal tibre Jehova wo limi bo re bo sahb lꞌlal ano. ");
INSERT INTO eka_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Devid kehm take tahm ejang behko, song wahr kuumu ero ewong go fee. Ka bo egburu eyake njahm ebal ebal. ");
INSERT INTO eka_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Á kehm lungu nsoja a Abner mmona Ner, <<Abner a me nehm faanga?<< Abner kehm faange re, <<Wo nne awoo no kpi ntul lung?<< ");
INSERT INTO eka_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Devid kehm bungu re, <<Nde, wo nnenlum wo, ano sanga? Nne awoo li ana wo go Isreel? Jenji wahnge a ki kpe baabe nso, ntul ewa? Nne ba o, re á ba rannge nso ntul ewa. ");
INSERT INTO eka_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Ji á ma lim nobem. Etingitingi ana Jehova li go elkpin, kehn anv, wo a ane eba wahn ebkpo, tibre a ma-m baabe nso ntul ewa, ye ji Jehova kak-e akehng go esi. Kpur sennge elna. Gan wo elkong a ekpꞌkpuk alahb ntul ji jolo kohl-e esi li no. ");
INSERT INTO eka_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Sol kehm liingi ellum ni Devid, fere bung re, <<Ellum ena ni oa Devid mmon ewama?<< Devid faange re, <<Ee, nꞌni, nsoo ntul ewame.<< ");
INSERT INTO eka_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","Á kpe budu re, <<Jenji wahnge nsoo ewame kpꞌkame nlokeltum ewe? Jenji m ma lim, elsoodo anii m ma li ebi? ");
INSERT INTO eka_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Anv nsoo ntul ewame, wuungu atung wuk alum nya nlokeltum ewe. Lꞌfere jol re Jehova ma-a tehm tv-m, nong á ko ayare. Lꞌfere jol re ane ba ma lim ano, nong bo bel nkuk goji Jehova. Bo ma-m kam lela yehke go mbake enyame go nsol elehkelkv nyi Jehova, fvfo bung re ˈSong, loko asowo nyako.ˈ ");
INSERT INTO eka_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Anv ka nongo alung emame gbo go ndi njahm ejahbe go fee go esamahr bi Jehova. Ntul no anebe Isreel eblohng kpꞌsebe aroongo ana nne kpi a akpamban bim go awong. ");
INSERT INTO eka_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Owo Sol kehm bungu re, <<Me n lim abiafem. Feere ba Devid mmon ewame. Tibre wob tiiri elkpin ename sahb gbꞌgbal lela, n nehm kpe gaare re me n lim-a ejum. Etingitingi me n lim ana egboolo nne, sahb sꞌsab ellimi rannge. ");
INSERT INTO eka_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","Devid kehm faange re, <<Nyehn elkong ni ntul ga. Nong njangkun anyehng enya ba ko. ");
INSERT INTO eka_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Jehova kpo tuuru nne awohng awohng go ebo ellimi nobnob a ekakesehk ebo. Jehova yak-a kak-m go egame abo lela, wo me n nehm lak nne no Jehova kak-e akehng go esi ebo ebame. ");
INSERT INTO eka_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Etingitingi, ana elkpin ena lub-m no lela, nong elkpin ename tob lub Jehova á tahr-m yehke go afemfem kpee. ");
INSERT INTO eka_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Owo Sol kehm bungu tong Devid re, <<Nong elfuulu jol a na Devid mmon ewame, a bahke limi agburu nsol, etingitingi a bahke sehnge ebta.<< Owo Devid kehm tahme mbang enye, Sol feere kehnge. ");
INSERT INTO eka_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Wo Devid tiri antahng re, <<Efung abehng Sol bahke lohko ba wul-m ege ebo. Ji bahke fuumu re me n lim li re, me n be tahm go ndi nyi anebe Filista. Owo Sol bahk-m rahke elsebe go ndi nyi anebe Isreel, m bahke weele lohng go ege ebo. ");
INSERT INTO eka_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","Owo Devid a aneblum atahl alon alon nkpel atahlara, (600) ba jolo a ne, bo kehm tahme goji Akisi mmona Maok , ye ji jolo ntul no Gati. ");
INSERT INTO eka_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","Devid a aneblum ebe, bo song lene go Gati tob Akisi. Nne awohng awohng bele nnahb nyꞌnye nyi jolo a ne. Devid bele akal abal, Ahinom nnea Jejireel, a Abigel nnea Kamel, ye ji jolo nkalebun no Nabal. ");
INSERT INTO eka_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","Eji bo tongo Sol re, Devid ebbe tahm go Gati, á we-e kpeem jo seb. ");
INSERT INTO eka_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Owo Devid kehm tongo Akisi re, <<Joare m ma-a fili ndon, ka-m edi ji m bahke jolo go mmojahbe fee go nfam nyia. <<Jenji wahnge me nlokeltum ewa bahke lene ejahbe ajehng a ntul ?>> ");
INSERT INTO eka_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Owo efung bio Akisi ka-e Jikilag, edi jia jolo ka atul ba Juda alela sang. ");
INSERT INTO eka_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","Devid lene go ejahbe anebe Filista elya kunu nnyahng eni. ");
INSERT INTO eka_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","Owo Devid a ane ebe, bo kehm tahme song kehme elnoko a anebe Gesu, a anebe Girji, go anebe Amalek. (Bomo mahne mahne ane baa lene edi ndi jio, nyange rehng go Sur a Ijib.) ");
INSERT INTO eka_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","Ngare anyehng anyehng nyi Devid lꞌsong nok a ejahbe ajehng ajehng, á joom yake nnenlum, afii nnenkal re bo jol go elkpin. Wo á jo rodo ejoro, adahmagbudu, ebvankang, akamel a abomo. Fere feere ba tob Akisi. ");
INSERT INTO eka_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","Akisi lꞌbahb re, <<Gan wo a je enok lela?<< Devid jo bungu re, <<E je ebta go ejahbe elka emahng ji li ka et'tohngo ji Juda. Nkpel nyindiki á bung re, e je ebta go ejahbe elka emahng edi ji anebe Jerameel lene no. Nkpel nyindiki á bung re, e je ebta go ejahbe elka emahng ji anebe Ken lene no.\" ");
INSERT INTO eka_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","Á joom tiki yake nnenlum afii nnenkal re bo jol go elkpin, ko bo ba ka Gati, á jo tiri re, <<Bo bahke bungu bade anahre re, ˈJia ji Devid ma lim.ˈ Eljini ene ni o ni á jo kono ellimi go afung kpee nya á lene go edi ndi ji anebe Filista. ");
INSERT INTO eka_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Akisi bumu Devid go etingitingi, fere bung tong elne re, <<Yebjol nne no kpꞌbibi eltim a ane ebe, anebe Isreel, tib ano, á bahke jolo nlokeltum ewame nkahlkahl.<< ");
INSERT INTO eka_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Go afung nyao anebe Filista lungu nsoja ebo ba kono re, bo nok a anebe Isreel. Akisi kehm tongo Devid re, <<Fuumu re wo kahn re, wo a aneblum eba, m bahk-m toono ba ebta. ");
INSERT INTO eka_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Devid bungu re, <<Owo a bahke nyehne antahng ana nlokeltum ewa bahke limi. Akisi faange re, <<Ebnob sehng, m bahk-a limi a jol mbaabe ebjing ewame nkahlkahl.<< ");
INSERT INTO eka_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Ngare nyio Samuel ebkpo, anebe Isreel kpee ba elkv, fere ling-e tete rod-e kpa kak ege ejahbe Rama. Ngare nyio fvfo Sol kame abuku mbu a anebe abi atohko, kpee yehke ndi nyio. ");
INSERT INTO eka_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Anebe Filista kehm ba kono, si ebehre go Sunem. Sol tob lung anebe Isreel kpee bo ba kono tob si ebehre go Gilboa. ");
INSERT INTO eka_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Eji Sol nyehne nsoja nyi anebe Filista, á kehme elfahle, fere jo kꞌkahm go ege eltim. ");
INSERT INTO eka_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Á bahbe Jehova, wo Jehova we-e faangem, jol go nlem afii go elfaange ni bo kpo lung re Urim, afii enyehnamahr. ");
INSERT INTO eka_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Owo Sol kehm tongo ane ba kpo lim eltum a ne re, <<Seben nnenkal no li mbuku elbu, eji n lꞌje song bahb-e. Bo tong-e re, <<Nnenkal awohng noa go Endo. ");
INSERT INTO eka_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Owo Sol kehm yaange nsol ebjing, fere kak nyindiki nyi nne li ki-e ma liingi, atv á ba tahm a aneblum abal song kpiri nnenkal, fvfo á tong-e re, <<Bahb etohko ka-m, wo ko etohko ji nne no ma kpo no m bahk-a tongo. ");
INSERT INTO eka_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Wo nnenkal noo tong-e re, <<Etingitingi, wo kpꞌkahne ji Sol ma lim, yeb kam abuku mbu a anebe abi atohko yehke go ndi nyia. Jenji wahnge a yahke kono ekpoko bade elkpin ename, ji bahk-m wulu. ");
INSERT INTO eka_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Sol kehm tiri tong-e go mbing nyi Jehova re, <<Etingitingi ana Jehova li go elkpin, bo wa-a nehm kak erem go eyaame jia.<< ");
INSERT INTO eka_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Owo nnenkal noo kehm bahbe re, <<Nne awoo m bahk-e koko ba kaa? Sol re, <<Ko Samwel ba a ne.<< ");
INSERT INTO eka_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Eji nnenkal nyehne Samwel, á kehm biingi ege ellum bung tong Sol re, <<Jenji wahnge a ma-m nehm? Wo Sol wo! ");
INSERT INTO eka_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Ntul tong-e re, <<Ka kpe fahl. Jenji a ma nyehn?<< Nnenkal re, <<N nyehne ebi etohko kpꞌlohngo go ndi abake. ");
INSERT INTO eka_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Á kehm bahbe re, <<Á li renan?<< Á re, á li ana ekꞌkula nnenlum, á kake ekpawobo kpꞌlohngo abake. Owo Sol soro kahn re Samwel wo, a gongo go ndi tanne elne, esamahr ebe go ndi. ");
INSERT INTO eka_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Samwel kehm bungu tong Sol re, <<Jenji wahnge a ma-m gbiingi ko-m ba aname. Sol re, <<N li go egburu ejahkjahk.<< Anebe Filista kpꞌnoko aname, Esowo ma-m yake abo. Á me-e kpehme kpe faange, fere jol go enyehnamahr afii go nlem. Owo wahnge n lung-a re, wo tong-m ejum ji m bahke limi.<< ");
INSERT INTO eka_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Samuel kehm bungu re, <<Jenji wahnge a kehm-m bahbe, anv eji Jehova ma-a yake, á ma fere jol nnekv ewa? ");
INSERT INTO eka_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Jehova eblim ji á bungu sehng egame. Jehova ebyare etul yehke go ega abo, faake abi ka nnebjing ewa Devid. ");
INSERT INTO eka_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Tibre a wukem ji Jehova, afii rod erakatahng eje rehng a ji goji anebe Amalek, Jehova eblim jia ka-a lela. ");
INSERT INTO eka_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Jehova bahk-a yake, wo a anebe Isreel kak anebe Filista go abo, behna wo a abon eba ba nlum, ḿ bahke jolo aname. Jehova bahke tob yake nsoja nyi anebe Isreel kak abo nya anebe Filista.<< ");
INSERT INTO eka_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Tvtv o Sol soro gbo tanne go ndi, elfahle gbal-e sehng eji á wuku alum nya Samuel. Eko tan-e tibre ejumjum á liim efung bio kpee a atv mao kpee. ");
INSERT INTO eka_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Eji nnenkal noo baa goji Sol ba nyehn re, á bele elfahle tete, á bungu re, <<Nyehne, me nlokeltum ewa ma-a wuk. N fili elkpin ename egame abo fere lim ji a tong-m no re me n lim. ");
INSERT INTO eka_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Anv titi, wuungu me nlokeltum ewa atung, me n ka-a nsol alehke eji a lꞌli kpe bel eko tahm eja kehnge.<< ");
INSERT INTO eka_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Á ten, fere bung re, <<N nehm li. << Wo aneblum ebe tobo nnenkal, bo gboong-e, á wꞌwuungu bo atung. Á mehle go ndi fere ji go nlaabe eti. ");
INSERT INTO eka_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Nnenkal noo bele njokojoka mmon edahmagbudu o etahk, á soro wul-e tvtv. Á nyahke abe kahm lim ngbu nyi ki kpi ayist. ");
INSERT INTO eka_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Á kehm jehke Sol a aneblum ebe bo li. Atv manehm o bo soro mehl tahm. ");
INSERT INTO eka_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","Anebe Filista kehm lungu nsoja ebo, bo song kono go Afek, nsoja nyi anebe Isreel kono go ekpabingi ji Jejireel. ");
INSERT INTO eka_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Ana atubesi ba anebe Filista jo jen go nlong atahl alon, a atahltahl atahltahl, Devid a aneblum ebe jo jene go njahm toono ntul Akisi. ");
INSERT INTO eka_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Atubesi nsoja nyi anebe Filista bahbe re, <<Anebe Hibru baa mee?<< Akisi faange re, <<Devid sang a ji jolo ntubesi abalimi eltum no Sol ntul no anebe Isreela? Yeb jol aname ebsehng elya, bomo efung bi atahme Sol sa tete rehng anv, n ka nyehn ebi ajehng ajehng go ege. ");
INSERT INTO eka_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Wo atubesi nsoja nyi anebe Filista atahng rake bo tob Akisi, bo kehm bungu re, <<Tum nnenlum noa á feere song go edi ji a tib-e no. Á ki-r toono ba ebta, tohko jol ano á bahke fere sennge kuum-r, ngare nyi ebta kpꞌnoko. Jol ga nob re á feere song tob nde nju ewe, sehnge re á wul aneblum ebahre kiimi bo asi. ");
INSERT INTO eka_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Devid jia sang bo kpo yim ese elbahne ebo bada ne re: << ˈSol ebwul ane atahltahl atahltahl ebe, Devid ebwul ane atahlakuu a nkuuaˈ?<< ");
INSERT INTO eka_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Owo Akisi kehm lungu Devid tong-e re, <<Etingitingi ana Jehova li go elkpin, wob jol nne no bo kpa-a bumu go etingitingi, jol-m koro re wo jol jo lok-m go egama nsoja. Bomo efung bi a ba go egame tete rehng lela, n ka tiki nyehn ebi ajehng ajehng go ega, wo atubesi re bo wa-a ka liingi. ");
INSERT INTO eka_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Anv, feere song go elkoono, ka lim ejum ajehng ajehng ji bahke sabe atubesi anebe Filista. ");
INSERT INTO eka_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","Devid kehm bahbe re, <<Wo anv, jenjii m ma lim? Ebi ajii a ma nyehn ji li bada nlokeltum ewa, bomo efung bi m ba a ega, tete tub anv? Jenji wahnge n lˈkˈsong nok a anebekv ba nso ntul ewame? ");
INSERT INTO eka_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Akisi kehm faange re, <<N kpꞌkahne re wob jol jo lim ji jo nob egame amahr, ana enjel nyi Esowo; Eltim ki-a gbiingi eji ma jol ano, atubesi anebe Filista ebbung re, <Ye nehm toon-r je ebta.> ");
INSERT INTO eka_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Mehl efungfu behre behre wo toono alokeltum nde nju ewa, bo ji toon-a ba, wahn tahm, efungu behre behre ana edi kpꞌlennge na lennge.<< ");
INSERT INTO eka_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Owo Devid a ane ebe, bo kehm tahme efungfu behre behre feere ndi nyi anebe Filista, anebe Filista wahr asongo go Jejireel. ");
INSERT INTO eka_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","Devid a ane ebe feere ba rehng go Jiklag, efung bi biingi nfung era. Wo re bo kehm rehnge o, anebe Amalek ebsong nok ebta go ejang eboblum nfam go elka emahng. Bo song noko a ejahbe Jiklag, fere jahm fi, ");
INSERT INTO eka_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","bo bobo anebkal a nne awohng awohng no jolo o, abonse a anebkul. Bo wulem nne awohng awohng, wo bo kpu bo tahm abo eji bo jo feere kehnge. ");
INSERT INTO eka_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","Eji Devid a ane ebe rehnge go Jiklag, bo song nyehne re agun ebrannge Jiklag, fvfo akal ebo, abon ba nlum, a ba nkal bo bobo bo song kak eju. ");
INSERT INTO eka_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","Owo Devid a ane ebe kehm lingi wahre wahre tete eko tan bo, bo kpeem ma jo ling. ");
INSERT INTO eka_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","Anebe Amalek fvfo tob bobo akal abal ba Devid, Ahinom ji nnea Jejireel, a Abigel ji nkalebun no Nabal ji nnea Kamel. ");
INSERT INTO eka_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","Devid jolo go egburu ntong, tibre bo jo bungu re, bo bahk-e tuubu atal, nne awohng awohng rak-e rehng nnahb eltim, tib esi abon ba nlum a ba nkal. Wo Devid bele atahne goji Jehova ji Esowo ebe. ");
INSERT INTO eka_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","Owo Devid kehm tongo Abiata ji nlimanjom mmon no Ahimelek re, <<Ko nkpehrekahbe ewobo ji nlimanjom ba ka-m. Abiata ko ba ka-e. ");
INSERT INTO eka_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","Devid kehm bahbe Jehova re, <<Anv, me n kam toono ellong abarˈrannge baa, m bahke ma kpiri boa? Jehova faang-e re, <<Kam toono bo, a bahke lohko kpiri bo, fere mal, tahre bo. ");
INSERT INTO eka_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","Devid a ane atahltahl atahlawubu ebe, bo song rehng go edamme ji Beso, edi jio wo egom jehko sa go njahm. ");
INSERT INTO eka_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","Ane atahl awubu gbo ewo, bo maam siiri edamme, wo Devid a ane atahltahl bako, bo soro asi jo kam toono asongo. ");
INSERT INTO eka_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","Bo kehm song nyehn nnea Ijib go ekulugbe ko-e ba a ne goji Devid. Bo ka-e alahb re á wo, fere tob ka-e nsol alehke re á li, ");
INSERT INTO eka_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","bo tob ka-e ebahk abane abane ngbu, nya bo ko afik lim, a abane bane ngbu abal nya bo ko agreb lim. Á li, fere bel eko, tib á ka tiki li nsol, afi wo alahb, go nfung na era, a atv era. ");
INSERT INTO eka_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","Devid bahb-e re, á li ka nne awoo? Gan wo a lohng no? / Á kehm bungu re, <<Me nnea Ijib wo, n li nju nyi nne Amalek. Nsoo ewame nju ma-m tahnge tub eji n jo yam, lela nfung era nyi a. ");
INSERT INTO eka_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","E ba noko a ejang eboblum emahng ji li ka anebe etˈtohngo Kered, edi ji li ka Juda, a ejang ji li ka ane ba etˈtohngo ji eboblum emahng bi li ka etˈtohngo ji Keleb. E fere jahm Jiklag fi. ");
INSERT INTO eka_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","Devid kehm-e bahbe re, <<A bahk-m ma tv song rehng edi ji ellong nsoja nyi ba rannge ejahbe li noa?\" ane ba, ba rannga? Á faange re, <<Tir tong-m go esamahr Esowo re me-e a nehm wul afii yak-m ka nsoo ewame nju, m bahk-a koko tahm goji bo.\" ");
INSERT INTO eka_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","Á tv Devid bo rehng go, ane bao ebyaame kpee yel akpohko ejahbe, kpꞌlehke fere kpꞌwoko jo bahn, tib go agbojok nsol nyi bo ma da go ndi nyi anebe Filista a Juda. ");
INSERT INTO eka_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","Devid noko a bo, bomo elgung ni efung bio, tete elgung ni efung behko, nnene beem lohng, sehngem njangkun atahltahl bo ji kuumu akamel bo ba be for. ");
INSERT INTO eka_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","Devid koo ejum ajehng ajehng ji anebe Amalek rodo no tahm a ji, budu akal ebe na abal. ");
INSERT INTO eka_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","Ejumjum tanem, ajangkun afii anebkul, abon ba nlum afii abon ba nkal, nsol nyi bo da no afii ejum ajehng ajehng ji bo rodo no tahm a ji. Devid koo ejum ajehng ajehng feere aji. ");
INSERT INTO eka_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","Á kpuu ellong ejoro a ellong adamagbudu, ane ebe gbo mbang jo jen abo asongo, go mbuksong nyi atohkondi nyako jo bung re, <<A wo li nsol nyi Devid ma da go ebta.\" ");
INSERT INTO eka_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Owo Devid bo kehm bake ba kpiri aneblum atahl awubu ba gbo ewo, bo ki-e ma kpe toono, bo sa go njahm edamme ji Beso. Bo kehm lohngo ba re bo ba wane Devid a ane ba jolo a ne. Ana Devid a ane ebe kpꞌrehnge o, á bahbe bo ana bo li no. ");
INSERT INTO eka_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","Wo abi ane kpee, kehm bake ba kpiri a abasebe afem go ellong ane ba toono Devid kehme elbungu re, <<Tib eji bo ki-r toono je, e nehm bak bo nsol nyi e song da kehnge a nyi. Limi limi kan, nnenlum awohng awohng bahke ma ko nkal ewe a abon ebe, bo song. ");
INSERT INTO eka_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Devid faange re, <<Eꞌee, abonanee ba nlum, kana lim ano go ejum ji Jehova ma-r kaa, á ma-r kuuru yehke, fere yake ellong ane ni ba nok anahre kak egahre abo. ");
INSERT INTO eka_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Nne awoo bahke wuungu atung go ejum ji wahn kpꞌbungu? M bake nyi nnenlum no sa jo kpur nsol, a nnenlum no je ebta, bahke jolo jangjang. Ane kpee bahke baange jangjang.<< ");
INSERT INTO eka_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Devid bumu limi jia jol ntahm a eljini ka anebe Isreel bomo efung bio tete tub anv. ");
INSERT INTO eka_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Eji Devid rehnge go Jiklag, a tumu nsol nyindiki nyi á da no tv anebkul Juda, bo ji jolo ate ebe, á bungu re, <<A wo li ayare nya lohng go nsol nyi n da goji anebekv ba Jehova.\" ");
INSERT INTO eka_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","Devid tumu tv bo ji jolo go Betel, bo ji jolo Ramoti go ejang emahng eboblum nfam, a Jati. ");
INSERT INTO eka_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","tob tum tv bo ji li Aroe Sifmoti, Estemoa, ");
INSERT INTO eka_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","a Rakal; tv bo ji jolo ajahbe nya anebe Jerameel a anebe Ken; ");
INSERT INTO eka_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","tv bo ji Homa, Bor Asan, Adak, ");
INSERT INTO eka_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","a Hebron, tob tum tv bo ji jolo adi nyako kpee nya ye a ane ebe jo beeme yannge. ");
INSERT INTO eka_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Anebe Filista jo noko a anebe Isreel, anebe Isreel be, egom gbalee bo wulu bo go egburu ewong Gilboa. ");
INSERT INTO eka_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Anebe Filista jo sahb kꞌkam Sol a abon ebe, fvfo bo wulu abon ebe ba nlum, Jonatan, Abinadab a Malki-Sua. ");
INSERT INTO eka_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Ebta fubu toono Sol senng-e kak, ana bo ta elban song bob-e, bo lim-e ejum alung ji sahb gbꞌgbal. ");
INSERT INTO eka_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Sol kehm tongo nne no jo fili nsol ebta enye re, <<Tohng ekahngkahng eba yehke wo jahm-m wul, tohko jol ano anebe Filista baa ba kil jo yehke nrur bahke bake ba wul-m, fere jo suum. Wo nne no jo fili nsol ebta enye menng-e sehng re á lim ano, owo Sol kehm rod ekahngkahng ebe jahm ekpare eje go ndi gbo jahme. ");
INSERT INTO eka_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Eji nfila nsol ebta enye nyehne re Sol ebkpo, ye fvfo tob rodo ekahngkahng ebe jahm ekpare go ndi gbo jahme, tob kpo a ne. ");
INSERT INTO eka_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Go mbang nyˈnehm nyi, Sol a abon ebe na ara, go nne no jo fili nsol ebta enye, a aneblum ebe kpee kpo efung bꞌnehm. ");
INSERT INTO eka_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Eji anebe Isreel ba jolo go edamme a bo ji lene go egbuk aya Jodan jehko nyehne re, nsoja nyi anebe Isreel ebbe, gana Sol a abon ebe ebkpo, bo be tahm ajahbe ebo sa, anebe Filista lohng ba ko ajahbe nyao. ");
INSERT INTO eka_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Njahm efungfu eji anebe Filista lohngo no song kehme akvne feede, re bo yehke nsol go abam akpakv nsoja, bo nyehne Sol a abon ebe na ara ma kpo go egburu ewong ji Gilboa. ");
INSERT INTO eka_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Bo kim-e esi fere yehke nsol ebta, bo tumu atiingi etib tv go ndi nyi anebe Filista re, bo tiingi etib bio go etahk alokelom ebo, tob tiingi ane ebo. ");
INSERT INTO eka_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Bo rodo nsol ebta enye kak go etahk elom ji asowo ebo ji bo kpo lung re Astoreti fere kum ngubjing enye lake go ekahme ji Beti San. ");
INSERT INTO eka_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Eji anebe Jabesi Giled wuku ji anebe Filista ma lim Sol, ");
INSERT INTO eka_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","atahntahn ane ebo kpee jene atv atv rehng Beti San. Bo song fono ngubjing nyi Sol a nya abon ebe go ekahme ji Beti San, Sol a abon ebe, feere go Jabesi, bo ba jahm bo fi. ");
INSERT INTO eka_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Owo bo kehm rodo akahb ebo song kpa kak go nla eti ji bo kpo lung re tamarisi go Jabesi, bo fere bade elbo njal nfung esehma.");
INSERT INTO eka_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Eji Sol ma kpo, Devid kehnge ebta bi á song nok ga anebe Amalek, á kange nfung ebal go Jiklag. ");
INSERT INTO eka_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","Go nfung era, á nyehne nne ma lohng go ellong nsoja nyi Sol ba, no nsol ebjing me-e yare, a ebtohko go esi. Eji á ba goji Devid á gbo noongo go ndi ka Devid ekpunu. ");
INSERT INTO eka_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","Devid kehm-e bahbe re, <<Á lohng gan?>> Á kehm faange re, <<Me m be lohng go ellong nsoja nyio nyi anebe Isreel.>> ");
INSERT INTO eka_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Devid kehm-e bahbe re, <<Jenji ma lim? Tong-m>> Á kehm faange re, <<Ane ebbe go ebta, gbalee bobwul bo. Fvfo Sol a Jonatan mmon ewe bobkpo.>> ");
INSERT INTO eka_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","Owo Devid kehm tongo njangkun nyi ko etib ba tong-e re, <<A limi renan kehm kahne re Sol a Jonatan mmon ewe bobkpo? ");
INSERT INTO eka_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","Njangkun nyio kehm bungu re, <<M ba sebe kahn re n li go ewong ji Gilboa, fvfo n nyehne Sol o, ma gbo yakke go ege elkong, nga amvtv ebta a abaf'fingi ba jo kam-e, me-e kabbe. ");
INSERT INTO eka_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Eji á keebe no nyehn-m, á kehm-m lungu, n kehm faange re, <Nyehn me ga!> ");
INSERT INTO eka_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","Á kehm-m bahbe re, wo nne awoo? N kehm faange re, <<Me nne Amalek wo.>> ");
INSERT INTO eka_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","Owo á kehm-m tongo re, <<Yiimi a kohl-m wo wul-m, n li go emel elkv, wo ga, me n kpeka li go elkpin.> ");
INSERT INTO eka_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","Ano wo n yiimi kohl-e, fere wul-e, tibre n k'kahn re eji bo me-e yehke alok, á nehm kpe kpin. Fvfo n rodo ekpasi etul ji konng-e go esi a ebil ngbakebil nyi woom-e ekv ebo, nya nya m ma ko re me m ba ka nsoo ewame. ");
INSERT INTO eka_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Owo Devid a ane ebe kpee ba li a ne, kehm jabbe abomo ebo, tohng yare. ");
INSERT INTO eka_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Bo ji ndon ndon jo ling, fere bade njal tete elgung ba, tib esi Sol a Jonatan mmon ewe, tob jolo ka nsoja Jehova a anebe Isreel kpee, tibre bob wul bo go ekahngkahng. ");
INSERT INTO eka_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","Devid kehm tongo njangkun nyi ko etib ba a bi re, <<Gan wo a lohng no? Á kehm faange re, <<Me mmona nne ajahmjahm wo, nnea Amalek. ");
INSERT INTO eka_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","Devid kehm bahbe re, <<N'nan ki-a mennge re wo rod ebo eba wul nne no Jehova kak-e akehng go esi?>> ");
INSERT INTO eka_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","Owo Devid kehm lungu nne awohng ewe fere tong-e re, <<Song wul-e, á soro song wul-e. ");
INSERT INTO eka_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","Devid tongo nnenlum noo re, <<Alung ema kuumu wofono antahng ega esi. Nnyo ema ebfvvrv bade a na, eji a bungu re, <Me n wul nne no Jehova kak-e akehng go esi.> >> ");
INSERT INTO eka_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","Devid kehm yimi ese eling jia kak Sol a Jonatan mmon ewe, ");
INSERT INTO eka_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","á ka ejehke re, bo tib anebe Juda eling ese jia, bo nyono kak nwer nyi Jasar ");
INSERT INTO eka_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","Eyee Isreel, egburu nne ano ewahne bo me-e wul go ewong! Eyee nyehn ana egburu nne ma gbo kpo! ");
INSERT INTO eka_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Kana tooro go Gati, kana tiingi go afaka abang nya Askelon, eji abon ba nkal ba anebe Filista l'k'jo geere, eji abon ba nkal ba ane ba kil jo yehke nrur l'k'bel eyebatahng. ");
INSERT INTO eka_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","Wahn awong nya Gilboa, nong ebohng afi elahb k'kpe na ka-n, nong akpak kpak elahb k'kpe na wohngo egahna edi egbe, nya kpo lak nkohl nyi ajom alimi. Tib o wo, bo daange ekum bi etahntahn nne, ekum bi Sol, akehng bo joom kpe taame. ");
INSERT INTO eka_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","Elban ni Jonatan feerem njahm, ekahngkahng bi Sol feerem abo abo, go alung nne no á wulu no, fvfo go ngubjing nyi etahntahn nne. ");
INSERT INTO eka_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","Sol a Jonatan, go ebo elkpin, bo jolo akorokoro fere jol yebe yebe, jol go ebo elkv bo yabem. Bo jo ware sehnge akpi, bo jo tahne sehnge agabe. ");
INSERT INTO eka_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","Abon ba nkal ba Isreel, lingen Sol, ye ji bob-n abomo nya kp'bili, ye ji liib-n akpawobo nya bo kanna agul tohko. ");
INSERT INTO eka_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","Eyee, atahntahn ane ebgbo go ebta, Jonatan bo me-e wul tub egahna awong. ");
INSERT INTO eka_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","Kp-m maange ka-a Jonatan mmonannee, a jo kor-m sehng, elkoro ni a bele aname jolo nkpokosi sehng, jol sahb kp'kpo esi sehnge ni anebkal. ");
INSERT INTO eka_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","Eyee, nyehn ana atahntahn ane ma gbo kpo, nsol ebta ebtan. ");
INSERT INTO eka_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Eji ma kang, Devid kehm bahbe Jehova re, <<M bahke ma tahm song lene go ejahbe Juda ajahnga?>> Jehova re, <<Song me,>> Devid kehm bahbe re, edi ajii? Jehova re, <<Go Hebron.>> ");
INSERT INTO eka_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Owo Devid kehm tahme a akal ebe abal. Bo jo lungu bo re, Ahinoam ji lohng go Jejireel abola Abigail, ye ji jolo nkalebun no Nabal ji Kamel. ");
INSERT INTO eka_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","Devid fvfo tob tahme a aneblum ba jolo a ne, no nne tahme a nnahb enye, bo song lene go abon ajahbe jolo sennge Hebron kak. ");
INSERT INTO eka_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Owo aneblum Juda kehm bake go Hebron, ona wo bo wohngo Devid akehng go esi fere bob-e etul ka et'tohngo ji Juda. Owo bo tongo Devid re aneblum ba lohng go Jabesi Giled ba ma kpa Sol kak, ");
INSERT INTO eka_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","á tumu abatiingetib tv bo fere tong bo re, \"Jehova fuulen eji ḿ ma tib Sol ji jolo ntubesi ewahne nnoobo eljini, go elkake ni ḿ me-e kpa kak. ");
INSERT INTO eka_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","Nong Jehova tiben nnoobo eljini a ekakesehk, me fvfo, m bahke tob tiben ndon ny'nehm tib eji ḿ ma lim jia. ");
INSERT INTO eka_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","Anv, belen atahne, wahn bel esahb, tib Sol ji jolo ntubesi ewahne ebkpo, anebe Juda ma-m bob etul re me n jol ntula bo. ");
INSERT INTO eka_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","Go ngare nyio, Abner mmon no Ner, ye ji jolo ntubesi abanoko ebta no Sol rodo Isiboseti mmon no Sol, ko-e tahm a ne go Mahanam. ");
INSERT INTO eka_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","Á song bob-e etul, á jol ntul no Giled, Asuri a Jejireel, fvfo tob jolo ka Efriim, a anebe Isreel kpee. ");
INSERT INTO eka_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","Isiboseti mmon no Sol kange nnya atahl abal eji á jolo ntul no Isreel, á fili ejahbe go nnya ebal. Et'tohngo ji Juda tiki sa woomo Devid go elwo. ");
INSERT INTO eka_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","Ngare nyi Devid jolo ntul go Hebron ka Juda, á fili edi nnya esehma, kunu nnyahng erakera. ");
INSERT INTO eka_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","Abner mmona Ner, mehle go Mahanam a nsoja nyi Isiboseti ji mmona Sol, fere tahm go Gibion. ");
INSERT INTO eka_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","Joab ji mmona Jeruya a nsoja nyi Devid lohngo song kpiri bo go etolahb ji Gibion. Ellong anehng ji, ejang etolahb jehko, ellong nehko ji ejang jehka. ");
INSERT INTO eka_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","Owo Abner kehm tongo Joab re, <<Nong ajangkun lohng yiimi nok abo abo egahre esamahr.>> Joab re, <<Ebnob nong bo lim ano!>> ");
INSERT INTO eka_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","Owo bo kehm mehle yiimi, bo fange bo yehke, ewubu aneblum abal ba jolo ka Benjamin, a Isiboseti ji mmona Sol, eji Devid jolo ewubu ane abal. ");
INSERT INTO eka_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","No nne tub ntem ejahm go esi, fere jahm-e ekere go ngbaange bo gbo ndi ane abal abal kpo. Tib ano edi jio ji Gibion bo jo lungu re, <<Emang ji akahngkahng.>> ");
INSERT INTO eka_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","Ebta fubu efung bio area, Abner a nsoja nyi Isreel, nsoja nyi Devid g'ga bo. ");
INSERT INTO eka_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","Abon ara ba nlum ba Jeruya jolo o: Joab, Abisayi, a Asahel. Asahel jo sahb b'be ana mbul emahng. ");
INSERT INTO eka_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","Á jo kame Abner, jol á joom gbake je eboblum afi ebobkal, eji á jo kam-e. ");
INSERT INTO eka_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","Abner kehm keebe njahm kehm bahbe re, <<Asahel, wo woa?>> Á faange re <<Ee, me wo.>> ");
INSERT INTO eka_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","Abner kehm-e tongo re, <<Kpur ejang eboblum, afii ejang ebobkal, yehke njangkun anyehng wo taar-e nsol ebta enye. Wo Asahel we-e tikem rahke elkame. ");
INSERT INTO eka_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","Abner kehm kpe rehke Asahel re, <<Rahke, ka-ma kpe kam, jenji wahnge m bahk-a wulu? n l'wul-a, m bahke kpe jo sahb seenge esamahr bi Joab mmonanne renan?>> ");
INSERT INTO eka_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","Wo Asahel we-e tikem rahke elkame, owo Abner kehm jahme Asahel elkong ene go ala bohngo go njahm. Á soro gbo ndi kpo elahbe. Nne awohng awohng no jo sehng jo ba sa yiimi edi jio ji Asahel gbo no kpo. ");
INSERT INTO eka_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","Wo Joab abola Abisayi jo kame Abner, eji njul ma ji egbiri, bo ba rehng go ewong ji Ama, kohlo Gia mbang mbang nyi edi erikendi ji li wum wum. ");
INSERT INTO eka_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","Owo ane ba et'tohngo ji Benjamin kehm kono yiimi njahm nyi Abner, bo ba fadde elbo jol ellong anehng, song sehke ata go ero ewong. ");
INSERT INTO eka_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","Abner kehm rabe lung Joab tong-e re, abohng nyaa ga ekahngkahng bahke sake ano anoa? a nehme kahn re bahke song kohlo go elmaanga? Bahke kange renan a kehm tongo ane eba re bo rahke elkame Isreel ane ebo? ");
INSERT INTO eka_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","Joab kehm faange re, <<Etingitingi, ana Esowo li go elkpin, a kala bung ana, ane baa jol soro asi jo kam bo, tete efungfu se.>> ");
INSERT INTO eka_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","Owo Joab kehm woro ntang, nsoja ebo kpee kehm rahke, bo joom kpe kam anebe Isreel, jol bo joom kpe nok. ");
INSERT INTO eka_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","Atv mao kpee Abner a nsoja enye, jene sehng go edamme ji Araba. Bo siiri aya Judan soro asi tete efungfu se, bo ba rehng Mahanayim. ");
INSERT INTO eka_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","Owo Joab rahke elkame Abner, bo nsoja kpee fere song kono edi ajehng. A l'yehke Asahel bum nkpe, elku ane ani ba Devid, bo kpeem nyehn bo. ");
INSERT INTO eka_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","Wo ane ba Devid wulu, ane atahlku atahlara ba et'tohngo ji Benjamin bo ji jolo ns