﻿USE sofia;
DROP TABLE IF EXISTS sofia.ebk_vpl;
CREATE TABLE ebk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ebk_vpl WRITE;
INSERT INTO ebk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hiyana nan lestaan nan kaap-uwan Jesu Cristo ay kianak David, ya hi David at kianak Abraham. ");
INSERT INTO ebk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Hi Abraham at aman Isaac. Hi Isaac at aman Jacob. Hi Jacob at aman cha Juda ay hen-anag-i. ");
INSERT INTO ebk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Hi Juda at aman cha Fares kan Zara, ya nan enacha at hi Tamar. Hi Fares at aman Esrom. Hi Esrom at aman Aram. ");
INSERT INTO ebk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Hi Aram at aman Aminadab. Hi Aminadab at aman Naason. Hi Naason at aman Salmon. ");
INSERT INTO ebk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Hi Salmon at aman Boaz, ya nan enan Boaz at hi Rahab. Hi Boaz at aman Obed, ya nan enan Obed at hi Ruth. Hi Obed at aman Jesse. ");
INSERT INTO ebk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Hi Jesse at aman Ari David. Hi David at aman Solomon, ya nan enan Solomon at sikud ay asawan Urias. ");
INSERT INTO ebk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Hi Solomon at aman Roboam. Hi Roboam at aman Abias. Hi Abias at aman Asa. ");
INSERT INTO ebk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Hi Asa at aman Josafat. Hi Josafat at aman Joram. Hi Joram at aman Ozias. ");
INSERT INTO ebk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Hi Ozias at aman Joatam. Hi Joatam at aman Acaz. Hi Acaz at aman Ezekias. ");
INSERT INTO ebk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hi Ezekias at aman Manases. Hi Manases at aman Amon. Hi Amon at aman Josias. ");
INSERT INTO ebk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Hi Josias at aman cha Jeconias ay hen-anag-i. Enpototna chicha as nan timpu ay naiyuyan nan chiyuycha kianak Israel ad Babilonia. ");
INSERT INTO ebk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kuncha pay wacha ad Babilonia, enpotot Jeconias hi Salatiel. Hi Salatiel at aman Zorobabel. ");
INSERT INTO ebk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Hi Zorobabel at aman Abiud. Hi Abiud at aman Eliakim. Hi Eliakim at aman Azor. ");
INSERT INTO ebk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Hi Azor at aman Sadoc. Hi Sadoc at aman Akim. Hi Akim at aman Eliud. ");
INSERT INTO ebk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Hi Eliud at aman Eleazar. Hi Eleazar at aman Matan. Hi Matan at aman Jacob. ");
INSERT INTO ebk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Hi Jacob at aman Jose. Hi Jose at asawan Maria ay enan Jesus, ya hi Jesus nan makali un Cristo. ");
INSERT INTO ebk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Isunga, hinpuru ya opat am-in nan kaap-uwan Jesus manipud kan Abraham inkiana kan David. Hinpuru ya opat us ay kaap-uwan manipud kan David inkiana as nan naiyuyan nan chiyuycha kianak Israel ad Babilonia. Wacha us chi hinpuru ya opat ay kaap-uwan manipud as nan naiyuyan nan chiyuycha kianak Israel ad Babilonia inkiana as nan naiyankan Cristo. ");
INSERT INTO ebk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hiyana nan kaap-apatan nan naiyankan Jesu Cristo. Hi Maria ay enana at naetfor kan Jose. Ngem sakbay nunteponcha, naammuwan at ay masikug hi Maria babaen as nan pannakafialin nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kiapú ta nalintig ay taku hi Jose ay asawana, ya achina laychun ay ifiafiain hi Maria as nan sangwanan nan tataku, ninumnumna ay iyichangna hiya ay achi maam-ammuwan nan tataku. ");
INSERT INTO ebk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","As nan chana mangnumnumnuman as na, nunpaila babaen as nan iitawna nan anghel nan Apo. Kenalen nan anghel, “Jose ay kianak David, achika umugyat ay mangetepon kan Maria, tay nan nasikukianana at babaen as nan pannakafialin nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iyanaknantu nan laraki, ya ngadnam as Jesus, tay hiya nan mangesarakantu as nan tatakuna as nan fiasfiasorcha.” ");
INSERT INTO ebk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Enommat am-in chaná ta matongpar nan enpaifiakian Apo Dios as nan usa ay pomapadtu ay kanana, ");
INSERT INTO ebk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Munsikugtu nan usa ay fiarasang ay maid laraki as nakiskissuy kan hiya. Iyanaknantu nan usa ay laraki ay mangadnantu as Immanuel.” (Nan laychun nan Immanuel ay kanan at “Wacha hi Apo Dios kan chitaku.”) ");
INSERT INTO ebk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kun pay finmangun hi Jose, enatna nan infiakian nan anghel nan Apo, at entepona hi Maria. ");
INSERT INTO ebk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngem chaan nakiskissuy kan Maria inkiana inyanakna nan mutun ay laraki. As nan hiyachi, ngenadnan Jose nan mutun as Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Naiyanak hi Jesus henan ili ay Betlehem henan probinsiya ay Judea as nan timpon Ari Herodes. Kun pay chaan nafiayag, wachacha nan inmuy ad Jerusalem ay nurpu henan tukutukún ay luglukiar as apét fomokfoknakian nan urkiw. Chicha nan mamasilib ay lanaraki ay mangad-achar as maepangkep as taraw. ");
INSERT INTO ebk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kuncha pay inumchan hid-i, senarudsudcha, “Ay chaud nan kaiyan-anak ay aren chi Judio? Tay inilami met nan fenmoknakian nan taraw ay sinyar nan naiyankana, at enmali kami ay munchayaw kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kun pay nachamag Ari Herodes nan infiakiacha, nalilifokan hiya as makasolet, ya kaman us as nan am-in ay tataku ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Isunga enpaayagna nan am-in ay ap-apon chi papachi ya mun-isursuru as Lintig, at ensarochakchakna kan chicha mu ay chaud nan maiyankantu nan Cristo. ");
INSERT INTO ebk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tinumforcha kan hiya, “Ad Judea henan ili ay Betlehem, tay hiyana nan insurat nan pomapadtu ay kanana un, ");
INSERT INTO ebk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Chakayu ay tataku ad Betlehem henan lutan Juda, figfikun chakayu henan am-in ay ili ad Juda, tay chakayu nan murpuwan nan usa ay muntoray ay mangaywan as nan tatakok ay kianak Israel.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Angkiay ya enpaayag Herodes nan chiyuycha mamasilib ay lanaraki ay chidchicha yangkiay, at naammuwana kan chicha nan ustu ay uras ay nunpail-an nan taraw. ");
INSERT INTO ebk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kuna pay infiaor chicha ad Betlehem, infilina, “Umuy kayu's chi, ya emamadyu man ay manganap as nan onga. As nan manguchananyu, epakaammuyu kan ha-un ta uyaktu us munchayaw kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Kuncha pay chinngor nan kenalen nan ari, nunligwatcha. As nan chacha manarcharanan, inilacha kasin nan chiyuy taraw ay inilacha as nan kawad-ancha pay laing henan fomokfoknakian nan urkiw. Naragsakancha as solet as nan nangil-ancha as nan taraw. Nan chiyuy taraw at enpanguna chicha inkiana naitungor as nan kawad-an nan onga. ");
INSERT INTO ebk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kuncha pay sinungkop as nan afong ya inilacha nan onga ya hi Maria ay enana, nunpalintumangcha ay nunchaychayaw as nan onga. Tenkafiancha nan nangiittuwancha as nan nunkangina ay ichatcha ay fialetok, insenso ya mirra. ");
INSERT INTO ebk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Angkiay ya as nan kenmatamancha henan lukiarcha, tukún nan inuycha kiapú ta enpaiitaw Apo Dios kan chicha ay achicha munfiangad kan Herodes. ");
INSERT INTO ebk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kun pay nak-ak nan chiyuycha mamasilib ay lanaraki, nunpaila nan anghel nan Apo kan Jose babaen as nan iitawna. Kenalen nan anghel, “Fumangunka. Etakinmu nan hen-ena ya lomayaw kayu ay umuy ad Egipto. Mayaschi kayu inkiana ifiakiak ay mak-ak kayu, tay epaanap Herodes nan onga ta patayuna.” ");
INSERT INTO ebk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hiya at chi ya finmangun hi Jose. Entakina nan hen-ena, ya nunligwatcha ay inmuy ad Egipto as nan hiyachi ay lafi. ");
INSERT INTO ebk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nakiilicha hid-i inkiana natuy hi Herodes. Enommat am-in chaná ta matongpar nan enpaifiakian nan Apo as nan pomapadtu ay kanana, “Enayakiak nan anakku ta mak-ak ad Egipto.” ");
INSERT INTO ebk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kun pay naammuwan Herodes ay insikapan nan chiyuycha mamasilib ay lanaraki hiya, ongor chi fungatna. Isunga infilina ay maepapatuy nan am-in ay lallaraki ay mutun inkiana as nan anongong-a ay muntawwun as chuwa ad Betlehem ya henan am-in ay sakopuna. Enatna na ay maiyunud as nan timpu ay nangammuwana as nan naiyankan nan mutun as nan chiyuycha mamasilib ay lanaraki. ");
INSERT INTO ebk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hiyana nan natongparan nan kenalen Jeremias ay pomapadtu ad pus-uy ay kanana, ");
INSERT INTO ebk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nadngor nan pararu ay tangugngug ya akorcha ad Rama. Cha ag-akiaran Raquel nan an-akna. Achina laychun ay maliwliwa, tay natuycha am-in.” ");
INSERT INTO ebk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kun pay natuy hi Ari Herodes, nunpaila nan anghel nan Apo kan Jose ad Egipto babaen as nan iitawna. ");
INSERT INTO ebk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kenalen nan anghel, “Fumangunka, etakinmu nan hen-ena, ya komatam kayu ad Israel, tay natuycha nan chiyuycha nanglarayad ay mangpatuy as nan onga.” ");
INSERT INTO ebk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","As nan hiyachi, finmangun hi Jose, entakina nan hen-ena, ya kenmatamcha ad Israel. ");
INSERT INTO ebk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ngem kun pay nachamag Jose ay hi Arkelao nan naisubrat kan Herodes ay amana ay muntoray ad Judea, inmugyat hiya ay umuy hid-i. Kiapú ta finag-an Apo Dios hiya babaen as nan iitawna, nunligwatcha ay umuy henan probinsiya ay Galilea. ");
INSERT INTO ebk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Hid-i ad Galilea, inmilicha henan ili ay makali un Nazaret. Enommat na ta matongpar nan kenalen nan chiyuycha pomapadtu un, “Makalintu hiya ay Nazareno.” ");
INSERT INTO ebk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","As nan timpu ay nanagyanan cha Jesus ad Nazaret, uy nun-ekaskasaba hi Juan ay Fumufunyag as nan chiyuycha tataku ay uy nunchungchungor kan hiya henan disyerto ad Judea. ");
INSERT INTO ebk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kenalina kan chicha, “Munfiafiawi kayu as nan fiasfiasoryu, tay kiayud umchan nan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Hi Juan ay anna nan infiakian Isaias ay pomapadtu ad pus-uy ay kanana, “Wacha nan taku henan disyerto ay cha mangifugfukiaw un, ‘Esakianayu nan ayun nan Apo. Munlutkunyu nan ayuna.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nan fiachon Juan at naamma as chotchot chi kamilyu. Nan sinturuna at larat, ya nan kanuna at chuchun ya chilu. ");
INSERT INTO ebk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Uray mu assena hiya, in-inmuy kan hiya nan ongoongor ay tataku ay nurpu ad Jerusalem, henan intiru ay probinsiya ay Judea, ya as nan am-in ay naesasag-un henan wawwang ay Jordan. ");
INSERT INTO ebk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nunfiafiawicha as nan fiasfiasorcha, at finunyakian Juan chicha henan wawwang ay Jordan. ");
INSERT INTO ebk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kun pay inilan Juan nan ongor ay Fariseo ya Saduseo ay cha omali ay munpafunyag, kenalina kan chicha, “Hoy! Chakayu ay kaman an-ak chi kubra! Anan mangali kan chakayu ay malisiyanyu nan omali ay ichusan Apo Dios mu mafunyakian kayu? ");
INSERT INTO ebk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Masapor atunyu nan mangepaila ay tit-iwa ay nunfiafiawi kayu as nan fiasfiasoryu. ");
INSERT INTO ebk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Achiyu kankanan as achoryu un, ‘Achi chakami challu chusaun kan Apo Dios, tay hi Abraham nan kaap-uwanmi.’ Tay ifiakiak kan chakayu ay uray nan nauycha fiatu at mafialin ay munfialinun Apo Dios as kiankianak Abraham! ");
INSERT INTO ebk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nan ichusan Apo Dios at kaman as nan wasay ay naesasakiana ay manipor as kaiw. Am-in ay kaiw ay achi fumkias as ammay at maesalepooncha ay masipor, ya maichus-orcha as nan apuy.” ");
INSERT INTO ebk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Inturuy Juan, “Funyakiak chakayu as chanum ay mangepaila ay nunfiafiawi kayu at. Ngem nan cha umunud kan ha-un at am-amud mu ha-un. Achiyak paat maekari ay mangchun as sapatosna. Hiya nan mangfunyag kan chakayu as Espiritu Santo ya apuy. ");
INSERT INTO ebk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Maepadpachong hiya as nan taku ay nanangchun as ligkia ay osaruna ay manapa as nan finayu. Nan natap-an at ittunantu as nan mangit-ittuwan. Ngem nan chuki at ipuornantu as nan apuy ay achi mapappauy.” ");
INSERT INTO ebk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","As nan timpu ay nunfunfunyakian Juan, inumchan hi Jesus ay nurpu ad Galilea ta uy munpafunyag kan Juan henan wawwang ay Jordan. ");
INSERT INTO ebk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngem penachas Juan ay mamas-iw kan hiya as nan nangaliyana, “Apo, ha-un met koma nan munpafunyag kan he-a. Sungang t'uy he-a nan omali ay munpafunyag kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngem tinumfor hi Jesus, “Ayu at! Atum na ad wani, tay masapor tongparunta nan am-in ay laychun Apo Dios.” Isunga inyafud Juan. ");
INSERT INTO ebk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kun pay nafunyakian hi Jesus, hiya at chi ya tenmakchang hiya as nan chanum. As nan hiyachi, natkafian ad chaya, ya inilana nan Espiriton Apo Dios ay kaman karopati ay cha komsop inkiana penmatang kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Wacha us nan kali ay nurpu ad chaya ay kanana, “Hi tona nan anakku ay laylaychok. Hiya nan mangepalaylayad kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kun pay narpas ay nafunyakian hi Jesus, enpangon nan Espiritu Santo hiya henan disyerto ta chistingun Satanas. ");
INSERT INTO ebk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kun pay inmuy chi opat puru ay urkiw ya lafi ay nun-ay-ayunaran Jesus, nunchukiaang hiya. ");
INSERT INTO ebk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Angkiay ya inmuy hi Satanas kan hiya, ya kanana, “Mu tit-iwa ay anak chaká kan Apo Dios, filinum nan nauycha fiatu ta munfialincha as tenapay.” ");
INSERT INTO ebk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ngem tinumfor hi Jesus, “Nan naisurat as nan Kalen Apo Dios at kanana un, ‘Fiakun yangkiay makan nan pagfiyag nan taku, ngem masaporcha challu nan am-in ay ifiagfiakian Apo Dios.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Angkiay ya inyuy Satanas hi Jesus henan nasantowan ay siyudad, ya enpatakchugna hiya as nan kangatuwan ay parten nan Templo. ");
INSERT INTO ebk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kenalina kan hiya, “Mu tit-iwa ay Anak chaká kan Apo Dios, ud-a pay omagkiangka inkiana as kuwabna, tay kanan met nan naisurat as nan Kalen Apo Dios un, ‘Filinun Apo Dios nan anghelesna ay mangaywan kan he-a. Tatag-uyun chakantu kan chicha as nan limacha ta achi maepakpak nan sukem as nan fiatu.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tinumfor hi Jesus, “Wacha met us nan naisurat as nan Kalen Apo Dios ay kanana un, ‘Achim chischistingun nan Apo ay Diosmu.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kun pay narpas chi, inyuy Satanas hi Jesus henan usa ay nangatungatu ay chuntug. Enpailana kan Jesus nan am-in ay muntorayan asna's luta ya nan kaichayawancha. ");
INSERT INTO ebk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kenalen Satanas, “Ichatkuntu am-in chaná kan he-a mu munpalintumangka ay munchayaw kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ngem tinumfor hi Jesus kan hiya, “Mak-akka Satanas! Nan naisurat met as nan Kalen Apo Dios at kanana un, ‘Chayawum nan Apo ay Diosmu, ya kan hiya yangkiay nan munserfiyam.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Haat taynan Satanas hiya. As nan hiyachi, enmalicha nan angheles ay uy nangfiachang kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kun pay nachamag Jesus ay naifiarud hi Juan ay Fumufunyag, nunfiangad hiya henan probinsiya ay Galilea. ");
INSERT INTO ebk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","As nan kawad-ana henan probinsiya ay Galilea, chaan nakiili ad Nazaret, ngem kun at uy nakiili ad Capernaum. Nan ili ay Capernaum at wacha henan olet nan fiayfiay ay Galilea ya henan lutan us nan chiyuycha kianak Zabulon ya Neftali. ");
INSERT INTO ebk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nakiili hiya ad Capernaum ta matongpar nan kenalen Isaias ay pomapadtu ad pus-uy, ");
INSERT INTO ebk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ad Galilea, henan lutan Zabulon ya henan lutan Neftali as nan charan ay umuy henan fiayfiay, ya chuchumangun nan wawwang ay Jordan, hid-i nan nakiiliyan nan ongoongor ay Gentil. ");
INSERT INTO ebk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nan tataku hid-i at kamancha natataku as nan kawad-an nan ngongot ya as nan kawad-an nan nunkatuy. Ngem ad wani at ilauncha nan narawag ay silaw, tay enmali as nan kawad-ancha nan manilaw as numnumcha.” ");
INSERT INTO ebk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nunlapu as nan hana ay timpu, enlapon Jesus ay nun-ekaskasaba. Kenarkalina, “Munfiafiawi kayu as nan fiasfiasoryu, tay kiayud umchan nan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","As nan usa ay urkiw ay cha manarcharanan Jesus henan olet nan fiayfiay ay Galilea, inilana nan hen-aki ay cha manafukor, tay hiyasa nan chunucha. Chicha cha Simon ay makali us un Pedro, ya hi Andres ay ifiana. ");
INSERT INTO ebk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kenalina kan chicha, “Unuchunak, at isurok chakayu ay munfialin as kaman tomatafukor as tataku.” ");
INSERT INTO ebk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hiya at chi ya tenaynancha nan chiyuycha tafukorcha, ya inmunudcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kuncha pay inturturuy ay manaran, inilan Jesus nan tukún ay hen-aki ay cha Santiago kan Juan ay potot Zebedeo. Nakilurukiancha kan amacha ay hi Zebedeo as nan fiangka, ya chacha esakiana nan tafukorcha. As nan hiyachi, enayakian Jesus chicha. ");
INSERT INTO ebk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hiya at chi ya tenaynancha nan fiangkacha ya hi amacha, ya inmunudcha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nunliklikud hi Jesus henan intiru ay probinsiya ay Galilea. Nun-is-isuru hiya as nan chiyuycha senagogacha, ya enkaskasabana nan Ammay ay Chamag maepangkep henan muntorayan Apo Dios. Kenaana us nan am-in ay karasen chi saketcha ya iliwas chi achorcha. ");
INSERT INTO ebk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Isunga naepachamag nan maepangkep kan hiya henan intiru ay Siria. Nan tataku at inyuycha kan hiya nan am-in ay nunsaket as tukutukún ay saket, nan naparpalikiatan, nan nunkaanennetan, nan nunkorchas ya nan nunkapilay, ya enpaammay Jesus chicha am-in. ");
INSERT INTO ebk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kiapú ta assena, inmunud kan hiya nan ongoongor ay tataku ay nurpu ad Galilea, nan Hinpuru ay Siyudad, Judea, Jerusalem ya henan usa ay chumang nan wawwang ay Jordan. ");
INSERT INTO ebk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","As nan nangil-an Jesus as nan ongoongor ay tataku, tinmikid henan usa ay chuntug. Kuna pay entokor, enmali nan disipulusna kan hiya, ");
INSERT INTO ebk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ya enlapuna ay nun-isuru kan chicha, ");
INSERT INTO ebk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nakiasat nan chiyuycha mamigfig as nan kenakurang chi kafiaelancha ay mangekaman as nan laychun Apo Dios, tay maetapichantu as nan muntorayana. ");
INSERT INTO ebk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Nakiasat nan chiyuycha ngumunguyus kiapú as fiasor, tay liwliwauntu Apo Dios chicha. ");
INSERT INTO ebk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Nakiasat nan chiyuycha napakumbaba, tay tawichunchantu nan luta ay enkaren Apo Dios kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Nakiasat nan chiyuycha kaman cha munchukiaang ya masketan ay chicha nan munlarayad ay mangekaman as nan laychun Apo Dios, tay mapnekchantu. ");
INSERT INTO ebk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Nakiasat nan chiyuycha manug-ang as pachongcha ay taku, tay sug-angantu Apo Dios chicha. ");
INSERT INTO ebk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Nakiasat nan chiyuycha nacharos chi numnumcha, tay ilaunchantu hi Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Nakiasat nan chiyuycha mangepakappia as nan pachongcha ay taku, tay ifilangtu Apo Dios chicha as an-akna. ");
INSERT INTO ebk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Nakiasat nan chiyuycha cha maparpalikiat kiapú as nan chacha mangekamkamanan as nan laychun Apo Dios, tay maetapichantu henan muntorayana. ");
INSERT INTO ebk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nakiasat kayu as nan mangsotan ya mamalikiatan nan tataku kan chakayu, ya ekaliyan chakayu as kumpurmi ay mangotettet kiapú kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kun kayu at munlagragsak ya munlaylayad, tay ongoongor nan gun-gunayu ad chaya. Tay assesa us nan en-enatcha ay namarpalikiat as nan chiyuycha pomapadtu ay enmon-ona mu chakayu.” ");
INSERT INTO ebk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Inturuy Jesus, “Chakayu nan maepachong as nan asin ay para as nan am-in ay tataku asna's luta. Ngem mu chakus at nakaan nan tamtam nan asin, achi poros kasin omasin. Maid at kotokna, kun at maiwagkia ya maikiatkiatin. ");
INSERT INTO ebk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Maepachong kayu as nan silaw ay manilaw as numnum nan tataku asna's luta. Nan siyudad ay wacha henan toktok nan chuntug at achi poros malinglingfian. ");
INSERT INTO ebk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Maid mamaskud as pingki ya op-opana as fianga, ngem kuna at epatang as nan maepatpatngana, at silawan nan pingki nan am-in ay wacha as nan afong. ");
INSERT INTO ebk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Assesa us ay masapor sumilaw kayu as nan mangiilan nan tataku ta mailacha nan ammay ay chayu at-atun, ya ichaychayawcha hi Amayu ad chaya.” ");
INSERT INTO ebk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kenalen pay Jesus, “Achiyu kanan un enmaliyak ay manachael as nan Lintig Moises ya nan insurat nan chiyuycha pomapadtu. Chaanak enmali ay manachael as nan hanacha, ngem kunak at enmali ay mangtongpar as nan laychuncha ay kanan. ");
INSERT INTO ebk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ifiakiak kan chakayu nan tit-iwa. Uray inkiana mamaid nan chaya ya nan luta, achi poros mamaid chi uray tektek winnu kaaptekan ay kali as nan lintig Apo Dios inkiana matongpar nan am-in ay pangkepna. ");
INSERT INTO ebk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Isunga uray ngachana nan achi mangafurot as nan filfilin Apo Dios uray nan chiyuycha kararakaan ay tongparun, ya mangisuru as nan tapina ta ukiayuncha nan hanacha at maifilang hiya as kun lawá apud henan muntorayan Apo Dios. Ngem nan mangafurot as nan lintig ya mangisuru kan chicha ta ekamancha us at maifilang hiya as amud henan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ifiakiak kan chakayu ay mafialin kayu ay maetapi henan muntorayan Apo Dios mu nalinlintig kayu mu nan chiyuycha mun-isursuru as Lintig ya nan chiyuycha Fariseo.” ");
INSERT INTO ebk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Inturuy Jesus, “Chinngoryu ay naifiakia as nan kaap-uwan takú un, ‘Achi kayu pomatuy,’ ya ‘nan pomatuy at maokóm ta machusa.’ ");
INSERT INTO ebk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngem ad wani, ifiakiak kan chakayu ay nan taku ay fumungat as nan pachongna ay taku at maokóm hiya ay machusa. Nan taku ay manginsurtu ay mangali as nan pachongna ay taku un, ‘Maid kotkotokmu!’ at maicharum as nan Sanhedrin. Kaman us as nan taku ay mangali as nan pachongna ay taku un, ‘Natotongokka!’ at maiyuy as nan apuy ad inferno. ");
INSERT INTO ebk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Isunga mu kiayudka mun-ichaton kan Apo Dios as nan altar ya nanumnummu iwa ay wachay finmungtan nan pachongmu ay taku kan he-a, ");
INSERT INTO ebk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","esaadmu nan chatonmu as nan sangwanan nan altar. Uyka on-ona makekappia as nan hana pachongmu ay taku, angkiay munfiangadka ay mun-ichaton kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kamuwum ay makealiglu as nan nangicharum kan he-a sakbay iyuyna chaká as nan lupon. Tay mu achi, ipurang chaká as nan huwis. Angkiay ya nan huwis at ipurang chaká as nan pulis ay mangifiarud kan he-a as pagfiaruchan. ");
INSERT INTO ebk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ifiakiak kan he-a nan tit-iwa ay achikantu makapitiw as pagfiaruchan inkiana fiayacham nan am-in ay mortam.” ");
INSERT INTO ebk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Chinngoryu at ay naifilin ad pus-uy un, ‘Achi kayu umiwet.’ ");
INSERT INTO ebk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngem ad wani, ifiakiak kan chakayu ay nan uray ngachana ay mangetotoong as fiafiai ya ninumnumna ay makissuy kan hiya at inmiwet at hiya as numnumna. ");
INSERT INTO ebk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Isunga mu nan kannawan ay matam nan kiapón chi fumasoram, oketam ya iwagkiam. Un-unuyna ay makurangan nan achormu as usa ay parti mu nan wacha nan intiru ay achormu ay kun challu maichus-or ad inferno. ");
INSERT INTO ebk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mu nan kannawan ay limam nan kiapón chi fumasoram, putnam ya iwagkiam. Un-unuyna ay makurangan nan achormu as usa ay parti mu nan wacha nan intiru ay achormu ay kun challu umuy ad inferno.” ");
INSERT INTO ebk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Naifiakia us ad pus-uy un, ‘Nan ngachana ay laraki ay mangiyichang as asawana at masapor umichat hiya kan asawana as kasuratan ay mangepaila ay nun-ichangcha ay hen-asawa.’ ");
INSERT INTO ebk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngem ad wani, ifiakiak kan chakayu ay nan uray ngachana ay laraki ay mangiyichang as asawana omangkiay mu nakelaraki nan chiyuy asawana at munfialinuna hiya as umiwet mu omasawa hiya as tukún. Kaman us as nan laraki ay mangasawa as nan naiyichang ay fiafiai at umiwet.” ");
INSERT INTO ebk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Chinngoryu ay naifilin as nan kaap-uwan takú un, ‘Achim chukchukkian nan ensapatam as nan Apo, kunmu at masapor tongparun.’ ");
INSERT INTO ebk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ngem ad wani, ifiakiak kan chakayu ay achi kayu poros munsapsapata. Achiyu kankanan un, ‘Ilaum ay chaya,’ tay hiyasa nan tomotokoran Apo Dios ay muntotoray. ");
INSERT INTO ebk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Achiyu us kankanan un, ‘Ilaum ay luta,’ tay hiyana nan kumakiatinana, winnu ‘Ilaum ay Jerusalem,’ tay hiyasa nan siyudad nan nangatu ay Ari. ");
INSERT INTO ebk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nan usa pay at achiyu os-osarun nan uruyu ay munsapata, tay achiyu kafiaelan ay mangepapukaw winnu mangepangutug as uray usa yangkiay ay fook. ");
INSERT INTO ebk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nan kananyu yangkiay at, ‘O,’ winnu ‘Achi.’ Tay nan ngachana nan etapiyu at kan Satanas ay makali un Mangotettet nan nurpuwana.” ");
INSERT INTO ebk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Chinngoryu nan naifilin ad pus-uy ay kanana, ‘Nan mamusling as matan chi usa ay taku at masapor us mafusling hiya. Nan mameng-aw as fiab-an chi usa ay taku at masapor us mapeng-awan hiya.’ ");
INSERT INTO ebk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngem ad wani, ifiakiak kan chakayu ay achiyu es-es-ang nan mangotettet ay enkaman nan pachongyu ay taku kan chakayu. Nan ngachana ngarud ay manepak as nan kannawan ay tamelmu at pay-am ay tepakuna us nan fisakna. ");
INSERT INTO ebk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nan mangicharum kan he-a ta arauna nan kamisitam at pay-am ay arauna us nan chaketmu. ");
INSERT INTO ebk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nan ngachana ay mamelet kan he-a ay manakfiat as uchuna as usa ay kilometro at sakfiatam as uray chuwa ay kilometro. ");
INSERT INTO ebk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nan kumchaw kan he-a at ichatmu nan kuchawuna. Nan manglayad ay fumurud kan he-a at achim achiyun.” ");
INSERT INTO ebk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Chinngoryu nan naifilin ad pus-uy ay kanana, ‘Laylaychum nan kiayyummu, ya inglum nan kafusormu.’ ");
INSERT INTO ebk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngem ad wani, ifiakiak kan chakayu ay laylaychunyu nan chiyuycha kafusoryu ya ekarkararakianyu nan chiyuycha mamarpalikiat kan chakayu ");
INSERT INTO ebk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ta maifilang kayu as an-ak Amayu ay wacha ad chaya. Tay hiya at pasilawuna nan urkiw para as nan mangotettet ya ammay ay tataku. Kaman us as nan uchan at epaalina para as nan chiyuycha mangekamkaman as nalintig ya nan chiyuycha achi nalintig. ");
INSERT INTO ebk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mu nan manglaylayad kan chakayu yangkiay nan laylaychunyu, ay wachay ichat Apo Dios as gun-gunayu? Uray nan chiyuycha mangam-among as fiaror at assesa us nan atuncha. ");
INSERT INTO ebk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mu nan kiakiayyumyu yangkiay nan tagtakiatforunyu, ay wachay natkunanyu as nan tapina? Uray nan chiyuycha Gentil ay achi nangammu kan Apo Dios at assesa us nan atuncha. ");
INSERT INTO ebk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Isunga masapor maid munkuranganyu ta maepachong kayu kan Amayu ad chaya ay maid nunkurangana.” ");
INSERT INTO ebk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Inturuy Jesus, “Il-ilaunyu ta achiyu kurkuratun ay mangepappaila as nan tataku nan ammay ay atunyu ay kaichayawan Apo Dios. Tay mu hiyasa at maidtu gun-gunayu as ichat Amayu ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Isunga as nan umichatanyu as nan chiyuycha makasapor, achiyu iwarwarakiawag as nan chiyuycha senagoga ya as nan chiyuycha charan ay kaman as nan cha at-atun nan pakamankaman ta ichayaw nan tataku chicha. Ifiakiak kan chakayu nan tit-iwa ay enawatcha at nan gun-gunacha. ");
INSERT INTO ebk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngem as nan umichatanyu as nan makasapor, achiyu epakaammu as nan uray kaas-opan ay kiayyumyu ");
INSERT INTO ebk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta maid mangammu. Hi Amayu ay mangil-ila as nan chaan naammuwan ay enatyu at gun-gunaana chakayuntu.” ");
INSERT INTO ebk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kenalen pay Jesus, “As nan munkararakianyu, achiyu koma tadtadnun nan chiyuycha pakamankaman, tay laylaychuncha ay tomakchug ay uy munkararag as nan chiyuycha senagoga ya as nan chiyuycha charan ta fuyfuyaun nan tataku chicha. Ifiakiak kan chakayu nan tit-iwa ay enawatcha at nan gun-gunacha. ");
INSERT INTO ebk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ngem as nan munkararakianyu at sungkop kayu as kuwartuyu, at in-ubyu nan pantiw, ya munkararag kayu kan Amayu ay achi maila. Hi Amayu ay mangiila as nan achi maam-ammuwan ay atunyu at gun-gunaana chakayuntu. ");
INSERT INTO ebk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“As nan munkararakianyu, achiyu ong-ongorun nan maid kotkotokna ay chayu kankanan ay kaman as nan cha at-atun nan chiyuycha Gentil ay achi nangammu kan Apo Dios. Tay ka-anancha un chungrun Apo Dios nan kararagcha mu anchuanchuwuncha. ");
INSERT INTO ebk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Achi kayu koma kaman kan chicha, tay hi Amayu at aammuna challu nan kasaporanyu sakbay ay chumawat kayu kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Assena ngarud nan atunyu ay munkararag: ‘Amami ay wacha ad chaya, maichaychayaw koma nan nasantowan ay ngachanmu. ");
INSERT INTO ebk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Omali koma nan muntorayam. Maekaman koma nan laychum asna's luta ay kaman ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ichatmu koma kan chakami nan kanunmi ad wani ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pakawanum koma chakami as nan fiasfiasormi ay kaman as nan mamakawananmi as nan finmasor kan chakami. ");
INSERT INTO ebk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Achim koma eparufus ay etorokmi ay masulisukian, ngem esarakam chakami as nan Mangotettet.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Inturuy Jesus, “Mu pakawanunyu nan finmasor kan chakayu, pakawanun chakayu us kan Amayu ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngem mu achiyu pakawanun chicha, achi chakayu pakawanun kan Amayu as nan fiasfiasoryu.” ");
INSERT INTO ebk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kenalen pay Jesus, “As nan mun-ayunaranyu, achiyu epappaila ay ngumunguyus kayu ay kaman as nan chiyuycha pakamankaman, tay ennganuycha ay manarcharos as achorcha ta ilaun nan tataku ay kamancha kasusug-ang as nan chacha mun-ay-ayunaran. Ifiakiak kan chakayu nan tit-iwa ay enawatcha at nan gun-gunacha. ");
INSERT INTO ebk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngem as nan mun-ayunaranyu, munchor-op ya munsukud kayu ");
INSERT INTO ebk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta achi madlaw nan tataku ay cha kayu mun-ayunar, ngem kun yangkiay hi Amayu ay achi maila. Hi Amayu ay mangil-ila as nan achi maam-ammuwan ay chayu at-atun at gun-gunaanantu chakayu.” ");
INSERT INTO ebk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Achi kayu mun-ornong as kenafiaknangyu asna's luta. Tay hena at kun challu chachaelun chi ngomengetnget ya lati, ya sungkop pay chi mangaakiw ta akiwuna. ");
INSERT INTO ebk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ngem kun kayu at mun-ornong as kenafiaknangyu ad chaya. Tay hid-i at achi chachaelun chi ngomengetnget ya lati, ya achi pay sungkop chi mangaakiw ta akiwuna. ");
INSERT INTO ebk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tay mu ay chaud nan kawad-an nan kenafiaknangyu at hid-i us nan kawad-an nan numnumyu.” ");
INSERT INTO ebk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nan mata at kaman silaw nan achor. Mu narawag nan umil-an nan matam, nasilawan nan intiru ay achormu. ");
INSERT INTO ebk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ngem mu achi narawag nan umil-an nan matam, ngongottu as solet nan intiru ay achormu. Isunga mu ngongot nan wacha kan he-a, ngongot as solet nan fiyagmu.” ");
INSERT INTO ebk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Maid munserfi as chuwa ay amo, tay iinglunantu nan usa ya laylaychuna nan usa, winnu oononguna nan usa ya elalayusana nan usa. Achiyu mafialin ay munkisanun ay serfiyan hi Apo Dios ya nan siping. ");
INSERT INTO ebk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Isunga ifiakiak kan chakayu ay achi kayu machanakian as maepangkep as pagfiyagyu mu anan kanunyu winnu anan ikopunyu. Achi kayu machanakian as nan maepangkep as nan achoryu mu anan ifiachuyu. Ay achi am-amud nan fiyag mu nan makan, ya nan achor mu nan fiachu? ");
INSERT INTO ebk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilaunyu nan chiyuycha kossel ay cha muntat-ayaw ad chaya. Achicha muntanum winnu mun-ani winnu mun-itupug as arangcha. Uray mu hiyasa, pakanun challu Amayu ad chaya chicha. Ay achi kayu am-amud mu chicha? ");
INSERT INTO ebk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ngachana kan chakayu nan makafiael ay mangepaan-anchu as fiyagna as uray kun usa ay uras kiapú as nan chana munchanchanakian? ");
INSERT INTO ebk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Anuy kayu lawá munchanag as maepangkep as fiachu? Ilaunyu nan sabsafong as uma. Achicha munchunu winnu mun-afor as fiachucha. ");
INSERT INTO ebk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Uray mu hiyasa, ifiakiak kan chakayu ay uray hi Ari Solomon as nan am-in ay kenafiaknangna at chaan poros nunfiachu as maepachong as nan kenaam-ammay nan usa as nan nauycha sabsafong. ");
INSERT INTO ebk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mu fiachuwan Apo Dios nan nauycha lukiam ay wacha as uma ad wani, ya as wiet at mapuoran challu, ay achina chamman kaskasin fiachuwan chakayu? Anuy paat anak-akettuy chi pammatiyu! ");
INSERT INTO ebk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Isunga achi kayu munchanag ay manarudsud un, ‘Anan omor-anmi as kanunmi winnu ikopunmi winnu ifiachumi?’ ");
INSERT INTO ebk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tay chatona am-in nan cha anaanapun nan chiyuycha Gentil ay achi nangammu kan Apo Dios. Hi Amayu ad chaya at ammuna ay masaporyu am-in chaná. ");
INSERT INTO ebk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ngem nan omon-ona ay anapunyu at nan maepangkep as nan muntorayan Apo Dios ya nan mangunuchanyu as nan kenalintigna. Mu hiyasa nan atunyu, ichatnantu am-in chaná ay kasaporan kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Isunga achi kayu machanakian as nan likiat ay omali as wiet. Awni ta as wiet. Tay nan likiat ay omali as nan usa ay urkiw at nawan as nan hana ay urkiw. Achiyu tapiyan.” ");
INSERT INTO ebk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kenalen pay Jesus, “Achiyu okomún nan pachongyu ay taku ta achi chakayuntu okomún kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tay nan atunyu ay mangokóm as nan pachongyu ay taku at assesantu us nan atunyu ay maokóm. Nan panglukudyu as nan pachongyu ay taku at assesantu us nan panglukud Apo Dios kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Adchi t'uymu chillawun nan ek-ektel ay futa as nan matan nan ifiam, ya kunmu at achi madlaw nan ad-acha-an ay futa as nan mismu ay matam? ");
INSERT INTO ebk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Winnu anan mangaliyam as nan ifiam un, ‘Ud-a ta kaanok nan futa as matam,’ mu wachay ad-acha-an ay futa as nan mismu ay matam? ");
INSERT INTO ebk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","He-a ay pakamankaman! Kaanum on-ona nan hana ad-acha-an ay futa as nan mismu ay matam ta makailaka ay ustu. Angkiay ya mafialinmu ay kaanun nan ek-ektel ay futa as nan matan nan ifiam.” ");
INSERT INTO ebk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kenalen Jesus, “Achiyu isuru nan kalen Apo Dios as nan chiyuycha nangossot ay tataku. Tay maepachongcha as nan asu ya fiafuy. Uray mu ichatmu as nan asu nan ammay, omapor challu ay mamangat kan he-a. Kaman us as nan fiafuy ay uray mu ichatmuy perlas kan hiya, kuna challu kiatkiatinan.” ");
INSERT INTO ebk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kenalen pay Jesus, “Achiyu ikinkinak ay chumawat kan Apo Dios as kasaporanyu, at maichattu kan chakayu nan chayu chawchawatun. Achiyu ikinkinak ay mun-anap, at maanapanyuntu nan chayu an-anapun. Achiyu ikinkinak ay munkokkokkok, at tokafiantu Apo Dios nan pantiw para kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tay am-in ay chumawat kan Apo Dios at maettan, nan mun-anap at makaanap, ya nan munkokkok at matkafian nan pantiw para kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ay wacha kan chakayu ay am-a nan mangichat as fiatu mu chumawat nan pototyu as makan? ");
INSERT INTO ebk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Winnu mangichat as urug mu chumawat as kiachiw? ");
INSERT INTO ebk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mu chakayu ay manangotettet at ammuyu ay mangichat as ammay as nan an-akyu, ay achi kaskasin ay ichat Amayu ay wacha ad chaya nan ammay as nan chiyuycha chumawat kan hiya? ");
INSERT INTO ebk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Isunga nan ngachana ay laychum ay atun nan tapina kan he-a, hiyasa nan atum kan chicha. Tay hiyana nan laychun ay kanan nan isursuron nan Lintig Moises ya nan insurat nan chiyuycha pomapadtu.” ");
INSERT INTO ebk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Sungkop kayu as nan nalepet ay pantiw, tay narawa nan pantiw ya naraka nan charan ay muntoróng ad inferno. Isunga ongorcha nan sungkop hid-i. ");
INSERT INTO ebk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ngem nalepet nan pantiw ya nalikiat nan charan ay muntoróng as nan fiyag ay maid patingkiana. Isunga akétcha nan makad-an hid-i.” ");
INSERT INTO ebk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Il-ilaunyu nan chiyuycha achi tit-iwa ay pomapadtu ay omali kan chakayu. Maepachongcha as nan karnero ay naamu, ngem nan kenatit-iwana at maepachongcha as nan atap ay asu. ");
INSERT INTO ebk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nan mangematonanyu kan chicha at as nan chacha at-atun. Ay wachay ubas ay mapuras as nan senagsakiakia, winnu igos ay mapuras as nan loos? ");
INSERT INTO ebk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nan narangtu ay kaiw at ammay chi fukiasna. Ngem nan naiing ay kaiw at mangisiw chi fukiasna, ");
INSERT INTO ebk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","tay achi mafialin ay fumkias nan narangtu ay kaiw as mangisiw, ya achi us mafialin ay fumkias nan naiing ay kaiw as ammay. ");
INSERT INTO ebk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tunggal kaiw ay achi fumkias as ammay at maesalepoon ay masipor ya maichus-or as nan apuy. ");
INSERT INTO ebk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Isunga mafialin ay maematonanyu nan chiyuycha achi tit-iwa ay pomapadtu babaen as nan chacha at-atun.” ");
INSERT INTO ebk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Inturuy Jesus, “Achi am-in ay tataku ay mangali kan ha-un un, ‘Apo, Apo,’ at sungkoptu henan muntorayan Apo Dios, ngem nan chiyuycha yangkiay mangekaman as nan laychun Amak ay wacha ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","As nan umchanantu nan urkiw ay mang-okomán Apo Dios as nan katakutaku, ongorchantu nan tataku ay mangali kan ha-un un, ‘Apo, Apo! Ay kun kami chaan nun-epadpadtu as nan ngachanmu? Ay kun kami chaan nun-epakpak-ak as anennet as nan ngachanmu? Ay kun achi ongor nan en-enatmi ay nakaskaschaaw as nan ngachanmu?’ ");
INSERT INTO ebk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngem kanaktu kan chicha un, ‘Achek poros am-ammu chakayu. Omachawwi kayu kan ha-un, chakayu ay mangekamkaman as mangotettet.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nan am-in ay tataku ay manngor as nan nauycha kalek ya atuncha chaná at maepachongcha as nan masilib ay taku ay nunkiaub as afongna as nan chupras. ");
INSERT INTO ebk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nunmomok, at enmali nan chamuna ay chanum. Pinmuwak as napigsa ya enatifudfuchana nan hana afong, ngem chaan natu-ug, tay as nan chupras nan nasaachana. ");
INSERT INTO ebk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ngem am-in ay tataku ay manngor as nan nauycha kalek ya achicha challu atun chaná at maepachongcha as nan achi masilib ay taku ay nunkiaub as afongna as nan lakian. ");
INSERT INTO ebk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nunmomok ya enmali nan chamuna ay chanum. Pinmuwak as napigsa ya enatifudfuchana nan hana afong, at natu-ug ya nunsidlay enatna ay nachachael.” ");
INSERT INTO ebk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kun pay narpas ay infiakian Jesus chaná, naschaaw nan tataku as nan enatna ay nun-isuru. ");
INSERT INTO ebk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tay as nan nun-is-isuruwana kan chicha, wachay kalibfengana ya achi kaman as nan chiyuycha mun-isursuru as Lintig. ");
INSERT INTO ebk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kun pay chinmayyu hi Jesus ay nurpu henan chuntug, ongoongor chi tataku ay inmunud kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Angkiay ya naesnop kan hiya nan usa ay laraki ay nakonet ya nunpalintumang as nan sangwanan Jesus, ya kanana, “Apo, mu laychum, epaammayak koma.” ");
INSERT INTO ebk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Inchawchaw Jesus nan limana, ya kenpana hiya. Kenalina, “Laychok. Omammayka!” Hiya at chi ya nakaan nan konet nan hana laraki. ");
INSERT INTO ebk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Angkiay ya kenalen Jesus kan hiya, “Maid poros mangifiagfiag-am as kumpurmi as nan enommat kan he-a, ngem kunka at uy munpaila as nan pachi ta ilauna ay nakaan nan saketmu. Kun pay marpas, umichatka as chatonmu kan Apo Dios ay kaman as nan infilin Moises ta mangammuwan nan tataku ay nakaan tit-iwa nan saketmu.” ");
INSERT INTO ebk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","As nan enmaliyan Jesus ad Capernaum, wacha hid-i nan kapetan chi sosorchachu ay Romano ay uy nanib-at kan hiya. Nunpakpakaasi ay chumawat as fiachang kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kenalina, “Apo, cha munsaket nan fiabfiaarok as afong. Cha u-uumfug hiya, tay naparalitiko ya malikiatan as solet.” ");
INSERT INTO ebk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kenalen Jesus kan hiya, “O, uyku epaammay hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngem tinumfor nan kapetan, “Apo, achiyak maekari ay mangepaskop kan he-a as afongku. Uray kunmu ifilin yangkiay at ommat chi ay mangepaammay as nan fiabfiaarok. ");
INSERT INTO ebk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tay uray ha-un at wacha nan nangatngatu ay mangetoray kan ha-un, ya wachacha us nan sosorchachok ay etorayak. Mu kanak as nan usa un, ‘Uyka’ at umuy hiya. Mu kanak us as nan usa un, ‘Aka’ at omali hiya. Mu kanak us as nan fiabfiaarok un, ‘Atum na’ at atuna.” ");
INSERT INTO ebk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kun pay chinngor Jesus na, naschaaw, ya kanana as nan tataku ay cha umun-unud kan hiya, “Ifiakiak kan chakayu nan tit-iwa ay maid poros naanapak as assena ay pammati uray ad Israel. ");
INSERT INTO ebk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ifiakiak kan chakayu ay ongorchantu nan tataku ay Gentil ay murpu henan intiru ay luta ay makekan kan cha chin naaAbraham, naiIsaac, ya najaJacob. ");
INSERT INTO ebk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ngem nan chiyuycha Judio ay maetapi koma henan muntorayan Apo Dios at maichus-orcha as chará henan ngongot. Hid-intu nan mun-ag-akoran nan tataku ya munngesngesatan chi fiab-acha kiapú as fungatcha.” ");
INSERT INTO ebk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Haat kanan Jesus as nan kapetan, “Komatamka, tay nan enafurotmu ay ommat at matongpar.” Hiyachi challu ay uras nan enmammayan nan fiabfiaaruna. ");
INSERT INTO ebk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kun pay sinungkop hi Jesus as afong Pedro, inilana nan katukiangan Pedro ay fiafiai ay inuumfug ay cha munpuchot. ");
INSERT INTO ebk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kenpan Jesus nan limana ya nakaan nan puchotna. As nan hiyachi, finmangun, ya nunsakiana as kanun Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","As nan hiyachi ay naschum, inyalen nan tataku kan Jesus nan ongor ay nunkaanennetan ya nan cha munsaket. Kiapú as nan kalina yangkiay, enpafoknag Jesus nan chiyuycha anennet ya enpaammayna us nan am-in ay cha munsaket. ");
INSERT INTO ebk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Enatna na ta matongpar nan kenalen Isaias ay pomapadtu, “Hiya ay mismu nan nangaan as iliwas chi achor ya saket takú.” ");
INSERT INTO ebk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kun pay inilan Jesus nan ongor ay tataku ay nangarufong kan hiya, infilina as nan disipulusna ay kumchangcha henan fiayfiay ta umuycha ad chumang. ");
INSERT INTO ebk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Angkiay ya naesnop kan Jesus nan usa ay mun-isursuru as Lintig, ya kanana, “Misturu, umunuchak kan he-a uray kumpurmi as ay-ayam.” ");
INSERT INTO ebk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tinumfor hi Jesus kan hiya, “Wachay omafongan nan chiyuycha fuwus, ya wachay somollongan nan chiyuycha kossel, ngem maid ustu as massuyan nan Naepadtu ay Anak chi Taku.” ");
INSERT INTO ebk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kenalen nan usa ay disipulusna kan hiya, “Apo, awni pay ta uyku ilufok on-ona hi amak.” ");
INSERT INTO ebk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngem tinumfor hi Jesus kan hiya, “Umunudka kan ha-un. Pay-am. Kikiad nan chiyuycha maid pammaticha ay maepachong as nan nunkatuy nan uy mangilufok as nan pachongcha ay nunkatuy.” ");
INSERT INTO ebk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Angkiay ya nunlukian hi Jesus as nan fiangka ya nakilukian nan disipulusna. ");
INSERT INTO ebk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kuncha pay wacha as nan fiayfiay, kalina at ya mun-atifudfud chi puwak. Nunsidlay manopsopyatan nan challuyon as nan fiangka, at kiayud lumnud. Kun pay hi Jesus at nanassuy. ");
INSERT INTO ebk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Uycha finangun hiya, ya kanancha, “Apo, esarakam chakami! Lumnud takú pay!” ");
INSERT INTO ebk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kenalen Jesus kan chicha, “Adchi t'uy kayu umugyat? Ak-akettuy tit-iway pammatiyu!” Angkiay ya finmangun hiya ya infilina as nan puwak ya nan challuyon ay kuminakcha. Hiya at chi ya ammay kasin as solet. ");
INSERT INTO ebk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Naschaaw am-in nan disipulusna, ya kanancha, “Ngachan ngun tona t'uy uray angin ya challuyon at tongparunchay filina?” ");
INSERT INTO ebk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Inturuy cha Jesus ay kinumchang inkiana inumchancha henan sasakopun nan i-Gadara. Wachacha nan nanib-at kan hiya ay chuwa ay lanaraki ay nunkaanennetan ay nurpu as nan lurubfok. Kauugyat chaná ay nunkaanennetan. Isunga maid makaiturud ay manguy as nan hana ay charan. ");
INSERT INTO ebk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hiya at chi ya, infukiawcha, “He-a ay Anak Apo Dios, anan ngachana nan laychum ay atun kan chakami? Ay enmalika ay mamalikiat kan chakami uray chaan pay inumchan nan ustu ay timpu?” ");
INSERT INTO ebk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","As nan naesasag-un, wachachay ongoongor ay fiafuy ay cha munsuksukor. ");
INSERT INTO ebk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Enpakaasen nan chiyuycha anennet kan Jesus, “Mu epak-akmu chakami, ifiaormu ngarud chakami as nan chiyuycha fiafuy.” ");
INSERT INTO ebk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Uy kayu,” kenalen Jesus kan chicha. Isunga nak-akcha as nan lanaraki ya inmuycha as nan chiyuycha fiafuy. Angkiay ya kenamon am-in nan fiafuy ay chinmayyu inkiana nag-ascha henan teng-el, at nurningcha. ");
INSERT INTO ebk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nan chiyuycha mangay-aywan as nan chiyuycha fiafuy at tenmagtagcha henan ili, at enpachamagcha nan am-in as nan tataku hid-i patí nan enommat as nan lanaraki ay nunkaanennetan. ");
INSERT INTO ebk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","As nan hiyachi, uy sinib-at am-in nan umili hi Jesus. Kuncha pay inila hiya, nunpakaasicha kan hiya ta mak-ak hiya henan lukiar ay sasakopuncha. ");
INSERT INTO ebk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kun pay narpas chi, nunlukian cha Jesus as nan fiangka, ya kasincha kinumchang henan fiayfiay inkiana nunfiangadcha henan mismu ay ilen Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","As nan hiyachi, wachacha nan nangiyuy kan Jesus as laraki ay paralitiko ay finmafianak as nan ubfukiana. Kun pay inilan Jesus nan pammaticha, kenalina as nan paralitiko, “Anakku, papigsaum nan numnummu. Napakawanka as nan fiasfiasormu.” ");
INSERT INTO ebk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Angkiay ya wachacha nan tapen nan mun-isursuru as Lintig ay cha mangali as numnumcha, “Nakkuran man na ay taku t'uyna epapachong chi achorna kan Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ngem ammon Jesus nan chacha numnumnumun, ya kanana, “Adchi t'uy mangotettet chi chayu numnumnumun? ");
INSERT INTO ebk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ngachana nan narakraka as kanan, ‘Napakawanka as nan fiasfiasormu,’ winnu kanan un, ‘Maligwatka ya manaranka’? ");
INSERT INTO ebk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngem mu hiyasa, atok na ta maammuwanyu ay nan Naepadtu ay Anak chi Taku at wachay kalibfengana asna's luta ay mangpakawan as tataku as nan fiasfiasorcha.” Angkiay ya kenalina as nan paralitiko, “Tomakchugka, araum nan apragmu, ya komatamka.” ");
INSERT INTO ebk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","As nan hiyachi, tenmakchug nan laraki, at kenmatam. ");
INSERT INTO ebk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","As nan nangil-an nan ongor ay tataku as nan enommat, inmugyatcha, ya chinaychayawcha hi Apo Dios ay nangichat as assena ay kalibfengan as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kun pay nak-ak hi Jesus hid-i, as nan chana manarcharanan, inilana nan usa ay laraki ay nan ngachana at Mateo ay nangatokor as nan opisinana ay munfiayfiayachan as fiaror. Kenalen Jesus kan hiya, “Unuchunak.” Nunkaliligwat hi Mateo ya inmunud kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","As nan nangatokoran cha Jesus ay makekan as afong Mateo, ongor chi enmali ay mangam-among as fiaror ya tapina ay fumafiasor, ya nakekancha kan Jesus ya as nan disipulusna. ");
INSERT INTO ebk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kun pay inilan nan chiyuycha Fariseo nan enat cha Jesus, senarudsudcha as nan disipulusna, “Adchi t'uy makiuufong nan misturuyu as nan chiyuycha mangam-among as fiaror ya as nan tapina ay fumafiasor?” ");
INSERT INTO ebk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ngem kun pay chinngor Jesus chi, kenalina, “Nan tataku ay achi munsaket at achicha masapor chi choktor, ngem kun yangkiay nan chiyuycha munsaket. ");
INSERT INTO ebk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Uyyu acharun ay ustu nan laychun ay kanan nan nauy naisurat as nan Kalen Apo Dios ay kanana, ‘Nan manug-anganyu as nan pachongyu ay tataku nan laychok, fiakun nan mun-ichatchatonanyu as animar kan ha-un,’tay chaanak enmali ay mangayag as nan chiyuycha nunkalintig, ngem kun at mangayag as nan chiyuycha fumafiasor.” ");
INSERT INTO ebk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Angkiay ya enmali kan Jesus nan disipulus Juan ay Fumufunyag, ya senarudsudcha kan hiya, “Adchi t'uy chakami ya nan chiyuycha Fariseo at mun-ayunar, ngem nan disipulusmu at achicha?” ");
INSERT INTO ebk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tinumfor hi Jesus kan chicha, “Ay ngumunguyus nan chiyuycha naayakian ay makichuyas uray mu kukutug nan chumuyas ay laraki kan chicha? Achi met! Ngem mu umchantu nan timpu ay maek-akan nan chinmuyas ay laraki kan chicha, hiyachintu nan mun-ayunarancha.” ");
INSERT INTO ebk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kenalen us Jesus ay nangepachong, “Maid mangelakub as fiarú ay lopot as nan lukiak ay fiachu, tay komsun nan naelakub. Angkiay ya makuyud nan lukiak ay fiachu ya kaskasin marakset. ");
INSERT INTO ebk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Maid us mangittu as kasubsufor ay fiayas as nan lukiak ay mangit-ittuwan ay larat. Tay mu atuna chi at fumtak nan larat. Maiwagkia nan fiayas, ya machachael pay nan larat. Ngem kun at maittu nan kasubsufor ay fiayas as nan fiarú ay mangit-ittuwan ay larat ta maid maiwagkia winnu machachael.” ");
INSERT INTO ebk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","As nan cha munkarkaliyan Jesus kan chicha, enmali nan usa ay ap-apon chi Judio kan hiya. Nunpalintumang as nan sangwanana, ya kanana, “Apo, katkatuy nan pototku ay fiafiai. Ngem omalika pay ta epataymu nan limam kan hiya ta kasin mataku.” ");
INSERT INTO ebk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Isunga naligwat hi Jesus, ya inmunud kan hiya. Nakiuycha us nan disipulusna. ");
INSERT INTO ebk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Wacha hid-i nan usa ay fiafiai ay cha mun-ichaichara as hinpuru ya chuwa ay tawwun. Naesnop as uchug Jesus ya kenpana nan kiayachan nan fiachuna, ");
INSERT INTO ebk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","tay kanana as numnumna, “Mu kunku paat kap-un nan fiachuna at omammayak.” ");
INSERT INTO ebk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kun pay nunsakong hi Jesus, inilana hiya, ya kanana kan hiya, “Anak, papigsaum nan numnummu. Nan pammatem nan nangepaammay kan he-a.” Hiya at chi ya enmammay nan chiyuy fiafiai. ");
INSERT INTO ebk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kun pay inumchan hi Jesus as nan afong nan ap-apu, inilana nan munkorkoraling para as nan punpun ya nan naaamong ay tataku ay cha mun-at-atengorngor, ");
INSERT INTO ebk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ya kanana, “Mak-ak kayu hena, tay nan fumarasang at chaan natuy, ngem kun nanassuy.” Kuncha at enam-amrang hiya. ");
INSERT INTO ebk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ngem as nan naepapitiwan nan tataku, sinungkop hi Jesus as nan kawad-an nan fumarasang. Angkiay ya inunnana nan limana, ya nafiannangun nan fumarasang. ");
INSERT INTO ebk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","As nan hiyachi, naepachamag nan nauy ay enat Jesus henan am-in ay sakop nan hana ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nak-ak hi Jesus hid-i, ya as nan chana manarcharanan, inunud nan chuwa ay lanaraki ay nafurag hiya. Chacha ifugfukiaw kan hiya, “Sug-angam man paat chakami, he-a ay Kianak David!” ");
INSERT INTO ebk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kun pay sinungkop hi Jesus as nan afong, nakiskop us nan chiyuycha chuwa ay nafurag. Senarudsud Jesus kan chicha, “Ay afurotunyu ay kafiaelak ay mangaan as nan finuragyu?” “O, Apo,” kenalicha. ");
INSERT INTO ebk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Angkiay kenpan Jesus nan matacha, ya kanana, “Maekaman kan chakayu ay maiyunud as nan pammatiyu.” ");
INSERT INTO ebk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","As nan hiyachi, nakaan nan finuragcha. Angkiay ya infilin Jesus ay ustu kan chicha, “Ilaunyu ta maid mangifiagfiag-anyu's na.” ");
INSERT INTO ebk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ngem as nan nak-akancha's chi, uycha enpachamag nan maepangkep kan Jesus henan am-in ay sakop nan hana ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","As nan cha mak-akan nan chiyuycha nakaan chi finuragcha, inyuy nan tapen nan tataku kan Jesus nan usa ay laraki ay inumor nan anennet. ");
INSERT INTO ebk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kun pay enpafoknag Jesus nan anennet ay wacha as nan umor, nunkali nan laraki. Naschaaw nan naamong ay tataku, ya chacha kanan, “Maid poros inil-ilami as assena hena ad Israel!” ");
INSERT INTO ebk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngem kenalen nan chiyuycha Fariseo, “Mun-epak-ak hiya as anennet kiapú as nan inchat nan ap-apon chi anennet ay pannakafialina.” ");
INSERT INTO ebk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Angkiay ya nunfiabfiaat hi Jesus henan am-in ay ili ya fiabruy. Nun-is-isuru hiya as nan chiyuycha senagogacha, ya enkaskasabana nan Ammay ay Chamag maepangkep henan muntorayan Apo Dios. Kenaana us nan am-in ay tukutukún ay saketcha ya am-in ay tukutukún ay iliwas chi achorcha. ");
INSERT INTO ebk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","As nan nangil-ana as nan ongoongor ay tataku, nasug-ang hiya kan chicha, tay malilifokancha ya maliglikiatancha ay maepachong as nan chiyuycha karnero ay maid mangay-aywan kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kenalina as nan disipulusna, “Ongor chi maani, ngem akét yangkiay chi mun-ani. ");
INSERT INTO ebk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Isunga munkararag kayu as nan nunkuwa as nan maani ta umifiaor as tapina ay mun-ani.” ");
INSERT INTO ebk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","As nan usa ay urkiw, enayakian Jesus nan hinpuru ya chuwa ay disipulusna. Angkiay ya enettana chicha as kalibfengancha ay mun-epak-ak as anennet ya mangaan as am-in ay tukutukún ay saket ya am-in ay tukutukún ay iliwas chi achor. ");
INSERT INTO ebk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nauycha nan ngadngachan nan hinpuru ya chuwa ay apostoles: nan omona at hi Simon ay makali us un Pedro, hi Andres ay sunúdna, nan hen-aki ay cha Santiago kan Juan ay potot Zebedeo, ");
INSERT INTO ebk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","hi Felipe, hi Bartolome, hi Tomas, hi Mateo ay mangam-among as fiaror, hi Santiago ay potot Alfeo, hi Tadeo, ");
INSERT INTO ebk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","hi Simon ay makali un mangesasaket as nasyona, ya hi Judas Iscariote ay mangesepseptu kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Infiaor Jesus nan nauycha hinpuru ya chuwa, ya infilina kan chicha, “Achi kayu poros um-umuy henan sasakopun nan chiyuycha Gentil ya achi kayu poros um-umuy henan il-ilen chi i-Samaria. ");
INSERT INTO ebk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ngem kun at nan umuyanyu at henan sasakopun nan iib-a takú ay kianak Israel ay maepachong as nan nalitaw ay karnero. ");
INSERT INTO ebk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","As nan am-in ay ay-ayanyu, ekasabayu ay kiayud umchan nan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Epaammayyu nan munsaket, takuwunyu nan natuy, epaammayyu nan nakonet ya epafoknagyu nan chiyuycha anennet as nan naanennetan. Achiyu aw-awatun chi fiayad, tay maid poros infiayadyu as nan nauy kalibfengan ay inchatku kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Achi kayu ometakin as siping ay fialetok, silver winnu kianfiang. ");
INSERT INTO ebk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Achi kayu us ometakin as samfiag winnu fiachu ay munsokatanyu, sapatos winnu surkud. Tay nan munchunu at libfengna ay maettan as pagfiyagna. ");
INSERT INTO ebk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“As nan umchananyu henan uray ngachana ay ili winnu fiabruy, anapunyu nan manglayad ay mangmangili kan chakayu. Hid-i nan magyananyu inkiana mak-ak kayu. ");
INSERT INTO ebk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","As nan sungkopanyu as nan hana ay afong, kananyu un, ‘Bendisyonan chakayu koma kan Apo Dios.’ ");
INSERT INTO ebk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mu laychuncha ay awatun nan infiakiayu kan chicha, mabendisyonancha. Ngem mu achicha awatun, achicha mabendisyonan. ");
INSERT INTO ebk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mu maid poros mangmangili kan chakayu winnu chumngor kan chakayu, pokpokanyu nan tapok as nan chapanyu as nan mak-akanyu hid-i ay afong winnu ili. ");
INSERT INTO ebk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ifiakiak kan chakayu nan tit-iwa ay as nan urkiw ay mang-okomán Apo Dios as nan katakutaku, narakrakantu nan chusan nan i-Sodoma ya i-Gomorramu nan umiili hesa.” ");
INSERT INTO ebk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kenalen pay Jesus, “Chumngor kayu! Ifiaorku chakayu ay maepachong as nan naamu ay karnero as nan kawad-an nan chiyuycha kauugyat ay atap ay asu. Isunga masapor masilib kayu ay kaman as nan urug ya naamu kayu ay kaman as nan karopati. ");
INSERT INTO ebk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Il-ilaunyu, tay wachachantu nan mangtiliw ya mangiyuy kan chakayu as nan chiyuycha lupon. Masaplesaplet kayuntu as nan chiyuycha senagogacha. ");
INSERT INTO ebk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Maicharum kayuntu as nan gogobernador ya ar-ari kiapú kan ha-un. Hiyasa nan chansayu ay mangepaneknektu as nan maepangkep as nan Ammay ay Chamag kan chicha ya as nan chiyuycha Gentil. ");
INSERT INTO ebk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kun chakayu pay icharum, achi kayu machanakian mu anan atunyu ay mangifiakia winnu ngachana nan kananyu. Tay nan kananyu at maepakaammuntu kan chakayu as nan hana ay uras, ");
INSERT INTO ebk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","tay fiakun chakayu nan munkali, ngem kun at nan Espiriton Apo Dios ay Amayu babaen kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“As nan hiyasa ay timpu, wacha nan mangepapatuytu as mismu ay sunúdna ay laraki. Assesantu us nan atun nan ama as nan pototna. Nan an-ak us at kontraunchantu nan chanakchakorcha ya epapatuycha chicha. ");
INSERT INTO ebk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Inglun chakayuntu as nan am-in ay tataku kiapú as nan pammatiyu kan ha-un. Ngem nan taku ay mangan-anos ay omafurot kan ha-un inkiana as nan anongos at maesarakantu. ");
INSERT INTO ebk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kun chakayu pay palikiatun henan usa ay ili, lomayaw kayu ay umuy henan tukún. Ifiakiak kan chakayu nan tit-iwa ay achiyuntu lopasun nan enpadnok kan chakayu henan kailiili ad Israel sakbay ay munfiangad nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Maid uswila as nangatngatu mu nan misturuna, winnu mafiabfiaor as nangatngatu mu nan amona. ");
INSERT INTO ebk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mapnek nan uswila as nan komamanana as nan misturuna, ya kaman us as nan mafiabfiaor as nan komamanana as nan amona. Mu penangadnan nan tataku nan ap-apu as nan pamilya as Beelzebub ay ap-apon chi anennet, ay achi at kaskasin mangotettet nan epangachancha kan chakayu ay kun membro as nan pamilyana?” ");
INSERT INTO ebk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Isunga achi kayu umug-ugyat as nan tataku, tay maid naililingub ay achintu maepaila, winnu naetatafun ay achintu maammuwan. ");
INSERT INTO ebk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nan chak ifiagfiakia kan chakayu as nan lafi at ifiakiayu as nan kaorkia. Nan naitubtufu kan chakayu at ifukiawyu as nan kaongoran chi tataku. ");
INSERT INTO ebk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Achi kayu umugyat as nan chiyuycha mangpatuy as achor ngem achi makafiael ay mangpatuy as lenawa. Kun at nan umugyatanyu at kan Apo Dios ay makafiael ay manachael as achor ya lenawa ad inferno. ");
INSERT INTO ebk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ilaunyu nan chiyuycha tulin. Ay achi nan chuwa at maelaku as kun lawá peso? Maelaku met! Uray akét nan fiarorcha at maid challu matuy uray usa kan chicha mu achi eparufus Amayu. ");
INSERT INTO ebk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kaskasin kan chakayu! Uray nan fook as uruyu at nafifilangcha am-in. ");
INSERT INTO ebk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Isunga achi kayu umug-ugyat, tay nafiarfiaror kayu mu nan ongor ay tulin.” ");
INSERT INTO ebk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Isunga nan ngachana ay mangipudnu as nan sangwanan nan tataku ay hiya at omafurot kan ha-un, assesantu us ay ipudnoktu nan maepangkep kan hiya as nan sangwanan Amak ay wacha ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ngem nan mangesaot kan ha-un as nan sangwanan nan tataku at esaotku us hiya as nan sangwanan Amak ay wacha ad chaya.” ");
INSERT INTO ebk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kenalen pay Jesus, “Achiyu kanan un enmaliyak ay mangiyali as talna asna's luta. Enmaliyak ay maepachong as nan espada ay mangsisiyan as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","O, enmaliyak ay munlumu as mangontraan nan anak ay laraki kan amana, nan anak ay fiafiai kan enana ya nan enapu ay fiafiai kan katukiangana ay fiafiai. ");
INSERT INTO ebk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nan kafusor nan usa ay taku at nan mismu ay pamilyana. ");
INSERT INTO ebk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nan taku ay ong-ongor nan layadna kan amana winnu kan enana mu nan layadna kan ha-un at achi maekari as ok disipulu. Uray nan taku ay ong-ongor nan layadna as anakna mu nan layadna kan ha-un at achi maekari as ok disipulu. ");
INSERT INTO ebk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nan taku ay achi mangitiin as korosna ya umunud kan ha-un at achi maekari as ok disipulu. ");
INSERT INTO ebk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nan taku ay mangaayyiw as fiyagna asna's luta at malitawnantu challu. Nan taku ay manglitaw as fiyagna asna's luta kiapú as pammatina kan ha-un at mawad-an as fiyag ay maid patingkiana.” ");
INSERT INTO ebk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nan taku ay mang-awat kan chakayu at ha-un nan awatuna, ya nan mang-awat kan ha-un at awatuna nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nan taku ay mang-awat as pomapadtu kiapú ta pomapadtu hiya at magun-gunaan hiya as pachong nan gun-gunan chi pomapadtu. Nan taku us ay mang-awat as nan nalintig ay taku kiapú ta nalintig hiya at magun-gunaan hiya as pachong nan gun-gunan chi nalintig ay taku. ");
INSERT INTO ebk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ifiakiak kan chakayu nan tit-iwa ay mu ngachana nan taku ay mangepaikop as uray hentasa ay tungnin ay chanum as nan nauycha apud ay tataku kiapú ta usa hiya ay disipulok at maawatna nan gun-gunana.” ");
INSERT INTO ebk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kun pay narpas ay infilin Jesus chaná as nan hinpuru ya chuwa ay disipulusna, nak-ak hid-i, ya uy nun-is-isuru ya nun-ekaskasaba henan naesasag-un ay il-ili hid-i. ");
INSERT INTO ebk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","As nan hiyachi ay timpu, naifiafiarud hi Juan. Kuna pay nachamag nan cha atuatun Cristo, inmifiaor as nan tapen nan disipulusna, ");
INSERT INTO ebk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","at senarudsudcha kan hiya, “Ay he-a nan enkaren Apo Dios ay omalintu, winnu munsuud kami as tukún?” ");
INSERT INTO ebk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tinumfor hi Jesus kan chicha, “Munfiangad kayu kan Juan, ya ifiakiayu kan hiya nan chayu il-ilaun ya chungchungrun. ");
INSERT INTO ebk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nan chiyuycha nafurag at makailacha, nan chiyuycha nunkapilud at makacharancha, nan chiyuycha nakonet at enmammaycha, nan chiyuycha nalurak at makadngorcha, nan chiyuycha natuy at natakucha manipud as nan utúy, ya nan chiyuycha pugli at naekasaba kan chicha nan Ammay ay Chamag. ");
INSERT INTO ebk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nakiasat nan taku ay achi munchuwachuwa as nan maepangkep kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kun pay nak-ak nan disipulus Juan, enlapon Jesus ay mangifiakia as nan maepangkep kan Juan as nan ongoongor ay tataku, “As nan enayanyu kan Juan henan disyerto, ngachana nan nenamnamayu ay ilaun koma? Ay usa'y taku ay maepachong as nan tufú ay cha ikiwkiwen chi angin? ");
INSERT INTO ebk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ngachana ngarud nan uyyu inila hid-i? Ay usa ay taku ay nunfiafiachu as am-ammay? Nan chiyuycha met munfiafiachu as am-ammay at mamagyancha as nan chiyuycha palasyu. ");
INSERT INTO ebk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ngachana ngay ngarud nan enay-ayanyu's chi? Ay uyyu inila nan usa ay pomapadtu? O, ifiakiak kan chakayu, inilayu nan am-amud mu nan pomapadtu. ");
INSERT INTO ebk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tay hi Juan nan naifiakia as nan Kalen Apo Dios ay kanana un, ‘Wacha nan ifiaorku ay mangon-ona mu he-a ay mangesakiana as nan ayum.’ ");
INSERT INTO ebk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ifiakiak kan chakayu nan tit-iwa ay as nan am-in ay naiyanak at maid am-amud mu hi Juan ay Fumufunyag. Ngem nan kaapuchan henan muntorayan Apo Dios at am-amud mu hi Juan. ");
INSERT INTO ebk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nunlapu as nan nun-ekaskasabaan Juan inkiana ad wani, wachacha nan mangepapati ay mangekasaba as nan maepangkep henan muntorayan Apo Dios, ya wachacha us nan mangepelet ay maetapi henan muntorayana. ");
INSERT INTO ebk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tay nan insursurat nan chiyuycha pomapadtu ya nan Lintig Moises at enpadtucha am-in nan maepangkep henan muntorayan Apo Dios inkiana enmali hi Juan. ");
INSERT INTO ebk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mu laraychunyu ay afurotun chachi at maawatanyu ay hi Juan at hiya nan Elias ay naepadtu ay omali kasin. ");
INSERT INTO ebk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nan wachay ingana ay chumngor at masapor chumngor.” ");
INSERT INTO ebk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kenalen pay Jesus, “Anan mangepachongak ngun kan chatona ay tataku ad wani? Maepachongcha as nan ongong-a ay nangatokor as nan lenawwag ay cha munfifinnukiaw as nan kaay-ayamcha ay cha mangarkali un, ");
INSERT INTO ebk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nun-epeep kami, ya chaan kayu nunsasara. Nunkanta kami as omepanguyus, ya chaan kayu nginmuyus.’ ");
INSERT INTO ebk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chakayu nan maepachongancha, tay enmali hi Juan, ya cha mun-ay-ayunar ya achi cha umig-ikop as fiayas, ya kanancha at un, ‘Naanennetan hiya!’ ");
INSERT INTO ebk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kun pay enmali nan Naepadtu ay Anak chi Taku ay cha makekkekan ya cha makiig-ikop, ya kanancha un, ‘Ilaunyu kay na ay taku at kun naranok ya futtang. Hiya us at kiayyum nan chiyuycha mangam-among as fiaror ya nan tapina ay fumafiasor.’ Uray mu assesa, maepaila challu ay ustu nan kenasilib Apo Dios as nan cha atuatun nan chiyuycha omaafurot.” ");
INSERT INTO ebk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Angkiay ya senengaran Jesus nan umili henan il-ili ay nangekamanana as nan kaongoran ay nakaskaschaaw, tay chaancha nunfiafiawi as nan fiasfiasorcha. ");
INSERT INTO ebk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kenalina, “Kasusug-ang kayu ay i-Corazin ya i-Betsaida! Tay mu ad Tiro ya ad Sidon nan nangekamanak as nan hanacha amud ay nakaskaschaaw ay enkamkamanku kan chakayu, nunfiafiawicha at koma ay nangafiachu as saku ya nachachapor. ");
INSERT INTO ebk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngem ifiakiak kan chakayu ay as nan urkiw ay mang-okomán Apo Dios as nan katakutaku, narakrakantu nan chusan nan chiyuycha i-Tiro ya i-Sidon mu nan chusayu. ");
INSERT INTO ebk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Chakayu ngay ay i-Capernaum, ay kananyu un maichayaw kayu ad chaya? Achi! Awni at kun kayu maichus-or ad inferno. Tay mu enkamkamanku nan hanacha amud ay nakaskaschaaw ad Sodoma ay enkamkamanku henan iliyu at nunfiafiawicha as nan fiasfiasorcha ya kukutug nan ilicha. ");
INSERT INTO ebk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngem ifiakiak kan chakayu ay as nan urkiw ay mang-okomán Apo Dios as nan katakutaku at narakrakantu nan chusan nan chiyuycha i-Sodoma mu nan chusayu.” ");
INSERT INTO ebk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","As nan hiyachi ay timpu, enkararag Jesus, “Ama ay Apo ad chaya ya asna's luta, munyamanak kan he-a, tay enpakaammom as nan chiyuycha chaan nakaachar nan nauycha entatafunmu as nan chiyuycha mamasilib ya nakaachar. ");
INSERT INTO ebk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O, Ama, enatmu na, tay hiyana nan mangepalaylayad kan he-a. ");
INSERT INTO ebk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Nan am-in at entalek Ama kan ha-un. Maid nangammu as nan Anak omangkiay nan Ama. Assesa us ay maid nangammu as nan Ama omangkiay nan Anak ya nan piliyun nan Anak ay mangepakaammuwana. ");
INSERT INTO ebk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Akayu kan ha-un, chakayu am-in ay kaman nabray ay manasakfiat as chagsun ta mun-iblayok chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Unuchunyu nan sursurok ya munsuru kayu kan ha-un, tay naanosak ya napakumbabaak. Mu hiyasa nan atunyu, natalnantu nan numnumyu. ");
INSERT INTO ebk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tay nan sursurok ay ichatku kan chakayu at naraka ay masuru, ya nan epasakfiatku kan chakayu at achi chagsun.” ");
INSERT INTO ebk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","As nan usa ay Urkiw ay Mun-iblayan, nanarcharan cha Jesus as nan chiyuycha uma ay natanman as trigo. Nunchukiaang nan disipulusna, isunga enlapucha ay nunsaw-i ya chacha munkutkutim as kanuncha. ");
INSERT INTO ebk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ngem kun pay inilan nan chiyuycha Fariseo nan enatcha, kenalicha kan Jesus, “Ilaum kay ya at cha atun nan disipulusmu nan epawan nan Lintig takú as nan Urkiw ay Mun-iblayan.” ");
INSERT INTO ebk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tinumfor hi Jesus kan chicha, “Ay chaanyu finasfiasa nan enat Ari David ya nan kakadwana as nan nunchukiaangancha? ");
INSERT INTO ebk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sinungkop hi David as nan munchaychayawan kan Apo Dios, at kenana nan tenapay ay naichaton kan Apo Dios. Maiyunud as nan Lintig, achi mafialin hiya ya nan kakadwana ay mangan. Kun yangkiay nan papachi nan mafialin ay mangan. ");
INSERT INTO ebk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Winnu, ay chaanyu us finasfiasa as nan Lintig Moises ay nan papachi ay cha mun-ichatchaton as nan Templo at chacha lablabsingun nan lintig nan Urkiw ay Mun-iblayan? Uray mu assena, fiakuncha met fiasor sa. ");
INSERT INTO ebk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ifiakiak ay wacha kan chakayu ad wani nan am-amud mu nan Templo. ");
INSERT INTO ebk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mu kunyu ammu nan laychun ay kanan nan naisurat as nan Kalen Apo Dios ay kanana un, ‘Nan manug-anganyu as nan pachongyu ay taku nan laychok, fiakun nan mun-ichatchatonanyu as animar kan ha-un.’ Mu tit-iwa ay ammuyu nan laychun nan nauy ay kanan, chaanyu koma penafiasor nan maid fiasorna. ");
INSERT INTO ebk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tay nan Naepadtu ay Anak chi Taku nan muntoray as nan Urkiw ay Mun-iblayan.” ");
INSERT INTO ebk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","As nan nak-akan Jesus hid-i, uy sinungkop as nan senagogacha. ");
INSERT INTO ebk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wacha hid-i nan laraki ay nakukuy chi usa ay limana. Wacha us nan tapen nan tataku hid-i ay nunsarudsud kan hiya, “Ay eparufus nan Lintig takú nan munkaanan as saket as nan Urkiw ay Mun-iblayan?” Enatcha chi ta wachay epafiasorcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kenalina kan chicha, “Mu nan usa kan chakayu at wachay karnerona ay mag-as as nan fitu as nan Urkiw ay Mun-iblayan, ay achina ngun uy kuyuchun? ");
INSERT INTO ebk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Am-amud as solet nan taku mu nan karnero! Isunga eparufus nan Lintig takú ay fiadngan takú nan pachong takú ay taku as nan Urkiw ay Mun-iblayan.” ");
INSERT INTO ebk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Angkiay ya kenalina as nan nakukuy chi limana, “Uyachum nan limam.” Kuna pay inuyad, enmammay at tit-iwa, ya maepachong as nan usa ay ammay ay limana. ");
INSERT INTO ebk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ngem nak-ak nan chiyuycha Fariseo ta uycha anapun mu anan atuncha ay mangpatuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ammon Jesus na ay pangkepcha, isunga nak-ak hid-i. Ongor nan tataku ay inmunud kan hiya, at enpaammayna nan am-in ay munsaket kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Infilina kan chicha ay achicha ifiagfiakia nan maepangkep kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Enatna na ta matongpar nan kalen Apo Dios ay insurat Isaias ay pomapadtu ay kanana, ");
INSERT INTO ebk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hi tona nan fiabfiaarok ay pinilek. Hiya nan laylaychok ya mangepalaylayad as solet kan ha-un. Ichatkuntu nan Espiritok kan hiya ta epakaammunantu as nan am-in ay tataku nan atuncha ay mapalintig as nan mangiilan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Achintu makisumsuma winnu fumudfudtak, ya achina us ipipigsa nan kalina as nan chiyuycha korsa. ");
INSERT INTO ebk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nan nanay-ub ay nunu ay maepachong as nan pammaten nan tataku at achina putnun. Nan munkudkuchimet ay apuy ay maepachong as nan namnamacha at achina patayun. Iturturuyna nan chununa inkiana matongpar nan nalintig ay pangkep Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hiya nan namnamaun nan katakutaku ay mangesarakan kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Angkiay ya wachacha nan nangiyuy kan Jesus as laraki ay finurag ya inumor nan anennet. Enpaammay Jesus nan hana laraki at makakali ya makaila at. ");
INSERT INTO ebk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naschaaw nan am-in ay tataku, ya kanancha, “Ay hi tona ngun nan Kianak David ay cha takú sassasad-un?” ");
INSERT INTO ebk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kun pay chinngor nan chiyuycha Fariseo na, tinumforcha, “Fiakun! Hi Beelzebub yangkiay ay ap-apon nan chiyuycha anennet nan nangichat as pannakafialin tona ay taku ay mangepak-ak as nan chiyuycha anennet.” ");
INSERT INTO ebk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ngem aammon Jesus nan chacha numnumnumun, isunga kenalina kan chicha, “Mu munkikinnufiat nan tataku henan usa ay muntorayan, machachael sa ay muntorayan. Kaman us as nan munkakailiyan winnu hinfiaruy, mu masusumacha at masisiyancha. ");
INSERT INTO ebk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mu epak-ak Satanas nan mismu ay iib-ana ay aanennet, anan atuna ay muntotoray in-inkiana? ");
INSERT INTO ebk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mu as nan pannakafialin Beelzebub nan nangor-ak as pannakafialinku ay mangepafoknag as aanennet, ngachana ngay nan nangichat as pannakafialin nan chiyuycha umun-unud kan chakayu ay mangepak-ak as nan anennet? Mu hiyasa, chicha nan mangepaneknek ay achi tit-iwa nan kenaliyu. ");
INSERT INTO ebk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nan kenatit-iwana at fiakun hi Beelzebub, ngem babaen as nan Espiriton Apo Dios nan mangepafoknakiak as nan aanennet. Hiyana nan mangepaila ay enmali nan muntorayan Apo Dios kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Maepachong hi Beelzebub as nan kursi ay taku. Maid makaskop as nan afong nan usa ay kursi ay taku ta akiwuna nan kuk-uwan tosa sukúdna on-ona etakud hiya. ");
INSERT INTO ebk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nan achi makius-usa kan ha-un at komokontra kan ha-un. Assesa us ay nan achi fumachang kan ha-un ay mangamong as nan tataku at kuna munsisiyanun chicha. ");
INSERT INTO ebk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Isunga ifiakiak kan chakayu ay mapakawan nan tataku as nan am-in ay fiasfiasorcha ya uray nan munkaliyancha as maifusor kan Apo Dios, ngem achi mapakawan nan munkali as maifusor as nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Uray nan taku ay munkali as maifusor as nan Naepadtu ay Anak chi Taku at mafialin ay mapakawan. Ngem nan taku ay munkali as maifusor as nan Espiritu Santo at achi mapakawan as nan nauy ay fiyag winnu as nan omali ay fiyag.” ");
INSERT INTO ebk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kenalen Jesus ay nun-epadpachong, “Mu narangtu nan usa ay kaiw, ammay us nan fukiasna, winnu mu naiing nan kaiw, mangisiw us nan fukiasna, tay maammuwan nan kaiw as nan fukiasna. ");
INSERT INTO ebk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Chakayu ay maepachong as nan kianak chi kubra, anan atunyu ay munkali as ammay mu mangotettet chi ukialiyu? Tay nan sumubsubra ay naichuchulin as nan numnum at hiya challu nan maepafoknag as nan tapak. ");
INSERT INTO ebk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nan ammay ay taku at epafoknagna nan ammay ay naichuchulin as nan numnumna. Assesa us ay nan mangotettet ay taku at epafoknagna nan mangotettet ay naichuchulin as nan numnumna. ");
INSERT INTO ebk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ifiakiak kan chakayu ay as nan umchanantu nan urkiw ay mang-okomán Apo Dios as nan katakutaku, waschi un songfiatanantu kan Apo Dios nan am-in ay kenarkalina ay maid kotkotokna. ");
INSERT INTO ebk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tay nan chiyuychantu mismu ay kaliyu nan osarun Apo Dios ay mangekeddeng kan chakayu mu nakafiasor kayu winnu chaan.” ");
INSERT INTO ebk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Angkiay ya kenalen nan tapen nan mun-isursuru as Lintig ya tapen nan Fariseo kan Jesus, “Misturu, laychunmi ay omepailaka as nakaskaschaaw ay sinyar as mangammuwanmi ay nurpuka kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngem tinumfor hi Jesus kan chicha, “Anuy paat mangotettet chi ukialen chi tataku ad wani ya maid us pammaticha kan Apo Dios! Chacha chumawat as nakaskaschaaw ay sinyar, ngem maid maepaila kan chicha omangkiay nan nakaskaschaaw ay enommat kan Jonas ay pomapadtu. ");
INSERT INTO ebk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tay hi Jonas at nanagyan as nan puton nan ad-acha-an ay finayang ay mamagyan henan fiayfiay as turu ay urkiw ya turu ay lafi. Assesantu us as nan Naepadtu ay Anak chi Taku ay mailufok as turu ay urkiw ya turu ay lafi. ");
INSERT INTO ebk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","As nan omaliyantu nan urkiw ay mun-okomán Apo Dios as nan katakutaku, tomakchugtu nan inmiili ad Nineve ay mangepafiasor kan chakayu ay tataku ad wani, tay nunfiafiawicha as nan fiasfiasorcha as nan nanngorancha as nan enkaskasaban Jonas. Ifiakiak kan chakayu ay wacha's na ad wani nan am-amud mu hi Jonas! ");
INSERT INTO ebk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kaman us as nan urkiw ay mun-okomán Apo Dios, tomakchugtu nan Reyna ad Seba ad pus-uy ay mangepafiasor kan chakayu, tay nurpu hiya henan achaachawwi ay lukiar ay uy paat nanngor as nan nainsilifian ay sursuron Solomon. Ifiakiak kan chakayu ay wacha hena ad wani nan am-amud mu hi Solomon.” ");
INSERT INTO ebk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nun-epadpachong pay hi Jesus, “As nan fomoknakian nan anennet ay sinungkop as nan taku, uy munlikud hiya henan luglukiar ay kamaid chi chanum ay mun-anaanap as tukún ay mun-iblayana, ngem maid uchanana. ");
INSERT INTO ebk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Angkiay ya kanana as numnumna, ‘Munfiangachak challu as nan afongku ay nurpuwak.’ As nan munfiangchana, uchanana ay nafiafiaíw, nacharos ya naornos nan afong. ");
INSERT INTO ebk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Angkiay mak-ak ya ometakin as tapina ay pitu ay aanennet ay kaskasin manangotettet mu hiya. Sungkopcha as nan afong ya magyancha hid-i. As nan hiyachi, kaskasin mangisiw nan kasasaad nan chiyuy taku mu as nan enmon-ona. Hiyana nan ommattu as nan chiyuycha manangotettet ay tataku ad wani.” ");
INSERT INTO ebk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","As nan cha pay laing munkarkaliyan Jesus as nan tataku, inumchan at hi enana ya nan susnúdna ay lanaraki. Tenmatakchugcha as nan fiattaw ya chacha chawatun ay maketakiatforcha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wacha nan nangifiakia kan Jesus, “Wacha hi enam ya nan susnúdmu ay lanaraki ay nangatakchug as nan fiattaw ay cha manawat ay maketakiatforcha kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tinumfor hi Jesus as nan nangifiakia kan hiya, “Ngachana nan kanam ay enak ya susnúdku?” ");
INSERT INTO ebk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Angkiay ya tinugkiawna nan disipulusna, ya kanana, “Nauycha nan tit-iwa ay enak ya susnúdku! ");
INSERT INTO ebk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tay nan uray ngachana ay mangekaman as nan laychun Amak ay wacha ad chaya at hiya nan tit-iwa ay sunúdku ay laraki winnu fiafiai ya enak.” ");
INSERT INTO ebk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","As nan hiyachi challu ay urkiw, nak-ak hi Jesus as nan afong, at inmuy henan olet nan fiayfiay. Hid-i nan tenmokorana ay mun-isuru. ");
INSERT INTO ebk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kiapú ta ongoongor chi tataku ay naamong kan hiya, uy tenmokor hiya as nan fiangka. Nan ongoongor ay tataku at nangatakchugcha henan oletna. ");
INSERT INTO ebk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ongor chi infiagfiakian Jesus kan chicha ay maepadpachongan. Kenalina, “Wacha nan usa ay taku ay uy nun-iwagwag. ");
INSERT INTO ebk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","As nan chana mun-iwagwagwakian, nag-as nan tapen nan fokel as nan charan. Angkiay ya enmali nan chiyuycha kossel, ya kenancha chachi. ");
INSERT INTO ebk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nan tapina at nag-ascha as nan machupras ay lukiar ay ak-akettuy chi lutana. Henkemadcha ay linmisim, tay nun-ooson nan luta. ");
INSERT INTO ebk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ngem kun pay penomtang, nakling nan chiyuycha cha tomemel. Kiapú ta chaancha lenmamot ad chur-um, narangucha. ");
INSERT INTO ebk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nan tapina at nag-ascha as nan kaongoran chi sufet. Naikisancha ay tinmufu as nan ongor ay sufet, at nasulincha. ");
INSERT INTO ebk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nan tapina ay fokel at nag-ascha as nan ammay ay luta. Tinmufucha, at nasikuncha. Hacha at fumkias as mahinkiagsot, maunum pupuru, ya matutlon pupuru.” ");
INSERT INTO ebk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Inyanongos Jesus, “Nan wachay ingana at masapor chumngor.” ");
INSERT INTO ebk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Angkiay ya enmali nan disipulus kan Jesus, ya senarudsudcha kan hiya, “Adchi t'uy maepadpachongan chi osarum ay mun-isuru as nan tataku?” ");
INSERT INTO ebk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tinumfor hiya kan chicha, “Kan chakayu nan naepakaammuwan nan chaan naam-ammuwan ay maepangkep henan muntorayan Apo Dios, ngem fiakun kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tay nan taku ay wachay kafiaelana at maettan as ong-ongor. Ngem nan taku ay maid kafiaelana at uray nan ak-akettuy ay wacha kan hiya at maarantu. ");
INSERT INTO ebk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Isunga maepadpachongan nan osarok ay mun-isuru kan chicha ta uray mu iilauncha, achicha ematonan. Uray mu chungruchungruncha, henpakpakidngoruncha winnu achicha challu maawatan. ");
INSERT INTO ebk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kan chicha nan natongparan nan enpadton Isaias ay kanana un, ‘Uray mu chungruchungrunyu at achiyu challu maawatan, ya uray mu ilailaunyu at achiyu challu ematonan. ");
INSERT INTO ebk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tay tenmangken chi numnum chatona ay tataku! Penoponetancha nan ingacha, ya kenekemetcha nan matacha. Tay mu atuncha chaná at makaematoncha, makadngorcha, makaawatcha ya munsakongcha kan ha-un, at epaammayku chicha.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Inturuy Jesus, “Ngem nakiasat kayu, tay makaila kayu ya makadngor kayu. ");
INSERT INTO ebk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ifiakiak kan chakayu nan tit-iwa ay nan ongor ay pomapadtu ya nalintig ay tataku at lenarayadcha ay mangila as nan chayu il-ilaun, ngem chaancha inila. Lenarayadcha us ay manngor as nan chayu chungchungrun, ngem chaancha chinngor.” ");
INSERT INTO ebk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kenalen Jesus, “Chungrunyu ngarud nan laychun ay kanan nan maepadpachongan maepangkep as nan uy nun-iwagwag as fokel. ");
INSERT INTO ebk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nan chiyuycha fokel ay nag-as as nan charan at maepachong chachi as nan tataku ay manngor as nan maepangkep henan muntorayan Apo Dios, ngem achicha maawatan. Angkiay ya maannuuy nan Mangotettet ya kaanuna nan hana kali ay chinngorcha. ");
INSERT INTO ebk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nan chiyuycha naiwagwag as nan machupras ay lukiar at maepachongcha as nan tataku ay naragsak ay mang-awat ay dagus as nan kalen Apo Dios as nan manngorancha. ");
INSERT INTO ebk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Uray mu assesa, achi lomamot ay ustu nan kalen Apo Dios as nan numnumcha, ya kun hen-omaketan chi omafurotancha. As nan omaliyan nan liglikiat kan chicha winnu mapalikiatcha kiapú as nan enmafurotancha as nan kalen Apo Dios, hiya at chi ya achicha ituruy ay omafurot. ");
INSERT INTO ebk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kun pay nan chiyuycha naiwagwag as nan tinmufuwan chi ongor ay sufet at maepachongcha as nan tataku ay manngor as nan kalen Apo Dios. Ngem nan chanchanagcha ya nan layadcha ay fumaknang at sulinuncha nan kalen Apo Dios. Mu hiyasa, achicha fumkias. ");
INSERT INTO ebk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kun pay nan chiyuycha naiwagwag as nan ammay ay luta, maepachongcha as nan tataku ay manngor ya makaawat as nan kalen Apo Dios. Tit-iwa, chatud-i nan fumkias as mahinkiagsot, maunum pupuru, ya matutlon pupuru.” ");
INSERT INTO ebk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wacha pay nan tukún ay maepadpachongan ay infiakian Jesus kan chicha. Kenalina, “Nan muntorayan Apo Dios at maepachong as nan usa ay taku ay uy nun-iwagwag as ammay ay fing-i ay trigo as umana. ");
INSERT INTO ebk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","As nan usa ay lafi, as nan nanassuyan nan am-in ay tataku, inmuy nan kafusorna as nan uman nan nunkuwa, ya wenagwakiana as fokel chi lukiam. Kun pay narpas, nak-ak hiya. ");
INSERT INTO ebk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kun pay nasikun nan chiyuycha trigo ya elapucha ay mamusfus, cha us masikun nan chiyuycha lukiam. ");
INSERT INTO ebk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Enmali nan chiyuycha fiabfiaarun nan nunkuwa as nan uma, ya kanancha as nan amocha, ‘Apo, ay kun fiakun ammay ay fing-i nan inwagwag takú as umam? Anan nurpuwan ngay chi lukiam?’ ");
INSERT INTO ebk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“ ‘Usa ay kafusor nan nangekaman as na,’ ensongfiatna. “Kenalen nan chiyuycha mafiabfiaor kan hiya, ‘Ay laychum ngarud t'uymi kafiaotun?’ ");
INSERT INTO ebk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“ ‘Achiyu ud-ay,’ kenalen nan amo, ‘tay atun at mu as nan munkafiaotanyu, maetapi nan chiyuycha trigo ay mafiagnot. ");
INSERT INTO ebk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pay-anyu ta masikuncha am-in inkiana as panag-aani. Ifiakiaktu as nan chiyuycha mun-ani un, “Amongunyu on-ona nan chiyuycha lukiam, ya fiatkunyu ta mapuorancha. Kun pay marpas, aniyunyu nan chiyuycha trigo, ya ipuuyyu as nan arangku.” ’ ” ");
INSERT INTO ebk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Wacha pay kasin nan tukún ay maepadpachongan ay infiakian Jesus kan chicha. Kenalina, “Nan muntorayan Apo Dios at maepachong as nan fokel chi mostasa ay enaran nan usa ay taku, ya uyna entanum as nan umana. ");
INSERT INTO ebk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nan fokel ay anna nan kaek-ektelan as nan am-in ay fokel. Ngem kun pay nasikun, hiya nan kaad-acha-anan as nan am-in ay naetanum as uma ay kaman kaiw chi kaad-achana, ya mafialin ay somollongchay kossel as nan chiyuycha pangana.” ");
INSERT INTO ebk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nun-epadpachong kasin hi Jesus. Kenalina, “Nan muntorayan Apo Dios at maepachong as nan akét ay lebadura ay ekar-ot nan fiafiai as nan turon sarop ay alina, inkiana fumrad am-in.” ");
INSERT INTO ebk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Maepadpachongan nan enos-osar Jesus as nan am-in ay insursuruna as nan tataku. Maid paat insursuruna kan chicha as chaana enpadpachong. ");
INSERT INTO ebk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Enatna na ta matongpar nan infiakian nan pomapadtu, “Maepadpachongan nan osaroktu ay munkali kan chicha. Ifiakiaktu kan chicha nan naetatafun nunlapu as nan nafiayangan nan luta.” ");
INSERT INTO ebk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Angkiay ya tenaynan Jesus nan ongoongor ay tataku, ya sinungkop as nan afong. Enmali nan disipulusna kan hiya, ya kanancha, “Ifiakiam pay kan chakami nan laychun ay kanan nan maepadpachongan ay maepangkep as nan lukiam as nan uma.” ");
INSERT INTO ebk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tinumfor hi Jesus, “Nan taku ay nangiwagwag as nan ammay ay fokel at hiya nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nan chiyuy uma at hiya nan luta ay anna. Nan ammay ay fokel at chicha nan tataku ay naetapi henan muntorayan Apo Dios. Nan chiyuycha lukiam at chicha nan tataku ay naetapi as nan Mangotettet. ");
INSERT INTO ebk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nan chiyuy kafusor ay uy nunwagwag as nan chiyuycha fokel chi lukiam at hi Satanas. Nan panag-aani at hiya nan munpatingkiaan nan luta, ya nan chiyuycha mun-ani at chicha nan angheles. ");
INSERT INTO ebk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kaman as nan nangamongan nan chiyuycha mafiabfiaor as nan lukiam ta mapuoran at assesantu us nan ommat as nan anongos ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ifiaortu nan Naepadtu ay Anak chi Taku nan anghelesna ay uy mangaan henan muntorayana nan tataku ay munlumu as fumasoran nan pachongcha ay tataku ya nan am-in ay mangekamkaman as manangotettet. ");
INSERT INTO ebk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ichus-or nan angheles chicha as nan munkilkil-ab ay apuy. Hid-intu nan mun-ag-akorancha ya munngesngesatan chi fiab-acha kiapú as fungatcha. ");
INSERT INTO ebk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngem nan nalintig ay tatakon Apo Dios at sumilichantu ay kaman urkiw henan muntorayan Amacha. Nan wachay ingana at masapor chumngor. ");
INSERT INTO ebk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Maepachong nan muntorayan Apo Dios as nan fialetok ay naekakaub as nan uma. Kun pay ininchanan nan usa ay taku, kinab-unana kasin. Kiapú as ongor ay lagsakna, uyna enlaku nan am-in ay wacha kan hiya, ya lenakwana nan chiyuy luta. ");
INSERT INTO ebk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Maepachong pay nan muntorayan Apo Dios as nan usa ay taku ay nigusyante ay mun-an-anap as am-ammay ay perlas. ");
INSERT INTO ebk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","As nan nanguchanana as nan usa ay perlas ay nangina as solet, ya kenmatam. Enlakuna nan am-in ay wacha kan hiya, ya uyna lenakwan nan chiyuy perlas.” ");
INSERT INTO ebk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Maepachong nan muntorayan Apo Dios as nan tafukor ay naetap-or henan fiayfiay ya kennanay tukutukún. ");
INSERT INTO ebk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kun pay napnu, ininat nan chiyuycha tomatafukor ay nangiyuy henan oletna. Tenmokorcha ta pasikuncha nan chiyuycha kennacha. Nan chiyuycha anam-ammay at inittucha as nan mangit-ittuwan. Ngem nan chiyuycha manangisiw at inwagkiacha. ");
INSERT INTO ebk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Assesantu us nan ommattu as nan anongos ay urkiw. Omalichantu nan angheles, ya epatkuncha nan manangotettet ay tataku as nan nalintig ay tataku, ");
INSERT INTO ebk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ya ichus-orcha nan manangotettet ay tataku as nan cha munkilkil-ab ay apuy. Hid-intu nan mun-ag-akorancha ya munngesngesatan chi fiab-acha kiapú as fungatcha.” ");
INSERT INTO ebk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Senarudsud Jesus as nan disipulusna, “Ay naawatanyu am-in chaná?” “O,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kenalina kan chicha, “Isunga maawatanyu ay nan tunggal usa ay mun-isursuru as Lintig ay nunfialin as disipulus henan muntorayan Apo Dios at maepachong as nan taku ay wachay afongna ay ammuna ay mangepafoknag as fiarú ya lukiak ay naichuchulin as arangna.” ");
INSERT INTO ebk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kun pay lenpas Jesus ay nangifiakia as nan nauycha maepadpachongan, nak-ak hid-i. ");
INSERT INTO ebk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hiyachi ya nunfiangad henan mismu ay ilina, ya uy nun-isuru hiya as nan tataku as nan senagogacha. Naschaaw nan chiyuycha nanngor, ya kanancha, “Ay chaud ngun nan nangor-an tona ay taku as kenasilibna ya pannakafialina ay mangekaman as nakaskaschaaw? ");
INSERT INTO ebk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ay fiakun hiya nan potot nan mun-am-amma as afong? Ay fiakun hi Maria nan enana, ya nan susnúdna at cha Santiago, Jose, Simon ya Judas? ");
INSERT INTO ebk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ay achi nan am-in ay susnúdna ay fianafiai at nakiilicha's na kan chitaku? Anuyna ngun nangor-an kan chatona am-in?” ");
INSERT INTO ebk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Angkiay ya enachicha at hiya. Ngem kenalen Jesus kan chicha, “Maichayaw nan pomapadtu henan kumpurmi ay lukiar omangkiay henan mismu ay ilina ya as nan pamilyana.” ");
INSERT INTO ebk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Maid enkaman Jesus as ongor ay nakaskaschaaw hid-i kiapú ta maid pammaticha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","As nan hiyasa ay timpu, nachamag Herodes ay gobernador ad Galilea nan maepangkep kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kenalina as nan chiyuycha opisyarna, “Hi tona hi Juan ay Fumufunyag ay kun nataku manipud as nan utúy. Isunga wacha kan hiya nan pannakafialin ay mangekamkaman as nan nauycha ay nakaskaschaaw.” ");
INSERT INTO ebk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kenalen Herodes chi, tay hiya nan nangepatiliw ya nangepafiarud kan Juan ay nakokor-ongan. Enatna na ta palaylaychuna hi asawana ay Herodias ay asawan Felipe ay sunúdna, ");
INSERT INTO ebk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","tay kenarkalen ngamin Juan kan Herodes, “Epawan nan lintig ay asaw-um nan ingudmu.” ");
INSERT INTO ebk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Laraychun Herodes ay epapatuy hi Juan, ngem umugyat hiya as nan tataku, tay infilangcha hi Juan as usa ay pomapadtu. ");
INSERT INTO ebk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ngem kun pay inumchan nan urkiw ay mangnumnumnumancha as nan naiyankan Ari Herodes, nunsasara nan anak Herodias ay fiarasang as nan sangwanan nan am-in ay naayakian ay makelagragsak. Nalaylaychan hi Herodes. ");
INSERT INTO ebk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Isunga enkarina as nan fiarasang ay ichatna kan hiya nan kumpurmi ay chawatuna. ");
INSERT INTO ebk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kiapú ta insuron Herodias ay enana, kenalen nan fiarasang, “Epaiyalem as na kan ha-un nan uron Juan ay Fumufunyag ay maiittu as nan paratu.” ");
INSERT INTO ebk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nalilifokan nan ari, ngem kiapú ta nun-ekari as nan sangwanan nan am-in ay mangilina, infilina ay maekaman nan chinawat nan fiarasang. ");
INSERT INTO ebk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hiyachi ya enpasiwatna nan uron Juan as pagfiaruchan. ");
INSERT INTO ebk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Inyuycha nan uron Juan ay naiittu as nan paratu, ya inchatcha as nan fiarasang ay nangiyuy kan enana. ");
INSERT INTO ebk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Angkiay ya enmalicha nan disipulus Juan ay nangara as nan achorna, ya uycha inlufok. Hacha at uy ifiakia kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","As nan nangchamakian Jesus as nan enommat kan Juan, nak-ak cha Jesus hid-i. Nunfiangkacha ay inmuy henan kamaid chi tataku ay kun chidchicha yangkiay. Ngem kun pay naammuwan nan ongoongor ay tataku ay nurpu henan il-ili, nanarcharancha ay nangunud kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kun pay nunchissaag hi Jesus, inilana nan ongoongor ay tataku. Nasug-ang hiya kan chicha, ya enpaammayna nan wachay saketna kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kun pay cha maschum, inmuy nan disipulusna kan hiya, ya kanancha, “Nauy takú henan kamaid chi umili ya cha us maschum. Epakatammu nan ongoongor ay tataku ta umuycha henan fiabfiabruy ay uy lomaku as kanuncha.” ");
INSERT INTO ebk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tinumfor hi Jesus, “Achicha kis-an mak-ak. Chakayu mismu nan mangichat as kanuncha.” ");
INSERT INTO ebk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kenalicha kan hiya, “Lema met yangkiay ay tenapay ya chuwa ay filis nan wacha's na kan chakami.” ");
INSERT INTO ebk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Iyaliyu chasa's na kan ha-un,” kenalen Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Angkiay infilina as nan ongoongor ay tataku ay tomokorcha as nan lukiam. As nan hiyachi, enarana nan lema ay tenapay ya nan chuwa ay filis, ya nuntangad ad chaya ay munyaman kan Apo Dios. Kun pay narpas, pinutput-ingna nan chiyuycha tenapay, ya inchatna as nan disipulusna, ya nan disipulusna at inwarascha as nan ongoongor ay tataku. ");
INSERT INTO ebk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nangancha am-in, at nasufucha. Haat amongun nan disipulus nan chinaancha ay namnu as nan hinpuru ya chuwa ay uppig. ");
INSERT INTO ebk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nan filang nan lanaraki ay nangan at kiayud umuy as leman lifu. Chaan naetapi nan fiabfiafiai ya ongong-a ay naifilang. ");
INSERT INTO ebk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","As nan cha mangepakataman Jesus as nan ongoongor ay tataku, enpalukiana nan disipulus as nan fiangka, ya enpaon-onana chicha ay kinumchang ad chumang. ");
INSERT INTO ebk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kuna pay enpakatam nan ongoongor ay tataku, tinmikid hiya henan chuntug ay us-usana ta uy munkararag. As nan naschum, nauusa pay laing hi Jesus hid-i. ");
INSERT INTO ebk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kun pay nan fiangka ay nunlurukianan nan disipulusna at achawwi henan olet nan fiayfiay. Kaman cha iyin-inchayon nan challuyon nan fiangka, tay kuncha sisib-atun chi angin. ");
INSERT INTO ebk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kun pay nakapis, inmuy kan chicha hi Jesus ay cha manarcharan as nan oson nan chanum. ");
INSERT INTO ebk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","As nan nangil-an nan disipulus kan hiya ay cha manarcharan as nan oson nan chanum, inmugyatcha as solet. “Anennet!” infukiawcha, ya nun-uwekcha kiapú as ugyatcha. ");
INSERT INTO ebk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngem nunkanan at Jesus kan chicha, “Papigsaunyu nan numnumyu! Ha-un na ya! Achi kayu umugyat!” ");
INSERT INTO ebk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tinumfor hi Pedro, “Apo, mu tit-iwa ay he-a sa, ifikiam pay ay omaliyak kan he-a as nan oson nan chanum.” ");
INSERT INTO ebk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Aka pay,” kenalen Jesus. Isunga kenmaan hi Pedro as nan fiangka, ya enlapuna ay nanaran as nan oson nan chanum ay umuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngem kuna pay kenekna nan napigsa ay angin, inmugyat, ya enlapuna ay lumnud. Infukiawna, “Apo, esarakanak!” ");
INSERT INTO ebk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hiya at chi ya inchawchaw Jesus nan limana, ya inkuyudna hiya. “Anuy paat ak-akettuy chi pammatem! Adchi t'uyka nunchuwachuwa?” kenalina. ");
INSERT INTO ebk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kuncha pay nunlukian as nan fiangka, kinminak nan angin. ");
INSERT INTO ebk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Angkiay nan chiyuycha wacha as nan fiangka at chinaychayawcha hi Jesus. Kenalicha, “Tit-iwa ay he-a nan Anak Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","As nan kinumchangancha henan fiayfiay, inumchancha ad chumang henan lukiar ay Genesaret. ");
INSERT INTO ebk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kun pay enmatonan nan tataku hid-i hi Jesus, enpakaammucha henan intiru ay lukiar hid-i, at inyuy nan tataku nan am-in ay munsaket kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nunpakaasicha kan hiya ta paat kap-un nan chiyuycha munsaket nan kiayachan nan fiachuna, ya nan am-in ay nangpa at enmammaycha. ");
INSERT INTO ebk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","As nan namingsan, inmuy kan Jesus nan chiyuycha Fariseo ya nan chiyuycha mun-isursuru as Lintig ay nurpu ad Jerusalem. Senarudsudcha, ");
INSERT INTO ebk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Adchi t'uy labsingun nan disipulusmu nan iniili ay ukialen nan kaap-uwan takú? Chacha met mangan ay achi munfuru.” ");
INSERT INTO ebk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tinumfor hi Jesus kan chicha, “Chakayu ngay, chayu met lablabsingun nan lintig Apo Dios ta nan naepatawid ay iniili ay ukialiyu nan chayu tongtongparun. ");
INSERT INTO ebk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tay nan infilin Apo Dios at kanana, ‘Rispituwum cha amam kan enam,’ya ‘Nan ngachana ay mangituchor as amana ya enana at masapor maepapatuy.’ ");
INSERT INTO ebk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ngem chayu met isuru ay mu wachay ifiachang koma nan usa ay taku kan cha amana ya enana at mafialin ay munpanfor mu kanana un, ‘Nan ifiachangku koma kan chakayu at naiichat at kan Apo Dios.’ ");
INSERT INTO ebk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mu hiyasa, chayu isuruwan hiya ay uray achina rispituwun hi amana. Isunga kiapú as nan iniili ay ukialiyu, menaidyu nan kotok nan kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Chakayu ay pakamankaman! Tit-iwa as solet nan enpadton Isaias maepangkep kan chakayu ay kanana un, ");
INSERT INTO ebk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nan nauycha tataku at chaychayawunak as nan kalicha, ngem achawwi challu nan numnumcha kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Maid kotok nan chacha manaychayawan kan ha-un, tay nan chacha isursuru at linlintig ay enammaan chi taku ay kanancha un filfilinku kanu.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Enayakian Jesus nan tataku kan hiya, ya kanana kan chicha, “Chumngor kayu ya numnumunyu ay ustu ta maawatanyu nan ifiakiak. ");
INSERT INTO ebk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Fiakun nan okmonun nan usa ay taku nan mangepaassi kan hiya as nan sangwanan Apo Dios, ngem kun at nan epafoknagna as tapakna nan mangepaassi kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Angkiay ya inmuy nan disipulus kan hiya, ya kanancha, “Ay ammom ay menmangisiw chi numnum nan chiyuycha Fariseo as nan nanngorancha's nan infiakiam?” ");
INSERT INTO ebk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tinumfor hi Jesus, “Tunggal tenanum ay fiakun hi Amak ad chaya nan nangetanum at mafiagnotcha. ");
INSERT INTO ebk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pay-anyu, tay maepachong chasa ay Fariseo as nan nafurag ay mangepangu as ayun. Mu epangon nan nafurag nan pachongna ay nafurag at mag-aschantu ay chuwa as nan ngilig.” ");
INSERT INTO ebk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kenalen Pedro, “Epakaawatmu pay kan chakami nan laychun ay kanan nan nauy maepadpadchongan.” ");
INSERT INTO ebk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kenalen Jesus kan chicha, “Ay uray chakayu at achiyu pay maawatan? ");
INSERT INTO ebk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ay achiyu ammu ay nan okmonun nan taku at umuy as putuna, at etaina challu? ");
INSERT INTO ebk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngem nan chiyuycha epafoknag nan taku as tapakna at murpu as nan numnum, ya hiyachi nan mangepaassi kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tay as nan numnum nan kurpuwan chi am-in ay manangotettet ay pangkep ay mangetoróng as nan taku ay pomatuy, umiwet, mangepapas as assi ay lachokna, mangakiw, munkutum ay muntistigu ya omekak-ali. ");
INSERT INTO ebk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chatona nan mangepaassi as nan usa ay taku as nan sangwanan Apo Dios. Ngem nan mangan ay achi munfuru at achina epaassi nan usa ay taku.” ");
INSERT INTO ebk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Angkiay ya nak-ak cha Jesus hid-i ay inmuy henan sakop nan Tiro ya Sidon. ");
INSERT INTO ebk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wacha nan usa ay fiafiai ay i-Canaan ay nakiiili hid-i. Naesnop kan Jesus, ya infukiawna, “Apo ay Kianak David, sug-anganak man paat! Naanennetan nan anakku ay fiafiai ya malikiatan as solet.” ");
INSERT INTO ebk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngem chaan tinumtumfor hi Jesus kan hiya. Isunga naesnop nan disipulus kan hiya, ya enpakaasicha, “Uray atum nan chana chawatun ya pakatamum, tay kuna itukiay fukiaw ay cha umunuunud kan chitaku.” ");
INSERT INTO ebk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tinumfor hi Jesus, “Naifiaorak as nan chiyuycha kianak Israel yangkiay ay maepachong as nan chiyuycha nalitaw ay karnero.” ");
INSERT INTO ebk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngem enmali nan fiafiai ya nunpalintumang as sangwanan Jesus, ya kanana, “Apo, fiadnganak at man.” ");
INSERT INTO ebk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tinumfor hi Jesus ay mangepadpachong, “Achi met ustu mu araun nan cha kanun nan ongong-a, ya ichat as nan chiyuycha asu.” ");
INSERT INTO ebk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kenalen nan fiafiai, “O, tit-iwa sa Apo. Ngem uray met nan asu at kanuncha nan mag-as as nan lamesaan nan amocha.” ");
INSERT INTO ebk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Angkiay kenalen Jesus kan hiya, “Ammi, napigsa nan pammatem! Maekaman ngarud nan laychum.” As nan hiyachi, enmammay nan anakna. ");
INSERT INTO ebk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nak-ak hi Jesus hid-i ay nanguy henan olet nan fiayfiay ay Galilea. Angkiay ya tinmikid henan chuntug, ya tenmokor hid-i. ");
INSERT INTO ebk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ongoongor nan inmuy kan hiya ay tataku ay nangiyali as nunkapilay, nunkafurag, nunkapilud, umor ya ongor pay ay tapina ay munsaket. Inyuycha chaná as nan sangwanan Jesus, ya enpaammayna chicha. ");
INSERT INTO ebk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Naschaawcha nan tataku, ya nunchaychayawcha as nan Dios nan chiyuycha kianak Israel as nan nangil-ancha ay makakali nan umor, enmammay nan chiyuycha napilud, makacharan nan nunkapilay, ya makaila nan nunkafurag. ");
INSERT INTO ebk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Angkiay ya enayakian Jesus kan hiya nan disipulusna, ya kanana, “Masug-angak as nan nauycha tataku, tay turu ay urkiw ay naketaktakincha kan ha-un, ya nam-in nan sangatcha. Achek laychun ay pakatamun chicha ay cha munchukiaang, tay anaka ya maurawcha as nan charan.” ");
INSERT INTO ebk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kenalen nan disipulus kan hiya, “Ay chaud ngay nan uy takú omor-an as ommat ay makan ta epakan as nan ongoongor ay tataku hena ay kamaid chi umili?” ");
INSERT INTO ebk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Senarudsud Jesus kan chicha, “Kaatnay tenapay nan wacha kan chakayu?” “Kun pitu, ya akét ay aneket ay filis,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","As nan hiyachi, infilin Jesus as nan tataku ay tomokorcha as nan luta. ");
INSERT INTO ebk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","As nan nangor-ana as nan pitu ay tenapay ya nan filis, nunyaman kan Apo Dios. Kun pay narpas, pinutput-ingna chachi, ya inchatna as nan disipulusna, ya nan disipulusna at inwarascha as nan ongoongor ay tataku. ");
INSERT INTO ebk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nangancha am-in, at nasufucha. Haat amongun nan disipulus nan chinaancha ay namnu as nan pitu ay uppig. ");
INSERT INTO ebk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nan filang nan lanaraki ay nangan at opat ay lifu. Chaan naetapi nan fiabfiafiai ya anongong-a ay naifilang. ");
INSERT INTO ebk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kun pay enpakatam Jesus nan ongoongor ay tataku, nunlukian hiya as nan fiangka ay inmuy henan sakop nan Magadan. ");
INSERT INTO ebk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wachacha nan Fariseo ya Saduseo ay inmuy kan Jesus. Lenayadcha ay chistingun hiya. Isunga chinawatcha kan hiya ay omepaila as nakaskaschaaw ay sinyar ay mangepaneknek ay hiya at nurpu kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tinumfor hi Jesus kan chicha, “As nan cha mauynuwan nan urkiw ya munlalatikia ad chaya, kananyu un, ‘Maukiwtu as wiet.’ ");
INSERT INTO ebk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mu ilaunyu ad chaya as nan wi-ewi-et, kananyu un, ‘Umuchan sa met, tay munlalatikia ad chaya ya munlilifuu.’ Naraing kayu ay mangematon as nan maila ad chaya. Ngem achiyu met maematonan nan chiyuycha sinyar Apo Dios ay maepangkep kan ha-un ay cha om-ommat ad wani. ");
INSERT INTO ebk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Anuy paat mangotettet chi ukialen chi tataku ad wani, t'uycha chinukkian nan tit-iwa ay Apo Dios! Chacha chumawat as nakaskaschaaw ay sinyar, ngem maid maepaila kan chicha omangkiay nan nakaskaschaaw ay enommat kan Jonas ay pomapadtu.” Kun pay lenpas Jesus ay nangifiakia's chi, nak-ak hiya ay nanaynan kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","As nan inumchanan cha Jesus ad chumang, ninumnum nan disipulusna ay liniw-anchay ometakin as sangatcha ay tenapay. ");
INSERT INTO ebk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Il-ilaunyu nan lebaduran nan chiyuycha Fariseo ya Saduseo,” kenalen Jesus kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","As nan nangaliyana's chi, natatakiatforcha nan disipulusna. Kenalicha, “Infiakiana chi, tay maid entakin takú as sangát takú ay tenapay.” ");
INSERT INTO ebk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ngem ammon Jesus nan nauy chacha matatakiatforan, isunga kenalina kan chicha, “Chakayu ay anak-akettuy chi pammatina! Adchi t'uyyu cha matatakiatforan chi kamaid nan sangatyu ay tenapay? ");
INSERT INTO ebk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ay achiyu pay laing maawatan? Ay achiyu manumnum nan namutput-ingak as nan lema ay tenapay ay kenan nan leman lifu ay tataku? Kaatnay enamongyu ay uppig ay napnu as chinaancha? ");
INSERT INTO ebk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Winnu as nan pitu ay tenapay ay kenan nan opat lifu ay tataku, kaatnay enamongyu ay uppig ay napnu as chinaancha? ");
INSERT INTO ebk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Anuyyu paat achi maawatan ay fiakun maepangkep as tenapay nan chak ifiakia kan chakayu? Nan infiakiak kan chakayu at il-ilaunyu nan lebaduran nan chiyuycha Fariseo ya Saduseo.” ");
INSERT INTO ebk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Angkiay ya naawatancha ay nan infiagfiakian Jesus ay il-ilauncha at fiakun payat nan lebaduran chi tenapay, ngem nan cha isursuron nan chiyuycha Fariseo ya Saduseo. ");
INSERT INTO ebk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kun pay inumchan cha Jesus henan sakop nan Cesarea Filipos, senarudsudna as nan disipulusna, “Ngachana nan kanan nan tataku maepangkep as nan Naepadtu ay Anak chi Taku?” ");
INSERT INTO ebk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kenalicha, “Kanan met nan tapina un he-a hi Juan ay Fumufunyag, ya kanan nan tapina un he-a hi Elias. Wacha pay nan mangali un he-a hi Jeremias winnu usa as nan chiyuycha pomapadtu.” ");
INSERT INTO ebk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Senarudsud Jesus kan chicha, “Ngem chakayu ngay? Ngachana nan kananyu maepangkep kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tinumfor hi Simon ay makali us un Pedro, “He-a nan Cristo ay Anak nan matataku ay Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Nakiasatka Simon ay potot Jonas,” ensongfiat Jesus. “Tay fiakun taku nan nangepakaammu's na kan he-a, ngem hi Amak ay wacha ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ifiakiak kan he-a, he-a hi Pedro ay nan laychuna ay kanan at chupras. Nan nauy ay chupras nan mangkiaufiak as nan iglesiak ay chicha nan omaafurot kan ha-un, ya achi poros amisun nan pannakafialin chi utúy chicha. ");
INSERT INTO ebk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ichatkuntu kan he-a nan chiyuycha torfek nan muntorayan Apo Dios ad chaya. Nan ngachana ay epawam asna's luta at maepawantu us ad chaya, ya nan uray ngachana ay eparufusmu asna's luta at maeparufustu us ad chaya.” ");
INSERT INTO ebk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Angkiay infilin Jesus ay ustu as nan disipulusna ay maid poros mangifiagfiag-ancha ay hiya nan Cristo. ");
INSERT INTO ebk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nunlapu as nan hiyasa ay timpu, enlapon Jesus ay mangelawlawag as nan disipulusna nan ommattu kan hiya. Kenalina, “Masapor umuyak ad Jerusalem, ya mun-iliwasak as ongor ay likiat ay epailiwas nan anam-amá, anap-apon chi papachi, ya nan chiyuycha mun-isursuru as Lintig. Maepapatuyaktu, ngem as nan maekatlu ay urkiw at matakuwak as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kun pay chinngor Pedro na, enek-akna hi Jesus, at senengarana hiya kiapú as nan kenalina. Kenalina, “Apo, achi koma eparufus Apo Dios sa! Achintu poros om-ommat chasa kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ngem nunsakong hi Jesus, ya kanana kan Pedro, “Mak-akka Satanas! Somasalika kan ha-un! Tay nan cham numnumnumun at fiakun nan laychun Apo Dios, ngem kun at nan laychun nan taku.” ");
INSERT INTO ebk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Angkiay ya kenalen Jesus as nan disipulusna, “Tay nan ngachana ay manglayad ay umunud kan ha-un at masapor ikinakna ay mangekaman as nan laylaychuna, ya itiina nan korosna, haat umunud kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tay nan uray ngachana ay mangaayyiw as fiyagna asna's luta at malitawnantu challu. Ngem nan uray ngachana ay manglitaw as nan fiyagna asna's luta kiapú as pammatina kan ha-un at mawad-an as fiyag ay maid patingkiana ay ichat Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tay anan maarantu nan taku ay mangkuwa as nan am-in ay wacha asna's luta, ngem malitawna challu nan fiyagna ay maid patingkiana ad inferno? Winnu anan ngachanantu challu nan esokat nan taku para as nan fiyagna? ");
INSERT INTO ebk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tay nan Naepadtu ay Anak chi Taku at munfiangadtu ay kadwana nan anghelesna ay mangepaila as nan kaichayawan Amana. Angkiay ya gun-gunaanantu nan tunggal usa ay maiyunud as nan enkamkamana. ");
INSERT INTO ebk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ifiakiak kan chakayu nan tit-iwa ay wachacha nan tapina kan chakayu ay nangatakchug hena ay achi matuy inkiana ilauncha nan omaliyan nan Naepadtu ay Anak chi Taku ay muntoray.” ");
INSERT INTO ebk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kun pay inmuy chi unum ay urkiw, entakin Jesus hi Pedro ya cha Santiago kan Juan ay hen-aki. Enpanguna chicha henan nangatu ay chuntug ay kun chidchicha yangkiay. ");
INSERT INTO ebk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","As nan chacha mangi-iil-an kan Jesus, tinmukun chi kail-ana. Nan lupana at sumili ay kaman as nan urkiw ya nan fiachuna at pinmukpukkawan ay kaman silaw. ");
INSERT INTO ebk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kalina at ya nunpaila kan chicha cha Moises kan Elias ay cha maketagtakiatfor kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Angkiay kenalen Pedro kan Jesus, “Apo, ammay paat ta wacha takú hena. Mu laychum, mun-ammaak as turu ay fiawi asna, usa kan he-a, usa kan Moises ya usa kan Elias.” ");
INSERT INTO ebk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kun pay cha munkarkali hi Pedro, kalina at ya wacha nan sumili ay lifuu ay nangalenong kan chicha. Wacha us nan kali ay nurpu as nan lifuu ay kanana, “Hi tona nan Anakku ay laylaychok. Malaylaychanak paat kan hiya. Chumngor kayu kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","As nan nanngoran nan disipulus as nan nauy ay kali, nunlukfubcha kiapú as ongor ay ugyatcha. ");
INSERT INTO ebk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ngem naesnop hi Jesus, at kenaprosna chicha, ya kanana, “Fumangun kayu. Achi kayu umugyat.” ");
INSERT INTO ebk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kuncha pay nuntangad, maid tapina as inilacha omangkiay hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","As nan chacha chumayyuwan ay nurpu henan chuntug, infilin Jesus kan chicha, “Maid mangifiagfiag-anyu as nan naepaila kan chakayu inkiana mataku nan Naepadtu ay Anak chi Taku manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ensarochakchak nan disipulus kan hiya, “Adchi man t'uy kanan nan mun-isursuru as Lintig un masapor omon-ona hi Elias ay omali mu hi Cristo?” ");
INSERT INTO ebk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tinumfor hi Jesus, “Tit-iwa ay omali on-ona hi Elias ay mangesakiana as nan am-in. ");
INSERT INTO ebk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngem ifiakiak kan chakayu ay enmali at hi Elias, ya chaan enmatonan nan tataku hiya, ngem kuncha at enat kan hiya nan am-in ay lenaylayadcha. Hiyasa us ay palikiatunchantu nan Naepadtu ay Anak chi Taku.” ");
INSERT INTO ebk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Haat maawatan nan disipulus ay nan cha kankanan Jesus kan chicha at maepangkep kan Juan ay Fumufunyag. ");
INSERT INTO ebk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kun pay nunfiangad cha Jesus as nan kawad-an nan ongoongor ay tataku, inmuy nan usa ay laraki kan Jesus. Nunpalintumang as nan sangwanana, ya kanana, ");
INSERT INTO ebk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apo, sug-angam man paat nan pototku ay laraki, tay munkorchas ya malikiatan as solet. Namen ongor ay cha maichuschus-or hiya as nan apuy winnu as nan chanum. ");
INSERT INTO ebk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inyuyku hiya as nan disipulusmu, ngem chaancha kenafiaelan ay nangepaammay kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tinumfor hi Jesus, “Nakkuran kayu ay tataku ad wani! Maid tit-iwa pammatiyu ya nunkasokel kayu! Anan kafiayag chi mawawad-ak kan chakayu? Anan kafiayag chi tata-unku kan chakayu? Iyaliyu man hena nan onga.” ");
INSERT INTO ebk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","As nan hiyachi, finilin Jesus nan anennet ay mak-ak, at tenaynan nan anennet nan onga. Hiya at chi ya enmammay nan onga. ");
INSERT INTO ebk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Angkiay ya as nan naaw-awni, inmuy nan disipulus kan Jesus ay chidchicha yangkiay, ya senarudsudcha, “Adchi t'uy kami chaan nakaepak-ak as nan anennet?” ");
INSERT INTO ebk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tinumfor hi Jesus, “Kiapú ta akét nan pammatiyu. Ifiakiak kan chakayu nan tit-iwa ay mu wachay pammatiyu ay maepachong as nan kaad-achan nan fokel chi mostasa, mafialinyu ay kanan henan nauy chuntug un, ‘Masligka munlapu hena ta uyka hid-i,’ at maslig tit-iwa. Maidtu poros achi mafialin kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngem nan assena ay karasen chi anennet at achi poros maepak-ak mu achi babaen as panagkararag ya panag-ayunar. ");
INSERT INTO ebk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","As nan naamongan nan disipulus ay kadwacha hi Jesus ad Galilea, kenalen Jesus kan chicha, “Nan Naepadtu ay Anak chi Taku at maipurangtu as nan tataku ");
INSERT INTO ebk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ya patayunchantu, ngem matakuntu hiya manipud as nan utúy as nan maekatlu ay urkiw.” As nan nanngoran nan disipulusna's chi, nginmunguyuscha as solet. ");
INSERT INTO ebk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kun pay inumchan hi Jesus ya nan disipulusna ad Capernaum, inmuy kan Pedro nan mangam-among as chuwa ay drachma ay fiaror nan Templo, ya senarudsudna, “Ay munfiayfiayad nan misturuyu as fiaror nan Templo?” ");
INSERT INTO ebk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“O, met,” ensongfiat Pedro. Kun pay kenmatam hi Pedro, hi Jesus at enmon-ona ay nunkali kan hiya, ya kanana, “Simon, ngachana nan munnunumnummu? Ngachana nan munsengelan nan ar-ari asna's luta as fiaror, ay as nan kakailiyancha winnu as nan chiyuycha mangilicha?” ");
INSERT INTO ebk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Ya kakun as nan chiyuycha mangilicha,” ensongfiat Pedro. “Mu hiyasa, achicha kis-an munfiayad nan kakailiyancha,” kenalen Jesus kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Ngem uray mu hiyasa, achi takú koma pamangisiwun chi numnumcha. Isunga uyka mamunwet henan fiayfiay. Araum nan omon-ona ay funwetam, ya takangum nan tapakna. Mailamtu nan siping ay munfiaror as opat ay drachma ay ommat as ifiayadta ay chuwa. Araum chi, ya uymu ichat kan chicha ta mafiayachan nan fiarorta.” ");
INSERT INTO ebk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","As nan hiyachi ay timpu, enmali nan disipulus kan Jesus, ya kanancha, “Ngachana nan kaamuchan henan muntorayan Apo Dios?” ");
INSERT INTO ebk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Enayakian Jesus nan usa ay onga, at enpatakchugna as nan kiawacha. ");
INSERT INTO ebk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Angkiay ya kenalina, “Ifiakiak kan chakayu nan tit-iwa ay achi kayu poros makaskop henan muntorayan Apo Dios sukúd kayu munfiarfialiw as nan ukialiyu ta munfialin kayu as kaman as nan ongong-a. ");
INSERT INTO ebk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Isunga nan mangepapakumbaba as achorna ay kaman kan tona ay onga at hiya nan kaamuchan henan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nan ngachana ay mang-awat as nan ap-apud ay taku ay kaman kan tona ay onga kiapú as nan pammatina kan ha-un at ha-un nan awatuna.” ");
INSERT INTO ebk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nan ngachana ay munlumu as fumasoran chi usa as nan nauycha ap-apud ay tataku ay omaafurot kan ha-un at un-unuyna ay maetekor chi losóng ay fiatu as fiakiangna, ya maichus-or ad chur-um henan fiayfiay ta murning. ");
INSERT INTO ebk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kasusug-ang nan tataku asna's luta, tay wachachay sulisug ay munlumu as fumasoran! Tit-iwa ay umchan challu nan sulisug, ngem kasusug-ang nan taku ay kurpuwan nan hana ay sulisug! ");
INSERT INTO ebk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mu nan usa ay limam winnu sukem nan kiapón chi fumasoram, putnam, ya iwagkiam. Un-unuyna ay pungudka winnu napiludka ay maetapi as nan fiyag ay maid patingkiana, mu nan wacha nan chuwa ay limam winnu chuwa ay sukem, ya kunka challu maichus-or as nan apuy ay achi mapappauy. ");
INSERT INTO ebk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mu nan matam nan kiapón chi fumasoram, oketam, ya iwagkiam. Un-unuyna ay fuslingka ay maetapi as nan fiyag ay maid patingkiana mu nan wacha nan chuwa ay matam, ya kunka challu maichus-or as nan apuy ad inferno.” ");
INSERT INTO ebk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Il-ilaunyu ta maid elalayusanyu as nan uray usa as nan nauycha ap-apud ay tataku. Tay ifiakiak kan chakayu ay kanayon ay wacha nan anghelescha as nan kawad-an Amak ad chaya.” ");
INSERT INTO ebk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tay nan Naepadtu ay Anak chi Taku at enmali ay mangesarakan as nan nalitaw. ");
INSERT INTO ebk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ngachana nan munnunumnumyu's na? Mu nan usa ay taku at wachay hinkiasot ay karnerona ya natingiw nan usa, ay achina taynan nan chiyuycha siyam puru ya siyam ay karnerona as punchag henan chuntug ta uyna anapun nan chiyuy natingiw? ");
INSERT INTO ebk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ifiakiak kan chakayu nan tit-iwa ay mu uchanana nan natingiw, ong-ongor chi lagsakna mu nan lagsakna as nan siyam puru ya siyam ay chaan natingtingiw. ");
INSERT INTO ebk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hiya us sa kan Amak ay wacha ad chaya ay achina laychun ay malitaw chi uray usa as nan nauycha ap-apud ay tataku.” ");
INSERT INTO ebk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mu fumasor nan ifiam kan he-a, uymu ifiakia kan hiya nan finmasorana as nan machuchuwaanyu yangkiay. Mu chumngor hiya kan he-a, munkiayyum kayu kasin. ");
INSERT INTO ebk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngem mu achi chumngor hiya kan he-a, omayagka as usa winnu chuwa as kadwam ay kasin umuy ta wachay chuwa winnu turu ay muntistigu as nan am-in ay maifiakia. ");
INSERT INTO ebk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mu achi challu chumngor kan chicha, ifiakiam sa as nan iglesia. Mu achi pay laing chumngor as nan iglesia, ifilangmu hiya as achi omaafurot winnu mangam-among as fiaror. ");
INSERT INTO ebk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ifiakiak kan chakayu nan tit-iwa ay nan uray ngachana nan epawayu asna's luta at maepawantu us ad chaya, ya nan uray ngachana nan eparufusyu asna's luta at maeparufustu us ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ifiakiak kasin kan chakayu ay mu nan chuwa kan chakayu asna's luta at muntimpuyugcha ay chumawat as kumpurmi kan Amak ay wacha ad chaya at ekamana para kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tay mu ay chaud nan maamongan nan uray chuwa winnu turu kiapú as nan pammaticha kan ha-un, wachaak hid-i kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Angkiay ya inmuy hi Pedro kan Jesus, ya kanana kan hiya, “Apo, mamen kaatku pakawanun nan ifiak ay cha fumasofiasor kan ha-un? Ay inkiana mamen pitu?” ");
INSERT INTO ebk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Achek kanan un mamen pitu yangkiay, ngem mamen pitu ay piton puru,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Tay nan muntorayan Apo Dios at maepachong as nan usa'y ari ay manglayad ay manotar as nan utang nan chiyuycha opisyarna. ");
INSERT INTO ebk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kuna pay cha elapu, naiyali kan hiya nan usa ay opisyalna ay liniblifuy utangna. ");
INSERT INTO ebk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kiapú ta achi makafiayad, infilin nan ari ay maelaku hiya ay kadwana nan pamilyana ay munfialin as mafiabfiaor ya nan am-in ay kuk-uwana. ");
INSERT INTO ebk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nunpalintumang nan chiyuy opisyar ya enpakaasina un, ‘Sug-anganak man paat ta fiayachak nan am-in ay utangku kan he-a.’ ");
INSERT INTO ebk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nasug-ang tit-iwa nan ari kan hiya. Menaidna nan utangna, ya penakatamna hiya. ");
INSERT INTO ebk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kun pay nak-ak nan chiyuy opisyar, sinib-atna nan usa ay pachongna ay opisyar ay nakautang kan hiya as hinkiasot ay dinario.Lenabkisna, ya enlapuna ay nankor, ya chana kanan un, ‘Fiayacham man nan inutangmu kan ha-un!’ ");
INSERT INTO ebk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Nunpalintumang nan chiyuy kadwana kan hiya, ya enpakaasina, ‘Sug-anganak man paat ta fiayachak nan utangku kan he-a.’ ");
INSERT INTO ebk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Chaana enat nan chawatna, ngem kuna at enpafiarud hiya inkiana mafiayachana nan utangna. ");
INSERT INTO ebk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","As nan nangil-an nan kakadwana ay chiyuycha opisyar as nan enommat, nalilifokan chi numnumcha, ya uycha infiakia as nan ari nan am-in ay enommat. ");
INSERT INTO ebk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Angkiay ya enpaayag nan ari hiya, ya kanana, ‘Mangotettet tit-iway ukialem ay opisyalku! Menaidku ngarud nan am-in ay utangmu, tay nunpasug-angka kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Anuymu chaan sinug-angan nan kadwam ay opisyar ay kaman as nan enatku ay nanug-ang kan he-a?’ ");
INSERT INTO ebk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","As nan hiyachi, finmungat as solet nan ari, ya enpafiarudna hiya inkiana mafiayachana nan am-in ay utangna.” ");
INSERT INTO ebk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Inyanongos Jesus, “Assid-i us nan atun Amak ay wacha ad chaya kan chakayu am-in mu achiyu tit-iwa pakawanun nan ifiayu.” ");
INSERT INTO ebk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kun pay narpas ay infiakian Jesus chaná, nak-ak cha Jesus ad Galilea, ya inmuycha henan sakop nan Judea henan usa ay chumang nan wawwang ay Jordan. ");
INSERT INTO ebk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Inmunud kan Jesus nan ongoongor ay tataku, at enpaammayna chicha hid-i. ");
INSERT INTO ebk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Wachacha nan tapen nan Fariseo ay inmuy kan Jesus ta chistinguncha hiya babaen as nan nanarudsuchancha, “Ay eparufus nan Lintig takú ay iyichang nan laraki nan asawana uray kumpurmi nan panforna?” ");
INSERT INTO ebk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tinumfor hi Jesus, “Ay chaanyu finasfiasa nan naisurat as nan Kalen Apo Dios maepangkep as nan namayangana as nan taku? As nan laplapuna, finayang Apo Dios nan laraki ya fiafiai. ");
INSERT INTO ebk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kenalina us un, ‘Hiyana nan kiapúna ay taynan nan laraki cha amana kan enana ta etepona hi asawana, at munfialincha as us-usa.’ ");
INSERT INTO ebk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Isunga fiakuncha chuwa, ngem kuncha us-usa. Nan nunteponun ngarud Apo Dios at achi koma mun-ichangun chi taku.” ");
INSERT INTO ebk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kenalen nan chiyuycha Fariseo kan hiya, “Mu hiyasa, adchi ngay ngarud t'uy infilin nan Lintig Moises ay mafialin ay umichat nan laraki kan asawana as kasuratan chi nun-ichangancha, hana at epak-ak hi asawana?” ");
INSERT INTO ebk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tinumfor hi Jesus kan chicha, “O, enparufus Moises ay iyichangyu nan asawayu kiapú as nan kenatangken chi numnumyu. Ngem fiakun met assesa nan pangkep Apo Dios as nan laplapuna. ");
INSERT INTO ebk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ifiakiak ngarud kan chakayu ay nan uray ngachana ay laraki ay mangiyichang as asawana omangkiay mu nakelaraki at umiwet mu omasawa hiya as tukún.” ");
INSERT INTO ebk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kenalen nan disipulus kan hiya, “Mu hiyasa payat nan ommat as nan hen-asawa, un-unuyna at ay achita omas-asawa.” ");
INSERT INTO ebk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tinumfor hi Jesus, “Tit-iwa, ngem achi kafiaelan nan am-in ay tataku nan nauy ay sursuru ay achi omasaw-an, ngem kun yangkiay nan chiyuycha nangichatan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tay tukutukún nan kiapón chi achi omasaw-an nan taku. Wachacha nan naiyanak ay kamancha naiblaan, ya nan tapina at iniblaan chi pachongcha ay taku. Nan tapina us at achicha omasawa ta paus-usauncha nan numnumcha as nan munserfiyancha kan Apo Dios henan muntorayana. Nan makafiael ay mangekaman as nan nauy ay sursuru at atuna koma.” ");
INSERT INTO ebk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","As nan namingsan, wacha nan nangiyuy kan Jesus as ongong-a ta epatayna nan limana ya ekararakiana chicha. Senengaran nan disipulusna nan tataku. ");
INSERT INTO ebk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngem kenalen Jesus kan chicha, “Yasa! Pay-anyu ay omali nan ongong-a kan ha-un. Achiyu epawa, tay nan tataku ay maepachong kan chatona ay ongong-a nan maetapi henan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kuna pay enpatay nan limana kan chicha, nak-ak hid-i. ");
INSERT INTO ebk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","As nan namingsan, wacha nan usa ay laraki ay inmuy kan Jesus, ya senarudsudna, “Misturu, ngachana man nan ammay ay masapor ay atok ta mawad-anak as fiyag ay maid patingkiana?” ");
INSERT INTO ebk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kenalen Jesus kan hiya, “Adchi t'uymu sarudsuchun kan ha-un mu ngachana nan ammay? Wacha nan usa yangkiay ay ammay ay hi Apo Dios. Mu laychum ay maetapi as nan fiyag ay maid patingkiana, tongparum nan filfilin Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Ngachan chatud-i ay filfilin?” senarudsudna. “Achika pomatuy, achika umiwet, achika mangakiw, achika munkutum ay muntistigu, ");
INSERT INTO ebk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","rispituwum cha amam kan enam, ya laylaychum nan pachongmu ay taku ay kaman as nan atum ay manglaylayad as achormu,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kenalen nan fumarfiaru kan hiya, “Tenongparku met am-in chaná ay filfilin. Ngachana pay nan masapor ay atok?” ");
INSERT INTO ebk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tinumfor us hi Jesus, “Mu laychum ay maid munkurangam, uymu elaku nan kuk-uwam, ya ichatmu nan lakuna as nan chiyuycha pugli, at wachantu nan kenafiaknangmu ad chaya. Kun pay marpas, unuchunak.” ");
INSERT INTO ebk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kun pay chinngor nan fiarfiaru na, nak-ak ay cha munnunnunungu, tay nafiaknang as solet. ");
INSERT INTO ebk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kenalen Jesus as nan disipulusna, “Ifiakiak kan chakayu nan tit-iwa ay nalikiattu as nan nafiaknang ay taku ay sungkop henan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kasinku kanan un narakraka pay ay lumfot nan kamelio as nan los-ok nan chakum mu nan fiaknang ay sungkop henan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","As nan nanngoran nan disipulus as na, naschaawcha as solet, ya kanancha, “Ngachancha ngay ngarud nan mafialin ay maesarakan?” ");
INSERT INTO ebk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Entoongan Jesus chicha, ya kanana, “Nan tataku at achicha kafiaelan ay mangekaman as na. Ngem hi Apo Dios at kafiaelana nan am-in.” ");
INSERT INTO ebk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Angkiay tinumfor hi Pedro, “Enham! Tenaynanmi nan am-in, ya inmunud kami kan he-a! Ngachana ngay nan gun-gunami?” ");
INSERT INTO ebk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kenalen Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa ay as nan mangepafiaruwantu Apo Dios henan lufong, tomokortu nan Naepadtu ay Anak chi Taku as nan machaychayaw ay tronona. Kun pay chakayu ay hinpuru ya chuwa ay disipulusku at tomokor kayuntu as nan hinpuru ya chuwa ay trono ay mangokóm as nan hinpuru ya chuwa ay tribu ay chicha nan kianak nan an-ak Israel. ");
INSERT INTO ebk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nan ngachana ay nanaynan as afongna, susnúdna, amana, enana, an-akna winnu payyiwna kiapú as nan pammatina kan ha-un at mamen hinkiasottu nan awatuna mu nan fiaror nan tenaynana, ya matawidnantu nan fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngem nan ongor ay omon-ona ad wani at omanongoschantu, ya nan ongor ay omanongos ad wani at omon-onachantu.” ");
INSERT INTO ebk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kenalen pay Jesus, “Nan muntorayan Apo Dios at maepachong as nan usa ay taku ay nunkuwa as nan uma ay natanman as ubas. Finmikiat ya uy nun-anap hiya as munlagfu as nan umana. ");
INSERT INTO ebk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kun pay nakad-an as munlagfuwuna, nakiturag kan chicha ay nan lagfucha as hin-urkiw at usa ay dinario. Angkiay infiaorna chicha ay uy munchunu as umana. ");
INSERT INTO ebk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“As nan mangaurkiw, kasin nun-anap, at inilana nan tapen nan lanaraki ay nangatakchug ay cha munforforakfor as nan mun-el-elakwan. ");
INSERT INTO ebk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Infiakiana kan chicha un, ‘Uy kayu us munchunu as umak, at ichatku nan ustu ay lagfuyu.’ ");
INSERT INTO ebk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Isunga inmuycha. “As nan nunkiawa ya as nan alas tres nan makiayud, kasin pinmitiw hiya, ya assid-i us challu ay uy nun-anap. ");
INSERT INTO ebk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kun pay kiayud alas singko, inmuy kasin as nan mun-el-elakwan, ya ininchanana nan tapina ay nangatakchug ay cha munforforakfor. Senarudsudna kan chicha un, ‘Anuyyu iyur-urkiw ay munforforakfor?’ ");
INSERT INTO ebk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“ ‘Anaka, maid ngamin mangayag kan chakami as munlagfuwanmi,’ ensongfiatcha. “ ‘Ayu ngarud. Uy kayu us munchunu as umak,’ kenalina kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kun pay cha maschum, kenalen nan nunkuwa as nan uma as nan ap-apon nan fiabfiaaruna, ‘Uymu ayakian nan chiyuycha nunlagfu ta ichatmu nan lagfucha. Elapom as nan chiyuycha enmanongos inkiana as nan chiyuycha enmon-ona ay nunlagfu.’ ");
INSERT INTO ebk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Enmali nan chiyuycha nunlagfu as nan kiayud alas singko, at nalagfuwancha as hin-us-a ay dinario. ");
INSERT INTO ebk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Isunga as nan enmaliyan nan chiyuycha enmon-ona ay nunlagfu, namnamauncha ay ong-ongor nan lagfucha. Ngem hin-us-a us challu ay dinario nan enawatcha. ");
INSERT INTO ebk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","As nan nanawatancha as nan lagfucha, nunlilicha as nan nunkuwa as nan uma. Kenalicha, ");
INSERT INTO ebk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Kun usa ay uras yangkiay chi nunchunuwan nan nauycha enmanongos, ya enpachongmu pay laing chi lagfucha kan chakami ay nunchunu as hin-urkiw ya nangiliwas as nunsidla ay atong!’ ");
INSERT INTO ebk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ngem kanana as nan usa kan chicha, ‘Kiayyum, chaanku met senator chakayu. Ay chaanyu inyafud ay usa'y dinario nan lagfuyu as nan hin-urkiw? ");
INSERT INTO ebk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ayu at! Araum nan lagfom, ya komatamka. Laychok challu ay ichat as nan nauycha enmanongos nan kaman as nan inchatku kan he-a. ");
INSERT INTO ebk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ay kun fiakun libfengku ay mangekaman as laychok as nan mismu ay sipingku? Winnu chaka payat omapos kiapú ta achiyak nangekot?’ ” ");
INSERT INTO ebk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Haat iyanongos Jesus, “Isunga nan omanongos ad wani at omon-onantu, ya nan omon-ona ad wani at omanongostu.” ");
INSERT INTO ebk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","As nan cha tumikichan cha Jesus ay umuy ad Jerusalem, ensakikina nan hinpuru ya chuwa ay disipulusna, ya kanana kan chicha, ");
INSERT INTO ebk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Chumngor kayu! Cha takú tumikid ad Jerusalem. Hid-intu ay maipurang nan Naepadtu ay Anak chi Taku as nan anap-apon chi papachi ya as nan chiyuycha mun-isursuru as Lintig. Keddenganchantu hiya ay matuy, ");
INSERT INTO ebk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ya ipurangchantu hiya as nan chiyuycha Gentil ay mangot-otyoktu, mangsapsaplettu ya mangelansantu kan hiya as nan koros. Ngem as nan maekatlu ay urkiw at matakuntu hiya manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Angkiay ya inmuy kan Jesus nan asawan Zebedeo ay kadwana nan chuwa ay an-akna ay lanaraki. Nunpalintumang as nan sangwanan Jesus ya chinawatna kan hiya, “Apo, wacha pay nan chawatok.” ");
INSERT INTO ebk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Senarudsud Jesus kan hiya, “Ngachana ngay nan laychum?” Tinumfor nan fiafiai kan hiya, “As nan tomokram as nan tronom as nan muntorayam, eparufusmu koma ay maketokor nan nauycha chuwa ay an-akku kan he-a: Nan usa at as apét kannawanmu ya nan usa at as apét kannikidmu.” ");
INSERT INTO ebk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ngem tinumfor hi Jesus, “Achiyu ammuy chayu chawchawatun. Ay kafiaelanyu ay mangiliwas as nan likiat ay iliwasku?” “Kafiaelanmi ya,” ensongfiatcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kenalina kan chicha, “Manuwat, tay iliwasyuntu nan likiat ay kaman as nan iliwasku. Ngem fiakunku kalibfengan ay munpili as tomokor as apét kannawanku ya as apét kannikidku, tay chatosa at para as nan chiyuycha nangesasakianaan Amak.” ");
INSERT INTO ebk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kun pay chinngor nan hinpuru ay disipulus nan nauy, finmungatcha as nan hen-aki. ");
INSERT INTO ebk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ngem enayakian Jesus am-in chicha as nan kawad-ana, ya kanana, “Ammuyu met ay nan chiyuycha mangetortoray as nan chiyuycha Gentil at epapeletcha nan laychuncha as nan chacha etortorayan. Nan anap-apucha us at etorayancha chicha. ");
INSERT INTO ebk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Fiakun koma assesa kan chakayu, ngem kun at nan uray ngachana ay manglayad ay munfialin as amud kan chakayu at masapor hiya nan fiabfiaarunyu. ");
INSERT INTO ebk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nan ngachana ay manglayad us ay munfialin as kaamuchan kan chakayu at masapor munfialin as fiabfiaarunyu. ");
INSERT INTO ebk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Uray nan Naepadtu ay Anak chi Taku at chaan enmali ay maserfiyan, ngem kun at munserfi ya ichatna nan fiyagna ta esarakana nan ongor ay tataku.” ");
INSERT INTO ebk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","As nan cha mak-akan cha Jesus ad Jerico, nan ongoongor ay tataku at inmunudcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wacha nan chuwa ay nafurag ay nangatokor as nan olet nan korsa. Kuncha pay chinngor ay cha mar-os hi Jesus, infukiawcha, “Sug-angam man paat chakami, he-a ay Kianak David!” ");
INSERT INTO ebk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Senengaran nan ongor ay tataku chicha, ya chacha ifiakia kan chicha ay kuminakcha koma. Ngem kenaskasincha infukiaw, “Apo, sug-angam man paat chakami, he-a ay Kianak David.” ");
INSERT INTO ebk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Inyawnen kayman Jesus, ya enayakiana chicha, ya kanana, “Ngachana nan laychunyu ay atok kan chakayu?” ");
INSERT INTO ebk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Apo, makaila kami koma,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nasug-ang hi Jesus kan chicha, at kenpana nan matacha. Hiya at chi ya makailacha, ya inmunudcha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kun pay cha maesnop cha Jesus ad Jerusalem, inumchancha ad Betfage henan chuntug ay Olivo. Enpaon-onan Jesus nan chuwa as nan disipulusna, ");
INSERT INTO ebk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ya kanana kan chicha, “Uy kayu henan fiabruy ay sasakiangunyu. Uchananyuntu ay dagus nan hen-ena ay dongki ay naetatakud. Fokatanyu chicha, ya iyaliyu kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mu wachay munsarudsud kan chakayu, kananyuntu un, ‘Masapor nan Apo chicha,’ ya paifiangadnantu challu ay dagus.” ");
INSERT INTO ebk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Enommat na ta matongpar nan infiakian nan pomapadtu ay kanana, ");
INSERT INTO ebk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ifiakiayu as nan tataku ad Jerusalem un, ‘Ilaunyu, cha omali kan chakayu nan ariyu ay napakumbaba ay nunsasakay as nan urfun ay dongki.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Inmuycha nan disipulusna, at enatcha nan infilin Jesus kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inyalicha nan chiyuy hen-ena ay dongki. Inyap-apcha nan chiyuycha kakiaycha as nan uchug nan nauycha animar, ya nunsakay hi Jesus as nan urfun. ");
INSERT INTO ebk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kaongoran as nan tataku hid-i at inyapragcha nan chiyuycha kakiaycha as nan korsa. Nan tapina at senmongpatcha as nan chiyuycha pangan chi kaiw, ya inchapratcha as nan korsa ta epailacha ay chayawuncha hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nan ongoongor ay tataku ay enmon-ona ya nan chiyuycha inmun-unud kan hiya at infugfukiawcha, “Machaychayaw nan Kianak David! Mabendisyonan koma nan omali as nan ngachan nan Apo! Maichaychayaw hi Apo Dios ad chaya!” ");
INSERT INTO ebk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","As nan inumchanan cha Jesus ad Jerusalem, nakuru nan am-in ay umili as chi, ya kanancha, “Ngachan man paat tona?” ");
INSERT INTO ebk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Hi tona hi Jesus ay pomapadtu ay i-Nazaret henan probinsiya ay Galilea,” ensongfiat nan ongor ay tataku ay nakiuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kun pay sinungkop hi Jesus as nan fiattaw nan Templo, enpak-akna nan am-in ay cha mun-el-elaku ya nan cha lomaklaku hid-i. Enlokabfuna nan chiyuycha lamesaan nan chiyuycha cha munsoksokat as siping ya nan totokoran nan chiyuycha cha mun-el-elaku as karopati. ");
INSERT INTO ebk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kenalina kan chicha, “Kanan nan naisurat as nan Kalen Apo Dios un, ‘Nan afongku at makali un munkarkararakian.’ Ngem kunyu at nunfialinun as muntabtafunan chi mangaakiw!” ");
INSERT INTO ebk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Angkiay ya enmalicha nan nafurag ya nan napilud kan Jesus as Templo, at enpaammayna chicha. ");
INSERT INTO ebk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngem nan anap-apon chi papachi ya nan chiyuycha mun-isursuru as Lintig at nunsidlay fungatcha as nan nangil-ancha as nan nakaskaschaaw ay enatna ya as nan ongong-a ay cha mangifugfukiaw as Templo, “Machaychayaw nan Kianak David!” ");
INSERT INTO ebk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kenalicha kan Jesus, “Ay chuchungrum nan cha kankanan chatona?” “O met,” ensongfiat Jesus. “Ay chaanyu finasfiasa nan naisurat as nan Kalen Apo Dios ay kanana un, ‘He-a Apo, isuruwam nan anongong-a ya nan manutun ay mangifiakia as ustuustu ay panagchayaw kan hiya’?” ");
INSERT INTO ebk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Angkiay tenaynan Jesus chicha henan siyudad, at uy inmiyan ad Betania. ");
INSERT INTO ebk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","As nan wiet ay cha munfiangchan cha Jesus ad Jerusalem, nunchukiaang hiya. ");
INSERT INTO ebk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Inilana nan kaiw ay igos as nan olet nan korsa. Inmuy hiya as nan hana kaiw, ya ininchanana ay kun tubtufu yangkiay chi wacha. Angkiay ya kenalina as nan kaiw, “Maidtu poros kasin fugfukiasmu.” Hiya at chi ya narangu nan kaiw ay igos. ");
INSERT INTO ebk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","As nan nangil-an nan disipulusna as chi, naschaawcha as solet, ya kanancha kan Jesus, “Anan enat nan kaiw ay igos ay narangu'y dagus?” ");
INSERT INTO ebk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","“Ifiakiak kan chakayu nan tit-iwa,” ensongfiat Jesus. “Mu wachay pammatiyu ya achi kayu munchuwachuwa, fiakun yangkiay nan enkamanku as nan igos nan maekamanyu, ngem mafialinyu us ay kanan henan nauy chuntug un, ‘Maokwatka ya maichus-orka henan fiayfiay,’ at maekaman tit-iwa. ");
INSERT INTO ebk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nan uray ngachana ay chawatunyu as nan kararagyu at maawatyuntu mu afurotunyu.” ");
INSERT INTO ebk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Angkiay ya nunfiangad hi Jesus as Templo. As nan chana mun-is-isuruwan, enmali kan hiya nan anap-apon chi papachi ya nan anam-amá. Senarudsudcha, “Anan nurpuwan man nan kalibfengam ay mangekaman kan chatona? Ngachana nan nangichat kan he-a as nan nauy ay kalibfengan?” ");
INSERT INTO ebk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tinumfor hi Jesus kan chicha, “Wacha us nan usa'y sarudsuchok kan chakayu. Mu masongfiatanyu, ifiakiaktu kan chakayu nan nurpuwan nan kalibfengak ay mangekamkaman kan chatona. ");
INSERT INTO ebk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ay chaud pay nan nurpuwan nan kalibfengan Juan ay munfunyag? Ay nurpu kan Apo Dios winnu as nan tataku?” Angkiay kenalicha ay maaapat, “Mu kanan takú un, ‘Nurpu kan Apo Dios,’ kananantu kan chitaku un, ‘Anuyyu ngarud chaan enafurot hiya?’ ");
INSERT INTO ebk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ngem mu kanan takú un, ‘Nurpu as nan tataku,’ umugyat takú met as nan atun nan ongoongor ay tataku, tay afurotuncha am-in ay hi Juan at usa ay pomapadtu.” ");
INSERT INTO ebk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Isunga tinumforcha kan Jesus, “Tuan! Achimi ammu.” Kenalen us Jesus, “Mu hiyasa, achek us ngarud ifiakia kan chakayu mu ngachana nan nunkalibfengan as nan chak mangekamkamanan kan chatona.” ");
INSERT INTO ebk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Infiakian Jesus nan nauy ay maepadpachongan kan chicha: “Ngachana nan munnunumnumyu's na? Wacha nan usa ay ama ay chuwa nan pototna. Inmuy hiya as nan panguru, ya kanana, ‘Anak, somepotka ad wani as uma ay naetanman chi ubas o?’ ");
INSERT INTO ebk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“ ‘Annaw,’ ensongfiatna. Ngem kun pay naaw-awni, nunfialiw nan numnumna, at senmepot challu. ");
INSERT INTO ebk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Angkiay ya inmuy nan chiyuy ama as nan enauchi, ya assid-i us challu nan infiakiana. Kenalen nan enauchi un, ‘O pay, Ama.’ Ngem chaan inmuy. ");
INSERT INTO ebk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ngachana kan chatud-i ay chuwa nan nangtongpar as nan laychun amacha?” “Nan panguru,” ensongfiatcha. Kenalen Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa. Nan chiyuycha mangam-among as fiaror ya nan fianafiai ay mangepabpafiayad as achorcha at chicha nan mangon-ona ay uy maetapi henan muntorayan Apo Dios mu chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tay enmali hi Juan ay Fumufunyag ay mangisuru kan chakayu as nan nalintig ay panagfiyag, ya kunyu chaan enafurot hiya. Ngem nan chiyuycha mangam-among as fiaror ya fianafiai ay mangepabpafiayad as achorcha nan enmafurot kan hiya. Uray as nan narpasan nan nangil-anyu as nan enmafurotancha, chaan kayu pay laing nunfiafiawi ya enmafurot kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Chungrunyu nan usa pay ay maepadpachongan. Wacha nan usa ay taku ay nuntanum as ongor ay ubasas umana. Enaradna nan naliwus, ya nunkaub as munkopkopran as ubas. Nun-amma us as nangatungatu ay fiawen nan munfianfiantay as nan umana. Kun pay narpas sa, enpaammana as nan chiyuycha mun-uumauna. Angkiay ya nunfiaat henan achawwi ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kun pay inumchan nan timpon chi munpurasan, infiaorna nan chiyuycha fiabfiaaruna as nan chiyuycha nun-uumauna ta uycha araun nan ubas ay kudwan nan amocha. ");
INSERT INTO ebk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngem lenabkis nan chiyuycha nun-uumauna chicha. Senaplesapletcha nan usa, penatuycha nan usa, ya lenomtalomtakcha nan usa. ");
INSERT INTO ebk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kasin inmifiaor hiya as tapina ay ong-ongor ay fiabfiaaruna mu nan enmona, ngem assid-i us challu nan enatcha kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","As nan anongosna, infiaorna nan mismu ay anakna kan chicha, tay kanana as numnumna un, ‘Siguradu ay mafiainchantu as nan mismu ay anakku.’ ");
INSERT INTO ebk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ngem kun pay inilan nan chiyuycha nun-uumauna nan mismu ay anakna, kenalicha un, ‘Nauy nan mangetawid as nan uumaun takú ay natanman as ubas. Akayu! Patayun takú hiya ta kuwaun takú nan tawidna.’ ");
INSERT INTO ebk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","As nan hiyachi, lenabkischa hiya. Inchus-orcha as nan fiakun sakop nan uma ay natanman as ubas ya penatuycha.” ");
INSERT INTO ebk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Senarudsud Jesus, “Mu hiyasa, as nan munfiangchan nan nakin kuwa as nan uma ay natatanman as ubas, ngachanantu ngun nan atuna as nan chiyuycha nun-uumauna?” ");
INSERT INTO ebk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tinumforcha, “Ya kakun kauugyat nan atunantu ay mangpatuy as nan chiyuycha manangotettet ay tataku. Angkiay ya enpaaywana nan umana ay natatanman as ubas as nan tukún ay mangichat as nan ustu ay kudwana as nan timpon nan munpurasancha.” ");
INSERT INTO ebk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kenalen Jesus kan chicha, “Ay chaanyu poros finasfiasa nan naisurat as nan Kalen Apo Dios? Kanana un, ‘Nan chiyuy fiatu ay enachen nan chiyuycha muntuptuping at hiya nan nunfialin as kaamuchan ay maipugnad. Hiyana nan enat nan Apo, ya anuy paat nakaskaschaaw sa as nan mangiila takú!’ ");
INSERT INTO ebk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Isunga kiapú ta enachiyak, ifiakiak kan chakayu ay achi kayuntu maetapi henan muntorayan Apo Dios, ngem kun at nan chiyuycha mangekamkaman as nan laychok nan maetapi. ");
INSERT INTO ebk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nan mag-as as nan nauy ay fiatu at mapet-apet-ang. Ngem kun pay mag-as nan hana ay fiatu as nan kumpurmi at kimokunantu nan hana mag-asana.” ");
INSERT INTO ebk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kun pay chinngor nan anap-apon chi papachi ya nan chiyuycha Fariseo nan nauy maepadpachongan ay infiakian Jesus, naawatancha ay maepangkep kan chicha nan chana kankanan. ");
INSERT INTO ebk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","As nan hiyachi, penachascha ay mangtiliw hiya, inmugyatcha as nan ongoongor ay tataku, tay infilangcha hiya as usa ay pomapadtu. ");
INSERT INTO ebk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kasin nun-epadpachong hi Jesus as nan tataku, ");
INSERT INTO ebk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nan muntorayan Apo Dios at maepachong as nan usa ay ari ay nunsakiana as nan chuyas nan pototna ay laraki. ");
INSERT INTO ebk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kun pay naesakiana am-in, inmifiaor hiya as nan chiyuycha fiabfiaaruna ay uy mangayag as nan chiyuycha naayakian ay makichuyas. Ngem nan chiyuycha naayakian at chaancha lenayad ay omali. ");
INSERT INTO ebk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kasin inmifiaor as nan tapina ay fiabfiaaruna ta uycha ifiakia as nan chiyuycha naayakian un, ‘Akayu! Naesakiana at nan am-in. Naparti at nan fiakami ya nan nunkarukmog ay urfun ay fiakami. O, omali kayu ay makichuyas!’ ");
INSERT INTO ebk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngem chaan penakian-anon nan chiyuycha naayakian, at inturuycha nan sikud ay chacha at-atun. Nan usa at senmepot, ya nan usa us at uy nun-elaku. ");
INSERT INTO ebk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kun pay nan tapina at lenabkischa nan chiyuycha fiabfiaarun nan ari. Penalikiatcha pay as solet chicha, ya penatuycha. ");
INSERT INTO ebk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nunsidlay fungat nan ari as nan nangchamakiana as nan enommat. As nan hiyachi, infiaorna nan sosorchachuna, at penatuycha nan chiyuycha pomapatuy ya pinuorancha nan siyudadcha. ");
INSERT INTO ebk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Angkiay ya kenalen nan ari as nan tapina'y fiabfiaaruna, ‘Naesasakiana nan am-in as nan nauy ay chuyas, ngem nan tataku ay enayakiak at achicha maekari ay omali. ");
INSERT INTO ebk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Uy kayu as nan chiyuycha wuliwor ay korsa ya ayakianyu nan am-in ay tataku ay uchananyu hid-i ta makichuyascha.’ ");
INSERT INTO ebk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Isunga inmuycha tit-iwa as nan chiyuycha korsa, ya enamongcha nan am-in ay tataku ay inuchanancha ay ammay ya uray mangotettet. As nan hiyachi, napnu as tataku nan afong nan chumuyas. ");
INSERT INTO ebk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ngem kun pay sinungkop nan ari ay uy mangila as nan chiyuycha naayakian, inilana hid-i nan usa ay taku ay chaan nunfiafiachu as fiachon chi makichuyas. ");
INSERT INTO ebk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Kiayyum,’ kenalen nan ari kan hiya, ‘anan enatmu ay sinungkop as na ay chaan nunfiafiachu as fiachon chi makichuyas?’ Kun kinkinak nan taku ay anchi. ");
INSERT INTO ebk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Angkiay kenalen nan ari as nan chiyuycha fiabfiaaruna un, ‘Fiaruchunyu nan limana ya sukina, ya ichus-oryu hiya as chará ay kawad-an nan ngongot. Hid-i nan mun-ag-akoranantu ya munngengesatantu nan fiab-ana kiapú as fungatna.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Inyanongos Jesus, “Ongor nan naayakian ay maetapi henan muntorayan Apo Dios, ngem akét nan napili.” ");
INSERT INTO ebk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Angkiay ya nak-ak nan chiyuycha Fariseo, ya uycha nuntuturag mu anan atuncha ay manikap kan hiya babaen as nan sarudsudcha ta wachay mangicharumancha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Infiaorcha nan tapina ay disipuluscha ay Fariseo ay kadwacha nan papasorot Ari Herodes ta umuycha kan Jesus. Kuncha pay inumchan kan hiya, kenalicha, “Misturu, ammumi ay tit-iwa nan am-in ay kanam. Ammumi us ay isurom nan tit-iwa ay laychun Apo Dios ay atun nan tataku. Mapapchong nan atum as nan am-in ay tataku, tay achim ifilang nan kasasaadcha. ");
INSERT INTO ebk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Isunga ifiakiam pay ngarud kan chakami nan munnunumnummu's na: Ay eparufus nan Lintig takú ay munfiayad kami as fiaror kan Emperador winnu achi?” ");
INSERT INTO ebk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngem aammon Jesus nan mangotettet ay pangkepcha, isunga kenalina, “Chakayu ay pakamankaman, adchi t'uyak chischistingun? ");
INSERT INTO ebk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ud-a, omepaila kayu kan ha-un as siping ay ifiarfiaroryu.” Inyalicha kan hiya nan usa ay silsilyu. ");
INSERT INTO ebk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Senarudsudna kan chicha, “Ngachana nan nakin lupa ya nakin ngachan as na?” ");
INSERT INTO ebk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Hi Emperador,” ensongfiatcha. Angkiay kenalen Jesus kan chicha, “Mu hiyasa ngarud, ichatyu kan Emperador nan kuk-uwan Emperador, ya ichatyu us kan Apo Dios nan kuk-uwan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","As nan nanngorancha's na, naschaawcha as solet. Angkiay ya tenaynancha hiya, at kenmatamcha. ");
INSERT INTO ebk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","As nan hiyasa challu ay urkiw, inmuycha kan Jesus nan tapen nan Saduseo. Chicha nan bunggoy chi Judio ay mangali un achi mataku nan natuy manipud as nan utúy. Senarudsudcha kan hiya, ");
INSERT INTO ebk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Misturu, kenalen met Moises un, ‘Mu wachay hen-asawa ay maid anakcha ya matuy nan laraki, masapor asaw-un nan sunúd nan laraki nan naellakas ta mu wachay anakcha at maifilangtu nan onga as potot nan chiyuy natuy ay sunúdna.’ ");
INSERT INTO ebk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wachacha met nan pitu ay hen-anag-i ay lanaraki as nan kawad-anmi. Enmasawa nan panguru, at natuy. Kiapú ta maid enpototna, enasawan nan utub nan naellakas. ");
INSERT INTO ebk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Natuy us hiya ay maid enpototna. Assid-i us challu as nan maekatlu inkiana as nan maekapitu. ");
INSERT INTO ebk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kuncha pay natuy am-in, natuy nan fiafiai. ");
INSERT INTO ebk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","As nan urkiw ay matakuwan nan nunkatuy manipud as nan utúy, ngachana ngay as nan pitu nan nakin asawa as nan chiyuy fiafiai, tay enasawacha met am-in hiya?” ");
INSERT INTO ebk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tinumfor hi Jesus kan chicha, “Kenomsaw kayu tit-iwa, tay achiyu maawatan nan maepangkep as nan Kalen Apo Dios, ya achiyu us maawatan nan pannakafialina. ");
INSERT INTO ebk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tay as nan matakuwan manipud as nan utúy nan nunkatuy, achicha mun-eennasawa, ngem kuncha at maepachong as nan angheles Apo Dios ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mu maepangkep as nan matakuwan nan nunkatuy manipud as nan utúy, ay chaanyu finasfiasa nan infiakian Apo Dios kan chakayu? Kanana un, ");
INSERT INTO ebk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ha-un nan Dios Abraham, nan Dios Isaac ya nan Dios Jacob.’Nan laychun tona ay kanan at hiya nan Dios nan natataku, fiakun nan nunkatuy.” ");
INSERT INTO ebk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","As nan nanngoran nan ongoongor ay tataku as na, naschaawcha as solet as nan insursuruna. ");
INSERT INTO ebk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kun pay chinngor nan chiyuycha Fariseo ay senom-or Jesus nan chiyuycha Saduseo, naamongcha. ");
INSERT INTO ebk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nan usa kan chicha ay naraing as nan maepangkep as nan chiyuycha lintig ay insurat Moises at nunsarudsud ay manisting kan Jesus, ");
INSERT INTO ebk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Misturu, ngachana man nan kaamuchan ay filin as nan Lintig takú?” ");
INSERT INTO ebk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tinumfor hi Jesus, “‘Masapor laylaychum nan Apo ay Diosmu as nan am-in ay pusom, as nan am-in ay lenawam ya as nan am-in ay numnummu.’ ");
INSERT INTO ebk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hiyana nan kaamuchan ya omona ay lintig Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nan maekadwa ay kaamuchan ay maepachong as nan omona at hiyana: ‘Masapor laylaychum nan pachongmu ay taku ay kaman as nan atum ay manglaylayad as achormu.’ ");
INSERT INTO ebk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nan nauycha chuwa ay filin at chicha nan maifisaran nan am-in ay Lintig Moises ya nan insursuron nan chiyuycha pomapadtu.” ");
INSERT INTO ebk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kun pay naamong nan chiyuycha Fariseo, senarudsud Jesus kan chicha, ");
INSERT INTO ebk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ngachana nan munnunumnumyu as nan maepangkep as nan Cristo? Ngachanay nakin kianak kan hiya?” “Kianak David hiya,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Senarudsud Jesus kan chicha, “Mu hiyasa, adchi pay ngarud t'uy enpaifiaag nan Espiriton Apo Dios kan David ay awakiana hi Cristo as ‘Apo’? Infiakian David un, ");
INSERT INTO ebk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kenalen nan Apo as nan Apok un, “Tomokorka as apét kannawanku inkiana amisok nan chiyuycha kafusormu.” ’ ” ");
INSERT INTO ebk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kenalen pay Jesus, “Mu hiyasa ngarud ay ‘Apo’ nan pang-awag David kan Cristo, anuyna ngay atun ay kianak David hi Cristo?” ");
INSERT INTO ebk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Maid poros makasongfiat kan Jesus, ya nunlapu as nan hana ay urkiw, maid nakaiturud ay nunsarudsud kasin kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Angkiay ya kenalen Jesus as nan ongoongor ay tataku ya as nan disipulusna, ");
INSERT INTO ebk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nan chiyuycha mun-isursuru as Lintig ya nan chiyuycha Fariseo at wachay kalibfengancha ay mangepakaawat as nan Lintig Moises. ");
INSERT INTO ebk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Isunga masapor tongparunyu ya atunyu nan am-in ay ifiakiacha. Ngem achiyu turturachun nan chacha at-atun, tay achicha cha atun nan chacha ekaskasaba. ");
INSERT INTO ebk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Chacha epadpad-un as nan tataku nan linlintig ay achicha kafiaelan. Ngem uray mu hiyasa, achicha met uyachun chi uray us-usa paat ay kiayyamotcha ay fumachang kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Am-in nan chacha at-atun at atuncha yangkiay ta ilaun nan tataku chicha. Paaad-achauncha nan kaman mait-ittuwan chi kispuru ay mangittuwancha as nan tapen nan naisurat ay lintig Apo Dios ay ifiafiarudcha as ketongcha ya as takraycha.Chacha us paanchuanchuwun chi ipay nan kiayachan nan kakiaycha ta epailacha nan kenaamudcha. ");
INSERT INTO ebk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Laylaychuncha nan chiyuycha tokoran chi mafigfigfig, ya nan chiyuycha kaammayan ay tokoran as tomoktokrancha as nan chiyuycha senagoga. ");
INSERT INTO ebk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Laylaychuncha ay cha risrispituwun nan tataku chicha as nan chiyuycha mun-el-elakwan, ya laylaychuncha us ay aw-awakian nan tataku chicha as ‘Misturu’. ");
INSERT INTO ebk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ngem chakayu at achiyu iyafud ay maawakian kayu as ‘Misturu,’ tay usa yangkiay nan misturuyu, ya kaman kayu hen-anag-i am-in. ");
INSERT INTO ebk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Maid aw-awakianyu asna's luta as ‘Ama,’ tay kun usa nan Amayu ay hiya nan wacha ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Achiyu us iyafud ay maawakian kayu as ‘Apo,’ tay hi Cristo yangkiay nan Apo. ");
INSERT INTO ebk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nan kaamuchan kan chakayu at masapor hiya nan fiabfiaarunyu. ");
INSERT INTO ebk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nan ngachana ay mangepangatu as achorna at maepababantu. Ngem nan mangepababa as achorna at maepangatuntu.” ");
INSERT INTO ebk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kenalen pay Jesus, “Kasusug-ang kayu ay mun-isursuru as Lintig ya Fariseo! Pakamankaman kayu, tay iniin-ubyu nan sungkopan koma nan tataku henan muntorayan Apo Dios. Chakayu ay mismu at achi kayu sungkop, ya achiyu pay eparufus ay sungkop nan chiyuycha manglayad ay sungkop hid-i.” ");
INSERT INTO ebk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kasusug-ang kayu ay mun-isursuru as Lintig ya Fariseo! Pakamankaman kayu, tay isikapanyu ay manguwa as nan ab-afong nan eellakas, ya paanchuanchuwunyu nan kararagyu ta ilaun nan tataku ay ammay kayu. Isunga naliglikiattu nan chusayu! ");
INSERT INTO ebk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kasusug-ang kayu ay mun-isursuru as Lintig ya Fariseo! Pakamankaman kayu, tay kudngunyu nan fiayfiay, ya umuy kayu henan achawwi ay nasnasyon ta uy kayu omawis as uray usa ay munfialin as pasorotyu. Kun pay wachay usa ay umunud, munfialinunyu as kaskasin maifilang ay umuy ad inferno mu chakayu! ");
INSERT INTO ebk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kasusug-ang kayu, chakayu ay maepachong as nan nunkafurag ay mangepangpangu as nan tataku! Chayu isuru un, ‘Achi kis-an tongparun nan esapata mu osarun nan Templo as nan munsapataan. Ngem mu osarun nan fialetok as nan Templo as nan munsapataan, masapor ay tongparun.’ ");
INSERT INTO ebk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Chakayu ay nunkangokngok ay nafurag! Ngachana nan am-amud kan Apo Dios, ay nan fialetok winnu nan Templo ay hiya nan mangepasanto as nan fialetok? ");
INSERT INTO ebk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Isursuruyu pay un, ‘Nan mangosar as nan altar as nan munsapataana at uray ud-ay achina tongparun nan ensapatana. Ngem mu osaruna nan chaton as nan altar as nan munsapataana, masapor tongparuna.’ ");
INSERT INTO ebk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nunkafurag kayu tit-iwa as solet! Ngachana nan am-amud kan Apo Dios, ay nan maichaton winnu nan altar ay mangepasanto as nan maichaton? ");
INSERT INTO ebk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Isunga nan mangosar as nan altar as nan munsapataana at osaruna sa ya nan am-in ay naepatang hesa as nan munsapataana. ");
INSERT INTO ebk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kaman us as nan mangosar as nan Templo as nan munsapataana at osaruna sa ya hi Apo Dios ay mamagyan hesa as nan munsapataana. ");
INSERT INTO ebk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nan mangosar ad chaya as nan munsapataana at osaruna us challu nan tronon Apo Dios ya nan tenmotokor hid-i. ");
INSERT INTO ebk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kasusug-ang kayu ay mun-isursuru as Lintig ya Fariseo! Pakamankaman kayu, tay ichatonyu tit-iwa nan pagkapuron nan apetyu ay kaman as nan chiyuycha mangepaammay as machangchang,ngem enganuyyu met nan chiyuycha tit-iwa ay amud ay sursuron nan Lintig ay kaman as nan munfialinanyu as nalintig, manangsug-ang ya matalek. Chatona nan masapor ay atunyu, ya achiyu challu enganuy ay mangekaman as nan tapina. ");
INSERT INTO ebk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Chakayu ay maepachong as nan nunkafurag ay mangepangpangu as nan tataku, paatyu makailaun ay ustu nan achi amud! Kenomsaw kayu, tay maepachong kayu as nan taku ay paat mangsakiat as emok as nan ikopuna, ngem maokmona met chi kamelio! ");
INSERT INTO ebk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kasusug-ang kayu ay mun-isursuru as Lintig ya Fariseo! Pakamankaman kayu, tay maepachong kayu as nan taku ay manguras as nan luwar yangkiay nan tasa ya paratu. Ngem nan numnumyu met at napnu as kenaakum ya kenangekot. ");
INSERT INTO ebk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Chakayu ay Fariseo ay kaman nunkafurag! Urasanyu on-ona nan lukaw nan tasa ya paratu at maurasantu us nan luwarcha. ");
INSERT INTO ebk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kasusug-ang kayu ay mun-isursuru as Lintig ya Fariseo! Pakamankaman kayu, tay maepachong kayu as nan chiyuycha lufok ay napentoran as munpupukaw ay am-ammay chi ilacha. Ngem ad chur-umcha at napnucha as tong-or ya nunkabrok ay achor chi nunkatuy. ");
INSERT INTO ebk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hiya us sa kan chakayu ay kaman nalintig as nan mangiilan nan tataku. Ngem nan numnumyu at napnu as kenapakamankaman ya kenamananglabsing.” ");
INSERT INTO ebk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kenalen pay Jesus, “Kasusug-ang kayu ay mun-isursuru as Lintig ya Fariseo! Pakamankaman kayu, tay iyammaanyu as anam-ammay ay lufok nan chiyuycha pomapadtu ad pus-uy ay penatuy nan kaap-uwanyu, ya arkosanyu nan chiyuycha lufok nan nunkalintig ay tataku. ");
INSERT INTO ebk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kananyu pay un, ‘Mu kun kami natataku as nan timpon nan chiyuycha kaap-uwanmi at chaan kami koma naetapi as nan namatuyancha as nan chiyuycha pomapadtu.’ ");
INSERT INTO ebk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ngem kiapú ta assesa nan kenaliyu, inyafudyu ay kianak chakayu as nan chiyuycha namatuy kan chatud-i ay pomapadtu. ");
INSERT INTO ebk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ayu ngarud, lopasunyu ay mangekaman as nan fiasor ay enlalapon nan kaap-uwanyu! ");
INSERT INTO ebk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Chakayu ay maepachong as nan urug ya an-ak chi kubra ay nunkasikap! Anan atunyu ay makalisi as nan chusayu ad inferno? ");
INSERT INTO ebk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Isunga ifiaorku kan chakayu nan chiyuycha pomapadtu ya mamasilib ay tataku ya nan chiyuycha mun-isursuru as nan Kalen Apo Dios. Patayunyuntu nan tapina kan chicha, ya elansayuntu as nan koros nan tapina. Sapsapletunyu nan tapina as nan chiyuycha senagogayu, ya chugchukunyuntu chicha henan il-ili. ");
INSERT INTO ebk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Isunga machusa kayu kiapú as nan namatuyanyu as nan am-in ay nalintig ay tataku asna's luta nunlapu as nan natuyan Abel ay nalintig inkiana as nan natuyan Zacarias ay potot Barakias ay penatuyyu as nan nunkiakiaw-an nan kuwartu as Templo ya nan altar. ");
INSERT INTO ebk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ifiakiak kan chakayu nan tit-iwa ay machusantu nan tataku ad wani kiapú as nan napatuyan chatona am-in.” ");
INSERT INTO ebk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kenalen Jesus, “Chakayu ay i-Jerusalem, penatuyyu nan chiyuycha pomapadtu, ya lenomtakyu nan chiyuycha infiaor Apo Dios kan chakayu. Namen kaat ay lenarayadku ay mang-among kan chakayu am-in ay kaman as nan atun nan mangngak ay mangesakub as enpasna, ya kunyu paat achi laychun. ");
INSERT INTO ebk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Il-ilaunyu! Nataynan ya naenganuy nan siyudadyu. ");
INSERT INTO ebk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ifiakiak kan chakayu, achiyaktu kasin il-ilaun inkiana as nan timpu ay mangaliyanyu un, ‘Maichaychayaw koma nan omali ay infiaor Apo Dios.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pinmitiw hi Jesus as nan Templo. As nan chana mak-akan, naesnop nan disipulusna kan hiya, ya tinugkiawcha kan hiya nan chiyuycha anam-ammay ay nakiaub as fiatu as nan kawad-an nan Templo. ");
INSERT INTO ebk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kenalen Jesus kan chicha, “O, iilaunyu met am-in chaná! Ifiakiak kan chakayu nan tit-iwa ay maidtu mayagyag as uray usa ay fiatu as nan naesasad-ana, tay kuncha am-in maikur-ub.” ");
INSERT INTO ebk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","As nan nangatokoran Jesus henan chuntug ay Olivo, enmali nan disipulus kan hiya ay chidchicha yangkiay. Kenalicha, “Ifiakiam pay kan chakami mu kaatna nan ommatantu tona, ya ngachanantu nan sinyar nan omaliyam ya nan anongos ay urkiw.” ");
INSERT INTO ebk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tinumfor hi Jesus kan chicha, “Il-ilaunyu ta maid mangar-allilaw kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tay ongortu nan tataku ay omali ay mangosar as nan ngachanku ay mangarkali un, ‘Ha-un nan Cristo,’ ya ongortu nan allilawuncha ay tataku. ");
INSERT INTO ebk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Chungrunyuntu nan kanikong chi kukufiat ya chamag maepangkep as kukufiat henan achawwi ay luglukiar. Ilaunyu ta achi kayu machanakian. Masapor challu ommat chaná, ngem fiakun pay hiyasa nan anongos ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tay munkikinnufiattu nan chiyuycha nasyon, ya kaman us nan chiyuycha muntorayan. Wachachantu chi fitel ya kichu henan tukutukún ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ngem chatona am-in nan laplapon chi likiat ay kaman as nan munpasikaran chi omanak. ");
INSERT INTO ebk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“As nan hiyachi, wachachantu nan mangicharum kan chakayu ta palikiatun ya patayun chakayu. Inglun chakayuntu as nan am-in ay tataku kiapú as nan pammatiyu kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","As nan timpu ay anchi at ongorchantu nan mankug as pammaticha. Munsesennepsepcha ya mun-iinningorcha. ");
INSERT INTO ebk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ongorchantu us nan munpaila ay achi tit-iwa ay pomapadtu, ya ongortu nan allilawuncha. ");
INSERT INTO ebk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kiapú as nan enmongoran chi kenamangotettet, omak-akét chi layad nan ongor ay tataku. ");
INSERT INTO ebk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngem nan taku ay mangan-anos ay omafurot inkiana as nan anongos at maesarakantu. ");
INSERT INTO ebk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nan nauy Ammay ay Chamag maepangkep henan muntorayan Apo Dios at maekasaba as nan am-in ay tataku asna's luta ay munserfi as pammaneknek kan chicha. Angkiay ya omalintu nan munpatingkiaan chi lufong.” ");
INSERT INTO ebk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kenalen pay Jesus, “Isunga as nan mangil-anyuntu as nan ‘Kauugyat ay Chumachael’ ay tenmatakchug as nan nasantowan ay lukiar ay hiya nan infiakian Daniel ay pomapadtu, (Nan mamasa as na at masapor maawatana nan laychun tona ay kanan.) ");
INSERT INTO ebk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nan umiili ad Judea at masapor lomayawcha ay umuy henan chiyuycha chuntug. ");
INSERT INTO ebk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nan taku ay wacha as tabfongan nan afongna at achi masapor chumayyu ay mangara as kinakuna as fiaruy. ");
INSERT INTO ebk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nan senmepot at achi masapor somaor ay mangara as kakiayna. ");
INSERT INTO ebk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kasusug-angtu kayman nan chiyuycha masisikug ya nan cha munpasusu as nan hanacha ay urkiw! ");
INSERT INTO ebk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ekararagyu kan Apo Dios ta achi paat maiyaspor nan lomayawanyu as nan chinamuy winnu as nan Urkiw ay Mun-iblayan. ");
INSERT INTO ebk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tay as nan hana ay timpu, omalintu nan nunsidla ay likiat ay maid maepachongana nunlapu as nan nafiayangan nan lufong inkiana ad wani, ya achintu kasin om-ommat. Maidtu om-ommat as assena as tapen chi urkiw. ");
INSERT INTO ebk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mu achi henkemachun Apo Dios nan hanacha ay urkiw ay munlikiatan, maidtu maesarakan ay matataku. Ngem kiapú as nan pinilina ay tatakuna, henkemachuna nan hanacha ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Angkiay ya mu wachay mangarkali kan chakayu un, ‘Ilaunyu! Nauy nan Cristo!’ winnu ‘Chiyuy hiya!’ at achiyu ab-afurotun. ");
INSERT INTO ebk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tay munpailachantu nan chiyuycha achi tit-iwa ay Cristo ya achi tit-iwa ay pomapadtu. Omepappailachantu as ongor ay nakaskaschaaw ay sinyar ya milagro ta mu mafialin at allilawuncha uray nan tataku ay pinilen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Il-ilaunyu, tay infiafiakiak met at kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Isunga mu kanancha un, ‘Ilaunyu at chiyuy hi Cristo henan disyerto,’ achi kayu um-umuy hid-i. Mu kanancha un, ‘Ilaunyu at nauy hiya asna's fiaruy,’ achiyu ab-afurotun. ");
INSERT INTO ebk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tay kaman as nan machiyatan nan fiakilat as nan fomokfoknakian nan urkiw ya silawana inkiana as nan mauy-uynuwan nan urkiw at assid-i us nan omaliyan nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","O, matongpartu chaná ay kaman as nan kanancha un, ‘Mu ay chaud nan kawad-an nan natuy at hid-i us nan maamongan nan chiyuycha kossel ay mangkakan as achor ay natuy.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kun pay marpas nan chiyuycha likiat as nan hanacha ay timpu, ngomongottu ay dagus nan urkiw, ya achintu somorag nan furan. Nan chiyuycha taraw ad chaya at mag-aschantu, ya achintu manongnong chi aatun nan am-in ay wacha ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Angkiay ya mailantu ad chaya nan sinyar nan omaliyan nan Naepadtu ay Anak chi Taku, ya mun-akorchantu nan am-in ay tataku asna's luta. Ilaunchantu nan Naepadtu ay Anak chi Taku ay cha omali ay wachay ongor ay pannakafialina ya kaichayawana ay maetatapi as nan chiyuycha lifuu ay murpu ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kun pay kumangos nan tarampet as napigsa, ifiaornantu nan anghelesna ay uy mang-among as nan tataku ay pinilen Apo Dios henan uray ay chaud ay lukiar ay kawad-ancha.” ");
INSERT INTO ebk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kenalen pay Jesus, “Suruwunyu koma nan maepadpachongan maepangkep as nan kaiw ay igos. As nan somalipingan nan kaiw ay igos ya maforongan, ammuyu at ay kiayud chakun. ");
INSERT INTO ebk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hiyasa us ay as nan mangil-anyu ay cha om-ommat chaná at ammuyuntu ay kiayud at nan omaliyana ay kaman wacha hiya as nan pantiw. ");
INSERT INTO ebk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ifiakiak kan chakayu nan tit-iwa. Wachacha pay nan tapen nan tataku ad wani ay timpu ay matataku pay as nan ommatantu chatona am-in ay infiakiak. ");
INSERT INTO ebk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mamaidtu nan chaya ya luta, ngem achintu poros mamaid nan kalek.” ");
INSERT INTO ebk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kenalen us Jesus, “Maid mangammu as nan urkiw ya uras ay ommatantu chatona ay infiakiak. Uray nan angheles ad chaya winnu nan Anak Apo Dios at achicha ammu, ngem kun yangkiay nan Ama. ");
INSERT INTO ebk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kaman as nan ukialen nan tataku as nan timpon Noe at assid-intu us nan ukialen nan tataku as nan omaliyan nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tay as nan hana ay timpu ay chaan pay napsongan nan intiru ay luta, cha mangmangan, cha umig-ikop, ya cha maas-asawa nan tataku inkiana as nan urkiw ay nunlukianan cha Noe as nan papor. ");
INSERT INTO ebk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Chaancha naammuwan nan ommattu kan chicha inkiana napsong nan luta ya nurningcha am-in. Assid-i us nan ommattu as nan omaliyan nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","As nan hiyachi, wachachantu nan chuwa ay lanaraki as payyiw. Maarantu nan usa ya mayagyag nan usa. ");
INSERT INTO ebk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wachachantu nan chuwa ay fianafiai ay cha munfiayu. Maarantu nan usa ya mayagyag nan usa. ");
INSERT INTO ebk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Isunga munsasakiana kayu, tay achiyu ammu nan urkiw ay omaliyan nan Apoyu. ");
INSERT INTO ebk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Ngem numnumunyu na: Mu aammon nan nakin afong nan uras as nan lafi ay omaliyan nan mangaakiw, siguradu ay fiantayana nan afongna ya achina eparufus ay sugpun nan mangaakiw. ");
INSERT INTO ebk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Isunga assesa us koma kan chakayu ay masapor nakasakiana kayu, tay omali nan Naepadtu ay Anak chi Taku as nan uras ay achiyu namnamaun.” ");
INSERT INTO ebk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nun-epadpachong pay hi Jesus. Kenalina, “Ngachana ngarud nan matalek ya masilib ay mafiabfiaor? Hiya nan nangichatan nan amona as kalibfengan ay mun-aywan as nan kakadwana ay mafiabfiaor, ya hiya nan mangiwaras as kanuncha as nan ustu ay timpon chi manganancha? ");
INSERT INTO ebk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nakiasat paat sa ay mafiabfiaor as nan komataman nan amona ya asporana hiya ay cha mangekaman as nan infilina. ");
INSERT INTO ebk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ifiakiak kan chakayu nan tit-iwa ay kan tosa ay mafiabfiaor nan mangichatantu nan amona as nan kalibfengan ay mun-aywan as nan am-in ay kuk-uwana. ");
INSERT INTO ebk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ngem mu nan hana mafiabfiaor ay mangotettet chi ukialina at kanana as numnumna un, ‘Uy at man mafiayag ay munfiangad nan amok.’ ");
INSERT INTO ebk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Angkiay ya elapuna ay manoprat as nan kakadwana ay mafiabfiaor, ya cha uy makekkekan ya makiig-ikop as nan fianuttang. ");
INSERT INTO ebk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","As nan komataman nan amona as nan urkiw ay achina namnamaun ya uras ay achina ammu, ");
INSERT INTO ebk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","chusauntu nan amona hiya. Hana at etapi hiya as nan chiyuycha pakamankaman. Hid-i nan mun-ag-akorantu nan tataku ya munngesngesatantu chi fiab-acha kiapú as fungatcha.” ");
INSERT INTO ebk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nun-epadpachong kasin hi Jesus. Kenalina, “Nan muntorayan Apo Dios at maepachongtu as nan hinpuru ay fiafiarasang ay nangara as pingkicha, ya uycha sinib-at nan chumuyas ay laraki. ");
INSERT INTO ebk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nan lema kan chicha at achicha masilib, ngem nan lema at masilibcha. ");
INSERT INTO ebk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nan chiyuycha achi masilib at enmetakincha as pingkicha, ngem chaancha enmetakin as lana as reserbacha. ");
INSERT INTO ebk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ngem kun pay nan chiyuycha lema ay masilib, enmetakincha as pingki ya lana as reserbacha. ");
INSERT INTO ebk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kiapú ta nafiayag nan omaliyan nan chiyuy chumuyas ay laraki, nasuyamancha, at nassuycha. ");
INSERT INTO ebk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ngem kun pay tongan chi lafi, wacha nan nangifukiaw un, ‘Nauy, cha omali nan chumuyas! Uyyu sib-atun hiya!’ ");
INSERT INTO ebk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","As nan hiyachi, nafiannangun nan hinpuru ay fiafiarasang ya ensakianacha nan silawcha. ");
INSERT INTO ebk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kenalen nan chiyuycha achi masilib as nan mamasilib, ‘Ettan chakami pay as tapen chi uyyu lana, tay munkudkuchimet nan silawmi.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ngem kenalen nan chiyuycha masilib un, ‘Achi sa met ommat nan reserbami as para kan chitaku am-in. Kun kayu at uy lomaku as nan chiyuycha mun-el-elaku as para kan chakayu.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Isunga naligwatcha ay uy lomaku. Ngem as nan chacha umuyan, inumchan nan chiyuy chumuyas ay laraki. Nan chiyuycha lema ay nakasakiana at nakiskopcha kan hiya as nan afong ay uycha makichuyasan, angkiay nain-ub nan pantiw. ");
INSERT INTO ebk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kun pay naawni, enmali us nan chiyuycha fiafiarasang ay uy lenmaku. ‘Apo, Apo! Paskopum pay chakami!’ infukiawcha. ");
INSERT INTO ebk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ngem tinumfor nan chiyuy chumuyas un, ‘Ifiakiak kan chakayu nan tit-iwa. Achek am-ammu chakayu.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Isunga munsasakiana kayu, tay achiyu ammu nan urkiw winnu uras ay omaliyan nan Naepadtu ay Anak chi Taku,” inyanongos Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nun-epadpachong pay hi Jesus. Kenalina, “Nan muntorayan Apo Dios at maepachongtu as nan usa ay taku ay cha munsakiana ay munfiaat as achaachawwi. Sakbay ay mak-ak, enayakiana nan chiyuycha fiabfiaaruna, ya entalekna kan chicha nan kuk-uwana. ");
INSERT INTO ebk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hinin-us-ana ay nangettan kan chicha as talento ay maiyunud as nan kafiaelancha. As nan usa at lema ay talento. As nan usa us at chuwa ay talento, ya as nan kasin usa at usa ay talento. Haat mak-ak hiya ay munfiaat. ");
INSERT INTO ebk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Nan chiyuy naichatan nan lema at uyna innigusyu ay dagus, at nunkiaransiya as lema pay ay talento. ");
INSERT INTO ebk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hiyasa us nan enat nan chiyuy naichatan nan chuwa. Nunkiaransiya as chuwa pay ay talento. ");
INSERT INTO ebk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngem nan chiyuy naichatan nan usa at uyna enkaub nan siping nan amona. ");
INSERT INTO ebk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kun pay nafiayag, nunfiangad nan amocha ya senarudsudna nan maepangkep as nan sipingna ay entalekna kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Inmuy nan naichatan nan lema ay talento, ya kanana un, ‘Apo, lema ay talento nan entalekmu kan ha-un. Nauycha us nan lema kasin ay talento ay kiaransiyana.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Ammay nan enatmu,’ ensongfiat nan amona. ‘Ammayka ya matalekka kayman ay mafiabfiaor! Kiapú ta matalekka as nan ak-akettuy, etalekkuntu kan he-a nan ong-ongor pay. Aka ngarud ta makelagragsakka kan ha-un.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Inmuy us nan naichatan nan chuwa ay talento, ya kanana un, ‘Apo, chuwa ay talento nan entalekmu kan ha-un. Nauycha nan chuwa kasin ay talento ay kiaransiyana.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Ammay nan enatmu,’ ensongfiat nan amona. ‘Ammayka ya matalekka kayman ay mafiabfiaor! Kiapú ta matalekka as nan ak-akettuy, etalekkuntu kan he-a nan ong-ongor pay. Aka ngarud ta makelagragsakka kan ha-un.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Inmuy us nan naichatan nan usa ay talento, ya kanana un, ‘Apo, ammok met ay istriktuka ay taku, tay apetum chi fiakunmu tenanum, ya aniyum chi fiakunmu tinunud. ");
INSERT INTO ebk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Inmugyatak ngamin kan he-a, isunga uyku enkaub nan chiyuy inchatmu kan ha-un. Nauy challu nan kuwam.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tinumfor nan amona kan hiya, ‘Mangotettet chi ukialem ya napadsokka ay mafiabfiaor! Ammom met payat ay apetok chi fiakunku tenanum ya aniyok chi fiakunku tinunud. ");
INSERT INTO ebk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kakunmu ngarud indiposito nan sipingku as bangko ta as nan munfiangchak at araok ay wachay interesna.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","As nan hiyachi, kenalen nan amo as nan tapina ay mafiabfiaor un, ‘Araunyu nan chiyuy talento kan hiya, ya ichatyu as nan naichatan nan hinpuru ay talento. ");
INSERT INTO ebk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tay nan taku ay wachay kafiaelana at maettan as ong-ongor, at ongortu as solet nan wacha kan hiya. Ngem nan taku ay maid kafiaelana at uray nan ak-akettuy ay wacha kan hiya at maarantu. ");
INSERT INTO ebk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nan nauy mafiabfiaor ay maid kotokna at ichus-oryu as chará henan ngongot. Hid-i nan mun-ag-akorantu nan tataku ya munngesngesatantu nan fiab-acha kiapú as fungatcha.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kenalen pay Jesus, “As nan kasin omaliyan nan Naepadtu ay Anak chi Taku ay maila nan kaichayawana ay kadwana nan am-in ay anghelesna, tomokortu hiya as nan tronona ta muntoray. ");
INSERT INTO ebk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Maepaamongchantu as nan sangwanana nan am-in ay tataku ay murpu henan am-in ay nasyon. As nan hiyachi, pasikunantu chicha as chuwa ay grupo ay kaman as nan mamasikian nan munpaspastor as nan chiyuycha karnero as nan chiyuycha kianching. ");
INSERT INTO ebk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nan chiyuycha nalintig ay tataku ay maepachong as nan karnero at ipuuyna as apét kannawana. Nan chiyuycha maepachong as nan kianching at ipuuyna as apét kannikidna. ");
INSERT INTO ebk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Angkiay ya kanantu nan ari as nan chiyuycha wacha as apét kannawana un, ‘Akayu, chakayu ay benendisyonan Amak ta maetapi kayu henan muntorayana ay naesasakiana para kan chakayu nunlapu as nan nafiayangan nan luta. ");
INSERT INTO ebk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tay as nan nunchukiaangak at penakanak kan chakayu. As nan nasketanak at penaikopak, ya usaak ay kaili ay achiyu am-ammu at menangiliyak kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kun pay maid fiachok at enettanak kan chakayu. As nan nunsaketak at enaywananak, ya as nan naifiaruchak at finisitaak.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Angkiay ya tumforchantu nan chiyuycha nalintig ay tataku kan hiya un, ‘Apo, kaatnay nangil-anmi kan he-a ay nunchukiaang, at penakanmi he-a, winnu nasketan, at penaikopmi he-a? ");
INSERT INTO ebk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kaatnay nangil-anmi kan he-a as kaili ay achi am-ammu, at menangilimi he-a, winnu maid fiachom, at enettanmi he-a? ");
INSERT INTO ebk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kaatna us chi nangil-anmi kan he-a ay nunsaket, at enaywananmi he-a, winnu naifiarud, at finisitami he-a?’ ");
INSERT INTO ebk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Kanantu nan ari kan chicha un, ‘Ifiakiak kan chakayu nan tit-iwa ay as nan nangfiadnganyu as nan uray usa as nan chiyuycha apud ay iib-ak ay omaafurot at kan ha-un nan nangekamananyu kan chatud-i.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Angkiay ya kananantu as nan chiyuycha wacha as apét kannikidna un, ‘Mak-ak kayu, chakayu ay chusaun Apo Dios. Uy kayu as nan achi mapappauy ay apuy ay naesasakiana para kan Satanas ya as nan anghelesna. ");
INSERT INTO ebk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tay as nan nunchukiaangak at chaanak penakan kan chakayu. As nan nasketanak at chaanak penaikop. ");
INSERT INTO ebk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Usaak ay kaili ay achi am-ammu at chaanak menangili kan chakayu. Kun pay maid fiachok at chaanak enettan kan chakayu. Nunsaketak at chaanak enaywanan, ya naifiaruchak at chaanak finisita.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Angkiay ya tumforchantu us ay mangali kan hiya un, ‘Apo, kaatna nan nangil-anmi kan he-a ay nunchukiaang winnu nasketan winnu kaili ay achi am-ammu winnu maid fiachom winnu nunsaket winnu naifiarud, at chaanmi finadngan he-a?’ ");
INSERT INTO ebk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kanantu nan ari kan chicha un, ‘Ifiakiak kan chakayu nan tit-iwa ay as nan chaanyu nangfiadngan as nan uray usa as nan chiyuycha apud ay tataku ay omaafurot kan ha-un at kan ha-un nan chaanyu nangekamanan kan chatud-i.’ ");
INSERT INTO ebk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Umuychantu chachi as nan chusa ay maid patingkiana. Ngem nan chiyuycha nalintig ay tataku at umuycha as nan fiyag ay maid patingkiana.” ");
INSERT INTO ebk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kun pay narpas ay insuron Jesus chaná am-in, kenalina as nan disipulusna, ");
INSERT INTO ebk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ammuyu met ay as sang-achum at Fiastan chi Munlausan.Maipurangtu nan Naepadtu ay Anak chi Taku ay maelansa as nan koros.” ");
INSERT INTO ebk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","As nan hiyachi, naamong nan anap-apon chi papachi ya nan anam-amá ay Judio as nan palasyon nan kangatuwan ay pachen chi Judio ay hi Caifas. ");
INSERT INTO ebk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nuntuturagcha as atuncha ay mangtiliw ya mangepapatuy kan Jesus ay achi maam-ammuwan nan tataku. ");
INSERT INTO ebk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ngem kenalicha, “Aw, achi takú iyaspor as nan fiasta, tay anaka ya munkukuru nan ongoongor ay tataku.” ");
INSERT INTO ebk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","As nan kawad-an cha Jesus ad Betania, uycha nakekan as afong Simon ay nakonet ay enpaammay Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","As nan chacha manganan, naesnop kan hiya nan usa ay fiafiai. Entatakina nan mangit-ittuwan ay naamma as fiatu ay nan ngachana at alabastro ay nanapnu as munfiangu ay nanginngina-an ay lana. Angkiay ya inkuyagna as nan uron Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","As nan nangil-an nan disipulusna, pararuy fungatcha, ya kanancha, “Ayyiwka sa paat! ");
INSERT INTO ebk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mu koma naelaku na ay fiangfiangru as nangina at maichat nan lakuna as nan chiyuycha pugli.” ");
INSERT INTO ebk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngem ammon Jesus nan chacha kankanan, isunga kenalina kan chicha, “Adchi t'uyyu lilifokun nan nauy fiafiai? Ammay met nan enatna kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tay kanayon ay wachacha kan chakayu nan chiyuycha pugli. Ngem mu ha-un, achiyaktu kanayon ay wacha kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Inkuyagna sa ay fiangfiangru kan ha-un ta esakianana nan achorku as nan mailubkak. ");
INSERT INTO ebk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ifiakiak kan chakayu nan tit-iwa. Uray ay chaud henan intiru ay luta nan maekasabaan nan Ammay ay Chamag at maifiabfiaagtu us nan enatna as mangnumnumnuman kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Angkiay ya usa as nan hinpuru ya chuwa ay disipulus Jesus ay hi Judas Iscariote at inmuy as nan anap-apon chi papachi, ");
INSERT INTO ebk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ya kanana, “Kaatna nan etangchanyu kan ha-un mu ipurangku hi Jesus kan chakayu?” Angkiay tenangchanancha hiya as turon puru ay silver ay siping. ");
INSERT INTO ebk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nunlapu as nan hiyachi, nun-anap hi Judas as ustu ay chansa ay mangesepsepana kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","As nan omona ay urkiw nan Fiastan chi Tenapay ay Maid Lebadurana, inmuy nan disipulus kan Jesus. Senarudsudcha, “Ay chaud nan laychum ay mangesakianaanmi as nan manganan takú as nan Fiastan chi Munlausan?” ");
INSERT INTO ebk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kenalen Jesus, “Uy kayu henan siyudad as nan chiyuy laraki, ya kananyu kan hiya un, ‘Infiakian nan Misturu un kiayud at umchan nan timpu ay enkeddeng Apo Dios para kan hiya. As nan afongmu nan mangiyufongana as nan disipulusna as nan Fiastan chi Munlausan.’ ” ");
INSERT INTO ebk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Enkaman tit-iwa nan disipulus nan infilin Jesus ay atuncha, ya ensakianacha nan manganan as nan Fiastan chi Munlausan. ");
INSERT INTO ebk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kun pay naschum, nakiufong hi Jesus as nan hinpuru ya chuwa ay disipulusna. ");
INSERT INTO ebk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","As nan chacha manganan, kenalen Jesus, “Ifiakiak kan chakayu nan tit-iwa ay wacha nan usa kan chakayu ay mangesepseptu kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nginmuyuscha as solet nan disipulusna, ya enlapucha ay nunsesennarunu ay nunsarudsud kan Jesus, “Apo, ay ha-un ta?” ");
INSERT INTO ebk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","“Nan chiyuy nakisiwsiw kan ha-un as tenapay as nan mallokong nan mangesepseptu kan ha-un,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","“Matuytu challu nan Naepadtu ay Anak chi Taku ay kaman as nan kanan nan naisurat as nan Kalen Apo Dios maepangkep kan hiya, ngem kasusug-ang kayman nan hana taku ay mangesepsep as nan Naepadtu ay Anak chi Taku! Un-unuyna at mu kun chaan naiyan-anak hiya!” ");
INSERT INTO ebk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hi Judas ay mangesepseptu kan Jesus at senarudsudna, “Misturu, ay ha-un ta?” “Kenalem at,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","As nan chacha manganan, enaran Jesus nan tenapay, ya nunyaman kan Apo Dios. Pinutput-ingna, angkiay inchatna as nan disipulusna, ya kanana, “Araunyu ta kanunyu. Hiyana nan achorku.” ");
INSERT INTO ebk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Angkiay ya enarana nan tasa ay natotorwan as maikop. Kun pay narpas ay nunyaman kan Apo Dios, inchatna kan chicha, ya kanana, “Umikop kayu am-in as na. ");
INSERT INTO ebk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hiyana nan charak ay mangepasiguradu as nan fiarú ay nakiturakian Apo Dios as nan tataku. Omayastu as nan matuyak para as nan ongor ay tataku ta mapakawancha as nan fiasfiasorcha. ");
INSERT INTO ebk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ifiakiak kan chakayu ay achiyaktu kasin umig-ikop as nan nauy ay unus chi ubas inkiana umchan nan hana ay urkiw ay makiikopaktu kan chakayu as nan fiarú ay unus chi ubas henan muntorayan Amak.” ");
INSERT INTO ebk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","As nan narpasancha ay nunkanta as pangchaychayaw kan Apo Dios, pinmitiwcha ay inmuy henan chuntug ay Olivo. ");
INSERT INTO ebk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","As nan chacha umuyan, kenalen Jesus as nan disipulusna, “Ad wani ay lafi, lomayaw kayuntu am-in kiapú kan ha-un, tay wacha nan naisurat as nan Kalen Apo Dios ay kanana, ‘Patayoktu nan mangay-aywan as nan karnero, at masisiyanchantu nan chiyuycha karnero.’ ");
INSERT INTO ebk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngem as nan matakuwak manipud as nan utúy, omon-onaaktu ay umuy ad Galilea mu chakayu.” ");
INSERT INTO ebk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Infiakian Pedro kan Jesus, “Uray mu lomayaw nan am-in ay kakadwak kiapú kan he-a at achiyak challu lomaylayaw.” ");
INSERT INTO ebk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kenalen Jesus kan hiya, “Ifiakiak kan he-a nan tit-iwa. Ad wani ay lafi, sakbay ay munkokakok nan ka-or at mamitluwaktu esaot kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kenalen Pedro, “Uray mu maetapiyak kan he-a ay matuy, achek challu poros esassaot he-a!” Assesa us nan kenalen nan am-in ay kakadwana ay disipulus. ");
INSERT INTO ebk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Angkiay ya inmuy hi Jesus ay kadwana nan disipulusna henan lukiar ay makali un Getsemani, ya kanana kan chicha, “Etokoryu hena ta uyak munkararag hid-i.” ");
INSERT INTO ebk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Entakina hi Pedro ya nan chuwa ay potot Zebedeo ay lanaraki. As nan hiyachi, enlapuna ay nginmuyus ya nalilifok. ");
INSERT INTO ebk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kenalina kan chicha, “Kamanku ekatuy nan nunsidla ay ngunguyusku. Mayasna kayu ya makipuyat kayu kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Angkiay ya inmuy as nan ad-achaawi as akét. Nunlukfub as nan luta, ya enkararagna, “Ama, mu mafialin at parufusum koma ay marpas nan nauy omali ay likiatku. Uray mu assena, fiakun challu nan laychok nan maekaman, ngem nan laychum.” ");
INSERT INTO ebk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","As nan nunfiangchana as nan kawad-an nan disipulusna, ininchanana chicha ay nanassuy. Kenalina kan cha Pedro, “Ay kunyu achi kafiaelan ay makipuyat kan ha-un as uray us-usa ay uras? ");
INSERT INTO ebk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Munpuyat ya munkararag kayu ta achi kayu maamis as nan sulisug. Nakasakiana kayman nan numnumyu, ngem nakapuy nan achoryu.” ");
INSERT INTO ebk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","As nan kapidwa, tenmaak hi Jesus ya uy nunkararag. Kenalina, “Amak, mu achek mafialin ay malisiyan nan nauy likiatkusukúdku iliwas, maekaman koma nan laychum.” ");
INSERT INTO ebk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kun pay nunfiangad as nan maekapidwa as nan kawad-an nan disipulusna, ininchanana chicha ay nanassuy kasin, tay makaskassuycha. ");
INSERT INTO ebk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Isunga kasina tenaynan chicha, ya uy nunkararag as nan maekapitlu ay maepachong as nan kenarkalina. ");
INSERT INTO ebk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kun pay nunfiangad as nan kawad-an nan disipulusna, kenalina kan chicha, “Ay kukutug kayu ay cha mammamassuy ya cha mun-ib-iblay? Ilaunyu! Inumchan at nan uras ay maesepsepan nan Naepadtu ay Anak chi Taku as nan fumafiasor. ");
INSERT INTO ebk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ayu, fumangun kayu ta uy takú maisib-at. Ilaunyu, nauy at nan mangesepsep kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kun pay kukutug ay cha munkarkali hi Jesus, enmali hi Judas ay usa as nan hinpuru ya chuwa ay disipulus. Intutun-udna nan ongoongor ay tataku ay nangachoros ya nangapak-or. Chicha nan infiaor nan anap-apon chi papachi ya anam-amán nan Judio. ");
INSERT INTO ebk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nan sinyar ay inturag Judas as nan intutun-udna at assena: “Nan taku ay fisituwok at hiya nan chayu an-anapun. Tiliwunyu hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nunchakpos hi Judas kan Jesus, ya kanana, “Komosta, Misturu?” Angkiay finisituna hiya. ");
INSERT INTO ebk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kenalen Jesus kan hiya, “Kiayyum, atum at nan pangkepmu ay enmali hena.” Hiyachi ya naesnop nan tataku ay nangtiliw kan hiya ya enpapakudcha ay ustu. ");
INSERT INTO ebk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nan usa ay kadwan Jesus at enoknosna nan chorosna. Finakagna nan fiabfiaarun nan kangatuwan ay pachi, at nakingasan nan ingana. ");
INSERT INTO ebk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kenalen Jesus kan hiya, “Esekatmu nan chorosmu. Tay nan am-in ay mangosar as choros as nan taku at matuy us babaen as choros. ");
INSERT INTO ebk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ay achim ammu ay mafialin ay chumawatak as fiachang kan Amak, at ifiaorna ay dagus nan nasorok as piton puru ya chuwa ay lifu ay angheles? ");
INSERT INTO ebk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ngem mu atok sa, anan atun ngay nan naisurat as nan Kalen Apo Dios ay matongpar ay kanana un masapor assena nan atuna ay ommat?” ");
INSERT INTO ebk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","As nan hiyachi ay uras, kenalen Jesus as nan ongoongor ay tataku, “Ay kunak kumukuru? Adchi t'uy kayu enmali ay nangachoros ya nangapak-or ay mangtiliw kan ha-un? Inurkiw met ay tomotokorak hid-i's Templo ay cha mun-is-isuru, ya chaanak met tiniltiliw kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngem enommat challu am-in chaná ta matongpar nan naisurat as nan Kalen Apo Dios ay infiakian nan chiyuycha pomapadtu.” Angkiay ya lenmayawcha nan am-in ay disipulus, ya tenaynancha hiya. ");
INSERT INTO ebk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Angkiay ya nan chiyuycha naniliw kan Jesus at inyuycha hiya as nan afong Caifas ay kangatuwan ay pachi. Hid-i nan naaamongan nan chiyuycha mun-isursuru as Lintig ya nan anam-amá. ");
INSERT INTO ebk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ngem kun pay hi Pedro, inmun-unud ay tenmataak inkiana as nan fiattaw nan kangatuwan ay pachi. Angkiay ya sinungkop hiya as nan fiattaw, ya naketokor hid-i as nan chiyuycha kuwarcha ay mangila mu ngachana nan ommat kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nan anap-apon chi papachi ya nan am-in ay membron nan Sanhedrin at nun-anaanapcha as achi tit-iwa ay pammaneknek as mangepafiasorancha kan Jesus ta wachay kiapúna as mangepapatuyancha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ngem maid naanapancha, uray mu enmalicha nan ongor ay muntistigu as achi tit-iwa. As nan anongosna, wachacha nan chuwa ay inmuy as sangwanan, ya kanancha, ");
INSERT INTO ebk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Kenalen tona ay taku un kafiaelana ay manachael as nan Templon Apo Dios, ya kiaufunantu as nan unig chi turu ay urkiw.” ");
INSERT INTO ebk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Angkiay ya tenmakchug nan kangatuwan ay pachi, ya senarudsudna kan Jesus, “Ay maid esongfiatmu as nan cha epabpafiasor chatona ay tataku kan he-a?” ");
INSERT INTO ebk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngem kun kinkinak hi Jesus. Kenalen nan kangatuwan ay pachi kan hiya, “Esapatam as nan ngachan Apo Dios ay natataku ay ifiakiam mu he-a nan Cristo ay Anak Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","“Kenalem at,” ensongfiat Jesus kan hiya. “Ngem ifiakiak kan chakayu ay munlapu ad wani at ilaunyuntu nan Naepadtu ay Anak chi Taku ay tomotokor as nan apét kannawan Apo Dios ay Mannakafialin as nan am-in. Ilaunyuntu us ay omali hiya ay murpu ad chaya ay maetatapi as nan lifuu.” ");
INSERT INTO ebk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kun pay chinngor nan kangatuwan ay pachi chi, lenaksetna nan fiachuna kiapú as fungatna, ya kanana, “Enpachongna nan achorna kan Apo Dios! Ay masapor takú pay chi muntistigu? Chinngoryu at met nan kenalina. ");
INSERT INTO ebk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngachana ngarud nan kananyu's na?” “Libfengna ay matuy!” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Angkiay ya tinubfiatubfiaancha nan lupana, ya sinudpasudpakcha hiya. Nan tapina kan chicha at tenampatampakcha hiya, at kenalicha kan hiya, ");
INSERT INTO ebk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ud-a pay! He-a ay Cristo kanu, pugtuwam mu ngachana kan chakami nan nanudpak kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kun pay hi Pedro, kukutug as chará ay naketotokor as nan fiattaw. Inmuy kan hiya nan usa ay mafiabfiaor ay fiafiai, at kenalina, “He-a us at nakekadkadwaka met kan Jesus ay i-Galilea?” ");
INSERT INTO ebk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngem ensaot Pedro ay mangali as nan sangwanancha am-in un, “Achek poros ammu nan cham kankanan!” ");
INSERT INTO ebk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kun pay inmuy hiya as nan sugpan nan fiattaw, nan tukún ay mafiabfiaor ay fiafiai at enmatonana hiya. Kenalina as nan chiyuycha nangatakchug, “Hi tona met ay laraki at usa us ay nakekadkadwa kan Jesus ay i-Nazaret.” ");
INSERT INTO ebk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kasina ensaot ay nangesapata, “Esapatak ay achek poros am-ammu sa ay taku!” ");
INSERT INTO ebk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kun pay naaw-awni as akét, nan chiyuycha nangatakchug hid-i at enmalicha kan Pedro. Kenalicha kan hiya, “O kayong, usaka us kan chicha, tay maematonanmi met nan ayug nan kalem.” ");
INSERT INTO ebk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Angkiay ya ensapatan Pedro as nan achorna, “Chusaunak ud-ay kan Apo Dios mu achi tit-iwa nan chak ifiagfiakia! Achek poros ammu sa ay taku!” Hiya at chi ya nunkokakok nan ka-or, ");
INSERT INTO ebk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ya nanumnum Pedro nan infiakian Jesus un, “Sakbay ay munkokakok nan ka-or at mamitluwaktu ay esaot kan he-a.” Angkiay ya pinmitiw hi Pedro, ya nunsidlay akorna. ");
INSERT INTO ebk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","As nan wi-ewi-et, nuntuturagcha nan am-in ay anap-apon chi papachi ya nan anam-amán chi Judio ay mangepapatuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kun pay narpas chi, finarudcha hiya, ya enek-akcha ay nangipurang kan Gobernador Pilato. ");
INSERT INTO ebk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","As nan nangil-an Judas ay nangesepsep kan Jesus ay nakeddengan hi Jesus ay matuy, nunfiafiawi as nan enatna. Infiangadna nan chiyuy turon puru ay silver ay siping as nan anap-apon chi papachi ya as nan anam-amá. ");
INSERT INTO ebk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kenalina, “Finmasorak as solet as nan ok nangesepsepan as nan taku ay maid fiasorna.” “Anan fiyangmi's sa? Kikiadka as sa,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","As nan hiyachi, inchus-or Judas nan chiyuy siping as fiaruy nan Templo, ya nak-ak ay uy nunfitkor. ");
INSERT INTO ebk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pinichet nan anap-apon chi papachi nan chiyuycha siping, at kenalicha, “Epawan nan lintig takú ay elamong takú na as nan siping as Templo, tay hi tona at fiayad chi fiyag chi usa ay taku.” ");
INSERT INTO ebk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Isunga nuntuturagcha ay osaruncha nan siping ay manglakucha as nan lutan nan usa ay mun-am-amma as fianga ta mangilublubkancha as matuy ay kaili ay achi am-ammu. ");
INSERT INTO ebk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Isunga nan hana ay luta at makali un “Luta ay Nacharaan” inkiana ad wani. ");
INSERT INTO ebk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hiyana nan natongparan nan kenalen Jeremias ay pomapadtu ad pus-uy ay kanana, “Enaran nan tapen chi kianak Israel nan turon puru ay silver ay siping ay hiya nan nuntuturakiancha ay lakon nan fiyagna. ");
INSERT INTO ebk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nan siping at infiayadcha as nan lutan nan mun-am-amma as fianga ay hiya challu nan infilin Apo Dios kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kun pay hi Jesus, tenmatakchug as nan sangwanan Pilato ay gobernador. Senarudsud Pilato kan hiya, “Ay he-a nan aren chi Judio?” “He-a nan nangali un ha-un,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngem as nan nangepabpafiasoran nan anap-apon chi papachi ya nan anam-amá kan hiya, chaan poros tinumtumfor. ");
INSERT INTO ebk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","As nan hiyachi, kenalen Pilato kan hiya, “Ay achim chungrun nan ongor ay chacha epabpafiasor kan he-a?” ");
INSERT INTO ebk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngem chaan poros senongsongfiatan Jesus nan uray usa as nan chacha epabpafiasor kan hiya. Isunga naschaaw as solet nan gobernador. ");
INSERT INTO ebk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kun kay Fiastan chi Munlausan at ukialen nan gobernador ay umilufus as usa ay fiarud ay laychun nan tataku ay chawatun. ");
INSERT INTO ebk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","As nan hana ay timpu, wacha nan usa ay nunchinngor ay fiarud ay nan ngachana at Barrabas. ");
INSERT INTO ebk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Isunga as nan naamongan nan ongoongor ay tataku, senarudsud Pilato kan chicha, “Ngachana nan laychunyu ay ilufusku para kan chakayu? Ay hi Barrabas winnu hi Jesus ay makali un Cristo?” ");
INSERT INTO ebk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Infiakiana chi, tay naammuwana ay inpurang nan anap-apon chi Judio hi Jesus kan hiya kiapú as aposcha. ");
INSERT INTO ebk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","As nan nangatokoran Pilato as nan mun-ok-okomána, enpachamag asawana kan hiya, “Achika makifiyang as nan laraki ay ansa ay nalintig, tay wacha nan iniitawku ad kia-u maepangkep kan hiya, at pararu ay napalikiatanak kiapú as nan iniitawku.” ");
INSERT INTO ebk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","As nan hiyachi, nan anap-apon chi papachi ya nan anam-amá at chinorchorcha nan tataku ta nan chawatuncha ay ilufusna at hi Barrabas ya hi Jesus nan epapatuyna. ");
INSERT INTO ebk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kasin senarudsud Gobernador Pilato as nan tataku, “Ngachana kan chatona ay chuwa ay tataku nan laychunyu ay ilufusku?” “Hi Barrabas!” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kenalen Pilato kan chicha, “Mu hiyasa, anan atok ngay ngarud kan Jesus ay makali un Cristo?” “Epaelansam as nan koros!” infukiawcha am-in. ");
INSERT INTO ebk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Adchi ngay? Ngachana man nan mangotettet ay enatna?” senarudsud Pilato. Ngem kenaskasincha infukiaw, “Epaelansam as nan koros!” ");
INSERT INTO ebk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","As nan nangil-an Pilato ay maid kotok nan chana munsarsarudsuchan, ngem kun at cha maelapu chi kuru, nunpaara as chanum ya nunfuru as nan sangwanan nan ongoongor ay tataku. Kenalina, “Maid fiasorku as nan mangpatuyanyu kan tona ay taku! Kikiad kayu!” ");
INSERT INTO ebk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tinumfor nan am-in ay tataku, “O ud-ay, kikiad kami challu ya nan an-akmi!” ");
INSERT INTO ebk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","As nan hiyachi, inlufusna hi Barrabas. Angkiay enpasaplesapletna hi Jesus as nan sosorchachu, at inpurangna hiya ta maelansa as nan koros. ");
INSERT INTO ebk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Angkiay ya inyuy nan sosorchachon Pilato hi Jesus as nan fiattaw nan afong nan gobernador, ya enamongcha nan am-in ay kakadwacha ay sosorchachu ya nan chiyuycha nangarufong kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lenafusancha hiya, at kenakiayancha hiya as munchachara ay maepachong as nan fiachon chi ari. ");
INSERT INTO ebk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Penolekawcha nan komawet ay sufet, ya insukrubcha as uruna. Enpad-uncha nan nunu as nan kannawan ay limana. Angkiay nunpalpalintumangcha ay mangot-otyok as nan mangarkaliyancha, “Matakutakuka ay Aren chi Judio!” ");
INSERT INTO ebk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tinubfiatubfiaancha hiya. Enaracha us nan nunu ya enpak-opak-orcha as nan uruna. ");
INSERT INTO ebk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kuncha pay lenpas ay nangotyootyok kan hiya, kenaancha nan munchachara ay kakiay, ya enpafiachucha kasin nan fiachuna. Hacha at ek-ak ay uy mangelansa kan hiya as nan koros. ");
INSERT INTO ebk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","As nan chacha mak-akan, sinib-atcha nan laraki ay i-Cirene ay nan ngachana at Simon. Peneletcha hiya ay manakfiat as nan koros Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kuncha pay inumchan henan lukiar ay makali un Golgota ay nan laychuna ay kanan at “Lukiar nan Tong-or chi Uru,” ");
INSERT INTO ebk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","penachascha ay mangepaikop kan Jesus as fiayas ay nakaslangan as apku ay mangepakyat kanu as putug. Ngem kuna pay tenamtaman, enachina. ");
INSERT INTO ebk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kuncha pay lenpas ay nangelansa kan hiya as nan koros, finingfingaycha nan chiyuycha fiachuna babaen as nan nunfifinnonotancha. ");
INSERT INTO ebk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Angkiay ya tenmokorcha, ya finantayancha hiya hid-i. ");
INSERT INTO ebk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","As nan laramakun nan uruna, inpuuycha nan tabra ay naisusuratan nan naepafiasor kan hiya ay assena nan kafiasaana: “Hi Tona Hi Jesus Ay Aren Chi Judio.” ");
INSERT INTO ebk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Angkiay ya wachacha us nan chuwa ay homohold-ap ay enlansacha as nan koros, usa as apét kannawan Jesus, ya nan usa at as apét kannikidna. ");
INSERT INTO ebk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nan chiyuycha cha marmar-os at en-ensotcha hiya ya nunwugwugwugcha, ");
INSERT INTO ebk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ay cha mangarkali, “He-a ay nangali un kafiaelam ay manachael as nan Templo ya kiaufum as nan unig chi turu ay urkiw at ud-a, esarakam nan achormu! Mu tit-iwa ay he-a nan Anak Apo Dios, komsopka as nan koros.” ");
INSERT INTO ebk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Uray nan anap-apon chi papachi ay kadwacha, nan mun-isursuru as Lintig ya nan anam-amá at enot-otyokcha hi Jesus as nan chacha mangarkaliyan, ");
INSERT INTO ebk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ensarakana nan tapina ay tataku, ngem achina met poros maesarakan nan achorna. Mu hiya nan aren nan chiyuycha kianak Israel, kakun ud-a komsop ad wani as nan koros, at afurotun takú hiya. ");
INSERT INTO ebk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Talekuna kanu hi Apo Dios. Ud-a pay, ilaun takú mu laychun Apo Dios ay mangesarakan kan hiya ad wani, tay kanana us un Anak Apo Dios hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kaman us as nan chiyuycha chuwa ay homohold-ap ay naelansa as nan koroscha at ininsurtucha us hiya. ");
INSERT INTO ebk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nunlapu as nan nunkiawa, ngenmongot nan intiru ay luta inkiana alas tres as nan makiayud. ");
INSERT INTO ebk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","As nan kiayud alas tres, inpigsan Jesus ay nangifukiaw, “Eli, Eli, lama sabaktani?” Nan laychuna ay kanan at, “Diosku, Diosku, adchi t'uyak ennganuy?” ");
INSERT INTO ebk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","As nan nanngoran nan tapen nan tataku ay nangatakchug hid-i, kenalicha, “Ku-una cha ayakian hi Elias.” ");
INSERT INTO ebk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Natannagtag nan usa kan chicha ay uy enmara as espongha. Enpasosopna as nan senmoka ay fiayas. Kun pay narpas, enpakatna as nan nunu ya inchawchawna ta epasosopna kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngem kanan nan tapina, “Awni pay ud-a ta ilaun takú mu omali hi Elias ay mangesarakan kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nunfukiaw kasin hi Jesus as napigsa, ya entalekna nan long-agna kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","As nan hiyachi, narakset ay nunkudwa nan kurtinan nan Templo nunlapu as lamagna inkiana as kuwabna. Kinmichu as napigsa ya nabtakcha nan chiyuycha anad-acha ay chupras. ");
INSERT INTO ebk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Natkafian us nan chiyuycha lufok, ya nan ongor ay natuy ay tatakon Apo Dios at natakucha manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tenaynancha nan chiyuycha lufokcha. As nan natakuwan Jesus manipud as nan utúy, inmuycha ad Jerusalem ay nasantowan ay siyudad, at ongor chi nangila kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kun pay keneknan nan kapetan chi sosorchachu ya nan sosorchachuna ay nunfiafiantay nan kichu ya inilacha nan enommat, inmugyatcha as solet, ya kanancha, “Tit-iwa payat ay hi tona at Anak Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","As nan ad-achawwi as akét, ongorcha nan fianafiai hid-i ay nangila as nan cha om-ommat. Chicha nan inmun-unud kan Jesus nunlapu ad Galilea ya namadfiachang kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nan tapina kan chicha at cha Maria Magdalena, hi Maria ay enan cha Santiago kan Jose, ya nan asawan Zebedeo. ");
INSERT INTO ebk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kun pay cha maschum, enmali nan usa'y fiaknang ay i-Arimatea ay nan ngachana at Jose. Usa us hiya ay disipulon Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Inmuy hiya kan Pilato, at chinmawat as pammarufus ay arauna nan achor Jesus. Angkiay ya infilin Pilato ay maichat kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Enaran Jose nan achor Jesus, ya penotepotana as nan fiarú ay am-ammay ya nacharos ay lopot. ");
INSERT INTO ebk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Angkiay ya enpaipuuyna as nan mismu ay fiarú ay lufokna ay enpatuktukna ay chupras. Kun pay narpas, enpaulina nan ad-acha ay fiatu ay nanangubna as nan lufok, angkiay nak-ak. ");
INSERT INTO ebk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hi Maria Magdalena ya nan usa ay Maria at wachacha us hid-i ay nangatokor as nan sangwanan nan lufok. ");
INSERT INTO ebk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","As nan kafikiatana as nan narpasan nan Urkiw nan Munsakianaan para as nan Urkiw ay Mun-iblayancha, inmuy nan anap-apon chi papachi ya nan chiyuycha Fariseo as afong Pilato. ");
INSERT INTO ebk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kenalicha, “Apo Gobernador, manumnummi nan kenalen nan enmallilaw ay anchi as nan natatakuwana pay laing ay kanana un, ‘As nan maekatlu ay urkiw at matakuwak manipud as nan utúy.’ ");
INSERT INTO ebk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Isunga ammay man mu ifilinmu ay mafiantayan ay ustu nan lufokna inkiana as nan maekatlu ay urkiw, tay atun at mu umuy nan disipulusna ay mangakiw as nan achorna, ya epachamagchantu as nan tataku ay nataku hiya manipud as nan utúy. Mu atuncha chi, kaskasin mangisiw nan anongos ay allilawcha mu nan enmon-ona ay kenalen Jesus un hiya nan Cristo.” ");
INSERT INTO ebk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kenalen Pilato kan chicha, “O, omayag kayu ngarud as sosorchachuyu ay murpu as Templo. Angkiay ya umuy kayu hid-i ya epakuwarchayu ay ustu nan lufok.” ");
INSERT INTO ebk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Isunga inmuycha, ya inpuuycha nan maton as nan unub nan lufok ta mailatu mu wachay mangulin. Hacha at epakuwarcha as nan sosorchachu. ");
INSERT INTO ebk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kun pay inmuy nan Urkiw ay Mun-iblayan as nan wi-ewi-et as nan Chumingku, inmuy cha Maria Magdalena ya nan usa ay Maria as nan lufok Jesus. ");
INSERT INTO ebk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kalina at ya nunkichu as napigsa, tay kinmuwab nan usa ay anghel Apo Dios ay nurpu ad chaya. Inulina nan fiatu ay tangub nan lufok, at tenokorana. ");
INSERT INTO ebk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nan ilana at munselselap ay kaman fiakilat, ya nan fiachuna at pukpukkawan. ");
INSERT INTO ebk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","As nan nangil-an nan chiyuycha sosorchachu as nan anghel, penmayagpagcha ya nunlukfubcha ay kamancha nanatuy kiapú as nan nunsidla ay ugyatcha. ");
INSERT INTO ebk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kenalen nan anghel as nan fianafiai, “Achi kayu umugyat, tay ammok challu ay chayu anapun hi Jesus ay naelansa as nan koros. ");
INSERT INTO ebk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Maid hiya hena, tay nataku manipud as nan utúy ay kaman as nan infiakiana. Akayu, ilaunyu nan naesasad-ana. ");
INSERT INTO ebk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kamuwunyu pay ay uy mangifiakia as nan disipulusna ay nataku hiya manipud as nan utúy, ya omon-ona hiya ay umuy mu chakayu ad Galilea. Ilaunyuntu hiya hid-i. Nunumnumunyu nan infiakiak kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Isunga kenamon nan fianafiai ay nak-ak as nan chiyuy lufok. Uray mu inmuugyatcha, naragsakcha challu. Angkiay ya tenmagtagcha ay uy mangifiakia as nan disipulusna. ");
INSERT INTO ebk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","As nan chacha tomagtakian, kalina at ya sinib-at Jesus chicha, ya kanana, “Komosta kayu?” Naesnopcha kan hiya, ya nunpalintumangcha ay nangchun as nan sukina, ya nunchayawcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Haat kanan Jesus kan chicha, “Achi kayu umugyat. Uyyu ifiakia as nan iib-ak ay umuycha ad Galilea. Hid-i nan mangil-anchantu kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","As nan cha umuyan nan fianafiai, nan tapen nan sosorchachu ay nangukuwarcha as nan lufok Jesus at inmuycha ad Jerusalem. Infiakiacha as nan anap-apon chi papachi nan am-in ay enom-ommat. ");
INSERT INTO ebk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nakiturag nan anap-apon chi papachi as nan anam-amá mu anan atuncha. Nan nunturakiancha at pasoksokancha nan chiyuycha sosorchachu as chamuna ay siping. ");
INSERT INTO ebk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Infilincha kan chicha, “Ifiakiayu as nan tataku ay enmali nan disipulus Jesus as nan lafi, ya enlayawcha nan achorna as nan nanassuyanmi. ");
INSERT INTO ebk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mu machamagtu nan gobernador na, kikiad kamintu ay mangawis kan hiya ta maid chusayu.” ");
INSERT INTO ebk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Isunga enaran nan sosorchachu nan siping, ya enatcha tit-iwa nan naifilin kan chicha. Inkiana ad wani, hiyana nan kukutug ay cha munchinchinamag as nan chiyuycha Judio. ");
INSERT INTO ebk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Inmuy nan hinpuru ya usa ay disipulus Jesus henan chuntug ad Galilea ay hiya nan infilin Jesus ay manib-atana kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","As nan nangil-ancha kan hiya, chinaychayawcha hiya, ngem nunchuwachuwa nan tapina kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Naesnop hi Jesus kan chicha, ya kanana, “Naichat kan ha-un nan am-in ay kalibfengan ad chaya ya asna's luta. ");
INSERT INTO ebk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Isunga uy kayu as nan am-in ay tataku henan am-in ay nasyon, ya munfialinunyu chicha as disipulusku. Funyakianyu chicha as nan ngachan nan Ama, nan Anak, ya nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Isuruwanyu chicha ay mangafurot as nan am-in ay infilinku kan chakayu. Nunumnumunyu us ay mawawachaak kan chakayu inkiana as nan munpatingkiaan nan lufong.”");
INSERT INTO ebk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hiyana nan nunlapuwan nan Ammay ay Chamag ay maepangkep kan Jesu Cristo ay Anak Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wacha nan infiakian Apo Dios as nan Anakna ad pus-uy ay enpaisuratna kan Isaias ay usa ay pomapadtu ay kanana, “Wacha nan ifiaorku ay mangon-ona mu he-a ay mangesakiana as nan ayum. ");
INSERT INTO ebk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ifugfukiawnantu henan lukiar ay disyerto un, ‘Esakianayu nan ayun nan Apo. Munlutkunyu nan ayuna.’ ” ");
INSERT INTO ebk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Natongpar chaná ay kali as nan nunpail-an Juan ay Fumufunyag henan disyerto. Nunfunfunyag ya nun-ekaskasaba as nan tataku, ya kanana, “Munfiafiawi kayu as nan fiasfiasoryu ya munpafunyag kayu, at pakawanun chakayu kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","In-inmuy kan hiya nan ongoongor ay tataku ay nurpu henan intiru ay probinsiya ay Judea ya henan siyudad ay Jerusalem. Nunfiafiawicha ay cha mangifiagfiakia as nan fiasfiasorcha, at finunyakian Juan chicha henan wawwang ay Jordan. ");
INSERT INTO ebk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nan fiachon Juan at naamma as chotchot chi kamelio. Nan sinturuna at larat, ya nan kanuna at chuchun ya chilu. ");
INSERT INTO ebk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Infiagfiakiana as nan tataku, “Wacha nan usa ay cha umunud kan ha-un ay am-amud mu ha-un. Achiyak paat maekari ay munyongyong ay mangfokat as kiarot chi sapatosna. ");
INSERT INTO ebk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Funyakiak chakayu as chanum, ngem hiya at funyakiana chakayuntu as Espiritu Santo.” ");
INSERT INTO ebk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","As nan hiyachi ay timpu, enmali hi Jesus ay nurpu ad Nazaret henan probinsiya ay Galilea, at nunpafunyag kan Juan henan wawwang ay Jordan. ");
INSERT INTO ebk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kun pay tenmakchang hi Jesus as nan chanum, inilana ay natkafian ad chaya, ya nan Espiritu Santo ay kaman karopati at cha komsop kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Wacha us nan kali ay nurpu ad chaya ay kanana, “He-a nan anakku ay laylaychok. Malaylaychanak paat kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hiya at chi ya entoróng nan Espiritu Santo hi Jesus henan disyerto. ");
INSERT INTO ebk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nagyan hi Jesus hid-i as opat puru ay urkiw ay chinischisting Satanas. Wachacha us nan nunkaatap ay animar as nan kawad-ana, ngem wachacha nan angheles ay uy nangfiachang kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kun pay naifiarud hi Juan, inmuy hi Jesus ad Galilea, ya enkaskasabana nan Ammay ay Chamag ay nurpu kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kenalina, “Inumchan nan ustu ay timpu, ya kiayud nan muntorayan Apo Dios. Munfiafiawi kayu as nan fiasfiasoryu ya afurotunyu nan Ammay ay Chamag!” ");
INSERT INTO ebk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","As nan cha manarcharanan Jesus henan olet nan Fiayfiay ay Galilea, inilana cha Simon kan Andres ay sunúdna ay cha manafukor henan fiayfiay, tay hiyachi nan chunucha. ");
INSERT INTO ebk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Angkiay kenalen Jesus kan chicha, “Unuchunak, at isurok chakayu ay munfialin as kaman tomatafukor as tataku.” ");
INSERT INTO ebk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hiya at chi ya tenaynancha nan chiyuycha tafukorcha, ya inmunudcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kuncha pay tenmaak as akét, inilan Jesus cha Santiago kan Juan ay potot Zebedeo. Nan nauycha hen-aki at wachacha as nan fiangkacha ay cha mangesakiana as nan chiyuycha tafukorcha. ");
INSERT INTO ebk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hiya at chi ya enayakian us Jesus chicha. Tenaynancha hi amacha ay Zebedeo as nan fiangka ay kadwana nan chiyuycha munlagfuwuncha ay lanaraki, ya inmunudcha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Inmuy cha Jesus ad Capernaum. As nan Urkiw ay Mun-iblayan, sinungkop hiya as nan senagoga ya nun-isuru. ");
INSERT INTO ebk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Naschaawcha nan chiyuycha chinumngor kan hiya as nan enatna ay nun-isuru, tay as nan nun-isuruwana kan chicha at wachay kalibfengana ay achi kaman as nan chiyuycha mun-isursuru as Lintig. ");
INSERT INTO ebk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","As nan hiyachi, sinungkop hid-i nan usa ay laraki ay naanennetan, ya infukiawna, ");
INSERT INTO ebk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Anan atum kan chakami, Jesus ay i-Nazaret? Ay enmalika ay manachael kan chakami? Am-ammok he-a. He-a nan nasantowan ay finaor Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngem senengaran Jesus nan anennet. Kenalina, “Kuminakka! Fomoknagka kan tosa ay laraki!” ");
INSERT INTO ebk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Angkiay ya nunkorchasun nan anennet nan laraki ya nun-uwekuna as napigsa, angkiay fenmoknag kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Naschaaw as solet nan am-in ay tataku, ya nunsesennarudsudcha, “Anan ngantona ngun ay fiarú ay sursuru? Wachay kalibfengana ay munfilin uray as nan anennet, at tomongparcha!” ");
INSERT INTO ebk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Naiwaras ay dagus nan chamag maepangkep kan Jesus henan am-in ay sikib nan Galilea. ");
INSERT INTO ebk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","As nan nak-akan cha Jesus as nan senagoga, inmuycha as afong cha Simon kan Andres. Nakiuy cha Santiago kan Juan. ");
INSERT INTO ebk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kuncha pay inumchan, nan katukiangan Simon ay fiafiai at inuumfug ay cha munpuchot. Hiya at chi ya infiaagcha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kun pay naesnop hi Jesus kan hiya, inunnana nan limana ya finanguna. Nakaan nan puchotna, ya nunsakiana as kanuncha. ");
INSERT INTO ebk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","As nan nauynuwan nan urkiw as nan naschum, inyalen nan tataku kan Jesus nan am-in ay cha munsaket ya nan nunkaanennetan. ");
INSERT INTO ebk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Naamong nan am-in ay umili as nan pantiw nan afong ay kawad-ana. ");
INSERT INTO ebk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ongor nan enpaammayna ay cha munsaket as tukutukún ay saksaket, ya enpafoknagna us nan ongor ay anennet as nan nunkaanennetan. Chaana penarufusan ay munkali nan chiyuycha anennet, tay aammucha hiya. ");
INSERT INTO ebk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","As nan kafikiatana, finmangun hi Jesus as nan chaana napat-oran ya nak-ak as nan afong. Inmuy henan kamaid chi umili ay uy nunkararag. ");
INSERT INTO ebk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Finmangun cha Simon ya nan kakadwana, ya uycha enanap hiya. ");
INSERT INTO ebk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kuncha pay naanapan, kenalicha, “Am-in ay tataku at cha chaká anapun.” ");
INSERT INTO ebk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngem tinumfor hi Jesus, “Uy takú henan naesasag-un ay il-ili ta uyak us munkasaba as nan tataku hid-i, tay hiyana nan kiapúna ay enmaliyak.” ");
INSERT INTO ebk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Isunga nunliklikud hiya henan intiru ay probinsiya ay Galilea ay cha mun-ekaskasaba as nan chiyuycha senagogacha ya cha mun-epafoknag as anennet as nan nunkaanennetan. ");
INSERT INTO ebk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wacha nan usa ay laraki ay nakonet ay naesnop kan Jesus. Nunpalintumang ay cha munpakpakaasi kan hiya, “Mu laychum, epaammayak koma.” ");
INSERT INTO ebk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nasug-ang kayman hi Jesus, ya inchawchawna nan limana ay nangpa kan hiya. Kenalen Jesus, “Laychok. Omammayka!” ");
INSERT INTO ebk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hiya at chi ya nakaan nan konetna ya enmammay hiya. ");
INSERT INTO ebk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Angkiay ya enpakatamna hiya ay dagus, ya pararuy enatna ay nangifilin, ");
INSERT INTO ebk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Achim ifiagfiakia as kumpurmi nan enommat kan he-a, ngem kunka at uy munpaila as nan pachi ta ilauna ay nakaan nan saketmu. Kun pay marpas, umichatka as chatonmu kan Apo Dios ay kaman as nan infilin Moises ta mangammuwan nan tataku ay nakaan tit-iwa nan saketmu.” ");
INSERT INTO ebk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngem as nan nak-akan nan chiyuy laraki, uyna enpachapachamag nan enommat kan hiya. Isunga achi mafialin ay makauy hi Jesus henan il-ili ay iilaun chi ongoongor ay tataku, ngem kun at nagyan henan kamaid chi tataku. Uray mu hiyasa, enmali challu kan hiya nan ongor ay tataku ay nurpu henan am-in ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kun pay inmuy chi kaat ay urkiw, nunfiangad hi Jesus ad Capernaum, ya nunchinamag ay kenmatam hiya. ");
INSERT INTO ebk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Isunga ongor ay tataku nan cha maamoamong as afongna at maid lukiar chi tapina uray as nan fiattaw. Angkiay as nan cha mangekaskasabaan Jesus as kalen Apo Dios kan chicha, ");
INSERT INTO ebk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","enmali nan opat ay lanaraki ay nangeaattang as laraki ay paralitiko ta iyuycha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Maid atuncha ay mangesag-un as nan paralitiko kan Jesus kiapú ta ongor chi tataku. Isunga kinusfotancha nan tabfongan ay tungor Jesus, at inuy-uycha nan paralitiko ay kukutug as nan inuumfukiana. ");
INSERT INTO ebk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kun pay inilan Jesus nan pammaticha, kenalina as nan paralitiko, “Anakku, napakawanka as nan fiasfiasormu.” ");
INSERT INTO ebk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wachacha nan tapina ay mun-isursuru as Lintig ay naketotokor hid-i ay nangali as numnumcha, ");
INSERT INTO ebk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Adchi ngun na as taku t'uyna kanan sa? Nakkuran man na ay taku t'uyna epapachong chi achorna kan Apo Dios! Ngachana nan makafiael ay mamakawan as nan tataku as nan fiasfiasorcha mu achi hi Apo Dios yangkiay?” ");
INSERT INTO ebk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hiya at chi ya naammuwan Jesus nan wacha as numnumcha, ya kanana kan chicha, “Adchi sa as chayu numnumnumun? ");
INSERT INTO ebk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ngachana nan narakraka as kanan as nan paralitiko, ‘Napakawanka as nan fiasfiasormu,’ winnu kanan un, ‘Maligwatka, araum nan apragmu ya manaranka’? ");
INSERT INTO ebk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngem mu hiyasa, atok na ta maammuwanyu ay nan Naepadtu ay Anak chi Taku at wachay kalibfengana asna's luta ay mamakawan as tataku as nan fiasfiasorcha.” Kenalina as nan paralitiko, ");
INSERT INTO ebk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kanak kan he-a, tomakchugka, araum nan apragmu ya komatamka.” ");
INSERT INTO ebk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hiya at chi ya tenmakchug hiya. Angkiay nun-arana nan apragna, ya nak-ak as nan mangiil-an nan am-in ay tataku. Naschaawcha am-in, ya chinaychayawcha hi Apo Dios, ya kanancha, “Anuy maid inil-ilami as assena!” ");
INSERT INTO ebk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Inmuy kasin hi Jesus henan olet nan Fiayfiay ay Galilea. Naamong chi ongor ay tataku kan hiya, at enlapuna ay nangisurusuru kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kun pay naaw-awni as nan chana manarcharanan, inilana nan potot Alfeo ay hi Levi ay nangatokor as opisinana ay munfiayfiayachan as fiaror. Kenalen Jesus kan hiya, “Unuchunak.” Nunkaliligwat hi Levi ya inmunud kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","As nan nangatokoran cha Jesus ay makekan as afong Levi, ongor chi mangam-among as fiaror ya tapina ay fumafiasor ay makekan kan chicha, tay ongorcha ay inmunud kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kun pay inilan nan chiyuycha mun-isursuru as Lintig ay wacha as nan bunggoy nan chiyuycha Fariseo ay cha makekan hi Jesus as nan chiyuycha fumafiasor ya mangam-among as fiaror, senarudsudcha as nan disipulusna, “Adchi t'uy makekan hiya as nan chiyuycha mangam-among as fiaror ya as nan tapina ay fumafiasor?” ");
INSERT INTO ebk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kun pay chinngor Jesus chi, kenalina kan chicha, “Nan tataku ay achi munsaket at achicha masapor chi choktor, ngem kun at nan chiyuycha munsaket yangkiay. Chaanak enmali ay mangayag as nan nunkalintig, ngem kun at nan fumafiasor.” ");
INSERT INTO ebk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","As nan namingsan, chacha mun-ayunar nan disipulus Juan ay Fumufunyag ya nan disipulus nan chiyuycha Fariseo. Inmuy nan tapina ay tataku kan Jesus, ya senarudsudcha, “Adchi t'uy nan disipulus Juan ya nan disipulus nan chiyuycha Fariseo at mun-ayunarcha, ngem nan disipulusmu at achicha?” ");
INSERT INTO ebk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tinumfor hi Jesus kan chicha, “Ay mun-ayunar nan chiyuycha naayakian ay makichuyas uray mu kukutug nan chumuyas ay laraki kan chicha? Achicha met! Mu kukutug nan chumuyas ay laraki kan chicha, achicha mafialin ay mun-ayunar. ");
INSERT INTO ebk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngem mu umchantu nan timpu ay maek-akan nan chinmuyas ay laraki kan chicha, hiyachintu nan mun-ayunarancha.” ");
INSERT INTO ebk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kenalen us Jesus ay nangepachong, “Maid mangelakub as fiarú ay lopot as nan lukiak ay fiachu. Mu atuna chi, komsun nan naelakub, at makuyud nan lukiak ay fiachu ya kaskasin marakset. ");
INSERT INTO ebk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Maid us mangittu as kasubsufor ay fiayas as nan lukiak ay mangit-ittuwan ay larat. Mu ipuuyna, epabtaktu nan fiayas nan larat, at maiwagkia nan fiayas ya machachael us nan larat. Ngem kun at maittu nan kasubsufor ay fiayas as nan fiarú ay mait-ittuwan ay larat.” ");
INSERT INTO ebk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","As nan usa ay Urkiw ay Mun-iblayan, cha mar-os cha Jesus as nan chiyuycha uma ay natanman as trigo. As nan chacha manarcharanan, enlapon nan disipulusna ay munsaw-i. ");
INSERT INTO ebk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Angkiay ya kanan nan chiyuycha Fariseo kan Jesus, “Ilaum, adchi t'uycha cha atun nan epawan nan Lintig takú as nan Urkiw ay Mun-iblayan?” ");
INSERT INTO ebk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tinumfor hi Jesus kan chicha, “Ay kunyu chaan poros finasfiasa nan enat Ari David ya nan kakadwana as nan nunsaporancha ya nunchukiaangancha? ");
INSERT INTO ebk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","As nan hiyachi ay hi Abiatar nan kangatuwan ay pachen nan chiyuycha Judio, sinungkop hi David as nan munchaychayawan kan Apo Dios ya kenana nan tenapay ay naichaton kan Apo Dios. Ngem epawan nan lintig nan ngachana ay mangan mu achi yangkiay nan papachi.Inchatna us nan tapen nan tenapay as nan kakadwana.” ");
INSERT INTO ebk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kenalen pay Jesus, “Nan Urkiw ay Mun-iblayan at naammaan para as nan omammayan nan tataku. Chaan nafiayang nan tataku ay para as nan Urkiw ay Mun-iblayan. ");
INSERT INTO ebk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Isunga nan Naepadtu ay Anak chi Taku nan muntoray uray as nan Urkiw ay Mun-iblayan.” ");
INSERT INTO ebk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sinungkop kasin hi Jesus as nan senagoga. Wacha hid-i nan usa ay laraki ay nakukuy nan usa ay limana. ");
INSERT INTO ebk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wachacha us nan manisiim kan Jesus mu epaammayna nan hana laraki as nan Urkiw ay Mun-iblayan ta wachay epafiasorcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kenalen Jesus as nan nakukuy chi limana, “Omalika hena.” ");
INSERT INTO ebk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Angkiay ya senarudsudna as nan tataku, “Ngachana nan eparufus nan Lintig ay atun takú as nan Urkiw ay Mun-iblayan? Ay atun takú nan ammay winnu mangotettet? Ay esarakan takú nan fiyag chi taku winnu chachaelun?” Ngem maid nunkali kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Finmufungat hi Jesus ay nuntat-allang kan chicha, ya nasaket us challu nan numnumna kiapú as nan kenatangken chi numnumcha. Angkiay ya kenalina as nan nakukuy chi limana, “Uyachum nan limam.” Inuyadna ya enmammay tit-iwa nan limana. ");
INSERT INTO ebk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nak-ak nan chiyuycha Fariseo, ya hiya at chi ya uycha enapat as nan chiyuycha pasorot Ari Herodes mu anan atuncha ay mangpatuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nak-ak hid-i hi Jesus ya nan disipulusna, at inmuycha henan olet nan Fiayfiay ay Galilea. Inmunud kan chicha nan ongoongor ay tataku ay nurpu ad Galilea, Judea, ");
INSERT INTO ebk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, sakopun nan Idumea, as apét fomokfoknakian nan urkiw ay usa ay chumang nan wawwang ay Jordan ya nan chiyuycha naesasag-un ay siyudad ay Tiro ya Sidon. Nan nauycha ongoongor ay tataku at enmalicha kan Jesus, tay chinngorcha nan en-enatna. ");
INSERT INTO ebk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kiapú ta ongor chi tataku, kenalen Jesus as nan disipulusna ay mun-esakianacha as fiangka as munlukianana ta achicha epetun hiya. ");
INSERT INTO ebk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kiapú ta ongor chi enpaammayna, nunsosonnor nan am-in ay munsaket ay umuy kan Jesus ta paatcha kaprosun hiya. ");
INSERT INTO ebk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mu kay ilaun nan nunkaanennetan hi Jesus, nunlukfubcha as nan sangwanana, ya infukiawcha, “He-a nan Anak Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngem infilin Jesus ay ustu kan chicha ay achicha ifiagfiakia nan maepangkep kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kun pay tinmikid cha Jesus henan chuntug, enayakian Jesus nan chiyuycha laychuna, at enmalicha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kuncha pay inumchan, chinutokana nan hinpuru ya chuwa ay apostolesna ta chicha nan kadkadwana, ya ifiaorna ay uy mun-ekaskasaba. ");
INSERT INTO ebk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Inchatna us chi kalibfengan kan chicha ay mun-epafoknag as nan chiyuycha anennet. ");
INSERT INTO ebk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chatona nan hinpuru ya chuwa ay pinilen Jesus: hi Simon (ay ngenadnana as Pedro), ");
INSERT INTO ebk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nan hen-aki ay cha Santiago kan Juan ay potot Zebedeo (ay chicha nan ngenadnana as Boanerges ay nan laychuna ay kanan at “An-ak chi Kud-or”); ");
INSERT INTO ebk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","hi Andres, hi Felipe, hi Bartolome, hi Mateo, hi Tomas, hi Santiago ay potot Alfeo, hi Tadeo, hi Simon ay mangesasaket as nasyona, ");
INSERT INTO ebk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ya hi Judas Iscariote ay mangesepseptu kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kun pay narpas chi, kenmatam cha Jesus. Ongor kasin chi tataku ay naamong, at kun achi mawayaan hiya ya nan disipulusna ay mangan. ");
INSERT INTO ebk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","As nan nanngoran nan iib-ana as na, inmuycha as nan kawad-an Jesus ta ekatamcha hiya, tay wachacha nan tataku ay cha mangarkali un uy at natongtongok hiya. ");
INSERT INTO ebk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nan tapen nan mun-isursuru as Lintig ay kinmuwab ay nurpu ad Jerusalem at chacha kankanan, “Nan sinungkop man kan hiya at hi Beelzebub! Hiya nan ap-apon nan chiyuycha anennet ay nangichat as pannakafialina ay mangepak-ak as nan chiyuycha anennet.” ");
INSERT INTO ebk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kun pay enommat na, enayakian Jesus chicha, ya kanana kan chicha ay mangepadpachong, “Anan atun Satanas ay mangepak-ak as achorna? ");
INSERT INTO ebk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mu munkikinnufiat nan tataku henan usa ay muntorayan, machachael nan hana ay muntorayan. ");
INSERT INTO ebk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kaman us as nan hinfiaruy ay mu masusumacha at masisiyanchantu. ");
INSERT INTO ebk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mu makepatuy hi Satanas as nan chiyuycha anennet ay etorayana ya masisiyancha, munpatingkia nan pannakafialina. ");
INSERT INTO ebk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Maid makaskop as nan afong nan usa ay kursi ay taku ta akiwuna nan kuk-uwan tosa sukúdna on-ona etakud hiya, at mafialina ay akiwun nan wacha as nan afongna. ");
INSERT INTO ebk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ifiakiak kan chakayu nan tit-iwa ay mafialin ay mapakawan nan tataku as nan am-in ay fiasfiasorcha ya uray nan am-in ay karkalicha ay maifusor kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngem nan taku ay munkali as maifusor as nan Espiritu Santo at achi poros mapakpakawan, tay nan enatna at fiasor ay maid patingkiana.” ");
INSERT INTO ebk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kenalen Jesus na, tay kenalicha ay naanennetan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Angkiay ya enmali hi enana ya nan susnúdna ay lanaraki as nan afong ay kawad-ana. Nangatakchugcha as nan fiattaw, ya enpaayagcha hiya. ");
INSERT INTO ebk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ongor chi tataku ay nangatokor ay nangaarufong kan Jesus, ya kanancha kan hiya, “Wacha hi enam ya nan susnúdmu ay lanaraki as nan fiattaw ay cha mangepaayag kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tinumfor hi Jesus, “Ngachancha nan kanam ay enak ya susnúdku?” ");
INSERT INTO ebk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nuntat-allang as nan nangaarufong kan hiya, ya kanana, “Nauycha nan tit-iwa ay enak ya susnúdku! ");
INSERT INTO ebk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nan uray ngachana ay mangekaman as nan enkeddeng Apo Dios ay atuna at hiya nan tit-iwa ay sunúdku ay laraki winnu fiafiai ya enak.” ");
INSERT INTO ebk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kasin nun-isuru hi Jesus henan olet nan Fiayfiay ay Galilea. Kiapú ta ongoongor chi tataku ay naamong kan hiya, uy tenmokor hiya as nan fiangka ay wacha henan fiayfiay. Nan ongoongor ay tataku at wachacha henan oletna. ");
INSERT INTO ebk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ongor chi insursuron Jesus kan chicha ay maepadpachongan, ya as nan nun-is-isuruwana, kenalina kan chicha, ");
INSERT INTO ebk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Chungrunyu! Wacha nan usa ay taku ay uy nun-iwagwag. ");
INSERT INTO ebk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","As nan chana munwagwagwakian, nag-as nan tapen nan fokel as nan charan. Angkiay ya enmalicha nan kossel ya kenancha. ");
INSERT INTO ebk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nan tapina at nag-ascha as nan machupras ay lukiar ay ak-akettuy chi lutana. Kiapú ta ak-akettuy chi lutana, henkemad ay linmisimcha. ");
INSERT INTO ebk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kun pay penomtang nan urkiw, nakling nan chiyuycha cha tomemel. Kiapú ta chaancha lenmamot ad chur-um, narangucha. ");
INSERT INTO ebk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nan tapina at nag-ascha as nan kaongoran chi sufet. Naikisancha ay tinmufu as nan ongor ay sufet. Naskorcha ya chaancha finumkias. ");
INSERT INTO ebk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nan tapina ay fokel at nag-ascha as nan ammay ay luta. Tinmufucha ya nasikuncha, at finumkiascha ya enmongorcha as maturon pupuru, maunum pupuru ya mahinkiagsot.” ");
INSERT INTO ebk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Inyanongos Jesus, “Nan wachay ingana ay chumngor at masapor chumngor.” ");
INSERT INTO ebk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kun pay nauusa hi Jesus, nakiuy kan hiya nan tapen nan tataku ay kadwacha nan hinpuru ya chuwa ay disipulus, ya senarudsudcha nan maepangkep as nan maepadpachongan. ");
INSERT INTO ebk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tinumfor hi Jesus kan chicha, “Kan chakayu nan naepakaammuwan nan chiyuycha chaan naam-ammuwan ay maepangkep henan muntorayan Apo Dios. Ngem as nan tapina ay achi omafurot kan ha-un at kun maepadpachong nan am-in ay maisursuru ");
INSERT INTO ebk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ta ‘uray mu ilailauncha, achicha challu ematonan, ya uray mu chungruchungruncha, achicha challu maawatan. Tay mu atuncha chaná at munfiangadcha kan Apo Dios, at pakawanuna chicha.’” ");
INSERT INTO ebk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Angkiay ya nunsarudsud hi Jesus kan chicha, “Ay kunyu chamman achi maawatan na ay maepadpachongan? Anan atunyu ngay ngarud ay mangammu as nan laychun ay kanan nan tapina ay maepadpachongan? ");
INSERT INTO ebk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nan chiyuycha fokel ay inwagwag nan mun-iwagwagwag at hiyana nan kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nan tapen nan tataku at maepachongcha as nan fokel ay nag-as as nan charan. As nan manngorancha as nan nauy ay kali, maannali hi Satanas ya kaanuna nan hana kali ay chinngorcha. ");
INSERT INTO ebk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Assesa us as nan chiyuycha fokel ay naiwagwag as nan machupras ay lukiar. Maepachongcha as nan tataku ay naragsak ay mang-awat ay dagus as nan kalen Apo Dios as nan manngorancha. ");
INSERT INTO ebk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Achi lomamot ay ustu as nan numnumcha, ya kun hen-omaketan chi omafurotancha. Angkiay ya as nan omaliyan nan likiat winnu mapalikiatancha kiapú as nan enmafurotancha as nan kalen Apo Dios, hiya at chi ya achicha ituruy ay omafurot. ");
INSERT INTO ebk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kun pay nan chiyuycha naiwagwag as nan tinmufuwan chi ongor ay sufet at maepachongcha as nan tataku ay manngor as nan kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ngem nan chanchanagcha, nan layadcha ay fumaknang, ya nan tapina ay laylaychuncha ay araun at sulinuncha nan kalen Apo Dios. Mu hiyasa, achicha fumkias. ");
INSERT INTO ebk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngem nan chiyuycha naiwagwag as nan ammay ay luta at chicha chi nan maepachong as nan tataku ay manngor ya mang-awat as nan kalen Apo Dios. Fumkiascha as maturon pupuru, maunum pupuru, ya mahinkiagsot.” ");
INSERT INTO ebk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Inturuy Jesus ay nun-epadpachong, “Ay napaskuchan nan pingki ta maop-opan as fianga winnu maipuuy as nan selok nan kama? Ay kun at achi epatang as nan maepatpatngana? ");
INSERT INTO ebk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tay maid naetatafun ay achintu maepaila, winnu maid chaan naepakaammu as achintu munmallag. ");
INSERT INTO ebk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nan wachay ingana ay chumngor at masapor chumngor.” ");
INSERT INTO ebk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kenalen pay Jesus kan chicha, “Numnumunyu ay ustu nan chungrunyu! Nan panglukudyu as nan pachongyu ay tataku, assesantu us nan panglukud Apo Dios kan chakayu, ngem kaskasin pay. ");
INSERT INTO ebk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tay nan taku ay wachay kafiaelana at maettan as ong-ongor. Nan taku ay maid kafiaelana at uray nan ak-akettuy ay wacha kan hiya at maarantu.” ");
INSERT INTO ebk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kasin nun-epachong hi Jesus, “Nan muntorayan Apo Dios at maepachong as nan taku ay uy mun-iwagwag as fokel chi trigo as umana. ");
INSERT INTO ebk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","As nan massuyana as nan lenafi ya fumangunana as nan winiet, at chacha tumufu ya masikun nan fokel, ngem achina ammu mu anan enatcha ay tinmufu ya nasikun. ");
INSERT INTO ebk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tay nan luta mismu nan manikun ya mangepafukias as nan chiyuy naetanum. Omon-ona at pom-on, angkiay mamusfus. Angkiay ya manorchang. ");
INSERT INTO ebk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kun pay nabkiasan chi, uyna aniyun ay dagus, tay panag-aani.” ");
INSERT INTO ebk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Inturuy Jesus, “Ngachana nan mangepachongan takú henan muntorayan Apo Dios, winnu ngachana ay maepadpachongan nan osarok? ");
INSERT INTO ebk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maepachong as nan fokel chi mostasa ay kaek-ektelan as nan am-in ay fokel asna's luta. ");
INSERT INTO ebk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ngem kun pay maetanum, masikun ya munfialin as kaad-acha-anan as nan am-in ay naetanum as uma. Somapang as anad-acha, isunga mafialin ay somollongan chi kossel nan omalenong ay pangana.” ");
INSERT INTO ebk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ongor chi assesena ay maepadpachongan ay enos-osar Jesus as nan nangekaskasabaana as nan kalen Apo Dios kan chicha. Insursuruwana chicha as nan kafiaelancha ay mangawat. ");
INSERT INTO ebk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kun maepadpachongan am-in nan enosarna ay naketagtakiatfor kan chicha. Ngem as nan maaangkiayancha, epakaawatna as nan disipulusna nan am-in. ");
INSERT INTO ebk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","As nan hana ay urkiw as nan naschum, kenalen Jesus as nan disipulusna, “Kumchang takú henan fiayfiay ta umuy takú ad chumang.” ");
INSERT INTO ebk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nunlukian nan disipulusna as nan fiangka ay nangatokoran Jesus ya tenaynancha nan ongoongor ay tataku. Wachacha pay nan tapina ay fiangka ay nakiuy kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kalina at ya enmali nan mun-atifudfud ay angin. Pararu ay cha sopsopyatan nan challuyon nan fiangka, isunga kiayud lumnud. ");
INSERT INTO ebk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ngem nanassuy hi Jesus ay nangapongan as nan uchichen nan fiangka. Finangun nan disipulus hiya, ya kanancha, “Misturu, ay achim pakian-anu uray mu lumnud takú?” ");
INSERT INTO ebk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Finmangun hi Jesus, ya infilina as nan angin ya nan challuyon, “Kuminak kayu!” Kinminak nan angin, ya ammay kasin as solet. ");
INSERT INTO ebk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kenalen Jesus kan chicha, “Adchi t'uy kayu umugyat? Ay maid poros pammatiyu?” ");
INSERT INTO ebk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naschaawcha as solet ya nunsesennarudsudcha, “Anan ngachan ngun tona t'uy uray angin ya challuyon at tongparunchay filina?” ");
INSERT INTO ebk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Inturuy cha Jesus ay kinumchang henan fiayfiay inkiana inumchancha henan sasakopun nan i-Gerasa. ");
INSERT INTO ebk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kun pay nunchissaag hi Jesus as nan fiangka, wacha nan nanib-at kan hiya ay usa ay laraki ay naanennetan ay nurpu henan lurubfok ");
INSERT INTO ebk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ay mamagyanana. Maid at makaetakud kan hiya, uray mu kor-ong nan maosar. ");
INSERT INTO ebk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tay namen ongor ay nakor-ongan nan limana ya sukina, ngem kuna challu senokposokpot ya chenachaelna nan kor-ong nan sukina. Maid makaepakud kan hiya, tay kurkursiyan. ");
INSERT INTO ebk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Inurkiw ya lenafi at cha munlikulikud hiya henan lurubfok ya chunchuntug ay cha mun-uweuwek ya chana ug-ugchun nan achorna as fiatu. ");
INSERT INTO ebk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kuna pay inila hi Jesus henan ad-achawwi pay laing, tenmagtag ay inmuy kan hiya ya nunpalintumang as nan sangwanana. ");
INSERT INTO ebk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Inpigsana ay nangifukiaw, “Jesus ay Anak nan Kangatuwan ay Dios, anan ngachana nan laychum ay atun kan ha-un? Munsapataka kan Apo Dios ay achiyak palikiatun.” ");
INSERT INTO ebk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kenalina na, tay kenalen at Jesus kan hiya, “He-a ay anennet, mak-akka kan tona ay laraki!” ");
INSERT INTO ebk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Angkiay senarudsud Jesus kan hiya, “Anan ngachanmu man?” “Liniblifu nan ngachanku, tay ongoongor kami,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Angkiay ya kuncha cha munpakapakaasi kan Jesus ay achina paat pak-akun chicha henan hana ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","As nan naesasag-un, wachachay ongoongor ay fiafuy ay cha munsuksukor henan filig. ");
INSERT INTO ebk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Enpakaasen nan chiyuycha anennet kan Jesus, “Ifiaormu ngarud chakami as nan chiyuycha fiafuy ta sugpunmi chicha.” ");
INSERT INTO ebk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Isunga penarufusan Jesus chicha. As nan hiyachi, fenmoknag nan chiyuycha anennet as nan laraki ya sinungkopcha as nan chiyuycha fiafuy. Angkiay ya kenamon nan chiyuycha fiafuy ay chinmayyu inkiana nag-ascha henan teng-el, ya nurningcha henan fiayfiay. Nan filang nan chiyuycha fiafuy at umuy as chuwan lifu. ");
INSERT INTO ebk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kun pay inilan nan chiyuycha mun-ay-aywan as fiafuy nan enommat, tenmagtagcha ya uycha enpachamag as nan tataku henan ili ya sigsikib. Inmuy nan tataku ay uy nangila as nan enommat. ");
INSERT INTO ebk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kuncha pay inumchan as nan kawad-an cha Jesus, inilacha nan laraki ay nak-akan nan liniblifu ay anennet. Nangatokor hid-i ya nangafiachu, ya ammay at chi numnumna. As nan hiyachi, inmugyatcha am-in as solet. ");
INSERT INTO ebk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Angkiay ya nan chiyuycha nangila as na at infiakiacha as nan tataku nan enommat as nan naanennetan ay laraki ya nan enommat as nan chiyuycha fiafuy. ");
INSERT INTO ebk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Angkiay enlapucha ay nunpakaasi kan Jesus ta mak-ak hiya henan lukiar ay sasakopuncha. ");
INSERT INTO ebk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kun pay cha uy munlukian hi Jesus as nan fiangka, nunpakaasi nan laraki ay fenmoknakian nan chiyuycha anennet ta makiuy koma kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngem chaan penarufusan Jesus hiya. Kuna at kenali kan hiya, “Komatamka as nan iib-am, ya ifiakiam nan am-in ay enat Apo Dios kan he-a ya nan ongor ay sug-angna kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Angkiay ya nak-ak ay inmuy henan makali un Hinpuru ay Siyudad ay cha mangifiagfiakia as nan enat Jesus kan hiya. Naschaaw nan am-in ay tataku ay nanngor. ");
INSERT INTO ebk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nunfiangka kasin cha Jesus ay kinumchang ad chumang. Kun pay nunchissaag hiya henan olet nan fiayfiay, enarufong nan ongoongor ay tataku hiya. ");
INSERT INTO ebk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Angkiay ya enmali nan usa ay ap-apu as nan senagoga ay nan ngachana at Jairo. Kuna pay inila hi Jesus, nunlukfub as nan sangwanana, ya kanana, ");
INSERT INTO ebk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Cha maongos nan fumarasang ay pototku. Omalika pay ta epataymu nan limam kan hiya ta omammay ya mataku hiya.” ");
INSERT INTO ebk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nakiuy hi Jesus kan hiya. Kuncha pay cha manad-aran, inmunud nan ongoongor ay tataku ya senmaliyubyubcha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wacha hid-i nan usa ay fiafiai kan chicha ay kun cha mun-ichaichara as hinpuru ya chuwa ay tawwun. ");
INSERT INTO ebk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ongor chi likiatna as nan uyna nunpaakiaakiasan as nan ongor ay choktor, ya kinastosna pay nan am-in ay sipingna. Omammay koma hiya, ngem kun at kenmaskasin. ");
INSERT INTO ebk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nachamagna nan maepangkep kan Jesus. As nan hiyachi, nakitun-ud as nan ongoongor ay tataku inkiana naesnop as uchug Jesus, ya kenpana nan fiachuna, ");
INSERT INTO ebk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","tay kanana as numnumna, “Mu kunku paat kap-un uray nan fiachuna at omammayak.” ");
INSERT INTO ebk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hiya at chi ya nakyat tit-iwa nan cha fomokfoknag ay charana, ya keneknana ay nakaan nan saketna. ");
INSERT INTO ebk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","As nan hiyachi, nakeknan Jesus ay nak-ak chi pannakafialin kan hiya. Isunga nunsakong hiya as nan ongoongor ay tataku, ya kanana, “Ngachana nan nangpa as nan fiachok?” ");
INSERT INTO ebk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tinumfor nan disipulusna, “Ilaum at ongoongor chi tataku ay nangaarufong kan he-a, angkiay sarudsuchum pay laing mu anan nangpa kan he-a?” ");
INSERT INTO ebk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ngem nuntat-allang hiya ay nangila mu ngachana nan nangekaman hid-i. ");
INSERT INTO ebk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kiapú ta ammon nan fiafiai nan enommat kan hiya, enmali ay cha munpappapayagpag kiapú as ugyatna ya nunlukfub as nan sangwanan Jesus. As nan hiyachi, infiakiana kan Jesus nan am-in ay tit-iwa. ");
INSERT INTO ebk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Angkiay ya kenalen Jesus kan hiya, “Anakku, nan pammatem nan nangepaammay kan he-a. Uyka ay kun natalna nan numnummu, tay enmammayka at.” ");
INSERT INTO ebk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kun pay kukutug ay cha munkarkali hi Jesus, wachacha at nan enmali ay nurpu as afong Jairo ay ap-apu as nan senagoga. Kenalicha kan Jairo, “Natuy at nan pototmu ay fumarasang. Anum pay laing lilifokun nan misturu?” ");
INSERT INTO ebk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Chaan penakian-anon Jesus nan kenalicha. Ngem kuna at kenali kan Jairo, “Achika umugyat. Kunka omafurot yangkiay.” ");
INSERT INTO ebk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Maid tukún as penarufusan Jesus ay umunud kan hiya kun yangkiay cha Pedro kan Santiago ya hi Juan ay sunúd Santiago. ");
INSERT INTO ebk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kuncha pay inumchan as nan afong Jairo, inilan Jesus nan ongor ay tataku ay cha mun-at-atengorngor. Chacha managchaku ya mun-ag-akor as napigsa. ");
INSERT INTO ebk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sinungkop hiya, ya kanana kan chicha, “Adchi tu'y kayu cha mun-at-atengorngor ya mun-ag-akor? Nan onga at chaan natuy, ngem kun yangkiay nanassuy.” ");
INSERT INTO ebk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kuncha at enam-amrang hiya. Ngem enpapitiwna am-in chicha, ya enayakiana nan ama ya enan nan onga, ya nan chiyuycha turu ay disipulusna. Angkiay enpanguna chicha as nan kawad-an nan onga. ");
INSERT INTO ebk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Inunnana nan liman nan onga, ya kanana kan hiya, “Talita, kum!” Nan laychuna ay kanan at, “Fumarasang, fumangunka!” ");
INSERT INTO ebk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hiya at chi ya finmangun tit-iwa nan fumarasang ya nanaran. (Hinpuru ya chuwa nan tawwuna.) Naschaawcha as solet nan nakiuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ngem infilin Jesus kan chicha ay maid poros mangifiagfiag-ancha as nan enommat. Angkiay ya infiakiana kan chicha ay umichatcha as kanun nan fumarasang. ");
INSERT INTO ebk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nak-ak hi Jesus hid-i, ya inmuy henan mismu ay ilina. Nakiuycha nan disipulusna kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","As nan Urkiw ay Mun-iblayan, enlapuna ay nun-isuru as nan senagoga, at naschaaw nan ongor ay nanngor kan hiya. Kenalicha, “Ay chaud ngun nan nangor-an tona ay taku as nan nauycha isursuruna? Ngantona ngun ay kenasilib nan naichat kan hiya? Anan atuna ngun ay mangekaman as milagro? ");
INSERT INTO ebk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ay fiakun hiya nan mun-am-amma as afong ay anak Maria, ya panguruwan cha Santiago, Jose, Judas ya hi Simon? Ay fiakun nan nauycha susnúdna us ay fianafiai at nakiiilicha kan chitaku?” Angkiay ya enachicha at hiya. ");
INSERT INTO ebk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kenalen Jesus kan chicha, “Maichayaw nan pomapadtu henan kumpurmi ay lukiar, omangkiay henan mismu ay ilina ya as nan iib-ana ya pamilyana.” ");
INSERT INTO ebk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Maid enkaman Jesus as nakaskaschaaw hid-i, kun yangkiay nan nangepatayana as limana as nan chiyuycha akét ay cha munsaket, ya enpaammayna chicha. ");
INSERT INTO ebk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Naschaaw hiya kiapú ta maid pammaticha kan hiya. Angkiay ya nunfiabfiaat hi Jesus ay cha mun-is-isuru henan chiyuycha fiabruy hid-i. ");
INSERT INTO ebk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Enayakiana nan hinpuru ya chuwa ay disipulus, ya infiaorna chicha ay hinchudwa. Inchatnay kalibfengan kan chicha ay mangepak-ak as nan chiyuycha anennet. ");
INSERT INTO ebk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Infilina us kan chicha, “Maid etakinyu as nan munfiaatanyu, kun yangkiay surkudyu. Achi kayu ometakin as sangát, passek ya siping as forsayu. ");
INSERT INTO ebk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Munsandal kayu, ngem achi kayu ometakin as fiachu ay munsokatanyu. ");
INSERT INTO ebk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","As nan ngachana ay ili ay ay-ayanyu ay wachay mangmangili kan chakayu as afongna, hid-i nan magyananyu inkiana mak-ak kayu henan hana ay ili. ");
INSERT INTO ebk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mu maid poros mangmangili kan chakayu henan ngachana ay lukiar ya achicha chumngor kan chakayu, mak-ak kayu hid-i. As nan mak-akanyu, pokpokanyu nan tapok as nan chapanyu ta epailayu ay maid fiyangyu kan chicha mu chusaun Apo Dios chicha.” ");
INSERT INTO ebk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Isunga uycha enkasaba as nan tataku ay masapor munfiafiawicha as nan fiasfiasorcha. ");
INSERT INTO ebk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Enpafoknagcha nan ongor ay anennet as nan nunkaanennetan. Angkiay kenapuwancha as lana nan ongor ay munsaket, at nakaan nan saketcha. ");
INSERT INTO ebk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nachamag Ari Herodes ad Galilea nan en-enat Jesus, tay nunchinngor nan ngachan Jesus henan am-in ay lukiar. Kenalen nan tapen nan tataku, “Hiya hi Juan ay Fumufunyag ay kun kasin nataku. Isunga wacha kan hiya nan pannakafialin ay mangekamkaman as nan nauycha nakaskaschaaw.” ");
INSERT INTO ebk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngem kenalen nan tapina, “Hiya hi Elias.” Kenalen pay nan tapina, “Usa hiya ay pomapadtu ay kaman usa as nan chiyuycha pomapadtu ad pus-uy.” ");
INSERT INTO ebk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kun pay chinngor Herodes chaná, kenalina, “A, hiya hi Juan ay Fumufunyag ay enpasiwatku nan uruna! Kun payat kasin nataku!” ");
INSERT INTO ebk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kenalen Herodes chi, tay hiya nan nangepatiliw ya nangepafiarud kan Juan ay nakokor-ongan. Enat Herodes na ta palaylaychuna hi asawana ay Herodias kiapú ta kenontrakontran Juan hi Herodes, tay enasawana nan ingudna ay asawan Felipe ay sunúdna. ");
INSERT INTO ebk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tay kenarkalen ngamin Juan kan Herodes, “Epawan nan lintig ay asaw-um nan ingudmu.” ");
INSERT INTO ebk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Isunga wachay ingor Herodias kan Juan, at laychuna ay epapatuy hiya, ngem achina maekaman. ");
INSERT INTO ebk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kiapú ta umugyat hi Herodes kan Juan, ensarakana hiya, tay ammuna ay nalintig ya nasantowan hiya. Uray mu nalilifokan as solet hi Herodes as nan chana manmanngoran as nan isursuron Juan, laylaychuna challu ay chumchumngor kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ngem kun pay inumchan nan chansan Herodias as nan urkiw ay mangnumnumnumancha as nan naiyanakan Ari Herodes, nunsicha hi Herodes. Enpaayagna nan am-in ay nunkangatu ay opisyar as nan goberno, chiyuycha komander chi sosorchachu ya nan mafigfigfig ay tataku henan probinsiya ay Galilea. ");
INSERT INTO ebk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","As nan sinungkopan nan anak Herodias ay fiafiai ya nunsasara, nalaylaychan hi Herodes ya nan chiyuycha mangilina. Isunga kenalen Ari Herodes as nan fiarasang, “Chawatum kan ha-un nan kumpurmi ay laychum, at ichatku kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ensapatana as nan fiarasang, “Uray mu ngachanay chawatum kan ha-un at ichatku kan he-a, uray ud-ay kakudwan nan chak etortorayan.” ");
INSERT INTO ebk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pinmitiw nan fiarasang, ya uyna senarudsud kan enana, “Ngachana nan chawatok?” “Nan uron Juan ay Fumufunyag,” ensongfiat enana. ");
INSERT INTO ebk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Angkiay ya naannuuy nan fiarasang as nan ari, ya kanana kan hiya, “Nan laychok at ichatmu ay dagus nan uron Juan ay Fumufunyag ay maiittu as nan paratu.” ");
INSERT INTO ebk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pararu ay nalilifokan nan ari, ngem kiapú ta nun-ekari as nan sangwanan nan am-in ay mangilina, mafiain ay achi mangekaman as nan enkarina kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hiya at chi ya infiaorna nan usa ay sorchachu ay mangiyali as nan uron Juan. Inmuy tit-iwa nan sorchachu, ya siniwatna nan uron Juan as pagfiaruchan. ");
INSERT INTO ebk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Inyuyna nan uru ay naiittu as nan paratu, ya inchatna as nan fiarasang. Angkiay nan fiarasang at inchatna kan enana. ");
INSERT INTO ebk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kun pay nachamag nan disipulus Juan na, enmalicha ay nangara as nan achorna, at uycha inlufok. ");
INSERT INTO ebk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nunfiangad nan apostoles kan Jesus, ya infiakiacha nan am-in ay en-enatcha ya nan insursurucha. ");
INSERT INTO ebk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kiapú ta ongor chi tataku ay cha omaliali kan chicha ya ongorcha us chi cha mak-amak-ak, maid wayacha ay mangan. Isunga kenalen Jesus as nan disipulusna, “Ayu! Uy takú henan kamaid chi tataku ay kun chitchitaku yangkiay ta munpangaiblay kayu as hen-omaketan.” ");
INSERT INTO ebk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Isunga nunfiangkacha ay inmuy henan kamaid chi tataku ay kun chidchicha yangkiay. ");
INSERT INTO ebk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ngem ongor ay tataku nan nangematon kan cha Jesus as nan nunligwatancha. Tenmagtagcha ay nurpu henan am-in ay ili, at enmon-onacha ay inumchan henan uy ay-ayan cha Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kun pay nunchissaag hi Jesus, inilana nan ongoongor ay tataku. Nasug-ang hiya kan chicha, tay kamancha karnero ay maid mangay-aywan kan chicha. Isunga enlapuna ay nangisuru kan chicha as ongor ay sursuru. ");
INSERT INTO ebk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kun pay cha maschum, inmuy nan disipulus kan hiya, ya kanancha, “Nauy takú henan kamaid chi umili ya cha us maschum. ");
INSERT INTO ebk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Epakatammu nan nauycha tataku ta umuycha henan naesasag-un ay fiabfiabruy ya uycha lomaku as kanuncha.” ");
INSERT INTO ebk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngem tinumfor hi Jesus kan chicha, “Chakayu mismu nan mangichat as kanuncha.” Angkiay senarudsudcha, “Ay uy kami lomaku as tenapay ay munfiaror as chuwan kiasot ay dinario ta ichatmi as kanuncha?” ");
INSERT INTO ebk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Senarudsud us Jesus, “Kaatnay tenapay nan wacha kan chakayu? Uyyu ilaun.” Kuncha pay naammuwan, nunfiangadcha, ya kanancha kan hiya, “Lema ay tenapay ya chuwa ay filis.” ");
INSERT INTO ebk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Angkiay infilina kan chicha ay epaar-arubfongcha nan tataku ay tomokor as nan lukiam. ");
INSERT INTO ebk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Isunga tenmokorcha ay naar-arubfong as hinkiagsot ya henlelman pupuru. ");
INSERT INTO ebk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","As nan hiyachi, enaran Jesus nan lema ay tenapay ya nan chuwa ay filis ya nuntangad ad chaya ay munyaman kan Apo Dios. Kun pay narpas, pinutput-ingna nan chiyuycha tenapay, ya inchatna as nan disipulusna, ya nan disipulusna at inwarascha as nan ongoongor ay tataku. Kinudkudwana us nan chuwa ay filis, ya enpaiwarasna kan chicha am-in. ");
INSERT INTO ebk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nangancha am-in, at nasufucha. ");
INSERT INTO ebk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Haat amongun nan disipulus nan chinaancha ay tenapay ya filis ay namnu as nan hinpuru ya chuwa ay uppig. ");
INSERT INTO ebk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nan filang nan lanaraki yangkiay ay nangan at leman lifu. ");
INSERT INTO ebk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","As nan cha mangepakataman Jesus as nan ongoongor ay tataku, hiya at chi ya enpalukiana nan disipulusna as nan fiangka, ya enpaon-onana chicha ay kinumchang ad chumang ad Betsaida. Kuna pay enpakatam chicha, ");
INSERT INTO ebk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","tinmikid hiya henan chuntug ta uy munkararag. ");
INSERT INTO ebk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","As nan naschum, wacha nan fiangka ay nunlurukianan nan disipulusna henan kiawan nan fiayfiay. Kun pay hi Jesus, nauusa pay laing henan chuntug. ");
INSERT INTO ebk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Inilan Jesus nan chiyuycha disipulusna ay cha maliglikiatan ay mangepacharan as nan fiangka, tay kuncha sisib-atun chi angin. Kun pay nakapis, inmuy kan chicha hi Jesus ay cha manarcharan as nan oson nan chanum. Elas-iyana koma chicha, ");
INSERT INTO ebk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ngem as nan nangil-an nan disipulus kan hiya ay cha manarcharan as nan oson nan chanum, ninumnumcha ay uy at usa ay anennet. Nun-uwekcha, ");
INSERT INTO ebk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tay inmugyatcha as solet as nan nangil-ancha am-in kan hiya. Ngem nunkanan at Jesus kan chicha, “Papigsaunyu nan numnumyu! Ha-un na ya! Achi kayu umugyat!” ");
INSERT INTO ebk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Angkiay ya nakilukian hiya kan chicha as nan fiangka, at kinminak nan angin. Naschaawcha as solet, ");
INSERT INTO ebk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tay chaancha pay naawatan nan tit-iwa ay laychun ay kanan nan nangepaongoran Jesus as nan tenapay, tay tenmangken chi numnumcha. ");
INSERT INTO ebk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","As nan kinumchangancha henan fiayfiay, inumchancha ad chumang henan lukiar ay Genesaret, ya entakudcha nan fiangka. ");
INSERT INTO ebk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kuncha pay nunchissaag as nan fiangka, enmatonan at nan tataku hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Isunga tenmagtagcha henan intiru ay lukiar, ya inyaattangcha nan chiyuycha munsaket ta iyuycha henan uray ay chaud ay nanngorancha ay kawad-an Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Uray mu ay chaud nan ay-ayan Jesus ay kaman henan fiabfiabruy, il-ili winnu sigsikib, inyuy nan tataku nan chiyuycha munsaket as nan mun-el-elakwan. Angkiay nunpakaasicha kan hiya ta paat kap-un nan chiyuycha munsaket nan uray kiayachan nan fiachuna, at enmammaycha nan am-in ay nangpa kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","As nan namingsan, naamong kan Jesus nan chiyuycha Fariseo ya nan tapen nan mun-isursuru as Lintig ay nurpu ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Inilacha ay cha mangan nan tapen nan disipulus Jesus ay chaancha nunfuru. Chaancha inunud nan ustu ay iniili ay ukialen nan Judio. ");
INSERT INTO ebk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tay nan chiyuycha Fariseo ya am-in ay Judio at chacha un-unuchun nan iniili ay ukialen nan uycha kaap-uwan ay enpatawidcha kan chicha ay hiya nan achicha manganan mu achicha munfuru. ");
INSERT INTO ebk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mu murpucha as nan mun-el-elakwan, achicha mangan sukúdcha mun-umus. Ongor pay chi tapina ay naepatawid ay iniili ay ukialicha ay kis-ancha atun ay kaman as nan mangurasancha as nan tasa, fianga ya tapina ay naammaan as kianfiang.) ");
INSERT INTO ebk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Isunga nunsarudsudcha kan Jesus nan chiyuycha Fariseo ya nan chiyuycha mun-isursuru as Lintig. Kenalicha, “Adchi t'uy achi tongparun nan disipulusmu nan iniili ay ukialen nan kaap-uwan takú, ngem kuncha at mangan ay achi munfuru?” ");
INSERT INTO ebk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Angkiay kenalen Jesus kan chicha, “Tit-iwa as solet nan enpadton Isaias maepangkep kan chakayu ay pakamankaman ay hiyana nan nauy naisurat as nan Kalen Apo Dios, ‘Nan nauycha tataku at chaychayawunak as nan kalicha, ngem achawwi challu nan numnumcha kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Maid kotok nan chacha manaychayawan kan ha-un, tay nan chacha isursuru at linlintig ay enammaan chi taku ay kanancha un filfilinku.’ ");
INSERT INTO ebk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Inyangkiayanyu nan lintig Apo Dios, ya inun-unudyu nan iniili ay ukiali ay enpatawid nan tataku.” ");
INSERT INTO ebk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kenalen pay Jesus kan chicha, “Ammay met kayman chi chayu at-atun ay mangachi as nan lintig Apo Dios ta tongparunyu nan naepatawid ay iniili ay ukialiyu! ");
INSERT INTO ebk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tay nan enpaisurat Apo Dios kan Moises at kanana, ‘Rispituwum cha amam kan enam,’ ya ‘Nan ngachana ay mangituchor as amana ya enana at masapor maepapatuy.’ ");
INSERT INTO ebk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngem chayu met isuru ay mu wachay ifiachang koma nan usa ay taku kan cha amana kan enana at mafialin ay munpanfor mu kanana un, ‘Korfian na’ (Nan laychuna ay kanan at naiichat na kan Apo Dios). ");
INSERT INTO ebk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mu isuruyu sa, chayu epawa ay fiadngana cha amana kan enana. ");
INSERT INTO ebk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mu hiyasa, menaidyu nan kotok nan kalen Apo Dios kiapú as nan iniili ay ukialiyu ay chayu epatawid as nan tapina. Ongor pay chi tapina ay anassesesa ay chayu at-atun.” ");
INSERT INTO ebk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Enayakian kasin Jesus nan tataku kan hiya, ya kanana kan chicha, “Chumngor kayu am-in kan ha-un, ya numnumunyu ay ustu ta maawatanyu nan ifiakiak. ");
INSERT INTO ebk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fiakun nan okmonun nan usa ay taku nan mangepaassi kan hiya, ngem kun at nan chiyuycha epafoknagna as tapakna ay murpu as numnumna. ");
INSERT INTO ebk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nan wachay ingana ay chumngor at masapor chumngor.” ");
INSERT INTO ebk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kun pay tenaynan Jesus nan ongor ay tataku ya sinungkop as nan afong, senarudsud nan disipulusna mu ngachana nan laychun ay kanan nan maepadpachongan. ");
INSERT INTO ebk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kenalina kan chicha, “Ay uray us chakayu at achiyu maawatan? Ay achiyu ammu ay nan okmonun nan taku at fiakun hiyana nan mangepaassi kan hiya as nan mangiilan Apo Dios? ");
INSERT INTO ebk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tay nan umuyana at fiakun as numnumna, ngem kun at as putuna, at etaina challu.” (Kenalen Jesus chi ta epakaammuna ay mafialin ay kanun nan am-in ay makan.) ");
INSERT INTO ebk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Angkiay ya kenalina pay, “Nan epafoknag nan taku ay murpu as nan numnumna nan mangepaassi kan hiya as nan sangwanan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tay as nan numnum nan taku nan kurpuwan chi am-in ay manangotettet ay pangkep ay mangetoróng kan hiya ay mangepapas as assi ay lachokna, mangakiw, pomatuy, umiwet. ");
INSERT INTO ebk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Nan tapina pay ay manangotettet ay pangkep at kenaakum, kenasongel, kenamanang-allilaw, kenaruket chi ukiali, kenaapos, kenamanagkak-ali, kenapangas ya kenaruku. ");
INSERT INTO ebk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Am-in chaná ay kenamangotettet at nurpucha as nan numnum nan taku ay chicha nan munlumu as fiasor nan usa ay taku.” ");
INSERT INTO ebk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Angkiay ya nak-ak cha Jesus hid-i ya inmuycha henan sakop nan Tiro ya Sidon. Chinmawus as nan usa ay afong ya achina laychun ay maammuwan chi uray usa ay wacha hiya hid-i, ngem chaana naetafun. ");
INSERT INTO ebk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wacha nan usa ay fiafiai ay nan anakna ay fiafiai at naanennetan. As nan nanngoran nan hana fiafiai as nan maepangkep kan Jesus, naannuuy hiya ya nunlukfub as nan sangwanana. ");
INSERT INTO ebk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nan nauy ay fiafiai at naiyanak ad Fenicia ay sakop nan Siria. Nan kalina at Griego. Nunpakaasi hiya kan Jesus ta epafoknagna nan anennet as nan anakna. ");
INSERT INTO ebk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kenalen Jesus kan hiya ay mangepadpachong, “Masapor pakanun on-ona nan ongong-a, tay achi met ustu mu araun nan chacha kanun ya ichat as nan chiyuycha asu.” ");
INSERT INTO ebk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tinumfor nan fiafiai kan hiya, “O, tit-iwa sa Apo. Ngem uray nan chiyuycha asu as nan selok nan lamesaan at kanuncha nan mag-as as nan cha manganan nan ongong-a.” ");
INSERT INTO ebk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Angkiay kenalen Jesus kan hiya, “Kiapú as nan nauy songfiatmu, komatamka ud-ay, tay nak-ak at nan anennet as nan anakmu.” ");
INSERT INTO ebk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kenmatam nan fiafiai as afongcha, at inilana nan anakna ay finmafianak as nan masmassuyana. Nak-ak at tit-iwa nan anennet kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Angkiay ya nak-ak hi Jesus henan sakop nan Tiro ya inuyna ad Sidon, at inmuy henan sakop nan makali un Hinpuru ay Siyudad. Haat munfiangad henan Fiayfiay ay Galilea. ");
INSERT INTO ebk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","As nan hiyachi, wachacha nan nangiyuy kan Jesus as laraki ay nalurak ya naumor. Nunpakaasicha kan hiya ta epatayna nan limana kan hiya ta omammay. ");
INSERT INTO ebk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Isunga enek-ak Jesus hiya as nan kaongoran chi tataku ta chidchicha yangkiay. Angkiay enlorokna nan kiayyamotna as nan ingan nan laraki. Kun pay narpas, tinmubfia, ya enkapuna nan tubfiana as nan chilan nan laraki. ");
INSERT INTO ebk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nuntangad hiya ad chaya, ya nunlong-ag as napigsa, ya kanana as nan laraki, “Efata!” (Nan laychuna ay kanan at “Matkafianka!”) ");
INSERT INTO ebk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hiya at chi ya makadngor nan laraki. Nakaan chi inumorna, ya enmammay chi munkaliyana. ");
INSERT INTO ebk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Angkiay ya infilin Jesus kan chicha ay maid poros mangifiagfiag-ancha. Ngem as nan kaskasina nangifilinan as sa, kaskasincha at infiagfiakia nan enatna. ");
INSERT INTO ebk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Naschaaw as solet nan am-in ay nanngor, ya kanancha, “Anuy paat ammay am-in chi chana at-atun! Uray nan nalurak at pakadnguruna, ya nan naumor at pakaliyuna.” ");
INSERT INTO ebk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","As nan namingsan, ongoongor kasin chi naamong ay tataku kan Jesus. Kun pay nam-in chi kanuncha, enayakian Jesus nan disipulusna kan hiya, ya kanana kan chicha, ");
INSERT INTO ebk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Masug-angak as nan nauycha tataku, tay turu ay urkiw ay naketaktakincha kan ha-un, ya nam-in nan sangatcha. ");
INSERT INTO ebk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mu pakatamok chicha ay cha munchukiaang, maurawchantu as nan charan, tay achawwi nan nurpuwan chi tapina kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tinumfor nan disipulusna kan hiya, “O, ngem anan omor-an as ommat ay makan ta epakan kan chatona ay tataku henan kamaid chi umili?” ");
INSERT INTO ebk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Senarudsud Jesus, “Kaatna ay tenapay nan wacha kan chakayu?” “Kun pitu,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Infilin Jesus as nan tataku ay tomokorcha as nan luta. As nan nangor-ana as nan pitu ay tenapay, nunyaman kan Apo Dios. Kun pay narpas, pinutput-ingna cha chi, at inchatna as nan disipulusna ta iwarascha as nan tataku. Enat tit-iwa nan disipulus. ");
INSERT INTO ebk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wacha us nan akét ay aneket ay filis. Nunyaman kasin hi Jesus, at enpaiwarasna us. ");
INSERT INTO ebk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nangancha am-in, at nasufucha. Haat amongun nan disipulus nan chinaancha ay namnu as nan pitu ay uppig. ");
INSERT INTO ebk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nan filang nan tataku ay nangan at mafialin ay opat lifu. ");
INSERT INTO ebk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kun pay narpas, enpakatam Jesus nan tataku. Hiya at chi ya nunlukian hiya ya nan disipulusna as nan fiangka, ya inmuycha henan sakop nan Dalmanuta. ");
INSERT INTO ebk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wachacha nan Fariseo ay inmuy kan Jesus, ya enlapucha ay makesosek kan hiya. Chinawatcha ay omepaila hiya as nakaskaschaaw ay sinyar ay mangepaneknek ay hiya at nurpu kan Apo Dios. Enatcha na ta chistinguncha hiya. ");
INSERT INTO ebk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nunlong-ag hiya as napigsa kiapú as saket chi numnumna kan chicha, at kenalina, “Adchi ngun t'uy chumawat nan tataku ad wani as nakaskaschaaw ay sinyar? Ifiakiak kan chakayu nan tit-iwa ay maid maepaila kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tenaynana chicha, ya nunlukian kasin as nan fiangka ay kumchang ad chumang. ");
INSERT INTO ebk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Naliw-an nan disipulusna ay ometakin as sangatcha ay tenapay kun yangkiay nan usa ay tenapay ay wacha kan chicha as nan fiangka. ");
INSERT INTO ebk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Finag-an Jesus chicha as nan nangaliyana, “Il-ilaunyu nan lebaduran nan chiyuycha Fariseo ya nan lebaduran Herodes.” ");
INSERT INTO ebk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","As nan nangaliyana as chi, natatakiatforcha nan disipulusna. Kenalicha, “Infiakiana chi, tay maid sangát takú ay tenapay.” ");
INSERT INTO ebk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ammon Jesus nan chacha matatakiatforan. Isunga senarudsudna kan chicha, “Adchi t'uyyu cha matatakiatforan chi kamaid nan sangatyu ay tenapay? Ay achiyu pay laing ammu winnu maawatan? Ay kun natangken chi numnumyu? ");
INSERT INTO ebk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ay maid matayu ay mangila, ya maid ingayu ay manngor? Ay achiyu manumnum ");
INSERT INTO ebk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","nan namutput-ingak as nan lema ay tenapay ay kenan nan leman lifu ay tataku? Kaatnay uppig nan napnu as chinaancha ay enamongyu?” “Hinpuru ya chuwa,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“As nan pitu ay tenapay ay kenan nan opat lifu ay tataku, kaatna'y uppig nan napnu as chinaancha ay enamongyu?” “Pitu,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Ay achiyu pay laing maawatan?” senarudsud Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kun pay inumchan cha Jesus ad Betsaida, inyuy nan tapen nan tataku nan usa ay nafurag ay laraki kan Jesus. Nunpakaasicha kan hiya ta kap-una koma nan nafurag ta omammay. ");
INSERT INTO ebk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Penachang Jesus nan nafurag ya enek-akna henan fiabruy. Tinubfiaana nan matan nan nafurag, ya enpatayna nan limana kan hiya. Angkiay ya senarudsudna, “Ay wachay mailam?” ");
INSERT INTO ebk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nuntat-allang nan nafurag, at kenalina, “O, mailak chi tataku, ngem kamancha kaiw ay cha manarcharan.” ");
INSERT INTO ebk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Enpatay kasin Jesus nan limana as nan matan nan nafurag. Enmetoong nan nafurag, ya enmammay nan matana, at narawag nan mangiilana as nan am-in. ");
INSERT INTO ebk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Angkiay ya enpakatam Jesus hiya, ya infilina, “Komatamka at! Achika munfiangad henan fiabruy.” ");
INSERT INTO ebk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Angkiay ya inturuy cha Jesus ay inmuy henan chiyuycha fiabruy nan Cesarea Filipos. As nan chacha manaranan, senarudsudna as nan disipulusna, “Ngachana nan kanan nan tataku maepangkep kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Infiakiacha kan hiya, “Kanan met nan tapina un he-a hi Juan ay Fumufunyag, ya kanan nan tapina un he-a hi Elias. Wacha pay nan mangali un usaka as nan chiyuycha pomapadtu.” ");
INSERT INTO ebk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Senarudsud Jesus kan chicha, “Ngem chakayu ngay? Ngachana nan kananyu maepangkep kan ha-un?” Tinumfor hi Pedro, “He-a nan Cristo.” ");
INSERT INTO ebk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Angkiay ya infilin Jesus kan chicha ay maid poros mangifiagfiag-ancha as nan maepangkep kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Angkiay ya enlapon Jesus ay mangisuru as nan disipulusna ay nan Naepadtu ay Anak chi Taku at masapor mun-iliwas as ongor ay likiat. Achiyuntu nan anam-amá, nan anap-apon chi papachi ya nan chiyuycha mun-isursuru as Lintig hiya. Maepapatuytu hiya, ngem as nan marpasan chi turu ay urkiw at mataku hiya manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Narawag nan enat Jesus ay nangifiakia kan chicha. Kun pay chinngor Pedro na, enek-akna hi Jesus, at senengarana hiya kiapú as nan kenalina. ");
INSERT INTO ebk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngem as nan nunsakongan Jesus, entoongana nan tapina ay disipulusna, ya sengarana hi Pedro as nan nangaliyana, “Mak-akka Satanas! Tay nan cham numnumnumun at fiakun nan laychun Apo Dios, ngem kun at nan laychun chi taku.” ");
INSERT INTO ebk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Angkiay ya enayakian Jesus nan ongor ay tataku ya nan disipulusna. Kenalina kan chicha, “Nan taku ay manglayad ay umunud kan ha-un at masapor ikinakna ay mangekaman as nan laylaychuna, ya itiina nan korosna, haat umunud kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tay nan uray ngachana ay mangepapati ay mangesarakan as fiyagna asna's luta at malitawnantu challu. Ngem nan uray ngachana ay manglitaw as fiyagna asna's luta kiapú as pammatina kan ha-un ya as nan Ammay ay Chamag at maesarakantu. ");
INSERT INTO ebk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tay anan maaran nan taku ay mangkuwa as nan am-in ay wacha asna's luta, ngem malitawna challu nan fiyagna ay maid patingkiana ad inferno? ");
INSERT INTO ebk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Anan ngachana challu nan mafialin ay esokat nan taku ay para as nan fiyagna? ");
INSERT INTO ebk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tay nan taku ay mangifiain kan ha-un ya nan karkalek as nan nauycha tataku ad wani ay achi omafurot kan Apo Dios ya fumafiasor at ifiaintu us nan Naepadtu ay Anak chi Taku hiya as nan kasina omaliyan ay mangepaila as nan kaichayawan Amana ay kadwana nan nasantowan ay angheles.” ");
INSERT INTO ebk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kenalen pay Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa ay wachacha nan tapina kan chakayu ay nangatakchug hena ay achintu matuy inkiana ilauncha nan muntorayan Apo Dios ay wacha nan pannakafialina.” ");
INSERT INTO ebk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kun pay inmuy chi unum ay urkiw, entakin Jesus cha Pedro, Santiago ya Juan. Enpanguna chicha henan nangatu ay chuntug ay kun chidchicha yangkiay. As nan chacha mangi-iil-an kan Jesus, tinmukun chi kail-ana. ");
INSERT INTO ebk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nan fiachuna at nunfialin as mun-am-amoselap ya pinmukpukkawan. Maid maepachongana as nan naepapukaw ay fiachu ay wacha asna's luta. ");
INSERT INTO ebk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","As nan hiyachi, nunpaila kan chicha cha Elias kan Moises ay cha maketagtakiatfor kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Angkiay ya kenalen Pedro kan Jesus, “Misturu, ammay paat ta wacha takú hena. Kun kami at mun-amma as turu ay fiawi, usa kan he-a, usa kan Moises ya usa kan Elias.” ");
INSERT INTO ebk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kenalina chi, tay achina ammu nan ustu ay ifiakiana kiapú ta inmugyatcha as solet. ");
INSERT INTO ebk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Angkiay ya wacha nan lifuu ay nangalenong kan chicha, ya wacha nan kali ay nurpu as nan lifuu ay kanana, “Hi tona nan anakku ay laylaychok. Chumngor kayu kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nuntat-allangcha ay dagus, ngem maid tapina as inilacha mu achi hi Jesus yangkiay. ");
INSERT INTO ebk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","As nan chacha chumayyuwan ay nurpu henan chuntug, infilin Jesus kan chicha, “Maid mangifiagfiag-anyu as nan inilayu inkiana mataku kasin nan Naepadtu ay Anak chi Taku.” ");
INSERT INTO ebk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tenongparcha nan filina kan chicha, ngem nunsesennarudsudcha ay chidchicha yangkiay mu anan laychun ay kanan nan mataku manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ensarochakchakcha kan Jesus, “Adchi man t'uy kanan nan mun-isursuru as Lintig ay masapor omon-ona hi Elias ay omali mu hi Cristo?” ");
INSERT INTO ebk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tinumfor hi Jesus kan chicha, “Tit-iwa ay omali on-ona hi Elias ay mangesakiana as nan am-in. Ngem adchi t'uy kanan nan naisurat as nan Kalen Apo Dios ay nan Naepadtu ay Anak chi Taku at masapor ay mun-iliwas as ongor ay likiat ya achiyun chi tataku? ");
INSERT INTO ebk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngem ifiakiak kan chakayu ay enmali at hi Elias, ya enatcha kan hiya nan am-in ay lenaylayadcha ay kaman as nan kanan nan naisurat as nan Kalen Apo Dios maepangkep kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kun pay nunfiangad hi Jesus ya nan turu as nan kawad-an nan tapina ay disipulusna, inilacha nan ongoongor ay tataku ay nangaarufong kan chicha. Cha makesosek nan tapen nan mun-isursuru as Lintig as nan disipulus. ");
INSERT INTO ebk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","As nan nangil-an nan am-in ay tataku kan Jesus, naschaawcha as solet, ya tenmagtagcha ay uy nangpakomosta kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Senarudsud Jesus as nan disipulusna, “Ngachana nan chayu makesosekan kan chicha?” ");
INSERT INTO ebk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Usa as nan tataku nan tinumfor, “Apo, inyalek kan he-a nan anakku ay laraki ay achi makakali, tay inumor nan anennet hiya. ");
INSERT INTO ebk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kun kay sumru nan anennet kan hiya at tu-ukuna as nan luta. Mun-usab nan tapakna, munngesat chi fiab-ana ya kumursi nan achorna. Chinawatku as nan nauycha disipulusmu ay epafoknagcha nan anennet, ngem chaancha kenafiaelan.” ");
INSERT INTO ebk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tinumfor hi Jesus kan chicha, “Nakkuran kayu ay tataku ad wani! Maid tit-iwa pammatiyu! Anan kafiayag chi mawawad-ak kan chakayu? Anan kafiayag chi tata-unku kan chakayu? Iyaliyu man hiya kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Angkiay inyuycha hiya kan Jesus. Kun pay inilan nan anennet hi Jesus, nunkorchasuna ay dagus nan fumarfiaru. Natu-ug nan fumarfiaru ay cha munlidlidchan as nan luta ya cha umus-usab nan tapakna. ");
INSERT INTO ebk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Senarudsud Jesus as nan aman nan fumarfiaru, “Kaatna nan nangelapuwana as nan nauy cha om-ommat kan hiya?” “Nunlapu as nan kaongana,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Kun anaka un cha ichus-or nan anennet hiya as nan apuy, mu achi kay at as nan chanum ta patayuna hiya. Masug-angka pay kan chakami ya fiadngam chakami mu kafiaelam.” ");
INSERT INTO ebk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kenalen Jesus, “Adchi t'uymu kanan, ‘Mu kafiaelak’? Am-in at mafialin ay maekaman as nan taku ay wachay pammatina kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hiya at chi ya inpigsan nan aman nan fumarfiaru ay nunkali, “Omafurotak, ngem kurang nan pammatek. Fiadnganak man paat ta mataptapiyan nan pammatek!” ");
INSERT INTO ebk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kun pay inilan Jesus nan ongor ay tataku ay nagrub ay tenmagtag ay naesnop kan cha Jesus, infilina as nan anennet, “He-a ay anennet ay nanglurak ya nang-umor as nan nauy fumarfiaru, mak-akka at man kan hiya, ya achika at munfiangfiangad kan hiya!” ");
INSERT INTO ebk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nun-uwek nan anennet, ya nunkorchasuna as solet nan fumarfiaru, angkiay nak-ak. Kaman at kun nanatuy nan fumarfiaru. Isunga ongor nan nangali, “Natuy at hiya.” ");
INSERT INTO ebk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngem inunnan Jesus nan liman nan fumarfiaru, ya finanguna, at tenmakchug. ");
INSERT INTO ebk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kun pay sinungkop cha Jesus as nan omaafongancha ay chidchicha yangkiay, senarudsud nan disipulusna kan hiya, “Adchi t'uy kami chaan nakaepak-ak as nan anennet?” ");
INSERT INTO ebk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tinumfor hi Jesus, “Nan assena ay karasen chi anennet at achi maepak-ak mu achi babaen as panagkararag yangkiay.” ");
INSERT INTO ebk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nak-ak cha Jesus henan hana ay lukiar, at nar-oscha ad Galilea. Achi laychun Jesus ay maammuwan nan tataku nan kawad-ancha, ");
INSERT INTO ebk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tay chana isuruwan nan disipulusna. Kenalina, “Nan Naepadtu ay Anak chi Taku at maipurangtu as nan tataku ya patayunchantu. Kun pay matuy ya marpas chi turu ay urkiw, matakuntu hiya manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ngem chaancha naawatan nan kenalina, ya umugyatcha ay mangepoot kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Inumchancha ad Capernaum. As nan sinungkopancha as nan afong, senarudsud Jesus as nan disipulusna, “Ngachana nan enapatyu as nan charan?” ");
INSERT INTO ebk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngem kuncha am-in kinkinak, tay enapatcha mu ngachana nan kaamuchan kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kun pay tenmokor hi Jesus, enayakiana nan hinpuru ya chuwa ay disipulus, ya kanana kan chicha, “Mu ngachana nan munlayad ay omon-ona at masapor hiya nan omanongos as nan am-in ya fiabfiaarun nan am-in ay tataku.” ");
INSERT INTO ebk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Angkiay enarana nan usa ay onga, ya enpatakchugna as nan kiawacha. Enakworna, ya kanana kan chicha, ");
INSERT INTO ebk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nan uray ngachana ay mang-awat as nan ap-apud ay taku ay kaman kan tona ay onga kiapú as nan pammatina kan ha-un at ha-un nan awatuna. Nan uray ngachana ay mang-awat kan ha-un at fiakun yangkiay ha-un nan awatuna, ngem nan nangifiaor us kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kenalen Juan kan Jesus, “Misturu, inilami nan usa ay taku ay cha mangepafoknag as nan chiyuycha anennet ay cha mangosar as ngachanmu. Enpawami, tay fiakun takú met kadwa hiya.” ");
INSERT INTO ebk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngem kenalen Jesus, “Achiyu epawa, tay nan mangekaman as nakaskaschaaw ay mangosar as ngachanku at achiyak ekaliyan as maifusor kan ha-un as maaw-awni. ");
INSERT INTO ebk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tay nan taku ay achi fumusor kan chitaku at kadwa takú. ");
INSERT INTO ebk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ifiakiak kan chakayu nan tit-iwa ay nan mangepaikop as uray hentasa ay chanum kan chakayu kiapú ta tataku chakayu kan Cristo at siguradu ay maawatna nan gun-gunana.” ");
INSERT INTO ebk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nan uray ngachana ay munlumu as fumasoran chi usa as nan nauycha ap-apud ay tataku ay omaafurot kan ha-un at un-unuyna ay maetekor chi losóng ay fiatu as fiakiangna, ya maichus-or hiya henan fiayfiay. ");
INSERT INTO ebk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mu nan usa as nan limam nan kiapón chi fumasoram, putnam. Un-unuyna ay pungudka ay maetapi as nan fiyag ay maid patingkiana mu nan wacha nan chuwa ay limam, ya kunka challu umuy ad inferno as nan kawad-an chi apuy ay achi mapappauy. ");
INSERT INTO ebk_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Hid-i at achi matmatuy nan chiyuycha fikis, ya achi mapappauy nan apuy. ");
INSERT INTO ebk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mu nan usa ay sukem nan kiapón chi fumasoram, putnam. Un-unuyna ay pungudka ay maetapi as nan fiyag ay maid patingkiana mu nan wacha nan chuwa ay sukem, ya kunka challu maichus-or ad inferno. ");
INSERT INTO ebk_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Hid-i at achi matmatuy nan chiyuycha fikis, ya achi mapappauy nan apuy. ");
INSERT INTO ebk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mu nan matam nan kiapón chi fumasoram, oketam. Un-unuyna ay fuslingka ay maetapi henan muntorayan Apo Dios mu nan wacha nan chuwa ay matam, ya kunka challu maichus-or ad inferno. ");
INSERT INTO ebk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hid-i at achi matmatuy nan chiyuycha fikis, ya achi mapappauy nan apuy. ");
INSERT INTO ebk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tay am-in ay tataku at masapor mapachasanchay likiat ta omammay nan ukialicha ay maepachong as nan asin ay mangepaammay as tamtam nan chinangchang. ");
INSERT INTO ebk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ammay nan asin, ngem mu chakus at nakaan nan tamtamna, achi poros kasin omasin. Isunga komaman kayu as nan asin ta munfifinnachang kayu ya makekappia kayu as nan pachongyu ay taku.” ");
INSERT INTO ebk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kun pay nak-ak cha Jesus hid-i, inmuycha henan sakop nan Judea henan usa ay chumang nan wawwang ay Jordan. Angkiay ya kun pay naamong kasin kan hiya nan ongoongor ay tataku, insuruwana kasin chicha ay kaman challu as nan ukialina. ");
INSERT INTO ebk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Wachacha nan tapen nan Fariseo ay inmuy kan Jesus ta chistinguncha hiya as nan nanarudsuchancha, “Ay eparufus nan Lintig takú ay iyichang nan laraki hi asawana?” ");
INSERT INTO ebk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","“Anan ngachana nan infilin Moises kan chakayu?” ensongfiat Jesus kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Enparufus met Moises ay mun-amma nan laraki as kasuratan nan mun-ichangancha, at epak-akna hi asawana,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ngem kenalen Jesus kan chicha, “Insurat Moises nan nauy lintig para kan chakayu kiapú as nan kenatangken chi numnumyu. ");
INSERT INTO ebk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ngem as nan laplapon nan nafiayangan nan luta, ‘finayang Apo Dios nan taku ay laraki ya fiafiai’ay kaman as nan naifiakia as nan Kalen Apo Dios ay kanana, ");
INSERT INTO ebk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Hiyana nan kiapúna ay taynan nan laraki cha amana kan enana ta etepona hi asawana, ");
INSERT INTO ebk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","at munfialincha as us-usa.’ Isunga fiakuncha chuwa, ngem kuncha us-usa. ");
INSERT INTO ebk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nan nunteponun ngarud Apo Dios at achi koma mun-ichangun chi taku.” ");
INSERT INTO ebk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kuncha pay nunfiangad as nan afong, ensarochakchak nan disipulus kan Jesus nan maepangkep as nan chiyuy kenalina. ");
INSERT INTO ebk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kenalen Jesus kan chicha, “Nan ngachana ay laraki ay mangiyichang as asawana ya kasin omasawa hiya as tukún at umiwet. Nan hana ay enatna at fiasorna as nan enmon-ona ay asawana. ");
INSERT INTO ebk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kaman us as nan fiafiai ay mangiyichang as asawana ya kasin omasawa as tukún at umiwet.” ");
INSERT INTO ebk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","As nan namingsan, wachacha nan cha mangiyuy as ongong-a kan Jesus ta kaprosuna ay mangbendisyon kan chicha, ngem senengaran nan disipulus chicha. ");
INSERT INTO ebk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","As nan nangil-an Jesus as chi, finmungat, ya kanana kan chicha, “Yasa! Pay-anyu ay omali nan ongong-a kan ha-un. Achiyu epawa, tay nan tataku ay maepachong kan chatona ay ongong-a nan maetapi henan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ifiakiak kan chakayu nan tit-iwa ay nan achi mang-awat henan muntorayan Apo Dios ay kaman as nan atun nan usa ay onga at achi poros sungkop henan muntorayana.” ");
INSERT INTO ebk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Angkiay ya inus-ussana ay nangakwor as nan ongong-a, ya benendisyonana chicha as nan nangepatayana as limana kan chicha am-in. ");
INSERT INTO ebk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kun pay cha munligwat cha Jesus ay munfiaat, tenmagtag kan hiya nan usa ay laraki. Nunpalintumang as nan sangwanana, ya senarudsudna kan hiya, “Ammay ay Misturu, ngachana man nan masapor ay atok ay manawid as nan fiyag ay maid patingkiana?” ");
INSERT INTO ebk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kenalen Jesus kan hiya, “Adchi t'uymu kanan un ammayak? Maid poros tukún as ammay mu achi yangkiay hi Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ammom met nan filfilin Apo Dios, ‘Achika pomatuy, achika umiwet, achika mangakiw, achika munkutum ay muntistigu, achika somator, ya rispituwum cha amam kan enam.’” ");
INSERT INTO ebk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kenalen nan laraki kan hiya, “Misturu, nunlapu as nan kaongak at enafurotku met am-in chaná.” ");
INSERT INTO ebk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kun pay entoongan Jesus nan laraki, nalaylaychan kan hiya, ya kanana, “Wacha nan usa ay nunkurangam. Uymu elaku nan kuk-uwam, ya ichatmu nan lakuna as nan chiyuycha pugli, at wachantu nan kenafiaknangmu ad chaya. Mu marpas sa, unuchunak.” ");
INSERT INTO ebk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kuna pay chinngor sa, naila as lupana ay nginmuyus, ya nunnunnunungu ay nak-ak, tay nafiaknang as solet. ");
INSERT INTO ebk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","As nan hiyachi, nuntat-allang hi Jesus, ya kanana as nan disipulusna, “Anuy paat nalikiattu as nan chiyuycha wachay kenafiaknangcha ay sungkop henan muntorayan Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Naschaawcha nan disipulus as nan nangaliyana as chi, ngem kenalen kasin Jesus, “An-akku, anuy paat nalikiat ay sungkop henan muntorayan Apo Dios! ");
INSERT INTO ebk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Narakraka pay ay lumfot nan kamelio as nan los-ok nan chakum mu nan fiaknang ay sungkop henan muntorayan Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Naschaawcha as solet, ya nunsesennarudsudcha, “Ngachancha ngay ngarud nan mafialin ay maesarakan?” ");
INSERT INTO ebk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Entoongan Jesus chicha, ya kanana, “As nan tataku at achicha kafiaelan ay mangekaman as na. Ngem achi kan Apo Dios, tay kafiaelana nan am-in.” ");
INSERT INTO ebk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Angkiay kenalen Pedro kan hiya, “Enham! Tenaynanmi nan am-in, ya inmunud kami kan he-a!” ");
INSERT INTO ebk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kenalen Jesus, “Ifiakiak kan chakayu nan tit-iwa ay nan nanaynan as afongna, susnúdna, enana, amana, an-akna winnu payyiwna kiapú as nan pammatina kan ha-un ya kiapú as nan mangekasabaana as nan Ammay ay Chamag ");
INSERT INTO ebk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","at mamen hinkiasottu nan awatuna ad wani ay timpu. O, ongor pay nan awatuna ay ab-afong, susnúd, en-a, an-akna, ya payyiw. Uray mu assesa, mapalikiat challu hiya, at as tapen chi urkiw at maettantu hiya as fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ngem nan ongor ay omon-ona ad wani at omanongoschantu, ya nan ongor us ay omanongos ad wani at omon-onachantu.” ");
INSERT INTO ebk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","As nan cha tumikichan cha Jesus as nan charan ay umuy ad Jerusalem, enmon-ona hiya. Naschaaw nan disipulusna, ya inmugyat nan tataku ay cha umun-unud. Ensakiken kasin Jesus nan hinpuru ya chuwa ay disipulusna, ya infiakiana nan nauy ommattu kan hiya, ");
INSERT INTO ebk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Chumngor kayu! Cha takú tumikid ad Jerusalem! Hid-intu ay maipurang nan Naepadtu ay Anak chi Taku as nan anap-apon chi papachi ya as nan chiyuycha mun-isursuru as Lintig. Keddenganchantu hiya ay matuy, ya ipurangchantu hiya as nan chiyuycha Gentil. ");
INSERT INTO ebk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ot-otyokunchantu, tubtubfiaanchantu, sapsapletunchantu ya patayunchantu hiya. Ngem as nan maekatlu ay urkiw at matakuntu hiya manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naesnop kan Jesus nan hen-aki ay cha Santiago kan Juan ay potot Zebedeo, ya kanancha kan hiya, “Misturu, wacha nan chawatunmi ay atum koma kan chakami.” ");
INSERT INTO ebk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Senarudsud Jesus kan chicha, “Ngachan tud-i ngay nan laychunyu ay atok para kan chakayu?” ");
INSERT INTO ebk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tinumforcha kan hiya, “As nan tomokram as nan tronom as nan machaychayaw ay muntorayam at eparufusmu koma ay maketokor kami kan he-a: Nan usa at as apét kannawanmu ya nan usa at as apét kannikidmu.” ");
INSERT INTO ebk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngem kenalen Jesus kan chicha, “Achiyu ammuy chayu chawchawatun. Ay kafiaelanyu ay mangiliwas as nan likiat ay iliwasku? Ay kafiaelanyu ay matuy ay kaman as nan atok ay matuy?” ");
INSERT INTO ebk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Kafiaelanmi ya,” ensongfiatcha kan hiya. Kenalen Jesus kan chicha, “O, iliwasyuntu nan likiat ay iliwasku, ya matuy kayuntu kaman as nan atok ay matuy. ");
INSERT INTO ebk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngem fiakunku kalibfengan ay munpili as tomokor as apét kannawanku winnu as apét kannikidku, tay chatosa at para as nan chiyuycha nangesasakianaan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kun pay chinngor nan hinpuru ay disipulus nan nauy, finmungatcha kan cha Santiago kan Juan. ");
INSERT INTO ebk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Enayakian Jesus am-in chicha as nan kawad-ana, ya kanana kan chicha, “Ammuyu met ay nan chiyuycha maifilang ay mangetortoray as nan chiyuycha Gentil at epapeletcha nan laychuncha as nan chacha etortorayan. Nan anap-apucha us at etorayancha chicha. ");
INSERT INTO ebk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Fiakun koma assesa kan chakayu. Ngem kun at nan uray ngachana ay manglayad ay munfialin as amud kan chakayu at masapor hiya nan fiabfiaarunyu. ");
INSERT INTO ebk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nan ngachana ay manglayad us ay munfialin as kaamuchan kan chakayu at masapor munfialin as fiabfiaarun nan am-in ay tataku. ");
INSERT INTO ebk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tay uray nan Naepadtu ay Anak chi Taku at chaan enmali ay maserfiyan, ngem kun at munserfi ya ichatna nan fiyagna ta esarakana nan ongor ay tataku.” ");
INSERT INTO ebk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Inumchan hi Jesus ya nan disipulusna henan ili ay Jerico. As nan chacha mak-akan hid-i, nakiuy nan ongoongor ay tataku. Wacha nan usa ay nafurag ay munlemlemos ay nan ngachana at Bartimeo ay potot Timeo ay nangatokor as nan olet nan korsa. ");
INSERT INTO ebk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kuna pay chinngor ay cha mar-os hi Jesus ay i-Nazaret, enlapuna ay nangifukiaw, “Jesus ay Kianak David, sug-anganak man paat!” ");
INSERT INTO ebk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Senengaran nan ongor ay tataku hiya, ya chacha ifiakia kan hiya ay kuminak koma hiya. Ngem kenaskasina infukiaw, “Kianak David, sug-anganak man paat!” ");
INSERT INTO ebk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Enyawnen Jesus, ya kanana, “Ayakianyu hiya.” Isunga enayakiancha nan nafurag ay laraki, ya kanancha, “Papigsaum nan numnummu! Maligwatka, tay chachaka ayakian.” ");
INSERT INTO ebk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kuna pay chinngor sa, nun-iwalina nan kakiayna, natannakchug, ya inmuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Senarudsud Jesus kan hiya, “Ngachana nan laychum ay atok kan he-a?” “Misturu, makailaak koma,” ensongfiat nan nafurag kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kenalen Jesus kan hiya, “Uyka. Nan pammatem nan nangepaammay kan he-a.” Hiya at chi ya makaila nan nafurag, ya inmunud kan Jesus as nan charan. ");
INSERT INTO ebk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kun pay cha maesnop cha Jesus ad Jerusalem, inumchancha ad Betfage ya Betania henan chuntug ay Olivo. Enpaon-onana nan chuwa as nan disipulusna, ");
INSERT INTO ebk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ya kanana kan chicha, “Uy kayu henan fiabruy ay sasakiangunyu. As nan paatyu umchanan hid-i, uchananyu nan usa ay dongki ay urfun ay naetatakud ay chaan pay nasaksakayan. Fokatanyu, ya iyaliyu hena. ");
INSERT INTO ebk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mu wachay mangali kan chakayu un, ‘Adchi t'uyyu cha atun sa?’ kananyu kan hiya un, ‘Masapor nan Apo. Paifiangadnantu challu ay dagus hena.’” ");
INSERT INTO ebk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Inmuycha, at ininchanancha tit-iwa nan dongki ay urfun as nan korsa ay naetatakud as nan pantiw nan afong. Kuncha pay cha fokatan, ");
INSERT INTO ebk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","senarudsud nan tataku ay kataktakchug hid-i, “Adchi t'uyyu cha fokatan nan urfun?” ");
INSERT INTO ebk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Infiakiacha nan kenalen Jesus kan chicha, at penarufusan nan tataku chicha. ");
INSERT INTO ebk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Angkiay ya inyalicha nan urfun kan Jesus. Inyap-apcha nan chiyuycha kakiaycha as nan uchug nan urfun, angkiay nunsakay hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nan ongor ay tataku at inyapragcha nan chiyuycha kakiaycha as nan korsa. Nan tapina at inchapratcha as nan korsa nan chiyuycha sapang ay ongor chi forongcha ay senongpatcha as nan chiyuycha uma ta epailacha ay chayawuncha hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nan chiyuycha enmon-ona mu hiya ya nan chiyuycha inmun-unud at infugfukiawcha, “Maichaychayaw hi Apo Dios! Mabendisyonan koma nan omali as nan ngachan nan Apo! ");
INSERT INTO ebk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mabendisyonan koma nan cha omali ay muntoray kan chitaku ay mangesokat kan Ari David ay kaap-uwan takú! Machaychayaw hi Apo Dios ad chaya!” ");
INSERT INTO ebk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","As nan inumchanan cha Jesus ad Jerusalem, sinungkop hiya as nan templo, ya nuntat-allang as nan am-in ay wacha's chi. Ngem kiapú ta cha maschum, inmuy hiya ad Betania ay kadwana nan hinpuru ya chuwa ay disipulus. ");
INSERT INTO ebk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","As nan kafikiatana as nan nak-akancha ad Betania, nunchukiaang hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Henan ad-achawwi as akét, inilana nan kaiw ay igos ay ongor chi tufuna. Inmuy hiya ay mangila mu wachay fukiasna. Kun pay inumchan as nan kawad-an nan kaiw, ininchanana ay kun tubtufu yangkiay chi wacha, tay fiakun pay hiyachi nan timpu ay fumfumkiasan chi igos. ");
INSERT INTO ebk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Angkiay ya kenalina as nan kaiw, “Maidtu poros mangmangan kasin as nan fukiasmu.” Chinngor nan disipulusna nan kenalina. ");
INSERT INTO ebk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kuncha pay inumchan ad Jerusalem, sinungkop hi Jesus as nan fiattaw nan Templo. Enlapuna ay mangepak-ak as nan chiyuycha am-in ay cha mun-el-elaku ya nan chiyuycha cha lomaklaku hid-i. Enlokabfuna nan chiyuycha lamesaan nan chiyuycha cha munsoksokat as siping ya nan totokoran nan chiyuycha cha mun-el-elaku as karopati. ");
INSERT INTO ebk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Enpawana us ay mar-os nan ngachana ay taku ay wachay karkiacha as nan chiyuycha fiattaw nan Templo. ");
INSERT INTO ebk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Angkiay ya insuruwana nan tataku, ya kanana kan chicha, “Ay kun chaan naisurat as nan Kalen Apo Dios un, ‘Nan afongku at makali un munkarkararakian ay para henan am-in ay nasyon’? Ngem kunyu at nunfialinun as muntabtafunan chi mangaakiw!” ");
INSERT INTO ebk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kun pay nachamag nan anap-apon chi papachi ya nan chiyuycha mun-isursuru as Lintig nan kenalen Jesus, inyanapchay atuncha ay mangpatuy kan hiya, tay umugyatcha kiapú ta naschaaw nan ongor ay tataku as nan isursuruna. ");
INSERT INTO ebk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","As nan naschum, nak-ak hi Jesus henan siyudad ay kadwana nan disipulusna. ");
INSERT INTO ebk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","As nan wiet as nan chacha mar-osan, inilacha ay narangu nan kaiw ay igos inkiana as nan lamotna. ");
INSERT INTO ebk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","As nan hiyachi, nanumnum Pedro nan tuchor Jesus, ya kanana kan hiya, “Misturu, ilaum! Narangu nan chiyuy kaiw ay igos ay intuchormu.” ");
INSERT INTO ebk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","“Omafurot kayu koma kan Apo Dios,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Ifiakiak kan chakayu nan tit-iwa. Mu wachay pammatiyu kan Apo Dios ya achi kayu munchuwachuwa, mafialin ay kananyu henan nauy chuntug un, ‘Maokwatka ya maichus-orka henan fiayfiay,’ ya maekaman tit-iwa. ");
INSERT INTO ebk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Isunga ifiakiak kan chakayu ay nan uray ngachana ay chawatunyu kan Apo Dios as nan kararagyu ya afurotunyu ay naawatyu at maichattu kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kun kayu kay munkararag,mu wachay ingoryu as nan pachongyu ay taku, pakawanunyu ta pakawanun chakayu us kan Amayu ad chaya as nan fiasfiasoryu. ");
INSERT INTO ebk_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ngem mu achiyu pakawanun hiya, achi chakayu us pakawanun kan Amayu ad chaya as nan fiasfiasoryu.” ");
INSERT INTO ebk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nunfiangad kasin cha Jesus ad Jerusalem. As nan cha manad-aranan Jesus as nan fiattaw as Templo, inmuy kan hiya nan anap-apon chi papachi, mun-isursuru as Lintig ya nan anam-amá. ");
INSERT INTO ebk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Senarudsudcha kan hiya, “Anan nurpuwan man nan kalibfengam ay mangekamkaman kan chatona? Ngachana nan nangichat kan he-a as nan nauy ay kalibfengan ay mangekaman kan chicha?” ");
INSERT INTO ebk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tinumfor hi Jesus, “Wacha nan usa'y sarudsuchok kan chakayu. Mu masongfiatanyu, ifiakiaktu kan chakayu nan nurpuwan nan kalibfengak ay mangekamkaman kan chatona. ");
INSERT INTO ebk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Anan nurpuwan nan kalibfengan Juan ay munfunyag? Ay nurpu kan Apo Dios winnu as nan tataku?” ");
INSERT INTO ebk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Angkiay kenalicha ay maaapat, “Mu kanan takú un, ‘Nurpu kan Apo Dios,’ kananantu un, ‘Anuyyu ngarud chaan enafurot hiya?’ ");
INSERT INTO ebk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngem mu kanan takú un, ‘Ay nurpu as nan tataku?’ Achi mafialin!” (Umugyatcha, tay afurotun nan am-in ay tataku ay hi Juan at tit-iwa ay usa ay pomapadtu.) ");
INSERT INTO ebk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Isunga nan ensongfiatcha kan Jesus at “Tuan! Achimi ammu.” Kenalen Jesus kan chicha, “Mu hiyasa, achek us ngarud ifiakia kan chakayu mu ngachana nan nunkalibfengan as nan chak mangekamkamanan kan chatona.” ");
INSERT INTO ebk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Angkiay ya nun-epadpachong hi Jesus, “Wacha nan usa ay taku ay nuntanum as ongor ay ubas as umana. Enaradna nan naliwus, ya nunkaub as munkopkopran as ubas. Nun-amma us as nangatungatu ay fiawen nan munfianfiantay as nan umana. Kun pay narpas sa, enpaammana as nan chiyuycha mun-umauna. Angkiay ya nunfiaat henan achawwi ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kun pay inumchan nan timpon chi munpurasan, infiaorna nan fiabfiaaruna as nan chiyuycha nun-uumauna ta uyna araun nan kudwan nan amona ay ubas ay naapet as nan umana. ");
INSERT INTO ebk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngem lenabkis ya senaplesaplet nan chiyuycha nun-uumauna hiya, ya enpafiangadcha hiya ay maid in-inchatcha. ");
INSERT INTO ebk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kun pay enommat sa, infiaorna us nan usa. Ngem linungakancha, ya penabpafiainancha hiya. ");
INSERT INTO ebk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Infiaorna nan tukún, ngem penatuycha hiya. Wachacha us chi naesokat ay infiaorna. Ngem penak-orcha nan tapen nan nauycha infiaorna, ya penatuycha nan tapina. ");
INSERT INTO ebk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kun pay hiyachi, nan nayagyag at nan us-usa ay laylaychuna ay anak ay laraki. As nan anongosna, infiaorna hiya kan chicha, tay kanana as numnumna un, ‘Siguradu ay mafiainchantu as nan mismu ay anakku.’ ");
INSERT INTO ebk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ngem kenalen nan chiyuycha nun-uumauna as nan tunggal usa un, ‘Nauy nan mangetawid as nan uma ay uumaun takú. Akayu! Patayun takú hiya ta kuwaun takú nan tawidna.’ ");
INSERT INTO ebk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","As nan hiyachi, lenabkischa hiya. Penatuycha, ya ichus-orcha as nan fiakun sakop nan uma ay natatanman as ubas.” ");
INSERT INTO ebk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Senarudsud Jesus, “Ngachanantu nan atun nan nunkuwa as nan uma ay natatanman as ubas? Omalintu hiya ay mangpatuy as nan chiyuycha nun-uumauna. Angkiay ichatna as nan tukún nan umana ay natatanman as ubas. ");
INSERT INTO ebk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ay chaanyu finasfiasa nan nauy naisurat as nan Kalen Apo Dios? Kanana un: ‘Nan chiyuy fiatu ay enachen nan chiyuycha muntuptuping at hiya nan nunfialin as kaamuchan ay maipugnad. ");
INSERT INTO ebk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hiyana nan enat nan Apo, ya anuy paat nakaskaschaaw sa as nan mangiila takú.’” ");
INSERT INTO ebk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","As nan hiyachi, penachas nan anap-apon nan chiyuycha Judio ay mangepatiliw kan Jesus, tay naawatancha ay nan maepadpachongan ay infiakian Jesus at maepangkep kan chicha. Ngem inmugyatcha as nan ongoongor ay tataku, isunga tenaynancha hiya. ");
INSERT INTO ebk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kun pay narpas chi, infiaorcha kan Jesus nan tapen nan chiyuycha Fariseo ya nan tapen nan chiyuycha pasorot Ari Herodes ay uy manikap kan hiya babaen as nan sarudsudcha ta wachay mangicharumancha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Enmalicha kan Jesus, ya kanancha, “Misturu, ammumi ay tit-iwa nan am-in ay kanam. Mapapchong nan atum as nan am-in ay tataku, tay achim ifilang nan kasasaadcha, ngem isurom nan tit-iwa ay laychun Apo Dios ay atun nan tataku. Ifiakiam pay ngarud kan chakami nan songfiatmu's na: Ay eparufus nan Lintig takú ay munfiayad kami as fiaror kan Emperador ad Roma winnu achi?” ");
INSERT INTO ebk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngem aammon Jesus ay pakamankamancha, ya kanana kan chicha, “Adchi t'uyak chischistingun? Ud-a, umiyali kayu as usa ay silsilyu ta ilaok.” ");
INSERT INTO ebk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kuncha pay inyali kan hiya, senarudsudna kan chicha, “Ngachana nan nakin lupa ya nakin ngachan as na?” “Hi Emperador,” ensongfiatcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kenalen Jesus kan chicha, “Mu hiyasa ngarud, ichatyu kan Emperador nan kuk-uwan Emperador, ya ichatyu us kan Apo Dios nan kuk-uwan Apo Dios.” As nan nangaliyana's chi, naschaaw nan chiyuycha naifiaor kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wachacha nan Saduceo ay enmali kan Jesus. Chicha nan bunggoy chi Judio ay mangali un achi mataku nan natuy manipud as nan utúy. Senarudsudcha kan hiya, ");
INSERT INTO ebk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Misturu, nauy met nan insurat Moises para kan chitaku ay kanana un, ‘Mu wachay hen-asawa ay maid anakcha ya matuy nan laraki, masapor ay asawaun nan sunúd nan laraki nan naellakas ta mu wachay anakcha at maifilangtu nan onga as potot nan chiyuy natuy ay sunúdna.’ ");
INSERT INTO ebk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wachacha kanu nan pitu ay hen-anag-i ay lanaraki. Enmasawa nan panguru, at natuy ay maid enpototna. ");
INSERT INTO ebk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Enasawan nan utub nan chiyuy naellakas, at natuy us ay maid enpototna. Assid-i us challu as nan maekatlu ");
INSERT INTO ebk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","inkiana as nan maekapitu. Natuycha am-in ay maid enpototcha. Kuncha pay natuy am-in, natuy us nan fiafiai. ");
INSERT INTO ebk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","As nan urkiw ay matakuwan manipud as nan utúy, ngachana ngay nan nakin asawa as nan chiyuy fiafiai, tay enasawan met nan pitu hiya?” ");
INSERT INTO ebk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tinumfor hi Jesus kan chicha, “Kenomsaw kayu tit-iwa! Achiyu maawatan nan maepangkep as nan Kalen Apo Dios, ya achiyu us maawatan nan pannakafialina. ");
INSERT INTO ebk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tay as nan matakuwan nan nunkatuy manipud as nan utúy at maid mun-eennasawa, ngem kuncha at am-in maepachong as nan angheles ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mu maepangkep as nan matakuwan nan nunkatuy manipud as nan utúy, ay chaanyu finasfiasa nan enpaisurat Apo Dios kan Moises maepangkep as nan cha munkiarkiarud ay kaiw? Hiyachi nan naisuratan nan kenalen Apo Dios un, ‘Ha-un nan Dios Abraham, nan Dios Isaac ya nan Dios Jacob.’ ");
INSERT INTO ebk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nan laychuna ay kanan at hiya nan Dios nan natataku, fiakun nan nunkatuy. Nunsidlay kenomsawanyu!” ");
INSERT INTO ebk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chinngor nan usa as nan mun-isursuru as Lintig nan sososek cha Jesus ya nan chiyuycha Saduceo. Ammuna ay ustu nan ensongfiat Jesus kan chicha, isunga senarudsudna kan hiya, “Apo, ngachana man nan kaamuchan ay filin?” ");
INSERT INTO ebk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tinumfor hi Jesus, “Nan kaamuchan ay filin Apo Dios at hiyana: ‘Chungrunyu, chakayu ay kianak Israel! Us-usa nan Apo takú ay hi Apo Dios. Maid tukún. ");
INSERT INTO ebk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Masapor laylaychum nan Apo ay Diosmu as nan am-in ay pusom, as nan am-in ay lenawam, as nan am-in ay numnummu ya as nan am-in ay fikasmu.’ ");
INSERT INTO ebk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nan maekadwa ay kaamuchan at hiyana: ‘Masapor laylaychum nan pachongmu ay taku ay kaman as nan atum ay manglaylayad as achormu.’Maid kasin tukún as am-amud ay filin mu nan nauycha.” ");
INSERT INTO ebk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Angkiay ya kenalen nan mun-isursuru as Lintig, “Ustu, Misturu. Tit-iwa nan kenalem ay us-usa nan Apo Dios. Maid tukún mu achi hiya yangkiay. ");
INSERT INTO ebk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tit-iwa met ay masapor laychun nan taku hi Apo Dios as nan am-in ay pusuna, as nan am-in ay numnumna ya as nan am-in ay fikasna. Masapor laylaychuna us nan pachongna ay taku kaman as nan atuna ay manglaylayad as nan achorna. Tit-iwa ay am-amud chaná as atun mu nan mangichatchatonan as animar ya tapina ay chaton kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","As nan nanngoran Jesus ay nainsilifian nan songfiat nan mun-isursuru as Lintig, kenalina kan hiya, “Kiayudka maetapi henan muntorayan Apo Dios.” Kun pay narpas na, maid poros makaiturud ay nunsarsarudsud kasin kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kun pay cha mun-isuru hi Jesus aschi's Templo, senarudsudna, “Adchi pay ngarud t'uy kanan nan chiyuycha mun-isursuru as Lintig un hi Cristo at kianak David? ");
INSERT INTO ebk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hiyana nan enpaifiaag nan Espiritu Santo kan David mismu un, ‘Kenalen nan Apo as nan ok Apo un, “Tomokorka as apét kannawanku inkiana amisok nan chiyuycha kafusormu.” ’ ");
INSERT INTO ebk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Mu hiyasa ngarud ay ‘Apo’ nan pangaw-awag David ay mismu kan Cristo, anuyna ngay atun ay hi Cristo at kianak David?” Ongor chi lagsak nan ongoongor ay tataku ay nanngor as nan kenalina. ");
INSERT INTO ebk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","As nan cha mun-isuruwan Jesus, kenalina, “Il-ilaunyu nan chiyuycha mun-isursuru as Lintig ay manglaylayad ay munliklikud ay nakafiachu as somakiayad ta mafigfigcha, ya manglaylayad ay marisrispitu as nan chiyuycha mun-el-elakwan. ");
INSERT INTO ebk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Laylaychuncha nan chiyuycha kaammayan ay tokoran as nan chiyuycha senagoga ya nan tokoran nan chiyuycha mafigfigfig as tomoktokorancha as nan uycha makifiastaan. ");
INSERT INTO ebk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Isikapancha ay mangkuwa as nan ab-afong nan eellakas. Angkiay paanchuanchuwuncha nan kararagcha ta ilaun nan tataku ay ammaycha. Naliglikiattu nan chusacha!” ");
INSERT INTO ebk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","As nan nangatokoran Jesus ay nanasakiang as nan mangit-ittuwan as siping aschi's Templo, inilana nan tataku ay cha mangipuuy as sipingcha. Inmipuuy nan ongor ay nunkafiaknang as chamuna ay siping. ");
INSERT INTO ebk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Angkiay enmali nan usa ay pugli ay ellakas ay nangipuuy as kun chuwa ay pesos. ");
INSERT INTO ebk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Enayakian Jesus nan disipulusna, at kenalina kan chicha, “Ifiakiak kan chakayu nan tit-iwa. Hi tona ay pugli ay ellakas nan nangittu as kachamunaan kan chicha am-in. ");
INSERT INTO ebk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tay nan nunkafiaknang at kuncha yangkiay inchat nan subra as nan kenafiaknangcha. Ngem hi tona ay ellakas uray pugli at inittuna challu nan am-in ay wacha kan hiya ay kurpuwan chi pagfiyagna.” ");
INSERT INTO ebk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kun pay cha pumitiw hi Jesus as nan Templo, kenalen nan usa ay disipuluna kan hiya, “Misturu, ilaum kay! Anad-acha-an as solet nan chiyuycha fiatu ay enosarcha, ya anuy paat anam-ammay nan chiyuycha nakiaub as fiatu as nan kawad-an nan Templo!” ");
INSERT INTO ebk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“O!” ensongfiat Jesus kan hiya. “Iilaum nan nauycha anad-acha ay nakiaub. Maidtu mayagyag as uray usa ay fiatu as nan naesasad-ana, tay kuncha am-in maikur-ub.” ");
INSERT INTO ebk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","As nan nangatokoran Jesus henan chuntug ay Olivo ay chuchumangun nan Templo, enmali cha Pedro, Santiago, Juan ya hi Andres kan hiya ay chidchicha yangkiay. ");
INSERT INTO ebk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Senarudsudcha, “Ifiakiam pay kan chakami mu kaatnantu nan ommatan chatona, ya ngachanantu nan sinyar ay mangematonan as nan ommatan chatona am-in?” ");
INSERT INTO ebk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kenalen Jesus kan chicha, “Il-ilaunyu ta maid mangar-allilaw kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ongortu nan tataku ay omali ay mangosar as nan ngachanku ay mangarkali un, ‘Ha-un hi Cristo!’ ya ongortu nan allilawuncha ay tataku. ");
INSERT INTO ebk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","As nan manngoranyu as kanikong chi kukufiat ya chamag maepangkep as kufiat henan achawwi ay luglukiar, achi kayu machanakian. Masapor challu ommat chaná, ngem fiakun pay hiyasa nan munpatingkiaan nan lufong. ");
INSERT INTO ebk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Munkikinnufiattu nan chiyuycha nasyon, ya kaman us nan chiyuycha muntorayan. Wachachantuy kichu henan tukutukún ay lukiar. Wachachantu us chi fitel. Ngem chatona nan laplapon chi likiat ay kaman as nan munpasikaran chi omanak. ");
INSERT INTO ebk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Il-ilaunyu, tay wachachantu nan mangicharum kan chakayu as nan chiyuycha lupon. Masaplesaplet kayuntu as nan chiyuycha senagogacha. Tomakchug kayuntu as nan sangwanan nan gogobernador ya ar-ari kiapú kan ha-un. Hiyasa nan chansayu ay mangepaneknektu kan chicha as nan maepangkep as nan Ammay ay Chamag. ");
INSERT INTO ebk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nan Ammay ay Chamag at masapor maekasaba on-ona henan am-in ay nasyon sakbay munpatingkia nan lufong. ");
INSERT INTO ebk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kun chakayu pay tiliwun ya icharum, achi kayu machanakian mu ngachanantu nan kananyu, ngem ifiakiayu mu ngachana nan maepakaammu kan chakayu as nan hana ay uras. Tay fiakun chakayu nan munkali, ngem kun at nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“As nan hiyasa ay timpu, wacha nan mangepapatuytu as mismu ay sunúdna ay laraki. Assesantu us nan atun nan ama as nan pototna. Nan an-ak us at kontraunchantu nan chanakchakorcha ya epapatuycha chicha. ");
INSERT INTO ebk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Inglun chakayuntu as nan am-in ay tataku kiapú as pammatiyu kan ha-un. Ngem nan taku ay mangan-anos ay omafurot kan ha-un inkiana as nan anongos at maesarakantu.” ");
INSERT INTO ebk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Inturuy Jesus, “Ilaunyuntu nan ‘Kauugyat ay Chumachael’ ay tenmatakchug as nan achina kalibfengan ay tomakchukian. (Nan mamasa as na at masapor maawatana nan laychun tona ay kanan.) As nan hiyachi, nan umiili ad Judea at masapor lomayawcha ay umuy henan chiyuycha chuntug. ");
INSERT INTO ebk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nan taku ay wacha as tabfongan nan afongna at achi masapor chumayyu ay sungkop ay mangara as kinakuna. ");
INSERT INTO ebk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nan senmepot at achi masapor somaor ay mangara as kakiayna. ");
INSERT INTO ebk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kasusug-angtu kayman nan chiyuycha masisikug ya nan cha munpasusu as nan hanacha ay urkiw! ");
INSERT INTO ebk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ekararagyu kan Apo Dios ta fiakun koma as nan chinamuy nan ommatana. ");
INSERT INTO ebk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tay as nan hanacha ay urkiw, omalintu nan nunsidla ay likiat ay maid maepachongana nunlapu as nan namayangan Apo Dios henan lufong inkiana ad wani, ya achintu kasin om-ommat. ");
INSERT INTO ebk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mu achi henkemachun Apo Dios nan chiyuycha urkiw ay munlikiatan, maidtu taku ay kutug ay matataku. Ngem kiapú as nan pinilina ay tatakuna, henkemachuna nan chiyuycha urkiw. ");
INSERT INTO ebk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“As nan hiyachi ay timpu, mu wachay mangarkali kan chakayu un, ‘Ilaunyu! Nauy nan Cristo!’ winnu ‘Ilaunyu! Chiyuy hiya!’ at achiyu ab-afurotun. ");
INSERT INTO ebk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tay munpailachantu nan chiyuycha achi tit-iwa ay Cristo ya achi tit-iwa ay pomapadtu. Omepappailachantu as ongor ay nakaskaschaaw ay sinyar ya milagro ta mu mafialin at allilawuncha nan tataku ay pinilen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ngem il-ilaunyu, tay infiafiakiak met at chaná am-in kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“As nan hanacha ay urkiw as nan karpasan nan timpon chi likiat, ngomongottu nan urkiw, ya achintu somorag nan furan. ");
INSERT INTO ebk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nan chiyuycha taraw at mag-aschantu ay murpu ad chaya, ya achintu manongnong chi aatun nan am-in ay wacha ad chaya. ");
INSERT INTO ebk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Angkiay ilaunchantu nan Naepadtu ay Anak chi Taku ay wachay ongor ay pannakafialina ya kaichayawana ay cha omali ay maetatapi as nan chiyuycha lifuu. ");
INSERT INTO ebk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Angkiay ya ifiaornantu nan anghelesay uy mangamong as nan tataku ay pinilen Apo Dios henan uray ay chaud ay lukiar ay kawad-ancha.” ");
INSERT INTO ebk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kenalen pay Jesus, “Suruwunyu koma nan maepadpachongan maepangkep as nan kaiw ay igos. As nan somalipingan nan kaiw ay igos ya maforongan, ammuyu at ay kiayud chakun. ");
INSERT INTO ebk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hiyasa us ay as nan mangil-anyu ay cha om-ommat chaná at ammuyuntu ay kiayud at nan omaliyana ay kaman wacha hiya as nan pantiw. ");
INSERT INTO ebk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ifiakiak kan chakayu nan tit-iwa. Wachacha pay nan tapen nan tataku ad wani ay timpu ay matataku pay as nan ommatantu chatona am-in ay infiakiak. ");
INSERT INTO ebk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mamaidtu nan chaya ya luta, ngem achintu poros mamaid nan kalek. ");
INSERT INTO ebk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Maid mangammu as nan urkiw winnu uras ay ommatantu chatona ay infiakiak. Uray nan angheles ad chaya winnu nan Anak Apo Dios at achicha ammu, ngem kun yangkiay nan Ama. ");
INSERT INTO ebk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Il-ilaunyu ya munsasakiana kayu, tay achiyu ammu nan timpu ay ommatana. ");
INSERT INTO ebk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Maepachong na as nan taku ay cha munsakiana ay munfiaat as nan achaachawwi. Sakbay mak-ak, ipiyarna nan afongna as nan chiyuycha fiabfiaaruna, ya ifiakiana nan chunuwun nan tunggal usa kan chicha. Ifilina us as nan munfianfiantay as nan sungkopan ay munfiantay hiya ay ustu. ");
INSERT INTO ebk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Isunga munsasakiana kayu, tay achiyu ammu nan omaliyan nan nun-afong. Achiyu ammu mu uy at as nan maschum, tongan chi lafi, makapis winnu mangaurkiw. ");
INSERT INTO ebk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Munsasakiana kayu, tay anaka ya loktat ay omali hiya, ya uchanana chakayu ay nanassuy. ");
INSERT INTO ebk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nan nauy ay infiakiak kan chakayu at hiya us nan ifiakiak as nan am-in ay tataku: Munsasakiana kayu!” ");
INSERT INTO ebk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chuwa pay ay urkiw at umchan nan Fiastan chi Munlausan ya Fiastan chi Tenapay ay Maid Lebadurana. Nan anap-apon chi papachi ya nan mun-isursuru as Lintig at chacha an-anapun nan atuncha ay mangtiliw ya mangepapatuy kan Jesus ay achi maam-ammuwan nan tataku. ");
INSERT INTO ebk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kenalicha, “Aw, achi takú iyaspor as nan fiasta, tay anaka ya munkukuru nan ongoongor ay tataku.” ");
INSERT INTO ebk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","As nan kawad-an cha Jesus ad Betania, uycha nakekan as afong Simon ay nakonet ay enpaammay Jesus. As nan chacha manganan, naesnop nan usa ay fiafiai. Entatakina nan mangit-ittuwan ay naamma as fiatu ay nan ngachana at alabastro ay nanapnu as munfiangu ay nanginngina-an ay makali un nardu. Pintuna nan fiakiang nan mangit-ittuwan, ya inkuyagna nan fiangfiangru as nan uron Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","As nan hiyachi, wachacha hid-i nan tapen nan tataku ay finmungat, ya chacha kanan ay matatakiatfor, “Ayyiwka sa paat! ");
INSERT INTO ebk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mu koma naelaku na ay fiangfiangru at nasorok as turon kiasot ay dinario nan fiarorna. Angkiay maichat nan lakuna as nan chiyuycha pugli.” Angkiay ya en-ensotcha as solet nan fiafiai. ");
INSERT INTO ebk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngem kenalen Jesus kan chicha, “Pay-anyu! Adchi t'uyyu lilifokun hiya? Ammay met nan enatna kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tay kanayon ay wachacha kan chakayu nan chiyuycha pugli, ya mu laychunyu, mafialinyu ay fiadngan chicha as nan kumpurmi ay uras. Ngem mu ha-un, achiyaktu kanayon ay wacha kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Enat nan fiafiai nan kafiaelana ay atun kan ha-un. Enon-onana ay nangefokfok as nan fiangfiangru as nan achorku ta esakianana nan pannakailufokku. ");
INSERT INTO ebk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ifiakiak kan chakayu nan tit-iwa. Uray ay chaud henan intiru ay luta nan maekasabaan nan Ammay ay Chamag at maifiabfiaagtu nan enatna as mangnumnumnuman kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Angkiay ya hi Judas Iscariote ay usa as nan hinpuru ya chuwa ay disipulus at inmuy as nan anap-apon chi papachi ta esepsepna hi Jesus kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Naragsakancha as nan nanngorancha as nan kenalina, ya enkaricha ay ichatcha nan siping kan hiya. Isunga nun-anap hi Judas as ustu ay chansa ay mangesepsepana kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","As nan omona ay urkiw ay Fiastan chi Tenapay ay Maid Lebadurana at hiyasa us nan urkiw ay mangichatonan nan chiyuycha Judio as nan chiyuycha urfun ay karnero para as nan Fiastan chi Munlausan. Senarudsud nan disipulus kan Jesus, “Ay chaud nan laychum ay mangesakianaanmi as nan manganan takú as nan Fiastan chi Munlausan?” ");
INSERT INTO ebk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Angkiay ya kenalen Jesus as nan chuwa ay disipulusna, “Uy kayu henan siyudad,at wachantu nan manib-at kan chakayu ay usa ay laraki ay manasakfiat as fusi ay natorwan as chanum. Unuchunyu hiya. ");
INSERT INTO ebk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Uray ngachana ay afong nan sungkopana, kananyu as nan nun-afong, ‘Infiakian nan Misturu un ay chaud nan kuwartu ay mangiyufonganantu as nan disipulusna as nan Fiastan chi Munlausan?’ ");
INSERT INTO ebk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Epailanantu kan chakayu nan nunngangatu ay kuwartu ay ad-acha ay kawad-an nan am-in ay kasaporan takú. Hid-i nan munsakianaanyu.” ");
INSERT INTO ebk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Inmuy nan chiyuycha chuwa ay disipulus henan siyudad, ya ininchanancha nan am-in ay kaman as nan infiakian Jesus kan chicha. As nan hiyachi, ensakianacha nan manganan as nan Fiastan chi Munlausan. ");
INSERT INTO ebk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kun pay naschum, inumchan hi Jesus ya nan hinpuru ya chuwa ay disipulus. ");
INSERT INTO ebk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","As nan chacha manganan, kenalina, “Ifiakiak kan chakayu nan tit-iwa ay wacha nan usa kan chakayu ay mangesepseptu kan ha-un ay hiya nan nakiuufong kan ha-un ad wani.” ");
INSERT INTO ebk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Enlapon nan disipulusna ay nginmuyus, ya nunsesennarunucha ay nunsarudsud kan Jesus, “Ay ha-un ta?” ");
INSERT INTO ebk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","“Usa kan chakayu ay hinpuru ya chuwa ay cha makisiwsiw kan ha-un as tenapay as nan mallokong,” ensongfiat Jesus kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Tay matuytu challu nan Naepadtu ay Anak chi Taku ay kaman as nan kanan nan naisurat as nan Kalen Apo Dios maepangkep kan hiya, ngem kasusug-ang kayman nan hana taku ay mangesepsep as nan Naepadtu ay Anak chi Taku! Un-unuyna at mu kun chaan naiyan-anak hiya!” ");
INSERT INTO ebk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","As nan chacha manganan, enaran Jesus nan tenapay, ya nunyaman kan Apo Dios. Pinutput-ingna, angkiay inchatna kan chicha, ya kanana, “Araunyu na. Hiyana nan achorku.” ");
INSERT INTO ebk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Angkiay ya enarana nan tasa ay natotorwan as maikop. Kun pay narpas ay nunyaman kan Apo Dios, inchatna kan chicha, at inmikopcha am-in. ");
INSERT INTO ebk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kenalina kan chicha, “Hiyana nan charak ay mangepasiguradu as nan fiarú ay nakiturakian Apo Dios as nan tataku. Omayastu as nan matuyak para as nan ongor ay tataku. ");
INSERT INTO ebk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ifiakiak kan chakayu nan kenatit-iwa. Achiyaktu umig-ikop as nan unus chi ubas inkiana umchan nan hana urkiw ay umikopak as nan fiarú ay unus chi ubas henan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","As nan narpasancha ay nunkanta as pangchaychayaw kan Apo Dios, pinmitiwcha ay inmuy henan chuntug ay Olivo. ");
INSERT INTO ebk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","As nan chacha umuyan, kenalen Jesus as nan disipulusna, “Lomayaw kayuntu am-in, tay wacha nan naisurat as nan Kalen Apo Dios ay kanana, ‘Patayoktu nan mangay-aywan as nan karnero, at masisiyanchantu nan chiyuycha karnero.’ ");
INSERT INTO ebk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngem as nan matakuwak kasin manipud as nan utúy, omon-onaaktu ay umuy ad Galilea mu chakayu.” ");
INSERT INTO ebk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Infiakian Pedro kan Jesus, “Uray mu lomayaw nan am-in ay kakadwak, achiyak challu lomaylayaw.” ");
INSERT INTO ebk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kenalen Jesus kan hiya, “Ifiakiak kan he-a nan tit-iwa. Ad wani ay lafi, sakbay munkokakok nan ka-or as nan kapidwa at mamitluwaktu esaot kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ngem enpapelet Pedro, “Aw! Uray mu maetapiyak kan he-a ay matuy, achek challu poros esassaot he-a!” Assesa us nan kenalen nan am-in ay kakadwana ay disipulus. ");
INSERT INTO ebk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Inmuy cha Jesus henan lukiar ay makali un Getsemani, ya kanan Jesus as nan disipulusna, “Etokoryu hena ta uyak munkararag.” ");
INSERT INTO ebk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Entakina hi Pedro, hi Santiago ya hi Juan. As nan hiyachi, enlapuna ay nginmuyus ya nalilifok. ");
INSERT INTO ebk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kenalina kan chicha, “Kamanku ekatuy nan nunsidla ay ngunguyusku. Mayasna kayu ya munpuyat kayu.” ");
INSERT INTO ebk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Angkiay ya inmuy as nan ad-achawwi as akét. Nunlukfub ya enkararagna ay mu mafialin koma at achi maturuy nan ommat kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Enkararagna, “Ama, nan am-in at kafiaelam. Kaanum koma kan ha-un nan nauy omali ay likiatku. Uray mu assena, fiakun challu nan laychok nan maekaman, ngem nan laychum.” ");
INSERT INTO ebk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","As nan nunfiangchana as nan kawad-an nan disipulusna, ininchanana chicha ay nanassuy. Kenalina kan Pedro, “Simon, ay nanassuyka at? Ay kunmu achi kafiaelan ay munpuyat as uray us-usa ay uras? ");
INSERT INTO ebk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Munpuyat ya munkararag kayu ta achi kayu maamis as nan sulisug. Nakasakiana kayman nan numnumyu, ngem nakapuy nan achoryu.” ");
INSERT INTO ebk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kasin tenmaak hi Jesus, ya enkararagna nan pachong nan kenarkalina. ");
INSERT INTO ebk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kun pay nunfiangad as nan maekapidwa as nan kawad-an nan disipulusna, ininchanana chicha ay nanassuy kasin, tay makaskassuycha as solet. Achicha ammu nan esongfiatcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Inmuy kasin ay nunkararag. Kun pay nunfiangad as nan maekapitlu, kenalina kan chicha, “Ay kukutug kayu ay cha mammamassuy ya cha mun-ib-iblay? Ustu sa! Inumchan at nan uras ay maesepsepan nan Naepadtu ay Anak chi Taku as nan fumafiasor. ");
INSERT INTO ebk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ayu, fumangun kayu ta uy takú maisib-at. Ilaunyu, nauy at nan mangesepsep kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kun pay kukutug ay cha munkarkali hi Jesus, enmali hi Judas ay usa as nan hinpuru ya chuwa ay disipulus. Intutun-udna nan ongor ay tataku ay kachorchorosan ya kapakpak-oran. Chicha nan infiaor nan anap-apon chi papachi, mun-isursuru as Lintig ya nan anam-amá. ");
INSERT INTO ebk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nan sinyar ay inturag Judas as nan intutun-udna at assena: “Nan taku ay fisituwok at hiya nan chayu an-anapun. Tiliwunyu hiya, ya etaakyu ay mangukuwarcha ay ustu.” ");
INSERT INTO ebk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","As nan inumchanan Judas, nunchakpos hiya kan Jesus, ya kanana, “Misturu!” ya finisituna hiya. ");
INSERT INTO ebk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Angkiay ya tiniliwcha hi Jesus, ya enpapakudcha ay ustu. ");
INSERT INTO ebk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngem as nan nangil-an nan usa ay disipulu ay nangatakchug hid-i, enoknosna nan chorosna. Finakagna nan fiabfiaarun nan kangatuwan ay pachi, at nakingasan nan ingana. ");
INSERT INTO ebk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Angkiay ya kenalen Jesus kan chicha, “Ay kunak kumukuru? Adchi t'uy kayu enmali ay nangachoros ya nangapak-or ay mangtiliw kan ha-un? ");
INSERT INTO ebk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Inurkiw met ay wachaak kan chakayu aschi's Templo ay cha mun-is-isuru, ya chaanak met tiniltiliw kan chakayu. Ngem masapor atunyu na ta matongpar nan naisurat as nan Kalen Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Angkiay ya lenmayawcha am-in, ya tenaynancha hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wacha nan usa ay fumarfiaru ay nangepopotepot yangkiay as urus as achorna ay cha umun-unud kan Jesus. Penachas nan tataku ay mangtiliw kan hiya, ");
INSERT INTO ebk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ngem lenmayaw ay lablabfusan ay nanaynan as nan urusna. ");
INSERT INTO ebk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Angkiay ya inyuycha hi Jesus as nan afong nan kangatuwan ay pachi. Hid-i nan naaamongan nan am-in ay anap-apon chi papachi, anam-amá ya nan mun-isursuru as Lintig. ");
INSERT INTO ebk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Inmun-unud hi Pedro ay tenmataak inkiana as nan fiattaw nan afong nan kangatuwan ay pachi. Angkiay ya naketokor hid-i as nan chiyuycha kuwarcha ay makeanichu. ");
INSERT INTO ebk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nan anap-apon chi papachi ya nan am-in ay membron nan Sanhedrin at nun-anaanapcha as pammaneknek as mangepafiasorancha kan Jesus ta wachay kiapúna as mangepapatuyancha kan hiya, ngem maid naanapancha. ");
INSERT INTO ebk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nan ongor at nuntistigucha as achi tit-iwa ay maekontra kan Jesus, ngem achi mapapchong nan pammaneknekcha. ");
INSERT INTO ebk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wachacha us nan tapen nan tataku ay tenmakchug ay nuntistigu as achi tit-iwa. Kenalicha, ");
INSERT INTO ebk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Chinngormi hiya ay kenalina, ‘Chachaeloktu nan nauy Templo ay enammaan chi tataku, ya as nan unig chi turu ay urkiw kumaufiaktu as tukún ay fiakun taku nan mangamma.’ ” ");
INSERT INTO ebk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Uray challu chatona at chaan napapchong nan intistigucha. ");
INSERT INTO ebk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Angkiay ya tenmakchug nan kangatuwan ay pachi as nan sangwanan nan am-in, ya senarudsudna kan Jesus, “Ay maid esongfiatmu as nan cha epabpafiasor chatona ay tataku kan he-a?” ");
INSERT INTO ebk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngem kun kinkinak hiya ya chaan tinumtumfor. Senarudsud kasin nan kangatuwan ay pachi kan hiya, “Ay he-a nan Cristo ay Anak nan Machaychayaw ay Dios?” ");
INSERT INTO ebk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“O ha-un,” ensongfiat Jesus. “Ilaunyuntu nan Naepadtu ay Anak chi Taku ay tomokor as apét kannawan Apo Dios ay Mannakafialin as nan am-in. Ilaunyuntu us ay omali hiya ay murpu ad chaya ay maetatapi as nan lifuu,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kun pay chinngor nan kangatuwan ay pachi chi, lenaksetna nan fiachuna kiapú as fungatna, ya kanana, “Ay masapor takú pay chi muntistigu? ");
INSERT INTO ebk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chinngoryu at met ay enpachongna nan achorna kan Apo Dios. Ngachana nan munnunumnumyu?” Am-incha at enkeddengcha ay libfengna ay mapatuy. ");
INSERT INTO ebk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Angkiay ya enlapon nan tapen nan tataku ay manubtubfia kan hiya. Enokopancha nan matana, ya sinudpasudpakcha hiya, at kenalicha kan hiya, “Ud-a pay! Pugtuwam mu ngachana nan nanudpak kan he-a.” Haat araun nan chiyuycha kuwarcha hiya ya tenamtampakcha. ");
INSERT INTO ebk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kun pay hi Pedro, kukutug as nan fiattaw. Nar-os nan usa as nan chiyuycha fiabfiafiai ay fiabfiaarun nan kangatuwan ay pachi as nan kawad-ana. ");
INSERT INTO ebk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kuna pay inila hi Pedro ay cha makean-anichu, entoongana hiya, at kenalina, “He-a us at nakekadkadwaka met kan Jesus ay i-Nazaret.” ");
INSERT INTO ebk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngem ensaot Pedro, “Achek poros ammu nan cham kankanan, ya achek us maawatan!” Inmuy hiya as nan sugpan nan fiattaw. Hiya at chi ya nunkokakok nan ka-or. ");
INSERT INTO ebk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nan tukún ay mafiabfiaor ay fiafiai at enmatonana hi Pedro, at kenalina as nan chiyuycha nangatakchug, “Hi tona met ay laraki at usa us kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngem kasina ensaot. Kun pay naaw-awni as akét, nan chiyuycha nangatakchug hid-i at kenalicha kan Pedro, “O kayong, usaka kan chicha, tay i-Galileaka met.” ");
INSERT INTO ebk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ngem ensapatan Pedro as nan achorna, “Chusaunak ud-ay kan Apo Dios mu achi tit-iwa nan chak ifiagfiakia! Achek poros ammu nan taku ay chayu kankanan!” ");
INSERT INTO ebk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hiya at chi ya nunkokakok nan ka-or as nan maekapidwa, ya nanumnum Pedro nan infiakian Jesus kan hiya, “Sakbay ay munkokakok nan ka-or as nan maekapidwa at mamitluwaktu esaot kan he-a.” Kun pay nanumnum Pedro, chaana naetporan chi saket chi numnumna, ya nunsidlay akorna. ");
INSERT INTO ebk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","As nan wi-ewi-et, nuntuturagcha nan anap-apon chi papachi, anam-amá, mun-isursuru as Lintig ya am-in ay membron nan Sanhedrin mu anan atuncha kan Jesus. Kun pay narpas chi, finarudcha hiya, ya enek-akcha ay nangipurang kan Gobernador Pilato. ");
INSERT INTO ebk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Senarudsud Pilato kan hiya, “Ay he-a nan aren chi Judio?” “He-a nan nangali ay ha-un,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ongor chi enpafiasor nan anap-apon chi papachi kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Angkiay kasin senarudsud Pilato kan hiya, “Chungrum at ongor chi chacha epabpafiasor kan he-a. Ay kun maid esongfiatmu?” ");
INSERT INTO ebk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngem chaan challu tinumtumfor hi Jesus, isunga naschaaw hi Pilato. ");
INSERT INTO ebk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kun kay Fiastan chi Munlausan at ukialen Pilato ay umilufus as usa ay fiarud ay chawatun nan tataku. ");
INSERT INTO ebk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","As nan hana ay timpu, wacha nan usa as nan chiyuycha fiarud ay nan ngachana at Barrabas. Hiya ya nan chiyuycha kakadwana at penmatuycha as nan nangkukuruwancha as nan goberno. ");
INSERT INTO ebk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kun pay naamong nan tataku as nan sangwanan Pilato, chinawatcha kan hiya ay atuna koma nan ukialina kun kay fiasta. ");
INSERT INTO ebk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Senarudsud Pilato kan chicha, “Ay laychunyu ay ilufusku nan aren chi Judio?” ");
INSERT INTO ebk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Infiakiana chi, tay naammuwana ay inpurang nan anap-apon chi papachi hi Jesus kan hiya kiapú as aposcha. ");
INSERT INTO ebk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ngem nan anap-apon chi papachi at chinorchorcha nan tataku ay munkuru ta nan chawatuncha ay ilufusna para kan chicha at hi Barrabas fiakun hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kenalen kasin Pilato as nan tataku, “Mu hiyasa, anan atok ngay ngarud as nan laraki ay kananyu un aren chi Judio?” ");
INSERT INTO ebk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Infukiawcha, “Epaelansam as nan koros!” ");
INSERT INTO ebk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Adchi ngay? Ngachana man nan fiasorna?” senarudsud Pilato kan chicha. Ngem kenaskasincha infukiaw, “Epaelansam as nan koros!” ");
INSERT INTO ebk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kiapú ta laychun Pilato ay paragsakuna nan tataku, inlufusna hi Barrabas para kan chicha. Angkiay enpasaplesapletna hi Jesus as nan sosorchachu, ya inpurangna hiya ta maelansa as nan koros. ");
INSERT INTO ebk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Iniskop nan sosorchachu hi Jesus as nan fiattaw nan palasyon nan gobernador, ya enamongcha nan am-in ay kakadwacha. ");
INSERT INTO ebk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Finachuwancha hi Jesus as kakiay ay munchachara ay maepachong as nan fiachon chi ari. Penolekawcha nan komawet ay sufet ya insukrubcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Angkiay ya enlapucha ay aginpapakomosta kan hiya, “Matakutakuka ay Aren chi Judio!” ");
INSERT INTO ebk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Enpak-opak-orcha nan nunu as nan uruna, ya tinubfiatubfiaancha hiya. Nunpalpalintumangcha ay aginchachayaw kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kuncha pay lenpas ay nangotyootyok kan hiya, kenaancha nan munchachara ay kakiay, ya enpafiachucha kasin nan sikud ay infiafiachuna. Hacha at ek-ak ay uy mangelansa kan hiya as nan koros. ");
INSERT INTO ebk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","As nan chacha manad-aranan, wacha nan nurpu henan sikib ay cha omali henan siyudad ay nan ngachana at Simon ay i-Cirene ay aman cha Alejandro kan Rufo. Kuncha pay sinib-at hiya, penelet nan sosorchachu hiya ay manakfiat as nan koros Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Angkiay ya inyuycha hi Jesus henan lukiar ay makali un Golgota ay nan laychuna ay kanan at “Lukiar nan Tong-or chi Uru”. ");
INSERT INTO ebk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hid-i, penachascha ay paikopun hi Jesus as fiayas ay nakaslangan as akias ay makali un mirra ay mangepakyat kanu as putug, ngem enachina. ");
INSERT INTO ebk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Enlansan nan sosorchachu hiya as nan koros. Angkiay finingfingaycha nan chiyuycha fiachuna babaen as nan nunfifinnonotancha ta ilauncha mu ngachana nan araun nan tunggal usa kan chicha. ");
INSERT INTO ebk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nuebe as nan wiet nan nangelansaancha kan Jesus as nan koros. ");
INSERT INTO ebk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nan tabra ay naisusuratan nan naepafiasor kan hiya at assena nan kafiasaana: “Nan Aren chi Judio.” ");
INSERT INTO ebk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Enlansacha us nan chuwa ay homohold-ap, usa as apét kannawan Jesus, ya nan usa at as apét kannikidna. ");
INSERT INTO ebk_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hiyana nan natongparan nan naisurat as nan Kalen Apo Dios ay kanana, “Naetapi hiya as nan chiyuycha lomalabsing as lintig.” ");
INSERT INTO ebk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nan chiyuycha cha marmar-os at en-ensotcha hiya ya nunwugwugwugcha, ya chacha kankanan, “Kakun ayu ad wani! He-a ay nangali un kafiaelam ay manachael as nan Templo ya kiaufum as nan unig chi turu ay urkiw ");
INSERT INTO ebk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","at ud-a, esarakam nan achormu, ya komsopka as nan koros!” ");
INSERT INTO ebk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Uray nan anap-apon chi papachi ya nan mun-isursuru as Lintig at enot-otyokcha hi Jesus as nan chacha mangarkaliyan as nan tunggal usa, “Ensarakana nan tapina ay tataku, ngem achina met poros maesarakan nan achorna. ");
INSERT INTO ebk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kakun ud-a komsop ad wani nan nauy Cristo ay aren nan chiyuycha kianak Israel as nan korosna ta ilaun takú, at afurotun takú hiya.” Nan chiyuycha naetapi kan Jesus ay naelansa as nan koroscha at ininsurtucha us hiya. ");
INSERT INTO ebk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","As nan nunkiawa, ngenmongot nan intiru ay luta inkiana alas tres as nan makiayud. ");
INSERT INTO ebk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","As nan alas tres, inpigsan Jesus ay nangifukiaw, “Eli, Eli, lama sabaktani?” Nan laychuna ay kanan at “Diosku, Diosku, adchi t'uyak ennganuy?” ");
INSERT INTO ebk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","As nan nanngoran nan tapen nan tataku ay nangatakchug hid-i, kenalicha, “Chungrunyu sa! Chana ayakian hi Elias.” ");
INSERT INTO ebk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tenmagtag nan usa ay nangepasosop as nan espongha as nan senmoka ay fiayas. Kun pay narpas, enpakatna as nan nunu, ya inchawchawna kan Jesus ta sosopuna, ya kanana, “Awni pay ud-a ta ilaun takú mu omali hi Elias ay uy mangeksop kan hiya as nan koros.” ");
INSERT INTO ebk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nunfukiaw hi Jesus as napigsa ya natuy. ");
INSERT INTO ebk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","As nan hiyachi, narakset ay nunkudwa nan kurtinan nan Templo nunlapu as lamagna inkiana as kuwabna. ");
INSERT INTO ebk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kun pay inilan nan kapetan chi sosorchachu ay nangatakchug hid-i ay nanasakiang kan Jesus nan enatna ay natuy, kenalina, “Tit-iwa payat ay hi tona ay taku at Anak Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","As nan ad-achawwi as akét, wachacha nan fianafiai ay nangiila as nan cha om-ommat. Nan tapina kan chicha at cha Maria Magdalena, hi Maria ay enan cha Jose kan Santiago ay makali un ong-onga, ya hi Salome. ");
INSERT INTO ebk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chatona nan nakikkiuy ya namadfiachang kan Jesus as nan kawad-ana pay laing ad Galilea. Ongor us nan tapina ay fianafiai ay inmunud kan Jesus as nan enmaliyana ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kun pay cha maschum, chacha munsakiana nan Judio para as nan kafikiatana ay Urkiw ay Mun-iblayan. ");
INSERT INTO ebk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Hi Jose ay i-Arimatea at naturud ay inmuy kan Pilato, at chinmawat as pammarufus ay arauna nan achor Jesus. Hi Jose ay anna at usa ay machayaw ay ap-apon chi Judio ay manman-ud as nan omaliyan nan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Naschaaw hi Pilato as nan nanngorana ay natuy at hi Jesus. Isunga enayakiana nan kapetan nan sosorchachu ya senarudsudna mu tit-iwa ay natuy hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kuna pay naammuwan as nan kapetan ay natuy tit-iwa hi Jesus, enparufusna ay araun Jose nan achor Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Lenmaku hi Jose as am-ammay ay lopot. Enpaksopna nan achor Jesus, at penotepotana as nan hana ay lopot. Angkiay ya enpaipuuyna as nan lufok ay natuktukan ay chupras. Kun pay narpas, enpaulina nan ad-acha ay fiatu ay nanangubna as nan lufok. ");
INSERT INTO ebk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Hi Maria Magdalena ya hi Maria ay enan Jose at inilacha nan nailubkan Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kun pay inmuy nan Urkiw ay Mun-iblayan, lenmaku cha Maria Magdalena, Maria ay enan Santiago, ya hi Salome as fiangfiangru ta uycha ekapu as nan achor Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","As nan wi-ewi-et nan Chumingku as nan cha fomoknakian nan urkiw, inmuy nan chiyuycha fianafiai as nan lufok Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","As nan chacha ay-ayan, chacha kanan ay matatakiatfor, “Ngachana ngay nan mangulin as nan tangub nan lufok?” ");
INSERT INTO ebk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","As nan inumchanancha as nan lufok, inilacha ay nakakaan nan ad-acha ay tangub nan lufok. ");
INSERT INTO ebk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kuncha pay sinungkop ya inilacha nan fumarfiaru ay nangatokor as apét kannawan ay nangakakiay as munpupukaw, inmugyatcha. ");
INSERT INTO ebk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kenalina kan chicha, “Achi kayu umugyat. Ammok challu ay chayu anapun hi Jesus ay i-Nazaret ay naelansa as nan koros. Maid hiya hena. Nataku hiya manipud as nan utúy! Ilaunyu nan nangesad-ancha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Uyyu pay ifiakia as nan disipulusna ya kan Pedro ay omon-ona ay umuy hi Jesus mu chakayu ad Galilea. Ilaunyuntu hiya hid-i ay kaman as nan kenakalina kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","As nan hiyachi, pinmitiwcha as nan lufok ya lenmayawcha, tay nakudnorcha ya penmayagpagcha. Maid nangifiagfiag-ancha as uray usa kiapú as nan nunsidla ay ugyatcha. ");
INSERT INTO ebk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kun pay nataku manipud as nan utúy hi Jesus as nan wi-ewi-et nan Chumingku, nunpaila hiya omona kan Maria Magdalena ay nangepafoknakiana as pitu ay anennet. ");
INSERT INTO ebk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Inmuy hi Maria Magdalena as nan kawad-an nan disipulus Jesus ay cha munnunnunungu ya cha mun-ag-akor, ya infiakiana kan chicha ay inilana hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngem as nan nanngorancha as nan infiakiana ay nataku hi Jesus manipud as nan utúy ya inilana hiya, chaancha enafurot. ");
INSERT INTO ebk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","As nan narpasan tona, nunpaila hi Jesus as nan chuwa ay disipulusna as nan chacha manarcharanan ay umuy henan sikib, ngem tinmukun chi kail-ana. ");
INSERT INTO ebk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nunfiangad nan chiyuycha chuwa, ya enpachamagcha as nan chiyuycha kakadwacha ay nunpaila hi Jesus kan chicha, ngem chaancha us enafurot chicha. ");
INSERT INTO ebk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Angkiay ya, nunpaila hi Jesus as nan hinpuru ya usa ay disipulus as nan chacha manganan. Senengarana chicha kiapú ta maid pammaticha ya natangken chi numnumcha, tay chaancha enafurot nan infiakian nan chiyuycha nangila kan hiya as nan natakuwana manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kenalina kan chicha, “Uy kayu henan intiru ay luta, ya ekasabayu nan Ammay ay Chamag as nan am-in ay tataku. ");
INSERT INTO ebk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nan omafurot ya mafunyakian at maesarakantu. Ngem nan achi omafurot at machusantu. ");
INSERT INTO ebk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nauycha nan nakaskaschaaw ay sinyar ay epailantu nan chiyuycha omaafurot: Mafialinchantu ay epafoknag nan chiyuycha anennet babaen as nan mangosarancha as nan ngachanku, ya makakalichantu as tukutukún ay kali ay epakalen nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Uray mu unnanchantu nan chiyuycha urug, winnu umikopcha as puwison at maid mangisiw ay ommat kan chicha. As nan mangepatayanchantu as limacha as nan chiyuycha munsaket at omammaychantu.” ");
INSERT INTO ebk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kun pay narpas ay naketakiatfor hi Apo Jesus kan chicha, naetag-uy hiya ad chaya, at tenmokor as apét kannawan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Angkiay ya naligwat nan disipulusna ya uycha nun-ekaskasaba henan am-in ay lukiar. Finadfiadngan Apo Jesus chicha, ya enpailana ay tit-iwa nan chacha ekaskasaba babaen as nan chiyuycha nakaskaschaaw ay sinyar ay enpaekamkamana kan chicha.");
INSERT INTO ebk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kan he-a machayaw ay Teofilo, Ongorcha nan namachas ay nangisurat as nan chiyuycha natongpar as nan kawad-an takú. ");
INSERT INTO ebk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nan insuratcha at kaman as nan nachamag takú as nan chiyuycha nangila as nan en-enat Jesus nunlapu as nan laplapuna ya nan chiyuycha nangekaskasaba as nan kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kiapú ta enmamadku ay nangachar as nan nauycha am-in ay enom-ommat nunlapu as nan nunlapuwancha, ninumnumku us ay ammay mu ornosok ay mangisurat as nan nauycha kan he-a ");
INSERT INTO ebk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ta maammuwam ay tit-iwa nan naisursuru kan he-a. ");
INSERT INTO ebk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","As nan timpu ay hi Herodes nan ari ad Judea, wacha nan usa ay pachi ay nan ngachana at Zacarias ay naetatapi as nan bunggoy chi papachi ay epapanguruwan Abias. Nan ngachan asawana at Elisabet ay kianak Aaron. ");
INSERT INTO ebk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nalintigcha ay hen-asawa as nan mangiil-an Apo Dios, ya tenongparcha ay ustu nan am-in ay filin ya lintig Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Maid anakcha, tay fiasig hi Elisabet, ya nunkarakaycha us challu. ");
INSERT INTO ebk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kun pay inumchan nan urkiw ay munserfiyan nan bunggoy ay naetatapiyan Zacarias, hiya nan cha mangekaman as nan chununa ay kenapachi. ");
INSERT INTO ebk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Maiyunud as nan iniili ay ukialen nan papachi, hi Zacarias nan nafunotan ay sungkop as nan Templo ay mamuor as nan insenso. ");
INSERT INTO ebk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kuna pay cha puoran nan insenso, chacha us munkararag nan am-in ay tataku as chará. ");
INSERT INTO ebk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Angkiay ya nunpaila kan Zacarias nan usa ay anghel Apo Dios ay nangatakchug as apét kannawan nan altar ay mangipuorancha as nan insenso. ");
INSERT INTO ebk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nakudnor hi Zacarias as nan nangil-ana as nan anghel, ya inmugyat hiya as solet. ");
INSERT INTO ebk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ngem kenalen nan chiyuy anghel kan hiya, “Achika umugyat, Zacarias, tay chinngor Apo Dios nan kararagmu, at omanaktu hi asawam ay Elisabet as laraki, ya ngadnam hiya as Juan. ");
INSERT INTO ebk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ongortu nan lagsakmu, ya ongortu us nan maragsakan as nan maiyankana, ");
INSERT INTO ebk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tay amudtu hiya as nan mangiilan Apo Dios. Masapor achi umikop as fiayas winnu tapina ay fumutang, ya mapnuntu hiya as Espiritu Santo uray as nan naisisikukiana. ");
INSERT INTO ebk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ongortu nan munfiangchuna ay kianak Israel kan Apo ay Dioscha. ");
INSERT INTO ebk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mangon-onantu hiya mu hi Cristo, ya nan pannakafialina at kamantu as nan inchat nan Espiritu Santo kan Elias ay pomapadtu ad pus-uy. Munlelennayachunantu nan am-a ya nan an-ak, ya nan nunkasokel at pafiangchunantu as nan kenasilib chi nalintig ay taku. Hiyachi nan atuna ay mangesakiana as nan tataku as nan omaliyan Cristo.” ");
INSERT INTO ebk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Angkiay kenalen Zacarias as nan anghel, “Anan mangammuwak mu tit-iwa nan kenalem, tay narakayak met ya kaman us kan asawak?” ");
INSERT INTO ebk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tinumfor nan anghel kan hiya, “Ha-un hi Gabriel ay fiabfiaarun Apo Dios ay nangatakchug as nan sangwanana. Infiaorak kan hiya ay mangifiakia kan he-a as nan nauy ammay ay chamag. ");
INSERT INTO ebk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kiapú ta chaanmu enafurot nan kenalek, maumorkantu inkiana umchan nan urkiw ay matongparan nan infiakiak kan he-a, tay tit-iwa ay matongpar chaná as nan timpuna.” ");
INSERT INTO ebk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","As nan hiyachi, sisin-ud nan tataku as chará nan pumitiwan Zacarias, ya chacha masmaschaaw mu adchi t'uy mafiayag hiya as Templo. ");
INSERT INTO ebk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kun pay pinmitiw hi Zacarias, achi at makakali kan chicha. Angkiay ya naawatancha ay wachay enpailan Apo Dios kan hiya as fiaruy, tay kun nunpadpacha hiya kan chicha ya achi makakali. ");
INSERT INTO ebk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kun pay narpas ay nunserfi as templo, kenmatam. ");
INSERT INTO ebk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kun pay chaan nafiayag, nunsikug hi Elisabet ay asawana, ya kun nuntutungaw as lema ay furan. ");
INSERT INTO ebk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kenalina as achorna, “Hi Apo Dios nan nangekaman as na kan ha-un, tay sinug-anganak as nan achek makaankan. Ad wani, maid ekafiainku as nan tataku.” ");
INSERT INTO ebk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kun pay as nan maekan-um ay furanun nan sikug Elisabet, infiaor Apo Dios hi anghel Gabriel ad Nazaret ay ili ad Galilea ");
INSERT INTO ebk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","as nan usa ay fiarasang ay nan ngachana at Maria ay chaan nakiskissuy as laraki. Hi Maria at naetfor kan Jose ay nurpu as nan kianak Ari David ad pus-uy. ");
INSERT INTO ebk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kun pay inmuy nan anghel kan Maria, kenalina, “Munlagragsakka! He-a ay nabendisyonan as solet, tay wacha hi Apo Dios kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nalilifokan as solet hi Maria as nan infiakian nan anghel, at ninumnunumnumna mu anan laychun nan nauy ay kanan. ");
INSERT INTO ebk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ngem kenalen nan anghel kan hiya, “Achika umug-ugyat Maria, tay benendisyonan chaká kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Munsikugkantu, at iyanakmu nan laraki, ya ngadnamtu hiya as Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hiyantu nan tit-iwa ay amud ya makali un Anak nan Kangatuwan ay Apo Dios. Mun-ariyuntu Apo Dios hiya ay kaman as nan kaap-uwana ay hi Ari David, ");
INSERT INTO ebk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ya hiyantu nan muntoray in-inkiana as nan chiyuycha kianak Jacob, ya maid munpatingkiaan nan muntorayana.” ");
INSERT INTO ebk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Senarudsud Maria as nan anghel, “Anuy man atun tona ay ommat, tay maid met laraki as nakiskissuy kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tinumfor nan anghel, “Omalintu nan Espiritu Santo kan he-a, ya as nan pannakafialin Apo Dios, ommat na kan he-a. Hiyana nan kiapúna ay nan nasantowan ay onga ay maiyanak at makali un Anak Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Uray nan ifiam ay Elisabet ay kanancha un fiasig ya narakay at unum chi furanun nan laraki ay insisikugna, ");
INSERT INTO ebk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","tay maid achi mafialin kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kenalen Maria, “Ha-un nan fiabfiaarun Apo Dios, ya kun ommat kan ha-un nan hana kenalem.” Angkiay ya tenaynan nan anghel hiya. ");
INSERT INTO ebk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kun pay chaan nafiayag as nan nanaynanan nan anghel kan Maria, kenamkamon Maria ay tinmikid henan chunchuntug inkiana inumchan henan usa ay ili ad Judea. ");
INSERT INTO ebk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sinungkop as afong cha Zacarias, ya kenomostana hi Elisabet. ");
INSERT INTO ebk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kun pay chinngor Elisabet nan kalen Maria, nunkiwi nan onga as putuna. Napnu hi Elisabet as Espiritu Santo, ");
INSERT INTO ebk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ya nunkali as napigsa, “Nabendisyonanka challu as nan am-in ay fianafiai, ya nabendisyonan nan onga as putom! ");
INSERT INTO ebk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Anuyak paat nabendisyonan t'uyak finisita as nan enan nan Apok? ");
INSERT INTO ebk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","As nan nanngorak as nan kalem, nunkiwi nan nauy onga as putok as lagsakna. ");
INSERT INTO ebk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nabendisyonanka, tay enafurotmu ay matongpar nan infiakian Apo Dios kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Angkiay kenalen Maria, “As nan am-in ay numnumku, ichaychayawku nan Apo. ");
INSERT INTO ebk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Munlagragsakak as solet kiapú kan Apo Dios ay Mangesarakan kan ha-un, ");
INSERT INTO ebk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","tay ninunumnumak ay kun lawá ap-apud ay mafiabfiaor! Munlapu ad wani, kanantu nan am-in ay tataku un nabendisyonanak, ");
INSERT INTO ebk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tay hi Apo Dios ay Mannakafialin ya nasantowan at enatna nan nakaskaschaaw kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Masug-ang hiya as nan am-in ay mangichaychayaw kan hiya manipud as nan kaap-uwan takú inkiana as nan chiyuycha cha somarsarunu ay kianakcha. ");
INSERT INTO ebk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Enpailana nan pannakafialina as nan nangwarawaraana as nan tataku ay nunkapangas. ");
INSERT INTO ebk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kenaana nan chiyuycha mannakafialin ay ar-ari as nan tronocha, ya enpangatuna nan ap-apud ay tataku. ");
INSERT INTO ebk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sinufuna nan chiyuycha cha munchukiaang as ammay, ya enpak-akna nan chiyuycha nafiaknang ay maid in-inchatna kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ninunumnumna nan enkarina as nan kaap-uwan takú, isunga finadngana nan chiyuycha kianak Israel ay fiabfiaaruna. ");
INSERT INTO ebk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kaman as nan enkarina kan Abraham ad pus-uy ya as nan chiyuycha kianakna ay sug-angana chicha in-inkiana.” ");
INSERT INTO ebk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kiayud umuy as turu ay furan nan nafofoonan Maria as afong cha Elisabet, angkiay ya kenmatam. ");
INSERT INTO ebk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kun pay inumchan nan urkiw ay omankan Elisabet, inyanakna nan laraki. ");
INSERT INTO ebk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chinngor nan sasag-una ya iib-ana nan sug-ang Apo Dios kan hiya, at nakelagragsakcha. ");
INSERT INTO ebk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","As nan maekawaru ay urkiw nan onga, enmalicha ay manugyat, ya mangepangachan koma kan hiya as Zacarias ay ngachan amana. ");
INSERT INTO ebk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ngem kenalen enana, “Fiakun sa. Nan ngachana at Juan.” ");
INSERT INTO ebk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kenalicha kan hiya, “Maid met ib-am as nakin ngachan as assesa.” ");
INSERT INTO ebk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Angkiay ya penachacha kan amana ay Zacarias mu ngachana nan laychuna ay epangachan as nan onga. ");
INSERT INTO ebk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nunpaara hi Zacarias as tabra as munsuratana, at insuratna na: “Nan ngachana at Juan.” Kuncha pay inila chi, naschaawcha am-in. ");
INSERT INTO ebk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kalina at ya makakali hi Zacarias ya nunchaychayaw kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Am-in nan sasag-uncha at naschaawcha as nan enommat, ya nan nauy ay chamag at naiwaras as nan umiili henan am-in ay chuntug ad Judea. ");
INSERT INTO ebk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nan am-in ay nanngor as na at ninumnunumnumcha ya waschi un senarudsudna, “Anan munfialinan ngun tona ay onga?” Kenalicha chi, tay inilacha ay wacha nan pannakafialin Apo Dios as nan onga. ");
INSERT INTO ebk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Napnu as Espiritu Santo hi Zacarias ay aman nan onga, ya enpadtuna na: ");
INSERT INTO ebk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Machaychayaw hi Apo Dios ay Apon nan chiyuycha kianak Israel, tay enmali ay nangfiachang as nan tatakuna, ya nangwayawaya kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Infiaorna kan chitaku nan mannakafialin ay Omesarakan ay nurpu as nan kianak Ari David ay fiabfiaaruna. ");
INSERT INTO ebk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hiyana challu nan enpaepadtuna as nan chiyuycha nasantowan ay pomapadtuna ad pus-uy ay nangali ");
INSERT INTO ebk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","un esarakana chitaku as nan chiyuycha kafusor takú ya as nan am-in ay mangiingor kan chitaku. ");
INSERT INTO ebk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Enkarina ay sug-angana nan kaap-uwan takú, ya achina liwliw-an nan nasantowan ay inturagna kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","O, enkarina kan Abraham ay kaap-uwan takú ");
INSERT INTO ebk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ay esarakana chitaku as nan chiyuycha kafusor takú, ya parufusana chitaku ay tumurud ay munserfi kan hiya ");
INSERT INTO ebk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ta nasantowan ya nalintig takú as nan mangiilan Apo Dios as nan am-in ay urkiw ay panagfiyag takú. ");
INSERT INTO ebk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“He-a ay anakku, he-a nan makali un pomapadton nan Kangatuwan ay Dios, tay omon-onaka mu nan Apo ta cham esakiana nan ayuna. ");
INSERT INTO ebk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Uymu cha epakaammu as nan tatakuna ay maesarakancha as nan mapakawanancha as nan fiasfiasorcha. ");
INSERT INTO ebk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kiapú as nan sug-ang Apo Dios kan chitaku, ifiaornantu nan murpu ad chaya ay mangesarakan kan chitaku ay maepachong as nan cha fomoknakian nan urkiw. ");
INSERT INTO ebk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tay as nan omaliyana ay murpu ad chaya, silawana nan tataku ay maepachong as nan matataku as nan ngongot ya umuycha as nan utúy ay maid patingkiana. Epangunantu chitaku as nan charan ay muntoróng as natalna ay numnum.” Hiyana nan kenalen Zacarias. ");
INSERT INTO ebk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Inmurúg nan onga, ya finmikas nan achorna, ya pinmigsa nan pammatina. Nayaschi henan disyerto inkiana inumchan nan urkiw ay nunpail-ana ay mun-isuru as nan tataku ay kianak Israel. ");
INSERT INTO ebk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","As nan hiyachi ay timpu, infilin Emperador Augustu ad Roma ay munpalesta nan am-in ay tataku henan am-in ay il-ili ay muntotorayana. ");
INSERT INTO ebk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hiyana nan omona ay naelestaan chi tataku at enommat as nan timpon Gobernador Kirenio ad Siria. ");
INSERT INTO ebk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Waschi un uy nunpalesta henan mismu ay ilina. ");
INSERT INTO ebk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kun pay hi Jose ay nurpu ad Nazaret ay usa ay ili ad Galilea, enmabrat ad Betlehem ay ili ad Judea, tay hid-i nan naiyankan Ari David ay kaap-uwana ad pus-uy. ");
INSERT INTO ebk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nuntun-udcha kan Maria ay naetfor ay asaw-una ta uycha us munpalesta. As nan hiyachi ay timpu, masisikug hi Maria. ");
INSERT INTO ebk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kuncha pay wacha ad Betlehem, inumchan at nan timpu ay omankan Maria, ");
INSERT INTO ebk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","at inyanakna nan laraki ay panguru ay anakna. Penotepotana as lopot ya enpab-ugna as nan mangmanganan chi animar. Hid-i ad Bethlehem nan inmiyanancha, tay maid magyanancha as nan chumawchawsan. ");
INSERT INTO ebk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","As nan hiyachi ay lafi, wachacha nan munpaspastor ay inmiiyan henan pastu ay naesasag-un henan hiyachi challu ay lukiar ay mamanfiantay as nan karnerocha. ");
INSERT INTO ebk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kalina at ya nunpaila nan usa ay anghel Apo Dios kan chicha, ya nasilawancha as nan sumili ay kaichayawan Apo Dios, ya inmugyatcha as solet. ");
INSERT INTO ebk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ngem kenalen nan anghel kan chicha, “Achi kayu umugyat, tay iyalek nan ammay ay chamag kan chakayu ay mangepalagsak as nan am-in ay tataku. ");
INSERT INTO ebk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ad wani ay urkiw, henan ilen Ari David, naiyanak nan Omesarakan ay hi Cristo ay hiya nan Apo. ");
INSERT INTO ebk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hiyana nan sinyar ay mangammuwanyu ay tit-iwa sa: Ilaunyuntu nan mutun ay napopotepotan as lopot ay naepapab-ug as nan mangmanganan chi animar.” ");
INSERT INTO ebk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kalina at ya nunpaila nan ongoongor ay angheles ay nurpu ad chaya ay kakadwan nan nauy anghel, ya chacha munchaychayaw kan Apo Dios ay chacha kankanan, ");
INSERT INTO ebk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Machaychayaw hi Apo Dios ad chaya, ya wachay kappia asna's luta as nan tataku ay mangepalaylayad kan hiya!” ");
INSERT INTO ebk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kuncha pay nunfiangad nan angheles ad chaya, natatakiatfor nan chiyuycha munpaspastor, “Uy takú ad Betlehem, ya uy takú ilaun nan nauy ay enommat ay enpakaammon Apo Dios kan chitaku.” ");
INSERT INTO ebk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Angkiay ya kenakamucha ay inmuy, ya ininchanancha cha Maria kan Jose ya nan mutun ay naepapab-ug as nan mangmanganan chi animar. ");
INSERT INTO ebk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","As nan nangil-ancha as nan mutun, infiakiacha kan chicha nan kenalen nan anghel maepangkep as nan nauy mutun. ");
INSERT INTO ebk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Naschaawcha nan am-in ay nanngor as nan infiagfiakian nan chiyuycha munpaspastor kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ngem kun ninunumnum am-in Maria chaná ya chana numnumnumun ay ustu. ");
INSERT INTO ebk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nan chiyuycha munpaspastor at nunfiangadcha ay cha munkankanta ya munchaychayaw kan Apo Dios kiapú as nan am-in ay chinngorcha ya inilacha ay infiakian nan anghel kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","As nan maekawaru ay urkiw nan mutun, sinugyatancha ya ngenadnancha as Jesus, tay hiyachi nan ngachan ay infiakian nan anghel kan chicha as nan chaana nurmuwan. ");
INSERT INTO ebk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kun pay enmali nan timpu ay mangekamanan cha Jose kan Maria as nan Lintig Moises ay pannakacharos, entakincha nan mutun ad Jerusalem ay uy mangiyawat kan hiya kan Apo Dios ");
INSERT INTO ebk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ay kaman as nan naisurat as nan Lintig Apo Dios ay kanana, “Am-in ay laraki ay panguru ay anak at kuwan Apo Dios chicha.” ");
INSERT INTO ebk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Uycha us inchaton kan Apo Dios nan infiakian nan Lintig ay chuwa ay fiarug winnu chuwa ay kinapad ay karopati. ");
INSERT INTO ebk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ad Jerusalem, wacha nan usa ay am-ama ay nan ngachana at Simeon ay maman-ud as nan kaesarakanan nan chiyuycha kianak Israel. Hi tona ay taku at nalintig ya tit-iwa ay manangchaychayaw kan Apo Dios, ya wacha nan Espiritu Santo kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Enpakaammon nan Espiritu Santo kan hiya ay achi matuy hiya inkiana ilauna hi Cristo ay enkaren nan Apo. ");
INSERT INTO ebk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kun pay entoróng nan Espiritu Santo hi Simeon as Templo, hiyachi us nan nangiskopan Jose ya hi asawana kan Jesus ta uycha atun nan naisurat as nan Lintig. ");
INSERT INTO ebk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Senakruy Simeon nan mutun ya chinaychayawna hi Apo Dios. Kenalina, ");
INSERT INTO ebk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Apo Dios, ad wani ay tenongparmu nan enkarem, eparufusmu koma ay matuyak ay fiabfiaarum ay wachay talna as numnumku, ");
INSERT INTO ebk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","tay inilak at ay mismu nan infiaormu ay Omesarakan ");
INSERT INTO ebk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ay ensasakianam as nan mangiilan nan am-in ay tataku. ");
INSERT INTO ebk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hiya at maepachong as nan silaw ay manilaw as numnum nan chiyuycha Gentil, ya kiapú kan hiya, maichayaw nan tatakom ay kianak Israel.” ");
INSERT INTO ebk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Naschaaw nan chanakchakor Jesus as nan kenalen Simeon maepangkep kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Angkiay ya benendisyonan Simeon chicha, ya kanana kan Maria ay enan Jesus, “Nan nauy ay anakmu at pinilen Apo Dios ay manachael ya mangesarakan as nan ongor ay kianak Israel. Hiya nan sinyar ay nurpu kan Apo Dios ay achi laychun nan ongor ay tataku. ");
INSERT INTO ebk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kiapú kan hiya, maammuwan nan tit-iwa ay wacha as numnumcha. Kun pay he-a ay enana, ngumunguyuska as solet ay kaman chaká chinuyok as tachum ay espada.” ");
INSERT INTO ebk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wacha us hid-i nan usa ay en-enagkiaw ay pomapadtu ay nan ngachana at Ana ay potot Fanuel ay kianak Aser. Pitu yangkiay ay tawwun nan enmaasaw-ana, ");
INSERT INTO ebk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","at ellakas hiya inkiana waron puru ya opat nan tawwuna. Inurkiw ya lenafi ay wacha hiya as Templo ay cha munchayachayaw kan Apo Dios, cha mun-ayuayunar ya cha munkarakararag. ");
INSERT INTO ebk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","As nan hiyachi ay uras, naesnop ay mangila kan Jesus. Nunyaman kan Apo Dios, ya infiakiana nan maepangkep as nan mutun as nan am-in ay maman-ud as nan mangwayawayaan Apo Dios as nan tataku ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kun pay narpas ay enat cha Jose kan Maria nan am-in ay filin as nan Lintig Apo Dios, nunfiangadcha ad Galilea henan mismu ay ilicha ay Nazaret. ");
INSERT INTO ebk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Inmurúg ya finmikas nan onga. Napnu us as silib, ya wacha kan hiya nan bendisyon Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tenawwun ay in-inmuy nan chanakchakor Jesus ad Jerusalem as nan Fiastan chi Munlausan. ");
INSERT INTO ebk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kun pay hinpuru ya chuwa nan tawwun Jesus, uycha nakifiasta ay maiyunud as nan iniili ay ukialicha. ");
INSERT INTO ebk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","As nan narpasan nan fiasta, inligwatcha ay munfiangad as ilicha. Ngem nunfiati hi Jesus ad Jerusalem ay achi ammon nan chanakchakorna. ");
INSERT INTO ebk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ka-anancha mu nakitutun-ud hiya as nan kakadwacha ay munfiangad as ilicha. Isunga nanad-arancha as usa ay urkiw, at enlapucha ay manganap kan hiya as nan iib-acha ya as nan am-ammucha. ");
INSERT INTO ebk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kuncha pay achi maanapan hiya, nunfiangadcha ad Jerusalem ay uy manganap kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kun pay inmuy chi turu ay urkiw, ininchanancha hi Jesus as nan Templo ay naketotokor ay chuchumngor as nan mun-isursuru as Lintig ya cha munsarsarudsud kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Am-in ay nanngor kan hiya at naschaawcha as nan pannakaawatna ya chiyuycha songfiatna. ");
INSERT INTO ebk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kun pay inilan nan chanakchakorna hiya, naschaawcha, ya kanan enana kan hiya, “Anakku, adchi t'uymu enat na kan chakami? Nachanakian kami as solet kan amam ay uy nangan-anap kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tinumfor hi Jesus, “Adchi t'uyak kis-an anapun? Ay achiyu ammu ay masapor wachaak as afong Amak?” ");
INSERT INTO ebk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ngem chaan naawatan nan chanakchakorna nan laychuna ay kanan kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Angkiay ya nakitun-ud hi Jesus kan chicha ay nunfiangad as ilicha ay Nazaret, at tenongtongparna cha amana kan enana. Kun ninunumnum am-in enana chaná ay enom-ommat. ");
INSERT INTO ebk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Inmurúg ya sinmilib hi Jesus, at nalaylaychan hi Apo Dios ya nan tataku kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","As nan maekapuru ya lema ay tawwun ay nuntorayan Emperador Tiberio, hi Poncio Pilato nan gobernador ad Judea, hi Herodes nan nuntoray ad Galilea, hi Felipe ay sunúdna nan nuntoray ad Iturea ya Traconite, ya hi Lisanias nan nuntoray ad Abilene. ");
INSERT INTO ebk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nan kangatuwan ay papachen chi Judio at cha Anas kan Caifas. As nan hana ay timpu, wacha nan kenalen Apo Dios kan Juan ay potot Zacarias as nan kawad-ana henan disyerto. ");
INSERT INTO ebk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Uy nun-ekaskasaba hi Juan henan am-in ay lukiar ay nangliliwus henan wawwang ay Jordan. Kenarkalina, “Munfiafiawi kayu ya munpafunyag kayu, at pakawanun Apo Dios chakayu as nan fiasfiasoryu.” ");
INSERT INTO ebk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nan nauy ay en-enat Juan at hiyana nan natongparan nan enpaisurat Apo Dios kan Isaias ay pomapadtu ay kanana: “Wacha nan taku henan disyerto ay cha mangifugfukiaw un, ‘Esakianayu nan ayun nan Apo. Munlutkunyu nan ayuna.’ ");
INSERT INTO ebk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Masapor maafiab nan chiyuycha nakaongan. Mapanad nan chiyuycha filig. Munfialin as lutug nan chiyuycha charan ay nunkatiku. Machuschusan nan chiyuycha tinmutunu. ");
INSERT INTO ebk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ilauntu nan am-in ay tataku nan atun Apo Dios ay omesarakan.” ");
INSERT INTO ebk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kenalen Juan as nan ongoongor ay tataku ay uy munpafunyag kan hiya, “Hoy! Chakayu ay kaman an-ak chi kubra! Anan nangali kan chakayu un malisiyanyu nan omali ay ichusan Apo Dios mu mafunyakian kayu? ");
INSERT INTO ebk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Masapor atunyu nan mangepaila ay tit-iwa ay nunfiafiawi kayu as nan fiasfiasoryu. Achiyu kankanan as achoryu un, ‘Achi chakami challu chusaun kan Apo Dios, tay hi Abraham nan kaap-uwanmi.’ Tay ifiakiak kan chakayu ay uray nan nauycha fiatu at mafialin ay munfialinun Apo Dios as kiankianak Abraham! ");
INSERT INTO ebk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nan ichusan Apo Dios at kaman as nan wasay ay naesasakiana ay manipor as kaiw. Am-in ay kaiw ay achi fumkias as ammay at maesalepooncha ay masipor, ya maichus-orcha as nan apuy.” ");
INSERT INTO ebk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Senarudsud nan ongor ay tataku kan hiya, “Ngachana nan atunmi ngarud?” ");
INSERT INTO ebk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tinumfor hi Juan kan chicha, “Nan taku ay wachay fiachuna as chuwa at masapor ichatna nan usa as nan maid fiachuna, ya nan wachay kanuna at umichat as nan maid kanuna.” ");
INSERT INTO ebk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wachacha us nan mangam-among as fiaror ay inmuy ay munpafunyag, ya kanancha kan Juan, “Misturu, ngachana nan atunmi?” ");
INSERT INTO ebk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Achi kayu munsengsengel as subra mu nan naifilin kan chakayu,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wachacha us nan sosorchachu ay nanarudsud kan hiya, “Chakami ngay, ngachana nan atunmi?” Tinumfor hi Juan kan chicha, “Achiyu epelpelet ay mangara as siping chi uray ngachana ay taku winnu achi kayu munkutkutum ay mangepafiasor as nan uray ngachana ay taku. Mapnek kayu as nan silchuyu.” ");
INSERT INTO ebk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kiapú as nan infiakian Juan, pinmigsa nan namnaman nan tataku, ya chacha numnumun nan maepangkep kan Juan ay uy at hiya nan Cristo. ");
INSERT INTO ebk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kenalen Juan kan chicha am-in, “Funyakiak chakayu as chanum, ngem wacha nan cha umunud kan ha-un ay am-amud mu ha-un. Achiyak paat maekari ay mangfokat as kiarot chi sapatosna. Funyakianantu chakayu as Espiritu Santo ya apuy. ");
INSERT INTO ebk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Maepadpachong hiya as nan taku ay nanangchun as ligkia ay osaruna ay manapa as nan finayu. Nan natap-an at ittunantu as nan mangit-ittuwan. Ngem nan chuki at ipuornantu as nan apuy ay achi mapappauy.” ");
INSERT INTO ebk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ongor pay nan tapina ay enosarna as nan chana mangekasabaan as nan Ammay ay Chamag as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ngem senengaran Juan hi Gobernador Herodes, tay penlosna hi Herodias ay asawan nan sunúdna, ya kiapú as nan am-in ay tapina pay ay manangotettet ay en-enatna. ");
INSERT INTO ebk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nan usa pay ay mangotettet ay enatna at nan nangepafiaruchana kan Juan. ");
INSERT INTO ebk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","As nan chaan pay naifiaruchan Juan as nan chana mamunfunyakian as nan ongor ay tataku, uy nunpafunyag us hi Jesus. As nan cha munkarkararakian Jesus kan Apo Dios, natkafian ad chaya. ");
INSERT INTO ebk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Angkiay ya kenomsop kan hiya nan Espiritu Santo ay kaman as nan ilan chi karopati, ya wacha nan kali ay nurpu ad chaya ay kanana, “He-a nan anakku ay laylaychok. Malaylaychanak paat kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kiayud turon puru ay tawwun Jesus as nan nangelapuwana ay nun-isuru as nan tataku. Infilang nan tataku hiya as potot Jose. Hi Jose at potot Eli. ");
INSERT INTO ebk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hi Eli at potot Matat. Hi Matat at potot Levi. Hi Levi at potot Melki. Hi Melki at potot Jane. Hi Jane at potot Jose; ");
INSERT INTO ebk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Hi Jose at potot Matatias. Hi Matatias at potot Amos. Hi Amos at potot Nahum. Hi Nahum at potot Esli. Hi Esli at potot Nage. ");
INSERT INTO ebk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Hi Nage at potot Maat. Hi Maat at potot Matatias. Hi Matatias at potot Semei. Hi Semei at potot Jose. Hi Jose at potot Juda. ");
INSERT INTO ebk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Hi Juda at potot Joana. Hi Joana at potot Resa. Hi Resa at potot Zorobabel. Hi Zorobabel at potot Salatiel. Hi Salatiel at potot Neri. ");
INSERT INTO ebk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Hi Neri at potot Melki. Hi Melki at potot Adi. Hi Adi at potot Cosam. Hi Cosam at potot Elmodam. Hi Elmodam at potot Er. ");
INSERT INTO ebk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Hi Er at potot Josue. Hi Josue at potot Eliezer. Hi Eliezer at potot Jorim. Hi Jorim at potot Matat. Hi Matat at potot Levi. ");
INSERT INTO ebk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Hi Levi at potot Simeon. Hi Simeon at potot Juda. Hi Juda at potot Jose. Hi Jose at potot Jonan. Hi Jonan at potot Eliakim. ");
INSERT INTO ebk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Hi Eliakim at potot Melea. Hi Melea at potot Mena. Hi Mena at potot Matata. Hi Matata at potot Natan. Hi Natan at potot David. ");
INSERT INTO ebk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Hi David at potot Jesse. Hi Jesse at potot Obed. Hi Obed at potot Booz. Hi Booz at potot Salmon. Hi Salmon at potot Naason. ");
INSERT INTO ebk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Hi Naason at potot Aminadab. Hi Aminadab at potot Aram. Hi Aram at potot Arni. Hi Arni at potot Esron. Hi Esron at potot Fares. Hi Fares at potot Juda. ");
INSERT INTO ebk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Hi Juda at potot Jacob. Hi Jacob at potot Isaac. Hi Isaac at potot Abraham. Hi Abraham at potot Tare. Hi Tare at potot Nacor. ");
INSERT INTO ebk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Hi Nacor at potot Serug. Hi Serug at potot Ragau. Hi Ragau at potot Peleg. Hi Peleg at potot Heber. Hi Heber at potot Selah. ");
INSERT INTO ebk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Hi Selah at potot Cainan. Hi Cainan at potot Arfaxad. Hi Arfaxad at potot Sem. Hi Sem at potot Noe. Hi Noe at potot Lamec. ");
INSERT INTO ebk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Hi Lamec at potot Matusalem. Hi Matusalem at potot Enoc. Hi Enoc at potot Jared. Hi Jared at potot Mahalaleel. Hi Mahalaleel at potot Cainan. ");
INSERT INTO ebk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Hi Cainan at potot Enos. Hi Enos at potot Set. Hi Set at potot Adan, ya hi Adan at anak Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Hi Jesus ay napnu as pannakafialin nan Espiritu Santo at nak-ak henan wawwang ay Jordan. Enpangon nan Espiritu Santo hiya henan disyerto. ");
INSERT INTO ebk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hid-i nan nanistingan Satanas kan hiya as opat puru ay urkiw. As nan chiyuycha ay urkiw, chaan nangnangan hi Jesus. Kun pay narpas chachi, nunchukiaang hiya. ");
INSERT INTO ebk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kenalen Satanas kan hiya, “Mu tit-iwa ay anak chaká kan Apo Dios, filinum nan nauy fiatu ta munfialin as tenapay.” ");
INSERT INTO ebk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tinumfor hi Jesus kan hiya, “Nan naisurat as nan Kalen Apo Dios at kanana un, ‘Fiakun yangkiay makan nan pagfiyag nan taku.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Angkiay ya enpangon Satanas hi Jesus as nan nangatu ay lukiar, ya as nan apag-ila yangkiay, enpailana kan Jesus nan am-in ay muntorayan asna's luta. ");
INSERT INTO ebk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kenalen Satanas, “Ichatkuntu kan he-a nan nauycha am-in ay kalibfengan ay mangetoray hena ya am-in nan nauycha kenafiaknangcha, tay naichat at chaná kan ha-un, at ichatkuntu as nan laychok ay mangichatan. ");
INSERT INTO ebk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Isunga mu chayawunak kan he-a, kuwam am-in chaná.” ");
INSERT INTO ebk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tinumfor hi Jesus kan hiya, “Nan naisurat as nan Kalen Apo Dios at kanana un, ‘Chayawum nan Apo ay Diosmu, ya kan hiya yangkiay nan munserfiyam.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Angkiay ya enpangon Satanas hiya ad Jerusalem, ya enpatakchugna hiya as nan kangatuwan ay parten nan Templo. Kenalina kan hiya, “Mu tit-iwa ay Anak chaká kan Apo Dios, ud-a pay omagkiangka munlapu hena inkiana as kuwabna, ");
INSERT INTO ebk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tay nan naisurat met as nan Kalen Apo Dios at kanana un, ‘Filinun Apo Dios nan anghelesna ay mangaywan kan he-a. ");
INSERT INTO ebk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tatag-uyun chakantu kan chicha as nan limacha ta achi maepakpak nan sukem as nan fiatu.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tinumfor hi Jesus kan hiya, “Wacha met us nan naisurat as nan Kalen Apo Dios ay kanana un, ‘Achim chischistingun nan Apo ay Diosmu.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kun pay enat Satanas nan am-in ay kafiaelana ay nanisting kan Jesus, tenaynan Satanas hiya inkiana kasin mawad-an as chansana. ");
INSERT INTO ebk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nunfiangad hi Jesus ad Galilea ay wacha kan hiya nan pannakafialin nan Espiritu Santo, at nunchinamag nan maepangkep kan hiya henan am-in ay lukiar ad Galilea. ");
INSERT INTO ebk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nun-is-isuru hiya as nan chiyuycha senagogacha, ya chinaychayaw nan am-in ay tataku hiya. ");
INSERT INTO ebk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Angkiay ya inmuy hi Jesus ad Nazaret ay nasiknana. Kun pay inumchan nan Urkiw ay Mun-iblayan, inmuy hiya as nan senagoga, tay hiyasa challu nan chana atuatun. Tenmakchug ay mamasa as nan Kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Naichat kan hiya nan nalolopelop ay insurat Isaias ay pomapadtu. Finitlagna ya ininchanana nan naisurat ay kanana, ");
INSERT INTO ebk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wacha nan Espiriton Apo Dios kan ha-un, tay piniliyak ay mangekasaba as nan Ammay ay Chamag as nan pugli. Infiaorak ay uy mangifiaag as nan pannakailufus nan chiyuycha fiarud, makail-an nan nunkafurag, ya pannakawayawayan nan munliglikiat. ");
INSERT INTO ebk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Infiaorak us ay mangepakaammu as nan timpu ay mangesarakanan Apo Dios as nan tatakuna.” ");
INSERT INTO ebk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lenopelopna kasin nan nangfiasaana ya infiangadna as nan fumadfiachang, at tenmokor hiya. Am-in nan tataku ay wacha as nan senagoga at entotoongancha hiya. ");
INSERT INTO ebk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kenalina kan chicha, “Nan nauy naisurat as nan Kalen Apo Dios ay chinngoryu ay naifiasa at natongpar ad wani.” ");
INSERT INTO ebk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ammay nan kaap-apatana as nan am-in ay tataku, ya naschaawcha as nan kenaammay nan kenalina. Kenalicha, “Ay fiakun hi tona nan potot Jose?” ");
INSERT INTO ebk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kenalina kan chicha, “Ammok ay ifiakiayuntu kan ha-un nan nauy ay karkali: ‘Choktor, akiasam nan achormu.’ Kananyuntu us un, ‘Atum as nan mismu ay ilem nan chinngormi ay en-enatmu ad Capernaum.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kenalen pay Jesus, “Ifiakiak kan chakayu nan tit-iwa ay maid challu pomapadtu ay maichayaw henan mismu ay ilina. ");
INSERT INTO ebk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ifiakiak kan chakayu ay tit-iwa ay ongor chi ellakas ad Israel as nan timpon Elias. As nan hiyasa ay timpu, chaan inmud-uchan as turu ya kakudwa ay tawwun, ya nunsidlay fitel henan intiru ay luta. ");
INSERT INTO ebk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hi Elias at chaan naifiaor ay fumachang as nan uray usa kan chicha ad Israel, ngem kun yangkiay as nan usa ay ellakas ad Serepta ay sakop nan Sidon. ");
INSERT INTO ebk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ongor us chi nakonet ad Israel as nan timpon nan pomapadtu ay hi Eliseo, ya maid enpaammayna kan chicha, ngem kun yangkiay hi Naaman ay i-Siria.” ");
INSERT INTO ebk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kun pay chinngor nan am-in ay tataku ay wacha as nan senagoga nan kenalen Jesus, finmungatcha as solet. ");
INSERT INTO ebk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Natannakchugcha ya peneletcha hiya ay mangek-ak henan ili. Inyuycha hiya henan teng-el nan chuntug ay nasasad-an nan ilicha ta uycha koma tokchakun. ");
INSERT INTO ebk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngem kun at kinmawa kan chicha ya nak-ak. ");
INSERT INTO ebk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Angkiay ya inmuy hi Jesus ad Capernaum ay ili ad Galilea, ya enlapuna ay nun-isuru as nan tataku as nan Urkiw ay Mun-iblayan. ");
INSERT INTO ebk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Naschaawcha am-in as nan enatna ay nun-isuru, tay wachay kalibfengan as nan kalina. ");
INSERT INTO ebk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","As nan senagoga, wacha nan usa ay laraki ay naanennetan. Infukiawna, ");
INSERT INTO ebk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ha! Anan atum kan chakami, Jesus ay i-Nazaret? Ay enmalika ay manachael kan chakami? Am-ammok he-a. He-a nan nasantowan ay infiaor Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ngem senengaran Jesus nan anennet. Kenalina, “Kuminakka! Fomoknagka kan tosa ay laraki!” Entap-or nan anennet nan laraki as nan sangwanan nan tataku, at fenmoknag hiya ay maid enkamkamana as putug as nan laraki. ");
INSERT INTO ebk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Naschaaw as solet nan am-in ay tataku, ya chacha matatakiatfor, “Ngachan tona man ay kali? Wachay kalibfengana ya pannakafialina ay mamilin as nan chiyuycha anennet, at fomoknagcha tit-iwa.” ");
INSERT INTO ebk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nunchinamag nan maepangkep kan Jesus henan am-in ay sasakopun nan hana ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Angkiay ya nak-ak hi Jesus as nan senagoga, ya inmuy as afong cha Simon. Nan katukiangan Simon ay fiafiai at pararuy puchotna. Naketakiatforcha kan Jesus ta fiadngana hiya. ");
INSERT INTO ebk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Uy tenmakchug hi Jesus as nan sag-un nan fiafiai, ya kuna pay finilin nan puchotna ay makaan, at nakaan. Nafiannangun nan fiafiai ya nunsakiana as kanuncha. ");
INSERT INTO ebk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kun pay cha maschum, inyalen nan tataku kan Jesus nan am-in ay kiakiayyumcha ay munsaket as tukutukún ay saket. Enpatay Jesus nan limana as nan tunggal usa kan chicha, at enpaammayna chicha am-in. ");
INSERT INTO ebk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Fenmoknag us nan chiyuycha anennet as nan ongor ay tataku ay nunkaanennetan. As nan chacha fomoknakian, chacha ifugfukiaw, “He-a nan Anak Apo Dios!” Ngem senengaran Jesus chicha ya achina parufusan chicha ay munkali, tay ammucha ay hiya nan Cristo. ");
INSERT INTO ebk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kun pay cha mafikiat, nak-ak hi Jesus henan hana ay ili ya inmuy henan kamaid chi umili. Cha an-anapun nan tataku hiya, ya kuncha pay naanapan, enpakudcha hiya ta achi mak-ak. ");
INSERT INTO ebk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ngem kenalina kan chicha, “Masapor ekasabak nan Ammay ay Chamag maepangkep as nan muntorayan Apo Dios as nan tapina ay il-ili, tay hiyana nan nangifiaoranak kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Uy ngarud nun-ekaskasaba as nan chiyuycha senagoga henan intiru ay probinsiya ay Judea. ");
INSERT INTO ebk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","As nan hin-urkiw as nan nangatakchukian Jesus henan olet nan Fiayfiay ay Genesaret, nunsosonnor nan tataku ay maesnop kan hiya ay manngor as nan isuruna ay kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Inilana nan chuwa ay fiangka as nan oletna ay tenaynan nan chiyuycha nakin kuwa ay cha manguras as nan tafukorcha. ");
INSERT INTO ebk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nunlukian hi Jesus as nan fiangkan Simon, ya chinawatna kan Simon ay iyad-achawwina as akét nan fiangka henan olet nan fiayfiay. Angkiay ya tenmokor hi Jesus ya nun-isuru as nan tataku ay wacha henan oletna. ");
INSERT INTO ebk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kun pay narpas ay nun-isuru as nan tataku, kenalina kan Simon, “Iyuymu nan nauy fiangka as nan posong, ya uy-uyunyu na hanacha tafukoryu ta wachay tafukoranyu.” ");
INSERT INTO ebk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tinumfor hi Simon, “Apo, enlabrafimi ay nanafutafukor ya maid poros enarami. Ngem mu hiyasay kanam, uy-uyok nan nauycha tafukor.” ");
INSERT INTO ebk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kuncha pay tit-iwa enat na, ongoongor nan natafukoran, ya kiayud marakset nan chiyuycha tafukor. ");
INSERT INTO ebk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Isunga wenatkiyancha nan kakadwacha ay wacha as nan usa ay fiangkacha ta omalicha ay fumachang. Kuncha pay enmali, pinnucha nan chuwa ay fiangka as nan tenafukorancha, at kiayudcha lumnud. ");
INSERT INTO ebk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kun pay inilan Simon Pedro nan enommat, nunlukfub hiya as nan sangwanan Jesus, ya kanana, “Tomaakka kan ha-un Apo, tay fumafiasorak ay taku.” ");
INSERT INTO ebk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Naschaaw hi Pedro ya nan am-in ay kakadwana as nan ongoongor ay tenafukorancha ");
INSERT INTO ebk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ay kaman us kan cha Santiago kan Juan ay potot Zebedeo ay kakadwan Simon. Angkiay ya kenalen Jesus kan Simon, “Achika umug-ugyat. Munlapu ad wani, tataku nan tafukoramtu.” ");
INSERT INTO ebk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kuncha pay enpaolet nan fiangkacha, tenaynancha nan am-in, ya inmunudcha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","As nan hin-urkiw ay kawad-an Jesus henan usa ay ili, wacha nan usa ay laraki ay nakonet nan intiru ay achorna. Kuna pay inila hi Jesus, uy nunlukfub as nan sangwanana, ya enpakaasina, “Apo, mu laychum, epaammayak koma.” ");
INSERT INTO ebk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Inchawchaw Jesus nan limana, ya kenpana hiya. Kenalina, “Laychok. Omammayka!” Hiya at chi ya nakaan nan konet nan hana laraki. ");
INSERT INTO ebk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Angkiay ya kenalen Jesus kan hiya, “Achim ifiagfiakia as kumpurmi nan enommat kan he-a. Ngem kunka at uy munpaila as nan pachi ta ilauna ay nakaan nan saketmu. Kun pay marpas, umichatka as chatonmu kan Apo Dios ay kaman as nan infilin Moises ta mangammuwan nan tataku ay nakaan tit-iwa nan saketmu.” ");
INSERT INTO ebk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ngem kaskasin nunchinamag nan maepangkep kan Jesus. Ongoongorchay tataku ay enmali ay manngor as nan kanana ya uy munpakaan as nan saksaketcha. ");
INSERT INTO ebk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ngem kun pay hi Jesus, inmuy hiya henan kamaid chi umili ay nunkararag. ");
INSERT INTO ebk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","As nan hin-urkiw ay cha mun-isursuruwan Jesus, wachacha nan Fariseo ya nan mun-isursuru as Lintig ay nangatokor ay cha manmanngor as nan chana kankanan. Nurpucha henan am-in ay ili ad Galilea, ad Judea ya ad Jerusalem. Wacha nan pannakafialin Apo Dios kan Jesus ay mangepaammay as tataku ay cha munsaket. ");
INSERT INTO ebk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","As nan hiyachi, wachacha nan nangiyaattang ay nangiyali as usa ay laraki ay paralitiko. Penachascha ay mangiskop as nan afong ay kawad-an Jesus ta epab-ugcha as nan sangwanana. ");
INSERT INTO ebk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ngem maid atuncha ay mangiskop, tay ongoongor chi tataku. Isunga inyuycha as tabfongan. Kinusfotancha nan atop, at inuy-uycha hiya ay kukutug as nan inuumfukiana as nan paat sangwanan Jesus as nan kiawan nan ongor ay tataku. ");
INSERT INTO ebk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kun pay inilan Jesus nan pammaticha, kenalina as nan paralitiko, “Ifia, napakawanka as nan fiasfiasormu.” ");
INSERT INTO ebk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Angkiay ya enlapon nan chiyuycha mun-isursuru as Lintig ya nan chiyuycha Fariseo ay nunsesennarudsud, “Ngachan man tona ay taku ay paat mangepachong as achorna kan Apo Dios? Ngachana nan makafiael ay mamakawan as nan tataku as nan fiasfiasorcha mu achi hi Apo Dios yangkiay?” ");
INSERT INTO ebk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kun pay naammuwan Jesus nan chacha numnumnumun, kenalina kan chicha, “Adchi sa as chayu numnumnumun? ");
INSERT INTO ebk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngachana nan narakraka as kanan, ‘Napakawanka as nan fiasfiasormu,’ winnu kanan un, ‘Maligwatka ya manaranka’? ");
INSERT INTO ebk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngem mu hiyasa, atok na ta maammuwanyu ay nan Naepadtu ay Anak chi Taku at wachay kalibfengana asna's luta ay mamakawan as nan tataku as nan fiasfiasorcha.” Kenalina as nan paralitiko, “Kanak kan he-a, tomakchugka, araum nan apragmu ya komatamka.” ");
INSERT INTO ebk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hiya at chi ya tenmakchug nan laraki ay iilauncha am-in. Angkiay nun-arana nan apragna, ya kenmatam ay cha munchaychayaw kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Naschaawcha as solet nan am-in ay tataku. Chinaychayawcha hi Apo Dios ya pararuy ugyatcha. Kenalicha, “Anuy paat nakaskaschaaw nan inila takú ad wani.” ");
INSERT INTO ebk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kun pay narpas na, nak-ak hi Jesus ya inilana nan usa ay mangam-among as fiaror ay nan ngachana at Levi ay nangatokor as opisinana ay munfiayfiayachan as fiaror. Kenalen Jesus kan hiya, “Unuchunak.” ");
INSERT INTO ebk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nunkaliligwat hi Levi ay nanaynan as nan am-in ya inmunud kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Angkiay ya nunparti hi Levi as fiaka as afongna ta pachayawana hi Jesus. Ongorcha us nan mangam-among as fiaror ya tapina ay tataku ay uy nakekan. ");
INSERT INTO ebk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kun pay inilan nan chiyuycha Fariseo ya nan kakadwacha ay mun-isursuru as Lintig ay cha makekan hi Jesus as nan chiyuycha mangam-among as fiaror, nunmotmotcha as nan disipulus Jesus. Kenalicha, “Adchi t'uy kayu makiub-ufong ya makiig-ikop as nan chiyuycha mangam-among as fiaror ya as nan tapina ay fumafiasor?” ");
INSERT INTO ebk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tinumfor hi Jesus kan chicha, “Nan tataku ay achi munsaket at achicha masapor chi choktor, ngem kun yangkiay nan chiyuycha munsaket. ");
INSERT INTO ebk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Chaanak enmali ay mangayag as nan nunkalintig, ngem kun at nan fumafiasor ta munfiafiawicha.” ");
INSERT INTO ebk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kenalen nan tapina kan Jesus, “Nan disipulus Juan ay Fumufunyag ya nan disipulus nan chiyuycha Fariseo at kun anaka un nun-ay-ayunarcha ya nunkarkararagcha. Ngem nan disipulusmu at chacha mangmangan ya umig-ikop.” ");
INSERT INTO ebk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tinumfor hi Jesus kan chicha, “Ay mafialin ay mun-ayunarunyu nan chiyuycha naayakian ay makichuyas uray mu kukutug nan chumuyas ay laraki kan chicha? Achi met! ");
INSERT INTO ebk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ngem mu umchantu nan timpu ay maek-akan nan chinmuyas ay laraki kan chicha, hiyachintu nan mun-ayunarancha.” ");
INSERT INTO ebk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Angkiay ya infiakian us Jesus na ay maepadpachongan: “Maid lomakset as akét as nan fiarú ay fiachu ya elakubna as nan lukiak ay fiachu. Mu atuna chi, kuna lawá chachaelun nan chiyuy fiarú ay fiachu, ya achi maifiakiay as nan naelakfiana ay lukiak ay fiachu. ");
INSERT INTO ebk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Maid us mangittu as kasubsufor ay fiayas as nan lukiak ay mangit-ittuwan ay larat. Mu ipuuyna, epabtaktu nan kasubsufor ay fiayas nan larat. Maiwagkiantu nan fiayas ya machachaeltu nan mangit-ittuwan ay larat. ");
INSERT INTO ebk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ngem kun at nan kasubsufor ay fiayas at masapor maittu as nan fiarú ay mangit-ittuwan ay larat. ");
INSERT INTO ebk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Maid us manglayad ay umikop as kasubsufor ay fiayas mu narpas at ay inmikop as norkiat, tay kanancha un am-am-ammay nan norkiat.” ");
INSERT INTO ebk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","As nan Urkiw ay Mun-iblayan, cha mar-os cha Jesus as nan chiyuycha uma ay natanman as trigo. As nan hiyachi, nunsaw-i nan disipulusna ya kinutimancha, at kenancha. ");
INSERT INTO ebk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ngem kenalen nan tapen nan chiyuycha Fariseo, “Adchi t'uyyu cha atun nan epawan nan Lintig takú as nan Urkiw ay Mun-iblayan?” ");
INSERT INTO ebk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tinumfor hi Jesus, “Ay chaanyu finasfiasa nan enat Ari David ya nan kakadwana as nan nunchukiaangancha? ");
INSERT INTO ebk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sinungkop hi David as nan munchaychayawan kan Apo Dios, ya enarana nan tenapay ay naichaton kan Apo Dios ya kenana. Ngem epawan nan Lintig nan ngachana ay mangan mu achi yangkiay nan papachi. Inchatna us nan tapen nan tenapay as nan kakadwana.” ");
INSERT INTO ebk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Inyanongos Jesus, “Nan Naepadtu ay Anak chi Taku nan muntoray as nan Urkiw ay Mun-iblayan.” ");
INSERT INTO ebk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","As nan kasin usa ay Urkiw ay Mun-iblayan, sinungkop hi Jesus as nan senagoga, ya nun-isuru. Wacha hid-i nan usa ay laraki ay nakukuy nan kannawan ay limana. ");
INSERT INTO ebk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wachacha us nan tapen nan chiyuycha mun-isursuru as Lintig ya tapen nan chiyuycha Fariseo ay manisiim kan Jesus mu mun-epaammay as tataku ay wachay saketcha as nan Urkiw ay Mun-iblayan ta wachay maanapan as epafiasorcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ngem aammon Jesus nan wacha as numnumcha, at kenalina as nan nakukuy chi limana, “Maligwatka ya omalika hena.” Naligwat tit-iwa ya uy tenmakchug hid-i. ");
INSERT INTO ebk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Angkiay kenalen Jesus kan chicha, “Sarudsuchok man kan chakayu mu ngachana nan eparufus nan Lintig ay atun takú as nan Urkiw ay Mun-iblayan: Ay atun takú nan ammay winnu mangotettet? Ay esarakan takú nan fiyag chi taku winnu chachaelun takú?” ");
INSERT INTO ebk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Entoongan Jesus chicha am-in, ya kanana as nan nakukuy chi limana, “Uyachum nan limam.” Inuyadna ya enmammay tit-iwa nan limana. ");
INSERT INTO ebk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ngem pararuy fungat nan chiyuycha mun-isursuru as Lintig ya nan chiyuycha Fariseo, at naaapatcha mu anan atuncha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","As nan hana ay timpu, tinmikid hi Jesus henan chuntug ay uy munkararag. Enlabrafina hid-i ay nunkarkararag kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kun pay nafikiat, enayakiana nan disipulusna ya pinilina nan hinpuru ya chuwa kan chicha ay ngenadnana as apostoles. ");
INSERT INTO ebk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nauycha nan ngadngachan nan pinilina: Hi Simon ay ngenadnana as Pedro, hi Andres ay sunúd Pedro, hi Santiago, hi Juan, hi Felipe, hi Bartolome, ");
INSERT INTO ebk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","hi Mateo, hi Tomas, hi Santiago ay potot Alfeo, hi Simon ay kanancha un mangesasaket as nasyona, ");
INSERT INTO ebk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","hi Judas ay potot Santiago, ya hi Judas Iscariote ay mangesepseptu kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chinmayyu cha Jesus ya inyawnina as nan nuntatapor ay lukiar ay kawad-an nan ongor ay tapina ay disipulusna. Wachacha hid-i nan ongoongor ay tataku ay nurpu henan am-in ay lukiar ad Judea ya Jerusalem. Wachacha us nan nurpu henan chiyuycha siyudad ay Tiro ya Sidon ay wacha henan olet nan fiayfiay. ");
INSERT INTO ebk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Enmalicha ay manngor as nan isursuron Jesus ya mangepakaan as am-in ay saksaketcha. Enpaammay Jesus nan chiyuycha enmali ay penarpalikiat chi anennet. ");
INSERT INTO ebk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Am-in nan tataku hid-i at penachascha ay mangpa kan Jesus, tay wacha nan pannakafialin ay murpu kan hiya, at enpaammayna chicha am-in ay wachay saketcha. ");
INSERT INTO ebk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Inilan Jesus nan disipulusna, ya kanana, “Nakiasat kayu ay pugli, tay maetapi kayuntu as nan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nakiasat kayu ay cha munchukiaang ad wani, tay mapnek kayuntu. Nakiasat kayu ay cha mun-akor ad wani, tay maamrang kayuntu. ");
INSERT INTO ebk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nakiasat kayu as nan mang-ingoran nan tataku kan chakayu, as nan achicha mangetapiyan kan chakayu kan chicha, as nan mangsotancha kan chakayu, ya as nan mangaliyancha un mangotettet kayu kiapú as nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Munlagragsak ya muntat-allok kayu kiapú as lagsakyu as nan ommatan nan hanacha kan chakayu, tay ongoongor nan gun-gunayu ad chaya. Tay assesa us nan en-enat nan kaap-uwancha as nan chiyuycha pomapadtu.” ");
INSERT INTO ebk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ngem kasusug-ang kayu ay nunkafiaknang ad wani, tay enawatyu at nan kenanam-ay chi fiyagyu. ");
INSERT INTO ebk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kasusug-ang kayu ay masusufu ad wani, tay munchukiaang kayuntu. Kasusug-ang kayu ay cha maam-amrang ad wani, tay ngumuyus ya mun-akor kayuntu. ");
INSERT INTO ebk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kasusug-ang kayu as nan mangaliyan nan am-in ay tataku un ammay kayu, tay assesa us nan kenarkalen nan kaap-uwancha as nan chiyuycha achi tit-iwa ay pomapadtu.” ");
INSERT INTO ebk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ngem ad wani, ifiakiak kan chakayu ay chuchumngor kan ha-un: Laychunyu nan chiyuycha kafusoryu ya ammay nan atunyu as nan mangiingor kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bendisyonanyu nan chiyuycha mangituchor kan chakayu, ya ekararakianyu nan chiyuycha mamarpalikiat kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mu wachay manepak as tamelmu, ichutngom us nan fisakna. Mu wachay mamelet ay mangara as chaketmu, ichatmu us nan kamisitam. ");
INSERT INTO ebk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ettam nan ngachana ay kumchaw kan he-a. Nan ngachana ay mangara as kuk-uwam, achim fiangchun. ");
INSERT INTO ebk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nan ngachana ay laychum ay atun nan tapina kan he-a, hiyasa us nan atum kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mu laylaychunyu nan chiyuycha yangkiay manglaylayad kan chakayu, ay magun-gunaan kayu? Achi! Tay uray nan fumafiasor at laylaychuncha nan chiyuycha manglaylayad kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mu ekamanyu nan ammay as nan chiyuycha yangkiay mangekaman as ammay kan chakayu, ay magun-gunaan kayu? Achi! Tay assesa us nan atun nan fumafiasor. ");
INSERT INTO ebk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mu nan pafuruchanyu yangkiay at nan chiyuycha ammuyu ay mangifiangadtu as nan finurudcha, ay magun-gunaan kayu? Achi! Tay assesa us nan atun nan chiyuycha fumafiasor ay pafuruchuncha nan kakadwacha ay fumafiasor, tay ammucha ay maifiangadtu challu nan finurudcha. ");
INSERT INTO ebk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ngem fiakun assesa nan atunyu! Kunyu at laylaychun nan kaiingoryu, ya atunyu nan ammay kan chicha. Pafuruchunyu chicha, ya achiyu namnamaun ay ifiangadcha. Mu hiyasa nan atunyu, magun-gunaan kayuntu as ongor, ya chakayuntu nan an-ak nan Kangatuwan ay Dios. Tay hi Apo Dios at manangsug-ang uray as nan chiyuycha achi munyaman ya chiyuycha manangotettet chi ukialicha. ");
INSERT INTO ebk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Masapor manangsug-ang kayu kaman kan Apo Dios ay Amayu ay manangsug-ang.” ");
INSERT INTO ebk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kenalen pay Jesus, “Achiyu okomún nan pachongyu ay taku ta achi chakayuntu okomún kan Apo Dios. Achiyu keddengan ay chusaun nan pachongyu ay taku ta achi chakayuntu keddengan ay chusaun kan Apo Dios. Pomakawan kayu ta pakawanun chakayuntu kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ichatyu nan kasaporan chi iib-ayu, at ichattu Apo Dios nan kasaporanyu. Nan atun Apo Dios ay umichat at iyongoongorna ya ipudpudna inkiana somafi. Tay nan panglukudyu as nan pachongyu ay taku at assesantu us nan panglukud Apo Dios kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Infiakian us Jesus kan chicha nan nauy usa ay maepadpachongan: “Ay mafialin ay epangon nan nafurag nan pachongna ay nafurag? Mu hiyasa, ay kuncha ngun achi mag-astu ay chuwa as nan ngilig? ");
INSERT INTO ebk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maid uswila as nangatngatu mu nan misturuna. Ngem am-in ay uswila ay manglopas as nan chana uswilaun at komaman as nan misturuna.” ");
INSERT INTO ebk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Adchi t'uymu chillawun nan ek-ektel ay futa as nan matan nan ifiam, ya kunmu at achi madlaw nan ad-acha-an ay futa as nan mismu ay matam? ");
INSERT INTO ebk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Winnu anan mangaliyam as nan ifiam un, ‘Ud-a ta kaanok nan futa as matam,’ mu he-a mismu at achim maila nan ad-acha-an ay futa as nan mismu ay matam? He-a ay pakamankaman! Kaanum on-ona nan hana ad-acha-an ay futa as nan mismu ay matam. Angkiay ya makailakantu ay ustu ay mangaan as nan ek-ektel ay futa as nan matan nan ifiam.” ");
INSERT INTO ebk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nun-epadpachong kasin hi Jesus, “Nan narangtu ay kaiw at achi fumkias as mangisiw, winnu nan naiing ay kaiw at achi fumkias as ammay. ");
INSERT INTO ebk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tay nan kaiw at maammuwan babaen as nan fukiasna. Tay nan chugway at achi mapuras as nan uyok, winnu nan ubas as nan lubfian. ");
INSERT INTO ebk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nan ammay ay taku at epafoknagna nan ammay ay naichuchulin as nan numnumna. Assesa us ay nan mangotettet ay taku at epafoknagna nan mangotettet ay naichuchulin as nan numnumna. Tay nan sumubsubra as numnumna at hiyasa challu nan epafoknagna as tapakna.” ");
INSERT INTO ebk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kenalen pay Jesus, “Adchi t'uyyu kanan kan ha-un un, ‘Apo, Apo,’ ya achiyu challu atun nan ifiakiak? ");
INSERT INTO ebk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nan ngachana ay taku ay omali kan ha-un ya manngor as nan nauycha kalek ya atuna chaná ");
INSERT INTO ebk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","at ifiakiak nan nauy maepachongana: Maepachong hiya as nan taku ay cha munkiaub as afong. Kenaufiana nan luta inkiana ininchanancha nan chupras ad chur-um, ya tinuudna nan pusten nan afong. Kun pay enmali nan ongor ay chanum, chinaraposna nan hana ay afong, ngem chaan poros nunwawud, tay naekanag ay nakiaub. ");
INSERT INTO ebk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ngem nan chiyuy taku ay manngor as nan nauycha kalek ya achina challu atun chaná at maepachong as nan taku ay nunkiaub as afong as nan luta ay chaan nangekaub as pusten nan afongna. Kun pay enmali nan ongor ay chanum, chinaraposna nan hana afong, at nunkatutu-ug ya nunsidlay enatna ay nachachael.” ");
INSERT INTO ebk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kun pay narpas ay infiakian Jesus chaná am-in as nan tataku, inmuy ad Capernaum. ");
INSERT INTO ebk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wacha hid-i nan usa ay kapetan chi sosorchachu ay Romano ay wachay fiabfiaaruna ay laylaychuna as solet. Nan fiabfiaaruna ay anna at cha munsaket, ya kiayud matuy. ");
INSERT INTO ebk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kun pay chinngor nan kapetan nan maepangkep kan Jesus, infiaorna nan tapen nan anam-amán chi Judio ay uy mangayag kan Jesus ta epaammayna nan fiabfiaarun nan kapetan ay anna. ");
INSERT INTO ebk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kuncha pay inmuy kan Jesus, nunpakpakaasicha kan hiya. Kenalicha, “Nan nauy ay kapetan at maekari ay fiadgam, ");
INSERT INTO ebk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tay laylaychuna chitaku ay Judio, ya hiya nan nangepaamma as nan senagoga takú.” ");
INSERT INTO ebk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Angkiay ya nakiuy hi Jesus kan chicha. Kuncha pay kiayud umchan as nan afong, infiaor nan kapetan nan kiakiayyumna ay uy mangifiakia kan Jesus, “Apo, achika cha munforforay ay omali as afongku, tay achiyak maekari ay mangepaskop kan he-a. ");
INSERT INTO ebk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Isunga achiyak maekari ay omali kan he-a. Ommat nan kalem yangkiay as mangepaammay as nan fiabfiaarok. ");
INSERT INTO ebk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tay uray ha-un at wacha nan mangetoray kan ha-un, ya wachacha us nan sosorchachok ay etorayak. Mu kanak as nan usa un, ‘Uyka’ at umuy hiya. Mu kanak us as nan usa un, ‘Aka’ at omali hiya. Mu kanak us as nan fiabfiaarok un, ‘Atum na’ at atuna.” ");
INSERT INTO ebk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kun pay chinngor Jesus na, naschaaw hiya, ya nunsakong as nan ongor ay tataku ay cha umun-unud kan hiya, ya kanana, “Ifiakiak kan chakayu ay maid poros naanapak as assena ay pammati uray ad Israel.” ");
INSERT INTO ebk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nunfiangad nan chiyuycha infiaor nan kapetan, at ininchanancha ay enmammay at nan fiabfiaaruna. ");
INSERT INTO ebk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Naaw-awni as akét, inmuy hi Jesus henan usa ay ili ay makali un Nain. Nakiuy kan hiya nan disipulusna ya nan ongoongor ay tataku. ");
INSERT INTO ebk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kun pay cha maesnop cha Jesus as nan sungkopan henan ili, sinib-atcha nan ongor ay uy mangilfun as nan laraki ay us-usa ay anak nan ellakas. Nakitutun-ud as nan ellakas nan ongoongor ay tataku ay nurpu henan hana ay ili. ");
INSERT INTO ebk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kun pay inilan Jesus nan ellakas, ongor chi sug-angna. Kenalina, “Achika mun-akor.” ");
INSERT INTO ebk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Angkiay ya naesnop hi Jesus ya kenpana nan longon. Angkiay inkinak nan chiyuycha nangiyaattang. Kenalen Jesus, “Anakku, kanak kan he-a un fumangunka.” ");
INSERT INTO ebk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tenmokor tit-iwa nan natuy ay laraki, ya enlapuna ay nunkali. Haat ichat Jesus hiya kan enana. ");
INSERT INTO ebk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Inmugyat nan am-in ay tataku, at chinaychayawcha hi Apo Dios ay chacha kankanan, “Nunpaila kan chitaku nan usa ay mannakafialin ay pomapadtu,” ya “Enmali hi Apo Dios ay mangesarakan as nan tatakuna.” ");
INSERT INTO ebk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nunchinamag nan nauy maepangkep kan Jesus henan intiru ay Judea ya henan am-in ay lukiar ay nangliliwus henan ili ay anna. ");
INSERT INTO ebk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nan disipulus Juan at uycha infiakia kan Juan ay naifiafiarud as nan hiyachi nan nauycha am-in ay enom-ommat. ");
INSERT INTO ebk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kun pay chinngor Juan chasa, enayakiana nan chuwa as nan disipulusna, ya infiaorna chicha ay uy manarudsud as nan Apo, “Ay he-a nan enkaren Apo Dios ay omalintu, winnu munsuud kami as tukún?” ");
INSERT INTO ebk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kuncha pay inmuy kan Jesus, kenalicha, “Hi Juan ay Fumufunyag at infiaor chakami ay manarudsud un, ‘Ay he-a nan enkaren Apo Dios ay omali, winnu munsuud kami as tukún?’ ” ");
INSERT INTO ebk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","As nan hiyachi ay uras, ongor nan enpaammay Jesus ay munsaket as tukutukún ay saksaket. Enpafoknagna nan anennet, ya nan nunkafurag at makailacha. ");
INSERT INTO ebk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tinumfor hi Jesus as nan chiyuycha infiaor Juan, “Munfiangad kayu kan Juan, ya ifiakiayu kan hiya nan nauycha inilayu ya chinngoryu: Nan chiyuycha nafurag at makailacha, nan chiyuycha napilud at makacharancha, nan chiyuycha nakonet at enmammaycha, nan chiyuycha nalurak at makadngorcha, nan chiyuycha natuy at natakucha, ya nan chiyuycha pugli at naekasaba kan chicha nan Ammay ay Chamag. ");
INSERT INTO ebk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nakiasat nan taku ay achi munchuwachuwa as nan maepangkep kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kun pay nak-ak nan chiyuycha infiaor Juan, infiakian Jesus nan maepangkep kan Juan as nan ongoongor ay tataku, “As nan enayanyu kan Juan henan disyerto, ngachana nan nenamnamayu ay ilaun koma? Ay usa ay taku ay maepachong as nan tufú ay cha ikiwkiwen chi angin? ");
INSERT INTO ebk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngachana ngarud nan enay-ayanyu hid-i ay ilaun? Ay usa ay taku ay nunfiafiachu as am-ammay? Nan chiyuycha met munfiafiachu as nangina ya nanam-ay chi fiyagcha at mamagyancha as nan chiyuycha palasyu. ");
INSERT INTO ebk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ngachana ngay ngarud nan enay-ayanyu hid-i? Ay uyyu inila nan usa ay pomapadtu? O, ifiakiak kan chakayu, inilayu nan am-amud mu nan pomapadtu. ");
INSERT INTO ebk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tay hi Juan nan naifiakia as nan Kalen Apo Dios ay kanana un, ‘Wacha nan ifiaorku ay mangon-ona mu he-a ay mangesakiana as nan ayum.’ ");
INSERT INTO ebk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ifiakiak kan chakayu ay as nan am-in ay naiyanak at maid am-amud mu hi Juan. Ngem nan kaapuchan as nan muntorayan Apo Dios at am-amud mu hi Juan.” ");
INSERT INTO ebk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kun pay chinngor nan am-in ay tataku patí nan chiyuycha mangam-among as fiaror nan nauy kenalen Jesus, enafurotcha nan nalintig ay pangkep Apo Dios kan chicha, ya nunpafunyagcha kan Juan. ");
INSERT INTO ebk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ngem nan chiyuycha Fariseo ya nan mun-isursuru as Lintig at enachicha nan pangkep Apo Dios kan chicha, tay chaancha nunpafunyag kan Juan. ");
INSERT INTO ebk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kenalen pay Jesus, “Anan mangepachongak ngun kan chatona ay tataku ad wani, ya anan kaassenacha? ");
INSERT INTO ebk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Maepachongcha as nan ongong-a ay nangatokor as nan lenawwag ay cha munfifinnukiaw ay cha mangarkali un, ‘Nun-epeep kami, ya chaan kayu nunsasara. Nunkanta kami as omepanguyus, ya chaan kayu nun-akor.’ ");
INSERT INTO ebk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tay enmali hi Juan ay Fumufunyag ay cha mun-ay-ayunar ya achi umig-ikop as fiayas, ya kananyu un, ‘Naanennetan hiya!’ ");
INSERT INTO ebk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kun pay enmali nan Naepadtu ay Anak chi Taku ay cha makekkekan ya cha makiig-ikop, kananyu un, ‘Ilaunyu kay na ay taku at kun naranok ya futtang. Hiya us at kiayyum nan chiyuycha mangam-among as fiaror ya nan tapina ay fumafiasor.’ ");
INSERT INTO ebk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Uray mu hiyasa, maepaila challu ay ustu nan kenasilib Apo Dios as nan am-in ay tatakuna.” ");
INSERT INTO ebk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wacha nan usa ay Fariseo ay nangayag kan Jesus ta uy makekan kan hiya. Isunga inmuy hi Jesus as afongna, ya nakiufong hiya as nan Fariseo ay ansa. ");
INSERT INTO ebk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Henan hana ay ili, wacha nan usa ay fiafiai ay fumafiasor. Kuna pay nachamag ay cha makekan hi Jesus as afong nan Fariseo, inyuyna nan mangit-ittuwan ay naamma as fiatu ay nan ngachana at alabastro ay nanapnu as munfiangu ay lana. ");
INSERT INTO ebk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tenmakchug nan hana ay fiafiai ay cha mun-ag-akor as likud Jesus as nan sag-un nan sukina. Nan chiyuycha luwana at tinmidtidcha as nan suken Jesus. Angkiay ya pinunasana as nan fookna. Finisituna nan suken Jesus, ya fenokfokana as fiangfiangru. ");
INSERT INTO ebk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kun pay inilan nan Fariseo ay nangayag kan Jesus nan hana naekaman, kenalina as numnumna, “Mu tit-iwa ay pomapadtuna ay taku, aammuna koma nan katatakon tona ay fiafiai ay cha mangmangpa kan hiya. Aammuna us koma ay hi tona at fumafiasor.” ");
INSERT INTO ebk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Angkiay kenalen Jesus as nan Fariseo, “Simon, wacha nan ifiakiak kan he-a.” “O, Misturu, ngachan tud-i?” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kenalen Jesus, “Wachacha nan chuwa ay inmutang as nan usa ay munpappautang as siping. Inmutang nan usa as leman kiasot ay dinario,kun pay nan usa at leman puru. ");
INSERT INTO ebk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kiapú ta achicha makafiayad, penakawan nan nunpautang chicha ay chuwa. Ad wani, ngachana pay kan chicha nan ong-ongor nan layadna as nan nunpautang?” ");
INSERT INTO ebk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tinumfor hi Simon, “Uy at nan chiyuy ong-ongor nan utangna ay.” Kenalen Jesus kan hiya, “Ustu nan hana kenalem.” ");
INSERT INTO ebk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Angkiay ya nunsakong as nan fiafiai, ya kanana kan Simon, “Ilaum nan nauy fiafiai. Sinungkopak asna's afongmu, ya maid inchatmu as chanum ay mangurasku as sukek. Ngem hiya at enlasana nan sukek as luwana ya pinunasana as fookna. ");
INSERT INTO ebk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","As nan sinungkopak, chaanak met finisitu kan he-a ay kaman as nan iniili ay ukiali takú. Ngem hiya at chaana inkinkinak ay namisfisitu as nan sukek nunlapu as nan sinungkopak. ");
INSERT INTO ebk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Chaanmu lenanaan nan urok, ngem hiya at fenokfokana nan sukek as fiangfiangru. ");
INSERT INTO ebk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Isunga ifiakiak kan he-a ay kiapú as nan ongor ay layadna kan ha-un, hiyana nan mangepaila ay napakawan hiya as nan ongor ay fiasfiasorna. Ngem nan taku ay akét chi napakawan ay fiasfiasorna at akét nan layadna ay epailana.” ");
INSERT INTO ebk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kenalen Jesus as nan fiafiai, “Napakawanka as nan fiasfiasormu.” ");
INSERT INTO ebk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Angkiay ya nan kakadwana ay nakekan at enlapucha ay mangali as numnumcha, “Ngachan man tona ay mamakawan as tataku as nan fiasfiasorcha?” ");
INSERT INTO ebk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ngem kenalen Jesus as nan fiafiai, “Nan pammatem nan nangesarakan kan he-a. Uyka ay kun natalna nan numnummu.” ");
INSERT INTO ebk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kun pay chaan nafiayag, inmuy hi Jesus henan il-ili ya fiabfiabruy ay cha mangekaskasaba as nan Ammay ay Chamag maepangkep as nan muntorayan Apo Dios. Nakiuy kan hiya nan hinpuru ya chuwa ay disipulusna ");
INSERT INTO ebk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ya nan tapen us nan fianafiai ay nakaanan nan chiyuycha anennet ya saksaket. Chicha cha Maria ay makali un Magdalena ay naepafoknakian chi pitu ay anennet, ");
INSERT INTO ebk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","hi Juana ay asawan Cusa ay opisyar Ari Herodes, hi Susana, ya ongor pay ay tapina ay fianafiai ay inmid-ichat as kasaporan cha Jesus babaen as nan kafiaelancha ay ichat. ");
INSERT INTO ebk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cha omali-ali nan ongoongor ay tataku ay nurpu henan tukutukún ay il-ili. Kuncha pay naamong as nan kawad-an Jesus, infiakian Jesus na ay maepadpachongan: ");
INSERT INTO ebk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wacha nan usa ay taku ay uy nun-iwagwag as fokel as nan umana. As nan chana mun-iwagwagwakian, nag-as nan tapen nan fokel as nan charan. Naikiatincha, ya kenan chi kossel. ");
INSERT INTO ebk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nan tapina at nag-ascha as nan machupras ay lukiar. Kuncha pay cha tomemel, naklingcha at, tay maid chanum nan naetanmancha. ");
INSERT INTO ebk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nan tapina at nag-ascha as nan kaongoran chi sufet. Naikisancha ay tinmufu as nan ongor ay sufet, at nasulincha. ");
INSERT INTO ebk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nan tapina at nag-ascha as nan ammay ay luta. Tinmufucha ya finumkiascha as mahinkiagsot.” Inyanongos Jesus, “Nan wachay ingana ay chumngor at masapor chumngor.” ");
INSERT INTO ebk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Senarudsud nan disipulus Jesus kan hiya mu ngachana nan laychun ay kanan nan chiyuy maepadpachongan. ");
INSERT INTO ebk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tinumfor hi Jesus, “Kan chakayu nan naepakaammuwan nan chaan naam-ammuwan maepangkep as nan muntorayan Apo Dios. Ngem as nan tapina, maifiakia kan chicha babaen yangkiay as nan mangosaran as maepadpachongan ta uray mu iilauncha, achicha ematonan. Uray mu chungruchungruncha at achicha challu maawatan.” ");
INSERT INTO ebk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nauy nan laychun ay kanan nan maepadpachongan: Nan fokel at hiyana nan Kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nan chiyuycha nag-as as nan charan at maepachongcha as nan tataku ay nanngor as nan Kalen Apo Dios, ngem umuy hi Satanas, ya kaanuna nan hana kali as numnumcha ta achicha omafurot ya maesarakan. ");
INSERT INTO ebk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nan chiyuycha naiwagwag as nan chiyuycha machupras ay lukiar at maepachongcha as nan tataku ay naragsak ay mang-awat as nan kalen Apo Dios as nan manngorancha. Ngem kiapú ta achicha lomamot ay ustu as numnumcha, hen-omaketan yangkiay nan omafurotancha. As nan timpu ay umchanan chi sulisug kan chicha, achicha at ituruy ay omafurot. ");
INSERT INTO ebk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kun pay nan chiyuycha nag-as as nan tinmufuwan chi ongor ay sufet at maepachongcha as nan tataku ay manngor as nan kalen Apo Dios. Ngem kun pay naaw-awni, nan chanchanagcha, kenafiaknangcha ya lagragsakcha as nan nauy ay fiyag at sulinuncha nan chinngorcha, at achicha maonngan as nan pammaticha. ");
INSERT INTO ebk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kun pay nan chiyuycha naiwagwag as nan ammay ay luta at maepachongcha as nan tataku ay manngor as nan kalen Apo Dios, ya ittucha as nan ammay ya napudnu ay numnumcha. Mun-an-anoscha inkiana fumkiascha.” ");
INSERT INTO ebk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kenalen pay Jesus, “Maid taku ay mamaskud as pingki ya op-opana as fianga winnu ipuuyna as nan selok chi kama. Kuna at epatang as nan maepatpatngana ta mailan nan chiyuycha sungkop nan silawna. ");
INSERT INTO ebk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tay maid naetatafun as achintu maepaila, winnu uray ngachana ay chaan naam-ammuwan as achintu maammuwan ya maepaila. ");
INSERT INTO ebk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Il-ilaunyu ngarud nan atunyu ay chumngor, tay nan taku ay wachay kafiaelana at maettan as ong-ongor. Nan taku ay maid kafiaelana at uray nan ak-akettuy ay wacha kan hiya at maarantu.” ");
INSERT INTO ebk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Inmuy kan Jesus hi enana ya nan susnúdna ay lanaraki, ngem maid atuncha ay maesnop kan hiya kiapú as nan kenaongor chi tataku. ");
INSERT INTO ebk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wacha nan nangifiakia kan Jesus, “Wacha hi enam ya nan susnúdmu ay lanaraki ay nangatakchug as nan fiattaw, ya laychun chaká ay ilaun.” ");
INSERT INTO ebk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ngem kenalen Jesus kan chicha, “Nan enak ya nan susnúdku at nan chiyuycha chumngor ya mangekaman as nan kalen Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","As nan hin-urkiw, nunlukian hi Jesus as nan fiangka ay kadwana nan disipulusna. Kenalen Jesus kan chicha, “Kumchang takú henan fiayfiay ta uy takú ad chumang.” Isunga nunligwatcha ay nunlukian as nan fiangka. ");
INSERT INTO ebk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","As nan chacha kumchangan, nassuy hi Jesus. Kalina at ya mun-atifudfud chi puwak henan fiayfiay. Cha matorwan as chanum nan fiangka ay nunlurukianancha, at kiayudcha lumnud. ");
INSERT INTO ebk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Uycha finangun hi Jesus, ya kanancha, “Apo, Apo, lumnud takú pay!” Finmangun hi Jesus, ya finilina nan puwak ya nan napigsa ay challuyon. Nakianninakcha, at ammay kasin. ");
INSERT INTO ebk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kenalen Jesus kan chicha, “Ay chaud payat nan pammatiyu?” Ngem inmugyatcha ya naschaawcha ay nunsesennarudsud, “Ngachan ngun tona ay mamilin as uray angin ya chanum, at tomongparcha?” ");
INSERT INTO ebk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Inturuycha Jesus ay kinumchang inkiana inumchan henan sasakopun nan chiyuycha i-Gerasa ay chuchumangun nan Galilea. ");
INSERT INTO ebk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kuncha pay inumchan ya pinmitiw hi Jesus as nan papor, sinib-atna nan laraki ay naanennetan ay nurpu henan hana ay ili. Nafiayag ay chaan nunfiadfiachu hiya ya chaan us nanagyan as afongna, ngem kun at as nan lurubfok. ");
INSERT INTO ebk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kuna pay inila hi Jesus, nun-uwek ya nunlukfub as nan sangwanan Jesus, ya inpigsana ay nangifukiaw, “Jesus ay Anak nan Kangatuwan ay Dios, ngachana nan laychum ay atun kan ha-un? Esapatam ay achiyak palikiatun.” ");
INSERT INTO ebk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kenalina na, tay finilin Jesus nan anennet ay fomoknag as nan laraki. Namen ongor ay penalikiat nan anennet nan laraki, ya uray naepokok ya nakor-ongan nan lima ya sukina, ngem senokpotna challu nan kor-ong ya enpatagtag nan anennet hiya ay umuy henan disyerto. ");
INSERT INTO ebk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Senarudsud Jesus kan hiya, “Anan ngachanmu man?” “Liniblifu,” ensongfiatna, tay ongoongorcha nan anennet ay sinungkop kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nunpakpakaasi nan chiyuycha anennet kan Jesus ta achina filinun chicha ay umuy henan lukiar ay kaman fitu ay maid papugna. ");
INSERT INTO ebk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","As nan naesasag-un, wachachay ongoongor ay fiafuy ay cha munsuksukor henan filig. Nunpakpakaasi nan chiyuycha anennet kan Jesus ta sungkopcha as nan chiyuycha fiafuy. Isunga penarufusan Jesus chicha. ");
INSERT INTO ebk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Fenmoknagcha tit-iwa nan chiyuycha anennet as nan laraki, ya sinungkopcha as nan chiyuycha fiafuy. Angkiay ya kenamon nan chiyuycha fiafuy ay chinmayyu inkiana nag-ascha henan teng-el, at nurningcha henan fiayfiay. ");
INSERT INTO ebk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kun pay inilan nan chiyuycha mun-ay-aywan as nan chiyuycha fiafuy nan enommat, tenmagtagcha ay uy nangepachamag as nan tataku henan ili ya sigsikib. ");
INSERT INTO ebk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Angkiay ya inmuycha nan tataku ay uy mangila as nan enommat. Kuncha pay inumchan as nan kawad-an cha Jesus, inilacha nan laraki ay fenmoknakian nan chiyuycha anennet. Nangatokor hiya as nan sag-un nan suken Jesus. Nangafiachu ya ammay at chi numnumna. As nan hiyachi, inmugyatcha am-in as solet. ");
INSERT INTO ebk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nan chiyuycha nangila at infiakiacha as nan tataku nan enat nan laraki ay enmammay. ");
INSERT INTO ebk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kiapú as nan nunsidla ay ugyat nan am-in ay i-Gerasa, chinawatcha kan Jesus ay mak-ak hiya hid-i. Isunga nunlukian hi Jesus as nan fiangka ya nak-ak. ");
INSERT INTO ebk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","As nan hiyachi, nunpakpakaasi kan Jesus nan laraki ay fenmoknakian nan anennet ta makiuy koma kan hiya. Ngem enpakatam Jesus hiya. Kenalina, ");
INSERT INTO ebk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Komatamka at man, ya uymu ifiagfiakia nan enat Apo Dios kan he-a.” Kenmatam tit-iwa ya uyna ifiakia as nan am-in ay kakailiyana nan enat Jesus kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kun pay nunfiangad hi Jesus ad chumang, naragsak nan tataku ay nangayag kan hiya, tay hiya nan sasad-uncha. ");
INSERT INTO ebk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Angkiay ya enmali nan usa ay laraki ay nan ngachana at Jairo ay usa ay ap-apu as nan senagoga. Nunlukfub hiya as nan sangwanan Jesus, ya nunpakpakaasi kan hiya ta makiuy as afongna, ");
INSERT INTO ebk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tay kiayud matuy nan us-usa ay anakna ay fiafiai ay hinpuru ya chuwa nan tawwuna. Kun pay cha umuy hi Jesus, somaliyubyub chi tataku ay makitun-ud kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wacha hid-i nan usa ay fiafiai kan chicha ay cha mun-ichaichara as hinpuru ya chuwa ay tawwun. Kinastosna am-in nan sipingna ay namayadna as mangakias kan hiya, ngem maid nakaakias kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Naesnop as uchug Jesus ya kenpana nan kiayachan nan fiachona. Hiya at chi ya nakyat nan cha fomokfoknag kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Senarudsud Jesus, “Ngachana nan nangpa kan ha-un?” Kuncha pay am-in ensaot, kenalen Pedro, “Apo, kuncha ongor chi tataku ay somaliyubyub kan he-a ya.” ");
INSERT INTO ebk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngem kenalen Jesus, “Ammok ay wacha nan nangpa kan ha-un, tay keneknak ay wachay pannakafialin ay nak-ak kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kun pay achi maesaot nan fiafiai, cha munpapayagpag ay enmali kan Jesus ya nunlukfub as nan sangwanana. As nan sangwanan nan am-in ay tataku, infiakiana mu adchi t'uyna kenpa hi Jesus ya anan enatna ay enmammay. ");
INSERT INTO ebk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kenalen Jesus kan hiya, “Ammi, nan pammatem nan nangepaammay kan he-a. Uyka ay kun natalna nan numnummu.” ");
INSERT INTO ebk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","As nan cha munkarkaliyan Jesus, enmali nan usa ay laraki ay naifiaor ay nurpu as afong Jairo, ya kanana kan Jairo, “Natuy at nan pototmu ay fiafiai. Achim lilifokun nan misturu.” ");
INSERT INTO ebk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ngem as nan nanngoran Jesus as sa, kenalina kan Jairo, “Achika umugyat. Omafurotka yangkiay, at omammay nan pototmu.” ");
INSERT INTO ebk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kun pay inumchan hi Jesus as afong Jairo, maid tukún as enpaskopna mu achi yangkiay cha Pedro, Juan, Santiago, ya nan ama ya enan nan onga. ");
INSERT INTO ebk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Am-in nan tataku hid-i at chacha mun-ag-akor ya munngunguyus. Ngem kenalen Jesus kan chicha, “Achi kayu cha mun-ag-akor, tay chaan natuy hiya, ngem kun nanassuy.” ");
INSERT INTO ebk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kuncha at enam-amrang hiya, tay nan ammucha at natuy nan onga. ");
INSERT INTO ebk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ngem inunnan Jesus nan liman nan onga, ya kanana kan hiya, “Anakku, fumangunka.” ");
INSERT INTO ebk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nataku kasin nan onga ya nafiannangun hiya. Angkiay ya infilin Jesus ay umichatcha kan hiya as kanuna. ");
INSERT INTO ebk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naschaawcha nan chanakchakor nan onga, ngem infilin Jesus kan chicha ay maid poros mangifiagfiag-ancha as nan enommat. ");
INSERT INTO ebk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Enamong Jesus nan hinpuru ya chuwa ay disipulusna kan hiya, ya inchatnay pannakafialin ya kalibfengan kan chicha ay mangepak-ak as am-in ay anennet ya mangaan as saksaket. ");
INSERT INTO ebk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Angkiay ya infiaorna chicha ay mangekasaba as nan maepangkep as nan muntorayan Apo Dios ya mangepaammay as nan tataku ay munsaket. ");
INSERT INTO ebk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kenalina kan chicha, “Maid etakinyu as nan munfiaatanyu. Achi kayu ometakin as uray surkud, samfiag, makan winnu siping ya uray munsokatanyu. ");
INSERT INTO ebk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","As nan uray ngachana ay afong ay sungkopanyu, hid-i nan magyananyu inkiana mak-ak kayu hid-i ay ili. ");
INSERT INTO ebk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Henan ngachana ay ili ay umuyanyu ay maid poros mangmangili kan chakayu, mak-ak kayu hid-i ay ili. As nan mak-akanyu, pokpokanyunan tapok as nan chapanyu ay mangepaila ay maid fiyangyu kan chicha as nan manusaan Apo Dios kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Angkiay ya inligwatcha ya inmuycha henan fiabfiabruy. Enkaskasabacha nan Ammay ay Chamag ya enpappaammaycha nan chiyuycha munsaket henan am-in ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kun pay nachamag Herodes ay gobernador ad Galilea nan am-in ay enkamkaman Jesus, nalilifokan hiya, tay kenalen nan tapina ay tataku un nataku manipud as nan utúy hi Juan ay Fumufunyag. ");
INSERT INTO ebk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nan tapina at kenalicha un nunpaila hi Elias, ya nan tapina us at kenalicha un hiya nan usa as nan chiyuycha pomapadtu ad pus-uy ay nataku manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kenalen Herodes, “Kunku cha enpasiwat nan uron Juan ya, ngem ngachan ngun tona ay taku nan chacha kankanan?” Nunlapu as nan hiyachi, lenayadna as solet ay mangila kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","As nan nunfiangchan nan hinpuru ya chuwa ay apostoles, infiakiacha kan Jesus nan am-in ay en-enatcha. Angkiay ya entakin Jesus chicha, ya inmuycha ay chidchicha yangkiay henan ili ay makali un Betsaida. ");
INSERT INTO ebk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kun pay naammuwan nan ongoongor ay tataku, inunudcha hiya. Enayakian Jesus nan nauycha tataku, ya infiakiana kan chicha nan maepangkep as nan muntorayan Apo Dios. Angkiay enpaammayna nan chiyuycha munsaket. ");
INSERT INTO ebk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kun pay cha maschum, enmali nan hinpuru ya chuwa ay disipulus kan Jesus, ya kanancha, “Nauy takú henan kamaid chi umili, epakatammu nan ongoongor ay tataku ta umuycha henan naesasag-un ay fiabfiabruy ya sigsikib ay mun-anap as kanuncha ya massuyancha.” ");
INSERT INTO ebk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngem kenalen Jesus kan chicha, “Chakayu mismu nan mangichat as kanuncha.” “Lema met yangkiay ay tenapay ya chuwa ay filis nan wacha kan chakami sukúd kami a uy lomaku as kanun nan nauycha am-in ay tataku,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kenalicha chi, tay nan filang nan lanaraki yangkiay at kiayud umuy as leman lifu. Kenalen Jesus as nan disipulusna, “Patokorunyu chicha ay maam-among as henlelman pupuru.” ");
INSERT INTO ebk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Enatcha tit-iwa, at enpatokorcha nan am-in ay tataku. ");
INSERT INTO ebk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","As nan hiyachi enaran Jesus nan lema ay tenapay ya nan chuwa ay filis, ya nuntangad hiya ad chaya ay munyaman kan Apo Dios. Kun pay narpas, pinutput-ingna chachi, ya inchatna as nan disipulusna, ya nan disipulusna at inwarascha as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nangan am-in nan tataku, at nasufucha. Haat amongun nan disipulus nan chinaancha ay namnu as nan hinpuru ya chuwa ay uppig. ");
INSERT INTO ebk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","As nan namingsan ay naaangkiayan Jesus ay cha munkararag, naesnop nan disipulus kan hiya. Angkiay senarudsudna kan chicha, “Ngachana nan kanan nan tataku maepangkep kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tinumforcha, “Kanan met nan tapina un he-a hi Juan ay Fumufunyag, ya kanan nan tapina un he-a hi Elias. Wacha pay nan mangali un usaka as nan chiyuycha pomapadtu ad pus-uy ay nataku manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Senarudsud Jesus kan chicha, “Ngem chakayu ngay? Ngachana nan kananyu maepangkep kan ha-un?” Tinumfor hi Pedro, “He-a nan Cristo ay pinilen Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Angkiay infilin Jesus ay ustu kan chicha ay maid poros mangifiagfiag-ancha as na. ");
INSERT INTO ebk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kenalina, “Nan Naepadtu ay Anak chi Taku at masapor mun-iliwas as ongor ay likiat. Achintu laychun nan anam-amá, anap-apon chi papachi, ya nan chiyuycha mun-isursuru as Lintig. Maepapatuytu hiya, ngem as nan maekatlu ay urkiw at mataku manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Angkiay kenalen Jesus as nan am-in, “Mu ngachana nan manglayad ay umunud kan ha-un at masapor ikinakna ay mangekaman as nan laylaychuna, ya itiina nan korosna as inurkiw, haat umunud kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tay nan uray ngachana ay mangepapati ay mangesarakan as fiyagna asna's luta at malitawnantu challu. Ngem nan uray ngachana ay manglitaw as fiyagna asna's luta kiapú as pammatina kan ha-un at maesarakantu. ");
INSERT INTO ebk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tay anan maaran nan taku ay mangkuwa as nan am-in ay wacha asna's luta, ngem malitaw winnu machachael challu hiya? ");
INSERT INTO ebk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tay nan ngachana ay mangifiain kan ha-un ya nan karkalek at ifiaintu us nan Naepadtu ay Anak chi Taku hiya as nan omaliyana kasin ay mangepaila as nan kaichayawana ya nan kaichayawan nan Ama ya nan nasantowan ay anghelesna. ");
INSERT INTO ebk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ifiakiak kan chakayu nan tit-iwa ay wachacha nan tapina kan chakayu ay nangatakchug hena ay achintu matuy inkiana ilauncha nan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kun pay kiayud waru ay urkiw as nan nangifiag-an Jesus as nan nauycha, entakin Jesus cha Pedro, Juan ya Santiago henan chuntug ta uycha munkararag. ");
INSERT INTO ebk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","As nan cha munkararakian Jesus, tinmukun chi kail-an chi lupana, ya nan fiachuna at pinmukpukkawan ya kun sumili. ");
INSERT INTO ebk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kalina at ya nunpaila nan sumili ay chuwa ay lanaraki ay cha maketagtakiatfor kan hiya ay cha Moises kan Elias. Chacha apatun nan kiayud mangtongparan Jesus as nan pangkep Apo Dios kan hiya ay hiyachi nan uyna matuyan ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","As nan hiyachi, naimugmug hi Pedro ya nan iib-ana, ngem kuncha pay finmangun, inilacha nan kaichayawan Jesus ya nan chuwa ay lanaraki ay naketatakchug kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kun pay cha mak-ak nan chuwa ay lanaraki as nan kawad-an Jesus, kenalen Pedro kan Jesus, “Apo, ammay paat ta wacha takú hena. Kun kami at mun-amma as turu ay fiawi, usa kan he-a, usa kan Moises ya usa kan Elias.” Kenalina chi, tay achina ammu nan chana kankanan. ");
INSERT INTO ebk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kun pay cha munkarkali hi Pedro, wacha nan lifuu ay nangalenong kan chicha, at inmugyatcha as solet ay cha maabfongan as lifuu. ");
INSERT INTO ebk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wacha us nan kali ay nurpu as nan lifuu ay kanana, “Hi tona nan Anakku ay pinilek. Chumngor kayu kan hiya!” ");
INSERT INTO ebk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kun pay kinminak nan cha munkali, inilacha ay nauusa hi Jesus. Kuncha kinkinak nan disipulusna, ya as nan hiyachi ay timpu, maid nangifiagfiag-ancha as nan inilacha. ");
INSERT INTO ebk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","As nan kafikiatana, chinmayyu cha Jesus ay nurpu henan chuntug, ya ongor nan tataku ay nanib-at kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kalina at ya infukiaw nan usa ay laraki ay naetatapi as nan tataku, “Misturu, ilaum man paat nan pototku ay laraki, tay kun us-usa ay pototku. ");
INSERT INTO ebk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tay as nan umchaan nan anennet kan hiya, kalina at ya cha lawá munfugfukiaw ya cha munkorchas hiya inkiana umusab nan tapakna. Paliwasana hiya as solet ya achina laychun ay taynan. ");
INSERT INTO ebk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nunpakpakaasiyak as nan nauycha disipulusmu ay epafoknagcha nan anennet, ngem achicha kafiaelan.” ");
INSERT INTO ebk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tinumfor hi Jesus, “Nakkuran kayu ay tataku ad wani! Maid tit-iwa pammatiyu ya nunkasokel kayu! Anan kafiayag chi mawawad-ak ya tata-unku kan chakayu? Iyalem man hena nan pototmu.” ");
INSERT INTO ebk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kun pay cha maesnop nan onga kan Jesus, inturchun nan anennet hiya as nan luta ya nunkorchasuna. Ngem finilin Jesus nan anennet ay fomoknag, at enmammay nan onga. Angkiay ya inpurangna nan onga as nan amana. ");
INSERT INTO ebk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Am-in nan tataku at naschaawcha as nan inilacha ay pannakafialin Apo Dios. Kun pay cha masmaschaaw nan tataku as nan am-in ay enat Jesus, kenalina as nan disipulusna, ");
INSERT INTO ebk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Achiyu liwliw-an nan nauy ifiakiak kan chakayu: Nan Naepadtu ay Anak chi Taku at maipurangtu as nan tataku.” ");
INSERT INTO ebk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ngem chaancha naawatan nan nauy infiakiana, tay naililingub kan chicha ta achicha maawatan, ya umugyatcha ay manarudsud kan hiya as nan maepangkep as nan nauy infiakiana. ");
INSERT INTO ebk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wacha nan nunlapu ay susuma as nan disipulus Jesus mu ngachana kan chicha nan kaamuchan. ");
INSERT INTO ebk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ngem kiapú ta aammon Jesus nan chacha numnumnumun, enayakiana nan usa ay onga ya enpatakchugna as nan sag-una. ");
INSERT INTO ebk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kenalina kan chicha, “Nan uray ngachana ay mang-awat kan tona ay onga kiapú as pammatina kan ha-un at ha-un nan awatuna. Nan uray ngachana ay mang-awat kan ha-un at awatuna nan nangifiaor kan ha-un. Tay nan taku ay kaapuchan kan chakayu am-in at hiya nan kaamuchan.” ");
INSERT INTO ebk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tinumfor hi Juan, “Apo, inilami nan usa ay taku ay cha mangosar as ngachanmu ay mangepafoknag as nan chiyuycha anennet. Enpawami, tay fiakun takú met kadwa hiya.” ");
INSERT INTO ebk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngem kenalen Jesus kan Juan ya as nan tapen nan disipulusna, “Achiyu epawa, tay nan taku ay achi komontra kan chakayu at kadwayu.” ");
INSERT INTO ebk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kun pay kiayud umchan nan timpu ay maetag-uyan Jesus ad chaya, epapatina ay umuy ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Isunga enpaon-onana nan tapen nan tataku henan usa ay fiabruy nan i-Samaria ta chacha esakiana nan munchawsana. ");
INSERT INTO ebk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ngem chaan lenayad nan umiili hid-i ay chumawus hi Jesus as kawad-ancha, tay aammucha ay ad Jerusalem nan ay-ayana. ");
INSERT INTO ebk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kun pay inilan cha Santiago kan Juan ay disipulusna nan enat nan i-Samaria, kenalicha kan Jesus, “Apo, ay laychum ay ayakianmi nan apuy ay murpu ad chaya ay komsop ay mamuor kan chicha?” ");
INSERT INTO ebk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ngem nunsakong hi Jesus ya senengarana chicha. ");
INSERT INTO ebk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Angkiay ya inmuycha henan tukún ay fiabruy. ");
INSERT INTO ebk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","As nan chacha umuyan, kenalen nan usa ay laraki kan Jesus, “Umunuchak kan he-a uray kumpurmi as ay-ayam.” ");
INSERT INTO ebk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tinumfor hi Jesus kan hiya, “Wachay lungug ay omafongan nan chiyuycha fuwus, ya wachay somollongan nan chiyuycha kossel, ngem maid ustu as massuyan nan Naepadtu ay Anak chi Taku.” ");
INSERT INTO ebk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kenalen Jesus as nan usa pay ay taku, “Umunudka kan ha-un.” Ngem kenalen nan taku, “Apo, awni pay ta uyku ilufok on-ona hi amak.” ");
INSERT INTO ebk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tinumfor hi Jesus kan hiya, “Pay-am. Kikiad nan chiyuycha maid pammaticha ay maepachong as nan nunkatuy nan uy mangilufok as nan pachongcha ay nunkatuy. Ngem kun pay he-a, uymu at ekasaba nan maepangkep as nan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kenalen nan tukún ay taku, “Apo, umunuchak kan he-a, ngem awni pay a ta uyak munpakacha on-ona as nan pamilyak.” ");
INSERT INTO ebk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ngem kenalen Jesus, “Nan taku ay mangelapu ay mun-arachu ya kun cha munsakosakong at achi maekari ay maetapi as nan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kun pay narpas chi, nunpili hi Jesus as piton puru ya chuwa pay ay disipulusna, ya infiaorna chicha ay mahinchudwa ay mangon-ona ay umuy henan am-in ay ili ya lukiar ay ay-ayanantu. ");
INSERT INTO ebk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kenalina kan chicha, “Ongor chi maani, ngem akét chi mun-ani. Isunga ekararagyu as nan nunkuwa as nan maani ta umifiaor hiya as tapina pay ay mun-ani. ");
INSERT INTO ebk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Uy kayu! Ifiaorku chakayu ay maepachong as nan naamu ay kordero as nan kawad-an nan chiyuycha kauugyat ay atap ay asu. ");
INSERT INTO ebk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Achi kayu ometakin as petaka, samfiag winnu sapatos ay munsokatanyu. Achiyu iyaw-awni as nan charan ay maketagtakiatfor as kumpurmi. ");
INSERT INTO ebk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","As nan uray ngachana ay afong ay sungkopanyu, kananyu on-ona un, ‘Nan natalna ay numnum nan mawawacha koma kan chakayu ay hinfiaruy.’ ");
INSERT INTO ebk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mu awatun nan nakin afong nan hana bendisyon ay infiakiayu, mabendisyonantu hiya. Ngem mu achina awatun, achintu mabendisyonan. ");
INSERT INTO ebk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mayassa kayu as nan hana ay afong. Kanunyu ya ikopunyu nan ichatcha kan chakayu, tay nan munchunu at maekari ay malagfuwan. Achi kayu mun-attoatton as afong ay chumawusanyu. ");
INSERT INTO ebk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","As nan umuyanyu henan usa ay ili ya mangiliyun chakayu, kanunyu nan makan ay esakianacha para kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Paammayunyu nan munsaket ay wacha hid-i ay ili, ya kananyu kan chicha, ‘Kiayud umchan nan muntorayan Apo Dios kan chakayu.’ ");
INSERT INTO ebk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngem as nan umuyanyu henan usa ay ili ya achi chakayu mangiliyun, umuy kayu as nan chiyuycha korsa, ya kananyu un, ");
INSERT INTO ebk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Uray nan tapok nan iliyu ay naepkat as nan chapanmi at pokpokanmi ay mangepaila ay maid fiyangmi as nan manusaan Apo Dios kan chakayu.’ Ngem uray mu hiyasa, achiyu liwliw-an ay kiayud umchan nan muntorayan Apo Dios kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ifiakiak kan chakayu ay as nan hana ay urkiw ay mang-okomán Apo Dios as nan katakutaku, narakrakantu nan chusan nan chiyuycha i-Sodoma mu nan umiili hesa.” ");
INSERT INTO ebk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Inturuy Jesus, “Kasusug-ang kayu ay i-Corazin ya i-Betsaida! Tay mu ad Tiro ya ad Sidon nan nangekamanak as nan hanacha amud ay nakaskaschaaw ay enkamkamanku kan chakayu, nunfiafiawicha at koma ay nangatokor ay nangafiachu as saku ya nachachapor. ");
INSERT INTO ebk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ngem as nan urkiw ay mang-okomán Apo Dios as nan katakutaku, narakrakantu nan chusan nan chiyuycha i-Tiro ya i-Sidon mu chakayu. ");
INSERT INTO ebk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Chakayu ngay ay i-Capernaum, ay kananyu un maichayaw kayu ad chaya? Achi! Awni at kun kayu maichus-or ad inferno.” ");
INSERT INTO ebk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kenalen pay Jesus as nan disipulusna, “Nan taku ay chumngor kan chakayu at kan ha-un nan chumngorana, ya nan mangachi kan chakayu at ha-un nan achiyuna. Kun pay nan mangachi kan ha-un at hi Apo Dios ay nangifiaor kan ha-un nan achiyuna.” ");
INSERT INTO ebk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","As nan nunfiangchan nan piton puru ya chuwa ay infiaor Jesus, ongor chi lagsakcha, ya kanancha kan Jesus, “Apo, uray nan chiyuycha anennet at enmafurotcha kan chakami as nan nangifilinanmi kan chicha ay fomoknagcha as nan nangosaranmi as nan ngachanmu.” ");
INSERT INTO ebk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kenalen Jesus kan chicha, “Inilak nan enat Satanas ay nag-as, at kaman as nan fiakilat ay nurpu ad chaya. ");
INSERT INTO ebk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chumngor kayu! Enettak chakayu as kalibfengan ay mangikiatin as nan chiyuycha urug ya chiyuycha scorpion, ya mangamis as nan am-in ay pannakafialin nan kafusoryu ay hi Satanas. Maid mangisiw ay ommat kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ngem achi kayu koma munlagsak kiapú ta nunpaetoray nan chiyuycha anennet kan chakayu, kun at nan munlagsakanyu at kiapú ta naisurat nan ngachanyu ad chaya.” ");
INSERT INTO ebk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","As nan hiyasa ay uras, enpalagragsak nan Espiritu Santo hi Jesus, ya kanana, “Ama ay Apo ad chaya ya asna's luta, munyamanak kan he-a, tay enpakaammom as nan chiyuycha chaan nakaachar nan nauycha entatafunmu as nan chiyuycha mamasilib ya nakaachar. O, Ama, enatmu na, tay hiyana nan mangepalaylayad kan he-a. ");
INSERT INTO ebk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Nan am-in at entalek Ama kan ha-un. Maid nangammu as nan Anak omangkiay nan Ama. Assesa us ay maid nangammu as nan Ama omangkiay nan Anak ya nan piliyun nan Anak ay mangepakaammuwana.” ");
INSERT INTO ebk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kun pay narpas sa, nunsakong hi Jesus as nan disipulusna as nan naaangkiayancha, ya kanana “Nakiasat nan tataku ay mangila as nan chayu il-ilaun. ");
INSERT INTO ebk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ifiakiak kan chakayu ay ongor kayman chi pomapadtu ya ar-ari ay nunlarayad ay mangila as nan chayu il-ilaun, ngem chaancha inila. Lenayadcha us ay manngor as nan chayu chungchungrun, ngem chaancha chinngor.” ");
INSERT INTO ebk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wacha nan usa ay mun-isursuru as Lintig ay inmuy kan Jesus ta chistinguna hiya. Kenalina, “Misturu, ngachana nan atok ta tawichok nan fiyag ay maid patingkiana?” ");
INSERT INTO ebk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tinumfor hi Jesus kan hiya, “Ngachana nan naisurat as nan Kalen Apo Dios? Ngachana nan mangawatmu?” ");
INSERT INTO ebk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tinumfor hiya, “Masapor laylaychum nan Apo ay Diosmu as nan am-in ay pusom, as nan am-in ay katatakom, as nan am-in ay fikasmu, ya as nan am-in ay numnummu. Masapor us laylaychum nan pachongmu ay taku ay kaman as nan atum ay manglaylayad as achormu.” ");
INSERT INTO ebk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Ustu nan ensongfiatmu,” kenalen Jesus, “Hiyasa nan atum, at matakuka in-inkiana.” ");
INSERT INTO ebk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngem lenayadna ay mangekalintikian as achorna, isunga kenalina kan Jesus, “Ngachana man nan sasag-unku?” ");
INSERT INTO ebk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tinumfor hi Jesus babaen as nan maepadpachongan: “Wacha nan usa ay taku ay cha chumayyu ad Jerico ay nurpu ad Jerusalem. As nan korsa, kalina at ya finchang chi homohold-ap hiya. Enaracha nan am-in ay wacha kan hiya, uray nan fiachuna, ya penak-opak-orcha inkiana kiayud matuy. Angkiay ya tenaynancha hiya. ");
INSERT INTO ebk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wacha nan pachi ay naiyaspor ay cha chumayyu as nan hana ay korsa. Kuna pay inila nan chiyuy taku, nunliglig hiya. ");
INSERT INTO ebk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Assesa us as nan Levitaay kun pay inumchan as nan kawad-an nan chiyuy taku ya inilana hiya, nunliglig hiya. ");
INSERT INTO ebk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ngem as nan nar-osan us nan usa ay i-Samaria ay cha munfiaat as nan kawad-an nan chiyuy taku ya inilana hiya, nasug-ang as solet hiya. ");
INSERT INTO ebk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Naesag-un, ya kenapuwana hiya as lana ya fiayas, angkiay finudfuchana nan sukiatna. Kun pay narpas, ensakayna hiya as nan dongki, ya inyuyna as nan chumawchawsan chi munfiaat, angkiay enaywanana hiya. ");
INSERT INTO ebk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","As nan kafikiatana, inchatna nan chuwa ay dinario as nan nakin kuwa as nan chumawchawsan, ya kanana kan hiya, ‘Aywanam hiya. As nan munfiangchak hena, fiayachaktu mu kaatna pay nan kinastosmu.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Inyanongos Jesus, “As nan munnunumnummu, ngachana kan chatud-i ay turu nan tit-iwa ay sag-un nan chiyuy taku ay penak-opak-or nan chiyuycha homohold-ap?” ");
INSERT INTO ebk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tinumfor nan mun-isursuru as Lintig, “Ya kakun nan chiyuy taku ay nanug-ang kan hiya.” Kenalen Jesus, “Uyka ngarud, ya assid-i us nan atum.” ");
INSERT INTO ebk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","As nan cha munfiaatan Jesus ya nan disipulusna, inumchancha henan usa ay fiabruy. Wacha hid-i nan fiafiai ay nan ngachana at Marta ay nangmangili kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wacha nan enauchina ay nan ngachana at Maria ay tenmokor as nan sag-un nan suken Jesus ya cha chumchumngor as nan cha isursuron Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ngem kun pay hi Marta, cha maseksekoran, tay hiya yangkiay nan cha mun-esakiana as kanuncha. Isunga inmuy hiya kan Jesus, ya kanana, “Apo, ay achim pakian-anu uray mu tenaynanak as nan ifiak, at kunku iyuusa ay mannu as nan nauycha am-in ay chunu? Ifiakiam pay kan hiya ta fiadnganak.” ");
INSERT INTO ebk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngem tinumfor hi Jesus kan hiya, “Marta, Marta! Chaka machanchanakian ya malilifokan as maepangkep as ongor ay fianag, ");
INSERT INTO ebk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ngem kun met usa yangkiay nan kasaporan. Pinilen Maria nan kaammayan, at achintu makakkaan kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","As nan hin-urkiw, cha munkarkararag hi Jesus henan usa ay lukiar. Kun pay narpas, kenalen nan usa ay disipuluna, “Apo, isurom pay chakami ay munkararag, kaman as nan enat Juan ay Fumufunyag ay nangisuru as nan disipulusna.” ");
INSERT INTO ebk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kenalen Jesus kan chicha, “As nan munkararakianyu, assena nan kananyu: ‘Ama, maichaychayaw koma nan nasantowan ay ngachanmu. Omali koma nan muntorayam. ");
INSERT INTO ebk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ichatmu koma kan chakami nan kanunmi as inurkiw. ");
INSERT INTO ebk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pakawanum koma chakami as nan fiasfiasormi, tay pakawanunmi us nan am-in ay finmasor kan chakami. Achim koma eparufus ay etorokmi ay masulisukian.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kenalen pay Jesus, “Mu ngay wacha nan usa kan chakayu ay umuy as afong nan usa ay kiayyumna as nan tongan chi lafi, ya kanana kan hiya, ‘Kiayyum, umutangak pay as turu ay tenapay, ");
INSERT INTO ebk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tay wacha nan cha munfiaat ay kiayyumku ay chinmawus ya naiyaspor ay maid epakanku kan hiya.’ ");
INSERT INTO ebk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mu ngay kanan nan kiayyummu ay wacha as fiaruy un: ‘Achika at man chumisturfu, tay naichachakig at nan unub ya inuumfug kami as nan an-akku. Achiyak challu fumangun ay umichat as makan kan he-a.’ ");
INSERT INTO ebk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ifiakiak kan chakayu ay uray mu achi fumangun ay umichat as makan kiapú ta kiayyummu hiya, ngem kiapú ta cham itukiatukia ay chumawat, fumangun challu ya ichatna nan am-in ay kasaporam. ");
INSERT INTO ebk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Isunga ifiakiak kan chakayu ay achiyu ikinkinak ay chumawchawat kan Apo Dios as kasaporanyu, at maichattu kan chakayu nan chayu chawchawatun. Achiyu ikinkinak ay mun-an-anap, at maanapanyuntu nan chayu an-anapun. Achiyu ikinkinak ay munkokkokkok, at tokafiantu Apo Dios nan pantiw para kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tay am-in ay chumawat kan Apo Dios at maawatna nan chawatuna, ya nan mun-anap at makaanap, ya nan munkokkok at matkafian nan pantiw para kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ngachana kan chakayu ay am-a nan mangichat as urug mu chumawat nan pototyu as kiachiw, ");
INSERT INTO ebk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","winnu mangichat as scorpion mu chumawat as itlug? ");
INSERT INTO ebk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mu chakayu ay manangotettet at ammuyu ay umichat as ammay as nan an-akyu, ay achi kaskasin ay ichat Ama ay wacha ad chaya nan Espiritu Santo as nan chiyuycha chumawat kan hiya?” ");
INSERT INTO ebk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","As nan hin-urkiw, cha mun-epafoknag hi Jesus as anennet ay nang-umor as nan usa ay taku. Kun pay fenmoknag nan anennet, makakali at nan hana ay taku, at naschaawcha nan tataku. ");
INSERT INTO ebk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ngem nan tapina kan chicha at kenalicha, “Hi Beelzebub ay ap-apon chi anennet nan nangichat kan hiya as pannakafialin ay mangepak-ak as anennet.” ");
INSERT INTO ebk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kun pay nan tapina at lenayadcha ay manisting kan Jesus. Isunga chinmawatcha as nakaskaschaaw ay sinyar ay mangepaneknek ay hiya at nurpu kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngem aammon Jesus nan chacha numnumnumun, isunga kenalina kan chicha, “Uray ngachana ay muntorayan ay munkikinnufiat chi tatakuna at machachael. Kaman us as nan hinfiaruy ay mu masusumacha at masisiyancha. ");
INSERT INTO ebk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mu makepatuy hi Satanas as nan chiyuycha anennet ay etorayana, anan atuna ay munturturuy ay muntoray in-inkiana? Kenalek sa, tay kananyu un hi Beelzebub nan nangichat as pannakafialinku ay mangepafoknag as nan chiyuycha anennet. ");
INSERT INTO ebk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mu as nan pannakafialin Beelzebub nan nangor-ak as pannakafialinku ay mangepafoknag as nan chiyuycha anennet, ngachana ngay nan nangichat as pannakafialin nan chiyuycha umun-unud kan chakayu ay mun-epafoknag as nan chiyuycha anennet? Mu hiyasa, chicha nan mangepaneknek ay achi tit-iwa nan kenaliyu. ");
INSERT INTO ebk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nan kenatit-iwana at fiakun hi Beelzebub, ngem hi Apo Dios nan nangichat as pannakafialinku ay mun-epafoknag as nan chiyuycha anennet. Hiyana nan mangepaila ay enmali nan muntorayan Apo Dios kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mu naarmasan ay ustu nan usa ay kursi ay taku ya fiantayana nan afongna, maid maak-akiw as nan kuk-uwana. ");
INSERT INTO ebk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ngem mu omali nan kurkursi ay taku ay makepatuy ya amisuna hiya, arauna nan am-in ay armas ay muntaltalekan nan kursi ay anchi. Angkiay ya enpakakchang nan hana kurkursi nan enakiwna. ");
INSERT INTO ebk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nan ngachana ay achi makius-usa kan ha-un at komokontra kan ha-un. Assesa us ay nan ngachana ay achi fumachang kan ha-un ay mangamong as nan tataku at kuna munsisiyanun chicha.” ");
INSERT INTO ebk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nun-epadpachong pay hi Jesus, “As nan fenmoknakian nan anennet ay sinungkop as nan taku, uy munlikud hiya henan luglukiar ay kamaid chi chanum ay mun-anaanap as tukún ay mun-iblayana, ngem maid uchanana. Angkiay ya kanana as numnumna, ‘Munfiangachak challu as nan afongku ay nurpuwak.’ ");
INSERT INTO ebk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","As nan munfiangchana, uchanana ay nacharos ya naornos nan afong. ");
INSERT INTO ebk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Angkiay ya mak-ak ya ometakin as tapina ay pitu ay anennet ay kaskasin manangotettet mu hiya. Sungkopcha as nan afong ya magyancha hid-i. As nan hiyachi, kaskasin mangisiw nan kasasaad nan chiyuy taku mu nan enmon-ona ay kasasaadna.” ");
INSERT INTO ebk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kun pay kenalen Jesus chaná, nunfukiaw nan usa ay fiafiai ay wacha as nan kaongoran chi tataku, ya kanana kan hiya, “Nakiasat paat nan nangiyanak ya nangepasusu kan he-a!” ");
INSERT INTO ebk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ngem kenalen Jesus, “Kun at nan nakiasat at nan chiyuycha manngor as nan kalen Apo Dios ya mangtongpar as sa.” ");
INSERT INTO ebk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kun pay cha omongor chi tataku, inturuy Jesus, “Nakkuran! Anuy paat mangotettet chi ukialen chi tataku ad wani! Chacha chumawat as nakaskaschaaw ay sinyar, ngem maid maepaila kan chicha omangkiay nan nakaskaschaaw ay enommat kan Jonas ay pomapadtu. ");
INSERT INTO ebk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kaman as nan nunfialinan Jonas as sinyar ay naepaila as nan tataku ad Nineve at assesa us ay munfialintu nan Naepadtu ay Anak chi Taku as sinyar ay maepaila as nan tataku ad wani. ");
INSERT INTO ebk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","As nan urkiw ay mun-okomán Apo Dios, tomakchugtu nan Reyna ad Seba ad pus-uy ay mangepafiasor as nan tataku ad wani, tay nurpu hiya henan achaachawwi ay lukiar ay uy paat nanngor as nan nainsilifian ay sursuron Solomon. Ifiakiak kan chakayu ay wacha hena ad wani nan am-amud mu hi Solomon. ");
INSERT INTO ebk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","As nan omaliyantu nan urkiw ay mun-okomántu Apo Dios as nan am-in ay tataku, tomakchugtu nan inmiili ad Nineve ay mangepafiasor kan chakayu ay tataku ad wani, tay nunfiafiawicha as nan fiasfiasorcha as nan nanngorancha as nan enkaskasaban Jonas. Ifiakiak kan chakayu ay wacha hena ad wani nan am-amud mu hi Jonas!” ");
INSERT INTO ebk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Inturuy Jesus, “Maid mamaskud as pingki ya ilingub winnu uyna op-opan as fianga. Ngem kuna at epatang as nan maepatpatngan ta nan chiyuycha sungkop at ilauncha nan silaw. ");
INSERT INTO ebk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nan matam at hiyasa nan maepachong as nan silaw nan achormu. Mu narawag nan umil-an nan matam, nasilawan nan intiru ay achormu. Ngem mu achi narawag nan umil-an nan matam, ngongot as solet nan achormu. ");
INSERT INTO ebk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Isunga il-ilaum ngarud ta nan silaw nan wacha kan he-a, fiakun nan ngongot. ");
INSERT INTO ebk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mu nan intiru ay achormu at narawag ay maid poros ngongot, narawagtu nan intiru ay achormu ay kaman chaká sinisilawan as nan lawag nan silaw.” ");
INSERT INTO ebk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kun pay cha munkarkali hi Jesus, enayakian nan usa ay Fariseo hiya ta makekan kan hiya. Isunga inmuy hi Jesus as nan afong nan Fariseo, ya naketokor ay makekan. ");
INSERT INTO ebk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nakudnor nan chiyuy Fariseo as nan nangil-ana ay chaan nunfuru on-ona hi Jesus sakbay mangan ay maiyunud as nan iniili ay ukialicha. ");
INSERT INTO ebk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ngem kenalen Apo Jesus kan hiya, “Chakayu ay Fariseo at kaman kayu as nan tataku ay manguras as nan luwar yangkiay nan tasa ya paratu, ngem achiyu met charosan nan numnumyu ay napnu as kenaakum ya kenamangotettet! ");
INSERT INTO ebk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Chakayu ay nunkangokngok! Ay fiakun hi Apo Dios ay nangamma as nan achor takú nan nangamma us as nan numnum takú? ");
INSERT INTO ebk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kunyu at ichat as nan makasapor nan wacha as nan tasa ya paratuyu. Tay mu atunyu sa, tit-iwa ay nacharos kayu. ");
INSERT INTO ebk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kasusug-ang kayu ay Fariseo, tay ichatonyu met tit-iwa nan pagkapuron nan apetyu ay kaman as nan chiyuycha mangepaammay as machangchang, ngem enganuyyu met nan kenalintig ya nan layadyu kan Apo Dios. Chatona nan masapor ay atunyu, ya achiyu challu enganuy ay mangekaman as nan tapina. ");
INSERT INTO ebk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kasusug-ang kayu ay Fariseo, tay nan laylaychunyu ay tomoktokoran at as nan kaammayan ay tokoran as nan senagoga, ya laylaychunyu us ay cha chakayu risrispituwun as nan tataku as nan chiyuycha mun-el-elakwan. ");
INSERT INTO ebk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kasusug-ang kayu ay Fariseo, tay maepachong kayu as nan chiyuycha lufok ay maid matoncha ay cha ikiatkiatin chi tataku, tay achicha ammu ay lufok.” ");
INSERT INTO ebk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Usa as nan mun-isursuru as Lintig nan nanfor kan Jesus, “Misturu, as nan nangaliyam as sa, cham us pabpafiainan chakami.” ");
INSERT INTO ebk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kenalen Jesus, “Kasusug-ang kayu us ay mun-isursuru as Lintig, tay ongor chi lintigyu ay chayu epadpad-un as nan tataku ay achicha kafiaelan, ya achiyu met uyachun chi uray us-usa paat ay kiayyamotyu ay fumachang kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kasusug-ang kayu, tay iyammaanyu as anam-ammay ay lufok nan chiyuycha pomapadtu ay penatuy nan kaap-uwanyu. ");
INSERT INTO ebk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ngem as nan mangekamkamananyu as sa, epailayu ay iyafudyu nan enkamkaman nan kaap-uwanyu, tay penatuycha chicha, ya iyam-ammaanyu chicha as lufokcha. ");
INSERT INTO ebk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hiyana nan mangepaila ay masilib hi Apo Dios, tay kenalina ad pus-uy un, ‘Ifiaorkuntu kan chicha nan chiyuycha pomapadtu ya apostoles, ngem patayunchantu nan tapina kan chicha ya palikiatunchantu nan tapina.’ ");
INSERT INTO ebk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Isunga chakayu ay tataku ad wani nan machusantu kiapú as nan napatuyan nan am-in ay pomapadtu nunlapu as nan nafiayangan nan luta, ");
INSERT INTO ebk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nunlapu as nan natuyan Abel inkiana as nan natuyan Zacarias ay napatuy as nan nunkiakiaw-an nan altar ya nan nasantowan ay kuwartu as nan Templo. Ifiakiak kan chakayu, tit-iwa ay machusantu nan tataku ad wani kiapú as nan penmatpatuyan nan kaap-uwancha. ");
INSERT INTO ebk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kasusug-ang kayu ay mun-isursuru as Lintig, tay kenaanyu nan torfek ay mankab as nan pantiw nan mangammuwan as nan kalen Apo Dios. Chakayu ay mismu at chaan kayu sinungkop ya enpawayu pay ay sungkop koma nan tataku.” ");
INSERT INTO ebk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kun pay cha mak-ak hi Jesus as nan chiyuy ay lukiar, enlapon nan mun-isursuru as Lintig ya nan chiyuycha Fariseo ay kaskasin mangsot kan hiya. Ongor us chi senarudsudcha kan hiya, ");
INSERT INTO ebk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tay laychuncha ay wachay kanana as mangepafiasorancha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","As nan cha ommatan nan nauycha, cha somaliyubyub nan liniblifu ay tataku ay uray kuncha cha munkikinnatin. Kenalen Jesus on-ona nan disipulusna, “Il-ilaunyu nan lebaduran nan chiyuycha Fariseo ay hiya nan ukialicha ay kenapakamankaman. ");
INSERT INTO ebk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Maid naililingub ay achintu maepaila, winnu naetatafun ay achintu maammuwan. ");
INSERT INTO ebk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Isunga mu ngachana nan infiagfiakiayu as nan lafi, madngortu as nan kaorkia. Nan intubtufuyu as nan kawad-anyu as nan naiin-ub ay kuwartuyu at maifukiawtu as nan chiyuycha charan ta chungrun nan ongor ay tataku.” ");
INSERT INTO ebk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kenalen Jesus as nan disipulusna, “Ifiakiak kan chakayu ay kiakiayyumku, achi kayu umugyat as nan chiyuycha mangpatuy as achor, tay as nan marpasan tosa at maid kasincha atun. ");
INSERT INTO ebk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ngem ifiafiakiak nan umugyatanyu: Nan umugyatanyu at kan Apo Dios ay wachay pannakafialina ay mangichus-or as nan achor ad inferno as nan manglopasana ay mangpatuy. O, tit-iwa, ifiakiak kan chakayu ay hiya nan masapor umugyatanyu. ");
INSERT INTO ebk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ilaunyu nan chiyuycha tulin. Ay achi nan lema at maelaku as kun lawá chuwa ay pesos? Maelaku met! Uray akét chi fiarorcha at maid challu liwliw-an Apo Dios as uray usa kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Uray nan fook as uruyu at nafifilangcha am-in. Isunga achi kayu umugyat, tay nafiarfiaror kayu mu nan ongor ay tulin.” ");
INSERT INTO ebk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kenalen pay Jesus, “Ifiakiak kan chakayu ay nan uray ngachana ay mangipudnu as nan sangwanan nan tataku ay hiya at omafurot kan ha-un, assesantu us ay ipudnuntu nan Naepadtu ay Anak chi Taku nan maepangkep kan hiya as nan sangwanan nan angheles Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ngem nan mangesaot kan ha-un as nan sangwanan nan tataku at maesaottu us as nan sangwanan nan angheles Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Nan ngachana ay munkali as maifusor as nan Naepadtu ay Anak chi Taku at mafialin ay mapakawan. Ngem nan munkali as maifusor as nan Espiritu Santo at achi mapakawan. ");
INSERT INTO ebk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“As nan mangicharuman nan tataku kan chakayu as nan sangwanan nan anap-apu as nan chiyuycha senagoga winnu as nan gogobernador winnu as nan wacha as nan toray, achi kayu machanchanakian mu anan atunyu ay somongfiat winnu ngachana nan kananyu. ");
INSERT INTO ebk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tay as nan hiyasa ay timpu at isuruntu nan Espiritu Santo nan ustu ay kananyu.” ");
INSERT INTO ebk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","As nan kaongoran chi tataku, wacha nan usa ay laraki hid-i ay nangali kan Jesus, “Misturu, ifiakiam as nan sunúdku ay kudwaunmi nan enpatawid chin amami kan chakami.” ");
INSERT INTO ebk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ngem kenalen Jesus kan hiya, “Ay kun kayong ha-un nan wachay kalibfengana ay mangenongnong winnu mangudwa as tawidyu? Fiakun.” ");
INSERT INTO ebk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Angkiay ya inturuy Jesus ay mangali as nan am-in ay tataku, “Il-ilaunyu ta achi kayu masursulisukian as nan am-in ay kenaakum, tay fiakun nan kenaongor nan kuk-uwan nan taku nan mail-an nan tit-iwa ay fiyagna.” ");
INSERT INTO ebk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","As nan hiyachi, infiakian Jesus kan chicha nan nauy ay maepadpachongan: “Wacha nan usa ay fiaknang ay ongor nan enanina as payyiwna. ");
INSERT INTO ebk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kenalina as numnumna, ‘Anan atok ngun, t'enha maid mangepay-ak as nan ongor ay enanek? ");
INSERT INTO ebk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","O, iwa, assena nan atok: Soktafok nan chiyuycha arangku ya munkiaufiak as an-anad-acha. Hid-i nan mangepay-ak as nan am-in ay enanek ya tapina pay ay kinakok.’ ");
INSERT INTO ebk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Angkiay ya kanaktu as achorku, ‘Ongor nan intupugku ay kasaporak ay ommat as kaat ay tawwun. Kunak mun-ib-iblay, mangmangan, umig-ikop, ya munlagragsak.’ ");
INSERT INTO ebk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ngem kenalen Apo Dios kan hiya, ‘Narokrok! Ad wani ay lafi, matuy ka. Anan manguwa pay as nan intutupugmu?’ ” ");
INSERT INTO ebk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Inyanongos Jesus, “Assesa nan ommat as nan taku ay cha mun-ituputupug as kenafiaknang as para kan hiya, ngem pugli hiya as nan mangiilan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kenalen Jesus as nan disipulusna, “Isunga ifiakiak kan chakayu ay achi kayu machanakian as maepangkep as pagfiyagyu mu anan kanunyu, winnu machanakian as nan maepangkep as nan achoryu mu anan ifiachuyu. ");
INSERT INTO ebk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tay nan fiyag at am-amud mu nan makan, ya nan achor at am-amud mu nan fiachu. ");
INSERT INTO ebk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Numnumunyu nan chiyuycha kossel. Achicha muntanum winnu mun-ani ya maid fiarugcha winnu arangcha. Uray mu hiyasa, pakanun challu Apo Dios chicha. Am-amud kayu met mu nan nauycha kossel! ");
INSERT INTO ebk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ngachana kan chakayu nan makafiael ay mangepaan-anchu as fiyagna as uray kun usa ay uras kiapú as nan chana munchanchanakian. ");
INSERT INTO ebk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mu achiyu kafiaelan ay mangekaman as ak-akettuy ay kaman as nan hana, anuy kayu lawá machanakian as maepangkep as tapina? ");
INSERT INTO ebk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ilaunyu nan atun nan sabsafong ay masikun. Achicha munchunu winnu mun-afor as fiachucha. Uray mu hiyasa, ifiakiak kan chakayu ay uray hi Ari Solomon as nan am-in ay kenafiaknangna at chaan poros nunfiachu as maepachong as nan kenaam-ammay nan usa as nan nauycha sabsafong. ");
INSERT INTO ebk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mu fiachuwan Apo Dios nan nauycha lukiam ay wacha as uma ad wani ya as wiet at mapuoran challu, ay achina chamman kaskasin fiachuwan chakayu mu nan nauycha? Anuy paat anak-akettuy chi pammatiyu! ");
INSERT INTO ebk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kiapú ta assesa, achi kayu cha munnumnunumnum as kanunyu ya ikopunyu, ya achi kayu munchanag. ");
INSERT INTO ebk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tay nan nauycha nan cha anaanapun nan chiyuycha Gentil ay achi nangammu kan Apo Dios. Ngem hi Amayu ad chaya at ammuna ay masaporyu chaná. ");
INSERT INTO ebk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kunyu at anapun nan maepangkep as nan muntorayan Apo Dios, at ichatnantu us chaná ay kasaporanyu.” ");
INSERT INTO ebk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kenalen pay Jesus, “Achi kayu umugyat, chakayu ay chak ay-aywanan, uray akét kayu, tay laychun Ama ad chaya ay maketoray kayu kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Elakuyu nan kuk-uwayu, ya ichatyu nan lakuna as nan chiyuycha pugli. As nan mangekamananyu as na, maarayu nan kenafiaknangyu ad chaya ay achi poros maak-akiw ya machadchachael. Kamanyu cha esakiana nan chiyuycha petakayu ay achi machunchunot, ya nan kenafiaknangyu ay ichulinyu at achi mamammaid. ");
INSERT INTO ebk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tay mu ay chaud nan kawad-an nan kenafiaknangyu at hid-i us nan kawad-an nan numnumyu.” ");
INSERT INTO ebk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Inturuy Jesus, “Munsasakiana kayu as nan kumpurmi ay om-ommat, ya papaskuchanyu nan pingkiyu ");
INSERT INTO ebk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ay maepachong as nan chiyuycha mafiabfiaor ay maman-ud as nan amocha ay uy nakichuyas ta muntokafiancha nan unub as nan munkokkokana ay sungkop. ");
INSERT INTO ebk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nakiasat nan chiyuycha mafiabfiaor ay chaan nanassuy ya nakasakiana as nan omaliyan nan amocha. Ifiakiak kan chakayu nan tit-iwa ay munsokattu nan chiyuy amo, patokorunantu chicha ya ikiauwana chicha. ");
INSERT INTO ebk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nakiasatcha nan chiyuycha mafiabfiaor mu asporan nan amocha chicha ay nakasakiana, uray mu komatam hiya as nan tongan chi lafi winnu maradlachaw.” ");
INSERT INTO ebk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Numnumunyu na: Mu aammon nan nakin afong nan uras ay omaliyan nan mangaakiw, achina eparufus ay sugpun nan mangaakiw nan afongna. ");
INSERT INTO ebk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","“Assesa us koma kan chakayu ay masapor nakasakiana kayu, tay omali nan Naepadtu ay Anak chi Taku as nan uras ay achiyu namnamaun.” ");
INSERT INTO ebk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kenalen Pedro, “Apo, ay kan chakami nan cham mangifiag-an as nan nauy maepadpachongan winnu as nan am-in ay tataku?” ");
INSERT INTO ebk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tinumfor hi Apo Jesus, “Ngachana ngarud nan matalek ya masilib ay mafiabfiaor? Hiya nan mangichatantu nan amona as nan kalibfengan ay mun-aywan as nan kakadwana ay mafiabfiaor, ya hiya nan mangiwarastu as kanuncha as nan ustu ay timpon chi manganancha. ");
INSERT INTO ebk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nakiasat paat sa ay mafiabfiaor as nan komataman nan amona ya asporana hiya ay cha mangekaman as nan infilina. ");
INSERT INTO ebk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ifiakiak kan chakayu nan tit-iwa ay kan tosa ay mafiabfiaor nan mangichatantu nan amona as nan kalibfengan ay mun-aywan as nan am-in ay kuk-uwana. ");
INSERT INTO ebk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ngem mu nan hana ay mafiabfiaor at kanana as numnumna un, ‘Uy at man mafiayag ay munfiangad nan amok.’ Angkiay ya enlapuna ay manoprat as nan kakadwana ay mafiabfiaor ay fianafiai ya lanaraki, ya cha uy mangmangan, umig-ikop, ya munfutfutang. ");
INSERT INTO ebk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","As nan komatamantu nan amona as nan urkiw ay achina namnamaun ya uras ay achina ammu, chusauntu nan amona hiya. Hana at etapi hiya as nan chiyuycha achi omaafurot.” ");
INSERT INTO ebk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nan mafiabfiaor ay nangammu as nan laychun nan amona ay atuna ngem chaan nunsakiana winnu chaana enat nan laychun nan amona at ong-ongortu nan masaplitana. ");
INSERT INTO ebk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kun pay nan mafiabfiaor ay chaan nangammu as nan laychun nan amona ay atuna, uray mu enatna nan kiapón chi masaplitana, ak-akéttu nan masaplitana. Tay nan taku ay naichatan chi ongor at ongor nan manamnamantu ay murpu kan hiya, ya nan taku ay naetalekan chi ongor at ongor nan manamnamantu ay murpu kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kenalen pay Jesus, “Enmaliyak ay mamuor as nan nauy luta ya laychok ay kumil-aw at koma! ");
INSERT INTO ebk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngem masapor munlikiataktu, ya kunak masesekoran as solet inkiana ommat! ");
INSERT INTO ebk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ay kananyu un enmaliyak ay umichat as talna asna's luta? Achi! Ifiakiak kan chakayu, enmaliyak ay mangsisiyan as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Munlapu ad wani, masisiyan nan lema as nan usa ay pamilya. Nan turu at kontrauncha nan chuwa, ya nan chuwa at kontrauncha nan turu. ");
INSERT INTO ebk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","O, kuncha makudkudwa. Munkennontra nan hen-ama ya kaman us as nan hen-ena. Nan katukiangan ay fiafiai at kontrauna nan enapuna ay fiafiai, ya nan enapu ay fiafiai at kontrauna nan katukiangana ay fiafiai.” ");
INSERT INTO ebk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kenalen Jesus as nan ongor ay tataku, “Mu ilaunyu nan lifuu ay cha fomoknag henan mauy-uynuwan nan urkiw, hiya at chi ya kananyu un, ‘Umuchantu,’ ya ommat tit-iwa. ");
INSERT INTO ebk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kaman us as nan mangkeknaanyu as nan angin ay murpu as filáng, kananyu un, ‘At-atongngantu,’ ya ommat tit-iwa. ");
INSERT INTO ebk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Chakayu ay pakamankaman! Naraing kayu ay mangematon as nan maila henan luta ya ad chaya. Ngem anuyyu achi maematonan nan chiyuycha sinyar Apo Dios maepangkep kan ha-un ay cha om-ommat ad wani ay timpu?” ");
INSERT INTO ebk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Inturuy Jesus, “Adchi t'uyyu achi numnumun mu ngachana nan ustu ay atunyu? ");
INSERT INTO ebk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mu kaspangarigan iyuy chaká as nan nangicharum kan he-a as kurti, atum nan kafiaelam ay makealiglu kan hiya as nan charan. Tay mu achi, ipurang chaká as nan huwis. Angkiay ya nan huwis at ipurang chaká as nan pulis ay mangifiarud kan he-a as pagfiaruchan. ");
INSERT INTO ebk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ifiakiak kan he-a ay achikantu makapitiw as pagfiaruchan inkiana fiayacham nan am-in ay mortam.” ");
INSERT INTO ebk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","As nan hiyachi ay timpu, wachacha hid-i nan tapina ay tataku ay nangifiakia kan Jesus maepangkep as nan tapina ay i-Galilea ay enpapatuy Gobernador Pilato as nan chacha mun-ichatonan kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tinumfor hi Jesus kan chicha, “Ay kananyu un kaskasin fumafiasor chaná ay i-Galilea mu nan tapina ay i-Galilea kiapú ta assesa nan enkatuycha? ");
INSERT INTO ebk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Achi! Ifiakiak kan chakayu ay mu achi kayu munfiafiawi as nan fiasfiasoryu, matuy kayuntu us ay kaman kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ay kananyu un kaskasin nunsidlay fiasfiasor nan chiyuycha hinpuru ya waru ay tataku ay natuy ay naappelan as nan natu-ukian nan nangatungatu ay afong ad Siloe mu nan fiasfiasor nan chiyuycha tapina ay kakailiyancha ay i-Jerusalem? ");
INSERT INTO ebk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Achi! Ifiakiak kan chakayu ay mu achi kayu munfiafiawi as nan fiasfiasoryu, matuy kayuntu us ay kaman kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Angkiay ya infiakian Jesus kan chicha nan nauy maepadpachongan: “Wacha nan usa ay taku ay nuntanum as kaiw ay igos as nan umana. As nan timpon chi fumkiasana, uy mun-ila as fukiasna ngem kun maid. ");
INSERT INTO ebk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Isunga kenalina as nan munkiarkiarchinuna, ‘Nauy turu ay tawwun ay enmalialiyak ay mangila as fukias nan nauy ay kaiw, ya kun maid poros ininchanak. Separum at, tay kuna lawá cha saysayangun nan luta.’ ");
INSERT INTO ebk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ngem kenalen nan munkiarkiarchinuna, ‘Apo, hihiya sa hesa as usa ay tawwun ta kaufiak nan kawad-an nan puuna ya lumangak. ");
INSERT INTO ebk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mu fumkias sa as tawwun, ammay paat. Ngem mu achi challu fumkias, epasipormuntu.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","As nan Urkiw ay Mun-iblayan, cha mun-is-isuru hi Jesus as nan usa ay senagoga. ");
INSERT INTO ebk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wacha hid-i nan usa ay fiafiai ay naanennetan ay nangepasaket kan hiya as hinpuru ya waru ay tawwun. Penekot nan anennet hiya, at achi poros makauyad. ");
INSERT INTO ebk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kun pay inilan Jesus hiya, enayakiana, ya kanana, “Ammi, nawayawayaanka as nan saketmu.” ");
INSERT INTO ebk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","As nan nangepatayan Jesus as nan limana kan hiya, naannuyad ya nunchayaw hiya kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ngem finmungat nan ap-apu as nan senagoga, tay nunkaan hi Jesus as saket as nan Urkiw ay Mun-iblayan. Kenalina as nan tataku, “Unum ay urkiw nan munchunuwan takú. Isunga as nan hanacha ay urkiw nan omaliyanyu ay munpakaan as saketyu, fiakun as nan Urkiw ay Mun-iblayan.” ");
INSERT INTO ebk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tinumfor hi Apo Jesus kan hiya, “Chakayu ay pakamankaman! Ay wachay usa kan chakayu ay achi mangfokat ay uy mangepaikop as fiakana winnu dongkina as nan Urkiw ay Mun-iblayan? ");
INSERT INTO ebk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ay achi mafialin ay mawayawayaan as nan Urkiw ay Mun-iblayan nan nauy fiafiai ay kianak Abraham ay finafiarud Satanas as hinpuru ya waru ay tawwun?” ");
INSERT INTO ebk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","As nan nangaliyana as na, nafiainan nan am-in ay kafusorna, ngem nunlagragsakcha nan tataku kiapú as nan am-in ay nakaskaschaaw ay en-enatna. ");
INSERT INTO ebk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Angkiay ya kenalen Jesus, “Ngachana nan kaassenan nan muntorayan Apo Dios? Anan mangepachongak pay? ");
INSERT INTO ebk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Maepachong as nan ek-ektel ay fokel chi mostasa ay enaran nan usa ay taku, ya uyna entanum as nan umana. Nasikun inkiana kaman kaiw chi kaad-achana, at nun-ammacha nan chiyuycha kossel as sollongcha as nan chiyuycha pangana.” ");
INSERT INTO ebk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kenalen pay Jesus, “Ngachana nan mangepachongak as nan muntorayan Apo Dios? ");
INSERT INTO ebk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Maepachong as nan akét ay lebadura ay ekar-ot nan fiafiai as nan turon sarop ay alina inkiana fumrad am-in.” ");
INSERT INTO ebk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Inturuy Jesus ay umuy ad Jerusalem, ya as nan chana manglausan henan il-ili ya fiabfiabruy, nun-is-isuru as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wacha nan nunsarudsud kan hiya, “Apo, ay kun akét chi tataku ay maesarakan?” Tinumfor hi Jesus kan hiya, ");
INSERT INTO ebk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Epapatiyu ay sungkop as nan nalepet ay pantiw, tay ifiakiak kan chakayu ay ongortu nan manglayad ay sungkop, ngem achicha makaskop. ");
INSERT INTO ebk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tay maepachong as nan nauy: Mu chakus tenmakchug nan nakin afong ya inin-ubna nan pantiw, mayagyag kayuntu as chará. Uray mu cha kayu munkokkokokkok ay mangali un, ‘Apo, ayu pay tokafiam na ta sungkop kami.’ Kananantu ay manfor kan chakayu un, ‘Achek poros am-ammu chakayu winnu nan nurpuwanyu.’ ");
INSERT INTO ebk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Angkiay ya kananyuntu us un, ‘Kun kami cha nakekkekan ya nakiig-ikop kan he-a ya. Nun-isursuruka pay henan ilimi.’ ");
INSERT INTO ebk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ngem kananantu kasin, ‘Achek challu am-ammu chakayu winnu nan nurpuwanyu. Omachawwi kayu kan ha-un, chakayu am-in ay mangekamkaman as mangotettet!’ ");
INSERT INTO ebk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hesa as chará nan mun-ag-akoranyuntu ya munngesngesatantu nan fiab-ayu kiapú as fungatyu as nan mangil-anyuntu kan Abraham, Isaac, Jacob ya nan am-in ay pomapadtu ay naetatapi as nan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Omalichantu nan tataku ay achi omaafurot ay murpu as apét fomokfoknakian ya mauy-uynuwan nan urkiw, ya as apét senakiangan ya filáng ay maketokor ay makifiasta as nan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Wachacha nan tapina ay anongos ad wani at chichantu nan omon-ona, ya nan tapina ay omon-ona ad wani at chichantu nan omanongos.” ");
INSERT INTO ebk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","As nan hiyachi challu ay uras, wachacha nan tapina ay Fariseo ay inmuy kan Jesus, ya kanancha kan hiya, “Ammay mu mak-akka hena, tay laychun chaká kanu ay patayun kan Ari Herodes.” ");
INSERT INTO ebk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tinumfor hi Jesus kan chicha, “Uyyu ifiakia kan Ari Herodes ay nasikap ay maepachong as nan fuwus un, ‘Mun-epafoknakiak as anennet ya munkaanak as saket ad wani ya as wiet, ya as sang-achum, lopasok nan chunok.’ ");
INSERT INTO ebk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Uray mu hiyasa, masapor ituruyku ay munfiaat ad Jerusalem ad wani, as wiet ya sang-achum, tay maid challu pomapadtu ay matuy as tukún ay lukiar omangkiay ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Chakayu ay i-Jerusalem, penatuyyu nan chiyuycha pomapadtu, ya lenomtakyu nan chiyuycha infiaor Apo Dios kan chakayu. Namen kaat ay lenarayadku ay mang-among kan chakayu am-in ay kaman as nan atun nan mangngak ay mangesakub as enpasna, ngem kunyu paat achi laychun. ");
INSERT INTO ebk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Il-ilaunyu! Nataynan nan siyudadyu! Ifiakiak kan chakayu, achiyaktu kasin il-ilaun inkiana as nan timpu ay mangaliyanyu un, ‘Machaychayaw koma nan omali ay infiaor Apo Dios!’ ” ");
INSERT INTO ebk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","As nan usa ay Urkiw ay Mun-iblayan, uy nakekan hi Jesus as afong nan usa ay ap-apu ay Fariseo. Nan tataku hid-i at sinisiimancha hiya mu ngachana nan atuna. ");
INSERT INTO ebk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wacha as nan sangwanana nan usa ay laraki ay finufumror nan chiyuycha sukina ya takrayna. ");
INSERT INTO ebk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kenalen Jesus as nan chiyuycha Fariseo ya mun-isursuru as Lintig, “Ay eparufus nan Lintig takú ay munkaan as saket as nan Urkiw ay Mun-iblayan winnu achi?” ");
INSERT INTO ebk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ngem kuncha kinkinak. Enayakian Jesus nan chiyuy laraki ya enpaammayna, angkiay enpakatamna. ");
INSERT INTO ebk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Angkiay ya kenalina kan chicha, “Ngachana kan chakayu nan wachay anakna winnu fiakana ay nag-as as nan fufun as nan Urkiw ay Mun-iblayan, ay achiyu uy mun-ara?” ");
INSERT INTO ebk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Maid poros ensongfiatcha kan hiya maepangkep as sa. ");
INSERT INTO ebk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kun pay inilan Jesus ay cha munpili nan tapina ay mangili as kaammayan ay tomokorancha, infiakiana nan nauy usa ay maepachongan kan chicha: ");
INSERT INTO ebk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mu wachay mangayag kan he-a as nan chuyas, achika tomokor as nan kaammayan ay tokoran, tay atun at mu wacha nan am-amud mu he-a ay enayakiana. ");
INSERT INTO ebk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mu omali nan chiyuy nangayag kan chakayu ay chuwa, ya kanana kan he-a, ‘Hiya pay nan tomokor hena.’ Angkiay nafiainanka at a, ya kapeletan ay uyka tomokor as nan apud ay tokoran. ");
INSERT INTO ebk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kun at nan atum as nan maayakianam at uyka tomokor as nan apud ay tokoran ta as nan omaliyan nan nangayag kan he-a at kananantu un, ‘Kiayyum, uyka tomokor as nan kaammayan ay tokoran.’ Angkiay maichayawkantu as nan sangwanan nan am-in ay tapen chi mangili. ");
INSERT INTO ebk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tay nan mangepangatu as achorna at maepababantu, ya nan mangepababa as achorna at maepangatuntu.” ");
INSERT INTO ebk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Angkiay kenalen Jesus as nan nangayag kan hiya, “As nan mangiyayakiam as makan as afongmu as nan kaorkia winnu maschum, achim ayakian nan kiakiayyummu winnu susnúdmu winnu iib-am winnu nan nunkafiaknang ay sasag-unmu. Tay mu hiyasa nan atum, ayakian chakantu us kan chicha, at maafus nan enatmu kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ngem as nan mangiyayakiam as makan as afongmu, nan ayakiam at nan chiyuycha pugli, nakukuy, napilud ya nafurag, ");
INSERT INTO ebk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","at nakiasatkantu. Tay uray mu achicha makaafus as nan enatmu, gun-gunaan chakantu kan Apo Dios as nan matakuwan nan chiyuycha nalintig ay tataku manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kun pay chinngor nan usa ay laraki as nan chiyuycha nakiuufong kan Jesus nan hana maepadpachongan, kenalina kan Jesus, “Nakiasat as solet nan taku ay makiufongtu as nan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ngem kenalen Jesus kan hiya, “Wacha nan usa ay taku ay nunparti as fiaka, ya ongor nan tataku ay enayakiana. ");
INSERT INTO ebk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kun pay timpon chi manganan, inmifiaor hiya as usa as nan chiyuycha fiabfiaaruna ay uy mangifiakia as nan chiyuycha naayakian un, ‘Akayu at, tay naesakiana nan am-in ay makan.’ ");
INSERT INTO ebk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ngem kuncha am-in nunpanfor nan naayakian. Nan enmona ay naayakian at kenalina kan hiya, ‘Pasensiya a, achiyak omali, tay wacha nan kalaklakok ay payyiw, at masapor uyku ilaun.’ ");
INSERT INTO ebk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kenalen us nan usa, ‘Achiyak omali, tay wacha nan hinpuru ay fiaka ay kalaklakok, at masapor uyku pachasun chicha ay mangidnu. Isunga kunak pasensiyaun.’ ");
INSERT INTO ebk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nan usa us at kenalina, ‘Kachuychuyasku met, isunga achiyak makaali.’ ");
INSERT INTO ebk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Angkiay ya nunfiangad nan chiyuy mafiabfiaor, ya infiakiana am-in chaná as nan amona. Finmungat nan amona, ya kanana as nan fiabfiaaruna, ‘Kamuwum ay umuy as nan chiyuycha korsa ya charan henan ili, ya ayakiam nan chiyuycha pugli, nakukuy, nafurag ya napilud.’ ");
INSERT INTO ebk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Uy tit-iwa enayakian nan chiyuy mafiabfiaor chachi, ya kanana as nan amona as nan nunfiangchana, ‘Apo, enatku am-in nan infilinmu, ngem nawaya pay met as fiaruy.’ ");
INSERT INTO ebk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Angkiay kenalen nan amona kan hiya, ‘Umuyka as nan ad-achawwi ay korkorsa ya luglukiar, ya peletum nan tataku ay omali hena ta mapnu nan afongku. ");
INSERT INTO ebk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ifiakiak kan he-a ay am-in nan chiyuycha naayakian ay chaan enmali at maid tamtamancha as nan ensasakianak ay makan.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","As nan namingsan, ongoongor ay tataku nan nakiuy kan Jesus. Nunsakong hi Jesus kan chicha, ya kanana, ");
INSERT INTO ebk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mu ngachana nan taku ay manglayad ay omali kan ha-un ay munfialin as disipulok, masapor ong-ongor nan layadna kan ha-un mu as nan amana, enana, asawana, an-akna, ib-ana ay lanaraki ya fianafiai ya uray as nan achorna. ");
INSERT INTO ebk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nan taku ay achi mangitiin as korosna ya achi umunud kan ha-un at achi mafialin ay munfialin as disipulok. ");
INSERT INTO ebk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mu wacha kan chakayu nan manglayad ay mangkiaub as ad-acha ay afong, ay achina on-ona etokor ay mangnumnum mu wachay sipingna as ommat ay kiastosuna inkiana marpas? ");
INSERT INTO ebk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tay mu enpatakchugna yangkiay nan chiyuycha tukud ya chaana lenpas, nan am-in ay tataku ay mangil-ila as nan hana at ot-otyokunchantu hiya. ");
INSERT INTO ebk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kankananchantu un, ‘Kun lawá enlapon tona ay taku ay munkiaub as ad-acha ay afong ya achina lopasun.’ ");
INSERT INTO ebk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kaman us as nan usa ay ari ay wachay hinpuru ay lifu ay sorchachuna ay uy makikufiat as nan ari ay wachay chuwan puru ay lifu ay sorchachuna at etokorna on-ona ta numnumuna mu kafiaelana ay kufiatun chicha. ");
INSERT INTO ebk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mu achina kafiaelan, umifiaor as manib-at kan tosa ay ari mu achawwicha pay laing ta chumawat as munkennappiaancha. ");
INSERT INTO ebk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Assesa us kan chakayu ay achi kayu mafialin ay munfialin as disipulusku mu achiyu taynan nan am-in ay wacha kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nan asin at ammay, ngem mu chakus nakaan nan tamtamna, achi poros kasin omasin. ");
INSERT INTO ebk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Maid challu kotokna as nan luta winnu as nan mangam-amongan as lumang, kun yangkiay maiwagkia. Nan wachay ingana ay chumngor at masapor chumngor.” ");
INSERT INTO ebk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","As nan namingsan, ongor ay mangam-among as fiaror ya fumafiasor nan enmali as nan kawad-an Jesus ay manngor as nan isursuruna. ");
INSERT INTO ebk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nunmotmot nan chiyuycha Fariseo ya nan chiyuycha mun-isursuru as Lintig ay mangarkali, “Hi tona ay taku at ayakianay fumafiasor ya makekan pay kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Isunga infiakian Jesus kan chicha nan nauy maepadpachongan: ");
INSERT INTO ebk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kaspangarigan, mu nan usa kan chakayu at wachay hinkiasot ay karnerona, ya nalitaw nan usa, ay achina taynan nan chiyuycha siyam puru ya siyam ay karnerona as punchag ta uyna anapun nan chiyuy nalitaw inkiana uchanana? ");
INSERT INTO ebk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","As nan manguchanana, ongor chi lagsakna, ya sakfiatana ay mangesaor. ");
INSERT INTO ebk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","As nan mangesaorana, ayakiana nan sasag-una ya nan kiakiayyumna, ya kanana kan chicha, ‘Makelagragsak kayu kan ha-un, tay ininchanak nan nalitaw ay karnerok.’ ");
INSERT INTO ebk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ifiakiak kan chakayu, assesa us ay ong-ongor chi lagsak ad chaya kiapú as nan munfiafiawiyan nan usa ay fumafiasor mu nan chiyuycha siyam puru ya siyam ay nalintig ay tataku ay achi kis-an munfiafiawi.” ");
INSERT INTO ebk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Inturuy Jesus, “Kaspangarigan, nan usa ay fiafiai at wachay nafiaror ay hinpuru ay silsilyu ay sipingna, ngem nalitaw nan usa. Ngachana nan atuna? Paskuchana nan pingki, ya sakiachana nan chat-orna ay manganaanap inkiana mad-anana. ");
INSERT INTO ebk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Angkiay ya as nan manguchanana, ayakianantu nan sasag-una ya nan kiakiayyumna, ya kanana, ‘Makelagragsak kayu kan ha-un, tay ininchanak nan sipingku ay nalitaw.’ ");
INSERT INTO ebk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ifiakiak kan chakayu, assesa us ay munlagragsak nan angheles Apo Dios as nan munfiafiawiyan nan usa ay fumafiasor.” ");
INSERT INTO ebk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kenalen pay Jesus, “Wacha nan usa ay ama ay chuwa nan pototna ay lanaraki. ");
INSERT INTO ebk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kenalen nan enauchi kan amana, ‘Ama, iyalem pay nan tawidku.’ Kinudwan tit-iwa amacha nan epatawidna kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Kun pay chaan inmuy chi ongor ay urkiw, enlakon nan enauchi nan am-in ay tawidna. Enarana nan am-in ay sipingna ya inmuy henan achaachawwi ay ili. Hid-i nan nangkiastosana as sipingna as nan lenalaschak ay panagfiyag. ");
INSERT INTO ebk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kuna pay kinastos nan am-in ay wacha kan hiya, inumchan nan pararu ay fitel henan lukiar ay anchi, at maid poros nayagyag kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Isunga uy nunchunu as nan usa ay umiili hid-i. Infiaor nan hana umiili as nan kawad-an nan fiafuyna ta hiya nan munpakpakan. ");
INSERT INTO ebk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Laraychuna koma ay masufu as nan uray kanun nan chiyuycha fiafuy, ngem maid poros inmichat kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kun pay nunnumnum ay ustu, kenalina, ‘Ongorcha nan fiabfiaarun amak ay cha sumubsubray kanuncha, ya nauyak hena ay kun lawá kiayud matuy as chukiaang. ");
INSERT INTO ebk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Maligwatak at ay munfiangad kan amak, ya kanaktu kan hiya un, “Ama, nakafiasorak kan Apo Dios ya kaman us kan he-a. ");
INSERT INTO ebk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Achiyak at maekari ay makali un pototmu. Isunga kunak ud-ay ifilang as usa ay fiabfiaarum.”’ ");
INSERT INTO ebk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Naligwat tit-iwa hiya ya nunfiangad kan amana. Ngem kun pay kutug ay achawwi as afongcha, inilan amana hiya, ya ongor chi sug-angna. Tenmagtag hi amana ay nanib-at kan hiya. Enakworna, ya finisituna hiya. ");
INSERT INTO ebk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Angkiay ya kenalen nan pototna, ‘Ama, finmasorak kan Apo Dios ya kaman us kan he-a. Achiyak at maekari ay makali un pototmu.’ ");
INSERT INTO ebk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ngem kenalen amana as nan chiyuycha fiabfiaaruna, ‘Kamuwunyu ay mangiyali as nan kaammayan ay fiachu ya iyammayu kan hiya. Singsinganyu nan limana, ya sapatosanyu hiya. ");
INSERT INTO ebk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Angkiay ya iyaliyu nan tenmafia ay urfun ay fiaka ya partiyunyu as ischa takú ta munlagragsak takú. ");
INSERT INTO ebk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tay nan nauy pototku at kaman natuy, ngem nataku. Kaman us nalitaw hiya, ngem nad-anan.’ Angkiay ya enlapucha ay munlagragsak. ");
INSERT INTO ebk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“As nan hiyachi, nan panguru ay anak at wacha as payyiw. Kun pay cha somaor ya cha maesnop as afongcha, chinngorna nan tokar ya tataku ay cha munsasara. ");
INSERT INTO ebk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Angkiay ya enayakiana nan usa as nan chiyuycha mafiabfiaor, ya senarudsudna kan hiya, ‘Anan cha om-ommat?’ ");
INSERT INTO ebk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Nunfiangad nan enauchem,’ ensongfiat nan mafiabfiaor, ‘at enpaparten amam nan tenmafia ay urfun ay fiaka, tay nunfiangad hiya ay maid mangisiw as enom-ommat.’ ");
INSERT INTO ebk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ngem finmungat nan panguru ay anak ya chaana lenayad ay sungkop. Isunga pinmitiw hi amana ay uy nangay-ayu kan hiya ta sungkop. ");
INSERT INTO ebk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngem kenalen nan anak kan amana un, ‘Kaat ay tawwun nan nunchunchunuwak kan he-a ay kaman usa ay mafiabfiaor, ya maid chaanku tenongpar ay filinmu. Ngem maid poros inchatmu kan ha-un as uray usa ay kianching ta wachay munlagragsakanmi as nan kiakiayyumku. ");
INSERT INTO ebk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ngem kun pay kenmatam nan nauy pototmu ay nangamin as kuk-uwam kiapú as fianafiai ay mangepabpafiayad as achorcha, enpartiyam hiya as tenmafia ay fiaka ay urfun!’ ");
INSERT INTO ebk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Angkiay kenalen amana un, ‘Anakku, kanayon met ay wachaka kan ha-un, ya nan am-in ay wacha kan ha-un at kuk-uwam us. ");
INSERT INTO ebk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngem masapor challu munselebrar ya munlagragsak takú, tay nan ifiam at kaman natuy, ngem nataku. Kaman us nalitaw hiya, ngem nad-anan.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nun-epadpachong kasin hi Jesus as nan disipulusna, “Wacha nan usa ay nafiaknang ay nangetalek as kuk-uwana as nan mun-ay-aywanuna. Naifiakia as nan nafiaknang ay nan sipingna at cha kiaskiastosun nan nauy mun-ay-aywan. ");
INSERT INTO ebk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Enpaayag nan nafiaknang hiya, ya kanana un, ‘Ngachana nan nauy machamchamagku maepangkep kan he-a? Iyalem nan lestaan nan am-in ay entalekku kan he-a, tay fiakun at he-a nan mun-aywanok.’ ");
INSERT INTO ebk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kenalen nan mun-ay-aywan as numnumna un, ‘Anan atok ngun, tay fiakuntu ha-un nan mun-aywanun nan amok? Achek met kafiaelan ay munpara ya mafiainak met us ay munlemos. ");
INSERT INTO ebk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, ammok nan atok ta wachay mangayag kan ha-un as nan kiakiayyumku as afongcha as nan makaanak as nan chunok.’ ");
INSERT INTO ebk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Isunga hinin-us-ana ay nangayag as nan tataku ay inmutang as nan amona ay nafiaknang, ya kanana as nan omona un, ‘Kaatna nan utangmu as nan amok?’ ");
INSERT INTO ebk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Hinkiasot ay lata ay mantika,’ ensongfiatna. Kenalen nan mun-ay-aywan un, ‘Nauy nan lestaan nan utangmu. Kamuwum ay tomokor, ya nan isuratmu ud-ay at leman puru.’ ");
INSERT INTO ebk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Angkiay ya kenalina as nan usa un, ‘He-a ngay, kaatna nan utangmu?’ ‘Hinkiasot ay kafian ay fukias,’ ensongfiatna. Kenalen nan mun-ay-aywan un, ‘Nauy nan lestaan nan utangmu. Ayu, nan isuratmu ud-ay at waron puru.’ ");
INSERT INTO ebk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Chinayaw nan amona nan kenasikap nan mun-ay-aywanuna ay achi mapiyar. Tay tit-iwa ay nan tataku ay achi omafurot kan Apo Dios at nasiksikapcha as nan chacha at-atun mu nan omafurot kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ifiakiak ngarud kan chakayu ay osarunyu nan kenafiaknangyu asna's luta ay makikiayyum as nan pachongyu ay tataku. Mu hiyasa ay mam-in, maawat kayuntu ad chaya ay magyananyu in-inkiana. ");
INSERT INTO ebk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Nan taku ay matalek as nan ak-akettuy at matalek us as nan chamchamuna. Kun pay nan taku ay achi mapiyar as nan ak-akettuy at achi us mapiyar as nan chamchamuna. ");
INSERT INTO ebk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Isunga mu achika mapiyar ay mangosar as nan kenafiaknang ay wacha asna's luta, anan mangetalektu kan he-a as nan tit-iwa ay kenafiaknang? ");
INSERT INTO ebk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kaman us mu achika mapiyar ay mangaywan as nan kuk-uwan chi tapina, anan mangichattu kan he-a as nan kuk-uwam? ");
INSERT INTO ebk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Maid mafiabfiaor ay munserfi as chuwa ay amo. Tay mu atuna sa, iinglunantu nan usa ya laylaychuna nan usa, winnu oononguna nan usa ya elalayusana nan usa. Achiyu mafialin ay munkisanun ay serfiyan hi Apo Dios ya nan siping.” ");
INSERT INTO ebk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kun pay chinngor nan chiyuycha Fariseo nan nauycha am-in ay infiakian Jesus, enot-otyokcha hiya, tay nan laylaychuncha at siping. ");
INSERT INTO ebk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ngem kenalen Jesus kan chicha, “Chakayu nan cha mangepappaila ay kaman kayu nalintig as nan mangiilan nan tataku, ngem aammon challu Apo Dios nan wacha as numnumyu. Tay nan amud as nan mangiilan nan tataku at maid kotokna as nan mangiilan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Nan Lintig Moises ya nan insurat nan chiyuycha pomapadtu at naun-unud inkiana as nan timpon Juan ay Fumufunyag. Nunlapu as nan hiyachi, naekasaba nan Ammay ay Chamag maepangkep as nan muntorayan Apo Dios, at waschi un epapeletna ay maetapi. ");
INSERT INTO ebk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngem narakraka ay mamaid nan chaya ya nan luta mu nan kaek-ektelan ay surat as nan Lintig.” ");
INSERT INTO ebk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kenalen us Jesus, “Nan ngachana ay laraki ay mangiyichang as asawana ya kasin omasawa as tukún at umiwet. Kaman us as nan laraki ay mangasawa as nan fiafiai ay naiyichang at umiwet.” ");
INSERT INTO ebk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Inturuy pay Jesus, “Wacha nan usa ay nafiaknang ay kanayon ay nangafiachu as nunkangina, ya inurkiw ay lenalaschak chi panagfiyagna. ");
INSERT INTO ebk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wacha us nan usa ay pugli ay nan ngachana at Lazaro ay nakulid nan intiru ay achorna. Inurkiw ay naiyuy hiya as nan pantiw nan fiaknang. ");
INSERT INTO ebk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Laraychuna ay mangkakan as nan uray nunkag-as ay makan ay nurpu as nan lamesaan nan fiaknang. Uray nan chiyuycha asu at uycha chinilchilchilan nan ongoongor ay kulidna. ");
INSERT INTO ebk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Natuy nan pugli, ya inyuy nan angheles hiya as nan kawad-an Abraham. Natuy us nan fiaknang, ya nailufok. ");
INSERT INTO ebk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Angkiay ya naiyuy hiya ad Hades ay hid-i nan chana munliglikiatan. As nan kawad-ana's chi, nuntangad, ya inilana hi Abraham ay wacha as nan achawwi ya hi Lazaro ay naichachapat kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Isunga infukiawna un, ‘Ama Abraham, sug-anganak man paat! Ifiaormu pay hi Lazaro ay mangisiwsiw as limana as nan chanum, ya epatidtidna as nan chilak ta tumungnin, tay ad-achiyan chi chak iliwas kiapú as nan atong nan nauy apuy.’ ");
INSERT INTO ebk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ngem kenalen Abraham kan hiya, ‘Anakku, numnumum ay as nan natatakuwam at naichat nan am-in ay anam-ammay kan he-a. Kun pay hi Lazaro at manangisiw nan naichat kan hiya. Ad wani, hiya nan cha maliwliwa hena, ya he-a nan cha munliglikiat hesa. ");
INSERT INTO ebk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Fiakun yangkiay sa, tay nauy challu nan narawarawa ay kaman teng-el ay maid papugna as nan nunkiakiaw-an takú ta achi mafialin ay nan murpu hena at makaali hesa kan chakayu, winnu nan murpu hesa at achi makaali hena kan chakami.’ ");
INSERT INTO ebk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tinumfor nan fiaknang, ‘Ama Abraham, chawatok ngarud ay ifiaormu hi Lazaro ay umuy as afong cha amak ");
INSERT INTO ebk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ta uyna fiagfiag-an nan lema ay susnúdku hid-i ta achicha us omali hena ay kawad-an chi likiat.’ ");
INSERT INTO ebk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ngem kenalen Abraham, ‘Wacha met kan chicha nan liblu ay insurat Moises ya nan chiyuycha pomapadtu ay manukun kan chicha. Kikiadcha nan susnúdmu ay chumngor kan chicha.’ ");
INSERT INTO ebk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Tinumfor nan fiaknang, ‘Aw, achi ommat sa Ama Abraham! Ngem mu wachay mataku as nan nunkatuy ay umuy kan chicha, munfiafiawichantu as nan fiasfiasorcha.’ ");
INSERT INTO ebk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ngem kenalen Abraham, ‘Mu achicha challu afurotun nan insurat Moises ya nan chiyuycha pomapadtu, achicha challu maawis ay omafurot uray mu wachay mataku ay natuy ay umuy kan chicha.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kenalen Jesus as nan disipulusna, “Tit-iwa ay umchan challu nan chiyuycha sulisug ay fumasoran chi tataku, ngem kasusug-ang nan taku ay kurpuwana. ");
INSERT INTO ebk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Un-unuyna at mu kun maetekor chi losóng ay fiatu as fiakiangna, ya maichus-or hiya henan fiayfiay mu nan munlumuwana as fumasoran chi uray usa as nan nauycha ap-apud ay tataku. ");
INSERT INTO ebk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Isunga il-ilaunyu at! “Mu fumasor nan ifiam at sengaram. Mu munfiafiawi at pakawanum. ");
INSERT INTO ebk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mu mamen pitu ay fumasor hiya kan he-a as nan hin-urkiw, ya mamen pitu ay omali kan he-a ay mangali un, ‘Munfiafiawiyak’ at masapor pakawanum hiya.” ");
INSERT INTO ebk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kenalen nan apostoles as nan Apo, “Papigsaum pay nan pammatimi.” ");
INSERT INTO ebk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tinumfor nan Apo, “Mu wachay pammatiyu ay maepachong as nan kaad-achan nan fokel chi mostasa, mafialinyu ay kanan as nan nauy kaiw ay sikomoro un, ‘Mafiagnotka ya maetanumka henan fiayfiay,’ at tongparunantu nan ifiakiayu.” ");
INSERT INTO ebk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kenalen pay Jesus, “Kaspangarigan, mu wachay usa kan chakayu ay wachay fiabfiaaruna ay cha mun-ar-arachu winnu cha mun-ay-aywan as nan chiyuycha karnero. As nan somaorana, ay kanam kan hiya un, ‘Aka ta manganka’? Achim met. ");
INSERT INTO ebk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kunmu at kanantu kan hiya un, ‘Kamuwum ay uy munlutu. Munsokatka ya esakianam nan kanok, angkiay sad-unak inkiana maafusak. As nan marpasak, mafialinka ay mangan.’ ");
INSERT INTO ebk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ay kis-anka munyaman as nan fiabfiaarum kiapú ta tenongparna nan infilinmu? Achi! ");
INSERT INTO ebk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kaman us kan chakayu as nan nangekamananyu as nan am-in ay naifilin ay atunyu, kananyu un, ‘Kun kami lawá mafiabfiaor, at kunmi yangkiay enat nan chunumi.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","As nan cha umuyan cha Jesus ad Jerusalem, inuycha nan nunkiakiaw-an nan Samaria ya Galilea. ");
INSERT INTO ebk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kuncha pay cha umuy henan usa ay fiabruy, wachacha at nan hinpuru ay nunkakonet ay nanib-at kan hiya. Tenmakchugcha as nan ad-achawwi as akét, ");
INSERT INTO ebk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ya infukiawcha, “Apo Jesus! Sug-angam man paat chakami!” ");
INSERT INTO ebk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kun pay inilan Jesus chicha, kenalina, “Uy kayu munpaila as nan papachi.” As nan chacha umuyan, enmammaycha at. ");
INSERT INTO ebk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kun pay inilan nan usa kan chicha ay enmammay hiya, nunfiangad ay mangipipigsa ay mangichaychayaw kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nunlukfub as nan sangwanan Jesus, ya nunyaman. Hi tud-i ay taku at i-Samaria. ");
INSERT INTO ebk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Angkiay kenalen Jesus, “Kun ngun hinpuru nan nakaan chi konetcha. Ay chaud ngay nan siyam? ");
INSERT INTO ebk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Adchi t'uy kun yangkiay nan nauy kaili nan nunfiangad ay munyaman kan Apo Dios?” ");
INSERT INTO ebk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Angkiay kenalen Jesus kan hiya, “Tomakchugka ya komatamka. Nan pammatem nan nangepaammay kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wachacha nan tapina ay Fariseo ay nangesarochakchak kan Jesus mu kaatnay omaliyan nan muntorayan Apo Dios asna's luta. Tinumfor hiya kan chicha, “Nan muntorayan Apo Dios at omalintu ay maid sinyar ay maepaila ");
INSERT INTO ebk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","winnu maid mangali un, ‘Nauy hena,’ winnu ‘Chiyuy hid-i!’ tay wacha at kan chakayu nan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Angkiay kenalen Jesus as nan disipulusna, “Wachantu nan timpu ay laraychunyu ay mangila as nan Naepadtu ay Anak chi Taku as uray henkemad, ngem achiyu maila. ");
INSERT INTO ebk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wachachantu nan mangali kan chakayu, ‘Enha, chiyuy hid-i!’ winnu ‘Enha, nauy hena!’ Ngem achiyu uy an-anapun hiya. ");
INSERT INTO ebk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tay kaman as nan machiyatan nan fiakilat ay manilaw am-in ad chaya at assid-i us nan kasin omaliyan nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngem masapor mun-iliwas hiya on-ona as ongor ay likiat ya achiyun nan nauy ay kianak. ");
INSERT INTO ebk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“As nan kasin omaliyan nan Naepadtu ay Anak chi Taku, nan ukialen nan tataku at kaman as nan ukialen nan tataku as nan timpon Noe. ");
INSERT INTO ebk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Cha mangmangan, umig-ikop, ya maas-asawa nan tataku inkiana as nan urkiw ay nunlukianan cha Noe as nan papor. Angkiay napsong nan intiru ay luta, ya nurningcha am-in. ");
INSERT INTO ebk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kaman us as nan timpon Lot ad Sodoma. Waschi un cha mangmangan ya cha umig-ikop, cha lomaklaku ya cha mun-el-elaku, cha muntantanum, ya cha munkiagkiaub as afong. ");
INSERT INTO ebk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kun pay as nan urkiw ay nak-akan Lot ad Sodoma, kalina at ya nag-aschay apuy ya asofre ay nurpu ad chaya ay namatuy kan chicha am-in. ");
INSERT INTO ebk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Assesantu us nan ommat as nan urkiw ay maepail-an kasin nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“As nan hana ay urkiw, nan taku ay wacha as tabfongan nan afongna at achi kis-an sungkop ay mangara as kinakuna. Kaman us as nan senmepot at achi kis-an somaor. ");
INSERT INTO ebk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Numnumunyu nan enommat as nan asawan Lot! ");
INSERT INTO ebk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nan uray ngachana ay mangepapati ay mangesarakan as fiyagna at litawuna challu. Ngem mu ngachana nan manglitaw as fiyagna kiapú kan ha-un at maesarakantu. ");
INSERT INTO ebk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ifiakiak kan chakayu, as nan hana ay lafi ay omaliyak, wachachantu nan chuwa ay tataku ay munchachapat ay mamassuy. Maarantu nan usa, ya mayagyagtu nan usa. ");
INSERT INTO ebk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wachachantu nan chuwa ay fianafiai ay cha mun-assud ay munfiayu. Maarantu nan usa ya mayagyagtu nan usa. ");
INSERT INTO ebk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wachachantu nan chuwa ay lanaraki as payyiw. Maarantu nan usa ya mayagyagtu nan usa.” ");
INSERT INTO ebk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Angkiay ya senarudsud nan disipulus kan Jesus, “Ay chaud man nan ommatan nan nauycha, Apo?” Tinumfor hi Jesus kan chicha, “O, matongpartu chaná ay kaman as nan kanana un, ‘Mu ay chaud nan kawad-an nan natuy, hid-i nan maamongan nan anad-acha ay kossel ay mangkakan as achor ay natuy.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Infiakian Jesus nan usa ay maepadpachongan as nan disipulusna ta isuruna chicha ay masapor kanayon ay munkarkararagcha ya achicha maichun nan namnamacha. ");
INSERT INTO ebk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kenalina, “Henan usa ay ili, wacha nan usa ay huwis ay chaan inmug-ugyat kan Apo Dios ya chaana rinisrispitu nan pachongna ay taku. ");
INSERT INTO ebk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wacha nan usa ay ellakas henan hana ay ili ay cha umuumuy as nan huwis. Chana kanakanan un, ‘Fiadnganak man paat ay mangamis as nan kafusorku.’ ");
INSERT INTO ebk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nafiayag ay chaan en-enat nan huwis nan cha chawachawatun nan ellakas. Ngem as nan anongosna, kenalina as achorna, ‘Uray mu achiyak umugyat kan Apo Dios ya achek rispituwun nan pachongku ay taku, ");
INSERT INTO ebk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kunku at fiadngan nan nauy ellakas ay mangamis as nan kafusorna, tay kunak lilifokun. Mu achek ichat nan kalintikiana, kun cha omalialintu ay omepaayu.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kenalen pay Apo Jesus, “Chinngoryu nan kenalen nan hana achi nalintig ay huwis. ");
INSERT INTO ebk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ay hi Apo Dios at paat nan achi mangichat as kalintikian nan tataku ay pinilina ay cha chumawachawat as fiachangna as inurkiw ya lenafi? Ay iyaawnina ay mangfiachang kan chicha? Achi! ");
INSERT INTO ebk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ifiakiak kan chakayu, mun-ichatnantu kan chicha nan kalintikiancha. Ngem as nan munfiangchantu nan Naepadtu ay Anak chi Taku, ay wachantu ngun chi uchanana ay omaafurot asna's luta?” ");
INSERT INTO ebk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Infiakian us Jesus nan nauy maepadpachongan as nan tataku ay nangepangpangas as kenalintigcha ya nangelalayus as pachongcha ay tataku. ");
INSERT INTO ebk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wacha nan chuwa ay lanaraki ay inmuy as nan Templo ay uy nunkararag. Nan usa at Fariseo, ya nan usa at mangam-among as fiaror. ");
INSERT INTO ebk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tenmataak ay nangatakchug nan Fariseo ya nunkararag as maepangkep as achorna. Kenalina, ‘Apo Dios, munyamanak kan he-a, tay achiyak kaman as nan tapina ay tataku ay naakum, somasator, umiiwet, winnu uray kaman kan tona ay mangam-among as fiaror. ");
INSERT INTO ebk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mun-ayunarak as chuwa ay urkiw as nan makachumingku, ya ichatku pay kan he-a nan pagkapuron nan am-in ay lagfok.’ ");
INSERT INTO ebk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ngem nan mangam-among as fiaror at tenmakchug as nan ad-achawwi. Achi poros muntangad ad chaya, ngem kuna at cha tibtib-ukun nan tagrangna, ya kanana un, ‘Apo Dios, masug-angka man paat kan ha-un ay usa ay fumafiasor.’ ");
INSERT INTO ebk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ifiakiak kan chakayu ay nan nauy mangam-among as fiaror at kenmatam ay naifilang as nalintig as nan sangwanan Apo Dios, ngem nan Fariseo at chaan. Tay nan mangepangatu as achorna at maepababantu, ya nan mangepababa as achorna at maepangatuntu.” ");
INSERT INTO ebk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","As nan namingsan, wachacha nan cha mangiyuy as ongong-a kan Jesus uray manutun ta kaprosuna ay mangbendisyon kan chicha. Kun pay inilan nan disipulusna, senengarancha chicha. ");
INSERT INTO ebk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ngem enayakian Jesus nan ongong-a, ya kanana as nan disipulusna, “Yasa! Pay-anyu ay omali nan ongong-a kan ha-un. Achiyu epawa, tay nan tataku ay maepachong kan chatona ay ongong-a nan maetapi as nan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ifiakiak kan chakayu nan tit-iwa ay nan achintu mang-awat as nan muntorayan Apo Dios ay kaman as nan atun nan usa ay onga at achintu poros makaskop henan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nunsarudsud nan usa ay ap-apon chi Judio kan Jesus, “Ammay ay Misturu, ngachana man nan masapor ay atok ay manawid as nan fiyag ay maid patingkiana?” ");
INSERT INTO ebk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kenalen Jesus kan hiya, “Adchi t'uymu kanan un ammayak? Maid poros tukún as ammay omangkiay hi Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ammom met nan filfilin Apo Dios: ‘Achika umiwet, achika pomatuy, achika mangakiw, achika munkutum ay muntistigu, ya rispituwum cha amam kan enam.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kenalen nan laraki, “Nunlapu as nan kaongak at enafurotku met am-in chaná.” ");
INSERT INTO ebk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kun pay chinngor Jesus na, kenalina, “Wacha pay nan usa ay nunkurangam. Elakom am-in nan kuk-uwam, ya ichatmu nan lakuna as nan chiyuycha pugli, at wachantu nan kenafiaknangmu ad chaya. Kun pay marpas, unuchunak.” ");
INSERT INTO ebk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngem kuna pay chinngor na, nginmuyus, tay nafiaknang hiya as solet. ");
INSERT INTO ebk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Inilan Jesus ay nginmunguyus hiya, ya kanana, “Anuy paat nalikiat ay sungkop nan chiyuycha wachay kenafiaknangcha henan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Narakraka pay ay lumfot nan kamelio as nan los-ok nan chakum mu nan fiaknang ay sungkop henan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ensarochakchak nan chiyuycha nanngor as na, “Ngachancha ngay ngarud nan mafialin ay maesarakan?” ");
INSERT INTO ebk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tinumfor hi Jesus, “Nan achi kafiaelan nan tataku ay ekaman at kafiaelan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kenalen Pedro, “Enham! Tenaynanmi nan pamilyami, ya inmunud kami kan he-a!” ");
INSERT INTO ebk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kenalen Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa ay nan nanaynan as afongna, asawana, susnúdna, chanakchakorna winnu an-akna kiapú as nan muntorayan Apo Dios ");
INSERT INTO ebk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","at ong-ongortu nan awatuna ad wani ay timpu, ya awatunantuy fiyag ay maid patingkiana as tapen chi urkiw.” ");
INSERT INTO ebk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ensakiken Jesus nan hinpuru ya chuwa ay disipulusna, ya kanana kan chicha, “Chumngor kayu! Cha takú tumikid ad Jerusalem, ya nan am-in ay insurat nan chiyuycha pomapadtu maepangkep as nan Naepadtu ay Anak chi Taku at matongpartu. ");
INSERT INTO ebk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Maipurangtu hiya as nan chiyuycha Gentil ay mangot-otyoktu, mangpabpafiaintu ya mangtubtubfiantu kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sapletunchantu ya patayunchantu hiya. Ngem as nan maekatlu ay urkiw at matakuntu hiya manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ngem maid poros naawatancha as nan kenalina. Nan laychuna ay kanan at naililingub kan chicha, ya achicha challu ammu nan cha kankanan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kun pay kiayud umchan hi Jesus ad Jerico, wacha nan usa ay laraki ay nafurag ay cha munlemlemos ay nangatokor as nan olet nan korsa. ");
INSERT INTO ebk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kuna pay chinngor ay ongor chi cha mar-os ay tataku, ensarochakchakna, “Ngachana man nan cha om-ommat?” ");
INSERT INTO ebk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Cha mar-os hi Jesus ay i-Nazaret,” kenalicha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Infukiaw nan nafurag, “Jesus ay Kianak David, sug-anganak man paat!” ");
INSERT INTO ebk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nan nangepapangu ay tataku at senengarancha hiya, ya chacha ifiakia kan hiya ay kuminak koma hiya. Ngem kenaskasina infukiaw, “Kianak David, sug-anganak man paat!” ");
INSERT INTO ebk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Inyawnen Jesus, ya infilina ay iyalicha kan hiya nan nafurag. Kun pay naesnop nan nauy nafurag, senarudsud Jesus kan hiya, ");
INSERT INTO ebk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngachana nan laychum ay atok kan he-a?” “Apo, makailaak koma,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kenalen Jesus kan hiya, “Makaila ka at! Nan pammatem nan nangepaammay kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hiya at chi ya makaila nan nafurag, at inmunud kan Jesus ya cha munchaychayaw kan Apo Dios. Uray us nan am-in ay tataku ay nangila as nan enommat at chinaychayawcha hi Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Inumchan hi Jesus ad Jerico ya cha mar-os henan hana ay ili. ");
INSERT INTO ebk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wacha nan nafiaknang hid-i ay ap-apon chi mangam-among as fiaror ay nan ngachana at Zakeo. ");
INSERT INTO ebk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Laraychuna ay ilaun mu kaassenan Jesus, ngem achina maila, tay ongor chi tataku ya ap-aptek hiya. ");
INSERT INTO ebk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Isunga tenmagtag ay enmon-ona, ya kenmarab as nan kaiw ay sikomoro ta ilauna hi Jesus, tay mar-ostu hid-i. ");
INSERT INTO ebk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kun pay inumchan hi Jesus as nan kawad-an Zakeo, nuntangad, ya kanana, “Zakeo, kamuwum ay komsop, tay masapor chumawusak as afongmu ad wani ay urkiw.” ");
INSERT INTO ebk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kenamon tit-iwa Zakeo ay kenomsop, ya ongor chi lagsakna ay nangmangili kan Jesus as afongna. ");
INSERT INTO ebk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Angkiay ya am-in nan tataku ay nangila as na at enlapucha ay munmotmot. Kenalicha, “Nakkuran! Uy nunpamangili as nan taku ay fumafiasor.” ");
INSERT INTO ebk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tenmakchug hi Zakeo, ya kanana as nan Apo, “Apo, chumngorka man paat. Ichatkuntu nan kakudwan nan kuk-uwak as nan pugli, ya mu wachay senatorku, ifiangadkuntu kan hiya as mamen opat ay kaongor mu nan enarak kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kenalen Jesus kan hiya, “Ad wani ay urkiw, naesarakan nan nauy ay hinfiaruy, tay hiya at usa us as nan nalitaw ay kianak Abraham. ");
INSERT INTO ebk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tay nan Naepadtu ay Anak chi Taku at enmali ay manganap ya mangesarakan as nan nalitaw.” ");
INSERT INTO ebk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kun pay cha epappapanaakian nan tataku chaná, inturuy Jesus ay nangosar as maepadpachongan kiapú ta kiayud umchan hiya ad Jerusalem ya kiapú ta ka-anan nan tataku ay munpaila ay dagus nan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Isunga kenalina, “Wacha nan usa ay mafigfigfig ay taku ay inmuy as nan achaachawwi ay lukiar ta uy machutokan as ari. Angkiay ya munfiangad ay mun-ari henan mismu ay ilina. ");
INSERT INTO ebk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sakbay mak-ak hiya, enayakiana nan hinpuru ay fiabfiaaruna, ya inchatna kan chicha nan hin-us-a ay fialetok ay siping. Kenalina kan chicha, ‘Nauy nan munpoonanyu ay munnigusyu inkiana munfiangachak.’ ");
INSERT INTO ebk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ngem iningor nan kakailiyana hiya, at inmifiaorcha as mangunud kan hiya ay mangifikia kan Emperador un, ‘Achimi laychun hiya ay mun-ari kan chakami.’ ");
INSERT INTO ebk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nachutokan challu ay mun-ari nan chiyuy mafigfigfig ay taku. “As nan nunfiangchana, enpaayagna nan chiyuycha fiabfiaaruna ay nangichatana as nan siping ta ammuwuna mu kaatna nan kiaransiyacha. ");
INSERT INTO ebk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Inmuy nan omona, ya kanana, ‘Apo, nunkiaransiya as hinpuru nan chiyuy usa ay fialetok ay inchatmu.’ ");
INSERT INTO ebk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Ammay nan enatmu,’ ensongfiat nan ari. ‘Ammayka ay mafiabfiaor! Kiapú ta matalekka as nan ak-akettuy, ichatku kan he-a nan kalibfengan ay mangetoray henan hinpuru ay siyudad.’ ");
INSERT INTO ebk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Inmuy nan maekadwa, ya kanana, ‘Apo, nunkiaransiya as lema nan usa ay siping ay fialetok ay inchatmu.’ ");
INSERT INTO ebk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tinumfor hiya, ‘Ichatku kan he-a nan kalibfengan ay mangetoray henan lema ay siyudad.’ ");
INSERT INTO ebk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Inmuy nan usa ay mafiabfiaor, ya kanana, ‘Apo, nauy challu nan sipingmu ay intupugku ay lenekfotak as nan panyok. ");
INSERT INTO ebk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Inmugyatak ngamin kan he-a, tay istriktuka ay taku. Kum lawá araun chi fiakunmu nunforayan, ya aniyum chi fiakunmu tinunud.’ ");
INSERT INTO ebk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Mangotettet chi ukialem ay mafiabfiaor,’ ensongfiat nan ari, ‘Chusaok he-a kiapú as nan hanacha kenalem. Ammom met ay istriktuwak ay taku ay mangara as fiakunku nunforayan ya mangani as fiakunku tinunud. ");
INSERT INTO ebk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Adchi ngarud t'uymu chaan indiposito nan sipingku as bangko ta as nan mungfiangchak at araok ay wachay interesna?’ ");
INSERT INTO ebk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“As nan hiyachi, kenalen nan ari as nan chiyuycha nangatakchug hid-i, ‘Araunyu nan siping kan hiya, ya ichatyu as nan naichatan nan hinpuru.’ ");
INSERT INTO ebk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“(Ngem kenalicha kan hiya, ‘Apo, wacha met mampay nan hinpuruna!)’ ");
INSERT INTO ebk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Tinumfor hiya, ‘Nan taku ay wachay kafiaelana at maettan as ong-ongor. Ngem nan taku ay maid kafiaelana, uray nan ak-akettuy ay wacha kan hiya at maarantu. ");
INSERT INTO ebk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ngem mu maepangkep as nan chiyuycha kafusorku ay chaan nanglayad ay etorayak chicha, iyaliyu chicha hena, ya patayunyu as nan sangwanak.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kun pay narpas ay infiakian Jesus na, enmon-ona hiya ay enmabrat ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kun pay cha maesnop hiya ad Betfage ya Betania henan chuntug ay Olivo, enpaon-onana nan chuwa as nan disipulusna. ");
INSERT INTO ebk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kenalina, “Uy kayu henan fiabruy ay sasakiangunyu. As nan umchananyu hid-i, uchananyu nan usa ay dongki ay urfun ay naetatakud ay chaan pay nasaksakayan. Fokatanyu, ya iyaliyu hena. ");
INSERT INTO ebk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mu wachay munsarudsud kan chakayu un, ‘Adchi t'uyyu cha fokatan sa?’ kananyuntu, ‘Masapor nan Apo.’” ");
INSERT INTO ebk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Inmuycha ngarud nan chiyuycha naifiaor, ya ininchanancha tit-iwa nan infiakiana kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kuncha pay cha fokatan nan dongki ay urfun, kenalen nan chiyuycha nakin kuwa as nan dongki kan chicha, “Adchi t'uyyu cha fokatan nan dongki ay urfun?” ");
INSERT INTO ebk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Masapor nan Apo,” kenalicha. ");
INSERT INTO ebk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Angkiay ya inyalicha nan urfun kan Jesus. Inyap-apcha nan chiyuycha kakiaycha as nan uchug nan nauy urfun, ya enpasakaycha hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kun pay cha mar-os hi Jesus ay nunsasakay as nan urfun, nan tataku at inyapragcha nan chiyuycha kakiaycha as nan korsa. ");
INSERT INTO ebk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","As nan cha maesnopan Jesus ad Jerusalem, as nan chayyuwan ay nurpu henan chuntug ay Olivo, enlapon nan ongoongor ay disipulusna ay munlagragsak ya inpipigsacha ay nangichaychayaw kan Apo Dios kiapú as nan am-in ay nakaskaschaaw ay inil-ilacha. ");
INSERT INTO ebk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Infugfukiawcha, “Mabendisyonan koma nan Ari ay omali as nan ngachan nan Apo! Wachay kappia ad chaya, ya maichaychayaw hi Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ngem nan tapina ay Fariseo ay naetatapi as nan ongor ay tataku at kenalicha kan Jesus, “Misturu, pakinkum man nan nauycha disipulusmu!” ");
INSERT INTO ebk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tinumfor hi Jesus, “Ifiakak kan chakayu ay mu ikinak chatona, nan chiyuycha fiatu nan munfukiaw.” ");
INSERT INTO ebk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","As nan cha maesnopan Jesus ad Jerusalem, nun-akor hiya as nan nangil-ana henan siyudad. ");
INSERT INTO ebk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kenalina, “Chakayu ay i-Jerusalem, mu kunyu naammuwan uray ad wani nan kasaporan ta makekappia kayu kan Apo Dios. Ngem ad wani, naililingub at kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Omalintu nan urkiw ay nan chiyuycha kafusoryu at arachuncha nan siyudadyu, liktufun chakayu, ya sokokun chakayu as nan am-in ay suli. ");
INSERT INTO ebk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chachaelunchantu as solet nan siyudadyu, ya uray us chakayu ay umiili hesa at patayuncha. Maidtu yagyakuncha as uray usa ay fiatu as nan naetotor-opana, tay chaanyu enmatonan nan timpu ay enmaliyan Apo Dios ay mangesarakan koma kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kun pay inumchan hi Jesus ad Jerusalem, sinungkop as nan fiattaw nan Templo. Enlapuna ay mangepak-ak as nan chiyuycha cha mun-el-elaku hid-i. ");
INSERT INTO ebk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kenalina kan chicha, “Wacha nan naisurat as nan Kalen Apo Dios ay kanana un, ‘Nan afongku at munkarkararakian.’ Ngem kunyu at nunfialinun as muntabtafunan chi mangaakiw!” ");
INSERT INTO ebk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Inurkiw ay cha mun-is-isuru hi Jesus as nan Templo. Nan anap-apon chi papachi, nan mun-isursuru as Lintig ya nan tapina ay anap-apu at chacha anapun mu anan atuncha ay mangpatuy kan Jesus, ");
INSERT INTO ebk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ngem maid atuncha. Tay am-in nan tataku at epapanaagcha nan chana kankanan. ");
INSERT INTO ebk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","As nan hin-urkiw ay cha mun-is-isuruwan Jesus as nan tataku as Templo ya as nan chana mangekaskasabaan as nan Ammay ay Chamag, inmuy kan hiya nan anap-apon chi papachi, mun-isursuru as Lintig ya nan anam-amá. ");
INSERT INTO ebk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kenalicha, “Ayu, ifiakiam kan chakami mu anan nurpuwan nan kalibfengam ay cha mangekamkaman as na, winnu ngachana nan nangichat kan he-a as nan nauy ay kalibfengan.” ");
INSERT INTO ebk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tinumfor hi Jesus, “Wacha us nan sarudsuchok kan chakayu. Ifiakiayu man us kan ha-un ");
INSERT INTO ebk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","mu anan nurpuwan nan kalibfengan Juan ay munfunyag. Ay nurpu kan Apo Dios winnu as nan tataku?” ");
INSERT INTO ebk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Angkiay kenalicha ay maaapat, “Mu kanan takú un, ‘Nurpu kan Apo Dios,’ kananantu un, ‘Anuyyu ngarud chaan enafurot hi Juan?’ ");
INSERT INTO ebk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ngem mu kanan takú un, ‘Nurpu as nan tataku,’ lomtakun chitakuntu as nan am-in ay tataku, tay afurotuncha ay hi Juan at usa ay pomapadtu.” ");
INSERT INTO ebk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Isunga nan ensongfiatcha at achicha ammu nan nurpuwan nan kalibfengana. ");
INSERT INTO ebk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kenalen Jesus kan chicha, “Mu hiyasa, achek us ifiakia kan chakayu mu ngachana nan nakin kalibfengan as nan chak mangekamkamanan kan chatona.” ");
INSERT INTO ebk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Angkiay ya infiakian Jesus nan nauy ay maepadpachongan as nan tataku: “Wacha nan usa ay taku ay nuntanum as ongor ay ubas as umana. Kuna pay enpaamma as nan chiyuycha mun-umauna, nunfiaat henan achawwi ay lukiar ya nafiayag hid-i. ");
INSERT INTO ebk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kun pay inumchan nan timpon chi munpurasan, infiaorna nan fiabfiaaruna as nan chiyuycha nun-uumauna ta uyna araun nan kudwan nan amona ay ubas ay naapet as nan umana. Ngem kun at senaplesaplet nan chiyuycha nun-uumauna hiya, angkiay enpafiangadcha hiya ay maid in-inchatcha. ");
INSERT INTO ebk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kun pay narpas sa, infiaorna us nan usa, ya kuncha us senaplesaplet, penafiainan, angkiay enpafiangadcha hiya ay maid in-inchatcha. ");
INSERT INTO ebk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Infiaorna nan maekatlu. Finakagcha hiya, ya inchus-orcha as nan fiakun sakop nan uma. ");
INSERT INTO ebk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kenalen nan nakin kuwa as nan uma un, ‘Anan atok ngun? A! Ifiaorku nan laylaychok ay anakku. Urum ya mafiainchantu kan hiya.’ ");
INSERT INTO ebk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ngem kun pay inilan nan chiyuycha nun-uumauna nan anakna, kenalicha un, ‘Nauy nan mangetawid as nan uumaun takú ay natatanman as ubas. Akayu! Patayun takú hiya ta kuwaun takú nan tawidna.’ ");
INSERT INTO ebk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","As nan hiyachi, inchus-orcha hiya as nan fiakun sakop nan uma ay natatanman as ubas ya penatuycha. “Ngachanantu ngay nan atun nan nakin kuwa as nan uma ay natatanman as ubas as nan chiyuycha nun-uumauna? ");
INSERT INTO ebk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Omalintu hiya ay mangpatuy kan chicha, ya ichatna as nan tukún nan umana ay natatanman as ubas.” Kun pay chinngor nan tataku na, kenalicha, “Aw! Fiakun koma assesay ommat.” ");
INSERT INTO ebk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Entoongan Jesus chicha, ya kanana, “Ngachana ngarud nan laychun ay kanan nan nauy naisurat as nan Kalen Apo Dios? Kanana un, ‘Nan chiyuy fiatu ay enachen nan chiyuycha muntuptuping at hiya nan nunfialin as kaamuchan ay maipugnad.’ ");
INSERT INTO ebk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Am-in ay tataku ay mag-as as nan hana ay fiatu at mapet-apet-ang. Ngem kun pay mag-as nan hana ay fiatu as nan kumpurmi at kimokunantu nan hana mag-asana.” ");
INSERT INTO ebk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kiapú ta naawatan nan mun-isursuru as Lintig ya nan anap-apon chi papachi ay nan nauy maepadpachongan ay infiakian Jesus at maepangkep kan chicha, penachascha ay epatiliw hiya as nan hiyachi ay uras, ngem inmugyatcha as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Isunga nunsuudcha as chansacha ay mangtiliw kan hiya. Infiaorcha nan napasoksokan ay lanaraki ay pakamankaman ay uy manikap kan Jesus ta wachay ifiakiana as mangicharumancha kan hiya ta ipurangcha hiya as nan gobernador ay wachay kalibfengana ay mun-okóm. ");
INSERT INTO ebk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Inmuycha kan Jesus nan napasoksokan, ya kanancha kan hiya, “Misturu, ammumi ay ustu nan kanam ya isurom. Ammumi us ay maid paspasikum, ngem isurom nan tit-iwa ay laychun Apo Dios ay atun nan tataku. ");
INSERT INTO ebk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ifiakiam pay ngarud kan chakami nan songfiatmu as na: Ay eparufus nan lintig takú ay munfiayad kami as fiaror kan Emperador ad Roma winnu achi?” ");
INSERT INTO ebk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngem aammon Jesus nan kenasikapcha, ya kanana kan chicha, ");
INSERT INTO ebk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ud-a, omepaila kayu kan ha-un as usa ay silsilyu. Ngachana nan nakin lupa ya nakin ngachan as na?” “Hi Emperador,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kenalen Jesus kan chicha, “Mu hiyasa ngarud, ichatyu kan Emperador nan kuk-uwan Emperador, ya ichatyu us kan Apo Dios nan kuk-uwan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Achicha poros kafiaelan ay isikapan hi Jesus babaen as nan kenalina as nan mangiilan nan tataku. Kiapú ta naschaawcha as nan ensongfiatna, kinminakcha. ");
INSERT INTO ebk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wachacha nan tapen nan Saduseo ay enmali kan hiya. Chicha nan bunggoy chi Judio ay mangali un achi mataku nan natuy manipud as nan utúy. Senarudsudcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Misturu, nauy met nan insurat Moises para kan chitaku ay kanana un, ‘Mu wachay hen-asawa ay maid anakcha ya matuy nan laraki, masapor asawaun nan sunúd nan laraki nan naellakas ta mu wachay anakcha at maifilangtu nan onga as potot nan chiyuy natuy ay sunúdna.’ ");
INSERT INTO ebk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wachacha kanu nan pitu ay hen-anag-i ay lanaraki. Enmasawa nan panguru, at natuy ay maid enpototna. ");
INSERT INTO ebk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Enasawan nan utub nan chiyuy naellakas, at natuy us ay maid enpototna. ");
INSERT INTO ebk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Assid-i us challu as nan maekatlu inkiana as nan maekapitu. Natuycha am-in nan pitu ay maid enpotpototcha. ");
INSERT INTO ebk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kuncha pay natuy am-in, natuy us nan fiafiai. ");
INSERT INTO ebk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","As nan urkiw ay matakuwan nan nunkatuy manipud as nan utúy, ngachana ngay nan nakin asawa as nan chiyuy fiafiai, tay enasawan met nan pitu hiya?” ");
INSERT INTO ebk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tinumfor hi Jesus, “Nan tataku asna's luta at mun-eennasawacha. ");
INSERT INTO ebk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ngem nan chiyuycha natuy ay maekari ay mataku manipud as nan utúy ya maketaku kan Apo Dios at achichantu mun-eennasawa, ");
INSERT INTO ebk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","tay kamancha angheles ay achi matmatuy. An-aktu Apo Dios chicha, tay matakucha manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Uray hi Moises at penaneknekana ay mataku nan natuy manipud as nan utúy. As nan naisurat as nan Kalen Apo Dios maepangkep as nan cha munkiarkiarud ay kaiw at enawakian Moises hi Apo Dios ay kanana un, ‘Nan Apo at hiya nan Dios Abraham, nan Dios Isaac ya nan Dios Jacob.’ ");
INSERT INTO ebk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nan laychun nan nauy ay kanan at hiya nan Dios nan matataku, fiakun nan nunkatuy. Tay mu as nan fiyang Apo Dios, nan am-in at matataku.” ");
INSERT INTO ebk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Angkiay kenalen nan tapina ay mun-isursuru as Lintig, “Ammay met kayman nan ensongfiatmu, Misturu.” ");
INSERT INTO ebk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kenalicha chi, tay chaancha naiturud ay munsarudsud kasin kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Angkiay kenalen Jesus kan chicha, “Anuyna atun ay nan Cristo at makali un kianak David? ");
INSERT INTO ebk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tay uray met hi David ay mismu at kanana as nan liblu ay Salmo un, ‘Kenalen nan Apo as nan ok Apo un: Tomokorka as apét kannawanku ");
INSERT INTO ebk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","inkiana amisok nan chiyuycha kafusormu ay kaman chicha nan kiakiatinam.’ ” ");
INSERT INTO ebk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Inturuy Jesus, “Mu hiyasa ngarud ay ‘Apo’ nan pang-awag David kan Cristo, anuyna ngay atun ay nan Cristo at kianak David?” ");
INSERT INTO ebk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","As nan chuchumngoran nan am-in ay tataku, kenalen Jesus as nan disipulusna, ");
INSERT INTO ebk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Il-ilaunyu nan nauycha mun-isursuru as Lintig. Laylaychuncha ay munliklikud ay nakafiachu as somakiayad, ya laylaychuncha ay cha risrispituwun nan tataku chicha as nan chiyuycha mun-el-elakwan. Laylaychuncha nan chiyuycha kaammayan ay tokoran as tomoktokorancha ya tokoran nan chiyuycha mafigfigfig as nan chiyuycha senagoga as nan uycha makifiastaan. ");
INSERT INTO ebk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Isikapcha ay manguwa as nan ab-afong nan eellakas. Angkiay paanchuanchuwuncha nan kararagcha ta ilaun nan tataku ay ammaycha. Naliglikiattu nan chusacha!” ");
INSERT INTO ebk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kun pay nuntangad hi Jesus, inilana nan nunkafiaknang ay cha mangittu as chatoncha ay siping as nan mangit-ittuwan as Templo. ");
INSERT INTO ebk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Inilana us nan usa ay pugli ay ellakas ay nangittu as kun chuwa ay pesos. ");
INSERT INTO ebk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","As nan hiyachi, kenalen Jesus, “Ifiakiak kan chakayu nan tit-iwa. Hi tona ay pugli ay ellakas nan nangittu as kachamunaan kan chicha am-in. ");
INSERT INTO ebk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tay nan nunkafiaknang at kuncha yangkiay inchat nan subra as nan kenafiaknangcha. Ngem hi tona ay ellakas uray pugli at inittuna challu nan am-in ay wacha kan hiya ay kurpuwan chi pagfiyagna.” ");
INSERT INTO ebk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wachacha nan tapina ay cha mangapat as nan kenaam-ammay nan Templo kiapú as nan anam-ammay ay fiatu ay naiyamma ya nan naiyar-arkos ay naichatchaton kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Kenalen Jesus, “Am-in chaná ay iilaunyu at umchantu nan timpu ay maidtu mayagyag as uray usa ay fiatu as nan naesasad-ana, tay kuncha am-in maikur-ub.” ");
INSERT INTO ebk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Senarudsudcha kan Jesus, “Misturu, kaatnantu nan ommatan chatona, ya ngachanantu nan sinyar ay mangematonan as nan kiayud ommatan chatona?” ");
INSERT INTO ebk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tinumfor hi Jesus, “Il-ilaunyu ta achi kayu maar-allilaw. Ongortu nan tataku ay omali ay mangosar as nan ngachanku ay mangarkali un, ‘Ha-un hi Cristo!’ ya ‘Kiayud umchan nan timpu!’ Achiyu poros un-unuchun chicha. ");
INSERT INTO ebk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","As nan manngoranyu ay wachachay kukufiat ya kukuru, achi kayu umug-ugyat as solet. Masapor challu ommat chaná on-ona, ngem fiakun pay hiyasa nan munpatingkiaan nan ka-ichin.” ");
INSERT INTO ebk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kenalen pay Jesus, “Munkikinnufiattu nan chiyuycha nasyon ya kaman us nan chiyuycha muntorayan. ");
INSERT INTO ebk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Henan tukutukún ay luglukiar, wachachantuy nunkapigsa ay kichu, ya wachachay fitel ya kauugyat ay saksaket ay ekatuytu nan tataku. Wachachantu us nan maila ad chaya ay kauugyat ya nakaskaschaaw ay sinyar. ");
INSERT INTO ebk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ngem sakbay ommat chaná, wachachantu nan mangtiliw ya mamalikiat kan chakayu. Icharum chakayuntu as nan totoray as nan chiyuycha senagoga, ya ifiarud chakayu. Iyuy chakayuntu as nan ar-ari ya as nan gogobernador kiapú as nan pammatiyu kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hiyanantu nan chansayu ay mangepaneknek as nan Ammay ay Chamag kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nunumnumunyu ay achi kayu machanakian mu ngachanantu nan esongfiatyu, ");
INSERT INTO ebk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tay ha-untu nan mangichat kan chakayu as kananyu ya kenasilibyu ay achintu makontra winnu masongfiatan nan kafusoryu. ");
INSERT INTO ebk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Uray chanakchakoryu, susnúdyu, ib-ayu, ya kiakiayyumyu at epatiliw chakayuntu, ya nan tapina kan chakayu at patayunchantu. ");
INSERT INTO ebk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Inglun chakayuntu as nan am-in ay tataku kiapú as nan pammatiyu kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ngem uray mu hiyasa, aaywanan chakayu challu kan Apo Dios ta uray usa as nan fookyu at achi malitaw. ");
INSERT INTO ebk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mun-eta-un kayu, tay hiyana nan atunyu ay mangara as nan fiyagyu ay maid patingkiana.” ");
INSERT INTO ebk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Inturuy Jesus, “As nan mangil-anyuntu ay nan ili ay Jerusalem at liwusun chi ongor ay sosorchachu, maammuwanyuntu ay kiayud umchan nan machachaelana. ");
INSERT INTO ebk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","As nan hiyasa, nan umiili ad Judea at masapor lomayawcha ay umuy henan chiyuycha chuntug. Masapor mak-ak nan chiyuycha wacha henan siyudad, ya nan chiyuycha wacha henan sigsikib at masapor achicha sungkop henan siyudad, ");
INSERT INTO ebk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","tay chatonantu nan ‘Urkiw ay Machusaan’ ta matongpar nan am-in ay kanan nan naisurat as nan Kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kasusug-angtu nan chiyuycha masisikug ya nan cha munpasusu as nan hanacha ay urkiw! Omalintu nan nunsidla ay likiat asna's luta, ya leknaun nan nauycha tataku nan fungat Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Matuytu nan tapina as choros, ya nan tapina at maifiarudchantu ay maiyuy henan tukutukún ay nasyon. Nan siyudad ay Jerusalem at chachaeluntu nan chiyuycha Gentil. Chichantu nan muntoray inkiana marpas nan naekeddeng ay timpucha.” ");
INSERT INTO ebk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kenalen pay Jesus, “Wachachantu nan sinyar ay maila as nan urkiw, furan ya taraw. Malilifokantu as solet nan am-in ay tataku henan am-in ay nasyon kiapú as nan nunsidla ay ugyatcha as nan napigsa ay atifungug henan fiayfiay ya anad-acha ay challuyon. ");
INSERT INTO ebk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Maurawchantu nan tataku kiapú as ugyatcha ay munsusuud as nan ommattu asna's luta, tay achintu manongnong chi aatun nan am-in ay wacha ad chaya. ");
INSERT INTO ebk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Angkiay ya ilaunchantu nan Naepadtu ay Anak chi Taku ay wachay kaichayawana ya pannakafialina ay cha omali ay maetatapi as nan lifuu. ");
INSERT INTO ebk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","As nan maelapuwan nan nauycha ay ommat, tomakchug ya muntangad kayu, tay kiayud umchan nan maesarakananyu.” ");
INSERT INTO ebk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Angkiay ya infiakian Jesus kan chicha nan nauy maepadpachongan: “Ilaunyu nan kaiw ay igos ya nan am-in ay tapen chi kaiw. ");
INSERT INTO ebk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","As nan mangil-anyu ay chacha somaliping, ammuyu at ay kiayud nan chakun. ");
INSERT INTO ebk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Assesa us ay as nan mangil-anyu ay cha om-ommat chaná at ammuyuntu ay kiayud at umchan nan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ifiakiak kan chakayu nan tit-iwa. Wachacha nan tapen nan tataku ad wani ay timpu ay matataku pay laing as nan ommatantu nan am-in ay infiakiak. ");
INSERT INTO ebk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mamaidtu nan chaya ya luta, ngem achi poros mamaid nan kalek. ");
INSERT INTO ebk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Il-ilaunyu ta fiakun nan narafus ay lagragsak ya futfutang ya chanchanag as maepangkep as pagfiyag nan nunumnumunyu. Mu atunyu chaná, makudnor kayuntu ay kaman kayu makna as nan loktat ay omaliyan nan hana ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tay nan hana ay urkiw at umchan as nan am-in ay tataku asna's luta. ");
INSERT INTO ebk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Isunga kanayon kayu ay nakasakiana, ya masapor kanayon kayu ay munkarkararag ta mawad-an kayu as pigsa ay mangeta-un as nan nauycha am-in ay ommattu ya ta makatakchug kayuntu as nan sangwanan nan Naepadtu ay Anak chi Taku.” ");
INSERT INTO ebk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Inurkiw ay nun-is-isuru hi Jesus as Templo, ya lenafi ay uy inmiiyan henan chuntug ay Olivo. ");
INSERT INTO ebk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Am-in nan tataku at inurkiw ay fumikiatcha ay umuy as Templo ay uy munchungor kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kiayud umchan nan Fiastan chi Tenapay ay Maid Lebadurana ay kanancha un Fiastan chi Munlausan. ");
INSERT INTO ebk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Inyan-anap nan anap-apon chi papachi ya nan mun-isursuru as Lintig nan atuncha ay mangepapatuy kan Jesus, tay umugyatcha as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sinungkop hi Satanas kan Judas ay makali un Iscariote ay usa as nan hinpuru ya chuwa ay disipulus Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Inmuy hi Judas as nan anap-apon chi papachi ya chiyuycha opisyar chi kukuwarcha as nan Templo ta makiturag mu anan atuna ay mangesepsep kan Jesus kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Naragsakancha ya enkaricha ay ichatcha nan siping kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Inyafud Judas, at nun-anap as ustu ay chansa ay mangesepsepana kan Jesus ay achi maam-ammuwan nan tataku. ");
INSERT INTO ebk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Angkiay ya enmali nan urkiw ay Fiastan chi Tenapay ay Maid Lebadurana ay hiyasa us nan naichatonan nan chiyuycha urfun ay karnero para as nan Fiastan chi Munlausan. ");
INSERT INTO ebk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Infiaor Jesus cha Pedro kan Juan. Kenalina kan chicha, “Uyyu esakiana nan manganan takú as nan Fiastan chi Munlausan.” ");
INSERT INTO ebk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Senarudsudcha, “Ay chaud nan laychum ay mangesakianaanmi?” ");
INSERT INTO ebk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tinumfor hi Jesus, “Chumngor kayu. As nan sungkopanyu henan siyudad, wachantu nan manib-at kan chakayu ay usa ay laraki ay manasakfiat as fusi ay natotorwan as chanum. Unuchunyu hiya inkiana as nan afong ay sungkopana. ");
INSERT INTO ebk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Angkiay ya kananyu as nan nakin afong, ‘Sarudsuchun nan Misturu kan he-a: Ay chaud nan kuwartu ay mangiyufonganantu as nan disipulusna as nan Fiastan chi Munlausan?’ ");
INSERT INTO ebk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Epailanantu kan chakayu nan nunngangatu ay kuwartu ay ad-acha ay kawad-an nan am-in ay kasaporan takú. Hid-i nan munsakianaanyu.” ");
INSERT INTO ebk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Inmuycha, ya ininchanancha nan am-in ay infiakian Jesus kan chicha. As nan hiyachi, ensakianacha nan manganan as nan Fiastan chi Munlausan. ");
INSERT INTO ebk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","As nan inumchanan nan uras ay manganancha, nakiufong hi Jesus as nan apostolesna. ");
INSERT INTO ebk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Angkiay ya kenalina kan chicha, “Lenarayadku paat ay makiufong kan chakayu as nan nauy Fiastan chi Munlausan sakbay munlikiatak, ");
INSERT INTO ebk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","tay ifiakiak kan chakayu, achiyaktu kasin mangmangan as nan nauy inkiana matongpar as nan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Angkiay ya enarana nan tasa ay natotorwan as maikop. Kun pay narpas ay nunyaman kan Apo Dios, kenalina, “Araunyu na, ya hen-anak-etunyu am-in ay mangikop. ");
INSERT INTO ebk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ifiakiak kan chakayu, munlapu ad wani, achiyaktu umig-ikop as nan unus chi ubas inkiana omali nan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Enarana us nan tenapay. Kun pay narpas ay nunyaman kan Apo Dios, pinutput-ingna, ya inchatna kan chicha, ya kanana, “Hiyana nan achorku ay maichat kan chakayu. Atunyu na as mangnumnumnumanyu kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kaman us as nan narpasancha ay nangan, inchatna nan tasa, ya kanana, “Nan nauy naetatasa at hiyana nan fiarú ay nakiturakian Apo Dios as nan tatakuna, epailanantu nan charak ay omayas para kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ngem ilaunyu at cha makiuufong hena nan mangesepsep kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tay matuytu challu nan Naepadtu ay Anak chi Taku ay kaman as nan enkeddeng Apo Dios. Ngem kasusug-ang kayman nan hana taku ay mangesepsep kan hiya!” ");
INSERT INTO ebk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Angkiay ya enlapucha ay munsesennarudsud mu ngachana kan chicha nan mangekaman as na. ");
INSERT INTO ebk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kun pay naaw-awni as akét, nasusuma nan disipulus mu ngachana kan chicha nan kaamuchan. ");
INSERT INTO ebk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kenalen Jesus kan chicha, “Nan ar-ari asna's luta at kuncha cha etortorayan nan tatakucha, ya nan chiyuycha wachay kalibfengancha ay muntoray at ngadnancha nan mismu ay achorcha as ‘Fumadfiachang’. ");
INSERT INTO ebk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ngem fiakun koma assesa kan chakayu. Ngem kun at nan kaamuchan kan chakayu at ifilangna koma nan achorna as kaongaan, ya nan ap-apu at ifilangna nan achorna as mafiabfiaor. ");
INSERT INTO ebk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ngachana pay nan am-amud, nan tomokor ay mangan winnu nan umichat as makan? Ay fiakun nan chiyuy tomokor ay mangan? Ngem ha-un, nauyak kan chakayu ay maepachong as nan mafiabfiaor. ");
INSERT INTO ebk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Chakayu nan chaan nanaytaynan kan ha-un as nan liglikiatku. ");
INSERT INTO ebk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Isunga epatorayku chakayu ay kaman as nan nangepatorayan amak kan ha-un ");
INSERT INTO ebk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ta makiufong kayuntu kan ha-un as nan muntorayak, ya tomokor kayuntu as nan chiyuycha trono ay mangokóm as nan hinpuru ya chuwa ay tribu ay chicha nan kianak Israel.” ");
INSERT INTO ebk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Angkiay kenalen Jesus kan Simon Pedro, “Simon, Simon, chumngorka. Naparufusan hi Satanas ay manisting kan chakayu am-in ta masisiyan kayu ay kaman as nan maisiyanan nan fukias as nan chuki. ");
INSERT INTO ebk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ngem enkararakiak he-a, Simon ta achi mamaid nan pammatem. As nan munfiangcham kan ha-un, masapor papigsaum nan pammaten nan iib-am.” ");
INSERT INTO ebk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tinumfor hi Pedro, “Apo, nakasakianaak ay maetapi kan he-a ay maifiarud ya matuy.” ");
INSERT INTO ebk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Ifiakiak kan he-a, Pedro,” kenalen Jesus, “Achintu munkokakok nan ka-or ad wani inkiana mamitluwak esaot kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Angkiay kenalen Jesus kan chicha, “As nan nangifiaorak kan chakayu ay maid entaktakinyu as petaka, samfiag winnu sapatos, ay wachay nunkuranganyu?” “Maid ya,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kenalen Jesus kan chicha, “Ngem ad wani, nan wachay petakana at masapor etakina, ya kaman us nan samfiagna. Nan maid chorosna at masapor elakuna nan kakiayna ta paat lomaku as usa. ");
INSERT INTO ebk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tay ifiakiak kan chakayu ay masapor ommat kan ha-un nan naisurat as nan Kalen Apo Dios ay kanana, ‘Maifilang hiya as lomalabsing as lintig.’ Tay nan hana naisurat maepangkep kan ha-un at kiayud matongpar.” ");
INSERT INTO ebk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kenalen nan disipulusna, “Apo, nauy met nan chuwa ay chorosmi hena.” “Nawan sa,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Angkiay ya nak-ak hi Jesus henan siyudad, ya inmuy henan chuntug ay Olivo ay hiyachi challu nan chana atuatun. Nakiuycha us nan disipulusna. ");
INSERT INTO ebk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kuncha pay inumchan hid-i, kenalina kan chicha, “Munkararag kayu ta achi kayu maamis as nan sulisug.” ");
INSERT INTO ebk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Angkiay ya tenaynana chicha ya inmuy as nan kaachawen chi maikiayangan chi fiatu. Hid-i nan nunpalintumangana ya nunkararakiana ay kanana, ");
INSERT INTO ebk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama, mu laychum, kaanum koma kan ha-un nan nauy omali ay likiatku. Ngem fiakun nan laychok nan matongpar, kun at nan laychum.” ");
INSERT INTO ebk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wacha nan usa ay anghel ay nurpu ad chaya ay nunpaila ya nangepapigsa kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kiapú ta nalilifokan as solet, kaskasina enpapasnek ay nunkararag. Nan lengatna at maepachong as nan chara ay tinmidtid as nan luta. ");
INSERT INTO ebk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kun pay narpas ay nunkararag, tenmakchug ya nunfiangad as nan kawad-an nan disipulusna. Ininchanana chicha ay nanassuy kiapú as foraycha as nan nginmuyusancha. ");
INSERT INTO ebk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kenalina kan chicha, “Adchi t'uy kayu mamassuy? Fumangun kayu, ya munkararag kayu ta achi kayu maamis as nan sulisug.” ");
INSERT INTO ebk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kun pay kukutug ay cha munkarkali hi Jesus, enmali nan ongor ay tataku ay enpapanguruwan Judas ay usa as nan hinpuru ya chuwa ay disipulusna. Naesnop hiya ay mamisitu kan Jesus, ");
INSERT INTO ebk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ngem kenalen Jesus kan hiya, “Judas, ay as nan mamisituwam as nan Naepadtu ay Anak chi Taku nan atum ay mangesepsep kan hiya?” ");
INSERT INTO ebk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kun pay inilan nan disipulus ay naketakin kan Jesus nan ommat, senarudsudcha, “Apo, ay fumakag kami?” ");
INSERT INTO ebk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","As nan hiyachi, finakag nan usa as nan disipulus nan fiabfiaarun nan kangatuwan ay pachi, at nakingasan nan kannawan ay ingana. ");
INSERT INTO ebk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngem kenalen Jesus kan chicha, “Ustu sa!” Angkiay ya kenpana nan ingan nan mafiabfiaor, at enpaammayna hiya. ");
INSERT INTO ebk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Angkiay kenalen Jesus as nan anap-apon chi papachi, oopisyar nan chiyuycha kuwarcha as nan templo, ya as nan anam-amá ay enmali ay uy mangtiliw kan hiya, “Ay kunak kumukuru? Adchi t'uy kayu enmali ay nangachoros ya nangapak-or? ");
INSERT INTO ebk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Inurkiw met ay wachaak as Templo, ya chaanak met tiniltiliw kan chakayu. Ngem urasyu ad wani, ya uras Satanas ay mangetoray as kenamangisiw.” ");
INSERT INTO ebk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Angkiay ya tiniliwcha hi Jesus, ya inyuycha as nan afong nan kangatuwan ay pachi. Kun pay hi Pedro, inmun-unud ay tenmataak. ");
INSERT INTO ebk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kun pay naiyapuy as nan kiawan nan fiattaw, uy naketokor hi Pedro as nan chiyuycha cha mun-an-anichu. ");
INSERT INTO ebk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ngem wacha hid-i nan usa ay mafiabfiaor ay fiafiai ay nangila kan Pedro ay tenmotokor ay cha makean-anichu. Entoongana, ya kanana, “Hi tona met ay laraki at usa us ay nakekadkadwa kan Jesus.” ");
INSERT INTO ebk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ngem ensaot Pedro, “Ammi, achek poros am-ammu hiya!” ");
INSERT INTO ebk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kun pay naaw-awni, nan tukún ay laraki at enmatonana us hi Pedro, ya kanana, “He-a us at usaka met as nan kakadwana.” Ngem tinumfor hi Pedro, “Aw, fiakunak met usa kan chicha!” ");
INSERT INTO ebk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Uy at kiayud usa ay uras chi inmuy, wacha nan usa pay ay laraki ay nangepapelet, “Tit-iwa met ay nakekadkadwa us na ay laraki kan Jesus, tay i-Galilea met hiya.” ");
INSERT INTO ebk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngem tinumfor hi Pedro, “Lakay, achek poros ammu nan cham kankanan!” Kun pay kukutug ay cha munkarkali hi Pedro, hiya at chi ya nunkokakok nan ka-or. ");
INSERT INTO ebk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nunsakong hi Apo Jesus, ya entoongana hi Pedro. Hiya at chi ya nanumnum Pedro nan infiakian nan Apo kan hiya un, “Sakbay munkokakok nan ka-or ad wani at mamitluwaktu esaot kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Angkiay ya pinmitiw hi Pedro, ya nunsidlay akorna. ");
INSERT INTO ebk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ad wani, nan tataku ay nangukuwarcha kan Jesus at enot-otyok ya senaplesapletcha hiya. ");
INSERT INTO ebk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Enokopancha nan matana, ya senarudsudcha kan hiya, “Ud-a pay! Pugtuwam mu ngachana nan nanudpak kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ongor pay chi kafiafiain ay infiagfiakiacha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","As nan wi-ewi-et, naamongcha nan membron nan Sanhedrin ay chicha nan anam-amán chi Judio, anap-apon chi papachi, ya nan chiyuycha mun-isursuru as Lintig. Kun pay narpas chi, inyuycha hi Jesus as nan sangwanan nan Sanhedrin. ");
INSERT INTO ebk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kenalicha kan hiya, “Ifiakiam man kan chakami mu he-a nan Cristo?” Tinumfor hi Jesus, “Uray mu ifiakiak kan chakayu, achiyuntu challu afurotun. ");
INSERT INTO ebk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mu munsarudsuchak kan chakayu, achi kayuntu challu tumfor. ");
INSERT INTO ebk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ngem munlapu ad wani, tomokortu nan Naepadtu ay Anak chi Taku as apét kannawan Apo Dios ay Mannakafialin as nan am-in.” ");
INSERT INTO ebk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Senarudsudcha am-in, “Mu hiyasa, ay he-a ngarud nan anak Apo Dios?” “Chakayu nan nangali un ha-un,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hacha at kanan, “Ay masapor takú pay chi tapina ay muntistigu? Chinngor takú met ay mismu nan kenalina.” ");
INSERT INTO ebk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Angkiay ya naligwat nan am-in ay membron nan Sanhedrin, ya inyuycha hi Jesus kan Gobernador Pilato. ");
INSERT INTO ebk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Enlapucha ay mangicharum kan hiya. Kenalicha, “Tiniliwmi na ay taku ay cha mangurkuru as nan kakailiyanmi. Epawanay munfiayachan as fiaror kan Emperador, ya kanana us un hiya nan Cristo ay usa ay ari.” ");
INSERT INTO ebk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Senarudsud Pilato kan Jesus, “Ay he-a nan aren chi Judio?” “He-a nan nangali un ha-un,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kenalen Pilato as nan anap-apon chi papachi ya as nan ongor ay tataku, “Maid naanapak as fiasor tona ay taku.” ");
INSERT INTO ebk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ngem enpapeletcha, “Kiapú as nan sursuruna, nakuru nan tataku henan am-in ay ili ad Judea, manipud ad Galilea inkiana hena ad Jerusalem.” ");
INSERT INTO ebk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kun pay chinngor Pilato na, senarudsudna mu i-Galilea hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kuna pay naammuwan ay nan ilen Jesus at sakop nan muntotorayan Herodes, enpaiyuyna hi Jesus kan Herodes ay wacha ad Jerusalem as nan hiyachi ay timpu. ");
INSERT INTO ebk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Naragsakan as solet hi Herodes as nan nangil-ana kan Jesus, tay nafiayag ay laraychuna ay mangila kan hiya kiapú ta chinchinngorna nan maepangkep kan hiya ya nenamnamana ay mangila as nakaskaschaaw ay epailan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Isunga ongor chi senarudsud Herodes kan Jesus, ngem chaan tinumtumfor hiya. ");
INSERT INTO ebk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tenmatakchug nan anap-apon chi papachi ya nan mun-isursuru as Lintig ay kaskasin nangepafiasor kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","As nan hiyachi, enlaylayusan ya enot-otyok Herodes ya nan sorchachuna hi Jesus. Angkiay ya enpafiachucha kan hiya nan fiachon chi ari, ya enpafiangad Herodes hiya kan Pilato. ");
INSERT INTO ebk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nunlapu as nan hiyasa ay urkiw, nunkiayyum cha Herodes kan Pilato uray mu nunfinnusorcha ad kasin. ");
INSERT INTO ebk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Enamong Pilato nan anap-apon chi papachi, nan mangepangpanguru as nan Judio ya nan tataku, ");
INSERT INTO ebk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ya kanana kan chicha, “Inyaliyu kan ha-un nan nauy ay taku ay kananyu un mangurkuru as tataku. Finistikiarku at hiya as nan sangwananyu, at maid naanapak as nan chayu epabpafiasor kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kaman us kan Herodes ay maid naanapana, tay hiyasa nan kiapúna as nan nangepafiangchana kan hiya kan chitaku. Maid challu enat tona ay taku as libfengna ay matuyan. ");
INSERT INTO ebk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Isunga kunku yangkiay epasaplet hiya, angkiay ilufusku hiya.” ");
INSERT INTO ebk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Napeletan hi Pilato ay umilufus as usa ay fiarud mu Fiastan chi Munlausan, tay hiyasa nan iniili ay ukialen chi Judio. ");
INSERT INTO ebk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngem nagrubcha am-in nan tataku ay nangifukiaw, “Epapatuymu! Hi Barrabas nan laychunmi ay ilufusmu!” ");
INSERT INTO ebk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Hi Barrabas ay anna at naifiarud kiapú ta enpanguna nan tataku ay munkukuru ad Jerusalem ya kiapú ta penmatuy.) ");
INSERT INTO ebk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Naketakiatfor kasin hiya as nan tataku, tay laraychun Pilato ay mangilufus kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ngem infugfukiawcha, “Epaelansam as nan koros! Epaelansam as nan koros!” ");
INSERT INTO ebk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kenalen Pilato kan chicha as nan maekapitlu, “Adchi ngay? Ngachana man nan mangotettet ay enatna? Maid met naanapak as enatna as libfengna ay matuyan. Isunga kunku yangkiay epasaplet hiya, ya ilufus hiya.” ");
INSERT INTO ebk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngem kaskasincha enpapati ay nangifukiaw un maelansa hi Jesus as nan koros inkiana nangafiakcha. ");
INSERT INTO ebk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Isunga inyafud Pilato nan enpapaticha. ");
INSERT INTO ebk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Inlufusna nan laraki ay naifiarud kiapú as nan nunkuruwana ya penmatuyana ay chinawatcha. Ngem inpurangna hi Jesus kan chicha ta atuncha nan laychuncha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","As nan cha mangek-akan nan sosorchachu kan Jesus, inkuyudcha nan usa ay taku ay nan ngachana at Simon ay i-Cirene ay cha omali henan siyudad ay nurpu henan sikib. Enpasakfiatcha kan hiya nan koros, angkiay enpaunudcha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Inmunud kan Jesus nan ongoongor ay tataku, ya nan tapina ay fianafiai ay cha mun-ag-akor ya muntangtangugngug kiapú kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Senakong Jesus chicha, ya kanana, “Aammi ay i-Jerusalem, achiyak akiaran. Achoryu at ya nan an-akyu nan akiaranyu! ");
INSERT INTO ebk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tay umchantu nan timpu ay mangaliyantu nan tataku un, ‘Nakiasat nan fianafiai ay fiasig, chaan enman-anak, ya chaan nunpaspasusu!’ ");
INSERT INTO ebk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hiyasa nan timpu ay mangaliyantu nan tataku as nan chunchuntug un, ‘Kiab-onanyu chakami,’ya as nan filfilig un, ‘Lingfianyu chakami.’ ");
INSERT INTO ebk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tay mu hiyana nan maekaman kan ha-un ay maepachong as nan naata ay kaiw, ay kun at achi kaskasin nan maekaman kan chakayu ay maepachong as nan narangu ay kaiw?” ");
INSERT INTO ebk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wachacha us nan chuwa ay lomalabsing as lintig ay naek-ak ay maetapi kan Jesus ay maepapatuy. ");
INSERT INTO ebk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kuncha pay inumchan henan lukiar ay makali un Tong-or Chi Uru, enlansacha hi Jesus as nan koros. Enlansacha us nan chuwa ay lomalabsing as lintig, usa as apét kannawan Jesus ya nan usa at as apét kannikidna. ");
INSERT INTO ebk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kenalen Jesus, “Ama, pakawanum chicha, tay achicha ammu nan chacha at-atun.” As nan hiyachi, finingfingay nan sosorchachu nan chiyuycha fiachuna babaen as nan nunfifinnunotancha. ");
INSERT INTO ebk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nan tataku hid-i at nangatakchugcha ay cha munfuyfuya. Kun pay nan anap-apon chi Judio at enot-otyokcha hiya. Chacha kankanan, “Ensarakana met nan tapina ay tataku. Kakuna esarakan nan achorna mu hiya nan Cristo ay pinilen Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Uray nan sosorchachu at enot-otyokcha hiya. Naesnopcha ya inchutngucha nan senmoka ay fiayas, ");
INSERT INTO ebk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ya kanancha, “Mu tit-iwa ay he-a nan aren chi Judio, kakunmu esarakan nan achormu!” ");
INSERT INTO ebk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wacha nan naisurat as nan tabra ay naipuuy as nan laramakun nan uron Jesus: “Hi Tona Nan Aren Chi Judio.” ");
INSERT INTO ebk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nan usa as nan chiyuycha lomalabsing as lintig ay naelansa at ininsurtuna hi Jesus. Kenalina, “Ay fiakun he-a nan Cristo? Kakunmu ngarud esarakan nan achormu ya chakami!” ");
INSERT INTO ebk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ngem nan chiyuy usa ay naelansa at senengarana nan nauy nanginsurtu kan Jesus. Kenalina, “Ay achika umugyat kan Apo Dios? Mapapchong met nan chusa takú am-in. ");
INSERT INTO ebk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Libfengta met ay machusa kiapú as nan enatta. Ngem hiya at maid enatna as mangisiw.” ");
INSERT INTO ebk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Angkiay kenalina kan Jesus, “Apo Jesus, nunumnumunak man paat as nan omaliyam ay mun-ari.” ");
INSERT INTO ebk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tinumfor hi Jesus kan hiya, “Ifiakiak kan he-a nan tit-iwa. Ad wani ay urkiw at maetapikantu kan ha-un ad Paraiso.” ");
INSERT INTO ebk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","As nan kiayud munkiawa, ngenmongot nan intiru ay luta inkiana alas tres as nan makiayud. ");
INSERT INTO ebk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","As nan hiyachi, namaid nan lawag nan urkiw, ya narakset ay nakudwa nan kurtinan nan Templo nunlapu as lamagna inkiana as kuwabna. ");
INSERT INTO ebk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Angkiay inpigsan Jesus ay nangifukiaw, “Ama, ichatku kan he-a nan lenawak.” Kuna pay narpas ay kenali na, natuy hiya. ");
INSERT INTO ebk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kun pay inilan nan kapetan chi sosorchachu nan enommat, nunchaychayaw hiya kan Apo Dios, ya kanana, “Tit-iwa payat ay nalintig na ay taku!” ");
INSERT INTO ebk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kun pay inilan nan naaamong ay tataku ay cha munfuyfuya nan enommat, kenmatamcha ay cha manibtib-ug as tagrangcha kiapú as nan ongor ay ngunguyuscha. ");
INSERT INTO ebk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nan am-in ay am-ammon Jesus patí nan fianafiai ay inmun-unud kan hiya nunlapu ad Galilea at nangatakchugcha as nan ad-achawwi as akét ay mangiila as nan nauycha cha om-ommat. ");
INSERT INTO ebk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Wacha nan usa ay laraki ay nan ngachana at Jose ay nurpu ad Arimatea ay usa ay ili henan probinsiya ay Judea. Nan nauy ay taku at ammay ya nalintig, ya usa ay cha manman-ud as nan omaliyan nan muntorayan Apo Dios. Uray mu usa hiya ay membron nan Sanhedrin, chaana inyafud nan enkeddeng ya enat nan kakadwana kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Inmuy hiya kan Pilato, at chinmawat as pammarufus ay arauna nan achor Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","As nan naeksopan nan achor Jesus as nan koros, penotepotana as am-ammay ay lopot, ya uyna inlufok as nan chaan naos-osar ay lufok ay natuktukan ay chupras. ");
INSERT INTO ebk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","As nan hana ay urkiw at urkiw ay Munsakianaan chi Judio, ya kiayud nunlapu nan Urkiw ay Mun-iblayan. ");
INSERT INTO ebk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nan fianafiai ay inmun-unud kan Jesus ay nurpu ad Galilea at nakiuycha kan Jose. Inilacha nan lufok ya nan enat nan achor Jesus ay naesaad. ");
INSERT INTO ebk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kun pay narpas, kenmatamcha. Angkiay ensakianacha nan lana ya fiangfiangru ay ipuuycha as nan achor Jesus. As nan Urkiw ay Mun-iblayan, nun-iblaycha ay maiyunud as nan filfilin nan Lintig. ");
INSERT INTO ebk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","As nan wi-ewi-et nan Chumingku, inmuy nan chiyuycha fianafiai as nan lufok Jesus. Entatakincha nan ensakianacha ay fiangfiangru. ");
INSERT INTO ebk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","As nan inumchanancha as nan lufok, ininchanancha ay nauulin at nan fiatu ay naetatangub as nan chiyuy lufok. ");
INSERT INTO ebk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ngem kuncha pay sinungkop, maid ininchanancha as achor Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","As nan chacha masmaschaawan as nan inilacha, kalina at ya naketatakchug as nan sag-uncha nan chuwa ay lanaraki ay nangafiachu as mun-aliling. ");
INSERT INTO ebk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kiapú as nan nunsidla ay ugyatcha, nunlukfubcha, ngem kenalen nan chuwa ay lanaraki kan chicha, “Adchi t'uyyu anapun chi matataku as nan kawad-an chi nunkatuy? ");
INSERT INTO ebk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maid hiya hena. Nataku hiya manipud as nan utúy. Numnumunyu nan kenalina kan chakayu as nan kawad-ana ad Galilea ");
INSERT INTO ebk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ay nan Naepadtu ay Anak chi Taku at masapor maipurang as nan fumafiasor ay tataku ta maelansa as nan koros, ya as nan maekatlu ay urkiw at mataku challu manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Angkiay ya nanumnum nan fianafiai nan infiakian Jesus. ");
INSERT INTO ebk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kuncha pay nunfiangad ay nurpu as nan lufok, uycha enpachamag chaná am-in as nan hinpuru ya usa ay disipulus ya as nan am-in ay tapina pay ay kakadwacha. ");
INSERT INTO ebk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chatona nan fianafiai ay uy nangifiakia as na as nan apostoles: hi Maria Magdalena, hi Juana, ya hi Maria ay enan Santiago, ya tapina pay ay fianafiai ay kakadwacha. ");
INSERT INTO ebk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ngem ka-anan nan apostoles un kun lawá ap-apat nan kenalicha, ya chaancha enafurot chicha. ");
INSERT INTO ebk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngem uray mu hiyasa, naligwat hi Pedro, ya tenmagtag ay inmuy as nan lufok Jesus. As nan inumchanana, nunyongyong ay nangiting-i ad chur-um, ya kun yangkiay nan naelekfot kan Jesus nan inilana. Angkiay kenmatam hiya ay cha masmaschaaw as nan enommat. ");
INSERT INTO ebk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","As nan hiyasa challu ay urkiw, cha manad-aran nan chuwa ay disipulus Jesus henan usa ay fiabruy ay makali un Emaus ay uy at umuy as hinpuru ya usa ay kilometro nan kaachawwina ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chacha ap-apatun nan am-in ay enom-ommat. ");
INSERT INTO ebk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kuncha pay cha mun-ap-apat, naesnop hi Jesus ya nakitun-ud kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Inilacha hiya, ngem chaancha naparufusan ay mangematon kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Senarudsud Jesus kan chicha, “Ngachana man paat nan chayu ap-apatun as nan chayu manarcharanan?” Entakchugcha ay kun ngumunguyus. ");
INSERT INTO ebk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Angkiay ya tinumfor nan usa ay nan ngachana at Cleofas, “Anuy he-a yangkiay chi mangili ad Jerusalem as achi nangammu as nan enom-ommat as nan nauycha inmuy ay urkiw?” ");
INSERT INTO ebk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Senarudsud Jesus, “Anan enom-ommat?” Tinumforcha, “Nan maepangkep as nan enommat kan Jesus ay i-Nazaret. Hi tona ay taku at usa ay pomapadtu, ya infilang Apo Dios ya nan am-in ay tataku hiya as wachay pannakafialina ay mun-isuru ya mangekaman as nakaskaschaaw. ");
INSERT INTO ebk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nan anap-apon chi papachi takú ya nan muntotoray kan chitaku at inpurangcha hiya ay makeddengan ay matuy, ya enpaelansacha as nan koros. ");
INSERT INTO ebk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Namnamaunmi ay hiya pay koma nan mangesarakan kan chitaku ay kianak Israel. Fiakun yangkiay sa, nauy maekatlu ay urkiw ad wani nunlapu as nan enommatana. ");
INSERT INTO ebk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nan usa pay at nan tapina ay fianafiai ay kakadwami at infiakiachay naschaawanmi. Inmuycha as nan lufokna as nan wi-ewi-et, ");
INSERT INTO ebk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ngem maid kanu ininchanancha as achorna. Nunfiangadcha ay nangifiakia un wacha kanu nan nunpaila ay angheles ay nangali kan chicha un nataku hiya manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Angkiay ya wachacha nan tapina ay kakadwami ay inmuy as nan lufok Jesus, at ininchanancha ay tit-iwa nan kenalen nan fianafiai, ngem chaancha challu inila hiya.” ");
INSERT INTO ebk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kenalen Jesus kan chicha, “Chakayu ay nunkangokngok! Anuy kayu nalikiat ay omafurot as nan am-in ay infiagfiakian nan chiyuycha pomapadtu! ");
INSERT INTO ebk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ay kun achi masapor iliwas Cristo chaná sakbay umuy ad chaya?” ");
INSERT INTO ebk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","As nan hiyachi, manipud as nan chiyuycha liblon Moises inkiana as nan insurat nan am-in ay pomapadtu, enpakaawatna kan chicha nan am-in ay naisurat as nan Kalen Apo Dios maepangkep kan hiya. ");
INSERT INTO ebk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kuncha pay cha maesnop henan fiabruy ay ay-ayancha, enpadlaw Jesus ay kaman achawwi pay nan ay-ayana, ");
INSERT INTO ebk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ngem enpakudcha hiya, ya kanancha, “Kakunka chumawus kan chakami, tay makiayud at met ya kiayud maschum.” Isunga chinmawus hiya kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kun pay tenmokor hi Jesus ay makekan kan chicha, enarana nan tenapay ya benendisyonana. Angkiay ya pinutput-ingna, ya inchatna kan chicha. ");
INSERT INTO ebk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kalina at ya kaman nunmallag chi mangiilacha kan Jesus, at enmatonancha hiya, ngem namaid at. ");
INSERT INTO ebk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kenalicha as nan tunggal usa, “Isunga naragsakta payat as nan naketakiatforana kan chita as nan korsa ya as nan nangepakaawatana kan chita as nan naisurat as nan Kalen Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nalannigwatcha ya nunfiangadcha ad Jerusalem. Ininchanancha nan hinpuru ya usa ay disipulus ay naaamong patí nan tapina pay ay kakadwacha ");
INSERT INTO ebk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ay cha mangarkali un, “Tit-iwa ay nataku nan Apo manipud as nan utúy! Nunpaila kan Simon!” ");
INSERT INTO ebk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Angkiay ya infiakian nan chuwa nan enom-ommat kan chicha as nan kawad-ancha as nan korsa, ya nan nangematonancha as nan Apo as nan namutput-ingana as nan tenapay. ");
INSERT INTO ebk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kun pay cha ifiagfiakian nan chuwa na kan chicha, kalina at ya naketatakchug hi Jesus kan chicha, ya kanana, “Natalna ay numnum koma nan mawawacha kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nakudnorcha ya inmugyatcha as solet. Ka-anancha mu uy at lawá anennet nan inilacha. ");
INSERT INTO ebk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ngem kenalina kan chicha, “Adchi t'uy kayu malilifokan ya munchuwachuwa ay ha-un na? ");
INSERT INTO ebk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilaunyu nan limak ya nan sukek. Ha-un na ay mismu! Ayu, udnanak ya keknaunyu ta omafurot kayu, tay maid laman ya tong-or nan anennet ay kaman as nan mailayu kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","As nan nangaliyana as na, enpailana kan chicha nan limana ya nan sukina. ");
INSERT INTO ebk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kuncha pay kutug ay achi omafurot, chacha maragragsakan ya masmaschaaw as solet, senarudsudna, “Ay wachay makan hena?” ");
INSERT INTO ebk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Inchatcha nan usa ay fiangos ay chinawis. ");
INSERT INTO ebk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Enarana ya kenana as nan sangwanancha. ");
INSERT INTO ebk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kun pay narpas hi Jesus ay nangan, kenalina kan chicha, “Nauycha nan infiakiak as nan kawad-ak pay laing kan chakayu: Masapor matongpar am-in nan naisurat as nan Lintig Moises, nan insurat nan chiyuycha pomapadtu ya nan wacha as nan liblu ay Salmo maepangkep kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Angkiay ya lenawlawakiana nan numnumcha ta maawatancha nan naisurat as nan Kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kenalina kan chicha, “Nauy nan naisurat as nan Kalen Apo Dios: Masapor munlikiat nan Cristo ya matuy. Angkiay as nan maekatlu ay urkiw, mataku hiya manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Masapor us maekasaba nan munfiafiawiyan nan tataku as nan fiasfiasorcha ya nan mamakawanan Apo Dios kan chicha babaen kan hiya henan am-in ay nasyon munlapu hena ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Chakayu nan mangepaneknek as nan nauycha. ");
INSERT INTO ebk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ifiaorkuntu kan chakayu nan enkaren Amak, ngem masapor sasad-unyu ad Jerusalem inkiana maawatyu nan pannakafialin ay murpu ad chaya.” ");
INSERT INTO ebk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Angkiay ya enpangon Jesus nan disipulusna ay umuy as nan fiakun sakop nan siyudad. Kuncha pay inumchan ad Betania, tenag-uyna nan limana, ya benendisyonana chicha. ");
INSERT INTO ebk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","As nan chana mangbendisyonan kan chicha, tenaynana chicha, ya naetag-uy hiya ad chaya. ");
INSERT INTO ebk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nunchaychayawcha kan hiya, angkiay nunfiangadcha ad Jerusalem ay cha munlagragsak. ");
INSERT INTO ebk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nunlapu as nan hiyachi ay timpu, kanayon ay wachacha as nan Templo ay munchaychayaw kan Apo Dios.");
INSERT INTO ebk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","As nan laplapuna, sakbay mafiayang nan luta, nawawacha at nan Kali. Nan nauy Kali ay hi Cristo at kadwan Apo Dios, ya hiya at Apo Dios ay mismu. ");
INSERT INTO ebk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hi tona ay Kali at kadwan Apo Dios nunlapu ad maliyam. ");
INSERT INTO ebk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nan am-in ay wacha at finayang Apo Dios babaen kan hiya, ya mu achi babaen kan hiya at maid usa as nafiayang. ");
INSERT INTO ebk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hiya nan kurpuwan chi fiyag, ya nan nauy ay fiyag at hiyana nan silaw ay manilaw as nan numnum nan tataku. ");
INSERT INTO ebk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nan silaw at silawana nan ngongot, ya achi poros amisun nan ngongot nan silaw. ");
INSERT INTO ebk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wacha nan usa ay taku ay finaor Apo Dios ay nan ngachana at Juan. ");
INSERT INTO ebk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Enmali ay uy mangepaneknek as nan maepangkep as nan nauy silaw ta am-in ay tataku at omafurotcha koma babaen kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hi Juan ay mismu at fiakun hiya nan chiyuy silaw. Enmali yangkiay ay uy mangepaneknek as nan maepangkep as nan chiyuy silaw. ");
INSERT INTO ebk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nan tit-iwa ay silaw ay manilaw as nan numnum nan am-in ay tataku at cha omali asna's luta. ");
INSERT INTO ebk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Asna's luta nan nawawad-anana, ya am-in ay wacha hena at finayang Apo Dios babaen kan hiya. Uray mu hiyasa, nan tataku at kuncha challu chaan enmatonan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Enmali henan mismu ay ilina, ngem chaan enawat nan kakailiyana hiya. ");
INSERT INTO ebk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngem am-in ay nang-awat ya enmafurot kan hiya at chicha nan nangichatana as kalibfengan ay munfialin as an-ak Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nan kiapón nan nunfialinancha as an-ak Apo Dios at fiakun nan naiyankancha as nan chanakchakorcha winnu fiakun kiapú as nan pangkep nan hen-asawa ay mawad-an as anak, ngem kun at babaen as nan pannakafialin Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nan Kali at nunfialin as taku ya nakiili kan chakami. Naila nan grasyana as nan am-in ay en-enatna, ya am-in nan infiagfiakiana at tit-iwa. Inilami nan kaichayawana ay inchat Amana kan hiya ay us-usa ay Anakna. ");
INSERT INTO ebk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Hi Juan at penaneknekana nan maepangkep as nan hana Kali. Infukiawna, “Hi tona nan infiakiak kan chakayu un, ‘Nan cha umunud kan ha-un at am-amud mu ha-un, tay nawawacha hiya sakbay maiyanakak.’ ” ");
INSERT INTO ebk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kiapú as nan ongoongor ay sug-angna, kanayon ay somabsafi nan bendisyona kan chitaku am-in. ");
INSERT INTO ebk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tay nan Lintig at enpakaammon Apo Dios babaen kan Moises, ngem nan grasyana ya nan kenatit-iwa maepangkep kan hiya at enpakaammuna babaen kan Jesu Cristo. ");
INSERT INTO ebk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maid poros nakaila kan Apo Dios mu achi yangkiay nan us-usa ay Anakna ay Dios mismu ay kadwan Amana. Hiya nan nangepakaammu as nan maepangkep kan Amana as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Hiyana nan penaneknekan Juan as nan papachi ya as nan chiyuycha Levita ay finaor nan anap-apon chi Judio ad Jerusalem ay uy manarudsud kan Juan mu anan ngachana. ");
INSERT INTO ebk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chaan ensaot Juan, ngem kuna at inpudnu kan chicha un, “Fiakun ha-un nan Cristo.” ");
INSERT INTO ebk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Senarudsudcha, “Ngachanmu ngay ngarud? Ay he-a hi Elias?” “Fiakun,” ensongfiat Juan. “Ay he-a nan Pomapadtu ay sasad-unmi?” senarudsudcha kasin. “Fiakun,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kenalicha kan Juan, “Ayu man paat ifiakiam mu anan ngachanmu. Masapor wachay esongfiatmi as nan chiyuycha nangifiaor kan chakami. Anan ngachanmu tit-iwa?” ");
INSERT INTO ebk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tinumfor hi Juan babaen as nan nangifiag-ana as nan enpadton Isaias, “Ha-un nan kalen nan cha mangifugfukiaw henan disyerto un, ‘Munlutkunyu nan ayun nan Apo.’ ” ");
INSERT INTO ebk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Angkiay ya nan chiyuycha finaor nan chiyuycha Fariseo at senarudsudcha kan Juan, ");
INSERT INTO ebk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Adchi ngay t'uyka munfunyag mu fiakun he-a nan Cristo winnu hi Elias winnu nan chiyuy pomapadtu?” ");
INSERT INTO ebk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tinumfor hi Juan, “Funyakiak chakayu as chanum, ngem wacha kan chakayu nan achiyu am-ammu. ");
INSERT INTO ebk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hiya nan cha umunud kan ha-un, ya achiyak poros maekari ay mangfokat as kiarot nan sapatosna.” ");
INSERT INTO ebk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Enommat chaná am-in ad Betania as apét fomokfoknakian nan urkiw as nan usa ay chumang nan wawwang ay Jordan ay cha munfunfunyakian Juan. ");
INSERT INTO ebk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","As nan kafikiatana, inilan Juan hi Jesus ay cha omali kan hiya, ya kanana, “Nauy nan Korderon Apo Dios ay mangaan as fiasfiasor nan katakutaku! ");
INSERT INTO ebk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hi tona nan infiakiak ay cha umunud kan ha-un ay am-amud mu ha-un, tay nawawacha hiya sakbay maiyanakak. ");
INSERT INTO ebk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Uray ha-un at achek us am-ammu hiya ad kasin, ngem enmaliyak ay mangfunyag as nan tataku as chanum ta hiyasa nan maepakaammuwana kan chakayu ay kianak Israel.” ");
INSERT INTO ebk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nauy nan pammaneknek Juan, “Inilak nan Espiritu Santo ay kenomsop ay kaman karopati ay nurpu ad chaya ya nayaschi kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ha-un mismu at achek am-ammu hiya. Ngem hi Apo Dios ay nangifiaor kan ha-un ay mangfunyag as nan tataku as chanum at kenalina kan ha-un, ‘Nan ilaumtu ay komsopan ya mayayaschiyan nan Espiritu Santo at hiya nan mangfunyagtu as nan tataku as Espiritu Santo.’ ");
INSERT INTO ebk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Inilak sa tit-iwa, at paneknekak kan chakayu ay hiya nan Anak Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","As nan kafikiatana, nangatakchug hid-i kasin cha Juan ya nan chuwa ay disipulusna. ");
INSERT INTO ebk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kun pay inilan Juan hi Jesus ay cha mar-os, kenalina, “Chiyuy nan Korderon Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chinngor nan chiyuycha chuwa ay disipulus Juan nan kenalina, at inmunudcha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nunsakong hi Jesus, ya inilana chicha ay cha umunud kan hiya. Angkiay senarudsudna kan chicha, “Ay wachay chayu anapun?” “Rabbi, ay chaud man paat nan mamagyanam?” Ensongfiatcha. (Nan laychun ay kanan nan Rabbi at “Misturu”). ");
INSERT INTO ebk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kenalen us Jesus, “Akayu ta ilaunyu.” Isunga nakiuycha kan hiya, at inilacha nan mamagyanana, nakepagyancha kan hiya as nan hana ay urkiw, tay alas kuwatro as nan makiayud. ");
INSERT INTO ebk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Hi Andres ay sunúd Simon Pedro at hiya nan usa as nan chiyuycha chuwa ay nanngor as nan infiakian Juan ya nakiuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Uy enanap Andres omona hi Simon ay sunúdna. Kuna pay inila, kenalina kan hiya, “Nad-ananmi nan Mesias.” (Nan laychun ay kanan nan Mesias at Cristo.) ");
INSERT INTO ebk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Angkiay ya intun-udna hi Simon kan Jesus. Entoongan Jesus hi Simon, ya kanana, “He-a hi Simon ay potot Juan. Mangadnankantu as Cefas.” (Nan laychuna ay kanan at Pedro.) ");
INSERT INTO ebk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","As nan kafikiatana, ninumnum Jesus ay umuy ad Galilea. Ininchanana hi Felipe, ya kanana kan hiya, “Aka, unuchunak.” ");
INSERT INTO ebk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Hi Felipe at i-Betsaida ay kailiyan cha Andres kan Pedro. ");
INSERT INTO ebk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Naanapan Felipe hi Natanael, ya infiakiana kan hiya, “Ininchananmi nan chiyuy taku ay insurat Moises as nan liblon chi Lintig ya nan insurat us nan chiyuycha pomapadtu. Hiya hi Jesus ay i-Nazaret ay potot Jose.” ");
INSERT INTO ebk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Angkiay ya kenalen Natanael kan hiya, “Ay wacha ngun paat chi ammay ay murpu ad Nazaret?” “Aka at kayya ta ilaum!” kenalen Felipe. ");
INSERT INTO ebk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kun pay inilan Jesus hi Natanael ay cha omali kan hiya, infiakiana nan maepangkep kan hiya, “Nauy nan tit-iwa ay kianak Israel ay maid poros kenasikap kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","As nan hiyachi, kenalen Natanael kan Jesus, “Anan nangammuwam kan ha-un?” Tinumfor hi Jesus, “Inilak he-a as nan puon nan kaiw ay igos sakbay ayakian chaká kan Felipe.” ");
INSERT INTO ebk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tinumfor hi Natanael, “Misturu, he-a payat nan Anak Apo Dios! He-a nan Aren nan Israel!” ");
INSERT INTO ebk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tinumfor hi Jesus, “Enmafurotka o-ngun kiapú ta kenalek un inilak he-a as nan puon nan kaiw ay igos. Ilaumtu nan ongoongor ay nakaskaschaaw ay ommat mu nan nauycha.” ");
INSERT INTO ebk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Angkiay ya kenalen Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa ay ilaunyuntu ad chaya ay kaman nanatkafian ya nan angheles Apo Dios ay cha um-umuy ya cha komkomsop as nan Naepadtu ay Anak chi Taku.” ");
INSERT INTO ebk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kun pay inmuy chi chuwa ay urkiw, wacha nan chuyas henan ili ad Cana henan probinsiya ay Galilea. Wacha hid-i hi enan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Naayakian us cha Jesus ya nan disipulusna ay makichuyas. ");
INSERT INTO ebk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kun pay nam-in nan fiayas, kenalen enan Jesus kan hiya, “Nam-in at nan fiayascha.” ");
INSERT INTO ebk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kenalen Jesus kan Maria, “Ammi, achiyak ud-ay fifiyangan, tay nan timpok ay mangtongpar as nan planon Apo Dios at chaan pay omali.” ");
INSERT INTO ebk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kenalen enana as nan chiyuycha mafiabfiaor, “Atunyu nan uray ngachana ay ifiakiana kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Wacha hid-i nan nunkaesaad ay unum ay anad-acha-an ay panannu ay naamma as fiatu ay natotorwan as ifuru, tay wacha nan iniili ay ukialen chi Judio maepangkep as nan ustu ay atun ay munfuru. Nan usa ay panannu at ittuna nan kiayud hinfialilis ay chanum. ");
INSERT INTO ebk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kenalen Jesus as nan chiyuycha mafiabfiaor, “Punuwunyu nan hanacha panannu as chanum.” Pinnucha tit-iwa am-in. ");
INSERT INTO ebk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Angkiay ya kenalina kan chicha, “Pomaok kayu as nan hana chanum, ya iyuyyu as nan mangenongnongnong as nan nauy chuyas.” Inyuycha tit-iwa. ");
INSERT INTO ebk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Angkiay ya tenamtaman nan mangenongnongnong as nan chuyas nan chanum ay nunfialin as fiayas. Achina ammu nan nurpuwana, ngem nan chiyuycha mafiabfiaor ay penmaok as nan chanum at chicha nan nangammu. Isunga enayakiana nan chiyuy chinmuyas ay laraki, ");
INSERT INTO ebk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ya kanana kan hiya, “Nan iniili ay ukialen nan tataku at epaikopcha omon-ona nan am-ammay ay fiayas, ya kun pay chakus enpapas nan mangili ay inmikop, ichatcha nan achi am-ammay ay fiayas. Ngem he-a at intupugmu nan am-ammay ay fiayas inkiana ad wani.” ");
INSERT INTO ebk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nan enat Jesus ad Cana ad Galilea at hiyana nan enmon-ona ay nakaskaschaaw ay sinyar ay nangepail-ana as nan kaichayawana, at kaskasin enmafurot nan disipulusna kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","As nan narpasan nan chuyas, inmuy hi Jesus ad Capernaum ay kadwana cha enana, nan susnúdna, ya nan disipulusna. Hid-i nan nagyanancha as kaat ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","As nan kiayud umchanan nan Fiastan chi Judio ay makali un Munlausan, enmabrat cha Jesus ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sinungkop hiya as Templo, ya ininchanana nan tataku ay cha mun-el-elaku as fiaka, karnero ya karopati, ya nan chiyuycha munsoksokat as siping ay nangatokor. ");
INSERT INTO ebk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Isunga nun-amma hi Jesus as saplet ay tali, ya enpak-akna manipud as nan Templo nan am-in ay mun-el-elaku, ya enafugna nan karnerocha ya fiakacha. Inwakletna us nan siping nan chiyuycha munsoksokat as siping, ya enlokabfuna nan lamesaancha. ");
INSERT INTO ebk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kenalina as nan chiyuycha mun-el-elaku as karopati, “Ipitiwyu at am-in chaná! Achiyu man munfialinun nan afong Amak as mun-el-elakwan!” ");
INSERT INTO ebk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nanumnum nan disipulusna nan naisurat as nan Kalen Apo Dios ay kanana, “Nan mangesasaketak as nan afongmu at hiya nan ekatuyku.” ");
INSERT INTO ebk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kiapú as nan enat Jesus, kenalen nan anap-apon chi Judio kan hiya, “Ngachana nan nakaskaschaaw ay sinyar ay atum as mangepail-am kan chakami ay wachay kalibfengam ay mangekaman as nan nauycha?” ");
INSERT INTO ebk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tinumfor hi Jesus kan chicha, “Okrangunyu nan nauy Templo, at kiaufoktu as kun turu ay urkiw.” ");
INSERT INTO ebk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Angkiay ya kenalen nan chiyuycha Judio kan hiya, “Opat puru ya unum ay tawwun nan nakiaufian nan nauy ay Templo, ya kanam un kun turu ay urkiw chi mangkiaufiam kasin?” ");
INSERT INTO ebk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngem nan templo ay kenalen Jesus at hiya nan achorna. ");
INSERT INTO ebk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Isunga as nan natakuwan Jesus manipud as nan utúy, ninumnum nan disipulusna nan nauy kenalina. Angkiay ya enafurotcha nan naisurat as nan Kalen Apo Dios ya nan infiakian Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","As nan nakifiastaan Jesus ad Jerusalem, ongorcha nan enmafurot kan hiya as nan nangil-ancha as nan chiyuycha nakaskaschaaw ay sinyar ay enatna. ");
INSERT INTO ebk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ngem chaana entalek nan achorna kan chicha, tay aammuna nan numnum nan tataku. ");
INSERT INTO ebk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Achi kis-an wacha nan mangepaneknek kan hiya as nan maepangkep kan chicha, tay hiya mismu at aammuna nan wacha as numnumcha. ");
INSERT INTO ebk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wacha nan usa ay membron nan bunggoy chi Fariseo ay nan ngachana at Nicodemo ay ap-apon chi Judio. ");
INSERT INTO ebk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","As nan henlafi, inmuy hiya kan Jesus, ya kanana, “Misturu, ammumi ay usaka ay mun-isursuru ay infiaor Apo Dios, tay maid makaekaman as nan nauycha nakaskaschaaw ay sinyar ay cham at-atun sukúd wacha hi Apo Dios kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tinumfor hi Jesus kan hiya, “Ifiakiak kan he-a nan tit-iwa. Maid maetapi henan muntorayan Apo Dios sukúd maiyanak kasin.” ");
INSERT INTO ebk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Senarudsud Nicodemo kan hiya, “Anuy man atun nan taku ay kasin maiyanak mu chakus at narakay? Ay kun mafialin ay kasin sungkop as nan puton enana ta maipidwa ay maiyanak? Achi met!” ");
INSERT INTO ebk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tinumfor hi Jesus, “Ifiakiak kan he-a nan tit-iwa. Maid maetapi henan muntorayan Apo Dios sukúd maiyanak as chanum ya as Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nan maiyanak as taku at taku challu, ya nan maiyanak as Espiritu Santo at naespirituwan. ");
INSERT INTO ebk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Achika koma maschaaw as nan nangaliyak kan he-a un masapor maiyanak kayu kasin. ");
INSERT INTO ebk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nan angin at umuy as kumpurmi ay ay-ayana. Chungrum nan atifungugna, ngem achim ammu nan nurpuwana winnu ay-ayana. Assesa us nan chunon nan Espiritu Santo as nan am-in ay tataku ay maiyanak kasin.” ");
INSERT INTO ebk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Senarudsud kasin Nicodemo kan hiya, “Anan atun man tona ay ommat?” ");
INSERT INTO ebk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","“Ayokayong!” kenalen Jesus. “Usaka met ay misturon nan chiyuycha kianak Israel, ya achim pay laing maawatan na? ");
INSERT INTO ebk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ifiakiak kan he-a nan tit-iwa. Ifiakiami nan ammumi ya paneknekanmi nan inilami, ngem kunyu achi awatun nan pammaneknekmi. ");
INSERT INTO ebk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mu hiyasa ay nan infiakiak maepangkep as nan wacha asna's luta at achiyu afurotun, anan atunyu ay mangafurot mu ifiakiak nan maepangkep as nan wacha ad chaya? ");
INSERT INTO ebk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maid pay inmuy ad chaya omangkiay nan Naepadtu ay Anak chi Taku ay kenomsop ay nurpu ad chaya. ");
INSERT INTO ebk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kaman as nan nangetag-uyan Moises as nan inur-urug ay kianfiang as nan tukud henan disyerto, masapor us assesa nan maekaman as nan Naepadtu ay Anak chi Taku ");
INSERT INTO ebk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ta nan uray ngachana ay omafurot kan hiya at mawad-an as fiyag ay maid patingkiana.” ");
INSERT INTO ebk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Kiapú ta laylaychun Apo Dios as solet nan tataku asna's luta, inchatna nan us-usa ay Anaknata nan uray ngachana ay omafurot kan hiya at achi machusa ay maisiyan kan Apo Dios, ngem mawad-an as fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tay chaan finaor Apo Dios nan Anakna asna's luta ta keddengana ay manusa as nan tataku, ngem kuna at finaor ta maesarakancha babaen kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nan taku ay omafurot kan hiya at achi makeddengan ay machusa. Ngem nan taku ay achi omafurot at chakus naokóm ay machusa, tay chaana enafurot nan us-usa ay Anak Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Hiyana nan kiapón nan maokománcha: Enmali nan silaw ay manilaw as numnum nan tataku asna's luta, ngem lenaylayadcha nan ngongot mu nan silaw, tay mangotettet nan chacha atuatun. ");
INSERT INTO ebk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tay nan ngachana ay cha mangekamkaman as mangotettet at kaiingorna nan silaw. Achina laychun ay maesnop as nan silaw, tay achina laychun ay maepaila nan mangotettet ay chana atuatun. ");
INSERT INTO ebk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ngem nan taku ay cha mangekamkaman as tit-iwa at maesnop as nan silaw ta maepaila ay ustu ay nan chana at-atun at nurpu kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","As nan narpasan tona, inmuy hi Jesus ya nan disipulusna henan probinsiya ay Judea. Hid-i nan nayaschiyancha ay nunfunfunyag. ");
INSERT INTO ebk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hi Juan us at cha munfunfunyag ad Enon ay sag-un nan Salim, tay ongor chi chanum hid-i. Chacha um-umuy nan tataku kan hiya, ya chana funfunyakian chicha. ");
INSERT INTO ebk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","As nan hiyachi, chaan pay naifiarud hi Juan. ");
INSERT INTO ebk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nunlapuy sososek nan disipulus Juan ya nan usa ay Judio maepangkep as nan panagcharos. ");
INSERT INTO ebk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Isunga inmuycha kan Juan, at kenalicha, “Misturu, ay manumnummu nan chiyuy taku ay kadwam as nan usa ay chumang nan wawwang ay Jordan, nan chiyuy pay challu penaneknekam kan chakami? Cha munfunfunyag hiya, ya chacha um-umuy am-in chi tataku kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tinumfor hi Juan, “Maid saad as nan fiyag ay maawat chi taku sukúd ichat Apo Dios kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Chakayu ay mismu nan mangepaneknek as nan kenalek un, ‘Fiakun ha-un nan Cristo, ngem infiaorak ay mangon-ona mu hiya.’ ");
INSERT INTO ebk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nan nauy at maepachong as nan chuyas nan chumuyas ay laraki ya nan chumuyas ay fiafiai. Nan kiayyum nan chumuyas ay laraki at hiya nan mangenongnong as nan sakiana as nan chuyas. Munsusuud ya chumngor hiya as nan munfiangchan nan chumuyas ay laraki. Kuna pay chungrun nan kalina, ongor nan lagsakna. Assesantu nan lagsakku, tay ha-un nan maepachong as nan hana kiayyum. ");
INSERT INTO ebk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Masapor omam-amud hiya, ya ha-un at masapor omap-apuchak.” ");
INSERT INTO ebk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nan omali ay murpu as ngatu at nangatngatu as nan am-in. Nan chiyuy murpu asna's luta at kun challu asna's luta nan kawad-ana, ya nan chana apaapatun at maepangkep yangkiay as nan wacha asna's luta. Ngem nan omali ay murpu ad chaya at hiya nan nangatngatu as nan am-in. ");
INSERT INTO ebk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Paneknekana nan inilana ya chinngorna, ngem kun maid omafurot as nan pammaneknekna. ");
INSERT INTO ebk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nan taku ay omafurot as nan pammaneknekna at penaneknekana ay tit-iwa nan kenalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tay nan infiaor Apo Dios at ifiakiana nan kalen Apo Dios, tay inchat Apo Dios kan hiya nan am-in ay pannakafialin nan Espirituna. ");
INSERT INTO ebk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nan Dios Ama at laylaychuna nan Anakna, ya am-in ay ka-ichin at inpurangna kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nan uray ngachana ay omafurot as nan Anakna at mawad-an as fiyag ay maid patingkiana. Ngem nan achi mangtongpar as nan Anakna at achi mawad-an as fiyag, ngem kun at mawad-an as nan ichusan Apo Dios in-inkiana. ");
INSERT INTO ebk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chinngor nan chiyuycha Fariseo ay ong-ongor chi cha aw-awisun ya funfunyakian Jesus as papasorotna mu hi Juan. ");
INSERT INTO ebk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ngem nan kenatit-iwana at chaan nunfunfunyag hi Jesus mismu, ngem kun at nan disipulusna yangkiay. ");
INSERT INTO ebk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kun pay naammuwan Jesus ay chinngor nan chiyuycha Fariseo na, nak-ak hiya ad Judea ya nunfiangad ad Galilea. ");
INSERT INTO ebk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","As nan hiyachi, masapor mar-os hiya henan probinsiya ay Samaria. ");
INSERT INTO ebk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Inumchan cha Jesus ad Sicar ay usa ay ili ad Samaria ay achi achawwi henan luta ay enpatawid Jacob kan Jose ay pototna. ");
INSERT INTO ebk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wacha hid-i nan fufun chin Jacob. Kun pay nabray hi Jesus ay nanarcharan, tenmokor hiya as nan fianang nan fufun. Kiayud munkiawa as nan hiyachi. ");
INSERT INTO ebk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","As nan hiyachi, enmali ay somakchu nan usa ay fiafiai ay i-Samaria. Kenalen Jesus kan hiya, “Ettanak pay as ikopok?” ");
INSERT INTO ebk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kun pay nan disipulus Jesus at inmuycha henan ili ta uycha lomaku as kanuncha. ");
INSERT INTO ebk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","“Ha? Kunka cha Judio ya, anuyka kumchaw as ikopum kan ha-un ay fiafiai ay i-Samaria?” ensongfiat nan fiafiai. (Tay nan chiyuycha Judio at achicha makekadkadwa as nan chiyuycha i-Samaria.) ");
INSERT INTO ebk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tinumfor hi Jesus kan hiya, “Mu naammuwam koma nan ichat Apo Dios ya mu ngachana nan cha kumchaw as ikopuna kan he-a, kumchawka koma kan hiya, at ettan chaká as chanum ay umichat as fiyag.” ");
INSERT INTO ebk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kenalen nan fiafiai, “Sir, maid met kayong esakchom, ya nan fufun at narosong. Ay chaud ngay nan omor-am as nan hana chanum ay umichat as fiyag? ");
INSERT INTO ebk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ay am-amudka mu nan kaap-uwan takú ay chin Jacob? Hiya met nan nangepatawid as nan nauy fufun kan chakami, ya hena us nan inmig-ikopana patí nan an-akna ya nan chiyuycha tarakoncha.” ");
INSERT INTO ebk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kenalen Jesus, “Nan am-in ay umikop as nan nauy ay chanum at masketan kasin. ");
INSERT INTO ebk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ngem nan uray ngachana ay umikop as nan chanum ay ichatku kan hiya at achintu poros masmasketan. O, nan chanum ay ichatkuntu kan hiya at munfialin as ugwor as achorna ay achi makmak-et ay umichat as fiyag ay maid patingkiana.” ");
INSERT INTO ebk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chinawat nan fiafiai kan hiya, “Sir, ichatmu pay na ngarud ay chanum kan ha-un ta achiyak kasin masmasketan, winnu omar-ali hena ay somakchu.” ");
INSERT INTO ebk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kenalen Jesus kan hiya, “Uymu ayakian hi asawam, at munfiangadka hena.” ");
INSERT INTO ebk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Maid met kang asawak,” ensongfiat nan fiafiai. “Tit-iwa met nan kenalem ay maid asawam,” kenalen Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Namen lemaka ay enmasawa, ya fiakunmu asawa nan laraki ay enteteponmu ad wani. Tit-iwa nan infiakiam kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Sir,” kenalen nan fiafiai, “madlawku ay usaka payat ay pomapadtu! ");
INSERT INTO ebk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nan kaap-uwanmi met ay i-Samaria at henan nauy ay chuntug nan nunchaychayawancha kan Apo Dios, ngem chakayu ay Judio at kananyu un masapor ad Jerusalem nan munchaychayawan takú.” ");
INSERT INTO ebk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","“Ammi,” ensongfiat Jesus, “afurotum nan kanak ay omalintu nan timpu ay fiakun hena ay chuntug winnu ad Jerusalem nan munchayawanyu kan Dios Ama. ");
INSERT INTO ebk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Chakayu ay i-Samaria at achiyu am-ammu nan chayu chaychayawun. Chakami ay Judio at am-ammumi nan chami chaychayawun, tay kan chakami nan nurpuwan nan omesarakan. ");
INSERT INTO ebk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Uray mu hiyasa, cha omali nan timpu, ya nauy at ad wani ay nan chiyuycha tit-iwa ay manangchaychayaw kan Dios Ama at munchaychayawchantu kan hiya babaen as nan Espirituna ya maiyunud as nan kenatit-iwa, tay chatona nan laychun Apo Dios ay munchayaw kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Hi Apo Dios at Espiritu ngamin, ya nan chiyuycha manangchaychayaw kan hiya at masapor munchaychayawcha babaen as nan Espirituna ya maiyunud as nan kenatit-iwa.” Hiyana nan kenalen Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kenalen nan fiafiai kan hiya, “Ammok ay omalintu nan Mesias ay makali un Cristo. As nan omaliyana, epakaammunantu kan chitaku nan am-in.” ");
INSERT INTO ebk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tinumfor hi Jesus, “Ha-un ay cha maketagtakiatfor kan he-a nan cham kankanan.” ");
INSERT INTO ebk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","As nan hiyachi challu, nunfiangad nan disipulusna, at naschaawcha ay nangchan kan hiya ay cha maketagtakiatfor as nan fiafiai. Ngem maid kan chicha nan nangsarudsud as nan fiafiai, “Ngachana nan laychum?” winnu nangsarudsud kan Jesus, “Adchi t'uyka cha maketagtakiatfor kan hiya?” ");
INSERT INTO ebk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Angkiay ya tenaynan nan fiafiai nan sakchuwana, ya nunfiangad henan ili. Kenalina as nan tataku hid-i, ");
INSERT INTO ebk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Akayu kay t'uyyu ilaun nan laraki ay nangifiakia kan ha-un as nan am-in ay en-enatku. Ay fiakun ngun hiya nan Cristo?” ");
INSERT INTO ebk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nak-akcha henan ili, ya inmuycha kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","As nan hiyachi us, cha iyannoannong nan disipulus ay mangali kan Jesus, “Misturu, ayu manganka.” ");
INSERT INTO ebk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngem kenalen Jesus kan chicha, “Wacha nan kanok ay achiyu ammu.” ");
INSERT INTO ebk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Isunga enlapon nan disipulusna ay matatakiatfor, “Ay wacha ngun chi nangiyali kan hiya as makan?” ");
INSERT INTO ebk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kenalen Jesus kan chicha, “Nan kanok at nan mangekamanak as nan laychun nan nangifiaor kan ha-un ya nan manglopasak as nan epadnuna kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ay kun achi wacha nan kankananyu un, ‘Opat ay furan pay sakbay kaseani’? Ilaunyu nan chiyuycha tataku. Nan nauycha tataku ay cha omali at maepachongcha as nan chiyuycha pakuy ay mafialin ay maani. ");
INSERT INTO ebk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nan mun-ani at malagfuwan, ya nan tataku ay chicha nan maepachong as nan aniyuna at ettan Apo Dios as fiyag ay maid patingkiana. Isunga nan muntanum as kalen Apo Dios ya nan mun-ani at munlagragsakcha ay chuwa. ");
INSERT INTO ebk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tit-iwa chaná ay karkali, ‘Nan usa nan muntanum ya tukún nan mun-ani.’ ");
INSERT INTO ebk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Finaorku chakayu ay mun-ani as nan chaanyu inidnuwan. Tukúncha nan nunchunu, ya ad wani maarayu nan inidnuwancha.” ");
INSERT INTO ebk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ongor chi i-Samaria henan hana ay ili nan enmafurot kan Jesus kiapú as nan pammaneknek nan fiafiai un, “Infiakiana kan ha-un nan am-in ay en-enatku.” ");
INSERT INTO ebk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Isunga as nan enmaliyan nan chiyuycha i-Samaria kan Jesus, chinawatcha kan hiya ay makepagyan hiya kan chicha, at nagyan hiya's chi as chuwa ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Enmong-ongorcha nan enmafurot kan Jesus kiapú as nan insursuruna. ");
INSERT INTO ebk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kenalicha as nan fiafiai, “Nan omafurotanmi ad wani at fiakun at kiapú as nan infiakiam, ngem kiapú as nan nanngoranmi ay mismu as nan kenalina. Ammumi ay hi tona nan tit-iwa ay Mangesarakan as nan tataku asna's luta.” ");
INSERT INTO ebk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kun pay inmuy chi chuwa ay urkiw, nak-ak cha Jesus ad Samaria ya inmuycha henan probinsiya ay Galilea. ");
INSERT INTO ebk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tay hi Jesus challu mismu nan nangali un achi maichayaw nan pomapadtu henan mismu ay ilina. ");
INSERT INTO ebk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","As nan enmaliyan cha Jesus ad Galilea, menangilen nan umili hid-i hiya, tay inilacha nan am-in ay en-enatna as nan fiastan chi Judio ad Jerusalem as nan nakifiastaancha hid-i. ");
INSERT INTO ebk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","As nan hiyachi, kasin nunfiangad hi Jesus ad Cana ay ili ad Galilea ay hid-i nan nangepafialinana as nan chanum as fiayas. Wacha nan usa ay opisyar chi goberno ay nan pototna ay laraki at cha munsaket ad Capernaum. ");
INSERT INTO ebk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kuna pay chinngor ay enmali hi Jesus ad Galilea ay nurpu ad Judea, inmuy hiya kan Jesus ya nunpasug-ang kan hiya ay chumayyu ad Capernaum ya epaammayna nan pototna ay kiayud matuy. ");
INSERT INTO ebk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kenalen Jesus kan hiya, “Maid challu omafurot kan chakayu sukúdyu ilaun nan nakaskaschaaw ay sinyar ay maekaman.” ");
INSERT INTO ebk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","“Sir,” kenalen nan opisyar, “makichayyuka man paat kan ha-un ta achi matuy nan pototku.” ");
INSERT INTO ebk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kenalen Jesus, “Komatamka. Omammay nan pototmu.” Enafurot tit-iwa nan opisyar nan kenalen Jesus, at nunligwat ay kenmatam. ");
INSERT INTO ebk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","As nan chana chumayyuwan ay komatam ad Capernaum, sinib-at nan chiyuycha fiabfiaaruna hiya, ya enpachamagcha ay enmammay nan pototna ay laraki. ");
INSERT INTO ebk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Senarudsud nan opisyar kan chicha mu ngachana ay uras nan enmammayan nan pototna. Tinumforcha kan hiya, “Ad kugkia as nan ala ona as nan makiayud nan nakaanan nan puchotna.” ");
INSERT INTO ebk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Haat manumnum nan aman nan onga ay hiyachi nan uras ay nangaliyan Jesus kan hiya, “Omammay nan pototmu.” Isunga hiya ay mismu ya am-in nan membron nan pamilyana at enmafurotcha. ");
INSERT INTO ebk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hiyana nan maekadwa ay nakaskaschaaw ay sinyar ay enat Jesus ad Galilea as nan nurpuwana ad Judea. ");
INSERT INTO ebk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","As nan narpasan tona, wacha nan fiastan chi Judio ad Jerusalem, ya enmabrat cha Jesus ay nakifiasta. ");
INSERT INTO ebk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","As nan sag-un chi Sungkopan chi Karnero ad Jerusalem, wacha nan nanapsong ay mun-om-omsan ay nan ngachana as nan kalen chi Hebreo at Betsata. Naliwus as lema ay fiangsar nan hana mun-om-omsan. ");
INSERT INTO ebk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","As nan nauycha ay fiangsar nan finmafiankan chi ongoongor ay munsaket ay tataku ay kaman as nan chiyuycha nafurag, napilud ya paralitiko. Sasad-un chatona nan munkiwiyan nan chanum, ");
INSERT INTO ebk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tay komsop kanu nan anghel nan Apo mu mamingsan ya ikiwina nan chanum. Mu ngachana kanu nan omon-ona ay pomachak as nan chanum mu marpas ay maikiwi at makaan nan kumpurmi ay saket ay wacha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wacha hid-i nan usa ay laraki ay turon puru ya waru ay tawwun chi nunsasaketana. ");
INSERT INTO ebk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kun pay inilan Jesus hiya ay finmafianak hid-i ya ammuna ay nafiayag chi saketna, kenalina kan hiya, “Ay laychum ay omammay?” ");
INSERT INTO ebk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tinumfor nan laraki ay cha munsaket, “Sir, maid met mangipuuy kan ha-un as nan nanapsong ay mun-om-omsan mu maikiwi nan chanum. As nan chak umuyan as nan maikiwiyan nan chanum, wacha at chi enmon-ona mu ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kenalen Jesus kan hiya, “Tomakchugka, araum nan apragmu ya manaranka.” ");
INSERT INTO ebk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hiya at chi ya enmammay nan laraki. Enarana nan apragna ya nanaran. Enommat na as nan Urkiw ay Mun-iblayan, ");
INSERT INTO ebk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","isunga kenalen nan anap-apon chi Judio as nan laraki ay enmammay, “Urkiw met ay Mun-iblayan, ya achi eparufus nan Lintig takú ay cham a-aagpetun nan apragmu.” ");
INSERT INTO ebk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ngem tinumfor nan laraki, “Infiakian met nan nangepaammay kan ha-un un araok nan apragku ya manaranak.” ");
INSERT INTO ebk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Senarudsudcha kan hiya, “Ngachana nan laraki ay nangali kan he-a un araum nan apragmu, ya manaranka?” ");
INSERT INTO ebk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngem nan laraki ay enmammay at achina ammu mu ngachan tud-i, tay nak-ak hi Jesus ay maid nakadkadlaw kan hiya as nan ongor ay tataku hid-i. ");
INSERT INTO ebk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kun pay naaw-awni as akét, ininchanan Jesus nan laraki as Templo, ya kanana kan hiya, “Ilaum at enmammayka! Ikinakmu ngarud ay cha fumasofiasor ta maid kaskasin likiat as ommat kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nak-ak nan laraki, ya uyna infiakia as nan anap-apon chi Judio ay hi Jesus nan nangepaammay kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hiyana nan kiapúna ay enlapon nan chiyuycha Judio ay namarpalikiat kan Jesus, tay enatna na as nan Urkiw ay Mun-iblayan. ");
INSERT INTO ebk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ngem tinumfor hi Jesus kan chicha, “Hi Amak at achina ikinkinak ay cha munchunchunu ay mangepaila as sug-angna. Assesa us nan chak at-atun.” ");
INSERT INTO ebk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kiapú as nan nauy ay infiakian Jesus, kaskasin enpapaten nan anap-apon chi Judio ay mangpatuy kan hiya, tay chaana yangkiay lenabsing nan Urkiw ay Mun-iblayan, ngem enpachongna pay nan achorna kan Apo Dios as nan nangaliyana un hi Apo Dios nan Amana. ");
INSERT INTO ebk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kenalen Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa. Nan Anak at maid mafialina ay atun as nan mismu ay kalibfengana, ngem atuna nan iilauna ay cha at-atun Amana, tay mu ngachana nan atun nan Ama, atun us nan Anak. ");
INSERT INTO ebk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tay nan Ama at laylaychuna nan Anak, ya am-in nan chana at-atun at enpailana kan hiya. Wacha pay nan epailana kan hiya ay kaskasin nakaskaschaaw mu nan nauycha ta maschaaw kayu. ");
INSERT INTO ebk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tay kaman as nan Ama ay takuwuna nan nunkatuy, assesa us as nan Anak ay takuwuna nan laychuna. ");
INSERT INTO ebk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nan Ama at maid okomuna ay tataku, ngem am-in nan kalibfengan ay mun-okóm at inchatna as nan Anakna ");
INSERT INTO ebk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ta am-in ay tataku at chayawuncha koma nan Anakna ay kaman as nan mangchayawancha as nan Amana. Nan taku ay achi munchayaw as nan Anak at achina us chayawun nan Ama ay nangifiaor kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ifiakiak kan chakayu nan tit-iwa. Nan taku ay manngor as nan kalek ya omafurot as nan nangifiaor kan ha-un at mawad-an as fiyag ay maid patingkiana. Achintu makeddengan hiya ay machusa, tay narpas nan naisiyanana kan Apo Dios, ya nawad-an at hiya as fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ifiakiak kan chakayu nan tit-iwa. Cha omali nan timpu, ya nauy at ad wani ay nan tataku ay naifilang as natuy as nan mangiilan Apo Dios at chungrunchantu nan kalen nan Anak Apo Dios. Nan chiyuycha mangafurot as nan chinngorcha at matakucha. ");
INSERT INTO ebk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tay kaman as nan Ama ay kurpuwan nan mismu ay fiyag, assesa us ay inchatna as nan Anakna nan kalibfengan ay mangichat as nan fiyag. ");
INSERT INTO ebk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Inchatna us as nan Anakna nan kalibfengan ay mun-okóm, tay hiya nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Achi kayu maschaaw as sa, tay cha omali nan timpu ay am-in nan nunkatuy at chungruncha nan kalina, ");
INSERT INTO ebk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ya fomoknagcha as nan nailurubkancha. Nan chiyuycha nangekamkaman as ammay at matakuchantu manipud as nan utúy ta maichat kan chicha nan fiyag ay maid patingkiana. Ngem nan chiyuycha nangekamkaman as mangotettet at matakuchantu manipud as nan utúy ta makeddengancha ay machusa in-inkiana.” ");
INSERT INTO ebk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Inturuy Jesus, “Maid maekamanku as nan mismu ay kalibfengak. Mun-okomák yangkiay ay maiyunud as nan ifiakian Amak kan ha-un. Isunga ustu nan atok ay mun-okóm, tay fiakun nan laychok nan atok mu achi yangkiay nan laychun nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Mu ha-un ay mismu nan mangepaneknek as nan maepangkep kan ha-un, achi maafurot nan ifiakiak. ");
INSERT INTO ebk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wacha us hi Amak ay mangepaneknek as nan maepangkep kan ha-un, ya ammok ay tit-iwa nan ifiakiana. ");
INSERT INTO ebk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Nan usa pay at wachacha nan finaoryu ay inmuy kan Juan, ya penaneknekan Juan kan chicha nan tit-iwa maepangkep kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Achek masapor chi taku ay mangepaneknek as nan maepangkep kan ha-un. Ngem epanumnumku yangkiay nan infiakian Juan ta omafurot ya maesarakan kayu. ");
INSERT INTO ebk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Hi Juan at maepachong as nan pingki ay cha kumarkiarud ya sumilsilaw, ya lenarayadyu as hen-omaketan ay nangkiankianas as nan lawagna. ");
INSERT INTO ebk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ngem nan pammaneknek ay wacha kan ha-un at narawrawag pay mu nan hana pammaneknek Juan. Tay nan nauycha chunu ay chak lopasun ay enpatongpar Amak kan ha-un at chatona challu nan mangepaneknek as nan maepangkep kan ha-un ay hi Amak nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hi Ama ay nangifiaor kan ha-un at hiya mismu nan mangepaneknek as nan maepangkep kan ha-un. Chaanyu poros chinchinngor nan kalina winnu inil-ila nan lupana. ");
INSERT INTO ebk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Achiyu ittu nan kalina as numnumyu, tay achi kayu omafurot as nan infiaorna. ");
INSERT INTO ebk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Komakud kayu ay cha mangachaachar as nan naisurat as nan Kalen Apo Dios, tay ka-ananyu un assid-i nan atunyu ay manganap as fiyag ay maid patingkiana. Chatosa ay naisurat nan mangepaneknek as nan maepangkep kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Uray mu hiyasa, kunyu challu achi laychun ay omali kan ha-un ta mawad-an kayu as fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Achek awatun nan pammachayaw nan tataku kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngem ammok chakayu, at ammok ay maid layadyu kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Enmaliyak babaen as nan kalibfengan Ama ya kunak achi awatun kan chakayu. Ngem mu wacha nan omali babaen as nan mismu ay kalibfengana, kun at hiya nan awatunyu. ");
INSERT INTO ebk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Anan atunyu man ngarud ay omafurot? Tay enha nan laychunyu at awatunyu nan pammachayaw nan tunggal usa kan chakayu, ngem achiyu met pachasun ay manganap as nan chayaw ay murpu as nan us-usa yangkiay ay Dios. ");
INSERT INTO ebk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Achiyu kanan un ha-un nan mangicharumtu kan chakayu as nan Amak. Tay nan mangicharum kan chakayu at chin Moises ay namnamaunyu ay mangesarakan kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mu enafurotyu chin Moises at afurotunak us koma, tay insuratna nan maepangkep kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngem mu achiyu afurotun nan insuratna, anan atunyu ay mangafurot as nan kanak?” ");
INSERT INTO ebk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","As nan narpasan tona, kinumchang hi Jesus henan fiayfiay ay Galilea ay ngenadnancha us as Fiayfiay ay Tiberias. ");
INSERT INTO ebk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Inmunud kan hiya nan ongoongor ay tataku, tay inilacha nan chiyuycha nakaskaschaaw ay sinyar ay en-enatna as nan nangepaammayana as nan chiyuycha munsaket. ");
INSERT INTO ebk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","As nan inumchanancha ad chumang, tinmikid hi Jesus ya nan disipulusna henan usa ay chuntug, ya tenmokorcha hid-i. ");
INSERT INTO ebk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","As nan hiyachi ay timpu, kiayud umchan nan Fiastan chi Munlausan ay fiastan chi Judio. ");
INSERT INTO ebk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kun pay inilan Jesus nan ongoongor ay tataku ay cha omali kan hiya, kenalina kan Felipe, “Ay chaud ngun nan lomakwan takú as kanun chatona ay tataku?” ");
INSERT INTO ebk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Senarudsudna chi ay manisting yangkiay kan Felipe, tay aammon Jesus mismu nan atuna. ");
INSERT INTO ebk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tinumfor hi Felipe, “Tuan! Uray chuwan kiasot ay dinario nan elaku takú as makan at achi challu ommat as hen-anak-etuncha.” ");
INSERT INTO ebk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kenalen nan usa as nan disipulusna ay hi Andres ay sunúd Simon Pedro kan Jesus, ");
INSERT INTO ebk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wacha nan usa ay fumarfiaru hena ay nananngát as lema ay tenapay ay naamma as kaman safug ya chuwa ay filis, ngem ay kun challu ommat na kan chatona am-in ay tataku?” ");
INSERT INTO ebk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kenalen Jesus as nan disipulusna, “Patokoronyu nan tataku.” Ongor chi lukiam hid-i, isunga hiyachi nan tenmokoran nan tataku. Nan filang nan lanaraki at umuy as leman lifu. ");
INSERT INTO ebk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Angkiay ya enaran Jesus nan chiyuycha tenapay ya nunyaman kan Apo Dios. Kun pay narpas sa, enpaiwarasna as nan disipulusna ay nangiwaras as nan chiyuycha nangatokor ay tataku. Assesa us nan enatna as nan chuwa ay filis ay enpaiwarasna inkiana nasufucha am-in. ");
INSERT INTO ebk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kuncha pay am-in nasufu, kenalen Jesus as nan disipulusna, “Amongunyu am-in nan chinaancha ta maid masayang.” ");
INSERT INTO ebk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Isunga enamongcha nan chinaancha ay namnu as nan hinpuru ya chuwa ay uppig as nachaan as nan lema ay tenapay. ");
INSERT INTO ebk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kun pay inilan nan tataku nan nakaskaschaaw ay enat Jesus, kenalicha, “Tit-iwa ay hi tona nan Pomapadtu ay naepadtu ay omali asna's luta.” ");
INSERT INTO ebk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hi Jesus at ammuna ay kiayudcha omali nan tataku ya peletuncha hiya ta munfialin as ari. Kiapú as na, nauusa ay inmuy kasin henan chuntug. ");
INSERT INTO ebk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kun pay cha maschum, chinmayyucha nan disipulus Jesus henan olet nan fiayfiay. ");
INSERT INTO ebk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nunlukiancha as nan fiangka, ya inligwatcha ay kumchang ad Capernaum. Kun pay naschum, maid pay laing hi Jesus kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","As nan hiyachi, nawacha at chi challuyon, tay mun-atifudfud chi angin. ");
INSERT INTO ebk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kun pay inmuy as lema winnu unum ay kilometro nan kinchangcha, inilacha hi Jesus ay cha manarcharan henan oson nan chanum, ya cha maesnop as nan fiangka. Inmugyatcha as solet. ");
INSERT INTO ebk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ngem kenalen Jesus kan chicha, “Ha-un na! Achi kayu umugyat.” ");
INSERT INTO ebk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Angkiay ya laraychuncha ay mangilukian kan hiya. Hiya at chi ya inumchancha as nan olet nan lukiar ay ay-ayancha. ");
INSERT INTO ebk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","As nan kafikiatana, nan ongoongor ay tataku ay nataynan ad chumang at sisin-udcha hi Jesus. Nanumnumcha ay kun usa nan fiangka ay wacha hid-i as nan lafi, ya ammucha us ay chaan nakilukian hi Jesus, ngem kun yangkiay nan disipulusna. ");
INSERT INTO ebk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","As nan hiyachi, nan tapina ay fiangka ay nurpu henan ili ay Tiberias at enmalicha as nan sag-un nan lukiar ay nanganancha as tenapay as nan narpasan nan nunyamanan Apo Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kun pay inilan nan tataku ay maid hi Jesus hid-i winnu nan disipulusna, nunlukiancha as nan chiyuycha fiangka, ya inmuycha ad Capernaum ay uy manganap kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kuncha pay ininchanan hi Jesus ad chumang nan fiayfiay, kenalicha kan hiya, “Misturu, kaatna payat chi enmaliyam hena?” ");
INSERT INTO ebk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","“Ifiakiak kan chakayu nan tit-iwa,” ensongfiat Jesus. “Chaak anaanapun kan chakayu, fiakun kiapú ta naawatanyu nan nakaskaschaaw ay sinyar ay inil-ilayu, ngem kiapú ta nangan kayu as nan tenapay ya nasufu kayu. ");
INSERT INTO ebk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Achi kayu munforay para as nan makan ay machachael, ngem kun kayu munforay para as nan makan ay umichat as fiyag ay maid patingkiana. Nan mangichat as nan nauy ay makan kan chakayu at hiya nan Naepadtu ay Anak chi Taku, tay enpailan Dios Ama kan hiya nan panang-aprobarna.” ");
INSERT INTO ebk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Angkiay ya senarudsudcha kan hiya, “Ngachana man nan masapor ay atunmi ta ekamanmi nan laychun Apo Dios?” ");
INSERT INTO ebk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tinumfor hi Jesus kan chicha, “Nan laychun Apo Dios ay atunyu at omafurot kayu as nan infiaorna.” ");
INSERT INTO ebk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Senarudsudcha kan hiya, “Ngachana ngarud nan nakaskaschaaw ay sinyar ay epailam ta ilaunmi ya omafurot kami kan he-a? Ngachana nan atum? ");
INSERT INTO ebk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nan kaap-uwan takú at nangancha as ‘mana’ henan disyerto. Tay wacha nan naisurat as nan Kalen Apo Dios ay kanana, ‘Enettana chicha as makan ay nurpu ad chaya.’ ” ");
INSERT INTO ebk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tinumfor hi Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa. Fiakun chin Moises nan nangichat kan chakayu as makan ay nurpu ad chaya, ngem hi Amak. O, hi Amak nan mangichat kan chakayu ad wani as tit-iwa ay makan ay murpu ad chaya. ");
INSERT INTO ebk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tay nan tit-iwa ay makan ay ichat Apo Dios at nan taku ay komsop ay nurpu ad chaya ya umichat as fiyag ay maid patingkiana as nan tataku.” ");
INSERT INTO ebk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kenalicha kan hiya, “Sir, kanayon pay ngarud ay ichatmu kan chakami na ay makan.” ");
INSERT INTO ebk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Infiakian Jesus na ay maepadpachongan kan chicha, “Ha-un nan makan ay umichat as fiyag ay maid patingkiana. Nan taku ay omali kan ha-un at achintu munchugchukiaang, ya nan taku ay omafurot kan ha-un at achintu masmasketan. ");
INSERT INTO ebk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngem kenalek at kan chakayu ay uray inilaak, kun kayu challu achi omafurot. ");
INSERT INTO ebk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nan am-in ay tataku ay etalek Amak kan ha-un at omalichantu kan ha-un, ya nan omali kan ha-un at achektu poros pafiangchun. ");
INSERT INTO ebk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tay kenomsopak ay nurpu ad chaya ay achek ekaman nan laychok, ngem nan laychun nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nan laychun nan nangifiaor kan ha-un at maid poros litawok as uray usa as nan am-in ay entalekna kan ha-un, ngem takuwoktu chicha manipud as nan utúy as nan anongos ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tay nan laychun Amak at am-in nan mamigfig kan ha-un ay Anak ya omafurot kan ha-un at mawad-ancha as fiyag ay maid patingkiana. Takuwoktu chicha manipud as nan utúy as nan anongos ay urkiw.” ");
INSERT INTO ebk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","As nan hiyachi, nan chiyuycha Judio at nunmotmotcha maepangkep kan hiya kiapú as nan kenalina un hiya nan makan ay kenomsop ay nurpu ad chaya. ");
INSERT INTO ebk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kenalicha, “Ay kun fiakun hi tona hi Jesus ay potot Jose? Am-ammu takú met nan amana ya enana. Anuyna kanan ad wani un hiya at kenomsop ay nurpu ad chaya?” ");
INSERT INTO ebk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tinumfor hi Jesus, “Ikinakyu ay cha munmotmotmot. ");
INSERT INTO ebk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Maid taku ay makaali kan ha-un sukúd hi Amak ay nangifiaor kan ha-un nan mangepaali kan hiya, ya takuwoktu hiya manipud as nan utúy as nan anongos ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tay wacha nan insurat nan chiyuycha pomapadtu ad pus-uy ay kanana, ‘Am-in ay tataku at isuruwantu Apo Dios.’ Nan am-in ay chumngor ya munsuru kan Ama at omalicha kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Achek kanan un wacha nan nangila kan Ama, tay maid nakaila kan hiya omangkiay nan usa ay nurpu kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ifiakiak kan chakayu nan tit-iwa. Nan taku ay omafurot kan ha-un at mawad-an as fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ha-un nan makan ay umichat as fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nan kaap-uwanyu ad pus-uy at uray nangancha as ‘mana’ henan disyerto, ngem natuycha challu. ");
INSERT INTO ebk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngem nan makan ay chak ifiagfiakia kan chakayu at hiya nan kenomsop ay nurpu ad chaya, ya mu ngachana nan mangan as nan nauy ay makan at achintu poros matmatuy. ");
INSERT INTO ebk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ha-un nan makan ay matataku ay kenomsop ay nurpu ad chaya. Mu ngachana nan mangan as nan nauy ay makan, matakuntu hiya in-inkiana. Nan makan ay anna at hiya nan achorku ay ichatku ta am-in ay tataku asna's luta at mafialincha ay mataku.” ");
INSERT INTO ebk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Angkiay ya nunlapuy nunsidla ay susuma as nan chiyuycha Judio, “Anuy man atun tona ay taku ay mangepakan as achorna kan chitaku?” ");
INSERT INTO ebk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kenalen Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa. Mu achiyu kanun nan achor nan Naepadtu ay Anak chi Taku ya ikopun nan charana at maid kan chakayu nan fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nan taku ay mangan as nan achorku ya mangikop as nan charak at mawad-an as fiyag ay maid patingkiana, ya takuwok hiya manipud as nan utúy as nan anongos ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tay nan achorku at hiya nan tit-iwa ay makan, ya nan charak at hiya nan tit-iwa ay maikop. ");
INSERT INTO ebk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nan taku ay mangan as nan achorku ya mangikop as nan charak at mawawacha hiya kan ha-un, ya mawawachaak us kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kaman as nan nangifiaoranak as nan matataku ay Amak ay kurpuwan chi fiyag, ya matakuwak kiapú kan hiya, assesa us ay nan taku ay mangan kan ha-un at mataku kiapú kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ha-un nan makan ay kenomsop ay nurpu ad chaya. Achi kaman as nan makan ay kenan nan kaap-uwanyu ad pus-uy, at natuycha challu. Nan taku ay mangan as nan nauy ay makan at mataku in-inkiana.” ");
INSERT INTO ebk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kenalen Jesus na as nan nun-isuruwana as nan senagoga ad Capernaum. ");
INSERT INTO ebk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kun pay chinngor nan chiyuycha disipulus Jesus nan kenalina, ongor kan chicha nan nangali, “Nalikiat na ay sursuru. Anan chumngor ya omafurot as na?” ");
INSERT INTO ebk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Uray maid nangifiakia kan Jesus, ammuna ay cha munmotmotmot nan disipulusna maepangkep as na, isunga kenalina kan chicha, “Ay kun yangkiay na ya chinukkianyu at nan pammatiyu? ");
INSERT INTO ebk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mu hiyasa, ngachana ngun chi numnumyuntu mu ilaunyu nan Naepadtu ay Anak chi Taku ay ngomatu ay munfiangad as nan sikud ay kawad-ana? ");
INSERT INTO ebk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nan Espiriton Apo Dios at hiya nan umichat as fiyag, tay nan taku at maid poros pannakafialina ay umichat as fiyag. Nan chiyuycha kenalek kan chakayu at nurpu as nan Espiriton Apo Dios ay umichat as fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ngem wachacha nan tapina kan chakayu ay achi omafurot.” Hiyana nan kenalen Jesus, tay ammuna nunlapu as nan laplapuna nan chiyuycha achi omafurot ya nan mangesepsep kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kenalen pay Jesus, “Hiyana nan mangaliyak kan chakayu un maid usa as makaali kan ha-un sukúd paaliyun Amak hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nunlapu as nan hiyachi, ongorcha as nan disipulus Jesus nan nankug kan hiya, ya chaancha inturuy ay nangunud kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Isunga senarudsud Jesus as nan hinpuru ya chuwa ay disipulusna, “Chakayu ngay, ay laychunyu us ay tomaynan?” ");
INSERT INTO ebk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tinumfor hi Simon Pedro, “Apo, anan umunuchanmi challu. He-a met nan kawad-an nan kali ay umichat as fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Afurotunmi ya ammumi met ay he-a nan Nasantowan ay nurpu kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tinumfor hi Jesus, “Ay kunku challu chaan pinili chakayu ay hinpuru ya chuwa? Ngem nan usa kan chakayu at kaman as nan numnum Satanas nan numnumna.” ");
INSERT INTO ebk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nan laychun ay kanan Jesus at hi Judas ay potot Simon Iscariote. Uray usa hiya as nan hinpuru ya chuwa ay disipulusna, hiya challu nan mangesepseptu kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","As nan narpasan tona, nunfiabfiaat hi Jesus henan probinsiya ay Galilea. Achina laychun ay umuy henan probinsiya ay Judea, tay nan anap-apon chi Judio hid-i at chacha anapun chi atuncha ay mangpatuy kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","As nan kiayud umchanan nan fiastan chi Judio ay makali un Fiastan chi Fiawi, ");
INSERT INTO ebk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","kenalen nan lanaraki ay susnúd Jesus kan hiya, “Mak-akka hena ya umuyka ad Judea ta ilaun nan chiyuycha pasorotmu nan nakaskaschaaw ay cham at-atun. ");
INSERT INTO ebk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Maid mangililingub as chana at-atun mu laychuna ay munchinamag hiya as nan tataku. Kiapú ta cham ekamkaman chaná ay nakaskaschaaw, uymu ngarud epaila as nan tataku asna's luta.” ");
INSERT INTO ebk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kenalen nan mismu ay susnúdna chi, tay uray chicha at achicha afurotun hiya. ");
INSERT INTO ebk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kenalen Jesus kan chicha, “Chaan pay omali nan ustu ay timpok ay mangtongpar as nan planon Apo Dios. Ngem kun pay chakayu, mafialin kayu ay umuy hid-i, uray ngachana ay timpu. ");
INSERT INTO ebk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nan tataku asna's luta at achi chakayu mafialin ay inglun. Ngem ha-un at inglunak, tay chak paneknekan ay mangotettet nan chacha atuatun. ");
INSERT INTO ebk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","O, uy kayu ngarud makifiasta. Kun pay ha-un, achiyak makiuy ad wani, tay chaan pay omali nan ustu ay timpok.” ");
INSERT INTO ebk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","As nan nangifiag-ana as na kan chicha, nunfiati hiya ad Galilea. ");
INSERT INTO ebk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kun pay nak-ak nan susnúd Jesus ay nakifiasta ad Jerusalem, inligwat us Jesus ay inmuy. Ngem as nan chana umuyan, chaan nunpadpadlaw ta achi maammuwan chi tataku. ");
INSERT INTO ebk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","As nan hiyachi ay fiasta, cha anapun nan anap-apon chi Judio hiya, ya chacha sarudsuchun, “Ay chaud ngun hiya?” ");
INSERT INTO ebk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ongor chi intubtufon nan ongor ay tataku ay nakifiasta maepangkep kan Jesus. Wachacha nan nangali, “Kun man ammay hiya ay taku.” Kenalen nan tapina, “Aw! Achi ya, tay chana ar-allilawun chi tataku.” ");
INSERT INTO ebk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Uray mu hiyasa, maid nakaiturud ay mangap-apat as nan maepangkep kan hiya as nan sangwanan nan tataku, tay umugyatcha as nan anap-apon chi Judio. ");
INSERT INTO ebk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kun pay kiayud komakinawa nan fiasta, inmuy hi Jesus as Templo, ya nun-isursuru as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Naschaawcha nan anap-apon chi Judio, ya senarudsudcha, “Anuy man nangor-an tona as kenaraingna, tay chaan met nun-us-uswila?” ");
INSERT INTO ebk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tinumfor hi Jesus kan chicha, “Nan chak isursuru at achi murpu kan ha-un, ngem nurpu kan Apo Dios ay nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nan taku ay manglarayad ay mangekaman as nan laychun Apo Dios at maammuwanantu mu nan chak isursuru at nurpu kan Apo Dios winnu nurpu as nan mismu ay kalibfengak. ");
INSERT INTO ebk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nan cha mangifiagfiakia as nan nurpu as numnumna at chana anapun nan mismu ay kaichayawana. Ngem nan cha manganap as kaichayawan nan nangifiaor kan hiya at matalek ya maid kenangutum kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ay kun chaan inchat Moises nan Lintig kan chakayu? Ngem kun challu maid usa kan chakayu as nangtongpar. Mu omafurot kayu as nan hana ay Lintig, adchi t'uyyu cha pachasun ay mangpatuy kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“Naanennetanka! Anan ngachana man nan cha mamachas ay mangpatuy kan he-a?” ensongfiat nan tataku. ");
INSERT INTO ebk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tinumfor hi Jesus kan chicha, “As nan usa ay enatku as nan Urkiw ay Mun-iblayan, naschaaw kayu am-in as nan chiyuy. ");
INSERT INTO ebk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kiapú ta infilin Moises ay sugyatanyu nan an-akyu ay lallaraki, sugyatanyu met as nan maekawaru ay urkiwna uray mu Urkiw ay Mun-iblayan. (Fiakun hi Moises nan nangifilin as na, ngem chicha nan kaap-uwanyu.) ");
INSERT INTO ebk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mu sugyatanyu nan onga ay laraki as nan Urkiw ay Mun-iblayan ta maafurot nan Lintig Moises, adchi ngay t'uy kayu fumungat kan ha-un kiapú ta enpaammayku nan intiru ay achor nan laraki as nan Urkiw ay Mun-iblayan? ");
INSERT INTO ebk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Achi kayu mun-okóm kiapú as nan maila yangkiay, ngem mun-okóm kayu ay maiyunud as nan ustu.” ");
INSERT INTO ebk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","As nan hiyachi, senarudsud nan tapen nan tataku ay wacha ad Jerusalem, “Ay fiakun hi tona ay laraki nan chacha pachasun ay patayun? ");
INSERT INTO ebk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ilaunyu! Nauy met hiya ay cha munkarkali as nan kaongoran chi tataku, ya maid met kankanan nan anap-apu as maekontra kan hiya. Ayokayong! Ay mafigfigcha ngun tit-iwa ay hi tona nan Cristo? ");
INSERT INTO ebk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ngem kun pay hi tona ay laraki, ammu takú met am-in nan nurpuwana. As nan omaliyan nan Cristo, maid kanu mangammu as murpuwana.” ");
INSERT INTO ebk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","As nan cha mun-isuruwan Jesus as Templo, inpigsana ay nangali, “Ay am-ammuwak tit-iwa ya ammuyu nan nurpuwak? Chaanak enmali asna's luta as nan mismu ay kalibfengak. Ngem nan nangifiaor kan ha-un at matalek. Achiyu poros am-ammu hiya, ");
INSERT INTO ebk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ngem am-ammok challu hiya, tay hiya nan nurpuwak, ya hiya nan nangifiaor kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kuna pay infiakia na, penachas nan anap-apu ay mangtiliw kan hiya, ngem maid nakafiael as sa, tay chaan pay omali nan timpuna. ");
INSERT INTO ebk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Uray mu hiyasa, ongor as nan tataku nan enmafurot kan hiya. Kenalicha, “As nan omaliyan nan Cristo, ay ong-ongor ngun chi atuna ay nakaskaschaaw ay sinyar mu nan en-enat tona ay taku?” ");
INSERT INTO ebk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","As nan hiyachi, chinngor nan chiyuycha Fariseo nan intubtufon nan tataku maepangkep kan Jesus. Isunga chicha ya nan anap-apon chi papachi at inmifiaorcha as kukuwarchan nan Templo ay mangtiliw kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kenalen Jesus kan chicha, “Achi mafiayag nan makepagyanak kan chakayu, at munfiangachak as nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Anapunaktu, ngem achiyaktu maanapan, tay achi kayu mafialin ay umuy as nan kawad-aktu.” ");
INSERT INTO ebk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nunsesennarudsud nan anap-apon chi Judio, “Ay chaud ngun nan ay-ayana, t'uy takú kanu achi maanapan hiya? Ay umuy ngun as nan kakailiyan takú ay Judio ay naiwaras henan nasnasyon chi Gentil ta uyna isuruwan nan chiyuycha Gentil? ");
INSERT INTO ebk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Anan laychuna ngun ay kanan as nan nangaliyana un, ‘Anapunaktu, ngem achiyaktu maanapan,’ ya ‘Achi kayu mafialin ay umuy as nan kawad-aktu’?” ");
INSERT INTO ebk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","As nan anongos ya nan kaamuchan ay urkiw as nan Fiastan chi Fiawi, tenmakchug hi Jesus, ya inpigsana ay nangali, “Mu ngachana nan nasketan, omali kan ha-un ay umikop. ");
INSERT INTO ebk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wacha nan naisurat as nan Kalen Apo Dios ay kanana, ‘Nan taku ay omafurot kan ha-un at wachantu kan hiya nan mangichat as tit-iwa ay fiyag ay maepachong as nan ugwor ay cha omay-ayas.’” ");
INSERT INTO ebk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nan nauy ay infiakian Jesus kan chicha at maepangkep as nan Espiriton Apo Dios ay awatuntu nan chiyuycha omafurot kan hiya. As nan hiyachi, chaan pay naichat nan Espiriton Apo Dios, tay chaan pay naepaila nan kaichayawan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nan tapen nan tataku ay nanngor as nan nauy infiakian Jesus at kenalicha, “Tit-iwa, hi tona ay taku nan Pomapadtu ay sasad-un takú.” ");
INSERT INTO ebk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kenalen nan tapina, “Hi tona nan Cristo!” Ngem nan tapina at kenalicha, “Kenomsaw kayu! Ay kun ngun murpu ad Galilea nan Cristo? ");
INSERT INTO ebk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ay chaan naisurat as nan Kalen Apo Dios un nan Cristo at murpu as nan kianak Ari David, ya maiyanak ad Betlehem ay inmiiliyan David?” ");
INSERT INTO ebk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Isunga kun at tukutukún chi mangnunumnum nan tataku as nan maepangkep kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nan tapina kan chicha at laychuncha ay tiliwun hiya, ngem maid usa as nakafiael ay nangekaman as sa kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","As nan nunfiangchan nan chiyuycha kuwarcha, senarudsud nan anap-apon chi papachi ya nan chiyuycha Fariseo kan chicha, “Adchi t'uyyu chaan inyali hiya?” ");
INSERT INTO ebk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","“Maid met kang poros nunkali ay kaman as nan enat tona ay taku,” ensongfiat nan chiyuycha kuwarcha. ");
INSERT INTO ebk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Enot-otyok nan chiyuycha Fariseo chicha, “Ayokayong! Uray us payat chakayu at naallilaw kayu? ");
INSERT INTO ebk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ay wachay ammuyu as usa as nan anap-apu winnu chiyuycha Fariseo ay enmafurot kan hiya? ");
INSERT INTO ebk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ngem as nan nauycha man ongor ay tataku ay achi poros nangammu as nan Lintig Moises at wacha nan tuchor Apo Dios kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hi Nicodemo ay usa kan chicha ay Fariseo ya hiya nan inmuy kan Jesus as nan henlafi at senarudsudna kan chicha, ");
INSERT INTO ebk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ay mafialin ay keddengan nan Lintig takú nan usa ay taku ay machusa sakbay mafistikiar ya maammuwan mu ngachana nan en-enatna?” ");
INSERT INTO ebk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","“Ay i-Galilea ka us payat?” ensongfiatcha. “Ayu, anapum ay ustu nan naisurat as nan Kalen Apo Dios, at maammuwamtu ay maid poros pomapadtu ay murpu ad Galilea.” ");
INSERT INTO ebk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","As nan hiyachi, waschi un kenmatam. ");
INSERT INTO ebk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kun pay hi Jesus, inmuy hiya henan chuntug ay Olivo. ");
INSERT INTO ebk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","As nan wi-ewi-et, nunfiangad hi Jesus as Templo, ya am-in nan tataku at enarufongcha hiya. Tenmokor hiya, ya enlapuna ay mun-isuru kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","As nan chana mun-isuruwan, inyalen nan chiyuycha mun-isursuru as Lintig ya nan chiyuycha Fariseo nan usa ay fiafiai ay tiniliwcha ay naasporancha ay cha umiwet. Enpatakchugcha hiya as nan sangwanan nan ongor ay tataku. ");
INSERT INTO ebk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kenalicha kan Jesus, “Misturu, nan nauy ay fiafiai at naasporan ay cha umiwet. ");
INSERT INTO ebk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","As nan Lintig takú, infilin Moises ay nan assena ay fiafiai at masapor malomtak ta matuy. Anan maifiakiam maepangkep kan hiya?” ");
INSERT INTO ebk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hiyana nan infiakiacha ay manisting kan Jesus ta wachay panforcha ay mangicharum kan hiya. Ngem nunyongyong hi Jesus, ya enosarna nan kiayyamotna ay nunsurat as nan luta. ");
INSERT INTO ebk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","As nan nangepapatiyancha ay nunsarudsud, tenmakchug hi Jesus, ya kanana kan chicha, “Mu ngachana kan chakayu nan maid fiasorna, ayu, hiya nan omona ay manglomtak kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kasin nunyongyong, ya enosarna nan kiayyamotna ay nunsurat as nan luta. ");
INSERT INTO ebk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","As nan nanngorancha as nan kenalina, nak-akcha am-in ay naussaussa manipud as nan kaam-amaan inkiana hi Jesus yangkiay ya nan fiafiai ay nangatakchug hid-i nan nayagyag. ");
INSERT INTO ebk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Angkiay ya tenmakchug hi Jesus, ya kanana kan hiya, “Ammi, ay chaudcha ngay? Ay maid nang-okóm kan he-a?” ");
INSERT INTO ebk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Maid, sir,” ensongfiatna. Kenalen Jesus, “Mu hiyasa ngarud, uray ha-un at achek okomún he-a. Uyka at, ya achika kasin fumasfiasor.” ");
INSERT INTO ebk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kun pay kasin nunkali hi Jesus as nan tataku, infiakiana na ay maepadpachongan: “Ha-un nan silaw ay manilaw as numnum nan tataku asna's luta. Mu ngachana nan umunud kan ha-un, achi poros manaran as nan ngongot, ngem kun at wacha kan hiya nan silaw ay umichat as fiyag.” ");
INSERT INTO ebk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kenontran nan chiyuycha Fariseo hiya, “He-a challu nan cha mangepaneknek as nan maepangkep as achormu. Achi kaaafurot nan cham ifiagfiakia!” ");
INSERT INTO ebk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tinumfor hi Jesus, “Uray mu ha-un nan cha mangepaneknek as nan maepangkep as achorku, tit-iwa nan pammaneknekku, tay ammok nan nurpuwak ya nan ay-ayak. Ngem chakayu, achiyu poros ammu nan nurpuwak ya nan ay-ayak. ");
INSERT INTO ebk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nan atunyu ay mun-okóm at maiyunud as nan numnum chi taku. Ngem ha-un at maid okomók. ");
INSERT INTO ebk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ngem uray mu mun-okomák, ustu nan panang-okómku, tay fiakun yangkiay ha-un nan mun-okóm, ngem kun at chuwa kami kan Amak ay nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Naisurat as nan Lintigyu ay mu munpachong nan pammaneknek chi chuwa ay taku, tit-iwa nan ifiakiacha. ");
INSERT INTO ebk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ha-un ay mismu nan usa ay mangepaneknek as maepangkep as nan achorku, ya nan maekadwa at hi Ama ay nangifiaor kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Senarudsudcha kan Jesus, “Ay chaud nan kawad-an amam?” Tinumfor hi Jesus, “Achiyak met am-ammu, ya achiyu us am-ammu hi Amak. Mu tit-iwa ay am-ammuwak kan chakayu, am-ammuyu us hi Amak.” ");
INSERT INTO ebk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Chatona nan infiagfiakian Jesus as nan chana mun-is-isuruwan as nan Templo as nan sag-un nan mangit-ittuwancha as siping ay maichaton. Ngem maid nangtiliw kan hiya, tay chaan pay omali nan timpuna ay mangtongpar as nan planon Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kenalen kasin Jesus kan chicha, “Awni at mak-akak, ya anapunaktu, ngem matuy kayuntu ay chaan kayu napakawan as nan fiasfiasoryu. O, achi kayu mafialin ay makaali as nan ay-ayak.” ");
INSERT INTO ebk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nunsesennarudsud nan anap-apon chi Judio, “Adchi t'uyna kanan un achi takú mafialin ay makauy as nan ay-ayana? Ay nan laychuna ngun ay kanan at patayuna nan achorna?” ");
INSERT INTO ebk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tinumfor hi Jesus kan chicha, “Chakayu, nurpu kayu asna's luta, ngem ha-un, nurpuwak ad chaya. Nan nunumnumunyu at nan maepangkep asna's luta, ngem ha-un at fiakun. ");
INSERT INTO ebk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hiyasa nan nangaliyak kan chakayu un matuy kayuntu ay chaan kayu napakawan as nan fiasfiasoryu. Tay mu achiyu afurotun ay ha-un nan infiakiak at matuy kayu challu ay chaan kayu napakawan as nan fiasfiasoryu.” ");
INSERT INTO ebk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Anan ngachanmu man?” senarudsudcha kan hiya. “Ayokáyong! Ha-un nan infiagfiakiak challu kan chakayu nunlapu as nan laplapuna inkiana ad wani,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“Kun pay maepangkep kan chakayu, ongor nan mafialin ay kanak ay mangepafiasor kan chakayu. Ngem nan infiakian nan nangifiaor kan ha-un at tit-iwa, ya chak ifiagfiakia as nan tataku asna's luta nan chinngorku yangkiay kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nan chiyuycha nanngor as na at chaancha naawatan ay nan Dios Ama nan infiagfiakiana. ");
INSERT INTO ebk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Isunga kenalen Jesus kan chicha, “As nan mangetag-uyanyuntu as nan Naepadtu ay Anak chi Taku as nan koros, maammuwanyuntu ay ha-un nan chak ifiagfiakia. Maammuwanyuntu us ay maid poros atok as nan mismu ay kalibfengak, ngem kunku yangkiay cha ifiagfiakia nan insuron Amak kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nan nangifiaor kan ha-un at wacha kan ha-un. Achiyak taytaynan ay kun mauusa, tay kunku cha atuatun nan mangepalaylayad kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","As nan nangifiag-an Jesus as sa, ongor nan enmafurot kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","As nan hiyachi, kenalen Jesus as nan chiyuycha Judio ay enmafurot kan hiya, “Mu iturturuyyu ay mangun-unud as nan insursurok, chakayu nan tit-iwa ay disipulusku. ");
INSERT INTO ebk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Maammuwanyuntu nan kenatit-iwa maepangkep kan ha-un, ya nan kenatit-iwa ay anna nan mangwayawayantu kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tinumforcha kan hiya, “Ohu! Kianak chakami met kan Abraham, ya maid usa as namabfiaor kan chakami. Anum kanan un mawayawayaan kamintu?” ");
INSERT INTO ebk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tinumfor hi Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa. Nan ngachana ay fumasor at hiya nan fiabfiaarun nan fiasor. ");
INSERT INTO ebk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nan mafiabfiaor at achi maifilang in-inkiana as nan pamilya, ngem nan anak at maifilang in-inkiana. ");
INSERT INTO ebk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Isunga mu nan Anak Apo Dios nan mangwayawaya kan chakayu, tit-iwa ay mawayawayaan kayu. ");
INSERT INTO ebk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ammok met ay kianak chakayu kan Abraham, ngem laychunak ay patayun, tay achiyu awatun nan chak isurusuru. ");
INSERT INTO ebk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ifiagfiakiak nan maepangkep as nan enpailan Amak kan ha-un. Chakayu at assesa us, tay atunyu nan chinngoryu kan amayu.” ");
INSERT INTO ebk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tinumfor nan chiyuycha Judio kan hiya, “Enham! Chin Abraham nan amami.” Kenalen Jesus kan chicha, “Mu tit-iwa ay an-ak chakayu kan Abraham, atunyu koma nan en-enatna. ");
INSERT INTO ebk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngem chayu met iyan-anap chi atunyu ay mangpatuy kan ha-un ay nangifiakia kan chakayu as nan kenatit-iwa ay chinngorku kan Apo Dios. Maid assesa as en-enat Abraham! ");
INSERT INTO ebk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nan chayu at-atun at nan en-enat amayu.” Kenalicha kan Jesus, “Fiakun kami met bastardo! Hi Apo Dios yangkiay nan amami. Maid tukún.” ");
INSERT INTO ebk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kenalen Jesus kan chicha, “Mu tit-iwa ay hi Apo Dios nan Amayu, laylaychunak a koma, tay nurpuwak met kan Apo Dios, ya ad wani nauyak hena. Chaanak enmali as nan mismu ay kalibfengak, ngem hiya nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Adchi t'uyyu achi maawatan nan chak kankanan? Hiyana challu, tay hinlurlurkunyu ay chumngor as nan ifiakiak. ");
INSERT INTO ebk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Chakayu nan an-ak amayu ay hi Satanas, ya nan laychunyu ay atun at nan laylaychuna. Nunlapu as nan laplapuna at pomapatuy hiya, ya maid poros ifiagfiakiana as kenatit-iwa, tay maid poros kenatit-iwa kan hiya. As nan munkutumana, maiyunud as nan ukialina ay nangutum. Tay hiya at nangutum ya aman chi am-in ay kenangutum. ");
INSERT INTO ebk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ngem kiapú ta chak ifiakia nan kenatit-iwa, achiyak afurotun kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngachana kan chakayu nan mangepaneknek ay finmasorak? Mu ifiakiak nan kenatit-iwa, adchi t'uyak achi afurotun? ");
INSERT INTO ebk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nan anak Apo Dios at chungruna nan karkalen Apo Dios. Ngem fiakuna an-ak chakayu, isunga achiyu chungrun nan kalina.” ");
INSERT INTO ebk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tinumfor nan chiyuycha Judio kan Jesus, “Ay achi tit-iwa nan kananmi un i-Samariaka ya naanennetanka?” ");
INSERT INTO ebk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Maid anennet kan ha-un, ngem kunku at cha chayawun hi Amak. Chakayu at achiyak chayawun,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Achek cha anapun nan mismu ay kaichayawak. Ngem wacha nan usa ay cha manganap as nan kaichayawak, ya hiya nan mun-okóm. ");
INSERT INTO ebk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ifiakiak kan chakayu nan tit-iwa. Mu ngachana nan mangtongpar as nan kalek at achintu matmatuy.” ");
INSERT INTO ebk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kenalicha kan hiya, “Ad wani ammumi ay tit-iwa ay naanennetanka. Hi Abraham at natuy, ya kaman us nan chiyuycha pomapadtu. Ngem kanam pay laing un nan mangtongpar as nan kalem at achi matmatuy. ");
INSERT INTO ebk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ay am-amudka chamman mu chin kaap-uwanmi ay Abraham? Hiya at natuy, ya kaman us nan chiyuycha pomapadtu. Ngachana kang nan mangnunumnummu as achormu?” ");
INSERT INTO ebk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tinumfor hi Jesus, “Mu ichayawku nan achorku, maid kotok nan kaichayawak. Hi Amak nan mangichayaw kan ha-un ay hiya nan kananyu un Apo Diosyu. ");
INSERT INTO ebk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Achiyu poros am-ammu hiya. Kun pay ha-un at am-ammok challu hiya. Mu kanak un achek am-ammu hiya, nangutumak ay kaman kan chakayu. Ngem am-ammok met tit-iwa hiya, ya tongparok nan kalina. ");
INSERT INTO ebk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Naragsak chin kaap-uwanmi ay Abraham as nan nangnumnumana ay ilaunantu nan urkiw ay omaliyak asna's luta. Inilana tit-iwa, at naragsakan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","“Ayokayong! Kuncha maid pay laing leman puru as tawwunmu ya,” kenalen nan chiyuycha Judio kan hiya. “Anum kanan un inilam hi Abraham?” ");
INSERT INTO ebk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tinumfor hi Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa. As nan chaan pay naiyankan Abraham at nawawachaak.” ");
INSERT INTO ebk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","As nan nanngorancha as sa, pinmichetcha as fiatu as elomtakcha kan hiya, ngem nuntafun hi Jesus, ya nak-ak as Templo. ");
INSERT INTO ebk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","As nan nanarcharanan cha Jesus, inilana nan usa ay laraki ay nafufurag nunlapu as nan naiyankana. ");
INSERT INTO ebk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Senarudsud nan disipulusna kan hiya, “Misturu, ngachana nan nakin fiasor t'uy nafufurag na nunlapu as nan naiyankana? Ay nan nauy laraki winnu nan chanakchakorna?” ");
INSERT INTO ebk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","“Fiakun fiasor nan nauy laraki winnu nan chanakchakorna,” ensongfiat Jesus. “Enommat na kan hiya ta maepaila nan pannakafialin Apo Dios kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Masapor atun takú nan epadnon nan nangifiaor kan ha-un, tay kaorkia pay laing. Cha omali nan lafi, at maid makachunu. ");
INSERT INTO ebk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","As nan mawawad-ak pay laing asna's luta, ha-un nan silaw ay manilaw as numnum nan tataku.” ");
INSERT INTO ebk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kun pay kenalen Jesus chaná, tinmubfia as nan luta, at penelotna. Hana at ekapu as nan matan nan laraki. ");
INSERT INTO ebk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kenalina as nan laraki, “Uyka munchor-op as nan Mun-om-omsan ay Siloe.” (Nan laychun ay kanan nan Siloe at naifiaor.) Isunga hiya at chi ya inmuy ya nunchor-op. As nan kenmatamana, makaila at. ");
INSERT INTO ebk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","As nan nangil-an nan sasag-una ya nan chiyuycha sikud ay nangil-ila kan hiya as nan nunlemlemosana, kenalicha, “Ay fiakun hi tona nan laraki ay nangepaingsa ay tomokor ay munlemos?” ");
INSERT INTO ebk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","“O, hiya ya,” kenalen nan tapen nan tataku. Nan tapina at kenalicha, “Fiakun ya. Kaluplupana yangkiay.” Ngem kenalen nan laraki ay mismu, “Ha-un chi ya.” ");
INSERT INTO ebk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Senarudsudcha kan hiya, “Adchi t'uyka makaila ad wani?” ");
INSERT INTO ebk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tinumfor hiya, “Nan taku ay nan ngachana at Jesus at penelotna nan luta, at enkapuna as nan matak. Hana at kanan kan ha-un un umuyak as nan Mun-om-omsan ay Siloe ya munchor-opak hid-i. Isunga hiya at chi ya inmuyak, at nunchor-opak. Kunak pay narpas, makailaak.” ");
INSERT INTO ebk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Ay chaud ngay hiya?” senarudsudcha kan hiya. “Tuan,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Inyuycha nan laraki ay nakaan chi finuragna as nan chiyuycha Fariseo. ");
INSERT INTO ebk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nan urkiw ay namelotan Jesus as nan pitak ya nangaanana as finurag nan laraki at Urkiw ay Mun-iblayan. ");
INSERT INTO ebk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Isunga ensarochakchak nan chiyuycha Fariseo as nan laraki mu adchi t'uy nakaila. Kenalina kan chicha, “Enkapuna nan pitak as matak, at chinor-opak. Ad wani at makailaak.” ");
INSERT INTO ebk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kenalen nan tapen nan Fariseo, “Nan laraki ay nangekaman as na at chaan nurpu kan Apo Dios, tay achina tongparun nan lintig maepangkep as nan Urkiw ay Mun-iblayan.” Ngem kenalen nan tapina, “Mu hiya at fumafiasor challu, anan atuna ay mangekaman as nakaskaschaaw ay sinyar ay kaman as nan nauycha?” Angkiay ya tukutukún at chi mangnunumnumcha as nan maepangkep kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Isunga kasin senarudsud nan chiyuycha Fariseo as nan laraki, “Anan maifiakiam maepangkep kan hiya, tay kenaana nan finuragmu?” “Pomapadtu hiya,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ngem chaan pay enafurot nan anap-apon chi Judio ay nan laraki ay makaila ad wani at naiyanak ay nafufurag. Isunga enayakiancha nan chanakchakorna. ");
INSERT INTO ebk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Senarudsudcha, “Ay hi tona nan anakyu ay laraki ay kananyu un nafufurag nunlapu as nan naiyankana? Adchi ngay t'uy makaila ad wani?” ");
INSERT INTO ebk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tinumfor nan chanakchakorna, “Ammumi ay hi tona nan anakmi ay laraki, ya ammumi ay nafufurag hiya nunlapu as nan naiyankana. ");
INSERT INTO ebk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ngem achimi poros ammu mu adchi t'uy makaila hiya ad wani winnu ngachana nan nangaan as finuragna. Kakunyu sarudsuchun kan hiya, tay inmurúg met, ya mafialina ay songfiatan nan sarudsudyu.” ");
INSERT INTO ebk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kenalen nan chanakchakorna na kiapú ta umugyatcha as nan anap-apon chi Judio, tay nuntuturakian at nan nauycha anap-apu ay mu ngachana nan mamigfig ay hi Jesus nan Cristo at maepak-ak hiya as nan senagogacha. ");
INSERT INTO ebk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Isunga hiyasa nan kiapúna as nangaliyan nan chanakchakorna un inmurúg hiya, ya kan hiya nan munsarudsuchancha. ");
INSERT INTO ebk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kasincha enayakian nan laraki ay nafufurag nunlapu as nan naiyankana. Kenalicha kan hiya, “Chayawum kayong hi Apo Dios ya fiakun hi tona, tay ammumi ay hi tona ay taku ay nangepaammay as matam ta makailaka at fumafiasor.” ");
INSERT INTO ebk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tinumfor hiya, “Achek ammu mu fumafiasor hiya winnu achi. Nan usa ay ammok at nafurakiak, ngem makailaak ad wani.” ");
INSERT INTO ebk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Senarudsudcha kan hiya, “Anan enatna mampay kan he-a t'uy nakaan nan finuragmu?” ");
INSERT INTO ebk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Kunku man infiakia kan chakayu, ya kun kayu achi chumngor,” ensongfiatna. “Adchi t'uyyu laychun ay kasin chungrun? Ay laychunyu us ay munfialin as disipulusna?” ");
INSERT INTO ebk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Angkiay ya ininsurtucha hiya, ya kanancha, “He-a nan disipuluna! Ngem chakami at disipulus Moises! ");
INSERT INTO ebk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ammumi ay nunkali hi Apo Dios kan Moises. Ngem hi tona ay taku, achimi ammu uray nan nurpuwana.” ");
INSERT INTO ebk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tinumfor nan laraki, “Anuy paat nakaskaschaaw as solet! Achiyu ammu nan nurpuwana, ngem kenaana met nan finuragku. ");
INSERT INTO ebk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ammu takú ay achi chumngor hi Apo Dios as nan chiyuycha fumafiasor, ngem chumngor hiya as nan tataku ay mangchayaw kan hiya ya mangekaman as nan laychuna. ");
INSERT INTO ebk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nunlapu as nan nafiayangan nan luta, maid poros nadngor as taku ay nangepaammay as nafufurag nunlapu as nan naiyankana. ");
INSERT INTO ebk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mu nan nauy ay taku at chaan nurpu kan Apo Dios, achi koma makaekaman as assena.” ");
INSERT INTO ebk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tinumforcha kan hiya, “Ohu! Kunka cha fumafiasor nunlapu as nan naiyankam ya. He-a at paat nan mangisuru kan chakami?” Angkiay enpak-akcha hiya as nan senagoga. ");
INSERT INTO ebk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kun pay chinngor Jesus ay enpak-akcha hiya, uyna enanap. As nan nanginchanana kan hiya, senarudsudna, “Ay omafurotka as nan Naepadtu ay Anak chi Taku?” ");
INSERT INTO ebk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“Sir, ifiakiam pay mu anan ngachana ta omafurotak kan hiya,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kenalen Jesus kan hiya, “Inilam at hiya, ya hiya nan cha maketagtakiatfor kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Apo, omafurotak,” ensongfiat nan laraki, at nunchayaw hiya kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kenalen Jesus, “Enmaliyak asna's luta ay mun-okóm ta nan chiyuycha kaman nafurag ay achi nangammu kan Apo Dios at makailacha, ya nan chiyuycha makaila ay mangali un ammucha hi Apo Dios at munfialincha as kaman nafurag.” ");
INSERT INTO ebk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nan tapen nan chiyuycha Fariseo ay naesasag-un kan Jesus at chinngorcha na, ya senarudsudcha, “Ay kanam un nafurag kami us?” ");
INSERT INTO ebk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tinumfor hi Jesus, “Mu nafurag kayu at maid koma fiasoryu. Ngem kiapú ta kananyu un makaila kayu, kukutug nan fiasoryu.” ");
INSERT INTO ebk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Infiakian Jesus na ay maepadpachongan kan chicha: “Ifiakiak kan chakayu nan tit-iwa. Nan taku ay achi sungkop as nan sugpan nan punchag chi karnero, ngem kun uy komarab as nan arad at mangaakiw ya homohold-ap. ");
INSERT INTO ebk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nan taku ay sungkop as nan sugpan at hiya nan mangay-aywan as nan karnero. ");
INSERT INTO ebk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Hiya nan paskopun nan munkukuwarcha as nan sugpan. As nan manguyawan nan mangay-aywan as nan ngachan nan tunggal usa as nan chiyuycha karnerona at ematonancha nan kalina at umuycha kan hiya. Angkiay ya epanguna chicha ay pumitiw. ");
INSERT INTO ebk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kuna pay enpapitiw am-in nan kuwana, epanguna chicha, ya nan karnerona at umunudcha kan hiya, tay ammucha nan kalina. ");
INSERT INTO ebk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Achicha umunud as nan tukún, ngem kuncha at lomayaw ay manaynan kan hiya, tay achicha ammu nan kalina.” ");
INSERT INTO ebk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Hiyana nan maepadpachongan ay infiakian Jesus kan chicha, ngem chaancha naawatan nan laychuna ay kanan. ");
INSERT INTO ebk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Isunga kasin kenalen Jesus kan chicha, “Ifiakiak kan chakayu nan tit-iwa. Ha-un nan maepachong as nan sugpan ay sungkopan nan chiyuycha karnero. ");
INSERT INTO ebk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nan am-in ay enmon-ona ay enmali mu ha-un at chicha nan mangaakiw ya homohold-up, ngem chaan enafurot nan chiyuycha karnero chicha. ");
INSERT INTO ebk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ha-un nan sugpan. Mu ngachana nan sungkop ay manguy kan ha-un at maesarakan. Maepachong hiya as nan karnero ay mafialin ay sungkop ya pumitiw ay mun-anap as munkiarafiana. ");
INSERT INTO ebk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Nan mangaakiw at omali yangkiay ay mangakiw, pomatuy, ya chumachael. Kun pay ha-un, enmaliyak ta nan tataku ay chicha nan maepachong as nan karnerok at mawad-ancha as fiyag ay maid patingkiana ya maid kurangna.” ");
INSERT INTO ebk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Inturuy Jesus, “Ha-un nan ammay ay mangay-aywan as karnero. Nan ammay ay mangay-aywan at nakasakiana ay mangichat as fiyagna para as nan karnerona uray mu matuy hiya. ");
INSERT INTO ebk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nan malagfuwan ay fiakun tit-iwa ay mangay-aywan ya fiakun nakin kuwa as nan karnero at lomayaw ay manaynan as nan karnero mu wachay ilauna as atap ay asu ay cha omali. Nan atap ay asu at chupapuna nan karnero, ya pasisiyanuna chicha. ");
INSERT INTO ebk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Lomayaw hiya kiapú ta hiya at malagfuwan yangkiay, ya achina ayyiwan nan chiyuycha karnero. ");
INSERT INTO ebk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ha-un nan ammay ay mangay-aywan as karnero. O, am-ammok nan karnerok, ya nan karnerok at am-ammuwak us. ");
INSERT INTO ebk_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Hiyasa us kan Ama ay am-ammuwak ya am-ammok us hiya, ya ichatku nan fiyagku kiapú as nan karnerok. ");
INSERT INTO ebk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wachacha nan tapina ay karnerok ay maid pay as nan nauy punchag. Masapor etoróngku us chicha hena, at chumngorchantu as nan kalek. Mu hiyasa, munfialincha as henpamurukian ya usa nan mangay-aywan kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Laylaychunak kan Amak, tay nakasakianaak ay mangichat as nan fiyagku ta kasinak challu mataku. ");
INSERT INTO ebk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maid mangara as nan fiyagku kan ha-un, ngem ha-un challu nan nakin numnum ay mangichat. Wacha nan kalibfengak ay mangichat as nan fiyagku, ya wacha us nan kalibfengak ay mangara kasin. Hiyana nan filin ay enawatku kan Amak.” ");
INSERT INTO ebk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kun pay chinngor nan chiyuycha Judio nan nauycha infiakian Jesus, tukutukún kasin chi mangnunumnumcha as nan maepangkep kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ongor kan chicha nan nangali, “Naanennetan hiya! Natongok hiya! Adchi t'uy kayu chumngor kan hiya?” ");
INSERT INTO ebk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ngem kenalen nan tapina, “Fiakun assesa nan kankanan chi naanennetan ya. Ay maepaammay nan anennet chi nafurag ta makaila?” ");
INSERT INTO ebk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","As nan chinamuy, wacha nan Fiasta ay Maichatonan chi Templo ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Cha manarcharan hi Jesus as nan makali un Fiangsar Solomon as Templo. ");
INSERT INTO ebk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Enarufong nan chiyuycha Judio hi Jesus, ya kanancha, “Anan uyaka man chi mangpapasugchanam kan chakami? Mu he-a nan Cristo, elawlawagmu man ay mangifiakia kan chakami.” ");
INSERT INTO ebk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tinumfor hi Jesus kan chicha, “Infiakiak at kan chakayu, ngem kunyu challu achi afurotun. Nan chiyuycha nakaskaschaaw ay chak at-atun as nan kalibfengan Ama at chatona nan mangepaneknek as nan maepangkep kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ngem kun kayu achi omafurot kiapú ta fiakun chakayu nan karnerok. ");
INSERT INTO ebk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nan chiyuycha karnerok at ematonancha nan kalek. Ammok chicha, ya umunudcha kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ettak chicha as fiyag ay maid patingkiana, ya achichantu poros maisiyan kan Apo Dios. Maidtu mammamros kan chicha kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hi Amak ay nangichat kan chicha kan ha-un at am-amud mu nan am-in. Maid makafiael ay mamros kan chicha as nan mangay-aywanan Dios Ama. ");
INSERT INTO ebk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ha-un ya hi Ama at us-usa kami.” ");
INSERT INTO ebk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kun pay chinngor nan chiyuycha Judio, kasincha pinmichet as fiatu as elomtakcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kenalen Jesus kan chicha, “Ongor nan ammay ay nakaskaschaaw ay enpailak kan chakayu babaen as nan pannakafialin Ama. Ay chaud as nan nauycha ay enpailak nan kiapúna as uyyu manglomtakan kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tinumfor nan chiyuycha Judio kan hiya, “Fiakun nan ammay ay enatmu nan kiapúna as manglomtakanmi kan he-a, ngem kiapú as nan kenalem ay maifusor kan Apo Dios. Kunka lawá taku ya, ngem munfialinum chi achormu as Dios.” ");
INSERT INTO ebk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kenalen Jesus kan chicha, “Ay kun chaan naisurat as nan Lintigyu ay kenalen Apo Dios un, ‘Kenalek un ap-apodios kayu’? ");
INSERT INTO ebk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ammu takú met ay nan naisurat as nan Kalen Apo Dios at achi masoksokatan, ya enawakian Apo Dios as ap-apodios nan chiyuycha naichatan nan kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kun pay ha-un, piniliyak kan Ama ya infiaorak asna's luta. Ay kananyu un chaak munkali as maifusor kan Apo Dios kiapú ta kenalek un, ‘Ha-un nan Anak Apo Dios’? ");
INSERT INTO ebk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mu achek cha atun nan epadnon Ama at achiyak ud-ay afurotun. ");
INSERT INTO ebk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngem mu atok chaná, uray achiyak afurotun, afurotunyu koma nan chiyuycha chak atuatun ta maammuwanyu ya maawatanyu ay wacha hi Ama kan ha-un, ya wachaak us kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Penachascha kasin ay mangtiliw kan Jesus, ngem enlayawana chicha. ");
INSERT INTO ebk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Angkiay ya kasin nunfiangad hi Jesus ay kinumchang henan wawwang ay Jordan henan lukiar ay nunfunfunyakian Juan ad kasin, ya hid-i nan nagyanana. ");
INSERT INTO ebk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ongor ay tataku nan inmuy kan hiya, at kenalicha, “Maid enat Juan as nakaskaschaaw ay sinyar, ngem am-in ay kenarkalen Juan maepangkep kan tona ay taku at tit-iwa.” ");
INSERT INTO ebk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ongor ay tataku nan enmafurot kan Jesus hid-i. ");
INSERT INTO ebk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wacha nan usa ay laraki ay nan ngachana at Lazaro ay cha munsaket ad Betania. Hid-i nan ilen Maria ya nan sunúdna ay hi Marta. ");
INSERT INTO ebk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Hi Maria ay anna nan mangikuyagtu as fiangfiangru as nan suken Jesus, ya punasanantu as nan fookna. Hi Lazaro ay sunúdna nan nunsaket. ");
INSERT INTO ebk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Isunga inmifiaor nan hen-aki ay fianafiai as uy mangifiakia kan Jesus un, “Apo, nan kiayyummu ay laylaychum at cha munsaket.” ");
INSERT INTO ebk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kun pay chinngor Jesus sa, kenalina, “Nan saket ay anna at achi ekatuy Lazaro. Ommat na ta maichayaw hi Apo Dios, ya hiyasa nan kiapón nan maichayawan nan Anak Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Laylaychun Jesus nan nauycha hen-anag-i ay cha Marta, Maria ya Lazaro. ");
INSERT INTO ebk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","As nan nangchamakian Jesus ay nunsaket hi Lazaro, nayaschi henan lukiar ay kawad-ana as chuwa pay ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kun pay narpas na, kenalen Jesus as nan disipulusna, “Umuy takú kasin ad Judea.” ");
INSERT INTO ebk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kenalen nan disipulus kan hiya, “Misturu, chaan nafiayag nan timpu ay kiayud chaká nanglomtakan as nan chiyuycha Judio. Ay kasinka pay laing munfiangad hid-i?” ");
INSERT INTO ebk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tinumfor hi Jesus, “Ay kun maid hinpuru ya chuwa ay uras as nan kaorkia? Mu ngachana nan manarcharan as nan kaorkia at achi maesakiaw hiya, tay mailana nan silawasna's luta. ");
INSERT INTO ebk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ngem mu ngachana nan manarcharan as nan lafi at maesakiaw, tay maid nan silaw kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kun pay kenalen Jesus na, kenalina pay, “Nan kiayyum takú ay hi Lazaro at nassuy, ngem uyku fiangunun hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tinumfor nan disipulus kan hiya, “Apo, mu nassuy hiya at omammaytu.” ");
INSERT INTO ebk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nan laychun Jesus ay kanan at natuy hiya, ngem ka-anancha mu nanassuy tit-iwa hi Lazaro. ");
INSERT INTO ebk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Isunga narawag nan infiakian Jesus kan chicha, “Natuy hi Lazaro, ");
INSERT INTO ebk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ngem kiapú kan chakayu, naragsakak as nan kamaidku as nan kawad-ana as nan natuyana ta pumigsa nan pammatiyu kan ha-un. Ayu, uy takú ilaun hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kenalen Tomas ay makali un Apel as nan kakadwana ay disipulus, “Umuy takú us ta uray maetapi takú as nan Apo ay matuy.” ");
INSERT INTO ebk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kun pay inumchan cha Jesus ad Betania, naammuwana ay opat at ay urkiw nan nailurubkan Lazaro. ");
INSERT INTO ebk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nan nauy Betania at asnop ad Jerusalem. Umuy as turu ay kilometro nan kaachawwina. ");
INSERT INTO ebk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ongor ay Judio nan enmali ay uy mangliwliwa kan cha Marta kan Maria kiapú as nan natuyan nan sunúdcha. ");
INSERT INTO ebk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kun pay chinngor Marta ay cha omali hi Jesus, pinmitiw hiya ay uy nanib-at kan hiya, ngem nayagyag hi Maria as afongcha. ");
INSERT INTO ebk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kenalen Marta kan Jesus, “Apo, mu kunka wacha hena at chaan koma natuy nan sunúdku. ");
INSERT INTO ebk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ngem uray ad wani, ammok ay mu ngachana nan chawatum kan Apo Dios, ichatna kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kenalen Jesus kan hiya, “Matakuntu manipud as nan utúy nan sunúdmu.” ");
INSERT INTO ebk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Ammok ay mataku kasin hiya as nan matakuwantu nan nunkatuy manipud as nan utúy as nan anongos ay urkiw,” ensongfiat Marta. ");
INSERT INTO ebk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kenalen Jesus kan hiya, “Ha-un nan mangtaku as nan natuy manipud as nan utúy ya nan mangichat as nan fiyag ay maid patingkiana. Nan taku ay omafurot kan ha-un at mataku challu uray mu matuy, ");
INSERT INTO ebk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ya mu ngachana nan matataku ay omafurot kan ha-un at achi matmatuy. Ay afurotum na?” ");
INSERT INTO ebk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“O, Apo,” ensongfiat Marta. “Afurotok ay he-a nan Cristo ay Anak Apo Dios. He-a nan sisin-udmi ay omali asna's luta.” ");
INSERT INTO ebk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kun pay narpas ay infiakian Marta na, nunfiangad hiya ay uy nangayag kan Maria ay sunúdna. Intubtufuna kan hiya, “Wacha nan Misturu hena, ya cha chaka epaayag.” ");
INSERT INTO ebk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","As nan nanngoran Maria as sa, nalannigwat hiya, at inmuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Chaan pay inumchan hi Jesus henan fiabruy, tay kukutug henan lukiar ay nanib-atan Marta kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nan chiyuycha Judio ay cha mangliwliwa kan Maria as fiaruy at inmunudcha as nan nangil-ancha ay nalannigwat hiya ya pinmitiw. Ka-anancha mu umuy as nan kawad-an nan lufok ta mun-akor. ");
INSERT INTO ebk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kun pay inumchan hi Maria as nan kawad-an Jesus ya inilana hiya, nunlukfub as nan sangwanana. Kenalina kan hiya, “Apo, mu kunka wacha hena at chaan koma natuy nan sunúdku ay laraki.” ");
INSERT INTO ebk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","As nan nangil-an Jesus kan Maria ya nan chiyuycha Judio ay inmunud kan hiya ay cha mun-ag-akor, nginmuyus hiya as solet ya nalilifok chi numnumna. ");
INSERT INTO ebk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Senarudsudna kan chicha, “Ay chaud nan nangilubkanyu kan hiya?” “Apo, aka ta uy takú ilaun,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nun-akor hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kenalen nan chiyuycha Judio, “Ilaunyu, ongor paat chi layadna kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ngem kenalen nan tapen nan tataku, “Ay fiakun hiya nan nangepaammay as matan nan nafurag ta makaila? Adchi ngay t'uyna enparufus ay natuy hi Lazaro?” ");
INSERT INTO ebk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kasin nginmuyus as solet hi Jesus as nan naesnopana as nan nailubkan Lazaro. Nan lufokna at natuktukan ay chupras ya natatangfian as ad-acha ay fiatu. ");
INSERT INTO ebk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Kaanunyu nan fiatu,” infilin Jesus. Ngem kenalen Marta ay sunúd nan natuy, “Ayokayong! Apo, mun-akub at a, tay opat at ay urkiw nan nailurubkana!” ");
INSERT INTO ebk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kenalen Jesus kan hiya, “Ay chaanku infiakia kan he-a ay mu omafurotka at mailam nan kaichayawan Apo Dios?” ");
INSERT INTO ebk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Isunga kenaancha nan fiatu. Angkiay ya nuntangad hi Jesus, ya kanana, “Ama, munyamanak kan he-a, tay chinngorak kan he-a. ");
INSERT INTO ebk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ammok ay kanayonak ay chungrun kan he-a, ngem kanak na kiapú as nan nauycha tataku hena ta afurotuncha ay he-a nan nangifiaor kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kuna pay kenali na, inpigsana ay nangifukiaw, “Lazaro, pumitiwka!” ");
INSERT INTO ebk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pinmitiw nan natuy. Napopotepotan chi limana ya sukina as lopot, ya naapongotan us nan lupana as panyu. Angkiay kenalen Jesus kan chicha, “Kaanunyu nan hanacha naepopotepot kan hiya ta mafialin ay komatam.” ");
INSERT INTO ebk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nan ongor as nan chiyuycha Judio ay enmali ay nangliwliwa kan Maria ya nangila as nan enat Jesus at enmafurotcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ngem nan tapina kan chicha at inmuycha as nan chiyuycha Fariseo, ya infiakiacha kan chicha nan enat Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Angkiay nan chiyuycha Fariseo ya nan anap-apon chi papachi at nakimitincha as nan chiyuycha membron nan Sanhedrin. Kenalicha kan chicha, “Anan atun takú ngay? Nan taku ay ansa at ongor chi nakaskaschaaw ay sinyar ay chana at-atun! ");
INSERT INTO ebk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mu ukiayun takú hiya ay mangiturturuy as sa, am-in ay tataku at omafurotchantu kan hiya. Mu hiyasa, omalintu nan chiyuycha toray ay i-Roma ay manachael as nan Templo takú ya uray nan nasyon takú.” ");
INSERT INTO ebk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ngem nan usa kan chicha at hi Caifas ay kangatuwan ay pachi as nan hiyachi ay tawwun nan nangali, “Kenomsaw kayu! Maid paat ammuyu! ");
INSERT INTO ebk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ay achiyu maawatan ay un-unuyna kan chakayu ay nan usa ay taku at matuy para as nan tataku mu nan intiru ay nasyon nan machachael?” ");
INSERT INTO ebk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nan nauy infiakian Caifas at chaan nurpu as nan mismu ay numnumna, ngem kiapú ta hiya nan kangatuwan ay pachi as nan hiyachi ay tawwun, enpaepadton Apo Dios kan hiya ay matuy hi Jesus para as nan tataku ay Judio. ");
INSERT INTO ebk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Fiakun yangkiay para as nan chiyuycha Judio, ngem am-in ay an-ak Apo Dios ay wacha henan tukutukún ay luglukiar at amonguna ay mun-us-usaun. ");
INSERT INTO ebk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nunlapu as nan hiyachi ay urkiw, nuntuturag nan anap-apon chi Judio as atuncha ay mangpatuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Isunga chaan at nunfiabfiaat hi Jesus as nan kawad-an nan tataku ad Judea, ngem kun at nak-ak hiya ya nan disipulusna ay inmuy henan ili ay Efraim ay asnop henan disyerto, ya hid-i nan nayaschiyancha. ");
INSERT INTO ebk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","As nan hiyachi, kiayud umchan nan Fiastan chi Judio ay makali un Munlausan. Ongorcha nan enmabrat ad Jerusalem ay nurpu henan sigsikib ay uy mangekaman as nan iniili ay ukialicha ay panagcharos sakbay makifiastacha. ");
INSERT INTO ebk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kuncha pay inumchan nan tataku ad Jerusalem, chacha anapun hi Jesus. As nan naamongancha as Templo, nunsesennarudsudcha, “Ngachana nan munnunumnummu? Ay achi ngun omali hi Jesus ay makifiasta?” ");
INSERT INTO ebk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nan anap-apon chi papachi ya nan chiyuycha Fariseo at infilincha as nan tataku ay mu wacha nan nangammu as nan kawad-an Jesus, masapor epakaammuna ta tiliwuncha hiya. ");
INSERT INTO ebk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","As nan hiyachi, unum pay ay urkiw sakbay nan Fiastan chi Munlausan. Inmuy cha Jesus ad Betania ay ilen Lazaro ay tenakuna manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nunsakianacha hid-i as kanuncha as nan maschum ta pachayawancha hi Jesus. Finmachang hi Marta ay nun-iwaras as makan, ya hi Lazaro at usa as nan chiyuycha nakiufong kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Angkiay ya hi Maria at enarana nan kakudwan chi litro ay nanginngina-an ay fiangfiangru ay nardu ay maid naekaskaslang. Inkuyagna as nan suken Jesus, angkiay inpunasna nan fookna. Nan fiangruna at nunwaras as nan intiru ay afong. ");
INSERT INTO ebk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ngem kun pay hi Judas Iscariote ay usa as nan disipulus Jesus ay mangesepseptu kan Jesus, kenalina as nan nangil-ana's chi, ");
INSERT INTO ebk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ayyiwka sa paat! Anuy chaan naelaku na ay fiangfiangru as turon kiasot ay dinario ya maichat nan lakuna as nan chiyuycha pugli?” ");
INSERT INTO ebk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kenalina sa, fiakun kiapú ta sug-angana nan pugli, ngem kiapú ta mangaakiw hiya. Hiya us nan mamangchun as nan sipingcha, ya ukialina ay mangakét para as nan mismu ay osaruna. ");
INSERT INTO ebk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kenalen Jesus kan Judas, “Pay-anyu! Intutupugna sa ta esakianana nan achorku para as nan urkiw ay mailubkak. ");
INSERT INTO ebk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nan chiyuycha pugli at kanayoncha ay wacha kan chakayu. Ngem kun pay ha-un, achiyak kanayon ay wacha kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","As nan nangammuwan nan ongor ay Judio ay wacha hi Jesus ad Betania, inmuycha hid-i. Nan inmuyancha at fiakun yangkiay kiapú kan Jesus, ngem kiapú ta laychuncha us ay ilaun hi Lazaro ay tenakuna manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Isunga plenanon nan anap-apon chi papachi ay patayun us hi Lazaro, ");
INSERT INTO ebk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tay kiapú kan hiya, ongor as nan chiyuycha Judio nan cha mak-ak kan chicha ya cha omafurot kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","As nan kafikiatana, nan ongoongor ay tataku ay enmali ay nakifiasta at chinngorcha ay cha omali hi Jesus ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Isunga enmaracha as pangan chi palma ay kaiw, ya uycha sinib-at hiya. Infugfukiawcha, “Machaychayaw hi Apo Dios! Bendisyonan koma Apo Dios nan naifiaor as pannakaachorna. Bendisyonan koma Apo Dios nan Aren nan Israel!” ");
INSERT INTO ebk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Enpaaran Jesus nan urfun ay dongki, ya nunsakay hiya ay kaman as nan naisurat as nan Kalen Apo Dios ay kanana, ");
INSERT INTO ebk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Chakayu ay tataku ad Jerusalem, achi kayu umugyat. Ilaunyu! Cha omali nan ariyu ay nunsasakay as nan urfun ay dongki.” ");
INSERT INTO ebk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nan nauycha enommat at chaan naawatan nan disipulus Jesus as nan hiyachi ay timpu. Ngem as nan naichayawan Jesus as nan natakuwana manipud as nan utúy, hiyachi nan nangnumnumancha ay nan nauycha maepangkep kan hiya at naisuratcha as nan Kalen Apo Dios ya enkamancha chaná kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nan ongor ay tataku ay nangila as nan nangayakian Jesus kan Lazaro as nan lufokna ya nangtakuwana kan hiya manipud as nan utúy at chacha epachapachamag nan inilacha. ");
INSERT INTO ebk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hiyachi nan kiapúna ay ongoongorcha nan uy nanib-at kan Jesus, tay nachamagcha nan nauy nakaskaschaaw ay sinyar ay enatna. ");
INSERT INTO ebk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Angkiay ya kenalen nan chiyuycha Fariseo as nan tunggal usa, “Ilaunyu at maid atun takú! Am-in ay tataku at chacha umunud kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wachacha nan tapen nan Griego ay naetatapi as nan chiyuycha uy nunchaychayaw kan Apo Dios as nan fiasta ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Inmuycha kan Felipe ay i-Betsaida ad Galilea, at kenalicha kan hiya, “Sir, laychunmi ngay koma ay ilaun hi Jesus.” ");
INSERT INTO ebk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Uy infiakian Felipe kan Andres, at uycha infiakia ay chuwa kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kenalen Jesus kan chicha, “Enmali at nan uras ay maichayawan nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ifiakiak kan chakayu nan tit-iwa. Nan nauy ay ommat at maepachong as nan usa ay fokel ay makiab-onan as nan luta ya kaman matuy. Mu assena, achi hihiya ay us-usa. Ngem uray kaman matuy, tomemeltu, at fumkias as ongoongor. ");
INSERT INTO ebk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nan taku ay nan mismu ay fiyagna yangkiay nan laylaychuna at malitawnantu. Ngem nan taku ay fiakun nan mismu ay fiyagna asna's luta nan laylaychuna at matakuntu in-inkiana. ");
INSERT INTO ebk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mu ngachana nan manglayad ay munserfi kan ha-un, masapor unuchunak, ya henan kawad-ak, hid-i us nan kawad-an nan fiabfiaarok. Mu ngachana nan munserfi kan ha-un, ichayaw Amak hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Inturuy Jesus, “Ad wani, malilifok as solet chi numnumku, ya anan ekararagku? Ay ekararagku un, ‘Ama, esarakanak as nan nauy omali ay likiatku’? Achi, tay hiyana ay likiat nan pangkep nan enmaliyak hena. ");
INSERT INTO ebk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kun at nan kanak, ‘Ama, epailam nan kaichayawan nan ngachanmu.’ ” Angkiay ya wacha at nan kali ay nurpu ad chaya ay kanana, “Enpailak at nan kaichayawak, ya kasinkuntu epaila.” ");
INSERT INTO ebk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nan ongor ay tataku ay nangatakchug hid-i at chinngorcha chi ay kali. Kenalen nan tapina kan chicha un kinmud-or. Nan tapina at kenalicha, “Nunkali nan anghel kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tinumfor hi Jesus kan chicha, “Nan nauy kali ay chinngoryu at fiakun para kan ha-un, ngem kun at para kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ad wani nan maokomán nan tataku asna's luta, ya ad wani us nan maamisan Satanas ay ap-apon chi achi omaafurot. ");
INSERT INTO ebk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kunak pay maetag-uy manipud asna's luta, awisoktu nan am-in ay tataku ta omafurotcha kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kenalina na ay mangepakaammu as nan atuna ay matuy. ");
INSERT INTO ebk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Angkiay ya tinumfor nan ongor ay tataku, “Ammumi met ay kanana as nan Lintig takú ay nan Cristo at mataku in-inkiana. Adchi t'uymu kanan un, ‘Masapor maetag-uy nan Naepadtu ay Anak chi Taku’? Ngachan tona ay Naepadtu ay Anak chi Taku?” ");
INSERT INTO ebk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tinumfor hi Jesus, “Hen-omaketan yangkiay nan mawawad-an nan silaw kan chakayu. Iturturuyyu ay manaran as nan mawawad-an pay laing nan silaw kan chakayu sakbay maschuman kayu. Tay nan taku ay manaran as nan ngongot at achina ammu nan ay-ayana. ");
INSERT INTO ebk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","As nan mawawad-an pay laing nan silaw kan chakayu, omafurot kayu as nan silaw ta munfialin kayu as tataku ay nasilawan chi numnumcha.” As nan nangaliyan Jesus as na, nak-ak hiya, ya chaan nunpaila kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Uray kun ongor nan nakaskaschaaw ay sinyar ay enpappailan Jesus kan chicha, kuncha challu achi afurotun hiya ");
INSERT INTO ebk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ta matongpar nan kenalen Isaias ay pomapadtu un, “Apo, ay kun wachay enmafurot as nan enpakaammumi? Ay kun wachay enmafurot as nan enpailam ay pannakafialinmu?” ");
INSERT INTO ebk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nan kiapúna as achicha omafurotan at wacha ngamin us nan kenalen Isaias un, ");
INSERT INTO ebk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Finurag Apo Dios nan matacha ya enpatangkena nan numnumcha ta achicha maila ya achicha us maawatan ya achicha munsakong kan hiya ta epaammayna chicha.” ");
INSERT INTO ebk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kenalen Isaias na, tay inilana nan kaichayawan Jesus ad pus-uy ya infiakiana nan maepangkep kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Uray mu hiyachi, ongor ay anap-apon chi Judio nan enmafurot kan Jesus. Ngem kuncha chaan ipudnu nan pammaticha, tay umugyatcha mu epak-ak nan chiyuycha Fariseo chicha as nan senagoga, ");
INSERT INTO ebk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","tay laylaychuncha nan mangchaychayawan nan tataku kan chicha mu nan mangchayawan Apo Dios kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Angkiay ya inpigsan Jesus ay nangali, “Nan taku ay omafurot kan ha-un at fiakun yangkiay ha-un nan afurotuna ngem patí nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nan taku ay mangila kan ha-un at ilauna us nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Enmaliyak as kaman silaw asna's luta ta mu ngachana nan omafurot kan ha-un at achi mayayaschi as nan ngongot. ");
INSERT INTO ebk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Mu ngachana nan manngor as nan chak isursuru ya achina tongparun at achek okomún hiya. Tay chaanak enmali ay mang-okóm as nan tataku asna's luta, ngem kunak at enmali ay mangesarakan kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wacha nan mang-okóm as nan mangachi kan ha-un ya achi mang-awat as nan chiyuycha kanak. Nan nauycha kenarkalek at chicha nan mang-okóm kan hiya as nan anongos ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","O, tit-iwa, tay chaanak nunkarkali as nan mismu ay kalibfengak, ngem kun at hi Ama ay nangifiaor kan ha-un nan nangifilin kan ha-un as nan masapor ay kanak. ");
INSERT INTO ebk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ammok ay nan filina at muntoróng as nan fiyag ay maid patingkiana. Isunga nan infilin Amak kan ha-un at hiya yangkiay nan kenarkalek.” ");
INSERT INTO ebk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","As nan kiayud umchanan nan Fiastan chi Munlausan, ammon Jesus ay inumchan nan uras ay mak-akana asna's luta ya munfiangchana kan Amana. Kanayona ay lenaylayad nan disipulusna, ya lenaylayadna chicha inkiana as nan natuyana asna's luta. ");
INSERT INTO ebk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","As nan lafi, as nan cha manganan cha Jesus, enpanumnum at Satanas kan Judas ay potot Simon Iscariote nan pangkepna ay mangesepsep kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Aammon Jesus ay am-in ay pannakafialin at inchat Amana kan hiya. Ammuna us ay kan Apo Dios nan nurpuwana ya kan hiya nan munfiangchana. ");
INSERT INTO ebk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Isunga tenmakchug hi Jesus, ya kenaana nan kakiayna, angkiay ensalifudna nan tuwarya as kitangna. ");
INSERT INTO ebk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kun pay narpas sa, tenorwana nan parangkiana as chanum. Angkiay ya enlapuna ay mangisu as nan disipulusna, ya punasana as nan tuwarya ay ensasalifudna as kitangna. ");
INSERT INTO ebk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kun pay naekchang kan Simon Pedro, kenalen Pedro kan hiya, “Apo, ay he-a nan mangisu kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tinumfor hi Jesus kan hiya, “Nan nauy chak at-atun at achim maawatan ad wani, ngem maawatamtu as kasin.” ");
INSERT INTO ebk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kenalen Pedro kan Jesus, “Aw, achiyaktu poros is-isuwan kan he-a, Apo.” Ngem tinumfor hi Jesus, “Mu achek isuwan he-a at achika maifilang as disipulok.” ");
INSERT INTO ebk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tinumfor hi Pedro, “Mu hiyasa payat, Apo, fiakun yangkiay nan sukek nan urasam ngem uray us nan limak ya nan urok.” ");
INSERT INTO ebk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kenalen Jesus, “Nan taku ay chakus nun-umus at achi kis-an mun-umus kasin, kun yangkiay mun-isu, tay nacharos hiya. Nacharos kayu, ngem achi kayu am-in.” ");
INSERT INTO ebk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Aammon Jesus nan mangesepsep kan hiya, isunga kenalina, “Achi kayu am-in nacharos.” ");
INSERT INTO ebk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kuna pay lenpas ay nangisu kan chicha, kasin nunkakiay ya nunfiangad as nan tokorana. Senarudsudna as nan disipulusna, “Ay maawatanyu nan nauy enatku kan chakayu? ");
INSERT INTO ebk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nan awagyu kan ha-un ay ‘Misturu’ ya ‘Apo’ at ustu, tay tit-iwa met ay ha-un sa. ");
INSERT INTO ebk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mu ha-un ay Apoyu ya Misturuyu at inisuwak chakayu, masapor us mun-iinnisu kayu. ");
INSERT INTO ebk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Enpailak met nan turachunyu ta atunyu us koma nan kaman as nan enatku kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ifiakiak kan chakayu nan tit-iwa. Nan mafiabfiaor at achi am-amud mu nan amona. Kaman us as nan naifiaor at achi am-amud mu nan nangifiaor kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mu ammuyu chaná, nakiasat kayu mu atunyu! ");
INSERT INTO ebk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Fiakun chakayu am-in nan chak ifiagfiakia, tay ammok nan chiyuycha pinilek. Ngem masapor matongpar nan naisurat as nan Kalen Apo Dios ay kanana, ‘Nan nakekan kan ha-un at hiya nan nunfialin as kafusorku.’ ");
INSERT INTO ebk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ifiakiak na kan chakayu ad wani sakbay ommat ta as nan ommatana at afurotunyu ay ha-un nan Cristo. ");
INSERT INTO ebk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ifiakiak kan chakayu nan tit-iwa. Nan taku ay mang-awat as nan ifiaorku at ha-un nan awatuna, ya nan mang-awat kan ha-un at awatuna nan nangifiaor kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kun pay narpas ay infiakian Jesus na, nalilifokan as solet nan numnumna. As nan hiyachi, narawag ay infiakiana, “Ifiakiak kan chakayu nan tit-iwa. Wacha kan chakayu nan usa ay mangesepsep kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nun-iinnila nan disipulusna, tay achicha poros ammu mu ngachana kan chicha nan chana kanan. ");
INSERT INTO ebk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nan usa as nan disipulusna ay laylaychun Jesus at naichachapat kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sininyasan Simon Pedro hiya, ya kanana, “Sarudsuchum pay kan Apo mu ngachana kan chitaku nan chana kanan.” ");
INSERT INTO ebk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Isunga nan naichachapat kan Jesus at kaskasin naesnop kan hiya, ya senarudsudna, “Apo, ngachan ngay tud-i?” ");
INSERT INTO ebk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","“Nan mangichataktu as nan nauy tenapay ay esawsawku at hiya,” ensongfiat Jesus. Kuna pay ensawsaw nan tenapay, inchatna kan Judas ay potot Simon Iscariote. ");
INSERT INTO ebk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","As nan hiyachi ay nangor-an Judas as nan tenapay, nasannukop hi Satanas kan hiya. Kenalen Jesus kan hiya, “Kamuwum! Atum at nan hana planom ay atun.” ");
INSERT INTO ebk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Maid nakaawat as nan chiyuycha nakekan kan Jesus mu adchi t'uy kenalen Jesus chi kan Judas. ");
INSERT INTO ebk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kiapú ta hi Judas nan mamangchun as nan sipingcha, ka-anan nan tapina kan chicha un uy at cha ifiakian Jesus kan hiya ay uy lomaku as kasaporancha as nan hana ay fiasta winnu uy umichat as siping as nan pugli. ");
INSERT INTO ebk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","As nan nang-awatan Judas as nan tenapay, napannitiw hiya. Lafi as nan hiyachi. ");
INSERT INTO ebk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","As nan nak-akan Judas, kenalen Jesus, “Ad wani, maichayaw nan Naepadtu ay Anak chi Taku, ya babaen kan hiya at maila nan kaichayawan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mu maichayaw hi Apo Dios babaen kan hiya at hi Apo Dios us ay mismu nan mangepaila ay dagus as kaichayawan nan Naepadtu ay Anak chi Taku. ");
INSERT INTO ebk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Chakayu ay an-akku, hen-omaketan yangkiay nan kawad-ak kan chakayu. Anapunaktu kan chakayu, ngem ifiakiak ad wani kan chakayu nan infiakiak as nan anap-apon chi Judio ay achi kayu makauy henan ay-ayak. ");
INSERT INTO ebk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nauy nan fiarú ay filinku kan chakayu: Munlelennayad kayu. Kaman as nan nanglaylaychanak kan chakayu at assesa us ay masapor munlelennayad kayu. ");
INSERT INTO ebk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mu hiyasa ay munlelennayad kayu, maammuwantu nan am-in ay tataku ay chakayu nan disipulusku.” ");
INSERT INTO ebk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Senarudsud Simon Pedro kan Jesus, “Apo, ay chaud nan ay-ayam?” “Henan ay-ayak at achika makaunud ad wani kan ha-un, ngem umunudkantu as kasin,” ensongfiat Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Senarudsud kasin Pedro, “Apo, adchi t'uyak achi makaunud kan he-a ad wani? Nakasakianaak met ay matuy para kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tinumfor hi Jesus, “Ay tit-iwa ay nakasakianaka ay matuy para kan ha-un? Ifiakiak kan he-a nan tit-iwa. Achi munkokakok nan ka-or inkiana mamen turu ay esaotak kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Inturuy Jesus, “Achi kayu malilifokan, ngem kun kayu at omafurot kan Apo Dios, ya omafurot kayu us kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ongor chi magyanan as nan kawad-an Amak ad chaya, ya umuyak hid-i ay mangesakiana as nan magyananyu. Mu kun achi tit-iwa nan chak kankanan at infiakiak koma kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","As nan umuyak ya mangesakianaak as nan magyananyu, omaliyaktu kasin ay mangekatam kan chakayu ta wacha kayuntu us as nan kawad-ak. ");
INSERT INTO ebk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ammuyu met nan charan ay umuy as nan ay-ayak.” ");
INSERT INTO ebk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kenalen Tomas kan Jesus, “Apo, achimi met ammu nan ay-ayam. Ngachana ngay nan atunmi ay mangammu as nan charan?” ");
INSERT INTO ebk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tinumfor hi Jesus kan hiya, “Ha-un nan charan ay umuy ad chaya, nan kurpuwan chi kenatit-iwa ya nan mangichat as fiyag. Maid makaali kan Amak mu achi babaen kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mu tit-iwa ay am-ammuwak at am-ammuyu us hi Amak. Munlapu ad wani, am-ammuyu challu hiya, ya kamanyu tit-iwa inila hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kenalen Felipe kan Jesus, “Apo, epailam kan chakami nan Ama. Mu atum sa, mapnek kami.” ");
INSERT INTO ebk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tinumfor hi Jesus kan hiya, “Ayokayong Felipe! Kunak cha nafiayag kan chakayu am-in ya, ay achiyak pay laing am-ammu kan he-a? Nan nakaila at kan ha-un at inilana us nan Ama. Anuymu kanan un, ‘Epailam nan Ama kan chakami?’ ");
INSERT INTO ebk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ay achim afurotun ay wachaak kan Amak, ya wacha hi Amak kan ha-un? Nan kenarkalek kan chakayu at chaan nurpu as numnumku ngem hi Amak ay mawawacha kan ha-un nan cha mangekaman as nan atuna. ");
INSERT INTO ebk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Afurotunyu nan kanak ay wachaak kan Ama ya wacha hi Ama kan ha-un. Mu achiyu afurotun nan kanak, afurotunyu kiapú as nan nakaskaschaaw ay en-enatku. ");
INSERT INTO ebk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Ifiakiak kan chakayu nan tit-iwa. Nan ngachana ay omafurot kan ha-un at atunantu us nan chak at-atun. Am-amud pay nan atuna mu nan nauycha, tay munfiangachak kan Ama. ");
INSERT INTO ebk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nan ngachana ay chawatunyu kiapú as nan nakius-usaanyu kan ha-un at atoktu ta maichayaw nan Ama babaen as nan Anakna. ");
INSERT INTO ebk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","O, mu chumawat kayu as kumpurmi kiapú as nan nakius-usaanyu kan ha-un, atoktu.” ");
INSERT INTO ebk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kenalen us Jesus, “Mu laylaychunak kan chakayu, tongparunyu nan filfilinku. ");
INSERT INTO ebk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Chawatoktu kan Ama, at ifiaorna nan Fumadfiachang as pannakaachorku. Hiya at mawawacha kan chakayu in-inkiana. ");
INSERT INTO ebk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hiya nan Espiritu Santo ay mangisursuru as nan kenatit-iwa. Nan tataku asna's luta ay achi omafurot at achicha mafialin ay awatun hiya, tay achicha maematonan ya achicha ammu hiya. Kun pay chakayu, ammuyu hiya, tay makepagyan kan chakayu, ya awni at mawawacha kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Achek taytaynan chakayu ay kaman maid chanakchakorcha, tay munfiangachaktu challu kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Achi mafiayag at achiyaktu il-ilaun as nan tataku ay achi omafurot kan ha-un. Ngem chakayu at ilaunaktu. Kiapú ta matakuwak at mataku kayu us. ");
INSERT INTO ebk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","As nan hana ay urkiw, maammuwanyuntu ay wachaak kan Ama, ya wacha kayu kan ha-un, ya wachaak kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nan mang-awat ya mangtongpar as nan filfilinku at hiya nan manglaylayad kan ha-un. Nan manglaylayad kan ha-un at laylaychuntu Ama hiya. Uray ha-un at laylaychoktu us hiya, ya epakaammoktu kan hiya nan maepangkep kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Senarudsud Judas (fiakun hi Judas Iscariote), “Apo, adchi t'uy kan chakami yangkiay nan mangepakaammuwam as nan maepangkep kan he-a ya fiakun as nan am-in ay tataku asna's luta?” ");
INSERT INTO ebk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tinumfor hi Jesus kan hiya, “Mu ngachana nan manglaylayad kan ha-un at tongparuna nan ifiakiak. Hi Amak at laylaychunantu hiya, ya omali kamintu ay chuwa ay makeafong kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nan taku ay achi manglaylayad kan ha-un at achina tongparun nan ifiakiak. Nan nauy kali ay chinngoryu at chaan nurpu as numnumku, ngem nurpu kan Ama ay nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Infiakiak chaná kan chakayu ad wani ay wachaak pay laing kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ngem ifiaortu Amak nan Fumadfiachang ay hiya nan Espiritu Santo as pannakaachorku. Hiyantu nan mangisuru kan chakayu as nan am-in ya mangepanumnum as nan am-in ay infiagfiakiak kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nan natalna ay numnum nan ifiatek kan chakayu. O, nan nauy natalna ay numnum ay nurpu mismu kan ha-un at achi poros maepachong as nan ichat nan tataku asna's luta. Isunga achi kayu malilifokan winnu umug-ugyat. ");
INSERT INTO ebk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chinngoryu met nan kenalek kan chakayu ay mak-akak, ngem munfiangachaktu kan chakayu. Mu lenaylayachak kan chakayu, naragsakan kayu koma, tay komatamak kan Ama. Tay hi Ama at am-amud mu ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Infiakiak na kan chakayu ad wani sakbay ay ommat ta as nan ommatana, omafurot kayu kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Achi mafiayag chi maketagtakiatforak kan chakayu, tay cha omali hi Satanas ay ap-apon chi achi omaafurot. Maid pannakafialina ay mangetoray kan ha-un, ");
INSERT INTO ebk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ngem masapor maammuwan nan tataku asna's luta ay laylaychok hi Ama. Hiyana nan kiapúna ay am-in ay infilin Ama kan ha-un at tongparok. Maligwat kayu ta uy takú,” kenalina. ");
INSERT INTO ebk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Infiakian Jesus na ay maepadpachongan, “Ha-un nan tit-iwa ay puon chi ubas, ya hi Amak nan mangay-aywan. ");
INSERT INTO ebk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Songpatuna nan tunggal panga ay achi fumkias, ya charosana nan chiyuycha panga ay fumkias ta omong-ongor chi fukiascha. ");
INSERT INTO ebk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Chakayu nan maepachong as nan chiyuycha panga ay chakus nacharosan kiapú as nan nangafurotanyu as nan kalek ay infiagfiakiak kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Iturturuyyu ay mawawacha kan ha-un, ya mawawachaak us kan chakayu. Nan panga at maid atuna ay fumkias mu naisiyan as nan puuna. Kaman us kan chakayu at maid fukiasyu as nan pammatiyu sukúd kayu mawawacha kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ha-un nan puon chi ubas, ya chakayu nan chiyuycha panga. Nan ngachana ay mawawacha kan ha-un ya mawawachaak us kan hiya at hiyantu nan omongor chi fukiasna as nan pammatina, tay maid maekamanyu mu maichak kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nan achi mawawacha kan ha-un at maichus-ortu ay kaman as nan panga ay nasongpat. Mu narangu nan assesesa ay panga, maamong ya maichus-orcha as nan apuy ta mapuorancha. ");
INSERT INTO ebk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mu mawawacha kayu kan ha-un ya mawawacha nan kalek kan chakayu, uray ngachana nan chawatunyu ay laychunyu, maichattu kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hiyana nan maichayawan Amak mu omongor nan fukiasyu as nan pammatiyu. Mu assena, hiyana us nan mangepaila ay chakayu nan disipulusku. ");
INSERT INTO ebk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Kaman as nan manglaylaychanan Amak kan ha-un at assena us nan manglaylaychanak kan chakayu. O, masapor mawawacha kayu ngarud as nan layadku kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mu tongparunyu nan infilfilinku, mawawacha nan layadku kan chakayu. Tay uray ha-un at tenongparku nan infilfilin Amak, ya mawawacha nan layadna kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Infiakiak chaná kan chakayu ta mawawacha nan lagsakku kan chakayu ya maid munkurangana. ");
INSERT INTO ebk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Nauy nan filinku kan chakayu: Munlelennayad kayu ay kaman as nan nanglaylaychanak kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nan kaamuchan ay layad ay epailan nan taku at hiyana nan mangichatana as nan fiyagna ta mataku nan kiakiayyumna. ");
INSERT INTO ebk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Chakayu nan kiakiayyumku mu tongparunyu nan ifilinku kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Fiakun at mafiabfiaor nan awagku kan chakayu, tay nan mafiabfiaor at achina ammu nan cha at-atun nan amona. Kunku at awakian chakayu as kiakiayyumku, tay nan am-in ay chinchinngorku kan Amak at enpakaammok kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Fiakun chakayu nan nangpili kan ha-un, ngem ha-un nan nangpili ya nangchutok kan chakayu ta uyyu paafurotun nan ongor ay tataku ay chicha nan maepachong as nan fukiasyu as nan pammatiyu ay mawawacha in-inkiana. Mu atunyu sa, uray ngachana nan chawatunyu kan Ama kiapú as nan nakius-usaanyu kan ha-un at ichatnantu kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hiyana ngarud nan ifilinku kan chakayu: Munlelennayad kayu.” ");
INSERT INTO ebk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Inturuy Jesus, “Mu inglun chakayu as nan tataku ay achi omaafurot, numnumunyu ay ha-un nan enmon-ona ay iningorcha. ");
INSERT INTO ebk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mu makius-usa kayu as nan achi omaafurot asna's luta, laylaychun chakayu kan chicha ay pachongcha. Ngem kiapú ta pinilek chakayu ta maisiyan kayu kan chicha ay achi omaafurot. Isunga iinglun chakayu kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Numnumunyu nan karkalek ay infiakiak kan chakayu: ‘Nan mafiabfiaor at achi am-amud mu nan amona.’Mu palikiatunak kan chicha at palikiatunchantu us chakayu. Mu tongparuncha nan insursurok at tongparunchantu us nan isursuruyu. ");
INSERT INTO ebk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngem am-in chaná ay likiat at epalak-amchantu kan chakayu kiapú as nan enmafurotanyu kan ha-un, tay achicha ammu nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mu chaanak enmali ya chaanku infiakia kan chicha, fiakuncha fiasor nan achicha mangafurotan kan ha-un. Ngem ad wani at maid maepanforcha para as nan fiasorcha. ");
INSERT INTO ebk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nan taku ay mangiingor kan ha-un at iingoruna us hi Amak. ");
INSERT INTO ebk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mu chaanku enkaman as nan nangiil-ancha nan nakaskaschaaw ay maid poros usa ay taku ay makaekaman at chaancha koma finmasor. Ngem ad wani, uray inilacha at iinglunak ya hi Amak. ");
INSERT INTO ebk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hiyana nan enommat ta matongpar nan naisurat as nan Lintigcha ay kanana, ‘Iningorak kan chicha ay maid kiapkiapúna.’ ");
INSERT INTO ebk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Omalintu nan Fumadfiachang ay murpu kan Ama. Hiya nan Espiritu Santo ay ifiaorkuntu ay mangisuru as nan kenatit-iwa kan chakayu. O, hiyantu nan mangepaneknek as nan maepangkep kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chakayu us at paneknekanyuntu nan maepangkep kan ha-un, tay naituntun-ud kayu kan ha-un nunlapu as nan laplapuna. ");
INSERT INTO ebk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Am-in chaná at kenalek kan chakayu ta achiyu koma chukchukkian nan pammatiyu kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Epak-ak chakayuntu as nan senagogacha. Fiakun yangkiay sa, tay omalintu nan timpu ay nan tataku ay mangpatuy kan chakayu at numnumunchantu ay chacha munserserfi kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hiyanantu nan atuncha kan chakayu, tay achicha am-ammu hi Ama winnu ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ifiagfiakiak chaná kan chakayu ad wani ta as nan omaliyan nan timpu ay mangekamanancha's na, manumnumyuntu ay infiafiakiak kan chakayu.” Inturuy Jesus, “Chaanku infiakia chaná as nan laplapuna ay nun-isuruwak kan chakayu, tay nawawachaak kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ad wani, munfiangachak as nan nangifiaor kan ha-un. Ngem uray mu hiyasa, maid manarsarudsud kan chakayu un, ‘Ay chaud nan ay-ayam?’ ");
INSERT INTO ebk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ngem kiapú ta infiakiak chaná kan chakayu ad wani, ngumunguyus kayu. ");
INSERT INTO ebk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Uray mu hiyasa, ifiakiak kan chakayu nan tit-iwa: Para as nan omammayanyu nan mak-akak. Tay mu achiyak mak-ak, achi omali nan Fumadfiachang kan chakayu. Ngem mu mak-akak, ifiaorkuntu hiya kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","As nan omaliyana, paneknekanantu as nan tataku asna's luta nan kenomsawancha maepangkep as nan fiasorcha. Paneknekanantu us nan maepangkep as kenalintig ya nan maepangkep as nan mun-okomán Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","As nan maepangkep as fiasorcha, paneknekanantu ay kenomsawcha, tay achicha omafurot kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","As nan maepangkep as kenalintig, paneknekanantu ay nalintikiak, tay umuyak kan Ama, ya achiyaktu il-ilaun kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","As nan maepangkep as nan mun-okomana, paneknekanantu ay kenomsawcha, tay naokóm at hi Satanas ay mangetortoray as nan chiyuycha achi omaafurot asna's luta. ");
INSERT INTO ebk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ongor pay nan laychok ay ifiakia kan chakayu, ngem ad wani, achi kayu makafiael ay mangnumnum. ");
INSERT INTO ebk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ngem as nan omaliyan nan Espiritu ay mangisuru as nan kenatit-iwa, hiyantu nan mangetoróng kan chakayu ay mangammu as nan am-in ay kenatit-iwa. Achi munkali hiya as nan mismu ay kalibfengana, ngem ifiakiana nan chungruna kan Dios Ama, ya epakaammunantu kan chakayu nan ommat as kasin. ");
INSERT INTO ebk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ha-un nan chayawunantu, tay nan wacha as numnumku at hiyasantu nan iwarakiawagna kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nan am-in ay kuwan Ama at kuwak. Isunga kenalek un nan wacha as numnumku at hiyasa nan iwarakiawagtu nan Espiritu Santo kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Inturuy us Jesus, “Achi mafiayag at achiyaktu il-ilaun kan chakayu. Angkiay ya achi kasin mafiayag at ilaunaktu.” ");
INSERT INTO ebk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Angkiay nunsesennarudsud nan tapen nan disipulusna, “Ngachana man nan laychun tona ay kanan, ‘Achi mafiayag at achiyak il-ilaun. Angkiay ya achi kasin mafiayag at ilaunaktu,’ ya, ‘Tay umuyak kan Ama’?” ");
INSERT INTO ebk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kasincha senarudsud, “Ngachana man nan laychun ay kanan nan ‘Achi mafiayag’? Achi takú met maawatan nan laychuna ay kanan.” ");
INSERT INTO ebk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Aammon Jesus nan laychuncha ay sarudsuchun kan hiya, isunga kenalina kan chicha, “Ay hiyana nan chayu munsesennarudsuchan, ‘Achi mafiayag at achiyak il-ilaun, angkiay achi kasin mafiayag at ilaunak’? ");
INSERT INTO ebk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ifiakiak kan chakayu nan tit-iwa. Mun-ag-akor ya ngumunguyus kayuntu, ngem munlagragsakchantu nan tataku ay achi omafurot. Ngumunguyus kayuntu, ngem nan ngunguyusyu at munfialintu as lagsak. ");
INSERT INTO ebk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nan maepachongana at as nan fiafiai ay cha munlikiat, tay timpon at nan munpasikarana. Ngem as nan chakusna enmankan, liw-ana nan likiatna ya ongor nan lagsakna, tay naiyanak nan mutun asna's luta. ");
INSERT INTO ebk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kaman us kan chakayu: Ngumunguyus kayu ad wani, ngem ilaoktu kasin chakayu. As nan hiyachi, munlagsak kayuntu as solet, ya maid poros mangaan as nan hana ay lagsakyu kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“As nan hana ay urkiw at maidtu uyyu kis-an sarudsuchun kan ha-un. Ifiakiak kan chakayu nan tit-iwa. Mu chumawat kayu as kumpurmi kan Ama at ichatnantu kan chakayu kiapú as nan nakius-usaanyu kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Inkiana ad wani at maid pay chinawatyu kan Ama kiapú as nan nakius-usaanyu kan ha-un. Chumawat kayu, at maawatyuntu ta maid munkurangan nan lagsakyu. ");
INSERT INTO ebk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Kenarkalek chaná kan chakayu babaen as nan maepadpachongan. Omalintu nan timpu ay achek at osarun nan maepadpachongan, ngem kun yangkiay narawag nan ifiakiaktu ay maepangkep kan Ama. ");
INSERT INTO ebk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","As nan hana ay urkiw, chumawat kayuntu mismu kan Ama kiapú as nan nakius-usaanyu kan ha-un. Achek kanan kan chakayu un chumawataktu kan Ama as para kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tay hi Ama ay mismu at laylaychuna chakayu kiapú ta lenaylayachak kan chakayu ya enafurotyu ay nurpuwak kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nurpuwak kan Amak, ya enmaliyak asna's luta. Ad wani, mak-akak asna's luta, ya munfiangachak kan Ama.” ");
INSERT INTO ebk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Angkiay kenalen nan disipulusna kan hiya, “Ilaum, narawag ad wani nan cham kankanan, tay achika mun-epadpachong. ");
INSERT INTO ebk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ad wani, ammumi at ay ammom nan am-in ay ka-ichin. Achim kasaporan chi munsarudsud kan he-a, tay mafialinmu ay songfiatan sakbay munsarudsudcha. Hiyana nan mangafurotanmi ay nurpuka kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tinumfor hi Jesus kan chicha, “Ay omafurot kayu ad wani? ");
INSERT INTO ebk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Cha omali nan timpu, ya nauy at ad wani, masisiyan kayuntu ay waschi un kenmatam as afongna. Kun pay ha-un, taynanaktu ay mauusa. Uray mu hiyasa, achiyak mauusa, tay wacha hi Ama kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nan nauycha at infiakiak kan chakayu ta natalnay numnumyu kiapú as nan nakius-usaanyu kan ha-un. Ongor chi munlikiatanyu asna's luta, ngem papigsaunyu nan numnumyu, tay enamisku at nan am-in ay mangotettet ay pannakafialin asna's luta.” ");
INSERT INTO ebk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kun pay narpas ay infiakian Jesus chaná, nuntangad ad chaya ya kanana, “Ama, enmali at nan uras ay enkeddengmu. Epailam nan kaichayawan nan Anakmu ta epailan nan Anakmu nan kaichayawam. ");
INSERT INTO ebk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tay kun pay he-a at inchatmu kan hiya nan kalibfengan ay mangetoray as nan katakutaku ta ichatna nan fiyag ay maid patingkiana as nan am-in ay tataku ay entalekmu kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nan fiyag ay maid patingkiana at hiya nan mangammuwancha kan he-a ay us-usa ay tit-iwa ay Apo Dios ya kan Jesu Cristo ay infiaormu. ");
INSERT INTO ebk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Enpailak nan kaichayawam asna's luta as nan nanglopasak as nan enpadnom kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ad wani, Ama, as nan mawawad-ak kasin as nan kawad-am, epailam nan kaichayawak ay pachong challu nan kaichayawak as nan kawad-ak kan he-a sakbay nafiayang nan luta. ");
INSERT INTO ebk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Enpakaammok nan kenadiosmukan chicha ay pinilem asna's luta. Sikud challu ay tatakom chicha, ya entalekmu chicha kan ha-un. Tenongparcha nan kalem. ");
INSERT INTO ebk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ad wani, naammuwancha ay nan am-in ay inchatmu kan ha-un at nurpu kan he-a, ");
INSERT INTO ebk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","tay infiakiak kan chicha nan infiakiam kan ha-un, at enawatcha. Ammucha ay tit-iwa ay nurpuwak kan he-a, ya afurotuncha ay he-a nan nangifiaor kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ekarkararakiak chicha. Achek cha ekararakian nan achi omaafurot ay tataku asna's luta, ngem kun yangkiay nan chiyuycha entalekmu kan ha-un, tay tatakom chicha. ");
INSERT INTO ebk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Am-in ay kuwak at kuwam, ya am-in ay kuwam at kuwak, ya maepaila pay nan kaichayawak babaen kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ad wani, achiyak at mayayasna asna's luta, tay kiayuchak munfiangad kan he-a. Ngem chicha at mayagyagcha asna's luta. Nasantowan ay Ama, aywanam koma chicha babaen as nan pannakafialinmu ay inchatmu kan ha-un ta mun-us-usacha koma ay kaman as nan nun-us-usaanta. ");
INSERT INTO ebk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","As nan nawawad-ak kan chicha at enaywanak chicha babaen as nan pannakafialinmu ay inchatmu kan ha-un. Tit-iwa, enaywanak chicha ay ustu. Maid poros nalitaw kan chicha, ngem kun yangkiay nan usa ay nakeddengan ay machusa ta matongpar nan naisurat as nan Kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ad wani, kiayuchak munfiangad kan he-a. Ifiakiak chaná kan chicha as nan mawawad-ak pay laing asna's luta ta nan lagsakku at maichat kan chicha ay maid munkurangana. ");
INSERT INTO ebk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Infiakiak kan chicha nan infiakiam kan ha-un, ya nan tataku asna's luta ay achi omaafurot at iningorcha chicha. O, tay achicha ngamin makius-usa as nan achi omaafurot asna's luta ay kaman kan ha-un ay achi makius-usa as nan achi omafurot. ");
INSERT INTO ebk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Achek chawatun ay ek-akmu chicha asna's luta, ngem chawatok ay aywanam chicha ta achicha maamis as nan pannakafialin Satanas ay makali un Mangotettet. ");
INSERT INTO ebk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kamancha kan ha-un ay achi makius-usa as nan achi omaafurot asna's luta. ");
INSERT INTO ebk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Elasinmu chicha ay munserfi kan he-a babaen as nan kalem ay hiya nan kenatit-iwa. ");
INSERT INTO ebk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nan enatku ay nangifiaor kan chicha asna's luta at kaman as nan enatmu ay nangifiaor kan ha-un asna's luta. ");
INSERT INTO ebk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ichatonku nan achorku kan he-a para kan chicha ta uray chicha at maelasincha ay munserfi tit-iwa kan he-a. ");
INSERT INTO ebk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Fiakun yangkiay chatona ay disipulusku nan ekararakiak ngem uray us nan chiyuycha omafurottu kan ha-un kiapú as nan ifiagfiakiacha. ");
INSERT INTO ebk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ama, ekararagku ay mun-us-usacha koma am-in ay kaman as nan mawawad-am kan ha-un ya mawawad-ak kan he-a. Mawawachacha koma kan chita ta afurotuntu nan tataku asna's luta ay finaorak kan he-a. ");
INSERT INTO ebk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Inchatku kan chicha nan kaichayawan ay inchatmu kan ha-un ta mun-us-usacha ay kaman as nan nun-us-usaanta. ");
INSERT INTO ebk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mawawachaak kan chicha, ya mawawachaka us kan ha-un ta maid koma munkurangan nan mun-us-usaan chi numnumcha. Mu hiyasa, maammuwan koma nan tataku asna's luta ay finaorak kan he-a. Maammuwancha koma us ay laylaychum chaná ay disipulus ay kaman as nan nanglaylaychanam kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ama, laychok ay nan tataku ay entalekmu kan ha-un at mawawachacha us koma kan ha-un as nan kawad-ak. Mu hiyasa, ilauncha nan kaichayawak ay inchatmu kan ha-un, tay lenaylayachak kan he-a sakbay nafiayang nan luta. ");
INSERT INTO ebk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“O, Ama ay nalintig, nan achi omaafurot ay tataku asna's luta at achi chaká am-ammu. Ngem ha-un at am-ammok he-a, ya nan nauycha disipulusku at ammucha ay finaorak kan he-a. ");
INSERT INTO ebk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Enpakaammok kan chicha nan maepangkep as nan kenadiosmu,ya ituruyku pay ay mangepakaammu. Atok na ta nan layadmu kan ha-un at mawawacha kan chicha ya ta mawawachaak us kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","As nan nanglopasan Jesus as nan nauy ay kararag, nak-ak hiya ay kadwana nan disipulusna, ya kinchangcha nan kinnaw ay Kidron. Angkiay inmuycha henan lukiar ay naetatanman chi ongor ay kaiw ay olivo. ");
INSERT INTO ebk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hi Judas ay mangesepsep kan Jesus at aammuna chi ay lukiar, tay hid-i nan kanayon ay nakisibsib-atan Jesus as nan disipulusna. ");
INSERT INTO ebk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Isunga inmuy hi Judas hid-i ay nangepangu as nan usa ay bunggoy nan sosorchachu ay i-Roma, nan kukuwarcha as Templo ay infiaor nan anap-apon chi papachi ya nan chiyuycha Fariseo. Nangaparorcha, nangapenakadcha, ya nangaarmascha. ");
INSERT INTO ebk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kiapú ta aammon Jesus nan am-in ay atunchantu kan hiya, naisib-at kan chicha, ya kanana, “Ngachana nan chayu anapun?” ");
INSERT INTO ebk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Hi Jesus ay i-Nazaret,” ensongfiatcha. “Ha-un ya,” kenalen Jesus. Hi Judas ay mangesepsep kan Jesus at naketatakchug kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","As nan nangaliyan Jesus, “Ha-un ya,” nasannanudcha ya natu-ugcha. ");
INSERT INTO ebk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Angkiay ya kasin nunsarudsud hi Jesus kan chicha, “Ngachana ngarud nan chayu anapun?” “Hi Jesus ay i-Nazaret,” ensongfiatcha kasin. ");
INSERT INTO ebk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Infiakiak met kan chakayu un ha-un,” ensongfiat Jesus. “Mu ha-un nan chayu anapun, pay-anyu ta mak-ak nan nauycha kakadwak.” ");
INSERT INTO ebk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Infiakian Jesus na ta matongpar nan kenalina: “Ama, maid linitawku as uray usa as nan chiyuycha entalekmu kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Angkiay ya hi Simon Pedro ay nangachoros, enoknosna nan chorosna, ya finakagna nan fiabfiaarun nan kangatuwan ay pachi, at nakingasan nan kannawan ay ingana. Nan ngachan nan fiabfiaaruna at Malco. ");
INSERT INTO ebk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Infilin Jesus kan Pedro, “Esekatmu nan chorosmu. Ay kanam un achek eta-un nan likiat ay enkeddeng Ama kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Angkiay ya nan bunggoy chi sosorchachu patí nan komandercha ya nan chiyuycha kuwarcha as Templo at tiniliwcha hi Jesus, ya finarudcha nan limana. ");
INSERT INTO ebk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Inyuycha hiya omona kan Anas ay katukiangan Caifas. Hi Caifas ay anna nan kangatuwan ay pachi as nan hiyachi ay tawwun. ");
INSERT INTO ebk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hi Caifas us nan nangitukun as nan ap-apon chi Judio ay un-unuyna ay matuy nan usa ay taku para as nan am-in ay tataku. ");
INSERT INTO ebk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Hi Simon Pedro ya nan usa ay disipulu at inmunudcha kan Jesus. Kiapú ta nan disipulu ay anna at am-ammon nan kangatuwan ay pachi, naparufusan ay nakiskop kan Jesus as nan fiattaw nan palasyon nan kangatuwan ay pachi. ");
INSERT INTO ebk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ngem hi Pedro at nayagyag as chara as nan sag-un nan sugpan. Isunga nunfiangad nan hana disipulu ay am-ammon nan kangatuwan ay pachi as nan sugpan, ya naketakiatfor as nan fiafiai ay munfianfiantay as nan sugpan. As nan hiyachi, enpaskopna hi Pedro. ");
INSERT INTO ebk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kenalen nan mafiabfiaor ay fiafiai ay munfianfiantay as nan sugpan kan Pedro, “Ay fiakunka us usa as nan disipulus nan hana laraki?” “Fiakun ya!” kenalen Pedro. ");
INSERT INTO ebk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","As nan hiyachi at tungnin. Nan chiyuycha mafiabfiaor ya nan chiyuycha kuwarcha at enpafiaracha nan uling ya nangatakchugcha ay cha mun-an-anichu. Uy naketatakchug us hi Pedro, ya cha makean-anichu kan chicha. ");
INSERT INTO ebk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kun pay nan kangatuwan ay pachi at chana fistikiarun hi Jesus maepangkep as nan disipulusna ya nan sursuruna. ");
INSERT INTO ebk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tinumfor hi Jesus kan hiya, “Kanayonak ay nunkarkali as nan sangwanan nan kaongoran chi tataku. Kanayon pay ay nun-is-isuruwak as nan senagoga ya as nan Templo ay naam-amongan nan am-in ay Judio. Maid met naetatafun as kenarkalek. ");
INSERT INTO ebk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Adchi t'uy kan ha-un chi munsarudsucham? Kakunmu sarudsuchun as nan tataku ay nanngor kan ha-un, tay ammucha met nan infiagfiakiak.” ");
INSERT INTO ebk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","As nan nangaliyan Jesus as na, nuntampak nan usa ay kuwarcha ay nangatakchug hid-i, ya kanana, “Ay hiyasay atum ay manfor as nan kangatuwan ay pachi?” ");
INSERT INTO ebk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tinumfor hi Jesus kan hiya, “Mu wachay infiakiak as achi ustu, paneknekam as nan tataku hena nan achi ustu ay kenalek. Ngem mu ustu nan kenalek, anuyak lawá tampakun?” ");
INSERT INTO ebk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Angkiay ya infiaor Anas hi Jesus ay kukutug ay nafiafiarud nan limana kan Caifas ay kangatuwan ay pachi. ");
INSERT INTO ebk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kun pay kutug hi Simon Pedro ay nangatakchug as nan fiattaw ay cha mun-an-anichu, wachacha nan nanarudsud kan hiya, “Ay fiakunka us usa as nan disipulusna?” “Aw, fiakunak!” kenalina ay nangesaot. ");
INSERT INTO ebk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wacha hid-i nan usa as nan fiabfiaarun nan kangatuwan ay pachi ay ib-an nan laraki ay kiningasan Pedro nan ingana. Senarudsudna, “Ay fiakun he-a nan inilak as nan kawad-an nan kakkaiw ay olivo ay nakekakadwa kan Jesus?” ");
INSERT INTO ebk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ngem kasin ensaot Pedro chi. Hiya at chi ya nunkokakok nan ka-or. ");
INSERT INTO ebk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nakapis at as nan nanglopasancha ay namistikiar kan Jesus as afong Caifas. Inyuy nan chiyuycha anap-apon chi Judio hiya as palasyon nan gobernador ay Romano, ngem chaancha nakiskop kiapú ta law-un nan Lintigcha ay sungkopcha as nan lukiar nan Gentil ta achicha maifilang as naruket ya ta mafialincha ay makekan as nan Fiastan chi Munlausan. ");
INSERT INTO ebk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Isunga pinmitiw hi Pilato ay gobernador, ya senarudsudna kan chicha, “Ngachana nan charumyu kan tona ay laraki?” ");
INSERT INTO ebk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“Ay kunmi lawá cha iyar-ali nan nauy laraki kan he-a mu maid fiasorna?” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kenalen Pilato kan chicha, “Mu hiyasa, kikiad kayu ngarud. Ayu, chakayu mismu nan mangokóm kan hiya ay maiyunud as nan Lintigyu.” “Ngem chakami ay Judio at maid met kalibfenganmi ay mangepapatuy as taku,” ensongfiatcha. ");
INSERT INTO ebk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hiyana nan enommat ta matongpar nan kenalen Jesus maepangkep as nan atuna ay matuy. ");
INSERT INTO ebk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sinungkop kasin hi Pilato as nan palasyu, ya enpaayagna hi Jesus. Senarudsudna kan hiya, “Ay he-a nan aren chi Judio?” ");
INSERT INTO ebk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tinumfor hi Jesus, “Ay nurpu as numnummu sa ay sarudsud, winnu wachachay nangifiakia kan he-a as nan maepangkep kan ha-un?” ");
INSERT INTO ebk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tinumfor hi Pilato, “Ay kunak Judio? Nan mismu ay kakailiyam ya nan anap-apon chi papachi nan nangipurang kan he-a hena. Ngachana man chi fiasormu?” ");
INSERT INTO ebk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","“Fiakun asna's luta nan mun-ariyak,” ensongfiat Jesus. “Mu asna's luta nan mun-ariyak at nakepapatuy koma nan papasorotku ta chaanak tiniliw as nan anap-apon chi Judio. O, nan mun-ariyak at fiakun asna's luta nan murpuwana.” ");
INSERT INTO ebk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Isunga senarudsud Pilato kan hiya, “Ay ari ka ngarud?” “He-a nan nangali un ariyak,” ensongfiat Jesus. “Nan pangkep nan enmaliyak asna's luta ya naiyanakak at ta paneknekak nan kenatit-iwa. Nan am-in ay manglayad as nan kenatit-iwa at chungruna nan kanak.” ");
INSERT INTO ebk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","As nan hiyachi, senarudsud Pilato, “Ngachana man nan kenatit-iwa?” As nan nangaliyan Pilato as na, pinmitiw kasin hiya, ya kanana as nan chiyuycha Judio, “Maid met maanapak as fiasorna as mang-okomák kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ngem wacha nan iniili ay ukialiyu ay umilufusak as usa ay fiarud ay laychunyu as nan Fiastan chi Munlausan. Ay laychunyu ay ilufusku nan ariyu ay Judio?” ");
INSERT INTO ebk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Infukiawcha, “Fiakun hiya! Hi Barrabas nan laychunmi!” (Hi Barrabas ay anna at kumukuru.) ");
INSERT INTO ebk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kun pay narpas chi, enpasaplet Pilato hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kun pay nan sosorchachu, nunpolekawcha as sufet, ya inpuuycha as uruna. Finachuwancha hiya as kummayad ay kakiay ay kaman fiachon chi ari. ");
INSERT INTO ebk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Angkiay ya chacha masensennokat ay manamtampak ay mangarkali kan hiya, “Matakutakuka ay Aren chi Judio!” ");
INSERT INTO ebk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pinmitiw kasin hi Pilato, ya kanana as nan tataku, “Ad wani, epaipitiwku hiya hena ta maammuwanyu ay maid maanapak as fiasorna.” ");
INSERT INTO ebk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Isunga pinmitiw hi Jesus ay nakokoronaan as sufet ya nangafiachu as kaman fiachon chi ari. Kenalen Pilato kan chicha, “Ilaunyu, nauy nan taku.” ");
INSERT INTO ebk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kun pay inilan nan anap-apon chi papachi ya nan kukuwarcha as nan Templo hiya, infukiawcha, “Epalansam hiya as nan koros! Epalansam hiya as nan koros!” Ngem kenalen Pilato kan chicha, “Chakayu mismu nan mangara kan hiya, ya elansayu as nan koros, tay maid naanapak as fiasorna.” ");
INSERT INTO ebk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tinumfor nan chiyuycha Judio, “Wacha met nan lintigmi ay mangali un masapor matuy hiya, tay kenalina un anak Apo Dios hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kun pay chinngor Pilato chaná ay kenalicha, kaskasin inmugyat hiya. ");
INSERT INTO ebk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sinungkop kasin as nan palasyu, ya senarudsudna kan Jesus, “Ay chaud man nan nurpuwam?” Ngem chaan tinumfor hi Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kenalen Pilato kan hiya, “Anuyka achi tumfor kan ha-un? Ay achim ammu ay wachay kalibfengak ay mangilufus winnu mangepaelansa kan he-a as nan koros?” ");
INSERT INTO ebk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tinumfor hi Jesus kan Pilato, “Maid poros kalibfengam kan ha-un sukúd kun ichat Apo Dios kan he-a. Isunga nan taku ay nangipurang kan ha-un kan he-a at ong-ongor nan fiasorna.” ");
INSERT INTO ebk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","As nan nanngoran Pilato as na, chana anapun chi atuna ay mangilufus kan Jesus. Ngem infukiaw nan chiyuycha Judio, “Mu ilufusmu na ay taku at fiakun chaká kiayyum kan Emperador. Tay nan ngachana ay mangifilang as achorna as ari at kafusor nan Emperador.” ");
INSERT INTO ebk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kun pay chinngor Pilato chaná ay kenalicha, enpaipitiwna hi Jesus, angkiay uy tenmokor as nan tokoran chi huwes henan lukiar ay makali un Naataran as Fiatu. Nan ngachana as nan kalen chi Hebreo at Gabata. ");
INSERT INTO ebk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","As nan hiyachi at kiayud munkiawa as nan Urkiw ay Munsakianaan nan Judio as nan Fiastan chi Munlausan. Kenalen Pilato as nan chiyuycha Judio, “Nauy nan ariyu!” ");
INSERT INTO ebk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ngem infugfukiawcha, “Epapatuymu! Epapatuymu! Epalansam as nan koros!” Kenalen us Pilato kan chicha, “Ay laychunyu ay epalansak nan ariyu as nan koros?” “Maid tukún as arimi mu achi yangkiay hi Emperador,” ensongfiat nan anap-apon chi papachi. ");
INSERT INTO ebk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kun pay as nan anongos, inpurang Pilato hi Jesus kan chicha ta maelansa as nan koros. ");
INSERT INTO ebk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nan sosorchachu at enpasakfiatcha kan Jesus nan korosna, ya inyuycha hiya henan lukiar ay makali un Lukiar nan Tong-or chi Uru. Nan ngachana as nan kalen chi Hebreo at Golgota. ");
INSERT INTO ebk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hid-i nan nangelansaancha kan Jesus as nan koros. Wachacha us nan chuwa ay enlansacha as nan koroscha, usa as apét kannawan Jesus ya nan usa as apét kannikidna. ");
INSERT INTO ebk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Wacha us nan enpaisurat Pilato ay enpaipuuyna as nan koros Jesus ay kanana, “Hi Jesus ay i-Nazaret, nan Aren chi Judio.” ");
INSERT INTO ebk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ongor as nan chiyuycha Judio nan nangfiasa as na, tay nan lukiar ay naekorosan Jesus at naesasag-un henan siyudad. Usa pay at naisurat sa as kalen chi Hebreo, Latin ya Griego. ");
INSERT INTO ebk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nan anap-apon chi papachen chi Judio at inmuycha kan Pilato, ya nunlilicha, “Fiakun ‘Aren chi Judio’ nan isuratmu, ngem kun at nan ‘Kenalen tona ay laraki un ha-un nan Aren chi Judio.’ ” ");
INSERT INTO ebk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ngem tinumfor hi Pilato, “Nan chakusku insurat at achi masokatan.” ");
INSERT INTO ebk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kun pay lenpas nan sosorchachu ay nangelansa kan Jesus as nan koros, enaracha nan chiyuycha fiachuna, ya nunkap-atuncha ta makmakchangcha ay opat. Enaracha us nan an-anchu ay kaman sando ay enafor ay maid nunsoopana. ");
INSERT INTO ebk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Isunga kenalen nan sosorchachu as nan tunggal usa, “Achi takú laksetun. Un-unuyna mu kun takú at munfifinnunot ta ilaun takú mu ngachana nan manguwa.” Hiyana nan enommat ta matongpar nan naisurat as nan Kalen Apo Dios ay kanana, “Kinudkudwacha nan chiyuycha fiachok, ya nunfifinnonotancha nan an-anchu ay sandok.” ");
INSERT INTO ebk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","As nan sag-un nan koros Jesus, nangatakchug cha enana, nan sunúd enana ay fiafiai, hi Maria ay asawan Cleofas, ya hi Maria Magdalena. ");
INSERT INTO ebk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kun pay inilan Jesus hi enana ya nan disipuluna ay laylaychuna ay nangatakchug as nan sag-una, kenalen Jesus kan enana, “Ammi, hi tosa nan ifilangmu as anakmu.” ");
INSERT INTO ebk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kenalina us as nan chiyuy disipuluna, “Enauchi, hi tosa nan ifilangmu as enam.” Nunlapu as nan hiyachi ay uras, enkatam nan chiyuy disipulu hi enan Jesus as afongna. ");
INSERT INTO ebk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","As nan narpasan tona, ammon at Jesus ay lenpasna nan am-in ya ta matongpar nan naisurat as nan Kalen Apo Dios, kenalina, “Nasketanak.” ");
INSERT INTO ebk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wacha hid-i nan usa ay fusi ay nanapnu as senmoka ay fiayas. Isunga ensawsaw nan sosorchachu nan munyam-us ay mangsosop as nan fiayas. Enpakatcha as nan ungtiw nan naluslusan ay lukiam ay makali un hisupu, ya inchawchawcha ta sosopun Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kun pay senosop Jesus chi, kenalina, “Narpas at.” Angkiay ya nunyongyong ya entalekna nan long-agna kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nan hana ay urkiw ay natuyan Jesus at Urkiw ay Munsakianaan. As nan kafikiatana at hiyasa nan kapatekian ay Urkiw ay Mun-iblayan, tay maikisan as nan Fiastan chi Munlausan. Kiapú ta law-uncha mu mayaschi nan chiyuycha achor as nan koros as nan Urkiw ay Mun-iblayan, inmuy nan anap-apon chi Judio kan Pilato, ya chinawatcha kan hiya ay epaepongna nan suken nan chiyuycha naelaransa as nan koros ta munkakatuycha, at epakaana chicha as nan koroscha. ");
INSERT INTO ebk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Isunga inmuy nan sosorchachu, ya enepongcha nan suken nan chuwa ay lanaraki ay naikiakiaw-an Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ngem kuncha pay enmali kan Jesus ya inilacha ay nanatuy at hiya, chaancha enepong nan sukina. ");
INSERT INTO ebk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Uray mu hiyasa, inchuyok nan usa as nan sosorchachu nan fiangkawna as nan kapiniling Jesus. Hiya at chi ya tinmuy-ok chi chara ya chanum. ");
INSERT INTO ebk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nan taku ay nangila as nan nauy ay enommat at paneknekana na ta omafurot kayu us koma. Tit-iwa nan pammaneknekna ya ammuna ay kenatit-iwa nan infiakiana. ");
INSERT INTO ebk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Enommat chaná ta matongpar nan naisurat as nan Kalen Apo Dios ay kanana, “Maidtu maepong as uray usa as nan tong-orna.” ");
INSERT INTO ebk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wacha us nan tapina ay naisurat as nan Kalen Apo Dios ay kanana un, “Ilaunchantu hiya ay chinuyokcha.” ");
INSERT INTO ebk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","As nan narpasan tona, inmuy hi Jose ay i-Arimatea kan Pilato, ya chinawatna nan achor Jesus. Hi Jose ay anna at usa'y disipulon Jesus, ngem kuna chaan enpakpakaammu nan pammatina as nan ongor ay tataku, tay umugyat as nan anap-apon chi Judio. As nan nangeparufusan Pilato, uy enek-ak Jose nan achor Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nakiuy us hi Nicodemo ay hiya nan inmuy kan Jesus as nan henlafi. Enmetakin hiya as nasorok as turon puru ay kilo ay fiangfiangru ay naamma as makali un mirra ya aloe. ");
INSERT INTO ebk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Enaran nan nauycha chuwa nan achor Jesus, ya penotepotancha as am-ammay ay lopot ay natapiyan as fiangfiangru ay maiyunud as nan iniili ay ukialen nan chiyuycha Judio ay atuncha as nan natuy. ");
INSERT INTO ebk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","As nan sag-un nan naekorosan Jesus, wacha nan lukiar ay natatanman as ongor ay kaiw ay kawad-an nan fiarú ay lufok ay maid nailublufok. ");
INSERT INTO ebk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kiapú ta kiayud umchan nan Urkiw ay Mun-iblayan chi Judio ya kiapú ta naesasag-un nan lufok, hid-i nan uycha nangilubkan kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kun pay as nan Chumingku, hi Maria Magdalena at enmalicha as nan chaan napat-or as nan lufok Jesus, ya inilana ay nakaan nan fiatu ay naetatangub as nan pantiw nan lufok. ");
INSERT INTO ebk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Isunga tenmagtag hiya ay inmuy kan Simon Pedro ya as nan usa ay disipulu ay laylaychun Jesus, ya infiakiana kan chicha, “Enaracha nan achor nan Apo hid-i's lufok, ya achimi ammu nan nangiyuyancha kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","As nan nanngoran Pedro ya nan usa ay disipulu, naannuuycha as lufok. ");
INSERT INTO ebk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tenmagtagcha ay chuwa, ngem kiapú ta fekfekkas nan usa mu hi Pedro, enmon-ona ay inumchan as lufok. ");
INSERT INTO ebk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nunyongyong ay nangila ad chur-um, ya inilana nan an-anchu ay lopot ay naepotepot kan Jesus, ngem chaan sinungkop hiya. ");
INSERT INTO ebk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kun pay inumchan hi Simon Pedro ay cha umun-unud, nunchakpos ay sinungkop as nan lufok. Inilana nan an-anchu ay lopot ay naepapatang hid-i ");
INSERT INTO ebk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ya nan panyu ay naepotepot as nan uron Jesus. Nan nauy panyu at chaan naetatapi as nan an-anchu ay lopot, ngem nalelekop as nan mismu ay kawad-ana. ");
INSERT INTO ebk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Angkiay ya sinungkop us nan usa ay disipulu ay enmon-ona ay inumchan as lufok. As nan nangil-ana as nan chiyuycha lopot ay wacha hid-i, enafurotna ay nataku hi Jesus manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ngem chaancha pay naawatan nan naisurat as nan Kalen Apo Dios ay kanana un masapor mataku hiya manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kun pay narpas sa, kenmatam nan chuwa ay disipulus. ");
INSERT INTO ebk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hi Maria at nangatakchug ay cha mun-ag-akor as luwar nan lufok. Kun pay cha mun-ag-akor, nunyongyong ay nangila ad chur-um. ");
INSERT INTO ebk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Inilana nan chuwa ay anghel ay nunfiafiachu as munpupukaw ay nangatokor as nan naepapab-ukian nan achor Jesus as nan chaana pay natakuwan manipud as nan utúy. Nan usa at nangatokor as nan ulluwana, ya nan usa at as nan kawad-an nan sukina. ");
INSERT INTO ebk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Senarudsud nan nauycha chuwa ay angheles kan hiya, “Ammi, anuyka cha mun-ag-akor?” “O, tay enlayawcha nan ok Apo, ya achek ammu nan nangiyuyancha kan hiya,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kuna pay kenali na, nunsakong ya inilana hi Jesus ay nangatakchug, ngem chaana enmatonan ay hi Jesus chi. ");
INSERT INTO ebk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Ammi, anuyka cha mun-ag-akor? Ngachana nan cham anapun?” senarudsud Jesus kan hiya. Ka-anan Maria mu hiyachi nan mun-ay-aywan as nan naetatanman chi ongor ay kaiw, isunga kenalina kan hiya, “Sir, mu he-a nan nangek-ak kan hiya, ifiakiam mu ay chaud nan nangiyuyam ta uyku epaara.” ");
INSERT INTO ebk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Maria,” kenalen Jesus kan hiya. Hiya at chi, nunsakong hi Maria, ya kanana, “Rabboni!” Nan laychuna ay kanan as nan kalen chi Hebreo at “Misturu”. ");
INSERT INTO ebk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Infiakian Jesus kan hiya, “Achiyak un-unnan, tay chaanak pay ngenmatu ay munfiangad kan Ama. Ngem kunmu at uy ifiakia as nan ib-ak un munfiangachak kan Amak ay hiya nan Amayu, ya as nan Diosku ay hiya nan Diosyu.” ");
INSERT INTO ebk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","As nan hiyachi, inmuy hi Maria Magdalena as nan disipulus Jesus, ya kanana, “Inilak nan Apo!” Infiakiana kan chicha nan kenalen Jesus kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","As nan lafen nan hiyachi ay Chumingku, naamong nan disipulus Jesus as nan usa ay afong. Nan chiyuycha unub at nunkaichakigcha, tay umugyatcha as nan anap-apon chi Judio. Kalina at ya wacha hi Jesus ay naketatakchug kan chicha, ya kanana kan chicha, “Nan natalna ay numnum nan mawawacha koma kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kuna pay kenali na, enpailana kan chicha nan chuwa ay limana ya nan kapinilingna. As nan hiyachi, naragsakan as solet nan disipulus as nan nangil-ancha as nan Apo. ");
INSERT INTO ebk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Angkiay ya kasin kenalen Jesus kan chicha, “Nan natalna ay numnum nan mawawacha koma kan chakayu. Kaman as nan nangifiaoran Ama kan ha-un at assesa us ay ifiaorku chakayu.” ");
INSERT INTO ebk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kuna pay kenali na, senop-okana chicha, ya kanana, “Awatunyu nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mu pakawanunyu nan uray ngachana as nan fiasfiasorna, mapakawan hiya. Mu achiyu pakawanun chicha, achicha mapakawan.” ");
INSERT INTO ebk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","As nan lafi ay nunpail-an Jesus as nan disipulusna, maid kan chicha hi Tomas ay makali un Apel ay usa as nan hinpuru ya chuwa ay disipulus. ");
INSERT INTO ebk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Isunga infiakian nan tapina ay disipulus kan hiya, “Inilami nan Apo!” Ngem tinumfor hi Tomas kan chicha, “Achek afurotun sukúdku ilaun ay mismu nan filat as limana as nan naelansaana. Achek challu afurotun sukúdku kaprosun nan filat as nan limana ya kapinilingna.” ");
INSERT INTO ebk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kun pay inmuy chi usa ay chumingku, naamong kasin nan disipulus Jesus as nan afong, ya wacha hi Tomas kan chicha. Nunkaichakig nan chiyuycha unub, ngem kalina at ya wacha hi Jesus ay naketatakchug kan chicha, ya kanana, “Nan natalna ay numnum nan mawawacha koma kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Angkiay ya kenalina kan Tomas, “Nauycha nan limak. Ayu, ichawchawmu nan limam ta kaprosum nan filatku as nan kapinilingku. Ikinakmu man ay munchuwachuwa, ngem kunka at omafurot!” ");
INSERT INTO ebk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tinumfor hi Tomas kan hiya, “Apok ya Diosku!” ");
INSERT INTO ebk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kenalen Jesus kan hiya, “Ad wani, kiapú ta inilaak at enmafurotka? Nakiasatcha nan chaan nangila kan ha-un, ngem omafurotcha.” ");
INSERT INTO ebk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ongor pay nan tapina ay nakaskaschaaw ay sinyar ay enkamkaman Jesus ay inilan nan disipulusna ay chaan naisurat as nan nauy ay liblu. ");
INSERT INTO ebk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ngem naisurat chaná ta afurotunyu ay hi Jesus nan Cristo ay Anak Apo Dios ya ta babaen as nan pammatiyu kan hiya at mawad-an kayu as fiyag ay maid patingkiana. ");
INSERT INTO ebk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","As nan narpasan tona, nunpaila kasin hi Jesus as nan disipulusna henan olet nan fiayfiay ay makali un Tiberias. Nan enkamana ay nunpaila at hiyana. ");
INSERT INTO ebk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Naaamong am-in cha Simon Pedro, Tomas ay makali un Apel, hi Natanael ay i-Cana ad Galilea, nan chiyuycha potot Zebedeo, ya nan chuwa pay ay disipulus Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kenalen Simon Pedro kan chicha, “Uyak manafukor.” “Makeali kami kan he-a,” kenalicha kan hiya. Isunga uycha nunlukian as nan fiangka. Ngem as nan hiyachi ay lafi, maid tenafukorancha. ");
INSERT INTO ebk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kun pay cha fomoknag nan urkiw, nangatakchug hi Jesus henan olet nan fiayfiay, ngem chaan naematonan nan disipulus ay hi Jesus chi. ");
INSERT INTO ebk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Infukiaw Jesus kan chicha, “Kiakiayyum, ay wachay enarayu?” “Maid mampay!” ensongfiatcha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“Etap-oryu nan tafukor as apét kannawan nan fiangka, at wachay konaunyu,” kenalina kan chicha. As nan nangetap-orancha tit-iwa, chaancha at nakainat, tay ongor chi nakna. ");
INSERT INTO ebk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Angkiay ya kenalen nan chiyuy disipulu ay laylaychun Jesus kan Pedro, “Nan Apo payat chi!” As nan nanngoran Simon Pedro un nan Apo chi, nun-iyammana nan kakiayna, (tay kenakaana) ya tinmifok ay umuy kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ngem nan tapina ay disipulus at nunfiafiangkacha ay cha mangikiayad as nan tafukor ay nanapnu as natafukoran. Achi achawwi henan oletna ay kun kiayud hinkiasot ay metros nan kaachawwicha. ");
INSERT INTO ebk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kuncha pay tenmakchang, inilacha nan uling ay finmafiara ay naikukumfiaan chi fiangos ya wacha us chi tenapay. ");
INSERT INTO ebk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kenalen Jesus kan chicha, “Ayu! Umiyali kayu as tapen nan katabtafukoryu.” ");
INSERT INTO ebk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Isunga nunfiangad hi Pedro as nan fiangka, ya finmachang as nan kakadwana ay nangikuyud as nan tafukor ay nanapnu as anad-acha ay nakna. Nan filang nan am-in ay nakna at hinkiasot ya leman puru ya turu. Uray mu hiyachi nan kaongor nan enaracha, chaan challu narakset nan tafukor. ");
INSERT INTO ebk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kenalen Jesus kan chicha, “Akayu ta mangan takú.” As nan hiyachi, maid naturud as nan disipulus ay nangsarudsud, “Ngachanmu,” tay ammucha ay nan Apo. ");
INSERT INTO ebk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Enaran Jesus nan tenapay, ya inchatna kan chicha. Assesa us nan enatna as nan fiangos. ");
INSERT INTO ebk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Hiyana nan maekatlu ay nunpail-an Jesus as nan disipulusna as nan narpasan nan natakuwana manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","As nan narpasancha ay nangan, senarudsud Jesus kan Simon Pedro, “Simon ay potot Juan, ay ong-ongor nan layadmu kan ha-un mu nan nauycha tapina ay disipulus?” “O, Apo, ammom met ay laylaychok he-a,” ensongfiat Pedro. “Mu hiyasa, aywanam nan chiyuycha enmafurot kan ha-un ay chicha nan maepachong as nan korderok,” kenalen Jesus. ");
INSERT INTO ebk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Senarudsud kasin Jesus kan hiya, “Simon ay potot Juan, ay laylaychunak?” “O, Apo, ammom met ay laylaychok he-a,” ensongfiat kasin Pedro kan hiya. “Mu hiyasa, aywanam nan chiyuycha enmafurot kan ha-un ay chicha nan maepachong as nan karnerok.” ");
INSERT INTO ebk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Senarudsud Jesus as nan maekapitlu, “Simon ay potot Juan, ay laylaychunak?” Nginmuyus hi Pedro, tay namen turu ay senarudsud Jesus kan hiya, “Ay laylaychunak?” Tinumfor hi Pedro, “Apo, ammom met nan am-in. Ammom met ay laylaychok he-a.” Kenalen Jesus kan hiya, “Aywanam nan karnerok. ");
INSERT INTO ebk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ifiakiak kan he-a nan tit-iwa. As nan kafiab-arom, kikiadka ay nunfiadfiachu, ya inmuyka as nan laylaychum. Ngem kunka pay marakay, uyachumtu nan takraymu, ya tukuntu nan mangfiarud as nan limam ay mangiyuytu kan he-a as nan achim laychun ay ay-ayan.” ");
INSERT INTO ebk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kenalen Jesus na ta mangepakaammuwana as nan atun Pedro ay matuy ay mangichayaw kan Apo Dios. Kun pay narpas na, kenalen Jesus kan hiya, “Unuchunak!” ");
INSERT INTO ebk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nunsakong hi Pedro, ya inilana ay cha umunud kan chicha nan disipulu ay laylaychun Jesus. Nan disipulu ay anna nan senmasachag kan Jesus as nan naschum ay nanganancha ya nan nunsarudsud kan hiya, “Apo, ngachana nan mangesepsep kan he-a?” ");
INSERT INTO ebk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","As nan nangil-an Pedro kan hiya, senarudsudna kan Jesus, “Apo, hi tona ngay us, ngachana nan ommat kan hiya?” ");
INSERT INTO ebk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tinumfor hi Jesus, “Mu laychok ay mataku hiya inkiana munfiangachak at maid fiyangmu's chi. Aka at, unuchunak!” ");
INSERT INTO ebk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kiapú as nan nauy ay kenalen Jesus, naepachamag as nan chiyuycha enmafurot ay achi matmatuy nan nauy ay disipulu. Ngem chaana kenali un achi matmatuy nan nauy ay disipulu. Nan kenalina yangkiay at, “Mu laychok ay mataku hiya inkiana munfiangachak at maid fiyangmu's chi.” ");
INSERT INTO ebk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ha-un nan chiyuy disipulu ay infiagfiakian Jesus hena. Ha-un us nan nangepaneknek ya nangisurat as nan nauycha ay maepangkep kan Jesus. O, ammumi ay tit-iwa chaná ay insuratku. ");
INSERT INTO ebk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ongoongor pay nan tapina ay enkamkaman Jesus. Mu maisurat am-in nan enkamkaman Jesus, as nan munnunumnumku at achi ommat nan intiru ay luta ay maepay-an nan chiyuycha liblu ay maisuratancha.");
INSERT INTO ebk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kan he-a Teofilo, As nan enmon-ona ay suratku, insuratku am-in nan en-enat ya insursuron Jesus nunlapu as nan nunlapuwana ay nun-isuru ");
INSERT INTO ebk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","inkiana as nan urkiw ay naetag-uyana ad chaya. Sakbay enommat chi, babaen as nan pannakafialin nan Espiritu Santo, infilina nan atun nan apostoles ay pinilina. ");
INSERT INTO ebk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kun pay narpas ay nun-iliwas ya natuy, nunpaipaila hiya as nan apostolesna, ya babaen as nan ongor ay en-enatna at naepaneknek ay tit-iwa ay nataku hiya. As nan opat puru ay urkiw, nunpappaila hiya kan chicha, ya infiagfiakiana kan chicha nan maepangkep henan muntorayan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","As nan hin-urkiw ay nakepagyanan Jesus kan chicha, infilina, “Achi kayu mak-ak hena ad Jerusalem, ngem kunyu at sad-un nan enkaren nan Ama ay ichatna kan chakayu ay hiyachi nan infiakiak kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Finunyakian Juan nan tataku as chanum, ngem karpasan chi kaat ay urkiw at mafunyakian kayuntu as Espiritu Santo.” ");
INSERT INTO ebk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kuncha pay kasin naamong ay kadwacha hi Jesus, senarudsud nan apostoles kan Jesus, “Apo, ay fiakun ad wani nan mangepakaanam as nan i-Roma ay muntotoray kan chitaku ta chitaku ay kianak Israel nan muntoray kasin?” ");
INSERT INTO ebk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kenalen Jesus kan chicha, “Achiyu masapor ammuwun nan timpu winnu urkiw ay ommatana ay enkeddeng Ama babaen as nan mismu ay kalibfengana. ");
INSERT INTO ebk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ngem maettan kayuntu as pannakafialin as nan omaliyan nan Espiritu Santo ay mawawacha kan chakayu. Chakayuntu nan mangepaneknek as nan maepangkep kan ha-un ad Jerusalem ya henan intiru ay probinsiya ad Judea ya Samaria inkiana henan am-in ay lukiar asna's luta.” ");
INSERT INTO ebk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kuna pay lenpas ay kenali na, as nan nangiil-ancha kan hiya, naetag-uy hiya ad chaya inkiana nalingfian as nan lifuu. ");
INSERT INTO ebk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kuncha pay cha etottotoongan ad chaya as nan chana umuyan, kalina at ya wachacha nan chuwa ay lanaraki ay nunfiafiachu as munpupukaw ay naketatakchug kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kenalicha, “Chakayu ay i-Galilea, adchi t'uy kayu kukutug ay tomatakchug hena ay muntatangad ad chaya? Hi Jesus ay anna ay naetag-uy ad chaya at munfiangadtu ay kaman as nan inilayu ay enatna ay inmuy ad chaya.” ");
INSERT INTO ebk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Angkiay nunfiangad nan apostoles ad Jerusalem ay nurpu henan chuntug ay Olivo ay uy at usa ay kilometro nan kaachawwina henan siyudad. ");
INSERT INTO ebk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","As nan inumchanancha ad Jerusalem, inmuycha as nan nunngangatu ay kuwarton nan afong ay mamagyanancha. Chicha chaná: cha Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, Santiago ay potot Alfeo, Simon ay mangesasaket as ilina ya hi Judas ay potot Santiago. ");
INSERT INTO ebk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kun anaka un naam-amongcha am-in ay mun-us-usa ay munkarkararag. Naetatapi kan chicha nan fianafiai ya hi Maria ay enan Jesus, ya nan lanaraki ay en-auchen Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kun pay inmuy chi kaat ay urkiw, naamong nan umuy as hinkiasot ya chuwan puru ay omaafurot kan Jesus. As nan hiyasa, tenmakchug hi Pedro, ya kanana, ");
INSERT INTO ebk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Chakayu ay iib-ak, masapor matongpar nan naisurat as nan Kalen Apo Dios ay enpaepadton nan Espiritu Santo kan David maepangkep kan Judas ay nangepangu as nan tataku ay naniliw kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Hi Judas at kadwami ad kasin, tay usa us hiya ay pinilen Apo Jesus ay makiserfi kan chakami ay apostoles.” ");
INSERT INTO ebk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Nan siping ay lagfon Judas as nan mangotettet ay enatna at enlakuna as luta. Hid-i nan natuyana as nan nag-asana. Finumtak nan achorna ya naiwakascha nan intiru ay putuna. ");
INSERT INTO ebk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nachamag am-in nan tataku ad Jerusalem nan enommat kan hiya. Isunga ngenadnancha nan chiyuy luta as Akeldama as nan kalicha. Nan laychun ay kanan nan hana ay ngachan at “Luta ay Nacharaan.”) ");
INSERT INTO ebk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kenalen pay Pedro, “Nauy nan naisurat maepangkep kan Judas as nan liblu ay Salmo ay kanana, ‘Maenganuy koma nan afongna, ya maid koma kasin uy omab-afong hid-i.’ Wacha us nan naisurat ay kanana, ‘Wacha komay mangisubrat as nan libfenguna.’ ");
INSERT INTO ebk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Mu hiyasa, masapor munpili takú as usa as nan chiyuycha kanayon ay nakituntun-ud kan chakami as nan kawad-an Apo Jesus kan chitaku ");
INSERT INTO ebk_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","nunlapu as nan namunyakian Juan kan hiya inkiana as nan naetag-uyana ad chaya ay naek-ak kan chitaku. O, masapor wachay usa as maetapi kan chakami ay munfialin as mangepaneknek as nan maepangkep as nan inilana ay natakuwan Apo Jesus manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Isunga infiakiacha nan chuwa ay ngachan ay munpiliyancha. Nan usa at hi Jose winnu Barsabas ay nangadnan us as Justo, ya nan usa at hi Matias. ");
INSERT INTO ebk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Angkiay ya nunkararagcha. Kenalicha, “Apo, ammom am-in nan numnum chi tataku. Isunga epakaammom ngarud kan chakami mu ngachana nan pinilem kan chatona ay chuwa ");
INSERT INTO ebk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ay mangesokat kan Judas as nan nauy ay chununa ay kenaapostol. Tay hi Judas at inmuy henan lukiar ay maifiakiay kan hiya as ay-ayana.” ");
INSERT INTO ebk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Angkiay ya as nan nunfifinnunotancha as nan nauy chuwa, hi Matias nan napili ay maetapi as nan hinpuru ya usa ay apostoles. ");
INSERT INTO ebk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kun pay inumchan nan urkiw ay Pentecostes, naamongcha am-in nan omaafurot as nan usa ay afong. ");
INSERT INTO ebk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kalina at ya wachay ngangak ay nurpu ad chaya ay kaman atifudfud chi angin, ya pinnuna nan intiru ay afong ay naaamongancha. ");
INSERT INTO ebk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Angkiay ya inilacha nan maepachong as nan apuy ay nasisiyan, ya waschi un naepatang as nan uron nan tunggal usa kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Napnucha am-in as pannakafialin nan Espiritu Santo, ya enlapucha ay nunkali as tukutukún ay kali ay enpakalen nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","As nan hiyachi, wachacha nan Judio ay manangchaychayaw kan Apo Dios ay nakepapagyan ad Jerusalem ay nurpu henan tukutukún ay nasyon asna's luta. ");
INSERT INTO ebk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kuncha pay chinngor sa ay ngangak, nagrubcha nan ongoongor ay tataku ay enmali, ya naschaawcha, tay waschi un chinngorna nan mismu ay kalina ay enkalen nan chiyuycha omaafurot. ");
INSERT INTO ebk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Naschaawcha as solet, ya senarudsudcha, “Ay kun fiakun i-Galilea chaná am-in ay cha munkarkali? ");
INSERT INTO ebk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Anuy atun nan tunggal usa kan chitaku ay manngor as nan mismu ay kali takú ay chacha ekarkali? ");
INSERT INTO ebk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nan tapina met kan chitaku at i-Partia, i-Media, i-Elam, i-Mesopotamia, i-Judea, i-Capadocia, i-Ponto, i-Asia. ");
INSERT INTO ebk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Nan tapina pay at i-Frigia, i-Pamfilia, i-Egipto, ya nurpu henan sakop nan Libya ay sag-un nan Cirene. Wachacha us kan chitaku nan i-Roma ");
INSERT INTO ebk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ay Judio ya fiakun Judio ay mangun-unud as nan iniili ay ukialen chi Judio. Wachachay i-Creta ya i-Arabia. Ngem chungrun takú met challu nan mismu ay kali takú ay chacha ekali ay mangifiabfiaag as nan nakaskaschaaw ay en-enat Apo Dios!” ");
INSERT INTO ebk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Naschaawcha am-in as solet, ya nalilifok chi numnumcha ay cha munsesennarudsud, “Anan laychun ngun tona'y kanan?” ");
INSERT INTO ebk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ngem nan chiyuycha tapina ay tataku at enot-otyokcha nan chiyuycha omaafurot kan Jesus. Kenalicha, “Ku-uncha man nunkafutang.” ");
INSERT INTO ebk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ngem tenmakchug hi Pedro ya nan hinpuru ya usa ay iib-ana ay apostoles. Angkiay kenalen Pedro ay nangipigsa as nan ongor ay tataku, “Iib-ak ay Judio ya am-in kayu ay umiili hena ad Jerusalem, chumngor kayu man paat as nan epakaawatku maepangkep kan chatona am-in. ");
INSERT INTO ebk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Chaan nafutang chaná ay tataku ay kaman as nan ka-ananyu, tay maid mafutang as nan uras chi alas nuebe as nan wiet. ");
INSERT INTO ebk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ngem nauy nan kenalen Joel ay pomapadtu: ");
INSERT INTO ebk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Infiakian Apo Dios, As nan chiyuycha anongos ay urkiw, sonakoktu nan Espiritok as nan am-in ay tataku. Nan an-akyu ay lanaraki ya fianafiai at epadtuchantu nan epakaammok kan chicha. Nan fiafiallu at ilaunchantu nan chiyuycha kaman iitaw. Kun pay nan anam-amá at epaiitawkuntu nan laychok ay epakaammu kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","O, uray as nan chiyuycha lanaraki ya fianafiai ay fiabfiaarok at sonakoktu nan Espiritok as nan hanacha ay urkiw, ya chichantu nan mangepadtu as nan epakaammok kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Omepailaaktu as nakaskaschaaw ad chaya. Uray asna's luta at omepailaaktu as sinyar ay chara, apuy ya mun-alepotapot ay asok. ");
INSERT INTO ebk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nan urkiw at ngomongottu, ya nan furan at komaman as chara. Chatosa nan ommat sakbay omali nan am-amud ya machayaw ay urkiw nan Apo. ");
INSERT INTO ebk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Angkiay ya am-in ay munpasug-ang as nan Apo at maesarakanchantu.’ ” ");
INSERT INTO ebk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Inturuy pay Pedro, “Iib-a ay kianak Israel, chumngor kayu as nan ifiakiak. Hi Jesus ay i-Nazaret nan finaor Apo Dios. Penaneknekan Apo Dios na kan chakayu babaen as nan ongor ay enpakamkamana kan Jesus ay milagro, nakaskaschaaw ya sinyar. Ammuyu sa, tay enommat chaná hena's kawad-anyu. ");
INSERT INTO ebk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Hi Jesus ay anna at ad pus-uy, plenaplanon ya sikud ay ammon Apo Dios mismu ay maipurang kan chakayu. Chakayu at enpapatuyyu hiya as nan manangotettet chi ukialicha ay tataku as nan nangelansaancha kan hiya as nan koros. ");
INSERT INTO ebk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ngem tenakon Apo Dios hi Jesus manipud as nan utúy, ya wenayawayaana hiya as nan pannakafialin chi utúy, tay achi poros mafialin ay nan utúy nan mangetoray kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tay nauy nan infiakian David maepangkep kan Jesus: ‘Kanayon ay iilaok nan Apo ay wacha kan ha-un. Kiapú ta as-op as solet hiya ay mamadfiachang kan ha-un, achiyak umugyat. ");
INSERT INTO ebk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Isunga naragsakak as solet, ya ifiakiak nan lagsakku. Uray matuy nan achorku, wacha nan namnamaok, ");
INSERT INTO ebk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tay ammok ay achim engannganuy nan lenawak ad Hades winnu eparufus ay mabrok nan achor nan Nasantowan as nan lufok. ");
INSERT INTO ebk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Enpakaammom kan ha-un nan charan ay muntoróng as nan fiyag ay maid patingkiana. He-a nan mangeparagsaktu as solet kan ha-un kiapú ta mawawachaka kan ha-un.’ Hiyasa nan kenalen Ari David.” ");
INSERT INTO ebk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Inturuy pay Pedro, “Chakayu ay iib-a, laychok ay epakaammu ay ustu nan maepangkep as nan ama takú ad pus-uy ay hi Ari David. Natuy hiya, at nailufok, ya inkiana ad wani at wacha hena nan lufokna. ");
INSERT INTO ebk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ngem kiapú ta usa hiya ay pomapadtu, ammuna nan enkaren Apo Dios kan hiya ay mun-ikianak hiya as usa ay ari ay kaman kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Aammon David nan atun Apo Dios as tapen chi urkiw, ya infiakiana nan maepangkep as nan matakuwan Cristo manipud as nan utúy ay chaan naenganuy nan lenawana ad Hades winnu nabrok nan achorna. ");
INSERT INTO ebk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Hi Jesus ay anna at tenakon Apo Dios manipud as nan utúy, ya chakami am-in nan mangepaneknek, tay inilami. ");
INSERT INTO ebk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Naetag-uy hi Jesus ad chaya as apét kannawan Apo Dios. Inchat Dios Ama kan hiya nan toray ay mangsonag as nan Espiritu Santo kan chakami ay kaman as nan enkarina. Chatona nan chayu il-ilaun ya chungchungrun ad wani. ");
INSERT INTO ebk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tay chaan naetag-uy hi David ad chaya. Uray mu hiyachi, kanana, ‘Nan kanan nan Apo as nan Apok at tomokorka as apét kannawanku ");
INSERT INTO ebk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","inkiana amisok nan chiyuycha kafusormu ay kaman chicha nan kiakiatinam.’ ");
INSERT INTO ebk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Isunga chakayu am-in ay kianak Israel, masapor siguradu ay maammuwanyu ay hi Jesus ay anna ay penatuyyu as nan nangepalansaanyu as nan koros at hiya nan nunfialinun Apo Dios as Apo ya Cristo.” ");
INSERT INTO ebk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kun pay chinngor nan tataku sa, nalilifokancha as solet, ya kanancha kan Pedro ya as nan tapina ay apostoles, “Iib-a, anan atunmi ngay ngarud?” ");
INSERT INTO ebk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tinumfor hi Pedro kan chicha, “Tunggal usa kan chakayu at munfiafiawi as nan fiasfiasorna ya munpafunyag ay mangepakaammu ay hi Jesu Cristo nan Apona ta mapakawan kayu as nan fiasfiasoryu. Mu atunyu sa at maawatyuntu nan ichat Apo Dios kan chakayu ay hiya nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tay nan enkaren Apo Dios at para kan chakayu ya as nan kianakyu ya as nan am-in ay tataku henan achawwi ay luglukiar. O, nan enkarina at para as nan am-in ay piliyun nan Apo ay Dios takú.” ");
INSERT INTO ebk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ongor pay nan tapina ay kenarkalen Pedro ay nanukutukun kan chicha ya finag-ana chicha, “Esarakanyu koma nan achoryu as nan chusantu nan tataku ad wani ay manangotettet chi ukialicha ay mangachi kan Jesus.” ");
INSERT INTO ebk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Angkiay ya nan chiyuycha enmafurot as nan kenalen Pedro at nunpafunyagcha. Umuycha as turon lifu nan naetapi as nan omaafurot kan Jesus as nan hiyachi ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Enpanaagcha ya inunudcha nan insuron nan apostoles, ya tenatanudcha ay makekadkadwa as nan tapina ay omaafurot. Nakekkekancha us kan chicha as nan tenapay ay hiyasa nan mangnumnumnumancha as nan natuyan Jesus, ya nun-us-usacha ay nunkarkararag. ");
INSERT INTO ebk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","As nan hiyachi, naschaawcha am-in nan tataku, ya kiapú as nan pannakafialin Apo Dios ay inchatna as nan apostoles, ongor nan nakaskaschaaw ya sinyar ay en-enatcha. ");
INSERT INTO ebk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Inturturuy am-in nan omaafurot ay cha maam-among, ya nun-eennettancha as nan am-in ay wacha kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Enlakucha nan lutacha ya nan tapina ay kuk-uwacha. Angkiay inchatcha nan lakuna as nan am-in ay omaafurot ay makasapor. ");
INSERT INTO ebk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Inurkiw ay inturturuycha ay maam-among as nan fiattaw nan Templo. As nan mun-ub-ufongancha us as ab-afongcha at naragsakcha ya napakumbabacha ay mangan as nan tenapay ay hiyasa nan mangnumnumnumancha as nan natuyan Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kuncha pay naamong, chinaychayawcha hi Apo Dios, ya rinisrispiton nan tataku chicha. Inurkiw ay entapen Apo Dios kan chicha nan chiyuycha fiarú ay naesarakan. ");
INSERT INTO ebk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","As nan hin-urkiw, tinmikid cha Pedro kan Juan as Templo as nan alas tres as nan makiayud ay hiyasa nan munkarkararakian chi Judio. ");
INSERT INTO ebk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wacha nan usa ay laraki ay naiyanak ay pilud ay nangatokor as nan Templo as nan sag-un nan sugpan ay makali un Am-ammay. Inurkiw ay maokwat hiya ay maiyuy hid-i ta munlemos as nan chiyuycha sungkop. ");
INSERT INTO ebk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kuna pay inila cha Pedro kan Juan ay uy sungkop as Templo, nunlemos kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Entoongan cha Pedro kan Juan hiya, ya kanan Pedro, “Ilaum chakami.” ");
INSERT INTO ebk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Isunga inilana chicha ay maman-ud as ichatcha. ");
INSERT INTO ebk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Angkiay ya kenalen Pedro, “Maid poros sipingku. Ngem nan wacha kan ha-un at hiya nan ichatku kan he-a. Babaen as nan pannakafialin nan ngachan Jesus ay i-Nazaret, manaranka.” ");
INSERT INTO ebk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Angkiay ya inunnan Pedro nan kannawan ay liman nan laraki ay pilud ya finadngana hiya ay tomakchug. Hiya at chi ya kinumnugcha nan suken nan pilud. ");
INSERT INTO ebk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Natannakchug, ya enlapuna ay manaran. Haat makiskop hiya kan cha Pedro kan Juan as Templo. As nan chana manarcharanan, cha muntattat-allok ya munchaychayaw kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Inilan am-in nan tataku hiya ay cha manarcharan ya cha munchaychayaw kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kuncha pay enmatonan ay hiya payat nan nangatokor ay munlemos as nan Templo as nan sag-un nan sugpan ay makali un Am-ammay, naschaawcha as solet as nan enommat kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","As nan hiyachi, penmapakud nan enmammay ay laraki kan cha Pedro kan Juan. Tenmagtag am-in nan tataku as nan kawad-an cha Pedro kan Juan henan makali un Fiangsar Solomon, tay naschaawcha as nan enommat as nan chiyuy pilud. ");
INSERT INTO ebk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kun pay inilan Pedro nan tataku, kenalina kan chicha, “Chakayu ay iib-ak ay kianak Israel, adchi t'uy kayu maschaaw as na? Adchi t'uy chakami etotoongan? Ay kananyu un nan mismu ay kafiaelanmi winnu ustu ay panagchayawmi nan nangepacharan kan tona ay taku? ");
INSERT INTO ebk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Hi Apo Dios ay Dios cha Abraham, Isaac ya Jacob ay kaap-uwan takú nan nangepacharan kan hiya, fiakun chakami ta maila nan kaichayawan Jesus ay fiabfiaaruna. Hi Jesus ay anna at hiya nan inpurangyu kan Gobernador Pilato. Enachiyu pay hiya as nan sangwanan Pilato uray mu plenanuna ay ilufus hiya. ");
INSERT INTO ebk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ngem enachiyu hiya ay nasantowan ya nalintig, ya chinawatyu kan Pilato ay ilufusna nan usa ay pomapatuy. ");
INSERT INTO ebk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Enpapatuyyu nan mangichat as tit-iwa ay fiyag, ngem tenakon Apo Dios hiya manipud as nan utúy. Chakami ngarud nan mangepaneknek as nan maepangkep as na, tay inilami. ");
INSERT INTO ebk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kiapú as nan pannakafialin nan ngachan Jesus, finmikas nan nauy laraki ay iilaunyu ya am-ammuyu. O, kiapú as nan pannakafialin nan ngachan Jesus ya pammati kan hiya, nakaan nan piniludna ay hiyasa nan iilaunyu am-in. ");
INSERT INTO ebk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ad wani chakayu ay iib-a, ammok ay achiyu maawatan ay hi Jesus nan Cristo as nan nangepapatuyanyu kan hiya. Kaman us nan anap-apuyu at achicha maawatan. ");
INSERT INTO ebk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nan enatyu kan Jesus at hiyasa nan natongparan nan enpaepadton Apo Dios as nan am-in ay pomapadtu ay hi Cristo at masapor mun-iliwas ya matuy. ");
INSERT INTO ebk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Isunga munfiafiawi kayu as nan fiasfiasoryu, ya munfiangad kayu kan Apo Dios ta pakawanuna chakayu as nan fiasfiasoryu. ");
INSERT INTO ebk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tay mu atunyu na, wachantuy mangepapigsaantu Apo Dios as nan numnumyu. Ifiaornantu kasin nan chinutokana ay hi Jesus ay hiya nan Cristo ay mangesarakan ya mangetoray as nan am-in ay omafurot kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Masapor mayaschi hi Jesus ad chaya inkiana umchan nan timpu ay mangepafiaruwan Apo Dios as nan am-in ay enpaepadtuna as nan chiyuycha nasantowan ay pomapadtu ad pus-uy. ");
INSERT INTO ebk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hi Moises at kenalina un, ‘Hi Apo Dios at somnagtu as usa ay pomapadtu ay kaman kan ha-un ya murpu kan chakayu ay Judio. Masapor epanaagyu ya tongparunyu nan am-in ay ifiakiana kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mu wachay achi mangtongpar as nan ifiakian nan hana ay pomapadtu, maisiyantu hiya as nan tatakon Apo Dios, ya machusantu hiya in-inkiana.’ ");
INSERT INTO ebk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Am-in nan pomapadtu patí hi Samuel ya nan chiyuycha senmokat kan hiya at enkasabacha us nan cha om-ommat as nan nauycha urkiw ad wani. ");
INSERT INTO ebk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chitaku am-in nan manawid as nan enkaren Apo Dios ay enpaepadtuna as nan chiyuycha pomapadtu, ya maetapi kayu as nan inturag Apo Dios as nan kaap-uwanyu. Tay kenalina kan Abraham un, ‘Babaen as nan kianakmu, bendisyonak am-in nan tataku asna's luta.’ ");
INSERT INTO ebk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Isunga, chakayu ay Judio nan enmon-ona ay nangifiaoran Apo Dios kan Cristo ay fiabfiaaruna ta bendisyonana chakayu babaen as nan mangchukkiananyu as nan mangotettet ay panagfiyagyu.” ");
INSERT INTO ebk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kun pay kutug ay cha munkarkali cha Pedro kan Juan as nan tataku, enmali kan chicha nan papachi, nan kapetan chi kukuwarcha as nan Templo ya nan chiyuycha Saduceo. ");
INSERT INTO ebk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Finmungatcha, tay insuron cha Pedro as nan tataku nan maepangkep kan Jesus ya enkasabacha ay nataku hiya manipud as nan utúy ay hiyana nan mangpaneknek ay mataku am-in nan nunkatuy. ");
INSERT INTO ebk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Angkiay ya tiniliwcha cha Pedro kan Juan, at enpaifiarudcha inkiana as nan kafikiatana, tay naschum at. ");
INSERT INTO ebk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ngem ongor as nan chiyuycha nanngor as nan kenalen cha Pedro kan Juan nan enmafurot. Nan filang nan lanaraki ay enmafurot kan Jesus at umuy as leman lifu. ");
INSERT INTO ebk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","As nan kafikiatana, nan chiyuycha membron nan Sanhedrin ay chicha nan anap-apu, nan anam-amá ya nan mun-isursuru as Lintig at naamongcha ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nakimitincha kan Anas ay hiya nan kangatuwan ay pachi, ya kan cha Caifas, Juan ay nurpu as nan pamilyan Anas, Alejandro ya nan tapina'y lanaraki as nan pamilyan nan kangatuwan ay pachi. ");
INSERT INTO ebk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Enpatakchugcha cha Pedro kan Juan as nan sangwanancha, ya finistikiarcha chicha. Kenalicha, “Ngachana nan nurpuwan nan pannakafialin ay nangepaammay as nan nauy napilud? Ngachana nan nakin kalibfengan as nangekamananyu's na?” ");
INSERT INTO ebk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hi Pedro at napnu as pannakafialin nan Espiritu Santo, ya tinumfor hiya kan chicha, “Chakayu ay totoray ya anam-amá, ");
INSERT INTO ebk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mu fistikiarunyu chakami ad wani maepangkep as nan ammay ay enaenatmi as nan napilud ya mu anan enatna ay nakacharan, nauy ifiakiami kan chakayu. ");
INSERT INTO ebk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Masapor ngarud maammuwanyu am-in ya am-in us ay kianak Israel ay babaen as nan pannakafialin nan ngachan Jesu Cristo ay i-Nazaret at enmammay nan nauy laraki ay nangatakchug as nan sangwananyu. Hi Jesu Cristo at hiya nan enpalansayu as nan koros ay tenakon Apo Dios manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hi Jesus nan maepachong as nan nauy naisurat as nan Kalen Apo Dios ay kanana un, ‘Nan chiyuy fiatu ay enachen nan chiyuycha muntuptuping at hiyasa nan nunfialin as kaamuchan ay maipugnad.’ ");
INSERT INTO ebk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hiya yangkiay nan mafialin ay mangesarakan as nan tataku, tay maid poros tapina asna's luta ay infiaor Apo Dios ay mangesarakan kan chitaku mu achi yangkiay hiya.” ");
INSERT INTO ebk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kun pay inilan nan chiyuycha membron nan Sanhedrin nan kenaturud cha Pedro kan Juan ay tumfor, ya as nan nangammuwancha ay kun ap-apud ay tataku cha Pedro kan Juan ay chaan nakaachar, naschaawcha. As nan hiyachi, enmatonan nan anap-apu cha Pedro kan Juan ay chicha nan nakituntun-ud kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ngem kiapú ta iilauncha nan laraki ay nakaan nan piniludna ay naketatakchug kan cha Pedro, maid at makanancha ay maekontra kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Isunga enpak-akcha cha Pedro kan Juan as nan munmitmitinan nan Sanhedrin, at enapatcha mu anan atuncha kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nunsesennarudsudcha, “Anan atun takú ngun kan chatona ay lanaraki? Chakus met naammuwan nan am-in ay umiili ad Jerusalem nan nauy nakaskaschaaw ay enatcha, ya achi takú met maesaot. ");
INSERT INTO ebk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ngem ad wani ta achi maiturturuy ay maiwaras na ay chamag as nan tataku at ug-ugyatun takú chicha ta achicha kasin os-osarun nan ngachan Jesus as nan munkarkaliyancha as nan tataku.” ");
INSERT INTO ebk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Angkiay ya kasincha enayakian cha Pedro kan Juan, ya infilincha kan chicha, “Ikinakyu at man ay fukfukikun winnu isurusuru nan maepangkep as nan ngachan Jesus.” ");
INSERT INTO ebk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ngem tinumfor cha Pedro kan Juan, “Chakayu nan mangifiakia mu ustu kan Apo Dios ay chakayu nan tongparunmi, fiakun hiya, ");
INSERT INTO ebk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","tay achimi mafialin ay ikinak ay mangifiaag as nan inilami ya chinngormi kan Jesus.” ");
INSERT INTO ebk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kun pay kasin inug-ugyat nan chiyuycha membron nan Sanhedrin chicha, enparufuscha chicha ay mak-ak. Achicha ammu nan atuncha ay manusa kan chicha, tay am-in nan tataku at chacha munchaychayaw kan Apo Dios kiapú as nan nakaskaschaaw ay enommat. ");
INSERT INTO ebk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tay nan laraki ay enommatan nan nauy ay nakaskaschaaw ay pannakapaammay at nasorok as opat puru nan tawwuna. ");
INSERT INTO ebk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kun pay nailufus cha Pedro kan Juan, nunfiangadcha as nan kawad-an nan kakadwacha, at enpachamagcha nan kenarkalen nan anap-apon chi papachi ya nan anam-amá. ");
INSERT INTO ebk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kun pay chinngor nan kakadwacha nan nauy, nun-us-usacha ay nunkararag kan Apo Dios. Kenalicha, “Mannakafialin ay Apo Dios, he-a nan namayang henan chaya ya luta ya nan chanum ya am-in ay wacha kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Babaen as nan Espiritu Santo, enpaifiakiam kan David ay kaap-uwanmi ay fiabfiaarum un, ‘Adchi t'uycha fumufungat nan chiyuycha Gentil ay mangkontra kan Apo Dios? Adchi t'uy cha planplanuwun nan chiyuycha Judio nan maid kotkotokna? ");
INSERT INTO ebk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nunsakiana ay makikufiat nan ar-ari asna's luta, ya naamong nan anap-apu ay mangkufiat kan Apo Dios ya kan Cristo ay pinilina.’ ");
INSERT INTO ebk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Natongpar nan insurat David, tay henan nauy siyudad ay Jerusalem at nakeamong cha Ari Herodes ya hi Poncio Pilato as nan chiyuycha Gentil ya nan chiyuycha kianak Israel ta kontrauncha nan nasantowan ay fiabfiaarum ay hi Jesus ay pinilem. ");
INSERT INTO ebk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Naamongcha ay mangekaman as nan am-in ay enkeddengmu ay ommat kiapú as nan laychum ya pannakafialinmu. ");
INSERT INTO ebk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ad wani Apo, chungrum man paat nan chacha iyug-ugyat kan chakami. Fiadngam chakami ay fiabfiaarum ta tumurud kami ay uy mangepakaammu as nan kalem. ");
INSERT INTO ebk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Epailam man paat nan pannakafialinmu ta mafialin ay omammay nan munsaket, ya maekaman nan chiyuycha sinyar ya nan chiyuycha nakaskaschaaw babaen as nan pannakafialin ay inchat Jesus ay nasantowan ay fiabfiaarum.” ");
INSERT INTO ebk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kuncha pay narpas ay nunkararag, nunwawud nan afong ay naaamongancha. Waschi un napnu as Espiritu Santo, ya tinmurudcha ay nangiwarakiawag as nan kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","As nan hiyachi, am-in nan omaafurot kan Jesus at nun-us-usacha as nan numnum ya pusucha. Maid kan chicha nan nangali un fukchana nan uray ngachana as nan kuk-uwana, ngem kuncha at nun-eennettan as nan am-in. ");
INSERT INTO ebk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Babaen as nan pannakafialin Apo Dios, inturturuy nan apostoles ay mangepaneknek as nan maepangkep as nan natakuwan Apo Jesus manipud as nan utúy. As nan hiyachi, benendisyonan Apo Dios as solet chicha am-in. ");
INSERT INTO ebk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Maid usa kan chicha as namaichan as kasaporana, tay nan chiyuycha wachay luta ya ab-afongcha at enlakucha chasa ay kuk-uwacha. Kun pay narpas, inyalicha nan lakon nan hanacha ");
INSERT INTO ebk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","as nan apostoles ay nangepakakchang as nan chiyuycha makasapor. ");
INSERT INTO ebk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Assesa us nan enat Jose ay kianak Levi ay i-Chipre. Ngenadnan nan chiyuycha apostoles hiya as Bernabe. (Nan laychuna ay kanan at “Anak ay Lumiwliwa.”) ");
INSERT INTO ebk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Enlakuna nan usa ay payyiwna, at inyuyna nan lakuna as nan apostoles. ");
INSERT INTO ebk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ngem wacha nan hen-asawa ay cha Ananias kan Safira ay nangelaku as tapen nan lutacha. ");
INSERT INTO ebk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Intupug Ananias nan tapen nan lakuna ay aammon asawana, ya inyuyna nan tapina yangkiay as nan apostoles. ");
INSERT INTO ebk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ngem kenalen Pedro kan hiya, “Ananias, adchi t'uymu enparufus hi Satanas ay mangetoray kan he-a, t'uymu inkutuman nan Espiritu Santo ya intupugmu nan tapen chi lakon nan lutam? ");
INSERT INTO ebk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sakbay elakom nan luta at kuk-uwam met, ya as nan nangelakwam as sa, kikiadka met challu as atum as nan lakuna. Adchi ngay ngarud t'uymu ninumnum ay mangekaman as assesa? Fiakun taku nan inkutumam ngem hi Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kun pay chinngor Ananias chaná ay kali, nunkakatuy hiya ya natu-ug. Nunsidlay ugyat nan am-in ay nanngor as nan hana. ");
INSERT INTO ebk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Angkiay ya inmuy nan fiafiallu kan Ananias, at lenekfotancha hiya. Hacha at ipitiw ay uy nangilufok. ");
INSERT INTO ebk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kun pay inmuy chi turu ay uras, enmali hi asawan Ananias ya sinungkop ay achina ammu nan enommat. ");
INSERT INTO ebk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Angkiay kenalen Pedro kan hiya, “Ifiakiam kan ha-un, ay hiyana kayong nan ustu ay lakon nan lutayu?” “O-ya hiyasa,” ensongfiat Safira. ");
INSERT INTO ebk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ngem kenalen Pedro kan hiya, “Anuyyu payat nunturakian ay hen-asawa ay manisting as nan Espiriton Apo Dios? Ilaum, nan chiyuycha nangilufok kan asawam ad kianad at hanacha as pantiw, ya uy chaká us ilufok kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nunkakatuy hi Safira ya natu-ug as nan suken Pedro. Kun pay sinungkop nan fiafiallu, ya ininchanancha ay nanatuy hi Safira, inpitiwcha ay uy nangilufok kan hiya as nan sag-un asawana. ");
INSERT INTO ebk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nunsidlay ugyat nan am-in ay omaafurot ya am-in nan tapina ay nanngor as nan enommat. ");
INSERT INTO ebk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","As nan hiyachi, ongor nan en-enat nan apostoles ay sinyar ya nakaskaschaaw as nan tataku. Tenatanud am-in nan omaafurot ay naam-among as nan makali un Fiangsar Solomon as Templo. ");
INSERT INTO ebk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Maid naturud as nan chaan enmafurot kan Jesus ay maetapi kan chicha. Ngem uray mu hiyasa, rinispitucha challu nan nauycha omaafurot. ");
INSERT INTO ebk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Enmongoongorcha us nan naetapi ay lanaraki ya fianafiai ay enmafurot kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kiapú as nan en-enat nan apostoles, nan chiyuycha munsaket at inyuy nan tataku as nan korsa, ya enpapab-ugcha as nan inyapragcha ta as nan mar-osan Pedro at paat maaiwan koma nan tapina kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nan ongoongor us ay tataku ay nurpu henan am-in ay ili ay nangliliwus ad Jerusalem at inyalicha nan chiyuycha munsaket ya nunkaanennetan, at enmammaycha am-in. ");
INSERT INTO ebk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","As nan hiyachi, nan kangatuwan ay pachi ya nan am-in ay kakadwana ay Saduceo at enmaposcha as solet. ");
INSERT INTO ebk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Isunga enpatiliwcha nan apostoles, at inpaifiarudcha chicha. ");
INSERT INTO ebk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ngem as nan lafi, enmali nan anghel Apo Dios, ya tenkafiana nan pantiw nan pagfiaruchan, at inpitiwna chicha. Kenalina kan chicha, ");
INSERT INTO ebk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Uy kayu as Templo ya ifiakiayu as nan tataku nan maepangkep as nan nauy fiarú ay fiyag.” ");
INSERT INTO ebk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Enafurot nan apostoles nan kenalina. As nan nakapis, inmuycha as Templo, ya enlapucha ay nun-isuru as nan tataku. Kun pay naaw-awni, as nan enmaliyan nan kangatuwan ay pachi ya nan kakadwana as Templo, enpaayagcha am-in nan am-in ay membron nan Sanhedrin ay chicha nan anap-apon chi Judio ya nan anam-amá ay Judio ta munmimitincha. Hacha at ifiaor nan kukuwarcha ay umuy as pagfiaruchan ay mangiyuy as nan apostoles kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ngem as nan inumchanancha as pagfiaruchan, maidcha at nan apostoles. Isunga nunfiangadcha ya enpachamagcha as nan chiyuycha membron nan Sanhedrin nan maepangkep as na. ");
INSERT INTO ebk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Kenalicha, “As nan inumchananmi, kutug ay naetotorfek nan pagfiaruchan, ya wachacha am-in nan nunkukuwarcha ay nangatakchug as nan pantiw. Ngem kunmi pay tenkafian, maid tagtakuwan as fiaruy.” ");
INSERT INTO ebk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kun pay chinngor nan kapetan nan kukuwarcha as Templo ya nan anap-apon chi papachi nan nauycha naifiakia, nalilifokancha as solet mu anan enommat as nan apostoles. ");
INSERT INTO ebk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Angkiay ya wacha at nan enmali ay nurpu as nan kawad-an nan Templo, ya kanana kan chicha, “Chumngor kayu! Nan lanaraki ay infiarudyu at wachacha as Templo ay cha mun-is-isuru as nan tataku.” ");
INSERT INTO ebk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kuncha pay chinngor sa, inmuy nan kapetan ya nan kukuwarcha ay uy nangara kan chicha. Ngem chaancha kinuyud chicha, tay umugyatcha as nan mangkiayangan nan tataku kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kuncha pay inyali nan apostoles, enpatakchugcha chicha as nan sangwanan nan Sanhedrin, ya finistikiar nan kangatuwan ay pachi chicha. ");
INSERT INTO ebk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kenalina, “Ilurugtokyu! Infilinmi met ay ustu kan chakayu ay achi kayu mun-is-isuru babaen as nan kalibfengan nan nauy ay ngachan. Ilaunyu, nunchinamag at henan intiru ay Jerusalem nan insursuruyu, ya chakami at nan uyyu pafiasorun as nangpatuy kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ngem tinumfor hi Pedro ya nan tapina ay apostoles, “Masapor hi Apo Dios nan tongparunmi, fiakun nan tataku. ");
INSERT INTO ebk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nan Apo Dios ay chinaychayaw nan kaap-uwan takú at tenakuna hi Jesus ay penatuyyu as nan nangepalansaanyu as nan koros. ");
INSERT INTO ebk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Hiya nan entag-uy Apo Dios as apét kannawana. Nunfialinuna hiya as Muntoray ya Omesarakan. Enat Apo Dios chi ta wachay chansan nan chiyuycha kianak Israel ay munfiafiawi ya mapakawan as nan fiasfiasorcha. ");
INSERT INTO ebk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Chakami nan mangepaneknek ay tit-iwa chaná. Assesa us as nan Espiritu Santo ay inchat Apo Dios as nan chiyuycha mangtongpar kan hiya.” ");
INSERT INTO ebk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kun pay chinngor nan chiyuycha membron nan Sanhedrin nan hana kenalen cha Pedro, finmungatcha as solet, ya laychuncha ay patayun nan apostoles. ");
INSERT INTO ebk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ngem wacha kan chicha nan usa ay Fariseo ay nan ngachana at Gamaliel ay mun-isursuru as Lintig ya rispituwun am-in nan tataku. Tenmakchug hiya, ya finilina nan kukuwarcha ay epapitiwcha nan apostoles as hen-omaketan. ");
INSERT INTO ebk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Angkiay ya kenalina as nan chiyuycha membron nan Sanhedrin, “Chakayu ay iib-ak ay kianak Israel, il-ilaunyu nan atunyu kan chatosa ay tataku. ");
INSERT INTO ebk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tay ad kasin, wacha hi Teudas ay nangali un usa hiya ay nangatu ay taku. Umuy as opat kiasot ay tataku nan naetapi ay inmunud kan hiya. Ngem napatuy hiya, ya am-in ay inmun-unud kan hiya at nasisiyancha, ya maid nunfianakian nan insursuruna. ");
INSERT INTO ebk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kun pay narpas sa, wacha us hi Judas ay i-Galilea as nan timpon nan munsensosan as tataku. Ongor chi nunfialinuna as pasorotna ay nangkuru as nan goberno. Uray hiya at napatuy ya nasisiyancha us nan inmun-unud kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Isunga ad wani, ifiakiak kan chakayu ay kunyu at man ukiayun chicha. O, yasa ta kikiadcha. Tay mu as nan numnum nan tataku nan nurpuwan nan chacha at-atun winnu planplanuwun, achi maturuy. ");
INSERT INTO ebk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ngem mu kan Apo Dios nan nurpuwana, achi kayu makaamis kan chicha, tay anaka ya kunyu at lawá kontraun hi Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Inyafudcha nan hana kenalen Gamaliel. Kuncha pay enpaayag kasin nan apostoles, enpasapletcha chicha. Angkiay ya finilincha chicha ay achicha kasin os-osarun nan ngachan Jesus as nan munkarkaliyancha as nan tataku, ya inlufuscha chicha. ");
INSERT INTO ebk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","As nan nanaynanan nan apostoles as nan chiyuycha membron nan Sanhedrin, nunlagsakcha, tay infilang Apo Dios chicha as maekari ay maetapi ay mun-iliwas as pannakaifiafiain kiapú kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Inurkiw ay wachacha as nan fiattaw nan Templo ya as nan tukutukún ay afong. Inturturuycha ay nangisursuru ya nangekaskasaba ay hi Jesus nan Cristo. ");
INSERT INTO ebk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","As nan nauycha ay timpu, as nan enmongoongoran nan omaafurot, nurmuy lilen nan chiyuycha Judio ay munkali as Griego as nan chiyuycha Judio ay munkali as Hebreo. Nunlili nan chiyuycha munkali as Griego, tay nan uycha eellakas at naenganuycha as nan inurkiw ay maiwarasan chi rasyon para as nan chiyuycha makasapor. ");
INSERT INTO ebk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Isunga enayakian nan apostoles nan am-in ay omaafurot ta munmimitincha. Kenalicha, “Achi ustu challu ay enganuymi ay mangekasaba as nan kalen Apo Dios ta chakami nan mangfiachang as nan eellakas. ");
INSERT INTO ebk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Isunga chakayu ay iib-a, pumili kayu as pitu ay lanaraki kan chakayu ay ammay chi kaap-apatancha ay napnu as pannakafialin nan Espiritu Santo ya kenasilib. Chicha nan chutokanmintu ay mangekaman as nan nauy ay chunu. ");
INSERT INTO ebk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mu hiyasa, kunmi yangkiay osarun nan timpumi ay munkarkararag ya mangekaskasaba as nan kalen Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nan kenalen nan apostoles at penalaylayadna nan am-in ay naamong hid-i. Pinilicha hi Esteban ay laraki ay napigsay pammatina ya napnu as pannakafialin nan Espiritu Santo ya cha Felipe, Procoro, Nicanor, Timon, Parmenas ya hi Nicolas ay Gentil ay i-Antiokia ay manguunud as nan iniili ay ukialen chi Judio. ");
INSERT INTO ebk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Angkiay ya inyuycha chicha as nan sangwanan nan apostoles ay nangekararag ya nangepatay as limacha as nan uron nan tunggal usa ay napili ta machutokancha ay mangekaman as nan nauy ay chunu. ");
INSERT INTO ebk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Isunga kaskasin nunchinamag nan kalen Apo Dios. Enmongoongorcha nan omaafurot ad Jerusalem, ya ongoongorcha us nan papachi ay enmafurot. ");
INSERT INTO ebk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Hi Esteban ay napnu as bendisyon Apo Dios ya pannakafialin nan Espiritu Santo at ongor chi nakaskaschaaw ya sinyar ay en-enatna as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ngem nan tapina ay Judio ay tatakon nan makali un Senagogan chi Nawayawayaan Ay Tataku ya nan chiyuycha Judio ay i-Cirene, i-Alejandria, i-Cilicia ya i-Asia at nakesosekcha kan Esteban. ");
INSERT INTO ebk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ngem chaancha nakasongfiat as nan kenasilib Esteban winnu nan enpakalen nan Espiritu Santo kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Isunga penasoksokancha nan tapen nan lanaraki ta pafiasoruncha hi Esteban. Kenalicha, “Chinngormi ay nunkali hiya as maifusor kan Moises ya kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","As nan hiyasa ay enatcha, linumuchay kuru as nan tataku, anap-apu ya mun-isursuru as Lintig. Angkiay tiniliwcha hi Esteban, ya inyuycha hiya as nan chiyuycha membron nan Sanhedrin. ");
INSERT INTO ebk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Enmayagcha as nunkangutum ay nangpaneknek un, “Hi tona ay taku at achina ikinak ay cha munkalikali as maifusor as nan nauy nasantowan ay Templo ya as nan Lintig Moises, ");
INSERT INTO ebk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","tay chinngormi ay kenalina un, ‘Hi Jesus ay anna ay i-Nazaret at paraw-unantu nan nauy Templo, ya sokatana am-in nan chiyuycha iniili ay ukiali ay enpatawid Moises kan chitaku.’ ” ");
INSERT INTO ebk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Am-in nan chiyuycha nangatokor as nan maam-amongan nan chiyuycha membron nan Sanhedrin at kuncha entotoongan hi Esteban, ya inilacha ay kaman lupan chi anghel nan lupana. ");
INSERT INTO ebk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Angkiay ya senarudsud nan kangatuwan ay pachi kan Esteban, “Ay tit-iwa chaná ay chacha epabpafiasor kan he-a?” ");
INSERT INTO ebk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tinumfor hi Esteban, “Chakayu ay ib-a ya am-a, chungrunyu nan ifiakiak kan chakayu. Hi Apo Dios ay machaychayaw at nunpaila kan apu takú ay Abraham as nan kawad-ana pay laing ad Mesopotamia sakbay uy makiili ad Haran. ");
INSERT INTO ebk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kenalen Apo Dios kan hiya, ‘Taynam nan ilem ya nan iib-am, ya umuyka henan luta ay epailak kan he-a.’ ");
INSERT INTO ebk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Isunga tenaynana tit-iwa nan lutan chi i-Caldeo ay nakiiliyana, ya uy nagyan ad Haran. Kun pay natuy hi amana ay entatakina, infiaor Apo Dios hiya as nan nauy luta ay umiiliyanyu ad wani. ");
INSERT INTO ebk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Maid poros enpatawid Apo Dios kan hiya hid-i as uray ak-akettuy ay luta. Ngem enkaren Apo Dios kan hiya ay ichatnantu na ay luta ay kuwaunantu ya nan chiyuycha kianakna, uray mu maid pay anakna as nan hiyachi ay nun-ekariyan Apo Dios kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nauy nan kenalen Apo Dios kan Abraham, ‘Nan chiyuycha kianakmu at magyanchantu henan lutan chi tukún, ya munfialinchantu as mafiabfiaor ya maparpalikiatchantu as opat kiasot ay tawwun. ");
INSERT INTO ebk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ngem chusaoktu nan chiyuycha umiili hid-i ay mamabfiaortu kan chicha. As nan marpasan chatosa, mak-akchantu as nan hana ay luta, ya chaychayawunak henan nauy ay lukiar.’ ” ");
INSERT INTO ebk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kenalen pay Esteban, “Inchat Apo Dios kan cha Abraham nan filin ay sugyatancha nan an-akcha ay lallaraki ay hiyasa nan sinyar nan inturag Apo Dios kan hiya. Isunga sinugyatan Abraham nan pototna ay hi Isaac as nan maekawaru ay urkiw nunlapu as nan naiyankana. Sinugyatan Isaac hi Jacob ay pototna. Assesa us nan enat Jacob as nan chiyuycha pototna ay hinpuru ya chuwa ay machaychayaw ay kaap-uwan takú. ");
INSERT INTO ebk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Nan chiyuycha kaap-uwan takú ay potot Jacob at enapsancha nan sunúdcha ay hi Jose. Enlakucha hiya ay nunfialin as mafiabfiaor ad Egipto. Ngem nawawacha hi Apo Dios kan Jose, ");
INSERT INTO ebk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ya ensarakana hiya as nan am-in ay nunliglikiatana. Inchat Apo Dios kan hiyay laing, ya nalaylaychan nan Faraon ay ari ad Egipto kan hiya. Isunga chinutokana hiya as muntoray as nan intiru ay Egipto ya mangenongnongnong us as nan am-in ay kuk-uwana. ");
INSERT INTO ebk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Angkiay ya as nan inumchanan chi fitel as nan intiru ay Egipto ya Canaan, ongor chi likiat nan tataku hid-i, ya maid omor-an nan kaap-uwan takú as kanuncha. ");
INSERT INTO ebk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kun pay chinngor Jacob ay wachay makan ad Egipto, infiaorna nan kaap-uwan takú ay lomaku as kanuncha. Hiyachi nan enmon-ona ay inmuyancha ad Egipto. ");
INSERT INTO ebk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","As nan maekadwa ay inmuyancha, enpakaammon Jose nan maepangkep as nan achorna as nan susnúdna, ya naam-ammon nan Faraon nan pamilyan Jose. ");
INSERT INTO ebk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Angkiay enpaayag Jose hi Jacob ay amana ya am-in ay pamilyan amana ay omalicha ad Egipto. Piton puru ya lemacha am-in. ");
INSERT INTO ebk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Inmuy hi Jacob ad Egipto ay hid-i nan natuyana ya nan an-akna ay kaap-uwan takú. ");
INSERT INTO ebk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nan achorcha at naiyaton ay naifiangad ad Sikem, ya inlufokcha as nan liyang ay lenakwan Abraham ad pus-uy as nan chiyuycha kianak Hamor. ");
INSERT INTO ebk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“As nan kiayud umchanan nan timpu ay ommatan nan enkaren Apo Dios kan Abraham ad pus-uy, kaskasin natapiyan nan kaap-uwan takú ad Egipto. ");
INSERT INTO ebk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nasennokat chi ari ad Egipto inkiana naesokat nan usa ay ari ay achi nangammu kan Jose. ");
INSERT INTO ebk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nan chiyuy ay ari at enallilawna ya penarpalikiatna nan kaap-uwan takú ya kun songel kan chicha. Peneletna chicha ay mangenganuy as mutuncha ta kuncha matuy. ");
INSERT INTO ebk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Hiyana nan timpu ay naiyankan Moises ay fusfusellan ay onga. Turu ay furan nan nangay-aywanan enana kan hiya as afongcha. ");
INSERT INTO ebk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kuncha pay achi maetafun hiya as afongcha, enpaiyachawwicha ya tenaynancha hiya. Ngem ininchanan nan fiafiai ay potot nan Faraon ya enpaurúgna hiya as kaman tit-iwa ay anakna. ");
INSERT INTO ebk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Naisursuruwan hi Moises as am-in ay kenasilib nan i-Egipto, ya nunfialin hiya as mafigfigfig as nan am-in ay infiagfiakiana ya en-enatna. ");
INSERT INTO ebk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kun pay nun-opat puru nan tawwuna, ninumnumna ay uy mangam-ammu as nan kakailiyana ay kianak Israel. ");
INSERT INTO ebk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","As nan inmuyana, enasporana nan usa ay kailiyana ay cha palikiatun nan i-Egipto. Inyapana kayman hiya, ya enes-angna babaen as nan nangpatuyana as nan i-Egipto. ");
INSERT INTO ebk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ka-anan Moises mu maawatan nan kakailiyana ay hiya nan osarun Apo Dios ay mangwayawaya kan chicha, ngem chaancha naawatan. ");
INSERT INTO ebk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","As nan kafikiatana, as nan nangil-ana as nan chuwa ay kakailiyana ay kianak Israel ay cha munpatuy, penachasna ay mangpakappia kan chatona ay chuwa. Kenalina, ‘Iib-a, munpachong kayu ay kianak Israel ya, anuy kayu cha munpatpatuy?’ ");
INSERT INTO ebk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ngem nan usa ay namalikiat as nan kailiyana at inturchuna hi Moises, ya kanana, ‘Anan nangchutok kayong kan he-a ay mangetoray ya mangokóm kan chakami? ");
INSERT INTO ebk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ku-unak man laychun ay patayun kan he-a ay kaman as nan nangpatuyam ad kugkia as nan usa ay i-Egipto.’ ");
INSERT INTO ebk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kun pay chinngor Moises na, lenmayaw hiya, ya nagyan ad Midian ay achawwi ay lukiar. Hid-i nan enmasaw-ana, ya nawad-an hiya as chuwa ay potot ay lanaraki. ");
INSERT INTO ebk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Kun pay inmuy chi opat puru ay tawwun, nunpaila kan hiya nan usa ay anghel as nan cha kumarkiarud ay ek-eket ay kaiw ay wacha henan disyerto as nan sag-un nan Chuntug Sinai. ");
INSERT INTO ebk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Naschaaw hi Moises as nan chiyuy inilana. Kun pay naesnop hiya ay uy mangemamad, chinngorna hi Apo Dios ay nangali kan hiya un, ");
INSERT INTO ebk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ha-un nan Dios nan kaap-uwam, nan Dios cha Abraham, Isaac, ya Jacob.’ Kun pay chinngor Moises chi, penmayagpag hiya kiapú as ugyatna, ya achina at maiturud ay mangila's chi. ");
INSERT INTO ebk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kenalen Apo Dios kan hiya, ‘Kaanum nan sapatosmu, tay nan luta ay nangatakchukiam at nasantowan. ");
INSERT INTO ebk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Inilak nan maparpalikiat ay tatakok ad Egipto, ya chinngorku nan mun-an-ananaancha kiapú as nan iliwascha. Isunga kenomsopak ay mangwayawaya kan chicha. Aka, ta ifiaorku he-a ay munfiangad ad Egipto.’ ” ");
INSERT INTO ebk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Inturuy pay Esteban, “Hi Moises ay anna nan enachen nan chiyuycha kianak Israel as nan nangaliyancha un, ‘Anan mangali un he-a nan mangetoray ya mangokóm kan chakami?’ Ngem hiya nan infiaor Apo Dios ta muntoray ya wayawayaana chicha babaen as nan fiachang nan anghel ay nunpaila kan hiya as nan cha kumarkiarud ay kaiw. ");
INSERT INTO ebk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Enpangon Moises chicha ay nak-ak ad Egipto. Ongor nan enkamkamana ay nakaskaschaaw ya sinyar ad Egipto, henan Munchachara ay Fiayfiay, ya kaman us as nan nanarcharanancha henan disyerto as opat puru ay tawwun. ");
INSERT INTO ebk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Hi Moises ay anna nan nangali as nan chiyuycha kianak Israel un, ‘Hi Apo Dios at umifiaortu kan chakayu as usa ay pomapadtu ay kaman kan ha-un ay murpu as nan kianak Israel.’ ");
INSERT INTO ebk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hi Moises nan naetatapi as nan kaap-uwan takú ay naamong henan disyerto. O, hiya nan wacha kan chicha ya nan anghel ay nunkali kan hiya henan chuntug ay Sinai. Hiya us nan nanawat as nan chiyuycha maid patingkiana ay kalen Apo Dios ay enpatawidna kan chitaku. ");
INSERT INTO ebk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ngem nan kaap-uwan takú at enachicha ay mangtongpar as nan infiagfiakian Moises kan chicha. Kuncha at chinukkian hiya, ya nan ninunumnumcha yangkiay at nan munfiangchana ad Egipto. ");
INSERT INTO ebk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kiapú ta nafiayag hi Moises henan chuntug ay Sinai, kenalicha kan Aaron ay pachicha, ‘Mun-ammaka as tapina ay didiosenmi ay mangepangu kan chakami. Nan nauy taku ay hi Moises ay nangek-ak kan chitaku ad Egipto at achi takú ammu nan enommat kan hiya.’ ");
INSERT INTO ebk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hiyachi nan timpu ay nun-ammaancha as didiosencha ay finakfiaka, nun-ichatchatoncha as nan hana ay didiosen, ya nunlagragsakcha ay nunsicha kiapú as nan enammaancha. ");
INSERT INTO ebk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ngem chinukkian Apo Dios chicha, ya inukiayna chicha ta uray ud-ay chayawuncha nan taraw ad chaya ay kaman as nan naisurat as nan liblon nan chiyuycha pomapadtu ay kanana, ‘Chakayu ay kianak Israel, ay ha-un nan enpartiyanyu as animar ya nun-ichatonanyu as opat puru ay tawwun ay nanarcharananyu henan disyerto? ");
INSERT INTO ebk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Fiakun, tay nan intitiinyu at hiya nan fiawi ay naamma as larat ay naipuy-an nan didiosenyu ay Moloc ya nan tenartaraw ay makali un Refam. Chicha nan didiosen ay enammaanyu ay chinaychayawyu. Isunga hiyana nan kiapón nan nangepak-akak kan chakayu ta umuy kayu as nan ad-achawwi mu nan Babilonia.’ ” ");
INSERT INTO ebk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Inturuy pay Esteban, “Nan kaap-uwan takú at wacha kan chicha nan fiawi ay naamma as larat henan disyerto ay mangepaila ay wacha hi Apo Dios kan chicha. Naammaan chi ay maiyunud as nan infilin Apo Dios kan Moises ya maiyunud as nan kapadpachong nan inilan Moises. ");
INSERT INTO ebk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kun pay natuy hi Moises, naesokat hi Josue ay nangepangu as nan kaap-uwan takú. Nan chiyuy fiawi ay naamma as larat ay tenawidcha at entatakincha henan luta ay sinubratcha as nan inmili hid-i ay enpak-ak Apo Dios. Nan hana fiawi ay naamma as larat at wacha inkiana as nan timpon Ari David. ");
INSERT INTO ebk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Hi David at penalaylayadna hi Apo Dios. As nan hiyachi, chinawat David kan Apo Dios mu mafialin ay mun-amma hiya as magyanan nan Dios ay chinaychayaw Jacob. ");
INSERT INTO ebk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ngem fiakun hi David nan nangamma, kun at nan pototna ay hi Solomon. ");
INSERT INTO ebk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Uray mu hiyasa, nan Kangatuwan ay hi Apo Dios at fiakun as nan chiyuycha afong ay enammaan chi tataku nan omaafongana ay kaman as nan kenalen nan usa ay pomapadtu un, ");
INSERT INTO ebk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ad chaya nan tronok, ya asna's luta nan kiakiatinak. Anan kaassenan nan afong ay ammaanyu para kan ha-un? Ay chaud nan mun-iblayak? ");
INSERT INTO ebk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ay kun fiakun ha-un nan nangamma am-in kan chatona?’ Hiyana nan kenalen Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Inturuy pay Esteban, “Nunsidlay kenasokelyu, ya nalurak kayu ay manngor as nan kalen Apo Dios! Kun kayu tit-iwa kaman as nan kaap-uwanyu ay kanayon ay mangontra as nan Espiritu Santo! ");
INSERT INTO ebk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ay wachay uray usa as nan chiyuycha pomapadtu ay chaan penalikiat nan kaap-uwanyu? Maid met. Penatuycha nan chiyuycha nangepadtu as nan omaliyan nan Nalintig. Ad wani chakayu mismu nan nangesepsep ya nangepapatuy kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Chakayu nan nang-awat as nan lintig ay nurpu kan Apo Dios babaen as nan anghelesna ad pus-uy, ngem kunyu challu chaan tenongpar.” ");
INSERT INTO ebk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kun pay chinngor nan chiyuycha membron nan Sanhedrin nan kenalen Esteban, nunngesat nan fiab-acha as fungatcha as solet kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ngem hi Esteban ay napnu as Espiritu Santo at nuntangad ad chaya, ya inilana nan kaichayawan Apo Dios ya hi Jesus ay nangatakchug as apét kannawana. ");
INSERT INTO ebk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kenalina, “Uy! Ilaunyu kay! Iilaok ay naeelwang ad chaya, ya iilaok nan Anak chi taku ay hi Jesus ay nangatakchug as nan apét kannawan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ngem kuncha at kahifufudtak ay nanangpop as ingacha. Angkiay kenamucha ay nangarufong kan hiya, ");
INSERT INTO ebk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","at inkiayadcha ay mangek-ak henan siyudad ya enlapucha ay manglomtak. Nan chiyuycha nuntistigu ay nangepafiasor kan hiya at kenaancha nan kakiaycha ya enpad-uncha as nan laraki ay nan ngachana at Saulo. ");
INSERT INTO ebk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kuncha pay cha lomlomtakun hi Esteban, nunkararag hiya. Kenalina, “Apo Jesus, awatum nan lenawak.” ");
INSERT INTO ebk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Angkiay ya nunpalintumang hiya, ya infukiawna, “Apo, achim ifilang na as fiasor kan chicha.” Kenalina chi, ya natuy. ");
INSERT INTO ebk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","As nan hiyachi, wachacha nan tapen nan manangchaychayaw kan Apo Dios ay uy nangilufok kan Esteban, ya nunsidlay tangugngugcha kiapú as nan natuyana. Hi Saulo at usa ay nangiyafud as nan nangpatuyancha kan Esteban. As nan hiyasa challu ay urkiw, nunlapu nan maparpalikiatanan as solet nan chiyuycha omaafurot ad Jerusalem. Am-in nan omaafurot hid-i at lenmayawcha ay nasisiyan henan intiru ay Judea ya Samaria omangkiay nan apostoles. ");
INSERT INTO ebk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ngem hi Saulo at enlapuna ay mamalikiat as solet as nan am-in ay omaafurot. Sinungsungkop as nan tukutukún ay afong ay nangikuyud as nan lanaraki ya fianafiai ta uyna ifiarud chicha. ");
INSERT INTO ebk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nan chiyuycha omaafurot ay nasisiyan at inmuycha henan uray ngachana ay luglukiar ay uy nangekaskasaba as nan kalen Apo Dios maepangkep kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Hi Felipe nan usa ay inmuy henan usa'y siyudad henan probinsiya ay Samaria, ya enkaskasabana nan maepangkep kan Cristo. ");
INSERT INTO ebk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","As nan nanngoran nan ongoongor ay tataku kan hiya ya nangil-ancha as nan chiyuycha nakaskaschaaw ay sinyar ay enatna, nun-us-usacha am-in ay chinumngor ay ustu as nan kenalina. ");
INSERT INTO ebk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nak-ak nan chiyuycha anennet as nan ongor ay nunkaanennetan ay cha munfugfukiaw, ya ongorcha us nan paralitiko ya nunkapilud ay enmammay. ");
INSERT INTO ebk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Isunga naragsakcha as solet nan umiili henan nauy siyudad ad Samaria. ");
INSERT INTO ebk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wacha hid-i nan usa ay taku ay nan ngachana at Simon ay somasaromangka ay nun-ekamkaman as naschaawan nan chiyuycha i-Samaria. Enpangasna pay un hiya at usa ay nakaskaschaaw ay taku. ");
INSERT INTO ebk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Am-in nan tataku hid-i uray ngachanay kasasaadcha at chinumngorcha kan hiya. Kenarkalicha, “Hi tona ay taku at makali un Amud ay Pannakafialin Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","O, chinumngorcha ay ustu kan hiya, tay nafiayag ay penaschaawna nan tataku babaen as nan nunsarsaromangkaana. ");
INSERT INTO ebk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ngem kuncha pay enafurot nan enkasaban Felipe ay Ammay ay Chamag maepangkep henan muntorayan Apo Dios ya maepangkep kan Jesu Cristo, nunpafunyagcha, lanaraki ya fianafiai. ");
INSERT INTO ebk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Uray us hi Simon at enmafurot. Kun pay narpas ay nafunyakian hiya, inturturuyna ay inmunud kan Felipe. Naschaaw hiya as nan inilana ay nakaskaschaaw ay sinyar ya milagro ay en-enat Felipe. ");
INSERT INTO ebk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kun pay chinngor nan apostoles ad Jerusalem ay enafurot nan chiyuycha i-Samaria nan kalen Apo Dios, infiaorcha cha Pedro kan Juan ay umuy kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","As nan inumchanancha hid-i, enkararakiancha nan chiyuycha omaafurot ta awatuncha koma nan Espiritu Santo, ");
INSERT INTO ebk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","tay chaan pay enmali nan Espiritu Santo as nan uray usa kan chicha. Nafunyakiancha yangkiay as nan ngachan Apo Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Angkiay ya as nan nangepatayan cha Pedro kan Juan as nan limacha as nan chiyuycha omaafurot, enawatcha nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kun pay inilan Simon ay inchat Apo Dios nan Espiritu Santo babaen as nan nangepatayan nan apostoles as limacha as nan chiyuycha omaafurot, inchawchawnay siping kan cha Pedro kan Juan. ");
INSERT INTO ebk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Chinawat Simon kan chicha, “Ichatyu man paat na ay pannakafialin kan ha-un ta mu ngachana nan mangepatayak as limak at urum ya maawatna nan Espiritu Santo.” ");
INSERT INTO ebk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ngem tinumfor hi Pedro kan hiya, “Maetapi koma nan sipingmu kan he-a ay mapuoran ad inferno, tay kunmu ka-anan un malakwan chi siping nan ichat Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maid fiyangmu as nan chunumi, tay achi ustu nan numnummu as nan mangiilan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Isunga munfiafiawika as nan mangotettet ay ninumnummu, ya munkararagka kan Apo Dios ta mu mafialin koma at pakawanun chaká as nan hana mangotettet ay pangkepmu. ");
INSERT INTO ebk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tay nan mailak at nangapposka as solet ya kamanka nafiafiarud babaen as nan fiasormu.” ");
INSERT INTO ebk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Angkiay ya tinumfor hi Simon, “Ekararakianak man paat as nan Apo ta achi challu maekaman kan ha-un nan kenaliyu.” ");
INSERT INTO ebk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kun pay lenpas cha Pedro kan Juan ay nangepaneknek as nan maepangkep kan Jesus ya nangekasaba as nan kalen Apo Dios, nunfiangadcha ad Jerusalem. As nan chacha marmar-osan henan ongor ay fiabruy ad Samaria, enkaskasabacha nan Ammay ay Chamag. ");
INSERT INTO ebk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","As nan hiyachi, nunpaila kan Felipe nan usa ay anghel Apo Dios, ya kanana kan hiya, “Maligwatka, ya umuyka as apét filáng, as nan korsa ay murpu ad Jerusalem ya muntoróng ad Gaza.” Nan nauy ay korsa at muntoróng henan disyerto. ");
INSERT INTO ebk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Naligwat hiya, ya inmuy as nan korsa ay ansa. As nan chana umuyan, sinib-atna nan i-Etiopia ay yunuku. Hi tona at usa ay mafigfigfig ay opisyar ay mangenongnongnong as nan am-in ay kuk-uwan nan reyna ad Etiopia ay makali un Candace. Nurpu hiya ad Jerusalem ay uy nunchayaw kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nunlurukian hiya as nan kalesana ay munfiangad as ilina ya cha munfiasfiasa as nan insurat Isaias ay pomapadtu. ");
INSERT INTO ebk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","As nan hiyachi, kenalen nan Espiritu Santo kan Felipe, “Uyka. Maesnopka as nan hana nunlurukian as nan kalesa.” ");
INSERT INTO ebk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Natannagtag hi Felipe ay naesnop, ya chinngorna ay cha fiasfiasaun nan opisyar nan insurat Isaias ay pomapadtu. Angkiay ya senarudsud Felipe kan hiya, “Ay maawatam nan cham fiasfiasaun?” ");
INSERT INTO ebk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Achek mampay maawatan sukúd kun wachay mangelawlawag kan ha-un,” ensongfiat nan opisyar. Angkiay ya enayakiana hi Felipe ay makilukian kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nan chana fiasfiasaun ay naisurat as nan Kalen Apo Dios at hiyana: “Maepachong hiya as nan karnero ay cha maiyuy ay maparti, winnu maepachong as nan kordero ay kun kinkinak uray cha mapukisan nan chotchotna. Maid poros kankanana. ");
INSERT INTO ebk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","As nan naifiafiainana, nakaan nan kalibfengana ay maokóm. Anan makaifiakia as nan maepangkep as nan kianakna, tay napapug at met nan fiyagna asna's luta?” ");
INSERT INTO ebk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kenalen nan yunuku kan Felipe, “Ifiakiam pay kan ha-un mu anan cha mangaliyan nan pomapadtu as na? Ay maepangkep kan hiya mismu winnu maepangkep as nan tukún ay taku?” ");
INSERT INTO ebk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Angkiay ya enlapon Felipe ay munkali nunlapu as nan naisurat as nan Kalen Apo Dios ay finasan nan yunuku, ya enlawlawagna kan hiya nan Ammay ay Chamag maepangkep kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kuncha pay inturturuy ay nanarcharan as nan korsa, inumchancha as nan kawad-an nan chanum. Kenalen nan yunuku, “Ilaum! Nauy chi chanum, anan mangepawa as ok mafunyakianan?” ");
INSERT INTO ebk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Kenalen Felipe kan hiya, “Mafialinka ay mafunyakian mu as nan am-in ay numnummu at omafurotka.” Tinumfor nan yunuku, “Afurotok ay hi Jesu Cristo nan anak Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Enpakinak nan yunuku nan kalesa ay nunlurukianancha, ya kenomsopcha ay chuwa as nan chanum, at finunyakian Felipe hiya. ");
INSERT INTO ebk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kuncha pay tenmakchang as nan chanum, enek-ak nan Espiriton Apo Dios hi Felipe. Chaan kasin inil-ilan nan yunuku hiya, ngem naragsak nan yunuku ay nangituruy ay inmuy as ay-ayana. ");
INSERT INTO ebk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kun pay hi Felipe at naammuwana ay kalina at ya wacha hiya payat ad Azoto. As nan hiyachi, inmuy ad Cesarea, ya as nan chinmag-osana henan am-in ay ili ay maraosana at enkaskasabana nan Ammay ay Chamag. ");
INSERT INTO ebk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","As nan hana ay timpu ay enommatan chatona, inturturuy Saulo ay nangug-ugyat ay mangpatuy as nan chiyuycha omaafurot. Isunga inmuy hiya as nan kangatuwan ay pachi ");
INSERT INTO ebk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ta chumawat as sursurat ay pammarufus ay iyuyna as nan anap-apu as nan chiyuycha senagoga henan siyudad ay Damasco. Hiyasa nan atuna ta mu kay wachay mad-anana as lanaraki winnu fianafiai ay cha omab-afurot as nan makali un Charan Apo Jesus at wachantuy kalibfengana ay mangtiliw kan chicha ay uy mangifiarud ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","As nan kiayud umchanan Saulo ad Damasco, kalina at ya nachiyat chi silaw ay nurpu ad chaya ay nangliwus kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natu-ug hi Saulo as nan luta ya chinngorna nan kali ay nangali kan hiya, “Saulo, Saulo, adchi t'uyak palikiatun?” ");
INSERT INTO ebk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Ngachanmu Apo?” senarudsud Saulo. Tinumfor nan Apo, “Ha-un hi Jesus ay cham parpalikiatun. ");
INSERT INTO ebk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tomakchugka, ya umuyka henan siyudad, at wacha hid-i nan mangifiakia kan he-a as nan masapor ay atum.” ");
INSERT INTO ebk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nan chiyuycha kakadwan Saulo at kuncha nasngang as nan nanngorancha as nan kali ngem maid inilacha as taku. ");
INSERT INTO ebk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Naligwat hi Saulo as nan luta, ya as nan nanglitakiana as nan matana, achi poros makaila. Isunga kuncha penapachang ay nangiyuy kan hiya ad Damasco. ");
INSERT INTO ebk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","As nan turu ay urkiw at achi makaila hiya. Chaan pay nangnangan ya chaan inmig-ikop. ");
INSERT INTO ebk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wacha nan usa ay omaafurot ad Damasco ay nan ngachana at Ananias. Nunkali hi Apo Jesus kan hiya babaen as nan kaman iitaw ya kanana, “Ananias!” “Nauyak Apo,” ensongfiatna. ");
INSERT INTO ebk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kenalen nan Apo kan hiya, “Maligwatka, ya umuyka as nan korsa ay makali un Lutug. Sarudsuchum as nan chiyuycha wacha as afong Judas nan i-Tarso ay nan ngachana at Saulo, tay wacha hid-i ay cha munkarkararag. ");
INSERT INTO ebk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Babaen as nan kaman iitaw, inilana ay cha sungkop nan laraki ay nan ngachana at Ananias, ya chana epatay nan limana kan hiya ta makaila kasin.” ");
INSERT INTO ebk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ngem tinumfor hi Ananias, “Apo, ongor met chi nachamagku as nan tataku maepangkep kan tona ay taku ya maepangkep as nan am-in ay en-enatna ay kauugyat as nan tatakom ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ad wani, enmali hiya hena ad Damasco ay wachay pammarufusna ay nurpu as nan anap-apon chi papachi ad Jerusalem ta mafialina ay tiliwun nan am-in ay munchaychayaw kan he-a.” ");
INSERT INTO ebk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ngem kenalen nan Apo kan Ananias, “Uyka, tay pinilek hiya as fiabfiaarok ay uy mangepakaammu as nan ngachanku as nan chiyuycha Gentil, as nan ar-ari, ya as nan chiyuycha kianak Israel. ");
INSERT INTO ebk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ha-un mismu nan mangepaila kan hiya as nan ongor ay iliwasna as nan mangepakaammuwana as nan ngachanku.” ");
INSERT INTO ebk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Isunga inmuy hi Ananias as nan afong ay kawad-an Saulo, at enpatayna nan limana kan hiya, ya kanana, “Ifiak ay Saulo, hi Apo Jesus ay nunpaila kan he-a as nan cham omaliyan hena nan nangifiaor kan ha-un ta kasinka makaila, ya mapnuka as Espiritu Santo.” ");
INSERT INTO ebk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hiya at chi ya nag-as nan kaman seksek as matan Saulo, ya kasin makaila hiya. Angkiay naligwat hiya ya nafunyakian. ");
INSERT INTO ebk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kun pay narpas chaná, uy nangan, ya finmikas kasin. As nan kaat ay urkiw, nakepagyan hi Saulo as nan chiyuycha omaafurot ad Damasco. ");
INSERT INTO ebk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Hiya at chi ya inmuy as nan chiyuycha senagoga ay nangelapu ay mangekasaba ay hi Jesus at Anak Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Am-in nan chinumngor kan hiya at naschaawcha. Waschi un senarudsudna, “Ay fiakun challu hi tona nan laraki ay namarpalikiat as nan chiyuycha munchaychayaw kan Jesus ad Jerusalem? Ay fiakun nan enmaliyana hena at ta uyna tiliwun nan omaafurot ay mangepafiangad as nan anap-apon chi papachi hid-i?” ");
INSERT INTO ebk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ngem kaskasin napapigsa hi Saulo ay nun-ekasaba ya makaawis as solet nan enatna ay nangepaneknek ay hi Jesus nan Cristo. Isunga achi poros makasongfiat nan chiyuycha Judio ay umiili ad Damasco. ");
INSERT INTO ebk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kun pay inmuy chi kaat ay timpu, plenanon nan chiyuycha Judio mu anan atuncha ay mangpatuy kan Saulo. ");
INSERT INTO ebk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Inurkiw ya lenafi ay ensasanubcha hiya as nan am-in ay sungkopan henan siyudad ta patayuncha hiya mu mak-ak. Ngem naammuwan Saulo nan planucha kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ngem as nan henlafi, nan iib-ana ay omaafurot at inittucha hiya as nan tekles ay tenaliyancha, ya inuy-uycha hiya as nan nangatu ay tuping nan siyudad ta lomayaw. ");
INSERT INTO ebk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kun pay inumchan hi Saulo ad Jerusalem, penachasna ay maetapi as nan chiyuycha omaafurot, ngem inmugyatcha am-in kan hiya, tay achicha afurotun ay usa us hiya ay tit-iwa ay omaafurot. ");
INSERT INTO ebk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ngem uy finadngan Bernabe hiya ya kenadwaana hiya ay inmuy as nan apostoles. Infiakiana kan chicha nan enat Saulo ay nangila as nan Apo as nan korsa ad Damasco ya nan nunkaliyan nan Apo kan hiya. Infiakiana us nan kenaturud Saulo ay nangekaskasaba as nan maepangkep kan Jesus ad Damasco. ");
INSERT INTO ebk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kiapú ta assid-i, nakekadkadwa hi Saulo kan chicha ad Jerusalem, ya naturud hiya ay uy nangekaskasaba as nan maepangkep kan Apo Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nakekali ya nakesosek hiya as nan chiyuycha Judio ay munkali as Griego, ngem kuncha at anapun chi atuncha ay mangpatuy kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kun pay naammuwan nan iib-a ay omaafurot sa, inturudcha hi Saulo ay chinmayyu ad Cesarea, at infiaorcha hiya ad Tarso. ");
INSERT INTO ebk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","As nan hiyachi, nakyat nan maparpalikiatanan nan chiyuycha iglesia henan intiru ay probinsiya ay Judea, Galilea ya Samaria. Pinmigsa nan pammaticha ya naawischa babaen as nan namadfiadngan nan Espiritu Santo kan chicha. Enmongoongorcha nan omaafurot ya inturuycha ay nunchaychayaw as nan Apo as nan panagfiyagcha. ");
INSERT INTO ebk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kun pay hi Pedro at cha munfiabfiaat henan tukutukún ay lukiar ay kawad-an nan tatakon Apo Dios. As nan namingsan, uyna finisita nan tatakon Apo Dios ad Lidda. ");
INSERT INTO ebk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Inilana hid-i nan usa ay laraki ay nan ngachana at Eneas. Hiya at kun u-uumfug as nan ufugna as waru ay tawwun, tay naparalitiko. ");
INSERT INTO ebk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kenalen Pedro kan hiya, “Eneas, paammayun chaká kan Jesu Cristo. Fumangunka ya lekopum nan apragmu.” Hiya at chi ya finmangun hi Eneas. ");
INSERT INTO ebk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","As nan nangil-an nan am-in ay inmiili ad Lidda ya Sarona as nan enommat kan Eneas, enmafurotcha kan Apo Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ad Joppe, wacha nan fiafiai ay nan ngachana at Tabita ay usa ay omaafurot. Nan ngachana as nan kalen chi Griego at Dorcas ay nan laychuna ay kanan at ugsa. Kanayona ay atun chi ammay ya fiadngana nan chiyuycha pugli. ");
INSERT INTO ebk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","As nan hana ay timpu ay kawad-an Pedro ad Lidda, nunsaket hi Tabita, at natuy. Angkiay ya kuncha pay inmus hiya, enpab-ugcha as nan nunngangatu ay kuwartu. ");
INSERT INTO ebk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kiapú ta nan ili ay Lidda at achi achawwi ad Joppe, as nan nanngoran nan chiyuycha omaafurot ay wacha hi Pedro ad Lidda, inmifiaorcha as chuwa ay lanaraki ay uy munpakaasi kan hiya. As nan inumchanancha, kenalicha, “Pangaasem ta kamuwum ay makeali kan chakami ad Joppe.” ");
INSERT INTO ebk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Isunga nunkaliligwat hi Pedro ya nakiuy kan chicha. Kuncha pay inumchan, enpangucha hiya as nan nunngangatu ay kuwartu. Am-in nan eellakas at enarufongcha hi Pedro. Chacha mun-ag-akor ya chacha epaila kan hiya nan chiyuycha kamisita ya tapen chi kakiay ay enammaan Dorcas as nan natatakuwana. ");
INSERT INTO ebk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ngem enpapitiw Pedro chicha am-in as nan kuwartu, at nunpalintumang hiya ya nunkararag. Angkiay ya nunsakong hiya as nan natuy, ya kanana, “Tabita, fumangunka.” Hiya at chi ya nunlitag hi Tabita. Kuna pay inila hi Pedro, finmangun ya tenmokor. ");
INSERT INTO ebk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Inunnan Pedro nan limana, ya finadngana hiya ay tomakchug. Angkiay ya enayakiana nan chiyuycha ellakas ya nan tapina ay kakadwacha ay omaafurot, ya enpailana kan chicha hi Dorcas ay nataku. ");
INSERT INTO ebk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nan nauy ay chamag at naammuwan henan intiru ay Joppe, ya ongorcha nan enmafurot kan Apo Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nagyan hi Pedro ad Joppe as ongor ay urkiw as nan afong Simon ay mun-am-amma as larat. ");
INSERT INTO ebk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Wacha ad Cesarea nan usa ay laraki ay nan ngachana at Cornelio ay kapetan chi hinkiasot ay sosorchachu. Nan nauy ay bunggoyna at makali un “Italiana ay Sosorchachu”. ");
INSERT INTO ebk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Uray Gentil hiya at relihiyoso challu, ya munchaychayaw hiya kan Apo Dios patí nan pamilyana. Ongor us chi en-enatna ay finmachang as nan chiyuycha Judio ay pugli, ya kanayon hiya ay munkararag kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","As nan usa ay makiayud as nan kiayud alas tres, babaen as nan kaman iitaw, inilana nan usa ay anghel Apo Dios ay sinungkop as nan kawad-ana, ya kanana kan hiya, “Cornelio.” ");
INSERT INTO ebk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Entotoongan Cornelio nan anghel as ugyatna as solet, ya kanana, “Apo, ngachanay ifiakiam?” Tinumfor nan anghel, “Nalaylaychan hi Apo Dios as nan chiyuycha kararagmu ya as nan ongor ay fiachangmu as nan pugli. Enawat at Apo Dios chasa ay kamanmu chaton kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ad wani umifiaorka as lanaraki ay umuy ad Joppe ay uy mangayag kan Simon ay nan usa ay ngachana at Pedro. ");
INSERT INTO ebk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Hiya nan mangili as afong Simon ay mun-am-amma as larat ay wacha henan olet nan fiayfiay.” ");
INSERT INTO ebk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kun pay nak-ak nan anghel, enayakian Cornelio nan chuwa as nan chiyuycha mafiabfiaor ya usa ay relihiyoso ay sorchachu ay usa as nan fumadfiachang kan hiya mismu, ");
INSERT INTO ebk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","at infiakiana kan chicha nan am-in ay enommat. Hana at ifiaor chicha ay umuy ad Joppe. ");
INSERT INTO ebk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","As nan kafikiatana as nan kiayud munkiawa, chacha manarcharan ay maesnop ad Joppe. As nan hiyachi challu ay uras, inmuy hi Pedro as nan nuntatapor ay tabfongan nan afong ay uyna munkararakian. ");
INSERT INTO ebk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kun pay naaw-awni, nunchukiaang hi Pedro, ya laychuna ay mangan. Ngem as nan cha mangesakianaan nan tapina as makan, wacha nan enpailan Apo Dios kan hiya babaen as nan kaman iitaw. ");
INSERT INTO ebk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Inilana ad chaya ay naelwang, ya cha mauy-uy asna's luta nan kaman afilug ay urus ay nasisiluwan nan opat ay sulina. ");
INSERT INTO ebk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nan naiittu as nan urus ay anchi at am-in ay tukutukún ay animar, chiyuycha munkadkachap asna's luta ya chiyuycha kossel. ");
INSERT INTO ebk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","As nan hiyachi, wacha nan nangali kan hiya, “Pedro, maligwatka. Pomartika as nan hanacha ya kanum.” ");
INSERT INTO ebk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ngem kenalen Pedro, “Annaw pay, Apo! Maid met kenkenanku as paniyiwun nan lintigmi ay Judio winnu kenkenanku ay naifilang as achi nacharos.” ");
INSERT INTO ebk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kasin kenalen nan kali kan hiya, “Nan infilang Apo Dios as nacharos at achim paniyiwun.” ");
INSERT INTO ebk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Namitlu ay enommat sa, at narab-et nan chiyuy urus ad chaya. ");
INSERT INTO ebk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","As nan cha mangnumnumnuman Pedro as nan inilana mu anan laychun tud-i ay kanan, naanapan nan laraki ay finaor Cornelio nan afong Simon, ya nangatakchugcha as nan sugpan. ");
INSERT INTO ebk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nunfukiawcha ay nanarudsud, “Ay wachay mangiliyu hena ay nan ngachana at Simon, ya nan usa pay ay ngachana at Pedro?” ");
INSERT INTO ebk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kun pay kutug ay cha numnumnumun Pedro nan enpailan Apo Dios kan hiya, kenalen nan Espiritu Santo kan hiya, “Wachacha nan turu ay lanaraki ay cha manganap kan he-a. ");
INSERT INTO ebk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Maligwatka ya chumayyuka. Achika mun-ad-achi ay makiuy kan chicha, tay ha-un nan nangifiaor kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hiya at chi ya chinmayyu hi Pedro, ya kanana as nan lanaraki, “Ha-un nan chayu anapun. Ngachana man paat nan pangkepyu ay enmali hena?” ");
INSERT INTO ebk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Finaor chakami kan Kapetan Cornelio,” ensongfiatcha kan Pedro. “Hiya at usa ay nalintig ay taku ya manangchaychayaw kan Apo Dios. Ammay us nan kaap-apatana as nan am-in ay tataku ay Judio. Nan usa ay anghel Apo Dios at infiakiana kan hiya babaen as nan kaman iitaw ay epaayag chaká as afongna ta chungruna nan maifiakiam.” ");
INSERT INTO ebk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Isunga enpaskop ya menangilen Pedro chicha. As nan kafikiatana, nunligwat hiya, ya nakiuy kan chicha ay kadwana nan tapina ay omaafurot ay i-Joppe. ");
INSERT INTO ebk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","As nan somarunu ay urkiw, inumchancha ad Cesarea. Cha sassasad-un Cornelio chicha as afongna ay kadwana nan enayakiana ay iib-ana ya kiakiayyumna. ");
INSERT INTO ebk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kun pay sinungkop hi Pedro as nan hana ay afong, sinib-at at Cornelio hiya ya nunpalintumang as nan sukina ay mangchayaw kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ngem nun-epatakchug Pedro hiya, ya kanana, “Tomakchugka, tay kunak us lawá taku.” ");
INSERT INTO ebk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","As nan cha muntagtakiatforan cha Pedro kan Cornelio ay sungkop as fiaruy, inilan Pedro nan ongor ay tataku ay naaamong. ");
INSERT INTO ebk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kenalina kan chicha, “Chakayu ay mismu at aammuyu ay paniyiwun nan lintigmi ay Judio nan makekadkadwaanmi as nan Gentil winnu uymi mangfisitaan kan chicha. Ngem enpailan Apo Dios kan ha-un ay achek challu paniyiwun ay makekadkadwa as nan uray ngachana ay taku. ");
INSERT INTO ebk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Isunga as nan nangepaayakianyu kan ha-un, chaanak nun-ad-achi ay nakeali. Ad wani, sarudsuchok man paat kan chakayu mu adchi t'uyak enpaayag.” ");
INSERT INTO ebk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tinumfor hi Cornelio, “Ad ossanchi as nan assena ay alas tres as nan makiayud, as nan chak munkarkararakian as afongku, kalina at ya wacha nan usa ay laraki ay nangatakchug as nan sangwanak ay mun-aliling chi fiachuna. ");
INSERT INTO ebk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kenalina kan ha-un un, ‘Cornelio, chinngor Apo Dios nan kararagmu, ya manunumnumna nan infiadfiachangmu as nan chiyuycha pugli. ");
INSERT INTO ebk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Umifiaorka as umuy ad Joppe ay uy mangayag kan Simon ay nan usa ay ngachana at Pedro. Hiya nan mangili as afong Simon ay mun-am-amma as larat ay wacha henan olet nan fiayfiay.’ ");
INSERT INTO ebk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hiyana nan kiapúna ay as nan hiyachi challu ay timpu at enpaayagku he-a. Ammay met, tay enanosam ay enmali. Ad wani, nauy kami am-in hena as nan sangwanan Apo Dios ay manngor as nan am-in ay infilina kan he-a ay epakaammom kan chakami.” ");
INSERT INTO ebk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Angkiay kenalen Pedro, “Tit-iwa ay maawatak ad wani ay hi Apo Dios at mapapchong nan atuna as nan am-in ay tataku. ");
INSERT INTO ebk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tay henan tunggal nasyon, nan ngachana ay manangchaychayaw kan hiya ya atuna nan nalintig at awatun Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ammuyu met nan chamag ay enpakaammon Apo Dios as nan chiyuycha kianak Israel. Hiyachi nan Ammay ay Chamag ay maekaskasaba ta mafialin ay makekappia nan taku kan Apo Dios babaen kan Jesu Cristo ay Apon am-in chi tataku. ");
INSERT INTO ebk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nachamagyu at nan enommat henan intiru ay probinsiya ay Judea manipud ad Galilea as nan nunlopasan Juan ay nangekaskasaba as nan maepangkep as funyag. ");
INSERT INTO ebk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ammuyu us nan enat Apo Dios ay nangichat kan Jesus ay i-Nazaret as Espiritu Santo ya pannakafialin. O, ammuyu nan enat Jesus ay as nan uray ngachana ay enay-ayana at enkamkamanay ammay, enpappaammayna nan am-in ay tataku ay penarpalikiat Satanas, tay wacha hi Apo Dios kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Chakami nan mangepaneknek as nan am-in ay en-enatna ad Jerusalem ya henan intiru ay Judea. Penatuycha hiya as nan nangepalansaancha as nan koros. ");
INSERT INTO ebk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ngem tenakon Apo Dios hiya manipud as nan utúy as nan maekatlu ay urkiw, ya enpailana hiya kan chakami. ");
INSERT INTO ebk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Chaana enpaila hiya as nan am-in ay tataku, ngem kan chakami yangkiay ay pinilen Apo Dios ay mangepaneknek as nan inilami. Tay chakami at nakekkekan ya nakiig-ikop kami kan hiya as nan natakuwana manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Finilin Apo Jesus chakami ay uy mangekasaba as nan Ammay ay Chamag as nan tataku ya uy mangepaneknek ay hiya nan pinilen Apo Dios ay mangokóm as nan am-in ay matataku ya nunkatuy. ");
INSERT INTO ebk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nan maepangkep kan Jesus nan paneknekan am-in nan pomapadtu as nan insuratcha ay nan am-in ay omafurot kan hiya at mapakawancha as nan fiasfiasorcha kiapú as nan enat Jesus.” ");
INSERT INTO ebk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kun pay kutug ay cha munkarkali hi Pedro, kalina at ya kenomsop ay sinungkop nan Espiritu Santo as nan am-in ay chuchumngor. ");
INSERT INTO ebk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Naschaaw nan chiyuycha omaafurot ay Judio ay nakiuy kan Pedro, tay inchat Apo Dios nan Espiritu Santo ta mawawacha uray as nan chiyuycha Gentil. ");
INSERT INTO ebk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tay chinngorcha ay chacha munkarkali as tanuktukún ay kali ay epakalen nan Espiritu Santo ya chacha munchaychayaw kan Apo Dios. Angkiay kenalen Pedro, ");
INSERT INTO ebk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Enha! Ay wachay mangepawa kan chicha as uycha mafunyakianan as chanum? Chatona ay tataku at enawatcha nan Espiritu Santo ay kaman kan chitaku.” ");
INSERT INTO ebk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","As nan hiyachi, finilina cha Cornelio ay mafunyakiancha ay mangepaila ay hi Jesu Cristo nan Apocha. Angkiay ya chinawatcha kan Pedro un mayaschi hiya kan chicha as kaat ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","As nan hiyachi, nan apostoles ya nan chiyuycha omaafurot ad Judea at chinngorcha ay enawat us nan chiyuycha Gentil nan kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","As nan enmabratan Pedro ad Jerusalem, nan chiyuycha Judio ay mangun-unud as nan panagsugyat at ensotcha hiya. ");
INSERT INTO ebk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Kenalicha, “Nunsidlaka! Inmuyka met as nan chiyuycha chaan nasugyatan ay Gentil, ya nakekanka pay kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Angkiay ya enlapon Pedro ay nangetot-orpang ay nangifiakia kan chicha as nan am-in ay enommat. ");
INSERT INTO ebk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Kenalina, “As nan kawad-ak henan siyudad ay Joppe, as nan chak munkarkararakian, wacha nan kaman iitaw ay enpailan Apo Dios kan ha-un. Inilak nan cha mauy-uy ay nurpu ad chaya ay kaman afilug ay urus ay nasisiluwan nan opat ay sulina ya naesaad as nan kawad-ak. ");
INSERT INTO ebk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Enmamadku ay nangila mu anan naittu as nan urus ay anchi, ya inilak chi tukutukún ay tarakon ya atap ay animar, chiyuycha munkadkachap asna's luta ya chiyuycha kossel. ");
INSERT INTO ebk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Angkiay chinngorku nan kali ay cha mangali kan ha-un un, ‘Pedro, maligwatka. Pomartika as nan hanacha ya kanum.’ ");
INSERT INTO ebk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ngem kenalek un, ‘Annaw pay, Apo! Maid met kenkenanku as paniyiwun nan lintigmi ay Judio winnu kenkenanku as naifilang as achi nacharos.’ ");
INSERT INTO ebk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ngem kasin tinumfor nan kali ay nurpu ad chaya. Kenalina un, ‘Nan infilang Apo Dios as nacharos at achim paniyiwun.’ ");
INSERT INTO ebk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Namitlu ay enommat sa, at narab-et chachi am-in ad chaya. ");
INSERT INTO ebk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“As nan hiyachi challu ay timpu, nan turu ay lanaraki ay naifiaor ay nurpu ad Cesarea ay uy mangayag kan ha-un at inumchancha as nan afong ay chinmawusak. ");
INSERT INTO ebk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Infiakian nan Espiritu Santo kan ha-un ay achiyak mun-ad-achi ay makiuy kan chicha. Nan nauycha unum ay iib-a ay omaafurot ay i-Joppe at nakealicha kan ha-un ad Cesarea, at sinungkop kami am-in as afong Cornelio. ");
INSERT INTO ebk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Infiakian Cornelio kan chakami nan enatna ay nangila as nan anghel ay nangatakchug as afongna ay nangali kan hiya un, ‘Umifiaorka as umuy ad Joppe ay uy mangayag kan Simon ay nan usa ay ngachana at Pedro. ");
INSERT INTO ebk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hiya nan mangifiakia as nan chamag kan chakayu ay hiyasa nan maesarakanamtu ya nan pamilyam.’ ");
INSERT INTO ebk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kunku pay enlapu ay nunkali, kenomsop ay sinungkop nan Espiritu Santo kan chicha ay kaman as nan sinungkopana kan chitaku as nan laplapuna. ");
INSERT INTO ebk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Angkiay ninumnumku nan kenalen Apo Jesus un, ‘Hi Juan at funyakiana nan tataku as chanum, ngem mafunyakian kayuntu as Espiritu Santo.’ ");
INSERT INTO ebk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ad wani ngarud, mu munpachong nan inchat Apo Dios kan chicha ay Gentil as nan inchatna kan chitaku as nan enmafurotan takú kan Apo Jesu Cristo, anan ngachanku paat ay mangepawa kan Apo Dios as atuna?” ");
INSERT INTO ebk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kuncha pay chinngor na, inkinakcha ay nangsot kan hiya, ya chinaychayawcha hi Apo Dios. Kenalicha, “Uray as nan chiyuycha Gentil at inchat Apo Dios nan chansacha ay munfiafiawi ta mawad-ancha as fiyag ay maid patingkiana.” ");
INSERT INTO ebk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","As nan hiyachi, nan chiyuycha omaafurot ay nasisiyan kiapú as nan naparpalikiatanancha ay linmun nan napatuyan Esteban at nunfiaatcha inkiana ad Fenicia, Chipre ya Antiokia. Chacha ifiagfiakia nan kalen Apo Dios as nan chiyuycha Judio yangkiay. ");
INSERT INTO ebk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ngem wachacha nan tapina kan chicha ay lanaraki ay i-Chipre ya i-Cirene ay inmuy ad Antiokia. As nan chiyuycha Gentil nan nangelapuwancha ay nangifiagfiakia ya nangekaskasaba as nan Ammay ay Chamag maepangkep kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kiapú ta wacha nan pannakafialin Apo Dios kan chicha, ongoongorcha nan tataku ay enmafurot ya nuntalek kan Apo Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kun pay nachamag nan iglesia ad Jerusalem ay enmafurot nan chiyuycha i-Antiokia, finaorcha hi Bernabe ay umuy ad Antiokia. ");
INSERT INTO ebk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","As nan inumchanana ya nangil-ana as nan bendisyon Apo Dios kan chicha, naragsakan hiya. Tinukutukuna chicha am-in ay mangiturturuy ay omafurot kan Apo Jesus as nan am-in ay numnumcha. ");
INSERT INTO ebk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Hi Bernabe at ammay ay taku, napnu as Espiritu Santo, ya napigsa nan pammatina. Isunga enmongoongor nan tataku ay naetapi kan chicha ay enmafurot as nan Apo. ");
INSERT INTO ebk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Angkiay ya inmuy hi Bernabe ad Tarso ay uy manganap kan Saulo. ");
INSERT INTO ebk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kuna pay ininchanan hiya, entakina hiya ad Antiokia. Kun pay makatawwuncha hid-i, nakekadkadwacha as nan chiyuycha omaafurot, ya insursuruwancha nan ongoongor ay tataku. Ad Antiokia nan enmon-ona ay nangadnanan nan chiyuycha omaafurot as Cristiano. ");
INSERT INTO ebk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","As nan hiyachi ay timpu, wachacha nan tapen nan pomapadtu ay nurpu ad Jerusalem ay inmuy ad Antiokia. ");
INSERT INTO ebk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nan usa kan chicha at hi Agabo. Tenmakchug hiya as nan naamongan nan chiyuycha omaafurot, ya enpaepadton nan Espiritu Santo kan hiya ay omalintuy usa ay nunsidla ay fitel henan intiru ay luta. (Enommat na tit-iwa as nan nuntotorayan Emperador Claudio.) ");
INSERT INTO ebk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Isunga nan chiyuycha omaafurot ad Antiokia at nuntuturagcha ay omepaw-et as ifiachangcha ay maiyunud as nan kafiaelan nan tunggal usa para as nan iib-acha ay omaafurot ay umiili ad Judea. ");
INSERT INTO ebk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Enpaw-etcha na tit-iwa kan cha Bernabe kan Saulo ay nangiyuy as nan chiyuycha mangepangpanguru as nan omaafurot ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","As nan hiyasa us ay timpu, enlapon Ari Herodes ay namalikiat as nan tapen nan omaafurot. ");
INSERT INTO ebk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Enpasiwatna nan uron Santiago ay sunúd Juan. ");
INSERT INTO ebk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kuna pay inila ay nalaylaychan nan chiyuycha Judio as nan nauy enatna, insubratna ay mangepatiliw us kan Pedro. Enommat na as nan makali un Fiastan chi Tenapay ay Maid Lebadurana. ");
INSERT INTO ebk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kuna pay enpatiliw hi Pedro, enpaifiarudna ya enpafiantayna as opat ay hen-op-at ay munsinsinnubrat ay sosorchachu. Tay as nan marpasan nan fiasta, plenanon Herodes ay mangokóm kan hiya as nan kaongoran chi tataku. ");
INSERT INTO ebk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Isunga naifiafiarud hi Pedro. Ngem uray mu hiyasa, chaan inkinkinak nan iib-ana ay omaafurot ay nangekarkararag kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","As nan hiyachi challu ay lafi, sakbay epapitiw Herodes hi Pedro as nan kafikiatana, nanassuy hi Pedro ay nunkiakiaw-an nan chuwa ay kuwarcha. Nakokor-ongan nan chuwa ay limana, ya wachacha pay nan nunkukuwarcha as nan pantiw nan pagfiaruchan. ");
INSERT INTO ebk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kalina at ya nunpaila nan usa ay anghel nan Apo, ya wachay silaw ay nangepapaway as nan kawad-ana. Sinikchud nan anghel nan pukor Pedro ay namangun kan hiya, ya kanana, “Kamuwum! Maligwatka!” Hiya at chi ya nag-as nan chiyuycha kor-ong nan chiyuycha limana. ");
INSERT INTO ebk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kenalen nan anghel kan hiya, “Iyam-ammam nan fiachom, ya munsandalka.” Enat Pedro chi. Angkiay ya kenalen kasin nan anghel, “Esalifudmu nan kakiaymu, ya umunudka kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Inunud Pedro nan anghel ay pinmitiw, ngem achina ammu ay nan cha at-atun nan anghel ay mangfiachang kan hiya at tit-iwa. Tay nan chana numnumnumun at cha mun-iitaw hiya. ");
INSERT INTO ebk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kuncha pay lenaosan nan omona ya nan maekadwa ay kuwarcha, inumchancha as nan lanchok ay unub nan sugpan ay muntoróng henan siyudad. Kun kalina ya natkafian nan lanchok ay unub ya pinmitiwcha. As nan nanaranancha as akét as nan korsa, kalina at ya namaid nan anghel. ");
INSERT INTO ebk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hiyachi nan nangammuwan Pedro ay fiakuna payat iitaw chi, ya kanana, “Ad wani, ammok ay tit-iwa ay infiaor Apo Dios nan anghelna ay mangesarakan kan ha-un as nan panagtoray Herodes ya as nan am-in ay cha namnamaun nan iib-ak ay Judio ay ommat kan ha-un.” ");
INSERT INTO ebk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kun pay ninumnum Pedro na, inmuy hiya as afong Maria ay enan Juan ay makali us un Marcos. Hid-i nan naaamongan nan ongor ay omaafurot ay cha munkarkararag. ");
INSERT INTO ebk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nunkokkok hi Pedro as nan pantiw. Angkiay ya nan mafiabfiaor ay fiafiai ay nan ngachana at Roda at uyna chinngor mu ngachan tud-i. ");
INSERT INTO ebk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kuna pay enmatonan nan kalen Pedro ya kiapú as lagsakna as solet, liniw-ana ay nankab as nan pantiw. Kun at tenmagtag ay nunfiangad ay nangifiakia un wacha hi Pedro ay nangatakchug as nan pantiw as chará. ");
INSERT INTO ebk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Ay kunka natongok?” kenalicha kan hiya. Ngem enpapeletna challu ay tit-iwa chi. Isunga kenalicha, “Ku-un anghelna mu.” ");
INSERT INTO ebk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ngem cha challu munkokkokokkok hi Pedro. Kuncha pay tenkafian nan pantiw, inilacha hiya, ya naschaawcha as solet. ");
INSERT INTO ebk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Sininyasana chicha ay kuminak, ya infiakiana kan chicha nan enat Apo Dios ay nangipitiw kan hiya as nan pagfiaruchan. Kenalina kan chicha, “Ifiakiayu pay na kan Santiago ya as nan tapina ay iib-a takú ay omaafurot.” Angkiay nak-ak hi Pedro, ya inmuy henan tukún ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","As nan kafikiatana, nalilifok ya inmugyat as solet nan sosorchachu mu anan enommat kan Pedro. ");
INSERT INTO ebk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Enpaanap Herodes hiya, ngem chaancha naanapan. Isunga finistikiarna nan sosorchachu ay nangukuwarcha kan Pedro, at infilina ay maepapatuycha. Kun pay narpas sa, chinmayyu hi Ari Herodes ay nurpu ad Judea, ya nafiayag ay nagyan ad Cesarea. ");
INSERT INTO ebk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","As nan nanagyanan Ari Herodes hid-i, finmungat hiya as solet as nan chiyuycha umiili ad Tiro ya Sidon. Isunga nun-us-usacha ay mangifiaor as nan usa ay grupo ay hiyasa nan pannakaachorcha ay uy manakiang kan Herodes. Kinayyumcha on-ona hi Blasto ay usa ay tenalek Herodes ay mangenongnongnong as nan palasyu ta hiya nan mangfiachang kan chicha. Angkiay ya inmuycha kan Herodes ta chumawatcha as kappia, tay henan sasakopuna nan omor-ancha as kanuncha. ");
INSERT INTO ebk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kun pay inumchan nan urkiw ay pinilen Herodes, nunfiachu as fiachon chi ari ya tenmokor as nan tronona, at nunchiskursu as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kun pay narpas chi, chacha ifugfukiaw, “Uy! Munkali payat hiya ay kaman as nan atun chi dios, fiakun kaman as nan atun chi taku.” ");
INSERT INTO ebk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hiya at chi ya enpasaket nan usa ay anghel Apo Dios hiya, tay chaana inchat kan Apo Dios nan pammachayaw. Angkiay ya nakrangan hiya, at natuy. ");
INSERT INTO ebk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ngem nan kalen Apo Dios at kaskasin nunchinamag, ya enmongorcha nan enmafurot kan Jesu Cristo. ");
INSERT INTO ebk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kun pay cha Bernabe kan Saulo at lenpascha nan naekeddeng ay atuncha ad Jerusalem, at nunfiangadcha ad Antiokia. Entakincha hi Juan ay makali us un Marcos as kadwacha. ");
INSERT INTO ebk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","As nan iglesia ad Antiokia, wachacha nan pomapadtu ya mun-isursuru as kalen Apo Dios. Chicha cha Bernabe, Simeon ay makali un Ngutug, Lucio ay i-Cirene, hi Manaen ay naepaurúg ay kadwan Herodes ay gobernador ad Galilea, ya hi Saulo. ");
INSERT INTO ebk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","As nan hin-urkiw, as nan chacha munchaychayawan kan Apo Dios ya mun-ay-ayunaran, kenalen nan Espiritu Santo kan chicha, “Chutokanyu cha Bernabe kan Saulo as munserfi kan ha-un as nan chunu ay nangayakiak kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kuncha pay narpas ay nun-ayunar ya nunkararag, enpataycha nan limacha kan cha Bernabe kan Saulo, at penaligwatcha chicha. ");
INSERT INTO ebk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Isunga kiapú as nan nangetorongan nan Espiritu Santo kan cha Bernabe kan Saulo, chinmayyucha on-ona ad Seleucia. Nunlapu hid-i, nunpaporcha ay inmuy ad Chipre. ");
INSERT INTO ebk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kuncha pay inumchan ad Salamina ad Chipre, enkaskasabacha nan kalen Apo Dios as nan chiyuycha senagogan chi Judio. Kadwacha hi Juan Marcos ay mangfiachang kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nar-oscha ad Chipre inkiana inumchancha ad Pafo. Hid-i nan nanib-atancha as nan usa ay somasaromangka ay Judio ay nan ngachana at Bar-Jesus ay nangali un pomapadtu hiya. ");
INSERT INTO ebk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hiya at kiayyum nan gobernador ad Chipre ay hi Sergio Paulo ay naraing ay taku. Enpaayag nan gobernador cha Bernabe kan Saulo, tay laychuna ay chungrun nan kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ngem hi Elimas ay sumasaromangka, (hiyasa nan ngachan Bar-Jesus as nan kali ay Griego) at chana konkontraun chicha, ya penachasna ay iyachawwi nan gobernador as nan omafurotana kan Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ngem hi Saulo ay makali us un Pablo ay napnu as pannakafialin nan Espiritu Santo at entoongana hi Elimas, ya kanana, ");
INSERT INTO ebk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“He-a ay anak Satanas! He-a nan kafusor chi am-in ay kenalintig. Napnuka as am-in ay kenasikap ya kenasator. Ay achim ikinak ay cha mamarfialinsuwek as nan kenatit-iwa ay isursuron Apo Dios? ");
INSERT INTO ebk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ad wani, chusaun chaká kan Apo Dios, ya mafuragka ya achim maila nan lawag nan urkiw as kaat ay urkiw.” Hiya at chi ya naleknana ay kaman liningfian chi munngungutug ay lifuu nan matana, ya nunkapkapukap ay nun-anap as mangpachang kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kun pay inilan nan gobernador nan enommat, enmafurot hiya kan Apo Jesus, tay naschaaw as nan insurucha maepangkep as nan Apo. ");
INSERT INTO ebk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nunpapor hi Pablo ya nan kakadwana nunlapu ad Pafo, at inumchancha ad Perge henan probinsiya ay Pamfilia. Hid-i nan nanaynanan Juan Marcos kan chicha, at nunfiangad hiya ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nanarcharan cha Pablo kan Bernabe nunlapu ad Perge inkiana inumchancha ad Antiokia henan probinsiya ay Pisidia. As nan Urkiw ay Mun-iblayan, sinungkopcha as nan senagoga ya naketokorcha. ");
INSERT INTO ebk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wacha nan nangifiasa as nan Lintig Moises ya nan insurat nan chiyuycha pomapadtu. Kun pay narpas, enpaifiakian nan totoray as nan senagoga kan cha Pablo, “Iib-a, mu wachay itukunyu as pumigsaan chi numnum nan tataku at mafialinyu ay ifiakia.” ");
INSERT INTO ebk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Isunga tenmakchug hi Pablo ya nunsinyas ay nangepakinak kan chicha. Kenalina, “Iib-ak ay kianak Israel ya chakayu am-in ay Gentil ay manaychayaw kan Apo Dios, chumngor kayu kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nan Dios nan chiyuycha kianak Israel at pinilina nan kaap-uwan takú as tatakuna, ya enpaongoongorna chicha as nan nagyanancha as kaili ad Egipto. As nan nafiayag ay timpu, babaen as nan pannakafialina, enpanguna chicha ay nak-ak hid-i. ");
INSERT INTO ebk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","As nan umuy as opat puru ay tawwun ay kawad-ancha henan disyerto, enan-anosan ya enay-aywanan Apo Dios chicha. ");
INSERT INTO ebk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kuncha pay inumchan nan kaap-uwan takú ad Canaan, enpaamis Apo Dios nan tataku ay wacha henan pitu ay nasyon, ya enpatawidna as nan kaap-uwan takú nan lutan nan hanacha ay nasyon. ");
INSERT INTO ebk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Am-in chaná ay enommat, nunlapu as nan inmuyancha ad Egipto inkiana as nan nangamisancha as nan chiyuycha i-Canaan at umuy as opat kiasot ya leman puru ay tawwun. Kun pay narpas sa, inchat Apo Dios kan chichay tukutukún ay huwis inkiana as nan timpon Samuel ay pomapadtu. ");
INSERT INTO ebk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Angkiay ya as nan chinmawatan nan tataku kan Apo Dios as ari, inchatna hi Saulo ay potot Kis ay kianak Benjamin. Nun-ari hi Saulo kan chicha as opat puru ay tawwun. ");
INSERT INTO ebk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kun pay kenaan Apo Dios hi Saulo, ensokatna hi David as aricha. Nauy nan kenalen Apo Dios maepangkep kan David: ‘Hi David ay potot Jesse at hiya nan mangepalaylayad kan ha-un. Hiya nan mangtongpartu as nan am-in ay laychok.’ ");
INSERT INTO ebk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nan nurpu as nan chiyuycha kianak David ay hi Jesus ay Mangesarakan as nan chiyuycha kianak Israel at finaor Apo Dios ay kaman as nan enkarina. ");
INSERT INTO ebk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","As nan chaan pay nangelapuwan Jesus as nan chununa, enkaskasaban Juan as nan am-in ay kianak Israel ay masapor munfiafiawicha as nan fiasfiasorcha ya munpafunyagcha. ");
INSERT INTO ebk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kun pay kiayud lopasun Juan nan chununa, kenalina as nan tataku, ‘Ngachana nan kananyu maepangkep kan ha-un? Fiakun ha-un nan chayu sassasad-un. Ngem wacha nan usa ay cha umunud kan ha-un ay uray nan kiarot chi sapatosna at achiyak maekari ay mangfokat.’ ");
INSERT INTO ebk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Iib-ak ay kianak Abraham ya am-in ay Gentil ay wacha hena ay munchaychayaw kan Apo Dios, chumngor kayu. Tit-iwa ay kan chitaku nan nangifiaoran Apo Dios as nan nauy naifiakia ay maepangkep as kaesarakanan. ");
INSERT INTO ebk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ngem nan chiyuycha inmiili ad Jerusalem ya nan anap-apucha at chaancha enmatonan ay hi Jesus nan infiaor Apo Dios winnu naawatan nan insurat nan chiyuycha pomapadtu ad pus-uy ay naifiasa as nan tunggal Urkiw ay Mun-iblayan. Uray mu hiyasa, chicha nan nangtongpar as nan infiakian nan chiyuycha pomapadtu as nan nangekeddengancha kan hiya ay matuy. ");
INSERT INTO ebk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Uray maid naanapancha as finmasorana as uycha nangepapatuyan kan hiya, chinawatcha challu kan Pilato ay epapatuyna hiya. ");
INSERT INTO ebk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kuncha pay enat nan am-in ay naisurat as nan Kalen Apo Dios maepangkep kan hiya, kensopcha hiya as nan koros, ya uycha inlufok. ");
INSERT INTO ebk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ngem tenakon Apo Dios hiya manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","As nan ongor ay urkiw, nunpappaila hiya as nan chiyuycha nakiuy kan hiya nunlapu ad Galilea inkiana ad Jerusalem. Ad wani chicha nan mangepaneknek kan chitaku ay Judio as nan maepangkep kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ad wani, chakami nan mangifiakia as nan nauy Ammay ay Chamag kan chakayu: Nan enkaren Apo Dios as nan kaap-uwan takú ad pus-uy ");
INSERT INTO ebk_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","at tenongparna kan chitaku ay kianakcha babaen as nan nangtakuwana kan Jesus manipud as nan utúy. Hiyana challu nan naisurat as nan maekadwa ay Salmo ay kanana, ‘He-a nan Anakku. Ad wani epailak ay ha-un nan Amam.’ ");
INSERT INTO ebk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nauy nan kenalen Apo Dios maepangkep as nan nangtakuwana kan Jesus manipud as nan utúy ay achi kasin matmatuy, tay achi poros mabrok hiya as nan lufok: ‘Ichatkuntu kan chakayu nan chiyuycha nasantowan ay bendisyon ay siguradu ay matongpar ay enkarek kan David.’ ");
INSERT INTO ebk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Isunga kenalina us as nan tukún ay naisurat as nan Salmo: ‘Achim eparufus ay mabrok nan Nasantowan as nan lufok.’ ");
INSERT INTO ebk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ngem fiakun maepangkep kan David nan laychuna ay kanan as na. Tay as nan narpasan David ay nangtongpar as nan penangkep Apo Dios kan hiya as nan natatakuwana, natuy hiya. Naetapi hiya ay nailufok as nan kaap-uwana, at nabrok nan achorna. ");
INSERT INTO ebk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ngem hi Jesus ay tenakon Apo Dios manipud as nan utúy at chaan nabrok. ");
INSERT INTO ebk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Isunga chakayu ay iib-ak, masapor maammuwanyu ay kiapú as nan enkaman Jesus, naekasaba kan chakayu nan mapakawanan chi fiasfiasor. ");
INSERT INTO ebk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tit-iwa ay babaen kan hiya, tunggal omafurot at naifilang as nalintig as nan sangwanan Apo Dios, tay achi mafialin ay palintikun nan Lintig Moises. ");
INSERT INTO ebk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Isunga il-ilaunyu ta achi koma maekaman kan chakayu nan nauy kenalen nan chiyuycha pomapadtu: ");
INSERT INTO ebk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ilaunyu, chakayu ay mun-ot-otyok! Maschaaw kayuntu, ya matuy kayuntu challu. Tay wachay kauugyat as solet ay atoktu as nan matatakuwanyu ay achiyuntu challu afurotun, uray kun wacha nan mangepakaawat ay ustu kan chakayu.’ ” ");
INSERT INTO ebk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","As nan cha pumitiwan cha Pablo kan Bernabe as nan senagoga, chinawat nan tataku kan chicha ay mu mafialin koma, isurucha pay chaná as nan somarunu ay Urkiw ay Mun-iblayan. ");
INSERT INTO ebk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kun pay nak-ak am-in nan tataku as nan senagoga, ongor ay Judio ya Gentil ay mangun-unud as nan iniili ay ukialen chi Judio nan inmunud kan chicha. Naketakiatfor cha Pablo ya enawischa chicha ay mangiturturuy ay muntalek as nan grasyan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","As nan senmarunu ay Urkiw ay Mun-iblayan, kiayud am-in nan umili at naamongcha ay uy manngor as nan kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ngem kun pay inilan nan chiyuycha Judio nan ongoongor ay tataku, enmaposcha as solet. Kenontracha nan kenalen Pablo ya enkak-aliyancha hiya. ");
INSERT INTO ebk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ngem kaskasin tinmurud cha Pablo kan Bernabe, ya kanancha, “Masapor chakayu ay Judio nan omon-ona ay maifiag-an nan kalen Apo Dios. Kiapú ta enachiyu, chakayu mismu nan achi mangifilang as achoryu ay mawad-an as fiyag ay maid patingkiana, taynanmi chakayu, ya umuy kami as nan chiyuycha Gentil. ");
INSERT INTO ebk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tay hiyana nan infilin Apo Dios kan chakami ay kanana un, ‘Pinilek he-a ay manilaw as numnum nan chiyuycha Gentil ta am-in nan tataku asna's luta at maesarakancha kiapú kan he-a.’ ” ");
INSERT INTO ebk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","As nan nanngoran nan chiyuycha Gentil as sa, naragsakancha ya chinaychayawcha nan kalen Apo Dios. Nan chiyuycha pinipilen Apo Dios ay mawad-antu as fiyag ay maid patingkiana at enmafurotcha. ");
INSERT INTO ebk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Angkiay ya naepachamag nan kalen Apo Dios henan hana intiru ay lukiar. ");
INSERT INTO ebk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ngem chinorchor nan chiyuycha Judio nan nunkafiaknang ay fianafiai ay manangchaychayaw kan Apo Dios ya nan anap-apu henan siyudad. Enlapucha ay mamalikiat kan cha Pablo kan Bernabe, ya enpak-akcha chicha henan lukiarcha. ");
INSERT INTO ebk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ngem penokpokan cha Pablo nan chapancha ay mangepaila as nan umili ay kikiadcha as nan mismu ay chusacha. Kun pay narpas sa, inmuycha ad Iconio. ");
INSERT INTO ebk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ngem uray mu assesa, nan chiyuycha enmafurot kan Jesus ad Antiokia at ongor chi lagsakcha, ya napnucha as pannakafialin nan Espiritu Santo. ");
INSERT INTO ebk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ad Iconio us, sinungkop cha Pablo kan Bernabe as nan senagogan chi Judio. Kiapú as nan makaawis as solet ay enatcha ay nangisursuru as nan kalen Apo Dios hid-i, ongoongorcha nan Judio ya Gentil ay enmafurot. ");
INSERT INTO ebk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ngem nan chiyuycha chaan enmafurot ay Judio at chinorchorcha nan chiyuycha Gentil ta ingluncha nan chiyuycha omaafurot. ");
INSERT INTO ebk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Uray mu assesa, nafiayag chi nakepagyanan cha Pablo kan Bernabe ad Iconio, ya naturudcha ay nangisursuru as nan kalen Apo Dios. Penaneknekan Apo Dios ay tit-iwa nan insursurucha maepangkep as nan grasyana babaen as nan nangichatana kan chicha as pannakafialin ay mangekaman as nan chiyuycha nakaskaschaaw ay sinyar ya milagro. ");
INSERT INTO ebk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ngem nakudwacha nan chiyuycha umiili hid-i ay siyudad. Nan tapina kan chicha at inunudcha nan chiyuycha Judio, ya nan tapina at inunudcha cha Pablo kan Bernabe ay apostoles. ");
INSERT INTO ebk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Angkiay ya nakiturag nan chiyuycha Gentil ya nan chiyuycha Judio as nan anap-apucha ay mamalikiat ya manglomtak as nan apostoles. ");
INSERT INTO ebk_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kun pay naammuwan nan apostoles nan planucha, lenmayawcha ay inmuy henan probinsiya ay Licaonia henan chiyuycha siyudad ay Listra ya Derbe, ya henan tukutukún ay luglukiar henan probinsiya ay ansa. ");
INSERT INTO ebk_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Hid-i nan nangituruyancha ay nangekasaba as nan Ammay ay Chamag. ");
INSERT INTO ebk_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ad Listra, wacha nan usa ay laraki ay nangatokor ay napilud nunlapu as nan naiyankana ya chaan poros nanarcharan. ");
INSERT INTO ebk_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Chinumngor hiya as nan cha kankanan Pablo. Entoongan Pablo hiya, ya inilana ay wacha nan pammatina ay makaan nan saketna. ");
INSERT INTO ebk_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Isunga kenalina ay nangipipigsa, “Tomakchugka!” As nan hiyachi, natannakchug nan laraki, ya enlapuna ay manaran. ");
INSERT INTO ebk_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kun pay inilan nan ongoongor ay tataku nan enat Pablo, infukiawcha as nan kalicha ay Linicaonia, “Nunfialin nan chiyuycha dios as kaman tataku, ya kinmuwabcha kan chitaku.” ");
INSERT INTO ebk_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ngenadnancha hi Bernabe as Zeus, ya hi Pablo as Hermes, tay hiya nan para karkali. ");
INSERT INTO ebk_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nan templo ay munchaychayawancha as nan dios ay Zeus at wacha henan fiakun sakop nan siyudad. Nan pachi ay munserserfi as nan hana ay templo at inyuynay chuwa ay laki ay fiaka ya appong ay sabsafong as nan sungkopan henan siyudad, tay hiya ya nan ongoongor ay tataku at laychuncha ay ichatonan cha Pablo kan Bernabe. ");
INSERT INTO ebk_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ngem kun pay chinngor cha Bernabe kan Pablo sa, lenaksetcha nan fiachucha, ya tenmagtagcha ay inmuy as nan kawad-an chi ongoongor ay tataku. Chacha ifugfukiaw as nan tataku, ");
INSERT INTO ebk_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Iib-a, adchi t'uyyu cha atun na? Kun kami us kaman kan chakayu ay tataku ya! Enmali kami hena ay mangepakaammu kan chakayu as nan Ammay ay Chamag maepangkep kan Apo Jesus. O, enmali kami ay mangifiakia kan chakayu ay chukkianyu nan panagchaychayaw as nan chiyuycha achi tit-iwa ay dios ta omafurot kayu as nan matataku ay Dios ay namayang as nan chaya, nan luta, nan fiayfiay, ya nan am-in ay wacha kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ad pus-uy, penarufusan Apo Dios nan am-in ay tataku ay munchaychayaw as nan laylaychuncha. ");
INSERT INTO ebk_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Uray mu hiyasa, narawag challu ay wachay pammaneknek ay hiya nan tit-iwa ay Apo Dios babaen as nan ammay ay atuna. Enpar-ina nan uchan ay nurpu ad chaya, ya inchatna nan apetyu as nan ustu ay timpu. Penennekna chakayu as ongor ay kanunyu ya lagsakyu.” ");
INSERT INTO ebk_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Uray mu assena nan infiagfiakian nan apostoles kan chicha, nalikiatancha challu ay nangepawa as nan tataku as nan mun-ichatonancha kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","As nan hiyachi, inumchan nan tapen nan Judio ay nurpu ad Antiokia ya Iconio. Chinorchorcha nan tataku ad Listra ay manglomtak kan Pablo. Kuncha pay lenpas ay nanglomtak kan hiya, inkiayadcha hiya ay nangek-ak henan siyudad, tay ka-anancha mu natuy. ");
INSERT INTO ebk_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ngem kun pay enarufong nan chiyuycha omaafurot hiya, naligwat hi Pablo, ya nunfiangad henan chiyuy siyudad. As nan kafikiatana, inmuy cha Pablo kan Bernabe ad Derbe. ");
INSERT INTO ebk_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Enkaskasaban cha Pablo kan Bernabe nan Ammay ay Chamag ad Derbe, ya ongorcha nan enmafurot. Angkiay nunfiangadcha ad Listra, ad Iconio, ya ad Antiokia ay siyudad ad Pisidia. ");
INSERT INTO ebk_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Penapigsacha nan pammaten nan chiyuycha omaafurot hid-i ay il-ili, ya enawischa chicha ay munturturuy as nan pammaticha kan Apo Dios. Kenalicha kan chicha, “Masapor mapachasan takúy ongor ay likiat as nan maetapiyan takú henan muntorayan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Chinmutok cha Pablo kan Bernabe as mangepangpanguru as nan tunggal iglesia. As nan narpasancha ay nunkararag ya nun-ayunar, entalekcha chicha as nan Apo ay hiya nan enafurotcha. ");
INSERT INTO ebk_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kun pay nar-os cha Pablo henan sakop nan Pisidia, enmalicha henan probinsiya ay Pamfilia. ");
INSERT INTO ebk_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Henan siyudad ay Perge, enkasabacha nan kalen Apo Dios. Angkiay ya kinmuwabcha ad Atalia. ");
INSERT INTO ebk_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nunlapu ad Atalia, nunpaporcha ay nunfiangad ad Antiokia henan probinsiya ay Siria. Hid-i nan nangekarkararakian nan iib-a ay nangetalek kan chicha as nan panang-aywan ya sug-ang Apo Dios para kan chicha as nan chunucha ay hiyasa nan lenpascha ad wani. ");
INSERT INTO ebk_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kuncha pay inumchan ad Antiokia, enamongcha nan chiyuycha membro as nan iglesia. Enpachamagcha nan am-in ay en-enat Apo Dios babaen kan chicha ya nan en-enatna ta nan chiyuycha Gentil at omafurotcha koma kan Apo Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nafiayag nan nakepapagyanan cha Pablo kan Bernabe as nan chiyuycha omaafurot ad Antiokia. ");
INSERT INTO ebk_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","As nan hiyachi, wachacha nan tapen nan lanaraki ay nurpu ad Judea ay chinmayyu ad Antiokia. Enlapucha ay mun-isuru as nan chiyuycha enmafurot kan Jesu Cristo, ya kanancha, “Mu achi kayu masugyatan ay maiyunud as nan iniili ay ukiali ay insuron Moises at achi kayu maesarakan.” ");
INSERT INTO ebk_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pararuy enat cha Pablo kan Bernabe ay nakesongfiat kan chicha maepangkep as sa. Isunga nachutokan cha Pablo kan Bernabe ya nan tapina ay omaafurot ad Antiokia ay omabrat ad Jerusalem ya makeapat as nan apostoles ya as nan chiyuycha anam-amá maepangkep as sa. ");
INSERT INTO ebk_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Angkiay ya penaligwat nan chiyuycha omaafurot cha Pablo. As nan chacha mar-osan ad Fenicia ya Samaria, infiakiacha as nan chiyuycha omaafurot hid-i nan enmafurotan nan chiyuycha Gentil. As nan nanngorancha as nan hana ay chamag, ongor chi lagsak am-in nan chiyuycha omaafurot. ");
INSERT INTO ebk_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kuncha pay inumchan ad Jerusalem, nan iglesia, nan apostoles, ya nan chiyuycha mangepangpanguru at enawatcha chicha. As nan narpasan tona, enpachamag cha Pablo nan am-in ay enat Apo Dios babaen kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ngem nan tapen nan omaafurot ay wacha as nan bunggoy nan chiyuycha Fariseo at tenmakchugcha, ya kanancha, “Masapor masugyatan nan chiyuycha Gentil ya mafiag-ancha ay mangtongpar as nan Lintig Moises.” ");
INSERT INTO ebk_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","As nan hiyachi, nunmimitincha nan apostoles ya nan chiyuycha mangepangpanguru ay mangapat as nan maepangkep as sa. ");
INSERT INTO ebk_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kun pay nafiayag chi nangapatancha as sa, tenmakchug hi Pedro, ya kanana kan chicha, “Iib-a, aammuyu met ay ad kasin at piniliyak kan Apo Dios kan chakayu ay uy mangekasaba as nan Ammay ay Chamag as nan chiyuycha Gentil ta chumngorcha ya omafurotcha. ");
INSERT INTO ebk_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Hi Apo Dios ay nangammu as numnum nan am-in ay tataku at enpailana ay enawatna nan chiyuycha Gentil babaen as nan nangichatana as Espiritu Santo kan chicha ay kaman as nan enatna kan chitaku. ");
INSERT INTO ebk_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Maid enat Apo Dios as natkunan takú kan chicha, tay penakawana chicha as nan fiasfiasorcha as nan enmafurotancha ay kaman kan chitaku. ");
INSERT INTO ebk_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Isunga adchi t'uyyu chischistingun hi Apo Dios as nan nangepad-unanyu kan chicha as nan uchun ay achicha kafiaelan? Uray met nan kaap-uwan takú ya chitaku mismu at achi takú challu kafiaelan. ");
INSERT INTO ebk_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Numnumunyu kay! Afurotun takú ay naesarakan takú babaen as nan grasyan Apo Jesus ay kaman challu kan chicha.” ");
INSERT INTO ebk_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","As nan hiyachi, kinminakcha am-in nan tataku, ya chinumngorcha as nan cha kankanan cha Bernabe kan Pablo. Enpachamagcha nan maepangkep as nan am-in ay nakaskaschaaw ay sinyar ya milagro ay enat Apo Dios as nan chiyuycha Gentil babaen kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","As nan narpasancha ay nunkali, kenalen Santiago, “Iib-a, chumngor kayu kan ha-un. ");
INSERT INTO ebk_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Kaifiagfiakian Simon Pedro nan omona ay nangepail-an Apo Dios as sug-angna as nan chiyuycha Gentil ta munpili hiya kan chicha as tatakuna. ");
INSERT INTO ebk_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nan nauy ay enat Apo Dios at inyafudna nan insurat nan chiyuycha pomapadtu. Kaman as nan naisurat as nan Kalen Apo Dios ay kanana, ");
INSERT INTO ebk_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Mu marpas na, munfiangachak ya kasek kiaufun nan mamagyanan Ari David ay nachachael. Kiaufok kasin nan nachachael ya kasinku patakchukun ");
INSERT INTO ebk_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ta am-in nan tapina pay ay tataku ya am-in nan Gentil ay pinilek as tatakok at anapuncha nan Apo. ");
INSERT INTO ebk_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Hiyana nan kenalen nan Apo ay nangepakaammu as na ad pus-uy.’ ");
INSERT INTO ebk_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Isunga nan wacha as numnumku at achi takú koma lilifokun nan chiyuycha Gentil ay cha omafurot kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kun takú at masapor munsurat kan chicha ay mangifiaag ay achicha ischa nan naichaton as nan didiosen, nan naparti ay chaan nauykokan, ya nan chara. Nan usa pay at chukkiancha nan mangepapasan as assi ay lachok. ");
INSERT INTO ebk_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tay nan Lintig Moises at naekasaba nunlapu ad pus-uy henan tunggal ili ya naifiasa as nan kasenasenagoga as nan tunggal Urkiw ay Mun-iblayan.” ");
INSERT INTO ebk_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Angkiay nan apostoles ya nan mangepangpanguru patí nan intiru ay iglesia at ninumnumcha ay munpili as lanaraki kan chicha ay makiuy kan cha Pablo kan Bernabe ad Antiokia. Pinilicha hi Judas ay makali us un Barsabas ya hi Silas ay chicha nan chuwa ay mangepangpanguru as nan iib-a. ");
INSERT INTO ebk_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Cha Judas kan Silas nan nangepaw-etancha as nan nauy ay surat as nan chiyuycha Gentil: “Chakami ay apostoles ya nan mangepangpanguru ay iib-ayu ad Jerusalem at nauy nan suratmi kan chakayu am-in ay Gentil ay omaafurot henan siyudad ay Antiokia ya henan sakop nan Siria ya Cilicia. Komosta kayu? ");
INSERT INTO ebk_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Chinngormi ay wachacha nan nurpu hena ay ib-ami ay inmuy hesa ay nanglilifok ya nangpachanag kan chakayu babaen as nan infiakiacha, uray mu fiakun chakami nan nangifilin kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Isunga nunmitin kami ya inyafud nan am-in ay pumili kami as lanaraki ay maifiaor as umuy hesa kan chakayu. Makitun-udcha as nan laylaychun takú ay kiakiayyum ay cha Pablo kan Bernabe ");
INSERT INTO ebk_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ay nangeposta as fiyagcha ay munserfi kan Apo takú ay Jesu Cristo. ");
INSERT INTO ebk_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Isunga ifiaormi cha Judas kan Silas ay chicha mismu nan mangpaneknek kan chakayu as nan pachong nan insuratmi. ");
INSERT INTO ebk_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Enpakaammon nan Espiritu Santo kan chakami ya inyafudmi ay achimi epapelet ay mangepad-un kan chakayu as nan ukialimi. Nan masapor ay tongparunyu at nan nauycha filin yangkiay: ");
INSERT INTO ebk_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Achiyu ischa nan naichaton as nan didiosen, nan chara, ya nan naparti ay chaan nauykukan. Nan usa pay at chukkianyu nan mangepapasan as assi ay lachok. Omammaytuy aatunyu mu tongparunyu chaná ay infilinmi. Hiyasa yangkiay nan ifiakiami.” ");
INSERT INTO ebk_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kuncha pay lenpas nan suratcha, naepaligwatcha nan nangiyuy ay umuy ad Antiokia. As nan inumchanancha hid-i, enamongcha nan chiyuycha omaafurot, at inchatcha nan surat. ");
INSERT INTO ebk_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kun pay finasan nan chiyuycha omaafurot ay i-Antiokia nan surat, ongor chi lagsakcha as nan ammay ay naitukun kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Cha Judas kan Silas ay pomapadtu ay mismu at ongor chi infiagfiakiacha ay nanukun ya nangepapigsa as pammaten nan iib-a. ");
INSERT INTO ebk_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kun pay inmuy chi kaat ay chumingkucha hid-i, penaligwat nan iib-a chicha ay nunfiangad as nan nangifiaor kan chicha, ya kanancha, “Aywanan chakayu koma kan Apo Dios.” ");
INSERT INTO ebk_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ngem ninumnum Silas ay mayagyag. ");
INSERT INTO ebk_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Cha Pablo kan Bernabe at nayagyagcha ad Antiokia ay nangisursuru ya nangekaskasaba as nan kalen nan Apo ay kadwacha nan ongor ay iib-acha ay omaafurot. ");
INSERT INTO ebk_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kun pay inmuy chi kaat ay urkiw, kenalen Pablo kan Bernabe, “Munfiangadta ay uy mangfisita as nan iib-a takú henan am-in ay ili ay nangekaskasabaanta as nan kalen nan Apo ta ilaunta mu anan chacha at-atun.” ");
INSERT INTO ebk_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Hi Bernabe at laraychuna ay etakincha hi Juan ay makali us un Marcos, ");
INSERT INTO ebk_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ngem enpapelet Pablo ay un-unuyna mu achicha etakin hiya, tay tenaynana chicha ad Pamfilia, ya chaana inturuy ay finmachang as nan chunucha. ");
INSERT INTO ebk_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kiapú ta nunsuma as solet cha Pablo kan Bernabe, nunsiyancha. Entakin Bernabe hi Marcos, ya nunpaporcha ay inmuy ad Chipre. ");
INSERT INTO ebk_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ngem hi Pablo at pinilina hi Silas as kadwana. Entalek nan iib-a chicha as nan panang-aywan ya sug-ang Apo Dios henan am-in ay ay-ayancha. Angkiay nunligwatcha, ");
INSERT INTO ebk_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","at nar-oscha ad Siria ya Cilicia ay nangepappapigsa as nan chiyuycha iglesia hid-i. ");
INSERT INTO ebk_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nunfiaat us cha Pablo ad Derbe, angkiay ya ad Listra. Wacha ad Listra nan usa ay omaafurot ay nan ngachana at Timoteo. Hi enana at usa ay Judio ay omaafurot, ngem hi amana at Griego. ");
INSERT INTO ebk_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Hi Timoteo ay anna at ammay chi kaap-apatana as nan am-in ay iib-a ay omaafurot ad Listra ya ad Iconio. ");
INSERT INTO ebk_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Laychun Pablo ay etakin hi Timoteo. Isunga enpasugyatna hiya ta achintu achiyun nan chiyuycha Judio hiya henan hanacha lukiar ay ay-ayanchantu. Tay am-in nan Judio at naammuwancha ay Griego hi amana. ");
INSERT INTO ebk_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","As nan nunfiaatancha henan il-ili, chacha epakaammu as nan chiyuycha Gentil ay omaafurot nan filfilin ay unuchuncha ay inyafud nan apostoles ya nan anam-amá ad Jerusalem. ");
INSERT INTO ebk_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Isunga nan chiyuycha iglesia at pinmigsa nan pammaticha ya inurkiw ay omongorcha. ");
INSERT INTO ebk_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Angkiay ya nunfiaat cha Pablo ay nar-os henan sakop nan Frigia ya Galacia, tay chaan enparufus nan Espiritu Santo ay ekasabacha nan kalen Apo Dios henan probinsiya ad Asia. ");
INSERT INTO ebk_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kuncha pay inumchan henan tikiad nan probinsiya ay Misia, penachascha ay umuy henan probinsiya ay Bitinia, ngem chaan enparufus nan Espiriton Apo Jesus. ");
INSERT INTO ebk_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Isunga nar-oscha ad Misia inkiana inumchancha ad Troas. ");
INSERT INTO ebk_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","As nan hiyachi ay lafi, wacha nan enpailan Apo Dios kan Pablo babaen as nan kaman iitaw. Inilana nan usa ay laraki ay i-Macedonia ay nangatakchug ay cha munpakpakaasi. Kenalina kan Pablo, “Omalika man paat ad Macedonia ay mangfiachang kan chakami.” ");
INSERT INTO ebk_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kun pay narpas ay inilan Pablo nan kaman iitaw, hiya at chi ya nun-anap kami as munlukiananmi ay umuy ad Macedonia, tay naawatanmi ay enayakian chakami kan Apo Dios ay uy mangekasaba as nan Ammay ay Chamag as nan tataku hid-i. ");
INSERT INTO ebk_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nunlapu ad Troas as nan nunlukiananmi as nan papor, nunchakpos kami ad Samotracia. As nan kafikiatana, inumchan kami ad Neapolis. ");
INSERT INTO ebk_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nunlapu hid-i, nanarcharan kami ay inmuy ad Filipos ay usa ay mafigfigfig ay siyudad henan sakop nan Macedonia. Nan kaongoran ay inmiili henan hana ay siyudad at Romano. Nagyan kami hid-i as kaat ay urkiw. ");
INSERT INTO ebk_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","As nan Urkiw ay Mun-iblayan, nak-ak kami henan hana ay siyudad, ya inmuy kami henan olet nan wawwang, tay ninumnummi mu wachay lukiar ay maam-amongan chi Judio ay munkararag. Naketokor ya naketakiatfor kami as nan fianafiai ay naamong hid-i. ");
INSERT INTO ebk_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nan usa as nan chiyuycha chinumngor kan chakami at hi Lydia ay nurpu henan siyudad ay Tiatira ay mun-el-elaku as nangingina ay lopot. Hiya at usa ay Gentil ay manangchaychayaw kan Apo Dios. Inchat Apo Dios kan hiyay pannakaawat ta omafurot as nan cha kankanan Pablo. ");
INSERT INTO ebk_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Angkiay nunpafunyagcha ay hinfiaruy. Kun pay narpas sa, kenalina kan chakami, “Mu afurotunyu ay tit-iwa'y enmafurotak kan Apo Jesus, chumawus kayu ngarud as afongmi.” Inturuyna ay nangayag kan chakami inkiana nakiuy kami kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","As nan hin-urkiw, as nan chami umuyan henan lukiar ay munkarkararakian, sinib-at chakami as nan mafiabfiaor ay fiarasang ay naanennetan. Nakasiping as ongor nan fiarasang para as nan chiyuycha amona kiapú as nan enpaifiakian nan anennet kan hiya ay ommat as tapen chi urkiw. ");
INSERT INTO ebk_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Inmunud kan chakami kan Pablo, ya chana ifugfukiaw, “Chatona ay lanaraki at munserserficha as nan Kangatuwan ay Dios ay cha mangekaskasaba kan chakayu as nan atunyu ay maesarakan!” ");
INSERT INTO ebk_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Enaenatna sa as kaat ay urkiw. Kun pay enmayu as solet hi Pablo, nunsakong, ya kanana as nan anennet, “As nan ngachan Jesu Cristo, filinok he-a ay fomoknag kan hiya!” Hiya at chi ya fenmoknag tit-iwa nan anennet. ");
INSERT INTO ebk_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kun pay inilan nan chiyuycha amona ay maid at chansacha ay makasiping, lenabkischa cha Pablo kan Silas. Inkiayadcha chicha ay nangiyuy as nan kawad-an nan totoray as nan mun-el-elakwan. ");
INSERT INTO ebk_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kuncha pay inyuy chicha as nan chiyuycha opisyar ay Romano, kenalicha, “Chatona ay lanaraki at Judiocha, ya chacha munkurkuru henan siyudad takú. ");
INSERT INTO ebk_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Chacha mun-is-isuru as iniili ay ug-ukiali ay komontra as nan lintig takú, ya achi mafialin ay unuchun takú ay Romano.” ");
INSERT INTO ebk_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Angkiay ya naetapi nan ongor ay tataku ay namudtak kan chicha. Nan chiyuycha opisyar at lenafusancha cha Pablo kan Silas, ya infilincha ay masapletcha. ");
INSERT INTO ebk_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kuncha pay lenpas ay nanaplesaplet kan chicha, enpaifiarudcha chicha. Infilincha as nan munkukuwarcha ay kuwarchaana chicha ay ustu. ");
INSERT INTO ebk_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kiapú ta assid-i nan infilin nan chiyuycha opisyar as nan munkukuwarcha, enpokokna cha Pablo kan Silas as nan paat nunchuchuku ay kuwartu as pagfiaruchan. Enpatangna nan sukicha as nan nunkaketangan ay nun-oomam ay tabra, ya nun-akmuna. ");
INSERT INTO ebk_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ngem as nan kiayud tongan chi lafi, cha munkarkararag ya munkankanta cha Pablo kan Silas ay manaychayaw kan Apo Dios, ya nan tapina ay fiarud at chuchumngorcha kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kalina at ya kinmichu as napigsa ay nangiwawud as nan nasasad-an nan pagfiaruchan. Hiya at chi ya natkafian nan kapantipantiw ya nag-as nan chiyuycha kor-ong nan am-in ay fiarud. ");
INSERT INTO ebk_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kun pay finmangun nan kuwarcha, ya inilana ay nanatkafian nan chiyuycha pantiw nan pagfiaruchan, enoknosna nan espadana ya kiayudna patayun nan achorna, tay ninumnumna ay lenmayawcha nan chiyuycha fiarud. ");
INSERT INTO ebk_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ngem infukiaw Pablo, “Achim patayun nan achormu, tay nauy kami am-in hena.” ");
INSERT INTO ebk_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kun pay chinngor nan kuwarcha na, nunpaara hiya as silaw. Tenagtagna ay inmuy as nan kawad-an cha Pablo kan Silas, ya cha munpapayagpag as ugyatna ay nunpalintumang as sangwanancha. ");
INSERT INTO ebk_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Angkiay inpitiwna chicha, ya senarudsudna, “Panguruwan, ngachana ngay nan masapor ay atok ta maesarakanak?” ");
INSERT INTO ebk_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tinumforcha, “Omafurotka kan Apo Jesus. Mu hiyasa nan atum, maesarakankantu ya nan pamilyam.” ");
INSERT INTO ebk_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Angkiay ya enkasabacha nan kalen nan Apo kan hiya ya as nan am-in ay tataku as afongna. ");
INSERT INTO ebk_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","As nan hiyachi challu ay uras as nan lafi, inyuy nan kuwarcha cha Pablo kan Silas as nan kawad-an nan chanum, ya enlasana nan sugsukiatcha. Kun pay narpas, nunpafunyag hiya ya patí nan pamilyana. ");
INSERT INTO ebk_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Angkiay ya enayakiana cha Pablo kan Silas as afongna, ya ensakianaana chicha as kanuncha. Ongor chi lagsakna patí nan pamilyana, tay enmafurotcha kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","As nan kafikiatana, inmifiaor nan chiyuycha opisyar ay Romano as pupulis ay uy mangifilin as nan kukuwarcha, “Ilufusmu nan hanacha lanaraki.” ");
INSERT INTO ebk_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Angkiay infiakian nan kuwarcha kan Pablo, “Infilin nan chiyuycha opisyar ay Romano ay mailufus kayu kan Silas. Ad wani, mafialin at ay mak-ak kayu, ya wacha komay talna kan chakayu.” ");
INSERT INTO ebk_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ngem kenalen Pablo as nan pupulis, “Kun chakami cha enpasaplet as nan kaongoran chi tataku ya. Chaan chakami pay finistikiar on-ona. Uray mu Romano kami, enpaifiarud chakami pay laing. Angkiay ad wani, laychun chakami ay ilufus kan chakayu ay maid mangam-ammu? Achi mafialin! Masapor chicha mismu nan omali ay mangilufus kan chakami.” ");
INSERT INTO ebk_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Enpachamag nan pupulis chaná ay kenalen Pablo as nan chiyuycha opisyar. Inmugyatcha as nan nanngorancha ay Romano payat cha Pablo kan Silas. ");
INSERT INTO ebk_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Isunga kenamucha ay inmuy as nan pagfiaruchan, at nunpakawancha kan cha Pablo kan Silas. Angkiay inpitiwcha chicha as pagfiaruchan, ya chinawatcha kan chicha ay mak-akcha henan siyudad. ");
INSERT INTO ebk_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","As nan nak-akan cha Pablo kan Silas as pagfiaruchan, inmuycha as afong Lydia. Hid-i nan nanib-atancha as nan iib-a ay omaafurot, ya penapigsan cha Pablo nan pammaticha babaen as nan kenalicha. Angkiay nak-akcha henan hana ay siyudad. ");
INSERT INTO ebk_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nunlapu ad Filipos, nanarcharan cha Pablo ay nanguy henan siyudad ay Amfipolis ya Apolonia inkiana inumchancha ad Tesalonica ay kawad-an nan usa as nan chiyuycha senagogan chi Judio. ");
INSERT INTO ebk_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","As nan hiyachi, in-inmuy hi Pablo as nan senagoga ay hiyachi challu nan chana atuatun. As nan turu ay Urkiw ay Mun-iblayan, nakeap-apat hiya as nan naamong ay tataku maepangkep as nan naisurat as nan Kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Enlawlawag ya penaneknekan Pablo ay nan Cristo at masapor munlikiat ya mataku manipud as nan utúy. Kenalina kan chicha, “Hi Jesus ay anna ay chak ifiagfiakia kan chakayu at hiya nan Cristo.” ");
INSERT INTO ebk_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nan tapina kan chicha at enmafurotcha ya naetapicha kan cha Pablo kan Silas. Kaman us as nan ongoongor ay Griego ay manangchaychayaw kan Apo Dios ya nan ongor ay mafigfigfig ay fianafiai. ");
INSERT INTO ebk_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ngem enmapos nan chiyuycha Judio ay achi omaafurot. Isunga enamongcha nan chiyuycha lanaraki ay nunkapadsok ay kun yangkiay cha munforforakfor as nan mun-el-elakwan, ya entapicha as nan enamongcha ay ongor ay tataku. Kun pay chaan nafiayag, nunlumucha as kuru henan siyudad. Peneletcha ay sungkop as nan afong Jason, tay nan ammucha at maanapancha cha Pablo kan Silas ta papitiwuncha chicha ay mangiyuy as nan sangwanan nan tataku. ");
INSERT INTO ebk_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ngem kuncha pay chaan naanapan chicha, hi Jason ya nan tapen nan iib-a at inkiayadcha ay nangiyuy as nan anap-apu henan siyudad. Chacha ifugfukiaw, “Nan nauycha tataku ay nunkurukuru henan am-in ay lukiar asna's luta at enmalicha hena ay munkuru kan chitaku, ");
INSERT INTO ebk_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","at menangilen Jason chicha. Am-in chaná at chacha lablabsingun nan chiyuycha lintig Emperador ay kanancha un wachay tukún ay ari ay nan ngachana at Jesus.” ");
INSERT INTO ebk_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","As nan nanngoran nan ongor ay tataku ya nan anap-apu henan siyudad as na, nurmuy kuru. ");
INSERT INTO ebk_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nunfiansaun nan chiyuycha toray cha Jason ya nan iib-a, at inlufuscha chicha. ");
INSERT INTO ebk_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","As nan hiyachi challu ay lafi, penaligwat nan iib-a cha Pablo kan Silas ay umuy ad Berea. Kuncha pay inumchan hid-i, inmuycha as nan senagogan chi Judio. ");
INSERT INTO ebk_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nan chiyuycha Judio ay wacha ad Berea at mannakaawatcha mu nan i-Tesalonica, tay ongor chi layadcha ay nanngor as nan kalen Apo Dios. Inurkiw ay chacha achaacharun nan naisurat as nan Kalen Apo Dios ta ammuwuncha mu tit-iwa nan kenarkalen Pablo. ");
INSERT INTO ebk_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ongor as nan chiyuycha Judio nan enmafurot, ya ongor nan enmafurot as nan chiyuycha Griego ay fianafiai ay nunkafiaknang ya ongor us nan lanaraki ay Griego. ");
INSERT INTO ebk_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ngem kun pay chinngor nan chiyuycha Judio ad Tesalonica ay cha us ekaskasaban Pablo nan kalen Apo Dios ad Berea, inmuycha us hid-i, at enlapucha ay nanugsug ya nangkuru as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Hiya at chi ya penaligwat nan iib-a ay omaafurot cha Pablo ay chumayyu henan olet nan fiayfiay, ngem nayagyag cha Silas kan Timoteo ad Berea. ");
INSERT INTO ebk_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nan chiyuycha nangitun-ud kan Pablo at inturudcha hiya inkiana henan siyudad ay Atenas. Angkiay nunfiangadcha ay uy nangifiakia as nan infilin Pablo ay kamuwun koma cha Silas kan Timoteo ay umunud kan hiya. ");
INSERT INTO ebk_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","As nan nunsusuuchan Pablo ad Atenas kan cha Silas kan Timoteo, nalilifok as solet nan numnumna as nan nangil-ana as nan ongoongor ay didiosen henan hana ay siyudad. ");
INSERT INTO ebk_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Isunga inmuy hiya as nan senagoga ay nakeap-apat as nan chiyuycha Judio ya as nan chiyuycha Gentil ay manangchaychayaw kan Apo Dios. Uray as nan mun-el-elakwancha, inurkiw ay uy nakeap-apat hiya as nan kumpurmi ay tataku ay nad-anana. ");
INSERT INTO ebk_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Wachacha nan tapen chi mimisturu ay makali un Epicureo ya Estoico ay uy nakesosek us kan hiya. Senarudsud nan tapina kan chicha, “Anan cha ngun lawá kankanan tona ay taku ay maid acharna?” Nan tapina us at kenalicha, “Kamana cha ekaskasaba nan chiyuycha kaili ay dios.” Kenalicha sa, tay enkasaban Pablo nan maepangkep kan Jesus ya nan matakuwan manipud as nan utúy. ");
INSERT INTO ebk_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Angkiay enpaiyuycha hiya as nan anap-apon chi umili ay makali un Areopago, ya kanancha, “Laychunmi man ay ammuwun nan nauy fiarú ay sursuru ay cham kankanan, ");
INSERT INTO ebk_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","tay nan kenarkalem at maid poros chinchinngormi as kaman as nan nauycha, ya laychunmi ay ammuwun nan laychun nan nauycha ay kanan.” ");
INSERT INTO ebk_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Am-in nan umiili ad Atenas ya uray nan chiyuycha kaili ay nagyan hid-i at kuncha laychun ay cha mangifiagfiakia ya cha manmanngor as nan fiarú ay sursuru. ");
INSERT INTO ebk_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Isunga tenmakchug hi Pablo as nan sangwanan nan anap-apon chi umili ay makali un Areopago, ya kanana, “Chakayu ay umiili hena ad Atenas, mailak ay as nan am-in at relihiyoso kayu. ");
INSERT INTO ebk_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tay as nan nunpaspasyorak henan siyudadyu ya as nan nangil-il-ak as nan chiyuycha munchaychayawanyu, inuchanak nan altar ay naisuratan nan kali ay kanana, ‘Para as nan Dios ay Achimi Am-ammu.’ Nan chiyuy chayu chaychayawun ay achiyu am-ammu at hiya nan chak epakaammu kan chakayu ad wani. ");
INSERT INTO ebk_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nan Dios ay namayang as nan lufong ya as nan am-in ay wacha hena at hiya nan Apo ad chaya ya asna's luta, ya achi mamagyan as nan chiyuycha templo ay enammaan chi taku. ");
INSERT INTO ebk_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Maid poros kasaporana as ifiachang chi taku kan hiya, tay hiya mismu nan mangichat as fiyag, long-ag ya am-in ay kasaporan takú. ");
INSERT INTO ebk_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Manipud as nan usa yangkiay ay taku, finayang Apo Dios nan am-in ay karasen chi tataku ya epapagyana chicha henan intiru ay luta. Enkeddengna us nan chiyuycha ustuustu ay timpu ya nan chiyuycha munpatingkiaan nan tikiad nan nasyoncha. ");
INSERT INTO ebk_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Enat Apo Dios na ta anapun nan tataku hiya ya uchanancha hiya as nan chacha munkapkapokapan ay manganap kan hiya. Nan kenatit-iwana at achi achawwi hiya as nan tunggal usa kan chitaku. ");
INSERT INTO ebk_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tay wacha nan nangali un, ‘Hiya nan mangichat as nan fiyag kan chitaku ya mangaywan kan chitaku as nan ay-ayan takú ya matatakuwan takú.’ Kaman as nan kenalen nan tapen nan uyyu sumusurat, ‘Chitaku nan an-akna.’ ");
INSERT INTO ebk_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kiapú ta an-ak chitaku kan Apo Dios, achi takú ngarud numnumnumun ay maepachong nan kenadiosna as nan kumpurmi ay dios ay fialetok, silver, winnu fiatu ay enammaan chi taku ay nurpu as nan laingna ya mismu ay numnumna. ");
INSERT INTO ebk_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","As nan timpu ay chaan pay nangammuwan nan tataku kan Apo Dios at inyangkiayana nan fiasfiasorcha. Ngem ad wani, infilina as nan am-in ay tataku henan uray ngachana ay lukiar ay munfiafiawicha as nan am-in ay fiasorcha. ");
INSERT INTO ebk_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tay enkekeddeng at Apo Dios nan urkiw ay mang-okomanantu as nan am-in ay tataku asna's luta. Nalintigtu nan atuna ay mun-okóm babaen as nan usa ay taku ay pinilina. Penaneknekan Apo Dios na as nan am-in ay tataku babaen as nan nangtakuwana kan hiya manipud as nan utúy.” ");
INSERT INTO ebk_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kuncha pay chinngor nan kenalen Pablo maepangkep as nan matakuwan manipud as nan utúy, nan tapina at enot-otyokcha hiya. Ngem wachacha nan tapina ay nangali, “Laychunmi ay chungrun kasin kan he-a nan maepangkep as nan kenalem.” ");
INSERT INTO ebk_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","As nan hiyachi, tenaynan Pablo chicha. ");
INSERT INTO ebk_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ngem wachacha nan tapina ay inmunud kan Pablo ya enmafurot kan Jesus. Nan usa kan chicha at hi Dionisio ay usa ay membron nan Areopago. Nan usa us at fiafiai ay nan ngachana at Damaris, ya wachacha pay nan tapina. ");
INSERT INTO ebk_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kun pay narpas sa, nak-ak hi Pablo ad Atenas, ya inmuy hiya ad Corinto. ");
INSERT INTO ebk_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Hid-i nan nangam-ammuwana as nan usa ay Judio ay nan ngachana at Akila ay naiyanak ad Ponto. Kaar-ali hiya ay nurpu ad Italia ay kadwana hi asawana ay Priscila, tay infilin Emperador Claudio ay am-in nan Judio at mak-akcha ad Roma. Uy finisitan Pablo chicha. ");
INSERT INTO ebk_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kiapú ta pachongna chicha ay mun-am-amma as fiawi ay naamma as larat, nakeafong ya nakidnu hiya kan chicha. ");
INSERT INTO ebk_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kun kay Urkiw ay Mun-iblayan un inmuy hi Pablo as nan senagoga ay uy makeap-apat ta awisuna nan chiyuycha Judio ya nan chiyuycha Griego. ");
INSERT INTO ebk_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kun pay inumchan cha Silas kan Timoteo ad Corinto as nan nurpuwancha ad Macedonia, kun yangkiay nun-ekaskasaba hi Pablo ay mangepanpaneknek as nan chiyuycha Judio ay hi Jesus nan Cristo. ");
INSERT INTO ebk_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kuncha pay kenontra ya enkak-aliyan hiya, inyagyagna nan tapok as fiachuna ta epailana ay maid at fiyangna kan chicha, ya kanana, “Chakayu ay mismu nan kikiad as nan machusaanyu! Maid fiasorku's sa. Munlapu ad wani, umuyak as nan chiyuycha Gentil.” ");
INSERT INTO ebk_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nak-ak hiya hid-i, ya uy nakepagyan as nan afong nan usa ay laraki ay nan ngachana at Ticio Justo ay manangchaychayaw kan Apo Dios. Nan afongna at naesasag-un as nan senagoga. ");
INSERT INTO ebk_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Hi Crispo ay ap-apu as nan senagoga at enmafurot kan Apo Jesus patí nan pamilyana. Nan ongor us as nan i-Corinto ay nanngor as nan enkaskasaban Pablo at enmafurotcha ya nunpafunyagcha. ");
INSERT INTO ebk_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","As nan henlafi, kenalen nan Apo kan Pablo babaen as nan kaman iitaw, “Achika umug-ugyat. Kunmu at iturturuy ay mun-ekaskasaba, ya achim ikinkinak nan cham at-atun, ");
INSERT INTO ebk_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","tay wachaak kan he-a. Maid taku ay mamusfusor ay mangsukiat kan he-a, tay ongor nan tatakok henan nauy ay siyudad.” ");
INSERT INTO ebk_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Isunga nakepagyan hi Pablo hid-i as usa ay tawwun ya unum ay furan ay nangisursuru as kalen Apo Dios as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kun pay nun-gobernador hi Galion ad Acaya, nun-us-usacha nan Judio ay naniliw kan Pablo, ya inyuycha as nan kurti. ");
INSERT INTO ebk_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Kenalicha, “Hi tona ay taku at chana sugsukian nan tataku ta nan atuncha ay munchaychayaw kan Apo Dios at maekontra as nan lintig.” ");
INSERT INTO ebk_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Uy koma munkali hi Pablo, ngem nunkanan Galion as nan chiyuycha Judio, “Mu nan charumyu at maepangkep as nan achi ustu winnu mangotettet ay naekaman, mafialin ay uray anosak ay chumngor kan chakayu ay Judio. ");
INSERT INTO ebk_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ngem kiapú ta maepangkep yangkiay as nan chiyuycha kali, ngachan ya nan lintig ay chayu un-unuchun, kikiad kayu's sa ay mangenongnong. Achek laychun ay ha-un chi mangokóm as nan hanacha.” ");
INSERT INTO ebk_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Angkiay ya enpak-akna chicha as nan kurti. ");
INSERT INTO ebk_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","As nan hiyachi, lenabkischa hi Sostenes ay ap-apu as nan senagoga, ya penak-opak-orcha hiya as nan sangwanan nan kurti. Ngem kun inyangkiayan Galion chicha. ");
INSERT INTO ebk_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Nakepagyan hi Pablo ad Corinto as ongor pay ay urkiw as nan iib-ana ay omaafurot. Angkiay ya as nan nanaynanana kan chicha ay uy munpapor ay munfiangad ad Siria ay kadwana cha Priscila kan Akila. Nanarcharancha at inmuy ad Cencrea ay hid-i nan nunpaapollokan Pablo ta mangepail-ana ay natongpar nan ensapatana kan Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kun pay inumchan nan papor ad Efeso, tenaynan Pablo cha Priscila kan Akila. Inmuy hiya as nan senagoga, ya nakesossosek as nan chiyuycha Judio. ");
INSERT INTO ebk_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Chinawatcha kan hiya ay mafiayfiayag pay koma hiya hid-i, ngem chaana lenayad. ");
INSERT INTO ebk_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kun at as nan nunpakachaana kan chicha, kenalina kan chicha, “Munfiangachaktu kan chakayu mu eparufus Apo Dios.” Angkiay ya nunlukian hiya as nan papor ay mak-ak ad Efeso. ");
INSERT INTO ebk_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kun pay inumchan hiya ad Cesarea, enmabrat ad Jerusalem ay uy mangepakomosta as nan chiyuycha omaafurot hid-i. Angkiay kinmuwab ad Antiokia. ");
INSERT INTO ebk_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kun pay inmuy chi kaat ay timpuna hid-i, nak-ak hiya, ya inmuy henan sakop nan Galacia ya Frigia ay cha mangepappapigsa as pammaten nan am-in ay omaafurot. ");
INSERT INTO ebk_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","As nan hiyachi us ay timpu, wacha nan usa ay Judio ay enmali ad Efeso ay nan ngachana at Apolos ay i-Alejandria. Naraing hiya ay mun-isuru ya ongor chi ammuna as nan naisurat as nan Kalen Apo Dios. ");
INSERT INTO ebk_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Naisursuruwan hiya as nan makali un Charan Apo Jesus, ya makakud hiya ay nangifiagfiakia ya nangisursuru ay ustu as nan maepangkep kan Jesus. Ngem nan ammuna yangkiay at nan funyag ay insuron Juan. ");
INSERT INTO ebk_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Enlapuna ay mun-isuru ay wachay turudna as nan senagoga. Kun pay chinngor cha Priscila kan Akila nan chana kankanan, enayakiancha hiya as afongcha, ya enlawlawagcha kan hiya nan achina pay laing ammu maepangkep kan Jesus ya nan charan ay muntoróng as nan panangesarakan Apo Dios as nan tataku. ");
INSERT INTO ebk_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kun pay plenanon Apolos ay kumchang ad Acaya, penapigsan nan iib-a ay omaafurot ad Efeso nan numnumna. Nunsuratcha as nan iib-a ay omaafurot ay wacha ad Acaya ta ayakianchantu hi Apolos mu umchan hiya hid-i. Kun pay inumchan hiya hid-i, ongor chi infiachangna as nan chi