﻿USE sofia;
DROP TABLE IF EXISTS sofia.dyu_vpl;
CREATE TABLE dyu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dyu_vpl WRITE;
INSERT INTO dyu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Fɔlɔfɔlɔ, Ala ka sankolo dan, ka dugukolo dan. ");
INSERT INTO dyu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dugukolo tun ma labɛn fɔlɔ; a lakolonba tun lo. Ji dunba le tun bɛ yi; a yɔrɔ bɛɛ tun ye dibi le ye. Nka Ala Nin tun bɛ lamagara jiw kunna. ");
INSERT INTO dyu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ala ko: «Yeelen ye bɔ!» Yeelen bɔra. ");
INSERT INTO dyu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ala k’a ye ko yeelen ka ɲi. A ka yeelen ni dibi faran ka o bɔ ɲɔgɔn na. ");
INSERT INTO dyu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","A ka yeelen wele ko «tere», ka dibi wele ko «su». Ayiwa, su kora ka o dugu gbɛ; o kɛra lon fɔlɔ ye. ");
INSERT INTO dyu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","O kɔ, Ala ko tuun ko: «Furancɛ dɔ ye kɛ jiw cɛ ma, ka jiw taran fla ye ka o bɔ ɲɔgɔn na.» ");
INSERT INTO dyu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ala ka o furancɛ kɛ. Ji minw bɛ san fɛ, ani ji minw bɛ dugu ma, a ka olugu faran ka o bɔ ɲɔgɔn na, ka furancɛ kɛ o cɛ ma. Ala k’a fɔ cogo min na, a kɛra ten. ");
INSERT INTO dyu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ala ka o furancɛ wele ko «sankolo». Ayiwa, su kora ka o dugu gbɛ; o kɛra lon flanan ye. ");
INSERT INTO dyu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","O kɔ, Ala ko tuun ko: «Ji minw bɛ sankolo jukɔrɔ, olugu bɛɛ ye lajɛn yɔrɔ kelen na; yɔrɔ tɔ ye kɛ yɔrɔjalan ye.» Ala k’a fɔ cogo min na, a kɛra ten. ");
INSERT INTO dyu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ala ka yɔrɔjalan wele ko «dugukolo»; jiw bɛɛ lajɛnna yɔrɔ min na, a ka o wele ko «kɔgɔji». Ala k’a ye ko o ka ɲi. ");
INSERT INTO dyu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ayiwa, Ala ko, ko binw ye falen dugukolo kan, ka o kisɛw kɛ o ra; ko yiridentaw fana ye wuri, ka den ka kaɲa ni o suguyaw ye, kisɛw walama kolo bɛ kɛ minw denw na. Ala k’a fɔ cogo min na, a kɛra ten. ");
INSERT INTO dyu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Dugukolo ka binw bɔ ka o kisɛw kɛ o ra ka kaɲa ni o suguyaw ye. Yiriw fana wurira, ka den, ka o kisɛw, walama o kolow kɛ o denw na, ka kaɲa ni o suguyaw ye. Ala k’a ye ko o ka ɲi. ");
INSERT INTO dyu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ayiwa, su kora ka o dugu gbɛ. O kɛra lon sabanan ye. ");
INSERT INTO dyu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ala ko, ko fɛn minw bɛ yeelen bɔ, olugu ye kɛ sankolo ra, ka tere ni su faranfasi ka o bɔ ɲɔgɔn na. O ye kɛ tagamasiyɛn ye ka wagatiw yira, ka lonw yira, ani ka sanw yira. ");
INSERT INTO dyu_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","O fɛnw ye kɛ sankolo kɔnɔ, ka yeelen bɔ dugukolo kan. Ayiwa, Ala k’a fɔ cogo min na, a kɛra ten. ");
INSERT INTO dyu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ala ka yeelenbɔnan belebele fla kɛ. A bɛɛ ra belebeleba, a ka o sigi terefɛwagati kunna; ka fitini sigi sufɛwagati kunna. A ka lolow fana kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ala ka o fɛnw bla sankolo ra, janko o ye yeelen bɔ dugukolo kan. ");
INSERT INTO dyu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","A ka kelen sigi terefɛwagati kunna, ka kelen sigi sufɛwagati kunna, janko o ye yeelen ni dibi faran ka bɔ ɲɔgɔn na. Ala k’a ye ko o ka ɲi. ");
INSERT INTO dyu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Su kora, ka o dugu gbɛ. O kɛra lon naaninan ye. ");
INSERT INTO dyu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ayiwa, Ala ko: «Fɛnɲanaman dɔw ye kɛ jiw ra, ka caya. Kɔnɔw fana ye wuri san ni dugu cɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ala ka kɔgɔji danfɛn barakamanw dan, ani jirafɛn ɲanaman tɔw bɛɛ; o fɛnw bɛɛ kɛra ji ra caman, ka kaɲa ni o suguyaw ye. Ala ka kɔnɔw fana dan, ka kaɲa ni o suguyaw ye. A k’a ye ko o ka ɲi. ");
INSERT INTO dyu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ala ka baraka don o ra, ko o ye woro, ka caya ka kɔgɔjiw fa. A ko kɔnɔw fana ye caya dugukolo kan. ");
INSERT INTO dyu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ayiwa, su kora, ka o dugu gbɛ. O kɛra lon loorunan ye. ");
INSERT INTO dyu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ala ko tuun ko fɛnɲanamanw ye kɛ dugukolo kan ka kaɲa ni o suguyaw ye: bɛganw, ani kongosogow, ani fɛn minw bɛ fofo, o bɛɛ ni o suguya. Ala k’a fɔ cogo min na, a kɛra ten. ");
INSERT INTO dyu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ala ka kongosogow bɛɛ dan, o bɛɛ ni o suguya, ka bɛganw dan, o bɛɛ ni o suguya, ani fɛn minw bɛ fofo, o bɛɛ ni o suguya. Ala k’a ye ko o ka ɲi. ");
INSERT INTO dyu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","O bɛɛ kɔ, Ala ko: «Ayiwa, sisan, an ye mɔgɔ dan ka kaɲa ni an yɛrɛ cogo ye, a ye bɔ an fɛ, janko ale ye kɛ jɛgɛw bɛɛ kunna, ka kɛ kɔnɔw kunna, ka kɛ bɛganw ni kongosogow kunna, ka sigi dugukolo bɛɛ kunna, ani fɛnɲanaman minw bɛɛ bɛ dugukolo kan.» ");
INSERT INTO dyu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ala ka mɔgɔ dan ka kaɲa ni a yɛrɛ cogo ye; a k’a dan ka kaɲa ni ale Ala yɛrɛ cogo ye. A ka o dan, cɛ ni muso. ");
INSERT INTO dyu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ala ka baraka don o ra; a ko: «Aw ye den caman sɔrɔ, ka caya ka dugukolo yɔrɔ bɛɛ fa, ka aw ta fanga sigi dugukolo kan, ka kɛ jɛgɛw bɛɛ kunna, ani kɔnɔw, ani fɛnɲanaman o fɛnɲanaman bɛ dugukolo kan.» ");
INSERT INTO dyu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ala k’a fɔ o ye tuun ko: «A flɛ, bin o bin bɛ falen dugukolo kan, ani a den, ani yiri o yiri bɛ den, k’a kisɛw, walama a kolo kɛ a denw kɔnɔ, ne bɛ o bɛɛ di aw ma, o bɛ kɛ aw ta baro ye. ");
INSERT INTO dyu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Dugukolo bɛganw bɛɛ, ani kɔnɔw bɛɛ, ani fɛnɲanaman o fɛnɲanaman bɛ dugukolo kan, o kɔrɔ ye ko fɛn o fɛn bɛ nɛnɛkiri, ne bɛ bin di olugu ma, ka o kɛ o ta baro ye.» Ayiwa, Ala k’a fɔ cogo min na, a kɛra ten. ");
INSERT INTO dyu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ala tun ka fɛn o fɛn kɛ, a ka o bɛɛ flɛ, k’a ye ko o bɛɛ ka ɲi kosɛbɛ. Su kora, ka o dugu gbɛ; o kɛra lon wɔɔrɔnan ye. ");
INSERT INTO dyu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ayiwa, sankolo ni dugukolo ni o kɔnɔfɛnw bɛɛ danna ka ban o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ala k’a ta baara kɛ ka ban tere wɔɔrɔ kɔnɔ; a tere wolonflanan, a nɛnɛkirira a ta baara bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ala ka baraka don tere wolonflanan na, k’a kɛ lon saninman ye; sabu o lon le ra, a nɛnɛkirira a ta baara bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ayiwa, wagati min Masa Ala ka danni kɛ, sankolo ni dugukolo danna nin cogo le ra. Ala ka sankolo ni dugukolo dan tuma min na, ");
INSERT INTO dyu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","kongoyiri si tun tɛ dugukolo kan fɔlɔ, bin si fana tun ma falen fɔlɔ; sabu Masa Ala tun ma sanji ben dugukolo kan fɔlɔ, ani mɔgɔ si fana tun tɛ yi fɔlɔ ka dugukolo sɛnɛ. ");
INSERT INTO dyu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Bugun dɔ le tun bɛ bɔ dugukolo ra ka kɛ ji ye ka dugukolo yɔrɔ bɛɛ sɔn. ");
INSERT INTO dyu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Masa Ala ka dugukolo bɔgɔ ta ka mɔgɔ lalaga ni a ye. O kɔ, a ka ɲanamanya nɛnɛkiri fiyɛ ni a dafɔɲɔ ye k’a don mɔgɔ nunwo fɛ; a kɛra mɔgɔ ɲanaman ye. ");
INSERT INTO dyu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","O kɔ, Masa Ala ka yirituɲuman dɔ kɛ Edɛni jamana ra, terebɔyanfan na, ka mɔgɔ bla o kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Matigi Ala ka yiri suguya bɛɛ falen dugukolo kan; yiri cɛɲumanw, minw den ka di; a ka ɲanamanya yiri bla yiritu cɛmancɛ ra, ani yiri min b’a to mɔgɔ bɛ koɲuman ni kojugu lɔn ka bɔ ɲɔgɔn na. ");
INSERT INTO dyu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ba dɔ tun bɛ woyo ka bɔ Edɛni jamana ra. O ba ji le tun bɛ woyo ka tɛmɛ yiritu kɔnɔ; o kɔ, a bɛ taran ka kɛ boro naani wɛrɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","O ba fɔlɔ tɔgɔ ye ko Pisɔn; ale bɛ woyo ka tɛmɛ Havila jamana bɛɛ kɔnɔ. Sanin bɛ o jamana le ra. ");
INSERT INTO dyu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","O sanin ye sanin bɛɛ ra ɲumanman le ye. Turu kasadiman dɔ fana bɛ sɔrɔ yi, min tɔgɔ ye ko bideliyɔmu, ani lulu bisigi dɔ, min tɔgɔ ye ko onikisi. ");
INSERT INTO dyu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ba flanan tɔgɔ ye ko Giyɔn; ale bɛ woyo ka tɛmɛ Kusi jamana bɛɛ kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ba sabanan tɔgɔ ye ko Tigere. Ale bɛ woyo Asiri jamana terebɔyanfan na. Ba naaninan tɔgɔ le ye ko Efirati. ");
INSERT INTO dyu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ayiwa, Matigi Ala ka mɔgɔ bla Edɛni yirituɲuman kɔnɔ, ko a ye a sɛnɛ, k’a kɔrɔsi. ");
INSERT INTO dyu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ala ka nin kuma fɔ mɔgɔ ye ko: «I bɛ se ka yiritu yiridenw bɛɛ dɔ domu. ");
INSERT INTO dyu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Nka yiri min b’a to mɔgɔ bɛ koɲuman walama kojugu lɔn, i kana o yiri den domu dɛ! Sabu ni i k’a dɔ domu lon o lon, sigiya t’a ra, i bɛna sa.» ");
INSERT INTO dyu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ayiwa, o kɔ, Matigi Ala ko: «Cɛ ye to a kelen na tan, o man ɲi. Ne bɛna dɛmɛbaga kɛ a ye, min bɛ bɛn a ma.» ");
INSERT INTO dyu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Masa Ala tun ka bɔgɔ ta ka kongosogow bɛɛ lalaga, ani kɔnɔw. O kɔ, a tun ka o bɛɛ lana cɛ fɛ, k’a flɛ a bɛna tɔgɔ min la o bɛɛ kelen kelen na, ani janko ni cɛ ka tɔgɔ min la fɛnɲanaman min na, o le ye kɛ a tɔgɔ ye. ");
INSERT INTO dyu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Cɛ tun ka tɔgɔ la bɛganw bɛɛ ra, ani kɔnɔw, ani kongosogow bɛɛ. Nka o fɛnw bɛɛ cɛ ra, a tun ma dɛmɛbaga sɔrɔ a yɛrɛ ra, min tun bɛ se ka bɛn ale ma. ");
INSERT INTO dyu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ayiwa, Masa Ala ka sunɔgɔba bla cɛ ra. Ka cɛ to sunɔgɔ ra, a k’a garagakolo kelen bɔ, ka sogobu kɛ ka o nɔ datugu. ");
INSERT INTO dyu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","O garagakolo min bɔra cɛ ra, Masa Ala ka o le ta k’a kɛ muso ye, ka na ni o muso ye cɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kabini cɛ ka muso ye, a ko: «Ɔnhɔn! Sisan kɔni, nin ye ne ɲɔgɔn dɔ yɛrɛ le ye. A kolow ye ne kolo dɔw le ye, a farisogo fana ye ne farisogo dɔ le ye. A tɔgɔ bɛna la ko muso, sabu a bɔra cɛ le ra.» ");
INSERT INTO dyu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","O le kosɔn cɛ bɛ bɔ a facɛ ni a bamuso kɔrɔ ka nɔrɔ a muso ra; o fla bɛ jɛn ka kɛ mɔgɔ kelen ye. ");
INSERT INTO dyu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ayiwa, o wagati ra cɛ ni muso fla bɛɛ fari lakolon tun lo; o tun m’a lɔn fɛn min tɔgɔ ye ko maroya. ");
INSERT INTO dyu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ayiwa, Masa Ala tun ka kongosogo minw bɛɛ dan, sa le tun ka cegu ni o bɛɛ ye. Lon dɔ, sa nana a fɔ muso ye ko: «Yala can lo ko Ala ko, ko aw kana yiritu yiriden si domu wa?» ");
INSERT INTO dyu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Muso ko: «An bɛ se ka yiritu yiridenw domu kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Nka yiri min bɛ yiritu cɛmancɛ ra, Ala ko an kana o le den domu, ko hali an kana maga a ra; ko ni o tɛ, an bɛna sa.» ");
INSERT INTO dyu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Sa ko muso ma ko: «Can tɛ, aw tɛna sa. ");
INSERT INTO dyu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ala ka o fɔ sabu a k’a lɔn ko ni aw ka yiri nin den domu lon o lon, aw ɲaw bɛ yɛlɛ, aw bɛ kɛ i n’a fɔ ale Ala; aw bɛna koɲuman lɔn ka bɔ kojugu ra.» ");
INSERT INTO dyu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ayiwa, muso k’a ye ko can ra yiri nin den ka kan ka diya; ni i k’a flɛ a cɛ ka ɲi, a fana bɛ se ka mɔgɔ hakiri yɛlɛ ka i kɛ kolɔnbaga ye. Muso ka dɔ tigɛ k’a domu. A cɛ tun lɔnin bɛ a kɔrɔ; a ka dɔ di ale ma, ale fana k’a domu. ");
INSERT INTO dyu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","O k’a domu minkɛ, o ka o yɛrɛ cogoya ye; o k’a ye ko o fari lakolon lo. O ka toroflaburu dɔw sirisiri ɲɔgɔn na, ka o kɛ ka o yɛrɛ datugu. ");
INSERT INTO dyu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ayiwa, wuladanin fɛ, cɛ ni muso ka Matigi Ala mankan mɛn, a bɛ yaalayaalara yiritu kɔnɔ. O borira Matigi Ala ɲa ka taga dogo yiritu yiri dɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Matigi Ala ka cɛ wele ko: «Adama, i bɛ min?» ");
INSERT INTO dyu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Cɛ ka Ala jaabi ko: «Ne ka i mankan mɛn yiritu ra, ne siranna sabu ne fari lakolon lo; o kosɔn ne dogora.» ");
INSERT INTO dyu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Matigi Ala ko: «Jɔn le k’a fɔ i ye ko i fari lakolon lo? Ne tun ko aw kana yiri min den domu, kɔni i ma o le domu dɛ?» ");
INSERT INTO dyu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Cɛ ko: «I ka muso min bla ne kɔrɔ, ale le ka dɔ di ne ma, ne k’a domu.» ");
INSERT INTO dyu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Matigi Ala ka muso ɲininka ko: «Mun na ele ka o kɛ?» Muso ko: «Sa le ka ne nɛgɛ, k’a to ne k’a domu.» ");
INSERT INTO dyu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Matigi Ala k’a fɔ sa ye ko: «I n’a fɔ ele sɔnna ka o kɛ, ne bɛna i danga bɛganw ni kongosogo tɔw bɛɛ cɛ ra. Sisan i bɛna to ka fofo i kɔnɔbara le kan, buguri bɛ to ka don i da ra, i bɛ a domu, fɔ ka taga i sa. ");
INSERT INTO dyu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ne bɛna juguya le bla ele ni muso cɛ, ka o juguya kelen bla i ta duruja ni muso ta duruja cɛ. Ni o ka i sɔrɔ, o bɛ i kun ci; ni ele fana ka o sɔrɔ, i bɛ o kin o senju ra.» ");
INSERT INTO dyu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ala k’a fɔ muso ye ko: «Ne bɛna dɔ fara i ta denworo sɛgɛ kan. I bɛna tɔɔrɔ ka sɔrɔ ka den woro. Ka fara o kan, i ta cɛ lɔgɔ bɛna to ka kɛ i ra; i ta ko bɛɛ bɛna to ale le boro fana.» ");
INSERT INTO dyu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ala k’a fɔ cɛ ye ko: «I sɔnna ka i ta muso kan le mɛn, ani ne tun kumana i fɛ k’a fɔ i ye ko i kana yiri min den domu, i ka o domu; ayiwa, dugukolo bɛna danga ele kosɔn. I bɛna sɛgɛ le kosɛbɛ ka sɔrɔ ka i ta baro sɔrɔ ka bɔ dugukolo ra, fɔ ka taga i sa; ");
INSERT INTO dyu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ŋaniw ni binjugu dɔw bɛna falen dugukolo kan; i bɛna fɛn minw sɛnɛ, o le bɛna kɛ i ta baro ye. ");
INSERT INTO dyu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","I bɛna baara kɛ ka wasi le, ka sɔrɔ ka i ta baro sɔrɔ, fɔ i ye na kɔsegi dugukolo ra yi tuun, i danna ni o dugukolo kelen min bɔgɔ ye; sabu i ye bɔgɔ le ye, i fana bɛna sekɔ ka kɛ o bɔgɔ kelen le ye.» ");
INSERT INTO dyu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ayiwa, Adama k’a muso tɔgɔ la ko Awa, sabu ale le kɛra mɔgɔw bɛɛ bamuso ye. ");
INSERT INTO dyu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Matigi Ala ka bɛgan dɔw gbolow kɛ fani ye, ka o don Adama ni a muso ra. ");
INSERT INTO dyu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Matigi Ala ko: «Sisan mɔgɔ kɛra i n’a fɔ an dɔ, a bɛ koɲuman ni kojugu lɔn ka bɔ ɲɔgɔn na. An ye a bari a kana ɲanamanya yiriden dɔ tigɛ k’a domu; ni o tɛ, ni a ka o domu a ɲanaman bɛ to wagati bɛɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","A kɛra ten, Matigi Ala ka o gbɛn ka bɔ Edɛni jamana yiritu ra, ko o ye taga dugukolo sɛnɛ, Ala ka o dan ni dugukolo min bɔgɔ ye. ");
INSERT INTO dyu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ayiwa, Ala ka Adama ni Awa gbɛn o cogo le ra. A ka serubɛn mɛlɛkɛ* dɔw bla Edɛni yiritu donda ra terebɔyanfan na, k’a kɔrɔsi, ani kɛrɛkɛmuru dɔ, min bɛ manamana i ko tasuma, ka yɛlɛmayɛlɛma, janko mɔgɔ si kana sira sɔrɔ ka se ɲanamanya yiri ma. ");
INSERT INTO dyu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ayiwa, Adama jɛnna ni a muso Awa ye. Awa ka kɔnɔ ta ka Kabila woro. Awa ko: «Matigi Ala baraka ra, ne ka cɛden sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","O kɔ, a ka kɔnɔ ta tuun ka Kabila dɔgɔnin Abila woro. Abila nana kɛ sagagbɛnbaga ye; Kabila, ale kɛra sɛnɛkɛbaga ye. ");
INSERT INTO dyu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Wagati dama tɛmɛnin kɔ, Kabila k’a ta foro yiriden dɔw kɛ saraka ye, ka o di Ala ma. ");
INSERT INTO dyu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abila fana k’a ta sagaden fɔlɔw kelen mina, ka o faga, ka o sogo yɔrɔɲumanw jɛni, ka o kɛ saraka ye, ka o di Ala ma. Abila ni a ta saraka ko diyara Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Nka Kabila ni a ta saraka ko ma diya Matigi Ala ye. Kabila dimina o ra, k’a ɲa kumu kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ayiwa, Matigi Ala ko Kabila ma ko: «Mun kosɔn i dimina fɔ ka i ɲa kumu tan? ");
INSERT INTO dyu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ni i ka kɛwaleɲumanw kɛ, i kun bɛ kɔrɔta. Nka ni i ta kɛwalew juguyara, o tuma jurumun bɛna kɛ i kɔ tuma bɛɛ; a b’a fɛ ka se i ra, nka ele le ka kan ka se jurumun na.» ");
INSERT INTO dyu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ayiwa, lon dɔ, Kabila k’a fɔ a dɔgɔcɛ ye ko o ye taga kongo ra. Ka o to kongo ra yi, a benna a dɔgɔcɛ kan, k’a faga. ");
INSERT INTO dyu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Matigi Ala k’a fɔ Kabila ye ko: «Kabila, i dɔgɔcɛ Abila do?» Kabila ko: «Ne m’a yɔrɔ lɔn; o tuma ne le blara ka kɛ ale kɔrɔsibaga ye wa?» ");
INSERT INTO dyu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Matigi ko: «I ka mun ko le kɛ tan? I dɔgɔcɛ fagari jori kulekan bɛ bɔra dugu ma ka se ne ma, ko ne ye a dimibɔ. ");
INSERT INTO dyu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ayiwa, i yɛrɛ boro ka i dɔgɔcɛ faga k’a jori seri dugukolo kan, k’a to dugukolo ye a jori min minkɛ, o kosɔn dugukolo banna i ra. ");
INSERT INTO dyu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","K’a ta sisan, hali ni i ka dugukolo sɛnɛ, a tɛna den i ye k’a siman di i ma tuun. I bɛna bla i yɛrɛ ma ka yaala ka lamini dugukolo kan.» ");
INSERT INTO dyu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kabila k’a fɔ Matigi Ala ye ko: «I ka tɔɔrɔ min la ne kan, o ka gbiri ka tɛmɛ; ne tɛna se. ");
INSERT INTO dyu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","A flɛ, i ka ne gbɛn ka bɔ yan dugukolo kan. Ne bɛna taga dogo i ɲa fɔ yɔrɔjan. Ne bɛna to ne yɛrɛ ma ka yaala ka lamini yɔrɔ bɛɛ; ni mɔgɔ o mɔgɔ ka ne sɔrɔ, o tigi bɛna ne faga.» ");
INSERT INTO dyu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Matigi Ala ko Kabila ma ko: «Ni mɔgɔ o mɔgɔ ka Kabila faga, o juru bɛna sara o tigi ra fɔ siɲaga wolonfla, ka Kabila dimibɔ.» Matigi Ala ka tagamasiyɛn dɔ bla Kabila kan, janko ni mɔgɔ min k’a ye, o tigi kana a faga. ");
INSERT INTO dyu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","O kɔ, Kabila bɔra Matigi Ala kɔrɔ ka taga yɔrɔjan, ka taga to Nɔdi jamana ra, Edɛni jamana terebɔyanfan na. ");
INSERT INTO dyu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ayiwa, o kɔ, Kabila jɛnna ni a muso ye. A muso ka kɔnɔ ta ka dencɛ woro; o le kɛra Henɔki ye. O kɔ, Kabila ka dugu dɔ lɔ, k’a dencɛ Henɔki tɔgɔ la o dugu ra. ");
INSERT INTO dyu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ayiwa, Henɔki nana Iradi woro; Iradi ka Mehuyahɛli woro; Mehuyahɛli ka Metusahɛli woro; Metusahɛli ka Lemɛki woro. ");
INSERT INTO dyu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemɛki nana muso fla le ta. Kelen tɔgɔ tun ye ko Ada, tɔ kelen tɔgɔ tun ye ko Sila. ");
INSERT INTO dyu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ka dencɛ woro; o le kɛra Yabali ye. Mɔgɔ minw bɛ si fanibonw kɔnɔ ka o ta bɛganw kɔrɔsi, Yabali le kɛra olugu bɛmacɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabali dɔgɔcɛ kɛra Yubali ye. Ale le kɛra gɔnifɔbagaw ni filenfiyɛbagaw bɛɛ bɛmacɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila fana ka dencɛ woro; o le kɛra Tubali Kabila ye. Ale kɛra numu le ye; a tun bɛ siranɛgɛfɛnw ni nɛgɛmanfɛnw lalaga. Dɔgɔmuso gbanna Tubali Kabila ra; o tɔgɔ lara ko Naama. ");
INSERT INTO dyu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lon dɔ, Lemɛki ko a ta musow ma ko: «Ada ni Sila, aw ye mɛnni kɛ! Ne Lemɛki ta musow, aw ye aw toro malɔ ne darakan na! Ni cɛ o cɛ boro ka se ne ma, ne bɛ o faga le; ni kanbelen o kanbelen ka ne mandimi, ne bɛ o faga le. ");
INSERT INTO dyu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","A fɔra ko ni mɔgɔ min ka Kabila faga, o juru bɛ sara o tigi ra fɔ siɲaga wolonfla; nka ne Lemɛki, ne ta juru bɛ sara fɔ siɲaga biwolonfla ni wolonfla.» ");
INSERT INTO dyu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ayiwa, Adama jɛnna ni a muso ye tuun. A ka kɔnɔ ta ka jigi dencɛ ra. A ka o tɔgɔ la ko Sɛti. A ko: «Sabu Kabila ka Abila faga; Ala le ka dencɛ wɛrɛ di ne ma Abila nɔ ra.» ");
INSERT INTO dyu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ayiwa, Sɛti fana nana kɔrɔ ka dencɛ sɔrɔ. A k’a tɔgɔ la ko Enɔsi. O wagati le ra, mɔgɔw ka kɛ Matigi Ala tɔgɔ wele ye, k’a bato. ");
INSERT INTO dyu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ayiwa, Adama ta durujaw tɔgɔw le sɛbɛra nin ye: Ala ka mɔgɔ dan lon min na, a k’a dan ka kaɲa ni ale Ala yɛrɛ cogo le ye. ");
INSERT INTO dyu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","A ka o dan, cɛ ni muso. A ka o dan minkɛ, a ka baraka don o ra, ka o tɔgɔ la ko mɔgɔ. ");
INSERT INTO dyu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ka Adama si to san kɛmɛ ni san bisaba, a ka dencɛ woro, ka kaɲa ni a yɛrɛ cogo ye; a bɔra a fɛ. A ka o dencɛ tɔgɔ la ko Sɛti. ");
INSERT INTO dyu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sɛti woronin kɔ, Adama ka san kɛmɛ seegi le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","A si bɛɛ lajɛnnin kɛra san kɛmɛ kɔnɔntɔn ni san bisaba. O kɔ, a sara. ");
INSERT INTO dyu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ka Sɛti si to san kɛmɛ ni san looru, a ka dencɛ woro; a ka o tɔgɔ la ko Enɔsi. ");
INSERT INTO dyu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enɔsi woronin kɔ, Sɛti ka san kɛmɛ seegi ni san wolonfla le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɛti si bɛɛ lajɛnnin kɛra san kɛmɛ kɔnɔntɔn ni san tan ni fla. O kɔ, a sara. ");
INSERT INTO dyu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ka Enɔsi si to san bikɔnɔntɔn, a ka Kenan woro. ");
INSERT INTO dyu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan woronin kɔ, Enɔsi ka san kɛmɛ seegi ni san tan ni looru le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enɔsi si bɛɛ lajɛnnin kɛra san kɛmɛ kɔnɔntɔn ni san looru; o kɔ, a sara. ");
INSERT INTO dyu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ka Kenan si to san biwolonfla, a ka Mahalalɛli woro. ");
INSERT INTO dyu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalɛli woronin kɔ, Kenan ka san kɛmɛ seegi ni san binaani le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan si bɛɛ lajɛnnin kɛra san kɛmɛ kɔnɔntɔn ni san tan. O kɔ, a sara. ");
INSERT INTO dyu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ka Mahalalɛli si to san biwɔɔrɔ ni looru, a ka Yɛrɛdi woro. ");
INSERT INTO dyu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yɛrɛdi woronin kɔ, Mahalalɛli ka san kɛmɛ seegi ni san bisaba le kɛ. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalɛli si bɛɛ lajɛnnin kɛra san kɛmɛ seegi ni san bikɔnɔntɔn ni san looru. O kɔ, a sara. ");
INSERT INTO dyu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ka Yɛrɛdi si to san kɛmɛ ni san biwɔɔrɔ ni san fla, a ka Enɔki woro. ");
INSERT INTO dyu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enɔki woronin kɔ, Yɛrɛdi ka san kɛmɛ seegi le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yɛrɛdi si bɛɛ lajɛnnin kɛra san kɛmɛ kɔnɔntɔn ni san biwɔɔrɔ ni san fla. O kɔ, a sara. ");
INSERT INTO dyu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ka Enɔki si to san biwɔɔrɔ ni san looru, a ka Metusalɛmu woro. ");
INSERT INTO dyu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusalɛmu woronin kɔ, Enɔki tagamana ka kaɲa ni Ala sago ye tuun fɔ san kɛmɛ saba. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enɔki si bɛɛ lajɛnnin kɛra san kɛmɛ saba ni san biwɔɔrɔ ni san looru. ");
INSERT INTO dyu_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enɔki tagamana ka kaɲa ni Ala sago ye. O kɔ, a ma kɛ dunuɲa ra tuun; Ala k’a ta ka taga ni a ye a yɛrɛ kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ka Metusalɛmu si to san kɛmɛ ni san biseegi ni san wolonfla, a ka Lemɛki woro. ");
INSERT INTO dyu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemɛki woronin kɔ, Metusalɛmu ka san kɛmɛ wolonfla ni san biseegi ni san fla le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusalɛmu si bɛɛ lajɛnnin kɛra san kɛmɛ kɔnɔntɔn ni san biwɔɔrɔ ni san kɔnɔntɔn. O kɔ, a sara. ");
INSERT INTO dyu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ka Lemɛki si to san kɛmɛ ni san biseegi ni san fla, a ka dencɛ woro. ");
INSERT INTO dyu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","A k’a tɔgɔ la ko Nuho, k’a fɔ ko: «Ala ka dugukolo danga, ka an bla baaragbɛlɛn minw na dugukolo kan, nin den le bɛna an jusu saaro, ka an bɔ o baaraw sɛgɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuho woronin kɔ, Lemɛki ka san kɛmɛ looru ni san bikɔnɔntɔn ni san looru le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemɛki si bɛɛ lajɛnnin kɛra san kɛmɛ wolonfla ni san biwolonfla ni san wolonfla. O kɔ, a sara. ");
INSERT INTO dyu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ka Nuho si to san kɛmɛ looru, a ka Sɛmu, ani Kamu, ani Zafɛti woro ka gban ɲɔgɔn na. ");
INSERT INTO dyu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ayiwa, mɔgɔw nana caya dugukolo kan; o ka denmusow woro fana. ");
INSERT INTO dyu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","A kɛra ten, Ala ta danfɛn dɔw tun bɛ yi, olugu k’a ye ko mɔgɔw denmusow cɛ ka ɲi minkɛ, o ka dɔw ɲanawoloma olugu ra ka o kɛ o ta musow ye. ");
INSERT INTO dyu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","O tuma Matigi Ala ko: «Ne ka nin min don mɔgɔ kɔnɔ, ne tɛna o nin to mɔgɔ kɔnɔ wagati bɛɛ, sabu mɔgɔ tɛ foyi ye ni fɛn sata tɛ. A si bɛɛ lajɛnnin tɛna tɛmɛ san kɛmɛ ni san mugan kan.» ");
INSERT INTO dyu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ala ta danfɛnw jɛnna ni mɔgɔw denmusow ye minkɛ, o ka denw sɔrɔ ni o ye; o denw le kɛra mɔgɔ belebele jamijanw ye o wagatiw ra dunuɲa ra. Olugu le kɛra cɛfariw ye fɔlɔfɔlɔ; o tɔgɔ bɔra kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Matigi Ala nana a ye ko adamadenw ta kɔnɔnɔjuguya warara dunuɲa kɔnɔ. A k’a ye ko lon o lon, miiriyajuguw dɔrɔn le bɛ kɛra mɔgɔw jusukun na. ");
INSERT INTO dyu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","A kɛra ten, Matigi Ala ka mɔgɔ dan k’a bla dugukolo kan minkɛ, o tingalɔn ka Matigi Ala yɛrɛ sɔrɔ. A jusu tɔɔrɔra kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Matigi Ala ko: «Ne ka mɔgɔ o mɔgɔ dan, ne bɛna o bɛɛ halaki pewu ka bɔ dugukolo kan, k’a damina adamadenw na, ka taga a bla bɛganw ni kongosogow ra, ani fɛn minw bɛ fofo, ani kɔnɔw; sabu ne ka o dan minkɛ, o danko tingalɔn bɛ ne ra.» ");
INSERT INTO dyu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nka Nuho ko diyara Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuho ta duruja ta ko ye nin ye: Nuho tun ye mɔgɔ terennin ani mɔgɔ jusukungbɛnin le ye a ta wagati ra. A tun bɛ tagama ka kaɲa ni Ala sago ye. ");
INSERT INTO dyu_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","A ka dencɛ saba le sɔrɔ: Sɛmu, ani Kamu, ani Zafɛti. ");
INSERT INTO dyu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","O wagati ra, dunuɲa tun fara kojugu ra Ala ɲa kɔrɔ. Mɔgɔw tun fariyara ɲɔgɔn ma yɔrɔ bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ala nana a ye ko dunuɲa fara kojugu ra; sabu adamadenw bɛɛ ta kɛwalew tun juguyara fɔ k’a dama tɛmɛ. ");
INSERT INTO dyu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","O tuma Ala k’a fɔ Nuho ye ko: «Ne k’a latigɛ ko ne bɛna fɛnɲanaman bɛɛ ban ka bɔ dugukolo kan; sabu olugu le k’a to juguya ka dunuɲa yɔrɔ bɛɛ fa. O kosɔn ne bɛna o ni dugukolo bɛɛ halaki ɲɔgɔn fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","O ra, ele ye kurunba dɔ lalaga ni gofɛriyiri ye, k’a kɔnɔ tarantaran, k’a kɛ bonkɔnɔw ye, k’a kɛnɛmayɔrɔ ni a kɔnɔnɔyɔrɔ mun ni mananji ye. ");
INSERT INTO dyu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","I ka kan k’a kɛ cogo min na, o flɛ nin ye: i bɛ a janya kɛ nɔngɔn ɲa kɛmɛ saba ye, k’a bonya kɛ nɔngɔn ɲa bilooru ye, k’a lɔ kɛ nɔngɔn ɲa bisaba ye. ");
INSERT INTO dyu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","I bɛ a datugu ka wo dɔ kɛ a ra san fɛ, ka o kɛ nɔngɔn ɲa kelen ye. I bɛ a donda kɛ a kɛrɛn na. I b’a kɛ sankaso ye: dugumabon, ani cɛmancɛbon, ani sanfɛbon. ");
INSERT INTO dyu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ne bɛna sanjiba le lana dugukolo kan; fɛn o fɛn bɛ nɛnɛkiri, sanji bɛna o bɛɛ faga. Fɛn o fɛn bɛ dugukolo kan, o bɛɛ bɛ halaki. ");
INSERT INTO dyu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Nka ne bɛna to ne ta jɛnɲɔgɔnya ra ni ele ye ka i kisi. I bɛna don kurunba kɔnɔ, i ni i dencɛw, ani i ta muso, ani i dencɛw ta musow. ");
INSERT INTO dyu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","I bɛ fɛnɲanaman suguya bɛɛ fla fla ladon i fɛ kurunba kɔnɔ fana, cɛ ni muso, janko o ɲanaman ye to. ");
INSERT INTO dyu_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Fɛnɲanaman bɛɛ fla fla le bɛna na i fɛ, cɛ ni muso, janko i ye o ladon kurunba kɔnɔ, o ɲanaman ye to: kɔnɔw ni bɛganw ni kongosogow ni fɛn fofotaw. ");
INSERT INTO dyu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","I ka kan ka domunifɛn bɛɛ dɔ ta fana ka bla i yɛrɛ kɔrɔ, ka o kɛ i ni o bɛganw ta domuni ye.» ");
INSERT INTO dyu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ayiwa, Nuho ka o le kɛ. Ala ka fɛn o fɛn fɔ a ye, a ka o bɛɛ kɛ ka kaɲa ni Ala ta fɔta ye. ");
INSERT INTO dyu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","O kɔ, Matigi Ala ko Nuho ma ko: «Sisan aw ye don kurunba kɔnɔ, i ni i ta denbaya; sabu ne k’a ye ko ele dɔrɔn le terennin lo ne ɲa kɔrɔ nin mɔgɔw bɛɛ cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Fɛnɲanaman o fɛnɲanaman saninyanin lo, i bɛ o bɛɛ dɔ ladon i fɛ kurun kɔnɔ, cɛman wolonfla, ani musoman wolonfla. Fɛnɲanaman minw saninyanin tɛ, i bɛ olugu fana ladon, cɛman kelen, ani musoman kelen. ");
INSERT INTO dyu_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","I bɛ kɔnɔ suguya bɛɛ fana dɔ ladon, cɛman wolonfla, ani musoman wolonfla, janko o ta siya kana tunu. ");
INSERT INTO dyu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Sabu a tɔ ye tere wolonfla, ne bɛna sanji ben dugukolo kan fɔ tere binaani ni su binaani. Ne ka fɛnɲanaman o fɛnɲanaman dan, ne bɛna o bɛɛ halaki pewu ka bɔ dugukolo kan.» ");
INSERT INTO dyu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ayiwa, Ala tun ka fɛn o fɛn fɔ Nuho ye, Nuho ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ayiwa, sanjiba nana dugukolo kan lon min na, o kɛra k’a sɔrɔ Nuho si ye san kɛmɛ wɔɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuho donna kurunba kɔnɔ, ani a muso, ani a dencɛw, ani a dencɛw ta musow. O donna kurunba kɔnɔ, ka kisi sanjiba ma. ");
INSERT INTO dyu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Fɛnɲanaman o fɛnɲanaman saninyanin lo, ani minw saninyanin tɛ, ani kɔnɔw, ani fɛn o fɛn bɛ fofo dugu ma, ");
INSERT INTO dyu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","o bɛɛ dɔ donna Nuho fɛ kurunba kɔnɔ, fla fla, cɛ ni muso, i ko Ala yɛrɛ tun k’a fɔ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tere wolonfla dafara minkɛ, sanjiba nana dugukolo kan. ");
INSERT INTO dyu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","O kɛra ka Nuho si to san kɛmɛ wɔɔrɔ. O san karo flanan, o karo tere tan ni wolonflanan, o lon na bunun minw bɛ dugukolo jukɔrɔ, olugu bɛɛ jiw serira ka bɔ ka kɛ dugukolo kan. Sankolo jibɔyɔrɔw fana dayɛlɛra. ");
INSERT INTO dyu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ayiwa, sanjiba benna dugukolo kan tere binaani ni su binaani. ");
INSERT INTO dyu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","O lon yɛrɛ ra, Nuho donna kurunba kɔnɔ, ani a dencɛ saba: Sɛmu, ani Kamu, ani Zafɛti; ani a muso, ani a dencɛ saba ta musow. ");
INSERT INTO dyu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","O donna kurunba kɔnɔ, o ni kongosogo siya bɛɛ dɔ. Bɛgan siya bɛɛ; fɛnɲanaman minw bɛ fofo, o siya bɛɛ, kɔnɔ siya bɛɛ, kɔnɔnin fitiniw bɛɛ, ani kaman bɛ fɛn o fɛn na. ");
INSERT INTO dyu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","O fɛnɲanamanw bɛɛ donna kurunba kɔnɔ ka to ni Nuho ye; fɛn o fɛn bɛ nɛnɛkiri, o bɛɛ fla fla donna. ");
INSERT INTO dyu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Fɛnɲanamanw bɛɛ, o bɛɛ fla fla donna kurunba kɔnɔ, cɛ ni muso, i ko Ala tun k’a fɔ Nuho ye cogo min na. O kɔ, Matigi Ala ka da tugu o da ra. ");
INSERT INTO dyu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Sanjiba benna dugukolo kan ka se fɔ tere binaani. Ji bonyara fɔ a ka kurunba kɔrɔta, a ka kɛ taga ye ji kunna. ");
INSERT INTO dyu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ji cayara ka bonya kosɛbɛ. Kurunba ka fogon ji kunna; ");
INSERT INTO dyu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ji belen ka kɛ bonya ye tuun. A ka kuru jamijanw bɛɛ datugu. ");
INSERT INTO dyu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ji yɛlɛnna kuruw kunna ka se fɔ nɔngɔn ɲa tan ni looru ka kuruw datugu pewu. ");
INSERT INTO dyu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nin tun bɛ fɛn o fɛn na, o bɛɛ fagara; kɔnɔw ni bɛganw ni kongosogow, ani fɛn o fɛn bɛ fofo, ani mɔgɔw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Fɛn o fɛn bɛ nɛnɛkiri, ni nin b’a ra, fɛn o fɛn bɛ dugukolo kan, o bɛɛ fagara. ");
INSERT INTO dyu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Fɛnɲanaman o fɛnɲanaman tun bɛ dugukolo kan, ji ka o bɛɛ domu; k’a ta mɔgɔw ra ka taga a bla bɛganw na, ani fɛn minw bɛ fofo, ani kɔnɔw. Ji ka o bɛɛ halaki. Nuho dɔrɔn le tora, ale ni minw tun bɛ ni a ye kurunba kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ji bonyanin tora dugukolo kan ka se fɔ tere kɛmɛ ni tere bilooru, k’a ta sanji damina lon na. ");
INSERT INTO dyu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nka Ala hakiri tora Nuho ra, ani kongosogow ni bɛgan minw tun bɛ ni a ye kurunba kɔnɔ. Ala ka fɔɲɔ dɔ fiyɛ dugukolo kan; ji jigira dɔɔnin. ");
INSERT INTO dyu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Dugukolo bununjiw lɔra, sankolo jibɔyɔrɔw datugura; sanji tigɛra. ");
INSERT INTO dyu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ji tora ka woyo ka bɔ dugukolo kan ka taga. Sani tere kɛmɛ ni tere bilooru cɛ, ji dɔgɔyara. ");
INSERT INTO dyu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ayiwa, a karo wolonflanan, o karo tere tan ni wolonflanan, kurunba tagara sigi Ararati jamana kuruw kan. ");
INSERT INTO dyu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ji ka kɛ dɔgɔya ye fɔ ka taga se san karo tannan ma. San karo tannan, o karo tere fɔlɔ, kuruw kunw bɔra. ");
INSERT INTO dyu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Tere binaani tɛmɛnin kɔ, Nuho tun ka da min bɔ kurunba ra, a ka o dayɛlɛ. ");
INSERT INTO dyu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","A ka kankan bla ka bɔ; o kɔnɔ bɔra, ka to tagakasegi ra, sabu ji tun ma ja dugukolo kan ban. ");
INSERT INTO dyu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","A ka tugani fana bla ka bɔ, k’a flɛ ni a kɛra ko ji dɔgɔyara dugukolo kan. ");
INSERT INTO dyu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nka tugani bɔra minkɛ, a ma sigiyɔrɔ sɔrɔ. A sekɔra ka na Nuho fɛ kurunba kɔnɔ, sabu ji tun bɛ dugukolo yɔrɔ bɛɛ ra hali bi. Nuho k’a boro bɔ ka tugani mina, k’a ladon kurunba kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuho k’a to tere wolonfla tɛmɛna tuun. O kɔ, a ka tugani bla ka taga tuun. ");
INSERT INTO dyu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Wula fɛ le tugani sekɔra ka na, oliviye flaburu dɔ tigɛnin bɛ a dakala ra. Nuho k’a lɔn o le ra ko dɔ bɔra ji ra. ");
INSERT INTO dyu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","A k’a to tere wolonfla wɛrɛ tɛmɛna tuun. O kɔ, a ka tugani labɔ tuun. Tugani tagara o ra minkɛ, a ma sekɔ tuun. ");
INSERT INTO dyu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","San min Nuho si tun bɛ san kɛmɛ wɔɔrɔ ni san kelen, o san karo fɔlɔ, ani o karo tere fɔlɔ, ji jara dugukolo kan. Da min tun bɛ kurunba san fɛ, Nuho ka o dayɛlɛ. A ka yɔrɔ flɛ, k’a ye ko ji jara dugukolo kan. ");
INSERT INTO dyu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","O san karo flanan, o karo tere mugan ni wolonflanan, ji jara dugukolo kan pewu. ");
INSERT INTO dyu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","O tuma, Ala kumana Nuho fɛ ko: ");
INSERT INTO dyu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Bɔ kurunba kɔnɔ sisan, i ni i ta muso, ni i dencɛw ni o ta musow. ");
INSERT INTO dyu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kongosogow ni bɛgan minw bɛ ni i ye, o bɛɛ ni o siya, ani kɔnɔw, ani fɛn fofotaw bɛɛ, o bɛɛ labɔ; o ye taga dugukolo yɔrɔ bɛɛ, ka woro, ka caya dugukolo kan.» ");
INSERT INTO dyu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ayiwa, Nuho bɔra kurunba kɔnɔ, ani a dencɛw, ni a muso, ni a dencɛw ta musow. ");
INSERT INTO dyu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kongosogow ni bɛganw bɛɛ, ani fɛnɲanaman minw bɛɛ bɛ fofo, ani fɛn o fɛn ni nin b’a ra, o bɛɛ ni o siya, o bɛɛ bɔra kurunba kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuho ka sarakabɔnan dɔ lalaga, ka Matigi Ala bato. Kongosogow ni bɛgan minw saninyanin lo, ani kɔnɔ minw saninyanin lo, a ka o dɔw kɛ saraka ye, ka o jɛni sarakabɔnan kan ka Ala bato. ");
INSERT INTO dyu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","O saraka kasadiman diyara Matigi Ala ye. Matigi Ala fana k’a latigɛ ko: «Ne tɛna dugukolo danga tuun adamadenw kosɔn, hali ni mɔgɔ jusukun miiriyaw man ɲi kabini a denmisɛnman. Ne tɛna sɔn ka fɛnɲanamanw bɛɛ halaki tuun, i n’a fɔ ne k’a kɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ka dugukolo to yi kɔni, dannikɛwagati ni simantigɛwagati tɛna ban, nɛnɛwagati ni fundɛninwagati tɛna ban, samiya ni teremana tɛna ban, su ni tere tɛna ban.» ");
INSERT INTO dyu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ayiwa, Ala ka baraka don Nuho ni a dencɛw ra. A ko o ma ko: «Aw ye woro, ka caya ka se dugukolo yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Aw bɛna kɛ siranyafɛnba le ye kongosogow ni bɛganw bɛɛ fɛ, ani kɔnɔw bɛɛ, ani fɛnɲanamanw bɛɛ, ani jɛgɛw bɛɛ. Ne bɛ o fɛnw bɛɛ labla aw ye. ");
INSERT INTO dyu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Fɛnɲanaman o fɛnɲanaman, ni nin b’a ra, o bɛɛ bɛ kɛ aw baro ye. Ne bɛ o bɛɛ di aw ma, i n’a fɔ ne ka binw di aw ma cogo min na. ");
INSERT INTO dyu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Nka aw man kan ka sogo si domu k’a nin to a ra, o kɔrɔ ye k’a jori to a ra. ");
INSERT INTO dyu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Aw ye a lɔn ka la a ra fana ko aw jori min ye aw nin ye ko ne bɛna o koɲininka. Ni kongofɛn o kongofɛn ka mɔgɔ faga, ne bɛna o tigi jori koɲininka o kongofɛn fɛ; ni mɔgɔ o mɔgɔ k’a mɔgɔɲɔgɔn faga, ne bɛna o jori koɲininka o tigi fɛ. Ne bɛna mɔgɔ nin koɲininka kongofɛn, walama mɔgɔfagabaga fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ni mɔgɔ min ka mɔgɔ faga, mɔgɔ dɔ wɛrɛ le fana bɛna o tigi faga; sabu Ala ka mɔgɔ dan ka kaɲa ni a yɛrɛ cogo le ye. ");
INSERT INTO dyu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","«Ayiwa, aw kɔni, aw ye denw woro, ka caya, ka janjan ka taga dugukolo yɔrɔ bɛɛ ra, ka caya dugukolo kan.» ");
INSERT INTO dyu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","O kɔ, Ala kumana Nuho ni a dencɛw fɛ tuun; ");
INSERT INTO dyu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","a k’a fɔ o ye ko: «Ayiwa, ne bɛ to ne ta jɛnɲɔgɔnya* ra ni aw ye, ani aw ta duruja minw bɛna woro aw kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Fɛnɲanaman o fɛnɲanaman bɛ ni aw ye, ne bɛ jɛnɲɔgɔnya don ni olugu bɛɛ ye: kɔnɔw, ani bɛganw, ani kongosogow bɛɛ, ani fɛn o fɛn bɔra kurunba kɔnɔ ni aw ye, ani fɛnɲanaman o fɛnɲanaman bɛna kɛ dugukolo kan aw kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ne bɛ jɛnɲɔgɔnya don ni aw ye; sanjiba tɛna danfɛn si halaki tuun. Sanjiba wɛrɛ tɛna kɛ yi tuun, ka dugukolo halaki.» ");
INSERT INTO dyu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ala ko tuun ko: «Ne bɛ jɛnɲɔgɔnya min don ni aw ye, ani fɛnɲanaman minw bɛɛ bɛ ni aw ye, ani mɔgɔ minw bɛɛ bɛna na aw kɔ fɛ, o jɛnɲɔgɔnya tagamasiyɛn le ye nin ye wagati bɛɛ: ");
INSERT INTO dyu_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ne bɛna ne ta sanmuru bɔ san fɛ sankabaw kunna; ne ka jɛnɲɔgɔnya min don ni danfɛnw bɛɛ ye, sanmuru le bɛna kɛ o jɛnɲɔgɔnya tagamasiyɛn ye. ");
INSERT INTO dyu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ni ne ka na sankabaw lajɛn dugukolo kunna tuma o tuma, ko ne bɛ sanji ben, sanmuru bɛna bɔ san fɛ sankabaw kunna. ");
INSERT INTO dyu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","O tuma ne ka jɛnɲɔgɔnya min don ni aw ye, ani fɛnɲanamanw bɛɛ ye, ani danfɛnw bɛɛ ye, ne bɛna ne hakiri to o jɛnɲɔgɔnya ra. Ne tɛna a to ji ye caya ka kɛ sanjiba ye tuun, fɔ ka danfɛnw bɛɛ halaki. ");
INSERT INTO dyu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Sanmuru bɛna bɔ san fɛ sankabaw kunna. Ne bɛna o flɛ ka ne hakiri to ne ta jɛnɲɔgɔnya wuribari ra, ne Ala ka jɛnɲɔgɔnya min don ni fɛnɲanamanw bɛɛ ye, ani danfɛn o danfɛn bɛ dugukolo kan.» ");
INSERT INTO dyu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ala k’a fɔ Nuho ye tuun ko: «Ne ka jɛnɲɔgɔnya min don ni dugukolo danfɛnw bɛɛ ye, o tagamasiyɛn le ye nin ye.» ");
INSERT INTO dyu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ayiwa, Nuho dencɛ minw bɔra kurunba kɔnɔ, olugu tun ye Sɛmu ye, ani Kamu, ani Zafɛti. Kamu ka dencɛ dɔ woro, o tɔgɔ tun ye ko Kanaana. ");
INSERT INTO dyu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nuho dencɛ saba le bɛ olugu ye. Dugukolo siyaw bɛɛ bɔra olugu ta durujaw le ra. ");
INSERT INTO dyu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ayiwa, o kow kɔ, Nuho ka sɛnɛ damina. A ka rɛzɛnforo sɛnɛ. ");
INSERT INTO dyu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Lon dɔ, Nuho ka o rɛzɛnmɔ duvɛn dɔ min, ka ɲanamini. A tagara la a ta fanibon kɔnɔ, a fari lakolon. ");
INSERT INTO dyu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ayiwa, Kanaana facɛ, min ye Kamu ye, ale tagara a facɛ Nuho fari lakolon lanin ye. A bɔra ka taga o fɔ a balemacɛ tɔ fla ye kɛnɛ ma. ");
INSERT INTO dyu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sɛmu ni Zafɛti ka deregeba dɔ ta o le ra, k’a la o kan na, ka don ni o kɔ ye o facɛ ta fanibon kɔnɔ, ka taga deregeba kɛ k’a datugu. O tun ka o ɲa munu fan wɛrɛ fɛ, janko o kana o facɛ fari lakolon ye. ");
INSERT INTO dyu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ayiwa, duvɛn nana bɔ Nuho ɲa ra tuma min na, a dencɛ fitini Kamu ka min kɛ, o ka o fɔ Nuho ye. ");
INSERT INTO dyu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nuho ko: «Kanaana dangara! A ye kɛ a balemaw ta jɔnw ta jɔn ye.» ");
INSERT INTO dyu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nuho ko tuun ko: «Matigi Ala baraka, Sɛmu ta Ala; Kanaana ye kɛ Sɛmu ta jɔn ye. ");
INSERT INTO dyu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ala ye Zafɛti borofɛnw caya, k’a to a ye taga sigi a balemacɛ Sɛmu ta so, k’a to Kanaana ye kɛ o ta jɔn ye.» ");
INSERT INTO dyu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ayiwa, sanjiba kɔ, Nuho ka san kɛmɛ saba ni san bilooru le kɛ tuun. ");
INSERT INTO dyu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuho si bɛɛ lajɛnnin kɛra san kɛmɛ kɔnɔntɔn ni san bilooru. O kɔ, a sara. ");
INSERT INTO dyu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ayiwa, sanjiba kɔ, Nuho dencɛw, minw ye Sɛmu, ani Kamu ni Zafɛti ye, olugu ka dencɛ dɔw sɔrɔ. Olugu ta durujaw flɛ nin ye: ");
INSERT INTO dyu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Zafɛti dencɛw tun ye Gomɛri ye, ani Magɔgi, ani Madayi, ani Yavan, ani Tubali, ani Mesɛki, ani Tirasi. ");
INSERT INTO dyu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomɛri dencɛw tun ye Asikenazi ye, ani Rifati, ani Togarima. ");
INSERT INTO dyu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavan dencɛw tun ye Elisa ye, ani Tarisisi, ani Kitimu, ani Rodanimu. ");
INSERT INTO dyu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Olugu le tagara sigi kɔgɔji kɔfɛjamanaw ra, bɛɛ ni i ta yɔrɔ, bɛɛ ni i ta kan, bɛɛ ni i ta gba, bɛɛ ni i ta siya. ");
INSERT INTO dyu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kamu dencɛw tun ye Kusi ye, ani Misirayimu, ani Puti ni Kanaana. ");
INSERT INTO dyu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusi dencɛw tun ye Seba ye, ani Havila, ani Sabita, ani Rayema, ani Sabiteka. Rayema denw kɛra Seba ye, ani Dedan. ");
INSERT INTO dyu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusi dencɛ dɔ fana kɛra Nimurɔdi ye. Ale fɔlɔ le kɛra fangatigi ye dugukolo kan. ");
INSERT INTO dyu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","A kɛra donsocɛfari ye Matigi Ala ɲa kɔrɔ. O le kosɔn o tun b’a fɔ ko mɔgɔtisina kɛra donsocɛfari ye Matigi Ala ɲa kɔrɔ, i ko Nimurɔdi. ");
INSERT INTO dyu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimurɔdi sigira fanga ra Babɛli dugu kunna, ani Erɛki dugu, ani Akadi dugu, ani Kaline dugu, Sinehari jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","A nana bɔ o jamana ra, ka taga Asiri jamana ra. A ka Ninive dugu lɔ, ani Rehobɔti Hiri dugu, ani Kala dugu; ");
INSERT INTO dyu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","a ka Resɛni duguba fana lɔ, Ninive dugu ni Kala dugu cɛ. ");
INSERT INTO dyu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misirayimu le ye Ludikaw bɛmacɛ ye, ani Anamikaw, ani Lehabikaw, ani Nafitukaw, ");
INSERT INTO dyu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ani Paturusikaw, ani Kasiluhikaw, ani Kafitɔrikaw; Filisikaw bɔra Kasiluhikaw le ra. ");
INSERT INTO dyu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaana ka Sidɔn woro; ale le kɛra a dencɛ fɔlɔ ye; o kɔ fɛ a ka Hɛti woro. ");
INSERT INTO dyu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ale le kɛra Yebusikaw bɛmacɛ ye, ani Amɔrikaw, ani Girigasikaw, ");
INSERT INTO dyu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ani Hevikaw, ani Arikikaw, ani Sinɛkaw, ");
INSERT INTO dyu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ani Arivadikaw, ani Semarikaw, ani Hamatikaw. Ayiwa, o kɔ, Kanaana ta gbamɔgɔw yɛrɛgɛra. ");
INSERT INTO dyu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaanakaw ta jamana tun bɛ damina Sidɔn, ka taga Gerari fan fɛ, ka taga a bla fɔ Gaza, ani ka taga Sodɔmu fan fɛ, ani Gomɔri, ani Adima, ani Seboyimu, ka taga se fɔ Lesa. ");
INSERT INTO dyu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Olugu le ye Kamu dencɛw ye, o bɛɛ ni o ta gbaw, ani o ta kanw, ani o ta jamanaw, ani o ta siyaw. ");
INSERT INTO dyu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sɛmu fana ka dencɛw sɔrɔ. Ale Sɛmu le kɛra Hebɛri ta mɔgɔw bɛɛ bɛmacɛ ye; Zafɛti dɔgɔcɛ tun lo. ");
INSERT INTO dyu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sɛmu dencɛw tun ye Elamu ye, ani Asuri, ani Aripasadi, ani Ludi, ani Aramu. ");
INSERT INTO dyu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramu dencɛw tun ye Usi ye, ani Huli, ani Getɛri, ani Masi. ");
INSERT INTO dyu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aripasadi ka Sela woro; Sela ka Hebɛri woro. ");
INSERT INTO dyu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hebɛri ka dencɛ fla sɔrɔ: kelen tɔgɔ tun ye ko Pelɛgi, sabu ale ta wagati le ra dugukolo taranna. Ale balemacɛ tɔgɔ tun ye ko Yokitan. ");
INSERT INTO dyu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitan ka Alimodadi woro, ani Selɛfu, ani Hasarimavɛti, ani Yera, ");
INSERT INTO dyu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ani Hadoramu, ani Uzali, ani Dikila, ");
INSERT INTO dyu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ani Obali, ani Abimayɛli, ani Seba, ");
INSERT INTO dyu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ani Ofiri, ani Havila, ani Yobabu. Olugu bɛɛ ye Yokitan dencɛw ye. ");
INSERT INTO dyu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","O ta sigiyɔrɔ tun bɛ damina fɔ Mesa, ka taga a bla fɔ Sefari kuruyɔrɔw ra terebɔyanfan na. ");
INSERT INTO dyu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ayiwa, olugu bɛɛ le kɛra Sɛmu denw ye, o bɛɛ ni o ta gbaw, ani o ta kanw, ani o ta jamanaw, ani o ta siyaw. ");
INSERT INTO dyu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nuho ta denw ta gbaw le kɛra olugu ye, o bɛɛ ni o ta durujaw, ani o ta siyaw. Siya minw yɛrɛgɛra dugukolo kan yɔrɔ bɛɛ sanjiba kɔ fɛ, o bɛɛ bɔra Nuho ta denw le ra. ");
INSERT INTO dyu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Fɔlɔfɔlɔ, dunuɲamɔgɔw bɛɛ tun bɛ kan kelen, ani kuma kelen le fɔ. ");
INSERT INTO dyu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","O bɔra terebɔyanfan na, ka taga kɛnɛgbɛba dɔ ye Sinehari jamana ra. O sigira o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Lon dɔ, o k’a fɔ ɲɔgɔn ye ko: «Aw y’a to an ye biriki bɔ, k’a jɛni k’a ja.» O ka o birikiw le kɛ o ta bonlɔkabakuruw ye, ka mananji kɛ bonlɔnan ye. ");
INSERT INTO dyu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","O ko: «Aw y’a to an ye dugu dɔ lɔ, ani sankasojan dɔ; k’a janya fɔ a ye se sankolo ma. O ye kɛ tagamasiyɛn ye, k’a to an ye tɔgɔ sɔrɔ, janko an kana na yɛrɛgɛ ka taga dugukolo fan bɛɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ayiwa, Matigi Ala jigira ka na dugu flɛ, ani sankasojan, adamadenw tun bɛ min lɔra. ");
INSERT INTO dyu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Matigi Ala ko: «Aw y’a flɛ, o bɛɛ kɛra i ko jamana kelen mɔgɔw; o bɛɛ bɛ kan kelen le fɔra fana. Sisan o fana ka nin baara le damina. Ni a tora tan, o ka fɛn o fɛn latigɛ ko o b’a kɛ, foyi le tɛna o bari ka o kɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ala ko: «An ye jigi ka taga o ta kan ɲagami janko o kana se ka ɲɔgɔn ta kan mɛn tuun.» ");
INSERT INTO dyu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Matigi Ala ka o le kɛ, ka o bɛɛ janjan ka bɔ o yɔrɔ ra, ka o lataga dugukolo yɔrɔ bɛɛ ra. O ka dugu lɔri dabla. ");
INSERT INTO dyu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","O kosɔn o yɔrɔ tɔgɔ lara ko Babɛli, sabu Matigi Ala ka dunuɲamɔgɔw bɛɛ ta kan ɲagami o yɔrɔ le ra; a ka o gbɛn ka bɔ o yɔrɔ le ra, ka o janjan ka taga dugukolo yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ayiwa, Sɛmu ta duruja ye nin ye. Ka Sɛmu si to san kɛmɛ, a ka Aripasadi woro. O kɛra san fla sanjiba kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Aripasadi woronin kɔ, Sɛmu ka san kɛmɛ looru le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ka Aripasadi si to san bisaba ni san looru, a ka Selasi woro. ");
INSERT INTO dyu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Selasi woronin kɔ, Aripasadi ka san kɛmɛ naani ni san saba le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ka Selasi si to san bisaba, a ka Hebɛri woro. ");
INSERT INTO dyu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Hebɛri woronin kɔ, Selasi ka san kɛmɛ naani ni san saba le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ka Hebɛri si to san bisaba ni san naani, a ka Pelɛgi woro. ");
INSERT INTO dyu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelɛgi woronin kɔ, Hebɛri ka san kɛmɛ naani ni san bisaba le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ka Pelɛgi si to san bisaba, a ka Erehu woro. ");
INSERT INTO dyu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Erehu woronin kɔ, Pelɛgi ka san kɛmɛ fla ni san kɔnɔntɔn le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ka Erehu si to san bisaba ni san fla, a ka Serugi woro. ");
INSERT INTO dyu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serugi woronin kɔ, Erehu ka san kɛmɛ fla ni san wolonfla le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ka Serugi si to san bisaba, a ka Nahɔri woro. ");
INSERT INTO dyu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahɔri woronin kɔ, Serugi ka san kɛmɛ fla le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ka Nahɔri si to san mugan ni kɔnɔntɔn, a ka Tera woro. ");
INSERT INTO dyu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tera woronin kɔ, Nahɔri ka san kɛmɛ ni san tan ni kɔnɔntɔn le kɛ tuun. A ka dencɛ wɛrɛw woro, ani denmusow. ");
INSERT INTO dyu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ka Tera si to san biwolonfla, a ka Iburama woro, ani dencɛ dɔ wɛrɛ, min fana tɔgɔ lara ko Nahɔri; ani Haran. ");
INSERT INTO dyu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera ta duruja le ye nin ye: a ka Iburama woro, ani Nahɔri, ani Haran. Haran ka Lutu woro. ");
INSERT INTO dyu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran nana sa k’a facɛ to si ra. A tun worora Kalide jamana le ra; a fana sara yi le, Uri dugu ra. ");
INSERT INTO dyu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Iburama ni Nahɔri ka muso furu. Iburama ta muso tɔgɔ tun ye ko Sarayi, Nahɔri ta muso tɔgɔ tun ye ko Milika; Milika tun ye Haran denmuso le ye. A denmuso dɔ wɛrɛ tun tɔgɔ ye ko Isika. ");
INSERT INTO dyu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi tun tɛ se ka den woro; o kosɔn den ma kɛ ale fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ayiwa, Tera k’a dencɛ Iburama ta, ani Lutu, a dencɛ Haran dencɛ, ani a buranmuso Sarayi, Iburama ta muso; o bɔra Uri, Kalide jamana ra, ka taga sigi Kanaana jamana ra. O tagara se fɔ Karan, ka sigi o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera si bɛɛ lajɛnnin kɛra san kɛmɛ fla ni san looru. O kɔ, a sara Karan mara ra. ");
INSERT INTO dyu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ayiwa, lon dɔ, Matigi Ala kumana Iburama fɛ, ko: «Iburama, bɔ i ta jamana ra, bɔ i faso ra, bɔ i facɛ ta lu kɔnɔ; ne bɛna jamana min yira i ra, i bɛna taga sigi o jamana le ra. ");
INSERT INTO dyu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ne bɛna i kɛ siya caman fa ye, ka baraka don i ra; ne bɛna i tɔgɔ bonya, k’a to mɔgɔw ye baraka sɔrɔ i sababu ra. ");
INSERT INTO dyu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ni mɔgɔ minw ka i minako ɲa, ne bɛna baraka don olugu ra. Ni mɔgɔ min ka i minako juguya, ne bɛna o tigi danga. Dugukolo gbaw bɛɛ bɛna baraka sɔrɔ ne Ala fɛ, ele le sababu ra.» ");
INSERT INTO dyu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Iburama wurira ka taga i n’a fɔ Matigi Ala k’a fɔ a ye cogo min na. Lutu fana tagara ni a ye. Iburama bɔra Karan mara ra k’a si to san biwolonfla ni looru. ");
INSERT INTO dyu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Iburama k’a muso Sarayi ta, ani a kɔrɔcɛ dencɛ Lutu, ani a borofɛnw bɛɛ, ani a ta baaradenw bɛɛ, ani a tun ka fɛn o fɛn sɔrɔ Karan mara ra. O bɔra ka taga se Kanaana jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","A donna Kanaana jamana kɔnɔ ka taga se fɔ yɔrɔ dɔ ra, min bɛ wele ko Sikɛmu, fɔ More ta yirisunba yɔrɔ ra. O wagati ra, Kanaanakaw tun bɛ Kanaana jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Matigi Ala k’a yɛrɛ yira Iburama ra, k’a fɔ a ye ko: «Ne bɛna nin jamana di i ta duruja le ma.» Iburama ka sarakabɔnan dɔ lalaga o yɔrɔ ra Matigi Ala ye, Ala min tun k’a yɛrɛ yira a ra. ");
INSERT INTO dyu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Iburama bɔra o yɔrɔ ra ka taga kuruyɔrɔw ra, Betɛli dugu terebɔyanfan na. A k’a ta fanibonw lɔ Betɛli dugu ni Ayi dugu cɛ. Betɛli tora terebenyanfan na, ka Ayi dugu to terebɔyanfan na. A ka sarakabɔnan dɔ wɛrɛ lalaga o yɔrɔ ra Matigi Ala ye, ka Ala tɔgɔ wele k’a bato. ");
INSERT INTO dyu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Iburama nana bɔ o yɔrɔ ra, ka taga ɲa a ta tagama ra. A nana jamana woroduguyanfan fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ayiwa, o wagati ra, kɔngɔ benna jamana kan. Iburama tagara Misiran, ko a bɛ taga wagati dɔ kɛ yi, sabu kɔngɔ tun juguyara jamana ra kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","O dontɔ Misiran, Iburama k’a fɔ a muso Sarayi ye ko: «Ne k’a lɔn ko i cɛ ka ɲi. ");
INSERT INTO dyu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","O ra, ni Misirankaw nana i ye, o bɛna a fɔ ko ne ta muso le bɛ i ye. O bɛna ne faga, ka ele to yi, janko ka i ta. ");
INSERT INTO dyu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","O kosɔn ne bɛ i daari ko ni an sera yi, i y’a fɔ ko i ye ne dɔgɔmuso le ye, janko o ye ne minako ɲa i kosɔn, o kana ne faga.» ");
INSERT INTO dyu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Iburama ni a muso sera Misiran minkɛ, Misirankaw k’a ye ko a muso cɛ ka ɲi fɔ ka tɛmɛ. ");
INSERT INTO dyu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Masacɛ Farawona ta mɔgɔbaw fana ka Sarayi ye; olugu tagara a cɛɲa lakari Farawona ye kosɛbɛ. O tagara Sarayi ta ka taga ni a ye Farawona ta so. ");
INSERT INTO dyu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Masacɛ ka Iburama minako ɲa Sarayi kosɔn. A ka sagaw ni baw ni misiw ni faliw ni baaraden cɛmanw ni a musomanw di Iburama ma; a ka falimusow ni ɲɔgɔmɛw fana di a ma. ");
INSERT INTO dyu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Nka Matigi Ala ka tɔɔrɔbaw lase Farawona ni a ta somɔgɔw ma Iburama ta muso Sarayi kosɔn. ");
INSERT INTO dyu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Farawona k’a ye ten minkɛ, a dimina; a ka Iburama wele, k’a fɔ a ye ko: «I ka mun le kɛ ne ra tan? Mun na i m’a fɔ ne ye ko i ta muso lo? ");
INSERT INTO dyu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mun kosɔn i ko ne ma ko i dɔgɔmuso lo, k’a to ne k’a ta k’a kɛ ne muso ye? I ta muso ye nin ye, a mina ka taga ni a ye!» ");
INSERT INTO dyu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Farawona k’a fɔ a ta mɔgɔw ye ko o ye Iburama ni a muso labɔ Misiran jamana ra, o ni o borofɛnw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Iburama bɔra Misiran ka taga Kanaana jamana woroduguyanfan fɛ, ani a muso, ani fɛn o fɛn tun bɛ a ta ye; a belenden Lutu fana tun bɛ ni a ye. ");
INSERT INTO dyu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Bɛganw, ani warigbɛ, ani sanin caman tun bɛ Iburama fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A bɔra Kanaana jamana woroduguyanfan fɛ, ka taga fɔ Betɛli; a tun ka fanibon lɔ yɔrɔ min na fɔlɔfɔlɔ, Betɛli ni Ayi dugu cɛ, a tagara se fɔ o yɔrɔ ra; ");
INSERT INTO dyu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","a tun kɔnna ka sarakabɔnan dɔ lɔ o yɔrɔ le ra. A sera o yɔrɔ ra minkɛ, a ka Matigi Ala tɔgɔ wele, k’a bato. ");
INSERT INTO dyu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lutu min tun bɛ ni Iburama ye, sagaw ni baw, ani misiw, ani fanibon caman tun bɛ ale fana fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","O kosɔn, yɔrɔ dɔgɔyara o fla ma, sabu o borofɛnw tun ka ca kosɛbɛ; o fla bɛɛ tun tɛ se ka kun yɔrɔ kelen na. ");
INSERT INTO dyu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","O le kɛra sababu ye k’a to lon dɔ, kɛrɛ dɔ wurira Iburama ta sagagbɛnbagaw ni Lutu ta sagagbɛnbagaw cɛ, yɔrɔ ko ra. O y’a sɔrɔ Kanaanakaw ni Perezikaw fana tun bɛ jamana ra yi. ");
INSERT INTO dyu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Iburama k’a ye ten minkɛ, a ko Lutu ma ko: «Sabari, an kana a to kɛrɛ ye wuri ne ni ele cɛ, walama ne ta sagagbɛnbagaw ni ele ta sagagbɛnbagaw cɛ, sabu anw ye balemaw le ye. ");
INSERT INTO dyu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Jamana ka bon. Nin bɛɛ le tɛ yɔrɔ ye wa? A to an ye faran. Ni numanboroyanfan ka bɛn i ma, i ye taga yi; ne bɛ taga kininboroyanfan fɛ; ni kininboroyanfan fana ka bɛn i ma, i ye taga yi, ne bɛ taga numanboroyanfan fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lutu k’a ɲa kɔrɔta ka Zuridɛn kɔ kɛnɛgbɛba flɛ; ji tun ka ca o yɔrɔ ra. Tuma min na Matigi Ala tun ma Sodɔmu dugu ni Gomɔri dugu halaki ban, o yɔrɔ tun cɛ ka ɲi, ka taga se fɔ Sowari; a tun bɛ i ko Matigi Ala ta yirituɲuman, i ko Misiran jamana. ");
INSERT INTO dyu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ayiwa, Lutu ka o ye minkɛ, a ka Zuridɛn kɔ kɛnɛgbɛ bɛɛ ta a yɛrɛ ta ye, ka gbara ka taga fɔ terebɔyanfan na. O faranna ɲɔgɔn na o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Iburama sigira Kanaana jamana ra. Lutu tagara sigi o kɛnɛgbɛba dugu dɔ ra, k’a ta fanibonw lɔ ka taga se fɔ Sodɔmu; ");
INSERT INTO dyu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","k’a sɔrɔ Sodɔmu dugumɔgɔw tun ka jugu. O tun bɛ jurumun caman kɛ, ka Matigi Ala hakɛ ta. ");
INSERT INTO dyu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lutu farannin kɔ ka bɔ Iburama kɔ, lon dɔ Matigi Ala ka a fɔ Iburama ye ko: «Iburama, i ɲa kɔrɔta san fɛ; i bɛ yɔrɔ min na, to yi ka flɛri kɛ sahiliyanfan fɛ, ani woroduguyanfan fɛ, ka flɛri kɛ terebɔyanfan na, ani terebenyanfan na. ");
INSERT INTO dyu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","I ɲa bɛ jamana min bɛɛ ra tan, ne bɛna o di ele ni i ta duruja ma, k’a kɛ aw ta ye wagati bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ne bɛna i ta duruja caya k’a kɛ i ko dugukolo kɛnkɛn. Ni mɔgɔ bɛ se ka dugukolo kɛnkɛn bɛɛ jate, o tuma i ta duruja fana bɛna se ka jate. ");
INSERT INTO dyu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Wuri ka jamana yaala, k’a janya ni a bonya flɛ, sabu ne bɛ nin jamana di i ma.» ");
INSERT INTO dyu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Iburama k’a ta fanibonw wuri, ka na sigi Mamire ta yirisunba yɔrɔ ra; o yɔrɔ bɛ Heburɔn kɛrɛ fɛ. A ka sarakabɔnan dɔ wɛrɛ lɔ o yɔrɔ ra Matigi Ala tɔgɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ayiwa, wagati min na Amurafɛli tun ye Sinehari jamana masacɛ ye, Ariyɔki tun ye Elasari dugu masacɛ ye, Kedolamɛri tun ye Elamu jamana masacɛ ye, Tidɛli tun ye Goyimu jamana masacɛ ye, ");
INSERT INTO dyu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","o wagati ra o masacɛ naani jɛnna ka taga Sodɔmu dugu masacɛ kɛrɛ, min tɔgɔ ye ko Bera, ani Gomɔri dugu masacɛ min tɔgɔ ye ko Birisa, ani Adima dugu masacɛ min tɔgɔ ye ko Sinabu, ani Seboyimu dugu masacɛ min tɔgɔ ye ko Semebɛri, ani Bela dugu masacɛ; Bela dugu le nana kɛ Sowari ye. ");
INSERT INTO dyu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","O masacɛ looru bɛɛ fana tun tagara ɲɔgɔn lajɛn Sidimu kɛnɛgbɛ kan. Kɔgɔji sanin bɛ o yɔrɔ le ra bi. ");
INSERT INTO dyu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","O masacɛ looru bɛɛ tun bɛ masacɛ Kedolamɛri ta fanga kɔrɔ kabini san tan ni fla. A san tan ni sabanan, o murutira. ");
INSERT INTO dyu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","O kosɔn a san tan ni naaninan, Kedolamɛri ni masacɛ minw tun bɛ ni a ye, olugu wurira o kama. Kedolamɛri ni a jɛnɲɔgɔnw tun ka Refayikaw kɛrɛ ka se o ra; o kɛra Asiterɔti Karinayimu dugu yɔrɔ ra. O tun ka Zuzikaw kɛrɛ ka se olugu fana ra; o kɛra Hamu dugu yɔrɔ ra. O tun ka Emitikaw kɛrɛ ka se o ra; o kɛra Sawe Kiriyatayimu dugu yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","O tun ka Hɔrikaw kɛrɛ ka se o ra o yɛrɛ ta kuruyɔrɔw ra, min ye Seyiri kuruyɔrɔw ye, ka o gbɛn ka taga se fɔ Ɛli Paran, kongokolon kɛrɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","O kɔ, o tun sekɔra ka na Ɛni Misipati dugu kɔnɔ; o dugu tɔgɔ le ye fana ko Kadɛsi. O yɔrɔ ra, o tun ka Amalɛkikaw kɛrɛ, ka se o ra o ta mara bɛɛ ra, ani Amɔrikaw; olugu tun siginin bɛ Hasasɔn Tamari dugu le ra. ");
INSERT INTO dyu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ayiwa, Sodɔmu dugu masacɛ ka o ye minkɛ, ale wurira ka na o kama, ani Gomɔri dugu masacɛ, ani Adima dugu masacɛ, ani Seboyimu dugu masacɛ, ani Bela dugu masacɛ; o dugu tɔgɔ le ye fana ko Sowari. O masacɛw nana lɔ kɛrɛ kama Sidimu kɛnɛgbɛ ra, ");
INSERT INTO dyu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ko o bɛ Kedolamɛri kɛrɛ, min ye Elamu jamana masacɛ ye, ani Tidɛli, min ye Goyimu jamanaw masacɛ ye, ani Amurafɛli, min ye Sinehari jamana masacɛ ye, ani Ariyɔki, min ye Elasari dugu masacɛ ye. O masacɛ naani fana nana masacɛ looru kama. ");
INSERT INTO dyu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ayiwa, dinga caman tun bɛ Sidimu kɛnɛgbɛ ra, mananji tun bɛ o bɛɛ ra. Ka o to kɛrɛ ra, Sodɔmu masacɛ ni Gomɔri masacɛ ni o ta mɔgɔw nana kɛ bori ye; o boritɔ nana don o mananji dingaw ra. Minw sera ka bɔsi o ra, olugu borira ka taga kuruw fan fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kedolamɛri ni a nɔfɛmɔgɔw sera o ra; o ka Sodɔmu ni Gomɔri ta naforow bɛɛ cɛ ka taga ni o ye, ani o ta domunifɛnw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","O ka Iburama kɔrɔcɛ dencɛ Lutu fana mina ka taga ni a ye, ani a borofɛnw bɛɛ, sabu ale tun siginin bɛ Sodɔmu dugu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mɔgɔ dɔ boritɔ bɔra kɛrɛkɛyɔrɔ ra, ka na o fɔ Iburama ye; o tun bɛ Iburama wele ko Heburucɛ. O y’a sɔrɔ a tun bɛ Mamire ta yirisunbaw yɔrɔ ra. Mamire tun ye Amɔrika le ye. A balemaw tun ye Esikɔli ni Anɛri le ye. Olugu bɛɛ tun kɛra Iburama jɛnɲɔgɔnw ye fana. ");
INSERT INTO dyu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kabini Iburama k’a mɛn ko o ka a ta somɔgɔ dɔ mina, a ta baaraden minw worora a ta so, a ka olugu ra cɛfari kɛmɛ saba ni tan ni seegi labɛn kɛrɛ kama. O ka o masacɛw nɔgbɛn ka taga se fɔ Dan mara ra. ");
INSERT INTO dyu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Iburama k’a ta baaradenw taran ka o kɛ jɛnkuru caman ye; o tagara ben o masacɛw kan su fɛ. Iburama ka o kɛrɛ, a sera o ra, ka o gbɛn ka taga se fɔ Hoba; o dugu bɛ Damasi dugu sahiliyanfan fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","O tun ka naforo minw cɛ, a ka o bɛɛ mina o ra ka na ni a ye. A nana ni a belenden Lutu ye, ani Lutu borofɛnw bɛɛ, ani musow, ani mɔgɔ minanin tɔw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ayiwa, Iburama tagara masacɛ Kedolamɛri ni a masacɛ ɲɔgɔn tɔw kɛrɛ minkɛ, ka se o ra, a sekɔtɔ, Sodɔmu masacɛ bɔra ka taga a kunbɛn Sawe kɛnɛgbɛyɔrɔ ra, min bɛ wele ko masacɛ ta kɛnɛgbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ayiwa, Salɛmu dugu masacɛ, min ye Mɛlikisedɛki ye, ale nana Iburama fɛ ni buru ye, ani duvɛn. Ale tun ye Ala Kɔrɔtaninba ta sarakalasebaga le ye. ");
INSERT INTO dyu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","A ka dugawu kɛ Iburama ye; a ko: «Ala ye baraka don Iburama ra, Ala Kɔrɔtaninba, sankolo ni dugukolo tigi.» ");
INSERT INTO dyu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","A ko Iburama ma ko: «An ye Ala tando, ale min ka i juguw labla i ye.» Iburama k’a borofɛnw bɛɛ yaga bɔ k’a di Mɛlikisedɛki ma. ");
INSERT INTO dyu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodɔmu masacɛ nana Iburama kunbɛn, k’a fɔ a ye ko: «Ayiwa, ne ta mɔgɔw di ne ma, i ye to ni naforow ye.» ");
INSERT INTO dyu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Iburama k’a jaabi ko: «Ne bɛ kari Matigi Ala ra, Ala Kɔrɔtaninba, sankolo ni dugukolo tigi, ");
INSERT INTO dyu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ka kari, ko ne tɛna i borofɛn si ta; hali jesejuru, walama sanbara juru, ne tɛna o ta, janko i kana na a fɔ lon dɔ ko: ‹Ne le ka Iburama fɛntigiya.› Ne yɛrɛ tɛ foyi ta. ");
INSERT INTO dyu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kanbelenw ka min kɛ o ta domuni ye, o kɔni ye olugu ta ye; minw tagara ni ne ye kɛrɛ ra, Anɛri, ani Esikɔli, ani Mamire, olugu fana bɛna o ninyɔrɔ ta.» ");
INSERT INTO dyu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ayiwa, nin kow bɛɛ kɔ fɛ, Matigi Ala k’a yɛrɛ yira Iburama ra, k’a fɔ a ye ko: «Iburama, kana siran, ne le bɛ i tanga fɛn bɛɛ ma; ne le bɛna barajiba di i ma fana.» ");
INSERT INTO dyu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Iburama ka Ala jaabi ko: «Dunuɲatigi Ala, den tɛ ne fɛ. I bɛna mun le di ne ma min bɛ se ka ne mako ɲa? Ne ta baaraden Eliyezɛri min bɔra Damasi, o le bɛna kɛ ne ta so cɛntabaga ye.» ");
INSERT INTO dyu_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Iburama ko Ala ma tuun ko: «I ma duruja kɛ ne ye; ne ta baaraden min worora ne ta so, ale le bɛna ne cɛn ta.» ");
INSERT INTO dyu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Matigi Ala ka Iburama jaabi ko: «I ta baaraden le tɛna kɛ i ta cɛntabaga ye dɛ! I yɛrɛ bɛna den min woro cɔ, ale le bɛna i cɛn ta.» ");
INSERT INTO dyu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","O kɔ, Ala tagara ni Iburama ye kɛnɛ ma, k’a fɔ a ye ko: «Iburama, i ɲa kɔrɔta san fɛ ka lolow bɛɛ jate, ni i bɛ se; sabu i ta duruja bɛna caya o cogo le ra.» ");
INSERT INTO dyu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ayiwa, Iburama lara Matigi Ala ta kumakan na, Ala k’a jate mɔgɔ terennin ye. ");
INSERT INTO dyu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Matigi Ala ko a ma tuun ko: «Ne le ye Matigi Ala ye min ka i labɔ Uri, Kalide jamana ra, ka na nin jamana di i ma yan.» ");
INSERT INTO dyu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Iburama ka Ala jaabi ko: «Dunuɲatigi Ala, mun le bɛna a to ne b’a lɔn ka la a ra ko nin jamana bɛna kɛ ne ta ye?» ");
INSERT INTO dyu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Matigi Ala ko: «Misimuso kelen mina, ani ba musoman kelen, ani sagajigi kelen, o bɛɛ si ye kɛ san saba saba; tugani kelen mina fana, ani jɛnɛtugani fitini kelen.» ");
INSERT INTO dyu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Iburama ka o fɛnw bɛɛ mina; a ka o faga, ka o bɛɛ kelen kelen cɛtigɛ fla ye o cɛmancɛ ra, ka o kunkurunw blabla ka o ɲasin ɲɔgɔn ma. A ma kɔnɔw le cɛtigɛ fla ye. ");
INSERT INTO dyu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Dɔɔnin kɛra, duga dɔw nana kɛ jigi ye o sogow kɔ. Iburama tora ka o gbɛn. ");
INSERT INTO dyu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ayiwa, terebenda surunyara tuma min na, sunɔgɔba dɔ ka Iburama ta. Siranyaba dɔ barara k’a mina, ka dibi don a ma k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Matigi Ala ko Iburama ma ko: «Iburama, i ka kan k’a lɔn ko lon dɔ i ta duruja bɛna taga kɛ lonan ye jamana wɛrɛ ra. O bɛna kɛ jɔnw le ye o jamana ra; o bɛna o tɔɔrɔ fɔ san kɛmɛ naani. ");
INSERT INTO dyu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nka jamana min bɛna o bla o jɔnya ra, ne bɛna ne ta kiti ben o jamana mɔgɔw kan; o kɔ, i ta duruja bɛna bɔ o jamana ra ni naforo caman ye. ");
INSERT INTO dyu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ele kɔni bɛna sa ɲasuma ra. I bɛna kɔrɔya diyabɔ, ka sɔrɔ ka sa, o bɛ i su don. ");
INSERT INTO dyu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","I ta mɔgɔw ta duruja naaninan le bɛna sekɔ ka na yan, sabu yan jamana mɔgɔw, minw ye Amɔrikaw ye, olugu ta kojugu ma tɛmɛ a dan kan fɔlɔ ka se o gbɛn ma.» ");
INSERT INTO dyu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ayiwa, tere nana ben ka dibiba don tuma min na, tasuma dɔ ka sisi bɔ, ka mana sogo cɛtigɛninw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","O lon yɛrɛ ra, Matigi Ala ka jɛnɲɔgɔnya* don ni Iburama ye, k’a fɔ a ye ko: «Ne bɛ nin jamana di i ta duruja le ma; k’a damina Misiran ba ra, ka taga a bla fɔ ba belebele ra, min ye Efirati ba ye. ");
INSERT INTO dyu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","O yɔrɔ ye Kenikaw ta jamana le ye, ani Kenazikaw, ani Kadimonikaw, ");
INSERT INTO dyu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ani Hɛtikaw, ani Perezikaw, ani Refayikaw, ");
INSERT INTO dyu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ani Amɔrikaw, ani Kanaanakaw, ani Girigasikaw, ani Yebusikaw.» ");
INSERT INTO dyu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Iburama ta muso Sarayi tun ma den woro a ye. Ayiwa, Misiranka sunguru dɔ tun bɛ Sarayi fɛ baaradenya ra, min tɔgɔ tun ye ko Hajara. ");
INSERT INTO dyu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Lon dɔ, Sarayi ko Iburama ma ko: «Iburama, a flɛ, Matigi Ala ka ne kɛ denworobari ye. Sabari ka jɛn ni ne ta baaraden sunguru ye; a bɛ se ka kɛ ko ale bɛna den sɔrɔ ne ye.» Iburama sɔnna Sarayi ta kuma ma. ");
INSERT INTO dyu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ayiwa, Iburama muso Sarayi k’a ta baaraden Misiranka sunguru ta o cogo le ra k’a di a cɛ Iburama ma, k’a kɛ a muso ye. O y’a sɔrɔ Iburama tun ka san tan le kɛ Kanaana jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Iburama jɛnna ni Hajara ye; Hajara nana kɔnɔ ta. Kabini a k’a ye ko ale ka kɔnɔ ta, a ka kɛ ɲadonya kɛ ye a matigimuso ra, k’a dɔgɔya. ");
INSERT INTO dyu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarayi k’a ye ten minkɛ, a k’a fɔ Iburama ye ko: «Iburama, Hajara bɛ ɲadonya min kɛra ne ra sisan, ele le ye o sababu ye. Ne le ka ne ta baaraden di ele ma; ale nana a ye ko a ka kɔnɔ ta minkɛ o, sisan ale bɛ ne kɛra dɔgɔyafɛn ye. Ayiwa, Matigi Ala le bɛna o kiti tigɛ an ni ɲɔgɔn cɛ!» ");
INSERT INTO dyu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Iburama ka Sarayi jaabi ko: «I ta baaraden bɛ i ta bla le ra. Fɛn min ka i diya, i ye o kɛ a ra.» O fɔra minkɛ, Sarayi ka kɛ Hajara tɔɔrɔ ye, fɔ a ma ɲa Hajara borira ka bɔ so kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Matigi Ala ta mɛlɛkɛ ka Hajara ye kongokolon kɔnɔ, bunun dɔ kɔrɔ; o bunun bɛ Suri kongokolon sira kɛrɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mɛlɛkɛ ko: «Hajara, Sarayi ta baaraden, i bɔra min, i bɛ taga min?» Hajara ko: «Ne bɛ borira ne matigimuso Sarayi le ɲa.» ");
INSERT INTO dyu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Matigi Ala ta mɛlɛkɛ ko: «Sekɔ ka taga i matigimuso fɛ, ka taga i yɛrɛ majigi a ye.» ");
INSERT INTO dyu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mɛlɛkɛ ko: «Ne bɛna i ta duruja caya, k’a kɛ fɔ mɔgɔ tɛna se ka o jate. ");
INSERT INTO dyu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","A flɛ, i ka kɔnɔ ta, i bɛna dencɛ woro. I bɛna a tɔgɔ la ko Sumayila, sabu Matigi Ala ka i ta jusukasikan mɛn. ");
INSERT INTO dyu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","O den bɛna kɛ i ko kongo fali; a bɛna kɛ kɛrɛ ra ni bɛɛ ye, bɛɛ bɛna kɛ kɛrɛ ra ni a ye fana. A bɛna a ta so lɔ a danna, ka sigi k’a mabɔ a balemaw bɛɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hajara ko: «E! Ala min bɛ ne yera, yala can lo ko ne ka ale le ye tan wa?» Matigi Ala tun kumana Hajara fɛ minkɛ, Hajara k’a tɔgɔ wele ko: Ata Ɛli Royi. ");
INSERT INTO dyu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","O kosɔn Hajara tun bɛ kɔlɔn min kɔrɔ, o kɔlɔn tɔgɔ lara fana ko Lasayi Royi ta kɔlɔn. A bɛ Kadɛsi dugu ni Berɛdi dugu cɛ. ");
INSERT INTO dyu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ayiwa, o kow kɔ, Hajara nana dencɛ woro Iburama ye. Iburama ka den tɔgɔ la ko Sumayila. ");
INSERT INTO dyu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hajara ka Sumayila woro Iburama ye, ka Iburama si to san biseegi ni san wɔɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ayiwa, Iburama nana san bikɔnɔntɔn ni kɔnɔntɔn sɔrɔ tuma min na, Matigi Ala k’a yɛrɛ yira a ra, k’a fɔ a ye ko: «Ne le ye Ala Sebɛɛtigi ye. Tagama ne ɲa kɔrɔ, ka kɛ mɔgɔ jusukungbɛnin ye. ");
INSERT INTO dyu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ne bɛna ne ta jɛnɲɔgɔnya* don ni i ye, ka i ta duruja caya kosɛbɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Iburama ka o mɛn minkɛ, a k’a kinbiri gban k’a ɲa biri dugu ma, ka Ala bato. Ala kumana a fɛ tuun ko: ");
INSERT INTO dyu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Ne bɛ jɛnɲɔgɔnya min don ni i ye, o ye nin ye: I bɛna kɛ siya caman facɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","I tɔgɔ tɛna kɛ Iburama ye tuun. I bɛna wele sisan ko Iburahima; sabu ne bɛna i kɛ siya caman bɛmacɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ne bɛna i ta denw caya kosɛbɛ. I ta denw bɛna kɛ siya caman le ye; masacɛ caman bɛna bɔ i ta siyaw ra. ");
INSERT INTO dyu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ne bɛna to ne ta jɛnɲɔgɔnya ra ni i ye, ani i ta duruja min o min bɛna na i kɔ fɛ; o jɛnɲɔgɔnya bɛna to ne ni olugu bɛɛ cɛ, wagati bɛɛ. O bɛna kɛ jɛnɲɔgɔnya wuribari le ye. O le sababu ra ne bɛna kɛ i ta Ala ye; i ta duruja minw bɛna na i kɔ fɛ, ne bɛ kɛ olugu fana ta Ala ye. ");
INSERT INTO dyu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I bɛ lonanya ra jamana min na bi, ne bɛna o jamana di i ma, ani i ta duruja minw bɛna na i kɔ fɛ. O ye Kanaana jamana bɛɛ ye; ne bɛna o di o ma, k’a kɛ o ta ye wagati bɛɛ; ne bɛna kɛ o ta Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ala ko Iburahima ma ko: «Ele kɔni ka kan ka ne ta jɛnɲɔgɔnya* sira tagama, ani i ta duruja minw bɛna na i kɔ fɛ, o bɛɛ ka kan k’a tagama o ta wagatiw ra, tuma bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ayiwa, aw ka kan ka ne ta jɛnɲɔgɔnya sira tagama. O jɛnɲɔgɔnya ka kan ka to ne ni aw cɛ wagati bɛɛ, ele ni i ta duruja min bɛna na i kɔ fɛ. Ayiwa, o jɛnɲɔgɔnya tagamasiyɛn ye nin ye, ko aw ra cɛden bɛɛ ka kan ka kɛnɛsigi. ");
INSERT INTO dyu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Aw ka kan ka kɛnɛsigi ka o kɛ jɛnɲɔgɔnya tagamasiyɛn ye ne ni aw cɛ. ");
INSERT INTO dyu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Cɛden bɛɛ ka kan ka kɛnɛsigi a worolon tere seeginan na; a bɛna kɛ ten le i ta duruja bɛɛ ra wagati bɛɛ. Jɔn minw worora i ta so, walama i ka minw san ka bɔ siya wɛrɛ ra, siya min tɛ i ta siya dɔ ye, olugu bɛɛ ka kan ka kɛnɛsigi fana. ");
INSERT INTO dyu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","«O cogo ra, jɔn minw worora i ta so, ani i ka minw san, o bɛɛ ka kan ka kɛnɛsigi. Ni o kɛra, ne ta jɛnɲɔgɔnya tagamasiyɛn bɛna kɛ aw farisogo ra, ka kɛ jɛnɲɔgɔnya wuribari ye. ");
INSERT INTO dyu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ni cɛden min ma kɛnɛsigi, ka o nɔ kɛ a farisogo ra, o ka kan ka faran ka bɔ a ta jamanamɔgɔw cɛ ra, sabu a ka ne ta jɛnɲɔgɔnya cɛn.» ");
INSERT INTO dyu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ayiwa, o kɔ, Ala k’a fɔ Iburahima ye tuun ko: «I kana i ta muso Sarayi wele tuun ko Sarayi. Sisan a tɔgɔ bɛna la ko Saran. ");
INSERT INTO dyu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ne bɛna baraka don a ra, k’a to a ye den woro i ye. Ne bɛna baraka don a ra k’a kɛ siya caman bamuso ye. Siya dɔw ta masacɛw bɛna bɔ a ta duruja ra.» ");
INSERT INTO dyu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Iburahima ka o mɛn minkɛ, a k’a kinbiri gban k’a ɲa biri dugu ma ka Ala bato. A yɛrɛkora k’a fɔ a yɛrɛ kɔnɔ ko: «Mɔgɔ min ka san kɛmɛ sɔrɔ, o bɛ se ka den sɔrɔ cogo di? Saran fana ye san bikɔnɔntɔn; ale bɛna den woro cogo di tuun?» ");
INSERT INTO dyu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","A k’a fɔ Ala ye ko: «A to Sumayila le ye si sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nka Ala k’a jaabi ko: «Ale tɛ dɛ! I ta muso Saran le bɛna dencɛ woro i ye. I bɛna a tɔgɔ la ko Isiyaka. Ne bɛna to jɛnɲɔgɔnya ra ni ale ye, ani a ta duruja min bɛna na a kɔ fɛ; o bɛna kɛ jɛnɲɔgɔnya wuribari le ye. ");
INSERT INTO dyu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","«Min ye Sumayila ta ye, i ka min daari ale ta ko ra, ne bɛna o kɛ i ye. Ne bɛna baraka don a ra, ka den caman di a ma, k’a ta duruja caya kosɛbɛ. A bɛna masaden tan ni fla le woro. Ne bɛna a kɛ siya caman facɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Saran bɛna Isiyaka min woro i ye san wɛrɛ ɲɔgɔntumasi, ne bɛna to jɛnɲɔgɔnya ra ni ale le ye.» ");
INSERT INTO dyu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ala kumana ni Iburahima ye ka ban tuma min na, a bɔra Iburahima kɔrɔ ka yɛlɛn san fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ayiwa, o lon yɛrɛ ra, Iburahima ka Sumayila kɛnɛsigi; jɔn minw worora a ta so, ani a tun ka minw bɛɛ san, a ka olugu bɛɛ kɛnɛsigi. Cɛden o cɛden tun bɛ a ta so kɔnɔ, Iburahima ka olugu bɛɛ kɛnɛsigi, i n’a fɔ Ala tun k’a fɔ a ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Iburahima yɛrɛ kɛnɛsigira k’a si to san bikɔnɔntɔn ni kɔnɔntɔn. ");
INSERT INTO dyu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","A dencɛ Sumayila kɛnɛsigira k’a si to san tan ni saba. ");
INSERT INTO dyu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Iburahima ni a dencɛ Sumayila bɛɛ kɛnɛsigira o lon kelen na, ");
INSERT INTO dyu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ani cɛ o cɛ tun bɛ Iburahima ta so; jɔn minw worora a ta so, ani a ka minw san ka bɔ siya wɛrɛw ra, o bɛɛ kɛnɛsigira ni a ye o lon na. ");
INSERT INTO dyu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","O kow kɔ, Matigi Ala k’a yɛrɛ yira Iburahima ra tuun Mamire ta yirisunbaw kɔrɔ. Iburahima tun siginin bɛ a ta fanibon da ra, teregban papa fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A nana a ɲa kɔrɔta minkɛ, a barara ka cɛ saba ye. A teliyara ka bɔ a ta fanibon kɔrɔ ka taga o kunbɛn, ka biri ka o fo ni bonya ye. ");
INSERT INTO dyu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","A ko o ra kelen ma ko: «Ne matigicɛ, ni aw tun bɛ sɔn ka sabari ka lɔ aw ta jɔncɛ kɔrɔ dɔɔnin, o tun bɛna kɛ bonyaba le ye ne fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Aw y’a to o ye na ni ji dɔɔnin ye ka na aw senw ko, aw ye nɛnɛkiri yirisuma ra yan dɔɔnin. ");
INSERT INTO dyu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ne bɛna taga domuni fitini ɲini ka na o di aw ma, janko aw ye o domu ka baraka dɔɔnin don aw yɛrɛ ra, aw bɛ sɔrɔ ka taga aw ta tagama fɛ. O le kosɔn Ala k’a to aw tɛmɛna aw ta jɔncɛ kɔrɔ yan.» O ka Iburahima jaabi ko: «Ayiwa, a kɛ ten.» ");
INSERT INTO dyu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Iburahima teliyara ka don a ta fanibon kɔnɔ Saran nɔ fɛ, k’a fɔ a ye ko: «Teliya ka mugu tɛntɛnnin minan ɲa saba suma, k’a nɔɔni k’a kɛ ŋɔmi ye.» ");
INSERT INTO dyu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","A borira ka taga a ta misiwɛrɛ ra, ka taga misiden ɲanaman tɔrɔnin dɔ mina, ka o di a ta baaraden dɔ ma. Ale ka o faga ka o labɛn joona. ");
INSERT INTO dyu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","O kɔ, a nana ni nɔnɔkumu ni nɔnɔkɛnɛ ye, ani o misiden sogo tobinin, ka na o sigi cɛ saba kɔrɔ; ale yɛrɛ ka lɔ o kɛrɛ fɛ, yirisuma ra. O cɛ saba ka domuni kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","O ka Iburahima ɲininka ko: «I ta muso Saran bɛ min le?» A ko: «A bɛ fanibon kɔnɔ yan.» ");
INSERT INTO dyu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","O ra kelen ko: «Sigiya t’a ra, ne bɛna sekɔ ka na i fɛ yan san wɛrɛ ɲɔgɔntumasi; o tuma i ta muso Saran bɛna dencɛ sɔrɔ.» Saran tun bɛ o kuma mɛnna, k’a siginin to fanibon donda ra a cɛ kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","O wagati ra Iburahima ni Saran tun kɔrɔra kosɛbɛ. Denworo wagati fana tun tɛmɛna Saran kan. ");
INSERT INTO dyu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ayiwa, Saran ka o mɛn minkɛ, a yɛrɛkora a yɛrɛ kɔnɔ. A ko: «Ne kɔrɔninba nin bɛna mun nafa le sɔrɔ cɛko ra tuun fɔ ka na den woro? Ne matigicɛ fana kɔrɔnin lo.» ");
INSERT INTO dyu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Matigi Ala k’a fɔ Iburahima ye ko: «Mun kosɔn Saran yɛrɛkora k’a fɔ a yɛrɛ kɔnɔ ko yala ale kɔrɔninba nin bɛ se ka den woro can na wa? ");
INSERT INTO dyu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Fɛn juman le bɛ se ka gbɛlɛya fɔ ka Matigi Ala kaɲa? San wɛrɛ ɲɔgɔntumasi, ne bɛna na i fɛ yan; o tuma Saran bɛna dencɛ sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","O kuma fɔra minkɛ, Saran siranna; a ma sɔn ka lɔ a ra. A ko: «Ne ma yɛrɛko dɛ!» A ka o fɔ sabu a tun siranna. Matigi Ala ko: «I yɛrɛkora yɛrɛ le.» ");
INSERT INTO dyu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ayiwa, o kɔ, o cɛ saba wurira ko o bɛ taga. O ka Sodɔmu dugu fan flɛ. Iburahima wurira ka taga o blasira. ");
INSERT INTO dyu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Matigi Ala ko: «Ne bɛna min kɛ Sodɔmu ni Gomɔri ra, yala ne bɛ se ka o dogo Iburahima ma wa? ");
INSERT INTO dyu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Sabu sigiya t’a ra, Iburahima bɛna kɛ siyaba le ye, ani siya fangatigi. Dugukolo siyaw bɛɛ bɛna baraka sɔrɔ ale le sababu ra. ");
INSERT INTO dyu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ne k’a ɲanawoloma, janko a ye a fɔ a ta denw ye, ani a ta somɔgɔ minw bɛna na a kɔ fɛ, ko o ye Matigi Ala ta sira tagama ka ɲa, ka tagama terenninya ni can kan. Ni o kɛra, ne Matigi Ala ka fɛn minw layiri ta Iburahima ye, ne bɛna o kɛ a ye.» ");
INSERT INTO dyu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ayiwa, Matigi Ala ko Iburahima ma ko: «Sodɔmu dugumɔgɔw, ani Gomɔri dugumɔgɔw jarakikan cayara; o ta jurumunw cayara kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","O kosɔn ne bɛna jigi ka taga a flɛ, ni i y’a sɔrɔ ko min bɛɛ bɛ fɔra o ta ko ra, o b’a kɛra o cogo yɛrɛ le ra; walama ni a fana kɛra ko o tɛ, ne bɛna o lɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","O cɛw bɔra Iburahima kɔrɔ, ka taga Sodɔmu dugu fan fɛ. Nka Iburahima belen lɔnin tora Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","A gbarara ɲa fɛ k’a fɔ Ala ye ko: «Matigi Ala, yala i bɛ sɔn ka mɔgɔɲuman ni mɔgɔjugu bɛɛ halaki ɲɔgɔn fɛ wa? ");
INSERT INTO dyu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","I n’a sɔrɔ ko mɔgɔɲuman bilooru bɛ dugu kɔnɔ. Yala i bɛ sɔn ka olugu fana halaki wa? I tɛna yafa dugu bɛɛ ma o mɔgɔɲuman bilooru kosɔn wa? ");
INSERT INTO dyu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ka mɔgɔɲuman ni mɔgɔjugu bɛɛ halaki ɲɔgɔn fɛ, walama ka mɔgɔɲuman ni mɔgɔjugu bɛɛ sara kɛ kelen ye, ne k’a lɔn ko i tɛ sɔn o ko ɲɔgɔn ma fiyewu. O tuma ele min bɛ dunuɲamɔgɔw bɛɛ ta kiti tigɛ, ele le tɛna se ka koɲuman ni kojugu lɔn ka bɔ ɲɔgɔn na wa?» ");
INSERT INTO dyu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Matigi Ala ka Iburahima jaabi ko: «Ni ne ka mɔgɔɲuman bilooru sɔrɔ Sodɔmu dugu kɔnɔ, ne bɛ yafa dugu bɛɛ ma, o mɔgɔɲuman bilooru kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Iburahima k’a fɔ Ala ye tuun ko: «Sabari k’a to ne ye kuma tuun, ne min tɛ foyi ye ni buguri ni bugurigbɛ tɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","A ko: «Matigi, i n’a sɔrɔ ko dugu mɔgɔɲumanw tɛna mɔgɔ bilooru bɔ. Mɔgɔ looru bɛ se k’a jɛn. Ayiwa, ni mɔgɔ looru dɔrɔn ka mɔgɔ bilooru jɛn o, o mɔgɔ looru kosɔn i bɛna dugu bɛɛ halaki wa?» Matigi Ala ko: «Ni ne ka mɔgɔɲuman binaani ni looru sɔrɔ dugu kɔnɔ, ne tɛna dugu halaki o mɔgɔɲuman binaani ni looru kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Iburahima kumana Ala fɛ tuun, ko: «I n’a sɔrɔ ko dugu mɔgɔɲumanw tɛna tɛmɛ mɔgɔ binaani kan.» Matigi Ala ko: «O mɔgɔ binaani kosɔn, ne tɛna foyi kɛ dugu ra.» ");
INSERT INTO dyu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Iburahima ko tuun ko: «Matigi, i kana dimi ne kɔrɔ. Ne bɛna kuma tuun: ni a sɔrɔra ko dugu mɔgɔɲuman bɛɛ tagara kɛ mɔgɔ bisaba le ye do?» Ala ko: «Ni ne ka mɔgɔɲuman bisaba sɔrɔ yi, ne tɛna foyi kɛ dugu ra.» ");
INSERT INTO dyu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iburahima ko: «Matigi, sabari k’a to ne ye kuma tuun: i n’a sɔrɔ ko dugu mɔgɔɲuman bɛna dan mɔgɔ mugan le ma. Ni a kɛra o ye do?» Matigi Ala ko: «Ne tɛna dugu halaki o mɔgɔ mugan kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Iburahima ko: «Matigi, sabari, i kana dimi ne kɔrɔ; ne ta kuma bɛna dan nin le ma: ayiwa, ni dugu mɔgɔɲuman bɛɛ nana kɛ mɔgɔ tan le ye do?» Matigi Ala ko: «Ne tɛna dugu halaki o mɔgɔ tan kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Matigi Ala banna kuma ra ni Iburahima ye minkɛ, a tagara. Iburahima sekɔra ka taga a ta so. ");
INSERT INTO dyu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ayiwa, o mɛlɛkɛ fla tagara se Sodɔmu o lon wulada fɛ. Lutu tun siginin bɛ dugu donda ra. A ka o ye minkɛ, a wurira ka taga o kunbɛn. A k’a kinbiri gban, k’a ɲa biri dugu ma ka o fo ni bonya ye. ");
INSERT INTO dyu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","A ko: «Ne matigicɛw, aw ye sabari ka na jigi aw ta jɔncɛ ta so, janko ne ye ji di aw ma, aw ye aw senw ko. O kɔ, aw bɛ si yan. Aw bɛna wuri sini sɔgɔmada joona fɛ, ka taga aw ta tagama fɛ.» Mɛlɛkɛw ka Lutu jaabi ko: «Ɔn-ɔn, an bɛna si kɛnɛ ma yan.» ");
INSERT INTO dyu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nka Lutu kumana o fɛ k’a gbɛlɛya, fɔ o tagara ni a ye ka taga jigi a ta so. A ka domuniba labɛn o ye, ka burufunubari kɛ o ye. O ka domuni kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Dɔɔnin kɛra, Sodɔmu dugumɔgɔw nana bon lamini, k’a sɔrɔ lonanw yɛrɛ tun ma la fɔlɔ. Denmisɛn o, mɔgɔkɔrɔba o, o bɛɛ le tun nana. ");
INSERT INTO dyu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","O ka Lutu wele k’a fɔ a ye ko: «Mɔgɔ minw nana i fɛ bi su fɛ, o bɛ min le? O labɔ yan, an bɛ jɛn ni o ye.» ");
INSERT INTO dyu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutu bɔra ka na o kɔ kɛnɛ ma, ka bon dasɔgɔ lonanw da ra yi. ");
INSERT INTO dyu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","A ko mɔgɔw ma ko: «Ne balemaw, aw ye sabari, aw kana sɔn nin kojugu ɲɔgɔn ma. ");
INSERT INTO dyu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ne denmuso fla bɛ yan, o si ma cɛko lɔn fɔlɔ; ne bɛna olugu labɔ aw fɛ kɛnɛ ma yan. Ni fɛn o fɛn ka aw diya, aw ye o kɛ olugu ra. Aw kana foyi kɛ nin mɔgɔw ra; sabu o nana jigi ne ta so le.» ");
INSERT INTO dyu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mɔgɔw k’a fɔ Lutu ye ko: «Ele ye bɔ yi dɛ!» Dɔw ko: «Aw ye cɛ nin flɛ dɛ! Ale min ye lonan ye, ale nana kɛ ko a bɛ sariya yira an na sisan!» O k’a fɔ Lutu ye ko: «Ni i ma bɔ an ɲa sisan, an bɛna min kɛ ele ra, o bɛna juguya ni i ta lonanw yɛrɛ ta ye.» O ka Lutu ɲɔni ka bɔ yi fanga ra, ka gbara ko o bɛ da kari. ");
INSERT INTO dyu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","O tuma ra, mɛlɛkɛ fla ka da yɛlɛ ka Lutu mina k’a ladon bon kɔnɔ, ka da sɔgɔ. ");
INSERT INTO dyu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Mɔgɔ minw bɛɛ tun bɛ bonda ra, mɛlɛkɛw ka olugu bɛɛ fiyen; k’a ta denmisɛnw na ka taga a bla mɔgɔkɔrɔbaw ra, o bɛɛ. A kɛra ten, o ka da yɔrɔɲini ka dɛsɛ. ");
INSERT INTO dyu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mɛlɛkɛ fla k’a fɔ Lutu ye ko: «Mɔgɔ o mɔgɔ ye i ta mɔgɔ ye yan, i burancɛw, i dencɛw, i denmusow, mɔgɔ o mɔgɔ ye i ta mɔgɔ ye yan, o bɛɛ labɔ dugu nin kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","An bɛna nin dugu bɛɛ halaki le; sabu o bɛ nin dugumɔgɔw jarakira kojugu minw na, o jarakikow cayara ka tɛmɛ a dan kan Matigi Ala ɲa kɔrɔ. O kosɔn Matigi Ala ka an ci ka na dugu halaki.» ");
INSERT INTO dyu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ayiwa, Lutu bɔra ka taga kuma a burancɛw fɛ, minw tun bɛna a denmusow furu; a ko o ma ko: «Aw ye wuri, an ye taga ka bɔ dugu nin kɔnɔ, sabu Matigi Ala bɛna dugu halaki!» Nka a kɛra a burancɛw ɲa na i ko Lutu bɛ toron le kɛra o fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kɛnɛbɔda fɛ, mɛlɛkɛw kumana Lutu fɛ tuun, ka a gbɛlɛya a ma; o ko: «Wuri, i ta muso boro mina, ani i denmuso fla minw bɛ i fɛ yan, janko kiti min bɛna ben nin dugu kan, aw fana kana na halaki o kiti ra ni o ye.» ");
INSERT INTO dyu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ayiwa, mɛlɛkɛw nana a ye ko o tɛ teliyara minkɛ, o ka Lutu mina a boro ma, ani a muso, ni a denmuso fla. Mɛlɛkɛw bɔra ni o ye ka taga o bla dugu kɔ fɛ; sabu Matigi Ala tun b’a fɛ ka o tanga. ");
INSERT INTO dyu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","O bɔnin kɔ dugu kɔnɔ, mɛlɛkɛ kelen ko Lutu ma ko: «Aw ye bori ka aw yɛrɛ kisi. Aw kana flɛri kɛ kɔ fɛ, aw fana kana lɔ kɛnɛgbɛba nin yɔrɔ si ra. Aw ye bori ka taga fɔ kuruw fan fɛ, janko aw kana halaki.» ");
INSERT INTO dyu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lutu ko: «E! Matigi, an tɛna se ka o yɔrɔ sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Aw makarira an na, aw ɲana an ma ka an kisi ka na se fɔ yan; nka an kɔni tɛna se ka bori ka se fɔ kuruw yɔrɔ ra, sabu sani an ye se yi, cɛnri bɛna kɛ, anw fana bɛna halaki. ");
INSERT INTO dyu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Dugu dɔ flɛ nin ye, o yɔrɔ man jan. An bɛ se ka bori ka se o ma, ka taga dogo yi; o dugu fana man bon. E! Aw ye sabari k’a to an ye taga dogo o dugudennin na, janko an ye kisi. Duguba tɛ o. Aw y’a to an ye taga an yɛrɛ kisi o yɔrɔ ra.» ");
INSERT INTO dyu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mɛlɛkɛ ko: «Ne bɛ o kelen fana kɛ aw ye tuun. I ka dugu min ko fɔ, ne tɛna o halaki. ");
INSERT INTO dyu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Aw ye teliya ka taga dogo yi, sabu ni aw ma se yi, ne tɛna se ka foyi kɛ.» O le kosɔn o dugu tɔgɔ nana la ko Sowari. ");
INSERT INTO dyu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Teresun wurituma le kɛra Lutu dontuma ye Sowari dugu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","O tuma ra Matigi Ala ka kiribi ni tasuma lajigi Sodɔmu dugu ni Gomɔri dugu kan i ko sanji. Matigi Ala yɛrɛ le tun ka o kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","A ka o duguw bɛɛ jɛni, ani o kɛnɛgbɛ bɛɛ, ani a dugumɔgɔw bɛɛ, ani a yirisunw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ayiwa, o tagatɔ, Lutu ta muso k’a kɔflɛ; a yɛlɛmana ka kɛ kɔgɔkuru ye. ");
INSERT INTO dyu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ayiwa, o dugusagbɛ sɔgɔmada joona fɛ, Iburahima tun kumana ni Matigi Ala ye yɔrɔ min na, a wurira ka taga o yɔrɔ kelen na. ");
INSERT INTO dyu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","A k’a ɲa kɔrɔta ka flɛri kɛ Sodɔmu ni Gomɔri duguw fan fɛ, ani o yɔrɔ kɛnɛgbɛba bɛɛ ra. A ka sisiba dɔ wuritɔ ye ka bɔ yi i ko dibiba dɔ sisi. ");
INSERT INTO dyu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lon min Ala tun bɛ o kɛnɛgbɛba ta duguw halakira, a hakiri tora Iburahima ra; o kosɔn a ka Lutu kisi ka bɔ tasuma ra. Lutu tun tagara sigi o dugu minw na, o tasuma le ka o duguw bɛɛ halaki. ");
INSERT INTO dyu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ayiwa, Lutu ma sɔn ka to Sowari dugu kɔnɔ. A bɔra ka taga sigi kuruw fanfɛyɔrɔ dɔ ra, sabu a tun bɛ siranna. A tagara to kuruwo dɔ ra, ale ni a denmuso fla. ");
INSERT INTO dyu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lon dɔ, Lutu denmuso kɔrɔba k’a fɔ a dɔgɔmuso ye ko: «An facɛ kɔrɔra; cɛ fana tɛ yan min bɛ se ka an furu i n’a fɔ a bɛ kɛ yɔrɔ tɔw ra cogo min na. ");
INSERT INTO dyu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","A to an ye duvɛn di an facɛ ma, a y’a min ka ɲanamini. Ni o kɛra, an bɛ la ni a ye, janko an ye den sɔrɔ, k’a to an facɛ ta siya kana tunu.» ");
INSERT INTO dyu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","O lon su fɛ, o ka duvɛn di o facɛ ma, a k’a min fɔ ka ɲanamini; kɔrɔmusoman ka taga la ni a ye o lon su fɛ. Facɛ m’a latuma lɔn, a m’a wurituma lɔn fana. ");
INSERT INTO dyu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Dugu gbɛra minkɛ, kɔrɔmusoman ko dɔgɔmusoman ma ko: «Su ra ne lara ni an facɛ ye. Bi su fɛ an ye duvɛn dɔ wɛrɛ di a ma tuun, a y’a min fɔ ka ɲanamini; ele ye taga la ni a ye, janko i ye den sɔrɔ, k’a to an facɛ ta siya kana tunu.» ");
INSERT INTO dyu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","O lon su fɛ, o ka duvɛn di o facɛ ma tuun, a k’a min fɔ ka ɲanamini. Dɔgɔmusoman ka taga la ni a ye. Facɛman m’a latuma lɔn, a m’a wurituma lɔn fana. ");
INSERT INTO dyu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ayiwa, denmuso fla nana kɔnɔ ta o facɛ Lutu fɛ o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kɔrɔmusoman nana dencɛ woro; a k’a tɔgɔ la ko Mohabu. Ale le kɛra Mohabukaw bɛmacɛ ye ka na se fɔ bi ma. ");
INSERT INTO dyu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Dɔgɔmusoman fana nana dencɛ woro; a k’a tɔgɔ la ko Bɛni Ami. Ale le kɛra Amɔnkaw bɛmacɛ ye ka na se fɔ bi ma. ");
INSERT INTO dyu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ayiwa, Iburahima nana bɔ a sigiyɔrɔkɔrɔ ra, ka taga sigi Kanaana jamana woroduguyanfan fɛ. A tagara sigi Kadɛsi dugu ni Suri kongokolon cɛ. O kɔ, a ka wagati dama kɛ Gerari dugu fana ra. ");
INSERT INTO dyu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Iburahima tun bɛ to k’a fɔ mɔgɔw ye ko Saran ye ale dɔgɔmuso le ye. O kɛra sababu ye k’a to Gerari dugu masacɛ min ye Abimelɛki ye, ale ka mɔgɔ dɔ ci ka taga Saran ta ka na a fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","O lon su fɛ, Ala k’a yɛrɛ yira Abimelɛki ra siko ra, k’a fɔ a ye ko: «Abimelɛki, i bɛna sa, sabu i ka muso min mina nin ye, ko i b’a kɛ i ta ye, cɛ b’a fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ayiwa, o y’a sɔrɔ Abimelɛki tun ma jɛn ni Saran ye fɔlɔ. A ko Ala ma siko ra ko: «Matigi, i bɛ sɔn ka ne ni ne ta siya halaki k’a sɔrɔ an ma kojugu foyi kɛ wa? ");
INSERT INTO dyu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Cɛ yɛrɛ le m’a fɔ ne ye ko a dɔgɔmuso lo wa? Muso fana m’a fɔ ko ale kɔrɔcɛ lo wa? Ne kɔni ka nin ko kɛ ni jusukun gbɛnin le ye, ne ma jaraki!» ");
INSERT INTO dyu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ala k’a fɔ Abimelɛki ye o siko kelen na ko: «Ne k’a lɔn ko i ka nin ko kɛ ni jusukun gbɛnin le ye, ko i ma kojugu kɛ; o kosɔn ne ma sɔn k’a to i ye jɛn ni a ye, ka ne hakɛ ta. ");
INSERT INTO dyu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sisan cɛ nin ta muso di a ma, sabu cira lo; a bɛna Ala daari i ye janko i kana sa. Nka ni i ma a muso di a ma, i ye la a ra k’a lɔn ko i bɛna sa le, ele ni i ta mɔgɔw bɛɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelɛki wurira sɔgɔmada joona fɛ; a k’a ta baaradenw bɛɛ wele, ka o kow fɔ olugu ye. Olugu ka o mɛn minkɛ, o bɛɛ siranna. ");
INSERT INTO dyu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelɛki ka Iburahima fana wele, k’a fɔ ale ye ko: «Cɛ, ele ka mun ko le kɛ an na tan? O tuma ne ka mun kojugu le kɛ i ra fɔ ka na a kɛ i ka nin jurumun ɲɔgɔn lase ne ni ne ta jamana mɔgɔw ma? I kɔni ka min kɛ nin ye, o tɛ ko kɛta ye fiyewu. ");
INSERT INTO dyu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","I ka nin ko kɛ k’a la kɔrɔ juman le kan?» ");
INSERT INTO dyu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Iburahima ko: «Ne tun b’a miirira ko i b’a sɔrɔ mɔgɔ si tɛ siran Ala ɲa nin jamana ra, ko o bɛna ben ne kan ka ne faga ne ta muso kosɔn. O le kosɔn ne k’a fɔ ko ne dɔgɔmuso lo. ");
INSERT INTO dyu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","O bɛɛ n’a ta, ne dɔgɔmuso lo fana. An bɛ fa kelen na, nka an tɛ ba kelen le ra. A kɛra ne muso ye fana. ");
INSERT INTO dyu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","O kosɔn lon min Ala ka ne labɔ ne faso ra, ne k’a fɔ Saran ye ko: ‹Ne bɛ i daari, sabari, ni an ka se yɔrɔ o yɔrɔ, a fɔ mɔgɔw ye ko ne ye i kɔrɔcɛ le ye.› » ");
INSERT INTO dyu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelɛki ka baw ni sagaw ni misiw, ani baaraden cɛmanw ni a musomanw di Iburahima ma; k’a muso Saran sekɔ a ma. ");
INSERT INTO dyu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A ko Iburahima ma ko: «Ne ta jamana ye nin ye i kɔrɔ, yɔrɔ min ka i diya, i ye taga sigi yi.» ");
INSERT INTO dyu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A ko Saran fana ma ko: «A flɛ, ne bɛ warigbɛ waga kelen di i kɔrɔcɛ ma, ne ta kɛwale sara ye. O wari bɛna i sutara k’a yira aw ta mɔgɔw bɛɛ ra ko i ma jaraki.» ");
INSERT INTO dyu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Iburahima ka Ala daari Abimelɛki ye; Ala ka Abimelɛki kɛnɛya, ani a muso, ani a ta baaraden musomanw bɛɛ. O sera ka den woro; ");
INSERT INTO dyu_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","sabu Ala tun ka denworobariya bana le bla Abimelɛki ni a ta somɔgɔw bɛɛ ra, Iburahima ta muso Saran minari kosɔn. ");
INSERT INTO dyu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Matigi Ala tun ka kuma min fɔ Saran ye, Matigi Ala hakiri tora o ra. A tun ka denko layiri min ta Saran ye, a nana o dafa a ye. ");
INSERT INTO dyu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ala tun ka wagati min latigɛ k’a fɔ Iburahima ye, o wagati sera minkɛ, Saran ka kɔnɔ ta ka dencɛ woro Iburahima ye; o y’a sɔrɔ Iburahima tun kɔrɔra. ");
INSERT INTO dyu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ayiwa, Saran ka o dencɛ min woro Iburahima ye, Iburahima ka o tɔgɔ la ko Isiyaka. ");
INSERT INTO dyu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isiyaka woronin tere seegi, Iburahima k’a kɛnɛsigi, i n’a fɔ Ala tun k’a yira a ra cogo min na fɔlɔfɔlɔ. ");
INSERT INTO dyu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Iburahima si tun ye san kɛmɛ a dencɛ Isiyaka worowagati ra. ");
INSERT INTO dyu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saran ko: «E! Ala ka ninsɔndiyakoba le kɛ ne ye dɛ! Ni mɔgɔ o mɔgɔ ka nin mɛn, o tigi bɛna ninsɔndiya yɛrɛ le.» ");
INSERT INTO dyu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Saran ko tuun ko: «Jɔn le tun bɛ sɔn k’a fɔ Iburahima ye ko Saran bɛna den woro fɔ ka sin di a ma? A ye nin ye sisan, ne ka dencɛ woro a ye, k’a kɔrɔnin to.» ");
INSERT INTO dyu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ayiwa, den tun bɛ kɔrɔbayara ka na. O nana a dabɔ sin na lon min na, Iburahima ka ɲanagbɛba dɔ kɛ o lon na. ");
INSERT INTO dyu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Lon dɔ, Misirankamuso Hajara tun ka dencɛ min woro Iburahima ye, Saran ka o cɛnin yɛrɛkotɔ ye Isiyaka ma. ");
INSERT INTO dyu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Saran k’a fɔ Iburahima ye ko: «Jɔnmuso ni a dencɛ gbɛn, sabu a dencɛ man kan ka cɛn ta ni ne dencɛ Isiyaka ye.» ");
INSERT INTO dyu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","O kuma digira Iburahima ra kosɛbɛ, sabu Sumayila fana tun ye a den ye. ");
INSERT INTO dyu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","O tuma, Ala k’a fɔ Iburahima ye ko: «Iburahima, i kana a to nin kuma ye digi i ra, i ta baaradenmuso ni a dencɛ kosɔn. Ni Saran ka fɛn o fɛn ɲini i fɛ, i ye o kɛ a ye; sabu i yɛrɛ tɔgɔ bɛna la i ta duruja min na o bɛna bɔ Isiyaka le ra. ");
INSERT INTO dyu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nka ne bɛna i ta baaradenmuso dencɛ kɛ siya dɔ fana bɛmacɛ ye, sabu i ta den lo.» ");
INSERT INTO dyu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Iburahima wurira sɔgɔmada joona fɛ; a ka domuni di Hajara ma, ka ji kɛ bara dɔ kɔnɔ, ka o dulon a kamankun na. A k’a dencɛ di a ma, ko o ye taga. A bɔra ka taga; nka a tagara tunu Bɛri Seba kongokolon yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ji nana ban bara kɔnɔ minkɛ, Hajara k’a dencɛ to yiritunin dɔ kɔrɔ, ");
INSERT INTO dyu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ka taga sigi yɔrɔ wɛrɛ, ka mɛtɛrɛ kɛmɛ ɲɔgɔn to a ni den cɛ, ko ale t’a fɛ k’a den satɔ ye. A tagara sigi o yɔrɔ ra ka to ka kasi. ");
INSERT INTO dyu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ala ka den kulekan mɛn. Ala ta mɛlɛkɛ tora san fɛ ka Hajara wele k’a fɔ a ye ko: «Hajara, mun le kɛra? I kana siran, sabu Ala ka den kasikan mɛn, k’a to yiri kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Wuri ka den ta, i ye a boro mina. A ta duruja bɛna kɛ siyaba le ye.» ");
INSERT INTO dyu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ala ka Hajara ɲa yɛlɛ, a ka kɔlɔn dɔ ye. A tagara bara fa ji ra ka na a di den ma, a k’a min. ");
INSERT INTO dyu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ala tora den fɛ. A nana kɔrɔya, ka sigi kongokolon kɔnɔ yi. A nana kɛ kalanbonbagaba le ye. ");
INSERT INTO dyu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","A sigira kongokolon kɔnɔ yɔrɔ dɔ ra, o yɔrɔ tɔgɔ ye ko Paran. A bamuso ka Misirankamuso dɔ furu ka o di a ma. ");
INSERT INTO dyu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","O kɔ, lon dɔ Abimelɛki nana ni a ta kɛrɛkɛdenw kuntigi ye, min tɔgɔ ye ko Pikɔli, ka na kuma Iburahima fɛ. A ko Iburahima ma ko: «Ala kɔni bɛ ni i ye i ta kow bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ne b’a fɛ i ye kari Ala ra yan bi, ko ne o, ne ta denw o, ne ta mamadenw o, ko i tɛna an si janfa; ani ko ne ka koɲuman min kɛ i ye, ko i fana bɛna o ɲumanya ɲɔgɔn le kɛ ne ye, ani i siginin bɛ ne ta jamana min na lonanya ra, ko i bɛna o ɲumanya ɲɔgɔn kɛ o jamana mɔgɔw bɛɛ ye fana.» ");
INSERT INTO dyu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Iburahima ko: «Ne bɛ kari o ra.» ");
INSERT INTO dyu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Nka Iburahima ka Abimelɛki jaraki kɔlɔn dɔ ko ra, sabu Abimelɛki ta baaraden dɔw tun ka o kɔlɔn mina fanga ra k’a kɛ o ta ye. ");
INSERT INTO dyu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelɛki ka Iburahima jaabi ko: «Ne m’a lɔn ne ta baaraden juman le ka o ko kɛ. Ele fana tun m’a fɔ ne ye. Bi le ne bɛ nin mɛnna kura ye.» ");
INSERT INTO dyu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Iburahima ka sagaw ni baw ni misiw di Abimelɛki ma; o ka jɛnɲɔgɔnya don. ");
INSERT INTO dyu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Iburahima ka sagagberen wolonfla bɔ a ta sagaw ra ka o bla danna. ");
INSERT INTO dyu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelɛki ko Iburahima ma ko: «Nin saga wolonfla bɔkun ye mun ye ka o bla danna?» ");
INSERT INTO dyu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iburahima ko: «Nin saga wolonfla mina; o ye kɛ an seere ye k’a yira ko ne le ka kɔlɔn nin sogi.» ");
INSERT INTO dyu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","O le kosɔn o ka o yɔrɔ tɔgɔ la ko Bɛri Seba; sabu Iburahima ni Abimelɛki karira ɲɔgɔn ye o yɔrɔ le ra. ");
INSERT INTO dyu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","O karira ɲɔgɔn ye ten minkɛ Bɛri Seba, Abimelɛki ni a ta kɛrɛkɛdenw kuntigi Pikɔli wurira ka sekɔ Filisikaw ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Iburahima ka tamarisun dɔ turu Bɛri Seba. A ka Matigi Ala tɔgɔ wele o yɔrɔ ra, k’a bato, k’a wele ko Matigi Ala banbari. ");
INSERT INTO dyu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Iburahima tora Filisikaw ta jamana ra lonanya ra ka wagatijan kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ayiwa, o kow kɔ fɛ, Ala ka Iburahima kɔrɔbɔ k’a flɛ. Ala k’a wele ko: «Iburahima!» A ko: «Naamu.» ");
INSERT INTO dyu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ala ko: «I dencɛ kelenpe Isiyaka min ko ka di i ye, o mina ka taga ni a ye Moriya jamana ra; ne bɛna kuru dɔ yira i ra, ni i sera yi, i b’a kɛ saraka jɛnita* ye o kuru kan.» ");
INSERT INTO dyu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Iburahima wurira sɔgɔmada joona fɛ, k’a ta fali labɛn, k’a ta baaraden fla wele ka gban a yɛrɛ kɔ, ani a dencɛ Isiyaka. A bɛna lɔgɔ min kɛ ka saraka jɛni, a ka o ci, ka o ta, ka kɛ taga ye. Ala ka yɔrɔ min fɔ a ye, o ka o yɔrɔ sira ta. ");
INSERT INTO dyu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","O ka tere saba kɛ tagama ra. A tere sabanan, Iburahima k’a ɲa kɔrɔta ka yɔrɔ ye yɔrɔjan yi. ");
INSERT INTO dyu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Iburahima k’a fɔ baaradenw ye ko: «Aw ye to yan ni fali ye. Ne ni den bɛna taga fɔ yan fɛ yi, ka taga Ala bato. Ni an tilara, an bɛ kɔsegi ka na.» ");
INSERT INTO dyu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Iburahima ka saraka jɛnilɔgɔ ta, k’a ɲu a dencɛ Isiyaka kun na, ka takami don fɛn dɔ kɔnɔ, ka o ni muru mina a yɛrɛ boro; ka o fla tagatɔ to ɲɔgɔn fɛ, ");
INSERT INTO dyu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isiyaka k’a fɔ a facɛ ye ko: «Baba!» Iburahima ko: «Naamu, ne dencɛ.» Isiyaka ko: «Tasuma bɛ an fɛ, lɔgɔ fana bɛ an boro; saga min bɛna kɛ saraka ye, o bɛ min?» ");
INSERT INTO dyu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Iburahima ko: «Saga min bɛna kɛ saraka ye, Ala yɛrɛ le bɛna o ko ɲanabɔ.» O fla ka kɛ taga ye ɲɔgɔn fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ala tun ka yɔrɔ min yira o ra, o tagara se yi minkɛ, Iburahima ka sarakabɔnan dɔ lɔ, ka lɔgɔ lala a kan. A bannin kɔ o ra, a k’a dencɛ Isiyaka mina k’a siri, k’a la sarakabɔnan kan, lɔgɔ san fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","A k’a boro bɔ ka muru ta ko a bɛ a dencɛ kannatigɛ. A ko a bɛ muru la den kan na dɔrɔn, ");
INSERT INTO dyu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Matigi Ala ta mɛlɛkɛ tora san fɛ ka pɛrɛn ko: «Iburahima! Iburahima!» Iburahima ko: «Naamu.» ");
INSERT INTO dyu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mɛlɛkɛ ko: «I kana i boro se den ma dɛ! I kana foyi kɛ a ra. Sisan ne k’a lɔn jate ko i bɛ siran Ala ɲa. O kosɔn i ma ban ka i dencɛ kelenpe kɛ saraka ye k’a di ne ma.» ");
INSERT INTO dyu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Iburahima k’a ɲa munu minkɛ, a barara ka sagajigi dɔ ye, a minanin bɛ a gban ma ka lɔ yiritunin dɔ cɛ ma. A tagara sagajigi mina ka na a faga k’a kɛ saraka jɛnita* ye a dencɛ nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Iburahima ka o yɔrɔ tɔgɔ la ko: Yawe Yire. O kosɔn mɔgɔw bɛ to k’a fɔ bi ko: «Ni an sera Matigi Ala ta kuru kunna, Matigi Ala yɛrɛ bɛna a ɲanabɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Matigi Ala ta mɛlɛkɛ tora san fɛ ka Iburahima wele a siɲaga flanan na, ");
INSERT INTO dyu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","k’a fɔ a ye ko: «Matigi Ala ta kuma ye nin ye ko: ‹Ne bɛ kari ni ne yɛrɛ tɔgɔ ye, ko i ka min kɛ nin ye, i ma ban ka i dencɛ kelenpe kɛ saraka ye k’a di ne ma minkɛ, ");
INSERT INTO dyu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","o le kosɔn ne bɛna baraka don i ra, ka i ta duruja caya kosɛbɛ i ko lolow, ani i ko kɔgɔjida kɛnkɛn. I ta durujaw bɛna se o juguw ra, fɔ ka o ta duguw mina o ra. ");
INSERT INTO dyu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Dugukolo siyaw bɛɛ bɛna baraka sɔrɔ ne fɛ ele ta duruja baraka le ra, sabu i sɔnna ka ne kan mina.› » ");
INSERT INTO dyu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","O kɔ, Iburahima ni a dencɛ sekɔra ka taga baaradenw kɔrɔ. O ka sira ta ka taga ɲɔgɔn fɛ Bɛri Seba, sabu Iburahima tun siginin bɛ Bɛri Seba le. ");
INSERT INTO dyu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ayiwa, o kow bɛɛ kɔ fɛ, o nana a fɔ Iburahima ye ko Milika fana ka dencɛw sɔrɔ Iburahima balemacɛ Nahɔri fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","A dencɛ fɔlɔ tɔgɔ ye ko Usi, a flanan tɔgɔ ye ko Buzi, a sabanan tɔgɔ ye ko Kemuhɛli. Kemuhɛli le nana Aramu woro. ");
INSERT INTO dyu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Milika dencɛ naaninan kɛra Kesɛdi ye, ka Hazo gban o ra, ka Pilidasi gban o ra, ka Yidilafe gban o ra, ka sɔrɔ ka Betuhɛli gban o ra. ");
INSERT INTO dyu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuhɛli le nana Rebeka woro. Milika ka o dencɛ seegi le woro Iburahima balemacɛ Nahɔri fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahɔri tun ka jɔnmuso min kɛ a muso ye, min tɔgɔ tun ye ko Rehuma, ale fana ka dencɛw woro; o dencɛw le ye Teba ye, ani Gahamu, ani Tahasi, ani Mahaka. ");
INSERT INTO dyu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saran si bɛɛ lajɛnnin kɛra san kɛmɛ ni san mugan ni wolonfla. ");
INSERT INTO dyu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Saran sara Kiriyati Araba. O yɔrɔ le bɛ wele fana ko Heburɔn. A bɛ Kanaana jamana ra. Iburahima nana sigi Saran su kɔrɔ, k’a su kasi. ");
INSERT INTO dyu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Iburahima nana bɔ a muso Saran su kɔrɔ, ka taga kuma ni Hɛti ta mɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","A ko: «Ne ye lonan tɛmɛbaga le ye aw fɛ yan. Aw ye yɔrɔ dɔ fiyeere ne ma, ne bɛ o kɛ kaburu ye ka ne ta muso sutara, k’a su bɔ ne ɲa kɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hɛti ta mɔgɔw ka Iburahima jaabi ko: ");
INSERT INTO dyu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«An matigicɛ, a flɛ, ele ye Ala ta fagamaden le ye anw cɛ ra yan. An ta kaburulo min o min ka i diya, i ye i ta su don o yɔrɔ ra; an si tɛna ban ka an ta sudonyɔrɔ to i ye, i ye i ta muso su don.» ");
INSERT INTO dyu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Iburahima k’a kinbiri gban ka Hɛti ta mɔgɔw fo. ");
INSERT INTO dyu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","A k’a fɔ o ye ko: «Ayiwa, i n’a fɔ aw sɔnna ko ne ye ne ta muso sutara, o tuma aw ye sabari ka Sohari dencɛ Efurɔn daari ne ye, ");
INSERT INTO dyu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ko kuruwo min b’a fɛ Makipela, a ta foro dan na, ko a ye o di ne ma; ne bɛna a wari kɔsegi a ma. O yɔrɔ ye kɛ ne ta sudonyɔrɔ ye aw fɛ yan.» ");
INSERT INTO dyu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","O y’a sɔrɔ Efurɔn yɛrɛ tun siginin bɛ Hɛti ta mɔgɔw cɛ ra. Ale fana tun ye Hɛti ta mɔgɔ dɔ le ye. A ka Iburahima jaabi Hɛti ta mɔgɔ tɔw bɛɛ ɲa na, ani mɔgɔ minw bɛɛ tun nana o ta dugu kɔnɔ o lon na. ");
INSERT INTO dyu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","A ko Iburahima ma ko: «Ɔn-ɔn, ne matigicɛ, a flɛ, ne bɛ foro di i ma le, ka kuruwo fana di i ma ka fara a kan. Ne bɛ o bɛɛ di i ma ka ne ta dugumɔgɔw bɛɛ kɛ a seere ye. Taga i ta muso su don.» ");
INSERT INTO dyu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Iburahima k’a kinbiri gban dugumɔgɔw bɛɛ ɲa na, ka o fo. ");
INSERT INTO dyu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","A k’a fɔ Efurɔn ye dugumɔgɔw bɛɛ ɲa na ko: «Sabari k’a to ne ye foro sɔngɔ di; sabari k’a mina, ne bɛ sɔrɔ ka taga ne ta muso su don yi.» ");
INSERT INTO dyu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efurɔn k’a fɔ Iburahima ye ko: ");
INSERT INTO dyu_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Ne matigicɛ, foro min sɔngɔ ye warigbɛ kɛmɛ naani, o bɛ mun le cɛn ne ni ele cɛ sa? Taga i ta muso su don.» ");
INSERT INTO dyu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Efurɔn ka warida min fɔ, o bɛnna Iburahima ma. Iburahima ka o wari jate Hɛti ta mɔgɔw bɛɛ ɲa na k’a di Efurɔn ma: warigbɛ kɛmɛ naani, ka kaɲa ni jagokɛbagaw ta jate ye. ");
INSERT INTO dyu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","A kɛra ten minkɛ, Efurɔn ta foro min tun bɛ Makipela, Mamire ta yɔrɔ terebɔyanfan na, foro ni kuruwo min bɛ o yɔrɔ ra, ani yiri o yiri bɛ foro kɔnɔ ka taga a bla fɔ foro dan na, ");
INSERT INTO dyu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","o bɛɛ kɛra Iburahima ta ye. Hɛti ta mɔgɔw bɛɛ kɛra a ko seere ye, ani mɔgɔ o mɔgɔ tun bɛ o ta dugu kɔnɔ o lon na. ");
INSERT INTO dyu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","O kɔ, Iburahima k’a muso Saran su don Makipela ta foro kuruwo ra; o yɔrɔ bɛ Mamire ta yɔrɔ terebɔyanfan na. O yɔrɔ le ye Heburɔn ye fana; a bɛ Kanaana jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Foro ni kuruwo min tun bɛ yi, o bɛɛ kɛra Iburahima ta ye, ka kɛ a ta sudonyɔrɔ ye. A ka o san Hɛti ta mɔgɔw fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ayiwa, Iburahima tun kɔrɔra kosɛbɛ. Matigi Ala tun ka baraka don a ra fɛn bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","A ta baaradenw bɛɛ ra kɔrɔba, min mɛɛnna a ta so kɔnɔ ka tɛmɛ tɔw bɛɛ kan, a tun ka min sigi a ta borofɛnw bɛɛ kunna, a ko ale ma ko: «Sabari ka na i boro la ne woto jukɔrɔ, ");
INSERT INTO dyu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ka kari Matigi Ala tɔgɔ ra, sankolo ni dugukolo tigi, ko an siginin bɛ Kanaanaka minw fɛ yan, ko i tɛna muso ta ne dencɛ ye olugu ta denw na, ");
INSERT INTO dyu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","nka i bɛna taga ne ta jamana le ra, ne faso ra, ka taga muso ta ne dencɛ Isiyaka ye o yɔrɔ ra.» ");
INSERT INTO dyu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Iburahima ta baaraden ko: «Ni a nana kɛ ko muso t’a fɛ ka na ni ne ye fɔ yan do? O tuma ne ka kan ka taga ni i dencɛ ye i ta jamana ra wa?» ");
INSERT INTO dyu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Iburahima ko: «Ɔn-ɔn dɛ! I kana taga ni ne dencɛ ye fiyewu. ");
INSERT INTO dyu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Matigi Ala sankolo tigi le ka ne labɔ ne faso ra, ani ne ta jamana ra. A kumana ne fɛ, ka kari ne ye ko a bɛna nin jamana di ne ta duruja ma. Ale Ala yɛrɛ le bɛna a ta mɛlɛkɛ bla i ɲa ka taga ne faso ra; i bɛna taga muso ta o yɔrɔ le ra ne dencɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ni a kɛra ko muso le t’a fɛ ka na ni i ye, o tuma o kariri kunko bɔra i kunna. Nka i kɔni kana taga ni ne dencɛ ye yi.» ");
INSERT INTO dyu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Baaraden k’a boro la a matigicɛ Iburahima woto kɔrɔ, ka kari, ko Iburahima ka min fɔ, ko ale bɛna o le kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","A ka ɲɔgɔmɛ tan ta a matigicɛ ta ɲɔgɔmɛw ra ka taga, ani a tagamaɲɔgɔnw; fɛn o fɛn ye fɛn dawulaman ye, a ka o bɛɛ dɔ ta. A tagara Mesopotami jamana ra, Nahɔri ta dugu ra. ");
INSERT INTO dyu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","A tagara se yi minkɛ, a ka ɲɔgɔmɛw lala kɔlɔn dɔ kɔrɔ dugu kɔ fɛ. O wagati tun bɛnna wulada le ma, wagati min musow bɛ bɔ ka na ji bi kɔlɔn na. ");
INSERT INTO dyu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","A ka Ala daari ko: «Matigi Ala, ne matigicɛ Iburahima ta Ala, ne bɛ muso min kɔ, sabari k’a to ne ye bɛn ni o ye bi; sabari ka o koɲuman kɛ ne matigicɛ Iburahima ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ayiwa, ne lɔnin flɛ kɔlɔn kɔrɔ yan; ni dɔɔnin kɛra dugu sunguruw bɛna bɔ ka na ji bi. ");
INSERT INTO dyu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ni ne ka na a fɔ sunguru min ma ko: ‹Sabari ka i ta daga jɛngɛ k’a to ne ye min,› ni a ka sɔn, ka ne jaabi ko: ‹Min; ni i minna, ne bɛna i ta ɲɔgɔmɛw fana sɔn o ye min.› Ayiwa, ni sunguru min ka o fɔ, o le ye kɛ i ta jɔncɛ Isiyaka ta muso ye, i yɛrɛ ka min latigɛ a ye. O ra ne bɛna a lɔn can ra ko i ka koɲuman kɛ ne matigicɛ Iburahima ye.» ");
INSERT INTO dyu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Sani cɛ ye ban a ta kuma ra dɔrɔn, Rebeka ye nin ye ni a ta daga ye a kamankun kan, a bɛ nana ji bi. Rebeka tun ye Betuhɛli denmuso le ye. Betuhɛli bamuso tun ye Milika ye, a facɛ tun ye Nahɔri ye; Nahɔri tun ye Iburahima dɔgɔcɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Sunguru cɛɲuman tun lo. A tun ma cɛko lɔn fɔlɔ. A tagara kɔlɔn da ra, ka taga a ta daga fa, ka sira mina. ");
INSERT INTO dyu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Iburahima ta baaraden borira ka taga a kunbɛn. A ko a ma ko: «Sabari ka daga jigi k’a to ne ye min.» ");
INSERT INTO dyu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Sunguru ko: «Dɔ min, baba!» A teliyara ka daga jigi, ka a mina a boro, ka ji di cɛ ma, a k’a min. ");
INSERT INTO dyu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Cɛ minna ka ban minkɛ, sunguru ko: «Ne bɛna ji dɔ bi k’a di i ta ɲɔgɔmɛw fana ma, fɔ o bɛɛ ye min ka fa.» ");
INSERT INTO dyu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","A teliyara ka daga ji yɛlɛma bɛganw ta jiminfaga kɔnɔ, ka bori ka taga dɔ wɛrɛ bi. A ka ji caman bi ɲɔgɔmɛw bɛɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Cɛ kɔni kabakoyanin lɔnin tora, a bɛ flɛri kɛra; a ma sɔn ka kuma fɔlɔ. A tun b’a flɛra ni Matigi Ala bɛna ale ta sira diya, walama ni a tɛna a diya. ");
INSERT INTO dyu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ɲɔgɔmɛw bɛɛ nana min ka ban tuma min na, cɛ ka nunnanɛgɛ saninlaman dɔ bɔ, min tun bɛ garamu wɔɔrɔ bɔ, ani bororanɛgɛ saninlaman fla, minw tun ka ca ni garamu kɛmɛ ye. A ka o di Rebeka ma. ");
INSERT INTO dyu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A ka sunguru ɲininka ko: «Hakɛ to, jɔn ta den le bɛ ele ye? Yala an siyɔrɔ bɛ sɔrɔ i facɛ ta so wa?» ");
INSERT INTO dyu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka ko: «Nahɔri ni Milika dencɛ Betuhɛli, o denmuso le ye ne ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Bin ni flaburu bɛ sɔrɔ an fɛ yi caman i ta ɲɔgɔmɛw ye. Aw siyɔrɔ fana bɛ sɔrɔ yi.» ");
INSERT INTO dyu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Cɛ ka o mɛn minkɛ, a k’a kinbiri gban ka Matigi Ala fo. ");
INSERT INTO dyu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","A ko: «Matigi Ala baraka, ne matigicɛ Iburahima ta Ala, sabu a tora a ta koɲuman ni a ta kankelentigiya kan ne matigicɛ Iburahima ye, a ka o dafa. Matigi Ala yɛrɛ le ka ne ɲamina ka na ni ne ye ne matigicɛ Iburahima yɛrɛ ta balemaw fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Sungurunin borira ka taga a bamuso fɛ, ka taga o ko lakari a ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka kɔrɔcɛ dɔ tun bɛ yi, a tɔgɔ ye ko Laban. Ale ka o kuma mɛn minkɛ, a borira ka bɔ, ka taga cɛ nɔ fɛ kɛnɛ ma kɔlɔnda ra. ");
INSERT INTO dyu_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Laban tun ka nunnanɛgɛ ni bororanɛgɛ ye a dɔgɔmuso boro. Rebeka tun ka cɛ ta kumaw lakari cogo min na, Laban tun ka o bɛɛ mɛn fana. O kosɔn a wurira ka taga cɛ nɔ fɛ. O y’a sɔrɔ cɛ tun siginin bɛ a ta ɲɔgɔmɛw kɔrɔ kɔlɔnda ra. ");
INSERT INTO dyu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban sera a kɔrɔ minkɛ, a ko: «Wuri ka don so kɔnɔ; Matigi Ala ka baraka don i ra. Mun kosɔn i bɛ to kɛnɛ ma yan? Ne ka yɔrɔ dɔ labɛn i ye, ka yɔrɔ dɔ fana labɛn i ta ɲɔgɔmɛw ye.» ");
INSERT INTO dyu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Cɛ wurira ka taga so kɔnɔ ni Laban ye. O sera so kɔnɔ minkɛ, Laban ka ɲɔgɔmɛw ta doniw jigi, ka bin ni flaburu di o ma, ka ji di cɛ ni a nɔfɛmɔgɔw ma, o ka o senw ko. ");
INSERT INTO dyu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","O kɔ, o ka domuni sigi o kɔrɔ. Nka cɛ ko: «Kuma min bɛ ne fɛ, ni ne ma o fɔ, ne tɛ se ka domuni kɛ.» Laban ko: «Ayiwa, min bɛ i fɛ, o fɔ sa.» ");
INSERT INTO dyu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Cɛ ko: «Ne ye Iburahima ta baaraden le ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Matigi Ala ka baraka don ne matigicɛ ra kosɛbɛ, k’a kɛ fɛntigi ye, k’a borofɛnw caya, ka sagaw ni baw ni misiw di a ma, ani warigbɛ ni sanin, ani baaraden cɛmanw ni musomanw, ani ɲɔgɔmɛw ni faliw. ");
INSERT INTO dyu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ne matigicɛ ta muso Saran fana, ale ni a ta kɔrɔya bɛɛ, a ka dencɛ woro ne matigicɛ ye. Ne matigicɛ k’a borofɛn bɛɛ di o dencɛ le ma. ");
INSERT INTO dyu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ayiwa, lon dɔ, a nana a fɔ ko ne ye kari ale ye, ko ne tɛna muso ta ale dencɛ ye Kanaanakaw ta denmusow ra, ale siginin bɛ minw cɛ ra yi; ");
INSERT INTO dyu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ko nka ne ye taga ale faso le ra, ale ta mɔgɔw fɛ, ka taga muso ɲini ale dencɛ ye o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ne k’a fɔ a ye ko: ‹Ni muso t’a fɛ ka na ni ne ye do?› ");
INSERT INTO dyu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A ko: ‹Ne bɛ tagama ka kaɲa ni Matigi Ala min ta kuma ye, ale yɛrɛ le bɛna a ta mɛlɛkɛ ci ka taga ni i ye, k’a to i ta sira ye diya, janko i ye muso dɔ ta ne dencɛ ye ne faso ra, ne ta somɔgɔw ra.› ");
INSERT INTO dyu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","A ko: ‹Ni i tagara muso daari ne ta somɔgɔw fɛ, ni olugu le ma sɔn k’a di i ma, o tuma i ta kariri kunko bɔra i kunna.› ");
INSERT INTO dyu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«Ayiwa, ne nana o le ra ka na se kɔlɔnda ra bi. Ne ko: ‹Matigi Ala, ne matigicɛ Iburahima ta Ala, ni i b’a fɛ ka ne ta sira diya, ");
INSERT INTO dyu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","o tuma ne bɛ lɔ kɔlɔnda ra yan; sunguru min bɛna bɔ ka na ji bi, ni ne k’a fɔ a ye ko: Sabari k’a to ne ye i ta daga ji dɔɔnin min. Ni a ka ne jaabi ko: ");
INSERT INTO dyu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Dɔ min; o kɔ, ne bɛna dɔ bi k’a di i ta ɲɔgɔmɛw fana ma. Ayiwa, ni sunguru min ka o fɔ, o ye kɛ ne matigicɛ dencɛ ta muso ye, Matigi Ala yɛrɛ ka min latigɛ a ye.› ");
INSERT INTO dyu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ayiwa, sani ne ye ban o kuma ra ne yɛrɛ kɔnɔ dɔrɔn, Rebeka ye nin ye ni a ta daga ye a kamankun kan, a bɛ nana. A nana ji bi kɔlɔn na. Ne ko a ma ko: ‹Sabari ka ji di ne ma ne ye min.› ");
INSERT INTO dyu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A teliyara k’a ta daga jigi ko ne ye min, ko ale bɛna ji bi k’a di ɲɔgɔmɛw fana ma o ye min. Ayiwa, ne minna. O kɔ, a ka ji bi k’a di ne ta ɲɔgɔmɛw fana ma, o minna. ");
INSERT INTO dyu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ne k’a ɲininka ko: ‹Jɔn den le bɛ ele ye?› A ko: ‹Nahɔri ni Milika dencɛ Betuhɛli, o denmuso le bɛ ne ye.› Ne ka nunnanɛgɛ dɔ don a nun na, ka bororanɛgɛ don a boro ra. ");
INSERT INTO dyu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","O kɔ, ne ka ne kinbiri gban dugu ma, Matigi Ala ɲa kɔrɔ, ne matigicɛ Iburahima ta Ala, k’a fo; sabu ale le blara ne ɲa ka teren ni ne ye fɔ yan, k’a to ne ye ne Matigicɛ yɛrɛ dɔgɔcɛ ta denmuso le sɔrɔ, ne matigicɛ dencɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ni aw b’a fɛ ka o koɲuman kɛ ne matigicɛ ye, k’a ta kankelentigiya yira, o tuma aw ye a fɔ ne ye; ni aw fana tɛ se k’a kɛ, aw ye a fɔ, janko ne ye ne tagayɔrɔ lɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ayiwa, Laban ni Betuhɛli ka Iburahima ta jɔncɛ jaabi ko: «Nin ko bɔra Matigi Ala yɛrɛ le ra. An tɛ se k’a sɔsɔ. ");
INSERT INTO dyu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ye nin ye, a ta ka taga ni a ye; a ye kɛ i matigicɛ dencɛ ta muso ye, i n’a fɔ Matigi Ala yɛrɛ k’a latigɛ cogo min na.» ");
INSERT INTO dyu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Iburahima ta jɔncɛ ka o kuma mɛn minkɛ, a k’a kinbiri gban ka Matigi Ala bato. ");
INSERT INTO dyu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","A ka masirifɛnw bɔ k’a di Rebeka ma; dɔw warigbɛraman, dɔw saninlaman, ani faniw. A ka fɛn dawulamanw di a kɔrɔcɛ ni a bamuso fana ma. ");
INSERT INTO dyu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","O kɔ, a ni a tagamaɲɔgɔnw ka domuni kɛ, ka min. O sira. O wurira minkɛ sɔgɔmada fɛ, a ko: «Aw ye sira di ne ma, ne bɛ sekɔ ne matigicɛ fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Rebeka kɔrɔcɛ ni a bamuso ko: «A to sunguru ye wagati fitini kɛ ni an ye, tere tan ɲɔgɔn; o kɔ, aw bɛ taga.» ");
INSERT INTO dyu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Cɛ ko: «Matigi Ala ka ne ta sira diya ka ban; aw kana ne lalɔ tuun. Aw y’a to ne ye taga ne matigicɛ fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Rebeka ta mɔgɔw ko: «Ayiwa, an ye sunguru wele k’a ɲininka.» ");
INSERT INTO dyu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","O ka Rebeka wele k’a ɲininka ko: «I b’a fɛ ka taga ni cɛ ye sisan wa?» A ko: «Ɔnhɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","O cogo ra, o ka o balemamuso Rebeka ni a lamɔbamuso bla ka taga ni Iburahima ta baaraden ni a tagamaɲɔgɔnw ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Sani o ye taga, o ka dugawu kɛ Rebeka ye; o ko: «An balemamuso, Ala ye den caman di i ma, ka o kɛ mɔgɔ waga caman caman ye. Ala y’a to o ye se o juguw ra, ka o ta duguw mina o ra.» ");
INSERT INTO dyu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka ni a ta baaradenmusow wurira ka taga yɛlɛn ɲɔgɔmɛw kan, ka gban cɛ kɔ. A tagara ni Rebeka ye o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","O y’a sɔrɔ Isiyaka tun bɔra Lasayi Royi ta kɔlɔn yɔrɔ ra. A tun siginin bɛ jamana woroduguyanfan le fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lon dɔ, wulada fɛ, Isiyaka bɔra ka taga yaalayaala kongo kɔnɔ, ani ka miiri. A nana a ɲa kɔrɔta ka flɛri kɛ, a ka ɲɔgɔmɛ dɔw ye, o bɛ nana. ");
INSERT INTO dyu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka natɔ k’a ɲa kɔrɔta ka Isiyaka ye. A jigira ka bɔ ɲɔgɔmɛ kan. ");
INSERT INTO dyu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","A ka Iburahima ta baaraden ɲininka ko: «Cɛ juman le bɛ nana an kunbɛn tan?» Baaraden ko: «Ne matigicɛ Isiyaka lo.» Rebeka ka o mɛn minkɛ, a k’a ta lankana biri. ");
INSERT INTO dyu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ayiwa, baaraden tun ka ko o ko kɛ, a ka o bɛɛ ɲafɔ Isiyaka ye. ");
INSERT INTO dyu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isiyaka tagara Rebeka bla a bamuso Saran ta fanibon kɔnɔ. Rebeka kɛra a muso ye; a ko diyara Isiyaka ye. O le kɛra sababu ye ka Isiyaka jusu suma a bamuso sanin kɔ. ");
INSERT INTO dyu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ayiwa, Iburahima ka muso wɛrɛ ta; ale tɔgɔ tun ye ko Ketura. ");
INSERT INTO dyu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura ka dencɛ minw woro Iburahima ye, o kɛra Zimiran ye, ani Yokisan, ani Medan, ani Madiyan, ani Isibaki, ani Suwa. ");
INSERT INTO dyu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokisan ka Seba ni Dedan woro. Dedan le ye Asurikaw ye, ani Letusikaw, ani Lemikaw bɛmacɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiyan dencɛw tun ye Efa ye, ani Efɛri, ani Hanɔki, ani Abida, ani Elida. Olugu bɛɛ le ye Ketura denw ni a mamadenw ye. ");
INSERT INTO dyu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Nka Iburahima k’a borofɛnw bɛɛ di Isiyaka le ma. ");
INSERT INTO dyu_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","A tun ka jɔnmuso minw kɛ a musow ye, a ka olugu dencɛw fana sɔn fɛn dɔw ra. Nka sani a ye sa, a ka olugu bla ka taga fɔ yɔrɔjan, terebɔyanfan jamanaw ra, ka o mabɔ a dencɛ Isiyaka ra. ");
INSERT INTO dyu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Iburahima si bɛɛ lajɛnnin kɛra san kɛmɛ ni san biwolonfla ni san looru; a ka o le sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Iburahima kɔrɔra fɔ ka kɔrɔya diyabɔ. O kɔ, a sara, ka taga fara a bɛma tɔw kan. ");
INSERT INTO dyu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A dencɛ fla, Isiyaka ni Sumayila, olugu k’a su don Makipela kuruwo ra. O yɔrɔ bɛ Hɛtikacɛ Sohari dencɛ Efurɔn ta foro ra. A bɛ Mamire terebɔyanfan na. ");
INSERT INTO dyu_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Iburahima tun ka o yɔrɔ le san Hɛti ta denw fɛ. Iburahima ni a muso Saran su donna yi le. ");
INSERT INTO dyu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Iburahima sanin kɔ, Ala ka baraka don a dencɛ Isiyaka ra. Isiyaka tun siginin bɛ Lasayi Royi ta kɔlɔn yɔrɔ le ra. ");
INSERT INTO dyu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iburahima ta muso Saran ta baaradenmuso min tɔgɔ tun ye ko Hajara, o Misirankamuso tun ka dencɛ min woro Iburahima ye ni a tɔgɔ tun ye ko Sumayila, ale ta duruja flɛ nin ye. ");
INSERT INTO dyu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","A dencɛw tɔgɔw ye nin ye, ka kaɲa ni o ta woro wagatiw ye: a dencɛ fɔlɔ ye Nebayɔti ye; o kɔ fɛ, Kedari, ani Adibɛli, ani Mibisamu, ");
INSERT INTO dyu_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ani Misima, ani Duma, ani Masa, ");
INSERT INTO dyu_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ani Hadadi, ani Tema, ani Yeturi, ani Nafisi, ani Kedima. ");
INSERT INTO dyu_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Olugu le ye Sumayila dencɛw ye. O tɔgɔw le ye o ye, ka kaɲa ni o ta duguw, ni o ta wɛrɛw ye. O kɛra kuntigi tan ni fla ye o ta siyaw ra. ");
INSERT INTO dyu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sumayila si bɛɛ lajɛnnin kɛra san kɛmɛ ni san bisaba ni san wolonfla; a ka o le kɛ. O kɔ, a sara fana ka taga fara a bɛmacɛ tɔw kan. ");
INSERT INTO dyu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","A denw tun siginin bɛ mara min na, o bɛ damina Havila mara ra ka taga a bla fɔ Suri kongokolon na. A yɔrɔ bɛ Misiran jamana terebɔyanfan na, Asiri jamana sira ra. O sigira o yɔrɔ ra o danna, ka o yɛrɛ mabɔ o balemaw bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ayiwa, Iburahima dencɛ Isiyaka ta duruja ye nin ye. ");
INSERT INTO dyu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Iburahima ka Isiyaka woro. Ka Isiyaka si to san binaani, a ka Rebeka furu. Rebeka facɛ tun ye Betuhɛli ye. Betuhɛli tun ye Arameka le ye, a bɛ bɔ Mesopotami jamana ra. Rebeka kɔrɔcɛ le tun ye Laban ye; ale fana tun ye Arameka ye. ");
INSERT INTO dyu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isiyaka ka Matigi Ala daari kosɛbɛ a muso Rebeka ye, sabu a tun ma den sɔrɔ. Matigi Ala ka a ta daariri lamɛn; a muso ka kɔnɔ ta. ");
INSERT INTO dyu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rebeka ka kɔnɔ ta flaninw le ra. K’a sɔrɔ o ma woro ban, denw tun bɛ ɲɔgɔn ɲɔniɲɔnina o bamuso kɔnɔ. Rebeka ko: «Ni o lo, ne ta kɔnɔtari kun kɛra mun le ye sa?» A ka Matigi Ala ɲininka o ko ra. ");
INSERT INTO dyu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Matigi Ala ko: «Siya fla le bɛ i kɔnɔ; ni i ka na o siya fla woro, o tɛna bɛn kelen ma; o bɛna faran. O fla ra kelen fanga bɛna bonya ka tɛmɛ tɔ kelen ta kan; kɔrɔcɛman le bɛna kɛ dɔgɔcɛman ta jɔn ye.» ");
INSERT INTO dyu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ayiwa, Rebeka jigilon nana se. Sigiya ma kɛ a ra tuun, a jigira flaninw le ra. ");
INSERT INTO dyu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Den fɔlɔ nana; ale kɛra wulenman, k’a yɔrɔ bɛɛ kɛ si ye i ko sagasi derege. O ka ale tɔgɔ la ko Esawu. ");
INSERT INTO dyu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","O kɔ, a dɔgɔcɛ nana; ale natɔ k’a kɔrɔcɛ sen mina a boro. O ka ale tɔgɔ la ko Yakuba. O worora ka Isiyaka si to san biwɔɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Denw nana ɲanatigɛ. Esawu nana kɛ donsocɛfari ye, ka kɛ kongoyaalabaga ye. Yakuba, ale kɛra mɔgɔ sumanin ye, ka kɛ sokɔnɔsigibaga ye. ");
INSERT INTO dyu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esawu ko le tun ka di Isiyaka ye, sabu ale baraka ra, Isiyaka tun bɛ sogo sɔrɔ k’a domu. Yakuba ko le tun ka di Rebeka ye. ");
INSERT INTO dyu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lon dɔ, Yakuba tun bɛ sɔsɔ tobira. Esawu sɛgɛninba nana ka bɔ kongo ra. ");
INSERT INTO dyu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","A ko Yakuba ma ko: «Ne sɛgɛra, kɔngɔ bɛ ɲini ka ne faga; sabari k’a to ne ye i ta sɔsɔwulen nin dɔ domu.» Ayiwa, o le kosɔn Esawu tɔgɔ nana la ko Edɔmu. ");
INSERT INTO dyu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakuba ko: «Ni i ka i ta kɔrɔya falen sɔsɔ ra ne fɛ bi, ne bɛ sɔrɔ ka sɔsɔ dɔ di i ma.» ");
INSERT INTO dyu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawu ko: «Kɔngɔ bɛ ɲini ka ne faga; kɔrɔya bɛ mun le ɲa ne ye?» ");
INSERT INTO dyu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakuba ko: «Kari a ra fɔlɔ ne ye.» Esawu karira; a k’a ta kɔrɔya falen Yakuba fɛ sɔsɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","O kɔ, Yakuba sɔrɔra k’a ta sɔsɔ dɔ di Esawu ma, ani buru. Esawu ka o domu, ka ji min, ka wuri ka tɛmɛ. A kɛra ten le, Esawu ma a ta kɔrɔya jate. ");
INSERT INTO dyu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ayiwa, o bɛɛ kɔ, kɔngɔ dɔ benna jamana kan. O ni Iburahima ta wagati ta kɔngɔ tun tɛ kelen ye. Isiyaka wurira ka taga Filisikaw ta masacɛ Abimelɛki fɛ, Gerari dugu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Matigi Ala k’a yɛrɛ yira Isiyaka ra, k’a fɔ a ye ko: «I kana taga Misiran dɛ! Ne bɛ jamana min yira i ra, i ye sigi yi le. ");
INSERT INTO dyu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Sigi nin jamana ra yan. Ne bɛna kɛ ni i ye, ka baraka don i ra, sabu ne bɛna nin yɔrɔ bɛɛ di i ni i ta duruja ma. O cogo ra ne ka layiri min ta i facɛ Iburahima ye, ne bɛna o dafa. ");
INSERT INTO dyu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ne bɛna i ta duruja caya, k’a kɛ i ko lolow ka ca cogo min na. Ne bɛna nin mara bɛɛ di i ta duruja ma. Dugukolo siyaw bɛɛ bɛna baraka sɔrɔ ne fɛ ele ta duruja sababu le ra, ");
INSERT INTO dyu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","sabu Iburahima ka ne kan mina; a ka ne ta kokɛtaw, ani ne ta kumaw, ani ne ta cifɔninw, ani ne ta sariyaw bɛɛ sira tagama.» ");
INSERT INTO dyu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ayiwa, Isiyaka tora Gerari. ");
INSERT INTO dyu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ni o tun ka Isiyaka ɲininka a muso ko ra, a tun bɛ to k’a fɔ mɔgɔw ye ko Rebeka ye ale dɔgɔmuso le ye. A tun bɛ siran ko ni ale k’a fɔ ko a muso lo, ko mɔgɔw bɛna ale faga Rebeka kosɔn, sabu a tun cɛ ka ɲi kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","O nana mɛɛn Gerari minkɛ, lon dɔ Filisikaw ta masacɛ Abimelɛki ka flɛri kɛ finɛtiri fɛ, ka Isiyaka ni a muso Rebeka ye, o bɛ toron kɛra ɲɔgɔn fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelɛki ka Isiyaka wele k’a fɔ a ye ko: «Ele ni muso nin toronkɛcogo b’a yira ko i muso lo, sigiya tɛ o ra. Mun na i ko an ma ko i dɔgɔmuso lo?» Isiyaka ko: «Ne ka o fɔ sabu ne tun bɛ siranna ko aw bɛna ne faga a kosɔn le.» ");
INSERT INTO dyu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelɛki ko: «I ka mun ko le kɛ nin ye tan? A tun tora dɔɔnin ne ta mɔgɔ dɔ tun bɛna jɛn ni i ta muso ye; i tun bɛna a to an bɛ Ala hakɛ ta ka an yɛrɛ jaraki gbansan.» ");
INSERT INTO dyu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","O tuma Abimelɛki ka kankari la a ta mɔgɔw bɛɛ ye ko: «Ni mɔgɔ min ka maga Isiyaka ra, walama a muso ra, o tigi bɛ faga.» ");
INSERT INTO dyu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ayiwa, Isiyaka tora Gerari ka sɛnɛ kɛ, ka siman dan. Ala ka baraka don a ta baara ra, a ta siman ɲana; a ka min dan a ka o ɲɔgɔn caman sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isiyaka borofɛnw nana caya, fɔ ka na a kɛ naforotigiba ye. ");
INSERT INTO dyu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Sagakuruw tun b’a fɛ, ani baw, ani misiw, ani baaraden caman. A nana kɛ fɔ a ɲangboya ka Filisikaw mina. ");
INSERT INTO dyu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","A kɛra ten, Isiyaka facɛ Iburahima ta baaradenw tun ka kɔlɔn o kɔlɔn sogi, Filisikaw ka bɔgɔ kɛ o bɛɛ kɔnɔ ka o gberen. ");
INSERT INTO dyu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","O kɔ, Abimelɛki ko Isiyaka ma ko: «Taga ka bɔ an fɛ yan, sabu i fanga bonyara ka tɛmɛ an kan.» ");
INSERT INTO dyu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isiyaka bɔra yi ka taga se Gerari kɛnɛgbɛ ra. A sigira o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ayiwa, Isiyaka facɛ Iburahima ta wagati ra, a tun ka kɔlɔn minw sogi, ni Filisikaw nana o gberen Iburahima sanin kɔ, Isiyaka ka o kɔlɔnw bɔgɔ bɔ tuun. A facɛ Iburahima tun ka tɔgɔ minw don o kɔlɔnw na, Isiyaka ka o tɔgɔ kelenw don o ra tuun. ");
INSERT INTO dyu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Lon dɔ, Isiyaka ta baaradenw ka kɔlɔn dɔ sogi o kɛnɛgbɛ ra yi, ka taga se bununji dɔ ma. ");
INSERT INTO dyu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerari ta sagagbɛnbagaw ka o ye minkɛ, o ka Isiyaka ta sagagbɛnbagaw kɛrɛ. O ko: «Nin ji ye anw ta le ye.» Isiyaka ka o kɔlɔn tɔgɔ la ko Esɛki, ko sabu o kɛrɛra a kosɔn. ");
INSERT INTO dyu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Isiyaka ta baaradenw ka kɔlɔn dɔ wɛrɛ sogi; o nana kɛrɛ kɛ o fɛ o fana kosɔn. Isiyaka ka o tɔgɔ la ko Sitina. ");
INSERT INTO dyu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","O bɔra yi ka taga kɔlɔn dɔ wɛrɛ sogi tuun. Mɔgɔ si ma na kɛrɛ kɛ o fɛ o kosɔn. A ka o tɔgɔ la ko Rehobɔti; ko sisan kɔni Matigi Ala ka an wasa yɛrɛ le. Sisan an borofɛnw bɛna caya jamana kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isiyaka bɔra yi ka taga Bɛri Seba. ");
INSERT INTO dyu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Lon dɔ, su fɛ, Matigi Ala k’a yɛrɛ yira Isiyaka ra k’a fɔ a ye ko: «Ne le ye i facɛ Iburahima ta Ala ye. I kana siran, sabu ne bɛ ni i ye. Ne bɛna baraka don i ra, ka i ta duruja caya, ne ta baaraden Iburahima kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isiyaka ka sarakabɔnan dɔ lɔ, ka Matigi Ala tɔgɔ wele, k’a bato. O kɔ, a k’a ta fanibon lɔ o yɔrɔ ra. A ta baaradenw ka kɔlɔn dɔ sogi o yɔrɔ ra fana. ");
INSERT INTO dyu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Lon dɔ, Abimelɛki ni a tericɛ Ahusati ni a ta kɛrɛkɛdenw kuntigi Pikɔli bɔra Gerari ka na Isiyaka fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isiyaka ko o ma ko: «Mun kosɔn aw nana ne fɛ tuun, k’a sɔrɔ aw ka ne kɔninya, ka ne gbɛn ka bɔ aw ta yɔrɔ ra?» ");
INSERT INTO dyu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","O ko: «An k’a ye ko Matigi Ala bɛ ni i ye le, o kosɔn an nana i fɛ, ko an ye kari ka layiri ta ɲɔgɔn ye, ka jɛnɲɔgɔnya don an ni ɲɔgɔn cɛ. ");
INSERT INTO dyu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Kari Ala ra ko i tɛna kojugu kɛ an na, i n’a fɔ an fana ma kojugu kɛ i ra cogo min na; an ka koɲuman dama le kɛ i ye. An ka i bla ka bɔ an fɛ hɛra ra; ayiwa, sisan Matigi Ala fana ka baraka don i ra.» ");
INSERT INTO dyu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isiyaka ka domuniba tobi o ye; o ka o domu, ka min. ");
INSERT INTO dyu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","O dugusagbɛ sɔgɔmada fɛ o wurira, o ka jɛnɲɔgɔnya don ni Isiyaka ye, ka layiri ta ɲɔgɔn ye. O kɔ, o faranna ɲɔgɔn na; Isiyaka ka sira di o ma, o tagara hɛra ra. ");
INSERT INTO dyu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ayiwa, o lon yɛrɛ, Isiyaka ta baaradenw tun bɛ kɔlɔn min sogira, o nana o kɔlɔn ko fɔ Isiyaka ye. O ko: «An ka kɔlɔn sogi ka se ji ma.» ");
INSERT INTO dyu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isiyaka ka o kɔlɔn tɔgɔ la ko Seba. O kosɔn o dugu tɔgɔ nana la ko Bɛri Seba. O tɔgɔ le tora a ra fɔ ka na se bi ma. ");
INSERT INTO dyu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ayiwa, ka Esawu si to san binaani, a ka Bɛri denmuso furu; Bɛri tun ye Hɛtika le ye; a denmuso tɔgɔ tun ye ko Yuditi. O kɔ, Esawu ka Elɔn denmuso fana furu. Elɔn fana tun ye Hɛtika ye. A denmuso tɔgɔ tun ye ko Basimati. ");
INSERT INTO dyu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","O muso fla ta ko ka Isiyaka ni Rebeka jusu tɔɔrɔ kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isiyaka tun kɔrɔra. A ɲadenw baraka dɔgɔyara fɔ ka na kɛ a tɛ foyi yera tuun. Lon dɔ, a k’a dencɛ fɔlɔ Esawu wele; a ko: «Ne dencɛ!» Esawu ko: «Naamu.» ");
INSERT INTO dyu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isiyaka ko: «A flɛ, ne kɔrɔra, ne ma ne sawagati lɔn fana. ");
INSERT INTO dyu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sabari, i ye i ta donsominanw ta, i ta kalan ni i ta biɲɛw, ka taga kongo ra ka taga sogo ɲini ne ye. ");
INSERT INTO dyu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Sogo tobicogo min ka di ne ye, i bɛna a tobi o cogo ra, ka na a di ne ma, ne ye a domu, janko ne ye dugawu kɛ i ye sani ne ye sa.» ");
INSERT INTO dyu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isiyaka ka min fɔ, jaga Rebeka ka o mɛn. Ayiwa, Esawu nana taga kongo ra ka taga sogo ɲini minkɛ, ");
INSERT INTO dyu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka ko a dencɛ Yakuba ma ko: «Ne ka i facɛ kumakan mɛn, a tun b’a fɔra i kɔrɔcɛ Esawu ye ko: ");
INSERT INTO dyu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹Taga sogo ɲini ne ye; sogo tobicogo min ka di ne ye, i bɛna o ɲɔgɔn tobi k’a di ne ma ne ye a domu; ni o kɛra, ne bɛna dugawu kɛ i ye Matigi Ala ɲa kɔrɔ sani ne ye sa.› » ");
INSERT INTO dyu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Rebeka ko Yakuba ma tuun ko: «Ne dencɛ, ne bɛna min fɔ i ye, i toro lɔ ka o lamɛn kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Taga ba fla mina bakuru ra ka na. Domuni min ɲɔgɔn ka di i facɛ ye, ne bɛna o tobi a ye, ");
INSERT INTO dyu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","i bɛ taga ni a ye a fɛ, a b’a domu, ka dugawu kɛ i ye sani a ye sa.» ");
INSERT INTO dyu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakuba ko a bamuso Rebeka ma ko: «Can lo, nka ne facɛ k’a lɔn ko si bɛ Esawu fari ra, k’a sɔrɔ si tɛ ne fari ra. ");
INSERT INTO dyu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ni ne facɛ ka na a fɔ ko a bɛ maga ne ra, a bɛna a lɔn ko ne tɛ Esawu ye; ne bɛna kɛ mɔgɔjanfabaga le ye. O tuma sani ne ye dugawu sɔrɔ, ne bɛna danga le sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","A bamuso ko: «Ne dencɛ, Ala y’a to o danga ye ne yɛrɛ le mina. Ne ka min fɔ, o kɛ dɔrɔn; taga baw mina ka na.» ");
INSERT INTO dyu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yakuba tagara ba fla mina ka na a di a bamuso ma. Sogo tobicogo min ka di a facɛ ye, a bamuso ka o ɲɔgɔn dɔ tobi. ");
INSERT INTO dyu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","O kɔ, Rebeka k’a dencɛ fɔlɔ Esawu ta fani dɔw ta bon kɔnɔ, faniɲuman dɔw, ka o don Yakuba ra. ");
INSERT INTO dyu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","A ka bagbolo dɔ kɛ ka Yakuba borokanw datugu, ani a kan. ");
INSERT INTO dyu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","A ka sogo min tobi, a ka o di Yakuba ma ko a ye taga ni a ye a facɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakuba tagara ni sogo ye a facɛ fɛ. A k’a facɛ wele ko: «Baba!» Isiyaka ko: «Naamu!» A ko: «Ne dencɛ, ele ye jɔn le ye?» ");
INSERT INTO dyu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakuba k’a facɛ jaabi ko: «Ne le ye i dencɛ fɔlɔ Esawu ye. I tun ka min fɔ ne ye, ne ka o le kɛ. Sabari ka wuri ka sigi ka ne ta sogo dɔ ɲimi, ka dugawu kɛ ne ye.» ");
INSERT INTO dyu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isiyaka ko a dencɛ ma ko: «E! Ele ka sogo sɔrɔ ka ban wa?» Yakuba ko: «I Matigi Ala yɛrɛ le ka sogow lana ne fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isiyaka ko: «Ne dencɛ, gbara yan, ne ye maga i ra k’a lɔn ni can lo ko ele le ye ne dencɛ Esawu ye, walama ni ele tɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakuba gbarara a facɛ ra; a facɛ magara a ra minkɛ, a ko: «A tigi kan ye Yakuba kan ye, nka a borow ye Esawu ta borow ye.» ");
INSERT INTO dyu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isiyaka ma se k’a lɔn ko Yakuba lo, sabu si tun bɛ a borow ra i n’a fɔ a balemacɛ Esawu borow. A ka dugawu kɛ a ye. ");
INSERT INTO dyu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","A k’a ɲininka tuun ko: «Yala can ra ele le ye ne dencɛ Esawu ye wa?» Yakuba ko: «Ɔnhɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isiyaka ko: «Ne dencɛ, o tuma sogo sigi ne kɔrɔ, janko ne ye dɔ ɲimi, ka dugawu kɛ i ye.» Yakuba ka sogo sigi a kɔrɔ, a k’a domu. Yakuba nana ni rɛzɛnji fana ye, a ka o min. ");
INSERT INTO dyu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","O kɔ, Isiyaka ko: «Gbara ne ra, i ye ne fo ni kanuya ye.» ");
INSERT INTO dyu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakuba gbarara a ra k’a fo ni kanuya ye. Isiyaka ka a ta faniw kasa mɛn. A ka dugawu kɛ a ye; a ko: «Ɔnhɔn, Matigi Ala ka baraka don kongo min na ne dencɛ kasa bɛ i ko o kongo kasa. ");
INSERT INTO dyu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ne dencɛ, Ala ye sankolo gɔmiji di i ma ka dugukolo turu di i ma, ka siman ni rɛzɛn di i ma caman. ");
INSERT INTO dyu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ala ye jamanaw bla i ta fanga kɔrɔ k’a to siyaw ye na o kinbiri gban i kɔrɔ. Ala ye i kɛ i balemaw matigicɛ ye, k’a to i balemaw ye na o kinbiri gban i kɔrɔ. Ni mɔgɔ min ka i minako juguya, Ala ye o tigi danga; ni mɔgɔ min ka i minako ɲa, Ala ye baraka don o tigi ra.» ");
INSERT INTO dyu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ayiwa, Isiyaka ka dugawu kɛ Yakuba ye ka ban minkɛ, ani Yakuba bɔra a kɔrɔ minkɛ dɔrɔn, a kɔrɔcɛ Esawu nana ka bɔ kongo ra. ");
INSERT INTO dyu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A tagara a ta sogo dɔ tobi ka taga o sigi a facɛ kɔrɔ. A ko a facɛ ma ko: «Baba, wuri ka i dencɛ ta sogo dɔ domu, ka dugawu kɛ a ye.» ");
INSERT INTO dyu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","A facɛ Isiyaka ko: «Ele ye jɔn le ye?» A ko: «Ne le ye i dencɛ kɔrɔba Esawu ye.» ");
INSERT INTO dyu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Esawu ka o fɔ minkɛ, Isiyaka ja tigɛra fɔ a bɛ yɛrɛyɛrɛ. A ko: «O tuma jɔn le tagara sogo faga ka na o tobi k’a di ne ma? Sani i ye na, dɔ nana ni sogo ye ne fɛ; ne k’a domu ka dugawu kɛ a tigi ye, a fana bɛna o dugawu sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ayiwa, Esawu ka o kuma mɛn a facɛ fɛ minkɛ, a jusu kasira; a kulera kosɛbɛ. A k’a fɔ a facɛ ye ko: «Baba, dugawu dɔ kɛ ne fana ye!» ");
INSERT INTO dyu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isiyaka ko: «I dɔgɔcɛ le nana faninya tigɛ, ka i janfa, ka i ta dugawu sonya.» ");
INSERT INTO dyu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu ko: «E! O tuma a tɔgɔ lara minkɛ ko Yakuba, o kosɔn a ka ne janfa fɔ siɲaga fla kɛ? A tɔgɔ bɛnna a ma faasi. A ka ne ta kɔrɔya mina ka o kɛ a yɛrɛ ta ye; sisan, a ka ne ta dugawu fana sonya.» Esawu ko a facɛ ma ko: «O tuma ele ma dugawu dɔ bla ne fana ye wa?» ");
INSERT INTO dyu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isiyaka ko Esawu ma ko: «A flɛ, ne ka dugawu kɛ a ye ka ban ko a ye kɛ i matigicɛ ye, ko a balema tɔw bɛɛ ye kɛ a ta jɔnw ye; ne ka siman ni rɛzɛn caman dugawu kɛ a ye. Ne bɛna dugawu juman wɛrɛ le kɛ ele ye tuun sa?» ");
INSERT INTO dyu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu ko a facɛ ma ko: «Baba, o tuma o dugawu kelen dɔrɔn le tun bɛ ele fɛ wa? Dugawu dɔ wɛrɛ kɛ ne ye.» Esawu ka o fɔ minkɛ, a kasira kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","A facɛ ko: «A flɛ, ele tɛna dugukolo turu sɔrɔ, i tɛna sankolo gɔmiji fana sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","I bɛna ɲanamanya i ta kɛrɛkɛmuru le baraka ra. I bɛna kɛ i dɔgɔcɛ ta jɔn ye fana; nka i bɛna to i yɛrɛ ma ka yaala ka lamini, ka i yɛrɛ bɔ a ta jɔnya fanga kɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ayiwa, Isiyaka tun ka dugawu min kɛ Yakuba ye, o ko kɛra sababu ye k’a to Esawu ka Yakuba kɔninya; a nana kɛ Esawu tun b’a fɔra a yɛrɛ kɔnɔ ko: «Ne facɛ sawagati bɛ surunyara; ni a sara, ni ne k’a sutara ka ban, ne bɛ ne dɔgɔcɛ Yakuba faga.» ");
INSERT INTO dyu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Dɔ tagara Rebeka fɛ, ka taga a dencɛ fɔlɔ Esawu ta miiriya fɔ a ye. Rebeka k’a dencɛ Yakuba wele, k’a fɔ a ye ko: «A flɛ, i kɔrɔcɛ Esawu ko a bɛna i faga k’a yɛrɛ dimibɔ. ");
INSERT INTO dyu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","O ra ne bɛna min fɔ i ye, o lamɛn. I ka kan ka bori ka taga Haran jamana ra, ne kɔrɔcɛ Laban fɛ yi. ");
INSERT INTO dyu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","I bɛ taga to ale kɔrɔ ka wagati kɛ yi, sani k’a to i kɔrɔcɛ jusu ye suma. ");
INSERT INTO dyu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","I ye to yi fɔ i kɔrɔcɛ ta dimi ye mala, janko i ka min kɛ a ra, a ye ɲina o kɔ. Ni a nana ɲina, ne bɛna i lana yan tuun. Ni o tɛ, ne le bɛna bɔnɔ aw fla bɛɛ ra lon kelen na.» ");
INSERT INTO dyu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ayiwa, Rebeka tagara a fɔ Isiyaka ye ko: «Isiyaka, Esawu ka Hɛti denmuso minw furu, o musow kɔni ka ne sɛgɛ fɔ ka dunuɲa lɔgɔ bɛɛ bɔ ne ra. Ayiwa, ni Yakuba fana nana o musow ɲɔgɔn dɔ furu nin jamana ra yan, Hɛti denmusow ra, o tuma hali ne ye sa o belen ka fisa.» ");
INSERT INTO dyu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ayiwa, Isiyaka ka Yakuba wele o le ra ka dugawu kɛ a ye, k’a fɔ a ye ko: «I kana i ta muso ta Kanaanakaw ta denmusow ra dɛ! ");
INSERT INTO dyu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","I bɛ taga fɔ Mesopotami jamana le ra, i bamuso facɛ ta so, ka taga i bamuso kɔrɔcɛ Laban ta denmuso dɔ ta i muso ye o yɔrɔ ra yi. ");
INSERT INTO dyu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Sebɛɛtigi Ala ye baraka don i ra, ka den caman di i ma, ka i ta duruja caya, janko i ta mɔgɔw ye kɛ mɔgɔ camanba ye. ");
INSERT INTO dyu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ala ka baraka min don Iburahima ra, a ye o baraka ɲɔgɔn don ele ni i ta duruja ra, janko i siginin bɛ jamana min na lonanya ra bi, o jamana min dira Iburahima ma, o jamana ye kɛ i ta ye.» ");
INSERT INTO dyu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","O kɔ, Isiyaka ka Yakuba bla ka taga Mesopotami jamana ra, Laban fɛ, min ye Aramekacɛ Betuhɛli dencɛ ye. Laban ye Yakuba ni Esawu bamuso Rebeka kɔrɔcɛ le ye. ");
INSERT INTO dyu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ayiwa, Esawu nana a ye ko Isiyaka ka dugawu kɛ Yakuba ye, k’a ci ka taga Mesopotami jamana ra, ka taga muso ta yi; a k’a ye ko a ka dugawu kɛ Yakuba ye k’a fɔ a ye ko a kana muso ta Kanaanakaw ta denmusow ra; ");
INSERT INTO dyu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","a k’a ye fana ko Yakuba k’a facɛ ni a bamuso kan mina, ka taga Mesopotami jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ayiwa, Esawu k’a lɔn o le ra ko Kanaana sunguruw man di a facɛ Isiyaka ye. ");
INSERT INTO dyu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","A k’a ye ten minkɛ, a wurira ka taga Iburahima dencɛ Sumayila ta mɔgɔw fɛ, ka taga olugu denmuso dɔ furu ka o fara a muso tɔw kan. O sunguru tɔgɔ tun ye ko Mahalati. Ale tun ye Nebayɔti dɔgɔmuso ye. ");
INSERT INTO dyu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ayiwa, Yakuba bɔra Bɛri Seba ko a bɛ taga Haran. ");
INSERT INTO dyu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","A tagatɔ, a sera yɔrɔ dɔ ra; a sira yi sabu tere tun benna ka ban. A ka kabakuru dɔ ta ka o bla a kun kɔrɔ ka la. ");
INSERT INTO dyu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","A sikora ka yɛlɛnyɛlɛnnan dɔ ye, a lɔnin bɛ dugu ma, a kun bɛ sera fɔ sankolo ma. Ala ta mɛlɛkɛw tun bɛ yɛlɛnna ka jigi o yɛlɛnyɛlɛnnan fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Matigi Ala yɛrɛ tun bɛ yɛlɛnyɛlɛnnan kunna, san fɛ. Ala ko Yakuba ma ko: «Ne le ye Matigi Ala ye, i bɛmacɛ Iburahima ta Ala, ani i facɛ Isiyaka ta Ala. I lanin bɛ dugukolo min kan, ne bɛna o di i ni i ta duruja ma. ");
INSERT INTO dyu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","I ta duruja bɛna caya i ko dugukolo kɛnkɛnmugu. I ta denw bɛna caya ka taga terebenyanfan na, ka taga terebɔyanfan na, ka taga sahiliyanfan fɛ, ani ka taga woroduguyanfan fɛ. Ne bɛna baraka don dugukolo gbaw bɛɛ ra, ele ni i ta duruja le sababu ra. ");
INSERT INTO dyu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ne bɛ ni i ye; ni i bɛ taga yɔrɔ o yɔrɔ, ne bɛna kɛ ni i ye ka i tanga kojugu ma. Ne bɛna a to i ye sekɔ ka na nin jamana ra yan tuun. Ne tɛna i to i kelen na fiyewu. Ne ka fɛn o fɛn fɔ i ye, ne bɛna o bɛɛ kɛ k’a dafa.» ");
INSERT INTO dyu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakuba wurira a ta sunɔgɔ ra minkɛ, a ko: «Sigiya t’a ra, Matigi Ala bɛ nin yɔrɔ ra, k’a sɔrɔ ne tun ma o lɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakuba siranna; a ko: «Nin yɔrɔ ye siranyayɔrɔ le ye dɛ! I b’a sɔrɔ ko yan le ye Ala ta so ye cɔ. Sankolo donda fana ka kan ka sɔrɔ yan le.» ");
INSERT INTO dyu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","A wurira sɔgɔmada joona fɛ; a tun ka kabakuru min bla a kun kɔrɔ, a ka o wuri k’a lɔ, ka turu bɔn a kan, k’a kɛ hakirijigifɛn ye. ");
INSERT INTO dyu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A ka o yɔrɔ tɔgɔ la ko Betɛli; k’a sɔrɔ fɔlɔfɔlɔ o yɔrɔ tɔgɔ tun ye le ko Luzi. ");
INSERT INTO dyu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakuba ka dajuru ta Ala fɛ; a ko: «Ni Ala tora ni ne ye, ka ne tanga kojuguw ma nin tagama ra, ni a ka domuni di ne ma ne y’a domu, ka ne ta fani donta di ne ma, ");
INSERT INTO dyu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","k’a to ne ye sekɔ hɛra ra ka na ne faso ra, o tuma Matigi Ala bɛna kɛ ne ta Ala ye. ");
INSERT INTO dyu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ne ka nin kabakuru min lɔ nin ye fana yan, k’a kɛ hakirijigifɛn ye, o yɔrɔ bɛna kɛ Ala ta so ye. Ni ne ka fɛn o fɛn sɔrɔ, ne bɛna o yaga bɔ Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakuba wurira ka sira mina ka taga terebɔyanfan jamana fan fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","A tagara kɔlɔn dɔ ye kongo kɔnɔ. Sagakuru saba tun bɛ yi, o sagaw tun lanin bɛ kɔlɔnda ra. O tun bɛ o sagaw lamin o kɔlɔn le ra. O tun bɛ kɔlɔn datugu ni kabakuru min ye, o kabakuru tun ka bon kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","O tun bɛ sagaw bɛɛ lajɛn o yɔrɔ le ra; ni sagaw bɛɛ nana, o bɛ sɔrɔ ka kabakuruba kolonkolon ka bɔ kɔlɔn da ra, ka sagaw lamin. Ni sagaw minna, o bɛ kabakuruba kolonkolon k’a bla kɔlɔn da ra tuun. ");
INSERT INTO dyu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakuba ka o sagagbɛnbagaw ɲininka ko: «Ne balemaw, aw bɔra yɔrɔ juman le?» O ko: «Anw bɔra Karan le.» ");
INSERT INTO dyu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakuba ko: «Yala aw ka Laban lɔn wa, Nahɔri dencɛ?» O ko: «An k’a lɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakuba ko: «Yala a ka kɛnɛ wa?» O ko: «A ka kɛnɛ kosɛbɛ. A denmuso Rasɛli yɛrɛ natɔ ye nin ye, ni sagaw ye.» ");
INSERT INTO dyu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ayiwa, Yakuba ko sagagbɛnbagaw ma ko: «Sagaw lajɛntuma ma se fɔlɔ dɛ! Aw m’a ye ko tere tɔ ka jan hali bi wa? Aw ye sagaw to o ye min, o kɔ, aw ye taga ni o ye, o ye bin ɲimi.» ");
INSERT INTO dyu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Sagagbɛnbagaw ko: «An tɛ se ka o kɛ; fɔ sagaw bɛɛ le ye lajɛn fɔlɔ, an bɛ sɔrɔ ka kabakuru kolonkolon ka bɔ kɔlɔnda ra, ka sagaw lamin.» ");
INSERT INTO dyu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ka Yakuba to o kuma ra ni sagagbɛnbagaw ye, Rasɛli sera ni a facɛ ta sagaw ye. Ale le tun bɛ o sagaw gbɛnna. ");
INSERT INTO dyu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakuba ka Rasɛli ye minkɛ, a belencɛ Laban denmuso, ani a belencɛ ta sagaw, a tagara kabakuru kolonkolon ka bɔ kɔlɔnda ra, k’a belencɛ Laban ta sagaw lamin. ");
INSERT INTO dyu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakuba ka Rasɛli fo ni kanuya ye, ka kasi kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","A k’a fɔ Rasɛli ye ko ale ye a facɛ ta mɔgɔ le ye; ko ale ye a facɛ dɔgɔmuso Rebeka dencɛ le ye. Rasɛli borira ka taga so ka taga o fɔ a facɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kabini Laban k’a dɔgɔmuso dencɛ Yakuba ko mɛn, a borira ka taga a nɔ fɛ, ka taga a boro melege a ma, k’a fo ni kanuya ye, ka taga ni a ye so kɔnɔ. Ko minw ka Yakuba sɔrɔ, a ka o bɛɛ lakari Laban ye. ");
INSERT INTO dyu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban ka o mɛn minkɛ, a ko: «Ka can fɔ, ele ni ne bɛɛ ye mɔgɔ kelen le ye.» Yakuba tora Laban fɛ ka na se fɔ karo kelen. ");
INSERT INTO dyu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lon dɔ, Laban nana a fɔ Yakuba ye ko: «Ne ta mɔgɔ le bɛ i ye, o ye can ye, nka o bɛɛ n’a ta, i man kan ka baara kɛ ne ye gbansan. I sara ka kan ka kɛ min ye, o fɔ ne ye.» ");
INSERT INTO dyu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ayiwa, o y’a sɔrɔ denmuso fla tun bɛ Laban fɛ. Kɔrɔmusoman tɔgɔ tun ye ko Leya; a dɔgɔmuso le tun ye Rasɛli ye. ");
INSERT INTO dyu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya ɲadenw le tun cɛ ka ɲi; nka Rasɛli fari tun cɛ ka ɲi, a ɲada fana tun cɛ ka ɲi. ");
INSERT INTO dyu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Rasɛli ko le tun ka di Yakuba ye. A ko Laban ma ko: «Ne bɛna baara kɛ i ye san wolonfla i denmuso flanan Rasɛli kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ko: «Ne ye a di ele ma, o ka fisa ne ye a di mɔgɔ wɛrɛ ma. To ni ne ye yan.» ");
INSERT INTO dyu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","O cogo ra, Yakuba tora Laban fɛ ka baara kɛ fɔ san wolonfla Rasɛli kosɔn. Nka Rasɛli diyanya kosɔn, o san wolonfla kɛra a ɲa na i ko tere dama dɔrɔn. ");
INSERT INTO dyu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","San wolonfla bannin kɔ, Yakuba ko Laban ma ko: «Ne ta muso di ne ma sisan sabu wagati min tun yirara, o dafara; ne b’a fɛ ka jɛn ni a ye sisan.» ");
INSERT INTO dyu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban ka o yɔrɔ mɔgɔw bɛɛ lajɛn, ka domuniba tobi, o ka o yɛrɛ ɲanagbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ayiwa, su fɛ, Laban k’a denmuso Leya ta ka taga ni a ye Yakuba fɛ. Yakuba sira ni a ye o su fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban tun k’a ta baaradenmuso dɔ di Leya ma, k’a kɛ a ta baaradenmuso ye. O tɔgɔ tun ye ko Zilipa. ");
INSERT INTO dyu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Dugu nana gbɛ minkɛ, Yakuba k’a ye ko Leya lo. A ko Laban ma ko: «I ka mun le kɛ ne ra tan? O tuma ne ma baara kɛ i ye Rasɛli le kosɔn wa? Mun kosɔn i ka ne janfa?» ");
INSERT INTO dyu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ko: «An ta landa ra yan, an tɛ se ka dɔgɔmuso di furu ra kɔrɔmuso ɲa. ");
INSERT INTO dyu_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Lɔgɔkun tɔ kɛ ni Leya ye. Ni lɔgɔkun banna, an bɛna dɔgɔmusoman fana di i ma, ni i ka san wolonfla wɛrɛ baara kɛ ne fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakuba k’a kɛ ten; a ka lɔgɔkun tɔ kɛ ni Leya ye. O kɔ, Laban k’a denmuso Rasɛli fana di a ma. ");
INSERT INTO dyu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban k’a ta baaradenmuso dɔ di Rasɛli ma; o tɔgɔ tun ye ko Bila. ");
INSERT INTO dyu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakuba jɛnna ni Rasɛli fana ye. Ale le ko diyara a ye ka tɛmɛ Leya kan; Yakuba ka baara kɛ Laban ye tuun fɔ san wolonfla. ");
INSERT INTO dyu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Matigi Ala k’a ye ko Leya ko tun man di Yakuba ye; o kosɔn Ala ka denworo nɔgɔya Leya ma, nka Rasɛli ma se ka den sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya nana kɔnɔ ta ka dencɛ woro; a k’a tɔgɔ la ko Rubɛn, ko: «Matigi Ala ka ne ta sɛgɛ ye; sisan ne cɛ bɛna ne kanu.» ");
INSERT INTO dyu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A nana kɔnɔ ta tuun, ka dencɛ wɛrɛ woro; a ko: «Matigi Ala k’a mɛn ko ne ko man di ne cɛ ye, o kosɔn a ka nin fana di ne ma.» A ka o tɔgɔ la ko Simeyɔn. ");
INSERT INTO dyu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leya ka kɔnɔ ta tuun ka dencɛ wɛrɛ woro; a ko: «Sisan kɔni ne cɛ bɛna nɔrɔ ne ra, sabu ne ka dencɛ saba le woro a ye.» O kosɔn a ka o tɔgɔ la ko Levi. ");
INSERT INTO dyu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A ka kɔnɔ wɛrɛ ta ka dencɛ naaninan woro. A ko: «Sisan ne bɛna Matigi tando le.» O kosɔn a ka o tɔgɔ la ko Zuda. O kɔ, a ma dɔ woro o wagati ra tuun. ");
INSERT INTO dyu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ayiwa, Rasɛli nana a ye ko ale tɛ den worora Yakuba ye minkɛ, a kɔrɔmuso celiya k’a mina. A ko Yakuba ma ko: «Den dɔ di ne fana ma, ni o tɛ, ne bɛna sa.» ");
INSERT INTO dyu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakuba dimina Rasɛli kɔrɔ kosɛbɛ. A ko: «O tuma ne le ye Ala ye wa? Ala le ma i bari denworo ra wa?» ");
INSERT INTO dyu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rasɛli ko: «Ne ta baaradenmuso Bila ye nin ye; jɛn ni ale ye, janko a ye den sɔrɔ ne ye. Ni o kɛra, ale sababu ra, ne fana bɛna den dɔ sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rasɛli k’a ta baaradenmuso Bila di Yakuba ma k’a kɛ a muso ye. Yakuba jɛnna ni a ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila nana kɔnɔ ta ka dencɛ woro Yakuba ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rasɛli ko: «Ala ka jo di ne ma. Ne ka min fɔ a ka o mɛn, ka dencɛ di ne ma.» O kosɔn Rasɛli ka den tɔgɔ la ko Dan. ");
INSERT INTO dyu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rasɛli ta baaraden Bila nana kɔnɔ ta ka dencɛ flanan woro Yakuba ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rasɛli ko: «Ne ka siyɛngbɛlɛn le ta ni ne kɔrɔmuso ye fɔ ka se sɔrɔ.» A ka o den tɔgɔ la ko Nɛfitali. ");
INSERT INTO dyu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ayiwa, Leya nana a ye ko ale tɛ den worora minkɛ tuun, ale fana k’a ta baaradenmuso Zilipa ta ka o di Yakuba ma. ");
INSERT INTO dyu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilipa nana kɔnɔ ta ka dencɛ woro Yakuba ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya ko: «Ne kunnadiyara dɛ!» A ka o den tɔgɔ la ko Gadi. ");
INSERT INTO dyu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilipa nana dencɛ flanan woro Yakuba ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya ko: «E! Nin ye hɛra le ye dɛ! Musow bɛna a fɔ ko ne ta ɲana.» A ka o tɔgɔ la ko Asɛri. ");
INSERT INTO dyu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Lon dɔ, simantigɛwagati ra, Rubɛn bɔra ka taga mandaragɔrisun dɔ ye foro ra. A ka o yiri den tigɛ ka na a di a bamuso Leya ma. Rasɛli ko Leya ma ko: «I tɛ sabari ka i dencɛ ta mandaragɔri dɔ di ne ma wa?» ");
INSERT INTO dyu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya ko: «Mun? I ka ne ta cɛ bɔsi ne ra, o ma i wasa, fɔ i belen ko ne ye ne dencɛ ta mandaragɔri le di i ma ka fara o kan kɛ!» Rasɛli ko: «Ayiwa, ni o lo, a bɛna bi su kɛ ni i ye. O bɛ kɛ mandaragɔri sara ye.» Leya sɔnna o ma. ");
INSERT INTO dyu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ayiwa, wula fɛ, Yakuba bɔtɔ foro ra, Leya borira ka taga a kunbɛn, k’a fɔ a ye ko: «I bɛ si ne le fɛ bi. Ne ka i sɔrɔ ni ne dencɛ ta mandaragɔriw ye.» Yakuba tagara si Leya fɛ o lon su fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ala ka Leya ta daariri lamɛn. A nana kɔnɔ ta ka dencɛ loorunan woro Yakuba ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya ko: «Ne ka ne ta baaradenmuso di ne ta cɛ ma minkɛ, Ala ka o sara le di ne ma.» Leya ka o den tɔgɔ la ko Isakari. ");
INSERT INTO dyu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya nana kɔnɔ ta tuun, k’a dencɛ wɔɔrɔnan woro Yakuba ye minkɛ, ");
INSERT INTO dyu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","a ko: «Ala ka fɛnba kɛ ne ye. Sisan ne cɛ bɛna ne bonya, sabu ne ka dencɛ wɔɔrɔ le woro a ye.» Leya ka o den tɔgɔ la ko Zabulɔn. ");
INSERT INTO dyu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","O kɔ, a ka denmuso woro, ka o tɔgɔ la ko Dina. ");
INSERT INTO dyu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ayiwa, Ala hakiri tora Rasɛli ra, k’a ta daariri lamɛn, ka woro nɔgɔya a ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rasɛli nana kɔnɔ ta ka dencɛ woro. A ko: «Ala ka maroya bɔ ne ra sisan.» ");
INSERT INTO dyu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A k’a tɔgɔ la ko Yusufu. A ko: «Ala ye dencɛ wɛrɛ fara nin kan ne ye.» ");
INSERT INTO dyu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ayiwa, Rasɛli ka Yusufu woro minkɛ, lon dɔ Yakuba k’a fɔ Laban ye ko: «Sira di ne ma ne bɛ sekɔ ka taga so, ne faso ra. ");
INSERT INTO dyu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ne ta musow, ani ne ta denw di ne ma; ne ka baara kɛ i ye olugu le kosɔn. O di ne ma ne bɛ taga so, sabu ne ka min kɛ i ye, i yɛrɛ ka o lɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban ko: «Ni ne ko ka di i ye, o tuma to yan. Ne ta lagbɛrikɛfɛnw k’a yira ne ra ko Matigi Ala ka baraka don ne ra ele le sababu ra. ");
INSERT INTO dyu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","I ta sara bɛ kɛ min ye, o fɔ ne ye, ne bɛ o di i ma.» ");
INSERT INTO dyu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakuba ko: «Ne ka baara kɛ cogo min na, ani i ta bɛganw cayara cogo min ne boro, ele yɛrɛ ka o lɔn. ");
INSERT INTO dyu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Sabu bɛgan fitini min tun bɛ i fɛ sani ne ye na yan, o cayara sisan ka kɛ bɛgankuruba ye. Matigi Ala ka baraka don i ra ne le sababu ra. Sisan ne bɛna wagati juman le sɔrɔ ka baara kɛ ne yɛrɛ ta mɔgɔw ye?» ");
INSERT INTO dyu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban ko: «I b’a fɛ ne ye mun le di i ma i sara ye?» Yakuba ko: «I tɛna foyi wɛrɛ di ne ma; ne bɛna min fɔ, ni i sɔnna o ma, ne bɛna i ta sagaw gbɛn tuun, ka o kɔrɔsi. ");
INSERT INTO dyu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nka bi, ne bɛna don i ta bɛganw cɛ ra ka o bɛɛ flɛflɛ kelen kelen. Sagaden musoman minw ɲɛgɛnɲɛgɛnna, ani fin bɛ minw na, ani minw yɔrɔ bɛɛ finna, ani ba minw ɲɛgɛnna fana, ani fin bɛ minw na, ne bɛna olugu bɛɛ mina ka o bla danna. O le bɛ kɛ ne ta sara ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","O kɔ fɛ, ni i nana ne ta sagaw flɛ, ni ne terennin lo walama ni ne terennin tɛ, walama ni ne ka i janfa, i yɛrɛ bɛna o lɔn; ni i nana ba o ba ye ne fɛ, min ma ɲɛgɛn, walama fin tɛ a ra, ani ni i ka sagaden o sagaden ye ne fɛ, min ma fin, o tuma ne ka o sonya i fɛ le.» ");
INSERT INTO dyu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ko: «Ayiwa, i k’a fɔ cogo min na, an ye a kɛ ten.» ");
INSERT INTO dyu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Nka, o lon yɛrɛ ra, bakɔrɔnin min o min ɲɛgɛnɲɛgɛnna, ani fin bɛ a min o min na, ani ba musoman min o min ɲɛgɛnɲɛgɛnna, ani fin bɛ a min o min na, walama gbɛ tun bɛ min o min na, ani saga min o min finna, Laban ka olugu bɛɛ woloma ka o bla danna. A ka olugu karifa a dencɛw ma, ");
INSERT INTO dyu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ka o bla ka taga yɔrɔ wɛrɛ, ka o yɔrɔ janya Yakuba ra; a dencɛw tagamana fɔ tere saba ka taga o yɔrɔ ra. Yakuba ka to ni Laban ta bɛgan tɔw ye, ka kɛ olugu kɔrɔsi ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ayiwa, Yakuba ka bere kɛnɛ dɔw tigɛ, pepiliyesun dɔw ra, ani amandesun dɔw ra, ani pilatanisun dɔw ra. A ka o berekɛnɛw fara dɔw bɔbɔ o ra, ka o gbɛmanyɔrɔw bɔbɔ, ka o ɲɛgɛnɲɛgɛn. ");
INSERT INTO dyu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","A ka o bere kɛnɛ ɲɛgɛnninw blabla bɛganw ta jiminfaga kɔnɔ, janko bɛganw natɔ jiminyɔrɔ ra, o ye o bere ɲɛgɛnninw ye; k’a sɔrɔ bɛganw tun bɛ yɛlɛn ɲɔgɔn kan jiminyɔrɔ le ra. ");
INSERT INTO dyu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ayiwa, bɛganw nana kɛ yɛlɛn ye ɲɔgɔn kan jiminyɔrɔ ra ka o ɲa to o bere ɲɛgɛnninw na. A kɛra ten, o bɛganw nana den o den woro, o denw bɛɛ ɲɛgɛnɲɛgɛnnin worora, ka fin kɛ o ra, walama ka gbɛ kɛ o ra. ");
INSERT INTO dyu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakuba tun ka saga minw woloma, a ka olugu bla Laban ta saga ɲɛgɛnninw, ani a finmanw ɲa kɔrɔ, janko o ye Laban ta sagaw flɛ. A kɛra ten Yakuba ka bɛgankuru dɔw sɔrɔ a yɛrɛ ta ye; a ma sɔn ka o fara Laban taw kan. ");
INSERT INTO dyu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ni saga barakamanw le tun bɛ nana min, Yakuba tun bɛ bere ɲɛgɛnɲɛgɛnnin bla jiminfaga kɔnɔ o ɲa kɔrɔ, janko o yɛlɛntɔ ɲɔgɔn kan, o ye berew ye, ani janko ni o sagamusow ka na kɔnɔ ta o denw ye ɲɛgɛnɲɛgɛn. ");
INSERT INTO dyu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Nka ni saga fasaninw le tun bɛ na min, Yakuba tun tɛ bere bla jiminfaga kɔnɔ o ɲa kɔrɔ. O cogo ra, saga fasaninw kɛra Laban ta ye, saga belebelew kɛra Yakuba yɛrɛ ta ye. ");
INSERT INTO dyu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ayiwa, Yakuba kɛra fɛntigi ye o cogo le ra. A ka baw ni sagaw sɔrɔ caman; baaraden musomanw ni a cɛmanw tun bɛ a fɛ, ani ɲɔgɔmɛw, ani faliw. ");
INSERT INTO dyu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ayiwa, Yakuba nana a mɛn ko Laban dencɛw b’a fɔra ko: «Yakuba ka an facɛ borofɛnw bɛɛ ta. A ka an facɛ ta naforo le ta k’a yɛrɛ kɛ fɛntigi ye.» ");
INSERT INTO dyu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakuba nana Laban kɔrɔsi fana, k’a ye ko Laban tun ka ale mina cogo min na fɔlɔ, a tɛ o cogo ra tuun. ");
INSERT INTO dyu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Lon dɔ, Matigi Ala k’a fɔ Yakuba ye ko: «Sekɔ i faso ra, i worora yɔrɔ min na. Ne bɛna kɛ ni i ye.» ");
INSERT INTO dyu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","O kuma fɔra minkɛ, Yakuba ka Rasɛli ni Leya wele ka na. Olugu tun bɛ kongo ra bɛganw kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yakuba ka o wele k’a fɔ o ye ko: «Ne k’a ye aw facɛ ɲa ra ko a tun ka ne mina cogo min na fɔlɔ, ko a tɛ ten tuun. Nka ne facɛ ta Ala le tora ne fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Aw yɛrɛ k’a lɔn ko ne ka baara kɛ aw facɛ ye ni ne baraka bɛɛ le ye. ");
INSERT INTO dyu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","O bɛɛ n’a ta, aw facɛ ka ne janfa, ka ne ta sara yɛlɛma fɔ siɲaga tan. Nka Ala ma sɔn a ye kojugu kɛ ne ra. ");
INSERT INTO dyu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","A ko minkɛ ko ni fin walama gbɛ ka kɛ sagaden minw na, ko olugu le bɛ kɛ ne ta sara ye, sagamusow ka sagaden o sagaden woro, fin walama gbɛ kɛra o bɛɛ ra. A nana yɛlɛma k’a fɔ ko ni sagaden minw ɲɛgɛnɲɛgɛnna, ko olugu le bɛ kɛ ne ta ye; o tuma sagamusow ka sagaden o sagaden woro, o bɛɛ ɲɛgɛnɲɛgɛnnin worora. ");
INSERT INTO dyu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ala le ka aw facɛ ta sagaw mina a ra ka o di ne ma; ");
INSERT INTO dyu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","sabu wagati min bɛganw tun bɛ yɛlɛn ɲɔgɔn kan, lon dɔ ne sikora; ne ka ne ɲa kɔrɔta, k’a ye ko bakɔrɔnin minw tun yɛlɛnna ba musomanw kan, olugu bɛɛ tun ɲɛgɛnɲɛgɛnnin lo, walama fin tun bɛ o ra. ");
INSERT INTO dyu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","O wagati ra, Ala ta mɛlɛkɛ ka ne wele ko: ‹Yakuba!› Ne ko: ‹Naamu.› ");
INSERT INTO dyu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A ko: ‹I ɲa kɔrɔta ka flɛri kɛ: bakɔrɔnin minw bɛ yɛlɛnna bamusow kan, o bɛɛ ɲɛgɛnɲɛgɛnnin lo, walama nɔ bɛ o bɛɛ ra.› A ko: ‹Ne ka o kɛ sabu Laban ka fɛn o fɛn kɛ i ra, ne ka o bɛɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ala min k’a yɛrɛ yira i ra Betɛli, ne le ye o Ala ye. I ka turu kɛ kabakuru kan o yɔrɔ le ra k’a kɛ hakirijigifɛn ye, ka dajuru ta ne Ala fɛ. Ayiwa, sisan wuri ka bɔ nin jamana ra, ka sekɔ i worojamana ra.› » ");
INSERT INTO dyu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ayiwa, Rasɛli ni Leya ka Yakuba ta kuma mɛn minkɛ, o ko: «Anw ninyɔrɔ foyi tɛ yan tuun, an fana tɛna cɛn foyi sɔrɔ an facɛ ta so yan tuun. ");
INSERT INTO dyu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Anw facɛ yɛrɛ bɛ anw jatera lonanw le ye sisan. A ma an fiyeere ka an wari domu ka ban wa?» ");
INSERT INTO dyu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","O ko Yakuba ma tuun ko: «Ala ka naforo minw mina an facɛ ra k’a di i ma, o ye anw ni an ta denw ta le ye sisan. O ra, Ala ka min fɔ i ye, o kɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakuba wurira k’a ta musow ni a ta denw yɛlɛn ɲɔgɔmɛw kan ka sira mina. ");
INSERT INTO dyu_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","A tagara ni a ta bɛganw bɛɛ ye, a ka bɛgan minw bɛɛ sɔrɔ Mesopotami jamana ra, ani fɛn o fɛn tun bɛ a ta ye. A ka kɛ taga ye a facɛ Isiyaka fɛ, Kanaana jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Yakuba bɔra wagati min na, o y’a sɔrɔ Laban tun tagara a ta sagaw sikanyɔrɔ ra. O bɔtɔ, Rasɛli k’a facɛ Laban ta batofɛnw sonya. ");
INSERT INTO dyu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakuba ka Aramekacɛ Laban janfa tan le, ka bɔ ka taga, a ma sara a ra. ");
INSERT INTO dyu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Fɛn o fɛn tun ye a ta ye, a teliyara ka o bɛɛ ta ka taga ni o ye. A ka Efirati ba tigɛ, ka taga Galadi kuruw fan fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yakuba taganin tere sabanan le ra, o sɔrɔra k’a fɔ Laban ye ko Yakuba borira. ");
INSERT INTO dyu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban k’a ta mɔgɔ dɔw ta ka Yakuba nɔgbɛn fɔ tere wolonfla. A tagara Yakuba sɔrɔ Galadi kuruyɔrɔw ra. ");
INSERT INTO dyu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Nka o lon su fɛ, Ala k’a yɛrɛ yira Aramekacɛ Laban na, siko ra, k’a fɔ a ye ko: «Laban, i yɛrɛ kɔrɔsi, i kana foyi kɛ Yakuba ra dɛ!» ");
INSERT INTO dyu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ayiwa, Laban tagara se Yakuba ma tuma min na, o y’a sɔrɔ Yakuba tun k’a ta fanibonw lɔ kuru sanfɛyɔrɔ dɔ ra. Laban fana k’a ta fanibonw lɔ Galadi kuruw yɔrɔ dɔ wɛrɛ ra, ani a ta mɔgɔw. ");
INSERT INTO dyu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","O kɔ, Laban tagara a fɔ Yakuba ye ko: «Yakuba, ele ka mun le kɛ ne ra tan? Mun na i ka ne janfa ka bɔ, ka ne denmusow mina ka bɔ ni o ye, i n’a fɔ jɔn minw minana kɛrɛkɛyɔrɔ ra? ");
INSERT INTO dyu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mun na i ka ne janfa ka dogo ka bɔ, i yɛrɛ ma sara ne ra. Ne tun bɛna ɲanagbɛba dɔ kɛ ka i blasira, an bɛ ɲagari ni dɔnkirilakanw ye, ani dundunkanw, ani gɔnifɔkanw. ");
INSERT INTO dyu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hali i yɛrɛ m’a to ne ye ne denmusow ni ne mamadenw fo ni kanuya ye! I ka mun hakirintanyako le kɛ tan? ");
INSERT INTO dyu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","An bɛ yɔrɔ min na sisan, ne bɛ se ka kojugu kɛ aw ra. Nka kunu, i bɛmaw ta Ala kumana ne fɛ. A ko: ‹Laban, i yɛrɛ kɔrɔsi, i kana foyi kɛ Yakuba ra dɛ!› ");
INSERT INTO dyu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ayiwa, ne k’a lɔn ko i kɔrɔtɔninba lo; i b’a fɛ ka taga i faso ra; nka mun kosɔn i tagatɔ ka ne ta batofɛnw fana sonya?» ");
INSERT INTO dyu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakuba ka Laban jaabi ko: «Ne tun bɛ siranna ko i bɛna i denmusow bɔsi ne ra le; o kosɔn ne bɔra i ɲina ma. ");
INSERT INTO dyu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nka ni i ka i ta batofɛnw sɔrɔ mɔgɔ o mɔgɔ boro ne fɛ yan, o tigi ka kan ka faga le. An ta mɔgɔw bɛɛ ye nin ye; i ta batofɛnw ɲini yɔrɔ bɛɛ; ni i ka min ye, i ye o ta.» Yakuba tun m’a lɔn ko Rasɛli le k’a facɛ Laban ta batofɛnw sonya. ");
INSERT INTO dyu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban tagara don Yakuba ta fanibon kɔnɔ, ka yɔrɔ bɛɛ flɛ; ka taga don Leya ta fanibon kɔnɔ, ka o fana flɛ; ka taga don baaradenmuso fla ta fanibon kɔnɔ ka o fana flɛ; a ma foyi ye. O kɔ, a tagara don Rasɛli ta fanibon kɔnɔ; ");
INSERT INTO dyu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","jaga Rasɛli tun k’a facɛ ta batofɛnw ta, ka o dogo ɲɔgɔmɛ ta sigifɛn kɔnɔ ka sigi a kan. Laban ka yɔrɔ bɛɛ flɛ, a ma foyi ye. ");
INSERT INTO dyu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasɛli ko a facɛ ma ko: «Baba, musow ta landa le bɛ ne ra bi, o kosɔn ne tɛ se ka wuri; yafa ne ma.» Laban k’a ta batofɛnw ɲini yɔrɔ tɔw bɛɛ ra, a ma o ye. ");
INSERT INTO dyu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakuba dimina Laban kɔrɔ, fɔ k’a kɛ kɛrɛ ye. A ko Laban ma ko: «Ne ka i hakɛ ta mun le ra, walama ne ka kojugu juman le kɛ i ra, fɔ i jusu gbannin bɛ ne nɔgbɛnna tan? ");
INSERT INTO dyu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","I ka ne ta minanw bɛɛ flɛ minkɛ, i ka i ta mun le ye ne fɛ? Ni a kɛra ko i ka i ta fɛn dɔ ye an fɛ, a yira i ta mɔgɔw ni ne ta mɔgɔw bɛɛ ɲa na yan, olugu ye a kiti tigɛ an fla cɛ. ");
INSERT INTO dyu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ne ka san mugan le kɛ i fɛ baara ra. I ta sagaw, ani i ta baw ka den o den woro, a bɛɛ ɲanaman worora. Lon si ne ma i ta sagajigi dɔ faga k’a ɲimi. ");
INSERT INTO dyu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Lon si ne ma na ni bɛgan dɔ ye i fɛ ko waraw k’a faga k’a tigɛtigɛ. Ni waraw tun ka dɔ faga, ne yɛrɛ le tun bɛ dɔ ɲini k’a bla o nɔ ra. Ni bɛgan dɔ tun sonyana ne fɛ, ni a kɛra tere fɛ o, ni a kɛra su fɛ o, i tun b’a fɔ ko ne ye a ɲɔgɔn ɲini. ");
INSERT INTO dyu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tere fɛ, tere fundɛnin tun bɛ ne kan. Su fɛ fana, nɛnɛ tun bɛ ne mina, k’a kɛ fɔ ne tɛ se ka sunɔgɔ. ");
INSERT INTO dyu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ne bɛ i ta so, nin ye a san mugan ye. Ne ka baara kɛ i ye san tan ni naani i denmuso fla kosɔn; o kɔ, ne ka san wɔɔrɔ kɛ, ne bɛ i ta sagaw ni i ta baw kɔrɔsira. Nka i ka ne sara yɛlɛma fɔ siɲaga tan. ");
INSERT INTO dyu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ne bɛmacɛ Iburahima ta Ala, ani ne facɛ Isiyaka bɛ tagama o Ala kelen min ɲasiran na, ni o Ala tun tɛ ni ne ye, ele tun bɛna ne borolakolon le bla ka taga. Ala ka ne ta sɛgɛ le ye, ani ne ta baara; o kosɔn kunu a ka nin kiti tigɛ an fla cɛ, ka nin ko latigɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ayiwa, Laban ka Yakuba jaabi ko: «Nin musow ye ne denmusow le ye, o ta denw fana ye ne ta denw le ye. Nin bɛganw ye ne ta le ye. I ɲa bɛ fɛn o fɛn na, o bɛɛ ye ne ta le ye. Ne bɛ se ka mun le kɛ ne denmusow ni o worodenw ye bi tuun?» ");
INSERT INTO dyu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Laban ko Yakuba ma tuun ko: «Na, an ye jɛnɲɔgɔnya don, ele ni ne; o ye kɛ seereya ye ele ni ne cɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakuba ka kabakuru dɔ ta k’a lɔ, ka o kɛ hakirijigifɛn ye. ");
INSERT INTO dyu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","O kɔ, a ko a ta mɔgɔw ma ko o ye kabakuruw cɛ. O ka kabakuruw cɛ k’a ton ɲɔgɔn kan. O bɛɛ jɛnna ka domuni kɛ o kabakuruton kan. ");
INSERT INTO dyu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban ka o yɔrɔ tɔgɔ la ko Yegari Sahaduta. Yakuba k’a tɔgɔ la ko Galɛdi. ");
INSERT INTO dyu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban ko: «Nin kabakuruton ye kɛ an fla seere ye bi. O le kosɔn o yɔrɔ tɔgɔ lara ko Galɛdi.» ");
INSERT INTO dyu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Nka a yɔrɔ tɔgɔ nana la fana ko Misipa, sabu Laban ka a fɔ Yakuba ye ko: «Ni an nana fara ɲɔgɔn na, k’a kɛ ko an ɲa tɛ ɲɔgɔn na tuun, Matigi Ala ye an bɛɛ kɔrɔsi.» ");
INSERT INTO dyu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban ko Yakuba ma tuun ko: «Ni i ka ne denmusow minako juguya, ka muso wɛrɛw ta, mɔgɔ le tɛ an seere ye dɛ! I yɛrɛ kɔrɔsi, sabu Ala le ye an seere ye.» ");
INSERT INTO dyu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban k’a fɔ Yakuba ye tuun ko: «Nin kabakuruton flɛ, ani ne ka nin kabakuruba min lɔ, ele ni ne cɛ. ");
INSERT INTO dyu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ayiwa, nin kabakuruton ye an seere ye, nin kabakuruba ye an seere ye. Ne man kan ka tɛmɛ nin kabakuruton kan ka taga ele nɔ fɛ ni ŋaninyajugu ye, ele fana man kan ka tɛmɛ ni kabakuruton kan, ani nin kabakuruba kan ka na ne nɔ fɛ ni ŋaninyajugu ye. ");
INSERT INTO dyu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Iburahima ta Ala, Nahɔri ta Ala, olugu facɛ ta Ala, ale le ye kɛ an ta kititigɛbaga ye.» Yakuba fana karira Ala ra, a facɛ Isiyaka bɛ tagama Ala min ɲasiran na. ");
INSERT INTO dyu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","O kɔ, Yakuba ka bɛgan dɔ kɛ saraka ye kuru kan; a k’a ta mɔgɔw bɛɛ wele ka na, o ka domuniba kɛ; o kɔ, o sira kuru kan yi. ");
INSERT INTO dyu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","O dugusagbɛ sɔgɔmada joona fɛ, Laban wurira k’a denmusow ni a mamadenw fo, ka dugawu kɛ o ye. O kɔ, a sekɔra ka taga a ta so. ");
INSERT INTO dyu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ayiwa, Yakuba k’a ta sira ka taga; a tagatɔ, a bɛnna ni Ala ta mɛlɛkɛ dɔw ye. ");
INSERT INTO dyu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakuba ka o ye minkɛ, a ko: «Nin yɔrɔ ye Ala ta mɔgɔw ta yɔrɔ le ye.» O kosɔn a ka o yɔrɔ tɔgɔ la ko Mahanayimu. ");
INSERT INTO dyu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakuba k’a ta mɔgɔ dɔw ci a kɔrɔcɛ Esawu fɛ Seyiri jamana ra, Edɔmu mara ra. ");
INSERT INTO dyu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A k’a fɔ o ye ko: «Aw ye taga a fɔ ne matigicɛ Esawu ye ko a ta jɔncɛ Yakuba le ka aw ci; ko ne tun bɛ Laban fɛ yi, ko ne tun bɛ yi le fɔ ka na se bi ma.» ");
INSERT INTO dyu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","A ko tuun ko: «Aw ye a fɔ a ye ko misiw bɛ ne fɛ, ani faliw, ani sagaw, ani baaraden cɛmanw ni a musomanw; ko ne bɛ o fɔ ne matigicɛ ye janko a ye sabari ka ne minako ɲa.» ");
INSERT INTO dyu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ayiwa, ciradenw tagara Esawu fɛ. O sekɔra minkɛ, o nana a fɔ Yakuba ye ko: «An tagara i kɔrɔcɛ Esawu fɛ. A bɛ nana i kunbɛn ni cɛ kɛmɛ naani ye a kɔ fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kabini Yakuba ka o mɛn, a siranna fɔ k’a hakiri ɲagami. Mɔgɔ minw bɛɛ tun bɛ ni a ye, ani sagaw, ani misiw, ani ɲɔgɔmɛw, a ka o bɛɛ taran, ka o kɛ jɛnkuru fla ye. ");
INSERT INTO dyu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","A ko: «Ni Esawu nana ben jɛnkuru kelen kan, ka olugu faga, tɔw bɛna boriyɔrɔ sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","A ka Ala daari ko: «Ne bɛmacɛ Iburahima ta Ala, ne facɛ Isiyaka ta Ala, Matigi Ala, ele le k’a fɔ ne ye ko ne ye sekɔ ka na ne ta jamana ra, ne woroyɔrɔ ra, ko i bɛna baraka don ne ra. ");
INSERT INTO dyu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ayiwa, i ka koɲuman min bɛɛ kɛ ne ye, ani i ka kankelentigiya min bɛɛ kɛ i ta jɔncɛ ye, ne tun man kan ni o ye. Ne tɛmɛtɔ yan ka taga Laban fɛ, ne ka Zuridɛn ba tigɛ tuma min na, foyi tun tɛ ne boro ni ne ta bere tɛ. Nka bi ne ka ne ta mɔgɔw ni ne ta bɛganw taran ka o kɛ fɔ jɛnkuru fla. ");
INSERT INTO dyu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Sabari ka ne bɔsi ne kɔrɔcɛ Esawu boro. Sabu ne bɛ siranna, a kana na ne faga, ka ne ta musow ni o ta denw fana faga. ");
INSERT INTO dyu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Matigi Ala, ele yɛrɛ le k’a fɔ ko i bɛna baraka don ne ra, ka ne ta duruja caya i ko kɔgɔji kɛnkɛn; k’a kɛ fɔ mɔgɔ tɛna se k’a jate k’a da lɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ayiwa, Yakuba ka Ala daari ka ban minkɛ, a sira o yɔrɔ ra yi. A k’a ta bɛgan dɔw woloma ko a bɛ o sama a kɔrɔcɛ Esawu ma. ");
INSERT INTO dyu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","A ka sagajigi mugan mina, ani sagamuso kɛmɛ, bakɔrɔnin mugan, ani ba musoman kɛmɛ fla, ");
INSERT INTO dyu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ani ɲɔgɔmɛmuso bisaba ni o sinmindenw, ani misi binaani, ani misitoran tan, ani falimuso mugan, ani falicɛ tan. ");
INSERT INTO dyu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","A ka o karifa a ta baaradenw ma, o bɛɛ ni o ta bɛgankuru. A k’a fɔ o ye ko: «Aw ye bla ne ɲa, ka furancɛ dɔ to bɛgankuruw ni ɲɔgɔn cɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A k’a fɔ baaraden fɔlɔ ye ko: «Ni ne kɔrɔcɛ Esawu nana bɛn ni i ye, ni a ka i ɲininka ko: ‹Ele ye jɔn ta baaraden le ye? I bɛ tagara min le? Bɛgankuru min bɛ i ɲa o ye jɔn ta le ye?› ");
INSERT INTO dyu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ni a ka i ɲininka ten, i ye a jaabi ko: ‹I ta jɔncɛ Yakuba ta lo, a ka nin bɛganw di ko ka na a sama a matigicɛ Esawu ma. A yɛrɛ bɛ nana kɔ fɛ.› » ");
INSERT INTO dyu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Yakuba ka o kuma kelen fɔ baaraden flanan ye, ani baaraden sabanan, ani bɛgankuru dɔ tun bɛ min o min ɲa. A k’a fɔ o ye ko ni o ka bɛn ni ale matigicɛ Esawu ye, o ye o kuma le fɔ a ye. ");
INSERT INTO dyu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","A ko o ma ko: «Aw ye a fɔ a ye ko a ta jɔncɛ Yakuba yɛrɛ bɛ nana kɔ fɛ.» Yakuba tun b’a fɔra a yɛrɛ kɔnɔ ko: «Ne ka nin bɛgan minw bla ka taga ɲa, ni olugu dira a ma, a jusu bɛna suma; o ra, ni an ɲa ka na ɲɔgɔn ye, a bɛ se ka kɛ ko a bɛna ne kunbɛn ni hɛra ye.» ");
INSERT INTO dyu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ayiwa, Yakuba ka o sama bla ka taga a yɛrɛ ɲa minkɛ, a yɛrɛ tora ni a ta mɔgɔw ye o su fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","O su kelen na, Yakuba wurira k’a muso fla ta, ani a ta baaradenmuso fla, ani a ta den tan ni kelen, ka Yabɔki ba tigɛ. ");
INSERT INTO dyu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A ka ba tigɛ ni olugu ye, k’a borofɛn tɔw bɛɛ latɛmɛ fana ba kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","O kɔ, ale yɛrɛ tora a kelen. Cɛ dɔ nana siyɛn ta ni a ye fɔ ka taga dugugbɛda se. ");
INSERT INTO dyu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Cɛ k’a ye ko a tɛ se ka Yakuba ben minkɛ, a k’a bugɔ a tɔgɔkun na. Yakuba tɔgɔkun mugura. ");
INSERT INTO dyu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Cɛ ko Yakuba ma ko: «A to ne ye taga, sabu dugu bɛ gbɛra.» Yakuba ko: «Ni i ma dugawu kɛ ne ye, ne tɛ a to i ye taga dɛ!» ");
INSERT INTO dyu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Cɛ ko Yakuba ma ko: «I tɔgɔ ye di?» A ko: «Yakuba.» ");
INSERT INTO dyu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Cɛ ko: «I tɔgɔ tɛna kɛ Yakuba tuun, i tɔgɔ bɛna la ko Izirayɛli; sabu i ka siyɛn ta ni Ala ye, ka siyɛn ta ni mɔgɔw ye, ka se sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakuba k’a ɲininka ko: «Sabari ka i tɔgɔ fɔ ne ye.» Cɛ ko: «Mun na i bɛ ne tɔgɔ ɲininkara?» O wagati ra, a ka dugawu kɛ Yakuba ye. ");
INSERT INTO dyu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakuba ka o yɔrɔ tɔgɔ la ko Penuwɛli; ko sabu ale ka Ala ye ɲa ni ɲa, nka ale kisira. ");
INSERT INTO dyu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yakuba bɔra wagati min na Penuwɛli ka ba tigɛ, o y’a sɔrɔ tere bɔra ka ban. A tun bɛ tagamana ka segelen. ");
INSERT INTO dyu_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","O le kosɔn fɔ ka na se bi ma, sogobu min bɛ bɛgan tɔgɔkun na, Izirayɛli ta mɔgɔw tɛ o domu; sabu Ala ka Yakuba bugɔ o yɔrɔ le ra, a tɔgɔkun kolotuguyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ayiwa, Yakuba nana a ɲa kɔrɔta ka flɛri kɛ, ka Esawu natɔ ye ni cɛ kɛmɛ naani ye. Yakuba ka o ye minkɛ, a k’a denw taran Rasɛli ni Leya cɛ, ani baaradenmuso fla. ");
INSERT INTO dyu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","A ka baaradenmusow bla ɲa fɛ ni o ta denw ye, ka Leya ni a ta denw gban o ra, o kɔ, a ka Rasɛli ni Yusufu gban olugu kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ale yɛrɛ ka bla o bɛɛ ɲa fɛ. A k’a kinbiri gban fɔ siɲaga wolonfla, fɔ ka taga se a kɔrɔcɛ Esawu ma. ");
INSERT INTO dyu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esawu borira ka na a kunbɛn, k’a boro mini a kan na, k’a fo ni kanuya ye. O fla bɛɛ ka kɛ kasi ye. ");
INSERT INTO dyu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esawu k’a ɲa kɔrɔta ka musow ni denmisɛnw ye minkɛ, a ko: «Nin mɔgɔ minw bɛ i kɔ olugu ye jɔntigiw le ye?» Yakuba ko: «Ala ka den minw di i ta jɔncɛ ma, olugu lo.» ");
INSERT INTO dyu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Baaradenmusow gbarara, o ni o ta denw, ka na o kinbiri gban. ");
INSERT INTO dyu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya ni a ta denw gbarara fana, ka na o kinbiri gban. O kɔ fɛ, Rasɛli ni Yusufu gbarara ka na o kinbiri gban. ");
INSERT INTO dyu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esawu ko Yakuba ma ko: «Ne bɛnna ni bɛgankuru minw ye, o ye mun ta le ye?» Yakuba ko: «Ne b’a fɛ ka o di i ma janko ne ko ye diya ne matigicɛ ye.» ");
INSERT INTO dyu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esawu ko: «Ne dɔgɔcɛ, fɛn caman bɛ ne fɛ ka ban, to ni i ta bɛganw ye.» ");
INSERT INTO dyu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakuba ko: «Ɔn-ɔn, sabari! Ni a kɛra ko i yafara ne ma, sabari ka ne ta bonya mina. O le kosɔn ne nana i kunbɛn minkɛ, ne ka i ye minkɛ, a kɛra i n’a fɔ ne ɲa lara Ala yɛrɛ le kan. I fana ka ne kunbɛn ka ɲa. ");
INSERT INTO dyu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Sabari ka sɔn ka ne ta bonya mina, sabu Ala ka ne sɔn fɛn caman na, foyi ma ne dɛsɛ.» Yakuba k’a fɔ ten k’a gbɛlɛya minkɛ, a laban Esawu sɔnna. ");
INSERT INTO dyu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","O kɔ, Esawu ko: «Ayiwa, an ye taga. An ye sira mina; ne bɛ i blasira.» ");
INSERT INTO dyu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakuba ko: «Ne matigicɛ yɛrɛ k’a lɔn ko denmisɛnw ta ko ka gbɛlɛn; sagadenw fana bɛ ne fɛ, misiden dɔw bɛ sin na. Ni an ka tagama lateliya ka tɛmɛ o baraka kan lon kelen dɔrɔn, bɛganw bɛɛ bɛna sa. ");
INSERT INTO dyu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","O ra ne matigicɛ ye bla a ta jɔncɛ ɲa. Ne bɛna to ka taga dɔɔnin dɔɔnin, ka gban bɛganw kɔ, ani denmisɛnw, fɔ ka taga se ne matigicɛ fɛ Seyiri mara ra.» ");
INSERT INTO dyu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawu ko: «O tuma ne bɛna ne ta mɔgɔ dɔw to ni i ye.» Yakuba ko: «O kɛkun ye mun ye sa? Ni ne ko diyara ne matigicɛ ye ka ban, o bɛ ne wasa.» ");
INSERT INTO dyu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ayiwa, o lon yɛrɛ, Esawu ka sira ta ka taga Seyiri mara ra. ");
INSERT INTO dyu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakuba tagara Sukɔti. A k’a ta fanibon lɔ yi, ka wɛrɛ dɔw lɔ a ta bɛganw ye. O le kosɔn o ka o yɔrɔ tɔgɔ la ko Sukɔti. ");
INSERT INTO dyu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakuba bɔra Mesopotami, a ni hɛra tagara se fɔ Sikɛmu, Kanaana jamana ra. A k’a ta fanibonw lɔ dugu ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A tun k’a ta fanibonw lɔ yɔrɔ min na, a nana o yɔrɔ san Hamɔri ta mɔgɔw fɛ warigbɛ kɛmɛ. Hamɔri le ka Sikɛmu dugu sigi. ");
INSERT INTO dyu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yakuba ka sarakabɔnan dɔ lɔ o yɔrɔ ra, ka o tɔgɔ la ko Ɛli Elowe Izirayɛli. ");
INSERT INTO dyu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ayiwa, Leya tun ka denmuso min woro Yakuba ye, ni a tɔgɔ ye ko Dina, lon dɔ, ale le nana bɔ ko a bɛ taga a sunguru ɲɔgɔnw fɛ dugu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Jamanatigi Hamɔri Hevikacɛ, ale dencɛ min tɔgɔ ye ko Sikɛmu, o ka Dina ye. A k’a mina ka jɛn ni a ye fanga ra, k’a lanɔgɔ. ");
INSERT INTO dyu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ayiwa, Yakuba denmuso Dina ko diyara Sikɛmu ye; a k’a kanu. A kumana a fɛ, ka cogo bɛɛ kɛ janko ale ye a sɔrɔ k’a kɛ a muso ye. ");
INSERT INTO dyu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","A ma na ɲa, Sikɛmu tagara a fɔ a facɛ Hamɔri ye ko a ye Dina daari k’a di ale ma, a bɛ kɛ a muso ye. ");
INSERT INTO dyu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ayiwa, Yakuba nana a mɛn ko Sikɛmu k’a denmuso Dina mina ka la ni a ye fanga ra k’a lanɔgɔ; nka i n’a fɔ Yakuba dencɛw tun bɛ ni bɛganw ye kongo ra, a jera o ko kan fɔ ka na a to o ye na ka bɔ kongo ra. ");
INSERT INTO dyu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamɔri ni a dencɛ Sikɛmu tagara Yakuba fɛ ka taga kuma a fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yakuba dencɛw nana ka bɔ kongo ra, o ka o ko mɛn. O k’a mɛn minkɛ, a digira o ra, o dimina kosɛbɛ, sabu Sikɛmu tun ka maroyakoba le kɛ Izirayɛlimɔgɔw cɛ ra; a lara ni o dɔgɔmuso Dina ye, k’a sɔrɔ o tun man kan ka kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamɔri tagara kuma Yakuba dencɛw fɛ; a k’a fɔ o ye ko: «Aw denmuso ko diyara ne dencɛ Sikɛmu ye. Ne bɛ aw daari aw ye a di a ma a ye kɛ a muso ye. ");
INSERT INTO dyu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Aw ye jɛnɲɔgɔnya don ni an ye; aw bɛna aw denmusow di an ma furu ra, ka an taw fana ta ka o kɛ aw ta musow ye. ");
INSERT INTO dyu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Aw bɛna sigi ni anw ye yan. Jamana bɛ labla aw ye, ni min ka aw diya aw bɛ o kɛ. Aw bɛ to yan ka jago kɛ, ka dugukolo dɔw san aw yɛrɛ ye.» ");
INSERT INTO dyu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sikɛmu fana k’a fɔ Dina facɛ ni a balemaw ye ko: «Aw ye sɔn ka nin kelen kɛ ne ye. Ni aw ka fɛn o fɛn ɲini ne fɛ, ne bɛna o di. ");
INSERT INTO dyu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ni a ka aw diya, aw ye furunaforoba dɔ fɔ, ani wari caman; ne bɛna o bɛɛ di aw ma, janko aw ye muso di ne ma dɔrɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yakuba dencɛw ka Sikɛmu ni a facɛ Hamɔri jaabi ni janfa kumaw le ye, sabu Sikɛmu ka o balemamuso Dina lanɔgɔ minkɛ, o ma diya o ye. ");
INSERT INTO dyu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","O ko Hamɔri ni Sikɛmu ma ko: «Ka an dɔgɔmuso di cɛ kɛnɛsigibari ma, o ye ko dɔ le ye an tɛ se ka min kɛ. O ye maroya le ye an fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Aw ka min fɔ, an tɛ se ka sɔn o ma, fɔ aw ye kɛ i ko anw; o kɔrɔ ye ko aw ra cɛdenw bɛɛ ka kan ka kɛnɛsigi. ");
INSERT INTO dyu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ayiwa, ni aw sɔnna o ma, o tuma ra an bɛna an denmusow di aw ma, an fana bɛna aw taw ta. An bɛna sigi aw fɛ, an bɛɛ bɛna kɛ mɔgɔ kelen ye. ");
INSERT INTO dyu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Nka ni aw ma sɔn an ta kuma ma, ka kɛnɛsigi, o tuma an bɛna an denmuso ta ka taga ni a ye.» ");
INSERT INTO dyu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ayiwa, o kuma bɛnna Hamɔri ni a dencɛ Sikɛmu ma. ");
INSERT INTO dyu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sikɛmu ka o ko mina a sɔbɛ ra, sabu Yakuba denmuso ko tun ka diya a ye. O ta so kɔnɔ, mɔgɔ bɛɛ fana tun bɛ Sikɛmu jatera. ");
INSERT INTO dyu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamɔri ni a dencɛ Sikɛmu tagara dugu donda* ra, ka taga kuma dugumɔgɔw fɛ. O ko: ");
INSERT INTO dyu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Nin mɔgɔw nana ni ŋaninyaɲuman le ye an fɛ. An ye a to o ye sigi an ta jamana ra, ka jago kɛ; an ta jamana ka bon, o sigiyɔrɔ tɛna fɔn. An bɛna o denmusow furu, an fana bɛna an taw di o ma. ");
INSERT INTO dyu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nka ni an ta cɛw bɛɛ kelen kelen ma kɛnɛsigi i n’a fɔ olugu k’a kɛ cogo min na, o tɛna sɔn ka sigi ni an ye, an ye kɛ mɔgɔ kelen ye. ");
INSERT INTO dyu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ni o sigira an fɛ, o ta bɛganw, ni o borofɛnw, ni o ta misiw bɛɛ tɛna kɛ an ta ye wa? O ka min fɔ an ye sɔn o ma, janko o ye to ni an ye.» ");
INSERT INTO dyu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Dugumɔgɔ minw bɛɛ tun bɛ dugu donda ra, o bɛɛ sɔnna Hamɔri ni a dencɛ Sikɛmu ta kuma ma. Min o min tun nana dugu donda ra, olugu bɛɛ kɛnɛsigira. ");
INSERT INTO dyu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ayiwa, o kɛnɛsiginin tere sabanan, ka jori dimi to o kan, Yakuba dencɛ fla, Simeyɔn ni Levi, Dina kɔrɔcɛw, olugu ka o ta muruw ta ka taga ben dugumɔgɔw kan, ka cɛw bɛɛ faga, k’a sɔrɔ dugumɔgɔw tun m’a lɔn ko o ko ɲɔgɔn bɛna se o ma. ");
INSERT INTO dyu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","O ka Hamɔri ni a dencɛ Sikɛmu fana faga, ka o dɔgɔmuso Dina labɔ Sikɛmu ta bon kɔnɔ ka taga ni a ye. ");
INSERT INTO dyu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yakuba dencɛ tɔw ka suw ta fɛnw bɛɛ bɔ o ra, ka dugumɔgɔw ta fɛnw bɛɛ cɛ, sabu Sikɛmu tun ka o dɔgɔmuso lanɔgɔ. ");
INSERT INTO dyu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","O ka o ta bɛganw ta, ani o ta misiw, ani o ta faliw; fɛn o fɛn tun bɛ dugu kɔnɔ, ani fɛn o fɛn tun bɛ forow ra, o ka o bɛɛ ta. ");
INSERT INTO dyu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","O ka o ta naforo bɛɛ cɛ, ani o ta denw, ani o ta musow, ani fɛn o fɛn tun bɛ o ta so kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakuba ko Simeyɔn ni Levi ma ko: «Aw ka ne hakiri ɲagami, sabu aw bɛna ne ko gboya jamana mɔgɔw ye, Kanaanakaw, ani Perezikaw. Ne ta mɔgɔw man ca; o bɛna lajɛn ne kama, ka ne ni ne ta somɔgɔw bɛɛ faga ka ban.» ");
INSERT INTO dyu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yakuba dencɛw k’a jaabi ko: «Mun kosɔn o ka an dɔgɔmuso kɛ i ko jatɔmuso?» ");
INSERT INTO dyu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ayiwa, lon dɔ, Ala kumana Yakuba fɛ, ko: «Wuri ka taga Betɛli, ka taga sigi o yɔrɔ ra; ni i sera yi, i bɛ sarakabɔnan dɔ lɔ ne ye, ne Ala min ka ne yɛrɛ yira i ra, i boritɔ i kɔrɔcɛ Esawu ɲa.» ");
INSERT INTO dyu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yakuba kumana a ta somɔgɔw fɛ, ani a nɔfɛmɔgɔw bɛɛ; a ko: «Batofɛn wɛrɛ minw bɛ aw fɛ, aw ye o bɛɛ labɔ yan. Aw ye aw yɛrɛ saninya, ka fani wɛrɛ don aw yɛrɛ ra; ");
INSERT INTO dyu_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","sabu an bɛna wuri ka taga Betɛli, ne bɛ taga sarakabɔnan dɔ lɔ Ala ye, Ala min ka ne ta daariri lamɛn ka ne dɛmɛ ne ta sɛgɛ wagati ra, ani ka to ne fɛ ne ta tagama ra.» ");
INSERT INTO dyu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Batofɛn wɛrɛ minw tun bɛ Yakuba ta mɔgɔw fɛ, o ka o bɛɛ bɔ ka o di Yakuba ma, ani tororanɛgɛ minw tun bɛ o torow ra. Yirisunba min bɛ Sikɛmu dugu kɔrɔ, Yakuba ka dinga sogi ka o dogo o yirisunba jukɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","O kɔ, o wurira ka taga. Ala ka siranyaba bla o yɔrɔ dugumɔgɔw bɛɛ ra. O si ma sɔn ka gban Yakuba ta mɔgɔw kɔ, ko o bɛ o kɛrɛ. ");
INSERT INTO dyu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakuba ni a nɔfɛmɔgɔw bɛɛ tagara se Luzi; o dugu tɔgɔ le ye fana ko Betɛli, a bɛ Kanaana jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakuba ka sarakabɔnan dɔ lɔ o yɔrɔ ra, ka o tɔgɔ la ko: Ɛli Betɛli; ko sabu Ala k’a yɛrɛ yira ale ra o yɔrɔ ra, tuma min na ale tun bɛ borira a kɔrɔcɛ ɲa. ");
INSERT INTO dyu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ayiwa, Rebeka ta lamɔbamuso min tun ye Debora ye, o sara. O k’a su don Betɛli kɔrɔ, yirisunba dɔ kɔrɔ, o yirisunba tɔgɔ le nana la ko kasi yirisunba. ");
INSERT INTO dyu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ala k’a yɛrɛ yira Yakuba ra tuun, ka baraka don a ra, a nanin kɔ ka bɔ Mesopotami jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ala ko a ma ko: «I tɔgɔ ye ko Yakuba, nka i tɔgɔ tɛna kɛ Yakuba ye tuun. I tɔgɔ bɛna la ko Izirayɛli.» Ala ka Yakuba tɔgɔ la ko Izirayɛli o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ala k’a fɔ a ye tuun ko: «Ne le ye Ala Sebɛɛtigi ye. I bɛna den caman sɔrɔ; siya dɔ bɛna bɔ i ra, ani jamana caman mɔgɔw. Masaw bɛna bɔ i ta duruja ra. ");
INSERT INTO dyu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ne ka jamana min di Iburahima ni Isiyaka ma, ne bɛna o jamana di i ma. I ta den minw bɛna na i kɔ fɛ, ne bɛna a di olugu fana ma.» ");
INSERT INTO dyu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ayiwa, Ala kumana Yakuba fɛ yɔrɔ min na, a bɔra a kɔrɔ o yɔrɔ ra ka taga. ");
INSERT INTO dyu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ala tun kumana ni Yakuba ye yɔrɔ min na, Yakuba ka kabakuruba dɔ lɔ o yɔrɔ ra k’a kɛ hakirijigifɛn ye, ka rɛzɛnji kɛ saraka ye ka o bɔn a kan, ani turu. ");
INSERT INTO dyu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ala kumana a fɛ yɔrɔ min na, Yakuba ka o yɔrɔ tɔgɔ la ko Betɛli. ");
INSERT INTO dyu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ayiwa, Yakuba ni a ta mɔgɔw nana bɔ Betɛli ka taga yɔrɔ wɛrɛ. O ni Efirata dugu cɛ belen tun ka jan dɔɔnin. Rasɛli jigira o yɔrɔ ra, nka a jigiko gbɛlɛyara kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ka tin dimi to a ra, tinminamuso ko a ma ko: «I kana siran, i ka dencɛ wɛrɛ sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ayiwa, o y’a sɔrɔ Rasɛli tun bɛ ɲini ka sa ka ban. K’a satɔ to, a ka den tɔgɔ la ko: Bɛni Ɔni; nka kɔ fɛ facɛman nana den tɔgɔ la ko: Boniyaminu. ");
INSERT INTO dyu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ayiwa, Rasɛli sara o yɔrɔ le ra. O k’a su don Efirata dugu sira ra. Efirata dugu tɔgɔ le nana la ko Bɛtilɛhɛmu. ");
INSERT INTO dyu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakuba ka kabakuruba dɔ lɔ Rasɛli ta kaburu kunna, ka o kɛ hakirijigifɛn ye. O kabakuru le kɛra Rasɛli ta kaburu hakirijigifɛn ye. A bɛ yi hali bi. ");
INSERT INTO dyu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Yakuba bɔra o yɔrɔ ra minkɛ, a tagara a ta fanibonw lɔ, fɔ ka taga tɛmɛ Migidali Edɛri yɔrɔ kan. ");
INSERT INTO dyu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ayiwa, ka Yakuba to o yɔrɔ ra, Rubɛn tagara jɛn ni Bila ye, min tun ye a facɛ ta jɔnmuso dɔ ye; Yakuba bɔra o ko kala ma. Yakuba dencɛw tun ye cɛ tan ni fla: ");
INSERT INTO dyu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya dencɛw flɛ nin ye: a ka dencɛ fɔlɔ min woro Yakuba ye, o ye Rubɛn ye, o kɔ, Simeyɔn, ani Levi, ani Zuda, ani Isakari, ani Zabulɔn. ");
INSERT INTO dyu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rasɛli dencɛw tun ye Yusufu ni Boniyaminu ye. ");
INSERT INTO dyu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rasɛli ta baaradenmuso Bila dencɛw tun ye Dan ni Nɛfitali ye. ");
INSERT INTO dyu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leya ta baaradenmuso Zilipa dencɛw tun ye Gadi ni Asɛri ye. Olugu le ye Yakuba dencɛw ye, minw worora Mesopotami. ");
INSERT INTO dyu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ayiwa, Yakuba tagara se a facɛ Isiyaka kɔrɔ Mamire ta yɔrɔ ra, Kiriyati Araba dugu kɔrɔ; o dugu le ye Heburɔn ye fana. Iburahima ni Isiyaka tun sigira o dugu le ra. ");
INSERT INTO dyu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isiyaka si bɛɛ lajɛnnin kɛra san kɛmɛ ni san biseegi. ");
INSERT INTO dyu_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","O kɔ, a sara, ka fara a bɛmacɛ tɔw kan. A tun kɔrɔra kosɛbɛ fɔ ka sijan sɔrɔ. A dencɛw Esawu ni Yakuba k’a su don. ");
INSERT INTO dyu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esawu ta denw ye nin ye; ale le bɛ wele fana ko Edɔmu. ");
INSERT INTO dyu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu k’a ta musow ta Kanaanaka sunguruw le ra. A muso dɔ tɔgɔ tun ye ko Ada; ale tun ye Hɛtikacɛ Elɔn denmuso le ye. Dɔ tɔgɔ tun ye ko Olibama; ale tun ye Ana denmuso ye; Ana yɛrɛ facɛ tun ye Sibeyɔn ye. Sibeyɔn tun ye Hevika le ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esawu muso sabanan kɛra Basimati ye. Ale tun ye Sumayila denmuso dɔ ye. Nebayɔti dɔgɔmuso tun lo. ");
INSERT INTO dyu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esawu muso Ada ka Elifazi woro Esawu fɛ. A muso Basimati ka Rewɛli woro. ");
INSERT INTO dyu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Olibama ka Yehusi woro, ani Yalamu, ani Kore. Olugu le ye Esawu dencɛw ye, minw worora a fɛ Kanaana jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ayiwa, lon dɔ, Esawu k’a ta musow ta, ani a dencɛw, ani a denmusow, ani a ta somɔgɔw bɛɛ, ani a ta sagaw ni a ta baw, ani a ta misiw bɛɛ, ani a tun ka fɛn o fɛn sɔrɔ Kanaana jamana ra; a wurira ka taga jamana wɛrɛ ra, yɔrɔjan, ka bɔ a dɔgɔcɛ Yakuba kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","O fla borofɛnw caya kosɔn, o tun tɛ se ka to ɲɔgɔn kan. Yɔrɔ tun ka dɔgɔ o ta bɛganw ma. ");
INSERT INTO dyu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","O le kɛra sababu ye k’a to Esawu tagara sigi Seyiri kuruyɔrɔw ra. Esawu le bɛ wele fana ko Edɔmu. ");
INSERT INTO dyu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ayiwa, Esawu le ye Edɔmukaw bɛmacɛ ye. A ta durujaw ye nin ye, k’a siginin to Seyiri kuruyɔrɔw ra: ");
INSERT INTO dyu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esawu dencɛw tɔgɔw ye nin ye: Elifazi, ale ye Esawu ta muso Ada dencɛ ye; Rewɛli, o ye Esawu ta muso Basimati dencɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazi yɛrɛ ta denw kɛra Teman ye, ani Omaru, ani Sefo, ani Getamu, ani Kenazi. ");
INSERT INTO dyu_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Esawu dencɛ Elifazi tun ka jɔnmuso min kɛ a muso ye, min tun ye Timina ye, ale le ka Amalɛki woro Elifazi ye. Olugu le ye Esawu ta muso Ada mamadenw ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Rewɛli dencɛw flɛ nin ye: Nahati, ani Zeraki, ani Sama, ani Miza. Olugu le ye Esawu ta muso Basimati mamadenw ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esawu ta muso Olibama, Sibeyɔn denmuso Ana ta denmuso, ale ka dencɛ minw woro Esawu fɛ, olugu flɛ nin ye: Yehusi, ani Yalamu, ani Kore. ");
INSERT INTO dyu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ayiwa, Esawu dencɛ minw kɛra kuntigiw ye, olugu ye nin ye: Esawu dencɛ fɔlɔ Elifazi dencɛw ra, minw kɛra kuntigiw ye, o ye Teman, ani Omaru, ani Sefo, ani Kenazi, ");
INSERT INTO dyu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ani Kore, ani Getamu, ani Amalɛki. Olugu le ye Elifazi dencɛw ye, minw kɛra kuntigiw ye Edɔmu jamana ra. Olugu le ye Esawu ta muso Ada mamadenw ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esawu dencɛ Rewɛli dencɛ minw kɛra kuntigiw ye, olugu flɛ nin ye: Nahati kɛra gbatigi ye, ani Zeraki, ani Sama, ani Miza. Olugu le ye Rewɛli dencɛw ye, minw kɛra kuntigiw ye Edɔmu jamana ra. Olugu le ye Esawu ta muso Basimati mamadenw ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esawu ta muso Olibama dencɛ minw kɛra kuntigiw ye, olugu flɛ nin ye: Yehusi kɛra gbatigi ye, ani Yalamu, ani Kore. Olugu le ye Esawu ta muso Olibama, Ana denmuso dencɛw ye, minw kɛra kuntigiw ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ayiwa, olugu le ye Esawu dencɛw ye, ani o ta kuntigiw. Olugu le ye Edɔmukaw ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ayiwa, mɔgɔ minw kɔnna ka sigi Edɔmu jamana ra, o ye Seyiri dencɛw le ye. Ale tun ye Hɔrika ye. A dencɛw tun ye Lotan ye, ani Sobali, ani Sibeyɔn, ani Ana, ");
INSERT INTO dyu_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ani Disɔn, ani Esɛri, ani Disan. Hɔrikaw ta kuntigiw le ye olugu ye. Seyiri dencɛw lo; o tun siginin bɛ Edɔmu jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan dencɛw tun ye Hɔri ni Hemamu ye. Lotan balemamuso tun ye Timina ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobali dencɛw flɛ nin ye: Aliban ni Manati, ani Ebali, ani Sefo, ani Onamu. ");
INSERT INTO dyu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeyɔn dencɛw flɛ nin ye: Aya, ani Ana. Lon dɔ, o Ana tɔgɔ le tagara bɔ bununji gbanninman dɔ kan kongo kɔnɔ, k’a to a bɛ a facɛ Sibeyɔn ta faliw kɔrɔsira. ");
INSERT INTO dyu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana dencɛ tun ye Disɔn ye; a denmuso tun ye Olibama ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disɔn dencɛw flɛ nin ye: Hemedan, ani Ɛsiban, ani Itiran, ani Keran. ");
INSERT INTO dyu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esɛri dencɛw tun ye Bilan, ani Zavan, ani Akan ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan dencɛw tun ye Usi ye, ani Aran. ");
INSERT INTO dyu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hɔrikaw ta kuntigiw flɛ nin ye: Lotan, ani Sobali, ani Sibeyɔn, ani Ana, ");
INSERT INTO dyu_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ani Disɔn, ani Esɛri, ani Disan. Olugu le ye Hɔrikaw ta kuntigiw ye Seyiri ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Sani masacɛ dɔ ye sigi Izirayɛlimɔgɔw kunna, masacɛ minw sigira Edɔmu mara kunna, olugu flɛ nin ye: ");
INSERT INTO dyu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Behɔri dencɛ Bela, ale sigira masaya ra Edɔmu; a ta dugu tɔgɔ tun ye ko Dinaba. ");
INSERT INTO dyu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela nana sa minkɛ, Zera dencɛ Yobabu, min bɛ bɔ Bɔsira, ale sigira a nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu nana sa minkɛ, Husamu sigira a nɔ ra; ale tun bɔra Temankaw ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husamu nana sa minkɛ, Bedadi dencɛ Hadadi sigira a nɔ ra; ale le ka Madiyankaw kɛrɛ ka se o ra Mohabu mara ra. A ta dugu tɔgɔ tun ye ko Aviti. ");
INSERT INTO dyu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi nana sa minkɛ, Samula min tun bɛ bɔ Masireka, ale sigira a nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula nana sa minkɛ, Sawuli min tun bɛ bɔ Rehobɔti, bada ra, ale sigira a nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawuli nana sa minkɛ, Akibɔri dencɛ Bahali Hanani sigira a nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akibɔri dencɛ Bahali Hanani nana sa minkɛ, Hadari sigira a nɔ ra; a ta dugu tɔgɔ tun ye Pawu. A muso tɔgɔ tun ye ko Metabɛli; Metabɛli tun ye Matɛrɛdi denmuso ye, Matɛrɛdi tun ye Mezahabu denmuso ye. ");
INSERT INTO dyu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ayiwa, kuntigi minw bɔra Esawu dencɛw ra ka kaɲa ni o ta gbaw, ani o ta sigiyɔrɔw, ani o tɔgɔw ye, o kuntigiw flɛ nin ye: Timina, ani Aliva, ani Yetɛti, ");
INSERT INTO dyu_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ani Olibama, ani Ela, ani Pinɔn, ");
INSERT INTO dyu_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ani Kenazi, ani Teman, ani Mibisari, ");
INSERT INTO dyu_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ani Magidiyɛli, ani Iramu. Olugu le kɛra Edɔmu mara kuntigiw ye; o bɛɛ sigira o ta mara ra. Esawu le kɛra o Edɔmukaw bɛmacɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ayiwa, Yakuba sigira Kanaana jamana ra. A facɛ fana tun sigira o jamana le ra. ");
INSERT INTO dyu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yakuba dencɛw ta kow flɛ nin ye. Ka Yusufu si to san tan ni wolonfla, a tun bɛ sagaw ni baw gbɛnna ni a kɔrɔcɛw ye. A tun bɛ ni a facɛ ta jɔnmuso Bila ni Zilipa dencɛw le ye. Olugu tun bɛ ko bɛnbari minw kɛ, Yusufu tun bɛna o bɛɛ lakari a facɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yusufu ko le tun ka di Yakuba ye ka tɛmɛ a ta den tɔw bɛɛ kan, sabu a tun ka Yusufu sɔrɔ k’a kɔrɔnin to; o kosɔn Yakuba tun ka forokiya ɲumannin ɲɛgɛnɲɛgɛnman dɔ karan Yusufu ye. ");
INSERT INTO dyu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yusufu kɔrɔcɛw k’a ye ko o facɛ bɛ Yusufu le kanuna ka tɛmɛ olugu kan minkɛ, o ka Yusufu kɔninya; hali kumaɲuman yɛrɛ tun tɛ se ka bɔ o da ra k’a fɔ Yusufu ye tuun. ");
INSERT INTO dyu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Lon dɔ, Yusufu nana siko dɔ kɛ; a ka o lakari a kɔrɔcɛw ye minkɛ, o ka dɔ fara o ta kɔninya kan. ");
INSERT INTO dyu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","A k’a fɔ o ye ko: «Aw ye sabari ka ne ta siko lamɛn! ");
INSERT INTO dyu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ne sikora k’a ye ko an tun bɛ foro ra, an bɛ siman tigɛra k’a siri. Ne ta simansiri nana wuri ka lɔ, aw ta simansiriw nana ne ta lamini ka biribiri a kɔrɔ k’a kɛ i n’a fɔ o bɛ a bonyara.» ");
INSERT INTO dyu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yusufu kɔrɔcɛw ko: «O tuma ele bɛ a miiri ko ele le bɛna sigi an kunna ka kɛ an ta masacɛ ye kɛ.» O k’a kɔninya tuun o siko kosɔn, ani o kumaw kosɔn. ");
INSERT INTO dyu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ayiwa, Yusufu nana siko dɔ wɛrɛ kɛ; a ka o fana fɔ a kɔrɔcɛw ye. A ko: «Ne ka siko dɔ wɛrɛ kɛ tuun; ne ka tere ni karo ni lolo tan ni kelen ye, o nana o yɛrɛ majigi ne kɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A ka o siko fɔ a facɛ ni a kɔrɔcɛw ye. A facɛ sɔngɔra a ra, k’a fɔ a ye ko: «Nin siko kɔrɔ le ye di? O tuma i b’a fɛ ne ni i bamuso ni i kɔrɔcɛw, an bɛɛ le ye na an kinbiri gban ele kɔrɔ kɛ?» ");
INSERT INTO dyu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","A ɲangboya donna a kɔrɔcɛw ra; nka a facɛ ka o kumaw to a yɛrɛ kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ayiwa, Yusufu kɔrɔcɛw tun tagara Sikɛmu ni o facɛ ta bɛganw ye. ");
INSERT INTO dyu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Lon dɔ, Yusufu facɛ Yakuba ko a ma ko: «I kɔrɔcɛw tagara ni bɛganw ye Sikɛmu; na, ne bɛ i ci o fɛ.» Yusufu nana. ");
INSERT INTO dyu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yakuba ko: «Taga a flɛ, ni i kɔrɔcɛw ka kɛnɛ, ani ni foyi tɛ bɛganw na; i ye na o kibaroya fɔ ne ye.» A ka Yusufu ci ka taga. A bɔra Heburɔn kɛnɛgbɛyɔrɔ ra ka taga Sikɛmu. ");
INSERT INTO dyu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ayiwa, cɛ dɔ tagara bɛn ni Yusufu yaalayaalatɔ ye kongo kɔnɔ. A k’a ɲininka ko: «Ele bɛ mun le ɲinina?» ");
INSERT INTO dyu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufu ko: «Ne bɛ ne kɔrɔcɛw le yɔrɔ ɲinina. O bɛ min le? Sabari ka o yɔrɔ yira ne ra.» ");
INSERT INTO dyu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Cɛ ko: «O bɔra yan; sabu ne tun k’a mɛn o fɛ ko o bɛ taga Dotan.» Yusufu tagara o kɔ ka taga o sɔrɔ Dotan. ");
INSERT INTO dyu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","A kɔrɔcɛw k’a ye yɔrɔjan a bɛ nana. Sani a ye se o ma, o ka janfa siri a kama ko o b’a faga. ");
INSERT INTO dyu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","O ko: «An ta sikobagawara natɔ ye nin ye. ");
INSERT INTO dyu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Aw ye na an ye a faga, k’a firi kɔlɔnkolon dɔ kɔnɔ. An bɛ taga a fɔ ko wara dɔ le k’a faga k’a domu. A ta sikow bɛna kɛ min ye, an bɛna o ye.» ");
INSERT INTO dyu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubɛn ka o kuma mɛn minkɛ, ale tun b’a fɛ ka Yusufu kisi ka bɔ o boro; a ko: «An kana a to a ye sa.» ");
INSERT INTO dyu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rubɛn k’a fɔ tuun ko: «Aw kana a faga; aw ye a firi kɔlɔnkolon kɔnɔ, kongo kɔnɔ yan; aw kana aw boro se a ma.» Rubɛn tun b’a fɛ ka na Yusufu labɔ dogo ra o kɔ fɛ, ka sekɔ ni a ye ka taga a di a facɛ ma. ");
INSERT INTO dyu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ayiwa, Yusufu nana se o kɔrɔ minkɛ, o k’a ta forokiya ɲumannin ɲɛgɛnɲɛgɛnman sama ka bɔ a kan na. ");
INSERT INTO dyu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","O k’a mina k’a firi kɔlɔnkolon kɔnɔ. Ji foyi tun tɛ kɔlɔn kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","O kɔ, o sigira ka domuni kɛ. O nana flɛri kɛ, ka Sumayila ta mɔgɔ dɔw natɔ ye ni o ta ɲɔgɔmɛw ye ka bɔ Galadi. Wusunanw, ani kasadiyananw, ani latikɔlɔn tun bɛ o ta doniw na ɲɔgɔmɛw kɔ ra. O tun bɛ tagara ni o ye Misiran. ");
INSERT INTO dyu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","O ra, Zuda k’a fɔ a balemaw ye ko: «Ni an ka an dɔgɔnin faga k’a dogo, o bɛna mun le ɲa an ye? ");
INSERT INTO dyu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Aw y’a to an y’a fiyeere Sumayila ta mɔgɔw ma. An kana an boro se a ma k’a faga, sabu an dɔgɔnin lo, an yɛrɛ dɔ lo.» A balema tɔw sɔnna a ta kuma ma. ");
INSERT INTO dyu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Madiyanka jagokɛbagaw, Sumayila ta mɔgɔw, olugu tɛmɛtɔ, o ka Yusufu sama k’a labɔ kɔlɔn kɔnɔ, k’a fiyeere olugu ma warigbɛ mugan. Sumayila ta mɔgɔw k’a san ka taga ni a ye Misiran. ");
INSERT INTO dyu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ayiwa, Rubɛn sekɔra ka na kɔlɔnda ra, ko a bɛna Yusufu labɔ. A nana a ye ko Yusufu tɛ kɔlɔn kɔnɔ tuun. A jusu kasira, fɔ a k’a ta derege mina k’a faran. ");
INSERT INTO dyu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","A nana a dɔgɔcɛw fɛ ka na a fɔ o ye ko: «E! Den tɛ kɔlɔn kɔnɔ tuun! Ne bɛna taga min ni nin ko ye?» ");
INSERT INTO dyu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","O ka Yusufu ta forokiyanin ta, ka bakɔrɔnin dɔ faga, ka forokiyanin don o jori ra. ");
INSERT INTO dyu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","O kɔ, o ka Yusufu ta forokiyanin bla ka taga a di a facɛ ma k’a fɔ a ye ko: «An ka forokiya nin ye kongo kɔnɔ; a flɛ ni a kɛra i dencɛ ta forokiya lo walama ni o tɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakuba k’a flɛ, k’a ye ko a dencɛ ta derege lo. A ko: «E! Ne dencɛ ta derege lo; wara dɔ le k’a domu. E! Wara dɔ le ka Yusufu tigɛtigɛ tan!» ");
INSERT INTO dyu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakuba k’a ta derege mina k’a faran, ka bɔrɔ dɔ don a yɛrɛ ra, ka kasi a dencɛ saya ko ra tere caman. ");
INSERT INTO dyu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A dencɛw ni a denmusow nana ko o bɛna a jusu saaro, nka a tun t’a fɛ mɔgɔ si ye a jusu saaro. A tun b’a fɔra ko: «Ne bɛna to kasi le ra fɔ ka na sa ka taga lahara ne dencɛ nɔ fɛ.» A tora ka kasi. ");
INSERT INTO dyu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ayiwa, Madiyanka jagokɛbagaw tagara Yusufu fiyeere Misiran, Farawona ta sorasiw kuntigiba ma; o tɔgɔ ye ko Potifari. ");
INSERT INTO dyu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ayiwa, wagati dɔ nana kɛ, Zuda bɔra a balemaw kɔrɔ, ka taga sigi Adulamu, cɛ dɔ kɔrɔ, o cɛ tɔgɔ ye ko Hira. ");
INSERT INTO dyu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Zuda ka Kanaanaka sunguru dɔ ye o dugu ra, a facɛ tɔgɔ ye ko Suwa. A ka o sunguru furu, ka jɛn ni a ye. ");
INSERT INTO dyu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Muso nana kɔnɔ ta, ka dencɛ woro. A ka den tɔgɔ la ko Ɛri. ");
INSERT INTO dyu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","A nana kɔnɔ wɛrɛ ta, ka dencɛ wɛrɛ woro. A ka o tɔgɔ la ko Onan. ");
INSERT INTO dyu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","A nana kɔnɔ wɛrɛ ta tuun ka dencɛ wɛrɛ woro. A ka o tɔgɔ la ko Sela. O den worotuma ra, Zuda tun bɛ Kesibu dugu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ayiwa, Zuda nana muso dɔ furu ka o di a dencɛ fɔlɔ Ɛri ma. O muso tɔgɔ tun ye ko Tamari. ");
INSERT INTO dyu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Nka Zuda dencɛ fɔlɔ kɛra mɔgɔjugu ye Matigi Ala ɲa kɔrɔ; o kosɔn, Matigi Ala ka saya lase a ma. ");
INSERT INTO dyu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Zuda k’a fɔ a dencɛ flanan Onan ye ko: «I kɔrɔcɛ muso ta ka jɛn ni a ye, sabu i nimɔgɔmuso lo; janko i ye den sɔrɔ ni a ye i kɔrɔcɛ nɔ ra, ka duruja to i kɔrɔcɛ kɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ayiwa, Onan k’a ye ko o den tɛna kɛ ale yɛrɛ ta ye; o ra, ni a tun bɛ jɛn ni a ninmɔgɔmuso ye, a tun bɛ lawa bɔn dugu ma, janko muso kana kɔnɔ ta ka duruja to a kɔrɔcɛ kɔ. ");
INSERT INTO dyu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan tun bɛ min kɛra, o ma diya Matigi Ala ye. Ala ka saya lase ale fana ma. ");
INSERT INTO dyu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Zuda k’a ye ten minkɛ, a ko Tamari ma ko: «I kana cɛ wɛrɛ ta; taga to i facɛ ta so, sani k’a to ne dencɛ Sela ye ɲanatigɛ. Ni a ka ɲanatigɛ, ne bɛna i di ale ma.» Zuda ka o fɔ, sabu a tun bɛ siranna; a tun t’a fɛ Sela ye Tamari furu janko ale fana kana na sa i n’a fɔ a kɔrɔcɛ tɔw. Tamari tagara to a facɛ ta so. ");
INSERT INTO dyu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Wagati dama tɛmɛnin kɔ, Zuda ta muso sara. O muso tun ye Suwa denmuso le ye. Sangakow nana nɔgɔya minkɛ, ani Zuda jusu sumana tuma min na, Zuda tagara a ta sagasikanbagaw fɛ Timina dugu kɔnɔ, a ni a tericɛ Hira, min bɛ bɔ Adulamu. ");
INSERT INTO dyu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ayiwa, dɔ nana a fɔ Tamari ye ko a burancɛ Zuda bɛ tagara Timina, ka taga a ta sagaw si kan. ");
INSERT INTO dyu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamari ka o mɛn minkɛ, a k’a ta firiya faniw bɔ a yɛrɛ ra, ka lankana dɔ biri a kun na, k’a yɛrɛ datugu, ka taga sigi Enayimu dugu donda ra, Timina dugu sira ra, k’a yɛrɛ kɛ i ko jatɔmuso. Tamari ka o kɛ, sabu a k’a ye ko Sela kɔrɔyara, nka Zuda ma sɔn ka ale di a ma, ale ye kɛ a muso ye. ");
INSERT INTO dyu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ayiwa, Zuda tɛmɛtɔ nana Tamari siginin ye; a kɛra a ɲa na ko jatɔmuso dɔ lo, sabu Tamari tun k’a ɲa datugu. ");
INSERT INTO dyu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Zuda k’a siginin ye sirada ra, a m’a lɔn ko a buranmuso lo. A ko a ma ko: «A to ne ye jɛn ni i ye.» Tamari ko: «Ni i ka jɛn ni ne ye, i bɛna mun le di ne ma?» ");
INSERT INTO dyu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Zuda ko: «Ne bɛna badennin kelen bɔ ne ta baw ra ka o sama i ma.» Tamari ko: «I bɛ mun le di ne ma a sarati ye, sani i ye na a sama ne ma?» ");
INSERT INTO dyu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Zuda ko: «Ele yɛrɛ b’a fɛ ne ye mun le di i ma a sarati ye?» Tamari ko: «I tɔgɔ tagamasiyɛn bɛ fɛn min kan, ani a juru, ani bere min bɛ i boro, olugu di ne ma.» Zuda ka o fɛnw di a ma, ka jɛn ni a ye. Tamari ka kɔnɔ ta Zuda fɛ o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","O kɔ, Tamari wurira ka taga. A k’a ta faniw bɔ a yɛrɛ ra, k’a ta firiya faniw don tuun. ");
INSERT INTO dyu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ayiwa, kɔ fɛ, Zuda nana badennin di a tericɛ Adulamukacɛ ma, ko a ye na a di muso ma, ani ale ka fɛn minw di muso ma, ka o mina ka na. Cɛ tagara, a ma muso ye. ");
INSERT INTO dyu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","A ka o yɔrɔ mɔgɔw ɲininka ko: «Jatɔmuso min bɛ to ka sigi Enayimu dugu donda ra, sirada ra, a bɛ min le?» Mɔgɔw ko: «Jatɔmuso si ma sigi yan ka ye.» ");
INSERT INTO dyu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ayiwa, a sekɔra ka taga a fɔ Zuda ye ko: «Ne ma muso ye dɛ! Ne k’a yɔrɔ mɔgɔw ɲininka; o ko: ‹Jatɔmuso si ma sigi yan ka ye.› » ");
INSERT INTO dyu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Zuda ko: «A ye to ni o fɛnw ye. An kana maroya ɲini ka se an yɛrɛ ma. Ne kɔni k’a ta badennin ci a ma, nka ele m’a ye!» ");
INSERT INTO dyu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ayiwa, karo saba tɛmɛnin kɔ, o nana a fɔ Zuda ye ko: «I buranmuso Tamari ka jatɔya kɛ; sisan a ye nin ye, a ka kɔnɔ ta yɛrɛ.» Zuda ka o kuma mɛn minkɛ, a ko: «Aw ye taga a mina ka bɔ ni a ye kɛnɛ ma, o ye a jɛni.» ");
INSERT INTO dyu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","O ko o bɛ taga Tamari mina ka bɔ ni a ye minkɛ, a ka mɔgɔ bla k’a fɔ a burancɛ ye ko: «Nin tagamasiyɛn ni nin bere ye mɔgɔ min ta ye, ne ka kɔnɔ ta o tigi le fɛ. Sabari ka nin tagamasiyɛn ni a juru, ni nin bere tigi ɲini, k’a lɔn jɔn ta lo.» ");
INSERT INTO dyu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Zuda ka fɛnw flɛ k’a ye ko ale yɛrɛ ta lo. A ko: «Ne jarakira ka tɛmɛ Tamari kan. Can lo, sabu ne tun ka kan k’a furu ne dencɛ Sela ma, nka ne ma o kɛ.» Zuda ma jɛn ni Tamari ye o kɔ tuun. ");
INSERT INTO dyu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ayiwa, a jigiwagati ra, denw kɛra flaninw ye. ");
INSERT INTO dyu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","A jigitɔ, den kelen k’a boro bɔ; tinminamuso ka ale boro mina ka jese wulenman dɔ siri a ra, k’a fɔ ko: «Nin le ye fɔlɔ ye.» ");
INSERT INTO dyu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Nka den k’a boro sama k’a don yi tuun. A flaninɲɔgɔn bɔra. Tinminamuso ko: «Ele le ka sira dayɛlɛ kɛ!» A k’a tɔgɔ la ko Perɛsi. ");
INSERT INTO dyu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","O kɔ, a dɔgɔnin bɔra, ni jese wulenman sirinin ye a boro ra. O ka ale tɔgɔ la ko Zeraki. ");
INSERT INTO dyu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ayiwa, Sumayila ta mɔgɔw tagara ni Yusufu ye Misiran. Misirankacɛ Potifari, Farawona ta sorasiw kuntigiba, ale ka Yusufu san Sumayila ta mɔgɔw fɛ; olugu le tun tagara nin Yusufu ye. ");
INSERT INTO dyu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Matigi Ala tora ni Yusufu ye k’a ta kow bɛɛ ɲa a boro. A tun bɛ a matigicɛ Misirankacɛ Potifari ta so le kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","A matigicɛ nana a ye ko Matigi Ala bɛ ni Yusufu ye; ko ni a k’a boro don fɛn o fɛn na, Ala bɛ o ɲa a boro. ");
INSERT INTO dyu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusufu ko nana diya a matigicɛ ye, fɔ a k’a sigi a ta so kunna, k’a borofɛnw bɛɛ karifa a ma. ");
INSERT INTO dyu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kabini Potifari ka Yusufu sigi a ta so kunna, ani a borofɛnw bɛɛ kunna, Matigi Ala ka baraka don Misirankacɛ Potifari ra, k’a ta so koɲaw bɛɛ ɲa Yusufu kosɔn. Matigi Ala ta baraka lara Potifari borofɛnw bɛɛ kan, sokɔnɔfɛnw, ani forokɔnɔfɛnw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","A kɛra ten minkɛ, Potifari k’a ta so koɲaw bɛɛ to Yusufu boro. A tun tɛ maga foyi ra, ni a yɛrɛ ta domuni dɔrɔn tɛ. Yusufu tun ye kanbelen cɛɲumanba le ye; a fari tun dakaɲanin lo, a ɲada fana tun cɛ ka ɲi. ");
INSERT INTO dyu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Wagati dɔ nana kɛ, Yusufu matigicɛ ta muso ɲabɔra Yusufu fɛ. A ko Yusufu ye jɛn ni ale ye. ");
INSERT INTO dyu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yusufu ma sɔn; a ko a ma ko: «Ne matigicɛ tɛ foyi kɛ a yɛrɛ ye tuun so kɔnɔ yan. A k’a borofɛnw bɛɛ karifa ne le ma. ");
INSERT INTO dyu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","A ni ne bɛɛ kɛra kelen ye nin so kɔnɔ yan. A ma ne bari foyi ra, fɔ ele kelen, sabu i ye a muso ye. Ne bɛna o kojuguba ɲɔgɔn kɛ cogo di ka Ala hakɛ ta?» ");
INSERT INTO dyu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Lon bɛɛ muso tun bɛ Yusufu wele, nka Yusufu ma sɔn ka taga la a kɔrɔ ka jɛn ni a ye. ");
INSERT INTO dyu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ayiwa, lon dɔ Yusufu tun donna bon kɔnɔ ka taga a ta baara kɛ; o y’a sɔrɔ lukɔnɔmɔgɔ si tun tɛ yi. ");
INSERT INTO dyu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Muso ka Yusufu mina a ta derege ma, ko a ye jɛn ni ale ye. Yusufu k’a ta derege bɔ k’a to a boro, ka bori ka bɔ kɛnɛ ma. ");
INSERT INTO dyu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ayiwa, muso k’a ye ko Yusufu k’a ta derege to ale boro ka bori ka bɔ kɛnɛ ma minkɛ, ");
INSERT INTO dyu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a kulera ka lukɔnɔmɔgɔw wele k’a fɔ o ye ko: «Aw y’a flɛ, ne cɛ nana ni Heburu kanbelen min ye, o nana an janfa le. Aw m’a ye, a nana ne kɔ ko a bɛna jɛn ni ne ye; nka ne ka kulekanba ci. ");
INSERT INTO dyu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","A nana a ye ko ne bɛ ne kan bɔra ka kule kosɛbɛ minkɛ, a k’a ta derege to ne boro yan ka bori ka bɔ kɛnɛ ma.» ");
INSERT INTO dyu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Muso ka Yusufu ta derege bla a yɛrɛ kɔrɔ, sani a cɛ ye sekɔ ka na so kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","A cɛ nana minkɛ, a ka o kuma kelen fɔ a ye, ko: «A flɛ, i nana ni jɔncɛ Heburuka min ye, a nana ne kɔ ko a bɛna jɛn ni ne ye. ");
INSERT INTO dyu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ne ka ne kan bɔ ka kule minkɛ, a k’a ta derege to ne boro, ka bori ka bɔ kɛnɛ ma.» ");
INSERT INTO dyu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ayiwa, muso ka min fɔ Yusufu ta ko ra, cɛ ka o mɛn minkɛ, a dimina kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","A ka Yusufu mina k’a bla kaso ra, masacɛ ta kasodenw bɛ yɔrɔ min na. Yusufu tora kasobon na yi. ");
INSERT INTO dyu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Nka Matigi Ala tora ni Yusufu ye, ka ɲa a ma, k’a ko diya kasobon kɔrɔsibaga ye. ");
INSERT INTO dyu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kasobon kɔrɔsibaga ka Yusufu bla kasoden tɔw bɛɛ kunna kasobon kɔnɔ, ko a ye o kɔrɔsi. Yusufu le tun bɛ fɛn bɛɛ ɲanabɔ kasobon kɔnɔ yi. ");
INSERT INTO dyu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kasobon kɔrɔsibaga yɛrɛ nana a boro bɔ fɛn bɛɛ ra, ka ko bɛɛ to Yusufu le boro, sabu Matigi Ala tun bɛ ni Yusufu ye. Ala tun bɛ a ta ko bɛɛ ɲa a boro. ");
INSERT INTO dyu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ayiwa, lon dɔ, Misiran masacɛ ta minnifɛndibagaw kuntigi, ani a ta burujɛnibagaw kuntigi, olugu ka ko dɔ kɛ min ma bɛn masacɛ ma. ");
INSERT INTO dyu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farawona dimina o kuntigi fla kɔrɔ, minw ye minnifɛndibagaw kuntigi ni burujɛnibagaw kuntigi ye. ");
INSERT INTO dyu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Masacɛ ko o ye o mina ka o bla kaso ra, sorasiw kuntigiba ta bon kɔnɔ, Yusufu tun bɛ yɔrɔ min na. ");
INSERT INTO dyu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sorasiw kuntigiba ka o bla ni Yusufu ye, ko Yusufu ye o kɔrɔsi. Yusufu le tun bɛ o ta ko bɛɛ ɲanabɔ. O ka wagati dama kɛ kasobon na yi. ");
INSERT INTO dyu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Lon dɔ, ka o to kasobon na yi, minnifɛndibagaw kuntigi, ani burujɛnibagaw kuntigi ka siko dɔ kɛ su kelen na. O bɛɛ ni o ta siko, dɔ ni dɔ kɔrɔ tɛ kelen ye. ");
INSERT INTO dyu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ayiwa, sɔgɔmada fɛ, Yusufu nana o flɛ minkɛ, a k’a ye ko o ɲa kumunin lo. ");
INSERT INTO dyu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","A ka o ɲininka ko: «Mun le ka aw ɲa kumu tan bi?» ");
INSERT INTO dyu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","O ko: «An ka siko dɔ le kɛ; mɔgɔ fana tɛ yi min bɛ se ka a kɔrɔ fɔ an ye.» Yusufu ko: «Siko kɔrɔ lɔnniya bɛ Ala le fɛ. Aw ye aw ta sikow fɔ ne ye.» ");
INSERT INTO dyu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Masacɛ ta minnifɛndibagaw kuntigi k’a ta siko fɔ; a ko: «Ne ta siko ra, ne ka rɛzɛnsun dɔ le ye ne ɲa fɛ, ");
INSERT INTO dyu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","yiriboro saba tun b’a ra. A fiyerenna, a fiyerenw denna, a rɛzɛndenw mɔna. ");
INSERT INTO dyu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","O y’a sɔrɔ Farawona ta jiminminan tun bɛ ne boro. Ne ka rɛzɛnmɔ mina k’a bisi Farawona ta jiminminan kɔnɔ, k’a di Farawona ma.» ");
INSERT INTO dyu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu ko: «I ta siko kɔrɔ ye nin ye: Yiriboro saba, o ye tere saba le ye. ");
INSERT INTO dyu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ni tere saba dafara, Farawona bɛna i labɔ kaso ra, ka i bla i ta baarakɔrɔ ra. I bɛna to ka minnifɛn di Farawona ma i n’a fɔ i tun b’a kɛra cogo min na kakɔrɔ, tuma min na i tun bɛ o baara ra. ");
INSERT INTO dyu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Nka ni i nana o hɛra sɔrɔ tuma min na, i ye i hakiri to ne ra, ka ɲa ne ma; i ye kuma Farawona fɛ, ka ne ko fɔ a ye, janko a ye ne labɔ kaso ra. ");
INSERT INTO dyu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Sabu o ka ne mina fanga ra ka bɔ Heburuw ta jamana le ra ka na ni ne ye yan. O ka ne bla kaso ra yan, k’a sɔrɔ ne ma kojugu si kɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ayiwa, burujɛnibagaw kuntigi k’a ye ko Yusufu k’a tɔɲɔgɔncɛ ta siko kɔrɔ fɔ k’a diya minkɛ, ale fana k’a ta fɔ. A ko: «Ne fana ta siko ra, segi saba tun bɛ ne kun, buru gbɛman tun bɛ o segi saba kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Segi min tun bɛ tɔw bɛɛ san fɛ, domunifɛn suguya bɛɛ tun bɛ o kɔnɔ, a bɛɛ tobira ka mɔ Farawona ye. Ayiwa, kɔnɔ dɔw nana kɛ o fɛnw domu ye segi kɔnɔ ne kunna.» ");
INSERT INTO dyu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu ko: «I ta siko kɔrɔ ye nin ye: Segi saba, o ye tere saba ye fana. ");
INSERT INTO dyu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ni tere saba dafara, Farawona bɛna i labɔ kaso ra, ka i kun tigɛ, ka i su dulon yiri ra, kɔnɔw bɛna kɛ i sogisogi ye.» ");
INSERT INTO dyu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ayiwa, tere saba nana dafa, ka bɛn Farawona worolon kunbɛn ma. O ɲanagbɛ ra, a ka domuniba dɔ tobi a ta jamana ɲamɔgɔw bɛɛ ye. A ka minnifɛndibagaw kuntigi ni burujɛnibagaw kuntigi labɔ kaso ra a ta jamana ɲamɔgɔw ɲa na. ");
INSERT INTO dyu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","A ka minnifɛndibagaw kuntigi bla a ta baarakɔrɔ ra, ko a ye to ka minnifɛn di Farawona ma. ");
INSERT INTO dyu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Nka a ka burujɛnibagaw kuntigi dulon yiri ra ka kaɲa ni Yusufu ta kuma ye. ");
INSERT INTO dyu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kabini minnifɛndibagaw kuntigi bɔra kaso ra, a ma miiri Yusufu ma tuun; a ɲinana a kɔ pewu. ");
INSERT INTO dyu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","San fla tɛmɛnin kɔ, Farawona yɛrɛ ka siko dɔ kɛ. A sikora k’a yɛrɛ ye Nili bada ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A ka misi ɲumanman tɔrɔnin wolonfla ye, o bɔra ji ra, ka na kɛ bin ɲimi ye bada ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","A ka misi cɛjugu fasamannin wolonfla ye, olugu fana bɔra ji ra, misi ɲumanman wolonfla kɔ fɛ, ka na lɔlɔ o kɔrɔ bada ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ayiwa, misi cɛjugu fasamannin wolonfla, olugu ka misi tɔrɔnin wolonfla domu. O kɔ, Farawona kununa sunɔgɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Sunɔgɔ nana a ta tuun; a ka siko dɔ wɛrɛ kɛ. A ka ɲɔtizan wolonfla ye, o bɔra ɲɔsun kelen na, o bɛɛ kisɛ ka bonbon, o cɛ ka ɲi. ");
INSERT INTO dyu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","O kɔ, ɲɔtizan wolonfla wɛrɛ bɔra o ɲɔsun kelen na, o kisɛw ka dɔgɔ dɔgɔ, sabu kongokolon fɔɲɔ ka o bɛɛ jaja fɔ ka o cɛjuguya. ");
INSERT INTO dyu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ayiwa, ɲɔtizan minw jajanin bɛ, olugu ka ɲɔtizan kisɛɲuman belebelew domu. O kɔ, Farawona kununa tuun. A k’a ye ko siko lo. ");
INSERT INTO dyu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","O lon sɔgɔmada fɛ, Farawona hakiri ɲagamina. A ka Misiran jamana lagbɛrikɛbagaw, ani a kolɔnbagaw bɛɛ wele. A ka a ta sikow lakari o ye, nka o si ma se k’a kɔrɔ fɔ Farawona ye. ");
INSERT INTO dyu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","O tuma ra, Farawona ta minnifɛndibagaw kuntigi ka kuma ta, k’a fɔ Farawona ye ko: «Ne ka kojugu min kɛ, ne hakiri jigira o ra bi.» ");
INSERT INTO dyu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","A ko: «Farawona, lon dɔ i tun dimina i ta jamana mɔgɔba dɔw kɔrɔ. I tun ka ne mina o wagati ra ka ne bla kaso ra, sorasiw kuntigiba ta bon kɔnɔ, ne ni burujɛnibagaw kuntigi. ");
INSERT INTO dyu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Lon dɔ, su fɛ, an mɔgɔ fla bɛɛ sikora, an bɛɛ ta siko kɔrɔ fɔra an ye. ");
INSERT INTO dyu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Heburu kanbelen dɔ le tun bɛ ni an ye kasobon na; sorasiw kuntigiba ta baaraden tun lo fɔlɔfɔlɔ. An ka an ta siko ɲafɔ ale le ye, a k’a kɔrɔ fɔ an ye. ");
INSERT INTO dyu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","A ka min fɔ an ye fana, kow nana kɛ ka kaɲa ni o le ye. I ka ne bla ne ta baarakɔrɔ ra, ka burujɛnibagaw kuntigi kun tigɛ k’a su dulon yiri ra.» ");
INSERT INTO dyu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ayiwa, Farawona ka o mɛn minkɛ, a ka mɔgɔ ci ka taga Yusufu wele. O teliyara ka Yusufu labɔ kasobon na. O k’a kun ni a bonbosiw bɛɛ li, k’a saninya, ka fani wɛrɛ don a ra, ka taga ni a ye Farawona fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","A sera yi minkɛ, Farawona ko a ma ko: «Ne ka siko dɔ le kɛ, mɔgɔ si ma se k’a kɔrɔ fɔ ne ye. Ne k’a mɛn ko ni siko fɔra ele ye, ko i bɛ se k’a kɔrɔ fɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu ka Farawona jaabi ko: «Farawona, ne tɛ, Ala le bɛna i ta siko kɔrɔ fɔ i ye ka ɲa.» ");
INSERT INTO dyu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Farawona k’a fɔ Yusufu ye ko: «Ne ta siko ra ne k’a ye ko ne tun bɛ Nili bada ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ne ka misi cɛɲuman tɔrɔnin wolonfla ye, o bɔra ji ra ka na kɛ bin ɲimi ye kɛnɛ ma. ");
INSERT INTO dyu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Misi wolonfla wɛrɛ bɔra ji ra tuun, o fasanin bɛ, o cɛ ka jugu, sogo ɲanaman tɛ o ra; Misiran jamana bɛɛ ra ne ma o misiw ɲɔgɔn cɛjugu ye ban. ");
INSERT INTO dyu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ayiwa, misi cɛjugu fasaninw, olugu ka misi tɔrɔninw domu, minw tun kɔnna ka bɔ. ");
INSERT INTO dyu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","O ka o kunu yɛrɛ le; nka o bɛɛ n’a ta, a kɛra i ko foyi yɛrɛ ma don o kɔnɔbara ra. O cɛjuguyanin tora ten, i ko o tun bɛ cogo min na kakɔrɔ. O kɔ, ne kununa sunɔgɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«Ayiwa, ne sunɔgɔra tuun; ne ka siko dɔ wɛrɛ kɛ. O ra ne ka ɲɔtizan wolonfla ye, o bɛɛ kisɛw ka bonbon, a cɛ ka ɲi. O tizan wolonfla bɛɛ bɔra ɲɔkala kelen na. ");
INSERT INTO dyu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Tizan wolonfla wɛrɛ bɔra o kɔ fɛ, o ka dɔgɔdɔgɔ, sabu kongokolon fɔɲɔ ka o bɛɛ jaja. ");
INSERT INTO dyu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ayiwa, tizan minw ka dɔgɔdɔgɔ, olugu ka tizanɲumanw domu. «Ayiwa, ne ka nin siko le fɔ ne ta lagbɛrikɛbagaw ye, nka o si ma se k’a kɔrɔ fɔ ne ye.» ");
INSERT INTO dyu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusufu k’a fɔ Farawona ye ko: «Farawona, i ka siko fla min kɛ, o bɛɛ ye fɛn kelen le ye. Ala bɛna min kɛ, a ka o le yira i ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Misi ɲumanman wolonfla, o ye san wolonfla ye. Ɲɔtizan wolonfla, o ye san wolonfla ye. A bɛɛ ye siko kelen le ye. ");
INSERT INTO dyu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Misi fasanin cɛjugu wolonfla minw bɔra ji ra ka na tɔw kɔ, o ye san wolonfla kɔngɔ ye. Ɲɔtizan wolonfla minw ka dɔgɔdɔgɔ, fɔɲɔ ka minw jaja, o fana ye o san wolonfla kɔngɔ kelen le ye. ");
INSERT INTO dyu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ne k’a fɔ i ye cogo min na sisan, Farawona, Ala bɛna min kɛ, a ka o le yira i ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sanji wolonfla bɛna kɛ, siman bɛna ɲa kosɛbɛ Misiran jamana bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Nka sanji wolonfla wɛrɛ bɛna na o kɔ fɛ, o bɛna kɛ kɔngɔba ye, k’a kɛ fɔ mɔgɔw bɛna ɲina san tɛmɛninw ta siman camanba wagati bɛɛ kɔ Misiran jamana ra. Kɔngɔ bɛna jamana bɛɛ halaki. ");
INSERT INTO dyu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kɔngɔ juguyakojugu fɛ, siman tun ɲana san minw na, mɔgɔw bɛna ɲina o sanw bɛɛ kɔ pewu.» ");
INSERT INTO dyu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Yusufu ko Farawona ma tuun ko: «Farawona, ni i k’a ye ko i ka nin siko kɛ cogoya fla ra, o b’a yira ko can ra Ala le ka nin ko latigɛ; a fana tɛna mɛɛn ni a ma kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ayiwa, sisan i ka kan ka mɔgɔ hakiriman kolɔnbaga dɔ le ɲini, k’a sigi Misiran jamana bɛɛ kunna, ");
INSERT INTO dyu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ka mɔgɔ dɔw fana sigi jamana kunna ni ale ye, janko ni siman o siman ka sɔrɔ, o ye o tarantaran yɔrɔ looru, ka taran kelen bɔ k’a bla danna, Misiran jamana yɔrɔ bɛɛ ra, sanɲuman wolonfla bɛɛ kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Sanɲuman wolonfla min bɛna na, o ye siman lajɛn o sanw bɛɛ kɔnɔ. Ele Farawona yɛrɛ ye o mɔgɔw kɔrɔsi. O ye o simanw lajɛn k’a bla danna duguw bɛɛ ra, k’a kɔrɔsi. ");
INSERT INTO dyu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ni san wolonfla kɔngɔ nana se Misiran jamana ma tuma min na, o siman min lajɛnna, o le bɛna kɛ ka jamana baro. Ni o kɛra, kɔngɔ tɛna jamana halaki.» ");
INSERT INTO dyu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ayiwa, Yusufu ka min fɔ, o diyara Farawona ni a ta jamana ɲamɔgɔw bɛɛ ye. ");
INSERT INTO dyu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Farawona k’a fɔ a ta jamana ɲamɔgɔw ye ko: «An bɛ se ka mɔgɔ juman le sɔrɔ tuun Ala ka hakiri di min ma i ko nin cɛ?» ");
INSERT INTO dyu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Farawona ko Yusufu ma ko: «I n’a fɔ Ala ka nin kow yira ele ra, mɔgɔ si tɛ yi tuun min bɛ sɔrɔ kolɔnbaga ye, ani hakiritigi ye ka ele bɔ. ");
INSERT INTO dyu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ne bɛ i sigi ne ta so kunna; ni i ka min fɔ, ne ta mɔgɔw bɛna o le kɛ. Masacɛya dɔrɔn le bɛna ne bonya ni i ye. ");
INSERT INTO dyu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ne ka Misiran jamana bɛɛ kuntigiya don i boro bi.» ");
INSERT INTO dyu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Farawona k’a yɛrɛ ta borokandennɛgɛ bɔ k’a don Yusufu borokanden na. A ko o ye lɛnfani ɲumanman dɔw don a ra, ka kannanɛgɛ saninlaman dɔ don a kan na. ");
INSERT INTO dyu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A ka Yusufu yɛlɛ sowotoro dɔ kan, k’a gban a yɛrɛ ta sowotoro kɔ. Mɔgɔ dɔw blara o ɲa ka kɛ pɛrɛn ye, ko: «Aw ye sira bla, aw ye sira bla, fagamaw bɛ nana!» Ayiwa, Farawona ka Misiran jamana bɛɛ kuntigiya di Yusufu ma o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farawona ko Yusufu ma tuun ko: «Ne le ye Farawona ye. Nka mɔgɔ man kan ka foyi kɛ Misiran jamana bɛɛ kɔnɔ yan, ni ele ma o sira di o tigi ma.» ");
INSERT INTO dyu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farawona ka Yusufu tɔgɔ la ko Safinati Paneya. A ka muso di a ma. A muso tɔgɔ tun ye ko Asanati. Muso facɛ tɔgɔ tun ye Potifera; ale le tun ye Ɔni dugu sarakalasebaga ye. Yusufu sigira Misiran jamana bɛɛ kunna. ");
INSERT INTO dyu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Wagati min na o ka Yusufu wele ka taga Misiran masacɛ Farawona fɛ, o y’a sɔrɔ a si tun ye san bisaba. O le kɔ fɛ, a bɔra Farawona kɔrɔ ka taga Misiran jamana yaala. ");
INSERT INTO dyu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ayiwa, san wolonfla kɛra, siman ɲana, ka den kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufu ka o san wolonfla ta siman dɔw lajɛn Misiran jamana yɔrɔ bɛɛ ra, ka o bla danna. A ka siman lajɛn k’a bla duguw bɛɛ ra. Forow bɛ dugu minw kɔrɔ, a ka o forow simanw lajɛn o duguw ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu ka siman lajɛn caman, i ko kɔgɔji kɛnkɛn. A cayara fɔ a laban o nana a jateri dabla, sabu a jateda tun tɛ se ka lɔn tuun. ");
INSERT INTO dyu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ayiwa, sani kɔngɔ wagati ye se, Yusufu ka dencɛ fla sɔrɔ ni a muso Asanati ye, Ɔni dugu sarakalasebaga Potifera denmuso. ");
INSERT INTO dyu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu k’a dencɛ fɔlɔ tɔgɔ la ko Manase, ko sabu Ala k’a kɛ ale ɲinana a ta tɔɔrɔw bɛɛ kɔ, k’a hakiri bɔ a facɛ ta so kɔ. ");
INSERT INTO dyu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A ka dencɛ flanan tɔgɔ la ko Efirayimu, ko sabu ale tɔɔrɔra jamana min na, Ala ka dencɛ di ale ma o jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ayiwa, siman ɲana kosɛbɛ sanji wolonfla min kɔnɔ Misiran, o sanji wolonfla nana ban. ");
INSERT INTO dyu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","O kɔ fɛ sanji wolonfla kɔngɔ daminana, i n’a fɔ Yusufu tun k’a fɔ cogo min na. Kɔngɔ benna jamana tɔw bɛɛ kan, nka siman tun bɛ Misiran jamana yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ayiwa, kɔngɔ nana se Misiran jamana fana ma tuma min na, mɔgɔw nana kɛ kule ye Farawona kɔrɔ, ko a ye domuni di o ma. Farawona ko Misirankaw bɛɛ ma ko: «Aw ye taga Yusufu fɛ; ni a ka min fɔ aw ye, aw y’a kɛ ten.» ");
INSERT INTO dyu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","O tuma kɔngɔba le tun bɛ jamana yɔrɔ bɛɛ ra. Yusufu ka simanmarayɔrɔw dayɛlɛ, ka siman fiyeere Misirankaw ma. O y’a sɔrɔ kɔngɔ tun bɛ juguyara ka taga Misiran jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mɔgɔw tun bɛ bɔ jamanaw bɛɛ ra ka na siman san Misiran, Yusufu fɛ; sabu kɔngɔ tun bɛ juguyara jamanaw bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakuba nana a mɛn ko siman bɛ sɔrɔra Misiran. A k’a fɔ a dencɛw ye ko: «Mun kosɔn aw bɛ sigi yan ka kɛ ɲɔgɔn flɛ ye? ");
INSERT INTO dyu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ne k’a mɛn ko siman bɛ sɔrɔra Misiran. Aw ye taga yi ka taga dɔ san an ye, janko kɔngɔ kana na an faga yan.» ");
INSERT INTO dyu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yusufu kɔrɔcɛ mɔgɔ tan ka sira mina, ka taga siman san Misiran. ");
INSERT INTO dyu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yakuba ma sɔn ka Yusufu dɔgɔcɛ Boniyaminu bla ni o ye ka taga. A tun bɛ siranna ko kojugu dɔ kana na taga a sɔrɔ yi. ");
INSERT INTO dyu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ayiwa, Yakuba dencɛw tagara simansanyɔrɔ ra ni mɔgɔ wɛrɛw ye, sabu kɔngɔ tun bɛ Kanaana jamana yɔrɔ bɛɛ le ra. ");
INSERT INTO dyu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","O y’a sɔrɔ Yusufu le tun bɛ Misiran jamana kuntigiya ra; ale le tun bɛ siman fiyeerera mɔgɔ bɛɛ ma Misiran. A kɔrɔcɛw nana se minkɛ, o ka o kinbiri gban Yusufu kɔrɔ, ka o ɲa biri dugu ma. ");
INSERT INTO dyu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu k’a kɔrɔcɛw ye minkɛ, a ka o lɔn; nka a k’a kɛ i n’a fɔ ale ma o lɔn. A kumana o fɛ k’a kɛ i n’a fɔ a dimina o kɔrɔ le. A ko o ma ko: «Aw bɔra min le?» O k’a jaabi ko: «An bɔra Kanaana jamana le ra, ka na siman san yan.» ");
INSERT INTO dyu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","O ka o fɔ minkɛ, Yusufu k’a lɔn can ra ko a kɔrɔcɛw lo. Nka olugu ma Yusufu lɔn. ");
INSERT INTO dyu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusufu tun ka siko minw kɛ a kɔrɔcɛw ko ra, a hakiri jigira o ra. A ko o ma ko: «Aw nana jamana flɛ dogo ra le, janko aw bɛna se ka jamana yɔrɔ minw kɛrɛ, aw ye o yɔrɔw lɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","A kɔrɔcɛw ko: «An matigicɛ, o tɛ! I ta jɔnw nana siman le san. ");
INSERT INTO dyu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","An bɛɛ ye fakelendenw le ye. An bɛ can le fɔra. An ma na jamana flɛ dogo ra.» ");
INSERT INTO dyu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yusufu ko: «Can tɛ! Aw nakun ye ka na jamana flɛ le, janko aw bɛna se ka yɔrɔ minw kɛrɛ, aw ye o lɔn.» ");
INSERT INTO dyu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","O ko: «Anw ye i ta jɔnw le ye; an ye balemacɛ tan ni fla le ye, an bɛɛ ye fakelendenw le ye. An sigira Kanaana jamana ra. An bɛɛ ra fitini, ale bɛ ni an facɛ ye so; kelen sara an na.» ");
INSERT INTO dyu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufu ko: «Ne ka min fɔ, o le ye can ye; ne ko aw nana an ta jamana flɛ dogo ra le. ");
INSERT INTO dyu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ne bɛna aw sɛgɛsɛgɛ cogo min na, o ye nin ye: ne bɛ kari Farawona tɔgɔ ra, ko ni aw dɔgɔcɛ fitini ma na fiyewu, aw tɛna bɔ yan. ");
INSERT INTO dyu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Aw ye mɔgɔ kelen bɔ aw ra k’a ci, o ye taga aw dɔgɔcɛ fitini ta ka na ni a ye. Tɔw bɛ to kaso ra yan. Ne bɛna aw ta kuma sɛgɛsɛgɛ o cogo le ra k’a lɔn ni aw bɛ can le fɔra. Ni aw ma o kɛ kɔni, o tuma ne karira Farawona tɔgɔ ra ko aw nana jamana flɛ dogo ra le.» ");
INSERT INTO dyu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yusufu ka o fɔ minkɛ, a ka o bla kaso ra tere saba. ");
INSERT INTO dyu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A tere sabanan, a k’a fɔ o ye ko: «Sisan ne bɛna min fɔ aw ye, ni aw ka o kɛ, o tuma ne tɛna foyi kɛ aw ra, sabu ne bɛ siran Ala ɲa. ");
INSERT INTO dyu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ni a kɛra ko aw bɛ can le fɔra, o tuma, aw ra kelen ye to kaso ra yan, aw tɔw ye taga ni siman ye ka taga a di aw ta somɔgɔw ma, sabu kɔngɔ bɛ o ra. ");
INSERT INTO dyu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","O kɔ, aw sekɔtɔ, aw ye na ni aw dɔgɔcɛ fitini ye yan; ni o kɛra, ne bɛ a lɔn ko aw bɛ can le fɔra; o ra ne tɛna foyi kɛ aw ra.» A kɔrɔcɛw sɔnna o ma. ");
INSERT INTO dyu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","O ka kɛ a fɔ ye ɲɔgɔn ye ko: «Can ra, an ka an dɔgɔcɛ Yusufu hakɛ ta; sabu an yɛrɛ tun k’a nin tɔɔrɔtɔ ye; a ka an daari ko an ye sabari ka makari ale ra k’a to yi, nka an ma sɔn. O le kosɔn nin ɲagban bɛ sera an ma bi.» ");
INSERT INTO dyu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubɛn ka kuma ta, k’a fɔ o ye ko: «Ne tun m’a fɔ aw ye ko aw kana den nin faga wa? Aw ma sɔn ka ne ta kuma lamɛn. Sisan a ye nin ye, Ala b’a hakɛ le bɔra an na tan.» ");
INSERT INTO dyu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ayiwa, o tun m’a lɔn ko Yusufu bɛ o ta kan mɛnna; sabu Yusufu yɛrɛ tun bɛ kumana o fɛ ni daramina le ye. ");
INSERT INTO dyu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu ka o kuma mɛn minkɛ, a bɔra o kɔrɔ ka taga kasi. A kɔsegira ka na, ka na kuma o fɛ tuun. O kɔ fɛ a ka Simeyɔn mina k’a siri o yɛrɛ ɲana. ");
INSERT INTO dyu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu k’a fɔ a ta baaradenw ye ko o ye a kɔrɔcɛw ta bɔrɔw fa siman na, ka o bɛɛ ta wariw dondon o ta bɔrɔw kɔnɔ, ani ka o ta siraradomuni di o ma. Baaradenw k’a kɛ ten. ");
INSERT INTO dyu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","O ka o ta bɔrɔw lala o ta faliw kɔ ra, ka sira mina ka kɛ taga ye. ");
INSERT INTO dyu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","O tagara se yɔrɔ dɔ ra, o y’a sɔrɔ su kora. O sira yi. O ra kelen k’a ta bɔrɔ dayɛlɛ ko a bɛ domuni di a ta fali ma; a k’a ta wari ye bɔrɔ da ra. ");
INSERT INTO dyu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A ko tɔw ma ko: «E! O ka ne ta wari sekɔ; a ye nin ye bɔrɔ da ra.» Tɔw k’a ye ten minkɛ, o jusu kasira. O siranna fɔ o bɛ yɛrɛyɛrɛ. O ko: «Ala ka mun le kɛ an na tan sa?» ");
INSERT INTO dyu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ayiwa, o nana se o facɛ Yakuba fɛ, Kanaana jamana ra. Min ka o sɔrɔ, o ka o bɛɛ fɔ a ye. O ko: ");
INSERT INTO dyu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Cɛ min bɛ Misiran jamana kunna, a ma kuma an fɛ ni ɲumanya ye dɛ! A ko, ko an tagara o ta jamana flɛ dogo ra le. ");
INSERT INTO dyu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","An k’a fɔ a ye ko an ye mɔgɔsɔbɛw le ye, ko an ma na jamana flɛ dogo ra. ");
INSERT INTO dyu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","An k’a fɔ a ye ko an tun ye balemacɛ tan ni fla le ye an facɛ fɛ, ko kelen sara, ko an dɔgɔcɛ fitini, sisan ale bɛ ni an facɛ ye Kanaana jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ayiwa, a ko an ma ko: ‹Fɛn min bɛ se k’a to ne bɛ la aw ra, ko aw ye mɔgɔsɔbɛw ye, o ye nin ye: aw ye aw balema kelen to yan; aw tɔw bɛ siman ta ka taga a di aw ta somɔgɔw ma, sabu kɔngɔ bɛ o ra. Ni aw tagara, aw ye na ni aw dɔgɔcɛ fitini ye ne fɛ yan. ");
INSERT INTO dyu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","O ra, ne bɛna a lɔn ko aw ma na jamana flɛ, ko aw ye mɔgɔsɔbɛw le ye. Ni o kɛra, ne bɛna aw balemacɛ bla. O kɔ, aw bɛ se ka taga jamana yɔrɔ bɛɛ ka sanni ni fiyeere kɛ, aw yɛrɛ sago ma.› » ");
INSERT INTO dyu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ayiwa, o nana kɛ siman bɔ ye o ta bɔrɔw kɔnɔ tuma min na, o k’a ye ko o bɛɛ ta wari bɛ o ta bɔrɔw kɔnɔ. O ka wari ye o ta bɔrɔ kɔnɔ minkɛ, o ni o facɛ bɛɛ siranna. ");
INSERT INTO dyu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","O facɛ Yakuba k’a fɔ o ye ko: «E! Aw bɛna ne bɔnɔ ne ta denw na dɛ! Yusufu tɛ yi tuun, Simeyɔn fana tɛ yi tuun; aw bɛna Boniyaminu fana mina ka taga ni a ye wa? Nin tɔɔrɔ bɛɛ bɛ ben ne le kan.» ");
INSERT INTO dyu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubɛn ko a facɛ ma ko: «Ni ne ma sekɔ ka na ni Boniyaminu ye i fɛ, o tuma i ye ne dencɛ fla bɛɛ faga! Boniyaminu to ne boro; ni a kɛra cogo o cogo, ne bɛna sekɔ ka na ni a ye i fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakuba ko: «Ɔn-ɔn, ne dencɛ tɛ taga ni aw ye Misiran fiyewu; sabu a ni a kɔrɔcɛ min bɛ bamuso kelen na, o sara k’a kelen to. Ni ko dɔ nana a sɔrɔ tagama ra, aw bɛna a to ne kɔrɔninba kunsigigbɛtigi ye sa jusukasi ra le.» ");
INSERT INTO dyu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ayiwa, kɔngɔ nana juguya jamana kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yakuba dencɛw tun nana ni siman min ye ka bɔ Misiran, o nana o domu ka ban tuma min na, Yakuba k’a fɔ o ye ko: «Aw ye sekɔ ka taga domuni dɔ ɲini an ye Misiran.» ");
INSERT INTO dyu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","A dencɛ Zuda k’a jaabi ko: «Misirankacɛ k’a fɔ an ye ka a gbɛlɛya kosɛbɛ ko ni an ma taga ni an dɔgɔcɛ ye, an ɲa tɛna la ale kan. ");
INSERT INTO dyu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","O ra, ni i bɛ sɔn ka an dɔgɔcɛ Boniyaminu bla ka taga ni an ye, an bɛna taga domuni san i ye. ");
INSERT INTO dyu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nka ni i tɛ sɔn k’a bla ka taga ni an ye, an tɛ taga; sabu cɛ k’a fɔ an ye ko ni an dɔgɔcɛ tɛ ni an ye, an ɲa tɛna la ale kan.» ");
INSERT INTO dyu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","O facɛ Yakuba ko: «Aw ka kojugu kɛ ne ra dɛ! Mun na aw k’a fɔ cɛ nin ye ko dɔgɔcɛ wɛrɛ bɛ aw fɛ dɛ? Han?» ");
INSERT INTO dyu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","A dencɛw k’a jaabi ko: «Cɛ yɛrɛ le ka ɲininkari caman gban an na an ta somɔgɔw bɛɛ ta ko ra. A ko: ‹Yala aw facɛ bɛ si ra wa? Yala balemacɛ wɛrɛ bɛ aw fɛ wa?› Anw fana k’a ta ɲininkariw jaabi. An tun bɛ se k’a lɔn cogo di ko a bɛna a fɔ an ye ko an ye na ni an dɔgɔcɛ ye?» ");
INSERT INTO dyu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Zuda ko a facɛ Yakuba ma ko: «Baba, den to ne boro, a ye taga ni an ye; a to an ye wuri ka taga domuni ɲini, janko kɔngɔ kana na an bɛɛ faga yan, ele ni anw, ani an ta denw. ");
INSERT INTO dyu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","«Ne le bɛna lɔ ni den kunko ye. Ni ko k’a sɔrɔ, i ye ne ɲininka. Ni ne ma sekɔ ni a ye fiyewu ka na a lɔ i ɲa kɔrɔ yan, o tuma o jaraki bɛna to ne kan tuma bɛɛ; ");
INSERT INTO dyu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","sabu ni tagama tun ma lalɔ tan, i b’a sɔrɔ ko an tun tagara ka kɔsegi ka ban fɔ siɲaga fla.» ");
INSERT INTO dyu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","O facɛ Yakuba ko: «Ayiwa, i n’a fɔ jagboya le ye a taga ye, o tuma aw bɛna min kɛ, o flɛ: Aw ye an ta jamana fɛnɲumanman dɔw bla aw ta bɔrɔw kɔnɔ, ka taga o sama Misirankacɛ ma. Aw ye turu dɔɔnin ta, ani li, ani kasadiyananw, ani turu kasadiman, ani yiriden dɔw, ani saraden, ani amande. ");
INSERT INTO dyu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","«Aw ye aw ta wari ɲɔgɔn fla ta. O tun ka wari min bla aw ta bɔrɔw kɔnɔ, aw ye sekɔ ni o ye. I b’a sɔrɔ o firira le. ");
INSERT INTO dyu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ayiwa, aw ye aw dɔgɔcɛ ta, aw ye wuri ka taga Misirankacɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ala Sebɛɛtigi ye aw makari don cɛ ra, janko a ye aw balemacɛ tɔ kelen ni Boniyaminu bla o ye na. Nka ni ne ka kan ka bɔnɔ ne ta denw na le, o tuma ne ye bɔnɔ o ra.» ");
INSERT INTO dyu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ayiwa, Yusufu kɔrɔcɛw ka o samafɛnw ta; o tun ka kan ka wari min ta, o ka o ɲɔgɔn fla ta. O wurira, o ni Boniyaminu, ka taga Misiran, Yusufu fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kabini Yusufu ka Boniyaminu ye ni o ye, a k’a fɔ a ta baaradenw kuntigi ye ko: «Nin mɔgɔw ladon so kɔnɔ, i ye bɛgan dɔ faga k’a labɛn; o bɛna tererafana domu ni ne yɛrɛ le ye.» ");
INSERT INTO dyu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yusufu ka min fɔ, cɛ ka o kɛ. A tagara ni Yusufu kɔrɔcɛw ye Yusufu ta so kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yusufu kɔrɔcɛw k’a ye ko o tagara ni olugu ye Yusufu ta so minkɛ, o siranna. O ko: «Wari min tora an ta bɔrɔ kɔnɔ an nako fɔlɔ ra, i b’a sɔrɔ o le kosɔn o nana ni an ye yan. O bɛna ben an kan le, ka jɛn an na, ka an mina ka an kɛ o ta jɔnw ye, ka an ta faliw fana mina.» ");
INSERT INTO dyu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","O siranya kosɔn, o gbarara Yusufu ta baaradenw kuntigi ra, so donda ra, ka kuma a fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","O ko: «Hakɛ to, an matigicɛ, anw nana siman san yan kakɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","An ta siman sanko fɔlɔ, an sekɔtɔ, an sera an siyɔrɔ ra minkɛ, an ka an ta bɔrɔw dayɛlɛ k’a ye ko an bɛɛ ta wari dafanin bɛ an ta bɔrɔw da ra, dɔ ma bɔ a ra; a bɛ i ko an tun nana ni a ye cogo min na. O kosɔn an sekɔra ni a ye ka na a di. ");
INSERT INTO dyu_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","An nana ni wari wɛrɛ ye fana ka na siman dɔ wɛrɛ san. Nka an m’a lɔn jɔn le ka wari bla an ta bɔrɔw da ra.» ");
INSERT INTO dyu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Baaradenw kuntigi ko o ma ko: «Aw ye aw hakiri sigi, aw kana siran! Aw ta Ala, aw facɛ ta Ala, ale le ka o wari bla aw fɛ bɔrɔ kɔnɔ. Ni o tɛ, aw tun ka wari min di, o sera ne ma.» Cɛ ka o kuma fɔ ka ban minkɛ, a nana ni Simeyɔn ye o fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","A ka o ladon Yusufu ta bon kɔnɔ, ka ji di o ma, o ka o senw ko. A ka domuni di o ta faliw fana ma. ");
INSERT INTO dyu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","O tun nana ni samafɛn minw ye, o ka o labɛn ka bla, sani Yusufu ye na teregban fɛ; sabu a tun fɔra o ye ko o ni Yusufu bɛna domuni kɛ Yusufu ta so. ");
INSERT INTO dyu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu nana so kɔnɔ tuma min na, o ka samafɛnw di a ma, ka o kinbiri gban a kɔrɔ k’a fo. ");
INSERT INTO dyu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusufu ka o ɲininka ko: «Aw ka kɛnɛ wa?» A ka o ɲininka fana ko: «Aw ka aw facɛ min ko fɔ ko a kɔrɔra, yala a bɛ si ra hali bi wa?» ");
INSERT INTO dyu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","O ka Yusufu jaabi ko: «I ta jɔncɛ min ye an facɛ ye, a bɛ si ra, a fana ka kɛnɛ.» O birira tuun ka o kinbiri gban Yusufu kɔrɔ k’a fo. ");
INSERT INTO dyu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu k’a ɲa kɔrɔta k’a dɔgɔcɛ Boniyaminu flɛ, a yɛrɛ baden dɔgɔnin. A ko: «Aw ka aw dɔgɔcɛ min ko fɔ, ale le ye nin ye wa?» Yusufu ko Boniyaminu ma ko: «Ne dencɛ, Ala ye baraka don i ra.» ");
INSERT INTO dyu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusufu k’a dɔgɔcɛ ye minkɛ, a hina donna a ra, fɔ ka kasilɔgɔ bla a ra. A teliyara ka don bon kɔnɔ ka taga kasi. ");
INSERT INTO dyu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","O kɔ, a k’a ɲa ko, ka bɔ kɛnɛ ma. Kasilɔgɔ tun b’a ra belen, nka a jijara k’a yɛrɛ mina. A k’a fɔ a ta baaradenw ye ko o ye na ni domuni ye. ");
INSERT INTO dyu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","O ka Yusufu ta domuni bɔ danna, k’a kɔrɔcɛw ta bɔ danna. Misiranka minw tun bɛ ni o ye, o ka olugu fana ta bɔ danna, sabu Misirankaw tɛ sɔn ka domuni kɛ ni Heburuw ye; Misirankaw bɛ ɲigi o ra. ");
INSERT INTO dyu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusufu kɔrɔcɛw sigira a ɲa kɔrɔ, ka gbangban ɲɔgɔn na, ka kaɲa ni o sandaw ye; k’a damina kɔrɔ ra ka taga a bla dɔgɔnin na. O ka kɛ ɲɔgɔn flɛ ye; o kabakoyara. ");
INSERT INTO dyu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Domuni min tun bɛ Yusufu kɔrɔ, a ka o dɔ di o ma. A ka tɔw ta ɲɔgɔn looru di Boniyaminu ma. O ka domuni kɛ, ka min, ka ɲagari ni Yusufu ye. ");
INSERT INTO dyu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ayiwa, o kɔ, Yusufu k’a fɔ a ta baaradenw kuntigi ye ko: «Nin mɔgɔw ta bɔrɔw fa siman na; o fanga bɛ se min o min kɔrɔ, o di o ma. O kɔ, i ye o bɛɛ ta wari bla o ta bɔrɔ kɔnɔ, bɔrɔ da ra. ");
INSERT INTO dyu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","I ye ne ta jiminminan warigbɛraman fana bla o bɛɛ ra fitini ta bɔrɔ kɔnɔ, a ta wari kan.» Ayiwa, Yusufu ka min fɔ, baaradenw kuntigi k’a kɛ ten. ");
INSERT INTO dyu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Dugu gbɛra minkɛ dɔrɔn, sɔgɔmada fɛ o ka sira di Yakuba dencɛw ma. O ka o ta doniw lala o ta faliw kɔ ra, ka taga. ");
INSERT INTO dyu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","O bɔra dugu kɔnɔ minkɛ, k’a sɔrɔ o yɔrɔ tun ma janya fɔlɔ, Yusufu k’a ta baaradenw kuntigi wele k’a fɔ a ye ko a ye wuri ka tugu o kɔ; ko ni a kunna o ra, a ye a fɔ o ye ko: «Mun na aw ka ne ta koɲuman sara ni kojugu ye? ");
INSERT INTO dyu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Yala aw ma ne matigicɛ ta jiminminan ta wa, a bɛ lagbɛri kɛ ni min ye? Aw ka kojuguba le kɛ nin ye dɛ!» ");
INSERT INTO dyu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ayiwa, baaradenw kuntigi tagara kun o ra, a ka o kuma fɔ o ye ten. ");
INSERT INTO dyu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","O k’a jaabi ko: «An matigicɛ, mun na i bɛ o kuma ɲɔgɔn fɔ? Ala ye an kisi o ko ɲɔgɔn kɛri ma. ");
INSERT INTO dyu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","An tun ka wari min ye an ta bɔrɔw kɔnɔ, an ma na ni o ye ka bɔ Kanaana ka na o di i ma wa? An bɛna sɔn cogo di ka warigbɛ walama sanin sonya i matigicɛ ta so kɔnɔ? ");
INSERT INTO dyu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ayiwa, ni minan ka ye i ta jɔn min o min fɛ anw na, aw ye o tigi faga, tɔw ye kɛ an matigicɛ ta jɔnw ye.» ");
INSERT INTO dyu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Baaradenw kuntigi ko: «Ayiwa, aw ka min fɔ, ne sɔnna o ma; nka ni minan yera mɔgɔ min kun, o tigi le bɛ kɛ ne ta jɔn ye, foyi tɛ kɛ tɔw ra.» ");
INSERT INTO dyu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","O yɔrɔnin bɛɛ, o bɛɛ ka o ta bɔrɔw jigi, ka o dayɛlɛ. ");
INSERT INTO dyu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Baaradenw kuntigi ka kɛ bɔrɔw kɔnɔ flɛflɛ ye. A k’a damina o bɛɛ ra kɔrɔba ra, ka taga a laban fitini na. Minan tagara ye Boniyaminu ta bɔrɔ kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","A kɛra ten minkɛ, o jusu kasira fɔ o ka o ta deregew mina ka o faranfaran. O ka o ta bɔrɔw ta ka o lala faliw kɔ ra ka sekɔ dugu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Zuda ni a balemaw tagara se Yusufu ta so, k’a sɔrɔ Yusufu belen tun bɛ yi. O ka o kinbiri gban Yusufu kɔrɔ k’a fo. ");
INSERT INTO dyu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu ko o ma ko: «Aw ka mun ko le kɛ tan? O tuma aw ma a lɔn ko ne ɲɔgɔn bɛ se ka ko dogoninw lɔn wa?» ");
INSERT INTO dyu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Zuda ko: «An matigicɛ, an bɛna mun le fɔ sa? Kuma tɛ an fɛ tuun. An bɛ se ka an yɛrɛ bɔ nin ko ra cogo di? Ala yɛrɛ le ka i ta jɔnw ta hakɛ bɔ kɛnɛ kan. Sisan an ye nin ye, an kɛra an matigicɛ ta jɔnw le ye, anw, ani minan tagara ye min ta bɔrɔ kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufu ko: «Ala ye ne kisi o ko ɲɔgɔn kɛri ma. Ne ta minan yera min ta bɔrɔ kɔnɔ, o tigi kelen le bɛna kɛ ne ta jɔn ye. Aw tɔw, aw ye taga hɛra ra aw facɛ fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Zuda gbarara Yusufu ra k’a fɔ a ye ko: «Ne matigicɛ, sabari k’a to i ta jɔncɛ ye kuma dɔ fɔ i ye; i kana dimi ne kɔrɔ, sabu ele ni Farawona bɛɛ le ye kelen ye. ");
INSERT INTO dyu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ne matigicɛ, an nako fɔlɔ ra yan, ele le tun ka an ɲininka ko yala an facɛ belen bɛ yi wa, ko yala dɔgɔcɛ wɛrɛ bɛ an fɛ wa. ");
INSERT INTO dyu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","An ka i jaabi ko an facɛ bɛ yi, ko a kɔrɔra, ani ko an dɔgɔcɛ fitini dɔ bɛ yi, an facɛ ka ale woro k’a sɔrɔ a tun kɔrɔra kosɛbɛ ka ban. Kɔrɔcɛ dɔ fana tun bɛ an dɔgɔcɛ fitini fɛ, nka ale sara. O fla bɛɛ tun bɛ bamuso kelen na. Ayiwa, o dɔgɔcɛ fitini kelen le tora sisan; an facɛ bɛ a kanu kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ele k’a fɔ an ye ko an ye na ni a ye i fɛ, janko i yɛrɛ ɲa ye a ye. ");
INSERT INTO dyu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","An tun ka i jaabi ko den tɛ se ka bɔ a facɛ kɔrɔ. Ni a bɔra a facɛ kɔrɔ, a facɛ bɛ sa jusukasi boro. ");
INSERT INTO dyu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","I k’a fɔ an ye ko ni an dɔgɔcɛ ma na, an ɲa tɛna la ele kan tuun. ");
INSERT INTO dyu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ayiwa, tuma min na an sekɔra an facɛ fɛ, an ka an matigicɛ ta kuma fɔ a ye. ");
INSERT INTO dyu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Lon min an facɛ nana a fɔ an ye ko an ye sekɔ ka na siman dɔ san, ");
INSERT INTO dyu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","an k’a fɔ a ye ko an tɛ se ka na ni an dɔgɔcɛ tɛ ni an ye, ko sabu Misirankacɛ k’a fɔ an ye ko ni an dɔgɔcɛ tɛ ni an ye, an ɲa tɛna la ale kan. ");
INSERT INTO dyu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","«I ta jɔncɛ, an facɛ k’a fɔ o le ra ko: ‹Aw k’a lɔn ko ne ta muso Rasɛli ka dencɛ fla dɔrɔn le woro ne ye. ");
INSERT INTO dyu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kelen tun bɔra so kɔnɔ lon dɔ; ne bɛ miiri ko wara dɔ le k’a faga, sabu ne m’a ye tuun fɔ ka se bi ma.› ");
INSERT INTO dyu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","A ko: ‹Ni aw ka na nin fana ta tuun, ni ko dɔ tagara a sɔrɔ yi, o tuma aw bɛna a to ne kɔrɔninba le bɛna sa tɔɔrɔ ra.› ");
INSERT INTO dyu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Ayiwa, sisan ni ne ka sekɔ i ta jɔncɛ fɛ, ne facɛ fɛ, k’a sɔrɔ den min bɛ a ta ko bɛɛ ye, o den tɛ ni an ye, ");
INSERT INTO dyu_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ni a k’a ye ko den tɛ ni an ye, a bɛna sa jusukasi boro. O tuma anw minw ye i ta jɔnw ye, anw le bɛna kɛ sababu ye k’a to i ta jɔncɛ, an facɛ kɔrɔninba bɛ sa jusukasi ra; ");
INSERT INTO dyu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","sabu, ne matigicɛ, ne le k’a fɔ an facɛ ye ko ne bɛ lɔ ni den kunko ye. Ne k’a fɔ a ye ko ni ne ma sekɔ ni den ye a fɛ, o tuma ne facɛ hakɛ ye to ne kan tuma bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","O kosɔn, ne matigicɛ, sabari i y’a to ne ye to yan den nɔ ra, ka kɛ i ta jɔn ye, k’a to den ye taga so ni a kɔrɔcɛw ye. ");
INSERT INTO dyu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ne bɛna taga ne facɛ fɛ cogo di, ni den tɛ ni ne ye? E! Ne tɛ se ka taga ne facɛ tɔɔrɔtɔ ye.» ");
INSERT INTO dyu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ayiwa, Zuda banna o kuma ra minkɛ, Yusufu ma se k’a yɛrɛ mina tuun mɔgɔw ɲa na. A pɛrɛnna ko o ye mɔgɔw bɛɛ labɔ. Tuma min na Yusufu tun bɛ a yɛrɛ yira a balemaw ra, mɔgɔ si tun tɛ ni o ye. ");
INSERT INTO dyu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yusufu kasira, fɔ Misirankaw k’a kasikan mɛn; Farawona ta somɔgɔw fana k’a kasikan mɛn. ");
INSERT INTO dyu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu k’a fɔ a balemaw ye ko: «Ne le ye Yusufu ye! Yala ne facɛ bɛ si ra wa?» Yusufu balemaw ma se k’a jaabi, sabu o bɛɛ hakiri tun ɲagamina. ");
INSERT INTO dyu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufu k’a fɔ o ye ko: «Aw ye gbara ne ra.» O gbarara a ra. A ko: «Ne le ye aw balemacɛ Yusufu ye, aw ka min fiyeere Misiran tagabagaw ma. ");
INSERT INTO dyu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nka aw kana aw jusu kasi; aw kana dimi aw yɛrɛ kɔrɔ ko mun na aw ka ne fiyeere; sabu Ala le ka ne ci aw ɲa yan, janko ne ye na kɛ sababu ye ka aw kisi. ");
INSERT INTO dyu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nin ye a san fla le ye kɔngɔ bɛ jamana kɔnɔ. Ayiwa, sɛnɛ tɛna se ka kɛ fɔ sanji looru tuun, siman fana tɛna kɛ yi. ");
INSERT INTO dyu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ala le ka ne ci ka na aw ɲa yan, janko aw ye na duruja sɔrɔ nin jamana ra, ka ɲanamanya; o ye kisiriba le ye. ");
INSERT INTO dyu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Aw le ma ne ci yan, Ala yɛrɛ lo. A ka ne sigi yan, ka ne kɛ i n’a fɔ Farawona fa; ka ne sigi a ta so fɛn bɛɛ kunna, ka ne kɛ Misiran jamana bɛɛ ɲamɔgɔba ye. ");
INSERT INTO dyu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«Ayiwa, aw ye teliya ka taga ne facɛ fɛ; aw ye taga a fɔ a ye ko a dencɛ Yusufu ko, ko Ala ka ale kɛ Misiran jamana bɛɛ kuntigi ye. Ko a ye teliya ka na ne kɔrɔ yan. ");
INSERT INTO dyu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ko a bɛna sigi Gosɛni mara ra; a bɛna to ne kɔrɔ yan, ale ni a ta denw, ani a mamadenw, ani a ta sagaw, ani a ta misiw, ani a borofɛnw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ko ne bɛna domuni di a ma, sabu kɔngɔ bɛna kɛ fɔ sanji looru tuun. Ni a nana yan, a ni a ta somɔgɔw ni a ta bɛganw bɛɛ, o tɛna fɔn foyi ra. ");
INSERT INTO dyu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Aw yɛrɛ ɲa bɛɛ a ra, ne dɔgɔcɛ Boniyaminu yɛrɛ ɲa b’a ra ko ne Yusufu le bɛ kumana aw fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Bonya min bɛ ne kan Misiran yan, ani aw yɛrɛ ɲa ka min ye, aw ye taga o bɛɛ lakari ne facɛ ye. O kɔ, aw y’a to ne facɛ ye na ne fɛ joona.» ");
INSERT INTO dyu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ayiwa, Yusufu ka o kumaw fɔ minkɛ, a k’a boro mini a dɔgɔcɛ Boniyaminu kan na, ka kasi, Boniyaminu fana k’a boro mini Yusufu kan na ka kasi. ");
INSERT INTO dyu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","A k’a boro mini a kɔrɔcɛw bɛɛ kan na kelen kelen, ka kasi. O kɔ fɛ, a kɔrɔcɛw sɔrɔra ka kuma ni a ye. ");
INSERT INTO dyu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ayiwa, Yusufu balemaw nako kibaroya sera Farawona ta lukɔnɔmɔgɔw ma. O diyara Farawona ni a ta jamana ɲamɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farawona ka Yusufu wele, k’a fɔ a ye ko: «A fɔ i balemaw ye ko o ye o ta faliw doni siman na ka kɔsegi Kanaana; ");
INSERT INTO dyu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ni o sera yi, o ye o facɛ ni o ta gbamɔgɔw bɛɛ ta ka na to ne kɔrɔ yan. Ne bɛna Misiran jamana yɔrɔ bɛɛ ra ɲumanman di o ma. O bɛna jamana domuniɲumanw domu.» ");
INSERT INTO dyu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","A ko Yusufu ma tuun ko: «A fɔ i balemaw ye ko ne ko, ko o ye sowotoro dɔw ta Misiran yan, ka taga o ta musow ni o ta denw ni o facɛ ta ka na ni o ye. ");
INSERT INTO dyu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ni o ma se ka na ni fɛn dɔw ye, o kana hami o ra, sabu Misiran jamana yɔrɔ bɛɛ ra ɲumanman le bɛna di o ma.» ");
INSERT INTO dyu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ayiwa, Farawona ka min fɔ, Yakuba dencɛw ka o kɛ. Yusufu ka sowotorow di o ma, ka kaɲa ni Farawona ta kuma ye. A ka domuni dɔ di o ma ko o ye o domu sira ra. ");
INSERT INTO dyu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A ka fanikura donta fana di o bɛɛ kelen kelen ma, ka warigbɛ kɛmɛ saba di Boniyaminu ma, ani fanikura looru. ");
INSERT INTO dyu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A ka falicɛ tan doni Misiran ta domuniɲumanw na, ka falimuso tan doni simankisɛ ni buru ra, ani domunifɛn suguya wɛrɛw, ko o ye taga o bɛɛ sama a facɛ ma, janko ni o nana kɛ na ye Misiran, o ye o kɛ o ta baro ye sira ra. ");
INSERT INTO dyu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","O kɔ, a ka sira di a balemaw ma, ko o ye taga. A ko o ma ko: «Aw kana kɛrɛ sira ra dɛ!» O tagara. ");
INSERT INTO dyu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","O bɔra Misiran, ka taga se Kanaana jamana ra, o facɛ Yakuba fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","O sera minkɛ, o k’a fɔ o facɛ ye ko: «Yusufu belen bɛ si ra! Ale le yɛrɛ siginin bɛ Misiran jamana kunna.» Nka Yakuba k’a kɛ i n’a fɔ mɔgɔ tɛ kumana a fɛ; a manwuna, fɔ a ma se ka foyi fɔ, sabu a ma se ka la o ta kuma ra. ");
INSERT INTO dyu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Nka dencɛw nana kɛ Yusufu ta kumaw bɛɛ fɔ ye a ye minkɛ, ani Yusufu tun ka sowotoro minw bla ka na a ta, a ka o bɛɛ ye minkɛ, a hakiri sɔrɔra ka sigi. ");
INSERT INTO dyu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Yakuba ko: «Ne dencɛ Yusufu bɛ si ra wa? Ne tɛ foyi ɲinina tuun ka tɛmɛ o kan. Ne bɛ taga ne ɲa la a kan sani ne ye sa.» ");
INSERT INTO dyu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakuba tagatɔ Misiran, a tagara ni a borofɛnw bɛɛ ye. A tagara se Bɛri Seba, a ka saraka bɔ a facɛ Isiyaka ta Ala ye. ");
INSERT INTO dyu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ala k’a yɛrɛ yira a ra su fɛ, k’a wele ko: «Yakuba, Yakuba!» A ko: «Naamu.» ");
INSERT INTO dyu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ala ko: «Ne le ye Ala ye, i facɛ ta Ala. I kana siran ka taga Misiran, sabu ne bɛna i ta duruja caya, k’a kɛ siyaba ye o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ne Ala yɛrɛ le bɛna taga ni i ye Misiran, ne yɛrɛ le fana bɛna i labɔ. I bɛna sa ka i to Yusufu le boro.» ");
INSERT INTO dyu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakuba bɔra Bɛri Seba. Farawona tun ka sowotoro minw di ka na a ta, a dencɛw k’a ladon o kɔnɔ, ani o ta denw ni o ta musow. ");
INSERT INTO dyu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","O ka o ta bɛganw fana ta, ani o tun ka fɛn o fɛn sɔrɔ Kanaana jamana ra. Yakuba ni a ta somɔgɔw bɛɛ tagara Misiran. ");
INSERT INTO dyu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","A tagara ni a dencɛw ye Misiran, ani a denmusow, ani a mamaden cɛmanw, ani a musomanw, ani a ta durujaw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ayiwa, Yakuba ta den minw tagara Misiran, olugu tɔgɔw ye nin ye; olugu le ye Izirayɛlimɔgɔw ye. A dencɛ fɔlɔ ye Rubɛn ye. ");
INSERT INTO dyu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubɛn dencɛw tun ye Hanɔki ye, ani Palu, ani Hɛsirɔn, ani Karimi. ");
INSERT INTO dyu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeyɔn dencɛw tun ye Yemuwɛli ye, ani Yamini, ani Owadi, ani Yakini, ani Sohari, ani Sawuli; Sawuli bamuso tun ye Kanaanaka le ye. ");
INSERT INTO dyu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi dencɛw tun ye Gɛrisɔn ye, ani Kehati, ani Merari. ");
INSERT INTO dyu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Zuda dencɛw tun ye Ɛri ye, ani Onan, ani Sela, ani Perɛsi, ani Zeraki. Nka Ɛri ni Onan sara Kanaana jamana ra. Perɛsi dencɛw tun ye Hɛsirɔn ni Hamuli ye. ");
INSERT INTO dyu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakari dencɛw tun ye Tola ye, ani Puva, ani Yasubu, ani Simirɔn. ");
INSERT INTO dyu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulɔn dencɛw tun ye Serɛdi ye, ani Elɔn, ani Yalɛli. ");
INSERT INTO dyu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Leya ka o denw le woro Yakuba ye, ka o to Mesopotami jamana ra, ani a denmuso Dina. A dencɛw ni a denmusow bɛɛ lajɛnnin tun ye mɔgɔ bisaba ni saba. ");
INSERT INTO dyu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadi dencɛw tun ye Sifiyɔn ye, ani Hagi, ani Suni, ani Ɛsibɔn, ani Ɛri, ani Arɔdi, ani Arɛli. ");
INSERT INTO dyu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asɛri dencɛw tun ye Imina ye, ani Isiva, ani Isivi, ani Beriya, ani o balemamuso Sera. Beriya dencɛw kɛra Hebɛri ye, ani Malikiyɛli. ");
INSERT INTO dyu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ayiwa, Olugu le ye Zilipa dencɛw ye, Laban tun ka o baaradenmuso min di a denmuso Leya ma. A ka o le sɔrɔ Yakuba fɛ. O bɛɛ lajɛnnin tun ye mɔgɔ tan ni wɔɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakuba ta muso Rasɛli dencɛw tun ye Yusufu ni Boniyaminu ye. ");
INSERT INTO dyu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Dencɛ fla worora Yusufu fɛ Misiran; o ye Manase ni Efirayimu ye. A muso Asanati le ka o woro a ye. Asanati tun ye Potifera denmuso le ye; Potifera le tun ye Ɔni dugu sarakalasebaga ye. ");
INSERT INTO dyu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Boniyaminu dencɛw tun ye Bela ye, ani Bekɛri, ani Asibɛli, ani Gera, ani Naaman, ani Ɛhi, ani Rɔsi, ani Mupimi, ani Hupimi, ani Aridi. ");
INSERT INTO dyu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Olugu le ye Rasɛli dencɛw ye, a ka minw woro Yakuba fɛ. O bɛɛ lajɛnnin tun ye mɔgɔ tan ni naani. ");
INSERT INTO dyu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan dencɛ ye Husimu ye. ");
INSERT INTO dyu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nɛfitali dencɛw ye Yasɛli ye, ani Guni, ani Yesɛri, ani Silɛmu. ");
INSERT INTO dyu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Olugu le ye Bila dencɛw ye, Laban tun ka o baaradenmuso min di a denmuso Rasɛli ma. A ka o dencɛw le woro Yakuba ye. O bɛɛ lajɛnnin tun ye mɔgɔ wolonfla. ");
INSERT INTO dyu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Mɔgɔ minw tagara Misiran ni Yakuba ye, a yɛrɛ denw, ani a mamadenw, o bɛɛ lajɛnnin tun ye mɔgɔ biwɔɔrɔ ni wɔɔrɔ. A dencɛw ta musow ma jate. ");
INSERT INTO dyu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ayiwa, dencɛ fla fana worora Yusufu fɛ Misiran; o cogo ra Yakuba ta mɔgɔ minw bɛɛ nana sigi ni a ye Misiran, o bɛɛ lajɛnnin tun ye mɔgɔ biwolonfla. ");
INSERT INTO dyu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ayiwa, Yakuba ka Zuda bla ka taga a yɛrɛ ɲa Misiran, Yusufu fɛ, ka taga a fɔ a ye ko ale bɛ nana Misiran, Gosɛni mara ra. ");
INSERT INTO dyu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu ka o mɛn minkɛ, a k’a ta sowotoro labɛn, ka taga Gosɛni, ka taga a facɛ Yakuba kunbɛn. A sera a facɛ ma minkɛ, a k’a boro mini a facɛ kan na, ka kasi ka mɛɛn. ");
INSERT INTO dyu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakuba ko Yusufu ma ko: «Sisan hali ni ne sara o tɛ baasi ye tuun. Sabu ne ka i ye, k’a ye ko i belen bɛ si ra.» ");
INSERT INTO dyu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu k’a fɔ a balemaw ni a facɛ ta somɔgɔ tɔw ye ko: «Ne bɛna taga a fɔ Farawona ye, k’a lasɔmi ko ne balemaw nana, ani ne facɛ ta mɔgɔ minw tun bɛ Kanaana jamana ra.» ");
INSERT INTO dyu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yusufu ko tuun ko: «Ne bɛna a fɔ Farawona ye ko ne ta mɔgɔw ye sagagbɛnbagaw le ye. O ta baara ye bɛganmara le ye. Ne bɛna a fɔ a ye ko aw nana ni aw ta sagaw ni aw ta baw ni aw ta misiw ye, ani aw borofɛnw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ni Farawona ka na aw wele ka aw ɲininka ko: ‹Aw bɛ mun baara le kɛ?› ");
INSERT INTO dyu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Aw ye a fɔ a ye ko: ‹I ta jɔnw bɛ bɛganw le mara kabini o denmisɛnman fɔ ka na se bi ma; anw ni an bɛmaw bɛɛ ka o le kɛ.› Ni o kɛra, a bɛna a to aw ye sigi Gosɛni mara ra, sabu Misirankaw bɛ ɲigi bɛganmarabagaw ra.» ");
INSERT INTO dyu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ayiwa, Yusufu tagara a fɔ Farawona ye ko: «Ne facɛ ni ne balemaw nana ka bɔ Kanaana jamana ra, ani o ta sagaw ni o ta baw, ni o ta misiw, ani o borofɛnw bɛɛ. O bɛ Gosɛni mara ra.» ");
INSERT INTO dyu_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yusufu tun bɛ ni a balemacɛ looru ye; a ka olugu yira Farawona ra. ");
INSERT INTO dyu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farawona k’a fɔ o ye ko: «Aw bɛ mun baara le kɛ?» O ka Farawona jaabi ko: «Anw ye bɛganmarabagaw le ye, i n’a fɔ an bɛmaw.» ");
INSERT INTO dyu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","O ko Farawona ma tuun ko: «An minw ye i ta jɔnw ye, anw nana ka na sigi i ta jamana ra, sabu anw ta jamana ra domunikɛyɔrɔ tɛ an ta bɛganw fɛ tuun. Kɔngɔ juguyara Kanaana jamana ra. A to an ye sigi Gosɛni mara ra. Anw ye i ta baaradenw le ye.» ");
INSERT INTO dyu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farawona ko Yusufu ma ko: «Ayiwa, i facɛ ni i balemaw nana i fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Misiran jamana ye nin ye i kɔrɔ; i facɛ ni i balemaw bla jamana yɔrɔ bɛɛ ra ɲumanman na, Gosɛni mara ra; ni i ka dɔw sɔrɔ i balemaw ra fana minw ka baara lɔn kosɛbɛ, i ye olugu bla ne yɛrɛ ta sagaw kunna o ye o kɔrɔsi.» ");
INSERT INTO dyu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusufu nana ni a facɛ Yakuba fana ye ka na a yira Farawona ra. Yakuba ka Farawona fo kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farawona ka Yakuba ɲininka ko: «Ele si ye san jori ye sisan?» ");
INSERT INTO dyu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakuba k’a jaabi ko: «Ne si ye san kɛmɛ ni san bisaba. Ne ka o le kɛ yaala ra. Ne ma san caman sɔrɔ, ne ta ɲanamanya fana gbɛlɛyara. Ne tɛna se ka sijan sɔrɔ, i n’a fɔ ne bɛmaw ka min sɔrɔ ka o to yaala ra jamana kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakuba ka o fɔ minkɛ, a ka dugawu kɛ Farawona ye tuun ka sɔrɔ ka taga. ");
INSERT INTO dyu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufu ka yɔrɔ dɔ di a facɛ ni a balemaw ma Misiran jamana ra, i n’a fɔ Farawona tun k’a fɔ a ye cogo min na; a ka jamana yɔrɔ bɛɛ ra ɲumanman di o ma, Ramusɛsi mara ra. ");
INSERT INTO dyu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufu ka domuni di a facɛ ni a balemaw ma, ani a facɛ ta somɔgɔw bɛɛ ma, ka kaɲa ni o ta gbamɔgɔw hakɛya ye. ");
INSERT INTO dyu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ayiwa, domuni foyi tun tɛ sɔrɔra Misiran jamana ra tuun; kɔngɔ tun juguyara kosɛbɛ. Misiran jamana ni Kanaana jamana mɔgɔw bɛɛ baraka tun bɛ dɛsɛra kɔngɔ boro fɔ ka o fasa. ");
INSERT INTO dyu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu ka siman fiyeere o ma, ka Misiran jamana ni Kanaana jamana wari bɛɛ mina k’a bla Farawona ta so. ");
INSERT INTO dyu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Misiran jamana ni Kanaana jamana wari bɛɛ nana ban tuma min na, Misirankaw bɛɛ nana Yusufu fɛ ka na a fɔ a ye ko: «Domuni di an ma; kana sɔn k’a to an ye faga i kɔrɔ. Wari foyi le tɛ an boro tuun.» ");
INSERT INTO dyu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu ko o ma ko: «Ni wari tɛ aw fɛ, aw ye na ni aw ta bɛganw ye. Aw ye na aw ta bɛganw falen ne fɛ siman na.» ");
INSERT INTO dyu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","O nana ni o ta bɛganw ye Yusufu fɛ. Yusufu ka o ta sow, ni o ta sagaw, ni o ta baw, ni o ta misiw, ni o ta faliw falen siman na. ");
INSERT INTO dyu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","O san nana ban minkɛ, o nana Yusufu fɛ tuun ka na a fɔ a ye ko: «An matigicɛ, an ta wari banna; an nana ni an ta bɛganw bɛɛ ye i fɛ fana. An tɛna a dogo i ma, ko foyi wɛrɛ le tɛ an fɛ tuun k’a di i ma, ni an yɛrɛ ni an ta dugukolow tɛ. ");
INSERT INTO dyu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","I kana sɔn k’a to an ye faga i kɔrɔ, ka an ta dugukolow lakolon to yi. An ni an ta dugukolow san, ka siman di an ma. O ra an ni an ta dugukolo bɛɛ bɛ kɛ i ta ye. Siman di an ma an ye a dan, janko an ye baro, an kana sa kɔngɔ boro, ka an ta dugukolow lakolon to.» ");
INSERT INTO dyu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yusufu ka Misiran dugukolo bɛɛ san Farawona ye. Kɔngɔ gbankojugu o ra, Misirankaw ka o ta forow bɛɛ fiyeere. Jamana bɛɛ kɛra Farawona ta ye. ");
INSERT INTO dyu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","O cogo ra Misiran jamana mɔgɔw bɛɛ kɛra Farawona ta jɔnw ye, k’a ta jamana kun kelen na, ka taga a bla a kun dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Dugukolo min tora ni a ma san, o kɛra sarakalasebagaw ta le ye. A ma olugu ta san, sabu Farawona tun ka sariya dɔ sigi sarakalasebagaw kosɔn; Farawona tun bɛ min di sarakalasebagaw ma, o tun bɛ baro o le ra. O kosɔn olugu ma o ta dugukolo fiyeere. ");
INSERT INTO dyu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusufu k’a fɔ mɔgɔw ye ko: «Ne ka aw ni aw ta dugukolow san bi Farawona ye. Ne bɛ siman di aw ma, aw ye taga a dan aw ta forow ra. ");
INSERT INTO dyu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Nka ni simantigɛwagati sera, aw bɛna siman taran k’a kɛ sigiyɔrɔma looru, k’a taran kelen di Farawona ma. A taran naani tɔ, aw bɛ o dɔ kɛ si ye, ka dɔ kɛ aw ni aw denw, ni aw ta somɔgɔ tɔw ta baro ye.» ");
INSERT INTO dyu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","O ka Yusufu jaabi ko: «An matigicɛ, i ka an kisi. Ayiwa, i n’a fɔ i ka o koɲumanba kɛ an ye, o tuma, an bɛna kɛ Farawona ta jɔnw ye.» ");
INSERT INTO dyu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusufu ka o sariya sigi Misiran jamana bɛɛ kan, ko san o san Misiran siman ka kan ka taran sigiyɔrɔma looru, k’a taran kelen kɛ Farawona ta ye. O sariya bɛ yi fɔ bi. Sarakalasebagaw dɔrɔn ta dugukolow le ma kɛ Farawona ta ye. ");
INSERT INTO dyu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ayiwa, Izirayɛlimɔgɔw sigira Misiran jamana ra, Gosɛni mara ra. O borofɛnw nana caya, o ka den caman sɔrɔ fana. ");
INSERT INTO dyu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakuba ka san tan ni wolonfla le kɛ Misiran jamana ra. A si bɛɛ lajɛnnin kɛra san kɛmɛ ni san binaani ni san wolonfla. ");
INSERT INTO dyu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","A sawagati sera minkɛ, a k’a dencɛ Yusufu wele, k’a fɔ a ye ko: «Ni ne ko ka di i ye, o tuma i boro la ne woto kɔrɔ, ka kari, ko i bɛna koɲuman kɛ ne ye, ka kɛ kankelentigi ye ni ne ye, ko i tɛna ne su don Misiran yan. ");
INSERT INTO dyu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ni ne sara tuma min na, ka taga fara ne bɛmaw kan, i ye ne ta ka bɔ Misiran, ka taga ne su don ne bɛmaw ta kaburu yɔrɔ ra.» Yusufu ko: «I ka min fɔ, ne bɛna o kɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakuba ko: «O tuma, kari ne ye.» Yusufu karira. O kɔ, Yakuba k’a kinbiri gban a ta lanan kunyanfan fɛ ka Ala bato. ");
INSERT INTO dyu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Wagati dama tɛmɛnin kɔ, o nana a fɔ Yusufu ye ko a facɛ man kɛnɛ. Yusufu k’a dencɛ fla ta, Manase ni Efirayimu, ka taga a facɛ kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","A fɔra Yakuba ye minkɛ ko a dencɛ Yusufu bɛ nana a fɛ, a jijara ka wuri ka sigi a ta lanan kan. ");
INSERT INTO dyu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakuba ko Yusufu ma ko: «Ala Sebɛɛtigi k’a yɛrɛ yira ne ra Luzi, Kanaana jamana ra, ka baraka don ne ra. ");
INSERT INTO dyu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","A k’a fɔ ne ye ko: ‹Ne bɛna den caman di i ma, ka i ta mɔgɔw caya, ka o kɛ siya caman ye, ka nin jamana di i ta duruja ma i kɔ fɛ, a bɛ kɛ o ta ye wagati bɛɛ.› » ");
INSERT INTO dyu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakuba ko Yusufu ma tuun ko: «I ka dencɛ fla min sɔrɔ Misiran jamana ra yan, sani ne ye na i fɛ yan, Efirayimu ni Manase, olugu bɛna kɛ ne ta denw le ye. O bɛna kɛ ne ta le ye i n’a fɔ Rubɛn ni Simeyɔn ye ne ta ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","«Nka i ka den minw sɔrɔ olugu kɔ fɛ, olugu bɛna kɛ i yɛrɛ ta ye. O bɛna o ta cɛn sɔrɔ Efirayimu ni Manase sababu le ra. ");
INSERT INTO dyu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ne bɛ o kɛra Rasɛli le kosɔn. Sabu ne sekɔtɔ ka bɔ Mesopotami jamana ra, Rasɛli sara ne fɛ sira ra Kanaana jamana ra, Efirata dugu kɛrɛ fɛ. Ne k’a su don o yɔrɔ ra, Efirata dugu sira ra, Efirata min bɛ wele fana ko Bɛtilɛhɛmu.» ");
INSERT INTO dyu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakuba ka Yusufu ta denw ye minkɛ, a ko: «Ninnugu ye jɔnw le ye!» ");
INSERT INTO dyu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu ko: «Ala ka dencɛ fla min di ne ma yan, olugu lo.» Yakuba ko: «Sabari ka o gbara ne ra yan, janko ne ye dugawu kɛ o ye.» ");
INSERT INTO dyu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakuba ɲa baraka tun dɔgɔyara kɔrɔya fɛ. A tun tɛ yeri kɛra bɛrɛbɛrɛ tuun. Yusufu k’a denw gbara Yakuba ra. Yakuba ka o ta ka o sigi a sen kan, k’a boro mini o ma ni kanuya ye. ");
INSERT INTO dyu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","A k’a fɔ Yusufu ye ko: «Ne tun tɛ a miiri ko ne ɲa bɛna la ele kan tuun. Nka a ye nin ye, Ala nana a kɛ fɔ ne ka i ta denw yɛrɛ ye.» ");
INSERT INTO dyu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusufu ka denw ta ka o bɔ a facɛ sen kan, ale yɛrɛ k’a kinbiri gban dugu ma, a facɛ kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","O kɔ, a k’a dencɛ Efirayimu bla a kininboroyanfan fɛ, ka Manase bla a numanboroyanfan fɛ. A gbarara ni o ye a facɛ ra, ka Efirayimu lɔ a facɛ numanboroyanfan fɛ, ka Manase lɔ a kininboroyanfan fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Nka a facɛ Yakuba k’a borow bananbiri, k’a kininboro la Efirayimu kun na, k’a sɔrɔ ale le ye dɔgɔcɛman ye, k’a numanboro la kɔrɔcɛman Manase kun na. ");
INSERT INTO dyu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Yakuba ka dugawu kɛ Yusufu ye. A ko: «Ne bɛmacɛ Iburahima ni ne facɛ Isiyaka ka Ala min bato, ale Ala min blara ne ɲa kabini ne worolon, fɔ ka na se bi ma, ale ye baraka don nin denw na. ");
INSERT INTO dyu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mɛlɛkɛ min ka ne bɔsi kojugu bɛɛ ma, o mɛlɛkɛ ye baraka don nin denw na. Nin denw sababu ra ne tɔgɔ kana tunu; ne bɛmacɛ Iburahima ni ne facɛ Isiyaka tɔgɔ kana tunu, o ta duruja ye caya jamana kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ayiwa, Yusufu k’a ye ko a facɛ k’a kininboro la Efirayimu le kun na minkɛ, o ma diya a ye, a k’a facɛ boro mina ka bɔ Efirayimu kun na, ka taga ni a ye a dencɛ fɔlɔ Manase fan fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","A k’a fɔ a facɛ ye ko: «Baba, i firira, nin le ye dencɛ fɔlɔ ye. I tun ka kan ka i kininboro la ale le kun na.» ");
INSERT INTO dyu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nka a facɛ ma sɔn. A ko: «Ne dencɛ, ne k’a lɔn cɔ. Ne k’a lɔn ko Manase fana ta duruja bɛna caya ka kɛ siya dɔ ye; a fana bɛna bonya, nka a dɔgɔcɛ bɛna bonya ka tɛmɛ a kan. A dɔgɔcɛ ta siya le bɛna caya ka kɛ siya camanba ye.» ");
INSERT INTO dyu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Yakuba ka dugawu kɛ o ye o lon na. A ko: «Izirayɛlimɔgɔw bɛna aw tɔgɔ le ta ka dugawu kɛ ni a ye. O bɛna a fɔ mɔgɔw ma ko: ‹Ala ye baraka don aw ra, i n’a fɔ a ka baraka don Efirayimu ni Manase ra cogo min na.› » Yakuba ka Efirayimu bla Manase ɲa fɛ o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","O kɔ, a k’a fɔ Yusufu ye ko: «Ne bɛna sa, nka Ala bɛna to ni aw ye. A bɛna kɔsegi ni aw ye aw bɛmaw ta jamana ra.» ");
INSERT INTO dyu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","A ko Yusufu ma tuun ko: «Ne bɛna i ta cɛn caya ka tɛmɛ i balemaw ta kan. Ne bɛ Sikɛmu mara di i ma. Ne ka Amɔrikaw kɛrɛ le ni ne ta kɛrɛkɛmuru ni ne ta kalan ye, ka o yɔrɔ mina o ra.» ");
INSERT INTO dyu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","O kɔ, Yakuba k’a dencɛw bɛɛ wele k’a fɔ o ye ko: «Aw ye na lajɛn ne kɔrɔ, ne bɛna aw ta duruja nataw ta kow fɔ aw ye.» ");
INSERT INTO dyu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","A ko: «Aw ye na lajɛn ka mɛnni kɛ, Yakuba dencɛw! Aw ye na aw facɛ Izirayɛli lamɛn. ");
INSERT INTO dyu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubɛn, ne dencɛ fɔlɔ, ele ye ne ta baraka ye, ne kanbelenman kɔnna ka den fɔlɔ min woro. I ta bonya tɛmɛna bɛɛ ta kan, i baraka fana tɛmɛna bɛɛ ta kan. ");
INSERT INTO dyu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nka i ma ɲamalɔ; i bɛ i ko jiba woyotɔ min bɛ lamaga; o ra, i tɛna ɲafɛyɔrɔ sɔrɔ dɛ! Sabu i yɛlɛnna i facɛ ta lanan kan, i yɛlɛnna ne ta lanan kan, ni ne muso ye. ");
INSERT INTO dyu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Ayiwa, Simeyɔn ni Levi ye mɔgɔ suguya kelen ye. O ta muruw ye kojugukɛfɛnw le ye. ");
INSERT INTO dyu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O ka jɛn min siri, ne tɛ ni o ye o ra; ne tɛ ni o ye o ta jɛn ra fiyewu! Sabu dimi kosɔn o ka mɔgɔ faga, o ta juguya kosɔn, o toronkɛtɔ, o ka mɔgɔw ta misitoranw senfasaw tigɛ. ");
INSERT INTO dyu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ala ye o ta dimi danga, sabu o le ka o bla kojugu ra. Ala ye o ta fariya danga, sabu o le ka o kɛ hinabariw ye. Ne bɛna o ta denw faran ka o bɔ ɲɔgɔn na Izirayɛli ta jamana ra, ka o yɛrɛgɛ ka taga jamana yɔrɔ bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«Ayiwa, Zuda, ele balemaw bɛna ele le bonya. I bɛna i boro la i juguw tɔn kan, ka o kun biri fanga ra. I fadenw fana bɛna o kinbiri gban i kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Zuda bɛ i ko jarakanbelen le. Ne dencɛ, i bɔra fagarikɛyɔrɔ ra ka na! A bɛ a kinbiri turu, ka la i ko jara, i ko jaraba. Jɔn le bɛ sɔn k’a lawuri! ");
INSERT INTO dyu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Masacɛbere tɛna mabɔ Zuda ta gba ra fiyewu. Kuntigiya bere tɛna bɔ a boro ka ye, fɔ ka taga se kotigi yɛrɛ nawagati ma. Siyaw bɛɛ bɛna o yɛrɛ majigi ale le ye. ");
INSERT INTO dyu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Rɛzɛn bɛna caya fɔ a bɛ a ta fali siri rɛzɛnsun le ra, k’a ta falimuso den siri rɛzɛnsunw bɛɛ ra ɲumanman na. A bɛ a ta derege ko rɛzɛnji le ra, k’a ta deregeba ko rɛzɛnji ra. ");
INSERT INTO dyu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Rɛzɛnji bɛ a ɲa manamana tuma bɛɛ, nɔnɔ bɛ a ɲinw gbɛ a da ra. ");
INSERT INTO dyu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Zabulɔn sigiyɔrɔ bɛna kɛ kɔgɔjida le ra, kurunbaw lɔyɔrɔ le bɛna kɛ a sigiyɔrɔ ye. A ta mara dan bɛna se fɔ Sidɔn dugu fan na. ");
INSERT INTO dyu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Isakari ye fali barakaman le ye, a bɛ la bɛganw siyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A k’a ye ko a layɔrɔ laganfiyanin bɛ minkɛ, ko a yɔrɔ cɛ ka ɲi minkɛ, a tora yi kunkelen. A k’a kɔ bla donita kama, fɔ ka na kɛ tɔw ta jɔn ye, ka jagboyabaaraw kɛ tɔw ye. ");
INSERT INTO dyu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Dan le bɛna sigi a ta mɔgɔw kunna ka o kiti tigɛ, ka kɛ i n’a fɔ Izirayɛli ta gba tɔw. ");
INSERT INTO dyu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan ye sa le ye, min bɛ la sira ra. Fɔnfɔnnin lo, min bɛ la mɔgɔw ɲa siradennin kan. A bɛ sow kin o sen na, fɔ sotigi bɛ yɛlɛma ka ben dugu ma. ");
INSERT INTO dyu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«E! Matigi Ala, ne jigi bɛ i ta dɛmɛri kan. ");
INSERT INTO dyu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«Gadi, mɔgɔ dɔw bɛna jɛn ka na ben i kan ko o bɛ i kɛrɛ, nka ele bɛna ben o kan ka o gbɛn. ");
INSERT INTO dyu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«Asɛri, domunifɛn ɲumanman bɛna sɔrɔ i ta jamana le ra; ele le bɛna domuniɲumanw di masacɛw ma. ");
INSERT INTO dyu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«Nɛfitali bɛ i ko dagbɛ, min bɛ a yɛrɛ ma; a bɛ denɲumanw le woro. ");
INSERT INTO dyu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«Yusufu bɛ i ko yiridenta min bɛ wurira kura ye, yiridenta min bɛ bununda ra. A yiriborow bɛ janya fɔ ka tɛmɛ kogo kunna. ");
INSERT INTO dyu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kalantigiw tugura a nɔ fɛ; o k’a bon ni o ta biɲɛw ye, o gbanna a ra kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Nka ale ta kalan tora a boro; Yakuba ta Ala fangatigi ka fanga don a borow ra. Ale Ala le ye Izirayɛli kɔrɔsibaga ye, ani Izirayɛli ta Ala barakaman. ");
INSERT INTO dyu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","I facɛ ta Ala, ale bɛna i dɛmɛ. Ala Sebɛɛtigi le bɛna baraka don i ra, ka sankolo ta baraka di i ma, ka dugukolo ta baraka di i ma, ka baraka don musow ra, ka denworo nɔgɔya o ye, ka baraka don bɛganw fana ra, ka o caya. ");
INSERT INTO dyu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","I facɛ ta dugawu tɛmɛna kuru banbariw ta kan; o dugawuw bɛna to i kan, ka mɛɛn, fɔ ka tɛmɛ kuruw si kan, kuru minw danna kabini fɔlɔfɔlɔ. O dugawu ye kɛ Yusufu kan, o dugawu bɛɛ ye to Yusufu kan, ale min kɛra a balemaw ta kuntigi ye. ");
INSERT INTO dyu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Boniyaminu ye wara le ye, a bɛ sogo mina k’a faga. Sɔgɔmada fɛ a bɛ sogo dɔ ɲimi, wulada fɛ, a ka min mina, a bɛ o taran.» ");
INSERT INTO dyu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ayiwa, Izirayɛli ta gba tan ni fla le ye nin mɔgɔw ye. O facɛ ka nin cirayakumaw le fɔ o ye, a dugawukɛtɔ. A ka dugawu kɛ o ye, bɛɛ ni i ta dugawu. ");
INSERT INTO dyu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ayiwa, o kɔ, Yakuba k’a fɔ a dencɛw ye ko: «Ne bɛna sa ka taga ne ta bɛmaw fɛ. Ni ne ka sa, kuruwo min bɛ Hɛtikacɛ Efurɔn ta foro ra, aw ye taga ne su don yi, ne ta bɛmaw kɛrɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","O kuruwo bɛ Makipela ta foro ra, Mamire ta yɔrɔ kɔrɔ, Kanaana jamana ra. Iburahima ka o foro le san Hɛtikacɛ Efurɔn fɛ, k’a kɛ sudonyɔrɔ ye. ");
INSERT INTO dyu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Iburahima ni a muso Saran su donna yi le. Isiyaka ni a muso Rebeka fana su donna yi. Ne le ka Leya su don yi fana. ");
INSERT INTO dyu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","O foro ni o kuruwo bɛɛ sanna Hɛti ta mɔgɔw fɛ.» ");
INSERT INTO dyu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ayiwa, Yakuba ka o kuma fɔ ka ban minkɛ, a k’a senw layɛlɛn lanan kan, ka la. A sara ka taga a bɛmaw fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusufu k’a ye ko a facɛ sara minkɛ, a facɛ kanuya kosɔn, a ka ɲa biri a facɛ ɲada kan, k’a boro mini a kan na, ka kasi. ");
INSERT INTO dyu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Flakɛbaga minw tun bɛ baara kɛ a ye, a k’a fɔ olugu ye ko o ye a facɛ su labɛn ka ɲa ni kasatigɛnan ye. Flakɛbagaw k’a su labɛn ni kasatigɛnan ye. ");
INSERT INTO dyu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","O k’a labɛn ka se fɔ tere binaani. Misirankaw k’a su kasi fɔ tere biwolonfla. ");
INSERT INTO dyu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","O sukasilonw dafara minkɛ, Yusufu k’a fɔ Farawona ta somɔgɔw ye ko: «Ni can ra ne ko ka di aw ye, aw ye taga kuma Farawona fɛ ne ye. Aw ye a fɔ a ye ko, ");
INSERT INTO dyu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","sani ne facɛ ye sa, a tun k’a fɔ ne ye ko ne ye kari ale ye, ko ni ale nana sa, ale tun ka kaburu min san Kanaana jamana ra, ko ne ye taga ale su don yi. O kosɔn ne b’a fɛ ka taga ne facɛ su don, ka sekɔ ka na.» ");
INSERT INTO dyu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ayiwa, o kuma sera Farawona ma minkɛ, Farawona k’a fɔ Yusufu ye ko: «Taga i facɛ su don i n’a fɔ i karira a ye cogo min na.» ");
INSERT INTO dyu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yusufu tagatɔ a facɛ sudonyɔrɔ ra, Farawona ta jamana ɲamɔgɔw bɛɛ tagara a blasira, ani Farawona ta cɛkɔrɔbaw, ani Misiran jamana cɛkɔrɔba tɔw bɛɛ, ");
INSERT INTO dyu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ani Yusufu ta somɔgɔw bɛɛ, ani a balemaw, ani a facɛ ta somɔgɔw bɛɛ. Denmisɛnw, ani sagaw ni baw, ani misiw dɔrɔn le tora Gosɛni mara ra yi, Misiran jamana ra. ");
INSERT INTO dyu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sowotorotigiw, ani sotigiw fana tun bɛ ni o ye. Jama caman le tun bɛ ɲɔgɔn kɔ ka taga. ");
INSERT INTO dyu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kɛnɛgbɛ min tɔgɔ ye ko Atadi, o sera o yɔrɔ ra minkɛ, Zuridɛn kɔba kɔ fɛ, o ka sukasi kɛ, ka kulekanbaw bɔ o yɔrɔ ra. Yusufu ka tere wolonfla le bla k’a facɛ sanga kɛ. O k’a facɛ sanga kɛ o yɔrɔ ra k’a su kasi. ");
INSERT INTO dyu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kanaanaka minw bɛ o jamana ra, olugu ka o sanga ko ye Atadi kɛnɛgbɛ ra, o ko: «Nin kɛra sangaba ye Misirankaw fɛ dɛ!» O le kosɔn, o ka o yɔrɔ tɔgɔ la ko: Abɛli Misirayimu; o yɔrɔ bɛ Zuridɛn ba kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","O cogo ra, Yakuba satɔ tun ka min fɔ a ta sanga ko ra, a dencɛw ka o kɛ. ");
INSERT INTO dyu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","O tagara ni a su ye Kanaana jamana ra. Kuruwo min bɛ Makipela foro ra, o tagara a su don yi. Iburahima tun ka o yɔrɔ le san Hɛtikacɛ Efurɔn fɛ, k’a kɛ sudonyɔrɔ ye; a bɛ Mamire ta yɔrɔ kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusufu k’a facɛ su don ka ban minkɛ, a sekɔra Misiran, ani a balemaw, ani minw bɛɛ tun tagara ni a ye a facɛ sudonyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ayiwa, Yusufu balemaw k’a ye ko o facɛ sara minkɛ, o ko: «Ni Yusufu ka wuri an kama sisan do! An ka kojugu min kɛ a ra, ni a ko a bɛ o juru sara an na do!» ");
INSERT INTO dyu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","O ka mɔgɔ ci ka taga a fɔ Yusufu ye ko: «Sani i facɛ ye sa, a tun k’a fɔ ko ");
INSERT INTO dyu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","an ye kuma i fɛ, ko i ye sabari ka i balemaw ta hakɛ ni o ta jurumun yafa o ma, sabu o ka kojugu le kɛ i ra.» O ko Yusufu ma ko: «An ye i facɛ ta Ala ta jɔnw le ye; sabari ka an ta hakɛw yafa an ma.» Yusufu ka o kuma mɛn minkɛ, a kasira. ");
INSERT INTO dyu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","A kɔrɔcɛw yɛrɛ nana o kinbiri gban a kɔrɔ; o ko: «Anw ye i ta jɔnw le ye.» ");
INSERT INTO dyu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yusufu ko o ma ko: «Aw kana siran. Ala ka min latigɛ, o le kɛra. ");
INSERT INTO dyu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Aw tun b’a fɛ ka kojugu le kɛ ne ra, nka Ala k’a yɛlɛma k’a kɛ koɲuman ye, k’a laban kɛ nin ye bi, janko ka mɔgɔ caman kisi. ");
INSERT INTO dyu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","O ra, aw kana siran, ne bɛna ne janto aw ra, aw ni aw ta denw bɛɛ.» Yusufu kumana o fɛ, ni kanuya ye, ka o jusu saaro. ");
INSERT INTO dyu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","O kɔ, Yusufu ni a facɛ ta somɔgɔw tora Misiran. Yusufu si tun ye san kɛmɛ ni tan. ");
INSERT INTO dyu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","A k’a dencɛ Efirayimu ta denw ye, ka Efirayimu mamadenw fana ye. A dencɛ Manase dencɛ Makiri, o ta denw worora minkɛ, Yusufu ka olugu kɛ a yɛrɛ ta denw ye. ");
INSERT INTO dyu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Lon dɔ, Yusufu k’a fɔ a balemaw ye ko: «Ne bɛna sa, nka sigiya t’a ra, Ala bɛna a janto aw ra, ka aw labɔ nin jamana ra yan. A ka layiri ta ko a bɛ jamana min di an bɛmaw Iburahima, ani Isiyaka, ani Yakuba ma, a bɛna taga ni aw ye o jamana ra.» ");
INSERT INTO dyu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","O kɔ, Yusufu k’a fɔ a balemaw ye ko: «Aw ye kari ne ye, ko ni Ala nana aw labɔ Misiran, aw tagatɔ, aw ye taga ni ne kolow ye ka bɔ Misiran.» ");
INSERT INTO dyu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ayiwa, Yusufu nana sa k’a si to san kɛmɛ ni tan. O k’a su labɛn ni kasatigɛnan ye k’a bla kɛsu dɔ kɔnɔ Misiran.");
INSERT INTO dyu_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ayiwa, Izirayɛlimɔgɔ minw tagara Misiran ni o facɛ Yakuba ye, o ni o ta gbaw, olugu tɔgɔw ye nin ye: ");
INSERT INTO dyu_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubɛn, Simeyɔn, Levi, Zuda, ");
INSERT INTO dyu_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Zabulɔn, Boniyaminu, ");
INSERT INTO dyu_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Nɛfitali, Gadi, Asɛri. ");
INSERT INTO dyu_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yakuba ta denw ni a ta mamadenw bɛɛ lajɛnnin tun ye mɔgɔ biwolonfla. Olugu tun nana a sɔrɔ Yusufu bɛ Misiran ka ban. ");
INSERT INTO dyu_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ayiwa, Yusufu nana sa. A balema tɔw bɛɛ nana sa fana, ani minw bɛɛ tun ye o wagati ta mɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Izirayɛlimɔgɔw ka den caman sɔrɔ. O cayara minkɛ, dɔ ka kɛ fara ye o ta fanga kan fana lon o lon. A kɛra ten minkɛ, Misiran jamana fara Izirayɛlimɔgɔw ra. ");
INSERT INTO dyu_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ayiwa, o kɔ, masacɛkura dɔ nana sigi masaya ra Misiran; ale tun ma dɔ lɔn Yusufu ta ko ra. ");
INSERT INTO dyu_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","O masacɛ k’a fɔ a ta mɔgɔw ye ko: «Aw m’a ye, Izirayɛlimɔgɔw cayara ni an ye sisan dɛ! O fanga fana bonyara ni an ta ye. ");
INSERT INTO dyu_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ayiwa, aw y’a to an ye cogo ɲini a ko ra, ka o bari janko o kana kɛ caya ye tuun; ni o tɛ, ni an nana kɛrɛ sɔrɔ ni an jugu dɔw ye, o bɛ sɔn ka fara an juguw kan ka an kɛrɛ, ka sɔrɔ ka bori ka bɔ jamana kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ayiwa, a kɛra ten minkɛ, o ka jagboyabaaraw la Izirayɛlimɔgɔw kan, ka kuntigi dɔw bla o kunna ko o ye o kɔrɔsi, ani ka o ɲagban kosɛbɛ ni o jagboyabaaraw ye. Izirayɛlimɔgɔw ka Pitɔmu dugu ni Ramusɛsi dugu lɔ o cogo le ra, ka o kɛ masacɛ Farawona ta fɛnmarayɔrɔw ye. ");
INSERT INTO dyu_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nka o tun bɛ o ɲagbanna cogo min na ni jagboyabaaraw ye, o fana tun bɛ cayara ka taga ten le. A kɛra ten, Izirayɛlimɔgɔw ta ko ka siranya bla Misirankaw ra kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Misirankaw ka dɔ fara o ta baaraw kan, ka o jɔnyamina. ");
INSERT INTO dyu_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","O ka o tɔɔrɔ fɔ k’a dama tɛmɛ, ka baarajugu suguya bɛɛ la o kan: o tun bɛ bɔgɔ nɔɔni, ka biriki bɔ, ka forobaaraw fana kɛ. O tun bɛ o jagboyabaaraw bɛɛ la o kan hali o tɛ hina o ra. ");
INSERT INTO dyu_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ayiwa, lon dɔ Misiran masacɛ kumana Heburuw ta tinminamuso fla fɛ. O muso kelen tɔgɔ tun ye ko Sifira, tɔ kelen tɔgɔ tun ye ko Puwa. ");
INSERT INTO dyu_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","A ko o ma ko: «Ni Izirayɛlimuso dɔ bɛ jigira aw boro tuma o tuma, aw ye den bɔtɔ kɔrɔsi. Ni cɛ lo, aw ye a faga; ni muso lo aw y’a to yi, aw kana a faga.» ");
INSERT INTO dyu_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Nka tinminamusow siranna Ala ɲa. Misiran masacɛ ka min fɔ, o ma sɔn ka o kɛ. O ka cɛdenw ɲanaman to. ");
INSERT INTO dyu_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Masacɛ ka tinminamusow wele ka o ɲininka. A ko: «Aw ka mun le kɛ tan? Mun na aw ka Izirayɛlimɔgɔw ta cɛdenw to yi, aw ma o faga?» ");
INSERT INTO dyu_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tinminamusow ka Farawona jaabi ko: «Izirayɛlimusow tɛ i ko Misirankamusow; baraka bɛ o ra kosɛbɛ. Sani tinminamuso ye na, o bɛ jigi.» ");
INSERT INTO dyu_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ayiwa, dɔ farara Izirayɛlimɔgɔw kan, o cayara, ka baraka sɔrɔ. Ala ka baraka don tinminamusow ra, o ta kɛwale kosɔn. ");
INSERT INTO dyu_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Tinminamusow siranna Ala ɲa, o ma sɔn ka denw faga minkɛ, o kosɔn Ala ka baraka don o ra, ka denw di olugu fana ma. ");
INSERT INTO dyu_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ayiwa, Farawona k’a ye ten minkɛ, a k’a fɔ a ta mɔgɔw ye ko o ye to ka Izirayɛlimɔgɔw ta denɲɛnin cɛmaninw bɛɛ firi Nili ba ji ra; ko o ye musodenw dɔrɔn le to yi. ");
INSERT INTO dyu_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ayiwa, o wagati ra Levi ta gbamɔgɔ dɔ tun ka muso dɔ furu; o muso tun ye o yɛrɛ ta gbamɔgɔ dɔ le ye. ");
INSERT INTO dyu_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Muso nana kɔnɔ ta, ka dencɛ woro; o k’a ye ko den cɛ ka ɲi; o siranna, o ka den dogo, ka se fɔ karo saba. ");
INSERT INTO dyu_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Nka den nana kɛ a tɛ se ka dogo tuun minkɛ, a bamuso ka segi dɔ lalaga ni kɔdarabin dɔw ye, ka mananji ni yiriji dɔ kɛ k’a mun janko ji kana don a kɔnɔ. A ka den la o kɔnɔ, ka taga a bla Nili bada ra, binw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Den kɔrɔmuso tagara lɔ ka kɛ den kɔrɔsi ye, k’a flɛ min bɛna kɛ den na. ");
INSERT INTO dyu_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Dɔɔnin kɛra, Farawona denmuso nana ba ra, ko a bɛna ko. A tɔɲɔgɔn minw tun nana ni a ye, olugu tun bɛ yaalayaalara bada ra. Farawona denmuso nana segi ye binw cɛ ra. A k’a ta baaradenmuso dɔ ci ka taga a ta. ");
INSERT INTO dyu_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Baaradenmuso nana ni segi ye minkɛ, Farawona denmuso k’a dayɛlɛ ka cɛdennin dɔ ye a kɔnɔ, a bɛ kasira. Den makari k’a mina. A ko: «E! Nin ye Heburu dɔw ta den le ye tan.» ");
INSERT INTO dyu_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Denɲɛnin kɔrɔmuso gbarara Farawona denmuso ra. A k’a fɔ a ye ko: «I tɛ a to ne ye taga Heburukamuso dɔ ɲini i ye, a bɛna den lamɔ i ye, ka to ka sin di a ma wa?» ");
INSERT INTO dyu_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Farawona denmuso ko: «Taga.» Sungurunin tagara den bamuso yɛrɛ le wele ka na. ");
INSERT INTO dyu_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Den bamuso nana minkɛ, Farawona denmuso ko a ma ko: «Den nin ta, i ye to ka sin di a ma. Ne yɛrɛ le bɛna i sara.» Muso ka den ta ka taga ni a ye. ");
INSERT INTO dyu_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Den nana kɔrɔ dɔɔnin minkɛ, muso tagara ni a ye Farawona denmuso fɛ. Den kɛra i n’a fɔ Farawona denmuso yɛrɛ dencɛ. A ko: «Ne bɛ a tɔgɔ la ko Musa; sabu ne k’a labɔ ji ra le.» ");
INSERT INTO dyu_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ayiwa, Musa nana kɔrɔya minkɛ, lon dɔ a tagara a balema Heburuw fɛ, ka taga o ye o ta jagboyabaaraw ra. A nana Misirankacɛ dɔ ye a bɛ a balema Heburu dɔ bugɔra. ");
INSERT INTO dyu_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa ka yɔrɔw flɛflɛ a ma mɔgɔ ye minkɛ, a ka Misirankacɛ faga, k’a su dogo kɛnkɛnmugu jukɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","O dugusagbɛ, Musa tagara tuun. A tagara bɔ Heburu fla kan, o bɛ kɛrɛra. Jo tun tɛ min fɛ, a ko o ma ko: «Mun na i bɛ i balemacɛ bugɔra?» ");
INSERT INTO dyu_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Cɛ ko Musa ma ko: «Jɔn le ka ele sigi anw kunna ka i kɛ anw ta kititigɛbaga ye? O tuma i b’a fɛ ka ne faga le fana i ko i ka Misirankacɛ faga cogo min na kɛ?» Musa ka o mɛn minkɛ, a siranna. A ko: «Sigiya t’a ra, i b’a sɔrɔ a ko lɔnna.» ");
INSERT INTO dyu_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ayiwa, Musa ka cɛ min faga, o ko sera masacɛ Farawona ma. Farawona dimina, ko a bɛ Musa faga. Musa borira o le ra Farawona ɲa, ka taga dogo Madiyan jamana ra. A tagara se kɔlɔn dɔ kɔrɔ, ka lɔ o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ayiwa, denmuso wolonfla tun bɛ Madiyan jamana sarakalasebaga Zetoro fɛ. Olugu nana kɔlɔnda ra ka na ji bi. O ka ji bi ka bɛganw ta jiminminan fa, ko o bɛ a di o facɛ ta bɛganw ma. ");
INSERT INTO dyu_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","O wagati ra, sagagbɛnbaga dɔw nana o sunguruw gbɛn, ko o ye bɔ yi k’a to olugu ye o ta sagaw lamin. Musa ka o ye minkɛ, a ka sagagbɛnbagaw fana gbɛn, ka ji di sunguruw ta bɛganw ma. ");
INSERT INTO dyu_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Sunguruw sekɔra ka taga se so kɔnɔ minkɛ, o facɛ Rewɛli ko o ma ko: «Mun le kɛra aw nana joona tan bi?» ");
INSERT INTO dyu_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","O ko: «Misirankacɛ dɔ le ka an bɔsi sagagbɛnbagaw boro bi, fɔ ka ji bi an ye yɛrɛ k’a di an ta bɛganw ma.» ");
INSERT INTO dyu_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Rewɛli ko a denmusow ma ko: «O cɛ bɛ min? Mun na aw nana k’a to yi? Aw ye taga a wele a ye na domuni kɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","O tagara Musa wele. Musa nana to o cɛ ta so. Cɛ k’a denmuso di a ma, k’a kɛ a muso ye. O denmuso tɔgɔ tun ye ko Sefora. ");
INSERT INTO dyu_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sefora nana kɔnɔ ta dencɛ ra Musa fɛ. Musa k’a tɔgɔ la ko Gɛrisɔmu. A ko: «Sabu ne ye lonan le ye jamana ra.» ");
INSERT INTO dyu_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ayiwa, wagatijan tɛmɛnin kɔ, Misiran masacɛ nana sa. O y’a sɔrɔ Izirayɛlimɔgɔw tun bɛ ŋunana ka kule o ta jɔnyabaara sɛgɛ boro hali bi. Ala ka o ta kulekan mɛn. ");
INSERT INTO dyu_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","A ka o ta kumakan mɛn minkɛ, a hakiri tora a ta jɛnɲɔgɔnya ra, a tun ka jɛnɲɔgɔnya min don ni Iburahima ni Isiyaka ni Yakuba ye. ");
INSERT INTO dyu_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ala ka Izirayɛlimɔgɔw flɛ, o makari k’a mina. ");
INSERT INTO dyu_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ayiwa, Musa tora ka a burancɛ Zetoro ta bɛganw kɔrɔsi; Zetoro tun ye Madiyan jamana ta sarakalasebaga le ye. Lon dɔ, Musa tagara ni bɛganw ye fɔ kongokolon kɔ fɛ, ka taga se fɔ Horɛbu kuru kɔrɔ, min bɛ wele ko Ala ta kuru. ");
INSERT INTO dyu_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ka Musa to o yɔrɔ ra, Matigi Ala ta mɛlɛkɛ k’a yɛrɛ yira a ra. Musa k’a ye yiritunin dɔ le cɛ ma, tasumamana ra. Musa k’a flɛ, a k’a ye ko tasuma bɛ bɔra yiritunin na, nka yiritunin yɛrɛ tɛ jɛnina. ");
INSERT INTO dyu_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa ko: «Ne bɛna gbara ka taga nin fɛn suguya flɛ, k’a lɔn mun kosɔn yiritu tɛ jɛnina, k’a sɔrɔ tasuma b’a ra.» ");
INSERT INTO dyu_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Matigi Ala k’a ye ko Musa bɛ gbarara ka taga yiritu flɛ minkɛ, a k’a kan bɔ yiritu cɛ ma ka Musa wele ko: «Musa, Musa!» Musa ko: «Naamu.» ");
INSERT INTO dyu_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ala ko: «I kana gbara yan dɛ! I ta sanbara bɔ i sen na, sabu i lɔnin bɛ yɔrɔ min na nin ye, yɔrɔ saninman lo.» ");
INSERT INTO dyu_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ala ko tuun ko: «Ne le ye i bɛmaw ta Ala ye, Iburahima ta Ala, ani Isiyaka ta Ala, ani Yakuba ta Ala.» Musa ka o mɛn minkɛ, a k’a ɲa dogo, sabu a tun bɛ siranna ko ale kana na Ala flɛ. ");
INSERT INTO dyu_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Matigi Ala ko: «O bɛ ne ta mɔgɔw minako juguyara cogo min na Misiran, ne ka o ye yɛrɛ le. Ne ka o kulekan mɛn o tɔɔrɔbagaw boro, sabu dimi min bɛ o kan, ne ka o ye. ");
INSERT INTO dyu_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","O kosɔn ne nana ka na o bɔsi Misirankaw boro, ka o labɔ o jamana ra, ka taga ni o ye jamanaba ɲumanman dɔ ra, nɔnɔ ni li bɛ woyo jamana min na; Kanaanakaw, ani Hɛtikaw, ani Amɔrikaw, ani Perezikaw, ani Hevikaw, ani Yebusikaw bɛ o jamana le ra. ");
INSERT INTO dyu_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Izirayɛlimɔgɔw kulekan sera ne ma; Misirankaw bɛ o minako juguyara cogo min na, ne ka o ye. ");
INSERT INTO dyu_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ayiwa, sisan ne bɛ ele ci Farawona fɛ, janko i ye taga ne ta mɔgɔw, Izirayɛlimɔgɔw labɔ Misiran.» ");
INSERT INTO dyu_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Musa ka Ala jaabi ko: «Ne wa? Ne ye mun le ye, ko ne bɛ taga lɔ Farawona ɲa fɛ, ko ne bɛ Izirayɛlimɔgɔw labɔra Misiran?» ");
INSERT INTO dyu_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ala ko: «Ne bɛna kɛ ni i ye. Ne b’a fɔ i ye ko ni i ka na bla Izirayɛlimɔgɔw ɲa ka o labɔ Misiran, aw bɛna na ne bato nin kuru kelen le kɔrɔ yan. O tagamasiyɛn le sababu ra i bɛna a lɔn ko ne le ka i ci.» ");
INSERT INTO dyu_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa ko: «Ayiwa, sisan ni ne ka taga Izirayɛlimɔgɔw fɛ, ka taga a fɔ o ye ko: ‹Aw bɛmaw ta Ala le ka ne ci aw fɛ!› Ni o ka ne ɲininka ko: ‹A tɔgɔ ye di?› O tuma ne bɛna o jaabi cogo di?» ");
INSERT INTO dyu_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ala ko Musa ma ko: « ‹Min bɛ yi, ne le ye o ye.› I bɛna o le fɔ Izirayɛlimɔgɔw ye ko min tɔgɔ ye ko: ‹Ne bɛ yi›, ale le ka ne ci aw fɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ala k’a fɔ tuun ko: «I bɛ taga nin fɔ Izirayɛlimɔgɔw ye ko: ‹Matigi Ala, aw bɛmaw ta Ala, Iburahima ta Ala, ani Isiyaka ta Ala, ani Yakuba ta Ala, ale le ka ne ci aw fɛ.› Ne tɔgɔ le bɛ o ye tuma bɛɛ, ani wagati bɛɛ. Wagati bɛɛ mɔgɔw bɛna ne wele o tɔgɔ le ra. ");
INSERT INTO dyu_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«Ayiwa, taga Izirayɛli cɛkɔrɔbaw lajɛn, i ye a fɔ o ye ko o bɛmaw ta Ala k’a yɛrɛ yira i ra, Iburahima ni Isiyaka ni Yakuba ta Ala. Ko a ko a ka aw ye, ani Misirankaw bɛ min kɛra aw ra Misiran, a ka o ye fana. ");
INSERT INTO dyu_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ko o kosɔn, ko ne ko ne bɛna o labɔ tɔɔrɔ ra Misiran, ka taga ni o ye Kanaanakaw, ni Hɛtikaw, ni Amɔrikaw, ni Perezikaw, ni Hevikaw, ni Yebusikaw ta jamana ra, nɔnɔ ni li bɛ woyo jamana min na.» ");
INSERT INTO dyu_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ala ko Musa ma tuun ko: «Izirayɛlimɔgɔw bɛna sɔn i ta kuma ma. I bɛna taga Misiran masacɛ fɛ, ele ni Izirayɛli cɛkɔrɔbaw. Aw b’a fɔ a ye ko: ‹Matigi Ala, Heburuw ta Ala ka a yɛrɛ yira an na. An bla, an ye taga tere saba tagama kɛ kongo kɔnɔ, ka saraka bɔ Matigi Ala, an ta Ala ye.› ");
INSERT INTO dyu_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ne k’a lɔn ko Misiran masacɛ tɛna sɔn k’a to aw ye taga, ni a ma kɛ jagboya ye a ma. ");
INSERT INTO dyu_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ne bɛna ne ta sebagaya yira, ka kabakow kɛ Misiran, ka tɔɔrɔ suguya bɛɛ la Misirankaw kan. Ni o kɛra, Farawona bɛna a to aw ye taga. ");
INSERT INTO dyu_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ne yɛrɛ bɛna a kɛ fɔ Misirankaw bɛna aw bonya; o ra, aw tagatɔ, aw borolakolon tɛna taga. ");
INSERT INTO dyu_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Aw ta musow bɛɛ kelen kelen bɛna a fɔ a sigiɲɔgɔnw, ani a ta sokɔnɔmɔgɔw ye, ko o ye warigbɛfɛnw, ani saninmanfɛnw di o ma, ani faniw, o bɛ o don o dencɛw ni o denmusow ra. «Aw bɛna Misirankaw ta fɛnw mina o ra ten le, ka taga ni o ye ka o borolakolon to.» ");
INSERT INTO dyu_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ayiwa, Musa ka Ala jaabi ko: «Izirayɛlimɔgɔw tɛna la ne ra; o tɛna sɔn ne ta kuma ma. O bɛna a fɔ ko can tɛ, ko Matigi Ala m’a yɛrɛ yira ne ra.» ");
INSERT INTO dyu_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Matigi Ala ko Musa ma ko: «Mun le bɛ i boro?» Musa ko: «Bere lo.» ");
INSERT INTO dyu_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Matigi Ala ko: «A firi dugu ma.» Musa ka bere firi dugu ma; bere yɛlɛmana ka kɛ sa ye. Musa borira sa ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Matigi Ala ko Musa ma ko: «Gbara a ra, i ye a mina a kukala ma.» Musa gbarara sa ra k’a mina a kukala ma. Sa yɛlɛmana ka kɛ bere ye tuun a nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Matigi Ala ko: «I bɛna taga o le kɛ Izirayɛlimɔgɔw ɲa na, janko o ye la a ra ko ne Matigi Ala, o bɛmaw ta Ala k’a yɛrɛ yira i ra, Iburahima ni Isiyaka ni Yakuba ta Ala.» ");
INSERT INTO dyu_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Matigi Ala ko tuun ko: «I boro don i ta derege jukɔrɔ, k’a la i disi kan.» Musa k’a boro don a ta derege jukɔrɔ. A k’a boro bɔ minkɛ, a k’a ye ko kunabana k’a boro mina, k’a mina k’a gbɛ pepepe. ");
INSERT INTO dyu_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Matigi Ala ko: «I boro don i ta derege jukɔrɔ tuun.» Musa k’a boro don a ta derege jukɔrɔ tuun. A nana a bɔ minkɛ, a boro sekɔra ka kɛ a cogo ra. ");
INSERT INTO dyu_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Matigi Ala ko: «Ni o ka tagamasiyɛn fɔlɔ ye, ni o ma la i ra, ni o ma sɔn i ta ma, ni o nana tagamasiyɛn flanan ye, o bɛna la i ra. ");
INSERT INTO dyu_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ni o ka o tagamasiyɛn fla bɛɛ ye, ni hali belen o ma la i ra, ni o ma sɔn i ta ma, o tuma i bɛ taga ji dɔ cɛ Nili ba ra, ka na a seri dugu ma. I bɛna o ji min bɔn, o bɛna yɛlɛma ka kɛ jori ye dugu ma.» ");
INSERT INTO dyu_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa ko Matigi Ala ma ko: «E! Matigi, ne tɛ se kuma ra dɛ! Kunu ko tɛ o ye, kununasini fana ko tɛ o ye. A fana tɛ i n’a fɔ a daminana sisan le, i kumatɔ ne fɛ. Kabini ne denmisɛnman, ne da ka gbiri, ne nɛnden sirinin lo.» ");
INSERT INTO dyu_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Matigi Ala ko: «Jɔn le ka da di mɔgɔ ma? Jɔn le bɛ mɔgɔ kɛ bobo ye, walama torogberen, k’a to a ye yeri kɛ, walama k’a fiyen? Ne Matigi Ala tɛ wa? ");
INSERT INTO dyu_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ele ye taga dɔrɔn. Ne bɛna kɛ ni i ye i kumatɔ. I ka kan ka min fɔ, ne yɛrɛ le bɛna o yira i ra.» ");
INSERT INTO dyu_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Musa ko: «Aa, Matigi Ala, sabari, i ye mɔgɔ wɛrɛ ci.» ");
INSERT INTO dyu_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Musa ka o fɔ minkɛ, Matigi Ala dimina Musa kɔrɔ kosɛbɛ. Ala ko: «I kɔrɔcɛ Haruna tɛ yi wa, i ni min bɔra Levi ta gba ra? Ne k’a lɔn ko ale kɔni bɛ se kuma ra. A yɛrɛ bɛ a yɛrɛ labɛnna ka ban ka na i kunbɛn. Ni a nana i ye, a bɛna diya a ye kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","I bɛna kuma a fɛ. Ele le bɛna kuma don a da ra. Ne bɛna kɛ ni i ye i kumatɔ, ka kɛ ni ale fana ye a kumatɔ. Aw bɛna kuma min fɔ, ne yɛrɛ le bɛna o yira aw ra. ");
INSERT INTO dyu_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ale bɛna kuma jama fɛ i nɔ ra. Ale le bɛna kɛ i ta kumalasebaga ye. Ele bɛna kɛ Ala nɔ ra ale fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Nin bere ta i boro; i bɛna taga tagamasiyɛnw kɛ ni o le ye.» ");
INSERT INTO dyu_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ayiwa, o kɔ, Musa sekɔra ka taga so. A tagara se a burancɛ Zetoro fɛ, a k’a fɔ a ye ko: «Sabari k’a to ne ye sekɔ ne balemaw fɛ Misiran, janko k’a lɔn ni o bɛ si ra.» A burancɛ Zetoro ko: «Taga, Ala ye i ni hɛra bɛn.» ");
INSERT INTO dyu_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ka Musa to Madiyan, Matigi Ala kumana a fɛ tuun. Ala ko: «Musa, i kɔsegi ka taga Misiran, sabu minw tun b’a fɛ ka i faga olugu bɛɛ sara.» ");
INSERT INTO dyu_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musa k’a muso ni a dencɛw layɛlɛn fali dɔ kan, ka taga Misiran. Ala tun ka tagamasiyɛnw kɛ ni bere min ye, Musa tagara ni o bere ye a boro. ");
INSERT INTO dyu_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Matigi Ala kumana Musa fɛ, ko: «Ni i tagara se Misiran, ne ka kabako minw yira i ra, i bɛna o bɛɛ kɛ Farawona ɲa na. Nka ne bɛna a jusukun gbɛlɛya, a tɛna sɔn ka Izirayɛlimɔgɔw bla o ye taga. ");
INSERT INTO dyu_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","I bɛna a fɔ Farawona ye ko: ‹Matigi Ala ko: Izirayɛlimɔgɔw ko ka gbɛlɛn ne ma; o kɛra i ko ne dencɛ fɔlɔ. ");
INSERT INTO dyu_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ne b’a fɛ i ye o bla o ye taga baara kɛ ne ye. Ni i ma sɔn k’a to o ye taga, ne bɛna i dencɛ fɔlɔ faga.› » ");
INSERT INTO dyu_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ayiwa, ka o to tagama ra, Musa ni a muso ni a denw tagara jigi yɔrɔ dɔ ra; ka o to o yɔrɔ ra, Matigi Ala wurira Musa kama ka tɔɔrɔ dɔ lase Musa ma, fɔ a tun bɛ ɲini ka sa. ");
INSERT INTO dyu_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sefora ka kabakuru lɛsɛnin dɔ ta, k’a dencɛ Gɛrisɔmu kɛnɛsigi, ka o gbolo maga Musa ra, k’a fɔ a ye ko: «Ele kɛra furucɛ joritigi le ye ne fɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","A kɛra ten minkɛ, Matigi Ala ka Musa to yi. O ko le kosɔn Sefora k’a fɔ Musa ma ko «furucɛ joritigi.» A ka o fɔ kɛnɛsigiri le kosɔn. ");
INSERT INTO dyu_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","O wagati ra, Ala k’a fɔ Haruna ye ko: «Wuri ka taga kongo kɔnɔ, ka taga Musa kunbɛn.» Haruna wurira ka taga. A tagara bɛn ni Musa ye Ala ta kuru kɔrɔ. A ka Musa fo ni kanuya ye. ");
INSERT INTO dyu_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Matigi Ala tun ka Musa ci ka kuma minw bɛɛ fɔ Musa ye, ani a tun ka tagamasiyɛn minw bɛɛ yira a ra ko a ye a kɛ, Musa ka o bɛɛ fɔ Haruna ye. ");
INSERT INTO dyu_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ayiwa, Musa ni Haruna ka sira ta o le ra ka taga. O tagara se Misiran, o ka Izirayɛlimɔgɔw ta cɛkɔrɔbaw bɛɛ lajɛn. ");
INSERT INTO dyu_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Matigi Ala tun ka kuma minw bɛɛ fɔ Musa ye, Haruna ka o fɔ cɛkɔrɔbaw ye; Musa ka tagamasiyɛnw kɛ o ɲa na fana. ");
INSERT INTO dyu_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Izirayɛlimɔgɔw lara o ra. O yɛrɛ k’a faamu ko Matigi Ala nana Izirayɛlimɔgɔw bɔsi; sabu Ala tun ka o ta sɛgɛ ye. O ka o ɲa biri dugu ma ka Ala bato. ");
INSERT INTO dyu_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ayiwa, o kɔ, Musa ni Haruna tagara Farawona fɛ; o tagara a fɔ a ye ko: «Matigi Ala, Izirayɛlimɔgɔw ta Ala ko i ye ale ta mɔgɔw bla, janko o ye taga ɲanagbɛ dɔ kɛ a ye kongo kɔnɔ, k’a bonya.» ");
INSERT INTO dyu_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farawona ko: «Jɔn le ye Matigi Ala ye ko ne bɛ a kan lamɛn, ka Izirayɛlimɔgɔw bla o ye taga? Ne ma Matigi Ala lɔn, ne tɛna Izirayɛlimɔgɔw bla o ye taga fana.» ");
INSERT INTO dyu_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa ni Haruna ko: «Heburuw ta Ala k’a yɛrɛ yira an na. A to an ye tere saba tagama kɛ kongo kɔnɔ, ka taga saraka dɔw bɔ Matigi Ala, an ta Ala ye, janko a kana na banajugu ben an kan ka an faga, walama k’a to o ye an faga ni kɛrɛkɛmuru ye.» ");
INSERT INTO dyu_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Misiran masacɛ Farawona ko: «Ele Musa, ani ele Haruna, mun kosɔn aw bɛ mɔgɔw kunnacɛnna ka o ta baara lalɔ dɛ? Aw ye tɛmɛ ka taga baara kɛ dɛ! ");
INSERT INTO dyu_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Mɔgɔw cayara sisan jamana kɔnɔ; mun kosɔn aw bɛna o ta baara lalɔ?» ");
INSERT INTO dyu_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ayiwa, o lon yɛrɛ ra, Farawona k’a fɔ baara kɔrɔsibagaw ni baarakuntigiw ye ko: ");
INSERT INTO dyu_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Aw kana bin ɲini k’a di Izirayɛlimɔgɔw ma tuun o ye biriki bɔ ni a ye, i n’a fɔ aw derira k’a kɛ cogo min na. Aw y’a to o ye taga bin ɲini o yɛrɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","O bɛɛ n’a ta, o derira ka birikidenda min bɔ kakɔrɔ, aw y’a fɔ o ye ko o ka kan ka o da kelen le bɔ. Aw kana dɔ bɔ a ra dɛ! Sabu salibagatɔw lo, o kosɔn o b’a fɔra tuma bɛɛ ko: ‹An ye taga saraka bɔ an ta Ala ye›. ");
INSERT INTO dyu_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Aw ye baara caya o ra, ka o degu kosɛbɛ. Ni o kɛra, o tɛna nin faninyakumaw jate tuun.» ");
INSERT INTO dyu_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ayiwa, baarakuntigiw, ani baara kɔrɔsibagaw nana o kuma fɔ mɔgɔw ye, ko: «Farawona ko an kana bin di aw ma tuun. ");
INSERT INTO dyu_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ko aw ye taga bin ɲini aw yɛrɛ ye. Ni aw bɛ se k’a sɔrɔ yɔrɔ o yɔrɔ, aw ye taga a ɲini yi, sabu dɔ tɛna bɔ aw ta baara ra.» ");
INSERT INTO dyu_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Mɔgɔw janjanna ka taga Misiran jamana yɔrɔ bɛɛ ra, ka taga bin ɲini. ");
INSERT INTO dyu_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Baarakuntigiw tun bɛ o ɲagbanna, k’a fɔ o ye ko: «Aw tun bɛ deri ka birikidenda min bɔ tere kɔnɔ, aw ka kan ka o le bɔ, i n’a fɔ wagati min na bin tun bɛ dira aw ma.» ");
INSERT INTO dyu_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Farawona ta kuntigiw tun ka Izirayɛlimɔgɔ minw sigi Izirayɛlimɔgɔ tɔw kunna, ka o kɛ baara kɔrɔsibagaw ye, Misirankaw nana kɛ olugu fana bugɔ ye. O ko o ma ko: «Mun kosɔn aw tun bɛ deri ka birikidenda min bɔ, aw ma se ka o bɔ kunu ni bi?» ");
INSERT INTO dyu_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ayiwa, Izirayɛlimɔgɔw ta baara kɔrɔsibagaw dimina; o wurira ka taga o ko fɔ Farawona ye, ko: «Mun kosɔn i bɛ i ta jɔnw minako juguyara tan? ");
INSERT INTO dyu_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Bin tɛ dira an ma, o bɛɛ n’a ta, o ko an ye biriki bɔ. A flɛ, o bɛ an bugɔra, k’a sɔrɔ i yɛrɛ ta mɔgɔw le jarakira.» ");
INSERT INTO dyu_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Farawona ko: «Aw ye salibagatɔw le ye, salibagatɔw yɛrɛyɛrɛ! O kosɔn aw b’a fɔra ko: ‹An bɛ taga saraka bɔ an ta Ala ye, an bɛ taga saraka bɔ an ta Ala ye.› ");
INSERT INTO dyu_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Aw ye tɛmɛ ka taga baara kɛ sisan. Bin foyi tɛ di aw ma, nka aw tun bɛ deri ka birikidenda min kɛ kakɔrɔ, aw ka kan ka o le kɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Izirayɛlimɔgɔw ta baara kɔrɔsibagaw k’a ye ko o ka olugu ta koɲaw gbɛlɛya fɔ k’a dama tɛmɛ; ko birikidenda min fɔra, ko dɔ tɛna bɔ o ra, ko o da kelen le ka kan ka kɛ lon o lon. ");
INSERT INTO dyu_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ayiwa, o bɔtɔ Farawona fɛ, o bɛnna ni Musa ni Haruna ye. Olugu tun bɛ o kɔnɔna da ra. ");
INSERT INTO dyu_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","O k’a fɔ Musa ni Haruna ye ko: «Matigi Ala yɛrɛ le bɛna nin ko ye, ka aw ta kɛwalew hakɛ bɔ aw ra. Aw le nana anw ta ko tɔ gbɛlɛya Farawona ni a ta jamana ɲamɔgɔw fɛ. Aw le ka an fagamuru di o ma ko a ye an faga.» ");
INSERT INTO dyu_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa ka o mɛn minkɛ, a k’a fɔ Matigi Ala ye ko: «Matigi, mun kosɔn i ka nin kojugu kɛ nin mɔgɔw ra? Mun na i ka ne ci? ");
INSERT INTO dyu_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kabini ne tagara Farawona fɛ ka taga kuma a fɛ i tɔgɔ ra, a bɛ kojugu dɔrɔn le kɛra i ta mɔgɔw ra. Ele fana ma foyi kɛ ka o kisi ka bɔ a boro!» ");
INSERT INTO dyu_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ayiwa, Matigi Ala k’a fɔ Musa ye ko: «Ne bɛna min kɛ Farawona ra, i bɛna o ye sisan. Ne ta sebagaya bɛna a jagboya k’a to a ye Izirayɛlimɔgɔw bla ka taga. Ne ta sebagaya bɛna a kɛ fɔ Farawona bɛna aw gbɛn yɛrɛ ka bɔ a ta jamana kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ala k’a fɔ Musa ye tuun ko: «Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ne ka ne yɛrɛ yira Iburahima ni Isiyaka ni Yakuba ra, ko ne le ye Sebɛɛtigi Ala ye. Nka ne tɔgɔ min ye ko Matigi Ala, o ma ne lɔn o tɔgɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ne ka jɛnɲɔgɔnya don ni o ye fana, ka layiri ta o ye ko ne bɛna Kanaana jamana di o ma, o tun nana kɛ lonan ye jamana min na. ");
INSERT INTO dyu_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ayiwa, sisan, ne ka o ŋunakan mɛn, sabu Misirankaw ka o bla jɔnya ra. Ne ka layiri min ta o ye, ne hakiri bɛ o ra. ");
INSERT INTO dyu_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","O kosɔn, a fɔ Izirayɛlimɔgɔw ye ko: ‹Ne le ye Matigi Ala ye; Misirankaw ka jagboyabaara min la aw kan, ne bɛna aw bɔsi ka bɔ o ra. Ne bɛna aw kisi ka aw bɔ o ta jɔnya ra. Ne bɛna aw kisi ne ta sebagayaba baraka ra, ka kitibaw ben Misirankaw kan. ");
INSERT INTO dyu_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ne bɛna aw kɛ ne ta mɔgɔw ye, ka kɛ aw ta Ala ye. O ra, aw bɛna a lɔn ko Misirankaw ka baara minw la aw kan, ko ne le bɛ aw bɔsi ka bɔ o baaraw bɛɛ ra; ne Matigi Ala, aw ta Ala ko ten. ");
INSERT INTO dyu_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Fɔlɔfɔlɔ, ne karira Iburahima, ani Isiyaka, ani Yakuba ye, ko ne bɛna jamana min di o ma, ne bɛna taga aw ladon o jamana le ra. Ne yɛrɛ le bɛna o jamana di aw ma, k’a kɛ aw ta ye; ne Matigi Ala ko ten.› » ");
INSERT INTO dyu_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ayiwa, Musa ka o kuma le fɔ Izirayɛlimɔgɔw ye. Nka o tun bɛ jɔnyagbɛlɛn min na, o jusukasi kosɔn, o ma se ka Musa lamɛn. ");
INSERT INTO dyu_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Matigi Ala kumana Musa fɛ tuun ko: ");
INSERT INTO dyu_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Taga kuma Misiran masacɛ Farawona fɛ ko a ye Izirayɛlimɔgɔw bla, o ye taga ka bɔ a ta jamana ra.» ");
INSERT INTO dyu_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musa ka Matigi Ala jaabi ko: «A flɛ, Izirayɛlimɔgɔw ma ne lamɛn; Farawona bɛna ne lamɛn cogo di, ne min tɛ se kuma ra?» ");
INSERT INTO dyu_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ayiwa, Matigi Ala kumana Musa ni Haruna fɛ tuun, Izirayɛlimɔgɔw, ani Misiran masacɛ ta ko ra, janko ka Izirayɛlimɔgɔw labɔ Misiran jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Izirayɛlimɔgɔw ta gbatigiw flɛ nin ye: Izirayɛli dencɛ fɔlɔ Rubɛn, ale dencɛw tun ye Hanɔki ye, ani Palu, ani Hɛsirɔn, ani Karimi. O gbaw bɛɛ bɔra Rubɛn le ra. ");
INSERT INTO dyu_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeyɔn dencɛw flɛ nin ye: Yemuwɛli, ani Yamini, ani Owadi, ani Yakini, ani Sohari, ani Kanaanaka muso dencɛ Sawuli. Olugu ta gbaw bɛɛ bɔra Simeyɔn le ra. ");
INSERT INTO dyu_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi dencɛw ni o ta durujaw tɔgɔw ye nin ye: Levi yɛrɛ dencɛw tɔgɔw tun ye ko Gɛrisɔn, ani Kehati, ani Merari. Levi si bɛɛ lajɛnnin kɛra san kɛmɛ ni san bisaba, ani san wolonfla. ");
INSERT INTO dyu_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gɛrisɔn dencɛw tun ye Libini, ani Simɛyi ye, o bɛɛ ni o ta gbaw. ");
INSERT INTO dyu_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kehati dencɛw tun ye Amuramu, ani Isari, ani Heburɔn, ani Uziyɛli ye. Kehati si kɛra san kɛmɛ ni bisaba ni saba. ");
INSERT INTO dyu_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari dencɛw tun ye Mali ni Musi ye. Ayiwa, Levi ta gbaw le ye olugu ye, o ni o ta durujaw. ");
INSERT INTO dyu_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ayiwa, Amuramu k’a tɛnɛnmuso Yokebɛdi furu. Ale ka Haruna ni Musa woro Amuramu ye. Amuramu si bɛɛ lajɛnnin kɛra san kɛmɛ ni san bisaba ni san wolonfla. ");
INSERT INTO dyu_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isari dencɛw tun ye Kore, ani Nefɛgi, ani Zikiri ye. ");
INSERT INTO dyu_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziyɛli dencɛw tun ye Misahɛli, ani Elisafan, ani Sitiri ye. ");
INSERT INTO dyu_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruna ka Aminadabu denmuso Eliseba le furu. Eliseba tun ye Nasɔn balemamuso le ye fana. Eliseba ka dencɛ minw woro Haruna ye, olugu le kɛra Nadabu ye, ani Abihu, ani Elehazari, ani Itamari. ");
INSERT INTO dyu_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kore dencɛw tun ye Asiri, ani Ɛlikana, ani Abiyasafu ye. Korekaw ta gbaw le ye olugu ye. ");
INSERT INTO dyu_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Haruna dencɛ Elehazari nana Putiyɛli denmusow kelen furu. O muso ka dencɛ woro, k’a tɔgɔ la ko Finehasi. Levi ta gbatigiw le kɛra olugu ye, o bɛɛ ni o ta gbaw. ");
INSERT INTO dyu_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ayiwa, Matigi Ala kumana o Haruna ni o Musa le fɛ, k’a fɔ o ye ko o ye Izirayɛlimɔgɔw labɔ Misiran jamana ra, ka o ta gbaw tugutugu ɲɔgɔn kɔ, jɛnkuru jɛnkuru, ka o labɔ Misiran. ");
INSERT INTO dyu_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","O Haruna ni o Musa le tagara kuma Misiran masacɛ Farawona fɛ, janko ka Izirayɛlimɔgɔw labɔ Misiran. ");
INSERT INTO dyu_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ayiwa, wagati min na Matigi Ala kumana Musa fɛ Misiran jamana ra, ");
INSERT INTO dyu_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","a tun k’a fɔ Musa ye ko: «Ne le ye Matigi Ala ye; ne bɛ fɛn o fɛn fɔ i ye, o fɔ Misiran masacɛ Farawona ye.» ");
INSERT INTO dyu_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","O wagati ra, Musa tun ka Matigi Ala jaabi o le ra ko: «Kuma ka gbɛlɛn ne fɛ; Farawona bɛna ne lamɛn cogo di?» ");
INSERT INTO dyu_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ayiwa, Matigi Ala k’a fɔ Musa ye o le ra ko: «Ne bɛna fangaba di i ma, ka i kɛ i ko Ala, Farawona ɲa kɔrɔ. I kɔrɔcɛ Haruna bɛna kɛ i ta kumalasebaga ye. ");
INSERT INTO dyu_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ni ne ka ci o ci fɔ i ye, i ye o fɔ i kɔrɔcɛ Haruna ye; ale bɛ o lase Farawona ma, janko a y’a to Izirayɛlimɔgɔw ye taga ka bɔ a ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Nka ne Ala, ne yɛrɛ bɛna Farawona jusukun gbɛlɛya, ka tagamasiyɛnw ni kabako caman kɛ Misiran jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Nka o bɛɛ n’a ta, Farawona tɛna sɔn ka aw lamɛn. Ne bɛna ne ta sebagaya yira Misiran jamana ra, ka kitibaw ben o kan, ka ne ta mɔgɔw, Izirayɛlimɔgɔw labɔ Misiran jamana ra; ne bɛna o gban ɲɔgɔn kɔ jɛnkuru jɛnkuru ka o labɔ. ");
INSERT INTO dyu_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ni ne nana ne ta sebagaya yira Misirankaw ra tuma min na, ka o tɔɔrɔ, ka Izirayɛlimɔgɔw bɔ o cɛ ra, o tuma le ra o bɛna a lɔn ko ne le ye Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Matigi ka ci minw fɔ Musa ni Haruna ye, o ka o kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa ni Haruna tagara kuma Farawona fɛ wagati min na, o y’a sɔrɔ Musa si tun ye san biseegi, Haruna si tun ye san biseegi ni saba. ");
INSERT INTO dyu_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ayiwa, Matigi Ala k’a fɔ Musa ni Haruna ye ko: ");
INSERT INTO dyu_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Ni Farawona k’a fɔ aw ye ko aw ye kabako dɔ kɛ k’a yira ale ra, Musa, ele ye a fɔ Haruna ye ko a ye a ta bere ta k’a firi dugu ma Farawona ɲa na. Bere bɛna yɛlɛma ka kɛ sa ye.» ");
INSERT INTO dyu_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musa ni Haruna tagara Farawona fɛ. Matigi Ala ka min fɔ o ye, o ka o kɛ. Haruna k’a ta bere firi dugu ma, Farawona ni a ta jamana ɲamɔgɔw ɲa na. Bere yɛlɛmana ka kɛ sa ye. ");
INSERT INTO dyu_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Farawona ka Misiran kolɔnbagaw, ani a subagaw, ani a jinamoriw wele ka na. Olugu fana nana o dɔ kɛ subagaya ra. ");
INSERT INTO dyu_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Olugu bɛɛ fana ka o ta berew firi dugu ma; berew yɛlɛmana ka kɛ saw ye. Nka Haruna ta bere tun yɛlɛmana ka kɛ sa min ye, o sa ka olugu ta saw bɛɛ kunu. ");
INSERT INTO dyu_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Nka o bɛɛ n’a ta, Farawona k’a jusukun gbɛlɛya, i n’a fɔ Matigi Ala tun k’a fɔ cogo min na; a ma sɔn ka Musa ni Haruna ta kuma lamɛn. ");
INSERT INTO dyu_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ayiwa, Matigi Ala k’a fɔ Musa ye ko: «Farawona jusukun ka gbɛlɛn; a tɛ sɔnna ka ne ta mɔgɔw bla o ye taga. ");
INSERT INTO dyu_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Sini sɔgɔmada joona fɛ, i ni Haruna ye taga a nɔ fɛ. A bɛna bɔ ka taga Nili bada ra. Aw ye taga a fɛ bada ra yi. Bere min yɛlɛmana ka kɛ sa ye, i ye o ta i boro. ");
INSERT INTO dyu_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","I ye a fɔ a ye ko: ‹Matigi Ala, Heburuw ta Ala ka ne ci i fɛ, ko ne ye a fɔ i ye ko i y’a to ale ta mɔgɔw ye taga, ka taga ale bato kongo kɔnɔ. Nka hali bi i tɛ sɔnna o kuma ma. ");
INSERT INTO dyu_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ayiwa, Matigi Ala ko, ko bere min bɛ ne boro, ko ne ye na o kɛ ka baji gbasi, ko baji bɛna yɛlɛma ka kɛ jori ye; ko o ra i bɛna a lɔn ko ale le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nili ba jɛgɛw bɛɛ bɛna faga ji ra. Ji bɛna tori. Misirankaw bɛna a fɔ ko o bɛ ji min, nka o tɛna se.› » ");
INSERT INTO dyu_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Matigi Ala k’a fɔ Musa ye tuun ko: «A fɔ Haruna ye ko a ye a ta bere ta k’a kɔrɔta Misiran jiw bɛɛ kunna, ani baw, ani kɔw, ani bununw, ani dinga jimanw. O jiw bɛɛ bɛna kɛ jori ye. Jori bɛna kɛ Misiran jamana yɔrɔ bɛɛ ra. Hali ji minw bɛ o ta yiridagaw, ani o ta kabakurudagaw kɔnɔ, o bɛɛ le bɛna kɛ jori ye.» ");
INSERT INTO dyu_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Matigi ka min fɔ Musa ni Haruna ye, o ka o kɛ. Haruna ka bere kɔrɔta ka baji gbasi ni a ye Farawona ni a ta jamana ɲamɔgɔw bɛɛ ɲa na. Baji bɛɛ yɛlɛmana ka kɛ jori ye. ");
INSERT INTO dyu_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ba jɛgɛw bɛɛ fagara. Ji torira. Misirankaw ma se k’a ji min tuun. Jori tun bɛ Misiran jamana yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Nka Misiran jinamoriw fana ka o ɲɔgɔn kɛ subagaya ra. Farawona ka o ye minkɛ, a k’a jusukun gbɛlɛya, i n’a fɔ Matigi Ala tun k’a fɔ cogo min na. A ma sɔn ka Musa ni Haruna ta kuma lamɛn. ");
INSERT INTO dyu_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Masacɛ Farawona sekɔra ka taga a ta so; hali a ma o ko jate fɛn ye. ");
INSERT INTO dyu_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misirankaw bɛɛ ka dingaw sogisogi bada ra ka ji ɲini; sabu o tun tɛ se ka ba ta ji min tuun. ");
INSERT INTO dyu_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Matigi Ala ka baji cɛn lon min na, tere wolonfla le kɛra o kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","O kɔ, Matigi Ala k’a fɔ Musa ye ko: «Aw ye taga a fɔ Farawona ye ko Matigi Ala ko: ‹A to ne ta mɔgɔw ye taga ne bato. ");
INSERT INTO dyu_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Ni i ma sɔn k’a to o ye taga, ne bɛna tɔrisenjanw kɛ ka i ta jamana bɛɛ fa, ka i tɔɔrɔ ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Baji bɛna fa tɔrisenjanw na. O bɛna bɔ ba ra ka taga i yɛrɛ ta so kɔnɔ, ka don hali i ta sibon kɔnɔ, ka yɛlɛn i ta lanan kan, ka don i ta jamana ɲamɔgɔw ta sow kɔnɔ, ani i ta mɔgɔw bɛɛ ta bonw kɔnɔ; o bɛna don hali burujɛnigbaw, ani burugbasiminanw bɛɛ kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Tɔriw bɛna yɛlɛn i kan, ani i ta mɔgɔw kan, ani i ta jamana ɲamɔgɔw bɛɛ kan.› » ");
INSERT INTO dyu_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Matigi Ala k’a fɔ Musa ye tuun ko: «A fɔ Haruna ye ko a ye bere ta, k’a kɔrɔta san fɛ, kɔw kunna, ani jisiraw, ani dinga jimanw, ka tɔrisenjanw bɔ ka o kɛ Misiran jamana bɛɛ kan.» ");
INSERT INTO dyu_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Haruna k’a boro kɔrɔta ni bere ye Misiran jiw bɛɛ kunna. Tɔrisenjanw bɔra ji ra yɔrɔ bɛɛ ra, ka Misiran jamana yɔrɔ bɛɛ fa. ");
INSERT INTO dyu_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nka Misiran jinamoriw fana ka o dɔ kɛ subagaya ra. O fana ka tɔrisenjanw bɔ ji ra k’a kɛ Misiran jamana kan. ");
INSERT INTO dyu_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Farawona ka Musa ni Haruna wele k’a fɔ o ye ko: «Aw ye Matigi Ala daari, janko a ye nin tɔrisenjanw mabɔ ne ni ne ta mɔgɔw ra; ni o kɛra, ne bɛna a to Izirayɛlimɔgɔw ye taga saraka bɔ Matigi Ala, o ta Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Musa ko Farawona ma ko: «Masacɛ, ele ta le ye bonya ye; a ko bɛ ele le boro. Tuma juman le i b’a fɛ ne ye Ala daari i ni i ta jamana ɲamɔgɔw ye, ani i ta jamana mɔgɔw, janko a ye tɔriw mabɔ i ra, ka o bɔ sow kɔnɔ? Ne bɛna Ala daari; tɔriw tɛna kɛ yɔrɔ si tuun ni baji dɔrɔn tɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Farawona ko: «A ye kɛ sini.» Musa ko: «I ka min fɔ, a bɛna kɛ ten, janko i ye a lɔn ko mɔgɔ tɛ yi, min bɛ se k’a yɛrɛ suma ni Matigi Ala, an ta Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tɔriw bɛna mabɔ i ni i ta sow ra, ani i ta jamana ɲamɔgɔw, ani i ta jamana mɔgɔw ra. Tɔriw bɛna kɛ ba dɔrɔn le ra.» ");
INSERT INTO dyu_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Musa ni Haruna tagara ka bɔ Farawona ta so. Musa tagara Matigi Ala daari kosɛbɛ, ko a ka Farawona tɔɔrɔ ni tɔri minw ye, a ye o tɔriw mabɔ Farawona ra, ani a ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa ka min daari, Matigi Ala ka o kɛ. Tɔriw bɛɛ fagara bonw kɔnɔ, ani luw kɔnɔ, ani forow ra. ");
INSERT INTO dyu_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","O ka o cɛ ka o tonton ɲɔgɔn kan. A torira, k’a kasa kɛ jamana yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Farawona k’a ye ko a ko nɔgɔyara minkɛ, a k’a jusukun gbɛlɛya tuun, i n’a fɔ Matigi Ala tun k’a fɔ cogo min na; a ma sɔn ka Musa ni Haruna ta kuma lamɛn. ");
INSERT INTO dyu_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Matigi Ala k’a fɔ Musa ye ko: «A fɔ Haruna ye ko a ye bere kɔrɔta ka dugukolo buguri gbasi. Buguri bɛna yɛlɛma ka kɛ kinnifɛn misɛn dɔw ye Misiran jamana fan bɛɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Matigi Ala ka min fɔ, Musa ni Haruna ka o kɛ. Haruna k’a boro kɔrɔta ni bere ye ka dugukolo buguri gbasi. Buguri yɛlɛmana ka kɛ kinnifɛn misɛnw ye ka don mɔgɔw ni bɛganw bɛɛ ra. Buguri bɛɛ yɛlɛmana ka kɛ kinnifɛn misɛnw ye Misiran jamana bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Misiran jinamoriw ko o bɛ o ɲɔgɔn kɛ subagaya ra, nka o ma se. Kinnifɛn misɛnw wurira ka na don mɔgɔw ni bɛganw bɛɛ ra yɔrɔ bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Jinamoriw k’a fɔ Farawona ye ko: «Nin ye Ala yɛrɛ ta boro nɔ le ye!» O bɛɛ n’a ta, Farawona k’a jusukun gbɛlɛya, i n’a fɔ Matigi Ala tun k’a fɔ cogo min na; a ma sɔn ka Musa ni Haruna ta kuma lamɛn. ");
INSERT INTO dyu_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Matigi Ala k’a fɔ Musa ye ko: «Wuri sɔgɔmada joona fɛ ka taga Farawona fɛ. A bɛna bɔ ka taga bada ra. Taga a fɔ a ye ko Matigi Ala ko: ‹A to ne ta mɔgɔw ye taga ne bato. ");
INSERT INTO dyu_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ni i m’a to ne ta mɔgɔw ye taga, ne bɛna limɔgɔjuguw lana i kama, ani i ta jamana ɲamɔgɔw, ani i ta jamana mɔgɔw bɛɛ kama; limɔgɔw bɛna don i ta sow kɔnɔ. Misirankaw ta sow bɛɛ bɛna fa limɔgɔw ra. Misiran jamana dugukolo bɛɛ bɛna fa a ra. ");
INSERT INTO dyu_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Nka o lon na, ne ta mɔgɔw siginin bɛ jamana yɔrɔ min na, min ye Gosɛni mara ye, ne bɛna o yɔrɔ tanga o limɔgɔw ma. Limɔgɔ tɛna kɛ o yɔrɔ ra; ne bɛna o kɛ, janko i ye a lɔn ko ne Matigi Ala, ko ne ta sebagaya bɛ Gosɛni mara kan. ");
INSERT INTO dyu_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ne bɛna o faranfasi kɛ i ta mɔgɔw, ani ne ta mɔgɔw cɛ. O tagamasiyɛn bɛna kɛ sini le.› » ");
INSERT INTO dyu_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Matigi Ala tun k’a fɔ cogo min na, a k’a kɛ ten fana. Limɔgɔjuguw nana caman Farawona ta so kɔnɔ, ani jamana ɲamɔgɔw ta sow kɔnɔ. Jamana yɔrɔ bɛɛ cɛnna limɔgɔw fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Farawona ka Musa ni Haruna wele k’a fɔ o ye ko: «Aw ye taga saraka bɔ aw ta Ala ye, nka aw ye to jamana kɔnɔ yan.» ");
INSERT INTO dyu_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Musa ko: «A tɛ se ka kɛ o cogo ra, sabu an bɛna saraka minw bɔ Matigi Ala, an ta Ala ye, Misirankaw bɛ o sarakaw haramuya; o bɛ fɛn min haramuya, ni an ka o bɔ saraka ye o ɲa na, o tɛna an bon ni kabakuru ye ka an faga wa? ");
INSERT INTO dyu_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","An b’a fɛ ka tere saba tagama le kɛ ka taga kongo kɔnɔ, ka taga saraka bɔ Matigi Ala, an ta Ala ye. Ni a yɛrɛ tagara min fɔ an ye, an bɛna o le kɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Farawona ko: «Ayiwa, ne kɔni bɛna a to aw ye taga saraka bɔ Matigi Ala, aw ta Ala ye kongo kɔnɔ, nka aw kana taga yɔrɔjan ka tɛmɛ. Aw ye Ala daari ne ye fana janko limɔgɔw ye taga.» ");
INSERT INTO dyu_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Musa ko: «Ni ne bɔra i fɛ yan, ne bɛna Matigi Ala daari i ye. Sini Ala bɛna limɔgɔw mabɔ i ra, ani i ta jamana ɲamɔgɔw, ani i ta jamana mɔgɔw bɛɛ ra. Nka i kana an nɛgɛ tuun ka ban, k’a to Izirayɛlimɔgɔw ye taga saraka bɔ Matigi Ala ye!» ");
INSERT INTO dyu_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musa bɔra Farawona ta so kɔnɔ minkɛ, a ka Matigi Ala daari. ");
INSERT INTO dyu_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Musa ka min daari, Matigi Ala ka o kɛ. A ka limɔgɔw mabɔ Farawona ra, ani a ta jamana ɲamɔgɔw, ani a ta jamana mɔgɔw bɛɛ ra. Hali limɔgɔ kelen ma to. ");
INSERT INTO dyu_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Nka Farawona belen k’a jusukun gbɛlɛya tuun, a ma sɔn k’a to Izirayɛlimɔgɔw ye taga. ");
INSERT INTO dyu_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Matigi Ala k’a fɔ Musa ye ko: «Taga Farawona fɛ, i ye taga a fɔ a ye ko Matigi Ala, Heburuw ta Ala ko: ‹A to ne ta mɔgɔw ye taga ne bato. ");
INSERT INTO dyu_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ni i ma sɔn k’a to o ye taga, ni i ka o mina ka to yan tuun, ");
INSERT INTO dyu_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","o tuma i ta bɛgan minw bɛ kongo kɔnɔ, ne Matigi Ala bɛna ne ta sebagaya kɛ ka olugu bɛɛ halaki. Banajuguba dɔ bɛna i ta sow mina, ani i ta faliw, ani i ta ɲɔgɔmɛw, ani i ta misiw, ani i ta sagaw, ani i ta baw; o camanba bɛna faga. ");
INSERT INTO dyu_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Nka ne Matigi Ala, ne bɛna faranfasi kɛ Izirayɛlimɔgɔw ta bɛganw, ani Misirankaw ta bɛganw cɛ. Izirayɛlimɔgɔw ta bɛgan si tɛna faga.› » ");
INSERT INTO dyu_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ayiwa, o ko bɛna kɛ lon min na, Matigi Ala ka o latigɛ. A ko: «Sini ne Matigi Ala bɛna o kɛ Misiran jamana kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","O dugusagbɛ, Matigi Ala tun ka min fɔ, a ka o kɛ. Misirankaw ta bɛganw bɛɛ fagara. Nka foyi ma faga Izirayɛlimɔgɔw ta bɛganw na. ");
INSERT INTO dyu_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farawona ka mɔgɔ ci ka taga ɲininkari kɛ o ko ra. O nana a fɔ a ye ko foyi ma faga Izirayɛlimɔgɔw ta bɛganw na. Nka o bɛɛ n’a ta, Farawona belen k’a jusukun gbɛlɛya; a ma sɔn fiyewu k’a to Izirayɛlimɔgɔw ye taga. ");
INSERT INTO dyu_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Matigi Ala k’a fɔ Musa ni Haruna ye ko: «Aw ye taga dibi dɔ ta bugurigbɛ dɔ cɛ. Ele Musa bɛna o bugurigbɛ seri san fɛ Farawona ɲa na. ");
INSERT INTO dyu_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","A bɛna kɛ gbangban ye ka Misiran jamana bɛɛ datugu, ka kɛ sumuni ye mɔgɔw ni bɛganw na; sumuniw bɛna cici ka kɛ joriw ye o fariw ra, Misiran jamana bɛɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Musa ni Haruna tagara dibi dɔ ta bugurigbɛ dɔ cɛ, ka taga ni o ye Farawona fɛ. Musa k’a seri san fɛ. A ka sumuni bɔ mɔgɔw ni bɛganw fari yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Hali Misiran jinamoriw ma se ka bɔ ka taga Farawona fɛ yi, sumuniw kosɔn; sabu sumuni tun bɔra olugu fana fariw ra, ka o fari bɛɛ kɛ jori ye, i n’a fɔ Misiranka tɔw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Nka Ala ka Farawona jusukun gbɛlɛya tuun, i n’a fɔ a tun k’a fɔ Musa ni Haruna ye cogo min na; Farawona ma sɔn ka Musa ni Haruna lamɛn. ");
INSERT INTO dyu_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Matigi Ala k’a fɔ Musa ye ko: «Sini sɔgɔmada joona fɛ, i ye wuri ka taga Farawona fɛ, i ye taga a fɔ a ye ko Matigi Ala, Heburuw ta Ala ko: ‹A to ne ta mɔgɔw ye taga ne bato. ");
INSERT INTO dyu_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ni o tɛ, sisan kɔni ne bɛna tɔɔrɔ min lase i ni i ta jamana ɲamɔgɔw, ani i ta jamana mɔgɔw bɛɛ ma, o bɛna juguya kosɛbɛ. Ne bɛna o kɛ janko i ye a lɔn ko dugukolo bɛɛ kan, mɔgɔ si tɛ se ka a yɛrɛ suma ni ne ye. ");
INSERT INTO dyu_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Sabu ne bɛna ne ta sebagaya yira can yɛrɛ ra, ka banajugu dɔ kɛ ka i halaki, ka i ni i ta jamana mɔgɔw bɛɛ tunu ka bɔ dugukolo kɔ kan. ");
INSERT INTO dyu_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ne ka i ɲanaman to, janko ka ne ta sebagaya le yira i ra, ani janko mɔgɔw ye ne tɔgɔ fɔ dugukolo yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","O bɛɛ n’a ta, hali bi i ka ne ta mɔgɔw bari; i ma sɔn k’a to o ye taga. ");
INSERT INTO dyu_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Sini ɲɔgɔntumasi, ne bɛna sanbɛrɛ jigi; o sanbɛrɛ bɛna juguya fɔ k’a dama tɛmɛ. Kabini Misiran jamana sigira, fɔ ka na se bi ma, o sanbɛrɛ ɲɔgɔn ma deri ka jigi a kan ban. ");
INSERT INTO dyu_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","O ra, i ta bɛganw, ani i ta fɛn o fɛn bɛ foro ra, i jija ka o bɛɛ ladon so kɔnɔ joona. Ni mɔgɔ o mɔgɔ, walama ni bɛgan o bɛgan ka to kongo ra, ni a ma na so kɔnɔ, sanbɛrɛ bɛna jigi olugu bɛɛ kan ka o bɛɛ faga.› » ");
INSERT INTO dyu_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ayiwa, Farawona ta jamana ɲamɔgɔ minw siranna Matigi Ala ta kuma ɲa, olugu ka o ta jɔnw ni o ta bɛganw lana so kɔnɔ joona. ");
INSERT INTO dyu_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Nka minw ma Matigi Ala ta kuma jate, olugu ka o ta jɔnw ni o ta bɛganw to kongo ra yi. ");
INSERT INTO dyu_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Matigi Ala k’a fɔ Musa ye tuun ko: «Bere ta k’a kɔrɔta san fɛ, janko sanbɛrɛ ye jigi mɔgɔw ni bɛganw kan, ani binw bɛɛ, Misiran jamana ra.» ");
INSERT INTO dyu_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa k’a ta bere kɔrɔta san fɛ. Matigi Ala ka sanpɛrɛn ni sanbɛrɛ jigi; sanmanamana kɛra dugukolo yɔrɔ bɛɛ ra. Matigi Ala ka sanbɛrɛ jigi Misiran jamana bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Sanbɛrɛ tun bɛ jigira; sanmanamana tun bɛ yɔrɔ bɛɛ. A tun juguyara kosɛbɛ; kabini Misiran jamana kɛra jamana ye, o ɲɔgɔn tun ma deri ka kɛ fɔlɔ. ");
INSERT INTO dyu_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Sanbɛrɛ jigira Misiran jamana yɔrɔ bɛɛ ra; fɛn o fɛn tun bɛ foro ra, adamaden fara bɛgan kan, sanbɛrɛ ka o bɛɛ halaki. Sanbɛrɛ ka binw bɛɛ faga, ka yiriw bɛɛ karikari. ");
INSERT INTO dyu_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Izirayɛlimɔgɔw tun siginin bɛ jamana yɔrɔ min na, Gosɛni mara ra, o yɔrɔ dɔrɔn le tora; sanbɛrɛ ma se o yɔrɔ le ma. ");
INSERT INTO dyu_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Farawona ka Musa ni Haruna wele, k’a fɔ o ye ko: «Sisan kɔni ne jarakira; Matigi Ala ta le ye can ye. Ne ni ne ta mɔgɔw le jarakira. ");
INSERT INTO dyu_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Aw ye Matigi Ala daari ne ye, a ye sanpɛrɛn ni sanbɛrɛ lalɔ ten. Ne bɛna a to aw ye taga; ne tɛna aw lalɔ tuun.» ");
INSERT INTO dyu_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa k’a fɔ Farawona ye ko: «Ni ne bɔra dugu kɔnɔ tuma min na, ne bɛna ne boro kɔrɔta Matigi Ala ma, k’a daari. Sanpɛrɛn ni sanbɛrɛ bɛna lɔ; janko i ye a lɔn ko dugukolo ye Matigi Ala ta le ye. ");
INSERT INTO dyu_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Nka ne k’a lɔn ko hali ni o kɛra, ele ni i ta jamana ɲamɔgɔw tɛna sɔn ka siran Matigi Ala ɲa hali belen.» ");
INSERT INTO dyu_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ayiwa, sɛnɛfɛn minw tun denna ka ban, ani sɛnɛfɛn minw tun ka fiyeren bɔ i n’a fɔ lɛn, sanbɛrɛ ka o bɛɛ cɛn. ");
INSERT INTO dyu_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Nka alikama* ni ɲɔ, sanbɛrɛ ma olugu cɛn sabu olugu tɛ fiyeren joona. ");
INSERT INTO dyu_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ayiwa, Musa bɔra Farawona ta so ka taga dugu kɔ fɛ. A ka a boro kɔrɔta san fɛ Matigi Ala ma, k’a daari. Sanpɛrɛn ni sanbɛrɛ lalɔra. Sanji ma ben tuun. ");
INSERT INTO dyu_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Farawona k’a ye ko sanji ni sanpɛrɛn ni sanbɛrɛ bɛɛ lɔra minkɛ, a belen tora a ta kojugukɛ ra. A k’a jusukun gbɛlɛya tuun, a ni a ta jamana ɲamɔgɔw. ");
INSERT INTO dyu_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Farawona jusukun gbɛlɛyara, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na; a ma sɔn k’a to Izirayɛlimɔgɔw ye taga fiyewu. ");
INSERT INTO dyu_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Matigi Ala k’a fɔ Musa ye tuun ko: «Taga Farawona fɛ tuun. Ne le ka ale ni a ta jamana mɔgɔw jusukun gbɛlɛya, janko ka ne ta tagamasiyɛnw kɛ o cɛ ra, o ye a ye; ");
INSERT INTO dyu_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ani janko ne ka Misirankaw tɔɔrɔ cogo min na, ni ne ta tagamasiyɛnw ye, i ye o bɛɛ lakari i denw, ani i mamadenw ye. Aw bɛɛ ka kan k’a lɔn ko ne le ye Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musa ni Haruna tagara Farawona fɛ ka taga a fɔ a ye ko: «Matigi Ala, Heburuw ta Ala ko, ko lon juman le i bɛna sɔn ka i yɛrɛ majigi a le ye dɛ? A ko i ye a ta mɔgɔw bla o ye taga ale bato. ");
INSERT INTO dyu_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","A ko ni i ma sɔn ka ale ta mɔgɔw bla o ye taga, sini a bɛna tɔnw bla ka na Misiran jamana yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Tɔnw bɛna i ta dugukolo yɔrɔ bɛɛ datugu fɔ mɔgɔ tɛna se ka dugukolo yɔrɔ si ye. Sanbɛrɛ ma se ka sɛnɛfɛn minw cɛn, tɔnw bɛna o bɛɛ domu; yiri o yiri bɛ kongo ra, o bɛna o bɛɛ flaburuw ɲimi. ");
INSERT INTO dyu_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","O bɛna don i ta bon kɔnɔ, ka i ta bonkɔnɔyɔrɔw fa, ani i ta jamana ɲamɔgɔw ta bonw, ani Misirankaw bɛɛ ta bonw. Kabini i faw ni i bɛmaw bɛ nin jamana ra yan, fɔ ka na se bi ma, o ɲa ma kojugu min ɲɔgɔn ye ban, o le bɛna kɛ.» Musa ni Haruna ka o fɔ minkɛ, o bɔra Farawona ta so kɔnɔ ka taga. ");
INSERT INTO dyu_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ayiwa, Farawona ta jamana ɲamɔgɔw ko a ma ko: «O tuma cɛ nin bɛna an sɛgɛ tan le tuma bɛɛ wa? I t’a to o ye taga Matigi Ala, o ta Ala bato wa? Hali bi i belen m’a lɔn ko Misiran jamana bɛ halakira ka taga le wa?» ");
INSERT INTO dyu_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ayiwa, o ka Musa ni Haruna wele tuun ka na Farawona fɛ. Farawona ko o ma ko: «Aw ye taga Matigi Ala, aw ta Ala bato. Nka jɔn ni jɔn le bɛna taga aw ra?» ");
INSERT INTO dyu_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa ka Farawona jaabi ko: «An bɛɛ lo; an ta kanbelenw, ani an ta cɛkɔrɔbaw, ani an dencɛw ni an denmusow bɛɛ; hali an ta sagaw, ani an ta baw, ani an ta misiw bɛɛ bɛ taga, sabu an bɛna ɲanagbɛba le kɛ ka Matigi Ala, an ta Ala bonya.» ");
INSERT INTO dyu_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farawona ko: «K’a fɔ ko ne bɛna aw bla ka taga ni aw ta musow ni aw ta denw ye, ko Matigi Ala bɛ aw fɛ, ne tɛ o kɛ fiyewu; ne k’a lɔn ko aw bɛ kojugu dɔ le miirira. ");
INSERT INTO dyu_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Aw ka min fɔ, o tɛ kɛ. Aw cɛw dama le ye taga Matigi Ala bato, sabu aw ko ten le.» O kɔ, o ka Musa ni Haruna gbɛn ka bɔ Farawona ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Matigi Ala k’a fɔ Musa ye tuun ko: «I ta bere mina i boro k’a kɔrɔta Misiran jamana kunna, ka tɔnw bɔ k’a kɛ Misiran jamana kan caman, o ye bin bɛɛ ɲimi, ani fɛn o fɛn tora sanbɛrɛ tɛmɛnin kɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa ka a ta bere kɔrɔta Misiran jamana kunna. Matigi Ala ka fɔɲɔba dɔ lawuri ka bɔ terebɔyanfan na. O fɔɲɔ nana o lon tere bɛɛ, ani su bɛɛ. O dugusagbɛ sɔgɔma, fɔɲɔ nana ni tɔnw ye caman; ");
INSERT INTO dyu_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","tɔnw bɔra ka don Misiran jamana ra. Jamana yɔrɔ bɛɛ fara tɔnw na, tɔn camanba. A ɲɔgɔn tun ma kɛ ka ye, a ɲɔgɔn fana tɛna kɛ ka ye. ");
INSERT INTO dyu_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Misiran dugukolo bɛɛ fara tɔnw na, fɔ ka yɔrɔ bɛɛ kɛ dibi ye. O ka binw bɛɛ ɲimi, ani yiridenw bɛɛ. Fɛn o fɛn tun tora sanbɛrɛ tɛmɛnin kɔ, o ka o bɛɛ domu. Flaburu foyi ma to yiri si ra, bin foyi ma to kongo ra, ni o ma min ɲimi, Misiran jamana bɛɛ kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Farawona teliyara ka Musa ni Haruna wele, ka na a fɔ o ye ko: «Ne ka aw ta Matigi Ala hakɛ ta, ka aw fana hakɛ ta. ");
INSERT INTO dyu_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Nka aw ye yafa ne ma nin kelen na, ka Matigi Ala, aw ta Ala daari ne ye janko a ye nin tɔɔrɔjuguba mabɔ ne ra.» ");
INSERT INTO dyu_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa bɔra Farawona ta so kɔnɔ ka taga Matigi Ala daari. ");
INSERT INTO dyu_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Matigi Ala ka fɔɲɔba dɔ lawuri ka bɔ terebenyanfan na. O fɔɲɔ ka tɔnw bɛɛ cɛ ka taga o kɛ Kɔgɔjiwulen na. Tɔn den kelen ma to Misiran jamana yɔrɔ si ra. ");
INSERT INTO dyu_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nka o bɛɛ n’a ta, Matigi Ala ka Farawona jusukun gbɛlɛya tuun. A ma sɔn ka Izirayɛlimɔgɔw bla o ye taga. ");
INSERT INTO dyu_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Matigi Ala ko Musa ma tuun ko: «I ta bere mina i boro k’a kɔrɔta san fɛ, janko dibikuruba ye don Misiran jamana fan bɛɛ ra; o dibi bɛna bonya fɔ k’a kɛ i n’a fɔ mɔgɔ bɛna maga a ra.» ");
INSERT INTO dyu_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ayiwa, Musa k’a ta bere kɔrɔta san fɛ; dibikuruba donna Misiran jamana fan bɛɛ ra, ka se fɔ tere saba. ");
INSERT INTO dyu_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Mɔgɔw tun tɛ sera ka ɲɔgɔn ye dibi bonyakojugu fɛ. Tere saba kɛra, mɔgɔ si ma se ka bɔ a ta so kɔnɔ; nka kɛnɛ tun bɛ Izirayɛlimɔgɔw ta yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farawona ka Musa wele tuun k’a fɔ a ye ko: «Aw ye taga Matigi Ala, aw ta Ala bato. Aw ye taga ni aw ta denmisɛnw bɛɛ ye. Aw ta sagaw ni aw ta baw, ni aw ta misiw dɔrɔn le bɛna to yan.» ");
INSERT INTO dyu_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa ko: «An bɛna taga fɛn minw kɛ saraka ye, ani an bɛna bɛgan minw kɛ saraka jɛnitaw ye k’a di Matigi Ala, an ta Ala ma, i ka kan k’a to an ye taga ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Anw kɔni bɛna taga ni an ta bɛganw bɛɛ le ye, hali kelen tɛna to an kɔ fɛ yan; sabu an bɛna o dɔw le kɛ saraka ye k’a di Matigi Ala, an ta Ala ma. Nka ni an ma se a yɔrɔ yɛrɛ ra, an bɛna min ni min kɛ saraka ye k’a di Matigi Ala, an ta Ala ma, an tɛ se ka o lɔn.» ");
INSERT INTO dyu_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Nka Matigi Ala ka Farawona jusukun gbɛlɛya tuun. A ma sɔn ka Izirayɛlimɔgɔw bla o ye taga ka bɔ a ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farawona pɛrɛnna Musa kunna, ko: «Tɛmɛ ka bɔ ne ta so kɔnɔ sisan! A dan ye kɛ nin ye. Ne kana i ye ne fɛ yan tuun; sabu ni ne ka i ye ne fɛ yan lon o lon, ne bɛ i faga o lon.» ");
INSERT INTO dyu_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa ko: «Ayiwa, ni i ko ten, ne k’a mɛn; ne tɛna se i fɛ yan tuun.» ");
INSERT INTO dyu_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Matigi Ala k’a fɔ Musa ye ko: «Ne bɛna tɔɔrɔba kelen lase Farawona ni Misirankaw ma tuun, ka o kɛ a laban ye. O kɔ, a bɛna aw bla aw ye taga. A yɛrɛ bɛna aw gbɛn le pewu ko aw ye taga ka bɔ a ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","A fɔ Izirayɛlimɔgɔw ye ko ni aw tagatuma sera, cɛw ni musow bɛɛ ye warigbɛfɛnw ni saninmanfɛnw daari o sigiɲɔgɔnw fɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Matigi Ala tun ka Izirayɛlimɔgɔw ko diya Misirankaw ye kosɛbɛ. Farawona ta jamana ɲamɔgɔw, ani Misirankaw bɛɛ tun bɛ Musa yɛrɛ bonyara kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ayiwa, Musa tagara a fɔ Farawona ye ko Matigi Ala ko, ko su cɛmancɛ ra, ale bɛna tɛmɛ Misiran jamana kɔnɔ; ");
INSERT INTO dyu_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ko dencɛ fɔlɔ bɛɛ bɛna sa Misiran jamana kɔnɔ. Masacɛ Farawona ni a ta masaya bɛɛ, o dencɛ fɔlɔ tɛna to; hali jɔnmuso gbansan min bɛ mugu si, o fana dencɛ fɔlɔ tɛna to, bɛganw fana den fɔlɔw cɛmanw tɛna to. ");
INSERT INTO dyu_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kulekanba caman bɛna bɔ Misiran jamana yɔrɔ bɛɛ ra. Sabu o ko ɲɔgɔn ma deri ka kɛ fɔlɔ, a ɲɔgɔn yɛrɛ fana tɛna kɛ tuun. ");
INSERT INTO dyu_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Nka Izirayɛlimɔgɔw fɛ, hali wuru tɛna kasi, k’a fɔ ko a bɛ sɔngɔra mɔgɔ ra, walama bɛgan na; a bɛna o kɛ janko faranfasi min bɛ Misirankaw ni Izirayɛlimɔgɔw cɛ Matigi Ala fɛ, aw ye o lɔn. ");
INSERT INTO dyu_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","O tuma ra i ta jamana ɲamɔgɔw bɛɛ bɛna o kinbiri gban ne kɔrɔ, k’a fɔ ne ye ko: «Taga, i ni i ta nɔfɛmɔgɔw bɛɛ.» O le kɔ, ne bɛ sɔrɔ ka bɔ ka taga ni ne ta mɔgɔw ye. Musa ka o kumaw fɔ minkɛ, a dimininba bɔra Farawona ta so ka taga. ");
INSERT INTO dyu_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ayiwa, Matigi Ala tun k’a fɔ Musa ye kabini a damina ra ko: «Farawona tɛna sɔn ka aw lamɛn. O bɛna kɛ sababu ye k’a to ne ye dɔ fara ne ta kabakow kan, ka ne ta sebagaya yira Misiran jamana kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ayiwa, Musa ni Haruna ka o kabakow kɛ Farawona ɲa na, nka Matigi Ala ka Farawona jusukun gbɛlɛya, a ma sɔn k’a to Izirayɛlimɔgɔw ye taga ka bɔ a ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ayiwa, ka Musa ni Haruna to Misiran jamana ra, Matigi Ala k’a fɔ o ye, ko: ");
INSERT INTO dyu_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Nin karo le bɛna kɛ karo fɔlɔ ye; ale le bɛna kɛ san karo fɔlɔ ye aw fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Aw ye a fɔ Izirayɛlimɔgɔw ye, ko: ‹San o san, nin karo tere tan, gba bɛɛ kelen kelen ye sagadennin kelen, walama badennin kelen mina; lu bɛɛ kelen kelen ni a ta sagaden walama baden. ");
INSERT INTO dyu_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ni lu min mɔgɔw man ca, olugu ni o sigiɲɔgɔnw ye jɛn bɛgan kelen na, ka kaɲa ni mɔgɔw hakɛya ye. Mɔgɔ hakɛya min bɛ se ka bɛgan kelen domu k’a ban, aw ye o da le jate mina. ");
INSERT INTO dyu_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","A ka kan ka kɛ bɛganden cɛman le ye, fiyɛn tɛ min na, min ka san kelen sɔrɔ fana. ");
INSERT INTO dyu_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Aw ye a mina k’a bla ka se fɔ karo tere tan ni naani ma. Izirayɛlimɔgɔw bɛɛ bɛna o bɛganden faga karo tere tan ni naaninan wulada fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Aw bɛna a sogo ɲimi bon min kɔnɔ, aw ye a jori dɔ seriseri o bon donda kɛrɛfɛyɔrɔ fla ni a sanfɛyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","O su kelen na, aw ye a sogo jɛni k’a domu; aw ye a ni burufunubari le domu, ani ɲuguflaburu kunaman dɔ. ");
INSERT INTO dyu_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Aw kana a kɛnɛ domu, walama a barabaranin; aw ye a kuturu le jɛni; a kun, ni a senw, ni a kɔnɔfɛnw. ");
INSERT INTO dyu_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Aw man kan k’a to a tɔ ye si. Ni a tɔ min sira, aw ye o jɛni ka a sisi fɔ k’a kɛ buguri ye. ");
INSERT INTO dyu_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Aw bɛna a domu cogo min na, o flɛ nin ye: aw bɛ aw ta deregew don ka aw yɛrɛ cɛsiri, ka aw ta sanbaraw don aw senw na, ka aw ta tagamabere mina aw boro; aw ye a domu teliya ra. Jɔnyaban ɲanagbɛ* lo; aw ye o kɛ ka Matigi Ala bonya. ");
INSERT INTO dyu_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","« ‹Bi su nin yɛrɛ ra, ne bɛna tɛmɛ Misiran jamana yɔrɔ bɛɛ ra, ka Misiran jamana den fɔlɔ cɛmanw bɛɛ faga; k’a ta mɔgɔw ra, ka taga a bla bɛganw na. Ne bɛna kiti ben Misiran batofɛnw bɛɛ kan; sabu ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Nka aw bɛna kɛ bon min kɔnɔ, jori le bɛna kɛ tagamasiyɛn ye o bondaw ra. Ni ne ka jori ye, ne bɛ tɛmɛ aw ta bonw kan. O cogo ra ni ne nana kɛ Misirankaw faga ye tuma min na, o tɔɔrɔw tɛna se aw ma. ");
INSERT INTO dyu_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","« ‹Nin lon bɛna kɛ aw fɛ hakirijigilonba le ye tuma bɛɛ. Aw bɛna ɲanagbɛba kɛ o lon na, ka Matigi Ala bonya. O ye kɛ sariya dablabari ye aw fɛ, ani aw ta duruja nataw bɛɛ fɛ.› » ");
INSERT INTO dyu_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Matigi Ala k’a fɔ tuun ko: «Aw bɛna burufunubari domu fɔ tere wolonfla. K’a damina a tere fɔlɔ ra, burufunufɛn si man kan ka ye aw ta sow kɔnɔ tuun; sabu ni mɔgɔ o mɔgɔ ka burufununin domu, o tere wolonfla kɔnɔ, o tigi bɛ faran ka bɔ Izirayɛli ta jamanadenw na. ");
INSERT INTO dyu_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A tere fɔlɔ ra, aw bɛna jamalajɛnba kɛ, ka Matigi Ala bato. A tere wolonflanan fana ra, aw bɛna jamalajɛnba kɛ tuun ka Matigi Ala bato. Mɔgɔ si man kan ka baara kɛ o lon fla ra; aw bɛ se ka aw ta tobiriw dɔrɔn le kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Aw ye to ka burufunubari ɲanagbɛ kɛ san o san, ka aw hakiri jigi ko o lon yɛrɛ le ra ne ka aw kɛ jɛnkuru jɛnkuru, ka aw labɔ Misiran. Aw ye o lon bla danna ka o ɲanagbɛ kɛ, a ye kɛ sariya dablabari ye aw ni aw denw fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","San karo fɔlɔ, k’a damina a tere tan ni naani wulada fɛ, fɔ ka taga se a tere mugan ni kelen wulada fɛ, aw ye burufunubari le domu. ");
INSERT INTO dyu_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","O tere wolonfla bɛɛ kɔnɔ, burufunufɛn si man kan ka ye aw si ta so kɔnɔ; sabu ni mɔgɔ o mɔgɔ ka burufununin domu, lonan fara dugulen kan, o tigi bɛ faran ka bɔ Izirayɛlimɔgɔw ta jɛn ra o lon na. ");
INSERT INTO dyu_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Burufunufɛn bɛ buru o buru ra, aw kana o domu. Bɛɛ ka kan ka burufunubari le domu a ta so kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ayiwa, Musa ka Izirayɛli cɛkɔrɔbaw bɛɛ wele k’a fɔ o ye ko: «Aw bɛɛ ye taga sagaden kelen walama baden kelen mina, gba bɛɛ ni a ta, k’a faga ka Jɔnyaban ɲanagbɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Aw ye sagaden kannatigɛ k’a jori kɛ minan dɔ kɔnɔ, ka izopeyiri flaburu dɔw su o jori ra, ka o jori seriseri bonda sanfɛyɔrɔ ra, ani a kɛrɛfɛyɔrɔ fla ra. Mɔgɔ si kana bɔ a ta so kɔnɔ fɔ ka taga dugu gbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ni Matigi Ala nana kɛ tɛmɛ ye, ka kɛ Misirankaw faga ye tuma min na, ni a ka jori ye bonda min sanfɛyɔrɔ ni a kɛrɛfɛyɔrɔ fla ra, a bɛ tɛmɛ o bon kan; a tɛna sɔn ninminamɛlɛkɛ ye don aw ta bon kɔnɔ ka aw faga. ");
INSERT INTO dyu_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Aw ye nin sariyaw sira tagama, ka o kɛ sariya dablabariw ye aw ni aw ta durujaw fɛ wagati bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Matigi ka layiri ta ko a bɛna jamana min di aw ma, ni aw tagara se o jamana ra tuma o tuma, aw ye to ka nin landa saninman kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ni aw ta denw ka aw ɲininka ko: ‹Nin landa kɔrɔ ye di aw fɛ?› ");
INSERT INTO dyu_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Aw ye a fɔ o ye ko: ‹Nin ye Jɔnyaban saraka le ye; an bɛ o kɛ ka Matigi Ala, an ta Ala bonya, sabu ka an to Misiran, tuma min na Matigi Ala ka Misirankaw den fɔlɔw faga, a tɛmɛna Izirayɛlimɔgɔw ta sow kan, a ma se olugu ma; a ka o kisi.› » Ayiwa, Musa ka o kumaw bɛɛ fɔ minkɛ, o tuma ra mɔgɔw bɛɛ ka o kinbiri gban dugu ma, ka Matigi Ala bato. ");
INSERT INTO dyu_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","O kɔ, Izirayɛlimɔgɔw tagara o ta sow kɔnɔ. Matigi Ala tun ka fɛn o fɛn fɔ Musa ni Haruna ye, o ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ayiwa, su cɛmancɛ ra, Matigi Ala ka Misiran jamana den fɔlɔw bɛɛ faga. K’a ta Misiran masacɛba yɛrɛ den fɔlɔ ra, ka taga a bla fɔ Misiran kasoden gbansanw den fɔlɔw ra, ani bɛganw den fɔlɔw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","A kɛra ten, Farawona ni a ta jamana ɲamɔgɔw ni Misirankaw bɛɛ wurira dugutarama fɛ. Kasikanbaw ni kulekanbaw tun bɛ bɔra jamana yɔrɔ bɛɛ ra; sabu so si ma to, ni saya ma kɛ min na. ");
INSERT INTO dyu_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","O su yɛrɛ fɛ, Farawona ka Musa ni Haruna wele k’a fɔ o ye ko: «Aw ye teliya ka taga ka bɔ ne ta mɔgɔw cɛ ra, aw ni Izirayɛlimɔgɔw bɛɛ; aw ye taga Matigi Ala bato i n’a fɔ aw k’a fɔ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Aw ye taga ni aw ta misiw, ani aw ta sagaw, ani aw ta baw ye, i n’a fɔ aw k’a fɔ cogo min na. Aw ye taga Ala daari ne ye.» ");
INSERT INTO dyu_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misirankaw gbanna Izirayɛlimɔgɔw ra, ko o ye bɔ; o tun kɔrɔtɔra ko Izirayɛlimɔgɔw ye bɔ o ta jamana ra; sabu o tun bɛ a miirira ko olugu Misirankaw bɛɛ le bɛna sa. ");
INSERT INTO dyu_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Izirayɛlimɔgɔw ka o ta mugu nɔɔninin ta, k’a sɔrɔ a tun ma funu fɔlɔ; o ka o ta burugbasiminanw bɛɛ siri o ta faniw na, ka o la o kamankun na. ");
INSERT INTO dyu_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ayiwa, Musa tun ka min fɔ Izirayɛlimɔgɔw ye, o ka o kɛ. O ka minan warigbɛramanw, ani minan saninlaman ni faniw daari Misirankaw fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Matigi Ala ka Izirayɛlimɔgɔw ko diya Misirankaw ye fana. Izirayɛlimɔgɔw ka fɛn o fɛn daari o fɛ, o ka o bɛɛ di o ma. Izirayɛlimɔgɔw ka Misirankaw ta fɛnw cɛ o cogo le ra ka o borolakolon to. ");
INSERT INTO dyu_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Izirayɛlimɔgɔw bɔra Ramusɛsi dugu kɔnɔ, ka taga se Sukɔti. Minw tun bɛ o sen na olugu tun bɛ mɔgɔ waga kɛmɛ wɔɔrɔ bɔ (600 000); musow ni denmisɛnw ma jate. ");
INSERT INTO dyu_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","O tagatɔ, siya wɛrɛ mɔgɔ caman tugura o kɔ; bɛgan caman tun bɛ olugu fana fɛ: misiw, ani sagaw, ani baw. ");
INSERT INTO dyu_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Izirayɛlimɔgɔw bɔtɔ Misiran, o tun ka mugu nɔɔninin min ta, k’a sɔrɔ a ma funu fɔlɔ, o ka o le jɛni ka o kɛ buru ye ka o domu; sabu Misirankaw tun bɛ gbanna o ra ko o ye bɔ minkɛ, o ma se ka domunifɛn ta o yɛrɛ boro. ");
INSERT INTO dyu_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Izirayɛlimɔgɔw tun ka san kɛmɛ naani ni san bisaba le kɛ Misiran. ");
INSERT INTO dyu_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","O san kɛmɛ naani ni san bisaba dafalon yɛrɛ le ra Matigi Ala ka Izirayɛlimɔgɔw kɛ jɛnkuru jɛnkuru, ka o bɛɛ labɔ Misiran. ");
INSERT INTO dyu_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","O kosɔn o su bɛna bla a danna Matigi ye, ka kɛ ɲanagbɛsu ye, sabu Matigi Ala ka o su bla danna, ka Izirayɛlimɔgɔw labɔ Misiran jamana ra o su fɛ. Izirayɛlimɔgɔw ni o ta durujaw bɛɛ ka kan ka o su bla danna fana, ka o kɛ ɲanagbɛsuba ye ka Matigi Ala bonya. ");
INSERT INTO dyu_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Matigi Ala k’a fɔ Musa ni Haruna ye tuun ko: «Jɔnyaban ɲanagbɛ sariya ye nin ye: jamana wɛrɛ mɔgɔ man kan k’a saraka domu. ");
INSERT INTO dyu_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ni jɔn dɔ bɛ aw fɛ, aw ka min san, aw ka kan k’a kɛnɛsigi fɔlɔ, sani a ye Jɔnyaban ɲanagbɛ* domuni kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Nka lonan tɛmɛbaga, ani baaraden, olugu si man kan k’a domu. ");
INSERT INTO dyu_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Aw ka kan k’a domu bon le kɔnɔ. Mɔgɔ si kana bɔ ni a sogo dɔ ye kɛnɛ ma; aw man kan k’a kolo dɔ kari fana. ");
INSERT INTO dyu_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","«Izirayɛlimɔgɔw bɛɛ ka kan ka Jɔnyaban ɲanagbɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Lonan minw siginin bɛ aw fɛ, ni o dɔ b’a fɛ ka Jɔnyaban ɲanagbɛ kɛ ka Matigi Ala bonya, cɛ o cɛ bɛ a ta so, olugu bɛɛ ka kan ka kɛnɛsigi fɔlɔ; ni o kɛra, a bɛ se ka Jɔnyaban ɲanagbɛ kɛ. O tuma, a bɛ kɛ i ko Izirayɛlimɔgɔ dɔ. Nka ni mɔgɔ o mɔgɔ ma kɛnɛsigi, o tigi man kan ka Jɔnyaban ɲanagbɛ domuni kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","O sariya kelen le bɛ Izirayɛlimɔgɔw ni lonanw bɛɛ kan.» ");
INSERT INTO dyu_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Matigi Ala ka ci min fɔ Musa ni Haruna ye, Izirayɛlimɔgɔw ka o kɛ k’a dafa. ");
INSERT INTO dyu_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","O lon yɛrɛ ra, Matigi Ala ka Izirayɛlimɔgɔw ta gbaw tugutugu ɲɔgɔn kɔ, ka o kɛ jɛnkuru jɛnkuru, ka o labɔ Misiran jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Matigi Ala k’a fɔ Musa ye ko: ");
INSERT INTO dyu_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Izirayɛlimɔgɔw dencɛ fɔlɔw bɛɛ bla danna ka o kɛ ne ta ye. Mɔgɔw dencɛ fɔlɔw, ani bɛganw ta den fɔlɔ cɛmanw bɛɛ; sabu o ye ne ta le ye.» ");
INSERT INTO dyu_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa k’a fɔ mɔgɔw ye ko: «Aw ye aw hakiri to nin lon na, aw bɔra Misiran jɔnya ra lon min na; sabu Matigi Ala ka aw labɔ Misiran ni a yɛrɛ ta sebagaya baraka le ye. O kosɔn aw kana burufununin domu o lon na. ");
INSERT INTO dyu_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Aw bɛna bɔ bi le, nin karo ra, min ye Abibu karo ye. ");
INSERT INTO dyu_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","«Matigi Ala karira aw bɛmaw ye ko a bɛna Kanaanakaw, ni Hɛtikaw, ni Amɔrikaw, ni Hevikaw, ni Yebusikaw ta jamana le di aw ma, nɔnɔ ni li bɛ woyo o jamana min na. Ni Matigi Ala nana aw ladon o jamana ra tuma min na, san o san, ni nin karo sera, aw ye Jɔnyaban ɲanagbɛ* kɛ ka Matigi Ala bonya. ");
INSERT INTO dyu_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Aw bɛna burufunubari domu fɔ tere wolonfla. A tere wolonflanan bɛna kɛ ɲanagbɛba ye ka Matigi Ala bonya. ");
INSERT INTO dyu_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Bɛɛ bɛna burufunubari le domu fɔ tere wolonfla. Burufununin man kan ka sɔrɔ aw ta bonw si kɔnɔ; burufunufɛn si man kan ka ye yɛrɛ jamana yɔrɔ si ra fana. ");
INSERT INTO dyu_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","«O ɲanagbɛ wagati ra, aw ka kan k’a ɲafɔ aw ta denw ye ko: ‹Matigi Ala ka koba min kɛ an ye an bɔtɔ Misiran, an bɛ nin kɛra ka an hakiri jigi o le ra.› ");
INSERT INTO dyu_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Nin ɲanagbɛ bɛna kɛ hakirijigifɛn le ye aw fɛ, ka kɛ i n’a fɔ tagamasiyɛn aw borow ra, ani aw tenw kan. A bɛna aw hakiri jigi, ko aw ka kan ka to ka Matigi Ala ta sariya ko fɔ tuma bɛɛ; sabu Matigi Ala le ka aw labɔ Misiran a ta sebagaya baraka ra. ");
INSERT INTO dyu_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","O le kosɔn aw bɛna to ka nin landa kɛ a wagati ra san o san. ");
INSERT INTO dyu_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Matigi Ala karira aw ni aw bɛmaw ye, ko a bɛna Kanaanakaw ta jamana di aw ma; ni a nana o jamana kɛ aw ta ye tuma min na, ka aw ladon o jamana ra, ");
INSERT INTO dyu_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","o tuma aw bɛna aw dencɛ fɔlɔw bɛɛ di Matigi Ala ma, hali aw ta bɛganw ta den fɔlɔ cɛmanw. O den cɛmanw ye Matigi Ala ta le ye. ");
INSERT INTO dyu_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","«Ni faliden lo, aw ye sagaden, walama baden dɔ di a nɔ ra, k’a kunmabɔ. Ni aw t’a fɛ k’a kunmabɔ, o tuma aw ye o faliden kan kari k’a faga. Aw ka kan ka aw yɛrɛ dencɛ fɔlɔw fana kunmabɔ. ");
INSERT INTO dyu_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","«Ayiwa, ni aw dencɛw nana aw ɲininka lon dɔ ko: ‹Nin kɛkun ye mun ye aw fɛ?› Aw ye a fɔ o ye ko: ‹An bɛ nin kɛ, sabu Matigi Ala ka an kunmabɔ ka bɔ jɔnya ra Misiran, a ta sebagaya baraka ra. ");
INSERT INTO dyu_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Farawona tun t’a fɛ ka sɔn fiyewu k’a to an ye taga minkɛ, Matigi Ala ka Misiran jamana den fɔlɔ cɛmanw bɛɛ faga; k’a damina mɔgɔw ta den fɔlɔw ra, fɔ ka taga se bɛganw ta den fɔlɔw ma. O le kosɔn an bɛ bɛganden fɔlɔ cɛmanw bɛɛ di Ala ma saraka ye, ka an yɛrɛ dencɛ fɔlɔw bɛɛ kunmabɔ.› ");
INSERT INTO dyu_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","«Ayiwa, nin bɛna kɛ hakirijigifɛn le ye aw fɛ, ka kɛ i n’a fɔ tagamasiyɛn, aw boro ra walama aw ten kan. Aw ka kan ka aw hakiri jigi a ra ko Matigi Ala le ka aw labɔ Misiran jɔnya ra a ta sebagaya baraka ra.» ");
INSERT INTO dyu_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Tuma min na Farawona sɔnna k’a to Izirayɛlimɔgɔw ye taga, Ala m’a to o ye tɛmɛ Filisikaw ta jamana sira fɛ, k’a sɔrɔ o sira le ka surun. A tun k’a lɔn ko ni o ka o sira ta, ni o ka taga bɛn nin siya wɛrɛw ye minw b’a fɛ ka o kɛrɛ, o bɛna siran, ka o ta miiriya yɛlɛma, ka kɔsegi Misiran tuun. ");
INSERT INTO dyu_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","O le kosɔn Ala k’a to o munumununa kongokolon sira fɛ, ka taga fɔ Kɔgɔjiwulen fan fɛ. Izirayɛlimɔgɔw bɔra Misiran ni o ta kɛrɛkɛminanw ye o boro. ");
INSERT INTO dyu_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa ka Yusufu kolow ta ka taga ni o ye o boro; sabu sani Yusufu tun ye sa, a tun k’a balemacɛw jagboya ko o ye kari ale ye. A tun k’a fɔ o ye ko: «Sigiya t’a ra, Ala bɛna na, ka na aw labɔ yan; ni ne sara, aw tagatɔ, aw ye taga ni ne kolow ye.» ");
INSERT INTO dyu_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ayiwa, Izirayɛlimɔgɔw bɔra Sukɔti, ka taga o ta fanibonw lɔ Etamu, kongokolon kɛrɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ayiwa, Matigi Ala yɛrɛ le tun bɛ o ɲa, ka sira yira o ra. Tere fɛ, sankaba jamijan dɔ le tun bɛ kɛ o ɲa, ka sira yira o ra. Su fɛ, a tun bɛ kɛ tasumamana jamijan dɔ ye, ka yeelen bɔ o ye, janko o ye tagama su ni tere. ");
INSERT INTO dyu_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Sankaba jamijan tun tɛ bɔ o ɲa fiyewu tere fɛ; tasumamana jamijan fana tun tɛ bɔ o ɲa su fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Matigi Ala k’a fɔ Musa ye ko: ");
INSERT INTO dyu_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«A fɔ Izirayɛlimɔgɔw ye ko o ye kɔsegi ka na sigi Pi Hayirɔti yɔrɔ kɛrɛ fɛ, Migidɔli ni kɔgɔji cɛ. Aw ye aw ta fanibonw lɔ yi le, ka ɲasin Baali Sefɔn ma, kɔgɔji kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ni o kɛra, Farawona bɛna a miiri ko aw tununa kongokolon kɔnɔ, ko aw ma tagayɔrɔ lɔn aw yɛrɛ ra tuun; ko aw kɛra i ko kasodenw, kongokolon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ne bɛna Farawona jusukun gbɛlɛya fɔ a bɛna wuri ka aw nɔgbɛn; nka ne bɛna ale ni a ta kɛrɛkɛjama bɛɛ halaki ka ne ta sebagaya yira. O ra Misirankaw bɛɛ bɛna a lɔn ko ne le ye Matigi Ala ye.» Matigi Ala ka min fɔ, Izirayɛlimɔgɔw ka o kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ayiwa, o nana taga a fɔ Misiran masacɛ Farawona ye ko Izirayɛlimɔgɔw tagara. O yɔrɔnin bɛɛ, Farawona ni a ta jamana ɲamɔgɔw nimisara o tagako ra. O ko: «Mun kosɔn an k’a to o tagara dɛ? An tun ka kan ka o to yan, o ye baara kɛ an ye.» ");
INSERT INTO dyu_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Farawona k’a ta sowotoro labɛn, k’a ta kɛrɛkɛdenw bɛɛ cɛ, o ka gban Izirayɛlimɔgɔw kɔ. ");
INSERT INTO dyu_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Sowotoroɲuman minw labɛnnin lo ka ɲa kɛrɛ kama, a ka o kɛmɛ wɔɔrɔ ta, ka fara Misiran sowotoro tɔw kan. Sowotorow bɛɛ labɛnnin tun lo, o bɛɛ bɛ ni o ta kɛrɛkɛdenw ye. ");
INSERT INTO dyu_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Matigi Ala ka Misiran masacɛ Farawona jusukun gbɛlɛya, fɔ Farawona tugura Izirayɛlimɔgɔw kɔ, k’a sɔrɔ Izirayɛlimɔgɔw ja siginin le tun bɔra Misiran ka taga, hali siranya ma kɛ o ra. ");
INSERT INTO dyu_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Misirankaw ta kɛrɛkɛjama, ani Farawona ta sow bɛɛ, ani a ta sowotorow, ani a ta sotigiw, olugu ka Izirayɛlimɔgɔw nɔ gbɛn fɔ ka taga se o ma Pi Hayirɔti yɔrɔ ra, ka ɲasin Baali Sefɔn yɔrɔ ma; Izirayɛlimɔgɔw tun ka o ta fanibonw lɔ o yɔrɔ le ra, kɔgɔjida ra. ");
INSERT INTO dyu_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Izirayɛlimɔgɔw nana flɛri kɛ k’a ye ko Farawona ni Misirankaw bɛ olugu kɔ, fɔ ka surunya o ra yɛrɛ. O ja tigɛra kosɛbɛ. O ka kɛ kule ye, ka kɛ Matigi Ala tɔgɔ wele ye, ko a ye olugu dɛmɛ. ");
INSERT INTO dyu_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","O ko Musa ma ko: «O tuma, anw sudonyɔrɔ le tun ma sɔrɔ Misiran wa, badi? A kɛra di i ka an labɔ yi ka na ni an ye kongokolon kɔnɔ yan, ka na a to an ye sa yan gbansan? ");
INSERT INTO dyu_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ka an to Misiran, an tun ka o le fɔ i ye. An tun ko i ye an to ɲasuma ra, an ye baara kɛ Misirankaw ye; sabu o tun ka fisa an ma sani an ye na sa kongokolon kɔnɔ yan tan.» ");
INSERT INTO dyu_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa ka o jaabi ko: «Aw ye to yɔrɔ kelen na, aw kana siran. Matigi Ala bɛna aw kisi cogo min na bi, aw bɛna o ye; sabu aw ɲa bɛ Misiranka minw na tan bi, aw ɲa tɛna la olugu dɔ kan tuun fiyewu. ");
INSERT INTO dyu_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Matigi Ala yɛrɛ le bɛna o kɛrɛ aw nɔ ra; aw ye je dɔrɔn.» ");
INSERT INTO dyu_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Matigi Ala k’a fɔ Musa ye ko: «Mun kosɔn i bɛ kulera ko ne ye aw dɛmɛ? A fɔ jama ye ko o ye sira ta ka taga. ");
INSERT INTO dyu_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ele Musa, ele ye i ta bere ta i boro k’a kɔrɔta kɔgɔji kunna. Ji bɛna cɛtigɛ fla ye, Izirayɛlimɔgɔw bɛna tagama ka tɛmɛ dugukolo jalan kan. ");
INSERT INTO dyu_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ne min ye Matigi Ala ye, ne bɛna Misirankaw jusukun gbɛlɛya, k’a to o ye don aw kɔ. O cogo le ra, ne bɛna Farawona ni a ta kɛrɛkɛjama, ani a ta sowotorow, ani a ta sotigiw bɛɛ halaki, ka ne ta sebagaya yira. ");
INSERT INTO dyu_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ni ne nana Farawona ni a ta sowotorow ni a ta sotigiw bɛɛ halaki, ka ne ta sebagaya yira tuma min na, o tuma Misirankaw bɛna a lɔn ko ne le ye Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Matigi ta mɛlɛkɛ min tun bɛ to ka kɛ Izirayɛlimɔgɔw ɲa fɛ, ale bɔra o ɲa fɛ, ka yɛlɛma o kɔ fɛ. Sankaba jamijan min tun bɛ o ɲa fɛ, o fana bɔra o ɲa fɛ, ka yɛlɛma o kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","A tagara lɔ Misirankaw ni Izirayɛlimɔgɔw cɛ. A kɛra dibi ye Misirankaw ta fan na, ka kɛ yeelen ye Izirayɛlimɔgɔw ta fan na. A kɛra ten, o jɛnkuru fla ma se ka gbara ɲɔgɔn na o su bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ayiwa, Musa k’a boro kɔrɔta kɔgɔji kunna. Matigi Ala ka fɔɲɔba dɔ lawuri ka bɔ terebɔyanfan na. O fɔɲɔ fiyɛra su bɛɛ ra, ka kɔgɔji ɲɔni, fɔ k’a cɛtigɛ fla ye, ka dugukolo jalan kɛ a cɛ ma. ");
INSERT INTO dyu_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Izirayɛlimɔgɔw donna, ka tagama dugukolo jalan kan ka kɔgɔji cɛtigɛ. Ji taranna fla ye, ka wuri ka lɔ o kininboro ni o numanboro fɛ, i ko kogo. ");
INSERT INTO dyu_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Misirankaw fana gbanna Izirayɛlimɔgɔw kɔ. Farawona ta sow, ani a ta sowotorow, ani a ta sotigiw, o bɛɛ donna Izirayɛlimɔgɔw kɔ kɔgɔji cɛ ma. ");
INSERT INTO dyu_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Dugugbɛda fɛ, Matigi Ala tora sankaba jamijan tasumaman ra, ka Misirankaw ta kɛrɛkɛjama flɛ; a ka o ta tagama ɲagami. ");
INSERT INTO dyu_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A ka o ta sowotorow senw don bɔgɔ ra ka o cɛn; o ma se ka taga kosɛbɛ tuun. Misirankaw k’a ye ten minkɛ, o ko: «An ye bori ka bɔ Izirayɛlimɔgɔw kɔrɔ; Matigi Ala yɛrɛ le bɛ an kɛrɛra ka di o ma.» ");
INSERT INTO dyu_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Matigi Ala ko Musa ma ko: «I boro kɔrɔta kɔgɔji kunna sisan, janko ji ye kari ka jigi Misirankaw ni o ta sowotorow ni o ta sotigiw kan.» ");
INSERT INTO dyu_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa k’a boro kɔrɔta kɔgɔji kunna. Dugugbɛda fɛ, kɔgɔji kɔsegira a nɔ ra. Misirankaw ko o bɛ bori ka bɔ, nka Matigi Ala ka ji kari ka jigi o bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Farawona ni a ta kɛrɛkɛdenw, ani a ta sowotorow, ani a ta sotigi minw bɛɛ tun donna kɔgɔji ra Izirayɛlimɔgɔw kɔ, ji karira ka kɛ olugu bɛɛ kan ka o bɛɛ datugu. Hali mɔgɔ kelen ma kisi o ra. ");
INSERT INTO dyu_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Nka Izirayɛlimɔgɔw kɔni tun tagamana le ka tɛmɛ dugukolo jalan kan, ka kɔgɔji cɛtigɛ. Kɔgɔji tun wurira ka lɔ o kininboroyanfan ni o numanboroyanfan fɛ i ko kogo. ");
INSERT INTO dyu_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ayiwa, Matigi Ala ka Izirayɛlimɔgɔw kisi ka o bɔ Misirankaw boro o lon na. Izirayɛlimɔgɔw yɛrɛ ɲa ka Misirankaw suw lalanin ye kɔgɔjida ra yɔrɔ bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Matigi Ala k’a ta sebagaya yira cogo min na, ka Misirankaw halaki, Izirayɛlimɔgɔw ka o ye minkɛ, o siranna Matigi Ala ɲa, ka la a ra; Musa min ye Ala ta baaraden ye, o lara ale fana ra. ");
INSERT INTO dyu_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ayiwa, o lon na Musa ni Izirayɛlimɔgɔw ka nin dɔnkiri la ka Matigi Ala tando. O ko: «Ne bɛna dɔnkiri la Matigi Ala ye k’a bonya, sabu a k’a ta sebagaya yira; a ka sotigiw ni o ta sow bɛɛ jigi kɔgɔji jukɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","«Matigi Ala le ye ne ta baraka ye, ani ne ta dɔnkirila sababu. Ale le ye ne kisibaga ye; ne ta Ala lo, ne bɛ a tando. Ne facɛ ta Ala lo fana, ne bɛ a tɔgɔ bonya. ");
INSERT INTO dyu_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Matigi Ala ye kɛrɛkɛcɛfari le ye. O kosɔn a tɔgɔ ye ko Matigi Ala. ");
INSERT INTO dyu_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","«A ka Farawona ni a ta sowotorow, ni a ta kɛrɛkɛjama bɛɛ tunu kɔgɔji ra. A ta kɛrɛkɛcɛfariw bɛɛ tununa Kɔgɔjiwulen jukɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ji ka o bɛɛ datugu pewu; o jigira Kɔgɔjiwulen jukɔrɔ i ko kabakuru. ");
INSERT INTO dyu_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","E! Matigi Ala, i boro barakaman ka i ta setigiya yira. O boro barakaman kelen le ka i juguw ɲɔɲɔ. ");
INSERT INTO dyu_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","«I ta masaya bonya kosɔn, i bɛ i juguw bɛɛ firi dugu ma ni i dimina, i ta dimi bɛ jigi i ko tasuma, ka o bɛɛ jɛnijɛni i ko binjalan. ");
INSERT INTO dyu_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","I nɛnɛkiriko kelen dɔrɔn, o fɔɲɔ le ka jiw bɛɛ lajɛn ɲɔgɔn kan yɔrɔ kelen na. Kɔgɔji wurira ka lɔ i ko kogo. Ji simina, ka teren ka lɔ kɔgɔji cɛ ma. ");
INSERT INTO dyu_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","«An juguw tun bɛ o yɛrɛ wasora k’a fɔ ko: ‹An bɛna o gbɛn fɔ ka o mina le; an bɛna o borofɛnw bɛɛ cɛ k’a taran an ni ɲɔgɔn cɛ. An bɛna an yɛrɛ dimibɔ o ra fɔ ka wasa, an bɛna an ta kɛrɛkɛmuru bɔ ka o bɛɛ halaki.› ");
INSERT INTO dyu_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nka, Matigi Ala, ele ka i dafɔɲɔ fiyɛ ji kan dama, kɔgɔji ka o bɛɛ datugu. O jigira ji jukɔrɔ i ko nɛgɛkuru; ka jigi fɔ ji jukɔrɔyɔrɔ ra yi. ");
INSERT INTO dyu_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","E! Matigi Ala, batofɛn juman wɛrɛ le bɛ i ko ele? Juman le saninyanin bɛ k’a dafa i ko ele? Juman le ye siranyafɛnba ye, ani a ka kan ni tandori ye, ani a bɛ kabakow kɛ i ko ele? ");
INSERT INTO dyu_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","«I ka i boro barakaman kɔrɔta dɔrɔn, dugukolo dayɛlɛra ka an juguw datugu. ");
INSERT INTO dyu_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","I ta ɲumanya kosɔn, i ka i ta mɔgɔw kunmabɔ. I ta sebagaya baraka ra, i bɛ bla o ɲa ka taga ni o ye jamana saninman na, i yɛrɛ ka jamana min layiri ta o ye. ");
INSERT INTO dyu_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","«Siya tɔw ka o kibaroya mɛn minkɛ, o siranna fɔ o bɛ yɛrɛyɛrɛra. Filisikaw kɔni, olugu ja tigɛra fɔ ka o hakiri ɲagami. ");
INSERT INTO dyu_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edɔmu jamanatigiw jigi tigɛra, Mohabu jamana ta masaw kɔni, siranya ma tɔ to olugu ra. Kanaanakaw, siranya ka olugu baraka bɛɛ ban pewu. ");
INSERT INTO dyu_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Siranyaba ni jatigɛ bɛna cun o kan i ta sebagaya baraka kosɔn, fɔ ka o da mina o ra, ka o kɛ i n’a fɔ kabakuruw; o tɛna se ka kuma, fɔ i ta mɔgɔw bɛɛ ye tɛmɛ, Matigi Ala; fɔ i ka i ta mɔgɔ minw kunmabɔ, olugu bɛɛ ye tɛmɛ ka ban. ");
INSERT INTO dyu_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","I bɛ bla i ta mɔgɔw ɲa, ka taga o sigi i ta kuru kan; i yɛrɛ ka yɔrɔ min lalaga o ye, Matigi Ala. O yɔrɔ bɛna kɛ i sigiyɔrɔ ye, k’a kɛ i sigiyɔrɔ saninman ye. ");
INSERT INTO dyu_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","«Matigi Ala bɛ to a ta masaya ra wagati bɛɛ, ani tuma bɛɛ!» ");
INSERT INTO dyu_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ayiwa, tuma min na Farawona ta sow, ani a ta sowotorow ni a ta sotigiw bɛɛ donna kɔgɔji kɔnɔ, Matigi Ala ka kɔgɔji kari ka jigi o kan ka o bɛɛ tunu; nka Izirayɛlimɔgɔw tagamana ka tɛmɛ dugukolo jalan kan kɔgɔji cɛmancɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ayiwa, Haruna kɔrɔmuso Mariyamu, min tun ye ciramuso ye, ale tun ka longan dɔ ta; muso tɔw fana ka dɔ ta ka gban a kɔ; o ka kɛ o fɔ ye, ka dɔn kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mariyamu tun blara tɔw ɲa; ale bɛ dɔnkiri ta, tɔw bɛ a lamina a kɔ. A tun b’a fɔra ko: «Aw ye dɔnkiri la Matigi Ala ye, sabu a k’a ta sebagaya yira. A ka sotigiw ni o ta sow bɛɛ tunu kɔgɔji ra.» ");
INSERT INTO dyu_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ayiwa, Musa blara Izirayɛlimɔgɔw ɲa ka bɔ Kɔgɔjiwulen yɔrɔ ra, ka taga se ni o ye Suri kongokolon fan fɛ. O ka tere saba tagama kɛ kongokolon kɔnɔ, o ma ji sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","O tagara se yɔrɔ dɔ ra, o yɔrɔ tɔgɔ ye ko Mara. Nka o ma se ka o yɔrɔ ji min, sabu ji tun ka kuna. O le kosɔn o ka o yɔrɔ tɔgɔ la ko «Mara». ");
INSERT INTO dyu_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mɔgɔw ka kɛ Musa mafiyɛnya ye; o ko: «O tuma an bɛna mun le min?» ");
INSERT INTO dyu_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa ka Matigi Ala daari kosɛbɛ. Matigi Ala ka yiri kunkurun dɔ yira a ra, ko a ye o firi ji ra. Musa ka o ta ka o firi ji ra, ji diyara. O yɔrɔ le ra Matigi Ala k’a ta sariyaw ni a ta ciw yira o ra. O yɔrɔ kelen le ra fana a ka o kɔrɔbɔ k’a flɛ. ");
INSERT INTO dyu_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","A k’a fɔ o ye ko: «Ni aw bɛ aw toro malɔ ka Matigi Ala, aw ta Ala kan lamɛn, ko minw terennin lo a ɲa kɔrɔ ni aw bɛ o kɛ, ni aw bɛ aw toro malɔ k’a ta cifɔninw lamɛn, ani k’a ta sariyaw bɛɛ sira tagama, o tuma, ne ka bana minw lase Misirankaw ma, ne tɛna o dɔ si lase aw ma; sabu ne le ye Matigi Ala ye, ne le bɛ aw kɛnɛya.» ");
INSERT INTO dyu_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ayiwa, Izirayɛlimɔgɔw bɔra o yɔrɔ ra, ka taga se Elimu. Bununji tan ni fla ni tamarosun biwolonfla le tun bɛ Elimu. O lɔra o yɔrɔ ra, ka o ta fanibonw lɔ jida ra. ");
INSERT INTO dyu_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Izirayɛlimɔgɔw bɛɛ bɔra Elimu, ka taga se Sinɛ kongokolon kɔnɔ. O yɔrɔ bɛ Elimu ni Sinayi kuru cɛ. O sera yi karo flanan tere tan ni looru ra, o bɔnin kɔ Misiran. ");
INSERT INTO dyu_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ayiwa, ka o to kongokolon kɔnɔ yi, Izirayɛlimɔgɔw bɛɛ ka kɛ Musa ni Haruna mafiyɛnya ye. ");
INSERT INTO dyu_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","O ko Musa ni Haruna ma ko: «E! Hali ni Matigi Ala tun ka a to an ye sa Misiran jamana ra, o belen tun bɛna fisaya ni nin ye. O yɔrɔ ra an tun bɛ sigi dagababaw kɔrɔ, o fanin sogo ra; an bɛ domuni kɛ ka fa. Sisan, a flɛ, aw nana ni an ye nin kongokolon kɔnɔ yan, ka na a to kɔngɔ ye an bɛɛ faga yan gbansan!» ");
INSERT INTO dyu_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Matigi Ala ko Musa ma o le ra ko: «Ne bɛna domuni lajigi aw ye ka bɔ san fɛ, i n’a fɔ sanji. Lon o lon, bɛɛ bɛna taga a ta tere domuni cɛ a ra. Ne bɛna aw kɔrɔbɔ k’a flɛ, k’a lɔn yala ni aw bɛna tagama ka kaɲa ni ne ta sariya ye, walama ni aw tɛna tagama ka kaɲa ni a ye. ");
INSERT INTO dyu_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ayiwa, lɔgɔkun tere wɔɔrɔnan, aw bɛna taga min cɛ ka na a tobi, aw ka kan ka o caya janko a ye lon tɔw ta ɲɔgɔn fla bɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musa ni Haruna k’a fɔ Izirayɛlimɔgɔw bɛɛ ye ko: «Bi wula fɛ, aw bɛna a lɔn ko Matigi Ala le ka aw labɔ Misiran jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Sini sɔgɔma fana, aw bɛna Matigi Ala ta nɔɔrɔ ye, sabu aw ka Matigi Ala mafiyɛnya ni kuma minw ye, a ka o mɛn; ne ni Haruna ye jɔntigiw le ye fɔ aw bɛ anw mafiyɛnya?» ");
INSERT INTO dyu_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa ko: «Matigi Ala bɛna sogo di aw ma bi wula fɛ, aw b’a domu. Sini sɔgɔma fana, a bɛna domuni di aw ma aw b’a domu ka fa; sabu aw ka Matigi Ala mafiyɛnya ni kuma minw ye, a ka o mɛn. Anw ye jɔntigiw le ye ko aw bɛ anw mafiyɛnya? Aw ma anw le mafiyɛnya dɛ, aw ka Matigi Ala yɛrɛ le mafiyɛnya.» ");
INSERT INTO dyu_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa ko Haruna ma ko: «A fɔ Izirayɛlimɔgɔw ye ko o bɛɛ ye gbara ka na lɔ Matigi Ala ɲa kɔrɔ, sabu o ka Matigi Ala mafiyɛnya ni kuma minw ye, a ka o mɛn.» ");
INSERT INTO dyu_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ayiwa, ka Haruna to kuma ra jama fɛ, o barara ka Matigi Ala ta nɔɔrɔ ye sankaba jamijan cɛ ma kongokolon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Matigi Ala ko Musa ma tuun ko: ");
INSERT INTO dyu_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Ne ka Izirayɛlimɔgɔw ta mafiyɛnyakanw mɛn. A fɔ o ye ko ne ko, ko bi wula fɛ o bɛna sogo domu; sini sɔgɔma fana o bɛna domuni caman sɔrɔ. Ni o kɛra, aw bɛna a lɔn ko ne le ye Matigi Ala, o ta Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ayiwa, wulada nana se minkɛ, a kɛra ten fana; wɔlɔnin suguya dɔw nana sigisigi yɔrɔ bɛɛ. O dugusagbɛ sɔgɔmada fɛ fana, gɔmiji ka fanibonw kɔrɔyɔrɔw bɛɛ lamini. ");
INSERT INTO dyu_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ayiwa, gɔmiji nana ban tuma min na, fɛn dɔ tora dugu ma; a tun ka misɛnmisɛn i ko sanbɛrɛ, a bɛ misɛnman, gbɛman. ");
INSERT INTO dyu_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Izirayɛlimɔgɔw k’a flɛ, o m’a lɔn fɛn min lo. O ko: «Mun le ye nin ye tan?» Musa ka o jaabi ko: «Matigi Ala ka domunifɛn min di aw ma, o lo. ");
INSERT INTO dyu_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","«Matigi Ala ka ci min fɔ, o ye nin ye: ‹A ko mɔgɔ bɛɛ ye dɔ cɛ, min bɛ a ta domuta bɔ; mɔgɔ kelen, sumanikɛminan ɲa kelen. Aw ye a cɛ ka kaɲa ni aw ta sokɔnɔmɔgɔw hakɛya ye.› » ");
INSERT INTO dyu_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","A fɔra cogo min na, Izirayɛlimɔgɔw k’a kɛ ten. Dɔw ka caman cɛ, dɔw ka dɔɔnin dɔrɔn cɛ, ka kaɲa ni o ta sokɔnɔmɔgɔw hakɛya ye. ");
INSERT INTO dyu_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nka o nana a suma ni sumanikɛminan ye minkɛ, o k’a ye ko minw ka caman cɛ, olugu ta tɔ ma to, minw ka dɔɔnin cɛ, olugu ta ma dɛsɛ fana. Bɛɛ tun k’a ta tere domuni hakɛya le cɛ. ");
INSERT INTO dyu_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa k’a fɔ o ye tuun ko: «Mɔgɔ si kana a ta domuni tɔ bla a ye si.» ");
INSERT INTO dyu_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Nka o bɛɛ n’a ta, o ma Musa lamɛn. Dɔw ka dɔ bla ka si; tumu donna o ra, a torira. Musa dimina o kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","K’a ta o lon na, sɔgɔma o sɔgɔma, min bɛ bɛn o ta tere domuni ma, bɛɛ bɛ bɔ ka o le cɛ. Ni tere tun ka gban, a tɔ min tora dugu ma o tun bɛ yeele. ");
INSERT INTO dyu_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Lɔgɔkun tere wɔɔrɔnan lon, o ka tere fla ta cɛ. Mɔgɔ bɛɛ kelen kelen ta kɛra sumanikɛminan ɲa fla ye. Jama ɲamɔgɔw tagara o fɔ Musa ye. ");
INSERT INTO dyu_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa ko: «Matigi Ala ka o le fɔ. Sini le ye Nɛnɛkirilon ye; o lon blara danna ka Matigi Ala bonya. Aw b’a fɛ ka fɛn minw jɛni, aw ye o jɛni bi. Aw b’a fɛ ka min barabara, aw ye o barabara bi. Aw ye bi ta domuni bɔ a ra k’a tɔ bla sini ɲa.» ");
INSERT INTO dyu_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","O k’a tɔ bla o dugusagbɛ ɲa, i n’a fɔ Musa tun k’a fɔ o ye cogo min na. O ma tori, tumu fana ma don a ra. ");
INSERT INTO dyu_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa ko o ma o le ra ko: «Aw ka domuni min bla kunu, aw ye o domu bi; sabu bi ye Nɛnɛkirilon le ye. Bi lon blara ka Matigi Ala bonya. Aw tɛna domuni foyi sɔrɔ kongo kɔnɔ bi. ");
INSERT INTO dyu_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Lɔgɔkun tere wɔɔrɔ bɛɛ ra, aw bɛna nin domuni sɔrɔ. Nka lɔgɔkun tere wolonflanan na, min ye Nɛnɛkirilon ye, aw tɛna foyi sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","O bɛɛ n’a ta, lɔgɔkun tere wolonflanan, dɔw belen bɔra ko o bɛ taga dɔ cɛ, o ma foyi sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ayiwa, Matigi Ala ko Musa ma o le ra ko: «Tuma juman le aw bɛna sɔn ka ne ta ci fɔninw, ni ne ta sariyaw mara dɛ? ");
INSERT INTO dyu_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ayiwa, aw ye nin kuma mɛn ka ɲa kosɛbɛ; ne ka Nɛnɛkirilon di aw ma, ko aw ye nɛnɛkiri le. O le kosɔn ne bɛ lɔgɔkun tere wolonflanan domuni di aw ma a tere wɔɔrɔnan lon na. Lɔgɔkun tere wolonflanan na, aw bɛɛ ye to aw ta yɔrɔ ra. Mɔgɔ si kana bɔ a ta yɔrɔ ra.» ");
INSERT INTO dyu_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","O kɛra minkɛ, mɔgɔw ka to ka nɛnɛkiri lɔgɔkun tere wolonflanan na. ");
INSERT INTO dyu_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Izirayɛlimɔgɔw ka o domuni tɔgɔ la ko mane. A tun bɔra simankisɛ dɔ le fɛ, min bɛ gbɛman; a tun ka timi i n’a fɔ lidɛgɛ. ");
INSERT INTO dyu_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa ko: «Matigi Ala ka ci min fɔ, o ye nin ye: ‹A ko aw ye sumanikɛminan kelen fa mane ra, ka o mara aw denw ni aw mamadenw ye; janko o ɲa ye a ye. Ni o kɛra, o bɛna a lɔn ko wagati min na ne ka aw labɔ Misiran jamana ra, ko ne ka o le di aw ma, k’a kɛ aw ta domuni ye kongokolon kɔnɔ.› » ");
INSERT INTO dyu_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa ko Haruna ma ko: «Daga dɔ ta ka sumanikɛminan ɲa kelen mane kɛ o kɔnɔ, ka o bla yɔrɔ saninman kɔnɔ, Matigi Ala ɲa kɔrɔ. O bɛna mara aw denw ni aw mamadenw ye.» ");
INSERT INTO dyu_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Haruna ka mane kɛ daga kɔnɔ. Kɛsu min bɛ Ala ta jɛnɲɔgɔnya yira, a k’a bla o kɛsu ɲa fɛ, k’a mara, i n’a fɔ Matigi Ala k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Izirayɛlimɔgɔw ka mane domu fɔ san binaani, fɔ ka taga o se jamana dɔ ma, mɔgɔ bɛ jamana min na. O ka mane domu fɔ ka taga o don Kanaana jamana kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Mane ta sumanikɛminan min ye omɛri ye, o ɲa tan le tun bɛ don sumanikɛminanba kɔnɔ, min ye efa ye. ");
INSERT INTO dyu_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Izirayɛlimɔgɔw bɛɛ bɔra Sinɛ kongokolon kɔnɔ ka taga Refidimu. O tagatɔ, o lɔlɔra yɔrɔ dɔw ra ka kaɲa ni Matigi Ala ta kuma ye. O sera Refidimu minkɛ, o ka o ta fanibonw lɔ yi, nka o ma ji sɔrɔ k’a min. ");
INSERT INTO dyu_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","O wurira Musa kama, ka to ka kumajuguw fɔ a ma. O ko: «Ji di an ma, an b’a min.» Musa ka o jaabi ko: «Mun kosɔn aw bɛ kɛrɛ ɲinina ne fɛ? Mun kosɔn aw b’a fɛ ka Matigi Ala kɔrɔbɔ?» ");
INSERT INTO dyu_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Jiminlɔgɔ gbanna mɔgɔw ra, o ka kɛ Musa jaraki ye; o ko: «Mun kosɔn i ka an labɔ Misiran dɛ? O tuma i tun b’a fɛ anw ni an ta denw, ani an ta bɛganw ye na sa kongokolon kɔnɔ yan jiminlɔgɔ boro le kɛ?» ");
INSERT INTO dyu_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa ka Matigi Ala daari kosɛbɛ. A ko: «Matigi, ne bɛna mun le kɛ ni nin mɔgɔw ye sa? Ni a tɛmɛna nin kan, o bɛna ne bon ni kabakuru ye.» ");
INSERT INTO dyu_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Matigi Ala k’a fɔ Musa ye ko: «Bla mɔgɔw ɲa fɛ, i ye Izirayɛli cɛkɔrɔba dɔw ɲanawoloma, ka gban i yɛrɛ kɔ. I ka baji gbasi ni bere min ye, i ye o mina i boro ka taga. ");
INSERT INTO dyu_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ne bɛna lɔ i ɲa fɛ Horɛbu kuru farakuru dɔ kan. I bɛna o farakuru le gbasi ni bere ye, ka ji bɔ a ra, janko mɔgɔw ye min.» Matigi Ala ka min fɔ, Musa k’a kɛ ten Izirayɛli cɛkɔrɔbaw ɲa na. ");
INSERT INTO dyu_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","O ka o yɔrɔ tɔgɔ la ko Masa ni Meriba, o kɔrɔ ye ko kɛrɛ ni kɔrɔbɔri, ko sabu Izirayɛlimɔgɔw ka kɛrɛ ɲini Musa fɛ, ani ko o tun b’a fɛ ka Matigi Ala kɔrɔbɔ k’a flɛ; o ko: «Yala Matigi Ala bɛ ni an ye wa, walama a tɛ ni an ye le?» ");
INSERT INTO dyu_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ayiwa, Amalɛki ta mɔgɔw nana ben Izirayɛlimɔgɔw kan Refidimu ko o bɛ o kɛrɛ. ");
INSERT INTO dyu_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa ko Yosuwe ma ko: «Cɛ dɔw ta Izirayɛlimɔgɔw cɛ ra, aw ye bɔ ka taga Amalɛki ta mɔgɔw kɛrɛ. Sini ne bɛna taga lɔ tintin kan, ni Ala ta bere ye ne boro.» ");
INSERT INTO dyu_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ayiwa, Musa ka min fɔ, Yosuwe ka o kɛ. A ni Izirayɛli cɛw tagara Amalɛki ta mɔgɔw kɛrɛ. O y’a sɔrɔ Musa ni Haruna ni Huri yɛlɛnna ka taga lɔ tintin kan. ");
INSERT INTO dyu_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ni Musa tun k’a boro kɔrɔta tuma o tuma, Izirayɛlimɔgɔw tun bɛ se sɔrɔ. Nka ni a tun k’a boro jigi dɔrɔn, Amalɛki ta mɔgɔw le tun bɛ se sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Musa boro fla bɛɛ nana sɛgɛ. Haruna ni Huri ka kabakuru dɔ ta ka o bla a kɔrɔ, a ka sigi a kan. O k’a borow mina ka o kɔrɔta; kelen lɔra a numanboro fɛ, kelen lɔra a kininboro fɛ. Musa borow kɔrɔtanin tora ten fɔ ka taga tere ban. ");
INSERT INTO dyu_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","A kɛra ten, Yosuwe ni a ta mɔgɔw ka se sɔrɔ Amalɛki ni a ta mɔgɔw bɛɛ kan, ka o kɛrɛ ni kɛrɛkɛmuru ye. ");
INSERT INTO dyu_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Matigi Ala k’a fɔ Musa ye ko: «Nin ko sɛbɛ kitabu kɔnɔ janko aw hakiri ye to a ra. A fɔ Yosuwe ye ko ne bɛna Amalɛki si tunu pewu ka bɔ dugukolo kan; mɔgɔ si hakiri tɛna to o ra tuun.» ");
INSERT INTO dyu_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa ka sarakabɔnan dɔ lɔ o yɔrɔ ra, ka o tɔgɔ la ko Yawe Nisi, o kɔrɔ ye ko Matigi Ala ye ne ta darapo ye. ");
INSERT INTO dyu_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Musa ko fana ko: «I n’a fɔ Amalɛki ta mɔgɔw sɔnna ka o boro kɔrɔta ko o bɛ Matigi Ala ta masaya kɛrɛ, o ra, kɛrɛ bɛna kɛ Matigi Ala ni Amalɛki ta siya cɛ wagati bɛɛ, ani tuma bɛɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ayiwa, Matigi Ala ka ko o ko kɛ Musa ni Izirayɛlimɔgɔw ye, o bɛɛ kibaroya sera Musa burancɛ Zetoro ma, min ye Madiyan sarakalasebaga ye. Matigi Ala tun k’a ta mɔgɔw, Izirayɛlimɔgɔw labɔ Misiran cogo min na fana, Zetoro tun ka o ko mɛn. ");
INSERT INTO dyu_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Musa burancɛ k’a denmuso Sefora ta, min ye Musa ta muso ye, ka taga ni a ye Musa fɛ, sabu Musa tun k’a muso bla ka taga wagati dɔ kɛ a facɛ fɛ yi. ");
INSERT INTO dyu_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Zetoro tagatɔ, a ka Sefora dencɛ fla fana ta ka taga ni o ye. Musa tun ka a dencɛ kelen tɔgɔ la ko Gɛrisɔmu, ko sabu ale ye lonan le ye jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","A tun ka tɔ kelen tɔgɔ la ko Eliyezɛri, ko sabu ale facɛ ta Ala ka ale dɛmɛ, ka ale bɔsi Farawona ta muru ma. ");
INSERT INTO dyu_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Musa burancɛ Zetoro, ni Musa ta muso, ni a dencɛw nana Musa sɔrɔ kongokolon kɔnɔ, Matigi Ala ta kuru kɛrɛ fɛ. Musa tun k’a ta fanibon lɔ o yɔrɔ le ra yi. ");
INSERT INTO dyu_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Zetoro sera yi minkɛ, a ka cira bla Musa ma; o tagara a fɔ Musa ye ko: «I burancɛ Zetoro nana, ani i muso, ni i dencɛ fla.» ");
INSERT INTO dyu_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa bɔra ka na a burancɛ kunbɛn. A birira a kɔrɔ k’a fo ni bonya ye, k’a boro melege a kan na k’a fo ni kanuya ye. O ka ɲɔgɔn fɛko ɲininka. O kɔ, o donna ɲɔgɔn fɛ Musa ta fanibon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Matigi Ala ka ko minw kɛ Farawona ni Misirankaw ra, Izirayɛlimɔgɔw kosɔn, Musa ka o bɛɛ lakari a burancɛ ye. Tɔɔrɔ minw sera Izirayɛlimɔgɔw ma ka o to sira ra, ani Matigi Ala ka o kisi o tɔɔrɔw ma cogo min na, Musa ka o bɛɛ fɔ a ye fana. ");
INSERT INTO dyu_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ayiwa, Matigi ka o koɲumanba min kɛ Izirayɛlimɔgɔw ye, ka o bɔsi ka bɔ Misirankaw boro, o kibaroya ka Zetoro jusu diya kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Zetoro ko o le ra ko: «Matigi Ala baraka, sabu ale le ka aw bɔsi Misirankaw ni Farawona boro; a k’a ta mɔgɔw bɔsi ka o bɔ Misirankaw ta jɔnya ra. ");
INSERT INTO dyu_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ne k’a lɔn sisan ko Matigi Ala le ka bon ka tɛmɛ batofɛn tɔw bɛɛ kan; sabu a ka Izirayɛlimɔgɔw kisi ka bɔ Misirankaw ta juguya kɔrɔ, ka o ta juguya ben o yɛrɛ kan.» ");
INSERT INTO dyu_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Musa burancɛ Zetoro ka bɛgan dɔ faga, k’a kuturu jɛni, ka o di Ala ma saraka ye. O kɔ, a ka bɛgan dɔw kɛ saraka ye tuun; Haruna ni Izirayɛli cɛkɔrɔbaw bɛɛ nana fara Zetoro kan, ka o saraka domu Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ayiwa, o dugusagbɛ, Musa wurira ka sigi, ka mɔgɔw ta koɲaw ɲanabɔ. Jama lɔra Musa kunna, k’a ta sɔgɔma, fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Musa tun bɛ min bɛɛ kɛra mɔgɔw ye, Zetoro ka o ye minkɛ, a ko Musa ma ko: «Mun na i bɛ nin jama ta kow ɲanabɔra nin cogo ra? Mun kosɔn ele kelenpe le siginin bɛ, nin jamaba lɔnin bɛ i ɲa fɛ, k’a ta sɔgɔma fɔ ka na wula se?» ");
INSERT INTO dyu_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa k’a burancɛ jaabi ko: «Mɔgɔw yɛrɛ le bɛ na ne fɛ ko ne ye o ta kiti tigɛ, ka Ala ta sariya yira o ra. ");
INSERT INTO dyu_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ni ko dɔ ka don o ni ɲɔgɔn cɛ, o bɛ na ne fɛ, ne bɛ o ɲanabɔ. Ne bɛ Ala ta ciw ni Ala ta sariyaw yira o ra.» ");
INSERT INTO dyu_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Musa burancɛ Zetoro k’a fɔ Musa ye ko: «I ta baarakɛcogo man ɲi. ");
INSERT INTO dyu_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","I bɛna i yɛrɛ baraka ban, ka mɔgɔw fana baraka ban. Nin baara ka bon i kelen baraka ma; i kelen tɛ se k’a ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ayiwa, sisan ne bɛna min fɔ i ye ka i ladi, o lamɛn; Ala fana ye i dɛmɛ k’a kɛ. Ele ka kan ka kɛ daramina le ye mɔgɔw ni Ala cɛ, ka o ta kogbɛlɛnw lase Ala ma. ");
INSERT INTO dyu_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","I ka kan ka mɔgɔw karan Ala ta cifɔninw ni Ala ta sariyaw ra. Mɔgɔw ka kan ka tagama cogo min na, ani o ka kan ka min kɛ, i ye o bɛɛ yira o ra. ");
INSERT INTO dyu_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","O kɔ, i ye mɔgɔ dɔw ɲanawoloma, minw hakiri ka bon; o ye kɛ Alaɲasiranbagaw ye, ani lanamɔgɔw, ani mɔgɔ minw tɛ sɔn janfa ma. I ye o mɔgɔw le sigisigi jama kunna; i ye dɔw sigi mɔgɔ waga kelen kelen kunna, ka dɔw sigi mɔgɔ kɛmɛ kɛmɛ kunna, ka dɔw sigi mɔgɔ bilooru looru kunna, ka dɔw sigi mɔgɔ tan tan kunna. ");
INSERT INTO dyu_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Olugu le bɛna kɛrɛkow ɲanabɔ lon o lon mɔgɔw ni ɲɔgɔn cɛ. Ni ko min bonyara olugu bɛɛ ma, o ye taga ni o ye ele fɛ. Nka ko fitiniw, olugu yɛrɛ ye o ɲanabɔ yi. Ni a kɛra ten, i bɛna i yɛrɛ laganfiya dɔɔnin, olugu bɛna dɔ bɔ i ta doni na. ");
INSERT INTO dyu_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ni i k’a kɛ ten, ni a fana kɛra ko Ala ka o le fɔ, ele tɛna sɛgɛ, mɔgɔw bɛɛ jusu sumanin bɛna taga o ta so fana.» ");
INSERT INTO dyu_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa burancɛ Zetoro ka kuma minw bɛɛ fɔ Musa ye, Musa sɔnna ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","A ka mɔgɔ hakiriman dɔw bɔ Izirayɛlimɔgɔw ra, ka olugu kɛ o kuntigiw ye. A ka dɔw sigi mɔgɔ waga kelen kelen kunna, ka dɔw sigi mɔgɔ kɛmɛ kɛmɛ kunna, ka dɔw sigi mɔgɔ bilooru looru kunna, ka dɔw sigi mɔgɔ tan tan kunna. ");
INSERT INTO dyu_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Olugu le tun bɛ mɔgɔw ta kɛrɛkow ɲanabɔ tuma bɛɛ. Ni ko min bonyara o ma, o bɛ taga ni o ye Musa fɛ. Nka ko fitini tɔw, olugu yɛrɛ le tun bɛ o bɛɛ ɲanabɔ o yɛrɛ ma. ");
INSERT INTO dyu_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ayiwa, o kɔ, Musa ka sira di a burancɛ Zetoro ma. Zetoro kɔsegira ka taga a ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Izirayɛlimɔgɔw bɔnin kɔ Misiran jamana ra, a karo sabanan tere fɔlɔ, o sera Sinayi kongokolon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","O bɔra Refidimu le ka se Sinayi kongokolon kɔnɔ. O ka o ta fanibonw lɔ o yɔrɔ ra ka o ɲasin kuru ma. ");
INSERT INTO dyu_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa yɛlɛnna kuru kunna ka taga kuma ni Ala ye. Matigi Ala ka Musa wele kuru kunna k’a fɔ a ye ko: «Nin kuma fɔ Yakuba ta mɔgɔw ye, Izirayɛlimɔgɔw, ko: ");
INSERT INTO dyu_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹Ne ka ko minw kɛ Misirankaw ra, aw ka o ye, ani ne ka aw ta i n’a fɔ bɔn bɛ a denw ta cogo mina a kaman kan, ka na ni aw ye ne yɛrɛ kɔrɔ, aw ka o ye fana. ");
INSERT INTO dyu_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","« ‹Ayiwa, sisan, ni aw ka ne kumakan lamɛn, ka to ne ta jɛnɲɔgɔnya ra, aw le bɛna kɛ ne ta mɔgɔ kanuninw ye ka tɛmɛ siya tɔw bɛɛ kan, sabu dugukolo bɛɛ lajɛnnin ye ne ta le ye. ");
INSERT INTO dyu_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ne bɛna aw kɛ ne ta sarakalasebagaw ye, ka aw sigi ne ta masaya ra, ka aw kɛ siya saninman ye, ka aw bla danna ne ye.› I bɛna o kuma le lase Izirayɛlimɔgɔw ma.» ");
INSERT INTO dyu_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musa jigira ka na Izirayɛli cɛkɔrɔbaw bɛɛ lajɛn. Matigi Ala ka kuma minw fɔ a ye, a ka o bɛɛ lase o ma. ");
INSERT INTO dyu_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Jama bɛɛ lajɛnnin ka Musa jaabi ko: «Matigi Ala ka min o min fɔ, anw bɛna o bɛɛ kɛ.» Jama ka min fɔ, Musa tagara o lase Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Matigi Ala ko Musa ma ko: «Ne bɛna kɛ sankaba finman dɔ ra ka na i fɛ, janko ni ne nana kɛ kuma ye i fɛ tuma min na, mɔgɔw ye ne kumakan mɛn, ka la i ra tuma bɛɛ.» Jama tun ka min fɔ Musa ye, Musa kɔsegira ka taga o lase Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Matigi Ala ko Musa ma tuun ko: «Taga mɔgɔw fɛ, i ye o saninya bi, ani sini, k’a fɔ o ye ko o ye o ta faniw fana ko; ");
INSERT INTO dyu_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ko o ye o yɛrɛ labɛn sani sinikɛnɛ cɛ; sabu sinikɛnɛ ne bɛna jigi Sinayi kuru kan mɔgɔw bɛɛ ɲa na. ");
INSERT INTO dyu_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","I ye dan dɔ yira o ra kuru lamini bɛɛ ra, k’a fɔ o ye k’a gbɛlɛya ko o ye o yɛrɛ kɔrɔsi, o kana tɛmɛ o dan kan, ka yɛlɛn kuru kan, walama ka gbara a ra. Ni fɛn o fɛn gbarara kuru ra, o ka kan ka faga le; ");
INSERT INTO dyu_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","nka mɔgɔ man kan k’a boro maga o tigi ra. Aw ye a bon ni kabakuru le ye, walama biɲɛ, k’a faga. Ni a kɛra mɔgɔ ye o, walama bɛgan o, a ɲanaman man kan ka to. Ni buru nana fiyɛ tuma min na, o tuma le ra dɔw bɛna se ka gbara kuru ra.» ");
INSERT INTO dyu_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa jigira ka bɔ kuru kan ka na mɔgɔw fɛ. A k’a fɔ o ye ko o ye o yɛrɛ saninya, ka o ta faniw ko. ");
INSERT INTO dyu_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","O kɔ, a k’a fɔ mɔgɔw ye tuun ko: «Aw ye aw yɛrɛ labɛn; sani sinikɛnɛ cɛ; aw kana gbara aw musow ra.» ");
INSERT INTO dyu_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ayiwa, lon min fɔra, o lon sɔgɔmada joona fɛ, sankurukan ni sanmanamana ni sankabafinba dɔ kɛra kuru san fɛ. Burufiyɛkan belebele dɔ bɔra, fɔ mɔgɔw bɛ yɛrɛyɛrɛ o ta fanibonw kɔnɔ, o sirankojugu fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ayiwa, a kɛra ten, Musa ka mɔgɔw bɛɛ labɔ kɛnɛ ma, ka taga ni o ye Ala ɲa kɔrɔ. Mɔgɔw lɔra kuru kɛrɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sinayi kuru fan bɛɛ tun kɛra sisi ye, sabu Matigi Ala tun jigira kuru kunna tasuma ra. A sisi tun bɛ wurira i ko dibiba dɔ sisi. Kuru bɛɛ tun bɛ yɛrɛyɛrɛra ni fanga ye. ");
INSERT INTO dyu_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Burufiyɛkan tun bɛ bonyara ka taga a fɛ. Ni Musa tun kumana, Matigi Ala tun bɛ a jaabi ni pɛrɛnkanba le ye i ko sanpɛrɛnkan. ");
INSERT INTO dyu_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Matigi Ala jigira o cogo le ra kuru kan. A tora kuru kunna ka Musa wele. Musa yɛlɛnna ka taga a fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Matigi Ala k’a fɔ a ye ko: «Jigi, i ye taga a fɔ mɔgɔw ye k’a gbɛlɛya o ma, ko o kana girin ka gbara kuru ra ko o bɛ ne flɛ dɛ! Ni o tɛ, o caman le bɛna faga. ");
INSERT INTO dyu_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hali sarakalasebaga minw bɛ deri ka gbara ne ra, olugu ka kan ka o yɛrɛ saninya fana, janko ne kana na kojugu dɔ kɛ o ra ka o faga.» ");
INSERT INTO dyu_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa k’a fɔ Matigi Ala ye ko: «Mɔgɔ tɛna sɔn ka yɛlɛn Sinayi kuru kan, sabu ele yɛrɛ ka kankari la an ye k’a gbɛlɛya an ma ko an ye dan bla kuru lamini na, mɔgɔ kana tɛmɛ o dan kan.» ");
INSERT INTO dyu_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Matigi Ala ko Musa ma ko: «Jigi, i ye taga; o kɔ, i ni Haruna ye yɛlɛn ka na ɲɔgɔn fɛ yan. Nka sarakalasebagaw ni mɔgɔ tɔw kana girin ko o bɛ yɛlɛn ka na ne fɛ! Ni o tɛ, ne bɛna kojugu kɛ o ra ka o faga.» ");
INSERT INTO dyu_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Musa jigira ka taga mɔgɔw fɛ, ka taga o kuma fɔ o ye. ");
INSERT INTO dyu_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ayiwa, Ala ka nin kumaw le fɔ Izirayɛlimɔgɔw ye; a ko: ");
INSERT INTO dyu_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Ne le ye Matigi Ala, i ta Ala ye, min ka i labɔ Misiran jamana ra, jɔnyaso ra. ");
INSERT INTO dyu_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«I kana batofɛn wɛrɛ si bato ne kɔ. ");
INSERT INTO dyu_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«I kana ja si lɛsɛ i yɛrɛ ye k’a bato. Fɛn minw bɛ sankolo ra o, minw bɛ dugukolo kan o, minw bɛ dugukolo jukɔrɔ ji ra o, i kana o dɔ si bisigiya lalaga k’a bato. ");
INSERT INTO dyu_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","I kana i kinbiri gban o fɛnw si kɔrɔ, ka o bato. Sabu ne min ye Matigi Ala, i ta Ala ye, ne t’a fɛ i ye ne ni batofɛn wɛrɛ kanu ɲɔgɔn fɛ fiyewu. Mɔgɔ minw bɛ o terenbariyakow kɛ, ne bɛna o hakɛ bɔ o tigiw ra, k’a bɔ o ta denw na, k’a bɔ o ta denw ta denw na fana, fɔ ka taga se o ta duruja sabanan, ni a naaninan ma, sabu o bɛ ne kɔninya. ");
INSERT INTO dyu_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Nka mɔgɔ minw bɛ ne kanu, ka ne ta sariyaw sira tagama, ne bɛ koɲuman kɛ olugu ye, k’a kɛ o ta denw ye, ani o ta denw ta denw, fɔ ka taga se o ta duruja waga kelennan ma. ");
INSERT INTO dyu_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«I kana Matigi Ala, i ta Ala tɔgɔ fɔ gbansan, sabu mɔgɔ o mɔgɔ bɛ Matigi Ala tɔgɔ fɔ gbansan, Matigi Ala tɛna o tigi jarakibari to. ");
INSERT INTO dyu_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«I ye i hakiri to Nɛnɛkirilon na k’a kɛ lon saninman ye. ");
INSERT INTO dyu_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","I ye baara kɛ tere wɔɔrɔ, ka i ta kow bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Nka lɔgɔkun tere wolonflanan ye Matigi Ala, i ta Ala ta Nɛnɛkirilon le ye. I kana baara si kɛ o lon na; i yɛrɛ o, i dencɛ o, i denmuso o, i ta jɔncɛ o, i ta jɔnmuso o, i ta bɛganw o, hali lonan min bɛ i fɛ so kɔnɔ, o si kana baara kɛ o lon na. ");
INSERT INTO dyu_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Sabu Matigi Ala ka sankolo ni dugukolo ni kɔgɔji ni a kɔnɔfɛnw bɛɛ dan tere wɔɔrɔ le kɔnɔ, ka nɛnɛkiri a tere wolonflanan. O le kosɔn Matigi Ala ka baraka don tere wolonflanan na, k’a saninya k’a bla danna. ");
INSERT INTO dyu_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«I fa ni i ba bonya, janko Matigi Ala, i ta Ala bɛna jamana min di i ma, i ye sijan sɔrɔ o jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«I kana mɔgɔ faga. ");
INSERT INTO dyu_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«I kana jɛnɛya kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«I kana sonyari kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«I kana faninya fɔ k’a la i mɔgɔɲɔgɔn na. ");
INSERT INTO dyu_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«I kana ɲabɔ i mɔgɔɲɔgɔn ta bon fɛ; i kana ɲabɔ i mɔgɔɲɔgɔn ta muso fɛ, walama a ta jɔncɛ, walama a ta jɔnmuso, walama a ta misi, walama a ta fali; i kana ɲabɔ i mɔgɔɲɔgɔn ta fɛn si fɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Mɔgɔw bɛɛ tun bɛ sankurukan ni burufiyɛkan mɛnna. O tun bɛ sanmanamana ni sisi wuritɔ yera kuru kan. Mɔgɔw ka o ye minkɛ, o ka kɛ yɛrɛyɛrɛ ye siranya boro. O mabɔra kuru ra ka taga lɔ fɔ yɔrɔjan. ");
INSERT INTO dyu_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","O ko Musa ma ko: «Ele yɛrɛ ye kuma an fɛ, an bɛna i lamɛn. Matigi Ala kana kuma an fɛ tuun, ni o tɛ, an bɛna sa.» ");
INSERT INTO dyu_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa k’a fɔ mɔgɔw ye ko: «Aw kana siran, sabu Ala nana ka na aw kɔrɔbɔ k’a flɛ le. A ka o kɛ janko aw ye siran a ɲa, aw kana jurumun kɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ayiwa, mɔgɔw lɔnin tora yɔrɔjan. Ala tun bɛ sankaba finman min na, Musa gbarara o sankaba ra. ");
INSERT INTO dyu_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Matigi Ala k’a fɔ Musa ye ko: «A fɔ Izirayɛlimɔgɔw ye ko ne ko: ‹Aw k’a ye ko ne tora fɔ sankolo ra ka kuma aw fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","O ra, aw kana batofɛn warigbɛraman, walama a saninlaman si lalaga aw yɛrɛ ye. Aw kana batofɛn wɛrɛ fara ne kan. Aw kana o kɛ fiyewu. ");
INSERT INTO dyu_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","« ‹Aw ye sarakabɔnan bɔgɔraman dɔ lɔ ne ye. Aw bɛna aw ta saraka jɛnitaw* ni aw ta jɛnɲɔgɔnya sarakaw* bɔ o kan, ni a kɛra sagaw ye walama baw walama misiw. Ni ne ka ne yɛrɛ yira yɔrɔ o yɔrɔ, ne bɛna na aw fɛ ka na baraka don aw ra o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","« ‹Ni aw bɛ sarakabɔnan lɔ ne ye, ni aw bɛ a lɔ ni kabakuru le ye, aw kana a lɔ ni kabakuru lɛsɛninw ye. Sabu ni aw bɛ kabakuru lɛsɛ ni aw ta kabakuru lɛsɛnanw ye, aw bɛna o kabakuruw lanɔgɔ le. ");
INSERT INTO dyu_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","« ‹Aw kana sarakabɔnan lɔ ne ye, ka yɛlɛnyɔrɔ kɛ a ra ka taga a san fɛ, ni o tɛ, aw yɛlɛntɔ ka taga saraka bɔ, mɔgɔw bɛ se ka to dugu ma ka aw ta fani jukɔrɔyɔrɔ ye.› » ");
INSERT INTO dyu_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Matigi Ala k’a fɔ Musa ye tuun ko: «Nin sariyaw fɔ Izirayɛlimɔgɔw ye ko: ");
INSERT INTO dyu_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‹Ni aw ka jɔn san, ni Heburu lo, a ka kan ka baara kɛ aw ye san wɔɔrɔ; nka a san wolonflanan, aw ka kan k’a bla a ye taga, a fana man kan ka foyi sara. ");
INSERT INTO dyu_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ni a kelen le tun nana aw fɛ, a kelen le ka kan ka taga fana. Ni muso tun bɛ a fɛ kakɔrɔ, a ni a muso bɛ taga. ");
INSERT INTO dyu_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ni a matigicɛ le tun ka muso di a ma, ni o muso ka dencɛw walama denmusow sɔrɔ a fɛ, muso ni denw bɛ kɛ a matigicɛ ta ye, ale kelen bɛ taga. ");
INSERT INTO dyu_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Nka ni jɔncɛ yɛrɛ le ko, ko a matigicɛ ni a muso ni a denw ko ka di a ye, ko o kosɔn a t’a fɛ ka taga, ");
INSERT INTO dyu_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","o tuma a matigicɛ ye Ala kɛ a yɛrɛ seere ye, ka gbara ni jɔncɛ ye, k’a dɛn bonda yiri kan, walama da kɛrɛfɛyiri kan, k’a toro sɔgɔ ni biɲɛ ye. Ni o kɛra, o jɔncɛ bɛ to a matigi ta baara ra fɔ ka taga a sa. ");
INSERT INTO dyu_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","« ‹Ayiwa, ni dɔ k’a denmuso fiyeere jɔnya ra, o denmuso lablacogo ni jɔn tɔw ta tɛna kɛ kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ni a matigicɛ tun k’a san, ko a bɛna a furu le, kɔ fɛ, a ko ma na diya a ye tuun, o tuma, a y’a to den fa ye a ta wari sekɔ a ma, ka den kunmabɔ. Matigicɛ man kan k’a fiyeere tuun siya wɛrɛ mɔgɔ ma. Ni a k’a fiyeere, a kɛra i n’a fɔ a k’a janfa le. ");
INSERT INTO dyu_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","« ‹Ni matigicɛ tun ka o jɔnsunguru san ko a bɛna a di a dencɛ le ma, landa min sigira sungurudenw ta furu ko ra, a ye a kɛ ka kaɲa ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kɔ fɛ, ni a nana muso wɛrɛ furu tuun, a tun bɛ min kɛra muso fɔlɔ ye, dɔ man kan ka bɔ o ra; a ye a fiyɛrɛbɔ, k’a baro, ka sɔn ka jɛn ni a ye. ");
INSERT INTO dyu_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","« ‹Ni a ma o ko saba kɛ a ye, o tuma jɔnmuso bɛ se ka bɔ ka taga, a tɛ foyi sara.› » ");
INSERT INTO dyu_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","« ‹Ni mɔgɔ min k’a lawuri a kama ka mɔgɔ bugɔ k’a faga, o tigi fana ka kan ka faga a ɲɔgɔn ye. ");
INSERT INTO dyu_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Nka ni a tigi m’a lawuri a kama ka taga dogo a ɲa ka a faga, ni a kɛra Ala yɛrɛ ta latigɛ le ye, o tuma ne bɛna yɔrɔ dɔ yira aw ra, o mɔgɔfagabaga bɛ se ka bori ka taga dogo yɔrɔ min na. ");
INSERT INTO dyu_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Nka ni mɔgɔ dɔ k’a lawuri a kama k’a mɔgɔɲɔgɔn nɛgɛ ka a faga, aw ye o tigi mina k’a faga fana, hali ni a borira ka taga dogo ne ta sarakajɛnifɛn le kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ni mɔgɔ min k’a facɛ, walama a bamuso bugɔ, o ka kan ka mina ka faga. ");
INSERT INTO dyu_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ni mɔgɔ min ka mɔgɔ dɔ sonya ka taga a fiyeere, walama ni a sonyanin yera a boro, o son ka kan ka faga. ");
INSERT INTO dyu_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","« ‹Ni mɔgɔ min ka kumajugu fɔ a facɛ ma, walama a bamuso ma, o tigi ka kan ka faga.› » ");
INSERT INTO dyu_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","« ‹Ni mɔgɔ fla kɛrɛra, ni dɔ ka dɔ bugɔ ni kabakuru ye, walama ni a borokuru ye, k’a mandimi, ni a ma sa, nka a banara ka la, ");
INSERT INTO dyu_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ni a nana se ka wuri ka bɔ kɛnɛ ma, ka yaalayaala ni bere ye, o tuma foyi tɛna kɛ a bugɔbaga ra. Nka a ka wagati min kɛ bana ra, a ka kan ka o sara a ye, k’a flakɛ fɔ ka taga a kɛnɛya. ");
INSERT INTO dyu_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","« ‹Ni matigicɛ min k’a ta jɔncɛ, walama a ta jɔnmuso bugɔ ni bere ye fɔ k’a faga, o hakɛ ka kan ka bɔ o matigicɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Nka ni o jɔn tora nin na ka tere kelen walama tere fla kɛ, foyi man kan ka kɛ a matigicɛ ra, sabu a ta wari lo. ");
INSERT INTO dyu_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","« ‹Ni cɛ dɔw kɛrɛkɛtɔ ka muso lasiritɔ dɔ ɲɔni k’a ben, ni muso kɔnɔ ka cɛn, k’a sɔrɔ foyi wɛrɛ ma kɛ a yɛrɛ ra, muso cɛ bɛna warida dɔ ben o cɛ kan, a bɛna o sara muso cɛ ye kititigɛbagaw ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Nka ni ko wɛrɛ le ka kɛ muso ra, o tuma o juru bɛ sara cɛ ra ka kaɲa ni sariya ye: ni min ka mɔgɔ faga, o tigi ka kan ka faga a ɲɔgɔn ye, ");
INSERT INTO dyu_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ni min ka mɔgɔ ɲa ci, o ta bɛ ci a ɲɔgɔn ye; ni min ka mɔgɔ ɲin bɔn, o ta bɛ bɔn a ɲɔgɔn ye; ni min ka mɔgɔ boro kari, o ta bɛ kari a ɲɔgɔn ye; ni min ka mɔgɔ sen kari, o ta bɛ kari a ɲɔgɔn ye; ");
INSERT INTO dyu_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ni min ka mɔgɔ jɛni, o fana bɛ jɛni a ɲɔgɔn ye; ni min ka mɔgɔ mandimi, o fana bɛ mandimi a ɲɔgɔn ye; ni min ka mɔgɔ bugɔ k’a yɔrɔ dɔ funu, o tigi fana ka kan ka bugɔ k’a yɔrɔ dɔ funu. ");
INSERT INTO dyu_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","« ‹Ni mɔgɔ min k’a ta jɔncɛ walama a ta jɔnmuso bugɔ fɔ k’a ɲa kelen ci, o tigi ka kan k’a labla a ɲa kosɔn. ");
INSERT INTO dyu_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ni a k’a bugɔ fɔ k’a ɲin kelen le kari, a ka kan k’a labla fana a ɲin kosɔn.› » ");
INSERT INTO dyu_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","« ‹Ayiwa, ni misi dɔ ka mɔgɔ tu, cɛ walama muso, k’a faga, o ka kan ka o misi bon ni kabakuru ye k’a faga. A sogo man kan ka domu. Nka foyi man kan ka kɛ misitigi yɛrɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Nka ni misi tun bɛ deri ka mɔgɔw tu kakɔrɔ, ni o ko fɔra a tigi ye, ni a ma sɔn k’a janto a ra, ayiwa, ni o misi ka mɔgɔ faga, cɛ walama muso, misi ka kan ka bon ni kabakuru ye k’a faga, k’a tigi fana faga k’a fara a kan. ");
INSERT INTO dyu_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Nka ni misi ka min faga, ni o ta mɔgɔw sɔnna ko misitigi ye warida dɔ sara k’a nin kunmabɔ, o tuma a bɛna o warida sara k’a nin kunmabɔ. ");
INSERT INTO dyu_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","« ‹Ayiwa, ni o misi ka den dɔ le tu k’a faga, cɛden, walama musoden, o sariya kelen le bɛna o ko ɲanabɔ. ");
INSERT INTO dyu_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Nka ni misi ka jɔn le tu k’a faga, cɛ walama muso, misitigi ka kan ka warigbɛ garamu kɛmɛ saba di o jɔn matigicɛ ma; o bɛ misi bon ni kabakuru ye k’a faga. ");
INSERT INTO dyu_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","« ‹Ni mɔgɔ dɔ ka dinga dɔ dayɛlɛ, walama k’a sogi, k’a to yi, a m’a datugu, ni misi dɔ, walama fali dɔ benna a kɔnɔ ka faga, ");
INSERT INTO dyu_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","o dinga sogibaga ka kan ka o bɛgan sara, k’a wari di bɛgantigi ma; nka misi su bɛ kɛ ale yɛrɛ ta ye. ");
INSERT INTO dyu_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","« ‹Ni mɔgɔ dɔ ta misi ka mɔgɔ wɛrɛ ta misi tu k’a faga, misi min ka turi kɛ, o bɛ fiyeere k’a wari taran o ni ɲɔgɔn cɛ; o bɛ misi faganin sogo taran o ni ɲɔgɔn cɛ fana. ");
INSERT INTO dyu_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Nka ni a kɛra ko o misi tun bɛ deri ka misi tɔw tu, ni misitigi k’a lɔn, nka a ma sɔn k’a janto a ra, o tuma a ta misi ka misi min faga, a bɛ o misi ɲɔgɔn sara ni misi wɛrɛ ye; misi su bɛ kɛ ale yɛrɛ ta ye. ");
INSERT INTO dyu_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","« ‹Ni mɔgɔ dɔ ka misi, walama saga, walama ba sonya k’a faga, walama k’a fiyeere, ni misi lo, a kan ka misi looru le di a ɲɔgɔn ye. Ni saga lo, walama ba, a ka kan ka o ɲɔgɔn naani le di.› » ");
INSERT INTO dyu_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","« ‹Ni son dɔ minana su fɛ k’a sɔrɔ a b’a fɛ ka don bon kɔnɔ, ni o k’a bugɔ fɔ k’a faga, kiti tɛna kɛ o ra. ");
INSERT INTO dyu_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Nka ni a minana tere fɛ le, ni o k’a faga, o tuma a fagabaga jarakira. Ni son minana tere fɛ, a ka fɛn minw sonya, a ka kan ka olugu sara le. Ni foyi tɛ a boro k’a sara, o tuma o ye a yɛrɛ fiyeere k’a kɛ a ta sonyari jurusara ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ayiwa, ni a kɛra ko a ka misi, walama fali, walama saga, walama ba le sonya, ni a ɲanaman yera a boro, a ka kan ka o misi, walama o fali, walama o saga, walama o ba sonyanin ɲɔgɔn fla le di.› » ");
INSERT INTO dyu_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","« ‹Ni mɔgɔ min k’a lawuri a kama k’a to a ta bɛganw ye dɔ ta siman cɛn, walama ka dɔ ta rɛzɛnforo cɛn, bɛgantigi bɛna a yɛrɛ ta foro simanw ni a ta rɛzɛnw bɛɛ ra ɲumanman di o forotigi ma a sara ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ni mɔgɔ dɔ ka tasuma don, ni tasuma tagara se binɲaga ma, ka bonya ka taga don dɔ ta foro ra, ka taga o tigi ta siman tigɛnin, walama siman senin tigɛbari, walama a sebari jɛni, min ka o tasuma don, o tigi ka kan ka forotigi ta siman sara a ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","« ‹Ni mɔgɔ dɔ ka wari, walama fɛn wɛrɛ karifa a mɔgɔɲɔgɔn ma ko a ye a mara a ye, ni o k’a sonya a fɛ so kɔnɔ, ni son ka mina, a ka kan ka o fɛn ɲɔgɔn fla sara o tigi ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Nka ni son ma ye, o tuma wari, walama fɛn tun karifara min ma, o tigi ye Ala kɛ a seere ye, ka kari ko ale yɛrɛ le ma o fɛn ta. ");
INSERT INTO dyu_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","« ‹Ayiwa, ni mɔgɔ fla jigira ɲɔgɔn na, misi, walama fali, walama saga, walama fani, walama fɛn dɔ wɛrɛ kosɔn, ko a tun tununa o fɛ, ni o fla bɛɛ ko o ta tun lo, o tuma o ye taga ni o ko ye Ala ɲa kɔrɔ. Ni Ala ka min jaraki, o tigi bɛna o fɛn tununin ɲɔgɔn fla sara tɔ kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","« ‹Ni mɔgɔ dɔ ka fali, walama misi, walama saga, walama ba, walama bɛgan suguya wɛrɛ di a mɔgɔɲɔgɔn ma ko a ye a mara, ni o bɛgan ka sa, walama ni a yɔrɔ dɔ ka kari, walama ni o k’a sonya k’a sɔrɔ mɔgɔ ma bɔ a kala ma, ");
INSERT INTO dyu_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","o tuma, karifa kɛra min ma, o ka kan ka kari Ala ra a tɔɲɔgɔn ɲana, ko ale boro ma maga a ra. Ayiwa, bɛgantigi ye sɔn o kariri ma; o tuma karifa kɛra min ma, o man kan ka foyi sara tuun. ");
INSERT INTO dyu_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Nka ni bɛgan sonyana a ta so le kɔnɔ, o tuma a ka kan k’a ɲɔgɔn sara bɛgantigi ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ni a kɛra ko wara dɔ le k’a faga k’a domu, a ye na ni wara datɔ ye ka na o yira, janko o ye kɛ a seere ye. Ni o kɛra, a man kan ka o bɛgan sara tuun. ");
INSERT INTO dyu_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","« ‹Ni dɔ ka bɛgan singa a mɔgɔɲɔgɔn fɛ, ni o bɛgan yɔrɔ dɔ ka kari, walama ni a ka faga, k’a sɔrɔ bɛgantigi yɛrɛ tɛ yi, min ka bɛgan singa, o ka kan k’a ɲɔgɔn sara bɛgantigi ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Nka ni a kɛra ko bɛgantigi yɛrɛ tun bɛ yi, min ka bɛgan singa, o man kan ka foyi sara tuun. Ni a kɛra ko a tun ka bɛgan ta a fɛ sara le ra, o wari le bɛna kɛ a sara ye.› » ");
INSERT INTO dyu_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","« ‹Sunguru min ma cɛko lɔn, ni a fana ma mamina fɔlɔ, ni cɛ dɔ ka o sunguru nɛgɛ ka jɛn ni a ye, o cɛ ka kan k’a furunaforo bɔ k’a di sunguru facɛ ma, k’a furu. ");
INSERT INTO dyu_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","« ‹Ni sunguru facɛ ma sɔn k’a denmuso di a ma, o bɛɛ n’a ta, cɛ ka kan ka o sunguru furunaforo sara, ka kaɲa ni furunaforo sariya ye.› » ");
INSERT INTO dyu_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","« ‹Muso o muso bɛ subagaya kɛ, aw ye o faga, aw kana a to yi. ");
INSERT INTO dyu_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","« ‹Ni mɔgɔ o mɔgɔ ka jɛn ni bɛgan ye, aw ye o tigi faga. ");
INSERT INTO dyu_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","« ‹Ni mɔgɔ o mɔgɔ ka saraka bɔ batofɛn wɛrɛw ye, ni Matigi Ala kelenpe tɛ, aw ye o tigi mina k’a faga. ");
INSERT INTO dyu_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","« ‹Aw kana kojugu kɛ lonanw na, walama ka o jɔnyamina, sabu aw fana tun ye lonanw le ye Misiran jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","« ‹Muso cɛ saninw, ani feritaninw, aw kana olugu tɔɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ni aw ka o tɔɔrɔ, ni o kasira ka ne tɔgɔ wele, ne Matigi Ala, ne bɛna o kasikan mɛn, sigiya tɛ o ra. ");
INSERT INTO dyu_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ne bɛna dimi aw kɔrɔ kosɛbɛ, k’a to aw juguw ye aw faga kɛrɛ ra ni kɛrɛkɛmuru ye. O tuma aw yɛrɛw ta musow le bɛna kɛ muso cɛ saninw ye, aw ta denw bɛ kɛ feritaninw ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","« ‹Ni aw ka wari juru don aw ta siyamɔgɔ fagantan dɔ ra, aw kana a kɛ i ko jurunantigi tɔw b’a kɛ cogo min na; aw kana a fɔ ko a ye wari dɔ fara a kan k’a sara aw ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","« ‹Ni i ka i mɔgɔɲɔgɔn ta deregeba mina a fɛ i ta juru kosɔn, i ka kan k’a kɔsegi a ma sani tere ye ben; ");
INSERT INTO dyu_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","sabu i b’a sɔrɔ ko o dɔrɔn le b’a fɛ k’a yɛrɛ datugu. Ni i ka o mina a ra, a bɛna mun le kɛ k’a yɛrɛ datugu su fɛ ka la? Ni a kasira, ka ne tɔgɔ wele, ne bɛna a kasikan mɛn, sabu ne bɛ hina. ");
INSERT INTO dyu_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","« ‹Aw kana Matigi Ala tɔgɔ cɛn, walama ka kumajugu fɔ aw ta jamana ɲamɔgɔ dɔ ma. ");
INSERT INTO dyu_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","« ‹Ni siman sera, walama ni rɛzɛn sera, aw man kan ka mɛɛn ka na ni siman fɔlɔ ye, walama rɛzɛn fɔlɔ, ka na o di ne ma saraka ye. Aw ka kan ka aw dencɛ fɔlɔw fana bla danna, ka o kɛ ne ta ye. ");
INSERT INTO dyu_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","O cogo kelen na fana, aw ye aw ta misiw ni aw ta sagaw ni aw ta baw fana den fɔlɔw di ne ma saraka ye. Nka o woronin ka kan ka to o ba kɔrɔ fɔlɔ, fɔ tere wolonfla. O tere seeginan le ra, aw bɛ sɔrɔ ka o di ne ma. ");
INSERT INTO dyu_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","« ‹Aw bɛɛ ka kan ka kɛ mɔgɔ saninmanw ye, ka kɛ ne ta ye. « ‹Ni wara ka bɛgan o bɛgan faga kongo kɔnɔ k’a domu, aw kana o tɔ domu. Aw ye o di wuruw ma.› » ");
INSERT INTO dyu_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ayiwa, Matigi Ala k’a fɔ Izirayɛlimɔgɔw ye tuun ko: «Ko min tɛ can ye, aw kana yaala ka o lakari. Aw kana jɛn ni mɔgɔjuguw ye ka faninya la mɔgɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Aw kana tugu jama nɔ fɛ, ka kojugu kɛ. Aw fana kana tugu jama kɔ, ka sɔn ka kɛ ko dɔ seere ye min tɛ ko terennin ye. ");
INSERT INTO dyu_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Aw kana kiti tigɛ k’a diya mɔgɔ dɔ ra ko a tigi ye fagantan ye. ");
INSERT INTO dyu_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Ni i bɛnna ni i jugu ta misi tununin ye, walama a ta fali, i ye a gbɛn ka taga a di a ma. ");
INSERT INTO dyu_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ni i ka i jugu ta fali dɛsɛnin ye doni kɔrɔ, hali ni a dɛmɛlɔgɔ tɛ i ra, i ye a dɛmɛ. ");
INSERT INTO dyu_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Aw kana kiti ben fagantan kan kititigɛyɔrɔ ra k’a ta jo bɔsi a ra. ");
INSERT INTO dyu_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","«Aw kana sɔn ka mɔgɔ jaraki faninya kan, ka mɔgɔ jarakibari, walama mɔgɔ terennin faga; sabu ne tɛ mɔgɔjugu jarakibari to. ");
INSERT INTO dyu_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","«Aw kana sɔn ka bonyafɛn mina mɔgɔ fɛ, ka kiti diya a tigi ra; sabu bonyafɛn bɛ mɔgɔ yerikɛbagaw ɲa fiyen, ka mɔgɔ terenninw ta kuma jɛngɛ. ");
INSERT INTO dyu_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Aw kana lonan jɔnyamina; lonanya ye min ye, aw yɛrɛ ka o silɔn, sabu aw fana tun ye lonanw le ye Misiran jamana ra.» ");
INSERT INTO dyu_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«San wɔɔrɔ kɔnɔ aw ka kan ka aw ta dugukolo sɛnɛ k’a siman tigɛ. ");
INSERT INTO dyu_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Nka a san wolonflanan, aw ye o yɔrɔ dugukolo to yi pewu, janko a ye a yɛrɛ sɔrɔ. Ni o kɛra, dɛsɛbagatɔ minw bɛ aw cɛ ra, olugu fana bɛna dɔ sɔrɔ a ra k’a domu. Ni a tɔ min ka to olugu kɔ, kongosogow bɛna o domu. Aw ka kan ka o kelen le kɛ aw ta oliviyeforow ni aw ta rɛzɛnforow ra. ");
INSERT INTO dyu_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«Aw ye baara kɛ tere wɔɔrɔ; a tere wolonflanan, aw ye nɛnɛkiri, janko aw ta misiw, ni aw ta faliw, ni aw ta jɔnw, ni aw ta lonanw bɛɛ ye nɛnɛkiri. ");
INSERT INTO dyu_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Ne min ye Matigi Ala ye, ni ne ka fɛn o fɛn fɔ aw ye, aw ye tagama ka kaɲa ni o le ye. Aw ye aw yɛrɛ kɔrɔsi kosɛbɛ, aw kana batofɛn wɛrɛ si tɔgɔ fɔ aw da ra. Mɔgɔ si yɛrɛ man kan ka batofɛn wɛrɛ tɔgɔ mɛn aw da ra.» ");
INSERT INTO dyu_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Ayiwa, san o san, aw ka kan ka ɲanagbɛ saba le kɛ ne ye, ka ne bonya. ");
INSERT INTO dyu_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","A fɔlɔ, aw ka kan ka burufunubari ɲanagbɛ* kɛ. Ni Abibu karo sera, ka kaɲa ni wagati latigɛnin ye, i n’a fɔ ne k’a fɔ aw ye cogo min na, aw ka kan ka burufunubari le domu fɔ tere wolonfla; sabu aw bɔra Misiran jamana ra o karo le ra. O ɲanagbɛ ra, mɔgɔ si kana na ne ɲa kɔrɔ fana yɔrɔ saninman na, ka na ne bato, k’a sɔrɔ foyi tɛ a boro k’a di ne ma saraka ye. ");
INSERT INTO dyu_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«Ayiwa, o kɔ, aw bɛ fɛn minw sɛnɛ aw ta foro kɔnɔ, ni aw bɛ o simankura kun fɔlɔ tigɛ tuma o tuma, aw ye simantigɛ ɲanagbɛ kɛ. «Ni san yɛlɛmana fana, ni aw bɛ aw ta forow yiridenw ladon tuma min na, aw ye simanladon ɲanagbɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","«O cogo ra, san o san, cɛw bɛɛ ka kan ka na siɲaga saba ne Matigi Ala ɲa kɔrɔ, ka na saraka bɔ ne ye o ɲanagbɛw ra. ");
INSERT INTO dyu_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Ni aw b’a fɛ ka bɛgan saraka* bɔ ne ye, aw kana o jori ni burufununin kori ɲɔgɔn na. Sarakasogo turu fana man kan ka bla ka si. ");
INSERT INTO dyu_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Aw ka kan ka na ni aw ta simankura kun fɔlɔ ye Matigi Ala, aw ta Ala ta batoso kɔnɔ. Aw kana badennin tobi ni a ba ta nɔnɔ ye.» ");
INSERT INTO dyu_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ayiwa, Matigi Ala k’a fɔ Musa ye tuun ko: «Ne bɛna mɛlɛkɛ dɔ ci aw ɲa fɛ, janko o ye aw kɔrɔsi sira ra. Ne ka yɔrɔ min labɛn aw ye, a bɛna taga aw ladon yi. ");
INSERT INTO dyu_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Aw ye aw yɛrɛ kɔrɔsi o mɛlɛkɛ ra. Aw ye a lamɛn; aw kana a sɔsɔ; ni o tɛ, a tɛna aw ta hakɛ yafa aw ma dɛ! Sabu a bɛ a ta baara kɛra ne tɔgɔ le ra. ");
INSERT INTO dyu_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nka ni aw k’a lamɛn, ani ne ka fɛn o fɛn fɔ aw ye, ni aw ka o kɛ, o tuma ne bɛna aw juguw kɛrɛ aw ye, ka aw kɛrɛkɛɲɔgɔnw kɛrɛ aw ye. ");
INSERT INTO dyu_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ne ta mɛlɛkɛ bɛna bla aw ɲa fɛ, ka taga aw ladon Amɔrikaw, ani Hɛtikaw, ani Perezikaw, ani Kanaanakaw, ani Hevikaw, ani Yebusikaw ta jamana ra. Ne bɛna o mɔgɔw bɛɛ halaki. ");
INSERT INTO dyu_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Nka aw man kan ka biri o ta batofɛnw kɔrɔ ka o bato fiyewu; aw kana saraka bɔ o ye. Aw kana o mɔgɔw ta kokɛcogow ladegi. Aw ye o halaki le ka o ban pewu, ka o ta batofɛnw bɛɛ cici, ani o bɛ kabakurujan minw sɔn. ");
INSERT INTO dyu_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Aw ka kan ka baara kɛ Matigi Ala, aw ta Ala le ye. Ni o kɛra, ne bɛna baraka don aw ta domuni ni aw ta ji ra, ka bana mabɔ aw ra. ");
INSERT INTO dyu_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Aw ta jamana ra, muso si kɔnɔ tɛna cɛn; muso si tɛna kɛ den worobari ye fana. Ne bɛna aw si janya. ");
INSERT INTO dyu_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«Siya min o min bɛ aw ɲa fɛ, ne bɛna siranyaba le bla olugu bɛɛ ra, sani aw ye se o ma. Aw bɛna se siya o siya ma, ne bɛna o bɛɛ gbɛn aw ɲa. Ne bɛna a to aw juguw bɛɛ ye bori aw ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ne bɛna o ja wuri, k’a to o bɛɛ ye bori aw ɲa. Ne bɛna Hevikaw, ni Kanaanakaw, ni Hɛtikaw gbɛn ka o bɔ aw ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nka ne tɛna o bɛɛ gbɛn ka bɔ aw ɲa san kelen dɔrɔn. Ni o tɛ, jamana lakolon bɛna to, waraw bɛna caya, ka to ka ben aw kan. ");
INSERT INTO dyu_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","«Ne bɛna to ka o jamana mɔgɔw gbɛn aw ɲa dɔɔnin dɔɔnin le, fɔ aw ye na caya ka se ka jamana bɛɛ fa. ");
INSERT INTO dyu_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","«Ne bɛna aw ta jamana dan sigi; k’a ta Kɔgɔjiwulen da ra, ka taga a bla fɔ Filisikaw ta jamana kɔgɔjida ra, ani k’a ta kongokolonba dan na, ka taga a bla fɔ Efirati bada ra. Ne bɛna o jamanaw mɔgɔw bɛɛ don aw boro. Aw bɛna o bɛɛ gbɛn ka bɔ aw ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","«Aw kana jɛnɲɔgɔnya si don ni o ye, walama ni o ta batofɛnw ye. ");
INSERT INTO dyu_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","«Aw kana sɔn o ye sigi aw ta jamana ra, janko o kana na a to aw ye ne hakɛ ta; sabu ni o sigira ni aw ye, a laban, aw bɛna o ta batofɛnw bato. O fana bɛna kɛ sababu ye ka aw lafiri.» ");
INSERT INTO dyu_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Matigi Ala k’a fɔ Musa ye tuun ko: «Yɛlɛn ka na kuru kan ne fɛ yan; ele ni Haruna, ani Nadabu, ani Abihu, ani Izirayɛli cɛkɔrɔba biwolonfla. Nka ni aw nana, aw ye to yɔrɔjan ka aw ɲa biri dugu ma ka ne bato. ");
INSERT INTO dyu_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","«O kɔ, ele Musa kelen dɔrɔn le ye gbara ne ra; olugu kana gbara ne ra. Mɔgɔ tɔw fana kana yɛlɛn ni aw ye.» ");
INSERT INTO dyu_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ayiwa, Matigi Ala ka sariya ni ci minw fɔ Musa ye, Musa tagara o bɛɛ fɔ mɔgɔw ye. Jama bɛɛ jɛnna ka Musa jaabi ko: «Matigi Ala ka min o min fɔ, anw kɔni bɛna o bɛɛ kɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ayiwa, Matigi Ala ka kuma minw bɛɛ fɔ Musa ye, Musa ka o bɛɛ sɛbɛ. O kɔ, a wurira sɔgɔmada joona fɛ, ka sarakajɛnifɛn dɔ lɔ kuru kɛrɛ fɛ, ka kabakurujan tan ni fla lɔlɔ fana ka kaɲa ni Izirayɛlimɔgɔw ta gba tan ni fla tɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","A ka Izirayɛli kanbelen dɔw ci ko olugu ye saraka jɛnitaw* faga Matigi Ala ye, ka misitoranw faga, k’a kɛ ninsɔndiya saraka* ye. ");
INSERT INTO dyu_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa ka o misitoranw jori tarancɛ kɛ minan dɔw kɔnɔ, k’a tɔ seriseri sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","O kɔ, a tun ka Ala ta sariyaw, ani a ta ciw sɛbɛ jɛnɲɔgɔnya Kitabu min kɔnɔ, a ka o ta k’a karan ni kanba ye jama bɛɛ ɲa na. O bɛɛ k’a fɔ ko: «Matigi Ala ka kuma o kuma fɔ, an bɛna o bɛɛ le kɛ a cogo yɛrɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ayiwa, Musa tun ka jori min kɛ minanw kɔnɔ, a ka o ta k’a seriseri mɔgɔw kan, k’a fɔ o ye ko: «Matigi ka jɛnɲɔgɔnya min don ni aw ye, k’a ta sariyaw bɛɛ fɔ aw ye, nin jori le ye o jɛnɲɔgɔnya sarati ye.» ");
INSERT INTO dyu_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ayiwa, Musa yɛlɛnna kuru kan, ani Haruna ni Nadabu ni Abihu ni Izirayɛli cɛkɔrɔba biwolonfla. ");
INSERT INTO dyu_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","O ka Izirayɛli ta Ala ye. A senkɔrɔyɔrɔ tun bɛ i ko safiri lulu min bɛ manamana, k’a nɔɔrɔ kɛ i ko sankolo yɛrɛ nɔɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Nka Matigi Ala ma foyi kɛ o mɔgɔw ra. O ka Ala ye; o kɔ, o ka domuni kɛ, ka minni kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Matigi Ala ko Musa ma ko: «Yɛlɛn ka na kuru kunna ne kɔrɔ yan, i ye lɔ yan. Ne ka sariyaw ni kumaw sɛbɛ kabakuru walaka minw kan, ne bɛna o di i ma, janko i ye Izirayɛlimɔgɔw karan o ra.» ");
INSERT INTO dyu_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musa yɛlɛnna kuru kunna, ani a ta baaraden Yosuwe. ");
INSERT INTO dyu_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Nka sani o ye taga, Musa k’a fɔ cɛkɔrɔbaw ye ko: «Aw ye an kɔnɔ yan, fɔ an ye sekɔ ka na. Haruna ni Huri bɛ ni aw ye yan. Ni aw b’a fɛ ka ko dɔ ɲanabɔ, aw ye taga olugu fɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ayiwa, ka Musa yɛlɛntɔ to kuru kunna, sankaba ka kuru datugu. ");
INSERT INTO dyu_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Matigi Ala ta nɔɔrɔ tora Sinayi kuru kan. Sankaba ka kuru datugu ka se fɔ tere wɔɔrɔ. A tere wolonflanan, Matigi Ala tora sankaba kɔnɔ ka Musa wele. ");
INSERT INTO dyu_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Izirayɛlimɔgɔw ka Matigi Ala nɔɔrɔ ye o ɲa ra. A kɛra i n’a fɔ tasuma farimanba le bɛ jɛnina kuru san fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa donna sankaba kɔnɔ ka to ka yɛlɛn ka taga kuru kunna yi. A tora o yɔrɔ ra yi ka tere binaani ni su binaani kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«A fɔ Izirayɛlimɔgɔw ye ko o ye na ni o borofɛn dɔw ye ka na o di ne ma. Mɔgɔ o mɔgɔ bɛna sɔn k’a di ni ŋaninyaɲuman ye, aw ye o bɛɛ ta mina. ");
INSERT INTO dyu_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","O bɛna min di, o ye nin ye: sanin, ani warigbɛ, ani siranɛgɛ, ");
INSERT INTO dyu_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ani sagasi jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛnfani fiyɛnman, ani basiw, ");
INSERT INTO dyu_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ani sagajigi gbolo min logira k’a wulen, ani gbolojalan, ani akasiyayiri, ");
INSERT INTO dyu_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ani fitinaturu, ani kasadiyanan minw bɛ kɛ ka turu saninman ni wusunan lalaga, ");
INSERT INTO dyu_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ani onikisi lulu, ani lulu wɛrɛ minw bɛna kɛ ka saninderege ni disirafɛn masiri. ");
INSERT INTO dyu_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Aw ye fanibon saninman dɔ lalaga ne ye, janko ne ye sigi aw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ne bɛna o fɛnw bisigiya min yira aw ra, aw ka kan ka fanibon saninman ni a minanw bɛɛ lalaga o cogo kelen le ra.» ");
INSERT INTO dyu_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Aw ye kɛsu dɔ lalaga ni akasiyayiri ye. A janya ye kɛ nɔngɔn ɲa fla ni tarancɛ, a bonya ye kɛ nɔngɔn ɲa kelen ni tarancɛ, a lɔ fana ye kɛ nɔngɔn ɲa kelen ni tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Aw ye sanin yɛrɛworo la a yɔrɔ bɛɛ kan; a kɔkanyɔrɔ ni a kɔnɔnɔyɔrɔ bɛɛ. Ka sanin kɛ k’a konkonda lamini. ");
INSERT INTO dyu_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Aw ye sanin gbasi, k’a koori, ka wo kɛ a ra; aw ye o ɲɔgɔn naani lalaga, ka o dondon kɛsu fan naani na; ka fla don fan kelen na, ka tɔ fla don fan tɔ kelen na. ");
INSERT INTO dyu_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Aw ye akasiyayiri dɔw lɛsɛ, k’a kɛ bere fla ye. Ka sanin gbasi k’a la o berew yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","O berew le bɛna don sanin koorininw wow ra kɛsu fan fla ra, ka to ka kɛsu ta ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","O berew ka kan ka to o wo koorininw na tuma bɛɛ; a man kan ka bɔ a ra fiyewu. ");
INSERT INTO dyu_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ne bɛna jɛnɲɔgɔnya sariya minw sɛbɛ k’a di i ma, i ye o bla o kɛsu kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Aw ye kɛsu datugunan fana lalaga ni sanin yɛrɛworo ye. A janya ye kɛ nɔngɔn ɲa fla ni tarancɛ, a bonya ye kɛ nɔngɔn ɲa kelen ni tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","«Aw ye sanin gbasi ka o kɛ serubɛn mɛlɛkɛ bisigi fla ye, ka o lɔlɔ kɛsu datugunan fan fla ra; ");
INSERT INTO dyu_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ka kelen kɛ datugunan kun dɔ ra, ka kelen wɛrɛ kɛ a kun tɔ kelen na. Aw ye mɛlɛkɛw lɔ kɛsu datugunan fan fla ra. ");
INSERT INTO dyu_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","O sanin serubɛn mɛlɛkɛw fla kamanw ka kan ka biri kɛsu datugunan kunna, k’a datugu ni o kamanw ye, ka o fla ɲasin ɲɔgɔn ma, ka o ɲaw biri kɛsu datugunan kunna. ");
INSERT INTO dyu_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ne bɛna sariya minw di aw ma, i ye o bla kɛsu kɔnɔ, ka datugunan biri kɛsu kunna. ");
INSERT INTO dyu_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","«Ne bɛna ne yɛrɛ yira i ra o yɔrɔ le ra, kɛsu datugunan san fɛ, sanin serubɛn mɛlɛkɛ fla cɛ ma, o minw bɛ jɛnɲɔgɔnya tagamasiyɛn kɛsu kunna. Ne bɛna ne ta ciw bɛɛ fɔ i ye o yɔrɔ le ra, janko i ye a fɔ Izirayɛlimɔgɔw ye.» ");
INSERT INTO dyu_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Aw ye tabali dɔ fana lalaga ni akasiyayiri ye. A janya ye kɛ nɔngɔn ɲa fla ye, a bonya ye kɛ nɔngɔn ɲa kelen ye, a lɔ ye kɛ nɔngɔn ɲa kelen ni tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Aw ye sanin yɛrɛworo la o tabali yɔrɔ bɛɛ kan, ka sanin kɛ k’a konkonda lamini. ");
INSERT INTO dyu_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Aw y’a to tabali konkonda ye bonya dɔɔnin, k’a bonya kɛ i ko borokanden naani bonya, ka sanin kɛ k’a dagbolo lamini. ");
INSERT INTO dyu_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Aw ye sanin gbasi, k’a koori, ka wo kɛ a ra; aw ye o ɲɔgɔn naani lalaga, ka o dondon tabali nɔngɔn naani na, tabali senw kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Aw ye o sanin koorininw dondon tabali senw sanfɛyɔrɔw ra, a nɔngɔn naani na. Berew ka kan ka don o wow le ra ka tabali ta. ");
INSERT INTO dyu_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Aw ye o berew kɛ ni akasiyayiri le ye, ka sanin la o berew bɛɛ kan. Aw bɛna tabali ta ni o berew le ye. ");
INSERT INTO dyu_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","«Aw ye minan dɔw lalaga fana, i n’a fɔ tasaw, ani sɛtiw, ani bɛlɛnw, ani jifiyɛw, ka rɛzɛnji sarakaw* kɛ ni o ye. Aw ye o bɛɛ lalaga ni sanin yɛrɛworo le ye. ");
INSERT INTO dyu_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Aw ka kan ka sarakaburuw bla o tabali le kan ne ɲa kɔrɔ wagati bɛɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«O kɔ, aw ye fitinablanan dɔ lalaga ni sanin yɛrɛworo gbasinin ye. A ka kan ka kɛ ni sanin kuturu kelen le ye. Aw ye sen kɛ a ra, ani a fitinaborow, ka fɛn dɔw kɛ a ra i ko yiriden bisigiw, ka kuruw kɛ o kɔrɔ, ka fɛn dɔw kɛ a ra fana i ko yirifiyeren bisigiw. ");
INSERT INTO dyu_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Aw ye fitinaboro wɔɔrɔ kɛ fitinablanan cɛmancɛ boro ra; ka boro saba kɛ a fan kelen na, ka saba kɛ a fan dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Aw ye yiriden bisigi saba kɛ a boro kelen kelen bɛɛ ra, k’a kɛ i ko amande yiridenw; aw ye kuruw kɛ a ra fana, ani yirifiyeren bisigiw. Fitinaborow bɛɛ ta ka kan ka kɛ ten. ");
INSERT INTO dyu_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Aw ye yiriden bisigi naani kɛ a cɛmancɛ boro ra fana, ka o kɛ i ko amande yiridenw, ka kuruw kɛ a ra, ani yirifiyeren bisigiw. ");
INSERT INTO dyu_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Aw ye kuru kelen kɛ fitina boro fla jukɔrɔ, ka kuru kelen kɛ fitina boro fla wɛrɛ ju kɔrɔ, ka fitinaboro wɔɔrɔ bɛɛ ta kɛ ten. ");
INSERT INTO dyu_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","A kuruw ni a borow ni a yɔrɔ tɔw bɛɛ ka kan ka kɛ sanin kuturu kelen le ye. Aw ye a bɛɛ kɛ ni sanin yɛrɛworo gbasinin ye. ");
INSERT INTO dyu_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«Aw ye fitinadaga wolonfla lalaga ka o sigisigi a borow bɛɛ kelen kelen kunna. O fitinadagaw bɛɛ ye yeelen bɔ o ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ayiwa, a fɛn tɔw, i n’a fɔ a tasuma lalagananw, ani a buguri donminanw, o bɛɛ ka kan ka kɛ sanin yɛrɛworo le ye. ");
INSERT INTO dyu_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Aw ye fitinablanan ni a minanw bɛɛ lalaga ni sanin yɛrɛworo kilo bisaba ye. ");
INSERT INTO dyu_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","«Ayiwa, Musa, ne bɛ nin fɛnw bisigiya min yirara i ra kuru kan, i ye o kɔrɔsi kosɛbɛ, k’a to a ye kɛ ka kaɲa ni o ye.» ");
INSERT INTO dyu_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Aw ye fani gbiriman tan dan ni lɛn jese ye, ani jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ. Aw ye o faniw dan ni o jesew ye; o kɔ, aw ye o sɔgɔ, ka serubɛn mɛlɛkɛ fla ja bisigiyaw kɛ o kan. ");
INSERT INTO dyu_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Faniw bɛɛ kelen kelen janya ka kan ka kɛ nɔngɔn ɲa mugan ni seegi ye, k’a bonya kɛ nɔngɔn ɲa naani ye. Faniw bɛɛ ka kan ka kɛ kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Aw ye o faniw looru tugutugu ɲɔgɔn na, k’a kɛ fanimugu kelen ye, k’a tɔ looru fana tugu ɲɔgɔn na ka o fana kɛ fanimugu kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Aw ye juruden dɔw dan ni jese bulaman ye ka o sirisiri fanimugu fɔlɔ dagbolo ra, ka dɔw sirisiri fana a flanan dagbolo ra. ");
INSERT INTO dyu_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Aw ye juruden bilooru don fanimugu fɔlɔ dagbolo ra, ka bilooru fana don fanimugu flanan dagbolo ra. Fanimugu fla ta jurudenw da ka kan ka bɛn ni ɲɔgɔn ye. ");
INSERT INTO dyu_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Aw ye sanin koorinin bilooru lalaga ka fanimugu fla mina k’a tugu ɲɔgɔn na ni o sanin koorininw ye. O cogo ra, fanibon bɛɛ bɛ kɛ fanimugu kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«Ayiwa, o kɔ, aw ye fani gbiriman tan ni kelen dan tuun ni basiw ye; aw ye o biri fanibon kunna. ");
INSERT INTO dyu_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","O faniw bɛɛ kelen kelen janya ye kɛ nɔngɔn ɲa bisaba ye, k’a bonya kɛ nɔngɔn ɲa fla ye. O fani gbiriman tan ni kelen bɛɛ janya ye kɛ kelen ye, ka o bonya kɛ kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Aw ye o fani gbiriman looru tugutugu ɲɔgɔn na k’a kɛ fanimugu kelen ye, k’a tɔ wɔɔrɔ fana tugutugu ɲɔgɔn na ka o fana kɛ fanimugu kelen ye. A wɔɔrɔnan le bɛna kɛ ka fanibon ɲafɛyɔrɔ datugu. ");
INSERT INTO dyu_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Aw ye juruden bilooru siri fanimugu fɔlɔ dagbolo ra, ka bilooru fana siri fanimugu flanan dagbolo ra. ");
INSERT INTO dyu_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Aw ye siranɛgɛ koorinin bilooru lalaga ka o kɛ ka fanimugu fla mina k’a siri ɲɔgɔn na, janko fanibon bɛɛ ye datugu ni fanimugu kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ayiwa, i n’a fɔ fanibon datugunin kɔ fani kelen belen bɛna to, aw ye o fani tarancɛ to a ye jigi ka la fanibon kɔfɛyɔrɔ kan. ");
INSERT INTO dyu_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Fani nɔngɔn ɲa kelen min bɛna bɔ fanibon fan fla ra, fanibon datugunin kɔ, o nɔngɔn ɲa kelen le bɛna jigi fanibon fan fla ra, k’a bɛɛ datugu ka ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«O kɔ, aw ye sagajigi gbolo dɔw wulen ka o kɛ ka fanimuguw datugu, ka gbolo gbiriman janin dɔ wɛrɛ lalaga ka o biri a bɛɛ lajɛnnin kunna.» ");
INSERT INTO dyu_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«O kɔ, aw ye yirifɛrɛn dɔw lɛsɛ akasiyayiri ra, minw bɛna lɔlɔ ka fanibon mina. ");
INSERT INTO dyu_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","O yirifɛrɛnw bɛɛ kelen kelen janya ye kɛ nɔngɔn ɲa tan ye, a bonya ye kɛ nɔngɔn ɲa kelen ni tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Aw ye sen fla kɛ o yirifɛrɛnw bɛɛ kelen kelen na, ka o senw kɛ ɲɔgɔn kɔrɔ. Fanibon bɛna lɔ ni yirifɛrɛn minw ye, aw ye o bɛɛ kɛ o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Aw ye yirifɛrɛn mugan lalaga, ka o kɛ fanibon woroduguyanfan ta ye, ");
INSERT INTO dyu_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ka warigbɛ den binaani gbasi ka wow bɔ o ra. Olugu le bɛna bla fla fla yirifɛrɛnw senw jukɔrɔ, ka yirifɛrɛnw senw dondon o wow ra dugu ma. ");
INSERT INTO dyu_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Aw ye yirifɛrɛn mugan lɛsɛ ka o kɛ fanibon sahiliyanfan ta ye, ");
INSERT INTO dyu_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ka warigbɛ den binaani gbasi, ka wow bɔ o ra fana, ka o kɛ sendonyɔrɔw ye. Aw ye olugu fana blabla fla fla, ka yirifɛrɛnw senw dondon o wow ra dugu ma. ");
INSERT INTO dyu_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Aw ye yirifɛrɛn wɔɔrɔ lalaga ka o kɛ fanibon kɔnɔnɔyɔrɔ ta ye, a terebenyanfan na. ");
INSERT INTO dyu_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Aw ye yirifɛrɛn dɔw lɛsɛ ka o lɔ fla fla bon kɔnɔnɔyɔrɔ ra, a nɔngɔnw na. ");
INSERT INTO dyu_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","O yirifɛrɛn fla ka kan ka nɔrɔ ɲɔgɔn na, k’a ta dugu ma fɔ san fɛ, k’a fla mina ɲɔgɔn na a sanfɛyɔrɔ ra ni nɛgɛ koorinin dɔ ye. Fanibon nɔngɔn fla bɛɛ ta yiriw ka kan ka kɛ ten le. ");
INSERT INTO dyu_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","O cogo ra, fanibon nɔngɔn naani ta yiriw bɛɛ bɛna kɛ yirifɛrɛn seegi ye, ani o sendonyɔrɔ warigbɛramanw. A bɛɛ bɛ kɛ sendonyɔrɔ tan ni wɔɔrɔ; fla bɛ don yirifɛrɛnw bɛɛ kelen kelen na. ");
INSERT INTO dyu_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«O kɔ, aw ye akasiyabere looru lɛsɛ ka o bananbiri fanibon fan kelen ta yirifɛrɛnw kan, ka yirifɛrɛnw mina ni o ye; ");
INSERT INTO dyu_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ka looru wɛrɛ lɛsɛ ka o bananbiri fanibon fan dɔ ta yirifɛrɛnw kan, ka o mina ni o ye fana; ka looru wɛrɛ lɛsɛ tuun ka o bananbiri fanibon kɔnɔnɔyɔrɔ ta yirifɛrɛnw kan, a terebenyanfan na, ka o yirifɛrɛnw mina ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Cɛmancɛbere ka kan ka tɛmɛ yirifɛrɛnw cɛmancɛ ra, k’a ta fanibon kun dɔ ra ka taga a bla a kun dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Aw ye sanin yeele k’a bɔn yirifɛrɛnw bɛɛ kan. Berew bɛna don nɛgɛ koorinin minw na ka yirifɛrɛnw mina, aw ye olugu bɛɛ kɛ ni sanin ye. Aw ye sanin la berew fana kan. ");
INSERT INTO dyu_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ayiwa, o ra, Musa, ne ka fanibon bisigiya min yira i ra kuru kan yan, i ye a lɔ ka kaɲa ni o le ye.» ");
INSERT INTO dyu_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Fani min bɛna kɛ ka fanibon cɛtigɛ, aw ye o dan ni jese bulaman ye, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. Aw ye o fani sɔgɔ ka ɲa, ka serubɛn mɛlɛkɛw ja bisigiyaw kɛ a ra. ");
INSERT INTO dyu_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Aw ye akasiyayiri naani lɛsɛ, ka sanin yeele k’a bɔn o bɛɛ kan. Aw ye nɛgɛ koorinin dɔw kɛ ni sanin ye, ka o dondon o yiriw ra. Aw ye sendonyɔrɔ naani kɛ ni warigbɛ ye, ka o yiriw sigisigi o kan. ");
INSERT INTO dyu_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Aw ye boncɛtigɛfani dulon o nɛgɛ koorininw jukɔrɔ. Aw ye jɛnɲɔgɔnya kɛsu* bla boncɛtigɛfani kɔfɛyɔrɔ ra. O boncɛtigɛfani le bɛna bon taran, k’a kɛ bonkɔnɔ fla ye. Bonkɔnɔ fɔlɔ bɛna kɛ Ala ta yɔrɔ saninman* ye, bonkɔnɔ flanan bɛ kɛ Ala ta yɔrɔ saninmanba* ye. ");
INSERT INTO dyu_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","O kɔ, aw ye kɛsu datugunan kɛ ka jɛnɲɔgɔnya tagamasiyɛn kɛsu datugu yɔrɔ saninmanba kɔnɔ yi. ");
INSERT INTO dyu_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Aw ye tabali bla boncɛtigɛfani ɲafɛyɔrɔ ra yɔrɔ saninman kɔnɔ, bon sahiliyanfan fɛ. Aw ye fitinablanan lɔ bon woroduguyanfan fɛ, k’a ɲasin tabali ma. ");
INSERT INTO dyu_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Fani min bɛna siri fanibon da ra, aw ye o dan ni jese bulaman ye, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. Aw ye a sɔgɔ ka ɲa kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Aw ye akasiyabere looru tigɛ ka o lɛsɛ, ka sanin la o berew bɛɛ kan; faniw bɛna dulon o berew le ra. Aw ye nɛgɛ koorinin dɔw lalaga ni sanin ye ka o don o berew ra. O kɔ, aw ye sendonyɔrɔ looru lalaga ni siranɛgɛ ye ka o berew sigi o kan.» ");
INSERT INTO dyu_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ala k’a fɔ Musa ye tuun ko: «Min ye sarakajɛnifɛn* ye, aw ye o lalaga ni akasiyayiri ye fana. Aw ye a janya kɛ nɔngɔn ɲa looru ye, k’a bonya fana kɛ nɔngɔn ɲa looru ye. A fan naani bɛɛ janya ye kɛ kelen ye. A lɔ ye kɛ nɔngɔn ɲa saba ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Aw ye gban naani kɛ a nɔngɔn naani na, ka siranɛgɛ yeele k’a bɔn o gbanw bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Aw ye sarakajɛnifɛn ta minanw bɛɛ lalaga; a buguri donminanw, ani a buguricɛnanw, ani a tasaw, ani a sogosɔgɔnanw, ani a takamidonnan. Aw ye o minanw bɛɛ kɛ ni siranɛgɛ le ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Aw ye nɛgɛ woman dɔ kɛ ni siranɛgɛ ye fana, k’a kɛ i n’a fɔ nɛgɛsansan. Aw ye siranɛgɛ koorinin naani kɛ ka o don a nɔngɔn naani na. ");
INSERT INTO dyu_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Aw ye o nɛgɛ woman la sarakajɛnifɛn konkonda jukɔrɔyɔrɔ kan, a kɔnɔnɔyɔrɔ ra, k’a se sarakajɛnifɛn lɔ cɛmancɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Aw ye akasiyabere fla tigɛ ka o kɛ sarakajɛnifɛn taberew ye. Aw ye siranɛgɛ yeele ka o bɔn o berew bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Aw ye o berew don siranɛgɛ koorininw wow ra, sarakajɛnifɛn fan fla ra, ka o berew kɛ ka sarakajɛnifɛn ta. ");
INSERT INTO dyu_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Aw ye sarakajɛnifɛn lalaga ni yirifɛrɛnw ye, k’a kɔnɔ lakolon to. «Ayiwa, Musa, ne ka bisigiya min yira i ra kuru kan yan, aw ye a lalaga ka kaɲa ni o le ye.» ");
INSERT INTO dyu_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Ayiwa, o kɔ, aw ye fanibon lukɛnɛ lamini. Aw ye lukɛnɛ woroduguyanfan laminifaniw dan ni lɛn jese ye. O fan kelen janya ye kɛ nɔngɔn ɲa kɛmɛ ye, ");
INSERT INTO dyu_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","k’a berew kɛ mugan ye, ani sendonyɔrɔ siranɛgɛraman mugan, berew bɛna sigi minw kan. Koori minw bɛna kɛ berew ra, ani fanidulonnanw, aw ye olugu lalaga ni warigbɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Aw ye a sahiliyanfan fana lalaga o cogo kelen na. O fana janya ye kɛ nɔngɔn ɲa kɛmɛ ye, k’a berew kɛ mugan ye, ani sendonyɔrɔ siranɛgɛraman mugan, berew bɛna sigi minw kan. Koori minw bɛna kɛ berew ra, ani fanidulonnanw, aw ye olugu lalaga ni warigbɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Aw ye lukɛnɛ terebenyanfan laminifani janya kɛ nɔngɔn ɲa bilooru ye; o ye lukɛnɛ bonya ye. Aw ye a berew kɛ bere tan ye, k’a berew donyɔrɔw fana kɛ tan ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ayiwa, lukɛnɛ terebɔyanfan, min ye a donda fan ye, o fana janya ye kɛ nɔngɔn ɲa bilooru ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Lu donda kininboroyanfan faniw janya ye kɛ nɔngɔn ɲa tan ni looru ye, k’a berew kɛ saba ye, k’a berew donyɔrɔw fana kɛ saba ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Lu donda numanboroyanfan janya ye kɛ nɔngɔn ɲa tan ni looru ye fana, k’a berew kɛ saba ye, ka berew donyɔrɔw fana kɛ saba ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Fani min bɛna bla lu donda yɛrɛ ra, aw ye o janya kɛ nɔngɔn ɲa mugan ye. Aw ye o fani sɔgɔ ni jese bulaman ye, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. A berew ye kɛ naani ye, ka o donyɔrɔw kɛ naani ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Bere minw bɛɛ bɛna kɛ ka lu lamini, aw ye o fanidulonyɔrɔw bɛɛ lalaga ni warigbɛ ye; koori minw fana ka kan ka don o ra, aw ye o lalaga ni warigbɛ ye, ka berew donyɔrɔw bɛɛ kɛ ni siranɛgɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","«Lu janya ka kan ka kɛ nɔngɔn ɲa kɛmɛ, k’a bonya kɛ nɔngɔn ɲa bilooru; a laminifaniw lɔ ka kan ka kɛ nɔngɔn ɲa looru. Fani minw bɛna kɛ ka lu lamini, aw ye o dan ni lɛn jese ye; berew donyɔrɔw ye kɛ ni siranɛgɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","«Fanibon bɛna lɔ ni nɛgɛ minw ye, olugu fana ka kan ka kɛ siranɛgɛ le ye. Fanibon ta juruw, ani lu laminifaniw ta juruw bɛna siri nɛgɛbere minw na dugu ma, o nɛgɛberew bɛɛ ye kɛ siranɛgɛ ye.» ");
INSERT INTO dyu_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ayiwa, Matigi Ala k’a fɔ Musa ye tuun ko: «Musa, i bɛna a fɔ Izirayɛlimɔgɔw ye ko o ye na ni oliviye turu yɛrɛworo ye, ka o kɛ fitinadagaw kɔnɔ, janko fitinadagaw mananin ye to wagati bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ayiwa, Haruna ni a dencɛw ye fitinablanan sigi fanibon kɔnɔ, boncɛtigɛfani ɲa fɛ, jɛnɲɔgɔnya kɛsu* bɛ o fani min kɔ fɛ. Fitinaw mananin ka kan ka to ne ɲa kɔrɔ lon o lon, k’a ta wula fɛ fɔ ka taga se sɔgɔma. O ye sariya le ye, Haruna ni a dencɛw, ani Izirayɛlimɔgɔw ka kan ka min sira tagama tuma bɛɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ala k’a fɔ Musa ye tuun ko: «Musa, i bɛna i kɔrɔcɛ Haruna ni a dencɛw, Nadabu, ani Abihu, ani Elehazari, ani Itamari wele ka o gbara i yɛrɛ ra. I bɛna olugu bɔ Izirayɛlimɔgɔw cɛ ra ka o bla danna ne ye, o ye sarakalasebagaya baara kɛ ne ye. ");
INSERT INTO dyu_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","I bɛna fani saninman dɔw karan i kɔrɔcɛ Haruna ye, min bɛ a yira ko a blara danna ne ta baara kama, ani min bɛ a masiri, ka a ni mɔgɔ tɔw bɔ ɲɔgɔn na. ");
INSERT INTO dyu_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","«Ayiwa, mɔgɔ minw bɛ se baara ra kosɛbɛ, ne ka hakiritigiya di minw ma, i bɛna a fɔ olugu ye ko o ye Haruna ta faniw karan; a bɛna o faniw le don k’a yira ko a blara danna ka sarakalasebagaya baara kɛ ne ye. ");
INSERT INTO dyu_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","O ka kan ka fani minw karan, o ye nin ye: disirafɛn, ani saninderege, ani forokiyajan ni forokiyasurun sɔgɔnin, ani jalamugu fugula ni cɛsirinan. I kɔrɔcɛ Haruna ni a dencɛw bɛna o faniw le don ka sarakalasebagaya baara kɛ ne ye. ");
INSERT INTO dyu_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","O mɔgɔw ye o faniw baara ni sanin ye, ani jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese.» ");
INSERT INTO dyu_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«O ka kan ka saninderege lalaga ni saninjese ye, ani jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese; ka a sɔgɔ ka ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","O ye juru dɔ don saninderege kamankun fla ra, k’a ɲafɛyɔrɔ ni a kɔfɛyɔrɔ tugu ɲɔgɔn na. ");
INSERT INTO dyu_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Cɛsirinan ni saninderege baaracogo ka kan ka kɛ kelen ye. A ka kan ka karan saninderege ra. A ka kan ka kɛ ni sanin le ye, ani jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. ");
INSERT INTO dyu_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Lulu bisigi min tɔgɔ ye ko onikisi, o ye o fla ta, ka Izirayɛli ta gba tan ni fla bɛɛ tɔgɔ sɛbɛ o kan ni nɛgɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","O ye tɔgɔ wɔɔrɔ sɛbɛ lulu fɔlɔ kan, ka wɔɔrɔ sɛbɛ a flanan kan, k’a damina o bɛɛ ra kɔrɔba ra, ka taga a bla o bɛɛ ra fitini na. ");
INSERT INTO dyu_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Aw ye Izirayɛli ta gbaw tɔgɔw sɛbɛ o lulu fla kan, i n’a fɔ sɛbɛri bɛ kɛ kabakuru kan cogo min na, k’a kɛ tagamasiyɛn ye. O kɔ, aw ye sanin kɛ ka o luluw lamini. ");
INSERT INTO dyu_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","O kɔ, aw ye o lulu fla don saninderege kamankun fla ra, ka o kɛ hakirijigifɛn ye Izirayɛli siya tan ni fla ko ra. O cogo ra, Izirayɛli ta gbaw tɔgɔ bɛna kɛ Haruna kamankun kan Matigi Ala ɲa kɔrɔ, k’a yira ko ne hakiri bɛ aw ra tuma bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","O lulu bisigiw bɛna don fɛn min kɔnɔ, o fana ka kan ka lalaga ni sanin le ye. ");
INSERT INTO dyu_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","O kɔ, aw ye saninjuru fla kɛ ni sanin yɛrɛworo ye, k’a dan i ko jurukisɛ bɛ dan cogo min na; luluw bɛna don fɛn minw kɔnɔ, aw ye o saninjuruw nɔrɔ o fɛnw na.» ");
INSERT INTO dyu_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Ayiwa, o kɔ, aw ye disirafɛn lalaga, min ye kititigɛnan ye; ale ni saninderege lalagacogo bɛɛ bɛ kɛ kelen ye. O ye a lalaga ka ɲa, k’a ɲɛgɛn ni saninjese ye, ani jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. ");
INSERT INTO dyu_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","A fan naani bɛɛ janya ye kɛ kelen ye. A ye kɛ fla, k’a fla kuru k’a la ɲɔgɔn kan. A janya ye kɛ sibiri ɲa kelen, k’a bonya fana kɛ sibiri ɲa kelen. ");
INSERT INTO dyu_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Aw ye lulu bisigi dɔw dondon a ra k’a masiri ni o ye. Aw ye o luluw kɛ sira naani ye. A sira fɔlɔ ye kɛ sariduwani lulu ye, ani topazi lulu, ani emerodi lulu. ");
INSERT INTO dyu_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","A sira flanan ye kɛ sikaribuli lulu ye, ani safiri lulu, ani jaman. ");
INSERT INTO dyu_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","A sira sabanan ye kɛ opali lulu ye, ani agati lulu, ani ametisi lulu. ");
INSERT INTO dyu_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","A sira naaninan ye kɛ kirisoliti lulu ye, ani onikisi lulu, ani jasipe lulu. O lulu bɛɛ donyɔrɔ ka kan ka lalaga ni sanin le ye. ");
INSERT INTO dyu_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","A bɛɛ lajɛnnin bɛ kɛ lulu den tan ni fla ye, ka kaɲa ni Izirayɛli ta gbaw tɔgɔw ye. Izirayɛlimɔgɔw ta siya tan ni fla bɛɛ kelen kelen tɔgɔ ye sɛbɛ ni nɛgɛ ye lulu kelen kelen kan, i n’a fɔ tagamasiyɛnfɛnw bɛ sɛbɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Aw ye saninjuru fla lalaga ni sanin yɛrɛworo ye, k’a dan i n’a fɔ jurukisɛ bɛ dan cogo min na, ka o siri disirafɛn na. ");
INSERT INTO dyu_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Aw ye sanin dɔ gbasi ka nɛgɛ koorinin fla lalaga, ka o don disirafɛn kun fla ra, a sanfɛyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Aw ye o saninjuru fla siri kooriw wow ra, disirafɛn kun fla ra, a sanfɛyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","O kɔ, aw ye saninjuru kun fla tɔ siri saninderege kamankunw na, luluw donyɔrɔ ra, ka disirafɛn bla ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","O kɔ, aw ye sanin dɔ gbasi ka koori fla wɛrɛ lalaga ka o siri disirafɛn kɔfɛyɔrɔ ra, a kun fla min bɛ a dugumayanfan na. ");
INSERT INTO dyu_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Aw ye sanin dɔ gbasi tuun ka koori fla wɛrɛ lalaga, ka o siri saninderege kamankun fla ra, lulu fla ɲafɛyɔrɔ jukɔrɔ, karansira kɛrɛ fɛ, saninderege cɛsirinan san fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Aw ye disirafɛn ta kooriw ni saninderege ta kooriw siri ɲɔgɔn na ni jese bulaman ye, janko disirafɛn lanin ye to cɛsirinan san fɛ, saninderege kan; a kana yɔgɔyɔgɔ ka bɔ saninderege kan. ");
INSERT INTO dyu_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«O cogo ra, ni Haruna bɛ don yɔrɔ saninman* kɔnɔ tuma o tuma, Izirayɛli ta mɔgɔw ta gbaw tɔgɔ sɛbɛnin bɛ kɛ disirafɛn min kan, min ye kititigɛnan ye, o bɛ kɛ a disi kan, ani a jusukun na, ka o kɛ hakirijigifɛn ye Matigi Ala ɲa kɔrɔ tuma bɛɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ala k’a fɔ Musa ye tuun ko: «Musa, ele bɛna Urimi ni Tumimi bla disirafɛn jufa kɔnɔ. Ni Haruna bɛ don yɔrɔ saninman kɔnɔ tuma o tuma ne Matigi Ala ɲa kɔrɔ, a ye o siri a disi ra. Tuma o tuma ni a bɛ taga lɔ ne ɲa kɔrɔ, a ye kɛ a disi kan, ani a jusukun na, janko a ye ne sago lɔn k’a yira Izirayɛlimɔgɔw ra.» ");
INSERT INTO dyu_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Ayiwa, Haruna bɛna saninderege don forokiyajan min kan, o ka kan ka dan ni jese bulaman le ye. ");
INSERT INTO dyu_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Aw ye forokiyajan kan bɔ, ka fani gbiriman dɔ karan ka a kan lamini, k’a gbiriya, janko a kana faran. ");
INSERT INTO dyu_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Aw ye forokiyajan senkɔrɔyɔrɔ bɛɛ masiri ni gerenadi yiriden bisigi dɔw ye. Aw ye o kɛ ni jese bulaman ye, ani a wulenman bisigi, ani a wulenman yɛrɛ, ka tanan dennin dɔw lalaga ni sanin ye ka o dondon o yiriden bisigiw cɛ ma. ");
INSERT INTO dyu_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ni aw ka sanin tanan dennin kelen don, aw ye gerenadi yiriden kelen gban o ra; ni aw ka sanin tanan dennin kelen don, aw ye gerenadi yiriden kelen gban o ra, fɔ ka taga forokiyajan senkɔrɔyɔrɔ bɛɛ lamini. ");
INSERT INTO dyu_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Haruna ye to ka o forokiyajan don, k’a ta sarakalasebagaya baara kɛ. Tuma min ni a bɛ don yɔrɔ saninman* kɔnɔ Matigi Ala ɲa kɔrɔ, walama ni a bɛ bɔ, o tanan denninw bɛna mankan bɔ; o cogo ra a tɛna sa. ");
INSERT INTO dyu_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Aw ye sanin yɛrɛworo dɔ gbasi k’a kɛ i n’a fɔ yirifiyeren bisigi dɔ; ka sɛbɛri dɔ kɛ o kan ni nɛgɛ ye, i n’a fɔ o bɛ tagamasiyɛnfɛn sɛbɛ cogo min na. Aw ye a sɛbɛ a kan ko: A SANINYARA KA KƐ MATIGI ALA TA YE. ");
INSERT INTO dyu_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Aw ye o sanin masirifɛn siri jalamugu fugula ɲa fɛ, Haruna ten na, ni jese bulaman dɔ ye. ");
INSERT INTO dyu_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Haruna bɛna o masirifɛn siri a ten na; o ra, Izirayɛlimɔgɔw bɛna hakɛko minw kɛ o ta saraka saninmanw bɔwagati ra, o hakɛw bɛna to ale kan. O masirifɛn ka kan ka kɛ a ten na wagati bɛɛ, janko ne Matigi Ala, ne ye sɔn o sarakaw ma. ");
INSERT INTO dyu_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Aw ye forokiyasurun dɔ karan Haruna ye ni lɛn jese ye, k’a jalamugu fugula dɔ kɛ ni lɛnfani ye, ka cɛsirinan dɔ fana dan, ka o sɔgɔ, k’a cɛɲa. ");
INSERT INTO dyu_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aw ye forokiyasurunw, ani cɛsirinanw ni banfla dɔw kɛ Haruna dencɛw fana ye, min bɛ a yira ko o blara danna ne ta baara kama, ani min bɛ o masiri, ka o ni mɔgɔ tɔw bɔ ɲɔgɔn na. ");
INSERT INTO dyu_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","«Ayiwa, o kɔ, Musa, ele bɛna o faniw don i kɔrɔcɛ Haruna ni a dencɛw ra, ka turu saninman* kɛ o kun na, ka o saninya ka o bla danna janko o ye sarakalasebagaya baara kɛ ne ye. ");
INSERT INTO dyu_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Aw ye kurusi dɔ karan o ye ni lɛnfani ye, janko o ye o don forokiyajan jukɔrɔ ka o yɛrɛ sutara. O kurusiw janya ka kan ka damina o soro ra, ka taga se fɔ o wotow ra. ");
INSERT INTO dyu_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ni Haruna ni a dencɛw bɛ don Ɲɔgɔnkunbɛn fanibon* kɔnɔ tuma o tuma, walama ni o bɛ gbara sarakajɛnifɛn na ka baara kɛ yɔrɔ saninman kɔnɔ, o faniw ka kan ka kɛ o ra. Ni o tɛ, ni o lebu yera, o bɛ sa. O ko ka kan ka kɛ sariya wuribari le ye Haruna ni a ta durujaw bɛɛ fɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ala k’a fɔ Musa ye tuun ko: «Sisan i ka kan ka fɛn minw kɛ ka Haruna ni a dencɛw saninya ka o bla danna, janko o ye sarakalasebagaya baara kɛ ne ye, o flɛ nin ye: I bɛna misitoran kaɲaman kelen ni sagajigi fla mina, fiyɛn tɛ minw na. ");
INSERT INTO dyu_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","I bɛ mugu tɛntɛnnin dɔ ta fana, ka burufunubari dɔw lalaga; ka mugu dɔ nɔɔni turu ra, ka o jɛni ka o kɛ buru ye, funufɛn kana kɛ a ra, ka ŋɔmi fana kɛ, ka turu kɛ a kan, funufɛn kana kɛ a ra. ");
INSERT INTO dyu_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","I ye o bla segi dɔ kɔnɔ, ka na ni a ye yɔrɔ saninman* na, ani misitoran kaɲaman, ani sagajigi fla. ");
INSERT INTO dyu_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«I ye Haruna ni a dencɛw lana Ɲɔgɔnkunbɛn fanibon donda ra, ka o ko ni ji ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","O kɔ, i ye faniw ta ka o don Haruna ra; forokiyasurun, ani saninderege bɛ don forokiyajan min kan, ani saninderege yɛrɛ, ani disirafɛn, ani cɛsirinan min bɛ kɛ ka saninderege cɛsiri. ");
INSERT INTO dyu_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","I ye jalamugu fugula biri a kun na, ka sanin masirifɛn siri o kan a ten na. ");
INSERT INTO dyu_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","O kɔ, i ye turu saninman* dɔ kɛ a kun na, k’a saninya, k’a bla ne ta baara kama. ");
INSERT INTO dyu_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","O kɔ, i ye Haruna dencɛw fana gbara i yɛrɛ ra, ka olugu ta forokiyasurunw don o kan na fana; ");
INSERT INTO dyu_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ka o ta cɛsirinan siri o cɛ ra, ka o ta banflaw biri o kun na. Sarakalasebagaya baara bɛna kɛ olugu ta le ye tuma bɛɛ; o ye sariya dablabari le ye. «I bɛna Haruna ni a dencɛw saninya ka o bla danna ne ta baara kama o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«O kɔ, i ye na ni misitoran ye Ɲɔgɔnkunbɛn fanibon* donda ra. Haruna ni a dencɛw ye o boro la a kun na. ");
INSERT INTO dyu_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","I ye o misi kan tigɛ ne Ala ɲa kɔrɔ, Ɲɔgɔnkunbɛn fanibon donda ra. ");
INSERT INTO dyu_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","I ye i borokanden su misi jori ra, k’a mun sarakajɛnifɛn* gbanw na, ka jori tɔ seriseri sarakajɛnifɛn* senkɔrɔyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ayiwa, ni i ka misi boso, misi kɔnɔnɔ turu, ani a biyɛn, ani a kɔkiri fla, ani a turu bɛɛ, i ye o bɛɛ la sarakajɛnifɛn kan k’a jɛni ka ban pewu. ");
INSERT INTO dyu_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Nka a sogo tɔ, ani a gbolo, ani a nogow, i ye taga o jɛni kɛnɛ ma, fanibonw kɔ fɛ. O bɛna kɛ saraka le ye min bɛ sarakalasebagaw ta jurumun yafa. ");
INSERT INTO dyu_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","O kɔ, i ye sagajigi kelen mina; Haruna ni a dencɛw ye o boro la o sagajigi fana kun na. ");
INSERT INTO dyu_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","I ye o sagajigi kan tigɛ, k’a jori seriseri sarakajɛnifɛn fan bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","I ye a boso, k’a tigɛtigɛ, k’a kɔnɔfɛnw ni a senw ko, ka o lala sogo tɔ ni a kunkolo kan, ");
INSERT INTO dyu_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ka sagajigi bɛɛ jɛni sarakajɛnifɛn kan k’a ban. O ye saraka jɛninin le ye min dira ne Matigi Ala ma; saraka jɛninin lo tasuma ra min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«O kɔ, i ye sagajigi flanan mina; Haruna ni a dencɛw ye o boro la a kun na. ");
INSERT INTO dyu_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","I ye o sagajigi fana kan tigɛ, k’a jori dɔɔnin ta k’a mun Haruna kininboroyanfan toro nunkun na, ani a dencɛw fana kininboroyanfan toro nunkun, ka dɔ mun o kininboroyanfan borokandenkunba ra, ani o kininboroyanfan senmandenba; o kɔ, i ye jori tɔ bɔn sarakajɛnifɛn fan bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ayiwa, o kɔ, jori min bɔnna sarakajɛnifɛn kan, i ye o dɔ ta, ka o ni turu saninman* dɔ seriseri Haruna ni a ta faniw kan, ka dɔ seriseri a dencɛw ni o ta faniw fana kan. O cogo le ra, Haruna ni a dencɛw ni o ta faniw bɛɛ bɛna saninya ka kɛ ne ta ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«O kɔ, i ye o sagajigi turu, ani a kukala, ani a kɔnɔnɔturu, ani a biyɛn, ani a kɔkiri fla ni a turu, ani a kininboroyanfan woto fara ɲɔgɔn kan; sabu o sagajigi le bɛna kɛ saraka ye ka Haruna ni a dencɛw saninya ka o bla danna ne ta baara kama. ");
INSERT INTO dyu_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","O kɔ, i tun ka burufunubariw bla segi min kɔnɔ, ne Matigi Ala ɲa kɔrɔ, i ye burukun kelen ta o ra, ani buru turuman kelen, ani ŋɔmikun kelen. ");
INSERT INTO dyu_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","I ye o fɛnw don Haruna ni a dencɛw boro, ko o ye a kɔrɔta san fɛ, ne Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","O kɔ, i ye o fɛnw bɔ o boro, ka o jɛni ni saraka jɛnita* ye sarakajɛnifɛn kan. Saraka jɛninin lo tasuma ra Matigi Ala ye, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«Ayiwa, o sagajigi flanan min kɛra ka Haruna ni a dencɛw saninya ka o bla danna ne ta baara kama, i ye o sagajigi disi ta k’a wuri san fɛ, k’a fifa, Matigi Ala ɲa kɔrɔ. O disi bɛna kɛ i yɛrɛ ninyɔrɔ ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«O kɔ, i ye a fɔ Izirayɛlimɔgɔw ye ko o sagajigi disi min fifara, ani a kaman min kɔrɔtara san fɛ Matigi Ala ɲa kɔrɔ, ko o ye fɛn saninmanw le ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","O le kosɔn ni Izirayɛlimɔgɔw bɛ ninsɔndiya saraka* bɔ ne ye tuma o tuma, o ka kan ka bɛgan disi ni a kaman bɔ ka o di Haruna ni a ta duruja ma, sabu saraka lo min kɔrɔtara san fɛ; jɛnɲɔgɔnya sarakaw ra, bɛgan saraka* yɔrɔ min kɔrɔtara san fɛ, o ye Matigi Ala ta le ye; o ye Haruna ni a ta duruja ninyɔrɔ ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Haruna ta fani saninmanw bɛna kɛ a dencɛw ta le ye ale sanin kɔ. Olugu ra, ni o nana turu kɛ min kun na ka o sigi sarakalasebagaya baara ra, o tigi le bɛna o fani saninmanw don. ");
INSERT INTO dyu_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Haruna dencɛ min bɛna sigi a nɔ ra sarakalasebagaya ra, ale bɛna o derege don tere wolonfla, ka sɔrɔ ka don Ɲɔgɔnkunbɛn fanibon kɔnɔ, Ala ta yɔrɔ saninman* na ka sarakalasebagaya baara damina. ");
INSERT INTO dyu_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Ayiwa, sagajigi min kɛra saraka ye ka Haruna ni a dencɛw sigi sarakalasebagaya ra, i ye o sogo tɔ ta ka taga a tobi yɔrɔ saninman dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Haruna ni a dencɛw ye a sogo domu, ani buru minw bɛ segi kɔnɔ. O ye o domu Ɲɔgɔnkunbɛn fanibon da ra. ");
INSERT INTO dyu_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","O saraka minw kɛra ka jurumun kafari, ka sarakalasebagaw saninya ka o bla sarakalasebagaya ra, ayiwa, sarakalasebagaw dɔrɔn le ka kan ka o sarakaw domu. Mɔgɔ wɛrɛ man kan k’a domu, sabu saraka lo min dira Ala ma. ");
INSERT INTO dyu_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ayiwa, ni o sogo walama ni o buru dɔ sira, o ye a jɛni k’a ban pewu; a man kan ka domu, sabu fɛn saninman lo. ");
INSERT INTO dyu_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«Ne ka ci minw bɛɛ fɔ i ye Haruna ni a dencɛw ko ra, i ye o ciw bɛɛ kɛ a cogo ra. I ka kan ka tere wolonfla le kɛ ka o saninya ka sɔrɔ ka o bla sarakalasebagaya baara ra. ");
INSERT INTO dyu_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","«O tere wolonfla kɔnɔ, i ka kan ka misitoran kelen faga lon o lon, ka o kɛ ka jurumun kafari. I bɛna sarakajɛnifɛn saninya ni o saraka le ye. O kɔ, i ye turu saninman* seriseri sarakajɛnifɛn kan, k’a saninya. ");
INSERT INTO dyu_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Tere wolonfla kɔnɔ, lon o lon i ye o saraka bɔ ka jurumun kafari, ka sarakajɛnifɛn saninya. O cogo ra, sarakajɛnifɛn bɛna kɛ fɛn saninyaninba ye. Ni fɛn o fɛn ka maga sarakajɛnifɛn na, o bɛ saninya fana.» ");
INSERT INTO dyu_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Ayiwa, i ka kan ka saraka minw bɔ sarakajɛnifɛn* kan lon o lon, o ye nin ye: sagaden fla, minw si ka san kelen sɔrɔ; i ye o faga lon o lon. O man kan ka dabla fiyewu. ");
INSERT INTO dyu_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","I ye kelen faga sɔgɔma, ka tɔ kelen faga wula fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Sɔgɔma, ni i bɛ sagaden fɔlɔ kɛ saraka ye, i ye mugu tɛntɛnnin kilo saba, ani oliviye turu litiri kelen ni tarancɛ ɲagami ɲɔgɔn na, ka rɛzɛnji litiri kelen ni tarancɛ ta, ka o fara saraka kan. ");
INSERT INTO dyu_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Wula fɛ, ni i bɛ sagaden flanan kɛ saraka ye, i bɛ mugu saraka*, ani rɛzɛnji saraka* fara a kan, i n’a fɔ sɔgɔmada ta. A ye kɛ saraka jɛninin ye tasuma ra, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Nin ye saraka jɛnita* le ye; i ni i ta duruja nataw ka kan ka o saraka bɔ lon o lon Ɲɔgɔnkunbɛn fanibon donda ra ne ɲa kɔrɔ. Ne bɛna ne yɛrɛ yira aw ra o yɔrɔ le ra, ka kuma i fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ne bɛna ne yɛrɛ yira Izirayɛlimɔgɔw ra o yɔrɔ le ra. Ne ta nɔɔrɔ bɛna o yɔrɔ saninya. ");
INSERT INTO dyu_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ne le bɛna Ɲɔgɔnkunbɛn fanibon ni sarakajɛnifɛn saninya. Ne le fana bɛna Haruna ni a dencɛw saninya janko o ye sarakalasebagaya baara kɛ ne ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ne bɛna sigi Izirayɛlimɔgɔw cɛ ra, ka kɛ o ta Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","O fana bɛna a lɔn ko ne le ye Matigi Ala ye, o ta Ala; ko ne ka o labɔ Misiran jamana ra, janko ne ye sigi o cɛ ra. Ne le ye Matigi Ala ye, o ta Ala.» ");
INSERT INTO dyu_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Aw ye sarakabɔnan dɔ lalaga, ka wusunan saraka bɔ o kan. Aw ye a lalaga ni akasiyayiri ye. ");
INSERT INTO dyu_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","A janya ye kɛ nɔngɔn ɲa kelen ye, a bonya fana ye kɛ nɔngɔn ɲa kelen ye. A janya ni a bonya bɛɛ ye kɛ kelen ye, a lɔ ye kɛ nɔngɔn ɲa fla ye. Aw ye gbanw kɛ a nɔngɔn naani bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Aw ye sanin yɛrɛworo yeele, k’a bɔn a yɔrɔ bɛɛ kan; a sanfɛyɔrɔ ni a kɛrɛfɛyɔrɔw ni a gbanw bɛɛ. Aw ye a konkondaw bɛɛ lamini ni sanin ye. ");
INSERT INTO dyu_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Aw ye sanin koorinin fla gbasi ka o don a konkondaw jukɔrɔ, a fan fla ra. Aw ye bere fla don o wow ra; aw bɛna a ta ni o berew le ye. ");
INSERT INTO dyu_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Aw ye o berew lalaga ni akasiyayiri ye, ka sanin yeele k’a bɔn o yɔrɔw bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Aw ye wusunanjɛnifɛn sigi boncɛtigɛfani ɲafɛyɔrɔ ra; jɛnɲɔgɔnya kɛsu* ni jurumun kafariyɔrɔ bɛ o boncɛtigɛfani min kɔ fɛ, ne bɛna to ka ne yɛrɛ yira i ra o yɔrɔ le ra. ");
INSERT INTO dyu_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","«Ayiwa, Haruna ye to ka wusunan kasadiman don o wusunanjɛnifɛn kan sɔgɔma o sɔgɔma, tuma min ni a bɛ don ka fitinadagaw labɛn. ");
INSERT INTO dyu_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ni a donna wula fɛ fana ko a bɛ fitinaw mana, a ye wusunan dɔ don. O wusunan kasadiman ka kan ka don tuma bɛɛ ne Matigi Ala ɲa kɔrɔ. Aw ta durujaw bɛɛ ka kan k’a kɛ ten le. ");
INSERT INTO dyu_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","«Aw kana wusunan suguya wɛrɛ don o wusunanjɛnifɛn kan, walama ka saraka jɛnita* dɔ jɛni a kan, walama ka siman saraka* bɔ a kan, walama ka rɛzɛnji saraka* bɔn a kan. ");
INSERT INTO dyu_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","«Haruna ka kan k’a saninya san kɔnɔ siɲaga kelen. Ni a ka bɛgan min kɛ ka jurumun kafari, a ye o jori dɔ ta k’a mun wusunanjɛnifɛn gbanw na. Aw ta duruja nataw bɛɛ ka kan k’a kɛ ten le tuma bɛɛ. O wusunanjɛnifɛn bɛna bla danna, ka saninya, ka kɛ ne Matigi Ala ta ye.» ");
INSERT INTO dyu_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ayiwa, Matigi Ala k’a fɔ Musa ye tuun ko: ");
INSERT INTO dyu_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Ni i bɛ Izirayɛlimɔgɔw jate tuma min na, o bɛɛ kelen kelen ka kan ka o nin kunmabɔsara di ne ma; ni o tɛ, banajugu dɔw bɛna o sɔrɔ o jateri wagati ra. ");
INSERT INTO dyu_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ayiwa, o bɛna o wari di cogo min na, o ye nin ye: mɔgɔ o mɔgɔ jatera, o bɛɛ kelen kelen ye warigbɛ garamu wɔɔrɔ ɲɔgɔn di, ka kaɲa ni yɔrɔ saninman* ta jate ye. Ala ta yɔrɔ saninman ta jate ra, o warigbɛ bɛ bɛn garamu tan ni fla le ma. O warigbɛ tarancɛ le bɛna kɛ ne Matigi Ala ta ye. ");
INSERT INTO dyu_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","«Ni mɔgɔ o mɔgɔ jatera, k’a ta san mugan na, o bɛɛ ka kan ka ne Matigi Ala ta di. ");
INSERT INTO dyu_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Dɔ man kan ka fara naforotigi ta kan, dɔ fana man kan ka bɔ fagantan ta ra. A fɔra ko bɛɛ ka kan ka da min di k’a kɛ a nin kunmabɔsara ye, bɛɛ ye o le di Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ni i ka o wari mina Izirayɛlimɔgɔw fɛ tuma min na, i ye o kɛ ka Ɲɔgɔnkunbɛn fanibon* baara kɛ. O le ra ne hakiri bɛna to Izirayɛlimɔgɔw ra ka o nin kunmabɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Matigi Ala k’a fɔ Musa ye tuun ko: ");
INSERT INTO dyu_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Aw ye tasaba dɔ lalaga ni siranɛgɛ ye, ka siginan kɛ a ra, k’a sigi Ɲɔgɔnkunbɛn fanibon ni sarakajɛnifɛn furancɛ ra, ka ji kɛ a kɔnɔ. Sarakalasebagaw bɛna o yɛrɛ saninya ni o ji le ye. ");
INSERT INTO dyu_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruna ni a dencɛw bɛna o boro ni o senw ko a ra, ");
INSERT INTO dyu_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ka sɔrɔ ka don Ɲɔgɔnkunbɛn fanibon kɔnɔ, janko o kana sa; ani fana ni o bɛ gbara sarakajɛnifɛn na, ka o ta sarakalasebagaya kɛ, ka saraka jɛni ne ye, ");
INSERT INTO dyu_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","o ka kan ka o borow, ani o senw ko, janko o kana na sa. O sariya bɛna kɛ sariya wuribari le ye Haruna ni a ta durujaw fɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Matigi Ala k’a fɔ Musa ye tuun ko: ");
INSERT INTO dyu_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Turu kasadimanw bɛɛ ra ɲumanman dɔw fara ɲɔgɔn kan: mire jiman kilo looru, ani sinamɔne kasadiman kilo fla ni tarancɛ, ani kanɛli kasadiman kilo fla ni tarancɛ, ");
INSERT INTO dyu_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ani kase kasadiman kilo wɔɔrɔ; o bɛɛ ye kɛ ka kaɲa ni yɔrɔ saninman* ta jate ye, ka oliviye turu litiri wɔɔrɔ fara o bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Turulalagabaga dɔ ye o bɛɛ ɲagami ɲɔgɔn na, k’a kɛ turu kasadiman ye, ani turu saninman*. O turu saninman* le bɛna kɛ ka sarakalasebagaw saninya. ");
INSERT INTO dyu_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","«I bɛna o turu le seriseri Ɲɔgɔnkunbɛn fanibon kan, k’a saninya k’a bla danna Ala ye, ani jɛnɲɔgɔnya tagamasiyɛn kɛsu*, ");
INSERT INTO dyu_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ani burutabali, ani fitinablanan ni a minanw bɛɛ, ani wusunanjɛnifɛn, ");
INSERT INTO dyu_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ani sarakajɛnifɛn ni a minanw bɛɛ, ani saninyari minan ni a siginan. ");
INSERT INTO dyu_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","I ye o fɛnw bɛɛ saninya ka o bla danna ne Ala ye. O fɛnw bɛna kɛ fɛn saninyaninbaw le ye. Ni fɛn o fɛn ka maga o ra, o fɛn bɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","I ka kan ka o turu le seriseri Haruna ni a dencɛw kan ka o saninya, janko o ye sarakalasebagaya baara kɛ ne ye. ");
INSERT INTO dyu_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","«O kɔ, i ye a fɔ Izirayɛlimɔgɔw ye ko nin turu ye turu saninman* le ye, min bɛ kɛ ka sarakalasebagaw saninya. A ka kan ka kɛ ten le aw ta duruja nataw bɛɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Mɔgɔ si man kan ka nin turu ta k’a yɛrɛ mun ni a ye. Aw kana a bɔɲɔgɔnko turu lalaga, ka a ni nin cogo bɛɛ kɛ kelen ye; sabu nin turu saninyanin lo, aw fana ka kan k’a jate fɛn saninyanin le ye. ");
INSERT INTO dyu_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ni mɔgɔ o mɔgɔ ka turu dɔ lalaga, ka a ni nin lalagacogo bɛɛ kɛ kelen ye, walama ni mɔgɔ o mɔgɔ ka nin turu kɛ ka mɔgɔ gbansan dɔ mun, o tigi ka kan ka faran ka bɔ Izirayɛli ta jamanadenw na.» ");
INSERT INTO dyu_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ayiwa, Matigi Ala k’a fɔ Musa ye tuun ko: «Kasadiyanan dɔw fara ɲɔgɔn kan: sitaki, ani ɔnkile, ani galibanɔmu, ani wusunan kasadiman yɛrɛworo. I y’a to o bɛɛ hakɛya ye kɛ kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Wusunanlalagabaga dɔ ye olugu ɲagami ɲɔgɔn na k’a kɛ wusunan saninman ye, ka kɔgɔ fana kɛ a ra. ");
INSERT INTO dyu_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","I ye a dɔ susu k’a mugu bɔ, ka o bla jɛnɲɔgɔnya kɛsu* ɲa fɛ, Ɲɔgɔnkunbɛn fanibon kɔnɔ. Ne bɛna ne yɛrɛ yira i ra o yɔrɔ le ra. ");
INSERT INTO dyu_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Aw si kana o wusunan kasadiman ɲɔgɔn lalaga aw yɛrɛ ye, ka kaɲa ni nin lalagacogo ye. Aw ka kan k’a jate fɛn saninman le ye, min blara danna Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ni mɔgɔ o mɔgɔ k’a ɲɔgɔn lalaga, ka to k’a sunsun, o tigi ka kan ka faran ka bɔ a ta jamana mɔgɔw cɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Matigi Ala k’a fɔ Musa ye tuun ko: ");
INSERT INTO dyu_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Ne ka Uri dencɛ Bɛtisalɛli le ɲanawoloma nin baara kama; Zuda ta gbamɔgɔ dɔ lo. A facɛ Uri ta facɛ le tun ye Huru ye. ");
INSERT INTO dyu_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ne ka Bɛtisalɛli hakiri fa ne ta Nin Saninman na, ka hakiritigiya ni faamuri, ni lɔnniya di a ma, janko a ye baara suguya bɛɛ kɛcogo lɔn. ");
INSERT INTO dyu_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","A bɛ se ka baara dɔw bɔ a yɛrɛ hakiri ra, k’a kɛ, ka sanin ni warigbɛ ni siranɛgɛ baara. ");
INSERT INTO dyu_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","A bɛ se ka lulu kisɛw ɲɛgɛn, ka o dondon sanin na, ka yiri lɛsɛ, ani ka baara suguya bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ne ka Ayisamaki dencɛ Oliyabu di a ma, ka o kɛ a dɛmɛbaga ye; ale ye Dan ta gbamɔgɔ dɔ le ye. Minw bɛɛ bɛ baara lɔn a ɲa ma, ne ka hakiritigiya di olugu bɛɛ ma, janko ne ka ci minw bɛɛ fɔ i ye, o ye se ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Olugu le bɛna Ɲɔgɔnkunbɛn fanibon lalaga, ani jɛnɲɔgɔnya kɛsu* ni a datugunan; o bɛna Fanibon minan tɔw bɛɛ lalaga fana: ");
INSERT INTO dyu_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","burutabali ni a minanw bɛɛ, ani fitinablanan saninlaman ni a minanw bɛɛ, ani wusunanjɛnifɛn, ");
INSERT INTO dyu_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ani sarakajɛnifɛn* ni a minanw bɛɛ, ani minanba ni a siginan, ");
INSERT INTO dyu_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ani sarakalasebagaw ta baarakɛfaniw, Haruna ta fani saninmanw, ani a dencɛw ta sarakalasebagaya faniw, ");
INSERT INTO dyu_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ani turu saninman*, ani Ala ta yɔrɔ saninman* wusunan kasadiman. O ka kan ka o fɛnw bɛɛ kɛ ka kaɲa ni ne ta cifɔninw ye.» ");
INSERT INTO dyu_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Matigi Ala k’a fɔ Musa ye tuun ko: ");
INSERT INTO dyu_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Kuma Izirayɛlimɔgɔw fɛ, i ye a fɔ o ye ko ne ka Nɛnɛkirilon* min sigi, aw ka kan ka o jate, sabu o bɛna kɛ tagamasiyɛn le ye ne ni aw cɛ, aw ta duruja nataw bɛɛ ra, janko aw y’a lɔn ko ne le ye Matigi Ala ye min ka aw saninya. ");
INSERT INTO dyu_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","O le kosɔn, aw ye Nɛnɛkirilon sariya sira tagama, sabu a ka kan ka kɛ lon saninman le ye aw fɛ. Ni mɔgɔ min ka Nɛnɛkirilon kɛ lon gbansan ye, aw ka kan ka o tigi faga. Ni mɔgɔ o mɔgɔ ka baara kɛ o lon na, aw ka kan ka o tigi faran ka bɔ Izirayɛli ta jamanadenw na. ");
INSERT INTO dyu_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Aw ye baara kɛ tere wɔɔrɔ; a tere wolonflanan ye Nɛnɛkirilon le ye; mɔgɔ man kan ka baara kɛ o lon na. O lon blara danna ka Matigi Ala bonya. Ni mɔgɔ o mɔgɔ ka baara kɛ Nɛnɛkirilon na, aw ka kan ka o tigi faga. ");
INSERT INTO dyu_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Izirayɛlimɔgɔw ka kan ka Nɛnɛkirilon sariya sira tagama, k’a kɛ lonba ye, o ni o ta duruja nataw bɛɛ; o jɛnɲɔgɔnya sariya ye sariya dablabari le ye. ");
INSERT INTO dyu_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Nɛnɛkirilon bɛna kɛ tagamasiyɛn le ye ne ni Izirayɛlimɔgɔw cɛ tuma bɛɛ; sabu ne Matigi Ala ka sankolo ni dugukolo dan tere wɔɔrɔ kɔnɔ. A tere wolonflanan, ne ka baara dabla ka nɛnɛkiri.» ");
INSERT INTO dyu_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ayiwa, Matigi Ala kumana ni Musa ye ka ban tuma min na Sinayi kuru kan, a tun ka sariyaw sɛbɛ ni a yɛrɛ boro ye kabakuru walaka fla minw kan, a ka o kabakuru walaka fla di Musa ma. ");
INSERT INTO dyu_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ayiwa, mɔgɔw k’a ye ko Musa mɛɛnna, ko a tɛ jigira ka bɔ kuru kan minkɛ, o ka ɲɔgɔn lajɛn ka taga Haruna fɛ, ka taga a fɔ a ye ko: «Haruna, wuri ka batofɛn dɔw lalaga an ye, minw bɛna bla an tagamatɔ ɲa fɛ ka taga; sabu nin cɛ tɔgɔ min ka an labɔ Misiran jamana ra, min ye Musa ye, an tɛ a yera, an m’a lɔn fɛn min k’a sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haruna k’a fɔ o ye ko: «Tororanɛgɛ saninlaman minw bɛ aw ta musow ni aw denmusow ni aw dencɛw torow ra, aw ye o bɛɛ bɔ ka na ni o ye yan.» ");
INSERT INTO dyu_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","O yɔrɔnin bɛɛ, o bɛɛ ka o ta sanin tororanɛgɛw bɔ ka na ni o ye Haruna fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Haruna ka o tororanɛgɛw mina ka o yeele, ka o kɛ misiden bisigi dɔ ye. Izirayɛlimɔgɔw ka o ye minkɛ, o pɛrɛnna ko: «Izirayɛlimɔgɔw, aw ta ala ye nin ye! Ale le ka aw labɔ Misiran jamana ra!» ");
INSERT INTO dyu_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Haruna k’a ye ko o diyara mɔgɔw ye minkɛ, a ka sarakajɛnifɛn dɔ lɔ misiden saninlaman ɲa fɛ, ka pɛrɛn k’a fɔ mɔgɔw ye ko: «Sini an bɛna ɲanagbɛba kɛ ka Matigi Ala bato!» ");
INSERT INTO dyu_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","O dugusagbɛ, o wurira sɔgɔmada joona fɛ, ka saraka jɛnita* dɔw bɔ, ani jɛnɲɔgɔnya sarakaw*. Mɔgɔw sigira ka domuni kɛ, ka min; o kɔ, o wurira ka dɔn kɛ ka o yɛrɛ ɲanagbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Matigi Ala ko Musa ma ko: «Jigi i ye taga, sabu i ka i ta mɔgɔ minw labɔ Misiran jamana ra, o ka kojuguba kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ne tun ka sira min yira o ra, o ka o yɛrɛ mabɔ o le ra yɔrɔnin kelen na tan ka ban. O ka misiden dɔ lalaga ni sanin ye, ka biri o kɔrɔ ka o bato, fɔ ka saraka bɔ a ye k’a fɔ ko: ‹Izirayɛlimɔgɔw, aw ta ala ye nin ye! Ale le ka aw labɔ Misiran jamana ra!› » ");
INSERT INTO dyu_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Matigi Ala k’a fɔ Musa ye tuun ko: «Ne k’a ye ko nin mɔgɔw ye mɔgɔ torokungbɛlɛnw le ye. ");
INSERT INTO dyu_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ayiwa, ele ye i nin bɔ a ra k’a to ne ma. Ne dimina o kɔrɔ cogo min na, ne bɛna o bɛɛ halaki ka ban pewu ten le. Ne bɛna ele Musa dɔrɔn ta duruja le kɛ siyaba ye.» ");
INSERT INTO dyu_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Musa ka Matigi Ala daari kosɛbɛ. A ko: «Matigi Ala, i ka i ta mɔgɔ minw labɔ Misiran jamana ra i ta sebagaya ni i ta baraka sababu ra, mun kosɔn i dimina o mɔgɔw kɔrɔ tan? ");
INSERT INTO dyu_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ni i ka o kɛ, Misirankaw bɛna a fɔ ko: ‹Ala k’a ta mɔgɔw labɔ Misiran ka taga kojugu le kɛ o ra.› O bɛna a fɔ ko i tun b’a fɛ ka taga o faga kuruw cɛ ra yi le, ka o si tunu ka bɔ dugukolo kan. «O ra, Matigi Ala, sabari ka i ta dimi mala. I b’a fɛ ka kojuguba min kɛ i ta mɔgɔw ra, i ta miiriya yɛlɛma ka o dabla. ");
INSERT INTO dyu_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","I hakiri to i ta jɔnw na, an bɛmacɛw Iburahima, ani Isiyaka, ni Izirayɛli. I tun ka layiri ta olugu ye, ko i bɛna o ta duruja caya i n’a fɔ lolow, ani i ka jamana min layiri ta o ye, i ko i bɛna o di o ta durujaw ma, k’a kɛ o ta ye wagati bɛɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ayiwa, Musa ka Matigi Ala daari ten minkɛ, Matigi Ala tun ko, ko a bɛna kojuguba min kɛ a ta mɔgɔw ra, a k’a ta miiriya yɛlɛma ka o dabla, a ma o kɛ tuun. ");
INSERT INTO dyu_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa jigira ka bɔ kuru kunna ni jɛnɲɔgɔnya walaka fla ye a boro. Ala ta sariyaw tun sɛbɛnin bɛ a fan fla bɛɛ kan, ");
INSERT INTO dyu_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Matigi Ala yɛrɛ boro le tun ka o walakaw lalaga. Sɛbɛri min tun fana bɛ a kan, o tun ye a yɛrɛ boro nɔ le ye. ");
INSERT INTO dyu_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ayiwa, ka Musa ni Yosuwe natɔ to, o ka mankan dɔ mɛn. Yosuwe ko Musa ma ko: «Kɛrɛ mankan dɔ bɛ bɔra dugu kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa ko Yosuwe ma ko: «Nin tɛ kɛrɛkan ye. Sesɔrɔbaga kan tɛ, sesɔrɔbari kan tɛ fana. Ne bɛ min mɛnna, o ye dɔnkirilakan le ye.» ");
INSERT INTO dyu_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","O surunyara mɔgɔw ra minkɛ, Musa ka misiden saninlaman ye, ka mɔgɔw ye o bɛ dɔn kɛra k’a lamini. Ayiwa, Musa dimikojugu fɛ, kabakuru walaka minw tun bɛ a boro, a ka o firi, ka o cici kuru sen kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","O tun ka misiden min lalaga, a ka o jɛni; k’a tɔ mugumugu, ka o mugu ɲagami ji ra, k’a di o ma, ko o ye a min. ");
INSERT INTO dyu_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","O kɔ, Musa ko Haruna ma ko: «O tuma, nin mɔgɔw ka mun le kɛ ele ra, ka na a to i sɔnna ka nin jurumunba ɲɔgɔn lase o ma?» ");
INSERT INTO dyu_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haruna ko: «Ne matigicɛ, sabari i kana dimi. Kojugu ka di nin mɔgɔw ye cogo min na, ele yɛrɛ ka o lɔn. ");
INSERT INTO dyu_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","O nana a fɔ ne ye ko: ‹Haruna, batofɛn dɔw lalaga an ye, minw bɛna bla an tagamatɔ ɲa fɛ ka taga; sabu nin cɛ min ka an labɔ Misiran jamana ra, min ye Musa ye, an tɛ a yera, an m’a lɔn fɛn min k’a sɔrɔ.› ");
INSERT INTO dyu_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ne k’a fɔ o ye o le ra, ko ni sanin bɛ mɔgɔ o mɔgɔ fɛ, a ye na ni a ye. O nana ni sanin ye ka na a di ne ma. Ne ka a don tasuma ra k’a yeele minkɛ, a kɛra nin misiden le ye.» ");
INSERT INTO dyu_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ayiwa, Musa k’a ye ko Haruna ka mɔgɔw to o yɛrɛ ma, o ka o sago kɛ. A k’a ye ko sisan olugu juguw bɛna yɛrɛko o ma. ");
INSERT INTO dyu_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa tagara lɔ dugu donda ra ka pɛrɛn ko: «Minw bɛ Matigi Ala kanu, olugu ye na ne kɔrɔ yan!» Levi ta gbamɔgɔw bɛɛ nana ɲɔgɔn kunbɛn Musa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Musa ko o ma ko: «Matigi Ala, Izirayɛli ta Ala ko: ‹Aw ra cɛ bɛɛ kelen kelen ye a ta kɛrɛkɛmuru ta. Aw ye fanibonw bɛɛ yaala, ka aw balemacɛw, ni aw teriw, ni aw sigiɲɔgɔnw faga.› » ");
INSERT INTO dyu_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Musa ka min fɔ, Levi ta mɔgɔw k’a kɛ ten. Cɛ waga saba le fagara mɔgɔw cɛ ra o lon na. ");
INSERT INTO dyu_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa ko Levi ta mɔgɔw ma o le ra ko: «Bi aw ka aw yɛrɛ bla danna Matigi ta baara kama, sabu aw ma sigiya hali ka aw dencɛw ni aw balemacɛw faga. Matigi Ala ye baraka don aw ra bi.» ");
INSERT INTO dyu_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ayiwa, o dugusagbɛ, Musa k’a fɔ mɔgɔw bɛɛ ye ko: «Aw ka jurumunba le kɛ. Ne bɛna kɔsegi kuru kunna ka taga Matigi Ala fɛ, ka taga a daari k’a flɛ, ni a bɛna sɔn ka yafa aw ma.» ");
INSERT INTO dyu_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musa kɔsegira o le ra kuru kunna Matigi Ala fɛ. A tagara a fɔ a ye ko: «E, Matigi Ala, nin mɔgɔw ka jurumunba le kɛ. O ka batofɛn saninlaman le lalaga k’a bato. ");
INSERT INTO dyu_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Sisan ne bɛ i daari, i ye yafa o ma. Ni i tɛ se ka yafa o ma, o tuma i ye ne tɔgɔ jɔsi ka bɔ i ta ɲanamanya kitabu kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Matigi Ala ko: «Ne tɛna ele tɔgɔ jɔsi. Minw ka ne hakɛ ta, ne bɛna olugu tɔgɔw le jɔsi ka bɔ ne ta ɲanamanya kitabu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ayiwa, sisan, taga. Ne ka jamana min yira i ra, i ye taga ni nin mɔgɔw ye o jamana ra; ne ta mɛlɛkɛ bɛna kɛ ni i ye. Nka ni ne ta hakɛbɔlon sera, ne bɛna ne hakɛ bɔ o ra o ta kojuguw kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ayiwa, Matigi Ala nana a hakɛ bɔ Izirayɛlimɔgɔw ra o misiden kosɔn, o tun ko Haruna ye o misiden min lalaga o ye. ");
INSERT INTO dyu_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Matigi Ala kumana Musa fɛ, ko: «I ka Izirayɛlimɔgɔ minw labɔ Misiran jamana ra, i ni o mɔgɔw ye wuri ka bɔ yan. Ne karira Iburahima ni Isiyaka ni Yakuba ye ko ne bɛna jamana min di o ta duruja ma, aw ye taga o jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ne bɛna ne ta mɛlɛkɛ bla aw ɲa, ka taga Kanaanakaw ni Amɔrikaw ni Hɛtikaw ni Perezikaw ni Hevikaw ni Yebusikaw gbɛn ka bɔ o jamana ra. ");
INSERT INTO dyu_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Aw ye wuri ka taga o jamana ra, nɔnɔ ni li bɛ woyo o jamana min na. Nka ne yɛrɛ le tɛna kɛ ni aw ye, ni o tɛ, ne bɛna aw halaki sira ra; sabu aw ye mɔgɔ torokungbɛlɛnw le ye.» ");
INSERT INTO dyu_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ayiwa, jama ka o kumagbɛlɛnw mɛn minkɛ, o jusu kasira. Mɔgɔ si ma sɔn ka masirifɛn don a yɛrɛ ra; ");
INSERT INTO dyu_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","sabu Matigi Ala tun k’a fɔ Musa ye ko a ye a fɔ Izirayɛlimɔgɔw ye ko: «Aw bɛɛ ye mɔgɔ torokungbɛlɛnw le ye. Ni ne ka kɛ ni aw ye ka hali wagati dɔɔnin dɔrɔn kɛ, ne bɛna aw halaki le. O ra aw ye aw ta masirifɛnw bɛɛ bɔ aw yɛrɛ ra; o kɔ, ne bɛna min kɛ aw ra, ne bɛna o lɔn.» ");
INSERT INTO dyu_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Izirayɛlimɔgɔw ka o yɛrɛ mabɔ Horɛbu kuru ra; o ka o ta masirifɛnw bɛɛ bɔ o yɛrɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ayiwa, Musa ka fanibon dɔ ta ka taga a lɔ kɛnɛ ma, k’a yɔrɔ janya fanibon tɔw ra. A ka o fanibon tɔgɔ la ko Ɲɔgɔnkunbɛn fanibon*. Ni mɔgɔ o mɔgɔ tun b’a fɛ ka Matigi Ala sago lɔn ko dɔ ra, o tigi tun bɛ bɔ ka taga Ɲɔgɔnkunbɛn fanibon yɔrɔ le ra, dugu kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ni Musa tun bɛ tagara o fanibon kɔnɔ tuma o tuma, mɔgɔw bɛɛ tun bɛ bɔ ka lɔlɔ o ta fanibonw dondaw ra, ka Musa tagatɔ flɛ, fɔ ka taga a don fanibon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ni Musa tun ka don o fanibon kɔnɔ, sankaba jamijan tun bɛ jigi ka na lɔ fanibon da ra; Matigi Ala tun bɛ kuma Musa fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ni Izirayɛlimɔgɔw tun ka sankaba jamijan lɔnin ye fanibon da ra, o bɛɛ tun wurira ka lɔ o ta fanibonw dondaw ra, ka biri dugu ma ka Ala bato. ");
INSERT INTO dyu_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Matigi Ala tun bɛ kuma ni Musa ye da ni da, i n’a fɔ mɔgɔ ni a teri bɛ kuma cogo min na. O kɔ, Musa tun bɛ kɔsegi ka taga jama fɛ. Nka a ta baaraden kanbelen Yosuwe, Nuni dencɛ, ale tun bɛ to o Ɲɔgɔnkunbɛn fanibon kɔnɔ yi. ");
INSERT INTO dyu_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ayiwa, Musa k’a fɔ Matigi Ala ye ko: «Matigi Ala, i ko ne ma ko ne ye taga ni nin mɔgɔw ye, nka min bɛna ne blasira, ka ne dɛmɛ, i ma o tigi yira ne ra; k’a sɔrɔ i ko ne ye i tericɛsɔbɛ le ye, ko ne ko ka di i ye. ");
INSERT INTO dyu_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ayiwa, ni ne ko ka di i ye, i ka ko minw latigɛ, o yira ne ra, k’a to ne ye i lɔn; ni o kɛra, ne bɛna a lɔn can ra ko i bɛ ne kanu. Matigi Ala, i hakiri to a ra ko nin mɔgɔw ye i yɛrɛ ta mɔgɔw le ye.» ");
INSERT INTO dyu_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Matigi Ala ka Musa jaabi ko: «Ayiwa, ne yɛrɛ bɛna kɛ ni i ye, ka jususuma di i ma.» ");
INSERT INTO dyu_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa ko Ala ma ko: «Ni i yɛrɛ kɔni tɛna kɛ ni an ye, o tuma i kana a to an ye bɔ yan. ");
INSERT INTO dyu_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Can ra ni ele tɛna kɛ ni an ye, k’a yira ko an ni dugukolo siya tɔw tɛ kelen ye, o tuma ne ni i ta mɔgɔw bɛna a lɔn cogo di ko an ko ka di i ye?» ");
INSERT INTO dyu_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ayiwa, Matigi Ala ko Musa ma ko: «I ka min daari ne fɛ ne bɛna o kɛ i ye, sabu ne nɛɛmara i ye, i ye ne teri sɔbɛ le ye fana.» ");
INSERT INTO dyu_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa ko Ala ma ko: «Ne bɛ i daari, ko i ye i ta nɔɔrɔ yira ne ra.» ");
INSERT INTO dyu_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ala ko: «Ne bɛna tɛmɛ i ɲa fɛ, ka ne ta ɲumanya yira i ra, ani ka ne tɔgɔ fɔ i ye, i ye a mɛn; ko: ne ye Matigi Ala le ye; ni ne b’a fɛ ka makari mɔgɔ min na, ne bɛ makari o tigi ra. Ni ne ko ne bɛ hina min na, ne bɛ hina o tigi ra fana. ");
INSERT INTO dyu_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Nka, i tɛ se ka ne ɲada ye; sabu mɔgɔ si tɛ se ka ne ɲada ye, k’a ɲanamanya tuun.» ");
INSERT INTO dyu_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Matigi Ala ko tuun ko: «Yɔrɔ dɔ flɛ ne kɛrɛ fɛ yan. I bɛna lɔ farakuru dɔ kan o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ni ne ta nɔɔrɔ bɛ tɛmɛ tuma min na, ne bɛna i dogo farawo dɔ ra; ne bɛna ne boro kɛ ka i datugu, fɔ ne ye tɛmɛ ka taga. ");
INSERT INTO dyu_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","O kɔ, ne bɛna ne boro bɔ i kan; ne tɛmɛnin kɔ le, i bɛna ne kɔ ye. Nka ne ɲada tɛ se ka ye.» ");
INSERT INTO dyu_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Matigi Ala k’a fɔ Musa ye tuun ko: «Walaka fla wɛrɛ lɛsɛ, k’a kɛ i n’a fɔ i tun ka minw cici. Ne tun ka kuma minw sɛbɛ o walaka fɔlɔw kan, ne bɛna o ɲɔgɔn sɛbɛ o walakakuraw fana kan. ");
INSERT INTO dyu_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","I ye i yɛrɛ labɛn sani dugu ye gbɛ. Sɔgɔmada joona, i ye yɛlɛn ka na lɔ Sinayi kuru kuncɛ ma, ka ne kɔnɔ yi. ");
INSERT INTO dyu_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mɔgɔ si kana yɛlɛn ni i ye. Mɔgɔ si kana ye kuru fan si ra fana, hali sagaw ni misiw kana domuni kɛ kuru kɛrɛ fɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musa ka kabakuru walaka fla lɛsɛ i n’a fɔ fɔlɔtaw. Sɔgɔmada joona fɛ, a wurira ka yɛlɛn Sinayi kuru kunna ni walaka fla ye a boro, i n’a fɔ Matigi Ala tun k’a fɔ a ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Matigi Ala jigira sankaba ra ka na lɔ Musa kɔrɔ, k’a yɛrɛ tɔgɔ fɔ. ");
INSERT INTO dyu_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","A tɛmɛna Musa ɲa kɔrɔ k’a fɔ ni fanga ye ko: «Ne le ye Matigi Ala ye, ne le ye Matigi Ala ye, hina tigi Ala, ani Ala min bɛ makari. Ne tɛ dimi joona, ne ta ɲumanya ni ne ta kankelentigiya ka bon. ");
INSERT INTO dyu_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ne bɛ koɲuman kɛ mɔgɔw ye, k’a kɛ o ta denw ye, ani o ta denw ta denw, fɔ ka taga se o ta duruja wagakelennan ma. Ne bɛ terenbariya ni hakɛ ni jurumun yafa mɔgɔw ma. Nka ne tɛ kojugukɛbaga jarakibari to. Ne bɛ faw ta hakɛw bɔ o denw na, k’a bɔ o ta denw ta denw na, fɔ ka taga se o ta duruja sabanan ni a naaninan ma.» ");
INSERT INTO dyu_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","O yɔrɔnin bɛɛ, Musa birira dugu ma ka Matigi Ala bato. ");
INSERT INTO dyu_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","A ko: «Matigi ni a kɛra ko ne ko ka di i ye, o tuma i ye sɔn ka kɛ ni anw ye. Sabu nin mɔgɔw ye mɔgɔ torokungbɛlɛnw le ye; nka ne bɛ i daari ko i ye an ta jurumunw ni an ta terenbariyaw yafa an ma, ka an jate i ta mɔgɔw ye.» ");
INSERT INTO dyu_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Matigi Ala k’a fɔ Musa ye ko: «Ayiwa, ne bɛna jɛnɲɔgɔnya don ni aw ye tuun. Ne bɛna kabakow kɛ i ta mɔgɔw bɛɛ ɲa na, kabako minw ma deri ka kɛ dugukolo yɔrɔ si ra fɔlɔ, ani min ma kɛ siya wɛrɛ cɛ ra ka ye. Mɔgɔ minw bɛɛ bɛ ni i ye, olugu bɛɛ bɛna ne ta kɛwalew ye, sabu ne bɛna se di i ma k’a to i ye ko minw kɛ, o bɛna kɛ siranyakobaw le ye. ");
INSERT INTO dyu_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ne bɛ ci minw fɔra aw ye bi, aw ye aw janto o ciw ra kosɛbɛ. Ni o kɛra, ne bɛna Amɔrikaw ni Kanaanakaw ni Hɛtikaw, ni Perezikaw, ni Hevikaw, ni Yebusikaw gbɛn ka bɔ aw ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Nka aw bɛna don jamana min kɔnɔ, aw ye aw yɛrɛ kɔrɔsi o mɔgɔw ra kosɛbɛ; aw kana jɛnɲɔgɔnya foyi don ni o jamana mɔgɔw ye, janko o kana na kɛ sababu ye ka aw lafiri. ");
INSERT INTO dyu_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Aw ye o ta sarakabɔnanw waraga; aw ye o ta kabakurujanw cici, ka o ta jo musoman Asera ta berew tigɛtigɛ. ");
INSERT INTO dyu_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","«Aw fana man kan ka biri batofɛn wɛrɛ kɔrɔ k’a bato, sabu ne tɔgɔ ye ko ‹Ala min t’a fɛ batofɛn wɛrɛ ye bato ale kɔ›; ne t’a fɛ aw ye ne ni batofɛn wɛrɛ kanu ɲɔgɔn fɛ fiyewu. ");
INSERT INTO dyu_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","O kosɔn aw kana jɛnɲɔgɔnya don ni o jamanaw mɔgɔw ye. Ni o tɛ, ni o bɛ o ta jow bato, ani ka o sɔn tuma min na, o bɛna aw wele, aw fana bɛna taga o sɔnnikɛfɛnw domu ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ni aw ka jɛnɲɔgɔnya don ni o ye fana, a laban aw bɛna o denmusow furu ka o di aw dencɛw ma. Ni o kɛra, ni o denmusow bɛ o ta jow bato, o bɛna aw dencɛw nɛgɛ k’a to olugu fana ye o jow bato. ");
INSERT INTO dyu_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Aw kana nɛgɛ yeele ka o kɛ batofɛn dɔ ye k’a bato. ");
INSERT INTO dyu_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Aw ka kan ka burufunubari ɲanagbɛ* kɛ. Ni Abibu karo sera, ka kaɲa ni wagati latigɛnin ye, i n’a fɔ ne k’a fɔ aw ye cogo min na, aw ka kan ka burufunubari le domu, sabu aw bɔra Misiran jamana ra o karo le ra. ");
INSERT INTO dyu_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Dencɛ fɔlɔ bɛɛ bɛna bla danna ka kɛ ne ta ye, hali bɛganw ta den fɔlɔ cɛmanw, ani misiw, ani sagaw, ani baw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Nka ni faliden lo, aw ye sagaden walama baden dɔ di a nɔ ra k’a kunmabɔ. Ni aw t’a fɛ k’a kunmabɔ, o tuma aw ye a kan kari k’a faga. Aw ka kan ka aw yɛrɛ dencɛ fɔlɔw bɛɛ kunmabɔ fana. «Mɔgɔ si kana na ne ɲa kɔrɔ fana, ka na ne bato, k’a sɔrɔ foyi tɛ a boro k’a di ne ma saraka ye. ");
INSERT INTO dyu_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Aw ka kan ka baara kɛ tere wɔɔrɔ, ka nɛnɛkiri a tere wolonflanan. Hali ni sɛnɛkɛwagati lo, walama simantigɛwagati, aw ka kan ka nɛnɛkiri. ");
INSERT INTO dyu_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Ni aw bɛ aw ta simankura kun fɔlɔw tigɛ tuma o tuma, aw ye lɔgɔkunw ta ɲanagbɛ kɛ. Ni san yɛlɛmana fana, ni aw bɛ aw ta forow yiridenw ladon tuma min na, aw ye simanladon ɲanagbɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","«O cogo ra, san o san, cɛw bɛɛ ka kan ka na siɲaga saba ne ɲa kɔrɔ, o ɲanagbɛw ra, ne Matigi Ala, Izirayɛli ta Ala. ");
INSERT INTO dyu_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","«Ne bɛna siya tɔw gbɛn ka bɔ aw ɲa, ka dɔ fara aw ta jamana bonya kan. Hali ni aw bɛ taga ne ta yɔrɔ saninman na, ka taga Matigi Ala, aw ta Ala bato siɲaga saba san o san, ne tɛna sɔn k’a to siya si ye ɲabɔ aw ta jamana fɛ k’a ta aw kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Ni aw b’a fɛ ka bɛgan saraka bɔ ne ye, aw kana o jori ni burufununin kori ɲɔgɔn na. Jɔnyaban ɲanagbɛ* ta sarakasogo fana man kan ka bla k’a si. ");
INSERT INTO dyu_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«Aw ka kan ka na ni aw ta simankura kun fɔlɔw ye Matigi Ala, aw ta Ala ta batoso kɔnɔ. Aw kana badennin tobi ni a ba ta nɔnɔ ye.» ");
INSERT INTO dyu_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ayiwa, Matigi Ala k’a fɔ Musa ye tuun ko: «Nin kumaw sɛbɛ, sabu ne bɛ jɛnɲɔgɔnya don ni ele ni Izirayɛlimɔgɔw bɛɛ ye ka kaɲa ni nin kumaw le ye.» ");
INSERT INTO dyu_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa ka tere binaani ni su binaani le kɛ ni Matigi Ala ye. A ma domuni kɛ, a ma ji min. Matigi Ala ka jɛnɲɔgɔnya ta sariyaw sɛbɛ walakaw kan, sariya tan, k’a di a ma. ");
INSERT INTO dyu_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa jigitɔ ka bɔ Sinayi kuru kan, jɛnɲɔgɔnya ta sariyaw tun sɛbɛra walaka fla min kan, a jigira ni o ye a boro. Nka Musa tun m’a lɔn ko ale ɲada tun bɛ manamanana sabu ale kumana ni Ala ye. ");
INSERT INTO dyu_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haruna ni Izirayɛlimɔgɔw bɛɛ ka Musa ɲada flɛ; o k’a ye ko a ɲada bɛ manamanana. O siranna, o ma sɔn ka gbara a ra. ");
INSERT INTO dyu_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Musa ka o wele; Haruna ni jama ɲamɔgɔw bɛɛ nana Musa kɔrɔ. Musa kumana o fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","O kɔ, Izirayɛlimɔgɔ tɔw bɛɛ gbarara Musa ra. Matigi Ala tun ka ci minw fɔ a ye Sinayi kuru kan, a ka o bɛɛ lase o ma. ");
INSERT INTO dyu_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa kumana o fɛ ka ban tuma min na, a ka fani dɔ biri a ɲada ra, a ɲada manamanako kosɔn. ");
INSERT INTO dyu_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","K’a ta o wagati ra, ni Musa tun bɛ taga Matigi Ala fɛ tuma o tuma ka taga kuma ni a ye, a tun bɛ fani bɔ a ɲada ra, fɔ ka taga a bɔ o yɔrɔ ra. Ni a bɔra yi, ni Matigi Ala tun ka min fɔ a ye, a tun bɛ o fɔ Izirayɛlimɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ni Izirayɛlimɔgɔw tun ka Musa ɲada flɛ, o tun bɛ a ɲada manamanatɔ ye; o tuma Musa tun bɛ fani biri a ɲada ra tuun. Ni a bɛ taga kuma ni Ala ye, a bɛ fani bɔ a ɲada ra. ");
INSERT INTO dyu_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa ka Izirayɛlimɔgɔw bɛɛ wele ka o lajɛn k’a fɔ o ye ko: «Matigi Ala ka ci minw fɔ, o le ye nin ye: ");
INSERT INTO dyu_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","‹Aw ka kan ka baara kɛ tere wɔɔrɔ, nka a tere wolonflanan ka kan ka kɛ lon saninman le ye, ka kɛ Nɛnɛkirilon ye; o lon blara danna ka Matigi Ala bonya; ni mɔgɔ o mɔgɔ ka baara kɛ o lon na, o tigi ka kan ka faga. ");
INSERT INTO dyu_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Aw kana hali tasuma mana aw ta sow si kɔnɔ o lon na.› » ");
INSERT INTO dyu_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ayiwa, Musa kumana Izirayɛlimɔgɔw bɛɛ lajɛnnin fɛ tuun k’a fɔ o ye ko: «Matigi Ala k’a fɔ fana, ");
INSERT INTO dyu_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ko aw bɛɛ ye dɔ bɔ aw borofɛnw na ka o di ale Matigi Ala ma. Mɔgɔ o mɔgɔ bɛ sɔn k’a di ni ŋaninyaɲuman ye, o tigi ye na ni a borofɛnw ye Matigi Ala fɛ. Aw bɛ se ka fɛn minw di, o ye nin ye: sanin, ani warigbɛ, ani siranɛgɛ, ");
INSERT INTO dyu_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ani sagasijese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛnfani fiyɛnman, ani basiw, ");
INSERT INTO dyu_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ani sagajigi gbolo min logira k’a wulen, ani gbolojalan, ani akasiyayiri, ");
INSERT INTO dyu_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ani fitinaturu, ani kasadiyanan minw bɛ kɛ ka turu saninman* ni wusunan lalaga, ");
INSERT INTO dyu_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ani onikisi lulu, ani lulu wɛrɛ minw bɛna kɛ ka saninderege ni disirafɛn masiri.» ");
INSERT INTO dyu_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Musa ko: «Minw bɛɛ bɛ se bororabaara ra fana, olugu ye na Matigi Ala ta baara kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","O bɛna fanibon saninman lɔ, ani fani min bɛna kɛ k’a datugu, ani gbolo minw bɛna biri a kunna, ani a nɛgɛ koorininw, ani a yirifɛrɛnw, ani a berew, ani a yiriw, ani a yiriw jusiginanw, ");
INSERT INTO dyu_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ani jɛnɲɔgɔnya kɛsu* ni a berew, ani a datugunan, ani boncɛtigɛfani min bɛ fanibon cɛtigɛ fla ye, ");
INSERT INTO dyu_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ani tabali ni bere minw bɛ kɛ k’a ta, ani a minanw bɛɛ, ani sarakaburu minw bɛ bla tabali kan, ");
INSERT INTO dyu_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ani fitinablanan ni a minanw, ni a fitinadagaw, ani a fitinaturu, ");
INSERT INTO dyu_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ani wusunanjɛnifɛn ni bere minw bɛ kɛ k’a ta, ani turu saninman*, ani wusunan kasadiman, ani fani min bɛna siri fanibon donda ra, ");
INSERT INTO dyu_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ani sarakajɛnifɛn ni a ta nɛgɛsansan, ani bere minw bɛ kɛ k’a ta, ani a minanw bɛɛ, ani minanba ni a siginan, ");
INSERT INTO dyu_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ani lu laminifani, ani a yiriw, ani a jusiginanw, ani fani min bɛ siri lu donda ra ");
INSERT INTO dyu_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ani fanibon ta nɛgɛberew, ani lu laminifaniw ta nɛgɛberew, ani a juruw, ani sarakalasebagaw bɛna fani saninman minw don ka sarakalasebagaya kɛ Ala ta yɔrɔ saninman* na; ");
INSERT INTO dyu_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","o ye sarakalasebaga Haruna ta fani saninmanw, ani a dencɛw ta sarakalasebagaya fani saninmanw ye.» ");
INSERT INTO dyu_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ayiwa, o kuma fɔnin kɔ, Izirayɛlimɔgɔw bɛɛ bɔra Musa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","A ko donna minw bɛɛ jusu ra, ani ŋaninyaɲuman tun bɛ minw kɔnɔ, olugu bɛɛ nana ni o borofɛnw ye, ka na o di Matigi Ala ma, Ɲɔgɔnkunbɛn fanibon* ni a minanw bɛɛ ta baara kama, ani sarakalasebagaw ta faniw. ");
INSERT INTO dyu_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Cɛ fara muso kan, o bɛɛ nana ni o borofɛnw ye; ŋaninyaɲuman tun bɛ min o min na, o bɛɛ nana ni o ta saninw ye: tororanɛgɛw, nunnanɛgɛw, borokandennɛgɛw, bororanɛgɛw, ani sanin suguya bɛɛ. Min o min tun b’a fɛ ka sanin di Matigi Ala ma, o ka o di. ");
INSERT INTO dyu_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Jese bulaman tun bɛ minw fɛ, ani a wulenman bisigi, ani a wulenman yɛrɛ, walama lɛn jese, walama basiw, walama sagajigi gbolo wulennin, walama gbolojalan, olugu bɛɛ nana ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Min o min tun b’a fɛ ka warigbɛ walama siranɛgɛ di Matigi Ala ma, olugu bɛɛ nana ni o ye ka na o di Ala ma. Akasiyayiri tun bɛ minw fɛ, ni a tun bɛ se ka Ala ta yɔrɔ saninman ta baara ɲa, olugu nana ni o ye fana. ");
INSERT INTO dyu_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Muso minw tun bɛ se jesemunu na, olugu ka jese munu ka na ni o ye: jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. ");
INSERT INTO dyu_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Nin baara ko diyara muso minw bɛɛ ye, ni o bɛ se baara ra kosɛbɛ, olugu ka basiw munu k’a kɛ jese ye, ka na o di. ");
INSERT INTO dyu_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Izirayɛlimɔgɔw ta ɲamɔgɔw nana ni onikisi luluw ye, ani lulu suguya wɛrɛw, minw bɛna don saninderege ni disirafɛn na; ");
INSERT INTO dyu_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","o nana ni kasadiyananw ye, ani turu min bɛ don fitinaw na, ani min bɛ kɛ ka sarakalasebagaw saninya, ani min bɛ don wusunan kasadiman na. ");
INSERT INTO dyu_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ayiwa, Matigi Ala tun ka o baara min yira Musa ra, o baara ko tun bɛ Izirayɛlimɔgɔ minw bɛɛ jusu ra, cɛ fara muso kan, olugu bɛɛ nana ni o borofɛnw ye o yɛrɛ ma ka na o di Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa k’a fɔ Izirayɛlimɔgɔw ye ko: «Matigi Ala ka Uri dencɛ Bɛtisalɛli le ɲanawoloma nin baara kama; Zuda ta gbamɔgɔ dɔ lo. A facɛ Uri ta facɛ le tun ye Huru ye. ");
INSERT INTO dyu_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ala ka Bɛtisalɛli hakiri fa a ta Nin Saninman na, ka hakiritigiya ni faamuri ni lɔnniya di a ma, janko a ye baara suguya bɛɛ kɛcogo lɔn. ");
INSERT INTO dyu_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ala ka hakiri di a ma, janko a ye se ka baara dɔw miiri a yɛrɛ hakiri ra ka o kɛ, ka sanin ni warigbɛ ni siranɛgɛ baara, ");
INSERT INTO dyu_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ka lulu kisɛw ɲɛgɛn, ka o don sanin na, ka yiri lɛsɛ, ani ka bororabaara suguya bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ala ka hakiri di a ma fana, janko a ye se ka dɔw karan o baaraw ra, ale ni Ayisamaki dencɛ Oliyabu; ale ye Dan ta gbamɔgɔ dɔ le ye. ");
INSERT INTO dyu_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ala ka lɔnniyaba di o ma; o ka yirilɛsɛ ni bororabaara lɔn; o bɛ se ka fani bulamanw, ani a wulenman bisigiw, ani a wulenmanw yɛrɛ, ani lɛnfaniw sɔgɔ, ka o dan, ka baara suguya bɛɛ kɛ, ani ka baara dɔw miiri o yɛrɛ hakiri ra ka o kɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Ayiwa, Bɛtisalɛli, ani Oliyabu, ani minw bɛɛ tun bɛ se baara ra, Matigi Ala tun ka hakiritigiya ni lɔnniya di olugu minw ma, janko o ye se ka baara suguya bɛɛ kɛ, olugu le ka fanibon ta baaraw bɛɛ kɛ i n’a fɔ Matigi Ala tun k’a fɔ cogo min na.» ");
INSERT INTO dyu_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa ka Bɛtisalɛli ni Oliyabu wele ka o baara di o ma, ani minw bɛɛ bɛ se baara ra, Matigi Ala tun ka lɔnniya don minw hakiri ra, ani minw bɛɛ tun labɛnnin bɛ, ka o sɔbɛ don baara ra k’a kɛ ka ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Izirayɛlimɔgɔw tun nana fɛn minw di fanibon ta baara kama, o nana o fɛnw cɛ Musa kɔrɔ ka taga baara damina. Nka sɔgɔma o sɔgɔma, mɔgɔw belen tun bɛ na ni o borofɛn dɔw ye tuun ka na o di Musa ma. ");
INSERT INTO dyu_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","A nana kɛ fɔ o baarakɛbagaɲuman minw tun bɛ fanibon baaraw kɛra, olugu ka o ta baara lalɔ, ");
INSERT INTO dyu_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ka taga a fɔ Musa ye ko: «An mako bɛ fɛn minw na ka Matigi Ala ta baara kɛ, mɔgɔw ta fɛn dita cayara ka tɛmɛ o kan.» ");
INSERT INTO dyu_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","A kɛra ten, Musa k’a fɔ mɔgɔw bɛɛ ye, cɛ fara muso kan, ko mɔgɔ si kana na ni fɛn ye tuun. O ka mɔgɔw lalɔ o cogo le ra, o ma na ni fɛn ye tuun; ");
INSERT INTO dyu_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","sabu fɛn minw tun sɔrɔra, o tun bɛ se ka baara ban, fɔ k’a tɔ to. ");
INSERT INTO dyu_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ayiwa, o mɔgɔ minw tun bɛ se baara ra, olugu ka fanibon lalaga damina; o ka fani gbiriman gbɛman tan lalaga ni lɛn jese fiyɛnman ye, ani jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ. O ka serubɛn mɛlɛkɛw ja kɛ a kan, k’a sɔgɔ ka ɲa kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Fani bɛɛ kelen kelen janya kɛra nɔngɔn ɲa mugan ni seegi ye, k’a bonya kɛ nɔngɔn ɲa naani ye. Faniw janya ni o bonya bɛɛ kɛra kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","O ka o faniw looru tugutugu ɲɔgɔn na, k’a kɛ fanimugu kelen ye, k’a tɔ looru fana tugutugu ɲɔgɔn na ka o kɛ fanimugu kelen ye fana. ");
INSERT INTO dyu_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","O ka juruden dɔw dan ni jese bulaman ye, ka o sirisiri o fanimugu fɔlɔ dagbolo ra; ka dɔw sirisiri fana fanimugu flanan dagbolo ra. ");
INSERT INTO dyu_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","O ka juruden bilooru don fanimugu fɔlɔ dagbolo ra, ka bilooru don fanimugu flanan fana dagbolo ra. O fanimugu fla ta jurudenw daw bɛnna ɲɔgɔn ma. ");
INSERT INTO dyu_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","O ka sanin koorinin bilooru lalaga, ka fanimugu fla mina ka o tugu ɲɔgɔn na ni o sanin koorininw ye. O cogo ra, fanibon bɛɛ kɛra fanimugu kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","O ka fani gbiriman tan ni kelen dan tuun ni basiw ye, ka o fana kɛ ka fanibon datugu. ");
INSERT INTO dyu_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","O fani gbirimanw bɛɛ kelen kelen janya kɛra nɔngɔn ɲa bisaba ye, a bonya kɛra nɔngɔn ɲa naani. O fani gbiriman tan ni kelen bɛɛ janya ni a bonya bɛɛ kɛra kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","O ka o fani gbirimanw looru tugutugu ɲɔgɔn na k’a kɛ fanimugu kelen ye, k’a tɔ wɔɔrɔ fana tugutugu ɲɔgɔn na, ka o kɛ fanimugu kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","O ka juruden bilooru siri fanimugu fɔlɔ dagbolo ra, ka bilooru siri fani mugu flanan fana dagbolo ra. ");
INSERT INTO dyu_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","O ka siranɛgɛ koorinin bilooru lalaga ka o kɛ ka fanimugu fla mina ka o siri ɲɔgɔn na, janko fanibon bɛɛ ye kɛ fanimugu kelen ye. ");
INSERT INTO dyu_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","O kɔ, o ka sagajigi gbolo dɔw wulen, min bɛna kɛ ka faniw datugu; o kɔ, o ka gbolo gbiriman janin dɔw lalaga, min bɛna biri a bɛɛ lajɛnnin kunna. ");
INSERT INTO dyu_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","O kɔ, o ka yirifɛrɛn dɔw lɛsɛ akasiyayiri ra, minw bɛna lɔlɔ ka fanibon mina. ");
INSERT INTO dyu_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","O yirifɛrɛn bɛɛ kelen kelen janya tun ye nɔngɔn ɲa tan ye; a bonya ye nɔngɔn ɲa kelen ni tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","O ka sen fla kɛ ɲɔgɔn kɔrɔ yirifɛrɛn bɛɛ kelen kelen na. Fanibon bɛna lɔ ni yirifɛrɛn minw ye, o ka o bɛɛ kɛ o cogo ra. ");
INSERT INTO dyu_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","O ka yirifɛrɛn mugan lɛsɛ ka o kɛ fanibon woroduguyanfan ta ye. ");
INSERT INTO dyu_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","O ka warigbɛ den binaani gbasi ka wow bɔ o ra, ka olugu kɛ o yirifɛrɛn mugan sendonyɔrɔ ye, ka o bla fla fla yirifɛrɛnw senw jukɔrɔ, ka yirifɛrɛnw senw dondon o wow ra dugu ma. ");
INSERT INTO dyu_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","O ka yirifɛrɛn mugan lɛsɛ ka o kɛ fanibon sahiliyanfan ta ye. ");
INSERT INTO dyu_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","O ka warigbɛ den binaani gbasi, ka wow bɔ o ra fana, ka o kɛ sendonyɔrɔw ye, ka o bla fla fla ka yirifɛrɛnw senw dondon o wow ra dugu ma. ");
INSERT INTO dyu_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","O ka yirifɛrɛn wɔɔrɔ lɛsɛ, ka o kɛ fanibon kɔnɔnɔyɔrɔ ta ye, a terebenyanfan na. ");
INSERT INTO dyu_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","O ka yirifɛrɛn dɔw lɛsɛ, ka na olugu lɔ fla fla fanibon nɔngɔnw na, a kɔnɔnɔyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","O ka o yirifɛrɛn fla nɔrɔ ɲɔgɔn na, k’a ta dugu ma fɔ san fɛ, k’a fla mina ɲɔgɔn na a sanfɛyɔrɔ ra ni nɛgɛ koorinin dɔ ye. Fanibon nɔngɔn fla bɛɛ ta yiriw kɛra ten le. ");
INSERT INTO dyu_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","O cogo ra, fanibon nɔngɔn naani ta yiriw bɛɛ lajɛnnin kɛra yirifɛrɛn seegi, ani o sendonyɔrɔ warigbɛramanw. A bɛɛ kɛra sendonyɔrɔ tan ni wɔɔrɔ, ka fla don yirifɛrɛn bɛɛ kelen kelen kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","O ka akasiyabere looru lɛsɛ, ka o bananbiri fanibon fan kelen ta yirifɛrɛnw kan, ka yirifɛrɛnw mina ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","O ka bere looru wɛrɛ lɛsɛ, ka o bananbiri fanibon fan dɔ ta yirifɛrɛnw kan, ka o mina ni o ye fana, ka looru wɛrɛ lɛsɛ tuun, ka o bananbiri fanibon kɔnɔnɔyɔrɔ ta yirifɛrɛnw kan, a terebenyanfan na, ka o yirifɛrɛnw mina ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","O ka cɛmancɛbere tɛmɛ yirifɛrɛnw cɛmancɛ ra, ka ta fanibon kun dɔ ra ka taga a bla a kun dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","O ka sanin la yirifɛrɛnw bɛɛ kan. Berew bɛ don nɛgɛ koorinin minw na ka yirifɛrɛnw mina, o ka olugu fana kɛ ni sanin ye. O ka sanin la berew fana kan. ");
INSERT INTO dyu_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Fani min bɛ kɛ ka bon cɛtigɛ, o ka o dan ni jese bulaman ye, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. O ka o fani sɔgɔ ka ɲa, ka serubɛn mɛlɛkɛw ja bisigiya kɛ a kan. ");
INSERT INTO dyu_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","O ka akasiyayiri naani lɛsɛ, ka sanin yeele k’a bɔn o bɛɛ kan. O ka nɛgɛ koorinin dɔw kɛ ni sanin ye ka o don o yiriw ra. O ka sendonyɔrɔ naani kɛ ni warigbɛ ye, ka o berew sigi o kan. ");
INSERT INTO dyu_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Fani min bɛ siri fanibon da ra, o ka o dan ni jese bulaman ye, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. O ka o fani sɔgɔ ka ɲa kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","O ka yiri looru fana lɛsɛ ka o fani mina, ka sanin la o yiriw ni o datugunanw bɛɛ kan, ani a nɛgɛ koorininw, ani a fani dulonnanw. O yiriw sendonyɔrɔ looru kɛra ni siranɛgɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bɛtisalɛli ka kɛsu dɔ lalaga ni akasiyayiri ye. A janya kɛra nɔngɔn ɲa fla ni tarancɛ, a bonya kɛra nɔngɔn ɲa kelen ni tarancɛ, a lɔ fana kɛra nɔngɔn ɲa kelen ni tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A ka sanin yɛrɛworo yeele k’a bɔn a yɔrɔ bɛɛ kan, a kɔkanyɔrɔ ni a kɔnɔnɔyɔrɔ bɛɛ; a ka sanin kɛ k’a konkonda lamini. ");
INSERT INTO dyu_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","A ka sanin gbasi, k’a koori, ka wo kɛ a ra; a ka o ɲɔgɔn naani lalaga, ka o dondon kɛsu fan naani na; ka fla don fan kelen na, ka tɔ fla don fan tɔ kelen na. ");
INSERT INTO dyu_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","A ka akasiyayiri dɔw lɛsɛ, ka o kɛ bere fla ye, ka sanin yeele k’a bɔn o berew yɔrɔ bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A ka o berew don sanin koorininw wow ra kɛsu fan fla ra, ka to ka kɛsu ta ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A ka kɛsu datugunan fana lalaga ni sanin yɛrɛworo ye. A janya kɛra nɔngɔn ɲa fla ni tarancɛ, a bonya kɛra nɔngɔn ɲa kelen ni tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","A ka ja fla lalaga ni sanin ye ka o kɛ i n’a fɔ serubɛn mɛlɛkɛw, ka o lɔlɔ kɛsu datugunan fan fla ra; ");
INSERT INTO dyu_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","a ka mɛlɛkɛ kelen lɔ a kun dɔ ra, ka tɔ kelen lɔ a kun tɔ kelen na. Mɛlɛkɛw lɔra kɛsu datugunan fan fla ra. ");
INSERT INTO dyu_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","O sanin serubɛn mɛlɛkɛw fla kamanw birira kɛsu datugunan kunna, ka kɛsu datugunan datugu ni o kamanw ye, ka o fla ɲaw sin ɲɔgɔn ma, ka o ɲa biri kɛsu datugunan kunna. ");
INSERT INTO dyu_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","A ka tabali dɔ fana lalaga ni akasiyayiri ye. A janya kɛra nɔngɔn ɲa fla ye, a bonya kɛra nɔngɔn ɲa kelen ye, a lɔ kɛra nɔngɔn ɲa kelen ni tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","A ka sanin yɛrɛworo yeele k’a bɔn o tabali yɔrɔ bɛɛ kan. Ka sanin kɛ k’a konkonda lamini. ");
INSERT INTO dyu_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","A k’a to tabali konkonda ye bonya dɔɔnin, k’a bonya kɛ i ko borokanden naani bonya, ka sanin kɛ k’a dagbolo lamini. ");
INSERT INTO dyu_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","A ka sanin gbasi, k’a koori, ka wo kɛ a ra; a ka o ɲɔgɔn naani lalaga, ka o dondon tabali nɔngɔn naani na, tabali senw kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","A ka o sanin koorininw dondon tabali senw sanfɛyɔrɔw ra, a nɔngɔn naani na. Berew bɛ don o wow le ra ka tabali ta. ");
INSERT INTO dyu_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","A ka o berew kɛ ni akasiyayiri le ye, ka sanin yeele k’a la o berew bɛɛ kan. O bɛna tabali ta ni o berew le ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","A ka minan dɔw lalaga fana minw bɛna bla tabali kan, i n’a fɔ tasaw, ani sɛtiw, ani bɛlɛnw, ani jifiyɛw, ka rɛzɛnji sarakaw kɛ ni o ye. A ka o bɛɛ lalaga ni sanin yɛrɛworo le ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","O kɔ, a ka fitinablanan dɔ lalaga ni sanin yɛrɛworo gbasinin ye. A ka sen kɛ a ra, ani a fitinaborow, ka fɛn dɔw kɛ a ra i ko yiriden bisigi, ka kuru kɛ o kɔrɔ, ka fɛn dɔw kɛ a ra fana i ko yirifiyeren bisigi. A ka o bɛɛ kɛ ni sanin kuturu kelen le ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","A ka fitinaboro wɔɔrɔ kɛ fitinablanan fan fla ra; a ka boro saba kɛ a fan kelen na, ka saba kɛ a fan dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","A ka yiriden bisigi saba kɛ a boro kelen kelen bɛɛ ra, k’a kɛ i ko amande yiridenw, ka kuruw kɛ a ra fana, ani yirifiyeren bisigi. Fitinaboro wɔɔrɔ bɛɛ ta kɛra ten. ");
INSERT INTO dyu_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","A ka yiriden bisigi saba kɛ a cɛmancɛ boro ra fana, ka o kɛ i ko amande yiriden, ka kuruw kɛ a ra, ani yirifiyeren bisigiw. ");
INSERT INTO dyu_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","A ka kuru dɔ kɛ cɛmancɛ boro ra fitinaboro fla jukɔrɔ, ka kuru dɔ kɛ fitinaboro fla wɛrɛ jukɔrɔ. Fitinaboro fla o fitinaboro fla, kuru kɛra o bɛɛ jukɔrɔ. O cogo ra, fitinaboro wɔɔrɔ bɛɛ, kuruw kɛra o bɛɛ jukɔrɔ fla fla. ");
INSERT INTO dyu_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","A k’a kuruw ni a borow ni a yɔrɔ tɔw bɛɛ kɛ ni sanin kuturu kelen le ye. A k’a bɛɛ kɛ ni sanin yɛrɛworo gbasinin ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","A ka fitinadaga wolonfla lalaga: a tasuma lalagananw, ani a buguri donminanw; a ka o bɛɛ kɛ ni sanin yɛrɛworo le ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","A ka fitinablanan ni a minanw bɛɛ lalaga ni sanin yɛrɛworo kilo bisaba le ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","A ka wusunanjɛnifɛn dɔ lalaga ni akasiyayiri ye. A janya kɛra nɔngɔn ɲa kelen, a bonya fana kɛra nɔngɔn ɲa kelen. A janya ni a bonya bɛɛ kɛra kelen ye. A lɔ kɛra nɔngɔn ɲa fla ye. A ka gbanw kɛ a nɔngɔn naani bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","O ka sanin yɛrɛworo yeele k’a bɔn a yɔrɔ bɛɛ kan; a sanfɛyɔrɔ, ni a kɛrɛfɛyɔrɔ, ni a gbanw bɛɛ. A k’a konkonda bɛɛ lamini ni sanin ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","A ka sanin koorinin fla gbasi ka o don a konkonda fla jukɔrɔ, a fan fla ra. A ka bere fla don o wow ra, janko k’a ta ni o berew ye. ");
INSERT INTO dyu_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A ka o berew lalaga ni akasiyayiri ye, ka sanin yeele k’a bɔn a yɔrɔ bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","A ka turu saninman* lalaga, turu min bɛ kɛ ka sarakalasebagaw saninya, ani ka wusunan kasadiman yɛrɛworo lalaga. A ka o kɛ ka kaɲa ni turu lalagabagaw ta turulalagacogo ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ayiwa, Bɛtisalɛli ka sarakajɛnifɛn* lalaga ni akasiyayiri ye. A k’a janya kɛ nɔngɔn ɲa looru ye, k’a bonya fana kɛ nɔngɔn ɲa looru ye. A fan naani bɛɛ janya kɛra kelen ye. A lɔ kɛra nɔngɔn ɲa saba ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A ka gban naani kɛ a nɔngɔn naani na, ka siranɛgɛ yeele k’a bɔn o gbanw bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","A ka sarakajɛnifɛn ta minanw bɛɛ lalaga: a buguri donminanw, ani a buguricɛnanw, ani a tasaw, ani a sogosɔgɔnanw, ani a takamidonnanw. A ka o minanw bɛɛ kɛ ni siranɛgɛ le ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","A ka nɛgɛ woman dɔ kɛ ni siranɛgɛ ye fana, k’a kɛ i n’a fɔ nɛgɛsansan, ka o don sarakajɛnifɛn kɔnɔ. A ka o la sarakajɛnifɛn konkonda jukɔrɔyɔrɔ kan, a kɔnɔnɔyɔrɔ ra, k’a se sarakajɛnifɛn lɔ cɛmancɛ ra. ");
INSERT INTO dyu_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","A ka siranɛgɛ koorinin naani kɛ ka o don sarakajɛnifɛn siranɛgɛ sansan nɔngɔn naani na, ka berew don o wow ra. ");
INSERT INTO dyu_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","A ka akasiyaberew tigɛ, ka o kɛ ka sarakajɛnifɛn ta. A ka siranɛgɛ la o berew bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","A ka o berew dondon siranɛgɛ koorininw wow ra, sarakajɛnifɛn fan fla ra, ka o berew kɛ ka sarakajɛnifɛn ta. A ka sarakajɛnifɛn lalaga ni yirifɛrɛnw le ye, k’a kɔnɔ lakolon to. ");
INSERT INTO dyu_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","A ka siranɛgɛtasa lalaga, ani a siginan; a ka o bɛɛ kɛ ni siranɛgɛ ye. Muso minw tun bɛ to ka ɲɔgɔn lajɛn fanibon ɲa fɛ ka baara dɔw kɛ Ala ye, olugu ka dugalen minw di, a ka o le kɛ ka minanba lalaga. ");
INSERT INTO dyu_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ayiwa, o kɔ, a ka lukɛnɛ laminifɛnw lalaga. A ka lukɛnɛ woroduguyanfan laminifani dan ni lɛn jese ye. O fan kelen janya kɛra nɔngɔn ɲa kɛmɛ ye, ");
INSERT INTO dyu_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","k’a berew kɛ mugan ye, ani sendonyɔrɔ siranɛgɛraman mugan, berew bɛ sigi minw kan. Nɛgɛ koorinin minw bɛ kɛ berew ra, ani fanidulonnanw, a ka olugu lalaga ni warigbɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","A sahiliyanfan fana ta fani janya kɛra nɔngɔn ɲa kɛmɛ ye, k’a berew kɛ mugan ye, ani sendonyɔrɔ siranɛgɛraman mugan, berew bɛ sigi minw kan. Nɛgɛ koorinin minw bɛ kɛ berew ra, ani fanidulonnanw, a ka olugu lalaga ni warigbɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","A terebenyanfan laminifani janya kɛra nɔngɔn ɲa bilooru ye, k’a berew kɛ tan ye, k’a berew sendonyɔrɔw fana kɛ tan ye. Nɛgɛ koorinin minw bɛ kɛ berew ra, ani fanidulonnanw, a ka olugu lalaga ni warigbɛ ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ayiwa, lukɛnɛ terebɔyanfan, min ye a donda fan ye, o fana janya kɛra nɔngɔn ɲa bilooru ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Lu donda kininboroyanfan faniw janya kɛra nɔngɔn ɲa tan ni looru, k’a berew kɛ saba ye, ka berew sendonyɔrɔw fana kɛ saba ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Lu donda numanboroyanfan, min ye da fan dɔ ye, o faniw janya kɛra nɔngɔn ɲa tan ni looru ye fana, k’a berew kɛ saba ye, ka berew sendonyɔrɔw fana kɛ saba ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Fanibon lukɛnɛ laminifaniw bɛɛ kɛra ni lɛnfani le ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Lukɛnɛ ta berew sendonyɔrɔw bɛɛ tun ye siranɛgɛ le ye. Nɛgɛ koorinin minw bɛ don berew ra, ani a fanidulonnanw, olugu kɛra warigbɛ ye. Warigbɛ le fana tun lara o berew datugunanw kan. Fanidulonnanw le tun bɛ lukɛnɛ ta berew bɛɛ ni ɲɔgɔn cɛ, ka berew tugu ɲɔgɔn na. ");
INSERT INTO dyu_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Fani min blara lu donda yɛrɛ ra, o ka o sɔgɔ ka ɲa kosɛbɛ ni jese bulaman ye, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. A janya tun ye nɔngɔn ɲa mugan ye. A lɔ ye nɔngɔn ɲa looru, i n’a fɔ lukɛnɛ ta faniw ta bonya. ");
INSERT INTO dyu_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","A ta bere naani ni o sendonyɔrɔ naani bɛɛ tun kɛra ni siranɛgɛ le ye. A nɛgɛ koorininw ni a fanidulonnanw tun warigbɛraman lo, ka warigbɛ la a berew sanfɛyɔrɔw kan fana. ");
INSERT INTO dyu_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Nɛgɛbere minw turura dugu ma ka fanibon mina, ani minw ka lukɛnɛ faniw mina, o bɛɛ tun ye siranɛgɛ le ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ayiwa, o ka fanibon ta minanw jate; Ala ta layiri tun bɛ o fanibon min kɔnɔ; Musa ko Levi ta mɔgɔw ye o minanw jate k’a hakɛya lɔn. Haruna dencɛ Itamari le kɛra o baara ɲamɔgɔ ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Huru dencɛ Uri, o dencɛ Bɛtisalɛli, min bɛ bɔ Zuda ta gba ra; ale le kɛra fanibon ta baara ɲamɔgɔ ye. Matigi Ala tun ka fɛn o fɛn fɔ Musa ye, a ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","A dɛmɛbaga kɛra Ayisamaki dencɛ Oliyabu ye; ale bɛ bɔ Dan ta gba le ra. Ale tun bɛ se ka fɛnw ɲɛgɛn, ani ka ko lɔn a yɛrɛ ma k’a kɛ, ani ka fani bulamanw, ani a wulenman bisigiw, ani a wulenmanw yɛrɛ, ani lɛnfaniw sɔgɔ; ale tun bɛ se o baara ra kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ayiwa, sanin min kɛra ka fanibon ta baara bɛɛ lajɛnnin kɛ, mɔgɔw ka min di Matigi Ala ma, o bɛɛ lajɛnnin kɛra sanin kilo kɛmɛ seegi ni biwolonfla ni wolonfla, ani garamu kɛmɛ saba, ka kaɲa ni yɔrɔ saninman* ta jate ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Izirayɛlimɔgɔ minw tun jatera, olugu ka warigbɛ min di, o bɛɛ lajɛnnin kɛra warigbɛ kilo waga saba ni kilo tan ni wolonfla ye, ani garamu kɛmɛ wolonfla ni garamu bilooru, ka kaɲa ni yɔrɔ saninman* ta jate ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Cɛ min o min jatera, k’a damina san mugan na, olugu bɛɛ kelen kelen tun ka kan ka warigbɛ garamu wɔɔrɔ le sara, ka kaɲa ni yɔrɔ saninman* ta jate ye. O cogo ra, cɛ waga kɛmɛ wɔɔrɔ ani cɛ waga saba ani cɛ kɛmɛ looru ni cɛ bilooru (603 550), olugu le tun jatera. ");
INSERT INTO dyu_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","O ka warigbɛ kilo waga saba le kɛ ka fanibon yiriw sendonyɔrɔw lalaga, ani boncɛtigɛfani ta yiriw sendonyɔrɔw; o kɛra sendonyɔrɔ kɛmɛ. Sendonyɔrɔ bɛɛ kelen kelen bɛnna warigbɛ kilo bisaba ma. ");
INSERT INTO dyu_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Warigbɛ kilo tan ni wolonfla ni garamu kɛmɛ wolonfla ni bilooru min tora, o ka nɛgɛ koorininw lalaga ni o ye, ani fanidulonnan minw donna berew ra, k’a tɔ la lukɛnɛ donda ta bere kunna. ");
INSERT INTO dyu_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Mɔgɔw ka siranɛgɛ min di Matigi Ala ma, o bɛɛ lajɛnnin kɛra kilo waga fla ni kilo kɛmɛ ni kilo mugan ni naani ye. ");
INSERT INTO dyu_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","O ka fanibon donda ta yiriw sendonyɔrɔw lalaga ni o ye, ani sarakajɛnifɛn*, ani a nɛgɛsansan min lara a kɔnɔ, ani sarakajɛnifɛn ta minan tɔw bɛɛ, ");
INSERT INTO dyu_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ani lukɛnɛ laminiberew ta sendonyɔrɔw, ani a donda ta berew sendonyɔrɔw, ani nɛgɛbere minw turura dugu ma ka fanibon mina, ani minw ka lukɛnɛ ta faniw mina. ");
INSERT INTO dyu_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Sarakalasebagaw bɛ fani minw don ka sarakalasebagaya baara kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ, o ka olugu lalaga ni fani bulamanw ye, ani a wulenman bisigiw, ani a wulenmanw yɛrɛ; o ka fani saninman dɔw lalaga Haruna ye, min bɛ a yira ko Haruna blara danna Ala ta baara kama, ani min bɛ a ni mɔgɔ tɔw bɔ ɲɔgɔn na, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","O ka saninderege lalaga ni sanin ye, ani jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. ");
INSERT INTO dyu_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","O ka sanin yeele k’a tigɛtigɛ k’a misɛnya k’a kɛ i ko jese; o ka o jese dondon fani bulamanw, ani a wulenman bisigiw, ani a wulenmanw yɛrɛ, ani lɛnfani dɔw ra ka o sɔgɔ ka ɲa. ");
INSERT INTO dyu_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","O ka fani dɔ la saninderege kamankun fla kan, k’a ɲafɛyɔrɔ ni a kɔfɛyɔrɔ tugu ɲɔgɔn na. ");
INSERT INTO dyu_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Cɛsirinan ni saninderege baaracogo kɛra kelen ye. O ka ale karan saninderege ra, k’a dan ni sanin ye, ani jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese; o k’a kɛ i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","O ka onikisi lulu dɔw ta, ka sanin dɔ gbasi ka o kɛ ka o lulu koori. O ka Izirayɛli ta gbaw tɔgɔw sɛbɛ o luluw kan, i n’a fɔ tagamasiyɛnfɛn bɛ sɛbɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","O ka o luluw don saninderege kamankun fla ra, ka o kɛ hakirijigifɛn ye Izirayɛli siya tan ni fla ko ra, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ayiwa, o kɔ, o ka disirafɛn lalaga; ale ni saninderege lalagacogo bɛɛ kɛra kelen ye. O k’a lalaga ka ɲa, k’a ɲɛgɛn ni sanin ye, ani jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ, ani lɛn jese. ");
INSERT INTO dyu_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","A fan naani bɛɛ janya kɛra kelen ye. O k’a kɛ fla, ka a fla kuru k’a la ɲɔgɔn kan. A janya kɛra sibiri ɲa kelen, k’a bonya fana kɛ sibiri ɲa kelen. ");
INSERT INTO dyu_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","O ka o luluw kɛ sira naani ye. A sira fɔlɔ kɛra sariduwani lulu ye, ani topazi lulu, ani emerodi lulu. ");
INSERT INTO dyu_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","A sira flanan kɛra sikaribuli lulu ye, ani safiri lulu, ani jaman. ");
INSERT INTO dyu_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","A sira sabanan kɛra opali lulu ye, ani agati lulu, ani emetisi lulu; ");
INSERT INTO dyu_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","a sira naaninan kɛra kirisoliti lulu ye, ani onikisi lulu, ani zasipe lulu. O ka o luluw bɛɛ donyɔrɔw lalaga ni sanin le ye. ");
INSERT INTO dyu_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","A bɛɛ lajɛnnin kɛra lulu den tan ni fla, ka kaɲa ni Izirayɛli ta gbaw tɔgɔw ye. Izirayɛlimɔgɔw ta gba tan ni fla bɛɛ kelen kelen tɔgɔ sɛbɛra ni nɛgɛ ye lulu kelen kelen kan, i n’a fɔ tagamasiyɛnfɛnw bɛ sɛbɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","O ka saninjuru fla lalaga ni sanin yɛrɛworo ye, ka o dan i n’a fɔ jurukisɛ bɛ dan cogo min na; o ka o siri disirafɛn na. ");
INSERT INTO dyu_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","O ka sanin dɔ gbasi, ka o kɛ lulu fla donyɔrɔ ye, ani nɛgɛ koorinin fla; o ka o nɛgɛ koorinin fla don disirafɛn kun fla ra, a sanfɛyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","O ka o saninjuru fla siri nɛgɛ koorininw wow ra, disirafɛn kun fla ra, a sanfɛyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","O kɔ, o ka saninjuru kun fla tɔ siri saninderege kamankunw na, luluw donyɔrɔ ra, ka disirafɛn bla ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","O kɔ, o ka sanin dɔ gbasi ka nɛgɛ koorinin fla wɛrɛ lalaga ka o siri disirafɛn kɔfɛyɔrɔ ra, a kun fla min bɛ a dugumayanfan na. ");
INSERT INTO dyu_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","O ka sanin dɔ gbasi tuun ka nɛgɛ koorinin fla wɛrɛ lalaga, ka o siri saninderege kamankun fla ra, lulu fla ɲafɛyɔrɔ jukɔrɔ, karansira kɛrɛ fɛ, saninderege san fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","O ka disirafɛn ta kooriw ni saninderege ta kooriw siri ɲɔgɔn na ni jese bulaman dɔ ye, janko disirafɛn lanin ye to cɛsirinan san fɛ, saninderege kan; a kana yɔgɔyɔgɔ ka bɔ saninderege kan, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ayiwa, Haruna bɛna saninderege don forokiyajan min kan, o ka o yɔrɔ bɛɛ dan ni jese bulaman le ye. ");
INSERT INTO dyu_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","O ka o forokiyajan kan bɔ, ka fani gbiriman dɔ karan a kan na k’a lamini, janko a kana faran. ");
INSERT INTO dyu_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","O ka forokiyajan senkɔrɔyɔrɔ bɛɛ masiri ni gerenadi yiriden bisigi dɔw ye. O ka o kɛ ni jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ ye, ani lɛn jese. ");
INSERT INTO dyu_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","O ka tanan dennin dɔw lalaga ka o dondon o yiriden bisigiw cɛ ma, ka forokiyajan senkɔrɔyɔrɔ bɛɛ lamini ni o ye. ");
INSERT INTO dyu_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ni o ka tanan dennin kelen don, o bɛ gerenadi yiriden kelen gban o ra; ni o ka tanan dennin kelen don, o bɛ gerenadi yiriden kelen gban o ra, fɔ ka taga Haruna ta sarakalasebagaya forokiyajan senkɔrɔyɔrɔ bɛɛ lamini, i n’a fɔ Matigi k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","O ka Haruna ni a dencɛw ta forokiyasurunw fana lalaga ni lɛnfani ye; ");
INSERT INTO dyu_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","o ka Haruna ta jalamugu fugula lalaga ni lɛnfani ye, ani a dencɛw ta banflaw, o bɛ min don ka o yɛrɛ masiri. O ka kurusiw fana lalaga o ye ni lɛnfani ye, ");
INSERT INTO dyu_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ka cɛsirinan fana dan ni lɛn jese ye, ka olugu sɔgɔ ni jese bulaman, ani a wulenman bisigi, ani a wulenman yɛrɛ ye, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","O ka sanin yɛrɛworo dɔ gbasi ka o kɛ i n’a fɔ yirifiyeren bisigi ka o kɛ masirifɛn saninman ye; o ka sɛbɛri dɔ kɛ o kan ni nɛgɛ ye, i n’a fɔ o bɛ tagamasiyɛnfɛn sɛbɛ cogo min na. O k’a sɛbɛ a kan ko: A SANINYARA KA KƐ MATIGI ALA TA YE. ");
INSERT INTO dyu_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","O ka o sanin masirifɛn siri jalamugu fugula ɲa fɛ, ni jese bulaman dɔ ye, Haruna ten na, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","O cogo le ra, Ɲɔgɔnkunbɛn fanibon baara bɛɛ banna. Matigi Ala tun k’a fɔ Musa ye cogo min na cɔ, Izirayɛlimɔgɔw k’a kɛ ten le. ");
INSERT INTO dyu_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","O kɔ, o ka fanibon minanw bɛɛ cɛ ka taga ni a ye Musa fɛ: a nɛgɛ koorininw, a yirifɛrɛnw, a berew, a yiriw, a sendonyɔrɔw, ");
INSERT INTO dyu_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","a sagajigigbolo wulenman minw bɛ biri fanibon kunna, ani gbolo gbiriman janin minw bɛ kɛ k’a datugu, a bon cɛtigɛfaniw, ");
INSERT INTO dyu_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","a jɛnɲɔgɔnya tagamasiyɛn kɛsu*, ani a berew, ani kɛsu datugunan, ");
INSERT INTO dyu_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ani burutabali ni a minanw, ani sarakaburuw, ");
INSERT INTO dyu_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ani fitinablanan saninlaman min kɛra ni sanin yɛrɛworo ye, ani a fitinadagaw ni a minanw bɛɛ, ani fitinaturu, ");
INSERT INTO dyu_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ani sarakabɔnan saninlaman, ani turu saninman*, ani wusunan kasadiman, ani fani min bɛ siri fanibon da ra, ");
INSERT INTO dyu_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ani siranɛgɛ sarakajɛnifɛn, ani a ta siranɛgɛ sansan, ni a ta berew, ani a ta minanw bɛɛ, ani minanba ni a siginan, ");
INSERT INTO dyu_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ani lu laminifaniw, ani a berew ni o sendonyɔrɔw, ani a minanw bɛɛ, ani fani min bɛ kɛ ka luda datugu, ani jurukisɛw, ani nɛgɛberew, ani fanibon minan tɔw bɛɛ, ");
INSERT INTO dyu_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ani sarakalasebagaw ta baarakɛfaniw, ani sarakalasebaga Haruna ta fani saninmanw, ani a dencɛw ta sarakalasebagaya faniw. ");
INSERT INTO dyu_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ayiwa, Izirayɛlimɔgɔw ka o baara bɛɛ kɛ a cogo ra i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa ka baara flɛ kosɛbɛ. A k’a ye ko Matigi Ala tun ka min fɔ ale ye, ko o k’a kɛ o cogo le ra. Musa ka dugawu kɛ o ye. ");
INSERT INTO dyu_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Matigi Ala k’a fɔ Musa ye ko: ");
INSERT INTO dyu_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«San karo fɔlɔ tere fɔlɔ, aw ye Ɲɔgɔnkunbɛn fanibon* lɔ. ");
INSERT INTO dyu_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Aw ye jɛnɲɔgɔnya kɛsu* bla a kɔnɔ, ka boncɛtigɛfani siri, janko mɔgɔ kana kɛsu ye. ");
INSERT INTO dyu_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","«Aw ye tabali bla a kɔnɔ, k’a labɛn ka ɲa, ka sarakaburuw blabla a kan. Aw ye fitinablanan fana bla a kɔnɔ, k’a fitinadagaw sigisigi a kunna. ");
INSERT INTO dyu_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","«Wusunan bɛ jɛni sarakabɔnan saninlaman min kan, aw ye o bla jɛnɲɔgɔnya tagamasiyɛn kɛsu ɲa fɛ. Fani min bɛ siri fanibon da ra, aw ye o fana siri. ");
INSERT INTO dyu_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«Aw ye sarakajɛnifɛn* sigi Ɲɔgɔnkunbɛn fanibon donda kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","«Aw ye minanba sigi sarakajɛnifɛn ni fanibon yɛrɛ furancɛ ra, ka ji kɛ a ra. ");
INSERT INTO dyu_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","«Aw ye lu laminifaniw kɛ ka lu lamini; fani min bɛ siri lu donda ra, aw ye o fana siri. ");
INSERT INTO dyu_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Aw ye turu saninman* dɔ seriseri Ɲɔgɔnkunbɛn fanibon kan, ani a kɔnɔnɔminanw bɛɛ; k’a minanw bɛɛ saninya ka o bla Ala ta baara kama. Ni o kɛra, o fɛnw bɛɛ bɛ kɛ fɛn saninyanin ye. ");
INSERT INTO dyu_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","«Aw ye turu saninman* dɔ fana seriseri sarakajɛnifɛn ni a minanw kan, k’a saninya k’a bla Ala ta baara kama. Ni o kɛra, sarakajɛnifɛn bɛ saninya kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","«Aw ye turu saninman* dɔ seriseri minanba fana kan, ani a siginan, k’a saninya k’a bla Ala ta baara kama.» ");
INSERT INTO dyu_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Ayiwa, o kɔ, i ye Haruna ni a dencɛw lana Ɲɔgɔnkunbɛn fanibon donda kɔrɔ, ka o ko ni ji ye. ");
INSERT INTO dyu_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","«I ye Haruna ta sarakalasebagaya fani saninmanw don a ra, ka turu saninman* dɔ kɛ a kun na, k’a saninya, janko a ye sarakalasebagaya baara kɛ ne ye. ");
INSERT INTO dyu_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","«O kɔ, i ye a dencɛw fana gbara i yɛrɛ ra, ka olugu ta forokiyasurunw don o ra fana. ");
INSERT INTO dyu_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","I ye turu saninman* dɔ kɛ olugu fana kun na i ko i ka o facɛ ta kɛ cogo min na, janko o ye sarakalasebagaya baara kɛ ne ye. Turu min kɛra o kun na, o sababu ra sarakalasebagaya baara bɛ kɛ olugu ni o ta duruja nataw ta le ye tuma bɛɛ.» ");
INSERT INTO dyu_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ayiwa, Matigi Ala ka ci minw bɛɛ fɔ Musa ye, Musa ka o bɛɛ kɛ. A k’a bɛɛ kɛ a cogo ra. ");
INSERT INTO dyu_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","San flanan karo fɔlɔ, o karo tere fɔlɔ, fanibon lɔra. ");
INSERT INTO dyu_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa ka fanibon lɔ; o ka sendonyɔrɔw blabla, ka yirifɛrɛnw senw dondon o wow ra, ka berew bananbiri o kan, ka yiriw fana lɔ. ");
INSERT INTO dyu_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","O ka fanibon kunnafani biri fanibon kunna, ka sɔrɔ ka birifaniw la o kunna, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","O ka sariya walakaw ta ka o bla jɛnɲɔgɔnya kɛsu* kɔnɔ; ka berew don kɛsu ta nɛgɛ koorininw na, ka kɛsu datugunan biri kɛsu kunna. ");
INSERT INTO dyu_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","O ka jɛnɲɔgɔnya kɛsu ladon Ɲɔgɔnkunbɛn fanibon kɔnɔ. O kɔ, o ka boncɛtigɛfani siri, janko mɔgɔ kana jɛnɲɔgɔnya tagamasiyɛn kɛsu ye, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","O ka burutabali bla boncɛtigɛfani ɲafɛyɔrɔ ra, Ɲɔgɔnkunbɛn fanibon kɔnɔ, fanibon sahiliyanfan fɛ. ");
INSERT INTO dyu_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","O ka sarakaburuw blabla tabali kan Ala ɲa kɔrɔ, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","O ka fitinablanan lɔ fanibon woroduguyanfan fɛ, k’a ɲasin tabali ma. ");
INSERT INTO dyu_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","O ka fitinadagaw mana Matigi Ala ɲa kɔrɔ, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","O ka sarakabɔnan saninlaman bla Ɲɔgɔnkunbɛn fanibon kɔnɔ, boncɛtigɛfani kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","O ka wusunan kasadiman don o sarakabɔnan kan, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Fani min bɛ siri fanibon donda ra o ka o siri. ");
INSERT INTO dyu_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","O kɔ, o ka sarakajɛnifɛn bla Ɲɔgɔnkunbɛn fanibon donda ra, ka bɛgan saraka* dɔ jɛni, ani ka siman saraka* dɔ bɔ, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","O ka minanba sigi Ɲɔgɔnkunbɛn fanibon donda ni sarakajɛnifɛn furancɛ ra, ka ji kɛ a kɔnɔ sarakalasebagaw ta saninyari kosɔn. ");
INSERT INTO dyu_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa ni Haruna ni a dencɛw tun bɛ o ji le kɛ ka o borow ni o senw ko. ");
INSERT INTO dyu_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ni o bɛ don ɲɔgɔnkunbɛn fanibon kɔnɔ, walama ni o bɛ gbara sarakajɛnifɛn na tuma o tuma, o bɛ o yɛrɛ saninya ni o ji le ye, i n’a fɔ Matigi Ala k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","O kɔ, o ka lu laminifani siri ka fanibon ni sarakajɛnifɛn lamini, ka lu donda ta fani fana siri. Ayiwa, Musa ka fanibon ta baara ban o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ayiwa, sankaba jamijan jigira ka na to Ɲɔgɔnkunbɛn fanibon kunna. Matigi Ala ta nɔɔrɔ ka fanibon fa. ");
INSERT INTO dyu_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","A kɛra ten fɔ Musa tun tɛ se ka don Ɲɔgɔnkunbɛn fanibon kɔnɔ; sabu sankaba jamijan tun lɔnin bɛ fanibon kunna, Matigi Ala ta nɔɔrɔ fana tun ka fanibon kɔnɔnɔyɔrɔ bɛɛ fa. ");
INSERT INTO dyu_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Izirayɛlimɔgɔw ta tagama wagati bɛɛ ra, o tun bɛ sankaba jamijan le flɛ. Ni sankaba jamijan tun kɔrɔtara ka bɔ fanibon kunna wagati min na, o wagati ra, o tun bɛ tagama damina. ");
INSERT INTO dyu_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Nka ni sankaba jamijan tun ma kɔrɔta ka bɔ fanibon kunna, o tun tɛ taga. O tun bɛ tagama lalɔ ka sankaba jamijan kɔnɔ, fɔ a ye kɔrɔta. ");
INSERT INTO dyu_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tere fɛ, Matigi Ala ta sankaba jamijan tun bɛ kɛ fanibon san fɛ. Ni su tun kora, a tun bɛ kɛ tasumamana jamijan le ye Izirayɛlimɔgɔw bɛɛ ɲa kɔrɔ. A kɛra ten le fɔ ka taga o ta tagama ban.");
INSERT INTO dyu_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Matigi Ala tora Ɲɔgɔnkunbɛn fanibon* kɔnɔ ka Musa wele, k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Kuma Izirayɛlimɔgɔw fɛ k’a fɔ o ye, ko ni dɔ b’a fɛ ka saraka bɔ Matigi Ala ye, a ye kɛ misi walama saga walama ba le ye. ");
INSERT INTO dyu_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","«Ni a ta saraka jɛnita ye misi le ye, a ye kɛ misitoran ye, fiyɛn tɛ min na. A ye taga o saraka bɔ Ɲɔgɔnkunbɛn fanibon donda ra, janko Matigi Ala ye a ta saraka mina. ");
INSERT INTO dyu_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","A ye a boro la saraka jɛnita kun na, janko Matigi Ala ye sɔn a ta saraka ma, k’a ta jurumun kafari. ");
INSERT INTO dyu_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","A ye o misi kannatigɛ Matigi Ala ɲa kɔrɔ. Sarakalasebagaw, minw ye Haruna dencɛw ye, olugu ye o jori kɛ fɛn dɔ kɔnɔ k’a kɔrɔta san fɛ Matigi Ala ɲa kɔrɔ. O kɔ, sarakajɛnifɛn min bɛ Ɲɔgɔnkunbɛn fanibon donda ra, o ye o jori seriseri o sarakajɛnifɛn fan bɛɛ kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Sarakalasebaga ye o misi boso, k’a tigɛtigɛ. ");
INSERT INTO dyu_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Sarakalasebagaw ye lɔgɔw lala sarakajɛnifɛn kan, ka tasuma kɛ a kan. ");
INSERT INTO dyu_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Sarakalasebagaw, minw ye Haruna dencɛw ye, olugu ye o sogo tigɛtigɛnin ni misi kunkolo ni a turumanyɔrɔw bɛɛ lala lɔgɔ kunna, tasuma ra, sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","O kɔ, sarakalasebaga ye a kɔnɔfɛnw ni a senw bɛɛ ko. O kɔ, a ye o ni sogo tɔ bɛɛ lajɛnnin jɛni sarakajɛnifɛn kan fɔ k’a ban; saraka jɛnita lo tasuma ra, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Ayiwa, ni a ta saraka jɛnita ye saga le ye walama ba, a ka kan ka kɛ cɛman le ye, fiyɛn tɛ min na. ");
INSERT INTO dyu_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","A ye a kannatigɛ sarakajɛnifɛn sahiliyanfan fɛ, Matigi Ala ɲa kɔrɔ. Sarakalasebagaw, minw ye Haruna dencɛw ye, olugu ye a jori seriseri sarakajɛnifɛn fan bɛɛ kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Sarakalasebaga ye a boso k’a tigɛtigɛ. A ye o sogo tigɛtigɛnin ni bɛgan kunkolo ni a turu bɛɛ lala lɔgɔ kunna, tasuma ra, sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","O kɔ, sarakabɔbaga ye a kɔnɔfɛnw ni a senw bɛɛ ko. O kɔ, sarakalasebaga ye o ni sogo tɔ bɛɛ lajɛnnin bla Matigi Ala ɲa kɔrɔ k’a jɛni sarakajɛnifɛn kan fɔ k’a ban; saraka jɛnita lo tasuma ra, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Ni i ta saraka jɛnita ye kɔnɔ le ye, a ye kɛ tugani walama jɛnɛtugani ye, min ma kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Sarakalasebaga ye taga ni o kɔnɔ ye sarakajɛnifɛn ɲa fɛ. A ye a kunkolo sama ka bɔ a ra, ka o jɛni sarakajɛnifɛn kan; k’a jori bɔn sarakajɛnifɛn fandara kelen kan. ");
INSERT INTO dyu_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","O kɔ, a ye a joki ni a kɔnɔfɛnw bɔ, ka o firi sarakajɛnifɛn kɛrɛ fɛ, terebɔyanfan na, bugurigbɛ bɔnnin bɛ yɔrɔ min na. ");
INSERT INTO dyu_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","O kɔ, a ye kɔnɔ mina a kaman fla ma k’a faran a cɛmancɛ ra, nka a kana a bɔ ɲɔgɔn na. Sarakalasebaga ye a jɛni sarakajɛnifɛn kan lɔgɔ kunna; saraka jɛnita lo tasuma ra, min kasa ka di Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Ayiwa, ni mɔgɔ dɔ b’a fɛ ka siman saraka le bɔ Matigi Ala ye, o tigi ye mugu tɛntɛnnin dɔ ta, ka turu kɛ o kan, ka wusunan kasadiman fara a kan, ");
INSERT INTO dyu_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ka taga ni o ye sarakalasebagaw fɛ, minw ye Haruna dencɛw ye. Sarakalasebaga ye boro ɲa kelen cɛ o mugu tɛntɛnnin tururaman ra, ka wusunan bɛɛ ta, ka o jɛni sarakajɛnifɛn kan, k’a yira ko o saraka bɛɛ kɛra Matigi Ala ta ye. O ye siman saraka le ye min jɛnina tasuma ra; o kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Siman saraka tɔ min tora, o ye Haruna ni a dencɛw ta ye. Fɛn saninmanba lo, sabu saraka min jɛnina tasuma ra Matigi Ala ye, a bɔra o le ra. ");
INSERT INTO dyu_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ni i b’a fɛ ka i ta siman saraka jɛni burujɛnifɛn kɔnɔ, k’a di Matigi Ala ma, i ye mugu tɛntɛnnin dɔ nɔɔni turu ra ka o kɛ buru ye, funufɛn kana kɛ a ra; walama i ye a kɛ ŋɔmi ye, ka turu kɛ a kan, funufɛn kana kɛ a ra. ");
INSERT INTO dyu_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«Siman saraka min bɛ yiran faga kɔnɔ ni o dɔ lo, i ye mugu tɛntɛnnin dɔ nɔɔni turu ra, funufɛn kana kɛ a ra, k’a yiran. ");
INSERT INTO dyu_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","O kɔ, i ye a tigɛtigɛ ka turu dɔ kɛ a kan tuun. Siman saraka lo. ");
INSERT INTO dyu_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«Ni siman saraka lo min bɛ yiran pɔli kɔnɔ, i ye mugu tɛntɛnnin dɔ nɔɔni turu ra, k’a lalaga. ");
INSERT INTO dyu_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","«O kɔ, o saraka min lalagara ni o fɛnw ye, i ye taga ni o ye, ka taga o di Matigi Ala ma. I bɛ taga a di sarakalasebaga ma; ale bɛ a bla sarakajɛnifɛn kan Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","O kɔ, sarakalasebaga ye dɔɔnin bɔ o siman saraka ra, min bɛ a yira ko o saraka bɛɛ ye Matigi Ala ta ye; a bɛ o jɛni sarakajɛnifɛn kan. O ye siman saraka le ye, min jɛnina tasuma ra; o kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Siman saraka tɔ min tora, o ye Haruna ni a dencɛw ta ye. Fɛn saninmanba lo, sabu saraka min jɛnina Matigi Ala ye, a bɔra o le ra. ");
INSERT INTO dyu_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«Aw bɛ siman saraka minw bɔ Matigi Ala ye, funufɛn kana kɛ o si ra. Siman saraka o siman saraka bɛ jɛni Matigi Ala ye, funufɛn walama li man kan ka kɛ o si ra. ");
INSERT INTO dyu_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ni aw bɛ na ni aw ta simankura kun fɔlɔ ye ka na o di Matigi Ala ma saraka ye tuma min na, aw bɛ se ka na ni li ni funufɛn ye ka na o di Matigi Ala ma o wagati ra. Nka aw man kan ka li walama funufɛn jɛni sarakajɛnifɛn kan Matigi Ala ye, k’a kɛ i n’a fɔ saraka jɛnita, min kasa ka di. ");
INSERT INTO dyu_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","«Aw ka kan ka kɔgɔ kɛ aw ta siman saraka bɛɛ ra. Aw kana a to kɔgɔ ye fɔn aw ta siman saraka si ra; sabu Matigi Ala ka jɛnɲɔgɔnya min don ni aw ye, kɔgɔ le ye o tagamasiyɛn ye. O kosɔn aw ye kɔgɔ kɛ aw ta siman sarakaw bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«Ni aw bɛ aw ta simankuraw kun fɔlɔw di Matigi Ala ma saraka ye, aw ye o siman kisɛw yiran, k’a susu, ka sɔrɔ ka taga a di Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Aw ye turu kɛ a kan, ka wusunan kasadiman fara a kan; siman saraka lo. ");
INSERT INTO dyu_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Sarakalasebaga bɛ o simankisɛ susunin dɔɔnin bɔ, ani turu ni wusunan bɛɛ, ka o jɛni sarakajɛnifɛn kan, k’a yira ko o saraka bɛɛ kɛra Matigi Ala ta ye. Siman saraka lo min jɛnina tasuma ra Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Ayiwa, ni dɔ b’a fɛ ka ninsɔndiya saraka bɔ Matigi Ala ye, ni misitoran lo, walama misimuso, a kana a to fiyɛn ye kɛ a ra; a ye na ni a ye Matigi Ala fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","A ye a boro la bɛgan kun na, k’a kannatigɛ Ɲɔgɔnkunbɛn fanibon* donda ra. Sarakalasebagaw, minw ye Haruna dencɛw ye, olugu ye a jori seriseri sarakajɛnifɛn kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Sarakabɔbaga ye o ninsɔndiya saraka kɔnɔnɔturu bɛɛ ta ka o jɛni tasuma ra Matigi Ala ye, ");
INSERT INTO dyu_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ani a kɔkiri fla ni a turumanyɔrɔw bɛɛ, ani a biyɛn; a ye o ni kɔkiriw tigɛ. ");
INSERT INTO dyu_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Sarakalasebagaw ye o jɛni sarakajɛnifɛn kan, saraka jɛnita kan. Saraka jɛninin lo tasuma ra min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Ayiwa, ni dɔ ta ninsɔndiya saraka ye saga le ye, walama ba, ni a kɛra cɛman le ye, walama musoman, ni a b’a fɛ ka o le di Matigi Ala ma, a kana a to fiyɛn ye kɛ a ra. ");
INSERT INTO dyu_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","«Ni saga lo, a ye na ni a ye Matigi Ala fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","A ye a boro la bɛgan kun na, k’a kannatigɛ Ɲɔgɔnkunbɛn fanibon donda ra. Sarakalasebagaw, minw ye Haruna dencɛw ye, olugu ye a jori seriseri sarakajɛnifɛn kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Sarakabɔbaga ye o ninsɔndiya saraka turumanyɔrɔw ta ka o jɛni tasuma ra Matigi Ala ye, ani a kɔnɔnɔturu bɛɛ, ani a kukala bɛɛ; a ye kukala tigɛ fɔ a kɔkolo kɔrɔ, ");
INSERT INTO dyu_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ani a kɔkiri fla, ani a turumanyɔrɔw bɛɛ, ani a biyɛn; a ye o ni kɔkiriw tigɛ. ");
INSERT INTO dyu_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Sarakalasebaga ye o jɛni sarakajɛnifɛn kan. O ye domunifɛn le ye min kɛra saraka ye k’a jɛni tasuma ra Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Ayiwa, ni dɔ ta saraka ye ba le ye, a ye na ni a ye Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","A ye a boro la a kun na, k’a kannatigɛ Ɲɔgɔnkunbɛn fanibon donda ra. Sarakalasebagaw ye o jori mina k’a seriseri sarakajɛnifɛn kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","A ye o ninsɔndiya saraka kɔnɔnɔturuw bɛɛ ta ka o jɛni tasuma ra Matigi Ala ye, ");
INSERT INTO dyu_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ani a kɔkiri fla ni a turumanyɔrɔw bɛɛ, ani a biyɛn; a ye o ni kɔkiriw tigɛ. ");
INSERT INTO dyu_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Sarakalasebaga bɛ o jɛni sarakajɛnifɛn kan. O ye domunifɛn le ye min kɛra saraka ye k’a jɛni, ani min kasa ka di.» Bɛgan saraka bɛɛ turu ye Matigi Ala ta ye. ");
INSERT INTO dyu_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","«Ayiwa, nin fana ye sariya wuribari le ye aw ni aw ta durujaw fɛ, ko ni aw nana taga sigi yɔrɔ o yɔrɔ, aw man kan ka sogo turu domu walama k’a jori domu.» ");
INSERT INTO dyu_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Kuma Izirayɛlimɔgɔw fɛ, i ye a fɔ o ye, ko ni mɔgɔ dɔ firira ka jurumun kɛ, ka ko bɛnbari dɔ kɛ, ka Matigi Ala ta sariya dɔ cɛn, o tigi ka kan ka min kɛ, o ye nin ye: ");
INSERT INTO dyu_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«Turu saninman kɛra sarakalasebaga min kan, ni ale le ka o jurumun ɲɔgɔn kɛ, ka o hakɛ bla Izirayɛli jama bɛɛ kunna, a ka kan ka misitoran kaɲaman kelen di Matigi Ala ma, fiyɛn tɛ min na, a ta jurumun kosɔn; o bɛ kɛ a ta jurumunyafa saraka ye. ");
INSERT INTO dyu_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","A ye na ni o misitoran ye Ɲɔgɔnkunbɛn fanibon* donda ra Matigi Ala ɲa kɔrɔ. A ye a boro la misi kun na, k’a kannatigɛ Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","A ye jori dɔ ta ka don ni o ye Ɲɔgɔnkunbɛn fanibon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","A ye a borokanden su o jori ra, k’a seriseri siɲaga wolonfla Matigi Ala ɲa kɔrɔ yɔrɔ saninman* cɛtigɛfani ɲafɛra kan. ");
INSERT INTO dyu_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","A ye jori dɔ mun wusunanjɛnifɛn gbanw fana kan, Matigi Ala ɲa kɔrɔ, Ɲɔgɔnkunbɛn fanibon kɔnɔ yi. O kɔ, a ye bɔ ka taga jori tɔ bɛɛ bɔn sarakajɛnifɛn dugumayɔrɔ kan, Matigi Ala ɲa kɔrɔ, Ɲɔgɔnkunbɛn fanibon donda ra. ");
INSERT INTO dyu_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","O kɔ, a ye o jurumunyafa saraka sogo turu bɛɛ tigɛ ka bɔ a ra, ani a kɔnɔnɔturu bɛɛ, ");
INSERT INTO dyu_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ani a kɔkiri fla ni a turumanyɔrɔw bɛɛ, ani a biyɛn; a ye o ni kɔkiriw tigɛ. ");
INSERT INTO dyu_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Sarakalasebaga ye o yɔrɔw bɔ misi ra, i n’a fɔ ninsɔndiya saraka ta bɛ kɛ cogo min na, ka o jɛni sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Nka a sogo tɔ ni a gbolo ni a kunkolo ni a senw ni a kɔnɔfɛnw bɛɛ, ");
INSERT INTO dyu_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ani misi tɔ bɛɛ, a ye taga o bɛɛ jɛni kɛnɛ ma fanibonw kɔ fɛ, yɔrɔ saninman dɔ ra. A ye a jɛni lɔgɔ kan tasuma ra, bugurigbɛ bɔnyɔrɔ ra.» ");
INSERT INTO dyu_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«Ayiwa, ni Izirayɛlimɔgɔw jama bɛɛ le firira ka jurumun kɛ, hali ni o ma bɔ a kala ma, ni o ka ko bɛnbari dɔ kɛ, ka Matigi Ala ta sariya dɔ cɛn, ka o hakɛ bla o yɛrɛ kunna, ");
INSERT INTO dyu_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ayiwa, ni o nana bɔ o jurumun kala ma, o tuma ra jama bɛɛ ye misitoran kaɲaman kelen di, ka o kɛ jurumunyafa saraka ye. O ye na ni o misi ye Ɲɔgɔnkunbɛn fanibon* donda ra. ");
INSERT INTO dyu_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Jama cɛkɔrɔbaw ye o borow la misi kun na; o ra kelen ye a kannatigɛ Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Turu saninman kɛra sarakalasebaga min kan, ale ye o jori dɔ ta ka don ni a ye Ɲɔgɔnkunbɛn fanibon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","A ye a borokanden su o jori ra, ka o seriseri siɲaga wolonfla fanibon* cɛtigɛfani ɲafɛra kan, Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","A ye jori dɔ mun fana wusunanjɛnifɛn gbanw kan, Matigi Ala ɲa kɔrɔ Ɲɔgɔnkunbɛn fanibon kɔnɔ yi. O kɔ, a ye bɔ ka taga jori tɔ bɛɛ bɔn sarakajɛnifɛn dugumayɔrɔ kan, Matigi Ala ɲa kɔrɔ, Ɲɔgɔnkunbɛn fanibon donda ra. ");
INSERT INTO dyu_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","O kɔ, a ye sogo turumanyɔrɔw bɛɛ tigɛ ka bɔ a ra, ka o jɛni sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","A ye a kɛ i n’a fɔ a ka misi min kɛ saraka ye a yɛrɛ ta jurumun kosɔn. O cogo le ra, sarakalasebaga bɛna o ta jurumun kafari o ye, Ala bɛna yafa o bɛɛ ma. ");
INSERT INTO dyu_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","O kɔ, a ye taga ni sogo tɔ ye kɛnɛ ma, fanibonw kɔ fɛ, ka taga a jɛni i n’a fɔ misi min kɛra saraka ye a yɛrɛ ta jurumunw kosɔn. Jama ta jurumunyafa saraka lo.» ");
INSERT INTO dyu_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«Ayiwa, ni jama ɲamɔgɔ dɔ le firira ka jurumun kɛ, ka ko bɛnbari dɔ kɛ, ka Matigi Ala, a ta Ala ta sariya dɔ cɛn, ka o hakɛ bla a yɛrɛ kan, ");
INSERT INTO dyu_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ni a nana bɔ a ta jurumun kala ma, a ye bakɔrɔnin kelen di, fiyɛn tɛ min na, ka o kɛ a ta jurumunyafa saraka ye. ");
INSERT INTO dyu_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","A ye a boro la bakɔrɔnin kun na, k’a kannatigɛ Matigi Ala ɲa kɔrɔ; o bɛ saraka jɛnitaw kannatigɛ yɔrɔ min na, a ye taga a kannatigɛ o yɔrɔ ra. Jurumunyafa saraka lo. ");
INSERT INTO dyu_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Sarakalasebaga ye a borokanden su o jurumunyafa saraka jori ra, ka o mun sarakajɛnifɛn gbanw na, ka jori tɔ bɔn sarakajɛnifɛn dugumayɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","A ye o sogo turumanyɔrɔw bɛɛ jɛni sarakajɛnifɛn kan, i n’a fɔ ninsɔndiya saraka ta bɛ jɛni cogo min na. O cogo le ra sarakalasebaga bɛna o jama ɲamɔgɔ ta jurumun kafari a ye; Ala bɛna a yafa a ma.» ");
INSERT INTO dyu_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«Ayiwa, ni jama mɔgɔ gbansan dɔ le firira ka jurumun kɛ, ka ko bɛnbari dɔ kɛ, ka Matigi Ala ta sariya dɔ cɛn, ka o hakɛ bla a yɛrɛ kan, ");
INSERT INTO dyu_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ni a nana bɔ a ta jurumun kala ma, a ye ba musoman kelen di, fiyɛn tɛ min na, ka o kɛ a ta jurumunyafa saraka ye; a ye o di a ta jurumun kosɔn. ");
INSERT INTO dyu_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","A ye a boro la o bɛgan kun na, k’a kannatigɛ; o bɛ saraka jɛnitaw kannatigɛ yɔrɔ min na, a ye taga a kannatigɛ o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Sarakalasebaga ye a borokanden su o bɛgan jori ra k’a mun sarakajɛnifɛn gbanw na. O kɔ, a ye jori tɔ bɛɛ bɔn sarakajɛnifɛn dugumayɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","A ye o sogo turumanyɔrɔ bɛɛ bɔ a ra, i n’a fɔ ninsɔndiya saraka ta bɛ kɛ cogo min na, ka o jɛni sarakajɛnifɛn kan. O saraka bɛna kɛ saraka ye min kasa ka di Matigi Ala ye. O cogo le ra, sarakalasebaga bɛna o tigi ta jurumun kafari a ye; Ala bɛna a yafa a ma. ");
INSERT INTO dyu_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«Ayiwa, ni a b’a fɛ ka saga le kɛ a ta jurumunyafa saraka ye, a ye a kɛ sagamuso ye, fiyɛn tɛ min na. ");
INSERT INTO dyu_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","A ye a boro la o bɛgan kun na, k’a kannatigɛ Matigi Ala ɲa kɔrɔ, k’a kɛ jurumunyafa saraka ye. O bɛ saraka jɛnitaw kannatigɛ yɔrɔ min na, a ye taga a kannatigɛ o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Sarakalasebaga ye a borokanden su o bɛgan jori ra k’a mun sarakajɛnifɛn gbanw na, ka jori tɔ bɔn sarakajɛnifɛn senkɔrɔyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","A ye o sogo turumanyɔrɔw bɛɛ bɔ a ra, i n’a fɔ ninsɔndiya saraka ta saga bɛ kɛ cogo min na, ka o jɛni sarakajɛnifɛn kan, i n’a fɔ saraka min jɛnina tasuma ra k’a ban, Matigi Ala ɲa kɔrɔ. O cogo le ra, sarakalasebaga bɛna o tigi ta jurumun kafari a ye; Ala fana bɛna a yafa a ma.» ");
INSERT INTO dyu_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«Ayiwa, ni mɔgɔ dɔ kɛra ko dɔ seere ye kititigɛyɔrɔ ra, ni a ka fɛn min ye a ɲa ra, walama ni a ka min mɛn, ni a ma sɔn ka o ko seereya kɛ, o tigi ka kojugu min kɛ, o hakɛ bɛ a kan. ");
INSERT INTO dyu_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«Ni mɔgɔ dɔ magara fɛn saninyabari dɔ ra, bɛgan saninyabari dɔ su, kongobɛgan walama sokɔnɔbɛgan, walama fɛnɲanaman minw bɛ fofo, hali ni a tigi ma bɔ a kala ma, o tuma, o tigi yɛrɛ bɛ kɛ mɔgɔ saninyabari ye; o hakɛ bɛ o tigi kan. ");
INSERT INTO dyu_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ni a magara mɔgɔ saninyabari dɔ ta fɛn le ra, ni a kɛra fɛn o fɛn ye, hali ni a ma bɔ a kala ma, ni a nana a lɔn tuma o tuma, o hakɛ bɛ o tigi kan. ");
INSERT INTO dyu_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ni mɔgɔ dɔ tora kuma ra, k’a da teliya ka kari ko ale bɛna ko dɔ kɛ, koɲuman walama kojugu, k’a sɔrɔ a ma o ko jate, ayiwa, kɔ fɛ ni a nana bɔ o ko kala ma, o hakɛ bɛ o tigi kan. ");
INSERT INTO dyu_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«Ayiwa, nin ko minw fɔra nin ye, ni mɔgɔ min ka o dɔ kɛ, o tigi ka kan ka lɔ o jurumun na mɔgɔw ɲa na. ");
INSERT INTO dyu_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","O kɔ, a ye na ni a ta hakɛbɔ saraka ye Matigi Ala ɲa kɔrɔ a ta jurumun kosɔn, bɛgan musoman dɔ, saga walama ba, ka o kɛ jurumun yafa sara ye; sarakalasebaga bɛna o kɛ k’a ta jurumun kafari a ye. ");
INSERT INTO dyu_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«Ni a ma se ka saga walama ba sɔrɔ, a ye tugani fla, walama jɛnɛtugani den fla di Matigi Ala ma, a ta jurumun sara ye; kelen bɛna kɛ a ta jurumunyafa saraka ye, tɔ kelen bɛ kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","A bɛna o di sarakalasebaga ma; min bɛ kɛ jurumunyafa saraka ye, sarakalasebaga ye kɔn ka o le bɔ fɔlɔ. Sarakalasebaga ye a kannatigɛ ni a sɔninfara ye, nka a kunkolo kana bɔ a ra; ");
INSERT INTO dyu_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","a ye a jori seriseri sarakajɛnifɛn fan kelen kan; o kɔ, a ye jori tɔ bɛɛ bɔn sarakajɛnifɛn dugumayɔrɔ ra. Jurumunyafa saraka lo. ");
INSERT INTO dyu_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","«O kɔ, sarakalasebaga ye kɔnɔ flanan kɛ saraka jɛnita ye, ka kaɲa ni saraka jɛnitaw ta sariya ye. O cogo le ra sarakalasebaga bɛna a ta jurumun kafari a ye, Ala bɛna yafa a ma. ");
INSERT INTO dyu_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«Ni a ma se ka tugani fla, walama jɛnɛtugani den fla sɔrɔ, a ye na ni mugu tɛntɛnnin kilo saba ye ka na o kɛ a ta jurumunyafa saraka ye. A kana turu kɛ a ra, a kana wusunan fana kɛ a ra, sabu jurumunyafa saraka lo. ");
INSERT INTO dyu_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","A ye na ni o mugu tɛntɛnnin ye sarakalasebaga fɛ. Sarakalasebaga ye boro ɲa kelen cɛ o mugu ra k’a yira ko o saraka bɛɛ kɛra Matigi Ala ta ye. A ye o jɛni sarakajɛnifɛn kan, i n’a fɔ siman saraka min jɛnina tasuma ra Matigi Ala ye. Jurumunyafa saraka lo. ");
INSERT INTO dyu_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","O cogo le ra, sarakalasebaga bɛna o tigi ta jurumun kafari a ye, ni a kɛra ko a tun ka o ko fla dɔ kɛ; Ala bɛna yafa a ma. «O mugu tɔ min bɛna to, o bɛna kɛ sarakalasebagaw ta ye, i n’a fɔ siman saraka tɔw ta bɛ kɛ cogo min na.» ");
INSERT INTO dyu_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Sarakafɛn minw ka kan ka bla Matigi Ala ye danna, ni mɔgɔ dɔ firira ka hakɛman ko dɔ kɛ o fɛnw ta ko ra, ka o fɛn saninmanw lanɔgɔ, o tigi ka kan ka sagajigi kelen, walama bakɔrɔnin kelen di Matigi Ala ma a ta jurumun sara ye; fiyɛn kana kɛ o bɛganw na. A tigi bɛna o fɛnw sara ka kaɲa ni ele Musa ta sɔngɔ fɔnin ye; a bɛ o warida sara ka kaɲa ni yɔrɔ saninman* ta jate ye. ");
INSERT INTO dyu_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","A ka fɛn saninman min cɛn, a bɛna o sɔngɔ di, ani a sɔngɔ tarannin sigiyɔrɔma looru, a bɛ a sigiyɔrɔma kelen fara a kan tuun, ka o di sarakalasebaga ma. O kɔ, sarakalasebaga bɛna o saga walama o bakɔrɔnin kɛ a ta hakɛbɔ saraka ye. Ala bɛna yafa a ma. ");
INSERT INTO dyu_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Ni mɔgɔ dɔ ka jurumun kɛ, hali ni a ma bɔ a kala ma, ni a ka ko bɛnbari dɔ kɛ, ka Matigi Ala ta sariya cɛn, o hakɛ bɛ bɔ o tigi ra, a fana bɛ lɔ ni a kunko ye. ");
INSERT INTO dyu_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","A ka kan ka na ni sagajigi, walama bakɔrɔnin dɔ ye, fiyɛn tɛ min na, min bɛ bɛn ele Musa ta sɔngɔ fɔnin ma; a ye na ni o ye sarakalasebaga fɛ, ka o kɛ a ta jurumun sara ye. A ka jurumun min kɛ ni a ma bɔ a kala ma, sarakalasebaga bɛna o jurumun kafari a ye; Ala bɛna yafa a ma. ");
INSERT INTO dyu_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","A ta hakɛbɔ saraka lo, sabu o tigi ka ko bɛnbari le kɛ ka Matigi Ala hakɛ ta.» ");
INSERT INTO dyu_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«Ni mɔgɔ dɔ ka terenbariyako dɔ kɛ Matigi Ala ɲa kɔrɔ, i n’a fɔ ka faninya fɔ a mɔgɔɲɔgɔn ye fɛn karifanin dɔ ko ra, walama fɛn singanin dɔ ko ra, walama fɛn sonyanin dɔ, walama ni a k’a mɔgɔɲɔgɔn tɔɲɔ ko dɔ ra, ");
INSERT INTO dyu_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","walama ni a ka fɛn tununin dɔ ye ka faninya tigɛ ko a m’a ye, walama ni a karira gbansan ko dɔ ra, walama ni a ka o ɲɔgɔnna ko dɔ kɛ, ");
INSERT INTO dyu_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","a ka jurumun le kɛ; o hakɛ bɛ a yɛrɛ kan. Ayiwa, a ka fɛn min sonya, walama a k’a mɔgɔɲɔgɔn tɔɲɔ fɛn min na, walama fɛn min karifara a ma, walama a ka fɛn tununin min ye k’a fɔ ko a m’a ye, ");
INSERT INTO dyu_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ani a karira gbansan fɛn min kosɔn, ni a nana bɔ o ko kala ma, lon min ni a bɛ o hakɛbɔ saraka di, a ka kan ka o fɛn sara a tigi ye, ka sɔrɔ k’a sɔngɔ taran taranyɔrɔ looru, k’a taran kelen fara a kan ka o di a tigi ma. ");
INSERT INTO dyu_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","«Ka fara o kan, a ye sagajigi dɔ bɔ a ta sagaw ra, fiyɛn tɛ min na, ka na ni o ye sarakalasebaga fɛ; a bɛ o di Matigi Ala ma a ta hakɛbɔ saraka ye. O bɛgan sɔngɔ ka kan ka min bɔ, i yɛrɛ bɛna o fɔ a ye. ");
INSERT INTO dyu_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Ayiwa, sarakalasebaga bɛna a ta jurumun kafari a ye Matigi Ala ɲa kɔrɔ; a ka jurumun o jurumun kɛ ka Ala hakɛ ta, Ala bɛna o bɛɛ yafa a ma.» ");
INSERT INTO dyu_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Nin ciw fɔ Haruna ni a dencɛw ye, ko saraka jɛnita ta sariya flɛ nin ye: Saraka jɛnita ka kan ka jɛni sarakajɛnifɛn kan su bɛɛ, fɔ ka taga dugu gbɛ; tasuma mananin ka kan ka to sarakajɛnifɛn kan wagati bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Ayiwa, sɔgɔma, saraka jɛnita min jɛnina sarakajɛnifɛn kan, sarakalasebaga ye a ta lɛnfaniw don a yɛrɛ ra, a ta forokiyasurun ni a ta kurusi, ka o saraka jɛninin buguri cɛ ka taga a kɛ sarakajɛnifɛn kɛrɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","O kɔ, a ye o faniw bɔ, ka fani wɛrɛw don, ka o buguri cɛ ka taga a bɔn kɛnɛ ma Izirayɛlimɔgɔw ta fanibonw* kɔ fɛ, yɔrɔ saninman* dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Tasuma min mananin bɛ sarakajɛnifɛn kan, o man kan ka faga fiyewu. Sɔgɔma o sɔgɔma, sarakalasebaga ye lɔgɔ dɔ kundon a ra, ka saraka jɛnita labɛn k’a bla tasuma ra, ka ninsɔndiya saraka kɔnɔnɔ turu fana jɛni a kan. ");
INSERT INTO dyu_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Tasuma mananin ye to sarakajɛnifɛn kan wagati bɛɛ, a kana faga fiyewu.» ");
INSERT INTO dyu_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","«Ayiwa, siman saraka ta sariyaw flɛ nin ye: Haruna dencɛw le ka kan ka na ni o saraka ye Matigi Ala ɲa kɔrɔ, sarakajɛnifɛn ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Sarakalasebaga ye dɔɔnin bɔ o mugu tɛntɛnnin tururaman ra, ka o ni a wusunan bɛɛ jɛni sarakajɛnifɛn kan, k’a yira ko o saraka bɛɛ kɛra Matigi Ala ta le ye. O ye siman saraka le ye, min jɛnina tasuma ra; o kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Saraka mugu tɔ min tora, Haruna ni a dencɛw ye o domu. O ye a domu yɔrɔ saninman* na, Ɲɔgɔnkunbɛn fanibon* lu kɔnɔ, funufɛn man kan ka kɛ a ra. ");
INSERT INTO dyu_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","O man kan ka funufɛn kɛ a ra k’a jɛni. O ninyɔrɔ le ye o ye; ne ka o le di o ma. Siman saraka min jɛnina tasuma ra ne Matigi Ala ye, ne k’a bɔ o le ra k’a di o ma. A saninyanin lo kosɛbɛ, i n’a fɔ jurumunyafa saraka, walama hakɛbɔ saraka. ");
INSERT INTO dyu_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Haruna dencɛw bɛɛ bɛ se k’a domu, sabu o saraka minw jɛnina Matigi Ala ye, olugu ninyɔrɔ bɛna kɛ o le ye wagati bɛɛ. Ni mɔgɔ o mɔgɔ ka maga o ra, o bɛ saninya ka bla danna Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«Lon min i bɛna Haruna ni a dencɛw mun ni turu ye ka o sigi sarakalasebagaya ra, o ka kan ka saraka minw di ne Matigi Ala ma, o ye nin ye: o ye mugu tɛntɛnnin kilo saba kɛ saraka ye lon o lon. O ye a tarancɛ kɛ saraka ye sɔgɔma, k’a tɔ tarancɛ kɛ saraka ye wula fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","O mugu ka kan ka nɔɔni turu ra, ka sɔrɔ k’a yiran faga kɔnɔ k’a kɛ ŋɔmi ye. I ye o ŋɔmi tigɛtigɛ ka sɔrɔ k’a di saraka ye Matigi Ala ma. Siman saraka lo min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","«Ni turu saninman kɛra Haruna dencɛ min kan k’a kɛ sarakalasebagaw kuntigi ye a nɔ ra, o fana ka kan ka o saraka kelen le bɔ. O saraka ka kan ka jɛni Matigi Ala ɲa kɔrɔ k’a ban pewu. O ye sariya wuribari le ye. ");
INSERT INTO dyu_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","«Sarakalasebagaw ta siman sarakaw bɛɛ ka kan ka jɛni k’a ban pewu; foyi man kan ka domu a ra.» ");
INSERT INTO dyu_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","«A fɔ Haruna ni a dencɛw ye ko jurumunyafa saraka ta sariyaw flɛ nin ye: Saraka jɛnita bɛ kannatigɛ yɔrɔ min na, jurumunyafa saraka ka kan ka kannatigɛ o yɔrɔ le ra, Matigi Ala ɲa kɔrɔ, sabu saraka lo, min saninyanin lo kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","«Sarakalasebaga min bɛ jurumunyafa saraka lase Matigi Ala ma, ale le bɛ se ka o saraka domu. A ye a domu yɔrɔ saninman* na, Ɲɔgɔnkunbɛn fanibon* lu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Ni sarakasogo ka maga fɛn o fɛn na, o bɛ saninya ka bla danna Ala ye. Ni a jori sera fani o fani ma, a sera fani yɔrɔ min ma, aw ye o yɔrɔ ko yɔrɔ saninman dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","A sogo tobira bɔgɔdaga min kɔnɔ, kɔ fɛ, o bɔgɔdaga ka kan ka ci. Ni siranɛgɛ daga lo, a ye a jɔsi kosɛbɛ, k’a sɛnɛnko ji ra. ");
INSERT INTO dyu_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Sarakalasebaga ta den cɛmanw dɔrɔn le bɛ se k’a sogo domu, sabu a saninyanin lo kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","«Nka o bɛ don ni jurumunyafa saraka min o min jori dɔ ye Ɲɔgɔnkunbɛn fanibon kɔnɔ ka taga jurumun kafari yɔrɔ saninman kɔnɔ, o saraka si sogo man kan ka domu. A ka kan ka jɛni k’a ban tasuma ra le.» ");
INSERT INTO dyu_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«Ayiwa, hakɛbɔ saraka ta sariyaw flɛ nin ye: Saraka saninyaninba lo. ");
INSERT INTO dyu_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","«Saraka jɛnita bɛ kannatigɛ yɔrɔ min na, hakɛbɔ saraka ka kan ka kannatigɛ o yɔrɔ le ra. O kɔ, sarakalasebaga ye a jori seriseri sarakajɛnifɛn fan bɛɛ kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","A ye a turumanyɔrɔw bɛɛ kɛ saraka ye ka o di Matigi Ala ma, ani a kukala, ani a kɔnɔnɔ turu bɛɛ, ");
INSERT INTO dyu_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ani a kɔkiri fla ni a turumanyɔrɔw bɛɛ, ani a biyɛn; a ye o ni kɔkiriw tigɛ. ");
INSERT INTO dyu_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Sarakalasebaga ye o bɛɛ jɛni sarakajɛnifɛn kan. Hakɛbɔ saraka lo min jɛnina tasuma ra Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Sarakalasebaga ta den cɛmanw dɔrɔn le bɛ se k’a sogo domu; nka o ka kan k’a domu yɔrɔ saninman* le ra, sabu a saninyanin lo kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","«Jurumunyafa saraka ta sariya ni hakɛbɔ saraka ta sariya bɛɛ ye kelen ye; a bɛɛ ye sariya kelen ye. Sarakalasebaga min bɛ jurumun kafari, o saraka sogo bɛna kɛ ale ta le ye. ");
INSERT INTO dyu_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Sarakalasebaga min ka mɔgɔ dɔ ta saraka jɛnita lase Matigi Ala ma, o saraka gbolo bɛ kɛ o sarakalasebaga yɛrɛ ta ye. ");
INSERT INTO dyu_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Siman saraka o siman saraka, ni a kɛra ko o saraka jɛnina burujɛnigba le kɔnɔ o, walama ni a yiranna pɔli le kɔnɔ o, walama ni a yiranna faga le kɔnɔ o, sarakalasebaga min k’a lase Ala ma, o siman saraka bɛ kɛ ale ta le ye. ");
INSERT INTO dyu_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Siman saraka o siman saraka, ni a nɔɔnina turu le ra, walama ni a jalan lo, o ye sarakalasebaga Haruna ni a dencɛw bɛɛ ta le ye, dɔ ma bɔ dɔ ra.» ");
INSERT INTO dyu_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«Ninsɔndiya saraka min bɛ bɔ ka di Matigi Ala ma, o ta sariyaw flɛ nin ye: ");
INSERT INTO dyu_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","«Ni mɔgɔ dɔ ko a bɛ ninsɔndiya saraka bɔ, k’a kɛ ɲumanlɔn saraka le ye, a ye buru tururaman misɛnmanw fara o barakalari saraka kan, funufɛn kana kɛ a ra, ani ŋɔmi; a ye turu kɛ ŋɔmi kan, nka funufɛn kana kɛ a ra; ani buru min kɛra ni mugu tɛntɛnnin tururaman ye. ");
INSERT INTO dyu_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","A ka o ninsɔndiya saraka min kɛ ɲumanlɔn saraka ye, a ka kan ka burufununin dɔ fana fara o saraka kan k’a di. ");
INSERT INTO dyu_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","A ye burukun kelen kelen bɔ o sarakafɛnw bɛɛ ra ka o kɔrɔta san fɛ, ka o di Matigi Ala ma. Sarakalasebaga min ka ninsɔndiya saraka jori seriseri sarakajɛnifɛn kan, o buruw bɛna kɛ ale ta le ye. ");
INSERT INTO dyu_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ninsɔndiya saraka min kɛra ɲumanlɔn saraka ye, o saraka sogo bɛɛ ka kan ka domu a bɔlon yɛrɛ ra; a dɔ man kan ka si. ");
INSERT INTO dyu_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«Ni sarakabɔbaga ta saraka ye dajurudafa saraka le ye, walama ni a yɛrɛ diyanya saraka lo, a bɛ o saraka di Matigi Ala ma lon min na, a sogo ye domu o lon yɛrɛ ra. Ni a tɔ ka to, a ye a domu o lon dugusagbɛ. ");
INSERT INTO dyu_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nka ni sogo tɔ belen ka to tuun a dugusagbɛ flanan, a ye o jɛni tasuma ra k’a ban. ");
INSERT INTO dyu_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ni mɔgɔ min ka sarakasogo domu fɔ a tere sabanan, o tigi ta saraka tɛna mina. O saraka kɛra gbansan le ye, sabu a sogo kɛra fɛn haramunin le ye. Ni mɔgɔ o mɔgɔ ka o sogo domu, o hakɛ bɛ o tigi kan. ");
INSERT INTO dyu_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Ni fɛn saninyabari dɔ magara sarakasogo min na, o sogo man kan ka domu tuun. O ka kan k’a jɛni. Ni o tɛ, mɔgɔ minw saninyara, olugu le ka kan ka sarakasogo domu. ");
INSERT INTO dyu_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Nka ni mɔgɔ min ka Matigi ta ninsɔndiya saraka domu k’a sɔrɔ a ma saninya, o tigi ka kan ka faran ka bɔ Izirayɛli jamanadenw na. ");
INSERT INTO dyu_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ni mɔgɔ min magara fɛn saninyabari dɔ ra fana, ni a kɛra mɔgɔ saninyabari dɔ le ye o, walama bɛgan o, walama fɛn saninyabari dɔ wɛrɛ o, ni o tigi ka Matigi Ala ta ninsɔndiya saraka domu, o tigi ka kan ka faran ka bɔ a ta jamana mɔgɔw cɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Kuma Izirayɛlimɔgɔw fɛ k’a fɔ o ye ko o man kan ka sogo turu domu. Ni a kɛra misi le ye o, walama saga o, walama ba o, o man kan ka o si turu domu. ");
INSERT INTO dyu_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ni a kɛra ko aw ka bɛgan dɔ su le ye, walama ni wara dɔ le k’a faga, aw bɛ se ka o turu kɛ ka mako wɛrɛ ɲa, nka aw man kan k’a domu. ");
INSERT INTO dyu_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","«Sarakasogo turu minw bɛ jɛni tasuma ra k’a kɛ saraka ye Matigi Ala ye, ni mɔgɔ o mɔgɔ ka o domu, o tigi ka kan ka faran ka bɔ a ta jamana mɔgɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","«Ni aw ka taga sigi jamana o jamana ra, aw kana kɔnɔ walama bɛgan si jori domu. ");
INSERT INTO dyu_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ni mɔgɔ min ka o fɛnw dɔ jori domu, o tigi ka kan ka faran ka bɔ Izirayɛli jamanadenw na.» ");
INSERT INTO dyu_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«A fɔ Izirayɛlimɔgɔw ye, ko ni dɔ b’a fɛ ka ninsɔndiya saraka bɔ Matigi Ala ye, Matigi ninyɔrɔ ye min ye o saraka ra, a ye o di. ");
INSERT INTO dyu_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Min ka kan ka jɛni tasuma ra Matigi Ala ye, a yɛrɛ ye na ni o ye. A ye na ni a turumanyɔrɔw ni a disi ye; a ye o disi fifa Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Sarakalasebaga ye a turu jɛni sarakajɛnifɛn kan; nka disi bɛ kɛ Haruna ni a dencɛw ta ye. ");
INSERT INTO dyu_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","«Aw ta ninsɔndiya sarakaw ra, aw ka kan ka kininboroyanfan woto fana tigɛ ka o di sarakalasebaga ma. ");
INSERT INTO dyu_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Haruna dencɛ min bɛna ninsɔndiya saraka jori ni a turu lase Matigi Ala ma, kininboroyanfan woto bɛ kɛ ale ta le ye. ");
INSERT INTO dyu_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","O ra, Izirayɛlimɔgɔw bɛ ninsɔndiya saraka minw bɔ, disi min bɔra o saraka ra k’a fifa, ani a woto min dira Ala ma, ne ka o di sarakalasebaga Haruna ni a dencɛw le ma, sabu o le bɛna kɛ olugu ninyɔrɔ ye wagati bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","«O ninsɔndiya saraka min turu jɛnina tasuma ra Matigi Ala ye, o disi ni o woto min bɔra o saraka ra, o le bɛ kɛ Haruna ni a dencɛw ta ye, ni i nana o mun lon min na ni turu saninman* ye, ka o sigi sarakalasebagaya ra. ");
INSERT INTO dyu_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ni i nana o mun lon min na, Matigi Ala k’a fɔ ko Izirayɛlimɔgɔw ye o le di o ma. O ye sariya wuribari le ye o ni o ta duruja nataw bɛɛ fɛ, wagati bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","«Ayiwa, sarakaw ta sariyaw le ye nin ye; saraka jɛnita, ani siman saraka, ani jurumunyafa saraka, ani hakɛbɔ saraka, ani sarakalasebagaw ta saninyari saraka, ani ninsɔndiya saraka.» ");
INSERT INTO dyu_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Matigi Ala ka o ciw le fɔ Musa ye Sinayi kuru kan, kongokolon kɔnɔ, lon min na a k’a fɔ Izirayɛlimɔgɔw ye ko o ye saraka bɔ ale ye. ");
INSERT INTO dyu_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Na ni Haruna ni a dencɛw ye, ani o ta fani saninmanw, ani turu saninman*, ani misitoran min bɛna kɛ o ta jurumunyafa saraka ye, ani sagajigi fla, ani burufunubariw bɛ segi min kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Izirayɛli jama bɛɛ lajɛn fana Ɲɔgɔnkunbɛn fanibon* donda ra.» ");
INSERT INTO dyu_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Matigi Ala ka min fɔ, Musa ka o kɛ. A ka jama bɛɛ lajɛn Ɲɔgɔnkunbɛn fanibon donda ra. ");
INSERT INTO dyu_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa k’a fɔ jama ye ko: «Matigi Ala ka ci min fɔ, ne bɛna o le kɛ bi.» ");
INSERT INTO dyu_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","A ka Haruna ni a dencɛw lana; a ka o ko ni ji ye. ");
INSERT INTO dyu_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","O kɔ, Musa ka forokiyasurun don Haruna ra, ka cɛsirinan kɛ k’a cɛsiri, ka forokiyajan fana don a ra, ka saninderege la o kan, ka saninderege cɛsirinan kɛ ka saninderege cɛsiri. ");
INSERT INTO dyu_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","A ka disirafɛn siri a disi ra, ka Urimi ni Tumimi don disirafɛn na. ");
INSERT INTO dyu_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","A ka jalamugu fugula biri a kun na, ka tennasanin tagamasiyɛn saninman siri o kan, a ten na, i n’a fɔ Matigi Ala tun k’a fɔ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","O kɔ, Musa ka turu saninman* seriseri Ɲɔgɔnkunbɛn fanibon* ni a kɔnɔfɛnw bɛɛ kan, ka o saninya ka o bla danna Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","A ka dɔ seriseri sarakajɛnifɛn kan siɲaga wolonfla, ani a minanw bɛɛ, ani minanba ni a siginan, ka o bɛɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","O kɔ, Musa ka turu saninman* dɔ kɛ Haruna kun na, k’a saninya Ala ta baara kama. ");
INSERT INTO dyu_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","A ka Haruna dencɛw fana gbara a yɛrɛ ra, ka olugu fana ta forokiyasurunw don o ra, ka o ta cɛsirinanw siri o cɛ ra, ka o ta banflaw biri o kun na, i n’a fɔ Matigi Ala tun k’a fɔ a ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","O kɔ, a nana ni jurumunyafa saraka ta misi ye. Haruna ni a dencɛw ka o boro la o misitoran kun na. ");
INSERT INTO dyu_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa ka misi kannatigɛ, k’a jori dɔ ta, k’a borokanden su o ra ka o mun sarakajɛnifɛn gbanw na, ka o saninya. O kɔ, a ka jori tɔ bɛɛ bɔn sarakajɛnifɛn dugumayɔrɔ ra, ka sarakajɛnifɛn saninya, ka jurumunw kafari. ");
INSERT INTO dyu_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Musa ka misi boso k’a kɔnɔnɔturu bɛɛ bɔ, ani a biyɛn, ani a kɔkiri fla ni a turu bɛɛ, ka o bɛɛ jɛni sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Nka misi gbolo ni a sogo tɔ, ani a kɔnɔfɛnw, a tagara o bɛɛ jɛni kɛnɛ ma, fanibonw* kɔ fɛ, i n’a fɔ Matigi Ala tun k’a fɔ a ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","O kɔ, a nana ni sagajigi kelen ye, min bɛna kɛ saraka jɛnita ye. Haruna ni a dencɛw ka o boro la sagajigi kun na. ");
INSERT INTO dyu_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa k’a kannatigɛ, k’a jori seriseri sarakajɛnifɛn fan bɛɛ kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","A ka sagajigi boso, k’a tigɛtigɛ, k’a kunkolo ni a sogo ni a turu bɛɛ jɛni. ");
INSERT INTO dyu_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","A k’a kɔnɔfɛnw ni a senw ko ni ji ye, ka o ni sagajigi sogo tɔ bɛɛ jɛni sarakajɛnifɛn kan, ka o kɛ saraka jɛninin ye tasuma ra, min kasa ka di Matigi Ala ye, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","O kɔ, a ka sagajigi flanan mina, sagajigi min bɛ kɛ Haruna ni a dencɛw ta saninyari saraka ye. Haruna ni a dencɛw ka o boro la o sagajigi kun na. ");
INSERT INTO dyu_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa k’a kannatigɛ, k’a jori dɔɔnin ta, ka o mun Haruna kininboroyanfan toro nunkun na, ani a kininboroyanfan borokandenba, ani a kininboroyanfan senmandenba. ");
INSERT INTO dyu_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","O kɔ, a ka Haruna dencɛw fana gbara a yɛrɛ ra, ka jori dɔ mun olugu fana kininboroyanfan toro nunkun na, ani o kininboroyanfan borokandenba, ani o kininboroyanfan senmandenba. O kɔ, a ka jori tɔ seriseri sarakajɛnifɛn fan bɛɛ kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","A ka sagajigi boso, k’a turu bɔ, ani a kukala, ani a kɔnɔnɔturu, ani a biyɛn, ani a kɔkiri fla ni a turu, ani a kininboroyanfan woto; ");
INSERT INTO dyu_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","burufunubari minw tun blara segi kɔnɔ Matigi Ala ɲa kɔrɔ, a ka burukun kelen ta o ra, ani buru turuman kelen ni ŋɔmikun kelen. A ka o fara sogo turu ni a kininboroyanfan woto kan. ");
INSERT INTO dyu_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","A ka o fɛnw bɛɛ don Haruna ni a dencɛw boro, o ka o fifa Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","O kɔ, a ka o fɛnw mina o boro, ka o jɛni ni saraka jɛnita ye sarakajɛnifɛn kan. O kɛra Haruna ni a dencɛw ta saninyari saraka ye. Saraka jɛninin lo tasuma ra, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","O kɔ, Musa ka o sagajigi disi ta k’a fifa Matigi Ala ɲa kɔrɔ. O disi kɛra Musa yɛrɛ ninyɔrɔ ye o saninyari saraka ta sagajigi ra, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musa ka turu saninman* dɔ ta, ani jori min tun bɔnna sarakajɛnifɛn kan; a ka o seriseri Haruna ni a ta faniw kan, ani a dencɛw ni o ta faniw. A kɛra ten, Haruna ni a dencɛw ni o ta faniw bɛɛ saninyara ka bla Matigi Ala ta baara kama. ");
INSERT INTO dyu_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa k’a fɔ Haruna ni a dencɛw ye ko: «Aw ye sagajigi flanan sogo tobi Ɲɔgɔnkunbɛn fanibon* donda ra. Aw ka kan k’a domu o yɔrɔ le ra, Matigi Ala ɲa kɔrɔ; sarakalasebagaw ta saninyari saraka tun bɛ segi min kɔnɔ, buru minw bɔra o segi kɔnɔ, aw ye o fana domu. Aw ye a domu Ɲɔgɔnkunbɛn fanibon donda ra, i n’a fɔ ne k’a fɔ aw ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ni o sogo, walama ni o buru tɔ ka si, aw ye o tɔ jɛni k’a ban pewu.» ");
INSERT INTO dyu_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Musa k’a fɔ Haruna ni a dencɛw ye tuun ko: «Aw ye to Ɲɔgɔnkunbɛn fanibon donda ra ka se fɔ tere wolonfla, fɔ ka taga aw ta saninyari lonw dafa; sabu tere wolonfla le bɛ dafa, aw bɛ sɔrɔ ka saninya ka don sarakalasebagaya ra. ");
INSERT INTO dyu_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Min kɛra bi, Matigi Ala le ka o bɛɛ fɔ. O kɛra janko aw ta jurumunw bɛɛ ye kafari. ");
INSERT INTO dyu_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","O ra, aw ye to Ɲɔgɔnkunbɛn fanibon donda ra su ni tere, fɔ tere wolonfla, ka Matigi Ala ta kokɛtaw dafa; ni o tɛ, aw bɛ sa. Matigi Ala ka o le fɔ ne ye.» ");
INSERT INTO dyu_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ayiwa, Matigi Ala tun ka ci minw don Musa da ra k’a lase Haruna ni a dencɛw ma, o ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ayiwa, sarakalasebagaw ta saninyari tere seeginan lon na, Musa ka Haruna ni a dencɛw ni Izirayɛli cɛkɔrɔbaw bɛɛ wele. ");
INSERT INTO dyu_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","A k’a fɔ Haruna ye ko: «Misitoran kelen kɛ i yɛrɛ ta jurumunyafa saraka ye, ka sagajigi kelen kɛ i ta saraka jɛnita ye; fiyɛn kana kɛ o si ra. I ye o di saraka ye Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","O kɔ, i ye kuma Izirayɛlimɔgɔw fɛ k’a fɔ o ye ko o fana ye bakɔrɔnin kelen kɛ o ta jurumunyafa saraka ye, ka san kelen misiden ni san kelen sagajigi kɛ o ta saraka jɛnita ye. Fiyɛn kana kɛ o si ra. ");
INSERT INTO dyu_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","O ye na ni misitoran kelen ye fana, ani sagajigi kelen, ka o kɛ ninsɔndiya saraka ye, ka o di Matigi Ala ma; ka mugu dɔ nɔɔni turu ra, ka o kɛ siman saraka ye ka o fara o kan; sabu Matigi Ala bɛna a yɛrɛ yira aw ra bi.» ");
INSERT INTO dyu_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ayiwa, Musa ka bɛgan minw ko fɔ, mɔgɔw nana ni o bɛganw ye Ɲɔgɔnkunbɛn fanibon* donda ra. Jama bɛɛ nana, ka na lɔ Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa ko: «Matigi Ala ko aw ye nin sarakaw bɔ, janko ale ye a ta nɔɔrɔ yira aw ra bi.» ");
INSERT INTO dyu_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa k’a fɔ Haruna ye ko: «Gbara sarakajɛnifɛn na ka i ta jurumunyafa saraka ni i ta saraka jɛnita bɔ, ka i yɛrɛ ta jurumunw kafari, ani jama ta jurumunw. O kɔ, i ye jama bɛɛ ta saraka bɔ fana ka o ta jurumunw kafari, i n’a fɔ Matigi Ala k’a fɔ cogo min na.» ");
INSERT INTO dyu_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ayiwa, Haruna gbarara sarakajɛnifɛn na; a ka misitoran kannatigɛ, ka o kɛ a yɛrɛ ta jurumunyafa saraka ye. ");
INSERT INTO dyu_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","A dencɛw ka o jori dɔ ta ka o di a ma; a k’a borokanden su jori ra, ka o jori dɔ kɛ sarakajɛnifɛn gbanw kan. O kɔ, a k’a tɔ bɔn sarakajɛnifɛn dugumayɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A ka o jurumunyafa saraka turu ni a kɔkiri fla ni a biyɛn jɛni sarakajɛnifɛn kan, i n’a fɔ Matigi Ala k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Nka a sogo tɔ ni a gbolo, a tagara o jɛni kɛnɛ ma Izirayɛlimɔgɔw ta fanibonw* kɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","O kɔ, Haruna ka saraka jɛnita fana kannatigɛ. A dencɛw ka o jori dɔ ta ka o di a ma. A ka o seriseri sarakajɛnifɛn fan bɛɛ kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","O ka o sarakasogo tigɛtigɛ ka o di Haruna ma, ani a kunkolo; a ka o jɛni sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","A k’a kɔnɔfɛnw ni a senw ko, ka olugu jɛni sarakajɛnifɛn kan ni saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","O kɔ, Haruna ka jama bɛɛ ta saraka fana lase Ala ma. Mɔgɔw tun nana ni bakɔrɔnin min ye ka na o kɛ o ta jurumunyafa saraka ye, a ka o mina, k’a kannatigɛ, k’a di saraka ye Matigi Ala ma, i n’a fɔ a tun k’a yɛrɛ ta kɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","A ka jama ta saraka jɛnita mina, misiden ni sagaden, ka o kɛ saraka ye, i n’a fɔ a tun latigɛra cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","A ka siman saraka ta, ka boro ɲa kelen cɛ o ra ka o kɛ sɔgɔmada ta saraka jɛnita kan, ka o jɛni sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","O kɔ, jama tun nana ni misitoran ni sagajigi min ye, ka o kɛ o ta ninsɔndiya saraka ye, Haruna ka o kannatigɛ. A dencɛw ka o jori dɔ ta ka o di a ma; a ka o seriseri sarakajɛnifɛn fan bɛɛ kan k’a lamini. ");
INSERT INTO dyu_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","O ka o misitoran ni o sagajigi turumanyɔrɔw, ni o kukalaw, ni o kɔnɔnɔ turuw, ni o kɔkiriw ni o biyɛnw bɔ o ra, ");
INSERT INTO dyu_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ka o fara disiw kan. Haruna ka o turuw jɛni sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","A ka disiw ta, ani kininboro wotow, ka o fifa Matigi Ala ɲa kɔrɔ, i n’a fɔ Musa tun k’a fɔ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ayiwa, Haruna ka o jurumunyafa saraka, ni o saraka jɛnita, ni o ninsɔndiya saraka bɔ ka ban tuma min na, a k’a boro lawuri ka dugawu kɛ jama bɛɛ ye. O kɔ, a jigira ka bɔ sarakajɛnifɛn kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa ni Haruna donna ɲɔgɔn fɛ Ɲɔgɔnkunbɛn fanibon* kɔnɔ. O bɔra minkɛ, o ka dugawu kɛ jama bɛɛ ye. O kɔ, jama bɛɛ ka Matigi Ala nɔɔrɔ ye. ");
INSERT INTO dyu_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Tasuma dɔ bɔra san fɛ, Matigi Ala fɛ, ka na saraka jɛnitaw ni sogo turuw bɛɛ jɛni sarakajɛnifɛn kan. Jama bɛɛ ka o ye minkɛ, o ka kule ci, ka o ɲa biri dugu ma, ka Matigi Ala bato. ");
INSERT INTO dyu_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Haruna dencɛ minw ye Nadabu ni Abihu ye, lon dɔ olugu ka o ta wusunan dagaw ta, ka takami kɛ a kɔnɔ, ka wusunan kɛ a kan; o ka wusunan don Matigi Ala ɲa kɔrɔ ni tasuma dɔ ye, min tun bɔra yɔrɔ wɛrɛ ra, k’a sɔrɔ o ma bɛn ni Matigi Ala ta kuma ye. ");
INSERT INTO dyu_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","A kɛra ten minkɛ, Matigi Ala ka tasuma lajigi o mɔgɔ fla kan, ka o jɛni ka o faga o yɔrɔnin kelen bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa k’a fɔ Haruna ye o le ra ko: «Matigi Ala yɛrɛ tun ka kankari la aw ye nin ko ra; a ko: ‹Ne b’a fɛ ko ne ta sarakalasebaga minw bɛ ne ta baara kɛ, olugu ye ne ta saninmanya jate, ka bonya la ne kan mɔgɔw bɛɛ ɲa na.› » Haruna jera, a ma kuma. ");
INSERT INTO dyu_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa ka Haruna facɛ balemacɛ Uziyɛli dencɛw wele, minw ye Misahɛli ni Elisafan ye, k’a fɔ o ye ko: «Aw ye taga aw balemacɛw suw ta ka bɔ yɔrɔ saninman* kɔnɔ, ka taga ni o ye kɛnɛ ma, fanibonw* kɔ fɛ.» ");
INSERT INTO dyu_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Olugu gbarara o suw ra; o ka o ta forokiyasurunw to o kana ka o ta ka taga ni o ye fanibonw kɔ fɛ, i n’a fɔ Musa k’a fɔ o ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musa k’a fɔ Haruna ni a dencɛ fla Elehazari ni Itamari ye, ko: «Aw kana aw kunsigi ɲagaminin to, walama ka aw ta faniw faran nin ko kosɔn; ni o tɛ, aw fana bɛna sa; Matigi Ala ta dimi bɛna se jama fana ma. Matigi Ala ka minw jɛni ka o faga, aw balemaw Izirayɛlimɔgɔw le bɛna olugu su kasi. ");
INSERT INTO dyu_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Aw fana kana bɔ Ɲɔgɔnkunbɛn fanibon* donda ra; ni o tɛ, aw bɛna sa; sabu Matigi Ala ka aw saninya ka aw bla Ala ta baara kama.» Musa ka min fɔ, Haruna ni a dencɛw k’a kɛ ten. ");
INSERT INTO dyu_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Matigi Ala kumana Haruna fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Ele ni i dencɛw, ni aw bɛ don Ɲɔgɔnkunbɛn fanibon* kɔnɔ tuma o tuma, aw kana duvɛn, walama minnifɛn fariman si min; ni o tɛ, aw bɛ sa. O ye sariya wuribari le ye aw ni aw ta duruja nataw bɛɛ fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Aw kana duvɛn walama minnifɛn fariman dɔ min, janko fɛn minw blara danna Ala ye, aw ye se ka olugu faranfasi ka bɔ fɛn tɔw ra, ka fɛn saninyaninw faranfasi ka bɔ fɛn saninyabariw ra fana; ");
INSERT INTO dyu_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ani janko ne ka sariya minw don Musa da ra k’a fɔ aw ye, aw ye se ka Izirayɛlimɔgɔw karan o ra.» ");
INSERT INTO dyu_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa k’a fɔ Haruna ni a dencɛ tɔ fla Elehazari ni Itamari ye ko: «Siman saraka minw jɛnina tasuma ra k’a di Matigi Ala ma saraka ye, o tɔ min tora, aw ye o ta ka o kɛ buru ye, k’a domu sarakajɛnifɛn kɔrɔ, sabu domunifɛn saninman lo; aw ye a domu, aw kana funufɛn kɛ a ra. ");
INSERT INTO dyu_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Aw ka kan k’a domu yɔrɔ saninman* dɔ ra. O saraka minw jɛnina Matigi Ala ye, o saraka tɔ ye ele Haruna ni i dencɛw ninyɔrɔ le ye; Matigi Ala ka o le fɔ ne ye. ");
INSERT INTO dyu_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","«Bɛgan disi ni a woto min fana bɔra Izirayɛlimɔgɔw ta ninsɔndiya saraka ra, min fifara Matigi Ala ɲa kɔrɔ, aw ye o fana domu yɔrɔ saninman dɔ ra. Ele ni i dencɛw ninyɔrɔ le ye o ye. I denmusow fana bɛ se ka o domu ni aw ye. ");
INSERT INTO dyu_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","«Izirayɛlimɔgɔw ka kan ka na ni o woto ni o disi ye, ani turu minw bɛ jɛni tasuma ra k’a di saraka ye Matigi Ala ma. Ni bɛgan disi fifara Matigi Ala ɲa kɔrɔ, ani k’a woto fana fifa Matigi Ala ɲa kɔrɔ, o woto ni o disi bɛna kɛ ele ni i dencɛw ninyɔrɔ ye. O ye sariya wuribari le ye, i n’a fɔ Matigi Ala k’a fɔ cogo min na.» ");
INSERT INTO dyu_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ayiwa, bakɔrɔnin min kɛra jama ta jurumunyafa saraka ye, Musa ka o ko ɲininka, k’a ye ko sarakalasebagaw ka o sogo bɛɛ jɛni tasuma ra. Musa dimina Haruna dencɛ fla kɔrɔ, Elehazari ni Itamari. ");
INSERT INTO dyu_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","A ko o ma: «Mun kosɔn aw ma o jurumunyafa saraka sogo domu yɔrɔ saninman* dɔ ra? O ye fɛn saninyaninba le ye. Matigi Ala ka o di aw ma, ko aw ye jama ta hakɛ bɔ o kunna, ka o ta jurumun kafari o ye, Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","I n’a fɔ a jori ma don Ɲɔgɔnkunbɛn fanibon* kɔnɔ, aw tun ka kan k’a domu yɔrɔ saninman dɔ le ra, i n’a fɔ ne k’a fɔ aw ye cogo min na.» ");
INSERT INTO dyu_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Haruna ka Musa jaabi ko: «A flɛ, Izirayɛlimɔgɔw ka o ta jurumunyafa saraka ni o ta saraka jɛnita bɔ Matigi Ala ɲa kɔrɔ bi. Ayiwa, bɔnɔ min ka ne sɔrɔ, ele yɛrɛ ka o lɔn. Yala bi lon ɲɔgɔn na, ni ne tun ka o jurumunyafa saraka sogo domu, o tun bɛna diya Matigi Ala ye wa?» ");
INSERT INTO dyu_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Haruna ka min fɔ, Musa sɔnna o ma. ");
INSERT INTO dyu_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Matigi Ala kumana Musa ni Haruna fɛ, k’a fɔ o ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«Aw ye a fɔ Izirayɛlimɔgɔw ye ko bɛganw bɛɛ ra, aw bɛ se ka minw sogo domu, ");
INSERT INTO dyu_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","o ye bɛgan minw sen gbɔgɔrɔ cira fla ye, ani o fana bɛ bin ɲimiko fla kɛ; aw bɛ se ka olugu le domu. ");
INSERT INTO dyu_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Nka minw bɛ bin ɲimiko fla kɛ dɔrɔn, walama minw sen gbɔgɔrɔ cira fla ye dɔrɔn, aw man kan ka olugu domu; o ra, aw man kan ka ɲɔgɔmɛ domu, sabu a bɛ bin ɲimiko fla kɛ, nka a sen gbɔgɔrɔ ma ci fla ye; aw ye a sogo jate i n’a fɔ sogo saninyabari. ");
INSERT INTO dyu_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Aw man kan ka farawoɲinan domu, sabu a bɛ bin ɲimiko fla kɛ, nka a sen gbɔgɔrɔ ma ci fla ye; aw ye a sogo jate i n’a fɔ sogo saninyabari. ");
INSERT INTO dyu_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Aw man kan ka sonzannin domu, sabu a bɛ bin ɲimiko fla kɛ, nka a sen gbɔgɔrɔ ma ci fla ye; aw ye a sogo jate i n’a fɔ sogo saninyabari. ");
INSERT INTO dyu_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Aw man kan ka lɛ domu, sabu a sen gbɔgɔrɔ cira fla ye, nka a tɛ bin ɲimiko fla kɛ; aw ye a sogo jate i n’a fɔ sogo saninyabari. ");
INSERT INTO dyu_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","«Aw kana o fɛnw si sogo domu; aw kana maga hali o su ra. Aw ye o sogo jate i n’a fɔ sogo saninyabari.» ");
INSERT INTO dyu_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«Ayiwa, fɛnɲanaman minw bɛ kɔgɔji ra, ani baji ra, ani kɔw ra, aw bɛ se ka o minw domu, o flɛ nin ye: fara ni jinɔmunan bɛ minw na, aw bɛ se ka olugu le domu. ");
INSERT INTO dyu_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Nka fɛnɲanaman o fɛnɲanaman bɛ ji ra, ni fara ni jinɔmunan tɛ a ra, ni a kɛra fɛnɲanaman min o min ye, aw ye o haramuya. ");
INSERT INTO dyu_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Aw ye a haramuya, aw kana a sogo domu. Aw ye hali a su haramuya. ");
INSERT INTO dyu_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Jirafɛn o jirafɛn, ni fara ni jinɔmunan tɛ a ra, aw ka kan ka o haramuya.» ");
INSERT INTO dyu_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«Ayiwa, aw ka kan ka kɔnɔ minw haramuya, ani aw man kan ka minw domu, olugu flɛ nin ye: bɔn, ani dugaba, ani kɔgɔjibɔn, ");
INSERT INTO dyu_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ani kongoduga, ani duga suguya tɔw, ");
INSERT INTO dyu_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ani kankan, ani o kɔnɔ suguya tɔw, ");
INSERT INTO dyu_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ani kɔnɔsogolon, ani gbingbingbɛ, ani jidarakɔnɔ, ani sɛgɛn, ani sɛgɛn suguya tɔw, ");
INSERT INTO dyu_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ani gbingbinfin, ani jɛgɛminakɔnɔ, ani gbingbinba, ");
INSERT INTO dyu_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ani gbingbin fitini, ani kɔnɔdaba, ani dugafin, ");
INSERT INTO dyu_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ani baninkɔnɔ, ani kɔnɔ senjan, ani kɔnɔ kunsigiman, ani tolen.» ");
INSERT INTO dyu_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«Fɛnɲanaman minw bɛ ni sen naani ye, ani o bɛ wuri san fɛ kaman na fana, aw ye olugu bɛɛ haramuya. ");
INSERT INTO dyu_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Nka o fɛnɲanamanw bɛɛ ra, minw kɔfɛsenw ka janjan ni o bɛ digi a kan ka pan, aw bɛ se ka olugu le domu; ");
INSERT INTO dyu_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","o kɔrɔ ye ko aw bɛ se ka tɔnba domu, ani gɛrɛn, ani tonwulen, ani tɔnmisɛn, ani o ɲɔgɔn tɔnw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Nka fɛnɲanaman tɔ min o min bɛ ni sen naani ye, ni o bɛ wuri san fɛ, aw ye o bɛɛ haramuya.» ");
INSERT INTO dyu_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«Ayiwa, ni aw ka o fɛn saninyabariw domu, o bɛ aw lanɔgɔ le. Ni mɔgɔ o mɔgɔ ka maga hali o fɛnw dɔ su ra, o tigi saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ni mɔgɔ o mɔgɔ ka o fɛnw dɔ su ta, o tigi ka kan k’a ta faniw ko; nka a saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","«Sogo o sogo, ni a sen gbɔgɔrɔ ma ci fla ye, ani ni a tɛ bin ɲimiko fla kɛ, aw ye o sogo jate fɛn saninyabari ye. Ni mɔgɔ o mɔgɔ ka maga o dɔ su ra, o tigi saninyabari bɛ to. ");
INSERT INTO dyu_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Sennaanimanfɛn min o min bɛ tagama a sentɛgɛ kan, aw ye o bɛɛ jate fɛn saninyabari ye. Ni mɔgɔ o mɔgɔ ka maga a dɔ su ra, o tigi saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ni mɔgɔ o mɔgɔ ka o fɛnw dɔ su ta, o tigi ka kan k’a ta faniw ko; o tigi saninyabari bɛ to fɔ ka taga wula se. Aw ye o fɛnw bɛɛ jate fɛn saninyabariw ye.» ");
INSERT INTO dyu_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«Fɛnɲanaman minw bɛ fofo o kɔnɔbara kan, aw ka kan ka o minw jate fɛn saninyabari ye, olugu flɛ nin ye: kongoɲinan, ani sokɔnɔɲinan, ani kaganan suguya bɛɛ, ");
INSERT INTO dyu_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ani surandɛrɛ, ani sakɛnɛ, ani kogoro, ani basa, ani nɔnsi. ");
INSERT INTO dyu_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Aw ye o fɛnw bɛɛ jate fɛn saninyabariw ye. Ni mɔgɔ o mɔgɔ ka maga o fɛn dɔ su ra, o tigi saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ni o fɛn dɔ su ka ben fɛn o fɛn kan, o fɛn bɛ jate fɛn saninyabari ye. Ni a su benna minan yiriraman dɔ kɔnɔ, walama fani dɔ kan, walama gbolo dɔ kan, walama bɔrɔ, walama baarakɛminan fɛn o fɛn, aw ka kan ka o fɛn ko; nka a saninyabari bɛ to fɔ ka taga wula se; o kɔ, a bɛ sɔrɔ ka saninya. ");
INSERT INTO dyu_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ni o fɛn su ka ben bɔgɔdaga dɔ kɔnɔ, fɛn o fɛn tun bɛ o bɔgɔdaga kɔnɔ, o bɛ kɛ fɛn saninyabari ye. Aw ka kan ka o bɔgɔdaga ci. ");
INSERT INTO dyu_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ni a kɛra ko ji le tun bɛ o bɔgɔdaga kɔnɔ, ni o ji sera domunifɛn o domunifɛn ma, o domunifɛn bɛ kɛ fɛn saninyabari ye; ni a sera ji minta le ma, o ji minta fana bɛ kɛ fɛn saninyabari ye. ");
INSERT INTO dyu_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ni o fɛn saninyabari su ka ben fɛn o fɛn le kan, o fɛn bɛ kɛ fɛn saninyabari ye. Ni a kɛra burujɛnigba le ye o, walama tobirikɛgba o, aw ka kan k’a ci; sabu a kɛra fɛn saninyabari le ye. Aw ka kan k’a jate fɛn saninyabari le ye. ");
INSERT INTO dyu_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","«Nka ni a fɛn tɔgɔ su ka ben bunun le kɔnɔ, walama kɔlɔn kɔnɔ, o bunun ta ji walama o kɔlɔn ta ji saninyanin bɛ to. Nka mɔgɔ min bɛ a su labɔ ji ra, o tigi saninyabari bɛ to. ");
INSERT INTO dyu_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ni a fɛn tɔgɔ su ka ben siman le kan, siman min bɛna dan, o siman saninyanin bɛ to fana. ");
INSERT INTO dyu_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Nka ni a kɛra ko ji le tun kɛra o siman kan k’a ɲigi, ni o fɛn dɔ su ka ben a ra, o tuma aw ka kan ka o siman jate fɛn saninyabari le ye.» ");
INSERT INTO dyu_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«Ayiwa, aw bɛ se ka fɛnɲanaman minw sogo domu, ni o dɔ ka jufa, ni mɔgɔ o mɔgɔ ka maga o su ra, o tigi saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ni mɔgɔ min fana ka o jufasogo dɔ domu, o tigi ka kan k’a ta faniw ko; nka a saninyabari bɛ to fɔ ka taga wula se. Ni mɔgɔ min fana k’a su ta, o tigi ka kan k’a ta faniw ko; a saninyabari bɛ to fɔ ka taga wula se.» ");
INSERT INTO dyu_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«Fɛn o fɛn bɛ fofo a kɔnɔbara kan, aw ye o bɛɛ haramuya. Aw kana o si domu. ");
INSERT INTO dyu_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Fɛn o fɛn bɛ fofo a kɔnɔbara kan, ani minw bɛ tagama sen naani walama sen caman kan, aw kana olugu si domu; aw ka kan ka o fɛnw haramuya. ");
INSERT INTO dyu_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Aw kana aw yɛrɛ haramuya o fɛn fofotaw si sababu ra, aw kana aw yɛrɛ lanɔgɔ o sababu ra, aw kana a to o fɛnw ye aw kɛ mɔgɔ saninyabariw ye. ");
INSERT INTO dyu_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","«Ne le ye Matigi Ala ye, aw ta Ala. Aw ka kan ka saninya, sabu ne saninyanin lo. O ra, fɛnɲanaman o fɛnɲanaman bɛ fofo, aw kana maga o ra, ka aw yɛrɛ lanɔgɔ ni o fɛnw ye. ");
INSERT INTO dyu_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ne le ye Matigi Ala ye; ne le ka aw labɔ Misiran jamana ra, ka kɛ aw ta Ala ye. O kosɔn aw ye saninya, sabu ne saninyanin lo. ");
INSERT INTO dyu_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","«Nin le ye sogow ni kɔnɔw ni jirafɛnw ta sariyaw ye, ani fɛn minw bɛ fofo dugu ma. ");
INSERT INTO dyu_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ne ka o fɔ aw ye, janko aw ye se ka fɛn saninyaninw, ani fɛn saninyabariw lɔn ka o bɔ ɲɔgɔn na, ani ka fɛn domutaw, ani fɛn domubariw fana lɔn ka o bɔ ɲɔgɔn na.» ");
INSERT INTO dyu_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Kuma Izirayɛlimɔgɔw fɛ, i ye a fɔ o ye, ko ni muso dɔ ka kɔnɔ ta ka jigi dencɛ ra, o muso saninyabari bɛ to fɔ tere wolonfla, i n’a fɔ ni a ka landa ye, a saninyabari bɛ to cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","«A jiginin tere seeginan, o ye den kɛnɛsigi. ");
INSERT INTO dyu_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","O kɔ, a ka kan ka tere bisaba ni tere saba le kɛ ka sɔrɔ ka saninya pewu, ka bɔ a ta jebagatɔya ra. Sani o cɛ, a man kan ka maga fɛn saninyanin si ra, a man kan ka don Ɲɔgɔnkunbɛn fanibon* lu kɔnɔ, fɔ ka taga a ta saninyari wagati dafa. ");
INSERT INTO dyu_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","«Ni muso jigira musoden le ra, a saninyabari bɛ to fɔ tere tan ni naani, i n’a fɔ ni a ka landa ye, a saninyabari bɛ to cogo min na. O kɔ, a ka kan ka tere biwɔɔrɔ ni wɔɔrɔ le kɛ tuun, ka sɔrɔ ka saninya pewu, ka bɔ a ta jebagatɔya ra. ");
INSERT INTO dyu_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«Ayiwa, ni a ta saninyari lonw dafara tuma min na, ni a ka dencɛ le woro walama denmuso, a ye taga ni san kelen sagajigi ye sarakalasebaga fɛ Ɲɔgɔnkunbɛn fanibon donda ra, ka o kɛ saraka jɛnita ye; ani jɛnɛtugani kelen, walama tugani kelen, ka o kɛ jurumunyafa saraka ye. ");
INSERT INTO dyu_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Sarakalasebaga bɛna o kɛ saraka ye Matigi Ala ɲa kɔrɔ, ka o muso ta jurumunw kafari. Ni o kɛra, jori min bɔra a fɛ a jigiwagati ra, a bɛ saninya ka bɔ o ra. Ni muso jigira dencɛ walama denmuso ra, sariya min sigira o ko ra, o le ye nin ye. ");
INSERT INTO dyu_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","«Ayiwa, ni muso min ma se ka sagaden sɔrɔ, o bɛ se ka na ni kongotugani fla ye, walama jɛnɛtugani fitini fla. Kelen ye kɛ saraka jɛnita ye, tɔ kelen ye kɛ jurumunyafa saraka ye. Sarakalasebaga bɛna o kɛ saraka ye Matigi Ala ɲa kɔrɔ, ka muso ta jurumunw kafari; ni o kɛra, a bɛ saninya.» ");
INSERT INTO dyu_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Matigi Ala kumana Musa ni Haruna fɛ, k’a fɔ o ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Ni kuru dɔ ka bɔ mɔgɔ dɔ fari ra, walama warawara, walama ni nɔ gbɛman dɔw ka bɔ a fari ra, k’a kɛ i ko bana minw bɛ mɔgɔ fari cɛn, o ye taga ni o tigi ye sarakalasebaga Haruna fɛ, walama Haruna dencɛ sarakalasebaga dɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Sarakalasebaga bɛ o yɔrɔ flɛ a fari ra. Ni a k’a ye ko a yɔrɔ siw gbɛgbɛnin lo, k’a ye ko a yɔrɔ dunyara dɔɔnin fana, o tuma bana minw bɛ mɔgɔ fari cɛn, o dɔ lo. Ni sarakalasebaga k’a flɛ ka ban, a y’a fɔ ko o tigi saninyanin tɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","«Nka ni a yɔrɔ nugunin lo dɔrɔn, k’a gbɛ, ni a ma dunya, ni a siw ma gbɛgbɛ fana, sarakalasebaga ye o banabagatɔ to a kelen na yɔrɔ dɔ ra fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","A tere wolonflanan, sarakalasebaga ye a flɛ tuun. Ni a k’a ye ko bana ma juguya, ni a fana ma yɛrɛgɛ a fari yɔrɔ bɛɛ ra, sarakalasebaga y’a to a kelen na yɔrɔ dɔ ra fɔ tere wolonfla wɛrɛ tuun. ");
INSERT INTO dyu_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ni o tere wolonfla ka dafa, sarakalasebaga ye a flɛ tuun. Ni a k’a ye ko bana nɔ tununa dɔɔnin, ni a ma yɛrɛgɛ a fari yɔrɔ bɛɛ ra, o tuma sarakalasebaga ye a fɔ ko o tigi saninyara, ko warawara dɔrɔn tun lo. Banabagatɔ ye a ta faniw ko; o kɔ, a bɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","«Nka ni sarakalasebaga k’a flɛ, k’a bla ka taga, ko a kɛnɛyara, ni bana ka taga juguya, a ka kan ka kɔsegi ka na a yɛrɛ yira sarakalasebaga ra. ");
INSERT INTO dyu_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Sarakalasebaga bɛna a flɛ kokura tuun. Ni a k’a ye ko bana juguyara a fari ra, a ye a fɔ ko o tigi saninyanin tɛ; bana minw bɛ mɔgɔ fari cɛn, o dɔ lo.» ");
INSERT INTO dyu_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Bana minw bɛ mɔgɔ fari cɛn, ni o dɔ ka mɔgɔ dɔ mina, aw ye taga ni o tigi ye sarakalasebaga fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Sarakalasebaga ye a tigi flɛ. Ni a k’a ye ko kuru min bɛ a fari ra, ko o gbɛnin lo, k’a ye fana ko o yɔrɔ siw gbɛgbɛnin lo, ko jori ɲa wulennin lo, ");
INSERT INTO dyu_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","o tuma o bana ye bana kɔrɔ le ye a farisogo ra. Sarakalasebaga y’a fɔ ko a saninyanin tɛ. Sarakalasebaga kana a fɔ ko a bɛ a to a kelen na yɔrɔ dɔ ra tuun, sabu sigiya t’a ra, a tigi saninyanin tɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","«Nka ni sarakalasebaga k’a ye ko kurukuruw bɔra a fari yɔrɔ bɛɛ le ra, k’a ta a kun na ka taga a bla fɔ a sentɛgɛ ra, o tuma sarakalasebaga ye a flɛ ka ɲa kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Ni a k’a ye ko o bana k’a fari yɔrɔ bɛɛ le mina, a y’a fɔ ko o banabagatɔ saninyanin lo; a saninyanin lo, sabu a fari gbɛgbɛra dɔrɔn le. ");
INSERT INTO dyu_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","«Nka ni jori nana ye a fari ra lon min na, o tuma a saninyanin tɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Sarakalasebaga bɛna o joriw flɛ, k’a fɔ ko a saninyanin tɛ. O joriw saninyanin tɛ; bana minw bɛ mɔgɔ fari cɛn, o dɔ lo. ");
INSERT INTO dyu_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Nka ni jori da nana gbɛ, a ye kɔsegi ka taga sarakalasebaga fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Sarakalasebaga bɛna a flɛ. Ni a k’a ye ko can ra, a fari yɔrɔ minw tun wulenna, ko olugu gbɛgbɛra tuun, a y’a fɔ ko o bana banna, sabu a fari gbɛra. O tuma a saninyara.» ");
INSERT INTO dyu_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Ayiwa, ni sumuni bɔra mɔgɔ dɔ fari ra, ni a nana kɛnɛya, ");
INSERT INTO dyu_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ni o kɔ kuru gbɛman dɔ nana wuri o sumuni nɔ ra, walama ni o sumuni nɔ nugura, k’a yɔrɔ gbɛ, walama k’a yɔrɔ wulen, o tigi ye taga a yɛrɛ yira sarakalasebaga ra. ");
INSERT INTO dyu_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Sarakalasebaga bɛna a yɔrɔ flɛ. Ni a k’a ye ko a yɔrɔ dunyara dɔɔnin, ani k’a yɔrɔ siw gbɛgbɛ, sarakalasebaga y’a fɔ ko o tigi saninyanin tɛ. Bana minw bɛ mɔgɔ fari cɛn, o dɔ le wurira sumuni nɔ ra ten. ");
INSERT INTO dyu_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","«Nka ni sarakalasebaga k’a flɛ, k’a ye ko a yɔrɔ siw ma gbɛgbɛ, ni a yɔrɔ ma dunya fana, ni a nɔ tununa dɔɔnin, sarakalasebaga ye o tigi to a kelen na yɔrɔ dɔ ra fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","O kɔ, ni a k’a flɛ k’a ye ko bana k’a fari yɔrɔ bɛɛ mina, sarakalasebaga y’a fɔ ko a saninyanin tɛ. Bana minw bɛ mɔgɔ fari cɛn, o dɔ lo. ");
INSERT INTO dyu_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Nka ni a nɔ tora a cogo ra, ni a m’a fari yɔrɔ bɛɛ mina, o tuma, sumuni le jara; a nɔ dɔrɔn lo. Sarakalasebaga ye a fɔ ko o tigi saninyanin lo.» ");
INSERT INTO dyu_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Ni tasuma ka mɔgɔ dɔ jɛni, ni a sumana, nka ni a nɔ gbɛra, walama k’a wulen dɔɔnin, ");
INSERT INTO dyu_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","sarakalasebaga ye a yɔrɔ flɛ. Ni a k’a ye ko o tasumajɛnida yɔrɔ siw gbɛgbɛra, k’a dunya dɔɔnin, o tuma bana minw bɛ mɔgɔ fari cɛn, o dɔ le daminana o tasumajɛnida nɔ ra. O ra, sarakalasebaga y’a fɔ ko o tigi saninyanin tɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","«Nka ni sarakalasebaga k’a flɛ k’a ye ko a yɔrɔ siw ma gbɛgbɛ, ni a yɔrɔ dunyara dɔɔnin, nka ni a nɔ tununa dɔɔnin, o tuma, sarakalasebaga y’a to a kelen na yɔrɔ dɔ ra fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","A tere wolonflanan lon, sarakalasebaga ye a flɛ tuun. Ni a k’a ye ko bana juguyara a fari ra, sarakalasebaga ye a fɔ ko a saninyanin tɛ. Bana minw bɛ mɔgɔ fari cɛn, o dɔ lo. ");
INSERT INTO dyu_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","«Nka ni a nɔ tora a cogo ra, ni a m’a fari yɔrɔ bɛɛ mina, ni a nɔ yɛrɛ tununa dɔɔnin, o tuma tasumajɛnida nɔ dɔrɔn lo. Sarakalasebaga ye a fɔ ko a saninyanin lo, sabu tasumajɛnida dama lo.» ");
INSERT INTO dyu_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Ni kaba bɔra cɛ walama muso dɔ kun na, walama a bonbonkun na, ");
INSERT INTO dyu_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","sarakalasebaga ye o kaba flɛ. Ni a k’a ye ko a nɔ dunyara dɔɔnin, k’a yɔrɔ siw kɛ fitini fitini nɛrɛmuguman ye, sarakalasebaga y’a fɔ ko o tigi saninyanin tɛ. Kaba lo; bana minw bɛ mɔgɔ fari cɛn, o dɔ le wurira a kunkolo walama a bonbonkun na. ");
INSERT INTO dyu_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Nka ni a k’a flɛ k’a ye ko a yɔrɔ ma dunya, ko a yɔrɔ siw ma finfin, sarakalasebaga y’a to a kelen na yɔrɔ dɔ ra fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","A tere wolonflanan lon, sarakalasebaga ye a flɛ tuun. Ni a k’a ye ko kaba m’a fari yɔrɔ bɛɛ mina, ni a yɔrɔ siw ma kɛ nɛrɛmuguman ye fana, ni a yɔrɔ fana ma dunya, ");
INSERT INTO dyu_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","o banabagatɔ ka kan k’a kun walama a bonbosi li. Nka kaba bɛ yɔrɔ minw na, a kana o li. O kɔ, sarakalasebaga y’a to a kelen na tuun tere wolonfla wɛrɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ni tere wolonfla ka dafa, sarakalasebaga ye a flɛ tuun. Ni kaba ma yɔrɔ bɛɛ mina, ni a nɔ ma dunya fana, a ye a fɔ ko o banabagatɔ saninyanin lo. A ka kan k’a ta faniw dɔrɔn le ko; o kɔ, a bɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","«Nka ni sarakalasebaga ko a saninyara, k’a bla ka taga, ni o kaba tagara juguya, a ka kan ka kɔsegi ka na janko sarakalasebaga ye a flɛ tuun. ");
INSERT INTO dyu_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Ni a k’a ye ko kaba k’a fari yɔrɔ bɛɛ mina ka ban, kun tɛ a ra tuun ko a y’a flɛ ni o yɔrɔ siw kɛra nɛrɛmuguman ye, sabu sigiya t’a ra, o tigi saninyanin tɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Nka ni sarakalasebaga k’a ye ko bana ma taga ɲa, ni a yɔrɔ siw ka kɛ bɔ ye tuun, o tuma o kaba kɛnɛyara; o tigi fana saninyara. O tuma sarakalasebaga ye a fɔ ko a saninyara.» ");
INSERT INTO dyu_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Ayiwa, ni nɔ gbɛman dɔw ka bɔ cɛ, walama muso dɔ fari ra, ");
INSERT INTO dyu_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","sarakalasebaga bɛna o tigi flɛ. Ni a k’a ye ko a yɔrɔ nugunin lo k’a gbɛ dɔɔnin, o tuma kurukuru dɔrɔn le wurira a fari ra. A saninyanin lo.» ");
INSERT INTO dyu_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Ni mɔgɔ dɔ kun cɛmancɛyɔrɔ siw bɛɛ bɔnna, a kun le wulanna; a saninyanin lo. ");
INSERT INTO dyu_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ni a kun ɲafɛyɔrɔ siw le bɔnna, o tuma a kun ɲafɛyɔrɔ le wulanna dɔrɔn; a saninyanin lo. ");
INSERT INTO dyu_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","«Nka ni kuru dɔ ka bɔ o wulanyɔrɔ ra, ka wulen, ni a kɛra kun cɛmancɛ le ra, walama tenda ra, o tuma bana minw bɛ mɔgɔ fari cɛn, o dɔ le bɛ wurira a kun wulanyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Sarakalasebaga ye a yɔrɔ flɛ. Ni a ka kuru dɔ ye a kun wulanyɔrɔ ra min wulenna, k’a kɛ i ko bana min bɛ mɔgɔ fari cɛn, ");
INSERT INTO dyu_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","o tuma i b’a sɔrɔ o bana dɔ lo; a saninyanin tɛ. Sarakalasebaga ye a fɔ ko o bana min bɛ a kunkolo ra ko o kosɔn a saninyanin tɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Ayiwa, ni o faricɛnbana dɔ bɛ mɔgɔ dɔ ra, o tigi ka kan ka fani faranninw le don. A ka kan k’a kunsigi ɲagaminin to a kun na. A ye fɛn dɔ kɛ k’a ɲa dugumayɔrɔ datugu, ka to ka pɛrɛn k’a fɔ ko: ‹Ne saninyanin tɛ! Ne saninyanin tɛ!› ");
INSERT INTO dyu_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","A saninyabari bɛna to fɔ ka taga a ta bana ban. O kosɔn a ka kan ka to a danna kɛnɛ ma fanibonw kɔ fɛ, k’a yɛrɛ mabɔ mɔgɔw ra.» ");
INSERT INTO dyu_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Ni sumaya sera fani donta dɔ ma ka nɔ bla a ra, ni a kɛra sagasifani le ye, walama lɛnfani, ");
INSERT INTO dyu_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","walama ni a sera fanimugu dɔ le ma, walama derege dɔ, min ye lɛnfani ye walama sagasi, walama ni a sera gbolo dɔ le ma, walama fɛn gboloraman dɔ, ");
INSERT INTO dyu_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ni a nɔ kɛra binkɛnɛman, walama wulenman, o tuma o fani walama o gbolo cɛnna le. O ka kan k’a yira sarakalasebaga ra. ");
INSERT INTO dyu_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Sarakalasebaga ye a nɔ flɛ. O kɔ, a ye o fɛn bla bon kɔnɔ ka da sɔgɔ a da ra fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","A tere wolonflanan, a ye a nɔ flɛ tuun. Ni a k’a ye ko a nɔ bonyara, o tuma o fani walama o gbolo cɛnna le. Fɛn saninyabari lo. ");
INSERT INTO dyu_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Sarakalasebaga ka kan k’a jɛni. Ni a kɛra fanimugu le ye, walama derege, min ye lɛnfani ye, walama sagasi, walama fɛn gboloraman dɔ ye, a ka kan ka a bɛɛ jɛni tasuma ra, sabu a cɛnna. ");
INSERT INTO dyu_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","«Nka ni sarakalasebaga k’a flɛ tere wolonfla kɔ fɛ, k’a ye ko nɔ min tun bɛ o fɛn na, ko o nɔ ma bonya, ");
INSERT INTO dyu_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","o tuma a y’a fɔ ko o ye a ko; o kɔ, a ye a bla bon kɔnɔ ka da sɔgɔ a da ra tuun fɔ tere wolonfla wɛrɛ. ");
INSERT INTO dyu_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ayiwa, ni sarakalasebaga nana a flɛ o tere wolonfla kɔ, k’a ye ko nɔ bɛ a cogo ra, hali ni a nɔ ma bonya, o fɛn saninyanin tɛ. Ni a kɔ le cɛnna o, walama ni a ɲa le cɛnna o, a ye a jɛni. ");
INSERT INTO dyu_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","«Nka ni sarakalasebaga k’a flɛ, k’a ye ko a konin kɔ o nɔ bɔra a ra dɔɔnin, ni a kɛra fanimugu le ye o, walama a derege o, walama fɛn gboloraman dɔ, a ye o yɔrɔ tigɛ ka bɔ a ra. ");
INSERT INTO dyu_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","«Ayiwa, o kɔ fɛ, ni nɔ nana ye o fani donta ra, walama o fanimugu ra, walama o derege ra, walama o fɛn gboloraman ra tuun, o tuma a cɛnna le tuun. Aw ye a jɛni tasuma ra. ");
INSERT INTO dyu_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","«Ni nɔ ka kɛ fani o fani na, k’a cɛn, ni a kɛra fanimugu le ye, walama derege, walama fɛn gboloraman dɔ, ni o k’a ko, ni nɔ bɔra a ra, o ka kan k’a ko tuun. Ni o kɛra, a bɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","«Ayiwa, nɔ minw bɛ kɛ fanidontaw ra, ni a kɛra sagasifani le ye o, lɛnfani o, walama fanimugu, walama derege, walama fɛn gboloraman dɔ, o sariya le ye nin ye. Nin sariyaw le b’a to aw bɛ se k’a lɔn ko o fɛnw saninyara walama ko o ma saninya.» ");
INSERT INTO dyu_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Bana minw bɛ mɔgɔ fari cɛn, ni o dɔ tun bɛ mɔgɔ dɔ ra, ni a tigi kɛnɛyara, a ta saninyari ka kan ka kɛ cogo min na, o flɛ nin ye: a fɔlɔ, o ye na ni a ye sarakalasebaga fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Sarakalasebaga bɛ bɔ ni a ye fanibonw kɔ fɛ, ka taga a flɛ. Ni a k’a ye ko a kɛnɛyara can ra, ");
INSERT INTO dyu_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","a y’a fɔ a ye ko a ye na ni kɔnɔ fla ye, minw ɲanaman lo, a ta saninyari kosɔn, kɔnɔ minw saninyanin lo, ani sɛdiriyiri, ani jese wulenman, ani izope flaburu. ");
INSERT INTO dyu_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Sarakalasebaga b’a fɔ ko o ye kɔnɔ kelen kannatigɛ, k’a jori kɛ jiɲuman dɔ ra, bɔgɔdaga dɔ kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","O kɔ, sarakalasebaga bɛ kɔnɔ ɲanaman mina, ani sɛdiriyiri, ani jese wulenman, ani izope flaburu; kɔnɔ min kannatigɛra k’a jori kɛ bɔgɔdaga kɔnɔ, jiɲuman na, a ye o fɛnw ni kɔnɔ ɲanaman su o jori ra. ");
INSERT INTO dyu_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Banabagatɔ min ka kan ka saninya, a ye a seriseri ale kan siɲaga wolonfla. Ni o kɛra, sarakalasebaga ye a fɔ ko a saninyara. O kɔ, a ye kɔnɔ ɲanaman bla ka taga kongo kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«Banabagatɔ min bɛ saninyara, ale ka kan k’a ta faniw ko, k’a fari siw bɛɛ li, k’a yɛrɛ ko fana ka sɔrɔ ka saninya. O kɔ, a bɛ se ka don dugu kɔnɔ. Nka a ka kan ka tere wolonfla kɛ ka sɔrɔ ka don a ta fanibon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","A tere wolonflanan, a ye a fari siw bɛɛ li tuun, a kun ni a bonbosi, ani a ɲasiw bɛɛ. O kɔ, a ye a ta faniw ko, k’a yɛrɛ ko fana. Ni o kɛra, a bɛ sɔrɔ ka saninya pewu. ");
INSERT INTO dyu_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«A tere seeginan, a ye na ni sagaden cɛman fla ye, fiyɛn tɛ minw na, ani sagaden musoman kelen, min si ye san kelen ye, ani fiyɛn tɛ min na. A ye mugu tɛntɛnnin kilo kɔnɔntɔn ta ka o nɔɔni turu ra, ani turu litiri tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Sarakalasebaga min bɛ saninyari kɛ, ale bɛ taga ni banabagatɔ ni o fɛnw bɛɛ ye Matigi Ala ɲa kɔrɔ Ɲɔgɔnkunbɛn fanibon* donda ra. ");
INSERT INTO dyu_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Sarakalasebaga ye na ni sagaden cɛman kelen ye, ka o kɛ hakɛbɔ saraka ye, ka turu litiri tarancɛ fara o kan. A bɛ o saraka fifa Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Jurumunyafa saraka ni saraka jɛnitaw bɛ kannatigɛ yɔrɔ min na, yɔrɔ saninman* kɔnɔ, a ka kan ka saga kannatigɛ o yɔrɔ le ra. Jurumunyafa saraka ye sarakalasebaga ta ye cogo min na, hakɛbɔ saraka fana ye a ta ye o cogo le ra; sabu saraka lo min saninyanin lo kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","«Mɔgɔ min ka kan ka saninya, sarakalasebaga ye hakɛbɔ saraka jori dɔ ta k’a mun o tigi kininboroyanfan toro nunkun na, ani a kininboroyanfan borokandenba ni a senmandenba. ");
INSERT INTO dyu_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","O kɔ, sarakalasebaga ye turu dɔɔnin kɛ a yɛrɛ numanboro tɛgɛ kɔnɔ, ");
INSERT INTO dyu_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","k’a kininboro borokanden su o turu ra a numanboro tɛgɛ kɔnɔ, k’a seriseri siɲaga wolonfla Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","O kɔ, turu tɔ min tora a borotɛgɛ kɔnɔ, a bɛ o mun a tigi kininboroyanfan toro nunkun na, ani a kininboroyanfan borokandenba ni a senmandenba, a tun kɔnna ka hakɛbɔ saraka jori mun o yɔrɔ minw na. ");
INSERT INTO dyu_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ayiwa, turu tɔ min tora sarakalasebaga borotɛgɛ kɔnɔ, a ye o kɛ banabagatɔ kun na, janko k’a ta jurumun kafari a ye Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","«O kɔ, sarakalasebaga ye jurumunyafa saraka bɔ, janko min bɛ saninyara ka bɔ a ta bana ra, ka o tigi ta jurumun kafari, k’a saninya. O kɔ, sarakalasebaga ye saraka jɛnita kannatigɛ; ");
INSERT INTO dyu_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","a bɛ o saraka kuturu bɛɛ jɛni ni siman saraka ye, sarakajɛnifɛn kan Matigi Ala ɲa kɔrɔ. Sarakalasebaga ye a ta jurumun kafari a ye; ni o kɛra, a bɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Ayiwa, ni a kɛra ko fɛn tɛ banabagatɔ boro, fɛn minw fɔra, ni o bɛɛ se ma kɛ a ye, o tuma a ye na ni sagaden cɛman kelen dɔrɔn ye, ka na o kɛ hakɛbɔ saraka ye. O bɛ o saraka fifa Matigi Ala ɲa kɔrɔ, ka o kɛ k’a ta jurumun kafari. A bɛ mugu tɛntɛnnin kilo saba dɔrɔn ta, ka o nɔɔni turu ra, ka o kɛ siman saraka ye, ani turu litiri tarancɛ. ");
INSERT INTO dyu_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","A ye na ni tugani fla ye, walama jɛnɛtugani fla, ka kaɲa ni a seko ye. Kelen ye kɛ jurumunyafa saraka ye, tɔ kelen ye kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","«A ta saninyari tere seeginan, a ye na ni o fɛnw bɛɛ ye sarakalasebaga fɛ Ɲɔgɔnkunbɛn fanibon* donda ra, Matigi Ala ɲa kɔrɔ, ka na a ta saninyari dafa. ");
INSERT INTO dyu_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Sarakalasebaga ye sagaden cɛman ta, ka o kɛ hakɛbɔ saraka ye, ani turu litiri tarancɛ. A ye o fifa Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","O kɔ, a ye hakɛbɔ saraka ta saga kannatigɛ, ka o saraka jori dɔ ta k’a mun banabagatɔ kininboroyanfan toro nunkun na, ani a kininboroyanfan borokandenba, ni a senmandenba. ");
INSERT INTO dyu_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Sarakalasebaga ye turu dɔ ta, ka dɔɔnin kɛ a yɛrɛ numanboro tɛgɛ kɔnɔ, ");
INSERT INTO dyu_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","k’a kininboroyanfan borokanden su a ra k’a seriseri Matigi Ala ɲa kɔrɔ siɲaga wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","O kɔ, sarakalasebaga ye o turu dɔɔnin ta ka o mun a tigi kininboroyanfan toro nunkun na, ani a kininboroyanfan borokandenba ni a senmandenba ra, a tun kɔnna ka hakɛbɔ saraka jori mun yɔrɔ minw na. ");
INSERT INTO dyu_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ayiwa, turu tɔ min tora sarakalasebaga borotɛgɛ kɔnɔ, a ye o kɛ a tigi kun na, janko k’a ta jurumun kafari Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","O kɔ, a sera ka na ni tugani minw ye walama jɛnɛtuganiw, sarakalasebaga ye kelen bɔ o ra, ");
INSERT INTO dyu_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ka o kɛ jurumunyafa saraka ye, ka tɔ kelen kɛ saraka jɛnita ye. A ye o kɛ saraka ye, ka siman saraka dɔ fara o kan, k’a ta jurumun kafari Matigi Ala ɲa kɔrɔ. Ni o kɛra, a bɛna saninya. ");
INSERT INTO dyu_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","«Ayiwa, bana minw bɛ mɔgɔ fari cɛn, ni o dɔ ka mɔgɔ dɔ mina, ni o tigi kɛnɛyara, k’a sɔrɔ saraka min yirara, cogo tɛ a boro ka o bɛɛ bɔ, ale bɛ se k’a yɛrɛ saninya cogo min na, o sariya le ye nin ye.» ");
INSERT INTO dyu_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Matigi Ala kumana Musa ni Haruna fɛ tuun k’a fɔ o ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Ne bɛna Kanaana jamana min di aw ma k’a kɛ aw ta ye, ni aw tagara se yi tuma min na, ni ne nana sumaya yɛlɛn aw ta bon kogo kan o jamana ra, ka nɔ bla a ra, ");
INSERT INTO dyu_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","o bontigi ye taga sarakalasebaga fɛ ka taga a fɔ a ye ko: ‹Ne ka nɔ dɔ ye ne ta bon kogo kan, a bɛ i n’a fɔ sumaya le yɛlɛnna a kan.› ");
INSERT INTO dyu_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Sarakalasebaga b’a fɔ a ye ko a ye taga a ta bonkɔnɔfɛnw bɛɛ labɔ kɛnɛ ma, sani ale ye don ka taga o nɔ flɛ. O ra, fɛn o fɛn tun bɛ bon kɔnɔ, o si tɛ jate fɛn saninyabari ye. Ni o fɛnw bɛɛ labɔra, sarakalasebaga bɛ don bon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ni sarakalasebaga ka o nɔw flɛ, ni a k’a ye ko nɔw kɛra binkɛnɛman, walama wulenman, k’a yɔrɔ kɛ dinga ye kogo ra, ");
INSERT INTO dyu_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","sarakalasebaga bɛ bɔ bon kɔnɔ, k’a fɔ o ye ko o ye bon da sɔgɔ fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ni tere wolonfla dafara, sarakalasebaga bɛ kɔsegi ka taga a flɛ tuun. Ni a k’a ye ko nɔw cayara kogo ra, ");
INSERT INTO dyu_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","a ye a fɔ o ye ko sumaya yɛlɛnna bon kabakuru min o min na, ko o ye o bɛɛ labɔ ka taga o firi dugu kɔ fɛ, yɔrɔ saninyabari dɔ ra; ");
INSERT INTO dyu_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","o ye bon kɔnɔnɔyɔrɔ kogo bɛɛ siyan, k’a bɔgɔ cɛ ka taga a firi dugu kɔ fɛ, yɔrɔ saninyabari dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","O kɔ, o ye kabakuru wɛrɛw ta ka o don kɔrɔmanw nɔ ra, ka bɔgɔ dɔ wɛrɛ kɛ ka bon bari. ");
INSERT INTO dyu_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ayiwa, o kabakuru bɔnin kɔ bon na, k’a kogow siyan, k’a bari kura ye, ni sumaya belen donna bon na tuun ka nɔ kɛ a ra, ");
INSERT INTO dyu_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","sarakalasebaga ka kan ka taga bon flɛ tuun. Ni a k’a ye ko nɔw yɛrɛgɛra ka don bon kogow ra tuun, o tuma bon cɛnna ka ban le; bon saninyanin tɛ. ");
INSERT INTO dyu_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","O ka kan ka o bon ci le, k’a kabakuruw ni a yiriw ni a bɔgɔ bɛɛ cɛ ka taga a firi dugu kɔ fɛ yɔrɔ saninyabari dɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","«Ayiwa, ka o bon da sɔgɔnin to fɔ tere wolonfla, ni mɔgɔ o mɔgɔ k’a dayɛlɛ ka don a kɔnɔ, o tigi saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ni mɔgɔ o mɔgɔ k’a da yɛlɛ ka don ka la a kɔnɔ, walama ka domuni kɛ a kɔnɔ, o tigi ye a ta faniw ko. ");
INSERT INTO dyu_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Nka bon barinin kɔ, ni sarakalasebaga k’a flɛ k’a ye ko sumaya ma yɛlɛn a kan tuun ka nɔ bla a ra, o tuma sarakalasebaga ye a fɔ ko o bon saninyanin lo; sabu sumaya tun ka nɔ minw bla a ra, o bɛɛ banna pewu. ");
INSERT INTO dyu_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","O tuma sarakalasebaga ye kɔnɔ fla mina, ani sɛdiriyiri, ani jese wulenman ni izope flaburu, ka bon saninya ni o ye. ");
INSERT INTO dyu_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","A ye kɔnɔ kelen kannatigɛ k’a jori kɛ jiɲuman na bɔgɔdaga dɔ kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","A bɛ sɛdiriyiri ta, ani izope flaburu, ani jese wulenman, ani kɔnɔ ɲanaman; kɔnɔ min kannatigɛra, a ye o fɛnw su o jori ra, ani jiɲuman na, k’a seriseri bon kan siɲaga wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","O cogo ra, a bɛna o bon saninya ni kɔnɔ jori ye, ani jiɲuman, ani kɔnɔ ɲanaman, ani sɛdiriyiri, ani izope flaburu ni jese wulenman. ");
INSERT INTO dyu_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","O kɔ, a ye kɔnɔ ɲanaman bla, a ye bɔ dugu kɔnɔ ka taga kongo kɔnɔ. A bɛna jurumun kafari kɛ o cogo le ra ka bon saninya. Ni o kɛra, bon bɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","«Ayiwa, bana minw bɛ mɔgɔ fari cɛn, o sariya le ye nin ye, ani kaba, ");
INSERT INTO dyu_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ani ni sumaya donna fani na, walama bon, ");
INSERT INTO dyu_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ani kurukuruw, ani warawara, ani nɔ gbɛman minw bɛ bɔ mɔgɔ fari ra; o sariyaw le ye nin ye. ");
INSERT INTO dyu_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","O sariyaw le bɛ a yira ni fɛn saninyara walama ni a ma saninya. O banaw ta sariyaw le ye nin ye.» ");
INSERT INTO dyu_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Matigi Ala kumana Musa ni Haruna fɛ, ");
INSERT INTO dyu_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","ko o y’a fɔ Izirayɛlimɔgɔw ye, ko: «Ni damajalan ka cɛ mina, k’a kɛ ko nɛɛn bɛ bɔn a yɛrɛ ma, o nɛɛn bɛ o tigi lanɔgɔ. ");
INSERT INTO dyu_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ni a kɛra ko o nɛɛn bɛ bɔnna le, walama ni a k’a ta ɲɛgɛnɛkɛyɔrɔ le datugu, ni a kɛra min o min ye, o tigi ma saninya. ");
INSERT INTO dyu_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","O kosɔn ni o tigi ka la fɛn o fɛn kan, walama ni a ka sigi fɛn o fɛn kan, o fɛn bɛ kɛ fɛn saninyabari ye. ");
INSERT INTO dyu_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ni mɔgɔ min fana ka maga a ta lanan na, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko fana. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ni mɔgɔ min ka sigi a sigiyɔrɔ ra, o tigi fana ka kan k’a ta faniw ko, k’a yɛrɛ fana ko. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ni mɔgɔ min ka maga o cɛ banabagatɔ ra, o tigi fana ka kan k’a ta faniw ko, k’a yɛrɛ ko. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ni a daji ka se mɔgɔ saninyanin min ma, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ni a ka sigi kirike o kirike kan ka taga tagama ra, o kirike saninyabari bɛ to. ");
INSERT INTO dyu_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Ni fɛn o fɛn blara banabagatɔ kɔrɔ, a ye la a kan walama a ye sigi a kan, ni mɔgɔ min ka maga o fɛn na, o tigi saninyabari bɛ to fɔ ka taga wula se. Ni mɔgɔ min ka o fɛn ta, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ni banabagatɔ tɛgɛkobari ka maga mɔgɔ o mɔgɔ ra, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ni banabagatɔ ka maga bɔgɔdaga min na, o bɔgɔdaga ka kan ka ci. Ni a magara minan yiriraman dɔ le ra, o ka kan ka ko ni ji ye kosɛbɛ k’a gbɛ. ");
INSERT INTO dyu_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«Ayiwa, ni a nana kɛ ko o cɛ ta nɛɛn tɛ bɔnna tuun, a ka kan ka lɔgɔkun kelen le kɛ, ka sɔrɔ ka saninya pewu. A ka kan k’a ta faniw ko, k’a yɛrɛ ko ni jiɲuman ye. Ni o kɛra, a bɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","A tere seeginan, a ka kan ka jɛnɛtugani fla, walama sokɔnɔtugani fla ɲini, ka taga ni o ye sarakalasebaga fɛ, Matigi Ala ɲa kɔrɔ, Ɲɔgɔnkunbɛn fanibon* donda ra. ");
INSERT INTO dyu_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Sarakalasebaga bɛna tugani kelen kɛ jurumunyafa saraka ye, ka tɔ kelen kɛ saraka jɛnita ye. O cogo ra, sarakalasebaga bɛ a saninya Matigi Ala ɲa kɔrɔ, ka bɔ a ta bana ra. ");
INSERT INTO dyu_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«Ayiwa, ni lawa bɛ bɔn cɛ fɛ, k’a sɔrɔ bana tɛ a ra, a ka kan k’a yɛrɛ ko ka gbɛ. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Lawa sera birifani min ma, walama fɛn gboloraman min ma, o ka kan ka ko. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","«Ni cɛ ni muso ka jɛn ni ɲɔgɔn ye, o fla bɛɛ ka kan ka ko. O saninyabari bɛ to fɔ ka taga wula se.» ");
INSERT INTO dyu_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«Ni muso bɛ landa ra, a saninyabari bɛ to fɔ lɔgɔkun kelen. Ni mɔgɔ o mɔgɔ ka maga a ra, o tigi saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ni a ka la fɛn o fɛn kan, walama ni a ka sigi fɛn o fɛn kan a ta landa wagati ra, o fɛn bɛ kɛ fɛn saninyabari ye. ");
INSERT INTO dyu_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ni mɔgɔ o mɔgɔ ka maga a ta lanan na, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ni o muso sigira fɛn o fɛn kan, ni mɔgɔ min ka maga o fɛn na, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Fɛn minw tun bɛ a ta lanan walama a ta siginan kan, ni mɔgɔ o mɔgɔ ka maga o fɛn dɔ ra, o tigi saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ni cɛ min ka jɛn ni o muso ye, k’a to landa ra, muso ta saninyabariya bɛ yɛlɛma o cɛ fɛ. O cɛ fana saninyabari bɛ to fɔ lɔgɔkun kelen. Ni o cɛ ka la lanan o lanan kan, o lanan saninyabari bɛ to. ");
INSERT INTO dyu_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«Ni jori ka bɔn muso dɔ fɛ ka tere dama kɛ, k’a sɔrɔ a ta landa wagati tɛ, walama ni a ta landa wagati le nana janya ka tɛmɛ a cogokɔrɔ kan, o wagati bɛɛ ra, a saninyabari bɛ to, i n’a fɔ a ta landa wagati ra. ");
INSERT INTO dyu_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ni a ka la lanan o lanan kan, walama ni a ka sigi siginan o siginan kan, o fana saninyabari bɛ to, i n’a fɔ a ta landa wagati ra. ");
INSERT INTO dyu_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ni mɔgɔ o mɔgɔ ka maga o lanan walama o siginan na, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko fana. A saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«Ni o jori nana lɔ, muso ka kan ka tere wolonfla kɛ ka sɔrɔ ka saninya tuun. ");
INSERT INTO dyu_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","A tere seeginan, a ka kan ka jɛnɛtugani fla, walama sokɔnɔtugani fla ɲini ka taga ni o ye sarakalasebaga fɛ, Ɲɔgɔnkunbɛn fanibon* donda ra. ");
INSERT INTO dyu_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Sarakalasebaga bɛna tugani kelen kɛ jurumunyafa saraka ye, ka tɔ kelen kɛ saraka jɛnita ye. O cogo ra, sarakalasebaga bɛ a saninya Matigi Ala ɲa kɔrɔ ka bɔ a ta joribɔn na. ");
INSERT INTO dyu_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«Ayiwa, aw ye a fɔ Izirayɛlimɔgɔw ye ko wagati min ni o saninyanin tɛ, o kana gbara ne Ala ta yɔrɔ saninman* na, janko o Ɲɔgɔnkunbɛn fanibon min bɛ a yira ko ne bɛ aw cɛ ra, o kana na o lanɔgɔ o ta saninyabariya kosɔn, k’a to ne ye o faga. ");
INSERT INTO dyu_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","«Ayiwa, ni damajalan ka cɛ mina k’a kɛ ko nɛɛn bɛ bɔn a fɛ, walama ni lawa bɛ bɔn a fɛ k’a sɔrɔ bana tɛ a ra, k’a lanɔgɔ, o sariyaw le ye nin ye; ");
INSERT INTO dyu_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ani ni muso bɛ landa ra, walama ni cɛ ka jɛn ni muso ye k’a sɔrɔ muso saninyabari lo, o sariyaw le ye nin ye.» ");
INSERT INTO dyu_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ayiwa, Haruna dencɛ fla tun sara, sabu olugu tun ka wusunan don ni tasuma min ye Matigi Ala ɲa kɔrɔ, o cogo tun ma bɛn ni Matigi Ala ta sariya ye. Ayiwa, olugu ta saya kɔ fɛ, Matigi Ala kumana Musa fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Matigi Ala k’a fɔ Musa ye ko: «A fɔ i kɔrɔcɛ Haruna ye ko a kana to ka don tuma bɛɛ yɔrɔ saninmanba* kɔnɔ, boncɛtigɛfani kɔ fɛ, jɛnɲɔgɔnya kɛsu* ni a datugunan bɛ yɔrɔ min na, ni o tɛ, a bɛna sa; sabu ne bɛ ne yɛrɛ yira aw ra sankaba jamijan ra o kɛsu datugunan le kunna. ");
INSERT INTO dyu_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Haruna ka kan ka don ne ta yɔrɔ saninman kɔnɔ cogo min na, o ye nin ye: a ka kan ka misitoran kaɲaman kelen mina ka o kɛ a yɛrɛ ta jurumunyafa saraka ye, ka sagajigi kelen kɛ a yɛrɛ ta saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","A bɛ a ta lɛnfaniw don a yɛrɛ ra, minw ye forokiyasurun ye, ani a kurusi, k’a yɛrɛ cɛsiri ni a cɛsirinan ye, ka jalamugu fugula gbɛman biri a kun na. A bɛ a yɛrɛ ko fɔlɔ, ka sɔrɔ ka o fani saninmanw don a yɛrɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","A ka kan ka bakɔrɔnin fla mina Izirayɛli jama fana fɛ ka o kɛ o ta jurumunyafa saraka ye, ani sagajigi kelen, ka o kɛ o ta saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Haruna ye a ta misitoran mina k’a kɛ saraka ye, k’a yɛrɛ ta jurumun, ani a ta somɔgɔw ta jurumun kafari. ");
INSERT INTO dyu_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","O kɔ, a ye bakɔrɔnin fla mina ka na ni o ye Matigi Ala ɲa kɔrɔ, Ɲɔgɔnkunbɛn fanibon* donda ra. ");
INSERT INTO dyu_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","A ye kara la*, janko k’a lɔn o bakɔrɔnin fla ra, juman le bɛ kɛ Matigi Ala ta ye, ani juman le bɛ bla ka taga kongo kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","«Ni bakɔrɔnin min ka kɛ Matigi Ala ta ye, Haruna bɛna o mina ka o faga k’a kɛ jama ta jurumunyafa saraka ye. ");
INSERT INTO dyu_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Bakɔrɔnin min kɛra bakɔrɔnin blata ye, a bɛna o ɲanaman mina k’a lɔ Matigi Ala ɲa kɔrɔ, ka jurumun kafari ni a ye, k’a gbɛn ka taga kongo kɔnɔ, k’a kɛ bakɔrɔnin blata ye. ");
INSERT INTO dyu_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Ayiwa, ni o kɛra, Haruna bɛ a ta misitoran mina, ka o kɛ k’a yɛrɛ ta jurumun ni a ta somɔgɔw ta jurumun kafari; a ye o misitoran kannatigɛ. ");
INSERT INTO dyu_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","O kɔ, a ye wusunandaga dɔ ta, ka takami dɔ cɛ wusunanjɛnifɛn kan, Matigi Ala ɲa kɔrɔ, ka o kɛ wusunandaga kɔnɔ, ka wusunanmugu boro ɲa fla kɛ minan dɔ kɔnɔ, ka taga ni o bɛɛ ye boncɛtigɛfani kɔ fɛ yɔrɔ saninmanba* kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ni a donna yi, a ye wusunan kɛ takami kan Matigi Ala ɲa kɔrɔ, janko wusunan sisi ye wuri ka kɛ jɛnɲɔgɔnya kɛsu datugunan kan k’a datugu. Ni o kɛra, Haruna tɛna sa. ");
INSERT INTO dyu_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","A bɛna misitoran jori dɔ ta, ka taga o seriseri ni a borokanden ye kɛsu datugunan ɲafɛyɔrɔ kan, a terebɔyanfan na; a ye a borokanden su jori ra tuun k’a seriseri kɛsu datugunan ɲa fɛ siɲaga wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«O kɔ, a bɛ Izirayɛli jama ta bakɔrɔnin mina ka o kannatigɛ, ka o kɛ o ta jurumunyafa saraka ye. A ye taga ni o jori ye boncɛtigɛfani kɔ fɛ. A k’a kɛ cogo min ni misitoran jori ye, a ye a kɛ o cogo kelen na. A ye jori dɔ seriseri kɛsu datugunan kan, ka dɔ seriseri a ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","«O cogo ra, Izirayɛlimɔgɔw ka Ala ta yɔrɔ saninmanba lanɔgɔ ni o ta kanminabariyaw, ani o ta hakɛkow, ani o ta jurumun minw bɛɛ ye, Haruna bɛ o bɛɛ kafari. A bɛ fanibon yɔrɔ tɔ bɛɛ fana ta kɛ o cogo ra, sabu o fanibon bɛ o mɔgɔ saninyabariw le cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","«Ni Haruna bɛ don yɔrɔ saninmanba kɔnɔ ka taga jurumun kafari wagati min na, mɔgɔ si man kan ka kɛ fanibon kɔnɔ o wagati ra, fɔ ka taga a bɔ. A bɛ jurumun kafari kɛ a yɛrɛ ni a ta somɔgɔw ye, ani Izirayɛlimɔgɔw jama bɛɛ lajɛnnin ye. ");
INSERT INTO dyu_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ni a bɔra, a ye taga sarakajɛnifɛn kɔrɔ Matigi Ala ɲa kɔrɔ, ka taga jurumun kafari kɛ sarakajɛnifɛn kan. A ye misitoran ni bakɔrɔnin jori dɔ mun sarakajɛnifɛn gbanw bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","A bɛ jori seriseri sarakajɛnifɛn kan ni a borokanden ye, siɲaga wolonfla, k’a saninya Izirayɛlimɔgɔw ta hakɛkow ma, k’a bla danna ne ye. ");
INSERT INTO dyu_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Ayiwa, ni Haruna ka jurumun kafari ka ban, ka yɔrɔ saninmanba ni Ɲɔgɔnkunbɛn fanibon ni sarakajɛnifɛn saninya, o tuma bakɔrɔnin min bɛ gbɛn ka taga kongo kɔnɔ, a ye o mina ka na. ");
INSERT INTO dyu_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Haruna ye a boro fla la o bakɔrɔnin kun na; Izirayɛlimɔgɔw ka terenbariyako minw bɛɛ kɛ, ani o ta hakɛkow, ani o ta jurumunw, Haruna ye o bɛɛ fɔ ka o kunko la bakɔrɔnin kan. A bɛ o jurumunw bɛɛ kunko la bakɔrɔnin kunna; o kɔ, a bɛ mɔgɔ dɔ bla a ye o bakɔrɔnin gbɛn ka taga kongokolon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","O bɛ o bakɔrɔnin gbɛn ka taga kongokolon kɔnɔ; ni o kɛra, bakɔrɔnin bɛ taga ni o ta jurumunw bɛɛ ye kongo kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«O kɔ, Haruna bɛ don Ɲɔgɔnkunbɛn fanibon kɔnɔ. A tun ka lɛnfani minw don, ka don yɔrɔ saninman* kɔnɔ, a bɛ o bɔ ka o bla yɔrɔ saninman kɔnɔ yi. ");
INSERT INTO dyu_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","A ye a yɛrɛ ko ni ji ye yɔrɔ saninman dɔ ra, ka sɔrɔ k’a ta faniw don. O kɔ, a ye bɔ ka na a ta saraka jɛnita ni jama ta saraka jɛnita jɛni. A ye a yɛrɛ ta jurumun ni jama ta jurumun kafari. ");
INSERT INTO dyu_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Bɛgan min kɛra jurumunyafa saraka ye, a bɛ o turu fana jɛni sarakajɛnifɛn kan. ");
INSERT INTO dyu_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Mɔgɔ min ka bakɔrɔnin gbɛn ka taga kongo kɔnɔ, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko fana, ka sɔrɔ ka don dugu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","«Misitoran ni bakɔrɔnin min kɛra jurumunyafa saraka ye, o donna ni minw jori ye yɔrɔ saninmanba kɔnɔ ka jurumun kafari, o ka kan ka taga ni olugu ye fanibonw kɔ fɛ, ka taga o gbolo ni o sogo ni o bo bɛɛ jɛni. ");
INSERT INTO dyu_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ni mɔgɔ min ka o jɛni, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko ji ra; o kɔ, a bɛ sɔrɔ ka don dugu kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Ayiwa, nin ye sariya wuribari le ye aw fɛ. San karo wolonflanan, o karo tere tan, aw ka kan ka aw yɛrɛ majigi Ala ɲa kɔrɔ; aw man kan ka baara si kɛ o lon na, aw Izirayɛlimɔgɔw, ani lonan minw siginin bɛ aw fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Sabu o lon le ra aw ta jurumunw bɛ kafari, ka aw saninya. Ni o kɛra, aw bɛna saninya ka bɔ aw ta jurumunw bɛɛ ra Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Aw man kan ka foyi kɛ o lon na; aw ka kan ka nɛnɛkiri, ka aw yɛrɛ majigi Ala ɲa kɔrɔ. O ye sariya wuribari le ye. ");
INSERT INTO dyu_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","«Ayiwa, turu saninman* kɛra sarakalasebaga min kan k’a saninya, k’a sigi sarakalasebagaya ra a facɛ nɔ ra, ale le bɛ jurumunw kafari; a ka kan ka lɛnfaniw le don, fani saninmanw. ");
INSERT INTO dyu_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","A bɛna jurumun kafari kɛ, ka yɔrɔ saninmanba saninya, ka Ɲɔgɔnkunbɛn fanibon ni sarakajɛnifɛn saninya, ka sarakalasebagaw ni jama bɛɛ lajɛnnin saninya. ");
INSERT INTO dyu_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","«Nin sariya ye sariya wuribari le ye aw fɛ. Aw ka kan ka Izirayɛlimɔgɔw ta jurumunw bɛɛ kafari o ye siɲaga kelen san o san.» Ayiwa, Matigi Ala tun ka fɛn o fɛn fɔ Musa ye, Haruna ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«A fɔ sarakalasebagaw ye, Haruna ni a dencɛw, ani Izirayɛlimɔgɔw bɛɛ ye, ko: ");
INSERT INTO dyu_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Matigi Ala ka min fɔ o le nin ye: ‹Ni Izirayɛlimɔgɔ dɔ ka misi, walama saga, walama ba faga dugu kɔnɔ, walama so kɔ fɛ, ");
INSERT INTO dyu_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ni a ma na ni a ye Ɲɔgɔnkunbɛn fanibon* ɲa fɛ ka na a faga o yɔrɔ ra, k’a kɛ saraka ye Matigi Ala ɲa kɔrɔ fanibon donda ra, o hakɛ bɛ to o tigi kunna, sabu a kɛra i n’a fɔ a ka mɔgɔ le faga. O tigi ka kan ka faran ka bɔ Izirayɛli jamanadenw na. ");
INSERT INTO dyu_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","O kun ye janko Izirayɛlimɔgɔw kana o ta bɛganw faga kongo kɔnɔ o yɛrɛ ma yi; o ye na ni a ye sarakalasebaga fɛ Matigi Ala ɲa kɔrɔ, Ɲɔgɔnkunbɛn fanibon donda ra, ka na a kɛ ninsɔndiya saraka ye k’a di Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Ni o ka o bɛgan faga, sarakalasebaga bɛ a jori seriseri Matigi Ala ta sarakajɛnifɛn kan, Ɲɔgɔnkunbɛn fanibon donda ra. A bɛ a turu jɛni sarakajɛnifɛn kan. O bɛ kɛ saraka ye min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","O ra, Izirayɛlimɔgɔw si man kan ka taga o ta bɛganw faga kongo kɔnɔ tuun ka saraka bɔ bakɔrɔnin jinaw ye, ka jɛn ni o jinaw ye ka jurumun kɛ. Nin sariya ye sariya wuribari le ye Izirayɛlimɔgɔw ni o ta durujaw bɛɛ fɛ.› ");
INSERT INTO dyu_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«O kosɔn i ye a fɔ o ye ko ni Izirayɛlimɔgɔ dɔ, walama lonan minw siginin bɛ o fɛ, ni o dɔ ka saraka jɛnita dɔ bɔ, walama saraka suguya wɛrɛ, ");
INSERT INTO dyu_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ni a ma na ni a ye Ɲɔgɔnkunbɛn fanibon donda ra, ka na o saraka bɔ Matigi Ala ye, o tigi ka kan ka faran ka bɔ a ta jamana mɔgɔw cɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«Ni Izirayɛlimɔgɔ dɔ, walama lonan minw siginin bɛ o fɛ, ni o dɔ ka bɛgan dɔ jori domu, ni a kɛra bɛgan o bɛgan jori ye, ne Ala bɛna wuri o tigi kama, k’a faran ka bɔ a ta jamana mɔgɔw cɛ ra; ");
INSERT INTO dyu_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","sabu fɛnɲanaman bɛɛ nin bɛ a jori le ra. O kosɔn Matigi Ala k’a fɔ ko aw ta bɛganw bɛɛ jori ye kɛ sarakajɛnifɛn kan, janko ka aw ta jurumun kafari. Nin min bɛ jori ra, o le b’a to jori bɛ kɛ ka jurumun kafari. ");
INSERT INTO dyu_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","O le kosɔn ne k’a fɔ Izirayɛlimɔgɔw ye ko: ‹Aw si man kan ka jori domu. Hali lonan minw bɛ o fɛ, o si man kan ka jori domu.› ");
INSERT INTO dyu_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«Ni Izirayɛlimɔgɔ dɔ, walama lonan minw bɛ o fɛ, ni o dɔ ka kongosogo walama kɔnɔ dɔ mina kongo ra, min bɛ domu, a ka kan ka a jori bɔn dugu ma ka a datugu ni buguri ye. ");
INSERT INTO dyu_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Sabu fɛnɲanaman bɛɛ nin ye a jori le ye, jori min b’a ra. O kosɔn ne k’a fɔ Izirayɛlimɔgɔw ye ko: ‹Aw kana fɛnɲanaman si jori domu; sabu fɛnɲanaman bɛɛ nin ye a jori le ye. Mɔgɔ o mɔgɔ k’a domu, o tigi bɛ faran ka bɔ Izirayɛlimɔgɔw cɛ ra.› ");
INSERT INTO dyu_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«Ni mɔgɔ o mɔgɔ ka jufasogo, walama wara datɔ domu, ni a kɛra Izirayɛlimɔgɔ ye, walama lonan, o tigi ka kan k’a ta faniw ko, k’a yɛrɛ ko. A saninyabari bɛ to fɔ ka taga wula se. O kɔ fɛ, a bɛ sɔrɔ ka saninya. ");
INSERT INTO dyu_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ni a ma a ta faniw ko, k’a yɛrɛ ko, o hakɛ bɛna bɔ a tigi ra.» ");
INSERT INTO dyu_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Kuma Izirayɛlimɔgɔw fɛ, k’a fɔ o ye ko: ‹Ne le ye Matigi Ala ye, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Aw tun bɛ Misiran jamana ra tuma min na aw ka ko minw ye olugu fɛ, aw kana o ladegi. Ne bɛ tagara ni aw ye Kanaana jamana min na fana, aw kana taga o jamana mɔgɔw ta kokɛtaw ladegi. Aw man kan ka o ta landaw ta. ");
INSERT INTO dyu_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Aw ka kan ka ne ta cifɔninw le kɛ, ka ne ta sariyaw sira tagama; sabu ne le ye Matigi Ala ye, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","« ‹Aw ye ne ta sariyaw ni ne ta cifɔninw sira tagama. Ni mɔgɔ min ka o sariyaw sira tagama, o tigi bɛna kisi o le sababu ra; sabu ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","« ‹Ayiwa, aw ra cɛ si man kan ka gbara muso dɔ ra, ka jɛn ni a ye, k’a sɔrɔ a ni o muso bɛɛ ye gbakelenmɔgɔw ye. Ne le ye Matigi Ala ye, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","« ‹I man kan ka jɛn ni i bamuso ye k’a lebu; sabu i bamuso lo. I man kan ka jɛn ni a ye, ka i facɛ lebu. ");
INSERT INTO dyu_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","« ‹I man kan ka jɛn ni i facɛ ta muso dɔ ye fana, ka i facɛ lebu. ");
INSERT INTO dyu_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","« ‹I man kan ka jɛn ni i balemamuso ye; ni aw bɛɛ kɛra fa kelen ni ba kelen o, walama ni aw kɛra fa kelen na, nka aw tɛ ba kelen na o, walama ni aw kɛra ba kelen na, nka aw tɛ fa kelen na o, ni aw worora lu kelen kɔnɔ o, walama ni aw ma woro lu kelen kɔnɔ o, i man kan ka jɛn ni a ye. ");
INSERT INTO dyu_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","« ‹I man kan ka jɛn ni i mamaden si ye, ka i yɛrɛ lebu. ");
INSERT INTO dyu_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","« ‹I man kan ka jɛn ni i facɛ ta muso dɔ ta denmuso ye, sabu i balemamuso lo. ");
INSERT INTO dyu_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","« ‹I man kan ka jɛn ni i facɛ kɔrɔmuso, walama ni a dɔgɔmuso dɔ ye, sabu i tɛnɛnmuso lo. ");
INSERT INTO dyu_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","« ‹I man kan ka jɛn ni i bamuso kɔrɔmuso walama a dɔgɔmuso ye, sabu i tɛnɛnmuso lo. ");
INSERT INTO dyu_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","« ‹I man kan ka i facɛ balemacɛ lebu, ka jɛn ni a muso ye, sabu i tɛnɛnmuso lo. ");
INSERT INTO dyu_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","« ‹I man kan ka jɛn ni i buranmuso ye, sabu i dencɛ muso lo. I man kan ka jɛn ni a ye. ");
INSERT INTO dyu_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","« ‹I man kan ka jɛn ni i balemacɛ muso ye, ka i balemacɛ lebu. ");
INSERT INTO dyu_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","« ‹I man kan ka jɛn ni muso dɔ ye, ka sekɔ ka jɛn ni a denmuso fana ye. I jɛnna ni muso min ye, i man kan ka jɛn ni o muso mamaden si ye; sabu olugu ni o muso bɛɛ ye gbakelenmɔgɔw le ye. Ni mɔgɔ min ka o kɛ, o tigi ka kojuguba le kɛ. ");
INSERT INTO dyu_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","« ‹I man kan ka i muso dɔgɔmuso furu, ka jɛn ni a ye, k’a i muso to si ra, ka celiya don o ni ɲɔgɔn cɛ. ");
INSERT INTO dyu_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","« ‹I man kan ka gbara muso si ra ka jɛn ni a ye, k’a sɔrɔ a bɛ a ta landa ra, sabu a saninyabari lo. ");
INSERT INTO dyu_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","« ‹I man kan ka i mɔgɔɲɔgɔn ta muso ɲini, ka jɛn ni a ye, ka i yɛrɛ lanɔgɔ ni a ye. ");
INSERT INTO dyu_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","« ‹I kana sɔn ka i den si di o ye a don tasuma ra, k’a kɛ saraka ye ka Molɔki ta jo sɔn ni a ye. I man kan ka i ta Ala tɔgɔ cɛn o cogo ra, sabu ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","« ‹I man kan ka jɛn ni i cɛɲɔgɔn ye i n’a fɔ cɛ bɛ jɛn ni muso ye cogo min na; o ye ko haramunin le ye. ");
INSERT INTO dyu_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","« ‹I man kan ka jɛn ni bɛgan ye, ka i yɛrɛ lanɔgɔ. Muso fana man kan k’a yɛrɛ di bɛgan ma, a ye jɛn ni a ye. O ye kokolonba le ye. ");
INSERT INTO dyu_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","« ‹Ayiwa, aw kana aw yɛrɛ lanɔgɔ ni nin kow si ye, sabu ne bɛna siya minw gbɛn ka bɔ aw ɲa, olugu tun ka o yɛrɛ lanɔgɔ ni nin kow bɛɛ le ye. ");
INSERT INTO dyu_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","O k’a kɛ ten ka jamana bɛɛ lanɔgɔ. O kosɔn ne bɛna o hakɛ bɔ o ra, k’a to o ta jamana ye o bɛɛ fɔɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","« ‹O ra aw ka kan ka ne ta cifɔninw, ani ne ta kolatigɛninw bɛɛ sira tagama. Aw Izirayɛlimɔgɔw, walama lonan minw bɛ aw cɛ ra, aw si man kan ka nin ko haramuninw ɲɔgɔn dɔ kɛ; ");
INSERT INTO dyu_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","sabu mɔgɔ minw sigira jamana ra ka kɔn aw ɲa, olugu ka nin ko haramuninw ɲɔgɔn le kɛ, ka jamana bɛɛ lanɔgɔ. ");
INSERT INTO dyu_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ni aw ka o kow ɲɔgɔn kɛ, ka jamana lanɔgɔ, jamana bɛna aw fana fɔɔnɔ, i n’a fɔ minw tun sigira jamana ra aw ɲa, jamana ka olugu fɔɔnɔ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","« ‹Aw ra ni min o min ka nin ko haramunin ɲɔgɔn dɔ kɛ, ne bɛna o tigi faran ka bɔ a ta jamana mɔgɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","« ‹Ayiwa, aw ka kan ka ne ta kokɛtaw sira le tagama. Nin ko haramunin minw tun bɛ kɛra jamana kɔnɔ ka sɔrɔ aw ma se yi ban, aw man kan ka o kow si ladegi ka aw yɛrɛ lanɔgɔ, sabu ne le ye Matigi Ala ye, aw ta Ala.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ayiwa, Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Kuma Izirayɛlimɔgɔw bɛɛ lajɛnnin fɛ k’a fɔ o ye ko: ‹Aw ka kan ka saninya, sabu ne saninyanin lo, ne Matigi Ala, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","« ‹Aw bɛɛ ye aw fa ni aw ba bonya. Ne ka Nɛnɛkirilon min sigi, aw ka kan ka o jate fana, sabu ne le ye Matigi Ala ye, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","« ‹Aw kana ɲabɔ batofɛn gbansanw fɛ ka o bato. Aw kana nɛgɛ yeele ka o kɛ batofɛn dɔ ye k’a bato; sabu ne le ye Matigi Ala ye, aw ta Ala.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","« ‹Ni aw b’a fɛ ka ninsɔndiya saraka bɔ ne ye, aw y’a kɛ ka kaɲa ni a kɛcogo ye, janko ne ye aw ta saraka mina. ");
INSERT INTO dyu_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Aw bɛ o saraka di ne ma lon min na, a sogo ka kan ka domu k’a ban o lon yɛrɛ ra. Ni a tɔ ka si, aw ye o domu o dugusagbɛ. Nka ni a tɔ belen ka to a dugusagbɛ flanan, aw ye o jɛni tasuma ra k’a ban. ");
INSERT INTO dyu_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ni mɔgɔ o mɔgɔ ka sarakasogo domu ka taga se fɔ tere saba, o tigi ta saraka tɛ mina, sabu a sogo kɛra fɛn haramunin ye. ");
INSERT INTO dyu_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ni mɔgɔ o mɔgɔ ka o sogo domu, o hakɛ bɛ o tigi kan; sabu o saraka min dira ne ma, a ma o jate fɛn saninman ye. O tigi ka kan ka faran ka bɔ Izirayɛli jamanadenw na.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","« ‹Ayiwa, ni aw nana kɛ aw ta simanw kan ye aw ta jamana ra tuma min na, aw ye foro kɛrɛfɛyɔrɔ ta simanw to yi, aw kana o kan. Siman minw fana kanbari tora, walama minw benbenna, aw kana sekɔ ka taga olugu kan tuun. ");
INSERT INTO dyu_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ni aw bɛ aw ta rɛzɛnmɔ fana bɔ, minw tora tigɛbari ye, walama minw benbenna, aw kana sekɔ ka taga olugu tɔmɔ. Aw ye o to fagantanw ni lonanw ye; sabu ne le ye Matigi Ala ye, aw ta Ala.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","« ‹Aw kana sonyari kɛ; aw kana faninya tigɛ, walama ka aw mɔgɔɲɔgɔn janfa. ");
INSERT INTO dyu_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Aw kana kari gbansan faninya kan ni ne tɔgɔ ye, ka ne tɔgɔ cɛn, sabu ne le Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","« ‹Mɔgɔ kana a mɔgɔɲɔgɔn tɔɲɔ. I kana i mɔgɔɲɔgɔn borofɛn bɔsi a ra. I ta baaraden sara kana si i boro. ");
INSERT INTO dyu_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","I kana torogberen nɛni. I kana fɛn bla fiyentɔ ɲa, k’a to a ye talon a ra. I ka kan ka siran Ala ɲa, sabu ne le ye Matigi Ala ye, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","« ‹Ni i bɛ kiti tigɛ, i ye a tigɛ terenninya kan. I kana jo di fagantan ma a ta fagantanya kosɔn, i fana kana kiti diya fagama ra a ta fagamaya kosɔn. Ni i bɛ i mɔgɔɲɔgɔn ta kiti tigɛ, i ye a kɛ can le kan. ");
INSERT INTO dyu_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","I kana yaala ka nafigiya kɛ mɔgɔw cɛ ra. I kana seereyajugu fɔ i mɔgɔɲɔgɔn ta ko ra min bɛ se ka kɛ a fagasababu ye; ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","« ‹I kana i balema kɔninya i jusukun na gbansan. Ni a ka ko dɔ le kɛ min man ɲi, i ye o fɔ a ɲa na k’a gbɛlɛya, janko o kana na i fana jaraki ni a ye. ");
INSERT INTO dyu_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ni mɔgɔ dɔ ka ko dɔ kɛ i ra, i kana a fɔ ko i bɛ a juru sara. Ni i balema dɔ ka ko dɔ kɛ i ra min ka i dimi, i kana o ko to i yɛrɛ kɔnɔ. I ka kan ka i mɔgɔɲɔgɔn kanu i ko i yɛrɛ, sabu ne le ye Matigi Ala ye.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","« ‹Ayiwa, aw ka kan ka ne ta sariyaw sira tagama. Aw ta bɛgan minw tɛ bɛgan suguya kelen ye, aw kana a to olugu ye jɛn. Siman minw fana tɛ siman suguya kelen ye, aw kana olugu dan foro kelen kɔnɔ. Fani minw tɛ fani suguya kelen ye, aw kana o karan ɲɔgɔn na ka o don.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","« ‹Ni cɛ dɔ ka jɔnmuso dɔ mamina, k’a sɔrɔ a m’a kunmabɔ, jɔnmuso matigicɛ fana m’a labla, ni cɛ wɛrɛ nana jɛn ni o muso ye, o tigi ka kan ka warida dɔ sara. Nka o man kan ka o faga, sabu jɔnmuso tun ma kunmabɔ, a tun tɛ a yɛrɛ ta ye fana. ");
INSERT INTO dyu_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","O cɛ ye na ni sagajigi kelen ye Ɲɔgɔnkunbɛn fanibon* donda ra, a ta hakɛ kosɔn, ka na o di Matigi Ala ma hakɛbɔ saraka ye a ta hakɛ kosɔn. ");
INSERT INTO dyu_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Sarakalasebaga bɛna a ta jurumun kafari ni o hakɛbɔ saraka ye Matigi Ala ɲa kɔrɔ. Cɛ ta jurumun bɛna yafa a ma.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","« ‹Ayiwa, ni aw tagara se Kanaana jamana ra tuma min na, ni aw ka yiri suguya caman turu, minw bɛ den, aw ka kan ka o yiriw denw jate i n’a fɔ yiriden saninyabariw, fɔ san saba; fɔ ka taga o san saba dafa, aw man kan ka o yiridenw domu. ");
INSERT INTO dyu_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A san naaninan, o yiriw bɛna den minw kɛ, o denw bɛɛ bɛna bla danna ne ye; aw bɛna ɲanagbɛ dɔ kɛ o yiridenw ko ra, ka ne bonya. ");
INSERT INTO dyu_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","A san loorunan le ra, aw bɛ se ka o yiridenw domu. O cogo ra, aw ta yiriw bɛna den caman kɛ aw ye san o san. Ne le ye Matigi Ala ye, aw ta Ala.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","« ‹Aw kana jufasogo domu. Aw kana subagaya kɛ, aw kana lagbɛri kɛ. ");
INSERT INTO dyu_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Aw kana aw kun li, ka si dɔ to aw kun cɛmancɛ ra. Aw kana aw bonbosi kɛrɛfɛyɔrɔw dama li. ");
INSERT INTO dyu_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ni mɔgɔ ka sa aw fɛ, aw kana aw fari cici ni muru ye ko mɔgɔ sara aw fɛ. Aw kana aw fari ɲɛgɛnɲɛgɛn. Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","« ‹Aw kana jɛn siri ni josɔnbagaw ye ka aw denmusow bla jatɔya ra ni o ye, ka o lebu; ni o tɛ, jamana bɛɛ bɛna na ɲabɔ o jow fɛ, ka kojugu caya jamana kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ne ka Nɛnɛkirilon* minw fɔ aw ye, aw ka kan ka o lonw jate; aw ka kan ka bonya la ne ta batoyɔrɔ saninman kan fana. Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","« ‹Minw b’a fɔ ko o bɛ kuma ni suw ye, ka lagbɛri kɛ, aw kana taga olugu fɛ ko aw bɛ taga lagbɛri kɛ. Ni aw ka o kɛ, aw bɛna aw yɛrɛ lanɔgɔ. Ne le ye Matigi Ala ye, aw ta Ala.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","« ‹Aw ye wuri ka lɔ mɔgɔkɔrɔba kunsigigbɛtigi ɲa kɔrɔ; aw ye mɔgɔkɔrɔba bonya kosɛbɛ. Aw ye siran aw ta Ala ɲa; ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","« ‹Ni lonan dɔ ka na sigi aw ta jamana ra, aw kana a jɔnyamina. ");
INSERT INTO dyu_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Aw ye lonanw minako ɲa, k’a kɛ i n’a fɔ aw yɛrɛ dɔ lo. Aw ye o kanu k’a kɛ i n’a fɔ o ye aw dɔ le ye, sabu aw fana tun ye lonanw le ye Misiran jamana ra. Ne le ye Matigi Ala ye, aw ta Ala.› » ");
INSERT INTO dyu_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«Aw kana mɔgɔ tɔɲɔ jago ra. Ni aw bɛ fiyeere kɛ, ni aw bɛ fɛn suma, aw kana dɔ bɔ a mɛtɛrɛda ra, walama a kiloda ra, walama a litirida ra. ");
INSERT INTO dyu_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Aw y’a to aw ta sumanikɛnan ye bɛn, a kiloda ye dafa; aw kana dɔ bɔ aw ta sumanikɛminanw na fana. Ne le Matigi Ala ye, aw ta Ala, min ka aw labɔ Misiran jamana ra. ");
INSERT INTO dyu_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","« ‹Aw ye ne ta sariyaw ani ne ta cifɔninw bɛɛ kɛ, ka tagama ka kaɲa ni o ye, sabu ne le ye Matigi Ala ye.› » ");
INSERT INTO dyu_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Kuma Izirayɛlimɔgɔw fɛ, i ye a fɔ o ye ko: ‹Ni Izirayɛlimɔgɔ dɔ, walama lonan minw bɛ ni aw ye, ni o dɔ k’a den di, k’a kɛ ka Molɔki ta jo sɔn, o tigi ka kan ka faga. Mɔgɔw ye jɛn k’a bon ni kabakuru ye k’a faga. ");
INSERT INTO dyu_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ne bɛna wuri o tigi kama, k’a faran ka bɔ Izirayɛlimɔgɔw ra, sabu a k’a den dɔ di, ka Molɔki ta jo sɔn ni a ye minkɛ, a ka ne ta yɔrɔ saninman* le lanɔgɔ, ka ne tɔgɔ saninman cɛn. ");
INSERT INTO dyu_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ayiwa, aw jamana mɔgɔw, ni aw ka aw ɲa tugu o ko ɲɔgɔn kan, ni aw ma sɔn k’a tigi faga, ");
INSERT INTO dyu_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ne yɛrɛ le bɛna juguya a ma kosɛbɛ, ale ni a ta gba bɛɛ, ka o faran ka bɔ o ta jamana mɔgɔw cɛ ra, ani minw bɛɛ bɛ jɛn ni o mɔgɔw ye, ka Molɔki ta jo sɔn. ");
INSERT INTO dyu_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","« ‹Minw b’a fɔ ko o bɛ kuma ni suw ye, ka lagbɛri kɛ, ni mɔgɔ o mɔgɔ ka taga olugu dɔ fɛ, ne bɛna wuri o tigi kama kosɛbɛ, k’a faran ka bɔ a ta jamana mɔgɔw cɛ ra.› » ");
INSERT INTO dyu_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","« ‹Aw ye aw yɛrɛ saninya ka kɛ mɔgɔ saninmanw ye, sabu ne le ye Matigi Ala ye, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","« ‹Aw ye jija ka ne ta sariyaw sira tagama, sabu ne le ye Matigi Ala ye, min bɛ aw saninya. ");
INSERT INTO dyu_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","« ‹Ni mɔgɔ o mɔgɔ ka kumajugu fɔ a facɛ walama a bamuso ma, o tigi ka kan ka faga. A fagari kunko bɛna ben a yɛrɛ le kan, sabu a ka kumajugu fɔ a facɛ walama a bamuso ma. ");
INSERT INTO dyu_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","« ‹Ni cɛ min ka jɛn ni a mɔgɔɲɔgɔn muso ye, o cɛ ni o muso bɛɛ ka kan ka faga. ");
INSERT INTO dyu_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","« ‹Ni cɛ min ka jɛn ni a facɛ muso ye, k’a facɛ lebu, o cɛ ni o muso bɛɛ ka kan ka faga; o fagari kunko bɛna ben o yɛrɛ le kan. ");
INSERT INTO dyu_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","« ‹Ni cɛ min ka jɛn ni a dencɛ muso ye, o cɛ ni o muso bɛɛ ka kan ka faga, sabu o ka koɲagamininba le kɛ. O fagari kunko bɛna ben o yɛrɛ le kan. ");
INSERT INTO dyu_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","« ‹Ni cɛ fla ka jɛn i n’a fɔ cɛ bɛ jɛn ni muso ye cogo min na, o ka ko haramunin le kɛ. O ka kan ka o faga. O fagari kunko bɛna ben o yɛrɛ le kan fana. ");
INSERT INTO dyu_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","« ‹Ni cɛ dɔ ka muso dɔ ta, ka sɔrɔ ka o muso denmuso fana ta tuun, o ye kojuguba le ye. O ka kan ka o saba bɛɛ jɛni, janko o kojugu ɲɔgɔn kana ye aw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","« ‹Ni cɛ min ka jɛn ni bɛgan ye, o cɛ ka kan ka faga; o ka kan ka bɛgan fana faga. ");
INSERT INTO dyu_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","« ‹Ni muso min fana k’a yɛrɛ di bɛgan dɔ ma ka jɛn ni a ye, o ka kan ka o muso ni o bɛgan bɛɛ faga. Ni o fagara, o fagari kunko bɛna ben o yɛrɛ le kan. ");
INSERT INTO dyu_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","« ‹Ni cɛ min k’a balemamuso ta, fakelenden, walama bakelenden, ka jɛn ni a ye, ka ɲɔgɔn lebu, o ye maroyakoba le ye. Olugu ka kan ka faran ka bɔ Izirayɛli jamanadenw na o balema tɔw bɛɛ ɲa na. O cɛ jɛnna ni a balemamuso ye minkɛ, o hakɛ ka kan ka ben a kan. ");
INSERT INTO dyu_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","« ‹Ni cɛ min ka jɛn ni muso dɔ ye ka o muso to landa ra, o fla bɛɛ ka kan ka faran ka bɔ o ta jamana mɔgɔw cɛ ra, sabu o ka o yɛrɛ lanɔgɔ jori ra, ka ne ta sariya cɛn. ");
INSERT INTO dyu_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","« ‹I man kan ka jɛn ni i bamuso balemamuso ye, walama i facɛ balemamuso, sabu i tɛnɛnmuso lo. Ni mɔgɔ min ka o kɛ, o hakɛ bɛna ben o tigi yɛrɛ kan. ");
INSERT INTO dyu_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","« ‹Ni cɛ min ka jɛn ni a benɔgɔcɛ ta muso ye, k’a benɔgɔcɛ lebu, o hakɛ bɛna ben o cɛ ni o muso kan. O tɛna den sɔrɔ fɔ ka taga o sa. ");
INSERT INTO dyu_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","« ‹Ni cɛ min k’a balemacɛ muso ta, o ye ko nɔgɔnin le ye. O tɛna den sɔrɔ, sabu o cɛ k’a balemacɛ lebu.› » ");
INSERT INTO dyu_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","« ‹Aw ye ne ta sariyaw ni ne ta cifɔninw bɛɛ kɛ, k’a sira tagama; ni o kɛra, ne bɛ tagara ni aw ye jamana min na, o jamana tɛna aw fɔɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ne bɛna siya minw gbɛn ka bɔ aw ɲa fɛ, aw kana olugu ta landaw ta, sabu o siyaw ka nin kojuguw bɛɛ le kɛ, fɔ k’a to ne ka o haramuya. ");
INSERT INTO dyu_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","O le kosɔn, ne k’a fɔ aw ye ko o jamana bɛna kɛ aw le ta ye. Ne bɛna o jamana di aw ma, nɔnɔ ni li bɛ woyo o jamana min na; sabu ne le ye Matigi Ala ye, aw ta Ala. Ne le ka aw ɲanawoloma ka bɔ siya tɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","« ‹O kosɔn sogo saninyaninw ni sogo saninyabariw, ani kɔnɔ saninyaninw ni kɔnɔ saninyabariw, aw ka kan ka olugu lɔn ka bɔ ɲɔgɔn na, janko aw kana aw yɛrɛ lanɔgɔ ni o fɛn saninyabariw si ye; aw kana aw yɛrɛ lanɔgɔ ni o sogow ye, walama o kɔnɔw, walama o fɛnɲanaman minw bɛ fofo o kɔnɔbara kan dugu ma. Ne ka o fɛnw yira aw ra, janko aw ye a lɔn ko o saninyanin tɛ. ");
INSERT INTO dyu_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","« ‹Aw ye aw yɛrɛ bla danna ka saninya ne ye, sabu ne Matigi Ala, ne saninyanin lo. Ne ka aw ɲanawoloma ka bɔ siya tɔw cɛ ra, janko aw ye kɛ ne ta mɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","« ‹Cɛw ni muso minw b’a fɔ ko o bɛ kuma ni suw ye, ka lagbɛri kɛ, aw ka kan ka olugu faga. Aw ye o bon ni kabakuru ye ka o faga. O ta fagari kunko bɛna ben o yɛrɛ le kan.› » ");
INSERT INTO dyu_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Matigi Ala k’a fɔ Musa ye ko: «Kuma sarakalasebagaw fɛ, minw ye Haruna dencɛw ye, i ye a fɔ o ye, ko ni sarakalasebaga dɔ ta mɔgɔ sara, a man kan ka gbara o su ra k’a yɛrɛ lanɔgɔ, ");
INSERT INTO dyu_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","fɔ ni a kɛra a yɛrɛ ta somɔgɔ dɔ ye, a bamuso, walama a facɛ, walama a ta den, walama a kɔrɔcɛ walama a dɔgɔcɛ. ");
INSERT INTO dyu_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Ni a balemamuso dɔ lo, min sunguruman lo, ni o tun bɛ ɲɔgɔn fɛ so kɔnɔ, a bɛ se ka gbara ale fana su ra k’a yɛrɛ lanɔgɔ, sabu a balemamuso ma furu. ");
INSERT INTO dyu_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","«Sarakalasebaga ye Izirayɛlimɔgɔw ɲamɔgɔ le ye, a ta sarakalasebagaya kosɔn. O ra, a man kan k’a yɛrɛ lanɔgɔ, k’a yɛrɛ lebu. ");
INSERT INTO dyu_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«Sarakalasebaga man kan k’a kun yɔrɔ dɔw li, walama k’a bonbosi kɛrɛfɛyɔrɔw li, walama k’a yɛrɛ fari yɔrɔ dɔw tigɛtigɛ ni muru ye. ");
INSERT INTO dyu_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","A ka kan ka saninya le, ka bla danna Ala ye; a man kan ka ne Ala tɔgɔ cɛn, sabu ale le bɛ siman sarakaw jɛni tasuma ra Matigi Ala ye, min ye o ta Ala ta saraka ye. O kosɔn a ka kan ka kɛ mɔgɔ saninman le ye. ");
INSERT INTO dyu_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","«Sarakalasebaga man kan ka jatɔmuso furu, walama cɛ dɔ ka muso min nɛgɛ ka jɛn ni a ye, walama muso furusanin dɔ, sabu sarakalasebaga blara danna ka saninya ka kɛ Matigi Ala ta le ye. ");
INSERT INTO dyu_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","«Izirayɛlimɔgɔw bɛɛ ka kan ka sarakalasebagaw jate mɔgɔ saninmanw ye, sabu olugu le bɛ aw ta Ala ta sarakaw lase. Aw ye o jate mɔgɔ saninmanw ye, sabu ne saninyanin lo, ne Matigi Ala min ka aw saninya. ");
INSERT INTO dyu_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","«Ni sarakalasebaga dɔ denmuso ka jɛn ni josɔnbagaw ye k’a yɛrɛ bla jatɔya ra ni o ye, k’a yɛrɛ lebu, a k’a facɛ le lebu. O ka kan k’a jɛni.» ");
INSERT INTO dyu_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«Ayiwa, sarakalasebaga min bɛ a balema sarakalasebaga tɔw kunna, turu saninman* kɛra min kun na k’a saninya, ka sarakalasebagaya faniw don a ra, ale man kan k’a kunsigi ɲagaminin to, walama k’a ta fani faran, kojugu dɔ kosɔn. ");
INSERT INTO dyu_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","A man kan ka gbara su ra k’a yɛrɛ lanɔgɔ, hali ni a facɛ, walama ni a bamuso su lo. ");
INSERT INTO dyu_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","A man kan ka bɔ yɔrɔ saninman* kɔnɔ ka taga sangayɔrɔ ra, janko a kana na Matigi Ala ta yɔrɔ saninman lanɔgɔ, sabu turu saninman* kɛra ale le kun na, k’a saninya k’a bla danna Ala ta baara kama. Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","«Sarakalasebagaw kuntigi ka kan ka sunguru le furu. ");
INSERT INTO dyu_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Muso cɛ sanin, walama muso furusanin, walama cɛ dɔ ka sunguru min nɛgɛ ka jɛn ni a ye, walama jatɔmuso, a man kan ka o dɔ furu. A ka kan ka sunguru dɔ le furu a yɛrɛ ta siyamɔgɔw ra, ");
INSERT INTO dyu_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","janko a denw kana kɛ den saninyabariw ye, ka ɲagami a ta siyamɔgɔw ra; sabu ne le ye Matigi Ala ye, min ka a saninya.» ");
INSERT INTO dyu_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ayiwa, Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«A fɔ Haruna ye, ko a ta durujaw ra, ko ni fiyɛn ka sɔrɔ a dencɛ min o min fari ra, ko o man kan ka gbara ko a bɛ a ta Ala ta saraka lase a ma. ");
INSERT INTO dyu_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ni fiyɛn bɛ mɔgɔ o mɔgɔ ra, o tɛ se ka gbara ne ta sarakajɛnifɛn na ka saraka lase ne ma. O ra, mɔgɔ o mɔgɔ ye fiyentɔ ye, walama senkelen, walama min ɲada cogo man ɲi, walama min sen kelen ka jan ni kelen ye, ");
INSERT INTO dyu_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","walama min sen kelen, walama a boro kelen man ɲi, ");
INSERT INTO dyu_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","walama dantɔ, walama mɔgɔ cɔrɔkɔnin, walama nɔ bɛ mɔgɔ min ɲaden kan, walama sɔninya bɛ mɔgɔ min na, walama ni warawara b’a ra, walama mɔgɔ min bɔra cɛya ra, o mɔgɔw si man kan ka saraka bɔ ne ye. ");
INSERT INTO dyu_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Sarakalasebaga Haruna ta gbamɔgɔ min o min, ni fiyɛn bɛ a fari ra, o man kan ka gbara ko a bɛ sarakaw jɛni Matigi Ala ye; sabu fiyɛn bɛ a fari ra. O ra, a daganin tɛ a ye gbara ko a bɛ a ta Ala ta saraka lase. ");
INSERT INTO dyu_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","A tigi bɛ se ka Ala ta saraka domu; fɛn minw saninyara, ani minw saninyara kosɛbɛ, a bɛ se ka olugu domu. ");
INSERT INTO dyu_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nka a man kan ka gbara yɔrɔ saninman* ta boncɛtigɛfani na, walama sarakajɛnifɛn na, sabu fiyɛn bɛ a fari ra. A man kan ka ne ta yɔrɔ saninmanw lanɔgɔ, sabu ne le Matigi Ala ye, ne le bɛ o saninya.» ");
INSERT INTO dyu_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ayiwa, Musa ka nin kumaw le fɔ Haruna ni a dencɛw ye, ani Izirayɛlimɔgɔw bɛɛ ye. ");
INSERT INTO dyu_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«A fɔ sarakalasebagaw ye, Haruna ni a dencɛw, ko Izirayɛlimɔgɔw bɛ saraka minw bɔ ne ye, ko o ye o saraka saninmanw minako ɲa, janko o kana ne tɔgɔ saninman lanɔgɔ. Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","A fɔ o ye ko o ta duruja nataw ra, ko Izirayɛlimɔgɔw bɛ saraka minw bɔ ne ye, ko ni sarakalasebaga min saninyabari ka gbara o fɛn saninmanw dɔ ra, o tigi ka kan ka bɔ ne ta baara ra. Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","«Bana minw bɛ mɔgɔ fari cɛn, walama damajalan, ni o dɔ bɛ sarakalasebaga o sarakalasebaga ra, Haruna dencɛw ra, o tigi man kan ka ne ta saraka saninmanw domu, fɔ ka taga a kɛnɛya. Ni sarakalasebaga min ka maga su ra, walama ni lawa bɛ bɔnna min fɛ, o fana man kan k’a domu; ");
INSERT INTO dyu_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","walama ni min magara fɛnɲanaman saninyabari dɔ ra, walama mɔgɔ saninyabari dɔ ra, k’a yɛrɛ lanɔgɔ, o fana man kan k’a domu. ");
INSERT INTO dyu_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ni mɔgɔ min ka maga o fɛnw dɔ ra, o tigi saninyabari bɛ to fɔ ka taga wula se; a man kan ka saraka saninmanw domu. O kɔ, a ka kan k’a yɛrɛ ko. ");
INSERT INTO dyu_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ni tere benna, a bɛ sɔrɔ ka saninya. O ra, a bɛ se ka saraka saninmanw domu, sabu o domuni ye a ta le ye. ");
INSERT INTO dyu_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Sarakalasebaga man kan ka bɛgan jufanin domu, walama wara datɔ, janko a kana a yɛrɛ lanɔgɔ. Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«Sarakalasebagaw ka kan ka ne ta kokɛtaw bɛɛ sira tagama; ni o tɛ, ni o ka o ciw bla, o hakɛ bɛna ben o kan, o bɛ sa; sabu ne le ye Matigi Ala ye, ne le bɛ o fɛnw saninya.» ");
INSERT INTO dyu_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«Ni sarakalasebagaw tɛ, mɔgɔ gbansan man kan ka saraka saninmanw domu. Mɔgɔ min ye lonan tɛmɛbaga ye sarakalasebaga ta so, walama min bɛ baaradenya ra a ta so, olugu si man kan k’a domu. ");
INSERT INTO dyu_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Nka ni sarakalasebaga ka jɔn min san, o bɛ se k’a domu; walama jɔn min worora a ta so. Olugu bɛ se ka sarakafɛn saninmanw domu. ");
INSERT INTO dyu_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ni sarakalasebaga denmuso dɔ furura mɔgɔ gbansan dɔ ma, o muso man kan ka Ala ta saraka saninmanw domu. ");
INSERT INTO dyu_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Nka ni sarakalasebaga denmuso min cɛ sara, walama min ta cɛ k’a bla, ni den tɛ a fɛ, ni a bɛ a facɛ ta so i n’a fɔ a sunguruman tuma, ale bɛ se ka saraka saninmanw domu ni a facɛ ye. Ni a bɔra o ra, mɔgɔ gbansan si man kan k’a domu. ");
INSERT INTO dyu_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","«Ni mɔgɔ dɔ firira ka saraka saninmanw dɔ domu, o tigi ka kan ka a ɲɔgɔn sara sarakalasebaga ye, k’a sɔngɔ taran taranyɔrɔ looru, k’a taran kelen fara a kan fana. ");
INSERT INTO dyu_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","«Izirayɛlimɔgɔw ka sarakafɛn minw bɔ ka o bla danna Matigi Ala ye, sarakalasebagaw man kan k’a to mɔgɔ gbansanw ye o fɛnw domu ka o lanɔgɔ. ");
INSERT INTO dyu_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Sabu ni o k’a domu, sarakalasebagaw bɛ jurumun le lase o mɔgɔw ma, ka o hakɛ ben o kan; ne le ye Matigi Ala ye, ne le bɛ o fɛnw saninya.» ");
INSERT INTO dyu_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Kuma Haruna ni a dencɛw fɛ, ani Izirayɛlimɔgɔw bɛɛ, k’a fɔ o ye ko ni Izirayɛlimɔgɔ dɔ, walama lonan minw bɛ Izirayɛlimɔgɔw cɛ ra, ni o dɔ b’a fɛ ka saraka jɛnita bɔ Matigi Ala ye, k’a ta dajuru le sara, walama ni a yɛrɛ diyanya saraka lo, ");
INSERT INTO dyu_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","a y’a to a ye kɛ bɛgan cɛman ye, misi, walama saga, walama ba, fiyɛn kana kɛ a ra. Ni o kɛra, a ta saraka bɛ mina. ");
INSERT INTO dyu_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Fiyɛn bɛ bɛgan min na, aw kana o kɛ saraka ye; ni o tɛ, o saraka tɛna mina. ");
INSERT INTO dyu_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ni mɔgɔ dɔ b’a fɛ ka ninsɔndiya saraka bɔ k’a di Matigi Ala ma k’a ta dajuru dafa, walama ni a yɛrɛ diyanya saraka lo, ni a kɛra misi ye, walama saga, walama ba, a y’a to fiyɛn si kana kɛ o bɛgan na, nɔ kana kɛ a ra, janko a ta saraka ye mina. ");
INSERT INTO dyu_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Bɛgan min fiyenna, walama min sen kelen man ɲi, walama min fari yɔrɔ dɔ tigɛra ka bɔ a ra, walama jori bɛ min fari ra, walama sɔninya, walama warawara, aw man kan ka o dɔ kɛ saraka ye. Aw man kan ka o dɔ kɛ saraka ye k’a jɛni sarakajɛnifɛn kan Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Misi, walama saga min sen kelen ka jan, walama min sen kelen ka surun, aw bɛ se ka o kɛ aw yɛrɛ diyanya saraka ye; nka a tɛ se ka kɛ dajurudafa saraka ye. ");
INSERT INTO dyu_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Bɛgan min kiliw cɛnna, walama ni a cira, walama ni a bɔra, walama ni a tigɛra, aw man kan ka o dɔ kɛ saraka ye k’a di Matigi Ala ma. O bɛgan ɲɔgɔn man kan ka kɛ saraka ye aw ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ni lonan dɔ ka o bɛgan ɲɔgɔn dɔ di, aw kana sɔn ka o mina ka o kɛ aw ta Ala ta saraka ye; sabu o bɛganw fari yɔrɔ dɔw tigɛtigɛra, walama nɔ dɔ bɛ o ra; o saraka tɛ mina.» ");
INSERT INTO dyu_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ayiwa, Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Ni misiden, walama sagaden, walama baden worora, o den ka kan ka to ni a ba ye ka tere wolonfla le kɛ. Ni a ka tere seegi sɔrɔ, walama ni a tɛmɛna o kan, o tuma le ra a bɛ se ka kɛ saraka jɛnita ye k’a di Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Nka aw kana bɛgan ni a den faga lon kelen na, ni a kɛra misi ye, walama saga, walama ba. ");
INSERT INTO dyu_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«Ni aw bɛ ɲumanlɔn saraka le bɔ ne ye, aw y’a kɛ ka kaɲa ni a cogo ye, janko Ala ye aw ta saraka mina. ");
INSERT INTO dyu_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ni aw ka saraka bɔ lon min na, aw ye a sogo bɛɛ domu o lon yɛrɛ le ra. Aw man kan k’a to a tɔ ye si. Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Aw ka kan ka sɔn ne ta sariyaw ma ka o sira tagama, sabu ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Aw kana ne tɔgɔ saninman cɛn. Izirayɛlimɔgɔw bɛɛ ka kan k’a lɔn ko ne saninyanin lo. Ne le ye Matigi Ala ye, min bɛ aw saninya. ");
INSERT INTO dyu_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ne ka aw labɔ Misiran jamana ra, ka kɛ aw ta Ala ye. Ne le ye Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Kuma Izirayɛlimɔgɔw fɛ, i ye a fɔ o ye ko aw ka kan ka ɲanagbɛ minw kɛ ka Matigi Ala bonya, o ka kan ka kɛ jamalajɛnbaw le ye ka Matigi Ala bato. O ɲanagbɛw flɛ nin ye. ");
INSERT INTO dyu_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«Aw ye baara kɛ tere wɔɔrɔ; a tere wolonflanan ye Nɛnɛkirilon* le ye. Mɔgɔ man kan ka baara kɛ o lon na. Aw ka kan ka jamalajɛnba kɛ o lon na. Aw man kan ka baara foyi kɛ; ni aw ka kɛ yɔrɔ o yɔrɔ, aw ka kan ka o lon bla a danna ka Matigi Ala bonya.» ");
INSERT INTO dyu_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«Aw ka kan ka ɲanagbɛ minw fana kɛ Matigi Ala ye, ka jamalajɛnba kɛ ka Matigi Ala bonya, o ɲanagbɛw wagatiw ye nin ye: ");
INSERT INTO dyu_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","San karo fɔlɔ, tere tan ni naani wulada fɛ, o bɛna kɛ Jɔnyaban ɲanagbɛ* ye; aw ye o kɛ ka Matigi Ala bonya. ");
INSERT INTO dyu_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Karo tere tan ni looru, o bɛna kɛ Burufunubari ɲanagbɛ* ye; aw bɛ o fana kɛ ka Matigi Ala bonya. Aw bɛna burufunubari domu ka se fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","O lɔgɔkun tere fɔlɔ, aw bɛ jamalajɛnba kɛ ka Matigi Ala bato. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na. ");
INSERT INTO dyu_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Aw ye saraka jɛnitaw bɔ Matigi Ala ye ka se fɔ tere wolonfla. A tere wolonflanan, aw bɛna jamalajɛnba kɛ tuun ka Ala bato. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na.» ");
INSERT INTO dyu_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«A fɔ Izirayɛlimɔgɔw ye ko ne bɛna jamana min di aw ma, ni aw sera o jamana ra, ni aw nana aw ta simanw tigɛ, aw ye na ni siman kansiri kelen ye sarakalasebaga fɛ; o ye kɛ aw ta siman fɔlɔ tigɛnin ye. ");
INSERT INTO dyu_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Sarakalasebaga bɛna o siman kansiri fifa ne ɲa kɔrɔ Nɛnɛkirilon* dugusagbɛ, ka o di ne ma saraka ye. Ni o kɛra, o saraka bɛna mina. ");
INSERT INTO dyu_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","O siman kansiri bɛna di saraka ye ne ma lon min na, o lon kelen na, aw ka kan ka sagaden cɛman kelen kɛ saraka jɛnita ye, min ka san kelen sɔrɔ, ani fiyɛn tɛ min na. ");
INSERT INTO dyu_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Aw ye mugu tɛntɛnnin kilo wɔɔrɔ nɔɔni turu ra, ka o fara a kan, ka o jɛni, o bɛ kɛ siman saraka* jɛnita ye, min jɛnina tasuma ra Matigi Ala ye, min kasa ka di. Aw ye rɛzɛnji litiri kelen ni tarancɛ fana kɛ rɛzɛnji saraka ye, ka o bɔn a kan. ");
INSERT INTO dyu_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Mɔgɔ si man kan ka o simankura dɔ kɛ buru ye k’a domu, walama k’a yiran k’a ɲimi, walama k’a kɛnɛ ɲimi, fɔ kansiri fɔlɔ ye di Matigi Ala ma fɔlɔ. Nin ye sariya wuribari le ye aw ni aw ta durujaw fɛ. Ni aw nana taga sigi yɔrɔ o yɔrɔ, aw ye nin sariya sira tagama.» ");
INSERT INTO dyu_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«Ayiwa, aw ka siman kansiri fɔlɔ di sarakalasebaga ma Nɛnɛkirilon* min na ko a ye a fifa k’a kɛ saraka ye, k’a damina o Nɛnɛkirilon dugusagbɛ ra, aw ye lɔgɔkun wolonfla dafanin jate, ");
INSERT INTO dyu_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ka taga a bla fɔ Nɛnɛkirilon wolonflanan dugusagbɛ ra; o bɛ kɛ tere bilooru. Ayiwa, o lon na, aw ka kan ka siman saraka dɔ wɛrɛ bɔ ne ye tuun. ");
INSERT INTO dyu_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Aw bɛna burukun fla lalaga aw ta sow kɔnɔ, ka na ni o ye sarakalasebaga fɛ, janko sarakalasebaga ye o buruw fifa. Aw ka kan ka o buruw bɛɛ kelen kelen lalaga ni mugu tɛntɛnnin kilo wɔɔrɔ ye, ka burufunufɛn kɛ a ra. O ye aw ta simankuraw fɛn fɔlɔ ye; aw ye o di Matigi Ala ma saraka ye. ");
INSERT INTO dyu_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ka fara o buruw kan, aw ye na ni sagaden cɛman wolonfla ye, fiyɛn tɛ minw na, ani minw ka san kelen bɔ, ani misitoran kaɲaman kelen, ani sagajigi fla; aw ye o kɛ saraka jɛnita ye ka o di Matigi Ala ma. Siman saraka ni rɛzɛnji saraka* min ka kan ka bɔ, aw ye o fana fara a kan; o bɛ kɛ saraka jɛnita ye, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Aw ye bakɔrɔnin kelen kɛ jurumunyafa saraka ye; ka sagaden fla kɛ ninsɔndiya saraka ye, minw ka san kelen sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Sarakalasebaga bɛna o sagaden fla sarakaw fifa Matigi Ala ɲa kɔrɔ, ani simankura ta buruw, ani sagaden fla. O sarakaw bɛ kɛ sarakalasebaga ta ye, sabu o blara danna Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","O lon kelen na, aw bɛna o ɲanagbɛ kɛ, ka jamalajɛnba kɛ ka Matigi Ala bato. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na. Nin ye sariya wuribari le ye aw ni aw ta durujaw fɛ; ni aw nana taga sigi yɔrɔ o yɔrɔ, aw ka kan ka nin sariya sira tagama. ");
INSERT INTO dyu_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«Ni aw nana kɛ siman tigɛ ye aw ta jamana ra tuma min na, aw ye aw ta foro kɛrɛfɛyɔrɔ ta simanw to yi, aw kana o kan; siman minw fana kanbari tora, walama minw benbenna, aw kana sekɔ ka taga olugu kan tuun. Aw ye o to fagantanw ni lonanw ye; sabu ne le ye Matigi Ala ye, aw ta Ala.» ");
INSERT INTO dyu_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«A fɔ Izirayɛlimɔgɔw ye ko san karo wolonflanan, a tere fɔlɔ, o bɛna kɛ Nɛnɛkirilon* ye aw fɛ, ka aw hakiri jigi ne ra. Aw bɛna burufiyɛkanw bɔ jamana yɔrɔ bɛɛ ra o lon na, ka jamalajɛnba kɛ ka ne bato. ");
INSERT INTO dyu_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na, ka saraka jɛnitaw bɔ Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«O karo wolonflanan tere tan, o le bɛna kɛ Jurumun yafalonba ye. Aw bɛna jamalajɛnba kɛ ka Matigi Ala bato, ka aw yɛrɛ majigi Ala ɲa kɔrɔ, ka saraka jɛnitaw bɔ Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Aw man kan ka baara si kɛ o lon na, sabu Jurumun yafalonba lo. Aw ta jurumunw ka kan ka yafa o lon le ra ne ɲa kɔrɔ, ne Matigi Ala, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Mɔgɔ o mɔgɔ tɛ a yɛrɛ majigi o lon na, o tigi ka kan ka faran ka bɔ Izirayɛlimɔgɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ni mɔgɔ o mɔgɔ fana ka baara kɛ o lon na, ne bɛna o tigi halaki ka bɔ Izirayɛlimɔgɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Aw man kan ka baara kɛ o lon na. Nin ye sariya wuribari le ye aw ni aw ta durujaw bɛɛ fɛ, aw sigiyɔrɔw bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","O lon bɛna kɛ Nɛnɛkirilon* le ye, i n’a fɔ lɔgɔkun tere wolonflanan. Aw ka kan ka aw yɛrɛ majigi Ala ɲa kɔrɔ. Aw ye o Nɛnɛkirilon bla danna Ala ye, k’a damina karo tere kɔnɔntɔnnan wula fɛ, ka taga a bla fɔ a tere tannan wula fɛ.» ");
INSERT INTO dyu_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«A fɔ Izirayɛlimɔgɔw ye ko o karo wolonflanan tere tan ni looru, o bɛna kɛ Gbatakɔrɔsigi ɲanagbɛ* ye. Aw bɛna o ɲanagbɛ kɛ fɔ tere wolonfla ka Matigi Ala bonya. ");
INSERT INTO dyu_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","A tere fɔlɔ, aw bɛna jamalajɛnba kɛ ka Ala bato. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na. ");
INSERT INTO dyu_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","O tere wolonfla kɔnɔ, aw bɛna saraka jɛnitaw bɔ ka o di Matigi Ala ma. A tere seeginan, aw bɛna jamalajɛnba kɛ tuun, ka saraka jɛnitaw bɔ Matigi Ala ye. Aw bɛna o jamalajɛnba kɛ Matigi Ala ye. Aw ka kan ka aw ta baara tɔw bɛɛ dabla. ");
INSERT INTO dyu_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«Ayiwa, ɲanagbɛ minw ka kan ka kɛ ka Matigi Ala bonya, ani jamalajɛnba minw ka kan ka kɛ, olugu le ye nin ye. Aw ka kan ka o kɛ, janko ka sarakaw jɛni Matigi Ala ye: saraka jɛnitaw, ani siman sarakaw, ani ninsɔndiya sarakaw, ani rɛzɛnji sarakaw. Aw ka kan ka o sarakaw bɛɛ kɛ ka kaɲa ni a cogo ye. ");
INSERT INTO dyu_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Nka o sarakaw nin tɛ Nɛnɛkirilonw ta sarakaw ra, ani aw bɛ deri ka saraka tɔ minw di Ala ma kakɔrɔ, ani aw ta dajurudafa sarakaw, ani aw yɛrɛ diyanya sarakaw. ");
INSERT INTO dyu_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«Ayiwa, o karo wolonflanan tere tan ni loorunan, ni aw ka aw ta jamana simanw tigɛ, aw bɛna gbatakɔrɔsigi ɲanagbɛ* kɛ tere wolonfla, ka Matigi Ala bonya. O ɲanagbɛ tere fɔlɔ bɛna kɛ Nɛnɛkirilon* ye, a tere seeginan fana bɛ kɛ Nɛnɛkirilon ye. ");
INSERT INTO dyu_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","A tere fɔlɔ, aw ye yiridenɲuman dɔw tigɛtigɛ, ani tamaro yiriborow, ani yiri flaburumanw, ani jidarayiri misɛn dɔw ta yiriborow. Aw ye o mina aw boro, ka to ka o fifa, ka toron kɛ, ka ɲagari Matigi Ala ɲa kɔrɔ, fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","San o san, aw ka kan ka o ɲanagbɛ kɛ tere wolonfla ka Matigi Ala bonya. O ye sariya wuribari le ye aw ni aw ta durujaw fɛ. Aw ka kan k’a kɛ san karo wolonflanan. ");
INSERT INTO dyu_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","O tere wolonfla bɛɛ ra, aw bɛna kɛ si ye fanibonw* le kɔnɔ. Izirayɛli jamanadenw bɛɛ ka kan ka si fanibonw le kɔnɔ o lonw na, ");
INSERT INTO dyu_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","janko aw ta denw y’a lɔn ko ne ka Izirayɛlimɔgɔw labɔ Misiran jamana ra tuma min na, ko o tun bɛ sira fanibonw le kɔnɔ. Ne le ye Matigi Ala ye, aw ta Ala.» ");
INSERT INTO dyu_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ayiwa, Izirayɛlimɔgɔw ka kan ka ɲanagbɛ minw kɛ ka Matigi Ala bonya, Musa ka o ɲanagbɛw bɛɛ yira o ra nin cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«A fɔ Izirayɛlimɔgɔw ye ko o ye na ni oliviye turu yɛrɛworo ye, ka na a don fitinadaga saninmanw kɔnɔ, janko fitinaw mananin ye to wagati bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Boncɛtigɛfani min ka jɛnɲɔgɔnya kɛsu* dogo, Haruna bɛna fitinaw labɛn o fani le ɲa fɛ Ɲɔgɔnkunbɛn fanibon* kɔnɔ, janko o fitinaw ye mana wagati bɛɛ Matigi Ala ɲa kɔrɔ, k’a ta wula fɛ fɔ ka taga dugu gbɛ. O ye sariya wuribari le ye aw ni aw ta durujaw fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Haruna bɛna fitinaw bla fitinablanan kan, min lalagara ni sanin yɛrɛworo ye, k’a to o ye mana wagati bɛɛ Matigi Ala ɲa kɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Aw ye mugu tɛntɛnnin dɔ kɛ ka burukun tan ni fla lalaga. Mugu kilo wɔɔrɔ le ka kan ka don burukun kelen kelen bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","I bɛna o buruw blabla ɲɔgɔn kan, k’a kɛ layɔrɔ fla, sanintabali kan, Matigi Ala ɲa kɔrɔ. Layɔrɔ kelen kelen bɛɛ ye kɛ burukun wɔɔrɔ wɔɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","I ye wusunan yɛrɛworo dɔ kɛ o buruw layɔrɔ kelen kelen bɛɛ kan k’a yira ko o buruw bɛɛ ye Matigi Ala ta le ye, i n’a fɔ saraka min jɛnina tasuma ra Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Nɛnɛkirilon* o Nɛnɛkirilon, aw ka kan ka o buruw labɛn tabali kan Matigi Ala ɲa kɔrɔ, wagati bɛɛ. O ye jɛnɲɔgɔnya wuribari le ye ne ni Izirayɛlimɔgɔw cɛ. ");
INSERT INTO dyu_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","O buruw bɛna kɛ Haruna ni a dencɛw ta ye. O ka kan k’a domu yɔrɔ saninman* dɔ le ra, sabu o buru saninyanin lo kosɛbɛ. Ala ka o di o ma i n’a fɔ saraka minw jɛnina tasuma ra Matigi Ala ye, o sarakaw sogo dira o ma cogo min na. Nin fana ye sariya wuribari le ye Izirayɛlimɔgɔw fɛ.» ");
INSERT INTO dyu_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ayiwa, Izirayɛlimuso dɔ tun furura Misirankacɛ dɔ ma. Lon dɔ, olugu dencɛ le nana Izirayɛlimɔgɔw cɛ ra, ka na kɛrɛ kɛ ni Izirayɛlicɛ dɔ ye. ");
INSERT INTO dyu_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","A ka nɛnini kɛ fɔ ka Ala tɔgɔ cɛn. O k’a mina ka taga ni a ye Musa fɛ. A bamuso tɔgɔ tun ye ko Selomiti; a bamuso facɛ tɔgɔ tun ye ko Dibiri. O tun bɛ bɔ Dan ta gba le ra. ");
INSERT INTO dyu_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","O k’a mina k’a bla kaso ra, sani o ye kuma dɔ sɔrɔ ka bɔ Matigi Ala fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ayiwa, Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Aw ye bɔ ni Alatɔgɔcɛnbaga ye kɛnɛ ma. Minw bɛɛ ka kumajugu mɛn a da ra, olugu bɛɛ ye o borow la a kun na; jama bɛɛ ye a bon ni kabakuru ye fɔ k’a faga.» ");
INSERT INTO dyu_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ala k’a fɔ Musa ye ko: «A fɔ Izirayɛlimɔgɔw ye ko, ni mɔgɔ o mɔgɔ ka Ala tɔgɔ cɛn, o hakɛ ka kan ka bɔ o tigi ra; ");
INSERT INTO dyu_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","o tigi ka kan ka faga. Jama bɛɛ ye a bon ni kabakuru ye k’a faga. Ni a kɛra lonan ye, walama dugulen, a ka kan ka faga, sabu a ka Ala tɔgɔ cɛn. ");
INSERT INTO dyu_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«Ni mɔgɔ o mɔgɔ k’a mɔgɔɲɔgɔn bugɔ k’a faga, o tigi fana ka kan ka faga. ");
INSERT INTO dyu_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","«Ni mɔgɔ min ka dɔ ta bɛgan bugɔ k’a faga, a ka kan k’a ɲɔgɔn di. Bɛgan ɲanaman dɔ le bɛ kɛ ka bɛgan faganin juru sara. ");
INSERT INTO dyu_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","«Ni mɔgɔ dɔ k’a mɔgɔɲɔgɔn mandimi, o tigi fana bɛ mandimi a ɲɔgɔn ye; ");
INSERT INTO dyu_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ni min ka mɔgɔ dɔ kolo kari, o ta ka kan ka kari a ɲɔgɔn ye; ni min ka mɔgɔ ɲa ci, o ta ka kan ka ci a ɲɔgɔn ye; ni min ka mɔgɔ ɲin bɔn, o ta ka kan ka bɔn a ɲɔgɔn ye; ni i ka nɔ o nɔ kɛ i mɔgɔɲɔgɔn na, o nɔ ɲɔgɔn ka kan ka kɛ i ra fana. ");
INSERT INTO dyu_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","«Ni mɔgɔ min ka dɔ ta bɛgan faga, a tigi ka kan k’a ɲɔgɔn di. Nka ni mɔgɔ min ka mɔgɔ faga, o tigi ka kan ka faga a ɲɔgɔn ye. ");
INSERT INTO dyu_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","«Ayiwa, nin sariyaw sigira mɔgɔ bɛɛ le kama, lonan fara dugulen kan; sabu ne le ye Matigi Ala ye, aw ta Ala.» ");
INSERT INTO dyu_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Ayiwa, Musa ka o kuma fɔ Izirayɛlimɔgɔw ye ka ban minkɛ, o ka Alatɔgɔcɛnbaga mina ka bɔ ni a ye kɛnɛ ma, ka taga a bon ni kabakuru ye fɔ k’a faga. O cogo ra, Matigi Ala tun ka min fɔ Musa ye, Izirayɛlimɔgɔw k’a kɛ ten. ");
INSERT INTO dyu_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Matigi Ala kumana Musa fɛ Sinayi kuru kan, k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Kuma Izirayɛlimɔgɔw fɛ, k’a fɔ o ye ko: ‹Ne bɛna jamana min di aw ma, ni aw nana taga don o jamana ra, ni wagati dɔ nana se, aw ka kan ka a to aw ta dugukolo ye nɛnɛkiri. Aw bɛna o kɛ nɛnɛkiri wagati le ye, ka Matigi Ala bonya. ");
INSERT INTO dyu_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Aw bɛna aw ta forow sɛnɛ ka se fɔ san wɔɔrɔ, ka simanw dan a ra, ka o tigɛ, ka aw ta rɛzɛnsunw kun tigɛtigɛ janko a ye den ka ɲa, k’a rɛzɛnmɔ tigɛ. ");
INSERT INTO dyu_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Nka a san wolonflanan, o bɛna kɛ dugukolo ta nɛnɛkirisan ye; aw ye nɛnɛkiri o san na, ka Matigi Ala bonya. O san na, aw man kan ka siman dan aw ta forow ra, aw man kan ka aw ta rɛzɛnsunw kun tigɛtigɛ fana janko o ye den ka ɲa. ");
INSERT INTO dyu_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Hali simankisɛ minw benbenna dugu ma simantigɛwagati ra, ka falen o yɛrɛ ma foro kɔnɔ, ni olugu ka den, aw man kan ka o siman tigɛ, k’a lajɛn aw yɛrɛ fɛ. Ni aw ta rɛzɛnsunw fana tora o yɛrɛ ma yi ka den minw kɛ, aw man kan ka o denw tigɛ fana k’a lajɛn aw yɛrɛ fɛ; sabu o san ye dugukolo ta nɛnɛkirisan le ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Fɛn minw bɛna falen o yɛrɛ ma kongo kɔnɔ, o ka kan ka labla bɛɛ le ye, ka kɛ bɛɛ ta baro ye: aw yɛrɛw, ani aw ta baaraden cɛmanw ni a musomanw, ani minw bɛ baara kɛ aw fɛ sara ra, ani lonan tɛmɛbaga minw bɛ aw fɛ, ");
INSERT INTO dyu_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ani aw ta bɛganw, ani kongosogow bɛɛ. O san ta simanw bɛ kɛ bɛɛ ta baro le ye.› » ");
INSERT INTO dyu_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","« ‹Ayiwa, ni nɛnɛkirisan wolonfla ka tɛmɛ, o bɛ kɛ san wolonfla sigiyɔrɔma wolonfla ye; o nɛnɛkirisan wolonfla bɛɛ bɛna kɛ san binaani ni kɔnɔntɔn ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","O san binaani ni kɔnɔntɔnnan karo wolonflanan tere tan, aw ye buruw fiyɛ ka mankanba bɔ. O ye jurumun yafalonba le ye. Aw ye buru fiyɛ ka mankanba bɔ jamana yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Aw ye san biloorunan bla danna ka Matigi Ala bonya. Aw ye mɔgɔw labla jamana kɔnɔ, ka forow labla o tigiw ye; bɛɛ ye kɛ a yɛrɛ ta ye o san na. O san bɛna kɛ yafarisan le ye aw fɛ. Minw tun ka o ta dugukolow tɔnɔmasigi, olugu ta dugukolow ye kɔsegi o ma; jɔnw bɛɛ ye labla, o ye sekɔ ka taga o ta somɔgɔw fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","O san biloorunan bɛna kɛ aw fɛ yafarisan le ye. Aw man kan ka siman dan. Siman minw wurira o yɛrɛ ma aw ta foro kɔnɔ, aw man kan ka o simanw kan k’a lajɛn aw yɛrɛ fɛ. Ni aw ta rɛzɛnsunw fana tora o yɛrɛ ma yi ka den minw kɛ, aw man kan ka o denw tigɛ ka o lajɛn aw yɛrɛ fɛ; ");
INSERT INTO dyu_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","sabu yafarisan lo; aw ka kan ka o san jate i n’a fɔ san saninman. Ni siman minw falenna kongo ra o yɛrɛ ma, o le bɛna labla bɛɛ ye, ka kɛ bɛɛ ta baro ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","O nɛnɛkirisan na, min o min tun k’a ta dugukolo tɔnɔmasigi, olugu ta dugukolo ye kɔsegi o ma. ");
INSERT INTO dyu_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","« ‹Ayiwa, ni aw bɛ foro dɔ san, walama ni aw bɛ foro dɔ fiyeere aw ta jamana mɔgɔ dɔ ma, dɔ man kan ka ben dɔ kan. ");
INSERT INTO dyu_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Foro bɛ se ka sɛnɛko da min kɛ tuun sani ka yafarisan dɔ wɛrɛ se, aw ka kan ka o sanw le jate k’a sɔngɔ fɔ, ka kaɲa ni o ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Foro bɛ se ka sɛnɛko da min kɛ tuun sani ka yafarisan dɔ wɛrɛ se, ni o sandaw belen ka ca, o tuma foro sɔngɔ ka kan ka caya, nka ni a sanw man ca, dɔ ka kan ka bɔ a sɔngɔ ra; sabu siman tigɛko da min bɛna bɔ foro ra, a bɛ i n’a fɔ o siman le bɛ fiyeerera. ");
INSERT INTO dyu_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Mɔgɔ si man kan k’a mɔgɔɲɔgɔn janfa. Aw ye siran Ala ɲa; ne le ye Matigi Ala ye, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Aw ye ne ta sariyaw, ani ne ta cifɔninw bɛɛ kɛ, k’a sira tagama ka ɲa. Ni o kɛra, aw bɛna to hɛra ni laganfiya ra aw ta jamana kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Aw ta forow simanw bɛna ɲa; aw bɛna domuni sɔrɔ caman, ka to hɛra ni laganfiya ra aw ta jamana kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","« ‹Aw bɛ se k’a fɔ ko aw bɛna mun le sɔrɔ k’a domu nɛnɛkirisan na, sabu aw tɛna danni kɛ, aw tɛna siman tigɛ fana. ");
INSERT INTO dyu_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ayiwa, ne bɛna baraka don aw ta san wɔɔrɔnan siman na, k’a caya k’a to a ye aw baro fɔ san saba. ");
INSERT INTO dyu_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","San seeginan, aw bɛna aw ta simanw dan. Nka aw bɛna to ka san wɔɔrɔnan ta simanw tɔ le domu belen, fɔ ka taga se san seeginan ta simankura ma.› » ");
INSERT INTO dyu_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","« ‹Aw man kan ka aw ta dugukolo yɔrɔ si fiyeere, aw ka kan k’a tɔnɔmasigi dɔrɔn le; sabu aw bɛ jamana min na, o ye ne ta jamana le ye. Aw bɛ i n’a fɔ lonan tɛmɛbagaw, walama lonan minw siginin bɛ ne ta jamana ra. ");
INSERT INTO dyu_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Aw ta jamana yɔrɔ bɛɛ ra, aw ka kan ka sariya dɔ sigi min b’a to mɔgɔ ye se k’a ta foro kunmabɔ. ");
INSERT INTO dyu_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","O ra, ni fagantanya benna dɔ kan, fɔ k’a jagboya k’a to a k’a ta foro yɔrɔ dɔ tɔnɔmasigi, a balema min ye a ta somɔgɔ yɛrɛyɛrɛ dɔ ye, o ka kan ka na a balemacɛ ta foro kunmabɔ a ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ni mɔgɔ tɛ mɔgɔ min fɛ, min bɛ se k’a ta foro kunmabɔ, ni a yɛrɛ nana se ka foro kunmabɔsara sɔrɔ, ");
INSERT INTO dyu_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","sanda min tora sani yafarisan ye se, o sanda le bɛ jate ka foro wari fɔ; a dakɔrɔ tɛ tuun. Ni o kɛra, a ta foro bɛ sekɔ a ma. ");
INSERT INTO dyu_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ayiwa, ni foyi tɛ a tigi boro k’a ta foro kunmabɔ, o tuma, foro tɔnɔmasigira min ma, a bɛ to o tigi fɛ, fɔ ka taga yafarisan se. Ni yafarisan sera, forotigi ta foro bɛ sekɔ a ma. A tun tɔnɔmasigira min ma, ale ka kan ka sabari ka foro to a tigi ye.› » ");
INSERT INTO dyu_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","« ‹Ni mɔgɔ min k’a ta so tɔnɔmasigi; k’a sɔrɔ o so bɛ dugu min kɔnɔ, o dugu lamininin bɛ ni kogo ye, sotigi ka kan k’a ta so kunmabɔ sani san kelen ye dafa. Kunmabɔri bɛ dan o san kelen le ma. ");
INSERT INTO dyu_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Nka ni san minina ka bɛn k’a sɔrɔ a ma a ta so kunmabɔ, o tuma kunmabɔri banna. So tɔnɔmasigira min ma, a bɛ kɛ ale ni a ta denw ta ye wagati bɛɛ. Hali ni yafarisan sera, a tɛ bɔ o so kɔnɔ tuun. ");
INSERT INTO dyu_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","« ‹Dugudennin minw ma lamini ni kogo ye, olugu ta sow tɔnɔmasigiri bɛ kɛ i n’a fɔ forow ta. Olugu bɛ se ka kunmabɔ tuma bɛɛ; ni yafarisan sera fana, so tɔnɔmasigira min ma, o ka kan ka so to a tigi ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","« ‹Ayiwa, min kɛra Levi ta mɔgɔw ye, ni olugu dɔ ka o ta so tɔnɔmasigi o yɛrɛ ta dugu dɔ ra, ni wagati o wagati ka bɛn o ma, o bɛ se ka o so kunmabɔ. ");
INSERT INTO dyu_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ni Levi ta mɔgɔ dɔ k’a ta so dɔ tɔnɔmasigi a yɛrɛ ta dugu dɔ ra, ni a ma na se k’a kunmabɔ, ni yafarisan sera, min ka so san, o tigi ka kan ka bɔ so kɔnɔ k’a to Levi ta mɔgɔ ye; sabu so minw bɛ Levi ta mɔgɔw fɛ o yɛrɛ ta duguw ra, Izirayɛli jamana ra, o sow ye o ta le ye; a tɛ se ka mina o ra fiyewu. ");
INSERT INTO dyu_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Foro minw bɛ Levi ta mɔgɔw fɛ, o ta duguw kɛrɛ fɛ, mɔgɔ si man kan ka o forow san; sabu o ye o ta le ye wagati bɛɛ.› » ");
INSERT INTO dyu_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","« ‹Ayiwa, ni fagantanya benna i balema dɔ kan i kɔrɔ, fɔ ka na a kɛ ko a dɛsɛra pewu, hali ni lonan lo walama ni tɛmɛbaga lo, i ka kan k’a dɛmɛ, janko a ye to aw kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ni i ka wari juru don a ra, i kana tɔnɔ ɲini a ra, i kana dɔ fara fɛn sɔngɔ kan; i ka kan ka siran Ala ɲa, k’a to i mɔgɔɲɔgɔn ye to i kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ni i ka wari juru don mɔgɔ ra, i kana tɔnɔ ɲini a ra. Ni i ka domunifɛn fiyeere a ma juru ra, i kana dɔ fara a sɔngɔ kan. ");
INSERT INTO dyu_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ne le ye Matigi Ala ye, aw ta Ala. Ne le ka aw labɔ Misiran jamana ra, ka na Kanaana jamana di aw ma, ka kɛ aw ta Ala ye.› » ");
INSERT INTO dyu_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","« ‹Ayiwa, ni fagantanya benna i balema Izirayɛlimɔgɔ dɔ kan i kɔrɔ, fɔ ka na a kɛ ko a k’a yɛrɛ fiyeere i ma, ko a bɛ kɛ i ta jɔn ye, i man kan k’a jɔnyamina. ");
INSERT INTO dyu_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","A ka kan ka baara kɛ i fɛ i n’a fɔ i ta baaraden dɔ, walama i ko i ta lonan tɛmɛbaga dɔ; a bɛna baara kɛ i fɛ fɔ ka taga yafarisan se. ");
INSERT INTO dyu_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ni yafarisan sera, a bɛ bɔ ka taga a ta so, ani a ta denw, ka taga sigi a faw ta yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Izirayɛlimɔgɔw bɛɛ ye ne Matigi Ala kelen ta jɔnw le ye; sabu ne le ka o labɔ Misiran jamana ra. O kosɔn Izirayɛlimɔgɔ si man kan ka fiyeere mɔgɔ ma ka kɛ o tigi ta jɔn ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Aw man kan ka aw balema Izirayɛlimɔgɔ si jɔnyamina, k’a minako juguya; aw ye siran Ala ɲa. ");
INSERT INTO dyu_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","« ‹Siya wɛrɛ mɔgɔ minw bɛ aw ta jamana lamini na, aw bɛ se ka aw ta jɔncɛw ni aw ta jɔnmusow bɔ o siyaw le ra. Aw bɛ se ka olugu dɔw le san ka o kɛ aw ta jɔncɛw ni aw ta jɔnmusow ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Lonan tɛmɛbaga minw nana sigi aw ta jamana ra, aw bɛ se ka olugu ta denw fana san ka o kɛ aw ta jɔnw ye, hali ni a kɛra ko o denw worora aw ta jamana ra le. O jɔn ɲɔgɔnw le bɛ kɛ aw ta ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","O jɔnw bɛna kɛ aw denw fana ta cɛn ye, aw kɔ. O bɛna to jɔnya ra aw fɛ, fɔ ka taga o sa. Nka aw man kan ka aw balema Izirayɛlimɔgɔ dɔ jɔnyamina, k’a minako juguya. ");
INSERT INTO dyu_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","« ‹Ayiwa, lonan minw siginin bɛ aw fɛ, walama minw nana wagati dɔ kɛ aw fɛ, ni o dɔ ka kɛ naforobatigi ye, k’a sɔrɔ aw balema Izirayɛlimɔgɔ dɔ kɛra fagantan ye a kɔrɔ, fɔ ka na a yɛrɛ fiyeere o lonan ma, walama o lonan ta mɔgɔ dɔ ma, ko a bɛ kɛ a ta jɔn ye, ");
INSERT INTO dyu_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","a fiyeerenin kɔ, a bɛ se ka kunmabɔ. A kɔrɔcɛ walama a dɔgɔcɛ dɔ bɛ se k’a kunmabɔ o jɔnya ra. ");
INSERT INTO dyu_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","A facɛ balemacɛ, walama o dencɛ, walama a ta somɔgɔ dɔ wɛrɛ fana bɛ se k’a kunmabɔ; walama ni se nana kɛ a yɛrɛ ye, a yɛrɛ bɛ se k’a yɛrɛ kunmabɔ. ");
INSERT INTO dyu_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","O tuma, sanda min bɛ o wagati ni yafarisan cɛ, a bɛ o jate ni a matigicɛ ye. A kunmabɔwari bɛ jate ka kaɲa ni o sandaw le ye; warida min bɛ di baaraden ma o sanda ɲɔgɔn kɔnɔ, o warida le ka kan ka di a kunmabɔsara ye a matigicɛ ma. ");
INSERT INTO dyu_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ni o wagati ni yafarisan cɛ ye san caman ye, a bɛna wari caman le sekɔ a matigicɛ ma a kunmabɔri sara ye, ka kaɲa ni o sandaw ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Nka ni a wagati ni yafarisan cɛ ye san dama dɔrɔn ye, a bɛna wari dɔɔnin dɔrɔn le sekɔ a matigicɛ ma, ka kaɲa ni o sandaw ye. ");
INSERT INTO dyu_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","« ‹Ni Izirayɛlimɔgɔ dɔ k’a yɛrɛ fiyeere lonan ma, o lonan ka kan ka o Izirayɛlimɔgɔ jate i ko baaraden min bɛ baara kɛra a fɛ san kɔnɔ. Aw man kan k’a to a ye a jɔnyamina, k’a minako juguya. ");
INSERT INTO dyu_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ni o Izirayɛlimɔgɔ ma se ka kunmabɔ cogo si ra, o tuma, yafarisan le ra a bɛ kɛ a yɛrɛ ta ye; a ni a ta denw bɛ taga o ta so; ");
INSERT INTO dyu_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","sabu Izirayɛlimɔgɔw ye ne Matigi Ala kelen ta jɔnw le ye. Ne ta jɔnw lo; ne le ka o labɔ Misiran jamana ra. Ne le ye Matigi Ala ye, aw ta Ala.› » ");
INSERT INTO dyu_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Matigi Ala k’a fɔ tuun ko: «Aw kana batofɛn gbansan si bato. Aw kana fɛn dɔ bisigiya lalaga ni bɔgɔ ye walama nɛgɛ, walama ni fɛn wɛrɛ ye k’a bato. Aw kana farakuru si kɛ aw ta batofɛn ye fana, walama ka kabakuru dɔ ɲɛgɛnɲɛgɛn ka lɔ a ɲa fɛ k’a bato. Ne le ye Matigi Ala ye, aw ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ne ka Nɛnɛkirilon minw fɔ aw ye, aw ka kan ka o lonw jate; aw ka kan ka bonya la ne ta batoyɔrɔ saninman kan fana. Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Ni aw ka ne ta sariyaw sira tagama, ka ne ta cifɔninw kɛ, ");
INSERT INTO dyu_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","o tuma ne bɛna sanji di aw ma a wagati ra, aw ta sɛnɛfɛnw bɛna ɲa, kongoyiriw bɛɛ bɛna den. ");
INSERT INTO dyu_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Aw ta sɛnɛfɛnw bɛna ɲa, k’a kɛ fɔ sani siman ye gbasi ka ban, o b’a sɔrɔ ko rɛzɛnw fana mɔna; sani rɛzɛnmɔw ye tigɛ ka ban, o b’a sɔrɔ ko simankura dantuma sera fana. Aw bɛna domuni sɔrɔ caman, k’a domu ka fa aw sago ma. Aw bɛ kɛ hɛra ni laganfiya ra jamana yɔrɔ bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ne bɛna hɛra kɛ jamana yɔrɔ bɛɛ ra. Aw bɛna la ka sunɔgɔ, mɔgɔ tɛna aw lasiran. Ne bɛna kongowaraw bɛɛ gbɛn ka bɔ jamana kɔnɔ. Kɛrɛ tɛna se aw ta jamana ma. ");
INSERT INTO dyu_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Aw juguw bɛɛ bɛna bori aw ɲa; aw bɛ o gbɛn ka o faga. ");
INSERT INTO dyu_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Aw ra cɛ looru bɛna aw jugu cɛ kɛmɛ gbɛn. Cɛ kɛmɛ bɛ cɛ waga tan gbɛn. Aw bɛ o gbɛn ka o faga. ");
INSERT INTO dyu_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ne bɛna ne hakiri to aw ra, ka den caman di aw ma, ka aw ta siya caya. Ne bɛna to ne ta jɛnɲɔgɔnya ra ni aw ye. ");
INSERT INTO dyu_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Sani aw ye aw ta simankɔrɔw domu ka ban, o b’a sɔrɔ ko simankuraw sera. Aw bɛna simankɔrɔw labɔ bondow kɔnɔ, ka simankuraw ladon o nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ne bɛna sigi aw cɛ ra; ne tɛna aw kɔninya fiyewu. ");
INSERT INTO dyu_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ne bɛna kɛ ni aw ye tuma bɛɛ; ne bɛ kɛ aw ta Ala ye, aw bɛ kɛ ne ta mɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ne le ye Matigi Ala ye, aw ta Ala. Ne le ka aw labɔ Misiran jamana ra, jɔnya ra. Ne ka jɔnya juru tigɛ ka bɔ aw kan na, ka aw kun kɔrɔtanin labɔ Misiran.» ");
INSERT INTO dyu_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Matigi Ala k’a fɔ tuun ko: «Nka ni aw ma ne lamɛn, ni aw ma ne ta cifɔninw bɛɛ kɛ, ");
INSERT INTO dyu_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ni aw ma ne ta sariyaw jate, ni aw ka ne ta cifɔninw kɔninya ka ban ka o kɛ, ni aw ka ne ta jɛnɲɔgɔnya cɛn, ");
INSERT INTO dyu_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ne bɛna min kɛ aw ra, o flɛ nin ye: Ne bɛna cɛnri lase aw ma. Ne bɛna banajuguw bla aw ra, k’a kɛ farigban ye aw ra, ka aw ɲadenw baraka dɔgɔya; dɔ le bɛna to ka bɔ aw ra lon o lon. Aw bɛna siman dan ka dɛsɛ, aw tɛ foyi sɔrɔ a ra; aw juguw le bɛna a bɛɛ domu. ");
INSERT INTO dyu_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ne bɛna juguya aw ma kosɛbɛ. Aw juguw bɛna se aw ra; aw kɔninyabagaw bɛna sigi aw kunna. Siranya kosɔn, aw bɛna bori k’a sɔrɔ mɔgɔ yɛrɛ tɛ aw gbɛnna. ");
INSERT INTO dyu_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Ni o tɔɔrɔw bɛɛ kɔ aw belen ma ne lamɛn, o tuma ne bɛna dɔ fara aw ta tɔɔrɔw kan, ka aw ta jurumunw hakɛ bɔ aw ra fɔ siɲaga wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ne bɛna aw ta yɛrɛbonya bɔ aw ra pewu. Sankolo bɛna ja i ko nɛgɛ, ka dugukolo ja i ko siranɛgɛ. ");
INSERT INTO dyu_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Aw bɛna baara kɛ ka aw yɛrɛ sɛgɛ gbansan. Aw ta foro simanw tɛna ɲa, yiriw tɛna den fana. ");
INSERT INTO dyu_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«O bɛɛ kɔ, ni aw belen ka aw jusukun gbɛlɛya, ka ban ka ne lamɛn, o tuma ne bɛna dɔ fara aw ta tɔɔrɔw kan, ka aw ta jurumunw hakɛ bɔ aw ra fɔ siɲaga wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ne bɛna kongowaraw su aw ra. O bɛna aw ta denw faga, ka aw ta bɛganw fana faga, fɔ ka aw ta siya dɔgɔya. Tɛmɛbagaw bɛna dɔgɔya siraw kan. ");
INSERT INTO dyu_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Ni o tɔɔrɔw belen ma aw yɛlɛma, ni aw belen ka aw jusukun gbɛlɛya, ");
INSERT INTO dyu_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ne fana bɛna ne jusukun gbɛlɛya aw kama; ne Ala, ne bɛna dɔ fara aw ta tɔɔrɔw kan tuun, ka aw ta jurumunw hakɛ bɔ aw ra fɔ siɲaga wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ne bɛna kɛrɛ lase aw ma; aw ka ne ta jɛnɲɔgɔnya cɛn minkɛ, ne bɛna o hakɛ bɔ aw ra. Ni aw ka bori ka taga dogo aw ta dugubaw kɔnɔ, ne bɛna banajuguw ben aw kan ka aw caman faga, ka aw mina ka aw don aw juguw boro. ");
INSERT INTO dyu_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ne bɛna kɔngɔba ben aw kan, fɔ muso tan bɛna aw bɛɛ ta domuni tobi gba kelen kan, k’a suma sumanikɛminan kɔnɔ, ka dɔɔnin dɔɔnin di aw ma; a bɛna a domu, nka a tɛna kɔngɔ bɔ aw ra. ");
INSERT INTO dyu_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Ayiwa, ni o bɛɛ kɔ aw belen ma ne lamɛn, ni aw belen ka aw jusukun gbɛlɛya, ");
INSERT INTO dyu_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ne fana bɛna ne jusukun gbɛlɛya aw kama, ka fariya aw ma, ka dɔ fara aw ta tɔɔrɔw kan, ka aw ta jurumunw hakɛ bɔ aw ra fɔ siɲaga wolonfla. ");
INSERT INTO dyu_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Aw bɛna aw dencɛw sogo domu, ka aw denmusow sogo domu. ");
INSERT INTO dyu_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","«Aw ka aw ta sɔnnikɛyɔrɔ minw lɔ kongoriw kunna, ne bɛna o bɛɛ cici. Aw bɛ wusunan bɔ aw ta jow ye kabakuru minw kan, ne bɛna o bɛɛ benben. Ne bɛna aw yɛrɛ suw firifiri aw yɛrɛ ta jow suw kan. Ne bɛna aw kɔninya. ");
INSERT INTO dyu_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ne bɛna aw ta dugubaw kɛ tomow ye, ka aw ta sɔnnikɛyɔrɔw cɛn. Aw ta saraka kasadimanw si tɛna diya ne ye tuun. ");
INSERT INTO dyu_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ne bɛna aw ta jamana bɛɛ cɛn, fɔ aw jugu minw bɛna aw ta jamana ta, olugu yɛrɛ bɛna kabakoya tuun. ");
INSERT INTO dyu_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ne bɛna kɛrɛ gban aw ra, fɔ ka aw janjan ka taga jamana wɛrɛw ra. Aw ta jamana bɛɛ bɛna halaki; aw ta dugubaw bɛɛ bɛna kɛ tomow ye. ");
INSERT INTO dyu_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","«Ni o kɛra, ka aw janjannin to aw juguw ta jamanaw ra, ani ka jamana lakolon to, jamana bɛna nɛnɛkiri. Aw tun ka kan ka jamana to a ye nɛnɛkiri san minw na, a bɛna nɛnɛkiri o sanw bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Tuma min na aw tun bɛ jamana ra, aw banna k’a to dugukolo ye nɛnɛkiri san minw na, a lakolon bɛna to ka nɛnɛkiri o wagatiw bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«Aw ra minw ɲanaman bɛna to o juguw ta jamana ra, ne bɛna siranyabana le bla olugu ra. Hali ni o ka flaburu gbansan mankan le mɛn, o bɛ bori. O bɛ bori fɔ ka taga bɔ ka ben i n’a fɔ o bɛ kɛrɛ ra ni mɔgɔ dɔ le ye, k’a sɔrɔ mɔgɔ si tɛ o gbɛnna. ");
INSERT INTO dyu_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","O bɛ bori ka taga benben ɲɔgɔn kan, i n’a fɔ o bɛ kɛrɛ le ra, k’a sɔrɔ mɔgɔ si tɛ o kɔ. Aw tɛna se ka lɔ aw juguw ɲa tuun. ");
INSERT INTO dyu_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","A laban, siya wɛrɛ mɔgɔw bɛna aw halaki. O ta jamanaw bɛna aw domu ka aw ban pewu. ");
INSERT INTO dyu_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Minw ɲanaman bɛna to aw ra, ne bɛna olugu halaki o juguw ta jamanaw ra, o ta jurumunw, ani o bɛmaw ta jurumunw kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«O bɛɛ n’a ta, aw ta denw bɛna lɔ o ta terenbariyaw ra, ani o bɛmaw ta terenbariyaw ra, ka ne daari; o ka o jurumun minw kɛ ka ne hakɛ ta, ani o ka o jusukun gbɛlɛya ne kama cogo min na, o bɛna lɔ o bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","O jurumunw le kosɔn, ne fana ka ne jusukun gbɛlɛya o kama, ka o janjan ka taga o juguw ta jamanaw ra. Nka ni olugu nana o ta jusukungbɛlɛya dabla, ka o yɛrɛ majigi, ni o ta terenbariyakow hakɛ bɔra o ra, ");
INSERT INTO dyu_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","o tuma, ne tun ka jɛnɲɔgɔnya min don ni o bɛmacɛw ye, Yakuba, ani Isiyaka, ani Iburahima, ne bɛna ne hakiri to o jɛnɲɔgɔnya ra. Ne tun ka jamana min layiri ta aw ye, ne bɛna ne hakiri to o ra fana. ");
INSERT INTO dyu_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Nka o bɛna bɔ ka jamana lakolon to. O tun ka kan ka dugukolo to a ye nɛnɛkiri san minw na, o tuma jamana lakolon bɛna to, janko a ye nɛnɛkiri o wagatiw bɛɛ ra. O wagati ra fana, o ta terenbariyakow bɛɛ hakɛ bɛna bɔ o ra, sabu o ma ne ta cifɔninw jate, o ka ne ta sariyaw cɛn. ");
INSERT INTO dyu_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Nka o bɛɛ n’a ta, hali ka o to o juguw ta jamana ra, ne tɛna ban o ra, ka o kɔninya fɔ ka taga o ta siya tunu, fɔ ka taga ne ta jɛnɲɔgɔnya dabla ni o ye; sabu ne le Matigi Ala ye, o ta Ala. ");
INSERT INTO dyu_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ne tun ka jɛnɲɔgɔnya min don ni o bɛmaw ye, ka o labɔ Misiran jamana ra siya tɔw bɛɛ ɲa na, ka kɛ o ta Ala ye, ne bɛna ne hakiri to o jɛnɲɔgɔnya ra; sabu ne le ye Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ayiwa, Matigi Ala ka sariyaw ni ciw ni kuma minw fɔ Musa ye Sinayi kuru kan, ko a ye a fɔ Izirayɛlimɔgɔw ye, olugu le ye nin ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Matigi Ala kumana Musa fɛ k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Kuma Izirayɛlimɔgɔw fɛ, i y’a fɔ o ye ko ni mɔgɔ dɔ ka dajuru ta Matigi Ala fɛ, ko a bɛna mɔgɔ dɔ le bla danna Matigi Ala ye, ayiwa, o tigi bɛ se ka wari di mɔgɔ nɔ ra ka o dajuru dafa. ");
INSERT INTO dyu_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","A ka dajuru ta ko a bɛ mɔgɔ min bla danna Matigi Ala ye, ni o tigi si bɛ san mugan ni san biwɔɔrɔ cɛ, ni cɛ lo, a bɛ warigbɛ bilooru le di a nɔ ra, ka kaɲa ni yɔrɔ saninman* ta jate ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ni muso lo, o ye warigbɛ bisaba ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ni a tigi si bɛ san looru ni san mugan cɛ, ni cɛ lo, o ye warigbɛ mugan. Ni muso lo, o ye warigbɛ tan. ");
INSERT INTO dyu_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ni a tigi si bɛ karo kelen ni san looru cɛ, ni cɛ lo, o ye warigbɛ looru. Ni muso lo, o ye warigbɛ saba. ");
INSERT INTO dyu_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ni a tigi si ye san biwɔɔrɔ, walama ni a tɛmɛna o kan, ni cɛ lo, o ye warigbɛ tan ni looru. Ni muso lo, o ye warigbɛ tan. ");
INSERT INTO dyu_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","«Ayiwa, warida min fɔra, ni o se tɛ dajurutabaga ye, o tuma a ka mɔgɔ min bla danna Matigi Ala ye, a ye taga ni o ye sarakalasebaga fɛ. Sarakalasebaga bɛna a flɛ, ka da dɔ yira ka kaɲa ni dajurutabaga ta sɔrɔta ye.» ");
INSERT INTO dyu_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«Ayiwa, ni dajuru tara ni bɛgan le ye, bɛgan min bɛ se ka kɛ saraka ye k’a di Matigi Ala ma, ni o bɛgan ka di Matigi Ala ma, o bɛgan bɛ kɛ Matigi Ala ta le ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","A man kan ka o bɛgan falen dɔ wɛrɛ ra; ka cɛjugu dɔ bla ɲumanman dɔ nɔ ra, walama ka ɲumanman dɔ bla cɛjugu dɔ nɔ ra. Ni a ko a bɛ a falen, o tuma o bɛgan fla bɛɛ le bɛ kɛ Matigi Ala ta ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","«Ayiwa, ni dajuru tara ni bɛgan dɔ ye, min tɛ se ka kɛ saraka ye k’a di Matigi Ala ma, dajurutabaga ka kan ka taga ni o bɛgan ye sarakalasebaga fɛ. ");
INSERT INTO dyu_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Sarakalasebaga bɛna warida dɔ fɔ, min bɛ bɛn bɛgan sɔngɔ ma, ka kaɲa ni bɛgan cogo ye. Ni a ka min fɔ, o le bɛ jate. ");
INSERT INTO dyu_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ni bɛgantigi b’a fɛ ka bɛgan kunmabɔ, a ka kan ka o warida le di. O kɔ, ni a k’a sɔngɔ taran taranyɔrɔ looru, taran kelen bɛ bɛn da min ma, a ye o fana di ka o fara a wari kan.» ");
INSERT INTO dyu_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«Ni mɔgɔ dɔ k’a ta bon di Matigi Ala ma, ko a ye bla danna Matigi Ala ye, sarakalasebaga bɛ o bon flɛ, k’a sɔngɔ fɔ ka kaɲa ni bon cogo ye. Ni a ka sɔngɔ min fɔ, o le bɛ jate. ");
INSERT INTO dyu_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Min ka bon di, ni ale b’a fɛ ka bon kunmabɔ, sarakalasebaga ka warida min fɔ, a bɛ o le di. O kɔ, ni a k’a sɔngɔ taran taranyɔrɔ looru, taran kelen bɛ bɛn da min ma, a ye o fana di ka o fara a kan. O tuma bon bɛ kɛ a ta ye tuun.» ");
INSERT INTO dyu_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«Ni mɔgɔ dɔ ka foro dɔ sɔrɔ cɛn ye a faw fɛ, ni a ka o foro yɔrɔ dɔ di Matigi Ala ma, siman hakɛya min bɛ se ka dan o foro ra, a sɔngɔ bɛ fɔ ka kaɲa ni o le ye. Ni siman kilo kɛmɛ saba lo, foro sɔngɔ bɛ bɛn warigbɛ bilooru ma. ");
INSERT INTO dyu_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ni a ka foro di Ala ma yafarisan le laban na, o sɔngɔ min fɔra, o le bɛ jate. ");
INSERT INTO dyu_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ni a ka foro di Ala ma, k’a sɔrɔ yafarisan tɛmɛna ka san dama dama kɛ ka ban, sanda min tora sani yafarisan dɔ wɛrɛ ye se, foro sɔngɔ bɛ fɔ ka kaɲa ni o sandaw le ye. O tuma, dɔ bɛ bɔ foro sɔngɔ ra. ");
INSERT INTO dyu_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ni forotigi b’a fɛ k’a ta foro kunmabɔ, a ka kan ka foro sɔngɔ di. O kɔ, ni a k’a sɔngɔ taran taranyɔrɔ looru, taran kelen bɛ bɛn da min ma, a ye o fana di ka o fara a kan. Ni o kɛra, foro bɛ kɛ a ta ye tuun. ");
INSERT INTO dyu_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ni a ma foro kunmabɔ, ni o nana foro fiyeere mɔgɔ wɛrɛ ma, o tuma ale tɛ se ka o foro kunmabɔ tuun. ");
INSERT INTO dyu_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Min ka foro san, ni o tigi nana foro labla yafarisan na, o foro bɛ kɛ Matigi Ala ta ye. A bɛ kɛ i n’a fɔ a k’a boro bɔ o foro kan le pewu. O foro bɛ kɛ sarakalasebagaw ta ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«Ni mɔgɔ dɔ ka foro dɔ san, ka o foro di Matigi Ala ma, k’a sɔrɔ o foro tɛ a yɛrɛ ta cɛn ye, ");
INSERT INTO dyu_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","sanda min tora sani yafarisan ye se, sarakalasebaga bɛna a sɔngɔ fɔ ka kaɲa ni o le ye. Min ka foro di, o tigi ka kan k’a kunmabɔ o lon yɛrɛ ra. A wari bɛ bla danna Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ni yafarisan sera, foro tun sanna min fɛ, min ta cɛn lo, a bɛ kɔsegi o tigi ma. ");
INSERT INTO dyu_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","«Warida bɛɛ ka kan ka fɔ ka kaɲa ni yɔrɔ saninman ta jate da le ye. O jate ra, o warigbɛ kelen bɛ bɛn garamu tan ni fla ma.» ");
INSERT INTO dyu_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«Mɔgɔ si man kan k’a ta bɛgan den fɔlɔ cɛman di Matigi Ala ma; o ye Matigi Ala ta le ye ka ban, sabu den fɔlɔ o den fɔlɔ, ni cɛ lo, ni a kɛra misi le ye walama saga, walama ba, o ye Matigi Ala ta le ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ni a kɛra bɛgan dɔ le ye, min tɛ se ka kɛ saraka ye, o tuma a bɛ warida min bɔ, o ye a kunmabɔ ni o warida ye. O kɔ, ni a k’a sɔngɔ taran taranyɔrɔ looru, taran kelen bɛ bɛn da min ma, a ye o fana di ka o fara a kan. Ni a ma kunmabɔ, o tuma a bɛ da min bɔ ka kaɲa ni sarakalasebaga ta jate ye, aw ye a fiyeere o ra. ");
INSERT INTO dyu_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«Ni mɔgɔ k’a boro bɔ a ta borofɛn min o min kan pewu, k’a di Matigi Ala ma, ni a kɛra mɔgɔ le ye o, walama bɛgan o, walama a ka foro min sɔrɔ cɛn ye o, o fɛn tɛ se ka fiyeere tuun, a fana tɛ se ka kunmabɔ tuun. Ni mɔgɔ k’a boro bɔ fɛn o fɛn le kan pewu, k’a di Ala ma, o fɛn bɛ kɛ fɛn saninyaninba le ye, k’a bla a danna Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","«Ni boro bɔra mɔgɔ o mɔgɔ fana kan pewu, ko a ye halaki, o tigi fana tɛ se ka kunmabɔ; a ka kan ka faga le.» ");
INSERT INTO dyu_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«Yaga bɛɛ ye Matigi ta le ye; ni a kɛra siman le ye, walama yiriden, Matigi ta lo. Fɛn dɔ lo min blara danna Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ni mɔgɔ dɔ b’a fɛ k’a ta yaga kunmabɔ, a ka kan k’a sɔngɔ di. O kɔ, ni a ka o sɔngɔ taran taranyɔrɔ looru, taran kelen bɛ bɛn da min ma, a ye o fana di ka o fara a kan. ");
INSERT INTO dyu_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Yaga o yaga, ni misi lo, walama saga, walama ba, den tan o den tan, aw ka kan ka kelen bɔ ka o bla danna Matigi Ala le ye. ");
INSERT INTO dyu_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Bɛgantigi man kan k’a ta bɛganw woloma k’a yaga di. Ni cɛjugu lo, walama ni cɛɲuman lo, ni yaga ka bɛn min ma, a ye o le di. A man kan ka dɔ falen dɔ ra. Ni a ko a bɛ a falen, o tuma bɛgan fla bɛɛ le bɛ kɛ Matigi Ala ta ye. O fla si tɛ se ka kunmabɔ fana.» ");
INSERT INTO dyu_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ayiwa, Matigi Ala ka sariya minw fɔ Musa ye Sinayi kuru kan, ko a ye o fɔ Izirayɛlimɔgɔw ye, o sariyaw le ye nin ye.");
INSERT INTO dyu_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Izirayɛlimɔgɔw bɔnin Misiran, o san flanan, o san karo flanan, o karo tere fɔlɔ, Matigi Ala kumana Musa fɛ Sinayi kongokolon kɔnɔ, Ɲɔgɔnkunbɛn fanibon* kɔnɔ. A ko: ");
INSERT INTO dyu_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Aw ye Izirayɛlimɔgɔw bɛɛ jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. Aw ye cɛdenw bɛɛ le jate; ");
INSERT INTO dyu_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Izirayɛli cɛ min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, ni a bɛ se ka taga kɛrɛ ra, aw ye o bɛɛ jate, o bɛɛ ni o ta kɛrɛkɛjama. Ele ni Haruna ye o jateri kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Izirayɛli ta jamakuruw bɛɛ kelen kelen ta mɔgɔ dɔ bɛna fara aw kan, min ye gbatigi ye, ka o jateri kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Mɔgɔ minw bɛna fara aw kan, olugu tɔgɔw ye nin ye: «Rubɛn ta gba ra, Sedehuri dencɛ Elisuri bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","«Simeyɔn ta gba ra, Surisadayi dencɛ Selumiyɛli bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","«Zuda ta gba ra, Aminadabu dencɛ Nasɔn bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","«Isakari ta gba ra, Suwari dencɛ Netanehɛli bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","«Zabulɔn ta gba ra, Helɔn dencɛ Eliyabu bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","«Yusufu dencɛ Efirayimu ta gba ra, Amihudi dencɛ Elisama bɛna fara aw kan. «Yusufu dencɛ Manase ta gba ra, Pedasuri dencɛ Gamiliyɛli bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","«Boniyaminu ta gba ra, Gidehoni dencɛ Abidan bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","«Dan ta gba ra, Amisadayi dencɛ Ahezɛri bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","«Asɛri ta gba ra, Okiran dencɛ Pagiyɛli bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","«Gadi ta gba ra, Dewɛli dencɛ Eliyasafu bɛna fara aw kan. ");
INSERT INTO dyu_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","«Nɛfitali ta gba ra, Enan dencɛ Ahira bɛna fara aw kan.» ");
INSERT INTO dyu_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","O ka o mɔgɔw le ɲanawoloma jama ra. Olugu le tun ye o faw ta jamakuruw ta kuntigiw ye; olugu le kɛra Izirayɛli ta kɛrɛkɛjamaw kuntigiw ye. ");
INSERT INTO dyu_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","O mɔgɔ minw tɔgɔw fɔra, Musa ni Haruna ka o mɔgɔw fara o yɛrɛ kan; ");
INSERT INTO dyu_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","o ka Izirayɛli jama bɛɛ lajɛn o san karo flanan tere fɔlɔ ra. O ka cɛdenw bɛɛ tɔgɔ sɛbɛ ka kaɲa ni o ta gbaw ye; o bɛɛ ni o ta gba, o bɛɛ ni o ta somɔgɔw. Min o min si ka san mugan bɔ, ani minw tɛmɛna o kan, o ka o bɛɛ jate kelen kelen. ");
INSERT INTO dyu_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Musa ka o jate Sinayi kongokolon kɔnɔ, i n’a fɔ Matigi Ala tun k’a fɔ a ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","O ka Izirayɛli dencɛ fɔlɔ Rubɛn ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Rubɛn ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga binaani ni wɔɔrɔ ni cɛ kɛmɛ looru (46 500). ");
INSERT INTO dyu_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","O ka Simeyɔn ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Simeyɔn ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga bilooru ni kɔnɔntɔn ni cɛ kɛmɛ saba (59 300). ");
INSERT INTO dyu_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","O ka Gadi ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gadi ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga binaani ni looru, ani cɛ kɛmɛ wɔɔrɔ, ni cɛ bilooru (45 650). ");
INSERT INTO dyu_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","O ka Zuda ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Zuda ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga biwolonfla ni naani ni cɛ kɛmɛ wɔɔrɔ (74 600). ");
INSERT INTO dyu_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","O ka Isakari ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Isakari ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga bilooru ni naani ni cɛ kɛmɛ naani (54 400). ");
INSERT INTO dyu_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","O ka Zabulɔn ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zabulɔn ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga bilooru nin wolonfla ni cɛ kɛmɛ naani (57 400). ");
INSERT INTO dyu_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","O ka Yusufu dencɛ Efirayimu ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Efirayimu ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga binaani ni cɛ kɛmɛ looru (40 500). ");
INSERT INTO dyu_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","O ka Yusufu dencɛ Manase ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manase ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga bisaba ni fla ni cɛ kɛmɛ fla (32 200). ");
INSERT INTO dyu_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","O ka Boniyaminu ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Boniyaminu ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga bisaba ni looru ni cɛ kɛmɛ naani (35 400). ");
INSERT INTO dyu_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","O ka Dan ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga biwɔɔrɔ ni fla ni cɛ kɛmɛ wolonfla (62 700). ");
INSERT INTO dyu_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","O ka Asɛri ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Asɛri ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga binaani ni kelen ni cɛ kɛmɛ looru (41 500). ");
INSERT INTO dyu_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","O ka Nɛfitali ta mɔgɔw jate, bɛɛ ni i ta gba, bɛɛ ni i ta somɔgɔw. O ka cɛdenw bɛɛ kelen kelen jate; min o min ka san mugan sɔrɔ, ani min o min tɛmɛna o kan, min o min bɛ se ka taga kɛrɛ ra, o ka olugu bɛɛ jate. ");
INSERT INTO dyu_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Nɛfitali ta cɛden minw jatera, o bɛɛ lajɛnnin kɛra cɛ waga bilooru ni saba ni cɛ kɛmɛ naani (53 400). ");
INSERT INTO dyu_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ayiwa, Musa ni Haruna, ani Izirayɛli kuntigi tan ni fla ka o mɔgɔw le jate. Kuntigi kelen kelen tun bɔra gba bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","O ka Izirayɛli cɛdenw jate bɛɛ ni i ta somɔgɔw; minw ka san mugan sɔrɔ, ani minw tɛmɛna o kan, Izirayɛli cɛden min o min tun bɛ se ka taga kɛrɛ ra, ");
INSERT INTO dyu_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","o minw bɛɛ jatera, o bɛɛ kɛra cɛ waga kɛmɛ wɔɔrɔ ni cɛ waga saba ani cɛ kɛmɛ looru ni bilooru (603 550). ");
INSERT INTO dyu_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Levi ta mɔgɔw, olugu ta gba nin ma kɛ o jateri ra; ");
INSERT INTO dyu_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","sabu Matigi Ala tun k’a fɔ Musa ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«I kana Levi ta gbamɔgɔw jate; i kana o jate ni Izirayɛlimɔgɔ tɔw ye. ");
INSERT INTO dyu_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ala ta jɛnɲɔgɔnya kɛsu* bɛ Ɲɔgɔnkunbɛn fanibon min kɔnɔ, i ka kan ka o baara karifa Levi ta mɔgɔw le ma, ani a minanw, ani a fɛn tɔw bɛɛ. Olugu le bɛna to ka Ɲɔgɔnkunbɛn fanibon ni a minan bɛɛ ta, ka o janto o fɛnw na; o bɛna o ta fanibonw lɔ ka Ɲɔgɔnkunbɛn fanibon lamini. ");
INSERT INTO dyu_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ni aw tagatuma ka se, Levi ta mɔgɔw le bɛna Ɲɔgɔnkunbɛn fanibon waraga, k’a faniw kuru. Ni aw tagara lɔ yɔrɔ dɔ ra, olugu le bɛna fanibon lɔ. Ni mɔgɔ wɛrɛ ka maga a ra, o tigi ka kan ka faga. ");
INSERT INTO dyu_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Izirayɛli gba bɛɛ kelen kelen ka kan ka o ta fanibonw lɔ o a ta yɔrɔ le ra, o ta darapo kɔrɔ, o bɛɛ ni o ta kɛrɛkɛjama. ");
INSERT INTO dyu_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Nka Levi ta mɔgɔw, olugu ka kan ka o ta fanibonw lɔ ka Ɲɔgɔnkunbɛn fanibon lamini, jɛnɲɔgɔnya kɛsu bɛ min kɔnɔ; ni o kɛra, ne ta jusugban tɛna ben Izirayɛlimɔgɔw kan. Levi ta mɔgɔw ka kan ka o janto Ɲɔgɔnkunbɛn fanibon na, jɛnɲɔgɔnya kɛsu bɛ min kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ayiwa, Matigi Ala ka fɛn o fɛn fɔ Musa ye, Izirayɛlimɔgɔw ka o bɛɛ kɛ a cogo ra. ");
INSERT INTO dyu_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Matigi Ala kumana Musa ni Haruna fɛ, k’a fɔ o ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Izirayɛlimɔgɔw ka kan ka o ta fanibonw lɔ o ta kɛrɛkɛjamabaw ta tagamasiyɛn le kɔrɔ, ani o ta gba ta darapo kɔrɔ. O ka kan ka o ta fanibonw lɔ ka Ɲɔgɔnkunbɛn fanibon lamini, k’a mabɔ Ɲɔgɔnkunbɛn fanibon na dɔɔnin. ");
INSERT INTO dyu_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","«Jɛnkuru minw bɛɛ bɛ Zuda ta kɛrɛkɛjamaba ra, olugu bɛɛ bɛna sigi terebɔyanfan na, o ta darapo kɔrɔ, o bɛɛ ni o ta jɛnkuru. Zuda ta mɔgɔw ta kuntigi ye Aminadabu dencɛ Nasɔn ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ale ta jɛnkuru jate ye cɛ waga biwolonfla ni naani, ani cɛ kɛmɛ wɔɔrɔ (74 600). ");
INSERT INTO dyu_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","«Isakari ta mɔgɔw bɛna kɛ olugu kɛrɛ fɛ. Isakari ta mɔgɔw ta kuntigi ye Suwari dencɛ Netanehɛli ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ale ta jɛnkuru jate ye cɛ waga bilooru ni naani, ani cɛ kɛmɛ naani (54 400). ");
INSERT INTO dyu_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","«O kɔ, Zabulɔn ta mɔgɔw: Zabulɔn ta mɔgɔw ta kuntigi ye Helɔn dencɛ Eliyabu ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ale ta jɛnkuru jate ye cɛ waga bilooru ni wolonfla, ani cɛ kɛmɛ naani (57 400). ");
INSERT INTO dyu_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","«Zuda ta kɛrɛkɛjamaba bɛɛ lajɛnnin jate ye cɛ waga kɛmɛ ni biseegi ni wɔɔrɔ ni cɛ kɛmɛ naani (186 400). Olugu le bɛna kɔn ka sira mina.» ");
INSERT INTO dyu_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","«Jɛnkuru minw bɛɛ bɛ Rubɛn ta kɛrɛkɛjamaba ra, olugu bɛɛ bɛna sigi woroduguyanfan na o ta darapo kɔrɔ, o bɛɛ ni o ta jɛnkuru. Rubɛn ta mɔgɔw ta kuntigi ye Sedehuri dencɛ Elisuri ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ale ta jɛnkuru jate ye cɛ waga binaani ni wɔɔrɔ ni cɛ kɛmɛ looru (46 500), ka kaɲa ni jate ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","«Simeyɔn ta mɔgɔw bɛna sigi olugu kɛrɛ fɛ. Simeyɔn ta mɔgɔw ta kuntigi ye Surisadayi dencɛ Selumiyɛli ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ale ta jɛnkuru jate ye cɛ waga bilooru ni kɔnɔntɔn ni cɛ kɛmɛ saba (59 300), ka kaɲa ni jate ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","«O kɔ, Gadi ta mɔgɔw: Gadi ta mɔgɔw ta kuntigi ye Dewɛli dencɛ Eliyasafu ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ale ta jɛnkuru jate ye cɛ waga binaani ni looru ni cɛ kɛmɛ wɔɔrɔ ni cɛ bilooru (45 650), ka kaɲa ni jate ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","«Rubɛn ta kɛrɛkɛjamaba bɛɛ lajɛnnin jate ye cɛ waga kɛmɛ ni bilooru ni kelen, ani cɛ kɛmɛ naani ni cɛ bilooru (151 450). Olugu le bɛna kɛ kɛrɛkɛjama flanan ye ka sira mina. ");
INSERT INTO dyu_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","«Levi ta mɔgɔw bɛ sɔrɔ ka gban olugu kɔ ni Ɲɔgɔnkunbɛn fanibon ye. Olugu bɛ kɛ gba tɔw bɛɛ cɛmancɛ ra. Sigiyɔrɔ minw yirara o ra, o ka kan ka tagama ka kaɲa ni o sigiyɔrɔw ye. Izirayɛlimɔgɔw bɛɛ bɛ tagama ka kaɲa ni o ta sigiyɔrɔw ye, o ta darapow kɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","«Jɛnkuru minw bɛɛ bɛ Efirayimu ta kɛrɛkɛjamaba ra, olugu bɛɛ bɛna sigi terebenyanfan na, o ta darapo kɔrɔ, o bɛɛ ni o ta jɛnkuru. Efirayimu ta mɔgɔw ta kuntigi ye Amihudi dencɛ Elisama ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ale ta jɛnkuru jate ye cɛ waga binaani ni cɛ kɛmɛ looru (40 500). ");
INSERT INTO dyu_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","«Manase ta mɔgɔw bɛna sigi olugu kɛrɛ fɛ. Manase ta mɔgɔw ta kuntigi ye Pedasuri dencɛ Gamiliyɛli ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ale ta jɛnkuru jate ye cɛ waga bisaba ni fla ni cɛ kɛmɛ fla (32 200). ");
INSERT INTO dyu_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","«O kɔ, Boniyaminu ta mɔgɔw: Boniyaminu ta mɔgɔw ta kuntigi ye Gidehoni dencɛ Abidan ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ale ta jɛnkuru jate ye cɛ waga bisaba ni looru ni cɛ kɛmɛ naani (35 400). ");
INSERT INTO dyu_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","«Efirayimu ta kɛrɛkɛjamaba bɛɛ lajɛnnin jate ye cɛ waga kɛmɛ ni seegi ni cɛ kɛmɛ (108 100). Olugu le bɛna kɛ kɛrɛkɛjama sabanan ye ka sira mina.» ");
INSERT INTO dyu_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","«Jɛnkuru minw bɛ Dan ta kɛrɛkɛjamaba ra, olugu bɛna sigi sahiliyanfan na, o ta darapo kɔrɔ, o bɛɛ ni o ta jɛnkuru. Dan ta mɔgɔw ta kuntigi ye Amisadayi dencɛ Ahezɛri ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ale ta jɛnkuru jate ye cɛ waga biwɔɔrɔ ni fla ni cɛ kɛmɛ wolonfla (62 700). ");
INSERT INTO dyu_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","«Asɛri ta mɔgɔw bɛna sigi olugu kɛrɛ fɛ. Asɛri ta mɔgɔw ta kuntigi ye Okiran dencɛ Pagiyɛli ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ale ta jɛnkuru jate ye cɛ waga binaani ni kelen ni cɛ kɛmɛ looru (41 500), ka kaɲa ni jate ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","«O kɔ, Nɛfitali ta mɔgɔw: Nɛfitali ta mɔgɔw ta kuntigi ye Enan dencɛ Ahira ye. ");
INSERT INTO dyu_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ale ta jɛnkuru jate ye cɛ waga bilooru ni saba, ani cɛ kɛmɛ naani (53 400). ");
INSERT INTO dyu_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan ta kɛrɛkɛjamaba bɛɛ lajɛnnin jate ye cɛ waga kɛmɛ ni bilooru ni wolonfla, ani cɛ kɛmɛ wɔɔrɔ (157 600). Olugu le bɛna sira mina tɔw bɛɛ kɔ fɛ, ni o ta darapow ye.» ");
INSERT INTO dyu_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Izirayɛlimɔgɔ minw jatera, olugu le ye nin ye, o bɛɛ ni o ta gbaw, ani o ta kɛrɛkɛjamaw. O bɛɛ lajɛnnin kɛra cɛ waga kɛmɛ wɔɔrɔ ni saba ni cɛ kɛmɛ looru ni cɛ bilooru (603 550). ");
INSERT INTO dyu_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Levi ta mɔgɔw ma jate ni Izirayɛlimɔgɔ tɔw ye, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ayiwa, Matigi Ala tun ka fɛn o fɛn fɔ Musa ye, Izirayɛlimɔgɔw ka o bɛɛ kɛ; o bɛɛ tun bɛ o ta fanibonw lɔ o ta yɔrɔw le ra, o ta darapow kɔrɔ, o tun bɛ tagama fana ka kaɲa ni o ta gbaw, ani o ta somɔgɔw sigiyɔrɔw le ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Haruna ni Musa ta somɔgɔw flɛ nin ye, wagati min Matigi Ala kumana Musa fɛ Sinayi kuru kan. ");
INSERT INTO dyu_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Haruna dencɛw tɔgɔw ye nin ye: Nadabu, ale kɛra a dencɛ fɔlɔ ye; ka Abihu gban o ra; o kɔ fɛ, Elehazari, o kɔ fɛ Itamari. ");
INSERT INTO dyu_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Haruna dencɛw le ye o ye; turu saninman* kɛra olugu le kan ka o kɛ sarakalasebagaw ye, ka o bla danna sarakalasebagaya kama. ");
INSERT INTO dyu_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nka Nadabu ni Abihu sara Matigi Ala ɲa kɔrɔ ka o to Sinayi kongokolon kɔnɔ, sabu o tun ka wusunan don Matigi Ala ɲa kɔrɔ ni tasuma dɔ ye, min tun bɔra yɔrɔ wɛrɛ ra. Dencɛ tun tɛ o si fɛ. Elehazari ni Itamari le ka sarakalasebagaya kɛ ni o facɛ Haruna ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Matigi Ala kumana Musa fɛ, k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Na ni Levi ta mɔgɔw ye sarakalasebaga Haruna fɛ, janko o ye na to k’a dɛmɛ. ");
INSERT INTO dyu_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Baara min karifara Haruna ni Izirayɛli jama bɛɛ ma, o bɛna o baara kɛ Ɲɔgɔnkunbɛn fanibon* ɲa fɛ; o bɛna fanibon saninman* ta baaraw kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Olugu le bɛna o janto Ɲɔgɔnkunbɛn fanibon ta minanw bɛɛ ra Izirayɛlimɔgɔw nɔ ra, ka fanibon saninman ta baaraw kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","O ra, i ka kan ka Levi ta mɔgɔw di Haruna ni a dencɛw ma. O ka kan ka to olugu le boro, ka baara kɛ Izirayɛlimɔgɔ tɔw nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","I ka kan ka Haruna ni a dencɛw le sigi sarakalasebagaya baara ra. Ni mɔgɔ wɛrɛ ka gbara yɔrɔ saninman na, o tigi ka kan ka faga.» ");
INSERT INTO dyu_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Matigi Ala kumana Musa fɛ tuun, k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Ne ka Levi ta mɔgɔw ɲanawoloma ka o bɔ Izirayɛlimɔgɔw ra, ka o bla ne ta baara ra Izirayɛlimɔgɔw dencɛ fɔlɔw nɔ le ra. O kosɔn Levi ta mɔgɔw ye ne ta le ye; ");
INSERT INTO dyu_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","sabu dencɛ fɔlɔ bɛɛ ye ne ta le ye. Lon min na ne ka Misirankaw dencɛ fɔlɔw bɛɛ faga Misiran jamana ra, o lon na ne ka Izirayɛlimɔgɔw dencɛ fɔlɔw bɛɛ kɛ ne yɛrɛ ta ye, mɔgɔw dencɛ fɔlɔw, ani bɛganw den fɔlɔ cɛmanw fana. O ka kan ka kɛ ne ta le ye. Ne le ye Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Matigi Ala kumana Musa fɛ tuun, Sinayi, kongokolon kɔnɔ; a k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Levi ta mɔgɔw jate, O bɛɛ ni o ta somɔgɔw, o bɛɛ ni o ta gbaw. I ye cɛdenw bɛɛ jate, min o min si ka karo kelen bɔ, ani minw tɛmɛna o kan.» ");
INSERT INTO dyu_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Musa ka o jate ka kaɲa ni Matigi Ala ta kuma ye, i n’a fɔ a tun fɔra cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi dencɛw tɔgɔw le ye nin ye: Gɛrisɔn, ani Kehati, ani Merari. ");
INSERT INTO dyu_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gɛrisɔn dencɛw tɔgɔw ye nin ye, o bɛɛ ni o ta gba: Libini ni Simɛyi. ");
INSERT INTO dyu_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kehati dencɛw tun ye Amuramu ye, ani Isari, ani Heburɔn, ani Uziyɛli; o bɛɛ ni o ta gba. ");
INSERT INTO dyu_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari dencɛw tun ye Mali ni Musi ye; o bɛɛ ni o ta gba. Levi ta gbamɔgɔw le tun ye olugu ye, o bɛɛ ni o ta somɔgɔw. ");
INSERT INTO dyu_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Libini ta gba ni Simɛyi ta gba, olugu bɔra Gɛrisɔn ta gba le ra; olugu le kɛra Gɛrisɔnkaw ta mɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Cɛden minw jatera olugu ra, min o min si ka karo kelen bɔ, ani minw tɛmɛna o kan, olugu bɛɛ kɛra cɛden waga wolonfla ani cɛden kɛmɛ looru (7 500). ");
INSERT INTO dyu_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gɛrisɔnkaw ta sigiyɔrɔ tun bɛ fanibon saninman* kɔ fɛ, terebenyanfan na. ");
INSERT INTO dyu_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gɛrisɔnkaw ta kuntigi tun ye Layɛli dencɛ Eliyasafu ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ɲɔgɔnkunbɛn fanibon* ta baara min karifara Gɛrisɔnkaw ma, o kɛra fanibon kɔnɔnɔfaniw, ani a kɛnɛmafaniw ta baara ye; fani gbiriman, ani fani min bɛ yɔrɔ saninman* donda ra, ");
INSERT INTO dyu_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ani fanibon lukɛnɛ laminifani minw sirinin bɛ ka fanibon saninman ni sarakajɛnifɛn* koori, ani fani min bɛ lu donda ra, ani a juruw, ani o minanw ta baaraw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amuramu ta gba, ani Isari ta gba, ani Heburɔn ta gba, ani Uziyɛli ta gba, olugu bɔra Kehati ta gba le ra; olugu le kɛra Kehatikaw ta mɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Kehatikaw ta cɛden minw jatera, min o min si ka karo kelen bɔ, ani minw tɛmɛna o kan, o kɛra cɛden waga seegi ni cɛden kɛmɛ wɔɔrɔ (8 600). Yɔrɔ saninman* ta baara tun karifara olugu le ma. ");
INSERT INTO dyu_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kehati dencɛw ta mɔgɔw ta sigiyɔrɔ tun bɛ fanibon saninman* woroduguyanfan na. ");
INSERT INTO dyu_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kehatikaw ta mɔgɔw ta kuntigi tun ye Uziyɛli dencɛ Elisafan le ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","O ka Ala ta jɛnɲɔgɔnya kɛsu* ta baara le di olugu ma, ani tabali, ani sanin fitinadaga, ani sarakabɔnanw, ani yɔrɔ saninman ta baara bɛ kɛ ni minan minw ye, ani yɔrɔ saninman cɛtigɛfani, ani o fɛnw ta baaraw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Levi ta mɔgɔw ta kuntigiw bɛɛ ta kuntigiba tun ye sarakalasebaga Haruna dencɛ Elehazari le ye. Mɔgɔ minw blara yɔrɔ saninman baara ra, ale le tun bɛ olugu bɛɛ kunna. ");
INSERT INTO dyu_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Malikaw ta gba, ani Musikaw ta gba, olugu bɔra Merari ta gba le ra. Olugu le kɛra Merarikaw ta mɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Cɛden minw jatera o ra, min o min si ka karo kelen bɔ, ani minw tɛmɛna o kan, o kɛra cɛden waga wɔɔrɔ ni cɛden kɛmɛ fla (6 200). ");
INSERT INTO dyu_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merarikaw ta mɔgɔw ta kuntigi tun ye Abihayili dencɛ Suruyɛli le ye. Olugu ta sigiyɔrɔ tun bɛ fanibon saninman* sahiliyanfan na. ");
INSERT INTO dyu_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Fanibon saninman ta yirifɛrɛnw, ani a berew, ani a nɛgɛberew, ani a nɛgɛberew donyɔrɔw, ani a minan tɔw bɛɛ, o fɛnw kɔrɔsiri ni o baara karifara Merarikaw ma, ");
INSERT INTO dyu_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ani lu laminifani ta nɛgɛberew bɛɛ, ani o nɛgɛberew donyɔrɔw, ani nɛgɛbere minw bɛ turu dugu ma, ani a juruw. ");
INSERT INTO dyu_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa ni Haruna ni a dencɛw, olugu ta sigiyɔrɔ tun bɛ fanibon saninman ɲa fɛ, terebɔyanfan na, Ɲɔgɔnkunbɛn fanibon* ɲa fɛ. Yɔrɔ saninman* kɔrɔsiri ni a baara karifara olugu le ma Izirayɛlimɔgɔw nɔ ra. Ni mɔgɔ wɛrɛ tun ka gbara o yɔrɔ ra, o tigi tun ka kan ka faga. ");
INSERT INTO dyu_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Musa ni Haruna ka Levi ta cɛden minw bɛɛ jate, o bɛɛ ni o ta somɔgɔw, ka kaɲa ni Matigi Ala ta kuma ye, cɛden min o min si ka karo kelen bɔ, ani minw tɛmɛna o kan, olugu bɛɛ lajɛnnin kɛra cɛden waga mugan ni fla (22 000). ");
INSERT INTO dyu_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Matigi Ala k’a fɔ Musa ye ko: «Izirayɛlimɔgɔw dencɛ fɔlɔw bɛɛ jate; min o min si ka karo kelen bɔ, ani minw tɛmɛna o kan. O bɛɛ jate, ka o bɛɛ tɔgɔ sɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Levi ta mɔgɔw bla danna ne Matigi Ala ye, Izirayɛlimɔgɔ tɔw dencɛ fɔlɔw bɛɛ nɔ ra, ka Levi ta mɔgɔw ta bɛganw fana bla danna ne ye, Izirayɛlimɔgɔ tɔw ta bɛganw ta den fɔlɔ cɛmanw bɛɛ nɔ ra.» ");
INSERT INTO dyu_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ayiwa, Musa ka Izirayɛlimɔgɔw dencɛ fɔlɔw bɛɛ jate, ka kaɲa ni Matigi Ala ta kuma ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Minw bɛɛ jatera, ka o tɔgɔ sɛbɛ, min o min si ka karo kelen bɔ, ani minw tɛmɛna o kan, olugu bɛɛ lajɛnnin kɛra cɛden waga mugan ni fla ani cɛden kɛmɛ fla ni mɔgɔ biwolonfla ni saba (22 273). ");
INSERT INTO dyu_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Matigi Ala kumana Musa fɛ, k’a fɔ a ye tuun ko: ");
INSERT INTO dyu_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Levi ta mɔgɔw bla danna ne ye, Izirayɛlimɔgɔw dencɛ fɔlɔw bɛɛ nɔ ra, ka o ta bɛganw fana bla danna ne ye Izirayɛlimɔgɔw ta bɛganw den fɔlɔ cɛmanw bɛɛ nɔ ra. Levi ta mɔgɔw bɛna kɛ ne ta le ye. Ne le ye Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Izirayɛlimɔgɔw dencɛ fɔlɔw hakɛya tɛmɛna Levi ta mɔgɔw hakɛya kan fɔ mɔgɔ kɛmɛ fla ni mɔgɔ biwolonfla ni saba; n’i bɛ olugu kunmabɔcogo, ");
INSERT INTO dyu_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","i bɛ warigbɛ looru mina o cɛdenw bɛɛ kelen kelen fɛ, ka kaɲa ni yɔrɔ saninman* ta jate ye; ka kaɲa ni o jate ye, o warigbɛ jate bɛɛ kelen kelen bɛ bɛn gera mugan le ma. ");
INSERT INTO dyu_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","«I bɛ o wari di Haruna ni a dencɛw ma. Izirayɛlimɔgɔw dencɛ fɔlɔw hakɛya min tɛmɛna Levi ta mɔgɔw hakɛya kan, o wari bɛ kɛ olugu ta kunmabɔri wari le ye.» ");
INSERT INTO dyu_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Musa ka o wari mina. Levi ta cɛden dɔ ma sɔrɔ ka bla Izirayɛlimɔgɔw dencɛ fɔlɔ minw nɔ ra, a ka olugu kunmabɔ ni o wari ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","A ka o wari min mina Izirayɛlimɔgɔw dencɛ fɔlɔw fɛ, o wari bɛɛ kɛra warigbɛ waga kelen ni kɛmɛ saba ni biwɔɔrɔ ni looru (1 365), ka kaɲa ni yɔrɔ saninman* ta jate ye. ");
INSERT INTO dyu_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","A ka o kunmabɔri wari di Haruna ni a dencɛw ma, ka kaɲa ni Matigi Ala ta kuma ye; a k’a kɛ ka kaɲa ni Matigi Ala ta kuma ye. ");
INSERT INTO dyu_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Matigi Ala kumana Musa ni Haruna fɛ, k’a fɔ o ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Aw ye Kehati dencɛw bɛɛ jate Levi ta gba ra, o bɛɛ ni o ta gba, o bɛɛ ni o ta somɔgɔw, ");
INSERT INTO dyu_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","k’a damina san bisaba ra, ka taga se fɔ san bilooru ma, min o min bɛ se ka baara dɔ kɛ Ɲɔgɔnkunbɛn fanibon* kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","«Kehati dencɛw bɛna baara min kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ, o ye nin ye: o bɛna yɔrɔ saninmanba* ta fɛn saninmanw ta baara le kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ni Izirayɛlimɔgɔw tagawagati sera, Haruna ni a dencɛw bɛna boncɛtigɛfani jigi, ka jɛnɲɔgɔnya kɛsu* datugu ni a ye. ");
INSERT INTO dyu_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","O bɛ gbolojalan dɔ fana la a kan, ka fani bulaman dɔ kɛ k’a bɛɛ lajɛnnin datugu. O kɔ, bere minw bɛ kɛ k’a ta, o bɛ o berew don a ra. ");
INSERT INTO dyu_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«O bɛ fani bulaman dɔ fana la sarakaburu tabali kan, ka rɛzɛnji saraka* ta minanw bla a kan, minw ye tasaw ye, ani sɛtiw, ani bɛlɛnw, ani jifiyɛw. Sarakaburu min ka kan ka bɔ wagati bɛɛ, o bɛ o fana bla o tabali kan. ");
INSERT INTO dyu_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","O bɛ fani wulenman dɔ biri a kunna, ka gbolojalan dɔ kɛ k’a bɛɛ lajɛnnin datugu. O kɔ, bere minw bɛ kɛ ka tabali ta, o bɛ o berew don a ra. ");
INSERT INTO dyu_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«O kɔ, o bɛ fani bulaman dɔ fana kɛ ka fitinablanan datugu, ani a fitinadagaw, ani minan minw bɛɛ blara a baara kama, i n’a fɔ tasuma lalagananw, ani buguri donminanw, ani turu donminanw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","O bɛ a ni a minanw bɛɛ melege gbolojalan dɔ kɔnɔ, k’a bla donitanan dɔ kan. ");
INSERT INTO dyu_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«O kɔ, o bɛ fani bulaman dɔ biri sarakabɔnan saninlaman kan, ka gbolojalan dɔ kɛ k’a datugu; o kɔ, bere minw bɛ kɛ k’a ta, o bɛ o don a ra. ");
INSERT INTO dyu_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","«Minan minw bɛɛ bɛ kɛ ka yɔrɔ saninman* ta baara kɛ, o bɛ o bɛɛ don fani bulaman dɔ ra, k’a melege ni gbolojalan dɔ ye, k’a bla donitanan dɔ kan. ");
INSERT INTO dyu_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","«O bɛ bugurigbɛ cɛ ka bɔ sarakajɛnifɛn* kan, ka fani wulenman dɔ biri a kan. ");
INSERT INTO dyu_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","O bɛ sarakajɛnifɛn ta minanw bɛɛ ta, min ye a takamicɛnanw ye, ani a sogosɔgɔnanw, ani a buguricɛnanw, ani a tasaw; o bɛ o bɛɛ bla a kan; o kɔ, o bɛ gbolojalan dɔ kɛ ka o datugu. O kɔ, bere minw bɛ kɛ ka sarakajɛnifɛn ta, o bɛ o berew don a ra. ");
INSERT INTO dyu_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«Ni Haruna ni a dencɛw ka yɔrɔ saninman ni a minanw bɛɛ datugu ka ban tuma min na, ni aw tagatuma sera, Kehatikaw bɛna o minanw ta. Nka o boro kana se o fɛn saninmanw yɛrɛ ma, janko o kana na sa. «Kehatikaw ta baara bɛna kɛ o minanw tari le ye Ɲɔgɔnkunbɛn fanibon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Sarakalasebaga Haruna dencɛ Elehazari le bɛna a janto fitinadaga saninlaman ta turu ko ra, ani wusunan, ani siman saraka* min bɛ bɔ lon o lon, ani turu saninman*; a ka kan k’a janto fanibon saninman ni a kɔnɔfɛnw bɛɛ ra, ani yɔrɔ saninman ni a minanw bɛɛ.» ");
INSERT INTO dyu_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Matigi Ala kumana Musa ni Haruna fɛ tuun, ko: ");
INSERT INTO dyu_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Aw kana kɛ sababu ye k’a to ne ye Kehatikaw halaki ka bɔ Levi ta mɔgɔ tɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Aw ka kan ka min kɛ o ye janko ni o gbarara yɔrɔ saninmanba ra o kana sa, o flɛ nin ye: Haruna ni a dencɛw ka kan ka don fanibon saninman kɔnɔ, ka o bɛɛ kelen kelen ta baara yira o ra, ka o ta donitataw yira o ra. ");
INSERT INTO dyu_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Olugu yɛrɛ man kan ka don ka taga fɛn saninmanw flɛ hali dɔɔnin; ni o tɛ, o bɛ sa.» ");
INSERT INTO dyu_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Gɛrisɔnkaw ta cɛdenw fana jate, o bɛɛ ni o ta gbaw, o bɛɛ ni o ta somɔgɔw. ");
INSERT INTO dyu_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","O jate k’a damina san bisaba ra, ka taga se fɔ san bilooru ma, min o min bɛ se ka baara dɔ kɛ Ɲɔgɔnkunbɛn fanibon* kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gɛrisɔnkaw ka kan ka baara minw kɛ, ani o ka kan ka doni minw ta, o flɛ nin ye: ");
INSERT INTO dyu_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","olugu le bɛna fanibon saninman* ta faniw ta, ani Ɲɔgɔnkunbɛn fanibon* ta fani gbirimanw, ani gbolojalan minw bɛ la fanigbirimanw kan, ani fani min bɛ Ɲɔgɔnkunbɛn fanibon* donda ra, ");
INSERT INTO dyu_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ani fanibon lu laminifani minw sirinin bɛ ka fanibon saninman ni sarakajɛnifɛn* koori, ani fani min bɛ lu donda ra, ani a juruw, ani a minan tɔw bɛɛ. O fɛnw ta baaraw bɛɛ donna Gɛrisɔnkaw le boro. ");
INSERT INTO dyu_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","O bɛ baara o baara kɛ, ni o bɛ doniw le ta, walama baara wɛrɛ, o ka kan ka o bɛɛ kɛ ka kaɲa ni Haruna ni a dencɛw ta fɔta le ye. O ka kan ka fɛn minw bɛɛ ta, aw le ka kan ka o fɔ o ye, ka o ta baaraw di o ma. ");
INSERT INTO dyu_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","«Ayiwa, nin le ye Gɛrisɔnkaw ta baara ye Ɲɔgɔnkunbɛn fanibon kɔnɔ. O ka kan ka o baaraw kɛ ka kaɲa ni sarakalasebaga Haruna dencɛ Itamari ta cifɔninw le ye.» ");
INSERT INTO dyu_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ala k’a fɔ Musa ye tuun ko: «Merari ta cɛw jate, o bɛɛ ni o ta gbaw, o bɛɛ ni o ta somɔgɔw. ");
INSERT INTO dyu_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","I bɛ o jate k’a damina san bisaba ra, ka taga se fɔ san bilooru ma, min o min bɛ se ka baara dɔ kɛ Ɲɔgɔnkunbɛn fanibon* kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","O bɛna baara minw kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ, ani o bɛna doni minw ta o flɛ nin ye: o bɛna fanibon saninman* ta yirifɛrɛnw ta, ani a berew, ani a nɛgɛberew, ani berew donyɔrɔw, ");
INSERT INTO dyu_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ani fanibon lu laminifani ta nɛgɛberew, ani o nɛgɛberew donyɔrɔw, ani nɛgɛbere minw bɛ turu dugu ma, ani a juruw, ani a minan tɔw bɛɛ, ani fɛn o fɛn blara o baara kama. Bɛɛ kelen kelen ka kan ka doni min ta, aw ye o doni yira o tigi ra. ");
INSERT INTO dyu_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","«Ayiwa, nin le ye Merarikaw ta baara ye; o ka kan ka baara minw bɛɛ kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ, ka kaɲa ni sarakalasebaga Haruna dencɛ Itamari ta cifɔninw ye.» ");
INSERT INTO dyu_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa ni Haruna ni Izirayɛli jama ɲamɔgɔw ka Kehatikaw jate, o bɛɛ ni o ta gbaw, o bɛɛ ni o ta somɔgɔw, ");
INSERT INTO dyu_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","k’a damina san bisaba ra, ka taga se fɔ san bilooru ma, min o min tun bɛ se ka baara kɛ Ɲɔgɔnkunbɛn fanibon* kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","O ka minw jate o bɛɛ ni o ta gbaw, olugu kɛra cɛ waga fla, ani cɛ kɛmɛ wolonfla ni bilooru (2 750). ");
INSERT INTO dyu_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Kehatika minw jatera, olugu da le kɛra o ye, minw bɛɛ tun bɛ baara dɔ kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ. Musa ni Haruna ka o jate ka kaɲa ni Matigi Ala ta kuma ye, i n’a fɔ a tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gɛrisɔnka minw jatera, o bɛɛ ni o ta gbaw, o bɛɛ ni o ta somɔgɔw, ");
INSERT INTO dyu_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","k’a damina san bisaba ra, ka taga se fɔ san bilooru ma, min o min tun bɛ se ka baara dɔ kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ, ");
INSERT INTO dyu_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","minw jatera, o bɛɛ ni o ta gbaw, o bɛɛ ni o ta somɔgɔw, olugu kɛra cɛ waga fla, ani cɛ kɛmɛ wɔɔrɔ ni cɛ bisaba (2 630). ");
INSERT INTO dyu_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Gɛrisɔnka minw jatera, olugu da le kɛra o ye, minw bɛɛ tun bɛ baara dɔ kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ. Musa ni Haruna ka o jate ka kaɲa ni Matigi Ala ta kuma ye. ");
INSERT INTO dyu_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merari ta mɔgɔ minw jatera, o bɛɛ ni o ta gbaw, o bɛɛ ni o ta somɔgɔw, ");
INSERT INTO dyu_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","k’a damina san bisaba ra, fɔ ka taga se san bilooru ma, min o min tun bɛ se ka baara dɔ kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ, ");
INSERT INTO dyu_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","minw jatera, o bɛɛ ni o ta gbaw, o bɛɛ ni o ta somɔgɔw, olugu kɛra cɛ waga saba ni cɛ kɛmɛ fla (3 200). ");
INSERT INTO dyu_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Merari ta mɔgɔ minw jatera, olugu da le kɛra o ye. Musa ni Haruna ka o jate ka kaɲa ni Matigi Ala ta kuma ye, i n’a fɔ a tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ayiwa, Musa ni Haruna ni Izirayɛli jama ɲamɔgɔw ka Levi ta mɔgɔ minw bɛɛ jate, o bɛɛ ni o ta gbaw, o bɛɛ ni o ta somɔgɔw, ");
INSERT INTO dyu_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","k’a damina san bisaba ra, ka taga se fɔ san bilooru ma, min o min tun bɛ se ka baara dɔ kɛ, ani ka doni ta Ɲɔgɔnkunbɛn fanibon kɔnɔ, ");
INSERT INTO dyu_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","minw bɛɛ jatera, olugu kɛra cɛ waga seegi, ani cɛ kɛmɛ looru ni cɛ biseegi (8 580). ");
INSERT INTO dyu_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","O ka o jate ka kaɲa ni Matigi Ala ta kuma ye, i n’a fɔ a tun k’a fɔ Musa ye cogo min na; o ka bɛɛ kelen kelen ta baara yira a ra, ani a ka kan ka doni min ta. O ka o jate i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«A fɔ Izirayɛlimɔgɔw ye ko bana minw bɛ mɔgɔ fari cɛn, ni o dɔ bɛ mɔgɔ o mɔgɔ ra, walama damajalan, walama ni mɔgɔ dɔ magara su dɔ ra k’a yɛrɛ lanɔgɔ, o ka kan ka o tigi labɔ Izirayɛlimɔgɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ni a kɛra cɛ ye walama muso, aw ye a labɔ; aw ye a labɔ aw sigiyɔrɔ ra, janko o kana na aw sigiyɔrɔ lanɔgɔ, sabu ne siginin bɛ aw cɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Izirayɛlimɔgɔw k’a kɛ ten; o ka o mɔgɔw labɔ o cɛ ra. Matigi Ala tun k’a fɔ Musa ye cogo min na, Izirayɛlimɔgɔw k’a kɛ ten. ");
INSERT INTO dyu_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Matigi Ala kumana Musa fɛ tuun, ko: ");
INSERT INTO dyu_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Kuma Izirayɛlimɔgɔw fɛ, k’a fɔ o ye, ko ni cɛ dɔ, walama muso dɔ k’a mɔgɔɲɔgɔn hakɛ ta, k’a tɔɲɔ fɛn dɔ ra, o tigi ka Matigi Ala le kan bla; a jarakira. ");
INSERT INTO dyu_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","A ka jurumun min kɛ, a ka kan ka lɔ o ra. A k’a mɔgɔɲɔgɔn hakɛ ta k’a tɔɲɔ fɛn min na, a ye o fɛn juru bɛɛ sara; o kɔ, o fɛn sɔngɔ tarannin taranyɔrɔ looru, a ye a taran kelen fara a kan fana; a ka mɔgɔ min hakɛ ta, a ye o di o tigi ma. ");
INSERT INTO dyu_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Nka ni a tigi sara, k’a sɔrɔ a ta mɔgɔ si tɛ yi o fɛn bɛ se ka di min ma, o tuma, o fɛn bɛ kɛ Matigi Ala ta ye. A ka kan ka taga a di sarakalasebaga ma; sagajigi min bɛ kɛ jurumunyafa saraka* ye, k’a ta jurumun kafari, a bɛ o fana fara a kan. ");
INSERT INTO dyu_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","«Ni Izirayɛlimɔgɔw ka fɛn o fɛn bla danna Matigi Ala ye, k’a di sarakalasebaga ma, o bɛ kɛ sarakalasebaga ta ye. ");
INSERT INTO dyu_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ni mɔgɔ ka fɛn o fɛn kɛ saraka ye, o bɛ kɛ sarakalasebaga ta ye; ni mɔgɔ ka fɛn o fɛn di sarakalasebaga ma, o fana bɛ kɛ a ta ye.» ");
INSERT INTO dyu_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Matigi Ala kumana Musa fɛ tuun, ko: ");
INSERT INTO dyu_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Kuma Izirayɛlimɔgɔw fɛ k’a fɔ o ye ko ni cɛ dɔ muso bɔra a fɛ ka kɛ cɛ wɛrɛ fɛ, ");
INSERT INTO dyu_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ni a tagara jɛn ni cɛ wɛrɛ ye, k’a yɛrɛ lanɔgɔ, k’a sɔrɔ a cɛ ma bɔ o ko kala ma, ni o ko dogonin tora, sabu mɔgɔ si ma kɛ a seere ye, mɔgɔ si fana ma o mina a ra, ");
INSERT INTO dyu_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ni celiya nana don cɛ jusu ra, sabu a sigiyara a muso ra, k’a sɔrɔ ko can lo fana ko muso k’a yɛrɛ lanɔgɔ, walama ni celiya ni sigiya donna a jusu ra k’a sɔrɔ muso m’a yɛrɛ lanɔgɔ, ");
INSERT INTO dyu_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","o tuma a ka kan ka taga ni muso ye sarakalasebaga fɛ. A ye mugu kilo saba ta, ka taga o kɛ saraka ye muso kosɔn. A man kan ka turu kɛ o mugu ra, walama wusunan; sabu siman saraka* lo min bɔra celiya kosɔn; hakirijigi saraka lo, min bɛ mɔgɔ hakiri jigi kojugu ra. ");
INSERT INTO dyu_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«Sarakalasebaga bɛna muso lana, ka na a lɔ Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","O kɔ, a bɛ ji saninman dɔ kɛ bɔgɔdaga dɔ kɔnɔ, ka buguri dɔ cɛ dugu ma fanibon saninman kɔnɔ ka o kɛ o ji ra. ");
INSERT INTO dyu_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ni sarakalasebaga ka muso lɔ Matigi Ala ɲa kɔrɔ, a bɛ muso kunsigi foni, ka hakirijigi saraka* don a boro, o siman saraka min bɔra celiya kosɔn; o y’a sɔrɔ ji kunaman min bɛ danga ben mɔgɔ kan, o ji bɛ sarakalasebaga yɛrɛ boro. ");
INSERT INTO dyu_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Sarakalasebaga ye muso jagboya ko a ye kari; a y’a fɔ a ye ko: ‹Ka i to i cɛ ta furu kɔnɔ, ni a kɛra ko cɛ wɛrɛ ma jɛn ni i ye, ni i ma bɔ ka taga i yɛrɛ lanɔgɔ, o tuma nin ji kunaman min bɛ danga ben mɔgɔ kan, nin ji kana foyi kɛ i ra. ");
INSERT INTO dyu_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Nka ka i to i cɛ ta furu kɔnɔ, ni a kɛra ko i bɔra ka taga i yɛrɛ lanɔgɔ, ka taga jɛn ni cɛ wɛrɛ ye, min tɛ i furucɛ ye,› ");
INSERT INTO dyu_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","sarakalasebaga ye muso jagboya ka kari, ka nin danga kumaw fɔ muso ma, k’a fɔ ko: ‹O tuma, Matigi Ala ye i denworonogow cɛn i kɔnɔ, ka i kɔnɔ funu, k’a to i ta mɔgɔw ye i danga, ka i yira, ko i kɛwale man ɲi. ");
INSERT INTO dyu_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","O ra, nin ji min bɛ danga ben mɔgɔ kan, nin ji ye don i kɔnɔ, ka i kɔnɔ funu, ka i denworonogow cɛn i kɔnɔ.› Muso b’a jaabi ko: ‹Amina! Amina!› ");
INSERT INTO dyu_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«Sarakalasebaga ye o danga kumaw sɛbɛ gbolokitabu dɔ kan; o kɔ, a ye o sɛbɛriw ko ka bɔ yi ni o ji kunaman ye, ");
INSERT INTO dyu_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ka o ji kunaman di muso ma ko a y’a min, o ji min bɛ danga ben mɔgɔ kan; o ji kunaman bɛna don a kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Nka sani a y’a min, siman saraka min bɔra celiya kosɔn, sarakalasebaga ye o mina muso boro, k’a fifa Matigi Ala ɲa kɔrɔ, ka taga a bla sarakajɛnifɛn* kan. ");
INSERT INTO dyu_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","A bɛ boro ɲa kelen bɔ o siman saraka* ra, k’a yira ko o saraka bɛɛ kɛra Matigi Ala ta ye; a bɛ o boro ɲa kelen saraka jɛni sarakajɛnifɛn kan. O kɔ, a bɛ ji di muso ma ko a y’a min. ");
INSERT INTO dyu_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ayiwa, ni a kɛra ko can lo ko muso tun bɔra a cɛ fɛ ka taga a yɛrɛ lanɔgɔ, ni a ka ji min, o ji min bɛ danga ben mɔgɔ kan, o ji bɛna don a kɔnɔ ka tɔɔrɔjugu dɔ lase a ma. Muso denworonogow bɛna cɛn a kɔnɔ, k’a kɔnɔ funu; o muso bɛ kɛ mɔgɔ danganin ye a ta mɔgɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Nka ni a kɛra ko muso m’a yɛrɛ lanɔgɔ, ni a saninyanin lo, o tuma jaraki ko si tɛna a sɔrɔ, a bɛna se ka den woro tuun. ");
INSERT INTO dyu_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«Ayiwa, celiya ko ta sariya le bɛ nin ye, ni muso dɔ bɔra ka taga a yɛrɛ lanɔgɔ, k’a to a cɛ ta furu kɔnɔ, ");
INSERT INTO dyu_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","walama ni cɛ dɔ sigiyara a muso ra, fɔ k’a kɛ a ra celiya ye a muso ta fan fɛ. Sarakalasebaga ka kan ka o muso lɔ Matigi Ala ɲa kɔrɔ, ka nin sariya kow bɛɛ kɛ muso ra. ");
INSERT INTO dyu_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Cɛ kɔni tɛna jaraki, nka muso ta jurumun hakɛ bɛna ben a yɛrɛ le kan.» ");
INSERT INTO dyu_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Kuma Izirayɛlimɔgɔw fɛ, k’a fɔ o ye ko ni cɛ dɔ, walama ni muso dɔ k’a yɛrɛ bɔ Izirayɛlimɔgɔ tɔw ra, ka dajuru ta, ko a b’a yɛrɛ bla danna Matigi Ala ye, k’a yɛrɛ kɛ Ala ta mɔgɔ saninman ye, ");
INSERT INTO dyu_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","o tigi ka kan ka duvɛn ni minnifɛn fariman suguya bɛɛ ye k’a to yi. A man kan ka duvɛn, walama minnifɛn fariman wɛrɛ min. Minnifɛn o minnifɛn bɛ bɔ rɛzɛn na, a man kan ka o min. A man kan ka hali rɛzɛn kɛnɛ, walama a janin domu. ");
INSERT INTO dyu_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","A ta dajuru wagati bɛɛ ra, fɛn o fɛn bɛ bɔ rɛzɛnsun na, a man kan ka o domu, hali rɛzɛnkisɛ, walama a fara. ");
INSERT INTO dyu_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","A ta dajuru wagati bɛɛ kɔnɔ, kunlimuru man kan ka se a kun ma, fɔ ka taga o wagati dafa. A k’a yɛrɛ bla danna Matigi Ala ye ka wagati min kɛ, a saninyanin ka kan ka to fɔ ka taga o wagati dafa. A ka kan k’a kunsigi to a ye wuri ka janya. ");
INSERT INTO dyu_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","A k’a yɛrɛ bla danna Matigi Ala ye wagati min bɛɛ kɔnɔ, a man kan ka gbara su ra. ");
INSERT INTO dyu_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Hali ni a worofa, walama ni a woroba le sara, walama a balemacɛ, walama a balemamuso, a man kan ka gbara o dɔ su ra k’a yɛrɛ lanɔgɔ, sabu a blara danna Matigi Ala ye minkɛ, o tagamasiyɛn bɛ a kun na. ");
INSERT INTO dyu_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","A ta dajuru wagati bɛɛ kɔnɔ, a saninyanin lo, ka kɛ Ala ta ye. ");
INSERT INTO dyu_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«Ni mɔgɔ dɔ barara ka sa a kɔrɔ, a kunsigi min b’a yira ko a blara danna Ala ye, o tuma o kunsigi lanɔgɔra. Nka a tere wolonflanan, a bɛ saninya kokura; o lon na, a bɛ a kun li. ");
INSERT INTO dyu_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A tere seeginan, a ye taga ni tugani fla, walama jɛnɛtugani fitini fla ye sarakalasebaga fɛ Ɲɔgɔnkunbɛn fanibon* donda ra. ");
INSERT INTO dyu_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Sarakalasebaga bɛ kelen kɛ jurumunyafa saraka* ye, ka tɔ kelen kɛ saraka jɛnita* ye. Sarakalasebaga bɛ a ta jurumun kafari a ye, sabu a gbarara su ra. O lon na, a kunsigi bɛ saninya tuun. ");
INSERT INTO dyu_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","A ka kan k’a yɛrɛ bla danna Ala ye tuun, k’a ta dajuru wagati damina kura ye. A bɛ sagaden cɛman kelen mina, min ka san kelen sɔrɔ, ka o kɛ hakɛ yafa saraka* ye. Nka a tun ka wagati minw kɛ ka ban, o tɛ jate tuun, sabu a ta dajuru tun cɛnna. ");
INSERT INTO dyu_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«Ayiwa, ni mɔgɔ ka dajuru ta ka kɛ Ala ta mɔgɔ saninman ye wagati min kama, ni o wagati dafara, o sariya ye nin ye: o bɛ na ni o tigi ye Ɲɔgɔnkunbɛn fanibon* donda ra. ");
INSERT INTO dyu_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","A bɛ na ni a ta sarakaw ye Matigi Ala fɛ: sagaden cɛman min ka san kelen sɔrɔ, ani fiyɛn tɛ min na, o bɛ kɛ saraka jɛnita ye; ani sagamuso min ka san kelen sɔrɔ, ani fiyɛn tɛ min na, o bɛ kɛ jurumunyafa saraka* ye; sagajigi kelen, fiyɛn tɛ min na, o bɛ kɛ ninsɔndiya saraka* ye. ");
INSERT INTO dyu_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","A bɛ burufunubari segi ɲa kelen di, buru min kɛra ni mugu tɛntɛnnin nɔɔninin ye turu ra, ani ŋɔmi, funufɛn tɛ min na; a bɛ siman sarakaw* ni rɛzɛnji sarakaw* fana fara o kan. ");
INSERT INTO dyu_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Sarakalasebaga bɛ o fɛnw bla Matigi Ala ɲa kɔrɔ, ka jurumunyafa saraka bɔ, ka saraka jɛnita fana bɔ. ");
INSERT INTO dyu_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Burufunubari minw bɛ segi kɔnɔ, a bɛ o bla Matigi Ala ɲa kɔrɔ; o kɔ, a bɛ sagajigi kɛ jɛnɲɔgɔnya saraka* ye k’a di Matigi Ala ma, ka siman saraka ni rɛzɛnji saraka fara o kan. ");
INSERT INTO dyu_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","«O kɔ, Ala ta mɔgɔ saninman tun k’a kunsigi min kɛ a ta saninyari tagamasiyɛn ye, a bɛ o li Ɲɔgɔnkunbɛn fanibon* donda ra. Ninsɔndiya saraka* blara tasuma min kan, a bɛ taga a kunsigi don o tasuma ra. ");
INSERT INTO dyu_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ni Ala ta mɔgɔ saninman ka o kunsigi li ka ban tuma min na, sarakalasebaga bɛ sagajigi sogo tobinin kaman kelen ta, ka o don a boro, ka burukun kelen ni ŋɔmikun kelen bɔ segi kɔnɔ, ka o fana di a ma. ");
INSERT INTO dyu_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","O kɔ, sarakalasebaga bɛ o fɛnw kɔrɔta san fɛ, ka o fifa Matigi Ala ɲa kɔrɔ. O ye fɛn saninmanw le ye, o ye sarakalasebaga ta ye, ani saga disi min fana fifara Matigi Ala ɲa kɔrɔ, ani a woto min kɔrɔtara. Ni o kɛra, o tuma Ala ta mɔgɔ saninman bɛ se ka rɛzɛnji min. ");
INSERT INTO dyu_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«Ayiwa, mɔgɔ min bɛ dajuru ta k’a yɛrɛ kɛ Ala ta mɔgɔ saninman ye, o sariya le bɛ nin ye. A ka kan ka saraka min bɔ Matigi Ala ye a ta dajuru kosɔn, o le fana bɛ nin ye; ni fɛn wɛrɛ se ka kɛ a ye, a bɛ se ka o fana fara nin sarakaw kan. A ka dajuru min ta, a ka kan ka o kow bɛɛ dafa, ka kaɲa ni o dajuru sariya ye.» ");
INSERT INTO dyu_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Matigi Ala k’a fɔ Musa ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«A fɔ Haruna ni a dencɛw ye, ko o ka kan ka dugawu kɛ Izirayɛlimɔgɔw ye cogo min na, o ye nin ye. O y’a fɔ ko: ");
INSERT INTO dyu_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‹Matigi Ala ye baraka don aw ra, ka aw tanga! ");
INSERT INTO dyu_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Matigi Ala ye aw flɛ ni ɲumanya ye, ka hina aw ra! ");
INSERT INTO dyu_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Matigi Ala y’a janto aw ra, ka hɛra kɛ aw ye.› ");
INSERT INTO dyu_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","«O ye dugawu kɛ Izirayɛlimɔgɔw ye ni ne tɔgɔ ye; ni o kɛra, ne bɛna baraka don Izirayɛlimɔgɔw ra.» ");
INSERT INTO dyu_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Musa tun ka fanibon saninman* lɔ ka ban wagati min na, a ka turu saninman* seriseri a kan k’a saninya, ani a kɔnɔminanw bɛɛ. A ka turu saninman* kɛ sarakajɛnifɛn* fana kan k’a saninya, a ni a minanw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","O wagati ra, Izirayɛli jama ɲamɔgɔ minw ye gbatigiw ani jama cɛkɔrɔbaw ye, olugu nana ni o ta sarakaw ye; Izirayɛlimɔgɔw jateri baara tun donna olugu le boro. ");
INSERT INTO dyu_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","O nana ni o ta sarakaw ye Matigi Ala ɲa kɔrɔ: misi wotoro wɔɔrɔ, minw sanfɛyɔrɔ datugunin lo, ani a misitoran tan ni fla. Kuntigi fla jɛnna ka wotoro kelen di; kuntigi bɛɛ kelen kelen ka misitoran kelen di. O nana ni o fɛnw ye fanibon saninman ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Nin bonyaw mina o boro, ka o bla Ɲɔgɔnkunbɛn fanibon* ta baara kama. I bɛna a di Levi ta mɔgɔw ma, ka kaɲa ni o ta baaraw ye.» ");
INSERT INTO dyu_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Musa ka wotorow ni misitoranw mina, ka o di Levi ta mɔgɔw ma. ");
INSERT INTO dyu_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","A ka wotoro fla ni misitoran naani di Gɛrisɔnkaw ma, ka kaɲa ni o ta baaraw ye, ");
INSERT INTO dyu_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ka wotoro naani ni misitoran seegi di Merari ta mɔgɔw ma, ka kaɲa ni o ta baaraw ye; olugu tun bɛ o ta baara kɛ ka kaɲa ni sarakalasebaga Haruna dencɛ Itamari ta cifɔninw le ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Nka a ma dɔ di Kehatikaw ma, sabu minan saninmanw tari baara karifara olugu le ma; o tun ka kan ka o fɛnw ta o kamankunw le kan. ");
INSERT INTO dyu_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Lon min na Musa ka turu saninman* kɛ sarakajɛnifɛn* kan, o lon na Izirayɛli kuntigiw nana ni o ta sarakaw ye, janko ka sarakajɛnifɛn saninya k’a bla danna Ala ye. O nana ni o sarakaw ye sarakajɛnifɛn ɲa fɛ; ");
INSERT INTO dyu_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Matigi Ala k’a fɔ Musa ye ko: «Lon o lon, kuntigi kelen ye na ka na a ta saraka di, janko ka sarakajɛnifɛn saninya k’a bla danna Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ayiwa, kuntigi min nana ni a ta saraka ye a tere fɔlɔ ra, o kɛra Aminadabu dencɛ Nasɔn ye, Zuda ta gba ra. ");
INSERT INTO dyu_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman* ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita* ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka* ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka* ye. Nin le kɛra Aminadabu dencɛ Nasɔn ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","A tere flanan, Isakari ta mɔgɔw ta kuntigi min ye Suwari dencɛ Netanehɛli ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Suwari dencɛ Netanehɛli ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","A tere sabanan, Zabulɔn ta mɔgɔw ta kuntigi min ye Helɔn dencɛ Eliyabu ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka* ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Helɔn dencɛ Eliyabu ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","A tere naaninan, Rubɛn ta mɔgɔw ta kuntigi min ye Sedehuri dencɛ Elisuri ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Sedehuri dencɛ Elisuri ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","A tere loorunan, Simeyɔn ta mɔgɔw ta kuntigi min ye Surisadayi dencɛ Selumiyɛli ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Surisadayi dencɛ Selumiyɛli ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","A tere wɔɔrɔnan, Gadi ta mɔgɔw ta kuntigi min ye Dewɛli dencɛ Eliyasafu ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Dewɛli dencɛ Eliyasafu ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","A tere wolonflanan, Efirayimu ta mɔgɔw ta kuntigi min ye Amihudi dencɛ Elisama ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fara wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Amihudi dencɛ Elisama ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","A tere seeginan, Manase ta mɔgɔw ta kuntigi min ye Pedasuri dencɛ Gamiliyɛli ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Pedasuri dencɛ Gamiliyɛli ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","A tere kɔnɔntɔnnan, Boniyaminu ta mɔgɔw ta kuntigi min ye Gidehoni dencɛ Abidan ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fara wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Gidehoni dencɛ Abidan ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","A tere tannan, Dan ta mɔgɔw ta kuntigi min ye Amisadayi dencɛ Ahezɛri ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Amisadayi dencɛ Ahezɛri ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","A tere tan ni kelennan, Asɛri ta mɔgɔw ta kuntigi min ye Okiran dencɛ Pagiyɛli ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Okiran dencɛ Pagiyɛli ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","A tere tan ni flanan, Nɛfitali ta mɔgɔw ta kuntigi min ye Enan dencɛ Ahira ye, ale nana ni a ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","A nana ni tasa warigbɛraman kelen ye, min gbiriya bɛ kilo kelen ni garamu kɛmɛ saba bɔ, ani daga warigbɛraman kelen, min gbiriya bɛ garamu kɛmɛ wolonfla bɔ, ka kaɲa ni yɔrɔ saninman ta jate ye. O minan fla bɛɛ tun fara ni mugu tɛntɛnnin nɔɔninin ye turu ra, ka o kɛ siman saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","A nana ni bɛlɛn saninlaman kelen ye, min gbiriya bɛ garamu kɛmɛ bɔ, o fanin wusunan na, ");
INSERT INTO dyu_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ani misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman kelen, min si ka san kelen bɔ, ka olugu kɛ saraka jɛnita ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","A nana ni bakɔrɔnin kelen ye, ka o kɛ jurumunyafa saraka ye; ");
INSERT INTO dyu_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","a nana ni misi fla ye, ani sagajigi looru, ani bakɔrɔnin looru, ani sagaden cɛman looru, minw si ka san kelen bɔ, ka olugu kɛ ninsɔndiya saraka ye. Nin le kɛra Enan dencɛ Ahira ta saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Musa ka turu saninman* kɛ sarakajɛnifɛn kan lon min na, Izirayɛli kuntigiw ka fɛn minw di saraka ye janko ka sarakajɛnifɛn saninya k’a bla danna Ala ye, o fɛnw le ye nin ye. O ka tasa warigbɛraman tan ni fla le di, ani daga warigbɛraman tan ni fla, ani bɛlɛn saninlaman tan ni fla. ");
INSERT INTO dyu_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Tasa warigbɛraman bɛɛ kelen kelen tun ye kilo kelen ni garamu kɛmɛ saba ye; daga warigbɛraman bɛɛ kelen kelen tun ye garamu kɛmɛ wolonfla ye. O minanw bɛɛ lajɛnnin ta warigbɛ kɛra kilo mugan ni naani, ka kaɲa ni yɔrɔ saninman ta jate ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Bɛlɛn saninlaman tan ni fla minw fara wusunan na, o bɛɛ kelen kelen tun ye garamu kɛmɛ kɛmɛ, ka kaɲa ni yɔrɔ saninman ta jate ye. O bɛlɛnw ta sanin bɛɛ lajɛnnin kɛra kilo kelen ni garamu kɛmɛ fla. ");
INSERT INTO dyu_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Bɛgan minw dira ka kɛ saraka jɛnita ye, o bɛɛ lajɛnnin kɛra misitoran tan ni fla, ani sagajigi tan ni fla, ani sagaden cɛman tan ni fla, minw si ka san kelen sɔrɔ; o ka o siman sarakaw fana fara o kan. Bakɔrɔnin tan ni fla kɛra jurumunyafa saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Bɛgan minw dira k’a kɛ ninsɔndiya saraka ye, o bɛɛ lajɛnnin kɛra misi mugan ni naani, ani sagajigi biwɔɔrɔ, ani bakɔrɔnin biwɔɔrɔ, ani sagaden cɛman biwɔɔrɔ, minw si ka san kelen sɔrɔ. Turu kɛra sarakajɛnifɛn kan ka ban minkɛ, fɛn minw dira saraka ye janko k’a saninya k’a bla danna Ala ye, o le ye nin ye. ");
INSERT INTO dyu_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ni Musa tun ka don Ɲɔgɔnkunbɛn fanibon kɔnɔ, ka taga kuma ni Matigi Ala ye, a tun bɛ Matigi Ala kumakan mɛn ka bɔ jɛnɲɔgɔnya kɛsu* datugunan kan, serubɛn mɛlɛkɛ bisigi fla cɛmancɛ ra. A tun bɛ kuma ni a ye o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«A fɔ Haruna ye, ko ni a bɛ fitinadagaw bla fitinablanan kan, a y’a to fitinadaga wolonfla bɛɛ yeelen ye bɔ ka taga fitinablanan ɲafɛyɔrɔ ra.» ");
INSERT INTO dyu_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Haruna k’a kɛ ten. A ka fitinadagaw bla, ka o ɲasin fitinablanan ɲafɛyɔrɔ ma, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Fitinablanan yɔrɔ bɛɛ tun lalagara ni sanin gbasinin le ye, k’a ta a sen na ka taga a bla fɔ a yirifiyeren bisigiw ra. Matigi Ala tun k’a bisigiya min yira Musa ra, o tun k’a lalaga ka kaɲa ni o le ye. ");
INSERT INTO dyu_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Matigi Ala kumana Musa fɛ tuun, ko: ");
INSERT INTO dyu_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Levi ta mɔgɔw bɔ Izirayɛlimɔgɔ tɔw ra, ka o saninya. ");
INSERT INTO dyu_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","I bɛna o saninya cogo min na, o ye nin ye: i bɛ jurumun kafari ji seriseri o kan; o kɔ, o bɛ o fari siw bɛɛ li, ka o ta faniw ko, ka o yɛrɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","O ye na ni misitoran kaɲaman kelen ye, ani siman saraka* min ka kan ka fara o kan, min ye mugu tɛntɛnnin nɔɔninin ye turu ra. Ele yɛrɛ fana ye na ni misitoran kaɲaman kelen wɛrɛ ye, min bɛna kɛ jurumunyafa saraka* ye. ");
INSERT INTO dyu_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","I bɛ taga ni Levi ta mɔgɔw ye Ɲɔgɔnkunbɛn fanibon* ɲa fɛ, ka Izirayɛli jama bɛɛ wele. ");
INSERT INTO dyu_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","I bɛ taga ni Levi ta mɔgɔw ye Matigi Ala ɲa kɔrɔ; Izirayɛlimɔgɔw bɛ o borow la o kan. ");
INSERT INTO dyu_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","O kɔ, Haruna bɛ Levi ta mɔgɔw lɔlɔ Matigi Ala ɲa kɔrɔ, ka o di Matigi Ala ma, i n’a fɔ Izirayɛlimɔgɔw bɛ saraka min fifa, k’a di Ala ma. O cogo ra, Levi ta mɔgɔw bɛ bla Matigi Ala ta baara kama. ");
INSERT INTO dyu_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","O kɔ, Levi ta mɔgɔw bɛ o borow la misitoranw kunw na. I bɛ o misitoran kelen kɛ jurumunyafa saraka* ye, ka kelen kɛ saraka jɛnita* ye, janko ka Levi ta mɔgɔw ta jurumunw kafari. ");
INSERT INTO dyu_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","I bɛ Levi ta mɔgɔw lɔlɔ Haruna ni a dencɛw ɲa fɛ; o kɔ, i bɛ o bla Ala ta baara kama, i n’a fɔ saraka fifata. ");
INSERT INTO dyu_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","O cogo ra, i bɛ Levi ta mɔgɔw faran ka bɔ Izirayɛlimɔgɔ tɔw ra. Levi ta mɔgɔw bɛna kɛ ne ta ye. ");
INSERT INTO dyu_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","O kɔ, Levi ta mɔgɔw bɛna baara kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ. I bɛna o saninya tan le, k’a kɛ i ko saraka min bɛ fifa k’a di Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Sabu olugu le dira ne ma Izirayɛlimɔgɔ tɔw nɔ ra. Ne ka olugu le ɲanawoloma Izirayɛlimɔgɔw dencɛ fɔlɔw bɛɛ nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Sabu Izirayɛlimɔgɔw dencɛ fɔlɔw bɛɛ ye ne ta le ye; mɔgɔw den fɔlɔw, ani bɛganw den fɔlɔw bɛɛ. Lon min ne ka dencɛ fɔlɔw bɛɛ faga Misiran jamana ra, ne ka Izirayɛlimɔgɔw dencɛ fɔlɔw bɛɛ kɛ ne yɛrɛ ta ye o lon na. ");
INSERT INTO dyu_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ne ka Levi ta mɔgɔw ta Izirayɛlimɔgɔw dencɛ fɔlɔw bɛɛ nɔ ra. ");
INSERT INTO dyu_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ne ka Levi ta mɔgɔw di Haruna ni a dencɛw ma Izirayɛlimɔgɔw nɔ ra, janko o ye baara kɛ Ɲɔgɔnkunbɛn fanibon kɔnɔ Izirayɛlimɔgɔw ye, ka Izirayɛlimɔgɔw ta jurumun kafari o ye; ni o kɛra, ni Izirayɛlimɔgɔw ka gbara ne ta yɔrɔ saninman* na, kojugu si tɛna o sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ayiwa, Matigi Ala tun ka fɛn o fɛn fɔ Musa ye Levi ta mɔgɔw ta ko ra, Musa ni Haruna ni Izirayɛli jama ka o bɛɛ kɛ Levi ta mɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levi ta mɔgɔw ka o yɛrɛ saninya, ka o ta faniw ko. O kɔ, Haruna ka o kɛ i ko saraka min bɛ fifa k’a di Matigi Ala ma, ka o ta jurumunw kafari o ye, ka o saninya. ");
INSERT INTO dyu_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","O kɔ, Levi ta mɔgɔw nana o ta baaraw damina Ɲɔgɔnkunbɛn fanibon kɔnɔ; Haruna ni a dencɛw le tun bɛ o ta baaraw yira o ra. O cogo ra, Matigi Ala tun ka fɛn o fɛn fɔ Musa ye Levi ta mɔgɔw ko ra, o ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Matigi Ala kumana Musa fɛ tuun, ko: ");
INSERT INTO dyu_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Levi ta mɔgɔw ta baara flɛ nin ye: Levi ta cɛdenw bɛɛ ka kan ka don Ɲɔgɔnkunbɛn fanibon ta baara ra, ka baara dɔ kɛ, k’a damina a san mugan ni looru, ani minw tɛmɛna o kan. ");
INSERT INTO dyu_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Nka ni o si sera san bilooru ma, o ka kan ka o boro bɔ baara ra; o tɛ baara kɛ tuun. ");
INSERT INTO dyu_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","O bɛ se ka o balema tɔw dɛmɛ o ta baaraw ra Ɲɔgɔnkunbɛn fanibon kɔnɔ, nka baara man kan ka kɛ olugu yɛrɛ tɔgɔra ta ye tuun. I ka kan ka Levi ta mɔgɔw ta baaraw di o ma nin cogo le ra.» ");
INSERT INTO dyu_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Izirayɛlimɔgɔw bɔnin kɔ Misiran, o san flanan karo fɔlɔ ra, Matigi Ala kumana Musa fɛ, Sinayi kongokolon kɔnɔ; a ko: ");
INSERT INTO dyu_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Izirayɛlimɔgɔw ka kan ka Jɔnyaban ɲanagbɛ kɛ a kɛwagati ra. ");
INSERT INTO dyu_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Wagati min latigɛra, min ye nin karo tere tan ni naani ye, ni o sera aw ye ɲanagbɛ kɛ terebenda fɛ. Aw y’a kɛ ka kaɲa ni ne ta cifɔninw, ani ne ta kolatigɛninw bɛɛ ye.» ");
INSERT INTO dyu_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ayiwa, Musa k’a fɔ Izirayɛlimɔgɔw ye ko o ye Jɔnyaban ɲanagbɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","O ka Jɔnyaban ɲanagbɛ kɛ san karo fɔlɔ tere tan ni naani terebenda fɛ, Sinayi kongokolon kɔnɔ. Matigi Ala tun ka kuma minw bɛɛ fɔ Musa ye, Izirayɛlimɔgɔw k’a kɛ ka kaɲa ni o bɛɛ ye. ");
INSERT INTO dyu_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Nka mɔgɔ dɔw ma se ka Jɔnyaban ɲanagbɛ kɛ o lon na, sabu olugu tun magara mɔgɔ dɔ su ra, ka o yɛrɛ lanɔgɔ. O lon yɛrɛ ra, o mɔgɔw tagara Musa ni Haruna fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","O tagara a fɔ Musa ye ko: «Anw saninyanin tɛ, sabu an magara su dɔ ra. Nka mun le bɛ an bari ka an ta saraka di Matigi Ala ma ni Izirayɛlimɔgɔ tɔw ye, Jɔnyaban ɲanagbɛ wagati ra?» ");
INSERT INTO dyu_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa ka o jaabi ko: «Aw ye ne makɔnɔ, sani ne ye kuma dɔ sɔrɔ ka bɔ Matigi Ala fɛ aw ta ko ra.» ");
INSERT INTO dyu_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Kuma Izirayɛlimɔgɔw fɛ, k’a fɔ o ye ko: ‹Aw ra, walama aw ta duruja nataw ra, ni a kɛra ko mɔgɔ dɔ ma saninya sabu a magara su dɔ ra, walama ni mɔgɔ dɔ tagara tagamajan dɔ ra, o bɛɛ n’a ta, a tigi bɛ se ka Jɔnyaban ɲanagbɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Olugu bɛna a kɛ san karo flanan tere tan ni naani le ra, terebenda fɛ. O bɛ sagaden sogo domu ni burufunubari ye, ani ɲuguflaburu kunaman. ");
INSERT INTO dyu_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","O man kan k’a to a tɔ ye si, o fana man kan k’a kolo dɔ kari. O ka kan k’a kɛ ka kaɲa ni Jɔnyaban ɲanagbɛ ta cifɔninw bɛɛ ye. ");
INSERT INTO dyu_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Nka ni mɔgɔ min saninyanin lo, ni a fana ma taga tagama ra, o bɛɛ n’a ta, ni a ma Jɔnyaban ɲanagbɛ kɛ a wagati yɛrɛ ra, o tigi ka kan ka faran ka bɔ Izirayɛli jamanadenw na; sabu a ma a ta saraka bɔ Matigi Ala ye a wagati ra. A ta jurumun hakɛ bɛna ben a yɛrɛ kan. ");
INSERT INTO dyu_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","« ‹Lonan minw siginin bɛ aw cɛ ra, ni o dɔ b’a fɛ ka Jɔnyaban ɲanagbɛ kɛ, ka Matigi Ala bonya, a ka kan k’a kɛ ka kaɲa ni Jɔnyaban ɲanagbɛ ta sariyaw ni a cifɔninw ye. Izirayɛlimɔgɔ fara lonan kan, o sariya kelen le bɛna kɛ aw bɛɛ kan.› » ");
INSERT INTO dyu_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Lon min na fanibon saninman* lɔra, sankaba jamijan nana fanibon saninman datugu, min ye Ɲɔgɔnkunbɛn fanibon* ye. K’a ta wulada fɛ, fɔ o dugusagbɛ sɔgɔmada fɛ, a tora fanibon kunna; a tun bɛ i ko tasuma. ");
INSERT INTO dyu_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","K’a ta o wagati ra, a kɛra o cogo le ra wagati bɛɛ. Sankaba tun bɛ fanibon datugu; ni su tun kora a bɛ kɛ i ko tasuma. ");
INSERT INTO dyu_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ni sankaba jamijan tun ka wuri ka bɔ fanibon kunna, Izirayɛlimɔgɔw tun bɛ wuri ka taga. Ni sankaba jamijan tun tagara lɔ yɔrɔ min na, o tun bɛ sigi o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Izirayɛlimɔgɔw tun bɛ taga ka kaɲa ni Matigi Ala ta kuma le ye, o fana tun bɛ lɔ ka kaɲa ni Matigi Ala ta kuma le ye. Ni sankaba jamijan tun tora fanibon saninman kunna ka wagati min kɛ, Izirayɛlimɔgɔw tun bɛ to o sigiyɔrɔ ra o wagati bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ni sankaba jamijan tun tora fanibon saninman kunna ka wagatijan kɛ, Izirayɛlimɔgɔw tun bɛ Matigi Ala kan mina, o tun tɛ taga. ");
INSERT INTO dyu_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Tuma dɔ, sankaba jamijan tun bɛ to fanibon saninman kunna ka tere dama dɔrɔn le kɛ; o tun bɛ sigi ka kaɲa ni Matigi Ala ta kuma le ye, o fana tun bɛ taga ka kaɲa ni Matigi Ala ta kuma le ye. ");
INSERT INTO dyu_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Tuma dɔ, sankaba jamijan tun bɛ to fanibon saninman kunna k’a ta wulada fɛ, ka se o dugusagbɛ sɔgɔmada dɔrɔn ma; ni a tun wurira sɔgɔma, Izirayɛlimɔgɔw tun bɛ wuri ka taga. Ni sankaba jamijan tun wurira tuma o tuma, ni a kɛra tere fɛ, walama su fɛ, Izirayɛlimɔgɔw tun bɛ wuri ka taga. ");
INSERT INTO dyu_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ni sankaba jamijan tun tora fanibon saninman kunna ka tere fla le kɛ, walama karo kelen, walama san kelen, Izirayɛlimɔgɔw tun bɛ to o sigiyɔrɔ ra, o tun tɛ taga. Nka ni a tun wurira tuma o tuma, o tun bɛ wuri ka taga. ");
INSERT INTO dyu_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","O tun bɛ lɔ ka kaɲa ni Matigi Ala ta kuma le ye, o fana tun bɛ taga ka kaɲa ni Matigi Ala ta kuma le ye. O tun bɛ Matigi Ala ta kumaw le lamɛn, ka kaɲa ni a ta cifɔnin ye, a ka min fɔ Musa ye. ");
INSERT INTO dyu_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Burufiyɛta warigbɛraman fla lalaga, ni warigbɛ gbasinin ye. I bɛna o le kɛ ka jama lajɛn, ani ka jama lasɔmi o tagatuma ra. ");
INSERT INTO dyu_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ni o buru fla bɛɛ fiyɛra, jama bɛɛ ka kan ka na lajɛn i kɔrɔ, Ɲɔgɔnkunbɛn fanibon* ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ni buru kelen dɔrɔn fiyɛra, Izirayɛli ɲamɔgɔ minw ye kɛrɛkɛjama kuntigiw ye olugu le bɛna lajɛn i kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ni aw ka buru fiyɛ k’a kan bonya tuma min na, terebɔyanfan mɔgɔw bɛ wuri ka taga. ");
INSERT INTO dyu_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ni aw k’a fiyɛ k’a kan bonya tuun a siɲaga flanan na, woroduguyanfan mɔgɔw bɛ wuri ka taga. Ni buru fiyɛra k’a kan bonya tuma o tuma, o bɛ aw tagawagatiw le yira. ");
INSERT INTO dyu_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","«Ni aw bɛ jama lajɛn, aw bɛ buru fiyɛ, nka aw man kan k’a fiyɛ k’a kan bonya. ");
INSERT INTO dyu_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Haruna dencɛw, minw ye sarakalasebagaw ye, olugu le ka kan ka o buruw fiyɛ. O bɛna kɛ sariya wuribari le ye aw ni aw ta durujaw fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«Ni aw nana se aw yɛrɛ ta jamana ra, ni aw juguw wurira aw kama, ni aw tagara o kɛrɛ, aw ye buru fiyɛ k’a kan bonya; ni o kɛra, o bɛ kɛ sababu ye k’a to Matigi Ala, aw ta Ala b’a hakiri to aw ra, ka aw bɔsi aw juguw boro. ");
INSERT INTO dyu_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","«Aw ka kan ka nin buruw fiyɛ aw ta ɲagarilonw na fana, min ye aw ta ɲanagbɛlonw ye, ani aw ta karokura ɲanagbɛw. Aw ye buru fiyɛ aw ta saraka jɛnitaw*, ani aw ta ninsɔndiya sarakaw* bɔwagatiw ra; o bɛna kɛ sababu ye k’a to Matigi Ala b’a hakiri to aw ra. Ne le ye Matigi Ala ye, aw ta Ala.» ");
INSERT INTO dyu_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Izirayɛlimɔgɔw bɔnin kɔ Misiran, o san flanan, karo flanan tere mugan, sankaba jamijan wurira ka bɔ Ɲɔgɔnkunbɛn fanibon* kunna, Ala ta jɛnɲɔgɔnya kɛsu* tun bɛ min kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","O kɛra minkɛ, Izirayɛlimɔgɔw wurira ka bɔ Sinayi kongokolon yɔrɔ ra ka taga. Sankaba tagara o ɲa, ka taga lɔ Paran kongokolon kunna. ");
INSERT INTO dyu_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","O le tun kɛra o ta tagama fɔlɔ ye, ka kaɲa ni Matigi Ala ta kuma ye, a tun ka min fɔ Musa ye. ");
INSERT INTO dyu_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Jɛnkuru minw bɛ Zuda ta jamaba ra, olugu le kɔnna ka taga ni o ta darapo ye. O jamaba ra, Aminadabu dencɛ Nasɔn le tun ye Zuda ta jɛnkuru kuntigi ye, ");
INSERT INTO dyu_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Suwari dencɛ Netanehɛli tun ye Isakari ta mɔgɔw ta jɛnkuru kuntigi ye, ");
INSERT INTO dyu_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Helɔn dencɛ Eliyabu tun ye Zabulɔn ta mɔgɔw ta jɛnkuru kuntigi ye. ");
INSERT INTO dyu_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","O kɔ, o ka fanibon saninman* waraga, Gɛrisɔnkaw, ani Merarikaw k’a ta ka taga. ");
INSERT INTO dyu_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","O kɔ, jɛnkuru minw bɛ Rubɛn ta jamaba ra, olugu ka sira mina ka taga ni o ta darapo ye. O jamaba ra, Sedehuri dencɛ Elisuri le tun ye Rubɛn ta jɛnkuru kuntigi ye, ");
INSERT INTO dyu_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Surisadayi dencɛ Selumiyɛli tun ye Simeyɔn ta mɔgɔw ta jɛnkuru kuntigi ye, ");
INSERT INTO dyu_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Dewɛli dencɛ Eliyasafu tun ye Gadi ta mɔgɔw ta jɛnkuru kuntigi ye. ");
INSERT INTO dyu_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","O kɔ, Kehatika minw bɛ minan saninmanw ta, olugu ka sira mina. Ni Izirayɛlimɔgɔw tun tagara lɔ yɔrɔ o yɔrɔ, o tun ka kan ka fanibon saninman* lɔ sani Kehatikaw ye se yi. ");
INSERT INTO dyu_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Jɛnkuru minw bɛ Efirayimu ta jamaba ra, olugu tagara ni o ta darapo ye. O jamaba ra, Amihudi dencɛ Elisama le tun ye Efirayimu ta jɛnkuru kuntigi ye, ");
INSERT INTO dyu_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Pedasuri dencɛ Gamiliyɛli tun ye Manase ta mɔgɔw ta jɛnkuru kuntigi ye, ");
INSERT INTO dyu_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Gidehoni dencɛ Abidan tun ye Boniyaminu ta mɔgɔw ta jɛnkuru kuntigi ye. ");
INSERT INTO dyu_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","A laban, jɛnkuru minw bɛ Dan ta jamaba ra, olugu gbanna tɔw kɔ ni o ta darapo ye. Olugu le tun bɛ kɛ jama tɔw bɛɛ kɔ fɛ. O jamaba ra, Amisadayi dencɛ Ahezɛri le tun ye Dan ta jɛnkuru kuntigi ye, ");
INSERT INTO dyu_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Okiran dencɛ Pagiyɛli tun ye Asɛri ta mɔgɔw ta jɛnkuru kuntigi ye, ");
INSERT INTO dyu_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Enan dencɛ Ahira tun ye Nɛfitali ta mɔgɔw ta jɛnkuru kuntigi ye. ");
INSERT INTO dyu_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ni Izirayɛlimɔgɔw tun bɔra o sigiyɔrɔ ra ka sira mina, o ta jɛnkuruw tun bɛ tugu ɲɔgɔn kɔ nin cogo le ra ka taga. ");
INSERT INTO dyu_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ayiwa, Musa kumana Hobabu fɛ, min ye a burancɛ Madiyanka Rewɛli dencɛ ye; a ko: «Matigi Ala k’a fɔ an ye ko a bɛna yɔrɔ min di an ma, an bɛ tagara o yɔrɔ le ra. Na an ye taga; ni o kɛra, an bɛna koɲuman kɛ i ye, sabu Matigi Ala ka layiri ta ko a bɛna koɲuman caman kɛ Izirayɛlimɔgɔw ye.» ");
INSERT INTO dyu_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabu ko: «Ne tɛ taga; ne bɛ sekɔ ka taga ne yɛrɛ ta jamana le ra, ne ta mɔgɔw fɛ.» ");
INSERT INTO dyu_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa ko: «Sabari, kana bɔ an kɔ, sabu an bɛ se ka sigi yɔrɔ minw na kongokolon kɔnɔ, ele le ka o yɔrɔw lɔn; na, i bɛna bla an ɲa ka sira yira an na. ");
INSERT INTO dyu_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ni i ka taga ni an ye, ni Matigi Ala nana koɲuman o koɲuman kɛ an ye, i bɛna dɔ sɔrɔ o ra.» ");
INSERT INTO dyu_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ayiwa, Izirayɛlimɔgɔw bɔra Matigi Ala ta kuru yɔrɔ ra, ka tere saba kɛ tagama ra. Matigi Ala ta jɛnɲɔgɔnya kɛsu* tun bɛ o ɲa o tere saba kɔnɔ, ka taga nɛnɛkiriyɔrɔ ɲini o ye. ");
INSERT INTO dyu_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ni o tun ka wuri tuma o tuma ka bɔ o sigiyɔrɔ ra, Matigi Ala ta sankaba jamijan tun bɛ kɛ o kunna tere fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ni o tun bɛ jɛnɲɔgɔnya kɛsu ta tuma o tuma ko o bɛ taga, Musa tun b’a fɔ ko: «E, Matigi Ala, i wuri, ka i juguw bɛɛ janjan; i kɔninyabagaw bɛɛ ye bori i ɲa.» ");
INSERT INTO dyu_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ni o tun bɛ a lajigi tuma o tuma, a tun b’a fɔ ko: «E, Matigi Ala, i kɔsegi ka na! Na sigi Izirayɛli ta mɔgɔ waga caman camanw cɛ ra tuun!» ");
INSERT INTO dyu_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Lon dɔ, Izirayɛlimɔgɔw ka Matigi Ala jaraki ni kuma caman ye, o ta sɛgɛ kosɔn. Matigi Ala ka o mɛn minkɛ, o ma diya a ye, a dimina kosɛbɛ. A k’a ta tasuma mana o cɛ ra, ka o ta sigiyɔrɔ kɛrɛfɛyɔrɔ jɛni. ");
INSERT INTO dyu_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Mɔgɔw kasira Musa nɔ fɛ. Musa ka Matigi Ala daari; tasuma fagara. ");
INSERT INTO dyu_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","O ka o yɔrɔ tɔgɔ la ko Tabera, ko sabu Matigi Ala ta tasuma manana mɔgɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ayiwa, siya wɛrɛ mɔgɔ minw tun bɛ ni Izirayɛlimɔgɔw ye, Misiran ta domunifɛnw lɔgɔ gbanna olugu ra. Izirayɛlimɔgɔw fana wurira ka kasi tuun, ko: «E, jɔn le bɛna sogo di an ma yan, an ye a domu sa? ");
INSERT INTO dyu_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","A flɛ, an tun bɛ jɛgɛ minw domu gbansan Misiran, an hakiri bɛ jigira o bɛɛ ra, ani kɔnkɔnburu, ani nzɛrɛ, ani puwaro, ani jaba, ani layi. ");
INSERT INTO dyu_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Nka sisan an sɔn jara; lon o lon an ɲa tɛ foyi wɛrɛ ra ni nin mane kelen tɛ.» ");
INSERT INTO dyu_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ayiwa, mane tun bɛ i ko simankisɛ dɔ, k’a ɲa gbɛ i ko bideliyɔmuyiri ta ji. ");
INSERT INTO dyu_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Izirayɛlimɔgɔw tun bɛ bɔ ka taga a cɛ, ka na a si ni wuguw ye, walama k’a susu kolon kɔnɔ; dɔw tun b’a tobi daga kɔnɔ, walama k’a kɛ ŋɔmi ye. A timiya tun bɛ i ko ŋɔmi. ");
INSERT INTO dyu_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ni gɔmiji tun jigira su fɛ Izirayɛlimɔgɔw sigiyɔrɔ ra, mane fana tun bɛ jigi. ");
INSERT INTO dyu_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ayiwa, Musa k’a ye ko gbaw bɛɛ ta mɔgɔw bɛ kasira o ta fanibonw donda ra. Matigi Ala dimina kosɛbɛ. Musa fana jusu kasira. ");
INSERT INTO dyu_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","A ko Matigi Ala ma ko: «Mun na i ka i ta jɔncɛ jusu kasi tan? Mun kosɔn i ma makari ne ra, fɔ i ka nin jama bɛɛ doni ta k’a la ne kan sa? ");
INSERT INTO dyu_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Yala ne le ka nin mɔgɔw bɛɛ kɔnɔta wa, walama ne le ka o woro wa? Mun na i ko ne ye o ta i ko denɲɛnin lamɔbaga bɛ a ta cogo min na, ka taga ni o ye fɔ o ta jamana ra, i ka jamana min layiri ta o bɛmaw ye? ");
INSERT INTO dyu_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ne bɛna sogo sɔrɔ min k’a di nin mɔgɔw bɛɛ ma? A flɛ, o bɛ kasira ne da ra ko ne ye sogo di o ma o b’a domu! ");
INSERT INTO dyu_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ne kelen kɔni tɛ se nin mɔgɔw bɛɛ kɔrɔ tuun. O doni ka gbiri ne ma. ");
INSERT INTO dyu_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Sani i ye nin tɔɔrɔ la ne kan, ne bɛ i daari, ko ni ne ko ka di i ye, i ye ne faga kunkelen, janko ne yɛrɛ ɲa kana ne ta ɲani tɔ ye.» ");
INSERT INTO dyu_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ayiwa, Matigi Ala ka Musa jaabi ko: «I bɛ Izirayɛli cɛkɔrɔba minw jate ko o ye jama cɛkɔrɔbaw ye, ani jama kuntigiw, olugu cɛ biwolonfla wele ka o lajɛn ne ɲa kɔrɔ. Na ni o ye Ɲɔgɔnkunbɛn fanibon* donda ra, o ye na lɔ ni i ye ne ɲa kɔrɔ yi. ");
INSERT INTO dyu_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ne bɛna jigi ka na kuma i fɛ o yɔrɔ ra. Nin min bɛ i kan, ne bɛna o dɔ don olugu fana ra; olugu bɛna i dɛmɛ ka jama doni ta; i kelen tɛna o doni ta tuun. ");
INSERT INTO dyu_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","A fɔ jama ye ko o ye o yɛrɛ saninya sani sini cɛ; ko o bɛna sogo domu, sabu o kasira Matigi Ala toro kɔrɔ, ko: ‹Jɔn le bɛna sogo di an ma yan, an b’a domu sa? Misiran le tun ka di an na!› Ayiwa, Matigi Ala bɛna sogo di aw ma, aw b’a domu. ");
INSERT INTO dyu_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nka aw tɛna a domu k’a dan tere kelen ma dɛ, walama tere fla, walama tere looru, walama tere tan, walama tere mugan; ");
INSERT INTO dyu_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","aw bɛna a domu fɔ karo kelen le; k’a domu fɔ ka taga a bɔ aw nunwow fɛ, fɔ ka taga a lɔgɔ bɛɛ bɔ aw ra pewu. Sabu Matigi Ala min bɛ aw cɛ ra, aw ka ale le mafiyɛnya. Aw kasira a ɲa kɔrɔ ko: ‹Mun kosɔn an bɔra Misiran?› » ");
INSERT INTO dyu_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa ko Matigi Ala ma ko: «Ne bɛ nin jama min cɛ ra, o cɛw ye cɛ waga kɛmɛ wɔɔrɔ (600 000). Ele ko i bɛna sogo di o ma o b’a domu fɔ karo kelen! ");
INSERT INTO dyu_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Hali ni an ka sagaw, ani baw, ani misiw bɛɛ le faga o ye, yala o bɛna o wasa wa? Walama ni an ka kɔgɔji jɛgɛw bɛɛ mina o ye, yala o bɛna o wasa wa?» ");
INSERT INTO dyu_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Matigi Ala ka Musa jaabi ko: «O tuma ne ta baraka le ka dɔgɔ wa? Ne ka min fɔ, ni o bɛna kɛ can ye, walama ni a tɛna kɛ can ye, i yɛrɛ bɛna o ye sisan.» ");
INSERT INTO dyu_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ayiwa, Musa bɔra ka taga Matigi Ala ta kuma fɔ jama ye. A ka Izirayɛli cɛkɔrɔbaw cɛ biwolonfla ɲanawoloma, ka o lajɛn, ka o lɔlɔ ka fanibon saninman* lamini. ");
INSERT INTO dyu_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Matigi Ala jigira sankaba jamijan cɛ ma, ka na kuma ni Musa ye. Nin min tun bɛ Musa kan, a ka o dɔ ta ka o don o cɛkɔrɔba biwolonfla ra. Nin jigira o kan minkɛ dɔrɔn, o ka kɛ cirayakumaw fɔ ye; nka a danna o wagati dɔrɔn ma. ");
INSERT INTO dyu_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Cɛ fla tun bɛ yi, kelen tɔgɔ ye ko Ɛlidadi, tɔ kelen tɔgɔ ye ko Medadi; olugu tun tora o ta sow kɔnɔ. Nin jigira olugu fana kan, sabu o tɔgɔw tun sɛbɛra ni tɔw ye, nka o tun ma taga fanibon saninman* kɔrɔ. Olugu fana tun bɛ cirayakumaw fɔra. ");
INSERT INTO dyu_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Kanbelennin dɔ borira ka taga a fɔ Musa ye, ko: «Ɛlidadi ni Medadi bɛ ciraya kɛra Izirayɛlimɔgɔw cɛ ra!» ");
INSERT INTO dyu_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ayiwa, Nuni dencɛ Yosuwe, min tun ye Musa ta baaraden ye kabini a denmisɛnman, ale pɛrɛnna, ko: «Ne matigicɛ Musa, a fɔ ko o y’a dabla!» ");
INSERT INTO dyu_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musa k’a jaabi ko: «Ɲangboya le bɛ aw ra ne kosɔn wa? Ala m’a kɛra ko Matigi Ala ta mɔgɔw bɛɛ ye kɛ ciraw ye, Matigi Ala ye a ta Nin lajigi o bɛɛ kan.» ");
INSERT INTO dyu_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","O kɔ, Musa ni Izirayɛli cɛkɔrɔbaw sekɔra ka taga o sigiyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ayiwa, Matigi Ala ka fɔɲɔ dɔ fiyɛ; o fɔɲɔ nana ni wɔlɔninw ye ka bɔ kɔgɔji fan na, ka na o bɔn Izirayɛlimɔgɔw ta sigiyɔrɔ laminiw bɛɛ ra. Mɔgɔ tun bɛ se ka tere kelen tagama kɛ ka taga dugu lamini bɛɛ ra, i tun bɛ o kɔnɔw sɔrɔ yi; o tun tonna ɲɔgɔn kan dugu ma k’a se fɔ nɔngɔn ɲa fla. ");
INSERT INTO dyu_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mɔgɔw bɔra ka o kɔnɔw mina o lon tere bɛɛ, ani o su bɛɛ, ani o dugusagbɛ tere bɛɛ. Mɔgɔ si tun tɛ yi ni min ta tun ka dɔgɔ ni homɛri ɲa tan ye. O bɛɛ ka o kɔnɔw sogo lala o ta yɔrɔw kɛrɛ fɛ ka o ja. ");
INSERT INTO dyu_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ayiwa, ka sogo to o da ra, hali o m’a ɲimi ka ban fɔlɔ, Matigi Ala dimina o kɔrɔ kosɛbɛ; a ka banajuguba bla o ra. ");
INSERT INTO dyu_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","O ka o yɔrɔ tɔgɔ la ko Kiburɔti Hatava, sabu bana ka minw faga o ta sɔnjuguya kosɔn, o ka olugu su don o yɔrɔ le ra. ");
INSERT INTO dyu_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Izirayɛlimɔgɔw bɔra Kiburɔti Hatava ka taga Haserɔti; o tora Haserɔti. ");
INSERT INTO dyu_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Ayiwa, Mariyamu ni Haruna nana kɛ Musa kɔrɔfɔ ye a ta Kusika muso ta ko kosɔn; sabu Musa tun ka Kusika muso dɔ furu. ");
INSERT INTO dyu_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","O k’a fɔ ko: «Yala Matigi Ala bɛ kuma Musa dɔrɔn le fɛ wa? Yala a tɛ kuma anw fana fɛ wa?» Ayiwa, Matigi Ala ka o kuma mɛn. ");
INSERT INTO dyu_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","K’a sɔrɔ Musa tun ye mɔgɔ sabarininba le ye. A ɲɔgɔn mɔgɔ sabarinin tun tɛ dugukolo kɔ kan. ");
INSERT INTO dyu_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","O yɔrɔnin bɛɛ Matigi Ala k’a fɔ Musa ni Haruna ni Mariyamu ye ko: «Aw mɔgɔ saba bɛɛ ye bɔ ka na Ɲɔgɔnkunbɛn fanibon* donda ra.» O saba bɛɛ bɔra ka na. ");
INSERT INTO dyu_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Matigi Ala jigira ka na sankaba jamijan na, ka na lɔ fanibon saninman donda ra. A ka Haruna ni Mariyamu wele. O mɔgɔ fla bɛɛ gbarara. ");
INSERT INTO dyu_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","A ko: «Aw ye ne ta kuma lamɛn ka ɲa. Ni mɔgɔ dɔ ka kɛ Matigi Ala ta cira ye aw cɛ ra, ne bɛna ne yɛrɛ yira o tigi ra ni tagamasiyɛnw le ye; ne bɛna kuma a fɛ sikow le ra. ");
INSERT INTO dyu_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Nka ne ta jɔncɛ Musa ta tɛ ten; ale ye kankelentigi le ye ne ta mɔgɔw bɛɛ cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ne bɛ kuma ni a ye da ni da, k’a gbɛya a ye; ne tɛ kuma kɔrɔ dogo a ma. A bɛ Matigi Ala cogo yɛrɛ le ye a ɲa ra. O ra, mun na aw ma siran ka ne ta jɔncɛ Musa dɔgɔya?» ");
INSERT INTO dyu_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Matigi Ala dimina o kɔrɔ kosɛbɛ. A bɔra o kɔrɔ ka taga. ");
INSERT INTO dyu_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Sankaba bɔra fanibon saninman* kunna minkɛ dɔrɔn, farirabana dɔ ka Mariyamu mina, k’a fari bɛɛ gbɛ pepepe. Haruna k’a ɲa munu ka Mariyamu flɛ, a k’a ye ko o bana bɛ a fari ra. ");
INSERT INTO dyu_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Haruna ko Musa ma ko: «Ne matigicɛ, sabari, i kana a to an ta jurumun hakɛ ye ben an kan. Anw ka hakirintanyako le kɛ nin ye. ");
INSERT INTO dyu_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","I kana a to an balemamuso ye kɛ i ko den min sanin bɔra a bamuso kɔnɔ ni a fari tarancɛ torinin ye.» ");
INSERT INTO dyu_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa ka Matigi Ala daari ni kanba ye ko: «E, Ala, ne bɛ i daari ko i ye a kɛnɛya.» ");
INSERT INTO dyu_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Matigi Ala ka Musa jaabi ko: «Ni a facɛ le tun ka daji tu a ɲa kan, yala a tun tɛna to ni o maroya ye fɔ tere wolonfla wa? Aw y’a labɔ dugu kɔnɔ, k’a to a kelen na fɔ tere wolonfla; o kɔ, aw y’a to a ye na.» ");
INSERT INTO dyu_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","O ka Mariyamu labɔ mɔgɔw cɛ ra, k’a bla a kelen na fɔ tere wolonfla. Jama ma wuri ka bɔ o yɔrɔ ra fɔ ka taga Mariyamu kɔsegi ka na. ");
INSERT INTO dyu_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","O kɔ, Izirayɛlimɔgɔw bɔra Haserɔti, ka taga sigi Paran kongokolon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Ne ka layiri ta ko ne bɛna Kanaana jamana min di Izirayɛlimɔgɔw ma, mɔgɔ dɔw ci ka taga o jamana yaala. Kuntigi kelen kelen bɔ gbaw bɛɛ ra ka olugu ci.» ");
INSERT INTO dyu_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Musa ka o mɔgɔw ci ka bɔ Paran kongokolon yɔrɔ ra, ka kaɲa ni Matigi Ala ta kuma ye. O bɛɛ tun ye Izirayɛli kuntigi dɔw le ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","O mɔgɔw tɔgɔw ye nin ye: Min bɔra Rubɛn ta gba ra, o tun ye Zakuri dencɛ Samuha ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Min bɔra Simeyɔn ta gba ra, o tun ye Hɔri dencɛ Safati ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Min bɔra Zuda ta gba ra, o tun ye Yefune dencɛ Kalɛbu ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Min bɔra Isakari ta gba ra, o tun ye Yusufu dencɛ Igali ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Min bɔra Efirayimu ta gba ra, o tun ye Nuni dencɛ Hoze ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Min bɔra Boniyaminu ta gba ra, o tun ye Rafu dencɛ Paliti ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Min bɔra Zabulɔn ta gba ra, o tun ye Sodi dencɛ Gadiyɛli ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Min bɔra Yusufu dencɛ Manase ta gba ra, o tun ye Susi dencɛ Gadi ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Min bɔra Dan ta gba ra, o tun ye Gemali dencɛ Amiyɛli ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Min bɔra Asɛri ta gba ra, o tun ye Mikayilu dencɛ Seturi ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Min bɔra Nɛfitali ta gba ra, o tun ye Wofisi dencɛ Nabi ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Min bɔra Gadi ta gba ra, o tun ye Maki dencɛ Gewɛli ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Musa ka mɔgɔ minw ci ka taga jamana yaala, olugu tɔgɔw le ye nin ye. Musa ka Nuni dencɛ Hoze tɔgɔ la ko Yosuwe. ");
INSERT INTO dyu_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa ka o ci ko o ye taga Kanaana jamana yaala. A k’a fɔ o ye ko: «Aw ye tɛmɛ woroduguyanfan na, ka yɛlɛn ka taga kuruyɔrɔw ra. ");
INSERT INTO dyu_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Aw ye taga jamana flɛ, k’a lɔn a bɛ cogo min na, k’a lɔn ni a mɔgɔw baraka ka bon walama ni o baraka ka dɔgɔ, ni o ka ca walama ni o man ca. ");
INSERT INTO dyu_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ka o ta jamana cogoya flɛ, k’a lɔn ni a ka di, walama ni a man di; k’a o ta duguw cogoya flɛ, ni o lamininin lo ni kogow ye walama ni o lamininin tɛ. ");
INSERT INTO dyu_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Aw ye dugukolo cogoya flɛ, ni a ka di walama ni a man di, ni yiriw b’a ra walama ni yiri t’a ra. Aw ye jija ka na ni jamana yiriden dɔw ye fana.» O wagati tun ye rɛzɛn fɔlɔw mɔwagati le ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","O tagara ka taga jamana yaala, k’a ta Zini kongokolon yɔrɔ ra, ka taga se fɔ Rehɔbu, Hamati dugu donda ra. ");
INSERT INTO dyu_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","O tɛmɛna woroduguyanfan na ka taga se Heburɔn, Ahiman ni Sesayi ni Talimayi ta mɔgɔw, minw ye Anakikaw ye, olugu tun bɛ o yɔrɔ ra. Heburɔn dugu tun sigira ka san wolonfla kɛ, Sohan dugu ka sɔrɔ ka sigi Misiran jamana ra. ");
INSERT INTO dyu_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","O sera Esikɔli kɔ yɔrɔ ra minkɛ, o ka rɛzɛn yiriboro dɔ tigɛ ni a rɛzɛnmɔw ye; cɛ fla ka o dulon bere dɔ ra k’a la o kan na. O ka Gerenadimɔw, ani toromɔw fana tigɛ. ");
INSERT INTO dyu_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","O yɔrɔ tɔgɔ lara ko Esikɔli ta kɔ, sabu Izirayɛlimɔgɔw ka rɛzɛnmɔ tizan kelen tigɛ yi. ");
INSERT INTO dyu_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ayiwa, o mɔgɔw ka jamana yaala fɔ tere binaani; o kɔ, o sekɔra ka na. ");
INSERT INTO dyu_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","O nana minkɛ, o tagara Musa ni Haruna ni Izirayɛli jama bɛɛ lajɛnnin fɛ Kadɛsi, Paran kongokolon kɔnɔ. O ka min ye, o ka o lakari Musa ni Haruna ni Izirayɛli jama bɛɛ ye; o ka jamana yiridenw fana yira o ra. ");
INSERT INTO dyu_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","O ka o ta tagama dantigɛ Musa ye, ko: «I ka an ci jamana min na, an sera yi. Can ra jamanaɲuman lo, nɔnɔ ni li bɛ woyo jamana min na. A yiriden dɔw ye nin ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nka mɔgɔ minw bɛ o jamana ra, olugu baraka ka bon. O ta duguw laminina ni kogow ye; o duguw ka bonbon fana. An ka Anaki ta mɔgɔw fana ye yi. ");
INSERT INTO dyu_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalɛkikaw bɛ jamana woroduguyanfan na, Hɛtikaw, ani Yebusikaw, ani Amɔrikaw bɛ kuruyɔrɔw ra; Kanaanakaw bɛ kɔgɔjida ra, ani Zuridɛn bada yɔrɔw ra.» ");
INSERT INTO dyu_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Mɔgɔw nana kɛ Musa jaraki ye minkɛ, Kalɛbu k’a fɔ o ye ko o ye je. A ko: «An ye taga ben jamana kan k’a mina; an bɛna se o ra, sigiya t’a ra!» ");
INSERT INTO dyu_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Nka minw tun tagara ni a ye, olugu ko: «An tɛ se ka nin mɔgɔw kɛrɛ, sabu o baraka ka bon ni an ta ye.» ");
INSERT INTO dyu_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","O ka jamana cogo lakari k’a juguya Izirayɛlimɔgɔw ye. O ko: «Anw tagara nin jamana min yaala k’a yɔrɔw flɛ, o jamana bɛ mɔgɔw domu le. An ka mɔgɔ o mɔgɔ ye, o bɛɛ ye mɔgɔ janjanw ye. ");
INSERT INTO dyu_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","An ka mɔgɔ belebele jamijanw ye, Anaki ta mɔgɔw, minw ta siya ye mɔgɔjanw ye. Anw ka an yɛrɛ ye o kɔrɔ i ko tɔnw, olugu fana ka an ye o ɲa kɔrɔ o cogo le ra.» ");
INSERT INTO dyu_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","O lon su fɛ, Izirayɛli jama bɛɛ ka o kan kɔrɔta ka kasi ni kanba ye. ");
INSERT INTO dyu_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","O ka Musa ni Haruna jaraki; jama bɛɛ k’a fɔ o ma ko: «E, hali an tun ye sa Misiran sa, walama kongokolon kɔnɔ! ");
INSERT INTO dyu_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mun le kosɔn Matigi Ala bɛ tagara ni an ye nin jamana ra dɛ, k’a to o ye an faga ni kɛrɛkɛmuru ye? O bɛna an musow ni an denw mina. Ni an sekɔra Misiran, o tɛna fisaya an ma wa?» ");
INSERT INTO dyu_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","O k’a fɔ ɲɔgɔn ye ko: «An ye mɔgɔ dɔ ɲanawoloma ka o kɛ an ɲamɔgɔ ye, ka sekɔ ka taga Misiran!» ");
INSERT INTO dyu_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa ni Haruna k’a ye ten minkɛ, o ka o yɛrɛ firi dugu ma, ka o ɲa biri dugu ma Izirayɛli jama bɛɛ lajɛnnin ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Nuni dencɛ Yosuwe ni Yefune dencɛ Kalɛbu, olugu minw tun tagara jamana yaala fana, olugu dimina ka o ta deregew mina ka o faran. ");
INSERT INTO dyu_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","O k’a fɔ Izirayɛli jama bɛɛ ye ko: «An donna jamana min kɔnɔ k’a yaala, o jamana ka ɲi kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ni a diyara Matigi Ala ye, a bɛna taga an ladon o jamana ra, k’a di an ma; nɔnɔ ni li bɛ woyo o jamana ra. ");
INSERT INTO dyu_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nka aw kana muruti Matigi Ala kama, aw ja kana tigɛ nin jamana mɔgɔw kosɔn; sabu an bɛna o bɛɛ latunu ka bɔ yi. Kɔrɔsibaga tɛ olugu fɛ min bɛ se ka o tanga, k’a sɔrɔ Matigi Ala bɛ ni anw ye. O ra, aw kana siran o ɲa.» ");
INSERT INTO dyu_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","O ka o fɔ minkɛ, jama bɛɛ lajɛnnin wurira ko o bɛ o bon nin kabakuru ye. O wagati yɛrɛ ra, Matigi Ala nɔɔrɔ yirara Ɲɔgɔnkunbɛn fanibon* kunna Izirayɛlimɔgɔw bɛɛ ɲa na. ");
INSERT INTO dyu_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Matigi Ala k’a fɔ Musa ye ko: «Wagati juman le nin mɔgɔw bɛna ne mafiyɛnyari dabla dɛ? Ne ka kabakoba minw bɛɛ kɛ o cɛ ra, wagati juman le o bɛna o hakiri to o ra, ka la ne ra? ");
INSERT INTO dyu_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ne bɛna banajuguw lase o ma, ka o halaki. Nka ne bɛna ele Musa ta duruja kɛ siya dɔ ye, min ka bon, ani min baraka ka bon ni olugu ta ye.» ");
INSERT INTO dyu_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa ka Matigi Ala jaabi ko: «O tuma i ka nin mɔgɔw labɔ Misiranka minw cɛ ra i ta sebagaya baraka ra, olugu bɛna nin ko mɛn. ");
INSERT INTO dyu_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Olugu fana bɛna o ko fɔ yan jamana mɔgɔw ye. K’a sɔrɔ olugu k’a mɛn ko ele Matigi Ala bɛ ni nin mɔgɔw ye, ko i bɛ i yɛrɛ yira o ra ɲa ni ɲa, ko i bɛ kɛ sankaba jamijan na tere fɛ, janko ka sira yira o ra, ko i bɛ kɛ tasumamana jamijan na su fɛ, ka bla o ɲa, ka taga. ");
INSERT INTO dyu_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ayiwa, ni i ka na nin mɔgɔw bɛɛ faga yɔrɔnin kelen na tan, siya minw ka i ko mɛn, olugu bɛna a fɔ ko: ");
INSERT INTO dyu_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹Matigi Ala karira nin mɔgɔw ye ko a bɛna jamana min di o ma, a ma na se ka o ladon o jamana ra tuun. O kosɔn a ka o bɛɛ faga kongokolon kɔnɔ.› ");
INSERT INTO dyu_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","O ra, ne bɛ i daari Matigi Ala, ko i ye i ta sebagaya yira, i n’a fɔ i tun k’a fɔ cogo min na, ko: ");
INSERT INTO dyu_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‹Matigi Ala tɛ dimi joona; a ta ɲumanya ka bon. A bɛ terenbariya ni hakɛkow yafa mɔgɔw ma. Nka a tɛ kojugukɛbaga jarakibari to. A bɛ faw ta hakɛw bɔ o denw na, fɔ ka taga se o ta duruja sabanan ni a naaninan ma.› ");
INSERT INTO dyu_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","O kosɔn, Matigi Ala, i ta ɲumanyaba kosɔn, nin mɔgɔw ta terenbariya yafa o ma, i n’a fɔ i yafara o ma cogo min na kabini an bɔra Misiran fɔ ka na se yan.» ");
INSERT INTO dyu_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Matigi Ala ko: «Ne bɛ yafa o ma ka kaɲa ni i ta kuma ye. ");
INSERT INTO dyu_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Nka ne bɛ kari ko sigiya t’a ra, ne le ye Ala ɲanaman ye, ani i n’a fɔ ne Matigi Ala ta bonya ka dugukolo yɔrɔ bɛɛ fa, ");
INSERT INTO dyu_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","nin mɔgɔ minw ka ne ta nɔɔrɔ ye, ani ne ka kabako minw kɛ Misiran, ani kongokolon kɔnɔ, o minw sigiyara ne ra ka se fɔ siɲaga tan, minw ma sɔn ka ne lamɛn, ");
INSERT INTO dyu_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","o si ɲa tɛna nin jamana ye, ne tun ka jamana min layiri ta o bɛmaw ye; min o min ka ne mafiyɛnya, o si tɛna o jamana ye. ");
INSERT INTO dyu_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Nka i n’a fɔ ne ta baaraden Kalɛbu ta miiriya ni tɔw ta ma kɛ kelen ye, ani i n’a fɔ a ka ne ta sira tagama ni a jusukun bɛɛ ye, o kosɔn a tagara o jamana min yaala, ne bɛna a ladon o jamana ra; o jamana bɛna kɛ a ta durujaw ta ye. ");
INSERT INTO dyu_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ayiwa, Amalɛkikaw, ani Kanaanakaw siginin bɛ dingakɔnɔyɔrɔ ra. Sini aw ye sekɔ ka taga kongokolon kɔnɔ tuun, Kɔgɔjiwulen fan na.» ");
INSERT INTO dyu_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Matigi Ala k’a fɔ Musa ni Haruna ye tuun ko: ");
INSERT INTO dyu_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Nin mɔgɔjuguw bɛna ne mafiyɛnyari dabla wagati juman le? Sabu Izirayɛlimɔgɔw bɛ mafiyɛnyakan minw fɔra, ne ka o mafiyɛnyakanw mɛn. ");
INSERT INTO dyu_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","O kosɔn, a fɔ o ye ko Matigi Ala ko: ‹Ne bɛ kari ko sigiya t’a ra, ne le ye Ala ɲanaman ye, ko ne toro ka kuma min mɛn aw fɛ, ne bɛna o le kɛ aw ra. ");
INSERT INTO dyu_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","O tun ka aw minw bɛɛ jate, aw minw ka san mugan sɔrɔ, ani minw tɛmɛna o kan, aw minw ka ne mafiyɛnya, aw bɛɛ bɛna benben ka sa kongokolon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ne tun karira ko ne bɛna aw sigi jamana min na, aw si tɛna don o jamana ra, fɔ Yefune dencɛ Kalɛbu, ani Nuni dencɛ Yosuwe. ");
INSERT INTO dyu_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Aw tun ko mɔgɔw bɛna aw den minw mina, ne bɛna olugu le ladon o jamana kɔnɔ; aw banna o jamana min na, olugu le bɛna taga o diyabɔ. ");
INSERT INTO dyu_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Nka aw yɛrɛ kɔni, aw bɛna benben ka sa kongokolon kɔnɔ yan. ");
INSERT INTO dyu_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Aw denw bɛna bɛganw gbɛn kongokolon kɔnɔ yan fɔ san binaani; aw ta terenbariyaw hakɛ bɛna bɔ olugu ra, fɔ ka taga a to aw bɛɛ ye benben ka sa kongokolon kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Aw ka tere binaani le kɛ ka jamana yaala; aw ta terenbariyaw hakɛ bɛna bɔ aw ra fɔ san binaani fana. Tere kelen kelen bɛɛ bɛ kɛ san kelen ye. Ni o kɛra, fɛn min tɔgɔ ye ko ka ban ne ta ma, aw bɛna o silɔn. ");
INSERT INTO dyu_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","« ‹Ne Matigi Ala, ne kumana; sigiya t’a ra, ne bɛna nin kow kɛ nin mɔgɔjuguw ra, sabu o bɛnna kelen ma ka wuri ne kama. O bɛɛ bɛna benben nin kongokolon kɔnɔ yan ka sa.› » ");
INSERT INTO dyu_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ayiwa, a kɛra ten, Musa tun ka mɔgɔ minw ci ka taga jamana yaala, o mɔgɔw ra minw tun sekɔra ka na jamana cogo lakari k’a juguya ka o kibarojugu janjan, k’a to mɔgɔw ka Musa mafiyɛnya, ");
INSERT INTO dyu_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","o mɔgɔ minw tun ka jamana ta ko lakari k’a juguya, olugu barara ka sa yɔrɔnin kelen na Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","O mɔgɔ minw bɛɛ tun tagara jamana yaala, o mɔgɔw ra, Nuni dencɛ Yosuwe, ani Yefune dencɛ Kalɛbu dɔrɔn le ma sa. ");
INSERT INTO dyu_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ayiwa, Musa ka o kow lakari Izirayɛlimɔgɔw bɛɛ ye minkɛ, o jusu kasira kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","O dugusagbɛ sɔgɔmada joona fɛ, o wurira ka kɛ yɛlɛn ye ka taga kuruyɔrɔw fan na. O ko: «An ka jurumun kɛ; Matigi Ala ka yɔrɔ min layiri ta an ye, sisan an b’a fɛ ka taga yi.» ");
INSERT INTO dyu_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Musa ko o ma ko: «Mun kosɔn aw bɛ Matigi Ala ta kuma sɔsɔ? Nin ko tɛna ɲa. ");
INSERT INTO dyu_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Aw kana taga, sabu Matigi Ala tɛ ni aw ye. Aw juguw bɛna aw kɛrɛ ka se aw ra; ");
INSERT INTO dyu_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","sabu Amalɛkikaw ni Kanaanakaw bɛna lɔ aw ɲa, ka aw kɛrɛ, ka aw faga ni kɛrɛkɛmuru ye. Matigi Ala tɛna kɛ ni aw ye, sabu aw banna Matigi Ala ra.» ");
INSERT INTO dyu_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","O bɛɛ n’a ta, Izirayɛlimɔgɔw ka o kun gbɛlɛya ka kɛ yɛlɛn ye ka taga kuruyɔrɔw ra. Nka Matigi Ala ta jɛnɲɔgɔnya kɛsu* ma bɔ a sigiyɔrɔ ra, Musa fana ma bɔ a sigiyɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Amalɛkikaw ni Kanaanaka minw siginin bɛ o kuruyɔrɔw ra, olugu nana ben o kan, ka o gbɛn ka taga fɔ Hɔrima. ");
INSERT INTO dyu_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Kuma Izirayɛlimɔgɔw fɛ, k’a fɔ o ye ko ne bɛna jamana min di aw ma, k’a kɛ aw sigiyɔrɔ ye, ni aw nana taga don o jamana ra, ");
INSERT INTO dyu_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ni aw ko aw bɛ saraka dɔ jɛni tasuma ra Matigi Ala ye, min kasa ka di Matigi Ala ye, misi, walama saga, walama ba, ni a kɛra saraka jɛnita* le ye, walama dajurudafa saraka, walama diyanya saraka, walama ni aw b’a bɔ aw ta ɲanagbɛ dɔ le wagati ra, ");
INSERT INTO dyu_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","mɔgɔ min bɛ o saraka bɔ, o tigi ka kan ka mugu tɛntɛnnin kilo saba nɔɔni ni turu litiri kelen ni tarancɛ ye, ka o kɛ siman saraka* ye ka o fara o saraka kan. ");
INSERT INTO dyu_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Ni a bɛ sagaden le kɛ saraka jɛnita ye walama ninsɔndiya saraka ye, a ka kan ka rɛzɛnji litiri kelen ni tarancɛ kɛ rɛzɛnji saraka* ye, ka o fara o saraka bɛɛ kan. ");
INSERT INTO dyu_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ni a ta saraka ye sagajigi le ye, a ye mugu tɛntɛnnin kilo wɔɔrɔ nɔɔni ni turu litiri fla ye, ka o kɛ siman saraka ye ka o fara a kan, ");
INSERT INTO dyu_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ka rɛzɛnji litiri fla kɛ rɛzɛnji saraka ye, ka o fana fara a kan. O bɛ kɛ saraka ye, min kasa ka di ne Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«Ni aw bɛ misiden cɛman dɔ le di k’a kɛ saraka jɛnita ye, walama dajurudafa saraka ye, walama ninsɔndiya saraka* ye, ");
INSERT INTO dyu_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","aw ye mugu tɛntɛnnin kilo kɔnɔntɔn nɔɔni ni turu litiri saba ye, ka o kɛ siman saraka ye ka o fara o misiden kan, ");
INSERT INTO dyu_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ka rɛzɛnji litiri saba kɛ rɛzɛnji saraka ye, ka o fana fara a kan. Saraka jɛninin lo tasuma ra, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","«Misitoran bɛɛ, ani sagajigi bɛɛ, ani sagaden bɛɛ, ani baden bɛɛ ta saraka bɛ labɛn nin cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ni aw ta sarakaw ka kɛ da o da ye, aw ka kan ka o bɛɛ kelen kelen ta siman saraka ni o ta rɛzɛnji saraka bɔ danna ka o fara a kan. ");
INSERT INTO dyu_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Izirayɛli jamanaden bɛɛ ka kan k’a kɛ nin cogo le ra, ni a b’a fɛ ka saraka jɛni tasuma ra, k’a kɛ saraka ye min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Lonan minw fana bɛ aw cɛ ra, ni tɛmɛbagaw lo, walama ni o siginin lo aw fɛ kabini wagatijan, ni o dɔ b’a fɛ ka saraka jɛni tasuma ra, saraka min kasa ka di ne Matigi Ala ye, olugu fana ka kan k’a kɛ aw ta kɛcogo le ra. ");
INSERT INTO dyu_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Jama bɛɛ ka kan ka tagama nin cifɔnin kelen le kan, aw ni lonan minw bɛɛ siginin bɛ aw fɛ. Nin ye cifɔnin wuribari le ye aw ta durujaw bɛɛ fɛ. Aw ni lonanw bɛɛ ta ye kelen ye Matigi Ala ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","O sariya kelen ni o kolatigɛnin kelen le bɛ aw bɛɛ kan, aw ni lonan minw siginin bɛ aw fɛ.» ");
INSERT INTO dyu_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Matigi Ala kumana Musa fɛ tuun, ko: ");
INSERT INTO dyu_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Kuma Izirayɛlimɔgɔw fɛ k’a fɔ o ye ko ne bɛ tagara ni aw ye jamana min na, ni aw sera o jamana ra tuma min na, ");
INSERT INTO dyu_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ni aw nana kɛ o jamana siman domu ye wagati min na, aw ye o siman dɔ di Matigi Ala ma saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ni aw nana aw ta mugu fɔlɔ nɔɔni ko aw b’a kɛ buru ye, aw ye burukun fɔlɔ di ne ma saraka ye, i n’a fɔ ni aw ka siman gbasi, aw bɛ siman fɔlɔ di ne ma saraka ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Aw ta duruja nataw bɛɛ ra, ni aw nana aw ta mugu fɔlɔ nɔɔni, aw ka kan ka o saraka bɔ k’a di Matigi Ala ma.» ");
INSERT INTO dyu_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«Ayiwa, ne Matigi Ala ka kuma minw bɛɛ fɔ Musa ye, ni aw dɔ firira ka ko dɔ kɛ min ma bɛn ni o kumaw ye, ");
INSERT INTO dyu_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ne ka o kuma minw bɛɛ fɔ Musa ye, ko a ye a lase aw ma, k’a ta o kumaw fɔwagati ra, ani wagati nataw bɛɛ ra, ");
INSERT INTO dyu_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ni aw dɔ firira ka ko dɔ kɛ min ma bɛn ni o kumaw ye, k’a sɔrɔ jama fana ma bɔ a kala ma, o tuma jama bɛɛ lajɛnnin ka kan ka misitoran kaɲaman kelen kɛ saraka jɛnita* ye, saraka min kasa ka di Matigi Ala ye, k’a siman saraka* ni a rɛzɛnji saraka* fara a kan, i n’a fɔ a latigɛra cogo min na, ka bakɔrɔnin kelen fana kɛ jurumunyafa saraka* ye. ");
INSERT INTO dyu_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Sarakalasebaga bɛ jama bɛɛ lajɛnnin ta jurumun kafari a ye. Ni o kɛra, Ala bɛ yafa o ma, sabu o tun m’a lawuri a kama; o fana nana saraka jɛni Matigi Ala ye o ta hakɛ kosɔn, ka jurumunyafa saraka fana bɔ. ");
INSERT INTO dyu_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Izirayɛli jama bɛɛ, ani lonan minw bɛ o fɛ, Ala bɛna yafa o bɛɛ ma, sabu jama bɛɛ le firira. ");
INSERT INTO dyu_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«Nka ni a kɛra ko mɔgɔ kelen dɔrɔn le firira ka jurumun kɛ, o tigi ka kan ka na ni badennin musoman kelen ye, min ka san kelen bɔ, ka o kɛ jurumunyafa saraka ye. ");
INSERT INTO dyu_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Mɔgɔ min firira ka jurumun kɛ k’a sɔrɔ a ma a lawuri a kama, sarakalasebaga bɛ o tigi ta jurumun kafari a ye Matigi Ala ɲa kɔrɔ. Ni a ta jurumun kafarira, Ala bɛ yafa a ma. ");
INSERT INTO dyu_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ni mɔgɔ o mɔgɔ ka kojugu dɔ kɛ k’a sɔrɔ a m’a lawuri a kama, o sariya kelen le bɛna kɛ bɛɛ kan, Izirayɛliden fara lonan kan. ");
INSERT INTO dyu_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","«Nka ni mɔgɔ o mɔgɔ k’a lawuri a kama ka kojugu dɔ kɛ, ni a kɛra jamanaden dɔ le ye walama lonan, o tigi ka Matigi Ala tɔgɔ le cɛn. O tigi ka kan ka faran ka bɔ Izirayɛli ta jamanadenw na; ");
INSERT INTO dyu_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","sabu a ka Matigi Ala ta kuma le mafiyɛnya, ka ban a kumakan ma. O tigi ka kan ka faran ka bɔ a ta mɔgɔw cɛ ra; a ta terenbariya hakɛ bɛ ben a yɛrɛ kan.» ");
INSERT INTO dyu_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ayiwa, ka Izirayɛlimɔgɔw to kongokolon kɔnɔ, lon dɔ o ka cɛ dɔ sɔrɔ a bɛ lɔgɔ ɲinina Nɛnɛkirilon* na. ");
INSERT INTO dyu_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Minw tun k’a ye a bɛ lɔgɔ ɲinina, olugu k’a mina ka taga ni a ye Musa ni Haruna ni jama ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","O k’a mina k’a datugu, sabu min tun bɛna kɛ a ra, o tun ma latigɛ fɔlɔ. ");
INSERT INTO dyu_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ayiwa, Matigi Ala k’a fɔ Musa ye ko: «Nin cɛ ka kan ka faga. Jama bɛɛ lajɛnnin ka kan ka taga a bon ni kabakuru ye dugu kɔ fɛ.» ");
INSERT INTO dyu_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Jama bɔra ni o cɛ ye dugu kɔ fɛ, ka taga a bon k’a faga, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Matigi Ala k’a fɔ Musa ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Kuma Izirayɛlimɔgɔw fɛ, k’a fɔ o ye ko aw ni aw ta duruja nataw bɛɛ, wagati bɛɛ, aw ka kan ka dakun dɔw kɛ aw ta deregebaw ra, ka jese bulamanw don o dakunw bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ni o kɛra, aw bɛna o jese bulamanw flɛ, ka aw hakiri to Matigi Ala kumakanw bɛɛ ra, ka o sira tagama; aw tɛna Matigi Ala kan bla ka taga aw yɛrɛ jusukun diyanyakow, ani aw ɲa diyanyakow nɔ fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ni o kɛra, aw bɛna aw hakiri to ne kumakanw bɛɛ ra, k’a sira tagama, ka saninya ka kɛ Matigi Ala ta ye. ");
INSERT INTO dyu_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ne le ye Matigi Ala ye, aw ta Ala, min ka aw labɔ Misiran jamana ra, ka kɛ aw ta Ala ye. Ne le ye Matigi Ala ye, aw ta Ala.» ");
INSERT INTO dyu_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Levi ta mɔgɔ dɔ tun bɛ yi, min tɔgɔ tun ye ko Kore. A facɛ tɔgɔ ye ko Isari; Kehatika tun lo. Lon dɔ, Kore le murutira, ale ni Eliyabu dencɛw, minw ye Datan ni Abiramu ye, ani Pelɛti dencɛ Ɔni; o cɛ saba bɛɛ tun ye Rubɛn ta mɔgɔw le ye. ");
INSERT INTO dyu_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","O wurira Musa kama, olugu ni Izirayɛli cɛ kɛmɛ fla ni cɛ bilooru; o bɛɛ tun ye jama ɲamɔgɔw ye, ani jama ta koɲanabɔbagaw, jama tun bɛ mɔgɔ minw jate kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","O tagara lajɛn Musa ni Haruna kama, k’a fɔ o ye ko: «Aw ka aw ta tɛmɛ a dan kan! Nin jama bɛɛ saninyanin lo; o bɛɛ saninyanin lo. Matigi Ala fana bɛ ni o ye. Mun kosɔn aw le bɛ wuri ka aw yɛrɛ bla Matigi Ala ta mɔgɔw kunna?» ");
INSERT INTO dyu_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa ka o mɛn minkɛ, a k’a ɲa biri dugu ma. ");
INSERT INTO dyu_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","A k’a fɔ Kore ni a nɔfɛmɔgɔw bɛɛ ye ko: «Sini sɔgɔma, mɔgɔ min ye Matigi Ala ta ye, ani mɔgɔ min saninyanin lo, Matigi Ala yɛrɛ bɛna o tigi yira; a bɛna o tigi le gbara a yɛrɛ ra. Ni a nana mɔgɔ min ɲanawoloma, a bɛna o tigi le gbara a yɛrɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ayiwa, ele Kore, i ni i nɔfɛmɔgɔw, aw ka kan ka min kɛ, o ye nin ye: a ye wusunandaga dɔw ta. ");
INSERT INTO dyu_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Sini, aw ye tasuma kɛ o ra, ka wusunan don Matigi Ala ɲa kɔrɔ. Ni Matigi Ala ka mɔgɔ min ɲanawoloma, o tuma o tigi le saninyara; sabu aw Levi ta mɔgɔw, aw le ka aw ta ko tɛmɛ a dan kan!» ");
INSERT INTO dyu_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa k’a fɔ Kore ye tuun ko: «Aw Levi ta mɔgɔw, aw ye nin lamɛn! ");
INSERT INTO dyu_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Izirayɛli ta Ala ka aw bɔ Izirayɛlimɔgɔ tɔw ra ka aw gbara a yɛrɛ ra, k’a to aw ye baara kɛ Matigi Ala ta fanibon saninman* kɔnɔ, ka lɔ jama ɲa fɛ ka baara kɛ o nɔ ra, o belen ma aw wasa wa? ");
INSERT INTO dyu_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Matigi Ala sɔnna k’a to ele ni i balemaw, Levi ta mɔgɔ tɔw bɛɛ ye gbara ale ra; nka sisan aw b’a fɛ ka sarakalasebagaya fana kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ele ni i nɔfɛmɔgɔw jɛnna ka muruti Matigi Ala le kama! Ni o tɛ Haruna ye jɔntigi le ye, ka na a fɔ ko aw bɛ a mafiyɛnya?» ");
INSERT INTO dyu_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Musa ka mɔgɔ dɔ ci ka taga Eliyabu dencɛw, Datan ni Abiramu wele. O ko: «Anw tɛ taga yi.» ");
INSERT INTO dyu_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","O ko: «Nɔnɔ ni li bɛ woyora jamana min na, i ka an labɔ o jamana ra, ka na an faga kongokolon kɔnɔ yan minkɛ, o belen ma i wasa wa? Sisan i b’a fɛ ka i ta fanga sigi an kunna tuun wa? ");
INSERT INTO dyu_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Nɔnɔ ni li bɛ woyo jamana min na, i kɔni ma taga ni an ye o jamana le ra fiyewu; i fana ma forow ni rɛzɛnsunw le di an ma. O tuma ele b’a bisigi ko nin mɔgɔw ɲaw cinin lo wa? An kɔni tɛ taga yi fiyewu.» ");
INSERT INTO dyu_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa dimina kosɛbɛ. A ko Matigi Ala ma ko: «I kana sɔn o ta saraka ma; hali fali gbansan, ne m’a mina o fɛ, ne fana ma kojugu kɛ o si ra.» ");
INSERT INTO dyu_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Ayiwa, Musa k’a fɔ Kore ye ko: «Ele ni i nɔfɛmɔgɔw bɛɛ ye na Matigi Ala ɲa kɔrɔ sini; ele ni olugu, ani Haruna. ");
INSERT INTO dyu_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Bɛɛ ye a ta wusunandaga ta ka wusunan kɛ a kɔnɔ, ka na ni a ye Matigi Ala ɲa kɔrɔ. A bɛɛ bɛ kɛ wusunandaga kɛmɛ fla ni wusunandaga bilooru. Ele ni Haruna fana ye na ni aw ta wusunandagaw ye.» ");
INSERT INTO dyu_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","O bɛɛ ka o ta wusunandagaw ta ka tasuma kɛ a ra, ka wusunan kɛ a ra, ka lɔ ni Musa ni Haruna ye Ɲɔgɔnkunbɛn fanibon* donda ra. ");
INSERT INTO dyu_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kore tun ka jama bɛɛ lajɛn Musa ni Haruna kama Ɲɔgɔnkunbɛn fanibon donda ra. Matigi Ala ta nɔɔrɔ yirara jama bɛɛ lajɛnnin ɲa na. ");
INSERT INTO dyu_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Matigi Ala kumana Musa ni Haruna fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Aw ye aw yɛrɛ mabɔ nin jama ra, k’a to ne ye o bɛɛ halaki ka ban yɔrɔnin kelen na.» ");
INSERT INTO dyu_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Musa ni Haruna ka o ɲa biri dugu ma ka Ala daari, ko: «E, Ala, ele Ala min ye adamaden bɛɛ nin tigi ye, o tuma i bɛ dimi jama bɛɛ lajɛnnin kɔrɔ k’a sɔrɔ cɛ kelen dɔrɔn le ka kojugu kɛ wa?» ");
INSERT INTO dyu_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Matigi Ala ka Musa jaabi ko: ");
INSERT INTO dyu_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«A fɔ jama ye ko o ye o yɛrɛ mabɔ Kore ni Datan ni Abiramu ta fanibonw na.» ");
INSERT INTO dyu_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa wurira ka taga Datan ni Abiramu fɛ; Izirayɛli cɛkɔrɔbaw tugura a kɔ. ");
INSERT INTO dyu_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","A kumana jama fɛ, k’a fɔ o ye ko: «Aw ye aw yɛrɛ mabɔ nin mɔgɔjuguw ta fanibonw na. Aw kana maga o borofɛnw si ra, ni o tɛ, aw fana bɛna halaki ni o ye o ta jurumunw kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Jama ka o yɛrɛ mabɔ Kore ni Datan ni Abiramu ta fanibonw na. O y’a sɔrɔ Datan ni Abiramu tun bɔra ka na lɔ o ta fanibonw donda ra, o ni o ta musow ni o ta denw ni o mamadenw. ");
INSERT INTO dyu_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa ko: «Nin le bɛna a to aw bɛ a lɔn ko Matigi Ala le ka ne ci ka na nin kow bɛɛ kɛ, ko ne tɛ o kɛra ne yɛrɛ ma. ");
INSERT INTO dyu_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ayiwa, ni nin mɔgɔw sara adamaden tɔw sacogo ra, ka sa i n’a fɔ bɛɛ bɛ sa cogo min na, o tuma Matigi Ala ma ne ci. ");
INSERT INTO dyu_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Nka ni Matigi Ala ka kokura kɛ, ko min ma deri ka kɛ, ni dugukolo dayɛlɛra ka nin mɔgɔw ni o borofɛnw bɛɛ kunu, ka o ɲanaman lataga lahara, o tuma aw bɛna a lɔn ko nin mɔgɔw ka Matigi Ala dɔgɔya le.» ");
INSERT INTO dyu_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musa ka o kumaw bɛɛ fɔ ka ban minkɛ dɔrɔn, dugukolo cira Datan ni Abiramu senw kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Dugukolo dayɛlɛra ka o kunu, o ni o ta somɔgɔw bɛɛ, ani Kore ni a ta mɔgɔw bɛɛ, ani o borofɛnw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","O ɲanaman tagara lahara, o ni o borofɛnw bɛɛ. Dugukolo datugura o da ra. O halakira ka tunu ka bɔ Izirayɛli jama cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","O kulekanw fɛ, Izirayɛlimɔgɔ tɔ minw tun bɛ o kɔrɔ, olugu bɛɛ borira, ka kɛ kule ci ye, ko: «E, dugukolo kana na anw fana kunu!» ");
INSERT INTO dyu_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Cɛ kɛmɛ fla ni bilooru minw tun bɛ wusunan donna, tasuma dɔ bɔra Matigi Ala fɛ, ka olugu bɛɛ jɛni. ");
INSERT INTO dyu_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ayiwa, Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«A fɔ sarakalasebaga Haruna dencɛ Elehazari ye, ko a ye wusunandagaw bɔ tasuma ra, sabu fɛn saninyaninw lo; a ye taga o takamiw bɔn yɔrɔjan. ");
INSERT INTO dyu_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Nin mɔgɔw ka jurumun le kɛ, ka o nin to a ra; aw ye o ta wusunandagaw gbasi k’a kɛ nɛgɛ falafala dɔ ye ka o la sarakajɛnifɛn* kunna; sabu o nana ni o wusunandagaw ye Matigi Ala ɲa kɔrɔ minkɛ, o wusunandagaw saninyara. O ye kɛ hakirijigifɛn ye Izirayɛlimɔgɔw fɛ ka o lasɔmi.» ");
INSERT INTO dyu_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ayiwa, sarakalasebaga Elehazari ka o mɔgɔ jɛnininw ta wusunandaga siranɛgɛramanw cɛ; o ka o gbasi ka o la sarakajɛnifɛn kan, ");
INSERT INTO dyu_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","O tun kɛra janko ka Izirayɛlimɔgɔw hakiri jigi ko mɔgɔ si man kan ka wusunan don Matigi Ala ɲa kɔrɔ, ni a tigi ma kɛ Haruna ta duruja dɔ ye; ni mɔgɔ o mɔgɔ ka o kɛ, o tigi bɛ kɛ i ko Kore ni a nɔfɛmɔgɔw kɛra cogo min na. Matigi Ala tun kɔnna ka o kuma fɔ Musa ye ko a ye o lasɔmi. ");
INSERT INTO dyu_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ayiwa, o lon dugusagbɛ, Izirayɛli jama bɛɛ lajɛnnin dimina, ka kɛ Musa ni Haruna jaraki ye tuun. O ko: «A flɛ, aw le ka Matigi Ala ta mɔgɔw faga!» ");
INSERT INTO dyu_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Nka jama nana lajɛn Musa ni Haruna kama minkɛ, o ka o ɲa munu Ɲɔgɔnkunbɛn fanibon* fan na k’a ye ko sankaba barara k’a datugu; Matigi Ala ta nɔɔrɔ yirara. ");
INSERT INTO dyu_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Musa ni Haruna tagara Ɲɔgɔnkunbɛn fanibon ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«Aw ye bɔ nin jama cɛ ra, k’a to ne ye o bɛɛ halaki yɔrɔnin kelen.» Musa ni Haruna ka o ɲa biri dugu ma. ");
INSERT INTO dyu_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa k’a fɔ Haruna ye ko: «Wusunandaga ta, ka sarakajɛnifɛn* ta tasuma dɔ kɛ a ra, ka wusunan kɛ a ra, ka teliya ka taga jama cɛ ra, ka taga o ta jurumun kafari o ye; sabu Matigi Ala ta dimi wurira, fagari daminana ka ban.» ");
INSERT INTO dyu_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Musa k’a fɔ cogo min na, Haruna k’a kɛ ten; a borira ka taga jama cɛ ra; o y’a sɔrɔ fagari tun daminana mɔgɔw cɛ ra ka ban. Haruna ka wusunan don ka o ta jurumun kafari. ");
INSERT INTO dyu_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","A lɔra mɔgɔ ɲanamanw ni suw cɛ; fagari lalɔra. ");
INSERT INTO dyu_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Nka bana tun ka mɔgɔ waga tan ni naani ni mɔgɔ kɛmɛ wolonfla (14 700) le faga; minw sara Kore ta ko kosɔn, olugu ma jate o ra. ");
INSERT INTO dyu_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","O kɔ, Haruna sekɔra ka taga Musa fɛ Ɲɔgɔnkunbɛn fanibon donda ra; bana tun lalɔra. ");
INSERT INTO dyu_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«A fɔ Izirayɛlimɔgɔw ye ko o ta jamakuruw ta kuntigiw bɛɛ ye na ni bere kelen kelen ye; a bɛɛ lajɛnnin bɛna kɛ bere tan ni fla. I bɛ kuntigi bɛɛ tɔgɔ sɛbɛ a ta bere kan. ");
INSERT INTO dyu_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","I bɛ Haruna tɔgɔ sɛbɛ Levi ta mɔgɔw ta bere kan; sabu kuntigi bɛɛ ni a ta bere lo. ");
INSERT INTO dyu_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","I bɛ taga o berew bla Ɲɔgɔnkunbɛn fanibon* kɔnɔ, jɛnɲɔgɔnya kɛsu* ɲa fɛ, ne bɛ deri ka kuma ni aw ye yɔrɔ min na. ");
INSERT INTO dyu_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Ni mɔgɔ min ta bere nugura ka flaburu bɔ, o tigi le ye ne ta mɔgɔ ɲanawolomanin ye. Ni o kɛra, Izirayɛlimɔgɔw bɛ aw jarakira ni kuma minw ye, o kumaw bɛɛ bɛna ban ne ɲa kɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Musa ka o kuma fɔ Izirayɛlimɔgɔw ye. O ta kuntigiw bɛɛ nana bere kelen kelen di a ma. Jamakuru bɛɛ kelen kelen ta kuntigi nana ni bere kelen ye; a kɛra bere tan ni fla. Haruna ta bere fana tun b’a ra. ");
INSERT INTO dyu_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Musa ka berew bla Matigi Ala ɲa kɔrɔ fanibon saninman* kɔnɔ, jɛnɲɔgɔnya kɛsu bɛ yɔrɔ min na. ");
INSERT INTO dyu_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","O dugusagbɛ, Musa tagara don fanibon saninman kɔnɔ, jɛnɲɔgɔnya kɛsu yɔrɔ ra. A k’a ye ko Haruna ta bere min tun ye Levi ta gba ta ye, o nugura ka flaburuw ni fiyerenw bɔ, ka den fɔ k’a yiridenw mɔ. ");
INSERT INTO dyu_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Musa ka berew bɛɛ cɛ Matigi Ala ɲa kɔrɔ, ka taga ni o ye Izirayɛlimɔgɔw fɛ. O bɛɛ k’a ye; o bɛɛ ka o ta berew mina. ");
INSERT INTO dyu_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Matigi Ala k’a fɔ Musa ye tuun ko: «Sekɔ ni Haruna ta bere ye, k’a taga a bla jɛnɲɔgɔnya kɛsu ɲa fɛ. Mɔgɔ minw bɛ muruti ka ban ne ta kuma ma, a ye mara ka kɛ tagamasiyɛn ye olugu kosɔn; janko o ta mafiyɛnyakanw ye ban ka bɔ ne ɲa kɔrɔ, ne kana na o faga.» ");
INSERT INTO dyu_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Musa k’a kɛ ten. Matigi Ala tun ka kuma min fɔ a ye, a ka o kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Izirayɛlimɔgɔw k’a fɔ Musa ye ko: «Anw kɔni bɛna sa le! Anw ta banna le! An bɛɛ le ta banna! ");
INSERT INTO dyu_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Ni an min o min ka gbara Matigi Ala ta fanibon saninman na dɔrɔn, o tigi bɛ sa. O tuma an bɛɛ le bɛna sa ka ban wa?» ");
INSERT INTO dyu_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Matigi Ala k’a fɔ Haruna ye ko: «Ni terenbariya min o min kɛra yɔrɔ saninman* kɔnɔ, o hakɛ bɛ ele ni i dencɛw, ani aw ta somɔgɔw le kan. Nka ni terenbariya min kɛra aw ta sarakalasebagaya baara ra, o hakɛ bɛ ele ni i dencɛw dɔrɔn le kan. ");
INSERT INTO dyu_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","I balema minw ye i bɛmacɛ Levi ta mɔgɔw ye, olugu gbara i yɛrɛ ra; janko wagati min i ni i dencɛw bɛ fanibon saninman* ɲa fɛ, jɛnɲɔgɔnya kɛsu* yɔrɔ ra, olugu ye fara i kan ka i dɛmɛ. ");
INSERT INTO dyu_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ni i ka baara min yira o ra, o bɛna o le kɛ; o bɛna fanibon saninman ta baaraw bɛɛ kɛ. Nka o man kan ka maga yɔrɔ saninman ta minanw na, walama sarakajɛnifɛn* na, ni o tɛ, aw bɛna sa, olugu ni aw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","O bɛna fara i kan, ka o janto Ɲɔgɔnkunbɛn fanibon* na, k’a baaraw bɛɛ kɛ. Mɔgɔ wɛrɛ man kan ka gbara aw ra. ");
INSERT INTO dyu_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Aw yɛrɛ le ka kan ka aw janto yɔrɔ saninman ni sarakajɛnifɛn na, janko ne ta dimi kana se Izirayɛlimɔgɔw ma tuun. ");
INSERT INTO dyu_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","«Ne ka aw balemaw, Levi ta mɔgɔw ɲanawoloma ka bɔ Izirayɛlimɔgɔ tɔw ra; o blara danna Matigi Ala ye, ka o di aw ma, janko o ye Ɲɔgɔnkunbɛn fanibon ta baaraw kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Nka ele ni i dencɛw dɔrɔn le ka kan kɛ sarakalasebagaw ye; fɛn o fɛn bɛ kɛ sarakajɛnifɛn kan, walama yɔrɔ saninmanba* kɔnɔ, boncɛtigɛfani kɔ fɛ, aw le ka kan ka o kɛ. Ne ka sarakalasebagaya baara di aw le ma. Ni mɔgɔ wɛrɛ ka gbara yɔrɔ saninman na, o tigi ka kan ka faga.» ");
INSERT INTO dyu_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Matigi Ala k’a fɔ Haruna ye tuun ko: «Saraka minw bɛ di ne ma, ne yɛrɛ le ka i sigi ko i ye i janto o sarakaw ra. Izirayɛlimɔgɔw bɛ saraka saninman minw di ne ma, ne bɛ o di i ni i dencɛw ma, ka o kɛ aw ninyɔrɔ ye. O ye sariya wuribari le ye. ");
INSERT INTO dyu_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Saraka saninyaninba minw ma jɛni tasuma ra, o bɛna kɛ i ta ye: siman sarakaw*, ani jurumunyafa sarakaw*, ani hakɛ yafa sarakaw*, o bɛna o saraka minw bɔ ne ye, o saraka saninyaninbaw bɛna kɛ ele ni i dencɛw ta ye. ");
INSERT INTO dyu_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Aw ye o fɛnw domu yɔrɔ saninyanin na. Cɛdenw bɛɛ bɛ se k’a domu; aw ka kan k’a jate fɛn saninyanin le ye. ");
INSERT INTO dyu_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Fɛn minw fana bɛna kɛ i ta ye, o ye nin ye: ni Izirayɛlimɔgɔw ka fɛn o fɛn kɔrɔta san fɛ k’a fifa, k’a di ne ma saraka ye, ne bɛ o di i ni i dencɛw ni i denmusow ma. O bɛna kɛ sariya wuribari le ye. I ta sokɔnɔmɔgɔ min o min saninyanin lo, o bɛ se k’a domu. ");
INSERT INTO dyu_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Izirayɛlimɔgɔw bɛ simankura kun fɔlɔ minw di Matigi Ala ma, ne bɛ o fana di i ma: turu bɛɛ ra ɲumanman, ani rɛzɛnjikura bɛɛ ra ɲumanman, ani simankisɛ bɛɛ ra ɲumanman. ");
INSERT INTO dyu_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","O bɛna na ni o ta dugukolo siman fɔlɔ min ye ka na a di Matigi Ala ma, o bɛna kɛ i ta ye. I ta sokɔnɔmɔgɔ min o min saninyanin lo, o tigi bɛ se ka o domu. ");
INSERT INTO dyu_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Ni mɔgɔ k’a boro bɔ a borofɛn min o min kan pewu, k’a di Matigi Ala ma Izirayɛli jamana ra, o fɛn bɛ kɛ ele ta ye. ");
INSERT INTO dyu_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ni fɛnɲanaman o fɛnɲanaman den fɔlɔ cɛman dira Matigi Ala ma, ni a kɛra mɔgɔ le ye walama bɛgan, o fana bɛ kɛ i ta ye. Nka o ka kan ka mɔgɔw dencɛ fɔlɔw kunmabɔ, ka bɛgan saninyabariw fana den fɔlɔw kunmabɔ. ");
INSERT INTO dyu_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ni o ka karo kelen sɔrɔ, i bɛ o kunmabɔ. I yɛrɛ bɛ warida min yira, o bɛ kunmabɔ ni o le ye. O bɛ kɛ warigbɛ looru ye, ka kaɲa ni yɔrɔ saninman* ta jate ye. Yɔrɔ saninman ta jate ra, o warigbɛ bɛ bɛn gera mugan le ma. ");
INSERT INTO dyu_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","«Nka i man kan k’a to o ye misi, walama saga, walama ba den fɔlɔ kunmabɔ; sabu fɛn saninyaninw lo. I ka kan ka o faga ka o jori kɛ sarakajɛnifɛn kan, ka o turu jɛni, k’a kɛ saraka jɛninin ye tasuma ra, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","O sogo bɛ kɛ i ta ye, i n’a fɔ bɛgan disi ni a kininboroyanfan woto min fifara k’a di Ala ma, o ye i ta ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","«Izirayɛlimɔgɔw bɛ saraka saninman min o min kɔrɔta san fɛ k’a di Matigi Ala ma, ne bɛ o bɛɛ di i ni i dencɛw ni i denmusow ma, ka o kɛ sariya wuribari ye. O ye jɛnɲɔgɔnya wuribari le ye, min tɛ yɛlɛma Matigi Ala ɲa kɔrɔ, ele ni i ta duruja kosɔn.» ");
INSERT INTO dyu_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Matigi Ala k’a fɔ Haruna ye tuun ko: «Ele tɛna dugukolo dɔ sɔrɔ Izirayɛlimɔgɔw ta jamana ra; i tɛna ninyɔrɔ sɔrɔ o cɛ ra. Ne yɛrɛ le ye ele ninyɔrɔ ni i ta sɔrɔta ye Izirayɛlimɔgɔw cɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Matigi Ala k’a fɔ tuun ko: «Ne bɛ Izirayɛlimɔgɔw ta yagaw bɛɛ di Levi ta mɔgɔw ma o ta baara kosɔn, o bɛ baara min kɛ Ɲɔgɔnkunbɛn fanibon* kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","«Izirayɛlimɔgɔw man kan ka gbara Ɲɔgɔnkunbɛn fanibon na tuun, janko o kana na jurumun dɔ lase o yɛrɛ ma, ka sa o kosɔn. ");
INSERT INTO dyu_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Levi ta mɔgɔw le bɛna Ɲɔgɔnkunbɛn fanibon ta baaraw kɛ. Ni jurumun min o min ka kɛ o yɔrɔ ra, o hakɛ bɛ olugu le kan. O bɛna kɛ sariya wuribari le ye o ta duruja nataw bɛɛ fɛ. Levi ta mɔgɔw tɛna dugukolo si sɔrɔ Izirayɛlimɔgɔw cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Izirayɛlimɔgɔw bɛna yaga minw kɔrɔta san fɛ k’a di Matigi Ala ma saraka ye, ne bɛ o le di Levi ta mɔgɔw ma. O kosɔn ne k’a fɔ o ye ko o tɛna dugukolo si sɔrɔ Izirayɛlimɔgɔw cɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Kuma Levi ta mɔgɔw fɛ, k’a fɔ o ye ko: ‹Ne bɛ Izirayɛlimɔgɔw ta yaga minw di aw ma, ni o nana o di aw ma, aw ka kan ka dɔ bɔ o ra ka o di Matigi Ala ma, ka o yaga ta yaga fana bɔ. ");
INSERT INTO dyu_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","O yaga bɛna jate i n’a fɔ Izirayɛlimɔgɔ tɔw bɛ min bɔ o ta simankura ra, walama o ta rɛzɛnjikura ra k’a di ne ma. ");
INSERT INTO dyu_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","O cogo ra, ni aw ka yaga o yaga sɔrɔ Izirayɛlimɔgɔw fɛ, aw fana ka kan ka dɔ bɔ o ra ka o di Matigi Ala ma. Aw bɛ min bɔ k’a di Matigi Ala ma, aw bɛna o di sarakalasebaga Haruna le ma. ");
INSERT INTO dyu_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ni fɛn o fɛn dira aw ma, aw ka kan ka dɔ bɔ o bɛɛ ra ka o kɛ Matigi Ala ta ye. Aw ye a bɛɛ ra ɲumanman ni a saninman le bla danna Matigi Ala ye.› ");
INSERT INTO dyu_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","«A fɔ Levi ta mɔgɔw ye fana ko: ‹Ni aw ka o sarakaw bɛɛ ra ɲumanman bɔ, min tora o kɔ, o bɛna jate Levi ta mɔgɔw fɛ i n’a fɔ Izirayɛlimɔgɔw ta siman gbasinin min tora, walama o ta rɛzɛnji min tora o fɛ rɛzɛnforogidinga kɔnɔ, yaga bɔnin kɔ. ");
INSERT INTO dyu_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Aw ni aw ta somɔgɔw bɛna o domu aw diyanyayɔrɔ dɔ ra. Aw bɛ baara min kɛ Ɲɔgɔnkunbɛn fanibon* kɔnɔ, o baara sara lo. ");
INSERT INTO dyu_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Jurumun si hakɛ tɛna kɛ aw kan o ra; sabu aw ka o saraka yɔrɔ bɛɛ ra ɲumanman bɔ ka o di Matigi Ala ma ka ban. O ra, aw tɛna Izirayɛlimɔgɔw ta saraka saninmanw cɛn, o ra aw fana tɛna sa o kosɔn.› » ");
INSERT INTO dyu_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Matigi Ala kumana Musa ni Haruna fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Ne Matigi Ala, ne ka sariya min sigi, o sariya dɔ ye nin ye: A fɔ Izirayɛlimɔgɔw ye ko o ye na ni misi wulenman kelen ye, nɔ tɛ min na, fiyɛn si tɛ min fari ra, ani min ma sɛnɛ kɛ fɔlɔ. ");
INSERT INTO dyu_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Aw bɛ na o di sarakalasebaga Elehazari ma. Ale b’a to o ye a labɔ dugu kɔnɔ, ka taga a kannatigɛ a ɲa na. ");
INSERT INTO dyu_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Sarakalasebaga Elehazari b’a borokanden su misi jori ra, ka o seriseri siɲaga wolonfla Ɲɔgɔnkunbɛn fanibon* ɲafɛyɔrɔ kan. ");
INSERT INTO dyu_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","O bɛ misi bɛɛ jɛni sarakalasebaga yɛrɛ ɲa na: a gbolo, ani a sogo, ani a jori, ani a bo. ");
INSERT INTO dyu_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Sarakalasebaga bɛ sɛdiriyiri ni izopeyiri ni jese wulenman dɔ ta, ka o firi misi jɛnitasuma ra. ");
INSERT INTO dyu_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","O kɔ, sarakalasebaga bɛ a ta faniw ko, k’a yɛrɛ ko ni ji ye, ka sɔrɔ ka don dugu kɔnɔ; nka a saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Mɔgɔ min ka misi jɛni, o tigi fana bɛ a ta faniw ko, k’a yɛrɛ ko ni ji ye. Ale fana saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","O kɔ, mɔgɔ saninyanin dɔ bɛ taga misi jɛninin buguri cɛ, ka taga a kɛ yɔrɔ saninyanin dɔ ra, dugu kɔ fɛ. Aw bɛna o buguri mara Izirayɛli jama ye; o bɛna saninyari ji lalaga ni o buguri le ye. Jurumunyafa saraka lo. ");
INSERT INTO dyu_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Mɔgɔ min ka misi jɛninin buguri cɛ, o tigi ka kan k’a ta faniw ko. A saninyabari bɛ to fɔ ka taga wula se. O sariya bɛna kɛ sariya wuribari le ye Izirayɛlimɔgɔw fɛ, ani lonan minw siginin bɛ o cɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Ni mɔgɔ min magara su dɔ ra, ni a ka kɛ mɔgɔ o mɔgɔ su ye, o tigi saninyabari bɛ to fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","O tigi bɛna a yɛrɛ saninya ni o ji le ye a tere sabanan ni a tere wolonflanan, ka sɔrɔ ka saninya. Ni a m’a yɛrɛ saninya a tere sabanan ni a tere wolonflanan, a tɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ni mɔgɔ min ka maga su dɔ ra, mɔgɔ sanin dɔ ra, ni o tigi m’a yɛrɛ saninya, o tigi bɛ Matigi Ala ta fanibon saninman* lanɔgɔ. O tigi ka kan ka faran ka bɔ Izirayɛli ta jamanadenw na. Saninyari ji dɔ ma seriseri a kan minkɛ, o tuma a saninyanin tɛ; a ta nɔgɔ bɛ to a kan. ");
INSERT INTO dyu_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«Ayiwa, ni mɔgɔ sara fanibon kɔnɔ, o sariya ye nin ye: Ni mɔgɔ ka sa fanibon kɔnɔ, ni mɔgɔ o mɔgɔ ka don o fanibon kɔnɔ, ani mɔgɔ minw tun bɛ a kɔnɔ yi, olugu bɛɛ saninyabari bɛ to fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Minan o minan bɛ o bon kɔnɔ, ni a tun dayɛlɛnin bɛ, ni datugunan tun tɛ a da ra, o minan saninyabari lo. ");
INSERT INTO dyu_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","«Ni mɔgɔ dɔ fagara kɛrɛ ra, walama ni a sara a yɛrɛ ma, ni mɔgɔ o mɔgɔ ka maga o su ra kongo kɔnɔ, walama ni mɔgɔ ka maga su dɔ kolokunw na, walama kaburu dɔ ra, o tigi saninyabari bɛ to ka taga se fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«Ayiwa, ni mɔgɔ dɔ k’a yɛrɛ lanɔgɔ o cogo ra, misi min jɛnina ka kɛ jurumunyafa saraka ye, aw ye o bugurigbɛ dɔ ta, ka o kɛ minan dɔ kɔnɔ, ka ji ɲanaman dɔ kɛ o kan. ");
INSERT INTO dyu_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Mɔgɔ saninyanin dɔ bɛ izope flaburu su o ji ra, ka o seriseri fanibon ni minanw bɛɛ kan, ani mɔgɔ minw tun bɛ bon kɔnɔ. Mɔgɔ min magara su kolow ra, walama mɔgɔ faganin dɔ ra, walama mɔgɔ sanin dɔ su ra, walama kaburu dɔ ra, o ji ka kan ka seriseri o tigiw fana kan. ");
INSERT INTO dyu_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Mɔgɔ saninyanin bɛ o ji seriseri mɔgɔ saninyabari kan a tere sabanan, ani a tere wolonflanan. A tere wolonflanan, a bɛ o tigi saninya. Ni a saninyara, a bɛ a ta faniw ko, k’a yɛrɛ ko ji ra. O lon wula fɛ, a bɛ saninya. ");
INSERT INTO dyu_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«Nka ni mɔgɔ min k’a yɛrɛ lanɔgɔ, ni a ma sɔn k’a yɛrɛ saninya, o tigi ka kan ka faran ka bɔ jama cɛ ra; sabu a ka Matigi Ala ta yɔrɔ saninman* le lanɔgɔ. Saninyari ji ma seriseri a kan minkɛ, o tuma a saninyabari lo. ");
INSERT INTO dyu_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","«Nin bɛna kɛ sariya wuribari le ye Izirayɛlimɔgɔw fɛ. Mɔgɔ min bɛ saninyari ji seriseri mɔgɔw kan, ale bɛ a ta faniw ko. Ni mɔgɔ min ka maga o ji ra, o tigi saninyabari bɛ to fɔ ka taga wula se. ");
INSERT INTO dyu_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","«Ni mɔgɔ saninyabari ka maga fɛn o fɛn na, o fɛn bɛ lanɔgɔ. Ni mɔgɔ min ka maga a ra, o tigi fana saninyabari bɛ to fɔ ka taga wula se.» ");
INSERT INTO dyu_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","San karo fɔlɔ ra, Izirayɛli jama bɛɛ lajɛnnin sera Zini kongokolon kɔnɔ. O sigira Kadɛsi; Mariyamu sara o yɔrɔ le ra, a su donna yi le fana. ");
INSERT INTO dyu_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Jama ma ji sɔrɔ o yɔrɔ ra. O ka ɲɔgɔn lajɛn ka wuri Musa ni Haruna kama. ");
INSERT INTO dyu_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","O ka kɛrɛ ɲini Musa fɛ; o k’a fɔ ko: «An balemaw sara tuma min na Matigi Ala ɲa kɔrɔ, hali an fana tun ye sa o tuma ra!» ");
INSERT INTO dyu_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","O ko: «Mun kosɔn aw nana ni Matigi Ala ta mɔgɔw ye nin kongokolon kɔnɔ, ka na a to anw ni anw ta bɛganw bɛɛ ye sa yan? ");
INSERT INTO dyu_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Mun kosɔn aw ka an labɔ Misiran ka na ni an ye nin yɔrɔjugu ra yan dɛ? Sɛnɛkɛyɔrɔ tɛ yan, torosun tɛ yan, rɛzɛnsun tɛ yan, gerenadisun tɛ yan, hali ji minta yɛrɛ tɛ yan.» ");
INSERT INTO dyu_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa ni Haruna bɔra jama kɔrɔ, ka taga Ɲɔgɔnkunbɛn fanibon* donda ra. O ka o yɛrɛ firi dugu ma, ka o ɲa biri dugu ma; Matigi Ala ta nɔɔrɔ yirara o ra. ");
INSERT INTO dyu_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«I ta bere ta, i ni i kɔrɔcɛ Haruna ye jama wele ka o lajɛn. Aw ye kuma farakuru fɛ o ɲana; ni o kɛra, ji bɛna bɔ farakuru ra. I bɛ ji seri ka bɔ farakuru ra k’a di jama ma, janko o ni o ta bɛganw ye min.» ");
INSERT INTO dyu_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa ka bere ta Matigi Ala ɲa kɔrɔ, i n’a fɔ Matigi Ala tun k’a fɔ a ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa ni Haruna ka jama wele ka o lajɛn farakuru ɲa fɛ. Musa k’a fɔ o ye ko: «Aw mɔgɔ murutininw, aw ye ne lamɛn. An bɛna ji bɔ nin farakuru le ra k’a di aw ma wa?» ");
INSERT INTO dyu_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Musa k’a boro kɔrɔta ka farakuru bugɔ ni bere ye fɔ siɲaga fla. Ji caman woyora ka bɔ farakuru ra. Jama minna, bɛganw fana minna. ");
INSERT INTO dyu_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Nka Matigi Ala k’a fɔ Musa ni Haruna ye ko: «Aw ma la ne ta kuma ra, k’a yira Izirayɛlimɔgɔw ra, ko ne ye Ala saninman le ye; o ra, ne bɛ jamana min di nin jama ma, aw le tɛna o ladon o jamana ra tuun.» ");
INSERT INTO dyu_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ayiwa, o ji tɔgɔ le lara ko Meriba ta ji, ko sabu Izirayɛlimɔgɔw ka kɛrɛ ɲini Matigi Ala fɛ, Matigi Ala fana k’a ta saninmanya yira o cɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Ka Izirayɛlimɔgɔw to Kadɛsi, Musa ka ciraden dɔw ci ka taga Edɔmu masacɛ fɛ, ka taga a fɔ a ye ko: «I balemaw, Izirayɛlimɔgɔw ko: ‹Tɔɔrɔ minw sera an ma, i yɛrɛ ka o bɛɛ lɔn. ");
INSERT INTO dyu_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","« ‹An bɛmaw tun tagara Misiran. Anw tora yi ka san caman kɛ. Nka Misirankaw ka anw ni an bɛmaw minako juguya kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Nka an kulera ka Matigi Ala daari minkɛ, a ka an kulekan mɛn. A ka mɛlɛkɛ dɔ ci ka na an bɔsi ka an labɔ Misiran. Sisan an ye nin ye Kadɛsi, dugu min bɛ i ta jamana dan na. ");
INSERT INTO dyu_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","O ra, sabari k’a to an ye i ta jamana cɛtigɛ. An tɛna don aw ta foro si ra, an tɛna don aw ta rɛzɛnforo si ra, an tɛna aw ta kɔlɔn si ji min. An bɛna masacɛ ta sirabajuru kelen le ta; an tɛ jɛngɛ ka taga an kininboro fɛ walama ka taga an numanboro fɛ, fɔ ka taga an bɔ i ta jamana kɔnɔ.› » ");
INSERT INTO dyu_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edɔmu masacɛ ka o jaabi ko: «Aw tɛ tɛmɛ ne ta jamana ra. Ni aw ka tɛmɛ ne ta jamana ra, ne bɛ bɔ aw kama ni kɛrɛkɛmuru ye.» ");
INSERT INTO dyu_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Izirayɛlimɔgɔw k’a fɔ Edɔmu masacɛ ye tuun ko: «An bɛna tɛmɛ siraba le fɛ. Ni anw ni an ta bɛgan dɔ ka i ta ji dɔ min, an bɛna o sara. An b’a fɛ ka tagama ka tɛmɛ dɔrɔn le. An tɛna foyi wɛrɛ kɛ o kɔ.» ");
INSERT INTO dyu_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Edɔmu masacɛ ko: «Aw tɛ tɛmɛ yan.» O kɔ, Edɔmukaw bɔra ka na Izirayɛlimɔgɔw kama ni kɛrɛkɛjamaba ye; o baraka tun ka bon kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Edɔmukaw ma sɔn Izirayɛlimɔgɔw ye tɛmɛ o ta jamana ra minkɛ, Izirayɛlimɔgɔw faranna ka sira wɛrɛ ta. ");
INSERT INTO dyu_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Izirayɛli jama bɛɛ lajɛnnin bɔra Kadɛsi ka taga se Hɔri kuru ma. ");
INSERT INTO dyu_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Matigi Ala k’a fɔ Musa ni Haruna ye Hɔri kuru kɛrɛ fɛ, Edɔmu jamana dan na, ko: ");
INSERT INTO dyu_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Haruna bɛna sa ka taga fara a bɛma tɔw kan; ne bɛ jamana min di Izirayɛlimɔgɔw ma, a tɛna don o jamana ra, sabu ne tun ka ci min fɔ aw ye Meriba ta ji yɔrɔ ra, aw fla bɛɛ murutira, aw ma o ci kɛ a cogo ra. ");
INSERT INTO dyu_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ele Musa, ele ye Haruna ni a dencɛ Elehazari ta, ka yɛlɛn ni o ye Hɔri kuru kan. ");
INSERT INTO dyu_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","I bɛ Haruna ta sarakalasebagaya faniw bɔ a ra, ka o don a dencɛ Elehazari ra. Haruna bɛna sa o yɔrɔ le ra, ka taga fara a bɛma tɔw kan.» ");
INSERT INTO dyu_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Matigi Ala ka min fɔ, Musa ka o kɛ. O bɛɛ yɛlɛnna Hɔri kuru kan jama bɛɛ ɲa na. ");
INSERT INTO dyu_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa ka Haruna ta sarakalasebagaya faniw bɔ a ra, ka o don a dencɛ Elehazari ra. Haruna sara kuru kunna yi. Musa ni Elehazari jigira ka bɔ kuru kan. ");
INSERT INTO dyu_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Jama k’a ye ko Haruna sara minkɛ, o k’a su kasi fɔ tere bisaba. ");
INSERT INTO dyu_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kanaanakaw ta masacɛ min bɛ Aradi mara kunna, min tun siginin bɛ woroduguyanfan na, ale k’a mɛn ko Izirayɛlimɔgɔw bɛ nana Atarimu dugu sira fɛ. A nana Izirayɛlimɔgɔw kɛrɛ ka o ta mɔgɔ dɔw mina ka taga ni o ye. ");
INSERT INTO dyu_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Izirayɛli ta mɔgɔw ka dajuru ta Matigi Ala fɛ. O ko: «Matigi Ala, ni i ka nin mɔgɔw don an boro, an bɛna o ta duguw bɛɛ halaki ka ban pewu.» ");
INSERT INTO dyu_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Matigi Ala ka Izirayɛlimɔgɔw ta dajuru jaabi. A ka Kanaanakaw don o boro. O ka o ni o ta duguw bɛɛ halaki ka ban pewu. O ka o yɔrɔ tɔgɔ la ko Hɔrima. ");
INSERT INTO dyu_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Izirayɛlimɔgɔw bɔra Hɔri kuru yɔrɔ ra, ka tɛmɛ Kɔgɔjiwulen sira fɛ, ka Edɔmu jamana munumunu. Nka ka o to sira ra, sɛgɛ ma na kun Izirayɛlimɔgɔw ra. ");
INSERT INTO dyu_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","O ka Matigi Ala ni Musa jaraki; o ko: «Mun kosɔn aw ka anw labɔ Misiran, k’a to an ye na sa kongokolon kɔnɔ yan? Sabu domunifɛn tɛ yan, ji tɛ yan. Nin domuni kunntan fana lɔgɔ bɔra an na.» ");
INSERT INTO dyu_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","A kɛra ten minkɛ, Matigi Ala ka sajugu dɔw bla ka na Izirayɛlimɔgɔw kama. O ka mɔgɔw kin; mɔgɔ caman sara Izirayɛlimɔgɔw ra. ");
INSERT INTO dyu_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Mɔgɔw nana Musa fɛ; o ko: «An ka jurumun kɛ, sabu an ka Matigi Ala ni ele yɛrɛ jaraki. Matigi Ala daari an ye, janko a ye nin saw mabɔ an na.» Musa ka Matigi Ala daari mɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Matigi Ala k’a fɔ Musa ye ko: «Sa bisigiya dɔ lalaga ni siranɛgɛ ye, k’a dulon yiri dɔ ra. Ni sa ka mɔgɔ o mɔgɔ kin, ni o tigi ka o sa lalaganin flɛ, o tigi tɛ sa.» ");
INSERT INTO dyu_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Musa ka sa dɔ lalaga ni siranɛgɛ ye, ka o dulon yiri dɔ ra. Ni sa tun ka mɔgɔ o mɔgɔ kin, ni o tigi tun ka siranɛgɛsa flɛ dɔrɔn, o tigi tun bɛ kisi. ");
INSERT INTO dyu_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Izirayɛlimɔgɔw bɔra o yɔrɔ ra, ka taga sigi Obɔti. ");
INSERT INTO dyu_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","O bɔra Obɔti ka taga sigi Iye Abarimu, kongokolon min ɲasinna Mohabu jamana ma, terebɔyanfan na. ");
INSERT INTO dyu_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","O bɔra o yɔrɔ ra, ka taga sigi Zerɛdi kɛnɛgbɛba ra. ");
INSERT INTO dyu_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","O bɔra yi, ka taga sigi Arinɔn kɔ ɲa dɔ kan; Arinɔn kɔ le bɛ woyo ka bɔ Amɔrikaw ta jamana ra, ka taga kongokolon kɔnɔ. Arinɔn kɔ le ye Mohabu jamana dan ye; a bɛ Mohabu jamana ni Amɔrikaw ta jamana fla cɛ ma. ");
INSERT INTO dyu_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","O le kosɔn, a sɛbɛra Matigi Ala ta Kɛrɛkow kitabu kɔnɔ, ko: «Vahɛbu min bɛ Sufa jamana ra, ani Arinɔn kɔ ta baborow, ");
INSERT INTO dyu_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ani baboro minw bɛ woyo ka taga Ari dugu fan fɛ, o bɛ taga se fɔ Mohabu ta jamana dan na.» ");
INSERT INTO dyu_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Izirayɛlimɔgɔw bɔra o yɔrɔ ra ka taga Bɛri. Bɛri kɔlɔn yɔrɔ le ra, Matigi Ala k’a fɔ Musa ye ko: «Mɔgɔw lajɛn, ne bɛna ji di o ma.» ");
INSERT INTO dyu_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","O tuma le ra, Izirayɛlimɔgɔw ka nin dɔnkiri la; o ko: «Kɔlɔn, ji bɛna bɔ ele ra fɔ ka woyo! An ye dɔnkiri la ka o fɔ! ");
INSERT INTO dyu_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Masacɛw ka kɔlɔn min sogi, jamana ɲamɔgɔw ka kɔlɔn min sogi, ni o ta masacɛberew ni o ta tagamaberew ye.» Izirayɛlimɔgɔw bɔra kongokolon kɔnɔ ka taga Matana, ");
INSERT INTO dyu_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ka bɔ Matana ka taga Nahaliyɛli, ka bɔ Nahaliyɛli ka taga Bamɔti. ");
INSERT INTO dyu_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","O bɔra Bamɔti ka taga Mohabu jamana kɛnɛgbɛba ra, Pisiga kuru fan na, mɔgɔ bɛ se ka to Pisiga kuru kuncɛ ma yɔrɔ min na ka kongokolon bɛɛ ye. ");
INSERT INTO dyu_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Izirayɛlimɔgɔw ka ciraden dɔw ci ka taga Amɔrikaw ta masacɛ Sihɔn fɛ, ka taga a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«A to an ye tɛmɛ i ta jamana fɛ. An tɛna don aw ta forow ra, an tɛna don aw ta rɛzɛnforow ra, an tɛna aw ta kɔlɔnw ji min. An bɛna masacɛ ta sirabajuru kelen le ta, fɔ ka taga an bɔ i ta jamana kɔnɔ.» ");
INSERT INTO dyu_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Nka masacɛ Sihɔn ma sɔn Izirayɛlimɔgɔw ye tɛmɛ a ta jamana fɛ. A k’a ta mɔgɔw bɛɛ lajɛn, ka bɔ ka taga Izirayɛlimɔgɔw kama kongokolon kɔnɔ. A tagara Izirayɛlimɔgɔw kɛrɛ Yahasi. ");
INSERT INTO dyu_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Nka Izirayɛlimɔgɔw sera a ra; o k’a ta jamana mina, k’a ta Arinɔn kɔ ra, ka taga a bla fɔ Yabɔki kɔ ra; nka o danna Amɔnkaw ta jamana dan na, sabu o tun ka kogo barakamanw lɔ o jamana dan na. ");
INSERT INTO dyu_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Izirayɛlimɔgɔw ka Amɔrikaw ta duguw bɛɛ mina, ka sigi o duguw ra; o ka Hɛsibɔn dugu fana mina, ani a kɛrɛfɛduguw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hɛsibɔn dugu le tun ye Amɔrikaw ta masacɛ Sihɔn ta masadugu ye. Ale le tun ka Mohabukaw ta masacɛkɔrɔ kɛrɛ, k’a ta jamana bɛɛ bɔsi a ra, ka taga se fɔ Arinɔn kɔ ma. ");
INSERT INTO dyu_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","O kosɔn dɔnkirilabagaw tun b’a fɔ ko: «Aw ye na Hɛsibɔn, ka na dugu lɔ kokura, aw ye Sihɔn ta dugu labɛn! ");
INSERT INTO dyu_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Tasuma dɔ bɔra Hɛsibɔn, tasumamana dɔ bɔra Sihɔn ta dugu kɔnɔ; ka Ari dugu jɛni, Mohabu jamana ra, ani kuntigi minw bɛ Arinɔn mara sanfɛyɔrɔw ra. ");
INSERT INTO dyu_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","E, Mohabukaw, bɔnɔ ka aw sɔrɔ. E, Kemɔsi ta mɔgɔw, aw ta banna. O k’a dencɛw labori, k’a denmusow mina ka taga ni o ye Amɔrikaw ta masacɛ Sihɔn fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Nka an ka o bon ni an ta biɲɛw ye; Hɛsibɔn halakira ka taga a bla fɔ Dibɔn. An ka cɛnri kɛ ka taga se fɔ Nofaki, ka taga se fɔ Medeba.» ");
INSERT INTO dyu_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Izirayɛlimɔgɔw sigira Amɔrikaw ta jamana ra o cogo le ra. ");
INSERT INTO dyu_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa ka mɔgɔ dɔw ci ka taga Yazɛri mara flɛ dogo ra. O kɔ, o ka Yazɛri kɛrɛfɛduguw mina; Amɔrika minw tun bɛ o yɔrɔ ra, o ka olugu gbɛn ka bɔ yi. ");
INSERT INTO dyu_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","O kɔ, Izirayɛlimɔgɔw ka o yɔrɔ sira bla ka Basan mara sira ta. Basan masacɛ Ɔgi bɔra ka na o kama ni a ta kɛrɛkɛjama bɛɛ ye, ko a bɛna o kɛrɛ Edereyi. ");
INSERT INTO dyu_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Matigi Ala k’a fɔ Musa ye ko: «I kana siran a ɲa, sabu ne bɛna a don i boro, ani a ta kɛrɛkɛjama bɛɛ, ani a ta jamana; i bɛna a kɛ i n’a fɔ i ka Amɔrikaw ta masacɛ Sihɔn kɛ cogo min na, min tun siginin bɛ Hɛsibɔn.» ");
INSERT INTO dyu_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Izirayɛlimɔgɔw ka Ɔgi kɛrɛ, ka ale ni a dencɛw ni a ta kɛrɛkɛjama bɛɛ faga; o ma hali mɔgɔ kelen to. O ka o ta jamana mina. ");
INSERT INTO dyu_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Izirayɛlimɔgɔw tagara sigi Mohabu kɛnɛgbɛ ra, Zuridɛn ba terebɔyanfan na, Zeriko dugu ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Izirayɛlimɔgɔw tun ka ko minw bɛɛ kɛ Amɔrikaw ra, o kibaroya tun sera Sipɔri dencɛ Balaki ma, Mohabukaw ta masacɛ. ");
INSERT INTO dyu_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mohabukaw siranna kosɛbɛ Izirayɛlimɔgɔw ta jama caya kosɔn; o ka Izirayɛlimɔgɔw ye minkɛ, o ja tigɛra. ");
INSERT INTO dyu_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Mohabukaw k’a fɔ Madiyan cɛkɔrɔbaw ye ko: «Nin jama caman bɛna an ta jamana laminiw bɛɛ halaki, i n’a fɔ misi bɛ binkɛnɛ domu cogo min na.» Ayiwa, o wagati ra, Sipɔri dencɛ Balaki tun ye Mohabukaw ta masacɛ ye. ");
INSERT INTO dyu_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Balaki ka ciraden dɔw ci ka taga Behɔri dencɛ Balamu fɛ, a ta jamana ra, Petɔri dugu kɔnɔ, Efirati bada ra, ko o ye taga a wele; a ko o y’a fɔ a ye ko: «Siya dɔ bɔra Misiran jamana ra, o ka ca, o ka jamana yɔrɔ bɛɛ fa. O nana sigi ne ta jamana kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Sabari ka na nin mɔgɔw danga ne ye, sabu o baraka ka bon ni ne ta ye. O bɛ se ka kɛ sababu ye k’a to ne ye se sɔrɔ o kan, ka o gbɛn ka bɔ jamana kɔnɔ; sabu ne k’a lɔn ko ni ele ka dugawu kɛ mɔgɔ min ye, o dugawu bɛ mina; ni i ka mɔgɔ min danga fana, danga bɛ o tigi mina.» ");
INSERT INTO dyu_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Mohabu cɛkɔrɔbaw, ani Madiyan cɛkɔrɔbaw tagara ni lagbɛrikɛbaga Balamu ta sara ye o boro. O tagara se Balamu ma, o ka Balaki ta cira fɔ a ye. ");
INSERT INTO dyu_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balamu k’a fɔ o ye ko: «Aw ye si yan; ni Matigi Ala nana min yira ne ra, ne bɛna aw jaabi ni o le ye.» Mohabu kuntigiw sira Balamu ta so. ");
INSERT INTO dyu_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ala nana Balamu ɲininka ko: «Nin mɔgɔ minw bɛ i ta so, olugu ye jɔntigiw le ye?» ");
INSERT INTO dyu_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balamu ka Ala jaabi ko: «Mohabukaw ta masacɛ min ye Sipɔri dencɛ Balaki ye, ale le ka o ci ne fɛ, ko o ye na a fɔ ne ye, ");
INSERT INTO dyu_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ko siya dɔ bɔra Misiran ka na, ko o ka jamana yɔrɔ bɛɛ fa, ko ne ye taga o danga ale ye; a ko o bɛ se ka kɛ sababu ye k’a to ale ye se ka o kɛrɛ, ka o gbɛn.» ");
INSERT INTO dyu_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ala k’a fɔ Balamu ye ko: «I kana taga ni o ye; i man kan ka nin mɔgɔw danga, sabu ne ta baraka bɛ o kan.» ");
INSERT INTO dyu_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balamu wurira sɔgɔmada fɛ; a k’a fɔ Balaki ta jamana kuntigiw ye ko: «Aw ye sekɔ aw ta jamana ra, sabu Matigi Ala ma sɔn k’a to ne ye taga ni aw ye.» ");
INSERT INTO dyu_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Mohabu jamana kuntigiw sekɔra ka taga Balaki fɛ, ka taga a fɔ a ye ko: «Balamu banna ka na ni an ye.» ");
INSERT INTO dyu_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaki ka kuntigi wɛrɛw ci tuun, minw tun ka ca, ani minw ta fanga tun ka bon ni kuntigi fɔlɔw ta ye. ");
INSERT INTO dyu_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Olugu nana Balamu fɛ ka na a fɔ a ye ko: «Sipɔri dencɛ Balaki ko i kana a to foyi ye i bari ka taga ale fɛ, ");
INSERT INTO dyu_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ko sabu ale bɛna i bonya kosɛbɛ; ni i ka fɛn o fɛn fɔ, a bɛna o kɛ i ye. A ko i ye sabari ka na nin mɔgɔw danga.» ");
INSERT INTO dyu_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balamu ka Balaki ta ciradenw jaabi ko: «Hali ni Balaki k’a ta masabon fa warigbɛ ni sanin le ra k’a di ne ma, ne tɛ se ka foyi si kɛ, koba walama ko fitini, ni min tɛ bɛn ni Matigi Ala, ne ta Ala ta kuma ye. ");
INSERT INTO dyu_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","O bɛɛ n’a ta, aw fana ye si yan; Matigi Ala bɛna min fɔ ne ye tuun, ne bɛna o lɔn.» ");
INSERT INTO dyu_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ala nana a fɔ Balamu ye o lon su fɛ, ko: «I n’a fɔ nin mɔgɔw nana i wele, wuri ka taga ni o ye; nka ne bɛna min fɔ i ye, i ka kan ka o le kɛ.» ");
INSERT INTO dyu_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","O dugusagbɛ sɔgɔma, Balamu wurira k’a ta falimuso labɛn, ka taga ni Mohabu jamana kuntigiw ye. ");
INSERT INTO dyu_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Balamu tagara minkɛ, Matigi Ala dimina a kɔrɔ kosɛbɛ. Matigi Ala ta mɛlɛkɛ dɔ tagara lɔ a ɲa sira ra k’a ɲakɔrɔmatigɛ. O y’a sɔrɔ a tun bɛ a ta fali kan; a ta baaraden fla tun bɛ ni a ye. ");
INSERT INTO dyu_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Falimuso ka Matigi Ala ta mɛlɛkɛ lɔnin ye sira kan, kɛrɛkɛmuru b’a boro, a bɔnin bɛ a la ra. Falimuso ka sira bla ka don foro kɔnɔ. Balamu ka falimuso bugɔ, janko k’a lana sira kan. ");
INSERT INTO dyu_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","O tagara se siradennin dɔ ma rɛzɛnforow cɛ ra. Kogo tun bɛ sira fan fla bɛɛ ra. Matigi Ala ta mɛlɛkɛ tagara lɔ o ɲa tuun. ");
INSERT INTO dyu_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Falimuso ka Matigi Ala ta mɛlɛkɛ ye minkɛ, a k’a yɛrɛ nɔrɔ kogo ra ka tɛmɛ, fɔ ka Balamu sen dɛrɛ kogo kan. Balamu k’a bugɔ tuun. ");
INSERT INTO dyu_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Matigi Ala ta mɛlɛkɛ tɛmɛna o ra, ka taga lɔ o ɲa yɔrɔ degunin dɔ ra; tɛmɛcogo wɛrɛ tun tɛ o yɔrɔ ra, kininboroyanfan na walama numanboroyanfan na. ");
INSERT INTO dyu_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Falimuso ka Matigi Ala ta mɛlɛkɛ ye minkɛ, a lara dugu ma ni Balamu ye. Balamu dimina kosɛbɛ; a ka falimuso bugɔ ni a ta bere ye. ");
INSERT INTO dyu_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Matigi Ala k’a to falimuso kumana; a ko Balamu ma ko: «O tuma ne ka mun le kɛ ele ra, fɔ i ka ne bugɔ fɔ siɲaga saba ka ban?» ");
INSERT INTO dyu_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balamu ka falimuso jaabi ko: «I bɛ ne kɛra i toronkɛɲɔgɔn le ye, o kosɔn ne ka i bugɔ. Ni muru yɛrɛ tun bɛ ne boro yan, ne tun bɛ i faga sisan.» ");
INSERT INTO dyu_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Falimuso k’a fɔ Balamu ye ko: «Ne le tɛ i ta fali ye wa, i bɛ yɛlɛn min kan tuma bɛɛ fɔ ka na se bi ma? Yala ne derira ka nin ɲɔgɔn kɛ ele ra wa?» Balamu ko: «Ɔn-ɔn.» ");
INSERT INTO dyu_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Matigi Ala ka Balamu ɲa yɛlɛ; Balamu ka Matigi Ala ta mɛlɛkɛ lɔnin ye sira cɛ ma, kɛrɛkɛmuru b’a boro, a bɔnin bɛ a la ra. Balamu k’a kinbiri gban k’a ɲa biri dugu ma. ");
INSERT INTO dyu_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Matigi Ala ta mɛlɛkɛ k’a fɔ a ye ko: «Mun kosɔn i ka i ta falimuso bugɔ fɔ siɲaga saba ka ban? A flɛ, ne nana lɔ i ɲa ka i ɲakɔrɔmatigɛ le; sabu ne k’a ye ko i ka sira min ta, o sira bɛ taga ni i ye i halakiyɔrɔ le ra. ");
INSERT INTO dyu_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","I ta falimuso ka ne ye, ka sira bla ne ye fɔ siɲaga saba. Ni a tun ma bɔ ne ɲa fɛ, sisan b’a sɔrɔ ko ne tun ka ele faga ka ban, ka falimuso to yi.» ");
INSERT INTO dyu_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balamu ka Matigi Ala ta mɛlɛkɛ jaabi ko: «Ne ka jurumun kɛ, sabu ne tun m’a lɔn ko i lɔnin bɛ sira ra ne ɲa. Ayiwa, ni nin tagama ma bɛn i ma, ne bɛ sekɔ ka taga ne ta so.» ");
INSERT INTO dyu_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Matigi Ala ta mɛlɛkɛ k’a fɔ Balamu ye ko: «Taga ni nin mɔgɔw ye. Nka ne bɛna taga kuma minw don i da ra, i bɛna o le fɔ.» Balamu tagara ni Mohabu jamana kuntigiw ye. ");
INSERT INTO dyu_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki nana a mɛn ko Balamu bɛ nana minkɛ, Mohabukaw ta dugu min bɛ Arinɔn kɔ kɛrɛ fɛ, a ta jamana dan yɛrɛ ra, a bɔra ka taga Balamu kunbɛn fɔ o yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki k’a fɔ Balamu ye ko: «Yala ne tun ma kɔn ka mɔgɔ dɔw ci ka taga i wele wa? Mun na i ma na ne fɛ o wagati ra? O tuma i b’a miiri ko ne tɛ se ka i bonya le wa?» ");
INSERT INTO dyu_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balamu ka Balaki jaabi ko: «Sisan ne kɔni nana i fɛ, nka ne tɛna se ka foyi fɔ ne yɛrɛ ma dɛ! Ni Ala ka kuma min don ne da ra, ne bɛ o dɔrɔn le fɔ.» ");
INSERT INTO dyu_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaki tagara ni Balamu ye, ka taga se Kiriyati Husɔti. ");
INSERT INTO dyu_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki ka misiw ni sagaw kɛ saraka ye. A ka o sogo dɔ ci Balamu ma, ani kuntigi minw tun bɛ ni a ye. ");
INSERT INTO dyu_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","O dugusagbɛ sɔgɔma, Balaki nana Balamu ta ka yɛlɛn ni a ye Bamɔti Baali kuruyɔrɔw ra; Balamu tora o yɔrɔ ra ka Izirayɛli jama fan kelen ye. ");
INSERT INTO dyu_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balamu k’a fɔ Balaki ye ko: «Sarakabɔnan wolonfla lalaga ne ye yan, ka misitoran wolonfla ni sagajigi wolonfla fana labɛn ne ye.» ");
INSERT INTO dyu_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balamu ka min fɔ, Balaki ka o kɛ. Balaki ni Balamu ka misitoran kelen ni sagajigi kelen kɛ saraka ye sarakabɔnan bɛɛ kelen kelen kan. ");
INSERT INTO dyu_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balamu k’a fɔ Balaki ye ko: «Lɔ i ta sarakaw kɔrɔ yan, ne bɛna taga ɲa fɛ dɔɔnin. A bɛ se ka kɛ ko Matigi Ala bɛna a yɛrɛ yira ne ra; o ra ni a ka min yira ne ra, ne bɛna o fɔ i ye.» Balamu tagara lɔ tintin dɔ kan. ");
INSERT INTO dyu_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ala nana a yɛrɛ yira Balamu na. Balamu k’a fɔ a ye ko: «Ne ka sarakabɔnan wolonfla lalaga, ka misitoran kelen ni sagajigi kelen kɛ saraka ye sarakabɔnan bɛɛ kelen kelen kan.» ");
INSERT INTO dyu_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Matigi Ala ka kuma don Balamu da ra, k’a fɔ a ye ko: «Sekɔ ka taga Balaki fɛ; ne ka kuma min don i da ra, i bɛ taga o fɔ a ye.» ");
INSERT INTO dyu_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balamu sekɔra ka taga Balaki fɛ; a tagara Balaki lɔnin sɔrɔ a ta saraka kɔrɔ, ale ni Mohabu kuntigiw bɛɛ. ");
INSERT INTO dyu_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balamu k’a ta cirayakuma fɔ; a ko: «Balaki le ka ne lana ka bɔ Aramu, Mohabu masacɛ le ka ne lana ka bɔ terebɔyanfan kuruyɔrɔw ra. A ko: ‹Na Yakuba ta mɔgɔw danga ne ye, na kumajuguw fɔ Izirayɛlimɔgɔw ma.› ");
INSERT INTO dyu_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ayiwa, Ala ma mɔgɔ min danga, ne bɛ se ka o danga cogo di? Matigi Ala ma kumajugu fɔ mɔgɔ min ma, ne bɛ se ka kumajugu fɔ o tigi ma cogo di? ");
INSERT INTO dyu_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ne bɛ o yera faraw kunna, ne ɲa bɛ o ra kongoriw kunna. Siya dɔ lo, min siginin bɛ a danna; o tɛ o yɛrɛ jate ko o ni siya tɔw ye kelen ye. ");
INSERT INTO dyu_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Jɔn le bɛ se ka Yakuba ta mɔgɔw jate, minw ka ca i ko kɛnkɛnmugu? Jɔn le bɛ se ka hali o tarancɛ ta tarancɛ jate? Ala y’a to ne ye sa nin mɔgɔɲumanw sacogo ra, ka ne labancogo ni o labancogo kɛ kelen ye.» ");
INSERT INTO dyu_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki k’a fɔ Balamu ye ko: «Ele ka mun le kɛ ne ra tan? Ne ka ele wele ko i ye na ne juguw danga, ele nana kɛ dugawu camanba le kɛ ye o ye!» ");
INSERT INTO dyu_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balamu k’a jaabi ko: «O tuma ni Matigi Ala ka kuma min don ne da ra, ne man kan ka jija ka o le fɔ wa?» ");
INSERT INTO dyu_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaki k’a fɔ Balamu ye ko: «Na, an ye taga yɔrɔ wɛrɛ, i bɛna to yɔrɔ min na ka nin mɔgɔw ye. I bɛna dɔw ye, nka i tɛna o bɛɛ ye. I bɛ to o yɔrɔ ra ka o danga ne ye.» ");
INSERT INTO dyu_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","A ka Balamu wele ka taga ni a ye Sofimu yɔrɔ ra, Pisiga kuru kunna. A ka sarakabɔnan wolonfla lalaga o yɔrɔ ra tuun, ka misitoran kelen ni sagajigi kelen kɛ saraka ye o sarakabɔnanw bɛɛ kelen kelen kan. ");
INSERT INTO dyu_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","O kɔ, Balamu k’a fɔ Balaki ye tuun ko: «Lɔ i ta sarakaw kɔrɔ yan, ne bɛ taga Ala ta kuma lamɛn.» ");
INSERT INTO dyu_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Matigi Ala nana a yɛrɛ yira Balamu na. A ka kuma don Balamu da ra; a k’a fɔ a ye ko: «Sekɔ Balaki fɛ, ne ka kuma min don i da ra, i ye taga o fɔ a ye.» ");
INSERT INTO dyu_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balamu sekɔra ka taga Balaki fɛ; a tagara Balaki lɔnin sɔrɔ a ta saraka kɔrɔ, ani Mohabu kuntigiw. Balaki k’a ɲininka ko: «Matigi Ala ka mun le fɔ?» ");
INSERT INTO dyu_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balamu k’a ta cirayakuma fɔ; a ko: «Balaki, wuri ka ne lamɛn! E, Sipɔri dencɛ, i toro malɔ ne ye! ");
INSERT INTO dyu_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ala tɛ i ko mɔgɔw, k’a fɔ ko a bɛ faninya tigɛ. A tɛ i ko adamaden, k’a fɔ ko a bɛ ko kɛ, ka nimisa. Yala Ala bɛ ko dɔ fɔ, ni a tɛ a kɛ wa? A bɛ ko layiri ta, ni a tɛ a dafa wa? ");
INSERT INTO dyu_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","A flɛ, Ala ko ne ye dugawu le kɛ o ye. A ka dugawu mina, ne fana tɛ se k’a yɛlɛma. ");
INSERT INTO dyu_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ala ma terenbariya si ye Yakuba ta mɔgɔw ra; a ma kojugu si kɔrɔsi Izirayɛlimɔgɔw ra. Matigi Ala, o ta Ala bɛ ni o ye. O ɲagaritɔ b’a fo ni masaya fori ye. ");
INSERT INTO dyu_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ala le ka o labɔ Misiran. A bɛ baraka don o ra i ko sigin ta baraka. ");
INSERT INTO dyu_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Subagaya tɛ se ka foyi kɛ Yakuba ta mɔgɔw ra; lagbɛri tɛ se ka foyi kɛ Izirayɛlimɔgɔw ra. Ni wagati latigɛnin sera, Ala bɛ min kɛ, o bɛ fɔ Yakuba ta mɔgɔw ye, Izirayɛlimɔgɔw. ");
INSERT INTO dyu_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Siya dɔ lo, min bɛ wuri i ko jaraba, ka wuri ka pan i ko jaracɛ. A tɛ la, fɔ a ye a ta sogo minaninw domu, fɔ a ye a ta sogo faganinw jori min.» ");
INSERT INTO dyu_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaki k’a fɔ Balamu ye ko: «Ni i tɛ se ka o danga, o to yi; nka i fana kana dugawu kɛ o ye!» ");
INSERT INTO dyu_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balamu ka Balaki jaabi ko: «Ne m’a fɔ i ye wa, ko: ‹Ni Matigi Ala ka fɛn o fɛn fɔ ne ye, ko ne bɛ o le kɛ?› » ");
INSERT INTO dyu_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki ko Balamu ma ko: «Na, ne bɛ taga ni i ye yɔrɔ wɛrɛ tuun. A bɛ se ka kɛ ko Ala bɛna sɔn k’a to i ye nin mɔgɔw danga ne ye o yɔrɔ ra.» ");
INSERT INTO dyu_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaki tagara ni Balamu ye Pehɔri kuru kunna, yɔrɔ min ɲasinna kongokolon ma. ");
INSERT INTO dyu_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balamu k’a fɔ Balaki ye ko: «Sarakabɔnan wolonfla lalaga ne ye yan, ka misitoran wolonfla ni sagajigi wolonfla fana labɛn ne ye.» ");
INSERT INTO dyu_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balamu ka min fɔ, Balaki ka o kɛ. O kɔ, a ka misitoran kelen ni sagajigi kelen kɛ saraka ye sarakabɔnan bɛɛ kelen kelen kan. ");
INSERT INTO dyu_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ayiwa, Balamu k’a ye ko Matigi Ala b’a fɛ ka baraka le don Izirayɛlimɔgɔw ra. O ra, a m’a kɛ i n’a fɔ siɲaga tɔw ta, ko a bɛ taga kuma dɔ ɲini ka bɔ Matigi Ala fɛ. A k’a ɲasin kongokolon ma. ");
INSERT INTO dyu_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","A k’a ɲa kɔrɔta ka Izirayɛlimɔgɔw ye, gba bɛɛ siginin bɛ a ta yɔrɔ ra. O wagati ra Ala Nin nana Balamu kan. ");
INSERT INTO dyu_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Balamu k’a ta cirayakuma fɔ; a ko: «Nin ye ne Balamu, Behɔri dencɛ kan ye. Cɛ yerikɛbaga kan lo; ");
INSERT INTO dyu_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Cɛ min bɛ Ala kumakan mɛn, o kan lo, cɛ min bɛ Sebɛɛtigi Ala ta fɛn yiraninw ye, cɛ min bɛ a ɲa biri dugu ma Ala ɲa kɔrɔ, ni Ala bɛ a ɲaw yɛlɛ. ");
INSERT INTO dyu_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","«E, Yakuba ta mɔgɔw, aw sigiyɔrɔ cɛ ka ɲi dɛ! E, Izirayɛlimɔgɔw, aw ta sow cɛ ka ɲi dɛ! ");
INSERT INTO dyu_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","O janjannin flɛ ka taga i ko kɔji, i ko nankɔ min bɛ bada ra, i ko Matigi Ala yɛrɛ ka alowɛsisun minw turu, i ko sɛdirisun minw bɛ ji da ra. ");
INSERT INTO dyu_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","O ta jibiminan fanin lo ji ra fɔ ka bɔn, ji caman bɛ woyo o ta simanw kɔrɔ, ka o falen. O ta masacɛ ka bon ka tɛmɛ masacɛ Agagi kan, o ta masaya bɛna to ka bonya ka taga a fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ala le ka o labɔ Misiran; a bɛ o ta baraka kɛ i ko sigin ta baraka. Siya minw bɛ wuri o kama, o bɛ olugu domu; o bɛ o kolow bɛɛ karikari, ka o sɔgɔ ni o ta biɲɛw ye. ");
INSERT INTO dyu_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","O kɔ, o bɛ o kinbiri turu, ka la i ko jara, i ko jaraba; jɔn le bɛ sɔn ka o lawuri? Izirayɛli, ni mɔgɔ min ka dugawu kɛ aw ye, Ala ye baraka don o tigi ra; ni mɔgɔ min ka aw danga, Ala ye o tigi danga.» ");
INSERT INTO dyu_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaki dimina Balamu kɔrɔ kosɛbɛ. A k’a boro fla gbasi ɲɔgɔn na, k’a fɔ Balamu ye ko: «Ne ka i wele ko i ye na ne juguw danga le; nka i ka dugawu caman le kɛ o ye fɔ siɲaga saba. ");
INSERT INTO dyu_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ni o lo, tɛmɛ ka bɔ yan sisan! Taga i ta so! Ne tun ko ne bɛna i bonya kosɛbɛ, nka Matigi Ala ma sɔn k’a to i ye o bonya sɔrɔ.» ");
INSERT INTO dyu_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balamu ka Balaki jaabi ko: «O tuma i ka ciraden minw ci ne fɛ, yala ne tun ma nin kuma fɔ olugu ye wa? ");
INSERT INTO dyu_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Ne ko: ‹Hali ni Balaki k’a ta masabon fa warigbɛ ni sanin le ra k’a di ne ma, ko ne tɛna foyi kɛ ne yɛrɛ ma, koɲuman, walama kojugu, ni min tɛ bɛn ni Matigi Ala ta kuma ye; ko ni Matigi Ala ka min fɔ ne ye, ne fana bɛ o le fɔ!› ");
INSERT INTO dyu_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ayiwa, ne bɛ taga ne ta mɔgɔw fɛ; nka nin mɔgɔw bɛna min kɛ i ta mɔgɔw ra wagati nata ra, na ne bɛ o fɔ i ye.» ");
INSERT INTO dyu_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","O tuma, Balamu ka cirayakuma dɔ wɛrɛ fɔ; a ko: «Nin ye ne Balamu, Behɔri dencɛ kan ye. Cɛ yerikɛbaga kan lo; ");
INSERT INTO dyu_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Cɛ min bɛ Ala kumakan mɛn, o kan lo, cɛ min bɛ Ala kɔrɔtaninba ta kolatigɛninw lɔn, cɛ min bɛ Sebɛɛtigi Ala ta fɛn yiraninw ye, cɛ min bɛ a ɲa biri dugu ma Ala ɲa kɔrɔ, ni Ala bɛ a ɲaw yɛlɛ. ");
INSERT INTO dyu_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","«Ne ɲa b’a ra, nka sisan ko tɛ; ne b’a flɛra, nka a yɔrɔ belen ka jan ne ra. Lolo dɔ bɛ bɔra Yakuba ta mɔgɔw cɛ ra; masacɛbere dɔ bɛ wurira Izirayɛli jamana ra. A bɛ Mohabukaw bugɔ o kun na, ka Sɛti ta mɔgɔw bɛɛ bugɔ ka o ben. ");
INSERT INTO dyu_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","A b’a fanga sigi Edɔmukaw kan, a b’a fanga sigi Seyirikaw kan, a juguw. Izirayɛlimɔgɔw baraka bɛna bonya. ");
INSERT INTO dyu_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Kuntigi min bɛna bɔ Yakuba ta mɔgɔw ra, o le bɛna sigi masaya ra. Minw bɛ bɔsi ka bori ka bɔ duguw kɔnɔ, a bɛ olugu halaki.» ");
INSERT INTO dyu_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ayiwa, Balamu ka Amalɛkikaw ta yɔrɔ ye minkɛ, a ka cirayakuma dɔ wɛrɛ fɔ tuun, ko: «Amalɛkikaw ta siya le tun ka bon ni siyaw bɛɛ ye; nka a laban, o bɛna halaki.» ");
INSERT INTO dyu_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Balamu ka Kenikaw ta yɔrɔ ye minkɛ, a ka cirayakuma dɔ wɛrɛ fɔ tuun, ko: «Kenikaw, aw ta sigiyɔrɔ dogora ka ɲa; a bɛ i ko ɲaga min dogonin bɛ farakuru kan. ");
INSERT INTO dyu_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Nka Kenikaw bɛna halaki, tuma min na Asirikaw bɛna o mina ka taga ni o ye.» ");
INSERT INTO dyu_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balamu ka cirayakuma dɔ wɛrɛ fɔ tuun, ko: «E, Ala bɛna nin kow kɛ wagati min na, jɔn le bɛna to si ra fɔ ka taga se o wagati ma? ");
INSERT INTO dyu_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kurunbatigi dɔw bɛna na ka bɔ Kitimu. O bɛna o ta fanga sigi Asirikaw kan, k’a sigi Heburuw kan; nka olugu yɛrɛ bɛna halaki.» ");
INSERT INTO dyu_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ayiwa, o kɔ, Balamu wurira ka taga a ta so. Balaki fana tagara a ta yɔrɔ ra. ");
INSERT INTO dyu_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ka Izirayɛlimɔgɔw siginin to Sitimu, Izirayɛli cɛ dɔw ka jatɔya kɛ ni Mohabukaw denmusow ye. ");
INSERT INTO dyu_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","O musow ka Izirayɛlimɔgɔw nɛgɛ ka o wele ka na o ta batofɛnw sɔn. Izirayɛlimɔgɔw ka o sarakaw domu, ka o kinbiri gban o ta batofɛnw kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","A kɛra ten, Izirayɛlimɔgɔw ka Pehɔri ta jo sɔn, min ye Baali* ye. Matigi Ala dimina Izirayɛlimɔgɔw kɔrɔ kosɛbɛ. ");
INSERT INTO dyu_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Matigi Ala k’a fɔ Musa ye ko: «Izirayɛli kuntigiw bɛɛ mina ka o bɛɛ kanw don juru ra Matigi Ala ɲa kɔrɔ, ka o ɲasin tere ma, janko Matigi Ala ta dimiba ye mabɔ Izirayɛlimɔgɔw ra.» ");
INSERT INTO dyu_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musa k’a fɔ Izirayɛli kititigɛbagaw ye ko: «Aw ta mɔgɔ minw ka Pehɔri ta jo sɔn, min ye Baali ye, aw ye o mɔgɔw faga.» ");
INSERT INTO dyu_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ayiwa, ka Izirayɛlimɔgɔw lajɛnnin to Ɲɔgɔnkunbɛn fanibon* donda ra, o bɛ kasira, Izirayɛlikacɛ dɔ nana a ta somɔgɔw fɛ ni Madiyanka sunguru dɔ ye, Musa ni jama bɛɛ ɲa na. ");
INSERT INTO dyu_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Sarakalasebaga Haruna dencɛ Elehazari, ale dencɛ Finehasi ka o ye minkɛ, a wurira ka bɔ jama cɛ ra, ka taman dɔ ta, ");
INSERT INTO dyu_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ka tugu Izirayɛlikacɛ kɔ a ta fanibon kɔnɔ. A tagara taman turu o fla bɛɛ ra; a ka Izirayɛlikacɛ sɔgɔ, ka muso fana sɔgɔ a kɔnɔbara ra. A kɛra ten, cɛnri min tun donna Izirayɛlimɔgɔw cɛ ra, o lalɔra. ");
INSERT INTO dyu_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Mɔgɔ waga mugan ni naani (24 000) le tun fagara. ");
INSERT INTO dyu_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Sarakalasebaga Haruna dencɛ Elehazari, ale dencɛ Finehasi le ka ne ta dimiba mabɔ Izirayɛlimɔgɔw ra; sabu Izirayɛlimɔgɔw ka ko min kɛ, o dimi tun bɛ ne ra cogo min na, a dimi fana kɛra ale ra ten. O le kosɔn ne ma dimi tuun ka Izirayɛlimɔgɔw faga ka ban. ");
INSERT INTO dyu_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","O kosɔn, a fɔ Elehazari ye ko ne bɛ jɛnɲɔgɔnya don ni a ye, ka hɛra kɛ a ye. ");
INSERT INTO dyu_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","O jɛnɲɔgɔnya sababu ra, sarakalasebagaya bɛna kɛ ale ni a ta duruja ta le ye tuma bɛɛ, ani wagati bɛɛ; sabu a dimina ka nin ko kɛ a ta Ala ta kanuya kosɔn, ka Izirayɛlimɔgɔw ta jurumun kafari o ye.» ");
INSERT INTO dyu_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Izirayɛlikacɛ min fagara ni Madiyanka muso ye, o tɔgɔ tun ye ko Zimiri; a facɛ tɔgɔ tun ye ko Salu. Simeyɔn ta mɔgɔw ta gbatigi dɔ tun lo. ");
INSERT INTO dyu_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Madiyanka muso min fagara, ale tɔgɔ tun ye ko Kosibi; a facɛ tɔgɔ tun ye ko Suri. Madiyankaw ta mɔgɔw ta gbatigi dɔ tun lo. ");
INSERT INTO dyu_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Matigi Ala kumana Musa fɛ tuun, ko: ");
INSERT INTO dyu_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Aw ye Madiyankaw mina i ko aw juguw, ka o bɛɛ faga; ");
INSERT INTO dyu_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","sabu o ka aw mina i ko o juguw. O ka aw janfa ka aw lafiri Pehɔri ta jo ta ko ra, ani o Madiyanka muso Kosibi ta ko, o min tun ye o ta kuntigi dɔ ta denmuso ye. Halakiri sera aw ma wagati min na Pehɔri ta jo Baali kosɔn, Finehasi ka o muso le faga.» ");
INSERT INTO dyu_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ayiwa, o banajugu tɛmɛnin kɔ, Matigi Ala k’a fɔ Musa ni sarakalasebaga Haruna dencɛ Elehazari ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Aw ye Izirayɛlimɔgɔw bɛɛ jate, o bɛɛ ni o ta somɔgɔw; cɛ minw ka san mugan sɔrɔ, ani minw tɛmɛna o kan, ni o bɛ se ka taga kɛrɛ ra, aw ye olugu bɛɛ jate.» ");
INSERT INTO dyu_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa ni sarakalasebaga Elehazari ka o kuma fɔ Izirayɛlimɔgɔw ye Mohabu jamana kɛnɛgbɛw yɔrɔ ra, Zuridɛn ba kɛrɛ fɛ, Zeriko dugu ɲa fɛ. O k’a fɔ o ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Cɛ minw ka san mugan sɔrɔ, ani minw tɛmɛna o kan, an bɛna olugu jate i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na.» Izirayɛlimɔgɔ minw tun bɔra Misiran jamana ra, olugu ta durujaw le ye nin ye: ");
INSERT INTO dyu_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ayiwa, Rubɛn le tun ye Izirayɛli dencɛ fɔlɔ ye; Rubɛn ta durujaw ye nin ye: Hanɔkikaw buruju bɔra Henɔki le ra. Palukaw buruju bɔra Palu le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hɛsirɔnkaw buruju bɔra Hɛsirɔn le ra. Karimikaw buruju bɔra Karimi le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Rubɛn ta durujaw bɔra o gbaw le ra. O minw jatera, o kɛra cɛ waga binaani ni saba ni cɛ kɛmɛ wolonfla ni cɛ bisaba (43 730). ");
INSERT INTO dyu_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ayiwa, Palu dencɛ le tun ye Eliyabu ye. ");
INSERT INTO dyu_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliyabu dencɛw tun ye Nemuwɛli ni Datan ni Abiramu ye. O Datan tɔgɔ ni o Abiramu tɔgɔ le tun kɛra Izirayɛli jama ɲamɔgɔ dɔw ye. Olugu le tun farara Kore ta mɔgɔw kan, ka wuri Musa ni Haruna kama, wagati min Izirayɛlimɔgɔw tun murutira Matigi Ala ma. ");
INSERT INTO dyu_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Dugukolo dayɛlɛra ka olugu ni Kore bɛɛ kunu. Kore nɔfɛmɔgɔ minw tun lajɛnna, olugu sara o lon na; tasuma ka mɔgɔ kɛmɛ ni bilooru fana jɛni. Ala tun ka o kɛ ka kankari le la Izirayɛlimɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","O bɛɛ n’a ta, Kore yɛrɛ dencɛw tun ma faga. ");
INSERT INTO dyu_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeyɔn ta durujaw ye nin ye, o ni o ta somɔgɔw: Nemuwɛlikaw buruju bɔra Nemuwɛli le ra. Yaminikaw buruju bɔra Yamini le ra. Yakinikaw buruju bɔra Yakini le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerakikaw buruju bɔra Zeraki le ra. Sawuli ta mɔgɔw buruju bɔra Sawuli le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simeyɔn ta durujaw le ye olugu ye. O kɛra cɛ waga mugan ni fla ni cɛ kɛmɛ fla (22 200). ");
INSERT INTO dyu_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gadi ta durujaw ye nin ye, o ni o ta somɔgɔw: Sefɔnkaw buruju bɔra Sefɔn le ra. Hagikaw buruju bɔra Hagi le ra. Sunikaw buruju bɔra Suni le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozinikaw buruju bɔra Ozini le ra. Ɛrikaw buruju bɔra Ɛri le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arɔdikaw buruju bɔra Arɔdi le ra. Arɛlikaw buruju bɔra Arɛli le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Gadi ta durujaw le ye olugu ye. O minw jatera, o kɛra cɛ waga binaani ni cɛ kɛmɛ looru (40 500). ");
INSERT INTO dyu_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Zuda dencɛ dɔw tun ye Ɛri ni Onan ye, nka olugu cɛ fla sara Kanaana jamana ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Zuda ta durujaw ye nin ye, o ni o ta somɔgɔw: Selakaw buruju bɔra Sela le ra. Perɛsikaw buruju bɔra Perɛsi le ra. Zerakaw buruju bɔra Zera le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Perɛsi ta durujaw ye nin ye: Hɛsirɔnkaw buruju bɔra Hɛsirɔn le ra. Hamulikaw buruju bɔra Hamuli le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Zuda ta durujaw le ye olugu ye. O minw jatera, o kɛra cɛ waga biwolonfla ni wɔɔrɔ, ani cɛ kɛmɛ looru (76 500). ");
INSERT INTO dyu_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isakari ta durujaw ye nin ye, o ni o ta somɔgɔw: Tolakaw buruju bɔra Tola le ra. Puvakaw buruju bɔra Puva le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasubukaw buruju bɔra Yasubu le ra. Simirɔnkaw buruju bɔra Simirɔn le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Isakari ta durujaw le ye olugu ye. O minw jatera o kɛra cɛ waga biwɔɔrɔ ni naani ni cɛ kɛmɛ saba (64 300). ");
INSERT INTO dyu_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zabulɔn ta durujaw ye nin ye, o ni o ta somɔgɔw: Serɛdikaw buruju bɔra a dencɛ Serɛdi le ra. Elɔnkaw buruju bɔra Elɔn le ra. Yalɛlikaw buruju bɔra Yalɛli le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Zabulɔn ta durujaw le ye olugu ye. O minw jatera, o kɛra cɛ waga biwɔɔrɔ, ani cɛ kɛmɛ looru (60 500). ");
INSERT INTO dyu_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yusufu dencɛw tun kɛra Manase ni Efirayimu ye. ");
INSERT INTO dyu_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manase ta duruja ye nin ye: Makirikaw buruju bɔra Makiri le ra. Galadikaw buruju bɔra Makiri dencɛ Galadi le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Galadi ta durujaw ye nin ye: Yezɛrikaw buruju bɔra Yezɛri le ra. Helɛkikaw buruju bɔra Helɛki le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asiriyɛlikaw buruju bɔra Asiriyɛli le ra. Sikɛmukaw buruju bɔra Sikɛmu le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semidakaw buruju bɔra Semida le ra. Hefɛrikaw buruju bɔra Hefɛri le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hefɛri dencɛ Selofadi, ale tun ma dencɛ sɔrɔ. A tun ka denmusow le sɔrɔ. A denmusow tɔgɔw tun ye ko Mala, ani Nowa, ani Hogila, ani Milika, ani Tirisa. ");
INSERT INTO dyu_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Manase ta durujaw le ye olugu ye. O minw jatera, o kɛra cɛ waga bilooru ni fla ni cɛ kɛmɛ wolonfla (52 700). ");
INSERT INTO dyu_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efirayimu ta durujaw ye nin ye, o ni o ta somɔgɔw: Sutelakaw buruju bɔra Sutela le ra. Bekɛrikaw buruju bɔra Bekɛri le ra. Tahankaw buruju bɔra Tahan le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutela ta durujaw kɛra Erankaw ye; olugu bɔra Eran le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Efirayimu ta durujaw le ye olugu ye. O minw jatera, o kɛra cɛ waga bisaba ni fla ani cɛ kɛmɛ looru (32 500). Olugu bɛɛ le kɛra Yusufu ta durujaw ye, o ni o ta somɔgɔw. ");
INSERT INTO dyu_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Boniyaminu ta durujaw ye nin ye, o ni o ta somɔgɔw: Belakaw buruju bɔra Bela le ra. Asibɛlikaw buruju bɔra Asibɛli le ra. Ahiramukaw buruju bɔra Ahiramu le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sufamukaw buruju bɔra Sufamu le ra. Hufamukaw buruju bɔra Hufamu le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Aridikaw buruju bɔra Bela dencɛ Aridi le ra. Nahamankaw buruju bɔra Bela dencɛ Nahaman le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Boniyaminu ta durujaw le ye olugu ye, o ni o ta somɔgɔw. O minw jatera, o kɛra cɛ waga binaani ni looru ni cɛ kɛmɛ wɔɔrɔ (45 600). ");
INSERT INTO dyu_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dan ta durujaw ye nin ye, o ni o ta somɔgɔw: Suhamukaw buruju bɔra Suhamu le ra. Olugu le kɛra Dan ta durujaw ye, o ni o ta somɔgɔw. ");
INSERT INTO dyu_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Minw jatera Suhamukaw ta gbaw ra, o bɛɛ lajɛnnin kɛra cɛ waga biwɔɔrɔ ni naani ani cɛ kɛmɛ naani (64 400). ");
INSERT INTO dyu_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asɛri ta durujaw ye nin ye, o ni o ta somɔgɔw: Iminakaw buruju bɔra Imina le ra. Isivikaw buruju bɔra Isivi le ra. Beriyakaw buruju bɔra Beriya le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Hebɛrikaw buruju bɔra Hebɛri le ra; o tun ye Beriya ta mɔgɔ dɔ ye. Malikiyɛlikaw buruju bɔra Malikiyɛli le ra; o tun ye Beriya ta mɔgɔ dɔ fana ye. ");
INSERT INTO dyu_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asɛri denmuso tɔgɔ tun ye ko Sera. ");
INSERT INTO dyu_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Asɛri ta durujaw le ye olugu ye. O minw jatera, o kɛra cɛ waga bilooru ni saba ni cɛ kɛmɛ naani (53 400). ");
INSERT INTO dyu_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nɛfitali ta durujaw ye nin ye, o ni o ta somɔgɔw: Yasɛlikaw buruju bɔra Yasɛli le ra. Gunikaw buruju bɔra Guni le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yesɛrikaw buruju bɔra Yesɛri le ra. Silɛmukaw buruju bɔra Silɛmu le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Nɛfitali ta durujaw le ye olugu ye, o ni o ta somɔgɔw. O minw jatera, o kɛra cɛ waga binaani ni looru ni cɛ kɛmɛ naani (45 400). ");
INSERT INTO dyu_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Izirayɛlimɔgɔ minw jatera, olugu le ye nin ye. O bɛɛ kɛra cɛ waga kɛmɛ wɔɔrɔ ni kelen ani cɛ kɛmɛ wolonfla ni cɛ bisaba (601 730). ");
INSERT INTO dyu_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Matigi Ala kumana Musa fɛ tuun, k’a fɔ a ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«I bɛna jamana taran mɔgɔw cɛ, k’a kɛ o sigiyɔrɔw ye, ka kaɲa ni o ta mɔgɔw hakɛya le ye. ");
INSERT INTO dyu_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Minw ka ca, i bɛ olugu ta yɔrɔ bonya; minw ka dɔgɔ, i bɛ olugu ta yɔrɔ dɔgɔya. Bɛɛ ta yɔrɔ bɛ di a ma, ka kaɲa ni a ta mɔgɔw hakɛya le ye. ");
INSERT INTO dyu_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Nka ni ne ka yɔrɔ min yira, ko a ye di gba min ma, i jija k’a to o yɔrɔ ye di o gba ma. Jamana bɛna taran o cogo le ra, ka kaɲa ni o bɛmaw ta gbaw tɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ni ne ka yɔrɔ min yira ko a ye di gba min ma, o bɛ di o gba ma. Minw ka ca, olugu ta bɛ di o ma; minw ka dɔgɔ, olugu fana ta bɛ di o ma.» ");
INSERT INTO dyu_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ayiwa, Levi ta duruja minw tun jatera, o ni o ta somɔgɔw, olugu ye nin ye: Gɛrisɔnkaw buruju bɔra Gɛrisɔn le ra. Kehatikaw buruju bɔra Kehati le ra. Merarikaw buruju bɔra Merari le ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Levi ta gba dɔw fana ye nin ye: Libinikaw ta gba, ani Heburɔnkaw ta gba, ani Malikaw ta gba, ani Musikaw ta gba, ani Korekaw ta gba. Kehati le ka Amuramu woro. ");
INSERT INTO dyu_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amuramu ta muso tɔgɔ tun ye ko Yokebɛdi. Ale tun ye Levi denmuso ye; a tun worora Misiran le. Yokebɛdi ka Haruna ni Musa ni o balemamuso Mariyamu woro Amuramu fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Haruna ka dencɛ minw sɔrɔ, o kɛra Nadabu ni Abihu ni Elehazari ni Itamari ye. ");
INSERT INTO dyu_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nka Nadabu ni Abihu sara, sabu lon dɔ, o tun ka wusunan don Matigi Ala ɲa kɔrɔ ni tasuma dɔ ye, min tun bɔra yɔrɔ wɛrɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ayiwa, Levi ta mɔgɔ minw jatera, cɛden minw ka karo kelen sɔrɔ, ani minw tɛmɛna o kan, o kɛra cɛ waga mugan ni saba (23 000). Olugu ma jate ni Izirayɛlimɔgɔ tɔw ye, sabu olugu tun man kan ka yɔrɔ dɔ sɔrɔ min bɛ kɛ o yɛrɛ ta yɔrɔ ye, i n’a fɔ Izirayɛlimɔgɔ tɔw. ");
INSERT INTO dyu_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ayiwa, Musa ni sarakalasebaga Elehazari ka Izirayɛlimɔgɔ minw jate Mohabu jamana kɛnɛgbɛw yɔrɔ ra, Zuridɛn ba kɛrɛ fɛ, Zeriko dugu ɲa fɛ, olugu le kɛra nin ye. ");
INSERT INTO dyu_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Musa ni sarakalasebaga Haruna tun ka Izirayɛlimɔgɔ minw jate fɔlɔfɔlɔ, Sinayi kongokolon kɔnɔ, olugu si tun tɛ nin mɔgɔw ra; ");
INSERT INTO dyu_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","sabu Matigi Ala tun k’a fɔ ko olugu bɛɛ le bɛna sa kongokolon kɔnɔ. O kosɔn o si ma to, fɔ Yefune dencɛ Kalɛbu, ani Nuni dencɛ Yosuwe. ");
INSERT INTO dyu_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Yusufu dencɛ Manase ta gbamɔgɔ dɔ tun bɛ yi, o tɔgɔ tun ye ko Selofadi. Selofadi facɛ le tun ye Hefɛri ye, Hefɛri facɛ tun ye Galadi ye, Galadi facɛ tun ye Makiri ye, Makiri facɛ tun ye Manase ye. Selofadi denmusow tɔgɔw le tun ye ko Mala, ani Nowa, ani Hogila, ani Milika, ani Tirisa. ");
INSERT INTO dyu_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Lon dɔ, o denmusow tagara Musa ni sarakalasebaga Elehazari fɛ, ani Izirayɛli jama bɛɛ lajɛnnin kuntigiw fɛ, Ɲɔgɔnkunbɛn fanibon* donda ra, ka taga a fɔ o ye ko: ");
INSERT INTO dyu_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Anw facɛ sara kongokolon kɔnɔ. Nka Kore ni a ta nɔfɛjama min tun murutira Matigi Ala ma, a tun tɛ ni o mɔgɔw ye. A sara a yɛrɛ ta hakɛw le kosɔn, k’a sɔrɔ dencɛ tun t’a fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","An facɛ ma dencɛ sɔrɔ minkɛ, yala a tɔgɔ ka kan ka tunu ka bɔ o ta gba ra o kosɔn wa? Anw b’a fɛ aw ye yɔrɔ dɔ di anw fana ma i n’a fɔ an facɛ balemacɛw.» ");
INSERT INTO dyu_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Ayiwa, Musa tagara Matigi Ala ɲininka o ko ra. ");
INSERT INTO dyu_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Matigi Ala ka Musa jaabi ko: ");
INSERT INTO dyu_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Jo bɛ Selofadi denmusow fɛ. Yɔrɔ dɔ di o ma, i n’a fɔ o facɛ balemacɛw, ka o kɛ o sigiyɔrɔ ye. O facɛ ta cɛn bɛna di olugu le ma. ");
INSERT INTO dyu_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","«Kuma Izirayɛlimɔgɔw fɛ fana, i y’a fɔ o ye ko ni mɔgɔ dɔ sara k’a sɔrɔ a ma dencɛ to a kɔ, aw ye cɛn di a denmuso ma. ");
INSERT INTO dyu_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ni denmuso t’a fɛ, aw ye cɛn di a balemacɛw ma. ");
INSERT INTO dyu_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ni balemacɛ t’a fɛ, a ye cɛn di a facɛ balemacɛw ma. ");
INSERT INTO dyu_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ni a facɛ balemacɛ tɛ yi, a ta somɔgɔ min ka surun a ra, aw ye cɛn di o ma; ale le bɛ cɛn ta. «Nin ye cifɔnin le ye min latigɛra Izirayɛlimɔgɔw ye, i n’a fɔ Matigi Ala k’a fɔ Musa ye cogo min na.» ");
INSERT INTO dyu_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Matigi Ala k’a fɔ Musa ye ko: «Ne bɛna jamana min di Izirayɛlimɔgɔw ma, yɛlɛn Abarimu kuruw kunna, i bɛ o jamana flɛ. ");
INSERT INTO dyu_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","I b’a flɛ, o kɔ, i bɛna sa ka taga fara i bɛma tɔw kan, i n’a fɔ i kɔrɔcɛ Haruna sara, ka taga fara a bɛmaw kan cogo min na; ");
INSERT INTO dyu_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","sabu wagati min jama ka kɛrɛ ɲini ne fɛ ji ko ra Zini kongokolon kɔnɔ, ne tun ka min fɔ aw ye, aw ma o kɛ. Aw ma ne bonya Izirayɛlimɔgɔw ɲa kɔrɔ ne ta saninmanya kosɔn.» Meriba ta ji ko min wurira Kadɛsi, Zini kongokolon kɔnɔ, o ko lo. ");
INSERT INTO dyu_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa kumana Matigi Ala fɛ ko: ");
INSERT INTO dyu_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«Matigi Ala, ele Ala min ye adamaden bɛɛ nin tigi ye, o tuma ele ye mɔgɔ dɔ sigi jama kunna, ");
INSERT INTO dyu_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","min bɛ se ka bla o ɲa, o dontɔ ni o bɔtɔ, min bɛ o labɔ, ani ka o ladon; janko Matigi Ala ta jama kana kɛ i ko saga minw tora o yɛrɛ ma, ni gbɛnbaga ma sɔrɔ o ra.» ");
INSERT INTO dyu_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Matigi Ala ka Musa jaabi ko: «Na ni Nuni dencɛ Yosuwe ye, i bɛ i boro la a kan, sabu ne Nin* bɛ a kan. ");
INSERT INTO dyu_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","I bɛ taga a lɔ sarakalasebaga Elehazari ni jama bɛɛ ɲa fɛ, ka ne ta ciw fɔ a ye ka baara karifa a ma o ɲa kɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","I ta fanga dɔ di a ma, janko Izirayɛlimɔgɔw bɛɛ ye a kan mina fana. ");
INSERT INTO dyu_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Nka ni a bɛ ko o ko kɛ, a ka kan ka taga sarakalasebaga Elehazari le fɛ; ale le bɛna ne ɲininka ni Urimi ye ka ne sago fɔ a ye. Yosuwe ni Izirayɛlimɔgɔw bɛɛ lajɛnnin dontɔ o, o bɔtɔ o, o ka kan ka o ta kow bɛɛ kɛ ka kaɲa ni Elehazari ta kuma le ye.» ");
INSERT INTO dyu_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Matigi Ala ka min fɔ Musa ye, a ka o kɛ. A nana Yosuwe lɔ sarakalasebaga Elehazari ni jama bɛɛ ɲa fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","A k’a boro la a kan, ka Matigi Ala ta baara karifa a ma, i n’a fɔ Matigi Ala tun k’a fɔ Musa ye cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Nin ci fɔ Izirayɛlimɔgɔw ye, ko saraka minw ka kan ka bɔ ne ye, aw ka kan ka aw janto o ra ka o bɔ ne ye a wagati ra; sabu o saraka minw bɛ jɛni tasuma ra ne ye, o sarakaw kasa ka di ne ye. ");
INSERT INTO dyu_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","«A fɔ o ye ko aw ka kan ka saraka minw jɛni tasuma ra Matigi Ala ye, o ye nin ye: Lon o lon aw ye sagaden cɛman fla kɛ saraka ye, minw si ka san kelen sɔrɔ, ani fiyɛn tɛ minw na, ka o kɛ saraka jɛnita* ye; o man kan ka dabla ka ye. ");
INSERT INTO dyu_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Aw ye sagaden kelen kɛ saraka ye sɔgɔma, ka tɔ kelen kɛ saraka ye wuladanin fɛ. ");
INSERT INTO dyu_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Aw ye mugu tɛntɛnnin kilo saba nɔɔni oliviye turu litiri kelen ni tarancɛ ra, ka o kɛ siman saraka* ye, ka o fara a kan. ");
INSERT INTO dyu_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Saraka jɛnita lo, min ka kan ka bɔ lon o lon; o man kan ka dabla ka ye. O saraka tun kɔnna ka bɔ Sinayi kuru le kan. Saraka jɛninin lo tasuma ra, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Aw ye rɛzɛnji litiri kelen ni tarancɛ fana kɛ rɛzɛnji saraka* ye, ka o fara sagaden fɔlɔ kan. Rɛzɛnji saraka ka kan ka bɔ Matigi Ala ye yɔrɔ saninman* le kɔnɔ. ");
INSERT INTO dyu_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Aw ye sagaden flanan kɛ saraka ye wuladanin fɛ, ka siman saraka ni rɛzɛnji saraka fara a kan i n’a fɔ sɔgɔmada ta. Saraka jɛninin lo, min kasa ka di Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«Nɛnɛkirilon* na, aw ye sagaden cɛman fla kɛ saraka ye, minw si ka san kelen sɔrɔ, ani fiyɛn tɛ minw na. Aw ye mugu tɛntɛnnin kilo wɔɔrɔ nɔɔni turu ra, ka o kɛ siman saraka* ye, ka o ni rɛzɛnji saraka* fara a kan. ");
INSERT INTO dyu_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","O ye Nɛnɛkirilon* ta saraka jɛnita* ye; o bɛ kɛ Nɛnɛkirilon o Nɛnɛkirilon. O bɛ fara lon o lon ta saraka jɛnita kan, min man kan ka dabla ka ye, ani a ta rɛzɛnji saraka* kan.» ");
INSERT INTO dyu_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«Karokura o karokura, a tere fɔlɔ, aw ye misitoran kaɲaman fla, ani sagajigi kelen, ani sagaden cɛman wolonfla kɛ saraka jɛnita* ye ka o di Matigi Ala ma; o si ka kan ka san kelen sɔrɔ, ani fiyɛn kana kɛ o ra. ");
INSERT INTO dyu_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Siman saraka* min bɛ fara misitoran bɛɛ kelen kelen kan, o bɛ kɛ mugu tɛntɛnnin kilo kɔnɔntɔn ye, ka o nɔɔni turu ra. Siman saraka min bɛ fara sagajigi kan, o bɛ kɛ mugu tɛntɛnnin kilo wɔɔrɔ ye, ka o nɔɔni turu ra. ");
INSERT INTO dyu_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Siman saraka min bɛ fara sagaden bɛɛ kelen kelen kan, o bɛ kɛ mugu tɛntɛnnin kilo saba ye, ka o nɔɔni turu ra. Saraka jɛnita lo tasuma ra, min kasa ka di Matigi Ala ye. ");
INSERT INTO dyu_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Rɛzɛnji saraka* min bɛ fara misitoran bɛɛ kelen kelen kan, o bɛ kɛ rɛzɛnji litiri saba ye. Min bɛ fara sagajigi kan, o bɛ kɛ rɛzɛnji litiri fla ye. Min bɛ fara sagaden bɛɛ kelen kelen kan, o bɛ kɛ rɛzɛnji litiri kelen ni tarancɛ ye. «Saraka jɛnita min ka kan ka bɔ karo o karo, karo tere fɔlɔ, o le ye nin ye; a ka kan ka bɔ san karo bɛɛ ra. ");
INSERT INTO dyu_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka* ye, ka o di Matigi Ala ma. O bɛ fara lon o lon ta saraka jɛnita kan, ani a rɛzɛnji saraka kan.» ");
INSERT INTO dyu_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«San karo fɔlɔ tere tan ni naani, aw ye Jɔnyaban ɲanagbɛ* kɛ ka Matigi Ala bonya. ");
INSERT INTO dyu_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","O karo tere tan ni looru bɛna kɛ ɲanagbɛlon le ye. Aw bɛna burufunubari le domu fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","O lɔgɔkun tere fɔlɔ, aw bɛ jamalajɛnba kɛ ka Matigi Ala bato. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na. ");
INSERT INTO dyu_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Aw bɛna saraka minw bɔ Matigi Ala ye, ka o kɛ saraka jɛnita* ye tasuma ra, o ka kan ka kɛ misitoran kaɲaman fla ye, ani sagajigi kelen, ani sagaden cɛman wolonfla, minw ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Aw ye mugu tɛntɛnnin nɔɔni turu ra ka o kɛ siman saraka* ye ka o fara a kan; misitoran kelen ta bɛ kɛ mugu kilo kɔnɔntɔn ye, sagajigi ta bɛ kɛ mugu kilo wɔɔrɔ ye, ");
INSERT INTO dyu_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","sagadenw bɛɛ kelen kelen ta bɛ kɛ mugu kilo saba ye. ");
INSERT INTO dyu_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka* ye, janko ka aw ta jurumunw kafari. ");
INSERT INTO dyu_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Aw bɛna o sarakaw bɔ ka o fara sɔgɔmada ta saraka jɛnita kan, min bɛ bɔ lon o lon. ");
INSERT INTO dyu_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Aw bɛna o sarakaw jɛni lon o lon, fɔ tere wolonfla, i ko siman saraka, min jɛnina tasuma ra, ani min kasa ka di Matigi Ala ye. Aw ka kan ka o sarakaw bɔ ka fara lon o lon ta saraka jɛnita kan, ani a rɛzɛnji saraka*. ");
INSERT INTO dyu_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Lɔgɔkun tere wolonflanan, aw bɛ jamalajɛnba kɛ tuun ka Matigi Ala bato. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na.» ");
INSERT INTO dyu_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«Aw bɛ aw ta simanw kun fɔlɔ tigɛ lon min na, ni aw bɛ na ni aw ta simankura saraka ye ka na o di Matigi Ala ma, ka lɔgɔkunw ta ɲanagbɛ kɛ, aw ye jamalajɛnba kɛ ka Matigi Ala bato. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na. ");
INSERT INTO dyu_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Aw ye saraka jɛnita* dɔ bɔ, min kasa ka di Matigi Ala ye: misitoran kaɲaman fla, sagajigi kelen, ani sagaden wolonfla, minw si ka san kelen sɔrɔ. ");
INSERT INTO dyu_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Aw ye mugu tɛntɛnnin nɔɔni turu ra ka o kɛ siman saraka* ye, ka o fara a kan; misitoran bɛɛ kelen kelen ta bɛ kɛ mugu kilo kɔnɔntɔn ye, sagajigi ta bɛ kɛ mugu kilo wɔɔrɔ ye, ");
INSERT INTO dyu_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","sagadenw bɛɛ kelen kelen ta bɛ kɛ mugu kilo saba ye. ");
INSERT INTO dyu_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Aw ye bakɔrɔnin kelen kɛ saraka ye, janko ka aw ta jurumunw kafari. ");
INSERT INTO dyu_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Aw bɛna o sarakaw bɔ ka o fara lon o lon ta saraka jɛnita ni a siman saraka kan. Fiyɛn man kan ka sɔrɔ o bɛganw na; aw ye o ta rɛzɛnji sarakaw fana fara a kan.» ");
INSERT INTO dyu_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«San karo wolonflanan tere fɔlɔ, aw bɛna jamalajɛnba kɛ ka Matigi Ala bato. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na. Aw bɛna burufiyɛkanw le bɔ jamana yɔrɔ bɛɛ ra o lon na. ");
INSERT INTO dyu_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Aw bɛna saraka jɛnitaw* bɔ, minw kasa ka di Matigi Ala ye: Misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman wolonfla, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Aw ye mugu tɛntɛnnin nɔɔni turu ra, ka o kɛ siman saraka* ye ka o fara o sarakaw kan. Misitoran ta bɛ kɛ mugu kilo kɔnɔntɔn ye, sagajigi ta bɛ kɛ mugu kilo wɔɔrɔ ye, ");
INSERT INTO dyu_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","sagaden bɛɛ kelen kelen ta bɛ kɛ mugu kilo saba ye. ");
INSERT INTO dyu_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka* ye, janko ka aw ta jurumunw kafari. ");
INSERT INTO dyu_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","O sarakaw bɛ bɔ ka o fara karokura ta saraka jɛnita ni a siman saraka* kan, ka o fara lon o lon ta saraka jɛnita ni a siman saraka kan, ani a ta rɛzɛnji saraka* kan, i n’a fɔ ne k’a latigɛ cogo min na. Saraka jɛnita lo tasuma ra min kasa ka di Matigi Ala ye.» ");
INSERT INTO dyu_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«O karo wolonflanan tere tan, aw ye jamalajɛnba kɛ ka Matigi Ala bato, ka aw yɛrɛ majigi Ala ɲa kɔrɔ, ka aw diyanyafɛnw bɛɛ to yi; aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na. ");
INSERT INTO dyu_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Aw bɛ saraka jɛnitaw* bɔ, min kasa ka di Matigi Ala ye: Misitoran kaɲaman kelen, ani sagajigi kelen, ani sagaden cɛman wolonfla, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Aw ye mugu tɛntɛnnin nɔɔni turu ra, ka o kɛ siman saraka* ye ka o fara a kan. Misitoran ta bɛ kɛ mugu kilo kɔnɔntɔn ye, sagajigi ta bɛ kɛ mugu kilo wɔɔrɔ ye, ");
INSERT INTO dyu_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","sagaden bɛɛ kelen kelen ta bɛ kɛ mugu kilo saba ye. ");
INSERT INTO dyu_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka* ye, ka fara jurumunyafa saraka yɛrɛ kan, ani ka fara lon o lon ta saraka jɛnita ni a siman saraka* ni a rɛzɛnji saraka* kan.» ");
INSERT INTO dyu_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«Karo wolonflanan tere tan ni looru, aw ka kan ka jamalajɛnba kɛ ka Matigi Ala bato. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na. Aw bɛna ɲanagbɛ dɔ kɛ ka Matigi Ala bonya, fɔ tere wolonfla. ");
INSERT INTO dyu_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Aw bɛ sarakaw bɔ Matigi Ala ye, ka o kɛ saraka jɛnita* ye tasuma ra, min kasa ka di Matigi Ala ye: Misitoran kaɲaman tan ni saba, ani sagajigi fla, ani sagaden cɛman tan ni naani, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Aw ye mugu tɛntɛnnin nɔɔni turu ra, ka o kɛ siman saraka* ye ka o fara a kan. Misitoran tan ni saba bɛɛ kelen kelen ta bɛ kɛ mugu kilo kɔnɔntɔn, sagajigi fla bɛɛ kelen kelen ta bɛ kɛ mugu kilo wɔɔrɔ ye, ");
INSERT INTO dyu_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","sagaden tan ni naani bɛɛ kelen kelen ta bɛ kɛ mugu kilo saba ye. ");
INSERT INTO dyu_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka* ye, ka fara lon o lon ta saraka jɛnita ni a siman saraka* ni a rɛzɛnji saraka* kan. ");
INSERT INTO dyu_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«A tere flanan, aw bɛ misitoran kaɲaman tan ni fla kɛ saraka ye, ani sagajigi fla, ani sagaden cɛman tan ni naani, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Aw ye o misitoranw ni o sagajigiw ni o sagadenw ta siman sarakaw ni o ta rɛzɛnji sarakaw fana bɔ, a bɛɛ ni a ta hakɛya, i n’a fɔ ne k’a latigɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka* ye, ka fara lon o lon ta saraka jɛnita ni a siman saraka ni a rɛzɛnji saraka kan. ");
INSERT INTO dyu_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«A tere sabanan, aw ye misitoran tan ni kelen kɛ saraka ye, ani sagajigi fla, ani sagaden cɛman tan ni naani, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Aw ye o misitoranw, ani o sagajigiw, ani o sagadenw ta siman sarakaw, ani o ta rɛzɛnji sarakaw fana bɔ, a bɛɛ ni a ta hakɛya, i n’a fɔ ne k’a latigɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka ye, ka fara lon o lon ta saraka jɛnita ni a siman saraka ni a rɛzɛnji saraka kan. ");
INSERT INTO dyu_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«A tere naaninan, aw ye misitoran tan kɛ saraka ye, ani sagajigi fla, ani sagaden cɛman tan ni naani, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Aw ye o misitoranw, ani o sagajigiw, ani o sagadenw ta siman sarakaw, ani o ta rɛzɛnji sarakaw fana bɔ, a bɛɛ ni a ta hakɛya, i n’a fɔ ne k’a latigɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka ye, ka o fara lon o lon ta saraka jɛnita ni a siman saraka ni a rɛzɛnji saraka kan. ");
INSERT INTO dyu_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«A tere loorunan, aw ye misitoran kɔnɔntɔn kɛ saraka ye, ani sagajigi fla, ani sagaden cɛman tan ni naani, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Aw ye o misitoranw, ani o sagajigiw, ani o sagadenw ta siman sarakaw, ani o ta rɛzɛnji sarakaw fana bɔ, a bɛɛ ni a ta hakɛya, i n’a fɔ ne k’a latigɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka ye, ka fara lon o lon ta saraka jɛnita ni a siman saraka ni a rɛzɛnji saraka kan. ");
INSERT INTO dyu_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«A tere wɔɔrɔnan, aw ye misitoran seegi kɛ saraka ye, ani sagajigi fla, ani sagaden cɛman tan ni naani, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Aw ye o misitoranw, ani o sagajigiw, ani o sagadenw ta siman sarakaw, ani o ta rɛzɛnji sarakaw fana bɔ, a bɛɛ ni a ta hakɛya, i n’a fɔ ne k’a latigɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka ye, ka fara lon o lon ta saraka jɛnita ni a siman saraka ni a rɛzɛnji saraka kan. ");
INSERT INTO dyu_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«A tere wolonflanan, aw ye misitoran wolonfla kɛ saraka ye, ani sagajigi fla, ani sagaden cɛman tan ni naani, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Aw ye o misitoranw, ani o sagajigiw, ani o sagadenw ta siman sarakaw, ani o ta rɛzɛnji sarakaw fana bɔ, a bɛɛ ni a ta hakɛya, i n’a fɔ ne k’a latigɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka ye, ka fara lon o lon ta saraka jɛnita ni a siman saraka ni a rɛzɛnji saraka kan. ");
INSERT INTO dyu_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«A tere seeginan, aw ye jamalajɛnba kɛ, ani ɲanagbɛba, ka Matigi Ala bonya. Aw ka kan ka aw ta baara tɔw bɛɛ dabla o lon na. ");
INSERT INTO dyu_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Aw bɛ sarakaw bɔ, ka o kɛ saraka jɛnita ye tasuma ra, min kasa ka di Matigi Ala ye: Misitoran kelen, ani sagajigi kelen, ani sagaden cɛman wolonfla, minw si ka san kelen sɔrɔ; fiyɛn kana kɛ o bɛganw si ra. ");
INSERT INTO dyu_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Aw ye o misitoran ni o sagajigi ni o sagadenw ta siman sarakaw, ani o ta rɛzɛnji sarakaw fana bɔ, a bɛɛ ni a ta hakɛya, i n’a fɔ ne k’a latigɛ cogo min na. ");
INSERT INTO dyu_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Aw ye bakɔrɔnin kelen fana kɛ jurumunyafa saraka ye, ka fara lon o lon ta saraka jɛnita kan, ani a siman saraka ni a rɛzɛnji saraka kan. ");
INSERT INTO dyu_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«Aw ka kan ka nin sarakaw le bɔ Matigi Ala ye aw ta ɲanagbɛlonw na. Nin sarakaw bɛ fara aw yɛrɛ ta diyanya sarakaw kan, ani aw ta dajurudafa sarakaw, ani aw ta saraka jɛnita tɔw, ani aw ta siman sarakaw, ani aw ta rɛzɛnji sarakaw, ani aw ta ninsɔndiya sarakaw*.» ");
INSERT INTO dyu_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Matigi Ala tun ka fɛn o fɛn fɔ Musa ye, a ka o bɛɛ fɔ Izirayɛlimɔgɔw ye. ");
INSERT INTO dyu_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Musa kumana Izirayɛli jamakuruw ta kuntigiw fɛ, k’a fɔ o ye ko: «Matigi Ala ka ci minw fɔ, o ye nin ye: ");
INSERT INTO dyu_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Ni cɛ o cɛ ka dajuru ta Matigi Ala fɛ, walama ni a karira ka layirigbɛlɛn ta Ala ye, a man kan ka kɛ mɔgɔ darakolon ye; ni kuma o kuma bɔra a da ra, a ka kan ka o kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","«Ni sunguru dɔ le ka dajuru ta Matigi Ala fɛ, ka layirigbɛlɛn ta Ala ye, k’a sɔrɔ a belen bɛ a facɛ ta so, ");
INSERT INTO dyu_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","a ka dajuru min ta Matigi Ala fɛ, ani a ka layirigbɛlɛn min ta Ala ye, ni a facɛ bɔra o ko kala ma, nka ni a jera, ni a ma foyi fɔ, o tuma sunguru ka dajuru min o min ta, o dajuru bɛ jate; a ka layirigbɛlɛn ta ko o ko ra, a ka kan ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Nka ni a facɛ bɔra o ko kala ma lon min na, ni a ma sɔn, o tuma o sunguru ka dajuru o dajuru ta, ani a ka layirigbɛlɛn min ta, o si tɛ jate tuun. Matigi Ala bɛ yafa a ma, sabu a facɛ ma sɔn. ");
INSERT INTO dyu_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","«Ni sunguru dɔ ka dajuru ta, ka kuma dɔ fɔ, ka layiri ta ko a bɛna o ko kɛ Ala ye, o kɔ fɛ ni a furura, ");
INSERT INTO dyu_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ni a cɛ nana bɔ o ko kala ma, ni a jera a ma foyi fɔ a muso ye o lon na, o tuma muso ta dajuruw bɛ jate; a ka layirigbɛlɛn ta ko minw na, a ka kan ka o bɛɛ kɛ. ");
INSERT INTO dyu_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Nka ni a cɛ bɔra o ko kala ma lon min na, ni a ma sɔn a ma, o tuma muso tun ka dajuru min ta, ani o kuma minw bɔsira a ra, fɔ a ka o layiri ta Ala ye, a cɛ bɛ o kow bɛɛ sa. O ra, Matigi Ala fana bɛ yafa a ma. ");
INSERT INTO dyu_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«Muso cɛ sanin, walama muso furusanin, ni o dɔ ka dajuru ta, ka layirigbɛlɛn min o min ta Ala ye, a ka kan ka o layiri fa. ");
INSERT INTO dyu_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","«Ayiwa, ni muso dɔ ka dajuru ta, ka layirigbɛlɛn dɔ ta Ala ye, k’a sɔrɔ a bɛ a cɛ fɛ, ");
INSERT INTO dyu_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ni a cɛ ka bɔ o ko kala ma, ni a jera, ni a ma foyi fɔ a muso ye, ni a ma ban muso ta dajuruw ma, o tuma a ta dajuruw bɛɛ bɛ jate; a ka layirigbɛlɛn ta ko minw bɛɛ ra, a ka kan ka o bɛɛ dafa fana. ");
INSERT INTO dyu_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Nka lon min ni a cɛ bɔra o kala ma, ni a ka o dajuruw sa, o tuma muso ka dajuru min o min ta, ani a ka layiri ta ka kuma o kuma bɔ a da ra, o si tɛ jate tuun, sabu a cɛ ka o bɛɛ sa. Matigi Ala fana bɛ yafa a ma. ");
INSERT INTO dyu_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","«O cogo ra, muso bɛ dajuru min o min ta, ka layiri ta, ka kari ko a bɛna a yɛrɛ jagboya ka ko o ko kɛ, a cɛ bɛ se ka sɔn o ko ma, a fana bɛ se ka a sa. ");
INSERT INTO dyu_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ayiwa, lon min ni a cɛ bɔra o ko kala ma, ni cɛ jenin tora o ko kan o lon bɛɛ ra, ni a ma foyi fɔ muso ye, o tuma muso ka dajuru min o min ta, walama a ka layirigbɛlɛn ta ko minw bɛɛ ra, cɛ sɔnna o kow bɛɛ le ma; a sɔnna o ma, sabu a bɔra o ko kala ma lon min na, a jera a ma foyi fɔ muso ye. ");
INSERT INTO dyu_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Nka lon min na a bɔra o ko kala ma, ni o lon tɛmɛna, ni o kɔ fɛ a nana o dajuru sa, o tuma muso ta dajuru hakɛ bɛ ben cɛ yɛrɛ le kan sisan.» ");
INSERT INTO dyu_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Ayiwa, Matigi Ala ka o ciw le yira Musa ra, dajuruw tari ko ra, cɛ ni a muso cɛ, ani facɛ ni a denmuso cɛ, denmuso min sunguruman bɛ a facɛ ta so. ");
INSERT INTO dyu_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Matigi Ala kumana Musa fɛ, ko: ");
INSERT INTO dyu_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Madiyankaw ka kojugu min kɛ Izirayɛlimɔgɔw ra, taga o hakɛ bɔ Madiyankaw ra, ka Izirayɛlimɔgɔw dimibɔ. O kɔ, i bɛna sa ka taga fara i bɛma tɔw kan.» ");
INSERT INTO dyu_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Musa kumana mɔgɔw fɛ, ko: «Aw ra cɛ dɔw ye o ta kɛrɛkɛminanw ta ka taga Madiyankaw kɛrɛ, ka o ta kojugu hakɛ bɔ o ra Matigi Ala tɔgɔ ra. ");
INSERT INTO dyu_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Aw ye cɛ waga kelen kelen bɔ gbaw bɛɛ ra, ka taga kɛrɛ ra.» ");
INSERT INTO dyu_vpl VALUES ("NU31_5",