﻿USE sofia;
DROP TABLE IF EXISTS sofia.dyi_vpl;
CREATE TABLE dyi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dyi_vpl WRITE;
INSERT INTO dyi_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Fafafa, wa dunruya wi lɛsaga, Yɛnŋɛlɛ làa naayeri wo naa tara ti da. ");
INSERT INTO dyi_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tara ti sila pye ma yala, tìla pye waga. Diwi wìla pye tɔnŋgbɔɔ tijuguwo pi go na. Yɛnŋɛlɛ li Yinnɛ làa pye na tigile tɔnmɔ pi go na. ");
INSERT INTO dyi_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","A Yɛnŋɛlɛ lì sho fɔ: «Yanwa pi pan!» A yanwa pì si pan. ");
INSERT INTO dyi_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","A Yɛnŋɛlɛ lì si yanwa pi yan pi yɛn ma yɔn. A lì si yanwa po naa diwi wi ni ti laga ti yɛɛ na. ");
INSERT INTO dyi_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","A Yɛnŋɛlɛ lì si yanwa pi yeri: Pilige, ma diwi wi yeri: Yembinɛ. A yɔnlɔkɔgɔ si gbɔn, a pinliwɛ fun pì gbɔn. A ko si pye pilige koŋgbanŋga. ");
INSERT INTO dyi_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","A Yɛnŋɛlɛ lì sho fɔ: «Fogo mbe ye tɔnmɔ pi sɔgɔwɔ, kuu kɔn shyɛn pi lali pi yɛɛ ni.» ");
INSERT INTO dyi_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kì kaa pye ma, a Yɛnŋɛlɛ lì si fogo le tɔnmɔ pi sɔgɔwɔ, ma tɔnmɔ pa yaga wa go na, ma pa yaga nɔgɔna. A kì si pye ma. ");
INSERT INTO dyi_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","A Yɛnŋɛlɛ lì si ko fogo ko yeri: Naayeri. A yɔnlɔkɔgɔ si gbɔn, a pinliwɛ fun pì gbɔn. A ko si pye pilige shyɛn wogo. ");
INSERT INTO dyi_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","A Yɛnŋɛlɛ lì sho naa fɔ: «Naayeri wi nɔgɔna tɔnmɔ pi gbogolo laga nuŋgba, lawaga mbe yiri.» A kì si pye ma. ");
INSERT INTO dyi_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","A Yɛnŋɛlɛ lì si ko lawaga ko yeri «tara», mɛɛ tɔnmɔ mba pì gbogolo pi yɛɛ na po yeri «kɔgɔje». A Yɛnŋɛlɛ lì sigi yan fɔ ki yɛn ma yɔn. ");
INSERT INTO dyi_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kona, a lì sho fɔ: «Yan mbe fi wa tara ti na naa yarilire ni, konaa tire nda ti yɛn pire sɛworo ti ni mbe yala ti cɛngɛlɛ ke ni. Tige pire ti gbagboro ti pye wa ti nawa mbe yala ti cɛngɛlɛ ke ni.» A kì si pye ma. ");
INSERT INTO dyi_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","A yan kì si fi wa tara ti na naa yarilire ni ma yala ti cɛngɛlɛ ke ni, naa tire nda ti yɛn pire sɛworo ti ni. A tire pire tì si gbagboro le wa ti nawa ma yala ti cɛngɛlɛ ke ni. A Yɛnŋɛlɛ lì sigi yan fɔ ki yɛn ma yɔn. ");
INSERT INTO dyi_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","A Yɔnlɔkɔgɔ si gbɔn. A pinliwɛ fun pì gbɔn. A ko si pye pilige taanri wogo. ");
INSERT INTO dyi_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","A Yɛnŋɛlɛ lì sho fɔ: «Yanwa yirigeyaara mbe pye wa naayeri, tila pilige ko naa yembinɛ li ni ti kɔɔn ti yɛɛ na. Ti pye paa kacɛn yɛn mbaa wagati, naa piliye konaa yɛgɛlɛ ke yɛgɛ nari. ");
INSERT INTO dyi_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ti pye yanwa yirigeyaara wa naayeri, mbaa yanwa yinrigi laga tara ti na.» A kì si pye ma. ");
INSERT INTO dyi_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kì pye ma, a Yɛnŋɛlɛ lì si yanwa yirigeyaara shyɛn gbegele, a kà wɛ ka na. A lì si gbegbeŋge ki tɛgɛ pilige ki go na, ko ki yɛn yɔnlɔ ye, mɛɛ jɛgɛ ki tɛgɛ yembinɛ li go na, ko ki yɛn yeŋge ye; mɛɛ wɔnŋgɔlɔ ke gbegele fun. ");
INSERT INTO dyi_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","A lì siri tɛgɛtɛgɛ wa naayeri tila yanwa yinrigi laga tara ti na; ");
INSERT INTO dyi_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","konaa ti cɛn pilige naa yembinɛ li ni ti go na, mbaa yanwa po naa diwi wi ni ti kɔɔn ti yɛɛ na. A Yɛnŋɛlɛ lì sigi yan fɔ ki yɛn ma yɔn. ");
INSERT INTO dyi_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","A yɔnlɔkɔgɔ si gbɔn, a pinliwɛ fun pì gbɔn. A ko si pye pilige tijɛrɛ wogo. ");
INSERT INTO dyi_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","A Yɛnŋɛlɛ lì sho naa fɔ: «Yaara nda yinwege na, ti lɛgɛrɛ mbe pye wa tɔnmɔ pi ni. Sannjɛrɛ mbe yiri tila yinrigi sire na wa naayeri, tara ti go na.» ");
INSERT INTO dyi_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","A Yɛnŋɛlɛ lì si kɔgɔje nawa yaritugbɔɔrɔ ti da, konaa yaara nda fuun ti yɛn yinwege na, na waa na mari wa tɔnmɔ pi ni ti ni. A tì lɛgɛ wa tɔnmɔ pi ni fɔ jɛŋgɛ, ma yala ti cɛngɛlɛ ke ni. A lì sannjɛrɛ ti cɛngɛlɛ ke ni fuun ke da. A lì sigi yan fɔ ki yɛn ma yɔn. ");
INSERT INTO dyi_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","A Yɛnŋɛlɛ lì si duwaw ti na, ma siri pye fɔ: «Ye se, ye lɛgɛ, ye kɔgɔje tɔnmɔ pi yin; sannjɛrɛ fun ti se, ti lɛgɛ laga tara ti na.» ");
INSERT INTO dyi_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","A yɔnlɔkɔgɔ si gbɔn, a pinliwɛ fun pì gbɔn. A ko si pye pilige kaŋgurugo wogo. ");
INSERT INTO dyi_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","A Yɛnŋɛlɛ li sho naa fɔ: «Tara ti pan yaara nda ti yɛn yinwege na ti ni mbe yala ti cɛngɛlɛ ke ni, yaayoro to naa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele ke maa fulolo tara ti na, konaa woŋgaala pe cɛnlɛ pyew li ni.» A ko si pye ma. ");
INSERT INTO dyi_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","A Yɛnŋɛlɛ lì si woŋgaala pe gbegele ma yala pe cɛngɛlɛ ke ni, naa yaayoro ti ni ma yala ti cɛngɛlɛ ke ni, naa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele fuun ke maa fulolo tara ti na ke ni ma yala ke cɛngɛlɛ ke ni. A Yɛnŋɛlɛ lì sigi yan fɔ ki yɛn ma yɔn. ");
INSERT INTO dyi_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","A Yɛnŋɛlɛ lì sho fɔ: «Ye ti we lere gbelege wi pye we yanlɛɛ, wi yiri we kɔrɔgɔ, wi cɛn ŋgbanra nda wa tɔnmɔ pi ni ti go na, naa naayeri sannjɛrɛ, naa yaayoro, naa tara to naa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele ke maa fulolo tara ti na ti go na.» ");
INSERT INTO dyi_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","A Yɛnŋɛlɛ lì si lere wi da, a wì pye li yanlɛɛ, a lì suu da, a wì yiri li kɔrɔgɔ. A lì si pe da naŋa naa jɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kona, a Yɛnŋɛlɛ lì si duwaw pe na mɛɛ pe pye fɔ: «Ye se, ye lɛgɛ, ye tara ti yin, ye cɛn ti go na. Ye cɛn ŋgbanra nda wa tɔnmɔ pi ni ti go na, naa naayeri sannjɛrɛ to naa yaara nda fuun ti yɛn yinwege na, na yanri tara ti na ti go na.» ");
INSERT INTO dyi_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","A Yɛnŋɛlɛ lì sho fɔ: «Ye wele! Yarilire nda fuun ti yɛn laga tara ti na konaa tire nda fuun ti maa pire sɛni ma pye gbagboro ni, mìri kan ye yeri ti pye ye yaakara. ");
INSERT INTO dyi_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Woŋgaala mbele fuun pe yɛn laga tara ti na, naa naayeri sannjɛrɛ ti ni fuun, naa yaara nda fuun ti maa yanri tara ti na, ko kɔrɔ wo yɛn yaraga ŋga fuun ki maa wɔɔn, mì yantipirige ki kan ti yeri ki pye ti yaakara.» A ko si pye ma. ");
INSERT INTO dyi_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yaara nda fuun Yɛnŋɛlɛ làa gbelege, a lì siri wele mari yan ti yɛn ma yɔn fɔ jɛŋgɛ. A yɔnlɔkɔgɔ si gbɔn, a pinliwɛ fun pì gbɔn. A ko si pye pilige kɔgɔlɔni wogo. ");
INSERT INTO dyi_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Naayeri wo naa tara ti ni, naa ti nawa yaara pyew, pa tìla gbegele ma kɔ yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Naa Yɛnŋɛlɛ làa kaa kɔ li tunŋgo pyege ki na, a lì si wogo pilige kɔlɔshyɛn wogo ki na tunŋgo ŋga fuun làa pye ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","A Yɛnŋɛlɛ lì si duwaw pilige kɔlɔshyɛn wogo ki na maga tɛgɛ ki yɛ li yɛɛ kan, katugu làa tunŋgo ki pye ma yaara nda fuun da, làa kɔ ki tunŋgo ki na mɛɛ wogo ko pilige ko ni. ");
INSERT INTO dyi_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yawe Yɛnŋɛlɛ làa naayeri wo naa tara ti da sanga ŋa ni, kìla pye yɛgɛ ŋga na, koyi ŋga. ");
INSERT INTO dyi_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Yawe Yɛnŋɛlɛ làa tara to na naayeri wi gbegele sanga ŋa ni, kìla yala tige kpɛ fa fi laga tara ti na gbɛn, konaa yan kpɛ fa fi fun laga tara ti na, katugu ki sanga wi ni kìla yala Yawe Yɛnŋɛlɛ li fa tisaga wa laga tara ti na gbɛn. Ki sanga wi ni, leele sila pye laga mbaa fali tara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ɛɛn fɔ, fɔɔngɔ kà la pye na yinrigi wa nɔgɔna na tara ti yinŋgi lagapyew. ");
INSERT INTO dyi_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yawe Yɛnŋɛlɛ làa lere wi gbegele taambugɔ ni, mɛɛ yinwege wɔnwɔn pi le wa wi numawegele ke ni li yɛɛ yɔn tifɛlɛgɛ ki ni. A lere wì si pye yinwege na. ");
INSERT INTO dyi_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ko puŋgo na, a Yawe Yɛnŋɛlɛ lì si naŋgɔ kɔlɔgɔ ka gbegele wa Edɛn tara ti yɔnlɔ yirisaga yeri, mɛɛ lere ŋa làa gbegele wi tɛgɛ wa ki nawa. ");
INSERT INTO dyi_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tige ŋga fuun ki yɛgɛ cɛnwɛ pi yɛn ma yɔn, ma pye yaakara tanra yaa ta wa ki na, a Yawe Yɛnŋɛlɛ lì si ti a ti cɛngɛlɛ ke ni fuun tà fi ma yiri wa tara. A lì si tige ŋga ki maa yinwege kaan ka tɛgɛ wa naŋgɔ kɔlɔgɔ ki nandogomɔ, konaa tige ŋga ki maa kajɛŋgɛ naa kapege ki jɛnwɛ pi kaan ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A gbaan wà si yiri wa Edɛn tara ti ni, na naŋgɔ kɔlɔgɔ ki yinŋgi. A gbaan wì si wali wa ki laga ki na, ma kɛyɛn tijɛrɛ wɔ. ");
INSERT INTO dyi_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Gbaan wi kɛɛ koŋgbanŋga pàa pye naga yinri Pishɔn. Ko kìla pye ma Havila tara ti maga mari fili. Tɛ yɛn wa ki tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ki tara ti tɛ wi yɛn tɛ piiri. Bedelimu tire tɔnmɔ nuwɔ taan konaa sinndɛɛrɛ sɔnŋgbanga woro nda pe yinri ɔnikisi tìla pye wa. ");
INSERT INTO dyi_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Gbaan wi kɛɛ shyɛn wogo pàa pye naga yinri Giyɔn, ko kìla pye ma Kushi tara ti maga. ");
INSERT INTO dyi_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Gbaan wi kɛɛ taanri wogo pàa pye naga yinri Tigire, ko la pye na fuun na kee wa Asiri tara ti yɔnlɔ yirisaga yeri. Gbaan wi kɛɛ tijɛrɛ wogo pàa pye naga yinri Efirati. ");
INSERT INTO dyi_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","A Yawe Yɛnŋɛlɛ lì si lere wi tɛgɛ wa Edɛn naŋgɔ kɔlɔgɔ ki ni ma yo wila ki fali, wila ki kɔrɔsi. ");
INSERT INTO dyi_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","A Yawe Yɛnŋɛlɛ lì si ŋgasele la tɛgɛ ma lere wi kan, mɛɛ wi pye fɔ: «Naŋgɔ kɔlɔgɔ ki tige pige ŋga fuun ki yɛn mɔɔ ndanla, ma mbe ya ka ka. ");
INSERT INTO dyi_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ɛɛn fɔ, tige ŋga ki maa kajɛŋgɛ konaa kapege ki jɛnwɛ pi kaan, maga kaga pyɔ wa ka. Na maga wa ka pilige ŋga ni, ma daga mbe ku dɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","A Yawe Yɛnŋɛlɛ lì sho fɔ: «Naŋa wi koro wi nuŋgba, ki woro ma yɔn. Mi yaa sagafɔ gbegele wi kan, wi yala wi ni.» ");
INSERT INTO dyi_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yawe Yɛnŋɛlɛ làa tara tɛgɛ ma woŋgaala poro naa sannjɛrɛ ti cɛngɛlɛ ke ni fuun ke gbegele, mɛɛ ti a tì pan naŋa wi kɔrɔgɔ, maa wele paa wi yaa ti yeri yɛgɛ ŋga na we. Naŋa wì ka mɛgɛ ŋga yeri yaraga yɛnwege ŋga na, ko ki ma pye ki mɛgɛ ye. ");
INSERT INTO dyi_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","A naŋa wì si yaayoro to naa sannjɛrɛ ti ni, naa woŋgaala pe cɛnlɛ pyew pe mɛrɛ ti tagataga. Ɛɛn fɔ, wa ki yaayoro ti sɔgɔwɔ, ka sila ta wa ŋga ki mbaa pye wi sagafɔ mbe yala wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","A Yawe Yɛnŋɛlɛ lì si wɔnlɔwɔ gbɔɔ wa naŋa wi na, a wì si wɔnlɔ. A lì suu kendiŋgangala li nuŋgba wɔ mɛɛ wi wire kara ti tɛgɛ maga laga ki tɔn. ");
INSERT INTO dyi_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kendiŋganna na Yawe Yɛnŋɛlɛ làa wɔ naŋa wi ni, a lì si lo pye jɛlɛ, mɛɛ pan wi ni naŋa wi kɔrɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Naa naŋa wìla kaa wi yan, a wì sho fɔ: «Koni, ŋa yɛɛn, na kajeere ko ka nuŋgba yi, na wire kara to tari. Pe yaa laa yinri jɛlɛ, katugu wì yiri wa naŋa wo ni.» ");
INSERT INTO dyi_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ko kì ti naŋa wi yaa ka laga wi to naa wi nɔ pe na, mbe si mara wi jɔ wi na, kona pe shyɛn pe yaa pye wire nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Naŋa wo naa wi jɔ wi ni pàa pye witiwaga, pe sila si fɛrɛ jɛn. ");
INSERT INTO dyi_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Woŋgaala mbele Yawe Yɛnŋɛlɛ làa da, wɔɔgɔ kìla jilige ma wɛ pe ni fuun pe na. A Wɔɔgɔ kì si kaa jɛlɛ wi yewe maa pye fɔ: «Ki yɛn kaselege fɔ Yɛnŋɛlɛ lì yo yaga kaa naŋgɔ kɔlɔgɔ tire pire ti ni fuun ti kaa le?» ");
INSERT INTO dyi_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","A jɛlɛ wì si wɔɔgɔ ki pye fɔ: «We mbe ya mbaa naŋgɔ kɔlɔgɔ tire pire ti kaa kɛ. ");
INSERT INTO dyi_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ɛɛn fɔ, tige ŋga ki wa naŋgɔ kɔlɔgɔ ki nandogomɔ, Yɛnŋɛlɛ lì yo waga kaga pyɔ wa ka. Lì yo waga ka jiri ki tige ki na yɛrɛ, nakoma we daga mbe ku.» ");
INSERT INTO dyi_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","A wɔɔgɔ kì si jɛlɛ wi pye ma yo fɔ: «Ki woro ma, ye se ku dɛ. ");
INSERT INTO dyi_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Yɛnŋɛlɛ lìgi yo ma, katugu lìgi jɛn ma yo na yaga tige ki pige ka ka pilige ŋga ni, ye yɛngɛlɛ ke yaa yɛngɛ, ye yaa pye paa Yɛnŋɛlɛ li yɛn, mbe kajɛŋgɛ konaa kapege ki jɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","A jɛlɛ wì sigi yan fɔ tige ki pire ti yaa pye yaakara tanra, ti yɛn ma yɔn lere mbaa ti wele, konaa na maga ka ka ki mbe ya tijinliwɛ kan ma yeri. A wì si ka cɔ ma ka, mɛɛ ka kan wi pɔlɔ wi yeri le wi yɛɛ tanla, a wo fun wìgi ka. ");
INSERT INTO dyi_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Le ki yɔngɔlɔ nuŋgba ke ni, a pe ni fuun shyɛn pe yɛngɛlɛ kè si yɛngɛ, a pè sigi jɛn ma yo pe yɛn witiwaga. A pè si figiye tige wɛrɛ kɔn mari gbegele pe yɛɛ kan lɔmbɛɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Yɔnlɔkɔgɔ ki ni, naa tifɛnɛ làa kaa yinŋgi, a pè si Yawe Yɛnŋɛlɛ li tinmɛ ta li yɛn na yanriyanri wa naŋgɔ kɔlɔgɔ ki ni. Kì pye ma, a naŋa wo naa wi jɔ wi ni pè si lara Yawe Yɛnŋɛlɛ li na wa naŋgɔ kɔlɔgɔ tire ti nɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","A Yawe Yɛnŋɛlɛ lì si naŋa wi yeri maa pye fɔ: «Ma yɛn se yeri?» ");
INSERT INTO dyi_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","A naŋa wì sho fɔ: «Mɔ̀ɔ tinmɛ ta wa naŋgɔ kɔlɔgɔ ki ni, a mì si fyɛ, katugu mi yɛn witiwaga, ko mì lara.» ");
INSERT INTO dyi_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","A Yawe Yɛnŋɛlɛ lì suu pye fɔ: «Ambɔ wìgi yo ma kan ma yo ma yɛn witiwaga? Tige pige ŋga mì yo maga ka ka ka, ko ka ma ma ka le?» ");
INSERT INTO dyi_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","A naŋa wì sho fɔ: «Jɛlɛ ŋa mà kan na yeri ma yo wi pye na ni, wo wìgi tige pige ka cɔ ma kan na yeri, a mìgi ka.» ");
INSERT INTO dyi_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","A Yawe Yɛnŋɛlɛ li si jɛlɛ wi pye fɔ: «Ŋga mà pye yɛɛn, yiŋgi yi ko?» A jɛlɛ wì sho fɔ: «Wɔɔgɔ ko kìlan fanla, a mì sigi ka.» ");
INSERT INTO dyi_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","A Yawe Yɛnŋɛlɛ lì si wɔɔgɔ ki pye fɔ: «Ŋga mà pye yɛɛn ki kala na, mɔ̀ɔ daŋga yaayoro to naa woŋgaala pe ni fuun pe sɔgɔwɔ. Ma yaa la fulolo ma lara ti na, taambugɔ ko ki yaa pye ma yaakara ma yinwege piliye yi ni fuun yi ni. ");
INSERT INTO dyi_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mi yaa mbɛnwɛ le mboro naa jɛlɛ wi ni ye sɔgɔwɔ, mbe mbɛnwɛ le ma setirige piile poro naa jɛlɛ wi setirige piile pe sɔgɔwɔ. Jɛlɛ wi setirige piile pe yaa ka ma go ki yaari, mboro fun ma yaa ka pe nɔ wa pe tɔndanra ti na.» ");
INSERT INTO dyi_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kona, a Yɛnŋɛlɛ lì si jɛlɛ wi pye fɔ: «Mi yaa pisege tere ti ŋgban ma na fɔ jɛŋgɛ. Ma yaa jɔlɔ mbe si jɛn mbe se. Ma jatere wi yaa pye ma pɔlɔ wo na, wi yaa pye ma go na.» ");
INSERT INTO dyi_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","A Yɛnŋɛlɛ lì si naŋa wo pye fɔ: «Tige pige ŋga mìla yo maga ka ka ka, kì kaa pye mɔ̀ɔ jɔ wi sɛnrɛ ti logo maga ka, ki kala na, tara tì daŋga ma kala na. Ma yaa jɔlɔ jɛŋgɛ si jɛn mbe yaakara ta wa tara ti ni ma yinwege piliye yi ni fuun yi ni. ");
INSERT INTO dyi_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tara ti yaa wuuro naa yan pege yirige ma kan. Yarilire nda ti yaa la taa wa kɛrɛ, to ti yaa pye ma yaakara. ");
INSERT INTO dyi_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ma yaa kafugo tulu wa ma walɛgɛ ki na mbe wa, si jɛn mbe yaakara ta, fɔ ma ka sa sɔngɔrɔ wa tara ti ni; katugu pa mà yiri wa tara ti ni. Taambugɔ kì tɛgɛ mɔɔ gbegele, ma yaa ka sɔngɔrɔ wa taambugɔ ki ni.» ");
INSERT INTO dyi_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Kona, naŋa we, wo ŋa pe yinri Adama, a wì suu jɔ wi mɛgɛ taga naa yinri Awa, ko kɔrɔ wo yɛn yinwege, katugu wo wi yɛn leweele pe ni fuun pe nɔ we. ");
INSERT INTO dyi_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","A Yawe Yɛnŋɛlɛ lì si sɛlɛgɛ pye yaripɔrɔ ma kan Adama wo naa wi jɔ pe yeri peri le. ");
INSERT INTO dyi_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","A Yawe Yɛnŋɛlɛ lì sili yɛɛ pye fɔ: «Wele, lere wì kanŋga ma pye paa woro wa nuŋgba yɛn, ma kajɛŋgɛ naa kapege ki jɛn. Koni, ye ti we konɔ li tɔn wi na, jaŋgo wiga ka gbɔn wa tige ŋga ki maa yinwege kaan ki na mbege pyɔ wa cɔ mboo ka, mbe koro yinwege na fɔ sanga pyew.» ");
INSERT INTO dyi_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kì kaa pye ma, a Yawe Yɛnŋɛlɛ lì si lere wi yirige maa wɔ wa Edɛn naŋgɔ kɔlɔgɔ ki ni, tara nda pàa tɛgɛ maa gbegele, wi saa ti fali. ");
INSERT INTO dyi_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A lì si lere wi purɔ maa wɔ wa, mɛɛ mɛrɛgɛye mbele pe yinri sherubɛnye pele tɛgɛ wa Edɛn naŋgɔ kɔlɔgɔ ki yɔnlɔ yirisaga yeri, konaa kasɔn tokobi ni, konɔ na li maa kee wa tige ŋga ki maa yinwege kaan ki yeri, a wo na figefige nali kɔrɔsi. ");
INSERT INTO dyi_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Kona, a Adama wì suu jɔ Awa wi jɛn jɛlɛ, a wì si kugbɔ lɛ mɛɛ Kayɛn se. A jɛlɛ wì sho fɔ: «Yawe Yɛnŋɛlɛ li fanŋga na, mì naŋa se.» ");
INSERT INTO dyi_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ko puŋgo na, a wì si Kayɛn wi jɔnlɔ Abɛli wi se. A Abɛli wì si kaa pye yaayoro kɔnrifɔ, a Kayɛn wò pye kɛrɛ kɔnfɔ. ");
INSERT INTO dyi_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Naa sanga wà la kaa toro, a Kayɛn wì si kari wi kɛrɛ yaara ta ni ma saa ti wɔ saraga Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","A Abɛli fun wì si kari wi simbapiile koŋgbanmbala tiyɔɔnlɔ pele ni, naa pe yanlaga ki ni, ma saa ti wɔ saraga Yawe Yɛnŋɛlɛ li yeri. A lì si yɛnlɛ Abɛli wo naa wi saraga ki na. ");
INSERT INTO dyi_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ɛɛn fɔ, li sila yɛnlɛ Kayɛn wo naa wi saraga ki na. A kì si Kayɛn wi mbɛn fɔ jɛŋgɛ, a wì si yɛgɛ san. ");
INSERT INTO dyi_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","A Yawe Yɛnŋɛlɛ lì si Kayɛn wi pye fɔ: «Ki pye mɛlɛ, a kì sɔɔn mbɛn, a mà yɛgɛ san? ");
INSERT INTO dyi_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Na ma kaa kajɛŋgɛ piin, ma yɔlɔgɔ ki yaa yiri caw. Ɛɛn fɔ, na kaa si pye ma woro na kajɛŋgɛ piin, kapege ki yɛn paa yaripege yɛn ŋga kì gbɛgɛlɛ ma sinlɛ le ma yeyɔngɔ ki tanla. Kila jaa mbe fanŋga ta ma na, mboro ma daga mbe cɛn ko go na.» ");
INSERT INTO dyi_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ko puŋgo na, a Kayɛn wì suu jɔnlɔ Abɛli wi pye fɔ: «Shokari wa kɛrɛ.» Ma pe ta wa kɛrɛ, a Kayɛn wì si to wi jɔnlɔ Abɛli wi na maa gbo. ");
INSERT INTO dyi_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","A Yawe Yɛnŋɛlɛ lì si Kayɛn wi yewe maa pye fɔ: «Ma jɔnlɔ Abɛli wi yɛn se?» A Kayɛn wì sho fɔ: «Mii jɛn. Muwi mi yɛn na jɔnlɔ wi kɔrɔsifɔ we le?» ");
INSERT INTO dyi_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","A we Fɔ wì sho fɔ: «Yiŋgi mà pye yɛɛn? Ma jɔnlɔ wi kasanwa mba mà wo wa tara ti na, pi gbelege kila gbɔɔn laga na na, nala piin ma yo mbege kayaŋga wɔ. ");
INSERT INTO dyi_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ma jɔnlɔ ŋa mà gbo ma yɛ, tara nda tùu kasanwa pi wɔ, mɔ̀ɔ daŋga mɔɔ wɔ wa ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ma kaa fali tara ti na, ti se yarilire kan ma yeri. Ma yaa pye yanrifɔ mbaa yanri la toro tara ti na.» ");
INSERT INTO dyi_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","A Kayɛn wì si Yawe Yɛnŋɛlɛ li pye fɔ: «Na tege kì gbɔgɔ ma wɛ na fanŋga ki na, mi se ya ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Wele, nala maa na puro nala woo laga ki tara nda ti ni, mi yaa fe mbe lara ma na. Mi yaa pye lejaga mbaa yanri faa la toro tara ti ni. Lere ŋa fuun kanla yan, wi mbe ya mbanla gbo.» ");
INSERT INTO dyi_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","A Yawe Yɛnŋɛlɛ lì si Kayɛn wi pye fɔ: «Lere ŋa fuun ka Kayɛn gbo, wi kapege ki fɔgɔ ki yaa tɔn wi na fɔ sa ta tɔnsaga kɔlɔshyɛn.» A Yawe Yɛnŋɛlɛ lì si tɛgɛrɛ tɛgɛ Kayɛn wi na, jaŋgo lere ŋa fuun kaa yan wiga kaa gbo. ");
INSERT INTO dyi_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","A Kayɛn wì si laga le Yawe Yɛnŋɛlɛ li yɛgɛ na, mɛɛ saa cɛn wa Nɔdi tara, wa Edɛn tara yɔnlɔ yirisaga yeri. ");
INSERT INTO dyi_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kona, a Kayɛn wì suu jɔ wi jɛn jɛlɛ, a wì si kugbɔ lɛ, mɛɛ Enɔki se. A wì si ca ka kan naga yinri Enɔki ma yala wi pyɔ wi mɛgɛ ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","A Enɔki wo si Iradi se. A Iradi wo Mewuyayɛli se. A Mewuyayɛli wo si Metushayɛli se. A Metushayɛli wo Lemɛki se. ");
INSERT INTO dyi_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemɛki wo la pɔri jɛɛlɛ shyɛn, pàa pye na nuŋgba yinri Ada, na sanŋa wi yinri Sila. ");
INSERT INTO dyi_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","A Ada wo Yabali se. Leele mbele pàa pye na cɛɛn wa paara yinrɛ ti ni na yaayoro koro, Yabali wo wìla pye pe tɛlɛ we. ");
INSERT INTO dyi_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Pàa pye naa jɔnlɔ lenaŋa wi yinri Yubali. Mbele pàa pye na juru wi gbɔɔn na wegele ke wiin pe tɛlɛ wo lawi. ");
INSERT INTO dyi_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","A Sila fun wo si Tubali Kayɛn se. Tubali Kayɛn wo la pye na tuguwɔrɔ naa tuguyɛnrɛ tunŋgo pyeyaara ti cɛngɛlɛ pyew ti gbegele. Pàa pye naa jɔnlɔ sumboro wi yinri Naama. ");
INSERT INTO dyi_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","A Lemɛki wì suu jɛɛlɛ pe pye fɔ: «Ada naa Sila, ye nuŋgbogolo jan yaa nuru na yeri. Mi Lemɛki, yoro mbele na jɛɛlɛ, ye nuŋgbolo jan na sɛnrɛ ti yeri. Mì naŋa gbo, ŋa wìlan wɛlɛgɛ. Mì lefɔnŋɔ gbo, naa wìlan gbɔn we. ");
INSERT INTO dyi_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Na kaa pye Kayɛn gbogo ki fɔgɔ ki yaa tɔn tɔnsaga kɔlɔshyɛn, Lemɛki wogo ko yaa tɔn tɔnsaga nafa taanri ma yiri kɛ ma yiri kɔlɔshyɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","A Adama wo naa wi jɔ wi ni pè si pinambyɔ wa se naa. A jɛlɛ wì suu mɛgɛ taga naa yinri Sɛti, ma sho fɔ: «Yɛnŋɛlɛ lì pinambyɔ wa yɛgɛ kan na yeri Abɛli wi yɔnlɔ, ŋa Kayɛn wìla gbo we.» ");
INSERT INTO dyi_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","A Sɛti wo fun wì si pinambyɔ wa se naa yinri Enɔsi. Ko sanga wowi leele pàa ki lɛ na Yawe Yɛnŋɛlɛ li mɛgɛ ki yinri nali gbogo. ");
INSERT INTO dyi_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama wi setirige piile pe mɛrɛ sɛwɛ wi ŋa. Yɛnŋɛlɛ li yaa lere wi da pilige ŋga ni, làa wi da a wìli lɛ. ");
INSERT INTO dyi_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Làa pe da naŋa naa jɛlɛ. Pilige ŋga ni làa pe gbegele, a lì si duwaw pe na, mɛɛ pe mɛgɛ ki taga na pe yinri leele. ");
INSERT INTO dyi_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Naa Adama wìla kaa ta yɛlɛ cɛnmɛ naa nafa ma yiri kɛ (130), a wì si pinambyɔ se, a wì yiri wi kɔrɔgɔ, ma pye wi yanlɛɛ. A wì suu mɛgɛ taga naa yinri Sɛti. ");
INSERT INTO dyi_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sɛti sege ki puŋgo na, a Adama wì si pye yɛlɛ cɛnmɛ kɔlɔtaanri (800), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adama wi yinwege piliye yan fuun wìla ta, yìla pye yɛlɛ cɛnmɛ kɔlɔjɛrɛ naa nafa ma yiri kɛ (930), a wì si ku. ");
INSERT INTO dyi_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","A Sɛti wo si ta yɛlɛ cɛnmɛ ma yiri kaŋgurugo (105), a wì si pinambyɔ se naa yinri Enɔsi. ");
INSERT INTO dyi_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enɔsi sege ki puŋgo na, a Sɛti wì si pye yɛlɛ cɛnmɛ kɔlɔtaanri ma yiri kɔlɔshyɛn (807), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɛti wi yinwege piliye yan fuun wìla ta, yìla pye yɛlɛ cɛnmɛ kɔlɔjɛrɛ naa kɛ ma yiri shyɛn (912), a wì si ku. ");
INSERT INTO dyi_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","A Enɔsi wo si ta yɛlɛ nafa tijɛrɛ ma yiri kɛ, mɛɛ pinambyɔ se naa yinri Kena. ");
INSERT INTO dyi_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kena sege ki puŋgo na, a Enɔsi wì si pye naa yɛlɛ cɛnmɛ kɔlɔtaanri naa kɛ ma yiri kaŋgurugo (815), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enɔsi wi yinwege piliye yan fuun wìla ta, yìla pye yɛlɛ cɛnmɛ kɔlɔjɛrɛ ma yiri kaŋgurugo (905), a wì si ku. ");
INSERT INTO dyi_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","A Kena wo si ta yɛlɛ nafa taanri ma yiri kɛ, a wì si pinambyɔ se naa yinri Mahalaleyɛli. ");
INSERT INTO dyi_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalaleyɛli sege ki puŋgo na, a Kena wì si pye naa yɛlɛ cɛnmɛ kɔlɔtaanri naa nafa shyɛn (840), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kena wi yinwege piliye yan fuun wìla ta, yìla pye yɛlɛ cɛnmɛ kɔlɔjɛrɛ ma yiri kɛ (910), a wì si ku. ");
INSERT INTO dyi_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","A Mahalaleyɛli wo si ta yɛlɛ nafa taanri ma yiri kaŋgurugo, a wì si Yerɛdi se. ");
INSERT INTO dyi_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yerɛdi sege ki puŋgo na, a Mahalaleyɛli wì si pye yɛlɛ cɛnmɛ kɔlɔtaanri naa nafa ma yiri kɛ (830), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleyɛli wi yinwege piliye yan fuun wìla ta, yìla pye yɛlɛ cɛnmɛ kɔlɔtaanri naa nafa tijɛrɛ ma yiri kɛ ma yiri kaŋgurugo (895), a wì si ku. ");
INSERT INTO dyi_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","A Yerɛdi wo si ta yɛlɛ cɛnmɛ naa nafa taanri ma yiri shyɛn (162), a wì si pinambyɔ se naa yinri Enɔki. ");
INSERT INTO dyi_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enɔki sege ki puŋgo na, a Yerɛdi wì si pye naa yɛlɛ cɛnmɛ kɔlɔtaanri (800), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yerɛdi wi yinwege piliye yan fuun wìla ta, yìla pye yɛlɛ cɛnmɛ kɔlɔjɛrɛ naa nafa taanri ma yiri shyɛn (962), a wì si ku. ");
INSERT INTO dyi_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","A Enɔki wo si ta yɛlɛ nafa taanri ma yiri kaŋgurugo, a wì si pinambyɔ se naa yinri Matusalɛmu. ");
INSERT INTO dyi_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matusalɛmu sege ki puŋgo na, a Enɔki wì si pye naa yɛlɛ cɛnmɛ taanri (300). Wìla pye na tanri Yɛnŋɛlɛ konɔ li na. A wì si pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enɔki wi yinwege piliye yìla pye yɛlɛ cɛnmɛ taanri naa nafa taanri ma yiri kaŋgurugo (365). ");
INSERT INTO dyi_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enɔki wìla pye na tanri Yɛnŋɛlɛ konɔ li na, ko puŋgo na, a wì si kaa kɔ leele pe na, pe suu yan naa, katugu Yɛnŋɛlɛ làa wi lɛ ma kari wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","A Matusalɛmu wo si ta yɛlɛ cɛnmɛ naa nafa tijɛrɛ ma yiri kɔlɔshyɛn (187), a wì si pinambyɔ se naa yinri Lemɛki. ");
INSERT INTO dyi_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemɛki sege ki puŋgo na, a Matusalɛmu wì si pye naa yɛlɛ cɛnmɛ kɔlɔshyɛn naa nafa tijɛrɛ ma yiri shyɛn (782), mɛɛ pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Matusalɛmu wi yinwege piliye yan fuun wìla ta, yìla pye yɛlɛ cɛnmɛ kɔlɔjɛrɛ naa nafa taanri ma yiri kɔlɔjɛrɛ (969), a wì si ku. ");
INSERT INTO dyi_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","A Lemɛki wo si ta yɛlɛ cɛnmɛ naa nafa tijɛrɛ ma yiri shyɛn (182), a wì si pinambyɔ se. ");
INSERT INTO dyi_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","A wì suu mɛgɛ ki taga naa yinri Nowe, ma sho fɔ: «We tunndo nda waa piin, na tere nda tege, katugu Yawe Yɛnŋɛlɛ lì tara ti daŋga, ki pyɔ ŋa yɛɛn, wo wi yaa we kotogo ki sogo we na ti kala na.» ");
INSERT INTO dyi_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nowe sege ki puŋgo na, a Lemɛki wì si pye naa yɛlɛ cɛnmɛ kaŋgurugo naa nafa tijɛrɛ ma yiri kɛ ma yiri kaŋgurugo (595), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemɛki wi yinwege piliye yan fuun wìla ta, yìla pye yɛlɛ cɛnmɛ kɔlɔshyɛn naa nafa taanri ma yiri kɛ ma yiri kɔlɔshyɛn (777), a wì si ku. ");
INSERT INTO dyi_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowe wìla ta yɛlɛ cɛnmɛ kaŋgurugo (500), a wì si pinambiile taanri se: Sɛmu, naa Kamu konaa Zhafɛti. ");
INSERT INTO dyi_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Naa leele pàa kaa na lege laga tara ti na, a pè si sumbonɔ lɛgɛrɛ se. ");
INSERT INTO dyi_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ko sanga wo ni, a Yɛnŋɛlɛ li pinambiile pè si leele pe sumbonɔ pe yan pe yɔn fɔ jɛŋgɛ. A pè si pele wɔ, ma pe pɔri pe jɛɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kona Yawe Yɛnŋɛlɛ lì sho fɔ: «Yinwege wɔnwɔn mba mìla le leele pe ni, mi soo yaga pi koro pe ni pilige pyew, katugu pe yɛn wire nda ti yɛn kuworo. Mbege lɛ yiŋgɔ ni, pe yɛgɛlɛ ke se toro yɛlɛ cɛnmɛ naa nafa (120) na.» ");
INSERT INTO dyi_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ko sanga wo ni, letitɔɔnrɔ la pye laga tara ti na, ali ki sanga wi puŋgo na fun. Ko sanga wowi Yɛnŋɛlɛ li pinambiile pàa leele pe sumbonɔ pe lɛ pe jɛɛlɛ, ma piile sese pe na. Poro pàa pye faa woolo letugbɔɔrɔ, ma pye fanŋga fɛnnɛ, a pe mɛgɛ kì yiri fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","A Yawe Yɛnŋɛlɛ lì sigi yan fɔ leele pe nawa pì pe pe na laga tara ti na fɔ ma saa toro. Pe nawa jatere wi sila pye yaraga ko ka na, fɔ tipege ko bɔkɔ, pilige pyew. ");
INSERT INTO dyi_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","A kì si Yawe Yɛnŋɛlɛ li mbɛn, a lì sigi yan fɔ ki sila daga li leele pe da laga tara ti na. Li nawa pìla tanga li na fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","A Yawe Yɛnŋɛlɛ lì sho fɔ: «Leele mbele mìla da, mi yaa pe tɔngɔ mbe pe wɔ laga tara ti na, mbege lɛ leele pe na, mbe saga wa yaayoro to naa yaara nda ti maa fulolo tara ti na, konaa naayeri sannjɛrɛ ti ni; katugu leele mbele mì da, ndɛɛ mii ja pe da, ko mbe ja mbɔnrɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ɛɛn fɔ, Nowe wo la mɛgɛ ta Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nowe wi setirige ki ŋga. Nowe wìla pye lesinŋɛ konaa jɛrɛgisaga fu wi sanga wi ni. Wìla pye na tanri Yɛnŋɛlɛ konɔ li na wi yinwege piliye yi ni fuun yi ni. ");
INSERT INTO dyi_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowe wìla pinambiile taanri se, pe mɛrɛ ti nda: Sɛmu, naa Kamu konaa Zhafɛti. ");
INSERT INTO dyi_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tara tìla jɔgɔ Yɛnŋɛlɛ li yɛgɛ na, leele pàa pye na tipere piin tara ti ni lagapyew. ");
INSERT INTO dyi_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","A Yɛnŋɛlɛ lì si tara ti wele mari yan ti yɛn ma jɔgɔ, katugu sɛnwee piile pe ni fuun pàa pye na kapege piin laga tara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","A Yɛnŋɛlɛ lì sigi yo Nowe wi kan fɔ: «Mìgi kɔn maga tɛgɛ, mbe yaara nda fuun mì da ti tɔngɔ mberi wɔ wa sanga ŋa wo ni, katugu leele pe yɛn na kapere ti piin tara ti lagapyew. Wele, mi yaa poro naa tara ti ni pe pinlɛ mbe pe tɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ma tɔnmɔkɔrɔ gbeŋge gbegele ma yɛɛ kan gofɛri tire ni, ma yumbiile wɔ wa ki nawa, maga nawa naa ki puŋgo ki wɔlɔgɔ joro panyi ni. ");
INSERT INTO dyi_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Wele, maga gbegele ki gbegewe mba po na: ki titɔnlɔwɔ pi pye mɛtɛrɛ cɛnmɛ naa nafa shyɛn ma yiri kɛ (150), ki gbemɛ pi pye mɛtɛrɛ nafa ma yiri kaŋgurugo, ki yagawa pi pye mɛtɛrɛ kɛ ma yiri kaŋgurugo. ");
INSERT INTO dyi_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Maga gona wi tɔn, ma fenɛtiri wɔ ki na mɛtɛrɛ kɔngɔ wa ki mbogo yagawa po naa ki tɔnyaraga ti sɔgɔwɔ pi ni, ma yɔn wɔ ki kanŋgaga nuŋgba na. Maga gbegele, maga pye go taanri, maga tagala ki yɛɛ na. Ka mbe pye nɔgɔna, ka mbe pye nandogomɔ, ka mbe pye go na. ");
INSERT INTO dyi_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Wele, mi yaa tɔnŋgbɔɔ tirige laga tara ti na, mbe yaraga ŋga fuun ki yɛn na wɔɔn ki tɔngɔ. Yaraga ŋga fuun ki yɛn laga tara na, ki yaa ku. ");
INSERT INTO dyi_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ɛɛn fɔ, mboro wo na, mi yaa na yɔn finliwɛ pi le ma ni. Ma yaa ka ye wa tɔnmɔkɔrɔ gbeŋge ki ni, mboro naa ma jɔ, naa ye pinambiile, konaa pe jɛɛlɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Yaara nda fuun ti yɛn yinwege na, ma ti cɛnlɛ pyew ti shyɛnzhyɛn yigi, naŋa naa jɛlɛ, ma ye ti ni wa tɔnmɔkɔrɔ gbeŋge ki ni, jaŋgo to mbe ta ti koro yinwege na wa ma ni. ");
INSERT INTO dyi_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Sannjɛrɛ ti ni fuun, mbe yala ti cɛngɛlɛ ke ni, naa yaayoro naa woŋgaala pe ni fuun, mbe yala pe cɛngɛlɛ ke ni, konaa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele fuun ke maa fulolo tara ti na ke ni, mbe yala ke cɛngɛlɛ ke ni, ti ni fuun ti naŋa naa jɛlɛ mbe pan ma kɔrɔgɔ, jaŋgo to mbe koro yinwege na. ");
INSERT INTO dyi_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ma yaakara ti cɛnlɛ pyew ta lɛ mari le wa ma yɛɛ kɔrɔgɔ, ti pye mboro naa to ni, ye yaakara.» ");
INSERT INTO dyi_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","A Nowe wì sigi pye ma, paa yɛgɛ ŋga na Yɛnŋɛlɛ làa ki yo maa kan we. ");
INSERT INTO dyi_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kona, a Yawe Yɛnŋɛlɛ lì sigi yo ma Nowe wi kan fɔ: «Mboro naa ma go woolo pe ni, ye ye wa tɔnmɔkɔrɔ gbeŋge ki ni, katugu mboro nuŋgba mì yan ma yɛn sinŋɛ na yɛgɛ na wa ki nala pilige woolo mbele pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Yaayoro to naa woŋgaala mbele pe yɛn kpoyi, ma ti shyɛnzhyɛn tɛgɛsaga kɔlɔshyɛn wɔ ti ni, ti nambala naa ti jɛɛlɛ, ma si nda ti yɛn fyɔngɔ ni ti tɛgɛsaga nuŋgba nuŋgba wɔ fun, ti nambala naa ti jɛɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ma sannjɛrɛ ti cɛngɛlɛ ke ni fuun ti shyɛnzhyɛn tɛgɛsaga kɔlɔshyɛn wɔ ti ni, ti nambala naa ti jɛɛlɛ, jaŋgo ti cɛngɛlɛ ke koro laga tara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Na pilige kɔlɔshyɛn ka toro, mi yaa tisaga wa laga tara ti na yɔnlɔ nafa shyɛn naa yembinɛ nafa shyɛn ni. Yaara nda fuun mì da, mi yaa ti tɔngɔ mberi wɔ laga tara ti na.» ");
INSERT INTO dyi_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ŋga fuun Yawe Yɛnŋɛlɛ làa yo ma Nowe wi kan, a Nowe wì ki ni fuun ki pye ma. ");
INSERT INTO dyi_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowe wìla ta yɛlɛ cɛnmɛ kɔgɔlɔni (600), sanga ŋa ni tɔnŋgbɔɔ pìla pan laga tara ti na we. ");
INSERT INTO dyi_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nowe naa wi jɔ, naa wi pinambiile poro naa pe jɛɛlɛ pe ni, pè si pinlɛ ma ye wa tɔnmɔkɔrɔ gbeŋge ki ni tɔnŋgbɔɔ pi kala na. ");
INSERT INTO dyi_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Yaayoro to naa woŋgaala mbele fuun pe yɛn kpoyi, naa mbele pe yɛn fyɔngɔ ni, naa sannjɛrɛ ti ni, konaa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele ke maa fulolo tara ti na ke ni, ");
INSERT INTO dyi_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ti shyɛnzhyɛn, naŋa naa jɛlɛ, a tì si ye wa tɔnmɔkɔrɔ gbeŋge ki ni Nowe wi kɔrɔgɔ, paa yɛgɛ ŋga na Yɛnŋɛlɛ làa ki yo maa kan we. ");
INSERT INTO dyi_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Naa piliye kɔlɔshyɛn yìla kaa toro ma kɔ, a tɔnŋgbɔɔ pì si ye ma tara ti tɔn. ");
INSERT INTO dyi_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Yɛlɛ na ni Nowe wìla ta yɛlɛ cɛnmɛ kɔgɔlɔni (600), ki yɛlɛ li yeŋge shyɛn wogo ki pilige kɛ ma yiri kɔlɔshyɛn wogo ki na, tara ti nɔgɔna tɔnmɔ wegele ke ni fuun ke si janri ma yiri lɛgɛrɛ. A naayeri tɔnmɔ wegele kè si yɛngɛ. ");
INSERT INTO dyi_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","A tisaga ki nɛɛ paan tara ti na yɔnlɔ nafa shyɛn naa yembinɛ nafa shyɛn ni. ");
INSERT INTO dyi_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ko pilige koyi Nowe wìla ye wa tɔnmɔkɔrɔ gbeŋge ki ni wo naa wi jɔ, naa wi pinambiile Sɛmu, naa Kamu, naa Zhafɛti, konaa wi pinambiile pe jɛɛlɛ taanri pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ko leele poro pàa pye wa tɔnmɔkɔrɔ gbeŋge ki ni, poro naa woŋgaala, naa yaayoro ti cɛngɛlɛ ke ni fuun, naa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele fuun ke maa fulolo tara ti na, ma yala ke cɛngɛlɛ ke ni fuun ke ni, naa sannjɛrɛ ti ni fuun, ma yala ti cɛngɛlɛ ke ni fuun ke ni, naa sannjɛtumɔɔrɔ ti ni fuun, konaa yaraga ŋga fuun kanwiga yɛn ki na ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Yaara nda fuun ti yɛn yinwege na, pa tìla ye wa tɔnmɔkɔrɔ gbeŋge ki ni yɛɛn wa Nowe wi kɔrɔgɔ, ti naŋa naa jɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ki yaara ti ni fuun, naŋa naa jɛlɛ, a tì si pan ma ye wa tɔnmɔkɔrɔ gbeŋge ki ni, paa yɛgɛ ŋga na Yɛnŋɛlɛ làa ki yo ma Nowe wi kan we. A Yawe Yɛnŋɛlɛ lì si tɔnmɔkɔrɔ gbeŋge ki yɔn tɔn pe na. ");
INSERT INTO dyi_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","A tɔnŋgbɔɔ pì si pan tara ti na maga yigi fɔ pilige nafa shyɛn. A tɔnmɔ pì si lɛgɛ fɔ ma tɔnmɔkɔrɔ gbeŋge ki yirige wa naayeri. ");
INSERT INTO dyi_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Tɔnmɔ pìla pan tara ti na ma lɛgɛ jɛŋgɛ, a tɔnmɔkɔrɔ gbeŋge ki nɛɛ yɛgɛ tɔnmɔ pi go na. ");
INSERT INTO dyi_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","A ka nɛɛ tari tɔnmɔ pi lɛgɛwɛ pi na fɔ ma saa yanwira titɔɔnrɔ ti ni fuun ti tɔn. ");
INSERT INTO dyi_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","A tɔnmɔ pì si yiri ma yanwira ti yinrɛ ti tɔn ma gbɔn fɔ mɛtɛrɛ kɔlɔshyɛn naa kɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yaara nda fuun ti yɛn yinwege na, na yanri laga tara ti na, a ti ni fuun tì ku: sannjɛrɛ, naa yaayoro, naa woŋgaala, naa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele fuun ke maa fulolo tara ti na konaa leele pe ni fuun. ");
INSERT INTO dyi_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Yaraga ŋga fuun yinwege wɔnwɔn la pye ki ni laga tara ti na, a ki ni fuun kì ku. ");
INSERT INTO dyi_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Pa Yɛnŋɛlɛ làa yaara nda fuun ti yɛn yinwege na ti tɔngɔ mari wɔ laga tara ti na yɛɛn we, maga lɛ leele pe na, ma saa gbɔn yaayoro ti na, naa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele ke maa fulolo tara ti na, konaa naayeri sannjɛrɛ ti ni. A ti ni fuun tì ku ma wɔ laga tara ti na. Nowe wo naa mbele pàa pye wa tɔnmɔkɔrɔ gbeŋge ki ni, poro cɛ pàa shɔ. ");
INSERT INTO dyi_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","A tɔnŋgbɔɔ pì koro laga tara ti na fɔ ma saa gbɔn piliye cɛnmɛ naa nafa shyɛn ma yiri kɛ (150). ");
INSERT INTO dyi_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ɛɛn fɔ, Yɛnŋɛlɛ li jatere wìla pye Nowe wi na, naa woŋgaala poro naa yaayoro ti ni fuun ti na, nda tìla pye wi ni wa tɔnmɔkɔrɔ gbeŋge ki ni we. A Yɛnŋɛlɛ lì si tifɛlɛgɛ yirige, a kì pan na tara ti fee, a tɔnmɔ pi nɛɛ tinri. ");
INSERT INTO dyi_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","A tara ti nɔgɔna tɔnmɔ wegele koro naa naayeri tɔnmɔ wegele ke ni fuun kè si tɔn, a tisaga kì si kɔn. ");
INSERT INTO dyi_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","A tɔnmɔ pi nɛɛ waga laga tara ti na pilige pyew, ma saa gbɔn fɔ pilige cɛnmɛ naa nafa shyɛn ma yiri kɛ (150). A tɔnmɔ pì si tigi. ");
INSERT INTO dyi_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ki yɛlɛ li yeŋge kɔlɔshyɛn wogo ki pilige kɛ ma yiri kɔlɔshyɛn wogo ki na, a tɔnmɔkɔrɔ gbeŋge kì si cɛn wa Ararati yanwiga ki go na. ");
INSERT INTO dyi_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tɔnmɔ pìla pye na tinri fɔ ma saa gbɔn naa yeŋge kɛ wogo ki na. Ki yeŋge ki pilige koŋgbanŋga ki na, pàa pye na yanwira ti yinrɛ ti yaan. ");
INSERT INTO dyi_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Naa piliye nafa shyɛn la kaa toro, fenɛtiri ŋa Nowe wìla wɔ tɔnmɔkɔrɔ gbeŋge ki na, a wì suu yɛngɛ. ");
INSERT INTO dyi_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","A wì si kaankaan wa yirige maa wa. A wì si kari, mɛɛ sɔngɔrɔ ma pan, mɛɛ koro na kee na paan fɔ tɔnmɔ pi sa waga pi kɔ wa tara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ko puŋgo na, a Nowe wì si ketenɛ la yirige mali wa, jaŋgo mbege jɛn na kaa pye tɔnmɔ pi waga wa tara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ɛɛn fɔ, ketenɛ lii cɛnsaga ta tɔnmɔ pi kala na. A lì si sɔngɔrɔ wa Nowe wi kɔrɔgɔ, wa tɔnmɔkɔrɔ gbeŋge ki ni, katugu tɔnmɔ pìla pye tara ti lagapyew. A Nowe wì suu kɛɛ ki yirige ma ketenɛ li yigi mali le wa wi yɛɛ kɔrɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A Nowe wì si yapelege nuŋgba yaga kì toro naa, a wì si ketenɛ li yirige mali wa naa. ");
INSERT INTO dyi_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","A ketenɛ lì si sɔngɔrɔ ma pan wi kɔrɔgɔ ki yɔnlɔkɔgɔ ki ni oliviye tige wɛrɛ ni wa li yɔn. A Nowe wì sigi jɛn ma yo tɔnmɔ pìla jerege laga tara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","A Nowe wì si piliye kɔlɔshyɛn pye wa tɔnmɔkɔrɔ gbeŋge ki ni naa. Ko puŋgo na, a wì si ketenɛ li wɔ mali wa naa, kona lii sɔngɔrɔ mbe pan wi kɔrɔgɔ naa. ");
INSERT INTO dyi_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nowe wi yɛlɛ cɛnmɛ kɔgɔlɔni naa yɛlɛ nuŋgba (601) wolo li yeŋge koŋgbanŋga, ki pilige koŋgbanŋga ki na, kìla yala tɔnmɔ pì waga laga tara ti na. A Nowe wì si tɔnmɔkɔrɔ gbeŋge ki naayeri tɔnyaraga ki yɛngɛ, ma funwa pi wele, ma sigi yan tɔnmɔ pì waga laga tara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ki yɛlɛ li yeŋge shyɛn wogo ki pilige nafa ma yiri kɔlɔshyɛn wogo ki na, a ko si yala tara tìla waga pew. ");
INSERT INTO dyi_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","A Yɛnŋɛlɛ lì sigi yo Nowe wi kan fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Ye yiri wa tɔnmɔkɔrɔ gbeŋge ki ni, mboro naa ma jɔ, naa ye pinambiile poro naa pe jɛɛlɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Yaara nda fuun ti yɛn yinwege na wa ma ni, ko kɔrɔ wo yɛn sannjɛrɛ, naa yaayoro naa woŋgaala konaa nda fuun ti maa yanri tara ti na, ma ti ni fuun ti yirige, jaŋgo ti se, ti lɛgɛ laga tara ti na.» ");
INSERT INTO dyi_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kona, a Nowe wì si yiri wa tɔnmɔkɔrɔ gbeŋge ki ni, wo naa wi jɔ, naa pe pinambiile poro naa pe jɛɛlɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Woŋgaala pe ni fuun, naa yaara nda ti maa fulolo tara ti na konaa sannjɛrɛ ti ni, yaraga ŋga fuun ki maa tigile tara ti na, mbe yala ti cɛngɛlɛ ke ni, a ti ni fuun tì yiri wa tɔnmɔkɔrɔ gbeŋge ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","A Nowe wì si saraga wɔsaga kan maga le Yawe Yɛnŋɛlɛ li kɛɛ. A wì si yaayoro to naa sannjɛrɛ ti nuŋgba nuŋgba yigi, nda ti yɛn kpoyi Yɛnŋɛlɛ lì yɛgɛ na, mari wɔ saraga Yɛnŋɛlɛ li yeri, mari sogo wa saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","A Yawe Yɛnŋɛlɛ lì sigi saraga ki nuwɔ taan pi ta. A lì sigi yo wa li nawa ma yo fɔ: «Mi se ka tara ti daŋga naa leele pe kala na, katugu mbege lɛ wa lere wi punwɛ pi na, wi nawa jatere wi yɛn ma pe wi na. Mi se ka yaara nda ti yɛn yinwege na ti tɔngɔ naa, paa yɛgɛ ŋga na mìgi pye we. ");
INSERT INTO dyi_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ɛɛn fɔ, mbe tara ti yaga wa ti yɔngɔlɔ ke ni, yarilire lugusanga naa ti kɔnsanga, were sanga naa kafugo sanga, yɔnrɔ naa kanga, yɔnlɔ naa yembinɛ ti se ka kɔ naa fyew.» ");
INSERT INTO dyi_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kona, a Yɛnŋɛlɛ lì si duwaw Nowe wo naa wi pinambiile pe na, ma pe pye fɔ: «Ye se, ye lɛgɛ, ye tara ti yin. ");
INSERT INTO dyi_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Yaara nda fuun ti yɛn yinwege na laga tara ti na, naa naayeri sannjɛrɛ to naa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele fuun ke maa fulolo tara ti na, naa ŋgbanra ti ni, ti yaa la fyɛ konaa ti sunndo wi yaa la kɔɔn ye yɛgɛ, mìri le ye kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Yaraga ŋga fuun ki maa tigile ma pye yinwege na, ti mbe ya pye ye yaakara. Mì ti ni fuun ti kan ye yeri, paa yɛgɛ ŋga na mìla yan wɛrɛ ti kan ye yeri we. ");
INSERT INTO dyi_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ɛɛn fɔ, yaga ka kara ta ka nda ti yɛn ti yinwege ki ni, ko kɔrɔ wo yɛn nda ti yɛn ti kasanwa pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ye kasanwa mba pi yɛn ye yinwege ye, mi yaa ka pi fɔgɔ ki yewe. Na yaayogo ka lere wa gbo, mi yaa ka ki lere wi kasanwa pi fɔgɔ yewe ki yaayogo ki na. Na lere wa ka wi lewee yɛnlɛ wa gbo, mi yaa ka ki lere wi yinwege fɔgɔ ki yewe ŋa wùu gbo wi na. ");
INSERT INTO dyi_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Na lere ka lere gbo, lere wa wi yaa ka wo gbo fun; katugu Yɛnŋɛlɛ lì lere wi da, a wì pye li yanlɛɛ. ");
INSERT INTO dyi_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Yoro wo na, ye piile se, ye lɛgɛ, ye jaraga lɛgɛrɛ laga tara ti na.» ");
INSERT INTO dyi_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kona, a Yɛnŋɛlɛ lì sigi yo Nowe wo naa wi pinambiile pe kan ");
INSERT INTO dyi_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","ma yo fɔ: «Ye wele, mi wo na, mi yaa na yɔn finliwɛ pi le ye ni, naa ye setirige piile mbele pe yaa ka yiri ye puŋgo na pe ni; ");
INSERT INTO dyi_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","konaa yaraga ŋga fuun ki yɛn yinwege na wa ye ni ki ni: Sannjɛrɛ, naa yaayoro, naa woŋgaala pe ni fuun, naa yaara nda fuun tì yiri wa tɔnmɔkɔrɔ gbeŋge ki ni, konaa nda fuun ti yaa ka pye yinwege na laga tara na ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mi yaa na yɔn finliwɛ pi le ye ni. Mi se ka tɔnŋgbɔɔ tɛgɛ mbe yaara nda ti yɛn yinwege na ti tɔngɔ laga tara ti na naa. Tɔnŋgbɔɔ ma pi yaa ka tɛgɛ mbe tara ti tɔngɔ naa.» ");
INSERT INTO dyi_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","A Yɛnŋɛlɛ lì sho naa fɔ: «Yɔn finliwɛ mba mi yaa le ye ni, naa yaara nda fuun ti yɛn yinwege na wa ye ni ti ni, konaa leele mbele fuun pe yaa ka yiri ye puŋgo na pe ni, pi kacɛn wowi ŋa. ");
INSERT INTO dyi_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mi yaa na yaanŋgondi wi tɛgɛ wa kambaara ti na, wi pye na yɔn finliwɛ pi kacɛn, po mba mì le tara woolo pe ni we. ");
INSERT INTO dyi_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Sanga o sanga mi ka ti tisaga kiga wɔ, pa yaanŋgondi wi yaa yiri wa kambaara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Yɔn finliwɛ mba mì le ye ni, naa yaraga ŋga fuun ki yɛn yinwege na ki cɛnlɛ pyew li ni, mi yaa la nawa tuun ki yɔn finliwɛ pi na. Tɔnŋgbɔɔ se ka pan mbe yaara nda ti yɛn yinwege na ti tɔngɔ naa laga tara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Yaanŋgondi wiga yiri wa kambaara ti na wa naayeri, mi yaa la wi wele, mbaa nawa tuun na yɔn finliwɛ mbakɔɔ pi na, po mba mì le yaara nda fuun ti yɛn yinwege na laga tara na ti ni we.» ");
INSERT INTO dyi_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","A Yɛnŋɛlɛ lì si Nowe wi pye naa fɔ: «Yaanŋgondi wo wi yɛn yɔn finliwɛ pi kacɛn we, po mba mì le mi naa yaara nda fuun ti yɛn yinwege na laga tara ti na ti ni we.» ");
INSERT INTO dyi_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowe wi pinambiile mbele pàa yiri wa tɔnmɔkɔrɔ gbeŋge ki ni pe mɛrɛ ti nda: Sɛmu, naa Kamu konaa Zhafɛti. Kamu wìla pye Kana wo to. ");
INSERT INTO dyi_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nowe wi pinambiile taanri poro wɛlɛ yɛɛn. Pe setirige piile poro wɛlɛ pè se ma tara ti ni fuun ti yin. ");
INSERT INTO dyi_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowe wo wìla pye kɛkɔɔn koŋgbanŋa ma ɛrɛzɛn tiire sanri. ");
INSERT INTO dyi_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","A Nowe wì si kaa duvɛn wɔ a wùu yigi; a wì suu yaripɔrɔ ti wɔ wi yɛɛ na, ma koro witiwaga, wa wi paraga go ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","A Kana wi to Kamu wì si saa wi to Nowe wi yan witiwaga, mɛɛ pan maga yo wi nɔsepiile shyɛn pe kan wa funwa na. ");
INSERT INTO dyi_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kona, a Sɛmu naa Zhafɛti pè si derigbɔgɔ lɛ maga taga pe pajoro ti na, nɛɛ kee puŋgo ni wa paraga go ki ni, ma saa pe to wi tɔn ki ni. Pàa puŋgo wa pe to wi yeri, jaŋgo paga kaa witiwaga ki yan. ");
INSERT INTO dyi_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Naa duvɛn wìla kaa laga Nowe wi na, ŋga wì pinambyɔ puŋgofɔ wìla pye wi na, a wì sigi jɛn. ");
INSERT INTO dyi_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","A wì sho fɔ: Daŋga mbe Kana wi yigi! Wi pye kulolo pe kulo mboo nɔsepiile pe kan! ");
INSERT INTO dyi_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","A wì sho naa fɔ: Yawe Yɛnŋɛlɛ na li yɛn Sɛmu wi Yɛnŋɛlɛ le, gbɔgɔwɔ mbe pye li woo! Kana wi pye Sɛmu wi kulo! ");
INSERT INTO dyi_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yɛnŋɛlɛ li Zhafɛti wi gbɔgɔ! Wila korogi wa Sɛmu wi paara yinrɛ ti ni. Kana wi pye wi kulo! ");
INSERT INTO dyi_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Tɔnŋgbɔɔ pi toroŋgɔlɔ, a Nowe wì si pye naa yɛlɛ cɛnmɛ taanri naa nafa shyɛn ma yiri kɛ (350). ");
INSERT INTO dyi_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nowe wi yinwege piliye yi ni fuun yìla pye yɛlɛ cɛnmɛ kɔlɔjɛrɛ naa nafa shyɛn ma yiri kɛ (950), a wì si ku. ");
INSERT INTO dyi_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Tɔnŋgbɔɔ pi panŋgɔlɔ, a Nowe wi pinambiile Sɛmu, naa Kamu, naa Zhafɛti pè si piile se. Pe setirige piile pe mɛrɛ ti nda: ");
INSERT INTO dyi_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Zhafɛti wi pinambiile pe mɛrɛ ti nda: Gomɛri, naa Magɔgi, naa Madayi, naa Yavan, naa Tubali, naa Meshɛki konaa Tirasi. ");
INSERT INTO dyi_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomɛri wi pinambiile pe mɛrɛ ti nda: Ashikenazi, naa Irifati konaa Togarima. ");
INSERT INTO dyi_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavan pinambiile pe mɛrɛ ti nda: Elisha, naa Tarisisi, naa Kitimu konaa Dodanimu. ");
INSERT INTO dyi_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Wa pe setirige ki ni, cɛngɛlɛ lɛgɛrɛ la yiri wa pe ni. A ki leele pè jaraga ma cɛn wa kɔgɔje yɔn tara ti laga ki ni fuun ki na. A pè si kɔɔnlɔ kɔɔnlɔ ma pye tara tara, naa cɛngɛlɛ cɛngɛlɛ, naa seye seye ma yala pe sɛnrɛ ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kamu pinambiile pe mɛrɛ ti nda: Kushi, naa Mizirayimu, naa Puti konaa Kana. ");
INSERT INTO dyi_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kushi pinambiile pe mɛrɛ ti nda: Seba, naa Havila, naa Sabita, naa Arayema konaa Sabiteka. Arayema pinambiile pe mɛrɛ ti nda: Saba naa Dedan. ");
INSERT INTO dyi_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi wo wìla Nimirɔdi wi se fun. Nimirɔdi wo wìla keli ma pye fanŋga fɔ koŋgbanŋa laga tara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimirɔdi wìla pye koniyɛɛn gbɔɔ Yawe Yɛnŋɛlɛ li yɛgɛ na. Ko kì ti pe maa ki yuun ma yo fɔ: «Koniyɛɛn gbɔɔ Yawe Yɛnŋɛlɛ li yɛgɛ na paa Nimirɔdi yɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Wi wunluwɔ cara koŋgbannda ti mɛrɛ tori nda yɛɛn: Babɛli, naa Erɛki, naa Akadi konaa Kaline, wa Sineyari tara. ");
INSERT INTO dyi_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","A Nimirɔdi wì si kaa yiri wa ki tara ti ni, ma kari wa Asiri tara, ma saa Ninive ca ki kan, naa Erehobɔti Iri ca ki ni, naa Kala ca ki ni, ");
INSERT INTO dyi_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","konaa Eresɛn cagbɔgɔ ki ni; ko la pye Ninive ca konaa Kala ca ti sɔgɔwɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizirayimu wo wìla pye Ludi cɛnlɛ woolo pe tɛlɛ we, naa Anɛmu cɛnlɛ woolo pe ni, naa Leyabi cɛnlɛ woolo, naa Nafitu cɛnlɛ woolo pe tɛlɛ; ");
INSERT INTO dyi_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","naa Paturusi cɛnlɛ woolo, naa Kasiluhi cɛnlɛ woolo poro naa Kafitɔri cɛnlɛ woolo pe tɛlɛ we. Pa Filisiti tara fɛnnɛ pè yiri wa ki cɛngɛlɛ shyɛn ŋgele ke ni. ");
INSERT INTO dyi_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","A Kana wì suu pinambyɔ koŋgbanŋa Sidɔn wi se konaa Hɛti ni. ");
INSERT INTO dyi_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Wo wìla pye Zhebusi cɛnlɛ woolo pe tɛlɛ we, naa Amɔri cɛnlɛ woolo, naa Girigasi cɛnlɛ woolo, ");
INSERT INTO dyi_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","naa Hɛvi cɛnlɛ woolo, naa Ariki cɛnlɛ woolo, naa Sini cɛnlɛ woolo, ");
INSERT INTO dyi_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","naa Arivadi cɛnlɛ woolo, naa Zemari cɛnlɛ woolo konaa Hamati cɛnlɛ woolo pe tɛlɛ we. Ko puŋgo na, a Kana sege woolo pè si jaraga. ");
INSERT INTO dyi_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Pe tara tìla lɛ wa Sidɔn ca ki na ma jaraga ma kari wa Gerari ca ki yeri, fɔ ma saa gbɔn wa Gaza ca ki na, ma kari wa Sodɔmu ca, naa Gomɔri ca, naa Adima ca, konaa Zeboyimu ca ki yeri, fɔ ma saa gbɔn wa Lesha ca ki na. ");
INSERT INTO dyi_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Poro pe yɛn Kamu wi setirige piile wele, mbele pàa kɔɔnlɔ kɔɔnlɔ ma yala pe seye, naa pe sɛnrɛ, naa pe tara konaa pe cɛngɛlɛ ke ni. ");
INSERT INTO dyi_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Zhafɛti wi ndɔ Sɛmu wìla pinambiile pele se fun. Wo wìla pye Hebɛri naa wi setirige piile pe tɛlɛ we. ");
INSERT INTO dyi_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sɛmu wi pinambiile pe mɛrɛ ti nda: Elamu, naa Asuri, naa Aripakisadi, naa Ludi konaa Aramu. ");
INSERT INTO dyi_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramu wi pinambiile pe mɛrɛ ti nda: Uzi, naa Huli, naa Getɛri konaa Mashi. ");
INSERT INTO dyi_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","A Aripakisadi wo si Shela se. A Shela wo Hebɛri se. ");
INSERT INTO dyi_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hebɛri wo la se pinambiile shyɛn. Pàa pye na koŋgbanŋa wi yinri Pelɛgi, katugu sanga ŋa ni wìla pye yinwege na, a tara woolo pè si kɔn pe yɛɛ na. Pàa pye naa nɔsepyɔ lenaŋa wi yinri Yokitan. ");
INSERT INTO dyi_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","A Yokitan wo si Alimodadi se, naa Shelɛfu, naa Hazarimavɛti, naa Yera, ");
INSERT INTO dyi_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","naa Hadoramu, naa Uzali, naa Dikila, ");
INSERT INTO dyi_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","naa Obali, naa Abimayɛli, naa Saba, ");
INSERT INTO dyi_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","naa Ofiri, naa Havila konaa Yobabu. Poro pe ni fuun mbele, poro la pye Yokitan wi pinambiile. ");
INSERT INTO dyi_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Pàa pye ma cɛn Mesa ca konaa Sefari yanwiga tara ti sɔgɔwɔ, ma wa yɔnlɔ yirisaga yeri. ");
INSERT INTO dyi_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Poro pe yɛn Sɛmu setirige piile wele, mbele pàa kɔɔnlɔ kɔɔnlɔ ma yala pe seye, naa pe sɛnrɛ, naa pe tara konaa pe cɛngɛlɛ ke ni. ");
INSERT INTO dyi_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nowe wi pinambiile pe setirige piile poro wɛlɛ yɛɛn, pàa kɔɔnlɔ kɔɔnlɔ seye seye, ma yala pe cɛngɛlɛ ke ni. Leele mbele fuun pe yɛn laga tara ti ni, pa pè yiri wa pe setirige ki ni, ma jaraga ma cɛn tara, tara, tɔnŋgbɔɔ pi panŋgɔlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sɛnrɛ nuŋgba dunruya woolo pàa pye na yuun, pe sɛnyogo kìla pye nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","A pè si kaa yiri wa yɔnlɔ yirisaga yeri na kee, mɛɛ saa funwa lagbɔgɔ ka yan wa Sineyari tara, a pè si cɛn lema. ");
INSERT INTO dyi_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","A pè si kaa ki yo pe yɛɛ kan ma yo fɔ: «Yoo kari we sa tofa kɔn woo sogo wi sheli jɛŋgɛ.» Ko puŋgo na, a pè sigi tofa wi lɛ, a wì pye pe yeri paa go wasinndɛɛrɛ yɛn, a pè tara nda ti yɛn ŋguro ni ta lɛ mbaa waa ti ni paa joro yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","A pè sho naa fɔ: «Yoo kari we sa cagbɔgɔ naa sanŋgazo titɔnlɔwɔ wa kan wi go ki gbɔn wa yɛnŋɛlɛ na; jaŋgo we mɛgbɔgɔ ta, waga ka jaraga tara ti lagapyew.» ");
INSERT INTO dyi_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Sɛnwee piile pàa pye na ca konaa sanŋgazo titɔnlɔwɔ ŋa kanni, a Yawe Yɛnŋɛlɛ lì si tigi ma pan mberi wele. ");
INSERT INTO dyi_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","A lì sili yɛɛ pye fɔ: «Wele! Leele pe ni fuun pe yɛn cɛnlɛ nuŋgba na sɛnrɛ nuŋgba yuun. Ŋga pè lɛ na piin yɛɛn, ki wele! Koni, kala lo la se pe yɛgɛ pari pe nandanwa kapyege na. ");
INSERT INTO dyi_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ye pan we tigi, we sa pe sɛnrɛ ti piri, jaŋgo paga kaa ti nuru pe yɛɛ yeri naa.» ");
INSERT INTO dyi_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","A Yawe Yɛnŋɛlɛ lì si pe jaraga tara ti ni fuun ti ni ma pe wɔ wa ki laga ki ni. A pè si cagbɔgɔ ki kanwa pi yaga. ");
INSERT INTO dyi_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ko kì ti pe maa ki laga ki yinri Babɛli, katugu pa Yawe Yɛnŋɛlɛ làa leele pe sɛnrɛ ti piri wa ki laga ki na. Maga lɛ le ki laga ki na, a Yawe Yɛnŋɛlɛ lì si leele pe jaraga tara ti laga ki ni fuun ki na. ");
INSERT INTO dyi_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sɛmu wi setirige piile pe mɛrɛ ti nda. Sɛmu wìla ta yɛlɛ cɛnmɛ mɛɛ pinambyɔ se, a paa wi yinri Aripakisadi, tɔnŋgbɔɔ pi toroŋgɔlɔ, ki yɛlɛ shyɛn wolo li ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Aripakisadi seŋgɔlɔ, a Sɛmu wì si pye naa yɛlɛ cɛnmɛ kaŋgurugo (500), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Aripakisadi wo la ta yɛlɛ nafa ma yiri kɛ ma yiri kaŋgurugo, mɛɛ pinambyɔ se, a paa wi yinri Shela. ");
INSERT INTO dyi_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shela seŋgɔlɔ, a Aripakisadi wì si pye naa yɛlɛ cɛnmɛ tijɛrɛ ma yiri taanri (403), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Naa Shela wìla kaa ta yɛlɛ nafa ma yiri kɛ, a wì si pinambyɔ se, a paa wi yinri Hebɛri. ");
INSERT INTO dyi_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Hebɛri seŋgɔlɔ, a Shela wì si pye naa yɛlɛ cɛnmɛ tijɛrɛ ma yiri taanri (403), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Naa Hebɛri wìla kaa ta yɛlɛ nafa ma yiri kɛ ma yiri tijɛrɛ, a wì si pinambyɔ se, a paa wi yinri Pelɛgi. ");
INSERT INTO dyi_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelɛgi seŋgɔlɔ, a Hebɛri wì si pye naa yɛlɛ cɛnmɛ tijɛrɛ naa nafa ma yiri kɛ (430), ma pinambiile pele yɛgɛ se naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Naa Pelɛgi wìla kaa ta yɛlɛ nafa ma yiri kɛ, a wì si pinambyɔ se, a paa wi yinri Erewu. ");
INSERT INTO dyi_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Erewu seŋgɔlɔ, a Pelɛgi wì si pye naa yɛlɛ cɛnmɛ shyɛn ma yiri kɔlɔjɛrɛ (209), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Naa Erewu wìla kaa ta yɛlɛ nafa ma yiri kɛ ma yiri shyɛn, a wì si pinambyɔ se, a paa wi yinri Serugi. ");
INSERT INTO dyi_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serugi seŋgɔlɔ, a Erewu wì si pye naa yɛlɛ cɛnmɛ shyɛn ma yiri kɔlɔshyɛn (207), ma pinambiile pele yɛgɛ se naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Naa Serugi wìla kaa ta yɛlɛ nafa ma yiri kɛ, a wì si pinambyɔ se, a paa wi yinri Nahɔri. ");
INSERT INTO dyi_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahɔri seŋgɔlɔ, a Serugi wì si pye naa yɛlɛ cɛnmɛ shyɛn (200), ma pinambiile pele yɛgɛ se, naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naa Nahɔri wìla kaa ta yɛlɛ nafa ma yiri kɔlɔjɛrɛ, a wì si pinambyɔ se, a paa wi yinri Tera. ");
INSERT INTO dyi_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tera seŋgɔlɔ, a Nahɔri wì si pye naa yɛlɛ cɛnmɛ ma yiri kɛ ma yiri kɔlɔjɛrɛ (119), ma pinambiile pele yɛgɛ se naa sumborombiile ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Naa Tera wìla kaa ta yɛlɛ nafa taanri ma yiri kɛ, a wì si pinambiile se. Pe mɛrɛ ti nda: Abiramu, naa Nahɔri, konaa Aran. ");
INSERT INTO dyi_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera setirige piile pe mɛrɛ ti nda: Tera wìla Abiramu, naa Nahɔri konaa Aran se. A Aran wo si pinambyɔ wa se, a paa wi yinri Lɔti. ");
INSERT INTO dyi_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","A Aran wì si keli ma ku wi to Tera wi na wa tara nda pàa wi se, wa Uri ca, wa Kalide tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","A Abiramu wo naa Nahɔri pè si jɛɛlɛ pɔri, pàa pye na Abiramu jɔ wi yinri Sarayi, na Nahɔri jɔ wi yinri Milika. Milika wìla pye Aran sumborombyɔ. Aran wo wìla pye fun Zhisika wi to. ");
INSERT INTO dyi_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi wi sila pyɔ ta, katugu wi sila pye na siin. ");
INSERT INTO dyi_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","A Tera wì suu pinambyɔ Abiramu wi lɛ, naa wi pishyɛnwoo Lɔti wi ni, Aran wi pinambyɔ we, naa wi pijɔ Sarayi wi ni, Abiramu wi jɔ we. A pè si pinlɛ ma yiri wa Uri ca, wa Kalide tara, nɛɛ kee wa Kana tara. A pè si saa gbɔn wa Haran ca mɛɛ cɛn le. ");
INSERT INTO dyi_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera wi yinwege piliye yi ni fuun yìla pye yɛlɛ cɛnmɛ shyɛn ma yiri kaŋgurugo (205), a wì si ku wa Haran ca. ");
INSERT INTO dyi_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kona, a Yawe Yɛnŋɛlɛ lì sigi yo Abiramu wi kan ma yo fɔ: «Abiramu! Yiri laga ma tara, laga ma sege woolo pe sɔgɔwɔ, konaa ma to ca ki ni. Ma kari wa tara nda mi yaa naga ma na ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mi yaa duwaw ma na mbɔɔn pye cɛnlɛ gbenɛ to, mbɔɔn mɛgɛ ki pye ki gbɔgɔ. Lelɛgɛrɛ yaa ka duwaw ta ma kala na. ");
INSERT INTO dyi_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Leele mbele ka duwaw pye ma kan, mi yaa duwaw poro na. Leele mbele kɔɔn daŋga, mi yaa poro daŋga. Sege ŋga fuun ki yɛn laga tara na ki woolo pe yaa ka duwaw ta ma kala na.» ");
INSERT INTO dyi_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","A Abiramu wì si kari paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo maa kan we. Lɔti wìla pinlɛ Abiramu wi ni ma kari fun. Abiramu wi yirisanga wi ni wa Haran ca, kìla yala wì ta yɛlɛ nafa taanri ma yiri kɛ ma yiri kaŋgurugo. ");
INSERT INTO dyi_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","A wì suu jɔ Sarayi wo naa wi jɔnlɔ pyɔ Lɔti pe lɛ ma kari pe ni, naa kulolo mbele fuun wìla ta wa Haran ca pe ni, naa wi kɛɛ yaara ti ni fuun ti ni. A pè si kari wa Kana tara. ");
INSERT INTO dyi_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Naa pàa ka saa ye wa Kana tara, a pè siri pari ma saa gbɔn fɔ wa laga ŋga pe yinri Sishɛmu, fɔ wa More laga tigbɔgɔ ki na. Ki sanga wi ni Kana tara woolo pàa pye wa pe tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ko puŋgo na, a Yawe Yɛnŋɛlɛ lì si li yɛɛ naga Abiramu wi na, mɛɛ wi pye fɔ: «Ki tara nda to mi yaa kan ma setirige pyɔ wi yeri.» A Abiramu wì si saraga wɔsaga kan Yawe Yɛnŋɛlɛ li kan le ki laga ki na. ");
INSERT INTO dyi_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ko puŋgo na, a pè si yiri lema mɛɛ kari wa yanwira ti na. Ki yanwira ti yɛn wa Betɛli ca ki tanla, ma wa yɔnlɔ yirisaga yeri. Naa pàa ka saa gbɔn, a pè si paara yinrɛ ti sangasanga mari kankan, ma Betɛli ca ki yaga yɔnlɔ tosaga yeri, ma Ayi ca ki yaga yɔnlɔ yirisaga yeri. A wì si saraga wɔsaga ka kan naa Yawe Yɛnŋɛlɛ li kan, mali mɛgɛ ki yeri mali gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ko puŋgo na, a Abiramu wì si yiri lema, nɛɛ tanri na cɛɛn na kee wa Negɛvu tara ti yeri. ");
INSERT INTO dyi_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Fuŋgo kà la to wa Kana tara ti ni. A Abiramu wì si yiri ma kari wa Ezhipiti tara mbe sa cɛn wa wagati jɛnri ni, katugu ki fuŋgo kìla gbɔgɔ fɔ ma toro. ");
INSERT INTO dyi_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Naa pàa ka saa yɔngɔ Ezhipiti tara ti ni, a wì suu jɔ Sarayi wi pye fɔ: «Wele, mìgi jɛn ma yo ma yɛn ma yɔn fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Na Ezhipiti tara woolo pe kɔɔn yan, pe yaa ki jɛn mbe yo mboro ma yɛn na jɔ we, pa pe yaa na gbo mbɔɔn yaga. ");
INSERT INTO dyi_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ki kala na, mi yɛn nɔɔ yɛnri, na pe kɔɔn yewe, maga yo ma pe kan fɔ: ‹Na jɔnlɔ sumboro wi mboro›, jaŋgo pe ta panla yigi jɛŋgɛ ma kala na, mbe koro yinwege na.» ");
INSERT INTO dyi_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Naa Abiramu wìla ka saa gbɔn wa Ezhipiti tara, a Ezhipiti tara fɛnnɛ pè suu jɔ Sarayi wi yan wi yɔn fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","A Farawɔn wi legbɔɔlɔ pèle si jɛlɛ wi yan mɛɛ saa wi tanga ma Farawɔn wi kan. A pè si kari jɛlɛ wi ni wa Farawɔn wi go. ");
INSERT INTO dyi_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Farawɔn wì si kajɛŋgɛ pye ma Abiramu wi kan wi jɔ wi kala na. A wì si simbaala kan wi yeri, naa sikaala, naa nɛrɛ, naa kulonambala naa kulojaala, naa sofile jɛɛlɛ naa nambala, konaa yɔngɔmɛye ni. ");
INSERT INTO dyi_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ɛɛn fɔ, a Yawe Yɛnŋɛlɛ lì si jɔlɔgɔ gbɔgɔ wa Farawɔn wo naa wi go woolo pe na, Abiramu wi jɔ Sarayi wi kala na. ");
INSERT INTO dyi_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","A Farawɔn wì si Abiramu wi yeri maa pye fɔ: «Yiŋgi mà pye na na yɛɛn? Ki pye mɛlɛ, mɛɛ sigi yo na kan mbe yo fɔ: ‹Ma jɔ wi?› ");
INSERT INTO dyi_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Kì pye mɛlɛ, a mà silan pye ma yo ma jɔnlɔ sumboro wi? Ko kì ti, mi yɛn naa jate mboo lɛ mboo pye na jɔ. Ɛɛn fɔ, koni, ma jɔ wi ŋa! Wi lɛ maa kee wi ni.» ");
INSERT INTO dyi_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","A Farawɔn wì si konɔ kan wi tunmbyeele pe yeri ma yo pe sa Abiramu wi torogo poo yirige wa Ezhipiti tara ti ni, wo naa wi jɔ, naa wi kɛɛ yaara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Kona, a Abiramu wì si yiri wa Ezhipiti tara, ma sɔngɔrɔ wa Negɛvu tara ti yeri, wo naa wi jɔ wi ni, naa yaara nda fuun wìla ta ti ni. Lɔti wìla pinlɛ ma kari wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Yarijɛndɛ lɛgɛrɛ la pye Abiramu wi yeri fɔ jɛŋgɛ. Wìla yaayoro lɛgɛrɛ ta naa penjagbɔrɔ ni, naa tɛ lɛgɛrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A wi nɛɛ tanri na toro lara lara, ma yiri wa Negɛvu tara ti yeri ma saa gbɔn wa Betɛli ca ki na. Wìla keli maa paraga go ki kan ma cɛn wa Betɛli ca naa Ayi ca sɔgɔwɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","A wì si saa gbɔn wa saraga wɔsaga ŋga wìla kan faa ki na. A Abiramu wì si Yawe Yɛnŋɛlɛ li mɛgɛ ki yeri wa, mali gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abiramu wi tangayɛnlɛ Lɔti we, yaayoro lɛgɛrɛ la pye wi yeri fun, to ti yɛn simbaala, naa sikaala, naa nɛrɛ, konaa paara yinrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ki tara ti sila pye ma gbɔgɔ, tìla kologo pe na, ki kala na, pe sila ya mbe pinlɛ mbe cɛn laga nuŋgba; katugu pe kɛɛ yaara tìla lɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Abiramu wi yaayoro kɔnrifɛnnɛ poro naa Lɔti woolo pe ni, pè si kaa win. Ko sanga wo ni, Kana tara woolo poro naa Perɛzi cɛnlɛ woolo pàa pye ma cɛn wa ki tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","A Abiramu wì si Lɔti wi pye fɔ: «Kii daga mi naa mboro ni kiti mbe ye we sɔgɔwɔ, kii daga kiti mbe ye we yaayoro kɔnrifɛnnɛ pe sɔgɔwɔ fun, katugu we yɛn sege nuŋgba mi naa mboro ni. ");
INSERT INTO dyi_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tara ti ni fuun ti nda ma yɛgɛ sɔgɔwɔ. Pan we laga we yɛɛ na. Na ma ka kee kamɛŋgɛ kɛɛ ki na, pa mi yaa kari kalige kɛɛ ki na. Na ma ka sila kee kalige kɛɛ ki na, pa mi yaa kari kamɛŋgɛ kɛɛ ki na.» ");
INSERT INTO dyi_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","A Lɔti wì suu yɛgɛ ki yirige ma wele, mɛɛ Zhuridɛn gbaan funwa laga ŋga kìla pye tɔnmɔ lɛgɛrɛ ni ko wɔ, ko ŋga kìla pye paa Ezhipiti tara ti yɛn. Sanga ŋa ni Yawe Yɛnŋɛlɛ li fa Sodɔmu naa Gomɔri cara ti tɔngɔ, kìla yɔn ma pye paa Yɛnŋɛlɛ li naŋgɔ kɔlɔgɔ yɛn, ma kari fɔ wa Sowari ca ki yeri. ");
INSERT INTO dyi_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kì kaa pye ma, a Lɔti wì si Zhuridɛn tara to wɔ, mɛɛ kari ma saa cɛn wa yɔnlɔ yirisaga yeri. Pa pàa laga pe yɛɛ na yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","A Abiramu wo si koro wa Kana tara. A Lɔti wo si saa cɛn wa Zhuridɛn gbaan funwa laga falafala ki cara ti tanla, mɛɛ kari ma saa wi paara yinrɛ ti sanga mari kankan wa Sodɔmu ca ki tanla. ");
INSERT INTO dyi_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodɔmu ca woolo pàa pye ma pe fɔ jɛŋgɛ, na kapere tugbɔɔrɔ piin Yawe Yɛnŋɛlɛ li na. ");
INSERT INTO dyi_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Naa Lɔti wìla kaa laga Abiramu wi na ma, a Yawe Yɛnŋɛlɛ lì si Abiramu wi pye fɔ: «Mbɔɔn ta le laga ŋga ma yɛn, ma yɛgɛ ki yirige ma yɔnlɔparawa kamɛŋgɛ kɛɛ naa yɔnlɔparawa kalige kɛɛ ki wele, ma yɔnlɔ yirisaga naa yɔnlɔ tosaga ki wele. ");
INSERT INTO dyi_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ma yɛgɛ ki yɛn tara nda fuun na, mi yaa ti kan mboro naa ma setirige piile ye yeri wagati wi ni fuun ni. ");
INSERT INTO dyi_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mi yaa kɔɔn setirige piile pe pye pe lɛgɛ jɛŋgɛ, paa yɛgɛ ŋga na lere se ya mbe taambugɔ ki jiri we. ");
INSERT INTO dyi_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Yiri ma tara ti yanri, mari titɔnlɔwɔ naa ti gbemɛ pi wele, katugu mi yaa ti kan ma yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","A Abiramu wì suu paara yinrɛ ti kɔlɔgi lema, mɛɛ kari ma saa cɛn wa Mamire tigbɔrɔ laga ki ni, wa Eburɔn ca ki tanla. A wì si saraga wɔsaga kan le Yawe Yɛnŋɛlɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ma si yala, Sineyari tara wunlunaŋa Amirafɛli wo naa Elasari ca wunlunaŋa Ariyɔki, naa Elamu ca wunlunaŋa Kedɔrilawomɛri konaa Goyimu ca wunlunaŋa Tideyali pe sanga wi na, ");
INSERT INTO dyi_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","pè si kaa malaga gbɔn Sodɔmu ca wunlunaŋa Bera wi ni, naa Gomɔri ca wunlunaŋa Birisha, naa Adima ca wunlunaŋa Shineyabu, naa Zeboyimu ca wunlunaŋa Shemebɛri konaa wunlunaŋa Bela pe ni. Bela mɛgɛ nuŋgba koyi ŋga fun Sowari. ");
INSERT INTO dyi_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ki wunlumbolo pe ni fuun pè si pe yɛɛ gbogolo wa Sidimu gbunlundɛgɛ ki ni. Nala Kɔgɔje kuwo wìgi gbunlundɛgɛ ki shɔ. ");
INSERT INTO dyi_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Pàa pe yɛɛ tirige wunlunaŋa Kedɔrilawomɛri wi kan fɔ ma saa gbɔn yɛlɛ kɛ ma yiri shyɛn. Ɛɛn fɔ, yɛlɛ kɛ ma yiri taanri wolo li ni, a pè si yiri ma je wi na. ");
INSERT INTO dyi_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ki yɛlɛ kɛ ma yiri tijɛrɛ wolo li ni, wunlunaŋa Kedɔrilawomɛri wo naa wunlumbolo mbele pàa pye yɔn finliwɛ na wi ni, pè si kari ma saa malaga gbɔn Erefayi cɛnlɛ woolo pe ni, ma ya pe ni wa Ashitarɔti Karinayimu ca, konaa ma ya Zuzimu cɛnlɛ woolo pe ni wa Hamu tara, naa Emimu cɛnlɛ woolo pe ni wa Shave Kiriyatayimu ca funwa laga falafala ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Pàa Hɔri cɛnlɛ woolo poro ya wa pe yɛɛra tara ti ni, wa Seyiri yanwira ti na, ma pe purɔ fɔ ma saa gbɔn wa Ɛli Paran laga ki ni, wa gbinri wi tanla. ");
INSERT INTO dyi_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ko puŋgo na, a pè si sɔngɔrɔ ma pan wa Eni Mishipa ca, ki ca pege yinri naa Kadɛshi. A pè si malaga ki gbɔn Amalɛki setirige piile pe ni ma ya pe ni wa pe tara ti lagapyew. Pàa ya Amɔri cɛnlɛ woolo pe ni fun, poro mbele pàa pye ma cɛn wa Hazazɔn Tamari ca. ");
INSERT INTO dyi_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kona, a Sodɔmu ca wunlunaŋa, naa Gomɔri ca wunlunaŋa, naa Adima ca wunlunaŋa, naa Zeboyimu ca wunlunaŋa wo naa Bela ca wunlunaŋa wi ni, pè si pe maliŋgbɔɔnlɔ pe yirige. Bela ca pege yinri naa Sowari. A pè si saa yere malinjɛ na wa Sidimu gbunlundɛgɛ ki ni ");
INSERT INTO dyi_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","mbe malaga gbɔn Elamu ca wunlunaŋa Kedɔrilawomɛri wi ni, Sineyari tara wunlunaŋa Amirafɛli konaa Elasari ca wunlunaŋa Ariyɔki pe ni. Ki wunlumbolo tijɛrɛ poro naa wunlumbolo kaŋgurugo poro pàa to pe yɛɛ na ma malaga ki gbɔn. ");
INSERT INTO dyi_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Pàa pye na ŋguro jowɔrɔ ti woo were nda ni, tìla pye ma lɛgɛ wa Sidimu gbunlundɛgɛ ki ni. A Sodɔmu ca naa Gomɔri ca wunlumbolo pè si fe ma toori wa ki were ta ni. Mbele pàa fe ma shɔ, a poro si saa lara wa yanwira ti na. ");
INSERT INTO dyi_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Mbele pàa malaga ki gbɔn ma ya, pè si Sodɔmu ca naa Gomɔri ca yarijɛndɛ ti ni fuun, naa pe yaakara ti ni fuun ti koli ma kari ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","A pè si Abiramu wi naa Lɔti wo naa wi kɛɛ yaara ti koli ma kari ti ni. Lɔti wìla pye ma cɛn wa Sodɔmu ca ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","A naŋa wà si fe ma shɔ, mɛɛ saa ki sɛnrɛ ti yo Eburuye naŋa Abiramu wi kan. Abiramu wìla pye ma cɛn wa Amɔri cɛnlɛ woolo naŋa Mamire wi tigbɔrɔ ti sɔgɔwɔ. Mamire naa wi nɔsepyɔ Ɛshikɔli, naa Anɛri konaa Abiramu ni, pàa pye yɔn finliwɛ na. ");
INSERT INTO dyi_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Naa Abiramu wìla kaa ki logo ma yo pàa wi naa Lɔti wi yigi ma kari wi ni, Abiramu wi kulolo mbele pàa se wa wi go, a wì si mbele kotogo la pye pe ni, pe cɛnmɛ taanri ma yiri kɛ ma yiri kɔlɔtaanri (318) wɔ. Wo naa poro ni, pè si pe maliŋgbɔnyaara ti lɛ, mɛɛ taga pe puŋgo na, na pe tuuro tɔnri fɔ wa Dan tara. ");
INSERT INTO dyi_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ki yembinɛ li ni, a Abiramu wì suu maliŋgbɔɔnlɔ pe walagi walagi ma saa to ki wunlumbolo pe na, mɛɛ ya pe ni ma pe purɔ fɔ wa Shoba ca, wa Damasi ca ki kamɛŋgɛ kɛɛ ki na. ");
INSERT INTO dyi_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","A wì si sɔngɔrɔ ma pan yarijɛndɛ nda fuun pàa koli ti ni, konaa wi naa Lɔti wi ni, naa wi kɛɛ yaara, naa jɛɛlɛ poro naa leele sanmbala pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Naa Abiramu wìla kaa ya Kedɔrilawomɛri naa wunlumbolo mbele pàa yɔn finliwɛ le wi ni pe ni, ma sɔngɔrɔ na paan, a Sodɔmu ca wunlunaŋa wì si pan maa fili wa Shave gbunlundɛgɛ ki ni. Ko ki yɛn wunlunaŋa wi gbunlundɛgɛ ye. ");
INSERT INTO dyi_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salɛmu ca wunlunaŋa Mɛlikisedɛki wì si pan buru naa duvɛn ni. Wìla pye Yɛnŋɛlɛ na yaara ti ni fuun ti go na li saraga wɔfɔ. ");
INSERT INTO dyi_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","A wì si duwaw pye Abiramu wi kan ma yo fɔ: «Yɛnŋɛlɛ na yaara ti ni fuun ti go na, li duwaw ma na, lo na lì naayeri wo naa tara ti da! ");
INSERT INTO dyi_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Sɔnmɔ yɛn Yɛnŋɛlɛ na yaara ti ni fuun ti go na li woo, lo na lɔ̀ɔn juguye pe le ma kɛɛ we!» A Abiramu wì si yaara nda fuun wìla koli ti walisaga kɛ wogo ki kan Mɛlikisedɛki wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","A Sodɔmu ca wunlunaŋa wì sigi yo Abiramu wi kan ma yo fɔ: «Leele poro kan na yeri ma yarijɛndɛ to lɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","A Abiramu wì suu pye fɔ: «Mìlan kɛɛ ki yirige ma wugu Yawe Yɛnŋɛlɛ na yaara ti ni fuun ti go na li na, lo na lì naayeri wo naa tara ti da. ");
INSERT INTO dyi_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Mì wugu mɔɔ kan fɔ yaraga ŋga fuun ki yɛn ma wogo, mi se ka lɛ, ali sa sun jese pyɔ nuŋgba nakoma sawiga maŋga; jaŋgo maga ka ta mbe yo mì Abiramu wi pye yarijɛndɛ tafɔ. ");
INSERT INTO dyi_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mi se yaraga ko ka shɔ na yɛɛ wogo, kaawɔ na woolo pè yaakara nda ka to. Na pinlɛyɛɛnlɛ Anɛri, naa Ɛshikɔli, naa Mamire poro na, poro mbe pe tasaga ki lɛ pe yɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ki kagala ke puŋgo na, a Yawe Yɛnŋɛlɛ lì si para naa Abiramu wi ni yariyanra ni, maa pye fɔ: «Abiramu, maga ka fyɛ yaraga ka kpɛ na. Mi yɛn ma go sigefɔ. Mi yaa ka tɔnli gbɔɔ kan ma yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","A Abiramu wì sho fɔ: «We Fɔ, Yawe Yɛnŋɛlɛ, yiŋgi tɔnli wi yɛn wa, na maga yaara to kan na yeri, mbe sigi ta pyɔ wo wa woro na yeri we? Na kɔrɔgɔ lifɔ wo wi yɛn Damasi ca fɛnnɛ naŋa Eliyezɛri we.» ");
INSERT INTO dyi_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","A Abiramu wì sho naa fɔ: «Wele, mɛɛ setirige piile kan na yeri. Na go tunmbyee Eliyezɛri ŋa wì yiri wa Damasi ca, wo wi yaa ka pye na kɔrɔgɔ lifɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","A Yawe Yɛnŋɛlɛ lì suu pye fɔ: «Ayoo, wo ma wi yaa pye ma kɔrɔgɔ lifɔ we. Ɛɛn fɔ, ma yɛɛra pisee wi yaa pye ma kɔrɔgɔ lifɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","A lì si Abiramu wi yirige wa funwa na, ma suu pye fɔ: «Ma yɛgɛ ki yirige wa naayeri ma wele! Wɔnŋgɔlɔ ke jiri na ma mbe ya we» A lì suu pye fɔ: «Pa ma setirige piile pe yaa ka lɛgɛ ma.» ");
INSERT INTO dyi_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","A Abiramu wì si taga Yawe Yɛnŋɛlɛ li na. Ki kala na, a Yawe Yɛnŋɛlɛ li nɛɛ wi jate paa lesinŋɛ yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","A we Fɔ wì suu pye naa fɔ: «Muwi mi yɛn Yawe Yɛnŋɛlɛ, na lɔ̀ɔn yirige wa Uri ca, wa Kalide tara, jaŋgo mbege tara nda ma yɛn laga ti ni, ti kan ma yeri, ti pye ma woro.» ");
INSERT INTO dyi_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","A Abiramu wì sili yewe ma yo: «We Fɔ, Yawe Yɛnŋɛlɛ, yiŋgi ki yaa ki naga na na mbe yo mi yaa kaga tara nda ti ta, ti pye na woro?» ");
INSERT INTO dyi_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","A we Fɔ wì suu pye fɔ: «Pan mala kan nasumboro ni, ŋa wì ta yɛlɛ taanri, naa sikanɔ ŋa wì ta yɛlɛ taanri, naa simbapɔlɔ ŋa wì ta yɛlɛ taanri, konaa ketenɛ nuŋgba naa jɛndɛtuwa yirifɔnŋɔ nuŋgba ni.» ");
INSERT INTO dyi_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","A Abiramu wì si pan ki yaayoro ti ni, mɛɛ ti walagi shyɛnzhyɛn wa ti nandogomɔ, mɛɛ ti waara ti tɛgɛtɛgɛ mari yɛgɛ wa ti yɛɛ yeri. Ɛɛn fɔ, wi sila sannjɛgɛlɛ koro walagi. ");
INSERT INTO dyi_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kara kasannjɛrɛ nda ti maa kara kaa tì si tigi ma to ki yaayoro kuro ti na. Ɛɛn fɔ, a Abiramu wì siri purɔ. ");
INSERT INTO dyi_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Naa yɔnlɔ kìla kaa na tuun, a wɔnlɔwɔ gbɔɔ si Abiramu wi yigi, a diwi gbɔɔ fyɛrɛ woo wà si ye wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","A we Fɔ wì si Abiramu wi pye fɔ: «Ki daga maga jɛn jɛŋgɛ fɔ ma setirige piile pe yaa ka pye nambannjɛɛnlɛ tara ta yɛgɛ ni, mbe pye wa ki leele pe kulolo. Pe yaa ka pe jɔlɔ fɔ sa gbɔn yɛlɛ cɛnmɛ tijɛrɛ (400). ");
INSERT INTO dyi_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ɛɛn fɔ, pe yaa ka pye kulolo tara nda ni, mi yaa ka ki leele pe jɔlɔ. Ko puŋgo na, ma setirige piile pe yaa ka yiri wa mbe pan yarijɛndɛ lɛgɛrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mboro wo na, ma lelɛwɛ pi yaa yɔn, ma yaa ku yɛyinŋge na, pee ka jɛn pɔɔn le. ");
INSERT INTO dyi_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ma setirige piile pe sɛrɛ woolo poro yirisaga tijɛrɛ wogo ko ki yaa ka sɔngɔrɔ laga; katugu Amɔri cɛnlɛ woolo pe kambasinŋge ŋga paa piin, ki fa gbɔn wa ki gbɔnsaga ki na gbɛn, mbe pe purɔ mbe pe yirige wa pe tara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Naa yɔnlɔ kìla kaa to, a diwi gbɔɔ wà si ye. A kasɔn gbɔgɔ kà si yiri wa, nɛɛ wirige kɔɔn, na yiin, mɛɛ pan ma toro wa yaayoro waara ti sɔgɔwɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ki pilige ki ni, a Yawe Yɛnŋɛlɛ lì si yɔn finliwɛ le Abiramu wi ni, mɛɛ wi pye fɔ: «Mi yɛn naga tara nda ti kaan ma setirige piile pe yeri, mbege lɛ wa Ezhipiti gbaan wi na fɔ sa gbɔn wa gbaan gbeŋɛ wi na, Efirati gbaan we. ");
INSERT INTO dyi_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ki tara to ti yɛn Keni cɛnlɛ woolo, naa Kenazi cɛnlɛ woolo, naa Kadimoni cɛnlɛ woolo, ");
INSERT INTO dyi_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","naa Hɛti cɛnlɛ woolo, naa Perɛzi cɛnlɛ woolo, naa Erefayi cɛnlɛ woolo, ");
INSERT INTO dyi_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","naa Amɔri cɛnlɛ woolo, naa Kana tara woolo, naa Girigasi cɛnlɛ woolo konaa Zhebusi cɛnlɛ woolo pe tara re.» ");
INSERT INTO dyi_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abiramu wi jɔ Sarayi wi sila pyɔ se wi kan. Ɛɛn fɔ, kulojɔ wà la pye wi yeri, pàa pye naa yinri Agari. Ezhipiti tara fɛnnɛ woo lawi. ");
INSERT INTO dyi_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","A Sarayi wì si Abiramu wi pye fɔ: «Wele, Yawe Yɛnŋɛlɛ lii yere ki na mbe pyɔ se. Ki kala na, mila ma yɛnri, kari ma sa sinlɛ wa na kulojɔ wi ni; kana pa mbe piile ta wi kala na.» A Abiramu wì si yere wi jɔ wi sɛnrɛ ti na. ");
INSERT INTO dyi_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kì kaa pye ma, a Sarayi wì suu kulojɔ, Ezhipiti tara fɛnnɛ woo Agari, wi yigi maa kan wi pɔlɔ Abiramu wi yeri jɛlɛ. Kìla yala Abiramu wì ta yɛlɛ kɛ wa Kana tara. ");
INSERT INTO dyi_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","A Abiramu wì si ye Agari wi kɔrɔgɔ maa jɛn jɛlɛ, a wì si kugbɔ lɛ. Naa Agari wìla kaa wi yɛɛ yan kugbɔ ni, wi sila pye na wi tafɔ jɛlɛ Sarayi wi jate naa. ");
INSERT INTO dyi_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kona, a Sarayi wì si Abiramu wi pye fɔ: «Tɛgɛlɛ na paa na tegele, li sɔngɔrɔ ma na. Ki yɛn kaselege fɔ muwi mìlan kulojɔ wi kan ma yeri jɛlɛ. Ɛɛn fɔ, maga lɛ wùu yɛɛ yan kugbɔ ni, wi woro nala jate naa. Yawe Yɛnŋɛlɛ li kiti kɔn mi naa mboro we sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","A Abiramu wì si Sarayi wi pye fɔ: «Mboro kulojɔ wi. Wi yɛn ma cɛnwɛ na. Kala na kɔɔn ndanla, ta lo piin wi na.» Kì kaa pye ma, a Sarayi wi nɛɛ Agari wi jɔlɔ jɛŋgɛ, fɔ a wì saa fe ma kari wa gbinri wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","A Yawe Yɛnŋɛlɛ li mɛrɛgɛ wì si pan ma Agari wi yan pulugo ka tanla wa Shuri ca kologo ki na, ");
INSERT INTO dyi_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","mɛɛ wi yewe ma yo fɔ: «Sarayi kulojɔ Agari, ma yiri se? Ma nɛɛ kee se?» A Agari wì suu pye fɔ: «Mi yɛn na fee na tafɔ jɛlɛ Sarayi wo yɛgɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","A Yawe Yɛnŋɛlɛ li mɛrɛgɛ wì suu pye fɔ: «Sɔngɔrɔ wa ma tafɔ jɛlɛ wi yeri, mɔɔ yɛɛ tirige wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yawe Yɛnŋɛlɛ li yaa kɔɔn setirige piile pe pye pe lɛgɛ, fɔ lere se ka ya mbe pe jiri.» ");
INSERT INTO dyi_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","A Yawe Yɛnŋɛlɛ li mɛrɛgɛ wì suu pye naa fɔ: «Wele, ma yɛn kugbɔ ni; ma yaa ka pinambyɔ se, mboo mɛgɛ taga Ishimayɛli; katugu we Fɔ wɔ̀ɔn jɔlɔgɔ gbelege ki logo. ");
INSERT INTO dyi_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ma pinambyɔ wi yaa ka pye paa yan sofile yɛn. Wi yaa kaa wiin leele pe ni fuun pe ni, leele pe ni fuun pe yaa kaa wiin wi ni. Wi yaa ka cɛn mbe lali wi woolo pe ni fuun pe ni.» ");
INSERT INTO dyi_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","A Agari wi nɛɛ wi yɛɛ yewe na yuun fɔ: «Ŋa wila na yaan, wo mì yan kaselege yɛɛn gbari?» A wì si mɛgɛ taga Yawe Yɛnŋɛlɛ na làa para wi ni li na, nali yinri «Yɛnŋɛlɛ na laa na yaan.» ");
INSERT INTO dyi_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ki kala na, kɔlɔ ŋa wi yɛn wa Kadɛshi ca naa Berɛdi ca sɔgɔwɔ pi ni, pe maa wi yinri «Ŋa wi yɛn wee nala yaan wi kɔlɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","A Agari wì si pinambyɔ se Abiramu wi kan. A Abiramu wì si pinambyɔ ŋa Agari wìla se wi mɛgɛ taga naa yinri Ishimayɛli. ");
INSERT INTO dyi_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Agari wìla Ishimayɛli wì se Abiramu wi kan sanga ŋa ni, kìla yala Abiramu wi ta yɛlɛ nafa tijɛrɛ ma yiri kɔgɔlɔni. ");
INSERT INTO dyi_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Naa Abiramu wìla kaa ta yɛlɛ nafa tijɛrɛ ma yiri kɛ ma yiri kɔlɔjɛrɛ, a Yɛnŋɛlɛ lì sili yɛɛ naga wi na, ma suu pye fɔ: «Muwi mi yɛn Yawe Yɛnŋɛlɛ na yawa pi ni fuun fɔ. Ti ma yinwege ki pye sinŋge na yɛgɛ na, ma pye jɛrɛgisaga fu. ");
INSERT INTO dyi_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mi yaa na yɔn finliwɛ pi le ma ni, mbɔɔn setirige piile pe pye pe lɛgɛ fɔ jɛŋgɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","A Abiramu wì si to maa yɛgɛ ki jiile wa tara mbe Yɛnŋɛlɛ li gbɔgɔ. A Yɛnŋɛlɛ lì suu pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Na yɔn finliwɛ mba mì le ma ni pi mba: ‹Ma yaa ka pye cɛngɛlɛ lɛgɛrɛ to. ");
INSERT INTO dyi_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Pe sɔɔn yeri naa Abiramu, ɛɛn fɔ, pe yaa lɔɔn yinri Abirahamu, katugu mi yaa ma pye cɛngɛlɛ lɛgɛrɛ tɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mi yaa ma pye sevɔ. Cɛngɛlɛ yaa ka yiri wa ma ni; wunlumbolo yaa ka yiri wa ma ni. ");
INSERT INTO dyi_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Na yɔn finliwɛ pi yaa koro mi naa mboro sɔgɔwɔ, naa ma setirige piile pe sɔgɔwɔ, konaa ma setirige piile mbele fuun pe yaa ka yiri ma puŋgo na pe sɔgɔwɔ. Ki yɔn finliwɛ pi yɛn kɔsaga fu, fɔ mi yaa ka pye ma Yɛnŋɛlɛ, naa ma setirige piile pe Yɛnŋɛlɛ mboro puŋgo na. ");
INSERT INTO dyi_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ma yɛn ma cɛn laga Kana tara nda ni, mi yaa ti ni fuun ti kan ma yeri, konaa ma setirige piile pe yeri, ti pye pe woro fɔ sanga pyew mboro puŋgo na. Mi yaa ka pye pe Yɛnŋɛlɛ.› » ");
INSERT INTO dyi_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","A Yɛnŋɛlɛ lì si Abirahamu wi pye naa fɔ: «Mboro wo na, na yɔn finliwɛ pi yigi, mboro naa ma setirige piile mbele fuun pe yaa ka yiri ma puŋgo na pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ye yaa na yɔn finliwɛ mba yigi, mi naa mboro sɔgɔwɔ, naa ma setirige piile mbele fuun pe yaa ka yiri ma puŋgo na pe sɔgɔwɔ, pi mba: ‹Yoro mbele fuun ye yɛn nambala, ye kɛnrɛkɛnrɛ. ");
INSERT INTO dyi_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ye yaa kɛnrɛkɛnrɛ, ko ki yaa pye yɔn finliwɛ pi tɛgɛrɛ re mi naa yoro sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ye pinambiile pe ni fuun pe daga mbe kɛnrɛkɛnrɛ pilige kɔlɔtaanri wogo ki na pe seŋgɔlɔ; pa ki yaa la piin ma, ma setirige piile mbele fuun pe yaa ka yiri pe na, sanga wi ni fuun ni; mbe pinlɛ kulolo mbele fuun pè se wa ma go pe ni, nakoma mbele fuun mà lɔ penjara ni cɛngɛlɛ kele yeri, pe si woro ma cɛnlɛ woolo. ");
INSERT INTO dyi_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kulo ŋa wì se wa ma go konaa ŋa mà lɔ, pe daga mbe kɛnrɛkɛnrɛ. Na yɔn finliwɛ pi tɛgɛrɛ ti yaa pye wa ye witire ti na mbege naga fɔ pi yɛn yɔn finliwɛ mba pi yɛn kɔsaga fu. ");
INSERT INTO dyi_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Naŋa ŋa fuun wii kɛnrɛkɛnrɛ, ye daga mboo purɔ mboo wɔ ye sɔgɔwɔ, katugu wìlan yɔn finliwɛ pi jɔgɔ.› » ");
INSERT INTO dyi_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","A Yɛnŋɛlɛ lì si Abirahamu wi pye fɔ: «Maga kɔɔn jɔ wi yeri naa Sarayi, ɛɛn fɔ, koni wi mɛgɛ koyi ŋga Sara. ");
INSERT INTO dyi_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mi yaa duwaw wi na, mbe pinambyɔ kan ma yeri wi fanŋga na. Mi yaa duwaw wi na mboo pye cɛngɛlɛ lɛgɛrɛ nɔ. Cɛngɛlɛ ke wunlumbolo yaa ka yiri wa wi setirige ki ni.» ");
INSERT INTO dyi_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","A Abirahamu wì si to maa yɛgɛ ki jiile wa tara, ma tɛgɛ, mɛɛ ki yo wa wi nawa fɔ: «Lere ŋa wì yɛlɛ cɛnmɛ ta, wo mbe ya mbe pyɔ se mɛlɛ? Sara fun wì ta yɛlɛ nafa tijɛrɛ ma yiri kɛ, wo mbe ya mbe pyɔ se mɛlɛ?» ");
INSERT INTO dyi_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","A Abirahamu wì si Yɛnŋɛlɛ li pye fɔ: «Ki yaga Ishimayɛli wi koro yinwege na ma yɛgɛ sɔgɔwɔ, ko yaa yala na ni ma.» ");
INSERT INTO dyi_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ɛɛn fɔ, a Yɛnŋɛlɛ lì sho fɔ: «Taga ki na, ma jɔ Sara wi yaa pinambyɔ se ma kan, maa mɛgɛ ki taga Izaki. Mi yaa ka koro yɔn finliwɛ na wi ni, yɔn finliwɛ mba pi yaa pye kɔsaga fu; mbe koro yɔn finliwɛ na wi setirige piile pe ni wo puŋgo na. ");
INSERT INTO dyi_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ishimayɛli wo na, mɔ̀ɔ yɛnrɛwɛ pi logo fun wi kanŋgɔlɔ. Mi yaa duwaw wi na, mboo pye sevɔ, mboo setirige piile pe pye pe lɛgɛ fɔ jɛŋgɛ. Wi yaa ka kundigile kɛ ma yiri shyɛn se. Mi yaa kaa pye cɛnlɛ gbenɛ tɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ɛɛn fɔ, mi yaa koro yɔn finliwɛ na Izaki wi ni, Sara wi yaa pinambyɔ ŋa se yelapanna anmɛ yɛgɛ we.» ");
INSERT INTO dyi_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Naa Yɛnŋɛlɛ làa kaa para Abirahamu wi ni ma kɔ, a lì si yiri ma kari wa naayeri maa toro le. ");
INSERT INTO dyi_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ki pilige nuŋgba ki ni, Abirahamu wi pinambyɔ Ishimayɛli wo naa kulolo mbele fuun pàa se wa wi go, naa mbele fuun pàa lɔ, nambala mbele fuun pàa pye wa wi go, a Abirahamu wì si pe ni fuun pe kɛnrɛkɛnrɛ ma yala Yɛnŋɛlɛ làa ŋgasele na yo maa kan li ni. ");
INSERT INTO dyi_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abirahamu wìla kɛnrɛkɛnrɛ fun ma yala wì ta yɛlɛ nafa tijɛrɛ ma yiri kɛ ma yiri kɔlɔjɛrɛ. ");
INSERT INTO dyi_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Wi pinambyɔ Ishimayɛli wìla kɛnrɛkɛnrɛ wi yɛlɛ kɛ ma yiri taanri wolo lo ni. ");
INSERT INTO dyi_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Wo naa wi pinambyɔ Ishimayɛli wi ni, pàa kɛnrɛkɛnrɛ pilige nuŋgba ki ni, ");
INSERT INTO dyi_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","naa nambala mbele fuun pàa pye wa wi go pe ni. Kulolo mbele fuun pàa se wa wi go, naa mbele fuun pàa lɔ cɛngɛlɛ kele yɛgɛ yeri, wo naa poro ni pàa kɛnrɛkɛnrɛ pilige nuŋgba ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ko puŋgo na, a Yawe Yɛnŋɛlɛ lì sili yɛɛ naga naa Abirahamu wi na wa Mamire tigbɔrɔ ti tanla. Wìla pye ma cɛn wa wi paraga go yeyɔngɔ ki na sɔnlɔ ŋgbanga ki na. ");
INSERT INTO dyi_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A wì suu yɛgɛ ki yirige ma wele, mɛɛ nambala taanri yan yeresaga wi yɛɛ tanla. Pe yanŋgɔlɔ, a wì si yiri le yeyɔngɔ ki na, mɛɛ fe ma saa pe fili, ma fɔli ma pe shari ma pe gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","A wì sho fɔ: «Na tafɔ, ndɛɛ ki pye ye mbe ja yɛnlɛ mbe koro na mi ŋa ye kulonaŋa na tanla jɛnri, ki mbe ja pye gbɔgɔwɔ ni na yeri. ");
INSERT INTO dyi_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ye yere pe pan tɔnmɔ jɛnri ni pe ye tɔɔrɔ ti jogo. Ye cɛn ye wogo wa tige ŋga ki yinmɛ pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mi yaa pan yaakara jɛnri ni ye kan yeri ka, jaŋgo ye fanŋga ta. Ko puŋgo na, yee la kee wa ye karisaga, katugu ko kala na Yɛnŋɛlɛ lìgi pye, a yè toro laga mi ŋa ye kulonaŋa na yeri.» A pè suu pye fɔ: «Ki pye paa yɛgɛ ŋga na màga yo.» ");
INSERT INTO dyi_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","A Abirahamu wì si fyɛɛlɛ ma sɔngɔrɔ wa paraga go, mɛɛ Sara wi pye fɔ: «Fyɛɛlɛ ma tiwiyaraga ki yɛnlɛ taanri tiwi farini muwɛ pi ni, maa gbɔn ma wɔn wa.» ");
INSERT INTO dyi_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","A Abirahamu wì si fe ma kari wa wi nɛrɛ ŋgbelege ki sɔgɔwɔ, mɛɛ saa napige yirifɔnŋgɔ ŋga ki yɛn yanlaga ni ma pye mɔrimɔri ka yigi maga kan wi tunmbyee wa yeri. A wo sigi fyɛɛlɛ maga gbegele maga sɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ko puŋgo na, a Abirahamu wì si nɔnɔ nara, naa nɔnɔ tipiriwe kona napige yirifɔnŋgɔ kara nda pàa sɔgɔ ti lɛ, ma saa ti kan nambanmbala pe yeri. Naa pàa kaa na nii, a Abirahamu wì si yere le pe kanŋgaga na, le tige ki nɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","A pè si Abirahamu wi yewe ma yo fɔ: «Ma jɔ Sara wo yɛn se?» A wì sho fɔ: «Wi yɛn wa paraga go ki ni.» ");
INSERT INTO dyi_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","A nambanmbala nuŋgba sho fɔ: «Yelapanna anmɛ yɛgɛ, mi yaa sɔngɔrɔ mbe pan laga ma yeri, ki yaa yala ma jɔ Sara wi pinambyɔ se.» Sara wìla pye le paraga go ki yeyɔngɔ ki na wa Abirahamu wi puŋgo na, mɛɛ ki sɛnrɛ ti logo. ");
INSERT INTO dyi_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abirahamu wo naa Sara wi ni, pàa lɛ makɔ fɔ jɛŋgɛ. Sara wìla lɛ ma toro pisege na. ");
INSERT INTO dyi_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kona, a Sara wì si tɛgɛ wa wi nawa, ma sho fɔ: «Mì lɛ koni, naŋa kala tasanga wo si toro? Na tafɔ fun wì lɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kona, a Yawe Yɛnŋɛlɛ lì si Abirahamu wi pye fɔ: «Yiŋgi na, a Sara wì si tɛgɛ ma yo fɔ ki se ya pye, fɔ wì lɛ ma toro pisege na? ");
INSERT INTO dyi_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kala lo la yɛn wa, na Yawe Yɛnŋɛlɛ li se ya mbe pye? Yelapanna anmɛ yɛgɛ, mi yaa sɔngɔrɔ mbe pan laga ma yeri, ki yaa yala Sara wì pinambyɔ se.» ");
INSERT INTO dyi_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","A Sara wì si fyɛ mɛɛ je ma yo fɔ: «Ayoo, mii tɛgɛ.» A we Fɔ wì sho fɔ: «Kaselege ko na, mà tɛgɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Naa ki nambala pàa kaa yiri na kee, a pè si wele wa Sodɔmu ca ki yeri. Abirahamu wìla pinlɛ pe ni na tanri mbe sa pe torogo. ");
INSERT INTO dyi_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","A Yawe Yɛnŋɛlɛ lì sho fɔ: «Kala na mi yaa pye, mi woro na jaa mbeli lara Abirahamu wi na. ");
INSERT INTO dyi_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Wi yaa ka pye cɛnlɛ gbenɛ na li yaa pye fanŋga ni li tɛlɛ. Wo kala na, mi yaa ka duwaw tara na cɛngɛlɛ ke ni fuun ke na. ");
INSERT INTO dyi_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Katugu mùu wɔ jaŋgo wigi yo wi piile, naa wi setirige piile pe kan, paa tanri paa yala na ŋgasegele ke ni, paa kasinŋge piin, paa tanri kaselege na, jaŋgo yɔn fɔlɔ na mì lɛ Abirahamu wi yeri, mbeli yɔn fili.» ");
INSERT INTO dyi_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","A Yawe Yɛnŋɛlɛ lì sho fɔ: «Pe yɛn na Sodɔmu naa Gomɔri woolo pe jɛrɛgi kagala ŋgele wogo na kè lɛgɛ, pe kapere tì tijanga ma toro. ");
INSERT INTO dyi_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ki kala na, pe yɛn na pe jɛrɛgi kagala ŋgele wogo na, mi yaa tigi saga wogo ki wele, na kaa pye mila ki nuru yɛgɛ ŋga na, pa paa ki piin ma. Na kaselege yi, na kaselege si ma, pa mi yaa ki jɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ki nambala, a shyɛn si yiri le mɛɛ yɛgɛ kan wa Sodɔmu ca ki yeri. Ɛɛn fɔ, a Abirahamu wo si koro le yeresaga Yawe Yɛnŋɛlɛ li tanla. ");
INSERT INTO dyi_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","A Abirahamu wì si fulo li tanla mɛɛ li pye fɔ: «Ma yaa lesinmbele poro naa lepeele pe pinlɛ mbe pe tɔngɔ kɛ? ");
INSERT INTO dyi_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kana lesinmbele nafa shyɛn ma yiri kɛ mbe ta wa ca ki ni. Ma mbe yɛnlɛ mbe ca ki tɔngɔ kɛ? Ma se ca ki yaga ki lesinmbele nafa shyɛn ma yiri kɛ pe kala na? ");
INSERT INTO dyi_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Mbe lesinmbele poro naa lepeele pe pinlɛ mbe pe tɔngɔ, nakoma mbe lesinmbele poro naa lepeele pe pye pe yala, mìgi jɛn ma yo ma se yɛnlɛ mbe ko pye. Mboro ŋa ma yɛn tara woolo pe kiti kɔnfɔ, ki se ya mbe pye fɔ mɛɛ kasinŋge ki jɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","A Yawe Yɛnŋɛlɛ lì sho fɔ: «Na mi ka lesinmbele nafa shyɛn ma yiri kɛ yan wa Sodɔmu ca, pa mi yaa ca ki ni fuun ki kala yaga pe kala na.» ");
INSERT INTO dyi_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","A Abirahamu wì sho naa fɔ: «Mi ŋa mi yɛn paa taambugɔ naa cɔnrɔ yɛn, mì kotogo le na yɛɛ ni na yuun we Fɔ wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kana lere kaŋgurugo wi yaa kɔn lesinmbele nafa shyɛn ma yiri kɛ pe na. Ki leele kaŋgurugo pe kala na, ma mbe yɛnlɛ mbe ca ki ni fuun ki tɔngɔ kɛ?» A we Fɔ wì sho fɔ: «Na mi ka lesinmbele nafa shyɛn ma yiri kaŋgurugo yan wa, pa mi se ca ki tɔngɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","A Abirahamu wì sho naa fɔ: «Kana lesinmbele nafa shyɛn pe yaa pye wa.» A we Fɔ wì sho fɔ: «Mi se yaraga ka pye ki lesinmbele nafa shyɛn pe kala na.» ");
INSERT INTO dyi_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kona, a Abirahamu wì sho fɔ: «Na Fɔ, maga ka nawa ŋgban, mi yaa para naa. Kana lesinmbele nafa ma yiri kɛ pe yaa pye wa.» A we Fɔ wì sho fɔ: «Na mi ka lesinmbele nafa ma yiri kɛ yan wa, pa mi se yaraga ka pye.» ");
INSERT INTO dyi_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","A Abirahamu wì sho fɔ: «Mì kotogo le na yɛɛ ni jɛŋgɛ na yuun we Fɔ wi ni. Kana lesinmbele nafa pe yaa pye wa.» A we Fɔ wì sho fɔ: «Mi se ca ki tɔngɔ ki lesinmbele nafa pe kala na.» ");
INSERT INTO dyi_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","A Abirahamu wì sho fɔ: «Na Fɔ, maga ka nawa ŋgban. Mi se para naa sɛnrɛ nda to puŋgo na: ‹Kana lesinmbele kɛ pe yaa pye wa cɛ.› » A we Fɔ wì sho fɔ: «Mi se ca ki tɔngɔ ki lesinmbele kɛ pe kala na.» ");
INSERT INTO dyi_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Naa Yawe Yɛnŋɛlɛ làa kaa para Abirahamu wi ni ma saa kɔ, a lì si kari. A Abirahamu wì si sɔngɔrɔ wa wi go. ");
INSERT INTO dyi_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Naa mɛrɛgɛye shyɛn pàa kaa gbɔn wa Sodɔmu ca yɔnlɔkɔgɔ ki ni, kìla yala mbogo ŋga kìla ca ki maga maga fili, Lɔti wìla pye ma cɛn wa ki yeyɔngɔ ki na. Naa Lɔti wìla kaa pe yan sanga ŋa ni, a wì si yiri ma saa pe fili, mɛɛ fɔli ma pe shari ma pe gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kona, a Lɔti wì si pe pye fɔ: «Na tafɛnnɛ, mila ye yɛnri, yege yaga ye sa tugu mi ŋa ye kulonaŋa wa na go; ye ye tɔɔrɔ ti jogo, ye wɔnlɔ laga. Goto yirifaga na, pa ye yaa la kee.» A pè sho fɔ: «Ayoo, we yaa sa sinlɛ wa katogo.» ");
INSERT INTO dyi_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ɛɛn fɔ, a Lɔti wì si koro na pe yɛnri ŋgbanga, fɔ a pè saa yɛnlɛ ma saa tugu wa wi go. A wì si ti a pè sɔgɔ ma pe kan, konaa ma leve fu buru fɔ pe kan. A pè si li. ");
INSERT INTO dyi_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Pè sila ta mbe sinlɛ gbɛn, a Sodɔmu ca nambala, maga lɛ ki lefɔnmbɔlɔ pe na, ma saa gbɔn lelɛɛlɛ pe na, pe ni fuun pè si pan ma go ki maga maga fili. ");
INSERT INTO dyi_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","A pè si Lɔti wi yeri ma suu pye fɔ: «Nambala mbele pè tugu laga ma go yɔnlɔkɔgɔ ŋga ki ni, pe yɛn se? Pe yirige laga we kan, we ta we jɛɛlɛ kala pye pe ni.» ");
INSERT INTO dyi_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","A Lɔti wì si yeyɔngɔ shɔn wi kaanla ma yiri laga funwa na pe kɔrɔgɔ, mɛɛ yeyɔngɔ ki tɔn wa wi puŋgo na; ");
INSERT INTO dyi_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","mɛɛ pe pye fɔ: «Ayoo, na wɛnnɛ, yaga ka ki kapege gbɔgɔ ŋga ki pye. ");
INSERT INTO dyi_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Sumbonɔ shyɛn yɛn na yeri pe fa naŋa kala jɛn gbɛn, mi yaa pe yirige laga funwa na ye kan. Ŋga ka ye ndanla, ye ko pye pe na. Ɛɛn fɔ, yaga ka kala pye ki nambala mbele pe na, katugu mi na nambanmbala wɛlɛ, mi yɛn pe go sigefɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","A pè suu pye fɔ: «Yiri we yɛgɛ na, mboro nambanŋa, maa jaa mbɔɔn yɛɛ pye we kiti kɔnfɔ. Kapege ŋga we yaa pye mboro na, ko yaa wɛ naa poro wogo ko na.» A pe nɛɛ Lɔti wi wɔnrɔgi ŋgbanga, na kee kɔrɔ ki yeri saga kaw mbe ye wa go. ");
INSERT INTO dyi_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kì kaa pye ma, a mɛrɛgɛye shyɛn pè si Lɔti wi yigi ŋgbanga, maa tile, maa le pe yɛɛ kɔrɔgɔ wa go nawa, mɛɛ kɔrɔ ki tɔn. ");
INSERT INTO dyi_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Nambala mbele pàa pye le yeyɔngɔ yɛgɛ ki na, a mɛrɛgɛye pè si yɛnfyɔnrɔ wa pe na, maga lɛ piile pe na, fɔ ma saa ki wa lelɛɛlɛ pe na. Pe sila yeyɔngɔ ki yan naa. ");
INSERT INTO dyi_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","A ki nambala shyɛn pè si Lɔti wi yewe ma yo fɔ: «Ma go woolo pele yɛn laga mbele poro puŋgo na le? Ma nafɛnnɛ, naa ma pinambiile, naa ma sumborombiile, lere o lere wi yɛn ma woo, ma pe yirige laga ca ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","We yaa ca ki tɔngɔ, katugu pe yɛn na ca ki jɛrɛgi kagala ŋgele wogo na, kè wɛ Yawe Yɛnŋɛlɛ li yɛgɛ na. Lì we tun we pan we ca ki tɔngɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","A Lɔti wì si yiri ma saa para wi nafɛnnɛ pe ni, mbele wìla wi sumborombiile pe kan pe yeri pe pe pɔri pe jɛɛlɛ, mɛɛ pe pye fɔ: «Ye yiri fyaw laga ki laga ŋga ki ni, katugu Yawe Yɛnŋɛlɛ li yaa ca ki tɔngɔ.» Ɛɛn fɔ, a ki sɛnrɛ tì si pye wi nafɛnnɛ pe yeri paa jiire sɛnrɛ yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Yinndogo ki na, a mɛrɛgɛye pe nɛɛ Lɔti wi fyɛɛlɛ ma yo fɔ: «Yiri maa kee, mboro naa ma jɔ, naa ma sumborombiile shyɛn mbele pe yɛn laga ma ni pe ni, jaŋgo kiti ŋa wi yaa kɔn ca ki na mbege tɔngɔ, ye ni ka ka pye wa wi ni.» ");
INSERT INTO dyi_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lɔti wìla pye na mɔlɔ, a nambala shyɛn pè suu yigi wi kɛɛ ki na, naa wi jɔ wi ni, konaa wi sumborombiile shyɛn pe ni, mɛɛ pe yirige wa ca ki ni, katugu Yawe Yɛnŋɛlɛ làa pye na jaa mbe pe shɔ. ");
INSERT INTO dyi_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Naa paa kaa na pe yinrigi wa ca ki ni, nambala shyɛn pe ni, a nuŋgba si Lɔti wi pye fɔ: «Ta fee mɔɔ yɛɛ shɔ. Maga ka kanŋga mbe wele puŋgo na, maga si ka yere funwa laga falafala ka kpɛ ni. Ta fee maa kee wa yanwiga ki na, jaŋgo maga ka ku.» ");
INSERT INTO dyi_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","A Lɔti wì suu pye fɔ: «Ayoo, na tafɔ, mi se ya mbege pye. ");
INSERT INTO dyi_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ki yɛn kaselege fɔ na kala lɔ̀ɔn ndanla, a mà kagbaraga pye mala kan, mala go shɔ. Ɛɛn fɔ, mi se ya fe mbe sa gbɔn wa yanwiga ki na, na ki jɔlɔgɔ gbɔgɔ ki fanla ta mbanla gbo. ");
INSERT INTO dyi_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Wele, ki ca pige ŋga wamɛ, ki yɛn ma yɔngɔ we ni fɔ jɛŋgɛ. Mbe ya fe mbe kari wama. Ki yaga mbe fe mbe kari sa lara wama, mbanla yɛɛ go shɔ, katugu ki yɛn ma kologo.» ");
INSERT INTO dyi_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","A mɛrɛgɛ wì suu pye fɔ: «Mì yɛnlɛ mbe kagbaraga ŋga mà yɛnri ki pye ma kan naa. Ca ŋga maa piin, mi yaa ki kala yaga, mi sege tɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Fyɛɛlɛ ma sa lara wa ki ni, katugu mi se ya kala la pye gbɛn, na ma fa gbɔn wa.» Ko kala ki ti pe maa ki ca ki yinri «Sowari». ");
INSERT INTO dyi_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lɔti wìla ye wa Sowari ca ma yala yɔnlɔ kila yinrigi fɔnŋgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kona, a Yawe Yɛnŋɛlɛ lì si kiribi kasɔn tirige ma yiri wa yɛnŋɛlɛ na, paa tisaga yɛn Sodɔmu naa Gomɔri cara ti na. ");
INSERT INTO dyi_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","A kì sigi cara ti tɔngɔ, naa funwa lara falafala ti ni fuun ti ni, naa leele pe ni fuun pe ni, konaa yaraga ŋga fuun kì fi wa tara ti na ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ɛɛn fɔ, a Lɔti jɔ wì si kanŋga ma wele wa puŋgo na, mɛɛ kanŋga ma pye paa kɔ tiyala yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ki goto yirifaga ki na, a Abirahamu wì si yiri ma kari wa laga ŋga wìla pye ma yere Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","A wì si wele wa Sodɔmu naa Gomɔri cara ti yeri, naa ki kanŋgara na lara ti ni fuun ti yeri, mɛɛ wirige ka yan kila yinrigi wa funwa laga falafala ki ni, paa kasɔn gbɔgɔ wirige yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lɔti wìla pye ma cɛn tara nda ni, naa Yɛnŋɛlɛ làa kaa ki cara ti tɔngɔ, làa jatere pye Abirahamu wi na (mbe kala pye wi kan), mɛɛ Lɔti wi shɔ maa wɔ wa ki jɔlɔgɔ ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lɔti wìla pye na fyɛ mbe koro wa Sowari ca ki ni. A wì si yiri le wo naa wi sumborombiile shyɛn pe ni, ma saa cɛn wa yanwiga ki na. Wo naa wi sumborombiile shyɛn pe ni pàa pye ma cɛn waliwege ka ni. ");
INSERT INTO dyi_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Pilige ka, a sumboro lɛrɛfɔ wì si jɔnlɔfɔ wi pye fɔ: «We to wì lɛ makɔ. Naŋa si woro laga ki tara nda ti ni mbe we pɔri paa yɛgɛ ŋga na ki maa piin laga tara ti ni fuun ti ni we. ");
INSERT INTO dyi_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Pan we duvɛn kan we to wi yeri wi wɔ wi tin, yembinɛ we sa sinlɛ wi ni, we ta we setirige piile kan wi yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ki yembinɛ li ni, a pè si duvɛn kan pe to wi yeri, a wì wɔ ma tin. A sumboro lɛrɛfɔ wì si saa sinlɛ pe to wi ni. Ɛɛn fɔ, wi to wi sila sumboro wi sinlɛsanga naa wi yirisanga jɛn. ");
INSERT INTO dyi_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ki goto, a sumboro lɛrɛfɔ wì sigi yo jɔnlɔfɔ wi kan fɔ: «Mì sinlɛ wa we to wi ni yembinɛ li ni. Pan we duvɛn wa kan wi yeri naa yɔnlɔkɔgɔ ŋga, wi wɔ wi tin naa, jaŋgo we setirige piile kan wi yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ki yembinɛ li ni, a pè si duvɛn wa kan pe to wi yeri naa, a wì wɔ ma tin. A jɔnlɔfɔ wì si saa sinlɛ wi ni. Wi to wi sila wi sinlɛsanga naa wi yirisanga jɛn. ");
INSERT INTO dyi_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","A Lɔti wi sumborombiile shyɛn pè si kugbɔrɔ lɛ pe to wi na. ");
INSERT INTO dyi_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","A sumboro lɛrɛfɔ wì si pinambyɔ se maa mɛgɛ taga naa yinri Mowabu. Wo wi yɛn Mowabu cɛnlɛ woolo pe tɛlɛ we, ali ma pan ma gbɔn nala. ");
INSERT INTO dyi_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","A jɔnlɔfɔ fun wì si pinambyɔ se maa mɛgɛ taga naa yinri Bɛni Ami. Wo wi yɛn Amɔ cɛnlɛ woolo pe tɛlɛ we, ali ma pan ma gbɔn nala. ");
INSERT INTO dyi_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Koni, a Abirahamu wì si yiri lema mɛɛ kari wa Negɛvu tara, ma saa cɛn wa Kadɛshi ca, naa Shuri ca sɔgɔwɔ pi ni. Ko puŋgo na, a wì si saa cɛn wa Gerari ca. ");
INSERT INTO dyi_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abirahamu wìla pye naga yuun wi jɔ Sara wi kanŋgɔlɔ ma yo wi yɛn wi jɔnlɔ sumboro. A Gerari ca wunlunaŋa Abimelɛki wì si leele tun, a pè saa Sara wi lɛ ma pan maa kan wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ki yembinɛ li ni, a Yɛnŋɛlɛ lì sili yɛɛ naga Abimelɛki wi na wɔɔnrɔ na, mɛɛ wi pye fɔ: «Ma yaa ku ki jɛlɛ ŋa mà lɛ wi kala na, katugu naŋafɔ wi.» ");
INSERT INTO dyi_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Kìla yala Abimelɛki wi faa jɛn jɛlɛ gbɛn. A wì sho fɔ: «We Fɔ, ali mbege ta mi naa na woolo pe ni wee kapege pye, ma yaa we gbo le? ");
INSERT INTO dyi_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abirahamu wo jate wìgi yo mala kan fɔ wi jɔnlɔ sumboro wi, a Sara wìgi yo mala kan fun ma yo wi ndɔ wi. Mìgi kala na li pye nawa jatere jɛnŋɛ ni, mii kapege pye.» ");
INSERT INTO dyi_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","A Yɛnŋɛlɛ lì sigi yo wi kan wa ki wɔɔnrɔ nuŋgba ti na fɔ: «Mìgi jɛn ma yo màga pye nawa jatere jɛnŋɛ ni. Muwi mì ti mɛɛ jiri wi na, mbe kapege pye na na. ");
INSERT INTO dyi_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Koni, ki jɛlɛ ŋa wi sɔngɔrɔ wi pɔlɔ wi na, katugu wi yɛn Yɛnŋɛlɛ yɔn sɛnrɛ yofɔ. Wi yaa yɛnri ma kan, pa ma yaa koro yinwege na. Ɛɛn fɔ, na ma suu sɔngɔrɔ wi na, ma taga ki na fɔ ma yaa ku, mboro naa ma woolo pe ni fuun pe ni.» ");
INSERT INTO dyi_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ki goto yirifaga ki na, a Abimelɛki wì suu legbɔɔlɔ pe ni fuun pe yeri mɛɛ ki kagala ke ni fuun ke yɛgɛ yo ma pe kan. A pè si fyɛ fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kona, a Abimelɛki wì si Abirahamu wi yeri fun, mɛɛ wi yewe ma yo fɔ: «Yiŋgi mà pye we na yɛɛn? Yiŋgi kapege mì pye ma na, a mà si ti mi naa na wunluwɔ pi ni, wège kapege gbɔgɔ ŋga ki pye? Ŋga mà pye na na, kii daga pyewe ni.» ");
INSERT INTO dyi_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Kona, a Abimelɛki wì si Abirahamu wi pye fɔ: «Kɔrɔ wiwiin na, a mà sigi kala na li pye?» ");
INSERT INTO dyi_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","A Abirahamu wì sho fɔ: «Mìla pye naga sɔnri, ki sila pye nala kɔɔn shyɛn, ma yo ki tara nda ti woolo paa la fyɛ Yɛnŋɛlɛ li yɛgɛ, fɔ leele pe yaa na gbo na jɔ wi kala na. ");
INSERT INTO dyi_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Mbe taga wa ko na, ki yɛn ma kaselege, na jɔnlɔ sumboro wi. We yɛn to nuŋgba piile, ɛɛn fɔ, we woro nɔ nuŋgba piile. Ko ki ti wì ya ma pye na jɔ. ");
INSERT INTO dyi_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Naa Yɛnŋɛlɛ làa kaa na yirige mala wɔ wa na to ca ki ni, a mì pye yanrifɔ, a mì sigi yo na jɔ wi kan fɔ maga kajɛŋgɛ nuŋgba ŋga ko pye na kan: ‹Waga kari laga o laga, maa ki yuun fɔ mi yɛn ma ndɔ.› » ");
INSERT INTO dyi_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","A Abimelɛki wì si simbaala, naa sikaala, naa nɛrɛ, naa kulonambala konaa kulojaala kan Abirahamu wi yeri, mɛɛ wi jɔ Sara wi sɔngɔrɔ wi na fun. ");
INSERT INTO dyi_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A Abimelɛki wì suu pye fɔ: «Na tara ti nda ma yɛgɛ sɔgɔwɔ. Laga ŋga kɔɔn ndanla, ma sa cɛn wama.» ");
INSERT INTO dyi_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A wì si Sara wi pye fɔ: «Wele, mi yɛn na warifuwe pyɔ waga kele (1 000) kaan ma ndɔ wi yeri, ko yaa ki naga leele mbele pe yɛn ma ni pe ni fuun pe na fɔ mɛɛ kapege pye wa ki kala na li ni.» ");
INSERT INTO dyi_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kona, a Abirahamu wì si Yɛnŋɛlɛ li yɛnri, a lì si Abimelɛki wo naa wi jɔ naa wi kulojaala pe sagala; a wi jɔ naa wi kulojaala pè si ya na siin naa. ");
INSERT INTO dyi_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Katugu Yawe Yɛnŋɛlɛ làa Abimelɛki wi go jɛɛlɛ pe ni fuun pe sege ki tɔn, ŋga kìla pye Abirahamu wi jɔ Sara wi na ki kala na. ");
INSERT INTO dyi_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yawe Yɛnŋɛlɛ li jatere wìla koro sɛnrɛ nda làa yo Sara wi kan ti na, mɛɛ ŋga làa yo maa kan ki pye. ");
INSERT INTO dyi_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","A Sara wì si kugbɔ lɛ ma pinambyɔ se Abirahamu wi kan wa wi lelɛwɛ pi ni, ma yala wagati ŋa Yɛnŋɛlɛ làa kɔn ma tɛgɛ wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","A Abirahamu wì si pinambyɔ ŋa Sara wìla se maa kan wi mɛgɛ taga naa yinri Izaki. ");
INSERT INTO dyi_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","A Abirahamu wì suu pinambyɔ Izaki wi kɛnrɛkɛnrɛ wi seŋgɔlɔ, pilige kɔlɔtaanri wogo ki na, paa yɛgɛ ŋga na Yɛnŋɛlɛ làa ki yo maa kan. ");
INSERT INTO dyi_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abirahamu wìla ta yɛlɛ cɛnmɛ wi pinambyɔ Izaki wi sesanga wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","A Sara wì sho fɔ: «Yɛnŋɛlɛ lì titɛgɛrɛ kala kan na yeri. Mbele fuun pe yaa li logo, pe yaa la tɛgɛ na ni ja.» ");
INSERT INTO dyi_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","A wì sho naa fɔ: «Ambɔ wi mbaa ki yo Abirahamu kan fɔ mi Sara yaa ka yinnɛ kan piile yeri? Ma si yala, mì pinambyɔ se wi kan wa wi lelɛwɛ pi ni.» ");
INSERT INTO dyi_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kona, a Izaki wì si yiri ma yɛgɛ to, a pòo laga yinnɛ na. Pàa wi laga yinnɛ na pilige ŋga ni, a Abirahamu wì si sɔgɔlɔ gbɔlɔ sɔgɔ wi mɛgɛ ni. ");
INSERT INTO dyi_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ma si yala Ezhipiti tara fɛnnɛ jɔ Agari wìla pinambyɔ ŋa se Abirahamu wi kan, a Sara wì suu yan wila tɛgɛ Izaki wi na. ");
INSERT INTO dyi_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","A Sara wì si Abirahamu wi pye fɔ: «Ki kulojɔ ŋa wi purɔ wo naa wi pinambyɔ wi ni, katugu ki kulojɔ ŋa wi pinambyɔ wi se pinlɛ mbe kɔrɔgɔ ki li ja na pinambyɔ Izaki wi ni.» ");
INSERT INTO dyi_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ki sɛnrɛ tìla Abirahamu wi mbɛn wi pinambyɔ Ishimayɛli wi kala na. ");
INSERT INTO dyi_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ɛɛn fɔ, a Yɛnŋɛlɛ lì si Abirahamu wi pye fɔ: «Ma kulojɔ wo naa wi pinambyɔ wi ni, pe wogo kiga kɔɔn ya. Sara wiga sɛnrɛ nda fuun yo ma kan, ma yɛnlɛ ti na; katugu pa ma setirige piile pe yaa ka yiri wa Izaki wo ni. ");
INSERT INTO dyi_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma kulojɔ wi pinambyɔ wo na, mi yaa cɛnlɛ la pye li yiri wa wi ni, katugu wi yɛn ma sege ki woo wa.» ");
INSERT INTO dyi_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ki goto yirifaga ki na, a Abirahamu wì si yaakara lɛ, naa sɛlɛgɛ kasha ni, ŋga kìla pye ma yin tɔnmɔ ni, mɛɛ ti kan Agari wi yeri, mari taga wa wi pajogo ki na, mɛɛ wi pinambyɔ wi kan wi yeri fun, ma suu pye ma yo wila kee. A Agari wì si kari mɛɛ saa puŋgo wa Bɛrisheba gbinri wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Naa sɛlɛgɛ kasha tɔnmɔ pìla kaa kɔ, a Agari wì si saa pyɔ wi tɛgɛ tipige ka nɔgɔ, ");
INSERT INTO dyi_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","mɛɛ kari ma saa cɛn wi yɛ wa pyɔ wi yɛsinmɛ na. Wo naa pyɔ wi ni, fogo ŋga kìla pye pe sɔgɔwɔ kìla pye paa yɛgɛ ŋga na paga wanga wɔn ki ma fogo ŋga pye si jɛn mbe to we; katugu wìla wi yɛɛ pye fɔ: «Mi woro na jaa mbanla pyɔ wi yan wila kuun.» Ko ki ti wìla saa cɛn wi yɛ wa pyɔ wi yɛsinmɛ pi na, nɛɛ gbele. ");
INSERT INTO dyi_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Yɛnŋɛlɛ làa pyɔ wi gbelege ki logo. A Yɛnŋɛlɛ li mɛrɛgɛ wì si koro wa naayeri ma Agari wi yeri maa pye fɔ: «Yiŋgi kɔɔn ta Agari? Maga kaa fyɛ, katugu Yɛnŋɛlɛ lì lenambile li magala li logo wa laga ŋga màli tɛgɛ we. ");
INSERT INTO dyi_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Yiri mali yigi li kɛɛ ki na, katugu Yɛnŋɛlɛ li yaa li pye cɛnlɛ gbenɛ to.» ");
INSERT INTO dyi_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kona, a Yɛnŋɛlɛ lì si ti a wì kɔlɔ wa yan tɔnmɔ ni. A wì si saa wi sɛlɛgɛ kasha ki ko maga yin, mɛɛ lenambile li kan, a lì wɔ. ");
INSERT INTO dyi_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","A Yɛnŋɛlɛ li nɛɛ lenambile li go singi, a lì si yiri ma lɛ, mɛɛ saa cɛn wa Paran gbinri wi ni, ma pye sandiga wɔnfɔ gbɔɔ. ");
INSERT INTO dyi_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Maga ta wìla pye ma cɛn wa Paran gbinri wi ni, a wi nɔ wì si Ezhipiti tara fɛnnɛ jɔ wa lɛ ma kan wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ki wagati wi ni, a Abimelɛki wì si pan Abirahamu wi kɔrɔgɔ, wo naa wi maliŋgbɔɔnlɔ to Pikɔli wi ni, mɛɛ wi pye fɔ: «Yɛnŋɛlɛ li yɛn ma ni ma kapyege ki ni fuun ni. ");
INSERT INTO dyi_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Koni, wugu mala kan Yɛnŋɛlɛ li mɛgɛ ki na, fɔ ma se kanla fanla, mi naa na piile, naa na setirige piile pe ni, fɔ ma yaa na yigi jɛŋgɛ naa tara nda ma yɛn ma cɛn laga ti woolo pe ni, paa yɛgɛ ŋga na mɔ̀ɔ yigi jɛŋgɛ we.» ");
INSERT INTO dyi_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","A Abirahamu wì sho fɔ: «Mi yaa wugu ki na mbege pye.» ");
INSERT INTO dyi_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ɛɛn fɔ, Abimelɛki wi kulonambala pàa kɔlɔ ŋa shɔ Abirahamu wi yeri fanŋga na, a Abirahamu wi nɛɛ para wi na ki wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","A Abimelɛki wì suu pye fɔ: «Lere ŋa wìgi kala li pye, mi suu jɛn. Mboro fun, mɛɛ sigi yo na kan. Ki logowo powi mba mila nuru ma yeri nala yɛɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kona, a Abirahamu wì si simbaala, naa sikaala naa nɛrɛ yigi ma kan Abimelɛki wi yeri. A pe shyɛn pè si yɔn finliwɛ le pe yɛɛ ni. ");
INSERT INTO dyi_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abirahamu wì si simbasumbonɔ kɔlɔshyɛn wɔ ma pe tɛgɛ pe yɛ. ");
INSERT INTO dyi_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","A Abimelɛki wì suu yewe ma yo fɔ: «Simbasumbonɔ kɔlɔshyɛn mbele mà wɔ ma tɛgɛ pe yɛ ko go ko yɛn kikiin?» ");
INSERT INTO dyi_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","A Abirahamu wì suu pye fɔ: «Yɛnlɛ ki simbasumbonɔ kɔlɔshyɛn mbele pe na, jaŋgo paa ma nawa tuun ki na fɔ muwi mìgi kɔlɔ ŋa wì wɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ko kala na, pe maa ki laga ki yinri Bɛrisheba, katugu pàa wugu le ki laga ki na ma pe yɛɛ kan. ");
INSERT INTO dyi_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kì kaa pye ma, a pè si yɔn finliwɛ le pe yɛɛ ni wa Bɛrisheba. Ko puŋgo na, Abimelɛki wo naa wi maliŋgbɔɔnlɔ to Pikɔli wi ni, pè si yiri ma sɔngɔrɔ wa Filisiti tara fɛnnɛ pe tara. ");
INSERT INTO dyi_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","A Abirahamu wì si tamarisi tige ka sanri wa Bɛrisheba, mɛɛ Yawe Yɛnŋɛlɛ li mɛgɛ ki yeri wa mali gbɔgɔ, lo na li yɛn Yɛnŋɛlɛ na li yɛn kɔsaga fu. ");
INSERT INTO dyi_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abirahamu wìla cɛn ma mɔ wa Filisiti tara fɛnnɛ pe tara. ");
INSERT INTO dyi_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ki kagala ke puŋgo na, a Yɛnŋɛlɛ lì si Abirahamu wi wa ma wele, mɛɛ wi pye fɔ: «Abirahamu.» A wì si shɔ ma yo: «Naw.» ");
INSERT INTO dyi_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","A Yɛnŋɛlɛ lì sho fɔ: «Ma pinambyɔ nuŋgba pe ŋa wɔ̀ɔn ndanla jɛŋgɛ, Izaki we, wi lɛ ma kari wi ni wa Moriya tara. Yanwiga ŋga mi yaa naga ma na, ma saa wɔ wa na yeri saraga sogowogo.» ");
INSERT INTO dyi_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ki goto yirifaga ki na, a Abirahamu wì si yiri ma sofile jɔngɔ ki pɔ wi sofile wi na, mɛɛ wi tunmbyeele shyɛn lɛ ma taga wi yɛɛ na, naa wi pinambyɔ Izaki wi ni. A wì si kanŋgirɛ nda ti yaa sa saraga ki sogo ti walagi. Yɛnŋɛlɛ làa laga ŋga sɛnrɛ yo maa kan, a pè si yiri nɛɛ kee wa ki laga ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pilige taanri wogo ki na, a Abirahamu wì suu yɛgɛ ki yirige ma wele, mɛɛ laga ki yan wa lege. ");
INSERT INTO dyi_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","A wì suu tunmbyeele pe pye fɔ: «Ye koro na sofile wi ni. Mi naa lefɔnŋɔ wi ni we yaa kari fɔ wamɛ sa Yɛnŋɛlɛ li gbɔgɔ, mbe si sɔngɔrɔ mbe pan ye kɔrɔgɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","A Abirahamu wì si saraga ki sogo kanŋgirɛ ti taga wi pinambyɔ Izaki wi go na, mɛɛ kasɔn naa gbenɛ to yigi. A pè si pinlɛ nɛɛ kee. ");
INSERT INTO dyi_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","A Izaki wì suu to Abirahamu wi yeri ma yo fɔ: «Baba.» A tofɔ wì si shɔ ma yo fɔ: «Naw, na pinambyɔ.» A Izaki wì sho fɔ: «Kasɔn konaa kanŋgirɛ ti nda! Simbapyɔ ŋa we yaa sa wɔ saraga, mboo sogo wo yɛn se?» ");
INSERT INTO dyi_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","A Abirahamu wì suu pye fɔ: «Na pinambyɔ, simbapyɔ ŋa we yaa wɔ saraga mboo sogo, Yɛnŋɛlɛ lo jate li yaa ki wogo ki yɔn we kan.» A pe shyɛn pè si pinlɛ nɛɛ kee. ");
INSERT INTO dyi_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Naa pàa kaa saa gbɔn wa laga ŋga Yɛnŋɛlɛ làa naga Abirahamu wi na, a wì si saraga wɔsaga kan, ma kanŋgirɛ ti taga wa ki na, mɛɛ wi pinambyɔ Izaki wi yigi maa pɔ, mɛɛ wi taga wa saraga wɔsaga ki na, wa kanŋgirɛ ti go na. ");
INSERT INTO dyi_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kona, a Abirahamu wì suu kɛɛ ki sanga ma gbenɛ li lɛ mboo pinambyɔ wi kɔnli. ");
INSERT INTO dyi_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ɛɛn fɔ, a Yawe Yɛnŋɛlɛ li mɛrɛgɛ wì si koro wa yɛnŋɛlɛ na ma Abirahamu wi yeri ma yo fɔ: «Abirahamu, Abirahamu.» A wì si shɔ ma yo: «Naw.» ");
INSERT INTO dyi_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","A we Fɔ wì sho fɔ: «Yere, maga kɔɔn kɛɛ ki taga pyɔ wi na, maga ka kapege kpɛ pye wi na. Mìgi jɛn yiŋgɔ ma yo ma yɛn na fyɛ mi ŋa Yɛnŋɛlɛ na yɛgɛ, mɛɛ je mbɔɔn pinambyɔ nuŋgba pe wi kan na yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","A Abirahamu wì suu yɛgɛ ki yirige mɛɛ simbapɔlɔ wa yan wa wi puŋgo na, wi yɛɛnrɛ tì yanra tipire ta ni. A Abirahamu wì si saa ki simbapɔlɔ wi yigi maa wɔ saraga sogowogo, wi pinambyɔ wi yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","A Abirahamu wì sigi laga ki mɛgɛ taga naga yinri fɔ: «Yawe Yɛnŋɛlɛ li yaa kaga wogo ki yɔn we kan.» Ko kì ti ali ma pan ma gbɔn nala, pe maa ki yuun ma yo: «We Fɔ wi yaa ki wogo ki yɔn wa yanwiga ki na.» ");
INSERT INTO dyi_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","A Yawe Yɛnŋɛlɛ li mɛrɛgɛ wì si koro wa yɛnŋɛlɛ na ma Abirahamu wi yeri naa, ");
INSERT INTO dyi_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ma yo: Yawe Yɛnŋɛlɛ lì nda yo ti nda: «Mà kaa ŋga ko pye yɛɛn, mɛɛ je mbɔɔn pinambyɔ nuŋgba pe wi kan na yeri, mi ŋa mi yɛn Yɛnŋɛlɛ, mì wugu na yɛɛ na ");
INSERT INTO dyi_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mbe duwaw ma na, mbɔɔn setirige piile pe pye pe lɛgɛ paa naayeri wɔnŋgɔlɔ koro naa kɔgɔje yɔn taambugɔ ki yɛn. Ma setirige piile pe yaa ka pe juguye pe cara ti shɔ pe yeri. ");
INSERT INTO dyi_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Pe kala na, cɛngɛlɛ ŋgele fuun ke yɛn laga tara na, mi yaa ka duwaw ke na, katugu mà tanga na sɛnrɛ ti na.» ");
INSERT INTO dyi_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kona, a Abirahamu wì si sɔngɔrɔ ma pan wi tunmbyeele pe kɔrɔgɔ. A pè si yiri ma sɔngɔrɔ wa Bɛrisheba. Pa Abirahamu wìla pye ma cɛn wa. ");
INSERT INTO dyi_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ki kagala ke puŋgo na, a Abirahamu wì sigi logo ma yo wi nɔsepyɔ lenaŋa Nahɔri wi jɔ Milika wìla pinambiile se fun wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uzi wo wìla pye pinambyɔ koŋgbanŋa we, naa wi jɔnlɔ Buzi, naa Kemuwɛli ŋa wìla pye Aramu to, ");
INSERT INTO dyi_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","naa Kezɛdi, naa Azo, naa Pilidashi, naa Yidilafu konaa Betuwɛli. ");
INSERT INTO dyi_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ki pinambiile kɔlɔtaanri mbele poro wɛlɛ Milika wìla se Abirahamu wi nɔsepyɔ lenaŋa Nahɔri wi kan. Erebeka wi to wo lawi ŋa Betuwɛli. ");
INSERT INTO dyi_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahɔri wi cɛnfɔ Erewumu wìla piile se wi kan fun. Pe mɛrɛ ti nda: Teba, naa Gahamu, naa Tahashi, konaa Maaka. ");
INSERT INTO dyi_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara wìla ta yɛlɛ cɛnmɛ naa nafa ma yiri kɔlɔshyɛn (127). Wi yinwege yɛgɛlɛ yɔn ko layi yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Pa Sara wìla ku wa Kiriyati Ariba ca, pe maa ki ca ki yinri naa Eburɔn, wa Kana tara. A Abirahamu wì si pan mboo jɔ Sara wi kunwɔ pi gbele mboo pye. ");
INSERT INTO dyi_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ko puŋgo na, a Abirahamu wì si yiri ma gboo wi yaga le laga ŋga wìla pye, mɛɛ saa para Hɛti cɛnlɛ woolo pe ni, ma pe pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Mi yɛn nambanŋa ma pye cɛnfɔ laga ye sɔgɔwɔ. Ye gboolo lesaga kan na yeri laga ye yeri, mbanla jɔ gboo wi le mboo lɛ na yɛɛ yɛgɛ sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","A Hɛti cɛnlɛ woolo pè si Abirahamu wi yɔn sogo ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«We tafɔ, logo we yeri! Ma yɛn Yɛnŋɛlɛ li legbɔɔ, a lì duwaw ma na laga we sɔgɔwɔ. Ma gboo wi le wa we gboolo lesaga ŋga kì yɔn ma wɛ ti ni fuun na ko ni. Lere wa kpɛ se je wi gboolo lesaga na we ni mbe yo maga kɔɔn jɔ gboo wi le wa.» ");
INSERT INTO dyi_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","A Abirahamu wì si yiri ma fɔli ki tara woolo pe yɛgɛ sɔgɔwɔ, Hɛti cɛnlɛ woolo wele, ma pe gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","A wì si pe pye fɔ: «Na kaa pye ye yɛnlɛ ki na kaselege, mbanla jɔ gboo wi le mboo lɛ na yɛɛ yɛgɛ sɔgɔwɔ, ye logo na yeri, ye Zowari pinambyɔ Efirɔn wi yɛnri na kan, ");
INSERT INTO dyi_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","wi waliwege ŋga ki yɛn wa Makipela laga ki na ki kan na yeri. Wo wogo yi, ki yɛn wa wi kɛrɛ ti koŋgo na. Wigi pɛrɛ na yeri mbe yala ki penjara yɔn ki ni, ki ta ki pye na gboolo lesaga laga ye sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hɛti cɛnlɛ woolo naŋa Efirɔn wìla pye ma cɛn wa wi woolo pe sɔgɔwɔ. A wì si Abirahamu wi yɔn sogo le Hɛti cɛnlɛ woolo sanmbala poro naa leele mbele fuun pàa pye na cɛɛn le wi ca ki mbogo yeyɔngɔ ki na pe yɛgɛ na, mɛɛ wi pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Ayoo, na tafɔ, logo na yeri. Kɛrɛ to naa waliwege ŋga ki yɛn wa ti ni, mi yɛn nari kaan ma yeri. Mi yɛn nari kaan ma yeri na woolo pe yɛgɛ na. Mɔɔ jɔ gboo wi le wa.» ");
INSERT INTO dyi_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","A Abirahamu wì si fɔli le tara ti woolo pe yɛgɛ sɔgɔwɔ ma pe gbɔgɔ, ");
INSERT INTO dyi_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","mɛɛ ki yo Efirɔn wi kan ki tara woolo pe yɛgɛ na fɔ: «Mila ma yɛnri, logo na yeri. Mi yaa kɛrɛ ti penjara yɔn ki kan ma yeri, ma yɛnlɛ ki na maga shɔ, mbe ta mbanla jɔ gboo wi le wa.» ");
INSERT INTO dyi_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ɛɛn fɔ, a Efirɔn wì si Abirahamu wi yɔn sogo ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Na tafɔ, logo na yeri. Kɛrɛ nda ti sɔnŋgɔ ki yɛn warifuwe pyɔ cɛnmɛ tijɛrɛ (400), ko woro yaraga ka mi naa mboro sɔgɔwɔ. Ki kala na, ma jɔ gboo wi le wa.» ");
INSERT INTO dyi_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","A Abirahamu wì si yɛnlɛ penjara yɔn ŋga Efirɔn wìla naga ki na, mɛɛ ti taanla mari kan wi yeri, Hɛti cɛnlɛ woolo sanmbala pe yɛgɛ na. Tìla pye warifuwe pyɔ cɛnmɛ tijɛrɛ (400) ma yala pɛrɛfɛnnɛ pe penjara jinriwɛ pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kì pye ma, Efirɔn kɛrɛ nda tìla pye wa Makipela, wa laga ŋga pàa pye na yinri Mamire ki yɔnlɔ yirisaga yeri, ki kɛrɛ to naa ti waliwege ki ni, naa tire nda fuun tìla pye mari maga mari fili ti ni, ");
INSERT INTO dyi_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","a tì si pye Abirahamu wi woro. Hɛti cɛnlɛ woolo poro naa leele mbele fuun pàa pan wa ca ki mbogo yeyɔngɔ ki na, kìla pye pe yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ko puŋgo na, a Abirahamu wì suu jɔ Sara wi le wa kɛrɛ ti waliwege ki ni, wa Makipela, wa Mamire laga ki tanla. Ko pe yinri fun Eburɔn, wa Kana tara. ");
INSERT INTO dyi_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kɛrɛ to naa ti waliwege ki ni, tì si kanŋga ma pye Abirahamu wi woro. Wìla ti lɔ Hɛti cɛnlɛ woolo pe yeri mbe ta mbaa wi gboolo pe nii wa. ");
INSERT INTO dyi_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abirahamu wìla lɛ fɔ jɛŋgɛ, a wi yɛgɛlɛ yɔn kì lɛgɛ. Yawe Yɛnŋɛlɛ làa duwaw wi na kagala ke ni fuun ni. ");
INSERT INTO dyi_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Pilige ka, a Abirahamu wì sigi yo ŋa wìla pye wi kulolo pe go na, konaa ma pye wi kɛɛ yaara ti ni fuun ti welefɔ wi kan fɔ: «Ma kɛɛ ki le laga na jegbɔlɔ li nɔgɔ, ");
INSERT INTO dyi_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ma wugu Yawe Yɛnŋɛlɛ li mɛgɛ ki na mala kan, lo na li yɛn Yɛnŋɛlɛ naayeri wo naa tara ti go na, fɔ ma se Kana tara fɛnnɛ sumboro wa lɛ mboo kan na pinambyɔ wi yeri jɛlɛ, poro mbele mi yɛn ma cɛn laga pe sɔgɔwɔ we. ");
INSERT INTO dyi_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ɛɛn fɔ, ma yaa kari wa na tara, mbe sa jɛlɛ lɛ na pinambyɔ Izaki wi kan, wa na go woolo pe sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A wi kulonaŋa wì suu yɔn sogo ma yo fɔ: «Kana jɛlɛ wi se yɛnlɛ mbe pinlɛ na ni, mbe pan laga ki tara nda ti ni; na kiga pye ma, mi daga mbe sɔngɔrɔ mbe kari ma pinambyɔ wi ni wa tara nda mà yiri ti ni le?» ");
INSERT INTO dyi_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abirahamu wì sho fɔ: «Ma yɛɛ yigi, maga ka sɔngɔrɔ mbe kari na pinambyɔ wi ni wa. ");
INSERT INTO dyi_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawe Yɛnŋɛlɛ, naayeri Yɛnŋɛlɛ le, lìlan yirige mala wɔ wa na tara, konaa wa na go woolo pe sɔgɔwɔ. Lì para na ni, ma wugu mala kan, ma yo li yaa kaga tara nda ti kan na setirige piile pe yeri. Lo yɛrɛ jate li yaa li mɛrɛgɛ wi kelegi ma yɛgɛ, jaŋgo ma jɛlɛ wa lɛ wa na pinambyɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Na jɛlɛ wiga yo wi se pinlɛ ma ni, pa kona wuguro nda mi yaa ti ma wugu, ti sɔɔn yigi. Ɛɛn fɔ, maga ka sɔngɔrɔ mbe kari na pinambyɔ wi ni wa.» ");
INSERT INTO dyi_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","A kulonaŋa wì suu kɛɛ ki le wa wi tafɔ Abirahamu wi jegbɔlɔ li nɔgɔ, mɛɛ wugu maa kan mbe tanga wi sɛnyoro ti na. ");
INSERT INTO dyi_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kona, a kulonaŋa wì suu tafɔ Abirahamu wi yɔngɔmɛye pe kɛ wɔ konaa wi yarijɛndɛ ti ni fuun ta ni, mɛɛ lɛ ma kari wa Mezopotami tara, wa ca ŋga Nahɔri wìla pye. ");
INSERT INTO dyi_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Naa wìla ka saa gbɔn wa kɔlɔ ŋa wi yɛn wa ca kayege wi na, a wì si ti yɔngɔmɛye pè kanŋguuro kan. Yɔnlɔkɔgɔ layi, jɛɛlɛ pe yɔnlɔkɔgɔ tɔnmɔ kosanga wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kona, a wì si Yɛnŋɛlɛ li yɛnri ma yo fɔ: «Yawe Yɛnŋɛlɛ, na tafɔ Abirahamu wi Yɛnŋɛlɛ, mila ma yɛnri, mala konɔ li tanla na kan nala. Ma kajɛŋgɛ pye na tafɔ Abirahamu wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mi ŋa mi yɛn ma yere na pulugo ki tanla. Ca woolo pe sumbonɔ pe yaa pan mbe ko. ");
INSERT INTO dyi_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Na mi kaga yo sumboro ŋa kan fɔ: ‹Mila ma yɛnri, ma cɔkogo ki yɛri mbe wɔ›, na wiga na yɔn sogo mbe yo: ‹Wɔ, mi yaa pa kan fun ma yɔngɔmɛye pe yeri pe wɔ›, pa kona wo mbe pye jɛlɛ ŋa mà wɔ ma tunmbyee Izaki wi kan wo. Na kiga pye ma, mi yaa ki jɛn mbe yo mà kajɛŋgɛ pye na tafɔ wi kan.» ");
INSERT INTO dyi_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Sanni wi sa kɔ yɛnrɛwɛ pi na, a Betuwɛli sumborombyɔ Erebeka wì si kɔn ma yiri wi cɔkogo ki ni wa wi pajogo ki na. Abirahamu wi nɔsepyɔ lenaŋa Nahɔri wi jɔ Milika wo pinambyɔ lawi Betuwɛli we. ");
INSERT INTO dyi_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ki sumboro wìla yɔn fɔ jɛŋgɛ. Wi sila naŋa kala jɛn, naŋa sila suu jɛn fun jɛlɛ. A wì si tigi wa pulugo ki ni, mɛɛ wi cɔkogo ki ko maga yin, mɛɛ yiri. ");
INSERT INTO dyi_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","A kulonaŋa wì si fe maa fili ma yo fɔ: «Mi yɛn nɔɔ yɛnri, mɔɔ cɔkogo tɔnmɔ pa kan na yeri mbe wɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A sumboro wì sho fɔ: «Wɔ, na tafɔ.» A wì si fyɛɛlɛ maa cɔkogo ki yɛri maa kan, a wì wɔ. ");
INSERT INTO dyi_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Naa wìla kaa wi kan wì wɔ, a wì sho fɔ: «Mi yaa pa ko ma yɔngɔmɛye pe kan fun, pe wɔ pe tin.» ");
INSERT INTO dyi_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","A wì si fyɛɛlɛ maa cɔkogo tɔnmɔ pi kanŋga wa yaayoro wɔyaraga ki ni, mɛɛ fe ma saa ko naa wa pulugo ki ni. Wìla ko ma yɔngɔmɛye pe ni fuun pe kan pè wɔ. ");
INSERT INTO dyi_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","A naŋa wì si pyeri naa wele, nɛɛ wi yɛɛ yewe sumboro wi kanŋgɔlɔ, mbege jɛn na kaa pye Yawe Yɛnŋɛlɛ laa jaa mboo konɔ li tanla. ");
INSERT INTO dyi_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Naa yɔngɔmɛye pàa kaa wɔ ma kɔ, a naŋa wì si tɛ kannjinɛ na pe ma le numala na la wɔ ma kan sumboro wi yeri, li nuguwɔ pi mbaa giramu kɔgɔlɔni si wo bɔ; naa kɛɛ kannjiŋgele tɛ wogolo shyɛn ni; ke ni fuun nuŋgba nuŋgba ke nuguwɔ pi mbaa giramu cɛnmɛ cɛnmɛ wo bɔ. ");
INSERT INTO dyi_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A wì suu yewe ma yo fɔ: «Ambɔ sumborombyɔ wi mboro? Mila ma yɛnri, ki yo na kan. We mbe sinlɛsaga ta wa ma to go mbe wɔnlɔ wa le?» ");
INSERT INTO dyi_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","A sumboro wì sho fɔ: «Mi yɛn Milika naa Nahɔri pe pinambyɔ Betuwɛli wo sumborombyɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","A wì sho naa fɔ: «Yan naa yaayoro yaakara lɛgɛrɛ yɛn wa we yeri. Sinlɛsaga yɛn wa fun ye sinlɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kona, a naŋa wì si sogo maa yɛgɛ ki jiile wa tara, ma Yawe Yɛnŋɛlɛ li gbɔgɔ, ");
INSERT INTO dyi_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","nɛɛ yuun fɔ: «Sɔnmɔ yɛn Yawe Yɛnŋɛlɛ li woo, lo na li yɛn na tafɔ Abirahamu wi Yɛnŋɛlɛ le. Li sili kagbaraga ki yaga, mbeli yɔn sɛnrɛ ti kanŋga na tafɔ Abirahamu wi kanŋgɔlɔ. We Fɔ wìlan yɛgɛ sin fɔ ma pan ma gbɔn laga na tafɔ wi woolo pe go.» ");
INSERT INTO dyi_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","A sumboro wì si fe ma saa ki kagala ke ni fuun ke yɛgɛ yo wi nɔ woolo pe ni fuun pe kan. ");
INSERT INTO dyi_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Erebeka wi ndɔ la pye wa, pàa pye naa yinri Laban. A Laban wì si fe ma yiri wa funwa na, mɛɛ kari naŋa wi kɔrɔgɔ, wa pulugo ki tanla. ");
INSERT INTO dyi_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Wìla kannjinɛ na pe ma le numala na li yan, ma kɛɛ kannjiŋgele ke yan wi jɔnlɔ Erebeka wi kɛyɛn yi na; Erebeka wìla naŋa wi sɛnrɛ ti yɛgɛ yo yɛgɛ ŋga na, Laban wìla ti logo ma fun. A wì si kari wa naŋa wi tanla, wo la pye ma yere le yɔngɔmɛye pe tanla, ma wa wa pulugo ki yeri. ");
INSERT INTO dyi_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","A Laban wì suu pye fɔ: «Pan we kari wa go, mboro ŋa Yawe Yɛnŋɛlɛ lì duwaw ma na we. Yiŋgi na, a mà si yere laga funwa na? Mì go ki gbogolo ma kan, ma laga ka gbegele yɔngɔmɛye pe kan fun.» ");
INSERT INTO dyi_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kona, a naŋa wì si kari wa Laban wi go. A Laban wì si ti a pè yɔngɔmɛye pe tuguro ti laga pe na, mɛɛ yan naa yaayoro yaakara kan pe yeri. A wì si ti a pè pan tɔnmɔ ni jaŋgo naŋa wo naa wi pinlɛyɛɛnlɛ pe ni pe pe tɔɔrɔ ti jogo (mbege naga fɔ wì pe yaara wɔ.) ");
INSERT INTO dyi_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kona, a pè si yaakara kan pe yeri pe ka. Ɛɛn fɔ, a naŋa wì sho fɔ: «Mi se ka kaawɔ mbanla pango ki yo gbɛn.» A Laban wì suu pye fɔ: «Ki yo na kan.» ");
INSERT INTO dyi_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","A ki naŋa wì sho fɔ: «Mi yɛn Abirahamu wo kulonaŋa. ");
INSERT INTO dyi_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawe Yɛnŋɛlɛ lì duwaw na tafɔ wi na jɛŋgɛ, maa pye yarijɛndɛ lɛgɛrɛ fɔ. We Fɔ wùu kan simbaala naa sikaala ni, naa nɛrɛ, naa penjara, naa tɛ, naa kulonambala naa kulojaala, naa yɔngɔmɛye konaa sofilele ni. ");
INSERT INTO dyi_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Na tafɔ wi jɔ Sara wa wi lelɛwɛ pi ni wì pinambyɔ se wi kan. Abirahamu wùu kɛɛ yaara ti ni fuun ti kan ki pinambyɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Na tafɔ wì ti, a mì wugu ma yo wi yɛn ma cɛn wa Kana tara fɛnnɛ mbele sɔgɔwɔ, mi ka ka ki sumboro wa lɛ mboo kan wi pinambyɔ wi yeri wi jɔ. ");
INSERT INTO dyi_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ɛɛn fɔ, wìlan pye ma yo mbe pan laga wi sege woolo pe yeri, laga wi go woolo pe sɔgɔwɔ, mbe pan mbe jɛlɛ lɛ laga wi pinambyɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","A mì sigi yo na tafɔ wi kan: ‹Kana jɛlɛ wi se yɛnlɛ mbe pinlɛ na ni.› ");
INSERT INTO dyi_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A wì silan yɔn sogo ma yo fɔ: ‹Yawe Yɛnŋɛlɛ na mìlan yinwege ki pye sinŋge li yɛgɛ na, li yaa li mɛrɛgɛ wi pinlɛ ma ni, mbɔɔn konɔ li tanla. Ma jɛlɛ wa lɛ wa na sege ki ni, wa na go woolo pe sɔgɔwɔ na pinambyɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ki wuguro nda mì ti mà wugu, na maga kari wa na sege ki ni, na pee yɛnlɛ mbe sumboro wi kan ma yeri, wuguro nda mì ti mà wugu, ti sɔɔn yigi.› ");
INSERT INTO dyi_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Naa mì kaa gbɔn le pulugo ki tanla nala, a mì si yɛnri ma yo fɔ: ‹Yawe Yɛnŋɛlɛ, na tafɔ Abirahamu wi Yɛnŋɛlɛ, na konɔ li tanla na kan.› ");
INSERT INTO dyi_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mi ŋa mi yɛn ma yere na pulugo ki tanla, sumboro ŋa ka pan kosaga, mi kaga yo wi kan fɔ mila ma yɛnri, ma cɔkogo tɔnmɔ pa kan na yeri jɛnri mbe wɔ, ");
INSERT INTO dyi_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","na wiga na pye mbe yo mbe wɔ, fɔ wi yaa pa ko fun na yɔngɔmɛye pe kan pe wɔ, ko sumborombyɔ wo mbe pye jɛlɛ ŋa Yawe Yɛnŋɛlɛ lì wɔ na tafɔ wi pinambyɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Sanni mbe sa yɛnri mbe kɔ wa na nawa, a Erebeka wì si kɔn ma yiri wi cɔkogo ki ni wa wi pajogo ki na, mɛɛ tigi wa pulugo ki ni ma ko. A mì suu pye fɔ: ‹Mila ma yɛnri, na kan mbe wɔ.› ");
INSERT INTO dyi_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A wì si fyɛɛlɛ maa cɔkogo ki laga wa wi pajogo ki na, maga yɛri, mɛɛ na pye ma yo mbe wɔ, fɔ wi yaa pa kan na yɔngɔmɛye pe yeri fun pe wɔ. A mì si wɔ, a wì silan yɔngɔmɛye pe kan a pè wɔ fun. ");
INSERT INTO dyi_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","A mì suu yewe ma yo fɔ: ‹Ma yɛn ambɔ sumborombyɔ?› A wì silan yɔn sogo ma yo fɔ: ‹Mi yɛn Nahɔri naa Milika pe pinambyɔ Betuwɛli wo sumborombyɔ.› A mì si tɛ kannjinɛ na pe ma le numala na la le wa wi numala li na, mɛɛ kɛɛ kannjiŋgele tɛ wogolo le wi kɛyɛn yi na. ");
INSERT INTO dyi_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","A mì si fɔli ma Yawe Yɛnŋɛlɛ li gbɔgɔ, na tafɔ Abirahamu wi Yɛnŋɛlɛ le. Lo lìlan yɛgɛ sin wa konɔ jɛnɛ li ni, fɔ a mì saa na tafɔ wi nɔsepyɔ lenaŋa wi sumboro lɛ wi pinambyɔ wi kan jɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Koni, na kaa pye ye mbe kajɛŋgɛ pye na tafɔ wi kan tagawa ni, yege yo na kan; nakosima yege yo na kan, pa mi yaa la kee laga ka yɛgɛ ni.» ");
INSERT INTO dyi_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","A Laban naa Betuwɛli pè suu yɔn sogo ma yo fɔ: «Yawe Yɛnŋɛlɛ lo lìgi kala na li yɛgɛ sin. We se ya kendige wɔ ma ni. ");
INSERT INTO dyi_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Erebeka wi ŋa na ma yɛgɛ sɔgɔwɔ, wi lɛ maa kee wi ni, wi sa pye ma tafɔ wi pinambyɔ wi jɔ, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ lìgi yo we.» ");
INSERT INTO dyi_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Naa Abirahamu wi kulonaŋa wìla kaa pe sɛnyoro ti logo, a wì si sogo maa yɛgɛ ki jiile wa tara Yawe Yɛnŋɛlɛ li yɛgɛ na mali gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","A kulonaŋa wì si fereyaara warifuwe woro naa tɛ woro, konaa yaripɔrɔ wɔ ma kan Erebeka wi yeri, mɛɛ yarijɛndɛ sɔnŋgbanga woro kan wi ndɔ naa wi nɔ pe yeri fun. ");
INSERT INTO dyi_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ko puŋgo na, a kulonaŋa wo naa wi pinlɛyɛɛnlɛ pe ni pè si li ma wɔ, mɛɛ saa sinlɛ. Ki goto pinliwɛ pi ni, naa pàa kaa yiri, a kulonaŋa wì si Erebeka wi ndɔ naa wi nɔ pe pye fɔ: «Yanla yaga mbe sɔngɔrɔ wa na tafɔ wi yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","A Erebeka wi ndɔ naa wi nɔ pè sho fɔ: «Ki yaga sumborombyɔ wi koro laga naa jɛnri, pa pilige kɛ yɛn; kona wi sila kee.» ");
INSERT INTO dyi_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A kulonaŋa wì si pe yɔn sogo ma yo fɔ: «Yaga kanla mɔ, katugu Yawe Yɛnŋɛlɛ lìlan konɔ li tanla na kan. Yanla yaga mbe sɔngɔrɔ wa na tafɔ wi yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kona, a pè suu yɔn sogo ma yo fɔ: «Ye ti we sumborombyɔ wi yeri, we wo kpaw wi yewe karaga wogo ki ni.» ");
INSERT INTO dyi_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","A pè si Erebeka wi yeri maa yewe ma yo fɔ: «Maa jaa mbe kari ki naŋa ŋa wi ni le?» A wì sho fɔ: «Ee, mi yaa kari wi ni.» ");
INSERT INTO dyi_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kì kaa pye ma, a pè si Erebeka wo naa jɛlɛ ŋa wìla pye wi gbegelefɔ, pe yaga a pè pinlɛ Abirahamu wi kulonaŋa wo naa wi woolo pe ni ma kari. ");
INSERT INTO dyi_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","A pè si duwaw pye Erebeka wi kan ma yo fɔ: Mboro ŋa we jɔnlɔ sumboro, Yɛnŋɛlɛ li ti ma pye lelɛgɛrɛ nɔ. Ma setirige piile pe pye pe panrafɛnnɛ pe cara ti go na. ");
INSERT INTO dyi_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","A Erebeka wo naa wi kulojaala pe ni pè si yiri ma lugu yɔngɔmɛye pe na, mɛɛ taga kulonaŋa wi na. A pè si pinlɛ na kee. ");
INSERT INTO dyi_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ki wagati wi ni, Izaki wìla yiri wa Lahayi Ɔrɔyi kɔlɔ wi tanla, mɛɛ pan ma cɛn wa Negɛvu tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Pilige ka, yɔnlɔkɔgɔ ka ni, Izaki wì si yiri ma kari wa wasege ki ni mbe sa jatere pye jɛŋgɛ. A wì si kaa yɛgɛ yirige ma wele, mɛɛ yɔngɔmɛye yan paa paan wa. ");
INSERT INTO dyi_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","A Erebeka wì suu yɛgɛ ki yirige ma wele fun, mɛɛ Izaki wi yan. A wì si yiri wa yɔngɔmɛ wi na ma tigi fyaw, ");
INSERT INTO dyi_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","mɛɛ kulonaŋa wi yewe ma yo fɔ: «Naŋa wiwiin wi ŋa wo wì yiri wa wasege ki ni na paan mbe we fili?» A kulonaŋa wì sho fɔ: «Na tafɔ wowi.» Le ki yɔngɔlɔ nuŋgba ke ni, a wì suu parigbɔgɔ ki lɛ maa yɛɛ fo ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","A kulonaŋa wì si kagala ŋgele fuun wìla pye ke yɛgɛ yo ma Izaki wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ko puŋgo na, a Izaki wì si kari Erebeka wi ni wa wi nɔ Sara wìla wi yinwege ki pye paraga go ŋga ni ki ni, mɛɛ wi pɔri maa pye wi jɔ. Erebeka wìla Izaki wi ndanla. Kì pye ma, a wi kotogo kì si sogo wi na wi nɔ kunwɔ pi wogo na. ");
INSERT INTO dyi_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Kona, a Abirahamu wì si jɛlɛ wa yɛgɛ pɔri naa, pàa pye naa yinri Ketura. ");
INSERT INTO dyi_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Wìla pinambiile mbele se Abirahamu wi kan pe mɛrɛ ti nda: Zimiran, naa Yokishan, naa Medan, naa Madiyan, naa Ishibaki, konaa Shuwa. ");
INSERT INTO dyi_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","A Yokishan wo Saba naa Dedan se. Dedan setirige piile poro pàa pye Ashuri cɛnlɛ woolo, naa Letushi cɛnlɛ woolo konaa Lewumi cɛnlɛ woolo. ");
INSERT INTO dyi_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiyan pinambiile poro la wɛlɛ Efa, naa Efɛri, naa Hanɔki, naa Abida konaa Ɛlidaa. Poro pe ni fuun mbele, poro pàa pye Ketura wi setirige piile wele. ");
INSERT INTO dyi_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Kona, a Abirahamu wì suu kɛɛ yaara ti ni fuun ti kan Izaki wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ma Abirahamu wi ta yinwege na, a wì si yarikanra kan wi kulojaala mbele wìla tɛgɛ jɛɛlɛ pe pinambiile pe yeri, mɛɛ pe torogo wa tara nda wa yɔnlɔ yirisaga yeri ti ni, ma pe lali wi pinambyɔ Izaki wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abirahamu wìla ta yɛlɛ cɛnmɛ naa nafa taanri ma yiri kɛ ma yiri kaŋgurugo (175). ");
INSERT INTO dyi_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abirahamu wìla lɛ ma tin yinwege ki na, a wi lelɛwɛ pì yɔn jɛŋgɛ, a wì si jɛn ma ku ma taga wa wi tɛlɛye mbele pàa ku pe na. ");
INSERT INTO dyi_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A wi pinambiile Izaki naa Ishimayɛli pè suu le wa waliwege ŋga ki yɛn wa Makipela laga ki ni, wa Hɛti cɛnlɛ woolo naŋa Zowari wi pinambyɔ Efirɔn wi kɛrɛ, wa Mamire laga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abirahamu wìla ki kɛrɛ ti lɔ Hɛti cɛnlɛ woolo poro yeri. Pa pàa Abirahamu wo naa wi jɔ Sara wi ni, pe gboolo pe le wa. ");
INSERT INTO dyi_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abirahamu wi kuŋgɔlɔ, a Yɛnŋɛlɛ lì si duwaw wi pinambyɔ Izaki wi na. Izaki wìla pye ma cɛn wa Lahayi Ɔrɔyi kɔlɔ wi tanla. ");
INSERT INTO dyi_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Sara wi kulojɔ Agari ŋa wìla yiri wa Ezhipiti tara, wìla pinambyɔ ŋa se Abirahamu wi kan, Ishimayɛli we, wi setirige piile poro wɛlɛ mbele yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ishimayɛli wi pinambiile pe mɛrɛ ti nda ma yala pè pe se ma pe tagala pe yɛɛ na yɛgɛ ŋga na ki ni. Wi pinambyɔ koŋgbanŋa wo lawi ŋa Nebayɔti, naa Kedari, naa Adibeyɛli, naa Mibisamu, ");
INSERT INTO dyi_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","naa Mishima, naa Duma, naa Masa, ");
INSERT INTO dyi_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","naa Hadadi, naa Tema, naa Yeturi, naa Nafishi konaa Kedima. ");
INSERT INTO dyi_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Poro mbele poro pàa pye Ishimayɛli wi pinambiile kɛ ma yiri shyɛn wele. Pe ni fuun nuŋgba nuŋgba pyew pàa pye cɛngɛlɛ teele. Pàa pe mɛrɛ ti tagataga pe cara naa pe kɛrɛ kapire ti na. ");
INSERT INTO dyi_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishimayɛli wìla ta yɛlɛ cɛnmɛ naa nafa ma yiri kɛ ma yiri kɔlɔshyɛn (137), a wì si ku ma taga wa wi tɛlɛye pe na. ");
INSERT INTO dyi_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ishimayɛli wi setirige piile pàa pye ma cɛn maga lɛ wa Havila tara fɔ ma saa gbɔn wa Shuri ca. Shuri ca ki yɛn wa Ezhipiti tara ti tanla, ma wa wa Asiri tara ti yeri. Pàa cɛn ma lali Abirahamu wi setirige piile sanmbala pe ni fuun pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Sɛnrɛ nda ti yɛn na para Abirahamu wi pinambyɔ Izaki wi wogo ki na ti nda: ");
INSERT INTO dyi_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Abirahamu wìla Izaki wi se. Izaki wìla ta yɛlɛ nafa shyɛn mɛɛ Erebeka pɔri. Aramu tara fɛnnɛ naŋa Betuwɛli ŋa wìla yiri wa Padamu Aramu tara wo sumborombyɔ lawi. Aramu tara fɛnnɛ naŋa Laban wo nɔsepyɔ sumboro lawi. ");
INSERT INTO dyi_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Erebeka wi sila pye na siin. Kì kaa pye ma, a Izaki wì si Yawe Yɛnŋɛlɛ li yɛnri wi jɔ wi kan. A we Fɔ wì suu yɛnrɛwɛ pi logo, a wi jɔ Erebeka wì si kugbɔ lɛ (nɛɛ waanla singi mbe se). ");
INSERT INTO dyi_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Piile pàa pye na pe yɛɛ tɛɛrɛ wa pe nɔ wi lara. A nɔfɔ wì sho fɔ: «Na kaa pye anmɛ ki yɛn, yiŋgi na, a mì si kugbɔ lɛ?» A wì si kari ma saa Yawe Yɛnŋɛlɛ li yewe ki wogo ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","A Yawe Yɛnŋɛlɛ lì suu pye fɔ: Cɛngɛlɛ shyɛn ke yɛn wa ma lara; Ma yaa ka cɛngɛlɛ shyɛn se, ke yaa ka laga ke yɛɛ na. Cɛnlɛ nuŋgba yaa ka fanŋga ta sanna li na; ndɔfɔ wi yaa ka pye jɔnlɔfɔ wi kulo. ");
INSERT INTO dyi_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Naa Erebeka wi sesanga wìla kaa gbɔn, a pè sigi jɛn fɔ waanla pe yɛn wa wi lara. ");
INSERT INTO dyi_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","A koŋgbanŋa wì si yiri, wìla pye gbanmbɛlɛ, ma pye sire ni wi wire ti lagapyew, paa tondara sire woo yɛn. A pè suu mɛgɛ taga naa yinri Ezawu. ");
INSERT INTO dyi_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ko puŋgo na, a wi jɔnlɔ wì si yiri. Wi kɛɛ kìla pye ma Ezawu wi yeŋgbele li yigi. A pè suu mɛgɛ taga naa yinri Zhakɔbu. Izaki wìla ta yɛlɛ nafa taanri pe sesanga wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","A pinambigile kè si yiri ma lɛ. Ezawu wìla pye koniyɛɛn gbɔɔ, a yan yanraga kùu ndanla. Ɛɛn fɔ, Zhakɔbu wo la pye lere ŋa wi yɛn pɔw. Wìla pye na korogi wa paraga go ki ni paa yɛgɛ ŋga na kìla wi ndanla we. ");
INSERT INTO dyi_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ezawu wìla pye ma Izaki wi ndanla, katugu wìla pye na kara kuun, a wila kaa. Ma si yala Zhakɔbu wìla pye ma Erebeka ndanla. ");
INSERT INTO dyi_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Pilige ka Zhakɔbu wìla pye na yara nda pe yinri lantiyi ta sori. A Ezawu wì si yiri wa kɛrɛ ma ye. Wìla pye ma te fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","A wì si Zhakɔbu wi yɛnri maa pye fɔ: «Ki yaga mbege yara yɛnrɛ nda ta ka, ki yara yɛnrɛ nda re, katugu mi yɛn ma te, fuŋgo ki yɛn na na.» Ko kala na pège mɛgɛ ŋga ki taga Ezawu wi na naa yinri Edɔmu. ");
INSERT INTO dyi_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","A Zhakɔbu wì suu pye fɔ: «Ma lelɛwɛ tɔnli wi kan na yeri gbɛn nala.» ");
INSERT INTO dyi_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","A Ezawu wì suu yɔn sogo ma yo fɔ: «Wele, mi yɛn na jaa mbe ku fuŋgo ki kɛɛ. Yiŋgi ki lelɛwɛ tɔnli wi yaa yɔn na kan?» ");
INSERT INTO dyi_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kona, a Zhakɔbu wì suu pye fɔ: «Wugu mala kan ki wogo ki na gbɛn.» A Ezawu wì si wugu maa kan, mɛɛ wi lelɛwɛ tɔnli wi kan wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kona, a Zhakɔbu wì si buru naa yara yɛnrɛ kan Ezawu wi yeri. A wì si ka ma wɔ mɛɛ yiri ma kari. Kì pye ma, Ezawu wi sila wi lelɛwɛ tɔnli wi jate yaraga. ");
INSERT INTO dyi_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Fuŋgo kà la to wa Kana tara ti ni. Ko fuŋgo ko la pye ki yɛ Abirahamu wagati wogo ko ni. A Izaki wì si kari Filisiti tara fɛnnɛ wunlunaŋa Abimelɛki wi kɔrɔgɔ wa Gerari ca. ");
INSERT INTO dyi_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","A Yawe Yɛnŋɛlɛ lì sili yɛɛ naga Izaki wi na maa pye fɔ: «Maga ka kari wa Ezhipiti tara, ɛɛn fɔ, ma sa cɛn wa tara nda mi yaa ti sɛnrɛ yo ma kan ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ma cɛn laga ki tara nda ti ni, mi yaa lɔɔn go singi mbe duwaw ma na, katugu mi yaa ki tara nda ti ni fuun ti kan mboro naa ma setirige piile ye yeri. Wuguro nda mìla wugu ma to Abirahamu wi kan, pa mi yaa ki kala li yɔn fili yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mi yaa kɔɔn setirige piile pe pye pe lɛgɛ, paa naayeri wɔnŋgɔlɔ ke yɛn. Mi yaa kaga tara nda ti ni fuun ti kan pe yeri. Cɛngɛlɛ ŋgele fuun ke yɛn laga tara na, mi yaa ka duwaw ke na pe kala na, ");
INSERT INTO dyi_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","katugu Abirahamu wìla tanga ma yala na sɛnyoro ti ni, naa na kondɛgɛŋgɛlɛ, naa na kakɔnndɛgɛŋgɛlɛ, koro naa na ŋgasegele ke ni.» ");
INSERT INTO dyi_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kì kaa pye ma, a Izaki wì si koro ma cɛn wa Gerari ca. ");
INSERT INTO dyi_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Naa ki laga ki nambala pàa kaa wi yewe wi jɔ wi wogo ki ni, a wì si pe pye fɔ: «Na jɔnlɔ sumboro wi.» Wi sila soro mbege yo mbe yo Erebeka wi yɛn wi jɔ, katugu wìla pye na fyɛ maga yan ndɛɛ ki laga ki nambala pe yaa wi gbo mbe Erebeka wi lɛ wi tiyɔnwɔ pi kala na. ");
INSERT INTO dyi_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Naa Izaki wìla kaa na mɔni wa Gerari ca, pilige ka, a Filisiti tara fɛnnɛ wunlunaŋa Abimelɛki wì si wele wa wi go fenɛtiri wi ni, mɛɛ Izaki wi yan wila wi jɔ Erebeka wi gbara, naa talitali. ");
INSERT INTO dyi_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","A Abimelɛki wì suu yeri mɛɛ wi pye fɔ: «Jaga ma jɔ wi piiri. Kì pye mɛlɛ, a mà sho fɔ ma jɔnlɔ sumboro wi?» A Izaki wì suu pye fɔ: «Mìla fyɛ maga yo ma, jaŋgo paga kanla gbo na jɔ wi kala na.» ");
INSERT INTO dyi_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kona, a Abimelɛki wì suu pye fɔ: «Yiŋgi mà pye we na yɛɛn? Kì koro jɛnri anmɛ we woo wa sinlɛ ma jɔ wi ni. Pa ma jɛn na we kan we kapege pye.» ");
INSERT INTO dyi_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kì kaa pye ma, a Abimelɛki wì sigi yo maga ŋgban wi tara woolo pe ni ma yo fɔ: «Lere ŋa fuun ka kapege pye ki naŋa ŋa wo naa wi jɔ pe na, wo daga mbe ku.» ");
INSERT INTO dyi_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ki yɛlɛ li ni, a Izaki wì si yariluguro lugu wa ki tara ti ni; a tì si yɔn fɔ jɛŋgɛ, katugu Yawe Yɛnŋɛlɛ làa duwaw wi na. ");
INSERT INTO dyi_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Izaki wi yarijɛndɛ tìla pye na lege na kee yɛgɛ, fɔ a wì saa pye penjagbɔrɔ fɔ. ");
INSERT INTO dyi_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Simbaŋgbelege la pye wi yeri, naa sikaala ŋgbelege ni, naa nɛrɛ ŋgbelege ni, konaa kulolo lɛgɛrɛ ni. Filisiti tara fɛnnɛ pàa pye na yenjara piin Izaki wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Wi to Abirahamu wi sanga wi na, wi kulonambala pàa kɔlɔye mbele wɔ, a Filisiti tara fɛnnɛ pè si tara ko ma le wa pe ni ma pe tɔnndɔ. ");
INSERT INTO dyi_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","A Abimelɛki wì si Izaki wi pye fɔ: «Ta kee ma wɔ laga we sɔgɔwɔ, katugu ma fanŋga kì wɛ we wogo ki na.» ");
INSERT INTO dyi_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","A Izaki wì si yiri le mɛɛ saa paara yinrɛ cɛnsaga kan wa Gerari ca gbunlundɛgɛ ki ni, ma cɛn wa. ");
INSERT INTO dyi_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kɔlɔye mbele pàa wɔ Izaki wi to Abirahamu sanga wi na, a Filisiti tara fɛnnɛ pè pe tɔn Abirahamu wi kuŋgɔlɔ, Izaki wìla pe wɔ naa fɔnŋgɔ; mɛrɛ nda wi to wìla taga pe na, a wì siri taga pe na naa. ");
INSERT INTO dyi_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Pilige ka, a Izaki wi kulolo pè si kɔlɔ wa wɔ wa Gerari ca gbunlundɛgɛ ki ni, mɛɛ saa yiri tɔnmɔ kologo na ŋga kila pulo. ");
INSERT INTO dyi_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","A Gerari ca yaayoro kɔnrifɛnnɛ pe nɛɛ wiin Izaki yaayoro kɔnrifɛnnɛ pe ni, ma yo tɔnmɔ pi yɛn poro woo. A Izaki wì si kɔlɔ wi mɛgɛ taga naa yinri Ezɛki, katugu pàa win wi ni wi go na. ");
INSERT INTO dyi_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","A wi kulolo pè si kɔlɔ wa wɔ naa. A pè win wi ni fun ki woo wi go na; a wì suu mɛgɛ taga naa yinri Sitina. ");
INSERT INTO dyi_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","A Izaki wì si yiri le ko laga ko na, mɛɛ saa kɔlɔ wa yɛgɛ wɔ naa. Lere sila win wi ni wo kala na; a wì suu mɛgɛ taga naa yinri Erehobɔti, katugu wìla ki yo fɔ: «Koni Yawe Yɛnŋɛlɛ lì we kotogo ki sogo we na, we yaa se mbe lɛgɛ mbe yarijɛndɛ ta laga tara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","A Izaki wì si yiri lema mɛɛ kari wa Bɛrisheba. ");
INSERT INTO dyi_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ki yembinɛ li ni, a Yawe Yɛnŋɛlɛ lì si li yɛɛ naga Izaki wi na maa pye fɔ: «Mi yɛn ma to Abirahamu wi Yɛnŋɛlɛ. Maga ka fyɛ, mi yɛn nɔɔ go singi. Mi yaa duwaw ma na, mbɔɔn setirige piile pe pye pe lɛgɛ, na tunmbyee Abirahamu wi kala na.» ");
INSERT INTO dyi_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","A Izaki wì si saraga wɔsaga kan wa ki laga ki na, ma Yawe Yɛnŋɛlɛ li mɛgɛ ki yeri mali gbɔgɔ. A wì suu paara yinrɛ ti kan wa; a wi kulolo pè kɔlɔ wa wɔ wa. ");
INSERT INTO dyi_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","A Abimelɛki naa wi wɔnlɔnaŋa Ahuzati, konaa wi maliŋgbɔɔnlɔ to Pikɔli wi ni, pè si yiri wa Gerari ca, mɛɛ kari Izaki wi kɔrɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","A Izaki wì si pe yewe ma yo fɔ: «Yiŋgi na, a yè si pan laga na kɔrɔgɔ, ma si yala yànla panra mala purɔ mala wɔ wa ye sɔgɔwɔ?» ");
INSERT INTO dyi_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","A pè suu yɔn sogo ma yo fɔ: «Wège wele maga yan fɔ Yawe Yɛnŋɛlɛ li yɛn ma ni. Ko kala na wè yo: ‹Ki daga we wugu we yɛɛ kan, we yɔn finliwɛ le we yɛɛ sɔgɔwɔ, woro naa mboro. ");
INSERT INTO dyi_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Po pi yaa ti ma se ka kapege ka kpɛ pye we na, paa yɛgɛ ŋga na woro fun we sɔɔn jɔlɔ we. Ɛɛn fɔ, kajɛŋgɛ wè pye mɔɔ kan bɔkɔ, mɛɛ ma yaga, a mà kari yɛyinŋge na. Koni Yawe Yɛnŋɛlɛ lì duwaw ma na.› » ");
INSERT INTO dyi_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","A Izaki wì si sɔgɔlɔ gbɔlɔ sɔgɔ pe kan, a pè li, ma wɔ, ma tin. ");
INSERT INTO dyi_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ki goto pinliwɛ pi ni, a pè si yiri ma wugu ma pe yɛɛ kan (ma yɔn finliwɛ le pe yɛɛ ni). A Izaki wì si konɔ li kan pe yeri. A pè si kari yɛyinŋge na. ");
INSERT INTO dyi_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ki pilige nuŋgba ki ni, Izaki wi kulolo pèle la pye na kɔlɔ wa woo, mɛɛ pan maa sɛnrɛ yo maa kan ma yo fɔ: «We tɔnmɔ ta kɔlɔ wa ni.» ");
INSERT INTO dyi_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","A Izaki wì sigi kɔlɔ wi mɛgɛ taga naa yinri Shiba. Ko ki ti ali ma pan ma gbɔn nala, pe maa ki ca ki yinri Bɛrisheba. ");
INSERT INTO dyi_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ezawu wìla ta yɛlɛ nafa shyɛn mɛɛ jɛɛlɛ shyɛn pɔri: Hɛti cɛnlɛ woolo naŋa Beeri wi sumborombyɔ Zhuditi wo naa Hɛti cɛnlɛ woolo naŋa Elɔn wi sumborombyɔ Basimati wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ki jɛɛlɛ pàa Izaki naa Erebeka pe nawa pi tanga pe na fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Izaki wìla lɛ jɛŋgɛ, a wi yɛngɛlɛ kè te, wii ya mbaa yaan naa. Kì kaa pye ma, a wì suu pinambyɔ koŋgbanŋa Ezawu wi yeri maa pye fɔ: «Na pinambyɔ.» A wì si shɔ ma yo fɔ: «Naw.» ");
INSERT INTO dyi_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","A Izaki wì sho fɔ: «Wele, mì lɛ makɔ, mi silan kupilige ki jɛn. ");
INSERT INTO dyi_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Koni ma koniyɛɛnrɛ yaara ti lɛ, ko kɔrɔ wo yɛn ma sanŋgbɔ wo naa ma sandiga ki ni, ma kari wa yan ma sa yanri ma kara ta gbo na kan. ");
INSERT INTO dyi_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kara nda ti yɛn mala ndanla, mari sɔgɔ na kan, ma pan ti ni mberi ka, jaŋgo mi jate mbe duwaw pye ma kan, si jɛn mbe ku.» ");
INSERT INTO dyi_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ma si yala Izaki wìla pye na para wi pinambyɔ Ezawu wi ni sanga ŋa ni, Erebeka wìla pye naga sɛnrɛ ti nuru. A Ezawu wì si kari wa yan mbe sa kara ta gbo mbe pan ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Kona, a Erebeka wì suu pinambyɔ Zhakɔbu wi pye fɔ: «Mìgi logo ma to wi yeri wila ma ndɔ Ezawu wi piin fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹Kari ma sa kara ta gbo, ma kara nda ti yɛn mala ndanla ti sɔgɔ na kan mberi ka. Mi yaa duwaw pye ma kan Yawe Yɛnŋɛlɛ li yɛgɛ na, si jɛn mbe ku.› ");
INSERT INTO dyi_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Koni na pinambyɔ, ta nuru na yeri, mi ka ŋga yo ma kan, ma ko pye. ");
INSERT INTO dyi_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kari wa sikaala ŋgbelege ki ni, ma sa sikaala yirifɔnmbɔlɔ tiyɔngɔlɔ shyɛn yigi na kan. Mi yaa kara nda tɔɔn to wi ndanla ti sɔgɔ wi kan, ");
INSERT INTO dyi_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","mɛɛ ti lɛ ma sari kan ma to wi yeri, wi ta ka jaŋgo wi duwaw pye ma kan, si jɛn mbe ku.» ");
INSERT INTO dyi_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","A Zhakɔbu wì suu nɔ Erebeka wi yɔn sogo ma yo fɔ: «Kaselege mà yo. Ɛɛn fɔ, na ndɔ Ezawu wi yɛn sire ni, sire si woro mi na. ");
INSERT INTO dyi_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kana na to wi yaa na talitali mbe wele (si jɛn mbe duwaw pye na kan), pa kona mi yaa pye wi yɛgɛ na leele fanlafɔ. Kiga pye ma, mi yaa ti wilan daŋga, wi se duwaw pye na kan.» ");
INSERT INTO dyi_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","A wi nɔ wì suu pye fɔ: «Na pinambyɔ, ki daŋga ki mi yigi! Ta nuru na yeri san, ma sa ki sikaala yirifɔnmbɔlɔ pe yigi ma pan pe ni na kan.» ");
INSERT INTO dyi_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","A Zhakɔbu wì si kari ma saa pe yigi ma pan pe ni, mɛɛ pe gbegele wi nɔ wi kan. A nɔfɔ wì si kara nda tì Zhakɔbu wi to wi ndanla ti sɔgɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ko puŋgo na, a Erebeka wì suu pinambyɔ lɛrɛfɔ Ezawu wi yaripɔrɔ, ti ti ni fuun tiyɔnrɔ nda wìla tɛgɛ wa go, ti lɛ mari le wi pinambyɔ shyɛnwoo Zhakɔbu wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","A wì si sikaala yirifɔnmbɔlɔ pe sɛɛrɛ ti lɛ, ma Zhakɔbu wi kɛyɛn yi fo ti ni, konaa wi yɔlɔgɔ lara nda tìla pye sire fu ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","A wì si kara tanra to naa yaakara nda wìla sɔgɔ ti le wi pinambyɔ Zhakɔbu wi kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","A Zhakɔbu wì si kari ti ni wi to wi kɔrɔgɔ, mɛɛ wi yeri maa pye fɔ: «Na to.» A Izaki wì si shɔ ma yo fɔ: «Naw! Ambɔ wi mboro, na pinambyɔ?» ");
INSERT INTO dyi_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","A Zhakɔbu wì suu pye fɔ: «Muwi, Ezawu, ma pinambyɔ koŋgbanŋa we. Ŋga mà yo mbe pye, mìgi pye. Mila ma yɛnri, yiri ma cɛn mala kara ta ka, jaŋgo mboro jate ma duwaw pye na kan.» ");
INSERT INTO dyi_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","A Izaki wì suu pinambyɔ wi yewe maa pye fɔ: «Mà pye mɛlɛ mɛɛ kara ta ta fyaw na pinambyɔ?» A Zhakɔbu wì sho fɔ: «Yawe Yɛnŋɛlɛ, ma Yɛnŋɛlɛ le, lo lì kara ti pye a tì pan na kɔrɔgɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","A Izaki wì si Zhakɔbu wi pye fɔ: «Fulo laga na tanla mbɔɔn talitali mbe wele na pinambyɔ, mbe ta mbege jɛn fɔ na pinambyɔ Ezawu wowi mboro kaselege.» ");
INSERT INTO dyi_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","A Zhakɔbu wì si fulo wa wi to Izaki wi tanla, a Izaki wì suu talitali ma wele, mɛɛ yo fɔ: «Magala lo yɛn Zhakɔbu magala, kɛyɛn yo yɛn Ezawu kɛyɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Wi sila Zhakɔbu wi jɛn, katugu wi kɛyɛn yìla pye pa wi ndɔ Ezawu wi woyo yi yɛn. A wì si duwaw pye maa kan. ");
INSERT INTO dyi_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","(Sanni Izaki wi sa duwaw pye wi kan), a wì suu yewe naa ma yo fɔ: «Kaselege mboro ma yɛn na pinambyɔ Ezawu we le?» A wì suu yɔn sogo ma yo fɔ: «Ee, wowi mi we.» ");
INSERT INTO dyi_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","A Izaki wì sho fɔ: «Yaakara ta ko na kan na pinambyɔ, mbe ta mbɔɔn kara ta ka, jaŋgo mi jate mbe duwaw pye ma kan.» A Zhakɔbu wì si ta ko wi kan, a wì ka, mɛɛ duvɛn kan wi yeri fun, a wì wɔ. ");
INSERT INTO dyi_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kona, a wi to Izaki wì suu pye fɔ: «Fulo laga na tanla ma kɛyɛn wa na yɔlɔgɔ mala shari na pinambyɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","A Zhakɔbu wì si fulo wa wi tanla mɛɛ kɛyɛn wa wi yɔlɔgɔ maa shari. A Izaki wì suu yaripɔrɔ ti nuwɔ ta, mɛɛ duwaw pye wi kan ma yo fɔ: «Kaselege ko na, na pinambyɔ wi nuwɔ pi yɛn paa kɛrɛ nda Yawe Yɛnŋɛlɛ lì duwaw ti na ti nuwɔ pi yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Yɛnŋɛlɛ sa fɔɔngɔ ŋga ki maa yinrigi wa naayeri na wuun ki kan ma yeri, li tara ti yarijɛndɛ ti kan ma yeri! Li yarilire nda pe yinri bile to naa duvɛn fɔnŋɔ kan ma yeri lɛgɛrɛ! ");
INSERT INTO dyi_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tara woolo paa tunŋgo piin ma kan, konaa cɛngɛlɛ kaa fɔli kaa ma kaan! Ma cɛn ma nɔsepiile pe go na, paa fɔli paa ma kaan. Lere ŋa kɔɔn daŋga, daŋga mbe wo yigi; lere ŋa ka duwaw pye ma kan, wo mbe duwaw ta.» ");
INSERT INTO dyi_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Naa Izaki wìla kaa kɔ duwaw pyege ki na Zhakɔbu wi kan, a Zhakɔbu wì si yiri. Pa wila yinrigi le wi to wi tanla, a wi ndɔ Ezawu wì si yiri wa yanrisaga ma ye. ");
INSERT INTO dyi_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A wì si kara tanra ta sɔgɔ fun, mɛɛ pan mari kan wi to wi yeri, ma suu pye fɔ: «Yiri ma cɛn na to, ma kara nda mì pan ma kan ta ka, jaŋgo ma ta ma duwaw pye na kan.» ");
INSERT INTO dyi_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","A wi to Izaki wì suu yewe maa pye fɔ: «Ambɔ wi mboro?» A wì sho fɔ: «Muwi, Ezawu, ma pinambyɔ we.» ");
INSERT INTO dyi_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","A Izaki wi jatere wì si piri wi na, fɔ a wila seri ŋgbanga. A wì si yewe ma yo fɔ: «A Ambɔ si saa kara ta gbo ma pan ti ni na kan, a mì ti ni fuun ti ka, a mà si jɛn ma pan? Ko fɔ wo mì duwaw pye wi kan; ki duwaw wi yaa si yigi.» ");
INSERT INTO dyi_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Naa Ezawu wìla kaa wi to wi sɛnyoro ti logo, a wi nawa pì si tanga wi na, a wì si gbele ŋgbanga, mɛɛ wi to wi yɛnri ma yo fɔ: «Duwaw wa pye na kan fun.» ");
INSERT INTO dyi_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","A Izaki wì suu yɔn sogo ma yo fɔ: «Ma jɔnlɔ wì pan mala fanla, mɔɔ duwaw wi shɔ maa ta.» ");
INSERT INTO dyi_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","A Ezawu wì sho fɔ: «Jaga wi Zhakɔbu mɛgɛ kì yala wi ni, ki kɔrɔ wo yɛn: Lere ŋa wi maa leele fanla, katugu wìlan fanla fanlasaga shyɛn. Wìla keli mala lelɛwɛ tɔnli wi shɔ na yeri, kooŋga wì nuru ma duwaw ŋa wi jɛn na pye na woo wi shɔ na yeri.» A Ezawu wì sho naa fɔ: «Duwaw wa si koro wa ma yeri naa ma pye na kan?» ");
INSERT INTO dyi_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","A Izaki wì suu yɔn sogo maa pye fɔ: «Wele, mùu tɛgɛ ma go na. Mùu nɔsepiile pe ni fuun pe le wi kɛɛ, pe pye wi kulolo. Mì bile wo naa duvɛn kan wi yeri. Mi se ya yaraga ka kpɛ pye ma kan naa na pinambyɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","A Ezawu wì suu to wi pye fɔ: «Baba, duwaw nuŋgba ŋa wo wi yɛn wa mboro yeri. Baba, duwaw wa pye na kan fun.» A Ezawu wi nɛɛ gbele ŋgbanga. ");
INSERT INTO dyi_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","A wi to Izaki wì suu yɔn sogo ma yo fɔ: Wele, tara ti yarijɛndɛ to naa fɔɔngɔ ŋga ki maa yinrigi wa naayeri na tuun tara, ti yaa pye mbe lali ma ni. ");
INSERT INTO dyi_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ma yaa kaa ma yɔn suro ti taa ma tokobi wo fanŋga na. Ma yaa kaa kulowo piin ma jɔnlɔ wi kan. Ɛɛn fɔ, ma yaa ka koro ma yɛɛ na, mbaa yanri la toro, mbɔɔn yɛɛ shɔ wi kulowo mba wi yaa taga ma na pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","A Ezawu wì si Zhakɔbu wi panra duwaw ŋa wi to wìla pye wi kan wi kala na. Ezawu wìla pye naga yuun wa wi nawa fɔ: «Na to wi yaa ku pilige ŋga ni ki yɛn na yɔngɔ. Wi kunwɔ piliye yi puŋgo na, pa mi yaa na jɔnlɔ Zhakɔbu wi gbo.» ");
INSERT INTO dyi_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Erebeka wi pinambyɔ koŋgbanŋa Ezawu wi sɛnrɛ nda wìla yo, pàa ti yo Erebeka wi kan. A wì si ti, a pòo pinambyɔ shyɛnwoo Zhakɔbu wi yeri wi kan. A wì suu pye fɔ: «Wele, ma ndɔ Ezawu wila jaa mboo kayaŋga ki wɔ ma ni mbɔɔn gbo. ");
INSERT INTO dyi_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Koni, na pinambyɔ, logo na yeri! Yiri ma fe, ma sa lara wa na ndɔ Laban wi yeri wa Haran ca. ");
INSERT INTO dyi_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ma koro wa wi ni sa gbɔn wagati wa ni, fɔ ma ndɔ wi naŋgbanwa pi sa sogo wi na. ");
INSERT INTO dyi_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Na ma ndɔ wi naŋgbanwa piga ka sogo ma kanŋgɔlɔ, a wì fɛgɛ ŋga mà pye wi na ki na, pa kona mi yaa ti ma pan; katugu mi woro na jaa mbe ye shyɛn ye la pilige nuŋgba ki ni.» ");
INSERT INTO dyi_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","A Erebeka wì si Izaki wi pye fɔ: «Na yinwege kì la kɔ na na, na pijaala, Hɛti cɛnlɛ woolo pe kala na. Na Zhakɔbu wiga Hɛti cɛnlɛ woolo sumborombyɔ wa pɔri, ki tara nda ti sumborombiile wo wa nuŋgba, paa mbele pe yɛn, mbe ku pa ko mbe mbɔnrɔ na yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kona, a Izaki wì si Zhakɔbu wi yeri mɛɛ duwaw pye wi kan, ma yo fɔ: «Maga ka Kana tara fɛnnɛ sumboro wa pɔri ma jɔ. ");
INSERT INTO dyi_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Yiri ma kari wa Padamu Aramu tara, wa ma nɔ wi to Betuwɛli wi yeri, ma sa ma nɔ wi ndɔ Laban wi sumborombiile wo wa pɔri ma jɔ. ");
INSERT INTO dyi_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Yɛnŋɛlɛ na yawa pi ni fuun fɔ, li duwaw ma na, lɔɔn pye sevɔ, ma pilɛgɛrɛ se, ma pye cɛngɛlɛ lɛgɛrɛ to. ");
INSERT INTO dyi_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Làa duwaw ŋa kan Abirahamu wi yeri, ligi duwaw cɛnlɛ nuŋgba wi kan mboro naa ma setirige piile ye yeri, jaŋgo tara nda ma yɛn ma cɛn laga ti ni paa nambanŋa yɛn, ti pye ma woro. Ko tara nda to Yɛnŋɛlɛ làa kan Abirahamu wi yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kì kaa pye ma, a Izaki wì si Zhakɔbu wi torogo wila kee. A wì si kari wa Aramu tara fɛnnɛ naŋa Betuwɛli wi pinambyɔ Laban wi yeri. Zhakɔbu naa Ezawu pe nɔ Erebeka wo ndɔ lawi. ");
INSERT INTO dyi_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ezawu wìla ki logo ma yo Izaki wìla duwaw pye Zhakɔbu wi kan, maa torogo wa Padamu Aramu tara wi sa jɛlɛ wa pɔri wama; wìla sigi logo fun ma yo sanga ŋa ni Izaki wìla pye na duwaw wi piin wi kan, wìla ki yo maga ŋgban wi ni fɔ wiga ka Kana tara fɛnnɛ sumboro wa pɔri wi jɔ. ");
INSERT INTO dyi_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","A wìgi yan fɔ Zhakɔbu wìla tanga wi to naa wi nɔ pe sɛnyoro ti na, ma kari wa Padamu Aramu tara. ");
INSERT INTO dyi_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kona, a Ezawu wì sigi jɛn ma yo Kana tara fɛnnɛ sumbonɔ pe sila wi to Izaki wi ndanla. ");
INSERT INTO dyi_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kì kaa pye ma, a Ezawu wì si kari Abirahamu wi pinambyɔ Ishimayɛli wi kɔrɔgɔ, ma saa wi sumborombyɔ ŋa pàa pye na yinri Mahalati wi pɔri ma taga wi jɛɛlɛ koŋgbanmbala pe na. Mahalati wìla pye Nebayɔti wo nɔsepyɔ sumboro. ");
INSERT INTO dyi_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Kona, a Zhakɔbu wì si yiri wa Bɛrisheba nɛɛ kee wa Haran ca. ");
INSERT INTO dyi_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","A wì si saa gbɔn laga ka na mɛɛ wɔnlɔ le, katugu yɔnlɔ kìla to. A wì sigi laga ki sinndɛlɛgɛ nuŋgba lɛ ma go gbɔn ki na, mɛɛ sinlɛ le ki laga ki na. ");
INSERT INTO dyi_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","A wì si wɔɔnrɔ wɔnlɔ, mɛɛ yɛrɛyɛrɛna wa yan wi go kì kan laga tara ti na, a wi numaga kila jiinri wa yɛnŋɛlɛ na. Yɛnŋɛlɛ li mɛrɛgɛye pàa pye na nuru na tinri wi na. ");
INSERT INTO dyi_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yawe Yɛnŋɛlɛ làa pye ma yere wa yɛrɛyɛrɛna wi naayeri, mɛɛ Zhakɔbu wi pye fɔ: «Muwi mi yɛn Yawe Yɛnŋɛlɛ, ma tɛlɛ Abirahamu wo naa Izaki pe Yɛnŋɛlɛ le. Tara nda ma yɛn ma sinlɛ ti na, mi yaa ti kan mboro naa ma setirige piile ye yeri. ");
INSERT INTO dyi_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ma setirige piile pe yaa ka lɛgɛ paa taambugɔ yɛn. Ye yaa ka lɛgɛ, mbe jaraga, mbe kari wa yɔnlɔ yirisaga naa yɔnlɔ tosaga yeri, naa yɔnlɔparawa kamɛŋgɛ kɛɛ naa yɔnlɔparawa kalige kɛɛ yeri. Mboro naa ma setirige piile ye kala na, mi yaa ka duwaw cɛngɛlɛ ke ni fuun ke na laga tara na. ");
INSERT INTO dyi_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Wele, mi jate mi yɛn ma ni, maga kari laga o laga, mi yaa lɔɔn go singi. Mi yaa kɔɔn pye ma sɔngɔrɔ laga ki tara nda ti ni. Mi sɔɔn wa, ŋga fuun mì yo ma kan, mi yaa ki pye mbege yɔn fili.» ");
INSERT INTO dyi_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","A Zhakɔbu wì si yɛn mɛɛ yo fɔ: «Kaselege ko na, Yawe Yɛnŋɛlɛ li yɛn na ki laga ŋga ki ni, mii si jaga jɛn na.» ");
INSERT INTO dyi_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","A wì si fyɛ ma sho fɔ: «Ki laga ŋga ki yɛn fyɛrɛ ni. Laga ka kpɛ ma Yɛnŋɛlɛ li go ko puŋgo na. Yeyɔngɔ ŋga ki maa yiin wa yɛnŋɛlɛ na, namɛ ki yɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ki goto yirifaga ki na, a Zhakɔbu wì si yiri, mɛɛ sinndɛlɛgɛ ŋga wìla go gbɔn ki na ki lɛ, mɛɛ titɛgɛ kɔn maga yerege, ma sinmɛ wo wa ki go na mbege naga fɔ wìgi le Yɛnŋɛlɛ kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A wì sigi laga ki mɛgɛ taga naga yinri Betɛli. Ɛɛn fɔ pàa pye naga ca ki yinri faa Luzi. ");
INSERT INTO dyi_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","A Zhakɔbu wì si yɔn fɔlɔ lɛ ma yo fɔ: «Na Yɛnŋɛlɛ liga koro na ni, mbaa na go singi na kondangala li na, mbaa yaakara kaan na yeri mbaa kaa, konaa yaripɔrɔ ni mbaa nii, ");
INSERT INTO dyi_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na mi ka sɔngɔrɔ yinŋge wa na to go, kona pa Yawe Yɛnŋɛlɛ li yaa pye na Yɛnŋɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ki sinndɛlɛgɛ ŋga mì yerege maga kan Yɛnŋɛlɛ yeri, ki laga ki yaa ka pye Yɛnŋɛlɛ li go. Liga yaraga ŋga fuun kan na yeri, mi yaa ki walisaga kɛwogo ki kan li yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ko puŋgo na, a Zhakɔbu wì si yiri ma konɔ li lɛ naa, mɛɛ kari wa tara ti yɔnlɔ yirisaga yeri. ");
INSERT INTO dyi_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Pilige ka, a wì si saa kɔlɔ wa yan wa wasege. Simbaala naa sikaala ŋgbeleye taanri la pye ma sinlɛ le kɔlɔ wi tanla na wogo. Pa pàa pye na kori wa ki kɔlɔ wi ni na pe kaan paa woo. Sinndɛlɛgɛ ŋga pàa pye na kɔlɔ wi yɔn tɔnni, kìla pye ma gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Na paga ka pan mbe yaayoro ŋgbeleye yi ni fuun yi gbogolo le, pe mɛɛ sinndɛlɛgɛ ki koŋgo maga laga wa kɔlɔ wi yɔn na, mbe si ko mbe yaayoro ti kan ti ma wɔ. Ko puŋgo na, pe mɛɛ sinndɛlɛgɛ ki sɔngɔrɔ maga taga wa ki yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","A Zhakɔbu wì si yaayoro kɔnrifɛnnɛ pe yewe ma yo fɔ: «Sefɛnnɛ, ye yiri se yeri?» A pè suu pye fɔ: «Wè yiri wa Haran ca.» ");
INSERT INTO dyi_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A wì si pe yewe fɔ: «Nahɔri pinambyɔ Laban, yoo jɛn le?» A pè sho fɔ: «Ee, wòo jɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","A wì si pe yewe ma yo fɔ: «Wi yɛn ŋgbaan le?» A pè sho fɔ: «Ee, wi yɛn wa ŋgbaan. Wele, wi sumborombyɔ Arashɛli wi ŋa wila paan wa wi yaayoro ŋgbelege ki ni.» ");
INSERT INTO dyi_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","A Zhakɔbu wì sho fɔ: «Ye wele, yɔnlɔ wa bere, yaayoro gbogolosanga wi fa gbɔn gbɛn ti sinlɛ. Ye yaayoro ti kan ti wɔ, ye kari ye saa yanri ti ni tila kaa.» ");
INSERT INTO dyi_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","A pè suu pye fɔ: «We se ya mbege pye ma, fɔ ndɛɛ pe sa yaayoro ŋgbeleye yi ni fuun yi gbogolo na gbɛn. Pa kona, sinndɛlɛgɛ ŋga ki yɛn ma kɔlɔ wi yɔn tɔn, pe mɛɛ ki koŋgo mbege laga wa wi yɔn na, mbe si ko mbe yaayoro ti kan ti ma wɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ma Zhakɔbu wi ta wìla pye na para pe ni bere, a Arashɛli wì si pan ma gbɔn le wi to yaayoro ti ni, katugu Arashɛli wìla pye yaayoro kɔnrifɔ. ");
INSERT INTO dyi_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Naa Zhakɔbu wìla wi nɔ ndɔ Laban wi sumborombyɔ Arashɛli wi yan wila paan wi lɛɛ Laban wi yaayoro ŋgbelege ki ni, a Zhakɔbu wì si fulo wa kɔlɔ wi tanla, ma sinndɛlɛgɛ ŋga kìla pye wa wi yɔn na ki koŋgo maga laga wa, mɛɛ ko maa lɛɛ Laban wi yaayoro ŋgbelege ki kan, a kì wɔ. ");
INSERT INTO dyi_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","A Zhakɔbu wì si kɛyɛn wa Arashɛli wi yɔlɔgɔ maa shari nɛɛ gbele nayinmɛ coli. ");
INSERT INTO dyi_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","A Zhakɔbu wì sigi yo Arashɛli wi kan ma yo wi yɛn wi to go lere wo wa, fɔ wi yɛn Erebeka wo pinambyɔ. A Arashɛli wì si fe ma saa ki yɛgɛ yo wi to wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Naa Laban wìla kaa wi jɔnlɔ sumboro wi pinambyɔ Zhakɔbu wi panga sɛnrɛ ti logo, a wì si fe ma saa wi fili, ma kɛyɛn wa wi yɔlɔgɔ maa shari maa mara wi yɛɛ na. A wì suu lɛ ma kari wi ni wa wi go. A Zhakɔbu wì si kagala ŋgele fuun kàa pye wi na ke yɛgɛ yo Laban wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","A Laban wì suu pye fɔ: «Kaselege ko na, ma yɛn na go lere wo wa, ma yɛn kasanwa nuŋgba na ni.» Zhakɔbu wìla yeŋge nuŋgba poni ko pye wa Laban wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Pilige ka, a Laban wì si Zhakɔbu wi pye fɔ: «Ma yɛn na go lere, ɛɛn fɔ, kii daga maa tunŋgo piin na kan waga. Ma sara wi daga mbe pye yaraga ŋga, ki yo na kan.» ");
INSERT INTO dyi_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ma si yala, sumborombiile shyɛn la pye Laban wi yeri. Sumboro lɛrɛfɔ pàa pye naa yinri Leya, nɛɛ jɔnlɔfɔ wi yinri Arashɛli. ");
INSERT INTO dyi_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya wi yɛngɛlɛ ke sila pye lugulugu, ɛɛn fɔ, Arashɛli wo la pye ma yɔn witige na fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Arashɛli wo wìla pye ma Zhakɔbu wi ndanla, a wì si Laban wi pye fɔ: «Mi yaa tunŋgo pye ma kan yɛlɛ kɔlɔshyɛn, mɔɔ sumborombyɔ shyɛnwoo Arashɛli wi kan na yeri na jɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","A Laban wì si yɛnlɛ ki na, ma sho fɔ: «Mboo kan mboro yeri, ko mbɔnrɔ mboo kan naŋa wa yɛgɛ yeri ko na. Koro laga na yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kì kaa pye ma, a Zhakɔbu wì si tunŋgo pye Laban wi kan ma saa gbɔn yɛlɛ kɔlɔshyɛn Arashɛli wi kala na. Ki yɛlɛ kɔlɔshyɛn làa pye Zhakɔbu wi yɛgɛ na paa piliye jɛnri yɛn, katugu Arashɛli wìla pye maa ndanla fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ko puŋgo na, a Zhakɔbu wì si Laban wi pye fɔ: «Na jɔ wi kan na yeri mboo jɛn jɛlɛ, katugu wagati ŋa mìla naga mbe tunŋgo pye ma kan, wùu yɛɛ yɔn fili.» ");
INSERT INTO dyi_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","A Laban wì sigi laga ki leele pe yeri, ma jayire sɔgɔlɔ li sɔgɔ pe kan. ");
INSERT INTO dyi_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ki yembinɛ li ni, a Laban wì suu sumborombyɔ Leya wi lɛ ma saa wi kan Zhakɔbu wi yeri. A wì si ye wi kɔrɔgɔ maa jɛn jɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","A Laban wì suu kulojɔ Zilipa wi kan wi sumborombyɔ Leya wi yeri, wi pye wi kulojɔ. ");
INSERT INTO dyi_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ki goto pinliwɛ pi ni, a Zhakɔbu wì sigi yan fɔ Leya lawi. A wì si Laban wi pye fɔ: «Yiŋgi yi ŋga mà pye na na yɛɛn? Mì yo mì tunŋgo pye ma kan Arashɛli wo kala na? Yiŋgi na, a mà silan fanla?» ");
INSERT INTO dyi_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","A Laban wì suu pye fɔ: «We kalɛgɛ ma laga mbe keli mbe jɔnlɔfɔ wi kan naŋa yeri njɔfɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Jayire yapelege ki pye njɔfɔ wi ni, pa we yaa jɔnlɔfɔ wi kan ma yeri fun, ma tunŋgo pye na kan naa yɛlɛ kɔlɔshyɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","A Zhakɔbu wì si yɛnlɛ ma jayire yapelege ki pye Leya wi ni. Ko puŋgo na, a Laban wì suu sumborombyɔ Arashɛli wi kan Zhakɔbu wi yeri jɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","A Laban wì suu kulojɔ Biliha wi kan Arashɛli wi yeri, wi pye wi kulojɔ. ");
INSERT INTO dyi_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","A Zhakɔbu wì si ye Arashɛli wi kɔrɔgɔ fun, maa jɛn jɛlɛ. Arashɛli wìla Zhakɔbu wi ndanla ma wɛ Leya wi na. A wì si tunŋgo pye naa Laban wi kan yɛlɛ kɔlɔshyɛn. ");
INSERT INTO dyi_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Naa Yawe Yɛnŋɛlɛ làa kaa ki yan Leya wi sila Zhakɔbu wi ndanla, a lì suu pye sevɔ, ma si yala Arashɛli wo la pye jambasee. ");
INSERT INTO dyi_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","A Leya wì si kugbɔ lɛ mɛɛ pinambyɔ se, maa mɛgɛ taga naa yinri Urubɛn; katugu wìla yo fɔ: «Ŋga kìla fɛrɛ wa na na, Yawe Yɛnŋɛlɛ lìgi yan. Koni mi yaa na pɔlɔ wi ndanla.» ");
INSERT INTO dyi_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A Leya wì si kugbɔ ka lɛ naa, ma pinambyɔ se, ma sho fɔ: «Yawe Yɛnŋɛlɛ lìgi jɛn mi silan pɔlɔ wi ndanla, mɛɛ na kan pinambyɔ ŋa wi ni naa.» A wì suu mɛgɛ taga naa yinri Simeyɔn. ");
INSERT INTO dyi_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","A wì si kugbɔ ka lɛ naa, ma pinambyɔ se, mɛɛ yo fɔ: «Koni, na pɔlɔ wi mbe mara na na, katugu mì pinambiile taanri se wi kan.» Kì kaa pye ma, a pè suu mɛgɛ taga naa yinri Levi. ");
INSERT INTO dyi_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A wì si kugbɔ ka lɛ naa, ma pinambyɔ se, mɛɛ yo fɔ: «Yiŋgɔ wo ni, mi yaa Yawe Yɛnŋɛlɛ li sɔn.» Kì kaa pye ma, a wì suu mɛgɛ taga naa yinri Zhuda. Kona, a wi sege kì si yere. ");
INSERT INTO dyi_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Naa Arashɛli wìla kaa ki yan wi woro na piile siin Zhakɔbu wi kan, a wi nɛɛ yenjaga piin wi njɔ Leya wi ni. A wì si Zhakɔbu wi pye fɔ: «Pinambiile pele se na na fun, nakoma mi yaa ku.» ");
INSERT INTO dyi_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","A Zhakɔbu wi nawa pì si ŋgban Arashɛli wi ni fɔ jɛŋgɛ. A wì sho fɔ: «Maa ki jate muwi mi yɛn Yɛnŋɛlɛ le le? Lo lì ti ma woro na siin.» ");
INSERT INTO dyi_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","A Arashɛli wì sho fɔ: «Na kulojɔ Biliha wi ŋa, ye wi kɔrɔgɔ maa jɛn jɛlɛ, wi ta wi piile pele se na kan; kona pa mi yaa piile pele ta fun wi fanŋga na.» ");
INSERT INTO dyi_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","A wì suu kulojɔ Biliha wi kan Zhakɔbu wi yeri, a wì ye wi kɔrɔgɔ maa jɛn jɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","A Biliha wì si kugbɔ lɛ, ma pinambyɔ se Zhakɔbu wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","A Arashɛli wì sho fɔ: «Yɛnŋɛlɛ lì kiti wi kɔn ma tanga ki kan na yeri, ŋga mìla pye na sɔnri na jaa, lìgi pye mala kan, ma pinambyɔ kan na yeri fun.» Kì kaa pye ma, a wì suu mɛgɛ ki taga naa yinri Dan. ");
INSERT INTO dyi_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","A Arashɛli wi kulojɔ Biliha wì si kugbɔ ka lɛ naa, ma pinambyɔ shyɛnwoo se Zhakɔbu wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","A Arashɛli wì sho fɔ: «Mì ŋgbeli ŋgbanga na njɔ wi ni Yɛnŋɛlɛ yɛnrɛwɛ ni, ma ya wi ni.» A wì si pyɔ wi mɛgɛ taga naa yinri Nɛfitali. ");
INSERT INTO dyi_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Naa Leya wìla kaa ki yan wi sege ki yere, a wì suu kulojɔ Zilipa wi lɛ maa kan Zhakɔbu wi yeri jɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","A Leya wi kulojɔ Zilipa wì si pinambyɔ se Zhakɔbu wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","A Leya wì sho fɔ: «Yɛfige kì pan.» A wì si pyɔ wi mɛgɛ taga naa yinri Gadi. ");
INSERT INTO dyi_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","A Leya wi kulojɔ Zilipa wì si pinambyɔ shyɛnwoo se Zhakɔbu wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","A Leya wì sho fɔ: «Mì fɛri. Koni jɛɛlɛ pe yaa lanla yinri fɛrifɔ.» A wì suu mɛgɛ taga naa yinri Asɛri. ");
INSERT INTO dyi_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Pilige ka, yarilire bile kɔnsanga wi ni, a Urubɛn wì si yiri ma kari wa kɛrɛ, mɛɛ saa wɛrɛ nda pe yinri madiragɔri ti pire ta yan. A wì siri lɛ ma pan mari kan wi nɔ Leya wi yeri. Kona, a Arashɛli wì si Leya wi pye fɔ: «Mila ma yɛnri, ma pinambyɔ wi madiragɔri pire ta kan na yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","A Leya wì sho fɔ: «Màla pɔlɔ wi shɔ na yeri ko sɔɔn bɔ bere, maa jaa mbanla pinambyɔ wi madiragɔri pire ti shɔ na yeri naa!» A Arashɛli wì sho fɔ: «Na kì kaa pye yɛɛn, Zhakɔbu wi yaa sa sinlɛ wa ma ni nala yembinɛ na li ni, ma pinambyɔ wi madiragɔri pire ti yɔnlɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ki yɔnlɔkɔgɔ ki ni, naa Zhakɔbu wìla kaa yiri wa kɛrɛ na paan, a Leya wì si yiri ma saa wi fili, mɛɛ wi pye fɔ: «Pa ma yaa sinlɛ wa na ni nala, katugu mbe ta mbɔɔn ta, mìgi kologo ki sara na pinambyɔ wi madiragɔri pire to ni.» A Zhakɔbu wì si saa sinlɛ wa Leya wi ni ki yembinɛ li ni. ");
INSERT INTO dyi_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","A Yɛnŋɛlɛ lì si Leya wi yɛnrɛwɛ pi logo. A Leya wì si kugbɔ lɛ, mɛɛ pinambyɔ kaŋgurugo woo se Zhakɔbu wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","A Leya wì sho fɔ: «Yɛnŋɛlɛ lìlan sara wi kan na yeri, katugu mìlan kulojɔ wi kan na pɔlɔ wi yeri jɛlɛ.» A wì si pyɔ wi mɛgɛ taga naa yinri Isakari. ");
INSERT INTO dyi_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","A Leya wì si kugbɔ ka lɛ naa, ma pinambyɔ kɔgɔlɔni woo se Zhakɔbu wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","A Leya wì sho fɔ: «Yɛnŋɛlɛ lì yarikanga tiyɔngɔ kan na yeri. Koni na pɔlɔ wi yaa cɛn na ni, katugu mì pinambiile kɔgɔlɔni se wi kan.» A wì si pyɔ wi mɛgɛ taga naa yinri Zabulɔn. ");
INSERT INTO dyi_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ko puŋgo na, a wì si sumborombyɔ se, mɛɛ wi mɛgɛ taga naa yinri Dina. ");
INSERT INTO dyi_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kona, a, Yɛnŋɛlɛ lì si jatere pye Arashɛli wi na, maa yɛnrɛwɛ pi logo mɛɛ wi sege ki yɛngɛ. ");
INSERT INTO dyi_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","A wì si kugbɔ lɛ, mɛɛ pinambyɔ se, ma sho fɔ: «Yɛnŋɛlɛ lìlan fɛrɛ kala li laga na go na.» ");
INSERT INTO dyi_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A wì suu mɛgɛ taga naa yinri Zhozɛfu, wìla pye naga sɔnri na yuun fɔ: «Yawe Yɛnŋɛlɛ li pinambyɔ wa kan na yeri naa!» ");
INSERT INTO dyi_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Naa Arashɛli wìla kaa Zhozɛfu wi se, a Zhakɔbu wì si Laban wi pye fɔ: «Na yaga mbe sɔngɔrɔ wa we yeri, wa na tara. ");
INSERT INTO dyi_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ki yaga mala jɛɛlɛ poro naa na piile pe kan na yeri, mbaa kee na tara; katugu poro kala lì ti mì tunŋgo pye ma kan. Mì tunŋgo pye ma kan yɛgɛ ŋga na màga jɛn ma yɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","A Laban wì suu pye fɔ: «Na kaa pye na kala lɔ̀ɔn ndanla, koro laga na yeri. Katugu na yarisunndo tìgi naga na na ma yo Yawe Yɛnŋɛlɛ lì duwaw na na mboro kala na. ");
INSERT INTO dyi_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ma sara wi yo na kan, mi yaa wi kan ma yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","A Zhakɔbu wì suu pye fɔ: «Mì tunŋgo pye ma kan yɛgɛ ŋga na, mboro jate màga jɛn, konaa ma yaayoro tì gbɔn yɛgɛ ŋga na mari ta na kɛɛ na, màga jɛn; ");
INSERT INTO dyi_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","katugu yaayoro jɛnri nda tìla pye ma yeri sanni mbe sa pan, tì se ma lɛgɛ fɔ jɛŋgɛ. Maga lɛ mì ye laga ma go, Yawe Yɛnŋɛlɛ lì duwaw ma na. Koni, mi wo yaa ka tunŋgo pye na go woolo pe kan wagati wiwiin?» ");
INSERT INTO dyi_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","A Laban wì suu yewe ma yo fɔ: «Yiŋgi maa jaa mbe kan ma yeri?» A Zhakɔbu wì suu yɔn sogo ma yo fɔ: «Ma se ka yaraga ka kan na yeri, na maga yɛnlɛ mbe ŋga mi yaa yo ma kan ki pye we. Mi yaa lɔɔn yaayoro ŋgbelege ki kɔnri bere, laga go singi. ");
INSERT INTO dyi_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nala mi yaa sa torotoro wa ma yaayoro ŋgbelege ki sɔgɔwɔ. Simbaala pe ni, simbapire nda fuun ti yɛn yɔɔnrɔ tumɔɔrɔ naa tugbɔɔrɔ ni, naa nda fuun ti yɛn ma wɔwɔ, konaa sikaala pe ni, sikapire nda fuun ti yɛn yɔɔnrɔ tumɔɔrɔ naa tugbɔɔrɔ ni, mari tɛgɛ ti yɛ; to ti yaa pye na sara we. ");
INSERT INTO dyi_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Puŋgo na, na maga ka pan mbanla sara wi wele, ma yaa ki jɛn na kaa pye mi yɛn ma sin. Sikaala mbele fuun pe se ka pye yɔɔnrɔ tumɔɔrɔ naa tugbɔɔrɔ ni, konaa simbaala mbele pe se ka pye wɔɔlɔ wɔɔlɔ, ko yaa ki naga fɔ mì poro yu.» ");
INSERT INTO dyi_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","A Laban wì sho fɔ: «Ŋga mà yo mìgi logo.» ");
INSERT INTO dyi_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ki pilige nuŋgba ki ni, a Laban wì si saa sikapɛnɛ mbele pe yɛn yɔɔnrɔ tumɔɔrɔ naa tugbɔɔrɔ ni pe tɛgɛ pe yɛ, naa sikanɛɛlɛ mbele fuun pe yɛn yɔɔnrɔ tumɔɔrɔ naa tugbɔɔrɔ ni, naa mbele fuun lafire la pye pe na, konaa simbawɔɔlɔ pe ni fuun pe ni. A wì si poro kan wi pinambiile pe yeri, ");
INSERT INTO dyi_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","mɛɛ pe torogo, a pè pilige taanri tangala tanga ma ko fogo ko le poro naa Zhakɔbu pe sɔgɔwɔ. A Zhakɔbu wi nɛɛ Laban wi yaayoro sannda ti kɔnri. ");
INSERT INTO dyi_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","A Zhakɔbu wì si saa pepiliye tire, naa amandi tire, konaa pilatani tire njere ta kɔɔnlɔ, mɛɛ ti kɔɔrɔ ta lagala fɛɛrɛ fɛɛrɛ, mari kɛnlɛgi, ma yiri tire ti lafire ti na. ");
INSERT INTO dyi_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","A wì si tire njere nda wìla ti kɔɔrɔ ti lagala fɛɛrɛ fɛɛrɛ, mari kɛnlɛgi, ti le wa yaayoro ti maa kaa na woo yaara nda ni ti ni, mari tɛgɛ wa yaayoro nda ti ma pan wɔsaga ti yɛgɛ sɔgɔwɔ; jaŋgo tiga pan la woo, tila nuru ti yɛɛ na. ");
INSERT INTO dyi_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Yaayoro tìla pye na nuru le ki tire njere ti yɛgɛ na. Ki kala na sikanɛɛlɛ pàa pye na pire nda siin, tìla pye yɔɔnrɔ tugbɔɔrɔ naa tunmɔɔrɔ ni, ma kɛnlɛgi kɛnlɛgi. ");
INSERT INTO dyi_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaayoro nda tìla pye yɔɔnrɔ ni ma wɔwɔ wa Laban yaayoro ti sɔgɔwɔ, Zhakɔbu wìla simbapire ti cɔnri mari tɛgɛ a tila ti wele. Pa Zhakɔbu wìla ki pye yɛɛn, ma yaayoro ŋgbeleye ta wi yɛɛ kan, nda wi sila pinlɛ Laban woro ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Wagati ŋa fuun yaayoro nda ti yɛn fanŋga ni ti kaa nuru, Zhakɔbu wi ma saa tire njere ti tɛgɛtɛgɛ wa yaayoro wɔyaara ti ni wa yaayoro ti yɛgɛ sɔgɔwɔ, ti ta tila nuru le tire njere ti yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Yaayoro nda tìla pye ma cɔgɔ cɔgɔ, na to kaa nuru, wila tire njere ti tɛgɛ wa ti yɛgɛ sɔgɔwɔ. Kì kaa pye ma, nda tìla pye ma cɔgɔ cɔgɔ, a to pye Laban woro, a tugbɔɔrɔ to pye Zhakɔbu wo woro. ");
INSERT INTO dyi_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","A Zhakɔbu wi nɛɛ wi yɛɛ yɔngɔ na kee yɛgɛ suyi. Wìla simbaala naa sikaala lɛgɛrɛ ta, naa kulojaala naa kulonambala ni, naa yɔngɔmɛye naa sofilele ni. ");
INSERT INTO dyi_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Kona, a Zhakɔbu wì si Laban wi pinambiile pe sɛnyoro ti logo. Pàa pye na yuun fɔ: «Yaara nda fuun tìla pye we to wi yeri, Zhakɔbu wìri shɔ. Ko yaara to wi tɛgɛ maa yɛɛ yɔn.» ");
INSERT INTO dyi_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","A Zhakɔbu wì sigi wele maga yan fɔ Laban wi yɛgɛ cɛnwɛ pìla pye wi ni yɛgɛ ŋga na faa, pi woro wi ni ma naa. ");
INSERT INTO dyi_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kona, a Yawe Yɛnŋɛlɛ lì si Zhakɔbu wi pye fɔ: «Sɔngɔrɔ wa ma teele pe tara, wa ma woolo pe yeri. Mi yaa lɔɔn go singi.» ");
INSERT INTO dyi_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","A Zhakɔbu wì si piile tun, a pè saa Arashɛli naa Leya pe yeri, a pè pan wa kɛrɛ, wa laga ŋga wi yaayoro tìla pye. ");
INSERT INTO dyi_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","A wì si pe pye fɔ: «Mìgi wele maga yan fɔ ye to wi yɛgɛ cɛnwɛ pi woro na ni paa yɛgɛ ŋga na pìla pye na ni faa we. Ɛɛn fɔ, na to wi Yɛnŋɛlɛ li yɛn nala go singi. ");
INSERT INTO dyi_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yoro jate yège jɛn ma yo mì tunŋgo pye ye to wi kan na fanŋga ki ni fuun ni. ");
INSERT INTO dyi_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ma si yala ye to wìlan fanla mala li, mala sara wi kanŋga kanŋgasaga kɛ. Ɛɛn fɔ, Yɛnŋɛlɛ lii yɛnlɛ ki na wi kapege pye na na. ");
INSERT INTO dyi_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Na ye to wiga yo fɔ yaayoro nda ti yɛn yɔɔnrɔ ni to ti yaa pye ma sara we, yaayoro ti ni fuun ti maa pire nda siin, ti ma pye yɔɔnrɔ ni. Na wiga sho fɔ nda ti yɛn ma kɛnlɛgi kɛnlɛgi to ti yaa pye ma sara we, yaayoro ti ni fuun ti maa pire nda siin, ti ma pye ma kɛnlɛgi kɛnlɛgi. ");
INSERT INTO dyi_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Yɛnŋɛlɛ lo lì ye to wi yaayoro ti shɔ mari kan na yeri. ");
INSERT INTO dyi_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Sanga ŋa ni yaayoro tìla pye na nuru, a mì si wɔɔnrɔ wɔnlɔ maga yan fɔ nambala mbele pàa pye na nuru simbanɛɛlɛ nakoma sikanɛɛlɛ pe na, pàa pye yɔɔnrɔ ni, ma kɛnlɛgi kɛnlɛgi, nakoma ma wɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","A Yɛnŋɛlɛ li mɛrɛgɛ wì silan yeri wa ki wɔɔnrɔ ti na ma yo fɔ: ‹Zhakɔbu.› A mì si shɔ ma yo fɔ: ‹Naw!› ");
INSERT INTO dyi_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A mɛrɛgɛ wì silan pye fɔ: ‹Ma yɛgɛ ki yirige ma wele. Yaayoro ti nambala mbele paa nuru jɛɛlɛ pe na, pe ni fuun pe yɛn yɔɔnrɔ ni, ma kɛnlɛgi kɛnlɛgi nakoma ma wɔwɔ. Ko pye ma, katugu ŋga Laban wì pye ma na, mì ki ni fuun ki yan.› ");
INSERT INTO dyi_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","A Yɛnŋɛlɛ lì sho fɔ: ‹Mi yɛn Yɛnŋɛlɛ na làa li yɛɛ naga ma na wa Betɛli, wa laga ŋga màa sinndɛlɛgɛ ki yerege ma sinmɛ wo ki go na mbege naga fɔ màga le mi ŋa Yɛnŋɛlɛ na kɛɛ, ma yɔn fɔlɔ kɔn na yeri. Koni, yiri, ma wɔ laga ki tara nda ti ni, ma sɔngɔrɔ wa tara nda pɔ̀ɔn se ti ni.› » ");
INSERT INTO dyi_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","A Arashɛli naa Leya pè suu yɔn sogo ma yo fɔ: «Tasaga naa kɔrɔgɔ si koro we yeri naa wa we to wi go. ");
INSERT INTO dyi_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","We to wì we jate paa nambanmbala yɛn, katugu wì we pɛrɛ, ma penjara nda ti jɛn na kan we yeri ti li. ");
INSERT INTO dyi_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Yarijɛndɛ nda fuun Yɛnŋɛlɛ lì shɔ we to wi yeri, tì pye woro naa we piile we woro. Koni, ŋga fuun Yɛnŋɛlɛ lì yo ma kan ki pye.» ");
INSERT INTO dyi_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Kona, a Zhakɔbu wì si yiri mbaa kee, mɛɛ wi piile naa wi jɛɛlɛ pe lurugo yɔngɔmɛye pe na. ");
INSERT INTO dyi_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Wìla kari wi yaayoro naa wi yarijɛndɛ nda fuun wìla ta wa Padamu Aramu tara ti ni, mbe ta mbe sɔngɔrɔ wa wi to Izaki wi yeri wa Kana tara. ");
INSERT INTO dyi_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ko sanga wo ni, kìla yala Laban wìla kari saa yaayoro ti sire ti kɔɔnlɔ. A Arashɛli wì suu to wi yarisunndo ti yu. ");
INSERT INTO dyi_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Zhakɔbu wo na, wìla Aramu tara fɛnnɛ naŋa Laban wi fanla, ma lara ma fe, wii sara wi na. ");
INSERT INTO dyi_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","A wì si fe ma kari wi kɛɛ yaara ti ni fuun ti ni, mɛɛ fyɛɛlɛ ma Efirati gbaan wi kɔn ma yiri, mɛɛ yɛgɛ kan wa Galaadi tara yanwira ti yeri. ");
INSERT INTO dyi_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ki pilige taanri wogo ki na, a pè sigi yo Laban wi kan fɔ Zhakɔbu wì fe. ");
INSERT INTO dyi_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","A Laban wì suu go woolo pele lɛ ma taga Zhakɔbu wi na, maa purɔ pe piliye kɔlɔshyɛn, mɛɛ saa wi yigi konɔ wa Galaadi tara yanwira ti na. ");
INSERT INTO dyi_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ɛɛn fɔ, ki yembinɛ li ni, a Yɛnŋɛlɛ lì si pan Aramu tara fɛnnɛ naŋa Laban wi kɔrɔgɔ wɔɔnrɔ na, mɛɛ wi pye fɔ: «Ma yɛɛ yigi, maga ka sɛnjɛndɛ nakoma sɛnpere yo Zhakɔbu wi na.» ");
INSERT INTO dyi_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Naa Laban wìla ka saa gbɔn wa Zhakɔbu wi na sanga ŋa ni, kìla yala Zhakɔbu wìla wi paraga go ki kan wa Galaadi tara yanwira ti na. A Laban wo naa wi woolo pe ni, pè si pe woro ti kan wa fun. ");
INSERT INTO dyi_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kona, a Laban wì si Zhakɔbu wi yewe ŋgbanga ma yo fɔ: «Yiŋgi mà pye yɛɛn? Màla fanla mala sumborombiile pe lɛ ma pan pe ni, paa malaga kasopiile yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Yiŋgi na, a mà si lara na na ma fe, màla fanla mɛɛ sara na na. Ndɛɛ ki pye màga yo na kan, mi jɛn na sɔɔn torogo, mbaa nayinmɛ yuuro koo, mbaa piŋge naa juru gbɔɔn. ");
INSERT INTO dyi_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Mɛɛ ti mbe kɛyɛn wa na pishyɛnwoolo naa na sumborombiile pe yɔlɔgɔ, mbe sara pe na. Yiŋgɔ wogo ko na, lembigewe kala mà pye. ");
INSERT INTO dyi_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Fanŋga yɛn na yeri mbe kapege pye ye na. Ɛɛn fɔ, ye to wi Yɛnŋɛlɛ le, lìlan pye yunmbaan ma yo fɔ: ‹Ma yɛɛ yigi, maga ka sɛnjɛndɛ nakoma sɛnpere yo Zhakɔbu wi na.› ");
INSERT INTO dyi_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Koni, na ma kaa na kee pew, katugu ma to ca ki la yɛn ma na, yiŋgi na, a mà silan yarisunndo to yu?» ");
INSERT INTO dyi_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","A Zhakɔbu wì si Laban wi yɔn sogo ma yo fɔ: «Mìla fyɛ maga jate ma yo kana ma yaa ma sumborombiile pe shɔ na yeri. ");
INSERT INTO dyi_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ɛɛn fɔ, na maga ma yarisunndo ti yan na woolo ŋa yeri, ko fɔ wo si daga mbe koro yinwege na. Na yaara ti san na we woolo pe yɛgɛ na, ma ŋga ki yɛn ma wogo ki wɔ.» Zhakɔbu wi sila ki jɛn mbe yo Arashɛli wo wìla wi to yarisunndo ti yu. ");
INSERT INTO dyi_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","A Laban wì si ye wa Zhakɔbu wi paraga go ki ni maga san, ma Leya wogo ki san, ma kulojaala shyɛn pe woro ti san, wii yaraga yan. A wì si yiri wa Leya paraga go ki ni mɛɛ ye wa Arashɛli wogo ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ma si yala, Arashɛli wo wìla yarisunndo ti yu mari le wa yɔngɔmɛ jɔngɔ ki nɔgɔ, mɛɛ cɛn ti na. A Laban wì si paraga go ki ni fuun ki san, wii yaraga yan. ");
INSERT INTO dyi_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","A Arashɛli wì suu to wi pye fɔ: «Na tafɔ, maga ka nawa ŋgban na ni, mi se ya yiri ma yɛgɛ na win, katugu mi yɛn na jogo.» A Laban wì si yarisunndo ti lagaja, wi siri yan. ");
INSERT INTO dyi_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","A Zhakɔbu wì si nawa ŋgban fɔ jɛŋgɛ, nɛɛ wiin Laban wi ni na yuun fɔ: «Kapegbɔgɔ kikiin mì pye, fɔ a mà yiri ma taga na na nala tuuro tɔnri yɛɛn? ");
INSERT INTO dyi_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Na mà we yaara ti ni fuun ti san, yiŋgi mà yan wa ma go wogo? Ki naga laga na na, na woolo poro naa ma woolo pe yɛgɛ na, pe pye we shyɛn we kala li yɛgɛ wɔfɛnnɛ. ");
INSERT INTO dyi_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Wele, na yɛlɛ nafa wolo loli na laga ma yeri. Ma simbanɛɛlɛ naa ma sikanɛɛlɛ wa kugbɔ si jɔgɔ. Mi sɔɔn yaayoro ŋgbelege ki simbapɛnɛ pe ka. ");
INSERT INTO dyi_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mii pan yaayogo ka ni ma kan ŋga cɛngɛ gbo. Na wa ka ku, muwi mi maga yɔngɔ ki le wa. Yaayoro nda pàa pye na yuun na yeri, yɔnlɔ na nakoma yembinɛ, màa pye nari yɔngɔ jaa na yeri. ");
INSERT INTO dyi_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Yɔnlɔ na, mìla pye na jɔlɔ kafugo ki kɛɛ, yembinɛ, na jɔlɔ were ti kɛɛ. Wɔnlɔwɔ pìla pye na gbaanri na na. ");
INSERT INTO dyi_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yɛlɛ nafa lo mì pye wa ma yeri. Mì tunŋgo pye ma kan yɛlɛ kɛ ma yiri tijɛrɛ, mɔɔ sumborombiile shyɛn pe pɔri, ma tunŋgo pye ma kan yɛlɛ kɔgɔlɔni, nɔɔ simbaala naa ma sikaala pe kɔnri. Ɛɛn fɔ, màla sara wi kanŋga ma ta kanŋgasaga kɛ. ");
INSERT INTO dyi_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ndɛɛ kì pye na tɛlɛ Abirahamu Yɛnŋɛlɛ le, lo na Izaki wi maa fyɛ li yɛgɛ, li sila na saga, anmɛ mala yaga mi sɔngɔrɔ kɛwara. Yɛnŋɛlɛ lìlan jɔlɔgɔ konaa tunŋgbanga ŋga mì pye ki yan; yunmbaan yembinɛ li ni, làa tanga ki kan na yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","A Laban wì si Zhakɔbu wi yɔn sogo ma yo fɔ: «Ki sumborombiile mbele, mi na woolo wɛlɛ, pe piile pe yɛn na woolo, ki yaayoro ŋgbeleye yan, mi na woyo yi. Yaara nda fuun maa yaan, mi na woro ri. Ɛɛn fɔ, mbege lɛ nala wo ni, mi se ya kala la pye na sumborombiile poro naa pe piile mbele pè se pe kan. ");
INSERT INTO dyi_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Koni, pan we yɔn finliwɛ le, mi naa mboro, we leele shyɛn, po mbe pye paa sɛrɛfɔ yɛn we sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kona, a Zhakɔbu wì si sinndɛlɛgɛ lɛ ma titɛgɛ kɔn maga yerege, (a kì pye pe yɔn finliwɛ pi tɛgɛrɛ). ");
INSERT INTO dyi_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","A wì suu woolo pe pye ma yo pe sinndɛɛrɛ wulo. A pè si ta wulo mari gbogolo ti yɛɛ na. A pè si cɛn, ma ka wa ki sinndɛɛrɛ nda pàa gbogolo ti go na. ");
INSERT INTO dyi_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","A Laban wì sigi laga ki mɛgɛ taga naga yinri Yegari Sahaduta. A Zhakɔbu wo ki mɛgɛ taga naga yinri Galɛdi. ");
INSERT INTO dyi_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","A Laban wì sho fɔ: «Ki sinndɛɛrɛ nda tì gbogolo yɛɛn, ti yɛn paa sɛrɛfɔ yɛn mi naa mboro we sɔgɔwɔ nala.» Ko ki ti pège mɛgɛ taga naga yinri Galɛdi. ");
INSERT INTO dyi_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Pàa ki mɛgɛ taga naga yinri naa Mizipa, katugu Laban wìla yo fɔ: «Yawe Yɛnŋɛlɛ laa wele mi naa mboro we na, na waga ka laga we yɛɛ na we. ");
INSERT INTO dyi_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Na ma kaa na sumborombiile pe jɔlɔ, na maga si jɛɛlɛ pele yɛgɛ pɔri, mɔɔ yɛɛ yingiwɛ jɛn, maga jɛn lere ma wi yaa pye we sɛrɛfɔ, ɛɛn fɔ, Yɛnŋɛlɛ lo jate li yaa pye sɛrɛfɔ mi naa mboro we sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ko puŋgo na, a Laban wì si Zhakɔbu wi pye fɔ: «Ki sinndɛɛrɛ nda mì gbogolo mi naa mboro we sɔgɔwɔ, ti wele! Ki sinndɛlɛgɛ ŋga kì yerege ki wele! ");
INSERT INTO dyi_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ki sinndɛɛrɛ nda gbogolosaga konaa ki sinndɛlɛgɛ ŋga yeresaga, ti yɛn paa we sɛrɛfɛnnɛ yɛn. Mii daga mberi toro la kee wa ma kɛɛ yeri kapege ni, mboro fun mɛɛ daga mberi toro la paan laga na kɛɛ yeri kapege ni. ");
INSERT INTO dyi_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abirahamu naa Nahɔri pe Yɛnŋɛlɛ le, lo na li yɛn pe to wi Yɛnŋɛlɛ le, li mi naa mboro we kala li yɛgɛ wɔ.» A Zhakɔbu wì si wugu Yɛnŋɛlɛ na wi to Izaki wi maa fyɛ li yɛgɛ li na. ");
INSERT INTO dyi_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","A Zhakɔbu wì si yaayogo saraga wɔ Yɛnŋɛlɛ li yeri wa yanwiga ki na, mɛɛ wi woolo pe yeri, a pè pan ma li. Naa pàa kaa li ma kɔ, a pè si wɔnlɔ wa yanwiga ki na. ");
INSERT INTO dyi_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ki goto yirifaga ki na, a Laban wì si yiri ma kɛyɛn wa wi pishyɛnwoolo naa wi sumborombiile pe yɔɔrɔ, ma duwaw pye pe kan, mɛɛ sɔngɔrɔ na kee wi ca. ");
INSERT INTO dyi_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kona, a Zhakɔbu wì si konɔ li lɛ nɛɛ kee, a Yɛnŋɛlɛ li mɛrɛgɛye pèle si pan maa fili. ");
INSERT INTO dyi_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Naa Zhakɔbu wìla kaa pe yan, a wì sho fɔ: «Yɛnŋɛlɛ li maliŋgbɔɔnlɔ pe cɛnsaga koyi ŋga.» A wì sigi laga ki mɛgɛ taga naga yinri Mahanayimu. ");
INSERT INTO dyi_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","A Zhakɔbu wì si piile tun wa wi ndɔ Ezawu wi yeri, wa Seyiri tara, wa Edɔmu wasege ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A wì sigi sɛnrɛ nda ti yo pe kan fɔ: «Ye saga sɛnrɛ nda ti yo na tafɔ Ezawu wi kan fɔ: ‹Ma kulonaŋa Zhakɔbu wì yo wì cɛn ma mɔ wa Laban wi yeri ma saa gbɔn yiŋgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nɛrɛ, naa sofilele, naa simbaala, naa sikaala, naa kulonambala, konaa kulojaala yɛn wi yeri. Ko wì piile tun pe saga yo mboro ŋa wi tafɔ ma kan, jaŋgo wi kala lɔɔn ndanla.› » ");
INSERT INTO dyi_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","A pitunmbolo pè si kari ma saa ki yo, mɛɛ sɔngɔrɔ ma pan ma Zhakɔbu wi pye fɔ: «We saa ma ndɔ Ezawu wi yan. Wi yɛn na paan mbɔɔn fili lere cɛnmɛ tijɛrɛ (400) ni.» ");
INSERT INTO dyi_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","A Zhakɔbu wì si fyɛ fɔ jɛŋgɛ, a wi jatere wì piri wi na. A wì si leele mbele pàa pye wi ni pe kɔn, a pè yiri tɛgɛsaga shyɛn, ma simbaala, naa sikaala, naa nɛrɛ, naa yɔngɔmɛye pe kɔn ŋgbeleye shyɛnzhyɛn. ");
INSERT INTO dyi_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Wìla pye naa yɛɛ piin fɔ: «Na Ezawu wiga pan mbe to tɛgɛsaga nuŋgba na mbe ya ki ni, pa tɛgɛsaga sanŋga ko mbe ya fe mbe shɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","A Zhakɔbu wì si Yɛnŋɛlɛ li yɛnri ma yo fɔ: «E, na tɛlɛ Abirahamu naa na to Izaki Yɛnŋɛlɛ, Yawe Yɛnŋɛlɛ, mboro màla pye fɔ: ‹Sɔngɔrɔ wa ma tara, wa ma woolo pe yeri, mi yaa kajɛŋgɛ pye ma kan!› ");
INSERT INTO dyi_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kajɛŋgɛ kagala ŋgele fuun mà pye mala kan, konaa a mà koro sinŋɛ na ni, mi ŋa ma kulonaŋa, mì kologo mbege kagala ke ta. Katugu mìla Zhuridɛn gbaan wi kɔn sanga ŋa ni, na gbɔtangala lo nuŋgba làa pye na yeri; koni na sɔngɔrɔsaga we yɛn tɛgɛsaga shyɛn. ");
INSERT INTO dyi_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mi yɛn nɔɔ yɛnri, mala shɔ na ndɔ Ezawu wi kɛɛ; katugu mi yɛn na fyɛ wiga ka pan mbanla gbo mbe pinlɛ jɛɛlɛ poro naa piile pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Mboro jate màga yo na kan ma yo ma yaa kajɛŋgɛ pye na kan, mbanla setirige piile pe pye pe lɛgɛ, paa kɔgɔje yɔn taambugɔ ŋga ki se ya jiri ki yɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ki yembinɛ li ni, a Zhakɔbu wì si wɔnlɔ le ki laga ki ni. Yaara nda fuun wìla ta, a wì si ta wɔ wa ti ni, mberi kan wi ndɔ Ezawu wi yeri yarikanra. ");
INSERT INTO dyi_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Yaara nda wìla kan ti nda: Sikanɛɛlɛ cɛnmɛ shyɛn (200), naa sikapɛnɛ nafa, naa simbanɛɛlɛ cɛnmɛ shyɛn (200), naa simbapɛnɛ nafa, ");
INSERT INTO dyi_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","naa yɔngɔmɛ nɛɛlɛ nafa ma yiri kɛ, ma pinlɛ pe pire ti ni tila wɔnri pe na, naa nanɛɛlɛ nafa shyɛn, naa napɛnɛ kɛ, naa sofile nɛɛlɛ nafa konaa sofile pɛnɛ kɛ. ");
INSERT INTO dyi_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","A wì siri le wi kulonambala pe kɛɛ ŋgbeleye ŋgbeleye, pe yɛ pe yɛ, mɛɛ pe pye fɔ: «Ye toro wa na yɛgɛ, ye fogo wa ŋgbeleye yi ni fuun nuŋgba nuŋgba yi sɔgɔwɔ pi ni.» ");
INSERT INTO dyi_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A wì si kulonaŋa ŋa wìla keli yɛgɛ wi pye fɔ: «Na na ndɔ Ezawu wiga fili ma ni mbɔɔn yewe mbe yo fɔ: ‹Ambɔ woo wi mboro? Maa kee se? Yaayoro ŋgbelege ŋga ma yɛgɛ, ambɔ wogo yi ko?› ");
INSERT INTO dyi_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Kona maa yɔn sogo ma yo fɔ: Mi yɛn ma kulonaŋa Zhakɔbu wo woo. Ki yaayoro nda ti yɛn yarikanga mbe kan ma yeri, mboro ŋa ma yɛn wi tafɔ. Wo jate wi yɛn na paan wa we puŋgo na.» ");
INSERT INTO dyi_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","A wì sigi sɛnrɛ nuŋgba ti yo shyɛn woo wi kan, mari yo taanri woo wi kan, konaa mbele fuun pàa taga yaayoro ŋgbeleye yi na pe kan. Anmɛ ye daga mbege yo na tafɔ Ezawu wi kan, na yaga fili wi ni we. ");
INSERT INTO dyi_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Yaa ki sɛnrɛ nda ti yuun yaa ti tari wa fɔ: «Ma kulonaŋa Zhakɔbu wo jate wi yɛn na paan wa we puŋgo na.» Katugu wìla pye naa yɛɛ piin fɔ: «Mi yaa wi naŋgbanwa pi sogo wi na ki yarikanra nda tì keli wa na yɛgɛ ti ni, ko puŋgo na, mbee wi yan gbɔgɔyi. Kona pa wi yaa na yigi jɛŋgɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","A pè si keli ki yarikanra ti ni wa wi yɛgɛ. A wo jate wì si koro wa paara yinrɛ cɛnsaga ki ni ki yembinɛ li ni. ");
INSERT INTO dyi_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","A wì si yiri ki yembinɛ nuŋgba li ni, maa jɛɛlɛ shyɛn, naa wi kulojaala shyɛn, konaa wi pinambiile kɛ ma yiri nuŋgba pe lɛ, mɛɛ ti a pè Yabɔki gbaan wi kɔn ma yiri, wa wi kɔnsaga. ");
INSERT INTO dyi_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Wìla pe lɛ, ma ti a pè gbaan njege ki kɔn ma yiri, ma pinlɛ wi kɛɛ yaara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","A Zhakɔbu wì si koro wi yɛ. Kona, a naŋa wà si pan ma ŋgbeli wi ni fɔ ma saa laga ki laga. ");
INSERT INTO dyi_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Naa ki naŋa wìla kaa ki yan wi se ya Zhakɔbu wi ni, ma yala wila ŋgbeli wi ni, a wì suu gbɔn wa wi jeyugo ki na, a kì si fugu. ");
INSERT INTO dyi_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","A naŋa wì suu pye fɔ: «Na yaga mbaa kee, katugu lalaaga kila paan.» A Zhakɔbu wì suu yɔn sogo ma yo fɔ: «Mi sɔɔn yaga maa kee, na mɛɛ duwaw pye na kan.» ");
INSERT INTO dyi_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","A naŋa wì si Zhakɔbu wi yewe ma yo fɔ: «Pe maa ma yinri mɛlɛ?» A wì sho fɔ: «Zhakɔbu.» ");
INSERT INTO dyi_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","A naŋa wì suu pye naa fɔ: «Pe saa ma yinri naa Zhakɔbu, ɛɛn fɔ, pe yaa lɔɔn yinri Izirayɛli, katugu mà ŋgbeli Yɛnŋɛlɛ li ni, ma ŋgbeli leele pe ni, a mà fanŋga ta.» ");
INSERT INTO dyi_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","A Zhakɔbu wì si naŋa wi yewe ma yo fɔ: «Mila ma yɛnri, ma mɛgɛ ki naga na na.» A naŋa wì suu yɔn sogo ma yo fɔ: «Yiŋgi na, a ma nɛɛ na yewe na mɛgɛ ko ni?» A wì si duwaw Zhakɔbu wi na le ki laga ki na. ");
INSERT INTO dyi_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","A Zhakɔbu wì sigi laga ki mɛgɛ taga naga yinri Peniyɛli, katugu wìla pye naa yɛɛ piin fɔ: «Mì Yɛnŋɛlɛ li yan gbɔgɔyi, mii si ku.» ");
INSERT INTO dyi_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yɔnlɔ kìla yiri ma yala Zhakɔbu wìla pye na Penuwɛli laga ki lɔgɔ ki kɔɔn wa laga ŋga pe maa ki kɔɔn tɔɔrɔ na. Wìla pye na sege wi jeyugo ki kala na. ");
INSERT INTO dyi_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Ko kala kì ti Izirayɛli tara woolo paa la jeyugo kapanŋga ki kaa, ali ma pan ma gbɔn nala; katugu pa Yɛnŋɛlɛ làa Zhakɔbu wi wɛlɛgɛ wa jeyugo kapanŋga ki na. ");
INSERT INTO dyi_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Kona, a Zhakɔbu wì suu yɛgɛ ki yirige ma wele, mɛɛ Ezawu wi yan wila paan wi lenambala cɛnmɛ tijɛrɛ (400) pe ni. A wì si piile pe yɛw ma pele kan Leya yeri, ma pele kan Arashɛli yeri, mɛɛ pele kan kulojaala shyɛn pe yeri. ");
INSERT INTO dyi_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","A wì si kulojaala shyɛn pe kelegi wa yɛgɛ poro naa pe piile pe ni, ma Leya naa wi piile pe taga pe na, ko puŋgo na, mɛɛ Arashɛli naa Zhozɛfu poro taga. ");
INSERT INTO dyi_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","A wo jate wì si keli wa pe yɛgɛ, nɛɛ sogo naa yɛgɛ ki kanni wa tara ma saa ta sogosaga kɔlɔshyɛn, fɔ ma saa gbɔn wa wi ndɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kì kaa pye ma, a Ezawu wì si fe ma saa wi fili, mɛɛ kɛyɛn wa wi yɔlɔgɔ maa shari. A pe shyɛn pe nɛɛ gbele. ");
INSERT INTO dyi_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","A Ezawu wì suu yɛgɛ ki yirige ma wele, mɛɛ jɛɛlɛ naa piile pe yan. A wì si yewe ma yo fɔ: «Ambɛnɛ wɛlɛ mbele poro?» A Zhakɔbu wì suu yɔn sogo ma yo fɔ: «Wa Yɛnŋɛlɛ li yinmɛ pi ni, lì piile mbele kan mi ŋa ma kulonaŋa na yeri, poro wɛlɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","A kulojaala poro naa pe piile pe ni, pè si fulo, mɛɛ sogo ma pe yɛrɛ ti jiile wa tara ma Ezawu wi gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","A Leya naa wi piile pè si fulo ma sogo ma pe yɛrɛ ti jiile wa tara maa gbɔgɔ; ko puŋgo na, a Zhozɛfu naa Arashɛli pè si fulo fun ma sogo ma pe yɛrɛ ti jiile wa tara maa gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","A Ezawu wì suu yewe ma yo fɔ: «Yaayoro ŋgbeleye yan mì fili yi ni, ko kɔrɔ wo yɛn mɛlɛ?» A Zhakɔbu wì sho fɔ: «Mila jaa na kala lɔɔn ndanla, na tafɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","A Ezawu wì sho fɔ: «Na jɔnlɔ, yaara nda ti yɛn na yeri tìlan bɔ, ma woro ti yaga wa ma yɛɛ yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kona, a Zhakɔbu wì suu yɔn sogo ma yo fɔ: «Ayoo, mila ma yɛnri, na kaa pye na kala lɔɔn ndanla, yaara nda mì kan ma yeri, yɛnlɛ ti na; katugu ko kala na, na finliwɛ mba mì fili ma ni, pì cɛn ndɛɛ Yɛnŋɛlɛ lo mì fili li ni, paa màla yigi jɛŋgɛ ki kala na. ");
INSERT INTO dyi_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ki kala na, yaara nda mì kan ma yeri ti shɔ, katugu Yɛnŋɛlɛ lì kajɛŋgɛ pye mala kan. Yaraga ŋga fuun kala li mbe ya pye na na, ka yɛn na yeri.» A wì suu yɛnri ŋgbanga fɔ a Ezawu wì saa yɛnlɛ ti na mari shɔ. ");
INSERT INTO dyi_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","A Ezawu wì sho fɔ: «Ye konɔ li lɛ we kari, mi yaa sɔɔn torogo.» ");
INSERT INTO dyi_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","A Zhakɔbu wì suu yɔn sogo ma yo fɔ: «Na tafɔ, màga jɛn ma yo piile pe woro fanŋga ni. Simbanɛɛlɛ naa nanɛɛlɛ yɛn na yeri, piile yɛn na wɔnri pe na. Na waga tanga pe ni ŋgbanga pilige nuŋgba, pa yaayoro ti ni fuun ti yaa ku. ");
INSERT INTO dyi_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ki kala na, na tafɔ, keli na yɛgɛ maa kee. Mi yaa taga ma na mbaa tanri yɔɔrɔ, mbaa yala yaayoro to naa piile pe tangala li ni, fɔ sa gbɔn ma na wa Seyiri tara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","A Ezawu wì sho fɔ: «Mi yaa na woolo pe walaga nuŋgba yaga ma ni.» A Zhakɔbu wì suu pye fɔ: «Paa yiŋgi piin? Na tafɔ, ŋga mila jaa, na kala lo mbɔɔn ndanla ko cɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ki pilige nuŋgba ki ni, a Ezawu wì si konɔ li lɛ ma sɔngɔrɔ wa Seyiri tara. ");
INSERT INTO dyi_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","A Zhakɔbu wo si kari wa laga ŋga pe yinri Sukɔti. A wì si go kan wi yɛɛ kan, mɛɛ segbara kan yaayoro to kan. Ko kala na pe maa ki laga ki yinri Sukɔti. ");
INSERT INTO dyi_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Zhakɔbu wìla yiri wa Padamu Aramu ma pan yinŋge le Sishɛmu ca, wa Kana tara. A wì si saa wi paara yinrɛ cɛnsaga ki kan wa ca ki yɛsinmɛ na. ");
INSERT INTO dyi_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A wì si laga ŋga wìla wi paraga go ki kan ki lɔ Amɔri cɛnlɛ woolo pe yeri warifuwe pyɔ cɛnmɛ na. Amɔri wo wìla pye Sishɛmu ca ki kanfɔ we. ");
INSERT INTO dyi_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","A wì si saraga wɔsaga kan wa, maga mɛgɛ taga naga yinri Ɛli Elohe Izirayɛli, (ko kɔrɔ wo yɛn Yɛnŋɛlɛ li yɛn Izirayɛli Yɛnŋɛlɛ). ");
INSERT INTO dyi_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Pilige ka, Leya naa Zhakɔbu pe sumborombyɔ Dina wì si yiri ma kari sa ki tara ti sumborombiile pele shari. ");
INSERT INTO dyi_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","A Hɛvi cɛnlɛ woolo naŋa Amɔri wi pinambyɔ Sishɛmu wì si Dina wi yan. Sishɛmu wo wìla pye ki tara ti go na. A wì si ti a pè saa Dina wi lɛ wi kan, a wì pan ma sinlɛ wi ni fanŋga na, maa jɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","A wì si mara Zhakɔbu sumborombyɔ Dina wi na wi nawa pi ni fuun ni. Sumboro wìla pye maa ndanla fɔ jɛŋgɛ, a wila sɛntanra yuun wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","A Sishɛmu wì suu to Amɔri wi pye fɔ: «Ki sumboro ŋa wi yɛnri na kan mboo pɔri na jɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Zhakɔbu wìla ki logo fɔ Sishɛmu wìla wi sumborombyɔ Dina wi jɔgɔ. Ɛɛn fɔ, naa wi pinambiile pàa pye wa kɛrɛ naa yaayoro ti kɔnri, kì pye ma, a wì si pyeri fɔ a pè saa yiri wa ma pan. ");
INSERT INTO dyi_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","A Sishɛmu wi to Amɔri wì si kari Zhakɔbu wi kɔrɔgɔ mbe sa para wi ni (mbe pyɔ wi yɛnri). ");
INSERT INTO dyi_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Naa Zhakɔbu wi pinambiile pàa kaa yiri wa kɛrɛ ma pan, a pè si ŋga kìla pye ki logo. A pè sigi yan pè pe tɛgɛlɛ. A pè si nawa ŋgban fɔ jɛŋgɛ, katugu Sishɛmu wìla fɛrɛ kala pye wa Izirayɛli, ma sinlɛ Zhakɔbu wi sumborombyɔ wi ni. Ko sila daga pyewe ni. ");
INSERT INTO dyi_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","A Amɔri wì si pe pye fɔ: «Ye sumborombyɔ wìlan pinambyɔ Sishɛmu wi ndanla fɔ jɛŋgɛ. Mi yɛn na ye yɛnri yoo kan wi yeri wi jɔ. ");
INSERT INTO dyi_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ye mbe ya pye we ni yɔn finliwɛ na, waa jɛɛlɛ kaan we yɛɛ yeri. We yaa la ye sumborombiile pe pori, yaa we woolo pe pori. ");
INSERT INTO dyi_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ye yaa cɛn laga we ni, tara ti yaa pye ye yanrisaga. Ye cɛn yaa loo yaa pɛrɛ, ye yarijɛndɛ ta.» ");
INSERT INTO dyi_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","A Sishɛmu wo jate wì si pan ma Dina wi to naa wi ndɛɛlɛ pe pye fɔ: «Ye ti na kala li ye ndanla. Yaga yaraga ŋga fuun naga mbe yo mbe kan, mi yaa ki kan ye yeri. ");
INSERT INTO dyi_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Japɔrɔgɔ yariwɔndɔ to naa yarikanra tiga lɛgɛ yɛgɛ o yɛgɛ, yege yo na kan, pa mi yaa ti kan ye yeri, jaŋgo ye sumboro wo kan na yeri mboo pɔri na jɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","A Zhakɔbu wi pinambiile pè si Sishɛmu naa wi to Amɔri pe yɔn sogo tijinliwɛ pee ni, katugu Sishɛmu wìla pe jɔnlɔ sumboro Dina wi jɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","A pè si pe pye fɔ: «We se ya mbe we jɔnlɔ sumboro wi kan naŋa ŋa wii kɛnrɛkɛnrɛ wa yeri jɛlɛ. Pa ki yaa pye fɛrɛ kala we yeri. ");
INSERT INTO dyi_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","We yaa yere ki na kala nuŋgba na: ‹Nambala mbele fuun pe yɛn laga ye yeri, pe daga mbe kɛnrɛkɛnrɛ paa we yɛn.› ");
INSERT INTO dyi_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Pa kona we yaa la we sumbonɔ pe kaan ye yeri yaa pe pori, woro fun we yaa la ye woolo pe pori. We yaa cɛn laga ye ni, mbe pye cɛnlɛ nuŋgba ye ni. ");
INSERT INTO dyi_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ɛɛn fɔ, na yee yɛnlɛ ki na mbe logo we yeri, mbe ye yɛɛ kan pe ye kɛnrɛkɛnrɛ, pa we yaa we jɔnlɔ sumboro wi shɔ ye yeri mbaa kee.» ");
INSERT INTO dyi_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","A pe sɛnrɛ tì si Amɔri naa wi pinambyɔ Sishɛmu pe ndanla. ");
INSERT INTO dyi_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Lefɔnŋɔ wi sila mɔ ki kala li pyewe ni, a wì si ti, a pòo kɛnrɛkɛnrɛ, katugu Zhakɔbu wi sumborombyɔ wìla wi ndanla fɔ jɛŋgɛ. Ma si yala, wa lefɔnŋɔ wi to go, pàa pye naa jate ma wɛ leele sanmbala pe ni fuun pe na. ");
INSERT INTO dyi_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","A Amɔri wo naa wi pinambyɔ Sishɛmu wi ni, pè si kari wa ca ki mbogo yeyɔngɔ ki na, wa laga ŋga leele pe maa pile, mɛɛ para pe ca woolo pe ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Ki leele mbele pe yɛn yɛyinŋge na we ni. Ye ti pe cɛn laga we tara ti ni, paa loo paa pɛrɛ. Tara ti yɛn ma gbɔgɔ pe kan. We yaa la pe sumbonɔ pe pori, mbaa we woolo pe kaan pe yeri paa pe pori. ");
INSERT INTO dyi_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ɛɛn fɔ, ki nambala mbele, pe yaa yɛnlɛ mbe cɛn laga we ni, mbe pye cɛnlɛ nuŋgba we ni, ki kala nuŋgba na lo na: ‹Nambala mbele fuun pe yɛn laga we ni, pe daga mbe kɛnrɛkɛnrɛ mbe pye paa pe yɛn.› ");
INSERT INTO dyi_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Na waga yere ki na, pa pe yaa pan mbe cɛn laga we ni. Pa kona pe yaayoro ti ni fuun naa pe yarijɛndɛ ti yaa ka pye we woro.» ");
INSERT INTO dyi_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Leele mbele fuun pàa pan le ca ki mbogo yeyɔngɔ ki na, a pè si yɛnlɛ Amɔri naa wi pinambyɔ Sishɛmu pe sɛnyoro ti na. Nambala mbele fuun pàa pan wa ca ki mbogo yeyɔngɔ ki na, pè si pe yɛɛ kan a pè pe kɛnrɛkɛnrɛ. ");
INSERT INTO dyi_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ki pilige taanri wogo ki na, ma pe ta sagbanra ti yɛn na pe yaa, a Zhakɔbu wi pinambiile shyɛn, Simeyɔn naa Levi, Dina wi ndɛɛlɛ wele, pè si yiri ma pe tokobiye pe lɛ ma ye wa ca ki ni, ma nambala pe ni fuun pe gbo. Poro la pye naga yaan ndɛɛ kaŋgbanga se ya gbɔn pe na. ");
INSERT INTO dyi_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","A pè si Amɔri naa Sishɛmu pe gbo tokobiye pe ni fun, mɛɛ pe jɔnlɔ sumboro Dina wi lɛ wa Sishɛmu wi go ma yiri wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","A Zhakɔbu wi pinambiile sanmbala pè si gboolo pe san, ma ca ki san maga yarijɛndɛ ti lɛ, katugu pàa pe jɔnlɔ sumboro wi jɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","A pè sigi leele pe simbaala, naa sikaala, naa pe nɛrɛ to naa pe sofilele pe koli, nda fuun tìla pye wa ca, konaa nda fuun tìla pye wa yan. ");
INSERT INTO dyi_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Pàa yarijɛndɛ ti ni fuun ti koli, ma piile naa jɛɛlɛ pe ni fuun pe yigi ma kari pe ni, ma yinrɛ ti san pew mari yarijɛndɛ ti lɛ. ");
INSERT INTO dyi_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Kona, a Zhakɔbu wì si Simeyɔn naa Levi pe pye fɔ: «Yànla jatere wi piri na na mala mɛgɛ ki pɛn tara woolo pe yeri, Kana tara woolo naa Perɛzi cɛnlɛ woolo pe yeri. Nambala mbele pe yɛn na yeri, pe woro ma lɛgɛ. Ki leele mbele pe yaa gbogolo mbe yiri we kɔrɔgɔ, mbe malaga gbɔn we ni, mbe mi naa na woolo pe ni we tɔngɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","A Simeyɔn naa Levi pè sho fɔ: «Wii ja daga mbe we jɔnlɔ wi pye paa nanjaa yɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Pilige ka, a Yɛnŋɛlɛ lì si Zhakɔbu wi pye fɔ: «Yiri ma kari ma sa cɛn wa Betɛli. Ma saraga wɔsaga kan wa na kan. Pa mìla na yɛɛ naga ma na wa ki laga ki na, maga ta ma yɛn na fee mbe shɔ ma ndɔ Ezawu wi yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","A Zhakɔbu wì sigi yo wi go woolo poro naa mbele fuun pàa pye wi ni pe kan fɔ: «Yarisunndo nda ti yɛn ye yeri ma yiri cɛngɛlɛ kele yɛgɛ yeri, yeri wa. Ye yɛɛ pye kpoyi, ye ye yaripɔrɔ ti wɔ, ye ta yɛgɛ le. ");
INSERT INTO dyi_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","We yaa yiri mbe kari wa Betɛli. Mi yaa sa saraga wɔsaga kan wa Yɛnŋɛlɛ li kan, lo na làa na yɛnrɛwɛ pi logo sanga ŋa ni kìla ŋgban na na we, mala saga wa na kondangala li ni fuun li ni.» ");
INSERT INTO dyi_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kì kaa pye ma, yarisunndo nda fuun tìla pye pe yeri ma yiri cɛngɛlɛ kele yɛgɛ yeri, a pè siri wɔ mari kan Zhakɔbu wi yeri, naa pe nuŋgbogolo ke ni. A Zhakɔbu wì si titɛgɛ kɔn terebɛnti tige ka nɔgɔ, mari le wa mari tɔn, wa Sishɛmu ca ki tanla. ");
INSERT INTO dyi_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ko puŋgo na, a pè si kari. A Yɛnŋɛlɛ lì si fyɛrɛ gbɔrɔ wa ki laga ki kanŋgara na cara ti woolo pe na. Ki kala na lere kpɛ sila taga Zhakɔbu pinambiile pe na mbaa pe puro. ");
INSERT INTO dyi_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Zhakɔbu wo naa mbele fuun pàa pye wi ni, pè si saa gbɔn wa Luzi ca ki ni, ko ki yɛn Betɛli we, wa Kana tara. ");
INSERT INTO dyi_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","A wì si saraga wɔsaga kan le, nɛɛ ki laga ki yinri Ɛli Betɛli; katugu pa Yɛnŋɛlɛ làa li yɛɛ naga wi na wa, sanga ŋa ni wìla pye na fee mbe shɔ wi ndɔ Ezawu wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","A Erebeka wi gbegelefɔ Debora wì si ku, a pòo le wa Betɛli ca ki tanla, tigbɔgɔ ka nɔgɔ, ali ma pan ma gbɔn nala pe maa ki yinri tigbɔgɔ ŋga pe maa gbele wa ki nɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Zhakɔbu wi yiriŋgɔlɔ wa Padamu Aramu ma pan, a Yɛnŋɛlɛ lì sili yɛɛ naga wi na naa, mɛɛ duwaw wi na. ");
INSERT INTO dyi_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","A Yɛnŋɛlɛ lì suu pye fɔ: «Pe maa ma yinri Zhakɔbu, ɛɛn fɔ, pe saa ma yinri naa Zhakɔbu. Ma mɛgɛ ki yaa pye Izirayɛli.» Yɛnŋɛlɛ li nɛɛ wi yinri Izirayɛli. ");
INSERT INTO dyi_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","A lì suu pye fɔ: «Muwi mi yɛn Yɛnŋɛlɛ na yawa pi ni fuun fɔ. Mi yaa ma pye sevɔ, mbe piile lɛgɛrɛ kan ma yeri. Ma yaa ka pye cɛngɛlɛ lɛgɛrɛ to. Wunlumbolo yaa ka yiri wa ma setirige piile pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tara nda mìla kan Abirahamu wi yeri, ko puŋgo na, mari kan Izaki wi yeri, mi yaa ti kan ma yeri, puŋgo na, mberi kan ma setirige piile pe yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","A Yɛnŋɛlɛ lì si kari ma Zhakɔbu wi yaga le laga ŋga làa para wi ni we. ");
INSERT INTO dyi_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yɛnŋɛlɛ làa para Zhakɔbu wi ni laga ŋga na, a wì si titɛgɛ kɔn ma sinndɛlɛgɛ ka yerege wa, mɛɛ duvɛn wo wa ki go na maa pye yarikanga konaa ma sinmɛ wo wa ki go na mbege naga fɔ wìgi le Yɛnŋɛlɛ kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yɛnŋɛlɛ làa para Zhakɔbu wi ni laga ŋga na, a wì sigi mɛgɛ taga naga yinri Betɛli. ");
INSERT INTO dyi_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Kona, a Zhakɔbu wo naa wi go woolo pe ni, pè si yiri wa Betɛli ma kari. Pàa pye ma lali jɛnri Efirata ca ki ni, a Arashɛli wì si se. Wi sege kìla ŋgban fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Maa ta wila siin wi sege kì ŋgban wi na, jɛlɛ ŋa wìla pye naa sari wi se, wì suu pye fɔ: «Maga ka fyɛ, pinambyɔ wo wa ma yɛn na siin naa.» ");
INSERT INTO dyi_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Arashɛli wìla pye na kuun, wi yaa yinŋgi sanga ŋa ni, a wì si pyɔ wi mɛgɛ taga maa yeri Bɛni Oni. Ɛɛn fɔ, a tofɔ wì suu mɛgɛ taga naa yinri Bɛnzhamɛ. ");
INSERT INTO dyi_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","A Arashɛli wì si ku, a pè suu le wa Efirata ca konɔ li yɔn na, pe maa ki ca ki yinri fun Betilɛɛmu. ");
INSERT INTO dyi_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","A Zhakɔbu wì si sinndɛlɛgɛ ka yerege wa Arashɛli fanga ki go na. Pe maa ki sinndɛlɛgɛ ki yinri Arashɛli fanga sinndɛlɛgɛ ali ma pan ma gbɔn nala. ");
INSERT INTO dyi_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","A Izirayɛli wì si kari ma saa wi paraga go ki kan wa Migidali Edɛri laga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ma Izirayɛli wi ta wìla pye ma cɛn wa ki tara ti ni, a Urubɛn wì si saa sinlɛ Biliha wi ni, wo ŋa wìla pye wi to wi jɔ shyɛnwoo. A Izirayɛli wì sigi logo. Zhakɔbu pinambiile pàa pye kɛ ma yiri shyɛn. ");
INSERT INTO dyi_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya pinambiile pe mɛrɛ ti nda: Urubɛn wìla pye Zhakɔbu wi pinambyɔ koŋgbanŋa, mɛɛ Simeyɔn taga, naa Levi, naa Zhuda, naa Isakari, naa Zabulɔn. ");
INSERT INTO dyi_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Arashɛli pinambiile pe mɛrɛ ti nda: Zhozɛfu naa Bɛnzhamɛ. ");
INSERT INTO dyi_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Arashɛli wi kulojɔ Biliha wi pinambiile pe mɛrɛ ti nda: Dan naa Nɛfitali. ");
INSERT INTO dyi_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leya wi kulojɔ Zilipa wi pinambiile pe mɛrɛ ti nda: Gadi naa Asɛri. Ki pinambiile mbele poro wɛlɛ Zhakɔbu wìla se maa ta wa Padamu Aramu tara. ");
INSERT INTO dyi_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","A Zhakɔbu wì si sɔngɔrɔ ma kari wa wi to Izaki wi yeri, wa Mamire laga ki ni, wa Kiriyati Ariba ca ki tanla, ko ŋga pe maa yinri Eburɔn we. Abirahamu naa Izaki pàa cɛn wa faa. ");
INSERT INTO dyi_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Izaki wìla ta yɛlɛ cɛnmɛ naa nafa tijɛrɛ (180). ");
INSERT INTO dyi_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Wìla lɛ ma tin yinwege ki na, mɛɛ jɛn ma ku ma taga wa wi tɛlɛye pe na. A wi pinambiile Ezawu naa Zhakɔbu pè suu le. ");
INSERT INTO dyi_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ezawu setirige piile poro wɛlɛ mbele yɛɛn. Ezawu wo pe yinri fun Edɔmu. ");
INSERT INTO dyi_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Kana tara fɛnnɛ jɛɛlɛ la wɛlɛ Ezawu wìla pɔri. Pe mɛrɛ ti nda: Hɛti cɛnlɛ woolo naŋa Elɔn wi sumborombyɔ Ada wo naa Ana sumborombyɔ Oholibama. Oholibama wìla pye Hɛvi cɛnlɛ woolo naŋa Zibewɔn wo pishyɛnwoo. ");
INSERT INTO dyi_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ezawu wìla Ishimayɛli wi sumborombyɔ Basimati wi pɔri fun, Nebayɔti wi jɔnlɔ sumboro we. ");
INSERT INTO dyi_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada wìla Elifazi se Ezawu wi kan. A Basimati wo Erewuwɛli se. ");
INSERT INTO dyi_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","A Oholibama wo si Yehushi, naa Yalamu, konaa Kora poro se. Poro wɛlɛ pàa pye Ezawu wi pinambiile mbele pàa se wi kan wa Kana tara. ");
INSERT INTO dyi_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","A Ezawu wì suu jɛɛlɛ, naa wi pinambiile, naa wi sumborombiile, naa wi kulolo pe ni fuun, naa wi yaayoro ŋgbeleye, naa wi yaayoro sannda to naa yarijɛndɛ nda fuun wìla ta wa Kana tara ti lɛ, mɛɛ kari ma saa cɛn tara ta yɛgɛ ni, ma lali wi jɔnlɔ Zhakɔbu wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Katugu pe kɛɛ yaara tìla pye ma lɛgɛ jɛŋgɛ, fɔ pe saa ya cɛn laga nuŋgba. Pàa pye ma cɛn tara nda ni, tìla pye ma kologo pe yaayoro ti na. ");
INSERT INTO dyi_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ko kala na Ezawu wìla saa cɛn wa Seyiri yanwiga ki na. Ezawu wo pe yinri fun Edɔmu. ");
INSERT INTO dyi_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ezawu wi setirige piile poro wɛlɛ mbele yɛɛn. Wo wìla pye Edɔmu cɛnlɛ woolo mbele pàa pye ma cɛn wa Seyiri yanwiga ki na pe tɛlɛ we. ");
INSERT INTO dyi_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ezawu wi pinambiile pe mɛrɛ ti nda: Elifazi wo la pye wi jɔ Ada wo pinambyɔ. Erewuwɛli wo la pye wi jɔ Basimati wo pinambyɔ. ");
INSERT INTO dyi_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazi wi pinambiile pe mɛrɛ ti nda: Tema, naa Omari, naa Zefo, naa Gatamu konaa Kenazi. ");
INSERT INTO dyi_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Jɛlɛ ŋa pàa pye na yinri Timina wìla pye Ezawu pinambyɔ Elifazi wi cɛnfɔ. Wìla pinambyɔ wa se wi kan fun, pàa pye naa yinri Amalɛki. Poro pàa pye Ada naa Ezawu pe pishyɛnwoolo wele. ");
INSERT INTO dyi_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Erewuwɛli wi pinambiile pe mɛrɛ ti nda: Nahati, naa Zera, naa Shama konaa Miza. Poro pàa pye Ezawu naa wi jɔ Basimati pe pishyɛnwoolo wele. ");
INSERT INTO dyi_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ezawu wi jɔ Oholibama ŋa wìla pye Ana wi sumborombyɔ, konaa ma pye Zibewɔn pishyɛnwoo, wi pinambiile mbele wìla se Ezawu wi kan, pe mɛrɛ ti nda: Yehushi, naa Yalamu konaa Kora. ");
INSERT INTO dyi_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Mbele pàa pye teele Ezawu wi setirige piile pe sɔgɔwɔ poro wɛlɛ mbele yɛɛn. Ezawu pinambyɔ koŋgbanŋa Elifazi wi pinambiile pe mɛrɛ ti nda: Tema wìla pye sege to, naa sege to Omari, naa sege to Zefo, naa sege to Kenazi, ");
INSERT INTO dyi_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","naa sege to Kora, naa sege to Gatamu konaa sege to Amalɛki. Poro mbele poro pàa pye sege teele wa Elifazi piile pe ni ma cɛn wa Edɔmu tara. Poro pàa pye Ezawu wi jɔ Ada wi pishyɛnwoolo wele. ");
INSERT INTO dyi_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ezawu pinambyɔ Erewuwɛli wi pinambiile pe mɛrɛ ti nda: Nahati wìla pye sege to, naa sege to Zera, naa sege to Shama konaa sege to Miza. Poro mbele poro pàa pye sege teele wa Erewuwɛli wi piile pe ni ma cɛn wa Edɔmu tara. Poro pàa pye Ezawu wi jɔ Basimati wi pishyɛnwoolo wele. ");
INSERT INTO dyi_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ezawu jɔ Oholibama wi pinambiile pe mɛrɛ ti nda: Yehushi wìla pye sege to, naa sege to Yalamu, konaa sege to Kora. Poro mbele poro pàa pye Ezawu jɔ Oholibama wi pinambiile mbele pàa pye sege teele. Oholibama wo la pye Ana wi sumborombyɔ. ");
INSERT INTO dyi_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Poro mbele poro pàa pye Ezawu wi setirige piile wele. Poro pàa pye teele setirige piile sanmbala pe sɔgɔwɔ. Ezawu wo pe yinri fun Edɔmu. ");
INSERT INTO dyi_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hɔri cɛnlɛ woolo naŋa Seyiri wi pinambiile pe mɛrɛ ti nda. Poro pàa keli ma cɛn wa Edɔmu tara. Lotan, naa Shobali, naa Zibewɔn, naa Ana, ");
INSERT INTO dyi_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","naa Dishɔn, naa Ezɛri konaa Dishan. Poro mbele poro pàa pye Hɔri cɛnlɛ woolo pe teele wele, ma pye Seyiri setirige piile, wa Edɔmu tara. ");
INSERT INTO dyi_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan wi pinambiile pe mɛrɛ ti nda: Hɔri konaa Emamu. Lotan wi nɔsepyɔ sumboro la pye wa, pàa pye naa yinri Timina. ");
INSERT INTO dyi_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobali wi pinambiile pe mɛrɛ ti nda: Alivan, naa Manahati, naa Ebali, naa Shefo konaa Onamu. ");
INSERT INTO dyi_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibewɔn pinambiile pe mɛrɛ ti nda: Aya naa Ana. Ko Ana wo wìla saa puluyo yan wa gbinri wi ni yi tɔnmɔ pìla pye ma wɛri, ma yala wìla pye naa to Zibewɔn wi sofilele pe kɔnri. ");
INSERT INTO dyi_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana wi piile pe mɛrɛ ti nda: Wi pinambyɔ Dishɔn konaa wi sumborombyɔ Oholibama. ");
INSERT INTO dyi_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishɔn pinambiile pe mɛrɛ ti nda: Emidan, naa Eshiban, naa Yitiran konaa Keran. ");
INSERT INTO dyi_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezɛri pinambiile pe mɛrɛ ti nda: Bilihan, naa Zaavan, konaa Akan. ");
INSERT INTO dyi_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan pinambiile pe mɛrɛ ti nda: Uzi naa Aran. ");
INSERT INTO dyi_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hɔri cɛnlɛ woolo mbele pàa pye sege teele pe mɛrɛ ti nda: Lotan wìla pye sege to, naa sege to Shobali, naa sege to Zibewɔn, naa sege to Ana, ");
INSERT INTO dyi_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","naa sege to Dishɔn, naa sege to Ezɛri konaa sege to Dishan. Poro mbele poro pàa pye teele Hɔri cɛnlɛ woolo pe sɔgɔwɔ, wa Seyiri tara. ");
INSERT INTO dyi_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Wunlumbolo mbele pàa cɛn wunluwɔ pi na Edɔmu tara ti go na, maga ta wunluwɔ fa cɛn Izirayɛli tara woolo pe go na gbɛn, pe mɛrɛ ti nda: ");
INSERT INTO dyi_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bewɔri wi pinambyɔ Bela wìla pye wunluwɔ wa Edɔmu tara ti go na. Wi ca pàa pye naga yinri Dinaba. ");
INSERT INTO dyi_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela kuŋgɔlɔ, a Bozira ca fɛnnɛ naŋa Zera wi pinambyɔ Yobabu wì si cɛn wa wi yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu kuŋgɔlɔ, a Hushamu ŋa wìla yiri wa Tema setirige piile pe tara, wì si cɛn wa wi yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamu kuŋgɔlɔ, a Bedadi pinambyɔ Hadadi wì si cɛn wa wi yɔnlɔ. Wo wìla malaga gbɔn Madiyan cɛnlɛ woolo pe ni ma ya pe ni wa Mowabu tara wasege ki ni. Wi ca pàa pye naga yinri Aviti. ");
INSERT INTO dyi_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi kuŋgɔlɔ, a Masireka ca fɛnnɛ naŋa Samila wo si cɛn wa wi yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samila kuŋgɔlɔ, Sawuli ŋa wìla yiri wa Erehobɔti gbaan yɔn tara ti ni, wì si cɛn wa wi yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawuli kuŋgɔlɔ, a Akibɔri pinambyɔ Baali Hana wì si cɛn wa wi yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akibɔri pinambyɔ Baali Hana wi kuŋgɔlɔ, a Adari wì si cɛn wa wi yɔnlɔ. Wi ca pàa pye naga yinri Pawu. Pàa pye naa jɔ wi yinri Metabeyɛli. Mezahabu sumborombyɔ Matirɛdi wo sumborombyɔ lawi. ");
INSERT INTO dyi_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Teele mbele pàa yiri wa Ezawu setirige piile pe ni ma yala pe seye naa pe tara ti ni, pe mɛrɛ ti nda: Timina wìla pye sege to, naa sege to Aliva, naa sege to Yetɛti, ");
INSERT INTO dyi_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","naa sege to Oholibama, naa sege to Ela, naa sege to Pinɔ, ");
INSERT INTO dyi_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","naa sege to Kenazi, naa sege to Tema, naa sege to Mibizari, ");
INSERT INTO dyi_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","naa sege to Magidiyɛli, konaa sege to Iramu. Poro mbele poro pàa pye teele Edɔmu cɛnlɛ woolo pe sɔgɔwɔ, ma yala pe cɛnsara ti ni, wa pe tara. Ezawu wo wìla pye Edɔmu cɛnlɛ woolo pe tɛlɛ we. ");
INSERT INTO dyi_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Kona, a Zhakɔbu wì si saa cɛn wa Kana tara, wa laga ŋga wi to wìla pye ma cɛn we. ");
INSERT INTO dyi_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Zhakɔbu wi setirige piile pe kapyegele ke ŋgele. Zhozɛfu wìla ta yɛlɛ kɛ ma yiri kɔlɔshyɛn, a wi nɛɛ pinlɛlɛ wi ndɛɛlɛ pe ni, a paa simbaala naa sikaala kɔnri. Maga ta wìla pye lefɔnmbile, wi ma pinlɛ wi to jɛɛlɛ Biliha naa Zilipa pe pinambiile pe ni. Zhozɛfu wìla pye na sɛnpere pere nda leele pàa pye na yuun wi ndɛɛlɛ pe kanŋgɔlɔ ti yuun wi to wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Zhozɛfu wìla pye ma Izirayɛli wi ndanla ma wɛ wi pinambiile sanmbala pe na, katugu wìla wi se wa wi lelɛwɛ pi ni. A wì si derigbɔgɔ tiyɔngɔ ka ti wi kan yɔɔnrɔ ni. ");
INSERT INTO dyi_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Naa wi ndɛɛlɛ pàa kaa ki yan wi pe to wi ndanla ma wɛ pe ni fuun pe na, a pè suu panra. Pe sila pye na sɛntanra yuun wi ni naa. ");
INSERT INTO dyi_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Pilige ka, a Zhozɛfu wì si wɔɔnrɔ wɔnlɔ mɛɛ saa ti yɛgɛ yo wi ndɛɛlɛ pe kan. A pè suu panra naa ma wɛ. ");
INSERT INTO dyi_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Wìla pe pye fɔ: «Wɔɔnrɔ nda mì wɔnlɔ, ye pan yeri logo na yeri. ");
INSERT INTO dyi_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Wàa pye wa kɛrɛ na yarilire ti kɔɔn nari poo pɔgɔlɔ pɔgɔlɔ. Le ki yɔnlɔ nuŋgba li ni, a na pɔlɔ lì si yiri ma yere ma sin. A ye pɔgɔlɔ kè si wa mali maga, nɛɛ fɔli li yɛgɛ sɔgɔwɔ nali gbogo.» ");
INSERT INTO dyi_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","A wi ndɛɛlɛ pè suu pye fɔ: «Maa ki jate mbe cɛn we go na mbaa we yɛgɛ sinni kɛ?» A pè suu panra naa ma wɛ koŋgbanŋga ki na wi wɔɔnrɔ naa wi sɛnyoro ti kala na. ");
INSERT INTO dyi_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","A wì si wɔɔnrɔ ta wɔnlɔ naa, mɛɛ ti yo wi ndɛɛlɛ pe kan ma yo fɔ: «Mì wɔɔnrɔ ta wɔnlɔ naa, maga yan yɔnlɔ ko naa yeŋge ki ni, naa wɔnŋgɔlɔ kɛ ma yiri nuŋgba pan na fɔli na yɛgɛ sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A wì si saa ti yɛgɛ yo wi to naa wi ndɛɛlɛ pe kan. A wi to wì si gbanla wi na, mɛɛ wi pye fɔ: «Wɔɔnrɔ nda mà wɔnlɔ yɛɛn, to kɔrɔ wo yɛn mɛlɛ? Kì cɛn maa ki jate mi naa ma nɔ, naa ma ndɛɛlɛ pe ni, we yaa ka saa sogo mbaa we yɛrɛ ti jiile wa tara ma yɛgɛ sɔgɔwɔ kɛ?» ");
INSERT INTO dyi_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","A wi ndɛɛlɛ pe nɛɛ yenjara piin wi ni, ɛɛn fɔ, a wi to wi nɛɛ jatere piin ki wɔɔnrɔ ti na. ");
INSERT INTO dyi_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Zhozɛfu wi ndɛɛlɛ pàa kari sa pe to simbaala naa sikaala pe kɔnri wa Sishɛmu ca wasege ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Pilige ka, a Izirayɛli wì si Zhozɛfu wi pye fɔ: «Ma ndɛɛlɛ pe yɛn na yaayoro ŋgbelege ki kɔnri wa Sishɛmu. Pan, mbɔɔn tun wa pe yeri.» A Zhozɛfu wì sho fɔ: «Mìgi logo na to.» ");
INSERT INTO dyi_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","A Izirayɛli wì suu pye fɔ: «Kari ma sɔɔn ndɛɛlɛ pe wele na kaa pye pe yɛn wa ŋgbaanla, konaa yaayoro ti ni fun. Mɛɛ pan ma pe sɛnrɛ yo na kan.» A Izirayɛli wì suu torogo ma yiri wa Eburɔn gbunlundɛgɛ ki ni. A Zhozɛfu wì si kari wa Sishɛmu. ");
INSERT INTO dyi_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","A naŋa wà suu yan wila yanri wa wasege ki ni, mɛɛ wi yewe fɔ: «Yiŋgi maa lagajaa?» ");
INSERT INTO dyi_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","A Zhozɛfu wì sho fɔ: «Na ndɛɛlɛ poro mi yɛn na lagajaa. Mi yɛn nɔɔ yɛnri, pe yɛn na pe yaayoro ti kɔnri laga ŋga na, ki naga na na.» ");
INSERT INTO dyi_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","A naŋa wì si Zhozɛfu wi pye fɔ: «Pè yiri na laga ŋga ko ni ma kari, katugu mìgi logo na pe yeri, paa yuun fɔ: ‹Yoo kari wa Dotan ca.› » A Zhozɛfu wì si taga wi ndɛɛlɛ pe na na pe tuuro tɔnri, mɛɛ saa pe yan wa Dotan. ");
INSERT INTO dyi_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","A wi ndɛɛlɛ pè suu yan wa lege wila paan. Sanni wi sa yɔngɔ pe ni, a pè si yɔn le wi na mboo gbo. ");
INSERT INTO dyi_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Pàa ki yo pe yɛɛ kan fɔ: «Wɔɔnrɔ wɔnlɔfɔ gbɔɔ wi ŋa wa wila paan. ");
INSERT INTO dyi_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ye pan yiŋgɔ woo gbo woo wa titɛgɛ ka nuŋgba ni, wee saga yo fɔ cɛngɛ pege to wi na maa ka. Pa kona wi wɔɔnrɔ ti yaa ka pye yaraga ŋga, we yaa kaga yan.» ");
INSERT INTO dyi_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","A Urubɛn wì sigi logo pe yeri, mɛɛ yere ki yerewe mbe Zhozɛfu wi shɔ pe yeri, ma yo fɔ: «Yaga kaa gbo.» ");
INSERT INTO dyi_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","A wì sho naa fɔ: «Titɛgɛ ŋga ki yɛn laga wasege ki ni, yoo wa wa ki ni. Ɛɛn fɔ, yaga ka lere gbo.» Urubɛn wìla pye na ko yuun ma mbe ta mboo shɔ pe yeri, mbe sɔngɔrɔ saa kan wi to wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Naa Zhozɛfu wìla kaa gbɔn le pe tanla, a pè suu yigi, maa derigbɔgɔ tiyɔngɔ ŋga yɔɔnrɔ ni ki tile maga wɔ wi na, ");
INSERT INTO dyi_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ma suu yigi maa wa wa titɛgɛ ki ni; ki titɛgɛ kìla pye waga, tɔnmɔ sila pye wa ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ko puŋgo na, a pè si saa cɛn mbe ka. Naa pàa kaa pe yɛrɛ ti yirige ma wele, a pè si Ishimayɛli setirige piile pele yan paa paan pe yɔngɔmɛye ni pè tanli pe yɛɛ na, ma yiri wa Galaadi tara. Tige tɔnmɔ nuwɔ taan, naa timuwɛ nuwɔ taan, naa nuwɔ taanyaara nda pe yinri miiri to tuguro tìla pye pe yɔngɔmɛye pe na. Pàa pye na kee ti ni wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kona, a Zhuda wì suu to seyɛɛnlɛ pe pye fɔ: «Yiŋgi tɔnli we ya ta, na waga we jɔnlɔ wi gbo mboo kunwɔ pi lara we? ");
INSERT INTO dyi_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ye pan woo pɛrɛ Ishimayɛli setirige piile pe yeri. Ɛɛn fɔ, yaga ka ti woo gbo; katugu wi yɛn we jɔnlɔ ma pye we go woo.» A wi to seyɛɛnlɛ pè si yere ki na. ");
INSERT INTO dyi_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ko puŋgo na, Madiyan tara pɛrɛfɛnnɛ pèle la pye na toro le. A pè si Zhozɛfu wi tile maa wɔ maa pɛrɛ Ishimayɛli setirige piile pe yeri warifuwe pyɔ nafa na. A poro si kari wi ni wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ko puŋgo na, a Urubɛn wì si sɔngɔrɔ wa titɛgɛ ki tanla ma saa wele wa. Wi sila Zhozɛfu wi yan wa. A wì suu yɛɛra yaripɔrɔ ti yigi mari walagi lawɔrɔ ti kala na, ");
INSERT INTO dyi_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","mɛɛ sɔngɔrɔ wa wi jɛɛnlɛ pe yeri, ma yo fɔ: «Pyɔ wi woro wa titɛgɛ ki ni. Mi yaa yɛgɛ le se?» ");
INSERT INTO dyi_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","A pè si Zhozɛfu wi derigbɔgɔ tiyɔngɔ ŋga yɔɔnrɔ ni ki lɛ, ma sikapɔlɔ wa kɔnli, mɛɛ ki piligi wa wi kasanwa pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ko puŋgo na, a pè si kari derigbɔgɔ tiyɔngɔ ŋga yɔɔnrɔ ni ki ni pe to wi kan, mɛɛ wi pye fɔ: «Wè saa ki derege ŋga yɛɛn ki yan. Ki wele jɛŋgɛ na kaa pye ma pinambyɔ wi derigbɔgɔ tiyɔngɔ ŋga yɔɔnrɔ ni koyi.» ");
INSERT INTO dyi_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","A Zhakɔbu wì sigi yan maga jɛn, mɛɛ yo fɔ: «Na pinambyɔ wi derigbɔgɔ tiyɔngɔ ŋga yɔɔnrɔ ni koyi. Cɛngɛ pege kà wi ka. Pè Zhozɛfu wi kɔɔnlɔ yuroyuroyuro.» ");
INSERT INTO dyi_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","A Zhakɔbu wì suu yɛɛra yaripɔrɔ ti walagi kayaŋga ki na, mɛɛ kunwɔ yaripɔrɔ lɛ ma le, mɛɛ wi pinambyɔ wi kunwɔ pi gbele ma mɔ pi na. ");
INSERT INTO dyi_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A wi pinambiile naa wi sumborombiile pe ni fuun pè si pan mboo kotogo ki sogo wi na. Ɛɛn fɔ, wìla je poo kotogo ki sogo wi na. Wìla pye na yuun fɔ: «Mi yaa koro la kunwɔ pi gbele fɔ sa kari na pinambyɔ wi kɔrɔgɔ wa kuulo tara.» A wì si koro naa pinambyɔ wi kunwɔ pi gbele. ");
INSERT INTO dyi_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ko sanga wo ni, a Madiyan tara fɛnnɛ pè si saa Zhozɛfu wi pɛrɛ wa Ezhipiti tara, Farawɔn wi legbɔɔ Potifari wi yeri. Potifari wìla pye Farawɔn wi laga welefɛnnɛ to. ");
INSERT INTO dyi_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ki sanga wi ni, a Zhuda wì si laga wi to seyɛɛnlɛ pe na, mɛɛ kari Adulamu ca fɛnnɛ naŋa wa kɔrɔgɔ, pàa pye naa yinri Ira. ");
INSERT INTO dyi_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Wa ki laga ki na, a Zhuda wì si Kana tara fɛnnɛ sumboro wa yan, pàa pye naa to wi yinri Shuwa. A wì suu pɔri maa jɛn jɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","A jɛlɛ wì si kugbɔ lɛ mɛɛ pinambyɔ se, a Zhuda wì suu mɛgɛ taga naa yinri Ɛri. ");
INSERT INTO dyi_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","A jɛlɛ wì si kugbɔ lɛ naa mɛɛ pinambyɔ se, maa mɛgɛ taga naa yinri Ona. ");
INSERT INTO dyi_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","A wì si pinambyɔ wa se naa, maa mɛgɛ taga naa yinri Shela. Wìla se maga ta Zhuda wìla pye wa ca ŋga pàa pye na yinri Kezibu. ");
INSERT INTO dyi_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","A Zhuda wì si jɛlɛ pɔri maa kan wi pinambyɔ koŋgbanŋa Ɛri wi yeri, pàa pye naa yinri Tamari. ");
INSERT INTO dyi_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Zhuda wi pinambyɔ koŋgbanŋa Ɛri wìla pe Yawe Yɛnŋɛlɛ li yɛgɛ na; a Yawe Yɛnŋɛlɛ lì si ti a wì ku. ");
INSERT INTO dyi_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kona, a Zhuda wì si Ona wi pye fɔ: «Ma ndɔ jɔ wi lɛ maa tɛgɛ ma jɔ, ŋga ma daga mbe pye kufɔ wi yɔnlɔ maga pye, ma setirige piile se ma ndɔ wi kan.» ");
INSERT INTO dyi_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ona wìla ki jɛn ma yo ki setirige ki se ka pye wo wogo. Na wiga fili jɛlɛ wi ni sanga ŋa ni, wi mɛɛ wi nama pi wo tara, jaŋgo wiga ka ta mbe setirige piile se wi ndɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ŋga wìla pye na piin, ki sila Yawe Yɛnŋɛlɛ li ndanla; a lì si ti a wì ku fun. ");
INSERT INTO dyi_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kì kaa pye ma, a Zhuda wì suu pijɔ Tamari wi pye fɔ: «Mà kaa pye naŋgunjɔ, kari ma sa cɛn wa ma to go fɔ na pinambyɔ Shela wi sa yiri wi lɛ wɔɔn tɛgɛ.» Wìla ko yo ma, katugu wìla pye naa yɛɛ piin fɔ: «Kii daga Shela wi ku fun paa yɛgɛ ŋga na wi ndɛɛlɛ pè ku we.» Kì kaa pye ma, a Tamari wì si kari ma saa cɛn wa wi to go. ");
INSERT INTO dyi_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Naa wagati wà la kaa toro, a Shuwa wi sumborombyɔ ŋa wìla pye Zhuda jɔ wì si ku. Naa Zhuda wi kotogo kìla kaa sogo wi na, a wì si kari wa ca ŋga pàa pye na yinri Timina sa mbele pàa pye naa simbaala naa wi sikaala pe sire ti kɔɔnlɔ pe wele, wo naa wi wɔnlɔnaŋa Ira ŋa wìla yiri wa Adulamu ca wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","A Leele pèle sigi yo Tamari wi kan fɔ: «Ma pɔlɔ wi to wi yɛn na toro na kee wa Timina ca saa yaayoro ti sire ti kɔɔnlɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Kì kaa pye ma, a Tamari wì suu naŋgunjagara yaripɔrɔ ti wɔ mari tɛgɛ, mɛɛ wi yɛɛ tɔn paraga ni maa yɛɛ fo, mɛɛ saa cɛn wa Enayimu ca mbogo yeyɔngɔ ki na, wa Timina ca konɔ li yɔn na. Katugu wìla ki jɛn ma yo Shela wìla yiri ma lɛ, pe sila si wo Tamari wi kan wi yeri wuu tɛgɛ wi jɔ. ");
INSERT INTO dyi_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Naa Zhuda wìla kaa wi yan, a wì sigi yan ndɛɛ nanjaa lawi, katugu wìla wi yɛgɛ ki fo paraga ni. ");
INSERT INTO dyi_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Wi sila ki jɛn mbe yo wi pijɔ wowi. A wì si fulo wa wi tanla, wa konɔ li yɔn na, mɛɛ wi pye fɔ: «Shokari mbe sa sinlɛ ma ni.» A Tamari wì sho fɔ: «Yiŋgi ma yaa kan na yeri mbe si jɛn mbe sinlɛ na ni?» ");
INSERT INTO dyi_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","A Zhuda wì sho fɔ: «Mi yaa sugbɔ yirifɔnŋɔ wa yigi wa na sikaala ŋgbelege ki ni mbe pan mboo kan ma yeri.» A jɛlɛ wì suu pye fɔ: «Yiŋgi ma yaa keli mbe kan na yeri ki pye paa tɛgɛrɛ yɛn fɔ ma sa pan wi ni?» ");
INSERT INTO dyi_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","A Zhuda wì suu yewe ma yo fɔ: «Yiŋgi maa jaa mbe keli mbe kan ma yeri ki pye pa tɛgɛrɛ yɛn?» A jɛlɛ wì sho fɔ: «Ma mɛgɛ ki tɛgɛrɛ yaraga konaa ki maŋga ki ni, naa gbɔtangala na li yɛn ma kɛɛ, ti wɔ mari kan na yeri.» A wì siri wɔ mari kan wi yeri, mɛɛ saa sinlɛ wi ni. A jɛlɛ wì si kugbɔ lɛ wi na. ");
INSERT INTO dyi_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","A jɛlɛ wì si yiri ma sɔngɔrɔ wa wi to go, mɛɛ paraga ŋga wìla tɛgɛ maa yɛɛ fo ki laga maga tɛgɛ, mɛɛ wi naŋgunjagara yaripɔrɔ ti lɛ mari le. ");
INSERT INTO dyi_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ko puŋgo na, a Zhuda wì si sugbɔ yirifɔnŋɔ wi kan wi wɔnlɔnaŋa ŋa wìla yiri wa Adulamu ca wi yeri ma yo wi saa kan, wuu yaara nda wìla keli ma kan paa tɛgɛrɛ yɛn ti shɔ jɛlɛ wi yeri. Ɛɛn fɔ, wi wɔnlɔnaŋa wi sila sa jɛlɛ wi yan. ");
INSERT INTO dyi_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","A wì si Enayimu ca fɛnnɛ pe yewe ma yo fɔ: «Nanjaa ŋa wìla pye ma cɛn na konɔ li yɔn na wi yɛn se yeri?» A pè suu yɔn sogo ma yo fɔ: «Malɛ wa, we fa nanjaa yan na ki laga ŋga ki na.» ");
INSERT INTO dyi_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","A naŋa wì si sɔngɔrɔ wa Zhuda wi yeri ma suu pye fɔ: «Mi suu yan. Ki laga ki woolo jate pànla pye ma yo maga lɛ wa pe fa nanjaa yan le ki laga ki na.» ");
INSERT INTO dyi_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","A Zhuda wì sho fɔ: «Na yaara nda ti wa wi yeri, wiri yaga wa wi yɛɛ yeri. Waga ka fɛrɛ wa we yɛɛ na. Mì wo pan sugbɔ yirifɔnŋɔ wo ni, a mboro saa jɛlɛ wi wele ma suu yan.» ");
INSERT INTO dyi_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Sanni sa gbɔn yeŋge taanri, a pè si pan maga yo Zhuda wi kan fɔ: «Ma pijɔ Tamari wùu yɛɛ pye nanjaa, wì yɛrɛ kugbɔ ta wa wi nanjara ti ni.» A Zhuda wì sho fɔ: «Yoo yirige ye pan wi ni, wi daga poo sogo wee.» ");
INSERT INTO dyi_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Naa pàa kaa na paan wi ni, a wì si tun wa wi pɔlɔ to wi yeri, ma yo fɔ: «Lere ŋa wì kugbɔ ki taga na na, ki yaara nda wo woro ri: Wi mɛgɛ ki tɛgɛrɛ yaraga konaa ki maŋga ki ni, naa wi gbɔtangala li ni. Wi bala wigi fɔ wi lagaja wuu jɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","A Zhuda wì si yaara ti yan mari jɛn, ma sho fɔ: «Jɛlɛ wi yɛn ma sin ma wɛ na na. Kaselege ko na, mila daga mboo kan na pinambyɔ Shela wi yeri wi jɔ, mii sigi pye.» Ko puŋgo na, Zhuda wi sila sinlɛ jɛlɛ wi ni naa. ");
INSERT INTO dyi_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Naa jɛlɛ wi sesanga wìla kaa gbɔn, a pè sigi jɛn ma yo waanla pàa pye wa wi lara. ");
INSERT INTO dyi_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Naa wìla kaa na siin, a pyɔ nuŋgba suu kɛɛ ki yirige laga funwa na. Jɛlɛ ŋa wìla pye naa sari sege ki na, wì si jese yɛɛn pɔ kɛɛ ki na mɛɛ yo fɔ: «Ŋa wo wì keli ma se.» ");
INSERT INTO dyi_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ɛɛn fɔ, a wì suu kɛɛ ki sɔngɔrɔ maga leŋge, a wi waan yɛnlɛ wì si yiri. Ŋa wìla pye na jasee wi sari wi se, wì sho fɔ: «Wele, mà fogo yɛngɛ ma yɛɛ kan.» A pè suu mɛgɛ taga naa yinri Perɛzi. ");
INSERT INTO dyi_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ko puŋgo na, a pè si pyɔ sanŋa wi se jese yɛɛn wi ni wa wi kɛɛ ki na. A pè suu mɛgɛ taga naa yinri Zera. ");
INSERT INTO dyi_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Koni, a Ishimayɛli setirige piile pè si kari Zhozɛfu wi ni wa Ezhipiti tara. A Ezhipiti tara fɛnnɛ naŋa wà suu lɔ pe yeri, pàa pye naa yinri Potifari. Potifari wìla pye Farawɔn wi legbɔɔ konaa ma pye wi laga welefɛnnɛ to. ");
INSERT INTO dyi_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yawe Yɛnŋɛlɛ làa pye Zhozɛfu wi ni, ki kala na, wi kagala ke ni fuun kàa pye na yɔngɔ wi kan. Zhozɛfu wìla pye ma cɛn wa wi tafɔ Ezhipiti tara fɛnnɛ naŋa wi go. ");
INSERT INTO dyi_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","A wi tafɔ wì sigi yan Yawe Yɛnŋɛlɛ làa pye Zhozɛfu wi ni, na wiga kɛɛ le kala na fuun ni, Yawe Yɛnŋɛlɛ li mali yɔn wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Zhozɛfu wi kala làa wi tafɔ Potifari wi ndanla, a wila tunŋgo piin wi kan. A Potifari wì suu tɛgɛ wi go ki go na, maa kɛɛ yaara ti ni fuun ti le wi kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Naa Ezhipiti tara fɛnnɛ naŋa Potifari wìla kaa Zhozɛfu wi tɛgɛ wi go konaa wi kɛɛ yaara ti go na, a Yawe Yɛnŋɛlɛ lì si duwaw wi go yaara ti ni fuun ti na Zhozɛfu wi kala na. Yawe Yɛnŋɛlɛ làa duwaw wi kɛɛ yaara ti ni fuun ti na, nda tìla pye wa ca to naa nda tìla pye wa kɛɛrɛ ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ki kala na, Potifari wìla wi kɛɛ yaara ti le Zhozɛfu wi kɛɛ, wi sila pye na yaraga ka piin naa, kaawɔ wi yɔn suro liwɛn po. Zhozɛfu wìla pye sara ni, ma yɔn witige na fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Naa wagati wà la kaa toro, a Zhozɛfu wi tafɔ wi jɔ wì si Zhozɛfu wi wele maa yan wi yɛn ma yɔn fɔ jɛŋgɛ. A jɛlɛ wì suu pye fɔ: «Pan ma sinlɛ na ni.» ");
INSERT INTO dyi_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","A Zhozɛfu wì si je mɛɛ wi tafɔ wi jɔ wi pye fɔ: «Wele, na tafɔ wùu kɛɛ yaara ti ni fuun ti le na kɛɛ, wi woro na kala la piin laga go ki ni naa. ");
INSERT INTO dyi_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Lere wo wa woro laga go ŋga ki ni ma gbɔgɔ ma wɛ na na. Wii na yɛgɛ kɔn yaraga ka kpɛ na, kaawɔ mboro nuŋgba, katugu ma yɛn wi jɔ. Mɛlɛ mbee ki kapege gbɔgɔ ŋga ki pye mbe kapege pye Yɛnŋɛlɛ na?» ");
INSERT INTO dyi_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Konaa ki ni fuun, wìla koro naga yuun Zhozɛfu wi ni pilige pyew. Ɛɛn fɔ, Zhozɛfu wi sila logo wi yeri mbe yɛnlɛ mbe sinlɛ wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pilige ka, a Zhozɛfu wì si ye wa go mboo tunŋgo ki pye. Kìla yala go woolo wa sila pye wa go. ");
INSERT INTO dyi_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kì kaa pye ma, a jɛlɛ wì si Zhozɛfu wi yigi wi derigbɔgɔ ki na, ma suu pye fɔ: «Pan ma sinlɛ na ni.» A Zhozɛfu wì suu derigbɔgɔ ki wɔ maga yaga wi kɛɛ, mɛɛ fe ma yiri wa funwa na. ");
INSERT INTO dyi_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Naa jɛlɛ wìla kaa ki yan Zhozɛfu wìla wi derigbɔgɔ ki yaga wi kɛɛ, ma fe ma yiri wa funwa na, ");
INSERT INTO dyi_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a wì si gbele maa go tunmbyeele pe yeri, mɛɛ pe pye fɔ: «Ye wele, na pɔlɔ wì pan ki Eburuye naŋa ŋa wi ni laga, wi ta wila jɛɛlɛ kala piin we ni. Wì pan mbe sinlɛ na ni, ɛɛn fɔ, a mi nɛɛ gbele ŋgbanga na sagafɔ jaa. ");
INSERT INTO dyi_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Naa wì kaa ki yan mila gbele ŋgbanga na yinri, a wì suu derigbɔgɔ ki yaga na na tanla, mɛɛ fe ma yiri wa funwa na.» ");
INSERT INTO dyi_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","A jɛlɛ wì si Zhozɛfu wi derigbɔgɔ ki tɛgɛ le wi yɛɛ tanla, fɔ a wi pɔlɔ wì saa sɔngɔrɔ ma pan. ");
INSERT INTO dyi_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","A wì sigi sɛnrɛ nuŋgba ti yo wi pɔlɔ wi kan ma yo fɔ: «Ki Eburuye kulonaŋa ŋa mà pan wi ni we kan, wì pan na kɔrɔgɔ mbe jɛɛlɛ kala pye na ni. ");
INSERT INTO dyi_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Naa mì kaa gbele ŋgbanga ma yeri, a wì suu derigbɔgɔ ki yaga na na tanla, mɛɛ fe ma yiri wa funwa na.» ");
INSERT INTO dyi_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Naa Zhozɛfu wi tafɔ wìla kaa wi jɔ wi sɛnyoro ti logo ma yo fɔ: «Ŋga ko mà kulonaŋa wì pye na na», ");
INSERT INTO dyi_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","a wi nawa pì si ŋgban fɔ jɛŋgɛ. A wì si ti a pè Zhozɛfu wi yigi maa tɔn wa kaso go ŋga wunlunaŋa wìla pye naa kasopiile pe tɔnni ki ni. Kì kaa pye ma, a Zhozɛfu wì si koro wa kaso. ");
INSERT INTO dyi_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yawe Yɛnŋɛlɛ làa pye Zhozɛfu wi ni ma kajɛŋgɛ pye maa kan, ma ti a wi kala lì kaso go ki to wi ndanla. ");
INSERT INTO dyi_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","A kaso go ki to wì si kasopiile sanmbala pe le Zhozɛfu wi kɛɛ. Kala na fuun làa pye na piin wa, Zhozɛfu wo wìla pye nali yɛgɛ sinni. ");
INSERT INTO dyi_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kala na fuun làa pye Zhozɛfu wi kɛɛ na, kaso go ki to wi sila pye na lo la wele naa, katugu Yawe Yɛnŋɛlɛ làa pye Zhozɛfu wi ni, naa kagala ke ni fuun ke yɔngɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ki kagala ke puŋgo na, pilige ka, mbele pe maa Ezhipiti tara wunlunaŋa wi kaan wi maa woo pe to wo naa wi buru wafɛnnɛ to wi ni, pè si kapege pye pe tafɔ Farawɔn wi na, Ezhipiti tara wunlunaŋa we. ");
INSERT INTO dyi_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","A Farawɔn wi nawa pì si ŋgban wi legbɔɔlɔ shyɛn pe ni, mbele pe maa wi kaan wi maa woo pe to wo naa wi buru wafɛnnɛ to we. ");
INSERT INTO dyi_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","A wì si ti a pè pe yigi ma pe le kaso, wa wunlunaŋa wi laga welefɛnnɛ to wi go ki ni, wa laga ŋga pàa Zhozɛfu wi tɔn we. ");
INSERT INTO dyi_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","A laga welefɛnnɛ to wì si pe le Zhozɛfu wi kɛɛ wila wele pe na, wo ŋa wìla pye na pe kala li yɔngɔ pe kan we. Pàa wagati wa pye wa kaso. ");
INSERT INTO dyi_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pilige ka, yembinɛ la ni, mbele pe maa Ezhipiti tara wunlunaŋa wi kaan wi maa woo pe to wo naa wi buru wafɛnnɛ to wi ni, pe shyɛn pè si wɔɔnrɔ wɔnlɔ ma pe ta wa kaso, pe ni fuun naa pe wɔɔnrɔ, a tì kɔrɔ wì pye wi yɛ wi yɛ. ");
INSERT INTO dyi_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ki goto pinliwɛ pi ni, naa Zhozɛfu wìla kaa pan mbe pe yan, a wì si pe yan pè yɛrɛ san. ");
INSERT INTO dyi_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kì kaa pye ma, Farawɔn wi legbɔɔlɔ mbele pàa pye wi ni wa kaso, wa wi tafɔ wi go, a wì si pe yewe ma yo fɔ: «Yiŋgi na, a yè si ye yɛrɛ ti san nala?» ");
INSERT INTO dyi_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","A pè suu yɔn sogo ma yo fɔ: «Wè wɔɔnrɔ wɔnlɔ, lere kpɛ woro laga mberi kɔrɔ wi yo we kan.» A Zhozɛfu wì si pe pye fɔ: «Yɛnŋɛlɛ lo li maa wɔɔnrɔ ti kɔrɔ wi yuun. Ye ye wɔɔnrɔ ti yɛgɛ yo na kan mbe wele.» ");
INSERT INTO dyi_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mbele pe maa wunlunaŋa wi kaan wi maa woo pe to wì suu wɔɔnrɔ ti yɛgɛ yo Zhozɛfu wi kan, ma yo fɔ: «Wa na wɔɔnrɔ ti ni, mì ɛrɛzɛn tirige ka yan na yɛɛ yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Njere taanri la pye ki tirige ki na. Naa kìla kaa fun, a kì si fyɛnwɛ mɛɛ sɛ, a ki ɛrɛzɛn shashara pire tì pe. ");
INSERT INTO dyi_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Farawɔn wi wɔjɛnnɛ làa pye na kɛɛ, a mì si ɛrɛzɛn pire ta cɔ mari tɔnmɔ pi yinwi wa wɔjɛnnɛ li ni, mali kan wi yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","A Zhozɛfu wì suu pye fɔ: «Ma wɔɔnrɔ ti kɔrɔ wi ŋa! Njere taanri nda mà yan to yɛn ma taanla piliye taanri ni. ");
INSERT INTO dyi_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mbe wɔ nala wo ni, kì koro piliye taanri naa, pa Farawɔn wi yaa ma yirige mbɔɔn tɛgɛ cɛnsagbɔgɔ na, wa ma tunŋgo lɛgɛ ki ni. Kona ma mbe ya mbaa Farawɔn wi wɔtɔnmɔ pi kaan wi yeri naa, paa yɛgɛ ŋga na màa pye naga piin faa we. ");
INSERT INTO dyi_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ɛɛn fɔ, na maga yɛyinŋge ta sanga ŋa ni, maga ka fɛgɛ na na, mila ma yɛnri, ma kajɛŋgɛ pye na kan, mala sɛnrɛ yo Farawɔn wi tanla, ma ti mbe yiri laga ki kaso ŋa wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Katugu pàa na yigi fanŋga na ma yiri wa Eburuye tara ma pan na ni. Lagamɛ mii si yaraga ka pye ŋga ki daga kaso yewe ni.» ");
INSERT INTO dyi_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Naa buru wafɛnnɛ to wìla kaa ki yan wɔɔnrɔ ti kɔrɔ wi yɛn ma yɔn, a wì si Zhozɛfu wi pye fɔ: «Mi fun, wa na wɔɔnrɔ ti ni, kanjara taanri la pye wa na go na buru fuwe ni. ");
INSERT INTO dyi_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Wa kanja gona wogo ki ni, buru cɛnlɛ pyew ŋa pe ma wa wi yɛn ma Farawɔn wi ndanla, wà la pye wa ki ni. Ɛɛn fɔ, a sannjɛrɛ tì si pan naa yoli wa kanja ki ni na go na.» ");
INSERT INTO dyi_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","A Zhozɛfu wì suu pye fɔ: «Ma wɔɔnrɔ ti kɔrɔ wi ŋa! Kanjara taanri to yɛn ma taanla piliye taanri ni. ");
INSERT INTO dyi_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mbe wɔ nala wo ni, kì koro piliye taanri naa, pa Farawɔn wi yaa ma yirige mbɔɔn go ki kɔw, mbɔɔn gboo wi to tige na. Sannjɛrɛ ti yaa pan mbɔɔn wire kara ti yɔli.» ");
INSERT INTO dyi_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Wɔɔnrɔ ti wɔnlɔŋgɔlɔ, ki piliye taanri wogo ki na, a kì si yala Farawɔn wi sege yɛfiile fɛti wà gbɔn. A wì si sɔgɔlɔ gbɔlɔ sɔgɔ wi legbɔɔlɔ pe ni fuun pe kan, mɛɛ mbele pe maa wi kaan wi maa woo pe to wo naa wi buru wafɛnnɛ to wi ni pe yirige ma pe wɔ wa kaso wi ni wi legbɔɔlɔ pe yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","A Farawɔn wì si mbele pe maa wi kaan wi maa woo pe to wi tɛgɛ naa wa wi tunŋgo lɛgɛ ki na, wi ta wila wi wɔtɔnmɔ pi kaan wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ɛɛn fɔ, a wì si ti a pè buru wafɛnnɛ to wi to tige na, paa yɛgɛ ŋga na Zhozɛfu wìla wɔɔnrɔ ti kɔrɔ wi yo we. ");
INSERT INTO dyi_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Konaa ki ni fuun, mbele pe maa Farawɔn wi kaan wi maa woo pe to wi sila nawa to Zhozɛfu wi na, wìla fɛgɛ wi na. ");
INSERT INTO dyi_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Naa yɛlɛ shyɛn là kaa toro, a Farawɔn wì si wɔɔnrɔ wɔnlɔ maa yɛɛ yan wì yere le Nili gbaan wi tanla. ");
INSERT INTO dyi_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A wì si nanɛɛlɛ kɔlɔshyɛn pele yan pè yiri wa gbaan wi ni ma tugbɔlɔ ma yɔnyɔn, nɛɛ nii wa gbaan yɔn laŋgɔrɔgɔ ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ko puŋgo na, a nanɛɛlɛ kɔlɔshyɛn pèle si yiri naa wa gbaan wi ni mbele pe puŋgo na; pàa pye ma cɔgɔ cɔgɔ ma tijanga. A pè si saa yere le koŋgbanmbala pe tanla le gbaan wi koŋgo na. ");
INSERT INTO dyi_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nanɛɛlɛ mbele pàa pye ma cɔgɔ cɔgɔ ma tijanga, pè si nanɛɛlɛ mbele pàa tugbɔlɔ ma yɔnyɔn pe ka. A Farawɔn wì si yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A wì si nuru naa ma wɔnlɔ mɛɛ wɔɔnrɔ shyɛn woro wɔnlɔ, ma yarilire sheshegele kɔlɔshyɛn yan kè yiri tinnɛ nuŋgba na, kàa pire le jɛŋgɛ ma yɔnyɔn. ");
INSERT INTO dyi_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ko puŋgo na, a sheshegele kɔlɔshyɛn kèle si yiri wa koŋgbanŋgala ke puŋgo na. Ke sila pye pire ni, a yɔnlɔ yirisaga tifɛlɛgɛ kì ke waga. ");
INSERT INTO dyi_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Sheshegele ŋgele ke sila pye pire ni, a kè si ŋgele kàa sɛ ma pire le jɛŋgɛ ke yɔli. A Farawɔn wì si yɛn mɛɛ ki yan wɔɔnrɔ wì wɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Naa laga kìla kaa laga, a Farawɔn wi jatere wì si piri wi na. A wì si Ezhipiti tara jɛlɛfɛnnɛ poro naa kajɛnmbɛlɛ pe ni fuun pe yeri, mɛɛ wi wɔɔnrɔ ti yɛgɛ yo pe kan. Ɛɛn fɔ, lere kpɛ sila ya mberi kɔrɔ wi yo wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kì kaa pye ma, mbele pe maa Farawɔn wi kaan wi maa woo pe to wì si sɛnrɛ ti lɛ, ma sho fɔ: «Wunlunaŋa, mi yɛn na nawa tuun na kapere ti na nala. ");
INSERT INTO dyi_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pilige ka, wunlunaŋa yàa nawa ŋgban woro mbele ye tunmbyeele we ni. A yè si ti a pè mi naa buru wafɛnnɛ to wi ni we le kaso, wa laga welefɛnnɛ to wi go. ");
INSERT INTO dyi_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","A we ni fuun shyɛn wè si wɔɔnrɔ wɔnlɔ yembinɛ la ni. Kɔrɔ la pye we ni fuun shyɛn we wɔɔnrɔ ti na. ");
INSERT INTO dyi_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Eburuye lefɔnŋɔ wà la pye wa we ni, wìla pye laga welefɛnnɛ to wo kulonaŋa. Wàa we wɔɔnrɔ ti yɛgɛ yo maa kan, a wì siri kɔrɔ wi yo ma we kan, we ni fuun nuŋgba nuŋgba naa we wɔɔnrɔ ti kɔrɔ. ");
INSERT INTO dyi_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ki kagala kàa pye ma cɛ paa yɛgɛ ŋga na wìla ki yɛgɛ yo we kan we. Farawɔn, a màla tɛgɛ wa na tunŋgo lɛgɛ ki na, mɛɛ ti a pè buru wafɛnnɛ to wo to tige na.» ");
INSERT INTO dyi_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kì pye ma, a Farawɔn wì si lere tun, a pè saa Zhozɛfu wi yeri. A pè si fyɛɛlɛ, maa yirige, maa wɔ wa kaso, mɛɛ wi go ki kulu. A wì si yaripɔrɔ ta yɛgɛ le, mɛɛ kari wa Farawɔn wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","A Farawɔn wì suu pye fɔ: «Mì wɔɔnrɔ wɔnlɔ, lere kpɛ si ya mberi kɔrɔ wi yo na kan. Ɛɛn fɔ, mìgi logo ma yo na paga wɔɔnrɔ yɛgɛ yo ma kan, ma ma ya mari kɔrɔ wi yo.» ");
INSERT INTO dyi_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","A Zhozɛfu wì suu yɔn sogo ma yo fɔ: «Wunlunaŋa, mi ma mi yaa wɔɔnrɔ ti kɔrɔ wi yo, ɛɛn fɔ, Yɛnŋɛlɛ lo li yaa wɔɔnrɔ ti kɔrɔ jɛnŋɛ wi yo Farawɔn ma kan.» ");
INSERT INTO dyi_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","A Farawɔn wì si Zhozɛfu wi pye fɔ: «Wa na wɔɔnrɔ ti ni, mìla ki yan mi yɛn ma yere le Nili gbaan wi yɔn na. ");
INSERT INTO dyi_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","A mì si nanɛɛlɛ kɔlɔshyɛn pele yan pè yiri wa gbaan wi ni, ma tugbɔlɔ ma yɔnyɔn, nɛɛ nii wa gbaan yɔn laŋgɔrɔgɔ ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ko puŋgo na, a nanɛɛlɛ kɔlɔshyɛn pèle si yiri naa wa gbaan wi ni mbele pe puŋgo na. Pàa pye ma cɔgɔ cɔgɔ jɛŋgɛ ma tijanga. Mi fa nɛrɛ ta yan ti tijanga laga Ezhipiti tara paa ki woro nda ti yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nanɛɛlɛ mbele pè cɔgɔ cɔgɔ ma tijanga, a pè si nanɛɛlɛ koŋgbanmbala kɔlɔshyɛn mbele pè tugbɔlɔ pe ka. ");
INSERT INTO dyi_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Naa pàa kaa pe yɔli, lere sila ki jɛn mbe yo pàa pe yɔli, katugu pàa pye ma cɔgɔ cɔgɔ paa yɛgɛ ŋga na pàa pye faa we. A mì si yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ko puŋgo na, a mì si wɔɔnrɔ ta wɔnlɔ naa ma yarilire sheshegele kɔlɔshyɛn yan kè yiri tinnɛ nuŋgba na, kàa pire le jɛŋgɛ ma yɔnyɔn. ");
INSERT INTO dyi_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","A mì si nuru naa ma sheshegele kɔlɔshyɛn kele yan kè yiri koro puŋgo na, ke sila pire le, a yɔnlɔ yirisaga tifɛlɛgɛ kì ke waga. ");
INSERT INTO dyi_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Sheshegele ŋgele ke sila pye pire ni, kè si sheshegele kɔlɔshyɛn ŋgele kè pire le ma yɔnyɔn ke yɔli. Mìgi wɔɔnrɔ ti yɛgɛ yo jɛlɛfɛnnɛ pe kan, wa kpɛ si ya mberi kɔrɔ wi yo na kan pe ni.» ");
INSERT INTO dyi_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","A Zhozɛfu wì si Farawɔn wi pye fɔ: «Wunlunaŋa, ma wɔɔnrɔ ti shyɛn ti kɔrɔ wi yɛn nuŋgba. Yɛnŋɛlɛ li yɛn na jaa mbe kala na pye, loli na lì naga wunlunaŋa ma na. ");
INSERT INTO dyi_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nanɛɛlɛ kɔlɔshyɛn mbele mà yan pè tugbɔlɔ ma yɔnyɔn, poro yɛn paa yɛgɛlɛ kɔlɔshyɛn yɛn. Sheshegele kɔlɔshyɛn ŋgele kè pire le ma yɔnyɔn ke yɛn paa yɛgɛlɛ kɔlɔshyɛn yɛn. Ki kala na, wɔɔnrɔ nuŋgba ri. ");
INSERT INTO dyi_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nanɛɛlɛ kɔlɔshyɛn mbele pè yiri wa koŋgbanmbala pe puŋgo na, ma cɔgɔ cɔgɔ ma tijanga, poro yɛn paa yɛgɛlɛ kɔlɔshyɛn yɛn. Sheshegele ŋgele ke woro pire ni, a yɔnlɔ yirisaga tifɛlɛgɛ kì ke waga, koro yɛn naga nari fɔ fuŋgo yaa to yɛgɛlɛ kɔlɔshyɛn ni. ");
INSERT INTO dyi_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ki yɛn ma, paa yɛgɛ ŋga na mìgi yo Farawɔn ma kan. Yɛnŋɛlɛ laa jaa mbe kala na pye loli na lì naga ma na Farawɔn. ");
INSERT INTO dyi_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Wele, yɛgɛlɛ kɔlɔshyɛn ŋgele kaa paan, yarilire ti yaa yɔn ke ni jɛŋgɛ laga Ezhipiti tara ti lagapyew. ");
INSERT INTO dyi_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ko puŋgo na, fuŋgo gbɔgɔ yaa to yɛgɛlɛ kɔlɔshyɛn ni mbe taga yaakara yɔn yɛgɛlɛ ŋgele kè toro ke na. Lere se ka nawa to yarilire yɔn yɛgɛlɛ ke na laga Ezhipiti tara ti ni. Fuŋgo gbɔgɔ ki yaa ka jɔlɔgɔ wa tara woolo pe na. ");
INSERT INTO dyi_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ki fuŋgo ki yaa ka ŋgban jɛŋgɛ, fɔ leele pe se kaga jɛn yarilire tìla yɔn laga tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Wunlunaŋa, maga ki yan mà wɔɔnrɔ ti wɔnlɔ wɔnlɔsaga shyɛn, a tì yiri ti yɛɛ kɔrɔgɔ, ko ki naga ma yo Yɛnŋɛlɛ lìgi kala li kɔn mali tɛgɛ, li se mɔ li yaa ki kala li pye mbeli yɔn fili. ");
INSERT INTO dyi_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ki kala na, yiŋgɔ, wunlunaŋa, naŋa wa lagaja, ŋa wi yɛn tijinliwɛ fɔ naa kajɛnŋɛ, maa tɛgɛ Ezhipiti tara ti go na. ");
INSERT INTO dyi_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Wunlunaŋa, maga kala li pye; mbe taga wa ko na, ma fanŋga fɛnnɛ tɛgɛtɛgɛ tara ti go na. Paa kɛɛrɛ ti yarilire ti walisaga kaŋgurugo wogo ki shoo yaakara yɔn yɛgɛlɛ kɔlɔshyɛn ke ni laga Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Yaakara yɔn yɛgɛlɛ ŋgele ke yɛn na paan, paa ki yarilire ti ni fuun ti gbogolo ti yɛɛ na. Paa bile wi gbogolo, paa wi teri bondoolo pe ni cara ti ni wunlunaŋa wi mɛgɛ na, paa ti kɔrɔsi. ");
INSERT INTO dyi_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ko yarilire to ti yaa pye yɛgɛlɛ kɔlɔshyɛn fuŋgo ŋga ki yaa to laga Ezhipiti tara ki yɛtɛgɛwɛ we, jaŋgo tara woolo paga ka ku fuŋgo ki kɛɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kona, a ki sɛnrɛ tì si tanla Farawɔn wo naa wi legbɔɔlɔ pe ni fuun pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","A Farawɔn wì si pe pye fɔ: «Ki naŋa ŋa, Yɛnŋɛlɛ li yinnɛ li yɛn wi ni. Woro mbe ya mbe lere wa ta paa ki naŋa ŋa wi yɛn?» ");
INSERT INTO dyi_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","A Farawɔn wì si Zhozɛfu wi pye fɔ: «Kì kaa pye Yɛnŋɛlɛ lìgi kagala ke ni fuun ke naga mboro na, lere wo wa woro wa, ŋa wi yɛn tijinliwɛ fɔ naa kajɛnŋɛ mbe wɛ mboro na. ");
INSERT INTO dyi_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Mboro mi yaa tɛgɛ na wunluwɔ pi go na, na tara woolo pe yaa la nuru ma yeri. Na wunluwɔ mɛgɛ ko nuŋgba ki yaa ti mbe wɛ ma na.» ");
INSERT INTO dyi_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","A Farawɔn wì suu pye fɔ: «Wele, mì fanŋga kan ma yeri Ezhipiti tara ti ni fuun ti go na.» ");
INSERT INTO dyi_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","A Farawɔn wì suu wunluwɔ vegeŋɛ wi wɔ wa wi yombɛlɛ li na, maa le wa Zhozɛfu wi yombɛlɛ li na, mɛɛ ti a pè lɛn jese yaripɔrɔ tiyɔnrɔ le wi kan, ma tɛ yɔngɔwɔ le wa wi yɔlɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A Farawɔn wì si ti a wì ye wa wi wotoro ŋa wi ma taga wunluwɔ woo wi na wi ni. A leele pe nɛɛ jɔrɔgi wa wi yɛgɛ na yuun fɔ: «Ye kanŋguuro kan, ye kanŋguuro kan.» Pa Farawɔn wìla Zhozɛfu wi tɛgɛ Ezhipiti tara ti ni fuun ti go na yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","A Farawɔn wì si Zhozɛfu wi pye naa fɔ: «Muwi mi yɛn wunlunaŋa we, ɛɛn fɔ, lere se ya mbe kala la pye laga Ezhipiti tara ti ni na mboro sigi konɔ kan wi yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","A Farawɔn wì si Zhozɛfu wi mɛgɛ taga naa yinri Safinati Paneya, mɛɛ jɛlɛ kan wi yeri, pàa pye naa yinri Asenati. Ɔni ca saraga wɔfɔ Potifera wo sumborombyɔ lawi. Kì kaa pye ma, a Zhozɛfu wì si cɛn Ezhipiti tara ti ni fuun ti go na. ");
INSERT INTO dyi_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Zhozɛfu wìla ta yɛlɛ nafa ma yiri kɛ, a pè si kari wi ni wa Farawɔn, Ezhipiti tara wunlunaŋa wi yɛgɛ sɔgɔwɔ. A wì si yiri le Farawɔn wi yɛgɛ sɔgɔwɔ mɛɛ saa na Ezhipiti tara lagapyew ki yanri. ");
INSERT INTO dyi_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Yaakara yɔn yɛgɛlɛ kɔlɔshyɛn ke ni, tara ti yarilire tìla yɔn fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Zhozɛfu wìla ki yɛgɛlɛ kɔlɔshyɛn ke yarilire nda fuun pe mbaa tɛgɛ ti gbogolo wa Ezhipiti tara ti ni. A wì siri gbogolo gbogolo cara ti ni ma toro. Kɛɛrɛ nda ka pye mbe ca ŋga fuun maga, pa wi ma ko yarilire to gbogolo wa ko ca ko ni. ");
INSERT INTO dyi_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Zhozɛfu wìla yarilire ti gbogolo a tì lɛgɛ jɛŋgɛ paa kɔgɔje yɔn taambugɔ ki yɛn. Tìla lɛgɛ ma toro, fɔ a pèri jinriwɛ pi yaga, katugu pe saa ya mbaa ti jinri naa. ");
INSERT INTO dyi_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sanni fuŋgo to yɛgɛlɛ ke sa gbɔn, Ɔni ca saraga wɔfɔ Potifera wi sumborombyɔ Asenati wìla pinambiile shyɛn se wi pɔlɔ Zhozɛfu wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","A Zhozɛfu wì suu pinambyɔ koŋgbanŋa wi mɛgɛ taga naa yinri Manase, katugu wìla yo fɔ: «Yɛnŋɛlɛ lì ti a mì fɛgɛ na tere ti ni fuun naa na lagawa na go woolo pe na ki na.» ");
INSERT INTO dyi_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A wì suu pinambyɔ shyɛn woo wi mɛgɛ taga naa yinri Efirayimu, ma yo fɔ: «Yɛnŋɛlɛ lìlan pye sevɔ laga tara nda mìla pye na jɔlɔ ti ni.» ");
INSERT INTO dyi_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Wa Ezhipiti tara, yarilire tìla yɔn yɛgɛlɛ kɔlɔshyɛn ŋgele ni kè si toro. ");
INSERT INTO dyi_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kona, a fuŋgo to yɛgɛlɛ kɔlɔshyɛn kè si gbɔn paa yɛgɛ ŋga na Zhozɛfu wìla ki yo we. Fuŋgo kìla to tara sannda pyew ti ni, ɛɛn fɔ, wa Ezhipiti tara ti lagapyew, yaakara la pye wa. ");
INSERT INTO dyi_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Naa fuŋgo kìla kaa to Ezhipiti tara woolo pe ni fuun pe na fun, a pè si saa na gbele wa Farawɔn wi yeri na yaakara jaa. A Farawɔn wì si pe pye fɔ: «Yaa kee Zhozɛfu wi kɔrɔgɔ, wiga ŋga yo ye kan, ye ko pye.» ");
INSERT INTO dyi_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Fuŋgo kìla ŋgban wa Ezhipiti tara ti lagapyew. A Zhozɛfu wì si bondo tugbɔmbɔlɔ pe yɛngɛlɛ nɛɛ yarilire ti pɛrɛ Ezhipiti tara woolo pe yeri. A fuŋgo ki nɛɛ ŋgbanni na seregi wa Ezhipiti tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tara pyew ti woolo pàa pye na paan wa Ezhipiti tara na bile loo Zhozɛfu wi yeri; katugu fuŋgo kìla ŋgban tara pyew ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kona, a Zhakɔbu wì sigi logo ma yo bile la pye wa Ezhipiti tara ti ni. Kì kaa pye ma, a wì suu pinambiile pe pye fɔ: «Yiŋgi na, a yè si cɛn na ye yɛɛ wele?» ");
INSERT INTO dyi_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","A wì sho fɔ: «Mìgi logo ma yo bile wa yɛn wa Ezhipiti tara. Ye kari ye sa wa lɔ wa we kan, jaŋgo we koro yinwege na, waga ka ku fuŋgo ki kɛɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","A Zhozɛfu wi ndɛɛlɛ kɛ si kari wa Ezhipiti tara sa bile wa lɔ. ");
INSERT INTO dyi_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Zhakɔbu wi sila Zhozɛfu wi jɔnlɔ Bɛnzhamɛ wo pinlɛ pe ni, katugu wìla pye na yuun fɔ: «Mila fyɛ kana kaŋgbanga mbe kaa ta konɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","A Izirayɛli wi pinambiile pè si kari sa bile wa lɔ wa Ezhipiti tara, pàa pinlɛ bile lɔfɛnnɛ pele ni ma kari; katugu fuŋgo kìla pye wa Kana tara fun. ");
INSERT INTO dyi_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Zhozɛfu wo wìla pye Ezhipiti tara ti go na. Wo wìla pye na bile wi pɛrɛ tara woolo pe ni fuun pe yeri. A Zhozɛfu wi ndɛɛlɛ pè si pan ma sogo ma pe yɛrɛ ti jiile wa tara wi yɛgɛ sɔgɔwɔ, maa gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Zhozɛfu wìla wi ndɛɛlɛ pe yan ma pe jɛn, ɛɛn fɔ, wi sila wi yɛɛ naga pe na. Wìla sɛnŋgbanra yo pe ni, ma pe pye fɔ: «Yè yiri se yeri?» A pè suu yɔn sogo ma yo fɔ: «Wè yiri wa Kana tara, wè pan mbe yaakara lɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Zhozɛfu wìla wi ndɛɛlɛ pe jɛn, ɛɛn fɔ, poro sila wi jɛn. ");
INSERT INTO dyi_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","A Zhozɛfu wì si nawa to wɔɔnrɔ nda wìla wɔnlɔ pe kanŋgɔlɔ ti na, mɛɛ pe pye fɔ: «Ye yɛn tara ti kagala koro yewefɛnnɛ. Tara ti fanŋga kì kologo lara nda ni to yè pan mbe wele mbe jɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","A pè suu yɔn sogo ma yo fɔ: «Ayoo, we tafɔ, ma kulonambala pè pan mbe yaakara lɔ win. ");
INSERT INTO dyi_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We ni fuun we yɛn naŋa nuŋgba pinambiile. We yɛn lesinmbele. Woro mbele ma kulonambala, we woro tara ti kagala koro yewefɛnnɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","A Zhozɛfu wì si pe pye fɔ: «Kaselege ma, tara ti fanŋga kì kologo lara nda na to yè pan mbe wele.» ");
INSERT INTO dyi_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","A pè suu yɔn sogo ma yo fɔ: «Woro mbele ma kulonambala, wàa pye to seyɛɛnlɛ kɛ ma yiri shyɛn, naŋa nuŋgba pinambiile, ma yiri wa Kana tara. Ɛɛn fɔ, we ni fuun jɔnlɔ wi yɛn wa we to wi ni nala, nuŋgba sanŋa wo woro go na.» ");
INSERT INTO dyi_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","A Zhozɛfu wì si pe pye fɔ: «Ko mì pye na yuun ye kan fɔ ye yɛn tara ti kagala koro yewefɛnnɛ. ");
INSERT INTO dyi_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Mi yaa ye wa mbe wele yɛgɛ ŋga na ki ŋga: ‹Mbe Farawɔn wi ta go na, ye se yiri laga ki tara nda ti ni fɔ ye ni fuun jɔnlɔ wi sa pan gbɛn. ");
INSERT INTO dyi_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Yè lere nuŋgba wɔ ye yɛɛ ni, yoo tun wi sa ye jɔnlɔ wi lagaja wi pan wi ni. Yoro sanmbala ye yaa koro laga kaso. Mi yaa ye sɛnrɛ ti cancan mbe wele, na kaa pye ti yɛn kaselege. Nakosima mbe Farawɔn wi ta go na, ye yɛn tara ti kagala koro yewefɛnnɛ.› » ");
INSERT INTO dyi_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","A Zhozɛfu wì si ti pè pe ni fuun pe le kaso piliye taanri. ");
INSERT INTO dyi_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Pilige taanri wogo ki na, a Zhozɛfu wì si pe pye fɔ: «Ye ŋga ko pye pa kona ye yaa koro yinwege na, katugu mì Yɛnŋɛlɛ li jɛn. ");
INSERT INTO dyi_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Na kaa pye ye yɛn sinmbele, ye to seyɛnlɛ nuŋgba mbe koro laga kaso, yoro sanmbala ye kari ye sa yarilire ti kan ye go woolo mbele fuŋgo ki yɛn pe na pe yeri. ");
INSERT INTO dyi_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ko puŋgo na, ye sɔngɔrɔ ye pan ye ni fuun jɔnlɔ wi ni laga, jaŋgo mbe ta mbe ye sɛnrɛ ti cancan mbe wele, na kaa pye ti yɛn kaselege, pa kona ye se ku.» A pè si yɛnlɛ ki sɛnrɛ ti na, ");
INSERT INTO dyi_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","nɛɛ ki yuun pe yɛɛ kan fɔ: «Ee, we yɛn kapege pyefɛnnɛ we jɔnlɔ wi kanŋgɔlɔ; katugu wàa wi yan wi jatere wì piri wi na fɔ ma saa toro. A wì we yɛnri ma yo woo yinriwɛ ta, ɛɛn fɔ, we sila yɛnlɛ mbe logo wi yeri. Yiŋgɔ jatere pirindorogo nuŋgba ŋga kìla wi ta, ko cɛnlɛ li yɛn na we taa.» ");
INSERT INTO dyi_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","A Urubɛn wì si sɛnrɛ ti lɛ, mɛɛ pe pye fɔ: «Mìla pye naga yuun ye kan ma yo yaga ka ti we kapegbɔgɔ pye Zhozɛfu wi na. Ɛɛn fɔ, ye sila yɛnlɛ mbe logo na yeri; yiŋgɔ wi kunwɔ pi jɔlɔgɔ ki yɔngɔ yɛn na woo we ni.» ");
INSERT INTO dyi_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Pe sila ki jɛn mbe yo Zhozɛfu wìla pye na pe sɛnrɛ ti nuru, katugu lere la pye poro naa Zhozɛfu pe sɔgɔwɔ na sɛnrɛ ti kanŋgi. ");
INSERT INTO dyi_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","A Zhozɛfu wì si yiri le pe tanla ma saa gbele. Ko puŋgo na, a wì si sɔngɔrɔ ma pan ma para pe ni, mɛɛ ti a pè Simeyɔn wi yigi le pe sɔgɔwɔ maa le kaso pe yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","A Zhozɛfu wì si konɔ kan wi tunmbyeele pe yeri ma yo pe pe kashara ti yinyin bile ni, pe pe ni fuun nuŋgba nuŋgba pe penjara ti lele wa pe kashara ti ni, pe yaakara kan pe yeri pe kondangala li na. A tunmbyeele pè sigi pye ma. ");
INSERT INTO dyi_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","A pè si pe bile kashara ti tagataga pe sofilele pe na, mɛɛ yiri le ma kari. ");
INSERT INTO dyi_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Naa pàa ka saa yere wa pe wɔnlɔsaga mbe wɔnlɔ le, a nuŋgba suu kasha ki yɛngɛ mboo sofile wi kan yaakara ni, mɛɛ wi penjara ti yan wa wi kasha ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A wì suu to seyɛɛnlɛ pe pye fɔ: «Pànla penjara ti sɔngɔrɔ na na. Ti nda laga na kasha ki ni bere.» Kona, a pe sunndo wì si kɔn pe na. A pe nɛɛ pe sunndo kɔngɔ sɛnrɛ ti yuun pe yɛɛ kan na yuun fɔ: «Yiŋgi Yɛnŋɛlɛ lì pye we na yɛɛn?» ");
INSERT INTO dyi_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Naa pàa ka saa gbɔn wa pe to Zhakɔbu wi na wa Kana tara, a pè si kala na fuun làa pe ta li yɛgɛ yo maa kan. ");
INSERT INTO dyi_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","A pè sho fɔ: «Naŋa ŋa wi yɛn tara ti go na, wì sɛnŋgbanra yo we ni ma yo we yɛn tara ti kagala koro yewefɛnnɛ. ");
INSERT INTO dyi_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Wòo yɔn sogo ma yo fɔ: ‹We yɛn lesinmbele, we woro tara ti kagala koro yewefɛnnɛ. ");
INSERT INTO dyi_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Wàa pye to seyɛɛnlɛ kɛ ma yiri shyɛn, naŋa nuŋgba pinambiile. Ɛɛn fɔ, nuŋgba wo woro go na, we ni fuun jɔnlɔ wi yɛn wa we to wi ni nala, wa Kana tara.› ");
INSERT INTO dyi_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kona, a naŋa ŋa wi yɛn tara ti go na, wì si we pye fɔ: ‹Ye wele, mi yaa ki jɛn yɛgɛ ŋga na fɔ ye yɛn lesinmbele ki ŋga. Ye ye to seyɛnlɛ wa yaga laga na tanla, ye kari ye sa bile wa kan ye go woolo mbele fuŋgo ki yɛn pe na pe yeri. ");
INSERT INTO dyi_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ye kari ye sa ye ni fuun jɔnlɔ wi lɛ ye pan wi ni na kan, pa mi yaa ki jɛn kona fɔ ye woro tara ti kagala koro yewefɛnnɛ, ɛɛn fɔ, ye yɛn lesinmbele. Kona mi yaa ye to seyɛnlɛ Simeyɔn wi kan ye yeri, mbe ye yaga yaa loo yaa pɛrɛ laga tara ti ni.› » ");
INSERT INTO dyi_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Naa pàa kaa pe kashara ti nawa yaara ti kanŋga, a pe ni fuun nuŋgba nuŋgba pè si pe penjara ti yan wa pe kashara ti ni. Poro naa pe to wi ni, pàa penjara bɔtɛɛlɛ pe yan, mɛɛ fyɛ fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","A pe to Zhakɔbu wì si pe pye fɔ: «Yànla kan a mìlan pinambiile shyɛn pe la. Mi woro Zhozɛfu ni, mi si woro Simeyɔn ni. Ko yaa jaa mbe Bɛnzhamɛ wo lɛ mbe kari wi ni fun! Ko kagala koro ke ni fuun yɛn na piin mi na.» ");
INSERT INTO dyi_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","A Urubɛn wì suu to wi pye fɔ: «Na mii sɔngɔrɔ mbe pan Bɛnzhamɛ wi ni ma kan, pa mala pinambiile shyɛn pe gbo. Wi le na kɛɛ, mi yaa sɔngɔrɔ mbe pan wi ni ma kan.» ");
INSERT INTO dyi_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","A Zhakɔbu wì si pe pye fɔ: «Na pinambyɔ wi se kari ye ni fyew; katugu wi ndɔ wì ku, wo nuŋgba wì koro. Na kaŋgbanga kaa ta wa ye kondangala li ni, pa ye yaa ti mbe kari kayaŋga ni na lelɛwɛ pi ni wa kuulo tara.» ");
INSERT INTO dyi_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Fuŋgo kìla pye na ŋgbanni na seregi wa Kana tara. ");
INSERT INTO dyi_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Naa Zhakɔbu wi go woolo pàa kaa bile ŋa pàa yiri wa Ezhipiti tara wì ka wì kɔ, a Zhakɔbu wì suu pinambiile pe pye fɔ: «Ye sɔngɔrɔ wa Ezhipiti tara ye sa yaakara ta lɔ wa we kan.» ");
INSERT INTO dyi_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","A Zhuda wì suu yɔn sogo ma yo fɔ: «Ki naŋa wìgi yo maga ŋgban we ni, ma yo waga ka sɔngɔrɔ sa yere wi yɛgɛ sɔgɔwɔ, na we jɔnlɔ wi woro we ni. ");
INSERT INTO dyi_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Na kiga pye ma yaa Bɛnzhamɛ wi yaga wi pinlɛ we ni, pa we yaa kari sa yaakara ta lɔ wa ma kan. ");
INSERT INTO dyi_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ɛɛn fɔ, na kiga pye ma se yɛnlɛ ki na Bɛnzhamɛ wi pinlɛ we ni, we se kari wa, katugu ki naŋa wì we pye ma yo waga ka sɔngɔrɔ sa yere wi yɛgɛ sɔgɔwɔ, na we jɔnlɔ wi woro we ni.» ");
INSERT INTO dyi_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kona, a Izirayɛli wì si pe pye fɔ: «Yiŋgi na, a yè si kapege pye na na maga yo ki naŋa wi kan ma yo jɔnlɔ yɛn laga ye yeri naa?» ");
INSERT INTO dyi_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","A pè suu yɔn sogo ma yo fɔ: «Ki naŋa wì we yewe jɛŋgɛ woro naa we go woolo we wogo ki na, ma yo fɔ: ‹Ye to wi yɛn yinwege na le? Jɔnlɔ wa yɛn wa ye yeri naa le?› A wè suu yɔn sogo ma yala yewige ŋga wìla we yewe ki ni. We mbaa ki jɛn mɛlɛ fɔ wi yaa we pye mbe yo we kari we jɔnlɔ wi ni wa Ezhipiti tara?» ");
INSERT INTO dyi_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","A Zhuda wì suu to Izirayɛli wi pye fɔ: «Lefɔnmbile li yaga li pinlɛ na ni, we ta we yiri we kari, kiga pye ma we yaa koro yinwege na, we se ku, woro naa mboro ni, konaa we piile pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mi yaa yere wi go kala li ni, maa wi wele na yeri. Na mii sɔngɔrɔ mbe pan wi ni ma kan, na mii si pan mboo tɛgɛ na ma yɛgɛ sɔgɔwɔ, mi yaa pye kapege pyefɔ ma na sanga pyew. ");
INSERT INTO dyi_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ndɛɛ ki pye wee ja mɔlɔ, anmɛ we karisaga shyɛn ko pye makɔ ma sɔngɔrɔ ma pan.» ");
INSERT INTO dyi_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","A pe to Izirayɛli wì si pe pye fɔ: «Kì kaa pye yɛɛn, ye ŋga ko pye: ‹Ye tara ti yarijɛndɛ ta lɛ yeri le wa ye tuguro ti ni, ye sari kan ki naŋa wi yeri paa yarikanga yɛn. Ye tige tɔnmɔ nuwɔ taan pa lɛ jɛnri, naa timuwɛ nuwɔ taan ni, naa nuwɔ taanyaara nda pe yinri miiri ta ni, naa sɛnrɛgɛ jɛnri ni, naa pisitashi tige pire ni, konaa amandi tige pire ta ni. ");
INSERT INTO dyi_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ye sɔngɔrɔsaga, yàa ye kashara ti yɛngɛlɛ ma penjara nda yan wa, yeri lɛ. Kana ki mbe ya pye lere wa wìla wa ma la mari le wa. Ye penjara shyɛn woro lɛ fun. ");
INSERT INTO dyi_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Koni ye ye jɔnlɔ wi lɛ ye sɔngɔrɔ wa ki naŋa wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Yɛnŋɛlɛ na yawa pi ni fuun fɔ li ti ki naŋa wi ye yinriwɛ ta, wi ye to seyɛnlɛ Simeyɔn wo naa Bɛnzhamɛ pe yaga pe sɔngɔrɔ pe pan ye ni laga. Mi wo na, na mbanla pinambiile pe la, mbe pe la.› » ");
INSERT INTO dyi_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","A pè si yarikanra ti lɛ, konaa penjara tɛgɛsaga shyɛn ni, mɛɛ kari pe jɔnlɔ Bɛnzhamɛ wi ni wa Ezhipiti tara, ma saa yere Zhozɛfu wi yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Naa Zhozɛfu wìla kaa Bɛnzhamɛ wi yan pe ni, a wì si ŋa wìla pye wi go ki go na wi pye fɔ: «Ki nambala mbele pe lɛ ma kari pe ni wa na go. Ma yaayogo ka yigi maga gbo, maga kan pege sɔgɔ; katugu ki nambala mbele pe yaa li na ni yɔnlɔfugo na.» ");
INSERT INTO dyi_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","A ki naŋa wì si tanga Zhozɛfu wi sɛnyoro ti na, mɛɛ pe lɛ ma kari pe ni wa Zhozɛfu wi go. ");
INSERT INTO dyi_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Naa pàa kaa ye pe ni wa Zhozɛfu wi go, a pè si fyɛ ma sho fɔ: «Penjara nda wàa yan pè le wa we kashara ti ni we tangala koŋgbanna li na, to kala na pè ye we ni lagamɛ. Pè ti wè ye laga, mbe ta mbe to we na, mbe we yigi, mbe we pye kulolo, mbe we sofilele pe shɔ we yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Pe yesanga wi ni wa go, a pè si fulo ŋa wìla pye Zhozɛfu wi go ki go na wi tanla wa yeyɔngɔ ki na, mɛɛ para wi ni, ");
INSERT INTO dyi_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","maa pye fɔ: «Ma yɛɛ yaga we tafɔ, wàa keli ma pan laga pansaga nuŋgba ma yaakara lɔ. ");
INSERT INTO dyi_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","We sɔngɔrɔsaga, naa wàa ka saa yere wa wɔnlɔsaga mbe wɔnlɔ le, a wè si we kashara ti yɛngɛlɛ, we ni fuun nuŋgba nuŋgba wè si we penjara ti yan wa ti ni, ma yala wàa lɔ nda ni ti yɔn ki ni. Wè sɔngɔrɔ ma pan ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Wè pan penjara ta yɛgɛ ni naa mbe yaakara ta lɔ. Wee jɛn ambɔ wìla we penjara ti sɔngɔrɔ mari le wa we kashara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","A naŋa wì si pe pye fɔ: «Ye cɛn yɛw, yaga ka fyɛ. Ye Yɛnŋɛlɛ le, lo na li yɛn ye to wi Yɛnŋɛlɛ le, lo lì penjagbɔrɔ le ye kan wa ye kashara ti ni. Ye penjara tìla kan na yeri.» A wì si ti a pè Simeyɔn wi wɔ ma pan wi ni pe kan. ");
INSERT INTO dyi_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","A ki naŋa wì si pe pye a pè ye wa Zhozɛfu wi go, mɛɛ pan tɔnmɔ ni pe kan, a pè pe tɔɔrɔ ti jogo, mɛɛ yaakara kan pe sofilele pe yeri. ");
INSERT INTO dyi_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","A pè si pe yarikanra ti gbɛgɛlɛ na Zhozɛfu wi singi wi pan yɔnlɔfugo na; katugu pàa ki yo pe kan ma yo pe yaa pinlɛ mbe li Zhozɛfu wi ni wa wi go. ");
INSERT INTO dyi_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Naa Zhozɛfu wìla kaa pan ma ye wa go, a pè si yarikanra nda pàa pan ti kan wi yeri, mɛɛ sogo ma pe yɛɛrɛ ti jiile wa tara wi yɛgɛ sɔgɔwɔ maa gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","A Zhozɛfu wì si pe yewe na kaa pye pe yɛn ŋgbaanla, mɛɛ pe pye fɔ: «Ye to lelɛɛ ŋa yàa wi sɛnrɛ yo na kan wi wa ŋgbaan le? Wi yɛn wa go na bere?» ");
INSERT INTO dyi_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","A pè suu yɔn sogo ma yo fɔ: «Ma kulonaŋa, we to we, wi wa ŋgbaan, wi si yɛn go na bere.» A pè si fɔli ma pe yɛrɛ ti sogo jɛŋgɛ maa gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","A Zhozɛfu wì suu yɛgɛ ki yirige ma wele, mɛɛ wi jɔnlɔ Bɛnzhamɛ wi yan, wo ŋa wìla pye wi ni nɔ nuŋgba we. A wì si pe yewe ma yo fɔ: «Ye puŋgo jɔnlɔ ŋa yàa wi sɛnrɛ yo na kan wowi ŋa le?» A wì sho naa fɔ: «Yɛnŋɛlɛ sa yinmɛ tirige ma na, na pinambyɔ!» ");
INSERT INTO dyi_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Naa Zhozɛfu wìla kaa wi jɔnlɔ wi yan, wi la ŋga kìla wi yigi ki kala na, a wi wire tì si tanga shɔɔn wi na, a wi nɛɛ jaa mbe gbele, mɛɛ fyɛɛlɛ ma ye yumbyɔ wa ni ma saa yanli. ");
INSERT INTO dyi_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Naa wìla kaa wi yɛgɛ ki jogo, a wì si sɔngɔrɔ ma pan maga kun wi yɛɛ ni, mɛɛ wi tunmbyeele pe pye ma yo pe yaakara ti yɛɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","A pè si Zhozɛfu wi yaakara ti kan wi yeri wi yɛ, maa to seyɛɛnlɛ pe woro kan pe yeri pe yɛ, ma Ezhipiti tara fɛnnɛ mbele pàa pye na nii wa wi go pe woro kan pe yeri fun pe yɛ, katugu Ezhipiti tara fɛnnɛ pe sila pye na pinlɛlɛ mbaa nii Eburuye pe ni. Ezhipiti tara fɛnnɛ pe yarifugo layi. ");
INSERT INTO dyi_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","A Zhozɛfu wi to seyɛɛnlɛ pè si cɛn wi yɛgɛ sɔgɔwɔ, maga lɛ lɛrɛfɔ wi na, fɔ ma saa gbɔn jɔnlɔfɔ wi na ma yala pe lelɛwɛ pi ni. Kìla pe pari, a pe nɛɛ pe yɛɛ wele. ");
INSERT INTO dyi_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","A Zhozɛfu wì si ti a pè yaakara nda tìla pye le wi yɛgɛ sɔgɔwɔ ta wɔ pe kan. Bɛnzhamɛ wo la tasaga kaŋgurugo ta ma wɛ wi to seyɛɛnlɛ pe ni fuun nuŋgba nuŋgba pe woro ti na. A pè si wɔ ma tin nɛɛ yɔgɔri wi ni ja. ");
INSERT INTO dyi_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ko puŋgo na, a Zhozɛfu wì sigi yo ŋa wìla pye wi go ki go na wi kan fɔ: «Ki nambala mbele pe kashara ti lele mari yinyin jɛŋgɛ yarilire ta ni, mbe yala pe mbe ya nda lɛ ti ni. Ma si pe ni fuun nuŋgba nuŋgba pe penjara ti sɔngɔrɔ mari le wa pe kashara ti nawa le yɔn na. ");
INSERT INTO dyi_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mala wɔjɛnnɛ na li yɛn warifuwe wolo li le fun wa pe puŋgo jɔnlɔ wi kasha ki ni, naa penjara nda wì pan mbe bile wi lɔ ti ni.» Zhozɛfu wìla sɛnrɛ nda yo ŋa wìla pye wi go ki go na wi kan, a wì sigi kagala ke pye. ");
INSERT INTO dyi_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ki goto, naa laga kìla kaa laga, a pè sigi nambala poro naa pe sofilele pe yaga a pè kari. ");
INSERT INTO dyi_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Naa pàa kaa yiri wa ca ki ni na kee, pe sila ta mbe lali jɛŋgɛ, a Zhozɛfu wì sigi yo naŋa ŋa wìla pye wi go ki go na wi kan fɔ: «Yiri ma taga ki nambala mbele pe na ma pe purɔ, na maga sa pe yigi ma pe yewe ma pe pye fɔ: ‹Yiŋgi na, a yè si kapege tɛgɛ ma kajɛŋgɛ ki fɔgɔ tɔn? ");
INSERT INTO dyi_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Yiŋgi na, a yè silan tafɔ wi wɔjɛnnɛ li yu, lo na wi maa wele wa li ni na jɛɛrɛ yaan? Ŋga yè pye yɛɛn ki woro ma yɔn.› » ");
INSERT INTO dyi_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ŋa wi yɛn Zhozɛfu wi go ki go na, wì si taga pe na ma saa pe yigi konɔ mɛɛ ki sɛnrɛ ti yo pe kan. ");
INSERT INTO dyi_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","A pè suu yɔn sogo ma yo fɔ: «Yiŋgi na, a we tafɔ wi nɛɛ para yɛɛn? Yɛnŋɛlɛ sa woro mbele ma kulolo we shɔ ki kapege ŋga ki pyewe ni. ");
INSERT INTO dyi_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Wele, penjara nda wàa yan wa we kashara ti ni, wè sɔngɔrɔ ma yiri wa Kana tara ma pan ti ni ma kan. Yiŋgi na, wee penjara nakoma tɛ yu wa ma tafɔ wi go? ");
INSERT INTO dyi_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Na ki wɔjɛnnɛ liga yan ŋa tuguro we ni, ki daga pe wo gbo; pa woro sanmbala we yaa pye ma kulolo.» ");
INSERT INTO dyi_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","A naŋa wì sho fɔ: «Kò yɔn. Sɛnrɛ nda yè yo, ki pye ki yala ti ni. Ɛɛn fɔ, na mi ka wɔjɛnnɛ li yan lere ŋa yeri, wo wi yaa pye na kulo we, yoro sanmbala ye kala se pye wa.» ");
INSERT INTO dyi_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kì kaa pye ma, a pe ni fuun nuŋgba nuŋgba pè si fyɛɛlɛ ma pe kashara ti tirige tara mɛɛ ti yɛngɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","A naŋa wì si kashara ti san ma wele, maga lɛ wa ndɔfɔ wi wogo ki na, ma saa ki wa wa jɔnlɔfɔ wi wogo ki na. A pè si wɔjɛnnɛ li yan wa jɔnlɔfɔ Bɛnzhamɛ kasha ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","A pe jatere wì si piri pe na fɔ jɛŋgɛ, a pè si pe yaripɔrɔ ti walagi lawɔrɔ ti na, mɛɛ pe tuguro ti tagala wa pe sofilele pe na, mɛɛ sɔngɔrɔ wa ca. ");
INSERT INTO dyi_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","A Zhuda wo naa wi to seyɛɛnlɛ pe ni, pè si saa gbɔn wa Zhozɛfu wi go maa ta wa bere. A pè si to tara wi yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","A Zhozɛfu wì si pe pye fɔ: «Yiŋgi kala yè pye yɛɛn? Ye sigi jɛn mbe yo lere ŋa wi yɛn paa mi si yɛn, yawa yɛn wi yeri mbaa jɛɛrɛ yaan?» ");
INSERT INTO dyi_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","A Zhuda wì suu pye fɔ: «We yaa yo mɛlɛ na tafɔ ma kan? Yiŋgi sɛnrɛ we yaa yo mbege naga fɔ we kapyege ma? Yɛnŋɛlɛ lo lì woro mbele ma kulolo we kapege ki yirige funwa na. Wele, we yaa pye na tafɔ ma kulolo woro naa wɔjɛnnɛ lì yan ŋa kasha wi ni.» ");
INSERT INTO dyi_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","A Zhozɛfu wì sho fɔ: «Yɛnŋɛlɛ liga ka ti mbe ko pye! Wɔjɛnnɛ lì yan ŋa yeri wo mi yaa lɛ na kulo. Ɛɛn fɔ, yoro sanmbala ye sɔngɔrɔ yaa kee yɛyinŋge na ye to wi kɔrɔgɔ.» ");
INSERT INTO dyi_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kì kaa pye ma, a Zhuda wì si fulo wa Zhozɛfu wi tanla, ma sho fɔ: «Na tafɔ, mila ma yɛnri, ma yɛɛ yaga, mi ŋa ma kulonaŋa mila jaa mbe para ma ni, maga ka nawa ŋgban na tafɔ, katugu mboro naa Farawɔn wi ni yè yala. ");
INSERT INTO dyi_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Na tafɔ màa keli ma we yewe fɔ na kaa pye we to wi yɛn wa go na bere, nakosima we nɔsepyɔ wa yɛn wa naa le? ");
INSERT INTO dyi_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","We tafɔ wàa ma yɔn sogo ma yo fɔ we to lelɛɛ wi yɛn wa, konaa we puŋgo jɔnlɔ wi ni. Wì wo se wa wi lelɛwɛ pi ni. Wi yɛn ma we to wi ndanla jɛŋgɛ, katugu wo nuŋgba wì koro pe nɔ yinnɛ li ni. Pinambyɔ sanŋa wo la ku. ");
INSERT INTO dyi_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Na tafɔ, a mà sigi yo woro mbele ma kulolo we kan ma yo we pan wi ni laga ma yeri, fɔ maa jaa mboo yan yɛnlɛ ni. ");
INSERT INTO dyi_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Na tafɔ, a wè sigi yo ma kan ma yo pyɔ wi se ya laga wi to wi na, fɔ na wiga laga wi na, pa tofɔ wi yaa ku. ");
INSERT INTO dyi_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ɛɛn fɔ, màa ki yo woro mbele ma kulolo we kan fɔ na we puŋgo jɔnlɔ wii pinlɛ mbe pan we ni, waga ka pan mbe yere ma yɛgɛ sɔgɔwɔ naa. ");
INSERT INTO dyi_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Na wàa kaa sɔngɔrɔ ma kari we to wi kɔrɔgɔ, ma kulonaŋa we, a wè si sɛnrɛ nda fuun màa yo we kan ti yɛgɛ yo wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","A we to wì si kaa ki yo we kan naa, ma yo we sɔngɔrɔ laga, we pan we yarilire jɛnri lɔ. ");
INSERT INTO dyi_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","A wè suu yɔn sogo ma yo fɔ we se ya kari wa kaawɔ we puŋgo jɔnlɔ wi pinlɛ we ni, pa kona we yaa kari; katugu we se ya yere ki naŋa wi yɛgɛ sɔgɔwɔ, na we jɔnlɔ wi woro we ni. ");
INSERT INTO dyi_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ma kulonaŋa, we to we, a wì si we pye fɔ: Yège jɛn ma yo na jɔ Arashɛli pinambiile shyɛn wì se na kan, ");
INSERT INTO dyi_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","pe ni, nuŋgba kɔ wa wara wara. Mi yɛn naga jate ma yo yanyaraga kùu gbo maa kɔɔnlɔ yuroyuroyuro, katugu mì suu yan naa, fɔ ma pan ma gbɔn nala. ");
INSERT INTO dyi_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","A ye nɛɛ jaa mbe sanŋa wo lɛ naa. Na kaŋgbanga kaa ta, pa ye yaa ti mbe kari kayaŋga ni wa kuulo tara, wa na lelɛwɛ pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Koni na mi ka sɔngɔrɔ wa na to ŋa wi yɛn ma kulonaŋa wi yeri, na pyɔ wi woro we ni, wì mara wi to wi na ma gbɔn yɛgɛ ŋga na, ");
INSERT INTO dyi_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","na wii pyɔ wi yan wi sɔngɔrɔ ma kari we ni, pa wi yaa ku. Pa kona we yaa ti wi ku kayaŋga ni wa wi lelɛwɛ pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Katugu mi ŋa ma kulonaŋa, mì yere pyɔ wi go kala li ni, mala to wi pye fɔ: ‹Na mii sɔngɔrɔ mbe pan pyɔ wi ni ma kan, pa mi yaa pye kapege pyefɔ ma yɛgɛ sɔgɔwɔ wagati wi ni fuun ni.› ");
INSERT INTO dyi_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ki kala na, mi yɛn nɔɔ yɛnri, mi ŋa ma kulonaŋa, maga yaga mbe koro laga pyɔ wi yɔnlɔ mbe pye na tafɔ ma kulonaŋa, jaŋgo pyɔ wi ta wi sɔngɔrɔ wi ndɛɛlɛ sanmbala pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mi se ya sɔngɔrɔ wa na to wi yeri, na pyɔ wi woro na ni. Jɔlɔgɔ ŋga ki yaa na to wi ta, mi se ya mbege yan mbege kun na yɛɛ ni.» ");
INSERT INTO dyi_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Kì kaa pye ma, Zhozɛfu wi sila ya mbege kun wi yɛɛ ni leele mbele pàa pye le wi tanla pe yɛgɛ na. A wì si ti a pè leele pe ni fuun pe yirige wa funwa na. Kona, a Zhozɛfu wì si koro wi yɛ wo naa wi to seyɛɛnlɛ pe ni, a wì suu yɛɛ naga pe na. ");
INSERT INTO dyi_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","A wi nɛɛ gbele ŋgbanga fɔ a Ezhipiti tara fɛnnɛ pège logo. A Farawɔn go woolo pège logo fun. ");
INSERT INTO dyi_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","A Zhozɛfu wì suu to seyɛɛnlɛ pe pye fɔ: «Muwi mi yɛn Zhozɛfu we. Na to wi yɛn go na bere le?» Ɛɛn fɔ, kìla to pe yɔn na le wi yɛgɛ sɔgɔwɔ, pe sila ya mboo yɔn sogo. ");
INSERT INTO dyi_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","A Zhozɛfu wì suu to seyɛɛnlɛ pe pye fɔ: «Ye fulo laga na tanla.» A pè si fulo wa wi tanla. A Zhozɛfu wì si pe pye naa fɔ: «Muwi mi yɛn Zhozɛfu, ye jɔnlɔ ŋa yàa pɛrɛ, a pè pan wi ni laga Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Koni yaga ka ye jatere wi piri ye yɛɛ na, mbe nawa ŋgban ye yɛɛ ni mbe yo yàa na pɛrɛ, a pè pan na ni lagamɛ. Yɛnŋɛlɛ lo lìlan torogo laga ye yɛgɛ jaŋgo mbe ye go shɔ. ");
INSERT INTO dyi_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Fuŋgo kì to ma ta yɛgɛlɛ shyɛn makɔ. Yɛgɛlɛ kaŋgurugo ŋgele kaa paan naa, pe se ka ya mbe yariluguro lugu, pe se si ka ya mbe yarilire kɔn fun. ");
INSERT INTO dyi_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yɛnŋɛlɛ lo lìlan torogo laga ki tara nda ti ni ye yɛgɛ, jaŋgo ye setirige piile ta laga tara ti ni, ye koro go na. Ko yɛn fɔ ye lɛgɛrɛ mbe shɔ. ");
INSERT INTO dyi_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Yoro ma yànla torogo lagamɛ, ɛɛn fɔ, Yɛnŋɛlɛ loli. Lo lìlan tɛgɛ mala pye Farawɔn wi legbɔɔ ŋa wi yɛn fanŋga fɔ, mala tɛgɛ wunlunaŋa wi go ki go na, konaa mala tɛgɛ Ezhipiti tara ti ni fuun ti go na. ");
INSERT INTO dyi_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ye fyɛɛlɛ ye sɔngɔrɔ wa na to wi yeri, yoo pye fɔ: ‹Ma pinambyɔ Zhozɛfu wì yo wège yo ma kan fɔ: Yɛnŋɛlɛ lùu tɛgɛ Ezhipiti tara ti ni fuun ti go na. Fɔ ma yiri ma kari wi kɔrɔgɔ, maga ka mɔ. ");
INSERT INTO dyi_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Fɔ ma yaa sa cɛn wa Goshɛni tara ti ni, mboro naa ma piile, naa ma pishyɛnwoolo, naa ma sikaala naa simbaala, naa nɛrɛ konaa ma yarijɛndɛ ti ni fuun ti ni. Kiga pye ma, pa ma yaa pye laga na tanla. ");
INSERT INTO dyi_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Fɔ mi yaa la yaakara kaan ma yeri lagamɛ, mboro, naa ma go woolo pe ni, naa ma yaayoro ti ni, jaŋgo yaraga ka kpɛ ka ka ye la, katugu fuŋgo ki yaa yɛgɛlɛ kaŋgurugo pye laga tara ti ni naa.› » ");
INSERT INTO dyi_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","A Zhozɛfu wì si pe pye naa fɔ: «Ye yɛn naga yaan yɛnlɛ ni, a na jɔnlɔ Bɛnzhamɛ fun wi yɛn naga yaan yɛnlɛ ni, fɔ mi jate mi yɛn na para ye ni. ");
INSERT INTO dyi_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Gbɔgɔwɔ mba fuun mì ta laga Ezhipiti tara, ye kari ye saa sɛnrɛ yo na to wi kan, konaa ŋga fuun yè yan laga ki ni. Ye si fyɛɛlɛ ye pan na to wi ni laga.» ");
INSERT INTO dyi_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","A Zhozɛfu wì si kɛyɛn wa wi jɔnlɔ Bɛnzhamɛ wi yɔlɔgɔ maa shari. A Bɛnzhamɛ fun wì kɛyɛn wa wi yɔlɔgɔ maa shari, a pe ni fuun shyɛn pe nɛɛ gbele nayinmɛ pi kala na. ");
INSERT INTO dyi_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Zhozɛfu wìla kɛyɛn wa wi to seyɛɛnlɛ pe yɔlɔgɔ fun, na gbele nayinmɛ pi kala na. Kona, a wi ndɛɛlɛ pè si kotogo ta na para wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Farawɔn wo naa wi go woolo pe ni pàa ki logo ma yo Zhozɛfu wi to seyɛɛnlɛ pàa pan wa Ezhipiti tara. A kì si nayinmɛ kan Farawɔn wo naa wi legbɔɔlɔ pe yeri. ");
INSERT INTO dyi_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","A Farawɔn wì si Zhozɛfu wi pye fɔ: «Ki yo ma to seyɛɛnlɛ pe kan fɔ pe pe tuguro ti taga pe yaayoro ti na, pe sɔngɔrɔ wa Kana tara ");
INSERT INTO dyi_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","pe sa pe to wi lɛ, naa pe go woolo pe ni, pe pan pe ni laga na tanla. Mi yaa cɛnsaga kan pe yeri laga Ezhipiti tara ti laga ŋga kì yɔn ma wɛ ki ni fuun na ki ni. Tara ti yarijɛndɛ ti yaa pye pe woro. ");
INSERT INTO dyi_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ki yo maga ŋgban fun ma to seyɛɛnlɛ pe ni fɔ pe wotoroye pele lɛ laga Ezhipiti tara, pe kari pe ni pe sa pe jɛɛlɛ, naa pe piile konaa pe to wi lɛ pe pan pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Yaara nda pe yaa pan mbe toro wa, ti wogo kiga ka pe ya, katugu pe yaa pan mbe cɛn laga Ezhipiti tara ti laga ŋga kì yɔn ma wɛ ki ni fuun na ko ni.» ");
INSERT INTO dyi_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","A Izirayɛli wi pinambiile pè si ŋga Farawɔn wìla yo ki pye ma. A Zhozɛfu wì si wotoroye kan pe yeri naa yaakara ni pe kondangala li na, ma yala Farawɔn wi sɛnyoro ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Wìla yaripɔrɔ fɔnndɔ nuŋgba nuŋgba kankan pe ni fuun nuŋgba nuŋgba pe yeri. Ɛɛn fɔ, wìla yaripɔrɔ tɛgɛsaga kaŋgurugo kan Bɛnzhamɛ wo yeri, naa warifuwe pyɔ cɛnmɛ taanri (300) ni. ");
INSERT INTO dyi_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A wì suu to wi torogo yaara ni. Wìla Ezhipiti tara yarijɛndɛ tuguro taga sofile nambala kɛ na, ma bile, naa buru, naa yarilire tuguro taga sofile nɛɛlɛ kɛ na wi to wi kondangala li na. ");
INSERT INTO dyi_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","A Zhozɛfu wì sigi yo wi to seyɛɛnlɛ pe kan fɔ: «Yaga ka sa win konɔ.» A wì si pe yaga, a pè kari. ");
INSERT INTO dyi_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","A pè si yiri wa Ezhipiti tara ma saa gbɔn wa Kana tara, wa pe to Zhakɔbu wi na. ");
INSERT INTO dyi_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","A pè sigi yo pe to wi kan fɔ: «Zhozɛfu wi yɛn go na bere. Wo yɛrɛ wi yɛn Ezhipiti tara ti go na.» Ɛɛn fɔ, a Zhakɔbu wì si pyeri dinw, katugu wi sila taga pe sɛnyoro ti na. ");
INSERT INTO dyi_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Sɛnrɛ nda fuun Zhozɛfu wìla yo, a pè si ti ni fuun ti yɛgɛ yo Zhakɔbu wi kan. A pè si wotoroye mbele Zhozɛfu wìla torogo ma yo pe saa lɛ pe naga wi na. Kona, a Zhakɔbu wi jatere wì si cɛn wi na laga nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","A Izirayɛli wì sho fɔ: «Yeri yaga ma. Na pinambyɔ Zhozɛfu wi yɛn go na bere! Mi yaa kari saa yan, si jɛn mbe ku.» ");
INSERT INTO dyi_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Kona, a Izirayɛli wì si lɛ ma kari wi kɛɛ yaara ti ni fuun ti ni. Naa wìla ka saa gbɔn wa Bɛrisheba, a wì si saara wɔ wi to Izaki wi Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ki yembinɛ li ni, a Yɛnŋɛlɛ lì si para Izirayɛli wi ni yariyanra ta ni maa yeri fɔ: «Zhakɔbu! Zhakɔbu!» A Izirayɛli wì si shɔ ma yo: «Naw.» ");
INSERT INTO dyi_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","A Yɛnŋɛlɛ lì sho fɔ: «Muwi mi yɛn Yɛnŋɛlɛ, ma to Izaki wi Yɛnŋɛlɛ le. Maga ka fyɛ mbe kari wa Ezhipiti tara, katugu mi yaa ka ma setirige piile pe pye pe lɛgɛ, mbe pe pye cɛnlɛ gbenɛ wa ki tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mi jate mi yaa pinlɛ mbe kari ma ni wa Ezhipiti tara, mi jate mi yaa kɔɔn pye ma sɔngɔrɔ laga naa fun. Ma kusanga ni, Zhozɛfu wo wi yaa kɔɔn yɛngɛlɛ ke tɔn.» ");
INSERT INTO dyi_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","A Zhakɔbu wì si yiri wa Bɛrisheba ma kari. Wotoroye mbele Farawɔn wìla torogo kondangala li na, a Zhakɔbu wi pinambiile pè si pe to Zhakɔbu, wo naa pe piile, naa pe jɛɛlɛ pe lɛ wa pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Pàa kari fun pe yaayoro ŋgbeleye yo naa pe yarijɛndɛ nda fuun pàa ta wa Kana tara ti ni. A Zhakɔbu wì si kari wa Ezhipiti tara wo naa wi go woolo pe ni fuun pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Zhakɔbu wìla kari wa Ezhipiti tara wo naa wi pinambiile, naa wi sumborombiile, naa wi pishyɛnwoolo nambala naa jɛɛlɛ, konaa wi go woolo pe ni fuun pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Izirayɛli setirige piile mbele pàa pan wa Ezhipiti tara pe mɛrɛ ti nda: Zhakɔbu naa wi pinambiile konaa wi pishyɛnwoolo. Zhakɔbu pinambyɔ koŋgbanŋa wo lawi ŋa Urubɛn. ");
INSERT INTO dyi_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Urubɛn pinambiile pe mɛrɛ ti nda: Hanɔki, naa Palu, naa Hɛzirɔn konaa Karimi. ");
INSERT INTO dyi_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeyɔn pinambiile pe mɛrɛ ti nda: Yemuwɛli, naa Yamini, naa Owadi, naa Yakini, naa Sokari konaa Kana tara fɛnnɛ jɔ wi pinambyɔ Sawuli wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi pinambiile pe mɛrɛ ti nda: Gɛrishɔn naa Kehati konaa Merari. ");
INSERT INTO dyi_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Zhuda pinambiile pe mɛrɛ ti nda: Ɛri, naa Ona, naa Shela, naa Perɛzi konaa Zera; ɛɛn fɔ, Ɛri naa Ona poro la ku wa Kana tara. Perɛzi pinambiile poro la pye Hɛzirɔn konaa Hamuli. ");
INSERT INTO dyi_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakari pinambiile pe mɛrɛ ti nda: Tola, naa Puva, naa Yɔbu konaa Shimirɔn. ");
INSERT INTO dyi_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulɔn pinambiile pe mɛrɛ ti nda: Serɛdi, naa Elɔn konaa Yaleyɛli. ");
INSERT INTO dyi_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ki pinambiile mbele poro wɛlɛ Leya wìla se Zhakɔbu wi na wa Padamu Aramu tara, ma pinlɛ wi sumborombyɔ Dina wi ni. Wi pinambiile naa wi sumborombiile, mbe pinlɛ wi pishyɛnwoolo pe ni, pe ni fuun pàa pye lere nafa ma yiri kɛ ma yiri taanri. ");
INSERT INTO dyi_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadi pinambiile pe mɛrɛ ti nda: Sifiyɔn, naa Hagi naa Shuni, naa Ɛzibɔn, naa Eri, naa Arɔdi konaa Arɛli. ");
INSERT INTO dyi_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asɛri pinambiile pe mɛrɛ ti nda: Yimina, naa Yishiva, naa Yishivi konaa Beriya, naa pe nɔsepyɔ sumboro Sera. Beriya pinambiile pe mɛrɛ ti nda: Hebɛri naa Malikiyɛli. ");
INSERT INTO dyi_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Zhakɔbu naa Zilipa pe setirige piile poro la wɛlɛ mbele yɛɛn. Pàa pye lere kɛ ma yiri kɔgɔlɔni. Zilipa wo Laban wìla kan wi sumborombyɔ Leya wi yeri wi kulojɔ. ");
INSERT INTO dyi_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Zhakɔbu wi jɔ Arashɛli wi pinambiile pe mɛrɛ ti nda: Zhozɛfu naa Bɛnzhamɛ. ");
INSERT INTO dyi_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Pinambiile shyɛn Zhozɛfu wìla se wi jɔ Asenati wi na wa Ezhipiti tara. Pe mɛrɛ ti nda: Manase naa Efirayimu. Ɔni ca saraga wɔfɔ Potifera wo sumborombyɔ lawi Asenati. ");
INSERT INTO dyi_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bɛnzhamɛ pinambiile pe mɛrɛ ti nda: Bela, naa Bekɛri, naa Ashibɛli, naa Gera, naa Naama, naa Ehi, naa Ɔrɔshi, naa Mupimu, naa Hupimu konaa Aridi. ");
INSERT INTO dyi_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Arashɛli wìla setirige piile mbele se Zhakɔbu wi na poro wɛlɛ yɛɛn. Pe ni fuun pàa pye lere kɛ ma yiri tijɛrɛ. ");
INSERT INTO dyi_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan wi pinambyɔ wi mɛgɛ ki ŋga: Hushimu. ");
INSERT INTO dyi_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nɛfitali pinambiile pe mɛrɛ ti nda: Yazeyɛli, naa Guni, naa Yezɛri konaa Shilɛmu. ");
INSERT INTO dyi_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Zhakɔbu naa Biliha pe setirige piile poro la wɛlɛ yɛɛn. Pe ni fuun pàa pye lere kɔlɔshyɛn. Biliha wo Laban wìla kan wi sumborombyɔ Arashɛli wi yeri wi kulojɔ. ");
INSERT INTO dyi_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Leele mbele pàa pinlɛ Zhakɔbu wi ni ma kari wa Ezhipiti tara, ma pye wo jate go woolo, pàa pye lere nafa taanri ma yiri kɔgɔlɔni. Wi pinambiile pe jɛɛlɛ pe sila poro jiri. ");
INSERT INTO dyi_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Zhozɛfu wi pinambiile shyɛn mbele wìla se wa Ezhipiti tara poro ka taga Zhakɔbu wi go woolo mbele pàa saa cɛn wa Ezhipiti tara, pe yaa pye lere nafa taanri ma yiri kɛ. ");
INSERT INTO dyi_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kona, a Zhakɔbu wì si Zhuda wi torogo wa wi yɛɛ yɛgɛ ma yo wi saga yo Zhozɛfu wi kan wi keli wi pan wi na wa Goshɛni tara. A pè si saa gbɔn wa Goshɛni tara. ");
INSERT INTO dyi_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","A Zhozɛfu wì si ti a pòo wotoro wi gbɛgɛlɛ wi kan. A wì si ye wa wi ni mɛɛ kari saa to Izirayɛli wi fili wa Goshɛni tara. Naa wìla ka saa wi yan sanga ŋa ni, a wì si fe ma kɛyɛn wa wi yɔlɔgɔ, mɛɛ gbele ma mɔ wa wi yɔlɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","A Izirayɛli wì si Zhozɛfu wi pye fɔ: «Koni mbe ya mbe ku, katugu ma yɛn go na bere, a mɔ̀ɔ yan.» ");
INSERT INTO dyi_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","A Zhozɛfu wì suu to seyɛɛnlɛ poro naa wi to go woolo pe pye fɔ: «Mi yaa kari sa ye panga wogo ki yo Farawɔn wi kan, fɔ na to seyɛɛnlɛ naa na to go woolo mbele pàa pye wa Kana tara, pè pan laga na kɔrɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mi yaa ki yɛgɛ yo wi kan fɔ ye yɛn yaayoro korofɛnnɛ, yaayoro tunŋgo ye maa piin; fɔ yè pan ye simbaala, naa ye sikaala, naa ye nɛrɛ konaa ye kɛɛ yaara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Na Farawɔn wiga ka ye yeri mbe ye yewe fɔ: ‹Yiŋgi tunŋgo ye maa piin?› ");
INSERT INTO dyi_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Yoo yɔn sogo ye yo fɔ: ‹Woro mbele ma kulonambala we yɛn yaayoro korofɛnnɛ, malɛ we yɛn piile fɔ ma pan ma gbɔn nala, paa yɛgɛ ŋga na we tɛlɛye pàa pye naga piin.› Kiga pye ma, pa ye yaa cɛn laga Goshɛni tara, katugu yaayoro korofɛnnɛ pe yɛn Ezhipiti tara fɛnnɛ pe yarifugo.» ");
INSERT INTO dyi_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","A Zhozɛfu wì si saa ki yo Farawɔn wi kan ma yo fɔ: «Na to naa na to seyɛɛnlɛ pè yiri wa Kana tara ma pan pe simbaala, naa pe sikaala, naa pe nɛrɛ, konaa pe kɛɛ yaara ti ni fuun ti ni. Pe yɛn wa Goshɛni tara.» ");
INSERT INTO dyi_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","A wì suu to seyɛɛnlɛ kaŋgurugo lɛ ma kari ma saa pe naga Farawɔn wi na. ");
INSERT INTO dyi_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","A Farawɔn wì si pe yewe ma yo fɔ: «Yiŋgi tunŋgo ye maa piin?» A pè si Farawɔn wi yɔn sogo ma yo fɔ: «Woro mbele ma kulonambala, we yɛn yaayoro korofɛnnɛ paa yɛgɛ ŋga na we tɛlɛye pàa pye.» ");
INSERT INTO dyi_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","A pè suu pye naa fɔ: «Wè pan mbe cɛn laga ki tara nda ti ni, katugu fuŋgo kila seregi wa Kana tara ti ni. Woro mbele ma kulonambala, yan si koro naa wa we yaayoro kɔnrisara we yaayoro tila kaa. We yɛn nɔɔ yɛnri, woro mbele ma kulonambala, maga yaga we sa cɛn wa Goshɛni tara.» ");
INSERT INTO dyi_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","A Farawɔn wì si Zhozɛfu wi pye fɔ: «Koni ma to naa ma to seyɛɛnlɛ pè pan ma kɔrɔgɔ, ");
INSERT INTO dyi_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ezhipiti tara ti yɛn ma kɛɛ na. Pe pye pe sa cɛn wa tara ti laga ŋga kì yɔn ma wɛ ki ni fuun na ko ni. Pe sa cɛn wa Goshɛni tara. Na maga si pele yan pe yɛn pe ni tunmbyeele, ma pe tɛgɛ mi jate na yaayoro ti go na.» ");
INSERT INTO dyi_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","A Zhozɛfu wì si ti a pè pan wi to wi ni, a wì saa wi naga Farawɔn wi na. A Zhakɔbu wì si duwaw pye Farawɔn wi kan. ");
INSERT INTO dyi_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","A Farawɔn wì si Zhakɔbu wi yewe ma yo fɔ: «Mà ta yɛlɛ jori?» ");
INSERT INTO dyi_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","A Zhakɔbu wì si Farawɔn wi yɔn sogo ma yo fɔ: «Yɛlɛ yɛn na yɛlɛ cɛnmɛ naa nafa ma yiri kɛ (130), mi ma yiri tara ta ni ma saa cɛn tara ta ni paa nambanŋa yɛn. Yɛlɛ yɔn ŋga mì pye kii lɛgɛ, mɛɛ tijanga na na. Kii na tɛlɛye pe yɛgɛlɛ yɔn ki bɔ, poro fun pàa pye na cɛɛn na toro paa na yɛn.» ");
INSERT INTO dyi_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","A Zhakɔbu wì si duwaw pye naa Farawɔn wi kan mɛɛ yiri le wi tanla ma kari. ");
INSERT INTO dyi_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","A Zhozɛfu wì si saa cɛnsaga kan wi to naa wi to seyɛɛnlɛ pe yeri, wa Ezhipiti tara laga ŋga kì yɔn ma wɛ ki ni fuun na ki ni, wa Aramisɛsi ca wasege ki ni, ma yala Farawɔn wi sɛnyoro ti ni. Wìla tara ta kan pe yeri. ");
INSERT INTO dyi_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Zhozɛfu wìla pye na yaakara kaan wi to, naa wi to seyɛɛnlɛ konaa wi to go woolo pe ni fuun pe yeri ma yala leele pe yɔn ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Fuŋgo kìla ŋgban jɛŋgɛ, yaakara sila pye tara ti laga ka kpɛ ni. Ezhipiti tara fɛnnɛ naa Kana tara fɛnnɛ pàa pye na cogo fuŋgo ki kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ezhipiti tara penjara naa Kana tara penjara nda fuun pàa bile wi lɔ ti ni Zhozɛfu wi yeri, wìla ti gbogolo ma saa ti tɛgɛ wa Farawɔn wi go. ");
INSERT INTO dyi_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Naa Ezhipiti tara penjara to naa Kana tara penjara tìla kaa kɔ, a Ezhipiti tara fɛnnɛ pè si pan ma Zhozɛfu wi pye fɔ: «Yaakara ta kan we yeri! Penjara nda tì kɔ we yeri ko kala na, ye mbe we yaga we ku na ye yɛgɛ sɔgɔwɔ le?» ");
INSERT INTO dyi_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","A Zhozɛfu wì si pe pye fɔ: «Kì kaa pye penjara tì kɔ ye yeri, yaa paan ye yaayoro ŋgbeleye yi ni na kan, pa mi yaa layi sunru ye yeri yaakara na.» ");
INSERT INTO dyi_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","A pè si pan pe yaayoro ŋgbeleye yi ni Zhozɛfu wi kan. A wi nɛɛ yaakara kaan pe yeri nari sunru pe shɔnye, naa simbaala, naa sikaala, naa nɛrɛ konaa pe sofilele pe na. Ki yɛlɛ li ni, wìla yaakara kan pe yeri mari suru pe yaayoro ti na. ");
INSERT INTO dyi_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ko yɛlɛ lo toroŋgɔlɔ, ki yelapanna, a pè si pan naa Zhozɛfu wi kɔrɔgɔ maa pye fɔ: «We sege lara ma na we tafɔ, fɔ we penjara ti ni fuun tì kɔ we yeri, a wè pan we yaayoro ŋgbeleye yi ni mayi kan we tafɔ ma yeri. Yaraga ko ka si koro we yeri we kan ma yeri we tafɔ, kaawɔ woro jate konaa tara nda ti yɛn we yeri to. ");
INSERT INTO dyi_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Maga ka ti we ku ma yɛgɛ sɔgɔwɔ mbe tara nda ti yɛn we yeri ti yaga waga. Woro naa tara nda ti yɛn we yeri ti ni, we lɔ yaakara na, pa we yaa pye Farawɔn wi kulolo, woro naa tara nda ti yɛn we yeri ti ni. Yariluguro kan we yeri we lugu jaŋgo we koro go na, waga ka ta mbe ku, tara nda ti yɛn we yeri tiga ka koro waga.» ");
INSERT INTO dyi_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","A Zhozɛfu wì si Ezhipiti tara fɛnnɛ pe tara ti ni fuun ti lɔ mari kan Farawɔn wi yeri. Ezhipiti tara fɛnnɛ pe ni fuun nuŋgba nuŋgba pàa pe kɛɛrɛ ti pɛrɛ, katugu fuŋgo kìla ŋgban pe na fɔ jɛŋgɛ. Kì kaa pye ma, a Ezhipiti tara ti ni fuun tì si pye Farawɔn wi woro. ");
INSERT INTO dyi_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","A Zhozɛfu wì si ti a leele pè pan ma cɛn wa cagbɔrɔ gbɔrɔ ti ni, maga lɛ wa Ezhipiti tara ti go ŋga na, ma saa ki wa ti go ŋga na. ");
INSERT INTO dyi_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ɛɛn fɔ, Ezhipiti tara saraga wɔfɛnnɛ pe tara to tìla koro Zhozɛfu wi sila lɔ, katugu Farawɔn wìla ŋgasele la tɛgɛ, na làa ti a paa kajɛŋgɛ piin saraga wɔfɛnnɛ pe kan. Pe yɔn suro pàa pye nari taa ki ŋgasele na Farawɔn wìla tɛgɛ lo kala na. Ko kala na poro sila pe tara ti pɛrɛ. ");
INSERT INTO dyi_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","A Zhozɛfu wì si tara woolo pe pye fɔ: «Mì ye lɔ nala, yoro naa ye tara Farawɔn wi kan. Mi yaa bile luguwoo kan ye yeri ye sa lugu wa ye kɛɛrɛ ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Na yaga ka yarilire ti kɔn sanga ŋa ni, ye yaa walisaga kaŋgurugo wogo ki kan Farawɔn wi yeri. Walisara tijɛrɛ sannda to yaa pye ye woro, ye ta pye luguworo, ye ta tɛgɛ yaa kaa yoro naa ye piile naa ye go woolo pe ni.» ");
INSERT INTO dyi_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","A pè suu pye fɔ: «Mà we go shɔ we tafɔ! Mà kajɛŋgɛ pye we kan, wè yere ki na mbe pye Farawɔn wi kulolo.» ");
INSERT INTO dyi_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","A Zhozɛfu wì sigi ŋgasele na li tɛgɛ wa Ezhipiti tara ali ma pan ma gbɔn nala, fɔ pe kɛɛrɛ yarilire ti walisaga kaŋgurugo wogo ki yaa pye Farawɔn wi wogo. Kaawɔ tara nda tìla pye saraga wɔfɛnnɛ pe woro to ti sila pye Farawɔn wi woro. ");
INSERT INTO dyi_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Izirayɛli wìla saa cɛn wa Ezhipiti tara wa Goshɛni wasege ki ni (wo naa wi go woolo pe ni). Pàa tara ta ta mari pye pe woro. Pàa se ma lɛgɛ fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Zhakɔbu wìla pye wa Ezhipiti tara yɛlɛ kɛ ma yiri kɔlɔshyɛn. Wi yinwege ki ni fuun kìla pye yɛlɛ cɛnmɛ naa nafa shyɛn ma yiri kɔlɔshyɛn (147). ");
INSERT INTO dyi_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Naa Zhakɔbu wi kusanga wila kaa na yɔngɔ, a wì suu pinambyɔ Zhozɛfu wi yeri maa pye fɔ: «Na kiga pye na kala lɔɔn ndanla, mila ma yɛnri, ma kɛɛ ki le laga na jegbɔlɔ li nɔgɔ ma yɔn kan na yeri, fɔ ma yaa ka kajɛŋgɛ pye na kan mbe koro sinŋɛ na ni, fɔ ma se kanla le laga Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Na mi ka ka ku mbe taga wa na tɛlɛye pe na, mala lɛ ma yiri na ni laga Ezhipiti tara, ma sanla le wa pe fanga ki ni.» A Zhozɛfu wì sho fɔ: «Sɛnrɛ nda mà yo, mi yaa ki kala li pye.» ");
INSERT INTO dyi_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","A Zhakɔbu wì suu pye fɔ: «Wugu mala kan ki wogo ki na.» A Zhozɛfu wì si wugu maa kan ki wogo ki na. A Zhakɔbu wì si sogo maa yɛgɛ ki jiile wa wi sinlɛyaraga ki go kɛɛ ki na, maa gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ki kagala ke puŋgo na, a pè si saa ki yo Zhozɛfu wi kan ma yo fɔ: «Wele, ma to wi woro ŋgbaan.» A wì si kari wi pinambiile shyɛn Manase naa Efirayimu pe ni wa wi to wi yeri. ");
INSERT INTO dyi_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","A pè sigi yo Zhakɔbu wi kan fɔ: «Ma pinambyɔ Zhozɛfu wi ŋa wila paan laga ma kɔrɔgɔ.» A Izirayɛli wì si fanŋga le wi yɛɛ ni, ma yiri ma cɛn wi sinlɛyaraga ki na. ");
INSERT INTO dyi_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","A Zhakɔbu wì si Zhozɛfu wi pye fɔ: «Yɛnŋɛlɛ na yawa pi ni fuun fɔ, làa li yɛɛ naga na na wa Luzi ca ki ni, wa Kana tara, ma duwaw na na. ");
INSERT INTO dyi_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Làa na pye fɔ: ‹Mi yaa ma pye sevɔ, mbɔɔn setirige piile pe pye pe lɛgɛ, mbɔɔn pye cɛngɛlɛ lɛgɛrɛ to. Mi yaa kaga tara nda ti kan ma setirige piile pe yeri mboro puŋgo na, ti pye pe woro wagati wi ni fuun.› ");
INSERT INTO dyi_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Koni, ma pinambiile shyɛn Efirayimu naa Manase, poro mbele mà se laga Ezhipiti tara sanni mbe sa pan ma kɔrɔgɔ, pe yaa pye na woolo paa yɛgɛ ŋga na Urubɛn naa Simeyɔn pe yɛn na woolo we. ");
INSERT INTO dyi_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ɛɛn fɔ, piile mbele mà se poro puŋgo na, poro pe yaa pye ma woolo. Pe yaa ka pe tasaga ta wa pe ndɛɛlɛ pe kɔrɔgɔ ki ni. ");
INSERT INTO dyi_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Na sɔngɔrɔsaga ma yiri wa Mezopotami tara na paan wa Kana tara, a ma nɔ Arashɛli wì si ku na yeri wa konɔ, ki laga ki sila lali Efirata ca ki ni. A mì suu le wa Efirata ca kologo ki yɔn na. Efirata ca ko ki yɛn Betilɛɛmu ca ye.» ");
INSERT INTO dyi_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","A Izirayɛli wì si Zhozɛfu wi pinambiile pe yan, mɛɛ yewe ma yo fɔ: «Ambɛnɛ wɛlɛ mbele poro?» ");
INSERT INTO dyi_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","A Zhozɛfu wì suu to wi yɔn sogo ma yo fɔ: «Yɛnŋɛlɛ lì pinambiile mbele kan na yeri laga Ezhipiti tara poro wɛlɛ.» A Izirayɛli wì sho fɔ: «Mi yɛn nɔɔ yɛnri, pe pye pe fulo laga na tanla mbe ta mbe duwaw pye pe kan.» ");
INSERT INTO dyi_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Izirayɛli wi yɛngɛlɛ kàa te wi lelɛwɛ pi kala na, wi sila pye na yaan ke ni naa. A Zhozɛfu wì suu pinambiile pe fulo wa wi tanla. A Izirayɛli wì si pe yigi ma pe mara wi yɛɛ na, ma kɛyɛn wa pe yɔlɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","A Izirayɛli wì si Zhozɛfu wi pye fɔ: «Mi sila pye naga sɔnri mi yaa kɔɔn yan naa, kooŋga Yɛnŋɛlɛ lìgi pye, a mì yɛrɛ ma piile yan.» ");
INSERT INTO dyi_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kona, a Zhozɛfu wì suu pinambiile pe laga wa wi to wi kanŋguuro ti na, mɛɛ sogo maa yɛgɛ ki jiile wa tara maa gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ko puŋgo na, a Zhozɛfu wì suu pinambiile pe shyɛn pe yigi ma pe fulo naa wa wi to wi tanla. Wìla Efirayimu wi yigi wi kalige kɛɛ ki ni maa yerege wa Izirayɛli wi kamɛŋgɛ kɛɛ ki na, ma Manase wi yigi wi kamɛŋgɛ kɛɛ ki ni maa yerege wa Izirayɛli wi kalige kɛɛ ki na. ");
INSERT INTO dyi_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ɛɛn fɔ, a Izirayɛli wì suu kɛyɛn yi suru maa kalige ki sanga maga taga Efirayimu go ki na, wo ŋa wìla pye jɔnlɔfɔ we, mɛɛ wi kamɛŋgɛ ki taga Manase wi go ki na; ali maga ta Manase wo wìla pye pinambyɔ koŋgbanŋa we. ");
INSERT INTO dyi_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","A wì si duwaw pye Zhozɛfu wi kan ma yo fɔ: Yɛnŋɛlɛ na na tɛlɛ Abirahamu wo naa na to Izaki wi ni pàa pe yinwege ki pye sinŋge li yɛgɛ na, lo na lìlan yɛgɛ sin na yinwege piliye yi ni fuun yi ni fɔ ma pan ma gbɔn nala, ");
INSERT INTO dyi_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mɛrɛgɛ ŋa wìlan go shɔ kapege ki ni fuun ki ni, wi duwaw ki lefɔnmbigile ŋgele ke na! Yɛnŋɛlɛ sa ti mi naa na tɛlɛ Abirahamu, naa na to Izaki pe we mɛrɛ ti taga! Pe jiti, pe setirige piile pe lɛgɛ laga tara ti na! ");
INSERT INTO dyi_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Naa Zhozɛfu wìla kaa ki yan wi to wìla pye naa kalige kɛɛ ki tari wa Efirayimu go ki na, a kì suu mbɛn. A wì suu to wi kɛɛ ki yigi, mbege laga wa Efirayimu go ki na, mbe saga taga wa Manase go ki na, ");
INSERT INTO dyi_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ma suu to wi pye fɔ: «Kila pye ma, na to, katugu ŋa wo wi yɛn lɛrɛfɔ we. Ma kalige kɛɛ ki taga wa wo go ko na.» ");
INSERT INTO dyi_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","A wi to wì si je mɛɛ yo fɔ: «Mìgi jɛn, na pinambyɔ mìgi jɛn; Manase wo fun cɛnlɛ yaa ka yiri wa wi ni, wo fun wi cɛnlɛ li yaa ka gbɔgɔ; ɛɛn fɔ, wi jɔnlɔ wi yaa ka gbɔgɔ mbe wɛ wi na. Cɛngɛlɛ lɛgɛrɛ yaa ka yiri wa wi setirige ki ni.» ");
INSERT INTO dyi_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","A Zhakɔbu wì si duwaw pye pe kan ki pilige ki ni, ma yo fɔ: «Izirayɛli woolo pe yaa kaa ma mɛgɛ ki yinri mbaa duwaw piin leele pe kan mbaa yuun fɔ: ‹Yɛnŋɛlɛ sa ti ma pye paa Efirayimu naa Manase yɛn!› » Pa Zhakɔbu wìla Efirayimu wi tɛgɛ Manase wi go na yɛɛn we. ");
INSERT INTO dyi_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ko puŋgo na, a Izirayɛli wì si Zhozɛfu wi pye fɔ: «Wele, mi yaa ku. Ɛɛn fɔ, Yɛnŋɛlɛ li yaa la ye go singi, mbe ye pye ye sɔngɔrɔ wa ye tɛlɛye pe tara. ");
INSERT INTO dyi_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mi yɛn na laga ka kaan ma yeri mbe taga wa ma tasaga ki na, mbe wɛ ma to seyɛɛnlɛ pe wogo ki na. Ko ki yɛn Sishɛmu wasege ye, ko ŋga mìla malaga gbɔn na tokobi naa na sandiga ti ni, maga shɔ Amɔri cɛnlɛ woolo pe yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kona, a Zhakɔbu wì suu pinambiile pe yeri ma yo fɔ: «Ye pan ye gbogolo, kagala ŋgele ke yaa ye ta wagati ŋa wila paan wa yɛgɛ wi ni, mi yaa ke yɛgɛ yo ye kan. ");
INSERT INTO dyi_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ye gbogolo ye logo Zhakɔbu pinambiile! Yaa nuru ye to Izirayɛli wi yeri! ");
INSERT INTO dyi_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«Urubɛn mboro ŋa ma yɛn na pinambyɔ koŋgbanŋa, mìla ma se sanga ŋa ni na fanŋga ki ni fuun ki yɛn na ni. Gbɔgɔwɔ naa fanŋga ti yɛn ma woro ma wɛ ma to seyɛɛnlɛ pe na. ");
INSERT INTO dyi_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ma yɛn paa lɔgɔ yɛn ŋga ki maa fuun ŋgbanga. Ɛɛn fɔ, ma se yɛkeere ti ta naa, katugu màla fuuro ti tanga, mà sinlɛ na jɛɛlɛ wa ni wa na sinlɛsaga maga tɛgɛ fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Simeyɔn naa Levi pe yɛn nɔsepiile. Pe tokobiye pe yɛn maliŋgbɔnyaara tipere. ");
INSERT INTO dyi_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mi se gbogolo pe ni pe yɔn lemɛ pa na. Mi se silan jatere wi wa nuŋgba pe ni wa pe gbogolosara ti ni. Katugu wa pe naŋgbanwa pi ni, pàa leele gbo, wa pe nandanwa kagala ke ni, pàa napɛnɛ pe pannda ti kɔɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Mì pe naŋgbanwa kapyege ki daŋga, katugu pìla pye ma pe. Mì pe naŋgbanwa ndorogo ki daŋga, katugu pe sila lere yinriwɛ ta. Mi yaa ka pe setirige piile pe laga pe yɛɛ na wa Zhakɔbu tara, mbe pe jaraga pe yɛ pe yɛ wa Izirayɛli tara. ");
INSERT INTO dyi_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«Zhuda, ma to seyɛɛnlɛ pe yaa kaa ma sɔnni. Ma yaa ka ma juguye pe ŋgbanga pe go sogo ma kan. Ma to seyɛɛnlɛ pe yaa kaa fɔli ma yɛgɛ sɔgɔwɔ mbaa ma gbogo. ");
INSERT INTO dyi_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Zhuda, ma yɛn paa jara yirifɔnŋɔ yɛn. Na pinambyɔ, mà yiri wa ma kagboro ti go na na paan. Mɔ̀ɔ kanŋguuro ti kuuro ma sinlɛ paa jara yɛn, paa jara nɔ yɛn. Ambɔ wi mbe ya mboo pye wi yiri? ");
INSERT INTO dyi_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Wunluwɔ kanŋgala li se wɔ wa Zhuda sege ki ni. Tegere gbɔtangala li se wɔ wi setirige piile pe kɛɛ fɔ li lɛfɔ jɛnŋɛ wi sa pan; wo ŋa cɛngɛlɛ ke yaa kaa nuru wi yeri we. ");
INSERT INTO dyi_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Wi ɛrɛzɛn tiire ti yaa ka lɛgɛ fɔ wi yaa kaa wi sofile wi poo ti na, mbaa wi sofile pyɔ wi poo ɛrɛzɛn tirige ŋga kì yɔn ma wɛ ti ni fuun na ki na. Wi yaa kaa wi yaripɔrɔ ti jori wa duvɛn wi ni, mbaa wi derigbɔgɔ ki jori wa ɛrɛzɛn tɔnmɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Wi yɛngɛlɛ ke yaa la yanlagi duvɛn wi kala na, wi ŋgangala ke yaa la finligi nɔnɔ wi kala na. ");
INSERT INTO dyi_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Zabulɔn wo yaa ka cɛn wa kɔgɔje yɔn ki na, wa laga ŋga tɔnmɔkɔɔrɔ ti yaa kaa yeregi. Wi tara ti yaa ka gbɔgɔ mbe gbɔn fɔ wa Sidɔn ca ki na. ");
INSERT INTO dyi_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Isakari wo yɛn paa sofile ŋa wi yɛn fanŋga ni, wi yɛn ma sinlɛ wa yaayoro jasa wi ni. ");
INSERT INTO dyi_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Wìgi yan fɔ wi yɛn ma sinlɛ laga ŋga na na wogo, ki yɛn ma yɔn, fɔ tara tì tanla. Wùu pɔgɔlɔ ke gbɛgɛlɛ tuguro lɛmɛ pi kala na. Wùu yɛɛ kan tunŋgo ki yeri paa kulo yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Dan wo yaa cɛn wi woolo pe go na mbaa pe kiti wi kɔɔn, mbe pye paa Izirayɛli cɛngɛlɛ sanŋgala ke nuŋgba yɛn. ");
INSERT INTO dyi_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan wo yaa ka pye paa wɔɔgɔ yɛn ŋga kì sinlɛ wa konɔ, paa mɛrɛgɛ yɛn, ŋga kì sinlɛ wa konɔ li yɔn na, na singi. Wi yaa ka shɔn wi nɔ wi yenjogo ki na, fɔ shɔn lugufɔ wi wɔ wi to wi jali. ");
INSERT INTO dyi_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","E, Yawe Yɛnŋɛlɛ, na jigi wi yɛn ki na fɔ ma yaa kanla shɔ. ");
INSERT INTO dyi_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«Gadi, maliŋgbɔɔnlɔ ŋgbelege yaa ka yiri mbe to ma na; ɛɛn fɔ, ma yaa ka yiri pe kɔrɔgɔ, mbe to pe na, mbe pe purɔ. ");
INSERT INTO dyi_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«Asɛri, yarilire lɛgɛrɛ yaa ka yiri wa ma yeri, wunlumbolo yarikatanra yaa kaa taa wa ma yeri. ");
INSERT INTO dyi_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«Nɛfitali wo yɛn paa lufaa yɛn ŋa wi yɛn yɛyinŋge na. Wi yaa kaa piile jɛmbɛlɛ siin. ");
INSERT INTO dyi_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«Zhozɛfu wo yɛn paa tige yɛn ŋga ki maa sɛni, ŋga ki yɛn pulugo yɔn na. Ki njere tì yiri ma yagara ma wɛ mbogo na. ");
INSERT INTO dyi_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Sandira wɔnfɛnnɛ pòo yɔn ja, pòo wɔn pe wangala ke ni maa yɛgɛ wɛri. ");
INSERT INTO dyi_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ɛɛn fɔ, wìla wi sandiga ki yigi ŋgbanga, Zhakɔbu Yɛnŋɛlɛ na fanŋga gbɔgɔfɔ li fanŋga na, wi kɛyɛn yìla fanŋga ta. Lo li yɛn Izirayɛli wi kɔnrifɔ ma pye walaga ŋga ki yɛn wi kɛɛ kansaga. ");
INSERT INTO dyi_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ma to wi Yɛnŋɛlɛ lo li yɛn ma sagafɔ, lo na li yɛn yawa pi ni fuun fɔ, lo li yaa duwaw ma na! Mbe duwaw ma na mbe ti tisara mbaa paan mbaa yinrigi wa naayeri! Mbe duwaw ma na mbe ti tɔnmɔ mbaa yinrigi wa tara ti nɔgɔ! Mbe duwaw ma na mbe ti jɛɛlɛ pe pye sevɛnnɛ konaa yaayoro ti lɛgɛ! ");
INSERT INTO dyi_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mi ŋa ma to, duwaw ŋa mì pye ma kan, wì wɛ ŋa na teele pàa pye na kan wi na fɔ ma saa gbɔn wa yanwira nda ti yɛn kɔsagafu ti go na. Yɛnŋɛlɛ sa ti ki duwaw wi tigi Zhozɛfu wi na, wo ŋa wi yɛn wi to seyɛɛnlɛ pe go na, ki duwaw wi tigi wa wi go na! ");
INSERT INTO dyi_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Bɛnzhamɛ wo yɛn paa kombokaga yɛn, ŋga ki ma yanyaraga ka yigi maga kɔɔnlɔ. Pinliwɛ ni, ki ma ki kagboro ti ka; yɔnlɔkɔgɔ, kì yaara nda koli, ki mari yɛɛlɛ.» ");
INSERT INTO dyi_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Poro mbele poro pe yɛn Izirayɛli cɛngɛlɛ kɛ ma yiri shyɛn ŋgele. Pe to wìla duwaw wi pye pe kan ma sɛnrɛ nda yo, tori yɛɛn. Pe ni fuun nuŋgba nuŋgba wìla duwaw pye pe kan, a wì yiri wi yɛ wi yɛ. ");
INSERT INTO dyi_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ko puŋgo, a Zhakɔbu wì sigi sɛnrɛ nda ti yo wi piile pe kan fɔ: «Mi yaa ku mbe taga wa na tɛlɛye mbele pè ku pe na. Na kuŋgɔlɔ, ye sanla le wa na tɛlɛye pe fanga ki ni, wa waliwege ŋga ki yɛn wa Hɛti cɛnlɛ woolo naŋa Efirɔn wi kɛrɛ ki ni, ");
INSERT INTO dyi_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","wa kɛrɛ ti waliwege ki ni, wa Makipela, wa Mamire laga ki tanla, wa Kana tara. Ko kɛrɛ to Abirahamu wìla lɔ Hɛti cɛnlɛ woolo naŋa Efirɔn wi yeri mari pye gboolo lesaga. ");
INSERT INTO dyi_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Pa pàa Abirahamu naa wi jɔ Sara pe le wa, pa pàa Izaki naa wi jɔ Erebeka pe le wa, pa mìla Leya wi le wa fun. ");
INSERT INTO dyi_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kɛrɛ to naa waliwege ŋga ki yɛn wa ti ni, pàa ti lɔ Hɛti cɛnlɛ woolo poro yeri.» ");
INSERT INTO dyi_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Naa Zhakɔbu wìla kaa kɔ wi sɛnyoro ti na wi pinambiile pe kan, a wì si nuru ma sinlɛ, mɛɛ ku ma taga wa wi tɛlɛye pe na. ");
INSERT INTO dyi_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Kona, a Zhozɛfu wì si fɔli wa wi to wi yɛgɛ ki na mɛɛ kɛyɛn wa wi yɔlɔgɔ ma gbele. ");
INSERT INTO dyi_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","A Zhozɛfu wì suu tunmbyeele mbele pàa pye wɛrɛ pyefɛnnɛ pe pye ma yo poo to gboo wi gbegele nuwɔ taanyaara ni (wi ya wi tɛgɛ). A wɛrɛ pyefɛnnɛ pè si nuwɔ taanyaara gbegele Izirayɛli gboo wi na. ");
INSERT INTO dyi_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Pàa ko kala lo pye piliye nafa shyɛn ni, katugu ko piliye yɔn ko ki ma yala pe gboo wi gbegewe pi ni. Ezhipiti tara fɛnnɛ pàa Zhakɔbu kunwɔ pi gbele ma saa gbɔn piliye nafa taanri ma yiri kɛ. ");
INSERT INTO dyi_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Naa kunwɔ pi gbelepiliye yìla kaa toro, a Zhozɛfu wì sigi yo Farawɔn wi go woolo pe kan fɔ: «Na kaa pye na kala li ye ndanla, mila ye yɛnri, ye saga sɛnrɛ nda ti yo Farawɔn wi kan yoo pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‹Sanni na to wi sa ku, wìla na pye ma yo: Wugu mala kan, fɔ ma yaa ka sanla gboo wi le wa fanga ŋga mìla kɔn wa Kana tara ki ni.› Ki kala na, ye konɔ kan na yeri, mbe sanla to gboo wi le, mbe si sɔngɔrɔ mbe pan.» ");
INSERT INTO dyi_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","A pè si saa ki yo Farawɔn wi kan. A wì sho fɔ: «Kari ma sɔɔn to gboo wi le ma yala wuguro nda wìla ti mà wugu ti ni.» ");
INSERT INTO dyi_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","A Zhozɛfu wì si lɛ na kee saa to gboo wi le. Farawɔn wi tunmbyeele, naa wi laga ki lelɛɛlɛ konaa Ezhipiti tara lelɛɛlɛ pe ni fuun pàa pinlɛ wi ni ma kari. ");
INSERT INTO dyi_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Zhozɛfu wi go woolo pe ni fuun, naa wi to seyɛɛnlɛ poro naa wi to go woolo sanmbala pàa kari fun. Pe sila lere wo wa kpɛ yaga wa Goshɛni tara, kaawɔ pe piile jɛɛlɛ jɛɛlɛ poro naa pe simbaala, naa sikaala konaa pe nɛrɛ ti ni. ");
INSERT INTO dyi_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Wotoroye mbele shɔnye maa tile naa pe fevɛnnɛ la pinlɛ Zhozɛfu wi ni fun, a janwa wi lɛgɛ fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Naa pàa ka saa gbɔn wa yarilire sunsaga ŋga pe yinri Atadi ki na, wa Zhuridɛn gbaan wi puŋgo na, a pè si kunwɔ pi pye wa maa gbɔgɔ, maa gbele fɔ jɛŋgɛ. Zhozɛfu wìla wi to kunwɔ pi gbele fɔ pilige kɔlɔshyɛn. ");
INSERT INTO dyi_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ki tara woolo mbele pàa pye Kana tara fɛnnɛ, a pè sigi kunwɔ pyewe pi wele maa yan wa Atadi yarilire sunsaga ki na, ma sho fɔ: «Ki kunwɔ mba pi yɛn ma gbɔgɔ Ezhipiti tara fɛnnɛ pe yeri dɛ!» Ki kala na, ki laga ŋga ki yɛn wa Zhuridɛn gbaan wi puŋgo na, pàa ki mɛgɛ taga naga yinri Abɛli Mizirayimu. ");
INSERT INTO dyi_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ko puŋgo na, a Zhakɔbu wi pinambiile pè sigi pye paa yɛgɛ ŋga na pe to wìla ki yo ma pe kan we. ");
INSERT INTO dyi_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Wi pinambiile pàa wi lɛ ma kari wi ni wa Kana tara, ma saa wi le wa kɛrɛ ti waliwege ki ni, wa Makipela. Abirahamu wo wìla ki kɛrɛ ti lɔ Hɛti cɛnlɛ woolo naŋa Efirɔn wi yeri maga pye gboolo lesaga wa Mamire laga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Naa Zhozɛfu wìla kaa wi to wi le makɔ, a wì si sɔngɔrɔ wa Ezhipiti tara, wo naa wi to seyɛɛnlɛ pe ni, konaa mbele fuun pàa saa wi torogo a wì saa wi to wi le pe ni. ");
INSERT INTO dyi_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Naa Zhozɛfu wi to seyɛɛnlɛ pàa kaa ki yan pe to wì ku, a pè si pe yɛɛ pye fɔ: «Koni, Zhozɛfu wi mbe ya yiri we kɔrɔgɔ mbe kapege ŋga wàa pye wi na ki fɔgɔ tɔn we na.» ");
INSERT INTO dyi_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kona, a, pè si ti a pè saa ki yo Zhozɛfu wi kan fɔ: «Sanni ma to wi sa ku, wìla ki sɛnrɛ nda ti yo ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‹Pa ye yaa para Zhozɛfu wi ni yɛɛn, mbe yo fɔ: Mi yɛn naa yɛnri fɔ kapege naa katijaanga ŋga wi to seyɛɛnlɛ pàa pye wi na, wigi kala yaga pe na; katugu pàa kapege pye wi na! Koni we yɛn nɔɔ yɛnri, woro mbele we yɛn ma to wi Yɛnŋɛlɛ li tunmbyeele, ma we kapere ti kala yaga we na.› » Naa pàa ka saa ki sɛnrɛ ti yo Zhozɛfu wi kan, a wì si gbele. ");
INSERT INTO dyi_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ko puŋgo na, a wi to seyɛɛnlɛ pè si kari pe yɛ ma saa fɔli wi yɛgɛ sɔgɔwɔ ma yo fɔ: «We mbele, we yɛn ma kulolo.» ");
INSERT INTO dyi_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ɛɛn fɔ, a Zhozɛfu wì si pe pye fɔ: «Yaga ka fyɛ, ko mbe pye muwi mi yɛn wa Yɛnŋɛlɛ li yɔnlɔ le? ");
INSERT INTO dyi_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yoro laga sɔnri mbe kapege pye na na, a Yɛnŋɛlɛ lì sigi kapege ki kanŋga kajɛŋgɛ mbe ta mbe ŋga kila piin nala ki yɔn fili, mbe lelɛgɛrɛ go shɔ. ");
INSERT INTO dyi_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Koni yaga ka fyɛ, mi yaa la ye kaan yaa kaa yoro naa ye piile.» A wì si pe kotoro ti sogo pe na sɛntanra ni. ");
INSERT INTO dyi_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Zhozɛfu wìla cɛn wa Ezhipiti tara wo naa wi go woolo pe ni. Wìla ta yɛlɛ cɛnmɛ ma yiri kɛ (110). ");
INSERT INTO dyi_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Zhozɛfu wìla wi pinambyɔ Efirayimu wi pishyɛnwoolo pe piile pe yan yɛnlɛ ni. Wìla wi pinambyɔ Manase wi pishyɛnwoo Makiri wi piile pe lɛ ma pe koro. ");
INSERT INTO dyi_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Pilige ka, a Zhozɛfu wì suu to seyɛɛnlɛ pe pye fɔ: «Sanni jɛnri, mi yaa ku! Ɛɛn fɔ, Yɛnŋɛlɛ li yaa la wele ye na, ki woro nala kɔɔn shyɛn. Li yaa ka ti ye yiri laga ki tara nda ti ni, mbe sɔngɔrɔ ye ni wa tara nda làa wugu ma yo li yaa kan Abirahamu, naa Izaki, konaa Zhakɔbu pe yeri ti ni.» ");
INSERT INTO dyi_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Zhozɛfu wì si ti a Izirayɛli pinambiile pe wugu maa kan mbe ŋga wi yaa yo ki pye. Wìla pe pye fɔ: «Yɛnŋɛlɛ li yaa la wele ye na, ki woro nala kɔɔn shyɛn. Na yaga kaa kee sanga ŋa ni, yanla kajeere ti lɛ ye kari ti ni, yeri wɔ laga.» ");
INSERT INTO dyi_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Zhozɛfu wìla ta yɛlɛ cɛnmɛ ma yiri kɛ mɛɛ ku (110). A pè suu gboo wi gbegele nuwɔ taanyaara ni, maa le gboolo kɛsu wa ni wa Ezhipiti tara.");
INSERT INTO dyi_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Izirayɛli ŋa pe yinri fun Zhakɔbu wi pinambiile mbele pàa pinlɛ wi ni ma kari wa Ezhipiti tara, pe mɛrɛ ti nda. Pe ni fuun nuŋgba nuŋgba pàa kari naa pe go woolo. ");
INSERT INTO dyi_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Urubɛn, naa Simeyɔn, naa Levi, naa Zhuda, ");
INSERT INTO dyi_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","naa Isakari, naa Zabulɔn, naa Bɛnzhamɛ, ");
INSERT INTO dyi_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","naa Dan, naa Nɛfitali, naa Gadi konaa Asɛri. ");
INSERT INTO dyi_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Zhakɔbu wi setirige piile mbele pàa kari wa Ezhipiti tara pe ni fuun pàa pye lere nafa taanri ma yiri kɛ. Wi pinambyɔ Zhozɛfu wo la pye wa Ezhipiti tara makɔ. ");
INSERT INTO dyi_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Naa kìla kaa mɔ, a Zhozɛfu wì si kaa ku, naa wi to seyɛɛnlɛ pe ni, konaa ki wagati woolo pe ni fuun pe ni. ");
INSERT INTO dyi_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ɛɛn fɔ, a Izirayɛli cɛnlɛ woolo pè si pye sevɛnnɛ, ma se ma lɛgɛ fɔ jɛŋgɛ, ma Ezhipiti tara ti yin, mɛɛ pye fanŋga ni. ");
INSERT INTO dyi_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","A wunlunaŋa fɔnŋɔ si kaa cɛn Ezhipiti tara ti go na, wo sila Zhozɛfu kala lo la kpɛ jɛn. ");
INSERT INTO dyi_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","A wì suu woolo pe pye fɔ: «Ye wele, Izirayɛli cɛnlɛ woolo pè lɛgɛ jɛŋgɛ ma wɛ we na, ma fanŋga ta ma wɛ we na. ");
INSERT INTO dyi_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ye pan we yigisaga ja pe wogo ki na tijinliwɛ ni, nakoma pe yaa ka lɛgɛ mbe toro. Na malaga ka ka to laga we na, pa pe yaa pinlɛ we mbɛnfɛnnɛ pe ni mbe malaga gbɔn we ni mbe ya we ni, mbe si wɔ laga tara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kì kaa pye ma, a pè si kulowo tunŋgo teele tɛgɛtɛgɛ Izirayɛli woolo pe go na, jaŋgo mbe pe yɛgɛ wɛri tunŋgbanra ni. Kì pye ma, a pè si Pitɔmu naa Aramisɛsi cara ti kan Farawɔn wi kan, a tì pye wi yarijɛndɛ tɛgɛsara. ");
INSERT INTO dyi_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ɛɛn fɔ, ali maga ta pàa pye na Izirayɛli woolo pe jɔlɔ na kee yɛgɛ, pàa pye na lege na seregi, fɔ a Ezhipiti tara fɛnnɛ pè Izirayɛli woolo pe panra. ");
INSERT INTO dyi_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Kì pye ma, Ezhipiti tara fɛnnɛ pàa Izirayɛli woolo pe le kulowo tunŋgo ŋgbanga ni. ");
INSERT INTO dyi_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Pàa pe yɛgɛ wɛri tunŋgbanra ti ni: joro tunŋgo, naa tofa kɔnwɔ konaa kɛɛrɛ tunndo ti cɛnlɛ pyew ti ni. Pàa kulowo tunŋgo cɛnlɛ pyew ki wɛ pe na fɔ tipege. ");
INSERT INTO dyi_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","A Ezhipiti tara wunlunaŋa wì si para jɛɛlɛ shyɛn mbele pàa pye na Eburuye jɛɛlɛ pe sari paa siin pe ni. Pàa pye na nuŋgba yinri Shifira, na sanŋa wi yinri Puwa. ");
INSERT INTO dyi_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Wìla pe pye fɔ: «Na ye kaa Eburuye jɛɛlɛ pe sari paa siin sanga ŋa ni, ye pyɔ wi wele jɛŋgɛ yoo jɛn wa sesaga, na wiga pye naŋa, yoo gbo; na wiga pye jɛlɛ, yoo yaga yinwege na.» ");
INSERT INTO dyi_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ɛɛn fɔ, jɛɛlɛ mbele pàa pye na Eburuye jɛɛlɛ pe sari paa siin pàa pye na fyɛ Yɛnŋɛlɛ li yɛgɛ. Pe sila Ezhipiti tara wunlunaŋa wi sɛnrɛ ti lɛ. Pàa pye na pinambiile pe yari yinwege na. ");
INSERT INTO dyi_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kona, a Ezhipiti tara wunlunaŋa wì si pe yeri mɛɛ pe pye fɔ: «Yiŋgi na a yè sigi pye yɛɛn ma pinambiile pe yaga yinwege na?» ");
INSERT INTO dyi_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mbele pàa pye na jɛɛlɛ pe sari paa siin, a pè si Farawɔn wi yɔn sogo ma yo fɔ: «Eburuye jɛɛlɛ pe woro paa Ezhipiti tara fɛnnɛ jɛɛlɛ pe yɛn. Pe yɛn kotogo ni, pe ma keli ma se sanni we sa gbɔn wa pe na.» ");
INSERT INTO dyi_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","A Izirayɛli cɛnlɛ woolo pè si se ma lɛgɛ fɔ jɛŋgɛ ma fanŋga ta. A Yɛnŋɛlɛ lì si kajɛŋgɛ pye mbele pàa pye na jɛɛlɛ pe sari paa siin pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Yɛnŋɛlɛ làa pe go woolo pe pye a pè lɛgɛ, katugu pàa Yɛnŋɛlɛ li jate. ");
INSERT INTO dyi_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kì kaa pye ma, a Farawɔn wì sigi konɔ na li kan wi tara woolo pe ni fuun pe yeri ma yo fɔ: «Paga Eburuye pinambyɔ ŋa se, yoo wa wa Nili gbaan wi ni, ɛɛn fɔ, ye pe sumborombiile pe ni fuun pe yaga yinwege na.» ");
INSERT INTO dyi_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ki sanga wi ni, Levi setirige woolo naŋa wà si ki setirige nuŋgba ki jɛlɛ wa pɔri wi jɔ. ");
INSERT INTO dyi_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","A ki jɛlɛ wì si kugbɔ lɛ mɛɛ pinambyɔ se, ma sigi yan fɔ pyɔ wi yɛn ma yɔn. A wì suu lara ma saa gbɔn fɔ yeyɛn taanri. ");
INSERT INTO dyi_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ko puŋgo na, wii ya mbaa wi lara naa, a wì si kanjapige ti gbɛgɛwɛ ni, maga nawa pi wɔlɔgɔ fɛnrɛgɛ naa ŋguro joro ni (jaŋgo tɔnmɔ ka ya ye wa ki ni), mɛɛ pyɔ wi le wa ki ni ma saa ki tɛgɛ wa gbagara wi sɔgɔwɔ wa gbaan wi koŋgo tɔnmɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","A pyɔ wi njɔ wì si saa yere laga ka na, mbe ta mbe ŋga ki yaa pye pyɔ wi na ki yan. ");
INSERT INTO dyi_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ko puŋgo na, a Farawɔn wi sumborombyɔ wì si kari wa gbaan wi ni mbe sa woli. A wi pinlɛyɛɛnlɛ poro nɛɛ yanriyanri na toro gbaan wi koŋgo ki na. A Farawɔn wi sumborombyɔ wì si kanjapige ki yan wa gbagara wi sɔgɔwɔ, mɛɛ wi tunmbyee jɛlɛ wi tun ma yo wi saga lɛ wi pan ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kì kaa pan, a wì sigi yɛngɛ mɛɛ pyɔ wi yan wa. Pinambyɔ lawi, wìla pye na gbele. A wi yinriwɛ suu ta, a wì sho fɔ: «Eburuye pe pyɔ wo wawi ŋa!» ");
INSERT INTO dyi_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kona, a pyɔ wi njɔ wì si Farawɔn sumborombyɔ wi pye fɔ: «Maa jaa mbe sa Eburuye jɛlɛ wa yeri wi pan wila pyɔ wi kaan wila wɔnri le?» ");
INSERT INTO dyi_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","A Farawɔn sumborombyɔ wì sho fɔ: «Ee.» A sumborombyɔ wì si kari ma saa pyɔ wi nɔ jate wi lagaja ma pan wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","A Farawɔn sumborombyɔ wì si jɛlɛ wi pye fɔ: «Ki pyɔ ŋa wi lɛ ma saa wi kaan wila wɔnri na kan, mi yaa kɔɔn sara ki wogo ki na.» A jɛlɛ wì si pyɔ wi lɛ ma saa naa kaan wila wɔnri. ");
INSERT INTO dyi_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Naa pyɔ wìla kaa yɛgɛ to, a nɔfɔ wì si pan maa kan Farawɔn sumborombyɔ wi yeri, a wùu pye wi pinambyɔ. A wì suu mɛgɛ ki taga naa yinri Moyisi, ma yo fɔ: Katugu mùu tile maa wɔ tɔnmɔ. ");
INSERT INTO dyi_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Naa Moyisi wìla kaa yiri ma yɛgɛ to, pilige ka, a wì si yiri ma kari wa wi cɛnlɛ woolo pe yeri, mɛɛ saa pe tunŋgbanra ti yan. A wì si Ezhipiti tara fɛnnɛ woo wa yan wila wi cɛnlɛ woolo Eburuye naŋa wa gbɔɔn. ");
INSERT INTO dyi_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","A wì si welewele maa yɛɛ maga, wii lere yan. A wì si Ezhipiti tara fɛnnɛ naŋa wi gbɔn maa gbo, mɛɛ wi lara wa taambugɔ ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ki goto, a wì si kari naa mɛɛ saa Eburuye nambala shyɛn yan paa wiin. A wì si ŋa wogo kì pɛn wi yewe ma yo fɔ: «Yiŋgi na, a ma nɛɛ ma sefɔ wi gbɔɔn?» ");
INSERT INTO dyi_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","A ki naŋa wì suu pye fɔ: «Ambɔ wɔ̀ɔn tɛgɛ we go na ma pye we kiti kɔnfɔ? Maa jaa mbanla gbo paa yɛgɛ ŋga na màa Ezhipiti tara fɛnnɛ naŋa wi gbo wi le?» A Moyisi wì si fyɛ ma suu yɛɛ pye fɔ: «Kaselege kona, lere ŋa mì gbo pège wogo ki jɛn.» ");
INSERT INTO dyi_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Farawɔn wìla ŋga kìla pye ki logo, a wi nɛɛ Moyisi wi lagajaa mboo gbo. Ɛɛn fɔ, a Moyisi wì si fe ma kari ma saa cɛn wa Madiyan tara ma lali Farawɔn wi ni. Wìla pye ma cɛn kɔlɔ wa tanla. ");
INSERT INTO dyi_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Wa Madiyan tara, saraga wɔfɔ wà la pye wa, wi sumborombiile pàa pye kɔlɔshyɛn. Pàa pan ma ko ma yaayoro wɔyaara ti yinyin, mbe pe to wi simbaala naa sikaala pe kan pe wɔ. ");
INSERT INTO dyi_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ɛɛn fɔ, a yaayoro kɔnrifɛnnɛ pèle si pan le, mɛɛ sumborombiile pe purɔ. Kona, a Moyisi wì si yiri pe kɔrɔgɔ ma saga sumborombiile pe na, mɛɛ pe yaayoro ŋgbelege ki kan, a kì wɔ. ");
INSERT INTO dyi_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Naa sumborombiile pàa kaa sɔngɔrɔ ma gbɔn wa pe to Erewuwɛli wi tanla, a wì si pe yewe ma yo fɔ: «Yiŋgi na, a yè si pan faa nala?» ");
INSERT INTO dyi_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","A pè suu yɔn sogo ma yo fɔ: «Ezhipiti tara fɛnnɛ naŋa wawi wì we shɔ yaayoro kɔnrifɛnnɛ pe yeri. Wì yɛrɛ ko we kan ma we yaayoro ŋgbelege ki kan, a kì wɔ.» ");
INSERT INTO dyi_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","A pe to wì si pe yewe ma yo fɔ: «Ki naŋa wi yɛn se yeri? Yiŋgi na, a yè si pan maa yaga wa? Ye saa yeri wa, wi pan we li.» ");
INSERT INTO dyi_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","A Moyisi wì si yɛnlɛ ki na mbe cɛn wa ki naŋa wi yeri; a wì suu sumborombyɔ Sefora wi kan Moyisi wi yeri wi jɔ. ");
INSERT INTO dyi_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","A Sefora wì si kugbɔ lɛ ma pinambyɔ se, a Moyisi wì suu mɛgɛ taga naa yinri Gɛrishɔmu; katugu wìla yo fɔ: «Mi yɛn nambanŋa ma cɛn tateere ni.» ");
INSERT INTO dyi_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Naa kìla kaa mɔ, a Ezhipiti tara wunlunaŋa wì si ku. Izirayɛli cɛnlɛ woolo pàa pye na jɛɛn na gbele bere pe kulowo tunŋgbanra ti kala na. A pe gbelege kì si gbɔn fɔ wa Yɛnŋɛlɛ li na. ");
INSERT INTO dyi_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","A Yɛnŋɛlɛ lì si pe gbeere ti logo, mɛɛ jatere pye yɔn finliwɛ mba làa le Abirahamu, naa Izaki konaa Zhakɔbu pe ni pi na. ");
INSERT INTO dyi_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","A Yɛnŋɛlɛ lì si Izirayɛli woolo pe wele, mɛɛ pe cɛnlɔmɔ pi yan maa jɛn. ");
INSERT INTO dyi_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moyisi wìla pye naa nafɔ Zheturo wi simbaala naa sikaala pe kɔnri wi kan. Zheturo wìla pye Madiyan tara saraga wɔfɔ. Pilige ka, a Moyisi wì si kari yaayoro ti ni wa gbinri wi puŋgo na, ma saa gbɔn wa Yɛnŋɛlɛ li yanwiga ŋga pe yinri Horɛbu ki na. ");
INSERT INTO dyi_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","A Yawe Yɛnŋɛlɛ li Mɛrɛgɛ wì suu yɛɛ naga wi na kasɔn yinnɛ la ni tipile la sɔgɔwɔ. A Moyisi wì sigi wele maga yan fɔ tipile li lagapyew kìla pye kasɔn ni, ɛɛn fɔ, tipile jate li sila pye na sori. ");
INSERT INTO dyi_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","A wì sho fɔ: «Mi yaa fulo wa mbe saga kafɔnnɔ na li wele mbege jɛn yiŋgi na tipile li si woro na sori.» ");
INSERT INTO dyi_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Naa Yawe Yɛnŋɛlɛ làa kaa wi yan wi yɛn na fulo wa mbe sa wele, a lì si koro wa tipile li sɔgɔwɔ maa yeri, ma yo fɔ: «Moyisi, Moyisi.» A Moyisi wì si shɔ ma yo fɔ: «Naw.» ");
INSERT INTO dyi_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","A Yɛnŋɛlɛ lì sho fɔ: «Maga ka fulo laga ki laga ŋga ki ni. Ma sawira ti wɔ wa ma tɔɔrɔ ti na, katugu ma yɛn ma yere laga ŋga na, ki tara ti yɛn kpoyi na yɛgɛ na.» ");
INSERT INTO dyi_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","A lì sho naa fɔ: «Muwi mi yɛn ma to wi Yɛnŋɛlɛ le, Abirahamu, naa Izaki konaa Zhakɔbu pe Yɛnŋɛlɛ le.» A Moyisi wì suu yɛgɛ ki tɔn, katugu wìla pye na fyɛ mbe Yɛnŋɛlɛ li wele. ");
INSERT INTO dyi_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","A Yawe Yɛnŋɛlɛ lì sho fɔ: «Na woolo mbele wa Ezhipiti tara, mì pe jɔlɔgɔ ki yan, gbeere nda paa gbele pe jɔlɔfɛnnɛ pe kɛɛ, mìri logo. Mì pe tere ti jɛn. ");
INSERT INTO dyi_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Mì pan mbe pe shɔ Ezhipiti tara fɛnnɛ pe kɛɛ, mbe pe yirige laga, mbe kari pe ni tara ta ni, nda tì yɔn ma gbɔgɔ, ma yin nɔnɔ naa sɛnrɛgɛ ni na fuun. Kana tara fɛnnɛ, naa Hɛti cɛnlɛ woolo, naa Amɔri cɛnlɛ woolo, naa Perɛzi cɛnlɛ woolo, naa Hɛvi cɛnlɛ woolo konaa Zhebusi cɛnlɛ woolo pe tara tori. ");
INSERT INTO dyi_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Wele, Izirayɛli woolo pe gbeere tì gbɔn laga na na, Ezhipiti tara fɛnnɛ paa pe jɔlɔ yɛgɛ ŋga na, mìgi yan. ");
INSERT INTO dyi_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Koni, ta kee, mila ma tunnu Farawɔn wi yeri. Ma sa Izirayɛli, na woolo pe pye pe yiri wa Ezhipiti tara.» ");
INSERT INTO dyi_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Kona, a Moyisi wì si Yɛnŋɛlɛ li pye fɔ: «Mi we? Ko lere ma mi, mbe kari sa Farawɔn wi yan, mbe Izirayɛli woolo pe pye pe yiri wa Ezhipiti tara.» ");
INSERT INTO dyi_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","A Yɛnŋɛlɛ lì sho fɔ: «Mi yaa pye ma ni. Tɛgɛrɛ nda ti yaa ki naga ma na mbe yo mi jate mila ma tunnu ti nda: ‹Na maga ka Izirayɛli woolo pe yirige wa Ezhipiti tara, ye ni fuun ye pan yanla gbɔgɔ laga ki yanwiga ŋga ki na.› » ");
INSERT INTO dyi_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","A Moyisi wì si Yɛnŋɛlɛ li pye fɔ: «Kì kaa pye yɛɛn, mi yaa kari wa Izirayɛli woolo pe yeri saga yo pe kan fɔ ye tɛlɛye pe Yɛnŋɛlɛ lìlan tun ye yeri. Ɛɛn fɔ, na paga na yewe li mɛgɛ ki ni, mi yaa yo mɛlɛ?» ");
INSERT INTO dyi_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","A Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Muwi mi yɛn ŋa wi yɛn.» Maga yo Izirayɛli woolo pe kan fɔ ŋa pe yinri «Mi yɛn» wìlan tun ye yeri. ");
INSERT INTO dyi_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","A Yɛnŋɛlɛ lì suu pye naa fɔ: «Maga yo Izirayɛli woolo pe kan fɔ: ‹Yawe Yɛnŋɛlɛ, ye tɛlɛye pe Yɛnŋɛlɛ le, Abirahamu, naa Izaki konaa Zhakɔbu pe Yɛnŋɛlɛ le, lo lìlan tun ye yeri.› Ko ki yɛn na mɛgɛ ye fɔ sanga pyew. Ko mɛgɛ koyi wagati wi ni fuun woolo pe mbe ya mbaa na yinri ki na. ");
INSERT INTO dyi_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Koni, kari ma sa Izirayɛli lelɛɛlɛ pe gbogolo, ma pe pye fɔ: ‹Yawe Yɛnŋɛlɛ, ye tɛlɛye pe Yɛnŋɛlɛ le, lìli yɛɛ naga na na. Lo na li yɛn Abirahamu, naa Izaki konaa Zhakɔbu pe Yɛnŋɛlɛ le.› Lìlan pye fɔ: ‹Mì pan mbe wele ye na, katugu ŋga paa piin ye na wa Ezhipiti tara, mìgi yan. ");
INSERT INTO dyi_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mi yaa ka ye yirige mbe ye wɔ wa jɔlɔgɔ ki ni, wa Ezhipiti tara, mbe kari ye ni wa Kana tara fɛnnɛ, naa Hɛti cɛnlɛ woolo, naa Amɔri cɛnlɛ woolo, naa Perɛzi cɛnlɛ woolo, naa Hɛvi cɛnlɛ woolo konaa Zhebusi cɛnlɛ woolo pe tara ti ni. Ki tara ti yɛn ma yin nɔnɔ naa sɛnrɛgɛ ni na fuun.› ");
INSERT INTO dyi_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Izirayɛli lelɛɛlɛ pe yaa ka logo ma yeri. Kona, mboro naa poro ni, ye kari wa Ezhipiti tara wunlunaŋa wi yeri, ye saa pye fɔ: ‹Yawe Yɛnŋɛlɛ, woro Eburuye, we Yɛnŋɛlɛ le, lìli yɛɛ naga we na. Koni, konɔ kan we yeri, we piliye taanri tangala tanga wa gbinri wi ni, we sa saara wɔ Yawe Yɛnŋɛlɛ li yeri.› ");
INSERT INTO dyi_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Mìgi jɛn ma yo Ezhipiti tara wunlunaŋa wi se yɛnlɛ mbe ye yaga ye kari, kaawɔ poo jori fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mi yaa kanla fanŋga ki naga Ezhipiti tara fɛnnɛ pe na, mbe pe jɔlɔ kafɔnŋgɔlɔ cɛngɛlɛ ŋgele fuun mi yaa pye wa pe sɔgɔwɔ ke ni. Ko puŋgo na, pa wi yaa ye yaga ye kari. ");
INSERT INTO dyi_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Mi yaa ka ti ye kala li Ezhipiti tara fɛnnɛ pe ndanla, jaŋgo yaga kaa kee sanga ŋa ni, yaga ka kari kɛwara. ");
INSERT INTO dyi_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ye jɛɛlɛ pe ni fuun nuŋgba nuŋgba pe tɛ yaara, naa warifuwe yaara konaa yaripɔrɔ yɛnri pe cɛnyɛɛnlɛ, Ezhipiti tara woolo pe yeri, konaa jɛɛlɛ mbele pe yɛn pe ni wa pe yinrɛ ti ni pe yeri; yeri le ye pinambiile naa ye sumborombiile pe na. Pa ye yaa Ezhipiti tara fɛnnɛ pe kɛɛ yaara ti koli pe yeri yɛɛn.» ");
INSERT INTO dyi_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Kona, a Moyisi wì si Yawe Yɛnŋɛlɛ li yɔn sogo ma yo fɔ: «Wele, Izirayɛli woolo pe se taga na sɛnrɛ ti na, pe se si logo na yeri. Ɛɛn fɔ, pe yaa na pye mbe yo fɔ: ‹Yawe Yɛnŋɛlɛ li sili yɛɛ naga ma na.› » ");
INSERT INTO dyi_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","A Yawe Yɛnŋɛlɛ lì suu yewe ma yo fɔ: «Yiŋgi ki yɛn ma kɛɛ?» A Moyisi wì sho fɔ: «Kanŋgala li.» ");
INSERT INTO dyi_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","A lì suu pye ma yo: «Li wa le tara.» A Moyisi wì sili wa le tara, a lì si kanŋga ma pye wɔɔgɔ. A Moyisi wì si fe wɔɔgɔ ki yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Ma kɛɛ ki sanga ma wɔɔgɔ ki yigi wa ki naga ki na.» A Moyisi wì suu kɛɛ ki sanga maga yigi. A wɔɔgɔ kì si kanŋga ma pye naa kanŋgala wa wi kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","A Yawe Yɛnŋɛlɛ lì sho fɔ: «Maga wogo ŋga ki pye, jaŋgo Izirayɛli woolo pe taga ki na fɔ mìlan yɛɛ naga ma na, mi ŋa pe tɛlɛye pe Yɛnŋɛlɛ le, Abirahamu, naa Izaki konaa Zhakɔbu pe Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","A Yawe Yɛnŋɛlɛ lì suu pye naa fɔ: «Ma kɛɛ ki taga wa ma kotogo ki na, wa ma yaripɔgɔ ki nɔgɔ.» A wì sigi taga wa wi kotogo ki na. Naa wìla kaa ki tile maga wɔ, a wi kɛɛ kì si filige pow yayɛnwɛ pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","A lì suu pye naa fɔ: «Ma kɛɛ ki sɔngɔrɔ maga taga wa ma kotogo ki na.» A wì sigi sɔngɔrɔ naa maga taga wa wi kotogo ki na. A kì si kanŋga ma pye naa paa wi witige ki yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","A Yawe Yɛnŋɛlɛ lì sho fɔ: «Na Izirayɛli woolo pee taga ma sɛnrɛ ti na, mbe kafɔnnɔ koŋgbanna li jate, pa pe yaa taga ti na kafɔnnɔ shyɛn wolo lo kala na. ");
INSERT INTO dyi_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Na pee taga ma sɛnrɛ ti na ki kafɔnŋgɔlɔ shyɛn ke kala na, na pee si logo ma yeri, pa ma Nili gbaan tɔnmɔ pa ko, maa wo tara ti na. Ki tɔnmɔ mba ma yaa ko mbe wo, pi yaa kanŋga kasanwa wa tara ti na.» ");
INSERT INTO dyi_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","A Moyisi wì sili pye fɔ: «Ayoo we Fɔ, yɔn tangafɔ ma mi, yunmbaan ma ki peli, kii si peli piliya ki na, ki yɛrɛ si peli malɛ ma yɛn na para mi ŋa ma kulonaŋa na ni. Na yɔn ki yɛn ma nugu na na.» ");
INSERT INTO dyi_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","A Yawe Yɛnŋɛlɛ lì suu pye fɔ: «Ambɔ wì lere wi yɔn ki kan wi yeri? Ambɔ wi ma lere wi pye bombo nakoma nuŋgbojili, mboo pye wila yaan nakoma mboo pye fyɔɔn? Mi ŋa Yawe Yɛnŋɛlɛ mi ma wi le? ");
INSERT INTO dyi_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Koni, ta kee san, mi yaa ka pye ma ni, na ma ka kaa para we. Sɛnrɛ nda ma yaa kaa yuun, mi yaa kaa ti nari ma na.» ");
INSERT INTO dyi_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","A Moyisi wì sho fɔ: «Mila ma yɛnri we Fɔ, lere wa yɛgɛ tun, ŋa kɔɔn ndanla.» ");
INSERT INTO dyi_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kona, a Yawe Yɛnŋɛlɛ lì si nawa ŋgban Moyisi wi ni, ma suu pye fɔ: «Ma ndɔ Arɔn, wo ŋa wi yɛn fun Levi setirige pyɔ, wi woro wa le? Mìgi jɛn ma yo yɔn tangafɔ wi. Wo jate, wi ŋa yɛrɛ wila paan ma filisaga. Na wiga kɔɔn yan sanga ŋa ni, wi nawa pi yaa yinŋgi wi na fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ma yaa ka para wi ni mbe sɛnrɛ nda wi daga mbe yo ti le wi yɔn. Mi jate mi yaa ka pye ye ni fuun nuŋgba nuŋgba ye ni, na ye ka kaa para we. Ŋga ye yaa ka pye, mi yaa kaga naga ye na. ");
INSERT INTO dyi_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Wo wi yaa kaa para leele pe ni ma yɔnlɔ. Wi yaa kaa ma yɔn sɛnrɛ ti yuun pe kan. Ma yaa ka pye wi yeri paa Yɛnŋɛlɛ yɛn, mbaa sɛnrɛ ti nii wi yɔn. ");
INSERT INTO dyi_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ki kanŋgala na, li lɛ mali yigi ma kɛɛ; lo ma yaa la kafɔnŋgɔlɔ ke piin li ni.» ");
INSERT INTO dyi_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Kona, a Moyisi wì si sɔngɔrɔ ma kari wa wi nafɔ Zheturo wi yeri, mɛɛ wi pye fɔ: «Mi yaa sɔngɔrɔ wa na cɛnlɛ woolo pe yeri wa Ezhipiti tara, mbe sa pe wele na kaa pye pe yɛn wa yinwege na bere.» A Zheturo wì si Moyisi wi pye fɔ: «Ta kee yɛyinŋge na.» ");
INSERT INTO dyi_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ma Moyisi wi ta wa Madiyan tara, a Yawe Yɛnŋɛlɛ lì suu pye fɔ: «Sɔngɔrɔ ma kari wa Ezhipiti tara, katugu mbele fuun pàa pye na jaa mbɔɔn gbo pè ku.» ");
INSERT INTO dyi_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kì kaa pye ma, a Moyisi wì suu jɔ naa wi pinambiile pe lɛ, ma ti a pè lugu sofilele na, mɛɛ sɔngɔrɔ wa Ezhipiti tara. Kanŋgala na Yɛnŋɛlɛ làa yo wi lɛ, a wì sili lɛ. ");
INSERT INTO dyi_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Na ma kaa sɔngɔri la kee wa Ezhipiti tara, kafɔnŋgɔlɔ ŋgele fuun mì fanŋga ki kan ma yeri maa ke piin, ma ke pye Farawɔn wi yɛgɛ na. Mi yaa wi kotogo ki pye ki ŋgban wi na; pa wi se yɛnlɛ mbe Izirayɛli woolo pe yaga pe kari. ");
INSERT INTO dyi_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Maga yo Farawɔn wi kan fɔ: ‹Pa Yawe Yɛnŋɛlɛ lì yo yɛɛn fɔ: Izirayɛli woolo pe yɛn paa na pinambyɔ yɛn, paa na pinambyɔ koŋgbanŋa yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Mila ki yuun ma kan fɔ: Mala pinambyɔ wi yaga wi kari wi sanla gbɔgɔ. Na maga je mbe yo wiga ka kari, pa mi yaa ti ma pinambyɔ wi ku, ma pinambyɔ koŋgbanŋa we.› » ");
INSERT INTO dyi_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ma pe ta pe kondangala li na paa kee, a pè si saa yere laga ka ni yembinɛ la ni mbe wɔnlɔ le. A Yawe Yɛnŋɛlɛ lì si pan Moyisi wi kɔrɔgɔ na jaa mboo gbo. ");
INSERT INTO dyi_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","A wi jɔ Sefora wì si sinndɛlɛgɛ ka lɛ, ŋga ki yɔn kìla pye ma tanla, maa pinambyɔ wi kɛnrɛkɛnrɛ, mɛɛ ki sɛlɛgɛ ki jiri wa Moyisi wi nama pi na, ma sho fɔ: «Ma yɛn na pɔlɔ, kasanwa po kala na.» ");
INSERT INTO dyi_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","A Yawe Yɛnŋɛlɛ lì si Moyisi wi yaga li suu gbo. Sefora wìla yo fɔ: «Na pɔlɔ kasanwa po kala na», kɛnrɛkɛnrɛ ŋa wìla pye wo kala na. ");
INSERT INTO dyi_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ko sanga wo ni, a Yawe Yɛnŋɛlɛ lì si Arɔn wi pye fɔ: «Kari ma sa Moyisi wi fili wa gbinri wi ni.» A Arɔn wì si kari ma saa Moyisi wi fili wa Yɛnŋɛlɛ li yanwiga ki na, mɛɛ kɛyɛn wa wi yɔlɔgɔ maa shari. ");
INSERT INTO dyi_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Yawe Yɛnŋɛlɛ làa Moyisi wi tun sɛnrɛ nda fuun ni, a wì si ti ni fuun ti yo Arɔn wi kan, konaa kafɔnŋgɔlɔ ŋgele fuun làa yo wi pye ke ni. ");
INSERT INTO dyi_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","A Moyisi naa Arɔn pè si kari ma saa Izirayɛli lelɛɛlɛ pe ni fuun pe gbogolo. ");
INSERT INTO dyi_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","A Arɔn wì si sɛnrɛ nda fuun Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan ti yɛgɛ yo ma pe kan, mɛɛ kafɔnŋgɔlɔ ke pye le pe yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","A Izirayɛli woolo pè si taga ki sɛnrɛ ti na. A pè sigi jɛn ma yo Yawe Yɛnŋɛlɛ làa pe jɔlɔgɔ ki yan, fɔ lì pan mbe pe shɔ. Kona, a pè si fɔli ma pe yɛrɛ ti jiile wa tara mali gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ko puŋgo na, a Moyisi naa Arɔn pè si kari wa Farawɔn wi yeri, ma suu pye fɔ: «Yawe Yɛnŋɛlɛ, woro Izirayɛli woolo we Yɛnŋɛlɛ le, pa lì yo yɛɛn, fɔ: ‹Na woolo pe yaga pe sa fɛti pye panla gbɔgɔ wa gbinri wi ni.› » ");
INSERT INTO dyi_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","A Farawɔn wì sho fɔ: «Yawe Yɛnŋɛlɛ lo yɛn ambɔ, jaŋgo mbeli sɛnrɛ ti logo, mbe si Izirayɛli woolo pe yaga paa kee? Mi sili jɛn, mi se Izirayɛli woolo pe yaga fyew paa kee.» ");
INSERT INTO dyi_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","A Moyisi naa Arɔn pè si Farawɔn wi pye fɔ: «Woro Eburuye we Yɛnŋɛlɛ le, lìli yɛɛ naga we na. Ki kala na, ki yaga we piliye taanri tangala tanga wa gbinri wi ni, we sa saara wɔ Yawe Yɛnŋɛlɛ, we Yɛnŋɛlɛ li yeri, jaŋgo liga ka tifɛlɛgɛ yama wa we na pi we gbo nakoma malaga mbe to we na.» ");
INSERT INTO dyi_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","A Ezhipiti tara wunlunaŋa wì si Moyisi naa Arɔn pe pye fɔ: «Yiŋgi na, a ye nɛɛ leele pe go jogo na pe lari pe tunŋgo ki na? Ye sɔngɔrɔ ye saa ye tunndo ti piin.» ");
INSERT INTO dyi_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","A Farawɔn wì sho naa fɔ: «Koni, ki leele mbele pè lɛgɛ laga tara ti ni, ko ye yɛn na jaa mbe pe tunndo ti yerege!» ");
INSERT INTO dyi_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ki pilige nuŋgba ki ni, a Farawɔn wì sigi konɔ na li kan jɔlɔgɔ tunŋgo teele poro naa Izirayɛli woolo mbele pàa pye tunŋgo welefɛnnɛ pe yeri ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Yaga kaa yan kaan naa Izirayɛli woolo pe yeri paa tofa wi kɔɔn, paa yɛgɛ ŋga na ye maa ki piin faa we. Poro jate paa kee pe saa yan ka lagajaa pe yɛɛ kan. ");
INSERT INTO dyi_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Konaa ki ni fuun, yege ŋgban pe na, paa tofa yɔn ŋga pe maa kɔɔn faa ki kɔɔn. Yaga ka ti ka mbe kɔn wa ki yɔn ki na; katugu tiyanmbala wɛlɛ, ko kala na pè yo poro yaa sa saara wɔ pe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ye ka taga ki leele pe tunŋgo ki na, tunŋgo ki pe kɛɛ yanra, jaŋgo paga kaa yagbogolo sɛnrɛ nuru.» ");
INSERT INTO dyi_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","A jɔlɔgɔ tunŋgo teele poro naa tunŋgo welefɛnnɛ pe ni, pè si saa ki yo Izirayɛli woolo pe kan fɔ: «Farawɔn wì yo: ‹Mi se ti pe yan ka kan ye yeri naa. ");
INSERT INTO dyi_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Yoro jate ye saa yan ka lagajaa ye yɛ, wa laga ŋga ye mbe ka ta we. Ye sigi jɛn ye yo fɔ ka se kɔn wa ye tunŋgo ki na.› » ");
INSERT INTO dyi_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kona, a Izirayɛli woolo pè si jaraga wa Ezhipiti tara ti lagapyew na yan ŋga kì fugurɔ ka wulo. ");
INSERT INTO dyi_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Jɔlɔgɔ tunŋgo teele pàa pye na pe yɛgɛ weregi na yuun fɔ: «Ye ye pilige nuŋgba tunŋgo ki kɔ. Tofa yɔn ŋga ki daga ye kɔn, yege kɔn, paa yɛgɛ ŋga na pàa pye na yan ki kaan ye yeri sanga ŋa ni we.» ");
INSERT INTO dyi_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Farawɔn wi tunŋgo teele pàa Izirayɛli woolo mbele tɛgɛ tunŋgo welefɛnnɛ sanmbala pe go na, pàa pye na pe gbɔɔn yɛrɛ, nɛɛ pe piin fɔ: «Tofa yɔn ŋga ye daga mbe kɔn, yiŋgi na yunmbaan naa nala, yee si ya mbege kɔn mbege kɔ paa faa yɛn?» ");
INSERT INTO dyi_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Kona, Izirayɛli woolo mbele pàa pye tunŋgo welefɛnnɛ, a pè si kari ma saa panraga wa Farawɔn wi yeri, ma yo fɔ: «Wunlunaŋa, yiŋgi na woro mbele ma kulolo, ma nɛɛ we jɔlɔ yɛɛn? ");
INSERT INTO dyi_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Pe woro na yan kaan we yeri naa, konaa ki ni fuun, pè sho fɔ waa tofa wi kɔɔn. Paa we gbɔɔn yɛrɛ, ma sigi ta, tanga woro ma woolo pe yeri.» ");
INSERT INTO dyi_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","A Farawɔn wì si pe yɔn sogo ma yo fɔ: «Ye yɛn tiyanmbala! Ee, tiyanmbala! Ko kala ki ti yè yo fɔ: ‹Yoo kari, we sa saara wɔ Yawe Yɛnŋɛlɛ li yeri.› ");
INSERT INTO dyi_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ye sɔngɔrɔ yiŋgɔ, ye saa ye tunndo ti piin. Pe saa ye kaan yan ni naa, ɛɛn fɔ, ye yaa sila tofa yɔn nuŋgba ki kɔɔn.» ");
INSERT INTO dyi_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Izirayɛli woolo mbele pàa pye tunŋgo welefɛnnɛ, a pè sigi yan pè pe cɛnlɔmɔ pi tisaw pe na, katugu pàa pe pye fɔ: «Tofa yɔn ŋga ye maa kɔɔn pilige pyew, ka se kɔn wa ki na.» ");
INSERT INTO dyi_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Naa pàa kaa yiri wa Farawɔn wi yeri, a pè si kari Moyisi naa Arɔn pe kɔrɔgɔ, poro la pye na pe singi. ");
INSERT INTO dyi_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","A pè si Moyisi naa Arɔn pe pye fɔ: «Yawe Yɛnŋɛlɛ li ye wele, li kiti kɔn ye na! Yè we kala li pye, a lì Farawɔn wo naa wi legbɔɔlɔ pe mbɛn. Kala na yè pye, li yɛn paa tokobi yɛn ŋa yè le pe kɛɛ pe we gbo wi ni.» ");
INSERT INTO dyi_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","A Moyisi wì si sɔngɔrɔ wa Yawe Yɛnŋɛlɛ li yeri ma saa li yewe ma yo: «E, we Fɔ, yiŋgi na, a mà si tipege pye ki leele mbele pe na? Yiŋgi na, a mà silan tun? ");
INSERT INTO dyi_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Malɛ mì saa para ma sɛnrɛ na Farawɔn wi kan, wi yɛn naga leele mbele pe jɔlɔ. Mɛɛ si kala la pye mbɔɔn woolo pe shɔ.» ");
INSERT INTO dyi_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Koni ŋga mi yaa pye Farawɔn wi na, ma yaa ki yan. Na fanŋga ko ki yaa wi ŋgbanga wi Izirayɛli woolo pe yaga pe kari. Ko ki yaa wi ŋgbanga wi pe purɔ, wi pe wɔ laga wi tara.» ");
INSERT INTO dyi_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Kona, a Yɛnŋɛlɛ lì si para naa Moyisi wi ni maa pye fɔ: «Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Faa mìla na yɛɛ naga Abirahamu, naa Izaki konaa Zhakɔbu pe na ma yo mi yɛn Yɛnŋɛlɛ na yawa pi ni fuun fɔ. Ɛɛn fɔ, pe sila na jɛn ‹Yawe Yɛnŋɛlɛ› mɛgɛ ko na. ");
INSERT INTO dyi_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mìla na yɔn finliwɛ pi le pe ni, mbe Kana tara ti kan pe yeri, to nda pàa pye ma cɛn wa ti ni, ma pye nambanmbala. ");
INSERT INTO dyi_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ezhipiti tara fɛnnɛ pè Izirayɛli woolo pe wa kulowo tunndo nda na, a paa jɛɛn, mìgi logo. Mì jatere pye yɔn finliwɛ mba mìla le pe ni pi na. ");
INSERT INTO dyi_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ki kala na, maga yo Izirayɛli woolo pe kan fɔ: ‹Muwi mi yɛn Yawe Yɛnŋɛlɛ le. Mi yaa ye shɔ kulowo tunndo nda Ezhipiti tara woolo pè yo yaa piin ti ni. Na fanŋga konaa jɔlɔgɔ kagbɔgɔlɔ ŋgele mi yaa wa pe na, mi yaa ke tɛgɛ mbe ye go shɔ. ");
INSERT INTO dyi_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mi yaa ye pye na woolo, mbe pye ye Yɛnŋɛlɛ. Pa ye yaa ki jɛn mbe yo muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. Mi yɛn na ye shoo tunŋgbanra nda Ezhipiti tara woolo pè yo yaa piin ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Tara nda mìla wugu na mɛgɛ ki na ma yo mi yaa kan Abirahamu, naa Izaki, konaa Zhakɔbu pe yeri, mi yaa ka ye pye ye ye wa ti ni. Mi yaa ti kan ye yeri ti pye ye woro. Mi ŋa Yawe Yɛnŋɛlɛ, muwi mì yo ma.› » ");
INSERT INTO dyi_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","A Moyisi wì si saa ki sɛnrɛ ti yo Izirayɛli woolo pe kan, ɛɛn fɔ, pe sila logo wi yeri fyew, pe jatere pirindorogo konaa pe kulowo tunŋgbanra ti kala na. ");
INSERT INTO dyi_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","A Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Kari ma saga yo Farawɔn wi kan, Ezhipiti tara wunlunaŋa we, fɔ wi Izirayɛli woolo pe yaga pe kari pe wɔ wa wi tara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","A Moyisi wì sili yɔn sogo ma yo fɔ: «Wele, Izirayɛli woolo poro yɛrɛ si logo na yeri! Farawɔn wo yaa logo na yeri mɛlɛ, mi ŋa mi woro yɔn tangafɔ we?» ");
INSERT INTO dyi_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","A Yawe Yɛnŋɛlɛ lì si para Moyisi naa Arɔn pe ni, ma yo pe sa Izirayɛli woolo poro naa Ezhipiti tara wunlunaŋa Farawɔn wi ni pe yan, jaŋgo mbe Izirayɛli woolo pe yirige wa Ezhipiti tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Izirayɛli woolo mbele pàa pye sege teele pe mɛrɛ ti nda. Zhakɔbu wi pinambyɔ koŋgbanŋa Urubɛn wi pinambiile pe mɛrɛ ti nda: Hanɔki, naa Palu, naa Hɛzirɔn, konaa Karimi. Poro wɛlɛ pàa pye Urubɛn wi setirige piile pe seye ye. ");
INSERT INTO dyi_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeyɔn pinambiile pe mɛrɛ ti nda: Yemuwɛli, naa Yamini, naa Owadi, naa Yakini, naa Sokari, konaa Kana tara fɛnnɛ jɔ wi pinambyɔ Sawuli wi ni. Poro wɛlɛ pàa pye Simeyɔn wi setirige piile pe seye ye. ");
INSERT INTO dyi_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi pinambiile pe mɛrɛ ti nda, naa pe setirige piile pe ni. Pinambiile taanri pàa pye Levi wi yeri: Gɛrishɔn, naa Kehati, konaa Merari. Levi wi yinwege piliye yan wìla ta, yìla pye yɛlɛ cɛnmɛ naa nafa ma yiri kɛ ma yiri kɔlɔshyɛn (137). ");
INSERT INTO dyi_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gɛrishɔn pinambiile pe mɛrɛ ti nda: Libini, naa Shimeyi, konaa pe seye yi ni. ");
INSERT INTO dyi_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kehati pinambiile pe mɛrɛ ti nda: Amiramu, naa Yizehari, naa Eburɔn, konaa Uziyɛli. Kehati wi yinwege piliye yan wìla ta, yìla pye yɛlɛ cɛnmɛ naa nafa ma yiri kɛ ma yiri taanri (133). ");
INSERT INTO dyi_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari pinambiile pe mɛrɛ ti nda: Mahali naa Mushi. Poro wɛlɛ pàa pye Levi wi seye woolo naa pe setirige piile wele. ");
INSERT INTO dyi_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amiramu wìla wi to jɔnlɔ sumboro Yokebɛdi wi pɔri wi jɔ. A Yokebɛdi wì si pinambiile shyɛn se wi kan. Pàa pye na wa yinri Arɔn, na sanŋa wi yinri Moyisi. Amiramu wi yinwege piliye yan wìla ta, yìla pye yɛlɛ cɛnmɛ naa nafa ma yiri kɛ ma yiri kɔlɔshyɛn (137). ");
INSERT INTO dyi_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yizehari pinambiile pe mɛrɛ ti nda: Kore, naa Nefɛgi, konaa Zikiri. ");
INSERT INTO dyi_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziyɛli pinambiile pe mɛrɛ ti nda: Mishayɛli, naa Elizafan konaa Sitiri. ");
INSERT INTO dyi_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arɔn wìla Elisheba pɔri wi jɔ. Elisheba wìla pye Aminadabu wo sumborombyɔ, konaa ma pye Naashɔn wi nɔsepyɔ sumboro. Wìla pinambiile tijɛrɛ se Arɔn wi kan: Nadabu, naa Abiyu, naa Eleyazari, konaa Itamari. ");
INSERT INTO dyi_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kore pinambiile pe mɛrɛ ti nda: Asiri, naa Ɛlikana, konaa Abiyasafu. Poro wɛlɛ pàa pye Kore wi setirige piile pe seye ye. ");
INSERT INTO dyi_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Arɔn wi pinambyɔ Eleyazari wìla Putiyɛli sumborombiile nuŋgba pɔri wi jɔ. Wìla pinambyɔ nuŋgba se wi kan, pàa pye naa yinri Fineyasi. Poro wɛlɛ pàa pye sege teele wa Levi setirige piile pe seye yi ni. ");
INSERT INTO dyi_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ki Arɔn wo naa ki Moyisi wi ni, poro wɛlɛ Yawe Yɛnŋɛlɛ làa pe pye fɔ: «Ye Izirayɛli woolo pe yirige wa Ezhipiti tara mbe yala pe seye yi ni paa maliŋgbɔɔnlɔ ŋgbeleye yɛn.» ");
INSERT INTO dyi_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Moyisi naa Arɔn poro wɛlɛ pàa saa para Farawɔn wi ni, Ezhipiti tara wunlunaŋa we, mbe Izirayɛli woolo pe yirige wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Pilige ŋga ni Yawe Yɛnŋɛlɛ làa para Moyisi wi ni wa Ezhipiti tara, ");
INSERT INTO dyi_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","làa wi pye fɔ: «Muwi mi yɛn Yawe Yɛnŋɛlɛ le. Kari ma sa sɛnrɛ nda fuun mila yuun ma kan, ti yɛgɛ yo Farawɔn wi kan, Ezhipiti tara wunlunaŋa we.» ");
INSERT INTO dyi_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","A Moyisi wì si Yawe Yɛnŋɛlɛ li yɔn sogo le ki laga ki na, ma yo fɔ: «Mi woro yɔn tangafɔ, Farawɔn wi se logo na yeri.» ");
INSERT INTO dyi_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Wele, mi yaa ma pye paa Yɛnŋɛlɛ yɛn Farawɔn wi yɛgɛ na. Ma ndɔ Arɔn wi yaa pye ma yɔn sɛnrɛ yofɔ. ");
INSERT INTO dyi_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ŋga fuun mi yaa yo ma kan, ma ki ni fuun ki yo ma ndɔ Arɔn wi kan. Wo wi yaa la para Farawɔn wi ni, jaŋgo wi Izirayɛli woolo pe yaga pe kari pe wɔ wa wi tara. ");
INSERT INTO dyi_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ma si yala, mi jate mi yaa Farawɔn wi kotogo ki ŋgban wi na; ali mbege ta mi yaa kagbɔgɔlɔ naa kafɔnŋgɔlɔ lɛgɛrɛ pye laga Ezhipiti tara ti ni, ");
INSERT INTO dyi_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","wi se logo ye yeri. Kona mi yaa na yawa pi pye poo jɛn wa Ezhipiti tara kiti kɔnkagbɔgɔlɔ ni. Mbe Izirayɛli, na woolo mbele pe yɛn paa na maliŋgbɔɔnlɔ yɛn, pe yirige mbe pe wɔ wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ezhipiti tara fɛnnɛ pe yaa ki jɛn mbe yo muwi mi yɛn Yawe Yɛnŋɛlɛ le, na mi ka ka yiri pe kɔrɔgɔ na fanŋga ki ni sanga ŋa ni, mbe Izirayɛli woolo pe yirige wa pe tara we.» ");
INSERT INTO dyi_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moyisi wo naa Arɔn wi ni, a pè sigi pye ma. Ŋga Yawe Yɛnŋɛlɛ làa yo pe kan, a pè sigi pye cɛ. ");
INSERT INTO dyi_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moyisi wìla ta yɛlɛ nafa tijɛrɛ, a Arɔn wì ta yɛlɛ nafa tijɛrɛ ma yiri taanri sanga ŋa ni pàa saa para Farawɔn wi ni we. ");
INSERT INTO dyi_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Kona, a Yawe Yɛnŋɛlɛ lì sigi yo Moyisi naa Arɔn pe kan fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Na Farawɔn wi ka ye pye mbe yo ye kafɔnnɔ la pye yeli naga, pa maga yo Arɔn wi kan wuu kanŋgala li wa le tara Farawɔn wi yɛgɛ na. Pa li yaa kanŋga wɔɔgɔ.» ");
INSERT INTO dyi_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","A Moyisi naa Arɔn pè si kari wa Farawɔn wi yeri, mɛɛ saa ŋga Yawe Yɛnŋɛlɛ làa yo ki pye. A Arɔn wì suu kanŋgala li wa le tara Farawɔn wo naa wi legbɔɔlɔ pe yɛgɛ na, a lì si kanŋga wɔɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ɛɛn fɔ, a Farawɔn wì si Ezhipiti tara tijinliwɛ fɛnnɛ poro naa kajɛnmbɛlɛ pe yeri, a pè pan maga kala nuŋgba la pye pe kajɛnmɛ pi fanŋga na. ");
INSERT INTO dyi_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Pe ni fuun nuŋgba nuŋgba pàa pe kanŋgagala ke wa le tara, a kè kanŋga wɔɔrɔ. Ɛɛn fɔ, a Arɔn kanŋgala lì si pe wogolo ke yɔli. ");
INSERT INTO dyi_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","A Farawɔn wi kotogo kì si ŋgban wi na, wi sila logo Moyisi naa Arɔn pe yeri; kìla pye ma yala sɛnrɛ nda Yawe Yɛnŋɛlɛ làa yo ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Farawɔn wì kotogo ki yɛn ma ŋgban wi na, wì je mbe Izirayɛli woolo pe yaga paa kee. ");
INSERT INTO dyi_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kari wa Farawɔn wi yeri goto pinliwɛ ni. Wi yaa ka yiri mbe kari wa gbaan wi tanla. Ma kari wi kɔrɔgɔ wa gbaan wi koŋgo na. Kanŋgala na làa kanŋga wɔɔgɔ, mali lɛ. ");
INSERT INTO dyi_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Maga yo maga ŋgban Farawɔn wi ni fɔ: ‹Yawe Yɛnŋɛlɛ, woro Eburuye we Yɛnŋɛlɛ le, lìlan tun ma yeri ma yo mbege yo ma kan fɔ mali woolo pe yaga pe kari wa gbinri wi ni, pe sali gbɔgɔ. Ɛɛn fɔ, mboro wo na, ali ma pan ma gbɔn yiŋgɔ, ma fa logo li yeri. ");
INSERT INTO dyi_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Sɛnrɛ nda Yawe Yɛnŋɛlɛ lì yo ti nda: Kala na li yaa pye, lo li yaa ki naga ma na fɔ Yɛnŋɛlɛ lo li yɛn Yawe Yɛnŋɛlɛ le. Kanŋgala na na kɛɛ, mi yaa li tɛgɛ mbe gbaan tɔnmɔ pi gbɔn li ni, pa pi yaa kanŋga kasanwa. ");
INSERT INTO dyi_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ŋgbanra nda wa gbaan wi ni ti yaa ku, gbaan tɔnmɔ pi yaa ka jɔgɔ fɔ Ezhipiti tara fɛnnɛ pe se ka ya mbaa pi woo.› » ");
INSERT INTO dyi_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Ki yo Arɔn wi kan, wuu kanŋgala li lɛ, wuu kɛɛ ki yirige, wigi sanga wa Ezhipiti tara tɔnmɔ pyew pi go na, pe laforo, naa pe gbaan njere, naa pe lambaara konaa pe lawere ti ni fuun ti go na, jaŋgo pe tɔnmɔ pi kanŋga pi pye kasanwa. Pa kona kasanwa pi yaa pye Ezhipiti tara ti lagapyew. Ali tɔnmɔ leyaara nda ti yɛn tire woro naa sinndɛɛrɛ woro ti tɔnmɔ pi yaa kanŋga kasanwa.» ");
INSERT INTO dyi_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Yawe Yɛnŋɛlɛ làa ŋga yo, a Moyisi naa Arɔn pè sigi pye. Arɔn wìla kanŋgala li yirige ma gbaan tɔnmɔ pi gbɔn li ni le Farawɔn wo naa wi legbɔɔlɔ pe yɛgɛ na. A tɔnmɔ pi ni fuun pì si kanŋga kasanwa. ");
INSERT INTO dyi_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ŋgbanra nda tìla pye wa gbaan wi ni tì si ku; a gbaan wi tɔnmɔ pì jɔgɔ. Ezhipiti tara fɛnnɛ pe sila ya mbaa gbaan wi tɔnmɔ pi woo naa. Kasanwa pìla pye wa Ezhipiti tara ti lagapyew. ");
INSERT INTO dyi_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ɛɛn fɔ, Ezhipiti tara fɛnnɛ kajɛnmbɛlɛ, a pè sigi kafɔnnɔ cɛnlɛ nuŋgba la pye fun pe kajɛnmɛ pi fanŋga na. Farawɔn wi kotogo kìla ŋgban wi na, wi sila logo Moyisi naa Arɔn pe yeri, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo we. ");
INSERT INTO dyi_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","A Farawɔn wì si sɔngɔrɔ ma kari wi go, wi sila ki kala li yigi kala. ");
INSERT INTO dyi_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ezhipiti tara fɛnnɛ pe ni fuun pàa pye na were woo wa gbaan wi kanŋgara na, na tɔnmɔ wɔwoo lagajaa, katugu pe saa ya mbe gbaan tɔnmɔ pi wɔ. ");
INSERT INTO dyi_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Naa Yawe Yɛnŋɛlɛ làa gbaan wi tɔnmɔ pi kanŋga kasanwa, piliye kɔlɔshyɛn yìla toro. ");
INSERT INTO dyi_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Ko puŋgo na, a lì si Moyisi wi pye fɔ: «Kari naa, ma sa Farawɔn wi pye fɔ: ‹Yawe Yɛnŋɛlɛ lì yo mali woolo pe yaga pe kari pe sali gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Na maga je mbe yo ma se pe yaga pe kari, pa li yaa ŋgbeye lɛgɛrɛ yirige pe pan pe tara ti tɔn lagapyew. ");
INSERT INTO dyi_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Ŋgbeye pe yaa ka lɛgɛ wa gbaan wi ni. Pe yaa ka yiri wa wi ni mbe kari wa ma wunluwɔ go ki ni, mbe ye wa go pyɔ ŋa ma maa wɔnlɔ wi ni, mbe lugu wa ma sinlɛyaraga ki na. Pe yaa ka ye wa ma tunmbyeele poro naa ma tara woolo pe yinrɛ ti ni, mbe ye wa ye yiraye poro naa ye buru gbɔnyaara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Ŋgbeye pe yaa kaa nuru mboro naa ma tara woolo naa ma tunmbyeele ye na.› » ");
INSERT INTO dyi_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Ki yo Arɔn wi kan wuu kɛɛ ki yirige wi kanŋgala li sin wa laforo, naa gbaan njere to naa lambaara ti yeri, wi ti ŋgbeye pe yiri wa ti ni, pe jaraga wa Ezhipiti tara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","A Arɔn wì suu kɛɛ ki yirige maga sin wa Ezhipiti tara lɔrɔ ti yeri. A ŋgbeye pè si yiri ma Ezhipiti tara ti tɔn lagapyew. ");
INSERT INTO dyi_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","A Ezhipiti tara fɛnnɛ kajɛnmbɛlɛ pè sigi kafɔnnɔ cɛnlɛ nuŋgba la pye pe kajɛnmɛ pi fanŋga na, ma ŋgbeye pele yirige, a pè ye wa Ezhipiti tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","A Farawɔn wì si Moyisi naa Arɔn pe yeri ma pe pye fɔ: «Ye Yawe Yɛnŋɛlɛ li yɛnri li ŋgbeye pe laga mi naa na tara woolo we na. Kona mi yaa yoro Izirayɛli woolo ye yaga ye kari ye sa saara wɔ li yeri.» ");
INSERT INTO dyi_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","A Moyisi wì si Farawɔn wi pye fɔ: «Gbɔgɔwɔ pi yɛn mboro woo, wagati wi naga, ŋa maa jaa mbe Yawe Yɛnŋɛlɛ li yɛnri mboro, naa ma legbɔɔlɔ konaa ma tara woolo ye kan we, jaŋgo li ŋgbeye pe wɔ wa ma yeri konaa wa ma yinrɛ ti ni. Pe se ka koro laga ka na naa, na gbaan wo ma.» ");
INSERT INTO dyi_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","A Farawɔn wì si Moyisi wi yɔn sogo ma yo fɔ: «Ki pye goto.» A Moyisi wì si Farawɔn wi pye fɔ: «Ki yaa pye ma paa yɛgɛ ŋga na maa ki jaa, jaŋgo maga jɛn ma yo lere wa kpɛ si yala Yawe Yɛnŋɛlɛ, we Yɛnŋɛlɛ li ni. ");
INSERT INTO dyi_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ŋgbeye pe yaa kari mbe wɔ laga ma yeri, mbe wɔ wa ma yinrɛ ti ni, mbe wɔ wa ma legbɔɔlɔ poro naa ma tara woolo pe yeri. Pe se ka koro laga ka na naa na gbaan wo ma.» ");
INSERT INTO dyi_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","A Moyisi naa Arɔn pè si yiri wa Farawɔn wi yeri. A Moyisi wì si gbele ma Yawe Yɛnŋɛlɛ li yɛnri Farawɔn wi kan, ŋgbeye mbele pàa ti a pè pan pe wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","A lì si ŋga Moyisi wìla yɛnri ki pye. A ŋgbeye pè si ku wa yinrɛ naa lara to naa kɛɛrɛ ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","A leele pè si pe gbogolo pe yɛɛ na, a pe nuwɔ pì si tara ti tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ɛɛn fɔ, naa Farawɔn wìla kaa ki yan ki kala lì mbɔnrɔ, a wì suu kotogo ki ŋgban, wi sila logo Moyisi naa Arɔn pe yeri, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo we. ");
INSERT INTO dyi_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Ki yo Arɔn wi kan, wuu kanŋgala li yirige wi taambugɔ ki gbɔn li ni, pa ki gbanŋgban wi yaa kanŋga namara wa Ezhipiti tara ti lagapyew.» ");
INSERT INTO dyi_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","A pè sigi pye ma. A Arɔn wì suu kɛɛ ki sanga, ma taambugɔ ki gbɔn wi kanŋgala li ni, a ki gbanŋgban wì si kanŋga namara ma mu leele poro naa yaayoro ti na na pe nɔɔri. Gbanŋgban wìla kanŋga namara wa Ezhipiti tara ti lagapyew. ");
INSERT INTO dyi_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","A Ezhipiti tara kajɛnmbɛlɛ pè si pe kajɛnmɛ pi pye ma yo pe yaa namara ta yirige. Ɛɛn fɔ, pe sila ya. Namara tìla pye leele poro naa yaayoro ti na, na pe nɔɔri. ");
INSERT INTO dyi_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","A kajɛnmbɛlɛ pè si Farawɔn wi pye fɔ: «Yɛnŋɛlɛ li yawa po pi yɛn na tunŋgo piin.» Konaa ki ni fuun, Farawɔn wi kotogo kìla ŋgban wi na, wi sila logo Moyisi naa Arɔn pe yeri, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo we. ");
INSERT INTO dyi_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa ma yo: «Goto, ma yiri faa ma kari wa Farawɔn wi yeri, na wiga ka yiri sanga ŋa ni mbaa kee wa gbaan wi yɔn na we. Ma saa pye fɔ sɛnrɛ nda Yawe Yɛnŋɛlɛ lì yo ti nda: ‹Na woolo pe yaga pe kari pe sanla gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Na maga je mbe yo paga ka kari, mi yaa nakɔɔnrɔ nda ti yɛn shɔnrɔ ni ta yirige mbe wa mboro naa ma legbɔɔlɔ, naa ma tara woolo poro naa ma go woolo pe na. Ezhipiti tara fɛnnɛ pe yinrɛ ti yaa yin nakɔɔnrɔ ti ni, mbe tara ti tɔn muŋga. ");
INSERT INTO dyi_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ɛɛn fɔ, ki pilige ki ka gbɔn, mi yaa Goshɛni tara ti wɔ ti yɛ ma woro ti ni, to nda na woolo pe yɛn ma cɛn wa ti ni we. Nakɔɔnrɔ se ka pye wa Goshɛni tara, ki ka pye ma, pa ma yaa ki jɛn mbe yo mi ŋa Yawe Yɛnŋɛlɛ, mi yɛn laga ki tara nda ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Mi yaa kanla woolo pe wɔ pe yɛ ma woolo pe ni. Ki kafɔnnɔ li yaa li yɛɛ yɔn fili goto.› » ");
INSERT INTO dyi_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","A Yawe Yɛnŋɛlɛ lì sigi pye paa yɛgɛ ŋga na làa ki yo we. Nakɔɔnrɔ nda ti yɛn shɔnrɔ ni, a tà si pan lɛgɛrɛ ma ye wa Farawɔn wi wunluwɔ go ki ni, naa wi legbɔɔlɔ pe yinrɛ ti ni konaa Ezhipiti tara ti lagapyew. Tìla tara ti lagapyew ki jɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","A Farawɔn wì si Moyisi naa Arɔn pe yeri ma yo fɔ: «Ye sa saara wɔ ye Yɛnŋɛlɛ li yeri, laga Ezhipiti tara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","A Moyisi wì si Farawɔn wi yɔn sogo ma yo fɔ: «We se ya mbege pye ma; katugu saara nda we yaa wɔ Yawe Yɛnŋɛlɛ, we Yɛnŋɛlɛ li yeri, ti yaa pye Ezhipiti tara fɛnnɛ pe yeri pe kambɛngɛ. Na waga sigi saara nda ti yɛn ma Ezhipiti tara fɛnnɛ pe mbɛn ti wɔ pe yɛgɛ na, pe yaa we wa sinndɛɛrɛ ni mbe we gbo. ");
INSERT INTO dyi_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","We yaa piliye taanri tangala tanga wa gbinri wi ni, mbe sa saara wɔ Yawe Yɛnŋɛlɛ, we Yɛnŋɛlɛ li yeri, mbe yala ŋga li yaa yo we kan ki ni.» ");
INSERT INTO dyi_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","A Farawɔn wì sho fɔ: «Mi jate, mi yaa ye yaga ye sa saara wɔ, Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ li yeri wa gbinri wi ni. Ɛɛn fɔ yaga ka kari lege. Ye Yɛnŋɛlɛ li yɛnri na kan (nakɔɔnrɔ ti wɔ laga).» ");
INSERT INTO dyi_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","A Moyisi wì suu yɔn sogo ma yo fɔ: «Na yiriŋgɔlɔ laga ma yeri, mi yaa Yawe Yɛnŋɛlɛ li yɛnri ma kan. Goto nakɔɔnrɔ ti yaa kari mbe laga mboro naa ma legbɔɔlɔ, naa ma tara woolo ye na. Ɛɛn fɔ, wunlunaŋa, maga ka koro mbaa we fanla mbe je mbe yo ma se we yaga we kari we sa saara wɔ Yawe Yɛnŋɛlɛ li yeri.» ");
INSERT INTO dyi_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","A Moyisi wì si yiri wa Farawɔn wi yeri mɛɛ Yawe Yɛnŋɛlɛ li yɛnri wi kan. ");
INSERT INTO dyi_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","A lì si ŋga Moyisi wìla yɛnri ki pye, ma nakɔɔnrɔ ti purɔ mari laga Farawɔn, naa wi legbɔɔlɔ konaa wi tara woolo pe na. Ali nuŋgba ko sila koro wa. ");
INSERT INTO dyi_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ɛɛn fɔ, ki wogo ŋga ki na, Farawɔn wìla wi kotogo ki ŋgban naa, wi sila Izirayɛli woolo pe yaga pe kari. ");
INSERT INTO dyi_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Kari wa Farawɔn wi yeri, ma saa pye fɔ: ‹Yawe Yɛnŋɛlɛ, Eburuye Yɛnŋɛlɛ le, pa lì yo yɛɛn fɔ: Na woolo pe yaga pe kari pe sanla gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Na maga je mbe yo paga ka kari, mbe ti pe koro laga, ");
INSERT INTO dyi_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","wele, ma yaayoro ŋgbeleye yan yila nii wa wasege ki ni, Yawe Yɛnŋɛlɛ li fanŋga ki yaa yiri yi kɔrɔgɔ; yambewe yaa to ma shɔnye, naa ma sofilele, naa ma yɔngɔmɛye, naa ma nɛrɛ, naa ma simbaala konaa sikaala pe na. ");
INSERT INTO dyi_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ɛɛn fɔ, Yawe Yɛnŋɛlɛ li yaa ka Izirayɛli woolo pe yaayoro ŋgbeleye yi jɛn mbe yi wɔ yi yɛ Ezhipiti tara fɛnnɛ pe woyo yi ni, Izirayɛli woolo pe yaayoro ka nuŋgba se ka ku.› » ");
INSERT INTO dyi_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","«Yawe Yɛnŋɛlɛ lìgi pyewagati wi kɔn maa tɛgɛ, ma yo fɔ: Goto, mi yaa ki kala li pye laga tara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ki goto, ŋga Yawe Yɛnŋɛlɛ làa yo, a lì sigi pye maga yɔn fili. Ezhipiti tara fɛnnɛ pe yaayoro ŋgbeleye yi ni fuun yìla ku. Ɛɛn fɔ, Izirayɛli woolo pe yaayogo ka nuŋgba sila ku. ");
INSERT INTO dyi_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","A Farawɔn wì si lere tun ma yo pe sa yewe na kaa pye Izirayɛli woolo pe yaayogo ka si ku. Ɛɛn fɔ, a pè sigi yan fɔ ali yaayogo nuŋgba ko sila ku wa Izirayɛli woolo pe yaayoro ŋgbeleye yi ni. Konaa ki ni fuun, Farawɔn wi kotogo kìla ŋgban wi na, wi sila Izirayɛli woolo pe yaga pe kari. ");
INSERT INTO dyi_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi naa Arɔn pe pye fɔ: «Ye sa cɔnrɔ ta koli kɛɛ yɛngɛlɛ yira wa ni, Moyisi wiri wa wa naayeri Farawɔn wi yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ki cɔnrɔ ti yaa kanŋga gbanŋgban wa Ezhipiti tara ti ni fuun ti ni. Ki gbanŋgban wi yaa naŋgbanra wa leele poro naa yaayoro ti na, mbe kɔɔnlɔ sagbanra pe na wa Ezhipiti tara ti ni fuun ti ni.» ");
INSERT INTO dyi_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","A Moyisi naa Arɔn pè si yira cɔnrɔ ta koli mɛɛ kari wa Farawɔn wi yeri. A Moyisi wì si cɔnrɔ ti wa wa naayeri. A tì si naŋgbanra wa leele poro naa yaayoro ti na, ma kɔɔnlɔ sagbanra. ");
INSERT INTO dyi_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ezhipiti tara kajɛnmbɛlɛ pe sila ya kari wa Moyisi wi yeri naŋgbanra ti kala na; katugu naŋgbanra tìla yiri pe na fun paa Ezhipiti tara fɛnnɛ sanmbala pe ni fuun pe yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","A Yawe Yɛnŋɛlɛ lì si Farawɔn wi kotogo ki ŋgban wi na, wi sila logo Moyisi naa Arɔn pe yeri, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo ma Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Goto pinliwɛ ni, ma yiri faa ma kari wa Farawɔn wi yeri, ma saa pye fɔ: ‹Pa Yawe Yɛnŋɛlɛ, woro Eburuye we Yɛnŋɛlɛ lì yo yɛɛn fɔ: Na woolo pe yaga pe kari pe sanla gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Katugu yɔnlɔ na lo na, mi yaa jɔlɔgɔ cɛnlɛ pyew ka wa mboro naa ma legbɔɔlɔ naa ma tara woolo pe na, jaŋgo maga jɛn ma yo fɔ lere wa si yala na ni laga tara ti na. ");
INSERT INTO dyi_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ndɛɛ ki pye yiŋgɔ mila kɛɛ ki yirige ma kɔrɔgɔ, ma tifɛlɛgɛ yama wa mboro naa ma woolo ye na, anmɛ ye ku ma wɔ laga tara ti na. ");
INSERT INTO dyi_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ɛɛn fɔ, mɔ̀ɔ yaga yinwege na, jaŋgo mbanla yawa pi naga ma na, mbanla mɛgɛ ki pye ki yiri laga tara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ali ma pan ma gbɔn yiŋgɔ, ma yɛn naga ŋgbanga mbanla woolo pe yɛgɛ kɔn paga ka ta mbe kari. ");
INSERT INTO dyi_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Wele, goto anmɛ yɛgɛ, mi yaa ti sinndɛɛrɛ tisaga ka mbe pan ŋgbanga laga Ezhipiti tara ti ni, ki cɛnlɛ ka fa pan laga malɛ Ezhipiti tara ti lɛsanga wi na fɔ ma pan ma gbɔn yiŋgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Koni ki yaga pe pan ca ma yaayoro ŋgbeleye yi ni konaa yaara nda fuun ti yɛn ma yeri wa wasege ki ni ti ni, peri tɛgɛ tɛgɛsaga jɛŋgɛ na. Leele mbele fuun pe yaa ka pye wa wasege konaa yaayoro ti ni fuun ti ni, na pee pan mbe ye wa yinrɛ ti ni, sinndɛɛrɛ tisaga ki yaa pe gbɔn mbe pe gbo mbe pinlɛ yaayoro ti ni.› » ");
INSERT INTO dyi_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Farawɔn wi legbɔɔlɔ mbele pàa Yawe Yɛnŋɛlɛ li sɛnrɛ ti yigi kala, poro la ti a pe tunmbyeele pè fyɛɛlɛ ma pan ca, konaa pe yaayoro ŋgbeleye yi ni, mari le wa yinrɛ ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ɛɛn fɔ, Farawɔn wi legbɔɔlɔ mbele pe sila Yawe Yɛnŋɛlɛ li sɛnrɛ ti lɛ, poro la pe tunmbyeele pe yaga wa wasege ki ni konaa pe yaayoro ŋgbeleye yi ni. ");
INSERT INTO dyi_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Ma kɛɛ ki yirige wa naayeri, jaŋgo sinndɛɛrɛ tisaga mbe pan wa Ezhipiti tara ti ni fuun ti ni, ki leele pe gbɔn, naa yaayoro ti ni konaa yaraga ŋga fuun kì fi wa Ezhipiti tara ki ni.» ");
INSERT INTO dyi_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","A Moyisi wì suu kanŋgala li yirige wa naayeri. A Yawe Yɛnŋɛlɛ lì si yɛnŋɛlɛ gbaanra yirige ma sinndɛɛrɛ tisaga wa, a yɛnŋɛlɛ gbanlaga kì to wa tara ti na. Yawe Yɛnŋɛlɛ làa ti, a sinndɛɛrɛ tisaga kì pan wa Ezhipiti tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Sinndɛɛrɛ tisaga kìla to, a yɛnŋɛlɛ yɛngɛlɛmɛ pì pinlɛ ki ni. Sinndɛɛrɛ tisaga kìla pye na paan ŋgbanga; malɛ Ezhipiti tara tì pye tara, ki cɛnlɛ ka fa pye wa gbɛn. ");
INSERT INTO dyi_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Sinndɛɛrɛ tisaga kìla to wa Ezhipiti tara ti lagapyew, ma yaraga ŋga fuun kìla pye wa wasege ki gbɔn maga gbo, leele o, yaayoro o. Kìla yan ki gbɔn maga fugurɔ, ma tire ti kaari wa wasege ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kaawɔ Goshɛni tara nda Izirayɛli woolo pàa pye ma cɛn wa ti ni to nuŋgba tìla shɔ. ");
INSERT INTO dyi_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kona, a Farawɔn wì si ti a pè Moyisi naa Arɔn pe yeri wi kan, mɛɛ pe pye fɔ: «Yɔnlɔ na lo na, mì kapege pye. Yawe Yɛnŋɛlɛ lo li yɛn ma sin. Mi naa na woolo pe ni, we yɛn kapere pyefɛnnɛ. ");
INSERT INTO dyi_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ye Yawe Yɛnŋɛlɛ li yɛnri na kan, li ti yɛnŋɛlɛ gbaanra to naa sinndɛɛrɛ tisaga ki ni ti yere. Pa kona mi yaa ye yaga yaa kee, we se ti ye koro laga naa.» ");
INSERT INTO dyi_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","A Moyisi wì suu yɔn sogo ma yo fɔ: «Na yiriŋgɔlɔ laga ca ki ni, mi yaa na kɛyɛn yi yirige wa Yawe Yɛnŋɛlɛ li yeri mbeli yɛnri, pa yɛnŋɛlɛ gbaanra to naa sinndɛɛrɛ tisaga ki ni, ti yaa yere, jaŋgo maga jɛn fɔ tara ti yɛn Yawe Yɛnŋɛlɛ lo woro. ");
INSERT INTO dyi_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ɛɛn fɔ, mìgi jɛn ma yo mboro naa ma legbɔɔlɔ pe ni, ye woro na fyɛ Yawe Yɛnŋɛlɛ li yɛgɛ bere.» ");
INSERT INTO dyi_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Yantiire nda pe yinri lɛn to naa yarilire nda pe yinri ɔrizhi, sinndɛɛrɛ tisaga kìla ti ni fuun ti jɔgɔ mari wɔ wa, katugu ɔrizhi wìla fuuru makɔ, a lɛn wì fyɛnwɛ. ");
INSERT INTO dyi_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ɛɛn fɔ, bile wo naa shɔgɔlɔ ke ni, koro sila jɔgɔ, katugu to ma koro puŋgo na. ");
INSERT INTO dyi_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","A Moyisi wì si yiri wa Farawɔn wi go, ma kari wa ca ki puŋgo na, ma suu kɛyɛn yi yirige wa naayeri, ma Yawe Yɛnŋɛlɛ li yɛnri. Kona, a yɛnŋɛlɛ gbaanra to naa sinndɛɛrɛ tisaga ki ni tì si yere. A tisaga kì si kɔn. ");
INSERT INTO dyi_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Naa Farawɔn wìla kaa ki yan tisaga kì kɔn, a sinndɛɛrɛ tisaga naa yɛnŋɛlɛ gbaanra tì yere, a wì si kapege cɛnlɛ nuŋgba ki pye ma je paa faa wogo ki yɛn. Wo naa wi legbɔɔlɔ pe ni, a pè si pe kotoro ti ŋgbanŋgban pe yɛɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Farawɔn wìla wi kotogo ki ŋgban wi yɛɛ na ma yala Yawe Yɛnŋɛlɛ làa sɛnrɛ nda yo Moyisi wi kan ti ni, wi sila Izirayɛli woolo pe yaga pe kari. ");
INSERT INTO dyi_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Kari wa Farawɔn wi yeri, katugu muwi mùu kotogo ki ŋgban wi na, wo naa wi legbɔɔlɔ pe ni, jaŋgo mbe ta mbanla kacɛn kagbɔgɔlɔ ke pye laga pe sɔgɔwɔ; ");
INSERT INTO dyi_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","jaŋgo mboro fun ma kaga yɛgɛ yo ma piile poro naa ma pishyɛnwoolo pe kan, paa yɛgɛ ŋga na mìla Ezhipiti tara fɛnnɛ pe jɔlɔ we, konaa kacɛn kagbɔgɔlɔ ŋgele mìla pye laga pe sɔgɔwɔ ke ni. Pa kona ye yaa ki jɛn mbe yo muwi mi yɛn Yawe Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kona, a Moyisi naa Arɔn pè si kari wa Farawɔn wi yeri ma saa wi pye fɔ: «Sɛnrɛ nda Yawe Yɛnŋɛlɛ, Eburuye Yɛnŋɛlɛ lì yo ti nda: ‹Ma yaa koro la jege mbe yo ma sɔɔn yɛɛ go sogo na kan fɔ sa gbɔn wagati wiwiin? Na woolo pe yaga pe kari pe sanla gbɔgɔ.› ");
INSERT INTO dyi_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Na maga je mbe yo ma se pe yaga pe kari, pa goto mi yaa gbatɔ wa laga ma tara ti lagapyew. ");
INSERT INTO dyi_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Wi yaa tara ti tɔn lagapyew fɔ pe se kaa tara ti yaan yɛnlɛ ni. Yaraga ŋga fuun kì koro sinndɛɛrɛ tisaga ki panŋgɔlɔ, gbatɔ wi yaa ko ka, naa tire nda fuun ti yɛn na yinrigi wa wasege ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Gbatɔ wi yaa ka ye wa wunluwɔ go ki ni mbege yin, naa ma legbɔɔlɔ pe ni fuun pe yinrɛ ti ni konaa Ezhipiti tara fɛnnɛ pe ni fuun pe yinrɛ ti ni. Ki jɔlɔgɔ ki yaa pye kala na lere fa la yan faa, malɛ wa ma tɛlɛye sanga wi na fɔ ma pan ma gbɔn nala.» Ki sɛnrɛ ti yoŋgɔlɔ, a Moyisi wì si yiri le Farawɔn wi tanla ma kari. ");
INSERT INTO dyi_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","A Farawɔn wi legbɔɔlɔ pè suu pye fɔ: «Ki naŋa ŋa wi yaa koro la we jɔlɔ fɔ sa gbɔn wagati wiwiin? Ki leele mbele pe yaga pe kari pe sa Yawe Yɛnŋɛlɛ li gbɔgɔ. Ma woro naga yaan bere fɔ we Ezhipiti tara ti yɛn na jogo na kee sa kɔ wi le?» ");
INSERT INTO dyi_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","A pè si Moyisi naa Arɔn pe yeri wa Farawɔn wi yeri, a wì si pe pye fɔ: «Ye kari ye sa Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ li gbɔgɔ. Ɛɛn fɔ, ambɛnɛ pe yɛn karifɛnnɛ poro?» ");
INSERT INTO dyi_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","A Moyisi wì suu yɔn sogo ma yo fɔ: «We yaa kari we piile naa we lelɛɛlɛ pe ni konaa we pinambiile naa we sumborombiile pe ni. We yaa kari we simbaala, naa we sikaala konaa we nɛrɛ ti ni, katugu waa kee sa fɛti pye mbe Yawe Yɛnŋɛlɛ li gbɔgɔ.» ");
INSERT INTO dyi_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","A Farawɔn wì si to pe tanla, ma pe pye fɔ: «Yawe Yɛnŋɛlɛ li pye ye ni! Ɛnhɛɛn! Mi yaa ye yaga yaa kee kpa, yoro naa ye piile pe ni. Ye ye yɛɛ yingiwɛ jɛn. Ki yɛn ma filige we yɛgɛ na fɔ ye jatere wi yɛn ma tijanga. ");
INSERT INTO dyi_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ŋga yè yɛnri ki se ya pye. Nambala poro cɛ pe yaa kari sali gbɔgɔ. Ko cɛ ŋga ko ye mbe ya yɛnri.» A pè si pe purɔ ma pe yirige wa Farawɔn wi go. ");
INSERT INTO dyi_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Ma kɛɛ ki yirige wa Ezhipiti tara ti go na, ma ti gbatɔ mbe pan laga, wi tara ti yin, yan ŋga fuun kìla shɔ sinndɛɛrɛ tisaga ki yeri, wigi ka pew.» ");
INSERT INTO dyi_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","A Moyisi wì suu kanŋgala li yirige wa Ezhipiti tara ti go na. A Yawe Yɛnŋɛlɛ lì si ti, a tifɛlɛgɛ ka yiri wa yɔnlɔ yirisaga yeri, na gbɔɔn wa tara ti ni, ki pilige ki yɔnlɔ naa ki yembinɛ li ni fuun li ni. Ki goto pinliwɛ pi ni, a pè sigi yan tifɛlɛgɛ kì pan gbatɔ wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Gbatɔ wìla pan wa Ezhipiti tara ti lagapyew, ma cɛn tara ti na lagapyew. Wìla lɛgɛ fɔ jɛŋgɛ, malɛ wa, pe fa wi lɛgɛwɛ pi cɛnlɛ la yan ma gbɛn, pe se si ka la yan ma naa. ");
INSERT INTO dyi_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Wìla tara ti ni fuun ti tɔn mari wɔ binriw. Yan ki ni fuun naa tige pire nda fuun tìla koro sinndɛɛrɛ tisaga ki panŋgɔlɔ, gbatɔ wìla ti ni fuun ti ka. Ali wɛtipinnɛ nuŋgba lo sila koro tige ka na nakoma wa wasege ki ni wa Ezhipiti tara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","A Farawɔn wì si ti, a pè Moyisi naa Arɔn pe yeri wi kan fyɛlɛgɛ na, mɛɛ pan ma pe pye fɔ: «Mì kapege pye Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ li na, ma kapege pye yoro fun ye na. ");
INSERT INTO dyi_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Koni mi yɛn na ye yɛnri, ki yɔnlɔ na li na naa, yanla kapege ki kala yaga na na, ye Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ li yɛnri na kan, ligi legbogo jɔlɔgɔ kala na li laga we na.» ");
INSERT INTO dyi_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","A Moyisi wì si yiri wa Farawɔn wi go mɛɛ saa Yawe Yɛnŋɛlɛ li yɛnri. ");
INSERT INTO dyi_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","A lì si ti a tifɛliŋgbɔgɔ ka yiri wa yɔnlɔ tosaga yeri, na gbɔɔn, ma gbatɔ wi lɛ, ma kari wi ni, ma saa wi wa wa Kɔgɔje yɛɛn wi ni. Ali nuŋgba wo sila koro wa Ezhipiti tara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ɛɛn fɔ, Yawe Yɛnŋɛlɛ làa Farawɔn wi kotogo ki ŋgban wi na, wii yɛnlɛ mbe Izirayɛli woolo pe yaga pe kari. ");
INSERT INTO dyi_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Ma kɛɛ ki yirige wa naayeri, jaŋgo diwi mbe ye laga Ezhipiti tara, fɔ leele paa talitali.» ");
INSERT INTO dyi_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","A Moyisi wì suu kɛɛ ki yirige wa naayeri, a diwi gbɔɔ wà si ye wa Ezhipiti tara ti ni fuun ti ni, fɔ ma saa gbɔn piliye taanri. ");
INSERT INTO dyi_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ki piliye taanri yi ni, leele pe sila pye na pe yɛɛ yaan. Lere wa kpɛ sila ya mbe yiri wi cɛnsaga mbe kari laga ka na. Ɛɛn fɔ, Izirayɛli woolo poro la pye ma cɛn lara nda ni, yanwa la pye na yinrigi wama. ");
INSERT INTO dyi_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","A Farawɔn wì si ti, a pè Moyisi wi yeri wi kan. A wì suu pye fɔ: «Yaa kee ye sa Yawe Yɛnŋɛlɛ li gbɔgɔ. Ye mbe ya kari ye go woolo pe ni, kaawɔ ye simbaala naa ye sikaala konaa ye nɛrɛ to cɛ ti yaa koro laga.» ");
INSERT INTO dyi_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","A Moyisi wì suu yɔn sogo ma yo fɔ: «Mboro yɛrɛ ma daga mbe ti we yaayoro ta ta we sari wɔ nayinmɛ saara konaa saara sogoworo Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Mbe taga wa ko na, we yaa kari we yaayoro ŋgbeleye yi ni. We yaayogo ka nuŋgba se koro laga; katugu we yaa sa yaayoro ta wɔ wa ti ni, mberi wɔ saraga Yawe Yɛnŋɛlɛ, we Yɛnŋɛlɛ li yeri, mberi gbo. Ɛɛn fɔ, nda we yaa ka sa wɔ saraga li yeri mbeli gbɔgɔ, we seri jɛn, kaawɔ we ka sa gbɔn wa gbɛn.» ");
INSERT INTO dyi_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ɛɛn fɔ, a Yawe Yɛnŋɛlɛ lì si Farawɔn wi kotogo ki ŋgban wi na, ma ti a wì je ma yo wi se Izirayɛli woolo pe yaga pe kari. ");
INSERT INTO dyi_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","A Farawɔn wì si Moyisi wi pye fɔ: «Kari ma yiri na na tanla. Mɔɔ yɛɛ yigi, maga ka pan laga na yɛgɛ sɔgɔwɔ naa, katugu pilige ŋga ni mi kɔɔn yan laga na yɛgɛ sɔgɔwɔ, ma yaa ku win.» ");
INSERT INTO dyi_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","A Moyisi wì sho fɔ: «Mboro mà yo ma! Mi se pan laga naa ma yeri.» ");
INSERT INTO dyi_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Mi yaa jɔlɔgɔ ka wa naa Farawɔn wo naa Ezhipiti tara fɛnnɛ sanmbala pe na. Ko puŋgo na, wi yaa ye yaga yaa kee. Wi yɛrɛ yaa ye purɔ pew mbe ye yirige laga tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kari ma saga yo Izirayɛli woolo pe kan, fɔ nambala pe ni fuun nuŋgba nuŋgba, naa jɛɛlɛ pe ni fuun nuŋgba nuŋgba, pe tɛ yaara naa warifuwe yaara yɛnri pe cɛnyɛɛnlɛ pe yeri.» ");
INSERT INTO dyi_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yawe Yɛnŋɛlɛ làa ti a Izirayɛli woolo pe kala lì Ezhipiti tara fɛnnɛ pe ndanla. Farawɔn wi legbɔɔlɔ poro naa tara woolo pe ni, pàa pye na Moyisi wi jate. ");
INSERT INTO dyi_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","A Moyisi wì si Farawɔn wi pye fɔ: «Sɛnrɛ nda Yawe Yɛnŋɛlɛ lì yo ti nda: ‹Yinndɛgɛ na, mi yaa pan mbe Ezhipiti tara ti yanriyanri, mbe toro. ");
INSERT INTO dyi_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ezhipiti tara woolo pe pinambiile koŋgbanmbala pe ni fuun pe yaa ku laga tara ti ni, mbege lɛ Farawɔn ŋa wi yɛn ma cɛn wa wunluwɔ jɔngɔ ki na wi pinambyɔ koŋgbanŋa wi na, fɔ saga wa kulojɔ wi pinambyɔ koŋgbanŋa ŋa wila yarilire ti tire wa tira ki na wi na, mbe pinlɛ yaayoro ti pinambire koŋgbannda ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Pa kona leele pe yaa kaa gbele ŋgbanga laga Ezhipiti tara ti lagapyew, malɛ ki gbeere cɛnlɛ ta fa pye laga gbɛn, ta se si ka pye laga naa paa ti yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ɛɛn fɔ, wa Izirayɛli woolo pe yeri, ali pyɔn nuŋgba se ka wɛli lere na nakoma yaayogo na, jaŋgo yege jɛn ye yo Yawe Yɛnŋɛlɛ lì Ezhipiti tara fɛnnɛ naa Izirayɛli woolo pe jɛn ma pe wɔ pe yɛɛ ni.› ");
INSERT INTO dyi_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Pa kona ma legbɔɔlɔ mbele yɛɛn, pe ni fuun pe yaa pan na kɔrɔgɔ mbe kanŋguuro kan na jegele sɔgɔwɔ, mbaa na yɛnri la yuun fɔ: Ta kee mboro naa ma woolo pe ni. Ko puŋgo na, pa mi yaa yiri mbe kari.» A Moyisi wì si yiri wa Farawɔn wi tanla naŋgbanwa gbɔɔ ni ma kari. ");
INSERT INTO dyi_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","A Yawe Yɛnŋɛlɛ lì sigi yo Moyisi wi kan naa fɔ: «Farawɔn wi se logo ye yeri, jaŋgo mbe ta mbe kafɔnŋgɔlɔ lɛgɛrɛ pye laga Ezhipiti tara.» ");
INSERT INTO dyi_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moyisi naa Arɔn pàa ki kafɔnŋgɔlɔ ke ni fuun ke pye Farawɔn wi yɛgɛ sɔgɔwɔ. Ɛɛn fɔ, Yawe Yɛnŋɛlɛ làa Farawɔn wi kotogo ki ŋgban wi na, wii yɛnlɛ mbe Izirayɛli woolo pe yaga pe kari pe wɔ wa wi tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si para naa Moyisi naa Arɔn pe ni wa Ezhipiti tara, ma pe pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Ki yeŋge ŋga yɛɛn, ko ki yaa pye yɛlɛ li lɛsaga. Ko ki yaa pye yɛlɛ li yeŋge koŋgbanŋga ye kan. ");
INSERT INTO dyi_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ye saga yo Izirayɛli gbogolomɔ woolo pe ni fuun pe kan fɔ ki yeŋge ŋga yɛɛn, ki pilige kɛ wogo ki na, sege nuŋgba nuŋgba pyew nakoma go nuŋgba nuŋgba pyew ki woolo pe simbapɔlɔ yirifɔnŋɔ nakoma sikapɔlɔ yirifɔnŋɔ yigi pe yɛɛ kan. ");
INSERT INTO dyi_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Na go ŋga woolo si lɛgɛ mbe pye pe mbe ya simbapɔlɔ yirifɔnŋɔ nuŋgba ka mboo kɔ kasaga nuŋgba, ki go woolo pe gbogolo go ŋga ki yɛn le pe tanla ki woolo pe ni, mbe yala leele pe yɔn ki ni. Ye simbapɔlɔ yirifɔnŋɔ wi yigi ye yala lere nuŋgba nuŋgba pyew wi mbe ya kara nda ka to ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ye simbapɔlɔ yirifɔnŋɔ nakoma sikapɔlɔ yirifɔnŋɔ yigi ŋa wì ta yɛlɛ nuŋgba, ma pye jɛrɛgisaga fu. ");
INSERT INTO dyi_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Yoo tɛgɛ ye sa gbɔn fɔ yeŋge ki pilige kɛ ma yiri tijɛrɛ wogo ki na. Ki pilige ki ni, yɔnlɔ ki tosanga ni, Izirayɛli gbogolomɔ woolo pe ni fuun pe yaayoro nda pè wɔ ti kɔnlɔgi. ");
INSERT INTO dyi_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Pe yaa ka kara ti ka yinrɛ nda ni, pe yaayoro ti kasanwa pa lɛ poo fafa ki yeyɔnrɔ ti naayeri tire to naa kɔɔrɔ ti kanŋgara na tire ti na. ");
INSERT INTO dyi_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ki yembinɛ nuŋgba li ni, ye kara ti fɔ tiyɔngɔ, yeri pinlɛ yeri ka leve fu buru naa yaanga taanga ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Yaga ka kara ta ka mbapende nakoma mberi sɔgɔ tɔnmɔ ni mberi ka. Ɛɛn fɔ, ye ti ni fuun ti fɔ tiyɔngɔ, ti yinrɛ, naa ti saanra konaa ti nawa yaara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Yeri ka, yaga ka ta yaga ti wɔnlɔ ti yiri. Na ta ka si wɔnlɔ mbe yiri, ki goto pinliwɛ ni yeri sogo. ");
INSERT INTO dyi_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Na ye kaa ti kaa sanga ŋa ni, ye ye yaripɔrɔ ti le, ye ye kurusijaraye pe pɔpɔ ti na, ye ye sawira ti lele, ye gbɔtangaŋgala ke ni ye kɛɛ mbege naga fɔ yè gbɛgɛlɛ mbaa kee, ye kara ti ka fyɛlɛgɛ na. Pa ye yaa Paki fɛti wi pye yɛɛn mi ŋa Yawe Yɛnŋɛlɛ na mɛgɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«Ki yembinɛ nuŋgba li ni, mi yaa ka Ezhipiti tara ti yanriyanri mbe toro. Mi yaa ka pinambiile koŋgbanmbala pe ni fuun pe gbo laga Ezhipiti tara ti ni, leele pe pinambiile koŋgbanmbala poro naa yaayoro ti pinambire koŋgbannda ti ni. Pa mi yaa kaga pye yɛɛn mbe jɔlɔgɔ wa Ezhipiti tara yarisunndo ti ni fuun ti na. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Kasanwa pi yaa ka pye ye go sigewe kacɛn wa yinrɛ nda ye yaa ka pye ti ni. Mi yaa kaa yan mbe toro mbe ye yaga. Kiga pye ma, na mi kaa jɔlɔgɔ waa Ezhipiti tara woolo pe na sanga ŋa ni, tifɛlɛgɛ yama kpɛ se ye ta mbe ye gbo. ");
INSERT INTO dyi_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«Yege pilige ki tɛgɛ yaa nawa tuun ki na sanga pyew, yege pye fɛti piligbɔgɔ mbaa mi ŋa Yawe Yɛnŋɛlɛ na gbogo, ki pye kondɛgɛlɛ na li yɛn kɔsaga fu ye setirige piile pe kan.» ");
INSERT INTO dyi_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kona, a Yɛnŋɛlɛ lì sho naa fɔ: «Ye yaa leve fu buru ka fɔ sa gbɔn piliye kɔlɔshyɛn. Mbege lɛ le ki piliye yi koŋgbanŋga ki na, leve si daga mbe yan wa ye yinrɛ ti ni. Mbege lɛ pilige koŋgbanŋga ki na sa gbɔn pilige kɔlɔshyɛn wogo ki na, na lere wa ka buru ŋa leve yɛn wi ni wa ka, wi daga poo wɔ laga Izirayɛli woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Pilige koŋgbanŋga naa pilige kɔlɔshyɛn wogo ki na, ye yaa gbogolo mbe shɛri, ye se ka tunŋgo ka kpɛ pye ki piliye yi ni, kaawɔ ye yaakara sɔgɔlɔ tunŋgo ko. ");
INSERT INTO dyi_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Ye yaa kaa leve fu buru fɛti wi piin mbaa nawa tuun fɔ ki pilige jate ŋga ko mìla ye yirige wa Ezhipiti tara. Yege pilige ki tɛgɛ ki yɛ yaa ki fɛti wi piin, ki pye kondɛgɛlɛ na li yɛn kɔsaga fu yoro naa ye setirige piile mbele fuun pe yaa ka yiri ye puŋgo na ye kan. ");
INSERT INTO dyi_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Yɛlɛ li yeŋge koŋgbanŋga ki pilige kɛ ma yiri tijɛrɛ wogo ki na, mbege lɛ ki yɔnlɔkɔgɔ ki na, ye yaa la leve fu buru kaa fɔ sa gbɔn ki pilige nafa ma yiri nuŋgba wogo ki yɔnlɔkɔgɔ ki na. ");
INSERT INTO dyi_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ki piliye kɔlɔshyɛn yi ni, leve si daga mbe yan wa ye yinrɛ ti ni. Lere ŋa fuun ka buru ŋa leve yɛn wi ni wa ka, wi yɛn Izirayɛli tara pyɔ o, wi yɛn nambanŋa o, wi daga poo wɔ wa Izirayɛli gbogolomɔ woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Yaga pye mbe cɛn laga o laga, ye se ka buru ŋa leve yɛn wi ni wa kpɛ ka; ɛɛn fɔ, yaa leve fu buru kaa.» ");
INSERT INTO dyi_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kona, a Moyisi wì si Izirayɛli lelɛɛlɛ pe ni fuun pe yeri ma pe pye fɔ: «Ye kari ye sa simbapɛnɛ yirifɔnmbɔlɔ nuŋgba nuŋgba nakoma sikapɛnɛ yirifɔnmbɔlɔ nuŋgba nuŋgba yigi mbe yala sege nuŋgba nuŋgba pyew ki woolo pe ni, ye pe gbo ye pe pye saragaPaki fɛti wi na. ");
INSERT INTO dyi_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ko puŋgo na, ye yizɔpi wɛrɛ ta kɔn, yaayogo ŋga yè gbo, yège kasanwa pi le leyaraga ŋga ni, yeri le wa ki kasanwa pi ni yeri tɛgɛ yoo fa yeyɔngɔ ki naayeri tige konaa kɔrɔ ki kanŋgara na tire shyɛn ti na. Ye ni, wa kpɛ ka ka wi yeyɔngɔ ki kaanla mbe yiri laga funwa na, fɔ sa gbɔn ki goto pinliwɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Yawe Yɛnŋɛlɛ li yaa ka Ezhipiti tara ti yanriyanri mbe toro, mbe jɔlɔgɔ wa leele pe na. Na liga ka kasanwa pi yan go ŋga yeyɔngɔ naayeri tige naa kɔrɔ ki kanŋgara na tire shyɛn ti na, li yaa ki yeyɔngɔ ki toro, li se ti jɔgɔwɔ pyefɔ wi ye wa ye yinrɛ ti ni mbe jɔgɔwɔ pye wa. ");
INSERT INTO dyi_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Yoro naa ye setirige piile pe ni, ye yaa la tanri ki kakɔnndɛgɛŋgɛlɛ ke na paa kondɛgɛlɛ yɛn, na li yɛn kɔsaga fu. ");
INSERT INTO dyi_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Na yaga ka sa ye wa tara nda Yawe Yɛnŋɛlɛ lì yɔn fɔlɔ lɛ mbe kan ye yeri ti ni, yaa tanri ki ŋgasele li na. ");
INSERT INTO dyi_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na ye piile paga ka ye yewe mbe yo fɔ ki ŋgasele na li kɔrɔ wo yɛn wiwiin? ");
INSERT INTO dyi_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ye pe yɔn sogo ye yo fɔ: ‹Saraga yi, ŋga we yɛn na woo Yawe Yɛnŋɛlɛ li mɛgɛ ni Paki fɛti wi na. Sanga ŋa ni woro Izirayɛli woolo wàa pye wa Ezhipiti tara, làa jɔlɔgɔ wa Ezhipiti tara fɛnnɛ pe na, ɛɛn fɔ, làa we yinrɛ ti toro, lii jɔlɔgɔ wa we na, ma we yinrɛ woolo pe shɔ.› » Kona Izirayɛli woolo pè si fɔli ma Yawe Yɛnŋɛlɛ li gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ko puŋgo na, ŋga fuun Yawe Yɛnŋɛlɛ làa yo Moyisi naa Arɔn pe kan, a Izirayɛli woolo pè si kari ma saa ki pye. ");
INSERT INTO dyi_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ki pilige ki yinndɛgɛ ki na, a Yawe Yɛnŋɛlɛ lì si Ezhipiti tara fɛnnɛ pe pinambiile koŋgbanmbala pe ni fuun pe gbo, maga lɛ Farawɔn ŋa wi yɛn ma cɛn wa wunluwɔ jɔngɔ ki na wi pinambyɔ koŋgbanŋa wi na, fɔ ma saa ki wa kasopyɔ wi pinambyɔ koŋgbanŋa wi na, ma pinlɛ yaayoro ti pinambire koŋgbannda ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ki yembinɛ li ni, a Farawɔn naa wi legbɔɔlɔ konaa Ezhipiti tara fɛnnɛ pe ni fuun pè si yiri. Gbeere la yiri ŋgbanga wa Ezhipiti tara ti lagapyew, katugu go ka sila koro ŋga lere sila ku wa ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Yinndɛgɛ ki na, a Farawɔn wì si Moyisi naa Arɔn pe yeri ma pe pye fɔ: «Ye yiri laga na tara, yaa kee yoro naa Izirayɛli woolo sanmbala pe ni, ye sa Yawe Yɛnŋɛlɛ li gbɔgɔ, paa yɛgɛ ŋga na yège yɛnri we. ");
INSERT INTO dyi_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ye ye yaayoro ti ni fuun ti lɛ, paa yɛgɛ ŋga yège yo we; yaa kee ye yiri laga. Ye sa ye Yɛnŋɛlɛ li yɛnri li duwaw na na.» ");
INSERT INTO dyi_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ezhipiti tara fɛnnɛ pàa pye na Izirayɛli woolo pe fyɛɛlɛ pe yiri wa pe tara ti ni, katugu pàa pye na pe yɛɛ piin fɔ: «We ni fuun we yaa ku.» ");
INSERT INTO dyi_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ki kala na, Izirayɛli woolo pàa yiri na kee pe muwɛ mba pàa gbɔn pi ni, mba leve sila ye pi ni. Pe maa pe muwɛ pi gbɔɔn yaara nda ni, pàa ti fofo wa pe derigbɔrɔ ti ni, mari taga pajoro na. ");
INSERT INTO dyi_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Izirayɛli woolo pàa tanga ma yala ŋga Moyisi wìla yo pe kan ki ni. Pàa warifuwe yaara, naa tɛ yaara, naa yaripɔrɔ yɛnri Ezhipiti tara fɛnnɛ pe yeri. ");
INSERT INTO dyi_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yawe Yɛnŋɛlɛ làa ti, a pe kala li Ezhipiti tara fɛnnɛ pe ndanla, a pè yaara nda Izirayɛli woolo pàa yɛnri pe yeri ti kan pe yeri. Pa pàa ki pye yɛɛn ma Ezhipiti tara fɛnnɛ pe yaara ti koli ma kari ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ko puŋgo na, a Izirayɛli woolo pè si yiri wa Aramisɛsi ca, mɛɛ lɛ na kee wa Sukɔti ca. Pàa pye na kee nambala waga cɛnmɛ kɔgɔlɔni (600 000) yɔn ko yeri, pe sila jɛɛlɛ naa piile poro jiri mbe pe pinlɛ wa. ");
INSERT INTO dyi_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Cɛngɛlɛ kele yɛgɛ woolo la pinlɛ pe ni lɛgɛrɛ na kee. Yaayoro ŋgbeleye lɛgɛrɛ la pye Izirayɛli woolo pe yeri, to tìla pye nɛrɛ, naa simbaala konaa sikaala. ");
INSERT INTO dyi_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Muwɛ mba pàa gbɔn ma yiri pi ni wa Ezhipiti tara, pàa pi wa wɔn; leve sila ye pi ni pi ta pi fɛ pi yiri; katugu pàa pe purɔ ma pe yirige wa Ezhipiti tara fyɛlɛgɛ na. Pe sila ta mbe kondangala yaakara le pe yɛɛ go na. ");
INSERT INTO dyi_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Yɛgɛlɛ ŋgele Izirayɛli woolo pàa pye wa Ezhipiti tara kàa pye yɛlɛ cɛnmɛ tijɛrɛ naa nafa ma yiri kɛ (430). ");
INSERT INTO dyi_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ki yɛgɛlɛ cɛnmɛ tijɛrɛ naa nafa ma yiri kɛ (430) ke kɔsanga wi ni, Paki fɛti pilige ki na, a Yawe Yɛnŋɛlɛ li woolo pè si yiri wa Ezhipiti tara, ma yala pe maliŋgbɔɔnlɔ ŋgbeleye yi ni. ");
INSERT INTO dyi_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ki kala na, ki pilige ki yembinɛ li yaa tɛgɛ li yɛ Yawe Yɛnŋɛlɛ li kan mbe pye fɛti piligbɔgɔ, katugu ki pilige ko làa tɛgɛ ki yɛ mali woolo pe yirige wa Ezhipiti tara ki yembinɛ li ni. Izirayɛli woolo poro naa pe setirige piile mbele fuun pe yaa ka yiri puŋgo na, pe daga mbege tɛgɛ ki yɛ fun, mbege pye fɛti piligbɔgɔ mbaa Yawe Yɛnŋɛlɛ li gbogo. ");
INSERT INTO dyi_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi naa Arɔn pe pye fɔ: «Kondɛgɛŋgɛlɛ ŋgele kè tɛgɛ Paki fɛti wi na ke ŋgele: ‹Nambanŋa wa kpɛ si daga mbege yaakara ta ka. ");
INSERT INTO dyi_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Kulo ŋa pè lɔ penjara ni, wi daga poo kɛnrɛkɛnrɛ, ko puŋgo na, wi mbe ya mbaa Paki fɛti yaakara ti kaa. ");
INSERT INTO dyi_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ɛɛn fɔ, nambannjɛɛn wo naa tunmbyee ŋa pe maa sara, wo wa si daga mbe ta ka. ");
INSERT INTO dyi_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ye yaa ka simbapɔlɔ yirifɔnŋɔ wi kara ti ka wa go nawa. Yaga ka yiri ta ni wa funwa na, yaga si ka yaayogo ki kajelege ka yaari. ");
INSERT INTO dyi_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Izirayɛli gbogolomɔ woolo pe ni fuun pe yaa kaa Paki fɛti wi piin. ");
INSERT INTO dyi_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Na nambanŋa wa ka pye mbe cɛn wa ye yeri mbaa ki jaa mbe Paki shɛrɛgɛ fɛti wi pye mi ŋa Yawe Yɛnŋɛlɛ na mɛgɛ ni, ki daga poo go woolo nambala pe ni fuun pe kɛnrɛkɛnrɛ. Ko puŋgo na wi mbe ya mbe Paki fɛti wi pye paa Izirayɛli tara piile pe yɛn. Lere o lere pe suu kɛnrɛkɛnrɛ wo wa kpɛ si daga mbe Paki fɛti yaakara ta ka.› ");
INSERT INTO dyi_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Yoro Izirayɛli tara piile naa nambannjɛɛnlɛ mbele pe yɛn laga ye sɔgɔwɔ, lasiri konɔ nuŋgba lo ye yaa la tanri li na.» ");
INSERT INTO dyi_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","A Izirayɛli woolo pe ni fuun pè si tanga Yawe Yɛnŋɛlɛ làa sɛnrɛ nda yo Moyisi naa Arɔn pe kan ti na. ");
INSERT INTO dyi_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ki Paki pilige ki ni, ko Yawe Yɛnŋɛlɛ làa Izirayɛli woolo pe yirige wa Ezhipiti tara paa maliŋgbɔɔnlɔ yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Ma Izirayɛli woolo pe pinambiile koŋgbanmbala pe ni fuun pe tɛgɛ pe yɛ na kan, leele pe pinambiile koŋgbanmbala poro naa yaayoro ti pinambire koŋgbannda ti ni; katugu pe yɛn na woolo.» ");
INSERT INTO dyi_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","A Moyisi wì si leele pe pye naa fɔ: «Pilige ŋga Yawe Yɛnŋɛlɛ lì ye yirige ma ye wɔ wa Ezhipiti tara li yawa gbɔɔ pi ni, yaa nawa tuun ki na, ki tara nda yàa pye wa ti ni kulolo we. Ki fɛti pilige kiga gbɔn, yaga ka buru ka ŋa pè leve le wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Yarilire kɔn yeŋge ŋga we yɛn yɛɛn, ki nala pilige ŋga koyi yàa yiri wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yawe Yɛnŋɛlɛ làa wugu ye tɛlɛye pe kan ma yo li yaa tara nda kan ye yeri, na yaga ka sa ye wa ti ni sanga ŋa ni, yaa ki fɛti ŋa wi piin ki yeŋge ŋga ki ni. Ki tara to ti yɛn Kana tara fɛnnɛ, naa Hɛti cɛnlɛ woolo, naa Amɔri cɛnlɛ woolo, naa Hɛvi cɛnlɛ woolo konaa Zhebusi cɛnlɛ woolo pe tara re, ti yɛn ma yin nɔnɔ naa sɛnrɛgɛ ni fɔ na fuun. ");
INSERT INTO dyi_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Piliye kɔlɔshyɛn ni, ye yaa la leve fu buru kaa. Ki pilige kɔlɔshyɛn wogo ki na, ye yaa fɛti pye Yawe Yɛnŋɛlɛ li mɛgɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Leve fu buru ye yaa la kaa fɔ sa gbɔn piliye kɔlɔshyɛn. Buru ŋa pè gbɔn leve ni wa si daga mbe yan wa ye yinrɛ ti ni; leve si daga mbe yan wa ye tara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ki pilige ki ni, ye fɛti wi kɔrɔ wi yo ye pinambiile pe kan, ye pe pye fɔ: ‹We yɛn na ki wogo ŋga ki ni fuun ki piin, mbaa nawa tuun ŋga Yawe Yɛnŋɛlɛ làa pye we kan ki na, sanga ŋa ni wàa yiri wa Ezhipiti tara we.› ");
INSERT INTO dyi_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ki fɛti wi yaa pye paa tɛgɛrɛ yɛn wa ye kɛyɛn yi na, konaa mbe pye paa nandowo yaraga yɛn wa ye walɛgɛlɛ ke na, jaŋgo yaa para suyi Yawe Yɛnŋɛlɛ li lasiri sɛnrɛ ti na; katugu lo lì ye yirige wa Ezhipiti tara ti ni li yawa pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Yaa tanri ki kondɛgɛlɛ li na yɛlɛ pyew, mbe yala wagati ŋa wì kɔn ma tɛgɛ ki wogo ki na wi ni.» ");
INSERT INTO dyi_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Kona, a Moyisi wì sho naa fɔ: «Na Yawe Yɛnŋɛlɛ liga ka ye ye ni wa Kana tara ti ni, mberi kan ye yeri, paa yɛgɛ ŋga na làa wugu ye tɛlɛye poro naa ye kan, ");
INSERT INTO dyi_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ye ye pinambiile koŋgbanmbala pe ni fuun pe kan li yeri, konaa ye yaayoro ti pinambire koŋgbannda pyew ti ni ti pye li woro. ");
INSERT INTO dyi_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Sofilele poro na, ye yaa simbapɛnɛ yirifɔnmbɔlɔ tɛgɛ mbe pe go shɔ; na ye si woro na jaa mbe pe go shɔ, ye pe yinrɛ ti yaari pe ku. Ɛɛn fɔ, ye leele pe pinambiile koŋgbanmbala pe ni fuun pe go shɔ. ");
INSERT INTO dyi_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Na ye piile paga ka ye yewe mbe yo fɔ: ‹Ŋga yaa piin ko kɔrɔ wo yɛn mɛlɛ?› Pa kona ye pe yɔn sogo ye yo fɔ: ‹Yawe Yɛnŋɛlɛ làa we yirige ma we wɔ wa Ezhipiti tara li yawa gbɔɔ pi ni, to nda wàa pye wa ti ni kulolo. ");
INSERT INTO dyi_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Naa Farawɔn wìla pye na jege ma yo wi se we yaga waa kee, a Yawe Yɛnŋɛlɛ lì si Ezhipiti tara fɛnnɛ pe pinambiile koŋgbanmbala pe ni fuun pe gbo, ma pinlɛ yaayoro ti pinambire koŋgbannda ti ni. Ko kala na we yɛn na yaayoro ti pinambire koŋgbannda ti woo saraga Yawe Yɛnŋɛlɛ li yeri, nɛɛ leele pe pinambiile koŋgbanmbala poro go shoo. ");
INSERT INTO dyi_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ki kapyege ki yaa pye paa kacɛn yɛn ye kan wa ye kɛyɛn yi na, mbe pye paa tɛgɛrɛ yɛn wa ye walɛgɛlɛ ke na, mbaa ye nawa tuun ki na fɔ Yawe Yɛnŋɛlɛ làa we yirige ma we wɔ wa Ezhipiti tara li yawa gbɔɔ pi ni.› » ");
INSERT INTO dyi_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Naa Farawɔn wìla kaa Izirayɛli woolo pe yaga a pè kari, Yɛnŋɛlɛ li sila ti pe toro wa konɔ na li maa kee wa Filisiti tara fɛnnɛ pe tara lo ni, ali mbege ta lo li yɛn ma were o; katugu Yɛnŋɛlɛ làa yo fɔ: «Na leele paga sa malaga ta wa pe yɛgɛ, pa pe yinriwɛ mba pè yiri wa Ezhipiti tara, ki wogo ki yaa ye pe go na mbege kan pe sɔngɔrɔ wa naa.» ");
INSERT INTO dyi_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ki kala na Yɛnŋɛlɛ làa ti a pè toro wa konɔ na lì koolo koolo wa gbinri wi ni lo ni, ma kari wa Kɔgɔje yɛɛn wi yeri. Izirayɛli woolo pàa gbɛgɛlɛ ma yiri wa Ezhipiti tara paa maliŋgbɔɔnlɔ yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","A Moyisi wì si Zhozɛfu wi kajeere ti lɛ mbe kari ti ni; katugu Zhozɛfu wìla ki yo Izirayɛli woolo sanmbala pe kan ma yo fɔ: «Ye wugu yanla kan fɔ ye yaa kanla kajeere ti lɛ mbe kari ti ni, katugu Yɛnŋɛlɛ li yaa ye saga (mbe ye yirige laga ki tara nda ti ni).» ");
INSERT INTO dyi_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","A Izirayɛli woolo pè si yiri wa Sukɔti ca ma saa pe paara yinrɛ ti kan ma cɛn wa laga ŋga pàa pye na yinri Etamu, wa gbinri wi koŋgo na. ");
INSERT INTO dyi_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yawe Yɛnŋɛlɛ làa pye na pe yɛgɛ sinni, yɔnlɔ na, kambaaga titɔnlɔgɔ yerege ka ni, na konɔ li nari pe na; yembinɛ làa pye na pe yɛgɛ sinni kasɔn titɔnlɔgɔ yerege ka ni, na yanwa yinrigi pe kan paa yaan, jaŋgo pe ya paa tanri yɔnlɔ naa yembinɛ. ");
INSERT INTO dyi_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Yɔnlɔ na, kambaaga titɔnlɔgɔ yerege kìla pye leele pe yɛgɛ, yembinɛ kìla pye kasɔn titɔnlɔgɔ yerege wa pe yɛgɛ sanga pyew. ");
INSERT INTO dyi_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si para naa Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Ki yo Izirayɛli woolo pe kan, fɔ pe kɛ pe kari, pe sa paara yinrɛ ti kankan pe cɛn wa Pi Ayirɔti ca ki yɛsinmɛ na, wa Migidɔli ca konaa kɔgɔje wi ni, ti sɔgɔwɔ pi ni. Pa ye yaa cɛn wa Baali Zefɔn laga ki yɛsinmɛ na, wa kɔgɔje yɔn ki na. ");
INSERT INTO dyi_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Kona Farawɔn wi yaa ki jate fɔ Izirayɛli woolo pè puŋgo, ma kɔ wa gbinri wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mi yaa Farawɔn wi kotogo ki ŋgban wi na, wi yaa yiri mbe taga ye na mbaa ye puro. Mi yaa wo naa wi maliŋgbɔɔnlɔ pe tɔngɔ mbanla gbɔgɔwɔ pi naga ye na. Pa Ezhipiti tara fɛnnɛ pe yaa ki jɛn mbe yo muwi mi yɛn Yawe Yɛnŋɛlɛ le.» A Izirayɛli woolo pè si tanga ki sɛnrɛ ti na. ");
INSERT INTO dyi_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Naa pàa ka saa ki yo Ezhipiti tara wunlunaŋa Farawɔn wi kan ma yo fɔ: «Izirayɛli woolo pè fe ma kari.» A wo naa wi legbɔɔlɔ pe ni, pè si pe jatere wi kanŋga Izirayɛli woolo pe kanŋgɔlɔ ma sho fɔ: «Yiŋgi kala wè pye yɛɛn? Wè Izirayɛli woolo pe yaga pè kari, pe se kulowo tunndo pye we kan naa.» ");
INSERT INTO dyi_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kì kaa pye ma, a Farawɔn wì si ti a pòo malaga gbɔnwotoro wi pɔ shɔn wa na, mɛɛ lɛ ma kari, wo naa wi maliŋgbɔɔnlɔ pe ni. ");
INSERT INTO dyi_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","A wì suu malaga gbɔnwotoroye jɛmbɛlɛ jɛmbɛlɛ cɛnmɛ kɔgɔlɔni (600) lɛ ma kari, pe ni fuun nuŋgba nuŋgba, maliŋgbɔɔnlɔ taanrindaanri la pye wa pe ni. A Ezhipiti tara malaga gbɔnwotoroye sanmbala pè si taga pe na. ");
INSERT INTO dyi_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","A Yawe Yɛnŋɛlɛ lì si Farawɔn wi kotogo ki ŋgban wi na, Ezhipiti tara wunlunaŋa we. A wì si yiri ma taga Izirayɛli woolo pe na, na pe puro. Ma sigi ta Izirayɛli woolo pàa yiri ma kari pe yɔlɔgɔ ki ni caw. ");
INSERT INTO dyi_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","A Ezhipiti tara maliŋgbɔɔnlɔ pe ni fuun, mbele pàa pye shɔn lugufɛnnɛ, naa mbele pàa pye malaga gbɔnwotoroye pe ni, naa Farawɔn wi shɔnye pe ni, pè si taga Izirayɛli woolo pe na, na pe puro, ma saa pe yigi wa Pi Ayirɔti ca ki tanla, wa Baali Zefɔn laga ki yɛsinmɛ na, wa kɔgɔje yɔn ki na. ");
INSERT INTO dyi_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Naa Farawɔn wìla kaa na yɔngɔ Izirayɛli woolo pe ni, a pè si yɛgɛ yirige ma wele wa lege, mɛɛ Ezhipiti tara fɛnnɛ pe yan pe taga pe na na pe puro; a pè si fyɛ fɔ jɛŋgɛ, nɛɛ gbele na Yawe Yɛnŋɛlɛ li yinri li pe saga. ");
INSERT INTO dyi_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","A pè si Moyisi wi pye fɔ: «Fanra lɛgɛrɛ woro wa Ezhipiti tara wi le? Yiŋgi na, a mà si pan we ni we pan we ku laga ki gbinri ŋa wi ni? Yiŋgi na, a mà si we yirige wa Ezhipiti tara? ");
INSERT INTO dyi_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ki wogo ŋga ko wàa yo ma kan ma we ta bere wa Ezhipiti tara fɔ: ‹Ma we yaga yɛw, we yaa la kulowo tunŋgo piin Ezhipiti tara fɛnnɛ pe kan. Ko mbɔnrɔ we yeri we ku laga gbinri wi ni ko na.› » ");
INSERT INTO dyi_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","A Moyisi wì si pe pye fɔ: «Yaga ka fyɛ, ye yere laga nuŋgba. Yawe Yɛnŋɛlɛ li yaa ye shɔ yɛgɛ ŋga na nala, ye yaa ki yan. Ki Ezhipiti tara fɛnnɛ mbele yaa yaan nala yɛɛn, ye se ka pe yan naa fyew. ");
INSERT INTO dyi_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yawe Yɛnŋɛlɛ li yaa malaga ki gbɔn ye kan. Yoro wo na, ye yere yɛw.» ");
INSERT INTO dyi_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Yiŋgi na, ma nɛɛ na yinri mbe ye saga? Ki yo Izirayɛli woolo pe kan pe yiri paa kee. ");
INSERT INTO dyi_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Mboro wo na, ma kanŋgala li yirige, mɔɔ kɛɛ ki sanga ma wa wa kɔgɔje wi yeri, ma tɔnmɔ pi kɔn shyɛn. Pa Izirayɛli woolo pe yaa tanga tawara na mbe kɔgɔje wi kɔn mbe yiri. ");
INSERT INTO dyi_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mi wo na, mi yaa Ezhipiti tara fɛnnɛ pe kotogo ki ŋgban pe na, mbe ti pe ye wa kɔgɔje wi ni ye puŋgo na. Kona mi yaa Farawɔn wo naa wi maliŋgbɔɔnlɔ pe ni fuun, naa malaga gbɔnwotoroye konaa wi shɔn lugufɛnnɛ pe tɛgɛ mbanla gbɔgɔwɔ pi naga. ");
INSERT INTO dyi_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Na mi ka Farawɔn wo naa wi malaga gbɔnwotoroye, konaa wi shɔn lugufɛnnɛ pe tɛgɛ mbanla gbɔgɔwɔ pi naga sanga ŋa ni, pa Ezhipiti tara fɛnnɛ pe yaa ki jɛn mbe yo muwi mi yɛn Yawe Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Yɛnŋɛlɛ li mɛrɛgɛ ŋa wìla pye wa Izirayɛli woolo pe yɛgɛ, na pe yɛgɛ sinni, a wì si toro wa pe puŋgo na. Kambaaga titɔnlɔgɔ yerege ŋga kìla pye wa pe yɛgɛ, a kì si toro wa pe puŋgo na fun, ");
INSERT INTO dyi_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","mɛɛ pan ma yere Ezhipiti tara fɛnnɛ cɛnsaga konaa Izirayɛli woolo cɛnsaga ti sɔgɔwɔ pi ni. Ki kanŋgɔlɔ nuŋgba la pye diwi pele kan, a ki sanŋga ko na yanwa yinrigi pele kan yembinɛ li ni. Yembinɛ li ni fuun li ni, cɛnsaga ka woolo si gbɔn ka woolo na. ");
INSERT INTO dyi_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","A Moyisi wì suu kɛɛ ki sanga wa kɔgɔje wi go na. A Yawe Yɛnŋɛlɛ lì si ti a tifɛliŋgbɔgɔ kà yiri wa yɔnlɔ yirisaga yeri na gbɔɔn wa kɔgɔje wi ni ki yembinɛ li ni fuun li ni, ma kɔgɔje tɔnmɔ pi wɔnrɔgɔ maa kɔn shyɛn, a lawaga yiri. ");
INSERT INTO dyi_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","A Izirayɛli woolo pè si ye wa kɔgɔje wi nandogomɔ, ma tanga tawara na, maa kɔn ma yiri. Tɔnmɔ pìla kɔn ma gbogolo pi yɛɛ na paa mboro yɛn pe kalige kɛɛ naa pe kamɛŋgɛ kɛɛ ki na. ");
INSERT INTO dyi_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","A Ezhipiti tara fɛnnɛ pè si taga pe na, na pe puro. Farawɔn wi shɔnye pe ni fuun, naa wi malaga gbɔnwotoroye konaa wi shɔn lugufɛnnɛ pè si ye wa kɔgɔje wi nandogomɔ Izirayɛli woolo pe kɔrɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Yinndogo yɔn ki na, ma Yawe Yɛnŋɛlɛ li ta wa kasɔn naa kambaaga titɔnlɔgɔ yerege ki ni, a lì si Ezhipiti tara fɛnnɛ pe maliŋgbɔɔnlɔ ŋgbelege ki kala li gbɔn mali piri pe yeri. ");
INSERT INTO dyi_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A lì si ti a pe malaga gbɔnwotoroye pe ŋgeere tì wɔwɔ pe na, fɔ a pe feŋge kì ŋgban. A Ezhipiti tara fɛnnɛ pè sho fɔ: «Ye ti waa fee Izirayɛli woolo pe yɛgɛ, katugu Yawe Yɛnŋɛlɛ li yɛn na malaga gbɔɔn we ni pe kan.» ");
INSERT INTO dyi_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Ma kɛɛ ki sanga wa kɔgɔje wi go na, jaŋgo tɔnmɔ pi sɔngɔrɔ pi pan Ezhipiti tara fɛnnɛ pe na, naa pe malaga gbɔnwotoroye poro naa pe shɔn lugufɛnnɛ pe na, pi pe li.» ");
INSERT INTO dyi_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","A Moyisi wì suu kɛɛ ki sanga wa kɔgɔje wi go na. Lalaaga ki na, a kɔgɔje tɔnmɔ pì si sɔngɔrɔ wa pi yɔnlɔ. Ezhipiti tara fɛnnɛ pàa pye na fee tɔnmɔ pi yɛgɛ, mɛɛ sun ma tɛrɛ pi na wa pe yɛɛ yɛgɛ. A Yawe Yɛnŋɛlɛ lì si pe jaanri wa kɔgɔje tɔnmɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","A tɔnmɔ pì si sɔngɔrɔ ma pan Farawɔn wi malaga gbɔnwotoroye pe na, ma pe li ma pinlɛ wi shɔn lugufɛnnɛ konaa wi maliŋgbɔɔnlɔ pe ni fuun pe ni; poro mbele pàa ye wa kɔgɔje wi ni Izirayɛli woolo pe puŋgo na, na pe puro. Ali lere nuŋgba wo sila shɔ mbe to. ");
INSERT INTO dyi_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Izirayɛli woolo poro na, pàa tanga tawara na, ma kɔgɔje wi kɔn ma yiri. Tɔnmɔ pìla kɔn ma gbogolo paa mboro yɛn pe kalige kɛɛ naa pe kamɛŋgɛ kɛɛ ki na. ");
INSERT INTO dyi_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ki pilige ki ni, Yawe Yɛnŋɛlɛ làa Izirayɛli woolo pe shɔ Ezhipiti tara fɛnnɛ pe kɛɛ. Pàa Ezhipiti tara fɛnnɛ pe gboolo pe yan pè toori wa kɔgɔje yɔn ki na. ");
INSERT INTO dyi_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Yawe Yɛnŋɛlɛ làa yiri li fanŋga ŋga ni Ezhipiti tara fɛnnɛ pe kɔrɔgɔ, Izirayɛli woolo pàa ki yan. A pè si fyɛ li yɛgɛ, mɛɛ taga lo naa li tunmbyee Moyisi pe na. ");
INSERT INTO dyi_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kona, a Moyisi naa Izirayɛli woolo pe ni, pè sigi yurugo ŋga ki kɔ ma Yawe Yɛnŋɛlɛ li gbɔgɔ ma yo fɔ: Ye ti mbe yurugo kɔ mbe Yawe Yɛnŋɛlɛ li gbɔgɔ, katugu lìli gbɔgɔwɔ pi naga. Lì shɔnye poro naa pe lugufɛnnɛ pe jaanri wa kɔgɔje wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yawe Yɛnŋɛlɛ lo li yɛn na fanŋga ye, lo li yɛn na yurukɔgɔ ki go ye. Lo lìlan shɔ. Lo li yɛn na Yɛnŋɛlɛ le, mi yaa li sɔn. Lo li yɛn na tɛlɛye pe Yɛnŋɛlɛ le, mi yaa li gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yawe Yɛnŋɛlɛ li yɛn malaga gbɔnfɔ gbɔɔ. Li mɛgɛ koyi ŋga Yawe Yɛnŋɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Yawe Yɛnŋɛlɛ lì Farawɔn wi malaga gbɔn wotoroye, naa wi maliŋgbɔɔnlɔ pe ni fuun pe jaanri wa kɔgɔje wi ni. Kɔgɔje yɛɛn wì Farawɔn wi maliŋgbɔɔnlɔ wɛlimbɛlɛ pe li. ");
INSERT INTO dyi_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Tɔnmɔ mba pi maa yinrigi na tuun pì toro pe go na. A pè tigi wa tɔnmɔ pi latijugo ki ni paa sinndɛlɛgɛ yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yawe Yɛnŋɛlɛ, yawa gbɔɔ yɛn ma ni! Ma yawa gbɔɔ po pɔ̀ɔn juguye pe tɔngɔ Yawe Yɛnŋɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ma gbɔgɔwɔ mba pì wɛ yaraga ki ni fuun ki na pi fanŋga na, mɔ̀ɔ juguye pe jaanri. Mɔ̀ɔ naŋgbanwa kala li wa pe na, a lì pe jɔgɔ paa yɛgɛ ŋga na kasɔn ma yan waga sogo we. ");
INSERT INTO dyi_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ma wɔnwɔn tifɛlɛgɛ ki fanŋga na, tɔnmɔ pì gbogolo pi yɛɛ na. Tɔnmɔ mba pila fuun pì gbogolo pi yɛɛ na paa mbogo yɛn. Tɔnmɔ mba pila yinrigi na tuun pì liri wa kɔgɔje wi nandogomɔ. ");
INSERT INTO dyi_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","We juguye pàa pye na yuun fɔ: «We yaa taga pe na la pe puro, sa pe yigi. We yaa sa pe kɛɛ yaara ti koli mberi yɛɛlɛ we yɛɛ na. We yaa we tokobiye pe kɔlɔgi wa pe woforo ti ni mbe pe gbo.» ");
INSERT INTO dyi_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ɛɛn fɔ, mboro wo na Yawe Yɛnŋɛlɛ, mɔ̀ɔ yɔn tifɛlɛgɛ ki fɛ, a kɔgɔje wì pe li. Pè tigi paa sunmu pyɔ yɛn wa tɔnŋgbɔɔ pi latijugo ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yawe Yɛnŋɛlɛ, yarisunndo ti ni fuun ti ni, kikiin ki yɛn ma taanla ma ni? Ambɔ wi yɛn paa mboro yɛn? Ma yɛn kpoyi ma yɔn fili. Ki daga paa fyɛ ma yɛgɛ konaa paa ma sɔnni, mboro ŋa ma maa kafɔnŋgɔlɔ piin we. ");
INSERT INTO dyi_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kapyege nuŋgba mà pye ma fanŋga ki ni, a tara tì si we juguye pe tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ma ndanlawa pi kala na, a mà woro mbele ma woolo we go shɔ, ma yawa pi fanŋga na, a maa we yɛgɛ sinni na kee we ni wa tara kpoyi nda ma yaa kan we yeri ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Cɛngɛlɛ sanŋgala kège wogo ki logo, a kaa seri fyɛrɛ ti kala na. Fyɛrɛ gbɔrɔ Filisiti tara fɛnnɛ pe yigi. ");
INSERT INTO dyi_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edɔmu tara teele pe sunndo wì kɔn pe na. Mowabu tara teele paa seri fyɛrɛ ti kala na. Kana tara fɛnnɛ pe ni fuun pè kotogo la. ");
INSERT INTO dyi_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Jatere pirindorogo naa fyɛrɛ gbɔrɔ la pe yigi. Ma fanŋga ŋga mà tɛgɛ ma we saga kì pe yɔn ki tɔn pe na, a pè pye paa sinndɛlɛgɛ yɛn. Woro mbele ma woolo, fɔ a wè saa toro, Yawe Yɛnŋɛlɛ! Woro mbele ma woolo, a mà we go shɔ, fɔ a wè saa toro. ");
INSERT INTO dyi_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ma yaa kari we ni sa we pye we cɛn wa ma yanwiga ki na, wa cɛnsaga ŋga mà gbegele ma yɛɛ kan ki ni Yawe Yɛnŋɛlɛ, fɔ wa ma laga kpoyi ŋga mà kan ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yawe Yɛnŋɛlɛ li yɛn wunluwɔ, fɔ sanga pyew. ");
INSERT INTO dyi_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Farawɔn wi shɔnye, naa wi malaga gbɔnwotoroye konaa wi shɔn lugufɛnnɛ pàa ye wa kɔgɔje wi ni sanga ŋa ni, Yawe Yɛnŋɛlɛ làa kɔgɔje tɔnmɔ pi sɔngɔrɔ maa wa pe na, a pì pe li. Ɛɛn fɔ, woro Izirayɛli woolo, wàa tanga tawara na ma kɔgɔje wi kɔn ma yiri. ");
INSERT INTO dyi_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Kona, a Arɔn wi njɔ Miriyamu ŋa wìla pye Yɛnŋɛlɛ yɔn sɛnrɛ yofɔ, wì si pimbile kpɛkpɛlɛkpɛ la lɛ nali gbɔɔn. A jɛɛlɛ sanmbala pe ni fuun pè si pan pimbigile kele ni ma taga wi na, na ke gbɔɔn na yoo. ");
INSERT INTO dyi_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","A Miriyamu wì si yurugo le, a Izirayɛli woolo sanmbala pe nɛɛ ki shoo wi yɔn na fɔ: Yaa yurugo koo Yawe Yɛnŋɛlɛ li kan. Lùu gbɔgɔwɔ pi naga. Lì shɔnye poro naa pe lugufɛnnɛ pe jaanri wa kɔgɔje wi ni, a wì pe li. ");
INSERT INTO dyi_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ko puŋgo na, a Moyisi wì si ti a Izirayɛli woolo pè yiri wa Kɔgɔje yɛɛn wi tanla ma kari wa Shuri gbinri wi ni. Pàa tanga pe piliye taanri pe sila tɔnmɔ ta mbe wɔ. ");
INSERT INTO dyi_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","A pè si saa gbɔn wa laga ŋga pàa pye na yinri Mara. Tɔnmɔ mba pàa saa yan wa, pe sila ya mbe pa wɔ, katugu pìla pye ma sori. A pè sigi laga ki mɛgɛ taga naga yinri Mara (ko kɔrɔ wo ŋa sorowo). ");
INSERT INTO dyi_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kona, a leele pe nɛɛ kɔngɔri Moyisi wi na, na yuun fɔ: «Yiŋgi we yaa wɔ?» ");
INSERT INTO dyi_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","A Moyisi wì si Yawe Yɛnŋɛlɛ li yɛnri ŋgbanga li pe saga. A lì si kanŋgekɔngɔ ka naga wi na, a wì sigi lɛ maga wa wa tɔnmɔ pi ni; a tɔnmɔ pì si kanŋga ma tanla. Yawe Yɛnŋɛlɛ làa kondɛgɛŋgɛlɛ naa kakɔnndɛgɛŋgɛlɛ kan Izirayɛli woolo pe yeri wa ki laga ki na. Làa pe wa ma wele wa fun, ");
INSERT INTO dyi_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","mɛɛ pe pye fɔ: «Na ye kaa nuru jɛŋgɛ mi ŋa Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ na yeri, mbaa ŋga ki yɛn ma sin ki piin na yɛgɛ na, na yaga nuŋgbogolo jan mbaa na ŋgasegele ke nuru konaa mbaa tanri na kondɛgɛŋgɛlɛ ke na, pa mi se ka yama mba mìla wa Ezhipiti tara fɛnnɛ pe na pa wa ye na. Katugu muwi mi yɛn Yawe Yɛnŋɛlɛ na li maa ye sagala.» ");
INSERT INTO dyi_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ko puŋgo na, a Izirayɛli woolo pè si kari ma saa gbɔn wa Elimu laga ki na. Puluyo kɛ ma yiri shyɛn la pye wa, konaa sɛngɛndire nafa taanri ma yiri kɛ ni. A pè si pe paara yinrɛ ti kankan wa tɔnmɔ pi tanla ma cɛn le. ");
INSERT INTO dyi_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ko puŋgo na, a Izirayɛli gbogolomɔ woolo pe ni fuun pè si yiri wa Elimu laga ki ni; pe yiriŋgɔlɔ wa Ezhipiti tara, ki yeŋge shyɛn wogo ki pilige kɛ ma yiri kaŋgurugo wogo ki na, a pè si gbɔn wa Sɛn gbinri wi ni, wo yɛn Elimu laga naa Sinayi yanwiga ti sɔgɔwɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","A Izirayɛli gbogolomɔ woolo pe ni fuun pè si kɔngɔri Moyisi naa Arɔn pe na wa gbinri wi ni; ");
INSERT INTO dyi_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","mɛɛ pe pye fɔ: «Ndɛɛ ki pye Yawe Yɛnŋɛlɛ làa ti, a wè ku wa Ezhipiti tara, sanga ŋa ni wàa pye na cɛɛn na kara cɔrɔ ti mari, na kaa na tinni, ko jɛn na mbɔnrɔ we na! Ɛɛn fɔ, yè pan we ni laga ki gbinri ŋa wi ni, mbe pan mbe we ni fuun we kan we ku fuŋgo ki kɛɛ.» ");
INSERT INTO dyi_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Wele, mi yaa yaakara tirige ye kan mbe yiri wa yɛnŋɛlɛ na. Pilige nuŋgba nuŋgba pyew, leele pe yaa yiri mbe sa nda ti yaa pe pilige nuŋgba yaakara bɔ ti wulo. Pa mi yaa ye wa mbe wele yɛɛn, mbege jɛn na kaa pye ye yaa tanga na lasiri sɛnrɛ ti na nakoma ye se tanga ti na. ");
INSERT INTO dyi_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Pilige kɔgɔlɔni wogo ki na, yaakara nda ye yaa wulo mbe sɔgɔ, ti yaa pye pilige nuŋgba woro nda ye ma wulo to tɛgɛsaga shyɛn.» ");
INSERT INTO dyi_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","A Moyisi naa Arɔn pè si Izirayɛli woolo pe ni fuun pe pye fɔ: «Nala yɔnlɔkɔgɔ ŋga ki ni, ye yaa ki jɛn mbe yo Yawe Yɛnŋɛlɛ lo lì ye yirige wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Goto pinliwɛ ni, Yawe Yɛnŋɛlɛ li yaa li gbɔgɔwɔ pi naga ye na; katugu kɔngɔrimɔ mba yaa kɔngɔri li na, lùu logo. Ɛɛn fɔ, woro wo na, we woro yaraga ka yaa kɔngɔri we na.» ");
INSERT INTO dyi_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","A Moyisi wì sho naa fɔ: «Yawe Yɛnŋɛlɛ li yaa kara kan ye yeri, ye ka nala yɔnlɔkɔgɔ ŋga ki ni, goto pinliwɛ ni mbe yaakara kan ye yeri ye ka ye tin. Katugu kɔngɔrimɔ mba yè kɔngɔri li na, lùu logo. Woro wo na, we woro yaraga ka, woro ma ye yɛn na kɔngɔri we na; ɛɛn fɔ, Yawe Yɛnŋɛlɛ lo yaa kɔngɔri li na.» ");
INSERT INTO dyi_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","A Moyisi wì si Arɔn wi pye fɔ: «Ki yo Izirayɛli gbogolomɔ woolo pe ni fuun pe kan fɔ pe kari wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, katugu lì pe kɔngɔrimɔ mba pè kɔngɔri li na pi logo.» ");
INSERT INTO dyi_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ma Arɔn wi ta wìla pye na para Izirayɛli gbogolomɔ woolo pe ni, a pè si kanŋga ma wele wa gbinri kɛɛ ki yeri. Pe mbe ka wele, mɛɛ Yawe Yɛnŋɛlɛ li gbɔgɔwɔ yanwa pi yan pùu yɛɛ naga wa kambaaga ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","A Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Mì Izirayɛli woolo pe kɔngɔrimɔ pi logo. Ki yo pe kan fɔ: ‹Nala yɔnlɔkɔgɔ ŋga, sanni yembinɛ li sa wɔ, ye yaa kara ka, goto pinliwɛ ni fun, ye yaa yaakara ta mbe ka fɔ mbe tin. Kiga pye ma, pa ye yaa ki jɛn mbe yo muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le.› » ");
INSERT INTO dyi_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ki yɔnlɔkɔgɔ ki ni, a siriŋgbangala si pan ma tigi wa paara yinrɛ cɛnsaga ki ni maga tɔn. Ki goto pinliwɛ pi ni, a pè si yiri ma fɔɔngɔ ka yan kì wo ma paara yinrɛ cɛnsaga ki maga. ");
INSERT INTO dyi_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Naa fɔɔngɔ kìla kaa kɔn, pe mbe ka wele, mɛɛ yaara tunmɔɔrɔ kpurukpuru ta yan tì koro wa tara ti na, wa gbinri wi ni. Tìla pye paa tisaga sinndɛɛrɛ yɛn, ma filige. ");
INSERT INTO dyi_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Naa Izirayɛli woolo pàa kaa ti yan, a pe nɛɛ pe yɛɛ yewe na yuun fɔ: «Yiŋgi yaara ri nda to yɛɛn?» Katugu pe sila ti cɛnlɛ li jɛn. A Moyisi wì si pe pye fɔ: «Yaakara nda Yawe Yɛnŋɛlɛ lì kan ye yeri yaa kaa, tori. ");
INSERT INTO dyi_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ŋga lì yo ti wogo ki na ki ŋga: ‹Lere nuŋgba nuŋgba pyew, nda ti yaa wi pilige nuŋgba yaakara bɔ, wi to wulo. Lere nuŋgba wi wulo paa litiri tijɛrɛ si yɛn. Lere nuŋgba nuŋgba pyew wi yaa ti wulo mbe yala lere yɔn ŋga ki yɛn wa wi paraga go ki ni ko ni.› » ");
INSERT INTO dyi_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","A Izirayɛli woolo pè sigi pye ma. Pèle la wulo lɛgɛrɛ, a pèle wulo jɛgɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ɛɛn fɔ, naa pàa kaa nda pàa wulo ti taanla Omɛri wi ni, a pè sigi yan fɔ mbele pàa lɛgɛrɛ wulo, pe sila ta mbe toro; mbele pàa jɛnri wulo, ka sila kɔn pe woro ti na. Pe ni fuun nuŋgba nuŋgba, pàa ta ma yala pe pilige nuŋgba nuŋgba yaakara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","A Moyisi wì si pe pye naa fɔ: «Lere kpɛ ka ka ta tɛgɛ ti wɔnlɔ ti yiri.» ");
INSERT INTO dyi_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ɛɛn fɔ, pele sila logo wi yeri. A pè si ta tɛgɛ fɔ ki goto. A fyɛnrɛ si ye ti ni, a tì si jɔgɔ na lugo. Kona, a Moyisi wì si nawa ŋgban ki leele pe ni. ");
INSERT INTO dyi_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Maga lɛ le kona, pàa pye na manɛ wi wulo pinliwɛ pyew. Lere nuŋgba nuŋgba pyew, wi pilige nuŋgba yaakara to wi ma wulo. Na yɔnlɔ kiga ka yiri la yaa, ŋa wì koro wi ma yan. ");
INSERT INTO dyi_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ɛɛn fɔ, pilige kɔgɔlɔni wogo ki na, a leele pè si piliye shyɛn yaakara wulo. Lere nuŋgba woro tìla pye na kee litiri kɔlɔtaanri yeri. A Izirayɛli gbogolomɔ woolo teele pè si kari ma saa ki yo Moyisi wi kan. ");
INSERT INTO dyi_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","A wì si pe yɔn sogo ma yo fɔ: «Ŋga Yawe Yɛnŋɛlɛ lì yo koyi we. Goto wi yɛn cɛnpilige ye, cɛnpilige ŋga kì tɛgɛ ki yɛ Yawe Yɛnŋɛlɛ li kan. Ye yaa yaakara nda fɔ wa yira wi ni, yeri fɔ nala; ye yaa nda sɔgɔ, yeri sɔgɔ nala. Na yaga ka, nda fuun ka koro, yeri tɛgɛ goto.» ");
INSERT INTO dyi_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Pàa sɔgɔ ma ka nda tìla koro, a pè siri tɛgɛ ki goto woro, paa yɛgɛ ŋga na Moyisi wìla ki yo pe kan. Ti sila jɔgɔ mbaa lugo, fyɛnrɛ sila si ye ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ki goto, a Moyisi wì si pe pye fɔ: «Yaakara nda yàa tɛgɛ, yeri ka nala; katugu nala wi yɛn cɛnpilige ye, ŋga kì tɛgɛ ki yɛ Yawe Yɛnŋɛlɛ li kan. Nala ye se sa manɛ wa yan wa. ");
INSERT INTO dyi_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Yapelege ki ni, ye yaa ki yaakara ti wulo sa gbɔn pilige kɔgɔlɔni. Ɛɛn fɔ, pilige kɔlɔshyɛn wogo ko na, ko ŋga ki yɛn cɛnpilige ye, ye se ka ta ta wa.» ");
INSERT INTO dyi_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Konaa ki ni fuun, pilige kɔlɔshyɛn wogo ki na, leele pèle la yiri wa paara yinrɛ cɛnsaga ki ni, ma kari sa ta wulo, ɛɛn fɔ, pe sila yaraga ka kpɛ yan wa. ");
INSERT INTO dyi_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi yewe naa fɔ: «Ye yaa koro mbaa jege mbe yo ye se tanga na ŋgasegele koro naa na kakɔnndɛgɛŋgɛlɛ ke na fɔ sa gbɔn wagati wiwiin? ");
INSERT INTO dyi_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ye daga mbege jɛn fɔ mi ŋa Yawe Yɛnŋɛlɛ mì cɛnpilige ki kan ye yeri ma yo yaa cɛɛn ki ni, yaa wogo. Ko kala na pilige kɔgɔlɔni wogo ki ni, mi ma piliye shyɛn yaakara kan ye yeri. Pilige kɔlɔshyɛn wogo ki ni, lere nuŋgba nuŋgba pyew wi koro wa wi paraga go ki ni, wa kpɛ ka ka yiri wa wi cɛnsaga.» ");
INSERT INTO dyi_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kona, a leele pè si cɛn ma wogo pilige kɔlɔshyɛn wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","A Izirayɛli woolo pè sigi yaakara ti mɛgɛ taga nari yinri manɛ (ko kɔrɔ wo yɛn yiŋgi yaraga ŋga). Manɛ wìla pye ma filige paa koriyandiri yantiire pire yɛn. Wi tanwa pìla pye paa wɔn ŋa pè sɛnrɛgɛ le wi ni wi yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","A Moyisi wì sho fɔ: «Sɛnrɛ nda Yawe Yɛnŋɛlɛ lì yo ti nda fɔ: ‹Ye manɛ wa lɛ wila kee litiri tijɛrɛ yeri, yoo tɛgɛ ye setirige piile pe kan, jaŋgo ki yaakara nda mila kaan yaa kaa laga gbinri wi ni, ye yiriŋgɔlɔ wa Ezhipiti tara, pe kari yan peri jɛn.› » ");
INSERT INTO dyi_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kona, a Moyisi wì sigi yo ma Arɔn wi kan fɔ: «Cɔgɔ ŋga pe maa yaara teri ki ni, ka lɛ ma manɛ wa le wa ki ni wila kee litiri tijɛrɛ yeri, ko puŋgo na, ma saa tɛgɛ wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, wi koro wa tɛgɛsaga ye setirige piile pe kan.» ");
INSERT INTO dyi_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","A Arɔn wì si manɛ wa le cɔgɔ ka ni ma yala ŋga Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan ki ni, mɛɛ saa cɔgɔ ki tɛgɛ wa li yɔn finliwɛ sɛnrɛ kɛsu wi yɛgɛ sɔgɔwɔ, mbaa pe nawa tuun. ");
INSERT INTO dyi_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Izirayɛli woolo pàa manɛ wi ka fɔ ma saa gbɔn yɛlɛ nafa shyɛn, fɔ leele yɛn ma cɛn tara nda ni ma saa ye ta ni, ko kɔrɔ wo yɛn fɔ ma saa gbɔn wa Kana tara ti kɔnlɔ li na. ");
INSERT INTO dyi_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Omɛri yɛngɛlɛ kɛ koro la pye taanlayaraga ŋga pàa pye na taanla ki ni pilige pyew ki yɛnlɛ nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Izirayɛli gbogolomɔ woolo pe ni fuun pàa yiri wa Sɛn gbinri wi ni ma kari. Pàa pye na tanri na cɛɛncɛɛn na kee ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni, fɔ ma saa gbɔn wa Erefidimu laga ki na. A pè si pe paara yinrɛ ti kankan ma cɛn le. Leele pe sila tɔnmɔ ta wa mbe wɔ. ");
INSERT INTO dyi_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kona, a leele pe nɛɛ wiin Moyisi wi ni na yuun fɔ: «Tɔnmɔ kan we yeri we wɔ!» A Moyisi wì si pe yɔn sogo ma yo fɔ: «Yiŋgi na, a ye nɛɛ wiin na ni? Yiŋgi na, a ye nɛɛ Yawe Yɛnŋɛlɛ li waa na wele?» ");
INSERT INTO dyi_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Wɔgɔ kìla leele pe yigi fɔ jɛŋgɛ. A pe nɛɛ kɔngɔri Moyisi wi na, na yuun fɔ: «Yiŋgi na, a mà si we yirige wa Ezhipiti tara mbe pan mbe we kan we ku lagamɛ, woro naa we piile konaa we yaayoro ŋgbeleye yi ni?» ");
INSERT INTO dyi_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","A Moyisi wì si gbele ma Yawe Yɛnŋɛlɛ li yɛnri li pe saga, ma yo fɔ: «Yiŋgi mi yaa pye ki leele mbele pe kan? Kì koro naa jɛnri, pe yaa na wa sinndɛɛrɛ ni mbanla gbo.» ");
INSERT INTO dyi_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","A Yawe Yɛnŋɛlɛ lì si Moyisi wi yɔn sogo ma yo fɔ: «Keli leele pe yɛgɛ. Ma Izirayɛli lelɛɛlɛ pele wɔ pe pinlɛ ma ni. Kanŋgala na màa tɛgɛ ma Nili gbaan wi gbɔn li ni, mali lɛ naa, maa kee. ");
INSERT INTO dyi_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Wele, mi yaa sa yere wa ma yɛgɛ Horɛbu yanwiga walaga ka go na. Ma saga walaga ki gbɔn ma kanŋgala li ni, pa tɔnmɔ yaa janri mbe yiri wa ki ni, leele pe yaa ta mbe wɔ.» A Moyisi wì si tanga Yawe Yɛnŋɛlɛ li sɛnyoro ti na Izirayɛli lelɛɛlɛ pe yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","A pè sigi laga ki mɛgɛ taga naga yinri Masa naa Meriba (ko kɔrɔ wo ŋa malaga naa wamawelewe), katugu Izirayɛli woolo pàa win Moyisi wi ni, konaa ma Yawe Yɛnŋɛlɛ li wa ma wele, ma yewe fɔ: «Yawe Yɛnŋɛlɛ li yɛn laga we sɔgɔwɔ lee li woro laga we sɔgɔwɔ?» ");
INSERT INTO dyi_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ko puŋgo na, a Amalɛki setirige piile pè si pan ma to Izirayɛli woolo pe na, ma malaga gbɔn pe ni wa Erefidimu. ");
INSERT INTO dyi_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","A Moyisi wì sigi yo Zhozuwe wi kan ma yo fɔ: «Nambala pele wɔ we ni, pe sa malaga gbɔn Amalɛki setirige piile pe ni. Goto mi yaa sa yere wa tinndi wi go na Yɛnŋɛlɛ li kanŋgala li ni na kɛɛ.» ");
INSERT INTO dyi_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","A Zhozuwe wì si tanga ma yala Moyisi wi sɛnrɛ ti ni, mɛɛ kari ma saa malaga gbɔn Amalɛki setirige piile pe ni. Ma si yala Moyisi, naa Arɔn konaa Huri poro la lugu ma kari wa tinndi wi go na. ");
INSERT INTO dyi_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Na Moyisi wiga wi kɛɛ ki yirige wa naayeri, Izirayɛli woolo pe ma fanŋga ta malaga ki na; na wiga wi kɛɛ ki tirige tege ki kala na, Amalɛki setirige piile pe ma fanŋga ta malaga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Naa Moyisi wi kɛyɛn yìla kaa te, a Arɔn naa Huri pè si sinndɛlɛgɛ ka lɛ maga tɛgɛ wi tanla, a wì si cɛn ki na. A pè suu kɛyɛn yi tɔgɔtɔgɔ. Nuŋgba la pye Moyisi wi kɛɛ ŋga na sanŋa wi yɛn wi kɛɛ ŋga na. A wi kɛyɛn yì si koro wa yirigesaga fɔ ma saa yɔnlɔ ki kɔ. ");
INSERT INTO dyi_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","A Zhozuwe wì si ya Amalɛki setirige piile pe ni ma pe gbo tokobi ni. ");
INSERT INTO dyi_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Ki kagala ke yɔnlɔgɔ sɛwɛ na ma ke tɛgɛ, jaŋgo paa nawa tuun ke na. Mɛɛ ki yo Zhozuwe wi kan fɔ mi yaa Amalɛki setirige piile pe gbo mbe pe kɔ pew, fɔ lere wa se ka nawa to pe na laga tara ti na naa.» ");
INSERT INTO dyi_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","A Moyisi wì si saraga wɔsaga kan wa ki laga ki ni, maga mɛgɛ taga naga yinri Adonayi Nisi (ko kɔrɔ wo yɛn fɔ Yawe Yɛnŋɛlɛ li yɛn na dirapo). ");
INSERT INTO dyi_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ko puŋgo na, a wì sho naa fɔ: «Ki kaa pye Amalɛki setirige piile pè pan ma to Yawe Yɛnŋɛlɛ li wunluwɔ pi na, li yaa la wiin pe ni sanga pyew.» ");
INSERT INTO dyi_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Kajɛŋgɛ ŋga fuun Yɛnŋɛlɛ làa pye Moyisi wo naa Izirayɛli woolo pe kan, poro mbele li woolo, Moyisi wi nafɔ lenaŋa Zheturo wìla ki sɛnrɛ ti logo, wo ŋa wìla pye Madiyan tara fɛnnɛ saraga wɔfɔ we; wìla ki logo fun paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa pe yirige wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Zheturo wìla kari Moyisi wi jɔ Sefora wi ni wi kan, wo ŋa Moyisi wìla wi torogo wa wi to Zheturo wi yeri we. ");
INSERT INTO dyi_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Wìla kari Sefora wi pinambiile shyɛn pe ni fun. Pàa pye na nuŋgba yinri Gɛrishɔmu (ko kɔrɔ wo ŋa nambannjɛɛn wa ki laga ŋga ki ni); katugu wìla pye na yuun fɔ: «Mi yɛn nambannjɛɛn tateere ni;» ");
INSERT INTO dyi_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","nɛɛ sanŋa wi yinri Eliyezɛri, (ko kɔrɔ wo ŋa na Yɛnŋɛlɛ lìlan saga), katugu wìla pye na yuun fɔ: «Na to wi Yɛnŋɛlɛ le, lìlan saga mala shɔ Farawɔn wi tokobi wi kɛɛ, wi silan gbo.» ");
INSERT INTO dyi_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Zheturo wìla kari Moyisi wi jɔ Sefora wo naa wi pinambiile shyɛn pe ni wa Moyisi wi yeri, wa gbinri wi ni, wa laga ŋga wìla wi paraga go ki kan ma cɛn, wa Yɛnŋɛlɛ li yanwiga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Wìla ti a pè saa ki yo ma Moyisi wi kan fɔ: «Ma nafɔ Zheturo wi yɛn na paan mbɔɔn shari wo naa ma jɔ naa ma pinambiile shyɛn pe ni.» ");
INSERT INTO dyi_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","A Moyisi wì si yiri ma saa wi nafɔ wi fili, ma fɔli wi yɛgɛ sɔgɔwɔ maa gbɔgɔ, mɛɛ kɛyɛn wa wi yɔlɔgɔ maa shari. A pè si pe yɛɛ yewe na kaa pye pe yɛn ŋgbaanla. Ko puŋgo na, a pè si kari wa Moyisi wi paraga go ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ŋga fuun Yawe Yɛnŋɛlɛ làa pye Farawɔn wo naa Ezhipiti tara fɛnnɛ sanmbala pe na, ma Izirayɛli woolo pe shɔ, a Moyisi wì si ki ni fuun ki yɛgɛ yo wi nafɔ wi kan. Kaŋgbangala ŋgele fuun kàa pe ta wa pe kondangala li ni, wìla ke ni fuun ke yɛgɛ yo wi kan fun, konaa paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa pe shɔ we. ");
INSERT INTO dyi_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Kajɛŋgɛ ŋga fuun Yawe Yɛnŋɛlɛ làa pye ma Izirayɛli woolo pe shɔ Ezhipiti tara fɛnnɛ pe kɛɛ, kìla Zheturo wi nawa pi yinŋgi wi na. ");
INSERT INTO dyi_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","A Zheturo wì sho naa fɔ: «Sɔnmɔ yɛn Yawe Yɛnŋɛlɛ li woo, lo na lì ye shɔ Ezhipiti tara fɛnnɛ poro naa Farawɔn wi ni pe kɛɛ. Lì ye shɔ Ezhipiti tara fɛnnɛ pe kulowo pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Koni mìgi jɛn ma yo lì gbɔgɔ ma wɛ yarisunndo ti ni fuun ti na; katugu lìgi wogo ki pye maga naga, ma sigi ta Ezhipiti tara fɛnnɛ pàa pye na Izirayɛli woolo pe jɔlɔ ndɛɛ pe yaa pe gbo.» ");
INSERT INTO dyi_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","A Moyisi wi nafɔ Zheturo wì si saraga sogowogo naa nayinmɛ saara wɔ Yɛnŋɛlɛ li yeri. A Arɔn wo naa Izirayɛli lelɛɛlɛ pe ni fuun pè si saa pinlɛ ma saraga yaakara ti ka Moyisi wi nafɔ Zheturo wi ni, Yɛnŋɛlɛ li yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ki goto, a Moyisi wì si cɛn mbaa leele pe kagala ke yɛgɛ woo. Leele pàa cɛn Moyisi wi yɛgɛ sɔgɔwɔ, maga lɛ pinliwɛ pi ni fɔ ma saa gbɔn yɔnlɔkɔgɔ ki na. ");
INSERT INTO dyi_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ŋga fuun Moyisi wìla pye na piin leele pe kan, wi nafɔ Zheturo wìla ki yan. A wì si Moyisi wi pye fɔ: «Yiŋgi na, ma nɛɛ leele pe kagala ke yɛgɛ woo ki pyelɔmɔ mba pi na? Yiŋgi na, a mà si cɛn ma yɛ mbaa kagala ke yɛgɛ woo, a leele pè si cɛn ma yɛgɛ sɔgɔwɔ, maga lɛ pinliwɛ pi ni fɔ ma pan ma gbɔn yɔnlɔkɔgɔ ŋga, ma ta ma pe kagala ke yɛgɛ wɔ?» ");
INSERT INTO dyi_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","A Moyisi wì suu nafɔ wi yɔn sogo ma yo fɔ: «Leele paa paan na kɔrɔgɔ, mbe Yɛnŋɛlɛ li yewe, mbeli nandanwa kala li jɛn wa pe kagala ke yɛgɛwɔmɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Na kala la ka ye pe sɔgɔwɔ, pe ma pan na kɔrɔgɔ, mi ma ki kala li yɛgɛ wɔ pe kan. Mi ma Yɛnŋɛlɛ li kondɛgɛŋgɛlɛ koro naa li lasiri sɛnrɛ ti naga pe na.» ");
INSERT INTO dyi_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","A Moyisi wi nafɔ wì suu pye fɔ: «Ma yɛn naga piin yɛgɛ ŋga na, kii yɔn. ");
INSERT INTO dyi_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ma yaa ka ma yɛɛ te, mbe leele mbele paa paan ma kɔrɔgɔ pe te fun; katugu ki tunŋgo ŋga kì wɛ ma fanŋga ki na, ma se ya mbege pye mbege yɔn fili ma nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Koni sɛnrɛ nda mi yaa ma yɛri, ti logo na yeri. Yɛnŋɛlɛ li pye ma sagafɔ. Ma tunŋgo koyi ŋga mbe pye wa leele pe yɔnlɔ Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mbaa pe kagala ke yɛgɛ yuun li kan. ");
INSERT INTO dyi_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ma daga mbe Yɛnŋɛlɛ li kondɛgɛŋgɛlɛ naa li lasiri sɛnrɛ ti naga pe na, mbe pe naga konɔ na pe daga la tanri li ni, konaa kagala ŋgele pe daga la piin ke ni. ");
INSERT INTO dyi_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Koni, nambala pele wɔ leele pe ni fuun pe sɔgɔwɔ, mbele pe yɛn tijinliwɛ fɛnnɛ, na fyɛ Yɛnŋɛlɛ li yɛgɛ, na tanri kaselege ki na, ma pye leele mbele pe se ya pe yɔn tɔn yarikanga ni; ma pe tɛgɛ teele leele pe go na, pe pye teele lere waga keleŋgele (1 000) go na, naa lere cɛnmɛ cɛnmɛ go na, naa lere nafa shyɛn ma yiri kɛ kɛ go na, konaa leele kɛ kɛ go na. ");
INSERT INTO dyi_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Poro pe yaa la leele pe kagala ke yɛgɛ woo pilige pyew. Paa paan kagbɔgɔlɔ koro ni ma kɔrɔgɔ, maa ke yɛgɛ woo. Ɛɛn fɔ, poro jate, paa kagala jɛgɛlɛ jɛgɛlɛ koro yɛgɛ woo. Pa ma yaa ma tunŋgo ki tifaga ma yɛɛ na yɛɛn, katugu pe yaa lɔɔn sari ki na. ");
INSERT INTO dyi_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Na maga ki pye paa yɛgɛ ŋga na mi yɛn nɔɔ yɛrɛgi, Yɛnŋɛlɛ laa ma yɛgɛ sinni, pa ma yaa ya ma tunŋgo ki ni. Pa ki leele mbele pe ni fuun pe yaa sɔngɔrɔ yɛyinŋge na wa pe yirisaga.» ");
INSERT INTO dyi_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","A Moyisi wì si tanga sɛnrɛ nda wi nafɔ wìla wi yɛri ti na, mɛɛ kagala ŋgele fuun wìla yo wi kan ke pye. ");
INSERT INTO dyi_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","A Moyisi wì si nambala tijinliwɛ fɛnnɛ pele wɔ wa Izirayɛli woolo pe ni fuun pe sɔgɔwɔ, ma pe tɛgɛ teele lere waga keleŋgele (1 000) go na, naa leele cɛnmɛ cɛnmɛ go na, naa leele nafa shyɛn ma yiri kɛ kɛ go na konaa leele kɛ kɛ go na. ");
INSERT INTO dyi_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Poro pàa pye na leele pe kagala ke yɛgɛ woo pilige pyew. Pàa pye na paan kaŋgbangala koro ni Moyisi wi kɔrɔgɔ, nɛɛ kagala jɛgɛlɛ jɛgɛlɛ koro yɛgɛ woo pe yɛ. ");
INSERT INTO dyi_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","A Moyisi wì suu nafɔ wi yaga wila kee. A Zheturo wì si sɔngɔrɔ ma kari wi tara. ");
INSERT INTO dyi_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Izirayɛli woolo pe yiriŋgɔlɔ wa Ezhipiti tara, ki yeŋge taanri wogo, ki pilige koŋgbanŋga ki na, a pè si gbɔn wa Sinayigbinri wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Pàa yiri wa Erefidimu laga ki ni, ma saa gbɔn wa Sinayi gbinri wi ni, mɛɛ pe paara yinrɛ ti kankan ma cɛn wa Sinayi yanwiga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","A Moyisi wì si lugu ma kari wa Yɛnŋɛlɛ li yeri wa yanwiga ki go na. A Yawe Yɛnŋɛlɛ lì si koro wa yanwiga ki na ma Moyisi wi yeri maa pye fɔ: «Sɛnrɛ nda ma yaa yo Zhakɔbu setirige piile pe kan, poro mbele pe yɛn Izirayɛli woolo wele, ti nda: ");
INSERT INTO dyi_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹Mì Ezhipiti tara fɛnnɛ pe jɔlɔ yɛgɛ ŋga na, yoro jate yège yan; mì ye lɛ ma pan ye ni lagamɛ paa yɔn ma kaa wi piile lɛ wi kanwira ti na yɛgɛ ŋga na, yège yan fun. ");
INSERT INTO dyi_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Koni, na yaga la nuru na yeri, mbanla yɔn finliwɛ pi yigi, pa ye yaa pye na woolo mbele pe kala li yɛn ma gbɔgɔ na yeri cɛngɛlɛ sanŋgala ke ni fuun ke sɔgɔwɔ. Ali mbege ta tara ti ni fuun ti yɛn na woro o. ");
INSERT INTO dyi_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ɛɛn fɔ, yoro wo na, ye yaa pye wunluwɔ mba pi yɛn saraga wɔfɛnnɛ woo na kan, mbe pye cɛnlɛ na li yɛn kpoyi. Sɛnrɛ nda ma yaa yo Izirayɛli woolo pe kan tori yɛɛn.› » ");
INSERT INTO dyi_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","A Moyisi wì si sɔngɔrɔ ma kari wa paara yinrɛ cɛnsaga ki ni, mɛɛ Izirayɛli lelɛɛlɛ pe yeri, ma sɛnrɛ nda fuun Yawe Yɛnŋɛlɛ làa yo wi kan ti yo pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Kona, a leele pe ni fuun pè si yɔn wa nuŋgba ma yo fɔ: «Ŋga fuun Yawe Yɛnŋɛlɛ lì yo, we yaa la ki ni fuun ki piin.» A Moyisi wì si saa sɛnrɛ nda leele pàa yo ti yo Yawe Yɛnŋɛlɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","A lì si Moyisi wi pye fɔ: «Wele, mi yaa na yɛɛ naga ma na kambaaga wɔgɔ ka ni, mbe para ma ni leele pe ta pege logo, jaŋgo pe taga ma na sanga pyew.» A Moyisi wì si leele pe sɛnyoro ti yo Yawe Yɛnŋɛlɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Sɔngɔrɔ wa leele pe tanla, ma sa pe pye fɔ pe pe yɛɛ pye kpoyi, nala naa goto. Pe pe yaripɔrɔ ti jogo fun. ");
INSERT INTO dyi_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Pe pe yɛɛ gbɛgɛlɛ paa pilige taanri wogo ki singi, katugu ki pilige kiga gbɔn, mi yaa tigi wa Sinayi yanwiga ki go na leele pe ni fuun pe yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ma kɔnlɔ gbɔn pe kan, ma yanwiga ki maga. Mɛɛ pe yɛri fɔ pe pe yɛɛ yingiwɛ jɛn, paga ka lugu wa yanwiga ki na, paga si ka fulo wa ki tanla yɛrɛ, yaraga yɛnwege ŋga fuun ka jiri ki na, ki daga pe ko gbo. ");
INSERT INTO dyi_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Na lere wa ka ki ŋgasele na li jɔgɔ, pe se ka jiri wi na. Ɛɛn fɔ, ki daga poo wa sinndɛɛrɛ ni poo gbo, nakoma poo wɔn wangala ni poo gbo. Na kiga pye yaayogo yi nakoma sɛnwee wi, yaga kaa yaga yinwege na. Na paga ka simbapɔlɔ yɛnrɛgɛ ki win sanga ŋa ni, ko ye pele mbe ya lugu wa yanwiga ki na.» ");
INSERT INTO dyi_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","A Moyisi wì si yiri wa yanwiga ki na ma tigi ma kari leele pe kɔrɔgɔ, mɛɛ ti a pè pe yɛɛ pye kpoyi, konaa ma pe yaripɔrɔ ti jogo. ");
INSERT INTO dyi_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ko puŋgo na, a wì si pe pye fɔ: «Ye ye yɛɛ gbɛgɛlɛ yaa pilige taanri wogo ki singi. Ye ye yɛɛ yingiwɛ jɛn, wa ka ka jɛɛlɛ kala pye.» ");
INSERT INTO dyi_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Pilige taanri wogo ki lalaaga ki na, yɛnŋɛlɛ gbaanra naa yɛnŋɛlɛ yɛngɛlɛmɛ la pye na piin wa yanwiga ki na. A kambaaga wɔgɔ kà si yanwiga ki tɔn. A pè mbanlaga ka magala logo lì yiri ŋgbanga fɔ jɛŋgɛ. A leele pe ni fuun pè si fyɛ nɛɛ seri wa paara yinrɛ cɛnsaga ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","A Moyisi wì si ti a leele pè yiri wa paara yinrɛ cɛnsaga ki ni, mbe fulo wa Yɛnŋɛlɛ li tanla. A pè si saa yere wa yanwiga ki nɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Wirige kìla Sinayi yanwiga ki tɔn lagapyew, katugu Yawe Yɛnŋɛlɛ làa tigi wa ki na, wa kasɔn ki nandogomɔ. Wirige kìla pye na yinrigi wa ki na paa kasɔn gbɔgɔ wirige yɛn. A yanwiga ki ni fuun kì si yɛgɛ ŋgbanga. ");
INSERT INTO dyi_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Mbanlaga ki magala làa pye na yinrigi ŋgbanga na seregi. Moyisi wìla pye na para, a Yɛnŋɛlɛ laa wi yɔn sogo magala gbɔlɔ ni. ");
INSERT INTO dyi_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yawe Yɛnŋɛlɛ làa tigi wa Sinayi yanwiga ki go na, mɛɛ Moyisi wi yeri. A Moyisi wì si lugu wa ki na naa, ma kari li kɔrɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Tigi ma sa leele pe yɛri ma pe pye fɔ paga ka fyɛɛlɛ mbe pan laga mi ŋa Yawe Yɛnŋɛlɛ na yeri, mbanla wele. Na ko ka pye, pa pe lɛgɛrɛ yaa ku. ");
INSERT INTO dyi_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ali saraga wɔfɛnnɛ, poro mbele pe maa fulo na tanla, pe daga mbe pe yɛɛ pye kpoyi, jaŋgo mi ka ka pele gbo pe ni.» ");
INSERT INTO dyi_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","A Moyisi wì si Yawe Yɛnŋɛlɛ li yɔn sogo ma yo fɔ: «Leele pe se ya lugu wa Sinayi yanwiga ki na, katugu mboro jate, màga yo maga ŋgban we ni fɔ we kɔnlɔ gbɔn, we yanwiga ki maga, mbe ti ki pye kpoyi.» ");
INSERT INTO dyi_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Sɔngɔrɔ ma kari wa paara yinrɛ cɛnsaga ki ni. Ko puŋgo na mboro naa Arɔn wi ni, ye pinlɛ ye lugu ye pan laga. Ɛɛn fɔ, saraga wɔfɛnnɛ poro naa leele sanmbala pe ni, paga ka fyɛɛlɛ mbe lugu mbe pan laga na kɔrɔgɔ, jaŋgo mi ka ka pe gbo.» ");
INSERT INTO dyi_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","A Moyisi wì si tigi ma sɔngɔrɔ wa leele pe yeri, ma saa ŋga Yawe Yɛnŋɛlɛ làa yo wi kan ki yɛgɛ yo pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Kona, a Yɛnŋɛlɛ lì sigi sɛnrɛ nda ti ni fuun ti yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Muwi mi yɛn Yawe Yɛnŋɛlɛ, ma Yɛnŋɛlɛ le; muwi mɔ̀ɔ yirige wa Ezhipiti tara, to nda màa pye wa ti ni kulo we. ");
INSERT INTO dyi_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Mɛɛ daga mbe yarisunndo ta yɛgɛ gbɔgɔ mi puŋgo na. ");
INSERT INTO dyi_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Maga ka yarisunŋgo ka tɛ ma yɛɛ kan. Maga si ka yaraga ka yanlɛɛ gbegele ma yɛɛ kan ki yiri yaara nda wa naayeri, wa yɛnŋɛlɛ na ka kɔrɔgɔ, nakoma nda laga tara na ka kɔrɔgɔ, nakosima nda wa tɔnmɔ pi ni, wa tara ti nɔgɔ ka kɔrɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Maga ka fɔli ki yarisunndo ti yɛgɛ sɔgɔwɔ, maga si kari gbɔgɔ; katugu mi ŋa Yawe Yɛnŋɛlɛ, ma Yɛnŋɛlɛ le, mi yɛn Yɛnŋɛlɛ na laa li yenjɔ wi yaga. Teele mbele mi yɛn ma pe mbɛn, mi ma pe kapege ki fɔgɔ tɔn pe piile pe na fɔ sa gbɔn pe setirige piile yirisaga taanri wogo naa tijɛrɛ wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ɛɛn fɔ, mbele mi yɛn ma pe ndanla, a paa tanri na ŋgasegele ke na, mi maa kajɛŋgɛ piin pe setirige piile pe yirisaga lɛgɛrɛ woolo kan. ");
INSERT INTO dyi_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Maga kaa Yawe Yɛnŋɛlɛ li mɛgɛ ki yinri jaga jaga, katugu lere ŋa wi maa mi ŋa Yawe Yɛnŋɛlɛ na mɛgɛ ki yinri jaga jaga, mi se kaa yaga mbajɔlɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Maa nawa tuun cɛnpilige ki na, maga tɛgɛ ki yɛ na kan. ");
INSERT INTO dyi_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ma yaa la tunŋgo piin piliye kɔgɔlɔni ni, mbaa tunndo nda fuun ma yaa la piin ti piin. ");
INSERT INTO dyi_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ɛɛn fɔ, pilige kɔlɔshyɛn wogo ko ki yɛn cɛnpilige ye, ma tɛgɛ ki yɛ mi ŋa Yawe Yɛnŋɛlɛ, ma Yɛnŋɛlɛ le, na kan. Mboro naa ma pinambyɔ, naa ma sumborombyɔ, naa ma kulonaŋa, naa ma kulojɔ, naa ma yaayoro konaa nambanŋa ŋa wi yɛn wa ma yeri, wa kpɛ ka ka tunŋgo pye ye ni ki pilige ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Katugu mi ŋa Yawe Yɛnŋɛlɛ, mì naayeri, naa tara, naa kɔgɔje konaa yaara nda fuun ti yɛn wa ti ni ti da piliye kɔgɔlɔni ni. Pilige kɔlɔshyɛn wogo ki na, a mì si wogo. Ko kala na mi ŋa Yawe Yɛnŋɛlɛ, mì duwaw cɛnpilige ki na, maga tɛgɛ ki yɛ na yɛɛ kan. ");
INSERT INTO dyi_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Ta ma to naa ma nɔ pe gbogo, jaŋgo Yawe Yɛnŋɛlɛ, ma Yɛnŋɛlɛ li yɛn na tara nda kaan ma yeri, ma yinwetɔnlɔgɔ ta wa ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Maga ka lere gbo. ");
INSERT INTO dyi_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Maga ka jataga pye. ");
INSERT INTO dyi_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Maga ka yu. ");
INSERT INTO dyi_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Maga ka yagbolo sɛrɛya yo mbe taga ma lewee yɛnlɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Ma yɛgɛ ka ka yiri ma lewee yɛnlɛ wa go na. Ma yɛgɛ ka ka yiri ma lewee yɛnlɛ wa jɔ na, nakoma wi kulonaŋa, nakoma wi kulojɔ, nakoma wi nɛgɛ, nakoma wi sofile, nakoma wi kɛɛ yaraga ka kpɛ na.» ");
INSERT INTO dyi_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Izirayɛli woolo pe ni fuun pàa pye na yɛnŋɛlɛ gbaanra naa mbanlaga magala li nuru, na yɛnŋɛlɛ yɛngɛlɛmɛ po naa wirige ŋga kìla yanwiga ki tɔn ti yaan. Naa pàa kaa ki yan ma, a pè si yere wa lege. ");
INSERT INTO dyi_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","A pè si Moyisi wi pye fɔ: «Mboro jate mbaa para we ni ma yɛ, we yaa la nuru ma yeri; ɛɛn fɔ, Yɛnŋɛlɛ lo jate, lo ka kaa para we ni li yɛ, jaŋgo waga ka ku.» ");
INSERT INTO dyi_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","A Moyisi wì si pe yɔn sogo ma yo fɔ: «Yaga ka fyɛ. Na yège yan Yɛnŋɛlɛ lì pan yɛɛn, li pan mbe ye wa mbe wele, mbe ti yaa fyɛ li yɛgɛ, jaŋgo yaga ka kapege pye li yɛgɛ na.» ");
INSERT INTO dyi_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Kona, a leele pè si koro wa lege. Yɛnŋɛlɛ làa pye kambaaga ŋga ni, a Moyisi wo si fulo wa ki tanla. ");
INSERT INTO dyi_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Ki sɛnrɛ nda ti yo Izirayɛli woolo pe kan fɔ: ‹Yoro jate yège yan paa yɛgɛ ŋga na mì koro wa naayeri, wa yɛnŋɛlɛ na ma para ye ni. ");
INSERT INTO dyi_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Yaga ka yarisunŋgo ka kpɛ gbegele ye yɛɛ kan warifuwe ni, nakoma tɛ ni mbaa ki gbogo paa na yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ye saraga wɔsaga ka kan na kan joro ni, yaa ye saara sogoworo, naa ye nayinmɛ saara, naa ye sikaala naa simbaala, konaa ye nɛrɛ ti woo saara na yeri wa ki na. Na mi ka ti yanla gbɔgɔ laga o laga ŋga na, mi yaa pan mbe duwaw ye na. ");
INSERT INTO dyi_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Na yaga saraga wɔsaga ka kan na kan sinndɛɛrɛ ni, yaga kaga kan sinndɛɛrɛ nda pè tɛ to ta ni. Katugu na yaga ti tɛ tunŋgo pyeyaraga ni, ye yaa ti tɛgɛ fyɔngɔ ni na yɛgɛ na, ");
INSERT INTO dyi_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Yaga kanla saraga wɔsaga ki kan mbege yagara, mbe lugusaga gbegele ki na, jaŋgo mbele pe yaa la nuru ki na mbaa saara ti woo, leele paga kaa pe fɛrɛ lara ti yaan.› » ");
INSERT INTO dyi_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Kakɔnndɛgɛŋgɛlɛ kele ŋgele, ma ke yɛgɛ yo Izirayɛli woolo pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ye ni, na wa ka wi Eburuye yɛnlɛ wa lɔ kulo, wi yaa tunŋgo pye wi tafɔ wi kan sa gbɔn yɛlɛ kɔgɔlɔni. Yɛlɛ kɔlɔshyɛn wolo li na, wi yaa wɔ wa kulowo pi ni mbe kari yɛyinŋge na, wi se yaraga ka kpɛ sara. ");
INSERT INTO dyi_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Na kaa pye wìla ye wa kulowo pi ni ma yeri, jɛlɛ sila pye wi yeri, wi yaa ka wɔ mbe kari wi nuŋgba. Na kaa pye wìla jɛlɛ pɔri, wi yaa kari wi jɔ wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Na kaa pye wi tafɔ wo wùu kan jɛlɛ, a wì si pinambiile nakoma sumborombiile se wi na, jɛlɛ wo naa piile pe ni poro yaa koro wi tafɔ wi kan; wo nuŋgba wi yaa wɔ mbe kari. ");
INSERT INTO dyi_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ɛɛn fɔ, na naŋa wiga sho fɔ: Na tafɔ, na jɔ nakoma na piile pànla ndanla, ki kala na mi woro na jaa mbe wɔ wa kulowo pi ni, ");
INSERT INTO dyi_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","wi tafɔ wi yaa Yɛnŋɛlɛ li pye wi sɛrɛfɔ, mbe si sa kulonaŋa wi yerege mboo mara go ki kɔrɔ ki na, nakoma wa yeyɔngɔ tige ki na mboo nuŋgbolo li furu wanla ni le ki laga ki na. Kona naŋa wi yaa pye wi tafɔ wi kulo fɔ sanga pyew. ");
INSERT INTO dyi_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Na naŋa wa kaa sumborombyɔ pɛrɛ kulo, wi se ka wɔ wa kulowo pi ni paa yɛgɛ ŋga na kulonaŋa ma wɔ wa kulowo pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Na kaa pye ki kulojɔ wi la kɔ wi tafɔ wi na, ma si yala wìla wi lɔ mboo pɔri, wi tafɔ wi daga mboo yaga sumborombyɔ wi to wuu go shɔ. Wi tafɔ wii daga mboo pɛrɛ nambanmbala pele yeri. Na wiga ko pye, wùu fanla. ");
INSERT INTO dyi_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Na kaa si pye wìla wi lɔ mboo kan wi pinambyɔ yeri wuu pɔri, kapyege ŋga ki daga mbe pye sumborombyɔ kan, ki daga wigi pye wi kan. ");
INSERT INTO dyi_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Na wi tafɔ wiga wi pɔri wi jɔ, puŋgo na mbe jɛlɛ wa yɛgɛ pɔri mbe taga wi na, wiga ka ka kɔn wa jɛlɛ koŋgbanŋa wi yaakara ti na, naa wi yaripɔrɔ konaa wi sinlɛsaga wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Na wi woro na ki kagala taanri ŋgele ke piin jɛlɛ wi kan, jɛlɛ wi mbe ya wɔ wa wi yeri yɛyinŋge na, wi se ka penjara kpɛ sara. ");
INSERT INTO dyi_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Na lere wa kaa lewee yɛnlɛ wa gbɔn mboo gbo, ki daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Konaa ki ni fuun, na kaa pye wi sigi jate wa wi nawa mbe lara mboo gbo, ɛɛn fɔ, mi ŋa Yɛnŋɛlɛ, muwi mì ti wì fara wi ni, ŋa wì gboro ti pye wi daga mbe fe sa karafa lara nda mi yaa ka naga ye na ka ni. ");
INSERT INTO dyi_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","«Ɛɛn fɔ, na lere wa kaga siligi mbe tijinliwɛ pee pye, mboo lewee yɛnlɛ wa gbo, yoo gbo. Ali na ki ka pye pa wi saa karafa wa na saraga wɔsaga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Na lere wa ka wi to nakoma wi nɔ gbɔn, wi daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Na lere wa ka lere yu mboo pɛrɛ, nakoma pe sa ŋa pè yu wi yan wa wi yeri bere, ki daga pe ki lerefɔ wi gbo. ");
INSERT INTO dyi_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Lere ŋa ka wi to nakoma wi nɔ daŋga, ki daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«Na leele ka win, a nuŋgba sanŋa wi gbɔn sinndɛlɛgɛ ni nakoma kɛŋgunɔ ni mboo wɛlɛgɛ, ŋa pè gbɔn na wii ku, ɛɛn fɔ, na wiga pye sinlɛsaga, ");
INSERT INTO dyi_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","na wiga ka ya mbe yiri naa, mbaa yanri kanŋgaga na wa funwa na, lere ŋa wì gbɔnrɔ ti pye, wii daga poo gbo. Konaa ki ni fuun, ŋa wì wɛlɛgɛ, wagati ŋa wì pye wa sinlɛsaga, wi daga mbege penjara ti kan wi yeri konaa mbe yere wi ni fɔ wi sa sagala. ");
INSERT INTO dyi_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Na lere wa ka kanŋgaga tɛgɛ mboo kulonaŋa nakoma wi kulojɔ gbɔn ki ni mboo gbo, ki daga pege kayaŋga wɔ wi tafɔ wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ɛɛn fɔ, ŋa pè gbɔn kanŋgaga ki ni, na wiga pilige nuŋgba nakoma piliye shyɛn pye, na wii ku, paga kaga kayaŋga wɔ wi tafɔ wi ni, katugu wi kɛɛ yaraga yi. ");
INSERT INTO dyi_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Na nambala pele kaa wiin mbe sa jɛlɛ kugbɔ fɔ wa tɛrɛ mbe ti wi kugbɔ ki yiri, na kala la yɛgɛ si jɛlɛ wi ta naa, jɛlɛ wi pɔlɔ wiga fɔgɔ ŋga wa pe na, pe yaa ki sara mbe yala yɛgɛ ŋga na kiti kɔnfɛnnɛ pè yɛnlɛ ki na we. ");
INSERT INTO dyi_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ɛɛn fɔ, na kala la yɛgɛ ka jɛlɛ wi ta, ma ti pe jɔlɔgɔ wa pe na mbe yala ŋga kì pye ki ni; pe yaa wi gbo mbe ŋa wì ku wi yinwege ki fɔgɔ tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Yɛnlɛ li yaa tɛgɛ mbe yɛnlɛ li fɔgɔ tɔn. Ŋganla li yaa tɛgɛ mbe ŋganla li fɔgɔ tɔn, kɛɛ ki yaa tɛgɛ mbe kɛɛ ki fɔgɔ tɔn, jele li yaa tɛgɛ mbe jele li fɔgɔ tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Maga lere sogo, pe yaa ma sogo mbege fɔgɔ tɔn. Maga lere wɛlɛgɛ, pe yaa ma wɛlɛgɛ mbege fɔgɔ tɔn. Maga lere gbɔn mboo tɔngɔlɔ, pe yaa ma gbɔn mbɔɔn tɔngɔlɔ mbege fɔgɔ tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Na naŋa wa kaa kulonaŋa nakoma wi kulojɔ gbɔn mboo yɛnlɛ la ya, wi yaa wi wɔ wa kulowo pi ni wi yɛnlɛ na lì ya li kala na. ");
INSERT INTO dyi_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Na wiga wi gbɔn mboo ŋganla la kaw wi na, wi yaa wi wɔ wa kulowo pi ni ŋganla na lì kaw li kala na. ");
INSERT INTO dyi_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Na nɛgɛ ka naŋa nakoma jɛlɛ gbɔn yɛnnɛ ni mboo gbo, pege wa sinndɛɛrɛ ni pege gbo. Paga kaga kara ti ka. Pe se si ka jɔlɔgɔ wa nɛgɛ fɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ɛɛn fɔ, na kaa pye nɛgɛ ki maa leele gbɔɔn yɛnnɛ ni faa, a pège yo nɛgɛ fɔ wi kan, wi si woro na wele ki na, kona ki ka lere gbo, pe yaa ki wa sinndɛɛrɛ ni mbege gbo, mbege fɔ wi gbo fun. ");
INSERT INTO dyi_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Na paga fɔgɔ wa nɛgɛ fɔ wi na mbe yo wigi tɔn wuu yɛɛ go shɔ, yaraga ŋga fuun pè naga, wi daga mbege kan. ");
INSERT INTO dyi_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Na nɛgɛ ki ka pinambyɔ nakoma sumborombyɔ gbɔn yɛnnɛ ni mboo gbo, pege kala nuŋgba li pye nɛgɛ fɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Na nɛgɛ kiga kulonaŋa nakoma kulojɔ wa gbɔn yɛnnɛ ni mboo gbo, nɛgɛ fɔ wi daga mbe warifuwe pyɔ nafa ma yiri kɛ kan kulo wi tafɔ wi yeri; ko puŋgo na pe nɛgɛ ki wa sinndɛɛrɛ ni pege gbo. ");
INSERT INTO dyi_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Na lere wa ka tɔnmɔ wege yɛngɛ mbege yaga yɛnlɛgɛ, nakoma na wiga tɔnmɔ wege wɔ wi sigi tɔn, na nɛgɛ nakoma sofile ka to wa ki ni, ");
INSERT INTO dyi_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","wi daga mbe nɛgɛ ki yɔngɔ sara ki fɔ wi yeri. Pa kona yaayogo kugo ki yaa koro wegefɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«Na lere wa nɛgɛ ka lere wa nɛgɛ gbɔn mbege gbo, pe yaa nawee wi pɛrɛ mbege penjara ti yɛɛlɛ poro yaayoro fɛnnɛ shyɛn pe yɛɛ na, mbe yaayogo kugo ki wali pe yɛɛ na fun. ");
INSERT INTO dyi_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ɛɛn fɔ, na kaa pye kì jɛn faa fɔ ki nɛgɛ ki maa gbɔɔn, nɛgɛ fɔ wi si woro na wele ki na, wi daga mbe nawee kan nakugofɔ wi yeri ki yɔngɔ. Pa kona nakugo ki yaa koro nawee wɔfɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","«Na lere wa ka nɛgɛ yu, nakoma sumbyɔ, nakoma sugbɔ, mboo gbo nakoma mboo pɛrɛ, wi daga mbe nɛrɛ kaŋgurugo kan nɛgɛ ŋga wì yu ki yɔngɔ, mbe simbaala nakoma sikaala tijɛrɛ kan ŋa wì yu wi yɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Na paga yoo yigi wi yɛn na go ka kɔrɔ kaari, paga wi gbɔn wiga ku, ŋa wi gbɔnrɔ ti pye pe se kaa jate legbolere. ");
INSERT INTO dyi_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ɛɛn fɔ, na ki kala liga pye yɔnlɔ na, lere ŋa wì gbɔnrɔ ti pye, wi daga mbaa jate legbolere. Yoo wi daga mbe yaraga ŋga wì yu ki sara. Na yaraga woro wi yeri, wi daga poo pɛrɛ kulo pe yaraga ki fɔgɔ tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","«Yaayogo ŋga wì yu, na ki ka pye nɛgɛ, nakoma sofile, nakoma sumbyɔ, nakoma sugbɔ, a pè saa ki yan wa wi yeri wege, wi yaa ki yɔngɔ shyɛn sara. ");
INSERT INTO dyi_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","«Na lere wa kaa yaayoro yaga, ti ka sa lere wa kɛrɛ nakoma wi ɛrɛzɛn kɛrɛ jɔgɔ, yaayoro fɔ wi daga mboo kɛrɛ ti yarilire jɛndɛ nakoma wi ɛrɛzɛn pire jɛndɛ ta kan kɛrɛ fɔ wi yeri ki yɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«Na lere wa ka kasɔn le wuuro ni, a tì sogo ma saa ye lere wa kɛrɛ nawa, mbe bile pɔgɔlɔ kele sogo, nakoma bile ŋa wi yɛn yere na ma yanlaga, nakoma mbe kɛrɛ ti ni fuun ti sogo, kasɔn lefɔ wi daga mbe yaara nda tì sogo ti yɔngɔ kan kɛrɛ fɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«Na lere wa ka penjara nakoma wi yarijɛndɛ kan lere wa yeri wiri tɛgɛ wi kan, na yoo wa ka sari yu wa wi go, na paga yoo wi yigi, wi yaa ti yɔngɔ shyɛn sara. ");
INSERT INTO dyi_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ɛɛn fɔ, na pee yoo wi ta mboo yigi, ŋa wì yaara ti shɔ mari tɛgɛ wi yaa Yɛnŋɛlɛ li pye wi sɛrɛfɔ, mbe wugu mbege naga fɔ wo yɛrɛ ma wùu lewee yɛnlɛ wi yaara ti lɛ mari ta. ");
INSERT INTO dyi_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Na leele shyɛn kaa kiti nɛgɛ go na, nakoma sofile, nakoma sumbyɔ, nakoma sugbɔ, nakoma yaripɔgɔ nakoma yaraga ŋga kì puŋgo ka go na, pe ni fuun shyɛn pe yaa kari wa Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. Na Yɛnŋɛlɛ li ka ŋa jɛrɛgi, wi yaa ki yaraga ki yɔngɔ shyɛn kan sanŋa wi yeri. ");
INSERT INTO dyi_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«Na lere wa ka sofile, nakoma nɛgɛ, nakoma sumbyɔ nakoma sugbɔ nakoma yaayoro sannda pyew ka kan wi lewee yɛnlɛ wa yeri wila ki wele wi kan, na yaayogo ki ka ku, nakoma ki tɔlɔgɔ mbe kaw ki na, nakoma yoolo mbege yu, lere ka kaga yan, ");
INSERT INTO dyi_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","lere ŋa pè yaayogo ki kan wi yeri wila ki wele, wi yaa wugu Yawe Yɛnŋɛlɛ li mɛgɛ ki na mbege naga fɔ wo yɛrɛ ma wùu lewee yɛnlɛ wi yaayogo ki lɛ mbege ta. Yaayogo fɔ wi yere ki wuguro ti na, wiga ka yaraga ka shɔ ki yɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ɛɛn fɔ, na wi ka ti paga yaayogo ki yu wi yeri, wi yaa ki yɔngɔ kan yaayogo fɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Na kaa pye cɛngɛ kìgi gbo maga ka, maga kɔɔnlɔ yuroyuroyuro, wi daga mbe pan ki kɔnrɔkɔnrɔ ti ni, mbege naga fɔ cɛngɛ kìgi gbo. Pa kona wi sege yɔngɔ kan. ");
INSERT INTO dyi_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","«Na lere wa ka yaayogo jin lere wa yeri, na yaayogo ki ka ki yɛɛ wɛlɛgɛ nakoma na ki ka ku yaayogo fɔ wi puŋgo na, lere ŋa wìgi jin wi yaa ki yɔngɔ kan ki fɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ɛɛn fɔ, na kaa pye ki kala lì pye yaayogo fɔ wi yɛgɛ na, ŋa wìgi jin wi sege yɔngɔ kan ki fɔ wi yeri. Na kaa pye wìla yaayogo ki lɛ sara na, ki penjara ti yaa koro wa ki yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","«Na naŋa wa ka sumboro ŋa wi fa naŋa kala jɛn, pe fa suu kan naŋa yeri wa fanla mbe sinlɛ wi ni, wi daga mbe japɔrɔgɔ yariwɔndɔ ti kan sumboro wi to wi yeri mboo pɔri wi jɔ. ");
INSERT INTO dyi_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Na sumboro wi to wiga je mbe yo wi soo kan wi yeri, japɔrɔgɔ yariwɔndɔ nda ti ma wɔ sumboro naŋa mbanjɛɛn wogo na, ŋa wì sumboro wi fanla, wi yaa ti wɔ mberi kan sumboro wi to wi yeri. ");
INSERT INTO dyi_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","«Yaga ka lekaajɔ wa yaga go na. ");
INSERT INTO dyi_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«Lere ŋa fuun ka sinlɛ yaayogo ni, ki daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«Lere ŋa fuun ka saara wɔ yarisunŋgo ka yɛgɛ yeri, na wi siri wɔ Yawe Yɛnŋɛlɛ lo nuŋgba yeri, wi daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«Nambanmbala mbele pe yɛn ma cɛn wa ye sɔgɔwɔ, yaga kaa pe fanla la pe nii, yaga si kaa pe jɔlɔ; katugu yoro fun yàa pye nambanmbala wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Yaga kaa naŋgunjaala poro naa pijiriwele pe jɔlɔ. ");
INSERT INTO dyi_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Na ye kaa pe jɔlɔ, paga gbele mbanla yɛnri mbe pe saga, pa mi yaa pe yɛnrɛgɛ ki logo. ");
INSERT INTO dyi_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Mi yaa nawa ŋgban ye ni mbe ti ye ku malaga. Pa kona ye jɛɛlɛ pe yaa pye naŋgunjaala, ye piile pe yaa pye fun pijiriwele. ");
INSERT INTO dyi_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","«Na yaga penjara fɔgɔ taga yoro mbele na woolo wa na, ŋa wi yɛn fyɔnwɔ fɔ, yaga kaga pye paa fɔgɔ tagafɛnnɛ pe wogo ki yɛn, mbaa tɔnli jaa ki go na. ");
INSERT INTO dyi_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«Na maga ma lewee yɛnlɛ wa derigbɔgɔ shɔ wi yeri mbege tɛgɛ ma kɛɛ yaraga ŋga wì shɔ mbe kaga sɔngɔrɔ ma na ki yɔnlɔ, ki daga maa derigbɔgɔ ki sɔngɔrɔ wi na sanni yɔnlɔ ki sa kɔ; ");
INSERT INTO dyi_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","katugu ko nuŋgba ki yɛn wi yeri wi paritɔnŋgɔ mboo yɛɛ tɔn ki ni were ti na. Na ko woro wa, wi yaa wi yɛɛ tɔn yiŋgi ni mbe ta mbe wɔnlɔ? Na wiga gbele mbanla yeri mboo saga, mi yaa wi yɛnrɛgɛ ki logo, katugu mi yɛn Yɛnŋɛlɛ na li yɛn yinriwɛ tafɔ. ");
INSERT INTO dyi_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","«Yaga ka mi ŋa ye Yɛnŋɛlɛ na tɛgɛlɛ, yaga si ka ye woolo pe to wi daŋga. ");
INSERT INTO dyi_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Yarikanra nda ye daga mbe kan na yeri mbe yiri wa ye yarilire fɔnndɔ koŋgbannda to naa ye ɛrɛzɛn pire tɔnmɔ koŋgbanmba pi ni, yaga ka mɔ mbe pan ti ni. Ye ye pinambiile koŋgbanmbala pe kan na yeri fun. ");
INSERT INTO dyi_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«Ye nanɛɛlɛ, naa simbanɛɛlɛ konaa ye sikanɛɛlɛ pe pinambire koŋgbannda, yeri kan na yeri yarikanra fun. Ti seŋgɔlɔ, yeri yaga wa ti nɛɛlɛ pe tanla piliye kɔlɔshyɛn, ki kɔlɔtaanri wogo ki na, yee ti kan na yeri yarikanra. ");
INSERT INTO dyi_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","«Ye daga mbe pye na woolo mbele pe yɛn kpoyi na kan. Cɛngɛ ka yaraga gbo mbe ka ki na, yaga kaga kara ta ka; yeri wa pyɔɔnlɔ pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Yaga kaa yagbogolo sɛnrɛ yari, yaga si ka gbogolo lepee wa ni mbe yagbolo sɛrɛya yo. ");
INSERT INTO dyi_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Yaga ka taga lelɛgɛrɛ sɛnrɛ na mbe kapege pye. Na paga ye yeri kiti kɔngɔ na mbe yo ye sa sɛrɛya yo, yaga ka wele lelɛgɛrɛ sɛnyoro to na, mbe sɛrɛya wi yo mbe tɔn kaselege ki na. ");
INSERT INTO dyi_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Yaga ka kiti kɔn mbege tanla lere wa na, ali mbege ta wi yɛn fyɔnwɔ fɔ. ");
INSERT INTO dyi_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Na yaga ye jugu wi nɛgɛ nakoma wi sofile yan wì puŋgo, yoo kɔnri ye kari wi ni wi kan. ");
INSERT INTO dyi_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Na yaga ye jugu wi sofile wi yan wì to wi tuguro ti ni, yaga kaa toro, ɛɛn fɔ, yoo saga wuu yirige, wuu yerege wi tɔɔrɔ ti na. ");
INSERT INTO dyi_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Yaga ka wele lere wa yɛn fyɔnwɔ fɔ ko kala na mbe kiti kɔn mbe tɔn kaselege ki na. ");
INSERT INTO dyi_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Yaga ka ye yɛɛ le yagbogolo sɛnrɛ ta ni. Yaga ka lere ŋa wi yɛn jɛrɛgisaga fu ma pye sinŋɛ wa gbo; katugu mi se ka kapere pyefɔ wa yaga mbajɔlɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Yaga ka yarikanga shɔ, ŋga ki yaa ye go jɔgɔ kala la yɛgɛ wɔmɔ na; katugu yarikanga ki ma leele mbele pe yɛngɛlɛ ke yɛn ma yɛngɛ pe pye paa fyɔɔnlɔ yɛn. Yarikanga ki ma ti lesinmbele paa ya mbe kaselege ki yo. ");
INSERT INTO dyi_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Yaga kaa nambanmbala mbele pe yɛn ma cɛn wa ye tara pe jɔlɔ. Nambanra kapyege ki yɛn yɛgɛ ŋga na, yège jɛn, katugu yoro fun yàa pye nambanmbala wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Yɛlɛ kɔgɔlɔni mbe taga yɛɛ na, ye yaa la fali tara ti na mbaa yariluguro nuru mbaa ti kɔɔn. ");
INSERT INTO dyi_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ɛɛn fɔ, yɛlɛ kɔlɔshyɛn wolo li na, ye tara ti yaga ti wogo, yaga ka fali ti na. Ye sefɛnnɛ mbele pe yɛn fyɔnwɔ fɛnnɛ, paga sa yaraga ŋga ta wa, ko ki yaa pye pe yaakara. Nda ka koro wa, to yaa pye woŋgaala pe yaakara. Ko nuŋgba ko ye yaa pye ye ɛrɛzɛn kɛɛrɛ naa ye oliviye tire kɛɛrɛ wogo ki na fun. ");
INSERT INTO dyi_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«Ye yaa la ye tunndo ti piin piliye kɔgɔlɔni ni, ɛɛn fɔ, pilige kɔlɔshyɛn wogo ki na, ye yaa ye tunndo ti yerege, jaŋgo ye nɛrɛ, naa ye sofilele ti ta ti wogo; ye kulojaala pe pinambiile poro naa ye nambanmbala pe ta pe wogo fun. ");
INSERT INTO dyi_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Sɛnrɛ nda fuun mì yo ye kan, yaa tanri ti na. Yaga kaa yarisunndo ta yɛgɛ yinri ti ye saga. Yaga kaa para ti sɛnrɛ na yɛrɛ.» ");
INSERT INTO dyi_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Kona, a Yawe Yɛnŋɛlɛ lì sho naa fɔ: «Yɛlɛ nuŋgba nuŋgba pyew, fɛti taanri ye yaa pye na mɛgɛ ni mbanla gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Fɛti koŋgbanŋa ŋa ye yaa pye, wo wi yɛn leve fu buru fɛti we. Ye yaa leve fu buru ka sa gbɔn piliye kɔlɔshyɛn, Abibu yeŋge ki ni, mbe yala wagati ŋa mì kɔn ma tɛgɛ wi ni, katugu Abibu yeŋge ki ni, ko yàa yiri wa Ezhipiti tara. Ye ni, wa kpɛ ka ka pan laga na yɛgɛ sɔgɔwɔ kɛwara. ");
INSERT INTO dyi_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ko puŋgo na, yaara nda yè lugu wa ye kɛɛrɛ ti ni, ye maa ki yarilire fɔnndɔ koŋgbannda ti kɔɔn sanga ŋa ni, ye yaa yarilire kɔngɔ fɛti wi pye. Ko puŋgo na, mbaa kee wa yɛlɛ li kɔsaga yeri, na yaga ye yarilire kɔngɔ tunndo ti pye wa ye kɛɛrɛ mbe kɔ, ye yaa yarilire kɔnŋgɔlɔ fɛti wi pye. ");
INSERT INTO dyi_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Yɛlɛ nuŋgba nuŋgba pyew, nambala pe ni fuun pe yaa pan pansaga taanri mi ŋa ye Fɔ, Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Yarikanga ŋga leve ma ye ki ni, yaga ka ka pinlɛ yaayoro saara kasanwa ni mbe wɔ na yeri. Yaga ka yaayoro nda yè gbo ma wɔ na yeri saraga ti yanlaga ki tɛgɛ ki wɔnlɔ ki yiri. ");
INSERT INTO dyi_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Yaa paan ye kɛrɛ yarilire fɔnndɔ koŋgbannda ti ni wa mi ŋa Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ na gbɔgɔgo ki ni. Yaga ka sugbɔ yirifɔnŋɔ sɔgɔ wa wi nɔ yinriwɛ pi ni.» ");
INSERT INTO dyi_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Kona, a we Fɔ wì sho naa fɔ: «Ye wele, mi yaa na mɛrɛgɛ wi kelegi wa ye yɛgɛ, wila wele ye na wa ye kondangala li ni, fɔ sa ye ye ni wa tara nda mì gbɛgɛlɛ ye kan ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Yaa wi gbogo yaa tanri wi sɛnrɛ ti na. Na yaga yiri mbe je, wi se kaga kala yaga ye na, katugu wo wi yɛn wa na yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ɛɛn fɔ, na yaga la nuru wi yeri sanga pyew, mbaa tanri na sɛnrɛ ti ni fuun ti na, pa mi yaa pye ye mbɛnfɛnnɛ pe mbɛnfɔ konaa ye winfɛnnɛ pe winfɔ. ");
INSERT INTO dyi_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","«Na mɛrɛgɛ wi yaa keli ye yɛgɛ mbaa ye yɛgɛ sinni sa ye ye ni wa Amɔri cɛnlɛ woolo, naa Hɛti cɛnlɛ woolo, naa Perɛzi cɛnlɛ woolo, naa Kana tara fɛnnɛ, naa Hɛvi cɛnlɛ woolo konaa Zhebusi cɛnlɛ woolo pe tara. Mi yaa ki leele pe ni fuun pe tɔngɔ pew. ");
INSERT INTO dyi_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Yaga ka fɔli pe yarisunndo ti yɛgɛ sɔgɔwɔ mbaa ti gbɔgɔ. Yaga kaa pe kapyere pyelɔmɔ pi fɔrɔgi. Ɛɛn fɔ, ye pe yarisunndo nda pe gbegele ti jɔgɔ, sinndɛɛrɛ nda pè yerege yerege na sunnu ti na, yeri gbɔn yeri jaanri yeri yaari. ");
INSERT INTO dyi_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mi ŋa Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le, yaa mi nuŋgba gbogo. Pa kona mi yaa duwaw ye na mbe yaakara jɛndɛ kan ye yeri, naa wɔtɔnmɔ ni, mbe ye shɔ yama pi kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Wa ye tara, jɛlɛ kugbɔ se ka jɔgɔ, jambasee se ka pye wa. Mi yaa yinwetɔnlɔgɔ kan ye yeri. ");
INSERT INTO dyi_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«Ye kaa yɔngɔ tara nda ni, mi yaa ti fyɛrɛ gbɔrɔ mbe ki leele pe yigi. Yaga ye leele mbele fuun tara, mi yaa ti paa fee ye yɛgɛ. Mi yaa ti ye mbɛnfɛnnɛ pe ni fuun paa fee ye yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mi yaa ndagasere tugbɔɔrɔ torogo wa ye yɛgɛ, ti sa Hɛvi cɛnlɛ woolo, naa Kana tara fɛnnɛ konaa Hɛti cɛnlɛ woolo pe purɔ wa ye yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ɛɛn fɔ, mi se ka ki leele pe ni fuun pe purɔ wa ye yɛgɛ yɛlɛ nuŋgba li ni, nakoma tara ti yaa koro waga, yanyaara ti yaa lɛgɛ, mbe yiri ye kɔrɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mi yaa la ye mbɛnfɛnnɛ pe puro wa ye yɛgɛ jɛɛnnjɛnri sanni ye sa lɛgɛ ye tara ti shɔ yeri ta. ");
INSERT INTO dyi_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mi yaa ti ye tara ti kɔnlɔ li lɛ wa Kɔgɔje yɛɛn wi na fɔ sa gbɔn wa Filisiti tara fɛnnɛ pe kɔgɔje wi na, konaa mbe lɛ wa Sinayigbinri wi na fɔ sa gbɔn wa Efirati gbaan wi na; katugu mi yaa ki tara woolo pe le ye kɛɛ, ye pe purɔ wa ye yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Yaga ka yɔn finliwɛ le pe ni, yaga si ka pye yɔn finliwɛ na pe yarisunndo ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Yaga ka pe yaga pe cɛn ye ni wa ye tara, jaŋgo paga ka ye fanla ye kapege pye na na. Na yaga la pe yarisunndo ti gbogo ti yaa pye paa pɛnɛ yɛn mbe ye yigi.» ");
INSERT INTO dyi_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Kona, a Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Lugu ma pan laga yanwiga ki na mi ŋa Yawe Yɛnŋɛlɛ na yeri, mboro naa Arɔn, naa Nadabu, naa Abiyu konaa Izirayɛlilelɛɛlɛ nafa taanri ma yiri kɛ ni. Ye yaa koro wa lege mbe fɔli mbanla gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ko puŋgo na, Moyisi mboro nuŋgba ma yaa fulo laga na tanla. Mbele pè pinlɛ ma lugu ma ni, paga ka fulo laga na tanla; leele sanmbala paga ka lugu wa yanwiga ki na.» ");
INSERT INTO dyi_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","A Moyisi wì si sɔngɔrɔ ma saa Yawe Yɛnŋɛlɛ li sɛnyoro to naa li kakɔnndɛgɛŋgɛlɛ ke ni fuun ke yo Izirayɛli woolo sanmbala pe kan. A leele pè si yɔn wa nuŋgba ma pinlɛ ma yo fɔ: «Ŋga fuun Yawe Yɛnŋɛlɛ lì yo, we yaa ki pye.» ");
INSERT INTO dyi_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kona, a Moyisi wì si Yawe Yɛnŋɛlɛ li sɛnyoro ti ni fuun ti yɔnlɔgɔ. Ki goto yirifaga ki na, a wì si yiri ma saraga wɔsaga kan wa yanwiga ki nɔgɔ, mɛɛ sinndɛɛrɛ kɛ ma yiri shyɛn yerege ma yala Izirayɛli cɛngɛlɛ kɛ ma yiri shyɛn ke yɔn ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","A wì si Izirayɛli tara lefɔnmbɔlɔ pele wɔ ma yo pe sa saara sogoworo wɔ Yawe Yɛnŋɛlɛ li yeri, pe napɛnɛ pele gbo, pe pe wɔ nayinmɛ saara li yeri. ");
INSERT INTO dyi_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","A Moyisi wì si yaayoro nda pàa gbo ti kasanwa pi tɔgɔ maa walaga le leyaara ta ni, mɛɛ pi walaga sanmba pi yanragi yanragi saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ko puŋgo na, a wì si yɔn finliwɛ sɛwɛ wi lɛ maa kara ŋgbanga leele pe kan. A Izirayɛli woolo pè sho fɔ: «Ŋga fuun Yawe Yɛnŋɛlɛ lì yo we yaa ki pye. We yaa la tanri li sɛnrɛ ti ni fuun ti na.» ");
INSERT INTO dyi_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Kona, a Moyisi wì si kasanwa mba pìla pye wa leyaara ti ni pi lɛ maa yanragi yanragi leele pe na, mɛɛ pe pye fɔ: «Yɔn finliwɛ mba Yawe Yɛnŋɛlɛ lì le ye ni, mbe yala sɛnrɛ nda fuun lì yo ti ni, kasanwa mba po pi yɛn naga wogo ki nari naga finligi.» ");
INSERT INTO dyi_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ko puŋgo na, a Moyisi wì si lugu wa yanwiga ki na wo naa Arɔn, naa Nadabu, naa Abiyu, konaa Izirayɛli lelɛɛlɛ nafa taanri ma yiri kɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","A pè si poro Izirayɛli woolo Yɛnŋɛlɛ li yan. Li tɔɔrɔ nɔgɔ kɛɛ kìla pye paa yaraga ka yɛn ma yiri safiri sinndɛlɛgɛ sɔnŋgbanga wogo kɔrɔgɔ, ma laga kpoyi paa yɛgɛ ŋga na yɛnŋɛlɛ li yɛgɛ ki ma kaa sulu we. ");
INSERT INTO dyi_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ɛɛn fɔ, ali mbege ta pàa Yɛnŋɛlɛ li yan, li sila kapege pye Izirayɛli woolo teele pe na. Pàa li wele jɛŋgɛ, ko puŋgo na, a pè si li ma wɔ. ");
INSERT INTO dyi_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Lugu ma pan na kɔrɔgɔ laga yanwiga ki go na, ma koro laga. Sinndɛɛrɛ papara papara nda mìla lasiri sɛnrɛ to naa na ŋgasegele ke yɔnlɔgɔ ti na, mi yaa ti kan ma yeri, jaŋgo ma saa Izirayɛli woolo pe nari ti ni.» ");
INSERT INTO dyi_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","A Moyisi wì si yiri wo naa wi tunmbyee Zhozuwe wi ni, mɛɛ lugu wa Yɛnŋɛlɛ li yanwiga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Wìla Izirayɛli lelɛɛlɛ pe pye fɔ: «Ye we sige laga Arɔn naa Huri pe ni fɔ we sa sɔngɔrɔ we pan. Na kala ka wa ta ye ni, wi kaa jaa peli yɛgɛ wɔ, yege yo pe kan.» ");
INSERT INTO dyi_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moyisi wìla lugu ma kari wa yanwiga ki go na, kambaaga kìla pye maga tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","A Yawe Yɛnŋɛlɛ li gbɔgɔwɔ yanwa pì si tigi wa Sinayi yanwiga ki na. A kambaaga kì sigi tɔn ma saa gbɔn piliye kɔgɔlɔni. Piliye kɔlɔshyɛn wogo ki na, a lì si koro wa kambaaga ki nandogomɔ ma Moyisi wi yeri. ");
INSERT INTO dyi_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Yawe Yɛnŋɛlɛ li gbɔgɔwɔ yanwa pìla pye Izirayɛli woolo pe yɛgɛ na wa yanwiga ki na paa kasɔn yɛn ŋga ki yɛn na yiin. ");
INSERT INTO dyi_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","A Moyisi wì si ye wa kambaaga ki nandogomɔ, mɛɛ lugu bere ma kari wa yanwiga ki go na. Wìla koro wa yanwiga ki na piliye nafa shyɛn, ki yɔnlɔ naa ki yembinɛ. ");
INSERT INTO dyi_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Ki yo Izirayɛli woolo pe kan fɔ pe yarikanra lagala wa pe yarijɛndɛ ti na, peri kan na yeri. Ye yaa ti shɔ mbele pe yaa ti kan nayinmɛ ni poro yeri. ");
INSERT INTO dyi_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Yarikanra nda ye yaa shɔ pe yeri ti nda: Tɛ, naa warifuwe naa tuguyɛnrɛ, ");
INSERT INTO dyi_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","naa ŋganra jese, naa jese yɛɛn kpanyi, naa kondoro jese, naa lɛn jese ŋgbaan, naa jese ŋa pe pili sikanɔ sire ni, ");
INSERT INTO dyi_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","naa simbapɛnɛ sɛɛrɛ nda pè le kondoro, naa sɛɛrɛ liire ni, naa akasiya tire ni, ");
INSERT INTO dyi_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","naa fitanla sinmɛ ni, naa nuwɔ taanyaara nda pe ma gbegele sinmɛ kpoyi ta ni konaa wusuna nuwɔ taan ŋa pe ma sogo; ");
INSERT INTO dyi_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","naa sinndɛɛrɛ sɔnŋgbanga woro nda pe yinri ɔnikisi, naa sinndɛɛrɛ sɔnŋgbanga woro ta yɛgɛ ni, nda pe yaa maramara yaripɔgɔ ŋga pe yinri Efɔdi ki na, konaa yaripɔgɔ ŋga pe ma le ma wa kotogo na ki na. ");
INSERT INTO dyi_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Yoro Izirayɛli woolo ye yaa cɛnsaga kpoyi ka kan na kan, jaŋgo mbe cɛn wa ye sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ye yaa na cɛnsaga paraga go ko naa ki tunŋgo pyeyaara ti gbegele mbe yala cɛnlɔmɔ mba mi yaa naga ma na po ni.» ");
INSERT INTO dyi_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Ye yaa kɛsu wa gbegele akasiya tire ni. Wi titɔnlɔwɔ pi yaa pye mɛtɛrɛ nuŋgba naa mɛtɛrɛ kɔngɔ ki kɔngɔ. Wi gbemɛ pi yaa pye mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. Wi yagawa pi yaa pye fun mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ye yaa tɛ piiri wo kɛsu wi nawa naa wi puŋgo ki na mboo tɔn, mbe wa wo wi yɔn ki na mbege maga mbege fili. ");
INSERT INTO dyi_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ye yaa tɛ wa gbɔn ŋgereye tijɛrɛ, mbeyi le kɛsu wi yɛngɛlɛ tijɛrɛ ke na. Ye yaa shyɛn le kanŋgɔlɔ nuŋgba na, mbe shyɛn le kanŋgɔlɔ sanŋga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ye yaa akasiya tige kanŋgagala shyɛn tɛ, mbe tɛ wo ke na mbe ke tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ye yaa ke le wa ŋgereye yi ni wa kɛsu wi kanŋgara ti na, mbe ke tɛgɛ mbaa wi lee. ");
INSERT INTO dyi_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Kanŋgagala ke daga mbe koro wa kɛsu wi na, pe se ka ke wɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Yɔn finliwɛ sɛnrɛ sɛwɛ ŋa mi yaa kan ma yeri, maa le wa kɛsu wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Ye yaa kapere ti kasulugo pyesaga ki gbegele tɛ piiri ni. Ki titɔnlɔwɔ pi yaa pye mɛtɛrɛ nuŋgba naa mɛtɛrɛ kɔngɔ ki kɔngɔ. Ki gbemɛ pi pye mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. Ko ki yaa pye kɛsu wi yaritɔnŋgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ye tɛ gbɔn wi yɛɛ na ye sherubɛnye yanlɛɛlɛ shyɛn gbegele wa kasulugo pyesaga ki yinrɛ shyɛn ti na. ");
INSERT INTO dyi_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","«Ye yaa sherubɛn nuŋgba gbegele go nuŋgba na, mbe sanŋa wi gbegele go sanŋga ki na. Ye yaa pe gbegele wa kapere ti kasulugo pyesaga ki yinrɛ shyɛn ti na, pe yiri ki go na. ");
INSERT INTO dyi_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ki sherubɛnye pe yaa pe kanwira ti yirige, mberi jaraga kapere ti kasulugo pyesaga ki go na, mbege tɔn ti ni, mbe yɛgɛ wa pe yɛɛ yeri, mbaa kapere ti kasulugo pyesaga ki wele. ");
INSERT INTO dyi_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Na maga ka yɔn finliwɛ sɛnrɛ sɛwɛ wi le wa kɛsu wi ni mbe kɔ, ye kapere ti kasulugo pyesaga ŋga ki yɛn wi yaritɔnŋgɔ ki taga wi na yoo tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Pa mi yaa lanla yɛɛ nari ma na wa kapere ti kasulugo pyesaga ki go na, wa kɛsu wi na sherubɛnye shyɛn pe sɔgɔwɔ; pa mi yaa lanla ŋgasegele ke ni fuun ke kaan wa ma yeri, maa ke yuun Izirayɛli woolo pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Ye tabali wa kan akasiya tire ni. Wi titɔnlɔwɔ pi yaa pye mɛtɛrɛ nuŋgba, wi gbemɛ pi pye mɛtɛrɛ kɔngɔ, wi yagawa pi pye mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ye yaa tɛ piiri wo wi na mboo tɔn, mbe wa wo wi yɔn koŋgo ki na mboo maga mboo fili. ");
INSERT INTO dyi_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ye yaa tige papagapa ka kan tabali wi kanŋgara ti na, mboo maga mboo fili, ki gbemɛ pi pye paa kɛndala gbemɛ yɛn. Ye tɛ wo ki yɔn koŋgo ki na kɛɛrɛ yege maga, yege fili. ");
INSERT INTO dyi_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ye yaa ŋgereye tijɛrɛ gbegele tɛ ni, mbeyi kan tabali wi yɛngɛlɛ tijɛrɛ ke na, mbe mara wi jegele tijɛrɛ ke na. ");
INSERT INTO dyi_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ŋgereye yi yaa pye wa tabali wi kanŋgara ti na, tige papagapa ki tanla. Pa ye yaa la kanŋgagala ke nii wa yi ni, mbaa tabali wi lee. ");
INSERT INTO dyi_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ye yaa akasiya tige kanŋgagala shyɛn tɛ, mbe tɛ wo ke na mbe ke tɔn. Koro ye yaa tɛgɛ mbaa tabali wi lee. ");
INSERT INTO dyi_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ye yaa yaapire nda pe yaa la gbegele ti ni wa tabali wi na ti gbegele. To ti yɛn tasaala kpakpalakpa, naa wɔjɛŋgɛlɛ, naa kugbogolo konaa duvɛn saraga ŋga pe ma wo wi leyaara ti ni. Ye ti ni fuun ti gbegele tɛ piiri ni. ");
INSERT INTO dyi_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Buru ŋa pe ma kan na yeri, yaa wi teri wa ki tabali wi na, na yɛgɛ sɔgɔwɔ sanga pyew. ");
INSERT INTO dyi_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Ye yaa tɛ piiri gbɔn mbe fitanladaga gbegele, wi nɔgɔ, naa wi njegele, naa wi leyaara yanlɛrɛ ti ni, naa wi gbunŋgbunŋgolo, konaa wi yarifyɛɛnrɛ yanlɛrɛ ti ni, yeri pinlɛ yeri gbegele nuŋgba fitanladaga wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Njegele kɔgɔlɔni yaa pye fitanladaga wi kɛyɛn shyɛn yi na; taanri yaa pye kɛɛ ŋga na, taanri mbe pye kɛɛ sanŋga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ye yaa leyaara yanlɛrɛ taanrindaanri gbegele fitanladaga wi njegele kɔgɔlɔni ke ni fuun nuŋgba nuŋgba ke na, paa amandi tige pige yɛn, naa ki gbunŋgbunŋgolo konaa ki fyɛɛnrɛ yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Leyaara yanlɛrɛ tijɛrɛ yaa pye fitanladaga wi na paa amandi tige pire yɛn, naa wi gbunŋgbunŋgolo konaa wi fyɛɛnrɛ yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Gbunŋgbunŋgolo nuŋgba nuŋgba daga mbe pye fitanladaga wi kɛyɛn shyɛn njegele ke filisaga pyew ki nɔgɔ, wa fitanladaga wi na. ");
INSERT INTO dyi_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Gbunŋgbunŋgolo koro naa njegele ke ni ke yaa pinlɛ mbe gbegele mbe pye nuŋgba fitanladaga wi ni, ti ni fuun ye yaa tɛ piiri gbɔn mberi gbegele. ");
INSERT INTO dyi_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ye yaa fitanlaye kɔlɔshyɛn gbegele wa fitanladaga wi na, mbe ti paa yiin paa yanwa kaan wa wi yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ye yaa fitanla yɔn yirigeyaara naa wi cɔnrɔ leyaara ti gbegele tɛ piiri ni. ");
INSERT INTO dyi_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ye tɛ piiri culo nafa ma yiri kɛ lɛ, yoo tɛgɛ ye fitanladaga wo naa wi tunŋgo pyeyaara ti gbegele. ");
INSERT INTO dyi_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Mboro Moyisi, cɛnlɔmɔ mba mì naga ma na wa yanwiga ki na, ma yɛɛ yigi, ma sa yaara ti gbegele ma yala pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Mboro Moyisi, ma yaa kapyɔ jɛnfɛnnɛ pe pye pe paara titɔɔnrɔ kɛ ti lɛn jese ŋgbaan ni, naa ŋganra jese, naa kondoro jese konaa jese yɛɛn kpanyi ni, yeri tɛgɛ yanla cɛnsaga paraga go ki gbegele. Pe sherubɛnye yanlɛɛlɛ gbegele wa paara ti na; kapyɔ jɛnfɛnnɛ mbege tunŋgo ki pye. ");
INSERT INTO dyi_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Paraga nuŋgba nuŋgba pyew, ki titɔnlɔwɔ pi yaa pye mɛtɛrɛ kɛ ma yiri tijɛrɛ, ki gbemɛ pi yaa pye mɛtɛrɛ shyɛn. Paara ti ni fuun ti daga mbe pye ma. ");
INSERT INTO dyi_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ye yaa paara ti kaŋgurugo yɔli mberi kan ti yɛɛ na, ti pye nuŋgba, mbe sannda ti yɔli mberi kan ti yɛɛ na ma fun. ");
INSERT INTO dyi_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Paara kaŋgurugo nda ye yaa keli mbe yɔli mberi kan ti yɛɛ na, ye ŋganra jese maŋgala pɔpɔ paraga kaŋgurugo wogo ki yɔn na. Paara kaŋgurugo sannda nda ye yaa yɔli mberi kan ti yɛɛ na, ye ŋganra jese maŋgala kele pɔpɔ fun wa paraga kaŋgurugo wogo ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Maŋgala nafa shyɛn ma yiri kɛ ke yaa pye paara koŋgbannda ti kaŋgurugo wogo ki yɔn na, maŋgala nafa shyɛn ma yiri kɛ mbe pye paara sannda ti kaŋgurugo wogo ki yɔn na. Ti ni fuun shyɛn, ti maŋgala ke daga mbe pye yɛsinmɛ nuŋgba na, mbe yala ke yɛɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Kandɔɔlɔ yaŋgala ŋgele pe ma tɛgɛ na yaara yinri ke ni, ye kele gbegele tɛ ni, ke pye nafa shyɛn ma yiri kɛ. Koro ye yaa tɛgɛ mbe paara ti yɔnrɔ ti yigi mberi kan ti yɛɛ na, jaŋgo paraga go ki pye nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«Ko puŋgo na, ye yaa paara titɔɔnrɔ kɛ ma yiri nuŋgba gbegele sikanɛɛlɛ sire ni, to mbe pye na cɛnsaga paraga go ki tɔnparaga. ");
INSERT INTO dyi_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ki paara ti ni fuun nuŋgba nuŋgba, ti titɔnlɔwɔ pi yaa pye mɛtɛrɛ kɛ ma yiri kaŋgurugo kaŋgurugo, ti gbemɛ pi yaa pye mɛtɛrɛ shyɛnzhyɛn. Ti ni fuun ti yaa pye mbe yala. ");
INSERT INTO dyi_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Yeri kaŋgurugo yɔli yeri kan ti yɛɛ na, yeri kɔgɔlɔni sannda ti yɔli yeri kan ti yɛɛ na. Paara kɔgɔlɔni nda ye yaa yɔli mberi kan ti yɛɛ na, yeri kɔgɔlɔni wogo ki kaw shyɛn wa paraga go ki yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Paara kaŋgurugo nda yè keli ma yɔli ma kan yɛɛ na, ye yaa maŋgala nafa shyɛn ma yiri kɛ pɔpɔ ti kaŋgurugo wogo ki yɔn na. Paara kɔgɔlɔni sannda nda yè yɔli ma kan yɛɛ na fun, ye yaa maŋgala nafa shyɛn ma yiri kɛ pɔpɔ ti kɔgɔlɔni wogo ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ye yaa kandɔɔlɔ yaŋgala gbegele tuguyɛnrɛ ni, ke pye nafa shyɛn ma yiri kɛ. Ye yaa ke lele wa maŋgala ke ni, mbe paara kaŋgurugo nda yè yɔli ma kan yɛɛ na konaa kɔgɔlɔni nda yè yɔli ma kan yɛɛ na ti yɔnrɔ shyɛn ti pɔ yɛɛ na, jaŋgo paraga go ki pye nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Paraga kɔgɔlɔni wogo ki yaa tɔnlɔ mbe toro cɛnsaga paraga go ki titɔnlɔwɔ pi na. Ki walaga nuŋgba yaa to wa cɛnsaga paraga go ki puŋgo na mbege tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Mɛtɛrɛ kɔngɔ nuŋgba nuŋgba yaa koro paraga titɔnlɔgɔ ki yinrɛ shyɛn ti ni fuun nuŋgba nuŋgba ti na, mbe tigitigi mbe cɛnsaga paraga go ki kɛyɛn shyɛn yi ni fuun yi tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Simbapɛnɛ sɛɛrɛ nda pè le kondoro, ye ta lɛ yeri tɛgɛ ye paraga go ki tɔn ti ni. Ye sɛlɛgɛ lirige ka pye paritɔnŋgɔ, yege wa ti ni fuun ti go na yeri tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«Ye akasiya tire tɛ go tire papara papara, yeri kan yanla cɛnsaga paraga go ki yerege ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ki tire papara papara ti ni fuun nuŋgba nuŋgba, ti titɔnlɔwɔ pi yaa pye mɛtɛrɛ kaŋgurugo kaŋgurugo, ti gbemɛ pi pye mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ye yaa jegele shyɛnzhyɛn wɔwɔ tire papara papara ti ni fuun nuŋgba nuŋgba ti na, ke sinzin ke yɛɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ye yaa ki tire papara papara ti nafa gbegele na cɛnsaga paraga go ki yɔnlɔparawa kalige kɛɛ ki kanwa wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ye yaa tire papara papara ti nɔgɔna cɛnyaara ti nafa shyɛn gbegele warifuwe ni, mberi tɛgɛ shyɛnzhyɛn tire papara papara ti ni fuun nuŋgba nuŋgba ti nɔgɔ, mberi jegele ke lele wa ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ye yaa tire papara papara ti nafa gbegele na cɛnsaga paraga go ki yɔnlɔparawa kamɛŋgɛ kɛɛ ki kanwa wogo ki na, ");
INSERT INTO dyi_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","konaa ti nɔgɔna cɛnyaara ti nafa shyɛn ni, yeri gbegele warifuwe ni. Yeri lele shyɛnzhyɛn wa tire papara papara ti ni fuun nuŋgba nuŋgba ti nɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ye yaa tire papara papara kɔgɔlɔni gbegele na cɛnsaga paraga go ki puŋgo kɛɛ ki kanwa wogo ki na, wa yɔnlɔ tosaga yeri. ");
INSERT INTO dyi_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ye yaa tire papara papara shyɛn gbegele na paraga go ki yɛngɛlɛ puŋgo wogolo ke kanwa wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ki tire papara papara shyɛn ti yaa lɛ wa nɔgɔna mbe laga ti yɛɛ na, mbe kari naayeri. Ye yaa ti yinrɛ ti kan ti yɛɛ na, mberi pɔ ŋgerege nuŋgba ni. Ti ni fuun ti yaa pye ki pyelɔmɔ nuŋgba pi na ma; ti yaa pye go yɛngɛlɛ shyɛn ke ni fuun ke na. ");
INSERT INTO dyi_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kiga pye ma, pa tire papara papara ti yaa pye kɔlɔtaanri, ti nɔgɔna cɛnyaara nda ti yaa gbegele warifuwe ni, ti yaa pye kɛ ma yiri kɔgɔlɔni. Ti shyɛnzhyɛn yaa pye tire papara papara ti ni fuun nuŋgba nuŋgba ti nɔgɔ, wa na cɛnsaga paraga go ki puŋgo kɛɛ yeri. ");
INSERT INTO dyi_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«Ye akasiya tire tɛ yeri pye tipaara. Kaŋgurugo yaa tɛgɛ mbe paraga go ki tire papara papara ti kanŋgɔlɔ nuŋgba yigi. ");
INSERT INTO dyi_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Kaŋgurugo yaa tɛgɛ mbe kanŋgɔlɔ sanŋga ki woro ti yigi, kaŋgurugo yaa tɛgɛ mbege puŋgo woro ti yigi, wa yɔnlɔ tosaga yeri. ");
INSERT INTO dyi_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Nandogomɔ tiyaparaga ki yaa taga wa tire papara papara ti nandogomɔ, mbe lɛ wa go ŋga na sa yiri wa go sanŋga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ye yaa tɛ wo tire papara papara to naa tipaara ti na mberi tɔn. Ye yaa tɛ ŋgereye gbɔn, pa tipaara ti yaa ka ye wa ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Mboro Moyisi, cɛnlɔmɔ mba pìla naga ma na wa yanwiga ki na, ma ti pege kan pe yala po ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Ye yaa paraga ka ti lɛn jese ŋgbaan ni, naa ŋganra jese, naa kondoro jese konaa jese yɛɛn kpanyi ni, ŋga ki yaa pɔ mbanla cɛnsaga paraga go ki kɔn shyɛn. Kapyɔ jɛnfɛnnɛ pege ti pe sherubɛnye yanlɛɛlɛ gbegele wa ki na. ");
INSERT INTO dyi_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ye yaa tɛ kandɔɔlɔ yaŋgala tɛgɛ mbege kan akasiya tige tiyagala tijɛrɛ na, kila yɔlɔ, ŋgele pè tɛ wo ke na ma ke tɔn. Ye tiyagala ke lele wa ke nɔgɔna cɛnyaara nda pè gbegele warifuwe ni ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ye yaa ki paraga ki pɔ wa tɛ kandɔɔlɔ yaŋgala ke nɔgɔ na. «Ye yaa Yɔn finliwɛsɛnrɛ kɛsu wi tɛgɛ wa paraga ki puŋgo na. Ki paraga ko ki yaa tɛgɛ mbe laga kpoyi konaa laga jɛŋgɛ kpoyi ti kɔn shyɛn ti yɛɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ko puŋgo na, kapere ti kasulugo pyesaga ŋga ki yɛn kɛsu wi yaritɔnŋgɔ, yege tɛgɛ ye yɔn finliwɛ sɛnrɛ kɛsu wi yɔn ki tɔn ki ni, wa laga jɛŋgɛ kpoyi ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Paraga ŋga kì pɔ mala cɛnsaga paraga go ki kɔn shyɛn, ye yaa tabali wi tɛgɛ wa ki yɛgɛ, wa yɔnlɔparawa kamɛŋgɛ kɛɛ yeri; ye fitanladaga wi tɛgɛ wa tabali wi yɛsinmɛ na, wa yɔnlɔparawa kalige kɛɛ yeri. ");
INSERT INTO dyi_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Mbele pe maa paara ti tiin nari sɔgɔ, pe yaa paraga ka yɛgɛ ti mbege sɔgɔ lɛn jese ŋgbaan ni, naa ŋganra jese naa kondoro jese konaa jese yɛɛn kpanyi ni mbaa yeyɔngɔ ki tɔnni ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ye akasiya tige tiyagala kaŋgurugo tɛ ye tɛ wo ke na ye ke tɔn. Ye tɛ kandɔɔlɔ yaŋgala tɛgɛ yege paraga ki kan wa tiyagala ke na, yeyɔngɔ ki na. Ye tuguyɛnrɛ yan ye tiyagala ke nɔgɔna cɛnyaara ti gbegele. ");
INSERT INTO dyi_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Ye akasiya tire tɛgɛ ye saraga wɔsaga gbegele. Ki kanŋgɔlɔyɔ tijɛrɛ yi yaa pye ja. Ki nuŋgba nuŋgba pyew ki yaa pye mɛtɛrɛ shyɛn naa kɔngɔ. Ki yagawa pi yaa pye mɛtɛrɛ nuŋgba naa kɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ye yaa yɛnŋgɛlɛ tijɛrɛ tɛ mbe ke yirige wa saraga wɔsaga ki yɛngɛlɛ tijɛrɛ ke na, ke pinlɛ ke pye nuŋgba ki ni. Ye yaa tuguyɛnrɛ yan mbe wo ki na mbege tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ye yaa saraga wɔsaga ki tunŋgo pyeyaara ti ni fuun ti gbegele tuguyɛnrɛ ni, to ti yɛn ki cɔnrɔ leyaara, naa ki cɔnrɔ koliyaara, naa ki tasaala, naa ki kara wɔwangala konaa ki naŋganra wɔyaara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ye yaa tuguyɛnrɛ tɛgɛ mbe mɛrɛ gbegele saraga wɔsaga ki kɛyɛn tijɛrɛ yi na. Ye ŋgereye tijɛrɛ gbegele tuguyɛnrɛ ni, yeyi lele mɛrɛ ti yɛngɛlɛ tijɛrɛ ke na. ");
INSERT INTO dyi_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Yege mɛrɛ ti kan saraga wɔsaga ki na, mbege lɛ wa nɔgɔna sa gbɔn wa ki nandogomɔ, mbege maga mbege fili. ");
INSERT INTO dyi_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ye yaa akasiya tige kanŋgagala shyɛn tɛ, mbe tuguyɛnrɛ wo ke na mbe ke tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ye ki kanŋgagala ke lele wa ŋgereye yi ni saraga wɔsaga ki kɛyɛn shyɛn yi na mbaa ki lee. ");
INSERT INTO dyi_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ye yaa tire papara papara tɛgɛ mbe saraga wɔsaga ki gbegele, ki nawa pi yaa pye waga. Yege gbegele ye yala cɛnlɔmɔ mba mìla naga Moyisi ma na wa yanwiga ki na pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Ye yaa na paraga go ki loŋgo ki jasa. Jasa wi yɔnlɔparawa kalige kɛɛ paara yeri ti lɛn jese ŋgbaan ni. Ki kɛɛ ki titɔnlɔwɔ pi yaa pye mɛtɛrɛ nafa shyɛn ma yiri kɛ. ");
INSERT INTO dyi_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ki tiyagala ke yaa pye nafa. Ye tiyagala ke nɔgɔna cɛnyaara ti nafa gbegele tuguyɛnrɛ ni, ye kandɔɔlɔ yaŋgala naa paara yanŋgakanŋgagala gbegele warifuwe ni, ye ke tɛgɛ ye paara ti kankan wa tiyagala ke na. ");
INSERT INTO dyi_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Na cɛnsaga paraga go ki yɔnlɔparawa kamɛŋgɛ kɛɛ, yege gbegele ki pyelɔmɔ nuŋgba pi na fun. Ki paara ti titɔnlɔwɔ pi yaa pye mɛtɛrɛ nafa shyɛn ma yiri kɛ; ki tiyagala ke yaa pye nafa, ke nɔgɔna cɛnyaara ti yaa pye nafa fun, yeri gbegele tuguyɛnrɛ ni. Ye kandɔɔlɔ yaŋgala naa paara yanŋgakanŋgagala gbegele warifuwe ni, ye ke tɛgɛ ye paara ti kankan wa tiyagala ke na. ");
INSERT INTO dyi_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Wa cɛnsaga paraga go ki yɔnlɔ tosaga yeri, loŋgo ki gbemɛ pi na, jasa paara ti titɔnlɔwɔ pi yaa pye mɛtɛrɛ nafa ma yiri kaŋgurugo. Wi tiyagala ke yaa pye kɛ, ke nɔgɔna cɛnyaara ti yaa pye kɛ fun. ");
INSERT INTO dyi_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Wa cɛnsaga paraga go ki yɔnlɔ yirisaga yeri, loŋgo ki gbemɛ pi yaa pye fun mɛtɛrɛ nafa ma yiri kaŋgurugo. ");
INSERT INTO dyi_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Loŋgo ki jasa yeyɔngɔ ki kɛyɛn shyɛn yi ni fuun nuŋgba nuŋgba yi na, paara ti titɔnlɔwɔ pi yaa pye mɛtɛrɛ kɔlɔshyɛn kɔlɔshyɛn naa kɔnrɔkɔnrɔ, naa tiyagala taanrindaanri konaa ke nɔgɔna cɛnyaara taanrindaanri. ");
INSERT INTO dyi_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Loŋgo ki yeyɔngɔ tɔnparaga ki yaa pye mɛtɛrɛ kɛ. Ye yaa ki ti mbege sɔgɔ lɛn jese ŋgbaan ni, naa ŋganra jese, naa kondoro jese konaa jese yɛɛn kpanyi ni. Yege pɔ tiyagala tijɛrɛ na, ye tiyagala ke taga nɔgɔna cɛnyaara tijɛrɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ye paara yanŋgakanŋgagala gbegele warifuwe ni, ye ke tɛgɛ ye loŋgo ki jasa tiyagala ke yigiyigi ke sɔgɔwɔ pi ni. Ye tiyagala ke nɔgɔna cɛnyaara ti gbegele tuguyɛnrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Loŋgo ki jasa wi titɔnlɔwɔ pi yaa pye mɛtɛrɛ nafa shyɛn ma yiri kɛ, wi gbemɛ pi yaa pye mɛtɛrɛ nafa ma yiri kaŋgurugo, wi paara nda ti yaa ti lɛn jese ŋgbaan ni ti yagawa pi yaa pye mɛtɛrɛ shyɛn naa kɔngɔ. Jasa tiyagala ke ni fuun ye ke nɔgɔna cɛnyaara ti gbegele tuguyɛnrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Yanla cɛnsaga paraga go ki tunŋgo pyeyaara ti ni fuun ti gbegele tuguyɛnrɛ ni, ki kankanŋgagala naa loŋgo ki jasa kankanŋgagala ke yaa gbegele tuguyɛnrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Mboro Moyisi, maga yo Izirayɛli woolo pe kan fɔ oliviye tige pire nda pè sun pe pan ti sinmɛ piiri ni, maa pi nii wa fitanladaga wi ni, jaŋgo fitanlaye paa yiin sanga pyew yembinɛ. ");
INSERT INTO dyi_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Arɔn naa wi pinambiile pe yaa fitanladaga wi gbegele mboo tɛgɛ wa filisaga paraga go ki ni, wa paraga ŋga pè pɔ maga kɔn shyɛn ki yɛgɛ, ko ŋga kì yɔn finliwɛ sɛnrɛ kɛsu wi yɛgɛ tɔn we; jaŋgo fitanlaye paa yiin mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ, mbege lɛ yɔnlɔkɔgɔ fɔ sa gbɔn lalaaga ki na. Ki yaa pye kondɛgɛlɛ na li yɛn kɔsaga fu, yoro Izirayɛli woolo ye kan, naa ye setirige piile mbele fuun pe yaa ka yiri puŋgo na pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«Mboro Moyisi, ma ndɔ Arɔn naa wi pinambiile Nadabu, naa Abiyu, naa Eleyazari konaa Itamari pe wɔ wa Izirayɛli woolo sanmbala pe sɔgɔwɔ, ma pe fulo ma yɛɛ tanla, jaŋgo paa saraga wɔgɔtunŋgo piin na kan. ");
INSERT INTO dyi_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ma yaripɔrɔ gbegele ma ndɔ Arɔn wi kan, nda ti yaa tɛgɛ ti yɛ Yɛnŋɛlɛ kan, tila wi gbɔgɔwɔ pi nari konaa mbe ti paa wi jate. ");
INSERT INTO dyi_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Maga yo kapyɔ jɛnfɛnnɛ pe ni fuun pe kan, poro mbele mì tijinliwɛ pi kan pe yeri, fɔ pe Arɔn yaripɔrɔ ti gbegele, mboo tɛgɛ wi yɛ, wila saraga wɔgɔtunŋgo ki piin na kan. ");
INSERT INTO dyi_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Yaripɔrɔ nda pe yaa gbegele ti nda: Yaripɔgɔ ŋga pe ma le ma wa kotogo na, naa efɔdi, naa derigbɔgɔ, naa deritɔnlɔgɔ ŋga pè sɔgɔ, naa gbɔgɔwɔ njala na pe yinri turiban konaa kurusijara ni. Pe yaa ki yaripɔrɔ nda tì tɛgɛ ti yɛ ti gbegele ma ndɔ Arɔn wo naa wi pinambiile pe kan, paa ti nii paa saraga wɔgɔtunŋgo ki piin na kan. ");
INSERT INTO dyi_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Pe yaa ti ti tɛ maŋgala ni, naa ŋganra jese, naa kondoro jese, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan ni. ");
INSERT INTO dyi_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Kapyɔ jɛnfɛnnɛ pe yaa efɔdi wi ti mboo sɔgɔ tɛ maŋgala ni, naa ŋganra jese, naa kondoro jese, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan ni. ");
INSERT INTO dyi_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ye pajogo maŋgala shyɛn yɔli efɔdi wi yinrɛ shyɛn ti na, jaŋgo ti pinlɛ ti pye nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kurusijara wo naa efɔdi wi ni ti gbegelelɔmɔ pi yaa pye nuŋgba. Ti yaa gbegele fun tɛ maŋgala ni, naa ŋganra jese, naa kondoro jese, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan ni. ");
INSERT INTO dyi_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ye ɔnikisi sinndɛɛrɛ sɔnŋgbanga woro shyɛn lɛ, ye Izirayɛli pinambiile pe mɛrɛ ti keregi keregi wa ti na. ");
INSERT INTO dyi_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ye mɛrɛ kɔgɔlɔni keregi keregi wa sinndɛlɛgɛ koŋgbanŋga ki na, ye mɛrɛ kɔgɔlɔni sannda ti keregi keregi wa sinndɛlɛgɛ shyɛn wogo ki na, mbe yala pe se ma tagala pe yɛɛ na yɛgɛ ŋga na ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ma ti pe Zhakɔbu pinambiile pe mɛrɛ ti keregi keregi wa ki sinndɛɛrɛ shyɛn ti na paa yɛgɛ ŋga na pe ma mɛgɛ tɛgɛrɛ tɛgɛyaraga ki keregi keregi sinndɛlɛgɛ na we. Sinndɛlɛgɛ keregi keregifɔ mbege tunŋgo ki pye; pege sinndɛɛrɛ ti maramara tɛ piile shyɛn nawa. ");
INSERT INTO dyi_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ye yaa ki sinndɛɛrɛ shyɛn ti mara efɔdi wi pajogo maŋgala shyɛn ke na. Ti yaa la nandowo kaan Izirayɛli woolo pe wogo ki na. Arɔn wi yaa pe mɛrɛ ti lɛ wa wi pajoro ti na, wa na cɛnsaga paraga go ki ni, mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ; pa kona mi se ka fɛgɛ ye na. ");
INSERT INTO dyi_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ma yaa ti pege sinndɛɛrɛ ti maramara tɛ piile nawa. ");
INSERT INTO dyi_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Ye tɛ piiri lɛ ye yɔngɔwɔ shyɛn gbegele, pi pye paa yɛgɛ ŋga na pe ma kaa mana pili we; sinndɛɛrɛ nda tì maramara wa tɛ piile pe nawa yoo le ti na. ");
INSERT INTO dyi_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Yaripɔgɔ ŋga pe ma le ma wa kotogo na mbaa kiti kɔnkagala ke yɛgɛ woo ki ni, ma ti kapyɔ jɛnfɛnnɛ pege gbegele gbegelelɔmɔ nuŋgba pi na. Ma yaa ti pege gbegele pege sɔgɔ tɛ maŋgala ni, naa ŋganra jese, naa kondoro jese, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan ni. ");
INSERT INTO dyi_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Yege kuru yege taga ki yɛɛ na, ki kɛyɛn tijɛrɛ yi pye yi yala. Ki kɛɛ nuŋgba nuŋgba pyew, ki titɔnlɔwɔ pi yaa pye siwiri nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ye sinndɛɛrɛ sɔnŋgbanga woro maramara wa ki ni, ti pye kologo tijɛrɛ. Ki kologo koŋgbanŋga ki yaa pye sariduwani sinndɛɛrɛ, naa topazi konaa emerodi. ");
INSERT INTO dyi_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ki kologo shyɛn wogo ki sinndɛɛrɛ ti yaa pye ɛsikaribukili, naa safiri konaa lulu. ");
INSERT INTO dyi_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ki kologo taanri wogo ki sinndɛɛrɛ ti yaa pye opali, naa agati konaa ametisiti. ");
INSERT INTO dyi_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ki kologo tijɛrɛ wogo ki sinndɛɛrɛ ti yaa pye kirizoliti, naa ɔnikisi konaa zhasipi. Ye ki sinndɛɛrɛ ti ni fuun ti maramara tɛ pyɔ nawa. ");
INSERT INTO dyi_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Sinndɛɛrɛ ti yaa pye kɛ ma yiri shyɛn mbe yala Izirayɛli pinambiile pe mɛrɛ ti ni. Cɛngɛlɛ kɛ ma yiri shyɛn ke ni, cɛnlɛ nuŋgba mɛgɛ daga mbe keregi keregi sinndɛlɛgɛ nuŋgba na, paa yɛgɛ ŋga na pe ma mɛgɛ tɛgɛrɛ tɛgɛyaraga ki keregi keregi we. ");
INSERT INTO dyi_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Ma ti pe yɔngɔwɔ shyɛn gbegele tɛ piiri ni, paa yɛgɛ ŋga na pe ma kaa mana pili, mboo le yaripɔgɔ ŋga pe ma le ma wa kotogo na ki na. ");
INSERT INTO dyi_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ma ti pe tɛ ŋgereye shyɛn gbegele fun, peyi to wa yaripɔgɔ ŋga pe ma le ma wa kotogo na ki yinrɛ shyɛn ti na. ");
INSERT INTO dyi_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Tɛ yɔngɔwɔ shyɛn poo nuŋgba pɔ ŋgerege nuŋgba na, poo sanmba pi pɔ ŋgerege sanŋga ki na, wa yaripɔgɔ ŋga pe ma le ma wa kotogo na ki yinrɛ shyɛn ti na. ");
INSERT INTO dyi_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Sinndɛɛrɛ shyɛn pèri maramara tɛ piile mbele ni, ma yaa ti pe yɔngɔwɔ shyɛn pi yinrɛ sannda ti pɔpɔ ki tɛ piile pe na, wa efɔdi wi pajogo maŋgala ke na, jaŋgo yaripɔgɔ ŋga pe ma le ma wa kotogo na ki pye wa yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ma yaa ti pe tɛ ŋgereye ya yɛgɛ gbegele shyɛn, peyi to yaripɔgɔ ŋga pe ma le ma wa kotogo na ki na, wa ki nɔgɔna yinrɛ shyɛn ti na, wa ki yɛgɛ ŋga ki yɛn ma mara efɔdi wi na ki na. ");
INSERT INTO dyi_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ma ti pe tɛ ŋgereye ya yɛgɛ gbegele shyɛn, peyi to wa efɔdi wi pajogo maŋgala shyɛn ke nɔgɔ, wa yɛgɛ kɛɛ ki na, ke yɔlikologo ki tanla, kurusijara ŋa wi yaa tɛgɛ mbe efɔdi wi pɔ ki go na. ");
INSERT INTO dyi_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Yaripɔgɔ ŋga pe ma le ma wa kotogo na, pe yaa ki ŋgereye yi pɔ efɔdi wi tɛ ŋgereye yi na ŋganra mana ni, jaŋgo yaripɔgɔ ŋga pe ma le ma wa kotogo na ki pye kurusijara ŋa wi yaa tɛgɛ mbe efɔdi wi pɔ wi go na, kiga ka sanga mbe laga wa efɔdi wi na. ");
INSERT INTO dyi_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Yaripɔgɔ ŋga pe ma le ma wa kotogo na mbaa kiti kɔnkagala ke yɛgɛ woo, ko ŋga Izirayɛli cɛngɛlɛ ke mɛrɛ ti yɛn ma keregi keregi ki na, na Arɔn wi kaa yiin sanga ŋa ni wa na cɛnsaga paraga go ki ni, wigi le wigi wa wa wi kotogo ki na. Pa kona, mi ŋa Yawe Yɛnŋɛlɛ, mi se fɛgɛ ye na. ");
INSERT INTO dyi_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Mboro Moyisi, yaara nda pe yinri Urimu naa Tumimu, mari le wa yaripɔgɔ ŋga pe ma le ma wa kotogo na mbaa kiti kɔnkagala ke yɛgɛ woo ki ni, jaŋgo na Arɔn wi kaa paan wa mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ sanga ŋa ni, ti pye wa wi kotogo ki na. Arɔn wi yaa lari nii lari waa wa wi kotogo ki na sanga pyew mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ, mbe ti wila na nandanwa kala li jɛnni, na wi kaa yoro Izirayɛli woolo ye kiti kɔnkagala ke yɛgɛ woo we. ");
INSERT INTO dyi_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Arɔn wi yaa efɔdi wi le mboo taga deritɔnlɔgɔ ŋga na, ma ti pege gbegele ŋganra jese ni. ");
INSERT INTO dyi_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ma ti pege yɔlɔgɔ ki wɔ wa ki nandogomɔ, pe mana ŋgbanla taga wa ki yɔn ki na, pege yɔn ki kaw, paa yɛgɛ ŋga na pe ma sɛlɛgɛ derege yɔlɔgɔ yɔn ti we. ");
INSERT INTO dyi_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ma ti pe girenadi tige pire yanlɛrɛ gbegele ŋganra jese, naa kondoro jese konaa jese yɛɛn kpanyi ni, peri toto derigbɔgɔ ki nɔgɔna yɔn ki na mbege maga mbege fili, naa tɛ keŋgeŋgele ni, pe ke toto ki tige pire yanlɛrɛ ti sɔgɔwɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Na paga girenadi tige pige yanlɛgɛ nuŋgba to, pe yaa tɛ keŋgenɛ la to, mbege pye ma mbe derigbɔgɔ ki nɔgɔna yɔn ki maga mbege fili. ");
INSERT INTO dyi_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Arɔn wi yaa kaa ki derigbɔgɔ ki nii mbaa saraga wɔgɔtunŋgo ki piin. Na wiga kaa paan wa na cɛnsaga paraga go ki ni na yɛgɛ sɔgɔwɔ, konaa na wiga kaa yinrigi, pe yaa la keŋgeŋgele ke tinmɛ taa, pa kona wi se ku. ");
INSERT INTO dyi_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Ma ti pe tɛ piiri gbɔn paparapa, maga yɔnlɔgɔ wa wi na fɔ: ‹MBE PYE KPOYI YAWE YƐNŊƐLƐ LI KAN›, paa yɛgɛ ŋga na pe ma mɛgɛ ki tɛgɛrɛ tɛgɛyaraga ki keregi keregi we. ");
INSERT INTO dyi_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ma yaa ki tɛ paparapa wi pɔ ŋganra mana ni wa gbɔgɔwɔ njala li na, wa ki yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ki tɛ paparapa wi yaa pye wa Arɔn wi walɛgɛ ki na. Kiga pye ma, yarikanra nda fuun Izirayɛli woolo pe yaa la teri ti yɛ, mbaa paan ti ni na kan kapere nda pe mbe ya mbaa piin ti wogo na, wi yaa ti go kala li lɛ. Ki tɛ paparapa wi yaa pye wa Arɔn wi walɛgɛ ki na sanga pyew, jaŋgo mi ŋa Yawe Yɛnŋɛlɛ, mbe yɛnlɛ ki yarikanra nda tì tɛgɛ ti yɛ ti na. ");
INSERT INTO dyi_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Ma ti pe deritɔnlɔgɔ gbegele Arɔn wi kan, naa njala ni konaa kurusijara ni, pege gbegele pege sɔgɔ lɛn jese ŋgbaan ni. ");
INSERT INTO dyi_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«Ma ti pe deritɔɔnrɔ gbegele Arɔn wi pinambiile pe kan, naa kurusijaraye ni, konaa gbɔgɔwɔ njagala ni; tila pe gbɔgɔwɔ pi nari konaa paa pe jate. ");
INSERT INTO dyi_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","«Maga yaripɔrɔ ti lele ma ndɔ Arɔn wo naa wi pinambiile pe kan. Ma sinmɛ kpoyi wo pe na, ma pe wɔ ma pe tɛgɛ pe tunŋgo ki na, ma pe pye kpoyi paa saraga wɔgɔtunŋgo ki piin na kan. ");
INSERT INTO dyi_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ma kurusiile weŋgele gbegele pe kan lɛn jese ni paa pe nii paa pe fɛrɛ ti tɔnni, mbege lɛ wa pe sɛnŋgɛlɛ ke na mbe tigi mbe pe jegbɔgɔlɔ ke tɔnndɔ. ");
INSERT INTO dyi_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Arɔn naa wi pinambiile pe ni, pe yaa la pe nii pe yɛɛ na, na pe kaa kee wa filisaga paraga go ki ni sanga ŋa ni we, nakoma na paga fulo wa saraga wɔsaga ki tanla mbe tunŋgo pye wa laga kpoyi ki ni. Ki ka pye ma, pe se jate pe kapege pye, ŋga ki yaa ti pe ku ki kala na. Ki yaa pye kondɛgɛlɛ na li yɛn kɔsaga fu Arɔn naa wi setirige piile pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Ŋga ma yaa pye mbe Arɔn naa wi pinambiile pe pye kpoyi mbe pe tɛgɛ pe yɛ, jaŋgo paa saraga wɔgɔtunŋgo piin na kan ki ŋga: «Ma yaa napɔlɔ yirifɔnŋɔ nuŋgba naa simbapɛnɛ shyɛn yigi, pe pye jɛrɛgisaga fu, ");
INSERT INTO dyi_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","mbe leve fu buru taga wa, naa leve fu gato ŋa pè gbɔn sinmɛ ni, naa leve fu wɔn ŋa pè wa yarilire nda pe yinri furoma ti muwɛ pa ni, ma sinmɛ yanragi yanragi wi na. ");
INSERT INTO dyi_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ma ti ni fuun ti le kanjapige nuŋgba ni, ma kari ti ni wa cɛnsaga paraga go ki ni, mbe pinlɛ napɔlɔ wo naa simbapɛnɛ shyɛn pe ni. ");
INSERT INTO dyi_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«Ma kari Arɔn naa wi pinambiile pe ni wa filisaga paraga go ki yɔn na wa nawa, ma ti pe woli tɔnmɔ ni. ");
INSERT INTO dyi_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ko puŋgo na, yaripɔrɔ nda tì tɛgɛ ti yɛ Yɛnŋɛlɛ kan, mari le Arɔn wi na, to ti yɛn derigbɔgɔ naa deritɔnlɔgɔ, naa efɔdi wo naa yaripɔgɔ ŋga pe ma le ma wa kotogo na ki ni; Kurusijara ŋa wi yaa tɛgɛ mbe efɔdi wi pɔ mɛɛ wi pɔ. ");
INSERT INTO dyi_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ma gbɔgɔwɔ njala li kan Arɔn wi kan. Yɔɔnrɔ ti yɛn tɛ paparapa ŋa na, maa pɔ wa gbɔgɔwɔ njala li na. ");
INSERT INTO dyi_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ma sinmɛ kpoyi pa lɛ maa wo wa Arɔn wi go ki na, mboo wɔ na kan. ");
INSERT INTO dyi_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ko puŋgo na, mɛɛ Arɔn wi pinambiile pe pye pe fulo wa ma tanla, mɛɛ pe deritɔɔnrɔ ti lele pe kan, ");
INSERT INTO dyi_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ma pe kurusijaraye pe pɔpɔ pe kan, ma pe njagala ke kankan pe kan. Saraga wɔgɔtunŋgo ki yaa pye pe wogo fɔ sanga pyew. «Pa ma yaa Arɔn wo naa wi pinambiile pe tɛgɛ saraga wɔgɔtunŋgo ki na yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«Ma kari napɔlɔ yirifɔnŋɔ wi ni wa filisaga paraga go ki yɛgɛ wa laga nawa, Arɔn naa wi pinambiile pe pe kɛyɛn yi tagataga wa wi go ki na. ");
INSERT INTO dyi_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Mɛɛ napɔlɔ yirifɔnŋɔ wi kɔnli na yɛgɛ sɔgɔwɔ, wa filisaga paraga go ki yɔn na wa nawa. ");
INSERT INTO dyi_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ma napɔlɔ yirifɔnŋɔ wi kasanwa pa lɛ ma yombɛlɛ li ni, maa fafa wa saraga wɔsaga ki yɛnŋgɛlɛ ke na, mɛɛ sanmba pi wo wa saraga wɔsaga ki nɔgɔna cɛnyaraga ki na maga maga, maga fili. ");
INSERT INTO dyi_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ko puŋgo na, ma yanlaga ŋga kì lara ti tɔn ki laga, naa yiripɔlɔ wi ni, naa jinŋgele shyɛn koro naa ke yanlaga ki ni. Ma ti ni fuun ti sogo wa saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ɛɛn fɔ, ma yaa napɔlɔ wi kara sannda, naa wi sɛlɛgɛ konaa wi lara ti sogo wa paara yinrɛ cɛnsaga ki puŋgo na. Ko yaa pye saraga mbe kapere kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«Ko puŋgo na, ma yaa simbapɛnɛ nuŋgba lɛ, Arɔn naa wi pinambiile pe yaa pe kɛyɛn yi tagataga wa wi go ki na. ");
INSERT INTO dyi_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ma yaa simbapɔlɔ wi kɔnli mboo kasanwa pi tɔgɔ, mboo yanragi yanragi saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ko puŋgo na, ma simbapɔlɔ wi kɔɔnlɔ, maa lara naa wi saanra ti jogo, mari taga wa wi kara nda mà kɔɔnlɔ to naa wi go ki na. ");
INSERT INTO dyi_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ma yaa simbapɔlɔ wi kara ti ni fuun ti sogo wa saraga wɔsaga ki na. Ki yaa pye saraga sogowogo ŋga yè wɔ mi ŋa Yawe Yɛnŋɛlɛ na yeri, saraga ŋga pe ma sogo, ki nuwɔ taan pi yɛn mala ndanla. ");
INSERT INTO dyi_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«Ma yaa simbapɔlɔ shyɛn woo wi lɛ, Arɔn naa wi pinambiile pe pe kɛyɛn yi tagataga wa wi go ki na. ");
INSERT INTO dyi_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Mɛɛ simbapɔlɔ wi kɔnli maa kasanwa pa lɛ maa fafa wa Arɔn naa wi pinambiile pe kalige nuŋgbogolo ke na, wa laga ŋga pe ma nuŋgbolo li furu, mbe pa fafa wa pe kalige kɛyɛn yombɛgbɔrɔ naa pe kalige tɔɔrɔ yombɛgbɔrɔ ti na. Ko puŋgo na, mɛɛ kasanwa sanmba pi yanragi yanragi wa saraga wɔsaga ki kanŋgara ti na. ");
INSERT INTO dyi_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kasanwa mba wa saraga wɔsaga ki na, ma pa lɛ, naa sinmɛ kpoyi pa ni, mari yanragi yanragi Arɔn naa wi yaripɔrɔ ti na konaa wi pinambiile naa pe yaripɔrɔ ti na. Ki ka pye ma, Arɔn wo naa wi pinambiile pe ni, pe yaa pye kpoyi, konaa pe yaripɔrɔ ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«Ma yaa simbapɔlɔ wi yanlaga ki lɛ, naa wi naga ki ni, naa wi yanlaga ŋga ki ma lara ti tɔn ki ni, naa yiripɔlɔ wi ni, naa wi jinŋgele koro naa ke yanlaga ki ni konaa wi kalige jegbɔlɔ li ni. Wo wi yɛn simbapɔlɔ ŋa pe ma wɔ saraga mbe lere tɛgɛ tunŋgo na. ");
INSERT INTO dyi_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Leve fu buru wi yɛn kanjapige ŋga ni, ko ŋga ki yɛn ma tɛgɛ wa na yɛgɛ sɔgɔwɔ, ma buru wa wɔ wa ki ni nuŋgba, naa gato ŋa pè wa sinmɛ ni nuŋgba ni konaa wɔn nuŋgba ni. ");
INSERT INTO dyi_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ma ki yaara ti ni fuun ti le Arɔn naa wi pinambiile pe kɛɛ, peri yirige peri kan saraga mi ŋa Yawe Yɛnŋɛlɛ na yeri. ");
INSERT INTO dyi_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ko puŋgo na, mari shɔ pe yeri, ma ti peri sogo wa saraga wɔsaga ki na, wa saraga sogowogo ki go na. Ki yaa pye saraga ŋga pe ma sogo, ki wirige nuwɔ taan pi yɛn ma mi ŋa Yawe Yɛnŋɛlɛ na ndanla. ");
INSERT INTO dyi_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ma simbapɔlɔ shyɛn woo ŋa wì wɔ saraga mbe Arɔn wi tɛgɛ tunŋgo ki na, wi ndige ki lɛ, maga yirige maga kan saraga mi ŋa Yawe Yɛnŋɛlɛ na yeri. Ko puŋgo na, ki ndige ki yaa pye ma tasaga. ");
INSERT INTO dyi_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«Simbapɔlɔ ŋa wi yaa pye saraga mbe Arɔn naa wi pinambiile pe tɛgɛ tunŋgo ki na, maa ndige naa wi jegbɔlɔ li ni ti lɛ, mari yirige mari kan saraga mi ŋa Yawe Yɛnŋɛlɛ na yeri. ");
INSERT INTO dyi_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ti yaa pye Arɔn naa wi pinambiile pe tasaga. Ki yɛn kondɛgɛlɛ na li yaa pye kɔsaga fu Izirayɛli woolo pe kan; katugu ki yɛn yarikanga, pe yaa la ki yarikanra ti lagala wa nayinmɛ saara ti na, mbaa ti kaan mi ŋa Yawe Yɛnŋɛlɛ na yeri. ");
INSERT INTO dyi_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Arɔn wi kuŋgɔlɔ, wi yaripɔrɔ nda tì tɛgɛ ti yɛ Yɛnŋɛlɛ kan, yeri kan wi pinambiile pe yeri, na paga sinmɛ kpoyi wo pe na mbe pe tɛgɛ tunŋgo ki na pilige ŋga ni we. ");
INSERT INTO dyi_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Arɔn wi pinambiile pe ni, ŋa wi yaa ka cɛn wa wi yɔnlɔ, mbe pye saraga wɔfɔ, mbaa yiin wa filisaga paraga go ki ni, mbaa tunŋgo piin wa laga kpoyi ki ni, wi yaa ki yaripɔrɔ ti le sa gbɔn piliye kɔlɔshyɛn. ");
INSERT INTO dyi_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Ko puŋgo na, simbapɔlɔ ŋa pe ma wɔ saraga ma lere tɛgɛ saraga wɔgɔtunŋgo ki na, yoo kara ti sɔgɔ laga kpoyi ka ni. ");
INSERT INTO dyi_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Arɔn naa wi pinambiile pe ni, pe yaa simbapɔlɔ wi kara ti ka konaa buru ŋa wa kanjapige ki ni wi ni, wa filisaga paraga go ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Poro cɛ pe yaa ki yarikanra ti ka, to nda pè tɛgɛ ma pe kapere ti kasulugo ki pye, ma pe pye kpoyi, naa pè pe tɛgɛ saraga wɔgɔtunŋgo ki na we. Lere wa yɛgɛ si daga mbe ta ka, katugu ti yɛn kpoyi. ");
INSERT INTO dyi_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ki yaayogo ŋga pè gbo ma lere wi tɛgɛ tunŋgo ki na, na ki kara ta ka wɔnlɔ mbe yiri, naa buru wa ni, yeri sogo. Lere si daga mbe ta ka, katugu ti yɛn yaara nda ti yɛn kpoyi. ");
INSERT INTO dyi_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«Kapyege ŋga ki yaa pye Arɔn naa wi pinambiile pe kan mbe pe tɛgɛ tunŋgo ki na, maga pye ma cɛ piliye kɔlɔshyɛn ni, paa yɛgɛ ŋga na mìla ki yo ma kan we. ");
INSERT INTO dyi_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Pilige nuŋgba nuŋgba pyew, ma yaa napɔlɔ nuŋgba wɔ saraga mbe kapere ti kala yagawa ja. Ki saraga ŋga ma yaa wɔ mbe kapere ti kala yagawa ja, ko ma yaa tɛgɛ mbe saraga wɔsaga ki pye kpoyi. Ko puŋgo na, ma yaa sinmɛ kpoyi wo ki na mbege le mi ŋa Yɛnŋɛlɛ na kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ma yaa kapere ti kala yagawa ja kapyege ki pye saraga wɔsaga ki na sa gbɔn piliye kɔlɔshyɛn, mbege le na kɛɛ. Ko puŋgo na, ki yaa pye jɛŋgɛ kpoyi, yaraga o yaraga ka jiri ki na, ki yaa pye kpoyi fun. ");
INSERT INTO dyi_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Saraga ŋga ma yaa la woo wa saraga wɔsaga ki na pilige pyew ki ŋga: Simbapɛnɛ yirifɔnmbɔlɔ shyɛn, mbele pè ta yɛlɛ nuŋgba nuŋgba. Ki saraga ki daga mbaa woo suyi. ");
INSERT INTO dyi_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ma yaa nuŋgba wɔ saraga pinliwɛ ni, mbe sanŋa wi wɔ saraga yɔnlɔkɔgɔ yɛgɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ma yaa muwɛ saraga culo taanri taga simbapɔlɔ yirifɔnŋɔ ŋa wi yaa wɔ pinliwɛ ni wi na, mba pè oliviye tige pire sinmɛ piiri litiri nuŋgba naa kɔngɔ pinlɛ pi ni, mberi wɔ saraga. Duvɛn saraga ŋga pe ma wo, ma yaa wi litiri nuŋgba naa kɔngɔ taga simbapɔlɔ yirifɔnŋɔ koŋgbanŋa wi na. ");
INSERT INTO dyi_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ma yaa simbapɔlɔ yirifɔnŋɔ shyɛn woo wi wɔ saraga yɔnlɔkɔgɔ yɛgɛ ni. Yarikanra nda tì taga pinliwɛ woo wi na, to nda ti yɛn muwɛ, naa sinmɛ konaa duvɛn, mari cɛnlɛ nuŋgba ti taga yɔnlɔkɔgɔ woo wi na. Ki yɛn saraga ŋga pe ma sogo, ki nuwɔ taan pi yɛn ma mi ŋa Yawe Yɛnŋɛlɛ na ndanla. ");
INSERT INTO dyi_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ki yɛn saraga sogowogo ŋga ye setirige piile mbele fuun pe yaa ka yiri puŋgo na, pe yaa la woo suyi wa filisaga paraga go ki yɔn na, mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ. Pa mi yaa la finli wa ye ni, mbaa para ma ni. ");
INSERT INTO dyi_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","«Ko laga koyi mi yaa kaa finli wa Izirayɛli woolo pe ni. Na gbɔgɔwɔ pi yaa ka ki laga ki pye kpoyi. ");
INSERT INTO dyi_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Mi yaa filisaga paraga go konaa saraga wɔsaga ti tɛgɛ ti yɛ na yɛɛ kan. Mi yaa Arɔn naa wi pinambiile pe pye kpoyi, paa saraga wɔgɔtunŋgo piin na kan. ");
INSERT INTO dyi_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mi yaa cɛn laga yoro Izirayɛli woolo ye sɔgɔwɔ, mbe pye ye Yɛnŋɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Kona ye yaa ki jɛn mbe yo muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le; mì ye yirige ma ye wɔ wa Ezhipiti tara, jaŋgo mbe cɛn laga ye sɔgɔwɔ. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Ma ti pe saraga wɔsaga ka gbegele akasiya tige ni, mbaa wusuna nuwɔ taan wi sori wa ki na. ");
INSERT INTO dyi_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Saraga wɔsaga ki kanŋgɔlɔyɔ tijɛrɛ yi yaa pye ja. Ki kanŋgɔlɔ nuŋgba pyew, ki yaa pye mɛtɛrɛ kɔngɔ, ki yagawa pi yaa pye mɛtɛrɛ nuŋgba. Ma ti pe yɛnŋgɛlɛ tɛ pe ke yirige wa ki yɛngɛlɛ tijɛrɛ ke na, ke pinlɛ ke pye ki ni nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ma ti pe tɛ piiri wo ki lagapyew ki na, ki gona wo naa ki kanŋgara, naa ki yɛnŋgɛlɛ ke na. Ma ti pe tɛ wa wo ki yɔn koŋgo ki na kɛɛrɛ mbege maga mbege fili. ");
INSERT INTO dyi_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ma ti pe tɛ ŋgereye shyɛnzhyɛn gbegele, peyi kankan saraga wɔsaga ki kɛyɛn shyɛn yan yì yɛgɛ wa yi yɛɛ yeri yi na, wa ki yɔn kɛɛrɛ ki nɔgɔ, jaŋgo paa ki lɛkanŋgagala ke nii wa yi ni, mbaa ki lee. ");
INSERT INTO dyi_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ma ti pe ki kanŋgagala ke gbegele akasiya tige ni, pe tɛ wo ke na pe ke tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ma ti pege saraga wɔsaga ki tɛgɛ wa paraga ŋga pè pɔ ma Yɛnŋɛlɛ cɛnsaga paraga go ki kɔn shyɛn ki yɛgɛ, ko ŋga yɔn finliwɛ sɛnrɛ kɛsu wi yɛn wa ki puŋgo na we, wa kapere ti kasulugo pyesaga ŋga ki yɛn wi yaritɔnŋgɔ ki yɛgɛ. Pa mi yaa kaa finli wa ma ni. ");
INSERT INTO dyi_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Arɔn wi yaa ti paa wusuna nuwɔ taan wi sori wa ki na pinliwɛ pyew, na wi kaa fitanlaye pe gbɛgɛlɛ sanga ŋa ni wa laga kpoyi ki ni we. ");
INSERT INTO dyi_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Yɔnlɔkɔgɔ pyew, wi yaa ti pe wusuna nuwɔ taan wa sogo wa ki na, na wi kaa jaa mbe fitanlaye pe mu sanga ŋa ni we. Ye yaa la wusuna nuwɔ taan wi sori suyi mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ, yoro naa ye setirige piile mbele fuun pe yaa ka yiri puŋgo na pe ni. ");
INSERT INTO dyi_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Yaga ka wusuna nuwɔ taan wa yɛgɛ sogo wa ki na, na ŋa cɛnlɛ mì naga wo wa ma. Yaga ka saraga sogowogo, naa muwɛ saraga konaa duvɛn saraga ŋga pe ma wo to ta wɔ wa ki na saraga. ");
INSERT INTO dyi_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Yɛlɛ pyew, Arɔn wi yaa kapere ti kala yagawa ja kapyege ki pye saraga wɔsaga ki yɛnŋgɛlɛ ke na pyesaga nuŋgba. Yaayogo ŋga pè gbo mbe kapere ti kala yagawa ja, wi yaa ki kasanwa pa fafa ke na. Ye setirige piile mbele fuun pe yaa yiri puŋgo na, paa ki kapyege ŋga ki piin yɛlɛ pyew pyesaga nuŋgba. Ki saraga wɔsaga ki yaa pye jɛŋgɛ kpoyi mi ŋa Yawe Yɛnŋɛlɛ na kan.» ");
INSERT INTO dyi_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Kona, a Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Na ma kaa Izirayɛli woolo sanmbala pe jinri sanga ŋa ni, pe ni fuun nuŋgba nuŋgba pe yaa penjara ta sara mi ŋa Yawe Yɛnŋɛlɛ na yeri mbe pe yɛɛ go shɔ; jaŋgo ki jirige ki ka ka ti jɔlɔgɔ mbe to ye na. ");
INSERT INTO dyi_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Lere ŋa fuun pe yaa ka jiri, wi yaa warifuwe pyɔ nuŋgba sara, ŋa wi nuguwɔ pi yaa pye giramu kaŋgurugo, mbe yala laga kpoyi ki warifuwe pyɔ walaga ki nuguwɔ pi ni. Ki warifuwe pyɔ wi yaa wɔ yarikanga mi ŋa Yawe Yɛnŋɛlɛ na yeri. ");
INSERT INTO dyi_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Lere o lere pe yaa ka jiri ki jirige ki na, mbege lɛ mbele pè ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni, pe yaa yarikanga ki kan mi ŋa Yawe Yɛnŋɛlɛ na yeri. ");
INSERT INTO dyi_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Penjara fɔ wii daga mbe kan mbe wɛ ki warifuwe pyɔ walaga ki na; fyɔnwɔ fɔ wii daga mbe kan mbe tigi ki warifuwe pyɔ walaga ki na. Lere nuŋgba nuŋgba pyew wi yaa ki penjara ti wɔ mberi kan mi ŋa Yawe Yɛnŋɛlɛ na yeri yarikanga, mbe ta mboo yɛɛ go shɔ. ");
INSERT INTO dyi_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ma yaa ki go shɔgɔ penjara ti shɔ Izirayɛli woolo pe yeri mberi tɛgɛ mbaa filisaga paraga go ki tunŋgo ki piin ti ni. Ti yaa ti mi ŋa Yawe Yɛnŋɛlɛ mbaa jatere piin ki na fɔ yè ye go shɔgɔ penjara ti kan.» ");
INSERT INTO dyi_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ko puŋgo na, a Yawe Yɛnŋɛlɛ lì si para naa Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Ma ti pe jogoyaraga gbegele tuguyɛnrɛ ni, naa ki nɔgɔna cɛnyaraga ni. Maga tɛgɛ filisaga paraga go konaa saraga wɔsaga ti sɔgɔwɔ pi ni, ma tɔnmɔ le wa ki ni maga yin saraga wɔfɛnnɛ pe yɛɛ jogowo pi mɛgɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Arɔn naa wi pinambiile pe yaa ki tɔnmɔ pi tɛgɛ mbaa pe kɛyɛn naa pe tɔɔrɔ ti jori pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Na pe kaa yiin wa filisaga paraga go sanga ŋa ni, pe yaa pe kɛyɛn naa pe tɔɔrɔ ti jogo wa ki tɔnmɔ pi ni gbɛn; konaa na pe kaa jaa mbe fulo wa saraga wɔsaga ki tanla mbe tunŋgo pye wa ki na, mbe saara nda pe ma sogo ta wɔ mi ŋa Yawe Yɛnŋɛlɛ na yeri we, jaŋgo paga ka ku. ");
INSERT INTO dyi_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Pe yaa la pe kɛyɛn naa pe tɔɔrɔ ti jori jaŋgo paga ka ku. Ko yɛn kondɛgɛlɛ na li yɛn kɔsaga fu ma Arɔn naa wi setirige piile mbele pe yaa ka yiri puŋgo na pe kan.» ");
INSERT INTO dyi_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Kona, a Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Nuwɔ taanyaara nda fuun ti yɛn jɛndɛ ma wɛ ti ni fuun na, ma ta lɛ: Nda pe yinri miiri ti tɔnmɔ culo kɔgɔlɔni, naa sinamɔmu timuwɛ nuwɔ taan culo taanri, naa kanɛli timuwɛ nuwɔ taan culo taanri, ");
INSERT INTO dyi_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","naa kasi timuwɛ nuwɔ taan culo kɔgɔlɔni, mbe yala laga kpoyi ki taanlayaraga ki nuguwɔ pi ni, konaa oliviye tige pire sinmɛ litiri kɔgɔlɔni ni. ");
INSERT INTO dyi_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ma ti nuwɔ taanyaara gbegelefɔ wa mberi pinlɛ ti yɛɛ ni, wiri gbegele sinmɛ nuwɔ taan. Pi yaa pye sinmɛ kpoyi, pe kaa jaa mbe yaraga ka le na kɛɛ, pe yaa pa wo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ko sinmɛ po pawi ma yaa wo filisaga paraga go ki na, naa yɔn finliwɛ sɛnrɛ kɛsu wi na, mberi le na kɛɛ; ");
INSERT INTO dyi_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","naa tabali wo naa wi tunŋgo pyeyaara ti na; naa fitanladaga wo naa wi tunŋgo pyeyaara ti na; naa wusuna nuwɔ taan wi ma sogo saraga wɔsaga ŋga na ki na; ");
INSERT INTO dyi_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","naa saara sogoworo ti ma sogo saraga wɔsaga ŋga na konaa ki tunŋgo pyeyaara ti na; naa jogoyaraga konaa ki tatɛgɛ ki na, mberi le na kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ma yaa ki yaara ti tɛgɛ ti yɛ na kan, pa ti yaa pye jɛndɛ kpoyi. Yaraga ŋga fuun ka jiri ka na, ki yaa pye kpoyi fun. ");
INSERT INTO dyi_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ma yaa ki sinmɛ pa wo Arɔn naa wi pinambiile pe na mbe pe pye kpoyi jaŋgo paa saraga wɔgɔtunŋgo piin na kan. ");
INSERT INTO dyi_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","«Ko puŋgo na, maga yo Izirayɛli woolo pe kan fɔ: ‹Ki sinmɛ mba pi yɛn sinmɛ kpoyi, ma tɛgɛ pi yɛ mi ŋa Yɛnŋɛlɛ na kan ye setirige piile mbele fuun pe yaa ka yiri puŋgo na pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Lere si daga mbe pa fa wi yɛɛ na; lere si daga mbege sinmɛ cɛnlɛ pa gbegele ki gbegelelɔmɔ nuŋgba pi na. Pi yɛn kpoyi, yaa pi jate kpoyi fun. ");
INSERT INTO dyi_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Na lere wa ka sinmɛ pa gbegele pi yiri ki woo mba pi kɔrɔgɔ, mboo fa lere wa yɛgɛ na, ŋa wi woro saraga wɔfɔ, ki daga pege fɔ wi wɔ wa wi woolo pe sɔgɔwɔ.› » ");
INSERT INTO dyi_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Nuwɔ taanyaara ta lɛ naa: Nda pe yinri sitakite, naa ɔnikisi konaa galibanumu. Ma wusuna nuwɔ taan piiri taga wa ti na; ti ni fuun nuŋgba nuŋgba ti lɛgɛ ti yalayala. ");
INSERT INTO dyi_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ma ti nuwɔ taanyaara gbegelefɔ wa mberi pinlɛ ti yɛɛ ni, wi wusuna nuwɔ taan piiri gbegele, ŋa wi yaa pye kpoyi. Wi yaa wi gbegele kɔ ni. ");
INSERT INTO dyi_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ma ti pe wa sun poo pye muwɛ, ma saa tɛgɛ wa filisaga paraga go ki ni, wa yɔn finliwɛ sɛnrɛ kɛsu wi yɛgɛ sɔgɔwɔ, wa laga ŋga mi yaa la finli ma ni we. Ye yaa laa jate pi yɛn jɛmbɛ kpoyi. ");
INSERT INTO dyi_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Yaga ka ki wusuna nuwɔ taan cɛnlɛ wa gbegele ki gbegelelɔmɔ nuŋgba pi na ye yɛɛ kan. Yaa wi jate paa yaraga kpoyi yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Na lere wa ka wi cɛnlɛ wa gbegele, mbaa wi gbɔɔn la yɔgɔri wi nuwɔ taan pi kala na, wi daga poo wɔ wa wi woolo pe sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si para naa Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Wele, mì Uri pinambyɔ Bezaleyɛli wi wɔ ma yiri wa Zhuda cɛnlɛ li ni. Uri to wo lawi ŋa Huri. ");
INSERT INTO dyi_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Mìlan yinnɛ li le wi ni, a lùu kan kajɛnmɛ, naa tijinliwɛ ni konaa kapyɔ tunndo ti yɛgɛ jɛnwɛ pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Wi mbe ya mbaa kapyɔ tunndo fɔnndɔ jatere taa, mbaa ti gbegele tɛ ni, naa warifuwe konaa tuguyɛnrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Wi mbe ya mbaa sinndɛɛrɛ sɔnŋgbanga woro ti tɛni mbaa ti sogolo ti yɛɛ ni, konaa mbaa tire tɛni. Ko kɔrɔ wo yɛn fɔ wi mbe ya mbe tunndo cɛnlɛ pyew ti pye. ");
INSERT INTO dyi_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Mì Ahisamaki pinambyɔ Oholiyabu wi kan wi yeri wila wi sari, ma yiri wa Dan cɛnlɛ li ni. Mì tijinliwɛ gbɔɔ kan kapyɔ jɛnfɛnnɛ pele yeri fun, jaŋgo pe ŋga fuun mì yo ma kan ki gbegele. ");
INSERT INTO dyi_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Pe filisaga paraga go ki gbegele, naa yɔn finliwɛ sɛnrɛ kɛsu wi ni, naa wi yaritɔnŋgɔ ŋga ki yɛn kapere ti kasulugo pyesaga ki ni, naa filisaga paraga go ki tunŋgo pyeyaara ti ni fuun ti ni; ");
INSERT INTO dyi_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","naa tabali wo naa wi tunŋgo pyeyaara ti ni, naa fitanladaga wi ni, poo gbegele tɛ piiri ni konaa wi tunŋgo pyeyaara ti ni fuun ti ni, naa wusuna nuwɔ taan wi ma sogo saraga wɔsaga ŋga na ki ni; ");
INSERT INTO dyi_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","naa saara sogoworo ti ma sogo saraga wɔsaga ŋga na ki ni, naa ki tunŋgo pyeyaara ti ni fuun ti ni, naa jogoyaraga konaa ki tatɛgɛ ki ni; ");
INSERT INTO dyi_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","naa yaripɔrɔ nda pe yaa la nii mbaa tunŋgo piin ti ni, naa saraga wɔfɔArɔn wi yaripɔrɔ nda ti yaa tɛgɛ ti yɛ Yɛnŋɛlɛ kan ti ni, naa wi pinambiile pe yaripɔrɔ nda pe yaa la nii mbaa saraga wɔgɔtunŋgo ki piin ti ni; ");
INSERT INTO dyi_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","naa sinmɛ kpoyi konaa wusuna nuwɔ taan ŋa wi yaa tɛgɛ wa cɛnsaga paraga go ki ni wi ni. Kapyɔ jɛnfɛnnɛ pe yaa ki tunndo ti ni fuun ti pye, mbe yala sɛnrɛ nda fuun mì yo ti ni.» ");
INSERT INTO dyi_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Kona, a Yawe Yɛnŋɛlɛ lì si para naa Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Ki yo Izirayɛli woolo pe kan fɔ paa cɛnpilige ki cɛɛn, katugu ki yɛn paa kacɛn yɛn mi naa yoro sɔgɔwɔ, naa ye setirige piile mbele pe yaa ka yiri puŋgo na pe sɔgɔwɔ. Ki yɛn naga nari fɔ muwi mi yɛn Yawe Yɛnŋɛlɛ na lì ye pye kpoyi. ");
INSERT INTO dyi_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ki kala na, yaa cɛnpilige ki cɛɛn, katugu ki yɛn ma tɛgɛ ki yɛ ye kan. Lere ŋa fuun kaga jɔgɔ wi daga poo gbo. Lere ŋa fuun ka tunŋgo ka pye ki pilige ki ni, poo purɔ poo wɔ wa wi woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ye yaa la tunŋgo piin piliye kɔgɔlɔni ni yapelege ki ni, pilige kɔlɔshyɛn wogo ko ki yɛn cɛnpilige ye, ma pye wogopilige ŋga kì tɛgɛ ki yɛ mi ŋa Yawe Yɛnŋɛlɛ na kan. Lere ŋa fuun ka tunŋgo pye cɛnpilige ki ni, wi daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Yoro Izirayɛli woolo yaa cɛnpilige ki cɛɛn suyi, yoro naa ye setirige piile mbele fuun pe yaa ka yiri puŋgo na pe ni; katugu ki yɛn yɔn finliwɛ mba pi yɛn kɔsaga fu. ");
INSERT INTO dyi_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ki pilige ki yaa pye kacɛn ŋa wi yɛn kɔsaga fu mi naa yoro Izirayɛli woolo ye sɔgɔwɔ; katugu mi ŋa Yawe Yɛnŋɛlɛ mì naayeri wo naa tara ti gbegele piliye kɔgɔlɔni ni, ki pilige kɔlɔshyɛn wogo ki na, a mì si wogo.» ");
INSERT INTO dyi_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Naa Yɛnŋɛlɛ làa kaa para Moyisi wi ni ma saa kɔ, wa Sinayi yanwiga ki na, a lì si sinndɛɛrɛ papara papara shyɛn nda lo jate làa yɔn finliwɛ sɛnrɛ ti yɔnlɔgɔ ti na ti kan wi yeri. ");
INSERT INTO dyi_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Naa Izirayɛli woolo pàa kaa ki yan Moyisi wila mɔni wa yanwiga ki na wi woro mbe tigi, a pè si saa gbogolo wa Arɔn wi tanla, ma suu pye fɔ: «Yiri ma yarisunŋgo ka gbegele we kan kila we yɛgɛ sinni. Katugu ki Moyisi ŋa wi yɛn naŋa ŋa wì we yirige ma we wɔ wa Ezhipiti tara ti ni, yaraga ŋga kùu ta, we sigi jɛn.» ");
INSERT INTO dyi_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","A Arɔn wì si pe yɔn sogo ma yo fɔ: «Tɛ nuŋgbogolo ŋgele ke yɛn ye jɛɛlɛ, naa ye pinambiile konaa ye sumborombiile pe na, ye ke wɔwɔ ye pan ke ni na kan.» ");
INSERT INTO dyi_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Le ki yɔngɔlɔ nuŋgba ke ni, a Izirayɛli woolo pe ni fuun pè si tɛ nuŋgbogolo ŋgele pàa lele ke wɔwɔ ma ke kan Arɔn wi yeri. ");
INSERT INTO dyi_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","A wì sigi tɛ yaara ti shɔ pe yeri, mari yan mari le yaraga ka ni, ma napige yanlɛgɛ gbegele wi ni. Kona, a Izirayɛli woolo pè si jɔrɔgɔ ma yo fɔ: «Woro Izirayɛli woolo, we yɛnŋɛlɛ li na, lo lì we yirige wa Ezhipiti tara.» ");
INSERT INTO dyi_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Naa Arɔn wìla kaa ki yan leele pè jɔrɔgɔ ma, a wì si saraga wɔsaga kan wa napige yanlɛgɛ ki yɛgɛ sɔgɔwɔ, mɛɛ ki yo ŋgbanga pe kan fɔ: «Goto we yaa fɛti pye Yawe Yɛnŋɛlɛ li mɛgɛ ni.» ");
INSERT INTO dyi_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ki goto yirifaga ki na, a leele pè si yiri ma saara sogoworo naa nayinmɛ saara wɔ. Kona, a pè si cɛn ma li ma wɔ. Ko puŋgo na, pè si yiri na jinrigi. ");
INSERT INTO dyi_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Tigi maa kee, katugu ma woolo mbele mà yirige wa Ezhipiti tara, pè kapege pye. ");
INSERT INTO dyi_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Pè kɛ fyaw ma konɔ na mìla naga pe na li wa. Pè tɛ yan ma napige yanlɛgɛ gbegele pe yɛɛ kan, ma fɔli ki yɛgɛ sɔgɔwɔ maga gbɔgɔ konaa ma saara wɔ ki yeri. Pè yɛrɛ yo fɔ: ‹Ye wele, woro Izirayɛli woolo, we yɛnŋɛlɛ li na, lo lì we yirige wa Ezhipiti tara.› » ");
INSERT INTO dyi_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Mìgi wele maga yan fɔ ki leele mbele pe yɛn leele mbele pè yiri ma je. ");
INSERT INTO dyi_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Koni, na yaga mbe nawa ŋgban pe ni. Mi yaa pe tɔngɔ mbe pe kɔ. Ɛɛn fɔ, mi yaa ti cɛnlɛ gbenɛ mbe yiri wa ma ni.» ");
INSERT INTO dyi_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","A Moyisi wì si Yawe Yɛnŋɛlɛ, wi Yɛnŋɛlɛ li yɛnri ma yo fɔ: «Yawe Yɛnŋɛlɛ, yiŋgi na mɛɛ nawa ŋgban ma woolo pe ni? Poro mbele mà pe yirige wa Ezhipiti tara ma yawa gbɔɔ po naa ma fanŋga gbɔgɔ ki ni we. ");
INSERT INTO dyi_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Na maga ki pye ma, pa Ezhipiti tara fɛnnɛ pe yaa yo fɔ mɔ̀ɔ woolo pe yirige wa Ezhipiti tara mbe pan mbe pe jɔlɔ, mbe pe gbo laga yanwira wasege ki ni, mbe pe cɛnlɛ li kɔ mbeli wɔ laga tara ti na pew. Ma naŋgbanwa gbɔɔ pi yaga. Jɔlɔgɔ ŋga maa jaa mbe wa ma woolo pe na, mɔɔ jatere wi kanŋga ki wogo ki na, maga yaga. ");
INSERT INTO dyi_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ma jatere pye ma tunmbyeele Abirahamu, naa Izaki konaa Izirayɛli pe na, poro mbele màa wugu ma yɛɛ mɛgɛ ki na pe kan ma yo fɔ: ‹Mi yaa ye setirige piile pe pye pe lɛgɛ paa naayeri wɔnŋgɔlɔ ke yɛn. Tara nda mìri sɛnrɛ yo, mi yaa ti kan pe yeri ti pye pe woro fɔ sanga pyew.› » ");
INSERT INTO dyi_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Kona, a Yawe Yɛnŋɛlɛ lì sili jatere wi kanŋga ma jɔlɔgɔ ŋga làa yo li yaa wa li woolo pe na ki yaga. ");
INSERT INTO dyi_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","A Moyisi wì si sɔngɔrɔ ma yiri wa yanwiga ki na ma tigi. Yɔn finliwɛ sɛnrɛ tìla pye ma yɔnlɔgɔ sinndɛɛrɛ papara papara shyɛn nda na tìla pye wi kɛɛ. Pàa yɔnlɔgɔ ti shyɛn ti kɛyɛn shyɛn yi ni fuun yi na. ");
INSERT INTO dyi_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ki sinndɛɛrɛ papara papara Yɛnŋɛlɛ lo làa ti gbegele. Yɔɔnrɔ nda tìla pye wa ti na, Yɛnŋɛlɛ lo làa ti yɔnlɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Naa Zhozuwe wìla kaa leele pe jɔrɔgɔmɔ pi logo, a wì si Moyisi wi pye fɔ: «Pyeri ma logo, malaga tinmɛ yɛn na yinrigi wa paara yinrɛ cɛnsaga ki ni.» ");
INSERT INTO dyi_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","A Moyisi wì suu yɔn sogo ma yo fɔ: «Ayoo, cew tafɛnnɛ ma paa jɔrɔgi, pè malaga gbɔn ma ya mbele ni poro pele si ma paa jɔrɔgi. Ɛɛn fɔ, yuuro tinmɛ mila nuru.» ");
INSERT INTO dyi_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Naa paa kaa na yɔngɔ paara yinrɛ cɛnsaga ki ni, a Moyisi wì si napige yanlɛgɛ ki yan konaa leele pe ni paa yoo. A wì si nawa ŋgban fɔ jɛŋgɛ, mɛɛ sinndɛɛrɛ papara papara nda tìla pye wi kɛɛ ti wa tara mari yaari le yanwiga ki nɔgɔ; ");
INSERT INTO dyi_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","mɛɛ ki napige yanlɛgɛ ŋga leele pàa gbegele ki lɛ, maga wa wa kasɔn maga sogo a kì pye muwɛ. A wì sigi muwɛ pi lɛ maa yanragi wa tɔnmɔ pi ni, maa kan Izirayɛli woolo pe yeri, a pòo wɔ. ");
INSERT INTO dyi_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ko puŋgo na, a Moyisi wì si Arɔn wi yewe ma yo fɔ: «Yiŋgi ki leele mbele pè pye ma na, a mà si ti a paa ki kapege gbɔgɔ ŋga ki piin?» ");
INSERT INTO dyi_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","A Arɔn wì si Moyisi wi yɔn sogo ma yo fɔ: «Na tafɔ, maga ka nawa ŋgban. Mboro jate màga jɛn ma yo kapege pyewe pi yɛn ma ki leele mbele pe ndanla. ");
INSERT INTO dyi_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Pànla pye ma yo fɔ: ‹Yarisunŋgo ka gbegele we kan kila we yɛgɛ sinni; katugu ki Moyisi ŋa wi yɛn naŋa ŋa wì we yirige ma we wɔ wa Ezhipiti tara ti ni, yaraga ŋga kùu ta, we sigi jɛn.› ");
INSERT INTO dyi_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","A mì si pe pye fɔ: ‹Tɛ yɛn lere ŋa fuun yeri, wuu wɔ na kan. A pè suu wɔwɔ ma pan maa kan na yeri. A mì suu le kasɔn, maa yan, mɛɛ ki napige yanlɛgɛ ŋga ki gbegele.› » ");
INSERT INTO dyi_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","A Moyisi wì sigi yan fɔ leele pè koro pe yɛɛ na, fɔ Arɔn wìla pe yaga a paa tanri pe yɛɛ nandanwa kala lo na, ma ti a pè tifaga pe juguye pe yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","A Moyisi wì si saa yere wa paara yinrɛ cɛnsaga yeyɔngɔ ki na, ma sho fɔ: «Lere o lere wi yɛn Yawe Yɛnŋɛlɛ li kɔrɔgɔ, wo mbe pan laga na tanla.» A Levi setirige piile pe ni fuun pè si saa gbogolo wa wi tanla maa maga. ");
INSERT INTO dyi_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","A wì si pe pye fɔ: «Yawe Yɛnŋɛlɛ, woro Izirayɛli woolo Yɛnŋɛlɛ le, ŋga lì yo ki ŋga: ‹Naŋa nuŋgba nuŋgba pyew, wuu tokobi wi lɛ, wi ye wa paara yinrɛ cɛnsaga ki ni, wigi yanriyanri, mbe yiri paraga go ka ni mbe ye ka ni, wuu sefɛnnɛ, naa wi wɛnnɛ konaa wi cɛnyɛɛnlɛ pe gbo.› » ");
INSERT INTO dyi_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","A Levi setirige piile pè si tanga ma yala Moyisi sɛnyoro ti ni. Ki pilige ki ni, nambala mbele pàa ku, pàa pye na kee lere waga taanri (3 000) yeri. ");
INSERT INTO dyi_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Kona, a Moyisi wì si Levi setirige piile pe pye fɔ: «Nala, yè ye yɛɛ kan Yawe Yɛnŋɛlɛ li yeri mbaa tunŋgo piin li kan, katugu yè yɛnlɛ ma ye pinambiile, naa ye sefɛnnɛ pe gbo. Ki kala na, lì duwaw ye na nala.» ");
INSERT INTO dyi_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ki goto, a Moyisi wì si leele pe pye fɔ: «Yè kapege gbɔgɔ pye. Koni mi yaa lugu naa mbe kari wa Yawe Yɛnŋɛlɛ li yeri, kana pa mi yaa ya mbe ye kapere ti kasulugo ki pye.» ");
INSERT INTO dyi_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","A Moyisi wì si sɔngɔrɔ naa wa Yawe Yɛnŋɛlɛ li yeri, ma saa li pye fɔ: «Ki leele pè kapege gbɔgɔ pye dɛ! Pè tɛ yarisunŋgo gbegele pe yɛɛ kan. ");
INSERT INTO dyi_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Koni, mi yɛn nɔɔ yɛnri, ma pe kapege ki kala yaga pe na; nakosima mala mɛgɛ ki gbo maga wɔ wa sɛwɛ ŋa mà yɔnlɔgɔ wi ni.» ");
INSERT INTO dyi_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","A Yawe Yɛnŋɛlɛ lì si Moyisi wi yɔn sogo ma yo fɔ: «Ayoo! Lere ŋa wì kapege pye na na, ko fɔ wo mɛgɛ ko mi yaa gbo mbe wɔ wa na sɛwɛ wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Koni, ta kee ma sa ki leele pe yɛgɛ sin ma kari pe ni wa laga ŋga mì naga ma na ki ni. Wele, na mɛrɛgɛ wi yaa la tanri ma yɛgɛ. Ɛɛn fɔ, mi ka ka yiri pe kɔrɔgɔ pilige ŋga ni, mi yaa pe jɔlɔ pe kapege ki kala na.» ");
INSERT INTO dyi_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Yawe Yɛnŋɛlɛ làa Izirayɛli woolo pe jɔlɔ napige yanlɛgɛ ŋga pàa ti a Arɔn wì gbegele pe kan ki kala na. ");
INSERT INTO dyi_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si para naa Moyisi wi ni ma yo fɔ: «Yiri na ki laga ŋga ki ni, maa kee mboro naa leele mbele mà yirige wa Ezhipiti tara pe ni; ye kari wa tara nda mìla wugu Abirahamu naa Izaki konaa Zhakɔbu pe kan ma yo mi yaa kari kan pe setirige piile pe yeri ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mi yaa na mɛrɛgɛ wi torogo wi keli ye yɛgɛ, mbe Kana tara fɛnnɛ, naa Amɔri cɛnlɛ woolo, naa Hɛti cɛnlɛ woolo, naa Perɛzi cɛnlɛ woolo, naa Hɛvi cɛnlɛ woolo konaa Zhebusi cɛnlɛ woolo pe purɔ mbe pe yirige wa ki tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Wi yaa ye yɛgɛ sin mbe kari ye ni wa tara nda ti yɛn ma yin nɔnɔ naa sɛnrɛgɛ ni na fuun ti ni. Ɛɛn fɔ, mi jate se pinlɛ ye ni mbe kari, nakoma ye yaa kaga kan mbe ye tɔngɔ mbe ye kɔ konɔ, katugu ye yɛn leele mbele pe ma yiri ma je.» ");
INSERT INTO dyi_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Naa leele pàa kaa ki sɛnŋgbanra ti logo, a pe jatere wì si piri pe na; ki kala na lere wo wa sila wi yɛɛ fere. ");
INSERT INTO dyi_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ma si yala, Yawe Yɛnŋɛlɛ làa ki konɔ kan Moyisi wi yeri ma yo wigi yo Izirayɛli woolo pe kan fɔ: «Ye yɛn leele mbele pe ma yiri ma je. Na mi ka pinlɛ ye ni sa ye torogo wagati jɛnri ni, pa mi yaa ye tɔngɔ mbe ye kɔ. Ki kala na, ye ye yɛɛ fereyaara ti wɔ, pa kona mi yaa ŋga pye, mi yaa ki jɛn.» ");
INSERT INTO dyi_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Mbege lɛ le Izirayɛli woolo pe yirisanga wi ni wa Horɛbu yanwiga ki na, a pè si pe yɛɛ fereyaara ti yaga, pe woro nari nii. ");
INSERT INTO dyi_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Kìla pye na paga sa paara yinrɛ cɛnsaga ki kan, Moyisi wi ma paraga go ki kɔlɔgi ma saa ki kan wa paara yinrɛ cɛnsaga ki puŋgo na, maga lali ki ni, nɛɛ ki yinri filisaga paraga go. Na lere wa kaa jaa mbe Yawe Yɛnŋɛlɛ li yewe kala la ni, wi ma yiri wa paara yinrɛ cɛnsaga ki ni, mbe kari wa filisaga paraga go ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Na Moyisi wi kaa kee wa ki paraga go ki ni sanga ŋa ni, leele pe ni fuun nuŋgba nuŋgba pe ma yiri ma yereyere wa pe paara yinrɛ ti yeyɔnrɔ ti na, naa wele fɔ wi ma saa toro ma ye wa ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Na Moyisi wiga ye wa paraga go ki ni sanga ŋa ni, kambaaga titɔnlɔgɔ yerege ki ma tigi ma yere wa paraga go ki yɔn na. Yawe Yɛnŋɛlɛ li mɛɛ la para Moyisi wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Leele pe ni fuun pe maa kambaaga titɔnlɔgɔ yerege ki yaan kì yere wa paraga go ki yɔn na. Kona pe ni fuun nuŋgba nuŋgba, pe mɛɛ fɔli mali gbɔgɔ wa pe paara yinrɛ yeyɔnrɔ ti na. ");
INSERT INTO dyi_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yawe Yɛnŋɛlɛ làa pye na para Moyisi wi ni gbɔgɔyi, paa yɛgɛ ŋga na lere maa para wi wɔnlɔ ni we. Ko puŋgo na Moyisi wi mɛɛ sɔngɔrɔ ma kari wa paara yinrɛ cɛnsaga ki ni. Ɛɛn fɔ, lefɔnŋɔ ŋa wìla pye wi tunmbyee, Nuni pinambyɔ Zhozuwe we, wo ma koro wa paraga go ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Kona, a Moyisi wì si Yawe Yɛnŋɛlɛ li pye fɔ: «Logo na yeri we Fɔ. Màa ki konɔ kan na yeri ma yo mbaa ki leele mbele pe yɛgɛ sinni. Ɛɛn fɔ, lere ŋa ma yaa taga na na wila na sari, mɛɛ si wo naga na na. Ma si yala, màa ki yo na kan ma yo màla wɔ ma yɛɛ kan, ma ti a na kala lɔ̀ɔn ndanla. ");
INSERT INTO dyi_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ma yɛɛ yaga, na kaa pye kaselege, na kala lɔɔn ndanla, ŋga ma yɛn na sɔnri ma ti mbege jɛn; pa kona mi yaa ma jɛn jɛŋgɛ, na kala li yaa ma ndanla naa jɛŋgɛ. Maa ki jate fun fɔ ki leele mbele pe yɛn ma woolo.» ");
INSERT INTO dyi_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","A Yɛnŋɛlɛ lì suu yɔn sogo ma yo fɔ: «Mi jate mi yaa sɔɔn torogo konaa mbaa ma go singi.» ");
INSERT INTO dyi_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","A Moyisi wì sho naa fɔ: «Na kaa pye mboro jate ma se sa we torogo, maga ka we pye we yiri laga ki laga ŋga ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Na mɛɛ sa we torogo, pe yaa ki jɛn mɛlɛ mbe yo mi naa ma woolo pe ni, we kala li yɛn mɔɔ ndanla? Kaawɔ ma sa we torogo ko ki yaa ki naga fɔ we yɛn we yɛ tara woolo sanmbala pe ni.» ");
INSERT INTO dyi_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi yɔn sogo ma yo fɔ: «Ŋga mà yɛnri mi yaa ko fun ki pye, katugu ma kala lìlan ndanla, a mɔ̀ɔ wɔ.» ");
INSERT INTO dyi_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","A Moyisi wì sho naa fɔ: «Ki yaga mɔɔ gbɔgɔwɔ pi naga na na.» ");
INSERT INTO dyi_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Kona, a Yɛnŋɛlɛ lì sho naa fɔ: «Mi yaa toro ma yɛgɛ sɔgɔwɔ, mbanla kajɛŋgɛ pyege ki ni fuun ki naga ma na, mbege yari ma yɛgɛ sɔgɔwɔ yɛgɛ ŋga na mi yɛn. Mi yaa lere ŋa yinriwɛ ta, mi yaa wo yinriwɛ ta. Lere ŋa yuŋgbɔgɔrɔ yaa pye na na, wo yuŋgbɔgɔrɔ yaa pye na na.» ");
INSERT INTO dyi_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","A lì sho naa fɔ: «Ma se ya mbanla yɛgɛ ki yan, katugu lewee se ya mbanla yɛgɛ ki yan, mbe koro yinwege na.» ");
INSERT INTO dyi_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","A Yawe Yɛnŋɛlɛ lì sho naa fɔ: «Laga ka yɛn na na tanla tɔɔn, walaga yi, pan ma yere laga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Na mi kaa toro mbaa na gbɔgɔwɔ pi nari sanga ŋa ni, mi yaa ma le wa ki walaga ki wege ki ni, mbɔɔn tɔn na kɛɛ ki ni fɔ mbe sa toro mbe kɔ. ");
INSERT INTO dyi_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ko puŋgo na, mi yaa na kɛɛ ki laga ma na, kona ma mbe ya mbanla pɔgɔlɔ ke yan; katugu lere se ya mbanla yɛgɛ ki yan.» ");
INSERT INTO dyi_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Mboro jate sinndɛɛrɛ papara papara shyɛn tɛ paa koŋgbannda nda mà yaari ti yɛn. Mi yaa ŋgasegele ŋgele kàa pye wa koŋgbannda ti na ke yɔnlɔgɔ wa nda ma yaa tɛ ti na. ");
INSERT INTO dyi_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ma yɛɛ gbɛgɛlɛ sanni goto pinliwɛ ni. Ma yiri faa, ma lugu wa Sinayi yanwiga ki na, ma sa yere wa ki go na, maa na singi. ");
INSERT INTO dyi_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Lere kpɛ ka ka pinlɛ ma ni mbe lugu wa yanwiga ki na. Paga ka lere wa kpɛ yan wa yanwiga laga ka na. Sumbyɔ naa sugbɔ konaa nɛgɛ ka ka yan wa yanwiga ki tanla kila yan kaa.» ");
INSERT INTO dyi_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","A Moyisi wì si sinndɛɛrɛ shyɛn tɛ papara papara paa koŋgbannda ti yɛn. Ki goto yirifaga ki na, a wì si kari ma saa lugu wa Sinayi yanwiga ki na sinndɛɛrɛ papara papara shyɛn ti ni wi kɛɛ, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","A Yawe Yɛnŋɛlɛ lì si tigi wa kambaaga ki ni ma yere le Moyisi wi tanla, ma li yɛɛ mɛgɛ ki yeri ma yo fɔ: «Yawe Yɛnŋɛlɛ». ");
INSERT INTO dyi_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","A lì si toro Moyisi wi yɛgɛ sɔgɔwɔ, nɛɛ wi piin naa fɔ: «Mi yɛn Yawe Yɛnŋɛlɛ. Yawe Yɛnŋɛlɛ na li yɛn leele yinriwɛ tafɔ, naa yuŋgbɔgɔrɔ tafɔ; mila la nawa ŋgbanni jaga jaga; na kagbaraga ki yɛn ma gbɔgɔ, mi si yɛn sɛnrɛ nuŋgba yofɔ. ");
INSERT INTO dyi_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Na ndanlawa pi yɛn kɔsaga fu leele pe ni, naa pe setirige piile yirisaga waga lɛgɛrɛ ni. Mi maa leele pe kapere naa pe mbasinmɛ konaa pe punŋguwɔ kagala ke kunni na yɛɛ ni. Ɛɛn fɔ, mila tanga kan ŋa wi daga mbe jɛrɛgi wi yeri. Mi ma teele pe mbasinmɛ pi fɔgɔ tɔn pe piile pe na, fɔ sa gbɔn pe setirige piile yirisaga taanri wogo naa tijɛrɛ wogo ki na.» ");
INSERT INTO dyi_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Le ki yɔngɔlɔ nuŋgba ke ni, a Moyisi wì si sogo maa yɛgɛ ki jiile wa tara, ma Yawe Yɛnŋɛlɛ li gbɔgɔ; ");
INSERT INTO dyi_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","kona mɛɛ yo fɔ: «We Fɔ, na kaa pye na kala lɔɔn ndanla, mi yɛn nɔɔ yɛnri, ma sa we torogo. Mìgi jɛn ma yo ki leele mbele pe yɛn leele mbele pe ma yiri ma je. Ɛɛn fɔ, mi yɛn nɔɔ yɛnri ma we mbasinmɛ naa we kapere ti kala yaga we na, maa we jate ma woolo.» ");
INSERT INTO dyi_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kona, a Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Mi yaa yɔn finliwɛ pi le naa fɔnŋgɔ ye ni. Mi yaa kafɔnŋgɔlɔ pye ma woolo pe ni fuun pe yɛgɛ na, ŋgele ke cɛnlɛ la fa yan tara ti laga ka kpɛ ni wa cɛngɛlɛ ke sɔgɔwɔ. Pa kona, mi ŋa Yawe Yɛnŋɛlɛ, kafɔnŋgɔlɔ ŋgele mi yaa ti ma pye ke yɛn fyɛrɛ kagala yɛgɛ ŋga na, Izirayɛli woolo pe yaa ke yan, poro mbele pe yɛn mɔɔ maga we. ");
INSERT INTO dyi_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Sɛnrɛ nda mila yuun ye kan nala, yaa ti jate jɛŋgɛ. Mi yaa Amɔri cɛnlɛ woolo, naa Kana tara fɛnnɛ, naa Hɛti cɛnlɛ woolo, naa Perɛzi cɛnlɛ woolo, naa Hɛvi cɛnlɛ woolo konaa Zhebusi cɛnlɛ woolo pe purɔ mbe pe yirige wa ye yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ye yɛɛ yingiwɛ jɛn, yaga ka yɔn finliwɛ le tara nda ye yaa sa cɛn wa ti ni ti woolo pe ni; jaŋgo paga ka pye paa pɛnɛ yɛn mbe ye yigi. ");
INSERT INTO dyi_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ɛɛn fɔ, ye pe saara wɔsara ti jaanri, sinndɛɛrɛ nda pè yerege yerege na sunnu ti na, yeri gbɔn yeri yaari, tiyagala ŋgele pe ma kankan na sunnu ke na, ye ke kɔɔnlɔ kɔɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Yaga ka yarisunŋgo ka kpɛ gbɔgɔ, katugu mi ŋa Yawe Yɛnŋɛlɛ, na mɛgɛ koyi ŋga yenjaga fɔ. Mi yɛn Yɛnŋɛlɛ na laa li yenjɔ wi yaga. ");
INSERT INTO dyi_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ki kala na, yaga ka yɔn finliwɛ le ki tara woolo pe ni; nakoma na pe kaa nanjara ti piin mbaa pe yarisunndo ti gbogo, pe yaa kaa ye yinri mbaa kee ye ni wa. Saara nda pe yaa la woo pe yarisunndo ti yeri, pe yaa kaa ye yinri ye saa ki saara yaakara ti kaa. ");
INSERT INTO dyi_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Pa kona ye yaa kaa pe sumbonɔ pe pori ye pinambiile pe kan pe jɛɛlɛ. Ki ka pye ma, pe sumborombiile paga kaa nanjara ti piin pe yarisunndo gbɔgɔwɔ pi na sanga ŋa ni, pa pe yaa ti ye pinambiile paa ti gbogo fun. ");
INSERT INTO dyi_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Yaga ka tugurɔn ta kpɛ yan mberi pye yarisunŋgo ye yɛɛ kan. ");
INSERT INTO dyi_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Yaa leve fu buru fɛti wi piin yarilire kɔnyeŋge ki ni, mbe yala wagati ŋa wì kɔn ma tɛgɛ wi ni. Piliye kɔlɔshyɛn ni, ye yaa la leve fu buru kaa, paa yɛgɛ ŋga na mìgi yo ye kan we, katugu ki yeŋge ki ni, ko yàa yiri wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Pinambyɔ koŋgbanŋa pyew wi yɛn na woo; yaayoro ti pinambire koŋgbannda fun ti yɛn na woro. Nanɔ wi pinambyɔ koŋgbanŋa, naa simbanɔ wi pinambyɔ koŋgbanŋa konaa sikanɔ wi pinambyɔ koŋgbanŋa wi ni, ye daga mbe pe wɔ na yeri saraga. ");
INSERT INTO dyi_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Sofile wi pinambyɔ koŋgbanŋa wo na, ye simbapige nakoma sikapige tɛgɛ yoo go shɔ; na yee ŋa go shɔ, yoo go ki yaari yoo gbo. Ye ye pinambiile koŋgbanmbala pe ni fuun pe go shɔ. «Lere ka ka pan laga na yɛgɛ sɔgɔwɔ kɛwara ni. ");
INSERT INTO dyi_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Ye yaa la tunŋgo piin piliye kɔgɔlɔni yapelege ki ni, ɛɛn fɔ, pilige kɔlɔshyɛn wogo ko na, ye yaa cɛn mbe wogo, yariluguro lugusanga ni o, yarilire kɔnsanga ni o. ");
INSERT INTO dyi_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Ye yaa la Pantikɔti fɛti wi piin bile koŋgbanŋa wi kɔnsanga wi ni, konaa mbaa yarilire kɔngɔ fɛti wi piin wa yɛlɛ li kɔsaga yeri. ");
INSERT INTO dyi_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","«Yɛlɛ nuŋgba nuŋgba pyew, ye woolo pe nambala pe ni fuun pe yaa pan pansaga taanri laga mi ŋa Yawe Yɛnŋɛlɛ, yoro Izirayɛli woolo Yɛnŋɛlɛ le, na yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mi yaa cɛngɛlɛ kele purɔ wa ye yɛgɛ mbe ye tara ti pye ti gbɔgɔ. Yɛlɛ pyew, na yaga kari karisaga taanri wa mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ, lere wa kpɛ se kaa ki jaa mbe ye tara ti shɔ mberi ta. ");
INSERT INTO dyi_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Yarikanga ŋga leve ma ye ki ni yaga ka ka pinlɛ yaayoro saara ni mbe wɔ na yeri. Saara nda ti yaa wɔ Paki fɛti wi na, yaga kaga kara ta yaga ti wɔnlɔ ti yiri. ");
INSERT INTO dyi_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ye yaa kaa paan ye kɛrɛ yarilire fɔnndɔ koŋgbannda ti ni wa mi ŋa Yawe Yɛnŋɛlɛ, ma Yɛnŋɛlɛ na cɛnsaga paraga go ki ni. Yaga ka sugbɔ yirifɔnŋɔ sɔgɔ wa wi nɔ yinriwɛ pi ni.» ");
INSERT INTO dyi_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye naa fɔ: «Ki sɛnrɛ nda ti yɔnlɔgɔ; katugu to mì tɛgɛ ma yɔn finliwɛ le mi naa mboro, naa Izirayɛli woolo sanmbala pe ni.» ");
INSERT INTO dyi_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moyisi wìla koro wa Yawe Yɛnŋɛlɛ li ni, ma yɔnlɔ nafa shyɛn pye naa ki yembinɛ nafa shyɛn. Wi sila ka, wi sila wɔ. Làa yɔn finliwɛ sɛnrɛ ti yɔnlɔgɔ sinndɛɛrɛ papara papara ti na, to nda ti yɛn ŋgasegele kɛ ŋgele. ");
INSERT INTO dyi_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Kona, a Moyisi wì si yiri wa Sinayi yanwiga ki na ma tigi, yɔn finliwɛ sɛnrɛ tìla pye ma yɔnlɔgɔ sinndɛɛrɛ papara papara shyɛn nda na tìla pye wi kɛɛ. Naa Yawe Yɛnŋɛlɛ làa para wi ni, wi yɛgɛ kìla pye na yɛngɛlɛ, ɛɛn fɔ, wi sila sigi jɛn. ");
INSERT INTO dyi_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","A Arɔn naa Izirayɛli woolo sanmbala pe ni fuun pè si Moyisi wi yan, pe mbe ka wele, mɛɛ wi yɛgɛ ki yan kila yɛngɛlɛ. A pe nɛɛ fyɛ mbe fulo wa wi tanla. ");
INSERT INTO dyi_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Kona, a Moyisi wì si pe yeri. A Arɔn naa Izirayɛli gbogolomɔ woolo teele pè si fulo wa wi tanla; a wì si para pe ni. ");
INSERT INTO dyi_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ko puŋgo na, a Izirayɛli woolo sanmbala pè si fulo wa wi tanla. A wì si ŋgasegele ŋgele Yawe Yɛnŋɛlɛ làa yo wi kan wa Sinayi yanwiga ki na ke ni fuun ke yɛgɛ yo pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Naa Moyisi wìla kaa para pe ni ma kɔ, a wì suu yɛgɛ ki fo paraga ni. ");
INSERT INTO dyi_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Na wi kaa kee wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ mbe sa para li ni sanga ŋa ni, wi ma paraga ki laga wa wi yɛgɛ ki na. Wi yiriŋgɔlɔ wa, wi ma sɛnrɛ nda lì yo wi kan ti yɛgɛ yo Izirayɛli woolo pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Izirayɛli woolo pàa pye na Moyisi wi yɛgɛ ki yaan kila yɛngɛlɛ. Ko puŋgo na, wi mɛɛ paraga ki tɛgɛ maa yɛgɛ ki fo naa, fɔ wi ka sa sɔngɔrɔ wa Yawe Yɛnŋɛlɛ li yeri mbe para li ni, ko wi ma jɛn maga laga wa. ");
INSERT INTO dyi_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Kona, a Moyisi wì si Izirayɛli woolo gbogolomɔ pi ni fuun pi gbogolo mɛɛ pe pye fɔ: «Sɛnrɛ nda Yawe Yɛnŋɛlɛ lì yo waa tanri ti na ti nda: ");
INSERT INTO dyi_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","‹Ye yaa la tunŋgo piin piliye kɔgɔlɔni yapelege ki ni, ɛɛn fɔ, pilige kɔlɔshyɛn wogo ki yaa pye wogopilige, cɛnpilige yi, ŋga kì tɛgɛ ki yɛ Yawe Yɛnŋɛlɛ li kan. Lere o lere ka tunŋgo pye cɛnpilige ki ni wi daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Yaga ka kasɔn mu cɛnpilige ki ni wa ye yinrɛ ti ni.› » ");
INSERT INTO dyi_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Kona, a Moyisi wì si Izirayɛli gbogolomɔ woolo pe ni fuun pe pye naa fɔ: «Yawe Yɛnŋɛlɛ li sɛnyoro ti nda: ");
INSERT INTO dyi_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‹Ye ye kɛɛ yaara ta lagala yeri kan Yawe Yɛnŋɛlɛ li yeri. Lere o lere wila ki jaa mbe kan nayinmɛ ni, wila paan yarikanga ni li kan. To ti yɛn tɛ nakoma warifuwe, nakoma tuguyɛnrɛ, ");
INSERT INTO dyi_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","naa ŋganra jese, naa kondoro jese, naa jese yɛɛn kpanyi, naa lɛn jese ŋgbaan, naa sikanɔ sire, ");
INSERT INTO dyi_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","naa simbapɛnɛ sɛɛrɛ nda pè le kondoro, naa sɛɛrɛ liire ni, naa akasiya tire ni, ");
INSERT INTO dyi_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","naa fitanla sinmɛ ni, naa nuwɔ taanyaara nda pe ma gbegele sinmɛ kpoyi konaa wusuna nuwɔ taan ŋa pe ma sogo; ");
INSERT INTO dyi_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","naa ɔnikisi sinndɛɛrɛ, naa sinndɛɛrɛ sɔnŋgbanga woro ta yɛgɛ ni nda ti yaa maramara efɔdi wo naa yaripɔgɔ ŋga pe ma le ma wa kotogo na ti na.› ");
INSERT INTO dyi_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Kapyɔ jɛnfɛnnɛ mbele fuun pe yɛn laga ye sɔgɔwɔ, pe gbogolo, ŋga Yawe Yɛnŋɛlɛ lì yo, pege gbegele; ko ki yɛn: ");
INSERT INTO dyi_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Yɛnŋɛlɛ cɛnsaga paraga go, naa paraga go ŋga ki yaa pye ki go na ki ni, naa ki gona tɔnparaga ki ni, naa ki kandɔɔlɔ yaŋgala ke ni, naa ki tire papara papara ti ni, naa ki tipaara ti ni, naa ki tiyagala ke ni, naa ki nɔgɔna cɛnyaara ti ni; ");
INSERT INTO dyi_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","naa yɔn finliwɛ kɛsu wi ni, naa wi lɛkanŋgagala ke ni, naa wi katɔnŋgɔ ki ni, naa paraga ŋga pe ma pɔ ma go ki kɔn shyɛn ki ni; ");
INSERT INTO dyi_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","naa tabali wo naa wi lɛkanŋgagala ke ni, naa wi tunŋgo pyeyaara ti ni fuun ti ni, naa buru ŋa pe ma kan Yɛnŋɛlɛ yeri wi ni; ");
INSERT INTO dyi_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","naa fitanladaga wo naa wi tunŋgo pyeyaara ti ni, naa wi fitanlaye pe ni, naa fitanla sinmɛ pi ni; ");
INSERT INTO dyi_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","naa wusuna nuwɔ taan wi ma sogo saraga wɔsaga ŋga na ki ni, naa ki lɛkanŋgagala ke ni, naa sinmɛ kpoyi, naa wusuna nuwɔ taan ni, naa Yɛnŋɛlɛ cɛnsaga paraga go ki yeyɔngɔ tɔnparaga ki ni; ");
INSERT INTO dyi_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","naa saara sogoworo ti ma sogo saraga wɔsaga ŋga na ki ni, naa ki tuguyɛnrɛ mɛrɛ ti ni, naa ki lɛkanŋgagala ke ni, naa ki tunŋgo pyeyaara ti ni fuun ti ni, naa jogoyaraga konaa ki tatɛgɛ ki ni, ");
INSERT INTO dyi_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","naa loŋgo ki jasa paara ti ni, naa jasa tiyagala koro naa ke nɔgɔna cɛnyaara ti ni, naa loŋgo ki yeyɔngɔ tɔnparaga ki ni; ");
INSERT INTO dyi_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","naa cɛnsaga paraga go ki kankanŋgagala ke ni, naa loŋgo ki jasa kankanŋgagala ke ni konaa ti pɔmanda ti ni, ");
INSERT INTO dyi_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","naa yaripɔrɔ nda pe yaa la nii mbaa tunŋgo piin wa laga kpoyi ki ni ti ni konaa saraga wɔfɔArɔn wi yaripɔrɔ nda ti yaa kan Yɛnŋɛlɛ yeri ti ni, ma pinlɛ wi pinambiile pe woro ti ni, to nda pe yaa la nii mbaa saraga wɔgɔtunŋgo ki piin we.» ");
INSERT INTO dyi_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kona, a Izirayɛli gbogolomɔ woolo pè si yiri le Moyisi wi tanla ma kari. ");
INSERT INTO dyi_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ko puŋgo na, mbele fuun kìla tigi wa pe kotogo na pe yarikanra kan konaa a paa ki jaa mbe kan nayinmɛ ni, a pè si pan pe yarikanra ti ni Yawe Yɛnŋɛlɛ li kan filisaga paraga go ki kanwa wogo ki na, naa tunŋgo ŋga fuun ki yaa pye ki wogo ki na, konaa yaripɔrɔ nda ti yaa tɛgɛ ti yɛ ti gbegewe wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Mbele fuun pàa pye naga jaa mbege pye nayinmɛ ni, ki naŋa naa ki jɛlɛ, pè si pan pe yarikanra ti ni; to lari nda: Yɔlɔgɔ kannjiŋgele, naa nuŋgbogolo, naa vegembele, naa kɛɛ yɔlɔgɔ kannjiŋgele, naa tɛ fereyaara ti cɛnlɛ pyew ta ni. A pè siri yirige mari kan saraga Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ŋganra jese, naa kondoro jese, naa jese yɛɛn kpanyi, naa lɛn jese ŋgbaan, naa sikanɔ sire, naa simbapɛnɛ sɛɛrɛ nda pè le kondoro konaa sɛɛrɛ liire la pye mbele fuun yeri, pàa pan ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Leele mbele fuun pàa warifuwe naa tuguyɛnrɛ lagala mberi pye yarikanra, a pè si pan ti ni Yawe Yɛnŋɛlɛ li kan. Mbele fuun akasiya tire la pye pe yeri, pàa pan ti ni mbe tunŋgo ki ni fuun ki pye. ");
INSERT INTO dyi_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Jɛɛlɛ mbele fuun pàa pye kapyɔ jɛnfɛnnɛ pè si ŋganra jese, naa kondoro jese, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan pili pe yɛ, ma pan wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Jɛɛlɛ sanmbala mbele fuun pàa pye kapyɔ jɛnfɛnnɛ, a tunŋgo ki pyela yɛn pe na pe kotogo ki ni fuun ni, a poro si sikanɛɛlɛ sire pili jese. ");
INSERT INTO dyi_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","A Izirayɛli woolo teele pè si pan ɔnikisi sinndɛɛrɛ ni konaa sinndɛɛrɛ sɔnŋgbanga woro ta yɛgɛ ni, nda pe yaa maramara efɔdi wo naa yaripɔgɔ ŋga pe ma le ma wa kotogo na ti na. ");
INSERT INTO dyi_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Pàa pan nuwɔ taanyaara ni, naa fitanla sinmɛ ni, naa mba pe ma wo yaraga na mbege wɔ Yɛnŋɛlɛ kan konaa wusuna nuwɔ taan ni. ");
INSERT INTO dyi_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Tunŋgo ŋga Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan ma yo pe pye, Izirayɛli woolo mbele fuun pàa pye naga jaa mbe yarikanra kan nandanwa ni ki tunŋgo ki pyewe pi na, pè si pan pe nayinmɛ yarikanra ti ni, ki naŋa naa ki jɛlɛ, mari kan li yeri. ");
INSERT INTO dyi_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kona, a Moyisi wì si Izirayɛli woolo pe pye fɔ: «Ye wele, Yawe Yɛnŋɛlɛ lì Uri pinambyɔ Bezaleyɛli wi wɔ ma yiri wa Zhuda cɛnlɛ li ni. Uri to wo lawi ŋa Huri. ");
INSERT INTO dyi_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Yawe Yɛnŋɛlɛ lìli yinnɛ li le wi ni maa yin, maa kan kajɛnmɛ naa tijinliwɛ konaa kapyɔ tunndo yɛgɛ jɛnmɛ ni mbaa tunndo cɛnlɛ pyew ti piin. ");
INSERT INTO dyi_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Wi mbe ya mbaa kapyɔ tunndo fɔnndɔ jatere taa, mbaa ti gbegele tɛ ni, naa warifuwe konaa tuguyɛnrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Wi mbe ya mbaa sinndɛɛrɛ sɔnŋgbanga woro ti tɛni mbaa ti sogolo ti yɛɛ ni, konaa mbaa tire tɛni la kapyɔ tunndo cɛnlɛ pyew ti piin. ");
INSERT INTO dyi_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","We Fɔ wì tijinliwɛ kan wi yeri, konaa maa kan fun Ahisamaki pinambyɔ Oholiyabu wi yeri, wo ŋa wì yiri wa Dan cɛnlɛ li ni, paa leele pe nari kapyɔ tunndo pyewe pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Wì tijinliwɛ kan pe yeri paa tunndo cɛnlɛ pyew ti piin, mbaa yaara tɛni, mbaa yaara yanlɛrɛ gbegele, mbaa paara ti sɔgɔ ŋganra jese ni, naa kondoro jese ni, naa jese yɛɛn kpanyi ni konaa lɛn jese ŋgbaan ni, mbaa tunndo cɛnlɛ pyew ti piin konaa mbaa kapyɔ tunndo fɔnndɔ jatere taa.» ");
INSERT INTO dyi_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Kona Bezaleyɛli naa Oholiyabu konaa kapyɔ jɛnfɛnnɛ sanmbala mbele fuun Yawe Yɛnŋɛlɛ làa kajɛnmɛ, naa tijinliwɛ naa kapyɔ tunndo yɛgɛ jɛnmɛ pi kan pe yeri pe ta pe cɛnsaga paraga go ki tunŋgo ki ni fuun ki pye, pe yaa pan mbege pye paa yɛgɛ ŋga na làa ki yo we.» ");
INSERT INTO dyi_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","A Moyisi wì si Bezaleyɛli naa Oholiyabu pe yeri. Kapyɔ jɛnfɛnnɛ sanmbala mbele fuun Yawe Yɛnŋɛlɛ làa tijinliwɛ kan pe yeri, a paa ki jate mbe pe yɛɛ kan tunŋgo ki yeri, wìla pe yeri fun. ");
INSERT INTO dyi_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Izirayɛli woolo pàa pan yarikanra nda fuun ni mbe cɛnsaga paraga go ki kan, a Moyisi wì siri kan tunŋgo pyefɛnnɛ pe yeri. Pilige pyew, pinliwɛ ni, leele pàa pye na paan pe nayinmɛ yarikanra ti ni nari kaan Moyisi wi yeri. ");
INSERT INTO dyi_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Kona, a tunmbyeele wele, poro mbele pàa pye kapyɔ jɛnfɛnnɛ na cɛnsaga paraga go tunŋgo ki ni fuun ki piin, pè si yiri ma pe tunŋgo ki yaga ma kari Moyisi wi kɔrɔgɔ, ");
INSERT INTO dyi_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ma saa wi pye fɔ: «Leele paa paan yaara nda ni tì lɛgɛ ma toro tunŋgo ŋga Yawe Yɛnŋɛlɛ lì yo we pye ki na.» ");
INSERT INTO dyi_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kì kaa pye ma, a Moyisi wì si konɔ kan ma yo pege yari wa paara yinrɛ cɛnsaga ki ni fɔ: «Nambala naa jɛɛlɛ, wa kpɛ ka ka pan yarikanga ni cɛnsaga paraga go ki tunŋgo ki wogo na naa.» A leele pè si yarikanra ti kanwa pi yerege; ");
INSERT INTO dyi_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","katugu yaara nda pàa kan pe tunŋgo ki pye, tìla lɛgɛ fɔ matoro. ");
INSERT INTO dyi_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Kona, a kapyɔ jɛnfɛnnɛ mbele pàa tunŋgo ki jɛn ma wɛ, pè si Yɛnŋɛlɛ cɛnsaga paraga go ki gbegele paara titɔɔnrɔ titɔɔnrɔ kɛ ni. Pàa ki paara ti ti lɛn jese ŋgbaan ni, naa ŋganra jese ni, naa kondoro jese ni konaa jese yɛɛn kpanyi ni. Pàa sherubɛnye yanlɛɛlɛ pe gbegele wa ti na kapyɔ jɛnfɛnnɛ tunŋgo pyelɔmɔ ni. ");
INSERT INTO dyi_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Paraga nuŋgba nuŋgba pyew ki titɔnlɔwɔ pìla pye mɛtɛrɛ kɛ ma yiri tijɛrɛ, ki gbemɛ pìla pye mɛtɛrɛ shyɛn. Paara ti ni fuun tìla taanla ma yala. ");
INSERT INTO dyi_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","A pè sigi paara ti kaŋgurugo yɔli mari kan ti yɛɛ na, a tì pye nuŋgba, ma kaŋgurugo sannda ti yɔli mari kan ti yɛɛ na ma fun. ");
INSERT INTO dyi_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Paara kaŋgurugo nda pàa keli ma yɔli ma kan yɛɛ na, a pè si ŋganra jese maŋgala pɔpɔ wa ki kaŋgurugo wogo ki yɔn na. Paara kaŋgurugo sannda nda pàa yɔli ma kan ti yɛɛ na, a pè kele pɔpɔ wa ki kaŋgurugo wogo ki yɔn na fun. ");
INSERT INTO dyi_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Paa jese maŋgala nafa shyɛn ma yiri kɛ pɔpɔ paara kaŋgurugo koŋgbannda ti kaŋgurugo wogo ki yɔn na, ma jese maŋgala nafa shyɛn ma yiri kɛ pɔpɔ fun paara kaŋgurugo sannda ti kaŋgurugo wogo ki yɔn na. Ki maŋgala ŋgele pàa pɔpɔ ke yɔnrɔ tìla sinzin ti yɛɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","A pè si kandɔɔlɔ yaŋgala ke nafa shyɛn ma yiri kɛ gbegele tɛ ni fun, ma ki paara titɔɔnrɔ titɔɔnrɔ tɛgɛsaga shyɛn ti yɔnrɔ ti kan ti yɛɛ na, ma paraga go ki pye nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ko puŋgo na, a pè si paara titɔɔnrɔ titɔɔnrɔ kɛ ma yiri nuŋgba gbegele fun sikanɛɛlɛ sire ni, mari pye paa paraga go yɛn, mbaa Yɛnŋɛlɛ cɛnsaga paraga go ki tɔnni ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ki paara ti nuŋgba nuŋgba pyew ki titɔnlɔwɔ pìla pye mɛtɛrɛ kɛ ma yiri kaŋgurugo, ki gbemɛ pìla pye mɛtɛrɛ shyɛn. Paara ti ni fuun tìla pye ma yala. ");
INSERT INTO dyi_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","A pè si paara ti kaŋgurugo yɔli mari kan ti yɛɛ na, ma kɔgɔlɔni sannda ti yɔli mari kan ti yɛɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Paara kaŋgurugo nda pàa yɔli ma kan yɛɛ na, pàa jese maŋgala nafa shyɛn ma yiri kɛ yɔli ti kaŋgurugo wogo ki yɔn na; ma jese maŋgala kele yɔli fun paara kɔgɔlɔni sannda nda pàa yɔli ma kan yɛɛ na ti kɔgɔlɔni wogo ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","A pè si kandɔɔlɔ yaŋgala ke nafa shyɛn ma yiri kɛ gbegele tuguyɛnrɛ ni, ma paara tɛgɛsaga shyɛn ti yɔnrɔ ti kan ti yɛɛ na, jaŋgo ti pye nuŋgba wa Yɛnŋɛlɛ cɛnsaga paraga go ki go na. ");
INSERT INTO dyi_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ko puŋgo na, a pè si tɔnparaga ka gbegele simbapɛnɛ sɛɛrɛ ni nda pàa le kondoro maga tɛgɛ ma paraga go ki go na wi tɔn ki ni, mɛɛ tɔnparaga ka gbegele fun sɛɛrɛ liire ni, maga wa wa ti ni fuun ti go na. ");
INSERT INTO dyi_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","A pè si akasiya tire tɛ tire papara papara, mari yerege yerege mbe Yɛnŋɛlɛ cɛnsaga paraga go ki kan ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ki tire papara papara ti ni fuun nuŋgba nuŋgba ti titɔnlɔwɔ pìla pye mɛtɛrɛ kaŋgurugo kaŋgurugo, ti gbemɛ pìla pye mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Pàa njegele shyɛnzhyɛn wɔwɔ tire papara papara ti ni fuun nuŋgba nuŋgba ti na ma ke sinzin ke yɛɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","A pè si tire papara papara ti nafa gbegele Yɛnŋɛlɛ cɛnsaga paraga go ki yɔnlɔparawa kalige kɛɛ ki kanwa wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","A pè si tire papara papara ti nɔgɔna cɛnyaara nafa shyɛn gbegele warifuwe ni, mari tɛgɛ shyɛnzhyɛn tire papara papara ti ni fuun nuŋgba nuŋgba ti nɔgɔ, mari njegele ke lele wa ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","A pè si tire papara papara ti nafa gbegele fun Yɛnŋɛlɛ cɛnsaga paraga go ki yɔnlɔparaga kamɛŋgɛ kɛɛ ki kanwa wogo ki na, ");
INSERT INTO dyi_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","konaa ma ti nɔgɔna cɛnyaara ti nafa shyɛn gbegele warifuwe ni, mari lele shyɛnzhyɛn wa tire papara papara ti ni fuun nuŋgba nuŋgba ti nɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","A pè si tire papara papara kɔgɔlɔni gbegele Yɛnŋɛlɛ cɛnsaga paraga go ki puŋgo kɛɛ ki kanwa wogo ki na, wa yɔnlɔ tosaga yeri, ");
INSERT INTO dyi_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ma tire papara papara shyɛnzhyɛn gbegele Yɛnŋɛlɛ cɛnsaga paraga go ki yɛngɛlɛ puŋgo wogolo ke kanwa wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Tìla lɛ wa nɔgɔna ma mara yɛɛ na ma kari naayeri; a pè saa ti shyɛn ti pɔ ti yɛɛ na ŋgerege nuŋgba ni. Pàa go ki yɛngɛlɛ shyɛn ke pye ki pyelɔmɔ nuŋgba pi na ma fun. ");
INSERT INTO dyi_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kì kaa pye ma, wa Yɛnŋɛlɛ cɛnsaga paraga go ki puŋgo na, tire papara papara tìla pye kɔlɔtaanri, ti nɔgɔna cɛnyaara nda pàa gbegele warifuwe ni, tìla pye kɛ ma yiri kɔgɔlɔni. Tìla pye shyɛnzhyɛn tire papara papara ti ni fuun nuŋgba nuŋgba ti nɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","A pè si akasiya tire kaŋgurugo tɛ mari pye tipaara. A to pye Yɛnŋɛlɛ cɛnsaga paraga go ki kanŋgɔlɔ nuŋgba ki tire papara papara ti woro; ");
INSERT INTO dyi_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ma kaŋgurugo tɛ fun ki kanŋgɔlɔ sanŋga ki tire papara papara ti woro, ma kaŋgurugo yɛgɛ tɛ ki puŋgo kɛɛ ki tire papara papara ti woro, wa yɔnlɔ tosaga kɛɛ yeri. ");
INSERT INTO dyi_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","A pè si nandogomɔ tiyaparaga ki tɛ. Pàa ki taga wa tire papara papara ti nandogomɔ, maga lɛ kɛɛ ŋga na, ma saa gbɔn kɛɛ ŋga na. ");
INSERT INTO dyi_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","A pè si tɛ wo tire papara papara ti lagapyew ki na mari tɔn, ma tɛ ŋgereye gbɔn mbe tipaara ti lele wa yi ni. Pàa tɛ wo tipaara ti lagapyew ki na mari tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Paraga ŋga ki yaa pɔ mbe Yɛnŋɛlɛ cɛnsaga paraga go ki kɔn shyɛn pàa ki ti ŋganra jese ni, naa kondoro jese ni, naa jese yɛɛn kpanyi ni, naa lɛn jese ŋgbaan ni. Kapyɔ jɛnfɛnnɛ pàa ki ti ma sherubɛnye yanlɛɛlɛ pe gbegele wa ki na. ");
INSERT INTO dyi_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","A pè si akasiya tire lɛ mari tɛ tiyagala tijɛrɛ, ma tɛ wo ke lagapyew ki na ma ke tɔn, mbe ta mbe paraga ki kan ke na; kandɔɔlɔ yaŋgala pàa kele gbegele tɛ ni tiyagala ke na, ma tiyagala ke nɔgɔna cɛnyaara tijɛrɛ gbegele warifuwe ni ma ke lele wa ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","A pè si Yɛnŋɛlɛ cɛnsaga paraga go ki yeyɔngɔ tɔnparaga ki ti maga sɔgɔ ŋganra jese ni, naa kondoro jese ni, naa jese yɛɛn kpanyi ni konaa lɛn jese ŋgbaan ni. ");
INSERT INTO dyi_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","A pè si tiyagala kaŋgurugo tɛ mbe paraga ki kan ke na, mɛɛ kandɔɔlɔ yaŋgala kele gbegele wa tiyagala ke na. Pàa tɛ wo tiyagala ke gona tɔnyaara ti na mari tɔn, ma wa wo paara yanŋgakanŋgagala ke na ma ke tɔn, ma tiyagala ke nɔgɔna cɛnyaara ti gbegele tuguyɛnrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Kona, a Bezaleyɛli wì si yɔn finliwɛ kɛsu wi gbegele akasiya tire ni. Wi titɔnlɔwɔ pìla pye mɛtɛrɛ nuŋgba naa mɛtɛrɛ kɔngɔ ki kɔngɔ. Wi gbemɛ pìla pye mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. Wi yagawa pìla pye mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A wì si tɛ piiri wo kɛsu wi nawa naa wi puŋgo ki na maa tɔn, ma wa wo wi yɔn koŋgo ki na kɛɛrɛ maga maga, maga fili. ");
INSERT INTO dyi_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Mɛɛ tɛ wa gbɔn ŋgereye tijɛrɛ mayi lele kɛsu wi yɛngɛlɛ tijɛrɛ ke na. Wìla shyɛn le kanŋgɔlɔ nuŋgba na, ma shyɛn sannya yi le kanŋgɔlɔ sanŋga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ko puŋgo na, a wì si akasiya tige kanŋgagala shyɛn tɛ, mɛɛ tɛ wo ke na ma ke tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A wì si kanŋgagala ke le wa ŋgereye yi ni wa kɛsu wi kanŋgara ti na pe ta paa wi lee ke ni. ");
INSERT INTO dyi_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A wì si kapere ti kasulugo pyesaga ki gbegele tɛ piiri ni. Ki titɔnlɔwɔ pìla pye mɛtɛrɛ nuŋgba naa mɛtɛrɛ kɔngɔ ki kɔngɔ. Ki gbemɛ pìla pye mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. Ko kìla pye kɛsu wi yaritɔnŋgɔ ye. ");
INSERT INTO dyi_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","A wì si tɛ piiri gbɔn wi yɛɛ na ma sherubɛnye yanlɛɛlɛ shyɛn pe gbegele wa kasulugo pyesaga ki kɛyɛn shyɛn yi na. ");
INSERT INTO dyi_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Wìla sherubɛn nuŋgba gbegele go nuŋgba na, ma sanŋa wi gbegele go sanŋga ki na. Wìla pe gbegele wa kapere ti kasulugo pyesaga ki yinrɛ shyɛn ti na ma pe yirige ki go na. ");
INSERT INTO dyi_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Sherubɛnye pàa pe kanwira ti yirige mari jaraga kapere ti kasulugo pyesaga ki go na maga tɔn, ma yɛgɛ wa pe yɛɛ yeri na kapere ti kasulugo pyesaga ki wele. ");
INSERT INTO dyi_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Kona, a Bezaleyɛli wì si tabali wi kan akasiya tire ni. Wi titɔnlɔwɔ pìla pye mɛtɛrɛ nuŋgba, wi gbemɛ pìla pye mɛtɛrɛ kɔngɔ, wi yagawa pìla pye mɛtɛrɛ kɔngɔ naa mɛtɛrɛ kɔngɔ ki kɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Wìla tɛ piiri wo wi na maa tɔn, ma wa wo wi yɔn koŋgo ki na kɛɛrɛ maga maga maa fili. ");
INSERT INTO dyi_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Wìla tige papagapa ka kan tabali wi kanŋgara ti na maa maga maa fili. Ki tige ki gbemɛ pìla pye pa kɛndala gbemɛ yɛn. Wìla tɛ wo ki yɔn koŋgo ki na kɛɛrɛ maga maga, maga fili. ");
INSERT INTO dyi_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","A wì si tɛ gbɔn ma ŋgereye tijɛrɛ gbegele mayi kankan tabali wi yɛngɛlɛ tijɛrɛ ke na, ma mara wi jegele tijɛrɛ ke na. ");
INSERT INTO dyi_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ŋgereye yìla pye ma mara tige papagapa ki na. Pa pàa pye na kanŋgagala ke nii wa, mbaa tabali wi lee. ");
INSERT INTO dyi_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","A wì si akasiya tige kanŋgagala shyɛn tɛ, ma tɛ wo ke na ma ke tɔn. Koro pàa tɛgɛ na tabali wi lee. ");
INSERT INTO dyi_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Yaapire nda pe yaa la gbegele ti ni wa tabali wi na, a wì siri gbegele. To lari nda tasaala kpakpalakpa wele, naa wɔjɛŋgɛlɛ, naa kugbogolo konaa duvɛn saraga ŋga pe ma wo wi leyaara ti ni. Wìla ti ni fuun ti gbegele tɛ piiri ni. ");
INSERT INTO dyi_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Kona, a Bezaleyɛli wì si tɛ piiri gbɔn ma fitanladaga wi gbegele. Wìla wi gbegele maa pinlɛ nuŋgba, wi nɔgɔ ki ni, naa wi njegele, naa wi leyaara yanlɛrɛ, naa wi gbunŋgbunŋgolo, konaa wi yarifyɛɛnrɛ yanlɛrɛ ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Njegele kɔgɔlɔni kàa pye fitanladaga wi kɛyɛn shyɛn yi na; taanri la pye kɛɛ ŋga na, taanri sanŋgala kàa pye kɛɛ sanŋga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Wìla leyaara yanlɛrɛ taanrindaanri gbegele wa fitanladaga wi njegele kɔgɔlɔni ke ni fuun nuŋgba nuŋgba ke na paa amandi tige pige yɛn, naa ki gbunŋgbunŋgolo konaa ki fyɛɛnrɛ yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Leyaara yanlɛrɛ tijɛrɛ la pye fitanladaga wi nandogomɔ kanŋgaga ki na paa amandi tige pire yɛn, naa ki gbunŋgbunŋgolo konaa ki fyɛɛnrɛ yɛn. ");
INSERT INTO dyi_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Gbunŋgbunŋgolo nuŋgba nuŋgba la pye fitanladaga wi kɛyɛn shyɛn njegele shyɛnzhyɛn ke filisaga pyew ki nɔgɔ, wa wi nandogomɔ kanŋgaga ki na. ");
INSERT INTO dyi_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ki gbunŋgbunŋgolo koro naa ki njegele ke ni kàa pinlɛ ma gbegele ma pye nuŋgba fitanladaga wi ni. Tɛ piiri pàa gbɔn ma ti ni fuun ti gbegele. ");
INSERT INTO dyi_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Wìla fitanlaye kɔlɔshyɛn, naa wi yɔn yirigeyaara konaa wi cɔnrɔ leyaara ti gbegele tɛ piiri ni. ");
INSERT INTO dyi_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Tɛ piiri culo nafa ma yiri kɛ pàa tɛgɛ ma fitanladaga wo naa wi tunŋgo pyeyaara ti gbegele. ");
INSERT INTO dyi_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Kona, a Bezaleyɛli wì si wusuna nuwɔ taan wi yaa la sori saraga wɔsaga ŋga na ki gbegele akasiya tire ni. Ki kanŋgɔlɔyɔ tijɛrɛ yìla pye ja. Ki kanŋgɔlɔ nuŋgba nuŋgba pyew ki titɔnlɔwɔ pìla pye mɛtɛrɛ kɔngɔ. Ki yagawa pìla pye mɛtɛrɛ nuŋgba. Pàa yɛnŋgɛlɛ tijɛrɛ tɛ ma ke yirige wa ki yɛngɛlɛ tijɛrɛ ke na, a kè pinlɛ ma pye nuŋgba ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Wìla tɛ piiri wo ki lagapyew ki na maga tɔn, ki gona naa ki kanŋgara to naa ki yɛnŋgɛlɛ ke na. Wìla tɛ wo ki yɔn koŋgo ki na kɛɛrɛ maga maga, maga fili. ");
INSERT INTO dyi_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Wìla tɛ ŋgereye shyɛn gbegele mayi kankan wa saraga wɔsaga ki kɛyɛn shyɛn yi na, wa ki yɔn koŋgo kɛɛrɛ ki nɔgɔ. Pa pàa pye naga lɛkanŋgagala ke nii wa ki ŋgereye yi ni naga lee. ");
INSERT INTO dyi_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A wì sigi lɛkanŋgagala ke gbegele akasiya tire ni, ma tɛ wo ke lagapyew ki na ma ke tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","A wì si ti, a pè sinmɛ kpoyi pa gbegele, po mba pi yɛn ma tɛgɛ pi yɛ Yɛnŋɛlɛ kan, konaa wusuna nuwɔ taan piiri ni. Sinmɛ nuwɔ taanyaara gbegelefɔ wìla ti gbegele. ");
INSERT INTO dyi_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Kona, a Bezaleyɛli wì si saara sogoworo ti ma sogo saraga wɔsaga ŋga na ki gbegele akasiya tire ni. Ki titɔnlɔwɔ naa ki gbemɛ pìla pye ma yala. Ki kanŋgɔlɔ nuŋgba nuŋgba pyew ki titɔnlɔwɔ pìla pye mɛtɛrɛ shyɛn naa kɔngɔ. Ki yagawa pìla pye mɛtɛrɛ nuŋgba naa kɔngɔ. ");
INSERT INTO dyi_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Wìla yɛnŋgɛlɛ tijɛrɛ tɛ ma ke yirige wa ki yɛngɛlɛ ke na. Kàa pinlɛ ma pye nuŋgba ki ni. Wìla tuguyɛnrɛ yan ma wo ki lagapyew ki na maga tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Wìla saraga wɔsaga ki tunŋgo pyeyaara ti ni fuun ti gbegele tuguyɛnrɛ ni, ki cɔnrɔ leyaara, naa ki cɔnrɔ koliyaara, naa ki tasaala, naa ki kara wɔwangala konaa naŋganra wɔyaara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","A wì si tuguyɛnrɛ tɛgɛ ma mɛrɛ gbegele ti ni, mari kan saraga wɔsaga ki na, wa ki yɔn koŋgo kɛɛrɛ ki nɔgɔ, maga maga, maga fili; maga lɛ wa ki nɔgɔna fɔ ma saa gbɔn wa ki nandogomɔ. ");
INSERT INTO dyi_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","A wì si ŋgereye tijɛrɛ gbegele mayi kan wa tuguyɛnrɛ mɛrɛ ti yɛngɛlɛ tijɛrɛ ke na, mbaa ki lɛkanŋgagala ke nii wa yi ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","A wì si kanŋgagala shyɛn gbegele akasiya tire ni ma tuguyɛnrɛ yan ma wo ke lagapyew ke na ma ke tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Pàa pye na kanŋgagala ke nii wa ŋgereye yi ni, saraga wɔsaga ki kɛyɛn shyɛn yi na, mbaa ki lee. Wìla ki gbegele tire papara papara ni, ki nawa pìla pye waga. ");
INSERT INTO dyi_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Kona, a Bezaleyɛli wì si jogoyaraga ki gbegele tuguyɛnrɛ ni, maga tatɛgɛ ki gbegele fun tuguyɛnrɛ ni. Jɛɛlɛ mbele pàa pye na gbogolo wa filisaga paraga go ki yɔn na, pe tuguyɛnrɛ duwaleele poro pàa yan mari gbegele. ");
INSERT INTO dyi_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ko puŋgo na, a Bezaleyɛli wì si loŋgo ki jasa. Wa yɔnlɔparawa kalige kɛɛ ki na, paara nda pàa loŋgo ki jasa pàa ti ti lɛn jese ŋgbaan ni. Ti titɔnlɔwɔ pìla pye mɛtɛrɛ nafa shyɛn ma yiri kɛ. ");
INSERT INTO dyi_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ki kanŋgɔlɔ ki tiyagala kàa pye nafa; ke nɔgɔna cɛnyaara nda pàa gbegele tuguyɛnrɛ ni tìla pye nafa fun. Ki kandɔɔlɔ yaŋgala koro naa ki paara yanŋgakanŋgagala ke ni, pàa ke gbegele warifuwe ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Wa loŋgo ki yɔnlɔparawa kamɛŋgɛ kɛɛ yeri, paara ti titɔnlɔwɔ pìla pye fun mɛtɛrɛ nafa shyɛn ma yiri kɛ, ki tiyagala kàa pye nafa; tiyagala ke nɔgɔna cɛnyaara tìla pye nafa, pàa ti gbegele tuguyɛnrɛ ni. Ki kandɔɔlɔ yaŋgala koro naa ki paara yanŋgakanŋgagala pàa ke gbegele warifuwe ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Wa loŋgo ki yɔnlɔ tosaga yeri, paara ti titɔnlɔwɔ pìla pye mɛtɛrɛ nafa ma yiri kaŋgurugo, ki tiyagala kàa pye kɛ; tiyagala ke nɔgɔna cɛnyaara tìla pye kɛ fun. Ki kandɔɔlɔ yaŋgala koro naa ki paara yanŋgakanŋgagala ke ni, pàa ke gbegele warifuwe ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Wa yɔnlɔ yirisaga yeri, loŋgo ki titɔnlɔwɔ pìla pye mɛtɛrɛ nafa ma yiri kaŋgurugo. ");
INSERT INTO dyi_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Loŋgo ki yeyɔngɔ ki kɛyɛn shyɛn yi ni fuun nuŋgba nuŋgba yi na, paara ti titɔnlɔwɔ pìla pye mɛtɛrɛ kɔlɔshyɛn kɔlɔshyɛn naa kɔnrɔkɔnrɔ, naa tiyagala taanrindaanri ni konaa ke nɔgɔna cɛnyaara taanrindaanri ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Paara nda fuun pàa tɛgɛ ma loŋgo ki jasa maga fili pàa ti ti lɛn jese ŋgbaan ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Tiyagala ke nɔgɔna cɛnyaara pàa ti gbegele tuguyɛnrɛ ni. Kandɔɔlɔ yaŋgala koro naa paara yanŋgakanŋgala ke ni, pàa ke gbegele warifuwe ni, ma ke tɛgɛ ma tiyagala ke yigiyigi wa ke sɔgɔwɔ pi ni. Pàa warifuwe yan ma wo tiyagala ke gona tɔnyaara ti na mari tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Loŋgo ki yeyɔngɔ tɔnparaga pàa ki ti maga sɔgɔ lɛn jese ŋgbaan ni, naa ŋganra jese ni, naa kondoro jese konaa jese yɛɛn kpanyi ni. Ki titɔnlɔwɔ pila pye mɛtɛrɛ kɛ, ki yagawa pìla pye mɛtɛrɛ shyɛn naa kɔngɔ. Ki yagawa po naa jasa paara ti yagawa pìla pye ja. ");
INSERT INTO dyi_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Pàa ki pɔ tiyagala tijɛrɛ na ŋgele kàa pye ma taga nɔgɔna cɛnyaara tijɛrɛ na. Pàa ti gbegele tuguyɛnrɛ ni. Kandɔɔlɔ yaŋgala koro naa paara yanŋgakanŋgala ke ni, pàa ke gbegele warifuwe ni. Pàa warifuwe yan ma wo tiyagala ke gona tɔnyaara ti na mari tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Yɛnŋɛlɛ cɛnsaga paraga go ki kankanŋgagala ke ni fuun, naa loŋgo ki kankanŋgagala ke ni pàa ke gbegele tuguyɛnrɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Yaara nda pàa tɛgɛ ma Yɛnŋɛlɛ cɛnsaga paraga go ki gbegele, ko ŋga yɔn finliwɛ sɛnrɛ ti yɛn ma yɔnlɔgɔ ma tɛgɛ wa ki ni, pàa ti jiri yɛgɛ ŋga na ki ŋga: Levi setirige piile poro pàa ti jiri ma yala Moyisi wi sɛnyoro ti ni. Saraga wɔfɔArɔn wi pinambyɔ Itamari wo wìla pye na pe yɛgɛ sinni. ");
INSERT INTO dyi_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Uri pinambyɔ Bezaleyɛli ŋa wìla yiri wa Zhuda cɛnlɛ li ni, a wì si ŋga Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan ki ni fuun ki pye. Uri to wo lawi ŋa Huri. ");
INSERT INTO dyi_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ahisamaki pinambyɔ Oholiyabu wo wìla wi saga. Oholiyabu wìla pye Dan cɛnlɛ woo. Wìla pye na yaara tɛni, na kapyɔ tunndo fɔnndɔ jatere taa nari gbegele; wìla pye na paara ti sɔgɔ lɛn jese ŋgbaan ni, naa ŋganra jese, naa kondoro jese konaa jese yɛɛn kpanyi ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tɛ ŋa fuun Izirayɛli woolo pàa yirige ma kan yarikanra, a pè cɛnsaga paraga go ki tunndo ti ni fuun ti pye, wìla pye culo waga kele (1 000), ma yala pe maa taanla yaraga ŋga ni wa cɛnsaga paraga go ki jatere wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Izirayɛli woolo mbele pàa jiri, warifuwe ŋa pàa wɔ, wìla pye na kee culo waga taanri naa cɛnmɛ kaŋgurugo yeri (3 500), ma yala pe maa taanla yaraga ŋga ni wa cɛnsaga paraga go ki jatere wi ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ki warifuwe yɔn ŋga kì naga, leele mbele pàa jiri, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛfɛnnɛ pe ni, pe ni fuun nuŋgba nuŋgba pàa wɔwɔ warifuwe giramu kaŋgurugo kaŋgurugo, ma yala pe maa taanla yaraga ŋga ni wa Yɛnŋɛlɛ cɛnsaga paraga go ki jatere wi ni. Leele mbele pàa jiri, pàa pye lere waga cɛnmɛ kɔgɔlɔni ma yiri taanri naa cɛnmɛ kaŋgurugo naa nafa shyɛn ma yiri kɛ (603 550). ");
INSERT INTO dyi_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Wa ki warifuwe wi ni pàa culo waga taanri naa cɛnmɛ tijɛrɛ naa nafa (3 420) tɛgɛ ma cɛnsaga paraga go ki tiyagala ke nɔgɔna cɛnyaara cɛnmɛ ti gbegele, naa paraga ŋga pe ma pɔ ma go ki kɔn shyɛn ki tiyagala ke nɔgɔna cɛnyaara ti ni. Tiyagala ke nɔgɔna cɛnyaraga nuŋgba nuŋgba pyew pàa ki gbegele warifuwe culo nafa ma yiri kɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Culo nafa ŋa wìla koro, a pè si wo tɛgɛ ma kandɔɔlɔ yaŋgala ke gbegele, naa paara yanŋgakanŋgagala ŋgele ke ma tiyagala ke yigiyigi wa ke sɔgɔwɔ ke ni, konaa tiyagala ke gona tɔnyaara ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Tuguyɛnrɛ nda Izirayɛli woolo pàa yirige ma kan Yawe Yɛnŋɛlɛ li yeri tìla pye na kee culo waga shyɛn naa cɛnmɛ kaŋgurugo (2 500) yeri. ");
INSERT INTO dyi_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Pàa ki tuguyɛnrɛ ti tɛgɛ ma filisaga paraga go yeyɔngɔ tiyagala ke nɔgɔna cɛnyaara ti gbegele, naa saraga wɔsaga ŋga ki yɛn tuguyɛnrɛ wogo ko naa ki mɛrɛ ti ni, naa ki tunŋgo pyeyaara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Loŋgo ki jasa tiyagala ke nɔgɔna cɛnyaara pàa ti gbegele tuguyɛnrɛ ni, naa ki yeyɔngɔ tiyagala ke nɔgɔna cɛnyaara ti ni, konaa Yɛnŋɛlɛ cɛnsaga paraga go ki kankanŋgagala ke ni fuun ke ni. ");
INSERT INTO dyi_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Yaripɔrɔ nda pe yaa le mbaa tunŋgo piin wa cɛnsaga paraga go ki ni, pàa ti ti ŋganra jese ni, naa kondoro jese ni, naa jese yɛɛn kpanyi ni, konaa ma yaripɔrɔ gbegele Arɔn wi kan nda tìla tɛgɛ ti yɛ Yɛnŋɛlɛ kan, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","A pè si efɔdi wi gbegele tɛ jese ni, naa ŋganra jese, naa kondoro jese, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan ni. ");
INSERT INTO dyi_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","A pè si tɛ gbɔn paparapa maa pye fɛgɛfɛgɛ maa walagi walagi maa pye tɛ maŋgala, mɛɛ koro naa ŋganra jese wi ni, naa kondoro jese, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan wi ni, ke jɔjɔ ke yɛɛ ni; kapyɔ jɛnfɛnnɛ pàa ki tunŋgo ki pye. ");
INSERT INTO dyi_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Pàa pajogo maŋgala shyɛn yɔli efɔdi wi na maa yinrɛ shyɛn ti kan ti yɛɛ na. ");
INSERT INTO dyi_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Kurusijara ŋa wìla pye ma kan efɔdi wi na, wo naa efɔdi wi ni ti gbegelelɔmɔ pìla pye nuŋgba. Pàa wi gbegele fun tɛ maŋgala ni, naa ŋganra jese ni, naa kondoro jese ni, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan ni; paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","A pè si ɔnikisi sinndɛɛrɛ shyɛn tɛ mari maramara wa tɛ wi nawa. Pàa Izirayɛli pinambiile pe mɛrɛ ti keregi keregi wa ti na, paa yɛgɛ ŋga na pe ma mɛgɛ ki tɛgɛrɛ tɛgɛyaraga ki keregi keregi we. ");
INSERT INTO dyi_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","A pè siri maramara efɔdi wi pajogo maŋgala ke na, a tila nandowo kaan Izirayɛli setirige piile pe wogo ki na, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Kona, a kapyɔ jɛnfɛnnɛ pè si yaripɔgɔ ŋga pe ma le ma wa kotogo na ki ti tɛ maŋgala ni, naa ŋganra jese, naa kondoro jese, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan ni. Pàa ki ti paa yɛgɛ ŋga na pàa efɔdi wi gbegele. ");
INSERT INTO dyi_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Pàa ki kuru maga taga ki yɛɛ na, ki kɛyɛn tijɛrɛ yìla pye ma yala. Ki titɔnlɔwɔ pìla pye siwiri nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","A pè si sinndɛɛrɛ sɔnŋgbanga woro maramara ki na kologo tijɛrɛ. Kologo koŋgbanŋga ki woro tìla pye sariduwani, naa topazi konaa emerodi. ");
INSERT INTO dyi_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Kologo shyɛn wogo ki woro tìla pye ɛsikaribukili, naa safiri konaa lulu. ");
INSERT INTO dyi_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Kologo taanri wogo ki woro tìla pye opali, naa agati konaa ametisiti. ");
INSERT INTO dyi_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Kologo tijɛrɛ wogo ki woro tìla pye kirizoliti, naa ɔnikisi konaa zhasipi. Pàa ki sinndɛɛrɛ ti ni fuun ti maramara tɛ nawa. ");
INSERT INTO dyi_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Sinndɛɛrɛ tìla pye kɛ ma yiri shyɛn ma yala Izirayɛli pinambiile pe mɛrɛ ti ni. Ki cɛngɛlɛ kɛ ma yiri shyɛn ke ni, cɛnlɛ nuŋgba nuŋgba pyew li mɛgɛ kìla pye ma keregi keregi sinndɛlɛgɛ nuŋgba na, paa yɛgɛ ŋga na pe ma mɛgɛ ki tɛgɛrɛ tɛgɛyaraga ki keregi keregi we. ");
INSERT INTO dyi_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Pàa tɛ piiri gbɔn ma yɔngɔwɔ shyɛn gbegele paa yɛgɛ ŋga na pe ma mana pili we, maa le yaripɔgɔ ŋga pe ma le ma wa kotogo na ki na. ");
INSERT INTO dyi_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Pàa tɛ piile shyɛn gbɔn, mbele pe yaa sinndɛɛrɛ sɔnŋgbanga woro ti maramara wa pe nawa, konaa ma tɛ ŋgereye shyɛn gbegele mayi kankan wa yaripɔgɔ ŋga pe ma le ma wa kotogo na ki yinrɛ shyɛn ti na. ");
INSERT INTO dyi_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","A pè si tɛ yɔngɔwɔ shyɛn pi pɔ wa tɛ ŋgereye shyɛn yi na, wa yaripɔgɔ ŋga pe ma le ma wa kotogo na ki yinrɛ shyɛn ti na. ");
INSERT INTO dyi_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Tɛ piile mbele pè sinndɛɛrɛ sɔnŋgbanga woro ti maramara wa pe nawa, a pè si tɛ yɔngɔwɔ shyɛn pi yinrɛ shyɛn sannda ti pɔpɔ wa pe na, wa efɔdi wi pajogo maŋgala ke na, jaŋgo yaripɔgɔ ŋga pe ma le ma wa kotogo na ki pye wa yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","A pè si tɛ ŋgereye ya yɛgɛ gbegele shyɛn mayi to wa yaripɔgɔ ŋga pe ma le ma wa kotogo na ki na, wa ki nɔgɔna yinrɛ shyɛn ti na, wa ki yɛgɛ ŋga ki yɛn ma mara efɔdi wi na ki na. ");
INSERT INTO dyi_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","A pè si tɛ ŋgereye ya yɛgɛ gbegele shyɛn, mayi to wa efɔdi wi pajogo maŋgala shyɛn ke nɔgɔ, wa yɛgɛ kɛɛ ki na, ke yɔlikologo ki tanla, kurusijara ŋa wi yaa tɛgɛ mbe efɔdi wi pɔ ki go na. ");
INSERT INTO dyi_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","A pè si yaripɔgɔ ŋga pe ma le ma wa kotogo na ki tɛ ŋgereye yi pɔ efɔdi wi tɛ ŋgereye yi na ŋganra mana ni; jaŋgo yaripɔgɔ ŋga pe ma le ma wa kotogo na ki pye kurusijara ŋa wi yaa tɛgɛ mbe efɔdi wi pɔ wi go na, wiga ka sanga mbe laga wa efɔdi wi na; paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Kona, deritɔnlɔgɔ ŋga Arɔn wi yaa la efɔdi wi nii ki go na, a pè sigi gbegele ŋganra jese ni. ");
INSERT INTO dyi_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Pàa ki yɔlɔgɔ ki wɔ wa ki nandogomɔ, ma mana ŋgbanla taga wa ki yɔn na maga yɔn kaw paa yɛgɛ ŋga na pe ma sɛlɛgɛ derege yɔlɔgɔ yɔn ki ti we. ");
INSERT INTO dyi_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Pàa girenadi tige pire yanlɛrɛ gbegele ŋganra jese, naa kondoro jese yɛɛn, naa jese yɛɛn kpanyi konaa lɛn jese ŋgbaan ni, mari toto wa deritɔnlɔgɔ ki nɔgɔna yɔn ki na maga maga, maga fili. ");
INSERT INTO dyi_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Pàa keŋgeŋgele gbegele tɛ piiri ni ma ke toto wa deritɔnlɔgɔ ki nɔgɔna yɔn ki na, wa girenadi tige pire yanlɛrɛ ti sɔgɔwɔ pi ni maga maga, maga fili. ");
INSERT INTO dyi_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Pàa girenadi tige pige yanlɛgɛ nuŋgba to, ma keŋgenɛ nuŋgba to; pàa ti toto deritɔnlɔgɔ ki yɔn na ma maga maga, maga fili; mbaa tunŋgo piin ki ni, paa yɛgɛ ŋga Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","A pè si bunduye ti lɛn jese ŋgbaan ni Arɔn naa wi pinambiile pe kan; ");
INSERT INTO dyi_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","naa lɛn jese gbɔgɔwɔ njala na pe yinri turiban li ni, naa lɛn jese njagala ni konaa lɛn jese kurusiile weŋgele ni. ");
INSERT INTO dyi_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Pàa kurusijara wi ti maa sɔgɔ lɛn jese ŋgbaan ni, naa ŋganra jese, naa kondoro jese konaa jese yɛɛn kpanyi ni; paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","A pè si tɛ piiri gbɔn paparapa, maga pye fereyaraga kpoyi, maga keregi keregi wi na, paa yɛgɛ ŋga na pe ma mɛgɛ ki tɛgɛrɛ tɛgɛyaraga ki keregi keregi we, ma yo fɔ: «MA PYE KPOYI YAWE YƐNŊƐLƐ LI KAN.» ");
INSERT INTO dyi_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","A pè sigi tɛ paparapa wi pɔ ŋganra mana ni wa gbɔgɔwɔ njala li na, wa li yɛgɛ, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Anmɛ Izirayɛli woolo pàa Yɛnŋɛlɛ cɛnsaga paraga go, ko ŋga ki yɛn filisaga paraga go ki tunndo ti ni fuun ti pye mari kɔ. Pàa tunŋgo ki ni fuun ki pye cɛ paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Pàa pan Yɛnŋɛlɛ cɛnsaga paraga go ko naa ki yaara ti ni fuun ti ni Moyisi wi kan. To ti yɛn ki kandɔɔlɔ yaŋgala, naa ki go kantire, naa ki tipaara, naa ki tiyagala konaa tiyagala ke nɔgɔna cɛnyaara ti ni; ");
INSERT INTO dyi_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","naa ki gona tɔnparaga ŋga pàa gbegele simbapɛnɛ sɛɛrɛ nda pàa le kondoro ti ni, naa ki tɔnparaga ŋga pàa gbegele sɛɛrɛ liire ni ki ni, naa paraga ŋga pe yaa pɔ mbe Yɛnŋɛlɛ cɛnsaga paraga go ki kɔn shyɛn ki ni; ");
INSERT INTO dyi_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","naa yɔn finliwɛ sɛnrɛ kɛsu wi ni, naa wi kasulugo pyesaga ŋga ki yɛn wi yaritɔnŋgɔ ki ni, naa wi lɛkanŋgagala ke ni, ");
INSERT INTO dyi_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","naa tabali wi ni, naa wi tunŋgo pyeyaara ti ni konaa buru ŋa pe ma kan Yɛnŋɛlɛ yeri wi ni, ");
INSERT INTO dyi_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","naa fitanladaga ŋa pàa gbegele tɛ piiri ni wi ni, naa wi fitanlaye pe ni, naa wi tunŋgo pyeyaara ti ni, naa fitanla sinmɛ pi ni, ");
INSERT INTO dyi_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","naa saraga wɔsaga ŋga pàa gbegele tɛ ni ki ni, naa sinmɛ kpoyi pi ni, naa wusuna nuwɔ taan wi ni konaa filisaga paraga go ki yeyɔngɔ tɔnparaga ki ni; ");
INSERT INTO dyi_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","naa saraga wɔsaga ŋga pàa gbegele tuguyɛnrɛ ni ki ni, naa ki tuguyɛnrɛ mɛrɛ ti ni, naa ki lɛkanŋgagala ke ni, naa ki tunŋgo pyeyaara ti ni fuun ti ni, naa jogoyaraga konaa ki tatɛgɛ ki ni; ");
INSERT INTO dyi_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","naa loŋgo ki jasa paara titɔɔnrɔ ti ni, naa ki tiyagala ke ni, naa tiyagala ke nɔgɔna cɛnyaara ti ni, naa loŋgo ki yeyɔngɔ tɔnparaga ki ni, naa ki manda naa ki kankanŋgagala ke ni konaa yaara nda fuun pe yaa la tunŋgo piin ti ni wa cɛnsaga paraga go, ko ŋga ki yɛn filisaga paraga go ti ni; ");
INSERT INTO dyi_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","naa yaripɔrɔ nda pe yaa la nii mbaa tunŋgo piin wa laga kpoyi ki ni ti ni, naa saraga wɔfɔ Arɔn wi yaripɔrɔ nda ti yɛn ma tɛgɛ ti yɛ ti ni, konaa wi pinambiile pe woro ti ni, to nda pe yaa la nii mbaa saraga wɔgɔtunŋgo ki piin we. ");
INSERT INTO dyi_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Izirayɛli woolo pàa ki tunndo nda ti ni fuun ti pye ma yala Yawe Yɛnŋɛlɛ làa sɛnrɛ nda yo Moyisi wi kan ti ni. ");
INSERT INTO dyi_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","A Moyisi wì si tunndo ti ni fuun ti wele ma sigi yan pàa ti pye ma yala ŋga Yawe Yɛnŋɛlɛ làa yo ki ni. Kona, a wì si duwaw pye Izirayɛli woolo pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kona, a Yawe Yɛnŋɛlɛ li si para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Yɛlɛ li yeŋge koŋgbanŋga ki pilige koŋgbanŋga ki ni, ma yaa ka Yɛnŋɛlɛ cɛnsaga paraga go ki kan, ko ŋga ki yɛn filisaga paraga go ye. ");
INSERT INTO dyi_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ma yaa Yɔn finliwɛ sɛnrɛ kɛsu wi tɛgɛ wa paraga go ki ni, wa paraga ŋga ki yaa pɔ mbege kɔn shyɛn ki puŋgo na, jaŋgo paga kaa wi yaan. ");
INSERT INTO dyi_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ma pan tabali wi ni, naa wi yaara nda ti daga mbe taga wi na ti ni mari gbɛgɛlɛ wa wi na. Ma pan fitanladaga wi ni ma fitanlaye pe gbɛgɛlɛ ma pe mu. ");
INSERT INTO dyi_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Saraga wɔsaga ŋga pè gbegele tɛ ni mbaa wusuna nuwɔ taan wi sori wa ki na, ma yaa ki tɛgɛ wa yɔn finliwɛ sɛnrɛ kɛsu wi yɛgɛ sɔgɔwɔ. Ma yaa cɛnsaga paraga go ki yeyɔngɔ tɔnparaga ki pɔ wa yeyɔngɔ ki na. ");
INSERT INTO dyi_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Saara sogoworo ti ma sogo saraga wɔsaga ŋga na, maga tɛgɛ wa laga nawa Yɛnŋɛlɛ cɛnsaga paraga go ki yɔn na, ko ŋga ki yɛn filisaga paraga go ye. ");
INSERT INTO dyi_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ma jogoyaraga ki tɛgɛ wa laga nawa filisaga paraga go konaa saraga wɔsaga ti sɔgɔwɔ pi ni, ma tɔnmɔ le wa ki ni. ");
INSERT INTO dyi_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ma loŋgo ki jasa wi kan maga paara ti kan ki na maga fili, mɛɛ jasa wi yeyɔngɔ tɔnparaga ki pɔ wa yeyɔngɔ ki na. ");
INSERT INTO dyi_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Sinmɛ mba pe ma wo yaraga na mbege wɔ Yɛnŋɛlɛ kan, ma pa wo na cɛnsaga paraga go ki na, mbe pinlɛ ki nawa yaara ti ni fuun ti ni. Maga le na kɛɛ naa ki tunŋgo pyeyaara ti ni fuun ti ni; pa ki yaa pye kpoyi. ");
INSERT INTO dyi_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Saara sogoworo ti ma sogo saraga wɔsaga ŋga na, ma sinmɛ pa wo ki na, naa ki tunŋgo pyeyaara ti ni fuun ti na, maga le na kɛɛ, pa ki yaa pye jɛŋgɛ kpoyi. ");
INSERT INTO dyi_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ma sinmɛ kpoyi wo fun jogoyaraga konaa ki tatɛgɛ ki na maga le na kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Ma ti Arɔn naa wi pinambiile pe fulo wa filisaga paraga go ki yɔn na, ma ti pe woli wa jogoyaraga tɔnmɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ko puŋgo na, ma Arɔn wi yaripɔrɔ nda ti yɛn ma tɛgɛ ti yɛ Yɛnŋɛlɛ kan ti le wi kan, mɛɛ sinmɛ pa wo wi na maa le na kɛɛ, wila saraga wɔgɔtunŋgo piin na kan. ");
INSERT INTO dyi_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ma Arɔn wi pinambiile pe pye pe fulo wa ma tanla, ma pe bunduye pe lele pe kan. ");
INSERT INTO dyi_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ma sinmɛ pa wo pe na ma pe le na kɛɛ, paa yɛgɛ ŋga na mà pa wo pe to wi na maa le na kɛɛ we; paa saraga wɔgɔtunŋgo piin na kan. Ki sinmɛ mba ma yaa wo pe na, ki yaa saraga wɔgɔtunŋgo ki kan poro naa pe setirige piile pe yeri fɔ sanga pyew.» ");
INSERT INTO dyi_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Kona, a Moyisi wì si tanga ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni, maga pye ma. ");
INSERT INTO dyi_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Pe yiriŋgɔlɔ wa Ezhipiti tara, ki yɛlɛ shyɛn wolo li yeŋge koŋgbanŋga ki pilige koŋgbanŋga ki na, a pè si Yɛnŋɛlɛ cɛnsaga paraga go ki kan maga kɔ. ");
INSERT INTO dyi_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moyisi wìla ti a pè Yɛnŋɛlɛ cɛnsaga paraga go ki kan, maga tiyagala ke nɔgɔna cɛnyaara ti tɛgɛtɛgɛ, maga tire papara papara ti yerege yerege naa ki tiyagala ke ni. ");
INSERT INTO dyi_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Pàa paritɔnŋgɔ ki sanga maga wa Yɛnŋɛlɛ cɛnsaga paraga go ki go na, maga gona tɔnparaga ki tɛgɛ maga tɔn, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Yɔn finliwɛ sɛnrɛ tìla pye ma yɔnlɔgɔ sinndɛɛrɛ papara papara nda na, a Moyisi wì siri le wa kɛsu wi ni, maa lɛkanŋgagala ke le wi na, mɛɛ kasulugo pyesaga ŋga ki yɛn wi yaritɔnŋgɔ ki tɛgɛ maa tɔn. ");
INSERT INTO dyi_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Wìla ti a pè kari kɛsu wi ni wa Yɛnŋɛlɛ cɛnsaga paraga go ki ni, mɛɛ paraga ŋga ki yaa pɔ mbe cɛnsaga paraga go ki kɔn shyɛn ki pɔ maa yɛgɛ tɔn, jaŋgo leele paga kaa yɔn finliwɛ sɛnrɛ kɛsu wi yaan, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Wìla tabali wi tɛgɛ wa filisaga paraga go ki yɔnlɔparawa kamɛŋgɛ kɛɛ ki na, wa paraga ŋga pè pɔ ma paraga go ki kɔn shyɛn ki yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Buru ŋa pè kan Yɛnŋɛlɛ yeri, a wì suu tanli wa tabali wi na Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, paa yɛgɛ ŋga na làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Wìla fitanladaga wi tɛgɛ wa filisaga paraga go ki ni, wa ki yɔnlɔparawa kalige kɛɛ ki na, wa tabali wi yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Wìla fitanlaye pe gbɛgɛlɛ ma pe mu Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, paa yɛgɛ ŋga na làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Saraga wɔsaga ŋga pàa gbegele tɛ ni, wìla ki tɛgɛ wa filisaga paraga go ki ni, wa paraga ŋga pàa pɔ maga kɔn shyɛn ki yɛgɛ, ");
INSERT INTO dyi_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","mɛɛ wusuna nuwɔ taan wa sogo wa ki na, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Wìla Yɛnŋɛlɛ cɛnsaga paraga go ki yeyɔngɔ tɔnparaga ki pɔ wa ki yeyɔngɔ ki na; ");
INSERT INTO dyi_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","saara sogoworo ti ma sogo saraga wɔsaga ŋga na wìla ki tɛgɛ wa laga nawa wa Yɛnŋɛlɛ cɛnsaga paraga go ki yɔn na, ko ŋga ki yɛn filisaga paraga go ye; a wì si saara sogoworo naa muwɛ saara wɔ wa ki na, paa yɛgɛ ŋga Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Wìla ti a pè jogoyaraga ki tɛgɛ wa laga nawa wa filisaga paraga go konaa saraga wɔsaga ti sɔgɔwɔ pi ni, mɛɛ tɔnmɔ le wa ki ni pe yɛɛ jogowo pi mɛgɛ ni. ");
INSERT INTO dyi_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moyisi naa Arɔn, naa Arɔn wi pinambiile pe ni, pàa pe kɛyɛn naa pe tɔɔrɔ ti jogo wa pi ni. ");
INSERT INTO dyi_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Na pe kaa yiin wa filisaga paraga go ki ni sanga o sanga konaa mbaa fulo wa saraga wɔsaga ki tanla, pe ma pe yɛɛ jogo, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Wìla loŋgo ki jasa wi kan ma paara ti kankan wi na, ma cɛnsaga paraga go konaa saraga wɔsaga ti maga mari fili, ma loŋgo ki yeyɔngɔ tɔnparaga ki pɔ wa yeyɔngɔ ki na. Pa Moyisi wìla tunndo ti ni fuun ti pye mari kɔ yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kona, a kambaaga kì si pan ma filisaga paraga go ki tɔn; a Yawe Yɛnŋɛlɛ li gbɔgɔwɔ yanwa pì si pan ma Yɛnŋɛlɛ cɛnsaga paraga go ki yin. ");
INSERT INTO dyi_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ki kala na Moyisi wi sila ya mbaa yiin wa filisaga paraga go ki ni, katugu kambaaga kìla tigi ma koro wa ki go na; a Yawe Yɛnŋɛlɛ li gbɔgɔwɔ yanwa pì si Yɛnŋɛlɛ cɛnsaga paraga go ki yin. ");
INSERT INTO dyi_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Na kambaaga ki ka yiri wa paraga go ki go na sanga o sanga, Izirayɛli woolo pe ma yiri na kee. Pa pàa pye na yinrigi na tanri na kee yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Na kambaaga ki ka koro wa Yɛnŋɛlɛ cɛnsaga paraga go ki go na, pe ma koro wa pe cɛnsaga. Na ki ka yiri wa ki go na pilige ŋga ni, pe ma yiri na kee. ");
INSERT INTO dyi_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Yɔnlɔ na, Yawe Yɛnŋɛlɛ làa pye naga nari ma yo li yɛn wa Izirayɛli woolo pe sɔgɔwɔ kambaaga ni, wa Yɛnŋɛlɛ cɛnsaga paraga go ki go na. Yembinɛ kìla pye na yiin kasɔn Izirayɛli woolo pe ni fuun pe yɛgɛ sɔgɔwɔ; kìla pye na piin ma pe kondangala li ni fuun li na.");
INSERT INTO dyi_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yawe Yɛnŋɛlɛ làa koro wa filisaga paraga go ki ni ma Moyisi wi yeri ma para wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","wigi yo Izirayɛli woolo pe kan fɔ: «Ye ni, na wa kaa jaa mbe yaayogo wɔ saraga Yawe Yɛnŋɛlɛ li yeri, wi pan nɛgɛ ni, nakoma sumbyɔ nakoma sugbɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","«Na kaa pye nɛgɛ wi yaa wɔ saraga sogowogo, wi daga mbe pan napɔlɔ ni, ŋa wi yɛn jɛrɛgisaga fu, wa filisaga paraga go ki yɔn na; jaŋgo ki fɔ wi kala li Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Lerefɔ wi yaa wi kɛɛ ki taga wa yaayogo ŋga ki yaa wɔ saraga sogowogo ki go ki na; kona Yawe Yɛnŋɛlɛ li yaa yɛnlɛ ki na mboo kapere ti kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Wi yaa napɔlɔ wi kɔnli li yɛgɛ sɔgɔwɔ. Kona saraga wɔfɛnnɛ, Arɔn pinambiile wele, pe yaa kasanwa pi wɔ saraga Yawe Yɛnŋɛlɛ li yeri, mboo yanragi yanragi saraga wɔsaga ki kanŋgara ti ni fuun ti na, wa filisaga paraga go ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Lerefɔ wi yaa napɔlɔ wi sɛlɛgɛ wɔ, mboo kɔɔnlɔ kaliye kaliye. ");
INSERT INTO dyi_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Saraga wɔfɔ Arɔn wi pinambiile pe yaa kasɔn gbɛri wa saraga wɔsaga ki na, mbe kanŋgirɛ le wa ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ko puŋgo na, saraga wɔfɛnnɛ, poro mbele Arɔn wi pinambiile wele, pe yaa kara nda tì kɔɔnlɔ ti lɛ, naa go ki ni konaa yanlaga ki ni, mberi tagataga wa kanŋgirɛ ti na wa kasɔn ki ni, wa saraga wɔsaga ki go na. ");
INSERT INTO dyi_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Lara to naa saanra ti ni, ti yaa jogo tɔnmɔ ni. Kona, saraga wɔfɛnnɛ nuŋgba yaa ti ni fuun ti sogo wa saraga wɔsaga ki na. Ki yɛn saraga sogowogo, saraga ŋga pe ma sogo, ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Na lere wa kaa jaa mbe saraga sogowogo wɔ sumbyɔ nakoma sugbɔ ni, wi yaa pan simbapɔlɔ nakoma sikapɔlɔ ni, ŋa wi yɛn jɛrɛgisaga fu. ");
INSERT INTO dyi_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Wi yaa yaayogo ki kɔnli Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, wa saraga wɔsaga ki yɔnlɔparawa kamɛŋgɛ kɛɛ yeri. Kona, saraga wɔfɛnnɛ, Arɔn pinambiile wele, pe yaa ki kasanwa pi yanragi yanragi saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Lere ŋa wì pan yaayogo ki ni, wi yaa ki kɔɔnlɔ kaliye kaliye. Saraga wɔfɛnnɛ nuŋgba yaa kara nda tì kɔɔnlɔ ti lɛ naa go ki ni konaa yanlaga ki ni mberi tagataga wa kanŋgirɛ ti na wa kasɔn ki ni, wa saraga wɔsaga ki go na. ");
INSERT INTO dyi_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Yaayogo ki lara naa ki saanra ti yaa jogo tɔnmɔ ni. Saraga wɔfɔ wi yaa ti ni fuun ti wɔ saraga mberi sogo wa saraga wɔsaga ki na. Ki yɛn saraga sogowogo, saraga ŋga pe ma sogo, ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Na lere wa kaa jaa mbe sannjɛlɛ wɔ saraga sogowogo Yawe Yɛnŋɛlɛ li yeri, wi daga mbe pan ketenɛ nuŋgba nakoma jɛndɛtuwa nuŋgba ni. ");
INSERT INTO dyi_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Saraga wɔfɔ wi yaa pan sannjɛlɛ li ni wa saraga wɔsaga ki yɛgɛ, mbeli go ki kɔw mbege sogo wa saraga wɔsaga ki na; ko puŋgo na, wi yaa li kasanwa pi yiwi mboo wo wa saraga wɔsaga ki kanŋgaga ki na; ");
INSERT INTO dyi_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","mbe sili siyɔlɔgɔ ki wɔ naa ki nawa yaara ti ni, mberi wa wa saraga wɔsaga ki tanla, wa yɔnlɔ yirisaga kɛɛ yeri, wa laga ŋga pe maa cɔnrɔ ti wuun we. ");
INSERT INTO dyi_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kona saraga wɔfɔ wi yaa sannjɛlɛ li wali wa li kanwira shyɛn sɔgɔwɔ pi ni; ɛɛn fɔ, wi seli wali shyɛn mbeli laga li yɛɛ na. Ko puŋgo na, wi yaa li sogo wa kasɔn kanŋgirɛ ti na, wa saraga wɔsaga ki na. Ki yɛn saraga sogowogo, saraga ŋga pe ma sogo, ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Na lere wa kaa jaa mbe muwɛ yarikanga kan Yawe Yɛnŋɛlɛ li yeri, wi daga mbe pan muwɛ tiyɔɔn ni mba wì sinmɛ yanragi yanragi pi na, ma wusuna nuwɔ taan taga wa pi na. ");
INSERT INTO dyi_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Wi yaa pan muwɛ tiyɔɔn pi ni wa saraga wɔfɛnnɛ pe yeri, Arɔn pinambiile wele. Pe ni, nuŋgba yaa ki muwɛ tiyɔɔn mba pè sinmɛ yanragi yanragi pi na pa ko kɛɛ yɛnlɛ nuŋgba, mbe wusuna nuwɔ taan wi ni fuun wi lɛ. Wi yaa ti sogo wa saraga wɔsaga ki na ti pye paa nandowo saraga yɛn. Ki yɛn yarikanga, ŋga pe ma sogo, ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Yarikanga sanŋga ki yaa pye Arɔn naa wi pinambiile poro wogo. Ki yɛn ma tɛgɛ ki yɛ pew, ma yiri wa saara nda pe ma sogo Yawe Yɛnŋɛlɛ li kan ti ni. ");
INSERT INTO dyi_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«Na lere wa ka pan muwɛ yarikanga ni ŋga pè fɔ yira ni, ki daga mbe pye gato ŋa leve si ye wi ni, a pè sinmɛ pinlɛ wi muwɛ tiyɔɔn pi ni maa gbɔn, nakoma ki pye wɔn ŋa leve si ye wi ni, a pè sinmɛ yanragi yanragi wi na. ");
INSERT INTO dyi_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«Na ki ka pye yarikanga ki yɛn muwɛ yarikanga ŋga pe ma kala wɔn taala ni, pe yaa sinmɛ pinlɛ ki muwɛ tiyɔɔn pi ni mboo gbɔn, paga ka leve le pi ni. ");
INSERT INTO dyi_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Pe yaa yarikanga ki kaari kporokporo mbe sinmɛ wo ti na mberi pye muwɛ saraga. ");
INSERT INTO dyi_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«Na ki ka pye yarikanga ki yɛn muwɛ yarikanga ŋga pe ma kala tugurɔn sikalaga ni, ki daga mbe gbegele muwɛ tiyɔɔn ni, pe sinmɛ pinlɛ pi ni. ");
INSERT INTO dyi_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","«Na ki yarikanga ki ka gbegele mbe kɔ ki yaara ti ni, wi yaa pan ki ni Yawe Yɛnŋɛlɛ li kan, mbege kan saraga wɔfɔ wi yeri. Wo yaa kari ki ni wa saraga wɔsaga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Saraga wɔfɔ wi yaa ka wɔ wa yarikanga ki ni mbege sogo wa saraga wɔsaga ki na, ko yaa pye paa nandowo saraga yɛn. Ki yɛn saraga ŋga pe ma sogo, ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Yarikanga sanŋga ki yaa pye Arɔn naa wi pinambiile poro wogo. Ki wogo ki yɛn ma tɛgɛ ki yɛ pew, ma yiri wa saara nda pe ma wɔ Yawe Yɛnŋɛlɛ li yeri ma sogo ti ni. ");
INSERT INTO dyi_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«Muwɛ yarikanga ŋga fuun pe yaa pan mbe wɔ Yawe Yɛnŋɛlɛ li yeri, paga ka leve le ka ni. Katugu pe se ka leve nakoma sɛnrɛgɛ wɔ saraga li yeri mbege sogo. ");
INSERT INTO dyi_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ye mbe ya pan leve naa sɛnrɛgɛ ki ni Yawe Yɛnŋɛlɛ li kan paa ye yarilire fɔnndɔ koŋgbannda yɛn. Ɛɛn fɔ, ye se kari sogo wa saraga wɔsaga ki na paa saraga ŋga ki nuwɔ pi yɛn mali ndanla we. ");
INSERT INTO dyi_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","«Muwɛ saraga ŋga fuun ye yaa wɔ li yeri, ye kɔ taga ki na. Yaga kaga pye sambalawa ni mbe ka yaga kɔ fu; katugu yɔn finliwɛ mba Yɛnŋɛlɛ lì le ye ni, kɔ wo wi yɛn pi kacɛn we. Ko kala na ye daga mbaa kɔ tari wa ye muwɛ saara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«Na ye kaa jaa mbe ye yarilire fɔnndɔ koŋgbannda muwɛ saraga ki wɔ Yawe Yɛnŋɛlɛ li yeri, ki daga mbe pye sheshegele koŋgbanŋgala ŋgele pè ke pire ti kala, mari sun ti muwɛ po pa. Po ye yaa wɔ mbe pye ye yarilire fɔnndɔ koŋgbannda ti muwɛ saraga ye. ");
INSERT INTO dyi_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ye yaa sinmɛ wo pi na, mbe wusuna nuwɔ taan taga wa pi na; ki yɛn muwɛ yarikanga. ");
INSERT INTO dyi_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Saraga wɔfɔ wi yaa pa wɔ wa ki muwɛ pi ni, naa sinmɛ ni, konaa wusuna nuwɔ taan wi ni fuun wi ni, mberi sogo paa nandowo saraga yɛn. Ki yɛn yarikanga ŋga pe ma sogo, ma pye Yawe Yɛnŋɛlɛ li wogo. ");
INSERT INTO dyi_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Na lere wa kaa jaa mbe nayinmɛ saraga wɔ nɛgɛ ni Yawe Yɛnŋɛlɛ li yeri, na kaa pye napɔlɔ nakoma nanɔ wi, wi daga mbe pye jɛrɛgisaga fu. ");
INSERT INTO dyi_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ki lerefɔ wi yaa wi kɛɛ ki taga wa yaayogo ki go ki na, mbege kɔnli wa filisaga paraga go ki yɔn na. Saraga wɔfɛnnɛ, Arɔn pinambiile wele, pe yaa ki kasanwa pi yanragi yanragi saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Wa ki nayinmɛ saraga ki ni, wi yaa ta wɔ wa mberi kan Yawe Yɛnŋɛlɛ li yeri, mberi sogo. To ti yɛn yanlaga ŋga ki ma lara ti tɔn, mbe pinlɛ ŋga ki ma mara lara ti na ki ni, ");
INSERT INTO dyi_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","naa jinŋgele shyɛn koro naa ke yanlaga ki ni, ko ŋga ki ma pye ma mara sɛnnɛ li na we, naa yiripɔlɔ wi ni, poo pinlɛ poo laga jinŋgele ke ni. ");
INSERT INTO dyi_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Arɔn wi pinambiile pe yaa ki woro ti sogo wa saraga wɔsaga ki na, saraga sogowogo ŋga pè taga makɔ wa kasɔn kanŋgirɛ ti na, wa ki go na. Ki yɛn saraga ŋga pe ma sogo, ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Na kaa pye sumbyɔ nakoma sugbɔ lerefɔ wì pan mbe wɔ nayinmɛ saraga Yawe Yɛnŋɛlɛ li yeri, ki yaayogo ki daga mbe pye naŋa nakoma jɛlɛ, mbe pye jɛrɛgisaga fu. ");
INSERT INTO dyi_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Na kaa pye sumbyɔ wi yaa wɔ saraga, wi yaa pan wi ni laga Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Wi yaa wi kɛɛ ki taga wa yaayogo ki go ki na, mbe sigi kɔnli wa filisaga paraga go ki yɛgɛ. Saraga wɔfɛnnɛ, Arɔn pinambiile wele, pe yaa ki kasanwa pi yanragi yanragi wa saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Wa ki nayinmɛ saraga ki ni, wi yaa yanlaga lara ti wɔ saraga Yawe Yɛnŋɛlɛ li yeri mberi sogo: to ti yɛn yanlaga ŋga ki ma lara ti tɔn, naa naga ki ni fuun ki ni, wigi kɔn wigi mara wa nafigo ki na, naa yanlaga ŋga ki ma mara lara ti na ki ni, ");
INSERT INTO dyi_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","naa jinŋgele shyɛn koro naa ke yanlaga ki ni, ko ŋga ki ma pye ma mara sɛnnɛ li na we, naa yiripɔlɔ wi ni, wi yaa wi laga mbe pinlɛ jinŋgele ke ni. ");
INSERT INTO dyi_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Saraga wɔfɔ wi yaa ki woro ti sogo wa saraga wɔsaga ki na. Ti yɛn yaakara nda pe ma wɔ saraga mberi sogo Yawe Yɛnŋɛlɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Na kaa pye sugbɔ lerefɔ wi yaa wɔ saraga, wi yaa pan wi ni laga Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Wi yaa wi kɛɛ ki taga wa yaayogo ki go ki na, mbe sigi kɔnli wa filisaga paraga go ki yɛgɛ. Saraga wɔfɛnnɛ, Arɔn pinambiile wele, pe yaa ki kasanwa pi yanragi yanragi wa saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Yanlaga ŋga ki ma lara ti tɔn konaa ŋga fuun ki yɛn ma mara ti na, wi yaa ki wɔ saraga Yawe Yɛnŋɛlɛ li yeri mbege sogo; ");
INSERT INTO dyi_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","naa jinŋgele shyɛn koro naa ke yanlaga ki ni, ko ŋga ki ma pye ma mara sɛnnɛ li na we, konaa yiripɔlɔ wi ni; wi yaa wi laga mboo pinlɛ jinŋgele ke ni. ");
INSERT INTO dyi_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Saraga wɔfɔ wi yaa ki woro ti sogo wa saraga wɔsaga ki na. Ti yɛn yaakara nda pe ma sogo, ti nuwɔ pi yɛn ma tanla. «Yanlaga ki ni fuun ki yɛn Yawe Yɛnŋɛlɛ lo wogo. ");
INSERT INTO dyi_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ki yɛn ŋgasele na li yɛn kɔsaga fu yoro naa ye setirige piile mbele fuun pe yaa ka yiri puŋgo na ye kan; yaga ka sa cɛn laga o laga, ye se yanlaga ka nakoma kasanwa.» ");
INSERT INTO dyi_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","wigi yo Izirayɛli woolo pe kan fɔ: «Na lere wa ka kapege pye, na wi sigi siligi, mbe kala na li woro pyewolo la pye, mbe Yawe Yɛnŋɛlɛ li ŋgasegele la jɔgɔ, ŋga wi daga mbe pye ki ŋga: ");
INSERT INTO dyi_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«Na kiga pye saraga wɔfɛnnɛ to ŋa pè sinmɛ kpoyi wo wi na maa wɔ wo wì kapege ki pye ma ti, a jɔlɔgɔ to leele pe ni fuun pe na, wi yaa napɔlɔ yirifɔnŋɔ ŋa wi yɛn jɛrɛgisaga fu wa wɔ saraga Yawe Yɛnŋɛlɛ li yeri, kapege ŋga wì pye ki kala na. ");
INSERT INTO dyi_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Wi yaa pan napɔlɔ yirifɔnŋɔ wi ni wa filisaga paraga go ki yɔn na Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mboo kɛɛ ki taga wa yaayogo ki go ki na, mbe sigi kɔnli le Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Saraga wɔfɛnnɛ to ŋa pè sinmɛ kpoyi wo wi na, wi yaa yaayogo ki kasanwa pa lɛ mbe ye pi ni wa filisaga paraga go ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Wi yaa wi yombɛlɛ nuŋgba le wa kasanwa pi ni, mboo yanragi yanragisaga kɔlɔshyɛn wa paraga ŋga pè pɔ ma cɛnsaga paraga go ki kɔn shyɛn ki na, Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Wusuna nuwɔ taan wi ma sogo saraga wɔsaga ŋga na, saraga wɔfɛnnɛ to wi yaa kasanwa pa fafa wa ki yɛnŋgɛlɛ ke na, wa filisaga paraga go ki ni, Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. Saara sogoworo ti ma sogo saraga wɔsaga ŋga na, wi kasanwa sanmba pi ni fuun pi wo wa ki tatɛgɛ ki na, ko ŋga ki yɛn wa filisaga paraga go ki yɔn na we. ");
INSERT INTO dyi_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ko puŋgo na, napɔlɔ ŋa wì wɔ mbe kapere ti kala yagawa ja, wi yaa wi yanlaga ki ni fuun ki laga, ŋga fuun ki ma lara ti tɔn konaa ŋga fuun ki ma mara ti na ki ni, ");
INSERT INTO dyi_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","naa jinŋgele shyɛn koro naa ke yanlaga ki ni, ko ŋga ki ma pye ma mara sɛnnɛ li na we, naa yiripɔlɔ wi ni, wi yaa wi laga mbe pinlɛ jinŋgele ke ni. ");
INSERT INTO dyi_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ye yaa ki woro ti wɔ wa napɔlɔ wi ni paa yɛgɛ ŋga na pe mari wɔ wa nayinmɛ saraga yaayogo ki ni we. Saraga wɔfɛnnɛ to wi yaa ti sogo wa saara sogoworo ti ma sogo saraga wɔsaga ŋga na ki na. ");
INSERT INTO dyi_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ɛɛn fɔ, napɔlɔ wi sɛlɛgɛ ko na, naa wi kara sannda ti ni fuun, naa wi go, naa wi saanra, naa wi lara konaa wi fire ti ni, ");
INSERT INTO dyi_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ko kɔrɔ wo yɛn napɔlɔ wi kara sannda pyew, saraga wɔfɛnnɛ to wi yaa ti lɛ mbe kari ti ni wa laga ŋga pe maa cɔnrɔ ti wuun, wa paara yinrɛ cɛnsaga ki puŋgo na, wa laga ŋga ki yɛn fyɔngɔ fu Yɛnŋɛlɛ yɛgɛ na ka ni. Wi yaa sari sogo kasɔn kanŋgirɛ ni, wa laga ŋga pe maa cɔnrɔ ti wuun we. ");
INSERT INTO dyi_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«Na kaa pye Izirayɛli gbogolomɔ woolo pe ni fuun poro pè kapege ki pye pe sigi siligi, mbe kala na li woro pyewolo la pye, mbe Yawe Yɛnŋɛlɛ li ŋgasegele la jɔgɔ, pe yɛn kapege pyefɛnnɛ, ali mbege ta pe sigi jɛn o. ");
INSERT INTO dyi_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Na paga kaga jɛn mbe yo pè kapege pye, pe yaa napɔlɔ yirifɔnŋɔ wɔ saraga mbe kapere kala yagawa ja. Pe yaa kari wi ni wa filisaga paraga go ki yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Izirayɛli gbogolomɔ pi lelɛɛlɛ pe ni fuun pe yaa pe kɛyɛn yi tagataga wa napɔlɔ wi go ki na, kona nuŋgba mbe suu kɔnli le Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Saraga wɔfɛnnɛ to ŋa pè sinmɛ kpoyi wo wi na wi yaa napɔlɔ wi kasanwa pa lɛ mbe ye pi ni wa filisaga paraga go ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Wi yaa wi yombɛlɛ nuŋgba le wa kasanwa pi ni mboo yanragi yanragisaga kɔlɔshyɛn wa paraga ŋga pè pɔ ma cɛnsaga paraga go ki kɔn shyɛn ki na, Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Wi yaa kasanwa pa fafa fun saraga wɔsaga ki yɛnŋgɛlɛ ke na Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, wa filisaga paraga go ki ni. Saara sogoworo ti ma sogo saraga wɔsaga ŋga na, wi yaa kasanwa sanmba pi ni fuun pi wo wa ki tatɛgɛ ki na, ko ŋga ki yɛn wa filisaga paraga go ki yɔn na we. ");
INSERT INTO dyi_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ko puŋgo na, wi yaa yanlaga ki ni fuun ki laga mbege sogo wa saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Napɔlɔ ŋa wì wɔ ma wi yɛɛra kapere ti kala yagawa ja, wùu pye yɛgɛ ŋga na, wi yaa ŋa wi pye ma fun. Wi yaa kapere ti kala yagawa ja kapyege ki pye pe kan. Pa kona pe kapere ti yaa kala yaga pe na. ");
INSERT INTO dyi_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Wi yaa kari ki napɔlɔ wi ni wa paara yinrɛ cɛnsaga ki puŋgo na, mbe saa sogo paa yɛgɛ ŋga na napɔlɔ koŋgbanŋa wi daga mbe sogo we. Ko ki yɛn saraga ŋga ki yaa wɔ mbe Izirayɛli woolo pe kapere ti kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«Na kaa pye Izirayɛli woolo teele wo wa wì kapege pye, wi sigi siligi, ma kala na li woro pyewolo la pye, mbe Yawe Yɛnŋɛlɛ, wi Yɛnŋɛlɛ li ŋgasegele la jɔgɔ, wi yɛn kapege pyefɔ. ");
INSERT INTO dyi_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Na wiga kaga jɛn mbe yo wì kapege pye, wi yaa sikapɔlɔ ŋa wi yɛn jɛrɛgisaga fu wa wɔ saraga, wi kapege ŋga wì pye ki kala na. ");
INSERT INTO dyi_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Wi yaa wi kɛɛ ki taga wa sikapɔlɔ wi go ki na, yaayoro nda pe maa woo saara sogoworo pe maa ti kɔnlɔgi laga ŋga na, mbe saa kɔnli wa, Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. Ki yɛn saraga ŋga pe ma wɔ mbe kapere kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Saraga wɔfɛnnɛ to wi yaa yaayogo ki kasanwa pa lɛ wi yombɛlɛ nuŋgba ni, saara sogoworo ti ma sogo saraga wɔsaga ŋga na, mboo fafa wa ki yɛnŋgɛlɛ ke na; ko puŋgo na, wi yaa kasanwa sanmba pi wo wa ki saraga wɔsaga nuŋgba ki tatɛgɛ ki na. ");
INSERT INTO dyi_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Wi yaa yanlaga ki ni fuun ki sogo wa saraga wɔsaga ki na paa yɛgɛ ŋga na wi daga mbe nayinmɛ saraga ki sogo we. Pa saraga wɔfɔ wi yaa kapere ti kala yagawa ja kapyege ki pye yɛɛn ŋa wi yɛn to wi kan, kona wi kapere ti yaa kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«Na kaa pye Izirayɛli woo wa yɛgɛ wì kapege pye, wi sigi siligi, mbe kala na li woro pyewolo la pye, mbe Yawe Yɛnŋɛlɛ li ŋgasegele la jɔgɔ, wi yɛn kapege pyefɔ. ");
INSERT INTO dyi_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Na wiga kaga jɛn mbe yo wì kapege pye, wi yaa sikanɔ wɔ saraga, ŋa wi yɛn jɛrɛgisaga fu, wi kapege ŋga wì pye ki kala na. ");
INSERT INTO dyi_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Wi yaa wi kɛɛ ki taga wa yaayogo ki go ki na, yaayoro nda pe maa woo saara sogoworo pe maa ti kɔnlɔgi laga ŋga na, mbege kɔnli wa. ");
INSERT INTO dyi_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Saraga wɔfɛnnɛ to wi yaa yaayogo ki kasanwa pa lɛ wi yombɛlɛ nuŋgba ni, saara sogoworo ti ma sogo saraga wɔsaga ŋga na, mboo fafa wa ki yɛnŋgɛlɛ ke na; mbe si kasanwa sanmba pi ni fuun pi wo wa ki saraga wɔsaga nuŋgba ki tatɛgɛ ki na. ");
INSERT INTO dyi_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Wi yaa yanlaga ki ni fuun ki laga paa yɛgɛ ŋga na pe ma nayinmɛ saraga wogo ki laga, mbe sigi sogo wa saraga wɔsaga ki na, jaŋgo ki nuwɔ taan pi Yawe Yɛnŋɛlɛ li ndanla. Wi yaa kapere ti kala yagawa ja kapyege pye ki lerefɔ wi kan. Pa wi kapere ti yaa kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«Na kaa pye sumbyɔ lerefɔ wila jaa mbe wɔ saraga wi kapege ki kala na, wi daga mbe pan simbanɔ ni, ŋa wi yɛn jɛrɛgisaga fu. ");
INSERT INTO dyi_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Yaayogo ŋga wi yaa wɔ saraga mbe kapere ti kala yagawa ja, wi yaa wi kɛɛ ki taga wa ki go ki na, yaayoro nda pe maa woo saara sogoworo pe maa ti kɔnlɔgi laga ŋga na, mbege kɔnli wa. ");
INSERT INTO dyi_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Saraga wɔfɛnnɛ to wi yaa yaayogo kasanwa pa lɛ wi yombɛlɛ nuŋgba ni, saara sogoworo ti ma sogo saraga wɔsaga ŋga na, mboo fafa wa ki yɛnŋgɛlɛ ke na; mbe si kasanwa sanmba pi ni fuun pi wo wa ki saraga wɔsaga nuŋgba ki tatɛgɛ ki na. ");
INSERT INTO dyi_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Wi yaa yanlaga ki ni fuun ki laga paa yɛgɛ ŋga na sumbapyɔ ŋa wi yɛn nayinmɛ saraga pe maa wogo ki laga we; ko puŋgo na, wi yaa ki sogo wa saraga wɔsaga ki na, saara sogoworo ti go na, to nda pe ma sogo Yawe Yɛnŋɛlɛ li kan we. Pa saraga wɔfɔ wi yaa kapere ti kala yagawa ja kapyege ki pye yɛɛn ki lerefɔ wi kan; pa wi kapere ti yaa kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«Na paga lere wa yeri mbe yo wi sa sɛrɛya yo kiti kɔnkala la na, ŋga wì jɛn wa ki kala li ni konaa ŋga wì logo, wi ka je mbe yo wi sege yo, ki yɛn kapege wi go na. ");
INSERT INTO dyi_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«Na lere wa ka jiri yaraga ŋga ki yɛn fyɔngɔ ni Yɛnŋɛlɛ yɛgɛ na ka na, kana ki pye yanyaraga ŋga ki yɛn fyɔngɔ ni ko ka kugo na, nakoma yaayogo ko ka kugo na, nakoma yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele ke maa fulolo lara na lo la kugo na, wo jate wi yaa pye fyɔngɔ ni, mboo kapege ki go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","«Na wiga jiri lere wa fyɔngɔ cɛnlɛ o cɛnlɛ na, na li mbe ya lere tɛgɛ fyɔngɔ ni, wii sigi jɛn, na wiga kaga jɛn sanga ŋa ni, wi yaa pye fyɔngɔ ni mboo kapege ki go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«Na lere wa kaa para mbe fo mbe wugu mbe yo wi yaa kala la pye kapege konɔ, nakoma kajɛŋgɛ konɔ, na wii jatere pye ki na, ki wuguro ti yɛn yɛgɛ o yɛgɛ, na wiga kaga jɛn sanga ŋa ni, ki yaa pye kapege wi go na. ");
INSERT INTO dyi_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«Ki kagala ŋgele kè naga yɛɛn, na lere wa ka puŋgo la na, wi daga mbe yere ki na fɔ wì kapege pye. ");
INSERT INTO dyi_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ko puŋgo na, wi yaa pan simbanɔ nakoma sikanɔ ni saraga Yawe Yɛnŋɛlɛ li kan wi kapege ŋga wì pye ki kala na, mboo wɔ saraga mbe kapere kala yagawa ja. Kona saraga wɔfɔ wi yaa kapere ti kala yagawa ja kapyege ki pye wi kan; pa wi kapere ti yaa kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«Na kaa pye lere wa se ya simbanɔ nakoma sikanɔ ta mboo wɔ saraga mbe kapege ŋga wì pye ki kala yagawa ja, wi yaa pan keteŋgele shyɛn nakoma jɛndɛtuwaye shyɛn ni Yawe Yɛnŋɛlɛ li kan. Wi yaa nuŋgba wɔ mbe kapere ti kala yagawa ja, mbe sanna li wɔ saraga sogowogo. ");
INSERT INTO dyi_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Wi yaa pan ke ni saraga wɔfɔ wi kan. Saraga wɔfɔ wi yaa keli mbe na li yaa wɔ mbe kapere ti kala yagawa ja li wɔ saraga gbɛn. Wi yaa li kɔnli wi yombɛkɔrɔgɔ ki ni wa li kɔnɔ li tanla; ɛɛn fɔ, wi se li go ki kɔw mbege wɔ wa. ");
INSERT INTO dyi_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ko puŋgo na, saraga ŋga kì wɔ mbe kapere ti kala yagawa ja, wi yaa ki kasanwa pi yanragi yanragi saraga wɔsaga ki kanŋgaga ki na, mbe sa sanmba pi wo saraga wɔsaga ki tatɛgɛ ki na. Ki yɛn saraga ŋga pe ma wɔ mbe kapere kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ko puŋgo na, saraga wɔfɔ wi yaa sannjɛlɛ shyɛn wolo li wɔ saraga sogowogo, mbe yala ki wɔlɔmɔ pi ni. Kona, wi yaa kapere ti kala yagawa ja kapyege ki pye ki lerefɔ wi kan. Pa wi kapere ti yaa kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«Na kaa pye wi se ya keteŋgele shyɛn nakoma jɛndɛtuwaye shyɛn ta, wi yaa pan muwɛ tiyɔɔn culo taanri ni wi kapege ki kala na, mboo wɔ saraga mbe kapere ti kala yagawa ja. Ɛɛn fɔ, wiga ka sinmɛ pinlɛ pi ni, wiga si ka wusuna nuwɔ taan taga wa pi na, katugu ki yɛn saraga ŋga pe ma wɔ mbe kapere ti kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Wi yaa pan muwɛ pi ni saraga wɔfɔ wi kan. Saraga wɔfɔ wi yaa pa ko kɛɛ yɛnlɛ nuŋgba, po mbe pye nandowo saraga, mboo sogo wa saraga wɔsaga ki na saara sogoworo ti go na, to nda pe ma sogo Yawe Yɛnŋɛlɛ li kan we. Ki yɛn saraga ŋga pe ma wɔ mbe kapere kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Kapege ŋga lerefɔ wì pye wa ki kagala ŋgele kè naga la ni, saraga wɔfɔ wi yaa kapere ti kala yagawa ja kapyege ki pye wi kan ki kala na. Pa wi kapere ti yaa kala yaga wi na. «Saraga muwɛ sanmba pi yaa pye saraga wɔfɔ wi woo paa yarikanga yɛn.» ");
INSERT INTO dyi_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Yaara nda tì tɛgɛ ti yɛ Yawe Yɛnŋɛlɛ li kan, na lere wa ka kapege pye ti wogo na, na wi sigi siligi, wi yaa pan simbapɔlɔ ni saraga, ŋa wi yɛn jɛrɛgisaga fu, mbe yiri wi ni wa wi simbaŋgbelege ki ni Yawe Yɛnŋɛlɛ li kan, mboo kajɔɔgɔ ki gbegele. Ma yaa simbapɔlɔ wi sɔnŋgɔ ki naga warifuwe pyɔ yɔn na, mbe yala cɛnsaga paraga go ki warifuwe pyɔ nuŋgba nuguwɔ pi ni. Simbapɔlɔ wi yaa pye saraga mbe kajɔɔgɔ ki gbegele. ");
INSERT INTO dyi_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Lerefɔ wì kapege ki pye yaara nda wogo na ma jɔgɔ cɛnsaga paraga go ki na, wi daga mberi sara, mbe nuru mbe sara ŋa wì kan wi walisaga kaŋgurugo wogo taga wa wi na, mberi kan saraga wɔfɔ wi yeri. Simbapɔlɔ ŋa wi yaa wɔ mbe kajɔɔgɔ ki gbegele, saraga wɔfɔ wi yaa wi wɔ saraga, mbe kapere ti kala yagawa ja kapyege ki pye lerefɔ wi kan. Pa wi kapere ti yaa kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Na lere wa ka kapege pye mbe kala na li woro pyewolo la pye Yawe Yɛnŋɛlɛ li ŋgasegele la wogo na, ali na wi sigi jɛn, ki kapege ki yaa pye wi go na. ");
INSERT INTO dyi_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Wi yaa pan simbapɔlɔ ni, ŋa wi yɛn jɛrɛgisaga fu saraga wɔfɔ wi kan, mbe yiri wi ni wa wi simbaŋgbelege ki ni. Ma yaa wi sɔnŋgɔ ki naga paa ŋa pe ma wɔ mbe kajɔɔgɔ gbegele wi wogo ki yɛn, mboo kajɔɔgɔ ki gbegele. Saraga wɔfɔ wi yaa kapere ti kala yagawa ja kapyege ki pye lerefɔ ŋa wì kapege ki pye wi sigi siligi, wii sigi jɛn wi kan. Pa wi kapere ti yaa kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ki yɛn saraga ŋga ki ma wɔ mbe kajɔɔgɔ gbegele, katugu ki lerefɔ wìla kapege pye Yawe Yɛnŋɛlɛ li na.» ");
INSERT INTO dyi_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«Na lere wa ka kapege pye mbe kambasinŋge ka pye Yawe Yɛnŋɛlɛ li yɛgɛ na, na wiga finlɛ wi lewee yɛnlɛ wa kan yaraga ŋga pè kan wi yeri wì tɛgɛ ka wogo na, nakoma ŋga wì jin nakoma ma yu ka wogo na, nakoma ŋga wì shɔ wi yeri fanŋga na ka wogo na, ");
INSERT INTO dyi_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","nakoma na wiga yaraga ŋga kì puŋgo ka yan mbe si finlɛ ki wogo na, nakoma mbe wugu mbe yagbolo li tɔn kapege ŋga fuun lere mbe ya pye ka wogo na, ");
INSERT INTO dyi_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","kona ki fɔ wì kapege pye ma pye jɔgɔfɔ. Yaraga ŋga wì yu, nakoma ŋga wì shɔ fanŋga na, nakoma yaraga ŋga pè kan wi yeri wì tɛgɛ, nakoma ŋga kì puŋgo a wì yan, wi daga mbege sɔngɔrɔ yaragafɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","Yaraga ŋga fuun wì yagbolo wuguro ti wugu ki kala na, wi yaa ki yaraga ki ni fuun ki yɔngɔ kan, mbe yaraga ki walisaga kaŋgurugo wogo taga wa ki na yaragafɔ wi kan, pilige ŋga ni wiga kaga jɛn mbe yo wi yɛn jɔgɔfɔ we. ");
INSERT INTO dyi_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Wi yaa pan simbapɔlɔ ni, ŋa wi yɛn jɛrɛgisaga fu saraga wɔfɔ wi kan, mbe yiri wi ni wa wi simbaŋgbelege ki ni, mboo wɔ saraga Yawe Yɛnŋɛlɛ li yeri mboo kajɔɔgɔ ki gbegele. Ma yaa wi sɔnŋgɔ ki naga paa ŋa pe ma wɔ mbe kajɔɔgɔ gbegele wi wogo ki yɛn. ");
INSERT INTO dyi_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Saraga wɔfɔ wi yaa kapere ti kala yagawa ja kapyege ki pye wi kan Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. Kapege ŋga wì pye, ki yɛn yɛgɛ o yɛgɛ, ki yaa kala yaga wi na.» ");
INSERT INTO dyi_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","wigi sɛnrɛ nda ti yo Arɔn naa wi pinambiile pe kan fɔ: «Ŋgasele na li yaa tɛgɛ saraga sogowogo ki wogo na li na: «Saraga sogowogo ki daga mbe koro wa saraga wɔsaga ki na yembinɛ li ni fuun li ni mbe sa gbɔn ki goto pinliwɛ ni. Kasɔn ki daga mbe koro la yiin wa saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Ki goto pinliwɛ ni, saraga wɔfɔ wi yaa wi derigbɔgɔ ŋga pè ti lɛn jese ni ki le, naa wi kurusi wenɛ na pè ti lɛn jese ni li ni. Saraga sogowogo ŋga kì sogo wa saraga wɔsaga ki na, wi yaa ki cɔnrɔ ti wɔ mberi wo le saraga wɔsaga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Ko puŋgo na, wi yaa ko yaripɔrɔ to wɔ wi yɛɛ na, mbe ta yɛgɛ le, mbe cɔnrɔ ti lɛ mbe kari wa paara yinrɛ cɛnsaga ki puŋgo na, sari wo wa laga ŋga ki yɛn fyɔngɔ fu ka ni. ");
INSERT INTO dyi_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Kasɔn ŋga wa saraga wɔsaga ki na, ki daga mbe koro la yiin, kiga ka figi. Pinliwɛ pyew, saraga wɔfɔ wi yaa kanŋgirɛ le wa kasɔn ki ni mbe saraga sogowogo ki taga wa ti na, ko puŋgo na mbe si nayinmɛ saara ti yanlaga ki sogo wa ki na. ");
INSERT INTO dyi_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Kasɔn ki daga mbe koro la yiin wa saraga wɔsaga ki na suyi, kiga ka figi. ");
INSERT INTO dyi_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","«Ŋgasele na li yaa tɛgɛ muwɛ saara ti wogo na li na: «Arɔn wi pinambiile poro pe yaa lari woo Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ wa saraga wɔsaga ki yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Saraga wɔfɛnnɛ pe ni, nuŋgba yaa saraga muwɛ tiyɔɔn pa ko kɛɛ yɛnlɛ nuŋgba, naa sinmɛ ni konaa wusuna nuwɔ taan ŋa wi ma taga yarikanga ki na wi ni fuun wi ni, to yɛn nandowo woro wa saraga ki ni. Wi yaa ti sogo wa saraga wɔsaga ki na, ko ŋga ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla we. ");
INSERT INTO dyi_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Arɔn naa wi pinambiile pe ni, muwɛ sanmba mba pì koro pe yaa pi pye pe yaakara. Pe yaa ki yaakara ti ka leve fu wa laga ŋga ki yɛn kpoyi Yɛnŋɛlɛ yɛgɛ na ka ni, wa filisaga paraga go loŋgo ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Paga ka leve pinlɛ pi ni mboo fɔ. Ki yɛn tasaga ŋga mi Yɛnŋɛlɛ mì kan pe yeri ma yiri wa saara nda pe ma wɔ na yeri ma sogo ti ni. Ki yɛn yaraga ŋga ki yɛn ma tɛgɛ ki yɛ pew na kan paa kapere ti kala yagawa jasaraga konaa kajɔɔgɔ gbegewe saraga ki yɛn. ");
INSERT INTO dyi_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Arɔn pinambiile mbele pe yɛn nambala poro pe yaa la to kaa. Ki woro ti yaa pye pe woro sanga pyew, poro naa pe setirige piile mbele fuun pe yaa ka yiri puŋgo na pe ni, mbe yiri wa saara nda ti ma sogo Yawe Yɛnŋɛlɛ li kan ti ni. Lere wa yɛgɛ ka jiri ti na, wi yaa pye kpoyi Yɛnŋɛlɛ yɛgɛ na.» ");
INSERT INTO dyi_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«Pilige ŋga ni paga sinmɛ kpoyi wo Arɔn naa wi pinambiile pe na mbe pe wɔ, saraga ŋga pe yaa wɔ Yawe Yɛnŋɛlɛ li yeri ki ŋga: Pilige pyew, muwɛ tiyɔɔn culo taanri. Pe yaa culo nuŋgba naa kɔngɔ wɔ pinliwɛ ni, mbe culo nuŋgba naa kɔngɔ sanmba pi wɔ yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Pe yaa sinmɛ pinlɛ pi ni mboo gbɔn, mbe suu kala tugurɔn sikalaga ni. Ma yaa ki wɔn wi kɔɔnlɔ kporokporo mbe pan mboo wɔ saraga, ŋga ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","«Arɔn pinambiile pe ni, ŋa pe yaa ka sinmɛ kpoyi wo wi na mboo wɔ, mboo tɛgɛ saraga wɔfɔ wa Arɔn wi yɔnlɔ, wi yaa ki saraga nuŋgba ki wɔ fun. Ki muwɛ saraga ki yaa pye Yawe Yɛnŋɛlɛ li wogo fɔ sanga pyew. Ki ni fuun ki yaa sogo mbe kɔ li kan. ");
INSERT INTO dyi_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Muwɛ saraga ŋga fuun saraga wɔfɔ wi yaa wɔ, ki daga mbe sogo pew Yawe Yɛnŋɛlɛ li kan, paga ka ka ka.» ");
INSERT INTO dyi_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","wigi yo Arɔn naa wi pinambiile pe kan fɔ: «Ŋgasele na li yaa tɛgɛ kapere ti kala yagawa jasaraga wogo ki na li na: «Yaayogo ŋga ki yaa wɔ mbe kapere ti kala yagawa ja, ki yaa kɔnli Yawe Yɛnŋɛlɛ li yɛgɛ na, wa laga ŋga yaayoro nda pe maa woo saara sogoworo pe maa ti kɔnlɔgi we. Ki yɛn yaraga ŋga ki yɛn ma tɛgɛ ki yɛ pew Yɛnŋɛlɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Saraga wɔfɔ ŋa wi yaa kapere ti kala yagawa jasaraga ki wɔ, wo wi yaa ki ka wa laga ŋga ki yɛn kpoyi ka ni, wa filisaga paraga go loŋgo ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Lere o lere ka jiri ki saraga kara ti na, wi yaa pye kpoyi. Na ki kasanwa pa ka janri mbe wo yaripɔgɔ na, pì janri ma wo laga ŋga na, pe yaa ki jogo laga kpoyi ka ni. ");
INSERT INTO dyi_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Na paga saraga kara ti sɔgɔ cɔgɔ ŋga ni, ki cɔgɔ ki daga mbe yaari ti sɔgɔŋgɔlɔ. Na paga ti sɔgɔ tuguyɛnrɛ cɔgɔ ni, pege jogo jɛŋgɛ, pege sunlu tɔnmɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Saraga wɔfɔ wi go woolo mbele fuun pe yɛn nambala, poro pe yaa ki kara ti ka. Ti yɛn yaraga ŋga ki yɛn ma tɛgɛ ki yɛ Yɛnŋɛlɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ɛɛn fɔ, kapere ti kala yagawa jasaraga ŋga pe ma ye ki kasanwa pa ni wa filisaga paraga go ki ni, mbe kapere ti kala yagawa ja kapyege ki pye wa cɛnsaga paraga go ki ni, ki kara ta si daga mbe ka. Ti yaa sogo wa kasɔn ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«Saraga ŋga ki ma wɔ mbe kajɔɔgɔ gbegele ki ŋgasele li na: «Ki yɛn yaraga ŋga ki yɛn ma tɛgɛ ki yɛ Yɛnŋɛlɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Yaayogo ŋga ki yaa wɔ kajɔɔgɔ gbegele saraga, yaayoro nda pe maa woo saara sogoworo pe maa ti kɔnlɔgi laga ŋga na, pa pe yaa ki kɔnli wa. Ko puŋgo na, pe yaa ki kasanwa pi yanragi yanragi saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Pe yaa yanlaga ki ni fuun ki wɔ saraga, naa ki naga ki ni, naa yanlaga ŋga ki ma lara ti tɔn ki ni, ");
INSERT INTO dyi_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","naa ki jinŋgele shyɛn koro naa ke yanlaga ki ni, ko ŋga ki ma pye ma mara sɛnnɛ li na we, naa yiripɔlɔ wi ni, pe yaa wi pinlɛ mboo laga jinŋgele shyɛn ke ni. ");
INSERT INTO dyi_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Saraga wɔfɔ wi yaa ti ni fuun ti sogo wa saraga wɔsaga ki na. Ki yɛn kajɔɔgɔ gbegewe saraga ŋga pe ma sogo Yawe Yɛnŋɛlɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Saraga wɔfɛnnɛ pe piile mbele pe yɛn nambala pe mbe ya mbege kara ta ka. Ɛɛn fɔ, pe yaa ti ka laga kpoyi ka ni. Ti yɛn yaraga ŋga ki yɛn ma tɛgɛ ki yɛ pew Yɛnŋɛlɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ŋgasele nuŋgba lo lì tɛgɛ kapere kala yagawa jasaraga konaa kajɔɔgɔ gbegewe saraga ti wogo ki na. Saraga wɔfɔ ŋa wi yaa kapere ti kala yagawa ja kapyege ki pye, yaayogo ki kara ti yaa pye wo woro. ");
INSERT INTO dyi_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","«Na saraga wɔfɔ wa ka saraga sogowogo wɔ lere wa kan, yaayogo ŋga pè wɔ saraga ki sɛlɛgɛ ki yaa pye ki saraga wɔfɔ wi wogo. ");
INSERT INTO dyi_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Saraga wɔfɔ wa ka lere wa muwɛ saraga wɔ, na paga ki fɔ yira ni wi o, nakoma paga ki kala wɔn taala ni o, nakoma tugurɔn sikalaga ni o, ki yaa pye saraga wɔfɔ wi wogo. ");
INSERT INTO dyi_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ɛɛn fɔ, muwɛ saara nda fuun pè sinmɛ pinlɛ ti ni mari gbɔn nakoma ti yɛn sinmɛ fu, to yaa pye Arɔn piile mbele pe yɛn nambala pe ni fuun pe woro, wa se wɔ wa ni. ");
INSERT INTO dyi_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«Nayinmɛ saara nda pe yaa la woo Yawe Yɛnŋɛlɛ li yeri, ŋgasele na lì tɛgɛ ti wogo ki na li na: ");
INSERT INTO dyi_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","«Na lere wa kaa nayinmɛ saraga woo Yawe Yɛnŋɛlɛ li yeri mbeli shari, wi yaa pan leve fu gato ni, ŋa pè gbɔn sinmɛ ni mboo taga wa nayinmɛ saraga ki na, naa leve fu wɔn ni, ŋa pè sinmɛ yanragi yanragi wi na, naa gato ni, ŋa pè muwɛ tiyɔɔn tɛgɛ maa gbɔn, ma sinmɛ pinlɛ pi ni. ");
INSERT INTO dyi_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Wi yaa buru ŋa leve yɛn wi ni wa taga wa wi nayinmɛ saraga ki na, ko ŋga wìla woo mbeli shari we. ");
INSERT INTO dyi_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Pe yaa buru nuŋgba nuŋgba lagala ki saara ti ni fuun nuŋgba nuŋgba ti na, mberi wɔ saraga Yawe Yɛnŋɛlɛ li yeri. Ki woro ti yaa pye saraga wɔfɔ ŋa wì nayinmɛ saraga yaayogo ki kasanwa pi yanragi yanragi wi woro. ");
INSERT INTO dyi_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Na wiga nayinmɛ saraga ki wɔ pilige ŋga ni mbeli shari, pe yaayogo ki kara ti ka ki pilige nuŋgba ki ni, paga ka ta yaga ti wɔnlɔ ti yiri. ");
INSERT INTO dyi_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«Na ki fɔ wi saraga kiga pye saraga ŋga pe ma wɔ mbe yɔn fɔlɔ tɔn, nakoma nayinmɛ yarikanga, pe yaa yaayogo ki kara ta ka pilige ŋga pè saraga ki wɔ ki ni, ti sannda ti yaa koro ki goto. ");
INSERT INTO dyi_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Na saraga kara ta ka koro sa gbɔn pilige taanri wogo ki na, peri sogo. ");
INSERT INTO dyi_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ɛɛn fɔ, na paga ki nayinmɛ saraga kara ta ka pilige taanri wogo ki na, ŋa wì saraga ki wɔ wi saraga ki se yigi, ki se si jate saraga; katugu ki kara ti yaa kanŋga fyɔngɔ yaraga. Lere ŋa ka ta ka, ki yaa pye kapege wi go na. ");
INSERT INTO dyi_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Na kara tiga jiri yaraga ŋga ki yɛn fyɔngɔ ni ka na, yaga ka ki kara ti ka, yeri sogo. «Lere ŋa fuun wi yɛn kpoyi, wo wi mbe ya mbege nayinmɛ saraga ŋga pè wɔ ki kara ta ka. ");
INSERT INTO dyi_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Nayinmɛ saraga kara nda ti yɛn Yawe Yɛnŋɛlɛ li woro, na lere wa ka ta ka mbege ta wi yɛn fyɔngɔ ni, wi daga poo purɔ poo wɔ wi woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Na lere wa ka jiri yaraga ŋga ki yɛn fyɔngɔ ni ka na, nakoma lere ŋa wi yɛn fyɔngɔ ni wa na, nakoma yaayogo ŋga ki yɛn fyɔngɔ ni ka na, mbe si nayinmɛ saraga kara ta ka, to nda pe wɔ Yawe Yɛnŋɛlɛ li yeri, wi daga poo purɔ poo wɔ wi woolo pe sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","wigi yo Izirayɛli woolo pe kan fɔ: «Yaga ka nɛgɛ yanlaga, nakoma sumbyɔ yanlaga nakoma sugbɔ yanlaga ka. ");
INSERT INTO dyi_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Yaayogo ŋga ka ku ki yɛ nakoma yaayogo ŋga cɛngɛ gbo, yaga ka ki yanlaga ka ka; ɛɛn fɔ, ye mbe ya kala la yɛgɛ pye ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Yaayogo ŋga pe ma wɔ saraga Yawe Yɛnŋɛlɛ li yeri mbe sogo kasɔn ni, na lere ŋa ka ki yanlaga ka ka, wi daga poo purɔ poo wɔ wi woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Yaga sa cɛn laga o laga, ye se ka kasanwa ka, sannjɛlɛ kasanwa nakoma yaayogo kasanwa. ");
INSERT INTO dyi_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Lere o lere ka kasanwa ka, pi yɛn yiŋgi kasanwa o, wi daga poo purɔ poo wɔ wi woolo pe sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","wigi yo Izirayɛli woolo pe kan naa fɔ: «Na lere wa ka nayinmɛ saraga wɔ Yawe Yɛnŋɛlɛ li yeri, wi daga mbeli tasaga wɔ wa wi nayinmɛ saraga ki ni mbege kan li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Wo jate wi yaa pan Yawe Yɛnŋɛlɛ li tasaga ki ni wi yɛ, ko ŋga ki yaa sogo we. To ti yɛn yanlaga konaa yaayogo ki ndige ye. Wi yaa ndige ki lɛ mbege yirige mbege kan saraga Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Saraga wɔfɔ wi yaa yanlaga ki sogo wa saraga wɔsaga ki na. Ndige ko na, ko yaa pye Arɔn naa wi pinambiile pe wogo. ");
INSERT INTO dyi_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ye yaa la ye nayinmɛ saara yaayoro ti kalige jegele ke kaan saraga wɔfɔ wi yeri paa yarikanga yɛn. ");
INSERT INTO dyi_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Arɔn wi pinambiile pe ni, ŋa wi yaa nayinmɛ saraga yaayogo ki kasanwa naa ki yanlaga ti wɔ wa saraga wɔsaga ki na, yaayogo ki kalige jele lo li yaa pye wi tasaga. ");
INSERT INTO dyi_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ndige ŋga pe ma yirige ma kan saraga ko naa jele li ni, mì mari shɔ Izirayɛli woolo pe yeri mbe yiri wa pe nayinmɛ saara ti ni, mberi kan saraga wɔfɔ Arɔn wo naa wi pinambiile pe yeri. Ki yɛn ŋgasele na li yɛn kɔsaga fu yoro Izirayɛli woolo ye kan.» ");
INSERT INTO dyi_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ki woro ti yɛn Arɔn naa wi pinambiile pe tasaga mbe yiri wa saara nda pe ma wɔ Yawe Yɛnŋɛlɛ li yeri mberi sogo ti ni, mbege lɛ pilige ŋga ni paga sinmɛ kpoyi wo pe na mbe pe wɔ paa saraga wɔmɔ tunŋgo ki piin li kan we. ");
INSERT INTO dyi_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ki woro nda to Yawe Yɛnŋɛlɛ làa yo Izirayɛli woolo paa kaan saraga wɔfɛnnɛ pe yeri, pilige ŋga ni paga sinmɛ kpoyi wo pe na mbe pe wɔ we. Ki ŋgasele na li yɛn kɔsaga fu pe setirige piile mbele fuun pe yaa ka yiri pe kan. ");
INSERT INTO dyi_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ki ŋgasegele ŋgele yɛɛn koro kè tɛgɛ saraga sogowogo ki na, naa muwɛ saraga wogo ki na, naa kapere kala yagawa jasaraga wogo ki na, naa kajɔɔgɔ gbegewe saraga wogo ki na, naa mbe lere wɔ mboo tɛgɛ tunŋgo na konaa nayinmɛ saraga wogo ki na. ");
INSERT INTO dyi_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Yawe Yɛnŋɛlɛ làa ki tunŋgo ki kan Moyisi wi yeri wa Sinayi yanwiga ki na, pilige ŋga ni làa ki konɔ kan Izirayɛli woolo pe yeri ma yo paa paan pe yarikanra ti ni li kan wa Sinayi gbinri wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Arɔn naa wi pinambiile pe yeri wa filisaga paraga go ki yɔn na. Yaripɔrɔ nda tì tɛgɛ ti yɛ mbaa saraga wɔgɔtunŋgo piin, ma ti pe pan ti ni, naa sinmɛ kpoyi pi ni, naa napɔlɔ wi ni, ŋa pe yaa wɔ mbe kapere ti kala yagawa ja, naa simbapɛnɛ shyɛn pe ni konaa leve fu buru wi yɛn kanjapige ŋga ni ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ma Izirayɛli gbogolomɔ woolo pe ni fuun pe yeri ma pe gbogolo wa filisaga paraga go ki yɔn na.» ");
INSERT INTO dyi_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","A Moyisi wì si ŋga Yawe Yɛnŋɛlɛ làa yo wi kan ki pye, ma Izirayɛli gbogolomɔ woolo pe yeri ma pe gbogolo wa filisaga paraga go ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Sɛnrɛ nda Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan, a wì siri yo Izirayɛli gbogolomɔ woolo pe kan. ");
INSERT INTO dyi_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ko puŋgo na, a Moyisi wi si ti a Arɔn naa wi pinambiile pè pan, a wì si pe pye a pè woli. ");
INSERT INTO dyi_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","A wì si bundu wi le Arɔn wi kan, ma kurusijara ŋa wi yɛn wi na wi pɔ wi kan, ma deritɔnlɔgɔ ki le wi kan konaa ma efɔdi wi le wi kan maa taga wa, mɛɛ kurusijara ŋa wi ma pye efɔdi wi na wi pɔ wa puŋgo na. ");
INSERT INTO dyi_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","A wì si yaripɔgɔ ŋga pe ma le ma wa kotogo na ki le wi kan, mɛɛ yaara nda pe yinri Urimu naa Tumimu ti le wa ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","A wì si gbɔgɔwɔ njala li kan wi kan, ma tɛ paparapa wi pɔ wa gbɔgɔwɔ njala li yɛgɛ, wo wi yɛn jara ŋa wi yɛn kpoyi, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan. ");
INSERT INTO dyi_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","A Moyisi wì si sinmɛ mba pe ma wo yaraga na mbege wɔ pi lɛ ma pa yanragi yanragi cɛnsaga paraga go konaa ki nawa yaara ti ni fuun ti na, maga tɛgɛ ki yɛ Yɛnŋɛlɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","A wì si pa yanragi yanragi saraga wɔsaga ki na yanragisaga kɔlɔshyɛn, naa ki tunŋgo pyeyaara ti ni fuun ti na, naa jogoyaraga konaa ki tatɛgɛ ki na mari tɛgɛ ti yɛ Yɛnŋɛlɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","A wì si sinmɛ mba pe ma wo yaraga na mbege wɔ pa wo wa Arɔn wi go ki na fun, maa pye kpoyi Yɛnŋɛlɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ko puŋgo na, a wì si Arɔn wi pinambiile pe pye a pè fulo wa wi tanla, mɛɛ pe bunduye pe lele pe kan, kurusijaraye mbele pe yɛn pe na ma pe pɔpɔ pe kan, mɛɛ pe njagala ke kankan pe kan paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Napɔlɔ ŋa pe yaa wɔ saraga mbe kapere ti kala yagawa ja, a wì si ti a pè pan wi ni wa wi tanla. A Arɔn naa wi pinambiile pè si pe kɛyɛn yi tagataga wa napɔlɔ wi go ki na. ");
INSERT INTO dyi_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","A Moyisi wì si napɔlɔ wi kɔnli mɛɛ wi kasanwa pa lɛ maa fafa wa saraga wɔsaga ki yɛnŋgɛlɛ ke na wi yombɛlɛ nuŋgba ni, maga pye kpoyi. Ko puŋgo na, a wì si kasanwa sanmba pi wo wa saraga wɔsaga ki tatɛgɛ ki na. Pa wìla saraga wɔsaga ki le Yɛnŋɛlɛ kɛɛ yɛɛn, jaŋgo paa kapere ti kala yagawa ja kapyege ki piin wa ki na. ");
INSERT INTO dyi_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","A Moyisi wì si yanlaga ŋga fuun ki yɛn ma napɔlɔ wi lara ti tɔn ki laga, naa yiripɔlɔ wi ni, naa jinŋgele shyɛn koro naa ke yanlaga ki ni, mari sogo wa saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ɛɛn fɔ, napɔlɔ wi kara sannda nda tìla koro: wi sɛlɛgɛ, naa wi kara konaa wi fire ti ni, wìla saa ti sogo wa paara yinrɛ cɛnsaga ki puŋgo na, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ko puŋgo na, a wì si ti, a pè pan simbapɔlɔ ŋa pe yaa pye saraga sogowoo wi ni. A Arɔn naa wi pinambiile pè si pe kɛyɛn yi tagataga wa simbapɔlɔ wi go ki na. ");
INSERT INTO dyi_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","A Moyisi wì si simbapɔlɔ wi kɔnli, mɛɛ wi kasanwa pi yanragi saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","A wì si simbapɔlɔ wi kɔɔnlɔ kaliye kaliye, mɛɛ wi go, naa kara nda tì kɔɔnlɔ konaa wi yanlaga ki ni ti sogo. ");
INSERT INTO dyi_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","A wì si simbapɔlɔ wi lara naa wi saanra ti jogo, mɛɛ ti sogo ma pinlɛ wi kara sannda ti ni wa saraga wɔsaga ki na. Ki yɛn saraga sogowogo, ŋga pe ma sogo, ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla, paa yɛgɛ ŋga na làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ko puŋgo na, a wì si ti a pè pan simbapɔlɔ shyɛn woo wi ni, ŋa pe yaa wɔ saraga mbe saraga wɔfɛnnɛ pe tɛgɛ tunŋgo ki na. A Arɔn naa wi pinambiile pè si pe kɛyɛn yi tagataga wa wi go ki na. ");
INSERT INTO dyi_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","A Moyisi wì si simbapɔlɔ wi kɔnli mɛɛ wi kasanwa pa lɛ maa fa wa Arɔn wi kalige nuŋgbolo li na, wa laga ŋga pe ma nuŋgbolo li furu, ma pa fa wa wi kalige kɛɛ yombɛgbɔgɔ ki na, konaa wi kalige tɔlɔgɔ yombɛgbɔgɔ ki na. ");
INSERT INTO dyi_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","A Moyisi wì si ti a Arɔn wi pinambiile pè fulo wi tanla, a wì si kasanwa pa fafa pe kalige nuŋgbogolo ke na, wa laga ŋga pe ma nuŋgbolo li furu, ma pa fafa wa pe kalige kɛyɛn yombɛgbɔrɔ ti na konaa pe kalige tɔɔrɔ yombɛgbɔrɔ ti na; kona, a wì si kasanwa sanmba pi yanragi yanragi wa saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","A Moyisi wì si simbapɔlɔ wi yanlaga ki lɛ, naa wi naga ki ni, naa yanlaga ŋga fuun ki ma lara ti tɔn ki ni, naa yiripɔlɔ wi ni, naa jinŋgele shyɛn koro naa ke yanlaga ki ni, konaa kalige jele li ni. ");
INSERT INTO dyi_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Leve fu buru wi yɛn kanjapige ŋga ni ma tɛgɛ wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, a wì si leve fu gato pyɔ nuŋgba wɔ wa ki ni, naa gato ŋa pè wa sinmɛ ni wi pyɔ nuŋgba ni, konaa wɔn pyɔ nuŋgba ni, mɛɛ ti taga wa yanlaga konaa kalige jele li na. ");
INSERT INTO dyi_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","A wì si ti ni fuun ti le Arɔn naa wi pinambiile pe kɛɛ, mɛɛ pe pye ma yo peri yirige peri kan saraga Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ko puŋgo na, a Moyisi wì siri shɔ pe kɛɛ mari sogo wa saraga wɔsaga ki na, wa saara sogoworo ti go na. Ki yɛn saraga ŋga pe ma wɔ mbe lere tɛgɛ tunŋgo na, pe maga sogo, ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","A Moyisi wì si simbapɔlɔ wi ndige ki lɛ maga yirige maga kan saraga Yawe Yɛnŋɛlɛ li yeri. Ki ndige kìla pye Moyisi wo tasaga ma yiri wa saraga wɔfɛnnɛ pe tɛgɛwɛ simbapɔlɔ wi ni, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ko puŋgo na, a Moyisi wì si sinmɛ mba pe ma wo yaraga na mbege wɔ pa lɛ, konaa kasanwa mba wa saraga wɔsaga ki na pa ni, maa yanragi yanragi Arɔn wo naa wi yaripɔrɔ ti na, ma pa yanragi yanragi wi pinambiile poro naa pe yaripɔrɔ ti na. Kì pye ma, pa wìla Arɔn naa wi yaripɔrɔ konaa wi pinambiile poro naa pe yaripɔrɔ ti ni pe pye kpoyi yɛɛn Yɛnŋɛlɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","A Moyisi wì sigi yo Arɔn wo naa wi pinambiile pe kan fɔ: «Ye simbapɔlɔ shyɛn woo wi kara ti sɔgɔ wa filisaga paraga go ki yɔn na. Ye kara ti ka wa ki laga ki na, mbe pinlɛ pè ye tɛgɛ tunŋgo ki na buru ŋa ni wi ni, wo ŋa wi yɛn wa kanjapige ki ni, paa yɛgɛ ŋga na mìla ki yo ye kan we. ");
INSERT INTO dyi_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kara to naa buru wi ni, yaga ka, nda ka koro, yeri sogo. ");
INSERT INTO dyi_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ye yaa koro wa filisaga paraga go ki yɔn na fɔ sa gbɔn piliye kɔlɔshyɛn, ki piliye yan pe yaa ye tɛgɛ tunŋgo ki na fɔ yi yɔn ki sa tin; katugu pe yaa ye tɛgɛ ye tunŋgo ki na piliye kɔlɔshyɛn ni. ");
INSERT INTO dyi_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Yawe Yɛnŋɛlɛ lo lì yo ki pye paa yɛgɛ ŋga na wège pye nala we, jaŋgo ye kapere ti kala mbe yaga ye na. ");
INSERT INTO dyi_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ye koro wa filisaga paraga go ki yɔn na, yɔnlɔ naa yembinɛ, fɔ sa gbɔn piliye kɔlɔshyɛn, jaŋgo Yawe Yɛnŋɛlɛ lì sɛnrɛ nda yo, yeri yɔn fili, nakoma ye yaa ku. Tunŋgo ŋga Yawe Yɛnŋɛlɛ lì yo na kan koyi yɛɛn». ");
INSERT INTO dyi_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ŋga Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan ma yo wìgi yo Arɔn naa wi pinambiile pe kan, a pè si tanga ma yala ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Pilige kɔlɔtaanri wogo ki na, a Moyisi wì si Arɔn naa wi pinambiile pe yeri, naa Izirayɛlilelɛɛlɛ pe ni; ");
INSERT INTO dyi_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","mɛɛ Arɔn wi pye fɔ: «Napɔlɔ yirifɔnŋɔ nuŋgba ja maa pye kapere ti kala yagawa jasaraga, konaa simbapɔlɔ nuŋgba ni, ma wo pye saraga sogowogo. Pe ni fuun shyɛn pe pye jɛrɛgisaga fu. Ma pe wɔ saraga Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ko puŋgo na, maga yo Izirayɛli woolo pe kan fɔ pe pan sikapɔlɔ nuŋgba ni mboo wɔ saraga mbe kapere ti kala yagawa ja, naa simbapɔlɔ yirifɔnŋɔ nuŋgba konaa napɔlɔ yirifɔnŋɔ nuŋgba, mbele pè ta yɛlɛ nuŋgba nuŋgba, ma pye jɛrɛgisaga fu; poro yaa pye saraga sogowogo. ");
INSERT INTO dyi_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Pe pan napɔlɔ nuŋgba naa simbapɔlɔ nuŋgba ni, mbe pe wɔ nayinmɛ saraga Yawe Yɛnŋɛlɛ li yeri. Pe muwɛ saraga taga pe na, mba pè sinmɛ pinlɛ pi ni; katugu Yawe Yɛnŋɛlɛ li yaa li yɛɛ naga ye na nala.» ");
INSERT INTO dyi_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Yaara nda fuun Moyisi wìla naga, a pè si pan ti ni wa filisaga paraga go ki yɔn na. A Izirayɛli gbogolomɔ woolo pe ni fuun pè si pan ma yere le Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","A Moyisi wì sho fɔ: «Ye wele, ŋga Yawe Yɛnŋɛlɛ lì yo ye pye, yege pye, pa li gbɔgɔwɔ yanwa pi yaa pi yɛɛ naga ye na.» ");
INSERT INTO dyi_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Kona, a Moyisi wì si Arɔn wi pye fɔ: «Fulo wa saraga wɔsaga ki tanla, mɔɔ kapere ti kala yagawa jasaraga ki wɔ, naa saraga sogowogo ki ni. Ma kapere ti kala yagawa ja kapyege pye ma yɛɛ kan konaa maga pye leele pe kan. Ko puŋgo na, mɛɛ leele pe saara ti wɔ pe kan, ma kapere ti kala yagawa ja kapyege ki pye pe kan fun, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ lìgi yo we.» ");
INSERT INTO dyi_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","A Arɔn wì si fulo wa saraga wɔsaga ki tanla mɛɛ napɔlɔ yirifɔnŋɔ ŋa wi yaa wɔ mboo yɛɛra kapere ti kala yagawa ja wi kɔnli. ");
INSERT INTO dyi_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","A wi pinambiile pè si yaayogo ki kasanwa pi kan wi yeri. A wì suu yombɛlɛ li le wa pi ni maa fafa saraga wɔsaga ki yɛnŋgɛlɛ ke na, mɛɛ sanmba pi wo wa saraga wɔsaga ki nɔgɔna tatɛgɛ ki na. ");
INSERT INTO dyi_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A wì si yaayogo ki yanlaga, naa ki jinŋgele shyɛn koro naa ki yiripɔlɔ wi ni ti sogo wa saraga wɔsaga ki na, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ɛɛn fɔ, yaayogo ki kara naa ki sɛlɛgɛ ko na, wìla saa to sogo wa paara yinrɛ cɛnsaga ki puŋgo na. ");
INSERT INTO dyi_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","A Arɔn wì si simbapɔlɔ ŋa pè pye saraga sogowogo wi kɔnli. A wi pinambiile pè si yaayogo ki kasanwa pi kan wi yeri, a wì suu yanragi yanragi saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Yaayogo ŋga kì wɔ saraga sogowogo, a pè sigi go naa ki kara nda pè kɔɔnlɔ kaliye kaliye ti kan wi yeri; a wì siri sogo wa saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","A wì si lara to naa saanra ti jogo, mari sogo wa saraga wɔsaga ki na, wa saraga sogowogo sanŋga ki go na. ");
INSERT INTO dyi_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ko puŋgo na, a Arɔn wì si leele pe saara ti wɔ. Sikapɔlɔ ŋa wi yaa wɔ saraga mbe leele pe kapere ti kala yagawa ja, a wì suu kɔnli maa wɔ saraga mbe kapere ti kala yagawa ja, paa yɛgɛ ŋga na wìla napige saraga ki wɔ we. ");
INSERT INTO dyi_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","A wì si saraga sogowogo ki wɔ ma yala ki kakɔnndɛgɛlɛ li ni. ");
INSERT INTO dyi_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Kona, a wì si muwɛ saraga ki wɔ, mɛɛ pa ko kɛɛ yɛnlɛ nuŋgba maa sogo wa saraga wɔsaga ki na, ma taga pinliwɛ pyew saraga sogowogo ki na. ");
INSERT INTO dyi_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Napɔlɔ wo naa simbapɔlɔ ŋa leele pàa pan mbe wɔ nayinmɛ saraga, a wì si pe kɔnlɔgi. A wi pinambiile pè si yaayoro ti kasanwa pi kan wi yeri. A wì suu yanragi yanragi saraga wɔsaga ki kanŋgara ti ni fuun ti na. ");
INSERT INTO dyi_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","A pè si napɔlɔ wi yanlaga ki kan Arɔn wi yeri naa simbapɔlɔ wi wogo ki ni, naa wi naga ki ni, naa yanlaga ŋga ki ma lara ti tɔn ki ni, naa jinŋgele shyɛn ke ni konaa yiripɔlɔ wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","A pè si yanlaga ki taga wa yaayoro shyɛn ti ndire ti na; a Arɔn wì si yanlaga ki sogo wa saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Kona, a Arɔn wì si ndire to naa kalige jele li ni ti yirige mari kan saraga Yawe Yɛnŋɛlɛ li yeri, paa yɛgɛ ŋga na Moyisi wìla ki yo we. ");
INSERT INTO dyi_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Naa Arɔn wìla kaa kapere kala yagawa jasaara ti wɔ ma kɔ, naa saara sogoworo ti ni, konaa nayinmɛ saara ti ni, a wì suu kɛyɛn yi yirige ma wa leele pe yeri mɛɛ duwaw pye pe kan. Kona, a wì si tigi ma yiri wa saraga wɔsaga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","A Moyisi naa Arɔn pè si ye wa filisaga paraga go ki ni. Naa pàa kaa yiri, a pè si duwaw pye leele pe kan. Kona, a Yawe Yɛnŋɛlɛ li gbɔgɔwɔ yanwa pì si pi yɛɛ naga leele pe ni fuun pe na. ");
INSERT INTO dyi_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","A kasɔn kà si yiri wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ mɛɛ saa saara sogoworo to naa yanlaga ki sogo wa saraga wɔsaga ki na. Leele pe ni fuun pàa ki yan nɛɛ jɔrɔgi nayinmɛ ni, mɛɛ to ma pe yɛrɛ ti jiile wa tara mbe Yɛnŋɛlɛ li gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Kona, a Arɔn pinambiile shyɛn Nadabu naa Abiyu pè si pe naŋganra leyaara ti lɛ ma kasɔn naŋganra le wa, mɛɛ wusuna nuwɔ taan wo ti na. A pè si pan ki kasɔn ki ni yarikanga Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, ŋga li sila ki konɔ kan; pe sila pan ki ni mbe yala ŋga làa yo pe kan ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kona, a kasɔn kà si yiri wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ ma pe sogo ma pe gbo le li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","A Moyisi wì si Arɔn wi pye fɔ: «Ko Yawe Yɛnŋɛlɛ làa yo ye kan maga filige ma yo fɔ: Leele mbele pe maa fulo na tanla, mi yɛn kpoyi yɛgɛ ŋga na, mila jaa paa ki gbogo. Pa kona leele pe ni fuun pe yaa lanla gbogo.» A Arɔn wì si pyeri dinw. ");
INSERT INTO dyi_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","A Moyisi wì si Mishayɛli naa Elizafan pe yeri, Arɔn wi tojɛɛ Uziyɛli wo pinambiile la wɛlɛ; a wì si pe pye fɔ: «Ye pan ye ye sefɛnnɛ pe lɛ laga cɛnsaga paraga go ki tanla, ye kari pe ni wa paara yinrɛ cɛnsaga ki puŋgo na.» ");
INSERT INTO dyi_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","A pè si pan ma gboolo pe lɛ ma pe yaripɔrɔ ti yaga pe na, mɛɛ kari pe ni wa paara yinrɛ cɛnsaga ki puŋgo na, paa yɛgɛ ŋga na Moyisi wìla ki yo we. ");
INSERT INTO dyi_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Kona, a Moyisi wì si Arɔn naa wi pinambiile Eleyazari naa Itamari pe pye fɔ: «Yaga ka ye yinrɛ ti yaga sagara, yaga si ka ye yaripɔrɔ ti walagi mbege naga fɔ yaa kunwɔ gbele, jaŋgo yaga ka ku konaa mbe ti Yɛnŋɛlɛ li nawa ŋgban Izirayɛli woolo gbogolomɔ pi ni. Mbele Yawe Yɛnŋɛlɛ lì gbo kasɔn ki ni, ye ye sefɛnnɛ Izirayɛli woolo sanmbala poro yaga pe pe kunwɔ pi gbele. ");
INSERT INTO dyi_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ɛɛn fɔ, yoro wo na, yaga ka yiri wa filisaga paraga go ki yɔn na, nakoma ye yaa ku; katugu Yawe Yɛnŋɛlɛ li sinmɛ mba pe ma wo yaraga na mbege wɔ, pòo wo ye na ma ye wɔ.» A Arɔn naa wi pinambiile pe ni pè si tanga ma yala Moyisi wi sɛnrɛ ti ni. ");
INSERT INTO dyi_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Kona, a Yawe Yɛnŋɛlɛ lì si para Arɔn wi ni maa pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Mboro naa ma pinambiile pe ni, yaga ka duvɛn nakoma sinmɛ wɛlɛwɛ pa yɛgɛ wɔ, mbe si jɛn mbe ye wa filisaga paraga go ki ni, jaŋgo yaga ka ku. Ki yɛn kakɔnndɛgɛlɛ na li yɛn kɔsaga fu yoro naa ye setirige piile mbele fuun pe yaa ka yiri puŋgo na ye kan. ");
INSERT INTO dyi_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ki daga ye ya ye yaraga ŋga ki yɛn kpoyi na kan konaa ŋga ki woro kpoyi na kan ti jɛn yeri wɔ ti yɛɛ ni; ye ŋga ki yɛn fyɔngɔ ni konaa ŋga ki yɛn fyɔngɔ fu ti jɛn yeri wɔ ti yɛɛ ni. ");
INSERT INTO dyi_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Mi ŋa Yawe Yɛnŋɛlɛ, ŋgasegele ŋgele fuun mì yo Moyisi wi kan ma yo wi ke yo ye kan, ki daga ye ya yaa Izirayɛli woolo pe nari ke ni fun.» ");
INSERT INTO dyi_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moyisi wìla Arɔn naa wi pinambiile mbele pàa koro wi kan, Eleyazari naa Itamari pe pye fɔ: «Saraga muwɛ mba pe ma sogo Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mba pì koro pi ni, yoo lɛ yoo pye leve fu buru yoo ka le saraga wɔsaga ki tanla; katugu ki yɛn yaraga ŋga ki yɛn ma tɛgɛ ki yɛ pew Yɛnŋɛlɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ye yaa pi ka laga ŋga ki yɛn kpoyi ka ni; katugu ko ki yɛn mboro naa ma pinambiile pe ni, ye tasaga ye, ma yiri wa saara nda pe ma sogo Yawe Yɛnŋɛlɛ li kan ti ni, paa yɛgɛ ŋga na làa ki yo na kan we. ");
INSERT INTO dyi_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ndige ŋga pe ma yirige ma kan saraga, konaa kalige jele na pe ma kan saraga Yawe Yɛnŋɛlɛ li yeri, mboro naa ma pinambiile konaa ma sumborombiile pe ni, ye yaa kaa ti kaa wa laga ŋga ki yɛn fyɔngɔ fu ka ni; katugu to ti yɛn ye tasaga ye, mbe yiri wa Izirayɛli woolo pe nayinmɛ saara ti ni. ");
INSERT INTO dyi_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Jele na li ma kan Yawe Yɛnŋɛlɛ li yeri, Izirayɛli woolo pe yaa pan li ni, naa ndige ŋga pe ma yirige ma kan saraga ki ni, mbe taga yanlaga ŋga pe ma sogo ki ni, mberi yirige mberi kan saraga Yawe Yɛnŋɛlɛ li yeri. Pa kona ti yaa pye mboro naa ma pinambiile pe ni ye tasaga. Ki wogo ki yɛn ŋgasele na li yɛn kɔsaga fu, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ lìgi yo we.» ");
INSERT INTO dyi_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Sikapɔlɔ ŋa pàa wɔ saraga mbe kapere ti kala yagawa ja, a Moyisi wì si yewe wi wogo ki na, mɛɛ ki logo fɔ pàa wi sogo makɔ. A wì si nawa ŋgban Arɔn wi pinambiile sanmbala shyɛn Eleyazari naa Itamari pe ni, mɛɛ pe pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Yiŋgi na saraga ŋga kì wɔ mbe kapere ti kala yagawa ja, yee sigi kara ti ka wa laga ŋga ki yɛn kpoyi ki ni, ma si yala ti yɛn yaakara nda ti yɛn ma tɛgɛ ti yɛ Yɛnŋɛlɛ kan? Yawe Yɛnŋɛlɛ lìri kan ye yeri yeri ka, jaŋgo ye Izirayɛli gbogolomɔ woolo pe kajɔɔgɔ ki go kala li lɛ, mbe kapere ti kala yagawa ja kapyege ki pye pe kan Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ye wele, yaayogo ki kasanwa pa si ye wa cɛnsaga paraga go ki ni; ki ja daga yege kara ti ka wa laga kpoyi ki ni, paa yɛgɛ ŋga na mìla ki yo ye kan we.» ");
INSERT INTO dyi_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","A Arɔn wì si Moyisi wi yɔn sogo ma yo fɔ: «Wele, nala yɛɛn, ko pè pe saara ti wɔ mbe kapere ti kala yagawa ja konaa pe saara sogoworo ti ni Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ; ma si yala ŋga kìlan ta, màga jɛn. Ndɛɛ ki pye nala pilige ŋga ki na, sikapɔlɔ ŋa wì wɔ mbe kapere ti kala yagawa ja, muu kara ta ka, ki se jɛn na Yawe Yɛnŋɛlɛ li ndanla.» ");
INSERT INTO dyi_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Naa Moyisi wìla kaa ki sɛnrɛ ti logo, a tì suu ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi naa Arɔn pe ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","pege sɛnrɛ nda ti yo Izirayɛli woolo pe kan pe pe pye fɔ: «Yaayoro to naa woŋgaala mbele laga tara ti na, ye mbe ya mbaa mbele kaa pe ni pe mbele: ");
INSERT INTO dyi_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Yaayoro naa woŋgaala mbele fuun pe yenjoro ti yɛn ma wali pe na shyɛn konaa pe maa yaakara nda pè ka ti sɔngɔrɔ nari sanga, ye mbe ya mbaa pe kaa. ");
INSERT INTO dyi_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ɛɛn fɔ, mbele pe yenjoro ti yɛn ma wali pe na shyɛn ko cɛ, nakoma mbele pe maa yaakara nda pè ka ti sɔngɔrɔ nari sanga ko cɛ, yaga kaa pe kaa. «Kì kala na, yaga kaa yɔngɔmɛ wi kaa, katugu wi ma yaakara nda wì ka ti sɔngɔrɔ nari sanga, ɛɛn fɔ, wi yenjoro ti si woro ma wali wi na shyɛn; yaa wi jate fyɔngɔ yaraga. ");
INSERT INTO dyi_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","«Yaga kaa woŋgbɔ dama wi kaa. Wi ma yaakara nda wì ka ti sɔngɔrɔ nari sanga, ɛɛn fɔ, wi yenjoro ti si woro ma wali wi na shyɛn; yaa wi jate fyɔngɔ yaraga. ");
INSERT INTO dyi_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","«Yaga kaa polo wi kaa. Wi ma yaakara nda wì ka ti sɔngɔrɔ nari sanga, ɛɛn fɔ, yenjoro woro wi na ma wali shyɛn; yaa wi jate fyɔngɔ yaraga. ");
INSERT INTO dyi_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","«Yaga kaa cɛlɛ wi kaa, katugu yenjoro yɛn wi na ma wali wi na shyɛn, ɛɛn fɔ, wila ya mbe yaakara nda wì ka ti sɔngɔrɔ mbaa ti sanga; yaa wi jate fyɔngɔ yaraga. ");
INSERT INTO dyi_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","«Ki woŋgaala mbele pè naga yɛɛn, yaga kaa pe kaa, yaga ka jiri yɛrɛ wa kugo na; yaa pe jate fyɔngɔ yaara. ");
INSERT INTO dyi_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«Tɔnmɔ yaara nda fuun ye mbe ya mbaa kaa tori nda yɛɛn: Ŋgbanra nda fuun wuuro yɛn ti kanŋgara ti na paa kanwira yɛn konaa ma pye kɔɔrɔ ni wa kɔgɔjeye naa lɔrɔ ti ni, ye mbe ya mbaa ti ni fuun ti kaa. ");
INSERT INTO dyi_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ɛɛn fɔ, yaara nda fuun ti yɛn wa kɔgɔjeye naa lɔrɔ ti ni na tigile tigile, tɔnmɔ yaara nda fuun wuuro woro ti kanŋgara ti na paa kanwira yɛn konaa kɔɔrɔ woro ti na, ti yaa pye ye yarifuro. ");
INSERT INTO dyi_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ti yaa pye ye yarifuro, ye se kaa ti kaa, ye se ka jiri ti kuro ta na. ");
INSERT INTO dyi_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tɔnmɔ yaara nda fuun wuuro woro ti kanŋgara ti na paa kanwira yɛn, kɔɔrɔ si woro ti na, ti yaa pye ye yarifuro. ");
INSERT INTO dyi_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«Sannjɛrɛ ti ni, nda ye yaa la fuun, ye se kaa ti kaa, ti nda: Yɔn, naa pɛtɛ, naa yɔn ŋa wi ma pye wa kɔgɔje wi ni, ");
INSERT INTO dyi_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","naa tufara konaa duwaye pe cɛnlɛ li ni fuun, ");
INSERT INTO dyi_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","naa kaankaanye pe cɛnlɛ li ni fuun, ");
INSERT INTO dyi_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","naa kɔnrɔsogolo, naa kuwege, naa kuwefige, naa gbinlɛlɛ pe cɛnlɛ li ni fuun, ");
INSERT INTO dyi_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","naa kuwegbɔgɔ, naa tɔnmɔ sannjɛgɛ, naa gbinŋgbin, ");
INSERT INTO dyi_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","naa laŋgolo, naa lɔgɔ simbaala, naa kara kasannjɛgɛ, ");
INSERT INTO dyi_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","naa jagapan, naa gɔgɔ konaa ki cɛnlɛ li ni fuun, naa sannjɛgɛ ŋga pe yinri hupi konaa ndirige. ");
INSERT INTO dyi_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«Yaawere nda fuun ti maa yinrigi sire na, na tanri tɔɔrɔ na, yaa ti fuun. ");
INSERT INTO dyi_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ɛɛn fɔ, yaawere nda fuun ti maa yinrigi sire na, na tanri tɔɔrɔ na, nda jegele titɔɔnrɔ titɔɔnrɔ yɛn ti na, ti maa yeni ke na, ye mbe ya mbaa to kaa. ");
INSERT INTO dyi_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Nda ye mbe ya mbaa kaa ti nda: Gbatɔ wi cɛnlɛ li ni fuun, naa kambɛɛrɛ tugbɔɔrɔ ti cɛnlɛ li ni fuun konaa kambɛɛrɛ ti cɛnlɛ li ni fuun. ");
INSERT INTO dyi_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ɛɛn fɔ, yaawere sannda nda fuun ti maa yinrigi sire na, na tanri tɔɔrɔ na, yaa ti fuun. ");
INSERT INTO dyi_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«Ti mbe ya ye tɛgɛ fyɔngɔ ni. Lere ŋa ka jiri ti kugo ka na, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Lere ŋa fuun kaga kugo ka lɛ, wi yaa wi yaripɔrɔ ti jogo. Konaa ki ni fuun wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Yaayogo naa woŋgbɔ ŋa fuun wi yenjogo ki woro ma wali wi na shyɛn, wila si ya mbe yaakara nda wì ka ti sɔngɔrɔ mbaa ti sanga, ye yaa la wo jate fyɔngɔ ni. Lere o lere ka jiri wa na, wi yaa pye fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Yaayogo naa woŋgbɔ ŋa fuun wi yɛn tɔɔrɔ tijɛrɛ ni, nɛɛ tanri wi tɔndagala ke na, ye yaa la to ti ni fuun to jate fyɔngɔ ni. Lere o lere ka jiri ki kugo ka na, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Lere ŋa fuun ka ki kugo ka lɛ, wi yaa wi yaripɔrɔ ti jogo, konaa ki ni fuun, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. Ye yaa la ki yaayoro to naa ki woŋgaala pe jate fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«Yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele fuun ke maa fulolo tara ti na, ŋgele ye yaa la jate fyɔngɔ ni ke ŋgele: Ŋgboyogo, naa saco, naa kanŋgɛnnɛ pe cɛnlɛ pyew, ");
INSERT INTO dyi_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","naa faramandana, naa paan, naa nambɛgɛ, naa naŋgbɔɔlɔ, konaa ŋganŋgori. ");
INSERT INTO dyi_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ki yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele fuun ke maa fulolo tara ti na, ye yaa la ke jate fyɔngɔ ni. Lere ŋa fuun ka jiri la kugo na, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Na la ka ku mbe to yaraga ŋga fuun na, ki yaraga ki yaa pye fyɔngɔ ni. Ki yɛn tige leyaraga o, yaripɔgɔ yi o, sɛlɛgɛ yi o, kasha yi o, ki yɛn tunŋgo pyeyaraga ŋga fuun, ki yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. Ko puŋgo na, ki yaa pye fyɔngɔ fu naa. ");
INSERT INTO dyi_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Na ki yaŋgala la kugo ka to leyaraga ŋga pè fanri joro ni ka ni, yaraga ŋga fuun ki yɛn wa ki nawa ki yaa pye fyɔngɔ ni, leyaraga ki daga pege yaari. ");
INSERT INTO dyi_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Na tɔnmɔ ka pye wa ki leyaraga ki ni, na paga pa wo yaakaga na, ki yaa pye fyɔngɔ ni fun. Yaraga ŋga fuun pe maa woo, na ka ka pye ki leyaraga ka ni, ki yɛn yɛgɛ o yɛgɛ, ki yaa pye fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Na ki yaŋgala la kugo ka to yaraga o yaraga na, ki yaa pye fyɔngɔ ni. Ki yɛn buru fɔsaga o, ki yɛn gbɔngɔlɔ o, ki daga pege yaari. Yaa ti jate fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Yɛgɛ o yɛgɛ ki yaŋgala la kugo ka to pulugo ka ni nakoma tɔnmɔ titɛgɛ ka ni, ki tɔnmɔ pi yaa koro fyɔngɔ fu. Ɛɛn fɔ, lere ŋa fuun ka jiri li kugo ki na, wi yaa pye fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Na la kugo ka kɔn mbe to yariluguro na, ki yariluguro ti yaa koro fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ɛɛn fɔ, na la kugo ka to yarilire nda pè fyɔn tɔnmɔ ni ta ni, ye daga mbaa ti jate fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«Yaayoro nda ye maa kaa, na ka ka ku ki yɛ, lere ŋa fuun ka jiri ki kugo ki na, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Lere ŋa fuun ka ki yaayogo kugo kara ta ka, wi daga mboo yaripɔrɔ ti jogo, wi yaa si pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. Lere ŋa ka yaayogo kugo ka lɛ, wi daga mboo yaripɔrɔ ti jogo fun, wi yaa si pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«Yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele fuun ke maa fulolo tara ti na, ke yaa pye ye yarifuro, ye se kaa ke kaa. ");
INSERT INTO dyi_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele fuun ke maa fulolo lara na, nakoma ŋgele ke maa tanri tɔɔrɔ tijɛrɛ na, nakoma tɔɔrɔ lɛgɛrɛ na, yaga ka la ka, yaa ke jate ye yarifuro. ");
INSERT INTO dyi_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Yaga kaga pye yɛgɛ ka na mbe ye yɛɛ faara ki yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele ke maa fulolo tara ti na la ni, mbe ti ye pye yaritijangara, yaga ka ti ti ye tɛgɛ fyɔngɔ ni, mbe ye pye fyɔngɔ fɛnnɛ. ");
INSERT INTO dyi_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le, ye ye yɛɛ pye kpoyi, ye pye leele mbele pe yɛn kpoyi, katugu mi yɛn kpoyi. Yaga ka jiri ki yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele ke maa fulolo tara ti na la na mbe ye yɛɛ tɛgɛ fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Muwi mi yɛn Yawe Yɛnŋɛlɛ na lì ye yirige wa Ezhipiti tara, mbe pye ye Yɛnŋɛlɛ. Ki kala na ye pye kpoyi, katugu mi yɛn kpoyi. ");
INSERT INTO dyi_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","«Yaayoro to naa woŋgaala pe ni, naa sannjɛrɛ ti ni, naa yaara nda ti yɛn yinwege na, na yanri wa tɔnmɔ konaa tara ti na ti ni, lasiri konɔ na lì tɛgɛ ti wogo ki na, loli yɛɛn; ");
INSERT INTO dyi_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","jaŋgo yaayoro naa woŋgaala mbele pe yɛn fyɔngɔ ni konaa mbele pe yɛn fyɔngɔ fu, ye pe jɛn ye pe wɔ pe yɛɛ ni; mbele ye mbe ya mbaa kaa naa mbele ye se ya mbaa kaa, ye pe jɛn ye pe wɔ pe yɛɛ ni.» ");
INSERT INTO dyi_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","wigi yo Izirayɛli woolo pe kan fɔ: «Na jɛlɛ wa ka pinambyɔ se, wi yaa pye fyɔngɔ ni fɔ sa gbɔn piliye kɔlɔshyɛn, paa yɛgɛ ŋga na wi kaa jogo wi ma pye fyɔngɔ ni we. ");
INSERT INTO dyi_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Pilige kɔlɔtaanri wogo ki na, pe yaa pyɔ wi kɛnrɛkɛnrɛ. ");
INSERT INTO dyi_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ko puŋgo na, jɛlɛ wi yaa koro mbaa wi yɛɛ gbegele fɔ sa gbɔn piliye nafa ma yiri kɛ ma yiri taanri, si jɛn mbe pye fyɔngɔ fu, kasanwa mba pì wo wi na pi kala na. Wii daga mbe jiri yaraga ŋga ki yɛn ma tɛgɛ ki yɛ Yɛnŋɛlɛ kan ka na, wii si daga mbe kari wa cɛnsaga paraga go ki ni, fɔ wagati ŋa wi daga mboo yɛɛ gbegele mbe pye fyɔngɔ fu wi sa kɔ. ");
INSERT INTO dyi_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","«Na jɛlɛ wa ka sumborombyɔ se, wi yaa pye fyɔngɔ ni fɔ sa gbɔn yapeleye shyɛn, paa yɛgɛ ŋga na wi kaa jogo wi ma pye fyɔngɔ ni we. Ko puŋgo na, wi yaa koro mbaa wi yɛɛ gbegele fɔ sa gbɔn piliye nafa taanri ma yiri kɔgɔlɔni si jɛn mbe pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«Jɛlɛ wi yaa wi yɛɛ gbegele mbe pye fyɔngɔ fu piliye yan ni, na yiga ka kɔ, wi pinambyɔ nakoma wi sumborombyɔ wi seŋgɔlɔ, pa wi yaa simbapɔlɔ yirifɔnŋɔ yigi ŋa wì fa yɛlɛ nuŋgba ta, wo mbe pye saraga sogowogo; naa jɛndɛtuwa nuŋgba nakoma ketenɛ nuŋgba, lo mbe pye saraga mbe kapere ti kala yagawa ja. Wi yaa kari ti ni wa filisaga paraga go ki yɔn na, mberi kan saraga wɔfɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Saraga wɔfɔ wi yaa ki saraga ki wɔ Yawe Yɛnŋɛlɛ li yeri mbe kapere ti kala yagawa ja kapyege ki pye wi kan. Kona jɛlɛ wi yaa pye fyɔngɔ fu wi kasanwa mba pì wo pi wogo ki na.» Ki ŋgasele na lo lì tɛgɛ jɛlɛ wi kan, na wiga pinambyɔ nakoma sumborombyɔ se we. ");
INSERT INTO dyi_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Na ki fanŋga woro jɛlɛ ŋa ni wi simbapɔlɔ yirifɔnŋɔ wɔ, wi pan keteŋgele shyɛn nakoma jɛndɛtuwaye shyɛn ni. Nuŋgba yaa pye saraga sogowogo, sanna li yaa pye saraga mbe kapere ti kala yagawa ja. Saraga wɔfɔ wi yaa kapere ti kala yagawa ja kapyege ki pye jɛlɛ wi kan, pa kona wi yaa pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si para Moyisi naa Arɔn pe ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Na yaritinŋge ka yiri lere wa na nakoma sagbanga ŋga ki yɛn titigiti, nakoma laga ka mbe kɔn kila yɛngɛlɛ wi witige ki na paa yayɛnwɛ yɛn, ye pan wi ni wa saraga wɔfɔ Arɔn wi yeri, nakoma wa wi setirige piile nuŋgba yeri. ");
INSERT INTO dyi_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Yama pi yɛn witige sɛlɛgɛ ŋga na, saraga wɔfɔ wi yaa ki wele jɛŋgɛ. Na wiga ki laga ki sire ti yan tì filige, nakoma mbege yan kì jugo jɛnri ma ye wa wire kara ti ni, kona yayɛnwɛ wi. Yama pi weleŋgɔlɔ, saraga wɔfɔ wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ɛɛn fɔ, na kaa pye wire ti laga ŋga kì kɔn na yɛngɛlɛ, kii jugo mbe ye jɛnri wa wire kara ti ni, na ki sire tii si filige, pa kona saraga wɔfɔ wi yaa yaŋa wi tɛgɛ wi yɛ laga ka ni fɔ sa gbɔn yapelege nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Pilige kɔlɔshyɛn wogo ki na, saraga wɔfɔ wi yaa wi wele naa jɛŋgɛ. Na wiga yama laga ki yan, ka si taga ki na, pii sɛlɛgɛ ki li mbe wɛ koŋgbanŋga ki na, pa wi yaa yaŋa wi tɛgɛ wi yɛ naa yapelege nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ki yapelege ki pilige kɔlɔshyɛn wogo ki na, saraga wɔfɔ wi yaa yama laga ki wele naa jɛŋgɛ ki shyɛn wogo na. Na wiga ki yan yama pila koo, pi woro na sɛlɛgɛ ki nii na gbogo, pa kona sasambara ri. Saraga wɔfɔ wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ fu. Pa kona ki lerefɔ wi yaa wi yaripɔrɔ ti jogo mbe pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ɛɛn fɔ, saraga wɔfɔ wiga yaŋa wi wele mbe kɔ mbege yo mbege naga fɔ wi woro fyɔngɔ ni, ko puŋgo na sasambara laga ki sila wire ti nii kila gbogo, wi daga mbe sɔngɔrɔ wa saraga wɔfɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Saraga wɔfɔ wi yaa wi wele naa. Na wiga ki yan sasambara laga kì sɛlɛgɛ ki li ma gbɔgɔ, wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ ni, fɔ yayɛnwɛ pi yɛn wi na. ");
INSERT INTO dyi_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Na yayɛnwɛ ka to lere wa na, pe yaa kari wi ni wa saraga wɔfɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Saraga wɔfɔ wi yaa wi wele. Na wiga ki yan yaritinŋge kì yiri wi wire sɛlɛgɛ ki na ma filige, a ki laga ki sire tì filige, a ki kara tì yanlaga, ");
INSERT INTO dyi_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","pa kona yayɛnwɛ wi, mba pì mɔ wi na. Saraga wɔfɔ wi yaa ki yo mbege naga fɔ wi yɛn fyɔngɔ ni. Wiga ka yo wi yaa wi tɛgɛ laga ka na wi yɛ, katugu kì jɛn ma filige fɔ wi yɛn fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ɛɛn fɔ, na saraga wɔfɔ wiga ki yan yaritinŋge kì lerefɔ wi witige sɛlɛgɛ lagapyew ki li, maa wire ti tɔn wi na mbege lɛ wa wi go ki na fɔ wa wi tɔndagala ke na, ");
INSERT INTO dyi_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kona wi yaa wi wele naa. Na wiga ki yan yaritinnde tùu wire lagapyew ki tɔn wi na, wi yaa ki yo mbege naga fɔ yaŋa wi woro fyɔngɔ ni; katugu yama pùu witige lagapyew ki filige wi na, wi woro fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ɛɛn fɔ, pilige ŋga ni paga sagbanga yɛgɛ ki yan kì kɔn ma yanlaga wi na, pa wi yaa pye fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Saraga wɔfɔ wi yaa sagbanga ki yɛgɛ ŋga kì kɔn ma yanlaga ki wele jɛŋgɛ, mbe sigi yo mbege naga fɔ ki lere wi yɛn fyɔngɔ ni. Katugu ki kayɛnrɛ ti yɛn fyɔngɔ ni, ti yɛn naga nari fɔ yayɛnwɛ pi yɛn wi na. ");
INSERT INTO dyi_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Na ki laga ki kayɛnrɛ tiga kanŋga mbe filige, ki lerefɔ wi sɔngɔrɔ wa saraga wɔfɔ wi yeri, ");
INSERT INTO dyi_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","wi saa wele. Na wiga sagbanga ki yɛgɛ ki yan kì kanŋga ma filige kaselege, wi yaa ki yo mbege naga fɔ yama pi se ya lere kan wi pye fyɔngɔ ni, kona ki lerefɔ wi yaa pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Na naŋgbanga ka yiri lere wa na, mbe ka kɔ, ");
INSERT INTO dyi_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ko puŋgo na, yaritinŋge fige mbe yiri wa ki titɛgɛ ki ni, nakoma ki laga ki kɔn kì filige ki yanlaga gbanliŋgbanli, kona ki lerefɔ wi yaa saa yɛɛ naga saraga wɔfɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Saraga wɔfɔ wi yaa yama pi wele jɛŋgɛ. Na wiga ki yan ki laga kì jugo ma ye wa wire ti sɛlɛgɛ ki ni jɛnri, a ki laga ki sire tì filige, wi yaa ki yo mbege naga fɔ yaŋa wi yɛn fyɔngɔ ni, fɔ yayɛnwɛ pì to wa naŋgbanga titɛgɛ ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ɛɛn fɔ, na saraga wɔfɔ wiga yama pi wele mbege yan ki laga ki sire ti woro ma filige, kii si jugo mbe ye jɛnri wa wire ti sɛlɛgɛ ki ni, na kaa pye ki yɛn na koo, pa wi yaa yaŋa wi tɛgɛ laga ka na wi yɛ piliye kɔlɔshyɛn ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ko puŋgo na, na saraga wɔfɔ wiga yama pi yan pì jaraga wa witige sɛlɛgɛ ki na, pa wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ ni, yayɛnwɛ pi yɛn wi na. ");
INSERT INTO dyi_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ɛɛn fɔ, na yama piga koro le pi yɔn lɛlɛ li ni, na ka si taga pi na, kona naŋgbanga titɛgɛ koyi, pa saraga wɔfɔ wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Na kasɔn ka lere wa sogo wi witige laga ka na, na laga ka ka yiri wa witige laga ŋga kì sogo ki ni mbe wɔlɔgɔ, mbe filige mbe yanlaga gbanliŋgbanli, ");
INSERT INTO dyi_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","saraga wɔfɔ wi yaa ki laga ki wele. Na wiga ki yan ki laga ki sire tì filige, ma jugo ma ye wa wire ti sɛlɛgɛ ki ni, kona yayɛnwɛ pì to wa kasɔn sogosaga ki ni. Pa wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Na saraga wɔfɔ wiga ki wele mbege yan ki laga ki sire ti woro ma filige, kii si jugo mbe ye wa wire ti sɛlɛgɛ ki ni, na wiga ki yan ki yɛn na koo, kona wi yaa yaŋa wi tɛgɛ laga ka na wi yɛ piliye kɔlɔshyɛn ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pilige kɔlɔshyɛn wogo ki na, na saraga wɔfɔ wiga ki yan yama pì sɛlɛgɛ ki li ma gbɔgɔ, wi yaa ki yo mbege naga fɔ ki lere wi yɛn fyɔngɔ ni; katugu yayɛnwɛ pì to wi na. ");
INSERT INTO dyi_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ɛɛn fɔ, na yama piga koro le pi yɔn lɛlɛ li ni, na ka si taga pi na, ɛɛn fɔ, na ki ka pye pì kɔ, pa kona kasɔn sagbantitɛgɛ yi. Pa saraga wɔfɔ wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ fu, katugu kasɔn sagbantitɛgɛ yi. ");
INSERT INTO dyi_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Yama mba pi ma to witige sɛlɛgɛ ki na, na pa ka to naŋa nakoma jɛlɛ wa go na, nakoma wa wi tugbila wi na, ");
INSERT INTO dyi_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","saraga wɔfɔ wi yaa yama pi wele. Na wiga pi yan pì jugo ma ye wa wire ti sɛlɛgɛ ki ni, a ki sire tì cɛn pa nɛŋgɛ muwɛ yɛn ma yiri yaliyali, kona wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ ni; katugu dagbaraga yi, ki yɛn yayɛnwɛ mba pì to wa wi go ki na nakoma wa wi tugbila wi na. ");
INSERT INTO dyi_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Na saraga wɔfɔ wiga yama pi wele mbege yan pii jugo mbe ye wa wire ti sɛlɛgɛ ki ni, na siwɔrɔ woro wa ki laga ki ni, wi yaa yaŋa wi tɛgɛ laga ka na wi yɛ piliye kɔlɔshyɛn ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Pilige kɔlɔshyɛn wogo ki na, saraga wɔfɔ wi yaa yama pi wele naa fɔnŋgɔ. Na wiga ki yan ka si taga dagbaraga ki na, na ki laga ki sire ti si woro paa nɛŋgɛ muwɛ yɛn, kii si jugo mbe ye wa wire ti sɛlɛgɛ ki ni, ");
INSERT INTO dyi_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","kona yaŋa wuu go ki kulu, dagbaraga ki yɛn laga ŋga na wi ko yaga. Ko puŋgo na, saraga wɔfɔ wi yaa wi tɛgɛ laga ka na wi yɛ naa piliye kɔlɔshyɛn ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ki yapelege shyɛn wogo ki pilige kɔlɔshyɛn wogo ki na, saraga wɔfɔ wi yaa yama pi wele naa fɔnŋgɔ. Na wiga ki yan dagbaraga kii sɛlɛgɛ ki li mbe gbɔgɔ, kii si jugo mbe ye wa wire kara ti ni, wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ fu. Kona ki lerefɔ wi yaa wi yaripɔrɔ ti jogo, pa wi yaa pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ɛɛn fɔ, na saraga wɔfɔ wiga ki wele mbege yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ fu, ko puŋgo na, dagbaraga ki sɛlɛgɛ ki li ki gbɔgɔ, ");
INSERT INTO dyi_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","pa saraga wɔfɔ wi yaa ki wele naa fɔnŋgɔ. Na wiga ki yan kaselege kì sɛlɛgɛ ki li ma gbɔgɔ, wi se cɛn mbe yo wi yaa ki sire ti wele na kaa pye ti yɛn paa nɛŋgɛ muwɛ yɛn, katugu ki lerefɔ wi yɛn fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Na yama piga koro le pi yɔn lɛlɛ li ni, siwɔrɔ mbaa yinrigi wa ki titɛgɛ ki ni, kona yaŋa wì sagala ma pye fyɔngɔ fu. Pa saraga wɔfɔ wi yaa ki yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Na lafire fire ka yiri naŋa nakoma jɛlɛ wa witige na, ");
INSERT INTO dyi_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","saraga wɔfɔ wi yaa wi wele; na wiga ki lara ti yan tì filige jɛnri, kona kawa wì yiri wa wi witige ki na, ki lerefɔ wi yɛn fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Na naŋa wa go ka pɛ wi na, wi yɛn yumbɛgɛ fɔ. Wi yɛn fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Na wi go kiga pɛ laga walɛgɛ kɛɛ yeri, ko yɛn go ŋga kì pɛ walɛgɛ na; wi yɛn fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ɛɛn fɔ, go ki nandogomɔ laga ŋga kì pɛ, nakoma walɛgɛ ŋga kì pɛ, na yama ka to wa ki na mbe kɔn mbe filige mbe yanlaga gbanliŋgbanli, kona yayɛnwɛ pì to wa wi go ki na. ");
INSERT INTO dyi_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Saraga wɔfɔ wi yaa yama pi wele. Na wiga ki yan go ki nandogomɔ laga ŋga kì pɛ nakoma walɛgɛ ŋga kì pɛ, yaritinŋge yiri wa ki na ma filige ma yanlaga gbanliŋgbanli paa yayɛnwɛ yɛn, ");
INSERT INTO dyi_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","kona yayɛnwɛ pì to ki naŋa wi na. Wi yɛn fyɔngɔ ni. Saraga wɔfɔ wi yaa ki yo mbege naga fɔ ki naŋa wi yɛn fyɔngɔ ni, yama mba pì to wa wi go ki na pi kala na. ");
INSERT INTO dyi_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Yayɛnwɛ ka to lere ŋa na, wi yaa yaripɔrɔ kɔnrɔkɔnrɔ le, mboo go ki yaga sagara. Wi yaa yaraga ka tɛgɛ mboo yɔn ki fo mbaa jɔrɔgi fɔ: ‹Mi yɛn fyɔngɔ ni, mi yɛn fyɔngɔ ni.› ");
INSERT INTO dyi_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Mbege yama pi ta wi na sanga ŋa fuun ni, wi yaa pye fyɔngɔ ni. Ki kala na, wi cɛnsaga ki yaa pye ki yɛ leele sanmbala pe wogo ki ni, wa paara yinrɛ cɛnsaga ki puŋgo na. ");
INSERT INTO dyi_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Na laga ka ka fyɛnwɛ yaripɔgɔ ka na ŋga ki yɛn simbasire wogo, nakoma lɛn jese wogo na, ");
INSERT INTO dyi_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","nakoma pariyɛɛgɛ na, nakoma tiriko ŋa pè ti lɛn jese ni nakoma simbasire ni wa na, nakoma sɛlɛgɛ na, nakoma yaraga ŋga fuun pè gbegele sɛlɛgɛ ni ka na, ");
INSERT INTO dyi_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","na ki laga ki yɛgɛ cɛnwɛ piga pye paa yantipirige yɛn, nakoma yɛngɛ gbanliŋgbanli wa yaripɔgɔ ki na, nakoma wa sɛlɛgɛ ki na, nakoma wa pariyɛɛgɛ ki na, nakoma wa tiriko wi na, nakoma wa yaraga ŋga fuun pè gbegele sɛlɛgɛ ni ka na, kona yaraga ŋga ki ma fyɛnwɛ yaripɔgɔ na ko kayi. Ki daga pe saga naga saraga wɔfɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Yaraga ŋga ki laga ka fyɛnwɛ, saraga wɔfɔ wiga ki wele mbe kɔ, wi yaa ki tɔn laga ka ni fɔ sa gbɔn piliye kɔlɔshyɛn. ");
INSERT INTO dyi_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Pilige kɔlɔshyɛn wogo ki na, wi yaa ki wɔ mbe laga ŋga kì fyɛnwɛ ki wele naa. Na wiga ki yan kì fyɛnwɛ ma gbɔgɔ ma kari yɛgɛ wa yaripɔgɔ ki na, naa wa pariyɛɛgɛ nakoma wa tiriko wi na, naa wa sɛlɛgɛ ki na, nakoma wa yaraga ŋga pè gbegele sɛlɛgɛ ni ki na, ki yɛn fyɛnwɛ mba pi ma fyɛnwɛ yaraga na po pa. Kiga pye ma, ki yaraga ki yɛn fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Laga ŋga kì fyɛnwɛ ki yɛn yaripɔgɔ ŋga na, pariyɛɛgɛ yi wi yo, tiriko ŋa pè ti simbasire ni nakoma lɛn jese ni wo wa wi yo, nakoma yaraga ŋga fuun pè gbegele sɛlɛgɛ ni ko kayi yo, saraga wɔfɔ wi yaa ki sogo; katugu ki yɛn fyɛnwɛ mba pi se ya laga ki na. Kiga pye ma, ki daga pege yaraga ki sogo pege wɔ wa. ");
INSERT INTO dyi_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ɛɛn fɔ, na saraga wɔfɔ wiga ki wele mbege yan laga ŋga kì fyɛnwɛ kii gbɔgɔ mbe jaraga wa yaripɔgɔ ki na, pariyɛɛgɛ yi wi yo, tiriko ŋa pè ti simbasire ni nakoma lɛn jese ni wo wa wi yo, nakoma yaraga ŋga fuun pè gbegele sɛlɛgɛ ni ko kayi yo, ");
INSERT INTO dyi_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","wi yaa ti pege jogo, ko puŋgo na, wi yaa ki tɔn laga ka ni naa yapelege nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Yaraga ki jogoŋgɔlɔ, wi yaa ki wele naa, na wiga ki yan laga ŋga kì fyɛnwɛ kii kanŋga, ali mbege ta ka si taga ki na, ki yaraga ki yaa la jate fyɔngɔ ni. Ki daga pege sogo, ali na kiga pye ki yɛgɛ nakoma ki puŋgo ko kì fyɛnwɛ ma jɔgɔ o. ");
INSERT INTO dyi_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ɛɛn fɔ, ki jogoŋgɔlɔ, na wiga ki wele mbege yan ki fyɛnwɛ jɛnri, wi yaa ki laga ki kɔn mbege wɔ wa yaripɔgɔ ki na, naa wa sɛlɛgɛ ki na, naa pariyɛɛgɛ nakoma wa tiriko wi na. ");
INSERT INTO dyi_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ko puŋgo na, na paga fyɛnwɛ pa yan naa wa yaripɔgɔ ki na, nakoma wa pariyɛɛgɛ naa tiriko nakoma wa yaraga ŋga pè gbegele sɛlɛgɛ ni ki na, kona ki yɛn na fyɛnwɛ na gbogo na kee yɛgɛ. Kona yaripɔgɔ ŋga ki laga kà fyɛnwɛ ki na ki daga pege sogo. ");
INSERT INTO dyi_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","«Na yaripɔgɔ, nakoma pariyɛɛgɛ, nakoma tiriko, nakoma yaraga ŋga pè gbegele sɛlɛgɛ ni ka ka fyɛnwɛ a pège jogo ki fyɛnwɛ pì laga ki na, pe yaa ki jogo naa jogosaga shyɛn wogo na; pa kona ki yaa pye fyɔngɔ fu.» ");
INSERT INTO dyi_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Laga ŋga ki ma fyɛnwɛ yaripɔrɔ nda pè ti simbasire ni ti na, nakoma lɛn jese ni ti na, nakoma pariyɛɛrɛ ti na nakoma tirikoye pe na, nakoma yaara nda fuun pè gbegele sɛlɛgɛ ni ti na, ŋgasele na lì tɛgɛ ki wogo na, loli yɛɛn. Ki ŋgasele li maa ki nari na kiga pye ki yaraga ki yɛn fyɔngɔ fu nakoma ki yɛn fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Na yayɛnwɛ ka lere wa ta (mbe ka kɔ), ŋgasele na lì tɛgɛ mboo pye fyɔngɔ fu loli na: Pe yaa kari wi ni wa saraga wɔfɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Wo yaa yiri wa paara yinrɛ cɛnsaga ki puŋgo saa wele. Na wiga ki yan yayɛnwɛ pi kɔ wi na, ");
INSERT INTO dyi_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","wi yaa ti pe pan sannjɛwegele shyɛn ni ŋgele ke yɛn fyɔngɔ fu, naa sɛdiri tige kanŋgaga ni, naa kondoro jese, naa yizɔpi wɛrɛ ni lere ŋa pe yaa pye fyɔngɔ fu wi kala na. ");
INSERT INTO dyi_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Saraga wɔfɔ wi yaa ti pe sannjɛlɛ nuŋgba kɔnli cɔgɔ ŋga pè fanri joro ni ka go na, ko ŋga pulugo tɔnmɔ yɛn wa ki ni we. ");
INSERT INTO dyi_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Wi yaa sannjɛwele li lɛ naa sɛdiri tige kanŋgaga ki ni, naa kondoro jese wi ni, naa yizɔpi wɛrɛ ti ni, mberi pinlɛ mberi le wa sannjɛlɛ na pè kɔnli li kasanwa pi ni, wa pulugo tɔnmɔ pi ni; ");
INSERT INTO dyi_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","kona mbe si pa yanragi yanragi lere ŋa wi daga mbe pye fyɔngɔ fu wi na sa ta yanragisaga kɔlɔshyɛn, mbe sigi yo mbege naga fɔ ki lerefɔ wi yɛn fyɔngɔ fu. Ko puŋgo na, wi yaa sannjɛwele li wa li yiri laa kee. ");
INSERT INTO dyi_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Lere ŋa wì pan mboo yɛɛ pye fyɔngɔ fu wi yaa wi yaripɔrɔ ti jogo, mboo sire ti ni fuun ti kulu mbe sa woli. Kona wi yaa pye fyɔngɔ fu. Ko puŋgo na, wi mbe ya sɔngɔrɔ wa paara yinrɛ cɛnsaga ki ni, ɛɛn fɔ, wi se ye wa wi paraga go ki ni fɔ sa gbɔn piliye kɔlɔshyɛn. ");
INSERT INTO dyi_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Pilige kɔlɔshyɛn wogo ki na, wi yaa wi sire ti ni fuun ti kulu naa, to ti yɛn wi yinzire naa wi siyɔ, naa wi yɛnyugo sire konaa wi witige lara sannda ti sire ti ni. Ko puŋgo na, wi yaa wi yaripɔrɔ ti jogo, mbe sa woli, kona wi yaa pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«Pilige kɔlɔtaanri wogo ki na, ki lerefɔ wi yaa pan simbapɛnɛ yirifɔnmbɔlɔ shyɛn ni, mbele pe yɛn jɛrɛgisaga fu, naa simbasumboro nuŋgba ni ŋa wì ta yɛlɛ nuŋgba ma pye jɛrɛgisaga fu, naa saraga muwɛ tiyɔɔn culo kɔlɔjɛrɛ ni mba pè sinmɛ pinlɛ pi ni konaa sinmɛ litiri kɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Saraga wɔfɔ ŋa wila ki fyɔngɔ fu kapyere ti yɛgɛ woo, wi yaa kari lerefɔ wo naa wi yarikanra ti ni fuun ti ni mbe saa yerege Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, wa filisaga paraga go ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Saraga wɔfɔ wi yaa simbapɛnɛ yirifɔnmbɔlɔ nuŋgba lɛ mboo pye saraga ŋga ki ma wɔ mbe kajɔɔgɔ gbegele, mbe pinlɛ sinmɛ litiri kɔngɔ ki ni, mberi yirige mberi kan saraga Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Yaayoro nda pe ma pye kapere ti kala yagawa jasaara to naa saara sogoworo ti ni pe maa kɔnlɔgi laga ŋga na, wi yaa simbapɔlɔ yirifɔnŋɔ wi kɔnli wa ki laga ki na, ko kɔrɔ wo yɛn wa laga kpoyi ki ni. Yaayogo ŋga pe ma gbo mbe kajɔɔgɔ gbegele konaa ŋga pe ma wɔ mbe kapere ti kala yagawa ja ti yɛn saraga wɔfɔ wi woro; ti yɛn yarikanga ŋga ki yɛn jɛŋgɛ kpoyi. ");
INSERT INTO dyi_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Saraga wɔfɔ wi yaa yaayogo ŋga kì wɔ mbe kajɔɔgɔ gbegele ki kasanwa pa lɛ mboo taga wa lerefɔ ŋa wi yaa wi yɛɛ pye fyɔngɔ fu wi kalige nuŋgbolo li na, wa laga ŋga pe mali furu we, mbe pa taga wa wi kalige kɛɛ yombɛgbɔgɔ konaa wi kalige tɔlɔgɔ yombɛgbɔgɔ ki na. ");
INSERT INTO dyi_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ko puŋgo na, wi yaa sinmɛ litiri kɔngɔ ki lɛ mbe pa kanŋga wa wi kamɛŋgɛ kɛndala li ni, ");
INSERT INTO dyi_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","mbe suu kalige kɛɛ yombɛnagala li le wa pi ni mboo yanragi yanragisaga kɔlɔshyɛn Yawe Yɛnŋɛlɛ li yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ko puŋgo na, sinmɛ mba pì koro wa wi kɛndala li ni, wi yaa pa taga wa lerefɔ ŋa wila wi yɛɛ piin fyɔngɔ fu wi kalige nuŋgbolo li na, wa laga ŋga pe mali furu we, mbe pa taga wa wi kalige kɛɛ yombɛgbɔgɔ ko naa kalige tɔlɔgɔ yombɛgbɔgɔ ki na, wa laga ŋga wì keli ma yaayogo ŋga kì wɔ mbe kajɔɔgɔ ki gbegele ki kasanwa pi taga we. ");
INSERT INTO dyi_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Sinmɛ sanmba mba pì koro wa wi kɛndala li ni, wi yaa pi wo wa lerefɔ ŋa wila wi yɛɛ piin fyɔngɔ fu wi go ki na, jaŋgo mbe kapere ti kala yagawa ja kapyege ki pye wi kan Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ko pyeŋgɔlɔ, saraga wɔfɔ wi yaa saraga ŋga pe ma wɔ mbe kapere ti kala yagawa ja ki wɔ, jaŋgo mbe kapere ti kala yagawa ja kapyege ki pye lerefɔ ŋa wila wi yɛɛ piin fyɔngɔ fu wi kan, kona mbe si yaayogo ŋga kì wɔ saraga sogowogo ki kɔnli. ");
INSERT INTO dyi_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Wi yaa yaayogo ŋga kì wɔ saraga sogowogo konaa muwɛ saraga ki ni ti pinlɛ mberi sogo wa saraga wɔsaga ki na. Kona wi yaa kapere ti kala yagawa ja kapyege ki pye naa ki lerefɔ wi kan, pa wi yaa pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Na kaa pye ki lerefɔ wi yɛn fyɔnwɔ fɔ, wi se ya mbege yariwɔndɔ ti ni fuun ti ta, wi yaa pan simbapɔlɔ yirifɔnŋɔ nuŋgba ni mboo pye saraga ŋga pe ma wɔ mbe kajɔɔgɔ gbegele, mboo yirige mboo kan saraga we Fɔ wi yeri, mboo kapere ti kala yagawa ja. Wi yaa muwɛ tiyɔɔn culo taanri taga wa, mba pè sinmɛ pinlɛ pi ni, konaa sinmɛ litiri kɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Wi yaa keteŋgele shyɛn nakoma jɛndɛtuwaye shyɛn wɔ mbe yala wi fanŋga ki mbe ya ŋga ni ki ni. Ki sannjɛgɛlɛ ke ni, nuŋgba yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, sanna li yaa pye saraga sogowogo. ");
INSERT INTO dyi_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Pilige kɔlɔtaanri wogo ki na, wi yaa pan ki yaara nda ti yaa tɛgɛ mboo pye fyɔngɔ fu ti ni Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mberi kan saraga wɔfɔ wi yeri, wa filisaga paraga go ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Saraga wɔfɔ wi yaa simbapɔlɔ yirifɔnŋɔ ŋa wi yaa pye kajɔɔgɔ gbegele saraga wi lɛ, naa sinmɛ pi ni, mberi yirige mberi kan saraga Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Wi yaa simbapɔlɔ yirifɔnŋɔ ŋa pe yaa wɔ mbe kajɔɔgɔ gbegele wi kɔnli, mboo kasanwa pa taga wa ŋa wila wi yɛɛ piin fyɔngɔ fu wi kalige nuŋgbolo li na, wa laga ŋga pe nali furu we, mbe pa taga wa wi kalige kɛɛ yombɛgbɔgɔ konaa wi kalige tɔlɔgɔ yombɛgbɔgɔ ki na. ");
INSERT INTO dyi_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Saraga wɔfɔ wi yaa sinmɛ pa le wa wi yɛɛra kamɛŋgɛ kɛndala li ni, ");
INSERT INTO dyi_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","mboo yombɛnagala li le wa sinmɛ pi ni, mboo yanragi yanragisaga kɔlɔshyɛn wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ko puŋgo na, saraga wɔfɔ wi yaa ki sinmɛ pa taga wa lere ŋa wila wi yɛɛ piin fyɔngɔ fu wi kalige nuŋgbolo li na, wa laga ŋga pe mali furu, mbe pa taga wa wi kalige kɛɛ yombɛgbɔgɔ konaa wi kalige tɔlɔgɔ yombɛgbɔgɔ ki na, wa laga ŋga wì keli ma simbapɔlɔ yirifɔnŋɔ wi kasanwa pi taga we. ");
INSERT INTO dyi_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Sinmɛ mba pì koro wa wi kɛndala li ni, wi yaa pi wo wa lere ŋa wila wi yɛɛ piin fyɔngɔ fu wi go ki na, mbe kapyege ŋga pe ma pye mbe kapere ti kala yagawa ja ki pye wi kan Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Wi yaa keteŋgele nuŋgba lɛ nakoma jɛndɛtuwaye nuŋgba lɛ, mbe yala ŋga lerefɔ wi ya ma ta ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Wi yaa li wɔ saraga mbe kapere kala yagawa ja, mbe sannjɛlɛ sanna li wɔ saraga sogowogo mbe taga wa muwɛ saraga ki na. Pa saraga wɔfɔ wi yaa kapere ti kala yagawa ja kapyege ki pye yɛɛn lere ŋa wila wi yɛɛ piin fyɔngɔ fu wi kan Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Lere ŋa yayɛnwɛ wì ta ma kaa kɔ, fanŋga si woro wi ni wi yaara nda wi daga mbe wɔ mboo yɛɛ pye fyɔngɔ fu ti ta, ŋgasele na lì tɛgɛ wi wogo ki na loli yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yawe Yɛnŋɛlɛ làa para Moyisi naa Arɔn pe ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Na yaga ka sa ye wa Kana tara ti ni, to nda mila kaan ye yeri ti pye ye woro, na mi ka ti laga ka ka fyɛnwɛ go ka na wa ki tara nda ti yɛn ye woro ti ni, ");
INSERT INTO dyi_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","lere ŋa go yi, wi yaa saga yo saraga wɔfɔ wi kan fɔ: ‹Mì laga ka yan kì fyɛnwɛ wa na go ki na.› ");
INSERT INTO dyi_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kona saraga wɔfɔ wi yaa ti pe go ki nawa yaara ti ni fuun ti yirige funwa na, wii jɛn wi ye wa go ki ni wigi laga ki wele. Pa kona yaara nda fuun ti wa go ki ni ka kpɛ se cɛn fyɔngɔ ni. Yaara ti yirigeŋgɔlɔ, wi yaa ye wa go ki ni mbege wele. ");
INSERT INTO dyi_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Wi yaa laga ŋga kì fyɛnwɛ ki wele, na wiga ki yan ki titɛgɛ wɔ wa mbogo ki ni, ma wɔ paa yantipirige yɛn nakoma ma yanlaga gbanliŋgbanli, konaa mbe jugo mbe ye wa mbogo ki ni, ");
INSERT INTO dyi_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","wi yaa yiri wa go nawa mbe pan le yeyɔngɔ ki na, mbe go ki tɔn sa gbɔn piliye kɔlɔshyɛn. ");
INSERT INTO dyi_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Pilige kɔlɔshyɛn wogo ki na, saraga wɔfɔ wi yaa sɔngɔrɔ mbe pan mbege wele naa; na wiga ki yan ki pyɛɛlɛ wa mbogo ki na, ");
INSERT INTO dyi_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","wi yaa ti pe sinndɛɛrɛ nda tì fyɛnwɛ ti wɔ wa mbogo ki ni, mbe sari wa wa ca ki puŋgo na, wa laga ŋga ki yɛn fyɔngɔ ni ka ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Wi yaa ti pe tara nda pàa tɛgɛ ma go nawa mbogo ki wɔlɔgɔ ti gbori, mberi koli mbe sari wa wa ca ki puŋgo na, wa laga ŋga ki yɛn fyɔngɔ ni ka ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ko puŋgo na, pe yaa sinndɛɛrɛ ta yɛgɛ le wa nda pè wɔ ti yɔnlɔ, mbe joro fɔnndɔ lɛ mbe go ki wɔlɔgɔ ti ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Sinndɛɛrɛ ti wɔŋgɔlɔ wa go ki ni, a pège mbogo nawa wogo ki gbori, laga ŋga kìla fyɛnwɛ, na kiga sɔngɔrɔ mbe yiri wa go ki na naa, ");
INSERT INTO dyi_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","saraga wɔfɔ wi yaa pan mbege wele naa, na wiga ki yan laga ŋga kìla fyɛnwɛ kì sɔngɔrɔ ma yiri ma pyɛɛlɛ, kona fyɛnwɛ wi mba pì se ya kɔ mbe wɔ wa go ki na. Ki go ki yɛn fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Pe yaa ki go ki jan mbege sinndɛɛrɛ, naa ki tire konaa ki joro ti ni fuun ti koli sari wa wa ca ki puŋgo na, wa laga ŋga ki yɛn fyɔngɔ ni ka ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","«Go ki yaa pye mbe tɔn piliye yan fuun ni, lere ŋa fuun ka ye wa ki ni, wi yaa pye fyɔngɔ ni fɔ sa gbɔn yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Lere ŋa fuun ka sinlɛ wa ki go ki ni nakoma mbe yaraga ka ka wa ki go ki ni, wi daga mboo yaripɔrɔ ti jogo. ");
INSERT INTO dyi_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Na paga go ki wɔlɔgɔ naa fɔnŋgɔ, saraga wɔfɔ wiga sɔngɔrɔ mbe pan mbege wele, mbege yan laga ŋga kìla fyɛnwɛ kii sɔngɔrɔ mbe yiri naa, kona wi yaa ki yo mbege naga fɔ go ki woro fyɔngɔ ni; katugu ki fyɛnwɛ pì kɔ. ");
INSERT INTO dyi_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","«Saraga wɔfɔ wi yaa sannjɛgɛlɛ shyɛn lɛ, naa sɛdiri tige kanŋgaga ni, naa kondoro jese ni konaa yizɔpi wɛrɛ ni mbe go ki pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Cɔgɔ ŋga pè fanri joro ni ma pulugo tɔnmɔ le wa ki ni, wi yaa sannjɛgɛlɛ nuŋgba kɔnli wa ki go na. ");
INSERT INTO dyi_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ko puŋgo na, wi yaa sɛdiri tige kanŋgaga ki lɛ, naa yizɔpi wɛrɛ ti ni, naa kondoro jese wi ni, konaa sannjɛwele li ni, mberi le wa sannjɛlɛ na wì kɔnli li kasanwa pi ni wa pulugo tɔnmɔ pi ni, mboo yanragi yanragi go ki na fɔ sa ta yanragisaga kɔlɔshyɛn. ");
INSERT INTO dyi_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ki pyelɔmɔ pi na, wi yaa go ki fyɔngɔ ki kɔ ki na sannjɛlɛ li kasanwa pi ni, naa pulugo tɔnmɔ, naa sannjɛwele, naa sɛdiri tige kanŋgaga, naa yizɔpi wɛrɛ konaa kondoro jese wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ko puŋgo na, wi yaa sannjɛwele li wa wa ca ki puŋgo na, li yiri li kari wa wasele li ni. Pa wi yaa ki pye yɛɛn mbe kapere ti kala yagawa ja kapyege ki pye go ki na, mbege fyɔngɔ ki kɔ ki na.» ");
INSERT INTO dyi_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ŋgasele na lì tɛgɛ yayɛnwɛ cɛnlɛ pyew pi wogo na loli yɛɛn, konaa kawa wi wogo na, ");
INSERT INTO dyi_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","naa yaripɔrɔ nda ti ma fyɛnwɛ, ");
INSERT INTO dyi_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","naa yaritinnde, naa sasambara konaa lara nda ti ma tigi ma ye wa sɛlɛgɛ ki ni ti wogo na. ");
INSERT INTO dyi_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ki ŋgasele na lo li yaa ki naga ye na, na kaa pye lere nakoma yaraga ka woro fyɔngɔ ni, nakoma na kaa pye lere nakoma yaraga ka yɛn fyɔngɔ ni. Lo li yɛn ŋgasele na lì tɛgɛ yayɛnwɛ cɛnlɛ pyew pi wogo na. ");
INSERT INTO dyi_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi naa Arɔn pe ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","pege yo Izirayɛli woolo pe kan pe pe pye fɔ: «Na Fyomiŋge ka to naŋa wa na, ki tɔnndɔ nda ti maa yinrigi na wuun ti maa tɛgɛ fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ki tɔnndɔ ti yɛn na yinrigi wa wi nama pi ni na wuun o, wi nama wele li tɔn o, wi yaa pye fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ki naŋa wiga sinlɛ sinlɛyaraga ŋga fuun na, nakoma wiga cɛn yaraga ŋga fuun na, ki yaa pye fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Lere ŋa ka jiri ki sinlɛyaraga ki na, wi daga mboo yɛɛra yaripɔrɔ ti jogo, mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Fyomiŋge fɔ wì cɛn yaraga ŋga fuun na, lere ŋa ka cɛn ki na, wi daga mboo yɛɛra yaripɔrɔ ti jogo, mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Lere ŋa ka jiri yaŋa wi na, wi daga mboo yɛɛra yaripɔrɔ ti jogo, mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Na yaŋa wiga cɛnrɛ wa lere wa na, ŋa wi yɛn fyɔngɔ fu, wi daga mboo yɛɛra yaripɔrɔ ti jogo, mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Yaŋa wiga cɛn sofile jɔngɔ ŋga fuun na, ki jɔngɔ ki yaa pye fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Yaŋa wì cɛn yaraga ŋga fuun na, lere ŋa fuun ka jiri ki na, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. Lere ŋa fuun kaga yaraga ki lɛ, wi daga mboo yɛɛra yaripɔrɔ ti jogo, mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Yaŋa wiga jiri lere ŋa fuun na kɛɛ mbajogowo ni, ki lerefɔ wi daga mboo yɛɛra yaripɔrɔ ti jogo, mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Yaŋa wiga jiri leyaraga ŋga fuun pè gbegele joro ni ka na, ki daga pege yaari; wiga jiri leyaraga ŋga fuun pè gbegele tige ni ka na, ki daga pege jogo jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«Na yaŋa wi fyomiŋge kiga ka kɔ, wi yaa wi yɛɛ pye fyɔngɔ fu yapelege nuŋgba ni. Wi yaa wi yaripɔrɔ ti jogo, mbe woli pulugo tɔnmɔ ni, pa wi yaa cɛn fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Pilige kɔlɔtaanri wogo ki na, wi yaa keteŋgele shyɛn nakoma jɛndɛtuwaye shyɛn yigi, mbe kari ke ni wa filisaga paraga go ki yɔn na, wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mbe ke kan saraga wɔfɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Saraga wɔfɔ wi yaa sannjɛlɛ nuŋgba wɔ saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, mbe sanna li wɔ saraga sogowogo. Ko puŋgo na, wi yaa kapyege ŋga pe ma pye mbe kapere ti kala yagawa ja ki pye naŋa wi kan Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mboo pye fyɔngɔ fu tɔnndɔ nda tìla pye wuun wi na ti kala na. ");
INSERT INTO dyi_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«Na naŋa wa nama tɔnmɔ ka wo mbe ye wi ni, wi daga mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ki nama tɔnmɔ piga wo yaripɔgɔ ŋga fuun na, nakoma yaraga o yaraga pè gbegele sɛlɛgɛ ni ka na, ki daga pege jogo; ɛɛn fɔ, ki yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","«Na naŋa ka sinlɛ jɛlɛ ni, pe ni fuun shyɛn pe daga mbe woli; ɛɛn fɔ, pe yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«Na jɛlɛ wa kaa jogo, a wi kasanwa pila wuun wi na, wi yaa la jate fyɔngɔ ni fɔ sa gbɔn piliye kɔlɔshyɛn. Lere ŋa ka jiri wi na, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Mboo ta wi yɛn na jogo piliye yan ni, wiga sinlɛ sinlɛyaraga ŋga fuun na, nakoma mbe cɛn yaraga o yaraga na, ki yaa pye fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Lere ŋa fuun ka jiri ki sinlɛyaraga ki na, wi daga mboo yɛɛra yaripɔrɔ ti jogo, mbe woli. Ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Lere ŋa fuun ka jiri jɛlɛ wì cɛn yaraga o yaraga ŋga na ki na, wi daga mboo yɛɛra yaripɔrɔ ti jogo, mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Jɛlɛ wìla sinlɛ sinlɛyaraga ŋga na, na kaa pye yaraga ka la pye wa ki na, nakoma wa cɛnyaraga ŋga wìla pye ma cɛn ki na, lere ŋa fuun ka jiri ki yaraga ki na, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Na naŋa wa ka sinlɛ ki jɛlɛ wi ni, a wi jogolo kasanwa pì fa wi na, ki naŋa wi yaa pye fyɔngɔ ni fɔ sa gbɔn piliye kɔlɔshyɛn. Wiga sinlɛ sinlɛyaraga ŋga fuun na ki yaa pye fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«Na kasanwa kaa wuun jɛlɛ wa na mbe piliye lɛgɛrɛ ta, ki pye wi jogosanga wo ma, nakoma wi jogolo li ma piliye yɔn ŋga ta ki sa toro ko na, wi yaa pye fyɔngɔ ni sanga ŋa fuun kasanwa pila wuun wi na wi ni, paa yɛgɛ ŋga na wi ma pye fyɔngɔ ni, na wi kaa jogo sanga ŋa ni we. ");
INSERT INTO dyi_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Wagati ŋa fuun kasanwa pila wuun wi na, wiga sinlɛ sinlɛyaraga ŋga fuun na, nakoma mbe cɛn cɛnyaraga ŋga fuun na, ki yaa pye fyɔngɔ ni paa yɛgɛ ŋga na wi kaa jogo sanga ŋa ni ki ma pye we. ");
INSERT INTO dyi_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Lere ŋa ka jiri ki sinlɛyaraga ki na nakoma ki cɛnyaraga ki na, wi daga mboo yɛɛra yaripɔrɔ ti jogo, mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«Kasanwa mba pila wuun wi na piga ka yere, wi daga mbe piliye kɔlɔshyɛn yaga yi toro si jɛn mbe pye fyɔngɔ fu naa. ");
INSERT INTO dyi_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Piliye kɔlɔtaanri wogo ki na, wi yaa keteŋgele shyɛn nakoma jɛndɛtuwaye shyɛn yigi mbe sa ke kan saraga wɔfɔ wi yeri wa filisaga paraga go ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Saraga wɔfɔ wi yaa nuŋgba wɔ saraga mbe kapere kala yagawa ja, mbe sanna li wɔ saraga sogowogo. Ko puŋgo na, wi yaa kapere ti kala yagawa ja kapyege ki pye jɛlɛ wi kan Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ wi kasanwa wogo fyɔngɔ ki kala na. ");
INSERT INTO dyi_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«Pa ye yaa ki pye yɛɛn mbe Izirayɛli woolo pe lali ŋga ki mbe ya pe tɛgɛ fyɔngɔ ni ki ni; kona pe se kanla cɛnsaga paraga go ki tɛgɛ fyɔngɔ ni mbe ku, ko ŋga mi yɛn ma cɛn laga ki ni ye sɔgɔwɔ we.» ");
INSERT INTO dyi_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ki ŋgasele na lo lì tɛgɛ, na fyomiŋge ka to naŋa wa na, nakoma wi nama tɔnmɔ piga wo mbe ye wi ni mboo tɛgɛ fyɔngɔ ni, ");
INSERT INTO dyi_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","konaa jɛlɛ kaa jogo, naa kasanwa kaa wuun naŋa nakoma jɛlɛ na, konaa na naŋa ka sinlɛ jɛlɛ ŋa wi yɛn fyɔngɔ ni wa ni. ");
INSERT INTO dyi_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Arɔn pinambiile shyɛn pe kuŋgɔlɔ, poro mbele pàa ku katugu pàa kari wusuna nuwɔ taan ni Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, ŋa wi sila ki kologo kan, a Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Làa wi pye fɔ: «Ki yo ma ndɔ Arɔn wi kan fɔ wiga kaa yiin wa cɛnsaga paraga go ki lajɛŋgɛ kpoyi ki ni sanga pyew, wa paraga ŋga pè pɔ maga kɔn shyɛn ki puŋgo na, ko ŋga yɔn finliwɛ kɛsu wo naa kasulugo pyesaga ŋga ki yɛn wi yaritɔnŋgɔ ti yɛn ma tɛgɛ wa we, jaŋgo na mi kanla yɛɛ naga kambaaga ka ni, wa kasulugo pyesaga ki go na, wiga ka ku. ");
INSERT INTO dyi_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«Arɔn wi mbe ya ye yɛgɛ ŋga na wa lajɛŋgɛ kpoyi ki ni ki ŋga: Wi yaa napɔlɔ yirifɔnŋɔ nuŋgba yigi mboo pye kapere kala yagawa jasaraga, naa simbapɔlɔ nuŋgba ni, mboo pye saraga sogowogo. ");
INSERT INTO dyi_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Wi yaa wi derigbɔgɔ ŋga pè ti lɛn jese ni ki le, mboo kurusi wenɛ na pè ti lɛn jese ni li le, mbe kurusijara ŋa pè ti lɛn jese ni wi pɔ konaa mbe gbɔgɔwɔ njala na pè ti lɛn jese ni li kan. Wi daga mbe woli si jɛn mbege yaripɔrɔ nda tì tɛgɛ ti yɛ Yɛnŋɛlɛ kan ti le. ");
INSERT INTO dyi_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Izirayɛli gbogolomɔ woolo pe yaa pan mbe sikapɛnɛ shyɛn kan wi yeri mbe pe pye kapere ti kala yagawa jasaraga, naa simbapɔlɔ nuŋgba ni, mboo pye saraga sogowogo. ");
INSERT INTO dyi_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","«Napɔlɔ ŋa Arɔn wi yaa wɔ saraga mboo yɛɛra kapere ti kala yagawa ja, wi yaa pan wi ni, mbe kapere ti kala yagawa ja kapyege ki pye wi yɛɛ kan konaa wi go woolo pe kan. ");
INSERT INTO dyi_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ko puŋgo na, wi yaa pan sikapɛnɛ shyɛn pe ni Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, wa filisaga paraga go ki yɔn na, ");
INSERT INTO dyi_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","mbe pɛtɛ gbɔn mbe ta mbe ŋa wi yaa wɔ saraga Yawe Yɛnŋɛlɛ li yeri wi jɛn konaa mbe ŋa pe yaa wa wila kee wi jɛn. ");
INSERT INTO dyi_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Pɛtɛ gbɔngɔ kiga sikapɔlɔ ŋa wɔ Yawe Yɛnŋɛlɛ li kan, Arɔn wi yaa wi wɔ li yeri saraga mbe kapere ti kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Pɛtɛ gbɔngɔ kì sikapɔlɔ ŋa wɔ poo wa wila kee, pe yaa pan wi ni wee Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mbe kapere ti kala yagawa ja kapyege ki pye wi na, mbe si jɛn mboo wa wila kee wa gbinri wi ni paa sikapɔlɔ ŋa pe ma wa wila kee we. ");
INSERT INTO dyi_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Ko puŋgo na, napɔlɔ ŋa Arɔn wi yaa wɔ mboo yɛɛra kapere ti kala yagawa ja wi yaa pan wi ni, mbe kapere ti kala yagawa ja kapyege ki pye wi yɛɛ kan konaa wi go woolo pe kan. Wi yaa napɔlɔ ŋa wì wɔ mboo kapere ti kala yagawa ja wi kɔnli. ");
INSERT INTO dyi_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ko pyeŋgɔlɔ, wi yaa naŋganra wɔyaraga ki lɛ mbe kasɔn naŋganra ta wɔ wa saraga wɔsaga ki ni mbege yin Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mbe si wusuna nuwɔ taan muwɛ kɛɛ yɛnlɛ shyɛn lɛ mbe ye ti ni fuun ti ni wa paraga ŋga pè pɔ ma cɛnsaga paraga go ki kɔn shyɛn ki puŋgo na. ");
INSERT INTO dyi_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Arɔn wi yaa ki wusuna nuwɔ taan wi wo wa kasɔn naŋganra ti na le Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ; jaŋgo yɔn finliwɛ sɛnrɛ kɛsu we, kasulugo pyesaga ŋga ki yɛn wi yaritɔnŋgɔ, wusuna wirige ki yiri ki tɔn ki na. Kiga pye ma wi se ku. ");
INSERT INTO dyi_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Wi yaa napɔlɔ wi kasanwa pa lɛ mbe yombɛlɛ tɛgɛ mboo yanragi yanragi wa kasulugo pyesaga ki yɔnlɔ yirisaga kɛɛ yeri, ko puŋgo na mbe pa yanragi yanragisaga kɔlɔshyɛn wa kasulugo pyesaga ki yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ko puŋgo na, sikapɔlɔ ŋa wi yaa wɔ mbe leele pe kapere ti kala yagawa ja, wi yaa wi kɔnli mboo kasanwa pi lɛ mbe ye pi ni wa paraga ŋga pè pɔ ma cɛnsaga paraga go ki kɔn shyɛn ki puŋgo na. Wì napɔlɔ wi kasanwa pi pye yɛgɛ ŋga na, wi yaa sikapɔlɔ wi kasanwa pi pye ma fun. Wi yaa pa yanragi yanragi kasulugo pyesaga ki na, mbe pa yanragi yanragi wa ki yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Anmɛ wi yaa kapere ti kala yagawa ja kapyege ki pye lajɛŋgɛ kpoyi ki kan mbege pye fyɔngɔ fu, Izirayɛli woolo pe fyɔngɔ kagala, naa pe mbasinmɛ kagala konaa pe kapere cɛnlɛ na fuun pè pye maga tɛgɛ fyɔngɔ ni ki kala na. Wi yaa ki nuŋgba ki pye fun filisaga paraga go ki laga sanŋga ki na, ko ŋga ki yɛn ma kan wa poro naa pe fyɔngɔ kagala ke sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Na Arɔn wiga ye wa filisaga paraga go ki ni, wa lajɛŋgɛ kpoyi ki ni mbaa kapere ti kala yagawa ja kapyege ki piin sanga ŋa ni, lere si daga mbe pye wa ki ni fɔ wi sa yiri. Wi yaa kapere ti kala yagawa ja kapyege ki pye wi yɛɛ kan, naa wi go woolo pe kan konaa Izirayɛli gbogolomɔ woolo pe ni fuun pe kan. ");
INSERT INTO dyi_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ko puŋgo na, wi yaa yiri mbe pan wa saraga wɔsaga ŋga wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ ki tanla, mbe kapere ti kala yagawa ja kapyege ki pye ki kan; kona mbe si napɔlɔ wi kasanwa pa lɛ konaa sikapɔlɔ wi woo pa ni, mboo fafa wa saraga wɔsaga ki yɛnŋgɛlɛ ke lagapyew ki na. ");
INSERT INTO dyi_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Wi yaa yombɛlɛ nuŋgba le wa kasanwa pi ni mboo yanragi yanragisaga kɔlɔshyɛn wa saraga wɔsaga ki na. Anmɛ wi yaa ki pye mbege tɛgɛ fyɔngɔ fu, mbe Izirayɛli woolo pe fyɔngɔ kagala ke laga ki na, mbege pye kpoyi. ");
INSERT INTO dyi_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Na Arɔn wiga kapere ti kala yagawa ja kapyege ki pye mbe kɔ lajɛŋgɛ kpoyi ki kan, naa filisaga paraga go ki laga sanŋga konaa saraga wɔsaga ki kan, wi yaa ti pe pan sikapɔlɔ wee wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Arɔn wi yaa wi kɛyɛn shyɛn yi taga wa wi go ki na, mbe Izirayɛli woolo pe punŋguwɔ kagala ke ni fuun, naa pe mbasinmɛ kagala ke ni fuun konaa pe kapere ti ni fuun ti yo mberi taga wa wi go ki na. Ko puŋgo na, wi yaa wi torogo wa gbinri wi ni, mboo le lere ŋa pè wɔ ki wogo ki na wi kɛɛ wi kari wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Kiga pye ma, sikapɔlɔ wi yaa Izirayɛli woolo pe kapere ti go kala li lɛ, mbe kari wasege waga ka ni. «Na paga kaa purɔ mboo wa wa gbinri wi ni sanga ŋa ni, ");
INSERT INTO dyi_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","kona Arɔn wi yaa sɔngɔrɔ wa filisaga paraga go ki ni. Yaripɔrɔ nda pè ti lɛn jese ni, to nda wìla le ma ye wa lajɛŋgɛ kpoyi ki ni, wi yaa ti wɔ wi yɛɛ na mberi tɛgɛ le, ");
INSERT INTO dyi_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","mbe woli laga kpoyi ka ni, mboo yaripɔrɔ sannda ti le wi yɛɛ na. Ko puŋgo na, wi yaa yiri mbe kari sa saraga sogowogo wɔ wi yɛɛ kan konaa mbe ka wɔ leele pe kan fun, jaŋgo mbe kapere ti kala yagawa ja kapyege ki pye wi yɛɛ kan konaa leele sanmbala pe kan. ");
INSERT INTO dyi_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Kona wi yaa yaayogo ŋga pè wɔ saraga mbe kapere ti kala yagawa ja ki yanlaga ki sogo wa saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Sikapɔlɔ ŋa pe yaa wa wila kee, naŋa ŋa wi yaa wi purɔ mboo torogo wa gbinri wi ni, wi daga mboo yaripɔrɔ ti jogo, mbe woli; ko puŋgo na, mbe si sɔngɔrɔ wa paara yinrɛ cɛnsaga ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Napɔlɔ wo naa sikapɔlɔ ŋa pè wɔ saraga ma kapere ti kala yagawa ja, a pè pe kasanwa pi lɛ ma ye pi ni wa laga kpoyi ki ni, ma kapyege ŋga pe ma pye mbe kapere ti kala yagawa ja ki pye, pe daga mbe pe lɛ mbe kari pe ni wa paara yinrɛ cɛnsaga ki puŋgo na, mbe sa pe sɛɛrɛ, naa pe kara konaa pe lara ti sogo wa. ");
INSERT INTO dyi_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Lere ŋa wi yaa ti sogo wi yaa wi yaripɔrɔ ti jogo, mbe woli si jɛn mbe sɔngɔrɔ wa paara yinrɛ cɛnsaga ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Ŋgasele laa na, na li yaa pye kɔsaga fu ye kan: ‹Yɛlɛ li yeŋge kɔlɔshyɛn wogo ki pilige kɛ wogo ki na, ye yaa yeŋge le, ye se tunŋgo ka kpɛ pye ki pilige ki ni, yoro Izirayɛli tara piile konaa nambannjɛɛnlɛ mbele pe yɛn laga ye sɔgɔwɔ pe ni. ");
INSERT INTO dyi_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Katugu ko pilige koyi pe yaa kapere ti kala yagawa ja kapyege ki pye ye kan, mbe ye kapere ti laga ye na, mbe ye pye fyɔngɔ fu. Kiga pye ma, ye yaa pye fyɔngɔ fu Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ki pilige ki yaa pye cɛnpilige ye kan, ye yaa wogo ki pilige ki ni mbe yeŋge le. Ki ŋgasele na li yaa pye kɔsaga fu.› ");
INSERT INTO dyi_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","«Saraga wɔfɔ ŋa pe yaa ka sinmɛ kpoyi wo wi na mboo tɛgɛ saraga wɔgɔtunŋgo ki na, wa saraga wɔfɛnnɛ to wi yɔnlɔ, wo wi yaa kaa kapyege ŋga pe ma pye mbe kapere ti kala yagawa ja ki piin. Yaripɔrɔ nda pè ti lɛn jese ni mari tɛgɛ ti yɛ Yɛnŋɛlɛ kan, wo wi yaa lari nii. ");
INSERT INTO dyi_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Wi yaa kapere ti kala yagawa ja kapyege ki pye lajɛŋgɛ kpoyi ki kan, naa filisaga paraga go ki laga sanŋga ki kan konaa saraga wɔsaga ki kan; wi yaa kapyege ŋga pe ma pye mbe kapere ti kala yagawa ja ki pye fun saraga wɔfɛnnɛ pe kan konaa Izirayɛli gbogolomɔ woolo pe ni fuun pe kan. ");
INSERT INTO dyi_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","«Ki wogo ki yɛn ŋgasele na li yɛn kɔsaga fu ye kan. Yɛlɛ pyew, pe yaa kapere ti kala yagawa ja kapyege ki pye pyesaga nuŋgba Izirayɛli woolo pe kan pe kapere ti ni fuun ti kala na.» A Arɔn wì si ŋga fuun Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan ki pye. ");
INSERT INTO dyi_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","wigi sɛnrɛ nda ti yo Arɔn, naa wi pinambiile konaa Izirayɛli woolo sanmbala pe ni fuun pe kan wi pe pye fɔ ŋga Yawe Yɛnŋɛlɛ lì yo ki ŋga: ");
INSERT INTO dyi_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","«Yoro Izirayɛli woolo, na wa kaa jaa mbe nɛgɛ nakoma sumbyɔ, nakoma sugbɔ kɔnli laga paara yinrɛ cɛnsaga ki ni, nakoma wa ki puŋgo na, ");
INSERT INTO dyi_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ki fɔ wi daga mbe kari ki yaayogo ki ni wa filisaga paraga go ki yɔn na, mbege wɔ yarikanga Yawe Yɛnŋɛlɛ li yeri wa cɛnsaga paraga go ki yɛgɛ. Na wii ko pye, pa wi yaa la jate wì kapege pye ma yaraga ŋga yinwege na ka kasanwa wo, ki kologo si ma. Pe yaa wi purɔ mboo wɔ wa Izirayɛli gbogolomɔ woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ki ŋgasele li yaa ti Izirayɛli woolo pe se kaa pe saara yaayoro ti kuun wa wasege ki ni, ɛɛn fɔ, pe yaa la paan ti ni saraga wɔfɔ wi kɔrɔgɔ wa filisaga paraga go ki yɔn na, mbaa ti woo Yawe Yɛnŋɛlɛ li yeri nayinmɛ saara. ");
INSERT INTO dyi_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kona saraga wɔfɔ wi yaa yaayogo ki kasanwa pa yanragi Yawe Yɛnŋɛlɛ li saraga wɔsaga ki na, wa filisaga paraga go ki yɔn na. Ko puŋgo na, wi yaa yanlaga ki sogo wa ki saraga wɔsaga ki na, ko ŋga ki nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla we. ");
INSERT INTO dyi_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Kiga pye ma, sikapɛnɛ yanlɛɛlɛ mbele Izirayɛli woolo pè gbegele yarisunndo na nanjara piin nari gbogo, ma je we Fɔ wi na, pe se kaa saara woo ti yeri naa. Ki yɛn ŋgasele na li yɛn kɔsaga fu yoro naa ye setirige piile mbele fuun pe yaa ka yiri ye kan. ");
INSERT INTO dyi_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«Na Izirayɛli woo nakoma pe nambanŋa wa kaa jaa mbe saraga sogowogo wɔ, nakoma saraga ka yɛgɛ, ");
INSERT INTO dyi_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","wi daga mbe pan yaayogo ki ni wa filisaga paraga go ki yɔn na, mbege wɔ saraga Yawe Yɛnŋɛlɛ li yeri. Na wi sigi pye ma, wi daga poo purɔ poo wɔ Izirayɛli gbogolomɔ woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«Na Izirayɛli woo nakoma nambanŋa wa ka kasanwa ka, ki kasanwa pi yɛn yɛgɛ o yɛgɛ, mi ŋa Yɛnŋɛlɛ mi yaa yiri wi kɔrɔgɔ, mboo purɔ mboo wɔ wa wi woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Katugu yaraga ŋga fuun ki da, pa ki yinwege ki yɛn wa ki kasanwa pi ni. Yawe Yɛnŋɛlɛ lìgi konɔ kan ye yeri, jaŋgo yaa kapere ti kala yagawa ja kapyege ki piin pi ni, wa saraga wɔsaga ki na ye yɛɛ kan. Kasanwa pi ma ti lere wi ma kapere kala yagawa ta, katugu pa yinwege ki yɛn wa pi ni. ");
INSERT INTO dyi_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ko kala ki ti mìgi yo Izirayɛli woolo pe kan fɔ: ‹Ye ni, wa kpɛ ka ka kasanwa ka, nambanmbala mbele pe yɛn ma cɛn laga ye sɔgɔwɔ, wa kpɛ ka ka kasanwa ka.› ");
INSERT INTO dyi_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«Na Izirayɛli woo nakoma pe nambanŋa wa ka kari yanrisaga mbe woŋgbɔ nakoma sannjɛlɛ gbo, a kì pye kara nda ti yɛn kaworo to ta, wi yaa ki yaraga ki kɔnli mbege kasanwa pi wo tara, mbe tara ta tɛgɛ mboo tɔn. ");
INSERT INTO dyi_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Yaraga ŋga fuun kì da ma pye yinwege na, pa ki yinwege ki yɛn wa ki kasanwa pi ni. Ko kala ki ti Yawe Yɛnŋɛlɛ lìgi yo yoro Izirayɛli woolo ye kan fɔ: ‹Yaga ka yaraga ŋga fuun kì da ka kasanwa ka; katugu ki yinwege ki yɛn wa ki kasanwa pi ni. Na lere ŋa fuun ka kasanwa ka, wi daga poo purɔ poo wɔ Izirayɛli woolo pe sɔgɔwɔ.› ");
INSERT INTO dyi_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«Lere o lere, wi yɛn Izirayɛli tara pyɔ o, nakoma nambanŋa o, na wa ka yarikugo nakoma woŋgbɔ ŋa cɛngɛ gbo wa kara ka, wi yaa wi yaripɔrɔ ti jogo, mbe woli; ɛɛn fɔ, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. Ko puŋgo na, wi yaa pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ɛɛn fɔ, na ki fɔ wiga je wi suu yaripɔrɔ ti jogo, wii si woli, wi yaa wi kapege ki go kala li lɛ.» ");
INSERT INTO dyi_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","wigi sɛnrɛ nda ti yo Izirayɛli woolo pe kan fɔ: «Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ezhipiti tara nda yàa pye ma cɛn wa ti ni, kagala ŋgele ti woolo pàa pye na piin, yaga kaa ke piin. Mila kee ye ni wa Kana tara nda ni, kagala ŋgele pe yɛn na piin wa, yaga ka saa ke piin. Yaga ka saa tanri ki tara woolo pe kalɛgɛlɛ ke na. ");
INSERT INTO dyi_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Yaa tanri na kakɔnndɛgɛŋgɛlɛ koro naa na ŋgasegele ke na; katugu muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","«Yaa tanri na kakɔnndɛgɛŋgɛlɛ naa na ŋgasegele ke na. Lere ŋa kaa tanri ke na, wi yaa yinwege ta ke fanŋga na. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«Yoro Izirayɛli woolo wa kpɛ si daga mbe sinlɛ wi go lere ni. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«Maga kɔɔn to wi tifaga mbe sinlɛ ma yɛɛra nɔ wi ni. Kiga pye ma, mɔ̀ɔ nɔ wi tifaga fun; katugu ma nɔ wi. ");
INSERT INTO dyi_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«Maga ka sinlɛ ma to jɔ wa yɛgɛ ni; kiga pye ma, mɔ̀ɔ to wi tifaga. ");
INSERT INTO dyi_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«Ma njɔ nakoma ma jɔnlɔ sumboro ŋa wi yɛn to nuŋgba ma ni, nakoma nɔ nuŋgba ma ni, a pòo koro wa ye go, nakoma go ka yɛgɛ ni, maga ka sinlɛ wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«Maga ka sinlɛ ma pishyɛnwoo ni, ko kɔrɔ wo yɛn ma pinambyɔ wi sumborombyɔ nakoma ma sumborombyɔ wi sumborombyɔ ni; kiga pye ma, ma yaa ma yɛɛ tifaga. ");
INSERT INTO dyi_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«Maga ka sinlɛ ma to jɔ wa yɛgɛ sumborombyɔ ni; katugu wi yɛn ma to wi sumborombyɔ, ma pye ma njɔ nakoma ma jɔnlɔ sumboro. ");
INSERT INTO dyi_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«Maga ka sinlɛ ma to wi nɔsepyɔ sumboro wa ni; katugu wi yɛn ma to wi go lere. ");
INSERT INTO dyi_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","«Maga ka sinlɛ ma nɔ wi nɔsepyɔ sumboro wa ni; katugu wi yɛn ma nɔ wi go lere. ");
INSERT INTO dyi_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«Maga kɔɔn to wi nɔsepyɔ lenaŋa wa tifaga mbe sinlɛ wi jɔ wi ni; katugu wi yɛn ma nijɛ. ");
INSERT INTO dyi_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«Maga ka sinlɛ ma pinambyɔ wa jɔ ni; katugu wi yɛn ma pijɔ, maga ka sinlɛ wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","«Maga ka sinlɛ ma nɔsepyɔ lenaŋa wa jɔ ni; kiga pye ma, ma yaa ma nɔsepyɔ lenaŋa wi tifaga. ");
INSERT INTO dyi_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«Maga ka sinlɛ jɛlɛ wa ni, mbe sinlɛ wi sumborombyɔ ni. Maga ka sinlɛ ki jɛlɛ wi pishyɛnwoo ŋa wi yɛn jɛlɛ wa ni, ko kɔrɔ wo yɛn wi pinambyɔ wo sumborombyɔ nakoma wi sumborombyɔ wo sumborombyɔ ni; katugu pe yɛn ki jɛlɛ wi go leele. Ki kala li yɛn katijaanga. ");
INSERT INTO dyi_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«Maga kɔɔn jɔ wi nɔsepyɔ sumboro wa pɔri ma jɔ mbe sinlɛ wi ni, mbe njɔfɔ wi ta yinwege na; katugu ki mbe ya yenjara yirige njɔ wo naa jɔnlɔ pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«Maga ka sinlɛ jɛlɛ wa ni wi jogosanga wi ni; katugu wi yɛn fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«Maga ka sinlɛ ma lewee yɛnlɛ wa jɔ ni, mbɔɔn yɛɛ tɛgɛ fyɔngɔ ni wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«Maga kɔɔn piile wa wɔ saraga mboo kan yarisunŋgo Molɔki ki yeri; kiga pye ma, ma yaa na mɛgɛ ki tifaga. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«Maga ka sinlɛ ma naŋa yɛnlɛ ni paa yɛgɛ ŋga na pe ma sinlɛ jɛlɛ ni. Ki kala li yɛn katijaanga. ");
INSERT INTO dyi_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«Maga ka sinlɛ yaayogo ni mbɔɔn yɛɛ tɛgɛ fyɔngɔ ni ki ni. Jɛlɛ si daga mboo yɛɛ kan yaayogo yeri ki sinlɛ wi ni; ki kapyege ki yɛn kala na li yɛn ma piri. ");
INSERT INTO dyi_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«Yaga ka ki kagala ŋgele la kpɛ pye mbe ye yɛɛ tɛgɛ fyɔngɔ ni, katugu cɛngɛlɛ ŋgele mi yaa ke woolo pe purɔ wa ye yɛgɛ, ki kagala ŋgele koro pe maa piin, ma pe yɛɛ tɛgɛ fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Pe tara ti ni fuun ti yɛn fyɔngɔ ni ki kagala ke kala na. Ko ki ti mi yaa jɔlɔgɔ wa wa tara ti ni pe mbasinmɛ pi kala na. Ki tara tì je ti woolo pe na. ");
INSERT INTO dyi_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","«Ki kala na, yoro Izirayɛli tara piile naa nambannjɛɛnlɛ mbele pe yɛn laga ye sɔgɔwɔ, yaa tanri na ŋgasegele koro naa na kakɔnndɛgɛŋgɛlɛ ke na. Yaga ka ki katijangara ta kpɛ pye. ");
INSERT INTO dyi_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Leele mbele pàa pye ma cɛn wa ki tara ti ni ye yɛgɛ, pàa pye na ki katijangara ti piin ma tara ti tɛgɛ fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Yoro wo na, yaga kari tɛgɛ fyɔngɔ ni naa, jaŋgo tiga ka je ye na paa yɛgɛ ŋga na mbele pàa pye ma cɛn wa ti ni ye yɛgɛ tìla je pe na we. ");
INSERT INTO dyi_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Leele mbele fuun pe yaa kaa ki katijangara nda ta piin, pe yaa ka pe purɔ mbe pe wɔ wi woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","«Sɛnrɛ nda fuun mì yo ye kan, yeri lɛ yaa tanri ti na. Katijangara nda pàa keli na piin wa tara ti ni na ye fa pan, yaga kaa ta kpɛ piin, jaŋgo mbe ye yɛɛ tɛgɛ fyɔngɔ ni ti pyewe pi kala na. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","wigi sɛnrɛ nda ti yo Izirayɛli gbogolomɔ woolo pe kan wi pe pye fɔ: «Ye pye kpoyi, katugu mi ŋa Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le, mi yɛn kpoyi. ");
INSERT INTO dyi_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","«Ye ni fuun nuŋgba nuŋgba yaa ye teele naa ye nɛɛlɛ pe gbogo, yaa na cɛnpilige ki cɛɛn. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«Yaga kaa yarisunndo ti gbogo, yaga ka tugurɔn yan mbe yarisunndo gbegele ye yɛɛ kan. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«Na ye kaa nayinmɛ saraga woo mi ŋa Yawe Yɛnŋɛlɛ na yeri, ye yaa ki wɔ mbe yala ki wɔlɔmɔ pi ni jaŋgo mbe yɛnlɛ ki na. ");
INSERT INTO dyi_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ye mbe ya mbe saraga kara ti ka saraga ki wɔpilige ki ni nakoma ki goto; nda ka koro sa gbɔn pilige taanri wogo ki na, yeri sogo. ");
INSERT INTO dyi_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Pilige taanri wogo ki na, na lere wa ka ki kara ta ka, ki saraga ki yaa pye fyɔngɔ yaraga, ki se yigi. ");
INSERT INTO dyi_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Lere ŋa ka ta ka, wi yaa wi kapege ki go kala li lɛ, katugu yaraga ŋga ki le mi ŋa Yawe Yɛnŋɛlɛ na kɛɛ, wìgi tɛgɛ fyɔngɔ ni. Wi daga poo purɔ poo wɔ wi woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«Na yaga ka saa ye yarilire ti kɔɔn wa ye tara sanga ŋa ni, kɛrɛfɔ wiga ka yarilire ti kɔn mbe gbɔn wa kɛrɛ koŋgo ki na. Laga ŋga wì kɔn, shegele ŋgele kè toori wa, wiga ka sɔngɔrɔ mbe sa ke wulo. ");
INSERT INTO dyi_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ki pyelɔmɔ nuŋgba pi na, ye ɛrɛzɛn pire ti cɔŋgɔlɔ, ye se ka sɔngɔrɔ wa ye ɛrɛzɛn kɛɛrɛ ti ni mbe sa shashara nda tì koro wa ti cɔ konaa mbe pire nda tì toori tara ti wulo. Ye yaa to yaga fyɔnwɔ fɛnnɛ naa nambanmbala pe kan peri wulo. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«Yaga kaa yuun, yaga kaa finlɛlɛ, yaga kaa ye yɛɛ fanla. ");
INSERT INTO dyi_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Yaga ka wugu na mɛgɛ ki na, katugu na yaga ki pye ma, ye yaa mi ŋa ye Yɛnŋɛlɛ na mɛgɛ ki tifaga. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«Maga kaga yerege ma lewee yɛnlɛ wa na, mbaa nii wi go na. Maga ka yu. Maga kɔɔn tunmbyee wi sara wi yaga wa ma yɛɛ yeri sa gbɔn ki goto. ");
INSERT INTO dyi_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Maga ka nuŋgbojili wa tɛgɛlɛ. Maga ka yaraga ka tɛgɛ fyɔɔn wa yɛgɛ, ŋga wi mbe kurugo ki na. Ɛɛn fɔ, yaa fyɛ na yɛgɛ. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«Yaga ka kambasinŋge pye kiti kɔnkala la ni. Maga ka fyɔnwɔ fɔ wi mbɔnrɔ lere wa na wi fyɔnwɔ pi kala na; maga si ka legbɔɔ wi mbɔnrɔ lere wa na wi legbɔgɔwɔ pi kala na. Ɛɛn fɔ, maa ma leweele yɛɛnlɛ pe kiti wi kɔɔn maa yala ŋga ki yɛn ma sin ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Maga kaa ye woolo pe mɛgɛ jogo la toro; maga ka yagbolo sɛrɛya yo mbe taga ma lewee yɛnlɛ na mbe ti poo gbo. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«Maga ka ma lewee yɛnlɛ wa panra wa ma nawa. Ɛɛn fɔ, ma daga mboo yɛri ŋgbanga wi kapyege ki na, jaŋgo kiga ka pye kapege ma go na wi kala na. ");
INSERT INTO dyi_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Maga ka kayaŋga wɔ ma yɛ, maga si ka gbu tɛgɛ ma nawa ma lewee yɛnlɛ wi ni. Ɛɛn fɔ, ma lewee yɛnlɛ wi daga mbɔɔn ndanla paa yɛgɛ ŋga na mɔɔ yɛɛ ndanla. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«Yaa tanri na ŋgasegele ke na. Maga ka ti ma yaayoro ti cɛnlɛ shyɛn, naŋa naa jɛlɛ, mbe lugu ti yɛɛ na. Maga ka yariluguro cɛnlɛ shyɛn lugu wa kɛrɛ nuŋgba ti ni. Maga ka yaripɔgɔ le ŋga pè ti jese cɛnlɛ shyɛn ni. ");
INSERT INTO dyi_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«Na naŋa wa ka sinlɛ kulojɔ wa ni, ŋa pè kan naŋa wa yɛgɛ yeri, ki pye pe fa kulojɔ wi go shɔ, wi fa si wɔ wa kulowo pi ni, ŋa wì sinlɛ wi ni, wi yaa tɔnŋgɔ yaara ti wɔ. Ɛɛn fɔ, pee daga mbe pe gbo, katugu jɛlɛ wi fa wɔ wa kulowo pi ni gbɛn. ");
INSERT INTO dyi_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ki naŋa wi yaa pan simbapɔlɔ ni wa filisaga paraga go ki yɔn na, wi kapege ŋga wì pye ki kala na, mboo wɔ Yawe Yɛnŋɛlɛ li yeri saraga ŋga pe ma wɔ mbe kajɔɔgɔ gbegele. ");
INSERT INTO dyi_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Saraga wɔfɔ wi yaa kapere kala yagawa ja kapyege ki pye ki naŋa wi kan, kapege ŋga wì pye ki kala na, Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, kapere kala yagawa ja simbapɔlɔ wi ni; pa wi kapere ti yaa kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«Na yaga ka sa ye wa Kana tara ti ni, mbe tire nda ti maa sɛni ti cɛnlɛ pyew ta lugu, yɛgɛlɛ koŋgbanŋgala taanri ke ni, pire nda ti yaa sɛ, ye yaa la to jate fyɔngɔ ni. Yaga ka ta ka. ");
INSERT INTO dyi_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Yɛlɛ tijɛrɛ wolo li na, tiga pire nda fuun sɛ, ye yaa ti le mi ŋa Yawe Yɛnŋɛlɛ na kɛɛ fɛti wa nɔgɔ mbanla sɔn. ");
INSERT INTO dyi_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Yɛlɛ kaŋgurugo wolo li na, ye yaa lari pire ti kaa. Na ye kaa ki piin ma, pa ye tire ti yaa la sɛni lɛgɛrɛ lɛgɛrɛ. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«Yaga ka yaraga ka kara ka wa laga ŋga pège kasanwa pi wo. Yaga kaa kajɛnmɛ piin, yaga si kaa jɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Yaga kaa ye yinrɛ ti nɔgɔ woo. Yaga si kaa ye siyɔ wi kanŋgara ti kunlu. ");
INSERT INTO dyi_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Yaga ka ye witige laga ka kɔɔnlɔ kɔɔnlɔ mbege naga fɔ ye yɛn na kunwɔ gbele. Yaga si ka njelewe gbɔn ye witige laga ka na. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«Yaga ka ye sumborombiile pe le nanjara ni mbe pe tifaga, jaŋgo leele paga ka ye kɛɛnrɛ limɛ pi ni laga tara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Yaa na cɛnpilige ki cɛɛn, yaa na cɛnsaga paraga go ki jate. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«Yaga kaa kee kuulo yewefɛnnɛ pe kɔrɔgɔ saa pe yewe konaa jɛlɛfɛnnɛ pe kɔrɔgɔ saa jɛlɛ pe yeri; katugu ki yaa ye tɛgɛ fyɔngɔ ni. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«Ma daga mbaa yinrigi la fɔli lelɛŋgbaara ti yɛgɛ sɔgɔwɔ lari gbogo. Pa ma yaa laga piin ma mbaa mi ŋa ma Yɛnŋɛlɛ na gbogo. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«Na nambanŋa wa ka sa cɛn wa ye tara, yaga kaa tɛgɛ mbaa nii wi go na. ");
INSERT INTO dyi_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ɛɛn fɔ, yoo yigi paa ye tara pyɔ yɛn. Wi daga mbe ye ndanla paa yɛgɛ ŋga na ye yɛn ma ye yɛɛ ndanla we, katugu yoro fun yàa pye nambanmbala wa Ezhipiti tara. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«Yaga ka kambasinŋge pye kiti kɔnkala ni, nakoma mɛtɛrɛ wogo na, nakoma culo wogo na, nakoma tiwiyaraga wogo na. ");
INSERT INTO dyi_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Yaa taanla culo ŋa wì yala wo ni, naa puwakuru ŋa wì yala konaa litiri ŋa wì yala wo ni. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ na làa ye yirige wa Ezhipiti tara. ");
INSERT INTO dyi_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","«Yaa tanri na ŋgasegele naa na kakɔnndɛgɛŋgɛlɛ ke ni fuun ke na, yaa ke piin. Muwi mi yɛn Yawe Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","wigi sɛnrɛ nda ti yo Izirayɛli woolo pe kan fɔ: «Na Izirayɛli woo nakoma nambanmbala mbele pe yɛn ma cɛn wa pe sɔgɔwɔ, wa ka wi pyɔ wɔ saraga yarisunŋgo Molɔki ki yeri, ki daga pege fɔ wi gbo. Tara woolo sanmbala pe yaa wi wa sinndɛɛrɛ ni mboo gbo. ");
INSERT INTO dyi_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mi jate mi yaa yiri ki lerefɔ wi kɔrɔgɔ mboo purɔ mboo wɔ Izirayɛli woolo sanmbala pe sɔgɔwɔ, katugu wùu piile wa wɔ saraga Molɔki yeri mala cɛnsaga paraga go ki tɛgɛ fyɔngɔ ni konaa mi yɛn kpoyi yɛgɛ ŋga na maga tifaga. ");
INSERT INTO dyi_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Tara woolo na paga yɛngɛlɛ tɔn ki kapyege ki na, mbaa ki piin ndɛɛ ŋga ki naŋa wila piin pe woro naga yaan, na pe suu gbo, ");
INSERT INTO dyi_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","pa kona mi jate mi yaa yiri ki naŋa wo naa wi go woolo pe kɔrɔgɔ konaa mbele fuun pe yaa taga wi na, mbaa nanjara piin, mbaa Molɔki wi gbogo pe kɔrɔgɔ, mbe pe purɔ mbe pe wɔ Izirayɛli woolo sanmbala pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«Na lere wa ka kari kuulo yewefɛnnɛ naa jɛlɛfɛnnɛ pe kɔrɔgɔ sa jɛlɛ pe yeri mbe yɛɛ tɛgɛ fyɔngɔ ni, mi yaa yiri ki fɔ wi kɔrɔgɔ mboo purɔ mboo wɔ wi woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","«Ye ye yɛɛ pye kpoyi, ye ta ye pye leele mbele pe yɛn kpoyi, katugu muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","«Yanla ŋgasegele ke yigi jɛŋgɛ yaa tanri ke na. Muwi mi yɛn Yawe Yɛnŋɛlɛ na lì ye wɔ ye pye cɛnlɛ na li yɛn kpoyi. ");
INSERT INTO dyi_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«Lere o lere kaa to nakoma wi nɔ daŋga, wi daga poo gbo. Wi yaa wi kunwɔ pi go kala li lɛ, katugu wùu to nakoma wi nɔ wi daŋga. ");
INSERT INTO dyi_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«Na naŋa wa ka wi naŋa yɛnlɛ wa jɔ ta, pe yaa ki jataa wo naa ki nandaa wi ni pe shyɛn pe gbo. ");
INSERT INTO dyi_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","«Na naŋa wa ka sinlɛ wi to jɔ wa ni mboo to wi tifaga, ki daga pege naŋa wo naa ki jɛlɛ wi ni pe gbo. Pe yaa si pe kunwɔ pi go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","«Na naŋa wa ka sinlɛ wi pijɔ ni, ki daga pe pe shyɛn pe gbo; katugu pè kala pye na li yɛn ma piri. Pe yaa pe kunwɔ pi go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","«Na naŋa wa ka sinlɛ wi naŋa yɛnlɛ ni paa yɛgɛ ŋga na pe ma sinlɛ jɛlɛ ni, ki daga pe pe shyɛn pe gbo; katugu pè katijaanga pye, pe yaa pe kunwɔ pi go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","«Na naŋa wa ka sumboro wa naa wi nɔ pɔri wi jɛɛlɛ, ki fɔ wi katijaanga pye. Ki daga pe ki naŋa wo naa jɛɛlɛ shyɛn pe sogo weele. Pa kona ki kapege ŋga ki cɛnlɛ li se la piin laga ye sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«Na naŋa wa ka sinlɛ yaayogo ni, ki daga poo gbo mbe yaayogo ki gbo fun. ");
INSERT INTO dyi_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","«Na jɛlɛ wa kaa yɛɛ kan yaayogo yeri ki sinlɛ wi ni, yoo gbo ye yaayogo ki gbo. Ki daga ye pe shyɛn pe gbo. Pe yaa pe kunwɔ pi go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«Na naŋa wa kaa jɔnlɔ sumboro pɔri wi jɔ, ŋa wi yɛn wi to seyɛnlɛ nakoma wi nɔ seyɛnlɛ, na paga sinlɛ pe yɛɛ ni, pè fɛrɛ kala pye pe yɛɛ ni. Pe yaa pe shyɛn pe purɔ ca woolo sanmbala pe yɛgɛ na. Katugu ki naŋa wì sinlɛ wi to seyɛnlɛ jɛlɛ nakoma wi nɔ seyɛnlɛ sumboro ni. Pe yaa ki kambasinŋge ki go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","«Na naŋa wa ka sinlɛ jɛlɛ ŋa wi yɛn na jogo wa ni, pe yaa pe shyɛn pe purɔ mbe pe wɔ Izirayɛli woolo pe sɔgɔwɔ, katugu pe shyɛn pè yo ma fili ki na ma jɛlɛ wi kasanwa yirisaga ki yɛngɛ. ");
INSERT INTO dyi_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«Maga ka sinlɛ ma nɔ wi nɔsepyɔ sumboro ni, nakoma ma to wi nɔsepyɔ sumboro ni. Na naŋa wa ka sinlɛ wi go lere wa ni, pe shyɛn pe yaa pe kambasinŋge ki go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","«Na naŋa wa ka sinlɛ wi to wi nɔsepyɔ lenaŋa wa jɔ ni, kona wùu to wi nɔsepyɔ lenaŋa wi tifaga. Ki naŋa wo naa ki jɛlɛ wi ni pe yaa pe kapege ki go kala li lɛ. Pe yaa ku pe se piile se. ");
INSERT INTO dyi_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","«Na naŋa wa ka wi nɔsepyɔ lenaŋa wa jɔ lɛ mboo pye wi jɔ, kona wì fyɔngɔ kala pye, ma wi nɔsepyɔ lenaŋa wi tifaga. Pe yaa ku piile fu. ");
INSERT INTO dyi_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«Na ŋgasegele naa na kakɔnndɛgɛŋgɛlɛ ŋgele fuun mì yo ye kan, ye ke lɛ yaa tanri ke na. Pa kona tara nda mi yɛn na kee ye ni ye sa cɛn wa ti ni, ti se je ye na. ");
INSERT INTO dyi_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Tara woolo mbele mi yaa purɔ mbe yirige wa ye yɛgɛ, yaga ka saa tanri pe kalɛgɛlɛ ke na; katugu ki tara woolo ko kagala koro pàa pye na piin, a pe kala lìlan mbɛn. ");
INSERT INTO dyi_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","A mì sigi yo ye kan fɔ: Yoro ye yaa pe tara ti ta kɔrɔgɔ. Mi yaa ti kan ye yeri ti pye ye woro. Ki tara tori nɔnɔ naa sɛnrɛgɛ ti yɛn na fuun wa ti ni. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. Muwi mì ye wɔ ma ye tɛgɛ ye yɛ tara woolo sanmbala pe ni. ");
INSERT INTO dyi_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ki kala na, ye daga mbe yaayoro nda ti yɛn fyɔngɔ fu ti jɛn mberi wɔ nda ti yɛn fyɔngɔ ni ti ni, mbe sannjɛrɛ nda ti yɛn fyɔngɔ fu ti jɛn mberi wɔ nda ti yɛn fyɔngɔ ni ti ni. Yoro jate yaga ka jiri yaayoro nda ti yɛn fyɔngɔ ni ta na, naa sannjɛrɛ nda ti yɛn fyɔngɔ ni konaa yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele ke maa fulolo tara ti na, ma pye fyɔngɔ ni la na, mbe ye yɛɛ tɛgɛ fyɔngɔ ni fun. Mìgi yaara ti wɔ ti yɛɛ ni maga naga ye na, jaŋgo ye nda ti yɛn fyɔngɔ ni ti jɛn. ");
INSERT INTO dyi_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","«Ye pye kpoyi na kan, katugu mi ŋa Yawe Yɛnŋɛlɛ, mi yɛn kpoyi. Mì ye wɔ tara woolo sanmbala pe sɔgɔwɔ ma ye tɛgɛ ye yɛ, jaŋgo ye pye na woolo. ");
INSERT INTO dyi_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«Na naŋa nakoma jɛlɛ wa ka pye jɛlɛfɔ, mbaa kuulo pe yewe, nakoma mbaa kajɛnmɛ piin, wi daga poo gbo. Pe yaa wi wa sinndɛɛrɛ ni mboo gbo. Wi yaa wi kunwɔ pi go kala li lɛ wi yɛ.» ");
INSERT INTO dyi_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yawe Yɛnŋɛlɛ làa Moyisi wi pye fɔ: «Ki sɛnrɛ nda ti yo saraga wɔfɛnnɛ pe kan, Arɔn wi pinambiile wele, ma pe pye fɔ: «Saraga wɔfɔ wa si daga mbe jiri wi sege woo wa gboo na mboo yɛɛ tɛgɛ fyɔngɔ ni, ");
INSERT INTO dyi_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","kaawɔ wi go woo wo wa: Wi nɔ, naa wi to, naa wi pinambyɔ, naa wi sumborombyɔ, naa wi nɔsepyɔ lenaŋa ");
INSERT INTO dyi_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","konaa wi nɔsepyɔ sumboro ŋa wi fa pɔri naŋa yeri. Wi mbe ya jiri poro wa gboo na, mboo yɛɛ tɛgɛ fyɔngɔ ni; katugu wi fa pye naŋa wa jɔ gbɛn. ");
INSERT INTO dyi_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Saraga wɔfɔ wo wi yɛn to wi woolo pe sɔgɔwɔ. Wii daga mboo yɛɛ tɛgɛ fyɔngɔ ni, wi yɛn kpoyi yɛgɛ ŋga na mbege jɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«Saraga wɔfɛnnɛ pee daga mbe pe yinrɛ ti lara ta kulu kulu, nakoma mbe pe siyɔ wi kanŋgara ti kulu; pee si daga mbe pe witire lara ta kɔɔnlɔ kɔɔnlɔ mbege naga fɔ kunwɔ to pe na ");
INSERT INTO dyi_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Pe daga mbe pye kpoyi pe Yɛnŋɛlɛ li kan. Pee daga mbe pe Yɛnŋɛlɛ li mɛgɛ ki jɔgɔ, katugu poro pe maa saara ti woo Yawe Yɛnŋɛlɛ li yeri, to nda ti yɛn li yaakara nda pe ma sogo we. Ki kala na pe daga mbe pye kpoyi. ");
INSERT INTO dyi_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","«Saraga wɔfɔ wii daga mbe nanjaa pɔri wi jɔ, nakoma sumboro ŋa wì jɔgɔ, nakoma jɛlɛ ŋa wi pɔlɔ wùu wa, katugu saraga wɔfɔ pyew wi yɛn kpoyi wi Yɛnŋɛlɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Yaa saraga wɔfɔ wi jate wi yɛn kpoyi, katugu wo wi maa ye Yɛnŋɛlɛ li yaakara ti kaan li yeri saraga. Wi daga mbe pye kpoyi ye yɛgɛ na; katugu mi yɛn kpoyi, mi ŋa Yawe Yɛnŋɛlɛ na li yɛn na ye piin kpoyi we. ");
INSERT INTO dyi_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","«Na saraga wɔfɔ wa sumborombyɔ kaa nanjara piin mboo yɛɛ tifaga, kona wi to wo wì tifaga. Ki daga pege sumboro wi sogo wee. ");
INSERT INTO dyi_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«Saraga wɔfɔ ŋa wi yɛn saraga wɔfɛnnɛ sanmbala pe go na, wo ŋa pàa sinmɛ mba pe ma wo yaraga na mbege le Yɛnŋɛlɛ kɛɛ pa wo wa wi go ki na, maa tɛgɛ wi yɛ Yɛnŋɛlɛ kan, a wila yaripɔrɔ nda tì tɛgɛ ti yɛ li kan ti nii, wii daga mboo go ki yaga sagara, wii si daga mboo yaripɔrɔ ti walagi mbege naga fɔ wi yɛn na kunwɔ gbele. ");
INSERT INTO dyi_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Wiga ka fulo gboo tanla, wiga si kaa yɛɛ tɛgɛ fyɔngɔ ni, ali wi to nakoma wi nɔ wì ku o. ");
INSERT INTO dyi_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Wi se ka yiri wa laga kpoyi ki ni, jaŋgo wiga ka wi Yɛnŋɛlɛ li cɛnsaga paraga go ki tɛgɛ fyɔngɔ ni; katugu sinmɛ mba pe ma wo yaraga na mbege le Yɛnŋɛlɛ kɛɛ pàa pa wo wi na, maa tɛgɛ na tunŋgo ki na. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","«Saraga wɔfɛnnɛ to wi daga mbe sumboro ŋa wi fa naŋa kala jɛn wo wa pɔri wi jɔ. ");
INSERT INTO dyi_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Wiga ka naŋgunjɔ pɔri wi jɔ, nakoma jɛlɛ ŋa wi pɔlɔ wi wa, nakoma jɛlɛ ŋa wìla jɔgɔ, nakoma jɛlɛ ŋa wila nanjara piin. Ɛɛn fɔ, wi daga mboo jɔ wi lɛ wa saraga wɔfɛnnɛ sege ki ni, wi pye sumboro ŋa wi fa naŋa kala jɛn; ");
INSERT INTO dyi_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","jaŋgo wiga ka setirige piile pele le wa wi sege ki ni, mbele pe yɛn fyɔngɔ ni; katugu mi ŋa Yawe Yɛnŋɛlɛ, mùu wɔ maa tɛgɛ wi yɛ na yɛɛ kan.» ");
INSERT INTO dyi_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","«Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","wigi sɛnrɛ nda ti yo Arɔn wi kan fɔ: ‹Mbele fuun pe yaa ka yiri puŋgo na, wa ma setirige piile pe ni, naŋa ŋa fuun ka ka pye sɔ ni wi witige laga ka na, wi se ka fulo wa saraga wɔsaga ki tanla mboo Yɛnŋɛlɛ li yaakara ti kan li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Naŋa ŋa fuun wi yɛn sɔ ni wi witige laga ka na, wa kpɛ si daga mbege tunŋgo ki pye. Ko kɔrɔ wo yɛn fyɔɔn, naa jejɔgɔlɔfɔ, naa ŋa wi yɛgɛ cɛnwɛ pì jɔgɔ wi na, naa ŋa wi witige laga kà wɔ wa ki yɔnlɔ, ");
INSERT INTO dyi_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","naa naŋa ŋa wi jele nakoma wi kɛɛ kaw wi na, ");
INSERT INTO dyi_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","naa puŋgunɔ fɔ, naa ŋa wì pɔngɔ, naa ŋa wi yɛnlɛ lì fi wi na, naa ŋa yama yɛn wi witige sɛlɛgɛ ki na konaa naŋa ŋa pè san. ");
INSERT INTO dyi_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ma setirige pyɔ ŋa ki sɔ ŋa wa yɛn wi na, wo wa si daga mbe fulo wa saraga wɔsaga ki tanla, mbe saara nda pe ma sogo ta wɔ Yawe Yɛnŋɛlɛ li yeri. Sɔ ŋa wi yɛn wi na wi kala na, wiga ka fulo wa mboo Yɛnŋɛlɛ li yaakara ti kan li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Wi mbe ya mbaa wi Yɛnŋɛlɛ li yaakara ti kaa, to ti yɛn yarikanra nda ti yɛn kpoyi konaa nda ti yɛn jɛndɛ kpoyi. ");
INSERT INTO dyi_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ɛɛn fɔ, sɔ ŋa wi yɛn wi na wi kala na, wii daga mbe fulo wa paraga ŋga pè pɔ ma cɛnsaga paraga go ki kɔn shyɛn ki tanla, wii daga mbe yɔngɔ saraga wɔsaga ki tanla. Wii daga mbanla cɛnsaga paraga go ki tɛgɛ fyɔngɔ ni, katugu muwi mi yɛn Yawe Yɛnŋɛlɛ na li maa saraga wɔfɛnnɛ pe piin kpoyi na yɛɛ kan.› » ");
INSERT INTO dyi_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","A Moyisi wì sigi sɛnrɛ ti yo Arɔn naa wi pinambiile konaa Izirayɛli woolo sanmbala pe ni fuun pe kan. ");
INSERT INTO dyi_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Para Arɔn wi pinambiile pe ni, ma pe pye fɔ pe pe yɛɛ yingiwɛ jɛn yarikanra nda tì tɛgɛ ti yɛ ti wogo na, to nda Izirayɛli woolo pe maa paan ti ni na kan we, jaŋgo na mɛgɛ ki yɛn kpoyi yɛgɛ ŋga na, paga kaga tɛgɛ fyɔngɔ ni. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ki yo pe kan naa fɔ: «Pe setirige piile mbele fuun pe yaa ka yiri puŋgo na, na naŋa wa ka ka pye fyɔngɔ ni wa pe ni, mbe si fulo yarikanra nda tì tɛgɛ ti yɛ na kan ti tanla, to nda Izirayɛli woolo pe maa paan ti ni na kan, pe yaa wo purɔ mboo yirige wa na yɛgɛ sɔgɔwɔ. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Arɔn setirige piile pe ni, saraga wɔfɔ ŋa fuun yayɛnwɛ ka to wi na nakoma fyomiŋge, wo wa si daga mbe yarikanra nda tì tɛgɛ ti yɛ na kan ta ka, fɔ wi ka sa pye fyɔngɔ fu. Ŋa ka jiri gboo na mboo yɛɛ tɛgɛ fyɔngɔ ni, naa ŋa wi nama tɔnmɔ pì wo wi na, wo wa si daga mbe ta ka fun; ");
INSERT INTO dyi_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","naa ŋa ka jiri yaŋgala jɛgɛlɛ jɛgɛlɛ ŋgele ke maa fulolo tara ti na la na, koro ŋgele ke ma lere tɛgɛ fyɔngɔ ni we, konaa ŋa ka jiri lere ŋa wi yɛn fyɔngɔ ni wa na, ali mbege ta ki fyɔngɔ kala li yɛn yɛgɛ o yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ŋa ka jiri ki yaara ta na, wi yaa pye fyɔngɔ ni fɔ sa gbɔn ki yɔnlɔkɔgɔ. Na wii ka woli mbe kɔ, wi se ya mbe yarikanra nda tì tɛgɛ ti yɛ na kan ta ka. ");
INSERT INTO dyi_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Na yɔnlɔ kiga ka to mbe kɔ, pa wi yaa pye fyɔngɔ fu, kona pa wi mbe ya yarikanra nda tì tɛgɛ ti yɛ na kan ta ka naa, katugu to ti yɛn wi yaakara re. ");
INSERT INTO dyi_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Saraga wɔfɔ wii daga mbe yarikugo nakoma woŋgbɔ ŋa cɛngɛ gbo wa kara ka mboo yɛɛ tɛgɛ fyɔngɔ ni. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«Saraga wɔfɛnnɛ pe daga mbanla sɛnyoro ti yigi la tanri ti na, jaŋgo paga ka pye kapege pyefɛnnɛ yaakara wogo na; katugu na paga ti tɛgɛ fyɔngɔ ni, pe yaa ku. Muwi mi yɛn Yawe Yɛnŋɛlɛ na lì pe tɛgɛ pe yɛ na yɛɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«Lere ŋa woro saraga wɔfɔ, wo wa kpɛ si daga mbe yarikanra nda tì tɛgɛ ti yɛ na kan ta ka. Ali saraga wɔfɔ wi nambanndorowo nakoma wi tunmbyee ŋa wi maa sara, pee daga mbe ta ka. ");
INSERT INTO dyi_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ɛɛn fɔ, saraga wɔfɔ wiga kulo ŋa lɔ penjara ni nakoma kulo ŋa pè se wa wi go, wo mbe ya mbaa saraga wɔfɔ wi yaakara ta kaa. ");
INSERT INTO dyi_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Na saraga wɔfɔ wi sumborombyɔ wiga pɔri naŋa ŋa wi woro saraga wɔfɔ wa yeri, yarikanra nda tì tɛgɛ ti yɛ na kan, saraga ŋga pe ma lagala wa ti na, ki sumborombyɔ wii daga mbaa ki kaa. ");
INSERT INTO dyi_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Na saraga wɔfɔ wi sumborombyɔ wiga pye naŋgunjɔ nakoma wi pɔlɔ wuu wa, mbe sigi ta wii piile se, na wiga sɔngɔrɔ sa cɛn wa wi to wi go paa yɛgɛ ŋga na wi sumborowo sanga wìla pye, kona wi mbe ya mbaa wi to yaakara ta kaa. Ɛɛn fɔ, lere ŋa woro saraga wɔfɔ, wo wa kpɛ si daga mbe ta ka. ");
INSERT INTO dyi_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Na lere wa ka wa mbe la mbe yarikanra nda tì tɛgɛ ti yɛ na kan ta ka, wi daga mbege yɔngɔ kan saraga wɔfɔ wi yeri mbege walisaga kaŋgurugo wogo taga wa ti na. ");
INSERT INTO dyi_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","«Izirayɛli woolo pe yarikanra nda pè lagala ma tɛgɛ ti yɛ, ma kan Yawe Yɛnŋɛlɛ li yeri, saraga wɔfɛnnɛ pee daga mberi tɛgɛ fyɔngɔ ni. ");
INSERT INTO dyi_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Na paga ti ka mbege ta pe cɛnwɛ pi woro ma yɔn, pa pe yaa ti ki pye kapege pe yɛɛ go na, ŋga ki daga pege kɔ. Muwi mi yɛn Yawe Yɛnŋɛlɛ na li yɛn na yarikanra ti teri ti yɛ na yɛɛ kan.» ");
INSERT INTO dyi_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","wigi sɛnrɛ nda ti yo Arɔn naa wi pinambiile konaa Izirayɛli woolo pe ni fuun pe kan wi pe pye fɔ: «Lere o lere wi yɛn Izirayɛli woo, nakoma nambanŋa ŋa wi yɛn ma cɛn laga Izirayɛli woolo pe sɔgɔwɔ, na wa kaa jaa mbe saraga sogowogo wɔ Yawe Yɛnŋɛlɛ li yeri, konaa mbe yɔn fɔlɔ tɔn, nakoma ki pye nayinmɛ yarikanga, ");
INSERT INTO dyi_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","na kaa pye ki fɔ wila jaa wi saraga ki yigi, wi daga mbe pan yaayogo naŋga ni, ŋga ki yɛn jɛrɛgisaga fu, ko yɛn napɔlɔ, nakoma simbapɔlɔ nakoma sikapɔlɔ. ");
INSERT INTO dyi_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Yaga ka yaayogo ŋga ki yɛn jɛrɛgisaga ni ka wɔ saraga; katugu ki saraga ki se yigi. ");
INSERT INTO dyi_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Na lere wa kaa jaa mbe nayinmɛ saraga wɔ Yawe Yɛnŋɛlɛ li yeri mbe yɔn fɔlɔ tɔn, nakoma ki pye nayinmɛ yarikanga, wi daga mbe pan nɛgɛ, nakoma sumbyɔ nakoma sugbɔ ni. Ki yaayogo ki daga mbe pye jɛrɛgisaga fu, sɔ ka ka pye ki na, pa kona wi saraga ki yaa yigi. ");
INSERT INTO dyi_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Yaga ka yaayogo ŋga ki yɛn fyɔɔn ka wɔ saraga Yawe Yɛnŋɛlɛ li yeri, nakoma ŋga ki laga kà kaw ki na, nakoma ŋga ki yɛn jekɔngɔ ni, nakoma ŋga sanŋgbanra yɛn ki na, nakoma ŋga kurukurugo nakoma kawa to ki na. Yaga ka ka wɔ saraga ŋga pe ma sogo wa saraga wɔsaga ki na Yawe Yɛnŋɛlɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Na nɛgɛ nakoma sumbyɔ wa witige laga ka wɔ wa ki yɔnlɔ, nakoma na wiga pɔngɔ, ma mbe ya mboo wɔ paa nayinmɛ yarikanga yɛn; ɛɛn fɔ, na maga ki tɛgɛ mbe yɔn fɔlɔ tɔn, ki saraga ki se yigi. ");
INSERT INTO dyi_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Yaayogo ŋga pège yɔgɔlɔ ke yaari, nakoma pège san, nakoma pège yɔgɔlɔ ke laga nakoma ma ke kɔn, yaga ka ka wɔ saraga Yawe Yɛnŋɛlɛ li yeri. Na yaga ka sa cɛn wa ye tara, yaga kaa ki kapyere cɛnlɛ li piin. ");
INSERT INTO dyi_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Yaayoro nda pè pye ma, yaga ka yɛnlɛ mbe ka shɔ nambanŋa wa yeri mbege wɔ yarikanga, ki pye Yawe Yɛnŋɛlɛ li yaakara, katugu pège san, nakosima ki witige laga kà wɔ wa ki yɔnlɔ. Kiga pye ma, ye saraga ki se yigi ye kan.» ");
INSERT INTO dyi_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Napige nakoma simbapige nakoma sikapige ki seŋgɔlɔ, ki daga mbe koro le ki nɔ wi tanla fɔ sa gbɔn piliye kɔlɔshyɛn. Mbe lɛ le pilige kɔlɔtaanri wogo ki na, ki mbe ya wɔ mi ŋa Yawe Yɛnŋɛlɛ na yeri saraga ŋga pe ma sogo. ");
INSERT INTO dyi_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ɛɛn fɔ, yaga ka nanɔ, nakoma simbanɔ nakoma sikanɔ naa wi pyɔ pe pinlɛ mbe pe gbo pilige nuŋgba ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«Na ye kaa jaa mbe saraga wɔ mi ŋa Yawe Yɛnŋɛlɛ na yeri mbanla sɔn, yege wɔ ki wɔlɔmɔ pi na, jaŋgo ki yigi ye kan. ");
INSERT INTO dyi_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Saraga ki wɔpilige, yege kara ti ka, yaga ka ta yaga ti wɔnlɔ ti yiri. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Yanla ŋgasegele ke yigi yaa tanri ke na. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Yaga kanla mɛgɛ ki tifaga, ko ŋga ki yɛn kpoyi we. Yoro Izirayɛli woolo mi yɛn kpoyi yɛgɛ ŋga na, yaa ki gbogo. Muwi mi yɛn Yawe Yɛnŋɛlɛ na lì ye wɔ ma ye tɛgɛ ye yɛ na yɛɛ kan. ");
INSERT INTO dyi_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Mì ye yirige wa Ezhipiti tara mbe pye ye Yɛnŋɛlɛ. Muwi mi yɛn Yawe Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","wigi sɛnrɛ nda ti yo Izirayɛli woolo pe kan wi pe pye fɔ: «Fɛtiye mbele ye daga mbaa piin Yawe Yɛnŋɛlɛ li mɛgɛ ni poro wɛlɛ yɛɛn. Wagati ŋa wì tɛgɛtɛgɛ fɛtiye pe wogo na, na wi ka gbɔn, yege yari leele pe kan pe gbogolo panla gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«Yapelege ki ni, ye yaa la tunŋgo piin piliye kɔgɔlɔni, pilige kɔlɔshyɛn wogo ko yɛn cɛnpilige, wogopilige ŋga kì tɛgɛ ki yɛ yaa ye yɛɛ gbogolo ki ni na mɛgɛ ni. Ye se ka tunŋgo ka kpɛ pye ki pilige ki ni. Ki yɛn cɛnpilige Yawe Yɛnŋɛlɛ li kan laga o laga ye yaa ka pye mbe cɛn we. ");
INSERT INTO dyi_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«Fɛtiye sanmbala mbele ye yaa kaa piin mbaa gbogolo Yawe Yɛnŋɛlɛ li mɛgɛ ni, mbaa li gbogo, mbe yala wagati ŋa wì tɛgɛtɛgɛ wi ni, poro wɛlɛ yɛɛn: ");
INSERT INTO dyi_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","«Yɛlɛ li yeŋge koŋgbanŋga ki pilige kɛ ma yiri tijɛrɛ wogo ki yɔnlɔkɔgɔ, ye yaa Paki fɛti wi pye Yawe Yɛnŋɛlɛ li mɛgɛ ni. ");
INSERT INTO dyi_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","«Ki yeŋge nuŋgba ki pilige kɛ ma yiri kaŋgurugo wogo ki na, leve fu buru wi ma ka fɛti ŋa na, ye yaa wi lɛ mbaa wi piin Yawe Yɛnŋɛlɛ li mɛgɛ ni. Ye yaa la leve fu buru kaa fɔ sa gbɔn piliye kɔlɔshyɛn. ");
INSERT INTO dyi_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ki piliye kɔlɔshyɛn yi pilige koŋgbanŋga ki na, ye yaa gbogolo mbeli gbɔgɔ. Ye se ka ye tunŋgo ka kpɛ pye ki pilige ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ki piliye kɔlɔshyɛn yi ni, pilige nuŋgba nuŋgba pyew, ye yaa saraga ŋga pe ma sogo ka wɔ Yawe Yɛnŋɛlɛ li yeri. Pilige kɔlɔshyɛn wogo ki na, ye yaa gbogolo mbeli gbɔgɔ. Ye se ka ye tunŋgo ka kpɛ pye ki pilige ki ni.» ");
INSERT INTO dyi_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","wigi sɛnrɛ nda ti yo Izirayɛli woolo pe kan wi pe pye fɔ: «Tara nda mila kaan ye yeri, na yaga ka sa ye wa ti ni sanga ŋa ni, mbaa yarilire kɔɔn wa ti ni, yaa paan ye yarilire pɔgɔlɔ koŋgbanŋgala ŋgele ye yaa kaa kɔɔn ke ni saraga wɔfɔ wi kan. ");
INSERT INTO dyi_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Saraga wɔfɔ wi yaa yarilire pɔgɔlɔ ke lɛ mbe ke yirige mbe ke kan saraga na yeri cɛnpilige ki goto, jaŋgo wi saraga ki yigi wi kan. ");
INSERT INTO dyi_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Pilige ŋga ni yaga yarilire pɔgɔlɔ ke yirige mbe ke kan saraga, ye yaa simbapɔlɔ yirifɔnŋɔ ŋa wì ta yɛlɛ nuŋgba, ma pye jɛrɛgisaga fu wa wɔ na yeri saraga sogowogo. ");
INSERT INTO dyi_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ye yaa muwɛ tiyɔɔn culo kɔgɔlɔni taga wi na, mba pè sinmɛ pinlɛ pi ni, pi yaa pye saraga ŋga pe ma sogo Yawe Yɛnŋɛlɛ li kan, ŋga ki nuwɔ taan pi yɛn mali ndanla, konaa duvɛn litiri nuŋgba naa kɔngɔ ni, mboo pye saraga ŋga pe ma wo. ");
INSERT INTO dyi_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Yaga ka ki yarilire fɔnndɔ ta pye buru mbe ka, nakoma mberi pire ta kala mberi ka, nakoma mbe pire fɔnndɔ nda wa sheshegele ke na ta ka, fɔ ndɛɛ ye ka pan ye we Yɛnŋɛlɛ li yarikanga ki kan li yeri pilige ŋga ni we. Ki yɛn ŋgasele na li yɛn kɔsaga fu ye setirige piile mbele pe yaa ka yiri puŋgo na pe ni fuun pe kan, laga o laga ye yaa ka pye mbe cɛn we. ");
INSERT INTO dyi_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«Cɛnpilige ki goto, yarilire pɔgɔlɔ koŋgbanŋgala pè ke yirige ma ke kan saraga, ma pan ke ni pilige ŋga ni, ye yaa ki lɛ le ki pilige ki na mbe jiri sa ta yapelege jɛnyɛ jɛnyɛ kɔlɔshyɛn. ");
INSERT INTO dyi_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ki wagati wi yaa pye piliye nafa shyɛn ma yiri kɛ, mbe sa yala cɛnpiliye kɔlɔshyɛn wogo ki goto wi ni. Ki pilige nafa shyɛn ma yiri kɛ wogo ki na, ye yaa muwɛ yarikanga kan Yawe Yɛnŋɛlɛ li yeri naa fɔnŋgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ye yaa pan buru shyɛnzhyɛn ni mbe yiri wa ye cɛnsara ti ni, mbe pan mboo yirige mboo kan saraga Yawe Yɛnŋɛlɛ li yeri. Ye buru wi ni fuun nuŋgba nuŋgba wi gbegele muwɛ tiyɔɔn culo taanrindaanri ni, ye leve le wi ni yoo fɔ. Ki yarikanga ki yaa kan li yeri mbe yiri wa ye yarilire fɔnndɔ koŋgbannda ti ni. ");
INSERT INTO dyi_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Mbe taga wa buru ŋa yè kan yarikanga wi na, ye yaa pan simbapɛnɛ yirifɔnmbɔlɔ kɔlɔshyɛn ni, mbele pè ta yɛlɛ nuŋgba nuŋgba ma pye jɛrɛgisaga fu, naa napɔlɔ nuŋgba konaa simbapɛnɛ shyɛn ni, mbe pe wɔ Yawe Yɛnŋɛlɛ li yeri saraga sogowogo, naa muwɛ saraga ŋga ki ma taga wa ki na konaa duvɛn saraga ŋga pe ma wo ki ni. Ti yɛn saara nda pe ma sogo, ti nuwɔ taan pi yɛn ma Yawe Yɛnŋɛlɛ li ndanla. ");
INSERT INTO dyi_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ye yaa sikapɔlɔ nuŋgba wɔ fun saraga mbe kapere kala yagawa ja, mbe simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba pe shyɛn wɔ nayinmɛ saraga. ");
INSERT INTO dyi_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Saraga wɔfɔ wi yaa buru ŋa pè yarilire fɔnndɔ koŋgbannda ti tɛgɛ maa gbegele wo naa yaayoro to naa simbapɛnɛ yirifɔnmbɔlɔ shyɛn pe yirige mbe pe kan Yawe Yɛnŋɛlɛ li yeri. Ki yaara ti yaa pye mbe tɛgɛ ti yɛ Yawe Yɛnŋɛlɛ li kan, mbe pye saraga wɔfɔ wo woro. ");
INSERT INTO dyi_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ki pilige nuŋgba ki ni, ye yaa leele pe yeri mbe gbogolo mbanla gbɔgɔ. Ye se ka ye tunŋgo ka kpɛ pye. Ki yɛn ŋgasele na li yɛn kɔsaga fu ye setirige piile mbele fuun pe yaa ka yiri puŋgo na pe kan, laga o laga ye yaa ka pye. ");
INSERT INTO dyi_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«Na yaga kaa ye yarilire ti kɔɔn sanga ŋa ni wa ye tara, yaga ka yarilire ti kɔn mbe gbɔn wa kɛrɛ koŋgo ki na. Laga ŋga yè kɔn yaga ka sɔngɔrɔ sa sheshegele ŋgele kè toori wa ke wulo. Ye to yaga wa fyɔnwɔ fɛnnɛ, naa nambanmbala pe kan. Muwi mi yɛn Yawe Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","wigi sɛnrɛ nda ti yo Izirayɛli woolo pe kan wi pe pye fɔ: «Yɛlɛ li yeŋge kɔlɔshyɛn wogo, ki pilige koŋgbanŋga ki yaa pye wogopilige ye kan, mbe ti ye nawa to na wogo ki na; ye yaa mbaanra win mbe gbogolo mbanla gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ye se ka ye tunŋgo ka kpɛ pye ki pilige ki ni. Ye yaa saara nda pe ma sogo ta wɔ mi ŋa Yawe Yɛnŋɛlɛ na yeri.» ");
INSERT INTO dyi_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Yɛlɛ li yeŋge kɔlɔshyɛn wogo ki pilige kɛ wogo ki yaa pye kapere ti kala yagawa japilige. Ye yaa gbogolo mbanla gbɔgɔ, mbe yeŋge le, mbe saara nda pe ma sogo ta wɔ Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Yaga ka tunŋgo ka kpɛ pye ki pilige ki ni, katugu ki pilige ki yɛn kapere ti kala yagawa japilige, ŋga ni kapyege ŋga pe ma pye mbe kapere ti kala yagawa ja pe yaa ki pye ye kan Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Lere ŋa fuun si yeŋge le ki pilige ki ni, pe yaa wi purɔ mboo wɔ Izirayɛli gbogolomɔ woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Lere ŋa fuun ka tunŋgo pye ki pilige ki ni, mi jate mi yaa wi tɔngɔ mboo wɔ Izirayɛli woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Yaga ka tunŋgo ka kpɛ pye ki pilige ki ni. Ki yɛn ŋgasele na li yɛn kɔsaga fu ye setirige piile mbele pe yaa ka yiri puŋgo na pe kan, laga o laga ye yaa ka pye mbe cɛn. ");
INSERT INTO dyi_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ki pilige ki yaa pye wogopilige ye kan paa cɛnpilige ki yɛn. Ye yaa yeŋge le ki ni. Mbege lɛ ki yeŋge ki pilige kɔlɔjɛrɛ wogo ki yɔnlɔkɔgɔ, fɔ sa gbɔn ki goto yɔnlɔkɔgɔ, ye yaa ki tɛgɛ wogopilige.» ");
INSERT INTO dyi_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","wigi sɛnrɛ nda ti yo Izirayɛli woolo pe kan wi pe pye fɔ: «Mbege lɛ yɛlɛ li yeŋge kɔlɔshyɛn wogo ki pilige kɛ ma yiri kaŋgurugo wogo ki na, fɔ sa gbɔn yapelege nuŋgba, ye yaa Gbataala nɔgɔ fɛti wi pye Yawe Yɛnŋɛlɛ li mɛgɛ ni. ");
INSERT INTO dyi_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Fɛti wi pilige koŋgbanŋga ki na, ye yaa gbogolo mbanla gbɔgɔ. Ye se ka ye tunŋgo ka kpɛ pye ki pilige ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ki yapelege ki pilige nuŋgba nuŋgba pyew ki ni, ye yaa saara nda pe ma sogo ta wɔ Yawe Yɛnŋɛlɛ li yeri. Pilige kɔlɔtaanri wogo ki na ye yaa gbogolo mbanla gbɔgɔ, mbe saara nda pe ma sogo ta wɔ na yeri. Ye yaa gbogolo ki pilige ki ni fuun ki ni mbanla gbɔgɔ, ye se ka tunŋgo ka kpɛ pye. ");
INSERT INTO dyi_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«Ko fɛtiye mbele poro wɛlɛ ye yaa la piin Yawe Yɛnŋɛlɛ li mɛgɛ ni. Ye yaa la ye yɛɛ gbogolo pe na mbaa li gbogo, mbaa saara sogoworo woo li yeri, naa muwɛ saara, naa nayinmɛ saara, konaa duvɛn saara nda pe ma wo ti ni, mbe yala fɛti wi pilige pyew saara wɔlɔmɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ki saara ti yaa wɔ mbe taga wa nda ye maa woo Yawe Yɛnŋɛlɛ li yeri cɛnpilige ki ni ti na, naa ye yarikanra ti na, konaa ye saara nda ye ma wɔ mbe yɔn fɔlɔ tɔn nakoma ye nayinmɛ saara ti na. ");
INSERT INTO dyi_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«Yɛlɛ li yeŋge kɔlɔshyɛn wogo ki pilige kɛ ma yiri kaŋgurugo wogo ki na, ye kɛrɛ yarilire ti kɔnŋgɔlɔ, ye yaa fɛti wa pye piliye kɔlɔshyɛn Yawe Yɛnŋɛlɛ li mɛgɛ ni. Pilige koŋgbanŋga konaa pilige kɔlɔtaanri wogo ki ni, to yaa pye wogopiliye. ");
INSERT INTO dyi_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Pilige koŋgbanŋga ki na, ye yaa ye tire pire tiyɔnrɔ ta lɛ, naa sɛngɛmbanra ni, naa tige njere nda tì fun ta ni, konaa lɔgɔ yɔn sɔli tire njere ta ni, mbe yɔgɔri Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ fɔ sa gbɔn yapelege nuŋgba. ");
INSERT INTO dyi_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Yɛlɛ pyew yaa ki fɛti ŋa wi piin piliye kɔlɔshyɛn ni Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, yɛlɛ li yeŋge kɔlɔshyɛn wogo ki na. Ki yɛn ŋgasele na li yɛn kɔsaga fu ye setirige piile mbele pe yaa ka yiri puŋgo na pe kan. ");
INSERT INTO dyi_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ki yapelege ki ni, yoro Izirayɛli woolo ye daga mbaa cɛɛn gbataala nɔgɔ. Izirayɛli tara piile pe ni fuun pe daga mbaa cɛɛn gbataala nɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ko yaa pye ma, jaŋgo ye setirige piile pege jɛn fɔ naa mìla ye tɛlɛye pe yirige wa Ezhipiti tara, mìla ti a pè cɛn gbataala nɔgɔ. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Fɛtiye mbele pe daga mbaa piin Yawe Yɛnŋɛlɛ li mɛgɛ ni, pa Moyisi wìla pe sɛnrɛ yo Izirayɛli woolo pe kan yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Ki yo Izirayɛli woolo pe kan fɔ pe pan pe oliviye tire pire nda pè sun ti sinmɛ piiri kan ma yeri; po pi yaa pye fitanla wi sinmɛ we, jaŋgo fitanlaye paa yiin sanga pyew yembinɛ. ");
INSERT INTO dyi_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Arɔn wi yaa fitanladaga wi gbegele mboo tɛgɛ wa filisaga paraga go ki ni, wa paraga ŋga pè pɔ maga kɔn shyɛn ki yɛgɛ; ko ŋga ki yɛn ma yɔn finliwɛ sɛnrɛ kɛsu wi yɛgɛ tɔn we; jaŋgo fitanlaye paa yiin suyi Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mbege lɛ yɔnlɔkɔgɔ fɔ sa gbɔn lalaaga ki na. Ki yɛn ŋgasele na li yɛn kɔsaga fu yoro naa ye setirige piile mbele fuun pe yaa ka yiri puŋgo na ye kan. ");
INSERT INTO dyi_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Arɔn wi yaa fitanlaye pe gbɛgɛlɛ wa fitanladaga wi na, wo ŋa pè gbegele tɛ piiri ni, jaŋgo paa yiin suyi Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Ma muwɛ tiyɔɔn lɛ ma buru kɛ ma yiri shyɛn gbegele pi ni, wi ni fuun nuŋgba nuŋgba wi nuguwɔ pi pye culo kɔgɔlɔni kɔgɔlɔni. ");
INSERT INTO dyi_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ma yaa ki buru wi tɛgɛ koŋgolo shyɛn wa tabali ŋa pè gbegele tɛ piiri ni wi na Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. Konɔ nuŋgba li yaa pye buru kɔgɔlɔni. ");
INSERT INTO dyi_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ma yaa wusuna nuwɔ taan piiri tɛgɛ mbe yala koŋgolo shyɛn ke ni fuun nuŋgba nuŋgba ke ni. Kona, ma yaa wi sogo buru wi yɔnlɔ paa saraga ŋga pe ma sogo Yawe Yɛnŋɛlɛ li kan ki yɛn; ki yɛn nandowo saraga buru wi wogo na. ");
INSERT INTO dyi_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","«Cɛnpilige pyew paa ki buru ŋa wa teri Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, kila piin ma sanga pyew. Izirayɛli woolo paa ki piin ma suyi, ki yɛn yɔn finliwɛ mba pi yɛn kɔsaga fu. ");
INSERT INTO dyi_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ki buru wi yaa pye Arɔn naa wi pinambiile poro woo. Pe yaa kaa wi kaa laga kpoyi ka ni; katugu wi yɛn yaraga ŋga ki yɛn ma tɛgɛ ki yɛ pew, ma yiri wa yarikanra nda pe ma sogo Yawe Yɛnŋɛlɛ li kan ti ni. Ki yɛn tasaga ŋga ki yaa la kaan pe yeri suyi.» ");
INSERT INTO dyi_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Izirayɛli tara fɛnnɛ jɔ wa pinambyɔ to la pye Ezhipiti tara fɛnnɛ naŋa wa. Pilige ka, a ki pinambyɔ wì si kari wa Izirayɛli woolo pe sɔgɔwɔ ma saa na wiin Izirayɛli woolo naŋa wa ni wa paara yinrɛ cɛnsaga ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","A Izirayɛli tara fɛnnɛ jɔ wi pinambyɔ wì si Yɛnŋɛlɛ li mɛgɛ ki jɔgɔ mali daŋga. A pè suu yigi ma kari wi ni Moyisi wi kɔrɔgɔ. Pàa pye na ki naŋa wi nɔ wi yinri Shelomiti. Shelomiti wìla pye naŋa ŋa pàa pye na yinri Debiri wo sumborombyɔ, ma yiri wa Dan cɛnlɛ li ni. ");
INSERT INTO dyi_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","A pè si saa ki naŋa wi tɛgɛ laga ka ni maga tɔn wi na, nɛɛ ŋga Yawe Yɛnŋɛlɛ li mbaa yo pe pye wi na ki singi mbege jɛn. ");
INSERT INTO dyi_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Ti pe kari naŋa mɛjɔɔgɔfɔ wi ni wa paara yinrɛ cɛnsaga ki puŋgo na. Leele mbele fuun pège sɛnrɛ ti logo wi yeri, pe pe kɛyɛn yi taga wa wi go ki na; kona Izirayɛli gbogolomɔ woolo pe ni fuun pe yaa wi wa sinndɛɛrɛ ni mboo gbo.» ");
INSERT INTO dyi_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Maga sɛnrɛ nda ti yo Izirayɛli woolo pe kan fɔ: «Lere ŋa fuun ka mi ŋa wi Yɛnŋɛlɛ na daŋga, wi yaa wi kapege ki go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Lere ŋa fuun ka mi ŋa Yawe Yɛnŋɛlɛ na mɛgɛ ki jɔgɔ, wi yɛn Izirayɛli tara pyɔ o, wi yɛn nambanŋa o, wi daga poo gbo. Izirayɛli gbogolomɔ woolo pe ni fuun pe yaa wi wa sinndɛɛrɛ ni mboo gbo. ");
INSERT INTO dyi_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«Na lere wa ka wi lewee yɛnlɛ wa gbo, wi daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Na wiga wi lewee yɛnlɛ wa yaayogo gbo, wi daga mbege yɔngɔ kan wi yeri wege. ");
INSERT INTO dyi_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","«Na lere wa ka wi lewee yɛnlɛ wa wɛlɛgɛ, poo wɛlɛgɛ fun paa yɛgɛ ŋga na wùu wɛlɛgɛ we. ");
INSERT INTO dyi_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Witige laga ka ka kaw, witige laga kayi ki yaa kaw mbege fɔgɔ tɔn; yɛnlɛ li yaa tɛgɛ mbe yɛnlɛ li fɔgɔ tɔn; ŋganla li yaa tɛgɛ mbe ŋganla li fɔgɔ tɔn; jɔgɔwɔ mba wì pye wi lewee yɛnlɛ wi na po cɛnlɛ pi yaa pye wi na fun. ");
INSERT INTO dyi_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","«Lere wa ka yaayogo gbo, wi yaa ki yɔngɔ kan. Lere wa ka wi lewee yɛnlɛ gbo, wi daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","«Kiti kɔngɔ ŋgasele nuŋgba lo lì tɛgɛ nambanmbala poro naa yoro Izirayɛli tara piile ye kan, katugu muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","A Moyisi wì sigi sɛnrɛ ti yo Izirayɛli woolo pe kan. A pè si yiri naŋa ŋa wìla Yɛnŋɛlɛ li mɛgɛ ki jɔgɔ wi ni, ma kari wa paara yinrɛ cɛnsaga ki puŋgo na, mɛɛ saa wi wa sinndɛɛrɛ ni maa gbo. Ŋga Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan, pa pàa ki pye yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni wa Sinayi yanwiga ki na ma yo ");
INSERT INTO dyi_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","wigi sɛnrɛ nda ti yo Izirayɛli woolo pe kan fɔ: «Na yaga ka sa ye wa tara nda mi yaa kan ye yeri ti ni, ye yaa kaa ti yari tila wogo wagati wa ni Yawe Yɛnŋɛlɛ li mɛgɛ ni. ");
INSERT INTO dyi_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Yɛgɛlɛ kɔgɔlɔni ni, ye yaa la ye kɛɛrɛ yariluguro ti nuru, mbaa ye ɛrɛzɛn tiire njere ti yaanla, mbaa ti pire ti coo. ");
INSERT INTO dyi_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ɛɛn fɔ, yɛlɛ kɔlɔshyɛn wolo lo yaa pye tara ti wogoyɛlɛ mbe tɛgɛ li yɛ Yawe Yɛnŋɛlɛ li kan. Tara ti yaa wogo ki yɛlɛ li ni fuun li ni. Ye se ka yariluguro lugu wa ye kɛɛrɛ ti ni, ye se si ka ye ɛrɛzɛn tiire njere ti yaanla. ");
INSERT INTO dyi_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Yɛlɛ na lì toro li yarilire ti kɔnŋgɔlɔ, nda ka fi ti yɛ wa ye kɛɛrɛ ti ni mbe sɛ, ye se kari kɔn. Ɛrɛzɛn tiire njere nda ye sila yaanla, tiga pire nda sɛ mbe yanlaga, ye se kari cɔ; katugu ki yɛlɛ li ni fuun li yaa pye tara ti wogoyɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ye yaa tara ti yaga ti wogo yɛlɛ na ni, yarilire lara nda ka sɛ wa ye kɛɛrɛ ti ni, to ti yaa pye ye yaakara, yoro naa ye kulonambala, naa ye kulojaala, naa ye tunmbyeele mbele pe yɛn na tunŋgo piin sara na konaa nambanmbala mbele pe yɛn ma cɛn wa ye ni pe ni. ");
INSERT INTO dyi_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ki yarilire lara nuŋgba to ti yaa pye ye yaayoro ti yaakara fun, konaa ye tara woŋgaala pe yaakara. ");
INSERT INTO dyi_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«Ye yaa wogoyɛgɛlɛ ke kɔlɔshyɛn jiri, ko yɛn yɛgɛlɛ kɔlɔshyɛn tɛgɛsaga kɔlɔshyɛn, ke ni fuun ke yaa sa pye yɛlɛ nafa shyɛn ma yiri kɔlɔjɛrɛ. ");
INSERT INTO dyi_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ki yɛlɛ nafa shyɛn ma yiri kɔlɔjɛrɛ wolo li yeŋge kɔlɔshyɛn wogo, ki pilige kɛ wogo ki na, ko ŋga ki yɛn kapere ti kala yagawa japilige, ye yaa mbaanra win wa tara ti lagapyew mberi magala li gbɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ki pyelɔmɔ pi na ma, ye yaa ki yo mbege naga fɔ yɛlɛ nafa shyɛn ma yiri kɛ wolo lì tɛgɛ li yɛ Yɛnŋɛlɛ kan; mbege yari fun leele pe ni fuun pe kan tara ti lagapyew fɔ pe mbe ya wɔ kulowo pi ni. Ki yɛlɛ ye yaa lali yinri zhubile. Ki yɛlɛ liga gbɔn, lere ŋa fuun pàa wi kɛɛ yaara shɔ wi yeri, ti yaa sɔngɔrɔ ki fɔ wi na; lere ŋa fuun pàa lɔ kulo, wi yaa sɔngɔrɔ wa wi sege ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Yɛlɛ nafa shyɛn ma yiri kɛ wolo pyew li yaa pye zhubile yɛlɛ ye kan. Ye se ka yariluguro lugu wa ye kɛɛrɛ ti ni; yarilire lara nda ka sɛ wa ye kɛɛrɛ ti ni ye se kari pire ti kɔn. Ɛrɛzɛn tiire njere nda ti sila yaanla, tiga pire nda sɛ mbe yanlaga, ye se kari cɔ; ");
INSERT INTO dyi_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","katugu ki yɛlɛ lo li yɛn zhubile yɛlɛ le; ye daga mbaa li jate fɔ li yɛn ma tɛgɛ li yɛ Yɛnŋɛlɛ kan. Ɛɛn fɔ, yariluguro nda ka fi ti yɛ wa ye kɛɛrɛ ti ni, ye yaa la to kaa. ");
INSERT INTO dyi_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«Zhubile yɛlɛ liga gbɔn, lere ŋa fuun pàa wi kɛɛ yaara shɔ wi yeri, ti yaa sɔngɔrɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ye ni, na wa kaa jaa mbe tara laga ka pɛrɛ nakoma mbe ka lɔ wi sefɔ wa yeri, wa ka ka wa li. ");
INSERT INTO dyi_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Na yaga laga ka lɔ nakoma mbe pɛrɛ ye sefɔ wa yeri, yɛgɛlɛ ŋgele kè toro ma taga zhubile yɛlɛ li na, ye yaa ke jate, mbe laga ki sɔnŋgɔ ki kɔn mbe yala yarilire kɔnyɛgɛlɛ ŋgele ke yɛn na paan ke ni, sanni zhubile yɛlɛ li sa gbɔn. ");
INSERT INTO dyi_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Yɛgɛlɛ ŋgele kè koro, na kaga lɛgɛ, laga ki sɔnŋgɔ ki yaa gbɔgɔ mbe yala ke ni; yɛgɛlɛ ŋgele kè koro, na kaga kologo, laga ki sɔnŋgɔ ki yaa tirige mbe yala ke ni; katugu laga ki yaa pɛrɛ ma yeri mbe yala yarilire kɔnyɛgɛlɛ ke yɔn ko ni. ");
INSERT INTO dyi_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ye ni, wa kpɛ ka kaa lewee yɛnlɛ wa dufile. Ɛɛn fɔ, ye daga mbaa fyɛ ye Yɛnŋɛlɛ li yɛgɛ; katugu muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Yaa tanri na ŋgasegele ke na, yanla kakɔnndɛgɛŋgɛlɛ ke yigi yaa tanri yaa yala ke ni. Pa kona ye yaa cɛn wa tara ti ni yɛyinŋge na pɔw. ");
INSERT INTO dyi_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Tara ti yarilire ti yaa la yɔngɔ ye kan jɛŋgɛ, ye yaa la nii la tinni, mbe cɛn wa tara ti ni yɛyinŋge na pɔw. ");
INSERT INTO dyi_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","«Kana ye yaa ye yɛɛ yewe mbe yo fɔ: Yiŋgi we yaa la kaa yɛlɛ kɔlɔshyɛn wolo lo ni, naa kì kaa pye we se yariluguro lugu, we se si yarilire kɔn we? ");
INSERT INTO dyi_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ye wele, mi ŋa Yawe Yɛnŋɛlɛ, mi yaa duwaw ye na yɛlɛ kɔgɔlɔni wolo li ni, mbe ti ye yarilire ti yɔn jɛŋgɛ ti yɛlɛ taanri woro bɔ. ");
INSERT INTO dyi_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","«Yɛlɛ kɔlɔtaanri wolo li ni, ye yaa yariluguro lugu wa ye kɛɛrɛ ti ni; ɛɛn fɔ, ki yɛlɛ li ni, yarilire lɛrɛ to ye yaa la kaa fɔ sa gbɔn yɛlɛ kɔlɔjɛrɛ wolo li yarilire ti na. Sanni ki yarilire fɔnndɔ ti sa gbɔn, yarilire lɛrɛ to ye yaa la kaa. ");
INSERT INTO dyi_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«Yaga ka tara ta pɛrɛ ti koro ŋa wìri lɔ wi kan suyi, katugu tara ti yɛn mi ŋa Yawe Yɛnŋɛlɛ na woro. Ye yɛn nambanmbala, ma pye cɛnfɛnnɛ laga na yeri. ");
INSERT INTO dyi_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ki kala na, wa tara nda fuun mi yaa kan ye yeri ti ni, ye yaa ŋgasegele tɛgɛtɛgɛ, ŋgele ke yaa ti leele pe ya paa tara nda ti yɛn pe woro ti go shoo. ");
INSERT INTO dyi_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","«Na fyɔnwɔ ka to ma sefɔ wa na, a wùu tara laga ka pɛrɛ, wi go lere ŋa wì yɔngɔ wi ni, wa ka pye wa, ŋa ki kologo yɛn wi yeri wigi go shɔ, ki lerefɔ wi daga mbege go shɔ. ");
INSERT INTO dyi_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Na tara ti go shɔfɔ woro lere ŋa yeri, na wo jate wiga yaraga ta mbe ya mboo tara laga ki go shɔ wi yɛ, ");
INSERT INTO dyi_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","laga ki pɛrɛŋgɔlɔ, yɛgɛlɛ ŋgele kè toro wi yaa ke jiri. Yɛgɛlɛ ŋgele kè koro fɔ sa gbɔn zhubile yɛlɛ li na, wi yaa ke penjara yɔn ki jate mbege sara ŋa wìla laga ki lɔ wi yeri. Pa kona wi laga ki yaa sɔngɔrɔ mbe pye wi wogo naa. ");
INSERT INTO dyi_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ɛɛn fɔ, na wii yaraga ta mbe laga ki go shɔ, pa tara laga ki yaa koro ŋa wìla ki lɔ wi kɛɛ na fɔ sa gbɔn zhubile yɛlɛ li na. Ki wagati wiga ka gbɔn, tara laga ki yaa sɔngɔrɔ mbe pye ti fɔ koŋgbanŋa wi wogo. ");
INSERT INTO dyi_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«Ca ŋga malaga sigembogo yɛn maga maga, na lere wa ka ki go ka pɛrɛ, kologo ŋga ki yɛn wi yeri wigi go shɔ ki yaa pye yɛlɛ nuŋgba poni fogo ni; mbege lɛ le ki pɛrɛpilige ki na fɔ sa gbɔn ki yelapanna. ");
INSERT INTO dyi_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ki go na pee ya mbege go shɔ yɛlɛ nuŋgba fogo ni, ki yaa koro ki lɔfɔ wo naa wi setirige piile pe kan suyi. Ali na zhubile yɛlɛ liga gbɔn, pe se kaga sɔngɔrɔ ki pɛrɛfɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ɛɛn fɔ, cara nda malaga sigembogo woro mari maga, yinrɛ ti yɛn na jate paa kɛɛrɛ nda ti yɛn wa tara ti ni ti yɛn. Pe mbe ya mbe to go shɔ sanga pyew. Zhubile yɛlɛ liga si gbɔn, ti yaa sɔngɔrɔ ti fɛnnɛ pe na. ");
INSERT INTO dyi_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«Levi setirige piile pe cara to na, yinrɛ nda ti yɛn wa ti ni, ki kologo yɛn pe yeri paa ti go shoo sanga pyew. ");
INSERT INTO dyi_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Na lere wa ka Levi setirige pyɔ wa go lɔ, zhubile yɛlɛ liga gbɔn, go ki lɔfɔ wi yaa yiri wa ki ni mbege kan gofɔ wi yeri; katugu Levi setirige piile pe yinrɛ nda wa pe cara ti ni to ti yɛn pe kɔrɔgɔ wa Izirayɛli woolo sanmbala pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Lara nda ti yɛn ma Levi setirige piile pe cara ti maga, tii daga mbe pɛrɛ, katugu tì kan Levi setirige piile pe yeri mbe pye pe woro sanga pyew. ");
INSERT INTO dyi_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«Na fyɔnwɔ ka to ye sefɛnnɛ wa na, na wi kɛɛ kiga koro waga ye sɔgɔwɔ, ye daga mboo saga, jaŋgo wi ya wi cɛn wa ye ni paa nambannjɛɛn yɛn nakoma nambanndorowo yɛn. ");
INSERT INTO dyi_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Yaga kaa tɔnli jaa wi go na, si ka logo tɔnli pee. Ye daga mbege naga wi na wa ye tangalɔmɔ pi ni fɔ ye yɛn na fyɛ mi ŋa ye Yɛnŋɛlɛ na yɛgɛ; jaŋgo ye sefɔ wi ya wi cɛn wa ye ni. ");
INSERT INTO dyi_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Na yaga wi jin penjara ni, yaga kaa tɔnli jaa ti go na, na yaga suu jin yarilire ni, yaga kaa tɔnli jaa wa ti go na. ");
INSERT INTO dyi_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ na lì ye yirige wa Ezhipiti tara mbe Kana tara ti kan ye yeri, jaŋgo mbe pye ye Yɛnŋɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«Na fyɔnwɔ ka to ma sefɔ wa na mbe ti wuu yɛɛ pɛrɛ ma yeri mbaa tunŋgo piin, maga ka kulowo tunndo kan wi yeri. ");
INSERT INTO dyi_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ɛɛn fɔ, ye daga mboo yigi paa ye tunmbyee yɛn, ŋa wi maa tunŋgo piin sara na, nakoma paa ye nambannjɛɛn yɛn. Wi yaa la tunŋgo piin ma kan fɔ sa gbɔn zhubile yɛlɛ li na. ");
INSERT INTO dyi_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Na liga gbɔn, pa wi yaa wɔ wa ma yeri wo naa wi piile pe ni, mbe sɔngɔrɔ wa wi go woolo pe kɔrɔgɔ, mbe sa cɛn tara nda wi tɛlɛye pàa ta kɔrɔgɔ ti na. ");
INSERT INTO dyi_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Katugu Izirayɛli woolo pe yɛn na tunmbyeele, poro mbele mì yirige wa Ezhipiti tara ti ni we. Ki kala na, paga kaa pe pɛrɛ paa yɛgɛ ŋga na pe maa kulolo pe pɛrɛ. ");
INSERT INTO dyi_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Yaga kaa kaŋgbanga piin pe na. Ɛɛn fɔ, yege naga wa ye tangalɔmɔ pi ni fɔ mi ŋa ye Yɛnŋɛlɛ ye yɛn nala gbogo. ");
INSERT INTO dyi_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","«Kulolo kala ka pye ye na, tara nda woolo pe yɛn ma ye maga, yaa ye kulonambala naa ye kulojaala pe loo wa pe yeri. ");
INSERT INTO dyi_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ye mbe ya mbaa nambanmbala mbele pè pan ma cɛn ye sɔgɔwɔ pele loo ye kulolo fun, mbaa pe sege woolo mbele pè se wa ye tara pele loo kulolo. Ye mbe ya mbaa pe loo kulolo pe pye ye woolo. ");
INSERT INTO dyi_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Puŋgo na, ye mbe ya mbe pe yaga ye pinambiile pe kan kɔrɔgɔ. Pe yaa pye ye kulolo fɔ sanga pyew. Ɛɛn fɔ, ye sefɛnnɛ Izirayɛli woolo sanmbala poro na, wa kpɛ ka ka kaŋgbanga taga wa na ye ni. ");
INSERT INTO dyi_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«Nambannjɛɛnlɛ mbele pe yɛn wa ye ni nakoma mbele pè pan ma cɛn mbe wagati jɛnri pye wa ye ni, na wa ka pye penjagbɔrɔ fɔ, fyɔnwɔ mbe si to ma sefɔ Izirayɛli woo wa na, wuu yɛɛ pɛrɛ ki nambanŋa wi yeri, nakoma ki nambanŋa wi go lere wa yeri, ");
INSERT INTO dyi_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","wi yɛɛ pɛrɛŋgɔlɔ, ki kologo mbe ya kan wi yeri poo go shɔ. Wi nɔsepyɔ lenaŋa mbe ya mboo go shɔ. ");
INSERT INTO dyi_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Na wi nɔsepyɔ lenaŋa woro wa, wi tojɛɛ mbe ya mboo go shɔ, nakoma wi tojɛɛ wo pinambyɔ, nakoma wi go lere ŋa wì yɔngɔ wi ni wo wa. Wo jate wiga ka yaraga ta, wi mbe ya mboo yɛɛ go shɔ. ");
INSERT INTO dyi_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Pa kona, wi yaa yɛgɛlɛ ke jate wo naa ŋa wùu lɔ wi ni, mbege lɛ yɛlɛ na wìla wi yɛɛ pɛrɛ li na fɔ sa gbɔn zhubile yɛlɛ na laa paan li na. Wi yaa wi go shɔgɔ sɔnŋgɔ ki kɔn mbe yala yɛgɛlɛ yɔn ŋga kì koro ko ni; ki penjara ti yaa jate mbe yala tunmbyee wi pilige nuŋgba sara wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Yɛgɛlɛ yɔn ŋga kì koro zhubile yɛlɛ lii gbɔn, na kaga lɛgɛ, pa kona, penjara nda wi lɔfɔ wìla kan maa lɔ, wi yaa ti lɛgɛrɛ sɔngɔrɔ wi lɔfɔ wi na. ");
INSERT INTO dyi_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Yɛgɛlɛ ŋgele kè koro fɔ sa gbɔn zhubile yɛlɛ li na, na kiga pye kee lɛgɛ, wi yaa ke jate mboo go shɔgɔ penjara ti sɔngɔrɔ wi lɔfɔ wi na mbe yala yɔn ŋga kì koro ko ni. ");
INSERT INTO dyi_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Mboo ta wa wi tafɔ wi yeri, wi daga mbaa jate paa tunmbyee ŋa pe ma lɛ yɛlɛ nuŋgba tunŋgo na wa yɛn. Yaga ka ti wi tafɔ wila kaŋgbanga piin wi na. ");
INSERT INTO dyi_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Na ye sefɔ pe suu go shɔ ki yɛgɛ ŋga ko ka na, pa kona zhubile yɛlɛ liga gbɔn, wo naa wi piile pe ni pe yaa wɔ wa wi tafɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Katugu yoro Izirayɛli woolo ye yɛn na tunmbyeele, mà jɛn muwi mì ye yirige wa Ezhipiti tara; muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«Yaga ka yarisunndo gbegele ye yɛɛ kan; yaga ka yaraga ka yanlɛɛ tɛ mbege yerege, nakoma mbe sinndɛlɛgɛ yerege mbaa sunnu ki na; yaga ka sinndɛɛrɛ nda pè keregi keregi ta tɛgɛ wa ye tara mbaa fɔli ti yɛgɛ sɔgɔwɔ mbaa ti gbogo; katugu muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","«Yaa na cɛnpiliye yi cɛɛn, yaa na cɛnsaga paraga go ki jate. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Na ye kaa tanri na ŋgasegele ke na, mbanla kakɔnndɛgɛŋgɛlɛ ke yigi mbaa tanri ke na, ");
INSERT INTO dyi_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","pa kona mi yaa ti tisara tila paan tila yala ti wagati wi ni, jaŋgo yarilire tila yɔngɔ wa tara ti ni, tire fun tila sɛni. ");
INSERT INTO dyi_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kona ye yarilire ye yaa ti sun fɔ sa gbɔn ɛrɛzɛn pire cɔsanga wi na, mbe ɛrɛzɛn wi cɔ fun fɔ sa gbɔn yariluguro sanga wi na. Ye yaa yaakara lɛgɛrɛ ta. Ye yaa si cɛn wa tara ti ni yɛyinŋge na pɔw. ");
INSERT INTO dyi_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Mi yaa ti yɛyinŋge mbe pye wa tara ti ni. Na yaga sinlɛ, yaraga ka kpɛ se ka pan mbe ye jatere wi piri ye na. Mi yaa woŋgapeele pe kɔ mbe pe wɔ wa tara ti ni. Pe se ka yiri ye kɔrɔgɔ mbe malaga gbɔn ye ni. ");
INSERT INTO dyi_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ye yaa ka taga ye juguye pe na la pe puro. Ye yaa kaa pe kuun tokobi ni. ");
INSERT INTO dyi_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ye ni, lere kaŋgurugo yaa ka ye juguye pe cɛnmɛ purɔ; ye ni, lere cɛnmɛ ya ka ye juguye pe waga kɛ (10 000) purɔ. Ye yaa ka pe gbo tokobi ni. ");
INSERT INTO dyi_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Mi yaa la wele ye na, mbe ye pye sevɛnnɛ, ye yaa se mbe lɛgɛ jɛŋgɛ. Mi yaa ti na yɔn finliwɛ pi koro mi naa yoro we sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ye yarilire ti yaa la yɔngɔ jɛŋgɛ fɔ nda ye yaa tɛgɛ, ye yaa kari ka mbe mɔ. Ye yaa kaa lɛrɛ ti woo wa ti tɛgɛsaga mbaa fɔnndɔ ti teri. ");
INSERT INTO dyi_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Na cɛnsaga ki yaa pye wa ye sɔgɔwɔ. Mi se ka laga ye na. ");
INSERT INTO dyi_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mi yaa pye wa ye sɔgɔwɔ, mbe pye ye Yɛnŋɛlɛ, ye pye na woolo. ");
INSERT INTO dyi_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ na lì ye yirige wa Ezhipiti tara ti ni, ma ye wɔ wa kulowo pi ni. Jɔlɔgɔ ŋga pàa taga ye na, mìgi laga ye na, koni ye mbe ya mbaa tanri ye yɔlɔgɔ ki ni caw. ");
INSERT INTO dyi_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Ɛɛn fɔ, na ye woro na nuru na yeri mbaa tanri na kakɔnndɛgɛŋgɛlɛ ke na, ");
INSERT INTO dyi_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","na yaga je na lasiri wi na, mbe puŋgo le na kakɔnndɛgɛŋgɛlɛ ke ni, mbe je na ŋgasegele ke na, mbanla yɔn finliwɛ pi jɔgɔ, ");
INSERT INTO dyi_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","kagala ŋgele mi yaa pye ye na ke ŋgele: «Mi yaa fyɛrɛ gbɔrɔ wa ye na, naa cɔgɔrɔ yama ni, konaa witiwɛrɛwɛ ni. Ki yama pi yaa ye yɛngɛlɛ ke jɔgɔ ye na, ye se pye sɛnweele kpayi. Ye yaa la ye yariluguro ti nuru wagafe; ɛɛn fɔ, ye juguye poro pe yaa kaa ki yarilire ti kaa. ");
INSERT INTO dyi_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Mi yaa yiri ye kɔrɔgɔ mbe ti ye juguye pe ya ye ni; ye winfɛnnɛ pe yaa cɛn ye go na. Ye yaa la fee, ali mbege ta lere woro na ye puro. ");
INSERT INTO dyi_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Na ko kagala koro si ti yaa nuru na yeri, jɔlɔgɔ ŋga mì wa ye na ye kapere ti kala na, mi yaa ki tɛgɛsaga kɔlɔshyɛn wa ye na naa. ");
INSERT INTO dyi_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Mi yaa ye yɛɛ gbɔgɔwɔ fanŋga ki kɔ, mbe ti naayeri wi sheli paa tugurɔn yɛn, mbe ti tisaga kala li ŋgban laga tara ti ni, mbe tara ti sheli paa tuguyɛnrɛ yɛn. ");
INSERT INTO dyi_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ye yaa tunŋgo pye mbe ye fanŋga ki kɔ jaga; ye yariluguro ti se kaa yɔngɔ, ye tara tire ti se kaa sɛni. ");
INSERT INTO dyi_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«Na yaga si yiri mbe je na na mbe yo ye saa nuru na yeri, jɔlɔgɔ ŋga mì wa ye na ye kapere ti kala na, mi yaa ki tɛgɛsaga kɔlɔshyɛn wa ye na naa. ");
INSERT INTO dyi_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mi yaa cɛnrɛ pere yirige mbe wa ye na wa ye tara; ti yaa la ye piile pe yinri mbaa ye yaayoro ti kuun. Ti yaa ka kɔn ye lɛgɛwɛ pi na mbege kan ye koŋgolo ke koro waga. ");
INSERT INTO dyi_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Na ko jɔlɔgɔ kagala koro si ye koro, na yaga je bere ye woro na nuru na yeri, ");
INSERT INTO dyi_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","kona mi fun mi yaa yiri ye kɔrɔgɔ, mbe jɔlɔgɔ ŋga ye na ki tɛgɛsaga kɔlɔshyɛn wa ye na naa ye kapere ti kala na. ");
INSERT INTO dyi_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Mi yaa ti malaga mbe to ye na wa ye tara, mbanla yɔn finliwɛ mba yè jɔgɔ pi kayaŋga wɔ ye ni. Na yaga fe sa laralara wa ye cagbɔrɔ gbɔrɔ ti ni, pa mi yaa ti tifɛlɛgɛ yama mbe to ye na konaa mbe ye le ye juguye pe kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Mi yaa ti yaakara ti kɔ ye yeri. Jɛlɛ kɛ yaa ka ye buru wi fɔ yira nuŋgba ni, pe yaa kaa wi taanla culo na, mbaa wi kaan ye yeri jɛgɛlɛ jɛgɛlɛ; ye yaa ka, ɛɛn fɔ ye se tin. ");
INSERT INTO dyi_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Ko kagala ŋgele koro ke ni fuun pyeŋgɔlɔ, na ye woro na nuru na yeri bere, na yaga koro mbaa jege na na, ");
INSERT INTO dyi_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","kona mi fun mi yaa yiri ye kɔrɔgɔ naŋgbanwa ni, mbe jɔlɔgɔ ŋga ye na ki tɛgɛsaga kɔlɔshyɛn wa ye na naa. ");
INSERT INTO dyi_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Kona ye yaa la ye yɛɛra piile pe kaa. ");
INSERT INTO dyi_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Mi yaa ye sunzara nda wa tinndiye pe na ti jɔgɔ; yarisunŋgo ŋga pe yinri Yɔnlɔ, tiyagala ŋgele yè kankan naga gbogo wa ke na, mi yaa ke kɔɔnlɔ mbe ke jaanri, mbe yoro jate ye gboolo pe wa wa ye yarisunndo nda tì jɔgɔ ti go na. ");
INSERT INTO dyi_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mi yaa ye cagbɔrɔ ti pye katara, mbe ye yarisunndo sunzara ti jɔgɔ mberi yaga waga. Mi se yɛnlɛ ye saara naa ye yarikanra ti nuwɔ taan pilan nawa pi yinŋgi na na. ");
INSERT INTO dyi_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Mi yaa ye tara ti jɔgɔ jɔgɔwɔ pa na, fɔ ye juguye mbele pe yaa pan mbe cɛn wa, ki yaa to pe yɔn na. ");
INSERT INTO dyi_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Mi yaa ti malaga mbe to ye na mbe ye jaraga cɛngɛlɛ sanŋgala ŋgele laga tara na ke sɔgɔwɔ. Ye tara ti yaa koro waga, ye cara ti yaa pye katara. ");
INSERT INTO dyi_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","«Pa kona, wagati ŋa fuun ye yaa pye wa ye juguye pe tara mbe ye tara ti yaga waga, ti yaa wogo ko wagati wo ni, wagati ŋa ye mbaa yaga ti wogo wi yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ki wagati ŋa fuun tara ti yaa koro waga, ti yaa wogo. Wogowo mba pi sila ta ye wogoyɛgɛlɛ ke ni, ma ye ta wa ti ni, ti yaa wogo ki yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«Yoro mbele ye yaa ka koro wa ye juguye pe tara, mi yaa sunndo kɔngɔ wa ye na, fɔ ali tifɛlɛgɛ kiga wɛŋgɛ nuŋgba tin, ye yaa la fee ki tinmɛ pi yɛgɛ. Ye yaa kaa fee paa yɛgɛ ŋga na lere jugu kaa wi puro tokobi ni wi maa fee we; ye yaa kaa tuun ali mbege ta lere woro na ye puro o. ");
INSERT INTO dyi_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ye yaa kaa kunrugu ye yɛɛ na paa yɛgɛ ŋga na lere ma kaa na fee wi jugu yɛgɛ we, mbe sigi ta lere woro na ye puro. Ye se ka ya yere mbe ye juguye pe sige. ");
INSERT INTO dyi_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Ko ki ni fuun puŋgo na, ye yaa ku cɛngɛlɛ kele yɛgɛ sɔgɔwɔ, ye yɛn ye juguye mbele tara, pe yaa ye gbo mbe ye kɔ. ");
INSERT INTO dyi_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Yoro sanmbala mbele ka koro yinwege na wa ye juguye pe tara, ye yaa la waga ye kapere to naa ye tɛlɛye pe kapere ti kala na. ");
INSERT INTO dyi_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«Ɛɛn fɔ, leele mbele pe yaa ka koro yinwege na pe yaa kaga jɛn fɔ poro naa pe tɛlɛye pe ni pè kapere pye na na, ma yiri ma je pe woro na nuru na yeri. ");
INSERT INTO dyi_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Pe yaa kaga jɛn fun fɔ ko ki ti mì yiri pe kɔrɔgɔ mbe pe torogo wa pe juguye pe tara. Na paga ka pe mbasinmɛ pi jɛn, mbe kanŋga mbe pe yɛɛ tirige, mbege jɛn fɔ jɔlɔgɔ ŋga kì taga pe na pe kapere ti kala na kì yala pe ni, ");
INSERT INTO dyi_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","pa kona mi yaa jatere pye na yɔn finliwɛ mba mìla le Zhakɔbu ni pi na, naa na yɔn finliwɛ mba mìla le Izaki ni pi na, konaa na yɔn finliwɛ mba mìla le Abirahamu ni pi na. Mi yaa jatere pye fun yɔn fɔlɔ na mì lɛ pe tara wogo ki na li na. ");
INSERT INTO dyi_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Mbe pe ta pè yiri wa tara ti ni mari yaga, a tì koro waga, ti yaa wogo ki wagati wi ni. Ko sanga wo ni, pe yaa ki jɛn fɔ jɔlɔgɔ ŋga kì taga pe na kì yala; katugu pè je na ŋgasegele ke na, ma puŋgo le na kakɔnndɛgɛŋgɛlɛ ke ni, koro ŋgele kè yiri laga na yeri we. ");
INSERT INTO dyi_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Konaa ki ni fuun, ali mbe pe ta wa pe juguye pe tara, mi se ka pe wa pew; pe kala li se kanla mbɛn fɔ sa gbɔn mbe pe tɔngɔ mbe pe kɔ. Mi se kanla yɔn finliwɛ pi jɔgɔ mi naa poro sɔgɔwɔ. Muwi mi yɛn Yawe Yɛnŋɛlɛ, pe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Mi yaa la jatere piin na yɔn finliwɛ pi na pe kan, po mba mìla le pe tɛlɛye pe ni we; poro mbele mìla yirige wa Ezhipiti tara ti ni cɛngɛlɛ sanŋgala ke yɛgɛ sɔgɔwɔ, jaŋgo mbe pye pe Yɛnŋɛlɛ. Muwi mi yɛn Yawe Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ŋgasegele naa kakɔnndɛgɛŋgɛlɛ naa sɛnyoro nda Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan wa Sinayi yanwiga ki na ma yo wiri yo Izirayɛli woolo pe kan tori yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo ");
INSERT INTO dyi_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","wigi sɛnrɛ nda ti yo Izirayɛli woolo pe kan wi pe pye fɔ: «Na lere wa ka yɔn fɔlɔ lɛ mbe lewee kan Yawe Yɛnŋɛlɛ li yeri, wi mbe ya mboo yɔn fɔlɔ li tɔn penjara yɔn ka ni. ");
INSERT INTO dyi_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Penjara yɔn ŋga ki daga mbaa sara ki ŋga: Na kiga pye naŋa pe yaa go shɔ, mbege lɛ ŋa wì ta yɛlɛ nafa sa gbɔn yɛlɛ nafa taanri, wi go shɔgɔ penjara ti yaa pye warifuwe pyɔ nafa shyɛn ma yiri kɛ, mbe yala cɛnsaga paraga go ki warifuwe pyɔ jatere wi ni. ");
INSERT INTO dyi_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Na kiga pye jɛlɛ wi, wi go shɔgɔ penjara ti yaa pye warifuwe pyɔ nafa ma yiri kɛ. ");
INSERT INTO dyi_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","«Mbege lɛ lenambyɔ ŋa wì ta yɛlɛ kaŋgurugo sa gbɔn yɛlɛ nafa fɛnnɛ pe na, wi go shɔgɔ penjara ti yaa pye warifuwe pyɔ nafa. Wiga pye sumboro, wi go shɔgɔ penjara ti yaa pye warifuwe pye kɛ. ");
INSERT INTO dyi_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","«Mbege lɛ ŋa wì ta yeŋge nuŋgba sa gbɔn fɔ yɛlɛ kaŋgurugo fɛnnɛ pe na, wiga pye lenambyɔ, wi go shɔgɔ penjara ti yaa pye warifuwe pyɔ kaŋgurugo; wiga pye sumboro, ti yaa pye warifuwe pyɔ taanri. ");
INSERT INTO dyi_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","«Mbege lɛ mbele pè ta yɛlɛ nafa taanrindaanri konaa pe yɛgɛ fɛnnɛ pe ni, na wiga pye naŋa, wi go shɔgɔ penjara ti yaa pye warifuwe pyɔ kɛ ma yiri kaŋgurugo; na wiga pye jɛlɛ, ti yaa pye warifuwe pyɔ kɛ. ");
INSERT INTO dyi_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","«Lere ŋa wì yɔn fɔlɔ li lɛ, wiga pye fyɔnwɔ fɔ, na wi se ya mbe penjara yɔn ŋga ki naga ki sara, pe yaa kari wi ni wa saraga wɔfɔ wi yeri. Saraga wɔfɔ wi yaa penjara yɔn ka naga mbe yala yɔn fɔlɔ lɛfɔ wi tawa pi ni. ");
INSERT INTO dyi_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«Na kaa pye yɔn fɔlɔ wìli lɛ mbe yaayogo kan, ŋga pe mbe ya wɔ saraga Yawe Yɛnŋɛlɛ li yeri, ki yaayogo ki yaa la jate kì tɛgɛ ki yɛ na kan. ");
INSERT INTO dyi_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Pe se ka ki yaayogo ki suru ka ni, pe se ka yaayogo tiyɔngɔ suru yaayogo tijaanga ni, nakoma mbe yaayogo tijaanga suru yaayogo tiyɔngɔ ni; katugu na paga ki yaayogo ki suru ka yɛgɛ ni, ti shyɛn ti yaa la jate ti tɛgɛ ti yɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Na kaa pye yɔn fɔlɔ wìli lɛ mbe yaayogo ŋga kan ki yɛn yaayoro nda ti yɛn fyɔngɔ ni ko ka, ŋga ki se ya wɔ saraga Yawe Yɛnŋɛlɛ li yeri, pe yaa kari ki ni wa saraga wɔfɔ wi yeri. ");
INSERT INTO dyi_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Saraga wɔfɔ wi yaa ki penjara yɔn ki naga mbe yala yaayogo ki tiyɔnwɔ nakoma ki tijangawa po ni; ko penjara to pe yaa sara mbe yala yɔn ŋga wì naga ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Na kiga pye yaayogo fɔ wi yɛn na jaa mbe yaayogo ki go shɔ, saraga wɔfɔ wiga penjara yɔn ŋga naga, wi yaa ki sara mbege walisaga kaŋgurugo wogo taga wa ki na. ");
INSERT INTO dyi_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«Na lere wa kaa jaa mboo go tɛgɛ ki yɛ, mbege pye yaraga ŋga kì tɛgɛ ki yɛ Yawe Yɛnŋɛlɛ li kan, saraga wɔfɔ wi yaa ki sɔnŋgɔ ki kɔn mbe yala ki tiyɔnwɔ nakoma ki tijangawa pi ni. Ko penjara to pe yaa sara mbe yala ki yɔn ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ŋa wì go ki tɛgɛ ki yɛ li kan, na wi kaa jaa mbege go shɔ, wi yaa penjara yɔn ŋga kì naga ki sara, mbege yɔn ki walisaga kaŋgurugo wogo taga wa ki na, kona go ki yaa sɔngɔrɔ mbe pye wi wogo naa. ");
INSERT INTO dyi_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«Na lere wa ka tara nda wì ta kɔrɔgɔ ki laga ka tɛgɛ ki yɛ Yawe Yɛnŋɛlɛ li kan, ki sɔnŋgɔ ki yaa kɔn mbe yala yariluguro nda ti mbe ya lugu wa ti lɛgɛwɛ po ni. Na kaa pye ɔrizhi pyɔ culo cɛnmɛ taanri (300) wi, ki penjara yɔn ki yaa pye warifuwe pyɔ nafa shyɛn ma yiri kɛ. ");
INSERT INTO dyi_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Na wiga kɛrɛ ti tɛgɛ ti yɛ Yɛnŋɛlɛ kan zhubile yɛlɛ li ni, maga penjara yɔn ŋga naga, ko ki yaa yere. ");
INSERT INTO dyi_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Na wiga kɛrɛ ti tɛgɛ ti yɛ Yɛnŋɛlɛ kan zhubile yɛlɛ li toroŋgɔlɔ, saraga wɔfɔ wi yaa penjara yɔn ki kɔn mbege tirige mbe yala yɛgɛlɛ yɔn ŋga kì koro sanni zhubile yɛlɛ li sa gbɔn ke ni. ");
INSERT INTO dyi_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","«Na kɛrɛ fɔ wi kaa jaa mbe kɛrɛ ti go shɔ, saraga wɔfɔ wi ka penjara yɔn ŋga naga, wi yaa ki sara, mbege walisaga kaŋgurugo wogo taga wa ki na. ");
INSERT INTO dyi_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","«Na wii kɛrɛ ti go shɔ, wiga ti pɛrɛ lere wa yɛgɛ yeri, ko puŋgo na wi se ka ya mberi go shɔ naa. ");
INSERT INTO dyi_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kona zhubile yɛlɛ liga gbɔn, ŋa wì kɛrɛ ti lɔ, wi yaa wɔ wa ti ni, ti yaa kan Yawe Yɛnŋɛlɛ li yeri paa kɛrɛ nda pe ma tɛgɛ ti yɛ pew li kan ti yɛn. Pa ti yaa pye saraga wɔfɔ wi woro. ");
INSERT INTO dyi_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«Na lere wa ka kɛrɛ nda wì lɔ wi yɛɛ kan ti kan Yawe Yɛnŋɛlɛ li yeri, ki pye nda ti yɛn wi kɔrɔgɔ to ta ma, ");
INSERT INTO dyi_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","saraga wɔfɔ wi yaa kɛrɛ ti sɔnŋgɔ ki kɔn mbe yala yɛgɛlɛ yɔn ŋga kì koro sanni zhubile yɛlɛ li sa gbɔn ke ni. Kɛrɛ ti kanfɔ wi yaa ki penjara ti sara ki pilige nuŋgba ki ni; katugu kɛrɛ tì kan Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Na zhubile yɛlɛ liga gbɔn, pàa kɛrɛ ti lɔ naŋa ŋa yeri, ti yaa sɔngɔrɔ ki fɔ wi na, ko kɔrɔ wo yɛn fɔ ŋa wìla ti ta kɔrɔgɔ we. ");
INSERT INTO dyi_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","«Penjara yɔn ŋga fuun ki yaa naga, ki daga mbe kɔn mbe yala cɛnsaga paraga go ki warifuwe pyɔ jatere wi ni; ki warifuwe pyɔ nuŋgba wi nuguwɔ pi yɛn giramu kɛ. ");
INSERT INTO dyi_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«Yaayoro ti pinambire koŋgbannda ti yɛn na woro makɔ. Lere si daga mboo yaayogo ka pinambige tɛgɛ ki yɛ Yawe Yɛnŋɛlɛ li kan, napige yi o, simbapige yi o, nakoma sikapige yi o; katugu pinambyɔ koŋgbanŋa pyew wi yɛn ma tɛgɛ wi yɛ Yawe Yɛnŋɛlɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Yaayoro nda ti yɛn fyɔngɔ ni, na kiga pye ko ka pinambige koŋgbanŋga yi, ki fɔ wi yaa ki go shɔ mbe yala penjara yɔn ŋga ki yaa naga ki ni, mberi walisaga kaŋgurugo wogo ki taga wa ti na. Na yaayogo fɔ wi sigi go shɔ, saraga wɔfɔ wi mbe ya mbege pɛrɛ mbe yala yɔn ŋga wi yaa naga ki ni. ");
INSERT INTO dyi_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«Na lere wa kaa kɛɛ yaraga ka tɛgɛ ki yɛ pew Yawe Yɛnŋɛlɛ li kan, na kaa pye lere wi, nakoma yaayogo, nakoma kɛrɛ ri, mbe yiri wa tara nda wìla ta kɔrɔgɔ ti ni, ki yaraga ki se ya pɛrɛ, pe se si ya mbege go shɔ; katugu yaraga ŋga fuun ki tɛgɛ ki yɛ pew li kan, ki yɛn jɛŋgɛ kpoyi ma pye li wogo. ");
INSERT INTO dyi_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ali kaa pye pè lere wa tɛgɛ wi yɛ pew Yawe Yɛnŋɛlɛ li kan, pe se kaa go shɔ, ɛɛn fɔ wi daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«Yaga ŋa fuun wi ma ta wa ye kɛɛrɛ ti ni, ye yarilire yaga wowi yo, nakoma ye tige pire yaga wowi yo, wi yɛn Yawe Yɛnŋɛlɛ li woo, wi yɛn ma tɛgɛ wi yɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Na lere wa kaa jaa mbe yaga wi go shɔ, wi yaa yaga wi penjara yɔn ki sara mbege walisaga kaŋgurugo wogo taga wa ki na. ");
INSERT INTO dyi_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Nɛrɛ, naa simbaala konaa sikaala poro yaga wo na, tɛgɛrɛ tɛgɛkanŋgala li yaa taga ŋga fuun na, ko kɔrɔ wo yɛn kɛ wogo ye, ko yaa kan Yawe Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Yaayoro fɔ wii daga mberi wele na kaa pye tì yɔn nakoma ti yɛn ma tijanga. Wii daga mbe ka suru ka yɛgɛ ni. Na wiga ka suru ka ni, ti shyɛn ti yaa pye mbe tɛgɛ ti yɛ Yawe Yɛnŋɛlɛ li kan; pe se ya mberi go shɔ.» ");
INSERT INTO dyi_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ki ŋgasegele ŋgele koro wɛlɛ Yawe Yɛnŋɛlɛ làa kan Moyisi wi yeri wa Sinayi yanwiga ki na ma yo wi ke yo Izirayɛli woolo pe kan.");
INSERT INTO dyi_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni wa filisaga paraga go ki ni, wa Sinayi yanwiga gbinri wi ni. Kìla pye Izirayɛli woolo pe yiriŋgɔlɔ wa Ezhipiti tara, ki yɛlɛ shyɛn wolo li yeŋge shyɛn wogo ki pilige koŋgbanŋga ki na. Làa wi pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Ye Izirayɛli gbogolomɔ woolo pe ni fuun pe mɛrɛ ti yɔnlɔgɔ ye yala pe setiriye yo naa pe seye yi ni. Ye nambala pe ni fuun nuŋgba nuŋgba pe jiri. ");
INSERT INTO dyi_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Mboro naa Arɔn wi ni, ye nambala mbele pe mbe ya malaga gbɔn pe ni fuun pe jiri, mbege lɛ mbele pè ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni, poro mbele pè pye Izirayɛli woolo pe maliŋgbɔɔnlɔ ŋgbeleye ye. ");
INSERT INTO dyi_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Cɛnlɛ pyew li naŋa nuŋgba daga mbe pye ye ni, poro pe yaa pye pe setiriye woolo pe go na mbaa ye sari. ");
INSERT INTO dyi_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Leele mbele pe yaa taga ye na mbaa ye sari pe mɛrɛ ti nda: Urubɛn cɛnlɛ woo wowi ŋa Shedewuri pinambyɔ Elisuri. ");
INSERT INTO dyi_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeyɔn cɛnlɛ woo wowi ŋa Zurishadayi pinambyɔ Shelumiyɛli. ");
INSERT INTO dyi_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Zhuda cɛnlɛ woo wowi ŋa Aminadabu pinambyɔ Naashɔn. ");
INSERT INTO dyi_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isakari cɛnlɛ woo wowi ŋa Suwari pinambyɔ Netaneyɛli. ");
INSERT INTO dyi_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zabulɔn cɛnlɛ woo wowi ŋa Elɔn pinambyɔ Eliyabu. ");
INSERT INTO dyi_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Zhozɛfu pinambyɔ Efirayimu wi cɛnlɛ woo wowi ŋa Amihudi pinambyɔ Elishama. Zhozɛfu pinambyɔ Manase wi cɛnlɛ woo wowi ŋa Pedasuri pinambyɔ Gamiliyɛli. ");
INSERT INTO dyi_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Bɛnzhamɛ cɛnlɛ woo wowi ŋa Gidewoni pinambyɔ Abidan. ");
INSERT INTO dyi_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan cɛnlɛ woo wowi ŋa Amishadayi pinambyɔ Ayezɛri. ");
INSERT INTO dyi_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asɛri cɛnlɛ woo wowi ŋa Okiran pinambyɔ Pagiyɛli. ");
INSERT INTO dyi_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gadi cɛnlɛ woo wowi ŋa Dewuwɛli pinambyɔ Eliyazafu. ");
INSERT INTO dyi_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nɛfitali cɛnlɛ woo wowi ŋa Ena pinambyɔ Ayira.» ");
INSERT INTO dyi_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Poro wɛlɛ pàa wɔ Izirayɛli gbogolomɔ woolo pe sɔgɔwɔ, a pè pye pe cɛngɛlɛ ke teele; poro pàa pye Izirayɛli woolo waga lɛgɛrɛ teele wele. ");
INSERT INTO dyi_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ki nambala kɛ ma yiri shyɛn mbele pe mɛrɛ ti naga yɛɛn, poro wɛlɛ Moyisi naa Arɔn pàa taga pe yɛɛ na. ");
INSERT INTO dyi_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","A pè si gbogolomɔ woolo pe ni fuun pe gbogolo pe yiriŋgɔlɔ wa Ezhipiti tara, yɛlɛ shyɛn wolo li yeŋge shyɛn wogo ki pilige koŋgbanŋga ki na. Pàa leele pe mɛrɛ ti yɔnlɔgɔ ma yala pe cɛngɛlɛ, naa pe setiriye yo naa pe seye yi ni. Pàa nambala pe ni fuun nuŋgba nuŋgba pe jiri maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Moyisi wìla pe jiri wa Sinayi gbinri wi ni, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo wi kan we. ");
INSERT INTO dyi_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Izirayɛli pinambyɔ koŋgbanŋa Urubɛn wi setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Nambala mbele pàa jiri wa Urubɛn cɛnlɛ li ni, pàa pye lere waga nafa shyɛn ma yiri kɔgɔlɔni naa cɛnmɛ kaŋgurugo (46 500). ");
INSERT INTO dyi_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeyɔn setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Nambala mbele pàa jiri wa Simeyɔn cɛnlɛ li ni, pàa pye lere waga nafa shyɛn ma yiri kɛ ma yiri kɔlɔjɛrɛ naa cɛnmɛ taanri (59 300). ");
INSERT INTO dyi_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gadi setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Nambala mbele pàa jiri wa Gadi cɛnlɛ li ni, pàa pye lere waga nafa shyɛn ma yiri kaŋgurugo naa cɛnmɛ kɔgɔlɔni naa nafa shyɛn ma yiri kɛ (45 650). ");
INSERT INTO dyi_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Zhuda setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Nambala mbele pàa jiri wa Zhuda cɛnlɛ li ni, pàa pye lere waga nafa taanri ma yiri kɛ ma yiri tijɛrɛ, naa cɛnmɛ kɔgɔlɔni (74 600). ");
INSERT INTO dyi_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Isakari setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Nambala mbele pàa jiri wa Isakari cɛnlɛ li ni, pàa pye lere waga nafa shyɛn ma yiri kɛ ma yiri tijɛrɛ naa cɛnmɛ tijɛrɛ (54 400). ");
INSERT INTO dyi_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zabulɔn setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Nambala mbele pàa jiri wa Zabulɔn cɛnlɛ li ni, pàa pye lere waga nafa shyɛn ma yiri kɛ ma yiri kɔlɔshyɛn naa cɛnmɛ tijɛrɛ (57 400). ");
INSERT INTO dyi_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Zhozɛfu pinambyɔ Efirayimu setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Nambala mbele pàa jiri wa Efirayimu cɛnlɛ li ni, pàa pye lere waga nafa shyɛn naa cɛnmɛ kaŋgurugo (40 500). ");
INSERT INTO dyi_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manase setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Nambala mbele pàa jiri wa Manase cɛnlɛ li ni, pàa pye lere waga nafa ma yiri kɛ ma yiri shyɛn naa cɛnmɛ shyɛn (32 200). ");
INSERT INTO dyi_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Bɛnzhamɛ setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Nambala mbele pàa jiri wa Bɛnzhamɛ cɛnlɛ li ni, pàa pye lere waga nafa ma yiri kɛ ma yiri kaŋgurugo naa cɛnmɛ tijɛrɛ (35 400). ");
INSERT INTO dyi_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Nambala mbele pàa jiri wa Dan cɛnlɛ li ni, pàa pye lere waga nafa taanri ma yiri shyɛn naa cɛnmɛ kɔlɔshyɛn (62 700). ");
INSERT INTO dyi_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Asɛri setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Nambala mbele pàa jiri wa Asɛri cɛnlɛ li ni, pàa pye lere waga nafa shyɛn ma yiri nuŋgba naa cɛnmɛ kaŋgurugo (41 500). ");
INSERT INTO dyi_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Nɛfitali setirige piile poro na, mbe yala pe setiriye yo naa pe seye yi ni, nambala mbele fuun pe mbaa ya malaga gbɔn, pàa pe ni fuun nuŋgba nuŋgba pe mɛrɛ ti yɔnlɔgɔ, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Nambala mbele pàa jiri wa Nɛfitali cɛnlɛ li ni, pàa pye lere waga nafa shyɛn ma yiri kɛ ma yiri taanri naa cɛnmɛ tijɛrɛ (53 400). ");
INSERT INTO dyi_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ki leele mbele, poro wɛlɛ Moyisi naa Arɔn, naa leele kɛ ma yiri shyɛn mbele pàa pye Izirayɛli woolo pe go na pàa jiri we. Ki nambala pàa yiri nuŋgba nuŋgba Izirayɛli cɛngɛlɛ kɛ ma yiri shyɛn ke ni ma pye pe seye yi teele. ");
INSERT INTO dyi_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Izirayɛli woolo mbele pàa jiri ma yala pe seye yi ni, mbele pe mbaa ya mbe malaga gbɔn, maga lɛ mbele pàa ta yɛlɛ nafa nafa konaa pe yɛgɛ fɛnnɛ pe ni, ");
INSERT INTO dyi_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","pe ni fuun pàa pye lere waga cɛnmɛ kɔgɔlɔni ma yiri taanri, naa cɛnmɛ kaŋgurugo naa nafa shyɛn ma yiri kɛ (603 550). ");
INSERT INTO dyi_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Levi setirige piile, mbe yala pe cɛnlɛ li ni, pe sila pe jiri mbe pe pinlɛ Izirayɛli woolo sanmbala pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Katugu Yawe Yɛnŋɛlɛ làa para Moyisi wi ni maa pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Maga ka Levi setirige piile pe cɛnlɛ li jiri, maga si ka pe mɛrɛ ti yɔnlɔgɔ mberi pinlɛ Izirayɛli woolo sanmbala pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ɛɛn fɔ, Yɛnŋɛlɛ li cɛnsaga paraga go ŋga yɔn finliwɛ sɛnrɛ ti yɛn ma tɛgɛ wa ki ni konaa ki tunŋgo pyeyaara ti ni, naa ki nawa yaara ti ni fuun ti ni, mari le Levi setirige piile pe kɛɛ. Poro pe yaa la Yɛnŋɛlɛ cɛnsaga paraga go ki tungu, naa ki tunŋgo pyeyaara ti ni, mbaa tunŋgo ŋga ki yaa la piin wa ki ni ki piin; paga sa cɛn laga o laga, pe yaa pe paara yinrɛ ti kankan mbe cɛn mbege maga. ");
INSERT INTO dyi_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Na yaga ka yiri mbaa kee, poro pe yaa Yɛnŋɛlɛ cɛnsaga paraga go ki kɔlɔgi. Na paga ka sa cɛn, poro pe yaa ki kan. Na lere wa ka fulo wa ki tanla, na Levi setirige pyɔ ma, wi daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Izirayɛli woolo pe ni fuun nuŋgba nuŋgba pe yaa pe paara yinrɛ ti kankan wa pe cɛnsara ti ni. Nambala pe ni fuun nuŋgba nuŋgba pe daga mbe pye wa pe cɛngɛlɛ ke tɛgɛrɛ yaara ti tanla, mbe yala pe maliŋgbɔɔnlɔ ŋgbeleye yi ni. ");
INSERT INTO dyi_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Levi setirige piile poro pe yaa pe paara yinrɛ ti kankan mbe cɛn, mbe Yɛnŋɛlɛ cɛnsaga paraga go ki maga, ko ŋga yɔn finliwɛ kɛsu wi yɛn wa ki ni we, mbe pye ki welefɛnnɛ; jaŋgo na nawa piga ka ŋgban Izirayɛli gbogolomɔ woolo pe ni.» ");
INSERT INTO dyi_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","A Izirayɛli woolo pè si tanga ma yala sɛnrɛ nda Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi naa Arɔn pe ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Izirayɛli woolo pe ni fuun nuŋgba nuŋgba pe yaa ka pe paara yinrɛ ti kankan mbe cɛn wa pe cɛngɛlɛ ke tɛgɛrɛ yaara ti tanla, wa pe maliŋgbɔɔnlɔ ŋgbeleye yi dirapoye pe tanla. Pe yaa ka pe paara yinrɛ ti kankan mbe cɛn, mbe yɛgɛ wa filisaga paraga go ki yeri mbege maga mbege fili, mbe fogo yaga poro naa ko sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","«Wa filisaga paraga go ki yɔnlɔ yirisaga kɛɛ yeri, mbele pe yaa ka keli mbe pe paara yinrɛ ti kankan mbe cɛn pe yaa ka pye wa Zhuda paara yinrɛ cɛnsaga ki dirapo wi tanla, mbe gbɛgɛlɛ mbe pye maliŋgbɔɔnlɔ ŋgbeleye. Aminadabu pinambyɔ Naashɔn wo wi yɛn to Zhuda cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Naashɔn maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa taanri ma yiri kɛ ma yiri tijɛrɛ, naa cɛnmɛ kɔgɔlɔni (74 600). ");
INSERT INTO dyi_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","7","Isakari cɛnlɛ woolo naa Zabulɔn cɛnlɛ woolo pe yaa pe paara yinrɛ ti kankan mbe cɛn Zhuda cɛnlɛ woolo pe kanŋgaya shyɛn yi na. Suwari pinambyɔ Netaneyɛli wo wi yɛn to Isakari cɛnlɛ woolo pe go na. Wi maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa shyɛn ma yiri kɛ ma yiri tijɛrɛ naa cɛnmɛ tijɛrɛ (54 400). Zabulɔn cɛnlɛ woolo poro na, Elɔn pinambyɔ Eliyabu wo wi yɛn to pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Elɔn maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa shyɛn ma yiri kɛ ma yiri kɔlɔshyɛn naa cɛnmɛ tijɛrɛ (57 400). ");
INSERT INTO dyi_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Zhuda cɛnsaga maliŋgbɔɔnlɔ ŋgbeleye taanri yi leele pe ni fuun pàa pye nambala waga cɛnmɛ naa nafa tijɛrɛ ma yiri kɔgɔlɔni naa cɛnmɛ tijɛrɛ (186 400). Poro pe yaa ka keli mbe yiri mbaa kee. ");
INSERT INTO dyi_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","«Wa filisaga paraga go ki yɔnlɔparawa kalige kɛɛ yeri, Urubɛn paara yinrɛ cɛnsaga dirapo wi yaa pye wa, naa wi maliŋgbɔɔnlɔ ŋgbeleye yi ni. Shedewuri pinambyɔ Elisuri wo wi yɛn to Urubɛn cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Elisuri maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa shyɛn ma yiri kɔgɔlɔni naa cɛnmɛ kaŋgurugo (46 500). ");
INSERT INTO dyi_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeyɔn cɛnlɛ woolo pe yaa pe paara yinrɛ ti kankan mbe cɛn Urubɛn cɛnlɛ woolo pe kanŋgaya na. Zurishadayi pinambyɔ Shelumiyɛli wo wi yɛn to Simeyɔn cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Shelumiyɛli maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa shyɛn ma yiri kɛ ma yiri kɔlɔjɛrɛ naa cɛnmɛ taanri (59 300). ");
INSERT INTO dyi_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","«Ko puŋgo na, Gadi cɛnlɛ woolo poro pe yaa cɛn le pe tanla. Erewuwɛli pinambyɔ Eliyazafu wo wi yɛn to Gadi cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Eliyazafu maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa shyɛn ma yiri kaŋgurugo naa cɛnmɛ kɔgɔlɔni naa nafa shyɛn ma yiri kɛ (45 650). ");
INSERT INTO dyi_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","«Urubɛn cɛnsaga maliŋgbɔɔnlɔ ŋgbeleye taanri yi leele pe ni fuun pàa pye nambala waga cɛnmɛ naa nafa shyɛn ma yiri kɛ ma yiri nuŋgba naa cɛnmɛ tijɛrɛ naa nafa shyɛn ma yiri kɛ (151 450). Poro pe yaa pye shyɛn woolo mbe yiri mbaa kee. ");
INSERT INTO dyi_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","«Ko puŋgo na, Levi setirige cɛnsaga woolo pe yaa yiri mbe kari filisaga paraga go ki ni. Pe yaa ka pye cɛnsara koŋgbannda shyɛn to naa cɛnsara puŋgo woro shyɛn ti nandogomɔ. Pe yaa ka pe paara yinrɛ ti kankan mberi tagala ti yɛɛ na yɛgɛ ŋga na, pa pe yaa ka yiri mbe tagala pe yɛɛ na ma mbaa kee, nambala pe ni fuun nuŋgba nuŋgba pe yaa ka pye wa pe cɛnsara, wa pe dirapoye pe tanla. ");
INSERT INTO dyi_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","«Wa filisaga paraga go ki yɔnlɔ tosaga kɛɛ yeri, Efirayimu paara yinrɛ cɛnsaga dirapo wi yaa pye wa, naa pe maliŋgbɔɔnlɔ ŋgbeleye yi ni. Amihudi pinambyɔ Elishama wo wi yɛn to Efirayimu cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Elishama maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa shyɛn naa cɛnmɛ kaŋgurugo (40 500). ");
INSERT INTO dyi_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","22","Manase cɛnlɛ woolo naa Bɛnzhamɛ cɛnlɛ woolo pe yaa ka pe paara yinrɛ ti kankan mbe cɛn Efirayimu cɛnlɛ woolo pe kanŋgaya shyɛn yi na. Pedasuri pinambyɔ Gamiliyɛli wo wi yɛn to Manase cɛnlɛ woolo pe go na. Gamiliyɛli maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa ma yiri kɛ ma yiri shyɛn naa cɛnmɛ shyɛn (32 200). Bɛnzhamɛ cɛnlɛ woolo poro na, Gidewoni pinambyɔ Abidan wo wi yɛn to pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Abidan maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa ma yiri kɛ ma yiri kaŋgurugo naa cɛnmɛ tijɛrɛ (35 400). ");
INSERT INTO dyi_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Efirayimu cɛnsaga maliŋgbɔɔnlɔ ŋgbeleye taanri yi leele pe ni fuun pàa pye nambala waga cɛnmɛ ma yiri kɔlɔtaanri naa cɛnmɛ (108 100). Poro pe yaa pye taanri woolo mbe yiri mbaa kee. ");
INSERT INTO dyi_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","«Wa filisaga paraga go ki yɔnlɔparawa kamɛŋgɛ kɛɛ yeri, Dan paara yinrɛ cɛnsaga dirapo wi yaa pye wa, naa pe maliŋgbɔɔnlɔ ŋgbeleye yi ni. Amishadayi pinambyɔ Ayezɛri wo wi yɛn to Dan cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ayezɛri maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa taanri ma yiri shyɛn naa cɛnmɛ kɔlɔshyɛn (62 700). ");
INSERT INTO dyi_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","29","Asɛri cɛnlɛ woolo naa Nɛfitali cɛnlɛ woolo pe yaa ka pe paara yinrɛ ti kankan mbe cɛn Dan cɛnlɛ woolo pe kanŋgaya shyɛn yi na. Okiran pinambyɔ Pagiyɛli wo wi yɛn to Asɛri cɛnlɛ woolo pe go na. Pagiyɛli maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa shyɛn ma yiri nuŋgba naa cɛnmɛ kaŋgurugo (41 500). Nɛfitali cɛnlɛ woolo poro na, Ena pinambyɔ Ayira wo wi yɛn to pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ayira maliŋgbɔɔnlɔ ŋgbelege kìla pye nambala waga nafa shyɛn ma yiri kɛ ma yiri taanri naa cɛnmɛ tijɛrɛ (53 400). ");
INSERT INTO dyi_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan cɛnsaga maliŋgbɔɔnlɔ ŋgbeleye taanri yi leele pe ni fuun pàa pye nambala waga cɛnmɛ naa nafa shyɛn ma yiri kɛ ma yiri kɔlɔshyɛn naa cɛnmɛ kɔgɔlɔni (157 600). Poro pe yaa ka pye puŋgofɛnnɛ mbe yiri mbaa kee pe dirapoye pe ni.» ");
INSERT INTO dyi_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Izirayɛli woolo mbele pàa jiri seye seye poro la wɛlɛ yɛɛn. Poro wɛlɛ pàa jiri, a pè pye paara yinrɛ ti cɛnsara fɛnnɛ, ma yala pe maliŋgbɔɔnlɔ ŋgbeleye yi ni. Pàa pye lere waga cɛnmɛ kɔgɔlɔni ma yiri taanri naa cɛnmɛ kaŋgurugo naa nafa shyɛn ma yiri kɛ (603 550). ");
INSERT INTO dyi_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ɛɛn fɔ, pe sila Levi setirige piile pe jiri mbe pe pinlɛ Izirayɛli woolo sanmbala pe ni, ma yala Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan yɛgɛ ŋga na ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Izirayɛli woolo pàa tanga ma yala sɛnrɛ nda fuun Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan ti ni. Kì pye ma, a pè si pe paara yinrɛ ti kankan ma cɛn pe dirapoye pe tanla. Pa pàa si kaa yiri ma, ma tagala pe yɛɛ na, na kee ma yala pe setiriye yo naa pe seye yi ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Arɔn naa Moyisi pe setirige piile pe mɛrɛ ti nda, sanga ŋa ni Yawe Yɛnŋɛlɛ làa para Moyisi wi ni wa Sinayi yanwiga ki na we. ");
INSERT INTO dyi_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Arɔn pinambiile pàa pye tijɛrɛ, pe mɛrɛ ti nda: Wi pinambyɔ koŋgbanŋa wo lawi ŋa Nadabu, a Abiyu si taga, naa Eleyazari konaa Itamari. ");
INSERT INTO dyi_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Arɔn pinambiile pe mɛrɛ to lari yɛɛn. Pàa sinmɛ kpoyi wo pe na ma pe wɔ ma pe tɛgɛ saraga wɔfɛnnɛ, ma pe le saraga wɔgɔtunŋgo ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadabu naa Abiyu pàa ku Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ ma pe ta wa Sinayi gbinri wi ni, katugu pàa pan kasɔn ni mbe saraga wɔ Yɛnŋɛlɛ li yeri ŋga li sila ki konɔ kan. Pe sila pinambiile se. Eleyazari naa Itamari pàa pye na saraga wɔgɔtunŋgo ki piin, a pe to Arɔn wila pe kɔrɔsi. ");
INSERT INTO dyi_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Ma pan Levi cɛnlɛ woolo pe ni, ma pe le saraga wɔfɔ Arɔn wi kɛɛ wila wele pe na, jaŋgo paa wi sari wa tunŋgo ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Yaara nda fuun tì le Arɔn naa Izirayɛli gbogolomɔ woolo pe ni fuun pe kɛɛ, wa filisaga paraga go ki yɛgɛ, poro pe yaa lari kɔrɔsi, mbaa Yɛnŋɛlɛ cɛnsaga paraga go ki tunŋgo ki piin. ");
INSERT INTO dyi_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Filisaga paraga go ki nawa tunŋgo pyeyaara to naa yaraga ŋga fuun kì le Izirayɛli gbogolomɔ woolo pe kɛɛ paa wele ki na, poro pe yaa lari kɔrɔsi, mbaa cɛnsaga paraga go ki tunŋgo ki piin. ");
INSERT INTO dyi_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ma Levi setirige piile pe kan Arɔn naa wi pinambiile pe yeri pew; pe yaa yiri wa Izirayɛli woolo sanmbala pe sɔgɔwɔ mbe kan wi yeri. ");
INSERT INTO dyi_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Arɔn naa wi pinambiile poro na, ma pe tɛgɛ paa saraga wɔgɔtunŋgo ki piin. Na lere wa yɛgɛ ka fulo wa cɛnsaga paraga go ki tanla, na saraga wɔfɔ ma, wi daga pe wo gbo.» ");
INSERT INTO dyi_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Wele, mi jate mì Levi setirige piile pe wɔ Izirayɛli woolo sanmbala pe sɔgɔwɔ. Pe yɛn na woolo mbaa tunŋgo piin na kan Izirayɛli woolo pe pinambiile koŋgbanmbala pe ni fuun pe yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Katugu pinambiile koŋgbanmbala pe ni fuun pe yɛn na woolo. Pilige ŋga ni mìla Ezhipiti tara woolo pe pinambiile koŋgbanmbala pe gbo, mìla Izirayɛli woolo pe pinambiile koŋgbanmbala pe wɔ ma pe tɛgɛ pe yɛ na yɛɛ kan; leele pe pinambiile koŋgbanmbala pe yaa pye na woolo naa yaayoro ti pinambire koŋgbannda ti ni. Muwi mi yɛn Yawe Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni naa wa Sinayi gbinri wi ni maa pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Ma Levi setirige piile pe jiri ma yala pe setiriye yo naa pe seye yi ni; ma nambala pe ni fuun nuŋgba nuŋgba pe jiri mbege lɛ mbele pè ta yeŋge nuŋgba nuŋgba pe na konaa pe yɛgɛ fɛnnɛ pe ni.» ");
INSERT INTO dyi_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","A Moyisi wì si pe jiri ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni, paa yɛgɛ ŋga na làa ki yo maa kan we. ");
INSERT INTO dyi_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi pinambiile pe mɛrɛ ti nda: Gɛrishɔn, naa Kehati konaa Merari. ");
INSERT INTO dyi_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gɛrishɔn pinambiile pe mɛrɛ ti nda ma yala pe setiriye yi ni: Libini naa Shimeyi. ");
INSERT INTO dyi_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kehati pinambiile pe mɛrɛ ti nda ma yala pe setiriye yi ni: Amiramu, naa Yizehari, naa Eburɔn konaa Uziyɛli. ");
INSERT INTO dyi_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari pinambiile pe mɛrɛ ti nda ma yala pe setiriye yi ni: Mahali naa Mushi. Poro wɛlɛ pàa pye Levi setirige piile, ma yala pe seye yi ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Libini sege woolo naa Shimeyi sege woolo pa pàa yiri wa Gɛrishɔn setirige ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Pàa nambala pe ni fuun nuŋgba nuŋgba pe jiri maga lɛ mbele pàa ta yeŋge nuŋgba nuŋgba pe na konaa pe yɛgɛ fɛnnɛ pe ni; mbele pàa jiri pàa pye lere waga kɔlɔshyɛn naa cɛnmɛ kaŋgurugo (7 500). ");
INSERT INTO dyi_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gɛrishɔn setirige piile pe seye woolo pàa pe paara yinrɛ ti kankan ma cɛn wa Yɛnŋɛlɛ cɛnsaga paraga go ki puŋgo na, wa yɔnlɔ tosaga yeri. ");
INSERT INTO dyi_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Layɛli pinambyɔ Eliyazafu wo wìla pye sege to Gɛrishɔn setirige piile pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Filisaga paraga go ki yaara nda pàa le Gɛrishɔn setirige piile pe kɛɛ paa ti kɔrɔsi ti nda: Yɛnŋɛlɛ cɛnsaga paraga go ko naa filisaga paraga go ki ni, naa paraga ŋga pe ma tɛgɛ maga gona wi tɔn ki ni, konaa filisaga paraga go ki yeyɔngɔ tɔnparaga ki ni, ");
INSERT INTO dyi_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","naa paara nda pe ma pɔ loŋgo ki jasa wi na ti ni, naa loŋgo ki jasa ŋa wi Yɛnŋɛlɛ cɛnsaga paraga go konaa saraga wɔsaga ki maga maga fili ki yeyɔngɔ tɔnparaga ki ni, konaa manda nda fuun pe ma tɛgɛ naga tunŋgo ki piin ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amiramu sege woolo, naa Yizehari sege woolo, naa Eburɔn sege woolo konaa Uziyɛli sege woolo pa pàa yiri wa Kehati setirige ki ni. Poro wɛlɛ pàa pye Kehati setirige piile pe seye woolo wele. ");
INSERT INTO dyi_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Nambala mbele fuun pàa jiri maga lɛ mbele pè ta yeŋge nuŋgba nuŋgba konaa pe yɛgɛ fɛnnɛ pe ni, pàa pye lere waga kɔlɔtaanri naa cɛnmɛ kɔgɔlɔni (8 600). Poro pàa pye na filisaga paraga go ki laga kpoyi ki kɔrɔsi. ");
INSERT INTO dyi_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kehati setirige piile pe seye woolo pàa pe paara yinrɛ ti kankan ma cɛn wa cɛnsaga paraga go ki yɔnlɔparawa kalige kɛɛ yeri. ");
INSERT INTO dyi_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Uziyɛli pinambyɔ Elizafan wo wìla pye to Kehati setirige piile pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Yaara nda pàa le Kehati setirige piile pe kɛɛ paa ti kɔrɔsi ti nda: Pàa yɔn finliwɛ kɛsu wi le Keyati setirige piile pe kɛɛ paa wele wi na, naa tabali ŋa wìla pye kpoyi Yɛnŋɛlɛ yɛgɛ na wi ni, naa fitanladaga wi ni, naa saraga wɔsara ti ni, naa laga kpoyi ki tunŋgo pyeyaara ti ni, naa paraga ŋga pàa pɔ ma filisaga paraga go ki nawa pi kɔn shyɛn ki ni, konaa ki yaara ti ni fuun ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Saraga wɔfɔ Arɔn wi pinambyɔ Eleyazari wo wìla pye to Levi setirige piile pe teele pe go na. Leele mbele pàa tɛgɛ paa filisaga paraga go ki laga kpoyi ki kɔrɔsi, wo wìla pye pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Mahali sege woolo naa Mushi sege woolo pa pàa yiri wa Merari setirige ki ni. Poro wɛlɛ pàa pye Marari wi setirige piile pe seye woolo wele. ");
INSERT INTO dyi_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Nambala mbele fuun pàa jiri, maga lɛ mbele pè ta yeŋge nuŋgba nuŋgba konaa pe yɛgɛfɛnnɛ pe ni, pàa pye lere waga kɔgɔlɔni naa cɛnmɛ shyɛn (6 200). ");
INSERT INTO dyi_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Abihayili pinambyɔ Suriyɛli wo wìla pye to Merari setirige piile pe seye woolo pe go na. Pàa pe paara yinrɛ ti kankan ma cɛn wa Yɛnŋɛlɛ cɛnsaga paraga go ki yɔnlɔparawa kamɛŋgɛ kɛɛ yeri. ");
INSERT INTO dyi_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Yaara nda pàa le Merari setirige piile pe kɛɛ paa ti kɔrɔsi ti nda: Yɛnŋɛlɛ cɛnsaga paraga go ki tire papara papara to naa ki tipaara ti ni, naa ki tiyagala ke ni, naa tiyagala ke nɔgɔna cɛnyaara ti ni, naa ki tunŋgo pyeyaara ti ni, naa yaara nda fuun ti yɛn ki wogo ti ni, ");
INSERT INTO dyi_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","naa jasa ŋa wì loŋgo ki maga maa fili wi tiyagala ke ni, naa tiyagala ke nɔgɔna cɛnyaara ti ni, naa paara pe mari pɔpɔ kanŋgagala ŋgele na ke ni, konaa ti manda ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moyisi naa Arɔn konaa Arɔn wi pinambiile pe ni, pàa pe paara yinrɛ ti kankan ma cɛn wa filisaga paraga go ki yɛgɛ, wa yɔnlɔ yirisaga yeri. Poro pàa pye na Yɛnŋɛlɛ cɛnsaga paraga go ki kɔrɔsi Izirayɛli woolo pe kan. Mbe wɔ Moyisi, naa Arɔn konaa Arɔn wi pinambiile pe ni, na lere wa yɛgɛ ka fulo wa ki tanla, wi daga poo gbo. ");
INSERT INTO dyi_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Levi setirige piile mbele fuun Moyisi naa Arɔn pàa jiri ma yala pe seye yi ni, maga lɛ nambala mbele fuun pàa ta yeŋge nuŋgba nuŋgba konaa pe yɛgɛfɛnnɛ pe ni, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo we, pàa pye lere waga nafa ma yiri shyɛn (22 000). ");
INSERT INTO dyi_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yawe Yɛnŋɛlɛ làa Moyisi wi pye fɔ: «Izirayɛli woolo pe pinambiile koŋgbanmbala pe ni fuun pe jiri, mbege lɛ mbele pè ta yeŋge nuŋgba nuŋgba pe na konaa pe yɛgɛfɛnnɛ pe ni, ma pe mɛrɛ ti yɔnlɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ma Levi setirige piile pe wɔ ma pe pye mi ŋa Yawe Yɛnŋɛlɛ na woolo, Izirayɛli woolo pe pinambiile koŋgbanmbala pe yɔnlɔ. Ki pyelɔmɔ nuŋgba pi na fun, ma Levi setirige piile pe yaayoro ti wɔ mari pye na woro Izirayɛli woolo pe yaayoro ti pinambire koŋgbannda ti ni fuun ti yɔnlɔ.» ");
INSERT INTO dyi_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","A Moyisi wì si Izirayɛli woolo pe pinambiile koŋgbanmbala pe ni fuun pe jiri ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Pinambiile koŋgbanmbala mbele pàa jiri ma yala pe mɛrɛ ti ni, maga lɛ mbele pàa ta yeŋge nuŋgba nuŋgba pe na konaa pe yɛgɛfɛnnɛ pe ni, pàa pye lere waga nafa ma yiri shyɛn naa cɛnmɛ shyɛn naa nafa taanri ma yiri kɛ ma yiri taanri (22 273). ");
INSERT INTO dyi_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yawe Yɛnŋɛlɛ làa Moyisi wi pye naa fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Levi setirige piile pe wɔ pe pye na woolo, Izirayɛli woolo pe pinambiile koŋgbanmbala pe yɔnlɔ, ma pe yaayoro ti wɔ ti pye na woro Izirayɛli woolo pe yaayoro ti yɔnlɔ; pa kona Levi setirige piile pe yaa pye na woolo. Muwi mi yɛn Yawe Yɛnŋɛlɛ le. ");
INSERT INTO dyi_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Izirayɛli woolo pe pinambiile koŋgbanmbala mbele pè lɛgɛ ma wɛ Levi setirige piile pe na lere cɛnmɛ shyɛn naa nafa taanri ma yiri kɛ ma yiri taanri (273), pe daga mbe go shɔ. ");
INSERT INTO dyi_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ma yaa warifuwe pyɔ kaŋgurugo kaŋgurugo shɔ lere nuŋgba nuŋgba pyew wi yeri; ma yaa ti shɔ mbe yala cɛnsaga paraga go ki warifuwe pyɔ nuguwɔ pi ni, wi nuguwɔ pi yɛn giramu kɛ. ");
INSERT INTO dyi_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ki penjara mari kan Arɔn naa wi pinambiile pe yeri ti pye Izirayɛli woolo pe pinambiile koŋgbanmbala mbele pè lɛgɛ ma wɛ Levi setirige piile pe na pe go shɔgɔ sara.» ");
INSERT INTO dyi_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Levi setirige piile pàa Izirayɛli woolo pe pinambiile koŋgbanmbala pe go shɔ, pinambiile koŋgbanmbala mbele pàa lɛgɛ ma wɛ pe na, Moyisi wìla pe go shɔgɔ sara wi shɔ. ");
INSERT INTO dyi_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Penjara nda wìla shɔ Izirayɛli woolo pe pinambiile koŋgbanmbala pe yeri, tìla pye warifuwe pyɔ waga kele naa cɛnmɛ taanri naa nafa taanri ma yiri kaŋgurugo (1 365), ma yala cɛnsaga paraga go ki warifuwe pyɔ nuguwɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","A Moyisi wì sigi go shɔgɔ penjara ti kan Arɔn naa wi pinambiile pe yeri ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi naa Arɔn pe ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Wa Levi setirige piile pe sɔgɔwɔ, ye Kehati setirige piile pe mɛrɛ ti yɔnlɔgɔ ye yala pe setiriye yo naa pe seye yi ni; ");
INSERT INTO dyi_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","mbege lɛ leele mbele pè ta yɛlɛ nafa ma yiri kɛ kɛ pe na, konaa pe yɛgɛfɛnnɛ pe ni, fɔ saga wa mbele pè ta yɛlɛ nafa shyɛn ma yiri kɛ kɛ pe na, mbele fuun pe mbe ya mbaa tunŋgo ka piin wa filisaga paraga go ki ni we. ");
INSERT INTO dyi_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","«Kehati setirige piile pe tunŋgo ki yaa ka pye mbaa filisaga paraga go ki yaara nda ti yɛn jɛndɛ kpoyi ti kɔrɔsi. ");
INSERT INTO dyi_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Na kiga ka gbɔn Izirayɛli woolo pe pe paara yinrɛ ti kɔlɔgi mbaa kee sanga ŋa ni, Arɔn naa wi pinambiile pe yaa pan gbɛn mbe paraga ŋga ki yɛn ma pɔ ma cɛnsaga paraga go ki kɔn shyɛn ki sanga, mbege wa yɔn finliwɛ sɛnrɛ kɛsu wi na mboo tɔn. ");
INSERT INTO dyi_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Pe yaa kɛsu wi tɔn paritɔnŋgɔ ni, ŋga pè gbegele sɛɛrɛ liire ni; pe yaa ŋganra paraga wa ti ni fuun ti go na mberi tɔn. Ko puŋgo na, pe yaa kɛsu wi lɛkanŋgagala ke le wi na. ");
INSERT INTO dyi_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«Buru ŋa pe ma kan Yɛnŋɛlɛ yeri wi ma tɛgɛ tabali ŋa na, pe yaa wi tɔn ŋganra paraga ni. Pe yaa tasaala pe taga wi na, naa wɔjɛŋgɛlɛ ke ni, naa leyaara ti ni, konaa duvɛn saraga ŋga pe ma wo wi lekugbogolo ke ni. Buru ŋa wi daga mbaa woo saraga na yeri sanga pyew, poo taga wa wi na. ");
INSERT INTO dyi_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Pe yaa paraga yɛngɛ kpanyi wa ki yaara ti na mberi tɔn, mbe ti ni fuun ti fo paritɔnŋgɔ ni, ŋga pè gbegele sɛɛrɛ liire ni. Ko puŋgo na, pe yaa tabali wi lɛkanŋgagala ke lele wi na. ");
INSERT INTO dyi_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Pe yaa ŋganra paraga tɛgɛ mbe fitanladaga wi tɔn, naa wi fitanlaye pe ni, naa wi yɔn yirigeyaara ti ni, naa wi cɔnrɔ leyaara ti ni, konaa wi sinmɛ lekugboro ti ni, to ti yɛn wi tunŋgo pyeyaara re. ");
INSERT INTO dyi_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Pe yaa wo naa wi tunŋgo pyeyaara ti ni fuun ti le paritɔnŋgɔ ni, ŋga pè gbegele sɛɛrɛ liire ni, mberi fo; ko puŋgo na, pe yaa ti taga lɛyaraga na. ");
INSERT INTO dyi_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Pe yaa paraga ŋga pè le ŋganra ni ka wa saraga wɔsaga ŋga pè gbegele tɛ ni ki na mbege tɔn, mbege fo paritɔnŋgɔ ni, ŋga pè gbegele sɛɛrɛ liire ni; ko puŋgo na, pe yaa ki lɛkanŋgagala ke lele ki na. ");
INSERT INTO dyi_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Pe yaa laga kpoyi ki tunŋgo pyeyaara ti lɛ mberi le paraga ŋga pè le ŋganra ni ka ni mberi tɔn, mbe siri fo paritɔnŋgɔ ni, ŋga pè gbegele sɛɛrɛ liire ni; ko puŋgo na, pe yaa ti taga wa ti lɛyaraga ki na. ");
INSERT INTO dyi_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Pe yaa saraga wɔsaga ki cɔnrɔ ti wɔ, mbe kondoro paraga wa ki na mbege tɔn. ");
INSERT INTO dyi_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Pe yaa ki tunŋgo pyeyaara ti ni fuun ti taga wa ki go na, ki naŋganra leyaara to naa ki kara wɔwangala ke ni, naa ki cɔnrɔ wɔyaara ti ni, naa tɔnmɔ mba pe ma yanragi yanragi pi leyaara ti ni. Pe yaa ti ni fuun ti tɔn paritɔnŋgɔ, ŋga pè gbegele sɛɛrɛ liire ni. Ko puŋgo na, pe yaa ki lɛkanŋgagala ke lele ki na. ");
INSERT INTO dyi_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«Leele pe kaa jaa mbe paara yinrɛ ti kɔlɔgi mbaa kee sanga ŋa ni, Arɔn naa wi pinambiile pe ni, na paga laga kpoyi konaa ki tunŋgo pyeyaara ti tɔn mbe kɔ, Kehati setirige piile poro pe yaa pan mberi tugo. Ɛɛn fɔ, paga ka jiri yaara kpoyi ti na, jaŋgo paga ka ta mbe ku. Filisaga paraga go ki tunŋgo ŋga kìla kan Kehati setirige piile pe yeri, ko layi yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Saraga wɔfɔ Arɔn wi pinambyɔ Eleyazari wo na, yaara nda ti yaa le wi kɛɛ wila wele ti na to ti yɛn fitanla sinmɛ, naa wusuna nuwɔ taan wi ni, naa muwɛ saraga ŋga pe maa woo sanga pyew ki ni, konaa sinmɛ kpoyi pi ni. Wo wi yaa kaa Yɛnŋɛlɛ cɛnsaga paraga go ki ni fuun ki kɔrɔsi, naa ki nawa yaara nda ti yɛn kpoyi to naa ki tunŋgo pyeyaara ti ni.» ");
INSERT INTO dyi_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yawe Yɛnŋɛlɛ làa para Moyisi naa Arɔn pe ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Yaga ka ti Kehati setirige piile pe seye woolo jɔlɔgɔ mbe to pe na ki pe gbo ki pe wɔ wa Levi setirige piile sanmbala pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Na pe kaa fulo wa yaara nda ti yɛn jɛndɛ kpoyi ti tanla sanga ŋa ni, ŋga ye daga mbaa piin pe kan koyi ŋga yɛɛn, jaŋgo pe koro yinwege na, paga ka ku: Arɔn naa wi pinambiile pe ni, pe yaa pan mbe pe ni fuun nuŋgba nuŋgba pe tunndo naa pe tuguro ti naganaga pe na. ");
INSERT INTO dyi_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ɛɛn fɔ, Kehati setirige piile pe se ka ye wa mbe yaara nda ti yɛn kpoyi ti wele, ali yɛrɛ jɛnri, jaŋgo paga ka ku.» ");
INSERT INTO dyi_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Gɛrishɔn setirige piile pe jiri fun ma yala pe setiriye yo naa pe seye yi ni. ");
INSERT INTO dyi_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ma nambala pe jiri mbege lɛ mbele pè ta yɛlɛ nafa ma yiri kɛ kɛ pe na, konaa pe yɛgɛ fɛnnɛ pe ni, fɔ sa gbɔn mbele pè ta yɛlɛ nafa shyɛn ma yiri kɛ kɛ pe na; mbele fuun pe mbe ya mbaa tunŋgo ka piin wa filisaga paraga go ki ni we. ");
INSERT INTO dyi_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gɛrishɔn setirige piile pe tunndo naa pe tuguro nda pe yaa la lee tori nda: ");
INSERT INTO dyi_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Poro pe yaa la Yɛnŋɛlɛ cɛnsaga paraga go ki tɔnpaara ti tungu konaa filisaga paraga go ki ni, naa ki tɔnparaga ki ni, naa ki tɔnparaga ŋga pe ma wa ki go na ki ni, ko ŋga pè gbegele sɛɛrɛ liire ni we, naa filisaga paraga go ki yeyɔngɔ tɔnparaga ki ni, ");
INSERT INTO dyi_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","naa paara nda ti ma loŋgo ki jasa wi maga maa fili ti ni, naa jasa wi yeyɔngɔ tɔnparaga ki ni, wo ŋa wì Yɛnŋɛlɛ cɛnsaga paraga go ko naa saraga wɔsaga ti maga mari fili we, naa jasa wi pɔmanda ti ni, konaa tunŋgo pyeyaara ti ni fuun ti ni. Tunŋgo ŋga fuun ki yaa la piin ki yaara ti ni, poro pe yaa laga piin. ");
INSERT INTO dyi_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Arɔn naa wi pinambiile poro pe yaa la Gɛrishɔn setirige piile pe yɛgɛ sinni wa pe tunŋgo ki ni, pe daga mbaa tuguro nda tungu mbaa ti wogo ki yuun pe kan.» ");
INSERT INTO dyi_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","«Tunndo nda ti yaa le Gɛrishɔn setirige piile pe seye woolo pe kɛɛ wa filisaga paraga go ki ni, tori yɛɛn. Saraga wɔfɔ Arɔn wi pinambyɔ Itamari wo wi yaa pye pe go na la pe yɛgɛ sinni. ");
INSERT INTO dyi_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Ma Merari setirige piile pe jiri fun mbe yala pe setiriye yo naa pe seye yi ni. ");
INSERT INTO dyi_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ma nambala pe jiri mbege lɛ mbele pè ta yɛlɛ nafa ma yiri kɛ kɛ pe na, konaa pe yɛgɛ fɛnnɛ pe ni, fɔ sa gbɔn mbele pè ta yɛlɛ nafa shyɛn ma yiri kɛ kɛ pe na, mbele fuun pe mbe ya mbaa tunŋgo piin wa filisaga paraga go ki ni we.» ");
INSERT INTO dyi_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Tunndo nda ti yaa le pe kɛɛ paa piin wa filisaga paraga go tunŋgo ki ni fuun ki ni ti nda: Poro pe yaa la Yɛnŋɛlɛ cɛnsaga paraga go ki tire papara papara ti tungu, naa ki tipaara ti ni, naa ki tiyagala ke ni, naa tiyagala ke nɔgɔna cɛnyaara ti ni, ");
INSERT INTO dyi_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","naa loŋgo ki jasa tiyagala ke ni, naa ke nɔgɔna cɛnyaara ti ni, naa ke paara ti kankanŋgagala ke ni, naa ke pɔmanda ti ni, naa tunŋgo pyeyaara ti ni fuun ti ni, konaa yaara nda fuun ti yɛn ki tunŋgo ki pyeworo ti ni. Yaara nda lere nuŋgba nuŋgba pyew wi daga mbe lɛ, yeri mɛrɛ ti yɔnlɔgɔ yeri kan pe yeri. ");
INSERT INTO dyi_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","«Tunndo nda ti yaa le Merari setirige piile pe seye woolo pe kɛɛ wa filisaga paraga go ki ni, tori yɛɛn. Saraga wɔfɔ Arɔn wi pinambyɔ Itamari wo wi yaa pye pe go na la pe yɛgɛ sinni.» ");
INSERT INTO dyi_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moyisi naa Arɔn naa mbele pàa pye teele Izirayɛli gbogolomɔ woolo pe go na, pàa Kehati setirige piile pe jiri ma yala pe setiriye yo naa pe seye yi ni, ");
INSERT INTO dyi_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","maga lɛ mbele pàa ta yɛlɛ nafa ma yiri kɛ kɛ pe na, konaa pe yɛgɛ fɛnnɛ pe ni, fɔ ma saa gbɔn mbele pàa ta yɛlɛ nafa shyɛn ma yiri kɛ kɛ pe na; mbele fuun pe mbaa ya tunŋgo pye wa filisaga paraga go ki ni we. ");
INSERT INTO dyi_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Nambala mbele pàa jiri ma yala pe setiriye yi ni, pàa pye lere waga shyɛn naa cɛnmɛ kɔlɔshyɛn naa nafa ma yiri kɛ (2 750). ");
INSERT INTO dyi_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Kehati setirige piile seye woolo mbele pàa jiri, mbele fuun pàa pye na tunŋgo piin wa filisaga paraga go ki ni, poro la wɛlɛ yɛɛn. Moyisi naa Arɔn pàa pe jiri ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gɛrishɔn setirige piile pàa pe jiri ma yala pe setiriye yo naa pe seye yi ni, ");
INSERT INTO dyi_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","maga lɛ nambala mbele pàa ta yɛlɛ nafa ma yiri kɛ kɛ pe na, konaa pe yɛgɛ fɛnnɛ pe ni, fɔ ma saa gbɔn mbele pàa ta yɛlɛ nafa shyɛn ma yiri kɛ kɛ pe na, mbele fuun pe mbaa ya mbaa tunŋgo piin wa filisaga paraga go ki ni we. ");
INSERT INTO dyi_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Nambala mbele pàa jiri ma yala pe setiriye yo naa pe seye yi ni, pàa pye lere waga shyɛn naa cɛnmɛ kɔgɔlɔni naa nafa ma yiri kɛ (2 630). ");
INSERT INTO dyi_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Gɛrishɔn setirige piile pe seye woolo mbele pàa jiri, mbele fuun pàa pye na tunŋgo piin wa filisaga paraga go ki ni, poro la wɛlɛ yɛɛn. Moyisi naa Arɔn pàa pe jiri ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merari setirige piile pe seye woolo pàa pe jiri ma yala pe setiriye yo naa pe seye yi ni, ");
INSERT INTO dyi_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","maga lɛ mbele pàa ta yɛlɛ nafa ma yiri kɛ kɛ pe na, konaa pe yɛgɛ fɛnnɛ pe ni, fɔ ma saa gbɔn mbele pàa ta yɛlɛ nafa shyɛn ma yiri kɛ kɛ pe na, mbele fuun pe mbaa ya mbaa tunŋgo piin wa filisaga paraga go ki ni we. ");
INSERT INTO dyi_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Nambala mbele pàa jiri ma yala pe setiriye yi ni, pàa pye lere waga taanri naa cɛnmɛ shyɛn (3 200). ");
INSERT INTO dyi_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Merari setiriye piile pe seye woolo mbele pàa jiri, poro la wɛlɛ yɛɛn. Moyisi naa Arɔn pàa pe jiri ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Moyisi naa Arɔn naa leele mbele pàa pye teele Izirayɛli woolo pe go na pàa Levi setirige piile pe ni fuun pe jiri ma yala pe setiriye yo naa pe seye yi ni, ");
INSERT INTO dyi_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","maga lɛ nambala mbele pàa ta yɛlɛ nafa ma yiri kɛ kɛ pe na, konaa pe yɛgɛ fɛnnɛ pe ni, fɔ ma saa gbɔn mbele pàa ta yɛlɛ nafa shyɛn ma yiri kɛ kɛ pe na, mbele fuun pe mbaa ya mbaa tunŋgo piin wa filisaga paraga go ki ni we. ");
INSERT INTO dyi_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Mbele fuun pàa jiri pàa pye lere waga kɔlɔtaanri naa cɛnmɛ kaŋgurugo naa nafa tijɛrɛ (8 580). ");
INSERT INTO dyi_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Pàa pe jiri ma yala Yawe Yɛnŋɛlɛ làa sɛnrɛ nda yo Moyisi wi kan ti ni, ma tunŋgo ŋga pe ni fuun nuŋgba nuŋgba pe yaa la piin konaa yaara nda pe yaa la tungu ti naganaga pe na. Pàa pe jiri ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni Moyisi wi kan. ");
INSERT INTO dyi_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Ki yo Izirayɛli woolo pe kan fɔ pe yayɛnwɛ fɛnnɛ pe yirige pe pe wɔ wa paara yinrɛ cɛnsaga ki ni, naa fyomiŋge fɛnnɛ pe ni fuun pe ni, konaa mbele pè jiri gboo na ma pye fyɔngɔ ni Yɛnŋɛlɛ yɛgɛ na pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Nambala o, jɛɛlɛ o, ye pe yirige ye pe wɔ wa paara yinrɛ cɛnsaga ki ni, ye pe torogo wa ki puŋgo na, jaŋgo paga kaga tɛgɛ fyɔngɔ ni, ko ŋga mi yɛn ma cɛn laga ki ni ye sɔgɔwɔ we.» ");
INSERT INTO dyi_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","A Izirayɛli woolo pè sigi pye ma. Pàa mbele fuun pàa pye fyɔngɔ ni pe yirige ma pe wɔ wa paara yinrɛ cɛnsaga ki ni, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo ma Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni maa pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Ki yo Izirayɛli woolo pe kan fɔ na naŋa nakoma jɛlɛ wa ka kapege ka pye wi lewee yɛnlɛ wa na, mbe kolo Yawe Yɛnŋɛlɛ li yɛgɛ na, wi daga mbaa jate kapege pyefɔ. ");
INSERT INTO dyi_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Wi daga mbege yo fɔ wì kapege pye; wì kapege ki pye lere ŋa na ma yaraga ŋga jɔgɔ, wi daga mbege yɔngɔ sɔngɔrɔ ki fɔ wi na, mbege walisaga kaŋgurugo wogo taga wa wi kan. ");
INSERT INTO dyi_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Na kaa pye yaragafɔ wì ku, wi lere si woro go na pe yaraga ki kan wi yeri, ki yaraga ki daga mbe pye mi ŋa Yawe Yɛnŋɛlɛ na wogo, ko ki naga ma yo pe yaa ki kan saraga wɔfɔ wi yeri. Ko puŋgo na, kapege pyefɔ wi yaa simbapɔlɔ wɔ mboo kapege ki kala yagawa ja, jaŋgo saraga wɔfɔ wi kapere ti kala yagawa ja kapyege pye wi kan. ");
INSERT INTO dyi_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Yaara kpoyi nda fuun Izirayɛli woolo pe maa paan nari nii saraga wɔfɔ wi kɛɛ, yarikanra nda fuun pe ma lagala wa ti na mbe kan saraga wɔfɔ wi yeri, to ma pye saraga wɔfɔ wo woro. ");
INSERT INTO dyi_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Na lere wa ka yaraga ka kan Yɛnŋɛlɛ yeri, ki yaa pye ki saraga wɔfɔ wi wogo. Na lere wa ka si yaraga ka kan saraga wɔfɔ wi yeri, ki yaa pye wi wogo.» ");
INSERT INTO dyi_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Ki yo Izirayɛli woolo pe kan fɔ: Na naŋa wa japɔrɔwɔ ka lara naŋa wa yɛgɛ ni mbe pye mbasinŋɛ wi pɔlɔ wi ni, ");
INSERT INTO dyi_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","na wiga sinlɛ naŋa wa yɛgɛ ni larawa, wi pɔlɔ wi woro ki jɛnmɛ, na kaa pye wuu yɛɛ tɛgɛ fyɔnrɔ ni larawa, lere sigi jɛn, pee suu yigi ki kala li go na, ");
INSERT INTO dyi_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","na yenjara ka pye naŋa wi ni wila singi wi jɔ wi na mbege ta jɛlɛ wì fyɔnrɔ kala pye, nakosima na yenjara ka ye naŋa wi ni wila singi wi jɔ wi na, mbege ta jɛlɛ wii fyɔnrɔ kala pye, ");
INSERT INTO dyi_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","kona naŋa wi yaa kari wi jɔ wi ni wa saraga wɔfɔ wi yeri. Wi yaa kari saraga yaara ni wi jɔ wi kala na. To yaa pye ɔrizhi muwɛ saraga woo culo taanri, wiga ka sinmɛ wo pi na, wiga si ka wusuna nuwɔ taan taga pi na, katugu saraga ŋga ki ma wɔ yenjara kala na ko kayi, ŋga ki ma nandowo kan lere yeri wi nawa to wi kapege ki wogo na. ");
INSERT INTO dyi_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Saraga wɔfɔ wi yaa kari jɛlɛ wi ni wa cɛnsaga paraga go ki ni mboo yerege Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Wi yaa ka tɔnmɔ mba pi yɛn ma tɛgɛ pi yɛ Yɛnŋɛlɛ kan pa ko wa cɔgɔ ŋga pè fanri joro ni ki ni, mbe si cɛnsaga paraga go ki nawa tara ta koli mberi le wa ki tɔnmɔ pi ni. ");
INSERT INTO dyi_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Saraga wɔfɔ wi yaa jɛlɛ wi pye wi yere Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mbe jɛlɛ wi go ki sanga mbege wa, mbe si saraga muwɛ mba pi ma nandowo kan lere yeri pi le wi kɛɛ, ki saraga ŋga kì wɔ yenjara wogo na we. Saraga wɔfɔ wi yaa tɔnmɔ mba pì sori pi yigi wa wi kɛɛ, po mba lere mbasinŋɛ kaa wɔ pi ma daŋga wa wi na we. ");
INSERT INTO dyi_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Saraga wɔfɔ wi yaa jɛlɛ wi pye wi wugu mbe suu pye fɔ: ‹Na kaa pye naŋa wa yɛgɛ si sinlɛ ma ni, mbɔɔn ta wa pɔrɔgɔ ki ni ma pɔlɔ wi yeri, na kaa si pye mɛɛ lara naŋa wa yɛgɛ ni mbe fyɔnrɔ kala pye, mbɔɔn ta wa pɔrɔgɔ ki ni, pa kona ki tɔnzorowo mba pi maa daŋga waa, piga ka kapege pye ma na. ");
INSERT INTO dyi_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ɛɛn fɔ, na kaa pye mbɔɔn ta wa pɔrɔgɔ ki ni, ma lara naŋa wa yɛgɛ ni ma fyɔnrɔ kala pye, a naŋa wà yɛgɛ sinlɛ ma ni, na ma pɔlɔ wo ma›, ");
INSERT INTO dyi_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","kona saraga wɔfɔ wi ti jɛlɛ wi wugu wuu yɛɛ daŋga; wuu pye fɔ: ‹Yawe Yɛnŋɛlɛ lɔɔn sege ki tɔn, lɔɔn fuŋgbolo li pye li fɛ ma na laga ma woolo pe sɔgɔwɔ, paa ma mɛgɛ ki yinri paa yɛgɛ nagawa yɛn, na pe kaa lere wa daŋgi we. ");
INSERT INTO dyi_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ki tɔnmɔ mba pi maa daŋga waa pi ye wa ma wire ti ni, pi ti ma fuŋgbolo li fɛ ma na, pɔɔn sege ki tɔn.› Kona jɛlɛ wigi shɔ wi yo fɔ: ‹Ki pye ma.› ");
INSERT INTO dyi_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«Kona saraga wɔfɔ wi yaa ki daŋga sɛnrɛ ti yɔnlɔgɔ sɛwɛ pyɔ wa na, mbe suu le wa tɔnzorowo pi ni mboo yɔɔnrɔ ti jogo ");
INSERT INTO dyi_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ko puŋgo na, wi yaa tɔnzorowo mba pi maa daŋga waa pi kan jɛlɛ wi yeri wuu wɔ; pa tɔnmɔ mba pi maa daŋga waa pi yaa ye wa jɛlɛ wi wire ti ni mbe jɔlɔgɔ pege wa wi na. ");
INSERT INTO dyi_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kona saraga wɔfɔ wi yaa muwɛ saraga ŋga pe ma wɔ yenjara kala na ki shɔ jɛlɛ wi yeri, mbe sigi yirige mbe kan saraga Yawe Yɛnŋɛlɛ li yeri, mbe si kari ki ni wa saraga wɔsaga ki na. ");
INSERT INTO dyi_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Saraga wɔfɔ wi yaa ki saraga muwɛ pa ko kɛɛ yɛnlɛ nuŋgba, pi pye saraga ŋga ki maa nandowo kaan, mbe suu sogo wa saraga wɔsaga ki na. Ko puŋgo na, ko wi yaa ti jɛlɛ wi tɔnmɔ pi wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Na wiga ki tɔnmɔ pi wɔ mbe kɔ, na kaa pye wi fyɔnrɔ kala pye ma pye mbasinŋɛ wi pɔlɔ wi ni, tɔnmɔ mba pi maa daŋga waa, pi yaa wi fuŋgbolo li fɛ wi na mboo sege ki tɔn. Daŋga yaa wi yigi wi woolo pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ɛɛn fɔ, na kaa pye wii fyɔnrɔ kala pye, na kaa pye wi yɛn fyɔnrɔ fu, pa wi yaa pye jɛrɛgisaga fu mbaa piile siin. ");
INSERT INTO dyi_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«Ko ŋgasele na lo lì tɛgɛ yenjara wogo na, na jɛlɛ wa ka lara naŋa wa yɛgɛ ni mbe fyɔnrɔ kala pye, mboo ta wa pɔrɔgɔ ki ni we. ");
INSERT INTO dyi_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Nakosima na kaa pye yenjara yɛn naŋa wi ni a wila singi wi jɔ wi na, saraga wɔfɔ wi yaa sa jɛlɛ wi pye wi yere wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mbe ŋgasele li ni fuun li pye wi na. ");
INSERT INTO dyi_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Pa kona, naŋa wi saa jate kapege pyefɔ, ɛɛn fɔ, na kaa pye jɛlɛ wi yɛn jɔgɔfɔ, wi yaa wi kapege ki go kala li lɛ.» ");
INSERT INTO dyi_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Ki yo Izirayɛli woolo pe kan fɔ na naŋa nakoma jɛlɛ wa kaa yɛɛ laga sanmbala pe na mbe yɔn fɔlɔ lɛ paa naziriwoo yɛn, mboo yɛɛ kan Yawe Yɛnŋɛlɛ li yeri mbaa tunŋgo piin li kan, ");
INSERT INTO dyi_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","wi daga mbe wɔ duvɛn naa sinmɛ wɛlɛwɛ sanmba pyew pi ni. Vinɛgiri ŋa pè duvɛn tɛgɛ maa gbegele, wii daga mbe pa wɔ; wiga ka mba pe ma gbegele sinmɛ wɛlɛwɛ pa yɛgɛ ni pa wɔ. Wii daga mbe wɔtɔnmɔ pa kpɛ wɔ mba pè gbegele ɛrɛzɛn tirige pire ni. Wii daga mbe ɛrɛzɛn pire tipiire nakoma piwara ka. ");
INSERT INTO dyi_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Wùu yɛɛ kan Yawe Yɛnŋɛlɛ li yeri sanga ŋa fuun ni, wiga ka yaraga ka ka ŋga pè gbegele ɛrɛzɛn pire ni, mbege lɛ ɛrɛzɛn pyɔ wi nawa pile li na fɔ saga wa wi kɔrɔgɔ ki na. ");
INSERT INTO dyi_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Wi yɔn fɔlɔ lɛsanga wi ni fuun wi ni, yunŋguluwo si daga mbe ye wa wi go ki ni, wùu yɛɛ kan Yawe Yɛnŋɛlɛ li yeri mbaa tunŋgo piin li kan sanga ŋa fuun ni fɔ wi sa kɔ. Wi yaa pye kpoyi mboo yinzire ti yaga tila tɔnlɔ ti yɛ konaa wi siyɔ wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Wùu yɛɛ kan Yawe Yɛnŋɛlɛ li yeri sanga ŋa fuun ni, wiga ka jiri gboo na. ");
INSERT INTO dyi_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Na wi to naa wi nɔ, naa wi nɔsepyɔ lenaŋa nakoma jɛlɛ wa ka ku pe ni, wiga ka jiri wa gboo na mboo yɛɛ tɛgɛ fyɔngɔ ni, katugu wùu yɛɛ kan Yawe Yɛnŋɛlɛ li yeri mbaa tunŋgo piin li kan, a wi yinzire ti yɛn naga wogo ki nari. ");
INSERT INTO dyi_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","«Wi yɔn fɔlɔ kɔnsanga wi ni fuun wi ni, wi yɛn ma tɛgɛ wi yɛ Yawe Yɛnŋɛlɛ li kan. ");
INSERT INTO dyi_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Na lere wa ka fo mbe ku le wi tanla, wi yinzire nda ti yɛn naga nari fɔ wùu yɛɛ kan li yeri, ti yaa pye fyɔngɔ ni. Lerefɔ wi kuŋgɔlɔ, ki pilige kɔlɔshyɛn wogo ki na, ko ŋga ki yɛn pilige ŋga wi yaa wi yɛɛ pye fyɔngɔ fu, wi yaa wi go ki kulu. ");
INSERT INTO dyi_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Pilige kɔlɔtaanri wogo ki na, wi yaa pan jɛndɛtuwaye shyɛn nakoma keteŋgele shyɛn ni saraga wɔfɔ wi kan wa filisaga paraga go ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Saraga wɔfɔ wi yaa nuŋgba kan li pye saraga mbe lerefɔ wi kapere ti kala yagawa ja, mbe si sanna li pye saraga ŋga pe ma sogo. Kona, wi yaa kapere ti kala yagawa ja kapyege ki pye lerefɔ wi kajɔɔgɔ ŋga wì pye, naa wì jiri gboo na ki kala na. Ki pilige nuŋgba ki ni, wi yaa wi yɛɛ kan naa Yɛnŋɛlɛ li yeri. ");
INSERT INTO dyi_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Wi yaa wi yɛɛ kan Yawe Yɛnŋɛlɛ li yeri mbe sanga ŋa pye, wi yaa ki yɔn fɔlɔ li lɛ naa fɔnŋgɔ. Wi yaa sumbyɔ ŋa wì ta yɛlɛ nuŋgba wa wɔ saraga na yeri mboo kajɔɔgɔ ki kala yagawa ja. Sanga ŋa wì keli ma pye wo se jate naa, katugu yɔn fɔlɔ koŋgbanna na wìla lɛ mbe sanga ŋa pye, wìla jɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«Na lere wa kaa yɛɛ kan Yɛnŋɛlɛ li yeri mbe tunŋgo pye li kan, wùu yɛɛ kan mbe sanga ŋa pye, na wiga ka kɔ, ŋgasele na lì tɛgɛ ki wogo ki na li na: Pe yaa kari wi ni wa filisaga paraga go ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Saraga ŋga wi yaa wɔ Yawe Yɛnŋɛlɛ li yeri ki ŋga: Simbapɔlɔ nuŋgba, ŋa wì ta yɛlɛ nuŋgba ma pye jɛrɛgisaga fu, wo yaa pye saraga sogowogo, naa simbasumboro nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba ma pye jɛrɛgisaga fu, wo mbe pye saraga ŋga pe ma wɔ mbe kapege kala yagawa ja, konaa simbapɔlɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba ma pye jɛrɛgisaga fu, wo mbe pye nayinmɛ saraga. ");
INSERT INTO dyi_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Wi yaa pan fun kanja pige ni ŋga kì yin leve fu buru ni, naa gato ni ŋa pòo muwɛ pi gbɔn sinmɛ ni, naa wɔn ni ŋa leve si ye wi ni, a pè sinmɛ yanragi yanragi wi na, naa yarikanra ko naa duvɛn saraga ŋga pe ma wo ma taga wa ki saara ti na ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Saraga wɔfɔ wi yaa pan ki yarikanra ti ni wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, mbege lerefɔ wi kapere ti kala yagawa saraga ki wɔ, naa wi saraga sogowogo ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Wi yaa simbapɔlɔ wi kan fun Yawe Yɛnŋɛlɛ li yeri wi pye nayinmɛ saraga, konaa kanja pige ŋga ki yɛn ma yin leve fu buru wi ni ki ni; mbe si muwɛ saraga ko naa duvɛn saraga ŋga pe ma wo ti taga wa. ");
INSERT INTO dyi_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Kona, ŋa wùu yɛɛ kan Yɛnŋɛlɛ li yeri, wi yaa wi yinzire nda ti yɛn naga nari fɔ wùu yɛɛ kan li yeri ti kulu wa filisaga paraga go ki yɔn na. Wi yinzire naa wi siyɔ sire nda ti yɛn naga nari ma yo wùu yɛɛ kan na yeri, wi yaa ti lɛ mberi le wa kasɔn ŋga ki yɛn na yiin wa nayinmɛ saraga ki kara ti nɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Saraga wɔfɔ wi yaa simbapɔlɔ wi pɔgɔ ŋga kì fɔ ma pe ki lɛ, naa kanja pige ki gato pyɔ nuŋgba ni ŋa leve si ye wi ni, konaa wɔn ni ŋa leve si ye wi ni, mbe siri le ŋa wùu yɛɛ kan Yɛnŋɛlɛ yeri wi kɛɛ, na wiga wi yinzire nda ti yɛn naga nari ma yo wùu yɛɛ kan Yɛnŋɛlɛ yeri ti kulu mbe kɔ we. ");
INSERT INTO dyi_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ko puŋgo na, saraga wɔfɔ wi yaa ki yaara ti yirige mberi kan saraga Yawe Yɛnŋɛlɛ li yeri. Ki yarikanra nda ti yɛn ma tɛgɛ ti yɛ na kan ti yaa pye saraga wɔfɔ wo woro, naa yaayogo ki ndige ŋga pè kan na yeri ki ni, konaa ki jegbɔlɔ na pe ma wɔ saraga wɔfɔ wi kan li ni. Ko puŋgo na, ŋa wùu yɛɛ kan Yawe Yɛnŋɛlɛ li yeri, wi mbe ya mbaa duvɛn woo naa fɔnŋgɔ. ");
INSERT INTO dyi_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«Na lere wa ka yɔn fɔlɔ kɔn Yawe Yɛnŋɛlɛ li yeri mbaa tunŋgo piin li kan, ŋgasele na li ma tanga yarikanra nda wi daga mbe kan na yeri ti wogo ki na tori yɛɛn. Na ki fanŋga ka pye wi ni wi yarikanra ta yɛgɛ kan mbe taga wa, wi mbe ya mbege pye. Ɛɛn fɔ, yɔn fɔlɔ na wì lɛ, yaraga ŋga ki ma wɔ, wi daga mbege wɔ, mbe yala wi naziri ŋgasele li ni.» ");
INSERT INTO dyi_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Ki yo Arɔn naa wi pinambiile pe kan fɔ: ‹Pa ye yaa la duwaw wi piin yɛɛn Izirayɛli woolo pe kan mbaa yuun fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Yawe Yɛnŋɛlɛ li duwaw ye na, laa ye go singi! ");
INSERT INTO dyi_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yawe Yɛnŋɛlɛ laa ye wele kajɛŋgɛ ni, li yinmɛ tirige ye na! ");
INSERT INTO dyi_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yawe Yɛnŋɛlɛ laa wele ye na, li yɛyinŋge kan ye yeri!› ");
INSERT INTO dyi_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Pa pe yaa la duwaw wi piin Izirayɛli woolo pe kan yɛɛn, kona pa mi jate, mi yaa duwaw pe na.» ");
INSERT INTO dyi_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Naa Moyisi wìla kaa Yɛnŋɛlɛ cɛnsaga paraga go ki kan maga kɔ, a wì si sinmɛ kpoyi wo ki na maga le Yɛnŋɛlɛ kɛɛ, konaa ki tunŋgo pyeyaara ti ni fuun ti ni. Wìla ki nuŋgba ki pye fun saraga wɔsaga ko naa ki tunŋgo pyeyaara ti ni fuun ti na. Wìla sinmɛ kpoyi wo ti na mari le Yɛnŋɛlɛ kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Kona Izirayɛli woolo mbele pàa pye teele pe tɛlɛye seye yi go na, pè si pan ma pe yarikanra ti kan. Poro pàa pye Izirayɛli cɛngɛlɛ teele mbele pàa leele pe jiri. ");
INSERT INTO dyi_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Pàa pan pe yarikanra ti ni wa Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ, to yɛn wotoroye mbele pè pe gona wi fo poro kɔgɔlɔni, naa nɛrɛ kɛ mari shyɛn. Wotoro nuŋgba la pye teele shyɛn yarikanga, a teele pe ni fuun nuŋgba nuŋgba pè kan nɛgɛ nuŋgba nuŋgba. A pè si pan ti ni wa Yɛnŋɛlɛ cɛnsaga paraga go ki yɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Ki yarikanra ti shɔ pe yeri, ti yaa pye tunŋgo pyeyaara wa filisaga paraga go ki ni. Mari kan Levi setirige piile pe yeri mbe yala pe ni fuun nuŋgba nuŋgba pe tunŋgo ki ni.» ");
INSERT INTO dyi_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Kona, a Moyisi wì si wotoroye poro naa nɛrɛ ti shɔ mari kan Levi setirige piile pe yeri. ");
INSERT INTO dyi_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Wìla wotoroye shyɛn naa nɛrɛ tijɛrɛ kan Gɛrishɔn setirige piile pe yeri ma yala pe tunŋgo ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Wìla wotoroye tijɛrɛ sanmbala naa nɛrɛ kɔlɔtaanri sannda ti kan Merari setirige piile pe yeri ma yala pe tunŋgo ki ni. Saraga wɔfɔArɔn wi pinambyɔ Itamari wo wìla pye na pe yɛgɛ sinni. ");
INSERT INTO dyi_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ɛɛn fɔ, wi sila ta kan Kehati setirige piile poro yeri, katugu yaara nda tìla tɛgɛ ti yɛ Yɛnŋɛlɛ kan, tìla le poro kɛɛ paa ti tungu pe pajoro ti na. ");
INSERT INTO dyi_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Pilige ŋga ni pàa sinmɛ kpoyi wo saraga wɔsaga ki na, a Izirayɛli woolo teele pè si pan yarikanra ni ma saraga wɔsaga ki le Yɛnŋɛlɛ kɛɛ. Pàa pan pe yarikanra ti ni wa saraga wɔsaga ki tanla. ");
INSERT INTO dyi_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Kona, a Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Izirayɛli woolo teele pe pye paa paan nuŋgba nuŋgba, pe nii naa pe pilige, mbaa pe yarikanra ti kaan mbe saraga wɔsaga ki le na kɛɛ.» ");
INSERT INTO dyi_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Pilige koŋgbanŋga ki na, Aminadabu pinambyɔ Naashɔn, wo wìla pan maa yarikanra ti kan, ma yiri wa Zhuda cɛnlɛ li ni. ");
INSERT INTO dyi_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Aminadabu pinambyɔ Naashɔn wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Pilige shyɛn wogo ki na, Suwari pinambyɔ Netaneyɛli wì si pan maa yarikanra ti kan, wo wìla pye to Isakari cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Suwari pinambyɔ Netaneyɛli wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Pilige taanri wogo ki na, Elɔn pinambyɔ Eliyabu wì si pan maa yarikanra ti kan, wo wìla pye to Zabulɔn cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Elɔn pinambyɔ Eliyabu wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Pilige tijɛrɛ wogo ki na, Shedewuri pinambyɔ Elisuri wì si pan maa yarikanra ti kan, wo wìla pye to Urubɛn cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Shedewuri pinambyɔ Elisuri wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Pilige kaŋgurugo wogo ki na, Zurishadayi pinambyɔ Shelumiyɛli wì si pan maa yarikanra ti kan, wo wìla pye to Simeyɔn cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Zurishadayi pinambyɔ Shelumiyɛli wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Pilige kɔgɔlɔni wogo ki na, Dewuwɛli pinambyɔ Eliyazafu wì si pan maa yarikanra ti kan, wo wìla pye to Gadi cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Dewuwɛli pinambyɔ Eliyazafu wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Pilige kɔlɔshyɛn wogo ki na, Amihudi pinambyɔ Elishama wì si pan maa yarikanra ti kan, wo wìla pye to Efirayimu cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Amihudi pinambyɔ Elishama wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Pilige kɔlɔtaanri wogo ki na, Pedasuri pinambyɔ Gamiliyɛli wì si pan maa yarikanra ti kan, wo wìla pye to Manase cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","naa wɔjɛnnɛ tɛ wolo nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Pedasuri pinambyɔ Gamiliyɛli wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Pilige kɔlɔjɛrɛ wogo ki na, Gidewoni pinambyɔ Abidan wì si pan maa yarikanra ti kan, wo wìla pye to Bɛnzhamɛ cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Gidewoni pinambyɔ Abidan wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Pilige kɛ wogo ki na, Amishadayi pinambyɔ Ayezɛri wì si pan maa yarikanra ti kan, wo wìla pye to Dan cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Amishadayi pinambyɔ Ayezɛri wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Pilige kɛ ma yiri nuŋgba wogo ki na, Okiran pinambyɔ Pagiyɛli wì si pan maa yarikanra ti kan, wo wìla pye to Asɛri cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Okiran pinambyɔ Pagiyɛli wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Pilige kɛ ma yiri shyɛn wogo ki na, Ena pinambyɔ Ayira wì si pan maa yarikanra ti kan, wo wìla pye to Nɛfitali cɛnlɛ woolo pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Yarikanra nda wìla pan ti nda: Warifuwe tasa kpakpalakpa nuŋgba, ŋa wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500), naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaraga nuŋgba, ŋga ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800), mbe yala Yɛnŋɛlɛ cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Ki tasaala shyɛn pàa pye ma yin muwɛ ni mba pàa sinmɛ pinlɛ pi ni mboo pye saraga, ");
INSERT INTO dyi_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","naa tɛ jɛnɛ nuŋgba ni, na li nuguwɔ pìla pye giramu cɛnmɛ ma yiri kɛ (110); làa pye ma yin wusuna nuwɔ taan ni, ");
INSERT INTO dyi_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","naa napɔlɔ yirifɔnŋɔ nuŋgba ni, naa simbapɔlɔ nuŋgba, konaa simbapɔlɔ yirifɔnŋɔ nuŋgba ni, ŋa wì ta yɛlɛ nuŋgba, poro yaa pye saraga sogowogo, ");
INSERT INTO dyi_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","naa sikapɔlɔ nuŋgba ni, wo yaa pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja, ");
INSERT INTO dyi_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","naa napɛnɛ shyɛn, naa simbapɛnɛ kaŋgurugo, naa sikapɛnɛ kaŋgurugo, konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kaŋgurugo, poro yaa pye nayinmɛ saraga. Yarikanra nda Ena pinambyɔ Ayira wìla kan, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Pilige ŋga ni pàa sinmɛ kpoyi wo saraga wɔsaga ki na mbege le Yɛnŋɛlɛ kɛɛ, yarikanra nda Izirayɛli woolo teele pàa kan, to lari yɛɛn: Warifuwe tasaala kpakpalakpa kɛ ma yiri shyɛn, naa tɔnmɔ mba pe maa yanragi yanragi pi warifuwe leyaara kɛ ma yiri shyɛn, konaa tɛ jɛŋgɛlɛ kɛ ma yiri shyɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Tasa kpakpalakpa nuŋgba nuŋgba pyew wi nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ kaŋgurugo (500). Tɔnmɔ mba pe maa yanragi yanragi pi leyaraga nuŋgba nuŋgba pyew ki nuguwɔ pìla pye giramu cɛnmɛ kɔlɔtaanri (800). Ki warifuwe yaara ti ni fuun ti nuguwɔ pìla pye culo nafa ma yiri kɔlɔshyɛn naa giramu cɛnmɛ kɔlɔshyɛn (700), mbe yala cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Tɛ jɛŋgɛlɛ kɛ ma yiri shyɛn kàa pye ma yin wusuna nuwɔ taan ni. Ke ni fuun nuŋgba nuŋgba ke nuguwɔ pìla pye giramu cɛnmɛ naa kɛ kɛ (110), mbe yala cɛnsaga paraga go ki warifuwe pyɔ wi jatere wi ni. Tɛ jɛŋgɛlɛ ke ni fuun ke nuguwɔ pìla pye culo nuŋgba naa giramu cɛnmɛ taanri naa nafa nafa (320). ");
INSERT INTO dyi_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Yaayoro nda pàa wɔ saara sogoworo ti ni fuun tìla pye napɛnɛ kɛ ma yiri shyɛn, naa simbapɛnɛ jɛmbɛlɛ kɛ ma yiri shyɛn, naa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro kɛ ma yiri shyɛn, naa muwɛ saara nda ti ma taga ti na ti ni, konaa sikapɛnɛ kɛ ma yiri shyɛn ni, poro yaa pye saara mbe kapere kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Yaayoro nda pàa wɔ nayinmɛ saraga, ti ni fuun tìla pye napɛnɛ nafa ma yiri tijɛrɛ, naa simbapɛnɛ jɛmbɛlɛ nafa taanri, naa sikapɛnɛ konaa simbapɛnɛ yirifɔnmbɔlɔ mbele pè ta yɛlɛ nuŋgba nuŋgba poro nafa taanrindaanri. Yarikanra nda pàa kan, naa pàa sinmɛ pi wo saraga wɔsaga ki na mbege le Yɛnŋɛlɛ kɛɛ, to lari yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Naa Moyisi wìla kaa na yiin wa filisaga paraga go ki ni mbe para Yawe Yɛnŋɛlɛ li ni, a wi nɛɛ magala la nuru na yinrigi wa kapere ti kasulugo pyesaga ki go na, wa yɔn finliwɛ sɛnrɛ kɛsu wi na, wa sherubɛnye shyɛn mbele pè gbegele ki na pe sɔgɔwɔ. A wi nɛɛ para wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Ki yo Arɔn wi kan fɔ na wi kaa fitanlaye kɔlɔshyɛn pe teri wa fitanladaga wi na sanga ŋa ni, wi ti paa yiin paa yanwa kaan wa wi yɛgɛ.» ");
INSERT INTO dyi_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","A Arɔn wì sigi pye ma. Wìla fitanlaye pe tɛgɛtɛgɛ wa fitanladaga wi na ma pe yɛgɛ wa wa wi yɛgɛ paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Tɛ pàa gbɔn wi yɛɛ na ma fitanladaga wi gbegele, maga lɛ wa wi nɔgɔ ki na fɔ ma saa gbɔn wa wi yarifyɛɛnrɛ yanlɛrɛ ti na. Pàa fitanladaga wi gbegele ma yala cɛnlɔmɔ mba Yawe Yɛnŋɛlɛ làa naga Moyisi wi na pi ni. ");
INSERT INTO dyi_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Levi setirige piile pe wɔ Izirayɛli woolo sanmbala pe sɔgɔwɔ ma pe pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ma yaa pe pye fyɔngɔ fu yɛgɛ ŋga na ki ŋga: ‹Tɔnmɔ mba pi ma ti kapere ti kasulugo ki ma pye, ma yaa pa yanragi yanragi pe na. Ko puŋgo na, ma ti pe pe sire ti kulu yunŋguluwo ni pe wire ti lagapyew ki na, pe pe yaripɔrɔ ti jogo. Pa kona pe yaa pye fyɔngɔ fu.› ");
INSERT INTO dyi_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ko puŋgo na, pe pan napɔlɔ yirifɔnŋɔ ni, pe saraga muwɛ mba pè sinmɛ pinlɛ pi ni pa taga wi na. Mboro wo na, ma napɔlɔ yirifɔnŋɔ wa yɛgɛ lɛ mboo pye saraga ŋga pe ma wɔ mbe kapere kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ma yaa Levi setirige piile pe pye pe fulo laga filisaga paraga go ki yɛgɛ na, mbe si Izirayɛli gbogolomɔ woolo pe ni fuun pe gbogolo laga fun. ");
INSERT INTO dyi_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ma yaa Levi setirige piile pe pye pe fulo laga mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ. Izirayɛli woolo sanmbala pe yaa pe kɛyɛn yi taga Levi setirige piile pe na. ");
INSERT INTO dyi_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Arɔn wi yaa Levi setirige piile pe yerege mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ sɔgɔwɔ mbe pe yirige mbe pe kan na yeri paa Izirayɛli woolo pe yarikanga yɛn, kona pa pe yaa la tunŋgo piin na kan. ");
INSERT INTO dyi_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Kona Levi setirige piile pe yaa pe kɛyɛn yi tagataga napɛnɛ shyɛn pe yinrɛ ti na. Ma yaa nuŋgba wɔ na yeri saraga mbe kapere ti kala yagawa ja, mbe si sanŋa wo pye saraga sogowogo mi ŋa Yawe Yɛnŋɛlɛ li na yeri, jaŋgo mbe kapere ti kala yagawa ja kapyege ki pye Levi setirige piile pe kan. ");
INSERT INTO dyi_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ma yaa Levi setirige piile pe pye pe yere Arɔn naa wi pinambiile pe yɛgɛ sɔgɔwɔ, mbe si pe yirige mbe pe kan mi ŋa Yawe Yɛnŋɛlɛ na yeri paa saraga yɛn. ");
INSERT INTO dyi_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Kiga pye ma, pa ma yaa Levi setirige piile pe laga Izirayɛli woolo sanmbala pe na, pa pe yaa pye na woolo. ");
INSERT INTO dyi_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Ko puŋgo na, Levi setirige piile pe yaa pan mbaa tunŋgo piin laga filisaga paraga go ki ni. «Pa ma yaa pe pye fyɔngɔ fu yɛɛn, mbe pe yirige mbe pe kan na yeri paa saraga yɛn. ");
INSERT INTO dyi_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Katugu pè kan na yeri pew, ma yiri wa Izirayɛli woolo sanmbala pe sɔgɔwɔ. Mì pe lɛ, a pè pye na woolo Izirayɛli woolo pe pinambiile koŋgbanmbala pe yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Katugu Izirayɛli woolo pe pinambiile koŋgbanmbala pe ni fuun pe yɛn na woolo, leele o, yaayoro o. Pilige ŋga ni mìla Ezhipiti tara fɛnnɛ pe pinambiile koŋgbanmbala pe gbo, a mì si Izirayɛli woolo pe pinambiile koŋgbanmbala pe tɛgɛ pe yɛ na yɛɛ kan. ");
INSERT INTO dyi_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mì Levi setirige piile pe lɛ ma pe pye na woolo Izirayɛli woolo pe pinambiile pe yɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Mì pe le Arɔn naa wi pinambiile pe kɛɛ ma yiri wa Izirayɛli woolo sanmbala pe sɔgɔwɔ, jaŋgo paa tunŋgo piin Izirayɛli woolo pe yɔnlɔ wa filisaga paraga go ki ni. Pe yaa la Izirayɛli woolo pe kapere ti kala yagawa jatunŋgo ki piin, jaŋgo jɔlɔgɔ kpɛ ka ka pe ta na paga fulo wa cɛnsaga paraga go ki tanla we.» ");
INSERT INTO dyi_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","A Moyisi, naa Arɔn, naa Izirayɛli gbogolomɔ woolo pe ni fuun pe ni, pè si ŋga Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan Levi setirige piile pe kanŋgɔlɔ ki pye pe na. ");
INSERT INTO dyi_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","A Levi setirige piile pè si pe yɛɛ pye fyɔngɔ fu, ma pe yaripɔrɔ ti jogo. A Arɔn wì si pe pye saraga ŋga pe ma yirige ma kan Yawe Yɛnŋɛlɛ li yeri. A wì si kapere ti kala yagawa ja kapyege ki pye pe kan, jaŋgo mbe pe pye fyɔngɔ fu. ");
INSERT INTO dyi_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ko puŋgo na, a Levi setirige piile pè si pan na pe tunŋgo ki piin wa filisaga paraga go ki ni. Arɔn naa wi pinambiile pe ni, poro pàa pye na pe yɛgɛ sinni. Ŋga Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan Levi setirige piile pe kanŋgɔlɔ, pàa tanga ma yala ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yawe Yɛnŋɛlɛ làa para naa Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Levi setirige piile mbele pè ta yɛlɛ nafa ma yiri kaŋgurugo kaŋgurugo konaa pe yɛgɛ fɛnnɛ pe ni, pe yaa ye wa filisaga paraga go tunŋgo ki ni mbaa tunŋgo ka piin. ");
INSERT INTO dyi_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Mbele ka ta yɛlɛ nafa shyɛn ma yiri kɛ kɛ, poro yaa pe tunŋgo ki yerege, pe saa tunŋgo piin naa. ");
INSERT INTO dyi_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Pe yaa kaa Levi setirige piile sanmbala pe sari pe tunndo ti na wa filisaga paraga go ki ni. Ɛɛn fɔ, poro jate tunndo se ka pye pe yeri pe woro. Kagala ŋgele ma yaa pye Levi setirige piile pe tunŋgo wogo ki kanŋgɔlɔ koro wɛlɛ yɛɛn.» ");
INSERT INTO dyi_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni wa filisaga paraga go ki ni, wa Sinayigbinri wi ni. Kìla pye Izirayɛli woolo pe yiriŋgɔlɔ wa Ezhipiti tara ki yɛlɛ shyɛn wolo li yeŋge koŋgbanŋga ki na. Làa wi pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Izirayɛli woolo pe daga mbe Paki fɛti wi pye mbe yala wagati ŋa wì kɔn ma tɛgɛ wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ye Paki fɛti wi pye ye yala wagati ŋa wì kɔn ma tɛgɛ wi ni, ki yeŋge ŋga yɛɛn ki pilige kɛ ma yiri tijɛrɛ wogo ki yɔnlɔkɔgɔ, mbe sa gbɔn ki yembinɛ li na, mbe yala wi kondɛgɛŋgɛlɛ naa wi kakɔnndɛgɛŋgɛlɛ ke ni fuun ke ni.» ");
INSERT INTO dyi_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Kona, a Moyisi wì si para Izirayɛli woolo pe ni ma yo pe Paki fɛti wi pye. ");
INSERT INTO dyi_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","A pè si Paki fɛti wi pye wa Sinayi gbinri wi ni, yɛlɛ shyɛn wolo li yeŋge koŋgbanŋga ki pilige kɛ ma yiri tijɛrɛ wogo ki na, maga lɛ ki yɔnlɔkɔgɔ ki na ma saa gbɔn yembinɛ li na. Pàa wi pye ma yala Yawe Yɛnŋɛlɛ làa sɛnrɛ nda yo Moyisi wi kan ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ma si yala, leele pèle la pye fyɔngɔ ni Yɛnŋɛlɛ yɛgɛ na, katugu poro la jiri gboo na. Pe saa ya mbe Paki fɛti wi pye ki pilige ki ni. A pè si kari ki pilige nuŋgba ki ni wa Moyisi naa Arɔn pe yeri, ");
INSERT INTO dyi_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ma saa pe pye fɔ: «We yɛn fyɔngɔ ni, katugu wè jiri gboo na. Mɛlɛ pee we yɛgɛ kɔn waga si ka pan we yarikanra ti ni Yawe Yɛnŋɛlɛ li kan mbe pinlɛ Izirayɛli woolo sanmbala pe ni, wagati ŋa wì kɔn ma tɛgɛ wi ni?» ");
INSERT INTO dyi_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","A Moyisi wì si pe pye fɔ: «Yanla sige na, mi yaa sa Yawe Yɛnŋɛlɛ li yewe ŋga li yaa yo na kan ye wogo ki na.» ");
INSERT INTO dyi_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","(A wì si kari). A Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni maa pye fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Ki yo Izirayɛli woolo pe kan fɔ: ‹Na leele pele ka pye laga ye sɔgɔwɔ, nala nakoma ye setirige piile mbele fuun pe yaa ka yiri puŋgo na pe ni, na ki leele pele ka pye fyɔngɔ ni, katugu pè jiri gboo na, nakoma na ki ka yala pe kari ca na lege, pa pe yaa ka Paki fɛti wi pye bere mi ŋa Yawe Yɛnŋɛlɛ na kan. ");
INSERT INTO dyi_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Pe daga mbe Paki fɛti wi pye ki yeŋge shyɛn wogo ki pilige kɛ ma yiri tijɛrɛ wogo ki na, mbege lɛ yɔnlɔkɔgɔ sa gbɔn yembinɛ li na. Simbapyɔ yirifɔnŋɔ wi daga mbe gbo Paki fɛti wi na, pe yaa wi kara ti ka leve fu buru ni konaa yaanga taanga ni. ");
INSERT INTO dyi_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Pe se ka yaakara ta yaga ti wɔnlɔ mbe yiri, pe se si ka yaayogo ki kajelege ka ya. Pe yaa fɛti wi pye mbe yala Paki fɛti wi kondɛgɛŋgɛlɛ ke ni fuun ke ni. ");
INSERT INTO dyi_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ɛɛn fɔ, na lere wa ka pye fyɔngɔ fu, na wii kari ca na, na wii si Paki fɛti wi pye, wi daga poo purɔ poo wɔ wa wi woolo pe sɔgɔwɔ; katugu wii pan yarikanga ni mi ŋa Yawe Yɛnŋɛlɛ na kan wagati ŋa wì kɔn ma tɛgɛ wi ni. Wi yaa wi kapege ki go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Na nambanŋa wa ka pye mbe cɛn wa ye sɔgɔwɔ, na wi kaa jaa mbe mi ŋa Yawe Yɛnŋɛlɛ na Paki fɛti wi pye, wi yaa wi pye mbe yala Paki wi kondɛgɛŋgɛlɛ naa wi kakɔnndɛgɛŋgɛlɛ ke ni. Kondɛgɛlɛ nuŋgba li yaa pye wa, yoro Izirayɛli tara piile naa nambanmbala pe kan.› » ");
INSERT INTO dyi_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Pilige ŋga ni pàa Yɛnŋɛlɛ cɛnsaga paraga go ki kan maga kɔ, yɔn finliwɛ sɛnrɛ tìla pye ma yɔnlɔgɔ sinndɛɛrɛ papara papara nda na tìla pye ma tɛgɛ paraga go ŋga ni, a kambaaga si pan ma tɔn ki na. Kambaaga kìla pye wa Yɛnŋɛlɛ cɛnsaga paraga go ki go na, maga lɛ ki yɔnlɔkɔgɔ ki na fɔ ma saa gbɔn ki goto pinliwɛ pi na paa kasɔn yɛn. ");
INSERT INTO dyi_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Kìla pye na piin ma suyi; kambaaga kìla pye ma Yɛnŋɛlɛ cɛnsaga paraga go ki tɔn. Na yembinɛ ka wɔ, ki ma pye paa kasɔn yɛn. ");
INSERT INTO dyi_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Na kambaaga ki ka yiri wa paraga go ki go na sanga o sanga, Izirayɛli woolo pe ma pe paara yinrɛ ti kɔlɔgi na kee. Na kiga sa yere laga ŋga fuun na, pe ma pe paara yinrɛ ti kankan mbe cɛn lema. ");
INSERT INTO dyi_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ki pyewe pi na ma, Izirayɛli woolo pàa pye na pe paara yinrɛ ti kologi na kee ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni; pàa si pye nari kanni na cɛɛn ma yala li sɛnyoro ti ni. Kambaaga ki ka mɔ wa Yɛnŋɛlɛ cɛnsaga paraga go ki go na mbe gbɔn yɛgɛ ŋga na, pa Izirayɛli woolo pe ma mɔ le pe paara yinrɛ cɛnsaga ki ni ma. ");
INSERT INTO dyi_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ali na kambaaga ki ka koro wa Yɛnŋɛlɛ cɛnsaga paraga go ki go na mbe mɔ wa, Izirayɛli woolo pe maa taanri na yala Yawe Yɛnŋɛlɛ li ŋgasele li ni, paa yiri mbaa kee. ");
INSERT INTO dyi_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Na kambaaga ki ka koro wa Yɛnŋɛlɛ cɛnsaga paraga go ki go na piliye jɛnri ni, pe ma pe paara yinrɛ ti kankan ma cɛn konaa ma kaa ti kɔlɔgi na kee ma yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Wagati wa ni, kambaaga ki ma saa yere laga ka go na mbege lɛ yɔnlɔkɔgɔ sa gbɔn ki goto pinliwɛ ni. Na ki ka yiri ki pinliwɛ pi ni, Izirayɛli woolo pe ma paara yinrɛ ti kɔlɔgi na kee. Na kambaaga ki ka si koro wa mbe yɔnlɔ nuŋgba naa yembinɛ nuŋgba pye, mbe si yiri, Izirayɛli woolo pe ma yiri mbaa kee. ");
INSERT INTO dyi_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Na kambaaga ki ka koro wa Yɛnŋɛlɛ cɛnsaga paraga go ki go na mbe ta piliye shyɛn, nakoma yeŋge nuŋgba, nakoma mbe mɔ wa jɛŋgɛ mbe wɛ ko na, Izirayɛli woolo pe ma koro ma cɛn wa pe paara yinrɛ ti ni, paa kari. Na ki ka ka yiri, pe maa kee. ");
INSERT INTO dyi_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Izirayɛli woolo pàa pye na pe paara yinrɛ ti kanni na cɛɛn na yala Yawe Yɛnŋɛlɛ li sɛnyoro ti ni, pàa si pye nari kologi na kee na yala li sɛnyoro ti ni. Pàa pye na tanri na yala li ŋgasele li ni, ma yala làa sɛnrɛ nda yo Moyisi wi kan ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Ma ti pe warifuwe gbɔn wi yɛɛ na pe mbaanra shyɛn gbegele. To ti yaa lɔɔn sari maa gbogolomɔ woolo pe yinri maa pe gbogolo, konaa mbaa konɔ kaan paara yinrɛ cɛnsaga woolo pe yeri na pe karisanga wiga gbɔn we. ");
INSERT INTO dyi_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Na paga mbaanra shyɛn ti pinlɛ mberi win sanga ŋa ni, gbogolomɔ woolo pe ni fuun pe pan pe gbogolo wa ma tanla, wa filisaga paraga go ki yɔn na. ");
INSERT INTO dyi_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Na paga mbanlaga nuŋgba win, mbele pe yɛn teele ma pye Izirayɛli woolo waga lɛgɛrɛ pe go na, poro cɛ pe yaa pan mbe gbogolo wa ma tanla. ");
INSERT INTO dyi_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Na yaga mbanlaga ki win mbege magala li gbɔgɔ, mbele pe yɛn ma cɛn wa paara yinrɛ ti ni, wa filisaga paraga go ki yɔnlɔ yirisaga kɛɛ yeri, poro mbe yiri paa kee. ");
INSERT INTO dyi_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Na yaga kaga win mbege magala li gbɔgɔ naa shyɛn wogo na, mbele pe yɛn ma cɛn wa paara yinrɛ ti ni, wa filisaga paraga go ki yɔnlɔparawa kalige kɛɛ yeri, pe yiri paa kee. ");
INSERT INTO dyi_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ye yaa la mbanlaga ki wiin fun mbaa leele pe gbogolo, ɛɛn fɔ, ye se kaa ki wiin mbaa ki magala li gbogo. ");
INSERT INTO dyi_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","«Saraga wɔfɛnnɛ, poro mbele pe yɛn Arɔn wi setirige piile poro cɛ pe yaa la mbaanra ti wiin. Ko yaa pye ŋgasele na li yɛn kɔsaga fu yoro naa ye setirige piile ye kan. ");
INSERT INTO dyi_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«Na yaga ka sa cɛn wa ye tara ti ni, mbe kaa kee sa malaga gbɔn ye winfɛnnɛ mbele pe yaa ka pan mbe to ye na pe ni sanga ŋa ni, ye ye mbaanra ti win yeri magaŋgala ke gbɔgɔ. Pa ki yaa ye nawa to fɔ mi ŋa Yawe Yɛnŋɛlɛ mi yɛn na jatere piin ye na mbe ti ye shɔ ye juguye pe kɛɛ. ");
INSERT INTO dyi_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ye nayinmɛ piliye, naa ye shɛrɛgɛ fɛti piliye, konaa ye yevɔnndɔ piliye koŋgbanya yi ni, na ye kaa ye saara sogoworo ti woo konaa ye nayinmɛ saara ti ni, ye yaa ye mbaanra ti win. Pa ki yaa ye kan yaa nawa tuun mi ŋa ye Yɛnŋɛlɛ ŋga mì pye ye kan ki wogo ki na. Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Izirayɛli woolo pe yiriŋgɔlɔ wa Ezhipiti tara ki yɛlɛ shyɛn wolo, li yeŋge shyɛn wogo, ki pilige nafa wogo ki na, yɔn finliwɛ sɛnrɛ ti yɛn ma tɛgɛ Yɛnŋɛlɛ li cɛnsaga paraga go ŋga ni, a kambaaga kì si yiri wa ki go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","A Izirayɛli woolo pè si yiri wa Sinayigbinri wi ni ma kari. Pàa pye na tanri na yeregi yeregi na kee. A kambaaga kì si saa yere wa Paran gbinri wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ki koŋgbanŋga ko layi Izirayɛli woolo pàa pe paara yinrɛ ti kɔlɔgi ma yiri na kee, ma yala sɛnrɛ nda Yawe Yɛnŋɛlɛ làa yo Moyisi wi kan ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Zhuda paara yinrɛ cɛnsaga maliŋgbɔɔnlɔ ŋgbeleye taanri yo yìla keli ma yiri na kee pe cɛnsaga dirapo wi ni pe yɛgɛ. Aminadabu pinambyɔ Naashɔn wo wìla pye to pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Suwari pinambyɔ Netaneyɛli wo wìla pye to Isakari cɛnlɛ woolo pe maliŋgbɔɔnlɔ ŋgbelege ki go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Elɔn pinambyɔ Eliyabu wo wìla pye to Zabulɔn cɛnlɛ woolo pe maliŋgbɔɔnlɔ ŋgbelege ki go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ko puŋgo na, a pè si Yɛnŋɛlɛ cɛnsaga paraga go ki kɔlɔgi. A Gɛrishɔn setirige piile, naa Merari setirige piile pè sigi tugo na kee ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kona, a Urubɛn paara yinrɛ cɛnsaga maliŋgbɔɔnlɔ ŋgbeleye taanri yì si yiri na kee, pe cɛnsaga dirapo wi ni pe yɛgɛ. Shedewuri pinambyɔ Elisuri wo wìla pye pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Zurishadayi pinambyɔ Shelumiyɛli wo wìla pye to Simeyɔn cɛnlɛ woolo pe maliŋgbɔɔnlɔ ŋgbelege ki go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Dewuwɛli pinambyɔ Eliyazafu wo wìla pye to Gadi cɛnlɛ woolo pe maliŋgbɔɔnlɔ ŋgbelege ki go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ko puŋgo na, a Kehati setirige piile pè si yaara nda ti yɛn kpoyi ti tugo na kee. A Levi setirige piile sanmbala pè si saa Yɛnŋɛlɛ cɛnsaga paraga go ki sanga maga kan na pe singi. ");
INSERT INTO dyi_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ko puŋgo na, a Efirayimu paara yinrɛ cɛnsaga maliŋgbɔɔnlɔ ŋgbeleye taanri yì si yiri na kee, pe cɛnsaga dirapo wi ni pe yɛgɛ. Amihudi pinambyɔ Elishama wo wìla pye to pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Pedasuri pinambyɔ Gamiliyɛli wo wìla pye to Manase cɛnlɛ woolo pe maliŋgbɔɔnlɔ ŋgbelege ki go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Gidewoni pinambyɔ Abidan wo wìla pye to Bɛnzhamɛ cɛnlɛ woolo pe maliŋgbɔɔnlɔ ŋgbelege ki go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ko puŋgo na, a Dan paara yinrɛ cɛnsaga maliŋgbɔɔnlɔ ŋgbeleye taanri yì si yiri na kee, pe cɛnsaga dirapo wi ni pe yɛgɛ. Poro pàa pye pe ni fuun pe puŋgo na. Amishadayi pinambyɔ Ayezɛri wo wìla pye to pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Okiran pinambyɔ Pagiyɛli wo wìla pye to Asɛri cɛnlɛ woolo pe maliŋgbɔɔnlɔ ŋgbelege ki go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ena pinambyɔ Ayira wo wìla pye to Nɛfitali cɛnlɛ woolo pe maliŋgbɔɔnlɔ ŋgbelege ki go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Naa Izirayɛli woolo pàa pe paara yinrɛ ti kɔlɔgi, pa pàa yiri ma tagala pe yɛɛ na yɛɛn na kee ma yala pe maliŋgbɔɔnlɔ ŋgbeleye yi ni. ");
INSERT INTO dyi_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","A Moyisi wì suu nafɔ Erewuwɛli ŋa wìla pye Madiyan tara fɛnnɛ woo wi pinambyɔ Obabu wi pye fɔ: «We yɛn na kee wa tara nda Yawe Yɛnŋɛlɛ lì yɔn fɔlɔ kɔn mbe kan we yeri ti ni. Ki kala na, ma pinlɛ we ni. We yaa ti ma kajɛŋgɛ ta, katugu Yawe Yɛnŋɛlɛ lì yɔn fɔlɔ kɔn mbe kajɛŋgɛ pye woro Izirayɛli woolo we kan.» ");
INSERT INTO dyi_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","A Obabu wì suu yɔn sogo ma yo fɔ: «Ayoo, mi se pinlɛ ye ni mbe kari wa, mi yaa sɔngɔrɔ wa na tara, wa na go woolo pe yeri.» ");
INSERT INTO dyi_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","A Moyisi wì suu pye naa fɔ: «Mila ma yɛnri, maga ka laga we na; katugu gbinri wi lara nda we mbe ya mbe we paara yinrɛ ti kankan mbe cɛn wa, ma yɛn mari jɛn. Ma yaa pye we yɛgɛ sinfɔ. ");
INSERT INTO dyi_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Na maga pinlɛ we ni, Yawe Yɛnŋɛlɛ li yaa kajɛŋgɛ ŋga pye we kan.» ");
INSERT INTO dyi_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","A Izirayɛli woolo pè si yiri wa Yawe Yɛnŋɛlɛ li yanwiga ki na ma piliye taanri tangala tanga. Ki piliye taanri yi ni, Yawe Yɛnŋɛlɛ li yɔn finliwɛ kɛsu pàa wi tugo ma keli wi ni pe yɛgɛ mbe sa laga ŋga pe mbe ya cɛn mbe wogo ka lagaja pe kan. ");
INSERT INTO dyi_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kìla pye, na paga pe paara yinrɛ ti kɔlɔgi mbaa kee, yɔnlɔ na, Yawe Yɛnŋɛlɛ li kambaaga ki ma pye pe go na. ");
INSERT INTO dyi_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Na yɔn finliwɛ kɛsu pe kaa kee wi ni sanga ŋa ni, Moyisi wi ma yo fɔ: «Yawe Yɛnŋɛlɛ, yiri we kari, jaŋgo ma juguye pe gbɔn pe jaraga, ma panrafɛnnɛ paa fee ma yɛgɛ.» ");
INSERT INTO dyi_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Na pe kaa yɔn finliwɛ kɛsu wi tungu sanga ŋa ni, Moyisi wi ma yo fɔ: «Yawe Yɛnŋɛlɛ, sɔngɔrɔ ma pan, ma pan ma cɛn laga Izirayɛli woolo waga lɛgɛrɛ pe sɔgɔwɔ.» ");
INSERT INTO dyi_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Pilige ka, Izirayɛli woolo pàa kɔngɔri jɛŋgɛ Yawe Yɛnŋɛlɛ li na. Naa Yawe Yɛnŋɛlɛ làa kaa pe kɔngɔrimɔ pi logo, a lì si nawa ŋgban fɔ jɛŋgɛ. A lì si yɛnŋɛlɛ gbanlaga kasɔn wa pe na. A kì si pe paara yinrɛ cɛnsaga ki kanŋgɔlɔ nuŋgba sogo. ");
INSERT INTO dyi_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","A Izirayɛli woolo pè si gbele ŋgbanga ma Moyisi wi yɛnri wi pe saga. A Moyisi wì si Yawe Yɛnŋɛlɛ li yɛnri, a kasɔn kì si figi. ");
INSERT INTO dyi_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","A pè sigi laga ki mɛgɛ taga naga yinri Tabeera, ko kɔrɔ wo ŋa jɔgɔwɔ kasɔn, katugu ko laga ko layi Yawe Yɛnŋɛlɛ li kasɔn kìla yigi wa pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Pilige ka, nambanmbala mbele pàa pye cɛngɛlɛ kele yɛgɛ woolo wa Izirayɛli woolo pe sɔgɔwɔ, a jogo cɛnlɛ pyew wà si pe yigi. Kona, a Izirayɛli woolo pè sigi lɛ na kɔngɔri fun na yuun fɔ: «Ndɛɛ ki pye we mbe ja kara ta mbe ka, ki jɛn naga jɛn! ");
INSERT INTO dyi_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","E! Ŋgbanra nda wàa pye na kaa waga wa Ezhipiti tara, waa nawa tuun ti na, naa sɛrɛ yaara nda pe yinri kɔnkɔnmburu, naa melɔn, naa puwaro, naa, jawa konaa layi wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Koni we yɛn na cogo, we woro na yaraga ka kpɛ yaan naa, kaawɔ manɛ wo, sanga pyew manɛ.» ");
INSERT INTO dyi_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manɛ wìla pye paa koriyandiri yantiire pire puuru ti yɛn, ma filige paa bedelimu tige tɔnmɔ pi yɛn. ");
INSERT INTO dyi_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Kìla pye, leele pe ma jaraga ma saa wi wulo, ko puŋgo na, pe mɛɛ saa wi tire tira na nakoma mboo sun sugulo, mbe si jɛn mboo sɔgɔ cɔgɔ nakoma mboo wa wɔn. Manɛ wi tanwa pìla pye paa gato yɛn, ŋa pè wa sinmɛ ni. ");
INSERT INTO dyi_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Yembinɛ, na fɔɔngɔ ki kaa wuun sanga ŋa ni wa paara yinrɛ cɛnsaga, manɛ wi maa wuun fun. ");
INSERT INTO dyi_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Sege nuŋgba nuŋgba pyew ki woolo pàa pye ma cɛn wa pe paara yinrɛ ti yeyɔnrɔ ti na, na gbele. A Moyisi wì sigi logo, a pe gbeere tì si Yawe Yɛnŋɛlɛ li nawa pi ŋgban. A kì si Moyisi wi mbɛn fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","A wì si Yawe Yɛnŋɛlɛ li pye fɔ: «Yiŋgi na, a ma nɛɛ mi ŋa ma tunmbyee na jɔlɔ yɛɛn? Yiŋgi na, mɛɛ si kajɛŋgɛ pye na kan. Mɛlɛ mɛɛ ki leele mbele pe ni fuun pe go kala li le na kɛɛ mbeli lɛ? ");
INSERT INTO dyi_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Muwi mìgi leele mbele pe ni fuun pe kugbɔrɔ ti lɛ wi le? Muwi mì pe se wi le? A mà silan pye ma yo mbe pe lɛ kotogo na paa yɛgɛ ŋga na pyɔ gbegelefɔ ma piyɛnlɛ lɛ nali gbegele, mbe kari pe ni fɔ wa tara nda màa yɔn fɔlɔ lɛ ma wugu mbe kan pe tɛlɛye pe yeri ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Mi yaa ki kara ti ta se mbe siri kan ki leele mbele pe ni fuun pe yeri peri ka? Pe mbele pe yɛn na gbele na na tanla na yuun fɔ: ‹Kara kan we yeri we ka.› ");
INSERT INTO dyi_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mi se ya mbege leele mbele pe ni fuun pe go kala li lɛ na yɛ. Pe go kala lì nugu ma wɛ na na. ");
INSERT INTO dyi_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Na kaa pye maa jaa mbe kajɛŋgɛ pye na kan, na gbo teere jaŋgo mi ka kaa na jɔlɔgɔ kagala ke yaan yɛnlɛ ni.» ");
INSERT INTO dyi_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Nambala nafa taanri ma yiri kɛ wɔ wa Izirayɛli lelɛɛlɛ pe sɔgɔwɔ ma pe gbogolo na kan, mbele mà jɛn pe yɛn lelɛɛlɛ ma pye leele pe kagala yɛgɛ wɔfɛnnɛ. Ma kari pe ni wa filisaga paraga go ki ni, ma pe pye pe yere le ma tanla wa na yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mi yaa tigi mbe para ma ni le ki laga ki ni. Mi yaa na yinnɛ na li yɛn ma ni la wɔ mbe kan pe yeri, jaŋgo pe leele pe go kala li lɛ ma ni. Pa kona ma se ka pe go kala li lɛ ma yɛ. ");
INSERT INTO dyi_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ki yo leele pe kan fɔ: ‹Ye ye yɛɛ pye kpoyi sanni goto. Ye yaa kara ta mbe ka. Kì kaa pye yè gbele Yawe Yɛnŋɛlɛ li nuŋgbolo ma yo fɔ: Ambɔ wi yaa we kan kara we ka? Yege wele pa kìla pye ma tanla we na wa Ezhipiti tara. Ye pyeri, Yawe Yɛnŋɛlɛ li yaa kara kan ye yeri ye ka. ");
INSERT INTO dyi_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ye se kari ka pilige nuŋgba, nakoma piliye shyɛn, nakoma piliye kaŋgurugo, nakoma piliye kɛ, nakoma piliye nafa yɛrɛ. ");
INSERT INTO dyi_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Ɛɛn fɔ, ye yaa ti ka fɔ sa gbɔn yeŋge nuŋgba, fɔ ti sa la kɔ ye na, tila lugo tila yinrigi wa ye numagala ke ni, katugu yè je Yawe Yɛnŋɛlɛ na li yɛn laga ye sɔgɔwɔ li na, ma gbele li yɛgɛ sɔgɔwɔ ma yo fɔ: Yiŋgi na, a wè si yiri wa Ezhipiti tara ti ni?› » ");
INSERT INTO dyi_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moyisi wìla Yawe Yɛnŋɛlɛ li pye fɔ: «Ki leele mbele mi yɛn laga pe sɔgɔwɔ, pe yɛn nambala waga cɛnmɛ kɔgɔlɔni (600 000) mbele pe mbe ya kala pye. A mà sho fɔ ma yaa kara kan pe yeri pe ka fɔ sa gbɔn yeŋge nuŋgba! ");
INSERT INTO dyi_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ali na waga we simbaala, naa we sikaala, naa we nɛrɛ ti kɔnlɔgi pe kan, ti se pe bɔ! Ali na waga si kɔgɔje ŋgbanra ti ni fuun ti wɔ mberi gbogolo pe kan, ti se pe bɔ.» ");
INSERT INTO dyi_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","A Yawe Yɛnŋɛlɛ lì si Moyisi wi yɔn sogo ma yo fɔ: «Mi ŋa Yawe Yɛnŋɛlɛ, na fanŋga kii kologo. Sanni jɛnri, ma yaa ki yan na kaa pye sɛnrɛ nda mì yo, ki kala li mbe ya pye nakoma li se ya pye.» ");
INSERT INTO dyi_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Kona, a Moyisi wì si yiri ma saa sɛnrɛ nda Yawe Yɛnŋɛlɛ làa yo ti yɛgɛ yo leele pe kan. Ko puŋgo na, a wì si Izirayɛli woolo pe lelɛɛlɛ nafa taanri ma yiri kɛ wɔ ma pe gbogolo, ma pe yerege ma paraga go ki maga. ");
INSERT INTO dyi_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","A Yawe Yɛnŋɛlɛ lì si tigi kambaaga titɔnlɔgɔ yerege ka ni ma pan ma para Moyisi wi ni. Làa li yinnɛ na kan Moyisi wi yeri, a lì si la laga wa li na ma kankan lelɛɛlɛ nafa taanri ma yiri kɛ pe yeri. Naa Yawe Yɛnŋɛlɛ li yinnɛ làa kaa tigi pe na sanga ŋa ni, a pe nɛɛ Yɛnŋɛlɛ li yɔn sɛnrɛ yuun. Ɛɛn fɔ, pe sila koro mbaa ti yuun suyi. ");
INSERT INTO dyi_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Nambala shyɛn la pye wa, pàa pye na nuŋgba yinri Ɛlidadi, na sanŋa wi yinri Medadi. Kagala yɛgɛ wɔfɛnnɛ nafa taanri mbele pe mɛrɛ tìla yɔnlɔgɔ, poro pele la wɛlɛ. Poro la koro wa paara yinrɛ cɛnsaga ki ni, pe sila pan wa paraga go ki tanla. Ɛɛn fɔ, a Yɛnŋɛlɛ li yinnɛ lì si tigi pe na, a pe nɛɛ Yɛnŋɛlɛ li yɔn sɛnrɛ yuun wa paara yinrɛ cɛnsaga ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","A lefɔnŋɔ wà si fe ma saa ki yo Moyisi wi kan ma yo fɔ: «Ɛlidadi naa Medadi paa Yɛnŋɛlɛ li yɔn sɛnrɛ yuun wa paara yinrɛ cɛnsaga ki ni.» ");
INSERT INTO dyi_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Kona, Nuni pinambyɔ Zhozuwe ŋa wìla pye na tunŋgo piin Moyisi wi ni maga lɛ wa sanga ŋa ni wi yɛn lefɔnŋɔ, a wì sho fɔ: «Na tafɔ Moyisi, ki yo pe kan paga kaa ki piin.» ");
INSERT INTO dyi_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","A Moyisi wì suu yɔn sogo ma yo fɔ: «Maga kaa yenjaga piin na kala na. Ndɛɛ ki pye Yawe Yɛnŋɛlɛ lili yinnɛ li tirige Izirayɛli woolo pe ni fuun pe na, a pe pye li yɔn sɛnrɛ yofɛnnɛ, ki jɛn nala ndanla!» ");
INSERT INTO dyi_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ko puŋgo na, a Moyisi wo naa Izirayɛli lelɛɛlɛ pe ni pè si yiri le ma sɔngɔrɔ wa paara yinrɛ cɛnsaga ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Kona, a Yawe Yɛnŋɛlɛ lì si ti a tifɛlɛgɛ kà yiri wa kɔgɔje wi yeri na gbɔɔn, ma pan siriŋgbangala ni, ma ke wo ma paara yinrɛ cɛnsaga ki maga, maga fili. Kàa wo ma kari pa pilige nuŋgba tangala fogo yɛn paara yinrɛ cɛnsaga ki kanŋgɔlɔ ki ni fuun ki na. Ke yagawa pi mbaa mɛtɛrɛ nuŋgba wo bɔ tara ti na. ");
INSERT INTO dyi_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Leele pàa yiri ma siriŋgbangala ke wulo ki yɔnlɔ ki ni fuun ki na, naa ki yembinɛ li ni fuun li ni, konaa ki goto pilige ki ni fuun ki ni. Wa sila wulo wi woro ti kologo tɔni nuŋgba wo na. A pè siri jali, pe nii naa pe woro, ma paara yinrɛ cɛnsaga ki maga. ");
INSERT INTO dyi_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ma kara ti ta wa pe yɔn pe fa ta mberi ka, a Yawe Yɛnŋɛlɛ lì si nawa ŋgban pe ni ma tifɛlɛgɛ yama wa pe na. ");
INSERT INTO dyi_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","A pè sigi laga ki mɛgɛ taga naga yinri Kiburɔti Ataava, ko kɔrɔ wo yɛn jogofɛnnɛ fanra; katugu jogo wìla leele mbele yigi, pa pàa pe le wa ki laga ki na. ");
INSERT INTO dyi_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","A Izirayɛli woolo pè si yiri wa Kiburɔti Ataava laga ki ni ma saa cɛn wa Hazerɔti laga ki na. ");
INSERT INTO dyi_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moyisi wìla Kushi cɛnlɛ woolo jɔ wa pɔri. A Miriyamu naa Arɔn pe nɛɛ Moyisi wi puŋgo sɛnrɛ yuun ki pɔrɔgɔ ki kala na. ");
INSERT INTO dyi_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Pàa pye na yuun fɔ: «Moyisi wo nuŋgba Yawe Yɛnŋɛlɛ li ma sɛnrɛ le wi yɔn wi yo wi le? Woro fun li ma sɛnrɛ le we yɔn we yo.» A Yawe Yɛnŋɛlɛ lì sigi sɛnrɛ ti logo. ");
INSERT INTO dyi_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ma si yala, Moyisi wìla pye pɔw jɛŋgɛ, ma wɛ lere pyew wi na laga tara ti na. ");
INSERT INTO dyi_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Le ki yɔngɔlɔ nuŋgba ke ni, a Yawe Yɛnŋɛlɛ lì si Moyisi, naa Arɔn konaa Miriyamu pe yeri ma pe pye fɔ: «Ye yiri, ye taanrimɛ, ye kari wa filisaga paraga go ki ni.» A pe taanri pè si yiri ma kari. ");
INSERT INTO dyi_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","A Yawe Yɛnŋɛlɛ lì si tigi wa kambaaga titɔnlɔgɔ yerege ki ni, ma yere wa paraga go ki yɔn na, mɛɛ Arɔn naa Miriyamu pe yeri, a pe shyɛn pè si fulo wa li tanla. ");
INSERT INTO dyi_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","A lì si pe pye fɔ: «Yaa nuru na yeri jɛŋgɛ. Na na yɔn sɛnrɛ yofɔ wa ka pye laga ye sɔgɔwɔ, mi ŋa Yawe Yɛnŋɛlɛ, mi yaa na yɛɛ naga wi na yariyanga ni, nakoma mbaa para wi ni wɔɔnrɔ na. ");
INSERT INTO dyi_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ɛɛn fɔ, na tunmbyee Moyisi wo na, wo wogo ko woro ma. Wi yɛn tagawa ni wa na go woolo pe ni fuun pe sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mi maa para wi ni yɔn ni nari finligi. Mi mala yɛɛ naga wi na, kìla pye yomiyɛgɛlɛ ni; mi ŋa Yawe Yɛnŋɛlɛ, wi mala cɛnlɔmɔ pi yan gbɔgɔyi. Yiŋgi na yee si fyɛ, a ye silan tunmbyee Moyisi wi puŋgo sɛnrɛ yo?» ");
INSERT INTO dyi_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","A Yawe Yɛnŋɛlɛ lì si nawa ŋgban pe ni fɔ jɛŋgɛ, mɛɛ kari. ");
INSERT INTO dyi_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Naa kambaaga kìla kaa yiri wa paraga go ki go na ma kari, a Miriyamu wì suu yɛɛ yan yayɛnwɛ to wi na lagapyew maa filige pow paa para yɛn. Naa Arɔn wìla kaa kanŋga ma yɛgɛ wa wa Miriyamu wi yeri, a wì suu yan yayɛnwɛ pì to wi na. ");
INSERT INTO dyi_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Kona, a Arɔn wì si Moyisi wi pye fɔ: «Na tafɔ, ma yɛɛ yaga. Tijinliwɛ fu kala na wè pye, ma kapege ŋga pye, maga ka ti ki jɔlɔgɔ ki to we na. ");
INSERT INTO dyi_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","E! Mila ma yɛnri, we nɔsepyɔ sumboro wiga ka pye paa pyɔ ŋa wì ku wa wi nɔ lara, a pè suu se; a wi wire ti kanŋgɔlɔ nuŋgba jɔgɔ wi na wi sesanga wi ni.» ");
INSERT INTO dyi_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","A Moyisi wì si gbele ma Yawe Yɛnŋɛlɛ li yeri ma yo fɔ: «E! Yɛnŋɛlɛ, mila ma yɛnri, wi sagala.» ");
INSERT INTO dyi_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: «Ndɛɛ ki pye wi to wi cɛnrɛ surugu wa wi yɛgɛ sɔgɔwɔ ma fɛrɛ wa wi na, ki fɛrɛ ti se jɛn naa yigi fɔ sa gbɔn piliye kɔlɔshyɛn wi le? Ki kala na, yoo wɔ wa paara yinrɛ cɛnsaga ki ni piliye kɔlɔshyɛn ni. Ko puŋgo na, yoo le ye yɛɛ ni naa fɔnŋgɔ.» ");
INSERT INTO dyi_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","A pè si Miriyamu wi wɔ wa paara yinrɛ cɛnsaga ki ni fɔ ma saa gbɔn piliye kɔlɔshyɛn. Leele pe sila paara yinrɛ ti kɔlɔgi mbe kari, fɔ a pè saa Miriyamu wi le pe yɛɛ ni naa fɔnŋgɔ. ");
INSERT INTO dyi_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ko puŋgo na, a leele pè si yiri wa Hazerɔti laga ki ni, mɛɛ kari ma saa pe paara yinrɛ ti kan ma cɛn wa Paran gbinri wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Kona, a Yawe Yɛnŋɛlɛ lì si para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Nambala pele wɔ Izirayɛli woolo teele pe ni, cɛnlɛ nuŋgba nuŋgba pyew, naŋa nuŋgba mbe yiri wa, ma pe tun pe sa Kana tara ti kagala ke yewe mbe ke jɛn, to nda mi yɛn na kaan yoro Izirayɛli woolo ye yeri we.» ");
INSERT INTO dyi_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ma pe ta wa Paran gbinri wi ni, a Moyisi wì si nambala pele wɔ ma pe tun paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo wi kan we. Izirayɛli woolo teele poro pele la wɛlɛ. ");
INSERT INTO dyi_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Mbele pàa wɔ pe mɛrɛ ti nda: Urubɛn cɛnlɛ li ni, Zakuri pinambyɔ Shamuwa wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeyɔn cɛnlɛ li ni, Hɔri pinambyɔ Shafati wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Zhuda cɛnlɛ li ni, Yefune pinambyɔ Kalɛbu wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isakari cɛnlɛ li ni, Zhozɛfu pinambyɔ Igali wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efirayimu cɛnlɛ li ni, Nuni pinambyɔ Hoze wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Bɛnzhamɛ cɛnlɛ li ni, Arafu pinambyɔ Paliti wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zabulɔn cɛnlɛ li ni, Sodi pinambyɔ Gadiyɛli wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Zhozɛfu pinambyɔ Manase wi cɛnlɛ li ni, Susi pinambyɔ Gadi wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan cɛnlɛ li ni, Gemali pinambyɔ Amiyɛli wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asɛri cɛnlɛ li ni, Mikayɛli pinambyɔ Seturi wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nɛfitali cɛnlɛ li ni, Vofisi pinambyɔ Nabi wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gadi cɛnlɛ li ni, Maki pinambyɔ Gewuwɛli wo pàa wɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ki nambala mbele pe mɛrɛ tì yɔnlɔgɔ, poro wɛlɛ Moyisi wìla wɔ ma tun pe sa tara ti yanri peri wele, peri kagala ke jɛn. A Moyisi wì si Nuni pinambyɔ Hoze wi mɛgɛ taga naa yinri Zhozuwe. ");
INSERT INTO dyi_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Naa Moyisi wìla pe tun pe sa tara ti kagala ke yewe mbe ke jɛn sanga ŋa ni, wìla pe pye fɔ: «Ye toro wa Negɛvu tara ti ni, ko puŋgo na, ye kari wa yanwira tara ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ye tara ti wele, yeri cɛnlɔmɔ pi jɛn. Leele pe pɛɛlɛ pe yɛn ma cɛn wa, na kaa pye pe yɛn fanŋga ni nakoma pe woro fanŋga ni, na kaa pye pe lɛgɛ nakoma pe woro ma lɛgɛ. ");
INSERT INTO dyi_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Pe yɛn ma cɛn tara nda ni, yeri cɛnlɔmɔ pi wele na kaa pye pi yɛn ma yɔn nakoma pi woro ma yɔn. Ye pe cara ti wele na kaa pye pe malaga sigemboro kankan mari maga nakoma peri yaga ma. ");
INSERT INTO dyi_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ye tara ti wele na kaa pye ti yɛn ma tanla nakoma ti woro ma tanla, na kaa pye tire yɛn wa nakoma tire woro wa. Ye kotogo le ye yɛɛ ni, ye pan ki tara ti tige pire ta ni.» Kìla yala ki sanga wi ni ɛrɛzɛn pire ti koŋgbannda tì gbɔn. ");
INSERT INTO dyi_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Kì kaa pye ma, a ki nambala pè si saa tara ti yanri mari kagala ke wele, maga lɛ le Zɛn gbinri wi na fɔ ma saa gbɔn wa Erehɔbu laga ki na, wa Lebo Hamati ca ki tanla. ");
INSERT INTO dyi_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Pàa toro wa Negɛvu tara ti ni, ma saa gbɔn wa Eburɔn ca ki na, wa laga ŋga Ahima sege woolo, naa Sheshayi sege woolo konaa Talimayi sege woolo pàa pye ma cɛn we, poro pàa pye Anaki setirige piile wele. Eburɔn ca pàa ki kan yɛlɛ kɔlɔshyɛn làa toro, a pè si jɛn ma Ezhipiti tara cagbɔgɔ ŋga pàa pye na yinri Zowan ki kan. ");
INSERT INTO dyi_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Naa pàa ka saa gbɔn wa Ɛshikɔli gbunlundɛgɛ ki ni, a pè si ɛrɛzɛn tirige njege ka kɔn ki pire ti shashaga ki ni wa ki na. Kìla pye ma nugu jɛŋgɛ fɔ a leele shyɛn ki lɛ kanŋgaga na pe pajoro ti na. Pàa girenadi tige pire naa figiye tige pire ta lɛ ma kari ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Malɛ le kona, a pè sigi laga ki mɛgɛ taga naga yinri Ɛshikɔli gbunlundɛgɛ. Ɛshikɔli ko kɔrɔ wo yɛn shashaga, mbe ta mbaa nawa tuun ɛrɛzɛn pire shashaga ŋga Izirayɛli woolo pàa kɔn wa ki na. ");
INSERT INTO dyi_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Piliye nafa shyɛn toroŋgɔlɔ, a pitunmbolo pè si sɔngɔrɔ ma yiri wa tara ti welesaga ma pan. ");
INSERT INTO dyi_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Pàa pan Moyisi, naa Arɔn konaa Izirayɛli gbogolomɔ woolo pe ni fuun pe kɔrɔgɔ wa Kadɛshi laga ki na, wa Paran gbinri wi ni. Pàa pe yirisaga kagala ke yɛgɛ yo pe kan, mɛɛ tara ti tire pire ti naga pe na. ");
INSERT INTO dyi_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Sɛnrɛ nda pàa yo Moyisi wi kan ti nda: «Mà we torogo tara nda ni wè yiri wa ma pan. Kaselege kona, nɔnɔ naa sɛnrɛgɛ ti yɛn wa ki tara ti ni fɔ na fuun. Ki tara ti tire pire taa nda. ");
INSERT INTO dyi_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ɛɛn fɔ, leele mbele pe yɛn ma cɛn wa ki tara ti ni pe yɛn fanŋga ni. Pe cara ti yɛn ma tugbɔlɔ, a pè malaga sigemboro wa mari maga. Wè yɛrɛ nandɔnlɔgɔ Anaki setirige piile pe yan wa. ");
INSERT INTO dyi_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalɛki setirige piile poro yɛn ma cɛn wa Negɛvu tara ti ni. Hɛti cɛnlɛ woolo, naa Zhebusi cɛnlɛ woolo konaa Amɔri cɛnlɛ woolo poro yɛn ma cɛn wa yanwira tara ti ni. Kana tara woolo poro yɛn ma cɛn wa Mediterane kɔgɔje yɔn ki na konaa wa Zhuridɛn gbunlundɛgɛ ki ni fuun ki ni.» ");
INSERT INTO dyi_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kona, leele mbele pàa pye na sɛnŋgbanra yuun Moyisi wi na, a Kalɛbu wì si pe pye ma yo pe pyeri, ma sho fɔ: «Yoo kari we sa malaga gbɔn ki tara woolo pe ni weri shɔ, ti pye we woro; katugu we yaa ya pe ni.» ");
INSERT INTO dyi_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ɛɛn fɔ, a Kalɛbu wi pinlɛyɛɛnlɛ pe nɛɛ yuun fɔ: «Ki fanŋga woro we ni we sa to ki leele mbele pe na, katugu pe yɛn fanŋga ni ma wɛ we na.» ");
INSERT INTO dyi_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ko puŋgo na, tara nda pàa saa ti kagala ke yewe mbe ke jɛn, a pe nɛɛ sɛnpere yuun ti kanŋgɔlɔ Izirayɛli woolo pe yɛgɛ na, na yuun fɔ: «Tara nda wè saa ti kagala ke yewe mbe ke jɛn, ti maa leele mbele pe yɛn ma cɛn wa ti ni pe kuun. Leele mbele wè yan wa, poro wo na, pe ni fuun pe yɛn ma tɔnlɔndɔnlɔ. ");
INSERT INTO dyi_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Wè yɛrɛ letitɔɔnrɔ yan wa, Anaki setirige piile wele. Pa pè yiri wa letugbɔɔrɔ ti cɛnlɛ li ni. Wè we yɛɛ yan paa kambɛɛrɛ yɛn le pe tanla. A poro fun paa we yaan paa kambɛɛrɛ yɛn pe yɛgɛ na.» ");
INSERT INTO dyi_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Kona, a leele pe ni fuun pè si yiri na gbele ŋgbanga na jɔrɔgi fɔ ma saa laga ki laga. ");
INSERT INTO dyi_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Izirayɛli woolo pe ni fuun pàa pye na kɔngɔri Moyisi naa Arɔn pe na. A gbogolomɔ woolo pe ni fuun pè si pe pye fɔ: «Ndɛɛ ki pye wàa ku wa Ezhipiti tara, nakoma wa gbinri wi ni, ko mbe ja mbɔnrɔ! ");
INSERT INTO dyi_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mɛlɛ Yawe Yɛnŋɛlɛ li nɛɛ paan we ni laga ki tara nda ti ni, mbe pan mbe we kan pe we gbo tokobi ni. We juguye pe yaa we jɛɛlɛ naa we piile pe koli mbe kari pe ni. Na waga sɔngɔrɔ wa Ezhipiti tara ko yaa mbɔnrɔ we na.» ");
INSERT INTO dyi_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Kona, a pè sigi yo pe yɛɛ kan ma yo fɔ: «Ye ti we lere wa tɛgɛ to we yɛɛ go na, we sɔngɔrɔ wa Ezhipiti tara.» ");
INSERT INTO dyi_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","A Moyisi naa Arɔn pè si to ma pe yɛrɛ ti jiile wa tara Izirayɛli gbogolomɔ woolo pe ni fuun pe yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Nuni pinambyɔ Zhozuwe wo naa Yefune pinambyɔ Kalɛbu, poro mbele pàa pye tara ti kagala ke yewefɛnnɛ pe ni ja, a poro si pe yɛɛra yaripɔrɔ ti walagi naŋgbanwa pi kala na, ");
INSERT INTO dyi_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","mɛɛ Izirayɛli gbogolomɔ woolo pe ni fuun pe pye fɔ: «Tara nda wè saa ti kagala ke yewe mberi jɛn, ti yɛn ma yɔn fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Na kaa pye we kala li Yawe Yɛnŋɛlɛ li ndanla, wi yaa kari we ni, wa ki tara ti ni, mberi kan we yeri, to nda nɔnɔ naa sɛnrɛgɛ ti yɛn wa na fuun we. ");
INSERT INTO dyi_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ɛɛn fɔ, yaga ka yiri mbe je Yawe Yɛnŋɛlɛ li na, yaga si ka fyɛ ki tara woolo pe yɛgɛ. Pe se we malaga bɔ, katugu pe go sigefɔ wi woro pe ni, ma si yala Yawe Yɛnŋɛlɛ li yɛn we ni. Yaga ka fyɛ!» ");
INSERT INTO dyi_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Gbogolomɔ woolo pe ni fuun pàa pye na yuun fɔ pe pe wa sinndɛɛrɛ ni pe pe gbo. Ɛɛn fɔ, a Yawe Yɛnŋɛlɛ li gbɔgɔwɔ yanwa pì si pan wa filisaga paraga go ki na Izirayɛli woolo pe ni fuun pe yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yawe Yɛnŋɛlɛ làa Moyisi wi pye fɔ: «Ki leele mbele pe yaa lanla mɛgɛ ki tifaga fɔ sa gbɔn wagati wiwiin? Pe yaa je mbe yo pe se taga na na fɔ sa gbɔn wagati wiwiin? Ali maga ta mì kafɔnŋgɔlɔ lɛgɛrɛ pye mala fanŋga ki naga wa pe sɔgɔwɔ o! ");
INSERT INTO dyi_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mi yaa tifɛlɛgɛ yama wa pe na mbe pe gbo mbe pe kɔ. Ko puŋgo na, mi yaa cɛnlɛ la yirige wa ma ni, li woolo pe yaa lɛgɛ mbe pye fanŋga ni mbe wɛ Izirayɛli woolo pe na.» ");
INSERT INTO dyi_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","A Moyisi wì si Yawe Yɛnŋɛlɛ li yɔn sogo ma yo fɔ: «Ezhipiti tara woolo pège jɛn ma yo mboro màga leele mbele pe yirige ma pe wɔ wa pe tara ma yawa pi na. ");
INSERT INTO dyi_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","A pège wogo ki yɛgɛ yo fun ki tara nda we yɛn laga ti woolo pe kan. Pège jɛn ma yo mboro ŋa Yawe Yɛnŋɛlɛ, woro mbele ma woolo, ma yɛn laga we sɔgɔwɔ, fɔ mboro ŋa Yawe Yɛnŋɛlɛ ma maa ma yɛɛ nari we na gbɔgɔyi. Pège logo ma yo ma kambaaga ki ma pye ma yere wa we go na, na we go singi; pège logo fun fɔ yɔnlɔ na, ma maa we yɛgɛ sinni kambaaga titɔnlɔgɔ yerege ka ni, yembinɛ na we yɛgɛ sinni kasɔn titɔnlɔgɔ yerege ka ni. ");
INSERT INTO dyi_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Koni, na maga ki leele mbele pe ni fuun pe gbo yɔnlɔ nuŋgba, kagala ŋgele mà pye, cɛngɛlɛ ŋgele kàa ke sɛnrɛ ti logo, ke yaa la yuun fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹Yawe Yɛnŋɛlɛ li saa ya mbe kari ki leele mbele pe ni wa tara nda làa yɔn fɔlɔ lɛ ma wugu mbe kan pe yeri ti ni. Ko kì ti lì saa pe gbo wa gbinri wi ni.› ");
INSERT INTO dyi_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Koni, Yawe Yɛnŋɛlɛ, mila ma yɛnri, maga yaga, mɔɔ yawa pi naga ma fanŋga ki ni fuun ki ni, paa yɛgɛ ŋga na màa ki yo maga filige we kan fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‹Mi ŋa Yawe Yɛnŋɛlɛ, mila la nawa ŋgbanni jaga jaga, na kagbaraga kì gbɔgɔ, mi ma leele pe kajɔɔgɔ naa pe kapere ti kala yaga pe na. Ɛɛn fɔ, mila tanga kan kapege pyefɔ wi yeri. Mi ma teele pe kapege ki fɔgɔ tɔn pe piile pe na fɔ sa gbɔn pe setirige piile pe yirisaga taanri wogo naa tijɛrɛ wogo ki woolo pe na.› ");
INSERT INTO dyi_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Yawe Yɛnŋɛlɛ, mila ma yɛnri, ma ki leele mbele pe kapere ti kala yaga pe na mbe yala ma kajɛŋgɛ pyewe gbɔɔ pi ni, paa yɛgɛ ŋga na ma yɛn na pe kapere ti kala yari pe na, maga lɛ pè yiri wa Ezhipiti tara we.» ");
INSERT INTO dyi_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","A Yawe Yɛnŋɛlɛ lì sho fɔ: «Mì pe kapere ti kala yaga pe na ma yala ma yɛnrɛgɛ ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Konaa ki ni fuun, mbege ta kaselege mi yɛn Yawe Yɛnŋɛlɛ na yinwege wolo, tara ti ni fuun ti yɛn ma yin na gbɔgɔwɔ yanwa pi ni. ");
INSERT INTO dyi_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Ki leele mbele pànla gbɔgɔwɔ yanwa pi yan, po naa kafɔnŋgɔlɔ tugbɔŋgɔlɔ ŋgele mì pye wa Ezhipiti tara konaa wa gbinri wi ni ke ni; pànla wa ma wele ma saa ta yɔnlɔ kɛ, pee logo na yeri. ");
INSERT INTO dyi_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Ki leele wo wa kpɛ se tara nda mì yɔn fɔlɔ kɔn ma wugu mbe kan pe tɛlɛye pe yeri ti yan yɛnlɛ ni. Poro mbele fuun pànla tifaga, wo wa kpɛ se ye wa ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ɛɛn fɔ, na tunmbyee Kalɛbu wo na, wi jatere wìla pye wi yɛ. Wìla logo na yeri kagala ke ni fuun ni. Ki kala na, mi yaa ti wi ye wa tara nda wì saa ti kagala ke yewe mbe ke jɛn ti ni, wi setirige piile pe yaa kari ta, ti pye pe kɔrɔgɔ. ");
INSERT INTO dyi_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Kì kaa pye Amalɛki setirige piile naa Kana tara woolo pe yɛn ma cɛn wa gbunlundɛgɛ ki ni, goto ye sɔngɔrɔ ye kari wa gbinri wi ni, wa Kɔgɔje yɛɛn wi yeri.» ");
INSERT INTO dyi_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","A Yawe Yɛnŋɛlɛ lì si para Moyisi naa Arɔn pe ni naa ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Ki gbogolomɔ woolo mbele yɛɛn pe yɛn ma pe. Mi yaa pe yaga paa kɔngɔri na na fɔ sa gbɔn wagati wiwiin? Katugu Izirayɛli woolo pe kɔngɔrimɔ mba paa kɔngɔri na na mùu logo. ");
INSERT INTO dyi_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ki yo pe kan fɔ Yawe Yɛnŋɛlɛ lo lì yo ma fɔ: ‹Mi ŋa Yɛnŋɛlɛ na yinwege wolo na mɛgɛ ki na, mi yaa jɔlɔgɔ wa ye na mbe yala kɔngɔrimɔ mba yè kɔngɔri mì logo pi ni.› ");
INSERT INTO dyi_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ye yaa toori mbe ku laga ki gbinri ŋa wi ni, yoro mbele fuun pàa ye jiri maga lɛ yoro mbele yè ta yɛlɛ nafa nafa ye na konaa ye yɛgɛ fɛnnɛ pe ni, katugu yè kɔngɔri na na. ");
INSERT INTO dyi_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Tara nda mìla yɔn fɔlɔ kɔn ma wugu ma yo mi yaa ti ye sa cɛn wa ti ni, ye se ye wa ti ni. Kaawɔ Yefune pinambyɔ Kalɛbu naa Nuni pinambyɔ Zhozuwe poro pe yaa ye wa ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ɛɛn fɔ, ye piile mbele yè yo fɔ ye juguye pe yaa pe koli, mi yaa pe yɛgɛ sin mbe sa ye pe ni wa tara nda yè je ti na ti ni, peri jɛn. ");
INSERT INTO dyi_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Yoro wo na, ye yaa toori mbe ku laga gbinri wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ye piile pe yaa la yanri la toro pe yaayoro ti ni laga gbinri wi ni fɔ sa gbɔn yɛlɛ nafa shyɛn. Ye mbalogowo pi jɔlɔgɔ ki yaa to pe na, fɔ ye ni fuun ye sa ku ye kɔ laga gbinri wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Pilige nafa shyɛn yè pye ma tara ti yanri mari kagala ke yewe mbe ke jɛn, ki pyelɔmɔ nuŋgba pi na fun, ye kapere ti jɔlɔgɔ ki yaa to ye na fɔ sa gbɔn yɛlɛ nafa shyɛn. Piliye nafa shyɛn yi pilige nuŋgba nuŋgba pyew ki yaa pye yɛlɛ nuŋgba. Ki ka pye ma, mbe yiri mbe je na na ki ma pye yɛgɛ ŋga na, ye yaa ki jɛn. ");
INSERT INTO dyi_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mi ŋa Yawe Yɛnŋɛlɛ, muwi mì yo ma. Ee, ki gbogolomɔ woolo mbele pè yiri ma je na na, ma gbogolo na mɛgɛ ni, pa mi yaa jɔlɔgɔ wa pe na yɛɛn. Pe yaa kɔ wa gbinri wi ni, pa pe yaa ku wa.» ");
INSERT INTO dyi_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Nambala mbele Moyisi wìla tun pe sa tara ti kagala ke yewe mbe ke jɛn, pe sɔngɔrɔsaga, pàa sɛnpere yo tara ti wogo ki na, ma Izirayɛli gbogolomɔ woolo pe ni fuun pe kan a paa kɔngɔri Moyisi wi na. ");
INSERT INTO dyi_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ki leele mbele pàa sɛnpere ti yo tara ti wogo ki na, yambewe la pe gbo Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Leele mbele pàa saa tara ti kagala ke yewe mbe ke jɛn, Nuni pinambyɔ Zhozuwe wo naa Yefune pinambyɔ Kalɛbu wi ni poro pàa koro go na pe ni. ");
INSERT INTO dyi_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Kona, a Moyisi wì si sɛnrɛ nda Yawe Yɛnŋɛlɛ làa yo wi kan ti yɛgɛ yo Izirayɛli woolo pe kan, a kì si pe nawa pi piri pe na fɔ jɛŋgɛ. ");
INSERT INTO dyi_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ki goto, a pè si yiri faa pinliwɛ pi ni, mɛɛ kari wa yanwira tara ti yeri, nɛɛ yuun fɔ: «Wè kapege pye, ɛɛn fɔ koni, we yaa kari wa laga ŋga Yawe Yɛnŋɛlɛ làa ki sɛnrɛ yo ki ni.» ");
INSERT INTO dyi_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","A Moyisi wì si pe pye fɔ: «Yiŋgi na yee si yere Yawe Yɛnŋɛlɛ li sɛnyoro ti na? Ye yɛn na kee ŋga na, ki se yɔn. ");
INSERT INTO dyi_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Yaga ka kari wa, katugu Yawe Yɛnŋɛlɛ li woro ye ni. Yaga ka sa ye yɛɛ kan ye juguye pe yeri pe ye gbo. ");
INSERT INTO dyi_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ye yaa sa Amalɛki setirige piile naa Kana tara fɛnnɛ pe ta wa ye yɛgɛ. Ye yaa ti pe ye gbo tokobi ni. Na yè kaa je Yawe Yɛnŋɛlɛ li na, li se pye ye ni.» ");
INSERT INTO dyi_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","A pè si nuŋgboŋgbanla pye ma lugu ma kari wa yanwira tara ti yeri. Ɛɛn fɔ, Moyisi wo la koro wa paara yinrɛ cɛnsaga ki ni ma pinlɛ Yawe Yɛnŋɛlɛ li yɔn finliwɛ kɛsu wi ni. ");
INSERT INTO dyi_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Kona Amalɛki setirige piile naa Kana tara fɛnnɛ mbele pàa pye ma cɛn wa yanwira tara ti ni, pè si tigi nɛɛ pe gbɔɔn na pe kuun, mɛɛ pe purɔ fɔ ma saa gbɔn wa Ɔrima ca ki na. ");
INSERT INTO dyi_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Ki yo Izirayɛli woolo pe kan fɔ: ‹Tara nda mi yaa kan ye yeri ye sa cɛn wa, na yaga ka sa ye wa ti ni, ");
INSERT INTO dyi_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mbaa jaa mbe saara nda pe ma wɔ mberi sogo kasɔn ni ta wɔ mi ŋa Yawe Yɛnŋɛlɛ na yeri, nakoma saraga sogowogo, nakoma saraga ŋga pe ma wɔ mbe yɔn fɔlɔ tɔn, nakoma ye nayinmɛ yarikanga, nakoma saraga ŋga pe ma wɔ ye shɛrɛgɛ fɛti wa na, ye yaa kaa ki saara ti woo nɛrɛ ni, nakoma simbaala naa sikaala ni. Ki saara ti nuwɔ taan pi yaa pye mbanla ndanla. ");
INSERT INTO dyi_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Lere ŋa ka pan wi saraga ni mi Yawe Yɛnŋɛlɛ na kan, wi daga mbe muwɛ culo taanri taga wa, pi pye saraga, mba pè sinmɛ litiri shyɛn pinlɛ pi ni, ");
INSERT INTO dyi_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","naa duvɛn saraga ŋga pe ma wo wi litiri shyɛn ni. Ki muwɛ saraga naa ki duvɛn saraga to yaa taga sumbyɔ yirifɔnŋɔ ŋa pe ma pye saraga sogowogo nakoma nayinmɛ saraga wo na. ");
INSERT INTO dyi_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Na kaa pye simbapɔlɔ wi, ye muwɛ culo kɔgɔlɔni taga wa, pi pye saraga, mba pè sinmɛ litiri shyɛn naa kɔngɔ pinlɛ pi ni, ");
INSERT INTO dyi_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","naa duvɛn saraga ŋga pe ma wo wi litiri shyɛn naa kɔngɔ ni. Ti yaa pye saara nda ti wirige nuwɔ taan pi yɛn ma mi ŋa Yawe Yɛnŋɛlɛ na ndanla. ");
INSERT INTO dyi_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Na kaa pye napɔlɔ yirifɔnŋɔ ye yaa pan mbe wɔ mi ŋa Yawe Yɛnŋɛlɛ na yeri, mboo pye saraga sogowogo, nakoma saraga ŋga pe ma wɔ mbe yɔn fɔlɔ tɔn, nakoma ŋga pe ma wɔ nayinmɛ saraga, ");
INSERT INTO dyi_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ye muwɛ culo kɔlɔjɛrɛ taga wa napɔlɔ yirifɔnŋɔ wi na, pi pye saraga, mba pè sinmɛ litiri tijɛrɛ pinlɛ pi ni, ");
INSERT INTO dyi_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","naa duvɛn saraga ŋga pe ma wo wi litiri tijɛrɛ ni. Ti yɛn saara nda ti ma sogo kasɔn ni, ti nuwɔ taan pi yɛn ma mi ŋa Yawe Yɛnŋɛlɛ na ndanla.› ");
INSERT INTO dyi_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","«Pa ye daga mbaa napɔlɔ nuŋgba nuŋgba pyew, naa simbapɔlɔ nuŋgba nuŋgba pyew, konaa sumbyɔ nakoma sugbɔ yirifɔnŋɔ nuŋgba nuŋgba pyew pe woo saara yɛɛn. ");
INSERT INTO dyi_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Yaayoro nda fuun ye yaa wɔ saraga, ye daga mbe muwɛ saara naa duvɛn saara nda ti naganaga ti taga wa ti nuŋgba nuŋgba pyew ti na. ");
INSERT INTO dyi_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Izirayɛli tara pyɔ pyew wi yaa la tanri mbaa yala ki sɛnrɛ nda ti ni, na wi kaa saara nda pe ma sogo kasɔn ni ta woo na yeri we, to nda ti nuwɔ taan pi yɛn ma mi ŋa Yawe Yɛnŋɛlɛ na ndanla we. ");
INSERT INTO dyi_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nambanmbala mbele pe yɛn ma cɛn laga ye sɔgɔwɔ, nakoma mbele pe yɛn cɛnfɛnnɛ laga ye sɔgɔwɔ ye setirige piile yirisaga pyew ki ni, pe yaa la tanri ki sɛnrɛ nuŋgba ti na fun paa ye yɛn, na pe kaa jaa mbe saara nda pe ma wɔ ma sogo kasɔn ni ta wɔ na yeri we, to nda ti nuwɔ taan pi yɛn ma mi ŋa Yawe Yɛnŋɛlɛ na ndanla we. ");
INSERT INTO dyi_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ki kondɛgɛlɛ li nuŋgba li yaa pye leele pe gbogolɔmɔ pi ni fuun pi woo, yoro Izirayɛli woolo naa nambanmbala mbele pe yɛn ma cɛn laga ye sɔgɔwɔ, ye ni fuun wolo li. Ki kondɛgɛlɛ li yaa pye kɔsaga fu ye setiriye piile mbele pe yaa ka yiri ye puŋgo na pe wolo. Yoro naa nambanmbala pe ni ye yɛn ja mi ŋa Yawe Yɛnŋɛlɛ na yɛgɛ na. ");
INSERT INTO dyi_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Lasiri koŋgolo nuŋgba naa kakɔnndɛgɛŋgɛlɛ nuŋgba koro ke yaa pye yoro naa nambanmbala mbele pe yɛn ma cɛn laga ye sɔgɔwɔ ye go na.» ");
INSERT INTO dyi_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yawe Yɛnŋɛlɛ làa para Moyisi wi ni ma yo fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Ki yo Izirayɛli woolo pe kan fɔ: ‹Mila shee ye ni tara nda ni, na yaga ka sa ye wa ti ni, ");
INSERT INTO dyi_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","mbege tara ti yarilire ta ka, ye keli ye yarikanra wɔ wa ti ni mberi kan mi ŋa Yawe Yɛnŋɛlɛ na yeri. ");
INSERT INTO dyi_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Na yaga ka ye muwɛ koŋgbanmba pa gbɔn mboo pye buru, koŋgbanŋa ŋa yè fɔ ye keli yoo pye yarikanga mboo kan mi ŋa Yawe Yɛnŋɛlɛ na yeri paa yɛgɛ ŋga na bile wi sunŋgɔlɔ wa wi sunsaga, ye ma keli ma wa wɔ wa wi ni maa kan na yeri we. ");
INSERT INTO dyi_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ki pyelɔmɔ nuŋgba pi na, buru koŋgbanŋa ŋa ye yaa ka fɔ, ye keli yoo pye yarikanga mboo kan mi ŋa Yawe Yɛnŋɛlɛ na yeri. Ki ŋgasele li yaa ka pye ye setiriye piile mbele pe yaa ka yiri puŋgo na pe wolo.› » ");
INSERT INTO dyi_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«Ŋgasegele ŋgele fuun mi Yawe Yɛnŋɛlɛ mì kan Moyisi wi yeri, na yaga wa mbe la mbe la jɔgɔ, na ye sigi siligi, ");
INSERT INTO dyi_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ko kɔrɔ wo yɛn ŋga fuun mì yo Moyisi wi kan a wì yo ye kan, maga lɛ pilige ŋga ni mi ŋa Yawe Yɛnŋɛlɛ mìla ŋgasegele ke kan ye yeri fɔ mbe saga wa ye setiriye piile mbele pe yaa ka yiri puŋgo na pe na, ");
INSERT INTO dyi_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","na kaa pye leele pe gbogolomɔ pì kapege ki pye pe sigi siligi, kona leele pe gbogolomɔ pi ni fuun pi yaa napɔlɔ yirifɔnŋɔ wɔ na yeri mboo pye saraga sogowogo, ŋga ki nuwɔ taan pi yɛn ma mi ŋa Yawe Yɛnŋɛlɛ na ndanla. Pe yaa muwɛ saraga naa duvɛn saraga ŋga pe ma wo ti taga wa ki na, mbe yala ki kakɔnndɛgɛŋgɛlɛ ke ni. Pe yaa sikapɔlɔ wɔ saraga mbe pe kapere ti kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Ko puŋgo na, saraga wɔfɔ wi yaa kapyege ŋga ki ma pye mbe kapere kala yagawa ja ki pye Izirayɛli gbogolomɔ woolo pe ni fuun pe kan. Pa pe yaa kapere kala yagawa ta; katugu ki kapege pège pye pe sigi siligi. Kona, pe yaa pan saara ni mbe saraga ŋga pe ma wɔ mbege sogo kasɔn ni ki wɔ mi ŋa Yawe Yɛnŋɛlɛ na yeri, konaa mbe ŋga pe ma wɔ mbe kapere kala yagawa ja ki wɔ kapege ŋga pè pye pe sigi siligi ki kala na. ");
INSERT INTO dyi_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Izirayɛli gbogolomɔ woolo pe ni fuun pe kapere ti yaa kala yaga pe na, naa nambanmbala mbele pe yɛn ma cɛn wa pe sɔgɔwɔ pe woro ti ni, katugu leele pe ni fuun pè kapege ki pye pe sigi siligi. ");
INSERT INTO dyi_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«Na kaa pye lere nuŋgba wì kapege ki pye wi sigi siligi, wi yaa sugbɔ yirifɔnŋɔ ŋa wì ta yɛlɛ nuŋgba wa wɔ saraga mbe kapere kala yagawa ja. ");
INSERT INTO dyi_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Saraga wɔfɔ wi yaa kapere ti kala yagawa ja kapyege ki pye lere ŋa wì kapege ki pye wi na Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. Kapere ti kala yagawa kapyege ki ka ka pye mbe kɔ, kona ki lerefɔ wi kapere ti yaa kala yaga wi na. ");
INSERT INTO dyi_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Na lere wa ka kapege pye wi sigi siligi, lasiri konɔ nuŋgba lo li yaa pye yoro Izirayɛli tara piile naa nambannjɛɛnlɛ mbele pe yɛn laga ye sɔgɔwɔ ye go na. ");
INSERT INTO dyi_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","«Ɛɛn fɔ, na lere wa kaga siligi mbe kapege pye, wi yɛn Izirayɛli tara pyɔ wo wa o, wi yɛn nambanŋa o, kona mi ŋa Yawe Yɛnŋɛlɛ wìlan tɛgɛlɛ. Wi daga poo wɔ wa wi woolo pe sɔgɔwɔ; ");
INSERT INTO dyi_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","katugu mi ŋa Yawe Yɛnŋɛlɛ wìlan sɛnrɛ ti tifaga mala ŋgasele li jɔgɔ. Wi daga poo wɔ wa wi woolo pe sɔgɔwɔ. Wi yaa wi kapege ki go kala li lɛ. ");
INSERT INTO dyi_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","«Ma Izirayɛli woolo pe ta wa gbinri wi ni, pilige ka, a pè si saa naŋa wa yan wila kanŋgirɛ jaa cɛnpilige ki ni. ");
INSERT INTO dyi_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Leele mbele pàa saa wi yan wa kanŋgirɛ jasaga, pè si pan wi ni Moyisi naa Arɔn konaa Izirayɛli gbogolomɔ woolo pe ni fuun pe yɛgɛ sɔgɔwɔ. ");
INSERT INTO dyi_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","A pè si saa wi tɛgɛ laga ka na naa kɔrɔsi, katugu kala la sila tɛgɛ jɔlɔgɔ ŋga pe mbaa wa wi na ki wogo na. ");
INSERT INTO dyi_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","A Yawe Yɛnŋɛlɛ lì si Moyisi wi pye fɔ: ‹Ki naŋa wi daga poo gbo. Izirayɛli gbogolomɔ woolo pe ni fuun pe yaa wi wa sinndɛɛrɛ ni mboo gbo wa paara yinrɛ cɛnsaga ki puŋgo na.› » ");
INSERT INTO dyi_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Kona, a Izirayɛli gbogolomɔ woolo pe ni fuun pè suu yirige maa wɔ wa paara yinrɛ cɛnsaga ki ni, mɛɛ saa wi wa sinndɛɛrɛ ni fɔ a wì saa ku, paa yɛgɛ ŋga na Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan we. ");
INSERT INTO dyi_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yawe Yɛnŋɛlɛ làa ki yo Moyisi wi kan fɔ: ");
INSERT INTO dyi_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Ki yo Izirayɛli woolo pe kan fɔ poro naa pe setirige piile mbele pe yaa ka yiri pe puŋgo na pe ni, pe yaa kaa fereyaara pusayi yoli pe yaripɔrɔ yɔnrɔ ti na; pe yaa jese pinlɛ fereyaara pusayi nuŋgba nuŋgba pyew ti ni. ");
INSERT INTO dyi_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Kona, na yaga ki fereyaara pusayi ti yan yaripɔrɔ yɔnrɔ ti na sanga ŋa ni, ye yaa nawa to mi ŋa Yawe Yɛnŋɛlɛ na ŋgasegele ke ni fuun ke na mbaa tanri ke na. Pa kona ye se wa mbe la ke na, mbaa tanri ye nandanwa kagala koro naa ye yɛnlɛ kagala ke na, koro ŋgele ke ma ti ye maa nanjara piin we. ");
INSERT INTO dyi_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Pa kona, ye yaa la nawa tuun na ŋgasegele ke ni fuun ke na mbaa tanri ke na. Pa ye yaa pye kpoyi mi ŋa ye Yɛnŋɛlɛ na kan. ");
INSERT INTO dyi_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le. Mì ye yirige ma ye wɔ wa Ezhipiti tara mbe pye ye Yɛnŋɛlɛ le. Ee, muwi mi yɛn Yawe Yɛnŋɛlɛ, ye Yɛnŋɛlɛ le.» ");
INSERT INTO dyi_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Yizehari pinambyɔ Kore ŋa wìla pye Levi setirige pyɔ, ma yiri wa Kehati sege ki ni, wìla yɔn le Urubɛn setirige piile taanri ni, poro la wɛlɛ Eliyabu pinambiile Datan naa Abiramu, konaa Pelɛti pinambyɔ Ɔni. ");
INSERT INTO dyi_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","A pè si yiri ma je Moyisi wi na, poro naa Izirayɛli woolo nambala cɛnmɛ shyɛn naa nafa shyɛn ma yiri kɛ (250) ni. Pàa pye Izirayɛli gbogolomɔ woolo pe teele poro pele, mbele pàa pye na yinri na pe kaa finliwɛ piin we. A pè pe mɛgɛ jɛn. ");
INSERT INTO dyi_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","A pè si gbogolo Moyisi naa Arɔn pe mɛgɛ ni, mɛɛ pe pye fɔ: «Ye wogo kì toro yogo na koni! Izirayɛli gbogolomɔ woolo pe ni fuun pe yɛn kpoyi Yawe Yɛnŋɛlɛ li yɛgɛ na, li si yɛn ma cɛn laga we ni fuun we sɔgɔwɔ. Mɛlɛ, a yoro nɛɛ ye yɛɛ jate mbe cɛn Yawe Yɛnŋɛlɛ li woolo pe go na?» ");
INSERT INTO dyi_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Naa Moyisi wìla kaa ki sɛnrɛ ti logo, a wì si to maa yɛgɛ ki jiile wa tara. ");
INSERT INTO dyi_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ko puŋgo na, a wì si Kore naa wi pinlɛyɛɛnlɛ pe pye fɔ: «Goto pinliwɛ ni, lere ŋa wi yɛn Yawe Yɛnŋɛlɛ li woo, ma tɛgɛ wi yɛ li kan, mbe ya mbe pan li yɛgɛ sɔgɔwɔ, li yaa wi naga we na. Lere ŋa Yawe Yɛnŋɛlɛ li yaa ka wɔ, li yaa ti wo mbe fulo wa li tanla. ");
INSERT INTO dyi_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Kala na ye yaa ka pye li na: ‹Kore naa wi pinlɛyɛɛnlɛ pe ni fuun pe naŋganra leyaara lɛ. ");
INSERT INTO dyi_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Goto pe kasɔn naŋganra le wa ti ni peri yinyin, pe wusuna nuwɔ taan wo ti na Yawe Yɛnŋɛlɛ li yɛgɛ sɔgɔwɔ. Yawe Yɛnŋɛlɛ liga ka lere ŋa wɔ, wo wi yɛn kpoyi li kan. Yoro Levi setirige piile, ye wogo kì toro yogo na koni.› » ");
INSERT INTO dyi_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","A Moyisi wì si Kore wi pye naa fɔ: «Ye logo na yeri jɛŋgɛ, yoro Levi setirige piile wele! ");
INSERT INTO dyi_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Izirayɛli woolo Yɛnŋɛlɛ lì ye wɔ Izirayɛli woolo sanmbala pe sɔgɔwɔ, ma konɔ kan ye yeri yaa fulo li tanla mbaa tunŋgo piin wa Yawe Yɛnŋɛlɛ li cɛnsaga paraga go ki ni, konaa mbaa yeregi Izirayɛli gbogolomɔ woolo pe yɛgɛ sɔgɔwɔ mbaa tunŋgo piin pe kan. Ko si yoro bɔ ma? ");
INSERT INTO dyi_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Yawe Yɛnŋɛlɛ lì konɔ kan ye yeri yaa fulo li tanla, mboro naa ma woolo pe ni fuun pe ni, yoro mbele ye yɛn Levi setirige piile wele. Konaa ki ni fuun, ye yɛn na saraga wɔgɔtunŋgo ki jaa fun. ");
INSERT INTO dyi_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ki wogo ŋga kì pye yɛɛn, ko ki naga ma yo Yawe Yɛnŋɛlɛ lo yè yiri ma je li na, mboro naa ma pinlɛyɛɛnlɛ pe ni. Nakoma Arɔn wo woro yaraga ka, ye yiri ye je wi na.» ");
INSERT INTO dyi_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ko puŋgo na, a Moyisi wì si tun ma yo pe sa Eliyabu pinambiile Datan naa Abiramu pe yeri wi kan. Ɛɛn fɔ, a pè suu yɔn sogo ma yo fɔ: «We se kari wa! ");
INSERT INTO dyi_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Tara nda ti yɛn ma yin nɔnɔ naa sɛnrɛgɛ ki ni na fuun, mà we yirige wa ti ni ma pan mbe we kan we ku laga gbin