﻿USE sofia;
DROP TABLE IF EXISTS sofia.dwy_vpl;
CREATE TABLE dwy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dwy_vpl WRITE;
INSERT INTO dwy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dhuwayatja latjuꞌna yana dhäwuꞌ. Ga dhäwuꞌya dhuwaya God-Waŋarrwalaŋuwuy Gäthuꞌmiŋuwalaŋuwuy, ga yäkuya ŋayi ŋunhi Djesu. Ŋayiya dhuwaya Christnha, Maŋutji-ḻakanhawuynha ŋunhi ŋayi God-Waŋarryu ḻakaŋaya ŋäthiyi. Ga dhäwuꞌya nhanukalaŋuwuy gurra bitjan gamꞌ ŋurru-yirrꞌyun: ");
INSERT INTO dwy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yaka ŋayi ŋunhi Djesuya ŋurru-yirrꞌyuna djäma, yurru God-Waŋarryu ŋunhi ḻinygu djuyꞌyuna yolŋuna yäkuna John-na. Ŋayi ŋunhi John-dhu riwalꞌyunaya dhukarrya nhanŋu Djesuwu. Ga ŋäthiyi ŋayi bili God-Waŋarryuya djuyꞌyuna nhanŋuway djawarrkmina yolŋuna yäkuna Isaiah-na. Ga bitjaya ŋayi ŋunhi ŋäthiyiya wukirri gamꞌ: “Ŋäku waya! Dhuwaya ŋarra gurra djuyꞌyuna yolŋunaya dhäwuꞌminaya ŋarrakuway. Ŋayi yurru dhukarrnha riwalꞌyun nhuŋuna. ");
INSERT INTO dwy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ga marrtjiya ŋayi yurru ŋunhi yolŋuya ŋunha wiraŋdhi wäŋayi yolŋumiriwyi ga ŋunhayana ŋayi ŋuli djawarrkthuya, ‘Bukmak yolŋu bawalamiŋu, gatjuy ŋamaŋamayunmina nhanŋuya Garraywuya. Dhukarrya dhunupakuŋuna, gumurr-ŋamathina nhanŋu.’ ” ");
INSERT INTO dwy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Ga ŋunhiya yolŋu yäku John-dja ŋunhi Buku-ḻupthunamiya yolŋu. Ga nhinanaya ŋayi gurrana ŋunhi guŋnharrana yana yolŋumiriwnha ŋunhaya wäŋaŋu yäkuŋu galki mayaŋꞌŋu Jordan. Ga girriꞌya ŋayi ŋuli dhaṯthunminya camel-waya bulkaꞌyu, ga biralꞌya nhanŋu wäyin barrwaṉ djämawuy ŋayi ŋuli nherraṉa. Ga ŋathaya ŋayi ŋuli ḻukanha ḏetjnha ga gukuna. John-dja gurrana ŋunhi nhinana bitjan ŋayi God-Waŋarrwuna djawarrkmi yäku Elijah ŋunhi ŋayi gurrana nhinana ŋäthiyi. Ga balanyamiyu, guḻkuꞌna ŋunhi yolŋuya waya marrtjina beŋuyu Jerusalem-ŋuyu ga birrkaꞌmiŋu wäŋaŋu beŋuyu Judea-ŋuyu makarrŋuyu, marrtjina ŋayŋu John-guna bunana. Ga marrtjina waya ŋunhi, bili waya gurrana djälmiyina waya yurru nhäma ŋanya, ga ŋäma nhanŋu dhäwuꞌ nhattjan ŋayi gurra marŋgikuma. Ga bitjayana ŋayi gurrana wayana waŋanaya, “Way, waya, ḻakaŋuna warraŋulkuŋuna nhumaŋgu yätjtja mala, ŋayŋu bilyuna, ga gunhaꞌyuna, märr ŋayi yurru God-Waŋarryuya nhumaŋgu bäy-ḻakamana. Djalkthuna waya dhuwayi yätjtja mala bala buku-ḻupthuna märr yurru ŋunhi ŋuriŋiya maŋutji-ḻakama ŋunhi nhumaya ḻinyguna bitjan latjuꞌna.” Ga ŋunhi waya marrtjina yätjtja wayaŋguway ḻakaŋaya warraŋulyiya, ŋayŋu ŋayi wayana gurrana buku-ḻupꞌmaŋayana ŋunhayana Jordan-na mayaŋꞌŋu. ");
INSERT INTO dwy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ga bitjayana ŋayi wayana waŋanaya, “Dhika gurra wiripu yolŋu marrtji buluna walꞌŋu djuḻkmamana gurra ŋarranaya. Ga ŋarraya dhuwaya bäyŋu yana ganaꞌ ŋurukuya nhanukalaŋuwu dhapatjuŋguya yupmanhawu, ḻäywuy dhuwaya ŋarra yolŋu, yaka ŋurruwuŋmi. ");
INSERT INTO dwy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ŋarraya gurra nhumana dhuwaya buku-ḻupmama gapuyu yana waŋganydhu. Yurru, ŋayiya yurru ŋunhi God-Waŋarryuya nhumaŋgaya rarryu Dhuyu Birrimbirrnha, ŋuriŋiya gurra buluna walꞌŋu djuḻkmama.” ");
INSERT INTO dwy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ga balanyamiyu waluyu, ŋayi Djesuya marrtjina Galilee-ŋuya makarrŋu wäŋaŋu yäkuŋu Nazareth-ŋu, märr ŋayi yurru John-guna buna. Ŋayŋu ŋayi John-dhuya ŋanya Djesuna buku-ḻupmaŋayana ŋunhaya Jordan-na mayaŋꞌŋu. ");
INSERT INTO dwy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ga ŋunhi ŋayi Djesu beŋu gapuŋuya walmana, bala ŋunhi djiwarrꞌya ḻapthunana. Ga God-Waŋarrwuya Dhuyu Birrimbirr yarrupthuna nhanukaya balanya bitjan wäyin murryil. ");
INSERT INTO dwy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ŋayŋu waya ŋäkuyana rirrakaynha waŋana gurrana bitjaya, “Dhuwayatja ŋarraku ŋunhi marrkapnha gäthuꞌmiŋu. Ga wirrkina yana ŋarra ŋuli gurra dhuwaya goŋmiyiya nhanukaya.” ");
INSERT INTO dwy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ga beŋuya ŋayŋu ŋunhi Dhuyu Birrimbirryuya djawꞌyuna Djesunaya gänaŋuyina ŋayilpiyina wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ga ŋunhayana wiraŋŋuna ŋayi gurrana ŋunhi nhinanaya 40-na walu. Ga wiripuya gurrana ŋunhi nhinana wakinŋuna wäyin malanynha. Ga ŋunhayatja ŋanya gurrana ŋunhi Satan-dhuya gurꞌkuryunana. Yurru ŋayiya yaka nhanŋu malthuna. Ŋayŋu ŋunhi djiwarrꞌwuyya dhäwuꞌmi yolŋu waya bunana nhanŋu guŋgaꞌyunawuna. ");
INSERT INTO dwy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Waŋganymiyu waluyu waya mulkanana ŋanya John-naya ŋunhi Buku-ḻupthunaminaya yolŋuna ŋayŋu gärrinymaŋaya dharruŋguyina. Ŋayŋu ŋayiya ŋunhi Djesuya marrtjina ŋayŋu Galilee-yina makarryi, märr ŋayi yurru ḻakama God-Waŋarrwalaŋuwuynha latjuꞌna dhäwu ŋunhaya. ");
INSERT INTO dwy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ga bitjaya ŋayi gurrana waŋana, “Ŋäkuna waya! Garraywuya dhuwaya walu bilina bunana! Ga yolŋuya yurru ŋunhi bukmaknha yana marŋgiyi ŋunhi God-Waŋarryuya ŋuli romdja nhanŋuway marrtjinyamaŋuna, ga dhuwayana ŋunhi yulŋuya dhiyaŋuna bala. Gatjuy, bilyuna waya mayaliꞌ-wilkthunamiŋuya romŋu, ŋayŋu roŋiyina, bala malthuna nhanŋuna God-Waŋarrwuna dhärukku. Ŋayŋu märr-yuwalkthina ŋuriki God-Waŋarrwalaŋuwuna latjuꞌwuna yana dhäwuꞌwu.” ");
INSERT INTO dwy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Waŋganymiyu ŋayi marrtjina Djesu galki Galilee-kuyu gapukuyu ga ŋunhaya ŋayi maḻŋꞌmaŋaya yolŋuna yäkuna Simon-na ga guthaꞌmiŋu nhanŋu Andrew. Ŋunhaya maṉḏa gurrana nhinana baymatthuna guya ganybuyu. Ŋunhina bili maṉḏaku ŋunhi djämaya. ");
INSERT INTO dwy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ŋayŋu ŋayi Djesuyuya garrꞌyunana maṉḏana bitjayana, “Wäy, maṉḏa, go! Malthuna nhuma yurru ŋarrakuna. Ŋarraya yurru nhumana marŋgikumana nhuma yurru gaṯmama yolŋunana wayana.” ");
INSERT INTO dwy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ga ŋunhi maṉḏa ŋäkuya balanyawuya bala maṉḏa gunhaꞌyunana ŋunhi ganybuya ŋayŋu dhunupana yana malthunana nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ga bitjaya bala ŋayi Djesu marrtjina ga nhäŋaya ŋayi Zebedee-wu gäthuꞌmiŋuna maṉḏana. Ga wakindja ŋunhi wäwaꞌmiŋuya yäku James ga guthaꞌmiŋuya nhanŋu yäku John. Ga bitjana bili maṉḏaya gurrana ganybu dhunupakuŋaya marthaŋaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ŋayŋu ŋayi Djesuya wäthunana maṉḏaku bitjaya, “Way, go, malthuna maṉḏa ŋarrakuna!” Ŋayŋu yana maṉḏa gunhaꞌyunana maṉḏaku bäpaꞌmiŋunaya ga djämaya ŋunha bili marthaŋayina. Ŋayŋu maṉḏa malthuna nhanŋuna. ");
INSERT INTO dwy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ŋayŋu waya bunana ŋunhaya Capernaum-nha wäŋaŋu, ŋayi Djesu ga ŋunhi wiripu-guḻkuꞌ yolŋu waya ŋunhi waya bämaraꞌyuna ŋanya. Ga Nhinanhamiyuna ŋunhi Waluyu, ŋayi Djesuya marrtjina ŋayŋu Jew-wayana biryamiyi buṉbuyi, märr ŋayi yurru marŋgikumana wayana ŋunhayana. ");
INSERT INTO dwy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ga ŋunhi gurrana yolŋuy wayay ŋäkuya ŋanya dhäruk, ṉirryunana, bili ŋayi ŋunhi marŋgina wirrkina ŋuriki malaw dhäwuꞌwu ga ganydjarrmina ŋuli ŋayi waŋaya. Ga djuḻkmamana gurra ŋunhi Jew-wuya rom-marŋgikunhaya nhattjan waya ŋuli marŋgikuma. ");
INSERT INTO dwy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ga ŋunhaya bili ŋayi yolŋu yätjmi birrimbirrmi gulŋiyina balayi buṉbuyi yurru dhä-rirrakaymi, ");
INSERT INTO dwy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yatjuna marrtjina bitjaya, “Wäy, Djesu wäŋa Nazareth-puy, nhäku nhe lili-ya marrtjina? Märr nhe yurru djuyꞌyuna ŋarrana ga ŋunha wiripuna yätjnha birrimbirrinha mala ŋayŋu dhä-ḏirꞌyunamiyina wäŋayi? Ŋanapuya dhuwaya dharaŋaya nhuna, nheya dhuwaya ŋunhiyi ŋunhi Maŋutji-ḻakanhawuy yolŋu God-Waŋarrwuŋuna djuyꞌyunaya. Nheya dhuwaya God-Waŋarrwu ŋunhi Dhuyunha Yolŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ŋayŋu ŋayi Djesuya waŋana bitjaya, ŋarrtjuna manapaya, “Maꞌ, mukthuna, ga walmina dhiyakayatja yolŋuwaya!” ");
INSERT INTO dwy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ŋayŋu ŋayi ŋuriŋi yätjthu birrimbirryu rurrꞌrurryunana ŋunhiyi yolŋunaya wirrkina yana. Ŋayŋu yana ŋayi ŋunhi dhawaṯthunaya dhä-rirrakaymina. ");
INSERT INTO dwy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ga yolŋuy wayay ŋunhi ŋunhaya biryamiŋuya buṉbuŋu nhäŋayana maŋmaŋdhunana. Ŋayŋu waya marrtjina waŋanhaminana bitjayana, “Nhä dhuwayatja? Dhuwaya ŋayi gurra dhäruk-mulka ŋunha yätjku birrimbirrwu dhawaṯmanhawu, ga wayatja gurra ŋanya ŋunha dhäruktja yana ŋätthuna. Nhäna ŋayi gurra dhuwaya yuṯana rom marŋgikuma ŋilimunaya?” ");
INSERT INTO dwy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ŋayŋu gurrana ŋunhi dhäwuꞌya marrtjina ḻatjuwarrꞌyunana ŋunhayatja makarrŋu wäŋaŋu Galilee-ya. Yolŋuya waya marrtjina ŋunhi ḻakanhaminana. ");
INSERT INTO dwy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ga ŋunhi waya dhawaṯthunaya marrtjina beŋu biryamiŋuya buṉbuŋu, ŋayŋu ŋayi Djesuya marrtjina ŋayŋu Simon-gayana ga Andrew-wayana wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ga ŋunhaya gurrana Simon-gu mukulꞌmiŋu rumaruꞌ rirrikthuna gorrmurꞌyu. Ga ŋunhi ŋayi Djesu ga guyurrꞌmiŋu waya nhanŋu gulŋiyinaya, ŋayŋu ŋayi ŋunhi yolŋuya waṉḏina ŋayŋu ḻakaŋayana Djesuwuna bitjaya, “Dhuwaya nhina worruŋu rirrikthun gorrmurꞌyu.” ");
INSERT INTO dwy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ŋayŋu ŋayi Djesuya marrtjina miyalkkayana, bala mulkanana ŋanya goŋnha ŋayŋu gaŋgathinymaŋayana. Ŋayŋu dhunupa yana ŋunhi gorrmurꞌya winyaꞌyunana. Ŋayŋu ŋayi ŋunhi miyalktja dhawaṯthunaya ga ganydjarr-warryuna ŋathawuna wayaŋgalaŋuwu. ");
INSERT INTO dwy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ga ŋunhi marrtjina waluya gulŋiyina bala marrtjina ŋunhi yolŋuyuya wayay rerriminaya wayana gäŋayana ga birrimbirr yätjminaya yolŋuna wayana ŋayŋu Djesuwayana walŋakunhawuna. ");
INSERT INTO dwy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ga guḻkuꞌna ŋunhi wirrkina yolŋuya waya ḻuŋꞌthuna balayi buṉbuyi, be nhämunyꞌnha gurrana mala-nherraṉmina. ");
INSERT INTO dwy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ga guḻkuꞌna ŋayi gurrana ŋunhi yolŋuna wayana walŋakuŋaya, wiripuŋu ga wiripuŋu rerriŋu. Ga walŋakuŋaya ŋayi wayana gurrana bukmaknha yana. Ga guḻkuꞌna ŋayi gurrana dhawaṯmaŋaya yätjtja malana birrimbirr. Ga wayatja ŋunhi yätjtja birrimbirr mala marŋgiyina nhanŋu, bala ŋayi Djesuya dhäruk-mukmaŋayana wayana. ");
INSERT INTO dwy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ga wiripuyuna waluyu yurru munhaku, ŋayi Djesu gaŋgathina beŋu buṉbuŋuya. Ga marrtjina ŋayŋu gänaŋuyina buku-miyanhawu märr maṉḏa yurru bäpaꞌmiŋu nhanŋu waŋanhami. ");
INSERT INTO dwy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ga ŋunhi ŋayi Simon ga wiripu-guḻkuꞌ guyurrꞌmiŋu waya nhanŋu gaŋgathina yakurrŋuya ŋayŋu waya gurrana ḻarruŋayana nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ga ŋunhi waya ŋanya maḻŋꞌmaŋayatja ŋayŋu waya bitjayana waŋana, “Marrkapmi, guḻkuꞌna gurra dhuwaya yolŋuya waya ḻarruma nhuŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ga ŋayiya bitjaya buku-roŋinymaŋaya, “Manymak dhuwayitja. Yurru ŋilimu yurru balaku bala ŋurruŋuya marrtji buku-ḻiwꞌmama ŋunha wiripuyi wäŋayi. Dhuwaya ŋunhi wäŋa mala ŋunhi ŋuli galki djingaꞌ-djingaryun. Bili ŋarra ŋuli djälmiyi ŋarra yurru ḻakama wayaŋgu Latjuꞌ Dhäwuꞌ, bili dhuwayyi ŋarraku ŋunhi djämaya.” ");
INSERT INTO dwy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ga beŋu dhurrwaraŋu, ŋayŋu ŋayi marrtjina djuḏuꞌyunana Galilee-kuyuna makarrkuyu, märr ŋayi yurru ḻakama dhäwuꞌna latjuꞌna God-Waŋarrwalaŋuwuynha ŋunhayatja Jew-waya biryamiŋu buṉbuŋu malanyŋumi. Ga bitjaya bili ŋayi gurrana Jesuyu ŋunhi yätjtja birrimbirr malanynha ŋaŋꞌŋaŋdhuna yolŋuwayatja wayaŋgaya. ");
INSERT INTO dwy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ga balanyamiyu waluyu yolŋu burrpuymi marrtjina nhanukaya Djesuwaya. Ŋayŋu ŋayi bunꞌkumu djipthuna ŋäŋꞌthuna guŋgaꞌyunawu bitjayana, “Marrkapmi, guŋgaꞌyu ŋarrana! Ŋarra marŋgi ŋunhi nhe yurru dhuwaya burrpuya rerri ŋarrakaya winyaꞌyunmamana, ŋuli nheya djäl, märr yurru gurra yolŋuya waya ŋarraku yakana buluya milnyaŋꞌthun.” ");
INSERT INTO dwy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ŋayŋu ŋayi Djesuya wuyunana nhanŋu ga goŋ-djarryuna, ŋayŋu mulkanana ŋanya bala waŋanana, “Djäl ŋarra dhuwaya, ŋarra yurru walŋakumana nhuna. Ḻinyguna nhe dhuwaya latjuꞌna!” ");
INSERT INTO dwy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ga dhunupana yana ŋayi ŋunhi ḏarramuya walŋathinana, ga wiḏiꞌyunana nhanukaya ŋunhi rerriya. ");
INSERT INTO dwy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ga waŋana ŋayi Djesu ḏälyu dhärukthu ŋayŋu djuyꞌyunana ŋanya wäŋayina ");
INSERT INTO dwy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","bitjayana, “Latjuꞌkuŋu yana guyaŋiya! Bilina nhe dhuwaya manymaknha ga yaka nhe yurru ḻakama yolŋuwutja wayaŋgu. Ŋuriki bili yana bamanꞌŋuwu yolŋuwu Moses-ku romgu malthu ŋunhi ŋayi ŋäthiliŋu. Ŋayŋu ŋäthiyiya ŋurruŋuya marrtji ŋunha ḏalkarramiwu yolŋuwu buni ga ŋayi yurru nhuna dhuwayi rumbalya nhäma ŋunhi rerriya yuwalknha yana winyaꞌyunana. Ŋayŋu nhe yurru mundhurrnha gathan buku-wekama God-Waŋarrnhana, märr yurru ŋunhi bukmaknha yolŋu waya marŋgithi ŋunhi nhokaya rerriya wiḏiꞌyunana.” ");
INSERT INTO dwy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ga ŋunhi ŋayi ŋunhiyi yolŋu walmanaya ŋayŋu ŋayi marrtjina ḻiwꞌmaŋayana ḻakaŋaya dhäwuꞌya wäŋakuyuna. Ga guḻkuꞌna ŋunhi yolŋuya waya ḻarruŋaya nhanŋu Djesuwuya. Ga yakana ŋunhi ŋayipitja marrtjina ŋayŋu yolŋu guḻkuꞌmiyiya wäŋayi, bili ŋunhi yolŋuyuya wayay ŋanya djorkuŋayana, ŋunhiya ŋayi gurrana ŋunhayana bäymana wirwiryuna wiraŋŋuna wäŋaŋu. Yurru gurrana ŋunhi yolŋuya waya ḻarruŋaya yana nhanŋu, nhänharawu djälmiyina nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ga be nhämunyꞌ ŋunhi walu djuḻkthuna, ŋayŋu ŋayi Djesuya roŋiyina bala Capernaum-dhina. Ga yolŋu waya marrtjina ḻakanhamina Djesuna ŋunhi ŋayi bilina ŋunha wäŋaŋuna gurrana nhinana. ");
INSERT INTO dwy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ga yolŋuya waya marrtjina ḻuŋꞌthuna birrkaꞌmiŋuna wäŋaŋu. Ga gulŋiyina marrtjina ga dhaŋaŋdhina, ga beŋga gurrana dhurrwaraŋuya nhinana ŋaṉbawꞌyuna. Ŋayŋu ŋayi Djesuya gurrana marŋgikuŋayana ga dhäwuꞌna ḻakaŋaya God-Waŋarrwalaŋuwuynha ŋayaŋuwuy. ");
INSERT INTO dwy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ga ŋayiya ŋunhi Djesuya baḏak gurrana ḻakaŋaya dhäwuꞌ, ga wayatja ḏämbumiriwyu yolŋuyu wayay gurrana gäŋaya gaṉuŋnha yolŋuna ŋayŋu Djesuwaya. ");
INSERT INTO dwy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ga bilina ŋunhi guḻkuꞌna wirrkina yolŋuya gurrana mala-nherraṉmina ŋunhayatja, ga yakana ŋunhi wayaŋgu dhukarrya wanhaku waya yurru yolŋunaya gäma Djesuwaya. Ŋayŋu waya ŋalꞌyuna ŋunha ŋapayina balaꞌpalayi ŋayŋu ŋarŋgana warkthuna ŋunhayana garrwarnha dhunupana yana ŋunhi wanhami gurrana Djesu djingaryuna. Ga ŋunhi balaꞌpalaya ḻapthunana ŋayŋu waya yupmaŋayana ŋunhi yolŋunaya gayanhꞌthamina. ");
INSERT INTO dwy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ga ŋunhi ŋayi Djesuyu nhäŋaya wayana ŋayŋu ŋayi marŋgithina wayaŋgu bili nhäŋaya ŋayi ŋunhi märr-yuwalkthinyami rom, ŋayŋu ŋayi gaṉuŋnhaya yolŋuna waŋana bitjayana, “Bilina ŋarra dhuwaya nhuŋu yätjtja rom bäy-ḻakaŋayana.” ");
INSERT INTO dwy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ga ŋunhaya ŋaḻapaḻmi Rom-marŋgikunhami yolŋu mala gurrana ḏäpthuna. Ga ŋunhi waya ŋäkuya Djesuna balanyawuy waŋanhaya ŋayŋu waya ŋayaŋuya yätjthinana, yakana waya galŋa-latjuꞌyina ŋuriŋiyi. ");
INSERT INTO dwy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ŋayŋu waya bitjayana waŋana, “Nhä ŋayi dhuwaya goramiriw balanyawu waŋanhawu. Dhuwaya ŋuli yana ŋayipi God-Waŋarryu yolŋuwu wayaŋgu bäy-ḻakama yätjpuy djämawuy. Nhattjan ŋayi ŋuli dhuwaya guyaŋinyamiya, yana bini ŋayi dhuwaya rrambaŋina maṉḏa God-Waŋarrnha? Dhuwaya ŋayi dhä-wiripuyinana waŋanaya!” ");
INSERT INTO dwy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yurru ŋayiya ŋunhi Djesuya wayaŋgu marŋgithina, ŋayŋu ŋayi bitjayana waŋana, “Yaka waya biyaku guyaŋi! ");
INSERT INTO dwy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Nhattjan ŋarra yurru dhika waŋaya? Ŋuli ŋarra yurru bitjandja, ‘Maꞌ, bilina ŋarra dhuwaya nhuŋu yätjtja bäy-ḻakaŋayana’, nhumaya dhuwaya yaka marŋgi ŋunhi yurru bitjandja maḻŋꞌthun, mak bäyŋuna. Ga ŋunhi ŋarra yurru waŋa bitjandja, ‘Maꞌ, ŋaṯthuna nhuŋuway dhuwayyi gayanhꞌthaya ŋayŋu marrtji wäŋayina’, ga yurruna nhuma yurru nhämaya ŋunhi ŋarraya dhuwaya Yuwalkŋuya Walꞌŋu Yolŋu dhuwanna. Ga ŋarraŋga gurra dhuwaya ganydjarrya mulka bäy-ḻakanhawuya yolŋuwuya wayaŋgu yätjkuya romgu.” ");
INSERT INTO dwy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ga beŋuya dhurrwaraŋu ŋayi Djesuya waŋana ŋunhi gaṉuŋnhaya yolŋuna bitjayana, “Yo, ŋäkuna! Dhuwaya nhe bilina walŋathinana, gatjuy, gaŋgathina ga ŋätthu nhuŋuway gayanhꞌthaya bala marrtji wäŋayina.” ");
INSERT INTO dwy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ga ŋunhi ŋayi ŋuriŋi yolŋuyu ŋäkuya, ŋayŋu ŋayi yana gaŋgathinana. Ga gayanhꞌthaya ŋayi ŋätthuna bala yana dhawaṯthunana. Ga waya ŋunhi yolŋuyuya wayay nhäŋayana ŋanya ganyimꞌthunana manapaya bitjayana, “Dhuwayatja ŋanapu gäthurana dhiyaŋuna bala nhäŋaya balanyawuya. Yuwalk yana ŋayi dhuwaya God-Waŋarrya ganydjarr ŋuṯu.” ");
INSERT INTO dwy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ga beŋuya ŋayi Djesu bulu marrtjina raŋiyi Galilee-yi guḻunꞌthi. Ga guḻkuꞌ ŋunhi yolŋuya waya marrtjina gumurr-waṉḏina nhanŋu ŋayŋu ŋayi gurrana ḻakaŋayana wayaŋgu God-Waŋarrwuna ŋayaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ga ŋunhayayi gurrana nhinana yolŋu yäku Levi, Alphaeus-ku gäthuꞌmiŋu. Ga warkthunaya ŋayi gurrana rrupiya ḻuŋꞌmaŋaya yäku tax Roman-buyŋuwu gapmangu. Ga ŋunhi ŋayi Djesu bunana, ŋayŋu ŋayi nhäŋayana Levi-nha. Ŋayŋu ŋayi bitjayana waŋana, “Wäy nhawi, go! Malthuna ŋarrakuna!” Ga ŋunhi ŋayi Djesuna dhäruk balanyawuy ŋäkuya, ŋayŋu ŋayi Levi-ya gaŋgathinana ga dhunupana yana malthunana nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ga beŋuya ŋayi Djesu ga malthunami waya nhanŋu marrtjina Levi-wayana wäŋayi, rrambaŋina waya ḻuṉḏuꞌmiŋuna waya nhanŋu Levi-wu ŋunhi rrupiya-warkthunamina waya. Ga wiripuya gurrana ŋunhayayi yolŋu waya nhinana ŋunhi ŋuli gurranha Jew-yu malayu wayana ḻakanha ŋunhi wayatja raypirri-waḏatjmina. Ga ŋunhaya bili ŋurrukŋu gurrana ḏäpthuna yolŋu waya ŋunhi waya ŋuli gurrana djälminya mäkiriꞌ-witjunawu nhanŋu Djesuwu. ");
INSERT INTO dwy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ga ŋulinyamiyu ŋunhaya gurrana nhinana rom-marŋgikunhami waya Pharisee-waya ŋurrukŋu. Ŋayŋu waya nhäŋayana ŋanya Djesunaya ŋayi gurrana ŋatha ḻukana ŋurikaya rrupiya djämamiwaya ga rom-djarrpiꞌmiwaya yolŋuwaya wayaŋgaya. Ŋayŋu waya ŋäŋꞌthuna ŋunhi Djesuwu guyurrꞌmiŋuna wayana bitjaya, “Nhäku gurra ŋunha nhumaŋguya marŋgikunhami nhina tax djämamiwayatja wayaŋgaya ga dhuwurr-yätjmiwaya yolŋuwaya wayaŋgaya?” ");
INSERT INTO dwy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ga ŋayitja ŋunhi Djesuyuya ŋäkuya wayana, ŋayŋu ŋayi bitjayana waŋana wayaŋgu, “Rerrimi yana yolŋu waya yurru marrtji marrŋgitjkayatja, yaka ḏäwalamiya. Ŋarraya dhuwaya marrtjina lili yätjmiwu yolŋuwu wayaŋgu, yaka ŋurikiya yolŋuwu ŋunhi waya ŋuli gurra be rom-dhunupa ḻakanhami.” ");
INSERT INTO dwy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Waŋganymiyu, yolŋu waya Rom-djákamiya mala yäku Pharisee gurrana ŋoy-ŋathamiriwnha yana nhinana ŋuriki romgu malthuna. Yo, ga nhäŋaya waya John-gu ŋunhi Buku-ḻupthunamiwu malthunamina wayana waya gurrana bitjaya bili ŋoy-ŋathamiriw nhinana. Ga yaka waya ŋunhi Djesuwuya guyurrꞌmiŋuna wayana nhäŋaya balanyayi. Ŋayŋu ŋunhi yolŋuya waya bunana nhanŋu Djesuwu ŋayŋu dhä-wirrkaꞌyunana bitjayana, “Wäy, ŋanapuya ŋuli gurra dhuwaya ŋoy-ŋathamiriw nhina, romgu malthun. Ga ŋunha gurra John-guya malthunami waya bitjan bili. Ga nhäku warray ŋuli ŋunhi nhuŋuya guyurrꞌmiŋu waya yaka bitjandhi nhina?” ");
INSERT INTO dwy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ŋayŋu ŋayi Djesuyuya mayaliꞌmina dhäwuꞌ ḻakaŋaya bitjayana, “Ḻinygu ga nhuma dhuwaya marŋgi: Ŋunhi yolŋu maṉḏa ŋuli ŋätthunmi, ga yolŋuya waya ŋuli yaka dhurrwara-yupthun ŋathaŋuya, ŋunhi waya ŋuli yana marrtji ŋathaya ḻukana ḏulpu-gunhamina. Ga ŋunhiya ḏarramu ŋunhi ŋayi yurru ŋätthun miyalknha nhanŋuway, ŋunhi ŋayi yurru ŋunhayatja nhina, ŋunhiya gurra yurru yolŋuyuya wayay ŋatha ḻuka yana. ");
INSERT INTO dwy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ga ŋunhi ŋayi yurru ŋunhina ḏarramuna djawꞌyun, ŋayŋu yurru ŋunhi ḻuṉḏuꞌmiŋuya waya nhanŋu ŋayaŋu-yätjthina ga marrtji waya yurru gurra ŋoy-ŋathamiriwnha nhina.” ");
INSERT INTO dwy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ga bulu ŋayi Djesuyu wiripu mayaliꞌmi dhäwuꞌ ḻakaŋaya, “Yaka yurru yolŋuyu dhamin-dharpuma yuṯa manydjarrkaꞌ ŋunha ŋäthiliŋuyi girriꞌyi manapan. Bili yalala ŋayi yurru ŋunhi girriꞌ rurrwuyun, bala yurru ŋunhi yuṯaya manydjarrkaꞌ dhurŋꞌthuna yutjuwaḻaꞌyina, ŋayŋu yurru ŋunhi girriꞌya barrꞌyuna. ");
INSERT INTO dwy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ga balanya bili: Yaka yurru dhuwaya yuṯa borum wikaꞌ rarryun ŋunha ŋäthiliŋuyi bathiyi, bili ŋayi yurru ŋunhi barrꞌyuna bala yurru wiyikaꞌya waṉḏina. Yuṯaya borum wiyikaꞌ yurru rarryun yuṯayi yana bathiyi.” Bitjaya ŋayi gurrana ŋunhi Djesuyu wayaŋgu ḻakaŋayatja, ŋunhi yurru nhanukuŋu yuṯaya marŋgikunhaya yurru yakana maŋutji-manapan ŋunhimaya ŋunhi nhä waya Pharisee-yu wayay ŋuli marŋgikuma. ");
INSERT INTO dwy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Waŋganymiyu Nhinanhamiyu Waluyu Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu marrtjina gurrana dhukarrkuyu ŋayŋu nhanukaya ḻuṉḏuꞌmiŋuya wayay gulkthuna marrtjina muḻkurr ŋatha berrali bala ḻukanana marrtjina bili waya djaṉŋarrthina. ");
INSERT INTO dwy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ga waya ŋunhi Pharisee-yuya nhäŋaya wayana, ŋayŋu waya ḻakaŋayana Djesuwuna, “Nhäku gurra ŋunha nhokayatja guyurrꞌmiŋuyu wayay rom ḏawꞌyun? Ŋunha waya gurra ŋatha wapmama dhiyaŋu wayay ŋunhi dhuwayatja Nhinanhami Walu. Yaka waya yurru bitjan!” ");
INSERT INTO dwy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ŋayŋu waya wayaŋgu buku-roŋinymaŋaya, “Wäy, waya, guyaŋiŋga nhuma gurra ŋunhiya dhäwuꞌ ŋunhi balanyamiyu waluyu ŋunhi ḻiya-ŋärraꞌmi yäku Abiathar gurrana nhinana? Ga wayatja ŋunhi David-tja ga malthunamiya waya nhanŋu djaṉŋarrthinana bala waya yana marrtjina ga gärrina Jew-wayana buṉbuyi bala wapmaŋayana ŋunhi ŋathaya. Ga rom gurra waŋa ŋunhi ḏalkarramiyuna waya yurru ḻuka ŋunhiya ŋatha, yakana bukmakthu. Ga ŋayiya ŋunhi David-thuya ga malayuya nhanukaya ḻukana yana bäyŋu wayana yolŋuyu wayay rom-nyamirꞌyuna.” ");
INSERT INTO dwy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ga bulu ŋayi Djesu bitjaya waŋana, “Wäy waya, yaka waya meṉguŋu, ŋunhi God-Waŋarryu Nhinanhami Walu djäma guŋgaꞌyunawu yolŋuwu. Yaka ŋayi ŋunhi yolŋuna djäma ŋayi yurru ŋurikina yana Nhinanhamiwuna Waluwu romgu malthun. ");
INSERT INTO dwy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bili ŋarraya dhuwaya Yuwalkŋuna Walꞌŋu Yolŋu, ŋarrakuwaynha yana dhuwaya dhunupaya nhattjan ŋarra yurru waŋa yolŋuna nhä ŋayi yurru djäma, wo yaka ŋayi yurru djäma dhiyaŋu Nhinanhamiyu Waluyu.” ");
INSERT INTO dwy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ga beŋuya ŋayi Djesu roŋiyina ŋayŋu Jew-wayana biryamiyi buṉbuyi gärrina. Ga ŋunhayatja ŋayi malŋꞌmaŋaya yolŋuna yurru goŋ-dhoṯnha. ");
INSERT INTO dwy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ga ŋunhaya gurrana Pharisee ŋaḻapaḻmi dhärraꞌdharrana ga dharr-witjaya waya gurrana nhäŋaya ŋanya Djesuna wanhaka ŋayi yurru walŋakuma yolŋuna Nhinanhamiyu Waluyu märr waya yurru ŋurikiwuynha Djesuwuya mariwuna. ");
INSERT INTO dwy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ŋayŋu ŋayi Djesuya gawaꞌyunana ŋurikiya goŋ-dhoṯkuya yolŋuwu bitjayana, “Go, marrtji lili, dhiya dhärri gumurrŋu, märr yurru bukmakthu yana nhämaya.” ");
INSERT INTO dwy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ŋayŋu ŋayi Djesuya waŋanana ŋuriki Pharisee-wuya yolŋuwu wayaŋgu bitjayana, “Nhattjan gurra ŋilimuŋguya rom waŋa dhiyaku Nhinanhamiwuya Waluwu? Nhä dhuwaya latjuꞌ ŋilimu yurru djäma yolŋuna wayana balanyamiyu waluyu, wo ŋilimu yurru yätjnha djäma? Nhattjan ŋarraya yurru yolŋuna walŋakuma, wo nhattjan ŋarra yurru buma murrkayꞌkumana, ŋeniya?” Ga wayatja ŋunhi Pharisee-ya waya yakana nhanŋu buku-roŋinymaŋaya. ");
INSERT INTO dwy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ŋayŋu ŋayi Djesuyu gurrana yolŋunaya wayana nhäŋayana, ga wirrkina ŋayi wayaŋgu maḏakarritjthinaya ga ŋayaŋu-wutthunaya manapaya bili waya ŋunhi ŋayaŋu-ḏälmina. Ŋunhiya waya gurrana romguna yana wayaŋgalaŋuwu wirrkiya malthuna. Ŋayŋu ŋayi Djesuya waŋana ŋurikiya goŋ-dhoṯkuya bitjayana, “Maꞌ, goŋdja djarryuna!” Ŋayŋu ŋayi ŋunhi yolŋuya goŋdja djarryuna bala yana latjuꞌyinana ga dhunupayinana. ");
INSERT INTO dwy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ŋayŋu ŋunhi Pharisee-ya yolŋu waya marrtjina latjuwarrꞌyunana, ga ŋunhayana ŋayŋu waya wiripu-guḻkuꞌya ŋaḻapaḻmi waya ḻuŋꞌthuna, ŋunhi ŋurru-warryunayŋuya miṯtji King Herod-kuya. Ga ŋunhayana waya gurrana ŋunhi waŋanhaminaya bunharawu nhanŋu Djesuwuya. ");
INSERT INTO dwy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Waŋganymiyu waluyu ŋayi Djesu ga guyurrꞌmiŋu waya nhanŋu marrtjina ŋunha bathalayi guḻunꞌthi Galilee-yina. Ga guḻkuꞌna ŋunhi yolŋuya waya nhanŋu malthuna bili waya ŋäkuya ŋunhi nhä ŋayi gurrana Djesuyu ŋunhi djäma. Ga yolŋuya waya ŋunhi marrtjina beŋu Galilee-ŋu makarrŋu ga Judea-ŋu makarr-ŋu ga Idumea-ŋu makarrŋu. Ga wiripuya ŋunhi yolŋu waya marrtjina beŋuna wäŋaŋu Jerusalem-ŋu ga Sidon-ŋu ga Tyre-ŋu. Ga guḻkuꞌ wiripu yolŋu waya marrtjina beŋu Jordan-ŋu mayaŋꞌŋu yurru galiꞌ dhimurruŋu. Ga bukmak waya gurrana ŋunhi djälthina waya yurru wayawuy yana nhäma ŋanya Djesuna. ");
INSERT INTO dwy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ga guḻkuꞌna ŋayi gurrana ŋunhi Djesuyu walŋakuŋaya balanyamiyu waluyu. Ga guḻkuꞌ yolŋu waya gurrana djälthina waya yurru ŋanya mulka, märr waya yurru latjuꞌyina. Ŋayŋu marrtjina ŋunhi yolŋuya waya giṯthunminana, ḏurꞌṯuryunminana marrtjina ŋunha galki yana nhanukayana, ŋayŋu ŋayi waŋana nhanŋuway guyurrꞌmiŋuna wayana bitjaya, “Marthaŋa waya ŋarrakaya ŋätthu, ḻinygu bäyŋuna dhuwaya dhaḻakarrya ŋarraku. Ŋunhi yurru dhuwaya yolŋuyuya wayay ŋarrana djorkumana, ŋarraya yurru marthaŋayina ŋalꞌyun.” ");
INSERT INTO dwy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ga wiripuya ŋunhi yolŋu waya ŋunhima marrtjina yätjmi birrimbirrmi mala. Ga ŋunhi waya ŋuriŋi yolŋuy wayay nhäŋaya ŋanya Djesunaya, bala gurrana ŋunhi birrimbirryuya malay djalktjalkthunana ŋunhi yolŋunaya wayana munathaꞌyina ŋayŋu gurrana yatjunana bitjayana, “Nheya dhuwaya God-Waŋarrwu Gäthuꞌmiŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yurru ŋayiya ŋunhi wayana dhurrwara-mukmaŋaya bitjaya, “Yaka nhuma yurru dhuwaya yolŋuwuya wayaŋgu ḻakama, yol Ŋarra dhuwaya!” ");
INSERT INTO dwy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ŋayŋu ŋayi Djesuya marrtjina bukuyina ŋalꞌyuna ŋayŋu wäthuna yolŋuwuna ḏarramuwuna wayaŋgu ŋunhi gurra ŋayaŋu dhä-mananapan nhanukaya Djesuwayana, malthunawuna nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ga djarrꞌyunaya ŋayi ŋunhi 12-nha ḏarramunaya wayana märr waya yurru gurra nhanŋu malthuna yana bitjana bili, dhuwayana waya djuyꞌyunawuya mala nhanŋu. Ga marrtjiya waya yurru gurra birrkaꞌmiyi wäŋayi dhäwuꞌya yurru ḻakama God-Waŋarrnhaya yolŋuwuya wayaŋgu. ");
INSERT INTO dwy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ga wekaŋaya ŋayi wayaŋgu ganydjarr, märr waya yurru gurra yätjnha birrimbirrnha malana dhawaṯmama yolŋuwaya. ");
INSERT INTO dwy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ga dhuwaya ŋunhi yolŋuya waya gamꞌ: Simon (ŋunhi Djesuyu ŋanya yäku nherraya Peter) ga James, ga John, dhuwayatja maṉḏa Zebedee-wu gäthuꞌmiŋu maṉḏa. (Ga Djesuyuya maṉḏana wiripuya yäku wekaŋaya, Boanerges mayaliꞌ ‘Murryuꞌmurryunami’.) ga Andrew ga Philip ga Bartholomew ga Matthew ga Thomas ga James (gäthuꞌmiŋu Alphaeus-ku) ga Thaddaeus ga Simon, (ŋunhi ŋayi gurrana malthuna Zealot-kuna malawu) ga Judas Iscariot (ŋayiya ŋunhi dhuwayatja yolŋu mulkuruyina Djesuwu.) ");
INSERT INTO dwy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yo, ŋayŋu ŋayi Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu yarrupthuna bukuŋu. Marrtjinaya waya ŋayŋu buṉbuyina gärrina. Ga bitjaya bili ŋunhi yolŋu waya ḻuŋꞌthuna guḻkuꞌna wirrkina, ga bäyŋuna ŋunhi waluya wayaŋgu ŋathawuya ḻukanhawu nhanŋu Djesuwu ga ḻuṉḏuꞌmiŋuwu wayaŋgu nhanukalaŋuwu. ");
INSERT INTO dwy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ga be yol yolŋu marrtjina ga ḻakaŋaya nhanukalaŋuwu gurruṯumiwu wayaŋgu, “Go, ŋunha marrtji Djesuya bawaꞌyuna, djämayuna, malaŋuyu!” bitjaya. Ŋayŋu ŋunhi gurruṯumiya waya nhanŋu marrtjinana märr waya yurru ŋanya garrꞌyun wäŋayina. Waya yurru gurra bitjan wayawuynha nhanŋu djäka. ");
INSERT INTO dwy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Manymak, ga rom-marŋgikunhami yolŋu waya bunana beŋu Jerusalem-ŋu ga bitjaya bili waya Djesuna nhäŋaya, bala bitjayana waŋana, “Way, waya, yaka nhuma yurru gurra dhiyakuya malthun, bili ganydjarrya ŋayi ŋuli gurra dhuwaya ŋätthun Satan-guŋu ŋunhi ŋayi buŋgawana bitjan yätjku birrimbirrwu malawu, ga wiripuya ŋayi ŋunhi yäku Beelzebul. Ga balanyawuynha ŋayi ŋuli gurra dhuwaya yätjnhaya birrimbirrnha malanynha dhawaṯmama.” ");
INSERT INTO dwy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ga ŋayiya ŋunhi Djesuya marŋgithina ŋunhi nhattjaya waya gurrana waŋana, ŋayŋu ŋayi wäthunana wayaŋgu, “Go, lili waya marrtji ga mäkiriꞌ-witjuyu waya ŋarraku,” bitjaya. Ŋayŋu ŋayi wayaŋgu dhäwuꞌna ḻakaŋaya märr dhunupakuŋayana. Ga bitjaya ŋayi waŋanaya gamꞌ, “Nhattjana ŋayi yurru ŋunhi Satan-dhuya buma Satan-naya? Dhuwayitja mayaliꞌmiriwnha rom. ");
INSERT INTO dwy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ga ŋäku waya! Ŋunhi yurru gurra yolŋu waya bunharami wäŋganybuy wäŋawuy, wayatja yurru ganydjarrmiriwthina bala yurru malaya dhawarꞌyun gupa-ḏälnha wiyinŋumina. ");
INSERT INTO dwy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ga ŋunhi yurru gurra waŋgany bäpurruꞌ yolŋu waya bitjan bili bunharami, ŋayŋu yurru ŋunhi yolŋuya waya gurruṯumiya waḻamaṯthina malaya, bala yurru dhawarꞌyuna gupa-ḏälnha. ");
INSERT INTO dwy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ga balanya bili, ŋunhi yurru gurra Satan-dhuya buma malana nhanŋuway, ŋayŋu yurru ŋunhi bukmaknha yana waya ganydjarrmiriwthiya ŋayŋu yurru bäyŋuthina, dhawarꞌyuna malaya yurru! ");
INSERT INTO dwy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ga ŋäkuna waya dhuwaya mayaliꞌmiya dhäwuꞌ ŋarra yurru ḻakama: Waŋgany yolŋu djälthina ŋayi yurru girriꞌ manaŋi beŋu ḏälwaya yolŋuwaya. Ga ŋurruŋuya ŋäthiyi ŋayi yurru ḏapmama ŋunhiyi ḏälnhaya yolŋuna, ga yurruna ŋayi yurru girriꞌya malanynha nhanŋu wapmaŋu. Yo, dhuwaya ŋayi ŋunhi mayaliꞌya gamꞌ dhiyalamiya dhäwuꞌŋu: Satan-dja, ŋayi ŋunhi ḏäl yolŋu ga ŋarraya ŋunhi wiripu yolŋu ŋunhi ḏapmaŋaya ŋanya Satan-na. Ga dhiyaŋuya bala ŋarra marrtji wapmama ŋarrakuwaya yolŋuna wayana beŋu nhanukaya goŋŋu. ");
INSERT INTO dwy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Dhuwayatja wiripuna yuwalknha yana dhäruk ŋarra yurru ḻakama. Ŋuli nhe yurru yätjkuma waŋa nhanŋu God-Waŋarrwu, mak ŋayi yurru nhuŋu bäy-ḻakama. ");
INSERT INTO dwy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ga ŋuli nhe yurru yätjkuma waŋa nhanŋu Dhuyu Birrimbirrwuya, ŋayiya yurru ŋunhi God-Waŋarryuya yakana nhuŋuya bäy-ḻakama, ga yana bili-i-i ga wäŋa ŋuli dhuwaya dhawarꞌyu!” ");
INSERT INTO dwy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ga bitjaya ŋayi ŋunhi Djesu waŋana, bili waya nhanŋu ŋunhi bitjaya waŋana, “Dhuwayatja yolŋu yätjmi birrimbirrmi.” ");
INSERT INTO dwy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ga beŋuya Djesuwu ŋäṉdiꞌmiŋu ga guthaꞌmiŋu waya nhanŋu ḻarruŋayana. Ŋayŋu waya gurrana djingarꞌdjingaryunana warraŋulnha ŋunhaya buṉbuŋu ŋunhi wanhami ŋayi gurrana marŋgikuŋaya yolŋuna wayana. Ga djuyꞌyuna waya yolŋuna garrꞌyunawu nhanŋu Djesuwu. ");
INSERT INTO dwy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ga balanyamiyu ŋayiya gurrana ŋunhi Djesuya marŋgikuŋayana ŋunhi yolŋuna wayana. Ŋayŋu ŋunhi yolŋuya marrtjinana, bala bitjana waŋa, “Dhuwaya ŋäṉḏiꞌmiŋu nhuŋu ga guthaꞌmiŋu waya ḻarruŋaya gurrana nhuŋu,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ŋayŋu ŋayi Djesuya bitjayana waŋana, “Yol waya dhika ŋarrakuya gurruṯumi?” ");
INSERT INTO dwy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ŋayŋu ŋayi marrtjina nhäŋayana ḻiwꞌmaŋayana ŋunhi yolŋunaya wayana ŋunhi marrtjina ḏäpthuna. Ŋayŋu ŋayi bitjayana waŋana, “Dhuwaya waya dhuwaya ŋarrakuya ŋäṉḏiꞌmiŋu ga guthaꞌmiŋu waya. ");
INSERT INTO dwy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ŋunhi ŋayi ŋula yol yolŋu ŋayaŋu-malthunami God-Waŋarrwu ŋayaŋuwu, ŋunhina ŋayi ŋarrakuya walꞌŋu galkiwuya gurruṯumi.” ");
INSERT INTO dwy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Waŋganymiyu ŋayi Djesu balayi roŋiyina Galilee-yi. Ga guḻkuꞌna dhika wirrkina yolŋuya waya ḻuŋꞌthuna nhanukaya ŋayŋuyi. Ŋayŋu ŋayi ŋunhi marthaŋayina ŋalꞌyuna, ga gaŋga yana waya ḏurꞌyuna marthaŋaya, ŋayŋu ŋayi nhinanana gurrana ŋunhaya. Ga beŋuna ŋayi gurrana ŋunhi marŋgikuŋaya dhäwuꞌya ḻakaŋaya wayaŋgu. ");
INSERT INTO dwy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ga guḻkuꞌ ŋayi gurrana ŋunhi dhäwuꞌya mayaliꞌmiya ḻakaŋaya, märr waya yurru ŋunhi yolŋuya wayay dharaŋan yana. ");
INSERT INTO dwy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yo, ŋäkuna waya: Waŋgany yolŋu djälmiyina ŋayi yurru maŋutji ŋatha djalkthun ŋunha munathaꞌyi märr yurru ŋathaya ŋuthana. ");
INSERT INTO dwy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ŋayŋu ŋayi marrtjina djalkthunana. Ga wiripuya ŋunhi maŋutji galkina märr ŋunha barrkuyi dhukarryi. Ga wayatja ŋunhi wäyindhu nhäŋaya bala ḻukanana marrtjina dhawarꞌmaŋayana. ");
INSERT INTO dwy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ga baḏak yana ŋayi marrtjina ŋunhi ŋuriŋiyi yolŋuyu maŋutji djalkthuna, wiripuya marrtjina galkina bitjayana bala, ga wiripuya galkina guṉḏamiyina wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ga ŋathaya ŋunhi maŋutjiya latjuꞌyinana ŋuthaya waḏutjana, ga ŋunhi ŋayi waluya bitjaya gorrmurꞌyina wirrkiya bala ŋunhi ḏukitja baṉḏanydhinana, gorrmurꞌyinana, bala rakunydhinana, bili guṉḏana ŋunhi, ga bäyŋuna munathaꞌya. ");
INSERT INTO dwy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ga baḏak ŋayi marrtjina bala ŋunhi djalkthuna, ga wiripuya ŋunhi maŋutji galkina ḏirriꞌṯirrimiyi. Ŋayŋu ŋuriŋiya ŋunhi ḏirriꞌṯirriyuya djorkuŋayana, ganydjarrnha dhawarꞌmaŋaya ŋuthanawuna. ");
INSERT INTO dwy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ga wiripuya ŋunhi ŋatha galkina latjuꞌyi munathaꞌyi. Ŋayŋu ŋunhi ŋathaya ŋuthayana buṯ-bitjayana. Ga ŋunhi ŋayi ŋathaya bitjaya latjuꞌyina dhaŋaŋdhina, waŋganybuya gärulwuy gurrana wirrkina yana giḻyuna. Ga wiripuŋumiya-a-a ga guḻkuꞌ yana, ga wiripuŋumiya ga balanya bili, ga ŋayŋuna bala. ");
INSERT INTO dwy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ŋuli nhuma mäkiriꞌmiya, ŋäkuya waya latjuꞌkuŋu, märr nhuma yurru dharaŋan yana dhuwaya dhäwuꞌya.” ");
INSERT INTO dwy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ŋayŋu waya marrtjinana gunhaꞌyunana ŋunhi guḻkuꞌnaya yolŋuna wayana. Ŋayŋu ŋayi gurrana Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu ga wiripu yolŋu waya gänana nhinana. Ŋayŋu waya dhä-wirrkaꞌyunana ŋanya bitjaya, “Go, ḻakaŋuna ŋanapuŋgu wanhakana ŋunhiya dhäwuꞌ mala ŋunhi nhe ḻakaŋaya, bili yaka ŋanapu ŋunhi dharaŋaya. Nhäpuy ŋunhi dhäwuꞌya malanynha?” ");
INSERT INTO dwy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ga ŋayi Djesuya waŋana bitjaya, “Nhumaŋguya dhiyakuya wayaŋgu ŋunhi nhuma ŋuli djämamiyama ŋunhi God-Waŋarrwu rom, ŋarraya yurru warraŋulkumana nhumaŋguya mayaliꞌ. Ga wiripuwuya yolŋuwu ŋunhi ŋayi yaka dhiyalami malaŋu, wayatja yurru ŋunhi dhäwuꞌna yana ŋäma. ");
INSERT INTO dwy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dhuwaya ŋarra yurru ḻakama gamꞌ, märr yurru nhanŋu dhäruktja maḻŋꞌthun God-Waŋarrwu ŋunha djorraꞌŋuna wukirriwuynha yuwalknha yana: Yolŋuya ŋuli ŋunhi nhäma ŋarrana djämayi, yurru yaka waya ŋuli dharaŋandja, nhä ŋunhiya mayaliꞌ. Ga ŋäma warray waya ŋuli mäkiriꞌyu, yurru bäyŋuna bitjan yuwalkumaya dharaŋan. Ga ŋunhi waya beni yuwalk dharaŋana, wayatja beni ŋunhi bilyuna roŋiyinya God-Waŋarrwayana. Yurru yaka waya ŋunhi djäl waya yurru marŋgiyi dhiyaku ŋunhi dhäwuꞌwu. Ga ŋayitja yurru ŋunhi God-Waŋarryuya yakana wayaŋguya bäy-ḻakama.” ");
INSERT INTO dwy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ŋayŋu ŋayi Djesuya wayaŋgu bitjayana waŋana, “Wäy, buku-djulŋimi, yaka nhuma gurra dhuwaya dhäwuꞌya dharaŋan, ŋeniya? Ga ŋuli nhuma yurru yakaya bitjan dharaŋan dhuwaya gumurr-yalŋgiꞌya dhäwuꞌ, ga nhattjana nhuma yurru ŋunhi dharaŋan ŋunha bala wiripuya malanynha dhäwuꞌ? ");
INSERT INTO dwy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dhiyalamiya dhäwuꞌŋu, yolŋu marrtjina maŋutjiwu lämu-nherraṉawu. Ga dhuwayatja ŋayi balanyana, bitjan ŋunhi yolŋu ŋuli marrtji ŋayŋu ḻakama God-Waŋarrnha dhäruk yolŋuwu wayaŋgu. ");
INSERT INTO dwy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yo, ga ŋathaya ŋayi ŋunhi djalkthunaya, ga ḻurrkunꞌtja ŋunhi galkina ŋunha dhukarryina. Ga dhukarrya ŋunhi ḏälnha wirrkina ga yakana ŋayi ŋunhi ŋathaya ŋuthaya. Manymak, ga ŋuriŋiya maŋutjiyu ŋathayu gurra maŋutji-ḻakama God-Waŋarrwuna dhäruk. Ga ḻurrkunꞌthu yolŋuyu wayay ŋuli ŋäma dhäruk nhanŋu ŋayaŋuyu ḏälyu, balanyana bitjan ŋunhiyi ḏäl munathaꞌ. Ga wäyindhu gurra maŋutji-ḻakama Satan-na ŋunhi ŋayi ŋuli djawꞌyun ŋunhiyi dhäruk yolŋuwaya ŋayaŋuŋu. ");
INSERT INTO dwy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ga ŋunhi ŋayi ŋatha galkina ŋunha guṉḏamiyiya, ŋuriŋiya gurra maŋutji-ḻakama ŋunhina yolŋuna ŋunhi ŋayi ŋuli ŋäma dhäruk ŋayaŋuyu latjuꞌyu bala ŋätthuna yana. ");
INSERT INTO dwy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ŋayŋu ŋuli wiripuyuya yolŋuyu nhämana ŋunhi ŋayi ŋuli ŋunhiyi yolŋu märr-yuwalkthi ŋuriki dhärukku, bala ŋayi ŋuli mari-wunana nhanŋu. Ŋayŋu ŋayi yurru ŋunhiya yolŋu gulyuna dhärukŋuya nhanukaya bala ḏiltji-wekamana God-Waŋarrwutja ga dhärukkuya nhanukalaŋuwu, bili ŋatha ŋunhi maŋutji yaka ṉiṉꞌthuna gulŋiyina. ");
INSERT INTO dwy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ga ŋunhi ŋayi ŋatha galkina ḏirriꞌṯirrimiyi, ga gulkuruna ŋunhi ŋathaya ŋuthaya, bili gurra ŋunhi yätjthuya mulmuyu djorkumana. Ga ŋuriŋiya gurra maŋutji-ḻakama ŋunhina yolŋuna ŋunhi waya ŋuli ŋäma God-Waŋarrwu dhäruk, ");
INSERT INTO dwy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bala ŋuli ŋunhi wiripuŋuyuna malanyŋuyu gungama. Wiripuna ga wiripuna ŋuli garrinymama walŋayi, nhäku waya djäl. Ga rrupiyana gurra wirrkina guyaŋi ga be nhäkuna warwuyun, gulkuꞌwuna, girriꞌwu. Ŋayŋu ŋuli ŋunhi dhiyaŋuya malay galmumana God-Waŋarrwayatja dhärukŋu, ga yakana ŋayi yurru ŋunhi nhina latjuꞌkumaya nhanŋuwaya yana God-Waŋarrwuya yolŋu. ");
INSERT INTO dwy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ga dhiyaŋuya dhäwuꞌyu, ŋatha ŋunhi galkina latjuꞌyi munathaꞌyi, ŋunhiya maŋutji ŋuthaya balwakmiyinana latjuꞌyinana, ŋayŋu ŋathamiyinana. Ga dhiyaŋuya gurra maŋutji-ḻakama ŋunhina yolŋuna ŋunhi ŋayi ŋuli ŋäma God-Waŋarrwu dhäruk ŋayŋu ŋuli djämamiyamana yana. Yo, balanyana waya ŋunhi yulŋuya bitjan ŋunhi waŋganybuy gärulwuy giḻyunana gurrana guḻkuꞌna yana wirrkina dhika. Ga wiripuŋuya-a-a guḻkuꞌ yana, ga wiripuŋumiya ga balanya bili.” ");
INSERT INTO dwy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ŋayŋu ŋayi Djesuya bitjayana waŋana, “Ŋunhi ŋuli yolŋuyu baḏayala dhuŋgurꞌyun, yaka ŋayi ŋuli ŋunhi banikinꞌthuya bilkthun, ŋeniya?... wo ŋoyyi betthiya djuḻuḻꞌmama. Ŋunhi ŋayi yurru ŋalꞌmama ŋunha garrwaryi, märr yurru bukmakthu yana nhäma nhäranhaya. ");
INSERT INTO dwy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ga balanyana ŋunhi yulŋuya God-Waŋarrwuya dhäruk. Nhä malanynha gurra ŋunhi ŋoyŋu djuḻuḻꞌyun, ŋunhiya yana ŋayipina yurru God-Waŋarryuna dhawaṯmama, bala bukmakthuya yolŋuyu wayay ŋuli nhäŋuna ŋayŋu marŋgithina. ");
INSERT INTO dwy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Maꞌ, ŋuli nhe mäkiriꞌmiya latjuꞌkuŋu ŋäkuya ŋarrana märr nhe yurru dharaŋan yana. ");
INSERT INTO dwy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ga guyaŋi marrtji dhäruktja ŋarrana. Ŋuli nhe yurru gurra wirrkiya yana ŋarraku mäkiriꞌ-witjun, ŋayiya yurru God-Waŋarryuya nhokaya gathan nhanŋuwaynha dharaŋanami rom, ŋunhi nhe yurru gurra dharaŋana nhäya malanynha ŋunhi latjuꞌya wirrkiya. ");
INSERT INTO dwy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ga ŋuli nhe yolŋu djäl marŋgithinyawu God-Waŋarrwalaŋuwu ŋayaŋuwu, nheya yurru yana gaḏamandhina. Ga ŋuli nhe yurru yakaya bitjan ŋayaŋumiyi, ŋayiya yurru ŋunhi guḻmamana nhuna dharaŋanaŋuya, ga ŋunhiya nhe yurru dhuŋana nhina nhanŋu God-Waŋarrwu.” ");
INSERT INTO dwy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ga bulu ŋayi Djesu waŋana bitjaya, “Marŋgithi nhuma yurru nhattjan ŋuli gurra God-Waŋarryu gurruṯumina wayana ŋuthanmama. Yo, dhuwayatja dhäwuꞌ mayaliꞌmina: Yolŋu djälmiyina ŋayi yurru ḻämu-nherraṉ maŋutji ŋatha, ŋayŋu ŋayi ŋuli marrtjina ŋunhi ŋathaya djalkthuna munathaꞌyina, bala gunhaꞌyuna ŋuli ŋunhi maŋutjiya ŋunhimana, ga marrtjina wäŋayina. ");
INSERT INTO dwy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Manymak, munha ga munha djuḻkthuna ga yakana ŋayi gurrana ŋuriŋiya yolŋuyu guyaŋinaya ŋunhiya maŋutjiya ŋathaya. ");
INSERT INTO dwy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ŋayŋu marrtjina ŋunhi maŋutjiya mala ŋuthana gänana yana. Yo, bala ŋunhi ḏukitja dhamanyꞌtjunana, bitjaya ŋurru-walmanana. Ga yaka wiyinꞌtja, ŋayŋu yaŋaraꞌmiyinana, ga yurruna muḻkurrya ŋathamiyina. ");
INSERT INTO dwy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ga ŋunhi ŋathaya muḻkurrya ḏälthina, ŋayŋu yolŋuya ŋuli marŋgithina ŋunhi ŋathaya bilina latjuꞌthinana, ŋayŋu ŋayi ŋuli marrtjina gulkthunawuna ŋurikina ŋathawuna. Waya, God-Waŋarryu dhuwaya ŋayipi ŋuli marrtji djäma bitjan ŋuthanmama.” ");
INSERT INTO dwy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ga bulu ŋayi Djesuyu ḻakaŋaya wiripu mayaliꞌmi dhäwuꞌ bitjaya, “Dhuwaya ŋarra gurra wiripu dhäwuꞌ nhumaŋgu guyaŋina, ŋunhi yurru nhumana guŋgaꞌyun märr nhuma yurru dharaŋan, nhattjan yurru gurra God-Waŋarrwu gurruṯumi waya ŋuthan. ");
INSERT INTO dwy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","God-Waŋarrwutja dhuwaya gurruṯumi yolŋu waya balanya bitjan yutjuwaḻaꞌna wirrkina maŋutji. ");
INSERT INTO dwy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ga ŋunhi yurru ŋunhiyi maŋutji galki munathaꞌyi ŋayŋu yurru ŋunhi maŋutjiya ŋuthana marrtji buṯ-bitjana ga yana bili ga bathalayi yurru, ŋayŋu yurru baṉdjaya mala ḏälthina. Ga ŋurrŋgitjnha ŋunhi yulŋuya. Ŋayŋu yurru wäyindja marrtjina ŋayŋu yaluna ŋamaŋamayun ŋunhimaya warrawꞌyi. Yo, bitjana yurru ŋunhi God-Waŋarrwuya yolŋu waya gurruṯumi ŋuthan marrtji, bathalayina yana mala.” ");
INSERT INTO dwy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yo, bitjayana ŋayi gurrana ŋunhi Djesuyu marŋgikuŋayatja yolŋuna wayana. Ga guḻkuꞌmi ŋayi gurrana dhäwuꞌ mala mayaliꞌmi ḻakaŋaya. ");
INSERT INTO dwy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ga ŋunhi waya gurrana wayawuy mala nhinana, Djesu ga ḻuṉḏuꞌmiŋu waya yana nhanŋu, ŋayiya ŋuli wayaŋgu mayaliꞌ bitjana dhawaṯmanha. ");
INSERT INTO dwy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ga ŋunhi marrtjina waluya gulŋiyina ŋayiya gurrana baḏak yana Djesuya nhinana marthaŋaŋu. Ŋayŋu ŋayi waŋana nhanukalaŋuwu ḻuṉḏuꞌmiŋuwu wayaŋgu bitjaya, “Go, ŋilimu marrtjina dhiyaŋu marthaŋayuna ŋunha galiꞌyina.” ");
INSERT INTO dwy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ŋayŋu wayatja ŋunhi ḻuṉḏuꞌmiŋuya waya ŋalꞌŋalyunana ŋayŋu marrtjinana. Ga gunhaꞌyuna waya ŋunhi guḻkuꞌna yolŋuna wayana bäymayi. Ga wiripu yolŋu waya marthaŋami malthuna wayaŋgu. ");
INSERT INTO dwy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Ŋayŋu ŋayi ŋunhi Djesuya gayŋithinana ŋunhaya dhuḏiŋuna marthaŋaŋu, muḻkurr ŋayi belayi ŋalꞌyuna bala gayŋithinana. Ga gandarrŋuya bala watana bathalana wirrkina bunana wayaŋgu, buŋayana wayana marrtjina, ga ḏowuya gurrana wapthuna ŋayŋu gapuya dhaŋaŋdhinana marthaŋaŋuya, galki beni ŋunhi marthaŋaya guḻwuḻyunana. Ga wayatja ŋunhi ḻuṉḏuꞌmiŋuya waya nhanŋu wirrkina yana biyaṉiyina, ŋayŋu waya gurrana dhirrꞌyuna Djesuna, “Wäy Marŋgikunhami gaŋgathina, rakunydhina ŋilimu yurru, guḻwuḻyuna ŋilimu yurru... yakana nhe gurra dhuwaya warwuyundja, ŋeniya?” ");
INSERT INTO dwy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ŋayŋu ŋayi Djesuya gayŋiŋuya gaŋgathinana bala dhunupa yana ŋayi waŋana ḏälyuna dhärukthu watanaya, “Gulyuna!” ga ḏowuwuya ŋayi bitjaya waŋana, “Ḻinyguna gulyuna!” bitjaya. Ŋayŋu dhunupa yana ŋunhi wataya gulyunana boꞌyunaŋuya ga ḏowuya marrtjina nyimdhunana bala wapurarrnha gurrana dhärrana. ");
INSERT INTO dwy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ŋayŋu ŋayi Djesuya waŋana wayaŋgu bitjayana, “Nhäku nhuma biyaṉiyinaya?... yaka nhuma gurra ŋarrakuya märr-yuwalkthi?” ");
INSERT INTO dwy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ŋayŋu wayatja ŋunhi wirrkina biyaṉiyina, maŋmaŋdhuna manapaya ŋayŋu marrtjina bitjayana waŋanhamina, “Nhäŋaya nhuma? Ŋunha watayuya ga gapuyuya ŋäkuya ŋanya dhäruk waŋanhaya! Dhuwayatja yuwalknha ganydjarrmina yolŋu!... ŋe?” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Djesu ga nhanŋu ḻuṉḏuꞌmiŋu waya buḏapthunana ŋuriki Galilee-wu guḻunꞌku, ga dhawaṯthunaya waya ŋunha galiꞌyina galki yana wäŋaŋu yäkuŋu Garasa. ");
INSERT INTO dwy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Ga ŋunhi ŋayi Djesu marthaŋaŋuya yupthuna ga yolŋuyu yätjmiyu birrimbirrmiyu ŋanya nhäŋaya, yurru walmanaya ŋayi ŋunhi beŋu bäyma moluŋu, ŋunhi ŋayi gurrana nhinana ŋunhayayi wiyinŋumi. Ga guḻkuꞌmi gurrana yolŋuyu wayay garrwiꞌyuna ŋanya djeṉdhu malanyŋuyu, ga ḻuku nhanŋu wiripuya ŋuli ḏapmanha, yurru gulkuruna, ŋayiya gurrana ŋuli ḏawꞌyuna, ga yupmanha. Ga bäyŋuna ŋayi gurrana ŋula yolkaya yolŋuwaya ganydjarryuya nhinana. Bitjaya bili munha-ŋupaya ga walu-ŋupaya ŋayi ŋuli buku-wirwiryunaya ŋulana bäymana bukukuna molumikuna girriꞌmiriwnha, yatjuna ŋuli ga miṯmiṯthunminya guṉḏayu raywalꞌyu. Manymak, ga ŋunhi ŋayi ŋuriŋi ḏarramuyu nhäŋaya Djesunaya ŋunhaŋga yana barrkuyi bala yana waṉḏinana gumurrꞌyunana bala bunꞌkumu-djipthuna gumurryina nhanukaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ga bitjaya ŋayi Djesu waŋana ŋuriki yätjkuya birrimbirrwu gamꞌ, “Way! Gatjuy dhawaṯthu dhiyakaya yolŋuwaya, maꞌ,” bitjaya. Ŋayŋu ŋayi ŋunhi yätjtja birrimbirr waŋana yatjunana, “Djesu! Gäthuꞌmiŋu God-Waŋarrwu, ŋunhi ŋayi djiwarrꞌwuy, nhattjana nhe yurru ŋarrana dhuwaya yulŋuya? God-Waŋarrwaya yäkuyu ŋarra nhuna gurra ŋäŋꞌthun, yaka ŋarrana baḏuwaḏuyu.” ");
INSERT INTO dwy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ŋayŋu ŋayi Djesuyuya dhä-wirrkaꞌyunana ŋanya bitjaya, “Yol nhe dhuwaya yäkuya?” bitjaya. Ga ŋayiya ḻakanhamina bitjaya, “Ŋarraya dhuwaya yäku Mala-Guḻkuꞌ, bili guḻkuꞌna wirrkina ŋarrakaya gurra yätjtja birrimbirr malanynha nhina,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ŋayŋu gurrana ŋunhi yätjtja birrimbirr mala ŋurikaya ḏarramuwayatja buku-ḏuwaṯthunana waŋana Djesuwuya bitjayana, “Yaka ŋanapuna ŋaŋꞌŋaŋdhu dhipuŋu wäŋaŋu!” ");
INSERT INTO dwy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Manymak ga ŋunhaya bili galki yana bukuŋu 2,000 bikipiki malanynha gurrana ḻarruꞌḻarruŋaya ŋathawu. ");
INSERT INTO dwy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ŋayŋu ŋuriŋiya yätjthuya birrimbirryu malanyŋuyu waŋana wirrkina Djesunaya bitjaya, “Wäy, ŋayŋuna ŋanapuna djuyꞌyu, märr ŋanapu yurru gärri ŋunha bikipikiwayana,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ga ŋunhi ŋayi Djesuyu ŋäkuya wayana ga bitjayana ŋayi waŋana, “Maꞌ... marrtjina waya!” Ŋayŋu gurrana ŋunhi yätjtja birrimbirr mala walmana ḏarramuwayatja ŋayŋu gulŋiyina bikipikiwayana. Ŋayŋu gurrana ŋunhi bikipikiya mala waṉḏinana, ḏurꞌṯuryunmina marrtjina, ŋayŋu gurrana ḻarryuna bukuŋuya, gapuyina guḻunꞌthina yana, bala gurrana guḻwuḻyunana. ");
INSERT INTO dwy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ga waya ŋunhi bikipiki djäkami waya waṉḏina ŋayŋu wäŋayina malaŋuyi, ŋayŋu waya marrtjina ḻakaŋayana bukmakkuna yana ŋunhi nhä gurrana ŋunhaya maḻŋꞌthuna. Ga guḻkuꞌyu yolŋuyu wayay gurrana gunhaꞌyuna wayaŋgu wäŋa malanynha, djälmiyina waya ŋunhi nhänharaw ŋuriki ŋunhi nhä ŋunhaya maḻŋꞌthuna. ");
INSERT INTO dwy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ga ŋunhi waya marrtjina Djesuwaya, ŋayŋu waya nhäŋayana ŋunhiya ḏarramuna ŋunhi nhanukaya gurrana ŋäthiyi nhinana guḻkuꞌna wirrkina yätj birrimbirr malanynha. Ga nhinana ŋayi gurrana muḻkurr latjuꞌna ga girriꞌmina dhaṯthunminyayana. Ga ŋunhi waya yolŋuyu wayay nhäŋaya, ŋayŋu waya yana biyaṉiyinana, bili waya yana dharaŋayana ŋunhi yurru gurra bitjandja yolŋuyu yätjtja birrimbirr dhawaṯmama balanyaya ŋunhi yolŋu buluna walꞌŋu ganydjarrmi. ");
INSERT INTO dwy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ga wayatja ŋunhi maŋutji-marŋgimiyuya gurrana dhäwuꞌna ḻakaŋaya wiripuwuna yolŋuwu wayaŋgu nhanukalaŋuwuy ŋunhi ḏarramuwalaŋuwuynha ga bikipikiwalaŋuwuynha. ");
INSERT INTO dwy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ŋayŋu wayatja ŋunhi yolŋuyuya wayay gurrana waŋana ŋanya Djesuna marrtjinyawuna yana. ");
INSERT INTO dwy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ga dhiyaŋuŋga bili ŋayi Djesu ŋalꞌyuna marthaŋayiya, ŋayŋu ŋayiya ŋunhiya ḏarramu ŋunhi nhanukaya gurrana ŋäthiyi nhinana yätj birrimbirr mala, waŋana gurrana wirrkina dhika bitjaya, “Dhuwaya ŋarra yurru nhuŋu malthuna yana!” ");
INSERT INTO dwy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yurru ŋayiya Djesuya yakaꞌyuna nhanŋu, ga waŋana ŋayi nhanŋu bitjaya, “Gatjuy nhe ŋayŋuyi ŋäthiyi roŋiyi gurruṯumiwu nhokalaŋuwu, ga ḻakaŋu wayaŋgu ŋunhi nhä nhuŋu God-Waŋarryu manymak djäma ga nhattjaya ŋayi nhuŋu maŋutji-wuyuna.” ");
INSERT INTO dwy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ŋayŋu ŋayi ŋunhi ḏarramuya marrtjina roŋiyinana ŋayŋu makarryi wäŋayi Decapolis-thi, ŋayŋu yana marrtjina ḻakaŋayana bukmakkuna, ŋunhi nhattjaya ŋayi Djesuyu djäma nhanŋu. Ga bukmakthu ŋunhi yolŋuyu wayay ŋäkuya dhäwuꞌ nhanukalaŋuwuy ganyimꞌthunana. ");
INSERT INTO dwy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ga dhurrwaraŋu beŋuya ŋayi Djesu ga ḻunḏuꞌmiŋu waya nhanŋu bunana marthaŋayuna ŋunha galiꞌyina ŋuriki guḻunꞌku, yäkuŋu wäŋaŋu Capernaum-nha. Ga ŋunhi waya gurrana marthaŋaŋuya yupthuna, ga malamina ŋunhi yolŋuya waya ḻuŋꞌthuna nhanukaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ga ŋunhayayi malaŋu gurrana yolŋu yäku Jairus djingaryuna ŋunhi ŋayi ŋurru-ḏawalaŋu Jew-wu biryamiwu buṉbuwu. Ga ŋunhi ŋayi Djesunaya nhäŋaya, ŋayŋu yana ŋayi marrtjinana bala bunꞌkumu-djipthunana munathaꞌyina gumurryina nhanukaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ŋayŋu ŋayi gurrana waŋana wirrkina Djesuwayana bitjaya gamꞌ, “Marrkapmi! Yothu ŋarraku ŋunha miyalk 12-mi dhuŋgarrami rirrikthun gurra, galki ŋayi yurru ŋunha rakunydhina! Buku-djulŋi, ŋäthiyi marrtji go, ga goŋ-ŋalꞌyu nhanukaya märr ŋayi yurru latjuꞌyi, ga yakana rakunydhiya.” ");
INSERT INTO dwy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ga marrtjina ŋayi Djesuya malthuna nhanŋu Jairus-kuna. Ga guḻkuꞌ ŋunhi wirrkina yolŋuya waya gurrana malthuna maṉḏaku yurru ḏurꞌṯuryunminana waya marrtjina. ");
INSERT INTO dwy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ga ŋunhayayi malaŋu gurrana marrtjina miyalk, yurru ŋayi ŋunhi ŋaraka-djetjiꞌmi. Ga märr wiyinŋumi ŋayi ŋunhi 12-nha dhuŋgarra rirrikthunaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Guḻkuꞌmi ŋayi gurrana marrtjina marrŋgitjkaya wayaŋgaya guŋgaꞌyunawu yurru gulkuruna. Ga warrpamꞌthunana ŋayi ŋuli rrupiya nhanŋuway djalkthuna wayaŋgaya, yurru bäyŋuna ŋayi ŋunhi yuwalktja latjuꞌyina, ga rerriya marrtjina ŋunhi wirrkina bathalayina. ");
INSERT INTO dwy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Ga ŋunhi ŋayi ŋuriŋi miyalkthu ŋäkuya Djesunaya, ŋayŋu ŋayi bitjayana guyaŋina, “Ŋuli ŋarra yurru girriꞌya nhanŋu mulka ŋarraya yurru yana latjuꞌyina.” Ŋayŋu yana ŋayi marrtjina ḏiltjikuna dhaḻakarr-yarpuŋaya yolŋuwaya wayaŋgaya malakuyu. Ga ŋunhi ŋayi goŋ-djarryunaya baṯnha mulkana girriꞌya nhanŋu. Ŋayŋu dhunupana nhanŋu ŋunhi ŋurru-yätjtja gulyunana, ŋayŋu ŋayi dhäkay-ŋäkuya ŋunhi rerriꞌyuya ŋanya gunhaꞌyunana. ");
INSERT INTO dwy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ga balanyamiyu bili yana ŋayi Djesuyuya dhäkay-ŋäkuyana nhanukiyingaya ŋayi rumbalyu, ŋunhi ganydjarryuya ŋanya gunhaꞌyunana. Ga gulyunana ŋayi, bala gumurr-bilyuna ŋayŋu dhä-wirrkaꞌyunana wayana bitjayana, “Yolthu ŋarraku girriꞌya mulkana?” ");
INSERT INTO dwy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ga waya ŋunhi ḻuṉḏuꞌmiŋuya waya nhanŋu waŋana bitjaya, “Nhäŋu ŋäthiyi dhuwaya yolŋuna waya mala, ŋapa-ŋalꞌŋalyunmina marrtji ḏurꞌ-ṯuryunmina nhokaya. Nhäku nhe bitjayatja waŋana, guḻkuꞌna dhuwaya wirrkina yolŋuya waya,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ŋayŋu ŋayi Djesuya bilyunana bala marrtjina nhäŋayana yolŋunaya wayana, märr ŋayi yurru maḻŋꞌmama yolthu nhanŋu girriꞌ mulkana. ");
INSERT INTO dwy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ga dhunupana yana ŋunhi miyalktja marŋgithinana bala marrmarryunana marrtjina biyaṉiyuna nhanukiyingaya ŋayi, bala yana djalkiri-dhatharꞌyuna ŋayŋu yana bunꞌkumu-djipthuna gumurryina nhanukaya Djesuwaya bala ḻakanhamina, “Marrkapmi, ŋarra ŋunhi nhuna mulkanaya.” ");
INSERT INTO dwy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ŋayŋu ŋayi Djesuya waŋana nhanŋu bitjayana, “Wäy... gäthu, bilina nhe ŋarraku märr-yuwalkthinana, ga bilina nhe dhuwaya walŋathinana rerriŋuya. Gatjuy marrtjina ŋoy-layuna bilina nhe dhuwaya walmanana beŋuya rerriꞌŋuya romŋu,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ga ŋayiya gurrana ŋunhi Djesuya baḏak yana waŋana, ŋayŋu wayatja ŋunhi yolŋuya waya marrtjina dhäwuꞌmiya beŋu Jairus-kayatja wäŋaŋu, ŋayŋu waya ḻakaŋayana bitjayana, “Wäy... wäŋaya dhuwaya ŋonuŋ. Yakana buluya dhuwayi Marŋgikunhaminaya ḻayḻaymaŋu,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ga ŋayiya ŋunhi Djesuyuya wayana djuḻkmaŋaya ŋäkuya, bala ŋayi bitjayana Jairus-kuya waŋana, “Yaka warwuyu ga biyaṉi, yana märr-yuwalkthi ŋarraku,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ŋayŋu ŋayi Djesuya bitjana waŋa, “Gulyuna nhuma wiripuya waya ga dhuwaya yurru ŋaliŋguya malthun wayawuynha yana Peter-na ga maṉḏana wäwaꞌmanydji James-nha ga John-nha ga ḻinyguna.” ");
INSERT INTO dwy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ga ŋunhi waya Jairus-kaya wäŋaŋu bunana bala waya nhäŋayana yolŋuna wayana waya marrtjina djämana dhika wiripuna ga wiripuna ŋurikina bäpurruꞌwuna romgu. Ga wiripuya yolŋu waya gurrana ŋäthinyamina, wiripuya nhinana gurrumꞌnha ŋäthina ga wiripuya dhä-rirrakaymina manikaynha yuṯuŋgurrnha ḻakaŋaya. ");
INSERT INTO dwy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ŋayŋu ŋayi Djesuya gulŋiyina ŋayŋu wäŋayina, ŋayŋu ŋayi waŋana wayaŋgu bitjayana, “Nhä nhuma gurra dhuwaya djämaya, nhä nhuma guyaŋinaya yana beni dhuwaya bäpurruꞌna? Ga nhäku nhuma gurra dhuwaya ŋäthinyamiya? Dhuwaya wirrkuḻ yothu yaka ŋayi rakuny, dhuwaya ŋayi gurra yakurr yana gayŋithi.” ");
INSERT INTO dwy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ga wayatja ŋunhi yolŋuꞌ-yulŋuyuya warkuꞌyuna, gitkitthunmina manapaya nhanŋu. Ŋayŋu ŋayi gurrana Djesuyuya gukuŋayana wayana bitjayana, “Gatjuy nhumaya bukmaknha yana walmina.” Ŋayŋu waya bukmaknha yana dhawaṯthuna buṉbuŋuya. Manymak, ga garrꞌyunaya ŋayi ŋäṉḏiꞌmiŋuna yana ga bäpaꞌmiŋuna Jairus-nha ga ḻurrkunꞌnhana guyurrꞌmiŋuna wayana nhanŋuway, bala waya garriꞌkarrina ŋunhima buṉbuyina ŋunhi wanhami gurrana yothu wirrkuḻ gayŋithina. ");
INSERT INTO dwy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ŋayŋu ŋayi Djesuyuya goŋnha ŋanya mulkana ŋunhina wirrkuḻnhaya bala waŋana nhanukaya dhärukkuyuna Arram-guyuna, “Dalitha gom!” (Mayaliꞌ “Wirrkuḻ gaŋgathina!”) ");
INSERT INTO dwy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Ga dhunupana yana ŋayi ŋunhi wirrkuḻya gaŋgathinana, bala yana marrtjiꞌmarrtjinana. Ŋayŋu ŋayi Djesuya waŋanana, “Gatjuy ŋula nhä waya nhanŋu wekuŋu ŋayi ḻukana,” bitjaya. Ga bukmakthuna ŋunhi nhäŋaya ŋayaŋu-ṉirryunami rom, ŋayŋu ŋayi Djesuya waŋana wayana wirrkina yana bitjaya, “Yaka yana ḻakaŋu ŋula yolku yolŋuwu dhiyakuwuyya,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ŋayŋu ŋayi Djesuya marrtjina gunhaꞌyunana ŋunhiya wäŋa Capernaum-dja, roŋiyina nhanukiyingayana wäŋayi Nazareth-dhina, ga bukmak yana ḻuṉḏuꞌmiŋuya waya nhanŋu malthunmina. ");
INSERT INTO dwy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ga wiripuŋuyu Jew-waya Nhinanhamiyu Waluyu, ŋayi gurrana Djesuya marŋgikuŋaya guḻkuꞌna yolŋuna wayana ŋunhaya ŋunhi biryamiŋuna buṉbuŋu. Ga ŋunhi waya gurrana ŋäkuya ŋanya ŋunhi nhä ŋayi gurrana wayana marŋgikuŋaya, ŋayŋu waya bitjayana waŋanhamina, “Wäy, dhuwayatja yolŋu gaḏamanha. Wanhami ŋayi gurrana dhuwaya marŋgithinaya dhiyakuya malawu? Ga wanhaŋu ŋayi gurrana dhuwaya ganydjarrya ŋätthuna djämawu ŋayaŋu-ṉirryunamiwuya romgu? ");
INSERT INTO dwy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dhuwayatja dhuwaya ŋunhi buṉbu-dhuḻꞌyunami warray yolŋu! Dhuwaya ŋilimuya dhiyakuwuynha bili wäŋapuy yana, ga marŋgi ŋilimu nhanukalaŋuwu ŋäṉḏiꞌmiŋuwuya Mary-wuya. Ga marŋgi ŋilimu nhanukalaŋuwu wäwaꞌmiŋuwuya wayaŋgu yäkuwu James-ku ga Joseph-ku ga Judas-ku ga Simon-gu, ga marŋgi ŋilimu nhanukalaŋuwu yapaꞌmiŋuwuya wayaŋgu.” Ŋayŋu gurrana ŋunhi yolŋuya waya nhanŋu yakana märr-ŋamathinaya, ŋurru-wilꞌwilyunana waya gurrana nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yurru ŋayi Djesuya waŋana bitjaya, “Ŋunhi ŋuli God-Waŋarrwuya djawarrkmi yolŋu marrtji wiripumaya wäŋayi ga wayatja ŋunhi wäŋa-waṯaŋumiyuya yolŋuy wayay dhäruk ŋätthun ga gumurr-ŋamathi nhanŋu. Ga ŋunhi ŋayi yurru marrtji nhanukiyingayatja wäŋayi, ga nhanukalaŋuwu gurruṯumiwu yolŋuwu buna, ga wayatja yurru ŋunhi yakana dhäruk-ŋätthun ga märr-yuwalkthi nhanŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Ga ganyimꞌthunana ŋayi ŋunhi Djesuyuya nhäŋaya, bili yolŋuya waya ŋunhi ŋayaŋuya-ḏälthinana ga yakana waya gurrana ŋunhi buluya märr-yuwalkthina. Ga yakana ŋayi gurrana ŋunhi ganydjarrmiya rom bäki wirrkiya, ḻurrkunꞌnha yana, yana ŋayi marrtjina waŋgaꞌ-waŋganygayana goŋ-ŋalꞌyunaya yolŋuwaya rerrimiwaya, bala yana wayatja walŋathinana. ");
INSERT INTO dwy_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Ŋayŋu ŋayi marrtjina Djesuyuya marŋgikuŋayana yolŋuna wayana buku-ḻiwꞌmaŋaya ŋunha yuṯuŋgurrŋu wäŋaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ga ḻuŋꞌmaŋaya ŋayi ŋunhi 12-nha ḻuṉḏuꞌmiŋuna wayana nhanŋuway ŋayi, ŋayŋu ŋayi ganaŋꞌthunmaŋayana wayana bulalꞌ ga bulalꞌ ga bulalꞌ, ga bitjayana ŋayi ŋunhi waŋanaya wayaŋgu, “Maꞌ, marrtjina waya wäŋayina malanyŋuyi ga marŋgikuŋuna yolŋunaya wayana God-Waŋarrwuna. Ŋarra nhumana gurra dhuwaya ganydjarrya wekamana nhuma yurru dhawaṯmamana yätjtja birrimbirr mala. ");
INSERT INTO dwy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ga yaka ŋätthu guḻkuꞌya girriꞌ bili ŋayi yurru nhuŋu God-Waŋarryu djäma ŋäthiyi. Dharpa yana ŋätthu gaṉdjiꞌyunawu ga djalkiriwuy dhuwayi ḻukuŋu nhokaya ga dhuwanna bili girriꞌya dhuwayyi galŋaŋu nhe gurra gäma. Ga yaka gäŋu ŋula nhä ŋatha ga rrupiya ga ŋula nhä bathi. ");
INSERT INTO dwy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ga ŋuli nhuma yurru bunaya birrkaꞌmiŋu wäŋaŋu ga wäthun ŋunhi waya yurru nhumaŋgu gumurr-ŋamathiya bitjandja waŋa, ‘Go, ŋunhaya nhuma yurru ŋarrakaya buṉbuŋu gayŋithi,’ nhumaya yana marrtjina ga yukirri ŋunhayana buṉbuŋu ga yana bili-i-i, ga djäma nhumaŋgu yurru dhawarꞌyun, ga yurruna wayana gunhaꞌyu. ");
INSERT INTO dwy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ga ŋunhi nhuma yurru buna birrkaꞌmiŋu wäŋaŋu ga yaka nhumaŋgu yurru ŋunhi wäŋa ŋurikiwuy yolŋu waya gumurr-ŋamathi, ga yaka waya yurru ḏukṯukmiyi ŋänharaw nhuŋu, nhumaya yurru gunhaꞌyuna yana ŋunhiya wäŋa bala munathaꞌya ḻukuŋuya djalk-tjalkthuna ŋurikiwuy wäŋawuy, ga biyakuna waŋi wayaŋgu, ‘Dhuwaya nhuma yaka djälmiyina ŋarraku mäkiriꞌ-witjunawu, ga ŋunhi yurru ŋula nhä mari nhumaŋgu malŋꞌthun, ŋunhiyiya nhumaŋguwaynha mari,’ biyakuna waŋi, ga yaka ḏawaꞌyu, yana ŋapa-wilꞌyuna wayaŋgaya.” ");
INSERT INTO dwy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yo, bala waya ŋunhi ḻuṉḏuꞌmiŋuya waya marrtjina barrkuwatjthinana bulalꞌ ga bulalꞌ wiripumana ga wiripumana wäŋayi, ga ŋunhayana waya ḻakaŋaya dhäwuꞌya yolŋuꞌ-yulŋuwuya bitjaya, “Gulyuna waya dhuwurr-yätjŋuya nhumaŋgaya nhuma, bala malthuna God-Waŋarrwuna yuwalkŋuwuna dhukarrwu.” ");
INSERT INTO dwy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ga guḻkuꞌna wirrkina waya gurrana ŋunhi yätjtja birrimbirr malanynha dhawaṯmaŋaya yolŋuwaya wayaŋgaya. Ga guḻkuꞌwaya ŋunhi rerrimiwaya waya gurrana wekaꞌ rarryuna muḻkurryi yurru ḻurrkunꞌ yana, yaka guḻkuꞌ, märr waya yurru latjuꞌyina. ");
INSERT INTO dwy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ga ŋulinyamiyu waluyu guḻkuꞌyuna gurrana ŋunhi yolŋuyu wayay Djesuwalaŋuwuya dhäwuꞌ ŋäkuya. Ga ŋayi ŋunhi yindiyu buŋgawayu yäkuyu King Herod-thuya ŋäkuya yana ganydjarr nhanukalaŋuwuy. Ga bitjayana gurrana ŋunhi wiripuya yolŋu waya waŋana, “Dhuwaya ŋayi John ŋunhi Buku-ḻupthunami, yurru Djesu-gunhaminana ŋayi rumbalya, dhuwaya ŋayi yawungu bulu walŋathi rakunyŋuyu, ga dhiyaŋuna ŋayi gurra dhuwaya Djesuyu ŋuli ŋayaŋu-ganyimꞌthunamiya rom djäma.” ");
INSERT INTO dwy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ga wiripu yolŋu waya gurrana waŋana bitjanmina, “Dhuwaya mak Elijah ŋeniya ŋunhi God-Waŋarrwuna djawarrkmi ŋäthiliŋuna?” Ga bulu wiripu yolŋu waya waŋana bitjaya, “Yaka dhuwaya Elijah, dhuwayatja ŋula yol wiripu God-Waŋarrwu djawarrkmi ŋäthiliŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ga ŋunhi ŋayi Herod-thu ŋäkuya ŋunhi ŋhä marrtjina yolŋu waya ḻakanhamina, bala ŋayi yana dhäruk wekaŋaya bitjayana, “Dhuwanna John-dja ŋunhi Buku-ḻupthunamiya yolŋu. Ga bili ŋarra ŋunhi ŋäthiyi yana dhäruktja-wekaŋaya ŋarrakalaŋuwu djämamiwu wayaŋgu bitjaya, ‘Gatjuy gupana waya ŋanya gulkthu.’ Ga dhuwaya ŋayi, bilina walŋana.” ");
INSERT INTO dwy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Yo, bitjaya ŋayi ŋunhi maḻŋꞌthunaya gamꞌ ŋäthiyiya. Ŋurikiya yindiwuya buŋgawawu yäkuwu King Herod-ku gurrana yukuyukuꞌmiŋu nhinana yäku Philip, ga miyalk nhanŋu yäku Herodius. Ŋayŋu ŋayi ŋuriŋi yindiyu buŋgawayu King Herod-thuya gumbuŋayana ŋunhi yukuyukuꞌmiŋuwuya miyalknha. Manymak, guḻkuꞌmi ŋayi gurrana John marrtjina ga waŋana maŋutji-yunupa Herod-ku bitjaya, “Yaka nhe djawꞌyu dhuwayi yukuyukuꞌmiŋuwu nhokalaŋuwu miyalknha. Dhuwayitja nhe gurra ḏawꞌyuna ŋilimuŋgu romnha, Jew-wuna bäpurruꞌwu.” Yurru ŋayi ŋunhi Herod-thuya ŋätthunana yana ŋunhi miyalknha. Ŋayŋu ŋayi ŋunhi dhäruktja-wekaŋaya djämamiwaya wayaŋgaya waya yurru John-na gärrinymama dharruŋguyina. ");
INSERT INTO dwy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ga bitjaya bili ŋayi gurrana ŋunhi John-dhuya ŋayaŋu-yätjkuŋaya waŋana, ŋayŋu marrtjina ŋunhi miyalktja ŋoy-dhärranana nhanŋu John-guya, ga ḏukṯukmiyinaya ŋayi gurrana ŋunhi wirrkina yana murrkayꞌkunhawuna yana baymatthunawu nhanŋu, yurru bäyŋu ŋayi ŋula dhukarr maḻŋꞌmaŋaya. Ŋayŋu ŋayi Herod-thuya gurrana mulkanana John-naya dharruŋguŋuna, ");
INSERT INTO dwy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ga bitjaya ŋayi ŋunhi dhäruk-wekanhamina djäkamiwayatja gamꞌ, “Dhiyakuya nhuma yurru gurra latjuꞌkuma yana djäka.” Ga wirrkina ŋayi ŋunhi yindiyuya buŋgawayu Herod-thuya waŋana John-naya märryu-ḏapmaŋaya ga beyaṉiyina manapaya. Ga marŋgi ŋayi ŋunhi, ŋanya God-Waŋarryu lili djuyꞌyuna ga nhäwi ŋayi ŋunhi ŋayaŋu-dhunupa balanya latjuꞌ yolŋu. Ga djäl ŋayi ŋunhi wirrki yana nhanŋu ŋayi yurru gurra ŋäma ŋanya dhäwuꞌyi ḻakanhayi. Yurru guḻkuꞌmi ŋayi gurrana ŋunhi John-dhu ŋayaŋu-yätjkuŋaya ŋanya ŋunhi ŋayi ŋuli waŋanha dhäwuꞌ ḻakanha. ");
INSERT INTO dwy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Manymak, ga waŋganymiyu waluyu waya marrtjina ḻuŋꞌthuna ŋathawuna ḻukanhawu, ga ŋuliwitjaya waya guyaŋina ŋunhi Herodku dhawal-wuyaŋinyami walu. Manymak, ga balanyamiyu ŋayi ŋunhi miyalkthu yäkuyu Herodius-thu guyaŋina bitjayana, “Yä-a-a, dhuwaya ŋarra yurru buku-roŋinymamana ŋurikiwuy John-guna, ŋunhi ŋayi nhattjaya John-dhu gulinybuŋaya Herod-nha ga ŋarrana.” Ga guḻkuꞌ waya marrtjina ŋathawu lukanhawu balanya bitjan ŋurru-warryunayŋu gapman waya, ga maḏakarritjmiwu miriŋuwu wayaŋgu buŋgawaꞌmiŋu ga ŋaḻapaḻmi ŋurukuwuynha makarrwuy wäŋawuy Galilee-wuynha. ");
INSERT INTO dwy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yo, ḻukanaya waya marrtjina ŋathaya ga gapuya, ga ŋunhaya gurrana wirrkuḻ miyalk giritjina, yurru ŋayi ŋunhi wakuꞌmiŋuya ŋuriki miyalkku Herodius-ku. Yo, giritjina ŋayi gurrana ŋunhi wirrkuḻ miyalk latjuꞌkuŋayana dhika. Ŋayŋu ŋayi ŋunhi yindiya buŋgawa Herod-tja ga yolŋu waya wirrkina maŋmaŋdhuna nhanukaya buŋgulyu. Ŋayŋu ŋayi Herod-tja wätthunana nhanŋu bitjayana, “Ŋuli nhe yurru ŋarrana ŋäŋꞌthun ŋula nhäku nhe djäl, ŋarraya yurru yana wekamana nhuŋu. ");
INSERT INTO dwy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ga ŋuli nhe djäl ŋarra yurru mala-wulkthun bukmaknha yana, ga wanhaka wäŋa makarr malanynha ŋarrakaya goŋŋu, ŋarraya yurru yana gulkthuna nhuŋuya ga ŋarrakuway. Ga ŋunhi yurru dhuwayi bäyŋuya bitjan malŋꞌthun, ŋarra yurru ŋäŋꞌthun ŋayi yurru ŋarrana God-Waŋarryuya dhä-dirꞌyuna yana.” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ga ŋayiya ŋunhi wirrkuḻya miyalk marrtjina ŋäthiyi dhawaṯthuna ŋunha ŋäṉḏiꞌmiŋuwu ḻarruŋaya ga ŋäŋꞌthuna ŋayi, “Wäy... ŋäṉḏi,... nhäku ŋarra yurru ŋunha yindinaya buŋgawana ŋäŋꞌthun?” bitjaya. Ga ŋayiya ŋunhi ŋäṉḏiꞌmiŋuya waŋana bitjayana, “Gatjuy... buku-djulŋi, ŋäŋꞌthuna John-galaŋuwuna yana muḻkurrwu.” ");
INSERT INTO dwy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ŋayŋu yana ŋayi wirrkuḻya roŋiyina ŋayŋuyi Herod-kaya, ŋayŋu bitjayana waŋana, “Yindi buŋgawa, ḏukṯuktja ŋarra dhuwaya nhe yurru gupa gulkthun John-nha ŋunhi Buku-ḻupthunamina yolŋuna dhiyaŋuna bala yana, ga gurrunhandja nhe yurru muḻkurrya ḻimbiḻimbiḻkthi rupaꞌyi ŋayŋu gäŋuna ŋarrakayana,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ga ŋunhi ŋayi Herod-thu balanyawuy ŋäkuya, ŋayŋu yana ŋayi ŋayaŋuya-yätjthinana märr-dhumbalꞌyunana manapaya. Yurru yakana ŋayi gurrana ŋunhi ḏukṯukthinaya ŋayi yurru dhäwuꞌya nhanŋu ḏawꞌyun, bili ŋayi ŋunhi dhawuꞌ-nherraya ŋanya guḻkuꞌwaya ŋaḻapaḻmiwaya. ");
INSERT INTO dwy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ŋayŋu ŋayi Herod-tja wäthunana miriŋuwuna buŋgawawu ŋayŋu dhäruknha-wekaŋaya, “Gatjuy marrtjina ŋunha dharruŋguyina wanhaka gurra John nhina ŋayŋu gupana ŋanya gulkthu.” ");
INSERT INTO dwy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ga ŋayi ŋunhi ŋätthunaya ŋanya gupaya ga muḻkurrya ŋayŋu gurrunhaya biḻitthina ŋayŋu gäŋaya ŋurikayana wirrkuḻwayana. Ga ŋayiya ŋunhi ŋuriŋi wirrkuḻyuya ŋätthunaya ŋayŋu wekaŋaya ŋunha ŋäṉḏiꞌmiŋuwuna nhanukalaŋuwu. ");
INSERT INTO dwy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ga ŋunhi waya John-gaya guyurrꞌmiŋuyu wayay ŋäkuya dhäwuꞌya nhanukalaŋuwuy rakunydhinyawuyya, ŋayŋu waya yana marrtjinana ŋätthunawuna nhanŋu rumbalwuna ŋayŋu moluyina märrkitjkuŋaya. Ga bitjayana ŋayi gurrana Herod-thuya guyaŋina yana be ŋayi Djesuya John-na ŋunhi Buku-ḻupthunamina yolŋu. Ga balanya ŋayi ŋunhi dhäwuꞌya. ");
INSERT INTO dwy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Manymak, ga ŋunhi waya ḻuṉḏuꞌmiŋu waya nhanŋu Djesuwu gumurr-roŋiyina beŋu djämaŋuya, ŋayŋu waya gurrana ḻakaŋayana Djesuwuna nhä waya gurrana djäma ga marŋgikuŋaya yolŋuna wayana. ");
INSERT INTO dwy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ga balanyamiyuya gurrana ŋunhi guḻkuꞌna wirrkina yolŋuya waya ḻarruŋaya nhanŋu Djesuwu, ga bäyŋuna wayaŋgu ŋunhi waluya ŋäthawuya ḻukanhawu, Djesuwuya ga ḻuṉḏuꞌmiŋuwuya wayaŋgu. Ŋayŋu ŋayi waŋanana ŋuriki ḻuṉḏuꞌmiŋuwutja wayaŋgu bitjayana, “Go, ŋilimu ŋathiyi marrtji ŋula gänaŋuyi wäŋayi märr ŋilimu yurru ŋirꞌyunmi.” ");
INSERT INTO dwy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ŋayŋu waya wapthunana marthaŋayina ŋayŋu marrtjina gänaŋuyina wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ga guḻkuꞌyuna gurrana ŋunhi yolŋuyuya nhäŋaya ŋunhi goyurr marthaŋaya wanhama waya gurrana ŋunhi marrtjina. Ŋayŋu ŋunhi yolŋuya waya ḻawꞌyunana goyurr-ŋupayana marthaŋanaya yurru ḏiltjiꞌkuna, ga wayana ŋunhi ŋurruŋuya bunana ŋunhaya wäŋaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ga ŋunhi ŋayi Djesu yupthunaya marthaŋaŋuya ŋayŋu gurrana ŋunhi yolŋuya waya galkunana nhanŋu. Ga ŋunhi ŋayi Djesuyu nhäŋaya wayana malaya bitjan, waya yakana marŋgi nhattjan waya yurru nhina romŋu raypirriꞌŋu, balanyana, waya ŋunhi bitjan wäyin bimbi malanynha djäkamiriwnha. Ŋayŋu ŋayi wirrkina ŋayaŋu-wuyunaya wayaŋgu, ga marŋgikuŋayatja ŋayi gurrana wayana ŋunhi God-Waŋarrwalaŋuwuna Romgu ");
INSERT INTO dwy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","ŋurru-yirrꞌyunaya ḏämbuyu-waluyu ga yana ḻinygu-u-u, ga ḻäy-wilyunayu. Ŋayŋu ŋunhi ḻuṉḏuꞌmiŋuya waya nhanŋu waŋanana, “Wäy, ḻäy-wilyunana dhuwaya ga bäyŋuna dhuwaya ŋathaya, gatju-mak waŋi dhuwayi yolŋuna wayana waya yurru ŋatha wayaŋguway ŋätthun dhuwaya yaꞌ wäŋaku miṯtjiku.” ");
INSERT INTO dwy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ga ŋayi Djesuya bitjaya buku-roŋinymaŋaya, “Yaka dhuwayitja latjuꞌ. Nhumapi yana wayana yurru ḏulpu-wekama.” Ga wayatja dhä-wirrkaꞌyuna ŋanya märr-dhumbalꞌyuna manapaya bitjaya, “Wäy, wanhami dhikaꞌ ŋanapu yurru maḻŋꞌmama balanyaya rrupiya mala dhiyaku yolŋuwu wayaŋgu ḏulpu-wekanhawu? Dhuwaya yurru yolŋu gurra djäma waŋganynha dhuŋgarra dhä-manaꞌmanapan rrupiya ŋäthiyi wuŋiliꞌyunawu ŋathawu.” ");
INSERT INTO dwy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ga ŋayi Djesuya waŋana bitjaya, “Maḻŋꞌmaŋu waya, yolthu gurra ŋula ŋathaya gäma?” Ŋayŋu waya ḻarruŋaya gurrana ga roŋiyina waya bala ḻakaŋaya bitjaya, “Goŋ waŋgany dhuwaya dämbaꞌya ga bulalꞌ ŋarirriꞌya.” ");
INSERT INTO dwy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ŋayŋu ŋayi Djesuyuya waŋana dhäruk-wekaŋaya ŋunha ḻuṉḏuꞌmiŋuna nhanŋuway ŋayi bitjaya, “Maꞌ, waŋina dhuwaya yolŋunaya wayana waya yurru nhina mulmuŋuna yurru miṯtji ga miṯtji ga miṯtji.” ");
INSERT INTO dwy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ŋayŋu gurrana yolŋuya waya mala-wulkthunana wiripuya yolŋu waya 100 mala ga wiripuya 50 ga ŋayŋuna wala, ga beŋga gurrana nhinanaya. ");
INSERT INTO dwy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ŋayŋu ŋayi Djesuyuya ŋunhi goŋ-waŋganydja dämbaꞌ ga ŋarirriꞌ maṉḏana ŋätthunana. Ga buku-garrwarthina ŋayi djiwarrꞌyi buku-wekaŋaya God-Waŋarrnha, ŋayŋu ḏawꞌṯawyunana ŋayŋu wekaŋaya ŋunha ḻuṉḏuꞌmiŋuwuna nhanukalaŋuw märr wayatja yurru wekaꞌwekamana ŋunha yolŋunana wayana. ");
INSERT INTO dwy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ga ḻukanaya waya marrtjina ŋunhi ŋathaya ga bukmak yana ganaꞌ. ");
INSERT INTO dwy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ga ḻukanana waya marrtjina ga dhawarꞌ, bala ŋunhi guyurrꞌmiŋuya wayay wapmaŋaya bäythinyawuya ŋatha, ga dhaŋaŋguŋayana 12-nha bathi malanynha. ");
INSERT INTO dwy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ga ŋula nhämunyꞌnha ŋunhi 5000-na ḏarramuya yana mala, ga gänayi ŋunhi miyalktja waya ga yumurrkuꞌya balanyaŋga bili miṯtji. ");
INSERT INTO dwy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ga dhunupana yana ŋayi ŋunhi Djesuya waŋana wayaŋgu ḻuṉḏuꞌmiŋuwu wayaŋgu bitjaya, “Wäy waya, nhumaya marrtji marthaŋayuna ŋunha galiꞌyina ŋunha Bethsaida-yina.” Ŋayŋu waya marrtjina buḏapthunana ŋuriki guḻunꞌku, ga ŋayipina Djesuna wäŋa-ŋurrꞌyunaya ŋunhaya bäymaya, ga yolŋunaya wayana ŋayi ŋäthiyina gurrana djuyꞌyuna roŋinymaŋaya wäŋayina. ");
INSERT INTO dwy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ga ŋunhi waya yolŋuya waya ḻatjuwarrꞌyuna, ŋayŋu ŋayipiya Djesuya bukuyina ŋalꞌyuna bukumiyanhawuna. ");
INSERT INTO dwy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Ga ŋunhi wäŋaya munhakuyina ŋayŋu ŋayi Djesuya yarrupthunana bukuŋuya. Ga waya ŋunhi ḻuṉḏuꞌmiŋuya waya nhanŋu marthaŋamiya waya balanyamiyuya ŋunhayana dhulmuŋuna gapuŋu. Ga wirrkina wayana gurrana ŋunhi watayuya buku-nhirraya ga wirrkina waya gurrana ŋunhi ḻiwꞌyunminaya. Ga munhakuna ŋayi Djesuyuya goyurr-ŋupaya wayana, yurru marrtjinaya ŋayi gurrana ŋunhi ḻukuyuna ŋapaꞌkuyuna gapukuyu. Ga dhiyaŋuŋga bili ŋayi marrtjina ŋunhi djuḻkmaŋaya wayana marthaŋaminaya wayana ŋayŋu waya ŋanya nhäŋayana. Ga biyaṉiyina waya ŋunhi nhanŋu wirrkina yulŋuya ŋapa-mulkanhamina dhä-wirrkaꞌyunmina bitjaya, “Wäy-y-y nhä gurra dhuwayatja marrtji way, maliꞌ yolŋu ŋeniya?” Yurru ŋayi Djesuya waŋana, “Ŋarra... ŋarra dhuwaya waya. Yaka waya biyaṉiyi!” ");
INSERT INTO dwy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ŋayŋu ŋayi Djesuya ŋalꞌyunana bala marthaŋayina ŋayŋu wataya ŋunhi wapurarryinana. Ga wayatja ŋunhi ḻuṉḏuꞌmiŋuya waya nhanŋu wirrkina wokthuna ŋuriki romgu. ");
INSERT INTO dwy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ga bili waya ŋunhi nhäŋaya ŋanya Djesuna ŋunhi ŋayi ganydjarryu nhanukiyingaya ḏulpu-wekaŋaya dhaŋaŋnha yolŋuna wayana djuḻkmaŋaya gurrana 5000-tja mala. Ga yakana yana waya ŋunhi dharaŋayatja nhanŋu ganydjarrya, bili wayaŋgu ŋunhi ŋayaŋuya ḏälmi yana. ");
INSERT INTO dwy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ga ŋunhi waya marrtjina ŋunha galiꞌyiya gilipuŋaya ŋuriki guḻunꞌku, ŋayŋu waya ḻukuna gutjparryuna ŋunhana bili gumurrŋuna wäŋaŋu Gennesaret-na. ");
INSERT INTO dwy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ga ŋunhi waya gurrana yupthuna marthaŋaŋuya, ŋayŋu guḻkuꞌyuna ŋunhi yolŋuyuya nhäŋaya wayana ŋayŋu waŋana bitjayana, “Waya dhuwanna Djesuya bilina bunana.” ");
INSERT INTO dwy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Ŋayŋu gurrana yolŋuya waya waṉḏinana, ḻakanhamina marrtjina buku-ḻiwꞌmaŋayana, ga dhuwanna lili yolŋuya waya marrtjina gäŋaꞌgaŋayana rerriminaya yolŋuna wayana. Ga wanhama ŋayi Djesu marrtjina ŋunhaya wäŋaŋu, wayatja yolŋuyuya wayay ŋäkuya ga bitjayaŋga marrtjina gäŋaꞌgaŋayatja rerriminaya yolŋuna wayana ŋayŋu ŋurru-ḏakthunminana, rarrꞌyunaya marrtjina yakurrkuŋayana ŋunhimaya ŋunhi wäŋayi. Ga bitjaya waya ŋunhi guyaŋinaya gamꞌ, “Ŋuli waya yurru ŋunhi girriꞌya yana nhanŋu Djesuwu mulka wayatja yurru latjuꞌyina yana.” Ga ŋunhi waya bitjaya mulkanaya nhanŋu girriꞌya dhunupana yana wayatja latjuꞌyinana. ");
INSERT INTO dwy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Waŋganymiyu waluyu Pharisee rom-mulkanhami waya, ga ḻurrkunꞌ Jew-wu rom-marŋgikunhami waya wäŋa Jerusalem-buy marrtjina waya Djesuwaya. ");
INSERT INTO dwy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Ga ŋunhiya yolŋu waya ŋuli gurra wirrkina yana romgu wayaŋguway malthun. Balanyana mala rom gamꞌ: ŋuli yurru yolŋu djälmiyi ŋathawu ḻukanhawu, ŋurruŋuya waya yurru goŋ-rurrwuyunmi romgu yana malthun ga yurruna ŋathaya ḻuka. Ga ŋunhi waya yurru ŋatha ŋätthun ŋula wanhami yolŋu guḻkuꞌmiŋu wäŋaŋu, ŋurruŋuya ŋathiyi waya yurru rurrwuyunmi ŋuriki romgu malthun. Ga yurruna banikinꞌtja malanynha rurrwuyun balanya bitjan saucepan mala, ŋathawuy bathanawuy rupa mala, ga gapuwuy wurkthunawuy rupa ga gäp ga biḻit ga guḻkuꞌ wiripu ga wiripu. Bukmak yurru rurrwuyun, romgu ŋuriki malthun. Ga ŋuli yurru wiripu Jew-yolŋu yakaya gurra malthun ŋunhi nhattjan gurra rom waŋa, wayatja yurru ŋunhi Pharisee-ya yolŋu waya maḏakarritjthina wayaŋgu. Ga balanyayina waya ŋunhi Djesuwuya ḻuṉḏuꞌmiŋuna wayana nhäŋaya, ŋayŋu waya ŋunhi Pharisee-ya bukmak yana maḏakarritjinaya wayaŋgu, bili waya gurrana ŋatha ḻukana, goŋ-rurrwuyunamiriw, yaka romgu malthuna. Ŋayŋu waya gurrana rom-nyämirꞌyunana ŋanya Djesuna bitjayana, “Nhäku ŋuli ŋunhi nhokayatja ḻuṉḏuꞌmiŋuyu wayay bitjandja ŋatha ḻuka goŋ-rurrwuyunamiriwya? Ŋunhiya waya ŋuli gurra rom-nha ḏawꞌyun ŋaḻapaḻmiwuna!” ");
INSERT INTO dwy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Ga ŋayi Djesuya buku-roŋinymaŋayana bitjaya, “Nhumaya dhuwaya yolŋu waya galiꞌ-märrmaꞌ warray. Dhunupaŋga ŋayi ŋunhi yolŋuyu yäkuyu Isaiah-yu bamanꞌtja wukirri God-Waŋarrwu dhäruk bitjaya gamꞌ, ‘Dhuwayatja yolŋu waya ŋuli wokthun ŋarraku dhärukthu yana waŋganydhu, ga yaka ŋuruŋu ŋayaŋuyutja. Bäyŋuna waya ŋuli yuwalktja buku-ŋalꞌyun ŋarraku, ga marŋgikumaya waya ŋuli ŋunha yolŋuwuna romdja malanynha, yana beni ŋunhiyiya God-Waŋarrwuŋuna rom. Ga baṯ-bitjana waya ŋuli mulka yolŋuwuna yana rom malany.’ Balanyana dhuwaya nhumaya. ");
INSERT INTO dwy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Gunhaꞌyunana nhuma God-Waŋarrwuŋuya rom nininyŋuya malanynha, ŋayŋu nhuma ŋuli malthundja yolŋuwuna yana romgu. Gaḏamana dhuwaya nhumaya marŋgina wirrkina balanyawuya yätjkunhawuyya djämawu! ");
INSERT INTO dwy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dhuwayatja ŋunhi rom nhanukuŋu God-Waŋarrwuŋu, ŋunhi ŋayi wekaŋaya ŋilimuŋgu Moses-kaya balanya gamꞌ, ‘Djälwu malthu nhokalaŋuwu ŋäṉḏiꞌmiŋuwu ga bäpaꞌmiŋuwu.’ Ga buluya ŋayi gurra bitjan waŋa gamꞌ, ‘Ŋuli yurru yolŋu dhurrara-retjandhiya waŋa ŋäṉḏiꞌmiŋuna ga bäpaꞌmiŋuna, ŋunhi ŋunha romdja gurra waŋa balanyawuya yolŋuwu ŋilimu yurru bumana rakunygumana yana.’ ");
INSERT INTO dwy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Yo, bitjaya ŋayi ŋunhi God-Waŋarryuya rom nherraya, yurru nhumaya ŋuli dhuwaya bilmamana wiripuna dhäwuꞌya ḻakama yolŋuwuya bitjana gamꞌ, ‘Ŋunha nhuŋu ŋäṉḏiꞌmiŋu ga bäpaꞌmiŋu gurra djälthi ŋula nhäku, yurru nheya ŋunhi ŋuli bilina ŋunhiyiya dhawuꞌ-nherraṉ God-Waŋarrnhana, yurru baḏak yana nheya gurra ŋayaŋuyu-ḏapmama, ga yakana nhe yurru ŋunhi bitjan maṉḏanaya wekama mundhurrya.’ ");
INSERT INTO dwy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ga balanyawuna ŋarra ŋunhi bitjayatja ḻakaŋaya nhumaŋgu ŋäthiyiya, nhumaya ŋunhi barꞌparmaŋaya nhanŋuna God-Waŋarrwuna rom, ŋayŋu bilmaŋayana nhuma, ga wiripuna rom nherraya. Ga guḻkuꞌ yana nhuma gurra dhuwaya rom malanynha bilmaŋaya.” ");
INSERT INTO dwy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ga beŋuya ŋayi Djesu wäthuna yolŋuwuna wayaŋgu ŋayŋu bitjayana waŋana, “Dharr-biyaku waya ŋäkuya, märr nhuma yurru dharaŋan yana. ");
INSERT INTO dwy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nhä ŋuli ŋunhi gärri guḻunꞌthi, yaka ŋuli ŋuriŋiya yolŋuna ŋayaŋu-yätjkuma. Ga nhä ŋuli ŋunhi dhawaṯthun ŋilimuŋgaya ŋayaŋuŋu, ŋunhiyina ŋayi yätjtja. ");
INSERT INTO dwy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ŋuli nhuma mäkiriꞌmiya waya ŋäku waya latjuꞌkuŋu!” ");
INSERT INTO dwy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ŋayŋu ŋayi Djesu ga ḻuṉḏuꞌmiŋu waya marrtjina ga gunhaꞌyuna ŋunhi yolŋuna wayana ŋayŋu gulŋiyina buṉbuyina. Ŋayŋu waya dhä-wirrkaꞌyunana Djesuna bitjaya, “Marrkapmi, ŋäthiyi ḻakaŋu ŋanapuŋgu ŋunhi mayaliꞌ ŋurikiwuy dhäwuꞌpuy.” ");
INSERT INTO dwy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Ga ŋayi Djesuya buku-roŋinymaŋaya wayaŋgu bitjaya, “Nhattjan nhuma gurra dhuwaya yaka yana dharaŋandja, ŋeniya? Balanya ŋayi ŋunhi mayaliꞌya gamꞌ: nhä ŋuli yolŋuyu ḻuka ŋunhiya latjuꞌ, bili yurru ŋunhi walmaŋga yalalaya. Yurru nhä ŋuli ŋunhi walma ŋayaŋuŋu, ŋunhiyina ŋayi yätjtja.” (Ga bitjaya ŋayi ŋunhi waŋanaya, bili bukmaktja dhuwaya ŋatha malanynha latjuꞌ yana ḻukanhawu.) ");
INSERT INTO dwy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Ga nhä ŋuli ŋunhi yolŋuwaya dhawaṯthun ŋayaŋuŋu, ŋurikina ŋuli ŋayi God-Waŋarrya wirrkina yana milnyaŋꞌthun: Dhiyaŋu yätjthuya ŋilimuna ŋuli gulmamana nhanukaya God-Waŋarrwayatja. ");
INSERT INTO dwy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dhiyaŋu yätjthu ŋilimuna ŋuli yarrkmama nhanukaya bitjan dhuwaya mala gamꞌ, guyaŋa yurru yätjnha yana nhä mala, ga marrambaꞌ-djawꞌyunami rom, ga manaŋgan rom, ga mari yurru djäma wiripuwu yolŋuwu rakunyguma, ga ");
INSERT INTO dwy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ḻäy-ḏäl rom, ga mayaliꞌ-wilkthunami rom, ga nyäḻyunami rom, ga djäl-gänaŋumi rom, ga maŋutji-ḏiyꞌyunami rom, gupa-waŋanhami rom, ga marŋgi-ḻakanhami rom, ga ḻäy-ŋarrꞌŋarr rom, ga ŋayaŋu-ḏäl rom. ");
INSERT INTO dwy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yo, balanyana ŋunhi yätjtja mala ŋunhi ŋuli walma dhipuŋuyu ŋayaŋuŋuya, ga yätjkumana ŋilimuŋgu ŋuli ŋayaŋuna. Ga bitjana bili ŋuli ŋunhi God-Waŋarrnhaya gulmama ŋilimuŋgaya, ŋunhiyiya nhanukayatja God-Waŋarrwayatja milnyaŋꞌmina.” ");
INSERT INTO dwy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Beŋuya ŋayi Djesu ga ḻuṉḏuꞌmiŋu mala nhanŋu gunhaꞌyuna ŋunhiyi wäŋa. Ga marrtjina waya ŋayŋu wäŋa guḻkuꞌmiyina wäŋayi yäkuyi Tyre-yina. Ga bunana waya ŋunhaya wäŋaŋu bala gärrina buṉbuyina, bili yaka ŋayi Djesu djälthina waya yurru yolŋu waya marŋgithi nhanŋu ŋunhi ŋayi gurrana ŋunhaya nhinana. Yurru gulkuruna ŋayi gurrana ŋunhi djuḻuḻꞌyunaya. ");
INSERT INTO dwy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ga ŋunhayayi gurrana miyalk nhinana yurru ŋayi ŋunhi yaka Jew-ya bäpurruꞌ. Ga yolŋuya ŋayi ŋunhi dhawal-wuyaŋinyawuy ŋurukuwuy Phoenecia-wuy, makarrŋu Syria. Ga ŋunhi ŋayi Djesunaya ŋäkuya, ŋayŋu ŋayi marrtjinana ga waŋana nhanŋu bitjaya, “Buku-djulŋi, ŋäthiyi ŋunha yätjnha birrimbirrnha gutjparrꞌyu yothuwaya ŋarrakalaŋuwaya.” ");
INSERT INTO dwy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ŋayŋu ŋayi Djesuya mayaliꞌkuna waŋana, “Dhuwaya yurru ŋurruŋuya ŋatha ḻuka yumurrkuꞌyu, ga yurruna moṉguya ŋatha ḻuka yurru wuŋgandhuya.” Balanya ŋunhi mayaliꞌya gamꞌ: ŋurruŋuya ŋayi yurru Djesuyu guŋgaꞌyun nhanŋuwuy ŋayi yolŋuna Jew-nha malana ga yurruna ŋayi yurru wiripunaya bäpurruꞌna wayana guŋgaꞌyun. ");
INSERT INTO dwy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ga ŋayi ŋunhi miyalkthuya buku-roŋinymaŋaya bitjaya, “Yuwalk yana marrkapmi. Yurru ŋunhi ŋuli wuŋgandhuya ḻuka gorꞌnha yupthunayana beŋuna ŋunhi yumurrkuꞌwayana biḻitŋu.” Ga dhiyalaŋumi ŋunhi ŋayi mayaliꞌya gamꞌ: ŋunhi ŋayi Djesuyu gurrana nhanŋuway yolŋuna wayana guŋgaꞌyuna, ga bitjan bili ŋayi yurru wiripunaya yolŋuna wayana guŋgaꞌyun. ");
INSERT INTO dwy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ga ŋunhi ŋayi Djesuyu ŋäkuya balanya dhäruk, ŋayŋu ŋayi waŋanana, “Way, dhuwayatja nhe yuwalknha yana waŋana. Gatjuy marrtjina wäŋayina, bilina dhuwaya birrimbirr yätjtja walmana nhokalaŋuwaya yothuwaya.” ");
INSERT INTO dwy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ŋayŋu ŋayi ŋunhi miyalktja roŋiyinana wäŋayina. Ga ŋunhi ŋayi bunana wäŋaŋuya, nhäŋaya yothunaya ŋayi gurrana gayŋi yana ŋorrana yakurr-latjuꞌyinana, bili nhanukaya ŋunhi yätjtja birrimbirr walmanana. ");
INSERT INTO dwy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ga beŋuya Djesuyu gunhaꞌyuna ŋunhi wäŋa Tyre-ya, ga marrtjina ŋayŋu Sidon-dhina, ga dhukarrkuyu ŋayi marrtjina ŋunha bala ḻäy-warryuna, ŋayŋu gumurrkuyu raŋikuyu. Dhunupana yana marrtjina Galilee-yina guḻunꞌthi ga bunana waya ŋunhaya yäkuŋu wäŋaŋu ‘Decapolis-ŋu.’ ");
INSERT INTO dwy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ga ŋunhaya gurrana yolŋu nhinana dhoŋuluꞌ ŋunhi ḻuṉḏuꞌmiŋuyu wayay ŋanya gäŋaya Djesuwaya. Ga ŋäŋꞌthuna waya bitjaya, “Buku-djulŋi ŋäthiyi goŋ-ŋalꞌyu dhiyakaya yolŋuwaya märr ŋayi yurru latjuꞌyi.” ");
INSERT INTO dwy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ŋayŋu ŋayi Djesuyuya ŋanya garrꞌyunana ŋunhiyi dhoŋuluꞌna gänaŋuyina, ŋayŋu ŋayi goŋdja gulŋiyina nhanukaya mäkiriꞌyi, bulalꞌyi yana. Ga ŋarambiyayi ŋayi nhanukaya dhupthuna, ŋayŋu mulkanana ŋunhi yolŋunaya ŋäṉarrya. ");
INSERT INTO dwy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ga buku-garrwarthina ŋayi djiwarrꞌyi ŋayŋu yindi-ŋirꞌyunana ŋayŋu waŋana dhärukuyu Arram-guyu bitjayana, “Yipatha!” Balanya gamꞌ mayaliꞌ “Ḻapthuna!” ");
INSERT INTO dwy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ga bitjaya ŋayi ŋunhi waŋanaya ŋayŋu nhanŋu mäkiriꞌya ḻapthunana, ga ŋäṉarrya nhanŋu ŋunhi dhayaḻayinana, ŋayŋu ŋayi waŋana latjuꞌkuŋayana. ");
INSERT INTO dwy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ŋayŋu maṉḏa roŋiyina ŋayŋu yolŋuwaya wayaŋgaya. Ga bitjaya ŋayi Djesuyu wayana dhäruk-mukmaŋaya, “Bäyŋu nhuma yurru ḻakama yolŋuwuya ŋunhi ŋarra dhuwaya yolŋuna latjuꞌkuŋaya.” Yurru wayatja gunhaꞌyuna ŋanya dhäruk ga baḏak yana ḻakaŋaya bukmakku yana yolŋuwu. ");
INSERT INTO dwy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ga bukmak waya wirrkina galŋa-ŋämathina. Ga bitjaya waya gurrana ŋunhi ḻakanhamina, “Nhäna dhuwayatja ŋayaŋu-ganyimꞌthunamina rom, ŋeniya! Dhiyaŋuya yolŋuyu gurra latjuꞌna wirrkina djäma. Mäkiriꞌ-dhumukthuya gurra ŋämana ga dhärukmiriwya gurra waŋana.” ");
INSERT INTO dwy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Waŋganymiyu waluyu yolŋu waya ḻuŋꞌthuna nhanukaya Djesuwaya märr yurru waya dhäwuꞌ ŋäma. Bili waya malthuna nhanŋu ḻurrkunꞌna walu, ga bäyŋuna ŋula ŋathatja wayaŋgu ḻukanhawu. Yurru ŋayi Djesuya wäthuna ḻuṉḏuꞌmiŋuwuna wayaŋgu nhanukalaŋuwu ŋayŋu waŋana bitjaya, “Ŋayaŋu-wuyunana ŋarra dhuwaya dhiyaku yolŋuwuya wayaŋgu. Guḻkuꞌna dhuwaya yolŋuya waya yawungu barrkuŋuya marrtjina ga ḻinyguna dhuwaya ḻurrkunꞌna waluya bitjan mala-manapanminyawuya ŋilimuŋgu ga yana bili ga ŋatha ŋilimuŋgu dhawarꞌyuna yawungu. Yakana ŋilimu yurru djuyꞌyundja wayana wäŋayiya djaṉŋarrminaya, waya ŋuli gandarrŋuya ḏalalakthina.” ");
INSERT INTO dwy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ga waya ŋunhi ḻuṉḏuꞌmiŋuya waya nhanŋu buku-roŋinymaŋaya, “Wäy, buku-djulŋi dhuwaya wäŋaya wiraŋnha,... nhattjana ŋilimu yurru ḏulpu-wekamaya, nhäthuna?” ");
INSERT INTO dwy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ga ŋayi Djesuyuya dhä-wirrkaꞌyuna wayana, “Nhämunhaꞌ gurra nhumaya ŋatha mulka?” Ga wayatja ḻakaŋaya nhanŋu, “Marrkapmi, seven yana dhuwaya dämbaꞌya.” ");
INSERT INTO dwy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ŋayŋu ŋayi Djesuyuya waŋana wayana, “Maꞌ, nhinina waya munathaꞌyina.” Ŋayŋu ŋayi yana ḻurrkunꞌtja dämbaꞌ ŋätthunana ga buku-wekaŋaya God-Waŋarrnhana. Ga ḏawꞌṯawyuna ŋayi marrtjina muṉguykuŋaya ŋayŋu wekaŋaya nhanukalaŋuwaya ḻuṉḏuꞌmiŋuwaya wayaŋgaya. Ga wayatja yolŋunana wayana marrtjina ḏulpu-wekaŋaya. ");
INSERT INTO dwy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ga ḻurrkunꞌ waya ŋunhi guyatja gurrana mulkana. Ga buku-wekaŋaya ŋayi ŋanya God-Waŋarrnha ŋuriki guyawu, ŋayŋu ŋayi wekaŋaya ḻuṉḏuꞌmiŋuwaya wayaŋgaya, ga wayatja marrtjina wekaŋaya yolŋuꞌyulŋunana. ");
INSERT INTO dwy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ga bukmak ŋunhi yolŋuya waya 4000-na mala. Ga ḻukanaya waya marrtjina ŋunhi ŋathaya ga ḏulputhina bukmak yana. Ga dhawarꞌyunaya waya ḻukanhaŋu ŋayŋu ŋunhi ḻuṉḏuꞌmiŋuyu wayay wapmaŋaya marrtjina bäythinyawuya ŋatha, ga dhaŋaŋdhina seven-nha bathi malany. Ga dhurrwaraŋu beŋu ŋayi gurrana Djesuyu djuyꞌyunana wayana wäŋayina. ");
INSERT INTO dwy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ga waya ŋunhi yolŋuya waya marrtjina wäŋayina roŋiyina, ŋayŋu ŋayi Djesuya ga ḻuṉḏuꞌmiŋuya waya nhanŋu ŋalꞌyuna gurrana marthaŋayina ŋayŋu waya marrtjinana, wäŋayi yäkuyi Dalmanutha-yina. ");
INSERT INTO dwy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ga ŋunhi waya Djesu ga bukmak ŋunhi nhämunyꞌnha gurrana malthuna nhanŋu, bunana ŋunhaya wäŋaŋu Dalmanutha. Ga ḻurrkunꞌ yolŋu waya beŋu ŋunhi Pharisee-waya malaŋu marrtjina nhanukaya Djesuwaya, ŋayŋu waya gurrana dhäruknha-ḏupthunmina märr waya yurru bawaꞌwekama ŋanya. Ga bitjaya waya ŋanya waŋanaya, “Maꞌ, mak maŋutji-wekuŋuna ŋanapuna ŋayaŋu-ganyimꞌthunamiya rom märr ŋanapu yurru nhäma ga märr-yuwalkthi ŋunhi nhe yuwalk gurra ganydjarr mulka God-Waŋarrwuŋu!” ");
INSERT INTO dwy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ŋayŋu ŋayi Djesuya yindi-ŋirꞌyunana ga waŋana ŋayi bitjaya, “Ŋunhi ŋarra yurru balanyawuya ŋäma, ŋunhiya nhuma gurra ŋayaŋu-wutthuna ŋarrana! Nhäku nhuma gurra dhuwaya ŋayaŋu-ganyimꞌthunamiwuya romgu ŋäŋꞌthun? Yaka waya biyaku ŋäŋꞌthu. Yuwalk gurra dhuwaya ŋayaŋu-ganyimꞌthunamiya rom marrtji, yurru ŋarraya ŋuli yakana biyaku djäma, yana ŋuli nhumaŋgu nhänharawu.” ");
INSERT INTO dwy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ga beŋuya ŋayi Djesu marrtjina gunhaꞌyuna wayana ga waya ḻuṉḏuꞌmiŋuya waya nhanŋu marrtjina buḏapthunana marthaŋayyuna ŋurikiya guḻunꞌku, ŋunha galiꞌyina. ");
INSERT INTO dwy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Manymak, ga waya Djesuya ga ḻuṉḏuꞌmiŋuya mala nhanŋu marrtjinana. Ga gandarrŋuya guḻunꞌŋu ŋayŋu waya guyaŋina ŋunhi waya yaka ŋätthuna ŋatha ḻukanhawu. Ga waŋganynha waya gurrana dämbaꞌna gäŋayatja. ");
INSERT INTO dwy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ga ŋayi ŋunhi Djesuyuya wayana ŋäkuya, waya gurrana waŋanhamina ŋathawu ŋayŋu ŋayi bitjayana waŋana, “Dharraḏayi, ga djäka waya, ŋe, märr yurru nhumana yaka waya mayaliꞌ-wilkthun ŋuruŋuya malay King Herod-thuya ga Pharisee-yuya malay. Balanya wayaŋgu ŋunhi dhäruktja mala bitjan ŋatha ŋilimu ŋuli bathan duṯuṯmama.” ");
INSERT INTO dwy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ga ŋunhi ḻuṉḏuꞌmiŋuyu wayay nhanukaya ŋäkuya ŋayŋu waya märr-dhumbalꞌyunana. Ga waŋanhamina waya, “Nhattjana ŋayi dhuwaya waŋanaya,... mak ŋilimu yaka ŋatha gäŋaya?” ");
INSERT INTO dwy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ga ŋayi Djesuya marŋgithina wayaŋgu nhattjaya waya guyaŋina, ŋayŋu ŋayi bitjayana, “Nhä nhuma gurra dhuwaya ŋathawuya yana waŋanhami... yaka nhuma ŋunhi ŋarrakuya mayaliꞌ ŋätthuna? Nhä nhumaŋgu dhuwaya muḻkurrya dhumukthinana? ");
INSERT INTO dwy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Biliŋga nhuma gurrana nhäŋayatja, yurru nhuma yaka yana dharaŋaya. Dhuwayatja bitjan nhuma dhuŋamina nhänharawu. Ga bili nhuma gurrana ŋäkuya, ga yaka yana nhuma dharaŋaya, ga ŋunhiya nhuma bitjan dhuŋamina ŋänharawu. ");
INSERT INTO dwy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nhä nhuma dhuwaya ḻiya-dhumukmina, ŋeniya? ŋunhi ŋarra dämbaꞌ malanynha ḏaw-ṯawꞌyuna ga ḏulpu-wekaŋaya 5000-nha yolŋuna wayana? Ga nhämunyꞌthi bathiyi nhuma ŋunhi bäythinyawuya ŋatha mala wapmaŋaya?” Ga wayatja buku-roŋinymaŋaya bitjaya, “12-ga ŋunhi bathiya, marrkapmi!” ");
INSERT INTO dwy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ga bulu ŋayi Djesuyu dhä-wirrkaꞌyuna, “Nhä nhuma gurra dhuwaya guyaŋiŋga yulŋuya ŋunhi ŋarra ḏawꞌṯawmaŋaya seven ŋatha malanynha ḏulpu-wekanhawu 4000-gu yolŋuwu wayaŋgu? Ga nhämunyꞌthi bathiyi nhuma ŋunhi bäythinyawuya ŋatha malany wapmaŋaya?” Ga wayatja waŋana ŋayŋuya, “Yo, seven ŋunhi bathiya!” ");
INSERT INTO dwy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ŋayŋu ŋayi Djesuya bitjaya waŋana, “Yuwalk dhuwayi, bilina nhuma dhuwaya nhäŋayana nhumaŋgaya maŋutjiyu, yurru nhäkuna nhuma gurra yakaya dharaŋan ŋunhi wanhaŋu ŋarraku gurra ganydjarrya marrtji?” ");
INSERT INTO dwy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ga beŋuya ŋayi Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu marrtjina ga bunana ŋunhaya Bethsaida wäŋaŋu. Ga ŋunhayatja waya gäŋaya nhanukaya Djesuwaya bambaynhana yolŋuna, ga ŋäŋꞌthuna waya Djesuna ŋayi yurru mulka ŋanya märr yurru ŋayi latjuꞌyina. ");
INSERT INTO dwy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ga ŋayi Djesuyuya garrꞌyunana ŋanya gänaŋuyina wäŋayi. Ŋayŋu ŋayi dhupthuna ŋanya maŋutji ŋayŋu mulkanana, ga dhä-wirrkaꞌyuna, “Wanhana, nhäŋayana... nhe?” ");
INSERT INTO dwy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ga ŋayi ŋunhi yolŋuya buku-garrwarthina ga ḏawaꞌyuna dhunupaꞌŋuyi ga wiṉꞌkuyi galiꞌyi, ŋayŋu buku-roŋinymaŋayana, “Dhuwaya ŋarra gurra yolŋunaya wayana nhämana, yurru märr gaŋga, balanya bitjan dharpa gurra maliꞌmaliyun!” ");
INSERT INTO dwy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ga bulu ŋayi Djesu goŋ-ŋalꞌyuna ŋurikaya yolŋuwaya maŋutjiyi. Ga wirrkina ŋayi yana ŋunhi bambaya yolŋu djalmiyina nhänharawuna. Ŋayŋu ŋayi gurrana nhäŋayana latjuꞌkuŋayana yolŋunaya wayana. Ga bilina nhanŋu ŋunhi maŋutjiya bitjan ḻapthunana. ");
INSERT INTO dwy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ŋayŋu ŋayi Djesuyuya djuyꞌyunana ŋunhi yolŋunaya bitjayana ŋayŋu, “Marrtjina wäŋayina, ga yakana buluya roŋiyi Bethsaida-yiya.” ");
INSERT INTO dwy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ga beŋuya Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu marrtjina buku-ḻiwꞌmaŋaya ŋuruku Caesarea Philippi-ŋu wäŋaŋu. Ga ŋunhaya gandarrŋu, ŋayi Djesuyuya ŋäŋꞌthuna nhanŋuway ḻuṉḏuꞌmiŋuna wayana bitjaya, “Wäy, waya, nhattjan ŋuli ŋunha yolŋuya wayay ḻakama,.... yol dhuwaya ŋarraya?” ");
INSERT INTO dwy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ga wayatja waŋana buku-roŋinymaŋaya, “Yolŋuya wayay nhuna ŋuli ḻakama yana be nhe John ŋunhi Buku-ḻupthunami yolŋu. Ga wiripu guḻkuꞌyuya nhuna ŋuli ḻakama yana be nhe Elijah-tja ŋunhi ŋaḻapaḻnha yolŋu God-Waŋarrwuna djawarrkmi bamanꞌŋuwuynha. Ga wiripuŋuya ŋuli nhuna ḻakama be nhe God-Waŋarrwuŋu bamanꞌŋuwuy djawarrkmi.” ");
INSERT INTO dwy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ga bulu ŋayi Djesuyu dhä-wirrkaꞌyuna, “Wäy-y nhumaya gurra nhattjan guyaŋi,... yol dhuwaya ŋarraya?” Ŋayŋu ŋayi Peter-ya buku-roŋinymaŋaya nhanŋu bitjaya, “Marrkapmi, nheya dhuwaya Christ ŋunhi Maŋutji-ḻakanhawuy yolŋu God-Waŋarrwuŋu ganaŋꞌmanhawuy bamanꞌŋuwuy.” ");
INSERT INTO dwy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ŋayŋu ŋayi Djesuyuya wayana dhäruk-mukmaŋayana bitjayana, “Yaka nhuma yurru bukmakkuya wayaŋgu ḻakama, ŋe!” ");
INSERT INTO dwy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ga beŋuya ŋayi Djesuyu ḻakaŋaya ḻuṉḏuꞌmiŋuwu wayaŋgu nhanukalaŋuwu bitjaya, “Ŋarrapina yana dhuwaya Yuwalkŋuya Walꞌŋu Yolŋu. Yo, yalalamiyuya ŋarra ŋuli wirrkina yana galŋa-wiḻyu bili ŋurru-ḏawalaŋuyu wayay ga ŋurruŋu-ḏalkarramiyu ga rom-marŋgikunhamiyu yolŋuy waya ŋarrana ŋuli ḻikandhu-ḏupthu, ŋayŋu waya ŋuli ŋarrana baymatthuna. Ga bulalꞌ munha ŋuli djuḻkthu ŋayŋu ŋarra ŋuli walŋathina rakunyŋuya.” ");
INSERT INTO dwy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ga ŋunhi ŋayi Djesu bitjaya ḻakanhamina, ŋayŋu ŋayi Peter-yuya ŋanya goŋnha warryuna ŋayŋu ŋarrtjunana ŋanya bitjayana, “Marrkapmi, yaka nhe biyakuya waŋi! Ŋarraya yurru wayana gulmama nhokaya baymatthunaŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ga bitjayana ŋayi ŋunhi Peter-ya waŋana yaka God-Waŋarrwayatja djälyu. Ŋayŋu ŋayi Djesuya bilyuna ŋayŋu nhäŋayana marrtjina ḻuṉḏuꞌmiŋunaya wayana nhanŋuway ŋayi, ŋayŋu ŋayi maḏakarritjthuna dhärukthu waŋana Peter-naya bitjayana, “Mukthuna! Dhuwayiya gurra Satan-na waŋa ŋunhi ŋayi buŋgawana yätjku malawu. Gatjuy marrtjina. Dhuwayatja nhe gurra yolŋuwaya ŋayaŋuyu waŋa, yaka God-Waŋarrwaya ŋayaŋuyu.” ");
INSERT INTO dwy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ŋayŋu ŋayi Djesuyu ga ḻuṉḏuꞌmiŋuyu wayay nhanukaya wiripunana yolŋuna wayana ḻuŋꞌmaŋaya, ŋayŋu ŋayi gurrana marŋgikuŋayana bitjayana, “Ŋuli ŋayi yurru yolŋu djälmiyi ŋarraku malthunawu, ŋayi yurru bitjana bili malthuna ŋarraku, ŋunhina ŋunhi ŋayi yurru meṉgumana nhanŋuway bitjan djäl ga malthun yurru God-Waŋarrwuna djälwu, bäydhi ŋayi wiripu yolŋu ŋuli djälthi baymatthunawu nhanŋu rakunygunhawu. Ga ŋayiya yurru yana bitjana bili malthuna, bitjan yolŋuyu ŋuli ḻawꞌmama nhanŋuway dharpa-mälakmanhaya ḻambarryu, ŋayŋu ŋuli gumurrꞌyuna marrtji rakunydhinyawuna yana. ");
INSERT INTO dwy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ga ŋuli yurru yolŋu gurra nhina nhanŋuway ŋayi walŋa, ḻuŋꞌmama yurru ŋula nhä wiripu rom, ŋayŋu ŋayi yurru baḏatjtjuna bala ŋayi yurru rumbal-wiḏiꞌyuna. Yurru ŋuli ŋula wiripu yolŋu yurru rakunydhi ŋunhiya bili ŋayi ŋuli ŋarraku malthun, ga ḻakama ŋuli ŋayi God-Waŋarrwuna yana rom, ga yalalamiyuna ŋayi ŋuli nhiniya walŋana dhä-dhawarꞌyunamiriwnha. ");
INSERT INTO dwy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Maꞌ, ŋäkuna waya! Ŋuli nhe yolŋu ḻukunydjaya walꞌŋu, ŋula nhä guḻkuꞌmi, ga ŋunhi ŋayi yurru God-Waŋarryu nhuna ŋuli ḏupthu, ga nhä nhe yurru ŋula ŋätthundja? Bäyŋuna! ");
INSERT INTO dwy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ga ŋuli nhe gurra ŋayaŋuy-ḏapmama nhä mala dhiyakuwuy munathaꞌwuy, ŋunhiya nhe yurru yakana buku-wekama gathan ŋula nhä walŋawuya nhokalaŋuwu roŋinymama! ");
INSERT INTO dwy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yo, ŋäkuna waya! Dhuwaya gurra dhiyaŋuya bala yolŋuya waya dhiya munathaꞌŋuya djäma guḻkuꞌna wirrkina yätjtja rom mala. Ga bäyŋuna waya gurra ŋayaŋumiyi malthunawu nhanŋu God-Waŋarrwuya. Ga ŋuli nhe yurru ḻäy-yarryun ŋarraku malthunawu, ga marŋgithinyawu ŋarrakuya, ŋarraya yurru bitjan bili nhuŋuya ḻäy-yarryun, ga yakana nhunaya ŋuli ḻakaŋu ŋunhayatja God-Waŋarrwayatja gumurrŋu. Bili ŋarraya ŋuli ŋunhi Yuwalkŋuya Walꞌŋu Yolŋu, roŋiyi ŋuli beŋu djiwarrꞌŋuya ga mala ŋarraku guḻkuꞌna djiwarrꞌpuynha yolŋu waya dhäwuꞌmi waya. Ga yarrupthuya ŋanapu ŋuli ŋunhi djeŋarraꞌyakaynha bäymana, ga balanyamiyuna ŋuli yolŋuya wayay dharaŋuya ŋarrana. ");
INSERT INTO dwy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yo, yaka waya meṉguŋuya ŋarraku dhäruktja, ŋe! Dhiyalaŋumina malaŋu dhuwaya nhuma gurra djingaryundja, ŋunhi nhuma yaka yana rakunydhina, yalalaŋumina nhuma ŋuli ŋunhi ḻurrkunꞌthuna yana yolŋuyu wayay nhäŋuya ŋayi yurru God-Waŋarryuya nhanŋuway romdja ŋuli marrtjinyamaŋuna, ganydjarryuna wirrkina walꞌŋu bathalana.” ");
INSERT INTO dwy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Waŋgany rulu ga waŋgany baythinyaya walu djuḻkthuna, ga ŋayi Djesuyu garrꞌyuna Peter-na, James-na, ga John-na, märr yurru waya marrtji bukuyi yolŋumiriwyi. Ga ŋunhi waya ŋunha bukuyiya ŋalꞌyuna ga nhäŋaya Djesunaya ŋayi wiripuŋuyinana rumbalya maŋutjiŋu wayaŋgaya. ");
INSERT INTO dwy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ga girriꞌya nhanŋu ŋunhi buluna dhika miḻŋꞌmiḻŋdhuna, watharrthinana ga lanyiŋdhinana, djuḻkmaŋayana gurrana wiripu girriꞌ ŋula watharr. ");
INSERT INTO dwy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ga ganyimꞌthuna waya nhäŋaya ŋunhi ŋayi Djesu gurrana waŋana ŋurikaya bamanꞌŋuwaya yolŋuwaya maṉḏakaya, Elijah-waya ga Moses-kaya. ");
INSERT INTO dwy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ga wirrkina waya ŋunhi ḻuṉḏuꞌmiŋuya waya biyaṉiyina. Ga ŋayi Peter-ya märr-dhumbalꞌyunana ga guyaŋina ŋayi, ŋayŋu waŋana bitjaya gamꞌ, “Wäy Garray, latjuꞌna dhuwaya wirrkina yana! Nhä ŋuli dhuwaya manymak ŋanapu yurru ŋurrŋgitj nhumaŋgu warkthun?... waŋganydja nhuŋu ga waŋganydja Elijah-wu ga wiripuya Moses-ku?” ");
INSERT INTO dwy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ga beŋuya ŋayŋu waŋupiniꞌna maḻŋꞌthuna bala yana bilkthunana wayana. Ŋayŋu waya ŋäkuyana rirrakaynha ŋayi gurrana waŋana beŋu waŋupiniꞌŋu bitjaya gamꞌ, “Ŋäkuna waya! Dhuwanna ŋunhi ŋarrakuwaya walꞌŋu gäthuꞌmiŋu marrkaptja. Nhuma yurru nhanŋuna yana mäkiriꞌ-witjundja!” ");
INSERT INTO dwy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ga ŋunhi waya ŋäkuya rirrakaya, ga ḏawaꞌyunaya ga nhäŋaya waya yana ŋanya Djesuna gänaŋuyina. ");
INSERT INTO dwy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ga beŋuya ŋayi Djesuya ga ḻuṉḏuꞌmiŋuya waya nhanŋu marrtjina yarrupthuna bukuŋuya. Ŋayŋu ŋayi Djesuyu waŋana wayana bitjayana, “Nhä nhuma dhuwaya nhäŋaya, yaka ḻakaŋu yolŋuwu wiripuŋuwu wayaŋgu. Bili ŋarraŋga dhuwaya Yuwalkŋuya Walꞌŋu Yolŋu. Ŋurruŋuya ŋarra yurru rakunydhi ga bulu ŋarra yurru ŋunhi walŋathi. Ga yurruna nhuma ŋuli yolŋuwuya wayaŋgu ḻakaŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ga baṯ-bitjayana waya gurrana ŋunhi dhäruktja ŋanya Djesuna mulkana ga yakana waya yolŋuwu ḻakaŋaya. Ga waya ḻurrkunꞌthuya ḻuṉḏuꞌmiŋuyu wayay dhä-wirrkaꞌyunmina bitjaya gamꞌ, “Nhäku ŋunhi ŋayi bitjayatja waŋana? Be ŋayi yurru bulu rakunyŋuyu gaŋgathi? Nhätjuyuna ŋuli ŋayi biyakuya maḻŋꞌthu?” ");
INSERT INTO dwy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ŋayŋu waya ŋanya dhä-wirrkaꞌyuna bitjayana, “Nhäku ŋuli ŋunhi Rom-marŋgikunhamiyuya wayay ḻakama ŋunhi ŋayi Elijah yurru buna ŋäthiyi, ga yurruna ŋayi Garrayya ŋunhi Maŋutji-ḻakanhawuya yolŋu buni? Ga nhepiya gurra nhattjan guyaŋa, Marrkapmi?” ");
INSERT INTO dwy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ga ŋayi Djesuya buku-roŋinymaŋaya bitjaya, “Yuwalk dhuwayitja. Waya ŋunhi bamanꞌŋuwuy ŋaḻapaḻmiyu wukirri ŋunhi ŋayi Elijah yurru buna ŋurruŋuya, ga ŋäthiyi ŋayi yurru dhukarr buma nhanŋu Christku. Ga ŋayi Christtja ŋunhi Maŋutji-ḻakanhawuy Yolŋu ŋunhi ŋayi God-Waŋarryu ŋäthilꞌyuna dhä-ŋäthiyi yana djuyꞌyuna. Ga nhäku gurra nhumaya yaka dharaŋan dhiyaŋuya wayay ŋunhi dhäruk ŋunha wukirriwuy God-Waŋarrwuŋu ŋunha djorraꞌŋu, ŋunhina ŋunhi Yuwalkŋuwalaŋuwuynha Walꞌŋu Yolŋuwalaŋuwuy? Yurru ḻinyguꞌga waya ŋunhi dhäwuꞌya wukirri, ga yolŋuya waya ŋunhi yaka djälthina ŋayŋu buŋayana waya ŋanya rakunyguŋayana. ");
INSERT INTO dwy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gatjuy latjuꞌkuŋuna waya mäkiriꞌ-witjuya. Ŋunhinaya yolŋuna Elijah-naya ŋunhi ŋayi ŋäthiyi bili bunana. Yurru yolŋuya waya wayaŋguway ŋayaŋuwu malthuna, yana yätjkuŋayana ŋanya nhäŋaya. Ga balanya ŋunhi waya djawarrkmiyu ŋäthiyiya dhäruk wukirri.” ");
INSERT INTO dwy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ga ŋunhi waya Djesu ga ḻurrkunꞌ ḻuṉḏuꞌmiŋu mala nhanŋu bunana wiripu-guḻkuꞌwu, ŋayŋu waya nhäŋaya guḻkuꞌnana yolŋuna wayana. Ŋayŋu ŋunhi yolŋuya waya ḻuŋꞌthunana ga nhäŋaya nhanŋu Djesuwuna ḻuṉḏuꞌmiŋuna wayana ga rom-marŋgikunhamina wayana waya gurrana ŋarrtjunmina. ");
INSERT INTO dwy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ga ŋunhi yolŋuyuya nhäŋaya ŋanya Djesunaya ŋayŋu waya ganyimꞌthunana bili waya guyaŋina ŋanya yana be ŋayi baḏak yana nhinana gurrana bukuŋu. Ŋayŋu waya gumurr-waṉdinana nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ŋayŋu ŋayi Djesuyuya dhä-wirrkaꞌyuna wayana bitjaya, “Nhäku nhuma ŋuli dhuwaya ŋarrtjunmiya?” ");
INSERT INTO dwy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ga ŋayi waŋganydja yolŋu bitjayana waŋana gamꞌ, “Marrkapmi ŋäku ŋarrana! Dhuwaya ŋarra yothuna ḏarramuna ŋarrakuway gäŋaya märr yurru nhe walŋakuma ŋanya. Bäyŋu ŋayi dhuwaya dhärukmiriw ga dhuwaya birrimbirryu yätjthu ŋanya ŋuli mulka. ");
INSERT INTO dwy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ga ŋunhi nhanukaya ŋuli birrimbirr yätjtja gärri yana butparkthuna ŋuli ŋanya munathaꞌyina. Ga yurruna ŋuli nhanukaya ŋälya dhaŋaŋdhi dhurrwarakuya ŋayŋu ŋuli ḻirra-ḻawunhamina ŋayi. Ga rumbalya nhanŋu ŋuli ḏälthina bitjan dharpa. Ga ŋäŋꞌthuna ŋarra dhuwaya ḻuṉḏuꞌmiŋuna wayana nhuŋu guŋgaꞌyunawu, dhawaṯmanhawu dhiyaku birrimbirrwu, yurru gulkuruna.” ");
INSERT INTO dwy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ga ŋunhi ŋayi Djesuyu balanya dhäwuꞌ ŋäkuya ŋayŋu ŋayi maḏakarritjthinana wayaŋgu, “Nhä nhuma dhuwaya yolŋuya waya dharaŋanamiriw, bili ŋarra nhumana dhuwaya marŋgikuŋayatja beŋu bili, bay nhä nhuma gurra dhuwaya dhiryun marŋgithiya? Yaka nhuma gurra ŋarraku yuwalktja märr-yuwalkthi, ŋeniya? Nhämunyꞌnhami ŋarra yurru nhumaŋgu galkundja? Go, gäŋuna waya dhuwayi yothunaya lilina!” ");
INSERT INTO dwy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ŋayŋu waya ḻawꞌmaŋayana ŋunhi yothunaya ga gäŋaya Djesuwayana. Ga ŋunhi ŋayi ŋuriŋi yätjthu birrimbirryu nhäŋaya Djesunaya bala yana ḏupthunana yothunaya munathaꞌyina gunhana ŋayi gurrana ḏurꞌyunmina ga djalkthunmina, ga dhurrwarakuya nhanukaya ŋälnha marrtjina ḻarryuna. ");
INSERT INTO dwy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ga beŋuya ŋayi Djesuyuya dhä-wirrkaꞌyunana ŋunhi bäpaꞌmiŋunaya bitjaya, “Nhätha ŋayi dhuwaya gurrana bitjayatja?” Ŋayŋu ŋayi ŋunhi bäpaꞌmiŋuya bitjayana ḻakaŋaya, “Beŋu yana bili ŋunhi ŋayi yothu ga yana. ");
INSERT INTO dwy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wiyinŋumi ŋayi ŋunhi yätjtja birrimbirr djälthina nhanŋu baymatthunawu. Ga bitjana bili ŋayi ŋuli ŋanya djalkthuna, wiripuya ḏupthun gurthayi ga gapuyi guḻwuḻmanha. Ga buku-djulŋi ŋäthiyi guŋgaꞌyu ŋilinyuna, gu? Ŋuli dhuwaya gumurr-yalŋgiꞌya, maꞌ maŋutji-wuyuna ŋilinyungu, walŋakuŋuna dhuwaya yothuna.” ");
INSERT INTO dwy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ga ŋayi Djesuya bitjana waŋana, “Nhäku nhe bitjayatja waŋana, ‘Ŋuli dhuwayi gumurr-yalŋgiꞌya?’ Ŋarraya yurru dhuwaya djäma yana, ŋuli nhe yurru ŋäthiyi ŋarraku märr-yuwalkthi!” ");
INSERT INTO dwy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ŋayŋu yana ŋayiya ŋunhi bäpaꞌmiŋuya märr-nherraṉminana bitjayana, “Marrkapmi, bilina ŋarra dhuwaya märr-yuwalkthinana. Go, guŋgaꞌyuna ŋarrana, märr ŋarraku yurru märr-yuwalkthinyamiya wirrkina yana ḏälthi!” ");
INSERT INTO dwy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ga ŋulinyamiyu waluyu ŋayi Djesuyu nhäŋayana guḻkuꞌnana yolŋuna wayana waya marrtjina giṯthunmina lili malami. Ŋayŋu ŋayi dhäruk-wekaŋaya ŋuriki yätjku birrimbirrwu bitjaya, “Nhe dhuwaya birrimbirr, walmina dhiyakaya yothuwaya, märr ŋayi yurru ŋämana ga waŋana! Ga yakana buluya gärri nhanukaya!” ");
INSERT INTO dwy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ga ŋunhi ŋayi ŋuriŋi birrimbirryu ŋäkuya Djesunaya dhäruk waŋanhawuyya, ŋayŋu yana ŋayi yatjuna wirrkina. Ŋayŋu ŋayi ŋunhi yothuya galkinana, ḏalalakthinana, bitjan ŋuli ŋayi rakunydhinana. Ŋayŋu yolŋuya waya ḻakanhamina marrtjina ŋunhaya, “Wäy bilina ŋayi dhuwaya rakunydhinana!” ");
INSERT INTO dwy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ŋayŋu ŋayi Djesuyuya goŋnha ŋanya mulkana ŋayŋu gaŋgathinymaŋayana. ");
INSERT INTO dwy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ŋayŋu waya Djesuya ga ḻuṉḏuꞌmiŋuya waya nhanŋu marrtjinana gunhaꞌyunana ŋunhiya wäŋa ga gulŋiyina buṉbuyina. Ga ŋunhayatja waya dhä-wirrkaꞌyunana ŋanya Djesuna bitjaya, “Wäy, nhäku ŋunhi ŋanapuya yaka dhawaṯmaŋaya ŋunhi yätjnha birrimbirrnha?” ");
INSERT INTO dwy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ŋayŋu ŋayi Djesuya waŋana bitjaya, “Latjuꞌkuŋu ŋäkuya! Balanyaya ŋunhi birrimbirr mala yätjnha yana wirrkina. Ga ŋuli nhuma yurru yakaya ŋäŋꞌthun guŋgaꞌyunawu God-Waŋarrnha dhiyaku birrimbirrwu, nhumaya yurru yakana dhawaṯmama yolŋuwayatja.” ");
INSERT INTO dwy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ga beŋuya ŋayi Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu gunhaꞌyunana ŋunhiya wäŋa ŋayŋu marrtjina Galilee-yina makarryi wäŋayi. Ga yaka ŋayi gurrana djälthina waya yurru yolŋu waya marŋgithi ŋunhi ŋayi gurrana nhinana ŋunhaya. ");
INSERT INTO dwy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yo, djälmina ŋayi gurrana, ŋayi yurru ḻuṉḏuꞌmiŋuna wayana nhanŋuway yana marŋgikuma. Ga bitjaya ŋayi waŋanaya gamꞌ, “Yaka wiyinꞌtja, ŋayŋu waya ŋuli ŋarrana goŋ-wekaŋuna wiripuwayana mulkuruwayana yolŋuwaya. Ŋayŋu ŋuli waya ŋarranaya Yuwalkŋunaya Walꞌŋu Yolŋuna baymatthuna murrkaykuŋuna. Ga rakunydhi ŋarra ŋuli yulŋuya, ga bulu walŋathi bulalꞌyu munhayu.” ");
INSERT INTO dwy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yo, bitjaya ŋayi gurrana Djesuyu ḻakaŋaya, yurru nhanŋu ŋunhi ḻuṉḏuꞌmiŋuya waya märr-dhumbalꞌyuna. Ga yakana waya ŋunhi buluya ŋanya dhä-wirrkaꞌyuna. ");
INSERT INTO dwy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ga beŋuya ŋayi Djesuya ga ḻuṉḏuꞌmiŋuya waya nhanŋu marrtjinana, ga bunana wäŋaŋu yäkuŋu Capernaum. Ga dhunupana waya gärrina buṉbuyina ŋayŋu ŋayi Djesuyuya dhä-wirrkaꞌyunana wayana bitjaya, “Wäy, nhäkuŋga nhuma marrtjina ŋunhi dhukarrkuya ŋarrtjunmina?” ");
INSERT INTO dwy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ga wayatja ŋunhi yakana nhanŋu buku-roŋinymaŋaya ŋunhi nhäku waya waŋanhamina marrtjina dhukarrkuyu, yol yurru ŋurruŋuyi beŋu malaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ŋayŋu ŋayi Djesuya nhinanana, ŋayŋu ŋayi marŋgikuŋayana bitjayana, “Ŋuli nhe ŋula yol djälthi gurra nhe yurru ŋurruŋuyi, nhe ŋäthiyi ŋuli biyaku bitjan dhuwaya yolŋu djämamina birrkaꞌmiwuna yolŋuwu.” ");
INSERT INTO dwy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ga ŋayi Djesuyuya yothunana ḻawꞌmaŋaya ŋayŋu dhangiꞌyunana ŋanya, ŋayŋu gunhaꞌyuna gumurryina ga waŋana bitjaya, ");
INSERT INTO dwy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ŋuli nhe yurru ŋula yol yolŋu gumurr-ŋamathi galiꞌwuywu yolŋuwu bitjan dhuwaya yothu, bili ŋayi ŋunhi ŋarraku yolŋu, ŋunhiya nhe ŋarrakuna gumurr-ŋamathi gurra. Ga ŋuli nhe ŋarrakuya gurra gumurr-ŋamathi, ŋunhiya nhe bitjan gumurr-ŋamathi gurra ŋarrakalaŋuwuna bäpaꞌmiŋuwu, ŋurikina ŋunhi ŋayi ŋarrana djuyꞌyuna lili dhipaya munathaꞌyi wäŋayi.” ");
INSERT INTO dwy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ga beŋuya dhurrwaraŋu ŋayŋu ŋayi Djesuwu ḻuṉḏuꞌmiŋu yäku John waŋana bitjaya, “Way marrkapmi, ŋunha ŋanapu nhäŋaya yolŋuna waŋganynha ŋayi gurrana yätj birrimbirr djalkthuna nhokaya yäkuyu. Yurru ŋanapuya ŋanya gulmaŋaya bili ŋayi ŋunhi yaka ŋilimuŋgaya malaŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ŋayŋu ŋayi Djesuya bitjayana buku-roŋinymaŋaya, “Yaka nhuma ŋunhi be gulmanha ŋanya. Bili ŋula yolthu yolŋuyu yurru djäma ganydjarrmi rom ŋarrakaya yäkuyu, ga yalalaya ŋayi yurru ŋunhi yakana ŋarrana yätjkuma waŋa. ");
INSERT INTO dwy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ga ŋunhi ŋayi yolŋu yakaya yurru gulmama ŋilimuna, ŋunhiya ŋayi ŋilimuŋgayana galiꞌŋu. ");
INSERT INTO dwy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Latjuꞌkuŋu guyaŋiya! Ŋuli ŋayi, ŋula yol yolŋu, marŋgi ŋunhi nhe ŋuli malthun Garraywu, bala ŋayiya nhuna yurru guŋgaꞌyuna, bäydhi ŋayi ŋuli nhuŋu gapu yana wekaŋu, God-Waŋarryuya ŋunhinaya yolŋuna ŋayi yurru yakana meṉguma.” ");
INSERT INTO dwy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ga bulu ŋayi Djesu waŋana bitjaya, “Ŋuli yurru ŋula yolthu yolŋuy maŋutji-warryun ŋarraku yothuna yätjthi romdhi, ŋayŋu ŋayi yurru yothuya ŋunhi gulyuna ŋarrakayatja märr-yuwalkthinyaŋuya, latjuꞌna ŋunhi ŋurikiya maŋutji-warryunamiwuya yolŋuwu ŋanyanaya yurru mayaŋꞌnha ḏapmama rakiꞌyuna bathalayuna guṉdayi, ŋayŋu ḏupthun dhulmuyina gapuyi, märr ŋayi yurru guḻwuḻyuna. ");
INSERT INTO dwy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ga ŋuli ŋayi yurru goŋdhu nhokaya yätj warkthun, nheya yana gulkꞌthunmina ŋunhi goŋdja. Bili latjuꞌya nhuŋu nhe yurru djiwarrꞌyiya marrtji goŋ waŋganynha. Ga ŋuli nhe baḏak yana goŋ bulalꞌ, nhunaya ŋuli ḏupthu ŋunha gurthayina ŋunha dhä-ḏirꞌyunamiyina wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ga ŋunhiya bitjan yätjnha wirrkina wäŋa. Ga gurthaya ŋuli yakana bolmuyukthi ŋunhaya wäŋaŋu. Ga mewirriya ŋuli walŋana yana gaḻꞌyunmi, ga yätjkuŋuna ŋuli warrpamꞌnha yana. ");
INSERT INTO dwy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ga ŋuli nhokaya ḻukuyu yurru gäma nhuna ŋula nhäyi yätjthi, gulkthuna dhuwayi ḻukuya. Bili latjuꞌya nhuŋu nhe ŋuli djiwarrꞌyiya gärri ḻuku waŋganynha. Ga ŋuli nhe ḻuku bulalꞌya nhunaya ŋuli ḏupthu ŋunha gurthaꞌyina ŋunha dhä-ḏirꞌyunamiyina wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ga ŋunhiya nhuŋu yätjnha wirrkina wäŋa. Ga gurthaya ŋuli yakana bolmuyukthi ŋunhaya wäŋaŋu. Ga mewirriya ŋuli gaḻꞌyun walŋana yätjkuŋuna ŋula nhä malanynha. ");
INSERT INTO dwy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ga ŋuli nhokaya maŋutjiyu nhuna yurru gäma romdhi yätjthi, nheya yana ḏulŋurrꞌyuna maŋutjiya nhuŋuway ŋayŋu ḏupthuna. Bili latjuꞌya nhuŋu nhe yurru djiwarrꞌyiya gärri maŋutji waŋganynha. Ga ŋuli nhe maŋutji bulalꞌya, nhunaya ŋuli ḏupthu ŋunha gurthaꞌyina ŋunha dhä-ḏirꞌyunamiyina wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Ga ŋunhiya nhuŋu yätjnha wirrkina wäŋa. Ga gurthaꞌya ŋuli yakana bolmuyukthi ŋunhaya wäŋaŋu. Ga mewirriya ŋuli walŋana yana gaḻyun, yätjkuŋuna ŋuli ŋula nhä malanynha.’ ");
INSERT INTO dwy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yo, ga God-Waŋarryuya ŋuli ŋunhi dhunupakuma nhanŋu malthunaminaya wayana gumurr-ḏälkuyuna romguyu, bitjan ŋuli yolŋuyu bilyuꞌbilyunmama nhanŋuway gara dhunupakuma gurthaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Manymak, djoḻya dhuwaya manymak, ŋuriŋi ŋuli ŋunhi ŋathaya dhäkaymiyi. Ga ŋuli yurru dhäkaya dhawarꞌyun ŋunhiya yätjnha, ŋayŋu ŋuli djalkthuna. Yo, nhumaya dhuwaya bitjan ŋunhi djoḻnha, dhäkaymiyanhawu märr nhuma yurru latjuꞌkumana nhinaya yolŋuwayatja malaŋu, märr-ŋamathinyamina yurru bukmaknha! Balanya dhuwaya! Märr gaŋga waya ŋarrtjunmiya, yol yurru buŋgawayiya ga yol bäyŋu!” ");
INSERT INTO dwy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ŋayŋu ŋayi Djesuya marrtjina Judea-yina makarryi wäŋayi. Ga bitjayana bala ŋunha galiꞌyina wiripuyina wäŋayi ŋunhana galki Jordan-na mayaŋꞌ mulkana. Ga guḻkuꞌna ŋunhi yolŋuya waya ḻuŋꞌthuna nhanukaya. Ga bulu ŋayi gurrana marŋgikuŋaya. ");
INSERT INTO dwy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ga Pharisee waya marrtjina märr waya yurru dhä-wirrkaꞌyun yurru gatjarrꞌyun ŋanya, “Nhattjan gurra ŋunha ŋilimuŋguya rom waŋa,... ŋayi yurru ḏarramuyuya gunhaꞌyun nhanŋuway miyalknha ŋayŋu djuyꞌyuna ŋanya?” ");
INSERT INTO dwy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ga ŋayi Djesuya buku-roŋinymaŋaya bitjaya, “Guyaŋi ŋäthiyi, nhattjan gurra ŋunhi Moses-kuya waŋa rom ŋurikiya ŋilimuŋgalaŋuwuya romgu?” ");
INSERT INTO dwy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ga wayatja buku-roŋinymaŋaya, “Ŋunha Moses-kuŋuya rom bitjan waŋa gurra ŋilimuŋgu gamꞌ, Ŋurruŋuya ŋayi ŋäthiyi yurru djorraꞌ wukirri gunhaꞌyunaminyawu, ga yurruna ŋanya gunhaꞌyundja yurru gupa-ḏälnha.” ");
INSERT INTO dwy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ŋayŋu ŋayi Djesuya waŋana bitjayana, “Ŋäku waya! Yuwalk ŋayi ŋunhi Moses-dhuya bitjaya rom nherraya, bili nhuma dhuwaya ŋayaŋu-ḏälmi. ");
INSERT INTO dwy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ga yaka waya ŋunhiya dhäwuꞌ meṉguŋu ŋe!, ŋunhi dhäwuꞌ ŋurru-yirrꞌyunawuy, ŋunhi ŋayipi God-Waŋarryu djäma dhuwaya djiwarrꞌ wäŋa ga dhuwaya munathaꞌ! Ŋunha gurra wukirriwuy djingaryun bitjan gamꞌ, ‘God-Waŋarryu ŋunhi djäma yolŋunaya, ḏarramuna ga miyalknha. ");
INSERT INTO dwy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ga ŋurikina ŋurruwu ŋayi yurru ŋunhi ḏarramuyuya gunhaꞌyun nhanŋuway ŋäṉḏiꞌmiŋunaya ga bäpaꞌmiŋunaya, ŋayŋu marrtjina ga ŋätthuna nhanŋuway miyalknhaya, märr maṉḏa yurru nhina ŋayaŋu-waŋganynha, ");
INSERT INTO dwy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ga bulalꞌ ŋunhi rumbalya maṉḏa yurru waŋganydhinana.’ ");
INSERT INTO dwy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ga ŋayi God-Waŋarryuna maṉḏana ŋuli waŋgany-manapandja, ga yakana maṉḏana yurru ŋula yolthu barrkuwatjkuma, bili ŋunhiya yätjnha wirrkina rom!” ");
INSERT INTO dwy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ga beŋuya ŋayi Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu gulŋiyina buṉbuyina. Ga ŋunhaya waya ŋanya ŋäŋꞌthunaya Djesuna bitjaya, “Nhä nhe gurrana ŋanapuna marŋgikuŋaya ŋäthiyiya?” ");
INSERT INTO dwy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ga ŋayi Djesuya buku-roŋinymaŋaya bitjayana, “Ŋunhi yurru ḏarramuyu gunhaꞌyun nhanŋuway miyalknha ga ŋätthun ŋayi yurru ŋunha wiripunana, ŋunhiya ŋayi gurra marrambaꞌna warkthun. ");
INSERT INTO dwy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ga balanya bili miyalkuya. Ŋuli ŋayi yurru gunhaꞌyun nhanŋuway dhuwayꞌmiŋunaya ŋayŋu waṉḏi yurru ga ŋätthun wiripunana, ŋunhiya bitjan marrambaꞌna gurra djäma.” ");
INSERT INTO dwy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Waŋganymiyu, yolŋuy wayay gäŋaya wayaŋgu djamarrkuḻina Djesuwaya, märr ŋayi yurru wayaŋgaya goŋ-ŋalꞌyun ga ŋäŋꞌthun God-Waŋarrnha märr nhanŋu yurru ŋunhi ŋayaŋu-latjuꞌkunhami rom maḻŋꞌthun wayaŋgaya. Ŋayŋu waya ŋunhi ḻuṉḏuꞌmiŋuya wayay ŋarrtjunana wayana gukuŋayana. ");
INSERT INTO dwy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ga ŋunhi ŋayi Djesuyu nhäŋaya wayana balanyayi ŋayŋu ŋayi maḏakarritjthinana nhanukalaŋuwu ḻuṉḏuꞌmiŋuwuya wayaŋgu ŋayŋu ŋayi waŋana bitjayana, “Yaw, yaka dhuwayi yumurrkuꞌnaya gukuŋu, bili God-Waŋarrwuya dhuwaya yolŋu waya balanya bitjan dhuwaya yumurrkuꞌ. ");
INSERT INTO dwy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yo, latjuꞌkuŋu waya biyaku guyaŋi. Ŋuli yurru ŋula yol yolŋu yuwalktja walꞌŋu djälmiyi God-Waŋarrwuya, wayatja yurru yuwalknha yana ŋayaŋumiyi nhanŋu, bitjan dhuwaya djamarrkuḻi ŋuli yuwalkkumaya ŋayaŋumiyi wayaŋgalaŋuwu ŋäṉḏiꞌmiŋuwu ga bäpaꞌmiŋuwu. Ga ŋuli yakaya ŋayaŋumiyi nhanŋu Godku, waya yurru yana yakana God-Waŋarrwuya djamarrkuḻi.” ");
INSERT INTO dwy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ga beŋu dhurrwaraŋu ŋayŋu ŋayi Djesuyuya wayana djamarrkuḻinaya ḻawꞌḻawmaŋayana, ŋayŋu ŋayi goŋ-ŋalꞌyuna ga bukumiyaŋaya God-Waŋarrwayana märr ŋayi yurru wekamana nhanŋuway märr-ŋamathinyamiya rom wayaŋgayana, bukmakayana yana. ");
INSERT INTO dwy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ga ŋunhi ŋayi Djesu gurrana gurkuꞌyuna marrtjinyawu, bala ŋayi ḏarramuna bunana nhanŋu. Ga buṉꞌkumu djipthuna ŋayi Djesuwaya ŋunhanaya bili gumurrŋuna nhanukaya bala ŋayi dhä-wirrkaꞌyunana bitjayana, “Manymak Marŋgikunhami, ŋarra nhuna yurru dhuwaya dhä-wirrkaꞌyun ŋäthiyi. Balanyawu gamꞌ: Nhattjan dhika ŋarra yurru yulŋuya, märr ŋarra yurru marŋgithi ŋunhi ŋarra ŋuli djiwarrꞌŋuya nhini God-Waŋarrwayatja wiyinŋumi, walŋa-dhawarꞌyunamiriwnha?” ");
INSERT INTO dwy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ga ŋayi Djesuya buku-roŋinymaŋaya, “Nhäku nhe dhuwaya bitjayatja waŋana, ‘Manymak Marŋgikunhami’?, bitjayatja. Yaka dhuwaya ŋula yol yolŋu yuwalktja walꞌŋu latjuꞌ, God-Waŋarr yana ŋayipi latjuꞌya. ");
INSERT INTO dwy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Biliŋga nhuma dhuwaya God-Waŋarrwuya dhärukku marŋgi ŋunhi gurra bitjan waŋa, ‘Yaka yolŋuna baymatthu rakunykuŋu; Yaka marrambaꞌthi; Yaka manaŋi: Yaka nyäḻ ḻakaŋu; Yaka mayaliꞌ-wilkthu yolŋuna, bala marrtji bala manaŋina nhanŋu nhä malanynha; Märr-ŋalꞌyu nhokalaŋuwu ŋäṉḏiꞌmiŋuwu ga bäpaꞌmiŋuwu.’ ” ");
INSERT INTO dwy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ŋayŋu ŋayi ŋunhi yolŋuya bitjayana waŋana, “Yuwalk yana marrkapmi Marŋgikunhami. Ŋarraya gurrana dhuwaya mulkana ga malthuna dhiyaku romgu beŋu bili yana ŋunhi ŋarra yothuŋga yana.” ");
INSERT INTO dwy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ŋayŋu ŋayi gurrana Djesuyuya nhäŋayana ŋunhi yolŋunaya ŋayaŋuyuna latjuꞌyuna ŋayŋu ŋayi bitjayana waŋana, “Gatjuy roŋiyina wäŋayina ga djalimnha nhuŋuway nhäya malany warrpamꞌthuna yana. Ga ŋuli nhe yurru rrupiyaya ŋätthun bala mala-gulkthuna ŋunhiya, ŋayŋu wekuŋu ŋunha ŋurruwuyknhana yolŋuna wayana. Ŋayŋu nheya yurru ŋarrakuna malthun. Ga yalalaya ŋayi yurru God-Waŋarryuya buku-roŋinymama wekama nhunaya nhä malanynha ŋunhaya djiwarrꞌŋuna.” ");
INSERT INTO dwy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ga ŋunhi ŋayi ŋuriŋi yolŋuyu balanya ŋäkuya Djesunaya, ŋayŋu nhanŋu ŋayaŋuya-yätjthinana. Ŋayŋu ŋayi wäŋayina marrtjina galŋa-yätjthinana, bili ŋayi ŋunhi yuwalknha yana ḻukunydjaꞌya. ");
INSERT INTO dwy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ŋayŋu ŋayi Djesuyuya nhäŋayana marrtjina, ŋayŋu ŋayi waŋana nhanukalaŋuwaya ḻuṉḏuꞌmiŋuwaya bitjaya, “Gumurr-ḏälnha dhuwaya wirrkina yana ḻukunydjaꞌwuya yolŋuwu gärrinyawu ŋayŋu djiwarrꞌyiya!” ");
INSERT INTO dwy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ga ŋunhi waya ḻuṉḏuꞌmiŋuyu ŋäkuya ŋanya balanyawuy waŋanhaya ŋayŋu waya märr-dhumbalꞌyunana. Ga ŋayi Djesuya bulu waŋana bitjaya, “Ŋäkuya waya latjuꞌkuŋu! Ḏäl dhuwaya wirrki gulŋinyawu God-Waŋarrwayatja gurruṯumiwayatja Romdhi. ");
INSERT INTO dwy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Guyaŋi ŋunhi wäyina yäkuna camel-nha. Yuwalk ŋayi ŋunhi wirrkina gumurr-ḏälnha nhanŋu gärrinyawu ŋunha yutjuwaḻaꞌya ŋarŋga ṉelŋu, ŋunhi girriꞌ ŋuli dharpuma. Yo, balanyana ŋunhi yulŋuya ḻukunydjaꞌwuya yolŋuwu, wirrkina yana gumurr-ḏälnha gärrinyawu God-Waŋarrwayatja Romdhi.” ");
INSERT INTO dwy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ga nhattjaya ŋayi ŋunhi Djesu waŋana, ŋunhiya waya wirrkina dhumbalꞌyuna. Ŋayŋu waya gurrana dhä-wirrkaꞌyunmina bitjayana, “Ga, ŋuli ŋayi gurra yuwalktja bitjan ḻakama, ga yolnha ŋuli ŋunhi yuwalktja nhini ŋunhayatja djiwarrꞌŋuya nhanukaya God-Waŋarrwayatja?” ");
INSERT INTO dwy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ŋayŋu ŋayi Djesuyuya nhäŋayana marrtjina, ga bitjayana ŋayi waŋana, “Yolŋuya yurru ŋunhi yaka gänaꞌ gulŋiyi God-Waŋarrwaya Romdhi nhanukiyingaya ŋayi ganydjarryu. Yurru yaka waya meṉguŋu, ŋayipi God-Waŋarryu mulka gurra ganydjarr gärrinyamanhawuya yolŋuwu nhanukiyingaya Romdhi. God-Waŋarryuya djäma yana nhä malanynha bukmak.” ");
INSERT INTO dwy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ga ŋayi Peter-ya waŋana buku-roŋinymaŋaya bitjana, “Marrkapmi. Ŋanapuya dhuwaya bili gunhaꞌyuna nhä mala ŋanapuŋguway ŋayŋu malthuna nhuŋuna. Ga nhä dhika ŋanapuŋguya buku-roŋinymanhaya?” ");
INSERT INTO dwy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ŋayŋu ŋayi Djesuya bitjayana waŋana, “Ŋarra nhumaŋgu yurru ḻakamana! Ŋuli yurru ŋula yol yolŋu djälmiyi malthunawu ŋarrakuya, bala marrtji yurru gunhaꞌyuna nhanŋuway ŋäṉḏiꞌmiŋuna, ga bäpaꞌmiŋuna, ga yumurrkuꞌna, ga guthaꞌmiŋuna, ga wäŋa ga djäma nhanŋuway ga nhä malanynha girriꞌ nhanŋu. Ga yurruna ŋayi yurru marrtjiya gurra buku-ḻiwꞌmamana yolŋuwaya wayaŋgaya dhäwuꞌna yurru latjuꞌna ḻakama ŋarrakalaŋuwuynha. Ga yalalana nhanŋuya ŋuli buku-roŋinymaŋu God-Waŋarryuna buluna walꞌŋu dhaŋaŋnha bukuyi-ŋalꞌmaŋu. Nhä malanynha ŋuli yolŋuyu gunhaꞌyuna, nhanŋuya ŋuli guḻkuꞌna buku-roŋinymaŋu God-Waŋarryu. Ga ŋayaŋu-wutthunamiya rom ŋuriŋi yolŋuyu ŋuli ŋätthun yana wiripuŋu yolŋuwuŋu, bili ŋayi ŋuli ŋunhi ŋarraku malthun. Ga yalalaŋumina ŋunhi ŋayi dhuwaya munathaꞌ wäŋa dhawarꞌyu, bala ŋayi ŋuli ŋunhi nhiniya wiyinŋumina, walŋa-dhawarꞌyunamiriwnha ŋunhayana galkina yana God-Waŋarrwayana. ");
INSERT INTO dwy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ga ŋuli yurru yolŋu bitjandja bili guyaŋinyami yindikunhamiya, ŋunhayatja ŋayi yurru nyumukuṉinydhina, nhäŋaniŋꞌthina. Ga ŋunhi nhäŋaniŋꞌtja yutjuwaḻaꞌya ŋuli ŋurruŋuyina ŋunhayatja.” ");
INSERT INTO dwy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ga balanyamiyu waya ŋunhi marrtjina ŋayŋu Jerusalem-dhina ga ŋayiya gurrana ŋunhi Djesuya ŋurruŋuna bitjaya marrtjina ga wayatja ḻuṉḏuꞌmiŋuya waya nhanŋu ga wiripu yolŋu waya gurrana ŋapa-munguyunana ŋanya. Ga guyaŋina waya marrtjina dhäruk ŋanya waŋanhaya bitjanaya, “Yolŋuyu wayay ŋarrana ŋuli baymatthuna ŋunhaya Jerusalem-dja.” Ga wirrkina waya ŋunhi bitjaya ganyimꞌthuna, biyaṉina manapaya. Ga ŋayi wayana Djesuyuya ŋäkuya ŋayŋu ŋayi ḻuŋꞌmaŋayana nhanŋuwaya ḻuṉḏuꞌmiŋuna wayana ga bulu ŋayi ḻakaŋaya nhatju ŋuli yolŋuyu wayay ŋanya mulki ŋunhaya Jerusalem. ");
INSERT INTO dwy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ga bitjaya ŋayi waŋana, “Ŋäku waya nhuma! Dhuwaya ŋilimu gurra marrtjina yulŋuya Jerusalem-dhina. Ga dhuwanna ŋarra yulŋuya Yuwalkŋuya Walꞌŋu Yolŋu, dhuwaya waya ŋuli ŋarrana goŋ-wekuŋuna ŋurruŋu-ḏalkarramiwuna wayaŋgu ga rom-marŋgikunhamiwuna wayaŋgu. Ŋayŋu waya yurru ŋarraku yoranhamina rakunydhinyawuna. Ŋayŋu waya ŋuli ŋarrana goŋ-wekuŋuna ŋunha wiripuwayana yolŋuwaya wayaŋgaya, ŋunhi waya dhuŋa God-Waŋarrwu. ");
INSERT INTO dwy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ga ŋunhayana waya ŋuli ŋarrana gora-wekuŋuya. Dhupthuyu waya ŋuli ŋarrana ga bartjunmaŋu rakiꞌyu, ŋanaknha ŋarrana baymatthuya. Ga dhurrwaraŋu beŋuya bala waya ŋarrana ŋuli murrkayꞌkuŋuna baymatthu. Ga yuwalk yana ŋarra ŋuli ŋunhi rakunydhiya, ga munha bulalꞌ ŋuli djuḻkthu ŋayŋu bulu ŋuli walŋathi.” ");
INSERT INTO dwy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ga beŋuya dhurrwaraŋu bala maṉḏa ŋunhi Zebedee-wu gäthuꞌmiŋu maṉḏa James ga John marrtjina withiya Djesuna. Ŋayŋu maṉḏa ŋäŋꞌthunana ŋanya bitjayana, “Marrkapmi Marŋgikunhami, dhuwaya ŋilinyu gurra dhäruk nhuŋu mulka.” ");
INSERT INTO dwy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ŋayŋu ŋayi Djesuyuya maṉḏana dhä-wirrkaꞌyunana bitjayana, “Nhäku nhuma yurru ŋäŋꞌthundja?” ");
INSERT INTO dwy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ga maṉḏaya bitjayana waŋana, “Marrkapmi, yalalamiyuya nheya yurru dhuwaya ŋurruwuŋmina walꞌŋu ŋurru-warryunamina ŋanapuŋgu. Ga ŋula nhe yurru bitjandhi bili ŋilinyuŋguya guyaŋi? Märr yurru ŋilinyu nhokayana galki. Waŋganydja yurru nhina nhokaya dhunupaꞌŋu galiꞌŋu ga wiripuya yurru nhina wiṉꞌkuŋuna galiꞌŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ga ŋayiya Djesuyuya buku-roŋinymaŋaya, “Yaka nhuma dhuwaya marŋgi nhäku nhuma gurra dhuwaya ŋäŋꞌthun. Ŋarraya ŋuli dhuwaya yalalaŋumiya galŋa-wiḻyuna wirrkina yana. Wanhana? Nhattjuna nhumaya ŋuli... biyaku bili galŋa-wiḻyu bitjan ŋarra, ga yana bili ga rakunydhi ŋuli?” ");
INSERT INTO dwy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ga maṉḏaya waŋana, “Ŋe... biyaku bili Marrkapmi.” Ga ŋayiya Djesuyuya buku-roŋinymaŋaya bitjaya, “Yo, yuwalk yana nhuma ŋuli ŋunhi galŋa-wiḻyuya, biyaku bili bitjan ŋarra. ");
INSERT INTO dwy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wäy-y, ŋunhiya ŋuli ŋayipina God-Waŋarryuna mala-djarrꞌyu, yol ŋuli nhini dhunupaꞌŋuya ga yol wiṉꞌkuŋuya galiꞌŋu. Ga bili ŋayi ŋunhi ŋäthiyi yana mala-djarrꞌyundja. Ŋunhiya ŋunhi yaka ŋarraku mala-djarrꞌyunawu.” ");
INSERT INTO dwy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ga ŋunhi waya wiripu-guḻkuꞌyuya ḻuṉḏuꞌmiŋuyu wayay ŋäkuya maṉḏana dhäruktja balanyawuy waŋanhaya, bala waya maḏakarritjthinana maṉḏaku. ");
INSERT INTO dwy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ŋayŋu ŋayi Djesuyuya wayana ḻuŋꞌmaŋayana ŋayŋu bitjayana waŋana, “Marŋgiŋga nhuma dhuwaya: ŋunhi dhiyaŋuya bala ŋurru-warryunamina yolŋu waya balanyawu, rom-ḏälmina, buŋgawakunhamina waya ŋuli yolŋuwuya wayaŋgu bukmakkuna. Balanyana ŋuli dhuwaya maḻŋꞌthundja buku-ḻiwꞌmama dhiya munathaꞌŋuya wäŋaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yurru nhumaya yurru yaka bitjandhi. Ga ŋuli nhe ŋula yol yolŋu dhipuŋu malaŋu gurra djälmiyi ŋurruŋuyinyawu, nhe ŋäthiyiya yurru djämamiyi wiripuŋuwu yolŋuwu wayaŋgu. ");
INSERT INTO dwy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ga ŋuli ŋayi yolŋu djäl ŋurruŋuthinyawu, ŋayi yurru djämamiyi bukmakkuna yana yolŋuwu. ");
INSERT INTO dwy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bili ŋarraya, ŋunhi Yuwalkŋuya Walꞌŋu Yolŋu, yaka ŋarra lili marrtjina märr waya yurru djäma ŋarraku. Marrtjinaya ŋarra lili märr yurru ŋarra djäma yolŋuwu wayaŋgu. Ŋarraya ŋunhi marrtjina ŋarra yurru rakunydhina mundhurr-wekamana, märr yurru ŋuruŋiya bäyarraꞌyuya, roŋinymamana yurru yolŋunana yätjŋuna romŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yo, Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu ga wiripu guḻkuꞌ yolŋu waya bunana ŋunhaya Jericho-nha wäŋaŋu. Ga ŋunhi waya gunhaꞌyunaya ŋunhiya wäŋaya, waṉgany yolŋu gurrana bambay nhinana galiꞌŋu dhukarrŋu yäku Bartimaeus, Timaus-ku gäthuꞌmiŋu, ŋäŋꞌthuna nhinana. ");
INSERT INTO dwy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ga ŋunhi ŋayi ŋuriŋi ŋäkuya ŋanya Djesuna ŋunhi Nazareth-puyŋunaya djuḻkthunaya, ŋayŋu ŋayi yatjunana bathalana rirrakay bitjayana, “Djesu, David-kuŋu mala-bunhaya, bilina ŋanapu wiyinŋumina gurrana galkunaya nhuŋu. Go, maŋutji-wuyuna ŋarraku.” ");
INSERT INTO dwy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ga waya ŋunhi yolŋuyuya wayay ŋäkuya ŋanya yatjunaya ŋayŋu waya marrtjinana ŋarrtjunana ŋanya, “Ye,... mukthu!” Ga ŋayiya wirrkina yatjuna bitjaya, “Djesu! David-ku mala-bunhaya, maŋutji-wuyu ŋarraku!” ");
INSERT INTO dwy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ŋayŋu ŋayi Djesuya gulyunana ŋayŋu bitjayana waŋana, “Go, lili waya ŋanya gäŋu!” Ga wayatja marrtjina nhanukaya, ŋayŋu waŋanana, “Ye, bilina mukthuna. Ŋunha nhuŋu gurra ŋayi wäthuna. Maꞌ, go, gaŋgathina!” ");
INSERT INTO dwy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ga ŋayiya ŋunhi Bartimaeus-thuya ŋäkuya ŋayŋu yana yupmaŋayana nhanŋuway girriꞌ gayanhꞌthanhawuy ŋayŋu djingaryunana waḏutja yana, ŋayŋu marrtjina wirrkina bala Djesuwayana. ");
INSERT INTO dwy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ŋayŋu ŋayi Djesuyuya ŋanya dhä-wirrkaꞌyunana, “Nhäku nhe djälya?” Ga ŋayiya ŋunhi bambaya buku-roŋinmaŋaya bitjaya, “Buku-djulŋi, djälmiyi ŋarra gurra dhuwaya nhänharawuna!” ");
INSERT INTO dwy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ga bulu ŋayi Djesu waŋana nhanŋu, “Bilina nhe dhuwaya märr-yuwalkmiyinana, ŋarraya yurru walŋakumana nhuna. Yo, ḻinyguna nhe dhuwaya latjuꞌna, gatjuy marrtjina!” Ŋayŋu nhanŋu Bartimaeus-kuya maŋutji dhunupana yana latjuꞌyinana. Ga beŋuya ŋayi gurrana malthunana nhanŋu Djesuwuna. ");
INSERT INTO dwy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yo, Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu marrtjina ŋayŋu Jeruselem-dhi, ga bunana waya ŋunhaya wäŋaŋu yäkuŋu galki Bethany ga Bethphage ŋunhayana bukuŋuna yäkuŋu Mount-Olive-nha. ");
INSERT INTO dwy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ŋayŋu ŋayi Djesuyu waŋana nhanŋuway märrmaꞌ ḻuṉḏuꞌmiŋuna bitjaya, “Gatjuy marrtjina maṉḏa. Ga ŋunhi nhuma yurru ŋunhaya wäŋa mulka, maḻŋꞌmamaya nhuma yurru wäyinnha yäkuna duŋꞌkina djingaryun yurru gurra garrwiꞌyunawuy dharpaŋu. Ga bäyŋu ŋula yolŋuyu ŋunhi bäki. Ga yupmama nhuma yurru rakiꞌ, ŋayŋu lilina gäŋu ŋarrakayana. ");
INSERT INTO dwy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ga ŋuli yurru yolŋuy dhä-wirrkaꞌyun bitjan, ‘Nhäku nhuma gurra dhuwayi duŋꞌkinaya yupmama?’ bitjandja, ga nhumaya yurru bitjan waŋa, ‘Garray ŋunha dhiyaku djälthina, ga yalala ŋayi yurru roŋinymama nhuŋu.’ ” ");
INSERT INTO dwy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ga ŋunhi maṉḏa marrtjinaya yana nhäŋayana ŋunhi duŋꞌkinaya, yurru yutjuwaḻaꞌ, djingaryuna gurrana garrwiꞌyunaya gumurrŋu buṉbuŋu. ");
INSERT INTO dwy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ŋayŋu yolŋuya wayay dhä-wirrkaꞌyunana maṉḏana bitjaya, “Way! Nhäku nhuma gurra dhuwayi duŋꞌkinaya yupmama?” ");
INSERT INTO dwy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ga maṉḏaya waŋana, “Garray dhuwaya dhiyaku djälthina, ga yalala ŋanapu yurru nhuŋu roŋinymama.” Ŋayŋu waya dhayuŋayana ŋunhi duŋꞌkinaya. ");
INSERT INTO dwy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ŋayŋu maṉḏaya ŋunhi gäŋayana duŋꞌkinaya Djesuwayana. Ga ŋunhayatja waya marrtjina gayanhꞌthakuŋaya girriꞌna wayaŋguway waya ḏiltjiyina duŋꞌkiwayana, ŋayŋu ŋayi Djesuya ŋalꞌyunana nhanukaya ḏiltjiyina bala marrtjina Jerusalem-dhina. ");
INSERT INTO dwy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ga guḻkuꞌyuna ŋunhi yolŋuyu waya rarrꞌyuna girriꞌya gayanhꞌthaya wayaŋguway waya dhukarryi. Ga wiripu-guḻkuꞌyu yolŋuyu wayay baṉdja ḏaw-ṯawꞌyuna manꞌtjarr guḻwirri, ŋunhi djingaryun marrtji galiꞌkuyu dhukarrkuyu. Ŋayŋu waya marrtjina dhukarryina rarrꞌyuna märr ŋayi yurru ŋunhi ḏuŋꞌkiya gayanhꞌthakuna marrtji. Rom wayaŋgu gurrana dhärrana waya yurru bitjan goŋmiwuya yolŋuwu gumurr-ŋamathi. Ga wiripu yolŋu waya gurrana marrtjina ŋurruŋu, ga wiripuya dhuḏitj gurrana marrtjina. ");
INSERT INTO dwy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ga bitjayaŋga waya marrtjina ŋunhi yatjunminaya, “Yo yo-o-oy! Hosanna! God-Waŋarr marrkapmi, dhuwaya ŋanapu gurra wokthun yana nhuŋu! Dhuwaya ŋayi gurra marrtji God-Waŋarrwaya yäkuyu. Ŋayi ŋunhi God-Waŋarryu ŋanya djuyꞌyuna, ga dhuwaya ŋayi lilina marrtjinaya. ");
INSERT INTO dwy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yo, yo-o-oy! Hosanna! God-Waŋarr marrkapmi, dhuwaya ŋanapu ŋuli gurra wokthun yana nhuŋu! God-Waŋarr marrkapmi, nheya yurru dhuwanna yolŋuna buŋgawakumana bukmakkuna yana Jew-wu yolŋuwu wayaŋgu, balanya nhanŋu ŋunhi mala-ŋurrkanhayŋuya King David-tja. Yo, yo-o-oy! Hosanna! God-Waŋarr marrkapmi, dhuwaya ŋanapu ŋuli gurra wokthun yana nhuŋu! God-Waŋarr, ŋunha djiwarrꞌŋuya nheya dhuwaya bathala!” ");
INSERT INTO dwy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ga ŋunhi waya Djesu ga ḻuṉḏuꞌmiŋu waya bunana ŋunhaya ŋunhi God-Waŋarrwaya Dhuyuŋu Buṉbuŋu bala ŋayi marrtjina nhäŋaya ḻiwꞌmaŋaya, bukmaknha yana ŋunhi buṉbuna malany ŋunhaya ḻoḻuŋu, ŋunhi marrtji djingarꞌdjingaryuna. Ŋayŋu ŋunhi waluya milmitjpayinana, bala ŋayi Djesuyuya gunhaꞌyunana ŋunhiya buṉbu, bala ŋayi ga ḻuṉḏuꞌmiŋu waya nhanŋgu 12 roŋiyina marrtjina ŋayŋu Bethany-yina. ");
INSERT INTO dwy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ga wiripuyu waluyu djaḏawꞌyunayu ŋayi Djesu ga guyurrꞌmiŋu waya nhanŋu marrtjina beŋu Bethany-ŋu bala Jerusalem-dhi. Ga gandarrŋuya bala ŋayi Djesuya djaṉŋarrthinana. ");
INSERT INTO dwy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ŋayŋu ŋayi nhäŋaya dharpa, djingaryuna gurrana galiꞌŋu dhukarrŋu. Ŋunhiya dharpa balanya bitjan muthi. Ga marrtjina ŋayi galkithina borumgu maḻŋꞌmanhawu yurru bäyŋu yana. Yo, marwattja gurrana guḻkuꞌna yana giḻyuna, yurru bäyŋu yana borumdja, bili yaka yana nhanŋu walu. ");
INSERT INTO dwy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ŋayŋu ŋayi Djesu waŋana ḏälyu dhärukthu ŋunhiyi dharpana bitjana, “Yaka yurru yolŋuyu buluya ḻuka nhokaya borrum!” bitjaya. Ga waya ŋunhi ḻuṉḏuꞌmiŋuyuya wayay nhanukaya ŋäkuya ŋanya balanya dhäruk. ");
INSERT INTO dwy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ŋayŋu ŋayi Djesuya ga ḻuṉḏuꞌmiŋu waya nhanŋu marrtjina Jerusalem-dhina. Ga bulu ŋayi marrtjina ŋunhimana wäŋayi ŋunhi God-Waŋarrwayana Dhuyuyi Buṉbuyi. Ga ŋunhaya ṉapuŋga Dhuyuŋu Buṉbuŋu malanyŋu gurrana dhärrana dhuyu munathaꞌ, yurru yolŋuyu wayay marrtjinya ŋuli wäyin mala wuŋiḻiꞌyuna mundhurr-wekanha. Ga wiripuya waya gurrana rrupiya buku-yuḻkmanhamina. Yaka waya ŋunhi ŋuriki buṉbuwu rumꞌrumdhuna, yätjnha waya gurrana djäma. Ga wiripuya yolŋuyu wayay gurrana rrupiya mala buku-yuḻkthunmina ŋunhi waya gurrana manaŋina manapaya. Ŋayŋu ŋayi Djesuyuya wayana bukmaknhana yana dhawaṯmaŋaya warraŋulyina, djalkthunana ŋayi wayaŋgu daybuḻya, rrupiya manapaya, ga nhinanhami mala wayaŋgu ŋunhi waya gurrana wäyinꞌ djälim. ");
INSERT INTO dwy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ga gulmaŋaya ŋayi yolŋuna wayana girriꞌŋu gänharaŋu: Yaka yurru gäma ṉapuŋgakuyu ŋulawitjan dhuyukuyu munathaꞌkuyu, rom gurra waŋa. ");
INSERT INTO dwy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ŋayŋu ŋayi Djesuyuya gurrana marŋgikuŋayana bukmaknha yana bitjayana, “Bamanꞌ ŋäthiyi ŋayi God-Waŋarr waŋana nhanukaya djawarrkmiwaya yolŋuwaya ŋayi yurru wukirri dhäruk bitjan, ‘God-Waŋarrwuya Buṉbu yurru dhärra bukmakku bäpurruꞌwu yolŋuwu buku-ŋalꞌyunawu.’ Ga nhumaya dhuwaya Buṉbuna warkuꞌyuna warray, yanapi dhuwaya manaŋganmiwu wayaŋgu buṉbu.” ");
INSERT INTO dwy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ga ŋunhi waya ŋurruŋu-ḏalkarramiyu waya ga rom-marŋgikunhamiyu malay ŋäkuya ŋunhi nhättjan ŋayi Djesuyu djäma, ŋayŋu waya wirrkina ŋayaŋu-yätjthinaya. Ŋayŋu waya gurrana waŋanhamina dhukarrwuna ḻarruŋaya bunharawuna nhanŋu, yurru waya ŋunhi biyaṉiyina nhanŋu bili bukmaktja wiripu-guḻkuꞌya yolŋu waya gurrana märr-ŋamathina Djesuwu wirrkina, bili ŋayi gurrana wayana latjuꞌkuŋaya yana marŋgikuŋaya. ");
INSERT INTO dwy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ga ŋunhi waluya nyilŋꞌthuna ŋayŋu ŋayi Djesu ga ḻuṉḏuꞌmiŋu nhanŋu marrtjinana beŋu Jerusalem-ŋuya bala Bethany-yina. ");
INSERT INTO dwy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Ga wiripuŋuyuna waluyu ŋayi Djesu ga guyurrꞌmiŋu waya nhanŋu roŋiyina balayi Jerusalem-dhi. Ga gandarrŋuya waya djuḻkmaŋaya ŋunhiyi dharpa ŋunhi ŋayi Djesuya waŋana ḏälyuna dhärukthu. Ga wayatja ŋunhi ḻuṉḏuꞌmiŋuya waya nhanŋu wirrkina yana ganyimꞌthuna, bili waya ŋunhi nhäŋaya dharpana ŋayi gurrana räwaknha ŋunhi djingaryuna, yurru rakunynha, beŋu bili marwatŋu ga yana bili ŋoyyi dharpayi. Ŋayŋu ŋayi Peter-yuya dhäruknha guyaŋina Djesuna ŋunhi nhattjaya ŋayi waŋana ŋuriki dharpawu. Ŋayŋu ŋayi Peter-ya bitjayana waŋana, “Marŋgikunhami, dhuwayana ŋunhi dharpaya rawaknha gurra djingaryun, rakunynha, ŋunhi nhe ḏälyu dhärukthu waŋana!” ");
INSERT INTO dwy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ga ŋayi Djesuya bitjana waŋa, “Ŋuli nhuma yurru God-Waŋarrwuya märr-yuwalkthi, nhumaya yurru bitjana bili djämana bitjan ŋarra. ");
INSERT INTO dwy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ga ŋuli nhuma yurru yuwalktja märr-yuwalkthi warrpamdhu yana ŋayaŋuyu, ga yaka märr-yuḻkthun, nhumaya yurru waŋa dhuwaya bukuna wäŋana ŋayi yurru gaŋgathi bala ḏamurruŋdhina gapuyi ḻupthun. Ŋayiya yurru God-Waŋarryuya yana giṯmamana ŋunhiya bukuya wäŋa. ");
INSERT INTO dwy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yo, yaka waya meṉguŋuya. Ŋuli nhe yurru yuwalkkumaya yana märr-yuwalkthi, nheya ŋäŋꞌthu ŋanya birrkaꞌmiwu, ga ŋayiya yurru gathan yana nhuŋu. ");
INSERT INTO dwy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ga ŋuli nhe yurru bukumiyamaya, ŋurruŋuya ŋäthiyi guyaŋi: Ŋuli nhuna yurru yolŋuyu ŋayaŋu-yätjkuma, marrtji ŋäthiyi ga buni nhanŋu ga bäy-ḻakaŋu, yakana guyaŋi yätjkuŋu. Ga ŋuli nhe yurru bitjandja djäma, ŋayiya yurru God-Waŋarryuya bäy-ḻakamana nhuŋuya nhä malanynha nhe yätj gurrana djäma. Nheya wayaŋgu ŋäthiyi bäy-ḻakaŋu, ga yurruna bukumiyaŋuya God-Waŋarrwayatja. ");
INSERT INTO dwy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ga ŋuli nhe yolŋu dhuŋaya bäy-ḻakanhawu, ŋayiya yurru God-Waŋarryuya ŋunhi yakana nhuŋuya yätj malanynha meṉguma.” ");
INSERT INTO dwy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ga ŋunhi waya bunana Jerusalem-dja ŋayŋu dhunupana yana waya gärrina ŋunhima wäŋayi ŋunhi warraŋul gurra dhärra God-Waŋarrwu Dhuyu Buṉbu. Ga waya ŋunhi ŋurruŋu-ḏalkarrami mala ga Jew-wu ŋurru-warryunayŋu mala ga rom-marŋgikunhami mala yolŋu waya bunana nhanŋu, ");
INSERT INTO dwy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bala waya gurrana dhä-wirrkaꞌyunana Djesunaya bitjayana, “Go, ḻakaŋu mak ŋanapuŋgu, yolthu nhuna waŋaya dhiyaku buṉbuwu ḏarrtjalkunhawu? Yolthu nhuna goŋ-nherraṉdja?” ");
INSERT INTO dwy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yurru ŋayiya ŋunhi Djesuya marŋgithina wayaŋgu ŋäthiyi yana. Ŋayŋu ŋayi bitjayana buku-roŋinymaŋaya, “Ŋarra ŋäthiyi nhumana yurru ŋäŋꞌthun ŋeꞌ. Nhuma ŋäthiyi waya ŋarraku ḻakaŋu, ga yurruna ŋarraya yurru nhumaŋguya ḻakama. ");
INSERT INTO dwy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Marŋgi nhuma John-guya, ŋunhi Buku-ḻupthunamiwuya yolŋuwu? Yolthu ŋunhi ŋanya goŋ-nherraya yolŋuwu wayaŋgu buku-ḻupthunawuya? God-Waŋarryu, wo yolŋuyu?” ");
INSERT INTO dwy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ŋayŋu waya gurrana waŋanhamina bitjayana, “Way, nhattjan ŋilimuya yurru buku-roŋinymama nhanŋuya? Ŋuli ŋilimu yurru bitjandja waŋa, ‘God-Waŋarryu ŋanya ŋunhi waŋana,’ bitjandja, ga ŋayiya yurru bitjan waŋa, ‘Ga nhäku nhumaya ŋunhi nhanŋu John-gu yaka märr-yuwalkthina dhärukku?’ ");
INSERT INTO dwy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ga ŋuli ŋilimu yurru bitjandja waŋa, ‘Yolŋuyu wayay ŋanya ŋunhi waŋana ŋuriki djämawu,’ bitjandja, wayatja yurru yolŋuya waya maḏakarritjthina, bili waya marŋgi ŋunhi dhuwaya John-dja God-Waŋarrwu djawarrkmi yolŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ŋayŋu waya bitjayana buku-roŋinymaŋaya, “Yaka ŋanapu dhuwaya marŋgi!” Ga yurruna ŋayiya Djesuya buku-roŋinymaŋaya bitjayana, “Ŋarraya yurru yaka nhumaŋguya ḻakama yolthu ŋarranaya djuyꞌyuna.” ");
INSERT INTO dwy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ga dhurrwaraŋu beŋuya ŋayi Djesu bulu waŋana ŋurikaya ŋurruŋu-ḏalkarramiwaya ga rom-marŋgikunhamiwaya ga Jew-waya ŋurru-warryunayŋuwaya wayaŋgaya. Ga bitjaya ŋayi ŋunhi dhäwuꞌya ḻakaŋaya mayaliꞌmi gamꞌ, “Waŋganymiyu waluyu wäŋa-waṯaŋu yolŋu djälthina ŋayi yurru borum, ḻämu-nherraṉ. Yo, ŋurruŋuya ŋayi ŋunhi riwalꞌyuna wäŋa latjuꞌkuŋaya, ga dharpa gulkthuna, bala metj-nherraya. Ga wäŋa ŋayi dhuḻꞌyuna garrwaryi milꞌŋuwu djäkamiwu wayaŋgu. Ga banikinꞌ ŋayi bathala nherraya wiyikaꞌwu borumgu. Ŋayŋu ŋayi yolŋunaya wayana ŋätthunana marrtjina märr waya yurru djäka ŋuriki borumgu. Ga yalala yurru ŋunhi borumdja latjuꞌyi bala waya yurru wekamana borum nhanŋu ŋuriki wäŋa-waṯaŋuwu. Maꞌ, ŋayŋu ŋayi wäŋa-waṯaŋuya marrtjina barrkuyina wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ga ŋunhi ŋayi waluya galkithina borumguya gulkthunawu, ŋayŋu ŋayi ŋuriŋiya wäŋa-waṯaŋuyuya djuyꞌyunana nhanŋuway djämamina, märr ŋayi yurru marrtji ŋayŋu borum-djäkamiwu wayaŋgu buna waya yurru nhanŋuya borum mala ganaŋꞌmama beŋu gätniŋu. ");
INSERT INTO dwy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ga wayatja ŋunhi yolŋuya wayay nhäŋaya ŋanya bala baṉdjana warryuna ŋayŋu baymatthunana, ŋayŋu ḏupthuna ŋanya warraŋulyina dhäparknha yana. ");
INSERT INTO dwy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ga bulu ŋayi ŋuriŋi wäŋa-waṯaŋuyu djuyꞌyuna wiripuna djämamina. Ga wayatja ŋunhi borum-djäkamiyuya wayay muḻkurrnha ŋanya djuḏulꞌyuna gurrana yana bili ga gulaŋ nhanŋu waṉdina. Ŋayŋu ŋanya waya dhawaṯmaŋayana beŋuya dhäparknha yana. ");
INSERT INTO dwy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ga bulu ŋayi djuyꞌyuna wiripuna djämamina. Ga wayatja ŋunhi baymatthuna ŋanya rakunyguŋayana. Ga bulu ga bulu gurrana balanyaya maḻŋꞌthuna. Wiripunaya waya djämamina baymatthunana yana, ga wiripunaya baymatthuna rakunyguŋayana. ");
INSERT INTO dwy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yo, ga waŋganynha gurrana yolŋu nhinana, gäthuꞌmiŋuna nhanŋu, ŋunhi ŋayi wirrki yana nhanŋu märr-ŋamathina. Ga bitjayana ŋayi gurrana ŋunhi bäpaꞌmiŋuya guyaŋina, ‘Ŋuli ŋarra yurru gäthuꞌmiŋunaya djuyꞌyun, wayatja yurru ŋunhi nhanŋu makmakthun bala mäkiriꞌ-witjuna nhanŋu.’ ");
INSERT INTO dwy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ŋayŋu ŋayi djuyꞌyuna nhanŋuway gäthuꞌmiŋuna ŋayŋuyi. Ga wayatja ŋunhi borum-djäkamiyuya wayay nhäŋaya ŋanya, ŋayŋu waya waŋanhamina nhanŋu, ‘Way, waya nhäŋu ŋäthiyi! Dhuwayana ŋayi gäthuꞌmiŋunana djuyꞌyuna bäpaꞌmiŋuyu. Ga yalalami yurru ŋunhi bäpaꞌmiŋuya rakunydhi, ŋayŋu yurru ŋunhi ŋayina dhiyaŋuna bukmaknha nhä malanynha ŋuli ŋätthuya. Go, ŋilimu bumana rakunygumana nhanŋu gäthuꞌmiŋunaya, märr yurru ŋunhi bukmak nhä malanynha ŋilimuŋguna.’ ");
INSERT INTO dwy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ŋayŋu waya mulkanana ŋanya, ga buŋaya rakunyguŋayana. Ŋayŋu waya nhanŋu rumbalya ḏupthuna warraŋulyina, yurru barrkumana.” ");
INSERT INTO dwy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ŋayŋu ŋayi Djesuya dhä-wirrkaꞌyuna ŋunhi ŋaḻapaḻminaya bitjayana, “Nhattjan nhumaya gurra guyaŋi? Nhattjana ŋayi yurru ŋuriŋi wäŋa-waṯaŋuyu yolŋuyu guyaŋa ŋunha borum-djäkaminaya wayana? Ŋunhi ŋayi yurru marrtjiya bala yana bumana rakunygumana ŋunhi borum-djäkaminaya wayana. Ŋayŋu ŋayi yurru ŋunhiya wäŋa borummiya wekama wiripuwuna yolŋuwu wayaŋgu djäkawu. ");
INSERT INTO dwy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bili nhuma dhuwaya marŋgimi ŋunhi ŋunha God-Waŋarrwayatja Djorraꞌŋu gurra bitjan djingaryun, ‘Waŋganydja ŋunhi guṉḏa waya djämamiyu wayay ḏupthunana bili waya yätj ḻakaŋaya. Yurru ŋunhiya guṉḏa ŋamakuliꞌŋuna walꞌŋu, ga ŋunhiya ŋayi djalkirina. ");
INSERT INTO dwy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ga God-Waŋarryuya ŋayipina ŋunhi ŋätthuna ŋayŋu latjuꞌ-ḻakaŋayana. Ga wirrkina ŋunhi maŋutji-wiḏiꞌyunamina yulŋuya!’ ” ");
INSERT INTO dwy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ga wayatja ŋunhi ŋaḻapaḻmiyuya dharaŋayana yana ŋunhi ŋayi Djesuyu gurrana wayana waywayuna ŋuriŋi dhäwuꞌyu. Wayatja ŋunhi ŋunhiya ŋaḻapaḻmiya balanya bitjan ŋunhi borum-djäkami waya. Ga wirrkina waya ŋunhi ŋayaŋu-yätjthinaya. Ga djälmiyina waya gurrana ŋunhi Djesuwuya mulkanhawuna, waya yurru ŋanya dharruŋguyina gärrinymama. Yurru waya gurrana ŋunhi yolŋuwu wayaŋgu biyaṉiyina, bala yana waya marrtjinana. ");
INSERT INTO dwy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ga beŋuya dhurrwaraŋu Jew-waya ŋurru-warryunayŋuyu ḻuŋꞌmaŋaya yolŋuna wayana beŋu bala Pharisee-na yolŋuna wayana ga King Herod-ku ḻuṉḏuꞌmiŋuna wayana. Ŋayŋu waya djuyꞌyuna ŋunhi yolŋuna wayana ŋayŋu Djesuwayana mayaliꞌ-wilkthunawuna, märr ŋayi yurru be nhattjan yätj dhäruk waŋa, märr waya yurru mariwunana nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ŋayŋu waya waŋana nhanŋu Djesuwuya bitjayana, “Marŋgikunhami, bukmak ŋanapu dhuwaya marŋgi nhuŋuya, nheya ŋuli gurra dhuwaya latjuꞌ yana djäma, ga waŋa ŋuli yuwalkkuma yana dhunupa. Ga dhunupa yana nhe ŋuli waŋganyguma nhäma yolŋuna, bili nhe ŋuli djäma rrambaŋikuma bukmakna yana yolŋuna, ŋaḻapaḻna ga yuṯana. Ga God-Waŋarrrwuya dhäruk nhe ŋuli yuwalkkuma yana marŋgikuma. Go, ḻakaŋuna ŋanapuŋgu, nhä ŋunhi dhunupaya ŋanapuŋguya Jew-wuya bäpurruꞌwu ŋanapu yurru rrupiya buku-roŋinymama Roman-buyŋuwu gapmangu yäku tax-tja, ŋunhi waya buŋgawa ŋuriki wäŋawu ŋarakawu?” ");
INSERT INTO dwy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ga ŋayiya ŋunhi Djesuya marŋgithina wayaŋgu ŋayaŋuwu. Ga ŋunhi ŋayi beni bitjana waŋanha, ‘Yaka dhuwayitja latjuꞌ nhuma yurru wuŋiḻiyun wayana dhuwayi tax rrupiya,’ bitjaya, ŋunhiya ŋayi ŋayipini mariyina gärrinymanhamina Roman-gayana gapmangaya wayaŋgaya. Ga ŋunhi ŋayi beni yoranha bitjana, ‘Yuw, wuŋiḻiyuna waya dhiyaŋuya rrupiyayu,’ bitjana, ga ŋunhiya ŋayi gurra mariyina gärrinymanhami Jew-wayana yolŋuꞌ-yulŋu waya, bili yaka waya gurrana djälthina waya yurru Roman-buyŋu buŋgawayi wayaŋgu. Ŋayŋu ŋayi Djesuya bitjana waŋa, “Yaka ŋarrana waya mayaliꞌ-wilkthu. Rrupiya waya ŋarrakaya gathu ŋarra mak nhäma.” ");
INSERT INTO dwy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ŋayŋu waya gathana nhanukaya Djesuwayana waŋgany ŋaraka. Ga nhäŋaya ŋayi, bala waŋana bitjaya, “Yol dhuwayatja wuŋiḻi ga yäku dhiyalamiya rrupiyaŋu ŋarakaŋu?” Ga wayatja buku-roŋinymaŋaya, “Dhuwayiya wuŋiḻi ŋayi Caesar-na ŋunhi ŋayi buŋgawana Roman-buyŋuwu gapmangu!” ");
INSERT INTO dwy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ŋayŋu ŋayi Djesuya bitjayana waŋana, “Gatjuy, roŋinymaŋu waya wekuŋu nhä malanynha nhanŋu ŋuriki Roman-buyŋuwu gapmangu. Ga nhä malanynha ŋunhi nhanŋu God-Waŋarrwu, biyaku bili nhanŋuya buku-roŋinymaŋu wekuŋu.” Ga bukmakthuya ŋunhi ŋäkuyana ŋanya dhäruktja ganyimꞌthuna, bili ŋayi wayana ŋunhi buku-roŋinymaŋaya djambatjthuna dhärukthu. ");
INSERT INTO dwy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ga wiripu guḻkuꞌ yolŋuꞌ-yulŋu mala yäku Sadducees marrtjina ŋunhi waya marŋgikunhawu yolŋuwu wayaŋgu, be yaka yurru yolŋu waya rakunyŋu walŋathi. Ga bitjaya waya gatjarrꞌyuna Djesuna, ŋayŋu waya waŋana bitjaya, ");
INSERT INTO dwy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Marŋgikunhami, dhuwaya God-Waŋarrwuya rom ŋunhi Moses-thuya wukirri, gamꞌ: Ŋunhi yurru yolŋuyu miyalknha ŋätthun, ga rakunydhiya yurru ŋayi walkurmiriw yana, bala nhanukaya guthaꞌmiŋuyuna yurru ŋunhi miyalknha ŋätthun. Ga yalalaya maṉḏaku yurru ŋunhi yothuna maḻŋꞌthun, nhanŋuna ŋuriki rakunyguna ḏarramuwu. ");
INSERT INTO dwy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ga nhämi dhuwayatja, gayꞌ? Guḻkuꞌ waya gurrana ŋunhi nhinanaya, seven-na wäwaꞌmanydji waya. Ga ŋayi ŋäthiyiya ŋaḻapaḻyu wäwaꞌmiŋuyu ŋätthuna miyalknha bala rakunydhinana, ga yaka ŋayi ŋuriŋi miyalkthu ŋula yothu nhanŋu gäŋaya. ");
INSERT INTO dwy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ŋayŋu ŋunhi malpurayuya ŋätthuna ŋunhi miyalknha yana bitjaya romgu malthuna. Ŋayŋu ŋayi ŋunhi ḏarramuya rakunydhinana, walkurmiriw yana. ");
INSERT INTO dwy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ga balanyana bili yana maḻŋꞌthuna bukmakku yana wayaŋgu wäwaꞌmanydjiwu. Ga bukmak waya ŋunhi romguya malthuna, ga bukmakthu waya ŋunhi ŋätthuna ŋunhiyi miyalknha. Ga bukmak yana waya rakunydhina yothumiriw yana. Ga dhä-dhuḏitjnha ŋayina ŋunhi miyalknha rakunydhina. ");
INSERT INTO dwy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ga dhiyakuna ŋanapu yurru nhunaya dhuwaya dhä-wirrkaꞌyun, gayꞌ: Ŋunhi buwaḻꞌyu God-Waŋarryu yolŋunaya wayana walŋakuŋu rakunyŋuya ŋunhaya djiwarrꞌŋuya, ga ŋunhi bitjaya waya wäwaꞌmanydji waya ga ŋunhiyi miyalk beŋu rakunyŋuyu walŋathi, ga yolkuna ŋayi yurru ŋunhi miyalktja, bili bukmakkaya yana ŋayi wayaŋgaya nhinanaya?” ");
INSERT INTO dwy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ga ŋayi Djesuya waŋana bitjayana, “Bukmak yana nhuma dhuwaya djarrpiꞌmi. Yaka yana nhuma dhuwaya God-Waŋarrwuya dhärukku yuwalktja marŋgi, ga yaka nhuma marŋgi nhanŋu ganydjarrwu. ");
INSERT INTO dwy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ga ŋunhi ŋuli yolŋu waya walŋathi rakunyŋuyu, ŋunhiya waya buwaḻꞌyu balanyana bitjan God-Waŋarrwuna dhäwuꞌmina mala, djiwarrꞌwuynha yolŋu waya. Wayatja yurru ŋunhi yakana ŋätthunmi ŋunhayatja. Bukmaktja yolŋu waya ŋunhayatja djiwarrꞌŋuya buwaḻꞌyu waŋganynha mala. Yakana buwaḻꞌyu ŋunhi yolŋuyu wayay dhawuꞌ nherruyu miyalknha ga bulu ŋätthunmi. ");
INSERT INTO dwy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nhumaya gurra dhuwaya bitjan guyaŋa yana beni yaka yolŋu waya yurru walŋathi rakunyŋuyu. Guyaŋi waya ŋunhi dhäwuꞌ Moses-kalaŋuwuy ŋunha God-Waŋarrwaya dhuyuŋu djorraꞌŋu: ŋunhi ŋayi nhäŋaya gurtha dharpayi, ga God-Waŋarr gurrana waŋana nhanukaya bitjaya, ‘Ŋarraya dhuwaya God-Waŋarr wayaŋgu Abraham-gu, Isaac-ku ga Jacob-ku.’ ");
INSERT INTO dwy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yaka ŋayi God-Waŋarr rakunymiwu yurru ŋayi God-Waŋarrya ŋuruku walŋamiwu yolŋuwu wayaŋgu. Bili waya gurra nhina walŋana ŋunha God-Waŋarrwayana, yaka waya rakunymi. Bili walŋami yolŋu waya ŋuli gurra God-Waŋarrwu buku-ŋalꞌyun, yaka rakunymi. Ŋunhi nhuma gurra guyana ŋunhi yolŋu waya yaka bulu ŋuli walŋathi, ga guyaŋinyawuyya nhumaŋguŋu djarrpiꞌna wirrkina.” ");
INSERT INTO dwy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ga ŋunhaya gurrana nhinana waŋgany rom-marŋgikunhami yolŋu, mäkiriꞌ-witjuna ŋayi gurrana Djesuwu. Ga bitjaya ŋayi gurrana ŋunhi guyaŋinaya: ŋunhi ŋayi Djesuyuya latjuꞌna yana wayaŋgu dhäruktja buku-roŋinymaŋaya Sadducees-kuya wayaŋgu. Ŋayŋu ŋayi ŋäŋꞌthuna ŋanya Djesuna bitjayana, “Nhä dhuwaya ŋurruŋuya wirrkiya walꞌŋu God-Waŋarrwu Rom?” ");
INSERT INTO dwy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ga ŋayi Djesuya buku-roŋinymaŋaya bitjayana, “Dhuwanna ŋunhi ŋurruŋuya walꞌŋu rom ŋunha God-Waŋarrwayatja djorraꞌŋu gurra ḻakama bitjan gamꞌ, ‘Ŋäkuya waya latjuꞌkuŋu, nhumaya Israel-puyŋuyu yolŋuyu wayay! God-Waŋarr yana dhuwaya ŋayipi ŋurruŋuya buŋgawa ŋilimuŋgu, Yaka gurra dhuwaya wiripu yolŋu nhina balanya bitjan ŋayi. Ga nhanŋuway yana ŋilimu yurru ŋunhi mäkiriꞌ-witjundja! ");
INSERT INTO dwy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ga märr-ŋamathi yurru dhuwaya dhiyaku God-Waŋarrwuya wirrki yana, yaka ganga. Ŋuruŋuna ŋayŋu märr-ŋamathi nhanŋu djinawaꞌyuna ŋayaŋuyu, ga bukmakthu yana nhokaya märryu, ga djälyu, ga guyaŋinyayu. Ga märr-ŋamathi God-Waŋarrwu bukmakthu yana nhokaya ganydjarryu, bitjan nhe ŋuli ganydjarr-waŋa ŋula djämawu.’ ");
INSERT INTO dwy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ga dhuwaya ŋayi ŋunhi wiripuya rom balanya bili bitjan ŋunha ŋurruŋu rom, dhuwanna gamꞌ: ‘Gatjuy, märr-ŋamathina ŋunha wiripuwuya yolŋuwu bitjan nhe ŋuli märr-ŋamathi nhuŋuway nhe.’ Dhuwanna ŋunhi bulalꞌnha rom maṉḏana walꞌŋu ŋurruŋuya.” ");
INSERT INTO dwy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ŋayŋu ŋayi ŋunhi rom-marŋgikunhamiya yolŋu bitjayana waŋana, “Yuwalk dhuwayiya! God-Waŋarr yana dhuwaya ŋayipi ŋilimuŋgu ŋurruŋu buŋgawa. Dhunupa yana nhe dhuwaya bitjaya waŋana ŋunhi ‘Bäyŋuna dhuwaya ŋula wiripu God-Waŋarr,... ŋayipina yana waŋganynha, ga ḻinyguna!’ ");
INSERT INTO dwy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dhika ŋilimu yurru gurra latjuꞌkuma yana nhanŋu God-Waŋarrwuya märr-ŋamathi, yaka gaŋga. Yuwalkkuma yana ŋilimu yurru gurra nhanŋu märr-ŋamathi bukmakthu ŋilimuŋgaya ŋayaŋuyu, ga märryu, ga djälyu, ga guyaŋinyayu, ga ganydjarryu. Ga bitjana bili ŋilimu yurru gurra ŋunhi wiripuwu yolŋuwu märr-ŋamathi, bitjan ŋilimu ŋuli ŋilimuŋguway märr-ŋamathi. Dhuwayina ŋunhi rom maṉḏana ŋurruŋuya ŋilimuŋgu. Yo, dhiyaŋuya djuḻkmama gurra romdhu dhuwaya ŋunhi wiripunaya malana romnha, balanya bitjan mundhurr-wekanaminaya romnha.” ");
INSERT INTO dwy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ga ŋunhi ŋayi Djesuyu ŋanya balanyawuya ŋäkuya, ŋunhi ŋayi ḏarramu djambatjthuna dhärukthu waŋana, bala ŋayi Djesuya bitjayana nhanŋu buku-roŋinymaŋaya, “Ḻinyguna nhe dhuwaya dharaŋayana, dhuwaya nhe gurra guyaŋina nhe yurru God-Waŋarrnhana buŋgawakuma nhokalaŋuwu walŋawu.” Ga yaka ŋunhi buluya ŋula yolŋu waya waŋana nhanŋu, bili yakana yurru ŋula yolthu ŋanya dhäruk djuḻkmama Djesuna. ");
INSERT INTO dwy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ga balanyamiyu ŋayi gurrana Djesuyu baḏak wayana marŋgikuŋaya yolŋuna wayana ŋunhaya God-Waŋarrwaya Dhuyuŋu Buṉbuŋu. Ga bitjaya ŋayi ḻakaŋaya, “Bili nhuma marŋgi dhuwaya ŋunhi David-tja gurrana nhinana be wala bamanꞌ ŋäthiyi yana. Ga wayatja gurrana nhumaŋgaya rom-marŋgikunhamiyuya ḻakaŋaya, ŋunhi God-Waŋarrwuna Maŋutji-ḻakanhawuynha buwaḻꞌyu maḻŋꞌthu nhanukayana David-kaya yarraṯaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yo, ŋäthiyi ŋayi ŋunhi God-Waŋarrwu Dhuyu Birrimbirryu dhäruk-wekaŋaya David-kaya dhäwuꞌwu wukirriwu bitjaya: God-Waŋarr waŋana ŋarrakalaŋuwaya buŋgawawaya bitjaya, ‘Go! Lili marrtji, ga dhiya nhini ŋarrakayana dhunupaꞌŋuna galiꞌŋu, märr nheya yurru ŋunhi galkina ŋarrakayana, ga bäythi ŋarra yurru miriŋuna nhuŋu gälkinymama, bala nhe yurru gurra ḻuku-ŋalꞌyuna wayaŋgaya.’ ");
INSERT INTO dwy_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Ga ŋanyanaya ŋunhi Maŋutji-ḻakanhawuynhaya yolŋuna ŋayi David-thuya gurrana buŋgawa ḻakaŋaya. Ga nhäkuna ŋayi be David-kayatja yarraṯaŋu buŋgawaꞌmiŋu nhanŋuya be David-kuya?” ");
INSERT INTO dwy_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Ga guḻkuꞌyu gurrana ŋunhi yolŋuyu wayay ŋäkuya ŋanya Djesuna dhäruk, ga märr-ŋamathina waya nhanŋu wirrkina yana. ");
INSERT INTO dwy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ga baḏak ŋayi gurrana ŋunhi Djesuyu marŋgikuŋaya yolŋuna wayana, ŋayŋu ŋayi bitjayana waŋana, “Wäy, djäka waya ŋe, ŋurukuya rom marŋgikunhamiwuya wayaŋgu! Dhuwaya waya ŋuli gurra bathalakunhami, ga girriꞌya waya ŋuli nherraṉ wiyinꞌna be wirrkina, märr yurru yolŋuyu wayay nhäma wayana ŋayŋu wokthuna wayaŋgu ga bitjana waŋa, ‘Yo, nhämi way yolŋu,’ bitjana, ŋunhi waya ŋuli gärulyiya marrtji. ");
INSERT INTO dwy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ga ŋunhi waya ŋuli biryayi buṉbuyi marrtji buku-ŋalꞌyunawuya, wo ŋathamiyi wäŋayi, waya ŋuli latjuꞌwuna yana nhinanhamiwu ḻarruma, märr yurru gurra yolŋuyu wayay nhäma wayana ŋunhima. ");
INSERT INTO dwy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yurru waya ŋunhi ŋuli bawaꞌ-wekama ŋunha ŋurruwuyknha miyalknha wayana bala marrtji manaŋina buṉbu mala wayaŋgu. Ga dhurrwaraŋu beŋuyu bala waya ŋuli marrtji biryamiyina buṉbuyi bala ŋuli buku-ŋalꞌyuna, djakaꞌ-wiyinꞌna be, märr yurru yolŋuyu wayay wayana latjuꞌ-ḻakama. Yurru ŋayiya ŋuli wayana ŋunhi God-Waŋarryuya wirrkina yana dhä-ḏirꞌyu yätjpuya.” ");
INSERT INTO dwy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ga beŋuya dhurrwaraŋu, ŋayi gurrana Djesu nhinana gumurr ŋayŋuna ŋunhi wanhami gurrana banikinꞌ rrupiyawuy djingaryuna ŋunhaya ŋunhi God-Waŋarrwaya Dhuyuŋu Buṉbuŋu. Ga nhäŋaya ŋayi gurrana yolŋuna wayana wiripuna ga wiripuna waya marrtjina rrupiya rarrꞌyuna balayi rupaꞌyi. Ga ḻukunydjaꞌyu yolŋuyu wayay marrtjina rarrꞌyuna bathala rrupiya. ");
INSERT INTO dwy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ga bulu ŋunhi gurrupuruŋunha miyalk marrtjina, ga gathaya ŋayi ŋunhi bulalꞌ yutjuwaḻaꞌ ŋaraka rrupiya, bäyŋuna bathala. ");
INSERT INTO dwy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ŋayŋu ŋayi Djesuya wäthunana nhanukalaŋuwu guyurrꞌmiŋuwu wayaŋgu bitjaya, “Dhuwaya ŋarra yurru dhunupa nhumaŋgu ḻakamaya: Dhiyaŋuya gayꞌ miyalkthu wekaŋaya warrpamꞌthuna, djuḻkmaŋayana gurrana ŋunha bukmaknha ḻukunydjaꞌna yolŋuna wayana mundhurr-wekanhawuy. ");
INSERT INTO dwy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Dhiyaŋuya ḻukunydjaꞌyu yolŋuyu wayay guyaŋina yana beni guḻkuꞌ wekaŋaya. Ga ŋunha wäŋaŋu wayaŋgaya gurra guḻkuꞌ yana rrupiya gandawꞌyun. Ga ŋayiya dhiyaŋuya miyalkthu warrpamnha wekaŋaya, yakana ŋula djuḻuḻꞌmaŋaya rrupiya nhanŋuwaya ŋayi ŋathawu.” ");
INSERT INTO dwy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ŋayŋu ŋayi Djesu ga guyurrꞌmiŋu waya nhanŋu marrtjina dhawaṯthuna beŋu ŋunhi God-Waŋarrwaya Dhuyuŋu Buṉbuŋu. Ŋayŋu ŋayi waŋganydja yolŋu waŋana bitjayana, “Way Marŋgikunhami, nhäŋu ŋäthiyi dhuwaya, latjuꞌ dhuwaya buṉbu. Nhäna dhuwayatja guṉḏa malanynha bathalamina wirrkina, ŋeniya?” ");
INSERT INTO dwy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ga ŋayi Djesuya waŋana bitjaya, “Dhuwaya nhuma gurra nhäma latjuꞌ buṉbu, dhuwaya yurru ḏawꞌyuna. Ga bäyŋuna yurru buluya gurra dhiya djingaryun. Ŋayŋu yurru dhuwaya guṉḏaꞌya mala ŋoyŋuna gandawyun. Warrpamꞌnha ŋuli burruḻꞌyun.” ");
INSERT INTO dwy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ŋayŋu waya ŋunhi Djesu ga guyurrꞌmiŋu waya nhanŋu marrtjina ŋayŋu bukuyi yäkuyi Mount Olive-thi ŋunhi ḻaypaꞌyunmi maṉḏa gurra, God-Waŋarrwu Dhuyu Buṉbu ga ŋunhaya, waya gurrana ŋunhi nhinanaya. Ŋayŋu waya ŋunhi Peter ga James ga John ga Andrew marrtjinana Djesuwuna bunana bala dhä-wirrkaꞌyunana, ");
INSERT INTO dwy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Marrkapmi, ŋäthiyi ŋanapuŋgu ḻakaŋu dhunupakuŋu, nhä nhe gurrana ḻakaŋaya. Nhätha yurru yolŋuyuya dhuwaya buṉbuya ḏawꞌmaŋu, ga nhäthu ŋanapu ŋuli marŋgithiya?” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ga ŋayi Djesuya waŋana, “Djäka waya marrtjiya märr yurru nhumana yaka yolŋuyu mayaliꞌ-wilkthun. ");
INSERT INTO dwy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Guḻkuꞌ ŋuli dhuwaya yolŋuya waya buni ga biyaku waŋi, ‘Ŋarra dhuwaya Maŋutji-ḻakanhawuya,’ ga guḻkuꞌna waya ŋuli yolŋuna wayana mayaliꞌ-wilkthu. ");
INSERT INTO dwy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ga mariwuya nhuma ŋuli ganydjarrya ŋäkuna. Ga wiripu yolŋu waya ŋuli buni bala ŋuli marrtji dhäwuꞌna-gäŋu wiripuwuynha mariwuy. Yurru nhumaya yaka ŋuli ŋayaŋu-wingilꞌyu ŋuriŋiya malay dhäwuꞌyu, ŋe? Mariwuyya nhuma ŋuli biyaku bili dhäwuꞌ ŋäku yana, bäymayi ga barrkuyi, yurru ŋunhiya yaka yana dhä-dhawaryunami walu. ");
INSERT INTO dwy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ga guḻkuꞌ ga guḻkuꞌ ŋuli dhuwaya mariya mala ŋurru-walmi. Yolŋu waya waŋgany bäpurruꞌ yurru mari-wuna wiripuŋuwu bäpurruꞌwu. Ga waŋganybuy ŋarakawuy wäŋawuy ŋuli mariwuni wiripuŋuyi wäŋayi. Ŋayŋu ŋuli wäŋaya dhuwaya ŋayipiya marrmarryuna, ga barrꞌparryuna ŋuli. Ga ŋathaya ŋuli ŋunhi dhawarꞌyuna wiyinŋumina waluyu, ga yolŋuya waya ŋuli wirrkina djaṉŋarrthi. Ga ŋurruŋuya yurru ŋunhi dhuwayi mari mala maḻŋꞌthu. Ga buluya ŋuli bathalana mari maḻŋꞌthu. Beyaku ŋayi ŋuli ŋunhi maḻŋꞌthuya gam: Bitjan ŋuli miyalkthu ŋurru-yirrꞌyun ŋämaꞌŋama rerri yothuna ŋunhi ŋayi yurru dhawal-wuyaŋi. ");
INSERT INTO dwy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Djäkana waya nhumaŋguway yulŋuya, märr yurru ŋunhi yaka nhumana yolŋuyuya wayay bawaꞌ-wekuŋu. Yolŋuya waya nhumaŋgu yurru ŋurru-wilꞌwilyuna bili nhuma ŋuli ŋunhi ŋarraku malthun. Ga mulki waya ŋuli nhumana ga gäŋu bala dhä-wirrkaꞌyunawuna, bala ŋuli bartjunmaŋuna nhumana ŋunhaya biryamiŋuna buṉbuŋu. Ga djingaryunmaŋu waya ŋuli nhumana ṉapuŋgaꞌyi yana gumurryi buŋgawawaya wayaŋgaya ga gapmangaya yolŋuwaya wayaŋgaya. Ga balanyamiyuya nheya ŋuli ŋarranaya biyaku ḻakaŋuna yolŋuwuna wayaŋgu, ");
INSERT INTO dwy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","märr yurru bukmakthu bäpurruꞌyu ŋäkuna ŋarrakalaŋuwuy dhäwuꞌ. Yo, ŋurruŋuya ŋuli dhuwaya bukmakthu bäpurruꞌyu dhäwuꞌ ŋäthiyi latjuꞌ ŋäku, ga yurruna ŋuli ŋunhi waluya dhä-dhawarꞌyu. ");
INSERT INTO dwy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yo, yolŋuyuya wayay nhumana ŋuli ḏapmaŋuna bala gäŋuna nhumana dhä-wirrkaꞌyunawuna, yurru nhumaya yurru yaka warwuyun nhattju nhuma ŋuli waŋi. Ŋayina yurru ŋunhi Dhuyu Birrimbirryuna nhumana dhäruk-wekama waŋanhawu. ");
INSERT INTO dwy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ga ŋuli yurru ŋunhi yolŋu märr-yuwalkthi ŋarrakuya, yolŋuyu gurruṯumiyu wayay yurru ŋanya baymatthuna rakunygumana yana. Wäwaꞌmanydji yurru baymatthunmi rakunygunhamina yana. Ga biyaku bili ŋuli bäpaꞌmiŋuyu baymatthu wayaŋguway wäwunŋuna djamarrkuḻina. Ga yumurrkuꞌya yurru ŋapa-wilyuna ŋäṉḏiꞌmiŋuwu ga bäpaꞌmiŋuwu ga gumurr-wekama maṉḏana yolŋuwayana wayaŋgaya baymatthunawu. ");
INSERT INTO dwy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ga guḻkuꞌna yolŋuya waya nhumaŋgu ŋuli ŋaramurrthiya, bili nhuma ŋuli ŋarraku malthun. Ga ŋunhi nhe yurru gurra ḏälya yana djingaryun ga yakaya nhe yurru märr-djawaryun, ŋayiya yurru God-Waŋarryuya nhuna walŋakuŋuna.” ");
INSERT INTO dwy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ga baḏak ŋayi gurrana ŋunhi Djesu waŋana bitjaya, “Dhikaya ŋuli yätjtja be nhä wirrkina ŋuli maḻŋꞌthu. Ga djingaryuya ŋayi ŋuli ŋunhi ŋunhaya God-Waŋarrwaya Dhuyuŋu Buṉbuŋu ŋunhaya Jerusalem, yätjkuŋuna ŋuli ŋunhiya wäŋa, ŋunhi yaka ŋayi beni yuwalktja maḻŋꞌthuna. Yurru, girriꞌ-ŋamathina yukirri nhiniya,” bitjaya. (Ga ŋuli nhe gurra nhäma dhuwaya dhäwuꞌya, marŋgithi yana ga yuwalkkuŋu dharaŋu, ga biyaku bili nheya nhini girriꞌ-ŋamathi.) Ga baḏak ŋayi nhina Djesuya waŋa bitjan, “Ŋuli nhuma yurru balanyawuya nhäma, ŋunhi dhä-dhawarꞌyunamiya walu galŋaꞌkalŋana. Ga ŋuli nhuma yurru Judea-puyŋuyu yolŋuyu wayay balanya nhäma, gaŋgathina yana ŋunha bukuꞌ-pukumiyina wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ga ŋuli nhe gurra warraŋulya nhokaya buṉbuŋu marrtjiꞌmarrtji, yakana waṉḏi yarrupthuya ga girriꞌya nhuŋuway wapmaŋu djinawaꞌ buṉbuŋu yana waṉḏi bukuyina. ");
INSERT INTO dwy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ga ŋuli nhe gurra ḏiltjiŋuya nhina, yakana waṉḏi nhokaya buṉbuyi be nhäkuya gundhaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ga gumurr-ḏälnha ŋuli dhuwaya wirrkina yothumiwuya miyalkku wayaŋgu balanyamiyuya waluyu. ");
INSERT INTO dwy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bukumiyaŋu God-Waŋarrwaya, märr yurru ŋunhi gumurr-ḏälya rom maḻŋꞌthu, balanyamiyu waluyu ŋunhina ŋayi nhuŋu gumurr-yalŋgiꞌya yolŋuwu ṉaŋꞌthunawu. ");
INSERT INTO dwy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ga dhiyaŋuya mariyu ŋuli yolŋuya waya galŋaya wirrkina nyelyu, yätjthina ŋuli. Beŋu bili ŋunhi ŋayi God-Waŋarryu ŋurru-yirrꞌyuna dhuwaya wäŋa, balanyamiyu gurrana ŋunhi yolŋuya waya nyelyuna. Yurru dhiyaŋuya mariyu ŋuli yolŋuya waya wirrkina galŋa-yätjthi. Ga yalalaya yakana ŋayi ŋuli buluya balanya gumurr-ḏäl maḻŋꞌthu. ");
INSERT INTO dwy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ga ŋunhi ŋayi yurru God-Waŋarryu yakaya ŋunhi mari gulmaŋu, ŋayiya yurru yolŋuya waya warrpamꞌnha yana rakunydhina. Yurru God-Waŋarryuya ŋunhi bili nhanŋuway yolŋuna wayana ganaŋꞌmaŋaya, ga yakana ŋayi yurru nhäma wayana rakunydhinyayi, ŋayŋu ŋayi yurru ŋunhi mariya dhumbuḻkumana, märr waya yurru walŋathi. ");
INSERT INTO dwy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ga ŋunhi ŋuli yolŋu biyaku waŋi, ‘Dhuwaya ŋanapu bilina maḻŋꞌmaŋayana ŋunhi Maŋutji-ḻakanhawuynhaya yolŋuna, dhuwana ŋayi yulŋuya,’ nhumaya yakana märr-yuwalkthi. Ga ŋunhi waya yurru bitjandja waŋa, ‘Ŋunhana ŋayŋu ŋayi, ya ŋunhana,’ yakana yana märr-yuwalkthi. ");
INSERT INTO dwy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Guḻkuꞌyu yolŋuyu ŋuli biyaku ḻakaŋu, ‘Ŋarra dhuwaya God-Waŋarrwuŋuya Maŋutji-ḻakanhawuy yolŋu.’ Ga wiripuya ŋuli biyaku waŋi, ‘Ŋarra dhuwaya djawarrkmiya yolŋu,’ yurru yuwalktja waya ŋuli ŋunhi nhumanaya mayaliꞌ-gäŋu. Ga biyaku ga waya ŋuli ŋunhi ŋayaŋu-ganyimꞌthunamiya rom mala djäma. Ga biyaku waya ŋuli ŋunhi guyaŋiya, ‘Go, ŋilimu bawa-wekama dhuwaya God-Waŋarrwu mala-djarrꞌyunawuynha yolŋuna wayana.’ Yurru gulkuruna waya ŋuli ŋunhi biyakuya djäma. ");
INSERT INTO dwy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Gatjuy djäkana waya! Dhuwana ŋarra gurra ḻakama nhumaŋgu yulŋuya, märr yurru ŋunhiya walu buni, nhumaya yurru girriꞌ-ŋamathina nhiniya ŋurikiya.” ");
INSERT INTO dwy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ga bulu ŋayi Djesuyu bitjaya ḻakaŋaya, “Ga beŋuya dhurrwaraŋu ŋunhi bathalaŋuya mariŋuya, waluya yurru munhaꞌkuyina ga ŋaḻinḏiya yurru yakana buluya djarraṯawunꞌmiyi. ");
INSERT INTO dwy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ga ganyuꞌya mala ŋuli burrulꞌyuna djiwarrꞌŋuya ga nhä malany ganydjarr ŋula nhäku malaŋuwu ŋunha djiwarrꞌŋuyu yurru rurrꞌrurryuna. ");
INSERT INTO dwy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ga beŋuya bala ŋuli yolŋuyuya wayay bukmakthu nhäŋuna ŋanyanaya ŋunhi Yuwalkŋunaya Walꞌŋu Yolŋuna. Ga yarrupthuya ŋayi ŋuli djiwarrꞌŋuya lili waŋupiniꞌyuna. Ga bukmakthu yolŋuyu ŋuli ŋunhi nhäŋuna ŋanya djeŋarraꞌyakaynha djärimina dhika, ga ganydjarr-ŋutuꞌna bäymana. ");
INSERT INTO dwy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ŋayŋu ŋarra ŋuli djuyꞌyuna God-Waŋarrwuya djiwarrꞌwuynha dhäwuꞌmina wayana, waya ŋuli ḻuŋꞌmaŋu ŋarrakuya mala-djarrꞌyunawuynha yolŋuna wayana dhuwaya bala buku-ḻiwꞌmama ḏapthun marrtji, beŋu dhimurruŋu ga ḏupthun bärraꞌyi ga dhipuŋu bala ḻuŋgurrmaŋuyu ga yana bili ga djalathaŋdhi wapthun.” ");
INSERT INTO dwy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ga baḏak ŋayi gurrana ŋunhi Djesuya waŋana bitjaya, “Ŋunhi nhuma ŋuli nhäma marwat dharpa galaḏaꞌyunaya, nhumaya ŋuli marŋgithina ŋunhi ŋunhiya dharratharramina walu galkithina marrtji. ");
INSERT INTO dwy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yo, ŋunhi nhuma ŋuli balanyawuya nhäma, ŋuriŋiya gurra gumurr-ḏälyuya romdhu maŋutji-ḻakama ŋarraku walu galkithina marrtji. ");
INSERT INTO dwy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Dhuwaya ŋarra yurru dhunupa yana nhumaŋgu ḻakama! Dhipuŋuyu gayꞌ ŋurrukŋuyu, dhuwaya nhuma gurra djingaꞌdjingaryun, wiripuya waya nhuma ŋuli walŋa yana nhini, ga nhäŋu yana nhuma ŋuli balanya gumurr-ḏäl rom maḻŋꞌthunaya. ");
INSERT INTO dwy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yo! Nhäya mala bukmaktja ŋuli dhawarꞌyuna, ŋunha djiwarrꞌ wäŋa ga dhuwaya munathaꞌ wäŋa dhawarꞌyuna ŋuli. Yurru dhäruktja ŋarraku yurru ŋunhi yakana dhawarꞌyu, ŋunhiya yurru djingaryuna gurra wiyinŋumina dhawarꞌyunamiriwnha.” ");
INSERT INTO dwy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ga bulu ŋayi Djesu waŋana bitjaya, “Yaka dhuwaya ŋula waŋgany yolŋu marŋgi ŋarrakalaŋuwu waluwu roŋiyinyawu. Ŋunha God-Waŋarrwu djiwarrꞌpuy dhäwuꞌmi yolŋu waya yaka yana marŋgi. Ga ŋarrapi dhuwaya yaka yana marŋgi. Ŋayipina yana dhuwaya Bäpaꞌmiŋuna ŋarraku marŋgi, ga ḻinyguna. ");
INSERT INTO dwy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gatjuy, djambatjthina waya yukurri nhiniya, bili nhuma yaka dhuwaya marŋgi ŋurikiya waluwu. ");
INSERT INTO dwy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dhuwaya ŋarra yurru dhäwuꞌ nhumaŋgu ḻakama mayaliꞌmi: Waŋganymiyu waluyu wäŋa-waṯaŋu yolŋu marrtjina gunhaꞌyuna wäŋa nhanŋuway ga marrtjina barrkuyi wäŋayi. Ga waŋana ŋayi nhanŋu djämamina wayana, waya yurru djäma yulŋuya, ga djäka girriꞌwu malanyŋuwu latjuꞌkuma yana. Ga waŋana ŋayi dhurrwara-djäkamina wayana waya yurru gurra dhukarr-nhäma yana, ga gumurr-roŋiyi ŋayi yurru. ");
INSERT INTO dwy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ga yaka waya ŋunhi marŋgi waluwu, nhäthu waluyu ŋayi yurru gumurr-roŋiyi. Mak ŋayi yurru walu gärrinyayu buna wo mak gandarryu munhayu, wo mak djaḏawꞌyunayu. Yo, waya, nhumaya dhuwaya balanya bitjan ŋunhi djämamina yolŋu waya, ga yaka nhuma dhuwaya marŋgi nhätha ŋarra yurru roŋiyi lili. Gatjuyꞌ, nhumaya marrtji girriꞌ-ŋamathina yulŋuya. ");
INSERT INTO dwy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Dhukarr-nhäŋuna waya yukirri nhiniya, bitjan ŋunhi yolŋu dhurrwara-djäkami ŋuli djingaryun dhukarr-nhäma nhina yana, märr ŋayi yurru yaka nhuna maḻŋꞌmama yakurryi. ");
INSERT INTO dwy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dhuwaya ŋarra yurru waŋana nhumana, ga bukmaknha yolŋuna wayana, ‘Gatjuy, djäka waya latjuꞌkuŋuna, dhukarr-nhäŋuya nhanŋu.’ ” Yo, dhiyana ŋayi dhäwuꞌya Djesuwuya gulyun ŋunhi ŋayi gurrana ḻakaŋaya ḻuṉḏuꞌmiŋuwu wayaŋgu ŋunhaya bukuŋu yäkuŋu Mount Olive. ");
INSERT INTO dwy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Yo, ga ŋunhi ŋurruŋu-ḏalkarrami yolŋu waya ga rom-marŋgikunhami waya ḻuŋꞌthuna bala waya waŋanhamina nhattjan waya yurru Djesuna mulkaꞌ, yurru gayul, bili waya wirrkina yana djälmiyina nhanŋu waya yurru rakunyguma buma ŋanya, bala waya waŋanhamina bitjanmina, “Wäy, galkun ŋilimu ŋe, bili rom ŋilimuŋgu gurra dhuwaya bathala marrtji. Waya ŋuli yolŋu waya ŋilimuŋguna mari-wuni, bili waya nhanŋu dhuwaya Djesuwuya wirrkina djäl.” Ga ŋunhi waya bitjayatja waŋana bili ŋunhi bulalꞌnha yana waluya bala ŋunhiyiya yurru rom ŋurru-yirrꞌyuna Ḻäy-djuḻkthunamiya Walu ga wiripu rom yäku Bilkpilk Ḏämba. Ga ŋuriŋiya waluyu waya ŋuli guyaŋinya wayaŋguway ŋaḻapaḻmina, gurruṯumina wayana, ŋunhi waya gunhaꞌyuna wäŋa yäku Egypt. ");
INSERT INTO dwy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ga ŋayiya gurrana ŋunhi Djesuya nhinana ŋunhaya wäŋaŋu Bethany, ŋatha gurrana ḻukana Simon-gaya wäŋaŋu. Ga ŋäthiyiya ŋayi gurrana ŋunhi Simon-dja nhinana rerrimi, räypinydhu ŋayi gurrana garathina wirrkina. Yurru ŋayi ŋunhi bilina latjuꞌyinana. Ga yaka wiyindja bala miyalknha ŋunhima gärrina yurru goŋ bothuḻuꞌmina, yurru bothoḻuꞌya ŋunhi djämapuy beŋu guṉḏaŋu. Ga gäŋaya ŋayi gurrana buŋgan-latjuꞌ, ga buŋgandja ŋunhi latjuꞌna dhika wirrkina, yurru rrupiya bathalami. Ga ḻapmaŋaya ŋayi ŋunhi muḻkurr yana bothuḻu, ŋayŋu rarryuna buŋgan-latjuꞌ bala ŋunhi Djesuwaya muḻkurryi. ");
INSERT INTO dwy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ga waya ŋunhi yolŋuya wayay ŋanya ŋarrtjunana bitjayana, “Nhäku nhe gurra dhuwaya buŋgan-latjuꞌya djalkthun? ");
INSERT INTO dwy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nhe ŋunhi beni djalim rrupiyawuna bathalawuna, ga rrupiyatja nhe ŋunhi be wekanha ŋunha lopananha yolŋuna wayana.” ");
INSERT INTO dwy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ŋayŋu ŋayi Djesuya waŋana wayana bitjaya, “Gunhaꞌyu waya ŋanya. Yaka waya nhanŋu mari-djäma. Dhuwaya ŋayi latjuꞌkuŋaya djäma ŋarraku. ");
INSERT INTO dwy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŋunha ŋunhi lopaya yolŋu waya yurru nhina nhumaŋgayana dhiyana biyakuna bili, ga balanyamiyu nhuma ŋuli wayana guŋgaꞌyuya. Yurru ŋarra yurru dhuwaya nhumaŋgaya yaka nhina wiyin, dhumbuḻꞌnha waluya. ");
INSERT INTO dwy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dhuwaya ŋarra ŋuli rakunydhina ŋayŋu waya yurru ŋarraku rumbalya gärrinymaŋayana moluyina. Ga dhiyaŋuya miyalkthu rarryuna ŋarrakaya dhuwaya buŋgan-latjuꞌ latjuꞌkuŋaya, ŋunhiya mayaliꞌ bitjan ŋayi ŋarrana ŋathilꞌyuna djäma rumbal ŋarraku. Ga latjuꞌna ŋayi dhuwaya wirrkina yulŋuya ŋunhi ŋayi bitjaya djäma. ");
INSERT INTO dwy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ŋäku waya ŋarrana. Dhuwaya ŋarra yurru nhumaŋgu yuwalk yana ḻakama. Ŋunhi ŋuli yolŋuy wayay, marrtji dhäwuꞌ ḻakaŋu ŋunha bala buku-ḻiwꞌmaŋu, ga ŋäku yana waya ŋuli dhuwaya miyalkalaŋuwuy dhäwuꞌ, ŋunhi nhä ŋayi ŋarraku djäma latjuꞌ. Ga guḻkuꞌna yurru ŋunhi yolŋuya waya marŋgiyi.” ");
INSERT INTO dwy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ga beŋu dhurrwaraŋu ŋayi ŋunhi waŋgany yolŋu yäku Judas Iscariot beŋu wayaŋgaya 12-kaya malthunamiwaya malaŋu marrtjinana. Yo, marrtjina ŋayi ga bunana ŋurruŋu-ḏalkarramiwu wayaŋgu, märr ŋayi yurru wayana guŋgaꞌyun goŋ-wekama Djesuna wayaŋgaya. Ga ḻakama ŋayi yurru wayaŋgu nhanŋuway ŋayaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ga ŋunhi waya ŋaḻapaḻmiyu balanya ŋäkuya ŋayŋu waya ŋoy-ŋamathinana. Ŋayŋu waya dhawuꞌ-nherraṉmina bitjaya, “Ŋuli nhe yurru Djesuna ŋanapuŋgaya goŋ-wekama, ŋanapuya yurru nhuna wuŋiḻi-yuna ŋurikiwuya.” Ŋayŋu ŋayi Judas-dja marrtjinana, bala gurrana dhukarrwuna ḻarruŋaya nhattjan ŋayi yurru Djesuna wayaŋgaya gathan. ");
INSERT INTO dwy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ga bitjana bili dhuŋgarra ŋupana ŋunhi ŋurru-yirrꞌyunamiyu waluyu wayaŋgu Jew-wu rom, waya ŋuli ḏämba ŋomaṉa ŋatha ŋuriki romgu malthuna yäkuwu Bilkpilk Ḏämba, ga wutthuna waya ŋuli bimbi wäyin ŋuriki romgu Ḻäy-djuḻkthunamiwu waluwu. Manymak, ga balanyamiyu bili yana waluyu, waya ŋuli ḻuṉḏuꞌmiŋuyu wayay waŋanha ŋanya Djesuna bitjana, “Wanhami wäŋaŋu ŋilimu yurru ŋamaŋamayun Ḻäy-djuḻkthunamiya ŋatha?” ");
INSERT INTO dwy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ŋayŋu ŋayi Djesuya waŋana guyurrꞌmiŋuna maṉḏana bulalꞌnha bitjaya, “Gatjuy marrtjina maṉḏa ŋayŋu Jerusalem-dhina. Ga ŋunhi nhuma yurru bunaya ŋunhaya wäŋaŋuya, nhuma yurru nhäma ḏarramuna. Ŋayi yurru gurra gapu gäma ḻambarryu banikinꞌmi. Ga malthu maṉḏa nhanŋu, ga gunha ŋayi yurru gulŋiyi ŋunhima buṉbuyi, yaka gunhaꞌyu, yana malthu nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ga ŋunhaya djinawaꞌya nhuma yurru waŋa buŋgawana ŋuriki buṉbuwu, ga bitjan nhuma yurru nhanŋu ḻakama gamꞌ, ‘Wäy, ŋunha Marŋgikunhamiyu ŋäŋꞌthuna wanhami ŋanapu yurru Ḻäy-djuḻkthunamiya ŋatha ŋamaŋamayun, märr ŋanapu yurru ḻuka ŋayi ga ŋanapu ḻuṉḏuꞌmiŋuyu wayay.’ ");
INSERT INTO dwy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ŋayŋu ŋayi yurru ŋuriŋi buŋgawayuya milkuma ŋunhana ŋunhi garwarnha wäŋa, ḻinyguna dharrana gurra, ŋilimuŋguna, ga ŋunhayana nhuma yurru ŋunhi ŋathaya ŋilimuŋgu ŋamaŋamayun.” ");
INSERT INTO dwy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ŋayŋu yana maṉḏa ŋunhi marrtjinana. Ga ŋunhi maṉḏa Jerusalem-dja bunana, ga maḻŋꞌmaŋaya maṉḏa balanya bili ŋunhi nhattjaya ŋayi gurrana Djesuyu maṉḏaku ḻakaŋaya. Ga ŋunhayana maṉḏa ŋunhi Ḻäy-djuḻkthunamiya ŋatha ŋamaŋamayuna. Ga goŋ-dhawarꞌyuna maṉḏa bala roŋiyina Djesuwayana. ");
INSERT INTO dwy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ga ŋunhi marrtjina waluya gärrina ŋayŋu ŋayi Djesuya ga ḻuṉḏuꞌmiŋuya waya nhanŋu ŋunhi 12-tja marrtjina ŋayŋuna wäŋayi. ");
INSERT INTO dwy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ga ŋunhi waya marrtjina ŋathaya ḻukana, ŋayŋu ŋayi Djesuya waŋana bitjayana, “Yuwalk yana ŋarra yurru dhuwaya nhumaŋgu ḻakama. Dhuwaya gayꞌ dhiyalaŋumi malaŋu dhuwaya ŋatha ŋilimu gurra ḻuka rrambaŋi, waŋganydja yolŋu yurru ŋarraku miriŋuthina,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ŋayŋu wayatja ŋunhi guyurrꞌmiŋuya waya nhanŋu galŋa-yätjthinana ŋuriŋiya dhärukthu nhanukaya, bala waya marrtjina dhä-wirrkaꞌyunana ŋanya bitjaya, “Wäy,... yolthu way... yol ŋarra ŋeniya Marrkapmi?” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ŋayŋu ŋayi Djesuya bitjayana waŋana, “Waŋganydhuya yolŋuyu dhiyalaŋumi gurra ŋathana mulka, ŋali yurru ḻupꞌmama banikinꞌthi rrambaŋina, ŋunhiya yolŋu yurru ŋarraku miriŋuthina. ");
INSERT INTO dwy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Guyaŋi waya, ŋarraya dhuwaya Yuwalkŋuya Walꞌŋu Yolŋu yurru rakunydhina bitjan yana bili ŋunha gurra God-Waŋarrwaya Dhuyuŋu Djorraꞌŋu wukirriwuy djingaryun. Ga bathalana wirrkina yurru ŋurikiya gumurr-gänhamiwuya yolŋuwu mari maḻŋꞌthu. Ga latjuꞌya nhanŋu ŋunhi ŋayi beni yaka maḻŋꞌthuna.” ");
INSERT INTO dwy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ga baḏak waya marrtjina ŋunhi ḻukana ŋathaya, ŋayŋu ŋayi Djesuya ḏämbaꞌna ŋätthuna bala bukumiyaŋaya God-Waŋarrnha ŋurikiyi. Ga ḏawꞌyuna ŋayi, ŋayŋu wekaŋaya marrtjina wayaŋgu. Ga waŋana ŋayi bitjaya, “Dhuwayatja ḏämba ŋarraku rumbal. Maꞌ, ŋätthuna ŋayŋu ḻukina.” ");
INSERT INTO dwy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ga bitjaya bili ŋayi ŋätthuna wiyikaꞌya banikinꞌmi, ga buku-wekaŋaya ŋayi God-Waŋarrnha, ŋayŋu ŋayi wekaŋaya ŋunhi wiyikaꞌya ŋunha guyurrꞌmiŋuwuna wayaŋgu wurkthunawu. ");
INSERT INTO dwy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ŋayŋu ŋayi bitjayana waŋana, “Dhuwayatja borum wiyikaꞌ ŋarraku gulaŋ, ŋunhi yurru ḻarryun guḻkuꞌwuna yolŋuwu walŋakunhawu. Ga bamanꞌtja ŋayi ŋunhi God-Waŋarryu dhawuꞌ-nherraya rom guḻkuꞌwu yolŋuwu walŋakunhawu. Dhiyaŋuya ŋunhi ŋarrakayatja gulaŋdhu yurru romnha marrtjinyamama, maḻŋꞌthuna yurru yuwalkthina. Maꞌ, ŋätthuna bala wurkthuna. ");
INSERT INTO dwy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ga dhuwanna gamꞌ, yakana ŋarra yurru buluya borum wiyikaꞌ wurkthu, ga gunha ŋilimu ŋuli rrambaŋina nhini ŋunhayana djiwarrꞌŋuna God-Waŋarrwayana romŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ga dhurrwaraŋu beŋuya ŋayŋu waya manikaynha barkparkthuna God-Waŋarrwayana. Ŋayŋu waya marrtjina ŋayŋu bukuyina wäŋayi yäkuyi Mount-Olive-thi. ");
INSERT INTO dwy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ga ŋunhi waya marrtjina ŋayŋu dhukarr-ŋupaya, ŋayŋu ŋayi Djesuyuya ḻakaŋaya ŋathilꞌyuna bitjaya, “Yalalaya yurru ŋunhi munhakuyina ga nhumaya yurru dhuwayatja waya waṉḏiꞌ-waṉḏina ŋarrakaya, gunhaꞌyuna ŋarrana yurru. Yo, ŋäthiyi yana ŋunhi waŋganydhu yolŋuyu dhäwuꞌ bitjaya wukirri Dhuyuyi Djorraꞌyi bitjaya gamꞌ, ‘God-Waŋarryu yurru buma rakunyguma ŋunhi wäyin-djäkaminaya, ŋayŋu ŋayi yurru bimbiya mala ḻatjuwarrꞌyuna.’ ");
INSERT INTO dwy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ŋarraya ŋuli rakunydhina. Yurru ŋarra ŋuli dhuwaya bulu walŋathi ŋayŋu ŋuli marrtjiya ŋurruŋuna nhumaŋgu, ga ŋunhayana ŋarra nhumaŋgu yukirri galkuyuya Galilee-na wäŋaŋu. Yo, ŋunhayana nhuma ŋuli ŋarrana nhäŋuya.” ");
INSERT INTO dwy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ga ŋayiya Peter-ya waŋana bitjayana, “Ŋarraya yurru nhuna yaka gunhaꞌyun, marrkapmi, gunha warray yurru wayatja nhuna gunhaꞌyun, yurru ŋarraya yaka.” ");
INSERT INTO dwy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ga ŋayi Djesuya waŋana bitjaya, “Ŋäku ŋarrana latjuꞌkuŋu Peter. Dhiyaŋu bala munhaku, yalala, nhe yurru ŋarraku dhumbalꞌyun ḏämbu-ḻurrkunꞌmi, ga yurruna ŋayi yurru ŋunhi wäyindja djiḻawurrya ŋäthi ḏämbu-bulalꞌmi.” ");
INSERT INTO dwy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ga ŋayi Peter-ya wirrkina waŋana bitjayana, “Yaka dhuwaya ŋarraya yurru nhuŋu dhumbalꞌyun, gunhayi ŋunhi ŋarra yurru rakunydhiya!” Ga waya ŋunhi wiripuya ḻuṉḏuꞌmiŋu waya ga bitjaya bili waŋana rrambaŋi yana dhäruk. ");
INSERT INTO dwy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ga ŋunhi Djesu ga ḻuṉḏuꞌmiŋu waya nhanŋu bunana ŋunhaya Gethsemane wäŋaŋu, ŋayŋu ŋayi Djesuya waŋana, “Dhiya waya ḏäpthu, ŋarra yurru bukumiyama God-Waŋarrwaya,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Ŋayŋu ŋayi garrꞌyuna Peter-na ga James-na ga John-na, ŋayŋu marrtjina bitjayana bala. Ga gurriri märr waya ŋunhi marrtjinaya, ga bulu ŋayi waŋana wayaŋgu, “Waya, ŋayaŋuya ŋarraku dhuwaya wirrkina yana ŋonuŋdhina bitjan ŋarra yurru dhuwaya rakunydhina. Dhiya waya ḏäpthu, yurru djäka yukirri yulŋuya,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ga marrtjina ŋayi märr gurriri, ŋayŋu yana gutjparryunminana munathaꞌyina ŋayŋu bukumiyaŋayana, “Bäpa ŋarraku marrkapmi, yakana dhuwaya nhuŋuya gumurr-ḏäl ŋula nhäku malanyŋuwu djämawu. Bäpaꞌ, ḏukṯuk ŋarra dhuwaya nhe yurru yarrkmama dhuwaya mari ŋarraku. Yurru ŋarrapiya gurra dhuwaya nhuŋuwaynha yana djälwuya malthun, yakana ŋarrakuwaya ŋarra,” bitjaya ŋayi gurrana bukumiyaŋayatja. ");
INSERT INTO dwy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ga roŋiyina ŋayi ŋayŋuyi luṉḏuꞌmiŋuwu wayaŋgu bunana ga maḻŋꞌmaŋaya wayana gayŋimina. Ga dhirrꞌyuna ŋayi wayana, ŋayŋu ŋayi Peter-wayatja waŋana bitjayana, “Wäy, nhattjan nhumaya gurra dhuwaya, gayŋithi yana? Yakana nhuma yurru dhuwaya märr ŋula gurriri biraꞌyun? ");
INSERT INTO dwy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Djäka waya nhumaŋguway, ga bukumiyaŋu waya God-Waŋarrwaya märr nhumana yurru ŋula nhäyuya mulka, nhumaya yurru ŋunhi dhärra ḏälnha yana. Ḻinygu ŋayaŋuya nhuŋu gurra dhuwayi djälmiyi nhe yurru dhärra ḏäl yana, yurru rumbalya nhuŋu dhuwayi ganydjarrmiriwnha yalŋgiꞌyinana,” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ga bulu ŋayi Djesu marrtjina buku-ŋalꞌyunawu, ga bitjaya bili ŋayi bukumiyaŋaya balanya bili yana dhäruk. ");
INSERT INTO dwy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ga gaŋgathina ŋayi, ga roŋiyina beŋu bukumiyanhaŋu ga maḻŋꞌmaŋaya wayana yakurrmina yana, bathalayuna wayana yakurryu bilkthuna. Ga ŋunhi waya ḏurryunaya bala goranana, ga yakana waya ŋula buku-roŋinymaŋaya nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ga bulu ŋayi ḏämbu-ḻurrkunꞌmi roŋiyina bukumiyanhaŋu. Ga ŋunhi ŋayi roŋiyinaya ŋayŋu waŋana ŋayi bitjayana, “Ḻinyguna yakurrŋuya waya gulyuna! Waluya dhuwaya galkithinana, ŋayi yurru ŋuriŋiya yolŋuyu goŋ-wekamana ŋunhi Yuwalkŋunaya Walꞌŋu Yolŋuna yätjkayana yolŋuwaya wayaŋgaya. ");
INSERT INTO dwy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Maꞌ! Gaŋgathina waya ŋilimu marrtjina. Nhäŋuna waya, dhuwanna ŋayi ŋunhiyiya yolŋu ŋunhi ŋayi guŋgaꞌyuna wayana mulkanhawu ŋarraku.” ");
INSERT INTO dwy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ga ŋurruŋu-ḏalkarrami mala ga rom-marŋgikunhami ga Jew-wu ŋurru-warryunami mala waya djuyꞌyuna yolŋuna wayana ŋapawu Judas-ku malthuna. Ga ŋayi ŋunhi Djesuya baḏak yana waŋana gurrana, ŋayŋu ŋayi Judas-tja bunana wayaŋgu ga mala nhanŋu. Ga marrtjinaya waya gurrana malkarrmi, goŋ garami, ga goŋ birkuꞌmi, mulkanhawu nhanŋu Djesuwu. ");
INSERT INTO dwy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ga bili ŋayi ŋunhi Judas-thuya ḻakaŋaya bitjaya, “Ŋunhi yolnha ŋarra yurru burumunꞌ walkuma ŋunhina yolŋunaya nhuma yurru mulkaꞌ.” ");
INSERT INTO dwy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ga ŋunhi waya bunanaya ŋayŋu ŋayi Judas-tja marrtjina Djesuwayana ŋayŋu waŋana bitjayana, “Marŋgikunhami,” bitjana, ŋayŋu walkuŋayana ŋanya, ga maŋutji-wekaŋayana ŋanya ŋunhi yolnha waya yurru mulkaꞌ. ");
INSERT INTO dwy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ŋayŋu waya wiripuya yolŋu mala galkithinana mulkanhawuna nhanŋu Djesuwu. ");
INSERT INTO dwy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ga ŋunhi waŋganydhuya Djesuwaya ḻuṉḏuꞌmiŋuyu yikiꞌna dhawaṯmaŋaya ŋayŋu yana buthuruna gulkthuna, ḻiya-ŋärraꞌmiwuna djämamina. ");
INSERT INTO dwy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ŋayŋu ŋayi Djesuya waŋana ŋuriki yolŋuwu wayaŋgu bitjayana, “Nhäku nhuma liliya marrtjina malkarrmiya? Yaka ŋarra dhuwaya maḏakarritj yolŋu. ");
INSERT INTO dwy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ŋarraya gurrana bitjaya bili walu-ŋupaya marŋgikuŋaya yolŋuna wayana ŋunhaya God-Waŋarrwaya Dhuyuŋu Buṉbuŋu, ga yaka warray nhumaya ŋarrana balanyamiyuya mulkana... yurru dhuwanna nhumaŋgu waluya. Yo, bitjan ga yana ŋayi gurra ŋunha wukirriwuya dhärra ŋäthiliŋuya God-Waŋarrwaya Djorraꞌŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ŋayŋu ŋunhi Djesuwuya ḻuṉḏuꞌmiŋu waya biyaṉiyinana ŋayŋu waya waṉḏiꞌwaṉḏinana, gunhaꞌyunana ŋanyaya ŋunhimana. ");
INSERT INTO dwy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ga ŋunhayayi gurrana gurrmulyu ḏarramuyu guyurr-ŋupaya Djesuna, ga bilkthunminaya ŋayi ŋunhi galikuꞌyu. Ga bitjaya bili waya ŋanyaya mulkana. ");
INSERT INTO dwy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Yurru waya ŋanya baḏatjuna ga mulkanaya waya nhanŋu ŋunhi galikuꞌna. Ga ŋayipiya gurrana waṉḏina wäŋayina girriꞌmiriwnha, bili ŋayi ŋunhi biyaṉiyina wirrkina. ");
INSERT INTO dwy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ŋayŋu waya ŋunhi gäŋayana Djesunaya ŋayŋu ḻiya-ŋärraꞌmiwayana wäŋayi. Ga ŋunhaya ŋunhi ŋaḻapaḻmiya yolŋu waya gurrana nhinana bukmak yana, ŋurruŋu-ḏalkarrami mala ga rom-marŋgikunhami waya ga Jew-wu ŋurru-warryunami mala. ");
INSERT INTO dwy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ga ŋunhi waya Djesuna gäŋaya, ga ŋayiya gurrana Peter-ya malthuna bala, ŋayŋuyi ḻiya-ŋärraꞌmiwaya wäŋayi, yurru djuḻuḻꞌyuna ŋayi gurrana marrtjinaya bala. Ga gulŋiyina waya rrambaŋi ŋayŋuyi, bala ŋayi malayina gärrina wayaŋgaya ḏap-ṯapkayana miṯtjiyi waya marrtjina ḏäpthuna ḻithaya gurthaŋu. ");
INSERT INTO dwy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ga ŋunhaya ŋunhi djinawaꞌ buṉbuŋu waya ŋunhi ŋurruŋu-ḏalkarramiya wayay gurrana dhäwuꞌna maḻŋꞌmaŋaya Djesuwalaŋuwuynha märr waya yurru djarrma-gäma ŋanya yätjpuy djämapuy. Yurru yaka waya ŋunhi malŋꞌmaŋaya ŋula nhä yatj nhanukaya. ");
INSERT INTO dwy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yo, guḻkuꞌna yolŋuna waya ŋätthuna mäkiriꞌ-marŋgimina märr waya yurru nyäḻꞌnha dhäwuꞌ nhanukalaŋuwuy ḻakama, ga dhäwuꞌya mala wayaŋguŋu ŋunhi barrkuwatjthinana. ");
INSERT INTO dwy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yo, ga wiripu-guḻkuꞌ yolŋu waya ŋunhi mäkiriꞌ-marŋgimi gaŋgathina bala gurrana nyälꞌnha dhäwuꞌ ḻakaŋaya ");
INSERT INTO dwy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","bitjaya, “Dhuwanaya ŋanapu yolŋuna ŋäma ŋayi bitjan waŋa, ‘Dhuwaya ŋarra yurru ḏawꞌmamana God-Waŋarrwuya Dhuyuya Buṉbu yolŋuwuŋuya goŋbuy dhuḻꞌyunaya. Ga ḻurrkunꞌthu waluyu wiripuna ŋuli buṉbu ŋalꞌyu, ga ŋunhiya yakana yolŋuwuŋu goŋbuy.’ ” ");
INSERT INTO dwy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ga dhäwuꞌya waya gurrana ŋunhi ḻakaŋaya yaka dhunupaya. ");
INSERT INTO dwy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ŋayŋu ŋayi ŋunhi ḻiya-ŋärraꞌmiya yolŋu gaŋgathinana gumurrŋu yolŋuwaya wayaŋgaya ŋayŋu waŋana Djesuwuya bitjayana, “Dhuwaya gurrana yolŋuyu wayay ḻakaŋaya be nhe yätj djäma. Ŋäma ga nhe gurra wayana yulŋuya? Nhäku nhe gurra dhuwaya mukthundja nhina?” ");
INSERT INTO dwy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yurru ŋayi Djesuya yakana buku-roŋinymaŋaya. Mukthunana ŋayi gurrana nhinana. Ŋayŋu ŋayi ŋunhi ḻiya-ŋärraꞌmiya waŋana bitjayana, “Maꞌ, ḻakaŋuna ŋanapuŋgu. Nheya dhuwaya ŋunhi Maŋutji-ḻakanhawuy yolŋu ŋeniya... God-Waŋarrwu gäthuꞌmiŋu?” ");
INSERT INTO dwy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ga ŋayi Djesuya waŋana bitjayana, “Yo, ŋarraŋga dhuwaya. Ga yalalaya nhuma yurru ŋarrana Yuwalkŋunaya Walꞌŋu Yolŋuna nhäma, ŋarra yurru gurra nhina ganydjarrmina, dhunupaꞌŋumina God-Waŋarrwayana galiꞌŋu ŋunhaya djiwarrꞌŋuna. Ga roŋiyi ŋarra ŋuli lili djiwarrꞌŋuyu waŋupiniꞌyu. Balanyamiyuna nhuma yurru ŋarrana nhämaya.” ");
INSERT INTO dwy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Ŋayŋu ŋayi ŋunhi ḻiya-ŋärraꞌmiya yolŋu wirrkina maḏakarritjthina, bala marrtjina girriꞌna nhanŋuway ŋayi barrꞌparrmaŋaya, ga waŋana ŋayi yätjkuŋayana bitjaya, “Ḻinyguna ŋilimu dhuwaya ŋäkuyana ŋanya dhäruktja bukmakthu waŋanhaya, ŋunhi ŋayi wanaŋgunhamina waŋana yana beni ŋayi God-Waŋarrnha. Yakana ŋilimu yurru buluya mäkiriꞌ-marŋgimiwuŋuya dhäwuꞌ ŋäma. Nhattjana nhumaya gurra guyaŋi ŋe?” bitjaya. Ga waya ŋunhi bukmaknha yolŋuya waya yoraŋayana yana bitjayana, “Yo, baymatthuna ŋanya murrkayꞌkuŋuna.” ");
INSERT INTO dwy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ŋayŋu marrtjina ŋunhi wiripuyuya yolŋuy wayay Djesunaya dhupthunana. Ga garrwiꞌyuna waya ŋanya maŋutji galikuꞌyu bala gurrana bartjunmaŋayana, ga waŋana waya bitjaya, “Maꞌ, ŋuli nhe God-Waŋarrwuya yolŋu, ḻakaŋu mak, yolthu nhuna wutthunaya?” Ŋayŋu ŋunhi ḏapṯapthuya wayay Djesunaya djawꞌyunana, bala gurrana baymatthunana ŋanya. ");
INSERT INTO dwy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ga balanyamiyu ŋayiya gurrana ŋunhi Peter-ya baḏak yana nhinana ḻithaya. Ga ŋunhaya ḻiya-ŋärraꞌmiwaya buṉbuŋu djämamiyu miyalkthu nhäŋaya Peter-na ŋunhamayi bala waŋanana bitjayana, “Nheya dhuwaya Djesuwu ḻuṉḏuꞌmiŋu ŋeniya?... ŋuriki yolŋuwu wäŋa Nazareth-puyŋuwu?” ");
INSERT INTO dwy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ga ŋayi Peter-ya dhumbalꞌyuna bitjaya, “Yaka dhuwayitja dhunupa. Yaka dhuwaya ŋarra marŋgi nhäku nhe gurra dhuwaya waŋa.” Ŋayŋu yana ŋayi Peter-ya walmanana warraŋulyina, ga dhunupana yana ŋunhi djiḻawurrya ŋäthinana. ");
INSERT INTO dwy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ga bulu ŋayi ŋuriŋi djämamiyu miyalkthu Peter-na nhäŋaya, ga waŋana ŋayi yolŋuꞌyulŋuna wayana ŋunhi marrtjina dhärra-dharrana bitjaya, “Dhuwayatja yolŋu Djesuwu yana ḻuṉḏuꞌmiŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ga ŋayi Peter-ya waŋana, “Yaka!... yaka ŋarraya!” Ga yaka wiyindja ga wiripuyu yolŋuyu ŋanya waŋana bitjaya, “Nhepi yana dhuwaya, dhuwaya nhe wäŋa Galilee-puy.” ");
INSERT INTO dwy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ŋayŋu ŋayi ŋunhi Peter-ya wirrkina galŋa-yätjthina bala ŋayi waŋana bitjayana, “Yaka, yaka ŋarraya dhuwaya marŋgi. God-Waŋarr dhuwaya ŋarrakuya marŋgi, ga ŋunhi ŋarra gurra nyäḻꞌyundja, ŋayiya yurru ŋarrana God-Waŋarryuya dhä-dirꞌyuna.” ");
INSERT INTO dwy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ga dhunupa yana ŋunhi djiḻawurrya ŋäthinana, ŋunhiya ḏämbu-bulalꞌmina. Ŋayŋu ŋayi Peter-yuya guyaŋinana ŋunhi nhattjaya nhanukaya Djesu waŋana bitjaya, “Yurruna ŋayi yurru ŋunhi djiḻawurrya ŋäthi ḏämbu-bulalꞌmi, nheya ŋarraku yurru märr-dhumbalꞌyun ḏämbu-ḻurrkunꞌmi.” Ŋayŋu yana ŋayi Peter-ya ŋäthinana wirrkina dhika murryuꞌmurryunana. ");
INSERT INTO dwy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ga munhayuna waluyu ŋayŋu waya ŋunhi Jew-wuya ŋaḻapaḻmi ḻuŋꞌthunana ŋayŋu yoranhamina nhanŋu Djesuwuya baymatthunawuna rakunygunhawuna. Ŋayŋu waya gärrwiꞌyuna ŋanya ŋarambiyana bala gäŋayana waya ŋuriŋi ŋaḻapaḻmiyu ŋayŋuna nhanukaya Pilate-kayana ŋunhi ŋayi Roman-buyŋuwu gapmangu buŋgawa. Ga waŋana waya Pilate-na ŋayi yurru ŋanya dhä-wirrkaꞌyun. ");
INSERT INTO dwy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ŋayŋu ŋayi Pilate-thuya dhä-wirrkaꞌyunana ŋanya, “Nhe dhuwaya buŋgawa Jew-wuya yolŋuwu wayaŋgu?” Ga ŋayi Djesuya buku-roŋinymaŋaya bitjaya, “Dhuwayina ḻinygu yana dhäruktja.” ");
INSERT INTO dwy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ga waya ŋunhi Jewyu ŋurruŋu-ḏalkarramiyu wayay ḻakaŋaya gurrana Pilate-kaya bitjayana, “Dhiyaŋuya yolŋuy gurrana warkthuna yätjnha wirrkina rom malanynha.” ");
INSERT INTO dwy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ŋayŋu ŋayi Pilate-tja bitjayana nhanŋu waŋana, “Ŋäma ga nhe gurra yulŋuya? Ŋunha waya gurra nhuna ḻakama be yätjpuy djämapuy. Yakana nhe yurru dhuwaya ŋula waŋaya?” ");
INSERT INTO dwy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yurru ŋayi Djesuya yakana waŋana, bala gurrana ŋunhi Pilate-tja maŋmaŋdhunana nhanŋu. ");
INSERT INTO dwy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yo, bitjana ḻinygu dhuŋgarra-ŋupana waya ŋuli ŋunhi Jew-ya bäpurruꞌ yolŋu mala waŋgany-manapanminya waŋganygu romgu yäkuwu Ḻäy-djuḻkthunamiwu Waluwu. Ga bitjana ḻinygu ŋayi ŋuli Roman-buyŋuyu gapmandhu dhawaṯmanha waŋganynha yolŋuna ḻoḻuŋu, yolku waya ŋuli Jew-yu ŋäŋꞌthuna. ");
INSERT INTO dwy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yo, ga balanyamiyu gurrana yolŋu yäku Barabbas gärrina ga mala nhanŋu bili waya ŋuli gurrana mari-djäma Roman-buyŋuwu gapmangu malawu. Ga wiripunaya wayana yolŋuna Barabbas-thu ga malayu nhanukaya bili baymatthuna rakunyguŋaya. ");
INSERT INTO dwy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Manymak, waya ŋunhi Jew-ya mala yolŋu marrtjinana bala ŋäŋꞌthuna Pilate-na waŋganyguna yolŋuwu dhawaṯmanhawu, bitjana ŋayi ŋuli Pilate-thu ŋäthiyi warkthuna dhuŋgarra-ŋupana. ");
INSERT INTO dwy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ŋayŋu ŋayi Pilate-tja waŋana bitjayana, “Yolnha ŋarra yurru dhawaṯmamaya? Nhämi warray dhuwayatja ŋunhi Jew-wuya yindiya buŋgawa?” ");
INSERT INTO dwy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yurru ŋayi ŋunhi Pilate-tja ŋäthiyi yana marŋgithina ŋunhi waya ŋurruŋu-ḏalkarramiyu wayay gäŋaya ŋanya Djesuna ŋayŋu nhanukaya bili waya gurrana ŋunhi wirrkina yana maŋutji-ḏiyꞌyunaya ŋanya. ");
INSERT INTO dwy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yurru waya ŋunhi ŋurruŋu-ḏalkarramiyu wayay gurrana gurꞌkuryuna yolŋuna wayana märr waya yurru Pilate-na ŋäŋꞌthun Barabbas-kuna dhawaṯmanhawu. ");
INSERT INTO dwy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ga bulu ŋayi Pilate-thu dhä-wirrkaꞌyuna ŋunhi yolŋuna wayana, “Nhattjan ŋarra yurru dhuwaya yolŋunaya, be nhuma ŋuli gurra ḻakama be ŋayi dhuwaya yindi buŋgawa Jew-wu yolŋuwu wayaŋgu?” ");
INSERT INTO dwy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ga wayatja bukmaknha yana waŋana yatjunmina bitjayana, “Baymatthuna ŋanya rakunyguŋuna yana! Dhuḻꞌyuna ŋanya dharpayina!” ");
INSERT INTO dwy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ga ŋayi Pilate-tja waŋana, “Nhä yulŋuya? Nhä ŋayi nhumaŋgu yätjtja warkthuna?” Yurru wayatja ŋunhi wirrkina yana yatjunmina waŋana, “Baymatthuna ŋanya rakunyguŋuna yana, dhuḻꞌyuna biyakuna dharpayina!” ");
INSERT INTO dwy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ŋayŋu ŋayi Pilate-tja yoraŋayana wayaŋgu, djälwuna malthuna. Ŋayŋu yana ŋayi Barabbas-nhaya dhawaṯmaŋayana. Ga waŋana ŋayi Roman-buyŋuwuya miriŋuwu wayaŋgu bartjunmanhawuna nhanŋu Djesuwu. Ga ŋunhi waya nhanukaya bartjunmanhaŋuya goŋ-dhawarꞌyuna bala ŋayi Pilate-tja bitjayana waŋana miriŋuwayatja, “Gatjuy ŋätthuna waya ŋanya ŋayŋu dhuḻꞌyuna ŋanya dharpayina ŋayŋu gunhaꞌyuna ŋunhimana, gunha ŋayi yurru rakunydhi.” ");
INSERT INTO dwy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ga beŋuya dhurrwaraŋu ŋayŋu ŋunhi miriŋuyu wayay gurrana gäŋaya Djesunaya dhawaṯmaŋayana ŋayŋu wiripuyina wäŋayi. Ga wäthuna waya gurrana wiripuŋuwu miriŋuwu wayaŋgu märr yurru waya miṯtjina dhaŋaŋꞌdhi, ga guḻkuꞌna ŋunhi wirrkina miriŋuya, ŋunhi gurrana dhawaṯthuna ŋayŋuyi. ");
INSERT INTO dwy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ga nhirraya waya nhanukaya djakaꞌ wiyin miku girriꞌ bitjan yindiwuna buŋgawawu. Ga ŋalꞌmaŋaya waya ḏirriṯirri ŋayŋu dhoṯkuŋaya, djoŋguꞌyi djäma, ŋayŋu yana ṉiṉꞌthunmaŋayana nhanukaya muḻkurryina. ");
INSERT INTO dwy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ŋayŋu waya gurrana ŋanya warkuꞌyunana bitjayana, “Dhuwana ŋayi yindiya buŋgawa Jew-wu malawu!” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ŋayŋu waya gurrana muḻkurrnha ŋanya wutthuna dharpayuna, ga dhupthuna waya ŋanya ŋayŋu warkuꞌyunana, bunꞌkumu-djipthuna nhanŋu ga buku-ŋalꞌyuna manapaya. ");
INSERT INTO dwy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ga ŋunhi waya warkuꞌyunaŋuya dhawarꞌyuna, bala waya yupmaŋayana nhanukaya minyꞌtjimiya girriꞌ ŋayŋu nherraꞌya nhanŋuwaynha girriꞌ. Ŋayŋu ŋanya miriŋuyuya wayay gäŋayana dhawaṯmaŋayana dhuḻꞌyunawuna dharpayina mälakmanhayina. ");
INSERT INTO dwy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ga ŋunhi waya marrtjina gumurr-ḏuwaṯthunaya beŋuya Jerusalem-ŋuya ŋayŋu waya gandarrŋuya maḻŋꞌmaŋaya yolŋuna yäkuna Simon-na wäŋa Cyrene-buyŋuna. Ga bäpaꞌmiŋu ŋayi ŋunhi maṉḏaku Alexander-wu ga Rufus-ku. Ŋayŋu yana waya ŋanya waŋana warryunawuna ŋurikina Djesuwalaŋuwuna dharpawu. ");
INSERT INTO dwy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ŋayŋu waya marrtjinana ŋunhimana wäŋayi yäkuyi Golgotha-yi, mayaliꞌ, ‘Muḻkurr Ŋaraka Wäŋa.’ ");
INSERT INTO dwy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ga ŋunhayatja waya Djesuna wekaŋaya wiyikaꞌ borumnha goḏu-manapanaya mirritjinmiꞌ yäku merr, märr yurru ŋuriŋiya ŋayamunuŋꞌkumana ŋanya rumbalnha. Yurru ŋayipiya ŋunhi Djesuyuya yaka wurkthuna ŋunhi borum wiyikaꞌ. ");
INSERT INTO dwy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ŋayŋu waya ŋanya Djesunaya dhuḻꞌyunana dharpayina. Ŋayŋu ḏuwukthunana ŋunhi dharpaya, bala djingarmaŋaya ŋunhiyi. Ga waluya ŋunhi goḏarrꞌmi yana. Ŋayŋu gurrana ŋunhi miriŋuya waya ŋaḻaꞌyunana dopuluꞌna girriꞌwuna nhanukalaŋuwu. ");
INSERT INTO dwy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ŋayŋu waya dhäruknha wukirri ŋaramurryu märryu ŋunhi nhäpuy waya ŋanya dhä-ḏirꞌyuna, ŋayŋu dhuḻꞌyuna dharpayina, ŋunhi Djesu gurrana ŋalꞌyuna. Ga bitjaya gurrana ŋunhi waŋanaya: ");
INSERT INTO dwy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ga bitjaya ḻinygu waya ŋunhi manaŋgana ḏarramuna maṉḏana ŋalꞌmaŋaya, waŋganynhaya waya dhuḻꞌyuna dhunupaꞌŋuyi galiꞌyi Djesuwaya, ga wiripunaya dhuḻꞌyuna wiṉꞌkuyi galiꞌyi. ");
INSERT INTO dwy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dhuwayatja dhäruk balanyawuynha wukirriwuy God-Waŋarrwayana Dhuyuŋu Djorraꞌŋu balanyanha gamꞌ, “Ŋunhi waya bitjayana ŋanya ḻakaŋaya, yana beni ŋayiya yätjnha, rommiriwnha yolŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ga ŋunhi gurrana yolŋu waya marrtjina djuḻkthunmina, ga ḏawaḏawaꞌyuna waya gurrana, warkuꞌyuna manapaya ŋanya. Ga bitjana nhanŋu waŋana, “Wäy, beŋga nheya yurru dhuwaya ḏawꞌyun ŋunhi God-Waŋarrwu Dhuyu Buṉbu, ga bulu nhe yurru be dhuḻꞌyun ḻurrkunꞌthu waluyu? ");
INSERT INTO dwy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Go, mak birrkaꞌyunmina nhunapinya nhe ga yupthuna dhipuŋuya dharpaŋuya, märr ŋanapu yurru nhäma bala märr-yuwalkthina nhuŋu, ŋuli nhe God-Waŋarrwuya be gäthuꞌmiŋu?” ");
INSERT INTO dwy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ga bitjana ḻinygu waya gurrana ŋunhi ŋurruŋu-ḏalkarramiyuya ga rom-marŋgikunhamiyuya yolŋuyu wayay warkuꞌyuna ŋanya Djesuna. Ga bitjaya waya gurrana waŋana gamꞌ, “Way, dhuwaya ŋayi gurrana ŋunha wiripuna yolŋuna wayana walŋakuŋaya... ga yakana ŋayi yurru dhuwaya ŋanyapinyawuya walŋakunhami? ");
INSERT INTO dwy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dhuwaya ŋayi ‘Maŋutji-ḻakanhawuy yolŋu’ be God-Waŋarrwuŋuna djuyꞌyunaya ŋäthiliŋuna. Ga wiripuŋuya yolŋuyu wayay gurrana ḻakaŋaya be ŋayi dhuwaya Yindi Buŋgawa Jew-wu malawu. Ga ŋunhi yuwalktja, ŋayiya yurru yupthuna dharpaŋuya märr ŋilimu yurru nhäma ŋayŋu märr-yuwalkthina.” Ga bulalꞌ ḏarramu maṉḏa gurrana ŋunhaya ŋalꞌyuna rrambaŋi waya Djesu. Ga bitjana bili maṉḏa gurrana ŋanya warkuꞌyuna. ");
INSERT INTO dwy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ga ḏaykunꞌtja ŋunhi ḏämbuyuna waluyu, ga munhayuya ŋunhi bilkthuna warrpamꞌnha ŋunhiyi ŋarakaya wäŋa, bitjayana bitjan ŋuli munhakuyinana. Ga munyguŋayana ŋunhi munhayuna yana bili-i-i ga ḻäy-wilyunayu. ");
INSERT INTO dwy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ŋayŋu ŋayi ŋunhayatja Djesuya yatjunana dhärukuyuna nhanukaya Aramaic-kuyu bitjayana, “Eloi, Eloi, lema sabachthani?” (mayaliꞌ, “God-Waŋarr ŋarraku, God-Waŋarr ŋarraku, nhäku nhe ŋarrana gunhaꞌyunaya?”) ");
INSERT INTO dwy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ga ŋunhaya gurrana yolŋu waya djingaꞌdjingaryuna, ga ŋäkuya waya ŋunhi Djesuna yatjunaya. Ŋayŋu waya bitjayana waŋana, “Way ŋäku waya! Ŋunhaya ŋayi gurra Elijah-wuna gawawꞌyun.” ");
INSERT INTO dwy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ŋayŋu ŋayi waŋganydja yolŋu waṉḏina bala yalŋgi galikuꞌ ŋätthuna ŋayŋu borumiyina wiyikaꞌyi ḻupmaŋaya. Ga mamꞌthunmaŋaya ŋayi dharpayina ŋayŋu marrtjina garrwarkuŋayana Djesuwayana, märr ŋayi yurru wurkthun ŋunhiyi wiyikaꞌ borum. Ŋayŋu ŋayi bitjana waŋana, “Bulnha ŋäthiyi ŋilimu galkun ŋe!, ŋayi ŋuli Elijah-na yarrupthu guŋgaꞌyunawuna nhanŋu.” ");
INSERT INTO dwy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ŋayŋu ŋayi Djesuya wirrkina yatjuna, bala yana rakunydhinana. ");
INSERT INTO dwy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ga balanyamiyu ḻinygu ŋunhaya Jerusalem-dja ŋayiya ŋunhi galikuꞌya God-Waŋarrwayatja Dhuyuŋu Buṉbuŋu ŋunhi gurrana galmuŋaya ŋunha dhuyuya goḏu yolŋuwaya, ŋunhiyiya barrꞌyunana, beŋu bili bukuŋu ga yana bili ŋoyyi. ");
INSERT INTO dwy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ga ŋunhaya Golgotha-ŋu wäŋaŋu gurrana yolŋu djingaryuna, ŋurru-warryunayŋu miriŋuwu wayaŋgu, ga nhäŋaya ŋayi gurrana ŋanya Djesuna beŋu ŋoyŋu dharpaŋu ŋunhi ŋayi milmay rakunydhina. Ŋayŋu ŋayi waŋanana, “Nhäna way! Yuwalk yana dhuwayatja yolŋu God-Waŋarrwu Gäthuꞌmiŋu, ŋeniya?” bitjaya. ");
INSERT INTO dwy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ga ŋunhaya gurrana miyalk mala dhärraꞌdharrana, yurru märr barrku. Ga ŋunhiyi miyalk waya ŋuli Djesuwu gurrana malthuna, ga guŋgaꞌyuna ŋanya ŋuli ŋunhaya Galilee. Ga dhuwaya waya ŋunhi yulŋuya gamꞌ: Mary Magdalene, Salome, ga wiripu Mary, ŋäṉḏiꞌmiŋu maṉḏaku gurrmulwu maṉḏaku Simon-gu ga Joseph-ku, ga guḻkuꞌ ŋunhi wiripu miyalk mala ŋunhi waya ŋapawu malthuna nhanŋu Djesuwu bala Jerusalem-dhi. ");
INSERT INTO dwy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yo, ga rakunydhinaya ŋayi ŋunhi Djesuya waluyu Friday läy-wilyunayu. Ga beŋu dhurrwaraŋu ŋayŋu ŋayi Joseph-thuya birrkaꞌyuna ŋunhi ŋayi yurru Djesuna rumbal yupmamana beŋu dharpaŋuya. Ga yolŋuya ŋayi ŋunhi wäŋa Arimathea-buy, ga miṯtjiŋuya ŋayi ŋunhi Jew-waya ŋaḻapaḻmiwaya ŋärraꞌŋu. Ga latjuꞌ ŋayi ŋunhi yolŋuya. Ga gatjpuꞌyuna ŋayi gurrana ŋunhi God-Waŋarrwalaŋuwuna romgu marrtjinyamanhawuna yana. Ga yurruna ŋunhi wiripuya yurru walu djaḏawꞌyun ŋunhiya Jew-wuna bäpurruꞌwu Nhinanamina Walu, ŋayiya Joseph-tja gaŋgathina, bala yana marrtjinana ŋayaŋu-ḏälthinana Pilate-kayana bala waŋana, “Nhattjana ŋarra yurru Djesunaya rumbal ŋätthuna?” ");
INSERT INTO dwy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ŋayŋu ŋayi ŋunhi Pilate-thuya ganyimꞌthunana ŋäkuya, bala bitjayana waŋana, “Nhä, ḻinyguna ŋayi rakunydhinaya?” Ŋayŋu ŋayi dhäruk-ŋalꞌyuna ŋurikaya miriŋuwaya märr ŋayi yurru marrtjina nhanŋu buna Pilate-ku, ga dhä-wirrkaꞌyuna ŋanya bitjana, “Nhä, yuwalknha ŋayi rakunydhinaya?” ");
INSERT INTO dwy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ŋayŋu ŋayi ŋunhi miriŋuwayatja buŋgawayu ḻakaŋaya bitjayana, “Yuw, yuwalknha yana!” Ŋayŋu ŋayi Pilate-thuya dhayuŋayana Djesuna rumbal Joseph-kayana. ");
INSERT INTO dwy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ga ŋayiya Joseph-thuya wuŋiḻiꞌyuna manydjarrkaꞌna rrupiya yindimina, ga ŋayŋuyi ŋayi roŋiyina Golgotha-yi Djesuwu rumbalwuna ŋätthunawu beŋu dharpaŋuna. Ga ŋuriŋina ŋayi galikuꞌyu ŋanya garrpiṉaya, bala waya gurrunhaya ŋanya mathirrayina, ŋunhima ŋunhi waya ŋäthiyi yana ŋangiꞌyuna ŋunhi guṉḏa. Ŋayŋu waya bilkthuna bathalayuna guṉḏayu dhurrwaraya dhaḻꞌyuna. ");
INSERT INTO dwy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ga maṉḏaya ŋunhi Mary Magdalene-dja ga Mary Joseph-kuya ŋäṉḏiꞌmiŋu maŋutji-marŋgina maṉḏa wanhama waya Djesuna märrkitjkuŋaya. ");
INSERT INTO dwy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ga ŋunhi Jew-wu Nhinanhami Walu bilina dhawarꞌyuna ŋuruŋuynha yuṯuŋgurr-munhamiyuna. Ga beŋuya waya Mary Magdalene, ga Salome, ga Mary ŋunhi James-ku ŋäṉḏiꞌmiŋu marrtjina buŋgan-latjuꞌ wuŋiḻiꞌyuna märr waya yurru latjuꞌkuma yana goŋ-ŋamathi nhanŋu rumbalwu. ");
INSERT INTO dwy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ga Sunday-na marrtjina djaḏawꞌyuna, ŋayŋu ŋunhi miyalk-tja waya marrtjinana ŋayŋuna mathirrayina. ");
INSERT INTO dwy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ga ŋunhi waya marrtjinaya bala dhukarr-ŋupaya, ŋayŋu waya waŋanhamina, “Yolthu ŋilimuŋgu yurru ŋunha guṉḏaya giṯmama dhurrwaraŋuya? Yindina ŋunha wirrkina yulŋuya.” Ga ŋunhi waya bunana ŋunhaya bala nhäŋayana ŋunhi guṉḏaya, galiꞌŋuna gurrana djingaryuna. ");
INSERT INTO dwy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ga gulŋiyina waya ŋunhima mathirrayi ŋayŋu nhäŋayana gurrmulnha ḏarramuna girriꞌ watharrmina dhika, nhinana gurrana. Ga wirrkina waya ganyimꞌthuna. ");
INSERT INTO dwy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ga bitjana ŋayi wayaŋgu waŋana, “Yaka waya biyaṉiyi. Dhuwaya nhuma gurra Djesuwu rumbalwuna ḻarruma wäŋa-Nazareth-puyŋuwuna ŋunhi waya ŋanya buŋaya rakunyguŋaya. Ḻinyguna ŋanya ŋunhi God-Waŋarryuna walŋakuŋaya rakunyŋuya, bäyŋuna ŋayi dhuwaya. Nhäŋuna waya, dhuwayatja dharapulnha ŋunhi waya märrkitjkuŋaya nhanŋu rumbal. ");
INSERT INTO dwy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Maꞌ, roŋiyi nhuma yurru ŋayŋuyi ga ḻakama nhanukalaŋuwu ḻuṉḏuꞌmiŋuwu wayaŋgu märr waya yurru roŋiyi Galilee-yina makarryi. Ga biyaku ḻakaŋu ŋunhi ŋayiya yurru ŋäthiyina marrtji, ga ŋunhi waya yurru bunaya, ga ŋunhayana waya yurru ŋanya maḻŋꞌmamaya. Ga ḻakaŋu yana Peter-wuya. Yo, ḻinygu ŋayi Djesuyu ŋunhi ŋäthiyi ḻakaŋaya wayaŋgu,” bitjaya ŋayi gurrmulya waŋana. ");
INSERT INTO dwy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ga nhäŋaya waya ŋunhi mathirraya dharapulnha ŋayŋu walmanana mathirraŋuya, bala ganydjarryuna yana marrtjinaya. Ga yakana waya ŋula yolku yolŋuwu dhäwuꞌ ḻakaŋaya ŋula bala dhukarrkuyu bili waya ŋunhi wirrkina biyaṉiyina. ");
INSERT INTO dwy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ga Sunday-na goḏarr, djaḏawꞌyunamiyuna waluyu ŋayi Djesuya milkunhamina Mary Magdalene-gu. Ŋurikayana ŋunhi miyalkaya ŋunhi ŋayi Djesuyu dhawaṯmaŋaya ŋäthiyi seven yätj birrimbirr mala. ");
INSERT INTO dwy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ŋayŋu yana ŋayi Mary-ya marrtjinana ḻuṉḏuꞌmiŋuwuna bunana, waya marrtjina ŋäthinyamina. ");
INSERT INTO dwy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ŋayŋu ŋayi Mary-yuya wayaŋgu ḻakaŋayana bitjayana, “Wäy, Garrayya dhuwaya bulu yawungu walŋathinya, ga ḻinyguna dhuwaya ŋarraya ŋanya nhäŋayana.” Ga wayatja bitjaya waŋana bili waya märr-yuḻkthuna ŋanya, “Nhä nhina dhuwaya dhiyaŋuya ḻakama way!” ");
INSERT INTO dwy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ga bulu ŋayi Djesu milkunhamina bulalꞌwayana ḻuṉḏuꞌmiŋuwaya, ŋunhi maṉḏa marrtjina gurrana ḏiltjikuyu. Ga wiripuŋuyinana ŋayi ŋunhi rumbalya maṉḏakaya maŋutjiŋuya. Ga yurruna, maṉḏa ŋanya ŋunhi dharaŋayatja. ");
INSERT INTO dwy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ŋayŋu maṉḏa roŋiyina bala Jerusalem-dhi ga ḻakaŋaya guyurrꞌmiŋuwu wayaŋgu bitjayana, “Way, ŋäku waya! Ḻinyguna dhuwaya ŋaliya nhäŋayana ŋanya Djesuna ŋunhaya dhukarrŋuna!” Yurru wayatja ŋunhi ḻuṉḏuꞌmiŋuya waya bitjaya waŋana, “Yaka maṉḏa nyäḻꞌyuya.” ");
INSERT INTO dwy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ga dhurrwaraŋu beŋuya ŋayŋu ŋayi Djesuya ŋanyapinyawuy ŋayi milkunhamina 11-kayana guyurrꞌmiŋuwaya, waya marrtjina ŋatha ḻukana. Ŋayŋu ŋayi ŋarrtjunana wayana bitjayana, “Dhuwaya nhuma ŋayaŋu-ḏälmi yolŋu waya. Ḻinygu gurra ŋunhi yolŋuyu wayay nhumaŋgaya ḻakama ŋunhi waya ŋarrana nhäŋaya wayaŋgaya maŋutjiyu, yurru nhumaya yakana wayaŋgu märr-yuwalkthina. Ga dhuwayatja ŋarrapina nhumaŋgu bunana. Yuwalk yana ŋarra ŋunhi rakunydhinaya, ga bulu ŋarra dhuwaya walŋathina. ");
INSERT INTO dwy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Gatjuy marrtjina waya ga ḻakaŋuna latjuꞌya dhäwuꞌ ŋarrakalaŋuwuy bukmakkuna yana yolŋuwu wayaŋgu, buku-ḻiwꞌmaŋuna ŋunha nhina marrtji wäŋaŋu miṯtjiŋu. ");
INSERT INTO dwy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ga ŋunhi ŋayi yurru ŋula yol yolŋu märr-yuwalkthiya ŋarrakuya, ga buku-ḻupthunamiya rom ŋätthun, ŋayiya yurru God-Waŋarryuya wayana walŋakumana. Ga ŋunhi ŋayi yurru ŋuyulkthiya, yakaya ŋarraku yurru märr-yuwalkthi, ŋanyanaya ŋunhinaya yolŋuna yurru dhä-ḏirꞌyuna bala yurru ḏupthuna warraŋulyina djiwarrꞌŋuya. ");
INSERT INTO dwy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ga ŋunhi yurru yolŋu waya gurra märr-yuwalkthiya, waya yurru gurra djämana ŋayaŋu-ganyimꞌthunamina romdja malanynha ŋunhi yurru gurra ŋuriŋiya maŋutji-ḻakama ŋunha ŋunhina God-Waŋarrwuna ganydjarr. Ga ŋarranaya waya yurru gurra ŋunhi yäkuya bäki wakinŋumiwuna birrimbirrwu dhawaṯmanhawu. Ga waŋaya waya yurru gurra ŋunhi wiripuna mulkuruna dhäruktja. ");
INSERT INTO dwy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ga ŋuli waya yurru ŋula bäpiya mulkaꞌ, wo ḻuka waya yurru botjinꞌ, wayatja yurru ŋunhi yakana rirrikthun. Ga goŋ-ŋalꞌyun waya yurru rerrimiwaya yolŋuwaya, ga wayatja yurru ŋunhi yana walŋakumana.” ");
INSERT INTO dwy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ga ŋunhi ŋayi gurrana Djesu waŋanaya ḻuṉḏuꞌmiŋuwayatja wayaŋgaya, ga dhawarꞌyunaya, ŋayŋu ŋayi God-Waŋarryuya ŋätthunana ŋanya ŋayŋuna djiwarrꞌyina. Ga ŋunhana ŋayi yulŋuya nhinana gurra God-Waŋarrwayana dhunupamiŋuna galiꞌŋu, märr maṉḏa gurra ŋunha rrambaŋina djämaya. ");
INSERT INTO dwy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ŋayŋu wayatja ŋunhi guyurrꞌmiŋuya wayay dhäruknha ŋanya ŋätthuna. Ŋayŋu waya marrtjinana dhäwuꞌna ŋunhi Djesuwalaŋuwuynha latjuꞌna ḻakaŋaya buku-ḻiwꞌmaŋayana. Ga ŋayiya God-Waŋarryuya gurrana wekaŋaya wayaŋgu ganydjarrnha märr waya yurru gurra djämana ŋayaŋu-ganyimꞌthunamina rom, ŋunhi ŋayi Djesuyu wayaŋgu ḻakaŋaya. Ga guḻkuꞌna gurrana ŋunhi yolŋuya waya märr-yuwalkthinaya Djesuwuya, ḻinygu waya dharaŋanana ŋunhiya Latjuꞌya Dhäwuꞌ yuwalknha yana. ");
INSERT INTO dwy_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","Ga ŋunhi waya ŋunhi ḻurrkunꞌ miyalk mala marrtjina bunana Peter-wu ga guyurrꞌmiŋuwu wayaŋgu, bala waya ḻakaŋaya wayaŋgu ŋunhiyi gurrmulnhana ŋunhi ŋayi gurrana waŋana wayaŋgu ŋunhaya mathirraŋu. ");
INSERT INTO dwy_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","Ga dhurrwaraŋu beŋuya bala ŋayi Djesuya dhäruk-wekanhaminana nhanukalaŋuwu ḻuṉḏuꞌmiŋuwu wayaŋgu waya yurru ŋunhiya Latjuꞌya Dhäwuꞌ nhanukalaŋuwuy ḻakamana marrtji buku-liwꞌmamana, dhiya munathaꞌŋu wäŋaŋu. Dhiyaŋuya gurra dhäwuꞌyu ḻakama ŋunhi God-Waŋarryuya yurru walŋakumana yana yolŋuna wayana yätjŋu romŋuyu, märr waya yurru gurra nhina nhanukayana djiwarrꞌŋuna walŋa-dhawarꞌyunamiriwnha. Dhuwayatja Latjuꞌna Dhäwuꞌ yuwalknha yana. Ga dhiyakuna ŋurruwu ŋayi dhuwaya dhawarꞌyunamiriwya dhäwuꞌ. ");
INSERT INTO dwy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Djesu waŋana nhanukaya ḻundu’miŋu waya bitjana, “Dhuyu Birrimbirr yurru buna nhuŋgu ga ŋayi yurru wekama nhuŋgu ganydjarr, bala nhe yurru ḻakama ŋarrakalaŋuwuy dhiya Jerusalem ga dhiya Judea-ya wäŋaŋu ga Samaria-ya wäŋaŋu, ga nhuma yurru marrtji yolŋu waya birrka’mi waya ḻiw’mama wäŋayi.” ");
INSERT INTO dwy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ŋunhi Djesuyu ḻakaŋaya wayaŋgu, God-thuya märraŋayana ŋanya djiwarr’yina. Nhanukaya ḻundu’miŋuyu waya nhäŋaya ŋanya, ŋunhi ŋayi marrtjina garrwarthina. Beŋuya maŋandhuna ŋanya dhaḻ’yuna Djesuna, bala waya ḻundumiŋu’yu bäyŋuna buluya nhäŋaya ŋanyana. ");
INSERT INTO dwy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nhäŋaya waya weyin’nha bala gärakthina, bala beŋuya märrma ḏirramu girri’ watharrmi maṉḏa dhärrana gurruna galki wayaŋgaya. ");
INSERT INTO dwy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Maṉḏa waŋana bitjana, “Nhuma ḏirramu mala Galilee-wuy, nhäku nhuma gurra dhärra dhiyaya ga nhäma bala gäraktja? God-thuya märraŋayana Djesunaya bala djiwarr’yina, yurru ŋayi ŋuli roŋiyi lili birrka’miyu nhuma nhäŋaya ŋanya ŋayi marrtjina bala djiwarr’yina, ga biyaku bili ŋayi ŋuli roŋiyiya lili bitjana nhuma nhäŋaya ŋanya.”");
ALTER TABLE dwy_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
