﻿USE sofia;
DROP TABLE IF EXISTS sofia.dww_vpl;
CREATE TABLE dww_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dww_vpl WRITE;
INSERT INTO dww_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Keriso tauna guyau Deivid na damma nopone ya tubuḡana, be guyau Deivid tauna Eibraham na damma nopone ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Be Eibraham natunama Aisik, be Aisik natunama Jeikob. Be Jeikob natunatunama taudi Juda be tasitasinama. ");
INSERT INTO dww_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Be Juda natunatunama taudi Peres be Sera, be tinedima tauna Temar. Be Peres natunama Hesron, be Hesron natunama Ram, ");
INSERT INTO dww_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","be Ram natunama Aminadap, be Aminadap natunama Nason, be Nason natunama Salmon ");
INSERT INTO dww_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","be Salmon natunama Boas, be Boas tinanama Reiheb. Be Boas natunama Obed, be Obed tinanama Rut. Be Obed natunama Jesi. ");
INSERT INTO dww_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Be Jesi natunama guyau Deivid. Be Deivid natunama Solomon be Solomon tinanama Uria na waivima. ");
INSERT INTO dww_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Be Solomon natunama Rehoboam, be Rehoboam natunama Abaija, be Abaija natunama Asa. ");
INSERT INTO dww_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Be Asa natunama Jehosafet, be Jehosafet natunama Joram, be Joram natunama Usaia. ");
INSERT INTO dww_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Be Usaia natunama Jotam, be Jotam natunama Eihas, be Eihas natuama Hesekaia. ");
INSERT INTO dww_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Be Hesekaia natunama Manase, be Manase natunama Amon, be Amon natunama Josaia. ");
INSERT INTO dww_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Be Josaia natunama Jehoiakin be tasitasinama. Taudi adi raḡanine Israel banegidima matabudi a nawedina Babilonma be dabudine a miana. ");
INSERT INTO dww_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Be Babilon a mianana murine Jehoiakin natunama Sealtiel ya tubuḡana. Be Sealtiel natunama Serubabel. ");
INSERT INTO dww_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Be Serubabel natunama Abiut, be Abiut natunama Elaiakim, be Elaiakim natunama Asor. ");
INSERT INTO dww_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Be Asor natunama Sadok, be Sadok natunama Akim, be Akim natunama Eliut. ");
INSERT INTO dww_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Be Eliut natunama Eleasar, be Eleasar natunama Matan, be Matan natunama Jeikob. ");
INSERT INTO dww_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Be Jeikob natunama Jousep. Be Jousep tauna Meri na badama. Be Meri, tauna vutuna Yesu Tauwai yawasana ya tikana. ");
INSERT INTO dww_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yodi tà kita da Eibraham ḡarone be ya naḡo da guyau Deivid ḡarone ya tavana, kimta matabudi 14. Be guyau Deivid ḡarone da ya naḡo da Babilon na raḡanie ya tavana, kimta matabudi 14. Be Babilonma raḡanine be ya naḡo da Keriso na raḡanie ya tavana, kimta matabudi 14. ");
INSERT INTO dww_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keriso muriḡa da ya tubuḡana noḡone, kaua umanama ya tubuḡana, Yesu tinanama Meri tauna Jousep na ḡoapaparama. Taudi muriḡa da sibo ai naḡi be ai rawateḡeina, Meri mayanama ya paḡo da kaiteka ya bogana Arua Babaue. ");
INSERT INTO dww_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Be Meri na badama Jousep tauna didimana baneginama. Vutuna aubainama raḡanine kaua nama ya kitakitana tauna nam i ḡoeḡoena da patara matedie sibo Meri ya gose be ya kawa tunimayaḡi. Vutuna aubainama tauna ya ḡoeḡoena da moisirie sibo Meri ya gosena. ");
INSERT INTO dww_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jousep inam kauidima yawai nuanoḡonoḡotedina maika, Bada na aneama raubonie Jousep ḡarone ya maḡatara be ya riuna, “Jousep, guyau Deivid natunama, nam kwa naira, Meri kwa paḡo da tam am waivima be nam kwa gose pore, baninama Meri Arua Babau na rewapanae gomana ya bogena. ");
INSERT INTO dww_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tauna tokare gomana tauḡominama e tika be tam kwai isana Yesu, baninama tauna tokare na banagama adi gewagewae ei yawasanidina.” ");
INSERT INTO dww_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Uma kauidima matabudi Bada boni peroveta ḡarone ya giugiuena ruvane, nama a tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Peroveta boni umanama ya riuna, “Tokare Matatapu e boga be gomana tauḡominama e tikana, be taudi inam gomeninama tai isana Imanuel.” Isa Imanuel inam baninama “Mamaitua tauda ḡarode.” ");
INSERT INTO dww_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jousep ya kenakena midisuḡuna murine, aba Bada na aneama ya riuriuena nama ya voiena, tauna Meri ya paḡo da naumeki na waivima. ");
INSERT INTO dww_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Be Jousep Meri mate nam tunidima ti rawateḡei rubudina naumeki da Meri gomana tauḡomina ya tikana. Dabudine Jousep inam gomeninama yai isana “Yesu”. ");
INSERT INTO dww_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Guyau Herod na raḡanie, Yesu Judia nopone Betliem meagaine ya tubutubuḡana murine, nuauyauya banegidima suara na kaba tavama yauwane nama be a verauna Jerusalemma. ");
INSERT INTO dww_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Be taudi guyau ai taravirena, “Gomana ḡaubonama deḡo dobudine ya tubuḡa, Jius adi guyauma? Tauma suara na kaba tavae gomana na kiporama kè kita be kè verauna rauduneenama aubainama.” ");
INSERT INTO dww_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Raḡanine guyau Herod inam giunama nama ya vaivaiena, nuanama ya rovona. Be banaga matabudi Jerusalem nopone, taudi mate nuedima ya rovona. ");
INSERT INTO dww_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Inam raḡanine tauna pirisi babadidima be tarawatu tauwai katakataidima matabudi ya rawateḡeidina be, Tauwai yawasana deḡo dabudine e tubuḡana vutuna yai taraviredina. ");
INSERT INTO dww_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Be taudi a paribee be a riuna, “Tauwai yawasana tokare Judia nopone Betliem meagaine e tubuḡana, baninama peroveta ya giruma be umanama ya riuna, ");
INSERT INTO dww_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Tam Betliem Judia provins nopone, tam nam meagai yababa Judia guyaguyaudima ḡarodie. Ibewa, baninama tam nopome tokare guyau dosinama e tubuḡa be tauna yau banagama Israel banegidima e rabedina.’” ");
INSERT INTO dww_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dabudine Herod nuauyauya banegidima moisirie ya rawateḡeidi be yai taravira yaḡeyaḡedina da taudi aba raḡanine kipora ya maḡatara be a kita. ");
INSERT INTO dww_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Naumeki da guyau nuauyauya banegidima ya riupore nawedi Betliemma be umanama ya riuedina, “Koi wanawana kaua da inam gomeninama ko banavina. Be gomeninama ko kitana raḡanine, ko verau munaḡa da taugu ko riuegu be taugu mate yà naḡo da gomeninama yà rauduneena.” ");
INSERT INTO dww_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Naumeki da guyau na giuma a vaie ya kovikovina murine, taudi naḡo ai karena. Be kiporinama a kitakitana vutuna a kita watani be a vawatanina, naumeki da deḡo gomana ya tubutubuḡana debane kipora ya midi kwasana. ");
INSERT INTO dww_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Be taudi nama a kitakitana, taudi ai nuavere kauana. ");
INSERT INTO dww_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Raḡanine vadae a tavatavana, taudi gomana a kitana, tinanama Meri mate. Naumeki da taudi tuapikedie a raupari be gomana a rauduneena. Dabudine taudi adi puyoma a kaiporaḡa be gomana a puyona, gold, piupiu be kai bodinama ḡabuḡabunama maesinama dosinama isanama ‘Mera’. ");
INSERT INTO dww_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Inam kauinama murine Mamaitua raubonie nuauyauya banegidima nuedima ya boru be ya riuedina da nam sibo a munaḡa Herod ḡarone. Vutuna aubainama taudi wari keda a paḡo da a munaḡana adi dobue. ");
INSERT INTO dww_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nuauyauya banegidima a naḡonaḡona muridie, Bada na aneama Jousep ḡarone raubonie ya maḡatara be umanama ya riuena, “Kwa midisuḡu, gomana kwa tika be tinanama mate naira ko naḡona Ijiptma. Be dobudine ko miana naumeki da taugu yà riuem da ko verau munaḡana, baninama guyau Herod tauna gomana e wanewanena ei gurina aubainama.” ");
INSERT INTO dww_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Naumeki da Jousep ya midisuḡu, da gomana ya tika be tinanama mate yai dokedi da kupie meagai a gose da a naḡona Ijiptma. ");
INSERT INTO dww_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Be taudi Ijiptma a miana naumeki da Herod e gurina. Uma kauidima inam peroveta aba boni yawai perovetaena nama yodi a tubuḡana. Peroveta umanama ya riuna, “Natuguma Ijiptma ya miamiana be è riue da ya dobina.” ");
INSERT INTO dww_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Be raḡanine guyau Herod ya kita da nuauyauya banegidima tauna ḡarone nam ti tava munaḡana, vutuna aubainama tauna nuanama yai medi kauana. Inam raḡanine tauna nuauyauya banegidima aba a giugiuena ya noḡota wairuvedi be na tauiḡarama ya riuporedi be ya riuna, “Ko naḡo Betliem meagaine, be diane meagaidima mate nopodie be seda tautauḡomidima adi suarama rabui be uma ya yovo munaḡana matabudi koi guri rovodina.” Tauna nuauyauya banegidima adi giuma ya noḡota wairuvedi be nama ya giuna. ");
INSERT INTO dww_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Be inam peroveta Jeremaia boni aba ya giugiuena nama ya tubuḡana. Tauna umanama ya riuna, ");
INSERT INTO dww_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Banaga ḡaba be nuaboya dosinama a vaiena Rama meagainama nopone. Reichel na sedama ya ḡabeḡabedina, be taudi nam teneteneḡina da sibo a riuwai nuasubasuba, baninama na sedama matabudi a guri rovona.” ");
INSERT INTO dww_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Raḡanine Herod ya gurigurina murine, Bada na aneama raubonie Jousep ḡarone Ijiptma ya maḡatara ");
INSERT INTO dww_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","be umanama ya riuena, “Kwa midisuḡu, gomana be tinanama mate kwai dokedi be ko munaḡana Israelma. Baninama taudi aitauḡa gomana waigurinama a riuriuena, inam banegidima yodi a gurina.” ");
INSERT INTO dww_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Naumeki da Jousep ya midisuḡu be gomana be tinanama mate yai dokedi be a munaḡana Israelma. ");
INSERT INTO dww_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Be tauna e vaiena, be Herod natunama Arikelas tamanama gabunama ya paḡo be Judia provins nopone yai badana. Vutuna aubainama Jousep dabudi naḡonama ya nairana. Be anea raubonie Jousep ya riue be tauna ya naḡona Galili provins nopone. ");
INSERT INTO dww_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naumeki da taudi a naḡona Nasaret meagaine be dabudine a miana. Be inam aba peroperoveta boni a giugiuena nama ya tubuḡana. Peroperoveta umanama a riuna: “Banaga tokare Yesu tai isana Nasaret baneginama.” ");
INSERT INTO dww_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Inam raḡandie Jon tauwai babataito Judia provins nopone ya tava be dobu kavakavane ya rarau guguyana. ");
INSERT INTO dww_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Be tauna umanama ya riuriuna, “Noḡota vitara ko paḡo be ami noḡotama ko vitaredina, baninama Mamaitua na waiguyauma kaiteka maida e tavatavana.” ");
INSERT INTO dww_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon tauwai babataito tauna vutuna peroveta Aisaia ya giugiuena. Aisaia umanama ya riuna, “Banaga dobu kavakavane e yokoyokona, Bada na kedama ko sepa, be keda ko kawa didimanidina na kaba verauma aubainama.” ");
INSERT INTO dww_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon na garama kamel vuvuḡinama voivoienama ya kotekotena. Be musara kopinama kwarikwarinama yai boretaiena, be tauna na kanima inam kapau be iwavi. ");
INSERT INTO dww_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Banaga toitoi Jerusalemḡa, Judia provinsne be upa Jodan banegidima matabudi Jon ḡarone a tavana. ");
INSERT INTO dww_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dabudine taudi adi gewagewama matabudi a kuvesidi be tauna yai babataitodina upa Jodan nopone. ");
INSERT INTO dww_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Raḡanine tauna e kitana be Parisi be Sadisi banegidima toitoi a veraverauna ḡarone deḡo banaga yawai babataitodie, dabudi Jon taudi umanama ya riuedina, “Taumi maika mota sarama natunatudima! Taumi aitau ya riuemi da tokare Mamaitua na kovoḡama ko vora pore? ");
INSERT INTO dww_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ami yawasanama ko vitaredi be yawasana veredima banidima koi maḡataridi da banaga ta kitedina, ");
INSERT INTO dww_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","be nam ko noḡoti be ko riuna, ‘Tauda Eibraham natunatunama, aubainama nam tokare aba gewagewanama ḡarode e tubuḡa.’ Yà riuriuemina, deḡoda Mamaitua sibo i ḡoena, tauna tokare teneteneḡinama kaua yekudie seda yai tubuḡidina Eibraham aubainama. ");
INSERT INTO dww_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bada tamiyoko kaite kai bogane ya boruna, be deḡo kaidima banidima nam veredi, matabudi tokare e taraḡa be e gabu gorudina. ");
INSERT INTO dww_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Taugu upa kavakavae yàwai babataitomina, ami noḡotama ko vitaredina aubainama. Be banaga murigue e veraverauna, tauna banaga wairewapana vavasaḡinama nam maika taugu. Be taugu nam veregu da na kaḡasumama yà ragaudi. Tauna tokare Arua Babaue be kaie ei babataitomina. ");
INSERT INTO dww_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tauna banaga veredi be gewegewedima e daridariḡedina maika raisi. Tauna raisi e tutu, be sive nopone e ḡini be sive mui e suve da ḡavoe e naḡonaḡona, be banidima ḡavoe ta dobidobina. Be tauna raisi banidima e ragaudi be na vadae e biribiridina. Be muinama kai karakaratine ei poraḡa be ta kara nonoḡedina.” ");
INSERT INTO dww_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naumeki da Yesu Galilima be ya verauna upa Jodanma, da Jon sibo tauna yai babataitona. ");
INSERT INTO dww_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Be Jon ya riutuaḡaie be ya riuna, “Tam aba aubainama taugu ḡarogue kuya verau? Tam sibo taugu kuyai babataitoguna.” ");
INSERT INTO dww_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Be Yesu ya paribee be ya riuna, “Ibewa, inam naumeki. Uma inam Mamaitua na ḡoanama naumeki da tà voiena.” Inam raḡanine Jon yai aninana. ");
INSERT INTO dww_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Naumeki da Yesu ya babataito ya kovi da tauna upae be ya tavatavana raḡanine, mara ya nuaporaḡa be tauna Arua Babau ya kitana ya yovoyovona ḡarone kiu gabubu maika. ");
INSERT INTO dww_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Be marae bona yadobi be ya riuna, “Inam tauna taugu natuguma nuaguma e paḡopaḡona, be taugu yàwai nuaverena tauna ḡarone.” ");
INSERT INTO dww_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Dabudine Arua Babau Yesu yai doka nawena dobu kavakavane da Diaboro sibo Yesu ya raurubuna. ");
INSERT INTO dww_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu dabudine ya widinana, kupi da suara raḡan 40 a kovikovina, murine tauna kani ya kara kauena. ");
INSERT INTO dww_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Inam raḡanine tauraurubu Yesu ḡarone ya tava be ya riuna, “Deḡoda tam Mamaitua Natunama, naumeki da uma yekudima kwa riuedi da tai rawaburedi.” ");
INSERT INTO dww_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Be Yesu ya paribee be ya riuna, “Girugiruminama porane girugiruminama umanama ya riuna, ‘Banaga nam tokare burediḡa na yawasanae tà mia, ibewa da Mamaitua riunama matabuna na yawasanae tà miana.’” ");
INSERT INTO dww_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dabudine Diaboro Yesu yai doka nawena Jerusalemma meagai babaune be Tempol debane a midi be ya riuena, ");
INSERT INTO dww_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Deḡoda tam Mamaitua Natunama, naumeki da uma dobudine kwa kuruva, baninama Girugiruminama porane girugiruminama umanama ya riuna, ‘Mamaitua na aneama e riuporedi da tam ta rabemna. Be nimedie ta kaisuḡum da nam yekue kaḡamma kwai riḡedi.’” ");
INSERT INTO dww_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Be Yesu ya paribee be ya riuna, “Be girugiruminama porane girugiruminama mate umanama ya riuna, ‘Bada, am Mamaituama nam kwa raurubu.’” ");
INSERT INTO dww_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dabudine Diaboro Yesu yai doka nawena oya daudau kwatikwatinama debane, be dobu na waiguyauma waimata veraveraudima matabudi Yesu yai katai ");
INSERT INTO dww_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","be ya riuna, “Deḡoda tam kwa rauduneeguna, uma yabedima matabudi tam yà utemna.” ");
INSERT INTO dww_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Be Yesu ya paribee be ya riuna, “Kwa naḡo ḡavoe, Seitan. Baninama girugiruminama porane girugiruminama umanama ya riuna, ‘Bada, am Mamaituama taunaḡa kwa raudunee be ḡarone kwa noyana.’” ");
INSERT INTO dww_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dabudine Diaboro Yesu ya gose be anea a dobi da Yesu a saguna. ");
INSERT INTO dww_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Raḡanine Jon dibure a boru be varinama Yesu ya vaivaiena, tauna ya munaḡana Galilima. ");
INSERT INTO dww_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naumeki da tauna Nasaret ya gose be ya naḡona Kapeniamma ya miana. Kapeniam inam yawawa dosinama diane, dobu Sebulun be Naptali nopodie. ");
INSERT INTO dww_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Uma kauinama peroveta Aisaia aba ya riuriuena, nama ya tubuḡana. Tauna umanama ya riuna, ");
INSERT INTO dww_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Dobu Sebulun be Naptali yawawa diane, upa Jodan murine. Tam dobumma tawai isamna Galili, be inam dabudi banaga ta miamiana taudi eteni, nam Jius. ");
INSERT INTO dww_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Banaga aitauḡa kupie a miamiana, taudi yana dosinama a kitana. Taudi aitauḡa guri na waikupikupie a miamiana, yodi yana raḡan maika e senesenerina a kitana.” ");
INSERT INTO dww_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Inam raḡanine be nokoi ya naḡona Yesu rauguguya yai kare be ya riuna, “Noḡota vitara ko paḡo be ami noḡotama ko vitaredi, baninama Mamaitua na waiguyauma kaiteka maida e tavatavana.” ");
INSERT INTO dww_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu Galili yawawinama dianaḡa ya naḡonaḡo raḡanine, tauna tautauḡoma rabui ya kitedina, Saemon awai isana Pita be tasinama Endru. Taudi tauwai sagida, aubainama adi sagidama topae a poraporaḡana iyana vunuḡidima aubainama. ");
INSERT INTO dww_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Dabudine Yesu ya riuedina, “Ko verau koi muriwatanegu be taugu yà voiemi da taumi banaga ko konedina.” ");
INSERT INTO dww_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Inam raḡanine taudi waiḡapa adi sagidama a gosaḡa be Yesu ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Naumeki da naḡo yai kare munaḡe be ya naḡonaḡo da tautauḡoma ḡesaudima rabui ya kitedina, Jeims be tasinama Jon taudi Sebedi natunatunama. Taudi wagae a miamiana tamedima Sebedi mate be adi sagidama a kawakawa batebatedina. Be Yesu taudi ya riuedina, “Ko verau be koi muriwatanegu.” ");
INSERT INTO dww_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Inam raḡanine taudi waiḡapa waga be tamedima a gosedi be Yesu ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili noponaḡa ya babara naḡo be sinagog nopodiḡa yawai katakatai, be Mamaitua na waiguyauma varinama verenama ya rarau guguyena. Be tauna banaga adi sidama tabu be tabu a ragaragaudina yawai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Be Yesu varinama Siria nopone ya daberara be banaga adi sidama tabu be tabu a verauḡedina Yesu ḡarone. Banaga ḡesaudima muya dosidima ragaragaudima, ḡesaudima penama kokukokudima be banaga ḡaḡarua kokukokudima, be ḡesaudima tuera ragaragaudima, matabudi yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Be patara dosinama Galiliḡa veraveraudima, Dekapolisḡa, Jerusalemḡa, Judiaḡa be upa Jodanma noaḡo nevane dobunama banegidima mate Yesu awai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Raḡanine Yesu patara nama ya kitakitana, tauna ya saḡa ya naḡona oya debane be ya miana. Dabudine na tauwai muriwatanama ḡarone a tava ");
INSERT INTO dww_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","be Yesu patara waikatakataidima yai kare be ya riuna, ");
INSERT INTO dww_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Taumi nuemima e verena, aitauḡa nuemima tabutabune Mamaitua na saguma ko ḡoeḡoena, baninama taumi tokare Mamaitua na waiguyauma ko paḡona. ");
INSERT INTO dww_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Taumi nuemima e verena, aitauḡa ami gewagewama aubaidima ko ḡabaḡabana, baninama taumi tokare Mamaitua ei nuasubemina. ");
INSERT INTO dww_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Taumi nuemima e verena, aitauḡa voyaḡota banegimima, baninama taumi tokare dobu matabuna koi buderiena. ");
INSERT INTO dww_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Taumi nuemima e verena, aitauḡa Mamaitua matane didimana ko ḡoeḡoe be ko wanewane guratena, baninama taumi tokare ami ḡoanama Mamaitua e utemina. ");
INSERT INTO dww_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Taumi nuemima e verena, aitauḡa banaga taurau nuatoiedima, baninama taumi tokare Mamaitua e raunuatoiemina. ");
INSERT INTO dww_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Taumi nuemima e verena, aitauḡa nopomima didimanidima be nam mira mate, baninama taumi tokare Mamaitua ko kitana. ");
INSERT INTO dww_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Taumi nuemima e verena, aitauḡa suba tauvoienama, baninama taumi tokare Mamaitua ei kawa natunemina. ");
INSERT INTO dww_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Taumi nuemima e verena, aitauḡa banaga ta raraukivi gewegewemina ami yawasana didimanidima aubaidima, baninama taumi tokare Mamaitua na waiguyauma ko paḡona. ");
INSERT INTO dww_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Taumi nuemima e verena, deḡoda banaga ta kunuremi, ta raraukivi gewegewemi be giu tabu be tabu kaikaiyovudie tai wavumina, baninama taumi taugu kowai muriwataneguna aubainama. ");
INSERT INTO dww_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Raḡanine inam kauidima nama ḡaromie ta tubutubuḡana, taumi koi nuavere be ko taukaina, baninama ami maesama dosinama marae e kenakenana. Banaga ḡesaudima boni peroveta ḡarodie inam kauidima teneḡidima nama a voivoiedina. ");
INSERT INTO dww_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Banaga adi butama inam taumi. Be deḡoda buta dininama e gewagewana, nema kwa voia bake da e dini munaḡa? Inam butanama kaite ya gewagewana, be banaga tokare inam butanama ta porekaiyati be ta vagudagudana. ");
INSERT INTO dww_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Banaga adi kodamma inam taumi. Be uma ko noḡoti, meagai oya debane nam ei moisiri be teneteneḡina, ");
INSERT INTO dww_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","be banaga nam kodam ei rageti be gurewa dibune e boru ibewa, tauna kodam ḡavoe e boru da vada nopone banaga matabudi ei yanedina. ");
INSERT INTO dww_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Inam kauinama teneḡinama nama, taumi banaga ḡarodie nama sibo koya yanana. Inam raḡanine taudi ami voiama veredima ta kitedi, be Tamemima marae isanama ta kawa saḡena. ");
INSERT INTO dww_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Taugu è verauna nam ko noḡoti da Mousis na tarawatuma be peroveta adi waikatakataima yà kawa gewegewedi, ibewa. Taugu nam yabedima kawa gewegewedima aubaidima è verauna, ibewa. Taugu è verauna tarawatu banidima yai maḡataridina aubainama. ");
INSERT INTO dww_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yà riuriu kauemina da nam ai tarawatu tenaḡa maika e samoa yababa, ibewa da noḡone tarawatu aba ya giugiuedina, matabudi ta tubuḡana. Yodibe mara be dobu ta samoana. ");
INSERT INTO dww_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tam aitau deḡoda tarawatu avedi da ḡaubo kokonama kwa kita tuatuaḡaie be kwawai kati kotovina, be inam kedane nama am banagama kwawai katakataidina, tam tokare Mamaitua na waiguyauma nopone ta kita poremna. Be tam aitau tarawatu kwa voteyeteyedi be inam kedane nama banaga kwawai katakataidina, tam tokare Mamaitua na waiguyauma nopone ta kita saḡemna. ");
INSERT INTO dww_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Be yà riuriuemina, ami yawasanama Mamaitua matane ko kawa didimana kauedina, be taumi nam Parisi be tarawatu tauwai katakataidima maika ko voia. Taudi adi yawasanama tà kitekitedina da kabe banaga veredi be nopodima gewagewa ya moḡavu. Deḡoda taudi maika ko voiana, taumi tokare nam Mamaitua na waiguyauma nopone ko saḡa. ");
INSERT INTO dww_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Taumi koya vaie da boni Mamaitua ya riuna, ‘Nam kwa rauvunuḡa. Be aitau da banaga ei gurina, tauna tokare ta etarena.’ ");
INSERT INTO dww_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Be taugu yodi yà riuriuemina da tam aitau turamma ḡarone nuama ei medina tam tokare ta etaremna. Be tam aitau da turamma kuya riuwai gewana tam tokare etara dosine kwa midina. Be deḡoda tam aitau turamma kuyai tara tautauena, tam inam gienae kai matane naḡonama kwawai rabena. ");
INSERT INTO dww_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Vutuna aubainama tam deḡoda am puyoma oltae kuya verauḡena Mamaitua puyonama aubainama, be dabudine kuya noḡoti da turamma mate poumie gewagewa e kenakenana, ");
INSERT INTO dww_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","naumeki da am puyoma olta diane kwa gose, be kwa munaḡa da noḡone turamma mate inam gewagewanama ko kawa didimani dokena. Yodibe kwa verau munaḡa da am puyoma Mamaitua kwa utena. ");
INSERT INTO dww_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Deḡoda banaga aitau tam e nawemna etara aubainama, naumeki da kedae dabudine am gewagewama kwa kawa didimana makaiena, da nam etara tauwai badenama nimane e borum. Baninama etara tauwai badenama tauna tokare porisiman nimane e borum be porisiman tauna tokare e nawemna dibure. ");
INSERT INTO dww_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Be yà riuriu kauemna da tam dibure kwa miana, naumeki da mane damodamonama kwai maesa ḡavutina. ");
INSERT INTO dww_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Taumi koya vaie da boni Mamaitua ya riuna, ‘Nam monaḡemma debane mui kwa pore.’ ");
INSERT INTO dww_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Be taugu yodi yà riuriuemina, tam aitau da aba waivinama kuya kita waidinidinina, tam inam kaite nuamma nopone gewagewa kwa voivoiena, be monaḡemma debane mui kwa poreporena. ");
INSERT INTO dww_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Deḡoda matamma kasaunama e kauem da gewagewa kwa voivoiena, naumeki da kwa kunavai be kwa porekaiyatina. Verenama da matamma tenaḡa mate mara nopone kwa saḡana, be nam matamma rabui mate, da Mamaitua gienae e pore nawemna. ");
INSERT INTO dww_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Be deḡoda nimamma kasaunama e kauem da gewagewa kwa voiena, naumeki da kwa tom pore be kwa porekaiyatina. Verenama da nimamma tenaḡa mate mara nopone kwa saḡana, be nam nimamma rabui mate, da Mamaitua gienae e pore nawemna. ");
INSERT INTO dww_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Taumi koya vaie da boni Mamaitua ya riuna, ‘Aitau na visarama gosenama e ḡoena, naumeki da tauna waigosaḡa pepanama na visarama sibo ya utena.’ ");
INSERT INTO dww_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Be taugu yodi yà riuriuemina deḡoda tam aitau am visarama kwa gose yababena, avedi da tauna nam ai tauḡoma mate gewagewa ti voiena, tam inam am visarama kwa voivoiena da tauna tokare gewagewa ei tubuḡi, be tam debame mui e porena. Be tam aitau da inam waivinama gosegosenama kwa naḡina, tam inam kwa rarau waivina. ");
INSERT INTO dww_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Be mate koya vaie da boni Mamaitua ya riuna, ‘Deḡoda Bada isane kuya sauga wapana, naumeki da kwa voiena.’ ");
INSERT INTO dww_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Be taugu yodi yà riuriuemina, nam aiyaba isane ko sauga wapa. Nam mara isane, baninama inam Mamaitua na kaba miama, ");
INSERT INTO dww_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","be nam dobu isane, baninama inam Mamaitua na kaba waivutuḡama, be nam Jerusalem isane, baninama inam guyau dosinama na meagaima. ");
INSERT INTO dww_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Be mate nam iwakidumie ko sauga wapa, baninama tam nam teneteneḡina da deba vuvuḡimma kwa kawa duba bo kwa kawa yaguni. ");
INSERT INTO dww_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Vutuna aubainama tam deḡoda waianina, naumeki da kwai anina ḡomana. Be tam deḡoda tuaḡai, naumeki da kwa tuaḡai ḡomana. Be deḡoda giu ḡesaudima nama kitedima mate kwa vatodina, inam gewagewa baninama inam Seitan na voiama nama. ");
INSERT INTO dww_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Taumi koya vaie da boni Mamaitua ya riuna, ‘Deḡoda turamma matamma e kunavaina, naumeki da tam mate tauna matanama kwa kunavaina. Be turamma mokamma ei mia kotovina, naumeki da tam mate tauna mokanama kwai mia kotovina.’ ");
INSERT INTO dww_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Be taugu yodi yà riuriuemina, gewagewa baneginama aba ḡarome ya voia waigewana, nam kwai ḡare. Deḡoda aitau nevakaumma e riḡana, kwa gose da nevakauma ḡesaunama mate e riḡana. ");
INSERT INTO dww_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Deḡoda aitau e etaetarem be am kwamama e paḡona, naumeki da am rupuma mate kwa utena! ");
INSERT INTO dww_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Deḡoda aitau e segerim da na taragaima sibo kuya kiroḡa da koya naḡo deḡo parata ya boruborue sibo kuya tavana, be tam inam paratinama ya boruboruna, kwai muri be tauna mate ko naḡo be wari madanie kwa gosena. ");
INSERT INTO dww_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aitau aiyaba ḡarome ei baḡena, naumeki da kwa utena be nam kwa riutuaḡaie. ");
INSERT INTO dww_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Taumi koya vaie da boni Mamaitua ya riuna, ‘Turamma turamma nuamma e paḡona.’ Be banaga ḡesaudima a riuriuna, am ḡaviama kwa tuaḡaiena. ");
INSERT INTO dww_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Be taugu yodi yà riuriuemina da ami ḡaviama mate nuemima e paḡona, be aitauḡa ta raraukivi gewegewemina aubaidima ko moiragina, ");
INSERT INTO dww_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","inam kedane taumi riukaua Tamemima marae natunatunama. Baninama tauna suara be kusana e riuriupore yovoḡena banaga veredi be gewegewedima matabudi aubaidima. ");
INSERT INTO dww_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Deḡoda taumi aitauḡa tawai nuapaḡoemina taudiḡa koi nuapaḡoedina, tokare maesa ko banavi, bo? Ibewa, inam damone nam aba. Baninama gewagewa banegidima taudi mate nama ta voivoiana. ");
INSERT INTO dww_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Be deḡoda am damma banegidima taudiḡa kwai kaiwedina, inam kwa voivoiena na verema aba? Banaga nam waisumeḡidi mate nama ta voivoiana. ");
INSERT INTO dww_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Taumi ami yawasanama verene be didimanine ko miana maika tamemima marae. ");
INSERT INTO dww_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ko kita kaua da voia veredima ko voivoiedina, nam patara matedie ko voiedi da taudi sibo a kitemi. Deḡoda nama ko voiana, tokare nam maesa tamemima marae ḡarone ko paḡo. ");
INSERT INTO dww_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Vutuna aubainama deḡoda waikaruwaḡawaḡa baneginama ko pairuena, nam bogigi ko suve da banaga ta kataie be isamma ta kawa saḡe. Inam banaga kaikaiyovudima adi voiama, taudi sinagog nopodie be doḡae patara matedie nama ta voivoiana. Taugu yà riu kauemina da inam nama banegidima taudi adi maesama naumeki ta paḡopaḡona. ");
INSERT INTO dww_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Be tam deḡoda banaga waikaruwaḡawaḡanama kwa paipairuena, naumeki da nam aitau diame e kataie. ");
INSERT INTO dww_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Be am pairuma moisirie kwa voiena. Inam raḡanine Tamamma marae e kitam da tam aba moisirie kwa voivoiena, naumeki da tauna tokare am maesama e utemna. ");
INSERT INTO dww_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Raḡanine kwa moimoiragina, nam banaga kaikaiyovudima maika kwa moiragi, baninama taudi adi ḡoana kauama inam sinagog nopodie ta midi bo keda poudie deḡo banaga toitoi adi kaba babare, dabudine ta midi be ta moimoiragina da banaga kabe ta kitedi. Taugu yà riu kauemina da inam nama banegidima taudi adi maesama naumeki ta paḡopaḡona. ");
INSERT INTO dww_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Be tam raḡanine moiragi kwa ḡoena, naumeki da kwa naḡo am vadae, matakeda kwa gudu be Tamamma Mamaitua miamia moisirinama ḡarone kwa moiragina. Inam raḡanine Tamamma Mamaitua aba moisirie kwa voivoiena e kitana, be tauna tokare am maesama e utemna. ");
INSERT INTO dww_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Be ko moimoiragina raḡanine, nam giu kavekavedie ami moiragima debane koi poto yababedi, banaga nam waisumeḡidima adi voiama maika. Taudi tawai noḡotana da kabe adi moiragie giu tai potodi be Mamaitua adi moiragima kabe e paḡo. ");
INSERT INTO dww_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nam inam banegidima maika ko voia, baninama taumi Tamemima Mamaitua ami ḡoanama kaite ya katai dokedina, muriḡa da kowai baḡana. ");
INSERT INTO dww_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Taumi sibo umanama koya moiragina: Tamamaima marae miemienimma, dobu matabuna isamma babaunama sibo a vivirena. ");
INSERT INTO dww_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tam am waibadama sibo ya verau. Be kwa sagumai da am ḡoanama dobue ka voie, maika marae ta voivoiana nama. ");
INSERT INTO dww_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ama kanima raḡan patapatanama sibo kuya utemai. ");
INSERT INTO dww_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Be ama gewagewama kwa noḡota poredi, nema tauma ama banagama adi gewagewama kè noḡota poredina nama. ");
INSERT INTO dww_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Be nam raurubue kwai dokemai. Tauma gewagewa nopone be tam kwai yawasanimaina. ");
INSERT INTO dww_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Be deḡoda taumi ami banagama adi gewagewama ko noḡota poredina, naumeki da Tamemima marae taumi mate ami gewagewama e noḡota poredina. ");
INSERT INTO dww_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Be deḡoda taumi ami banagama adi gewagewama nam ko noḡota poredi, naumeki da Tamemima marae mate ami gewagewama nam e noḡota poredi. ");
INSERT INTO dww_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Raḡanine ko widiwidinana, nam banaga kaikaiyovudima maika ami widinama patare koi maḡataridi da banaga ta kitemi da taumi ko widiwidinana. Taudi ta raugari be ta midimidi naḡona kabe banaga ta kitedi. Taugu yà riuriu kauemina da inam nama banegidima taudi adi maesama naumeki ta paḡopaḡona. ");
INSERT INTO dww_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Be taumi ko widiwidinana raḡanine, ko sigu be noḡomima ko buyodi ");
INSERT INTO dww_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","be ko voie da banaga matedie taumi kabe nam ko widiwidina. Be Tamemima miamia moisirinama taunaḡa e kitemi da taumi ko widiwidinana. Inam raḡanine Tamemima Mamaitua aba moisirie ko voivoiena e kitana, be tauna tokare ami maesama e utemina. ");
INSERT INTO dww_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nam ami taragaima dobue kowai damdi, baninama deḡoda kwarikwari ta kanidi, bo ta raubusabusaḡa bo banaga vadae ta sonaḡa ta saḡa be ta danenedina. ");
INSERT INTO dww_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vutuna aubainama marae koi taragaina, baninama inam dabudine tokare nam ami taragaima kwarikwari ta kanidi bo ta raubusabusaḡa bo banaga vadae ta sonaḡa ta saḡa be ta danenedi. ");
INSERT INTO dww_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Baninama ami taragaima deḡo dabudine ta kenakenana, taumi tokare ami noḡota be nuemima tabutabunama dabudine e kenana. ");
INSERT INTO dww_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Matamma inam tunimma na kodamma. Deḡoda matamma verenama, naumeki tunimma matabuna yanayananama. ");
INSERT INTO dww_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Be deḡoda matamma e gewagewana, naumeki da tunimma matabuna ei kupikupina. Be deḡoda yana nopome ei kupikupina, o ebom, inam tadiwanawana ya moraba kauana. ");
INSERT INTO dww_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nam aitau babada rabui ḡarodie ei yaraga. Deḡoda nama e voiana, naumeki da noḡone badanama e tuaḡaie be muriḡa badanama e ḡoena; bo noḡone badanama e ḡoe be muriḡa badanama e tuaḡaiena. Taumi nam mane be Mamaitua ḡarodie koi yaraga be teneteneḡina, ibewa! ");
INSERT INTO dww_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Taugu yà riuriuemina da yawasana tubuḡe aubainama nam koi nuaboya da aba sibo koya kani bo koya tego. Be nam koi nuaboya da aba sibo koya kote tunimima aubainama. Baninama yawasana noḡotinama ya moraba vavasaḡana, nam maika kani. Be tunimima noḡotinama ya moraba vavasaḡana, nam maika gara. ");
INSERT INTO dww_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kiu gunume ta rovorovona ko noḡotidi! Taudi nam tima sipisipina, be nam kani timawai damna. Be yaḡoro tamemima marae ewai kanidina. Be taumi noḡotimima ya moraba vavasaḡana, nam maika kiu. ");
INSERT INTO dww_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Taumi inam yabedima kowai nuaboyedina, tokare tai yawasanimi, bo? ");
INSERT INTO dww_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Aba aubainama gara kowai nuaboyedi? Nanari ko kitedi dobire ta gogogogona. Taudi nam tima noyanoyana, be gara nam tima voivoiedina. ");
INSERT INTO dww_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Be taugu yà riuriuemina, avedi da guyau Solomon na garama veredima waimatakanikanidima, be nam ai gara tenaḡa i vere vavasaḡana maika nanari. ");
INSERT INTO dww_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mamaitua berana e voiedi be ta busobusona kitedima a vere kauana. Be inam beranidima pomai tokare kai e kara gorudina. Be taumi noḡotimima inam ya moraba kauana Mamaitua ḡarone, nam maika berana. Vutuna aubainama Mamaitua tokare teneteneḡinama ei garemina, be taumi naumeki da koi sumaḡana be nam ami noḡotama e vobekubeku. ");
INSERT INTO dww_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Be nam koi nuaboya be ko riuna, ‘Aiyaba tà kani?’, bo ‘Aiyaba tà tego?’, bo ‘Aiyaba tà kote?’ ");
INSERT INTO dww_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Banaga nam waisumeḡidi taudi inam yabedima tawai nuaboya kauedina. Be taumi Tamemima marae ya kataie da inam yabedima ko ḡoeḡoedina. ");
INSERT INTO dww_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Be taumi ko kita da noḡone Mamaitua na waiguyauma be didimana kededima ko wana dokedi. Yodibe tauna inam yabedima matabudi tokare e utemina. ");
INSERT INTO dww_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Vutuna aubainama nam pomai na kauama yodi koi nuaboye. Pomai ko gose da taunaḡa ei nuaboya munaḡena. Raḡan tenatenaḡaḡa adi nuaboyama nama ta kenakenana. ");
INSERT INTO dww_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nam turamma na yawasanama kwa kita wairuva be kwa riutuatuaḡaie da Mamaitua tokare teneḡinama nama ḡarome e voiena. ");
INSERT INTO dww_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Baninama tam nema banaga kwa kitakita wairuvana, teneḡinama nama Mamaitua tam tokare e kita wairuvamna. Tam aba ruvane turamma kwa ruvaruvana, ruvanama teneḡine Mamaitua tokare tam e ruvamna. ");
INSERT INTO dww_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aba aubainama turamma matane vunavuna kwa kitakita be tam matame kaitupo nam kuma kitakita? ");
INSERT INTO dww_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bo aba aubainama tam matame kaitupo nam ku kaipore, be turamma matane vunavuna kaiporenama kwa riuriue? ");
INSERT INTO dww_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tam banaga kaikaiyovumma! Noḡone tam matame kaitupo kwa kaipore doke da kwai kita kaua, yodibe turamma matane vunavuna kwa kaiporena. ");
INSERT INTO dww_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yaba babaudima ḡaromie nam daḡadaḡasi ko utedi. Be ami posaruma nam bawa ko utedi, deḡoda taudi inam yabedima ta vagudegudedi be tai tauvitaredi da taumi bogemie ta dawena. ");
INSERT INTO dww_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Koi baḡa be e utemina, ko wane be ko banavina, ko raupewapewa be e kaiporena ḡaromie. ");
INSERT INTO dww_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Deḡoda aitau ewai baḡana, tokare e paḡona, be aitau e wanewanena, tokare e banavina, be aitau e rarau pewapewana, tokare ḡarone e kaiporena. ");
INSERT INTO dww_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nam aitau tam natumma kani ewai baḡe be tokare yeku kwa ute. ");
INSERT INTO dww_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Be nam aitau tam natumma iyana ewai baḡe be tokare mota kwa ute. ");
INSERT INTO dww_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yodi avedi da taumi banaga gewegewemima, be yaḡoro yaba veredima natunatumima ko uteutedina. Naumeki da tamemima marae tauna teneteneḡinama taumi aitauḡa kowai baḡana, tokare yaba veredima e utemina. Baninama tauna kivinama ya vere vavasaḡana, nam maika taumi. ");
INSERT INTO dww_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Taumi aba ko ḡoeḡoena banaga sibo ḡaromie a voiena, nama taumi banaga ḡarodie ko voiana. Deḡoda nama ko voiana, taumi inam tarawatu be peroveta adi waikatakataima ko vovo teyeteyedina. ");
INSERT INTO dww_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Keda matakedanama ḡuririne ko sonaḡana, baninama gewagewa kedanama inam nuasabunama be matakedanama dosinama, be banaga toitoi inam matakedane ta saḡa be kedanama ta watawatanina. ");
INSERT INTO dww_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Be yawasana kedanama ya ḡaubo be matakedanama ya ḡuriri kauana, be banaga raubisaḡa inam matakedanama ta banavi be ta watawatanina. ");
INSERT INTO dww_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Peroveta kaikaiyovudima ko kita kauedina. Taudi ḡaromie ta tavana kitedima kabe banaga vovoyaḡotidi, be ibewa da taudi nopodima inam tabei maika. ");
INSERT INTO dww_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Peroveta adi yawasanama ko kita wairuvedi da taudi peroveta veredi, bo gewegewedi. Baninama banaga nam tokare damaya votanama yaguru bogane e ragaudi be teneteneḡina. Be nam aitau mabeko votanama gedara bogane e ragaudi be teneteneḡina. ");
INSERT INTO dww_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Be teneḡinama nama kai verenama votanama inam verenama, be kai gewagewanama votanama inam gewagewanama. ");
INSERT INTO dww_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kai verenama votanama nam gewegewedi, be kai gewagewanama votanama nam veredi. ");
INSERT INTO dww_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Be ai kaiḡa banidima nam veredi, taudi matabudi tokare Mamaitua e taraḡa be e gabu gorudina. ");
INSERT INTO dww_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Inam kauinama teneḡine peroveta adi yawasanama ko kita wairuvedi be ko kataiedi da taudi peroveta veredi bo peroveta kaikaiyovudi. ");
INSERT INTO dww_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Banaga toitoi ta riuriueguna, ‘Bada, Bada’, be nam tokare matabudi Mamaitua na waiguyaue ta saḡa. Ibewa da aitauḡa Tamaguma marae na ḡoanama ta voivoiena, taudi vutudi tokare Mamaitua na waiguyaue ta saḡana. ");
INSERT INTO dww_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Inam raḡanine banaga toitoi tokare ta riueguna, ‘Bada, tauma tam isame kè rarau guguya, be tam isame penama kè tavutavu dobiḡedi be mataira dosidima toitoi kè voivoiedina.’ ");
INSERT INTO dww_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Be taugu tokare yà riuedina, ‘Taugu taumi nam airaḡan e kataiemina. Taumi tarawatu tauwai katikotovidima, ko naḡo ḡavoe.’ ");
INSERT INTO dww_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Vutuna aubainama, deḡoda aitau e verau be riuguma e vaie be e voivoiena, tauna noḡota kaua baneginama maika. Tauna na vadama kerinama aubainama dom ya keri gurate da yeku debane na tuatuama yai midiri, be na vadama ya kerina. ");
INSERT INTO dww_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Be kusana dosinama kabaita mate a dobidobina raḡanine, gimori a karuedina, be sive dosinama ya suve da vada ya riḡa rereḡe, be vada nam i bekuna, baninama tuatua a yovo guratana, yeku debane aubainama. ");
INSERT INTO dww_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Be aitau da e verau be riuguma e vaivaiena, be nam ima voivoiena, tauna banaga buabuanama maika. Tauna na vadama kerinama aubainama nam dom i keri guratena, tauna na tuatuama gimori debane yai midiridi be na vadama ya kerina. ");
INSERT INTO dww_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Be kusana dosinama kabaita mate a dobidobina raḡanine, gimori a karuedina, be sive dosinama ya suve da vada ya riḡariḡana, yai mia kamoḡi be ya nuarikarikana.” ");
INSERT INTO dww_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu na giuma ya kovikovina raḡanine, patara Yesu na waikatakataima a base kauena, ");
INSERT INTO dww_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","baninama taudi mayanama a paḡo da tauna rewapana mate yawai katakataidina, nam tarawatu tauwai katakataidima maika. ");
INSERT INTO dww_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Raḡanine Yesu oya debane be ya yovoyovo munaḡana, patara dosinama ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dabudine tauḡoma tenaḡa kito paḡopaḡonama ya verau Yesu noḡone da tuapikane ya raupari be ya riuna, “Bada deḡoda kwa ḡoena, naumeki da kwai yawasaniguna.” ");
INSERT INTO dww_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Naumeki da Yesu nimanama yai yoyo, da tauḡoma ya taukoni be ya riuna, “Naumeki, yà ḡoeḡoena, kwa yawasanana.” Be inam dabudine yai raḡantenaḡe da tauḡoma kito paḡopaḡonama ya yawasanana. ");
INSERT INTO dww_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dabudine Yesu inam tauḡominama ya riuena, “Aba ḡarome ya tubuḡana, nam aitau kwa riue, be kwa naḡo pirisi ḡarone da tauna e kaiviramna. Yodibe Mamaitua kwa puyona, Mousis na tarawatuma e riuriuna nama. Dabudine banaga ta kitam be ta kataie da tam kuya yawasanana.” ");
INSERT INTO dww_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Be Yesu raḡanine Kapeniamma ya tavatavana, dabudine tori matanama Yesu ḡarone ya tava da yai baḡa be ya riuna, ");
INSERT INTO dww_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bada, yau taunoyama vadae e kenakenana be tauna tuninama ai kaukudukudu be muya dosinama e kenakenana.” ");
INSERT INTO dww_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Be Yesu tauna ya riuena, “Taugu mate tà naḡo be yai yawasanina.” ");
INSERT INTO dww_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Be dabudi tori matanama Yesu ya paribee be ya riuna, “Bada taugu nam veregu da tam yau vadae sibo kuya verau. Be bonamḡa kwa riu da yau taunoyama e yawasanana. ");
INSERT INTO dww_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Taugu mate waibada dibudie yà miamiana, be mate banaga iḡeiḡeridima yau waibadama dibune ta miamiana. Be raḡanine tauiḡara yà riuena, ‘Kwa naḡo’, be tauna e naḡonaḡona. Bo yà riuena, ‘Kwa verau’, be tauna e veraverauna. Be yau taunoyama yà riuena, ‘Uma kwa voie’, be tauna e voivoiena.” ");
INSERT INTO dww_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Raḡanine Yesu nama ya vaivaiena, tauna tori matanama ya basena, be dabudine yai tautinamuri da patara awai muriwatanena ya riuedina, “Yà riuriu kauemina, taugu nam airaḡan Israelma umanama baneginama na waisumaḡama dosinama deḡo e banavi rubuna. ");
INSERT INTO dww_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Taugu yà riuemi, tokare banaga toitoi dobu matabuna nopone ta verauna, Mamaitua na waiguyauma nopone. Dabudine taudi Eibraham, Aisik be Jeikob mate ta mia be ta soi tenaḡana. ");
INSERT INTO dww_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Be banaga aitauḡa noḡone Mamaitua ya vinedina da na waiguyauma nopone sibo a saḡana, be tokare inam banegidima ei poraḡa dobiḡedina tadiwanawana nopone. Be inam dabudine taudi tokare ta yakei be gadigadidima ta sanadididina.” ");
INSERT INTO dww_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dabudine Yesu tori matanama ya riuena, “Naumeki kwa naḡo, be am waisumaḡama ruvane nama e tubuḡana.” Inam nama ya riuriuna, tori matanama na taunoyama ya yawasana munaḡana. ");
INSERT INTO dww_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Raḡanine Yesu Pita na vadae ya saḡasaḡana, dabudine Pita rawanama sida poyapoya ya paḡo be ya kenakenana ya kitana. ");
INSERT INTO dww_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Naumeki da Yesu Pita rawanama nimanama ya taukoni ḡome be poyapoya yai kavena, be waivinama ya midisuḡu be adi kanima ya vokaukauedina. ");
INSERT INTO dww_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Be ravi ya tavatavana raḡanine, banaga toitoi penama kokukokudima a verauḡedina Yesu ḡarone, be tauna bonane inam aruidima gewegewedima ya tavu dobiḡedina, be banaga sidesidedima mate matabudi yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Uma kauidima Bada boni peroveta Aisaia ḡarone ya giugiuena ruvane nama ya tubuḡana. Peroveta boni umanama ya riuna, “Tauna dà nuaboyama ya ragaudi be dà sidama matabudi vitanama ya kiroḡidina.” ");
INSERT INTO dww_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu patara dosinama ya kitekitedina, tauna na tauwai muriwatanama ya riuedina da wagae sibo yawawa a davu be noaḡo nevane a naḡona. ");
INSERT INTO dww_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dabudine tarawatu tauwai katakatainama tenaḡa Yesu ḡarone ya tava be ya riuena, “Tauwai katakatai, tam deḡo kwa naḡona taugu yài muriwatanemna.” ");
INSERT INTO dww_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Be Yesu ya paribeena, “Inam naumeki be kwa noḡoti da, kiudobo adi gabuma gaure ta miamiana, be kiu adi gabuma noḡie ta miamiana, be Banaga Natunama nam deḡo na gabu da tauna e kena.” ");
INSERT INTO dww_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dabudine Yesu na tauwai muriwatanama ḡesau ya tava be ya riuena, “Bada, taugu yài muriwatanemna, be noḡone kwa gosegu da yà naḡo tamaguma yà dobo dokena.” ");
INSERT INTO dww_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Be Yesu ya paribeena, “Tam taugu kwai muriwataneguna, be banaga guriguridima kwa gosedi da taudiḡa adi gurima ta dobodina.” ");
INSERT INTO dww_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dabudine Yesu na tauwai muriwatanama mate wagae a saḡa da a naḡona, ");
INSERT INTO dww_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","be yawawa poune yai raḡantenaḡe da kaibitibiti dosinama ya tavana. Be rabama dosidima waga a riḡa be upa waga nopone a saḡasaḡana. Be Yesu tauna ya kenakenana. ");
INSERT INTO dww_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dabudine na tauwai muriwatanama Yesu a rawaḡosori be a riuna, “Bada kwai yawasanimai, kaiteka tà monuna.” ");
INSERT INTO dww_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Be tauna ya paribeedi be ya riuna, “Aba aubainama ko nainaira? Ami waisumaḡama ya ḡaubo ḡaḡa.” Dabudine tauna ya midisuḡu da sive be rabama ya riutuaḡaiedi be daumora ya kena munaḡana. ");
INSERT INTO dww_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Inam raḡanine taudi Yesu a base be a riuna, “Uma ai banaga nama kitana? Tauna sive be rabama ta vovo teyeteyena.” ");
INSERT INTO dww_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Raḡanine taudi noaḡo nevane Gerasi banegidima adi dobue a tavatavana, banaga rabui penama kokukokudima, taudi kokoagae be Yesu ḡarone a dobina. Taudi ai nuanainaira kauana. ");
INSERT INTO dww_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Be taudi bonedima dosine Yesu a riuena, “Mamaitua Natunama! Tam aba ḡaromaie kwa ḡoeḡoe? Kovoḡa na raḡanima tokare e tavana, be tam uma dabudine kuya verauna kwa kovoḡa dokemai, bo?” ");
INSERT INTO dww_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Taudi deḡo a midimidina diedie bawa netarinama dosinama a yabayabana. ");
INSERT INTO dww_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Naumeki da penama Yesu ai baḡa be a riuna, “Deḡoda kwa tavu dobiḡemaina, naumeki da kwa riupore nawemaina bawa nopodie.” ");
INSERT INTO dww_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dabudine Yesu penama ya riuedina, “Ko dobi ko naḡo!” Dabudine penama tautauḡoma a dobi poredi da a naḡona bawa nopodie. Be bawa matabudi oya boganaḡa a manini yovo be yawawa nopone a naḡo, be dabudine upa nopone a tonedi be a gurina. ");
INSERT INTO dww_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Be bawa tauyosidima taudi naira a naḡo meagaie a tava, be dabudine yaba matabuna a tubutubuḡana adi banagama a riuedina. ");
INSERT INTO dww_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Naumeki be banaga matabudi inam meagaine miemienidima a dobi a naḡona Yesu ḡarone, be taudi Yesu a riu vavasaḡena da tauna inam dobunama sibo ya gose be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Naumeki be Yesu waga nopone ya saḡa munaḡa da yawawa ya davu be noaḡo nevane ya naḡona Kapeniamma, na kaba miae. ");
INSERT INTO dww_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Be dabudine tautauḡoma ḡesaudima turedima tuera paḡopaḡonama ma ratiratina a kiroḡa verauḡena Yesu ḡarone. Be raḡanine Yesu inam tautauḡomidima adi waisumaḡama nama ya kitakitana, tauna tauḡoma tuera paḡopaḡonama ya riuena, “Taukui, nam kwai nuaboya, am gewagewama taugu è noḡota porena.” ");
INSERT INTO dww_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Raḡanine tarawatu tauwai katakataidima inam riunama nama a vaivaiena, taudi nuedie ai nuanoḡonoḡota be a riuna, “Uma baneginama Mamaitua ewai diboḡina.” ");
INSERT INTO dww_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Be Yesu inam banegidima aba awai nuanoḡonoḡotedina, ya kataiena, aubainama ya riuedina, “Aba aubainama inam noḡotidima gewegewedima nopomie ta saḡasaḡa? ");
INSERT INTO dww_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aba riunama ya tekateka, ‘Am gewagewama è noḡota porena’, bo ‘Kwa midisuḡu be kwa naḡo’? ");
INSERT INTO dww_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yodi tokare yài kataimi be ko kataie da dobue Banaga Natunama ḡarone rewapana e kenakenana da gewagewa e noḡota poredina.” Naumeki da Yesu inam tauḡominama tuera paḡopaḡonama ya riuena, “Kwa midisuḡu, am gunima kwa paḡo be kwa naḡona am vadae.” ");
INSERT INTO dww_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Inam raḡanine tauḡoma ya midisuḡu be ya munaḡana na vadae. ");
INSERT INTO dww_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dabudine patara inam kauinama a kitakitana, taudi a basena, baninama Mamaitua inam nama rewapaninama banaga ya utena, vutuna aubainama taudi Mamaitua isanama a kaisuḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu inam gabunama ya gose da ya naḡonaḡo be tauḡoma isanama Metiu ya kitana. Metiu tauna teks na kaba tamima gabune ya miamiana. Be Yesu tauna ya riuena, “Kwai muriwatanegu!” Dabudine Metiu ya midisuḡu be Yesu yai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Naumeki da inam kupine Yesu na tauwai muriwatanama mate a naḡona Metiu na vadae kani aubainama. Be inam vadane gewagewa banegidi be teks tautaminama toitoi a tava be matabudi a kani tenaḡana. ");
INSERT INTO dww_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dabudine Parisi ta kitana be Yesu gewagewa banegidima mate a kanikanina, naumeki da taudi Yesu na tauwai muriwatanama a riuedina, “Aba aubainama ami tauwai katakataima teks tautamidima be gewagewa banegidima mate ta kanikani tenaḡa?” ");
INSERT INTO dww_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Raḡanine Yesu nama ya vaivaiena, tauna ya riuna, “Banaga yawayawasanidima taudi nam dogeta tima ḡoeḡoena, be banaga sidesidedima taudi dogeta ta ḡoeḡoena. ");
INSERT INTO dww_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Be ko naḡo da giu uma baninama ko wanena aba ya giue, ‘Taugu raunuatoi kitanama yà ḡoeḡoena, be taumi musare ko tipatipana taugu nam ama ḡoeḡoena.’ Baninama taugu è yovona banaga gewegewedima waiyawasanidima aubainama. Be aitauḡa ta noḡonoḡoti da taudi banaga veredima, taugu nam taudi aubaidima e yovona.” ");
INSERT INTO dww_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Raḡan tenaḡa Jon tauwai babataito na tauwai muriwatanama Yesu ḡarone a tava be a riuena, “Aba aubainama tauma be Parisi ka widiwidina, be tam am tauwai muriwatanama nam tima widiwidinana?” ");
INSERT INTO dww_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Be Yesu ya paribeedi be ya riuedina, “Raḡanine naḡivau tauḡominama yaḡoro naḡi soine e miamiana, nam ko voie da na banagama ta widina yababa. Be raḡan e tavana da naḡivau tauḡominama ta nawena. Inam raḡanine na banagama tokare tai nuaboya be ta widinana.” ");
INSERT INTO dww_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nam aitau gara vaunama e paḡo be e naḡo gara poranama mate e popo tenaḡedi. Baninama gara vaunama tokare gara poranama e sorusika be e kawa gewagewana. ");
INSERT INTO dww_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Be mate banaga nam tokare waen vaunama ta paḡo, be waen koukounama porane ta ḡini. Deḡoda nama ta voiana, waen vaunama tokare koukou poranama e surasari be waen e rauḡinina. Be waen koukounama tokare e gewagewana. Waen vaunama tauna naumeki da waen koukounama vaune ta ḡinina. Inam raḡanine waen vauna be waen koukounama vaunama tokare veredima nama ta kenana. ");
INSERT INTO dww_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu inam yabedima ya giugiuedina maika, sinagog tauwai badenama tenaḡa ya verauna tauna ḡarone. Tauna ya verau Yesu noḡone be tuapikane doḡae ya raupari be ya riuna, “Taugu natuguma waivinama yodi ya gurina. Vutuna aubainama tam sibo kuya verau da nimamma tauna debane kuya boru be tauna ya yawasana munaḡana.” ");
INSERT INTO dww_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Naumeki da Yesu na tauwai muriwatanama mate a midisuḡu be inam tauḡominama mate a naḡona tauna na vadae. ");
INSERT INTO dww_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Taudi a naḡonaḡo kedae be waivi waikosinavutuvutu paḡopaḡonama Yesu murine ya tava be Yesu na garama ya taukoni be yai nuanoḡonoḡota be ya riuna, “Deḡoda Yesu na garaḡama isunaḡa yà taukonina, taugu tokare yà yawasana munaḡana.” Uma waivinama tauna waikosinavutuvutu ya paḡona, naumeki da modi 12 a kovina. ");
INSERT INTO dww_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dabudine Yesu yai tauvitare da waivinama ya kita be ya riuena, “Moumou, nam kwai nuaboya, am waisumaḡama yai yawasanimna.” Naumeki da inam dabudine waivinama ya yawasanana. ");
INSERT INTO dww_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Be raḡanine Yesu sinagog tauwai badenama na vadae ya saḡasaḡana, dabudine banaga saree a ḡabaḡaba nuanuaina, be patara dosinama ya kitedina. ");
INSERT INTO dww_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Be Yesu ya riuedina, “Ko dobi doḡae matabumi. Gomana nam i gurina, tauna e kenakena ḡomana.” Dabudine patara nama a vaivaiena, taudi Yesu ai kwatekwatevena. ");
INSERT INTO dww_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Be raḡanine ya riuedi da doḡae a dobidobi rovona murine, Yesu ya saḡa vada nopone da gomana nimane ya paḡo be gomana ya midisuḡuna. ");
INSERT INTO dww_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Inam kauinama ya tubutubuḡana, varinama ya daberara be inam dobunama matabuna ya paḡo rovona. ");
INSERT INTO dww_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Naumeki da Yesu inam vadanama ya gose pore da ya naḡonaḡo be tautauḡoma rabui matapotepotedima tauna ai muriwatane, a yogo be a riuriuna, “Guyau Deivid natunama, kwa raunuatoiemai!” ");
INSERT INTO dww_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Raḡanine Yesu ya naḡo vada nopone ya saḡasaḡana, inam tautauḡomidima mate a saḡana. Dabudine Yesu yai taraviredina, “Taumi naumeki kowai sumaḡa bo, da taugu tokare yà voiemi da koi kita munaḡa?” Be taudi a paribee be a riuna, “Bada, tauma kawai sumaḡana.” ");
INSERT INTO dww_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Naumeki da Yesu inam tautauḡomidima matedima ya taukonidi be ya riuna, “Taumi ami waisumaḡama ruvane, yodi tokare koi kitana.” ");
INSERT INTO dww_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Inam raḡanine taudi ai kitana. Be Yesu ya riu vavasaḡedi be ya riuna, “Aba ḡaromie yodi ya tubuḡana nam aitau ko riue!” ");
INSERT INTO dww_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Be you, taudi yaḡoro a naḡo be Yesu varinama inam dobunama matabuna nopone ai daberarina. ");
INSERT INTO dww_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Raḡanine inam tautauḡomidima Yesu a gose be a naḡonaḡona maika, banaga ḡesaudima tauḡoma penama kokukokunama ai doke tavaitena Yesu ḡarone, be inam tauḡominama tauna gumgum. ");
INSERT INTO dww_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Be raḡanine Yesu inam tauḡominama nopone penama ya tavutavu dobiḡena murine, tauḡoma giu yai kare munaḡena. Be patara dabudine inam kauinama a kitakitana, taudi a base be a riuna, “Uma kauinama Israel nopone nam nama dà kaba kita, be yodi tè kitana.” ");
INSERT INTO dww_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Be Parisi a riuna, “Inam penama adi badama tauna rewapana Yesu ya utena. Vutuna aubainama tauna penama e tavutavu dobiḡedina.” ");
INSERT INTO dww_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ya naḡo taoniḡa, be meagai matabudi nopodiḡa banaga adi sinagogma nopodie, be Mamaitua na waiguyauma varinama verenama ya rarau guguye be banaga yawai katakataidina. Be mate banaga adi sidama tabu be tabu a veraverauḡedina tauna ḡarone, be matabudi yawai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Be raḡanine Yesu patara nama ya kitekitedina, tauna ya raunuatoi kauedina. Baninama taudi adi nuaboyama inam a toi rereḡena be nam ti kataiena aikedae sibo a naḡo be sagu a paḡo. Taudi inam maika kabe sipu nam taurabedima mate ti miamia. ");
INSERT INTO dww_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dabudine Yesu na tauwai muriwatanama ya riuedina, “Sipi nopone maura dosinama ya nonoḡa be e kenakenana, be taunoya a rabuina. ");
INSERT INTO dww_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Vutuna aubainama Bada, tauna vutuna sipi taupakinama koi baḡa da taunoya e riuporaḡa be tauna na sipie ta noyana.” ");
INSERT INTO dww_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Inam raḡanine Yesu na tauwai muriwatanama 12 ya rawateḡeidi be rewapana ya utedina da taudi arua gewegewedima ta tavu dobiḡedi be sida tabu be tabu tai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Apasol 12 isedima inam umanama, Saemon, tauna vutuna ya vine dokena, awai isana ‘Pita’, be tasinama Endru, da Jeims, Sebedi natunama be tasinama Jon, ");
INSERT INTO dww_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","da Pilip be Batolomiu, da Tomas be Metiu teks tautaminama, da Jeims, tauna Alpius natunama, be Tadeas, ");
INSERT INTO dww_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","da Saemon tauna awai isana ‘Selot’, be Judas Iskariot, tauna vutuna Yesu tauboru dobiḡenama. ");
INSERT INTO dww_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Inam tautauḡomidima 12 Yesu ya riuporedi be umanama ya riuedina, “Israel banegidima ḡarodiḡa ko naḡona, baninama taudi sipu kwakokwakodima maika ta miamiana. Be nam banaga ḡesaudima ḡarodie ko naḡo maika Samaria adi meagaie, bo dobu ḡesaudie. ");
INSERT INTO dww_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ko naḡonaḡona raḡanine taumi uma varinama ko rauguguyena, ‘Mamaitua na waiguyauma kaiteka maida.’ ");
INSERT INTO dww_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Be banaga sidesidedima koi yawasanidi, guriguridima ko kawa midisuḡudi, banaga kito ragaragaudima koi yawasanidi, be penama banaga a kokukokudina ko tavu dobiḡedina. Uma rewapanidima yà uteute yababemina, aubainama taumi banaga koi yawasana yababedina. ");
INSERT INTO dww_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ami vaḡaie nam mane ko paḡo, ");
INSERT INTO dww_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nam tana, nam rupu ḡesau mate ko paḡo, nam kaḡasuma, be nam diḡona. Taumi yau taunoyama aubainama banaga tokare yaba matabudi ta voiedina aubaimima. ");
INSERT INTO dww_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Raḡanine taumi meagaie ko tavatavana, dabudine ko kita da banaga kaua ḡarone ko miana, naumeki da inam meagainama ko gosena. ");
INSERT INTO dww_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Raḡanine taumi vadae ko saḡana, koi kaiwa be ko riuna, ‘Suba ḡaromie e kenana’. ");
INSERT INTO dww_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Be banaga dabudine tai aninemina, naumeki da ami subama ḡarodie e kenana. Be deḡoda ibewa, ami subama ko paḡo munaḡena. ");
INSERT INTO dww_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Be deḡoda banaga nam tai aninemi be ami giuma nam ta vaie, naumeki da kaḡemima popokaudima ko rawakurukuruvidi be inam vadana bo meagainama ko gosena. ");
INSERT INTO dww_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Taugu yà riuriu kauemina da maraetara raḡanine Mamaitua tokare inam banegidima e kovoḡa vavasaḡedina, nam maika Sodom be Gomora. ");
INSERT INTO dww_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Taugu yà riuriupore nawemina maika sipu, musara ḡasiḡasidima nopodie. Vutuna aubainama ko vora kaua da gewagewa nam e taukonimi be mate ko voyaḡota kaua da yawasana miremiredima nam ko voiedi. ");
INSERT INTO dww_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Be banaga ko kita kauedina, baninama taudi tokare tauetara nimedie ta biri nawemi be sinagog nopodie ta kwapumina. ");
INSERT INTO dww_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Taudi tokare ta soru nawemina gabegabeman be guyaguyau dosidima noḡodie taugu kau taiye. Be dabudine taudi ḡarodie be banaga matabudi ḡarodie taumi taugu aubaiguma koi matamatana. ");
INSERT INTO dww_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Be ta panimina raḡanine, nam koi nuaboya da nema sibo koya giu bako. Mamaitua tauna tokare giu ei kataimi da nema ko giu bakona. ");
INSERT INTO dww_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Baninama inam raḡanine tokare nam taumi ko giu, ibewa da Tamemima marae Aruinama tauna giu e utemi be ko giuna. ");
INSERT INTO dww_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Inam raḡanine tautauḡoma tasitasidima bo tuatuaḡedima ta biri dobiḡedi da banaga taudi tai guridina, be dosi kauinama teneḡinama adi sedama ḡarodie ta kauena, be seda nama adi dosima tai ḡaviedi be ta voiedi da gurie ta biridina. ");
INSERT INTO dww_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Be banaga matabudi ta tuaḡaiemina, baninama taumi taugu kowai sumaḡeguna aubainama. Be aitau na waisumaḡe e midi bagibagi be e raudamoena, tauna tokare e yawasanana. ");
INSERT INTO dww_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Deḡo meagaine ta raukivi gewegewemina, naumeki da inam meagainama ko gose, be wari meagaie ko naḡona. Be yà riuriu kauemina da taumi muriḡa da sibo Israel meagaidima nopodie ami noyama sibo koyai kovina, be Banaga Natunama tokare e verauna. ");
INSERT INTO dww_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Banaga aitauḡa ta girugirumana nam adi tauwai katakataima ta saḡa pore, be nama taunoya na badama nam e saḡa pore. ");
INSERT INTO dww_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Be banaga girugiruminama na tauwai katakataima e ruvana, inam naumeki. Be kauinama teneḡinama nama taunoya, tauna na badama e ruvana, inam naumeki. Vutuna aubainama, deḡoda banaga vada taupakinama tai wavu be ta riuna da tauna penama adi guyauma Belsebul, naumeki da taumi vadanama banegimima tokare inam riunama teneḡinama nama ta riuemina. ");
INSERT INTO dww_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Be inam banegidima nam ko nairedi. Be raḡan e veraverauna e tavana raḡanine, yaba matabudi semosemodina tokare ta maḡatarana. Be yaba waimoisirie kenekenedima matabudi tokare patare tai maḡataridina. ");
INSERT INTO dww_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Be aiyaba kupie yà riuriuemina, taumi tokare suare ko giuedina, be taugu aiyaba waimoisirie beemie yà kasavena, tokare bonemima dosine patare ko giue be banaga matabudi ta vaiena. ");
INSERT INTO dww_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Banaga tubuḡa taunaḡa tauwai gurinama nam ko nairedi, baninama taudi tokare nam teneteneḡina da aruimima tai guridi. Mamaitua tauna vutuna ko nairena, baninama tauna deḡoda e ḡoena, tokare teneḡinama da tubuḡimima be aruimima ei guri tenaḡedina gienae. ");
INSERT INTO dww_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Uma ko noḡoti, kiu ḡauḡaubodima rabui maesidima 10 Toea, be Tamemima Mamaitua tokare nam ai kiu tenaḡa e kitapore be e guri yababa. ");
INSERT INTO dww_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Be taumi deba vuvuḡimima mate e siasiava waibatena. ");
INSERT INTO dww_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Vutuna aubainama nam ko naira, baninama taumi noḡotimima ya moraba kauana, nam kiu ḡauḡaubodima maika. ");
INSERT INTO dww_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Aitau taugu isaguma banaga matedie e kawa saḡena, naumeki da taugu tauna isanama tokare Tamaguma marae ḡarone yà kawa saḡena. ");
INSERT INTO dww_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Be aitau taugu e bovieguna banaga matedie, naumeki da taugu tauna tokare Tamaguma marae ḡarone yà boviena. ");
INSERT INTO dww_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nam ko noḡoti da taugu dobue suba è verauḡena, ibewa. Taugu kea e verauḡena. ");
INSERT INTO dww_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Taugu è yovona, yà voiemi da tauḡoma natunama tauḡominama mate tai saḡasaḡana, be gomana waivinama tinanama mate tai saḡasaḡana, be visara rawanama mate tai saḡasaḡana. ");
INSERT INTO dww_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Taumi ami ḡaviama tokare ami vadae ta tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Tam aitau da taugu kwawai nuapaḡoeguna, be yaḡoro tam tamamma be tinamma kwawai nuapaḡo guratedina, naumeki da tam nam teneteneḡina da taugu yau tauwai muriwatana. Be tam aitau da taugu kwawai nuapaḡoeguna, be am sedama kwawai nuapaḡo guratedina, naumeki da tam nam teneteneḡina da taugu yau tauwai muriwatana. ");
INSERT INTO dww_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Be deḡoda aitau nam na korosima e kiroḡi be ei muriwatanegu, tauna nam teneteneḡina da taugu yau tauwai muriwatana. ");
INSERT INTO dww_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tam aitau tame am yawasanama kwa kaididi be kwa raberabena, tam tokare am yawasanama kwa kawa gewagewana, be tam aitau da taugu kautaiye am yawasanama kuyai utaena, am yawasanama tokare kwa banavina. ");
INSERT INTO dww_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Aitau da taumi ewai aninemina, taugu mate ewai anineguna. Be aitau da taugu ewai anineguna, tauriuporeguma mate ewai aninena. ");
INSERT INTO dww_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tam aitau da peroveta kuyai aninena, baninama tauna peroveta aubainama, tam tokare peroveta adi maesama ta paḡopaḡona ruvanama, nama tam kwa paḡona. Be tam aitau da didimana baneginama kuyai aninena, baninama tauna didimana baneginama aubainama, tam tokare didimana banegidima adi maesama ta paḡopaḡona ruvanama, nama tam kwa paḡona. ");
INSERT INTO dww_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Be aitau da umanama banegidima taudi banaga yabayababa, be upa kwa ute be e tegona, baninama tauna yau tauwai muriwatanama, taugu yà riuriu kauemna da tam tokare am maesama kwa paḡona.” ");
INSERT INTO dww_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Raḡanine Yesu na tauwai muriwatanama 12 yawai katakatai kovidina, murine tauna inam dobunama ya gose be ya naḡona Galili meagaidima nopodie waikatakatai be rauguguya aubaidima. ");
INSERT INTO dww_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Be Jon tauna dibure ya miamia be Yesu yaba ya voivoiedina varidima ya vaivaiena, naumeki be tauna na tauwai muriwatanama ya riuporedi ");
INSERT INTO dww_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","da Yesu umanama sibo a riuena, “Tam vutuna Tauwai yawasana a riuriuemna kuya tava bo banaga ḡesau ka rabe?” Be Yesu ya paribeedi be ya riuna, “Ko munaḡa be aba koya vaivaiedi be koya kitekitedina, vutudi Jon koi varina. ");
INSERT INTO dww_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","“Banaga matapotepotedima tawai kita munaḡana, be banaga tuera ragaragaudima ta naḡonaḡo munaḡana, be banaga kito ragaragaudima ta verevere munaḡana, ");
INSERT INTO dww_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","be banaga beapotepotedima tawai beavaia munaḡana, be banaga guriguridima ta midimidisuḡu munaḡana, be banaga waikaruwaḡewaḡedima vari verenama ta vaivaiena. ");
INSERT INTO dww_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Be nuavere tauna aitau nam ḡarogue ima noḡonoḡota bekubekuna.” ");
INSERT INTO dww_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Taudi a munamunaḡana raḡanine, Yesu patara nopone Jon na kauama ya giuedina, “Boni dobu kavakavane koya naḡona Jon ḡarone, be aiyaba koya noḡonoḡotina sibo koya kita? Banaga na waisumaḡama gwaḡanama maika vagara sive ya kwadikwadiena, vutuna kitanama aubainama koya naḡo? ");
INSERT INTO dww_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bo aiyaba koya noḡonoḡotina sibo koya kita? Banaga gara verenama kotekotenama sibo koya kita? Ibewa, banaga gara veredima kotekotedima taudi guyau na vadae ta miamiana. ");
INSERT INTO dww_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bo aiyaba koya noḡonoḡotina sibo koya kita? Peroveta, bo? Ee, be yà riuriuemina, taumi peroveta dosinama koya kitana, nam peroveta ḡesaudima maika. ");
INSERT INTO dww_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tauna vutuna girugiruminama porane girugiruminama umanama ya riuna, ‘Taugu yau taunoyama yà riupore doke da am kedama e sepana, be muriḡa tam.’ ");
INSERT INTO dww_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Yà riuriu kauemina da dobue nam aitau tenaḡa Jon e saḡa pore. Be banaga aitau Mamaitua na waiguyauma nopone e miamiana, avedi da tauna banaga yababa, be yaḡoro tauna Jon ya saḡa porena. ");
INSERT INTO dww_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon tauwai babataito na raḡanie da yodi, banaga Mamaitua na waiguyauma awai ḡaviena. Be taudi a rarau rubuna da taudi adi rewapanae Mamaitua na waiguyauma sibo ai badena. ");
INSERT INTO dww_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Peroveta be Mousis na tarawatuma taudi matabudi awai perovetana naumeki da Jon na raḡanima ya tavana. ");
INSERT INTO dww_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Be Elaija tè raberabena, tauna vutuna yodi Jon ya tavana. ");
INSERT INTO dww_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Deḡoda beemima ta kenana, naumeki da koi beavaiana. ");
INSERT INTO dww_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Naumeki da, uma kimtinama yodi nema yài ruvaruva bakedi? Taudi aiyaba maika? Taudi seda debadebae tawai digirina maika. Be taudi adi banagama mate tawai riusinḡaḡaya be ta riuriuna, ");
INSERT INTO dww_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tauma naḡi sarenama kè sare be taumi nam ko bigana, be tauma guri ḡabanama kè ḡaba sinasinayona, be taumi nam ko ḡabana.’ ");
INSERT INTO dww_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Be banaga raḡan matabuna teneḡinama nama a riuriu tuatuaḡaiena. Raḡanine Jon ya tavana, banaga kauinama teneḡinama a voivoiena. Tauna kani ya widiwidinedi be waen nam i tegotegona raḡanine, banaga a riuriuna, ‘Tauna nopone penama e miamiana.’ ");
INSERT INTO dww_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Be Banaga Natunama ya tava be ya kanikani, be ya tegotegona raḡanine, banaga a riuriuna, ‘Ko kita, tauna banaga kanikani dobidobinama be waen tegotego dobidobinama. Be teks tautamidima, be gewagewa tauvoiedima tauna ewai turanedina.’ “Mamaitua na noyama didimanidie tà kita be tai kawa riukaue da na nuauyauyama inam riukaua.” ");
INSERT INTO dww_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Meagai ḡesaudie Yesu mataira dosidima ya voiedina be yaḡoro banaga adi noḡotama nam ti vitaredina. Vutuna aubainama Yesu inam meagaidima banegidima ya riuvireviredi be ya riuna, ");
INSERT INTO dww_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasin be Betsaida meagaimima, ko kita kauana! Baninama taugu ḡaromie mataira dosidima è voiedina, be taumi nam koi sumaḡana. Deḡoda taugu sibo meagai Taia be Saidon nopodie uma matairidima nama dosidima sibo è voiedina, naumeki da taudi bonika sibo noḡota viravira a paḡo, be adi gewagewama nuaboyanama sibo a moguredina. ");
INSERT INTO dww_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Taugu yà riu kauemina da mara etara raḡanine Taia be Saidon tokare kovoḡa ta paḡona, be taumi tokare kovoḡa dosi vavasaḡinama ko paḡona. ");
INSERT INTO dww_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Be taumi Kapeniam banegimima ko noḡonoḡotina tokare ko naḡo marae, bo? Ibewa, taumi tokare Mamaitua gienae e kidipore nawemina, baninama taugu ḡaromie mataira dosidima è voiedina be taumi nam koi sumaḡana. Deḡoda taugu Sodom meagainama nopone uma matairidima nama dosidima sibo è voiedina, taudi tokare noḡota viravira a paḡona, inam yodi Sodom yaḡoro sibo ya kenakenana. ");
INSERT INTO dww_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Taugu yà riu kauemina da mara etara raḡanine Sodom banegidima tokare kovoḡa ta paḡona, be taumi tokare kovoḡa dosi vavasaḡinama ko paḡona.” ");
INSERT INTO dww_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Inam raḡanine Yesu ya riuna, “Mamai, tam mara be dobu Badanama, yà kaisuḡusuḡumna baninama tam uma kauidima banaga aitauḡa ta noḡonoḡotina da taudi kabe nuauyauya be katai banegidi, taudi ḡarodie nam kui maḡataridina. Be tam banaga koekoedima kitedima seda maika ḡarodie kuyai maḡataridina. ");
INSERT INTO dww_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Naumeki Mamai, inam vutuna tam am ḡoanama. ");
INSERT INTO dww_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tamaguma yaba matabuna ya uteguna. Be nam aitau Mamaitua Natunama i kataiena, be Tamanama taunaḡa ya kataiena. Be nam aitau Tamanama i kataiena be natunama taunaḡa Tamanama ya kataiena. Be natunama aitauḡa ya vinevinedina, taudi ḡarodie ewai maḡatarana da Tamanama aitau. ");
INSERT INTO dww_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Taumi matabumi aitauḡa nuaboya be vita ko kirokiroḡana, ko verau ḡarogue be ko siperena. ");
INSERT INTO dww_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yau kewama isune ko kiroḡi be yau kedama ko kataiena, baninama taugu voyaḡota be ḡaubo munaḡa banegiguma. Vutuna aubainama taugu ḡarogue tokare sipere ko banavi, be yài nuasubemina. ");
INSERT INTO dww_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Baninama yau kewama inam tekatekanama, be yau vitama nam i morabana.” ");
INSERT INTO dww_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabat tenaḡa Yesu na tauwai muriwatanama mate yaḡoda sipinama nopodiḡa a naḡonaḡona. Be na tauwai muriwatanama kani ya karatidi be taudi yaḡoda a ragaudina be a kanidina. ");
INSERT INTO dww_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Be Parisi nama a kitakitana, taudi Yesu a riuena, “Yodi kuya kita, uma yabedima Sabat nopone nam sibo koya voivoiedi, be tam am tauwai muriwatanama ta voivoiedi.” ");
INSERT INTO dww_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Be Yesu ya paribeedi be ya riuna, “Guyau Deivid na banagama mate kani ya karatidi, be aba Deivid ya voivoiena, vutuna taumi koya sievi bo ibewa? ");
INSERT INTO dww_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tauna Mamaitua na vadae ya naḡo be buredi waiaiainidima ya ragaudi be na banagama mate a kanidina. Be tarawatu e riuriuna da inam buredidima pirisi taudiḡa sibo a kanikanina. ");
INSERT INTO dww_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Be mate taumi tarawatu koya sievi bo ibewa da Sabat raḡanine pirisi tempol nopone Sabat na tarawatuma tawai kati kotovina, be inam nam gewagewa ti voivoiena. ");
INSERT INTO dww_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Taugu yà riuriuemina banaga tenaḡa uma nopode tauna ya saḡa vavasaḡana, nam maika tempol. ");
INSERT INTO dww_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mamaitua boni umanama ya riuna, ‘Taugu raunuatoi kitanama yà ḡoeḡoena, be taumi musare ko tipatipana taugu nam ama ḡoeḡoena.’ Taumi deḡoda inam giudima banidima ko kataiedina, taumi didimana banegidima tokare nam koyai wavu yababedi. ");
INSERT INTO dww_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Banaga Natunama tauna Sabat ewai badena.” ");
INSERT INTO dww_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu naḡo yai kare munaḡe be banaga adi sinagogma tenaḡa nopone ya saḡana. ");
INSERT INTO dww_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Be dabudine tauḡoma nimanama tuera paḡopaḡonama ya miamiana ya kitana. Be inam dabudine Parisi taudi Yesu waiwavunama kedanama a wanewanena da aiyabae tauna sibo Yesu ai wavuna. Vutuna aubainama taudi Yesu ai taravire be a riuna, “Tarawatu nema e riuriu bako? Sabat raḡanine banaga kwai yawasanina tokare naumeki bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Be Yesu ya paribeedi be ya riuna, “Deḡoda tam aitau tenaḡa am sipuma Sabat raḡanine dome i bekuna, tam tokare nam kuya naḡo be kuya tika tavaite, bo? ");
INSERT INTO dww_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Be banaga tauna noḡotinama ya moraba kauana, nam maika sipu. Vutuna aubainama Sabat raḡanine naumeki da vere tà voiena.” ");
INSERT INTO dww_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dabudine Yesu inam tauḡominama ya riuena, “Nimamma kwa kawa didimani.” Naumeki da tauḡoma nimanama ya kawa didimani be nimanama ya vere munaḡana, nimanama ḡesau maika. ");
INSERT INTO dww_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Be Parisi a dobi a naḡo be Yesu kana kasirama a tomtomna da sibo ai gurina. ");
INSERT INTO dww_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Be Yesu ya kataie da Parisi taudi aba a voivoiena, vutuna aubainama tauna inam gabunama ya gose be wari kedae ya naḡona. Be banaga toitoi Yesu ai muriwatane be tauna banaga sidesidedima matabudi yai yawasanidina ");
INSERT INTO dww_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","be ya riu vavasaḡedina da taudi nam aitau sibo a riue da tauna aba banegina. ");
INSERT INTO dww_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Uma kauidima matabudi Bada boni peroveta Aisaia ḡarone aba ya giugiuedina, ruvane nama a tubuḡana. Aisaia boni umanama ya riuna, ");
INSERT INTO dww_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Uma tauna inam taugu yau taunoyama, vutuna è vinena. Tauna vutuna nuaguma e paḡopaḡona, be taugu yàwai nuaverena tauna ḡarone. Taugu Aruiguma nopone yà boru be tauna tokare yau waitarapirima banaga matabuna ḡarodie e rauguguyena. ");
INSERT INTO dww_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tauna tokare nam aitau mate tai saḡasaḡa be e rasedi. Tauna nam tokare kedaḡa e yogoyogo babara be bonanama ta vaie. ");
INSERT INTO dww_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Be vagara viriviri kusewinama nam tokare e kotova pore. Be kai punanama nopone e rarau karakaratana, tauna tokare nam ei tiriri gaba. Tauna nama e voiana naumeki da raḡan damone dobu matabuna nopone banaga e kawa didimana rovodina. ");
INSERT INTO dww_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Inam raḡanine banaga dobu matabuna taudi tokare adi waisumaḡama tauna ḡarone ta boruna.” ");
INSERT INTO dww_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dabudine tauḡoma penama kokukokunama a verauḡena Yesu ḡarone. Inam tauḡominama tauna gumgum be matapotapotanama. Be Yesu inam tauḡominama yai yawasani be tauna matanama yai kita be giu yai karena. ");
INSERT INTO dww_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Be banaga matabudi Yesu a base be a riuna, “Agunai uma tauna guyau Deivid natuna, bo?” ");
INSERT INTO dww_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Raḡanine Parisi umanama a vaivaiena, taudi a riuna, “Inam penama adi guyauma isanama Belsebul, tauna Yesu ya koku be na rewapanama Yesu ya ute da penama ḡesaudima e tavutavu dobiḡedina.” ");
INSERT INTO dww_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Be Yesu taudi adi noḡotama ya kataiena aubainama ya riuedina, “Deḡoda aba waiguyaunama tauname e dariḡa munaḡena, tokare taunaḡa e kawa gewagewa munaḡena. Be ai meagai nopone taudiḡa tai kawa ḡasiḡasi be ta dariḡa munaḡedina, taudi tokare ta kawa gewagewa munaḡedina. Be ai vada nopone taudiḡa tai kawa ḡasiḡasi be ta dariḡa munaḡedina, taudi tokare ta kawa gewagewa munaḡedina. ");
INSERT INTO dww_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Inam kauinama teneḡinama nama, deḡoda Seitan tauname na penamama sibo i tavutavu dobiḡedina, inam tokare tauname e dariḡa munaḡena, be na waiguyauma nam tokare e kena watana. ");
INSERT INTO dww_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Vutuna aubainama deḡoda taugu sibo Belsebul na rewapanae penama e tavutavu dobiḡedina, naumeki da taumi Parisi ami tauwai muriwatanama taudi aitau na rewapanae penama ta tavutavu dobiḡedi? Taudi koi taraviredi, aitau isane penama ta tavutavu dobiḡedi. Taudi ḡarodie tokare ko banavi da ami giuma inam kaikaiyovunama. ");
INSERT INTO dww_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Be taugu Mamaitua Aruinama na rewapanae penama yà tavutavu dobiḡedina. Inam kauine taumi ko kataie da Mamaitua na waiguyauma kaiteka ḡaromie ya tavana. ");
INSERT INTO dww_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nam aitau tauḡoma wairewapaninama na vadama e gigi da e saḡa, be na purapurama e danene rovodi. Ibewa da noḡone inam tauḡominama wairewapaninama e vunuḡi da e pani dokena, muriḡa be e saḡa da na purapurama e danenedina. ");
INSERT INTO dww_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Deḡoda tauna aitau nam taugu ḡarogu, naumeki da tauna taugu ewai ḡavieguna. Be tauna aitau nam taugu mate kama noyanoya tenaḡana, inam tauna yau noyama e kawakawa gewagewana. ");
INSERT INTO dww_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Vutuna aubainama yà riuriuemina da gewagewa be waidiboḡa matabudi Mamaitua tokare e noḡota poredina. Be aitau da Arua Babau ewai diboḡina, inam gewagewanama Mamaitua tokare nam e noḡota pore. ");
INSERT INTO dww_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Deḡoda aitau Banaga Natunama ḡarone e riuriu viravirana, naumeki da tauna na gewagewama tokare Mamaitua e noḡota porena. Be aitau da Arua Babau ḡarone e riuriu viravirana, naumeki da tauna na gewagewama yodi be nokoi ya naḡona, tokare Mamaitua nam airaḡan e noḡota poredi. ");
INSERT INTO dww_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kai ko kawa batebatena, tokare votanama ta verena. Be kai ko kawa gewagewana, tokare votanama ta gewagewana. Baninama kai votane tokare ko kita be ko kataie da inam kai verena bo kai gewagewana. ");
INSERT INTO dww_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Taumi mota sarama natunatudima, taumi gewagewa banegimima, nema tokare vere ko giu bake? Baninama aba banaga nopone ya moḡavu be e kenakenana, vutuna mudune e dobidobina. ");
INSERT INTO dww_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Banaga verenama noponama vere ya moḡavuna aubainama, yaba veredima ewai tubuḡidina. Be banaga gewagewanama noponama gewagewa ya moḡavuna aubainama, yaba gewegewediḡa ewai tubuḡidina. ");
INSERT INTO dww_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Taugu yà riuriuemina da etara na raḡanie banaga dobue adi giu yabayababama aubainama, taudi matabudi tokare Mamaitua e etaredina. ");
INSERT INTO dww_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Baninama am giuma ruvane Mamaitua tam tokare e kovoḡimna. Be nama am giuma ruvane Mamaitua tam tokare ei yawasanimna.” ");
INSERT INTO dww_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Naumeki da Parisi be tarawatu tauwai katakataidima Yesu a riuena, “Tauwai katakatai, tauma ka ḡoeḡoena mataira kwa voie be ka kitana.” ");
INSERT INTO dww_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Be tauna ya riuedina, “Uma kimtinama taumi gewagewa be badara banegimima be yodi mataira kitanama ko ḡoeḡoena. Be taumi nam tokare mataira ko kita, ibewa da peroveta Jona ḡarone aba ya tubuḡana, vutunaḡa tokare ko kitana. ");
INSERT INTO dww_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona tauna iyana nopone ya miana raḡan rabuiteḡa be kupi rabuiteḡa. Inam kauinama teneḡinama nama Banaga Natunama tokare doḡa nopone e kenana raḡan rabuiteḡa be kupi rabuiteḡa. ");
INSERT INTO dww_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Be maraetara raḡanine Ninive banegidima be taumi uma kimtinama mate gurie be ko midisuḡu munaḡana raḡanine, taudi tokare ta riuemina da taumi sibo gienae koya naḡona. Baninama boni Jona ya rarau guguyana raḡanine, Ninive banegidima taudi na giuma a vaie be noḡota vitara a paḡona. Be yodi uma dobudine banaga tenaḡa tauna Jona ya saḡa porena, be tauna na giuma taumi nam koma vaie be noḡota vitara koma paḡopaḡona. ");
INSERT INTO dww_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Be mate maraetara raḡanine dobu Saba guyaunama waivinama taumi uma kimtinama mate gurie be ko midisuḡu munaḡana. Be tauna mate tokare e riuemina da taumi sibo gienae koya naḡona. Baninama boni inam guyaunama waivinama tauna dobu damone, be ya tavana, Solomon na nuauyauyama vaienama aubainama, be yodi uma dobudine banaga tenaḡa tauna Solomon ya saḡa porena, be tauna na giuma taumi nam komawai beavaiena. ");
INSERT INTO dww_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Be penama banaga e dobi porena raḡanine, tauna e naḡona dobu pokine na kaba siperema gabunama wanenama aubainama. Be gabu nam i banavina aubainama, ");
INSERT INTO dww_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","tauna tokare e riuna, ‘Taugu yau vadama deḡo è gose be è veraverauna, dabudi yà munaḡana.’ Be tauna raḡanine vadae e tava da e kitana be vada noponama kavakavanama. Be vada kawakawa verena be waiwaisianama e kenakenana. ");
INSERT INTO dww_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Naumeki da tauna e munaḡa be penama ḡesaudima, matabudi 7, ei dokedina. Be inam aruidima taudi a gewagewa vavasaḡana nam maika tauna. Taudi matabudi ta saḡa vadanama nopone be ta miana. Inam raḡanine banaga tokare na yawasanama e gewagewa da e gewagewa vavasaḡana, nam noḡone maika. Inam kauinama teneḡinama nama tokare uma kimtinama ḡarodie e tubuḡana.” ");
INSERT INTO dww_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Be raḡanine Yesu yaḡoro patara ḡarodie ya giugiuna maika, tinanama be tasitasinama a tava be doḡae a midina, be taudi a ḡoeḡoena da Yesu mate sibo ai giuna. ");
INSERT INTO dww_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Naumeki da banaga tenaḡa Yesu ya riuena, “Tinam be tasitasimma doḡae ta midimidina, be taudi ta ḡoeḡoena tam mate koi giuna.” ");
INSERT INTO dww_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Dabudine Yesu tauna ya paribee be ya riuna, “Aitau tinagu be aitau tasitasigu?” ");
INSERT INTO dww_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Be tauna na tauwai muriwatanama ḡarodie yai nimayoyo be ya riuna, “Uma taudi taugu tinagu be tasitasiguma. ");
INSERT INTO dww_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Baninama aitau da Tamaguma marae na ḡoanama e voivoiedina, tauna vutuna taugu tasiḡomigu, nuvuḡomigu, be tinaḡomiguma.” ");
INSERT INTO dww_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Inam raḡaninama teneḡine Yesu vada ya dobi pore, be ya naḡo yawawa diane ya miana. ");
INSERT INTO dww_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Be yaḡoro patara dosinama ḡarone a rawateḡeidina, aubainama tauna topae waga debane ya saḡa be ya miana. Be patara matabudi taudi barabarae topa diane a miana. ");
INSERT INTO dww_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Inam dabudine tauna yaba toitoi wainasie yai katakataidi be ya riuedina, “Raḡan tenaḡa taukuma ya naḡona na pesima kumedima aubainama. ");
INSERT INTO dww_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tauna pesi yawai yaraiedina raḡanine, pesi ḡesaudima keda poune a ravusedina, be kiu a tava be a kani rovodina. ");
INSERT INTO dww_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Be pesi ḡesaudima yeku debedie a ravusedina, dabudine doḡa nam dosina, vutuna aubainama pesi a gogo makaina. ");
INSERT INTO dww_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Be suara ya rarararanana raḡanine, pesi ya kara gabedi da a pokina, baninama taudi waramidima nam doḡa nopone ti yovo guratana. ");
INSERT INTO dww_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Be pesi ḡesaudima gedara nopodie a ravusedina, be inam gedaridima pesi a gogogogona, a yavanidina. Vutuna aubainama taudi nam ti banina. ");
INSERT INTO dww_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Be pesi ḡesaudima taudi doḡa verene a ravusedi be a gogona. Naumeki da a moraba be a banina. Banidima ḡesaudima 100, ḡesaudima 60, be ḡesaudima 30. ");
INSERT INTO dww_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Deḡoda beemima ta kenana, naumeki da koi beavaiana.” ");
INSERT INTO dww_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Naumeki da tauwai muriwatana a verau be Yesu ai taravirena, “Aba aubainama banaga wainasie kwa giugiuedi?” ");
INSERT INTO dww_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Be tauna ya paribeedi be ya riuna, “Taugu è vinemina da taumi Mamaitua na waiguyauma semosemonama ko kataiena. Be banaga ḡesaudima tokare nam ta kataie. ");
INSERT INTO dww_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aitau da uma yabedima e katakataiedina, Mamaitua tokare inam katainama debane e taipotodina. Be deḡoda aitau uma yabedima nam ku kataiedina, avedi da katai ḡaubonama ḡarome, be yaḡoro Mamaitua tokare kataidima matabudi e kaiporaḡana. ");
INSERT INTO dww_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Vutuna aubainama taugu banaga ḡarodie wainasie yà giugiuna. Baninama taudi ta kitakitana be nam tima kitakita kauena, be vaienama ta vaivaiena be nam tima katakataiena. ");
INSERT INTO dww_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Boni aba peroveta Aisaia ya giugiuena, yodi taudi ḡarodie e tubutubuḡana. Tauna umanama ya riuna, ‘Taumi ko vaivaiena be tokare nam ko kataie, taumi ko kitakitana be tokare nam ko kita kaue. ");
INSERT INTO dww_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Uma banegidima nuedima gudugudunama. Be taudi beedima nam timawai beavaia kauana, be taudi matedima a potana. Taudi nama a voiana da matedie nam aba ta kita, bo beedie nam aba ta vaie, bo nuedie nam aba ta kataie, baninama taudi nuedima vitarenama a tuaḡaie, be nam tima ḡoeḡoena da taugu yài yawasanidi.’ ");
INSERT INTO dww_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Be taumi matemima ewai kitana, be beemima ewai beavaiana aubainama koi nuaverena. ");
INSERT INTO dww_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Taugu yà riuriu kauemina da boni peroveta toitoi be didimana banegidima a ḡoeḡoena da sibo uma kauidima a kitedina, maika taumi yodi ko kitekitedina nama, be nam ti kitedina. Be taudi a ḡoeḡoena da sibo uma giudima a vaiedina, maika taumi yodi ko vaivaiedina nama, be nam ti vaiedina. ");
INSERT INTO dww_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yodi taukuma wainasinama ḡaromie yà giu waibate da ko vaiena. ");
INSERT INTO dww_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pesi keda debane ravuravusenama na giuma inam umanama. Banaga Mamaitua na waiguyauma varinama e vaivaiena, be nam ima katakataiena raḡanine, Seitan e tava be Mamaitua riunama banaga nopone kumakumanama e kaikai poraḡana. ");
INSERT INTO dww_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Be banaga ḡesaunama tauna maika pesi yeku debedie ravuravusedima. Tauna riu e vaivaiena, waiḡapa ma nuaverena e paḡopaḡona. ");
INSERT INTO dww_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Be tauna nam waramina aubainama tauna nam tokare e midi gurata. Raḡanine piripiri bo raukivigewagewa ta tavatavana Mamaitua riunama kana taiye, tauna tokare waiḡapa e bekuna. ");
INSERT INTO dww_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Be banaga ḡesaunama tauna maika pesi gedara nopodie ravuravusedima. Tauna riu e vaivaiena, be dobu yawasanidima nuaboyedi be dobu waiguyaudima wainuapaḡoedima mate ta saḡa be Mamaitua riunama ta yavanidi, da nam tima banibanina. ");
INSERT INTO dww_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Be banaga ḡesaunama tauna maika pesi doḡa verene kumakumanama, tauna riu e vaivaie, e paḡopaḡo, be e vovo teyeteyedina, tauna votanama 100 bo 60 bo 30.” ");
INSERT INTO dww_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu wainasi ḡesaunama ya riuedina, “Mamaitua na waiguyaunama inam maika banaga tenaḡa na sipie pesi veredima ya kumedina. ");
INSERT INTO dww_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Be tauna kupie ya kenakenana raḡanine, na ḡaviama ya tava da pesi gewegewedima inam sipine pesi veredima nopodiḡa ya kuma nawedi be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Be pesi veredima a gogo be buso awai karena raḡanine, pesi gewegewedima mate a gogo tenaḡana. ");
INSERT INTO dww_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Naumeki be sipi taupakinama na taunoyama tauna ḡarone a tava be a riuna, ‘Bada, tam pesi veredima sipie kuya kumedina, be uma pesidima gewegewedima aikedae a tava be ta gogogogo?’ ");
INSERT INTO dww_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Be tauna ya paribeedi be ya riuna, ‘Inam ḡavia tenaḡa ya tava be nama ya voiana.’ Be na taunoyama a riuna, ‘Nema kwa noḡonoḡota bake, tauma ka naḡo ka kamoḡa poraḡa bo avedi?’ ");
INSERT INTO dww_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Be tauna ya riuna, ‘Avedi! Baninama deḡoda pesi gewegewedima ko kamoḡana, taumi tokare pesi veredima mate ko kamoḡa tenaḡedina. ");
INSERT INTO dww_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nakarua, ko gosedi da matabudi ta gogo tenaḡana naumeki da dariḡa raḡanine tokare tà kitedina. Inam raḡanine tokare taudariḡa ya riuedi da taudi tokare pesi gewegewedima a gogogogona, ta kamoḡa poraḡa da ta pani boinidi be kai matane ta gabu gorudina. Muriḡa pesi veredima a gogogogona, ta kamoḡa da ta ragau saḡedina yau vadae.’” ");
INSERT INTO dww_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Be Yesu wainasi ḡesaunama ya riuedina, “Mamaitua na waiguyauma inam kai yauḡana pesinama maika, banaga ya paḡo be na sipie ya kumana. ");
INSERT INTO dww_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Inam pesinama ya ḡaubo kauana be banaga ya paḡo da na sipie ya kumana, be ya gogogogona raḡanine kai matabudi ya saḡa poredi, be kaibada ya tubuḡana. Be kiu ta tava be kainama ragane ta noḡinoḡina.” ");
INSERT INTO dww_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Be wainasi ḡesaunama mate ya riuedina, “Mamaitua na waiguyauma inam maika yist waivi ya paḡo, parawa nopone ya biridi, be ya gwada da parawa ya sasana be ya morabana.” ");
INSERT INTO dww_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu uma yabedima matabudi patara ḡarodie wainasie ya giuedina. Tauna yaba matabudi wainasie ya giuedina, be nam i giugiu ḡomana. ");
INSERT INTO dww_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Inam kauidima peroveta boni ya riuriuedina nama yodi a tubuḡana. Peroveta boni umanama ya riuna, “Taugu muduguma yà kaipore be wainasie yà giuna. Boni dobu ya tubutubuḡe da yodi, giu semosemodima a kenakenana, be yodi giudima semosemodima vutudi yà giuedina.” ");
INSERT INTO dww_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Dabudine Yesu patara ya gosedi be ya naḡona vadae. Be na tauwai muriwatanama tauna ḡarone a tava be a riuena, “Bada, mui sipie a gogogogona wainasidima sibo kuya giu waibate be kè vaie.” ");
INSERT INTO dww_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Be Yesu ya paribeedi be ya riuna, “Pesi veredima taukumedima, tauna inam Banaga Natunama. ");
INSERT INTO dww_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Sipi inam uma dobunama, be pesi veredima inam tauwai sumaḡa, taudi vutudi Mamaitua na waiguyauma natunatunama. Be pesi gewegewedima taudi inam Diaboro natunatunama. ");
INSERT INTO dww_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Be ḡavia tauna aitau pesi gewegewedima ya kumekumedina, tauna inam Diaboro. Be dariḡa raḡaninama inam raḡan damonama, be taudaridariḡa inam taudi anea. ");
INSERT INTO dww_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Be dariḡa raḡanine pesi gewegewedima ta kamoḡa poraḡa da ta pani boinidi, be kai matane ta gabu gorudina. Be raḡan damone inam kauinama nama tokare e tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Banaga Natunama tokare na aneama e riuporaḡa be taudi gewagewa tauwai tubuḡidima be raukosoḡaiḡai banegidima matabudi ta kamoḡa poraḡana maika pesi, ");
INSERT INTO dww_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","be kai matane ta pore nawedina. Be inam dabudine taudi tokare ta yakei be gadigadidima ta sanadididina. ");
INSERT INTO dww_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Inam raḡanine tokare didimana banegidima tamedima na waiguyauma nopone ta mia be ta yana guratana, suara maika. Deḡoda beemima ta kenana, naumeki da koi beavaiana. ");
INSERT INTO dww_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mamaitua na waiguyauma, inam doḡa nopone mane dosinama semosemonama maika. Be banaga tenaḡa inam manenama ya vabanavi be ya rupu porena, be tauna ma nuaverena ya munaḡa ya naḡo da na taragaima matabudi ya raugimaredi, be mane ya paḡona. Yodibe ya munaḡa be inam doḡanama ya gimerina. ");
INSERT INTO dww_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Be mate, Mamaitua na waiguyauma inam taugimara tenaḡa maika, tauna posaru verenama ya wanewanena da sibo ya gimerina. ");
INSERT INTO dww_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Raḡan tenaḡa tauna posaru vere vavasaḡinama ya banavina, be maesinama dosinama. Dabudine tauna ya munaḡa ya naḡo da na taragaima matabudi ya raugimaredi, be mane ya paḡo, yodibe inam posarunama ya gimerina. ");
INSERT INTO dww_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Be mate, Mamaitua na waiguyauma inam sagida maika, banaga topae ta pore, be iyana tabutabu ta konekonedina. ");
INSERT INTO dww_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Raḡanine sagida e moḡamoḡavuna, taudi sagida ta soru tavaite barabarae ta mia be ta dariḡedi da iyana veredima posa nopone tawai ikwedina, be gewegewedima tawai poraḡana. ");
INSERT INTO dww_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Uma kauinama nama tokare raḡan damone e tubuḡana. Inam raḡanine anea tokare ta yovo be didimana banegidima, be gewagewa banegidima ta dariḡedina. ");
INSERT INTO dww_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Be gewagewa banegidima kai matane ta poraḡa nawedi, be dabudine taudi tokare ta yakei be gadigadidima ta sanadididina.” ");
INSERT INTO dww_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Be Yesu na tauwai muriwatanama yai taraviredi be ya riuna, “Uma giudima matabudi koya kataiedi, bo ibewa?” Be taudi a paribee be a riuna, “Ee, kè kataiedina.” ");
INSERT INTO dww_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Be Yesu ya riuedina, “Tarawatu tauwai katakataidima taudi Mamaitua na waiguyauma a katakataiena raḡanine, taudi vada taupakinama maika a tubuḡana. Vutuna aubainama taudi vada nopone ta saḡa be taragai vaudi da poredima sivusivudima ta ragaragau dobiḡedina.” ");
INSERT INTO dww_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Raḡanine Yesu wainasi giunama yawai kovidina, tauna inam dobunama ya gose pore, be ya naḡona wari kedae. ");
INSERT INTO dww_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tauna ya munaḡana na meagai ḡomae, be dabudine tauna sinagog nopone ya saḡa, be banaga yawai katakataidina raḡanine, taudi a basa kaue be a riuna, “Uma baneginama deḡo dabudine nuauyauya, be mataira rewapanidima ya ragaudi be uma yabedima e voivoiedi? ");
INSERT INTO dww_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tauna kabe tauwai kamda natuna, be tinanama Meri tauma kè kataiena. Be tasitasinama inam Jeims, Jousep, Saemon be Judas. ");
INSERT INTO dww_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Be nuvunuvunama matabudi kauanema diade ta miamiana. Tauna uma rewapanidima deḡo dabudi ya ragaudi?” ");
INSERT INTO dww_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Inam dabudine taudi Yesu a tuaḡaiena. Be Yesu ya riuedina, “Peroveta na meagai ḡomae, be na vada ḡomama banegidima tauna nam ti vivirena.” ");
INSERT INTO dww_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Vutuna aubainama inam meagaine Yesu mataira nam toitoi i voiedina, baninama taudi nam ti sumaḡena aubainama. ");
INSERT INTO dww_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Inam raḡanine guyau Herod tauna Yesu varinama ya vaivaiena, ");
INSERT INTO dww_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","tauna na taunoyama ya riuedina, “Uma baneginama agunai Jon tauwai babataito, tauna gurie be ya midisuḡu munaḡana, vutuna aubainama rewapana ḡarone ta kenakenana da mataira e voivoiedina.” ");
INSERT INTO dww_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod umanama ya giugiuna, baninama tauna noḡone Jon yai gurina. Jon umanama ya gurina: Herod tuaḡanama Pilip na waivima isanama Herodias ya kwayana, be inam kauinama debane Jon Herod ya riuriuena da nam nama sibo ya voie, vutuna aubainama Herod na tauiḡarama ya riuedi be Jon a vunuḡi da a pani be dibure a boruna. ");
INSERT INTO dww_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Be Jon tauna yaḡoro da Herod umanama ya riuriuena, “Inam nam i verena da Herodias kwa naḡi, baninama inam tuaḡamma na waivima.” ");
INSERT INTO dww_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Inam riunama aubainama Herod ya ḡoena da Jon sibo yai gurina. Be tauna banaga ya nairedina, baninama banaga taudi a noḡonoḡotina da Jon tauna peroveta. ");
INSERT INTO dww_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Be Herod na kaba tubuḡama soinama ya voivoiena nopone, Herodias natunama waivinama ya biga be Herod yai nuavere kauena. ");
INSERT INTO dww_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Vutuna aubainama guyau Herod ya sauga wapa be umanama ya riuena, “Aba kwai baḡena yà utemna.” ");
INSERT INTO dww_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naumeki da gomana tinanama na ḡoanama aubainama guyau Herod ya riuena, “Taugu yà ḡoeḡoena yodi Jon debanama dabire kwa boru, be kwa uteguna.” ");
INSERT INTO dww_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Be inam giunama guyau ya kawa nuaboya kauena, be tauna nam teneteneḡina da gomana sibo ya rawaḡaiḡaie, baninama Herod noḡone na warema matedie ya sauga wapana. Naumeki da guyau yai aninana da gomana na ḡoanama tokare e utena. ");
INSERT INTO dww_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Be na tauiḡarama ya riue da ya naḡo dibure, be Jon gadonama ya tomna. ");
INSERT INTO dww_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Naumeki da tauiḡara Jon debanama dabire ya boru, be gomana guguininama ya ute, da ya kiroḡi nawe be tinanama ya utena. ");
INSERT INTO dww_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Naumeki da Jon na tauwai muriwatanama a verau be Jon tubuḡinama a kiroḡa nawe, be a dobona. Yodibe a naḡo da Yesu ai varina. ");
INSERT INTO dww_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu Jon varinama ya vaivaiena raḡanine, tauna wagae ya geru be ya naḡona gabu wainuatuḡune. Be patara ta vaiena be Yesu gabu wainuatuḡune ya naḡona. Naumeki da banaga taudi adi meagaima a gosaḡa be a doka ḡomedi be kaḡediḡa geresaḡa a naḡona. ");
INSERT INTO dww_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Raḡanine Yesu gerese ya ḡotaḡotana, dabudine e kitana be patara dosinama a miamiana. Naumeki da Yesu taudi ya raunuatoiedi be banaga sidesidedima yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Be suara ya yovoyovona raḡanine, na tauwai muriwatanama Yesu ḡarone a verau be a riuna, “Bada, uma inam mutuyuae tà miamiana, be kaiteka ravi e tavatavana. Banaga kwa riupore nawedi da meagaie ta naḡo da adi kanima ta gimarana.” ");
INSERT INTO dww_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Be Yesu ya paribeedi be ya riuna, “Taudi nam ta naḡo. Taumi kani ko utedina.” ");
INSERT INTO dww_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Be taudi a riuena, “Be tauda buredi 5 be iyana rabui kavakava ta kenakenana.” ");
INSERT INTO dww_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Be Yesu ya riuedina, “Ko verauḡedi ḡarogue.” ");
INSERT INTO dww_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Naumeki da banaga ya riuedi be mui debedie a miana. Yodibe tauna buredi 5 be iyana rabui ya ragaudi, gunume yai kita saḡa da yai kaiwa be buredi ya givana. Yodibe na tauwai muriwatanama ya utedi, be taudi banaga a ute nawedina. ");
INSERT INTO dww_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dabudine banaga matabudi a kani da a kani siauana. Naumeki da tauwai muriwatana banaga kani a kanikani gosedina, taudi a rawateḡeteḡeidi be posa matabudi 12 ai moḡavudina. ");
INSERT INTO dww_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Banaga dabudine a kanina, tautauḡoma sievinama 5 tausand be waiwaivi seda mate nam ti sievidina. ");
INSERT INTO dww_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Inam kauinama murine Yesu na tauwai muriwatanama wagae ya riuporedi da taudi a doka be yawawa a davu da noaḡo nevane a naḡona. Muriḡa Yesu banaga ya riuporedi be a naḡona adi meagaie. ");
INSERT INTO dww_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Be banaga a naḡonaḡona muridie, tauna ya naḡona oya debane, moiragi aubainama. Be ravi ya tavatavana raḡanine, Yesu taunaḡa dabudine ya miamiana, ");
INSERT INTO dww_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","be waga kaiteka yawawa poune ya naḡonaḡona, be sive dosinama aubainama, rabama waga ya katikati vitarena. ");
INSERT INTO dww_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Be raḡan tomtom Yesu topa debane ya babara be ya naḡonaḡona taudi ḡarodie. ");
INSERT INTO dww_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Be dabudine na tauwai muriwatanama ta kitana be tauna topa debanaḡa ya veraverauna ḡarodie. Inam raḡanine taudi a naira kaua, a rasa be a riuna, “Ḡaḡarua e veraverauna.” ");
INSERT INTO dww_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Be Yesu waiḡapa ya riu makai be ya riuedina, “Nam ko naira, taugu.” ");
INSERT INTO dww_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dabudine Pita ya riuena, “Bada, deḡoda riukaua tam, naumeki da kwa riu be taugu topa debanaḡa ḡarome yà verau.” ");
INSERT INTO dww_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Dabudine Yesu ya paribee be ya riuna, “Kwa verau.” Naumeki da Pita waga ya dobi pore be topa debanaḡa ya babara be Yesu ḡarone naḡonama yai karena. ");
INSERT INTO dww_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Be tauna sive be rabama ya kitedi be ya nainairana raḡanine, tauna daururu yai karena, inam raḡanine tauna ya yogona, “Bada, kwai yawasanigu!” ");
INSERT INTO dww_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Be Yesu waiḡapa nimanama yai yoyo be Pita nimane ya kaididi da ya sorusaḡe be ya riuna, “Am waisumaḡama ya ḡaubo ḡaḡa, aba aubainama kuya noḡota bekubeku?” ");
INSERT INTO dww_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Be taudi wagae a saḡasaḡana raḡanine, sive be rabama ai kavena. ");
INSERT INTO dww_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dabudine taudi aitauḡa wagae a gerugeruna, matabudi Yesu a raudunee be a riuna, “Tam riukaua Mamaitua Natunama.” ");
INSERT INTO dww_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dabudine taudi yawawa a davu be a naḡona naumeki da Genesaretma a ḡotana. ");
INSERT INTO dww_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Be tautauḡoma dabudine Yesu a kitakitana, taudi Yesu varinama inam dobunama matabuna nopone ai daberarina, be banaga sidesidedima a verauḡedina Yesu ḡarone. ");
INSERT INTO dww_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Be Yesu ai baḡana da tauna sibo yai aninedi, be taudi na garama isunaḡa sibo a taukonina. Be banaga aitauḡa na garama a tautaukonina, taudi matabudi a yawasanana. ");
INSERT INTO dww_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dabudine Parisi be tarawatu tauwai katakataidima ḡesaudima Jerusalemma be Yesu ḡarone a tava be ai taravirena, ");
INSERT INTO dww_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Aba aubainama tam am tauwai muriwatanama dà babadama adi vaivaima tawai kati kotovidi? Taudi kani raḡanine, nam nimedima tima koḡedi be ta kanikani yababana.” ");
INSERT INTO dww_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Be Yesu ya paribeedi be ya riuna, “Be taumi aba aubainama ami vaivaima kowai muriwatanedi, be Mamaitua na riuvavasaḡama kowai kati kotovidi? ");
INSERT INTO dww_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Baninama Mamaitua umanama ya riuna, ‘Tamamma be tinamma kwa viviredina!’ be ‘Aitau tamanama bo tinanama ei tara tautauena, tauna gurie ta boruna.’ ");
INSERT INTO dww_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Banaga aitau na dosima sagudima aubainama yaba ḡarone a kenakenana sibo ya ragaudi be na dosima ya sagudina. Be taumi ami waikatakataima kana taiye tauna inam yabedima ya ragaudi be na dosima ya riuedina, ‘Uma yabedima taumi sibo è sagumina, be yodi Mamaitua puyonama aubainama taumi nam yà utemi.’ ");
INSERT INTO dww_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Inam raḡanine taumi ko riuriuna, ‘Tam ya verena da Mamaitua kwa puyona, be am dosima nam kwa sagudi.’ Inam waikatakataidie taumi Mamaitua na riuvavasaḡama ko kawakawa koakoana, be taumi ami vaivaima ko kawakawa saḡena. ");
INSERT INTO dww_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Taumi banaga kaikaiyovumima. Aisaia na waiperovetama inam ya riu kauana. Mamaitua umanama ami kauama ya giuena, ");
INSERT INTO dww_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Uma banegidima mududiḡa e riuriuna, “Mamaitua, isamma ka kaikai suḡusuḡuna” be taudi nopodima madanie. ");
INSERT INTO dww_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Taudi adi raudunema ḡarogue nam baniboruboruna. Baninama taudi adi waikatakataima inam banaga tarawatu a voivoiedina, vutudi banaga tawai katakataidina.” ");
INSERT INTO dww_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dabudine Yesu patara ya rawateḡeidi be ya riuedina, “Koi beavaia be ko kataiena. ");
INSERT INTO dww_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yaba aba banaga gayane e saḡasaḡana, tokare noponama nam ei mira, ibewa, be aba banaga nopone be gayane e dobidobina, inam vutuna taunaḡa noponama ewai mirana.” ");
INSERT INTO dww_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dabudine na tauwai muriwatanama ḡarone a tava be a riuena, “Bada tam kuya kataie bo ibewa da Parisi am giuma a vaivaiena, taudi nuedima ai medi kauana?” ");
INSERT INTO dww_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu ya paribeedi be ya riuna, “Tamaguma marae tauna deḡo kaidima nam i kumedina, inam kaidima tokare ma waramidi e kamoḡa poraḡana. ");
INSERT INTO dww_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Vutuna aubainama inam banegidima ko gose poredina. Taudi tauwai dokadokana matapotepotedima. Be deḡoda banaga matapotapotanama turanama matapotapotanama ewai dokena, taudi rabuidi tokare dakie ta bekuna.” ");
INSERT INTO dww_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Be Pita ya riuna, “Bada, uma wainasinama kwa giu waibate be ka vaie.” ");
INSERT INTO dww_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Be Yesu taudi ya riuedina, “Taumi yaḡoro ko nuanua babaḡa, bo? ");
INSERT INTO dww_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Koya kataie bo ibewa da yaba aba banaga gayane e saḡasaḡana, tokare kapone e naḡo da noveḡo e dobi munaḡa? ");
INSERT INTO dww_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Be aba banaga nuapoune be e saḡa da gayane e dobidobina, inam vutuna tauname ewai mirana. ");
INSERT INTO dww_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Baninama banaga nuapoune noḡota gewegewedima ta tavatavana, maika rauvunuḡa, badara, waisoḡa yabayababa, danene, kaiyovu, waikarakarakutu bo waidiboḡa. ");
INSERT INTO dww_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Inam kauidima vutudi banaga noponama tawai mirana. Be deḡoda nimamma nam kwa koḡa be kwa kanina, inam nam nopomma kumawai mirana, ibewa.” ");
INSERT INTO dww_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Dabudine Yesu inam gabunama ya gose be ya naḡona Taia be Saidonma. ");
INSERT INTO dww_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Be dobudine Keinan waivinama ya verau tauna ḡarone be bonanama dosine ya riuna, “Bada, tam guyau Deivid natunama, kwa raunuatoiegu! Penama natuguma waivinama ya koku be ewai nuatoitoi kauana.” ");
INSERT INTO dww_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Be Yesu nam aba i riuena. Vutuna aubainama Yesu na tauwai muriwatanama Yesu a riuena, “Kwa riue be ḡavoe e naḡo, tauna muridaḡa e naḡo be ya yogo makamakai be nam i verena.” ");
INSERT INTO dww_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dabudine Yesu inam waivinama ya paribee be ya riuna, “Israel banegidima taudi sipu kwakokwakodima maika. Be Mamaitua ya riuporeguna da taudiḡa sibo è sagudina.” ");
INSERT INTO dww_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Be waivi Yesu noḡone tuapikane ya raupari be ya riuna, “Bada, kwa sagugu!” ");
INSERT INTO dww_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Be Yesu ya paribee be ya riuna, “Inam nam i verena da seda adi kanima yà paḡo be daḡadaḡasi yà utedi.” ");
INSERT INTO dww_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Be waivi ya riuna, “Bada, inam riukaua! Be kwa noḡoti da guni debane seda kani kurekuredima ta tatai kuruvidina, yaḡoro daḡadaḡasi ta tava be ta kanikanina.” ");
INSERT INTO dww_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Be Yesu ya paribee be ya riuna, “Tam waivimma, am waisumaḡama ya moraba kauana, vutuna aubainama naumeki da aba kwawai baḡena, nama e tubuḡana.” Yesu ya giugiuna raḡanine, waivi natunama ya yawasana munaḡana. ");
INSERT INTO dww_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu inam dobunama ya gose be Galili yawawinama dianaḡa ya naḡona. Naumeki da tauna ya saḡa ya naḡo oya babedie, be dabudine ya miana. ");
INSERT INTO dww_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dabudine patara dosinama adi banagama tuera ragaragaudima da matapotepotedima da nuakudukududima da gumgum be sida ḡesaudima ragaragaudima mate ai doka tavaitedina. Da Yesu noḡone ai mienidi be tauna banaga sidesidedima matabudi yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Inam raḡanine gumgum giu ai karena, be banaga nuakudukududima a vere munaḡana, be tuera ragaragaudima babara ai karena, be matapotepotedima ai kitana. Uma kauinama banaga a kitakitana, taudi a base kaue, be Israel adi Mamaituama isanama a kaisuḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu na tauwai muriwatanama ya rawateḡeidi be ya riuedina, “Taugu uma banegidima yà rarau nuatoiedina, baninama taudi raḡan rabuiteḡa nopodie tauda mate uma dabudi tè mia be taudi nam aiyaba ti kani rubuna da yodi. Be taugu nam ama ḡoeḡoena da taudi ma kaniguridi yà riuporedi, deḡoda kedae ta raumoyaḡasuna.” ");
INSERT INTO dww_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Be na tauwai muriwatanama a riuna, “Tauda mutuyuae tà miamiana, be yodi deḡo kani tà paḡo be umanama patarinama tài kanidi?” ");
INSERT INTO dww_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dabudine Yesu yai taraviredina, “Taumi buredi bisa ḡaromie ta kenakena?” Be taudi a riuna, “Buredi 7 be iyana ḡauḡaubodima raubisaḡa.” ");
INSERT INTO dww_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Naumeki da Yesu banaga ya riuedi da doḡae a miana. ");
INSERT INTO dww_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yodibe tauna buredi 7 be iyana ya ragaudi, Mamaitua yai kaiwe, be buredi ya giva da na tauwai muriwatanama ya utedi, be taudi banaga a ute nawedina. ");
INSERT INTO dww_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dabudine banaga matabudi a kani da a kani siauana. Be kani murine tauwai muriwatana banaga kani a kanikani gosedina, taudi a rawateḡeteḡeidi be posa matabudi 7 ai moḡavudina. ");
INSERT INTO dww_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Banaga dabudine a kanina tautauḡoma sievinama 4 tausand be waiwaivi seda mate nam ti sievidina. ");
INSERT INTO dww_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Naumeki da Yesu patara ya riuedi da a naḡona adi meagaie, be tauna wagae ya saḡa be ya naḡona Magadanma. ");
INSERT INTO dww_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi be Sadisi taudi Yesu ḡarone a tavana, raurubunama aubainama, taudi Yesu ai baḡana da sibo mara matairinama ya voie be a kitana. ");
INSERT INTO dww_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Be tauna ya riuna, “Deḡoda kupi e tava be gunuma ei siana raḡanine, taumi ko riuriuna, ‘Pomai inam komra.’ ");
INSERT INTO dww_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Be raḡanboiboi deḡoda dobu e ḡuva be gunuma e dubadubana raḡanine, taumi ko riuriuna, ‘Manaka tokare kusana e dobina.’ Taumi gunume yaba ta tubutubuḡana kita wairuvedima koya kataiena, be yodi raḡandima matairidima kita wairuvedima nam koma katakataiedina. ");
INSERT INTO dww_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Taumi kimtimima gewagewa be badara banegimima, taumi yodi mataira kitanama ko ḡoeḡoena. Be nam tokare mataira ko kita, ibewa da taumi peroveta Jona ḡarone aba ya tubuḡana, vutunaḡa tokare ko kitana.” Dabudine Yesu taudi ya gosedi be ya naḡo poredina. ");
INSERT INTO dww_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Taudi yawawa a davu be a naḡonaḡona raḡanine, Yesu na tauwai muriwatanama nuedima ya koana da buredi nam ti ragaudina. ");
INSERT INTO dww_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Be Yesu ya riuedina, “Parisi be Sadisi adi yistma ko kita kauedina.” ");
INSERT INTO dww_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Naumeki da tauwai muriwatana uma kauinama ai giu vivivire be a riuna, “Tauda nam buredi te ragaudina, vutuna aubainama tauna nama ya riuna.” ");
INSERT INTO dww_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Be Yesu ya kataie da taudi aba a giugiuena, vutuna aubainama tauna umanama ya riuedina, “Taumi ami waisumaḡama ya ḡaubo ḡaḡa. Aba aubainama ko riuriuna da taumi ḡaromie nam buredi? ");
INSERT INTO dww_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Taumi aba koya kitakitana yaḡoro nam ko kataie, bo? Taugu buredi 5 be banaga 5 tausand èi kanidina, be posa bisa koyai moḡavudina, vutudi nam koma noḡonoḡoti, bo? ");
INSERT INTO dww_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Be taugu buredi 7 be banaga 4 tausand èi kanidina, be posa bisa koyai moḡavudina, vutudi nam koma noḡonoḡoti, bo? ");
INSERT INTO dww_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Taugu yaba yà giugiuedina aba aubainama taumi nam koma katakataiedi, taugu nam buredi ama giugiuena, ibewa. Taugu Parisi be Sadisi adi yistma ko kita kauedina, vutuna taugu yà giugiuena.” ");
INSERT INTO dww_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Inam raḡanine taudi a kataie da tauna nam buredi kana yistma i giugiuena, ibewa da Parisi be Sadisi adi waikatakataima kaikaiyovudima ya giugiuena. ");
INSERT INTO dww_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Raḡanine Yesu Seseria-Pilipai meagaine ya tavatavana, tauna na tauwai muriwatanama yai taraviredi be ya riuna, “Banaga nema ta riuriu bako? Banaga Natunama tauna aitau?” ");
INSERT INTO dww_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Be taudi a paribee be a riuna, “Banaga ḡesaudima ta riuriuna da Elaija, be ḡesaudima ta riuriuna da kabe Jerimaia bo ai peroveta tenaḡa kabe i tavatava.” ");
INSERT INTO dww_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Be tauna yai taraviredi be ya riuna, “Be taumi nema ko noḡonoḡota bako, da taugu aitau?” ");
INSERT INTO dww_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Dabudine Pita ya paribee be ya riuna, “Tam Tauwai yawasana, Mamaitua yawayawasaninama natuḡominama.” ");
INSERT INTO dww_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Be Yesu Pita ya riuena, “Saemon Jona natunama, tam Mamaitua ei aiainimna, baninama uma noḡotinama nam banaga ti kataimna, ibewa da Tamaguma marae tauna vutuna ḡarome yai maḡatarina. ");
INSERT INTO dww_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Be taugu yà riuemna da tam Pita inam yeku. Be inam yekunama debane taugu yau ekalesiama yà kerina, be guri tokare nam inam ekalesianama e vaisuba be teneteneḡina. ");
INSERT INTO dww_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Taugu mara waiguyaunama kiḡinama tam tokare yà utemna. Vutuna aubainama tam aba dobue kwa panipanina, nama marae e panina. Be aba dobue kwa kuvekuvesina, nama marae e kuvesina.” ");
INSERT INTO dww_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Inam dabudine na tauwai muriwatanama ya riuedina da nam aitau sibo a riue, da tauna vutuna Keriso. ");
INSERT INTO dww_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Inam raḡanine da nokoi ya naḡona Yesu tauna na tauwai muriwatanama ya giu waibatedina, da tauna tokare e naḡona Jerusalemma. Be dabudine babada dosidima, be pirisi adi babadama, be tarawatu tauwai katakataidima, matabudi taudi Yesu ta raukivi gewegewe, be tai gurina. Be raḡan aniwai rabuiteḡane tauna tokare e midisuḡu munaḡana. ");
INSERT INTO dww_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Inam raḡanine Pita Yesu yai doke ḡavoe ya nawe be yai ḡake be ya riuna, “Avedi Bada, Mamaitua na sague inam kauinama nam ḡarome e tubuḡa!” ");
INSERT INTO dww_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Dabudine Yesu yai tautinamuri be Pita ya riuena, “Kwa naḡo ḡavoe Seitan! Tam yau kedama kwa guduguduna, tam am noḡotama nam Mamaitua ḡarone be tima yovoyovona. Tam inam banaga adi noḡotama kwa giugiuena.” ");
INSERT INTO dww_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Inam raḡanine Yesu na tauwai muriwatanama ya riuedina, “Deḡoda aitau waimuriwataneguma e ḡoena, naumeki da na ḡoanama matabuna e gosedi, be na korosima e kiroḡi da ei muriwataneguna. ");
INSERT INTO dww_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tam aitau tame am yawasanama kwa kaididi be kwa raberabena, tokare am yawasanama kwa kawa gewagewana, be tam aitau da taugu kautaiye am yawasanama kuyai utaena, naumeki da am yawasanama tokare kwa banavina. ");
INSERT INTO dww_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Be deḡoda aitau dobu yabedima matabudi e ragaragaudina, be e gurina raḡanine, inam yabedima tauna nema ta sagu bake, da yawasana kenakena nonoḡinama e paḡo? Bo aba ei utae da na yawasanama e paḡo munaḡe? ");
INSERT INTO dww_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Baninama Banaga Natunama tokare Tamanama neneḡarine na aneama mate ta yovona. Yodibe banaga tenatenaḡaḡa aba a voivoiedina ruvane nama tokare ei maesidina. ");
INSERT INTO dww_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Taugu yà riuriu kauemina da taumi ḡesaumima yodi uma dabudi ko midimidina tokare nam ko guri, naumeki da Banaga Natunama ei rawaguyau be e verauna ko kitana.” ");
INSERT INTO dww_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Raḡan 6 muridie Yesu na tauwai muriwatanama Pita, Jeims be tasinama Jon yai dokedi be taudiḡa oya daudaunama debane a naḡona. ");
INSERT INTO dww_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Taudi oya debane a tavatavana, dabudi ta kitana be Yesu kitanama ya boru vitarena. Tauna noḡonama yai matakanikanina maika suara, be na garama a ḡavorana maika suara boruminama. ");
INSERT INTO dww_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Inam kauinama ya tubutubuḡana nopone, ta kitana be Mousis be Elaija Yesu mate awai giuna a kitedina. ");
INSERT INTO dww_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Naumeki be Pita Yesu ya riuena, “Bada, ya vere kauana da tauma mate uma dabudine. Deḡoda tam kwa ḡoena, taugu kape rabuiteḡa yà voiedina, tenaḡa tam aubaimma, tenaḡa Mousis be tenaḡa Elaija.” ");
INSERT INTO dww_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita yaḡoro ya giugiu be giyou ḡavoḡavora tunutununama ya yovoyovona ya suma tawedina. Dabudine bona giyou nopone ya dobi be ya riuna, “Uma inam taugu natuḡomiguma, tauna ewai nuavereguna, bonanama ko vaiena!” ");
INSERT INTO dww_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Be tauwai muriwatana nama giunama a vaivaiena, taudi a naira kaua, be noḡodie a beku be doḡae a ravusedina. ");
INSERT INTO dww_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Naumeki be Yesu ya verau da ya taukonidi be ya riuna, “Ko midisuḡu, nam ko naira.” ");
INSERT INTO dww_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Inam raḡanine taudi a tausuḡudi be ai kita da Yesu taunaḡa a kitana, be nam aitau ḡesau dabudi ti kitana. ");
INSERT INTO dww_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Naumeki da taudi oyae be a dobi a munamunaḡana raḡanine, Yesu taudi umanama ya riuedina, “Taumi aba koya kitakitana nam aitau tenaḡa ko riue, naumeki da Banaga Natunama gurie be e kawa midisuḡu munaḡena.” ");
INSERT INTO dww_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dabudine tauwai muriwatana Yesu ai taravire be a riuna, “Aba aubainama tarawatu tauwai katakataidima ta riuriuna da Elaija tauna noḡone e yovo doka?” ");
INSERT INTO dww_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dabudine Yesu ya paribeedi be ya riuna, “Inam riukaua, Elaija tauna tokare e yovo doka be yaba matabudi e kawa nonoḡidina. ");
INSERT INTO dww_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Be uma yà riuemina, Elaija tauna kaite ya yovona, be banaga tauna a nuababaḡena, vutuna aubainama taudi adi ḡoanama nama tauna ḡarone a voivoiedina. Inam banegidima tokare kauinama teneḡine nama Banaga Natunama ta raukivi gewegewe be ei nuatoitoina.” ");
INSERT INTO dww_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Inam raḡanine na tauwai muriwatanama a kataiena, da tauna taudi ḡarodie Jon tauwai babataito ya giugiuena. ");
INSERT INTO dww_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Raḡanine taudi patara ḡarodie a dobidobina, dabudine tauḡoma tenaḡa ḡarodie ya tava be Yesu noḡone tuapikane ya raupari ");
INSERT INTO dww_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","be ya riuna, “Bada, natuguma kwa raunuatoie! Tauna muya e kawakawa guri, be e rarau gurerena. Tauna kana raḡanie e beku be kai matane e naḡonaḡona, be wari raḡanie upa nopone e naḡonaḡona. ");
INSERT INTO dww_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Taugu è verauḡena am tauwai muriwatanama ḡarodie, da taudi a raurubuna, be nam ti yawasanina.” ");
INSERT INTO dww_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Be Yesu ya paribee be ya riuna, “O banaga nam waisumeḡimi, ami nuababaḡama ya moraba ḡaḡa. Taumi mate tà mia ḡaḡa be yà noya ḡaḡaemi? Gomana ko verauḡe uma ḡarogue.” ");
INSERT INTO dww_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Inam dabudine Yesu penama ya riutuaḡaie be penama gomana ya dobi porena. Naumeki da inam raḡanine gomana ya yawasana munaḡana. ");
INSERT INTO dww_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Be tauwai muriwatana taudiḡa muriḡa a verau Yesu ḡarone da ai taravire be a riuna, “Aba aubainama tauma penama kè tavu be nam i naḡo?” ");
INSERT INTO dww_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Be tauna ya paribeedi be ya riuna, “Inam baninama taumi nam ami waisumaḡama i morabana. Yà riuriu kauemina taumi ami waisumaḡama i morabana kai yauḡana pesinama maika, taumi tokare kaua oyanama koya riuena, kwa midisuḡu be noa dabudi kwa naḡo, be oya tokare ya naḡona. Be nam aiyaba tokare ḡaromie ya piripiri. ");
INSERT INTO dww_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Penama inam nama kitedima tokare nam aiyaba e tauriedi, ibewa da widina be moiragie tokare e tauriana.” ");
INSERT INTO dww_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Be tauwai muriwatana matabudi Galilima awai rawateḡeidina raḡanine, Yesu umanama ya riuedina, “Banaga Natunama kaiteka banaga nimedie ta boru nawena. ");
INSERT INTO dww_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Be taudi tokare tai gurina, be raḡan wairabuiteḡane Mamaitua tokare tauna ei yawasani, be e kawa midisuḡu munaḡena.” Dabudine tauwai muriwatana nama a vaivaiena, taudi ai nuaboya kauana. ");
INSERT INTO dww_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Be Yesu na tauwai muriwatanama mate Kapeniamma a tavatavana raḡanine, tempol teksnama tautaminama baneginama ya tava da Pita yai taravire be ya riuna, “Ami tauwai katakataima tauna tempol teksnama ewai maesi bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Naumeki da Pita ya paribee be ya riuna, “Ee, ewai maesina!” Be raḡanine Pita vadae ya saḡasaḡana, Yesu Pita yai taravira doke be ya riuna, “Saemon, tam aba kwa noḡonoḡoti, guyaguyau dobue aitau ḡarodie teks ta tamatama? Natunatuḡomidima ḡarodie bo banaga ḡesaudima ḡarodie?” ");
INSERT INTO dww_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Dabudine Pita ya paribee be ya riuna, “Banaga ḡesaudima ḡarodie.” Dabudine Yesu Pita ya riuena, “Naumeki da tauda adi sedama aubainama nam tài maesa. ");
INSERT INTO dww_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Be deḡoda tama kawa nopogewegewedi aubainama, kwa naḡo da topae kwa dobi da am kaimoma kwa porena. Be aba iyeninama kwa kaimo dokena, inam iyeninama gayane kwa kitana mane e kenakenana. Inam vutuna kwa paḡo da teks tautaminama kwa utena, taugu be tam aubaidama kwai teksna.” ");
INSERT INTO dww_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Inam raḡanine tauwai muriwatana Yesu ḡarone a verau be ai taravirena, “Bada, Mamaitua na waiguyauma nopone aitau ya saḡa gurata?” ");
INSERT INTO dww_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dabudine Yesu gomana ḡaubonama ya riue da ya verau be poudie ya midina. ");
INSERT INTO dww_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Yodibe ya riuna, “Taugu yà riuriu kauemina, deḡoda tam aitau am yawasanama nam kwa vitare seda adi yawasanama maika, tam nam tokare Mamaitua na waiguyauma nopone kwa saḡa. ");
INSERT INTO dww_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Vutuna aubainama deḡoda tam aitau am yawasanama kwa vitare be kwa ḡaubo munaḡana uma gomeninama maika, tam tokare Mamaitua na waiguyaue am banagama poudie kwa saḡa guratana. ");
INSERT INTO dww_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Be aitau da gomana ḡaubonama maika uma gomeninama taugu isague ewai aninena, tauna taugu ewai anineguna. ");
INSERT INTO dww_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Be deḡoda ai banaga ewai sumaḡeguna gomana ḡaubonama maika, be banaga ḡesau e verau be e voie da inam baneginama aitau ewai sumaḡeguna gewagewa ei tubuḡina, ya verena da inam baneginama gewagewa tauwai karenama gadone yeku dosinama ta pani be egasie tai daururuna. ");
INSERT INTO dww_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Taumi aitauḡa dobue ami banagama adi waisumaḡe kowai kedadoka waigewedina, taumi ko kita kauana! Raurubu riukaua tokare ta tavana, be aitauḡa da tauraurubu, taumi ko kita kauana! ");
INSERT INTO dww_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Deḡoda nimamma bo kaḡamma e voiem da gewagewa kwa voivoiena, naumeki da kwa douraka be kwa porekaiyatina. Ya verena da kaḡamma tenaḡa be nimamma tenaḡa mate yawasana nopone kwa saḡana, be nam rabui mate da tam kai karakarata nonoḡine ta pore nawemna. ");
INSERT INTO dww_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Be deḡoda matamma e voiem be gewagewa kwa voivoiena, naumeki da kwa kunavai be kwa porekaiyatina. Ya verena da matamma tenaḡa mate yawasana nopone kwa saḡana, be nam rabui mate da gienae kai karakaratine ta pore nawemna. ");
INSERT INTO dww_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ko kita kaua da uma tauwai sumeḡidima ḡauḡaubodima nam ko kita waiyovoḡedi, baninama taudi adi aneama raḡan matabuna marae Tamaguma noḡone ta midimidina. ");
INSERT INTO dww_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Banaga Natunama ya yovona, banaga kwakokwakodima waiyawasanidima aubainama. ");
INSERT INTO dww_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Deḡoda banaga tenaḡa ḡarone sipu 100 a miamiana, be tenaḡa i kwakona, tauna tokare aiyaba ya voie, taumi aba ko noḡonoḡoti? Tauna tokare na sipuma 99 oya babane ya gosedi, be ya naḡona na sipuma kwakokwakonama wanenama aubainama. ");
INSERT INTO dww_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Be yà riuriu kauemina, raḡanine na sipuma i banavina, tauna inam sipunama kwakokwakonama aubainama tokare yai nuavere kauana, nam na sipuma ḡesaudima maika. ");
INSERT INTO dww_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Be inam kauinama teneḡinama nama Tamemima marae, tauna nam ima ḡoeḡoena da tauwai sumaḡa ḡaubonama tenaḡa e kwako. ");
INSERT INTO dww_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Deḡoda turamma tauwai sumaḡa ḡesau be gewagewa ḡarome ya voiena, naumeki da tamḡa kwa naḡo ḡarone, be taumiḡa inam piripirinama ko kawa didimanina. Be deḡoda am giuma e vaie be e paḡona, inam naumeki da turamma kuya paḡo munaḡena. ");
INSERT INTO dww_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Be deḡoda am giuma nam e paḡo, naumeki da banaga tenaḡa bo rabui mate kwa ragaudi, be ḡarone ko naḡo da inam piripirinama ko kawa didimanina. Be inam banegidima rabui bo rabuiteḡa taudi aba ko giuedina tai matematena. ");
INSERT INTO dww_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Be tauna deḡoda inam banegidima bonedima yaḡoro nam e paḡo, naumeki da inam kauinama Mamaitua na damma ḡarodie ko giuena. Be tauna Mamaitua na damma adi raukurama yaḡoro nam e vaie, naumeki da tauna ekalesiae be ko boru dobiḡena ḡavoe. Be taumi tauna ko voie da banaga danedanenenama maika, bo banaga isanama gewagewanama maika. ");
INSERT INTO dww_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yà riuriu kauemina da taumi aba dobue ko panipanina, nama marae e panina. Be dobue ko kuvekuvesina, nama marae e kuvesina. ");
INSERT INTO dww_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Be mate uma yà riuemina, deḡoda taumi rabui uma dobue koi anina tenaḡa be aiyaba koi baḡena, tokare Tamaguma marae ami waibaḡama e voiena. ");
INSERT INTO dww_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Baninama deḡo dabudi banaga rabui bo rabuiteḡa isague tai rawateḡeidina, taugu taudi mate dabudine.” ");
INSERT INTO dww_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dabudine Pita Yesu ḡarone ya verau be yai taravirena, “Bada, deḡoda turaguma gewagewa ḡarogue e voiena, raḡan bisa tokare na gewagewama yà noḡota pore, raḡan 7, bo?” ");
INSERT INTO dww_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Be Yesu ya riuena, “Nam 7, ibewa, be raḡan 7 be 70 be debane debane turamma na gewagewama kwa noḡota porena. ");
INSERT INTO dww_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Vutuna aubainama mara waiguyaunama inam maika umanama, guyau dosinama tenaḡa ya tava be na taunoyanama ya rawateḡeidina, baninama ya ḡoeḡoena da sibo ya kataiena, da na taunoyama na manema a rabe kauedi bo ibewa. ");
INSERT INTO dww_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Taudi awai rawateḡeina raḡanine, taudi tauḡoma tenaḡa guyau na manema 10 tausand Talent ya paḡopaḡona, tauna a verauḡena guyau ḡarone. ");
INSERT INTO dww_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Be inam baneginama nam teneteneḡina da sibo guyau na manema yai maesa munaḡe. Vutuna aubainama guyau ya riuna da sibo inam tauḡominama tauname, be na visarama, na sedama be na taragaima matabudi sibo ya gimaredi, da mane sibo ya paḡona. Yodibe guyau na manema sibo ya ute munaḡena. ");
INSERT INTO dww_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dabudine taunoya guyau noḡone tuapikane e raupari be yai baḡa gurate be ya riuna, ‘Ae, guyau kwa raunuatoiegu! Taugu am manema maesinama matabuna tokare yà ute munaḡemna.’ ");
INSERT INTO dww_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naumeki da guyau na taunoyama ya raunuatoiena, aubainama na manema maesinama matabuna ya noḡota poredi, be ya riue da ya naḡona. ");
INSERT INTO dww_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Raḡanine tauḡominama doḡae ya dobidobina, dabudi boni tauna ḡarone turanama ḡesau mane 100 Denari ya paḡopaḡona, vutuna ya banavina, naumeki da turanama gadonama ya kiki be ya riuna, ‘Yau manema kwai maesa makaie.’ ");
INSERT INTO dww_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dabudine turanama tauna noḡone tuapikane ya raupari be yai baḡa gurate be ya riuna, ‘Ae, yau tura kwa raunuatoiegu! Taugu am manema maesinama matabuna tokare yà ute munaḡemna.’ ");
INSERT INTO dww_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Be tauna turanama na riuma ya vaia tuaḡaie, be dibure ya boru nawena. Be dabudi ya miana naumeki da turanama na manema sibo yai maesa rovona. ");
INSERT INTO dww_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Inam raḡanine taunoya ḡesaudima nama a kitakitana, taudi nuedima yai medi kauana. Vutuna aubainama taudi yaba matabudi a tubutubuḡana, a naḡo be guyau ai varina. ");
INSERT INTO dww_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Naumeki da guyau inam tauḡominama ya riue da ḡarone ya saḡa, be ya riuena, ‘Tam taunoya gewagewama! Taugu yau manema maesinama ḡarome matabuna è noḡota porena, baninama tam tuapikame kuya raupari, be kuyai baḡaguna aubainama. ");
INSERT INTO dww_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Be tam turamma nama sibo kuya raunuatoiena, taugu tam è raunuatoiemna maika.’ ");
INSERT INTO dww_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dabudine guyau nuanama yai medi kaua, be inam tauḡominama kivikorokoronama dibure ya boru nawena tauraukivigewagewa banegidima nimedie. Be dabudine ya miana naumeki da guyau na manema sibo yai maesa rovona. ");
INSERT INTO dww_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Taumi deḡoda ami banagama adi gewagewama nam nuemima tabutabune ko noḡota poredi, naumeki da Tamaguma marae tokare taumi ḡaromie kauinama teneḡinama nama e voiem be gienae e pore nawemna.” ");
INSERT INTO dww_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Be Yesu inam giudima yawai kovina raḡanine, tauna Galili ya gose be ya naḡona Judia adi dobue, upa Jodanma be noaḡo nevane. ");
INSERT INTO dww_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Be patara dosinama tauna ai muriwatane be dabudine yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dabudi Parisi ḡesaudima Yesu raurubunama aubainama ḡarone a tava be a riuna, “Deḡoda tauḡoma na noḡotama ruvane na waivima i gosena, inam tokare naumeki bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Dabudine Yesu ya paribeedi be ya riuna, “Taumi girugiruminama porane koya sievi bo ibewa, boni pakane tauwai tubuḡa tauna tauḡoma be waivi ya voiedi, ");
INSERT INTO dww_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","be ya riuna, ‘Tauḡoma tamanama be tinanama ya gosedi be na waivima mate tai rawateḡeidina, da boni taudi rabui be yodi taudi inam tubuḡa tenaḡa.’ ");
INSERT INTO dww_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Vutuna aubainama taudi yodi nam rabui, ibewa da taudi tenaḡa. Taudi noḡone rabui be yodi Mamaitua ya rawateḡeidina, nam aitau ei yamonedi.” ");
INSERT INTO dww_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dabudine Parisi Yesu ai taravira munaḡe be a riuna, “Be aba aubainama Mousis riuvavasaḡa tautauḡoma ya utedi da taudi waigosaḡa pepanama adi waiwaivima ta utedi be ta gosedi?” ");
INSERT INTO dww_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Be Yesu dabudi ya paribeedi be ya riuna, “Mousis yai aninemina da taumi ami waiwaivima ko gosedina, baninama taumi nam ami raunuatoima ami waiwaivima ḡarodie ima kenakenana. Be pakane Mamaitua waigosaḡa nam i aninena. ");
INSERT INTO dww_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Taugu yà riuriuemina deḡoda tam aitau am visarama kwa gose yababena, avedi da tauna nam ai tauḡoma mate gewagewa ti voiena, be waivi ḡesaunama kwa naḡina, tam inam gewagewa dosinama kuya voiena, baninama monaḡemma debane mui kuya porena. Be waivi na tauḡomama debane mui e porena, inam raḡanine tauḡoma na waivima deḡoda e gose porena inam nam aiyaba.” ");
INSERT INTO dww_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Naumeki da tauwai muriwatana Yesu a riuena, “Deḡoda waigosaḡa nam kwai anine, ya verena da banaga nam sibo ai naḡi.” ");
INSERT INTO dww_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu ya paribeedi be ya riuna, “Nam banaga matabudi uma giunama tokare ta paḡo, ibewa da taudi aitauḡa Mamaitua noḡota ya uteutedina, taudiḡa ta paḡona. ");
INSERT INTO dww_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Banaga ḡesaudima nam timawai naḡina, baninama taudi a tubuḡena nama, be tautauḡoma ḡesaudima banaga a kaivaidina aubainama nam timawai naḡina. Be tautauḡoma ḡesaudima taudi Mamaitua na waiguyauma aubainama naḡi a tuaḡaiena. Be banaga aitau inam giudima banidima e kataiedina, tauna sibo ya ragaudina.” ");
INSERT INTO dww_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Be banaga ḡesaudima seda a verauḡedina Yesu ḡarone, da tauna nimanama debedie sibo ya boru be aubaidima ya moiragina. Be tauwai muriwatana inam banegidima a riutuaḡaiedina. ");
INSERT INTO dww_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Dabudine Yesu ya riuna, “Seda ḡauḡaubodima ko gosedi da ḡarogue ta verauna, be nam koi ḡakedi, baninama mara waiguyaunama banaga maika uma sededima nama aubaidima.” ");
INSERT INTO dww_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Naumeki da Yesu seda debedie nimanama ya biridi ya kovikovina, tauna ya naḡona. ");
INSERT INTO dww_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Raḡan tenaḡa tauḡoma tenaḡa Yesu ḡarone ya tava da yai taravire be ya riuna, “Tauwai katakatai, taugu aiyaba verenama yà voie be yawasana kenakena nonoḡinama yà paḡo?” ");
INSERT INTO dww_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Be Yesu ya paribee be ya riuna, “Vere aba verenama aubainama tam taugu kwawai taraviregu? Mamaitua taunaḡa verenama. Be tam deḡoda yawasana kenakena nonoḡinama kwa ḡoena, naumeki da riuvavasaḡa kwa voteyeteyedina.” ");
INSERT INTO dww_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Be taragai baneginama yai taravira munaḡa be ya riuna, “Abaḡa riuvavasaḡidi?” Dabudine Yesu ya paribee be ya riuna, “Nam kwa rauvunuḡa, nam kwa rauwaivi bo kwa rautauḡoma, nam kwa danene, nam kwa kaiyovu, ");
INSERT INTO dww_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tamam be tinamma kwa viviredina be turamma nuanuamma e paḡona maika nema tamḡa kwawai nuapaḡo munaḡemna nama.” ");
INSERT INTO dww_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Be taragai baneginama ya riuna, “Taugu inam giudima matabudi è voia rovodina. Be yodi aiyaba ḡesau yà voie?” ");
INSERT INTO dww_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Naumeki da Yesu tauḡoma umanama ya riuena, “Tam deḡoda yawasana didimaninama kwa ḡoena, naumeki da kwa naḡo be am purapurama matabudi kwa raugimaredi, be mane banaga waikaruwaḡewaḡedima kwa utedina. Deḡoda nama kwa voiana, tam am waiguyauma tokare marae kwa paḡona. Yodibe tam taugu kwai muriwataneguna.” ");
INSERT INTO dww_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Inam tauḡominama nama giunama ya vaivaiena tauna yai nuaboya kaua be ya naḡona, baninama tauna yai purapura guratana aubainama. ");
INSERT INTO dww_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","“Dabudine Yesu na tauwai muriwatanama umanama ya riuedina, Yà riuriu kauemina da purapura baneginama tauna marae saḡanama ḡarone ya piripiri kauana. ");
INSERT INTO dww_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Be ko noḡoti da Kamel ya bagibagi kauana da seyau gavogavone e sonaḡana, be nama taragai baneginama ya bagibagi da ya bagibagi kauana, tokare nam teneteneḡina da Mamaitua na waiguyauma nopone e saḡa.” ");
INSERT INTO dww_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Be Yesu na tauwai muriwatanama nama a vaivaiena taudi a naira kaua be a riuna, “Deḡoda nama, aitau tokare e yawasana?” ");
INSERT INTO dww_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Naumeki da Yesu taudi ya kitadididi be ya riuna, “Inam kauidima matabudi banaga ḡarodie tokare nam teneteneḡina, be Mamaitua ḡarone yaba matabuna teneteneḡinama e voiedina.” ");
INSERT INTO dww_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Be Pita dabudine Yesu ya riuena, “Tauma yaba matabudi kè gosaḡana tam waimuriwatanema aubainama, be tauma tokare aiyaba ama maesama ka paḡo?” ");
INSERT INTO dww_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dabudine Yesu taudi umanama ya riuedina, “Rawavau raḡaninama e tavana raḡanine, Banaga Natunama waiguyau gabunama boruborumine e miana, be inam raḡanine taumi tauwai muriwatanama 12 mate diague ko mia be Israel damdima matabudi 12 koi tarapiriedina. ");
INSERT INTO dww_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Be aitau da adi vadama bo tamedima bo tinedima, tasitasidima bo nuvunuvudima, adi sedama bo adi sipima a gosaḡana taugu waimuriwataneguma aubainama, taudi tokare ya toi vavasaḡana ta banavidina, nam a gosegosedina maika. Be taudi yawasana kenakena nonoḡinama mate ta paḡona. ");
INSERT INTO dww_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Be banaga toitoi aitauḡa ta dokadokana, taudi tokare tai murina. Be aitauḡa yodi taiwai murina, taudi tokare ta dokana.” ");
INSERT INTO dww_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Be Yesu na giuma ya kaiwatani be ya riuna, “Mara na waiguyauma inam umanama: Raḡan tenaḡa sipi taupakinama raḡanboiboi kupinaḡa ya naḡo be banaga ya kokonedina, da na sipie sibo a noyana. ");
INSERT INTO dww_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Be taudi matabudi ai anina tenaḡa da taudi matabudi adi noyama damone ravie taudi tenatenaḡaḡa Denari tenaḡaḡa ei maesidina. Naumeki be ya riu poredina na sipie. ");
INSERT INTO dww_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Be raḡanboiboi suara ya tavatavana nama, tauna ya dobi ya munaḡa be banaga ḡesaudima anikune gabune a midimidi yabayababana ya banavidina. ");
INSERT INTO dww_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Dabudine ya riuedina, ‘Taumi ko naḡo be yau sipie ko noyana, be taugu tokare taumi yai maesimina.’ ");
INSERT INTO dww_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Naumeki da taudi a naḡona na sipie noya aubainama. “Naumeki da suaratopu be tauḡominama ya dobi ya munaḡana, be kauinama teneḡinama ya voiena. Be ravie kauinama teneḡinama ya voiena. ");
INSERT INTO dww_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Be suara ya yovoyovona raḡanine, tauna ya dobi ya munaḡa be yaḡoro banaga a midimidi yabayababana ya banavidina. Dabudine ya riuedina, ‘Taumi suara daudau aba uma dabudi ko midi yabayababa be ko voivoie?’ ");
INSERT INTO dww_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Be taudi a riuna, ‘Tauma nam aitau i kokonemaina da aba sibo kè voie.’ Be tauna ya riuedina, ‘Naumeki, taumi mate ko naḡo yau sipie ko noyana.’ ");
INSERT INTO dww_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Be ravi ḡomae noya ya kovikovina, sipi taupakinama taunoya adi badama ya yokoe be ya riuena, ‘Taunoya matabudi kwa rawateḡeidi be adi maesama kwa utedina. Aitauḡa muriḡa a tava be noya awai karena, taudi ḡarodie waimaia kwai karena naumeki da banaga noya awai kare dokena ḡarodie kwa tavana.’ ");
INSERT INTO dww_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Naumeki da taudi aitau da suara ya yovoyovona raḡanine noya aubainama a tavatavana, taudi tenatenaḡaḡa a verau be Denari tenatenaḡaḡa a ragaudina. ");
INSERT INTO dww_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Be aitauḡa noya aubainama a tavatava dokana, taudi awai noḡotana kabe mane dosinama ta paḡo. Be ibewa da taudi matabudi Denari tenaḡaḡa a ragaudina. ");
INSERT INTO dww_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Taudi mane a paḡopaḡona raḡanine, sipi taupakinama ḡarone momodu ai kare be a riuna, ");
INSERT INTO dww_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Tauma noya dosinama kè voie be suara debamaie ya kara kuruvana. Be inam banegidima taudi muriḡa ḡoma a tava be nam noya dosinama ti voiena. Be tam maesa teneḡinama kuya utedina.’ ");
INSERT INTO dww_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Be sipi taupakinama ya paribeedi be ya riuna, ‘Badam, taugu nam gewagewa ḡarome e voiena, baninama noḡone tam kuyai aninana da Denari tenaḡa sibo è utemina noya murine. ");
INSERT INTO dww_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Vutuna aubainama am manema kwa paḡo be kwa naḡona. Be taugu yà ḡoeḡoena da banaga muriḡa è kokokokonedina maesa teneḡinama yà utedina maika tam. ");
INSERT INTO dww_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Taugu yau pairuma aubainama tam kuya unura, bo? Uma inam taugu yau manema, vutuna aubainama taugu yà ḡoeḡoena nama banaga yà utena.’ ");
INSERT INTO dww_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Naumeki da aitau da tawai murina, taudi tokare ta dokana, be aitau da ta dokadokana, taudi tokare tai murina.” ");
INSERT INTO dww_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu na tauwai muriwatanama mate Jerusalemma a naḡonaḡona raḡanine, kadae na tauwai muriwatanama ya riuedi da ḡavoe taudiḡa be ya riuedina, ");
INSERT INTO dww_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tauda tà naḡonaḡona Jerusalemma be dabudine Banaga Natunama tokare banaga ta boru dobiḡena pirisi adi babadama be tarawatu tauwai katakataidima nimedie. Be taudi adi ogama a taraḡina da tauna tokare tai gurina. ");
INSERT INTO dww_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Be taudi tokare Banaga Natunama ta paḡo be banaga aitauḡa nam Jius taudi nimedie ta boru nawe da taudi tai diboḡi, ta kwapu be korosie ta tuparatuna. Be raḡan wairabuiteḡane tauna e midisuḡu munaḡana.” ");
INSERT INTO dww_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Dabudine Sebedi natunatunama tinedima mate Yesu ḡarone a tava be tinedima tuapikane ya raupari be na ḡoanama Yesu yai baḡana. ");
INSERT INTO dww_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Be Yesu ya riuna, “Tam am ḡoanama aba?” Dabudine waivi ya riuna, “Kwai anina da am waiguyauma nopone yau sedama uma rabui, be tenaḡa sibo kasaumma yauwane ya miana, be tenaḡa sibo senimma yauwane ya miana.” ");
INSERT INTO dww_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Be Yesu ya riuena, “Tam nam ku kataiena aba kwawai baḡena. Taumi teneteneḡina da taugu ḡoraḡoranama yà tegona nama tokare ko tego, bo?” Dabudine seda a riuna, “Ee, tokare ka tegona teneteneḡinama.” ");
INSERT INTO dww_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Be Yesu ya riuedina, “Taumi riukaua tokare yau redue ko tegona, be kasaugue be senigue mieninama inam nam taugu amawai badena. Inam gabudima Tamaguma ya vokaukauedina, taudi banaga vinevinedima aubaidima.” ");
INSERT INTO dww_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tauwai muriwatana ḡesaudima matabudi 10-nama a vaivaiena raḡanine, taudi nuedima yai medina adi banagama rabui ḡarodie. ");
INSERT INTO dww_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Vutuna aubainama Yesu taudi matabudi ya rawateḡeidi be ya riuedina, “Taumi koya kataiena da eteni babadidima tawai badabadana. Be babadidima ai rewapana vavasaḡana aubainama, taudi eteni tawai badedina. ");
INSERT INTO dww_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Uma kauinama taumi ḡaromie nam nama e tubuḡa! Be deḡoda aitau tenaḡa nopomie moraba e ḡoena, naumeki da tauna e kaue da matabumi ami taunoyama e tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Be aitau saḡa gurata e ḡoena, naumeki da ei taunoyana ḡaromie. ");
INSERT INTO dww_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Maika Banaga Natunama ya yovona, nam banaga tauna aubainama ti noyana, ibewa da tauna banaga aubaidima ya noyana, be na yawasanama yai utaena, da banaga toitoi e kuvesidina.” ");
INSERT INTO dww_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na tauwai muriwatanama mate Jeriko a gosegosena raḡanine, patara dosinama tauna ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dabudine tautauḡoma rabui matapotepotedima keda diane a miamiana. Be raḡanine ta vaiena be Yesu inam kedanaḡa ya naḡonaḡona, naumeki da taudi bonedima dosine a riuna, “Bada, guyau Deivid natunama, kwa raunuatoiemai!” ");
INSERT INTO dww_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Be dabudine patara taudi a riutuaḡaiedina da sibo ai nuatuḡuna. Be taudi yaḡoro a riu guratana, “Bada, guyau Deivid natunama, kwa raunuatoiemai!” ");
INSERT INTO dww_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dabudine Yesu ya midi kwasa, be yai taraviredina, “Aba ko ḡoeḡoena yà voie?” ");
INSERT INTO dww_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Be taudi a paribee be a riuna, “Bada, tauma ka ḡoeḡoena kai kitana.” ");
INSERT INTO dww_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Be Yesu ya raunuatoiedi be matedima ya taukonidina. Be dabudine yai raḡantenaḡe da taudi ai kita be tauna ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Raḡanine Jerusalem diane a tavatavana taudi a verauna oya Olipma Betpage meagaine. Dabudine Yesu na tauwai muriwatanama rabui ya riupore nawe dokedi, ");
INSERT INTO dww_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","be ya riuedina, “Ko naḡo noḡomie meagaine, be raḡanine meagaie ko saḡasaḡana, dabudine ko kitana donki natunama mate a nigoridina. Ko kuvesidi be ko yovoḡedina taugu ḡarogue! ");
INSERT INTO dww_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Be deḡoda aitau ei taraviremina, taumi ko riuena, ‘Bada e ḡoeḡoedina, raḡan ḡaubonaḡa be ka saḡe munaḡedina.’” ");
INSERT INTO dww_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Uma kauinama Mamaitua na giuma boni peroveta ya giugiuena nama ya tubuḡana, ");
INSERT INTO dww_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalem banegidima ko riuedina, ko kitana ami guyauma vovoyaḡotinama donki natunama ya gerue be ḡaromie e veraverauna.” ");
INSERT INTO dww_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Naumeki da tauwai muriwatana a naḡo be Yesu aba ya riuriuedina, nama a voiedina. ");
INSERT INTO dww_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Taudi donki natunama mate Yesu ḡarone a dobiḡedi be taudi adi garama donki natunama debane a yesidi, be Yesu debane ya miana. ");
INSERT INTO dww_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Banaga toitoi adi garama kedaḡa a yesiyesidina maika, banaga ḡesaudima kai ma rugurugudi a taraḡa, a tavaitedi, be kedaḡa a yesidina. ");
INSERT INTO dww_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Banaga aitauḡa a dokadokana be aitauḡa Yesu murine a saḡasaḡana, a yogo be a riuriuna, “Hosana guyau Deivid natunama ḡarone! Waiaiaininama, tauna vutuna Bada isane e veraverauna! Mamaitua saḡasaḡa vavasaḡinama isanama tà kaisuḡusuḡuna.” ");
INSERT INTO dww_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Raḡanine Yesu Jerusalem nopone ya saḡasaḡana banaga matabudi a mosari, ai paparana be a riuriuna, “Uma tauna aitau?” ");
INSERT INTO dww_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Be patara a riuna, “Uma tauna Yesu, tauna peroveta, Nasaretma Galili provins nopone be ya verauna.” ");
INSERT INTO dww_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Be Yesu tempol nopone ya saḡa be dabudine banaga aitauḡa a kunekune be a gimagimarana, matabudi ya tavu dobiḡedina. Be tauna mane taurabedima adi vatarama yai tauviredi be aitauḡa kiu gabubu taurau gimaredima adi kaba miama mate yai tauviredina. ");
INSERT INTO dww_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Be Yesu taudi ya riuedina, “Girugiruminama porane Mamaitua ya riuna, ‘Taugu yau vadama inam moiragi kana vadama.’ Be taumi ko voivoiena da kabe taudanedanene adi gabu. ");
INSERT INTO dww_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Be banaga matapotepotedi be tuera ragaragaudima tempol nopone Yesu ḡarone a tava be tauna yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dabudine pirisi adi babadama be tarawatu tauwai katakataidima Yesu yaba veredima ya voivoiedina a kitedi be seda tempol nopone a yogo be a riuriuna, “Hosana, guyau Deivid natunama!” Vutuna aubainama inam babadidima nuedima yai medi ");
INSERT INTO dww_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","be Yesu a riuena, “Tam seda aba ta riuriuena kwa vaivaie bo ibewa?” Be Yesu taudi ya riuedina, “Ee, yà vaivaiedina. Taumi girugiruminama porane koya sievi bo ibewa da umanama ya riuna, ‘Tam seda raubanidima, be seda wawaidima kuya voiedi da taudi isamma ta kaisuḡusuḡuna.’” ");
INSERT INTO dww_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dabudine tauna ya gosedi be inam meagainama ya dobi pore be ya naḡona Betenima, be dabudine ya kenana. ");
INSERT INTO dww_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pomainama raḡanboiboi kupinaḡa Yesu ya munamunaḡana Jerusalemma, be kedae tauna kani ya karatina. ");
INSERT INTO dww_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dabudine e kitana be damaya kainama keda diane ya midimidina. Naumeki da tauna kai diane ya naḡo be dabudi damaya rugudiḡa ya kitedina, be banidima nam i banavidina. Vutuna aubainama tauna damaya ya riuena, “Nam airaḡan kwa vota munaḡa!” Tauna nama ya riuriuna mudune, damaya kainama ya pokina. ");
INSERT INTO dww_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Be tauwai muriwatana nama a kitakitana, taudi a base be a riuna, “Damaya nemanama da ya poki makai?” ");
INSERT INTO dww_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Be Yesu ya riuedina, “Yà riuriu kauemina taumi deḡoda koi sumaḡa be nam ko noḡota bekubeku, taumi tokare kauinama teneḡinama nama ko voiana, be nam inam vutunaḡa be mate taumi tokare kaua oyanama ko riuena, ‘Kwa nuakamoḡa be kwa naḡo egasie.’ Be nama tokare e tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Deḡoda taumi koi sumaḡana, taumi tokare ami ḡoanama aiyaba koi baḡena moiragie, tokare ko banavina.” ");
INSERT INTO dww_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu tempol nopone ya saḡa be yawai katakataina raḡanine, pirisi adi babadama be babada ḡesaudima mate tauna ḡarone a tava, be ai taravirena, “Tam aba waibadana, be aitau waibada ya utem be uma kauidima kwa voivoiedi?” ");
INSERT INTO dww_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Be Yesu ya riuedina, “Taugu mate yau waitaravirama tenaḡa taumi yài taraviremina, be deḡoda taumi ko paribeeguna, naumeki da yà riuemi da taugu aba waibadane uma yabedima yà voivoiedi. ");
INSERT INTO dww_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ko riuegu! Jon deḡo dabudi waibada ya paḡo da yawai babataito, Mamaitua ḡarone bo banaga ḡarodie?” Dabudine taudiḡa ai saḡasaḡa be a riuna, “Nema tà riu bako? Deḡoda tà riuna Mamaitua ḡarone, tauna tokare e riuedana, aba aubainama taumi Jon nam koi sumaḡe? ");
INSERT INTO dww_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Be deḡoda tauda tà riuna, banage, tauda mate banaga tà nairedina, baninama taudi matabudi ta noḡonoḡotina da Jon tauna peroveta.” ");
INSERT INTO dww_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Vutuna aubainama taudi Yesu a paribee be a riuna, “Tauma nam ke kataiena.” Dabudine Yesu ya riuedina, “Naumeki, taugu mate nam yà riuemi da taugu aba waibadane uma yabedima yà voivoiedi. ");
INSERT INTO dww_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Uma wainasinama yà riuemi be nema ko noḡota bake? Tauḡoma tenaḡa be natunatunama rabui. Be tauna ya naḡo da natunama tautueḡinama ḡarone be ya riuena, ‘Taukui, manaka kwa naḡo dà sipie be kwa noyana.’ ");
INSERT INTO dww_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Be natunama ya tuaḡai be ya riuna, ‘Taugu è kayo tuaḡaina.’ Be you, muriḡa nuanama ya vitara be ya naḡona sipie noya aubainama. ");
INSERT INTO dww_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Naumeki be tauḡoma ya naḡona natunama tautasinama ḡarone be riunama teneḡinama natunama ya riuena. Be dabudine natunama ya riuna, ‘Naumeki mamai, taugu yà naḡona.’ Be tauna nam i naḡona sipie. ");
INSERT INTO dww_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Yodi aitau tamanama ya voteyeteye be na ḡoanama ya voie?” Be banaga Yesu a paribee be a riuna, “Gomana tautueḡinama.” Dabudine Yesu ya riuedina, “Taugu yà riuriu kauemina da teks tautamidima kaikaiyovudima, be toretore waiwaividima taudi tokare Mamaitua na waiguyaue ta saḡa dokana. Be taumi ibewa, ");
INSERT INTO dww_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","baninama Jon ya tava be tauna didimana kedanama yai kataimina, be taumi nam tauna koi sumaḡena. Be teks tautamidima kaikaiyovudima, be toretore waiwaividima taudi Jon ai sumaḡena. Be taumi uma kauinama koya kitana, be yaḡoro nam ami noḡotama ko vitaredi be koi sumaḡena. ");
INSERT INTO dww_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Be yodi wainasi ḡesaunama yà riuemi be ko vaiena. Sipi taupakinama tenaḡa gureipi sipinama ya voie be ya ganakukuna. Yodibe waen anibuyonama domnama be kweyaḡa vadanama ya keridina. Yodibe gureipi sipinama tausipi ḡesaudima nimedie ya boru da a raberabe be tauna vaḡaie ya naḡona. ");
INSERT INTO dww_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Raḡanine gureipi taminama na raḡanima ya tavatavana, tauna na taunoyama ya riupore nawedina sipi taurabenama ḡarodie, da tauna na sikerema sibo a paḡona. ");
INSERT INTO dww_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Be sipi taurabedima taudi taunoya a vunuḡidi, be tenaḡa a riḡa yabayababena, be ḡesau ai gurina, be ḡesaunama a rauyeku be ya gurina. ");
INSERT INTO dww_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Naumeki da sipi taupakinama na taunoyama ḡesaudima rautoitoi ya riuporaḡana. Be sipi taurabedima inam kauinama teneḡinama nama ḡarodie a voiena. ");
INSERT INTO dww_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Taunoya a vunuvunuḡa rovodina murine, tauna natuḡominama ya riupore nawena ḡarodie be ya riuna, ‘Taugu yà noḡonoḡotina da taudi yodi tokare natuguma ta vivirena!’ ");
INSERT INTO dww_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Be raḡanine sipi taurabenama tauna a kitakitana, taudiḡa ai giu vivivira be a riuna, ‘Uma tauna sipi tokare ei buderiena. Vutuna aubainama tài guri be inam buderinama tauda tài buderiena.’ ");
INSERT INTO dww_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naumeki da taudi sipie be a vunuḡa dobiḡena ḡavoe, be dabudine ai gurina. ");
INSERT INTO dww_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Yodi nemanama? Sipi taupakinama e tavana raḡanine, tokare sipi taurabedima nema e bakedi?” ");
INSERT INTO dww_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Taudi Yesu a riuena, “Tauna inam banegidima gewegewedima tokare e kawa gewegewedi, be murine na sipima banaga ḡesaudima nimedie e boruna. Be gureipi taminama na raḡanie taudi tokare tauna na sikerema ta utena.” ");
INSERT INTO dww_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Be Yesu taudi ya riuedina, “Taumi girugiruminama porane koya sievi bo ibewa? Inam umanama ya riuna, ‘Vada taukerinama yekue vada a kerikeri be yeku tenaḡa a porekaiyatina, baninama inam yekunama taudi nam ti ḡoena. Be Mamaitua yekunama poreporenama ya paḡo be ya voie da na vadama e kerikerina yasinama ya tubuḡana. Be inam kauinama Bada ya voiena tauda ḡarode anikitanama ya vere kauana.’ ");
INSERT INTO dww_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Vutuna aubainama yà riuriuemina da Mamaitua na waiguyauma taumi ḡaromie tokare e kaipore, be banaga ḡesaudima e utedina. Be inam dabudine taudi tokare ta vota be Mamaitua na sikerema ta utena. ");
INSERT INTO dww_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Be aitau e beku be uma yekunama debane e ravusena, tauna tokare ei mia gorugoruna. Be yekunama aitau debane e ravusena, tauna tokare ei mia mutumutuna.” ");
INSERT INTO dww_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dabudine pirisi adi babadama be Parisi Yesu na wainasima matabudi a vaivaiedina, taudi a kataiena da tauna taudi ya giugiuedina. ");
INSERT INTO dww_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Vutuna aubainama taudi keda a wanewanena da Yesu sibo a vunuḡina, be taudi banaga a nairedina, baninama banaga a noḡonoḡotina da Yesu inam peroveta. ");
INSERT INTO dww_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Be Yesu wainasi ḡesau ya riuedina, ");
INSERT INTO dww_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mamaitua na waiguyauma inam maika umanama: Guyau tenaḡa natunama tauḡominama yawai naḡina. Vutuna aubainama tauna soi ya vokaukauena. ");
INSERT INTO dww_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Be tauna na taunoyama ya riuporedina da banaga ya kokokokonedina, vutudi sibo a riuedi da a verauna soie. Be inam banegidima taudi a tuaḡaina. ");
INSERT INTO dww_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Naumeki da tauna na taunoyama ḡesaudima rautoitoi ya riupore nawedi be ya riuna, ‘Ko naḡo inam banegidima è kokokokonedina ḡarodie be umanama ko riuedina, “Ko verauna soie! Taugu kaite yau kani be yau musarama è vokaukauedi, be taumi yà raberabemina.” ’ ");
INSERT INTO dww_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Be inam banegidima yaḡoro taunoya bonedima a vaia tuaḡaiedi, be taudi ai naḡo teḡateḡana. Waria na sipie ya naḡona, be waria na noyae ya naḡona. ");
INSERT INTO dww_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Be ḡesaudima taunoya a vunuḡidi, a raukivi gewegewedi be ai guridina. ");
INSERT INTO dww_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Vutuna aubainama guyau noponama yai ḡora kaua be na tauiḡarama ya riuporedina da inam banegidima taurau vunuḡa tai guridi be adi meagaima mate ta gabu gorudina. ");
INSERT INTO dww_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dabudine guyau na taunoyama ya riuedina, ‘Naḡi soinama kaite e kawa nonoḡi be e kenakenana. Be banaga è kokokokonedina, taudi nam veredi da sibo a verau. ");
INSERT INTO dww_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Vutuna aubainama taumi ko naḡo kedaḡa be aitauḡa ko banabanavidina, ko riuedi be matabudi ta verauna soie.’ ");
INSERT INTO dww_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Naumeki da taunoya a naḡo kedaḡa be banaga aitauḡa a banabanavidina, veredi bo gewegewedi, matabudi a tavaitedi, be soi vadanama ya moḡavu taritarina. ");
INSERT INTO dww_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Be guyau vadae ya saḡana, na warema kitedima aubainama. Be dabudine e kitana be banaga tenaḡa nam naḡi garedima i kotedina. ");
INSERT INTO dww_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dabudine guyau inam baneginama ya riuena, ‘Badam, tam nam naḡi garedima ku kotedina, be nemanama da uma dabudine kuya saḡa?’ Be tauḡoma dabudine nam aiyaba i riuena. ");
INSERT INTO dww_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dabudine guyau na taunoyama ya riuedina, ‘Inam tauḡominama nimanama, kaḡanama ko panidi be ko pore dobiḡena tadiwanawanae. Be dabudine e ḡaba be gadigadinama e sanadididina.’ ");
INSERT INTO dww_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ko kataie da Mamaitua banaga toitoi ya kokonedina be bisaḡa ya vinedina.” ");
INSERT INTO dww_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dabudine Parisi a naḡo da adi ogama a taraḡina da tauna sibo giue Yesu ai sinasina be aiyaba sibo ya vato waigewana. ");
INSERT INTO dww_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Be Parisi adi tauwai muriwatanama be Herod na tauwai muriwatanama a riupore nawe tenaḡedi, be Yesu ai taravirena, “Tauwai katakatai, tauma kè kataiena da tam riukaue kwa giugiuna, be Mamaitua na ḡoanama riukaue kwawai katakataina. Be am giue tam nam banaga kuma nainairedina, avedi da banaga nema maika kitedima, tam nam kuma siesievidina. ");
INSERT INTO dww_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kwa riuemai, tam nema kwa noḡonoḡota bake, tauma Sisa ḡarone kai teks bo avedi?” ");
INSERT INTO dww_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dabudine Yesu taudi adi noḡotama gewegewedima ya kataiedi be ya riuna, “Taumi banaga kaikaiyovumima! Aba aubainama taumi ko rarau rubugu? ");
INSERT INTO dww_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sirin teks aniwai maesinama ko verauḡe be yà kita.” Naumeki da Denari tenaḡa a paḡo verauḡe ḡarone ");
INSERT INTO dww_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","be Yesu taudi yai taraviredina, “Aitau noḡona be isanama Sirin bogane ta kenakena?” ");
INSERT INTO dww_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Be taudi a paribee be a riuna, “Uma Sisa noḡonama.” Be Yesu ya riuedina, “Naumeki da Sisa ḡaronama Sisa ko utena, be Mamaitua ḡaronama naumeki da Mamaitua ko utena!” ");
INSERT INTO dww_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Raḡanine nama giunama a vaivaiena, taudi Yesu a base be a naḡona. ");
INSERT INTO dww_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadisi taudi a riuriuna da banaga e guri be nam e midisuḡu munaḡa. Inam raḡaninama teneḡine taudi vutudi Yesu ḡarone a tava da ai taravire ");
INSERT INTO dww_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","be a riuna, “Tauwai katakatai, Mousis umanama ya riuna, ‘Deḡoda tauḡoma yai naḡi be nam seda i tikedi da ya gurina, be na visarama ya gosena, naumeki da tasinama bo tuaḡanama inam kaiyababinama e naḡi be seda ei tubuḡidina tuaḡanama gurigurinama aubainama.’ ");
INSERT INTO dww_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Tauma ḡaromaie tautauḡoma 7 a tubuḡana tina tenaḡa ḡarone, be tauḡoma tautuaḡa waivi ya naḡi da nam ti natunatuna, be tauḡominama ya gurina be tasinama tuaḡanama kaiyababinama ya naḡina. ");
INSERT INTO dww_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Be tauna mate seda nam i tikedi be ya gurina. Be kauinama teneḡinama tauḡoma wairabuiteḡanama ḡarone ya tubuḡana. Namaḡa da tauḡoma aniwai 7-nama ḡarone ya dobina. Be inam tauḡominama mate nam i natunatuna be ya gurina. ");
INSERT INTO dww_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Naumeki da inam tautauḡomidima a gurigurina damone inam waivinama ya guri ḡavutana. ");
INSERT INTO dww_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yodi nemanama? Midisuḡu munaḡa na raḡanie uma waivinama tautauḡoma 7 a naḡinaḡina, tauna tokare aitau na waivi?” ");
INSERT INTO dww_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu ya paribeedi be ya riuna, “Taumi koya giu waigewana, baninama taumi girugiruminama porane nam ko katai kauena, be Mamaitua na rewapanama mate nam ko kataiena. ");
INSERT INTO dww_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Midisuḡu munaḡa raḡanine, banaga taudi tokare anea maika ta tubuḡana marae, be tokare nam tai naḡi. ");
INSERT INTO dww_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Be guri ta midisuḡu munaḡana na waikatakataima taumi koya sievi bo ibewa? Mamaitua boni umanama ya riuna, ");
INSERT INTO dww_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Taugu inam Eibraham, Aisik be Jeikob adi Mamaituama.’ Mamaitua, nam banaga guriguridima adi Mamaitua, ibewa da tauna banaga yawayawasanidima adi Mamaituama.” ");
INSERT INTO dww_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Patara umanama giudima a vaivaiena, taudi Yesu na waikatakataima a base kauena. ");
INSERT INTO dww_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Inam raḡanine Parisi ta vaiena be Yesu Sadisi adi giuma matabudi ya gududina, vutuna aubainama Parisi a rawateḡeidina. ");
INSERT INTO dww_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Be adi badama, tarawatu tauwai katakatainama tenaḡa Yesu ya raurubu be ya riuena, ");
INSERT INTO dww_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tauwai katakatai, tarawatu nopone, deḡo riuvavasaḡinama ya saḡa vavasaḡa?” ");
INSERT INTO dww_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Be Yesu ya paribeena, ‘Bada am Mamaituama nuanuamma e paḡona, nuanuamma tabutabune, aruimma tabutabune be am noḡotama tabutabune.’ ");
INSERT INTO dww_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inam riuvavasaḡinama ya saḡa guratana, be tauna e dokadokana. ");
INSERT INTO dww_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Be aniwai rabuinama inam nama kitanama, ‘Turamma nuanuamma e paḡona, nema tam kwawai nuapaḡo munaḡemna nama.’ ");
INSERT INTO dww_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tarawatu be peroveta adi waikatakataima matabudi inam riuvavasaḡidima rabui nopodie ta kenakenana.” ");
INSERT INTO dww_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Be Parisi ai rawateḡeidi da a miamia be Yesu yai taraviredina, ");
INSERT INTO dww_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Taumi Keriso nema ko noḡonoḡota bake, tauna aitau natuna?” Be taudi a paribee be a riuna, “Tauna guyau Deivid natunama.” ");
INSERT INTO dww_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Be Yesu ya riuedina, “Be nemanama da Arua Babau guyau Deivid nopone ya yovo be tauna umanama ya riuna, ");
INSERT INTO dww_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mamaitua yau Badama ya riuena, Kasaugue kwa miana, naumeki da taugu am ḡaviama kaḡamma dibudie yà biridina.’ ");
INSERT INTO dww_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Guyau Deivid Keriso ḡarone ya riuna, ‘Yau Badama!’ Be yodi nemanama da Keriso tauna guyau Deivid natuna?” ");
INSERT INTO dww_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Inam dabudine nam aitau Bada na giuma i paribeena. Inam raḡanine be nokoi ya naḡona nam aitau Yesu waitaravira munaḡenama i ḡoena, baninama taudi a nairana. ");
INSERT INTO dww_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dabudine Yesu tauna na tauwai muriwatanama be patara ya riuedina, ");
INSERT INTO dww_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tarawatu tauwai katakataidima be Parisi taudi Mousis gabunama a paḡo be banaga tawai katakataidina. ");
INSERT INTO dww_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Vutuna aubainama taumi yaba matabuna ta riuriuemina, naumeki da ko voteyeteyedina. Be adi yawasanama nam i verena aubainama, nam koi muriwatanedi. Taudi ta riuemi da taumi yaba ko voivoiedina, be taudi ḡomidima inam yabedima ta giugiuedina nam tima voivoiedina. ");
INSERT INTO dww_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Taudi tarawatu tabu be tabu bagibagidima ta voiedi, be banaga ta segesegeridina da tarawatu tai muriwatanedina, be banaga inam tarawatudima waimuriwatanedima ta voivoia rereḡedina, be taudi nimediḡa a tikedi be ta miamiana. ");
INSERT INTO dww_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Taudi adi voiama matabudi ta voivoiedina da banaga kabe ta kitedi be ta basedina. Taudi Mamaitua riunama pepae ta girumidi be noḡodie be nimedie ta panipanidina, be gara rarauperoperodima ta kotekotedina. Be gara peroperodima tawai dau guratedina da kabe banaga ta kitedi be ta basedi. ");
INSERT INTO dww_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Soi raḡanine taudi guni poune mieninama ta ḡoeḡoedina, be taparoro raḡandie taudi gabu verediḡa ta vinevinedina. ");
INSERT INTO dww_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Taudi adi ḡoana kauama da banaga aniwai boru gabudie taudi ḡarodie ta verau, be kawasaḡe na waikaiwe tai kaiwedi be ta riuna, ‘O bada dosimma.’ ");
INSERT INTO dww_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Be taumi ko kita da nam aitau ḡaromie e riuna, ‘Bada dosimma’, avedi. Baninama taumi inam ami badama dosinama tenaḡa, be taumi matabumi inam tauna tasitasinama. ");
INSERT INTO dww_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Be dobue nam aitau ḡarone ko riuna, ‘Mamai’, avedi. Baninama taumi tamemima tenaḡa, tauna vutuna marae e miamiana. ");
INSERT INTO dww_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Be taumi ko kita da nam aitau ḡaromie e riuna, ‘Tauwai katakatai’, avedi. Baninama taumi inam ami tauwai katakataima tenaḡa, tauna vutuna Keriso. ");
INSERT INTO dww_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aitau da nopomie ya saḡa guratana, naumeki da tauna aubaimima ei taunoyana. ");
INSERT INTO dww_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Be aitau da e kawakawa saḡe munaḡena, Mamaitua tokare tauna e boru dobiḡena. Be aitau da e boruboru dobiḡa munaḡena, Mamaitua tokare tauna e kawa saḡena. ");
INSERT INTO dww_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Taumi tarawatu tauwai katakataidima be Parisi taumi banaga kaikaiyovumima. Gewagewa vavasaḡinama tokare ko banavina. Baninama banaga Mamaitua na waiguyauma nopone saḡanama ta ḡoeḡoena be taumi adi kedama ko guduguduna. Be mate tokare nam Mamaitua na waiguyauma nopone ko saḡa. Be mate banaga Mamaitua na waiguyauma nopone saḡanama aubainama ta rarau rubuna, be taumi adi kedama ko guduguduna. ");
INSERT INTO dww_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(-) ");
INSERT INTO dww_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Taumi tarawatu tauwai katakataidima be Parisi taumi banaga kaikaiyovumima. Gewagewa vavasaḡinama tokare ko banavina. Baninama taumi dobu ko naḡo popoe be banaga ko voiedi da tawai muriwatanemi be kowai katakataidina. Be inam kedane taumi inam banegidima ko voiedi da taudi giena natunatudima ta tubutubuḡana maika taumi. Be mate ko voiedi da adi kaiyovuma tawai moraba kauena, nam maika taumi. Vutuna aubainama taumi inam giena na banima. ");
INSERT INTO dww_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Taumi tauwai dokadoka matapotepotemima, taumi gewagewa vavasaḡinama tokare ko banavina. Baninama taumi ko riuriuna, ‘Deḡoda aitau tempol isane e sauga wapana, inam saugawapanama nam bani boruboruna. Be deḡoda tempol nopone gold isane e sauga wapana, naumeki da inam saugawapanama nam kwai kati kotovi.’ ");
INSERT INTO dww_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Taumi matapotepotemi, be buebuemima! Deḡo tauna yaba dosina, Gold bo tempol? Tempol tauna vutuna gold e kawakawa babauna. ");
INSERT INTO dww_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Be mate ko riuriuna, ‘Deḡoda aitau olta isane e sauga wapana, inam saugawapanama nam bani boruboruna. Be deḡoda puyo olta debane e kenakenana, be inam puyonama isane e sauga wapana, naumeki da inam saugawapanama nam kwai kati kotovi.’ ");
INSERT INTO dww_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Taumi matapotepotemima. Deḡo tauna yaba dosina, puyo bo olta? Olta tauna vutuna puyo e kawakawa babauna. ");
INSERT INTO dww_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Vutuna aubainama aitau da olta isane e sauga wapana, naumeki da tauna yaba matabuna olta debane mate isedie e sausauga wapana. ");
INSERT INTO dww_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Be aitau da tempol isane e sauga wapana, tauna inam tempol isane be aitau da tempol nopone e miamiana mate isane e sausauga wapana. ");
INSERT INTO dww_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Be aitau da mara isane e sauga wapana, naumeki da tauna Mamaitua na kaba miama be Mamaitua ḡominama mate isane e sausauga wapana. ");
INSERT INTO dww_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Taumi tarawatu tauwai katakataidima be Parisi taumi banaga kaikaiyovumima. Tokare gewagewa vavasaḡinama ko banavina. Baninama taumi kani anitai dinidima yabedima koi rawadamdamdi da matabudi 10 be dam tenaḡa Mamaitua ko uteutena. Inam kaua ḡaubonama. Be kaua dosidima tarawatue ta kenakenana inam didimana, raunuatoi be waipatutu taumi nam koma voivoiedina. Inam ya gewagewa kaua. Taumi noḡone kaua dosidima sibo koya voiedina, muriḡa da kaua ḡauḡaubodima sibo koya voivoiedina. ");
INSERT INTO dww_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Taumi tauwai dokadoka matapotepotemima. Taumi kaua ḡauḡaubodima ko kitakita yaḡeyaḡedina, be kaua dosidima ko vava gudegudedina. ");
INSERT INTO dww_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Taumi tarawatu tauwai katakataidima be Parisi taumi banaga kaikaiyovumima. Gewagewa vavasaḡinama tokare ko banavina. Baninama taumi keyaka be tebo tauridima ko koḡekoḡedina, be nopomima danene be kanitoku ya moḡavuna, inam vutudi mira. ");
INSERT INTO dww_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Taumi Parisi matapotepotemima. Taumi noḡone keyaka be tebo nopodima ko koḡa dokedina, yodibe tauridima mate tokare ta verena. ");
INSERT INTO dww_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Taumi tarawatu tauwai katakataidima be Parisi taumi banaga kaikaiyovumima. Gewagewa vavasaḡinama tokare ko banavina. Baninama taumi kokoaga waiwaisianama maika. Kokoaga debanama kitanama ya vere kauana, be noponama turiḡa be mira ya moḡavuna. ");
INSERT INTO dww_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Be taumi ami yawasanama inam kokoaga maika. Banaga ta kitekitemina da taumi kabe didimana banegimi, be nopomima inam kaiyovu be gewagewa ya moḡavuna. ");
INSERT INTO dww_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Taumi tarawatu tauwai katakataidima be Parisi taumi banaga kaikaiyovumima. Gewagewa vavasaḡinama tokare ko banavina. Baninama taumi peroveta be didimana banegidima kokoagidima koi sia yaḡeyaḡedi, ");
INSERT INTO dww_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","be ko riuriuna, ‘Deḡoda tauda waḡawaḡadama adi raḡanie sibo tè miana, tauda tokare nam te sagudi be peroveta tei guridi.’ ");
INSERT INTO dww_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Inam giudie kowai maḡatara munaḡemina da taumi vutuna peroveta tauvunuḡidima natunatudima. ");
INSERT INTO dww_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Be taumi ami dosima gewagewa a voivoia gosena, tokare taumi ko kaiḡavutidina. ");
INSERT INTO dww_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Taumi mota, sarama natunatudima! Taumi tokare riukaua da ko naḡona gienae, be nam tokare koi moisiri be teneteneḡina. ");
INSERT INTO dww_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Vutuna aubainama taugu yodi uma yà riuemina da peroveta, nuauyauya banegidima be tauwai katakatai yà riuriuporedina ḡaromie. Be ḡesaudima taumi tokare koi guridi, be ḡesaudima ko tuparatudi, be ḡesaudima ami sinagogma nopodie kwapue ko riḡedi, be ḡesaudima koi tarapiriedi be ko tavu waibabaridina meagai da meagai nopodiḡa. ");
INSERT INTO dww_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Vutuna aubainama aitauḡa banaga veredima a vunuvunuḡidina adi kovoḡama taumi tokare ko paḡona. Boni pakane da yodi, didimana banegidima a vunuḡidi be kosinidima a darorona. Inam Eibol na parate ya naḡo da Berekaia natunama Sakaraias ḡarone ya tavana. Sakaraias tauna olta be tempol poudie koya vunuḡina. Inam banegidima matabudi ami dosima a vunuvunuḡidina mate kosinidima taumi nimemie ta kenakenana. Vutuna aubainama taumi tokare kovoḡa ko paḡona. ");
INSERT INTO dww_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yà riuriu kauemina, da uma kauidima matabudi taumi kimtimima ḡaromie ta tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem! Taumi peroveta kowai guridina. Mamaitua banaga e riuriuporaḡana ḡaromie, be taumi ko rarau yekudina! Raḡan ya toi kauana taugu è raurubu da sibo è rawateḡeimina, kamkam natunatunama mapenama dibune e rawarawa teḡeidina maika, be taumi koya tuaḡaina. ");
INSERT INTO dww_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vutuna aubainama Mamaitua ami tempolma tokare e gose be e kena yababana. ");
INSERT INTO dww_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Be yodi yà riuriuemina da taumi nam ko kita munaḡegu, naumeki da tokare raḡan e tavana, dabudine taumi umanama ko riuna, ‘Tam vutuna Bada isane kwa veraverauna, isamma ka kaisuḡusuḡuna.’” ");
INSERT INTO dww_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu tempol ya gose da ya naḡonaḡo be na tauwai muriwatanama ḡarone a tavana. Dabudine taudi tempol a kita virevire, Yesu ai katai be a basebasena. ");
INSERT INTO dww_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Be dabudine Yesu taudi ya riuedina, “Yà riuriu kauemina da uma yabedima matabudi yodi ko kitekitedina, tokare nam nama ta kena nonoḡa ibewa, be matabudi tokare ta rawadabu ririḡidina.” ");
INSERT INTO dww_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu oya Olip debane ya miamia be na tauwai muriwatanama taudiḡa Yesu ḡarone a tava da ai taravire, be a riuna, “Kwa riuemai, uma kauidima aba raḡanine ta tubuḡa? Be abaḡa matairidima ta tubuḡa da ka kitedi be ka kataie da raḡan damonama kaiteka maida, be mate nema ka katai bake da tam am kaba verauma raḡaninama e tavatava?” ");
INSERT INTO dww_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Be Yesu ya riuna, “Koi kita kaua da nam aitau ei kedadoka waigewemi. ");
INSERT INTO dww_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Baninama banaga toitoi tokare isague ta tava be ta riuna, ‘Taugu vutuna Keriso!’ Be taudi tokare banaga toitoi tai kedadoka waigewedina. ");
INSERT INTO dww_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Be raḡanine iḡara maida guguridima ko vaie bo madanie varidima ko vaiedina, nam ko naira! Uma kauidima nama tokare ta tubuḡana, be inam nam raḡan damona, ibewa! ");
INSERT INTO dww_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dobu da dobu tai kawa ḡasiḡasina, be waiguyau turanama waiguyau mate tai kawa ḡasiḡasina. Be dobu toitoi nopodie meiḡara be yoyo tai verautatena. ");
INSERT INTO dww_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Inam kauidima maika kaipakara gomana kaevounama e tepetepena tunimuyanama maika, inam tepa pakanama. ");
INSERT INTO dww_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Inam raḡanine taumi tokare ta panimi be babada nimedie ta biri nawemi da taudi ta raukivi gewegewemi be tai gurimina. Be taumi taugu kowai sumaḡeguna aubainama, banaga dobu matabuna tokare ta tuaḡaiemina. ");
INSERT INTO dww_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Inam raḡanine banaga toitoi adi waisumaḡama ta gosedi be adi banagama adi banagama ta tuaḡaiedi be tai kawa biri dobiḡana, ");
INSERT INTO dww_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","be peroveta kaikaiyovudima toitoi inam raḡanine ta maḡatara, be banaga toitoi tai kedadoka waigewedina. ");
INSERT INTO dww_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Be gewagewa e moraba, be banaga toitoi adi wainuapaḡoma tokare ei kavena. ");
INSERT INTO dww_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Be aitauḡa adi waisumaḡe ta midi bagibagi be ta raudamoena, taudi tokare ta yawasanana. ");
INSERT INTO dww_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Be Mamaitua na waiguyauma varinama verenama tokare dobue banaga matabudi ḡarodie ta rauguguya nawe da banaga ta vaie, muriḡa da raḡan damonama e tavana. ");
INSERT INTO dww_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Taumi tausiava, uma giunama baninama ko katai kauena, Peroveta Daniel ya riuna da tokare ko kitana gewagewa waimatawarawara vavasaḡinama deḡo nam sibo ya midi, be tokare e midina. Inam kauinama e tubuḡana raḡanine, ");
INSERT INTO dww_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","taudi aitauḡa Judiama miemienidima naumeki da naira oyae sibo a naḡona. ");
INSERT INTO dww_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Inam raḡanine, aitau da na wagapatae e miamiana, nam vadama nopone e saḡa be na purapurama e ragaudi. ");
INSERT INTO dww_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Be nam aitau sipie be na garama ragaudima aubaidima e munaḡa vadae. ");
INSERT INTO dww_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Inam raḡandie waiwaivi bogebogedima be waitatau vaudima, taudi tokare piripiri dosidima ta banavidina. ");
INSERT INTO dww_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Be Mamaitua ḡarone ko moiragi da inam raḡandima, nam bodubodue bo Sabat raḡandie ta tubuḡa, baninama taumi tokare nema naira ko naḡo bako? ");
INSERT INTO dww_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Baninama nuaboya inam raḡandie e gewagewa vavasaḡana tokare ta tubuḡana. Mamaitua dobu yawai tubuḡie da yodi, nam airaḡan uma piripiridima ti tubuḡa rubuna naumeki da yodi. Be uma piripiridima murine nam airaḡan e tubuḡa munaḡa. ");
INSERT INTO dww_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Be deḡoda Mamaitua inam piripiri raḡandima tai tupodima ibewa, nam aitau tenaḡa tokare ya yawasana. Be na banagama vinevinedima kadi taiye, tauna uma raḡandima tokare e taitupodina. ");
INSERT INTO dww_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Be inam raḡandie deḡoda aitau e riuemina, ‘Keriso umanema!’ bo e riuna, ‘Keriso noanema!’ Inam baneginama nam koi sumaḡe! ");
INSERT INTO dww_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Baninama Keriso kaikaiyovudima, be peroveta kaikaiyovudima tokare ta maḡatara be mataira be anibasa kauidima ta voiedina, be ta raurubu da Mamaitua na vinevinema banegidima mate sibo ai kedadoka waigewedina. ");
INSERT INTO dww_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Vutuna aubainama ko kita kauana, yaba matabuna kaite è riu wainonoḡimina, muriḡa da inam raḡandima ta tavana. ");
INSERT INTO dww_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Vutuna aubainama deḡoda aitau e riuemina, ‘Noanema Keriso, dobu kavakavane.’ Nam ko dobi ko naḡo! Bo deḡoda e riuemina, ‘Keriso umanema vadae.’ Nam koi sumaḡe! ");
INSERT INTO dww_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Baninama Banaga Natunama na raḡanima ei raḡantenaḡe be keyama maika e kidi, be gunuma matabuna e yana porena. ");
INSERT INTO dww_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Deḡo musara gurinama e kenakenana, dabudine naboduba ta rawarawa teḡeidina. ");
INSERT INTO dww_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Be inam piripiridima raḡandima muridie, suara ei kupi, be nawaravi tokare nam e yana munaḡa. Be gunuma rewapanidima matabudi e gusu waidaberaridi be kipora gunume ta kuruvana. ");
INSERT INTO dww_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Inam raḡanine noḡone Banaga Natunama tokare gunume e maḡatara, da banaga ta kita be ta kataie da inam Banaga Natunama e yovoyovona. Be dobue banaga matabudi tai sosori be ta ḡabana. Be tokare taudi Banaga Natunama rewapana be neneḡara dosinama mate giyou nopone be e yovoyovona ta kitana. ");
INSERT INTO dww_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dabudine bogigi dosinama e riuriuna raḡanine, tauna na aneama e riuporedi da na banagama vinevinedima matabudi dobu isune da isune, be gunuma isune da isune, da ta rawateḡeteḡeidina. ");
INSERT INTO dww_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Naumeki da damaya kainama ko kita be ḡarone ko kataina. Raḡanine damaya ragedima ta kini, be rugudima ta gidagidavana, inam raḡanine ko kataie da inam bodubodu raḡaninama maida e tavatavana. ");
INSERT INTO dww_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Inam kauinama teneḡinama nama, raḡanine taumi inam kauidima gewegewedima ta tubutubuḡana ko kitedina, dabudine taumi ko kataie da Bada na kaba verauma raḡaninama kaiteka maida. ");
INSERT INTO dww_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Taugu yà riuriu kauemina, da uma kimtinama nam ei kave, naumeki da inam kauidima tokare matabudi ta tubuḡa dokana. ");
INSERT INTO dww_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mara be dobu tokare ta samoana, be taugu riuguma nam airaḡan e samoa. ");
INSERT INTO dww_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nam aitau tenaḡa raḡan i kataiena da airaḡan inam raḡaninama e tava. Nam anea marae, Mamaitua Natunama mate nam i kataiena, be Tamanama marae taunaḡa ya kataiena. ");
INSERT INTO dww_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Banaga Natunama na raḡanima maika Noa na raḡanie yawasana a tubutubuḡana maika. ");
INSERT INTO dww_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Muriḡa da kabaita ya tubuḡana, banaga a kanikani, a tegotego, ai naḡi be awai naḡidina. Nama a voivoia be Noa waga ak nopone ya saḡana. ");
INSERT INTO dww_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Be banaga tokare aba ḡarodie e tubuḡana, taudi nam ti kataiena. Naumeki da kabaita ya tubutubuḡana, taudi matabudi ya karuedi be upa nopone a tonedina. Inam kauinama nama tokare Banaga Natunama na kaba veraue e tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Inam raḡanine tautauḡoma rabui ta sipisipi be tenaḡa tokare anea ta nawena, be tenaḡa ta gosena. ");
INSERT INTO dww_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Be waiwaivi rabui kani ta rarau suvi, be tenaḡa tokare anea ta nawena, be tenaḡa ta gosena. ");
INSERT INTO dww_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Vutuna aubainama raḡan matabuna koi neneḡanana, baninama ami Badama na kaba verauma raḡanima nam ko kataiena. ");
INSERT INTO dww_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Uma ko noḡoti, deḡoda vada taupakinama sibo taudanedanene na kaba tavama raḡaninama i kataiena, naumeki da tauna tokare na gaburama ya bodame, be baneginama nam na vadae ya saḡa be ya danene. ");
INSERT INTO dww_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Vutuna aubainama taumi mate ko vokaukaua be ko miamia, baninama Banaga Natunama na kaba verauma, taumi tokare ko miamia nuababaḡa be e tavana. ");
INSERT INTO dww_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ai taunoya tauna waisumeḡina be nuanuauyauyana, da Bada sibo tauna ya vine? Inam taunoyanama na banagama e rabedi be adi kanima e soiedina, taudi ta ḡoeḡoena raḡanine. ");
INSERT INTO dww_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","“Raḡanine na Badama e tava munaḡa be e kitana da na taunoyama na noyama e voivoiena, naumeki da nuavere dosinama inam taunoyanama ḡarone. ");
INSERT INTO dww_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yà riuriu kauemina da Bada na purapurama matabudi tokare inam taunoyanama e ute, be tauna ei badedina. ");
INSERT INTO dww_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Be taunoya deḡoda e gewagewa be e riuna, ‘Bada bonideḡo ya naḡo be e miamia watanana.’ ");
INSERT INTO dww_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Be dabudine tauna na banagama e riḡedi be tegobua banegidima mate ta kanikani, ta tegotego buana. ");
INSERT INTO dww_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nama e voivoia nuababaḡa be na badama e tavana. ");
INSERT INTO dww_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Inam raḡanine Bada inam taunoya gewagewanama e dourakaraka be banaga kaikaiyovudima adi gabue e boru nawena. Be dabudine tokare ta yakei be gadigadidima ta sanadidi watanedina. ");
INSERT INTO dww_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Inam raḡanine tokare mara na waiguyauma inam maika umanama: Matatapu matabudi 10 adi rampama a ragaudi be a dobi da naḡivau tauḡominama verau bodebodenama a naḡona. ");
INSERT INTO dww_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Matatapu 5 buebuedima be 5 nuanuauyeuyedima. ");
INSERT INTO dww_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Matatapu buebuedima adi rampama a ragaudina be karesin nam ti ragauna. ");
INSERT INTO dww_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Be nuanuauyeuyedima taudi rampa be karesin ḡesaudima mate a ragaudina. ");
INSERT INTO dww_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Be naḡivau tauḡominama nam i tava makaina, vutuna aubainama taudi matedima a yado da a kenana. ");
INSERT INTO dww_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Naumeki da kupi poune be banaga a yogo be a riuna, ‘Naḡivau tauḡominama kaiteka e tavana! Ko dobi be ko verau beena.’ ");
INSERT INTO dww_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dabudine matatapu matabudi a midisuḡu be adi rampama a vokaukauedina. ");
INSERT INTO dww_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Be matatapu buebuedima adi banagama nuanuauyeuyedima a riuedina, ‘Karesin ko utemai, ama rampama ta gurigurina.’ ");
INSERT INTO dww_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Be taudi a paribeedi be a riuna, ‘Ibewa, karesin nam ruvana da taumi mate tà soie be teneteneḡina. Taumi ko naḡo da aitauḡa karesin ta rarau gimaredina taudi ḡarodie, be mabimie ami karesinma ko gimarana.’ ");
INSERT INTO dww_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Naumeki da taudi karesin gimerinama aubainama keda a naḡonaḡona maika, muridie naḡivau tauḡominama ya tavana. Be matatapu aitauḡa kaite a vovo kaukauana, taudi naḡivau tauḡominama mate vada nopone wainaḡi soine a saḡa, be matakeda ya guduna. ");
INSERT INTO dww_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Be matatapu buebuedima taudi muriḡa a tava be a riuna, ‘Bada, Bada, matakeda kwa kaipore aubaimaima!’ ");
INSERT INTO dww_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dabudine Bada ya paribeedi be ya riuna, ‘Yà riuriu kauemina da taugu taumi nam e kataiemina.’ ");
INSERT INTO dww_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Vutuna aubainama taumi raḡan matabuna koi neneḡanana, baninama Banaga Natunama na kaba verauma raḡaninama be na awama taumi nam ko kataiena. ");
INSERT INTO dww_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Be mate mara na waiguyauma inam maika umanama: Banaga tenaḡa muriḡa da sibo vaḡai aubainama ya naḡona, be noḡone tauna na taunoyama ya riuedina da tauna na manema ta rabedina. ");
INSERT INTO dww_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Naumeki da na taunoyama adi noyama ruvane nama mane ya utedina. Taunoya tenaḡa 5 tausand Kina ya utena, be ḡesaunama 2 tausand Kina ya utena, be ḡesaunama 1 tausand Kina ya utena. Yodibe tauna ya naḡona vaḡai aubainama. ");
INSERT INTO dww_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Be taunoya aitau da 5 tausand ya paḡopaḡona, tauna ya naḡo da manenama ya noye da yai morebi be 5 tausand ḡesau ya paḡona. ");
INSERT INTO dww_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Be nama taunoya aitau da 2 tausand ya paḡopaḡona, tauna mate manenama ya noye da yai morebi be 2 tausand ḡesau ya paḡona. ");
INSERT INTO dww_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Be taunoya aitau da 1 tausand ya paḡopaḡona, tauna ya naḡo da dom ya keri be na badama na manema dome ya semona. ");
INSERT INTO dww_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Taunoya adi badama ya mia gurata da tokare deḡo, be ya tava munaḡana. Be na taunoyama ya rawateḡeidina, baninama ya ḡoeḡoena da sibo ya kataiena, da na taunoyama tauna na manema ai morebidi bo ibewa. ");
INSERT INTO dww_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dabudine taunoya aitau da 5 tausand Kina paḡopaḡonama, tauna ya tavana 5 tausand ḡesaunama mate be ya riuna, ‘Bada, taugu 5 tausand Kina kuya uteguna, be yodi kwa kita 5 tausand Kina ḡesaunama mate è tavaitena.’ ");
INSERT INTO dww_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dabudine Bada ya riuna, ‘O, tam taunoya veremma! Taugu yaba ḡaubonama è utemna be tam kuyai patutu be kuya noye da ya morabana. Vutuna aubainama taugu tam tokare yaba toitoi yà utem, be kwai badedina. Naumeki da yodi kwa verau be taugu mate tài nuaverena.’ ");
INSERT INTO dww_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Dabudine taunoya aitau da 2 tausand Kina paḡopaḡonama tauna ya tava be ya riuna, ‘Bada, taugu 2 tausand Kina kuya uteguna, be yodi kwa kita 2 tausand Kina ḡesaunama mate è tavaitena.’ ");
INSERT INTO dww_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dabudine Bada ya riuna, ‘O, tam taunoya veremma! Taugu yaba ḡaubonama è utemna be tam kuyai patutu be kuya noye da ya morabana. Vutuna aubainama taugu tam tokare yaba toitoi yà utem be kwai badedina. Naumeki da yodi kwa verau be taugu mate tài nuaverena.’ ");
INSERT INTO dww_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Dabudine taunoya aitau da 1 tausand Kina paḡopaḡonama tauna ya tava be ya riuna, ‘Bada, taugu è kataiena da tam banaga medimedimma. Tam nam pesi ku kumedina be kwa ragaragau yababedina. Tam nam ku sipina be kwa rarau yaba yababana. ");
INSERT INTO dww_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Vutuna aubainama taugu tam è nairemna aubainama dom è keri, be am manema dome è semona. Yodi kuya kita umanema am manema ya uteute munaḡemna.’ ");
INSERT INTO dww_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dabudine Bada ya riuna, ‘Tam taunoya gewagewamma, matagayagayawimma. Tam kuya kataiena da taugu nam pesi è kumedina be yà ragaragau yababedina, be taugu nam e sipina be yà rarau yaba yababana. ");
INSERT INTO dww_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Inam naumeki, tam yau manema banike sibo kuya boru be ya noyana. Be taugu è tavana raḡanine debane anitai potonama mate sibo è paḡona. ");
INSERT INTO dww_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Inam taunoyanama gewagewanama ḡarone mane ko paḡo, be taunoya 10 tausand Kina ya voivoiena, tauna ko utena. ");
INSERT INTO dww_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Baninama aitau da na noyae ei patutu be e voivoia kauena, tauna tokare yaba ḡesaudima mate debane yà taipoto be yà utena. Be aitau na noyama e voivoia waigewagewana, avedi da tauna yaba ḡaubonama ḡarone e kenakenana, be yaḡoro taugu tokare ḡarone yà kaiporena. ");
INSERT INTO dww_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Be inam taunoyanama matagayagayawinama ko pore dobiḡe tadiwanawanae, be dabudine e yakei be gadigadinama e sanadididina.’ ");
INSERT INTO dww_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Banaga Natunama tokare na kaba waiguyauma boruborumine e mia be ma neneḡarina na aneama matabudi mate marae be ta yovona. ");
INSERT INTO dww_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Be banaga dobu matabuna tauna noḡone ta rawateḡeidi be tauna e dariḡedina, maika tauyosi sipu be gote e daridariḡedina nama. ");
INSERT INTO dww_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tauna sipu kasaunama yauwane e biridina, be gote seninama yauwane e biridina. ");
INSERT INTO dww_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Dabudine guyau banaga kasaunama yauwane tokare e riuedina, ‘Taumi aitauḡa Tamaguma yawai aiainimina, ko verau be ami buderima ko paḡona. Baninama Tamaguma muriḡa da dobu ya voiena, noḡone tauna aubaimima mara waiguyaunama ya vokaukaue be ya kenakenana, vutuna yodi koi buderiena. ");
INSERT INTO dww_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Baninama kani ya karakaraguna raḡanine, taumi kani koya utegu be è kanikanina. Be nuaguma ya rarau kasakasana raḡanine, taumi upa koya utegu be è tegotegona. Be taugu è vaḡavavaḡaina raḡanine, taumi koya riuegu da ami vadae è saḡasaḡana. ");
INSERT INTO dww_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Be gara èwai karuwaḡewaḡena raḡanine, taumi koyawai garaguna. Be taugu è sidasidana raḡanine, taumi koya raberabe kaueguna. Taugu dibure è miamiana raḡanine, taumi koya vava kitakitaguna.’ ");
INSERT INTO dww_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Inam raḡanine didimana banegidima tauna ta paribee be ta riuna, ‘Bada, airaḡan kani ya karakaratim be tauma kani kè utem? Be airaḡan nuamma ya rarau kasakasa be tauma upa kè utem? ");
INSERT INTO dww_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Be airaḡan tauma kè riuem da vadae kuya saḡa? Bo airaḡan gara kuyawai karuwaḡewaḡe be tauma gara kè utem? ");
INSERT INTO dww_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Be airaḡan tam kuya sida bo dibure kuya miamia, be tauma kè vava kitakitam?’ ");
INSERT INTO dww_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dabudine guyau taudi ya paribeedi be ya riuna, ‘Yà riuriu kauemina, da aitau tenaḡa turaguma ḡaubonama ḡarone vere kuya voiena, inam taugu ḡarogue kuya voiena.’ ");
INSERT INTO dww_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Dabudine guyau banaga seninama yauwane tokare umanama e riuedina, ‘Ko naḡo ḡavoe, taumi Mamaitua yai tara tautauemina tokare kai karakarata nonoḡinama nopone ko naḡona. Inam gabunama Mamaitua ya vovo kaukauena, Diaboro be na aneama mate aubaidima. Be taumi mate inam dabudi ko naḡona. ");
INSERT INTO dww_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Baninama taugu kani ya karakaraguna raḡanine, taumi nam kani ko uteguna. Be nuaguma ya rarau kasakasana raḡanine, taumi nam upa ko uteguna. ");
INSERT INTO dww_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Be taugu è vaḡavavaḡaina raḡanine, taumi nam ko riuegu da ami vadae è saḡana. Be taugu gara èwai karuwaḡewaḡena raḡanine, taumi nam koi garaguna. Be taugu è sidasida bo dibure è miamiana raḡandie, taumi nam ko vakitakitaguna.’ ");
INSERT INTO dww_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Inam raḡanine taudi mate ta paribee be ta riuna, ‘Bada, airaḡan kani ya karakaratim, be nuamma ya rarau kasakasa, bo kuya vaḡavaḡai, bo gara kuyawai karuwaḡewaḡe, bo kuya sida bo dibure kuya miamia, be tauma nam ke sagum?’ ");
INSERT INTO dww_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dabudine guyau taudi tokare e paribeedi be e riuna, ‘Yà riuriu kauemina, da aitau tenaḡa turaguma ḡaubonama ḡarone nam vere ko voiena, inam taugu mate ḡarogue nam ko voiena.’ ");
INSERT INTO dww_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Inam raḡanine taudi tokare ta naḡona kovoḡa kenakena nonoḡine, be didimana banegidima tokare ta naḡona yawasana kenakena nonoḡine.” ");
INSERT INTO dww_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu na giuma ya kovikovina murine, tauna na tauwai muriwatanama ya riuedina, ");
INSERT INTO dww_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Taumi koya kataiena da yodi raḡan rabui ta kenakenana, da Naḡopore soinama e tavana, be Banaga Natunama banaga nimedie ta boru nawe be ta tuparatuna.” ");
INSERT INTO dww_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dabudine pirisi adi babadama be babada ḡesaudima mate, taudi pirisi adi badama isanama Kaiyapas na vadae a rawategeidina. ");
INSERT INTO dww_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Be taudi Yesu kana kasirama a tomtomna da waimoisirie deḡo sibo a vunuḡi be ai gurina. ");
INSERT INTO dww_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Be taudi a riuna da uma kauinama nam soi nopone sibo ya tubuḡa, baninama deḡoda iḡara e nuasarina. ");
INSERT INTO dww_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu tauna Betenima, tauḡoma Saemon awai isana Kito, tauna na vadae Yesu ya miamiana. ");
INSERT INTO dww_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Dabudine Yesu ya kanikani be waivi upa ḡabuḡabunama maesinama dosinama duginama ya kiroḡi be ya tavana. Naumeki da waivi dugi vikinama ya kaipore be upa ḡabuḡabunama Yesu debane ya ḡinina. ");
INSERT INTO dww_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Be na tauwai muriwatanama nama kauinama a kitakitana, taudi nuedima ya karati be a riuna, “Aba aubainama upa ḡabuḡabunama ewai yakare? ");
INSERT INTO dww_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Uma upanama ḡabuḡabunama sibo ya raugimare da mane dosinama ya paḡo, be manenama banaga waikaruwaḡewaḡedima sibo ya utedina.” ");
INSERT INTO dww_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dabudine Yesu ya kataie da taudi aba a giugiuena, aubainama tauna ya riuedina, “Aba aubainama uma waivinama ko kawakawa nuaboya? Tauna kaua verenama ya voiena ḡarogue. ");
INSERT INTO dww_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Taumi raḡan ya toi kauana banaga waikaruwaḡewaḡedima mate ko miana. Be taugu nam uma dabudi taumi mate tà mia nonoḡa. ");
INSERT INTO dww_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tauna upa ḡabuḡabunama tunigue ya ḡini wainonoḡi, be ya kawa nonoḡiguna tai kokoagiguna aubainama. ");
INSERT INTO dww_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Taugu yà riuriu kauemina, Deḡo da deḡo dobu matabuna vari verenama ta rarau guguyena raḡanine, uma waivinama aba ya voivoiena noḡotinama mate tokare ta giu watanena.” ");
INSERT INTO dww_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dabudine Judas Iskariot, tauna tenaḡa tauwai muriwatana 12 nopodie, tauna ya naḡo pirisi adi badama ḡarone, ");
INSERT INTO dww_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","be yai taravirena, “Deḡoda taugu Yesu nimemie yà boruna, taumi aiyaba tokare taugu ko utegu?” Naumeki da taudi mane a sievi da sirin matabudi 30 be a utena. ");
INSERT INTO dww_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Inam raḡanine be nokoi ya naḡona, Judas tauna keda ya wanewanena, da Yesu taudi nimedie sibo ya boru nawena. ");
INSERT INTO dww_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Naumeki da Buredi-Nam-Sasasanina soinama raḡaninama yawai karena raḡanine, tauwai muriwatana Yesu ḡarone a tava da ai taravire be a riuna, “Deḡo dabudi kwa ḡoeḡoena tauma ka naḡo be Naḡopore soinama ka vokaukaue tam aubaimma da kwa kani?” ");
INSERT INTO dww_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Be tauna ya paribeedi be ya riuna, “Ko naḡo meagaie tauḡoma tenaḡa ḡarone be ko riuena, ‘Tauwai katakatai umanama ya riuna: Taugu yau raḡanima boruborunama kaiteka maida ya tavana. Taugu am vadae yau tauwai muriwatanama mate Naḡopore soinama ka voiena.’” ");
INSERT INTO dww_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Naumeki da tauwai muriwatana aba Yesu ya riuriuedina nama a voiena. Taudi a naḡo be Naḡopore soinama a vokaukauena. ");
INSERT INTO dww_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Be ravi ya tavatavana raḡanine, Yesu na tauwai muriwatanama 12 mate a mia gogona be a kanina. ");
INSERT INTO dww_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Taudi a kanikani be Yesu taudi ya riuedina, “Yà riuriu kauemina da nopomie tenaḡa tokare taugu e boru dobiḡeguna.” ");
INSERT INTO dww_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dabudine taudi ai nuaboya kaua be tenatenaḡaḡa a riuna, “Bada, agunai nam taugu, bo?” ");
INSERT INTO dww_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Be Yesu ya riuna, “Tauna aitau da rabuigu nimamaima teboe e yovo tenaḡana, inam tauna tokare taugu e boru dobiḡeguna. ");
INSERT INTO dww_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Be Banaga Natunama tokare e gurina girugiruminama porane e riuriuna maika, be gewagewa vavasaḡinama tauna aitau Banaga Natunama e boruboru dobiḡena ḡarone e tubuḡana. Ya verena da inam baneginama avedi da sibo ya tubuḡana.” ");
INSERT INTO dww_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Be Judas tauna vutuna tokare Yesu e boru dobiḡena, tauna mate ya riuna, “Tauwai katakatai, nam taugu, bo?” Be Yesu tauna ya riuena, “Tam ḡomimma vutuna kwa riuriuna.” ");
INSERT INTO dww_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Taudi yaḡoro a kanikani be Yesu buredi ya paḡo da yai kaiwa da ya giva be na tauwai muriwatanama ya utedi be ya riuna, “Ko paḡo be ko kanina, uma inam taugu tubuḡiguma.” ");
INSERT INTO dww_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Inam kauinama murine tauna keyaka ya paḡo, yai kaiwa da ya utedi be ya riuna, “Taumi matabumi uma keyekine ko tegona. ");
INSERT INTO dww_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Uma inam kosiniguma waianina aubainama, e rarau ḡinina banaga toitoi adi gewagewama aninoḡota porenama aubainama. ");
INSERT INTO dww_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Taugu yà riuriuemina da nam waen yà tego munaḡe, naumeki da Tamaguma na waiguyauma nopone, taumi mate tokare tà tego tenaḡana.” ");
INSERT INTO dww_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dabudine taudi a saresare kovina murine, taudi a naḡona oya Olip debane. ");
INSERT INTO dww_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Dabudine Yesu na tauwai muriwatanama ya riuedina, “Manaka kupine taumi matabumi tokare ko goseguna, baninama girugiruminama porane ya riuna, ‘Taugu tokare tauyosi yài guri be sipu adi kaba miama ta gosedi, be ta daberarana.’ ");
INSERT INTO dww_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Be taugu gurie be yà midisuḡu munaḡana murine, taugu yà gosemi be yà doka da yà naḡona Galilima.” ");
INSERT INTO dww_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dabudine Pita ya paribee be ya riuna, “Banaga matabudi tokare ḡarome aba e tubutubuḡana ta kita be naira ta naḡona, be taugu tokare nam yà gosem.” ");
INSERT INTO dww_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dabudine Yesu ya riuna, “Yà riuriu kauemna, manaka kupine muriḡa da kamkam e riuna, tam tokare raḡan rabuiteḡa kwa riuna da tam taugu nam ku kataieguna.” ");
INSERT INTO dww_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Be Pita ya riuna, “Taugu nam airaḡan tokare yà riuna, Taugu nam tam e kataiemna, be tam kwa gurigurina raḡanine, taugu tam mate tà guri tenaḡana. Be tauwai muriwatana ḡesaudima taudi mate riunama teneḡinama nama a vatona. ");
INSERT INTO dww_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Naumeki da Yesu na tauwai muriwatanama mate a naḡona dobu isanama Getsemenima, be dabudine taudi ya riuedina, “Taumi uma dabudine ko miamia be taugu yà naḡo noa dabudine yà moiragina.” ");
INSERT INTO dww_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dabudine tauna Pita be Sebedi natunatunama rabui yai dokedi, be mate a naḡona. Inam raḡanine tauna nuaboya yai kare, be nuanama ya gewagewa kauana. ");
INSERT INTO dww_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Be ya riuedina, “Taugu nopoguma nuaboya ya moḡavuna, be kaiteka nuaboya ei guriguna. Uma dabudi ko mia be tai neneḡanana.” ");
INSERT INTO dww_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Inam raḡanine Yesu ya gosedi be tauna ya taunaḡo ḡavoe da doḡae ya raupari be umanama ya moiragina, “Mamai, deḡoda teneteneḡina bo ibewa, da ḡoraḡoranama yodi e tavana nam sibo è sigue. Be avedi, nam taugu yau ḡoanama kwa voie, be tam am ḡoanama kwa voiena.” ");
INSERT INTO dww_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dabudine tauna ya tava munaḡa na tauwai muriwatanama ḡarodie, da e kitedina be taudi a kenakenana, dabudine Pita ya riuena, “Taumi tokare suara rovanama tenaḡa nopone koya mia be koyai neneḡana bo ibewa? ");
INSERT INTO dww_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ko mia be koi neneḡana, be ko moiragi da nam raurubue ko beku! Aruimima moiragi e ḡoeḡoena, be tubuḡimima e vovo gwaḡagwaḡana.” ");
INSERT INTO dww_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Naumeki da Bada raḡan aniwai rabuinama ya munaḡa be ya moiragina, “Mamai, deḡoda uma ḡoraḡoranama kai porenama nam kwa ḡoe, naumeki da tam am ḡoanama kwa voiena.” ");
INSERT INTO dww_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Raḡanine tauna ya tava munaḡana na tauwai muriwatanama ḡarodie, da e kitedina be taudi a kena munaḡana, baninama matedima a yado kauana. ");
INSERT INTO dww_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Naumeki da tauna ya gosedi da ya munaḡa, be raḡan aniwai rabuiteḡanama ya moiragi be giudima teneḡidima ya vatodina. ");
INSERT INTO dww_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Be tauna na tauwai muriwatanama ḡarodie ya tava munaḡa be ya riuedina, “Taumi yaḡoro ko kena be ko sipesipere, bo? Ko kita, Banaga Natunama ta boru dobiḡena, gewagewa banegidima nimedie raḡaninama kaiteka ya tavana. ");
INSERT INTO dww_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ko midisuḡu be tà naḡona, tauboru dobiḡeguma kaiteka umanema ya tavana.” ");
INSERT INTO dww_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu yaḡoro ya giugiu be Judas tauna tenaḡa tauwai muriwatana matabudi 12 nopodie, tauna ya tavana. Be banaga patara ḡesaudima mate a tavana, taudi nimedie kwatikwati be kwaibubu a ragaudina. Taudi inam pirisi adi babadama, be babada dosidima a riuporedina. ");
INSERT INTO dww_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Be tauborudobiḡa mataira aba e voiena, patara ya riuedina, “Deḡo baneginama yàwai suruvena, tauna vutuna ami ḡoanama, tauna ko pani be koi doka nawena!” ");
INSERT INTO dww_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Naumeki da Judas tauna didimaninama ya naḡo ḡomana Yesu ḡarone, be ya riuna, “Ebom tauwai katakatai.” Naumeki da yai suruvena. ");
INSERT INTO dww_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Be Yesu ya riuna, “Yau tura, uma dabudine kuya tavana, naumeki da am ḡoama kwa voiena.” Dabudine tautauḡoma Yesu a vunuḡi be a kaididina. ");
INSERT INTO dww_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Inam raḡanine Yesu na tauwai muriwatanama tenaḡa, kwatikwati ya kaikai suḡuna, pirisi adi badama na taunoyama beanama ya dourakana. ");
INSERT INTO dww_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Be Yesu ya riuena, “Am kwatikwatima kwa kaididi, baninama aitau da kwatikwatie ta iḡaiḡarana, inam banegidima taudi tokare kwatikwatie tai guridina. ");
INSERT INTO dww_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Deḡoda taugu sibo è ḡoena, tokare Tamaguma èi baḡa be tauna waiḡapa anea toitoi ya riuporaḡana saguguma aubainama. ");
INSERT INTO dww_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Be deḡoda nama yà voiana, tokare girugiruminama porane aba ya riuriuena sibo a tubuḡana, be tokare nam a tubuḡa.” ");
INSERT INTO dww_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Inam dabudine Yesu patara ya riuedina, “Taumi kwaibubu be kwatikwati mate koya tavana taugu ko vunuḡigu, banaga danedanenenama maika, bo? Taugu raḡan patapatanama tempol nopone è mia be èwai katakataina, be taumi nam ko vunuḡiguna. ");
INSERT INTO dww_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Be uma kauidima matabudi ta tubutubuḡana, baninama boni peroveta a girugirumidina ruvane.” Dabudine tauwai muriwatana matabudi Yesu a gose, be taudi naira a naḡona. ");
INSERT INTO dww_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Be taudi aitauḡa Yesu a panipanina, naumeki da ai doka nawena pirisi adi badama Kaiyapas ḡarone. Inam dabudine tarawatu tauwai katakataidima be babada ḡesaudima mate matabudi ai rawateḡeidina. ");
INSERT INTO dww_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Be Pita Yesu yai muriwatane be madanie muriḡa ya veraverauna, naumeki da ya saḡa ya naḡona anikaba etara gabune, pirisi adi badama na vadae. Dabudine tauna taubodama mate a mia be yawai rabana da nema sibo Yesu a etara bakena ya kitana. ");
INSERT INTO dww_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Be pirisi adi babadama be etara babadidima matabudi, a rarau rubuna da giu kaikaiyovudima deḡo sibo a banavidi, be inam giudie Yesu sibo ai gurina. ");
INSERT INTO dww_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Be matamata kaikaiyovudima toitoi dabudine a tavana, be yaḡoro taudi nam deḡo keda ti banavina da Yesu sibo ai guri. Dabudine banaga rabui a verau ");
INSERT INTO dww_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","be a riuna, “Uma tauḡominama umanama ya riuna, ‘Taugu teneḡinama da Mamaitua na tempolma yà katiwei be raḡan rabuiteḡa nopodie yà keri munaḡena.’” ");
INSERT INTO dww_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dabudine pirisi adi badama ya midisuḡu be ya riuna, “Uma banegidima tawai wavumna tokare kwa paribeedi bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Be Yesu tauna nam aiyaba i riuena. Naumeki da pirisi adi badama Yesu ya riuena, “Mamaitua yawayawasaninama isane yà riuriu vavasaḡemna, kwa riuemai: Tam vutuna Keriso, Mamaitua Natuna, bo?” ");
INSERT INTO dww_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Be Yesu ya riuna, “Ee, inam vutuna kuya vatona. Be yà riuemina: Tokare taumi Banaga Natunama Mamaitua wairewapaninama kasaunama yauwane e mia, be ma giyouna marae be e yovoyovona ko kitana.” ");
INSERT INTO dww_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dabudine pirisi adi badama tauname na garama ya sika be ya riuna, “Yodi koya vaie, tauna ewai diboḡana. Yodi nam matamata ḡesaudima tà wanedi. ");
INSERT INTO dww_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Taumi nema kowai noḡota bako?” Be taudi a paribee be a riuna, “Tauna naumeki da e gurina.” ");
INSERT INTO dww_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dabudine taudi Yesu noḡonama a kaviso be a paitina. Be ḡesaudima a raunevanevakau ");
INSERT INTO dww_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","be a riuna, “Keriso kwai nasi, aitau kabe ya riḡam?” ");
INSERT INTO dww_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Be Pita tauna anikaba etara gabunama diane ya miamia be taunoya waivinama ḡarone ya tava, be ya riuena, “Tam mate Galili Yesunama mate koya naḡonaḡona.” ");
INSERT INTO dww_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Be Pita taudi matabudi noḡodie ya bovi be ya riuna, “Tam aba kwa giugiuena, taugu nam e kataiena.” ");
INSERT INTO dww_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dabudine tauna ḡavoe ya dobi ya naḡonaḡo be waivi ḡesaunama tauna ya kita, be na banagama ya riuedina, “Noa tauḡominama mate Nasaret Yesunama mate a naḡonaḡona.” ");
INSERT INTO dww_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Be Pita ya bovi munaḡa, da ya rauseri be ya riuna, “Taugu inam tauḡominama nam e kataiena.” ");
INSERT INTO dww_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Naumeki da a mia raḡan ḡaubonaḡa be banaga aitauḡa diane a midimidina Pita a riuena, “Inam riukaua, tam mate turedima. Tam bonapakamma ewai maḡatarana ka vaivaiena.” ");
INSERT INTO dww_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Be Pita ya riu vavasaḡa be ya riuna, “Taugu yà riuriu kauana! Inam tauḡominama taugu nam e kataiena. Deḡoda taugu yà kaiyovuna, naumeki da Mamaitua tokare gewagewa ḡarogue e voiena.” Pita nama ya giugiuna inam raḡanine kamkam ya riuna. ");
INSERT INTO dww_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dabudine Yesu aba Pita ya riuriuena ya noḡotina, “Muriḡa da kamkam e riuna, tam tokare raḡan rabuiteḡa kwa bovieguna.” Dabudine Pita ya dobi ya naḡo be ya ḡaba guratana. ");
INSERT INTO dww_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Raḡanboiboi kupinaḡa pirisi adi babadama matabudi, be babada ḡesaudima adi ogama a taraḡina, da Yesu tai gurina. ");
INSERT INTO dww_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dabudine taudi Yesu nimanama a panidi be ai doka nawena, be gabeman isanama Paelat nimane a boruna. ");
INSERT INTO dww_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Be Judas tauborudobiḡa tauna e vaiena be Yesu waigurinama a giugiuena, inam raḡanine tauna yai sosori, be yai nuaboya kauana. Naumeki da Judas ya munaḡana pirisi adi babadama, be babada ḡesaudima ḡarodie be sirin 30 taudi ya ute munaḡedi, ");
INSERT INTO dww_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","be ya riuna, “Taugu gewagewa è voiena. Taugu banaga verenama è boru dobiḡa yababe be tokare tai guri, be kosininama e darorona.” Be taudi a paribeena, “Inam tam am vitama, be nam tauma ama nuaboya.” ");
INSERT INTO dww_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Naumeki da Judas mane tempol nopone ya yaraiedi, be tauna ya naḡo be ya sopana. ");
INSERT INTO dww_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dabudine pirisi adi badama manedima ya tama be ya riuna, “Tarawatu nam ima waianinana, da uma manedima tempol manenama nopone tà biridi, baninama uma inam vunuḡa manenama.” ");
INSERT INTO dww_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dabudine taudi ai oga da inam manene, gurewa tauvoienama na doḡama ta gimeri be dabudine vaḡavaḡai adi kokoagama tai tubuḡina. ");
INSERT INTO dww_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Vutuna aubainama inam dobunama yodi tawai isana ‘Kosina Dobunama’. ");
INSERT INTO dww_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Inam kauidima peroveta Jeremaia boni aba ya riuriuena, ruvane nama ya tubuḡana, inam umanama, Israel banegidima tauna na maesama a boruna, inam sirin matabudi 30. Be inam sirindima 30 ta ragaudi ");
INSERT INTO dww_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","be gurewa tauvoienama na doḡama ta gimerina, Bada ya riuriuna nama. ");
INSERT INTO dww_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Naumeki da Yesu gabeman noḡone ya midi be tauna Yesu yai taravirena, “Tam Jius adi guyau, bo?” Be Yesu ya riuna, “Ee, inam vutuna kuya vatona.” ");
INSERT INTO dww_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dabudine pirisi adi babadama be babada ḡesaudima taudi Yesu awai wavuna, be tauna nam aiyaba i giuena. ");
INSERT INTO dww_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Naumeki da Paelat Yesu yai taravirena, “Tam banaga tawai wavumna, kwa vaivaiedi bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Be Yesu nam aba i paribea rubudina. Vutuna aubainama gabeman tauna ya basena. ");
INSERT INTO dww_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Be gabeman tauna na vaivaima da soi nopodie banaga adi ḡoanama aitau dibure ta vinevinena, vutuna e kaikaiporena. ");
INSERT INTO dww_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Be inam raḡanine gewagewa baneginama isanama Barabas, tauna isanaḡonaḡonama dibure ya miamiana. ");
INSERT INTO dww_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Be patara awai rawateḡeidina raḡanine, Paelat yai taraviredi be ya riuna, “Taumi deḡo tauna ko ḡoeḡoena yà kaipore? Barabas bo Yesu, tawai isana Keriso?” ");
INSERT INTO dww_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paelat nama ya riuna, baninama tauna ya kataie da pirisi Yesu a unurena aubainama tauna nimane a boruna. ");
INSERT INTO dww_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Naumeki da Paelat etara gabune ya miamia, be na visarama vari ya riuporena tauna ḡarone be ya riuna, “Inam baneginama ḡarone nam tam aiyaba kwa voie, tauna banaga verenama. Baninama inam baneginama kana taiye taugu kupie rauboni gewagewa kaukauinama è kitana.” ");
INSERT INTO dww_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Be pirisi adi babadama be babada ḡesaudima patara a riuedina da taudi sibo Barabas kaiporenama aubainama Paelat sibo ai baḡana, be Yesu sibo yai gurina. ");
INSERT INTO dww_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Be Paelat patara yai taraviredi be ya riuna, “Uma banegidima rabui be taumi deḡo tauna ko ḡoeḡoena yà kaipore?” Be taudi a riuna, “Barabas kwa kaiporena.” ");
INSERT INTO dww_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dabudine Paelat ya riuna, “Be Yesu tawai isana ‘Keriso’, nema yà bake?” Be taudi matabudi a riuna, “Kwa tuparatuna!” ");
INSERT INTO dww_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Be Paelat ya riuna, “Aba aubainama yà tuparatu? Tauna aiyaba gewagewanama ya voie?” Be taudi a rasa gurata be a riuna, “Kwa tuparatuna!” ");
INSERT INTO dww_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Be Paelat ya raurubu be ya kita da nam keda deḡo i banavina, vutuna aubainama tauna patara matedie nimanama upae ya koḡa be ya riuna, “Taugu uma baneginama e gurina, wavunama nam taugu yà paḡo. Inam taumiḡa ami wavuma.” ");
INSERT INTO dww_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dabudine banaga matabudi a riuna, “Naumeki da tauna kosininama e rauḡini, be wavunama tauma ama sedama mate ka kiroḡina.” ");
INSERT INTO dww_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Inam raḡanine Paelat tauna Barabas ya kaipore da ya naḡona, be Yesu inam na tauiḡarama nimedie ya boruna da taudi ta riḡa be ta tuparatuna. ");
INSERT INTO dww_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Naumeki da tauiḡara Yesu ai doka saḡena Paelat na kaba miae. Be dabudine tauiḡara matabudi ai rawateḡeidina Yesu noḡone. ");
INSERT INTO dww_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Be taudi na garama a ḡiḡi pore, be gara ḡesau sabasabanama ai kotena. ");
INSERT INTO dww_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yodibe taudi gedara a pinou be Yesu debane ai mieni be a virididina, be diḡona nimanama kasaune ai paḡona. Yodibe taudi Yesu noḡone tuapikedie a raupari, da ai varavara be a riuna, “Ebom, Jius adi guyauma.” ");
INSERT INTO dww_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Naumeki da Yesu a kaviso be diḡona nimane a paḡo, be debanama a riḡa yabayababena. ");
INSERT INTO dww_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Be taudi ai varavara ya kovikovina, gara sabasabanama a kaipore, be tauna na garama ai kote munaḡena. Yodibe ai doka nawena tuparatunama aubainama. ");
INSERT INTO dww_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Be kedae tauḡoma tenaḡa a banavina, isanama Saemon, tauna Sairin meagainama baneginama. Dabudine tauiḡara inam tauḡominama a segeri da Yesu na korosima ya kiroḡina. ");
INSERT INTO dww_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Naumeki da taudi dobu isanama ‘Golgotama’ a tavana. Riu ‘Golgota’ baninama inam ‘debagarere’. ");
INSERT INTO dww_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Dabudine taudi waen be musara kavisonama mate a gwada tenaḡe, be Yesu a utena da sibo ya tegona. Be tauna ya remorubu da ei damina be tegonama ya tuaḡaiena. ");
INSERT INTO dww_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Naumeki da taudi Yesu korosie a tuparatu be na garama ai kasiedina. Be aitau kasie yawai rewapanana, tauna deḡo garanama ya ḡoeḡoena, nama ya paḡona. ");
INSERT INTO dww_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Be dabudine taudi a mia be Yesu a rabe be a kitakita watanina. ");
INSERT INTO dww_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Be aba aubainama Yesu a tuparatuna, vutuna kai ḡaubonama bogane umanama a girumana Uma tauna Yesu, Jius adi guyauma Yodibe Yesu debane korosi bogane kainama a tutuna. ");
INSERT INTO dww_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Be inam dabudine taudi banaga danedanenedima rabui mate a tuparatudina, tenaḡa Yesu kasaune be tenaḡa senine. ");
INSERT INTO dww_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Be banaga aitauḡa kedaḡa a naḡonaḡona, taudi debedima a kwadiedi da Yesu ai diboḡi, ");
INSERT INTO dww_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","be a riuriuna, “Iyo! Tam dokane kuya riuna da tempol kwa katiwei be raḡan rabuiteḡa nopodie kwa keri munaḡena. Yodi kwai yawasana munaḡem. Deḡoda tam Mamaitua Natunama, naumeki da yodi korosi boganaḡa kwa yovo be ka kitam.” ");
INSERT INTO dww_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Inam kauinama teneḡine pirisi adi babadama be tarawatu tauwai katakataidima, be babada ḡesaudima mate taudi Yesu ai varavara, be a riuna, ");
INSERT INTO dww_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tauna banaga ḡesaudima yawai yawasanidina, be yodi taunaḡa nam tokare ei yawasana munaḡe! Deḡoda tauna Israel guyaunama, naumeki da korosi boganaḡa e yovo be tauma kai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tauna Mamaitua ewai sumaḡe be ya riuriuna, ‘Taugu Mamaitua Natunama.’ Yodi kabe tà kita Mamaitua tauna waiyawasaninama e ḡoeḡoe bo ibewa.” ");
INSERT INTO dww_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Be banaga danedanenedima rabui Yesu mate a tupatuparatudina, taudi mate Yesu ai diboḡina. ");
INSERT INTO dww_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Be suaratopu dobu yai kupikupina naumeki da ravie 3-okoroki paratinama. ");
INSERT INTO dww_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Be ravie 3-okoroki nama Yesu bonanama dosine umanama ya riuna, “Eli, Eli, lema sabaktani?” Uma giunama baninama inam umanama, “Yau Mamaituama, yau Mamaituama, aba aubainama kuya gose poregu?” ");
INSERT INTO dww_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Be banaga ḡesaudima dabudine diane a midimidina nama a vaivaiena, taudi a riuna, “Koi beavaia! Tauna Elaija e yokoyokoena!” ");
INSERT INTO dww_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Be dabudine tauḡoma tenaḡa anitaiyo ya paḡo, be ya manini ya saḡa ya naḡo da waen ḡoraḡorane yai sonom da kai isune ya pani be Yesu sibo yai tegona, ");
INSERT INTO dww_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","be banaga ḡesaudima a riuna, “Nakarua, kwa gose! Elaija e yovoyovona ei yawasanina tà kitana.” ");
INSERT INTO dww_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Be Yesu bonanama dosine ya yogona, naumeki da tauname aruinama ya raukaigosena. ");
INSERT INTO dww_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Inam kauinama ya tubutubuḡana raḡanine, gara tempol nopone matakeda waisaurinama, ya nuasika poraḡa da ma nevana a kenana. Be doḡa ya gusu be yeku a nuasenana. ");
INSERT INTO dww_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Be inam raḡanine kokoaga gayedima a nuaporaḡa be banaga babaudima guriguridima toitoi a midisuḡu munaḡana. ");
INSERT INTO dww_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Be tauna na kaba midisuḡu munaḡama murine, taudi kokoaga a dobi pore be a naḡona meagai babaune, be banaga toitoi ḡarodie a maḡatarana. ");
INSERT INTO dww_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Be tori matanama na tauiḡarama mate Yesu a rabe be a kitakita watanina, taudi yoyo be yaba matabudi a tubutubuḡana, nama a kitekitedina, taudi a naira kaua be a riuna, “Uma tauna inam riukaua Mamaitua Natunama!” ");
INSERT INTO dww_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Be dabudine waiwaivi mate, taudi madanie a midi be awai kitana. Inam waiwaividima taudi Galilima Yesu waimuriwatanenama ai karena, be aba tauna ya ḡoeḡoena nama a sagusaguna. ");
INSERT INTO dww_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Be inam waiwaividima matabudi nopodie inam Meri Magdalin, Meri Jeims be Jousep tinedima, be Sebedi natunatunama tinedima. ");
INSERT INTO dww_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Be ravi ya tavatavana paratine, waiguyau baneginama Arimatia meagaine be ya tavana, isanama Jousep. Inam baneginama tauna mate Yesu tauwai muriwatanenama. ");
INSERT INTO dww_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tauna ya naḡo Paelat ḡarone be yai baḡana da Yesu tubuḡinama sibo ya paḡona. Naumeki da Paelat na tauiḡarama ya riuedi, da Yesu tubuḡinama Jousep a utena. ");
INSERT INTO dww_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Naumeki da Jousep Yesu tubuḡinama ya paḡo, be gara ḡavoḡavoridie ya sumana. ");
INSERT INTO dww_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Be Jousep tauname na kokoagama vaunama yeku vasivasi wainonoḡinama nopone, Yesu tubuḡinama ya boruna. Yodibe yeku dosinama yai rawakui da kokoaga matakedanama yai miditom, be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Be Meri Magdalin be Meri ḡesaunama taudi kokoaga noḡone noaḡo a miamiana. ");
INSERT INTO dww_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Raḡan ya tom da pomainama Sabat raḡanine, be pirisi adi babadama be Parisi a naḡo Paelat ḡarone be a riuna, ");
INSERT INTO dww_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Bada, tauma yaḡoro ka noḡonoḡotina da uma baneginama kaikaiyovunama dokane yawai yawasanana umanama ya riuna, ‘Taugu tokare raḡan aniwai rabuiteḡane yà midisuḡu munaḡana.’ ");
INSERT INTO dww_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Vutuna aubainama kawai baḡamna da kokoaga kwa gudu kaue be taubodama kokoaga ta rabena naumeki da raḡan wairabuiteḡanama e kovina. Deḡoda na tauwai muriwatanama ta tava be tubuḡinama ta danene, be ta naḡo da banaga ta riuedina, ‘Yesu kaite ya midisuḡu munaḡana.’ Deḡoda inam nama e tubuḡana, naumeki da inam kaiyovunama tokare kaiyovu dokanama ei moraba guratena.” ");
INSERT INTO dww_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dabudine Paelat taudi ya riuedina, “Naumeki, tauiḡara yà riuporedi da taumi mate ko naḡo be kokoaga ta rabena, be ami noḡotama ruvane nama ko gudu waikaikaina.” ");
INSERT INTO dww_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Naumeki da taudi a naḡo da kokoaga a gudu waikaikai ya kovi, yodibe tauiḡara kokoaga matakedanama a midi ḡaḡari be kokoaga a rabena. ");
INSERT INTO dww_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat raḡaninama murine, pomainama Sande raḡantomtom, Meri Magdalin be Meri ḡesau mate a naḡona kokoaga kivunama aubainama. ");
INSERT INTO dww_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Inam raḡanine anea ya yovoyovona, yoyo dosinama ya tubuḡana. Be anea ya naḡo kokoagae be yeku dosinama kokoaga matakedanama waimiditomnama yai rawakui ḡavoe ya naḡo, be tauna yekunama debane ya miana. ");
INSERT INTO dww_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Be anea kitanama maika keama, be na garama ḡavoḡavora tunutununama. ");
INSERT INTO dww_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dabudine tauiḡara taudi a naira kauana, be naira ya kawa gusugusudi be a guri gidavana. ");
INSERT INTO dww_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naumeki da anea waiwaivi ya riuedina, “Nam ko naira! Taugu è kataiena da taumi Yesu a tuparatuna, vutuna ko wanewanena. ");
INSERT INTO dww_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tauna nam uma dabudine. Tauna kaite ya midisuḡu munaḡana, boni ya riuriuna maika. Ko verau be na kaba kenama gabunama ko kita. ");
INSERT INTO dww_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Be waiḡapa ko naḡo da na tauwai muriwatanama umanama ko riuedina, ‘Yesu ya guri be ya midisuḡu munaḡana, be yodi ya doka be e naḡonaḡona Galilima, be dabudine taumi tokare tauna ko kitana.’ Inam vutunaḡa è riuemina.” ");
INSERT INTO dww_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Naumeki da waiwaivi kokoaga a gosena, nopodima naira be mosari ya moḡavuna, be a manini a naḡona tauwai muriwatanama riuedima aubainama. ");
INSERT INTO dww_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Taudi a naḡonaḡo be Yesu yai raḡantenaḡe da ḡarodie ya tava be ya riuna, “Ebom.” Be waiwaivi tauna ḡarone a naḡo da tuapikedie a raupari, be kaḡanama a kaididi be a rauduneena. ");
INSERT INTO dww_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dabudine Yesu taudi ya riuedina, “Nam ko naira! Ko naḡo be tasitasiguma ko riuedi da ta naḡona Galilima. Be dabudine taudi taugu ta kitaguna.” ");
INSERT INTO dww_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Naumeki da waiwaivi keda a naḡonaḡona maika, tauiḡara a naḡona meagaie pirisi adi babadama ḡarodie, be yaba matabudi a tubutubuḡana ai varidina. ");
INSERT INTO dww_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dabudine pirisi adi babadama be babada ḡesaudima mate ai boru be adi ogama a taraḡina. Yodibe tauiḡara mane dosinama a utedi ");
INSERT INTO dww_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","be a riuedina, “Ko naḡo be banaga umanama koi varidina, ‘Tauma kupie kè kena nuakoa, be debamaie Yesu na tauwai muriwatanama a tava be Yesu tubuḡinama a danenena.’ ");
INSERT INTO dww_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Be deḡoda gabeman uma giunama ima vaie, tokare tauma ka gwayedi da nam aba gewagewanama ko banavi.” ");
INSERT INTO dww_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Naumeki da tauiḡara mane a ragaudi be aba pirisi be babada ḡesaudima a riuriuedina nama a voiedina. Be inam gututunama Jius nopone ya daberarana, naumeki da yodi. ");
INSERT INTO dww_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Inam raḡanine tauwai muriwatana matabudi 11 a naḡona Galilima. Dabudine taudi a naḡona oyae deḡo Yesu dokane ya riuriuedina dabudine. ");
INSERT INTO dww_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Be raḡanine taudi Yesu a kitakitana, dabudine a rauduneena, be ḡesaudima taudi a noḡota bekubekuna. ");
INSERT INTO dww_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Naumeki da Yesu taudi ḡarodie ya tava be ya riuna, “Rewapana marae, be dobue matabudi Mamaitua taugu ya uteguna. ");
INSERT INTO dww_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Vutuna aubainama ko naḡo be banaga dobu matabuna nopone ko voiedi da yau tauwai muriwatanama ta tubuḡana. Be koi babataitodina Tamanama, Natunama be Arua Babau isedie. ");
INSERT INTO dww_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Be aba è riuriu vavasaḡemina, yabedima matabudi taudi koi katakataidi da ta voteyeteyedina. Be yà riuriu kauemina da taugu raḡan matabuna taumi mate, naumeki da raḡan damone.” ");
INSERT INTO dww_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mamaitua Natunama, Yesu Tauwai yawasana varinama verenama umanama yai karena. ");
INSERT INTO dww_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Maika nema peroveta Aisaia ya girugirumina nama, Mamaitua ya riuna, “Taugu tokare tauwai noyanoya yà riupore dokena da tauna am kedama e sepana. ");
INSERT INTO dww_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Banaga dobu kavakavane e yokoyokona, ‘Keda ko kawa vereveredi be ko kawa didimanidi be Bada e veraverauna.’” ");
INSERT INTO dww_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Naumeki da Jon dobu kavakavane ya maḡatara be yawai babataito be noḡota viravira ya rarau guguyedina da Mamaitua banaga adi gewagewama sibo ya noḡota poredina. ");
INSERT INTO dww_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Banaga toitoi Juda provins nopone be Jerusalem meagaine matabudi a dobi a naḡona Jon ḡarone. Dabudine taudi adi gewagewama ai maḡataridi be Jon Jodan upane yai babataitodina. ");
INSERT INTO dww_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon na garama kamel vuvuḡine voivoienama ya kotekotena. Be musara kopinama kwarikwarinama yai boretaie be na kanima kapau be dobira iwavinama. ");
INSERT INTO dww_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tauna banaga umanama yai varidina, “Banaga murigue e veraverauna tauna yai rewapana vavasaḡana, nam maika taugu. Taugu nam veregu da yà raudune be na kaḡasumama yà kaiporedi. ");
INSERT INTO dww_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taugu upakavakavae yàwai babataitomina, be tauna tokare Arua Babaue ei babataitomina.” ");
INSERT INTO dww_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Inam raḡandie Yesu Nasaret meagaine Galili provins nopone be ya verauna, da Jon Jodan upane Yesu yai babataitona. ");
INSERT INTO dww_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Raḡanine Yesu upae be ya potipoti tavana, tauna e kitana be mara yai raḡantenaḡe da ya nuaporaḡa be arua ya yovoyovona ḡarone maika kiu gabubu. ");
INSERT INTO dww_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dabudine bona marae ya riuna, “Tam taugu natuḡomiguma be taugu yàwai nuaverena ḡarome.” ");
INSERT INTO dww_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Naumeki da Arua Yesu yai doka nawena dobu kavakavane. ");
INSERT INTO dww_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Be inam dabudine tauna ya miana raḡan matabudi 40 be Seitan Yesu ya raurubuna. Be inam dabudine dobira museridima mate be anea a dobi be a saguna. ");
INSERT INTO dww_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Raḡanine Jon dibure a boruboru nawena, murine Yesu ya naḡona Galilima be Mamaitua varinama verenama ya rauguguyena. ");
INSERT INTO dww_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yesu ya riuna, “Raḡan kaua ya tavana be Mamaitua na waiguyauma kaiteka e tavatavana da Mamaitua na waibadama ei karena. Vutuna aubainama ami gewagewama ko kuvesidi be vari verenama koi sumaḡena.” ");
INSERT INTO dww_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Raḡanine Yesu Galilima yawawa dianaḡa ya naḡonaḡo be tauwai sagida rabui ya kitedina, Saemon be tasinama Endru taudi sagide iyana a konekonedina. ");
INSERT INTO dww_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Be Yesu ya riuedina, “Koi muriwatanegu be taugu yài katakataimi da banaga ko konedina.” ");
INSERT INTO dww_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Raḡanine Yesu nama ya riuriuedina, taudi waiḡapa adi sagidama a gosaḡa be tauna ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Dabudine tauna ya taunaḡo ḡaubonaḡa be Sebedi natunatunama Jeims tasinama Jon mate wagae ya kitedina, adi sagidama a kawakawa batebatedina. ");
INSERT INTO dww_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Raḡanine Yesu taudi ya kitekitedina, tauna ya yokoedi be taudi tamedima Sebedi be na yarayaragama mate wagae a gosedi be Yesu ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu be na tauwai muriwatanama a verauna Kapeniam meagaine, be Sabat raḡanine Yesu ya naḡona sinagog nopone be waikatakatai yai karena. ");
INSERT INTO dww_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dabudine banaga aitauḡa na waikatakataima nama a vaivaiena, taudi a basena, baninama tauna nam maika tarawatu tauwai katakataidi be tauna na waikatakataima rewapana mate. ");
INSERT INTO dww_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Dabudine penama tauḡoma kokukokunama ya saḡa sinagog nopone ya yogo be ya riuna, ");
INSERT INTO dww_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaret Yesumma, tam am noyama aba tauma ḡaromaie? Tam uma dabudine kuya tavana kwa kawa gewagewamai, bo? Taugu è kataiena tam aitau. Tam Mamaitua na Taunoya babauma.” ");
INSERT INTO dww_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu arua gewagewanama ya riutuaḡaie be ya riuna, “Kwai nuatuḡu be tauḡominama kwa dobi pore!” ");
INSERT INTO dww_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dabudine arua gewagewanama tauḡoma ya kawa gusugusu, ya kawa yogoyogo be ya dobi porena. ");
INSERT INTO dww_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Banaga matabudi a base be ai taraviravira be a riuna, “Uma aba kauina? Inam waikatakatai vauna, bo? Rewapana mate tauna arua gewegewedima mate e riuedi be ta vovo teyeteyena.” ");
INSERT INTO dww_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Naumeki da dabudine Yesu varinama ya daberara makaina Galili provinsnama nopone. ");
INSERT INTO dww_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na tauwai muriwatanama mate be Jeims da Jon sinagog a gose be didimaninama a naḡona Saemon be Endru adi vadae. ");
INSERT INTO dww_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saemon rawanama sida poyapoya ya paḡo be gunie ya kenakenana. Be raḡanine Yesu ya tavatavana, tauna inam sidanama ai varina. ");
INSERT INTO dww_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu ya naḡo waivinama ḡarone da nimane ya kaididi be ya kawa midisuḡuna. Dabudine poyapoya waivi ya gose be tauna adi kanima soienama yai karena. ");
INSERT INTO dww_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Inam ravine suara ya yovoyovona murine banaga adi banagama sidesidedima be aitauḡa penama kokukokudima a verauḡedina Yesu ḡarone. ");
INSERT INTO dww_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Banaga matabudi meagaie miemienidima vada matakedane ai rawateḡeidina. ");
INSERT INTO dww_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Be Yesu banaga aitauḡa sida tabu be tabu ragaragaudima yai yawasanidi be penama toitoi ya tavu dobiḡedina. Be Yesu penama ya kauedi da nam aba ti giuena, baninama taudi a kataie da Yesu tauna aitau. ");
INSERT INTO dww_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Raḡanboiboi kupinaḡa muriḡa da raḡan ya yanana, Yesu ya midisuḡu da vada be meagai ya gosedi be ya naḡona dobu wainuatoitoine dabudine ya moiragina. ");
INSERT INTO dww_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Be Saemon na varoroma ḡesaudima mate a naḡona Yesu wanenama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Be raḡanine Yesu a banabanavina, taudi a riuna, “Banaga matabudi tam ta wanewanemna.” ");
INSERT INTO dww_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu ya paribeedi be ya riuna, “Tà naḡo wari kedaḡa be uma meagainama diane meagaidima ḡarodiḡa mate yà rauguguyana, baninama taugu vutuna aubainama è yovona.” ");
INSERT INTO dww_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naumeki da Yesu Galili noponaḡa ya babara naḡo be sinagog nopodiḡa ya rarau guguya be penama ya tavutavu dobiḡedina. ");
INSERT INTO dww_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tauḡoma kito paḡopaḡonama ya verau Yesu noḡone be doḡae ya raupari da sagu yai baḡe be ya riuna, “Deḡoda tam kwa ḡoena, taugu kwai yawasanigu.” ");
INSERT INTO dww_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dabudine Yesu noponama raunuatoi ya moḡavu be nimanama yai yoyo da tauḡoma ya taukoni be ya riuna, “Naumeki, taugu yà ḡoeḡoena, kwa yawasana!” ");
INSERT INTO dww_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dabudine sida kito yai raḡantenaḡe da tauḡoma ya gose be tauna ya yawasanana. ");
INSERT INTO dww_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Naumeki da Yesu tauḡoma ya riupore be umanama ya riu vavasaḡena, ");
INSERT INTO dww_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kwa kita kaua da uma kauinama nam aitau kwai vari be didimaninama kwa naḡo da pirisi ḡarone kwai maḡatara munaḡem be Mamaitua kwa tipana Mousis na tarawatuma e riuriuna nama. Kwa voie da banaga ta kita da tam kuya yawasana munaḡana.” ");
INSERT INTO dww_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Be yaḡoro tauḡoma ya raukosoḡaiḡai da ya naḡo be Yesu varinama meagai matabuna noponaḡa ya giu gurate be yai daberarina. Vutuna aubainama Yesu meagaie debaḡa nam i naḡona be dobu wainuatuḡutuḡudie ya miamiana. Be yaḡoro banaga deḡo deḡo miemienidima ḡarone a tavatavana. ");
INSERT INTO dww_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Raḡan bisanama a kovikovina murine Yesu ya munaḡana Kapeniamma be banaga varinama a vaie da tauna inam dabudine ya tavana. ");
INSERT INTO dww_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dabudine banaga toitoi ai rawateḡeidi da nam gabu deḡo i kena rubuna be matakeda noḡonama mate ya moḡavuna. Be Yesu vari verenama ya rauguguyena ḡarodie. ");
INSERT INTO dww_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dabudine tautauḡoma 4 tauḡoma tuera paḡopaḡonama a kiroḡi tavaitena Yesu ḡarone. ");
INSERT INTO dww_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Be taudi nam teneteneḡina da Yesu ḡarone a verauḡe, baninama patara ya morabana. Vutuna aubainama taudi vada debane gaura a voiena, deḡo Yesu ya midimidie. Naumeki da tauḡoma tuera paḡopaḡonama kebana debane ma ratiratina ai dawe yovoḡena. ");
INSERT INTO dww_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Raḡanine Yesu adi waisumaḡama nama ya kitakitana, tauna tauḡoma tuera paḡopaḡonama ya riuena, “Taukui, am gewagewama è noḡota porena.” ");
INSERT INTO dww_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dabudine aitauḡa tarawatu tauwai katakataidima a miamiana, taudiḡa nopodie ai nuanoḡonoḡota be a riuna, ");
INSERT INTO dww_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Aba aubainama uma tauḡominama nama e giugiu? Tauna Mamaitua ewai diboḡina. Nam aitau gewagewa e noḡota pore, be Mamaitua taunaḡa.” ");
INSERT INTO dww_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dabudine Yesu waiḡapa aruine ya kataie da taudi nopodie aba awai nuanoḡonoḡotena be ya riuedina, “Aba aubaina uma kauidima kowai nuanoḡonoḡotedi? ");
INSERT INTO dww_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Deḡo tauna ya tekateka tauḡoma tuera paḡopaḡonama tà riuena, ‘Am gewagewama è noḡota porena,’ bo tà riuna, ‘Kwa midisuḡu, am gunima kwa paḡo be kwa naḡo?’ ");
INSERT INTO dww_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Be yodi yài kataimi be ko kataie da Banaga Natunama dobue rewapana ḡarone da gewagewa e noḡota porena.” Naumeki da Yesu tauḡoma tuera paḡopaḡonama ya riuena, ");
INSERT INTO dww_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Yà riuriuemna, kwa midisuḡu, am gunima kwa paḡo be kwa naḡo am vadae!” ");
INSERT INTO dww_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dabudine tauḡoma waiḡapa ya midisuḡu, na gunima ya paḡo be patara matedie be ya naḡona. Uma kauinama banaga matabudi a base be Mamaitua isanama a kaisuḡu be a riuna, “Tauma uma kauinama nam ama kaba kita.” ");
INSERT INTO dww_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Dabudine Yesu ya munaḡana yawawa dosinama diane be patara dosinama ḡarone a verau be waikatakataidima yai karena. ");
INSERT INTO dww_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Raḡanine tauna ya naḡonaḡo da kedae e kitana be Alpias natunama Livai teks tautaminama tauna na kaba noyae ya miamia be Yesu tauna ya riuena, “Kwai muriwatanegu!” Dabudine Livai ya midisuḡu be Yesu yai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Muriḡa nama Livai na vadae Yesu ya kanikani be teks tautamidi, gewagewa banegidima, be na tauwai muriwatanama mate ai rawateḡeidi be a kanikani tenaḡana. Baninama taudi matabudi Yesu awai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Raḡanine tarawatu tauwai katakataidima, taudi vutuna Parisi, nama ta kitana be Yesu gewagewa banegidima be teks tautamidima mate a kanikanina, taudi na tauwai muriwatanama a riuedina, “Aba aubainama tauna umanama banegidima mate ta kanikani?” ");
INSERT INTO dww_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Raḡanine Yesu nama ya vaivaiena, tauna ya riuedina, “Banaga yawayawasanidima taudi nam dogeta tima ḡoeḡoena be banaga sidesidedima taudi dogeta ta ḡoeḡoena. Taugu nam e yovona banaga veredima aubaidi, taugu banaga gewegewedima aubaidima è yovona.” ");
INSERT INTO dww_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naumeki da Jon na tauwai muriwatanama be Parisi a widiwidina be banaga ḡesaudima a tava Yesu ḡarone be ai taravirena, “Nemanama da Jon na tauwai muriwatanama be Parisi adi tauwai muriwatanama taudi ta widiwidina, be tam am tauwai muriwatanama ibewa?” ");
INSERT INTO dww_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ya paribeedina, “Nemanama da naḡivau tauḡominama na warema ta widina raḡanine yaḡoro tauna taudi mate? Raḡanine naḡivau tauḡominama yaḡoro taudi mate taudi nam tokare ta widina. ");
INSERT INTO dww_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Be raḡan e tavana da naḡivau tauḡominama ḡavoe ta nawena, yodibe inam raḡanine ta widinana. ");
INSERT INTO dww_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nam aitau gara nuasikanama poranama e paḡo be gara vaunama mate e popo tenaḡe. Deḡoda nama e voiana, gara nuasikanama vaunama tokare gara poranama e sika pore be gaura e moraba guratana. ");
INSERT INTO dww_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Be nam aitau waen vaunama e paḡo be waen koukounama poranama nopone e ḡini. Deḡoda nama e voiana, tokare koukou e nuagoru da waen e nuaḡini be rabuidi ta gewagewana. Ibewa! Tauna waen vaunama koukou vaunama nopone e ḡinina.” ");
INSERT INTO dww_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat tenaḡa Yesu be na tauwai muriwatanama mate yaḡoda sipinama nopodiḡa a naḡonaḡona, be na tauwai muriwatanama yaḡoda ragaudima ai karena. ");
INSERT INTO dww_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Be Parisi Yesu a riuena, “Tauma ama tarawatuma e riuriuna da Sabat raḡanine nam nama sibo am tauwai muriwatanama a voia, be taudi ta voivoiana.” ");
INSERT INTO dww_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Be Yesu ya paribeedi be ya riuna, “Taumi Deivid aba ya voivoiena koya sievi bo ibewa? Raḡanine tauna na varoroma mate kani a ḡoe kauena, ");
INSERT INTO dww_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","tauna Mamaitua na vadae ya naḡo be buredi Mamaitua waikatainama ya paḡo be ya kanina. Be na varoroma mate ya utedi be a kanina avedi da pirisi taudiḡa sibo a kanikanina, baninama tarawatu e riuriuna nama. Inam raḡandie pirisi adi badama isanama Abiata na raḡanie.” ");
INSERT INTO dww_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Naumeki da Yesu taudi ya riuedina, “Sabat e kenakenana banaga aubainama be nam Sabat banaga ei bade. ");
INSERT INTO dww_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Vutuna aubainama Banaga Natunama yaḡoro Sabat ewai badena.” ");
INSERT INTO dww_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Raḡan ḡesaune Yesu ya naḡo sinagog vadanama nopone be dabudine tauḡoma nimanama tuera poḡopaḡonama ya miamiana. ");
INSERT INTO dww_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Inam dabudi banaga ḡesaudima mate Yesu a kitakita watanina deḡoda tauna Sabat raḡanine banaga sibo i yawasanina, dabudine taudi tokare ai samanina. ");
INSERT INTO dww_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Be Yesu tauḡoma nimanama tuera poḡopaḡonama ya riuena, “Kwa saḡa be banaga matabudi nopodie kwa midi!” ");
INSERT INTO dww_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dabudine Yesu banaga yai taraviredina, “Aba dà tarawatuma e riuriuedana da tà voie: Sabat raḡanine yaba veredima tà voiedi bo yaba gewegewedima tà voiedi, banaga tài yawasani bo tài guri?” Be taudi nam aba ti riuena. ");
INSERT INTO dww_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu nuanama yai medi da ya kita vireviredina be ya raunuatoi kauedina, baninama taudi adi nopobadoma be adi voia waigewama aubainama. Dabudine Yesu tauḡoma ya riuena, “Nimamma kwai yoyo!” Be tauḡoma nama ya voia be nimanama ya vere munaḡana. ");
INSERT INTO dww_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dabudine Parisi sinagog a gose pore be a naḡona Herod na damma mate ai rawateḡeidi be Yesu na kasirama tomnama ai karena, da tauna sibo ai gurina. ");
INSERT INTO dww_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu be na tauwai muriwatanama mate a naḡona Galili yawawine be dabudine banaga patara ai muriwatanedina. ");
INSERT INTO dww_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Raḡanine ta vaiena be Yesu yaba matabudi ya voivoiedina, banaga toitoi ḡarone a tavana. Taudi Judiaḡa, Jerusalemḡa, Idumeaḡa be Jodan be nuaḡo nevane Taia be Saidon banegidima mate a tavana. ");
INSERT INTO dww_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Baninama patara ya morabana aubainama, Yesu na tauwai muriwatanama ya riuedi da waga ḡaubonama ta kawa nonoḡina tauna aubainama, da patara nam tauna ta midi ḡuruvi be ta tauporepore. ");
INSERT INTO dww_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Baninama banaga toitoi yawai yawasanidina, vutuna aubainama banaga sidesidedima toitoi a rarau rubu guratana da sibo Yesu a taukonina. ");
INSERT INTO dww_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Raḡanine aitauḡa arua gewegewedima kokukokudima Yesu a kitakitana, taudi kaḡapakane a raudune be bonedima dosine a riuna, “Tam Mamaitua Natunama.” ");
INSERT INTO dww_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Be taudi ya riu vavasaḡedi da nam sibo aitau a riue da tauna aitau. ");
INSERT INTO dww_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ya naḡo oya debane be aitauḡa tautauḡomidima ya ḡoeḡoedina, nama ya yokoedina. ");
INSERT INTO dww_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Raḡanine taudi tauna ḡarone a tavatavana, taudi 12 ya vinedi be yai isedina ‘Apasol’, da taudi tauna mate be tauna ya riupore nawedi da ta rauguguyana. ");
INSERT INTO dww_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Be rewapana a paḡo da penama ta tavu dobiḡedina. ");
INSERT INTO dww_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Uma banegidima 12 Yesu ya vinedina inam Saemon, Yesu yai isana Pita. ");
INSERT INTO dww_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jeims, Sebedi natunama be tasinama Jon, taudi yai isedina ‘Boaneges’, inam riunama baninama ‘parere natunatunama’. ");
INSERT INTO dww_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endru, Pilip, Batolomiu, Metiu, Tomas be Jeims, tauna Alpius natunama, Tadeas, Saemon tauna Selot. ");
INSERT INTO dww_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Be Judas Iskariot, tauna Yesu tauwai karakarakutuenama. ");
INSERT INTO dww_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Dabudine Yesu ya munaḡana vadae, you, yaḡoro patara Yesu ḡarone ai rawateḡeidina, be nam kaisavo deḡo, da sibo Yesu na tauwai muriwatanama mate a mia be a kani. ");
INSERT INTO dww_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Raḡanine na damma uma kauinama nama a vaivaiena, taudi a naḡona Yesu waidokenama aubainama. Baninama taudi a riuna, “Tauna ya buana.” ");
INSERT INTO dww_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Be tarawatu tauwai katakataidima ḡesaudima, aitauḡa Jerusalemḡa veraveraudima, a riuna, “Penama adi guyauma Yesu ya kokuna. Tauna vutuna rewapana Yesu e ute be penama ewai dobidina.” ");
INSERT INTO dww_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Vutuna aubainama Yesu ya yokoedi ḡarone be wainasie ya giugiuedina, “Nemanama da Seitan tauname e tavu dobiḡa munaḡe? ");
INSERT INTO dww_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Deḡo dobunama banegidima tai kawa ḡasiḡasi be ta dariḡa munaḡedina, inam dobunama tokare e kawa gewagewa munaḡena. ");
INSERT INTO dww_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Be deḡo damnama tai kawa ḡasiḡasi be ta dariḡa munaḡedina, inam damnama tokare ta kawa gewagewa munaḡedina. ");
INSERT INTO dww_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Be nama teneḡinama, deḡoda Seitan na waiguyauma e dariḡa munaḡena be dam ei tubuḡana, inam damdima tokare nam ta kena nonoḡa, da ta kawa gewagewa munaḡedi be tai kavena. ");
INSERT INTO dww_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tauḡoma wairewapaninama na vadama nam aitau e gigi da e saḡa be na purapurama e ragaudi, deḡoda noḡone tauḡominama wairewapaninama e pani doke be muriḡa e saḡa da inam tauḡominama na purapurama e ragaudina. ");
INSERT INTO dww_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Yà riuriu kauemina, banaga adi voia waigewa be adi waidiboḡama tokare Mamaitua e noḡota poredina. ");
INSERT INTO dww_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Be deḡoda aitau Arua Babau ḡarone e riuriu viravirana, tokare Mamaitua nam e noḡota pore, baninama tauna gewagewa kenakena nonoḡinama ya voiena.” ");
INSERT INTO dww_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu nama ya riuna, baninama banaga ḡesaudima umanama a riuriuna, “Tauna arua gewagewanama nopone.” ");
INSERT INTO dww_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naumeki da Yesu tinana be tasitasinama a tavana. Taudi doḡae a midi kwasa be Yesu a riuwanena. ");
INSERT INTO dww_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Be patara Yesu a miamia kwavivirona, taudi Yesu a riuena, “Kwa kita! Tinam be tasitasimma a tava be gabure ta midimidi be taudi tam ta ḡoeḡoemna.” ");
INSERT INTO dww_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu ya paribeedi be ya riuna, “Aitau tinagu be aitau tasitasigu?” ");
INSERT INTO dww_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dabudine banaga Yesu a miamia kwaviviroena ya kitedi be ya riuna, “Ko kita! Umanema tinatinagu be tasitasiguma. ");
INSERT INTO dww_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aitau da Mamaitua na ḡoanama e voivoiena, tauna vutuna tasigu, nuvugu be tinaguma.” ");
INSERT INTO dww_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu Galili yawawinama diane waikatakatai yai kare munaḡena. Be patara dosinama a rawateḡeidina aubainama, tauna topae waga debane ya saḡa be ya miana. Be patara matabudi taudi barabarae upa diane a miana. ");
INSERT INTO dww_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tauna wainasie yaba toitoi yai katakataidi be ya riuedina, ");
INSERT INTO dww_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Koi beavaia! Raḡan tenaḡa taukuma ya naḡona pesi kumanama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Raḡanine pesi yawai yaraiedina, ḡesaudima keda poune a ravusedina be kiu a tava be a kanidina. ");
INSERT INTO dww_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Be ḡesaudima yeku debedie a ravusedina, dabudine nam doḡa dosina aubainama pesi a gogo makaina, baninama doḡa nam i potopoto guratana. ");
INSERT INTO dww_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Be raḡanine suara ya tavatavana, pesi ya kara gabedi be a pokina, baninama taudi waramidima nam ti yovo guratana. ");
INSERT INTO dww_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Be pesi ḡesaudima gedara nopodie a ravusedi be gedara pesi a gogogona a yavanidina. Vutuna aubainama taudi nam ti banina. ");
INSERT INTO dww_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Be yaḡoro pesi ḡesaudima doḡa verene a gogona. Naumeki da a gogotava, a moraba be a banina, ḡesaudima banidima 30, ḡesaudima 60, bo 100.” ");
INSERT INTO dww_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dabudine Yesu ya riuna, “Deḡoda beemima ta kenana, koi beavaia!” ");
INSERT INTO dww_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Raḡanine Yesu taunaḡa, be banaga aitauḡa tauna a vaivaiena, tauwai muriwatana 12 mate a tava be tauna ai baḡa da tauna na wainasima baninama aba. ");
INSERT INTO dww_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naumeki da Yesu ya paribeedi be ya riuna, “Taumi Mamaitua na waiguyauma semosemonama ya utemina. Be banaga ḡesaudima ḡavoe miemienidima, taudi yaba matabudi wainasie yà riuedina: ");
INSERT INTO dww_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Vutuna aubainama taudi ta kitakitana be nam tima kitakita kauena, be vaienama ta vaivaiena be nam tima vaivaiena, vutuna aubainama taudi nam Mamaitua ḡarone tima tavatava be adi gewagewama ima noḡonoḡota poredina.’ ");
INSERT INTO dww_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dabudine Yesu yai taraviredina, “Taumi uma wainasinama nam ko kataie, bo? Be nema wainasi ḡesaudima ko katai bakedi? ");
INSERT INTO dww_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Taukuma Mamaitua riunama ewai yaraiedina. ");
INSERT INTO dww_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Be banaga ḡesaudima maika pesi keda debane ravuravusedima, deḡo Mamaitua riunama ya kumakumae. Raḡanine riu ta vaivaiena, Seitan waiḡapa e tava be Mamaitua riunama nopodie kumakumanama e kaikaiporaḡana. ");
INSERT INTO dww_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Be banaga ḡesaudima maika pesi yeku debedie ravuravusedima. Taudi riu ta vaie be raḡan tenaḡa ma nuaveredi ta paḡopaḡona, ");
INSERT INTO dww_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","baninama taudi nam waramidi aubainama taudi nam ta midi gurata. Raḡanine gewagewa bo raukivigewagewa e tavana, baninama Mamaitua riunama aubainama, taudi waiḡapa tai daberaridina. ");
INSERT INTO dww_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Be mate ḡesaudima maika pesi gedara nopodie ravuravusedima, riu ta vaivaiena, ");
INSERT INTO dww_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","be dobu yawasanidima nuaboyedi, dobu waiguyaudima be yaba ḡesaudima adi wainuapaḡoma mate ta saḡa be Mamaitua riunama ta yavanidi be nam tima banibanina. ");
INSERT INTO dww_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Be banaga ḡesaudima taudi maika pesi doḡa verene kumakumanama, taudi riu ta vaie, ta paḡopaḡo, ta vovo teyeteyedi, be votedima ḡesaudima 30, ḡesaudima 60 bo 100.” ");
INSERT INTO dww_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ya riuedina, “Nam aitau kodam ya saḡe be gurewa dibune bo vatara dibune ya boru. Bo tokare ḡavoe koyai midiri bo ibewa? ");
INSERT INTO dww_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aba da moimoisirinama tokare e neganegana be aba rupurupunama tokare e maḡatarana. ");
INSERT INTO dww_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aitauḡa da beemima e kenakenana, koi beavaia kauana! ");
INSERT INTO dww_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aba yà riuriuemina, koi beavaia kaua!” Mate ya riuedina, “Ruvanama ko rarau ruvena teneḡine nama Mamaitua taumi e ruvemina bo e tausaḡena. ");
INSERT INTO dww_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aitau uma yabedima kwa katakataiedina, tam tokare Mamaitua debane e taipotodina. Deḡoda aitau uma yabedima nam ku kataiedina, tam tokare avedi da ḡaubonama ḡarome be Mamaitua matabudi e kaiporaḡana.” ");
INSERT INTO dww_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Be mate Yesu ya riuedina, “Mamaitua na waiguyauma maika umanama: Tauḡoma pesi na sipie yai yaraiedina. ");
INSERT INTO dww_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Be kupi da suara tauna e kenakena bo e miamia nuababaḡana, be nam ima katakataiena nema pesi ta gogogogo bakona. ");
INSERT INTO dww_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Be doḡa taunaḡa e voie da pesi ta gogo be ta banibanina, noḡone rugudima ta biridina, murine ta rovena, yodibe banidima nopodie ta biridina. ");
INSERT INTO dww_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Raḡanine yaḡoda ta ḡouḡouna, tauḡoma na biriukoma e paḡo be taraḡidima ei karena, baninama dariḡa na raḡanima ya tavana.” ");
INSERT INTO dww_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu yai taravirana, “Mamaitua na waiguyauma nema tà giu bake, bo aba wainasinama tà voie da e kawa didimani? ");
INSERT INTO dww_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Inam maika gaga pesinama, nito ḡominama doḡa nopone ko kumakumana nama. ");
INSERT INTO dww_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Raḡanine e gogogona, tauna e moraba guratana, nam maika pesi ḡesaudima sipie ta gogogona nama. Be tauna raga yaveyaveḡinama vagurune kiu ḡavoḡa rovorovodima ta verau be ta raunoḡina.” ");
INSERT INTO dww_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu wainasi toitoi banaga ḡarodie ya rauguguyena, maika uma wainasinama nama ya giu guratedi da banaga ta kataiedina. ");
INSERT INTO dww_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tauna nam airaḡan wainasi i gose be ḡarodie i giu ḡomana, be raḡanine na tauwai muriwatanama mate taudiḡa be tauna yaba matabuna ḡarodie ya giu waibatena. ");
INSERT INTO dww_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Inam raḡaninama teneḡine ravie, Yesu na tauwai muriwatanama ya riuedina, “Yawawa tà davu be tà naḡo noaḡo nevane.” ");
INSERT INTO dww_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Naumeki da patara a gosedi be Yesu deḡo wagane ya miamiae dabudine tauwai muriwatana a geru be tauna mate a naḡona. Be waga ḡesaudima dabudi mate. ");
INSERT INTO dww_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yai raḡantenaḡe da sive bagibaginama ya tava be rabama ya nuayemra da ḡaubonaḡa sibo waga nopone upa ya moḡavuna. ");
INSERT INTO dww_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Be Yesu tauna waga murine, debanama kunuane ya boru be ya kenakenana. Be na tauwai muriwatanama a rawaḡosori be a riuna, “Tauwai katakatai kwa kitakita bo ibewa da kaiteka tà gurina. Tam nam kumawai nuaboyeda, bo?” ");
INSERT INTO dww_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu ya midisuḡu da sive ya riutuaḡaie be ya riuna, “Kwai nuatuḡu!” Be rabama ya riuedina, “Ko rautamtamḡota!” Dabudine sive yai nuatuḡu be daumora dosinama ya kenana. ");
INSERT INTO dww_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Naumeki da Yesu na tauwai muriwatanama ya riuedina, “Aba aubainama ko nainaira? Taumi nam ḡaromie waisumaḡa, bo?” ");
INSERT INTO dww_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Taudi a ḡosoridi, a base be adi banagama adi banagama a riuedina, “Uma baneginama aitau? Tauna sive be rabama e riuedi be ta vovo teyeteyena.” ");
INSERT INTO dww_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na tauwai muriwatanama mate a naḡona Galili yawawinama nuaḡo nevane, Gerasi banegidima adi dobue. ");
INSERT INTO dww_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Raḡanine Yesu wagae ya dobidobina, inam dabudi tauḡoma guri adi gubae miemieninama ya verauna Yesu ḡarone. Inam tauḡominama arua gewagewanama nopone. ");
INSERT INTO dww_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tauna guri adi gubaḡa ya miamia naḡona. Be nam aitau teneteneḡina da tokare ya vunuḡi be ya rauseini, ");
INSERT INTO dww_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","baninama raḡan patapatanama tauna kaḡanama be nimanama seinie a panipanidina, be ya rakerakedina. Be kaḡane irama ya vava kotovidina. Tauna yai rewapana kauana, nam aitau teneteneḡina da ya taiparapara. ");
INSERT INTO dww_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kupi da suara tauna oya debediḡa be guri adi gubaḡa ya yogo naḡo da sabira ya ragau be ya nigonigo munaḡena. ");
INSERT INTO dww_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tauna madanie be raḡanine Yesu ya kitakitana, tauna ya manini ya naḡo da Yesu noḡone tuapikanama doḡae yai tutumidiri ");
INSERT INTO dww_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","be bonanama dosine ya riuna, “Yesu, Mamaitua saḡasaḡa vavasaḡinama natunama! Tam aba ḡarogue kwa ḡoeḡoe? Mamaitua isane yàwai baḡamna, nam kwa kovoḡigu!” ");
INSERT INTO dww_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tauḡoma nama ya riuna, baninama noḡone Yesu ya riuna da arua gewagewanama uma tauḡominama sibo ya dobi porena. ");
INSERT INTO dww_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dabudine Yesu tauḡoma yai taravirevirena, “Tam isamma nema?” Be tauna ya paribeena, “Taugu isaguma ‘patara’ be kè toi kauana.” ");
INSERT INTO dww_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Be arua gewegewedima yaḡoro Yesu awai baḡana da nam wari dobue sibo ya riupore nawedina. ");
INSERT INTO dww_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dabudine bawa netarinama dosinama maida oya babane a yabayabana. ");
INSERT INTO dww_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Naumeki da penama Yesu ai baḡana, “Kwa riupore nawemai bawa ḡarodie be kwai aninemai da nopodie ka saḡa.” ");
INSERT INTO dww_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Naumeki da Yesu arua gewegewedima yai aninedi da tauḡoma a dobi pore be a naḡona bawa nopodie. Netari tabutabunama bawa sievinama 2 tausand nama dere boganaḡa a manini yovo be dakie a beku be yawawa nopone a tonedina. ");
INSERT INTO dww_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dabudine tauyosi aitauḡa bawa a raberabedina, a manini ḡoma meagaie be meagai diane, be uma varinama ai daberarina. Dabudine banaga a dobi a naḡona aba ya tubutubuḡana kitanama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Be raḡanine taudi Yesu ḡarone a tavatavana, taudi tauḡoma penama ḡumnama tauna nopone miemienidima a kitana. Tauna yai gara be na noḡotama didimanine ya miamiana. Be taudi matabudi a nairana. ");
INSERT INTO dww_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Taudi aitauḡa nama a kitakitana, banaga a riuedi da tauḡoma penama kokukokunama be bawa mate ḡarodie aba ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Vutuna aubainama taudi Yesu ai baḡa da adi dobuma sibo ya gosena. ");
INSERT INTO dww_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Raḡanine Yesu waga nopone ya saḡasaḡana maika, tauḡoma penama a gosegose porena, tauna Yesu yai baḡana da sibo mate a naḡona. ");
INSERT INTO dww_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Be Yesu nam i aninena, be ya riuna, “Kwa naḡo vadae, am damma ḡarodie be bada na raukiviverema be abaḡa ḡarome ya voivoiedina, nama kwa riuedina!” ");
INSERT INTO dww_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dabudine tauḡoma ya midisuḡu be ya naḡona Dekapolis noponaḡa, be Yesu aba tauna ḡarone ya voivoiena giuedima yai karena. Be banaga aitauḡa nama a vaivaiena, taudi a basena. ");
INSERT INTO dww_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu wagae yawawa ya davu be ya naḡona noaḡo nevane, dabudi yawawa diane patara dosinama tauna a midi ḡuruvina. Inam dabudine ");
INSERT INTO dww_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","sinagog taurabenama tenaḡa isanama Jaeras ya tava da e kitana be Yesu, naumeki da Yesu noḡone tuapikane ya raupari ");
INSERT INTO dww_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","be nuanama tabutabune yai baḡe be ya riuna, “Taugu natuguma waivinama ḡaubonama e gurigurina. Yàwai baḡamna da nimamma debane kwa boru da e yawasana be e mianana.” ");
INSERT INTO dww_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Naumeki da Yesu tauna mate naḡo ai karena. Be patara mate a naḡo be Yesu a tauporeporena. ");
INSERT INTO dww_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Be dabudine waivi tenaḡa waikosina vutuvutu ya paḡona na modima 12 a kovina. ");
INSERT INTO dww_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tauna yai nuatoitoi kauana, be na purapurama matabudi dogeta ḡarodie yawai yakaredina deḡo e yawasana kabe da yaḡoro ya kaikai guratena. ");
INSERT INTO dww_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Raḡanine tauna Yesu varinama ya vaivaiena, tauna patara nopodie Yesu na garama ya taukonina, ");
INSERT INTO dww_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","baninama tauna ya noḡotina, “Deḡoda taugu Yesu na garama yà taukoni ḡomena, taugu tokare yà yawasanana.” ");
INSERT INTO dww_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Raḡanine tauna Yesu na garama ya tautaukonina, dabudine yai raḡantenaḡe da kosina manimanininama yai kave be tuninama mayanama ya dami da tauna na wainuatoitoie ya yawasanana. ");
INSERT INTO dww_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Inam dabudine Yesu mayanama ya dami da rewapana ḡarone ya dobi porena. Naumeki da tauna yai tauvitare patara ḡarodie yai taravira be ya riuna, “Aitau yau garama ya taukonidi?” ");
INSERT INTO dww_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Be na tauwai muriwatanama a paribee da a riuna, “Kwa kita da patara ta midimidi ḡuruvim be ta tatau poreporemna. Be nemanama da kwa riuriuna, ‘Aitau ya taukonigu?’” ");
INSERT INTO dww_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu yaḡoro ya waitau kitakitana da aitau ya voiana sibo ya kitana. ");
INSERT INTO dww_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dabudine waivi ya katai munaḡe da ḡarone aba ya tubuḡana, vutuna aubainama tauna ḡarone ya verau be naira ma gusuna Yesu kaḡapakane tuapikane ya raupari be yaba matabuna yai maḡataridina. ");
INSERT INTO dww_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu waivi ya riuena, “Moumou, am waisumaḡama yai yawasanimna. Ma nuasubam kwa naḡona, be am wainuatoitoie kwa yawasanana!” ");
INSERT INTO dww_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Dabudine Yesu yaḡoro ya giugiu be tautauḡoma ḡesaudima Jaeras tauna sinagog taurabenama na vadae be a tava da Jaeras a riuena, “Natumma waivinama ya gurina. Aba aubainama tauwai katakatai kwa tatai nuaraḡaraḡa?” ");
INSERT INTO dww_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu taudi aba a giugiuedina ya vaia yababedi be tauna Jaeras ya riuena, “Nam am noḡotama e beku be kwai sumaḡa ḡoma!” ");
INSERT INTO dww_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Naumeki da Yesu nam aitau i anine da tauna mate ti naḡo, be tauna Pita, Jeims tasinama Jon taudiḡa mate a naḡona. ");
INSERT INTO dww_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Raḡanine taudi sinagog taurabenama na vadae a tavatavana, dabudine Yesu e vaiena be banaga patara ai nuaboya be bonedima ḡavoḡa a ḡabaḡabana ya kitedina. ");
INSERT INTO dww_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu vada nopone ya saḡa be ya riuna, “Aba aubainama kowai nuaboya be ko ḡabaḡaba? Gomana nam i gurina, tauna e kenakena ḡomana.” ");
INSERT INTO dww_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Be taudi Yesu ai kwatekwatevena, vutuna aubainama tauna banegidima ya riupore dobiḡedi be tauna gomana tamana, tinana be na tauwai muriwatanama rabuiteḡa mate a naḡona deḡo gomana ya kenakenae. ");
INSERT INTO dww_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naumeki da Yesu gomana waivinama nimane ya kaididi be Hibru bonane ya riuena, “Talita kum!” Uma riunama baninama inam, ‘Moumou, yà riuriuemna, kwa midisuḡu!’ ");
INSERT INTO dww_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dabudine gomana waivinama yai raḡantenaḡe da ya midisuḡu be naḡo yai karena. Inam gomeninama na modima 12. Raḡanine uma kauinama nama ya tubutubuḡana, taudi matabudi a base kauena. ");
INSERT INTO dww_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Be Yesu ya riu vavasaḡedi da uma kauinama nam aitau tenaḡa sibo ai vari, be tauna ya riuedi da aiyaba sibo gomana a ute da ya kanina. ");
INSERT INTO dww_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu inam dobunama ya gose be ya munaḡana na vadae na meagaie, be na tauwai muriwatanama mate ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Be Sabat ya tavatavana raḡanine, tauna sinagog nopone waikatakatai yai kare be banaga a riuna, “Uma tauḡominama uma kauidima deḡo ya ragaudi? Uma nuauyauyanama deḡo ya paḡo da tauna mataira mate e voivoiedi! ");
INSERT INTO dww_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tauna kabe Meri natuna tauwai kamda, be Jeims, Jousep, Judas be Saemon tuaḡedi? Be nuvunuvunama mate yodi ḡarode.” Vutuna aubainama taudi a tuaḡaiena. ");
INSERT INTO dww_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Be Yesu taudi ya riuedina, “Peroveta dobu ḡesaudie ta vovo teyeteyena, be na meagaima banegidi be na banaga ḡomama be na vadama banegidima ta tuatuaḡaiena.” ");
INSERT INTO dww_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Vutuna aubainama tauna inam dabudi nam aba matairidima i voiedina. Be nimane banaga raubisaḡa sidesidediḡa ya taukonidi be yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Be Yesu ya basedina, baninama taudi adi waisumaḡama ibewa. ");
INSERT INTO dww_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tauna tauwai muriwatana 12 ya yokoedi be ma turana ma turana ya riuporedina. Be tauna rewapana ya utedi da taudi arua gewegewedima ta tavu dobiḡedina. ");
INSERT INTO dww_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dabudine ya riu vavasaḡedi be ya riuna, “Ami vaḡaie nam aba ko ragaudi, nam kani, nam tana, nam mane bogemie. Be diḡona taunaḡa ko paḡo. ");
INSERT INTO dww_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Be mate kaḡasuma ko kotedina, be nam kwama ḡidoidima mate ko ragaudi!” ");
INSERT INTO dww_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Be mate ya riuedina, “Raḡanine deḡo vadane tai aninemi be ko saḡana, inam dabudine ko miana, naumeki da inam meagainama ko gose porena. ");
INSERT INTO dww_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Be deḡoda banaga nam ta ḡoemi, naumeki da kaḡemima popokaudima ko rawakurukuruvidi, be inam meagainama ko gose porena, da dabudi taudi ta kita be ta kataie da taudime adi wavuma.” ");
INSERT INTO dww_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dabudine taudi a dobi a naḡo be a rauguguyana da banaga adi gewagewama sibo a kuvesidina. ");
INSERT INTO dww_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Be mate banaga ḡarodie penama toitoi a tavu dobiḡedi, be oerie banaga sidesidedima toitoi tunidima a viredi be ai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Guyau Herod uma kauinama nama ya vaiena, baninama Yesu a katai vavasaḡe be varinama ya moramorabana. Vutuna aubainama tauna ya riuna, “Jon tauwai babataito ya guri be ya midisuḡu munaḡana. Vutuna aubainama tauna rewapana ya paḡo da uma matairidima e voivoiedina.” ");
INSERT INTO dww_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Be ḡesaudima a riuriuna, “Tauna Elaija.” Be yaḡoro banaga ḡesaudima a noḡonoḡoti da, tauna maika bonideḡo perovetedima nama. ");
INSERT INTO dww_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Raḡanine Herod nama ya vaivaiena, tauna ya riuna, “Tauna inam Jon tauwai babataito, gadonama è tomna be gurie ya midisuḡu munaḡana.” ");
INSERT INTO dww_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Be boni Herod tauiḡara ya riuedi da Jon a vunuḡi da seinie a pani be dibure a boruna. Herod nama ya voiana, baninama tauna tuaḡa ḡominama Pilip na waivima isanama Herodias ya naḡina. ");
INSERT INTO dww_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Vutuna aubainama Jon Herod umanama ya riuriuena, “Inam nam i verena da tuaḡama na waivima kwa naḡi!” ");
INSERT INTO dww_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Vutuna aubainama Herodias nuanama yai medina Jon ḡarone da ya ḡoeḡoena sibo yai gurina. Be tauna nam teneteneḡina da nama sibo ya voiana, ");
INSERT INTO dww_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","baninama Herod tauna Jon ya naire be ya raberabe kauena, baninama ya kataie da Jon tauna banaga didimanina be tauḡoma babaunama. Be Herod tauna Jon na giuma vaienama ya ḡoeḡoe kauena, avedi da tauna ya tatai nuaraḡaraḡana, be yaḡoro na giuma vaienama ya ḡoeḡoena. ");
INSERT INTO dww_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dabudine Herodias keda ya banavina da Jon ei gurina. Inam raḡanine Herod na kaba tubuḡama soine. Tauna soi ya voiena gabegabeman adi babadama, iḡeiḡeridima adi babadama be Galili babadidima mate aubaidima. ");
INSERT INTO dww_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dabudine Herodias natunama guguininama ya saḡa da ya bigana, be Herod na warema mate nuedima ya paḡo kauena. Dabudine Guyau Herod gomeninama ya riuena, “Aba kwa ḡoeḡoena kwa paḡo? Taugu aiyaba kwa ḡoeḡoena nama yà utemna.” ");
INSERT INTO dww_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ya sauga wape be ya riuna, “Aba kwai baḡena yà utemna, avedi da yau waiguyauma be nevanama tokare yà utemna.” ");
INSERT INTO dww_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dabudine gomana waivinama ya dobi ya naḡo be tinanama yai taravire be ya riuna, “Dudua, aiyaba yài baḡe?” Dabudine tinanama ya pribee be ya riuna, “Jon tauwai babataito debanama yà ḡoeḡoena.” ");
INSERT INTO dww_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Inam gomeninama guguininama yai raḡantenaḡe da ya manini ya naḡona guyau ḡarone be na ḡoanama ya riuena. “Taugu yà ḡoeḡoena tam yodi uma dabudi Jon debanama teboe kwa boru be kwa uteguna.” ");
INSERT INTO dww_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Be uma giunama guyau ya kawa nuaboya kauena, be tauna nam teneteneḡina da gomana ya rawaḡaiḡaiena, baninama tauna noḡone na warema matedie ya sauga wapana. ");
INSERT INTO dww_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Vutuna aubainama guyau na taubodamama ya giu yaḡe be ya riupore da Jon debanama e verauḡena. Naumeki da taubodama ya naḡo dibure be Jon gadonama ya tom, ");
INSERT INTO dww_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","da teboe ya boru be gomana guguininama ya ute da ya kiroḡi be tinanama ya utena. ");
INSERT INTO dww_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Raḡanine Jon na tauwai muriwatanama uma giunama a vaivaiena, taudi a verau be tubuḡinama a kiroḡa nawe be a dobona. ");
INSERT INTO dww_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apasol Yesu ḡarone a tava munaḡa be yaba matabuna a voivoiedi be awai katakataina tauna ai varina. ");
INSERT INTO dww_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Dabudine banaga toitoi a saḡasaḡa be a yovoyovona, be Yesu na tauwai muriwatanama nam teneteneḡina da sibo a mia be a kani. Vutuna aubainama tauna ya riuedina, “Taumiḡa muriguḡa ko verau gabu wainuatuḡune be raḡan ḡaubonaḡa ko siperena!” ");
INSERT INTO dww_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dabudine taudiḡa wagae a naḡona gabu wainuatuḡutuḡune. ");
INSERT INTO dww_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Be dabudine patara ta kitana be Yesu da na tauwai muriwatanama mate a naḡonaḡona, taudi a kitedi be a kataiedina aubainama taudi meagai matabuna a gosedi da noḡodima a tom be a tava dokana. ");
INSERT INTO dww_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Raḡanine Yesu wagae ya ḡotaḡotana, tauna patara dosinama ya kitedi be ya raunuatoiedina, baninama taudi maika sipu be nam taurabedi. Naumeki da tauna yaba matabuna waikatakataidima yai karena. ");
INSERT INTO dww_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Raḡanine ravi ya tavatavana, tauna na tauwai muriwatanama ḡarone a tava be a riuna, “Uma dobu wainuatoitoinama be kaiteka suara e kovikovina. ");
INSERT INTO dww_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Banaga kwa riupore nawedi meagaiḡa be meagai murisairidie be mabidie adi kanima ta gimara be ta kanidi.” ");
INSERT INTO dww_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Be Yesu ya riuedina, “Taumi koi kanidi!” Be tauwai muriwatanama tauna a riuena, “Tam kwa ḡoeḡoena tauma ka naḡo be Denari 200 vutuna ruvanama buredi ka gimara be banaga kai kani bagibagidi, bo?” ");
INSERT INTO dww_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Be Yesu na tauwai muriwatanama ya riuedina, “Taumi buredi bisa ḡaromie? Ko naḡo be ko kitedi!” Dabudine a noḡota banavi be tauna a riuena, “Buredi 5 be iyana rabui.” ");
INSERT INTO dww_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dabudine Yesu na tauwai muriwatanama ya riuedi da banaga ta dariḡedina, naumeki da taudi banaga a dariḡedi be mui gidegidevidima debedie a miana. ");
INSERT INTO dww_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Naumeki da banaga a daridariḡana, dariḡidima nopodie banaga ḡesaudima 100 be ḡesaudima 50-nama a miana. ");
INSERT INTO dww_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dabudine Yesu buredi 5 be iyana rabui ya ragaudi da gunuma yai kita saḡa be Mamaitua yai kaiwe, be buredi ya givedina, yodibe na tauwai muriwatanama ya utedi da taudi a soiedi be banaga a utedina. Be iyana rabui mate ya soiedina. ");
INSERT INTO dww_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Banaga matabudi a kani da a kani siauana. ");
INSERT INTO dww_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Be tauwai muriwatana buredi be iyana kanikani gosedima a tama be posa matabudi 12 ai moḡavudina. ");
INSERT INTO dww_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tautauḡoma aitauḡa a kanikanina sievidima 5 tausand. ");
INSERT INTO dww_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Naumeki da Yesu waiḡapa na tauwai muriwatanama ya riuedi da waga nopone a saḡa da Yesu a gose be taudi a naḡonaḡo dokana Betsaidama maika, tauna patara ya riuporedina. ");
INSERT INTO dww_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Murine tauna ya naḡona oyae moiragi aubainama. ");
INSERT INTO dww_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Raḡanine ravi na parate be waga yawawa poune ya midimidina, be Yesu taunaḡa gerese ya midimidina. ");
INSERT INTO dww_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tauna e kitana be na tauwai muriwatanama ma nuaboyedi a yareyarena, baninama sive dosinama ya kiroḡidi be a wewewesana. Raḡantomtom suara 3 be 6-nama poudie be Yesu topa debanaḡa ya naḡo be ḡarodie ya tavana. Tauna sibo ḡaubonaḡa yai muridina, ");
INSERT INTO dww_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","be taudi a kita be ai noḡotana kabe ḡaḡarua. ");
INSERT INTO dww_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Be bonedima dosine a rasana, baninama taudi a naira kauana. Dabudine Yesu yai raḡantenaḡe be ya riuedina, “Nam nuemima e rovo! Inam taugu. Nam ko naira!” ");
INSERT INTO dww_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dabudine Yesu ya saḡana waga nopone taudi ḡarodie be sive yai nuatuḡuna. Be taudi a base kauena, ");
INSERT INTO dww_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","baninama taudi tautauḡoma 5 tausand awai kanidina na banima nam ti kataiena, be debedima ya buana. ");
INSERT INTO dww_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Taudi yawawa a davu be a verauna Genesaret geresine a ḡota be ai anikana. ");
INSERT INTO dww_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Raḡanine taudi waga a dobidobi porena, banaga Yesu a kita be a katai ḡomena. ");
INSERT INTO dww_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Taudi Genesaret dobunama matabuna a naḡo popoe be banaga sidesidedima ma ratiratidi a kiroḡa be deḡo deḡo Yesu ya naḡonaḡona nama sida a kirokiroḡa tavaitedina. ");
INSERT INTO dww_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Be Yesu deḡo meagai murisairidiḡa ya naḡonaḡona, nama taudi banaga sidesidedima anikune gabudie a tavatavaitedina. Be taudi Yesu ai baḡa da tauna sibo yai aninedi da na garama isunama sibo a taukonina, be aitauḡa a tautaukonina, taudi a yawasanana. ");
INSERT INTO dww_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi be tarawatu tauwai katakatai ḡesaudima aitauḡa Jerusalemḡa a tavatavana, matabudi Yesu ḡarone a rawateḡeidi da ");
INSERT INTO dww_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ta kitana be Yesu na tauwai muriwatanama ḡesaudima ma nimamiredi a kanikanina, inam waikatakatai dosi poredie saḡasaḡanama adi tarawatuma nam ti kaiwatanina. ");
INSERT INTO dww_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi be Jius matabudi nam tima kanikani yababana, noḡone nimedima ta koḡedina, adi dosima adi waikatakataima poredie a paḡopaḡona nama. ");
INSERT INTO dww_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Raḡanine anikune gabune be ta tavana, taudi nam ta kani be noḡone nimedima ta raukoḡana. Be taudi tarawatu poredima ḡesaudima toitoi ta kaikai watanedina, maika redu, tebo be gurewa koḡedima. ");
INSERT INTO dww_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Vutuna aubainama Parisi be tarawatu tauwai katakataidima Yesu ai taravirena, “Aba aubainama tam am tauwai muriwatanama uma waikatakatainama dosi poredie ya yovoyovona nam timawai muriwatane, be taudi ma nimamiredi ta kanikanina?” ");
INSERT INTO dww_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu ya paribeedi be ya riuna, “Taumi waikaikaiyovu banegimima. Aisaia tauna na waiperovetae ya riu kauana, tauna umanama ya girugirumina, ‘Uma banegidima mududiḡa ta riuriuna, ‘Mamaitua’, be nopodima madanie. ");
INSERT INTO dww_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Taudi nam teneteneḡina da taugu ta rauduneegu, baninama taudi tarawatu banaga a voivoiedina tawai katakataidina, da inam kabe vutudi Mamaitua na tarawatu.’ ");
INSERT INTO dww_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Taumi Mamaitua na riuvavasaḡama ḡavoe koya taurie be banaga ḡoma adi waikatakataima ko vovo teyeteyedina.” ");
INSERT INTO dww_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Be ya riuedina, “Taumi koya katai ḡaḡa be Mamaitua na tarawatuma koya varie be taumiḡa ami vaivaie kowai muriwatanedina. ");
INSERT INTO dww_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Baninama Mousis ya riuna, ‘Tamamma be tinamma kwa viviredi!’ be ‘Aitau tamanama bo tinanama e kunukunurena tauna gurie e miana.’ ");
INSERT INTO dww_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Be taumi ko riuriuna, deḡoda banaga yaba ya paḡona maika kani bo yaba ḡesaudima da tamanama bo tinanama sibo ya sagudina, be tauna e riuriuedina, ‘Uma Korban’ - inam riunama baninama: Puyo Mamaitua taunaḡa aubainama. ");
INSERT INTO dww_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Taumi ami waikatakataima kadi taiye tauna nam tamana bo tinanama ima sagusagudina. ");
INSERT INTO dww_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Inam kededie waikatakatai ewai raudavudavuna, banaga ḡesaudima ḡarodie be Mamaitua riunama e kawakawa koakoana. Be yaba ḡesaudima a toi rereḡedina mate ko voivoiedina maika uma taudi.” ");
INSERT INTO dww_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dabudine Yesu patara ya yoko munaḡedi ḡarone be ya riuedina, “Koi beavaiegu matabumi, be uma yabedima yodi yà giuedina ko noḡotidi! ");
INSERT INTO dww_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nam aiyaba ḡavoe tokare e saḡa banaga nopone be ei mira, ibewa da aba banaga nopone e dobidobina, inam vutuna taunaḡa ewai mirana.” ");
INSERT INTO dww_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(-) ");
INSERT INTO dww_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Raḡanine Yesu patara ya gosedi be vada nopone ya saḡasaḡana, tauna na tauwai muriwatanama ai baḡa da uma wainasinama baninama sibo ya giu yaḡedina. ");
INSERT INTO dww_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Be Yesu ya riuedina, “Taumi nam ko kataie, bo? Taumi sibo koya kataie da yaba ḡavoe be banaga nopone e saḡasaḡana tokare nam ei mira. ");
INSERT INTO dww_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Baninama inam nam nuapoune ima yovoyovona, ibewa da kapone da noveḡo e dobidobina.” Uma riunama nama Yesu ewai maḡatarana da kani matabudi anikani. ");
INSERT INTO dww_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na giuma ya kaiwatani be ya riuna, “Aba banaga nopone e dobidobina, inam vutuna tauna ewai mirana. ");
INSERT INTO dww_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Baninama banaga nopone nuapoune noḡota gewegewedima ta tavatavana, maika badara, danene, vunuḡa, turanama debane mui e porena, ");
INSERT INTO dww_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","waigogo be noḡota ḡesaudima gewegewedima tabu be tabu e voivoiedina, maika waikaikaiyovu, kaua waimata warewaredi bo waideba subesubedima, unura, boruwaideḡa, moraba be bua kauidima e voivoiedina. ");
INSERT INTO dww_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Uma kauidima gewegewedima banaga nopone ta tavatavana, taudi vutudi banaga tawai mirana.” ");
INSERT INTO dww_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Dabudine Yesu inam meagainama ya gose be ya naḡona dobu dosine Taiya meagainama diane. Tauna vada nopone ya saḡa be ya ḡoeḡoena da banaga nam sibo a kataie da tauna inam dabudine, be yaḡoro tauna nam i mia moisirina. ");
INSERT INTO dww_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Gomana waivinama arua gewagewanama kokukokunama tinanama, Yesu varinama ya vaivaiena, yai raḡantenaḡa ya verau Yesu noḡone be tuapikane ya rauparina. ");
INSERT INTO dww_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Waivi tauna eteni Gurik nama be meagai dosinama Ponitia nopone ya tubuḡana Siriama, waivi Yesu yai baḡa da tauna natunama nopone penama sibo ya tavu dobiḡena. ");
INSERT INTO dww_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Be Yesu ya paribee be ya riuna, “Kwa gose da noḡone seda ta kani doka. Nam i verena da seda adi kanima tà paḡo be daḡadaḡasi ḡarodie tà pore nawe.” ");
INSERT INTO dww_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Waivi ya paribee be ya riuna, “Bada! Be yaḡoro daḡadaḡasi vatara dibune miemienidima seda adi kanima kurekuredima tokare mate ta kanidina.” ");
INSERT INTO dww_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dabudine Yesu waivi ya riuena, “Nama kuya giuna aubainama, yodi tam kwa munaḡa am vadae, be dabudine tokare kwa kita da penama natumma waivinama ya dobi porena.” ");
INSERT INTO dww_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Naumeki da waivi ya munaḡa vadae da e kitana be penama gomana waivinama ya dobi pore be gomeninama tauna na kaba kenae ya kenakenana ya kitana. ");
INSERT INTO dww_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Dabudine Yesu Taiama be Saidonḡa ya dobi ya naḡona Dekapolis nopone Galili yawawinama paratine. ");
INSERT INTO dww_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Dabudine banaga ḡesaudima tauḡoma beanama potapotanama be nam giugiuna a verauḡena Yesu ḡarone be ai baḡa da nimanama sibo tauḡoma tunine ya boruna. ");
INSERT INTO dww_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Naumeki da patara nopodie be Yesu tauḡominama taunaḡa yai doka dobiḡe ḡavoe be nimarakurakunama tauḡoma beane ya sivudi, da nimanama kavisone yai vira be tauḡoma menanama ya taukonina. ");
INSERT INTO dww_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Naumeki da Yesu gunume yai kita saḡa da yavutu bagibaginama ya taupore, be tauḡoma ya riuena, “Epata!” Inam riunama baninama ‘Kwa nuaporaḡa’. ");
INSERT INTO dww_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Inam raḡanine tauḡoma beanama ya raunuaḡari be mudune ya giu yaḡana. ");
INSERT INTO dww_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Be Yesu banaga ya riu vavasaḡedi da nam aitau tenaḡa ta riue, be ya riuriu nonoḡedina, be taudi yaḡoro a giugiu watanena. ");
INSERT INTO dww_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Be taudi aitauḡa a vaivaiena a base kaue be a riuna, “Tauna yaba matabuna ya voia kauedina. Tauna e voie da avedi beapotapotanama be ei beavaiana, be avedi gumgum be e giuna.” ");
INSERT INTO dww_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nam dauna inam raḡanine, patara ḡesaunama dosinama mate ai rawateḡeidina. Be dabudine nam aiyaba i kenakenana da taudi sibo a kani, dabudine Yesu na tauwai muriwatanama ya yokoedi ḡarone be ya riuna, ");
INSERT INTO dww_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Taugu uma banegidima è raunuatoiedina, baninama raḡan rabuiteḡa nopodie taudi taugu mate, be yodi nam aiyaba da ta kani. ");
INSERT INTO dww_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Be deḡoda taudi ma kaniguridi yà riuporedina, tokare kedae ta raugurerena. Baninama banaga ḡesaudima madanie be a verauna.” ");
INSERT INTO dww_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dabudine na tauwai muriwatanama a paribee be a riuna, “Uma mutuyua dobunama. Deḡo kani tà paḡo be uma banegidima tài kani bagibagidi?” ");
INSERT INTO dww_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu ya paribeedi be ya riuna, “Taumi ḡaromie buredi bisa?” Be taudi a riuna, “Buredi 7.” ");
INSERT INTO dww_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Naumeki da Yesu patara ya riuedi da doḡae a miana. Be dabudine tauna buredi matabudi 7 ya ragaudi, Mamaitua yai kaiwe, ya givedi be na tauwai muriwatanama ya utedi da taudi sibo a soiedina patara ḡarodie, be taudi nama a voiena. ");
INSERT INTO dww_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Be taudi iyana ḡauḡaubodima bisaḡa mate a ragaudina. Be Yesu inam iyenidima aubaidima yai kaiwa be na tauwai muriwatanama ya riuedi da uma taudi mate ta soiedina. ");
INSERT INTO dww_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Dabudine banaga sievinama 4 tausand nama a kani da a kani siauana. Naumeki da na tauwai muriwatanama kani kanikani gosedima posa matabudi 7 ai moḡavudina. Be dabudine Yesu banaga ya riuriupore nawedina, ");
INSERT INTO dww_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","tauna waiḡapa na tauwai muriwatanama mate wagae a saḡa be a naḡona Dalmatia distrik nopone. ");
INSERT INTO dww_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Be Parisi ḡesaudima a tava Yesu ḡarone be waitaravirevirenama ai karena. Taudi a ḡoeḡoena sibo Yesu a raurubuna, vutuna aubainama mara matairinama ai baḡe da sibo ya voie be dabudi a kita be a kataie da Yesu tauna Mamaitua ḡaronama. ");
INSERT INTO dww_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dabudine Yesu yavutu bagibaginama ya taupore be ya riuna, “Aba aubainama yodi raḡaninama banegidima mataira tawai baḡedi? Ibewa! Yà riuriu kauemina da nam tokare mataira uma banegidima ḡarodie e tubutubuḡa.” ");
INSERT INTO dww_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Naumeki da tauna ya gose poredi da waga nopone ya saḡa munaḡa be yawawa a davu da noaḡo nevane a naḡona. ");
INSERT INTO dww_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tauwai muriwatana nuedima ya koana, buredi toitoi kabe ti ragaragau da tenaḡa kavakava a paḡona ḡarodie wagae. ");
INSERT INTO dww_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Dabudine Yesu nuedima ya boru be ya riuedina, “Parisi be Herod adi waikaikaiyovuma maika yist. Koi kita kauana!” ");
INSERT INTO dww_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Naumeki da tauwai muriwatana uma kauinama ai giu vivivire be a riuna, “Tauna nama ya riuna, baninama tauda ḡarode nam buredi.” ");
INSERT INTO dww_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu ya kataiedi da taudi aba a giugiuena, vutuna aubainama tauna yai taraviredi, “Aba aubainama ko riuriuna da taumi ḡaromie nam buredi? Taumi yaḡoro nam ko kita be ko kataie, bo? Taumi koya nuababaḡa, bo? ");
INSERT INTO dww_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Taumi matemima e kenakenana be nam komawai kita, beemima e kenakenana be nam komawai beavaia, bo? Be ko noḡonoḡoti bo ibewa ");
INSERT INTO dww_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","da raḡanine taugu buredidima matabudi 5 è givedina banaga 5 tausand aubaidima, be kani kanikani gosedima posedima moḡamoḡavudima bisa koya ragau?” Be tauwai muriwatana a paribee be a riuna, “Matabudi 12.” ");
INSERT INTO dww_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Raḡanine taugu buredidima matabudi 7 è givedina banaga 4 tausand aubaidima be kani kanikani gosedima posedima moḡamoḡavudima bisa koya ragau?” Be taudi a paribee be a riuna, “Matabudi 7.” ");
INSERT INTO dww_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Be Yesu na tauwai muriwatanama ya riuedina, “Taumi yaḡoro nam koma katakataie, bo?” ");
INSERT INTO dww_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Raḡanine taudi Betsaidama a tavatavana banaga ḡesaudima tauḡoma matapotapotanama ai doka verauḡe Yesu ḡarone be ai baḡana da sibo ya taukonina. ");
INSERT INTO dww_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Naumeki da tauna tauḡoma matapotapotanama nimane ya kaididi da meagai a dobi pore be ḡavoe a naḡona. Dabudine Yesu tauḡoma matanama ya kavisodi be nimanama tauḡoma matane ya sivudi da yai taravire be ya riuna, “Aba kwa kitakita bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Be tauna ya tausuḡu be ya riuna, “Taugu banaga yà kitekitedina be kitedima maika kai kabe ti naḡonaḡo.” ");
INSERT INTO dww_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Naumeki da Yesu nimanama tauḡoma matane ya sivu munaḡedina. Dabudine tauḡoma matanama ya vere be yai kita munaḡana, be yaba matabudi ya kita kauedina. ");
INSERT INTO dww_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Be Yesu tauḡoma ya riupore da ya naḡona na vadae be ya riuna, “Nam meagai banegidima kwa riuedi da aba ya tubuḡana.” ");
INSERT INTO dww_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu be na tauwai muriwatanama mate Seseria-Pilipai diane meagaidiḡa nama a naḡona. Da kedae be yai taraviredi da ya riuna, “Banaga ta riuriu da taugu aitau?” ");
INSERT INTO dww_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Be taudi a paribeena, “Banaga ḡesaudima ta riuriuna da tam kabe Jon tauwai babataito, be ḡesaudima ta riuriuna da tam kabe peroveta Elaija, be ḡesaudima ta riuriu da tam kabe boni perovetedima.” ");
INSERT INTO dww_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Be tauna ya riuedina, “Be taumi nemanama ko noḡonoḡoti bake da taugu aitau?” Be Pita ya paribeena, “Tam Keriso, vutuna Mamaitua ya sausaugena ya riupore yovoḡena.” ");
INSERT INTO dww_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dabudine Yesu na tauwai muriwatanama ya riu vavasaḡedi da nam aitau tenaḡa tai vari. ");
INSERT INTO dww_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dabudine Yesu na tauwai muriwatanama waikatakataidima yai kare be ya riuedina, “Banaga Natunama tokare ei nuatoitoina yaba toitoi ḡarodie be babada dosidima, Parisi adi babadama be tarawatu tauwai katakataidima, taudi matabudi ta tuaḡaie be tai gurina. Be raḡan wairabuiteḡane tauna tokare e midisuḡu munaḡana.” ");
INSERT INTO dww_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tauna uma kauidima ya giu kauedina, vutuna aubainama Pita Yesu yai doka nawe ḡavoe be riutuaḡaienama yai karena. ");
INSERT INTO dww_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Be raḡanine Yesu yai tauvitare da na tauwai muriwatanama ya kitedi be Pita ya riutuaḡaie be ya riuna, “Seitan! Murigue kwa naḡo, tam am noḡotama nam Mamaitua ḡarone tima yovoyovona be banaga ḡomae.” ");
INSERT INTO dww_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Naumeki da Yesu na tauwai muriwatanama be patara ya yokoedi ḡarone be ya riuedina, “Aitau waimuriwataneguma e ḡoena, naumeki da na ḡoanama matabuna e gosedi, be na korosima e kiroḡi da ei muriwataneguna. ");
INSERT INTO dww_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Baninama deḡoda aitau tame am yawasanama kwa kaididi be kwa raberabena, tokare am yawasanama kwa kawa gewagewana, be tam aitau am yawasanama kuyai utaena taugu be vari verenama kama taiye, tam tokare am yawasanama kwa banavina. ");
INSERT INTO dww_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Be deḡoda aitau dobu yabedima matabudi e ragaragaudi be raḡanine e gurina, inam yabedima nema tauna ta sagu bake da tauna yawasana kenakena nonoḡinama e paḡo? ");
INSERT INTO dww_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bo aba banaga ei utae da na yawasanama e paḡo munaḡe? ");
INSERT INTO dww_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Deḡoda banaga aitau taugu be riuguma giuenama e tunitunimayaḡena, uma kimtinama nam waisumeḡidi be gewagewa tauvoiedima nopodie, naumeki da tokare, raḡanine Banaga Natunama Tamanama neneḡarine be anea babau mate ta verauna, tauna mate e tuaḡaiena, baninama noḡone ya tunimayaḡeguna aubainama.” ");
INSERT INTO dww_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Be Yesu na giuma ya kaiwatani da ya riuna, “Taugu yà riuriu kauemina da taumi ḡesaumima yodi uma dabudi ko midimidina, tokare nam ko guri naumeki da Mamaitua na waiguyauma rewapana mate e verauna ko kitana.” ");
INSERT INTO dww_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Raḡan 6 a kovikovina murine Yesu Pita, Jeims be Jon yai dokedi be a naḡona oya daudaunama debane, taudiḡa dabudine a tavana. Be dabudine taudi noḡodie matedie Yesu kitanama ya boru vitarena. ");
INSERT INTO dww_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Be na garama a rawarawa keyekeyemidi be a ḡavora da a ḡavora kauana, nam aitau dobue teneteneḡina da nama e kawa ḡavori. ");
INSERT INTO dww_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dabudine tauwai muriwatana rabuiteḡa noḡodie be Elaija da Mousis a maḡatara be Yesu mate awai giuna. ");
INSERT INTO dww_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Be Pita ya riuna, “Tauwai katakatai, ya vere kaua da tauda mate uma dabudi. Be agunai tauma kape rabuiteḡa ka keridi, da tenaḡa tam aubaimma, tenaḡa Mousis aubaina be tenaḡa Elaija aubainama.” ");
INSERT INTO dww_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita nama ya riuna, baninama tauna na banagama rabui mate a naira kauana, be Pita nam i kataie da aba sibo ya giue, vutuna aubainama ya giu yabayababana. ");
INSERT INTO dww_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dabudine giyou ya dobi be ya ruputawedina. Be inam giyounama nopone bona ya yovo be ya riuna, “Uma tauna taugu natuḡomiguma, tauna vutuna taugu nuaguma e paḡopaḡona, koi beavaie!” ");
INSERT INTO dww_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Taudi ai raḡantenaḡe da aitau kitakita be nam aitau tenaḡa ti kitana, be ḡarodie Yesu taunaḡa. ");
INSERT INTO dww_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Raḡanine taudi oya debane be a yovoyovona raḡanine, Yesu na tauwai muriwatanama ya riu vavasaḡedi da matedie aba a kitakitana nam aitau tenaḡa tai vari, naumeki da Banaga Natunama gurie e midisuḡu munaḡana. ");
INSERT INTO dww_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Taudi inam giudima a nuevidi be taudiḡa ai giu vivivira da, gurie midimidisuḡunama na banima aba. ");
INSERT INTO dww_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Be taudi Yesu ai taravirena, “Aba aubainama tarawatu tauwai katakataidima ta riuriuna da, Elaija tokare e tava doka?” ");
INSERT INTO dww_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu ya paribeedi be ya riuna, “Inam riukaua, Elaija tauna tokare e tava dokana, be tauna tokare yaba matabudi e kawa didimanidina. Be you, aba aubainama girugiruminama porane e riuriuna da Banaga Natunama tokare ei nuatoitoi kaua be ta tuaḡaiena? ");
INSERT INTO dww_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Be yà riuriuemina da Elaija maiḡone ya tavana, be aba banaga a noḡonoḡotina, nama ḡarone a voiena, maika girugiruminama porane ya riuriuena nama.” ");
INSERT INTO dww_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Raḡanine taudi a dobidobi munaḡana, tauwai muriwatana ḡidoidima mate ai rawateḡeidi be ta kitana be patara dosinama a midi ḡuruvidi be tarawatu tauwai katakataidima mate awai saḡasaḡana. ");
INSERT INTO dww_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Dabudine banaga matabudi Yesu a kitakitana, taudi a ḡosoridi da a manini ḡarone a naḡo be ai kaiwena. ");
INSERT INTO dww_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Be Yesu yai taraviredi be ya riuna, “Taumi aba aubainama taudi mate kowai saḡasaḡa?” ");
INSERT INTO dww_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Naumeki da tauḡoma tenaḡa patara poune ya paribee be ya riuna, “Tauwai katakatai, taugu natuguma è verauḡena ḡarome. Tauna penama ya koku be ya kaue da nam ima giugiuna. ");
INSERT INTO dww_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kana raḡanie penama gomana e vunuvunuḡina raḡanine, tauna gomana doḡae ewai bekuna. Be tauna kasampuropuro gayane ta dobidobina, da mokanama e gidedi be tuninama ta badobadona. Be taugu am tauwai muriwatanama èi baḡedina da sibo peneminama a tavu dobiḡena, be taudi nam teneteneḡina.” ");
INSERT INTO dww_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Be Yesu ya riuedina, “Taumi kimta nam waisumeḡimi! Taugu taumi mate tà mia ḡaḡa be ami vitama yà kiroḡa ḡaḡae? Gomana ko verauḡe ḡarogue.” ");
INSERT INTO dww_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naumeki da gomana a verauḡena Yesu ḡarone. Be raḡanine penama Yesu ya kitakitana, tauna yai raḡantenaḡe da gomana ya kawa kokeri be doḡae yai bekuna. Dabudine gomana yai kunukunuvira be gayane kasampuropuro a tavatavana. ");
INSERT INTO dww_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Be Yesu gomana tamanama yai taravirena, “Raḡan bisa tauna umanama ya voia?” Be gomana tamanama Yesu ya paribee be ya riuna, “Raḡanine tauna ḡaubone da yodi. ");
INSERT INTO dww_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Be penama raḡan matabuna gomana kai matane bo upae yawai bekuna waigurinama aubainama. Be deḡoda tam teneteneḡinama aba kwa voiena, naumeki da kwa raunuatoiemai da kwa sagumai!” ");
INSERT INTO dww_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Be Yesu ya riuna, “Aba aubainama kuya riuna, ‘Deḡoda tam teneteneḡina’? Tauna aitau ewai sumaḡana, ḡarone yaba matabuna teneteneḡinama.” ");
INSERT INTO dww_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Naumeki da gomeninama tamanama yai raḡantenaḡe da bonanama dosine ya riuna, “Taugu nam amawai sumaḡa kauana, be kwa kaisagugu da yài sumaḡa guratana.” ");
INSERT INTO dww_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Raḡanine Yesu e kitana be patara ya moramorabana, vutuna aubainama tauna penama ya riutuaḡai be ya riuna, “Penama beapotapota be gumgum penemima, yà riuriu vavasaḡem da gomana kwa dobi pore be nam nopone kwa saḡa munaḡa!” ");
INSERT INTO dww_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dabudine penama gomana ya kawa yogoyogo, ya kawa kokeri gurate be gomana ya dobi porena. Be gomeninama kitanama maika guri kabe i kenakena. Vutuna aubainama banaga ḡesaudima a riuna, “Tauna ya gurina!” ");
INSERT INTO dww_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naumeki da Yesu gomana nimane ya kaididi da ya soruwai midisuḡu be ya midina. ");
INSERT INTO dww_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Raḡanine Yesu vada nopone ya saḡasaḡana murine, be na tauwai muriwatanama taudiḡa ai taravire be a riuna, “Aba aubainama tauma penama nam ke tavu dobiḡe?” ");
INSERT INTO dww_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Be Yesu ya paribeedi da ya riuna, “Nam aiyabae tokare uma peneminama nama e tavu dobiḡe, ibewa da moiragi taunaḡa.” ");
INSERT INTO dww_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Naumeki da Yesu na tauwai muriwatanama mate inam dobunama a gose pore be Galili noponaḡa a naḡona. Be Yesu nam i ḡoeḡoena da aitau tenaḡa sibo ya kataiedi da taudi aikedae, ");
INSERT INTO dww_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","baninama tauna na tauwai muriwatanama yawai katakataidina. Be ya riuedina, “Banaga Natunama tokare ta boru dobiḡena banaga nimedie. Taudi tai guri be raḡan rabuiteḡa murine tauna e midisuḡu munaḡa.” ");
INSERT INTO dww_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dabudine na tauwai muriwatanama nam ti kataiena da uma giunama baninama aba, be taudi waitaravirevirenama a nairena uma giunama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Naumeki da taudi Kapeniamma a tava da vada nopone a saḡa a mia be Yesu na tauwai muriwatanama ya riuedina, “Taumi kedae aba koyawai saḡasaḡae?” ");
INSERT INTO dww_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Be taudi ai nuatuḡutuḡuna, baninama kedae taudi awai saḡasaḡana da aitau poudie ya saḡa gurata. ");
INSERT INTO dww_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dabudine tauna ya mia yovo da na tauwai muriwatanama 12 ya yokoedi be ya riuedina, “Deḡoda aitau moraba e ḡoena, naumeki e kaue da e ḡaubo be banaga matabudi adi taunoyama e tubuḡana.” ");
INSERT INTO dww_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dabudine tauna gomana ḡaubonama nimane ya kaididi be na tauwai muriwatanama poudie yai midirina. Be gomeninama yai yaubabe, be ya riuedina, ");
INSERT INTO dww_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aitau seda umanama maika kitedima tenaḡa isague ewai turanena, tauna taugu ewai turaneguna, be aitau taugu ewai turaneguna, tauna tauriuporeguma ewai turanena.” ");
INSERT INTO dww_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ya riuna, “Tauwai katakatai, tauma tauḡoma tenaḡa kè kitana isame penama ya tavutavu dobiḡedi be tauma kè riutuaḡaiena, baninama tauna nam tauda mate tama noyanoya tenaḡana.” ");
INSERT INTO dww_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Be Yesu ya riuna, “Nam ko riutuaḡaie! Baninama aitau da isague mataira e voivoiedina, tauna nam teneḡina da mainokomḡo raḡandie isaguma e kawa gewagewa, ");
INSERT INTO dww_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","baninama banaga aitau nam imawai ḡaviedana, tauna inam tauda turadama. ");
INSERT INTO dww_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taugu yà riuriu kauemina, deḡoda aitau isague upa e uteutemina, baninama taumi Keriso ḡaronama, tauna teneteneḡinama na maesama tokare e paḡona. ");
INSERT INTO dww_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Be deḡoda aitau uma sededima tenaḡa ewai sumaḡegu be e kaue da gewagewa e voiena, ya verena da tauna yeku dosinama gadone ta pani be egasie ta pore nawena. ");
INSERT INTO dww_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Deḡoda nimamma e kauem da gewagewa kwa voiena, naumeki da kwa douraka pore! Ya verena da nimamma tenaḡa mate yawasana nopone kwa saḡa be nam nimamma rabui mate da gienae kwa naḡo, dabudine kai karakarata watanine. ");
INSERT INTO dww_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO dww_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Be deḡoda kaḡamma e kauem da gewagewa kwa voiena, naumeki da kwa douraka pore. Ya verena da kaḡamma tenaḡa mate yawasana nopone kwa saḡana be nam kaḡamma rabui mate da gienae ta pore nawem. ");
INSERT INTO dww_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO dww_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Deḡoda matamma e kauem da gewagewa kwa voiena, naumeki da kwa kaipore. Ya verena da matamma tenaḡa kwa kunavai be Mamaitua na waiguyauma nopone kwa saḡana, be nam matamma rabui mate da gienae ta pore nawemna. ");
INSERT INTO dww_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Inam dabudine motamota taudi ta kanikanidina nam ta guri, be kai e karakaratidina nam e guri. ");
INSERT INTO dww_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Be nama kai karakaratidima banaga matabudi tunidie ta yaraiedina. ");
INSERT INTO dww_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Buta inam yaba verenama, be deḡoda buta dininama e gewagewana, nema kwa voia bake da e dini munaḡa? Buta ko paḡo nopomie be ami banagama mate subae ko miana.” ");
INSERT INTO dww_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Naumeki da Yesu inam dobunama ya gose pore be ya naḡona Judia provinsnama nopone be upa Jodan ya davuna. Dabudine patara ḡarone a tava munaḡa be yai katakataidina tauna na vaivaie nama. ");
INSERT INTO dww_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Be Parisi ḡesaudima Yesu ḡarone a tava be tauna raurubuna aubainama ai taravirena, “Kwa riuemai, tarawatu ewai anina bo ibewa da tauḡoma na waivima e riupore?” ");
INSERT INTO dww_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Be Yesu ya paribeedi be ya riuna, “Mousis na tarawatuma nopone nema ya riu bakemi?” ");
INSERT INTO dww_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Be taudi a riuna, “Mousis yai anina da tauḡoma waigosaḡa pepanama e girumi be waivi e riuporena.” ");
INSERT INTO dww_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dabudine Yesu ya paribeedi be ya riuna, “Mousis inam tarawatunama ya girumina, baninama taumi noḡota poraḡa ḡarone debemima ya bado kauana. ");
INSERT INTO dww_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Be pakane Mamaitua yaba matabuna yawai tubuḡidina raḡanine, tauna tauḡoma be waivi ya voiedina. ");
INSERT INTO dww_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Vutuna aubainama tauḡoma tamanama be tinanama e gosedi be na waivima mate tai rawateḡeidina ");
INSERT INTO dww_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","da taudi tubuḡa tenaḡa ta tubuḡana. Vutuna aubainama taudi yodi nam tubuḡa rabui, ibewa da tenaḡa. ");
INSERT INTO dww_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Naumeki da aba Mamaitua yawai rawateḡeidina nam aitau ei yamonedi!” ");
INSERT INTO dww_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Raḡanine taudi a munaḡa vadae a tava be na tauwai muriwatanama uma giunama aubainama Yesu ai taravirena. ");
INSERT INTO dww_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Be Yesu ya paribeedi be ya riuna, “Ai tauḡoma na waivima e gose be waivi ḡesaunama e naḡina, tauna na waivima debane mui e poreporena. ");
INSERT INTO dww_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Be kauinama teneḡinama, deḡoda ai waivi na tauḡomama e gose be tauḡoma ḡesaunama e naḡina, tauna na tauḡomama debane mui e poreporena.” ");
INSERT INTO dww_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Banaga ḡesaudima seda ḡauḡaubodima Yesu ḡarone a verauḡedi da tauna sibo ya taukonidina, be na tauwai muriwatanama inam banegidima a riutuaḡaiedina. ");
INSERT INTO dww_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Be raḡanine Yesu nama ya kitakitana, tauna nuanama yai medi be na tauwai muriwatanama ya riuedina, “Seda ḡauḡaubodima ko gosedi da ḡarogue ta verau be nam ko riutuaḡaiedi, baninama Mamaitua na waiguyauma inam banaga maika uma sededima nama aubaidima. ");
INSERT INTO dww_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Taugu yà riuriu kauemina da aitau nam Mamaitua na waiguyauma i paḡona, maika gomana ḡaubonama nama, tauna tokare nam waiguyaunama nopone e saḡa.” ");
INSERT INTO dww_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Naumeki da Yesu seda ya tikedi da nimanama debedie ya sivudi be yai aiainidina. ");
INSERT INTO dww_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dabudine Yesu na naḡoma yai kare munaḡe be tauḡoma tenaḡa ya manini tava da Yesu noḡone be tuapikane ya raupari be yai taravirena, “Tauwai katakatai veremma, aba yà voie be yawasana kenakena nonoḡinama yà paḡo?” ");
INSERT INTO dww_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Be Yesu ya riuena, “Aba aubainama kwawai isaguna veregu? Nam aitau verena be Mamaitua taunaḡa. ");
INSERT INTO dww_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tam tarawatu poranama girugiruminama kuya kataiedina, Nam kwa vunuḡa! Nam am visarama bo am tauḡomama debane mui kwa pore! Nam kwa danene! Nam kwa kaiyovu! Nam kwa uta gigibu! Tamamma be tinamma kwa viviredi!” ");
INSERT INTO dww_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dabudine tauḡominama ya riuna, “Tauwai katakatai, taugu ḡaubogue da yodi uma tarawatudima matabudi è voteyeteyedina.” ");
INSERT INTO dww_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu tauḡominama ya kita da nuanama ya paḡo be ya riuna, “Yaba tenaḡa sibo kuya voiena. Kwa naḡo be yaba matabudi ḡarome kwa raugimaredi be inam manedima banaga waikaruwaḡewaḡedima kwa utedi, be tam tokare marae kwai guyauna. Yodibe kwa verau be kwai muriwatanegu!” ");
INSERT INTO dww_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Be raḡanine uma riunama ya vaivaiena tauḡominama yai nuaboya be ma nuaboyana ya naḡona, baninama tauna yai purapura kauana. ");
INSERT INTO dww_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu yai kita kwaviviro be na tauwai muriwatanama ya riuedina, “Waiguyau banegidima ḡarodie ya piripiri kaua da tokare Mamaitua na waiguyauma nopone ta saḡa.” ");
INSERT INTO dww_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tauwai muriwatana uma riunama nama a vaivaiena, taudi a ḡosoridina. Be Yesu ya riu munaḡana, “Seda, Mamaitua na waiguyauma nopone saḡanama ya piripiri kauana. ");
INSERT INTO dww_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel ya bagibagi kauana da seyau gavogavone e sonaḡa, be maika nama waiguyau baneginama ya bagibagi da ya bagibagi kauana da Mamaitua na waiguyauma nopone e saḡa.” ");
INSERT INTO dww_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dabudine tauwai muriwatana a ḡosori kauedi be adi noḡotama ya kovina. Be adi banagama adi banagama a riuedina, “Yodi aitau tokare e yawasana?” ");
INSERT INTO dww_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu na tauwai muriwatanama ya kita dididi, ya paribeedi be ya riuna, “Banaga ḡarone nam teneteneḡina be Mamaitua ḡarone tauna teneteneḡinama da waiguyau banegidima e voiedi da tokare Mamaitua na waiguyauma nopone ta saḡana.” ");
INSERT INTO dww_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dabudine Pita ya riuna, “Be tauma yaba matabudi kè gosa poraḡa be tam kèi muriwatanemna!” ");
INSERT INTO dww_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Be Yesu ya paribeedi be ya riuna, “Taugu yà riuriu kauemina, aitau na vadama bo tuatuaḡanama, bo novunovunama, bo tinana, bo tamana, bo seda, bo sipi e gosedina taugu isague be vari verenama aubainama, ");
INSERT INTO dww_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tauna yaba veredima toitoi yodi raḡanine e banavidina. Tauna tokare na vadama, tuatuaḡanama, novunovunama, tinatinanama, na sedama, be na sipima ta toi vavasaḡa, 100 be ei murina. Be raukivigewagewa mate be raḡan e tavana, tauna tokare yawasana kenakena nonoḡinama e paḡona. ");
INSERT INTO dww_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Be toitoi yodi ta dokadokana tokare ta murina, be aitauḡa yodi ta murimurina tokare ta dokana.” ");
INSERT INTO dww_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu na tauwai muriwatanama mate taudi kedaḡa a saḡa a naḡonaḡona Jerusalemma, Yesu ya dokadokana be na tauwai muriwatanama muriḡa a saḡasaḡana nuedima ya karatina, be banaga aitauḡa awai muriwatanedina taudi a naira kauana. Dabudine Yesu na tauwai muriwatanama 12 yai doka nawedi ḡavoe be ya riuedina da tauna ḡarone abaḡa ta tubuḡana, ");
INSERT INTO dww_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Koi beavaia! Tauda tà saḡa tà naḡona Jerusalemma, dabudine Banaga Natunama tokare ta boru dobiḡena pirisi adi babadama be tarawatu tauwai katakataidima ḡarodie, taudi tokare ta etare be eteni banegidima nimedie ta boru nawena waigurinama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Be taudi tokare tai varavara, ta kaviso, ta kwapu be tai gurina. Be raḡan wairabuiteḡane tauna tokare e midisuḡu munaḡana.” ");
INSERT INTO dww_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naumeki da Sebedi natunama Jeims be Jon Yesu ḡarone a tava be a riuna, “Tauwai katakatai, tauma ka ḡoeḡoena aubaimaima yaba tenaḡa kwa voiena.” ");
INSERT INTO dww_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Be Yesu ya riuna, “Aba ko ḡoeḡoena aubaimima yà voie?” ");
INSERT INTO dww_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Taudi a paribee be a riuna, “Am waiguyauma na raḡanie kwai aninemai da tenaḡa kasaume e mia be tenaḡa senime.” ");
INSERT INTO dww_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Be Yesu ya riuedina, “Taumi nam ko kataiena aba kowai baḡena. Taumi teneteneḡina da taugu ḡoraḡoranama yà tegona nama ko tego bo babataitonama yà paḡona nama ko paḡo, bo?” ");
INSERT INTO dww_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Taudi a paribee be a riuna, “Tauma teneteneḡinama!” Dabudine Yesu ya riuedina, “Taumi tokare ḡoraḡoranama ko tegona be yà babataitona nama tokare ko babataitona. ");
INSERT INTO dww_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Be kasaugue be senigue mieninama, inam tokare nam taugu yài anina. Inam gabunama taudi aitauḡa vinevinedima aubaidima Mamaitua ya vokaukauena.” ");
INSERT INTO dww_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Raḡanine tauwai muriwatana ḡesaudima 10-nama a vaivaiena, taudi nuedima yai medina Jeims be Jon ḡarodie. ");
INSERT INTO dww_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Vutuna aubainama taudi matabudi Yesu ya yokoedi ḡarone be ya riuedina, “Taumi koya kataiena da eteni banegidima adi babadama eteni ḡarodie tawai badabadana. Be babadidima ai rewapana vavasaḡana aubainama da taudi matabudi tawai badedina. ");
INSERT INTO dww_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Uma kauinama nama taumi ḡaromie nam e tubuḡa! Be deḡoda aitau tenaḡa nopomie moraba e ḡoena, naumeki tauna e kaue da matabumi ami taunoyama e tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Be aitau saḡa gurata e ḡoena, naumeki da ei taunoyana ḡaromie. ");
INSERT INTO dww_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Baninama avedi da Banaga Natunama ya verauna nam banaga tauna aubainama ta noya, be tauna taudi aubaidima e noyana, be na yawasanama ei utae da banaga toitoi e kuvesidina.” ");
INSERT INTO dww_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Naumeki da Yesu be na tauwai muriwatanama a tavana Jerikoma. Dabudine taudi be patara dosinama meagainama a gose be tauḡoma matapotapotanama isanama Batimeus keda diane ya mia be ya kiḡikiḡina, tauna inam Timias natunama. ");
INSERT INTO dww_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Raḡanine tauna e vaiena be Nasaret Yesunama, tauna ya yoko be ya riuna, “Yesu, Deivid natunama kwa raunuatoiegu!” ");
INSERT INTO dww_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Banaga toitoi a riupasakare be a riutuaḡaiena da sibo yai nuatuḡuna. Be dabudine tauna ya yoko gurata be ya riuna, “Deivid natunama kwa raunuatoiegu!” ");
INSERT INTO dww_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dabudine Yesu ya midi kwasa be ya riuna, “Ko riue be e verau!” Naumeki da taudi tauḡoma matapotapotanama a yokoe be a riuena, “Nam kwai nuaboya! Kwa midisuḡu! Tauna e yokoyokoemna.” ");
INSERT INTO dww_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dabudine tauḡoma ya midisuḡu, na garama ya gose pore be ya verauna Yesu ḡarone. ");
INSERT INTO dww_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu tauḡoma yai taravire be ya riuna, “Aba kwa ḡoeḡoena aubaimma yà voie?” Dabudine tauḡoma matapotapotanama ya riuna, “Tauwai katakatai, taugu yà ḡoeḡoena yài kitana.” ");
INSERT INTO dww_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dabudine Yesu ya riuna, “Kwa naḡo, am waisumaḡama yai yawasanimna.” Naumeki be yai raḡantenaḡe da matanama yai kita munaḡa be Yesu yai muriwatanena kedaḡa. ");
INSERT INTO dww_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Raḡanine Jerusalem diane a tavatavana, taudi a verauna Betpage be Beteni meagaidie oya isanama ‘Olip’ yauwane. Dabudine Yesu na tauwai muriwatanama rabui ya riupore nawe dokedi ");
INSERT INTO dww_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","be ya riuedina, “Ko naḡona noḡomie meagaine, be raḡanine meagaine ko saḡasaḡana, dabudine ko kitana donki natunama a nigorina. Inam nam aitau i geru rubuena. Ko kuvesi be ko verauḡena uma! ");
INSERT INTO dww_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Be deḡoda aitau ei taraviremina, ‘Aba aubainama umanama ko voivoie?’ da ko riuena, ‘Bada e ḡoeḡoena, raḡan ḡaubonaḡa be ka verauḡa munaḡena.’” ");
INSERT INTO dww_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Naumeki da taudi a naḡona, kedae be vada noḡone donki natunama nigonigorinama a kitana. Raḡanine taudi a kuvekuvesina, ");
INSERT INTO dww_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","banaga ḡesaudima inam dabudine midimididima taudi ai taraviredina, “Aba aubainama donki natunama ko kuvekuvesi?” ");
INSERT INTO dww_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Be taudi Yesu ya riuriuedina nama a paribeedina, vutuna aubainama taudi ai aninedi be a naḡona. ");
INSERT INTO dww_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Taudi donki natunama Yesu ḡarone a tavaite be adi garama donki natunama debane a yesidi be Yesu debane ya miana. ");
INSERT INTO dww_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Banaga toitoi adi garama a yesiyesidina maika banaga ḡesaudima kairugurugu wapue a taraḡa a tavaitedi be kedaḡa a yesidina. ");
INSERT INTO dww_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Banaga aitauḡa a dokadokana be aitauḡa Yesu murine a saḡasaḡana a yogo be a riuna, “Hosana! Waiaiaininama, tauna vutuna Bada isane e veraverauna! ");
INSERT INTO dww_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mamaitua, tauma tamamaima guyau Deivid na waiguyauma e veraverauna kwai aiaini! Mamaitua ka kaisuḡum!” ");
INSERT INTO dww_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Naumeki da Yesu Jerusalem nopone ya saḡa be ya naḡona tempol nopone, dabudine yaba matabudi ya kita rovodina, be kaiteka ravi aubainama, tauna na tauwai muriwatanama 12 mate a dobi a naḡona Betenima. ");
INSERT INTO dww_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pomainama taudi Beteni a gose be a munamunaḡana, be Yesu kani ya karatina. ");
INSERT INTO dww_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dabudine tauna ei kita naḡona be damaya ya kitana, ya kinikini. Naumeki da tauna ya naḡona kitanama aubainama deḡoda banidima tima kenakena. Be raḡanine damaya pakane e tavana be damayinama nam i banina be rugukavanaḡa ya kitana. Baninama damaya nam yodi na iri kaua da damayinama sibo ya bani. ");
INSERT INTO dww_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Naumeki da Yesu damayinama ya riutuaḡaie be ya riuna, “Tam damayimma nam airaḡan kwa bani munaḡa!” Dabudine nama ya riuriuna na tauwai muriwatanama a vaiena. ");
INSERT INTO dww_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Raḡanine taudi Jerusalemma a tavatavana, tauna tempol nopone ya saḡa be banaga aitauḡa a kunekune be a gimagimarana ya tavu dobiḡedina. Tauna mane taurabedima adi vatarama yai tauviredi be aitauḡa kiu gabubu taurau gimaredima adi kaba miama mate yai tauviredina, ");
INSERT INTO dww_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","be nam aitau tenaḡa i anine da na taragaima e kiroḡa be tempol noponaḡa e naḡo. ");
INSERT INTO dww_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Taudi yai katakataidi be dabudine ya riuedina, “Giruma porane Mamaitua ya riuna, ‘Taugu yau tempolma tai isana moiragi kana vadama dobu matabuna aubaidima.’ Be taumi koya voie da kabe ‘taudanedanene adi gabu.’” ");
INSERT INTO dww_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Naumeki da pirisi adi babadama be tarawatu tauwai katakataidima uma kauinama a vaiena, vutuna aubainama taudi keda a wanewanena da nema sibo Yesu ai guri bakena, be taudi a nairena, baninama patara matabudi na waikatakataima a basebasena. ");
INSERT INTO dww_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Naumeki da ravi ya tava be Yesu na tauwai muriwatanama mate meagainama a dobi pore be a naḡona. ");
INSERT INTO dww_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pomainama raḡanboiboi taudi a naḡonaḡona maika, kedae damaya waramine da damone matabuna ya pokina a kitana. ");
INSERT INTO dww_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dabudine aba ya tubutubuḡana Pita ya noḡoti be Yesu ya riuena, “Tauwai katakatai, damaya kuya riuriutuaḡaiena kwa kita, ya pokina!” ");
INSERT INTO dww_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Naumeki da Yesu ya paribeedi be ya riuna, “Koi sumaḡa Mamaitua ḡarone! ");
INSERT INTO dww_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yà riuriu kauemina deḡoda aitau uma oyanama e riuena, ‘Kwa midisuḡu be kwa pore nawem egasie!’ Be tauna nopone nam e noḡota bekubeku be ei sumaḡa da aba ya riuriuena e tubuḡana, tokare teneteneḡinama aubainama e tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Vutuna aubainama yà riuemina aba moiragie koi baḡena, koi sumaḡa da taumi kaite koya paḡo. Da inam tokare taumi ḡaromima. ");
INSERT INTO dww_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Raḡanine ko midi da ko moiragi be ko noḡoti da aitau aba ḡaromie ya voia waigewana, naumeki da ko noḡota porena, yodibe tamemima marae tokare taumi mate ami gewagewama e noḡota porena.” ");
INSERT INTO dww_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(-) ");
INSERT INTO dww_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu na tauwai muriwatanama mate Jerusalemma a tava munaḡa be raḡanine tauna tempol noponaḡa ya naḡonaḡona, dabudine pirisi adi babadama, tarawatu tauwai katakataidima be babada ḡesaudima Yesu ḡarone a tava, ");
INSERT INTO dww_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","da ai taravire be a riuna, “Tam aba waibadane umanama yabedima kwa voivoiedi? Bo aitau uma waibadanama ya utem?” ");
INSERT INTO dww_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Dabudine Yesu ya paribeedi be ya riuna, “Taugu yau waitaravirama tenaḡa yài taraviremi da ko paribeegu be muriḡa da taugu yà riuemi da taugu aba waibadane uma yabedima yà voivoiedi. ");
INSERT INTO dww_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ko riuegu! Jon deḡo dabudi waibada ya paḡo da yawai babataito, Mamaitua ḡarone bo banaga ḡarodie?” ");
INSERT INTO dww_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dabudine taudiḡa ai saḡasaḡa be a riuna, “Nema tà riu bako? Deḡoda tà riuna Mamaitua ḡarone, tauna tokare umanama ei taraviredana, ‘Be aba aubainama da taumi Jon nam koi sumaḡe?’ ");
INSERT INTO dww_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Be deḡoda tauda tà riuna ‘banage’ taudi banaga a nairedina, baninama banaga matabudi a noḡonoḡotina da Jon tauna peroveta.” ");
INSERT INTO dww_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Vutuna aubainama taudi Yesu a paribee be a riuna, “Tauma nam ke kataiena.” Dabudine Yesu ya riuedina, “Taugu mate nam yà riuemi da taugu aba waibadane uma yabedima yà voivoiedi.” ");
INSERT INTO dww_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Naumeki da Yesu wainasie banaga umanama ya riuedina, “Tauḡoma tenaḡa gureipi sipinama ya voie be ya gana kukuna. Naumeki da waen anibuyonama domnama ya keri be kweyaḡa vadanama mate ya kerina. Yodibe gureipi sipinama tausipi ḡesaudima nimedie ya boru da a raberabe be tauna vaḡaie ya naḡona. ");
INSERT INTO dww_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Raḡanine gureipi taminama na raḡaninama ya tavatavana, tauna na taunoyama ya riupore nawena sipi taurabenama ḡarodie da na dariḡama sibo ya paḡona. ");
INSERT INTO dww_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Be taudi a vunuḡi, a riḡa be nimakavakavanama a riupore nawena. ");
INSERT INTO dww_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Naumeki da taupaka na taunoyama ḡesaunama ya riupore nawena ḡarodie, dabudine sipi taurabenama inam tauḡominama debanama a riḡa be a kaue da a kawa tunimayaḡina. ");
INSERT INTO dww_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Be taupaka yaḡoro na taunoyama ḡesaunama ya riupore, be sipi taurabenama inam tauna a katigabana. Be taupaka banaga ḡesaudima mate toitoi ya riuporedi be ḡidoidima a riḡedi, be ḡidoidima a kati gabedina. ");
INSERT INTO dww_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Be yodi tenaḡa kavakava a taugosena. Be inam tauna, taupaka natunama tauḡominama, tauna vutuna ewai nuapaḡoena. Naumeki da na damone tauna natunama ya riupore be ya riuna, ‘Yà noḡonoḡotina da taudi tokare natuguma ta vivirena!’ ");
INSERT INTO dww_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Be sipi taurabenama taudiḡa ai giu vivivira be a riuna, ‘Uma tauna tokare tamanama na buderima e paḡona, vutuna aubainama tài guri be buderinama tài buderie!’ ");
INSERT INTO dww_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Naumeki da taudi a vunuḡi be ai guri da gureipi sipinama nopone, be a pore dobiḡena.” ");
INSERT INTO dww_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Dabudine Yesu yai taraviredi be ya riuna, “Sipi taupakinama tokare e verau be aba e voie? Tauna tokare e verau be sipi taurabedima ei guridi be gureipi sipinama banaga ḡesaudima e utedina. ");
INSERT INTO dww_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Taumi riuwai noḡota poranama nopone girugiruminama koya sievi bo ibewa, da ‘Vada taukerinama yekue vada a kerikeri be yeku tenaḡa a pore kaiyatina, baninama inam yekunama taudi nam ti ḡoena. Be Mamaitua yekunama poreporenama ya paḡo be ya voie da na vadama e kerikerina yasinama ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Be inam kauinama Bada ya voie da uma kauinama anikitanama ḡarode ya vere kauana.’” ");
INSERT INTO dww_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dabudine pirisi adi babadama, Jius babadidima be tarawatu tauwai katakataidima a ḡoeḡoena da Yesu sibo a vunuḡina, baninama mayedima a paḡo da Yesu taudi yawai nasiedina. Be taudi patara a nairedina, vutuna aubainama tauna a gose be a naḡo porena. ");
INSERT INTO dww_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muriḡanama taudi Parisi be Herod na tauwai muriwatanama ḡesaudima mate a riupore nawedi Yesu ḡarone be waitaravirae Yesu a raurubu be a vaia kaue da Yesu aba sibo ya vato waigewana. ");
INSERT INTO dww_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Taudi Yesu ḡarone a tava be a riuna, “Tauwai katakatai, tauma kè kataie da tam riukaue kwa giugiu. Am giue tam nam banaga kuma nainairedina, baninama tam banaga nam kuma siesievidi da taudi nema maika kitedi, be Mamaitua na ḡoanama riukaue kwai katakataidina. Kwa riuemai, inam naumeki bo ibewa da tauma Sisa ḡarone kai teks bo avedi? Tauma kai maesa bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Be dabudine Yesu adi noḡotama kaikaiyovudima ya kataie be ya riuna, “Aba aubainama taumi ko rarau rubugu? Sirinnama ko verauḡe be yà kita!” ");
INSERT INTO dww_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Naumeki da Sirin a paḡo verauḡe ḡarone be Yesu yai taraviredina, “Aitau noḡona be isanama Sirin bogane ta kenakena?” Be a paribee be a riuna, “Uma Sisa noḡonama.” ");
INSERT INTO dww_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Be Yesu ya riuedina, “Naumeki da Sisa ḡaronama Sisa ko ute, be Mamaitua ḡaronama Mamaitua ko ute!” Be dabudine taudi Yesu a basena. ");
INSERT INTO dww_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jius nopodie dam ḡaubonama isanama Sadisi, a riuriuna da banaga e guri be nam e midisuḡu munaḡa, taudi a verau Yesu ḡarone, ai taravire be a riuna, ");
INSERT INTO dww_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tauwai katakatai, Mousis uma tarawatunama aubaimaima ya girumina, deḡoda banaga tauḡominama ya guri be na visarama e gose porena nam waisedasedana, naumeki da tasinama bo tuaḡanama sibo kaiyababinama ya naḡi be seda sibo yai tubuḡana tuaḡanama gurigurinama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Naumeki da tautauḡoma 7 a tubuḡana tina tenaḡa ḡarone, be tauḡoma tautuaḡa waivi ya naḡi da nam ti natunatuna be tauḡominama ya gurina. ");
INSERT INTO dww_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Be tauḡoma wairabuinama inam kaiyababinama ya naḡina, be tauna mate seda nam i tikedi be ya gurina, kauinama teneḡinama tauḡoma wairabuiteḡanama ḡarone ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Naumeki da tautauḡoma 7 kauinama namaḡa nam ti natunatuna da a guri rovona. Naumeki da a gurigurina damone inam waivinama ya guri ḡavutana. ");
INSERT INTO dww_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Be raḡanine midisuḡu munaḡa na raḡanie uma waivinama tautauḡoma 7 a naḡinaḡina, be inam waivinama tokare aitau na waivi?” ");
INSERT INTO dww_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu ya paribeedi be ya riuna, “Taumi koya riu waigewana, baninama taumi girugiruminama porane nam ko katai kauena be Mamaitua na rewapanama mate nam ko kataiena. ");
INSERT INTO dww_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Raḡanine guri ta midisuḡu munaḡa, be taudi tokare maika anea marae be tokare nam tai naḡi. ");
INSERT INTO dww_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Be yodi guri kawakawa midisuḡunama na giuma taumi Mousis na bukama koya sievi bo ibewa? Deḡo ya riuna gedara rageragetinama nopone Mamaitua Mousis ya riuena umanama, ‘Taugu inam Eibraham, Aisik be Jeikob adi Mamaituama’. ");
INSERT INTO dww_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mamaitua, nam banaga guriguridima adi Mamaitua, be tauna banaga yawayawasanidima adi Mamaituama. Taumi naumeki koya bua kauana.” ");
INSERT INTO dww_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tarawatu tauwai katakataidima tenaḡa dabudine mate adi giuma yawai beavaiena. Dabudine tauna e vaiena be Yesu na giuma didimanine Sadisi adi giuma ya pariparibeedina. Vutuna aubainama tauna Yesu yai taravire be ya riuna, “Riuvavasaḡa matabudi namaḡa, be deḡo tauna ya saḡa vavasaḡa?” ");
INSERT INTO dww_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ya paribee be ya riuna, “Riuvavasaḡa dosinama tenaḡa inam umanama, ‘Israel koi beavaia! Bada da Mamaituama, tauna taunaḡa Bada. ");
INSERT INTO dww_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bada Mamaitua nuanuamma e paḡo, nuanuamma tabutabune, aruimma tabutabune, am noḡotama tabutabune be am rewapanama tabutabune.’ ");
INSERT INTO dww_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Be riuvavasaḡa dosinama aniwai rabuinama inam umanama, ‘Turamma nuanuamma e paḡona maika tam kwa ḡoeḡoe munaḡemna nama.’ Nam deḡo aba riuvavasaḡidima ti saḡa vavasaḡana maika uma taudi.” ");
INSERT INTO dww_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tarawatu tauwai katakatainama Yesu ya riuena, “Inam riukaua tauwai katakatai, kuya riuna maika da Bada taunaḡa Mamaitua be nam deḡo mamaitua ḡesaudi, ibewa da tauna, taunaḡa. ");
INSERT INTO dww_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Be banaga nuanama tabutabune, na noḡotama tabutabune, be na rewapanama tabutabune Mamaitua ei nuapaḡoe, be turanama ei nuapaḡoena maika tauname ewai nuapaḡo munaḡena nama. Uma riudima riuvavasaḡa rabui dosidima tà voteyeteyedina, taudi nam maika musara be puyo ḡesaudima tà gabudi be Mamaitua tà uteutena nama.” ");
INSERT INTO dww_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Raḡanine Yesu ya kataie da tauna na paribeama ya vere kauana, aubainama tauna tarawatu tauwai katakatainama ya riuena, “Tam kaiteka Mamaitua na waiguyauma diane kwa tavatavana.” Inam dabudine nam aitau Yesu waitaravira munaḡenama i ḡoena, baninama taudi a nairana. ");
INSERT INTO dww_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Raḡanine Yesu tempol nopone yawai katakataina maika, tauna yai taravira be ya riuna, “Nemanama da tarawatu tauwai katakataidima ta riuriuna da Keriso tauna Deivid natunama? ");
INSERT INTO dww_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Be Arua Babau Deivid nopone ya yovo be tauna ḡominama umanama ya riuena, ‘Mamaitua yau Badama ya riuena, Kasaugue kwa miana naumeki da taugu am ḡaviama kaḡamma dibudie yà biridina’. ");
INSERT INTO dww_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deivid ḡominama Keriso yawai isana: Bada! Be yodi nemanama da Keriso tauna Deivid natuna?” Dabudine patara dosinama ma nuaveredi Yesu awai beavaiena. ");
INSERT INTO dww_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Be raḡanine Yesu yawai katakataidi be ya riuna, “Koi kita kauana tarawatu tauwai katakataidima ḡarodie! Taudi ta ḡoeḡoena gara veredima ta kotedi be debaḡa ta rauguyaguyau naḡona be banaga taudi tai kaiwedina vivira mate. ");
INSERT INTO dww_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Be taudi sinagog nopodie be soi nopodie gabu verediḡa be gabu dosidiḡa ta ragaragaudina. ");
INSERT INTO dww_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Be taudi kaiyababa waikaruwaḡewaḡedima adi vadama be adi purapurama ta kwayekwayedina be moiragi daudaudima kaikaiyovudima ta voivoiedina. Taudi tokare kovoḡa dosinama ta banavina.” ");
INSERT INTO dww_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu tempol nopone mane adi kaba boruma diane ya mia be patara mane a boruboruna ya kitekitedina. Be banaga waimanedima toitoi a saḡa be mane toitoi a biribiridina. ");
INSERT INTO dww_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Be kaiyababa waikaruwaḡawaḡanama ya saḡa be mane dubedima ḡauḡaubodima rabui ya biridina, inam peni tenaḡa na ruvama. ");
INSERT INTO dww_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu na tauwai muriwatanama ya yokoedi da ḡarone be ya riuedina, “Yà riuriu kauemina da uma kayababinama waikaruwaḡawaḡanama tauna puyo ya moraba kauana mane tanane ya suvekina, nam maika banaga ḡesaudima nama. ");
INSERT INTO dww_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Baninama banaga ḡesaudima mane ai maure be ragisidima a saḡa be a rarau puyoedi. Be kaiyababa waikaruwaḡawaḡanama, tauna na manema ḡaubonama sibo na kanima ya gimerina be ya raupuyoena.” ");
INSERT INTO dww_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Raḡanine Yesu tempol ya gosegosena, na tauwai muriwatanama tenaḡa ya riuna, “Tauwai katakatai, kwa kita! Vada yekue kerikeridima kitedima a vere ḡaḡa.” ");
INSERT INTO dww_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Be Yesu ya paribee be ya riuna, “Uma vadedima dosidima ko kitekitedina. Nam ai yeku tenaḡa dabudine tokare na gabue e kena. Matabudi tokare ta rawadabuririḡidina.” ");
INSERT INTO dww_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu oya Olip debane ya mia be tempol yauwanine yawai kitanaḡo be Pita, Jeims, Jon be Endru moisirie be ḡarone a tava da Yesu ai taravire be a riuna, ");
INSERT INTO dww_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kwa riuemai, uma kauidima aba raḡanine ta tubuḡa be abaḡa matairidima ta tubuḡa be ka kitedi da uma kauidima ta tubutubuḡana?” ");
INSERT INTO dww_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Be Yesu ya riuna, “Koi kita kaua da nam aitau ei kedadoka waigewemi. ");
INSERT INTO dww_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Banaga toitoi tokare isague ta tava be ta riuna, ‘Taugu vutuna Keriso!’ Be taudi tokare banaga toitoi tai kedadoka waigewedina. ");
INSERT INTO dww_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Be raḡanine iḡara guguridima maida ko vaie be madanie varidima ko vaiedina, nam koi nuaboya! Uma kauidima nama tokare ta tubuḡana, be nam ko noḡoti da inam raḡan damona, ibewa! ");
INSERT INTO dww_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dobu da dobu tai kawa ḡasiḡasina, be waiguyau turanama waiguyau mate tai kawa ḡasiḡasina. Be dobu matabuna yoyo be meiḡara tai verau tatena. Uma kauidima matabudi ta tubuḡana maika gomana kaevounama e tubutubuḡana tunimuyanama nama, inam tepa pakanama. ");
INSERT INTO dww_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Taumiḡa ko kita kauemina. Taumi tokare tapanimina etara aubainama, taumi tokare sinagog nopodie ta riḡemina, taumi tokare babada dosidima be guyaguyau noḡodie ko midi be isague vari verenama ko riuedina. ");
INSERT INTO dww_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Muriḡa da raḡan damonama e tavana, be noḡone vari verenama ta rauguguyena dobu matabuna banaga ḡarodie. ");
INSERT INTO dww_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Raḡanine ta panimi be etara aubainama ta nawemina, nam koi nuaboya dokadoka da nema sibo koya giu bako. Raḡanine inam raḡaninama e tavana giu aba da e uteutemina ko giuena, baninama giu aba da ko giuena inam nam nuemie tokare ko giu, ibewa da Arua Babau e giuna. ");
INSERT INTO dww_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Tautauḡoma tasitasidi bo tuatuaḡedima ta biri dobiḡedi da tai guridina, be seda tametamedima kauinama teneḡinama adi sedama ḡarodie ta kauena, be seda nama adi dosima mate tai kawa ḡasiḡasi be tai guridina. ");
INSERT INTO dww_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Be banaga matabudi ta tuaḡaiemina, baninama taumi taugu kowai sumaḡeguna aubainama. Be aitau e midi bagibagi be e raudamoena, tauna tokare e yawasanana. ");
INSERT INTO dww_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tausiava, uma giunama baninama ko katai kauena: Taumi tokare ko kita da gewagewa waimatawarawara vavasaḡinama deḡo nam sibo ya midi, be tokare e midina. Be taudi aitauḡa Judiama miemienidima oyae sibo a naḡona. ");
INSERT INTO dww_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Be aitau da na vadama debane, be nam tauna teneteneḡina da tokare e dobi e naḡo na vadama nopone be na purapurama e ragaudi. ");
INSERT INTO dww_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Be nam aitau sipie be e munaḡa vadae na garama ragaudima aubaina. ");
INSERT INTO dww_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Inam raḡandie waiwaivi bogebogedi be waitatau vaudima ḡarodie e gewagewa kauana. ");
INSERT INTO dww_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mamaitua ḡarone ko moiragi da uma kauidima nam bodubodue ta tubuḡa, ");
INSERT INTO dww_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","baninama nuaboya inam raḡandie ta tubuḡana e gewagewa vavasaḡana, nam maika Mamaitua dobu pakane yawai tubuḡie nama i tubuḡa rubuna, naumeki da yodi raḡandie ta tubuḡana. Tokare uma kauinama nama nam e tubuḡa munaḡa. ");
INSERT INTO dww_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Be deḡoda Bada inam raḡandima nam sibo i taitupodi, tokare nam aitau tenaḡa ya yawasana. Be baninama tauna na banagama vinevinedima kadi taiye, tauna uma raḡandima ya taitupodina. ");
INSERT INTO dww_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Be inam raḡandie deḡoda aitau e riuemina, Keriso umanema! Bo noanema! Nam koi sumaḡe! ");
INSERT INTO dww_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Baninama Keriso kaikaiyovudi be peroveta kaikaiyovudima tokare ta maḡatara be mataira be anibasa kauidima ta voiedina, be deḡoda Mamaitua na vinevinema banegidima mate tai kedadoka waigewedina. ");
INSERT INTO dww_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Vutuna aubainama ko kita kaua, yaba matabuna è riu wainonoḡimina, muriḡa da inam raḡandima ta tavana. ");
INSERT INTO dww_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Be inam nuaboyedima raḡandima muridie, suara ei kupi, be nawaravi tokare nam e yana munaḡa. ");
INSERT INTO dww_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Be kipora gunume ta kuruva be gunuma rewapanidima matabudi e gusu waidaberaridina. ");
INSERT INTO dww_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Be dabudine Banaga Natunama ta kitana giyou nopone e maḡatara be e yovona ma rewapanina be neneḡarinama dosinama mate. ");
INSERT INTO dww_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dabudine tauna na aneama e riuporaḡa da dobu kawa susunama 4, be dabudine Mamaitua na banagama vinevinedima ta rawateḡeteḡeidina dobu isudie da isudie be gunuma isudie da isudie. ");
INSERT INTO dww_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Naumeki ko gose da damaya kainama ei katakataimi! Raḡanine damaya ragedima ta kini be rugudima ta gidagidavana, inam raḡanine ko kataie da inam bodubodu raḡaninama maida e tavatavana. ");
INSERT INTO dww_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Uma kauinama teneḡinama nama, raḡanine taumi uma kauidima gewegewedima ko kitedi be ta tubutubuḡana, dabudine taumi ko kataie da Bada na kaba verauma raḡaninama kaiteka maida. ");
INSERT INTO dww_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Taugu yà riuriu kauemina, da uma kimtinama nam ei kave naumeki da uma kauidima tokare matabudi ta tubuḡa dokana. ");
INSERT INTO dww_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mara be dobu tokare tai kavena be taugu riuguma nam airaḡan tai kave. ");
INSERT INTO dww_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nam aitau tenaḡa raḡan be awa i kataie rubuna da airaḡan inam raḡaninama e tava. Nam ai anea marae bo Natunama tauḡominama, be ibewa Tamaguma taunaḡa ya kataiena. ");
INSERT INTO dww_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Be koi kita kaua be koi neneḡana, baninama nam ko kataiena da airaḡan inam raḡaninama e tava. ");
INSERT INTO dww_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Inam maika tauḡoma na taunoyama ya gosedi da na vadama a raberabe be tauna ya naḡo poredina vaḡai aubainama. Tauna na taunoyama tenaḡaḡa adi noyama ya utedina, be matakeda taurabenama ya riue da ei neneḡana kauana. ");
INSERT INTO dww_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Vutuna aubainama taumi raḡan matabuna koi neneḡana, baninama taumi vada taupakinama na kaba verauma nam ko kataiena da airaḡan e verau munaḡa, deḡoda ravie bo nubautuae bo raḡantomtom kamkam ta riuriue nama bo raḡanboiboi suara e tavatavana raḡanine! ");
INSERT INTO dww_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Baninama deḡoda ei raḡantenaḡe be e tavana, nam ko kenakena be e kitemi. ");
INSERT INTO dww_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Taugu aba yà riuriuemina, nama banaga matabudi yà riuriuedina, koi neneḡana!” ");
INSERT INTO dww_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Raḡan rabui muridie, da sibo Naḡopore be Buredi-Nam-Sasasanina soinama, be pirisi adi babada be tarawatu tauwai katakataidima taudi keda a wanewanena, be semoe Yesu kana kasirama a tomtomna da sibo a vunuḡi be ai gurina. ");
INSERT INTO dww_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Be taudi a riuna, “Nam soi nopone be nama tà voia, deḡoda banaga tokare kada iḡarama ta suruena.” ");
INSERT INTO dww_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu tauna Betenima, tauḡoma isanama Saemon Kito, tauna na vadae Yesu ya miamiana. Dabudine Yesu ya kanikani be waivi upa ḡabuḡabunama maesinama dosinama duginama ya kiroḡi be ya tavana. Inam upanama yaba isanama Nad a voiena. Naumeki da waivi dugi vikinama ya kaipore be upa ḡabuḡabunama Yesu debane ya ḡinina. ");
INSERT INTO dww_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dabudine banaga ḡesaudima nama a kitakitana, taudi adi banagama adi banagama a riuedina, “Aba aubainama upa ḡabuḡabunama ewai yakare? ");
INSERT INTO dww_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Inam sibo a raugimare da mane Denari 300 be mainokoiḡo nama sibo a paḡo, be manenama banaga waikaruwaḡewaḡedima sibo a utedina.” Be taudi bonedima bagibagine waivi a riu virevirena. ");
INSERT INTO dww_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Be Yesu ya riuna, “Ko gosepore! Aba aubainama ko kawakawa nuaboya? Tauna kaua verenama ya voiena ḡarogue. ");
INSERT INTO dww_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Taumi raḡan ya toi kauana banaga waikaruwaḡewaḡedima mate ko miana, kana raḡanie ko ḡoeḡoena, nama ko sagudina. Be taugu nam uma dabudi taumi mate tà mia nonoḡa. ");
INSERT INTO dww_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tauna aba verenama ya noḡonoḡotina nama, yodi ya voiena aubaiguma. Tauna upa ḡabuḡabunama tunigue ya ḡini wainonoḡina waikokoagiguma aubainama. ");
INSERT INTO dww_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Taugu yà riuriu kauemina, deḡo deḡo dobu matabuna vari verenama ta rarau guguyena, be uma waivinama aba ya voivoiena noḡotinama tokare mate ta giu watanena.” ");
INSERT INTO dww_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Be dabudine Judas Iskariot tauna tenaḡa tauwai muriwatana 12 nopodie, be tauna ya dobi ya naḡo pirisi adi babadama ḡarodie da Yesu sibo nimedie ya boru nawena. ");
INSERT INTO dww_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Taudi nuedima ya vere kauana da Judas aba e vatona ta vaiena, be taudi a sauga da mane tauna ta utena. Vutuna aubainama Judas keda ya wanewanena da Yesu sibo taudi nimedie ya boru nawena. ");
INSERT INTO dww_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Naumeki da Buredi-Nam-Sasasanina soinama raḡaninama yawai karena. Inam raḡanine sipu natunatudima Naḡopore soinama aubainama a vunuvunuḡana, be tauwai muriwatana Yesu ai taravire be a riuna, “Deḡo dabudi kwa ḡoeḡoemaina ka naḡo be Naḡopore soinama ka vokaukaue tam aubaimma da kwa kani?” ");
INSERT INTO dww_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Naumeki da na tauwai muriwatanama rabui ya riuporedi be umanama ya riuedina, “Ko naḡo meagai nopone be tauḡoma upa duginama e kirokiroḡina ko banavina, tauna vutuna koi muriwatane ");
INSERT INTO dww_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","da deḡo vadanama nopone e saḡana. Inam dabudine vada taupakinama umanama ko riuena, ‘Tauwai katakatai umanama ya riuna: Deḡo gabunama taugu ware yau gabu da taugu be yau tauwai muriwatanama mate dabudi Naḡopore soinama ka kani?’ ");
INSERT INTO dww_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Be tauna vada nopone vatavatara rabui, be debane vatarine dabudine gabu dosinama yaba matabudi kawakawa nonoḡidima ei kataimina, be inam dabudine aubaidama ko vokaukauana.” ");
INSERT INTO dww_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Naumeki da tauwai muriwatana a naḡona, raḡanine taudi meagaie a tavatavana yaba matabuna Yesu ya riuriuedina nama a banavidina, dabudine taudi Naḡopore soinama a vokaukauena. ");
INSERT INTO dww_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Naumeki da ravi ya tavatavana, Yesu na tauwai muriwatanama 12 mate a tavana. ");
INSERT INTO dww_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Be raḡanine taudi vatara debane a kanikani be Yesu ya riuedina, “Taugu yà riuriu kauemina, aitau tenaḡa poumie tokare taugu e boru dobiḡeguna. Tauna aitau taugu mate ka kanikanina, tauna vutuna.” ");
INSERT INTO dww_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dabudine tauwai muriwatana nuedima yai poya be tenatenaḡaḡa Yesu ai taravirena, “Bada, taugu teika?” ");
INSERT INTO dww_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ya paribeedi be ya riuna, “Taumi 12 nopomie, aitau tenaḡa na buredima taugu mate teboe kai gayo tenaḡedina, tauna vutuna. ");
INSERT INTO dww_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Be girugiruminama poranama e riuriuna maika nama tokare Banaga Natunama e gurina, be ya gewagewa kauana tauna baneginama ḡarone aitau Banaga Natunama e boru dobiḡena! Ya verena da inam baneginama avedi sibo ya tubuḡa!” ");
INSERT INTO dww_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Naumeki da taudi a kanikanina maika, Yesu buredi tenaḡa ya paḡo be moiragie yai kaiwana, ya giva da na tauwai muriwatanama ya utedi be ya riuna, “Ko paḡo! Uma tauna taugu tubuḡiguma.” ");
INSERT INTO dww_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Naumeki da Yesu keyaka ya paḡo Mamaitua ḡarone yai kaiwa, be na tauwai muriwatanama ya utedi da keyekine a rautegona. ");
INSERT INTO dww_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Be Yesu ya riuna, “Uma tauna taugu kosiniguma e rauḡinina waianina vaunama aubainama. Yodibe Mamaitua banaga ei yawasanidina. ");
INSERT INTO dww_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Taugu yà riuriu kauemina da taugu tokare nam waen yà tego munaḡe, naumeki da Mamaitua na waiguyauma nopone waen tegonama yài kare munaḡena.” ");
INSERT INTO dww_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Naumeki da taudi kaisuḡu sarenama a sare be a naḡona oya olipma. ");
INSERT INTO dww_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ya riuedina, “Taumi matabumi tokare ko gosegu be koi naḡo teḡateḡana, baninama girugiruminama porane ya riuna da, ‘Mamaitua tokare tauyosi ei guri, be sipu matabudi tai daberaridina.’ ");
INSERT INTO dww_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Be raḡanine gurie be yà midisuḡu munaḡana, taugu tokare yà naḡo dokana Galilima, be muriḡa taumi.” ");
INSERT INTO dww_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ya riuna, “Avedi da ḡesaudima tokare ta gosemna, be taugu tokare nam yà gosem.” ");
INSERT INTO dww_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dabudine Yesu Pita ya riuena, “Taugu yà riuriu kauemna da manaka kupine muriḡa da kamkam raḡan aniwai rabuinama e riuna, be tam tokare raḡan rabuiteḡa kwa bovieguna da tam nam taugu ku kataieguna.” ");
INSERT INTO dww_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Be Pita bonanama bagibagine ya riuna, “Taugu tokare nam yà boviem, teneteneḡinama deḡoda tam mate tà gurina!” Be tauwai muriwatanama ḡesaudima mate giunama teneḡinama nama a giuna. ");
INSERT INTO dww_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Naumeki da Yesu na tauwai muriwatanama mate a naḡo dobu isanama Getsemenima a tava be tauna ya riuedina, “Uma dabudi ko miamia be taugu yà naḡo yà moiragina.” ");
INSERT INTO dww_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tauna na tauwai muriwatanama rabuiteḡa Pita, Jeims be Jon yai dokedina. Dabudine tauna nuanama yai poya be nuaboya noponama ya kukutomna, ");
INSERT INTO dww_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","be taudi ya riuedina, “Nuaboya nopogue ya moraba kaua da ḡaubonaḡa èi guriguna. Be taumi uma dabudi ko mia be ko taibanabanagigu be kowai neneḡana!” ");
INSERT INTO dww_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naumeki da tauna ya taunaḡo ḡaubonaḡa da moiragi aubainama ya beku yovo doḡae be ya moiragina, deḡoda teneteneḡina bo ibewa da tauna nam sibo ḡoraḡoranama e veraverauna nopone ya naḡo. ");
INSERT INTO dww_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Dabudine tauna ya moiragi be ya riuna, “Mamai, Tamaguma, yaba matabuna tam ḡarome teneteneḡinama. Be ḡoraḡoranama uma yà siguena ḡarogue kwa kaipore! Naumeki da nam taugu yau ḡoanama yà voie be am ḡoanama nama e tubuḡana!” ");
INSERT INTO dww_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dabudine tauna ya munaḡa na tauwai muriwatanama ḡarodie, da e kitana be taudi a kenakenana. Naumeki da Yesu Pita ya riuena, “Saemon, tam kwa kenakena, bo? Tam nam tokare kuya mia da suara rovanama tenaḡa, bo?” ");
INSERT INTO dww_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Be tauna taudi ya riuedina, “Koi neneḡana be ko moiragi da nam raurubue ko beku! Arua e ḡoeḡoena, be tubuḡa e vovo gwaḡagwaḡana.” ");
INSERT INTO dww_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Naumeki da Yesu ya munaḡa be moiraginama teneḡinama ya moiragina. ");
INSERT INTO dww_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Raḡanine tauna na tauwai muriwatanama ḡarodie ya tava munaḡa da e kitana be taudi yaḡoro a kenakenana, baninama taudi yaḡoro matedima ya guri kauana. Be taudi nam ti kataiena da aba sibo Yesu ḡarone a vato. ");
INSERT INTO dww_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Be raḡan aniwai rabuiteḡane tauna ya tava munaḡa be ya riuedina, “Taumi yaḡoro ko kenakena be ko sipesipere, bo? Naumeki koya kenana! Raḡaninama kaiteka ya tavana, ko kita, Banaga Natunama a boru dobiḡena gewagewa banegidima nimedie. ");
INSERT INTO dww_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ko midisuḡu be tà naḡo, tauboru dobiḡeguma kaiteka umanema ya tavana.” ");
INSERT INTO dww_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Dabudine Yesu yaḡoro ya giugiu be Judas tauna tenaḡa tauwai muriwatana matabudi 12 nopodie, be ya tavana. Dabudine banaga patara ḡesaudima mate nimedie kwatikwati be kwapu mate, taudi pirisi adi babadama, tarawatu tauwai katakataidima be babada dosidosidima a riuporedina. ");
INSERT INTO dww_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Be tauborudobiḡa patara umanama ya riuedi da tauna tokare waimatarara aba e voiena, “Deḡo baneginama yàwai suruvena, tauna vutuna ami ḡoanama, tauna ko pani be koi doka nawena!” ");
INSERT INTO dww_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Raḡanine Judas ya tavatavana, tauna waiḡapa didimaninama ya saḡa, ya naḡona Yesu ḡarone be ya riuna, “Tauwai katakatai!” da yai suruvena. ");
INSERT INTO dww_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dabudine taudi Yesu a vunuḡi be a kaididi guratena. ");
INSERT INTO dww_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dabudine banaga tenaḡa diedie ya midimidina, na kwatikwatima ya kaisuḡu be pirisi adi badama na taunoyama beanama yai miarakana. ");
INSERT INTO dww_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dabudine Yesu ya riuedina, “Taumi kwapu be kwatikwati mate koya tavana taugu ko vunuḡigu, maika kabe banaga taudanedanene, bo? ");
INSERT INTO dww_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Taugu raḡan matabuna taumi mate tempol nopone èwai katakataina, be taumi nam taugu ko vunuḡiguna. Be girugiruminama porane e riuriuna naumeki da nama e tubuḡana.” ");
INSERT INTO dww_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dabudine tauwai muriwatana matabudi Yesu a gosepore be a naḡona. ");
INSERT INTO dww_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Be inam raḡanine tauḡoma yaraginama tenaḡa nam aba ḡesaunama i kotena, be gara ḡavoḡavorinama ya kote be Yesu yawai muriwatanena. Raḡanine taudi tauna a kaikaididina, ");
INSERT INTO dww_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tauna na garama ya gosaḡa be ma kavakavana naira ya manini be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Naumeki da Yesu ai doka nawena pirisi saḡasaḡa vavasaḡinama na vadae, be dabudine pirisi adi babadama, tauwai tarapiri babadidima be tarawatu tauwai katakataidima matabudi ai rawateḡeidina. ");
INSERT INTO dww_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Be Pita Yesu yawai muriwatane be muriḡa ya veraverauna, naumeki da ya saḡa ya naḡona anikaba etara gabuna pirisi saḡasaḡa vavasaḡinama na vadae. Dabudine tauna taubodama mate kai diane a mia be yawai kaimaririna. ");
INSERT INTO dww_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Be pirisi adi babadama be waibabada matabudi riukaua a wanewanena da nema sibo Yesu ai gurina, be nam aitau ḡarone riukaua ti banavina. ");
INSERT INTO dww_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Baninama banaga toitoi kaiyovue Yesu na kauama a giugiuena, be adi giuma matabudi nam teneḡidi. ");
INSERT INTO dww_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Be mate dabudine banaga ḡesaudima a midisuḡu be kaiyovue Yesu na kauama umanama a giuena, ");
INSERT INTO dww_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tauma kè vaiena umanama ya riuna, ‘Taugu tokare uma tempolnama banaga nimedie a kerikerina yà katiweina, be raḡan rabuiteḡa nopodie natabu yà keri munaḡena, nam maika banaga nimedie a kerikerina nama.’” ");
INSERT INTO dww_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Be yaḡoro adi giuma matabudi nam teneḡidi. ");
INSERT INTO dww_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Naumeki da pirisi saḡasaḡa vavasaḡinama banaga noḡodie ya midisuḡu be Yesu yai taravirena, “Tam uma banegidima adi giuma ta saḡesaḡedina ḡarome nam am paribea, bo?” ");
INSERT INTO dww_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Be Yesu naumeki da yai nuatuḡu be nam aba i giuena. Dabudine pirisi saḡasaḡa vavasaḡinama Yesu yai taravira munaḡena, “Tam Keriso, Mamaitua Natuna, bo?” ");
INSERT INTO dww_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dabudine Yesu ya paribeedi be ya riuna, “Taugu vutuna! Be taumi matabumi tokare Banaga Natunama Mamaitua wairewapana vavasaḡinama nimanama kasaune e mia be marae ma giyouna e veraverauna ko kitana.” ");
INSERT INTO dww_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Naumeki da pirisi saḡasaḡa vavasaḡinama na garama ya sikedi be ya riuna, “Tauma yodi nam matamata ḡesaudima kama ḡoeḡoedina! ");
INSERT INTO dww_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yodi tauna na waidiboḡama koya vaiena. Be nema kowai noḡota bako?” Be taudi matabudi ai anine da Yesu sibo gurie a boruna. ");
INSERT INTO dww_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dabudine banaga ḡesaudima Yesu a kaviso be matanama a suma da a riḡa be a riuna, “Yodi kwai peroveta kabe aitau ya riḡam?” Naumeki da taubodama Yesu ai doka nawe be a raunevaneva kauna. ");
INSERT INTO dww_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita tauna yaḡoro anikaba etara gabunama dibune ya miamiana, be pirisi saḡasaḡa vavasaḡinama na taunoyama waivinama tenaḡa ḡarone ya tavana. ");
INSERT INTO dww_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Raḡanine waivinama Pita e kitana be yawai kaimaririna, tauna Pita ya kitadidi be ya riuna, “Tam mate Nasaret Yesunama mate koya naḡonaḡona.” ");
INSERT INTO dww_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Be Pita ya bovie be ya riuna, “Taugu nam e kataiena tam aba kwa giugiue.” Be tauna matakedae be ya dobina doḡae. ");
INSERT INTO dww_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Raḡanine taunoyanama waivinama ya kitakitana, taudi aitauḡa dabudi midimididima ya riu munaḡedina, “Tauna mate Yesu na tauwai muriwatanama!” ");
INSERT INTO dww_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Be Pita ya bovi munaḡana, dabudine aitauḡa diedie midimididima Pita a riuena, “Inam riukaua, tam mate turedima, baninama tam mate Galili banagimma.” ");
INSERT INTO dww_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Be Pita taudi ḡarodie ya sauga wapa be ya riuna, “Taugu yà riuriu kauana! Deḡoda taugu ama kaiyovu, naumeki da Mamaitua sibo ya kovoḡigu. Taumi aba tauḡominama ko giugiue, taugu nam e kataiena!” ");
INSERT INTO dww_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Naumeki da yai raḡantenaḡe da kamkam raḡan aniwai rabuinama ya riuna. Dabudine Yesu nema ya giugiu bakona Pita ya noḡotina: “Muriḡa da kamkam raḡan aniwai rabuinama e riuna be tam tokare raḡan rabuiteḡa kwa boviegu da tam taugu nam ku kataieguna.” Dabudine Pita yai nuaboya kaua be ya ḡaba guratana. ");
INSERT INTO dww_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Naumeki da raḡanboiboi kupinaḡa, pirisi adi babadama, tauwai tarapiri babadidima mate, tarawatu tauwai katakataidima be waibabada matabudi ai rawateḡeidi be ai giu da aba ta voiena. Dabudine Yesu a pani be ai doka nawena Paelat ḡarone. ");
INSERT INTO dww_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Naumeki da Paelat Yesu yai taravire be ya riuna, “Tam Jius adi guyau, bo?” Be tauna ya riuna, “Ee! Vutuna kuya vatona.” ");
INSERT INTO dww_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dabudine pirisi adi babadama yaba matabuna ḡarone Yesu ai wavuna. ");
INSERT INTO dww_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Vutuna aubainama Paelat umanama Yesu yai taravirena, “Tam nam aba tokare kwa paribeedi, bo? Kuya vaie da yaba matabuna ḡarone tawai wavumna.” ");
INSERT INTO dww_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Be yaḡoro Yesu nam aba giunama tenaḡa maika i vato rubuna. Vutuna aubainama Paelat ya basena. ");
INSERT INTO dww_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Be Naḡopore soinama modi matabuna nopodie Paelat tauna na vaivaima da banaga dibure miemienidima tenaḡa nama e kaikaiporena, deḡo baneginama ta ḡoeḡoena nama. ");
INSERT INTO dww_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Be inam raḡanine tauḡoma isanama Barabas be banaga medimedidima ḡesaudima iḡara nopone a rauvunuḡana mate dibure a miamiana. ");
INSERT INTO dww_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Naumeki da patara a rawateḡeidi be Paelat ai baḡana da noḡone tauna nema ya voivoia bakona, nama sibo taudi aubaidima ya voiana. ");
INSERT INTO dww_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Be Paelat taudi yai taraviredi be ya riuna, “Taumi ko ḡoeḡoena Jius guyaunama taumi aubaimima yà kaipore, bo?” ");
INSERT INTO dww_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Be Paelat ya katai kauena da pirisi adi babadama Yesu a verauḡena tauna ḡarone, baninama taudi a unurana. ");
INSERT INTO dww_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dabudine pirisi adi babadama patara a kawa nuaḡoreḡoredi be Paelat ai baḡana da Barabas sibo ya kaiporena, be nam Yesu. ");
INSERT INTO dww_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Naumeki da Paelat patara yai taravira munaḡedi be ya riuna, “Uma tauna kowai isana Jius guyaunama, yodi nema yà bake?” ");
INSERT INTO dww_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Taudi a rasa be a riuna, “Kwa tuparatu!” ");
INSERT INTO dww_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Be Paelat ya riuna, “Aba aubaina? Tauna aba gewagewanama ya voie?” Be taudi matabudi a rasa gurata be a riuna, “Kwa tuparatu!” ");
INSERT INTO dww_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Naumeki da Paelat patara adi nuasubama aubainama Barabas ya kaiporena, be Yesu kwapue a riḡa be taudi nimedie ya boruna tuparatunama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Naumeki da tauiḡara Yesu ai doka saḡena vadae, deḡo Paelat na kaba miae be tauiḡara ḡesaudima a riuedi da a rawateḡeidina. ");
INSERT INTO dww_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dabudine taudi gara gatugatunama Yesu ai kotena, be gedara a pipini be pinounama Yesu debane ai kunuboboena. ");
INSERT INTO dww_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Be taudi Yesu waivaravarae ai kaiwe be a riuna, “Ebom, Jius guyauma!” ");
INSERT INTO dww_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Naumeki da taudi kwapue Yesu debanama a riḡa yabayababe, a kaviso, tuapikedie a raupari be a rauduneena. ");
INSERT INTO dww_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Raḡanine taudi ai kwatekwateve ya kovikovina, taudi gara gatugatunama a kaipore, be tauna na garaḡomama ai kote munaḡena. Dabudine taudi ai doka dobiḡa nawena tuparatunama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Be kedae tauḡoma tenaḡa isanama Saemon, tauna na sipie be ya saḡasaḡana a banavina. Dabudine tauiḡaiḡara inam tauḡominama a segeri da Yesu na korosima e kiroḡina. Saemon tauna Sairin tauḡominama, tauna inam Alexanda be Rupas tamedima. ");
INSERT INTO dww_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Naumeki da patara Yesu ai doka nawena gabu isanama ‘Golgota’, inam riunama baninama ‘debagarere’. ");
INSERT INTO dww_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dabudine taudi a ḡoeḡoena da waen be bunama muya anibosonama isanama ‘Maera’ mate wairawateḡeinama Yesu sibo ai tegona, be tauna nam i tegona. ");
INSERT INTO dww_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Naumeki da tauiḡara Yesu korosie a tuparatu be na garama ai kasiedina, be aitau kasie yawai rewapanana, tauna na ḡoanama garanama nama ya paḡopaḡona. ");
INSERT INTO dww_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Be raḡanboiboi suara rovanama 9-okorokinama Yesu a tuparatuna. ");
INSERT INTO dww_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dabudine Yesu debane kai ḡaubonama bogane a giruma da aba aubainama Yesu a tuparatu. Taudi umanama a girumana ");
INSERT INTO dww_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Inam dabudine taudi taudanedanene rabui mate a tuparatudina, tenaḡa Yesu kasaune be tenaḡa senine. ");
INSERT INTO dww_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO dww_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Be banaga ḡesaudima noḡodiḡa a saḡasaḡa be a yovoyovona, taudi debedima a kwadiedi da Yesu ai diboḡi be a riuna, “Iyo! Tam godekai kuya riuna, ‘Tempol kwa katiwei be raḡan rabuiteḡa nopodie kwa keri munaḡena.’ ");
INSERT INTO dww_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yodi korosie kwa dobi be kwai yawasana munaḡem!” ");
INSERT INTO dww_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Inam kauinama teneḡine pirisi adi babadama be tarawatu tauwai katakataidima Yesu ai kwatekwateve be adi banagama adi banagama a riuedina, “Tauna banaga ḡesaudima yawai yawasanidina be yodi tauna nam tokare ei yawasana munaḡe! ");
INSERT INTO dww_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yodi Keriso, Israel guyaunama, tà kita korosi bogane e dobi be tài sumaḡe!” Be taudi aitauḡa taudanedanene rabui Yesu mate a tupatuparatudina, taudi mate Yesu ai diboḡina. ");
INSERT INTO dww_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dabudine suaratopu, be dobu yai kupikupina, naumeki da ravi. ");
INSERT INTO dww_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Be ravie 3-okoroki Yesu bonanama dosine umanama ya riuna, “Eli, Eli, lema sabaktani?” Uma giunama baninama inam umanama, “Yau Mamaituama, yau Mamaituama, aba aubainama kuya gose poregu?” ");
INSERT INTO dww_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Be banaga ḡesaudima dabudine diane a midimidina nama a vaie be a riuna, “Koi beavaia! Tauna Elaija e yokoyokoena!” ");
INSERT INTO dww_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Be dabudine tauḡoma tenaḡa anitaiyo ya paḡo, be ya manini, ya saḡa ya naḡo da waen ḡoraḡorane yai sonom da kai isune ya pani be Yesu sibo yai tegona, be dabudine a riuna, “Nakarua! Deḡoda Elaija e yovoyovona Yesu korosie be e dobiḡena tà kitana.” ");
INSERT INTO dww_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Naumeki da Yesu bonanama dosine ya riuriuna, naumeki da ya gurina. ");
INSERT INTO dww_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Be gara tempol nopone matakedae waisaurinama ya nuasika poraḡa da ma nevana a kenana. ");
INSERT INTO dww_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Be raḡanine tauiḡara adi badama dabudine Yesu noḡone ya midimidina, tauna Yesu bonanama ya vaie be ya kita da Yesu nema ya guri bakona, dabudine tauna ya riuna, “Riukaua, uma tauḡominama naumeki da tauna Mamaitua Natunama!” ");
INSERT INTO dww_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Be dabudine waiwaivi ḡesaudima mate, taudi madanie be awai kitana, be taudi nopodie Meri Megdalin, Meri Jeims ḡaubonama be Joses tinedima be Salome. ");
INSERT INTO dww_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Raḡanine Yesu tauna Galilima ya miamiana, uma waiwaividima matabudi Yesu awai muriwatane be tauna na ḡoanama nama a sagusaguna. Be waiwaivi toitoi ḡesaudima Yesu mate Jerusalemma a saḡasaḡana, taudi mate dabudine. ");
INSERT INTO dww_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Naumeki da ravi ya tavatava be Jousep tauna Arimatia tauḡominama ya tavana tauwai tarapiri nopodie, tauna mate tenaḡa be a vivivivirena. Tauna Mamaitua na waiguyauma ya veraverauna ya raberabena. Be inam raḡanine Sabat na vokaukauama raḡaninama, be pomai inam Sabat na raḡanima. Vutuna aubainama Jousep ma raudebatorana ya naḡona Paelat ḡarone be yai baḡana Yesu tubuḡinama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Be Paelat nama ya vaie be ya base da Yesu tauna kaite ya gurina. Vutuna aubainama Paelat tauiḡara adi badama ya yokoe be yai taravirena, deḡoda Yesu kaite ya guri bo ibewa. ");
INSERT INTO dww_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Be raḡanine Paelat tauiḡara adi badama na giuma ya vaie ya kovikovina, Jousep ya riuporena da tauna Yesu tubuḡinama e paḡona. ");
INSERT INTO dww_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Naumeki da Jousep gara ḡavoḡavoridima ya gimara, yodibe Yesu tubuḡinama korosie ya kiroḡa dobiḡe be gara ḡavoḡavoridie ya sumana. Naumeki da guba yeku nopone voivoienama, dabudine Yesu yai kenana. Yodibe Jousep yeku yai raurie be guba matakedanama yai kenatomna. ");
INSERT INTO dww_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Megdalin be Meri Jousep tinanama taudi Jousep deḡo Yesu tubuḡinama yai kenana a kitana. ");
INSERT INTO dww_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Naumeki da Sabat ya kovi be murine, Meri Megdalin, Salome, be Meri, Jeims tinanama, taudi bunama a gimarana Yesu tubuḡine ḡininama aubainama. ");
INSERT INTO dww_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pomainama Sande raḡanboiboi suara ya tavatavana nama, taudi a naḡona kokoagae. ");
INSERT INTO dww_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Be kedae taudi adi banagama adi banagama mate ai giu vivivira be a riuna, “Aitau tokare yeku kokoaga matakedane e taurie aubaidama?” ");
INSERT INTO dww_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Raḡanine taudi a tausuḡudi da ta kitana be yekunama dosinama kaite ya raunuariana. ");
INSERT INTO dww_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Raḡanine taudi kokoaga nopone a saḡasaḡana, kasaudima yauwanine tauḡoma yaraginama gara ḡavoḡavorinama ya kote be ya miamiana, a kita be a nairana. ");
INSERT INTO dww_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dabudine tauḡoma ya riuna, “Nam ko naira! Taugu è kataiena taumi Nasaret Yesunama a tupatuparatuna ko wanewanena. Tauna nam uma dabudi, tauna ya midisuḡu munaḡana! Ko kita, umanema awai kenana gabunama. ");
INSERT INTO dww_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yodi ko naḡo be na tauwai muriwatanama be Pita mate uma varinama ko riuedina: Bada Yesu kaite ya doka be e naḡonaḡona Galilima, dabudine taumi tokare ko kitana, noḡone ya riuriuemina nama.” ");
INSERT INTO dww_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Naumeki da waiwaivi kokoaga a dobi pore be a base be ma nuagusugusudi a manini be a naḡona. Taudi nam aitau ḡarone aba ti giuena, baninama taudi a naira kauana. ");
INSERT INTO dww_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Raḡanine Sande raḡanboiboi Yesu gurie be ya midimidisuḡu munaḡana, tauna Meri Megdalin ḡarone penama matabudi 7 ya tavu dobiḡedina, tauna vutuna ḡarone ya maḡatara dokana. ");
INSERT INTO dww_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naumeki da inam waivinama ya munaḡa be na banagama, aitauḡa ai nuaboya be a ḡabaḡabana ya riuedina. ");
INSERT INTO dww_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Dabudine taudi ta vaiena be Meri ya riuna da Yesu ya yawasana munaḡana, be tauna ya kitana, be yaḡoro taudi nam ti sumaḡena. ");
INSERT INTO dww_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Be uma kauinama murine, tauwai muriwatana rabui kedaḡa a naḡonaḡo be Yesu kitanama ya boru vitare be ḡarodie ya maḡatarana. ");
INSERT INTO dww_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dabudine taudi a munaḡa be adi banagama a riuedina, be taudi yaḡoro nam ti sumaḡana. ");
INSERT INTO dww_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Muriḡanama tauwai muriwatana matabudi 11 a kanikani be Yesu ḡarodie ya maḡatarana. Tauna ya ḡasiedina, baninama taudi nam nopodie waisumaḡa. Taudi adi nopobadoma aubainama banaga ḡesaudima Yesu ya midisuḡu munaḡana a giugiuena, be taudi yaḡoro nam ti sumaḡedina. ");
INSERT INTO dww_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dabudine Yesu taudi umanama ya riuedina, “Ko naḡo dobu matabuna nopodiḡa be riu verenama ko rauguguyena banaga ḡarodie! ");
INSERT INTO dww_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Be aitau ei sumaḡa be e babataitona, tauna tokare e yawasanana. Be aitau nam ei sumaḡa, Mamaitua tokare tauna e kovoḡina. ");
INSERT INTO dww_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tauwai sumaḡa taudi tokare rewapana è utedi da mataira ta voiedina. Taudi tokare isague penama ta tavu dobiḡedi, be bona vaudima tabu be tabu ta giuedina. ");
INSERT INTO dww_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Deḡoda taudi mota gewegewedima nimedie ta ragaudi bo aniwai guri upedima ta tegodina, taudi tokare nam nema ta bako. Be nimedima banaga sidesidedima tunidie ta biridina, inam banegidima tokare ta yawasanana.” ");
INSERT INTO dww_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dabudine Bada Yesu na tauwai muriwatanama mate a giugiu kovina murine, Mamaitua Yesu ya nawena marae be Mamaitua kasaunama yauwane ya miana. ");
INSERT INTO dww_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Naumeki da tauwai muriwatana dobu matabuna a naḡo be a rauguguyana, be Bada tauna taudi mate a noyanoya be mataira a voivoiedina. Be banaga taudi a kitedi da taudi adi rauguguyama naumeki riukaua. ");
INSERT INTO dww_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kapore Tiopilas! Banaga toitoi kaite a raurubu da voia nopode a tubutubuḡana a girumidina. ");
INSERT INTO dww_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Taudi voia pakane matedie a kitakitana be beedie a vaivaiena a riuriuedina nama a girumidina. ");
INSERT INTO dww_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Vutuna aubainama taugu uma voiedima è kita yaḡedi da adi didimanae yà girugirumina tam aubaimma, ");
INSERT INTO dww_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","baninama tam sibo kuya kataie da aba awai katakataimna inam matabudi riukaua. ");
INSERT INTO dww_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yau giuma pakanama yai karena, inam Herod tauna Judia provins guyaunama. Inam raḡandie pirisi ya miamiana isanama Sakaraias. Tauna Abia na waipirisima damnama nopone be na visarama Elisabet tauna Eron na waipirisima damnama nopone ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakaraias be Elisabet taudi rabuidi yawasana didimanine a mianana Mamaitua noḡone, be Mamaitua na riuvavasaḡama matabudi a voteyeteyedina, be nam aba tenaḡa ti voia waigewana. ");
INSERT INTO dww_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Be taudi nam ti natunana, baninama Elisabet tauna yai kaikaipokina, be taudi rabuidi ai rawadosina. ");
INSERT INTO dww_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Raḡan tenaḡa Sakaraias Jerusalemma tempol nopone ya noyanoyana, baninama Abia na waipirisima damnama adi noyama na raḡanima. ");
INSERT INTO dww_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Inam damnama nopone Sakaraias a vinena da tauna Bada na tempolma nopone e saḡa be piupiu e gabuna. ");
INSERT INTO dww_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Naumeki da Sakaraias tempol nopone piupiu ya gabugabuna maika, banaga ḡesaudima gabure a mia kwasa, be a moimoiragina. ");
INSERT INTO dww_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakaraias tempol nopone piupiu ya gabugabuna maika, Bada na aneama piupiu oltanama diane ya maḡatarana, Sakaraias kasaunama yauwane. ");
INSERT INTO dww_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaraias anea ya kitakitana, tauna ya ḡosori be ya naira kauana. ");
INSERT INTO dww_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Be anea ya riuena, “Sakaraias, nam kwa naira! Mamaitua am moiragima ya paribeena, da am visarama Elisabet gomana tauḡominama tokare e tikana, be tam inam gomeninama kwai isana Jon. ");
INSERT INTO dww_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Inam gomeninama tam ei nuaverem be banaga toitoi tai nuaverena inam gomeninama ya tubuḡana aubainama. ");
INSERT INTO dww_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Baninama Bada matane tauna tokare banaga dosinama e tubuḡana. Tauna tokare nam waen bo upa bagibagidima e tegodi, ibewa. Be tauna tinanama kapone da nokoi ya naḡona Arua Babau noponama e moḡavuna. ");
INSERT INTO dww_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tauna Israel banegidima toitoi e verauḡa munaḡedina Bada adi Mamaituama ḡarone. ");
INSERT INTO dww_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Be tauna Bada na kedadokadokama be tauna Elaija na aruama be na wairewapanama maika e noyana. Be tauna dosi nuedima e vitaredi da adi sedama nuedima ta paḡona. Be banaga rawarawa ḡaiḡaidima nuedima e vitaredi da Mamaitua na nuauyauyama ta kataie be yawasana didimanine ta miana. Inam yabedima matabudi e voiedi, da banaga e vokaukauedina Bada na kaba verauma aubainama.” ");
INSERT INTO dww_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Be Sakaraias anea ya riuena, “Nemanama yà kataie bake da tam kwa riuriu kaua? Baninama taugu yau visarama mate kaiteka kèi rawadosina.” ");
INSERT INTO dww_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dabudine anea Sakaraias ya paribee be ya riuna, “Taugu Geibriel. Taugu Mamaitua noḡone yà midimidina, tauna ya riuporeguna da uma riunama verenama yà riuriuemna, ");
INSERT INTO dww_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","be tam nam kui sumaḡeguna, aubainama yodi tam gumgum kwa miana naumeki da uma yabedima matabudi adi raḡan kaue ta tubuḡana.” ");
INSERT INTO dww_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Banaga yaḡoro doḡae awai rabana da Sakaraias sibo ya dobina, be taudi a nuababaḡana aba aubainama Sakaraias tempol nopone e miamia gurata. ");
INSERT INTO dww_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tauna doḡae ya dobidobina raḡanine, nam aba i giuena, be matairaḡa ya voiena. Dabudi banaga a kataie da tauna mataḡomine rauboni ya kitana, be Sakaraias tauna naumeki da gumgum ya mianana. ");
INSERT INTO dww_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Naumeki da tauna na noyama taparoronama ya kovikovina, tauna ya munaḡana na vadae. ");
INSERT INTO dww_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Inam kauidima muridie tauna na visarama Elisabet ya boga be semoe ya miana naumeki da nawaravi 5 a kovina. Be Elisabet ya riuna, ");
INSERT INTO dww_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Bada na raukiviveree ya raunuatoiegu be yau tunimayaḡama ya kaiporena.” ");
INSERT INTO dww_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Raḡanine Elisabet na nawaravima aniwai 6-nama murine, Mamaitua anea Geibriel ya riupore da ya naḡona matatapu isanama Meri ḡarone, tauna Jousep mate ai ḡoapaparana. Jousep tauna guyau Deivid na damma nopone. Taudi rabuidi Nasaret meagaine a mianana Galili provinsnama nopone. ");
INSERT INTO dww_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Dabudine anea ya saḡa da Meri ya riuena, “Ebom tam waivima waiaiainimma, Bada ḡarome.” ");
INSERT INTO dww_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Inam raḡanine Meri ya nuababaḡana be anea aba ya giugiuena tauna nam i kataiena, be tauna yawai nuanoḡonoḡotana da inam giudima banidima aba. ");
INSERT INTO dww_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Be anea ya riuena, “Meri nam kwa naira! Tam Mamaitua kwawai nuavaina. ");
INSERT INTO dww_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tam tokare kwa boga be gomana tauḡominama kwa tikana, be inam gomeninama kwai isana Yesu. ");
INSERT INTO dww_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tauna tokare banaga dosinama be Mamaitua saḡasaḡa vavasaḡinama natunama e tubuḡana. Be Yesu guyau Deivid na dame e tubuḡana aubainama Mamaitua Deivid na waiguyauma natunama Yesu e utena. ");
INSERT INTO dww_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Be tauna Israel ḡarodie ei bada nonoḡana, be na waiguyauma nam e kovi.” ");
INSERT INTO dww_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Be Meri anea yai taravirena, “Inam nemanama? Taugu tauḡoma nam mayanama e paḡona.” ");
INSERT INTO dww_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Be anea ya paribee be ya riuna, “Arua Babau tokare e tava ḡarome be saḡasaḡa vavasaḡinama na rewapanama vagurunama e rupumna. Inam vutuna aubainama tam tokare gomana babaunama kwa tikana, tauna Mamaitua Natunama. ");
INSERT INTO dww_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kwa noḡoti da am dame Elisabet avedi yai rawadosina be gomana tauḡominama tokare e tikana. Banaga a riuna da tauna kaikaipoki be yodi Elisabet tauna kaite na nawaravima 6 a kovina, ");
INSERT INTO dww_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","baninama Mamaitua aba ya riuedina tokare matabudi ta tubuḡana.” ");
INSERT INTO dww_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Be Meri ya riuna, “Taugu Bada na taunoyama, be aba kuya riueguna tokare naumeki da e tubuḡana.” Naumeki da anea Meri ya gose be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Inam kauinama murine Meri ya midisuḡu be ya naḡona oyae Judia provins nopone ");
INSERT INTO dww_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sakaraias na meagaie, Elisabet kitanama be waikaiwenama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Be Elisabet Meri na waikaiwama ya vaivaiena raḡanine, tauna kapone gomana yai dagudagu be Elisabet noponama Arua Babau ya moḡavuna. ");
INSERT INTO dww_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Be bonanama dosine ya riuna, “Waiwaivi nopodie tam Mamaitua yai aiaina vavasaḡemna, tam be votamma mate! ");
INSERT INTO dww_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aina, taugu kamai banabanaga be aba aubainama kitaguma kuya tava? Tam Bada tinanama be. ");
INSERT INTO dww_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Taugu am waikaiwama è vaievaiena raḡanine, kapogue gomana nuanama ya vere be ya potina. ");
INSERT INTO dww_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tam Mamaitua yai aiainimna, baninama kuyai sumaḡa da Bada riunama ḡarome e tubuḡana.” ");
INSERT INTO dww_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meri ya riuna, “Taugu Bada yà kaisuḡu ");
INSERT INTO dww_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","be nuaguma ya verena, baninama Mamaitua tauwai yawasaniguma. ");
INSERT INTO dww_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Taugu waivi kavakava be yaḡoro tauna ya noḡotiguna. Be yodi da nokoi ya naḡona kimta da kimta tokare ta riuna da riukaua taugu Mamaitua yai aiainiguna, ");
INSERT INTO dww_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","baninama Mamaitua tauna vutuna babau be wairewapana vavasaḡinama tauna aubaiguma yaba dosinama ya voiena. ");
INSERT INTO dww_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tauna na raunuatoima kimta be kimta aitauḡa tauna ta vivivivirena e utedina. ");
INSERT INTO dww_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tauna nimanama wairewapanine yaba dosidima ya voiedina be banaga raurau guyaguyaudima yai daberaridina. ");
INSERT INTO dww_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tauna banaga wairewapanidima adi waibadae ya biri dobiḡedina, be banaga wainuatoitoidima ya biri tavaitedina. ");
INSERT INTO dww_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tauna banaga kanikaniguridima vere ya utedina, be banaga waimauridima nimakavekavedima ya riuporedina. ");
INSERT INTO dww_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tauna na taunoyama Israel e saguda, e noḡotida be e raunuatoi nonoḡedana, ");
INSERT INTO dww_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","maika boni Eibraham be na damma ya riuedina nama.” ");
INSERT INTO dww_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri Elisabet mate a miana nawaravi rabuiteḡa, be muriḡa ya munaḡana na vadae. ");
INSERT INTO dww_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yodi Elisabet na wainatunama raḡaninama ya tavana da gomana tauḡominama ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabet na banagama be na damma inam varinama a vaie be matabudi nuedima ya vere kauana, baninama Mamaitua tauna Elisabet ya raunuatoi kauena. ");
INSERT INTO dww_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Be gomana na raḡanima aniwai 8-nama, inam raḡanine taudi matabudi a tavana kopitom aubainama. Be taudi a ḡoeḡoena da gomana sibo tamanama isane ai isana Sakaraias. ");
INSERT INTO dww_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Be tinanama ya riuna, “Ibewa! Tauna isanama Jon.” ");
INSERT INTO dww_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Be taudi a riuna, “Aba aubaina? Tam am dame inam nama isanama nam ima kenakenana.” ");
INSERT INTO dww_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dabudine taudi gomana tamanama waibuae ai taravire da gomana isanama nema. ");
INSERT INTO dww_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dabudine Sakaraias anigiruma ya ḡoena da a ute be bogane umanama ya girumana, “Tauna isanama Jon”, be taudi inam isanama a basena. ");
INSERT INTO dww_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Be yai raḡantenaḡe da Sakaraias ya giu munaḡa be Mamaitua isanama ya kaisuḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Be na banagama inam kauidima a kitekitedina, taudi Mamaitua na rewapanama a base be Judia provins matabuna nopone inam yabedima banaga ai giugiuedina. ");
INSERT INTO dww_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Banaga matabudi aitauḡa nama giudima a vaivaiedina, taudi ai nuanoḡonoḡote be a riuna, “Uma gomeninama tokare aba e tubuḡa, baninama yodi tà kitakitana da Mamaitua tauna mate.” ");
INSERT INTO dww_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Be Jon tamanama Sakaraias noponama Arua Babau yai moḡavu be Mamaitua riunama yawai perovetaena. ");
INSERT INTO dww_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bada Israel Mamaituanama yà kaikai suḡusuḡuna. Tauna ya verauna na banagama kuvesidima be waiyawasanidima aubainama. ");
INSERT INTO dww_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tauna na taunoyama Deivid na dame Tauwai yawasana wairewapaninama ya riuporena tauda aubaidama, ");
INSERT INTO dww_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","maika boni Mamaitua peroveta ḡarodie ya giugiuna nama, ");
INSERT INTO dww_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","da tauna banaga aitau ta tuatuaḡaiedana bo dà ḡaviama nimedie be tauna ei yawasanidana. ");
INSERT INTO dww_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tauna e rarau nuatoina waḡawaḡadama waḡewaḡedima ḡarodie be riuwainoḡota babaunama e noḡotina ");
INSERT INTO dww_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","vutuna tauna tamadama Eibraham ḡarone boni ya sausaugana nama. ");
INSERT INTO dww_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Tauna dà ḡaviama adi rewapanae be ei yawasanidana da tauda babaudama tà tubuḡa be nuadama torane be didimana mate Mamaitua tai yaragena raḡan matabuna. ");
INSERT INTO dww_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Be tam yau gomanama tam tokare Mamaitua saḡasaḡa vavasaḡinama na perovetama. Baninama tam tokare kwa doka be Bada na kedama kwa sepana. ");
INSERT INTO dww_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tam banaga kwa riuedina da Mamaitua taudi ei yawasanidina, baninama yodi raḡan ya tavana da Mamaitua adi gewagewama e noḡota poredina. ");
INSERT INTO dww_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Baninama Mamaitua na raunuatoima dosinama kapoyaninama marae be ḡarode yovonama ewai karena, ");
INSERT INTO dww_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","da yana e yovoḡena aitauḡa guri na waikupikupie ta miamiana ḡarodie. Be tauna ei dokeda be suba kedanama ei kataidana.” ");
INSERT INTO dww_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Naumeki da gomana ya moraba da arue yai rewapanana. Be tauna dobu kavakavane ya miana naumeki da na raḡan kauama ya tavana, yodibe patara nopodie na noyama yai karena Israel banegidima ḡarodie. ");
INSERT INTO dww_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Inam raḡandie Sisa Augastas na riuma ya boru da dobu matabuna deḡo banaga ta miamiana, nama sensus ta voiena. ");
INSERT INTO dww_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Noḡone nam sensus i kenakenana, be uma raḡandie yodi sensus ai karena. Inam raḡanine Kwirinias tauna Siria provins nopone yawai primiana. ");
INSERT INTO dww_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Vutuna aubainama banaga matabudi a munaḡana adi meagaie sensus aubaina. ");
INSERT INTO dww_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Naumeki da Jousep mate tauna Nasaret meagainama Galili provins nopone ya gose be ya naḡona Betliemma, guyau Deivid na meagaie Judia provins nopone, baninama Jousep tauna Deivid na damma nopone. ");
INSERT INTO dww_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Be Jousep na ḡoapaparama Meri ma bogana, taudi a naḡona sensus aubainama. ");
INSERT INTO dww_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Be taudi Betliemma be gomana na kaba tubuḡama raḡaninama ya tavana, ");
INSERT INTO dww_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","naumeki da Meri gomana kaevounama tauḡominama ya tikana. Be barekie nam deḡo gabu i kenakenana aubainama, tauna gomana garae ya paiwi be musara adi ḡobee yai kenana. ");
INSERT INTO dww_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Inam kupine sipu taurabedima wapue a miana be adi sipuma a kitakita watanidina. ");
INSERT INTO dww_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Be Bada na aneama ḡarodie ya dobi be Bada neneḡarinama yai yanedi be taudi a naira kauana. ");
INSERT INTO dww_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dabudine anea ya riuedina, “Nam ko naira! Taugu vari verenama yà yovoyovoḡena ḡaromie da tokare banaga matabuna tai nuaverena, ");
INSERT INTO dww_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","baninama manaka Deivid na meagaie Tauwai yawasana ya tubuḡana taumi aubaimima. Tauna Bada Keriso. ");
INSERT INTO dww_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Taumi gomana umanama ko kitana, tauna a paiwi be musara adi ḡobee e kenakenana, be inam nama ko kataiena da inam tauna.” ");
INSERT INTO dww_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Be yai raḡantenaḡe da anea damnama dosinama a maḡatara be inam aneanama mate Mamaitua a kaisuḡusuḡu be a riuriuna, ");
INSERT INTO dww_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kawasaḡe be kaisuḡusuḡu Mamaitua ḡarone ta kena, baninama tauna saḡasaḡa vavasaḡinama aubainama. Be aitauḡa dobue didimanaḡa ta naḡonaḡona, Mamaitua taudi na subama e uteutedina.” ");
INSERT INTO dww_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Raḡanine anea tauyosi a gosedi be a munamunaḡana marae, dabudine tauyosi adi banagama adi banagama a riuedina, “Tà naḡo Betliemma be Bada ya riuriuedana ya tubuḡana tà kitana.” ");
INSERT INTO dww_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Naumeki da a naḡo makamakai da Jousep, Meri be gomana musara adi ḡobee ya kenakenana a banavidina. ");
INSERT INTO dww_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Taudi inam kauinama a kitakita kovina, murine anea gomana varinama ya riuriuedina, inam dabudi ai daberarina. ");
INSERT INTO dww_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Be banaga matabudi aitauḡa tauyosi adi giuma a vaivaiena, taudi a basena. ");
INSERT INTO dww_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Be Meri tauna inam riudima nuane ya taudididi be yawai nuanoḡonoḡotedina. ");
INSERT INTO dww_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Naumeki da tauyosi a munaḡa be Mamaitua a kawa saḡe be a kaisuḡuna yaba matabuna a kitakita be a vaivaiena aubainama. Yaba matabuna anea ya riuriuedina, nama a tubuḡana. ");
INSERT INTO dww_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yodi gomana na raḡanima aniwai 8-nama, inam kopitom raḡaninama ya tavana, be dabudine taudi gomana ai isana ‘Yesu’. Inam isanama anea Meri ya riu dokena, muriḡa da Meri ya bogana. ");
INSERT INTO dww_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Raḡanine Meri gomana tauḡominama ya tikana murine, Mousis na tarawatuma e riuriuna ruvane Meri nam waiḡapa i naḡona Mamaitua na vadae. Ibewa da ya miana da na raḡanima 40 a kovina. Be murine Jousep be Meri Yesu a tika saḡena Jerusalemma Bada waikatainama aubainama, ");
INSERT INTO dww_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","baninama Bada na tarawatuma umanama ya riuna, “Banaga be musara tautauḡomidima kayevoudima matabudi ko saḡedi be Bada ko utena.” ");
INSERT INTO dww_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Be puyo bunebune rabui bo gabubu natunatudima rabui mate a saḡedina Bada na tarawatuma ya girugirumina nama. ");
INSERT INTO dww_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Inam raḡanine banaga tenaḡa Jerusalemma ya miamiana, isanama Simeon. Tauna yawasana didimanine ya mia be Mamaitua ya vivivivirena be Arua Babau tauna noponama ya moḡavu, be Israel tauwai yawasaninama ya raberabena. ");
INSERT INTO dww_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Be Arua Babau Simeon ya riuena da tauna nam sibo ya guri naumeki da noḡone Bada na Kerisoma e kitana. ");
INSERT INTO dww_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Naumeki da Meri be Jousep gomana Yesu a saḡena tempol nopone da tarawatu aba ya riuriuedina voiedima aubainama. Inam raḡanine Arua Simeon yai doka nawena tempol nopone. ");
INSERT INTO dww_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Be dabudine Simeon nimane gomana ya tika be Mamaitua ya kaisuḡusuḡuna be umanama ya riuna, ");
INSERT INTO dww_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Naumeki Bada, yodi taugu am taunoyama nuasubae yà gurina kuya riuriueguna nama, ");
INSERT INTO dww_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","baninama Tauwai yawasana kuya riuriuporena, yodi matague è kitana. ");
INSERT INTO dww_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tauna dobu matabuna aubainama kuya riuporena. ");
INSERT INTO dww_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tauna dam matabudi e rawayanedi be tam ta kataiemna. Be mate tauna e voie da am banagama Israel ta kawa saḡedina.” ");
INSERT INTO dww_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Be Simeon gomana nema ya giugiu bakena, gomana na dosima inam giudima a basedina. ");
INSERT INTO dww_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dabudine Simeon taudi yai aiainidi be gomana tinanama Meri ya riuena, “Israel banegidima toitoi adi yawasanae ta bekuna be toitoi adi yawasanae ta midisuḡuna, uma gomeninama kana taiye. Tauna Mamaitua ewai matairena aubainama banaga toitoi ta riuvirevirena ");
INSERT INTO dww_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","be adi wainua noḡonoḡotama tauna ei maḡataridina. Inam voiedima matabudi aubaidima tam tokare ta voiem da kwai nuaboya kauana, maika kea gamgamnama kabe nuapoume i midimidi.” ");
INSERT INTO dww_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Be peroveta waivinama poranama isanama Hana, tauna mate dobudi tempol nopone. Tauna Panuel natunama be Aser na damma nopone. Hana na badama mate ai naḡi be a mianana modi 7 ");
INSERT INTO dww_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","murine tauna yai kaiyababana. Be yodi tauna na suarama 84 be kupi da suara tempol nopone ya miamiana. Be nam airaḡan tempol i gose rubuna. Tauna na noyama ya widiwidina be ya moimoiragina. ");
INSERT INTO dww_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Naumeki da Simeon gomana na dosima mate a giugiuna raḡanine, Hana ya saḡa da Mamaitua ya kaisuḡusuḡu be banaga aitauḡa Jerusalem na Tauwai yawasanama a raberabena ḡarodie gomana na kauama ya giuedina. ");
INSERT INTO dww_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Raḡanine Jousep be Meri yaba matabuna Bada na tarawatuma ya riuriuena a voia rovodina, murine taudi a munaḡana adi meagaie Nasaretma, Galili provins nopone. ");
INSERT INTO dww_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Dabudine gomana ya moraba be yai rewapanana, be nuauyauya noponama ya moḡavu be Mamaitua na raukiviverema tauna ḡarone ya kenana. ");
INSERT INTO dww_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Naumeki da Yesu na suarama 12, be na dosima mate a naḡona Jerusalemma Naḡopore soinama aubainama. Inam taudi adi vaivaima aubainama, taudi modi matabuna ta naḡonaḡona Jerusalemma, inam soinama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Raḡanine inam soinama ya kovikovina murine, taudi naḡo munaḡa meagaie ai karena, be gomana Yesu ya mia kwasana Jerusalemma, be na dosima taudi nam ti kataiena. ");
INSERT INTO dww_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Taudi ai noḡotana kabe na banagama mate ti naḡonaḡo naumeki da a naḡo ravina. Be ravie gomana wanenama ai karena na dosima be na banagama ḡesaudima ḡarodie. ");
INSERT INTO dww_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Be taudi gomana nam ti banavina aubainama waiwanawana a munaḡana Jerusalemma. ");
INSERT INTO dww_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Raḡan aniwai rabuiteḡane taudi gomana tempol nopone a banavina. Yesu tauna tauwai katakatai poudie ya mia be tauna taudi mate awai giuna be yawai beavaiedina. ");
INSERT INTO dww_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Be banaga matabudi aitauḡa gomana a vaivaiena, na kataima be na paribeama a base kauena. ");
INSERT INTO dww_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Raḡanine na dosima a banavina, nuedima yai medi be tinanama ya riuena, “Taukui, aba aubainama umanama kuya voia ḡaromaie? Tamamma rabuigu ma nuaboyamai kè wanewanemna.” ");
INSERT INTO dww_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Be tauna ya riuedina, “Aba aubainama koya wanewanegu? Taumi sibo koya kataie da taugu Tamaḡomiguma na vadae yà miamiana.” ");
INSERT INTO dww_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Be gomana aba ya riuriuena, taudi na giuma baninama nam ti kataiena. ");
INSERT INTO dww_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naumeki da tauna na dosima ya voteyeteyedi be taudi mate a naḡona Nasaretma, be tinanama inam giudima matabudi nuane ya taudididina. ");
INSERT INTO dww_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Be Yesu tauna na nuauyauyama be na suarama a moraba tenaḡana, be na wainuapaḡoma Mamaitua ḡarone be banaga ḡarodie mate. ");
INSERT INTO dww_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Raḡanine Sisa Tiberius tauna na waibadae ya miana na modima 15, be inam raḡanine Pontis Paelat tauna Judia provins primianama, be Herod tauna Galili provins na guyauma be tasinama Pilip, tauna Ituraia be Trakontis adi guyauma, be Lisanias tauna Abilene guyaunama. ");
INSERT INTO dww_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Be Hanas be Kaiyapas taudi pirisi dosidima. Inam banegidima adi waibadama raḡanine, Jon tauna dobu kavakavane ya miamiana be Mamaitua na riuma ya yovona, Sakaraias natunama Jon ḡarone. ");
INSERT INTO dww_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon ya naḡona upa Jodan dianama matabuna nopodie be banaga ḡarodie ya rauguguya be ya riuriuna, “Ami gewagewama ko gosedi be ko babataito da Mamaitua ami gewagewama e noḡota poredina.” ");
INSERT INTO dww_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon yaba matabuna nema peroveta Aisaia na bukae ya girugirumidina, nama ya voiedina. Peroveta Aisaia umanama ya riuna, “Banaga dobu kavakavane e yokoyokona, ‘Bada na kedama ko sepa, keda ko kawa didimanidina Bada na kaba verauma aubainama. ");
INSERT INTO dww_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gaugauba matabudi ko ḡuruvidi be oya matabudi debedima ko keri waiwapudina. Be yawasana barebaredima ko kawa didimanidi be keda pikepikedima ko keri yaḡoyaḡotidina. ");
INSERT INTO dww_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yodibe banaga matabudi Mamaitua nema ei yawasana bakedina ta kitana.’” ");
INSERT INTO dww_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Banaga ḡumnama a dobina Jon ḡarone babataito aubainama, be tauna ya riuedina, “Taumi maika mota sarama natunatudima! Taumi aitau ami wainua noḡonoḡotama ya voie da Mamaitua na kovoḡama ko naḡo pore, wa? ");
INSERT INTO dww_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Noḡone ko munaḡa da ami yawasanama ko vitaredi be yawasana banidima veredima koi maḡataridi da banaga ta kitedina, be nam ko noḡota munaḡemi be ko riuna, ‘Tauda Eibraham natunatunama aubainama ḡarode nam tokare gewagewa aba e tubuḡa.’ Yà riuriuemina da Mamaitua sibo i ḡoena, tokare teneteneḡinama kaua yekudie seda yai tubuḡidina Eibraham aubainama. ");
INSERT INTO dww_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bada tamiyoko kaite kai bogane ya boruna, be ai kaiḡa nam banidima veredi matabudi e taraḡa poraḡa be e gabugorudina.” ");
INSERT INTO dww_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dabudine banaga ḡumnama a riuna, “Yodi aba tà voie?” ");
INSERT INTO dww_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Be Jon ya paribeedina, “Aitauḡa ḡaromie kwama rabui, tenaḡa turamma nam waikwamana kwa utena, be kani mate nama ko voiena.” ");
INSERT INTO dww_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Teks tautaminama mate a verauna babataito aubainama be ai taravirena, “Tauwai katakatai, tauma aba ka voie?” ");
INSERT INTO dww_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Be Jon ya riuedina, “Teks a riuriuemina na ruvae nama ko ragauna be nam ko tausaḡe.” ");
INSERT INTO dww_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Be banaga iḡeiḡeridima mate ai taravirena, “Tauma nema ka voie bako?” Be tauna ya riuedina, “Nam banaga ko raukivi gewegewedi be nam ko riu waigusudi be adi waiyabama ko paḡo avedi, taumi ami maesama inam naumeki ewai nuasubemina.” ");
INSERT INTO dww_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dabudine banaga matabudi Tauwai yawasana a raberabena, be awai noḡotana da kabe Jon tauna vutuna Tauwai yawasana. ");
INSERT INTO dww_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Be tauna umanama ya riuedina, “Taugu upakavakavae yàwai babataitomina be banaga murigue e veraverauna, tauna banaga dosinama be wairewapana vavasaḡinama, be taugu nam veregu da na kaḡasumama yà kaipore. Tauna tokare Arua Babaue be kaie ei babataitomina. ");
INSERT INTO dww_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tauna banaga vere be gewagewa e vinevinedina maika raisi. Raisi tauna e tutu, be sive nopone e ḡini be sive mui e suve be ḡavoe e dobidobina be baninama ḡavoe e dobidobina. Muriḡa tauna banidima e ragaragaudina, be muinama kai karakaratine e gabu gorudi be ta karakara nonoḡana.” ");
INSERT INTO dww_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Be giu ḡesaudima mate Jon na rauguguyae banaga ya sagudi da adi yawasanama a vitaredina. Nama tauna riu verenama ya rauguguyena. ");
INSERT INTO dww_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jon patara nopodie guyau Herod ya riuvirevirena, baninama tasinama na visarama Herodias ya kwayana be na gewagewama ḡesaudima mate aubainama. ");
INSERT INTO dww_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Vutuna aubainama Herod Jon dibure ya boru be you, na gewagewama ya taipotona. ");
INSERT INTO dww_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Muriḡa da Herod Jon dibure ya boruna, noḡone Jon banaga matabudi yai babataito rovodi be Yesu mate yai babataitona. Be Yesu ya moimoiragina raḡanine, mara ya nuaporaḡa ");
INSERT INTO dww_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","be Arua Babau ya yovona Yesu ḡarone maika kiu gabubu. Be marae bona ya dobina, “Tam taugu natuguma nuaguma kwa paḡopaḡona, be taugu yawai nuaverena tam ḡarome.” ");
INSERT INTO dww_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu tauna na suarama 30 be patara nopodie na noyama yai karena. Banaga ai noḡotana Yesu kabe Jousep natuna, be Jousep tauna Eli natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","be Eli tauna Matat natunama, be Matat tauna Livai natunama, be Livai tauna Melki natunama, be Melki tauna Janai natunama, be Janai tauna Jousep natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","be Jousep tauna Matatias natunama, be Matatias tauna Amos natunama, be Amos tauna Naum natunama, be Naum tauna Esli natunama, be Esli tauna Nagai natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","be Nagai tauna Mat natunama, be Mat tauna Matatias natunama, be Matatias tauna Simei natunama, be Simei tauna Josek natunama, be Josek tauna Joda natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","be Joda tauna Joanan natunama, be Joanan tauna Resa natunama, be Resa tauna Serubabel natunama, be Serubabel tauna Sealtiel natunama, be Sealtiel tauna Neri natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","be Neri tauna Melki natunama, be Melki tauna Adi natunama, be Adi tauna Kosam natunama, be Kosam tauna Elmadam natunama, be Elmadam tauna Er natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","be Er tauna Josua natunama, be Josua tauna Elieser natunama, be Elieser tauna Jorim natunama, be Jorim tauna Matat natunama, be Matat tauna Livai natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","be Livai tauna Simeon natunama, be Simeon tauna Juda natunama, be Juda tauna Jousep natunama, be Jousep tauna Jonam natunama, be Jonam tauna Elaiakim natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","be Elaiakim tauna Melea natunama, be Melea tauna Mena natunama, be Mena tauna Matata natunama, be Matata tauna Natan natunama, be Natan tauna Deivid natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","be Deivid tauna Jese natunama, be Jese tauna Obed natunama, be Obed tauna Boas natunama, be Boas tauna Salmon natunama, be Salmon tauna Nason natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","be Nason tauna Aminadab natunama, be Aminadab tauna Admin natunama, be Admin tauna Arni natunama, be Arni tauna Esron natunama, be Esron tauna Peres natunama, be Peres tauna Juda natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","be Juda tauna Jeikob natunama, be Jeikob tauna Aisik natunama, be Aisik tauna Eibraham natunama, be Eibraham tauna Tara natunama, be Tara tauna Nahor natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","be Nahor tauna Seruk natunama, be Seruk tauna Ragu natunama, be Ragu tauna Palek natunama, be Palek tauna Eber natunama, be Eber tauna Sala natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","be Sala tauna Kainam natunama, be Kainam tauna Arpaksad natunama, be Arpaksad tauna Sem natunama, be Sem tauna Noa natunama, be Noa tauna Lamek natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","be Lamek tauna Metusala natunama, be Metusala tauna Inok natunama, be Inok tauna Jaret natunama, be Jaret tauna Malaleel natunama, be Malaleel tauna Kainan natunama, ");
INSERT INTO dww_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","be Kainan tauna Enos natunama, be Enos tauna Set natunama, be Set tauna Adam natunama, be Adam tauna Mamaitua natunama. ");
INSERT INTO dww_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu Arua Babau noponama ya moḡavu be Jodan ya gose porena. Arua tauna yai doke be a naḡona dobu kavakavane na raḡanima 40. ");
INSERT INTO dww_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Inam dabudine Diaboro Yesu ya raurubuna. Inam raḡandie Yesu tauna nam aiyaba i kani rubuna, naumeki da raḡan 40 a kovikovina, Yesu tauna kani ya karatina. ");
INSERT INTO dww_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Be Diaboro Yesu ya riuena, “Deḡoda tam Mamaitua Natunama, naumeki da uma yekunama kwa riue da ei rawaburedi.” ");
INSERT INTO dww_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Be Yesu ya paribee be ya riuna, “Girugiruminama poranama umanama ya riuna, ‘Banaga nam buredi ḡomae e mia.’” ");
INSERT INTO dww_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dabudine Diaboro yai doka nawena oya daudaunama debane, be dobu matabuna na waiguyauma yai kataina. ");
INSERT INTO dww_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Be Diaboro Yesu ya riuena, “Uma rewapanidima be uma yabedima waimatakanikanidima matabudi Mamaitua taugu ya uteguna. Vutuna aubainama aitau yà ḡoeḡoena nama yà utena. ");
INSERT INTO dww_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Be deḡoda tam taugu kwa rauduneeguna, inam yabedima matabudi tam yà utemna.” ");
INSERT INTO dww_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Be Yesu ya paribee be ya riuna, “Girugiruminama poranama umanama ya riuna, ‘Bada, am Mamaituama taunaḡa kwa raudunee, be ḡarone kwa noyana.’” ");
INSERT INTO dww_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dabudine Diaboro Yesu yai doka nawena Jerusalemma tempol daudaunama debane, be ya riuena, “Deḡoda tam riukaua Mamaitua Natunama, naumeki da uma dobudine kwa potina, ");
INSERT INTO dww_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","baninama girugiruminama poranama umanama ya riuna, ‘Mamaitua na aneama e riuporedi da tam ta rabemna. ");
INSERT INTO dww_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Be nimedie ta kaisuḡum da nam yekue kaḡamma kwai tutu.’” ");
INSERT INTO dww_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Be Yesu ya paribeena, “Girugiruminama poranama mate umanama ya riuna, ‘Bada, am Mamaituama nam kwa raurubu.’” ");
INSERT INTO dww_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Raḡanine Diaboro na raurubuma ya kovikovina, naumeki da tauna Yesu ya taugosena raḡan ḡaubonaḡa. ");
INSERT INTO dww_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Arua Babau na wairewapanae Yesu ya munaḡana Galili provins nopone, be banaga matabudi inam dabudi tauna a giugiuena. ");
INSERT INTO dww_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Be tauna taudi sinagog nopone yai katakataidi be taudi tauna isanama a kaisuḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Be Yesu ya naḡona Nasaretma deḡo ya moramorabe. Be Sabat raḡanine ya naḡona sinagog nopone maika nema Sabat matabuna ya voivoiana nama. Be tauna ya midisuḡu da girugiruminama sievinama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Peroveta Aisaia na bukama tauna a ute be ya tapa da deḡo giruma ya riuna, ");
INSERT INTO dww_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bada Aruinama nopogue, baninama tauna ya vineguna da riukaua yà rarau guguyena banaga waikaruwaḡewaḡedima ḡarodie. Be tauna ya riuporeguna da banaga panipanidima yà riuedi da ta kuvesidina. Be banaga matapotepotedima tai kita munaḡa. Taugu è yovona banaga adi banagama ta rarau kivi gewegewedina yài ḡakedina. ");
INSERT INTO dww_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Be tauna ya riuporegu da yà giugiuna, yodi raḡan ya tavana da Bada na banagama ei yawasanidina.” ");
INSERT INTO dww_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Dabudine Yesu buka ya gudu be taunoya ya ute munaḡe da ya miana, be sinagog nopone banaga matabudi matedima Yesu ḡarone. ");
INSERT INTO dww_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dabudi Yesu giu yai kare be ya riuedina, “Manaka inam riudima koya vaivaiedina, baninama ya tubuḡana.” ");
INSERT INTO dww_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Be banaga matabudi Yesu isanama a kaisuḡusuḡu, be taudi Yesu na giuma veredima aubainama a basena. Be taudi a riuna, “Tauna Jousep natunama! Be nemanama da umanama e giugiu?” ");
INSERT INTO dww_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Be Yesu ya riuedina, “Taugu è kataiena da uma riunama tokare ko riueguna, ‘Dogeta kwai yawasana munaḡem!’ Be mate ko riueguna, ‘Tauma kè vaiem be Kapeniamma yaba kuya voivoiedina, nama uma dabudine am meagaie kwa voiedi.’” ");
INSERT INTO dww_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Be tauna ya riuna, “Taugu yà riuriu kauemina, peroveta na dobue banaga na giuma vaienama nam tima ḡoeḡoena. ");
INSERT INTO dww_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Taugu yà riukauemina, peroveta Elaija na raḡanie banaga nam ti sipisipina, baninama modi 3 ½ marakapo ya karatana. Be inam raḡanine Israel nopone kaiyababa toitoi a miamiana. ");
INSERT INTO dww_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Be Bada nam Elaija i riupore i naḡona inam kaiyababidima ḡarodie, ibewa be ya riupore ya naḡona kaiyababa ḡesau ḡarone. Inam kaiyababinama tauna Sarepama miemieninama dobu isanama Saidon nopone. ");
INSERT INTO dww_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Be peroveta Elisa na raḡanie Israel nopone banaga toitoi sida kito ragaragaudima be inam dobudine Bada nam aitau tenaḡa i yawasanina be Naeman Siriaḡa tavatavanama taunaḡa yai yawasanina.” ");
INSERT INTO dww_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sinagog nopone banaga matabudi inam riunama nama a vaivaiena raḡanine, taudi nuedima yai medi kauana. ");
INSERT INTO dww_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dabudine taudi a midisuḡu da Yesu a soru dobiḡe da a nawena daki debane meagai diane. Dabudine kabe tauna dakie ta kiroḡa pore. ");
INSERT INTO dww_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Be Yesu patara nopodiḡa ya dobi be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dabudine Yesu ya dobi ya naḡona Kapeniam meagaine Galili provins nopone. Be Sabat raḡandie tauna banaga yawai katakataidina. ");
INSERT INTO dww_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Be banaga na waikatakataima a basena, baninama na waikatakataima yai rewapana kauana. ");
INSERT INTO dww_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Be sinagog nopone banaga penama kokukokunama, tauna bonanama dosine ya yogo be ya riuna, ");
INSERT INTO dww_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei! Nasaret Yesumma, tam aba ḡaromaie kwa ḡoeḡoe? Tam kuya verauna kwa kawa gewagewamai, bo? Taugu è kataiena tam aitau. Tam Babaumma Mamaitua ḡaronama.” ");
INSERT INTO dww_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Be Yesu ya riutuaḡaie be ya riuna, “Kwai nuatuḡu be inam baneginama kwa dobi pore!” Dabudine penama banaga ya dobi pore be ya gosena, be nam banaga i kawa gewagewana. ");
INSERT INTO dww_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Banaga matabudi a ḡosoridi be adi banagama mate a giu yabayababa be a riuna, “Uma aba giudima nama? Tauna na rewapanae penama e riuedi be ta dobidobina.” ");
INSERT INTO dww_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Be inam dobunama matabuna Yesu varinama a vaiena. ");
INSERT INTO dww_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu tauna sinagog ya gose be ya naḡona Saemon na vadae. Be inam dabudine Saemon rawanama tauna poyapoya dosinama ya paḡona be taudi Yesu ai baḡa da tauna e saguna. ");
INSERT INTO dww_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Dabudine tauna diane ya midi be poyapoya ya riutuaḡaiena, be poyapoya visara ya gose porena. Be yai raḡantenaḡe da visara ya midisuḡu be taudi adi kanima ya vokaukauena. ");
INSERT INTO dww_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Be ravi ya tavatavana raḡanine, banaga toitoi adi banagama sida tabu be tabu ragaragaudima a verauḡedina Yesu ḡarone, be tauna banaga tenatenaḡaḡa nimane ya taikonidi be yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Be mate penama toitoi ma yogoyogodi banaga a dobi poredi be a riuriuna, “Tam Mamaitua Natunama!” Be Yesu taudi ya riutuaḡaiedina da nam ta giu, baninama taudi a kataiena da tauna Keriso. ");
INSERT INTO dww_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Raḡan ya tomna da Yesu inam dobunama ya gose pore be dobu wainuatuḡune ya naḡona. Be banaga tauna a wanewanena, be a banavina raḡanine, taudi a ḡoeḡoe da tauna nam sibo ya gose poredi. ");
INSERT INTO dww_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Be Yesu taudi ya riuedina, “Taugu meagai ḡesaudie mate yà naḡo be Mamaitua na waiguyauma yà rauguguyena. Baninama Mamaitua ya riuporeguna vutuna aubainama.” ");
INSERT INTO dww_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Be tauna Galili be Judia sinagog nopodiḡa ya rarau guguya naḡona. ");
INSERT INTO dww_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Raḡan tenaḡa Yesu tauna Genesaretma yawawa diane ya midimidina. Be banaga tauna a midi ḡuruvi be Mamaitua riunama a vaibeavaiena. ");
INSERT INTO dww_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Be tauna waga rabui ya kitedina gerese a midimidina, be tauwai sagida adi wagama a gosedi da adi sagidama a koḡekoḡedina. ");
INSERT INTO dww_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu Saemon na wagae ya saḡa be yai baḡana da waga sibo ya tauriena topae, yodibe tauna ya mia yovo wagae be banaga yai katakataidina. ");
INSERT INTO dww_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Raḡanine na giuma ya kovikovina, tauna Saemon ya riuena, “Waga kwa dobiḡe topa poune be ami sagidama koi dawe dobiḡedi be iyana ko konedi!” ");
INSERT INTO dww_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Be Saemon ya paribeena, “Bada, tauma kupi daudaunama sagida kè raurubu rereḡa da nam aba ke kona rubuna, be tam am riuma aubainama da yà raurubu munaḡana.” ");
INSERT INTO dww_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Raḡanine a rarau rubu munaḡana, iyana toitoi a konedi be sagida ḡaubonaḡa sibo a nuagigina. ");
INSERT INTO dww_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Be taudi adi banagama waga ḡesaune a raumataḡuiedina da taudi sibo a verau be a sagudina. Naumeki da adi banagama a verau a sagudi da iyana waga rabui ai moḡavudina, be waga ḡaubonaḡa sibo a monuna. ");
INSERT INTO dww_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Be Saemon Pita uma kauinama ya kitakitana tauna tuapikane ya raupari Yesu noḡone be ya riuna, “Bada, kwa gosegu be ḡavoe kwa naḡo, baninama taugu banaga gewagewaguma!” ");
INSERT INTO dww_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tauna nama ya giuna, baninama tauna na banagama mate a base be a nairana iyana toitoi a vunuḡana aubainama. ");
INSERT INTO dww_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Be nama Saemon na banagama Jeims be Jon, Sebedi natunatunama. Be Yesu Saemon ya riuena, “Nam kwa naira! Yodibe nokoi ya naḡona tam banaga toitoi kwa konedina.” ");
INSERT INTO dww_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Raḡanine barabarae adi wagama a sorusoru tavaitedina, taudi yaba matabuna a goseporedi be Yesu ai muriwatanina. ");
INSERT INTO dww_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Raḡan tenaḡa Yesu tauna meagai tenaḡa nopone ya miamiana be tauḡoma tenaḡa ya verauna tuninama kito ya moḡavuna. Inam tauḡominama Yesu ya kitakitana, tauna Yesu noḡone ya raupari be yai baḡana, “Bada, tam deḡoda kwa ḡoena, naumeki da kwai yawasanigu.” ");
INSERT INTO dww_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Be Yesu ya riuena, “Naumeki, taugu yà ḡoeḡoena, kwa yawasana!” Dabudine Yesu nimanama yai yoyo be ya taukonina. Be yai raḡantenaḡe da sida kito tauḡoma ya gosena. ");
INSERT INTO dww_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Be Yesu inam tauḡominama ya riu vavasaḡena, “Nam aitau kwa riue. Be kwa naḡo da pirisi ḡarone be tauna e kaiviramna. Be murine Mamaitua kwa tipana Mousis na tarawatuma e riuriuna nama. Inam kedane banaga tokare ta kitam be ta kataiena da tam kuya yawasana munaḡana.” ");
INSERT INTO dww_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Be yaḡoro da Yesu varinama ya moraba be ya daberarana. Be banaga toitoi Yesu waibeavaienama be ei yawasanidina aubainama a tavatavana. ");
INSERT INTO dww_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Be Yesu banaga ya gosedi be ya naḡona dobu wainuatoitoine moiragi aubainama. ");
INSERT INTO dww_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Raḡan tenaḡa Yesu yawai katakataina be Parisi be tarawatu tauwai katakataidima taudi mate a mia be awai beavaiena. Inam banegidima meagai matabudi Galili provins be Judia provins nopodiḡa be Jerusalemḡa a verau be awai beavaiena. Be Bada na rewapanama Yesu ḡarone vutuna aubainama tauna sida yawai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Naumeki da banaga ḡesaudima tauḡoma tuera paḡopaḡonama ratiratinama a kiroḡa verauḡe da kabe vadae ta saḡe be Yesu noḡone tai kena. ");
INSERT INTO dww_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Be taudi nam teneteneḡina da vadae sibo a saḡa, baninama patara ya moraba kauana. Vutuna aubainama taudi vada debane a saḡa be vada debane gaura a voie da tauḡoma ma ratiratina ai dawe dobiḡena patara poudie Yesu noḡone. ");
INSERT INTO dww_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Raḡanine Yesu adi waisumaḡama ya kitakitana, tauna ya riuna, “Tauḡoma, am gewagewama è noḡota porena.” ");
INSERT INTO dww_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dabudine Parisi be tarawatu tauwai katakataidima umanama wainua noḡonoḡota ai karena, “Uma aitau baneginama nama ewai diboḡa, wa? Tauna e ḡoeḡoena da Mamaitua gabunama e paḡo, bo? Mamaitua taunaḡa tokare gewagewa e noḡota poredina, be nam aitau ḡesau.” ");
INSERT INTO dww_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Be Yesu taudi adi wainua noḡonoḡotama ya kataiedina aubainama yai taraviredina, “Aba aubainama taumi inam yabedima nuemie kowai nuanoḡonoḡotedi? ");
INSERT INTO dww_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aba riunama ya tekateka, ‘Am gewagewama è noḡota porena’ bo ‘Kwa midisuḡu be kwa naḡo?’ ");
INSERT INTO dww_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Be yodi yài kataimi be ko kita da Banaga Natunama dobue rewapana ḡarone e kenakenana da gewagewa e noḡota poredina.” Naumeki da Yesu tauḡoma tuera paḡopaḡonama ya riuena, “Yà riuriuemna, kwa midisuḡu, am gunima kwa paḡo be kwa naḡona am vadae.” ");
INSERT INTO dww_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yai raḡantenaḡe tauḡoma noḡodie ya midisuḡu da na gunima ya paḡo be ya naḡona na vadae, Mamaitua isanama ya kaisuḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dabudi banaga matabudi a base be taudi mate Mamaitua isanama a kaisuḡusuḡuna. Be matabudi a ḡosoridi be a riuna, “Manaka tauda kaua dosinama tè kitana.” ");
INSERT INTO dww_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Uma kauinama murine Yesu ya dobi be ya naḡonaḡo da teks tautaminama isanama Livai ya kitana. Livai tauna na kaba noyae ya miamiana, be Yesu tauna ya riuena, “Kwai muriwatanegu!” ");
INSERT INTO dww_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Naumeki da Livai ya midisuḡu be yaba matabuna ya gosedi be Yesu yai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dabudine Livai na vadae soi dosinama ya voiena Yesu aubaina, be teks tautamidima toitoi be banaga ḡesaudima mate dabudine a kanikanina. ");
INSERT INTO dww_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Vutuna aubainama Parisi be tarawatu tauwai katakataidima taudi Yesu na tauwai muriwatanama a riusinḡaḡayedi be a riuna, “Aba aubainama taumi teks tautamidima be gewagewa banegidima mate ko kanikani be ko tegotego?” ");
INSERT INTO dww_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dabudine Yesu ya paribeedi be ya riuna, “Banaga yawayawasanidima taudi nam dogeta tima ḡoeḡoena, be banaga sidesidedima taudi dogeta ta ḡoeḡoena. ");
INSERT INTO dww_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Taugu nam e yovona banaga veredima aubaidi, ibewa da banaga gewegewedima yà riuedi da adi noḡotama ta vitaredina.” ");
INSERT INTO dww_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Be taudi Yesu a riuena, “Jon na tauwai muriwatanama be Parisi adi tauwai muriwatanama matabudi kana raḡanie ta widiwidina be ta moimoiragina, be tam am tauwai muriwatanama taudi ta kanikani be ta tegotego yabayababana.” ");
INSERT INTO dww_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Be Yesu ya riuedina, “Naḡivau tauḡominama taumi mate ko miamiana raḡanine, taumi nam ko voie da naḡinaḡi kadi warema ta widina. ");
INSERT INTO dww_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Be raḡan e tavana da naḡivau tauḡominama ḡavoe ta nawena, inam raḡanine taudi ta widinana.” ");
INSERT INTO dww_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu uma wainasinama mate ya riuedina, “Nam aitau gara vaunama e sika be e naḡo gara poranama mate e popo tenaḡe. Be deḡoda nama sibo i voiana, gara vaunama tokare e kawa gewagewana, be gara vaunama nam gara poranama mate tai rawateḡeidi be teneteneḡina. ");
INSERT INTO dww_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Be nam aitau waen vaunama waen poranama koukounama nopone e ḡini. Baninama deḡoda nama e voiana, inam tokare waen vaunama koukou e surasari be waen e rauḡinina. Be koukou ta gewagewana. ");
INSERT INTO dww_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ibewa da waen vaunama koukou vaudie ko ḡinidina. ");
INSERT INTO dww_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Be aitau waen poranama ya tegotegona, waen vaunama nam ima ḡoeḡoena, baninama tauna e riuriuna, ‘Waen poranama ya vere kauana, nam waen vaunama maika.’” ");
INSERT INTO dww_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat tenaḡa Yesu be na tauwai muriwatanama mate a naḡona wapue yaḡoda sipine be na tauwai muriwatanama yaḡoda a ragaudi da a vukudi be a kanikanidina. ");
INSERT INTO dww_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Be Parisi ḡesaudima nama a kitakitana taudi a riuna, “Taumi Sabat raḡanine inam yabedima nam sibo koya voivoiedi, be aba aubainama taumi yodi ko voivoiedi?” ");
INSERT INTO dww_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Be Yesu ya paribeedi be ya riuna, “Taumi koya kataie bo ibewa da boni Deivid na banagama mate kani ya karatidi be aba a voie? ");
INSERT INTO dww_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tauna ya naḡona Mamaitua na vadama nopone be buredi Mamaitua waikatainama ya ragaudi be na banagama mate ya utedi be a kanidina. Be tarawatu e riuriu da pirisi taudiḡa inam buredinama ta kanina be nam banaga ḡoma.” ");
INSERT INTO dww_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dabudine Yesu Parisi ya riuedina, “Banaga Natunama Sabat ewai badena.” ");
INSERT INTO dww_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat ḡesaune Yesu ya naḡona sinagog nopone be yawai katakataina. Be tauḡoma tenaḡa dabudine mate, tauna nimanama kasaunama tuera paḡopaḡonama. ");
INSERT INTO dww_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Be Parisi be tarawatu tauwai katakataidima maida a tava be keda a wanewanena da aiyabae be Yesu sibo ai wavuna. Vutuna aubainama taudi Yesu a kitakita watanina da tauna Sabat raḡanine banaga sibo yai yawasani bo ibewa, yodibe taudi sibo a samanina. ");
INSERT INTO dww_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Be Yesu tauna ya kataiena da taudi aba awai nuanoḡonoḡotena, be tauna tauḡoma nimanama tuera paḡopaḡonama ya riuena, “Kwa midisuḡu be patara noḡodie kwa midi!” Dabudi tauḡoma ya midisuḡu be ya midina. ");
INSERT INTO dww_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Be dabudine Yesu taudi ya riuedina, “Taugu taumi yài taraviremina, dà tarawatuma aba e riuriuedana tà voie Sabat raḡanine? Yaba veredima tà voiedi bo yaba gewegewedima tà voiedi, banaga tài yawasanidi bo tà kawa gewegewedi?” ");
INSERT INTO dww_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Be Yesu banaga matabudi ya kita vireviredi be tauḡoma patara noḡodie midimidinama ya riuena, “Nimamma kwai yoyo!” Be tauḡoma nama ya voiena be nimanama matabuna ya vere munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Be taudi nuedima yai medi kaua be adi banagama mate ai giuna da aba sibo a voiena Yesu ḡarone. ");
INSERT INTO dww_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Inam kauidima muridie raḡan ḡesaune Yesu ya saḡa ya naḡona oya debane moiragi aubainama, be Mamaitua ḡarone kupi ya moiragi raḡanina. ");
INSERT INTO dww_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Be raḡanboiboi tauna na tauwai muriwatanama ya riu gogonidi da ḡarone a tavana, be taudi nopodie tautauḡoma matabudi 12 ya vinedina. Be uma banegidima 12 tauna yai isedina ‘Apasol’. ");
INSERT INTO dww_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Umanama banegidima ya vinedina: Saemon (yai isana ‘Pita’) be tasinama Endru, be Jeims, Jon, Pilip, Batolomiu, ");
INSERT INTO dww_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Metiu, Tomas be Jeims (tauna Alpius natunama) be Saemon ḡesau tauna awai isana ‘Selot’, ");
INSERT INTO dww_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","be Judas (tauna Jeims natunama), be Judas Iskariot, tauna vutuna muriḡa Yesu ya boru dobiḡena. ");
INSERT INTO dww_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu na apasolma mate a yovoyovo munaḡana raḡanine, taudi dobu wapuwapune a midina, be tauwai muriwatana toitoi be banaga toitoi Judiaḡa be Jerusalemḡa a tavana, be Taia be Saidon geresinama banegidima mate ");
INSERT INTO dww_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","a tavana Yesu vaienama be adi sidama ei yawasanidina aubainama. Be banaga aitauḡa penama kokukokudima, taudi mate yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Be banaga matabudi a rarau rubuna da Yesu sibo a taukonina, baninama rewapana tauna ḡarone ya dobi be banaga matabudi yawai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu na tauwai muriwatanama ya kitedi be ya riuna, “Taumi nuemima e verena waikaruwaḡewaḡemima, baninama Mamaitua na waiguyauma inam taumi ḡaromima. ");
INSERT INTO dww_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Taumi nuemima e verena aitauḡa yodi kani ko gurigurina, baninama tokare ko kani siauana. Taumi nuemima e verena aitauḡa yodi ko ḡabaḡabana, baninama tokare ko kwatevana. ");
INSERT INTO dww_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Taumi nuemima e verena deḡoda banaga ta tuaḡaiemi, ta boru dobiḡemi, ta kunuremi be isemima ta kawa gewagewana, baninama Banaga Natunama kana taiye. ");
INSERT INTO dww_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Inam kauidima ta tubutubuḡana raḡanine, taumi koi nuavere be ko taukaina, baninama ami maesama dosinama marae e kenakenana. Be inam banegidima tametamedima boni nama peroveta ḡarodie a voivoiana. ");
INSERT INTO dww_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ko kita kauana taumi aitauḡa yodi kowai guyauna, baninama taumi ami nuasubama inam naumeki koya paḡona. ");
INSERT INTO dww_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Be taumi aitauḡa yodi ko kanikani siauana, ko kita kauana, baninama taumi tokare kani e karemina. Be aitauḡa yodi ko kwatekwatevana, ko kita kauana, baninama taumi tokare koi nuaboya be ko ḡabana. ");
INSERT INTO dww_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ko kita kauana deḡoda banaga matabudi taumi isemima ta kaikai suḡuna, baninama inam banegidima tametamedima nama boni peroveta kaikaiyovudima isedima a kaikai suḡusuḡudina. ");
INSERT INTO dww_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Be taumi aitauḡa ko vaivaieguna yà riuemina, ami ḡaviama nuemima e paḡona. Be aitauḡa ta tuatuaḡaiemina, ḡarodie vere ko voiena. ");
INSERT INTO dww_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aitauḡa tawai tara tautauemina, naumeki da koi aiainidina! Be aitauḡa ta raukivi gewegewemina aubaidima ko moiragina! ");
INSERT INTO dww_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Deḡoda aitau nevakaumma e riḡana, kwa gose da nevakaumma ḡesaunama mate e riḡa. Deḡoda aitau am rupuma e kaiporena, naumeki da am kwamama mate kwa utena! ");
INSERT INTO dww_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aitau aba yai baḡena, naumeki da kwa ute! Be aitau am waiyabama e paḡona, nam kwa riue be e ute munaḡem. ");
INSERT INTO dww_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Taumi aba ko ḡoeḡoena banaga ḡaromie sibo a voiena, taumi nama taudi ḡarodie ko voiena! ");
INSERT INTO dww_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Banaga ḡesaudima tawai nuapaḡoemina, be taumi deḡoda taudiḡa koi nuapaḡoedina, inam nam i verena, tokare nam maesa ko banavi, inam banaga gewegewedima nama adi voiama. ");
INSERT INTO dww_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Be banaga ḡesaudima vere ḡaromie ta voivoie, be taumi deḡoda taudiḡa vere ḡarodie ko voiena, inam nam i verena, tokare nam maesa ko banavi, inam banaga gewegewedima nama adi voiama. ");
INSERT INTO dww_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Be aitauḡa aba koya utedi be taumi ko noḡonoḡotina da tai ḡare munaḡemina, inam naumeki be tokare nam maesa ko banavi! Baninama inam kauinama teneḡinama nama gewagewa banegidima ta voivoiana. ");
INSERT INTO dww_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Be taumi ami ḡaviama sibo koyai nuapaḡoedina, be yaba verediḡa ḡarodie ko voiedina, be banaga yaba ko utedi be nam murine ko noḡonoḡoti da ta ute munaḡemi. Deḡoda nama ko voiana, tokare ami maesama dosinama ko paḡona, be taumi Mamaitua saḡasaḡa vavasaḡinama natunatunama ko tubuḡana. Baninama avedi da banaga kanikanitokudima be gewegewedima be Mamaitua yaḡoro e rarau kiviverena ḡarodie. ");
INSERT INTO dww_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Vutuna aubainama taumi ko raunuatoina maika tamemima marae e rarau nuatoina nama. ");
INSERT INTO dww_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nam turamma kwai wavu da tokare Mamaitua nam tam ei wavum. Be nam turamma kwai tara tautaue, da tam tokare Mamaitua nam ei tara tautauem. Ami banagama adi gewagewama ko noḡota poredina, be nama taumi tokare ami gewagewama Mamaitua e noḡota porena. ");
INSERT INTO dww_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ko pairu be Mamaitua e pairuemina. Tauna moḡamoḡavunama e utemina be e nuaḡiniḡinina. Vutuna aubainama ruva dosine ko rauruvana, baninama Mamaitua inam ruvanama teneḡine e ruvemina.” ");
INSERT INTO dww_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Be Yesu tauna uma wainasinama mate ya riuedina, “Tauḡoma matapotapotanama banaga ḡesau matapotapotanama nam ei doke. Deḡoda, rabuidi dome ta bekuna. ");
INSERT INTO dww_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tauwai muriwatana nam aitau e saḡa gurata da na tauwai katakataima ei muri, be raḡanine tauna ai katakatai be ya kovina, inam raḡanine tauna na tauwai katakataima maika e tubuḡana. ");
INSERT INTO dww_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Aba aubainama turamḡa matane vunavuna kwa kitakita, be tam matame kaitupo nam kuma kitakita? ");
INSERT INTO dww_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tam matame kaitupo nam kuma kitakitana, be nema turamma kwa riu bake be matane vunavuna kwa kaipore, wa? Tam banaga kaikaiyovumma! Noḡone tam matame kaitupo kwa kaipore da kwai kita kaua, yodibe turamma matane vunavuna kwa kaiporena. ");
INSERT INTO dww_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kai verenama votanama nam gewegewedi be kai gewagewanama votanama nam veredi. ");
INSERT INTO dww_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kai votane kwa kita be kwa kataie da inam kai verena bo kai gewagewana. Nam aitau tokare damaya votanama yaguru bogane e ragau. Be nam aitau tokare mabeko votanama gedara nopone e ragau. ");
INSERT INTO dww_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Inam kauinama teneḡinama nama banaga verenama, nuanama verenama aubainama, yaba veredima ewai tubuḡidina. Be banaga gewagewanama yaba gewegewediḡa ewai tubuḡidina. Baninama banegidima nopodima noḡota ya moḡavu da mududie ta giugiuna. ");
INSERT INTO dww_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Aba aubainama ko riuriueguna, ‘Bada, Bada’, be taugu yà riuriuemina ko vaivaiena be nam koma voivoie? ");
INSERT INTO dww_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Deḡoda aitau e verau be riuguma e vaie be e voivoiena, taugu yài kataimi da tauna umanama: ");
INSERT INTO dww_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tauna maika banaga na vadama e kerikerina. Tauna dom ya keri ya yovo gurata da yeku debane tuatua yai midirina. Be raḡanine kabaita ya dobi be upa vada ya kamoḡa rereḡe be vadanama nam i dagudaguna, baninama tuatua doḡa nopone a yovo guratana, yeku debane. ");
INSERT INTO dww_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Be aitau riuguma ya vaie be nam i voiena, tauna maika banaga na vadama e kerikerina, be tauna tuatua doḡa debane yai midirina. Be raḡanine kabaita vada ya kamokamoḡina, yai raḡantenaḡe da vada doḡae ya ravuse be ya gewagewana.” ");
INSERT INTO dww_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Raḡanine Yesu inam banegidima ḡarodie ya giugiu rovona, naumeki da tauna ya naḡona Kapeniamma. ");
INSERT INTO dww_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Dobudine Rom banegidima iḡeiḡeridima matabudi 100 be taudi adi torima matanama na taunoyama, nuanama taupaḡonama ya sida kauana, be ḡaubonaḡa sibo ya guri. ");
INSERT INTO dww_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Raḡanine Rom adi torima matanama Yesu varinama ya vaivaiena, dabudine tauna Jius babadidima ya riuporedina da taudi sibo Yesu ai baḡa da ya verau be na taunoyama sibo yai yawasanina. ");
INSERT INTO dww_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Be taudi Yesu ḡarone a tavatavana raḡanine, tauna ai baḡa gurate be a riuna, “Tori matanama sibo kuya saguna, tauna banaga vere kaukauinama, ");
INSERT INTO dww_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","baninama ama banagama nuedima e paḡopaḡona, be tauna taunaḡa dà sinagogma ya kerina.” ");
INSERT INTO dww_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Naumeki da Yesu taudi mate a naḡona. Yesu tauna kaiteka vada diane ya tavatava be Rom adi torima matanama na banagama ya riuporedi da Yesu sibo umanama a riuena, “Bada nakarua, nam aubaiguma kwa noya gurata, taugu nam veregu da yau vadae kwa saḡa. ");
INSERT INTO dww_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Be yau banagaḡa è riuporedina, baninama taugu nam veregu da tam ḡarome sibo è verau. Riuḡa kwa riu be yau taunoyama e yawasanana. ");
INSERT INTO dww_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Taugu è kataiena tam tokare riuḡa kwa riu be e tubuḡana, baninama taugu mate waibada dibune yà miamiana be ḡarogue banaga iḡeiḡeridima ta miamiana. Be raḡanine yau tauiḡarama tenaḡa yà riunena, ‘Kwa naḡo’, be tauna e naḡonaḡona. Be ḡesau yà riuena, ‘Kwa verau’, be tauna e veraverauna. Be yau taunoyama yà riuena, ‘Uma kwa voie’, be tauna e voivoiena.” ");
INSERT INTO dww_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Raḡanine Yesu nama ya vaivaiena, tauna Rom adi torima matanama ya basena, be dabudine yai tautinamuri da patara awai muriwatanena ya riuedina, “Yà riuriuemina da nam airaḡan Israelma aitau na waisumaḡama dosinama umanama maika deḡo e banavi rubuna.” ");
INSERT INTO dww_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dabudine tori matanama na banagama a munaḡana vadae, be a kita da taunoya ya yawasana munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Naumeki da Yesu ya mia raḡan ḡaubonaḡa be ya naḡona meagai isanama Nain, be na tauwai muriwatanama be patara dosinama mate a naḡona. ");
INSERT INTO dww_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Raḡanine taudi meagai kedanama matane a tavatavana, dabudine patara dosinama inam meagaine kaiyababa natunama tenaḡa ḡominama gurigurinama a kiroḡi be a dobina. ");
INSERT INTO dww_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Raḡanine Bada inam kaiyababa ya kitakitana, tauna ya raunuatoie be ya riuena, “Nam kwa ḡaba!” ");
INSERT INTO dww_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naumeki da Yesu maida ya tava da guri kebeninama ya taukonina, be guri taukiroḡinama dabudi a midina. Be Yesu ya riuna, “Yaraga, yà riuriuemna, kwa midisuḡu!” ");
INSERT INTO dww_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Inam raḡanine tauḡoma gurigurinama ya midisuḡu be giu yai karena. Be Yesu inam tauḡominama tinanama ya ute munaḡena. ");
INSERT INTO dww_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Be banaga matabudi a ḡosoridi be Mamaitua isanama a kaisuḡu be a riuna, “Peroveta dosinama poude ya maḡatarana be Mamaitua ya tavana sagudama aubainama.” ");
INSERT INTO dww_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Be Yesu varinama ya daberarana Judia provins nopone be dianama mate. ");
INSERT INTO dww_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon na tauwai muriwatanama inam yabedima matabudi a tubutubuḡana Jon ai varina. ");
INSERT INTO dww_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Be Jon na tauwai muriwatanama rabui ya riuedi da a tava ḡarone be ya riuporedina, da taudi Yesu sibo umanama ai taravirena, “Tam vutuna Keriso a riuriuemna kuya tava bo banaga ḡesau ka rabe?” ");
INSERT INTO dww_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Raḡanine Yesu ḡarone a tavana taudi a riuena, “Jon tauwai babataito ya riuporemaina da uma waitaraviranama tam kai taravirem, ‘Tam vutuna Keriso a riuriuemna kuya tava bo banaga ḡesau ka rabe?’” ");
INSERT INTO dww_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Inam raḡanine Yesu tauna banaga toitoi adi sidama dosidie da ḡauḡaubodie yai yawasanidi be penama banaga nopodie ya tavu dobiḡedina be banaga matapotepotedima ai kita munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Be Yesu Jon na tauwai muriwatanama ya paribeedina, “Ko munaḡa be aba koya kitakitana, be koya vaivaiena, vutuna Jon koi varina: Banaga matapotepotedima ai kitana, banaga tuera ragaragaudima a noḡona, banaga kito ragaragaudima a verena, banaga beapotepotedima ai beavaiana, banaga guriguridima a midisuḡu munaḡana, be vari verenama banaga waikaruwaḡewaḡedima ḡarodie yà rarau guguyedina. ");
INSERT INTO dww_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nuavere tauna aitau nam ḡarogue ima noḡonoḡota bekubekuna.” ");
INSERT INTO dww_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon na tauwai muriwatanama a naḡona, be muridie Yesu patara nopone Jon na kauama ya giuena, “Boni dobu kavakavane koya naḡona Jon ḡarone, be aiyaba koya noḡonoḡotina sibo koya kita? Banaga na noḡotama gwaḡanama maika vagara sive ya kwadikwadiena kitanama aubainama koya naḡo, bo? ");
INSERT INTO dww_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bo aiyaba koya noḡonoḡotina sibo koya kita? Banaga gara verenama kotekotenama sibo koya kita, bo? Ibewa, banaga gara veredima kotekotedima be purapura vereveredima ḡarodie, taudi guyau na vadae miemienidima. ");
INSERT INTO dww_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bo aiyaba koya noḡonoḡotina sibo koya kita, peroveta, bo? Ee, be yà riuriuemina, taumi peroveta dosinama koya kitana, nam maika peroveta ḡesaudima. ");
INSERT INTO dww_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Inam tauna vutuna girugiruminama porane umanama e riuriuna, ‘Taugu tauwai noyanoya yà riupore dokena muriḡa tam, be tauna am kedama e sepana.’ ");
INSERT INTO dww_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Be yà riuriuemina, Waiwaivi banaga a tiketikedina nopodie nam aitau Jon e saḡapore. Be kamai banabanaga Mamaitua na waiguyauma nopone, tauna vutuna Jon ya saḡaporena.” ");
INSERT INTO dww_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Be raḡanine banaga matabudi be teks tautaminama Jon na rauguguyama a vaivaiena, taudi matabudi a noḡotina da Mamaitua na giuma riukaua, vutuna aubainama Jon taudi yai babataitodina. ");
INSERT INTO dww_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Be Parisi be tarawatu tauwai katakataidima taudi Mamaitua na ḡoanama na kedama a tuaḡaiena, aubainama Jon na waibabataitoma a tuaḡaiena. ");
INSERT INTO dww_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Be Yesu yaḡoro ya giugiuna, “Yodi taumi kimtimima nema yài ruvaruva bakemi? Taumi aiyaba maika? ");
INSERT INTO dww_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Taumi maika seda debadebae tawai digirina. Be taudi adi banagama mate tawai riu sinḡaḡayana. ‘Tauma naḡi digirinama kèi digirie be taumi nam ko bigana, be tauma guri digirinama kèi digirie be taumi nam ko ḡabana.’ Taumi raḡan matabuna nama ko riuriu tuatuaḡaina. ");
INSERT INTO dww_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Be raḡanine Jon ya tavana, taumi kauinama teneḡinama koya voivoiena. Tauna ya widiwidina be waen nam i tegotegona, be taumi ko riuriuna, ‘Tauna penama ḡarone.’ ");
INSERT INTO dww_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Be Banaga Natunama ya tava da e kanikani be e tegotegona da taumi ko riuriuna, ‘Ko kita, tauna banaga kanikani dobidobinama be waen tegotego dobidobinama. Be teks tautamina be gewagewa tauvoiedima taudi tauna na banagama.’ ");
INSERT INTO dww_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mamaitua na nuauyauyama natunatunama ḡarodie, tokare tà kitana deḡo tauna riukaua. Banaga tauriu sinḡaḡayena, bo taugu be Jon.” ");
INSERT INTO dww_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisi tenaḡa Yesu ya kokonena na vadae kani aubainama. Naumeki da Yesu Parisi na vadae ya naḡo be ya kena girigirina kani aubainama. ");
INSERT INTO dww_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Be uma meagaine waivi na yawasanama gewagewanama ya miamiana. Be raḡanine Yesu Parisi na vadae a kanikanina, varinama tauna ya vaivaiena, naumeki da upa ḡabuḡabunama duginama maesinama dosinama ya kiroḡi verauḡena. ");
INSERT INTO dww_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Be tauna ma ḡabaḡabana Yesu kaḡanama diane ya midi be matasurune Yesu kaḡanama yai butedi, be debavuvuḡine Yesu kaḡanama ya ravusidina, be kaḡanama yai suruvedi be upa ḡabuḡabunama kaḡane ya ḡinina. ");
INSERT INTO dww_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Be Yesu taukokonenama uma kauinama nama ya kitakitana, tauna yai nuanoḡonoḡotana, “Deḡoda uma banaginama tauna riukaua peroveta, naumeki da tauna tokare sibo ya kataie da uma aba waivinama tauna e tautaukoni, be tauna sibo ya kataie da uma waivinama tauna waivi gewagewanama.” ");
INSERT INTO dww_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Be Yesu tauna ya riuena, “Saemon, taugu yà ḡoeḡoena aba yà riuemna.” Be tauna ya riuna, “Naumeki, tauwai katakatai, kwa giu!” ");
INSERT INTO dww_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Mane taupakinama tenaḡa banaga rabui loun ya utedina. Banaga tenaḡa Denari 500 be ḡesau tauna Denari 50. ");
INSERT INTO dww_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Be taudi rabuidi nam mane da mane taupakinama sibo a ute munaḡe, vutuna aubainama mane taupakinama taudi adi bukinma ya boaporena. Yodi tam kwa noḡonoḡotina deḡo tauna nuanama ya vere kaua?” ");
INSERT INTO dww_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Be Saemon ya paribeena, “Taugu è noḡotina agunai banaga aitau 500 Denari boaboaporenama.” Be Yesu ya riuna, “Tam kuya riukauana.” ");
INSERT INTO dww_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dabudine Yesu yai tautinamuri waivi ḡarone be Saemon ya riuena, “Uma waivinama kuya kita? Taugu am vadae è saḡa be nam upa ku utegu da kaḡaguma sibo è koḡana, dà vaivaima e riuriuna nama, be tauna matasurune kaḡaguma ya koḡedi be debavuvuḡine kaḡaguma ya ravusidina. ");
INSERT INTO dww_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tam nam kui suruveguna waikaiwa aubainama, dà vaivaima e riuriuna nama, be tauna raḡanine è saḡasaḡana kaḡaguma waisuruvenama yai kare be nam i gosena. ");
INSERT INTO dww_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tam nam debague oeri ku ḡinina, dà vaivaima e riuriuna nama, be tauna kaḡague upa ḡabuḡabunama ya ḡinina. ");
INSERT INTO dww_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Vutuna aubainama yà riuriuemna da tauna na gewagewama matabudi Mamaitua ya noḡota poredina. Vutuna aubainama taugu nuanama yà paḡopaḡo kauena. Be aitau da na gewagewama ḡaubonama Mamaitua ya noḡota porena, vutuna aubainama tauna na wainuapaḡoma ḡaubonama taugu ḡarogue.” ");
INSERT INTO dww_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dabudine Yesu waivi ya riuena, “Am gewagewama è noḡota poredina.” ");
INSERT INTO dww_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Be banaga ḡesaudima taudime ai taraviravira munaḡedi be a riuriuna, “Uma tauna aitau, banaga adi gewagewama e noḡonoḡota poredi?” ");
INSERT INTO dww_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Be Yesu waivi ya riuena, “Am waisumaḡama yai yawasanimna. Ma nuasubam kwa naḡona.” ");
INSERT INTO dww_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dabudine a miana raḡan bisanama be Yesu na apasolma 12 mate a naḡona meagai dosidie be ḡauḡaubodie da Mamaitua na waiguyauma riunama verenama ya rarau guguyena. ");
INSERT INTO dww_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Be Yesu waiwaivi ḡesaudima penama be sida ragaragaudima yai yawasanidina. Inam waiwaividima taudi mate Yesu ai muriwatane be a naḡonaḡona. Taudi isedima Meri awai isana Megdalin, penama matabudi 7 tauna a dobi porena, ");
INSERT INTO dww_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","be Joana, tauna Kusa na visarama, be tauna guyau Herod na bisnisma taurabenama, be Susana be waiwaivi ḡesaudima mate. Inam waiwaividima adi kanie be adi manee Yesu be na tauwai muriwatanama a sagusagudina. ");
INSERT INTO dww_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Raḡan tenaḡa patara dosinama meagai da meagai a verau be Yesu ḡarone ai rawateḡeidina, be tauna uma wainasinama ya riuedina, ");
INSERT INTO dww_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tauḡoma tenaḡa ya dobi ya naḡo da pesi yai yaraiedina. Raḡanine pesi yawai yaraiedina, ḡesaudima keda poune a ravusedina, be banaga a vagudegudedi be kiu a kanidina. ");
INSERT INTO dww_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Be ḡesaudima yeku debedie a ravusedina. Be raḡanine a gogo tavana, matabudi a pokina, baninama doḡa noponama nam subasubana. ");
INSERT INTO dww_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Be ḡesaudima gedara nopodie a ravusedi da gedara mate a gogo tenaḡana be gedara pesi ya yavanidi da pesi nam ti gogona. ");
INSERT INTO dww_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Be ḡesaudima doḡa verenama debane a ravusedi be a gogo kauana be banidima a biridina ya toi kauana, be pesi tenaḡaḡa banidima 100.” Be Yesu bonanama dosine ya riuna, “Deḡoda beemima ta kenakenana, koi beavaia!” ");
INSERT INTO dww_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Be tauwai muriwatana Yesu ai taravirena, “Bada, inam wainasinama baninama aba?” ");
INSERT INTO dww_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Be tauna ya paribeedi be ya riuna, “Mamaitua na waiguyauma semosemodima yàwai kataimina da na waiguyauma yodi nema e veraverau bakona ko kataiena. Be banaga ḡesaudima taudi wainasi taunaḡa ta vaivaiena, aubainama taudi matedie ta kitakitana be nam tima kitakita kauena, ta vaivaiena be nam tima katakataiena. ");
INSERT INTO dww_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Be wainasi baninama inam umanama: Pesi inam Mamaitua riunama. ");
INSERT INTO dww_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pesi keda debane ravuravusedima, inam maika banaga Mamaitua riunama ta vaivaiena, be muriḡa Diaboro e tava be Mamaitua riunama nopodie e kaikaiporaḡana, da taudi nam tai sumaḡa be ta yawasana. ");
INSERT INTO dww_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pesi yeku debane ravuravusedima, inam maika banaga raḡanine Mamaitua riunama ta vaivaiena, taudi ma nuavereveredi inam riunama ta paḡopaḡona. Be taudi nam waramidi, vutuna aubainama raḡan ḡaubonaḡa tai sumaḡana, be raḡanine raurubu e tavatavana taudi adi waisumaḡe ta bekuna. ");
INSERT INTO dww_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Be pesi gedara nopodie ravuravusedima, inam maika banaga Mamaitua riunama ta vaivaiena, be muriḡa nuaboya be waiguyau be tubuḡa na wainuaverema adi waisumaḡama ta yavayavanidina da taudi tokare nam ta bani. ");
INSERT INTO dww_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Be pesi doḡa verenama debane ravuravusedima, inam maika banaga nopodima veredima be didimanidima, be raḡanine taudi giu ta vaivaiena, taudi ta kaididi be ta rabe da e votavotana.” ");
INSERT INTO dww_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nam aitau kodam e gabu be e ruputawa bo anikaba kena dibune e boru. Tauna kodam ḡavoe ei midiri da banaga ta saḡasaḡana ta kitana. ");
INSERT INTO dww_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Deḡoda yaba matabuna yodi ko ruputawedina, be tokare ta maḡatara munaḡana. Am noḡota be am kauama semosemodima mate tokare banaga matabudi ta kataiedina. ");
INSERT INTO dww_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Vutuna aubainama koi beavaia kauana, baninama deḡoda aitau yau giuma ya paḡopaḡona, ḡesau debane mate tokare e utena. Be deḡoda aitau yau giuma nam i paḡona be e noḡonoḡotina da ya paḡona, be ibewa da tokare matabudi e kaiporaḡana.” ");
INSERT INTO dww_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu tinanama be tasitasinama taudi a verauna Yesu ḡarone be nam ḡarone ti tavana, baninama patara ya morabana. ");
INSERT INTO dww_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dabudine banaga tenaḡa Yesu ya riuena, “Tinamma be tasitasimma doḡae ta midimidi be ta ḡoeḡoena da ta kitamna.” ");
INSERT INTO dww_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Be Yesu ya riuna, “Tinaguma be tasitasiguma taudi aitauḡa Mamaitua riunama ta vaivaie be ta voivoiena.” ");
INSERT INTO dww_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Raḡan tenaḡa Yesu na tauwai muriwatanama mate wagae a saḡa be ya riuedina, “Yawawa dosinama tà davu be tà naḡo noaḡo nevane.” Naumeki da a naḡona. ");
INSERT INTO dww_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Taudi yawawa a davudavuna maika Yesu ya kenana, be kaibitibiti yai raḡantenaḡe da ya tavana be waga noponama upa ya moḡavu be waga ḡaubonaḡa da sibo ya monuna. ");
INSERT INTO dww_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Be tauwai muriwatana a naḡo be Yesu a taiḡosori be a riuena, “Bada, Bada ḡaubonaḡa da tà gurina!” Be tauna ya midisuḡu be sive be rabama ya riutuaḡaiedi, da taudi ai nuatuḡutuḡu be daumora ya kenana. ");
INSERT INTO dww_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Be Yesu na tauwai muriwatanama ya riuedina, “Taumi ami waisumaḡa bo ibewa?” Be taudi a ḡosoridi be a basena be adi banagama adi banagama a riuedina, “Uma baneginama aitau? Tauna sive be upa e riuedi be ta vovo teyeteyena.” ");
INSERT INTO dww_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Be taudi wagae a naḡona Geresin adi dobue. Umaḡo Galili provins be noaḡo nevane. ");
INSERT INTO dww_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Be Yesu kaḡanama gerese ya boruboru dobiḡena raḡanine, meagaie tauḡoma tenaḡa ya verauna Yesu ḡarone. Be tauḡominama penama bonideḡo a kokuna, be tauna ma kovakovana ya naḡonaḡona be nam vadae i miamiana. Be tauna guri adi gubae ya miamiana. ");
INSERT INTO dww_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Be inam tauḡoma Yesu ya kitakitana raḡanine, tauna ya yogo be Yesu noḡone ya bekuna. Dabudine Yesu penama ya riue da tauḡoma ya dobi porena. Be tauna bonanama dosine ya riuna, “Yesu, Mamaitua saḡasaḡa vavasaḡinama Natunama, aba ḡarogue kwa ḡoeḡoe? Yàwai baḡamna da nam gewagewa ḡarogue kwa voie.” Raḡan toitoi penama tauḡoma yai babari be na ḡoane nama ya nawenawena. Be banaga tauna nimanama be kaḡanama a rauseini be a raberabena. Be yaḡoro tauna ya rakedi be penama tauḡoma ya nawena dobu wainuatoitoine. ");
INSERT INTO dww_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu yai taravirena, “Tam isamma nema?” Be tauna ya paribeena, “Taugu isaguma Patara”, baninama penama toitoi nopone a saḡana. ");
INSERT INTO dww_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Be penama awai baḡana da Yesu nam taudi sibo ya riuedi da dom nam dibuboruborune sibo a naḡo. ");
INSERT INTO dww_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Inam dabudine bawa netarinama oya babane a yabayabana. Be penama Yesu ai baḡa da tauna sibo yai aninedi da bawa nopodie sibo a naḡona. Be Yesu yai aininedina. ");
INSERT INTO dww_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dabudine penama banaga a dobi pore be bawa nopodie a naḡona da bawa netarinama dere boganaḡa a manini yovo da a naḡona yawawa dosine be a tonedina. ");
INSERT INTO dww_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bawa tauyosidima inam kauinama nama a kitakitana, taudi a manini a naḡona. Be taudi banaga matabudi ai varidina adi meagaie be meagai diane mate. ");
INSERT INTO dww_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dabudine banaga a dobi a naḡo da kaua aba ya tubutubuḡana sibo a kitana. Be raḡanine Yesu ḡarone a tavatavana, taudi tauḡoma penama dobidobi porenama Yesu kaḡane ya miamiana a kitana. Be tauḡoma yai gara kaua be na noḡotama verene ya miamiana, be taudi nama a kitakitana a nairana. ");
INSERT INTO dww_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Be banaga aitauḡa kauinama a kitakitana, taudi banaga ḡesaudima ai varidina da tauḡoma penama kokukokunama ya yawasana munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dabudine Geresin banegidima Yesu ai baḡana da tauna sibo inam dobunama ya gose be ya naḡo poredina, baninama taudi a naira da a naira kauana. Naumeki da Yesu waga nopone ya saḡa be ya munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tauḡoma penama dobidobi porenama Yesu yawai baḡana da mate sibo a naḡona. Be Yesu ya riupore be umanama ya riuena, ");
INSERT INTO dww_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kwa munaḡa am vadae da Mamaitua aba ḡarome ya voivoiena banaga kwai varidina!” Dabudine tauḡoma ya naḡo be meagai nopone banaga matabudi ya riuedina da Yesu aba tauna ḡarone ya voiena. ");
INSERT INTO dww_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Be Yesu ya tavatava munaḡana raḡanine, banaga patara tauna ai kaiwena, baninama taudi matabudi tauna a raberabena. ");
INSERT INTO dww_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dabudine tauḡoma isanama Jaeras, tauna sinagog taurabenama. Tauna ya tava be Yesu noḡone tuapikane ya raupari be yai baḡa guratena da sibo na vadae ya saḡana, ");
INSERT INTO dww_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","baninama natunama waivinama tenaḡa ḡominama na suarama 12 be tauna ḡaubonaḡa da e gurina. Be Yesu ya naḡonaḡona raḡanine, patara tauna a midimidi ḡuruḡuruvina. ");
INSERT INTO dww_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Dabudine waivi tenaḡa Yesu murine ya tava be na garama isunama ya taukonina, baninama tauna waikosina vutuvutu ya paḡona modi 12 a kovina. Be tauna bonika na purapurama matabudi dogeta ḡarodie yawai yakaredina, be nam aitau i yawasanina. Be raḡanine Yesu na garama isunama ya tautaukonina, yai raḡantenaḡe da waikosina vutuvutu yai kavena. ");
INSERT INTO dww_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dabudine Yesu yai taravirana, “Aitau ya taukonigu?” Be matabudi a bovina, vutuna aubainama Pita ya riuna, “Bada, banaga a midi ḡuruvim be ta biubiu suriḡimna. Be nemanama da kwa riuriuna ‘Aitau ya taukonigu?’” ");
INSERT INTO dww_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Be Yesu ya riuna, “Taugu è kataiena da aitau ya taukoniguna, baninama rewapana ya dobi poreguna.” ");
INSERT INTO dww_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Raḡanine waivi mayanama ya paḡo da nam teneteneḡina da sibo yai moisiri, vutuna aubainama tauna ma tunigusugusuna Yesu noḡone ya bekuna. Be patara noḡodie waivi Yesu ya riuena da aba aubainama Yesu ya taukoni, yodi tauna ya yawasana munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Be Yesu tauna ya riuena, “Moumou, am waisumaḡama yai yawasanimna. Ma nuasubam kwa naḡona.” ");
INSERT INTO dww_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu yaḡoro ya giugiu be sinagog taurabenama na vadae banaga miemieninama ya tava da Jaeras ya riuena, “Natumma ya gurina, tauwai katakatai nam kwai sinasina.” ");
INSERT INTO dww_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Be Yesu nama ya vaivaiena, tauna Jaeras ya riuena, “Nam kwai nuaboya, kwai sumaḡa be tauna tokare e yawasanana.” ");
INSERT INTO dww_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Be taudi Jaeras na vadae a tavana raḡanine, Yesu banaga ya riuedina da nam aitau tauna mate vadae ta saḡa. Pita, Jon, Jeims be gomana na dosima taudiḡa Yesu mate vadae a saḡana. ");
INSERT INTO dww_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Be banaga matabudi gomana ai nuaboye be a ḡabeḡabena. Be Yesu ya riuedina, “Nam ko ḡaba, tauna nam i gurina, e kenakena ḡomana.” ");
INSERT INTO dww_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dabudine banaga matabudi Yesu ai kwatekwatevena, baninama taudi a kataie da gomana ya gurina. ");
INSERT INTO dww_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Raḡanine ya tavutavu dobiḡedina, tauna gomana nimane ya kaididi be ya riuna, “Gomana, kwa midisuḡu!” ");
INSERT INTO dww_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dabudine gomana aruinama ya tava munaḡa be ya midisuḡuna. Be Yesu taudi ya riuedina, “Yodi kani ko ute be e kani!” ");
INSERT INTO dww_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Be tauna na dosima nuedima ya mosari kauana. Be aba ya tubutubuḡana Yesu taudi ya riuedina da nam aitau sibo a riue. ");
INSERT INTO dww_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu apasol 12 ya riuedi da a rawateḡeidi be tauna rewapana be waibada ya utedina, da taudi penama ta tavu dobiḡedi be banaga sidesidedima tai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yodibe ya riuporedina da taudi Mamaitua na waiguyauma ta rauguguye, be banaga sidesidedima tai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Be tauna ya riuedina, “Ami naḡoe nam aba ko paḡo. Nam diḡona, nam tana, nam kani, nam mane be nam kwama ḡesaunama mate ko paḡo. ");
INSERT INTO dww_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Be raḡanine ai meagaie ko saḡasaḡana taumi vada tenaḡa nopone ko miana, naumeki da ami kaba naḡoma raḡanine inam meagainama ko gosena. ");
INSERT INTO dww_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Be deḡoda banaga taumi nam tai aninemi, naumeki da kaḡemima popokaudima ko rawakurukuruvidi be inam meagainama ko goseporena. Dabudine taudi ta kataie da taudi tokare Mamaitua matane inam wavunama taudime ta paḡo munaḡena.” ");
INSERT INTO dww_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Naumeki da tauwai muriwatana meagai da meagai nopodiḡa a naḡo be vari verenama a rarau guguye, be banaga dobu matabuna awai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Inam raḡanine Herod, tauna Galili provins guyaunama, be uma kauidima nama a tubutubuḡana, tauna ya vaiedi be ya nuababaḡana, baninama banaga ḡesaudima a riuriuna da Jon tauwai babataito ya guri be ya midisuḡu munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Be banaga ḡesaudima a riuriuna da peroveta Elaija ya maḡatara munaḡana, be banaga ḡesaudima a riuriuna da bonideḡo perovetedima tenaḡa ya guri be ya midisuḡu munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Be Herod ya riuna, “Jon gadonama è tomna, be inam yodi aitau baneginama varinama yà vaivaie?” Be tauna ya ḡoeḡoena da sibo Yesu ya kitana. ");
INSERT INTO dww_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Be apasol a tavatava munaḡana raḡanine, taudi yaba matabuna a voivoiedina Yesu ai varina. Tauna wainuatuḡune yai dokedi be a naḡona meagai isanama Betsaidama. ");
INSERT INTO dww_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Raḡanine patara nama a vaivaiena taudi ai muriwatanedina. Be Yesu taudi yai aninedina, be Mamaitua na waiguyauma taudi ya giuedina, be aitauḡa yawasana a ḡoeḡoena naumeki da yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Raviravi Yesu na apasolma 12 a tava be a riuena, “Banaga kwa riuporaḡa da ta naḡo meagaiḡa be meagai murisairine da taudi kani be ḡaravu ta banavidina, baninama uma dobunama wainuatoitoinama.” ");
INSERT INTO dww_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Be Yesu ya riuedina, “Taumi koi kanidi!” Be taudi a paribeena, “Nema kai kani bakedi? Tauma buredi 5 kavakava be iyana rabui ḡaromaie, bo nema kwa noḡonoḡota bake? Tauma ka naḡo be kani ka gimara uma banegidima aubaidima, bo?” ");
INSERT INTO dww_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dabudine tautauḡoma a kitaruvedi da 5 tausand. Be Yesu na tauwai muriwatanama ya riuedina, “Banaga ko dariḡedi da 50 50 ta miana.” ");
INSERT INTO dww_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Naumeki da taudi nama a voia be banaga matabudi a miana. ");
INSERT INTO dww_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu buredi 5 be iyana rabui ya ragaudi da gunume yai kitasaḡa be Mamaitua yai kaiwe da ya givedi be na tauwai muriwatanama ya utedina, be taudi a soiedi da banaga a utedina. ");
INSERT INTO dww_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Be banaga matabudi a kani da a kani siauana. Be tauwai muriwatana kani kanikanigosedima a tama da posa 12 ai moḡavudina. ");
INSERT INTO dww_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Raḡan tenaḡa Yesu taunaḡa ya moimoiragi be na tauwai muriwatanama taudi tauna mate. Be tauna taudi yai taraviredina, “Banaga ta riuriu da taugu aitau?” ");
INSERT INTO dww_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Be taudi a paribeena, “Banaga ḡesaudima ta riuriuna da tam kabe Jon tauwai babataito, be ḡesaudima ta riuriuna da tam kabe peroveta Elaija, be banaga ḡesaudima ta riuriuna da tam bonideḡo perovetedima guriguridima tenaḡa kabe i midimidisuḡu munaḡa.” ");
INSERT INTO dww_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Be tauna ya riuedina, “Be taumi nema kowai noḡota bako, taugu aitau?” Be Pita ya paribeena, “Tam Tauwai yawasana, Mamaitua ya riupore yovoḡemna.” ");
INSERT INTO dww_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dabudine Yesu na tauwai muriwatanama ya riu vavasaḡedina da nam aitau sibo a riue. ");
INSERT INTO dww_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Be ya riuna, “Banaga Natunama tokare ei nuatoitoina yaba toitoi ḡarodie be babada dosidima be pirisi adi babadama be tarawatu tauwai katakataidima, taudi matabudi Banaga Natunama tokare ta tuaḡaie be tai gurina. Be raḡan wairabuiteḡane Mamaitua e kawa midisuḡu munaḡena.” ");
INSERT INTO dww_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Be Yesu banaga matabudi ya riuedina, “Deḡoda aitau waimuriwataneguma e ḡoena, naumeki da na ḡoanama matabudi e gosedi, be raḡan matabuna na korosima e kiroḡi be ei muriwataneguna. ");
INSERT INTO dww_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tam aitau tame am yawasanama kwa kaididi be kwa raberabena, tam tokare am yawasanama kwa kawa gewagewana, be tam aitau da taugu kautaiye am yawasanama kuyai utaena, am yawasanama tokare kwa banavina. ");
INSERT INTO dww_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Deḡoda aitau dobu yabedima matabudi e ragaragaudina be yaḡoro tauna na yawasanama e gewagewana, inam yabedima tauna tokare nam tai yawasani. ");
INSERT INTO dww_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Deḡoda aitau, taugu e tunimayaḡegu bo riuguma e tunimayaḡena, naumeki da tokare Banaga Natunama tauna Tamanama neneḡarine be anea babau neneḡaridie e dobina, tauna mate inam baneginama e tunimayaḡena. ");
INSERT INTO dww_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Be taugu riukaua yà riuriuemina, ḡesaumima yodi uma ko midimidina, taumi tokare nam ko guri, naumeki da Mamaitua na waiguyauma ko kitana.” ");
INSERT INTO dww_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Naumeki da inam giudima a kovikovina murine, raḡan aniwai 8 ne Yesu tauna Pita, Jon be Jeims yai dokedi be a naḡona oya debane moiragi aubainama. ");
INSERT INTO dww_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Be Yesu ya moimoiragina maika, tauna noḡonama kitanama ya boru vitare be na garama ya ḡavora be ya rawakeyekeyemina. ");
INSERT INTO dww_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Yai raḡantenaḡe da tautauḡoma rabui, Mousis be Elaija ma neneḡaridi a maḡatara be Yesu mate a giugiuna. Taudi Yesu nema Jerusalemma e guri bako be uma dobunama e naḡo porena, vutuna a giugiuena. ");
INSERT INTO dww_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Be Pita na banagama mate a yadoyadona. Be a ḡosoḡosoridina raḡanine, taudi Yesu ma neneḡarina be tautauḡoma rabui, tauna mate a midimidina a kitekitedina. ");
INSERT INTO dww_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Be raḡanine tautauḡomidima Yesu a gosegosena, dabudine Pita ya riuna, “Bada, ya vere kauana da tauma yodi uma dobudine. Agunai kape rabuiteḡa ka keridina, tenaḡa tam aubaimma be tenaḡa Mousis aubainama be tenaḡa Elaija aubainama.” Be Pita tauna nam i kataiena aba ya giugiuena, be tauna ya giugiu yabayababana. ");
INSERT INTO dww_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Be Pita yaḡoro ya giugiuna maika, giyou ya dobi da vagurune ya rupu tawedina. Be raḡanine giyou ya sumasuma tawedina, taudi a naira kauana, ");
INSERT INTO dww_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","be giyou nopone bona ya dobi be ya riuna, “Uma tauna taugu natuguma be taugu è vinena, aubainama tauna bonanama ko vaiena!” ");
INSERT INTO dww_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bona yaḡoro ya giugiuna maika, taudi ta kitana be Yesu taunaḡa ya midimidina. Be tauwai muriwatana inam raḡanine aba taudi a kitakitana, a nuevina be nam aitau ti riuedina. ");
INSERT INTO dww_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pomainama taudi oya debane be a yovoyovo munaḡana raḡanine, patara dosinama taudi ḡarodie a tavana. ");
INSERT INTO dww_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Patara nopodie tauḡoma tenaḡa tauna ya rasa be ya riuna, “Tauwai katakatai, yàwai baḡamna da yau gomanama uma kwa kita, taugu natuguma tauḡominama tenaḡa ḡominama. ");
INSERT INTO dww_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Penama kana raḡanie yau gomanama e vunuḡi be e kawakawa rasarasa be e kawakawa kokerina, be tauna gayane kasampuropuro ta dobidobina. Inam peneminama natuguma nam airaḡan ima gosegosena, be natuguma tuninama e kawakawa gewagewana. ");
INSERT INTO dww_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Be taugu am tauwai muriwatanama èi baḡedina da taudi sibo penama a tavu dobiḡena, taudi a raurubu be nam teneteneḡina.” ");
INSERT INTO dww_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Be Yesu ya paribeena, “Taumi banegimima beapotepotemima, nam waisumeḡimi, taumi mate tà mia ḡaḡa be ami vitama yà kiroḡa ḡaḡae? Natumma kwa verauḡe uma dabudine!” ");
INSERT INTO dww_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Be gomana ya veraverauna raḡanine, penama tauna yai beku doḡae be ya kawa kokerina. Dabudine Yesu penama ya riutuaḡaie be gomana yai yawasanina, yodibe tamanama ya ute munaḡena. ");
INSERT INTO dww_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Be banaga matabudi Mamaitua na rewapanama dosinama aubainama a basena. Yesu yaba matabuna ya voivoiedina banaga yaḡoro a basebasena maika, Yesu na tauwai muriwatanama ya riuedina, ");
INSERT INTO dww_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Koi beavaia kaua da aba yodi yà riuemina. Banaga Natunama ta boru dobiḡena banaga nimedie raukivigewegewenama aubainama.” ");
INSERT INTO dww_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Be na tauwai muriwatanama inam giunama, baninama nam ti kataiena. Giu baninama semosemonama da taudi nam sibo a kataie. Be inam giunama aubainama taudi Yesu sibo ai taravirena, be a nairana. ");
INSERT INTO dww_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Raḡan tenaḡa Yesu na tauwai muriwatanama ai saḡasaḡana da poudie aitau ya saḡa gurata. ");
INSERT INTO dww_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Be Yesu adi wainua noḡonoḡotama ya kataiena, vutuna aubainama gomana ḡaubonama ya riue da diane ya midi ");
INSERT INTO dww_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","be taudi ya riuedina, “Aitau uma gomeninama ḡaubonama taugu isague ewai turanena, naumeki da tauna ewai turaneguna, be aitau taugu ewai turaneguna, naumeki da tauna tauriuporeguma mate ewai turanena. Vutuna aubainama aitau taumi poumie na yawasanama ya yovona, tauna ya saḡa guratana.” ");
INSERT INTO dww_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Be Jon ya riuna, “Bada, tauma tauḡoma kè kitana, tauna isame penama ya tavutavu dobiḡedina, be tauma kè riutuaḡaiena, baninama tauna nam tauda mate tama noyanoya tenaḡana.” ");
INSERT INTO dww_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Be Yesu ya riuna, “Nam ko riutuaḡaie, baninama tauna deḡoda taumi nam ami ḡavia, naumeki da tauna taumi turemima.” ");
INSERT INTO dww_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Naumeki da Yesu na raḡanima maida ya tavatavana da tauna sibo ya munaḡana marae, vutuna aubainama na noḡotama ya vitare da Jerusalem naḡonama ya noḡota didina. ");
INSERT INTO dww_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Be tauna tauwai noyanoya ya riupore dokedina, da taudi a naḡona Samaria meagaine da Yesu na kaba verauma aubainama sibo a vokaukauana. ");
INSERT INTO dww_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Be banaga dabudine nam ti aninena, baninama tauna ya naḡonaḡona Jerusalemma. ");
INSERT INTO dww_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Be raḡanine na tauwai muriwatanama Jeims be Jon nama a kitakitana, taudi a riuna, “Bada, naumeki bo ibewa da tauma sibo kai marae kè riue be ya yovo da uma banegidima sibo ya kara gorudi, Elaija ya voiana maika?” ");
INSERT INTO dww_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Be Yesu yai tauvitara be ya riutuaḡaiedina. ");
INSERT INTO dww_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Naumeki da taudi a naḡona meagai ḡesaune. ");
INSERT INTO dww_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Raḡanine taudi kedaḡa a naḡonaḡona, be tauḡoma tenaḡa Yesu ya riuena, “Tam deḡo kwa naḡona, taugu yài muriwatanemna.” ");
INSERT INTO dww_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Be Yesu ya paribee be ya riuna, “Inam naumeki be uma kwa noḡoti, kiudobo taudi adi gaure adi kaba miama, be kiu adi noḡie adi kaba miama, be Banaga Natunama nam deḡo na gabu kaua da tauna e sipere.” ");
INSERT INTO dww_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Be Yesu tauḡoma ḡesaunama ya riuena, “Kwai muriwatanegu!” Be tauna ya riuna, “Bada, noḡone kwa gosegu da yà naḡo be tamaguma yà dobona.” ");
INSERT INTO dww_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Be Yesu ya paribeena, “Banaga guriguridima kwa gosedi da taudiḡa adi gurima ta dobo munaḡedina, be tam kwa naḡo be Mamaitua na waiguyauma e veraverauna, vutuna kwa rauguguyena!” ");
INSERT INTO dww_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Be banaga ḡesau Yesu ya riuena, “Bada, taugu yài muriwatanemna, be noḡone kwa gosegu da yà naḡo be yau dosima yài kaiwedina.” ");
INSERT INTO dww_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Be Yesu ya riuena, “Deḡoda aitau yabiyabi e paḡopaḡo be ei tautinamurina, tauna nam teneteneḡina da Mamaitua na waiguyauma nopone e noya.” ");
INSERT INTO dww_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Uma kauinama murine Bada banaga ḡesaudima matabudi 72 ya vinedina, be tauna deḡo meagaidiḡa naḡonama ya noḡonoḡotina, nama inam banegidima ma turana ma turana ya riupore nawe dokedina inam meagaidiḡa. ");
INSERT INTO dww_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Be tauna umanama ya riuedina, “Sipi taupakinama koi baḡa da tauna taunoya ḡesaudima e riuporaḡa da taumi ta sagumina, baninama inam dabudine maura ya morabana be taunoya a raubisaḡana. ");
INSERT INTO dww_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Naumeki, ko naḡo! Taugu yà riuriuporemina sipu natunatudima maika musara ḡasiḡasidima nopodie. ");
INSERT INTO dww_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nam pausi ko ragau, nam tana, nam kaḡasuma ḡesaudima mate, be nam kedae banaga mate koi boruboru! ");
INSERT INTO dww_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Raḡanine vada nopone ko saḡana, noḡone ko riuna, ‘Suba uma vadane.’ ");
INSERT INTO dww_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Be deḡoda inam dabudine suba baneginama e mianana, naumeki da ami subama tauna ḡarone e kena, be deḡoda tauna nam suba banegina, naumeki da ami subama e verau munaḡana ḡaromie. ");
INSERT INTO dww_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Raḡanine deḡo meagaine koya tava be deḡo vadane koya saḡana, naumeki da vadane ko miana, be dabudi ko kani be ko tego gogonana, baninama taunoya sibo adi maesama a paḡo. Be taumi nam koi vadasaḡa! ");
INSERT INTO dww_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Taumi deḡo meagaie ko tava be banegidima tai aninemina, naumeki da aba ta uteutemina, vutudiḡa ko kanina! ");
INSERT INTO dww_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Be banaga sidesidedima koi yawasanidi be ko riuedina da Mamaitua na waiguyauma raḡaninama e tavatavana. ");
INSERT INTO dww_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Be taumi deḡo meagaine ko tava, be inam meagainama banegidima nam tai aninemi, naumeki da ko naḡo kedae be ko riuna, ");
INSERT INTO dww_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Tauma ami meagaima popokaunama kaḡamaima ya patipatina ḡaromie ka vava yasayasaina, be ko noḡoti da taumi tokare nam ko yawasana, baninama Mamaitua na waiguyauma raḡaninama ya tavatava be taumi koya tuaḡaiena.’ ");
INSERT INTO dww_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Taugu yà riuriuemi da etara raḡanine Mamaitua inam meagainama e kovoḡa guratena, nam maika Sodom. ");
INSERT INTO dww_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasin be Betsaida meagaimima, ko kita kaua! Baninama deḡoda taugu sibo meagai Taiya be Saidon nopodie voia dosidima sibo è voiedina maika taumi ḡaromie è voiedina nama, naumeki da taudi bonika sibo noḡota viravira a paḡo, be adi gewagewama nuaboyanama a mogurena. ");
INSERT INTO dww_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Etara raḡanine Mamaitua taumi e kovoḡa guratemina, nam maika Taiya be Saidon. ");
INSERT INTO dww_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Be taumi Kapeniam banagimima, kowai noḡotana tokare ko naḡo marae, bo? Ibewa, Mamaitua taumi tokare banaga guriguridima adi gabue e kidipore nawemina.” ");
INSERT INTO dww_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Be Yesu na tauwai muriwatanama umanama ya riuedina, “Aitau da taumi ami giuma e vaivaiena, naumeki da tauna taugu yau giuma e vaivaiena. Be aitau da e tuatuaḡaiemina, naumeki da tauna taugu e tuatuaḡaieguna, be aitau da taugu e tuatuaḡaieguna, naumeki da tauna tauriuporeguma e tuatuaḡaiena.” ");
INSERT INTO dww_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Be raḡanine banegidima taudi 72 a tavatava munaḡana, taudi ai nuavere kaua be a riuna, “Bada, tam isame penama mate tauma a voteyeteyemaina.” ");
INSERT INTO dww_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Be Yesu ya riuedina, “Taugu Seitan è kitana marae ya beku be ya yovona maika keama. ");
INSERT INTO dww_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Taugu rewapana è utemina da ḡavia na rewapanama matabuna ko vaisubana, be mota be rikarikau debedie koi vutuḡa be ko vamutudina. Be nam aba tokare e kawa gewegewemi. ");
INSERT INTO dww_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Be nam penama ta vovo teyeteyemina aubainama koi nuavere, avedi. Be taumi koi nuaverena, baninama isemima marae girugirumidima ta kenakenana aubainama.” ");
INSERT INTO dww_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Inam raḡanine Yesu noponama Arua Babaue nuavere ya moḡavu be ya riuna, “Mamai, tam mara be dobu Badanama, yà kaisuḡumna, baninama uma kauidima kuya semodina da nuauyauya be katai banegidima ḡarodie nam kui maḡataridina. Be tam banaga koekoedima ḡarodie kuyai maḡataridina. Mamai, inam naumeki, tam am ḡoanama ruvane.” ");
INSERT INTO dww_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tamaguma yaba matabuna taugu ya uteguna. Be nam aitau i kataiena da Natunama aitau, Tamanama taunaḡa ya kataiena. Be nam aitau i kataiena da Tamanama aitau, Natunama taunaḡa ya kataiena, be Natunama aitauḡa ya vinevinedina ḡarodie ewai maḡataridina da tauna Tamanama aitau.” ");
INSERT INTO dww_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Be Yesu na tauwai muriwatanama ḡarodie yai tauvitare be taudiḡa ya riuedina, “Taumi uma kauinama koya kitakitana, nama banaga ta kitana, naumeki da nuedima e verena, ");
INSERT INTO dww_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","baninama boni peroveta toitoi be guyaguyau a ḡoeḡoena da sibo uma kauinama a kitana, maika taumi yodi ko kitakitana nama, be nam ti kitana. Taudi a ḡoeḡoena da sibo uma giunama a vaiena, maika taumi yodi ko vaivaiena nama, be nam ti vaiena.” ");
INSERT INTO dww_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Raḡan tenaḡa tarawatu tauwai katakatainama ya verau da Yesu ya raurubu be ya riuna, “Tauwai katakatai, aba yà voie be yawasana kenakena nonoḡinama yà paḡo?” ");
INSERT INTO dww_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu ya riuena, “Tarawatu nema e riuriu bako? Tam nema kwa katakatai bake?” ");
INSERT INTO dww_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Be tauḡoma ya paribeena, “Bada, am Mamaituama nuanuamma e paḡona, nuanuamma tabutabune, aruimma tabutabune, am noḡotama tabutabune be am rewapanama tabutabune. Be turamma nuanuamma e paḡona maika nema tam kwa ḡoeḡoe munaḡemna nama.” ");
INSERT INTO dww_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ya riuena, “Tam kuya riu kauana, inam vutuna raḡan matabuna kwa voie be yawasana kwa paḡona.” ");
INSERT INTO dww_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Be tauname ya gudutara munaḡe be Yesu ya riuena, “Naumeki, be yau banagama aitauḡa?” ");
INSERT INTO dww_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu gututue tauna ya paribeena, “Raḡan tenaḡa tauḡoma Jerusalemma be ya dobi ya naḡonaḡona Jerikoma. Be kedae banaga danedanenedima inam tauḡominama a vunuḡi da na garama a kaiporaḡa be a riḡa da ya raugurere be a gose da a naḡo porena. ");
INSERT INTO dww_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Naumeki da pirisi inam kedanaḡa ya dobi ya naḡonaḡona. Be raḡanine tauna e kitana be tauḡominama ya kenakenana, naumeki da keda dianaḡa ya dobi be ya naḡo ḡomana. ");
INSERT INTO dww_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Be murine Livait dobudine ya dobina. Be kauinama teneḡinama ya kita be tauna mate keda dianaḡa ya dobi be ya naḡo ḡomana. ");
INSERT INTO dww_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Be Samaria tauḡominama kedanaḡa ya dobi be ya naḡonaḡo da tauḡominama ḡarone ya dobina. Be raḡanine tauḡominama nama e kitana, be ya raunuatoiena. ");
INSERT INTO dww_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Naumeki da ya naḡo ḡarone ya tava be oeri be waen kerone ya ḡinidi be garae keronama ya panidina. Yodibe ya kiroḡi da na donkima ragane yai geru da yai doka nawena barekie, be dabudi ya rabena. ");
INSERT INTO dww_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Naumeki da pomainama Samaria tauḡominama Denari rabui ya ragaudi be bareki taurabenama ya ute be ya riuena da inam tauḡominama sibo rabe kauena, be deḡoda mane nam teneḡina, naumeki da taugu yà tava munaḡana raḡanine tam yài maesimna.” ");
INSERT INTO dww_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Be Yesu tauḡoma yai taravirena, “Be yodi nema kwa noḡonoḡota bake, uma banegidima rabuiteḡa be deḡo baneginama taudanedanene a vunuvunuḡina ewai turane?” ");
INSERT INTO dww_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dabudine tarawatu tauwai katakatainama ya paribee be ya riuna, “Aitau da inam tauḡominama ya sagusaguna, inam tauna vutuna turanama.” Be Yesu ya riuena, “Tam kwa naḡo be nama kwa voia watanana!” ");
INSERT INTO dww_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na tauwai muriwatanama mate a naḡonaḡona Jerusalemma be kedae meagaie a tavatavana, dabudine waivi isanama Mata, tauna Yesu ya kokone da taudi vadae a saḡana. ");
INSERT INTO dww_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Be tauna tasinama isanama Meri, tauna Yesu kaḡane ya mia be na giuma yawai beavaiena. ");
INSERT INTO dww_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Be Mata taunaḡa ya youyouvoa guratana, vutuna aubainama tauna Yesu ḡarone ya verau be ya riuena, “Bada, tam kuya kataie bo ibewa da tasiguma ya gosegu be tauguḡa yà youyouvoana. Kwa riue be e kaisagugu.” ");
INSERT INTO dww_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Be Bada ya paribee be ya riuna, “O Mata, tam yaba matabudi kwawai nuaboyedi be taudi ta kawakawa nuaraḡaraḡamna. ");
INSERT INTO dww_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Be yaba tenaḡa yodi Meri ya vinena, tauna vutuna ya vere kauana, be nam aitau tauna ḡarone e kaipore.” ");
INSERT INTO dww_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Raḡan tenaḡa Yesu gabu ḡesaune ya moimoiragina. Be ya moimoiragi kovina murine, na tauwai muriwatanama tenaḡa ya riuna, “Bada, moiragi kwai kataimai da tauma nama sibo kè moiragina, maika Jon na tauwai muriwatanama yai katakataidina nama.” ");
INSERT INTO dww_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu ya riuedina, “Raḡanine ko moiragina, umanama ko riu: Mamai, dobu matabuna isamma babaunama sibo a vivirena. Tam am waibadama sibo ya verau. ");
INSERT INTO dww_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ama kanima raḡan patapatanama sibo kuya utemai. ");
INSERT INTO dww_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","“Bada, ama gewagewama kwa noḡota poredi maika tauma ama banagama ḡaromaie gewagewa a voivoiedina ka noḡonoḡota poredina nama. Be nam raurubue kwai dokemai. ");
INSERT INTO dww_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Dabudine Yesu ya riuedina, “Deḡoda tam aitau turamma risine kupi poune ku naḡo be ku riuena, ‘Yau tura, buredi rabuiteḡa kwa utegu, ");
INSERT INTO dww_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","baninama turaguma yodi vaḡaie ya tava be taugu nam ḡarogue aba da sibo è ute.’ ");
INSERT INTO dww_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Be turamma vada nopone i paribeem be i riuna, ‘Nam kwa taiḡosoḡosorigu, taugu yau sedama mate matakeda kè gudu be ka kenakenana, tokare nam aiyaba yà utem.’” ");
INSERT INTO dww_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Dabudine Yesu ya riuna, “Taugu yà riuriuemina da turamma nam i ḡoena da sibo ya midisuḡu be kani ya utem. Be am waibaḡa dobidobima aubainama tauna tokare e midisuḡu da kani e utemna. ");
INSERT INTO dww_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Vutuna aubainama yà riuriuemina, koi baḡa be e utemina, ko wane be ko banavina, ko raupewapewa be ḡaromie e kaiporena. ");
INSERT INTO dww_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Baninama aitau ewai baḡana, tokare e paḡona, be aitau e wanewanena, tokare e banavina, be aitau e rarau pewapewana, tokare ḡarone e kaiporena. ");
INSERT INTO dww_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nam ai gomana kani i ḡabeḡabe be tamanama yeku i utena, ibewa. ");
INSERT INTO dww_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Be nam ai gomana pou i ḡabeḡabe be tamanama rikarikau i utena, ibewa. ");
INSERT INTO dww_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yodi uma ko noḡoti, avedi da taumi banaga gewegewemima be yaḡoro yaba veredima natunatumima ko uteutedina. Vutuna aubainama Tamemima marae tauna teneteneḡinama da aitauḡa Arua Babau tawai baḡena, tokare e utedina.” ");
INSERT INTO dww_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu penama ya tavu dobiḡena. Be uma peneminama banaga ya koku be ya miamiana tauna gumgum. Be inam penama tauḡoma ya gosegosena raḡanine, tauḡoma giu yai kare munaḡena, be banaga matabudi a basena. ");
INSERT INTO dww_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dabudine banaga ḡesaudima a riuna, “Yesu tauna Belsebul isane penama e tavutavu dobiḡedina. Be Belsebul tauna penama adi guyauma.” ");
INSERT INTO dww_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Be banaga ḡesaudima taudi Yesu raurubunama aubainama awai baḡana da sibo mara matairinama ya voie be taudi sibo a kita be ai kawa riukaue da tauna naumeki Mamaitua ḡaronama. ");
INSERT INTO dww_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Be Yesu ya kataie da taudi aba awai nuanoḡonoḡotena, aubainama tauna umanama ya riuedina, “Deḡo dobunama tenaḡa e dariḡa munaḡena, tokare taunaḡa e kawa gewagewa munaḡena. Be deḡo vadanama ei mia ḡinanana, tokare taunaḡa ei yamona munaḡena. ");
INSERT INTO dww_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Deḡoda Seitan na banagama mate tai ḡinana munaḡedina, tauna tokare na waiguyauma e kawa gewagewa be nam ei rewapana. Umanama yà riuriuna, baninama taumi ko riuriuna da taugu kabe Belsebul isane penama è tavutavu dobiḡedi. ");
INSERT INTO dww_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Be deḡoda taugu Belsebul isane, penama è tavutavu dobiḡedina, naumeki da yodi taumi Parisi ami tauwai muriwatanama taudi aitau isane penama ta tavutavu dobiḡedi? Taumi ami tauwai muriwatanama tawai maḡatarana da taumi ko kaikaiyovuna! ");
INSERT INTO dww_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Be deḡoda taugu Mamaitua nimarakurakune penama yà tavutavu dobiḡedina, inam anikitanama Mamaitua na waiguyauma ḡaromie ya tavana. ");
INSERT INTO dww_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Deḡoda banaga wairewapaninama ma madana na gabuma e bodabodamena, naumeki da na purapurama tokare ta kena kauana. ");
INSERT INTO dww_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Be deḡoda banaga wairewapana vavasaḡinama e tava be inam baneginama e vunuḡi be na madama na kaba waisumaḡedima e ragaudina, inam raḡanine banaga wairewapana vavasaḡinama taubodama na purapurama e ragaudi be na banagama e soiedina. ");
INSERT INTO dww_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Deḡoda tauna aitau nam taugu mate, tauna inam taugu ewai ḡavieguna. Be mate tauna aitau nam taugu mate kama noyanoya tenaḡana, tauna inam yau noyama e kawakawa gewagewana. ");
INSERT INTO dww_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Be penama banaga e dobidobi porena raḡanine, tauna dobu pokine e naḡo be na kaba siperema gabunama e wanena. Be deḡoda gabu nam e banavi, tauna tokare e riuna, ‘Taugu yà munaḡana yau vadae, deḡo e veraveraue dabudi.’ ");
INSERT INTO dww_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Raḡanine tauna e tava munaḡa da vada kavakavanama, kawakawa verenama be waiwaisianama e kenakenana e kitana, ");
INSERT INTO dww_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","inam raḡanine tauna e munaḡa be penama ḡesaudima, matabudi 7 ei dokedina. Be inam penemidima a gewagewa vavasaḡana, nam maika noḡone. Be taudi matabudi inam vadanama nopone ta saḡa be banaga nopone ta miana. Inam raḡanine banaga na yawasanama e gewagewa vavasaḡana, nam maika noḡone.” ");
INSERT INTO dww_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Raḡanine Yesu inam nama ya giugiuna maika, waivi patara nopodie bonanama dosine Yesu ya riuena, “Nuavere tauna aitau tam ya tikam be yai susumna.” ");
INSERT INTO dww_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Be Yesu inam waivinama ya paribee be ya riuena, “Naumeki aba kuya riuena, be nuavere dosinama taudi aitauḡa Mamaitua riunama ta vaivaie be ta voivoiena.” ");
INSERT INTO dww_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Be patara ya moramorabana raḡanine, Yesu ya riuna, “Taumi uma kimtimima kimta gewegewemima. Taumi matairaḡa kitanama ko ḡoeḡoena, be nam tokare mataira ko kita da Jona na matairama taunaḡa tokare ko kitana. ");
INSERT INTO dww_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona taunaḡa yai matairana Ninive aubaidima, teneḡinama nama Banaga Natunama tokare ei matairana taumi kimtimima aubaimima. ");
INSERT INTO dww_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Etara raḡanine dobu Saba guyaunama waivinama taumi kimtimima mate ko midisuḡu munaḡana raḡanine, tauna tokare e riuna da taumi kimtimima sibo gienae koya naḡona, baninama boni Saba guyaunama tauna dobu damone, be ya tavana, Solomon na nuauyauyama vaienama aubainama, be yodi uma dobudine banaga tenaḡa Solomon ya saḡa porena be tauna na giuma nam komawai beavaiena. ");
INSERT INTO dww_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Etara raḡanine Ninive meagainama banegidima taumi kimtimima mate ko midisuḡu munaḡana raḡanine, taudi ta riuna da taumi kimtimima sibo gienae koya naḡona, baninama boni Jona ya rarau guguyana, be Ninive banegidima a vaie be taudi noḡota vitara a paḡona, be yodi uma dobudine banaga tenaḡa Jona ya saḡa porena, be tauna na giuma nam komawai beavaiena. ");
INSERT INTO dww_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nam aitau kodam e gabu be e semo, bo tebo dibune e boru. Ibewa, tauna kodam ḡavoe ei midiri da banaga ta saḡasaḡana ta kitana. ");
INSERT INTO dww_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matamma inam tunimma na kodamma. Deḡoda matamma verenama, naumeki da tunimma matabuna yanayananama, be deḡoda matamma e gewagewana, naumeki da tunimma matabuna ei kupikupina. ");
INSERT INTO dww_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Be yodi kwa kita kaua da yana ḡarome nam ei kupikupi. ");
INSERT INTO dww_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Deḡoda tam tunimma matabuna yanayananama, be nam tunimma aiyabinama ei kupikupi, naumeki da tunimma matabuna e yanana maika kabe kodam neneḡarinama ḡarome i yanayanana.” ");
INSERT INTO dww_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Raḡanine Yesu na giuma yawai kovina, Parisi tenaḡa tauna ya kokonena na vadae kani aubaina. Naumeki da Yesu ya saḡa da ya mia be ya kanikanina. ");
INSERT INTO dww_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Be Parisi tauna ya basena, baninama Yesu tauna nimanama nam i koḡa be ya kanikanina. ");
INSERT INTO dww_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Be Yesu Parisi ya riuena, “Taumi Parisi raḡan matabuna ami raudunema mataira kitekitedima kowai sumaḡedi be kowai muriwatanedina, be taumi nopomima gewagewa ya moḡavuna. Taumi maika keaka be tebo tauridima ko koḡekoḡedina be nopodie mira yaḡoro ta kenakenana. ");
INSERT INTO dww_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Taumi koya bua kauana! Koya kataie bo ibewa da Mamaitua ḡavoe be nopoe raudunedima tauna ya voiedina? ");
INSERT INTO dww_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Taumi nopomima ko koḡedi be ami yawasanama ko kawa didimanidina, yodibe yaba matabuna inam e verena. ");
INSERT INTO dww_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Taumi Parisi ko kita kaua! Baninama yaba matabuna koi rawadamdamdi da matabudi 10 be dam tenaḡa Mamaitua ko uteutena, be kani anitai dinidima mate. Be taumi banaga ḡesaudima ḡarodie nam komawai rabaraba kauana be Mamaitua nuemima nam ima paḡopaḡona. Taumi yaba matabudi sibo koya voiedina! ");
INSERT INTO dww_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Taumi Parisi, ko kita kauana! Baninama sinagog nopone gabu verediḡa ko ḡoeḡoedina, be taumi ko ḡoeḡoena da debae banaga tai kaiwemina banaga dosidima maika.” ");
INSERT INTO dww_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Be Yesu uma wainasinama ya riuedina, “Taumi Parisi, gewagewa ḡaromie! Baninama taumi maika kokoaga nam waimatairidi banaga nam ti kataie be debanaḡa ta naḡo yababa be adi yawasanama ta kawakawa gewegewedina.” ");
INSERT INTO dww_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dabudine tarawatu tauwai katakatainama tenaḡa Yesu ya riuena, “Tauwai katakatai, uma yabedima kwa giugiuedina, tauma mate kwa biribiri dobiḡemaina.” ");
INSERT INTO dww_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Be Yesu ya paribee be ya riuna, “Taumi tarawatu tauwai katakataidima, taumi mate ko kita kauana! Baninama taumi banaga vita koi kiroḡidi be ta kirokiroḡa rereḡedina, be taumi nam airaḡan koma sagusagu rubudina. ");
INSERT INTO dww_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ko kita kauana! Baninama boni taumi waḡewaḡemima peroveta ai guridina, be taumi kowai aninedina. ");
INSERT INTO dww_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Taumi ko noḡonoḡotina da aba waḡewaḡemima a voivoiedina, inam naumeki, baninama taudi peroveta a vunuḡidi be taumi yodi adi kokoagama koi kitedi be kowai nuaverena. ");
INSERT INTO dww_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Vutuna aubainama Mamaitua na nuauyauyae ya riuna, ‘Taugu peroveta be apasol yà riuporaḡana be ḡesaudima tai guridina, be ḡesaudima ta raukivigewegewedina.’ ");
INSERT INTO dww_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Raḡan pakane da yodi banaga peroveta ai guridina be kosinidima a darorona aubainama, taumi kimtimima tokare kovoḡa ko paḡona. ");
INSERT INTO dww_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Peroveta matabudi Eibol ya naḡo da Sakaraias, tauna olta be tempol poudie ai guridina. Inam banegidima awai guridina kadi taiye naumeki da taumi tokare Mamaitua e kovoḡimina, baninama peroveta awai guridina taumi kowai aninedina aubainama. ");
INSERT INTO dww_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Taumi tarawatu tauwai katakataidima, ko kita kauana! Baninama taumi riukaua kiḡinama koya paḡo be ko semosemona, vutuna aubainama taumi nam tokare marae ko naḡo. Be banaga ḡesaudima taudi marae naḡonama ta ḡoeḡoena, be taumi ko gudugududina.” ");
INSERT INTO dww_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Dobudine Parisi be tarawatu tauwai katakataidima nuedima yai medi be bonedima bagibagine awai sinasinana, ");
INSERT INTO dww_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","da Yesu aba giunama gewagewanama sibo ya vato be a vunuḡina. ");
INSERT INTO dww_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Raḡan ḡaubonaḡa be patara ya morabana tausand bisanama be adi banagama mate awai vaguda munaḡana. Be Yesu na tauwai muriwatanama ḡarodie giu yai kare da ya duḡudi be ya riu wainoḡotidina, “Ko rabe munaḡemi be nam Parisi adi kauama ko ruvedi. Taudi ta voivoiana kabe banaga veredi, be ibewa. Baninama taudi adi waikaikaiyovuma maika sida ewai raudavudavuna. ");
INSERT INTO dww_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Be raḡan e veraverauna e tavana, inam raḡanine uma yabedima rupurupudima tokare ta maḡatarana, be yaba semosemodima tokare banaga matabudi ta kataiedina. ");
INSERT INTO dww_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Be aiyaba kupie ko giuedina, tokare banaga matabudi yanae ta vaiedina, be aiyaba turemima mate waimoisirie koi kasavena, tokare patare ta giue be banaga matabudi ta vaiena. ");
INSERT INTO dww_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Yau bana, taugu yà riuriuemina, banaga tubuḡa taunaḡa tauwai gurinama nam ko nairedi, tokare nam aba ḡesau ta voie. ");
INSERT INTO dww_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Taugu yà riuriuemina da aitau ko nairena. Mamaitua ko nairena, baninama ko gurina murine, tauna deḡoda e ḡoena, tauna rewapana ḡarone da tokare gienae e poraḡa nawemina. Vutuna aubainama yà riuriuemina da tauna taunaḡa ko naire! ");
INSERT INTO dww_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kiu ḡauḡaubodima matabudi 5 maesidima 20 Toea. Be nam ai kiu tenaḡa Mamaitua nuanama i koana. ");
INSERT INTO dww_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Avedi debavuvuḡimima be inam matabudi Mamaitua ya sievidina. Vutuna aubainama nam ko naira, taumi noḡotimima ya moraba kauana, nam kiu ḡauḡaubodima maika. ");
INSERT INTO dww_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Be yà riuriuemina da aitau taugu ei maḡatariguna banaga matedie, naumeki da taugu tauna Mamaitua na aneama matedie yai maḡatarina. ");
INSERT INTO dww_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Be aitau taugu e bovieguna banaga matedie, naumeki taugu tauna Mamaitua na aneama matedie yà boviena. ");
INSERT INTO dww_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Deḡoda aitau Banaga Natunama ḡarone e riu viravirana, naumeki da taugu tokare yà noḡota porena, deḡoda tauna noḡotaporaḡa e ḡoena. Be deḡoda aitau Arua Babau ḡarone ei diboḡana, avedi da tauna noḡotaporaḡa e ḡoeḡoena, be taugu tokare nam yà noḡota pore. ");
INSERT INTO dww_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Taumi taugu kowai sumaḡeguna aubainama, deḡoda banaga ta verauḡemina sinagog nopone etaremima aubainama, nam ko naira bo ko riuna, ‘Nema tà gudutara bako?’ ");
INSERT INTO dww_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","baninama inam raḡanine tokare Arua Babau tauna giu e utemi be nama ko giuna.” ");
INSERT INTO dww_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Banaga tenaḡa patara nopodie Yesu ya riuena, “Tauwai katakatai, tuaḡaguma kwa riue da tauna dosi gagasidima e soiedi da tauna be taugu.” ");
INSERT INTO dww_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Be Yesu ya riuena, “Badam, tam aitau ya riuem da taugu ami purapurama soienama yài tarapiriedi?” ");
INSERT INTO dww_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Be Yesu taudi ya riuedina, “Ko kita kaua da ḡaromie nam purapura matabudi koi gogo, baninama taumi nam teneteneḡina da inam purepuredie yawasana ko banavi!” ");
INSERT INTO dww_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dabudine Yesu uma wainasinama ya riuedina, “Raḡan tenaḡa purapura baneginama na sipima ya maurana. ");
INSERT INTO dww_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Be inam baneginama tauna ya noḡota munaḡena, ‘Taugu yodi aba yà voie? Taugu yau gabuma nam teneteneḡina da yau maurama yài damdi.’ ");
INSERT INTO dww_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dabudine tauna ya riuna, ‘Taugu è kataiena yodi aba yà voiena. Yau kanima vadedima yà kati weidi be vada dosidiḡa yà keridi. Be dabudine yau maurama be yau purapura matabudi yài damdina. ");
INSERT INTO dww_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Be dabudine taugu yà riu munaḡeguna, Ya vere kauana, yodi aba yài nuaboye? Taugu yabedima veredima matabudi è ḡoeḡoedina yodi è ragaudina modi toitoi ruvedima. Yodi taugu yà sipere, yà kani, yà tego be yài nuaverena.’ ");
INSERT INTO dww_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Be Mamaitua ya riuena, ‘Tam bua! Manaka kupine am yawasanama yà kaiporena, be aubaimma kuya vovo kaukauana tokare aitau e ragaudi?’ ");
INSERT INTO dww_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Inam kauinama teneḡinama nama tauna aitau dobue maurama ewai damna ḡarone e tubuḡana, be tauna nam Mamaitua ḡarone na maurama imawai damna, ibewa.” ");
INSERT INTO dww_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Be Yesu na tauwai muriwatanama ya riuedina, “Taugu yà riuriuemina da nam tubuḡimima na yawasanama aubainama koi nuaboya, aba sibo koya kani bo aba sibo koya kote tunimima aubainama. ");
INSERT INTO dww_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Baninama yawasana noḡotinama inam ya moraba vavasaḡana, nam maika kani, be tunimima noḡotinama inam ya moraba vavasaḡana, nam maika gara. ");
INSERT INTO dww_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kiu gayogayo ko kitedi! Taudi nam tima sipisipina, be nam kani timawai damna. Be yaḡoro Mamaitua ewai kanidina. Be taumi noḡotimima inam ya moraba vavasaḡana, nam maika kiu. ");
INSERT INTO dww_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tam aitau da inam yabedima kwawai nuaboyedina, tokare kwa mia watana, bo? ");
INSERT INTO dww_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Be taumi deḡoda inam yabedima ḡauḡaubodima nam teneteneḡina da ko voiedi, naumeki da yaba ḡesaudima mate nam koi nuaboyedi! ");
INSERT INTO dww_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nanari dobire ta gogogogona ko kitedi. Taudi nam tima noyanoyana be gara nam tima voivoiedina. Be yà riuriuemina, avedi da guyau Solomon na garama veredima waimatakanikanidima, be nam ai gara tenaḡa i vere vavasaḡana nanari maika. ");
INSERT INTO dww_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Be yodi berana ta gogo be Mamaitua ewai garedina ko kitekitedina, be pomai kaie ta gabu gorudina. Teneḡinama nama Mamaitua tokare teneteneḡinama da taumi ei garemina! Taumi ami waisumaḡama ya ḡaubo kauana! ");
INSERT INTO dww_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Be mate kani be tego nam koi nuaboyedi! ");
INSERT INTO dww_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dobu banegidima nam waiwaisumeḡidi inam yabedima tawai nuaboyedina. Taumi Tamemima marae ya kataie da inam yabedima ko ḡoeḡoedina. ");
INSERT INTO dww_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Be taumi noḡone Mamaitua na waiguyauma ko wane dokena. Yodibe tauna inam yabedima matabudi e utemina. ");
INSERT INTO dww_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Taumi inam taugu yau yosima damnama ḡaubonama, nam koi nuaboya, baninama Tamemima tokare na waiguyauma e utemina. ");
INSERT INTO dww_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ami purapurama ko raugimaredi be mane banaga waikaruwaḡewaḡedima ko utedina. Deḡoda nama ko voiana, tokare marae ami waiguyauma verevavasaḡinama ko paḡona, be inam waiguyaunama nam airaḡan e kovi. Be nam aitau ami waiguyauma e danene bo kwarikwari ta kanidi. ");
INSERT INTO dww_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Baninama taumi ami waiguyauma vere vavasaḡidima deḡo ta kenakenana, taumi ami noḡotama be nuemima tabutabunama inam dabudine ta kenakenana. ");
INSERT INTO dww_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Raḡan matabuna ko vokaukaua wainonoḡa da ami kodamma ko gabudi be koi rabana, ");
INSERT INTO dww_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","maika taunoya adi badama soie ya naḡo be ta raberabena da e verau munaḡana, be raḡanine e tava munaḡa be e raupewapewana taudi waiḡapa ta dobi be matakeda ta kaiporena. ");
INSERT INTO dww_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Raḡanine Bada e verau munaḡa be na taunoyama a vokaukaua be tauna a raberabena e kitedina, inam raḡanine nuavere dosinama taunoya ḡarodie. Taugu yà riuriu kauemina inam raḡanine Bada na taunoyama e riuedi da taudi ta mia be tauna na taunoyama adi kanima e soiena. ");
INSERT INTO dww_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Inam raḡanine, taunoya avedi da kenavauvaue bo nobautuae, taudi yaḡoro a vokaukaua be tawai rabana. Be Bada e verau munaḡa da e kitana be na taunoyama a vokaukauana be awai rabana, inam raḡanine naumeki da nuavere dosinama taudi ḡarodie. ");
INSERT INTO dww_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Uma ko noḡoti, deḡoda vada taupakinama sibo taudanene na kaba tavama raḡaninama i kataiena, naumeki da tauna tokare na gaburama ya bodame be baneginama nam na vadae ya saḡa be ya danene. ");
INSERT INTO dww_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Be taumi mate nama ko vokaukauana, baninama Banaga Natunama na verauma raḡaninama taumi nam koma noḡonoḡotina da tauna e tava, inam raḡanine tauna e tavana.” ");
INSERT INTO dww_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Be Pita yai taravira be ya riuna, “Bada, uma wainasinama taumaḡa aubaimaima kuya giue bo banaga ḡesaudima mate?” ");
INSERT INTO dww_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Be Yesu ya paribeena, “Aba è riuriuemina, yodi nema ko noḡonoḡota bake? Aba taunoyanama waisumeḡina be nuanuauyauyanama, da bada inam taunoyanama e vine be tauna na banagama ei badedi be adi kanima e soiena? ");
INSERT INTO dww_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Raḡanine Bada e verau munaḡa be na taunoyama inam noyanama e voivoiena e kitana, naumeki da nuavere dosinama inam taunoyanama ḡarone. ");
INSERT INTO dww_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yà riuriu kauemina da tokare Bada inam taunoyanama e vine da Bada na purapurama matabudi ei badedina. ");
INSERT INTO dww_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Be deḡoda taunoya tauname e riu munaḡe be e riuna, ‘Yau Badama bonika deḡo ya naḡona be nam ima veraverau munaḡana.’ Inam raḡanine tauna na banagama ḡesaudima riḡedima ei karena, dabudine tauna e kanikani be e tegotego koakoa be e tego buana. ");
INSERT INTO dww_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Inam raḡanine taunoya e miamia nuababaḡa be Bada e verauna raḡanine, tauna e dourakaraka be banaga nam waiwaisumeḡidi ḡarodie e boru nawena. ");
INSERT INTO dww_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Be taunoya Bada na ḡoanama ya kataiena, be nam i vokaukauana bo Bada na ḡoanama nam i voivoiena, naumeki da tauna tokare kovoḡa dosinama e paḡona. ");
INSERT INTO dww_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Be deḡoda taunoya aitau Bada na ḡoanama nam i kataiena be aba ya voia waigewana, tauna tokare kovoḡa ḡaubonama e paḡona. Deḡoda Mamaitua banaga yaba toitoi ya uteutena, tauna tokare inam baneginama ḡarone yaba toitoi e ragaudina. Be Mamaitua banaga aitau yaba toitoi nimane ya biridi be e raberabedina, naumeki da inam baneginama yaba toitoi Mamaitua e ute munaḡena. ");
INSERT INTO dww_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Taugu è yovona kai karakaratinama dobue è yovoḡena, be yà noḡonoḡotina da kainama kaiteka e karatina. ");
INSERT INTO dww_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Taugu tokare babataito bagibaginama yà paḡona, be ma nuaboyagu naumeki da yà raudamoena. ");
INSERT INTO dww_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Taumi ko noḡonoḡoti da taugu dobue è yovona suba è yovoḡe, bo? Ibewa, nam suba be dariḡa. ");
INSERT INTO dww_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yodi be nokoi e naḡona vada tenaḡa nopone banaga 5 tai kawa dariḡa munaḡana. Banaga rabuiteḡa rabui mate tai saḡasaḡana, be banaga rabui rabuiteḡa mate tai saḡasaḡana. ");
INSERT INTO dww_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tametamedima, natunatudima tautauḡomidima mate tai saḡasaḡana, be natunatudima tautauḡomidima, tametamedima mate tai saḡasaḡana, be tinetinedima, natunatudima waiwaividima mate tai saḡasaḡana, be natunatudima waiwaividima, tinetinedima mate tai saḡasaḡana. Be rawanama visara mate tai saḡasaḡana, be visara rawanama mate tai saḡasaḡana.” ");
INSERT INTO dww_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Be Yesu banaga ya riuedina, “Taumi giyou ko kita be egasiḡa e naḡonaḡona, inam raḡanine ko riuriuna, ‘Yodi kusana e ḡoḡona’, be nama e tubutubuḡana. ");
INSERT INTO dww_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Be deḡoda sive oyaḡa e yovoyovona, inam ko riuriuna, ‘Yodi komra e tomna’, be nama e tubutubuḡana. ");
INSERT INTO dww_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Taumi banaga kaikaiyovumima! Taumi mataira gunume be dobue kitawairuvedima koya kataiena. Be aba aubaina yodi raḡandima matairidima kitawairuvedima nam koma siasiava kauedi? ");
INSERT INTO dww_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Taumi koi tarapiri munaḡemi da deḡo tauna didimana be riukaua. ");
INSERT INTO dww_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Deḡoda banaga tam e panim be e nawemna etara aubainama, naumeki da kedae kwa raurubu da am gewagewama kwa kawa didimana dokena. Inam raḡanine nam etara tauwai badenama e riuem be dibure kwa naḡo. ");
INSERT INTO dww_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Taugu yà riuriuemna da tam tokare nam dibura kwa dobi pore naumeki da Toea damonama kwa kaiḡavutina.” ");
INSERT INTO dww_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Inam raḡanine banaga aitauḡa dabudi a tavatavana, taudi Yesu ḡarone ai maḡatarana da Galili provins banegidima ḡesaudima taudi musare Mamaitua ḡarone a rarau puyona maika, Paelat na tauiḡarama inam banegidima ai guridina. ");
INSERT INTO dww_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Be Yesu ya riuedina, “Taumi ko noḡonoḡotina da inam banegidima nama ai nuatoitoi be a gurina adi gewagewama ya moraba kaua, nam banaga ḡesaudima maika, bo? ");
INSERT INTO dww_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ibewa, nam nama. Yà riuriuemina da nuemima nam ko vitaredi, taumi matabumi tokare nama ko gurina. ");
INSERT INTO dww_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bo banaga matabudi 18 ko noḡotidi, taudi raḡanine Siloamma be vada debedie ya beku be yai guridina. Taumi ko noḡonoḡotina da noa banegidima nama a gurina adi gewagewama ya moraba kaua, nam maika banaga ḡesaudima Jerusalemma nama, bo? ");
INSERT INTO dww_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ibewa, nam nama. Yà riuriuemina da nuemima nam ko vitaredi, taumi matabumi tokare nama ko gurina.” ");
INSERT INTO dww_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dabudine Yesu uma wainasinama ya riuedina, “Tauḡoma tenaḡa na sipie damaya ya midimidina. Be inam tauḡominama ya naḡona damaya banidima aubaidima, be nam i banavidina. ");
INSERT INTO dww_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Vutuna aubainama tauna sipi taurabenama ya riuena, ‘Taugu modi rabuiteḡa nopodie èi veraverauna damaya banidima wanedima aubainama, be nam airaḡan banidima e banavidina. Vutuna aubainama kwa taraḡa pore! Aba aubainama doḡa ewai yakare?’ ");
INSERT INTO dww_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Be sipi taurabenama ya riuna, ‘Bada, kwa gosepore da modi tenaḡa nopone taugu yà keri dobona. ");
INSERT INTO dww_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Be deḡoda modi ḡesau nopone e banina, inam naumeki. Be ibewa, naumeki da kwa taraḡa porena.’” ");
INSERT INTO dww_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat raḡanine Yesu sinagog tenaḡa nopone yawai katakataina. ");
INSERT INTO dww_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Be inam dabudine waivi tenaḡa nopone penama ya saḡa be ya voie da tauna ya sida kauana modi 18 a kovina, be nam teneteneḡina da sibo ya didimana munaḡa. ");
INSERT INTO dww_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Raḡanine Yesu inam waivinama ya kitakitana, tauna ya riue da ḡarone ya tava be ya riuena, “Waivi, yodi am sidama ya kovina.” ");
INSERT INTO dww_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Naumeki da Yesu nimanama waivi debane ya boru be yai raḡantenaḡe da waivi ya didimana munaḡa be Mamaitua isanama ya kaisuḡuna. ");
INSERT INTO dww_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Be sinagog taurabenama nuanama yai medi kauana, baninama Yesu tauna Sabat raḡanine banaga yai yawasanina. Dabudine sinagog taurabenama banaga ya riuedina, “Raḡan matabudi 6 ta kenakenana, inam noya na raḡanima. Inam raḡandie ko verauna waiyawasana aubainama be nam Sabat raḡanine!” ");
INSERT INTO dww_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Be Yesu tauna ya paribee be ya riuna, “Taumi kaikaiyovumima! Matabumi Sabat raḡandie ami yosima nam komawai kanidi, bo? ");
INSERT INTO dww_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Be uma waivinama Eibraham natunama, be Seitan ya pani be ya rabena modi 18 a kovina. Be yodi aba aubainama Sabat raḡanine nam sibo èi yawasani?” ");
INSERT INTO dww_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Inam nama ya riuriuna raḡanine, na ḡaviama banegidima debedima ya suba kauana. Be banaga ḡesaudima nuedima ya vere kauana, baninama tauna yaba matabudi veredima ya voivoiedina aubainama. ");
INSERT INTO dww_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu ya riuna, “Mamaitua na waiguyauma nema maika kitana? Nema yài tarapata bake da taumi ko kataie? ");
INSERT INTO dww_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Inam maika pesi ḡaubonama banaga ya paḡo be na sipie ya kuma be ya gogo ya moraba da kai dosinama ya tubuḡana. Be kiu a verau be ragane a rarau noḡina.” ");
INSERT INTO dww_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Be Yesu ya riu munaḡana, “Mamaitua na waiguyauma nema maika kitana? Nema yài tarapata bake da taumi ko kataie? ");
INSERT INTO dww_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Inam maika yist waivi ya paḡo, parawa toitoi nopodie ya biridi, da ya gwada be parawa ya sasanana.” ");
INSERT INTO dww_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu tauna Jerusalemma ya naḡonaḡona, be kedae meagaiḡa banaga yawai katakataidina. ");
INSERT INTO dww_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Be banaga tenaḡa Yesu yai taravirena, “Bada, inam riukaua da banaga raubisaḡa tokare ta yawasana, bo?” Be Bada ya riuedina, ");
INSERT INTO dww_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ko kaivavasaḡe da matakeda ḡuririne ko sonaḡana, baninama banaga toitoi ta rarau rubuna da ta sonaḡana, be tokare nam teneteneḡina. ");
INSERT INTO dww_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Baninama raḡanine vada taupakinama e midisuḡu be matakeda e guduna, dabudine taumi doḡae ko midi be matakedae ko raupewapewa be ko riuna, ‘Bada, matakeda aubaimaima kwa kaipore.’ Be tauna tokare umanama e paribeemina, ‘Taugu nam taumi e kataiemina. Taumi aikedae be koya tava?’ ");
INSERT INTO dww_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dabudine taumi ko riuna, ‘Bada, tauma tam mate tè kanikani be tè tegotegona, be ama meagaiḡa kuyawai katakatai naḡona.’ ");
INSERT INTO dww_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Be tauna e riu munaḡemina, ‘Kaite naumeki è riuemina. Taugu nam taumi e kataiemina. Taumi aikedae be koya tava? Ko naḡo ḡavoe! Taumi nam uma dabudine ko saḡa, gewagewa tauvoienama.’ ");
INSERT INTO dww_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Dabudine taumi ko ḡaba gurata be gadigadimima ko sanadididina. Be dabudine taumi tokare Eibraham, Aisik, Jeikob be peroveta matabudi Mamaitua na waiguyauma nopone ta soisoina ko kitedina, be taumi tokare Mamaitua ei poraḡa dobiḡemina. ");
INSERT INTO dww_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Be Banaga dobu matabuna nopone tokare ta verauna, Mamaitua na waiguyauma nopone ta mia be Mamaitua na soima ta kanina. ");
INSERT INTO dww_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Naumeki da yodi ko kita, aitauḡa yodi ta dokadokana, taudi tokare tai murina, be aitauḡa yodi tawai murina, taudi tokare ta dokana.” ");
INSERT INTO dww_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Inam raḡaninama teneḡine Parisi a verau Yesu ḡarone be a riuena, “Tam uma dobunama kwa dobi pore be kwa naḡona wari kedae, baninama guyau Herod e ḡoeḡoena ei gurimna.” ");
INSERT INTO dww_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Be Yesu umanama ya paribeedina, “Ko naḡo be inam dakonama ko riuena, taugu manaka be pomai penama banaga nopodie yai dobidina, be banaga sidesidedima yai yawasanidina, be mainokomḡo yau raḡanima e kovina. ");
INSERT INTO dww_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Be yodi taugu naumeki da yau noyama yà voiedina, manaka, pomai, be mainokomḡo mate, baninama nam i verena da peroveta wari kedae e guri, ibewa da Jerusalemḡa nopone. ");
INSERT INTO dww_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem! Taumi peroveta kowai guridina. Mamaitua banaga e riuriu poraḡana ḡaromie, be taumi ko rarau yekudina! Raḡan ya toi kauana taugu è raurubu da è rawateḡeteḡeimina kamkam natunatunama mapenama dibune e rawarawa teḡeidina maika, be taumi nam ko ḡoena. ");
INSERT INTO dww_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vutuna aubainama Mamaitua ami tempolma e gosena. Be taugu yà riuriuemina taumi nam ko kita munaḡegu, naumeki da raḡan e veraverauna e tavana, inam raḡanine taumi tokare umanama ko riuna, ‘Isanama tà kaisuḡu, tauna vutuna Bada isane e veraverauna!’” ");
INSERT INTO dww_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat tenaḡa Yesu ya naḡona Parisi dosinama na vadae kani aubainama, be banaga tauna a kitakita watanina, ");
INSERT INTO dww_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","baninama Yesu noḡonama yauwanine tauḡoma kaḡanama be nimanama sasasanidima ya miamiana. ");
INSERT INTO dww_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Be Yesu Parisi be tarawatu tauwai katakataidima yai taraviredina, “Inam naumeki bo ibewa da Sabat raḡanine banaga tài yawasanina?” ");
INSERT INTO dww_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Be taudi nam aba ti riuena. Naumeki da Yesu inam tauḡominama ya taukoni da yai yawasani be ya riupore nawena. ");
INSERT INTO dww_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dabudine Yesu inam banegidima ya riuedina, “Tam aitau tenaḡa natum bo am kauma kaikaivainama Sabat raḡanine dome i kuruvana, tam Sabat raḡanine aubainama tokare nam kuya soru tavaite, bo?” ");
INSERT INTO dww_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Be taudi nam teneteneḡina da tauna sibo a paribee. ");
INSERT INTO dww_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Raḡanine Yesu e kitana be ware gabu verediḡa a vinevinedina, tauna uma wainasinama ya riuedina, ");
INSERT INTO dww_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Raḡanine aitau soie e kokonemna, nam kwa naḡo be guni poune kwa mia! Baninama deḡoda banaga ḡesaunama ya kokonena ya saḡa vavasaḡana nam maika tam e veraverauna e tavana. ");
INSERT INTO dww_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Inam raḡanine taupaka tokare tam e riuemna, ‘Kwa naḡo ḡavoe, inam banaga dosinama na gabuma.’ Dabudine tam kwa tunimayaḡa be doḡae kwa dobina. ");
INSERT INTO dww_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Vutuna aubainama raḡanine aitau soie e kokonemna, naumeki da kwa naḡo be doḡae kwa miana! Be taukokonemma e riuemna, ‘Yau tura, kwa saḡa guni poune kwa mia!’ Inam raḡanine tam tokare ta kawa saḡemna. ");
INSERT INTO dww_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Baninama aitauḡa ta kawakawa saḡe munaḡedina, taudi tokare e biri dobiḡedina. Be aitauḡa ta biribiri dobiḡa munaḡedina, taudi tokare e kawa saḡedina.” ");
INSERT INTO dww_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dabudine Yesu taupaka ya riuena, “Tam kani kwa vokaukauena raḡanine, nam am banagama bo tuatuaḡamma, am damma bo am banagama waiguyaudima kwa kokonedi, avedi, baninama taudi tokare tam ta kokonaḡaremna. ");
INSERT INTO dww_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Be tam kani kwa vokaukauena raḡanine, banaga waikaruwaḡewaḡedima be nuakududima be tuera ragaragaudima be matapotepotedima, taudi kwa kokonedina. ");
INSERT INTO dww_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Inam raḡanine tam nuavere dosinama kwa paḡona, baninama taudi nam aba ḡarodie da ta kokonaḡarem. Be didimana banegidima guriguridima ta midimidisuḡu munaḡana raḡanine, Mamaitua tam ei maesimna.” ");
INSERT INTO dww_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dabudine tauḡoma tenaḡa Yesu mate a mia da a kanikanina, nama giunama e vaiena be tauna Yesu ya riuena, “Nuavere taudi aitauḡa Mamaitua na waiguyauma nopone ta mia tenaḡa be ta kanina.” ");
INSERT INTO dww_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Be Yesu tauna ya riuena, “Raḡan tenaḡa banaga tenaḡa ya soisoina, be soinama nopone banaga toitoi ya kokonedina. ");
INSERT INTO dww_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Raḡanine soi ya vokaukaue ya kovina, da na taunoyama ya riupore da na warema riuedima aubainama. Be taunoya ware ya riuedina, ‘Ko verau! Yaba matabudi kè vokaukaua rovodina.’ ");
INSERT INTO dww_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Be ware matabudi a raugudutaraḡa da kabe adi noyama ti kenakena. Ware dokadokanama ya riuna, ‘O ebom, taugu yodi ḡoma yau doḡama è gimeri be yà naḡonaḡona kitanama aubainama. Tokare nam yà verau!’ ");
INSERT INTO dww_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Be ḡesaunama ya riuna, ‘O ebom, taugu yau kauma kaikaivaidima 10 è gimara be yodi yà naḡonaḡona yà raurubudina, aubainama da nam yà verau.’ ");
INSERT INTO dww_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Be waiḡesaunama ya riuna, ‘O ebom, taugu yodi ḡoma èi naḡina, vutuna aubainama da nam yà verau.’ ");
INSERT INTO dww_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Dabudine taunoya ya munaḡa be riudima matabudi na badama ḡarone yai maḡataridina. Naumeki be na badama nuanama yai medi kaua be na taunoyama ya riuena, ‘Kwa naḡo makai meagai dosinama nopone keda dosidie be kedasoraḡa be banaga waikaruwaḡewaḡedima be banaga tunidima nuakududima be tuera ragaragaudima be matapotepotedima taudi kwai doka verauḡedina.’ ");
INSERT INTO dww_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Naumeki da, taunoya yaba matabudi ya voia kovidi be ya riuna, ‘Bada yaba matabuna kuya riuriueguna è voiedina, be yaḡoro gabu e kenakenana.’ ");
INSERT INTO dww_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Be bada na taunoyama ya riuena, ‘Kwa naḡo diadiaḡa be banaga kwa segeridi be ta verau da yau vadama tai moḡavuna!’ ");
INSERT INTO dww_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Taugu yà riuriuemina da taudi aitauḡa noḡone è kokonedi be a gudugudu tarana nam aitau tenaḡa yau soima kaninama e sanarubu.” ");
INSERT INTO dww_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Inam raḡanine patara dosinama Yesu mate a naḡonaḡona. Be tauna yai tautinamuri ḡarodie be ya riuedina, ");
INSERT INTO dww_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Deḡoda aitau waimuriwataneguma e ḡoena, inam naumeki, be deḡoda tamanama, tinanama, na waivima, natunatunama, tuatuaḡanama, tasitasinama, nuvunuvunama bo tauname na yawasanama ei nuapaḡo guratedina, nam maika taugu, tauna nam teneteneḡina da taugu yau tauwai muriwatana. ");
INSERT INTO dww_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Be deḡoda aitau nam na korosima e kiroḡi be ei muriwatanegu, tauna nam teneteneḡina da taugu yau tauwai muriwatana. ");
INSERT INTO dww_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Deḡoda tam aitau vada dosinama kerinama kwai nuanoḡonoḡotena, noḡone tam kwa mia be kwa kita da mane teneteneḡinama, naumeki da vada kwa kerina. ");
INSERT INTO dww_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Baninama deḡoda vada pakanama kerinama kwai karena be nam teneteneḡina da kwai kovi, inam raḡanine banaga matabuna tokare vada ta kita be ta kwatevem ");
INSERT INTO dww_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","be ta riuna, ‘Uma baneginama vada kerinama yai karena, be nam teneteneḡina da ei kovi.’ ");
INSERT INTO dww_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Bo deḡoda guyau tenaḡa, na tauiḡarama 10 tausand mate muriḡa da ta naḡona iḡara aubainama, tauna noḡone e mia be ei nuanoḡonoḡota da tauna teneteneḡina bo ibewa da guyau ḡesau na tauiḡarama 20 tausand mate tai iḡara. ");
INSERT INTO dww_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Be deḡoda e noḡoti be nam teneteneḡina, naumeki da taudi madanie be banaga e riuporedina guyau ḡesau ḡarone suba waibaḡenama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Inam kauinama teneḡinama nama tam aitau am ḡoanama matabudi nam kwa gosaḡa, tam nam teneteneḡim da yau tauwai muriwatana. ");
INSERT INTO dww_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Buta inam yaba verenama. Be deḡoda buta dininama e gewagewana, tokare nema kwa voia bake da e dini munaḡa? ");
INSERT INTO dww_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Inam butanama nam sipi bo mui waidamnama mate tai rawateḡei be teneteneḡina, ibewa, inam butanama nam na noyama aba, tokare banaga ta pore kaiyatina. Deḡoda beemima ta kenakenana, naumeki da koi beavaia kauana.” ");
INSERT INTO dww_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dabudine teks tautamina be gewagewa banegidima ḡesaudima mate Yesu waibeavaienama a tavana. ");
INSERT INTO dww_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Be Parisi be tarawatu tauwai katakataidima momodu ai kare be a riuna, “Uma baneginama ko kita, tauna banaga gewegewedima ei aninedi be mate ta kanikanina.” ");
INSERT INTO dww_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Vutuna aubainama Yesu uma wainasinama ya riuedina, ");
INSERT INTO dww_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Deḡoda tam aitau am sipuma 100 be tenaḡa i kwakona, tam tokare aba sibo kuya voie? Tam tokare sipu 99 gabu verene kwa gosaḡa be kwa naḡo da tenaḡa kwa wanena, be kwa banavi da naumeki. ");
INSERT INTO dww_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Be kwa banavina raḡanine, tam ma nuavereverem ragame kwa boru ");
INSERT INTO dww_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","be kwa kiroḡa nawe munaḡena am vadae. Be dabudine am banagama kwa riu gogonidi be kwa riuedina, ‘Tài nuavere tenaḡana, baninama yau sipuma ya kwako be è banavi munaḡena.’ ");
INSERT INTO dww_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yà riuriuemina da uma kauinama teneḡinama nama marae, deḡoda banaga gewagewanama tenaḡa na noḡotama e vitarena, tauna debane tokare nuavere dosinama e tubuḡana. Be nam banaga 99 maika, taudi noḡota vitara nam tima ḡoeḡoena, baninama taudi ta noḡonoḡotina da kabe banaga didimanidi. ");
INSERT INTO dww_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Bo waivi tenaḡa ḡarone sirin matabudi 10. Be deḡoda tenaḡa i taikuruvina, tauna tokare aba sibo ya voie? Tauna kodam ya gabu, be vada ya rauḡiriḡiri be yai wanawana kauana, ya banavi da naumeki. ");
INSERT INTO dww_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Be ya banavina raḡanine, na banagama ya riu gogonidi be ya riuedina, ‘Tài nuavere tenaḡana, baninama yau sirinma taitaikuruvinama è banava munaḡena.’ ");
INSERT INTO dww_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yà riuriuemina da uma kauinama teneḡinama nama deḡoda gewagewa baneginama tenaḡa na noḡotama e vitaredina, tokare Mamaitua na aneama tai nuavere kauana.” ");
INSERT INTO dww_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu na giuma ya kaiwatani be ya riuna, “Tauḡoma tenaḡa be natunatunama tautauḡomidima rabui. ");
INSERT INTO dww_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Be tauḡoma natunama tautasinama tauna tamanama ya riuena, ‘Mamai, taugu yau sikerema kwa utegu.’ Naumeki da tamanama mane ya sikeredi da tauna na sikerema ya utena. ");
INSERT INTO dww_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Naumeki da raḡan ḡaubonaḡa be gomana tautasinama na sikerema ya ragaudi be ya naḡona wari dobue. Be dabudine bua na miae ya mia be na sikerema matabuna yai yakaredina. ");
INSERT INTO dww_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Raḡanine na sikerema matabuna yai kovina murine, inam dobunama meiḡara raḡaninama ya tavana, be tauna wainuatoitoi yai karena. ");
INSERT INTO dww_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Vutuna aubainama tauna ya naḡona inam dobunama baneginama ḡarone noya aubainama. Naumeki da dobunama baneginama tauna ya riupore nawena na bawama rabedima aubainama. ");
INSERT INTO dww_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Dabudine tauḡoma kani ya karati be bawa adi kanima sibo ya kanina, be yosi taupakinama nam i aninena. ");
INSERT INTO dww_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Inam raḡanine tauḡoma noḡota debane ya saḡasaḡana, be tauna ya riuna, ‘Tamaguma ḡarone taunoya toitoi be taudi ḡarodie kani ya toi vavasaḡana, be nam tima kanikani rovodina, be taugu uma dabudi yà miamia kanigurina. ");
INSERT INTO dww_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Taugu yà midisuḡu be yà munaḡana tamaguma ḡarone be yà riuena: Mamai, taugu gewagewa è voiena Mamaitua ḡarone be tam ḡarome. ");
INSERT INTO dww_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Taugu nam teneteneḡigu da ta riueguna tam natum; be kwa voiegu da maika am taunoyama tenaḡa.’ ");
INSERT INTO dww_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Dabudine tauḡoma ya midisuḡu be ya munaḡana tamanama ḡarone. Tauna yaḡoro madanie be tamanama yawai kita da gomana ya kita be nuanama yai poya kauana. Naumeki da tauna ya manini natunama ḡarone da natunama ya tika be yai suruvena. ");
INSERT INTO dww_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Be natunama tamanama ya riuena, ‘Mamai, taugu gewagewa è voiena Mamaitua ḡarone, be tam ḡarome. Taugu nam teneteneḡigu da ta riueguna tam natum.’ ");
INSERT INTO dww_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Be tamanama na taunoyama ya riuedina, ‘Waiḡapa ko naḡo be gara verenama ko paḡo be natuguma koi garana. Be rin nimane ko boru be kaḡasuma kaḡane ko boruna. ");
INSERT INTO dww_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kau natunama momomoninama koi guri da tà soi be tài nuaverena. ");
INSERT INTO dww_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Baninama uma natuguma tauna ya gurina, be yodi ya yawasana munaḡana, tauna ya kwakona, be yodi è banavi munaḡena.’ Naumeki da soi ai karena. ");
INSERT INTO dww_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Inam raḡanine gomana tautuaḡa tauna yaḡoro sipie. Be tauna ya munamunaḡana vadae. Be tauna vada diane ya tava da e vaiena be banaga a saresare be a bigabigana. ");
INSERT INTO dww_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Naumeki da taunoya tenaḡa ya yokoe be yai taravirena, ‘Aba e tubutubuḡa?’ ");
INSERT INTO dww_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Be taunoya ya riuna, ‘Tasimma ya tava munaḡana, aubainama tamamma kau natunama momomoninama yai gurina. Baninama natunama ya banavi munaḡena aubainama, be nam aba gewagewanama i banavina.’ ");
INSERT INTO dww_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Dabudine gomana tautuaḡa nuanama yai medi kaua be nam vadae naḡonama i ḡoena. Vutuna aubainama tamanama ya dobi be ya riuwai nuabigabigana. ");
INSERT INTO dww_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Be tauna tamanama ya riuena, ‘Kwa kita, taugu suara toitoi aubaimma è noya guratana be nam airaḡan, am riuma è rawaḡaiḡaiena. Be taugu nam airaḡan musara ḡaubonama ku ute rubugu da yau banagama mate kei nuaverena, ");
INSERT INTO dww_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","be natumma inam am mane be yaba matabuna yai yakaredina toretore waiwaividima ḡarodie. Be yodi ya tavatava munaḡana tam kau natunama momomoninama tauna aubainama kuyai gurina.’ ");
INSERT INTO dww_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Be tamanama ya riuna, ‘Taukui, tam raḡan matabuna taugu mate tà miamiana, be yaba matabuna taugu ḡaroguma, inam tam ḡaromma. ");
INSERT INTO dww_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Be yodi inam ya verena da tauda tà soi be tài nuaverena, baninama tasimma ya guri, be yodi ya yawasana munaḡana. Tauna ya kwakona, be yodi è banava munaḡena.” ");
INSERT INTO dww_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu na tauwai muriwatanama ya riuedina, “Stoa taupakinama ḡarone stoa taurabenama ya miamiana. Be banaga stoa taupakinama a riuena da tauna na stoama taurabenama mane ya danedanenedina. ");
INSERT INTO dww_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dabudine stoa taupakinama yodi stoa taurabenama ya yokoe be ya riuena, ‘Inam aba giunama ḡarome è vaie? Am noyama kuya voivoiena yà kita. Tam nam airaḡan yau stoama kwa rabe munaḡe.’ ");
INSERT INTO dww_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Be stoa taurabenama taunaḡa ya riu munaḡena, ‘Aba yodi yà voie, bada yau noyama ya kaiporena aubainama? Taugu nam wairewapanigu da noya dosinama yà voiedi, be banaga kiḡiedima taugu è tunimayaḡana. ");
INSERT INTO dww_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yodi è kataiena aba yà voie da banaga ḡesaudima ta rabeguna yau noyama e kovikovina raḡanine.’ ");
INSERT INTO dww_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Naumeki da stoa taurabenama banaga aitauḡa stoe awai bukinna banegidima ya riuedi da ḡarone a tavana. Be dokadokanama ya riuena, ‘Am bukinma bisa yau badama ḡarone?’ ");
INSERT INTO dww_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Be tauna ya paribeena, ‘Oeri duramdima 100.’ Be stoa taurabenama ya riuena, ‘Am bukinma pepanama kwa paḡo, be kwa girumina 50.’ ");
INSERT INTO dww_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Be murine ḡesau ya riuena, ‘Tam, am bukinma bisa yau badama ḡarone?’ Be tauna ya riuna, ‘Wit begidima 1 tausand.’ Be stoa taurabenama ya riuena, ‘Am bukinma pepanama kwa paḡo be kwa girumina 800.’ ");
INSERT INTO dww_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Be stoa taupakinama tauna na stoama taurabenama kaikaiyovunama ya basena, baninama stoa taurabenama na nuauyauyae na yawasanama kedanama ya voivoiena aubainama.” Be Yesu ya riuna, “Uma dobunama natunatunama mane mate waitureninama a katai kauena, nam yana natunatunama maika, ");
INSERT INTO dww_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","vutuna aubainama yà riuriuemina, banaga ḡesaudima manee gewagewa ta voivoiedina, be taumi ami manee banaga ko sagudi da bada ta banavina. Inam taudi taumi ami banagama, be tokare mane e kovina raḡanine, taumi marae tai aninemina. ");
INSERT INTO dww_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Deḡoda tam yaba ḡauḡaubodie be vere kwa voiedina, naumeki da tam teneteneḡinama tokare yaba dosidie vere kwa voiedina. Be deḡoda tam yaba ḡauḡaubodie nam vere kwa voiedi, naumeki da tam tokare nam teneteneḡina da yaba dosidie vere kwa voiedi. ");
INSERT INTO dww_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Deḡoda taumi dobu yabedima nam ko rabe kauedi, naumeki da taumi tokare Mamaitua nam ei sumaḡemi be mara yabedima e utemi. ");
INSERT INTO dww_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Be deḡoda taumi banaga ḡesaudima adi purapurama nam ko rabe kauedi, naumeki da taumi tokare Mamaitua nam ei sumaḡemi be purapura e utemi. ");
INSERT INTO dww_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nam ai taunoya teneteneḡina da babada rabui ḡarodie ei yaraga. Deḡoda e ḡoena, naumeki da noḡone badanama e tuaḡaie be murine badanama e ḡoena, bo noḡone badanama e ḡoena, murine badanama e tuaḡaiena. Taumi nam mane be Mamaitua ḡarodie koi yaraga tenaḡa!” ");
INSERT INTO dww_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Raḡanine Parisi uma riudima a vaivaiedina, taudi Yesu ai kwatekwatevena, baninama mane nuedima ya paḡona aubainama. ");
INSERT INTO dww_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Be Yesu taudi ya riuedina, “Taumi banaga matedie ko voivoia munaḡemina da kabe veremi, be Mamaitua taumi nuemima noponama ya kataiena. Yaba banaga e noḡonoḡotina da kabe yaba dosidi, be inam yabedima Mamaitua matane a gewagewa vavasaḡana. ");
INSERT INTO dww_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Noḡone taumi Mousis na tarawatuma be peroveta adi girumama ḡaromie a kenakenana. Raḡanine Jon tauwai babataito ya tavatavana, dabudine taudi adi raḡanima ya kovina. Be dabudine vari verenama Mamaitua na waiguyauma riunama yà rarau guguyena. Be banaga matabudi ta rarau rubuna da Mamaitua na waiguyauma nopone sibo a saḡana. ");
INSERT INTO dww_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mara be dobu teneteneḡinama da ta samoana, be Mamaitua na tarawatuma, avedi da ḡauboḡominama be tokare nam e samoa. ");
INSERT INTO dww_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Aitau na visarama e gose be waivi ḡesaunama e naḡina, tauna na waivima debane mui e poreporena. Be deḡo tauḡominama na waivima e tuaḡaie be e gosena, be wari tauḡoma inam waivinama e naḡina, tauna turanama debane mui e poreporena.” ");
INSERT INTO dww_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Be Yesu ya riuna, “Raḡan tenaḡa purapura baneginama tauna na garama waimatakanikanidima ya kotekotedina maesidima dosidima. Be vada maesadonanama nopone ya miamiana. Be dabudine na purapurama damnama a kenakenana. Be tauna raḡan matabuna yawai nuaverena. ");
INSERT INTO dww_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Be na vadama matakedane taukiḡikiḡi wainuatoitoinama ya kenakenana, tauna isanama Lasares. Be tauna tuninama kerokero ya moḡavuna. ");
INSERT INTO dww_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Be Lasares tauna ya kena be yawai noḡotana da purapura baneginama na kanima kurekuredima sibo ya kanidina. Be daḡadaḡasi a tavana da keronama a remoremodina. ");
INSERT INTO dww_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Naumeki da raḡan tenaḡa Lasares ya guri be anea a kiroḡa nawe da Eibraham diane ya miana. Murine purapura baneginama ya guri be a dobona. ");
INSERT INTO dww_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Be banaga guriguridima aruidima adi gabue tauna ma tunimuyana ya miamiana. Be ei kitasaḡana be madanie Eibraham be diane Lasares ya miamiana ya kitedina. ");
INSERT INTO dww_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Dabudine ya yokona, ‘Mamai Eibraham, kwa raunuatoiegu be Lasares kwa riupore da upa nimarakurakune ei buta be e yovo da menaguma ei subana, baninama taugu yàwai nuatoitoina uma kai menamenane.’ ");
INSERT INTO dww_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Be Eibraham ya riuna, ‘Natuguma, tam am raḡanie kwa noḡoti! Yaba matabudi vereveredima tam ḡarome, be Lasares tauna yaba matabuna ya marumaruabiedina. Vutuna aubainama yodi Lasares nuanuanama e subasubana, be tam kwawai nuatoitoina. ");
INSERT INTO dww_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Be yaba ḡesaudima mate inam, tam be tauma poude siḡuḡu dosinama e kenakenana. Vutuna aubainama banaga ḡarome veraunama ta ḡoeḡoena be nam teneteneḡina. Be kauinama teneḡinama nama banaga tauma ḡaromaie veraunama ta ḡoeḡoena be nam teneteneḡina.’ ");
INSERT INTO dww_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Naumeki da purapura baneginama ya riuna, ‘Inam naumeki mamai, be yàwai baḡamna da Lasares kwa riupore nawena tamaguma na vadae ");
INSERT INTO dww_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","da tasitasiguma 5 nuedima e boru da taudi nam uma tunimuya dosi kaukauinama gabune ta verau, maika taugu.’ ");
INSERT INTO dww_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Be Eibraham ya riuna, ‘Tasitasimma taudi Mousis be peroveta riudima ḡarodie da tai beavaiedina.’ ");
INSERT INTO dww_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Be purapura baneginama ya riuna, ‘Ibewa mamai Eibraham, inam nam teneteneḡina, be deḡoda banaga gurigurinama sibo i midisuḡu munaḡa be i naḡona ḡarodie, inam raḡanine taudi tokare adi noḡotama a vitaredina.’ ");
INSERT INTO dww_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Be Eibraham ya riuna, ‘Deḡoda taudi Mousis be peroveta adi giuma nam tai beavaiedi, naumeki da tokare banaga gurigurinama sibo i midisuḡu munaḡana, taudi yaḡoro nam ai sumaḡe.’” ");
INSERT INTO dww_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu na tauwai muriwatanama ya riuedina: “Raḡan matabuna yaba ḡesaudima banaga ta raurubudi da gewagewa ta voivoiedina. Be taumi aitauḡa ami banagama raurubue ko biridi be gewagewa ta voivoiedina, ko kita kauana. ");
INSERT INTO dww_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Deḡoda tam aitau yau banagama bo yau sedama gewagewae kwa biri nawedina, ya verena da tam gadome sibo yeku dosinama a pani be egasie sibo a pore nawemna. Be nam i verena da Mamaitua tokare kovoḡa dosinama e utem. ");
INSERT INTO dww_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Vutuna aubainama aba ko voivoiena, ko kita kauana. Deḡoda tauwai sumaḡa ḡesau gewagewa e voivoiena, naumeki da kwa riutuaḡaiena. Be deḡoda tauna na noḡotama e vitarena, naumeki da na gewagewama kwa noḡota porena. ");
INSERT INTO dww_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Be deḡoda ḡarome gewagewa 7 ya voiedina raḡan tenaḡa nopone, be e noḡota vitara be raḡan 7 e verau ḡarome be e riuna, ‘Ebom, taugu gewagewa ḡarome è voiedina’, naumeki da na gewagewama kwa noḡota poredina.” ");
INSERT INTO dww_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Be apasol Bada a riuena, “Ama waisumaḡama kwai morebi!” ");
INSERT INTO dww_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Be Bada ya paribeedi be ya riuna, “Deḡoda taumi ami waisumaḡama ḡaubonama yauḡana pesinama maika, inam teneteneḡinama da tokare uma kainama mobiri ko riuena, ‘Kwa nuakamoḡa ma waramim be egasie kwa pore nawem!’ Be tauna tokare e voteyeteyemina. ");
INSERT INTO dww_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Deḡoda tam aitau sibo ḡarome taunoya be tauna ya suasuata bo sipu ya raberabedina. Be raḡanine na noyama yai kovi be ya tavana vadae, tam tokare umanama kuya riu bo ibewa, ‘Yodi kwa mia be kwa kani’? ");
INSERT INTO dww_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ibewa, tam agunai tokare umanama kuya riuna, ‘Taunoya, yau kanima kwa raubuka’, be muriḡa sibo kuya riuna, ‘Yau kanima kwa vokaukaue be yà kanina. Be raḡanine taugu yà kani be yà tego rovona, murine tam kwa mia da kwa kani be kwa tegona.’ ");
INSERT INTO dww_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Inam raḡanine bada bonanama na taunoyama ya voteyeteyena aubainama, tokare ei kaiwe bo ibewa? Ibewa! ");
INSERT INTO dww_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Inam nama taumi, raḡanine yaba matabuna Mamaitua e riuriuemi be ko voivoiedina, naumeki da taumi umanama ko riuna, ‘Tauma taunoya yababa. Naumeki da ama noyama kè voiena.’” ");
INSERT INTO dww_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu ya nanaḡona Jerusalemma maika, tauna Samaria be Galili provins poudiḡa ya naḡonaḡona. ");
INSERT INTO dww_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Be raḡanine meagaie ya tavatavana, dabudi tautauḡoma kito ragaragaudima matabudi 10 Yesu ḡarone a tavana da ḡavoe a midi be bonedima dosine a yokona, ");
INSERT INTO dww_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Yesu, Bada, kwa raunuatoiemai!” ");
INSERT INTO dww_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu ya kitedi be ya riuedina, “Ko naḡo pirisi ḡarodie be koi kataiemina!” Naumeki da taudi pirisi ḡarodie a naḡonaḡona maika, taudi kedae a vere munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dabudine tauḡoma tenaḡa ya kita munaḡe da tauna ya yawasanana, naumeki da ya munaḡa be bonanama dosine Mamaitua isanama ya kaisuḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Be inam tauḡominama Yesu kaḡapakane noḡone ya beku da ya raudunee be yai kaiwena. Be inam tauḡominama, tauna Samaria baneginama. ");
INSERT INTO dww_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Be dabudine Yesu ya riuna, “Banaga matabudi 10 a yawasanana, be banaga ḡesaudima 9 deḡo? ");
INSERT INTO dww_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aba aubainama uma madani baneginama taunaḡa Mamaitua waikaiwenama ya tava, be ḡesaudima ibewa?” ");
INSERT INTO dww_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Be Yesu inam tauḡominama ya riuena, “Kwa midisuḡu be kwa naḡo, am waisumaḡama yai yawasanimna.” ");
INSERT INTO dww_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Be Parisi Yesu ai taravirena, “Airaḡan Mamaitua na waiguyauma e verau?” Be Yesu umanama ya paribeedina, “Mamaitua na waiguyauma nam aiyaba maika e verau be tokare ko kita, ");
INSERT INTO dww_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","be nam aitau e riuna, ‘Ko kita, umanema’ bo ‘Ko kita noanema.’ Baninama Mamaitua na waiguyauma inam nopomie.” ");
INSERT INTO dww_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dabudine na tauwai muriwatanama ya riuedina, “Raḡan e veraverauna e tavana raḡanine, taumi koya ḡoeḡoe guratena da Banaga Natunama na raḡanima sibo koya kitana, be tokare nam ko kita. ");
INSERT INTO dww_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Inam raḡandie banaga tokare ta riuemina, ‘Ko kita, Keriso umanema!’ bo ‘Ko kita, Keriso noanema!’ Be nam ko naḡo bo koi muriwatanedi! ");
INSERT INTO dww_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Banaga Natunama na raḡanima ei raḡantenaḡe be keama maika e kidi be gunuma matabuna e yana porena. ");
INSERT INTO dww_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Be noḡone tauna ei nuatoitoi guratana be uma kimtinama banegidima tauna ta tuaḡaiena. ");
INSERT INTO dww_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Banaga Natunama na raḡanima inam Noa na raḡanie maika: ");
INSERT INTO dww_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Banaga a kanikani, a tegotego, awai naḡi be awai naḡidina. Nama a voivoia be Noa waga ak nopone ya saḡana, be kabaita ya tubuḡa da banaga matabudi yai guridina. ");
INSERT INTO dww_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Bo Banaga Natunama na raḡanima inam Lot na raḡanie maika: Banaga a kanikani, a tegotego, a gimagimara, awai kawa gimagimara, a kumakuma be a vadavada kerina. ");
INSERT INTO dww_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Inam raḡanine Lot Sodom ya gosena, be kai menanama be yeku monamonaunidima isedima salfa marae a kuruva dobi be banaga matabudi ai guri rovodina. ");
INSERT INTO dww_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Inam kauidima teneḡidima nama banaga tokare ta voivoiedi be Banaga Natunama e maḡatarana. ");
INSERT INTO dww_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Inam raḡanine aitau da vada debane kuya miamia be am purapurama vada nopone, nam kwa naḡo be kwa ragau. Be aitau da sipie, nam vadae yaba kuya gosagosaḡana kwa noḡotidi! ");
INSERT INTO dww_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot na visarama ḡarone aba ya tubuḡana ko noḡoti! ");
INSERT INTO dww_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aitau na yawasanama dobue e raberabena, tokare na yawasanama ḡarogue e kawa gewagewana. Be aitau na yawasanama ewai utaena, naumeki da yawasana ḡarogue ya banavina. ");
INSERT INTO dww_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yà riuriuemina, inam kupine gunie banaga rabui ta kenakena be tenaḡa tokare ta nawena, be ḡesau e kena kwasana. ");
INSERT INTO dww_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Banaga rabui ta rarau riti be tenaḡa e kaiporena be ḡesau e mia kwasana.” ");
INSERT INTO dww_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(-) ");
INSERT INTO dww_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Be na tauwai muriwatanama ai taravirena, “Bada, uma kauidima deḡo dabudi ta tubuḡa?” Be tauna ya riuedina, “Deḡo musara gurinama e kenakenana, dabudine naboduba ta rawateḡeidina.” ");
INSERT INTO dww_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Naumeki be Yesu na tauwai muriwatanama wainasi ya riuedi be yai katakataidi da taudi raḡan matabuna sibo a moimoiragina, be nam a tunituaḡai. ");
INSERT INTO dww_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tauna uma wainasinama ya riuedina, “Meagai tenaḡa nopone tauwai tarapiri ya miamiana. Tauna Mamaitua nam i nainaire be banaga nam i viviviviredina. ");
INSERT INTO dww_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Be inam meagaine kaiyababa mate ya miamiana. Tauna tauwai tarapiri ḡarone ya verau be yawai baḡana, ‘Kwa kaisagugu, baninama tauwai wavuguma raḡan matabuna ewai ḡavieguna.’ ");
INSERT INTO dww_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Be kaiyababa raḡan bisanama tauwai tarapiri yai baḡana be nam i sagu rubuna. Be raḡan tenaḡa tauwai tarapiri tauname ya riu munaḡena, ‘Avedi taugu Mamaitua nam ama nainairena bo banaga nam ama viviviviredina, ");
INSERT INTO dww_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","be uma kaiyababinama e riuriu ḡasakirieguna, vutuna aubainama naumeki da yà kaisaguna, muriḡa be waiveraverau e kawa nuaḡaroguna.’” ");
INSERT INTO dww_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Be Bada ya riuna, “Tauwai tarapiri gewagewanama nema ya riu bakona, taumi koya vaie? ");
INSERT INTO dww_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Taumi ko noḡonoḡotina Mamaitua na vinevinema banegidima kupi da suara sagu ta ḡabeḡabena, nam adi nuaboyae e sagudi, bo? Bo tokare nuatauḡa e sagudi, bo? ");
INSERT INTO dww_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ibewa! Tauna waiḡapa adi nuaboyae e sagudina. Be raḡanine Banaga Natunama e tava munaḡana dobue, tauna tokare banaga waisumeḡidima e banavidi bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Banaga aitauḡa ta noḡonoḡotina da taudi kabe banaga veredi, be banaga ḡesaudima ta kitakita tuaḡaiedina. Vutuna aubainama Yesu uma wainasinama inam banegidima ya riuedina: ");
INSERT INTO dww_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Raḡan tenaḡa banaga rabui a saḡa a naḡona tempol nopone moiragi aubainama, tenaḡa Parisi be ḡesau teks tautaminama. ");
INSERT INTO dww_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Be Parisi taunaḡa ya miditeḡa be tauname aubainama ya moiragi be ya riuna, ‘O Mamaitua, yàwai kaiwemna da taugu nam ama noḡonoḡota munaḡegu be ama danedanenena, be taugu yau visarama debane nam mui ama poreporena, banaga ḡesaudima maika. Yàwai kaiwemna da taugu nam noa baneginama teks tautaminama maika. ");
INSERT INTO dww_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Taugu wiki tenaḡa nopone raḡan rabui yà widiwidinana be yau purapurama yà rawadamdamdi da matabudi 10 be tenaḡa tam yà uteutemna.’ ");
INSERT INTO dww_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Be teks tautaminama tauna noa madanie ya midimidina nam ḡaubonaḡa noḡonama i tausuḡuna marae. Tauna nimane nuakadanama ya rauriḡa be ya riuna, ‘O Mamaitua, kwa raunuatoiegu, taugu gewagewa banegiguma.’ ");
INSERT INTO dww_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Taugu yà riuriuemina, Mamaitua teks tautaminama ya kawa didimani be ya naḡona na vadae, be Parisi ibewa. Baninama banaga aitau tauname e kawakawa saḡe munaḡena, tokare Mamaitua tauna e boru dobiḡena. Be banaga aitau tauname e boruboru dobiḡa munaḡena, tokare Mamaitua tauna e kawa saḡena.” ");
INSERT INTO dww_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Banaga ḡesaudima Yesu ḡarone adi sedama a veraverauḡedina da sibo yai aiainidina. Be na tauwai muriwatanama nama a kitekitedina, taudi a riutuaḡaiedina. ");
INSERT INTO dww_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Be Yesu seda ya riuedi da ḡarone be ya riuna, “Seda ko gosedi da ḡarogue ta verauna, be nam koi ḡakedi, baninama Mamaitua na waiguyauma inam banaga maika umanama sededima aubaidima. ");
INSERT INTO dww_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Uma ko noḡoti, aitau da nam Mamaitua na waiguyauma e paḡo gomana ḡaubonama maika, naumeki da tauna inam waiguyaunama nopone nam e saḡa.” ");
INSERT INTO dww_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jius adi badama tenaḡa Yesu yai taravirena, “Tauwai katakatai veremma, aba yà voie da yawasana kenakena nonoḡinama yà paḡo?” ");
INSERT INTO dww_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Be Yesu ya riuena, “Aba aubainama kwawai isaguna vere? Nam aitau verena be Mamaitua taunaḡa. ");
INSERT INTO dww_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tam riuvavasaḡa kuya kataiedi bo ibewa? Nam monaḡemma debane mui kwa pore, nam kwa vunuḡa, nam kwa danene, nam kwa kaiyovu, tamam be tinamma kwa viviredi!” ");
INSERT INTO dww_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Be tauḡoma ya paribee be ya riuna, “Raḡanine taugu vaugue da yodi uma riudima matabudi è vovo teyeteyedina.” ");
INSERT INTO dww_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Be Yesu nama riunama ya vaivaiena, tauna ya riuna, “Yaḡoro yaba tenaḡa tam kwa gosegosena. Tam yaba matabudi ḡarome kwa gimaredi be mane banaga waikaruwaḡewaḡedima kwa utedina, be tam marae kwai purapurana. Yodibe tam taugu kwai muriwataneguna!” ");
INSERT INTO dww_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Be raḡanine tauḡoma uma riunama ya vaivaiena, tauna yai nuaboya kauana, baninama tauna yai purapura kauana aubainama. ");
INSERT INTO dww_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu inam tauḡominama ya kita be ya riuna, “Purapura banegidima taudi Mamaitua na waiguyauma nopone saḡanama ḡarodie ya piripiri kauana. ");
INSERT INTO dww_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel ya bagibagi kauana da seyau gavogavone e sonaḡana, be nama purapura baneginama tauna Mamaitua na waiguyauma nopone saḡanama ya bagibagi da bagibagi kauana.” ");
INSERT INTO dww_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Be banaga aitauḡa nama a vaivaiena ai taravirana, “Tauma kè noḡoti da purapura banegidima kabe ta naḡona marae. Be yodi deḡoda purapura banegidima nam ta yawasana, naumeki da nam aitau tokare e yawasana, bo?” ");
INSERT INTO dww_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Be Yesu ya paribeedina, “Aiyaba banaga ḡarodie nam teneteneḡina, Mamaitua ḡarone inam teneteneḡinama.” ");
INSERT INTO dww_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dabudine Pita ya riuna, “Aiyo! Tauma yaba matabudi kè gosedina tam waimuriwatanemma aubainama.” ");
INSERT INTO dww_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dabudine Yesu ya riuedina, “Yà riuriu kauemina, aitau da na meagaima bo na dosima bo tuatuaḡanama bo na visarama bo na sedama ya gosedina Mamaitua na waiguyauma aubainama, ");
INSERT INTO dww_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","naumeki da tauna yawasana veredima toitoi yodi raḡandie e banavidina. Be mate tokare yawasana kenakena nonoḡinama e veraverauna e paḡona.” ");
INSERT INTO dww_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu na tauwai muriwatanama 12 yai doka nawedi ḡavoe be ya riuedina, “Tauda tà saḡa tà naḡonaḡona Jerusalemma be dabudine yaba matabudi Banaga Natunama ḡarone ta tubuḡana, nema boni peroveta a girugirumina nama: ");
INSERT INTO dww_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jius taudi Banaga Natunama eteni banegidima nimedie ta boruna. Be taudi tai varevare, ta ḡasie, ta kaviso ");
INSERT INTO dww_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","be dabudine ta kwapu be tai gurina. Be raḡan wairabuiteḡane tauna e midisuḡu munaḡana.” ");
INSERT INTO dww_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Be tauwai muriwatana uma yabedima Yesu ya giugiuedina banidima taudi nam ti kataiedina. Be uma riudima semosemodima, vutuna aubainama taudi nam ti kataiedina. ");
INSERT INTO dww_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Raḡanine Yesu Jeriko meagainama diane ya tavatavana, dabudine tauḡoma matapotapotanama keda diane ya mia be mane ya kiḡikiḡiena. ");
INSERT INTO dww_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Be raḡanine e vaiena be banaga patara dianaḡa a naḡonaḡona, naumeki da tauna yai taravirana, “Aba e tubutubuḡa?” ");
INSERT INTO dww_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Taudi a riuena, “Yesu Nasaretma ya verau be e naḡonaḡona.” ");
INSERT INTO dww_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dabudine tauna ya yoko be ya riuna, “Yesu, Deivid natunama, kwa raunuatoiegu!” ");
INSERT INTO dww_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Be aitauḡa a dokadokana a riutuaḡaie be a riuna, “Kwai nuatuḡu!” Be tauna ya rasa guratana, “Yesu, Deivid natunama, kwa raunuatoiegu!” ");
INSERT INTO dww_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dabudine Yesu ya midi kwasa be banaga ya riuedi da tauḡoma matapotapotanama sibo a verauḡena ḡarone. Be raḡanine tauḡoma maida ya tavatavana, Yesu tauna yai taravirena, ");
INSERT INTO dww_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Aba kwa ḡoeḡoena yà voie aubaimma?” Be tauna ya riuna, “Bada, taugu yà ḡoeḡoena sibo èi kitana.” ");
INSERT INTO dww_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Be Yesu ya riuena, “Kwai kita! Am waisumaḡama yai yawasanimna.” ");
INSERT INTO dww_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Be yai raḡantenaḡe da tauḡoma matanama yai kitana. Dabudine tauna Yesu yai muriwatane be Mamaitua isanama ya kaisuḡuna. Inam raḡanine banaga matabudi nama a kitakitana, taudi mate Mamaitua isanama a kaisuḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Be Yesu Jerikoma ya tava be ya naḡonaḡona. ");
INSERT INTO dww_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Be dabudi banaga tenaḡa isanama Sakias, tauna teks tautaminama banegidima adi badama, be tauna purapura baneginama. ");
INSERT INTO dww_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tauna ya ḡoeḡoena Yesu sibo ya kitana, tauna nema maika kitana, be nam Yesu i kitana, baninama tauna banaga tuponama be patara ya moraba kauana aubainama. ");
INSERT INTO dww_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Vutuna aubainama tauna ya manini doka be kai damaya ya saḡaina Yesu kitanama aubainama, baninama Yesu inam kedanaḡa ya veraverauna aubainama. ");
INSERT INTO dww_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Raḡanine Yesu deḡo Sakias ya miamiae dabudi ya tavatavana, tauna ya midi kwasa da ya kitasaḡe be ya riuna, “Sakias, kwa yovo makai! Taugu manaka tam am vadae yà miana.” ");
INSERT INTO dww_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Naumeki da Sakias ya dobi makai be ma nuavereverena Yesu yai kaiwena. ");
INSERT INTO dww_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Banaga matabudi umanama kauinama a kitakitana raḡanine, taudi a momodu be a riuna, “Uma baneginama yodi gewagewa baneginama ḡarone e miana.” ");
INSERT INTO dww_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Dabudine Sakias ya midisuḡu be Bada ya riuena, “Bada, yau purapurama nevedima banaga waikaruwaḡewaḡedima ya utedina. Be deḡoda aitau ḡarone kaiyovue yaba tenaḡa è paḡopaḡona, naumeki da debane rabui be rabui yà taipoto be yà ute munaḡena.” ");
INSERT INTO dww_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Naumeki da Yesu tauna ya riuena, “Manaka kuvesa uma vadane ya saḡana, baninama Sakias tauna yodi ewai maḡatara munaḡena da tauna Eibraham natunama. ");
INSERT INTO dww_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Banaga Natunama ya verauna, baninama tauna banaga kwakokwakodima e wanedi be ei yawasanidina.” ");
INSERT INTO dww_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dabudine banaga awai beavaia be awai noḡotana da Mamaitua na waiguyauma kabe vutuna i tavatava, baninama Yesu kaiteka Jerusalem diane ya tavana aubainama. Vutuna aubainama Yesu wainasi ḡesaunama ya riuedina adi noḡotama kawa didimaninama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naumeki da Yesu ya riuna, “Guyau tenaḡa natunama ya naḡo wari dobue be waiguyau ya paḡona, yodibe ya munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Vutuna aubainama guyau na taunoyama matabudi 10 ya riuedi be mane isanama Mina matabudi 10 ya utedi be ya riuedina, ‘Mane ko noyedi da ta toina, muriḡa da yà tava munaḡana.’ ");
INSERT INTO dww_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Be na dobuma banegidima tauna a tuaḡaie be riu murine a riupore be Sisa a riuena, ‘Tauma inam baneginama nam kama ḡoeḡoena ḡaromaie ei bada.’ ");
INSERT INTO dww_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Be tauna yaḡoro na waibadama ya paḡo be ya munaḡana na dobue. Dabudine na taunoyama aitauḡa mane ya uteutedina ya riuedi da ḡarone a tavana, baninama tauna ya ḡoeḡoena da sibo ya kataiena, da tenaḡaḡa mane bisa a voiedi. ");
INSERT INTO dww_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Naumeki da taunoya dokadokanama ya tava be ya riuna, ‘Bada, mane kuya uteuteguna anitai potonama mate debane matabudi 10.’ ");
INSERT INTO dww_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Be na Badama ya paribeena, ‘Ya vere kauana, tam taunoya veremma. Baninama tam mane ḡaubonama be kuya noya kauena, vutuna aubainama rewapana yà uteutemna da tam meagai 10 kwai badedina.’ ");
INSERT INTO dww_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Naumeki da taunoya wairabuinama ya verau be ya riuna, ‘Bada, mane kuya uteuteguna anitai potonama mate debane matabudi 5.’ ");
INSERT INTO dww_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Be na badama ya paribeena, ‘Tam yodi rewapana yà uteutemna da meagai 5 kwai badedina.’ ");
INSERT INTO dww_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Naumeki da taunoya ḡesau ya verau be ya riuna, ‘Bada, am manema garae è suma be è semosemona umanema, ");
INSERT INTO dww_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","baninama tam banaga ḡasiḡasimma aubainama è nairemna. Yaba nam tam ḡarom be kwa ragaragaudina, tam nam kusipina be kwa ragaragaudina.’ ");
INSERT INTO dww_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Bada na taunoyama ya riuena, ‘Tam taunoya gewagewamma, tam aba kuya riuriueguna, nama tam yà etaremna. Tam kwa noḡonoḡotina da taugu kabe banaga gewagewagu be yaba taugu nam ḡarogu be yà ragaragaudina, be taugu nam e sipina be yà ragaragaudina. ");
INSERT INTO dww_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Be aba aubainama yau manema nam banike ku boru? Taugu yodi è tava munaḡana, yau manema anitai potonama mate sibo è paḡona.’ ");
INSERT INTO dww_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Dabudine tauna banaga aitauḡa diane a midimidina ya riuedina, ‘Inam taunoyanama gewagewanama ḡarone mane ko paḡo be ko naḡo da taunoya aitau ḡarone mane 10, tauna ko utena!’ ");
INSERT INTO dww_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Be banaga Bada a riuena, ‘Bada, tauna kaite mane 10 ya ragaudina!’ ");
INSERT INTO dww_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Be tauna ya paribeedina, ‘Yà riuriuemina, aitau yaba ḡarone e taipotona, naumeki tauna yaba ḡesaudima mate yà utena, be aitau da ḡarone yaba nam i taipotona, naumeki da tauna avedi da ḡaubonama ḡarone, be taugu yaḡoro yà kaiporedina. ");
INSERT INTO dww_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Be yodi aitauḡa yau ḡaviama nam ti ḡoeḡoena da taugu sibo ḡarodie èi bada, ko verauḡedi uma dabudi be noḡogue koi guridina!’” ");
INSERT INTO dww_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Be Yesu nama ya giugiuna murine, tauna ya doka ḡome be ya saḡa ya naḡona Jerusalemma. ");
INSERT INTO dww_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tauna oya Olip, diane meagai Betpage be Betanima ya tavatavana, dabudine na tauwai muriwatanama rabui ya riuporedi ");
INSERT INTO dww_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","be ya riuna, “Ko naḡo noḡomie meagaine. Be raḡanine meagaie ko saḡasaḡa, dabudi ko kitana donki natunama a nigorina. Inam donkinama natunama nam aitau i geru rubuena, vutuna ko kuvesi be ko verauḡena! ");
INSERT INTO dww_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Be deḡoda aitau ei taraviremina, ‘Aba aubainama ko kuvekuvesi?’, naumeki da ko riuena, ‘Bada e ḡoeḡoena.’” ");
INSERT INTO dww_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Naumeki da taudi a naḡo be aba Yesu ya riuriuedina, nama a banavidina. ");
INSERT INTO dww_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Raḡanine taudi donki natunama a kuvekuvesina, taupaka ya riuedina, “Aba aubainama ko kuvekuvesi?” ");
INSERT INTO dww_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Be taudi a riuna, “Bada e ḡoeḡoena.” ");
INSERT INTO dww_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Taudi ai doka nawe Yesu ḡarone be adi garama donki debane a yesidi be Yesu a boru tavaitena donki debane. ");
INSERT INTO dww_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Be raḡanine tauna kedaḡa ya naḡonaḡona, banaga adi garama kedaḡa a yesidina. ");
INSERT INTO dww_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Raḡanine tauna oya Olip isune ya tavatavana, na tauwai muriwatanama matabudi bonedima dosine Mamaitua isanama kaisuḡusuḡunama ai karena, baninama mataira matabudi a kitekitedina aubainama. ");
INSERT INTO dww_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Be taudi a riuna, “Guyau isanama tà kaisuḡu, tauna Bada isane e veraverauna!” ");
INSERT INTO dww_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dabudine Parisi ḡesaudima patara nopone Yesu a riuena, “Tauwai katakatai, am tauwai muriwatanama kwa riutuaḡaiedi!” ");
INSERT INTO dww_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Be Yesu ya riuna, “Yà riuriuemina, deḡoda taudi tai nuatuḡuna, naumeki da yeku tokare ta yogona.” ");
INSERT INTO dww_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Be raḡanine Jerusalem diane ya tava be meagainama ya kitakitana, Yesu ya ḡabana Jerusalem aubainama ");
INSERT INTO dww_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","be ya riuna, “Taumi manaka sibo suba koya paḡona, be yodi ya semona aubainama, taumi nam ko kita. ");
INSERT INTO dww_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tokare raḡan e tavana da ami ḡaviama ta verau be ta babavivirimi be ta vaḡuruvimina. ");
INSERT INTO dww_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Be taudi tokare taumi be ami sedama mate tai miagudemina. Be ami ḡaviama tokare nam aiyaba ta taugose. Uma yabedima ḡaromie ta voiedina, baninama taumi Mamaitua na kaba verauma mayanama nam ko paḡona.” ");
INSERT INTO dww_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dabudine Yesu ya naḡona tempol nopone be banaga a kunekunena ya tavu dobiḡedi ");
INSERT INTO dww_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","be ya riuedina, “Girugiruminama porane umanama ya riuna, ‘Taugu yau vadama inam moiragi kana vadama’ be taumi ko voivoiena da kabe anidanene gabuna. ");
INSERT INTO dww_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Be raḡan matabuna tauna tempol nopone yawai katakataina. Be pirisi adi babadama be tarawatu tauwai katakataidima be babada ḡesaudima mate a rawateḡeidi be a rarau rubuna da sibo Yesu ai gurina. ");
INSERT INTO dww_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Be taudi nam deḡo aniwai gurinama kedanama ti banavina da sibo ai guri, baninama banaga matabudi tauna na giuma nuedima ya paḡo be yaḡoro awai beavaiena. ");
INSERT INTO dww_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Raḡan tenaḡa Yesu tempol nopone banaga yawai katakataidi be vari verenama ya rarau guguyena, be pirisi adi babadama be tarawatu tauwai katakataidima be babada ḡesaudima mate a rawateḡeidi be a saḡana Yesu ḡarone, ");
INSERT INTO dww_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","be a riuena, “Kwa riuemai, tam aba waibadana be uma yabedima kwa voivoiedi, bo aitau uma waibadanama ya utem?” ");
INSERT INTO dww_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu ya paribeedina, “Be taugu mate taumi yai taraviremina, ko riuegu, ");
INSERT INTO dww_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon na waibadama aitau ya ute be yawai babataito, Mamaitua bo banaga?” ");
INSERT INTO dww_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dabudine taudiḡa ai saḡasaḡa be a riuna, “Deḡoda tà riuna, ‘Mamaitua ḡarone’, tauna tokare ei taraviredana, Be aba aubainama nam Jon koi sumaḡe? ");
INSERT INTO dww_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Be deḡoda tà riuna, ‘Banage’, tokare banaga matabudi yekue ta kati gabadana, baninama banaga matabudi ta noḡonoḡotina da Jon tauna Mamaitua na perovetama.” ");
INSERT INTO dww_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Vutuna aubainama taudi a riuna, “Tauma nam ke kataiena Jon waibada aikedae ya paḡo.” ");
INSERT INTO dww_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Be Yesu ya riuedina, “Naumeki, taugu mate nam yà riuemi da taugu aba waibadane uma yabedima yà voivoiedi.” ");
INSERT INTO dww_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu banaga uma wainasinama ya riuedina, “Raḡan tenaḡa banaga sipi ya voie be gureipi ya kumedina. Be banaga ḡesaudima ḡarodie sipi ya gosepore da taudi a rabena, be tauna ya naḡona wari kedae be ya mia guratana. ");
INSERT INTO dww_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Be gureipi taminama na raḡanie, tauna na taunoyama tenaḡa ya riuporena sipi taurabenama ḡarodie da na badama na dariḡama sibo ya paḡona. Be sipi taurabenama taunoya a riḡa be nimakavakavanama a riupore munaḡena. ");
INSERT INTO dww_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dabudine bada na taunoyama ḡesau ya riuporena, be sipi taurabenama inam taunoyanama mate a riḡa be yaba ḡesaudima mate a voie da tauna a kawa tunimayaḡi be nimakavakavanama a riupore munaḡena. ");
INSERT INTO dww_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Naumeki be bada na taunoyama wairabuiteḡanama ya riuporena. Be tauna mate a vunuḡi da ai kero be a rubu dobiḡena. ");
INSERT INTO dww_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Dabudine gureipi sipinama taupakinama ya riuna, ‘Yodi aba yà voie? Agunai natuguma tauḡominama, nuaguma e paḡopaḡo kauena, tauna yà riupore be taudi ta kita be dabudine ta vivirena.’ ");
INSERT INTO dww_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Be raḡanine sipi taurabedima tauna a kitakitana, ai giu vivivirana, ‘Tauna tokare tamanama na buderima e paḡona, aubainama tà vunuḡi be tauda tài buderiena.’ ");
INSERT INTO dww_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Naumeki da tauna sipie be a pore dobiḡe be ai gurina. “Be yodi taumi aba ko noḡonoḡoti, sipi taupakinama aba e voie sipi taurabedima ḡarodie? ");
INSERT INTO dww_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tauna tokare e yovo be sipi taurabedima ei guridi be gureipi sipinama waria e utedina.” Be raḡanine banaga Yesu nama ya riuriuna a vaivaiena, taudi a riuna, “Uma riunama tokare nam e tubuḡa!” ");
INSERT INTO dww_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Be Yesu ya kitadididi be yai taraviredina, “Deḡoda taugu ama kaikaiyovu, naumeki girugiruminama poranama nopone riu uma ya girugirumina, baninama aba, ‘Vada taukerinama taudi yekue vada a kerikerina, be yeku tenaḡa a pore kaiyatina, baninama taudi ai noḡotana kabe inam yeku gewagewana. Be Mamaitua inam yekunama porepore kaiyatinama ya paḡo be ya voie da na vadama yasinama ya tubuḡana.’ ");
INSERT INTO dww_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Be banaga matabudi ta beku be uma yekunama debane ta ravusedina, taudi tokare tai mia gorugorudina. Be yekunama banaga aitau debedie e ravusena, taudi tokare ei mia mutumutudina.” ");
INSERT INTO dww_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dabudine pirisi adi babadama be tarawatu tauwai katakataidima a ḡoeḡoena waiḡapa sibo Yesu a vunuḡina, baninama mayedima a paḡo da tauna taudi yawai nasiedina. Be taudi banaga a nairedina. ");
INSERT INTO dww_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Be taudi Yesu a kitakita watanina, be taukita wataninama banegidima a riuporaḡana. Taudi a voivoiana da maika kabe banaga veredi be a raurubuna da sibo Yesu a kaiyovue da aba sibo ya vato waigewana, yodibe babada dosidima ḡarodie a nawena etarenama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dabudine taukita wataninama Yesu ai taravirena, “Tauwai katakatai, tauma kè kataiena da tam raḡan matabuna kwa giugiu be kwawai katakataina matabuna riukaua. Be tam banaga nam kuma nainairedi, be Mamaitua na kauama matabuna kwa giugiuena inam riukaua. ");
INSERT INTO dww_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kwa riuemai, inam naumeki bo ibewa da tauma Sisa ḡarone kai teks?” ");
INSERT INTO dww_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Be Yesu ya kataiena da taudi a ḡoeḡoena da sibo a kaiyovuena, be Yesu ya riuedina, ");
INSERT INTO dww_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Sirin koi kataigu! Aitau noḡona be isanama sirin bogane ta kenakena?” Be taudi a paribeena, “Sisa noḡonama be isanama ta kenakenana.” ");
INSERT INTO dww_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dabudine Yesu ya riuedina, “Naumeki da Sisa ḡaronama Sisa ko utena, be Mamaitua ḡaronama Mamaitua ko utena!” ");
INSERT INTO dww_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Inam raḡanine taudi nam teneteneḡina da Yesu sibo a kaiyovue be aba ya vato waigewa. Be taudi dabudine na giuma a base be ai nuatuḡutuḡuna. ");
INSERT INTO dww_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jius nopodie dam ḡaubonama isanama Sadisi. Taudi a riuriuna da banaga e guri be nam tokare e midisuḡu munaḡa. Taudi a verau Yesu ḡarone be ai taravirena, ");
INSERT INTO dww_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tauwai katakatai, Mousis ya giruma be ya riuna, deḡoda tauḡoma ya guri be na visarama e goseporena nam waisedasedana, naumeki da tasinama tuaḡanama kaiyababinama sibo ya naḡi be seda yai tubuḡana tuaḡanama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Deḡoda tautauḡoma 7 dam tenaḡa nopone be dokadokanama waivi ya naḡi da nam ti natuna be tauḡoma ya gurina, ");
INSERT INTO dww_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","naumeki da tauḡoma wairabuinama ");
INSERT INTO dww_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","inam kaiyababinama ya naḡina. Be namaḡa da tauḡoma aniwai 7-nama ḡarone ya dobina. Be yaḡoro nam ti natunana. ");
INSERT INTO dww_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Muriḡa waivinama mate ya gurina. ");
INSERT INTO dww_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yodi nemanama? Midisuḡu munaḡa na raḡanie uma waivinama tautauḡoma 7 a naḡinaḡina, tokare aitau na waivi?” ");
INSERT INTO dww_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Be Yesu ya riuedina, “Banaga uma raḡandie ta miamiana, naumeki taudi tawai naḡina. ");
INSERT INTO dww_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Be Mamaitua na banagama gurie ta midisuḡu munaḡana raḡanine, taudi Mamaitua na dobuma ḡesaune ta mia nonoḡana, be inam raḡanine taudi nam tai naḡi. ");
INSERT INTO dww_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Be nam ta guri munaḡa, ibewa, be taudi ta miana maika anea. Taudi Mamaitua na sedama, baninama taudi gurie be a midisuḡu munaḡana aubainama. ");
INSERT INTO dww_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Be taumi Mousis na gututuma gedara kodekoderinama ko noḡoti. Inam dabudine Mousis mate yai kataidana da banaga gurie be ta midisuḡu munaḡana, baninama Mamaitua umanama Mousis ya riuena, ‘Taugu Eibraham, Aisik be Jeikob adi Mamaituama.’ ");
INSERT INTO dww_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dabudine tà kataie da Mamaitua nam banaga guriguridima adi Mamaitua, ibewa da tauna banaga yawayawasanidima adi Mamaituama. Baninama taune yaba matabudi ta yawayawasanana.” ");
INSERT INTO dww_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dabudi tarawatu tauwai katakataidima ḡesaudima Yesu a riunena, “Tauwai katakatai, tam kuya giu kauana.” ");
INSERT INTO dww_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Inam raḡanine nam aitau teneteneḡina da sibo ai taravira munaḡe, matabudi a nairana. ");
INSERT INTO dww_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Be yodi Yesu yai taraviredina, “Nemanama da tarawatu tauwai katakataidima ta riuriuna da Keriso tauna kabe guyau Deivid natuna? ");
INSERT INTO dww_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Be buka Salamo nopone Deivid tauna ya riuna, ‘Bada yau Badama ya riuena, Kasaugue kwa mia. ");
INSERT INTO dww_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Be taugu am ḡaviama yà vaḡaḡaridi be kaḡamma dibune yà biridina maika guni.’ ");
INSERT INTO dww_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Be yodi tà kita da Deivid Keriso ya riuena ‘Yau Badama’, be yodi nemanama da Keriso Deivid natuna?” ");
INSERT INTO dww_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dabudine banaga matabudi awai beavaia be Yesu na tauwai muriwatanama ya riuedina, ");
INSERT INTO dww_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Koi kita kauana tarawatu tauwai katakataidima ḡarodie. Taudi gara veredima ta kotedi be ta rarau guyaguyau naḡona, be adi ḡoanama banaga debae taudi tai kaiwedina, be sinagog nopodie bo soi nopodie taudi gabu verediḡa ragaudima ta ḡoeḡoedina. ");
INSERT INTO dww_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Be taudi kaiyababa waikaruwaḡewaḡedima adi vadama ta danedanenedi be moiragi daudaudima kaikaiyovudima ta voivoiedina da banaga kabe ta kitedi be ta basedi. Inam nama banegidima taudi tokare kovoḡa dosinama ta banavina.” ");
INSERT INTO dww_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Be Yesu yawai kita be mane banegidima ya kitekitedina tempol nopone mane a boruboruna. ");
INSERT INTO dww_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Be tauna kaiyababa waikaruwaḡawaḡanama mate ya kitana, penipeni dubedima rabui ya biridina. ");
INSERT INTO dww_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dabudine Yesu ya riuna, “Yà riuriuemina da uma kaiyababinama waikaruwaḡawaḡanama tauna na puyoma ya moraba kauana, nam maika banaga ḡesaudima nama. ");
INSERT INTO dww_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Baninama taudi ḡesaudima mane ai maurena, be tautaugosedima a raupuyoedina. Be kaiyababa tauna na manema ḡaubonama sibo na kanima ya gimarana, be matabuna ya raupuyoena.” ");
INSERT INTO dww_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu na tauwai muriwatanama ḡesaudima a riuna da tempol kitanama ya vere vavasaḡana, baninama banaga tempol yeku waimatakanikanidie ai siana, be puyo veredima mate a raupuyoedina Mamaitua ḡarone. Be Yesu ya riuna, ");
INSERT INTO dww_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Yodi uma yabedima matabudi ko kitekitedina, be raḡan e tavana uma yabedima matabudi tai kavena. Nam ai yeku tenaḡa tokare na gabue e kena.” ");
INSERT INTO dww_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Be taudi ai taravirena, “Tauwai katakatai, airaḡan uma kauidima ta tubuḡa be aba matairidima ka kitedi be ka kataie?” ");
INSERT INTO dww_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Be Yesu ya riuna, “Ko kita kaua da nam aitau ei kedadoka waigewemi, baninama banaga toitoi tokare isague ta tava be ta riuna, ‘Taugu vutuna Keriso, be raḡan damonama ya tavana.’ Be nam koi muriwatanedi! ");
INSERT INTO dww_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Be raḡanine ḡavia bo iḡara riudima ko vaiedina, nam ko naira! Inam yabedima matabudi ta tubuḡa dokana, be raḡan damonama tokare nam e tava makai.” ");
INSERT INTO dww_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Be na giuma ya kaiwatani be ya riuna, “Tokare dobu turanama dobu mate, be waiguyau turanama waiguyau mate tai kawa ḡasiḡasina. ");
INSERT INTO dww_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Be dobu ḡesaudie yoyo dosidima ta tubuḡana, be meiḡara be guriguri raḡandima ta tavana. Be yaba wainua nainairidima be mataira dosidima gunume ta tubuḡana. ");
INSERT INTO dww_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Muriḡa da uma kauidima ta tubuḡana noḡone, banaga taumi ta vunuḡimi be ta raukivi gewegewemina. Be etare ta biri nawemina, sinagog banegidima be guyaguyau be babada dosidima noḡodie, da taumiḡa ko gudutaraḡa munaḡemina. Be dabudine taumi dibure ta biri nawemina, baninama taumi taugu kowai sumaḡeguna aubainama. ");
INSERT INTO dww_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Inam kauidima ta tubutubuḡana raḡanine, taumi taugu aubaiguma koi matamatana. ");
INSERT INTO dww_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Be taumi nema sibo koya giu bakona, nam yodi koi nuaboye. ");
INSERT INTO dww_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Baninama taugu tokare giu be nuauyauya yà utemi da ami ḡaviama nam teneteneḡina da ami giuma ta riḡa bo ta mediemi. ");
INSERT INTO dww_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Taumi ami dosiḡomama, tuatuaḡemima, ami damma be ami banagama taudi tokare ta biri dobiḡemina. Be ḡesaumima tokare taudi tai gurimina. ");
INSERT INTO dww_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Be banaga matabudi ta tuaḡaiemina, baninama taumi taugu kowai sumaḡeguna aubainama. ");
INSERT INTO dww_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Be taumi deba vuvuḡimima nam tenaḡa tokare e beku waiyakare, vutuna aubainama nam koi nuaboya. ");
INSERT INTO dww_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ko midi bagibaginaḡa da aruimima koi yawasanina. ");
INSERT INTO dww_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Taumi ko kitakita be iḡara banegidima Jerusalem ta midi kwa vivirona, inam raḡanine ko kataie da ḡaubonaḡa Jerusalem ta kawa gewagewana. ");
INSERT INTO dww_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dabudine aitauḡa Judiama, taudi sibo a naḡona oyae. Be aitauḡa Jerusalem nopone, taudi sibo a dobi a naḡona. Be aitauḡa Jerusalem diane miemienidima, taudi nam sibo a saḡa Jerusalem nopone. ");
INSERT INTO dww_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Baninama inam biwa raḡaninama e tavana, boni peroveta a girugirumina, ruvane nama e tubuḡana. ");
INSERT INTO dww_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Inam raḡandie tokare waiwaivi bogebogedima be waitatau vaudima ḡarodie e gewagewa kauana, baninama inam raḡanine tokare wainuatoitoi dosinama e tubuḡana dabudine, baninama Mamaitua nuanama yai medi kauana banegidima ḡarodie aubainama. ");
INSERT INTO dww_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dabudine banaga ḡesaudima tai guridina, be ḡesaudima ta ragaudi be dobu matabuna nopodie dibure ta biri nawedina. Be eteni banegidima taudi Jerusalem ta vagudagudana, naumeki da adi raḡanima boruborune e kovina. ");
INSERT INTO dww_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Be inam raḡandie mataira ta tubuḡana suara, nawaravi be kipora bogedie. Be dobu matabuna tokare wainuatoitoi dosinama ta banavina, be banaga matabudi egasi gavasinama be rabaminama e rawanapedina. ");
INSERT INTO dww_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Inam raḡanine banaga tokare naira e kawa raugureredina, baninama taudi ta nainaira kauana da aiyabaḡa ḡesaudima gewegewedima dobue ta tubuḡana. Be rewapana matabudi gunume ta rawadaberaridina. ");
INSERT INTO dww_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yodibe Banaga Natunama ma giyouna e yovona, rewapana be neneraḡinama dosinama mate, be banaga matabudi tokare ta kitana. ");
INSERT INTO dww_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Be inam yabedima matabudi ta tubuḡana raḡanine nam ko naira, be taumi ko tausuḡumi be koi nuaverena, baninama raḡan ya tavana, da taugu yà yovoyovona yài yawasanimina aubainama.” ");
INSERT INTO dww_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dabudine Yesu uma wainasinama ya riuedina, “Damaya kainama be kai ḡesaudima mate ko noḡotidi! ");
INSERT INTO dww_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Taumi kai ta kinikinina raḡanine ko kitedi be ko kataikataiena da inam bodu raḡaninama e tavatavana. ");
INSERT INTO dww_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Be inam kauinama teneḡinama nama raḡanine inam kauidima ta tubutubuḡana ko kitekitedina, dabudine ko kataie da Mamaitua na waiguyauma raḡaninama e tavatavana. ");
INSERT INTO dww_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Taugu yà riuriu kauemina, da uma kimtinama nam ei kave be inam kauidima matabudi Jerusalemma ta tubuḡana. ");
INSERT INTO dww_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mara be dobu tokare tai kavena be taugu riuguma nam airaḡan ei kave! ");
INSERT INTO dww_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ko kita kauemi da kanidobidobi be tegobua bo dobu yawasanidima nuaboyedima nam ta taimatakoekoemi, deḡoda raḡan damonama ei raḡantenaḡe be ei ḡosorimina. ");
INSERT INTO dww_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Baninama inam raḡaninama tokare banaga matabudi dobue e kamotidina maika kwaro! ");
INSERT INTO dww_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Vutuna aubainama taumi koi neneḡana be raḡan matabuna ko moiragi da taumi tokare teneteneḡinama da uma kauidima ta tubutubuḡana, nopodiḡa ko naḡo be Banaga Natunama noḡone ko midina, be nam tokare ko tunimayaḡa.” ");
INSERT INTO dww_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu suare tempol nopone yawai katakataina, be kupie ya dobi be ya naḡonaḡona oya Olip debane, kena aubainama. ");
INSERT INTO dww_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Be banaga matabudi raḡantomtom a naḡona tempol nopone tauna waibeavaienama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Buredi-Nam-Sasasanina soinama raḡaninama ya tavatavana, isanama ‘Naḡopore soinama’. ");
INSERT INTO dww_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pirisi adi babadama be tarawatu tauwai katakataidima, taudi Yesu waigurinama kedanama a wanewanena nema sibo ai guri bakena, be taudi banaga a nairedina. ");
INSERT INTO dww_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Be Judas, tawai isana ‘Iskariot’, tauna nopone Seitan ya saḡana. Tauna tenaḡa tauwai muriwatana 12 nopodie. ");
INSERT INTO dww_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Vutuna aubainama tauna ya naḡona pirisi adi babadama be babada ḡesaudima mate ai tarapiri da nema sibo tauna Yesu ya boru dobiḡa bakena ḡarodie. ");
INSERT INTO dww_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Be taudi nuedima ya vere kaua be ai aninana da Judas sibo mane a utena. ");
INSERT INTO dww_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Naumeki da Judas mate yai aninana da tauna inam noyanama e voiena. Be keda ya wanewanena da patara matakoedie sibo Yesu ya boru dobiḡena. ");
INSERT INTO dww_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Buredi-Nam-Sasasanina soinama raḡaninama ya tavana. Be inam raḡanine dam matabudi adi sipuma tenaḡaḡa ai guridina Naḡopore soinama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dabudine Yesu tauna Pita be Jon ya riuporedi be ya riuna, “Ko naḡo be Naḡopore soinama ko vokaukaue be tà kanina.” ");
INSERT INTO dww_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Be taudi ai taravirena, “Deḡo dabudi kwa ḡoeḡoemaina soi ka vokaukaue?” ");
INSERT INTO dww_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Be tauna ya riuedina, “Taumi ko naḡo be raḡanine meagaie ko tavatavana, dabudine banaga ko banavina upa duginama e kirokiroḡina. Inam baneginama koi muriwatane da na vadae ko tavana. ");
INSERT INTO dww_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Be vada taupakinama ko riuena, ‘Tauwai katakatai umanama ya riuemna: Deḡo ware adi gabu da taugu be yau tauwai muriwatanama mate Naḡopore soinama ka kani?’ ");
INSERT INTO dww_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Be tauna vada vatavatara rabui nopone be debane vatarine dabudine gabu dosinama be yaba matabuna kawakawa nonoḡidima tauna ei kataimina. Be inam dobudine kani ko vokaukauena.” ");
INSERT INTO dww_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dabudine taudi a naḡo be Yesu ya riuriuedina yabedima nama a banavidina, naumeki da Naḡopore soinama taudi a vokaukauena. ");
INSERT INTO dww_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Naumeki da soi na raḡanima ya tavatavana, Yesu na apasolma mate a miana kani aubainama. ");
INSERT INTO dww_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dabudine tauna ya riuedina, “Nuaguma ya poyapoya vavasaḡena da uma Naḡopore soinama taumi mate sibo tè kanina, be muriḡa da taugu yài nuatoitoina. ");
INSERT INTO dww_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Baninama yà riuriuemina da taugu Naḡopore soinama nam airaḡan yà kani munaḡe naumeki da uma soinama baninama e maḡatarana Mamaitua na waiguyauma nopone.” ");
INSERT INTO dww_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Be ya giugiuna murine Yesu keyaka ya paḡo, yai kaiwa be ya riuna, “Uma ko paḡo be ko soiena! ");
INSERT INTO dww_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Baninama yà riuriuemina da yodi be nokoi ya naḡona taugu nam waen yà tego munaḡe naumeki da Mamaitua na waiguyauma e tavana.” ");
INSERT INTO dww_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Be tauna buredi ya paḡo, yai kaiwa, ya giva da ya utedi be ya riuna, “Uma taugu tubuḡiguma yà uteutemina. Yodi be nokoi e naḡona uma ko voiena taugu aninoḡotiguma aubainama.” ");
INSERT INTO dww_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Be kani murine keyaka ya paḡo be ya riuna, “Uma keyekinama inam waianina vaunama, baninama kosiniguma e rauḡinina taumi aubaimima. ");
INSERT INTO dww_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Be banaga aitau tokare e boru dobiḡeguna, be tauborudobiḡeguma tauna mate yodi uma dabudine tà miamiana. ");
INSERT INTO dww_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Banaga Natunama tokare e gurina, inam naumeki. Be aitau da ya boruboru dobiḡena, tauna tokare gewagewa dosinama e banavina.” ");
INSERT INTO dww_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dabudine apasol taudiḡa ai taraviravira munaḡedina, da aitau uma kauinama e voie. ");
INSERT INTO dww_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Dabudine apasol waisaḡasaḡa ai karena, da aitau poudie ya saḡa gurata. ");
INSERT INTO dww_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Be Yesu ya riuedina, “Dobu guyaguyaudima adi banagama ḡarodie awai badabadana, be banaga a riuedi be taudi awai isedina ‘Raukivivere banegimima’. ");
INSERT INTO dww_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Be taumi nam sibo nama! Banaga dosinama nopomie tauna sibo maika gomana, be ami badama tauna sibo maika taunoya. ");
INSERT INTO dww_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Aba taumi ko noḡonoḡoti, aitau ya saḡa gurata? Banaga e mia be e kanikanina, bo kani tausoienama? Banaga e mia be e kanikanina, tauna ya saḡa guratana! Be taugu poumie maika taunoya. ");
INSERT INTO dww_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Taumi banagimima taugu yau wainuatoitoie koya riu vaivaiteguna. ");
INSERT INTO dww_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Vutuna aubainama taugu rewapana yà uteutemina da taumi koi badana, taugu yau waiguyauma, Tamaguma ya uteuteguna nopone. ");
INSERT INTO dww_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Dabudine taumi tokare ko kani be ko tegona yau waiguyauma nopone. Be taumi waibadae ko mia be Israel damnama 12 taumi tokare ko etaredina.” ");
INSERT INTO dww_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Be Bada ya riuna, “O Saemon! Seitan Mamaitua yai baḡana da matabumi e raurubumi be e dariḡemina maika banaga raisi banidima be muidima ta daridariḡedina nama, taumi veree be e nawemina gewagewae. ");
INSERT INTO dww_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Be taugu aubaimma è moiragina da am waisumaḡama nam e beku, be raḡanine am noḡotama e verau munaḡana ḡarogue, naumeki da tam am banagama kwa voiedi da tai rewapanana.” ");
INSERT INTO dww_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Be Pita ya riuna, “Bada, taugu è vokaukauana da tam mate tà naḡona dibure be tam mate tà gurina.” ");
INSERT INTO dww_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Be Yesu ya riuna, “Yà riuriuemna Pita, tam manaka raḡan rabuiteḡa kwa bovieguna da tam nam ku kataieguna, muriḡa da kamkam e riuna.” ");
INSERT INTO dww_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dabudine Yesu yai taraviredina, “Boni taugu è riuporemina, be nam mane, nam tana be nam kaḡasuma mate, inam raḡanine taumi aba koya maruabie bo ibewa?” Be taudi a riuna, “Ibewa!” ");
INSERT INTO dww_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dabudine ya riuedina, “Be yodi na tabu, aitau ḡarone mane bo tana da e paḡona. Be aitau ḡarone kwatikwati ibewa, naumeki da tauna na rupue kwatikwati e gimerina, ");
INSERT INTO dww_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","baninama girugiruminama poranama nopone a girumina taugu aubaiguma, ‘Taudi tauna a voiena maika kabe tauvunuvunuḡa.’” ");
INSERT INTO dww_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Be apasol a riuna, “Bada, uma kwa kita, kwatikwati rabui.” Be tauna ya riuna, “Inam nakarua!” ");
INSERT INTO dww_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu vada ya dobi pore be na kaba naḡoe ya naḡona oya Olip debane. Be na tauwai muriwatanama mate ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Be raḡanine taudi Yesu ḡarone a tavatavana, tauna ya riuedina, “Ko moiragi da nam raurubue ko beku!” ");
INSERT INTO dww_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dabudine na tauwai muriwatanama ya gosedi be ya naḡo da yeku ruburubunama ruvane nama, be tuapikane doḡae ya raupari da ya moiragi ");
INSERT INTO dww_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","be ya riuna, “Mamai, taugu nam ama ḡoeḡoena ḡoraḡoranama yà sigue, be naumeki da tam am ḡoanama yà voiena, be nam taugu yau ḡoana.” ");
INSERT INTO dww_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dabudine anea marae ya yovo be ya kawa rewapanina. ");
INSERT INTO dww_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu na nuaboyama ya moramoraba guratana, vutuna aubainama tauna ya moiragi gurata, be poya kosina maika a tositosina doḡae. ");
INSERT INTO dww_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Dabudine ya midisuḡu munaḡa be ya naḡona na tauwai muriwatanama ḡarodie da e kitana be taudi matabudi ai nuaboya kaua be a kenakenana. ");
INSERT INTO dww_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Be tauna ya riuedina, “Aba aubainama ko kenakena? Ko midisuḡu be ko moiragi da taumi nam raurubue ko beku!” ");
INSERT INTO dww_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu tauna yaḡoro ya giugiu be banaga toitoi a tavana, be apasol 12 nopodie apasol tenaḡa isanama Judas, tauna inam banegidima yai dokedokedina, be Judas tauna ya saḡa da Yesu yai suruvena. ");
INSERT INTO dww_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Be Yesu ya riuena, “Judas, tam Banaga Natunama waisuruvae kwa boruboru dobiḡe, bo?” ");
INSERT INTO dww_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Be raḡanine Yesu na tauwai muriwatanama nama kauinama a kitakitana, taudi a riuna, “Bada, kwa ḡoeḡoemaina tauma ama kwatikwatima ka kwadiedi, bo?” ");
INSERT INTO dww_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Naumeki da tauḡoma tenaḡa kwatikwati ya kwadie be pirisi adi badama na taunoyama beanama kasaunama yai miarakana. ");
INSERT INTO dww_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Be Yesu ya riuna, “Avedi! Ko gose pore!” Dabudine Yesu inam tauḡominama beanama ya taukoni be yai yawasanina. ");
INSERT INTO dww_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Be Yesu pirisi adi babadama, tempol babadidima be banaga adi babadama ḡesaudima mate ya riuedina, “Taumi kwapu be kwatikwati koya kiroḡa be koya verauna taudanedanene ko vunuḡi, bo? ");
INSERT INTO dww_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Taugu raḡan matabuna taumi mate tempol nopone tè miamiana, be dabudine taumi nam ko vunuḡiguna. Be naumeki da yodi taumi ami raḡanima. Yodi tadiwanawana na waibadama raḡaninama.” ");
INSERT INTO dww_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dabudine taudi Yesu a pani be a nawena pirisi adi badama na vadae. Be Pita muriḡa yai muriwatanedina. ");
INSERT INTO dww_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Be inam banegidima taudi pirisi na vadama diane anikaba etare, dabudi kai a dena be diane a miamiana, be dabudine Pita mate diedie ya miamiana. ");
INSERT INTO dww_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Be taunoya waivinama tenaḡa e kitana be Pita kai diane ya miamiana, dabudine ya kita yaḡeyaḡe be ya riuna, “Kaua tauḡominama mate Yesu murinaḡa ya naḡonaḡona!” ");
INSERT INTO dww_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dabudine tauna ya bovi be ya riuna, “Ibewa! Taugu Yesu nam e kataiena!” ");
INSERT INTO dww_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Be a mia da raḡan ḡaubonaḡa be banaga ḡesau e kitana be ya riuna, “Tam mate Yesu turanama!” Be Pita ya riuna, “Ei, nam taugu!” ");
INSERT INTO dww_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Naumeki da a taumia raḡan ḡaubonaḡa be tauḡoma ḡesau ya riu gurata be ya riuna, “Ee, riukaua inam tauna mate Yesu yawai muriwatanena, baninama tauna Galili provins baneginama!” ");
INSERT INTO dww_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Be Pita ya riuna, “Ei badam, tam aba kwa giugiuena taugu nam e kataiena.” Be Pita yaḡoro nama ya giugiu be kamkam ya riuna. ");
INSERT INTO dww_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dabudine Bada yai tautinamuri be Pita ya kitadidina. Inam raḡanine Pita Yesu na giuma uma ya noḡotina, ‘Tam raḡan rabuiteḡa kwa bovieguna da tam nam taugu ku kataieguna, muriḡa da kamkam e riuna.’ ");
INSERT INTO dww_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Be dabudine Pita ya dobi doḡae be ya ḡaba da ya ḡaba guratana. ");
INSERT INTO dww_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Be banaga aitauḡa Yesu taukita wataninama taudi Yesu waivarevarenama be riḡanama ai karena. ");
INSERT INTO dww_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Taudi Yesu matanama a suma be a riuriuena, “Kwai peroveta da aitau kabe ya riḡam.” ");
INSERT INTO dww_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Be taudi ḡasi gewegewedima toitoi mate tauna a riuriuena. ");
INSERT INTO dww_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Raḡantomtom babada a rawateḡeidina, taudi inam pirisi adi babadama, tarawatu tauwai katakataidima be banaga adi babadama. Yodibe Yesu ai doka verauḡena ḡarodie. ");
INSERT INTO dww_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yodibe taudi Yesu ai taravirena, “Kwa riuemai, tam Keriso, bo?” Be tauna ya paribeedi be ya riuna, “Deḡoda taugu yà riuemina, taumi tokare nam koi sumaḡegu, ");
INSERT INTO dww_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","be deḡoda taugu taumi sibo èi taraviremina, taumi nam tokare koya paribeegu. ");
INSERT INTO dww_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Be yodi da nokoi ya naḡona Banaga Natunama Mamaitua wairewapana vavasaḡinama nimanama kasaune e miana.” ");
INSERT INTO dww_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dabudine taudi matabudi ai taravirena, “Tam Mamaitua Natuna, bo?” Be tauna ya riuedina, “Taumi aba ko vatovatona, vutuna taugu.” ");
INSERT INTO dww_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Be taudi a riuna, “Tauma yodi nam matamata ḡesaudima kama ḡoeḡoedina, baninama tauma matabumai kè vaiena tauna aba ya vatona.” ");
INSERT INTO dww_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dabudine banaga matabudi borue a midisuḡu be Yesu a nawena Paelat ḡarone. ");
INSERT INTO dww_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Be dabudi taudi waiwavunama ai karena be a riuna, “Tauma kè vaie da uma baneginama tauna banaga yawai doka waigewedi, be ya riuna da nam sibo Sisa ḡarone ai teks, be mate tauna ya riuna da taunaḡa guyau be Keriso.” ");
INSERT INTO dww_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Vutuna aubainama Paelat Yesu yai taravirena, “Tam Jius adi guyau, bo?” Be tauna ya riuna, “Vutuna kwa vatovatona.” ");
INSERT INTO dww_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Be Paelat, pirisi adi babadama be patara ya riuedina, “Taugu nam aba gewagewanama uma baneginama ḡarone e banavina.” ");
INSERT INTO dww_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Be taudi a riu vavasaḡana, “Tauna Jius nopone na waikatakataima, aubainama banaga nuedima ya sorusoru viviridina. Tauna Galili nopone waikatakatai yai karena da uma dobudine ya tavana.” ");
INSERT INTO dww_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Raḡanine Paelat e vaiena be banaga Galili provins a vatovatona, dabudine tauna yai taravidedina, “Tauna Galili provins banegina, bo?” ");
INSERT INTO dww_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Be dabudine e vaiena be Yesu Herod na waiguyauma nopone, naumeki da tauna ya riuporena Herod ḡarone. Baninama inam raḡanine tauna Jerusalemma ya miamiana aubainama. ");
INSERT INTO dww_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Raḡanine Herod Yesu ya kitakitana, tauna nuanama ya vere kauana, baninama tauna bonideḡo be ya ḡoeḡoena sibo Yesu ya kitana. Baninama Yesu yaba toitoi yawai tubuḡidina ya vaiena, vutuna aubainama Herod yawai noḡotana Yesu sibo mataira ya voie be tauna ya kitana. ");
INSERT INTO dww_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Be Herod giu toitoi Yesu yai taravirevirena, be Yesu nam i paribeena. ");
INSERT INTO dww_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Dabudine pirisi adi babadama be tarawatu tauwai katakataidima a midisuḡu be Yesu ai wavu vavasaḡena. ");
INSERT INTO dww_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Be Herod na tauiḡarama mate Yesu ai varavara be a raukivi gewagewa kauena. Be Herod gara waimata kanikaninama Yesu yai kote be ya riupore nawe munaḡena Paelat ḡarone. ");
INSERT INTO dww_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Inam raḡanine Paelat be Herod ai turana kauana. Be noḡone taudi awai mia taurina. ");
INSERT INTO dww_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paelat, pirisi adi babadama, babada ḡesaudima be banaga ya rawateḡeidi ");
INSERT INTO dww_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","be ya riuedina, “Taumi uma baneginama koya verauḡe ḡarogue be koya riuna da tauna banaga ya sorusoru viviridina, be taugu noḡomie è etare be è banavi da taumi ami waiwavuma matabudi nam banidi. ");
INSERT INTO dww_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Be teneḡinama Herod nama, be ya riupore munaḡena ḡarode, baninama tauna nam aiyaba i banavina da Yesu sibo ai guri. ");
INSERT INTO dww_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Vutuna aubainama taugu yodi tauna yà kovoḡi be yà riupore da e naḡona.” ");
INSERT INTO dww_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(-) ");
INSERT INTO dww_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Be banaga matabudi a rauyogo tenaḡa be a riuna, “Koi guri, be Barabas ko kaiporena tauma ama ḡoanama!” ");
INSERT INTO dww_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Be Barabas tauna dibure a boruna, baninama tauna meagai nopone iḡara dosinama yai kare, be banaga yai gurina. ");
INSERT INTO dww_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Be Paelat banaga ya riu munaḡedina, baninama tauna ya ḡoeḡoena Yesu sibo ya kaiporena aubainama. ");
INSERT INTO dww_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Be taudi Paelat a rauyogoe be a riuriuna, “Kwa tuparatu, kwa tuparatu!” ");
INSERT INTO dww_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Be Paelat raḡan wairabuiteḡanama ya riu munaḡedina, “Be uma baneginama aba gewagewanama ya voie? Taugu nam aba e banavina da yài guri! Taugu yà kovoḡi be yà riupore be e naḡona.” ");
INSERT INTO dww_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Be taudi a mia rasarasa be a ḡoeḡoena sibo Yesu a tuparatuna korosie. Be taudi yaḡoro a rasarasana. ");
INSERT INTO dww_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Dabudine Paelat nuanama ya vitare da banaga adi ḡoanama nama e voiena. ");
INSERT INTO dww_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Be tauḡoma meagai nopone iḡara yai kare be banaga yawai gurina, tauna dibure be Paelat ya riupore da ya naḡona, banaga adi ḡoanama ruvane. Be tauna Yesu taudi nimedie ya boru da adi ḡoanama nama a voiena. ");
INSERT INTO dww_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dabudine Yesu ai doka dobiḡe da a nawenawe, be kedae tauḡoma tenaḡa a banavina isanama Saemon, tauna Sairin meagainama tauḡominama. Tauna sipie be ya munamunaḡana meagaie. Naumeki da tauna a vunuḡi be korosi ai kiroḡina, be tauna Yesu ya sagu da korosi ya kiroḡina. ");
INSERT INTO dww_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Be patara dosinama tauna murinaḡa a naḡonaḡona, be nopodie waiwaivi mate, be taudi Yesu ai nuaboye be a ḡabaḡabana. ");
INSERT INTO dww_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dabudine Yesu yai tautinamuri be ya riuedina, “Taumi Jerusalem waiwaivimima nam ko ḡabegu, be taumi be ami sedama mate ko ḡaba munaḡemina! ");
INSERT INTO dww_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Baninama raḡan ta tavana da taumi ko riuna, ‘Nuavere dosinama waiwaivi kaikaipokidima ḡarodie be aitauḡa nam ti bogana be susudie nam seda ti susurubudina.’ ");
INSERT INTO dww_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Inam raḡanine banaga oya ta riuedina, ‘Debamaie ko beku da ko dobotawamai!’ Be oya ḡauḡaubodima ta riuedina, ‘Ko ruputawamai!’ ");
INSERT INTO dww_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Deḡoda taugu kai gidegideviguma ḡarogue nama banaga ta voivoiana, naumeki da banaga maika kai pokidima ḡarodie tokare aba e tubuḡa?” ");
INSERT INTO dww_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Be tauiḡaiḡara banaga gewegewedima rabui mate ai doka tenaḡedina waiguridima aubainama. ");
INSERT INTO dww_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Raḡanine taudi dobu isanama ‘Debagarere’ dabudi a tavatavana, taudi korosie Yesu a tutuna, be banaga gewegewedima rabui mate. Tenaḡa Yesu kasaunama yauwane be tenaḡa seninama yauwane. ");
INSERT INTO dww_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Be Yesu ya riuna, “Mamai kwa noḡota poredi, baninama taudi nam ti kataiena aba ta voivoiena!” Be tauiḡara Yesu na garama a kasiedina. ");
INSERT INTO dww_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Be banaga patara dabudine a midi be yaba matabuna a kitekitedina. Be babada Yesu ai kwatekwateve be a riuriuna, “Banaga ḡesaudima yai yawasanidina, be yodi taunaḡa ei yawasana munaḡe deḡoda tauna Keriso, Mamaitua na vinevinema!” ");
INSERT INTO dww_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Be tauiḡaiḡara mate waikwatekwatevenama, aubainama taudi waen wairurunama ai tego be a riuna, ");
INSERT INTO dww_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Deḡoda tam Jius adi guyauma, naumeki da kwai yawasana munaḡem!” ");
INSERT INTO dww_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Be kai ḡaubonama bogane a girumana raḡan rabuiteḡa, Gurik bonane, Letin bonane be Hibru bonane be a riuna: Uma tauna Jius adi guyauma be korosi bogane a tutuna Yesu debane. ");
INSERT INTO dww_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Be gewagewa tauḡominama tenaḡa dabudi ya dawedawena yai diboḡi be ya riuna, “Tam Keriso da kwai yawasanim be kwai yawasanimai!” ");
INSERT INTO dww_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Be gewagewa baneginama ḡesaunama turanama ya riutuaḡaie be ya riuna, “Tam wainuatoitoi teneḡinama kwa paḡopaḡona maika Yesu, vutuna aubainama tam Mamaitua sibo kuya vivirena nam kuyai diboḡi, ");
INSERT INTO dww_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","baninama tauda tà gurina dà gewagewama aubaidima inam naumeki, be tauna nam aba gewagewanama i voiena da sibo ya guri.” ");
INSERT INTO dww_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Be dabudine ya riuna, “Yesu tam am waiguyauma nopone kwa saḡasaḡana raḡanine, kwa noḡotiguna.” ");
INSERT INTO dww_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Be Yesu ya riuena, “Yà riuriu kauemna da tam manaka taugu mate paradaisie tà miana.” ");
INSERT INTO dww_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Naumeki be suaratopunama suara ya duba be dobu matabuna yai kupikupina, be nama ya kenana da ravie nama be dobu ya yana munaḡa. Inam raḡanine gara tempol nopone matakeda awai saurina poune ya nuasika poraḡa da ma nevana a kenana. ");
INSERT INTO dww_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Be Yesu bonanama dosine ya riuna, “Mamai, aruiguma nimame yà boruboruna!” Tauna nama ya riuriuna, naumeki da ya gurina. ");
INSERT INTO dww_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Dabudine Rom adi badama aba a tubutubuḡana nama ya kitakitana, tauna Mamaitua isanama ya kaisuḡu be ya riuna, “Naumeki riukaua, uma tauna inam didimana baneginama.” ");
INSERT INTO dww_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Be banaga matabudi a veraverauna Yesu tuparatunama kitanama aubainama, raḡanine aba ya tubutubuḡana nama a kitekitedina, taudi ai nuaboya kaua be nimedima nuakadedie a biridi be a munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dabudi Yesu na banagama matabudi be waiwaivi Galilima be awai muriwatanena, taudi mate ḡavoe a midi be yaba matabudi a tubutubuḡana a kitekitedina. ");
INSERT INTO dww_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Dabudine tauḡoma tenaḡa isanama Jousep. Tauna tenaḡa tauwai tarapiri badanama, be tauna na yawasanama verenama be didimaninama. Be tauna ");
INSERT INTO dww_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mamaitua na waiguyauma ya raberabena da sibo ya tavana. Be inam baneginama tauna na banagama yaba matabudi a giugiuedi be a voivoiedina tauna nam i aninedina. Tauna Jius meagaine, isanama Arimatiama, be ya verauna. ");
INSERT INTO dww_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Naumeki be tauna ya naḡona Paelat ḡarone be Yesu tubuḡinama aubainama yai baḡana. ");
INSERT INTO dww_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yodibe ya kiroḡa dobiḡe da garae ya suma be kokoaga guba voivoienama nopone ya boruna, noḡone nam aitau inam kokoagine ti boru rubuna. ");
INSERT INTO dww_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Inam raḡaninama vokaukaua na raḡanima, be Sabat raḡaninama ḡaubonaḡa e tava. ");
INSERT INTO dww_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Be dabudine waiwaivi aitauḡa Yesu Galili provins nopone ai muriwatane be a veraverauna, taudi Jousep ai muriwatane da kokoagae be nema Yesu tubuḡinama e boru bakena, vutuna kitanama aubainama. ");
INSERT INTO dww_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dabudine waiwaivi a munaḡana vadae da upa be bunama ḡabuḡabudima a vokaukauedina Yesu tubuḡinama aubainama. Be Sabat raḡanine taudi a siperena, adi tarawatuma e riuriuna nama. ");
INSERT INTO dww_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande raḡantomtom waiwaivi upa be bunama ḡabuḡabudima voivoia wainonoḡidima a kiroḡa be a naḡona kokoagae. ");
INSERT INTO dww_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Be taudi kokoagae a tavatavana, ta kitana be kokoaga matakedanama yeku waimiditomnama ya rawakui da ḡavoe ya naḡona. ");
INSERT INTO dww_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Naumeki da taudi kokoaga nopone a saḡana, be Bada Yesu tubuḡinama nam dabudine. ");
INSERT INTO dww_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Be taudi uma kauinama awai riu nuababaḡe be tautauḡoma rabui, adi garama waimatakanikanidima, ai raḡantenaḡe da diedie a maḡatarana. ");
INSERT INTO dww_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Dabudine waiwaivi a naira kaua be noḡodima doḡae ya yovona, be tautauḡoma rabui a riuna, “Aba aubainama taumi banaga yawayawasaninama banaga guriguridima nopodie ko wanewane? ");
INSERT INTO dww_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tauna nam uma dobudi. Ya midisuḡu munaḡana. Tauna boni taumi mate Galilima be nema ya riuriu bakemina, vutuna ko noḡoti! ");
INSERT INTO dww_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tauna umanama ya riuna, ‘Mamaitua ya ḡoena da Banaga Natunama banaga gewegewedima nimedie ta boru nawe da korosie ta tuparatuna. Be tauna raḡan wairabuiteḡane e midisuḡu munaḡana.’” ");
INSERT INTO dww_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dabudine waiwaivi riunama a noḡotina ");
INSERT INTO dww_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","be kokoaga a gose pore da a munaḡana apasol 11 be tauwai muriwatana ḡesaudima mate ḡarodie. Be waiwaivi yaba matabudi tauwai muriwatana a riuedina. ");
INSERT INTO dww_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Inam waiwaividima taudi Meri Magdalin, Joana be Meri tauna Jeims tinanama. Taudi be waiwaivi ḡesaudima mate uma kauidima apasol a riuedina. ");
INSERT INTO dww_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Be apasol ai noḡotana waiwaivi adi riuma kabe kaiyovu aubainama, taudi nam ti sumaḡedina. ");
INSERT INTO dww_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dabudine Pita ya midisuḡu, ya manini be kokoagae ya naḡona. Be tauna ya raudune yovo da garaḡa ya kitedina be nam aba ḡesau. Naumeki da ya munaḡana vadae, be ya nuababaḡana aba ya tubuḡa. ");
INSERT INTO dww_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Inam raḡaninama teneḡine tautauḡoma rabui taudi a naḡonaḡona meagaie, uma meagainama isanama Emaus. Be inam meagaine da Jerusalem na madanima inam 10 kilomita. ");
INSERT INTO dww_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Be taudi ma turana yaba matabudi Jerusalemma a tubutubuḡana awai giugiuedina. ");
INSERT INTO dww_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dabudine taudiḡa awai giugiu naḡo be Yesu ya tava da taudi mate a naḡonaḡona. ");
INSERT INTO dww_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Be taudi Yesu a kitana be nam ti kataiena da tauna aitau. ");
INSERT INTO dww_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Be Yesu ya riuedina, “Taumi aba kowai giugiu naḡoe?” Naumeki da taudi ma nuaboyedi a midi kwasa ");
INSERT INTO dww_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","be tauḡoma tenaḡa isanama Kleopas, tauna Yesu ya riuena, “Tamḡa Jerusalem nopone nam ku kataie da aba a tubuḡa uma raḡandie?” ");
INSERT INTO dww_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Be Yesu ya riuna, “Aba yabedi?” Be taudi a paribeena, “Yaba matabuna Nasaret Yesunama ḡarone a tubutubuḡana, vutuna ka giugiuedina. Tauna peroveta be na giuma be na voiama matabudi ai rewapana kauana yai maḡataridina, Mamaitua be banaga matedie. ");
INSERT INTO dww_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pirisi adi babadama be tauma ama babadama ai utaena Rom ḡarodie da korosie a tuparatu be ya gurina. ");
INSERT INTO dww_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Be tauma kè noḡotana da tauna kabe Israel damnama ei yawasanidi, be uma kauidima a tubuḡana yodi raḡan rabuiteḡa a kovina. ");
INSERT INTO dww_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Be manaka waiwaivi ḡesaudima ḡaromaie a riuwai nuababaḡimaina, baninama taudi raḡan tomtom a naḡona kokoagae ");
INSERT INTO dww_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","be Yesu tubuḡinama nam ti banavina. Be taudi a verau munaḡa be a riuna da anea ḡarodie a maḡatara be a riuna da Yesu ya yawasanana. ");
INSERT INTO dww_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Naumeki da tauma ama banagama ḡesaudima a naḡo kokoagae a tavana, be aba waiwaivi a riuriuena nama a kitana. Taudi Yesu nam ti kitana.” ");
INSERT INTO dww_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dabudine Yesu taudi ya riuedina, “Taumi buebuemima. Aba aubainama peroveta a riuriuna taumi nam koi sumaḡedi? ");
INSERT INTO dww_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Keriso tauna uma yabedie ei nuatoitoina muriḡa be e naḡona na neneḡarae.” ");
INSERT INTO dww_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Be dabudine Yesu peroveta adi giuma girugiruminama poranama nopone, matabudi tauna na kauama a giugiuena, taudi ya giu waibatedina. Tauna Mousis na bukae giu yai karena da peroveta ḡesaudima ḡarodie ya tavana. ");
INSERT INTO dww_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Be taudi meagai diane a tavatavana raḡanine, Yesu ya voie da kabe i dokadoka. ");
INSERT INTO dww_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Be taudi a riu vavasaḡena, “Suara ya kovina, kaiteka kupi, tauma mate tà miana!” Naumeki da tauna adi vadae ya saḡa be dabudi a miana. ");
INSERT INTO dww_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Be raḡanine kani aubainama dabudi Yesu buredi ya paḡo, da Mamaitua yai kaiwe, yodibe ya giva da ya utedina. ");
INSERT INTO dww_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Be dabudine taudi matedima ya kaya be Yesu a kataiena, be inam dabudine yai raḡantenaḡe da tauna ya samoana. ");
INSERT INTO dww_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Inam dabudine taudiḡa ai giugiu be a riuna, “Kwa noḡonoḡoti bo ibewa raḡanine kedae girugirumidima poranama ya giuedi be nuadama kai maika ya karatina.” ");
INSERT INTO dww_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Inam raḡaninama teneḡine taudi a midisuḡu be a naḡona Jerusalemma apasol 11 be ḡesaudima mate ḡarodie. ");
INSERT INTO dww_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Be taudi raḡanine Jerusalemma vadae a saḡasaḡana, dabudine tauwai muriwatana inam banegidima rabui a riuedina, “Bada riukaua ya midisuḡuna, tauna Saemon ḡarone ya maḡatarana.” ");
INSERT INTO dww_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dabudine tautauḡomidima rabui aba kedae ḡarodie ya tubutubuḡana tauwai muriwatana ai varidina. Be mate taudi ai varidina da Yesu buredi ya givagivana raḡanine, taudi a kataiena da tauna aitau. ");
INSERT INTO dww_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Taudi inam kauinama yaḡoro a giugiue be Yesu tauna ḡominama poudie ya raumidire be ya riuedina, “Suba ḡaromie e kenana.” ");
INSERT INTO dww_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Be taudi a ḡosoridi be naira nopodima ya moḡavuna, baninama taudi ai noḡotana kabe ḡaḡarua ti kitakita. ");
INSERT INTO dww_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Be tauna ya riuedina, “Taumi aba aubainama ko nainaira be nopomima e vovo raḡaraḡa? ");
INSERT INTO dww_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nimagu be kaḡaguma ko kitedi be ko kataie da inam taugu. Be ko taukonigu da ko kataiegu da taugu nam ḡaḡarua, baninama ḡaḡarua taudi nam visiḡodi bo turiḡidi taugu maika.” ");
INSERT INTO dww_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesu nama ya riuriuna, naumeki da tauna nimana be kaḡanama yai kataidina. ");
INSERT INTO dww_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Inam raḡanine taudi nuedima ya vere kaua be a mosamosari koena be nam ti sumaḡena. Vutuna aubainama tauna ya riuedina, “Kani ḡaromie e kenakena bo ibewa da taugu yà kani?” ");
INSERT INTO dww_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Be taudi iyana gabugabunama nevanama a utena. ");
INSERT INTO dww_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Be tauna ya paḡo be matedie ya kanina. ");
INSERT INTO dww_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dabudine Yesu ya riuedina, “Dokane taugu taumi mate raḡanine be è riuemina da yaba matabudi Mousis na tarawatuma, peroveta be Salamo nopodie a girugirumidina taugu aubaiguma, nama yodi ta tubutubuḡana.” ");
INSERT INTO dww_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dabudine Yesu taudi noḡota ya sagudi da taudi girugiruminama poranama a noḡoti be a kataiena, ");
INSERT INTO dww_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","be ya riuedina, “Girugiruminama porane umanama a girumina: Keriso ei nuatoitoi be raḡan wairabuiteḡane guriguridima nopodie tauna e midisuḡu munaḡana. ");
INSERT INTO dww_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Be tauna na rewapanae noḡota vitara be noḡota poraḡa dobu matabudi nopodie ta rauguguyedina. Be rauguguya inam Jerusalemma tai karena. ");
INSERT INTO dww_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Be taumi inam kauidima matabudi adi matamatama. ");
INSERT INTO dww_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Taugu Tamaguma aba ya riuriueguna, tokare yà riuporena taumi ḡaromie. Be taumi Jerusalem meagaine ko miana, naumeki da Mamaitua na rewapanama ko paḡona.” ");
INSERT INTO dww_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Naumeki da Yesu na tauwai muriwatanama Jerusalem meagaine be yai doka nawedina Betenima. Dabudine tauna nimanama ya kaisuḡudi be na tauwai muriwatanama yai aiainidina. ");
INSERT INTO dww_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Be tauna yawai aiainidina maika, Mamaitua tauna ya nawena marae. ");
INSERT INTO dww_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Be tauwai muriwatana tauna a raudunee be nuedima ya vere vavasaḡana, be ma mosaridi a munaḡana Jerusalemma. ");
INSERT INTO dww_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Be raḡan matabuna taudi tempol nopone a mia be Mamaitua isanama a kaikai suḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Boni pakane muriḡa da dobu ya tubuḡana, Riu taunaḡa ya kenakenana. Be Riu tauna Mamaitua mate. Be inam Riunama vutuna tauna Mamaitua. ");
INSERT INTO dww_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Inam Riunama tauna boni pakane Mamaitua mate a miamiana. ");
INSERT INTO dww_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Inam Riune yaba matabudi a tubuḡana. Be tauna ibewa, yaba yodi ta kenakenana tokare nam a tubuḡa. ");
INSERT INTO dww_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tauna ḡarone yawasana ya kenakenana. Be inam yawasaninama vutuna banaga adi kodamma. ");
INSERT INTO dww_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Be inam kodamnama tadiwanawanae e yanayanana, be tadiwanawana nam teneteneḡina da inam kodamnama sibo ya suragaba. ");
INSERT INTO dww_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Be Mamaitua banaga tenaḡa ya vinena isanama Jon, ");
INSERT INTO dww_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","be ya riu pore da banaga ḡarodie inam kodamnama e giuena, be inam giune banaga matabudi sibo ai sumaḡa. ");
INSERT INTO dww_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon tauna nam kodam. Ibewa, tauna ya verauna kodamnama e rauguguyena. ");
INSERT INTO dww_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Riukaua kodamnama ya veraverauna dobue, vutuna banaga ewai yanedina. ");
INSERT INTO dww_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tauna vutuna dobu be yaba matabuna ya voiedina. Be tauna dobue ya miamiana raḡanine, banaga yaḡoro tauna a nuababaḡena. ");
INSERT INTO dww_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tauna ya yovona na dobue, na banaga ḡomama ḡarodie, be taudi nam ti aninena. ");
INSERT INTO dww_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Be aitauḡa tauna ai anine be isane awai sumaḡana, taudi vutudi yai aninedi da Mamaitua natunatunama a tubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Taudi nam banaga kosinine ti tubuḡana. Be taudi nam tubuḡa na ḡoane bo banaga na ḡoane ti tubuḡana, ibewa da Mamaitua ḡarone a tubuḡa vitarana. ");
INSERT INTO dww_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Riu yai rawabanaga be ḡarode dobue ya miana. Tauna raukivivere be riukaua noponama ya moḡavuna. Be Mamaitua na neneḡarama matabuna nuanuanama Natunama tenaḡa ḡominama ya uteutena tauma kè kitana. ");
INSERT INTO dww_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon inam baneginama vutuna ya rauguguye be ya riuna, “Uma baneginama vutuna boni umanama è riuriuemina, ‘Banaga murigue e veraverauna tauna ya saḡa vavasaḡana, nam maika taugu. Baninama muriḡa da taugu è tubuḡana, tauna boni nama miemieninama.’” ");
INSERT INTO dww_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Be na raukiviveree tauna vere toitoi tabu be tabu ya utedana, ");
INSERT INTO dww_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","raukivivere be riukaua Yesu Kerisoe a verauna. Be Mousis tauna tarawatu taunaḡa ya utedana. ");
INSERT INTO dww_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nam aitau airaḡan Mamaitua i kita rubuna, be Natunama tenaḡa ḡominama tauna vutuna Mamaitua, Tamanama nuanuane miemieninama, vutuna Mamaitua ḡarode yai maḡatarina. ");
INSERT INTO dww_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalemma Jius babadidima taudi pirisi be Livait banegidima a riupore nawedina Jon ḡarone, da ai taravire be sibo a kataiena tauna aitau. ");
INSERT INTO dww_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Be Jon riukaue ya paribeedi be ya riuna, “Taugu nam Tauwai yawasana.” ");
INSERT INTO dww_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dabudine taudi ai taravira munaḡena, “Be tam aitau? Peroveta Elaija, bo?” Be tauna ya riuna, “Ibewa.” Be taudi ai taravira munaḡena, “Mamaitua ya sausaugena peroveta raḡan damone e tavana, vutuna tam, bo?” Be tauna ya riuna, “Ibewa.” ");
INSERT INTO dww_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Be yodi tam aitau? Tam giu baninama kwa ute yaḡemai be tauma ka paḡo da ka munaḡe be tauriuporemaima kai varidina. Tam nema kwa noḡonoḡota bakem, tam aitau?” ");
INSERT INTO dww_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Be tauna ya paraibeedi be peroveta Aisaia na giue ya riuedina, “Taugu vutuna banaga dobu kavakavane bonanama dosine umanama e riuriu, ‘Bada na kedama ko kawa didimani.’” ");
INSERT INTO dww_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dabudine Parisi adi banagama a riuriuporedina Jon waitaravirenama aubainama. ");
INSERT INTO dww_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Taudi Jon ai taravire be a riuna, “Deḡoda tam nam Keriso bo Elaija bo Mamaitua peroveta ya sausaugena, naumeki da aba aubainama tam yodi banaga kwawai babataitodi?” ");
INSERT INTO dww_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Be Jon ya paribeedi be ya riuna, “Taugu upae yàwai babataitona be banaga tenaḡa poumie nam ko kataiena, ");
INSERT INTO dww_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","tauna vutuna tokare murigue e tavana, be taugu nam veregu da tauna na kaḡasumama yà kaiporaḡa.” ");
INSERT INTO dww_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Inam kauidima matabudi Betenima a tubuḡana, upa Jodan be noaḡo nevane. Inam dabudine Jon banaga yawai babataitodina. ");
INSERT INTO dww_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pomainama Jon Yesu ya kitana, ḡarone ya veraverauna, be Jon ya riuna, “Ko kita, tauna vutuna Mamaitua Na Sipuma. Banaga sipu natunama ta vunuḡi be ta tipatipana, nama Mamaitua Na Sipuma yai utaena da banaga adi gewagewama dobue e koḡa poredina. ");
INSERT INTO dww_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uma baneginama vutuna boni taugu umanama è riuriuemina, ‘Banaga murigue e veraverauna, tauna ya saḡa vavasaḡana, nam maika taugu. Baninama muriḡa da taugu è tubuḡana, tauna boni nama miemieninama.’ ");
INSERT INTO dww_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Noḡone taugu nam e kataiena da aitau Keriso, be taugu è verau be upae banaga èi babataitodina da tauna Israel banegidima ḡarodie e maḡatarana.” ");
INSERT INTO dww_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Be Jon umanama ya riuna, “Taugu è kitana Arua Babau marae be ya yovona kiu gabubu maika, be Yesu debane ya miana. ");
INSERT INTO dww_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Noḡone taugu nam e kataiena da tauna Keriso be Mamaitua taugu upae waibabataito aubainama ya riuriuporeguna raḡanine, umanama ya riueguna, ‘Tam tokare Arua kwa kitana e yovo be banaga aitau debane e miana, tauna vutuna tokare Arua Babaue ei babataitona.’ ");
INSERT INTO dww_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Taugu uma kauinama nama è kitana Yesu ḡarone ya tubuḡana. Vutuna aubainama yà riuriu kauemina da tauna vutuna Mamaitua Natuḡominama.” ");
INSERT INTO dww_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pomainama Jon ya tava munaḡa be na tauwai muriwatanama rabui mate a midimidina. ");
INSERT INTO dww_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Be raḡanine Jon e kitana be Yesu dianaḡa ya naḡonaḡona, inam dabudine tauna ya riuna, “Ko kita, tauna vutuna Mamaitua Na Sipuma.” ");
INSERT INTO dww_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Be Jon na tauwai muriwatanama rabui inam riunama a vaivaiena raḡanine, taudi Yesu ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Dabudine Yesu yai tautinamuri da taudi ya kitedi be yai taraviredina, “Aba ami ḡoana?” Be taudi a paribee be a riuna, “Rabai, tam deḡo dabudine am kaba mia?” (Giu ‘Rabai’ baninama inam ‘Tauwai katakatai’) ");
INSERT INTO dww_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Be Yesu ya riuedina, “Ko verau ko kita.” Naumeki da 4 okoroki nama taudi tauna mate a naḡona na kaba miae be dabudine a mia kupina. ");
INSERT INTO dww_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Inam tauwai muriwatanidima rabui, be tauḡoma tenaḡa isanama Endru, tauna Saemon Pita tuaḡanama. ");
INSERT INTO dww_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dabudine Endru aba ya voiena inam noḡone ya naḡo tasinama Saemon ya wane, be ya riuena, “Tauma Mesaia kè banavina.” Mesaia baninama inam Keriso. ");
INSERT INTO dww_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naumeki da Endru Saemon yai doka verauḡena Yesu ḡarone, be Yesu Saemon ya kita be ya riuena, “Tam Saemon, Jon natunama be yodi tokare yài isamna ‘Kipas’ inam baninama ‘Pita’.” ");
INSERT INTO dww_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pomainama Yesu Galili naḡonama yai taina. Be kedae tauna Pilip ya banavi be ya riuena, “Kwai muriwatanegu!” ");
INSERT INTO dww_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip tauna Betsaida baneginama maika Endru be Pita. ");
INSERT INTO dww_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Naumeki da Pilip Nataniel ya banavi be ya riuena, “Tauma Tauwai yawasana kè banavina. Inam Nasaret Yesunama Jousep natunama. Tauna vutuna Mousis na tarawatue be peroveta adi bukae a girugirumina.” ");
INSERT INTO dww_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Be Nataniel yai taravirena, “Tam aitau ya riuem da tokare Nasaretma vere e tubuḡa?” Be Pilip ya riuena, “Kwa verau be kwa kita.” ");
INSERT INTO dww_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Be Yesu e kitana, be Nataniel tauna ḡarone ya veraverauna. Dabudine Yesu ya riuna, “Uma riukaua Israel baneginama, tauna nam kaiyovu nopone ima kenakenana.” ");
INSERT INTO dww_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dabudine Nataniel Yesu yai taravirena, “Tam nemanama taugu kuya katai bakegu?” Be Yesu ya paribeena, “Taugu tam kai damaya pakane è kitamna, muriḡa da Pilip ya riuem be koya verauna.” ");
INSERT INTO dww_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dabudine Nataniel Yesu ya riuena, “Tauwai katakatai, tam riukaua Mamaitua Natunama, be Israel guyaunama tam.” ");
INSERT INTO dww_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Be Yesu ya riuena, “Tam kai damaya pakane è kitam be è riuemna aubainama kuyai sumaḡa, bo? Be nam inam vutunaḡa, tam yaba ḡesaudima dosidima mate tokare kwa kitedina. ");
INSERT INTO dww_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Be yà riuriu kauemina da taumi tokare ko kitana mara e nuaporaḡa be Mamaitua na aneama ta saḡasaḡa be ta yovoyovona Banaga Natunama ḡarone.” ");
INSERT INTO dww_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Raḡan wairabuiteḡane matakopa soinama Keina meagaine ya tubuḡana Galili provins nopone. Be Yesu tinanama mate dabudine. ");
INSERT INTO dww_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu be na tauwai muriwatanama mate a kokonedina inam soinama aubainama. ");
INSERT INTO dww_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Be waen ya kovina raḡanine, Meri Yesu ya riuena, “Banaga adi waenma ya kovina.” ");
INSERT INTO dww_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Be Yesu ya riuna, “Tam be taugu dà noyama dabudine nam ima kenakenana. Taugu yau raḡanima nam i tavana.” ");
INSERT INTO dww_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dabudine Yesu tinanama taunoya ya riuedina, “Aba tauna e riuriuemina, naumeki da ko voiena.” ");
INSERT INTO dww_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Inam dabudine vaivai raukoḡanama kadi dugima matabudi 6 a midimidina. Dugidima a moraba vavasaḡana, tenatenaḡaḡa 100 lita ruvanama. ");
INSERT INTO dww_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Be Yesu taunoya ya riuedina, “Uma dugidima matabudi upa koi moḡavudina.” Naumeki da taudi dugi upa ai moḡavu taritaridina. ");
INSERT INTO dww_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yodibe taudi ya riuedi da upa dugi nopone a redu be soi taupakinama a utena. Yesu aba ya riuriuena, nama taudi a voiena. ");
INSERT INTO dww_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Be soi taupakinama upa e tego rubuna be upa yai rawawaenna. Be soi taupakinama nam i kataiena da uma waennama aikedae be ya tava, be taunoya aitauḡa upa tauredunama, taudiḡa a kataiena. Dabudine soi taupakinama naḡivau tauḡominama ya riue da ḡarone ya tava ");
INSERT INTO dww_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","be umanama ya riuena, “Tam waen dinidininama vutuna sibo kuya soi dokena, be ware a tegotego buana murine, tam waen ḡesaudima tometomedima sibo kuya soiedina. Tam aba aubainama waen verenama kuya rabe kwase be yodi kuya dobiḡe?” ");
INSERT INTO dww_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Uma inam Yesu mataira pakanama voienama yai karena Keina meagaine, Galili provins nopone. Inam kedane tauna neneḡarinama yai maḡatari be na tauwai muriwatanama ai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Matakopa soinama murine Yesu be tinanama, tasitasinama be na tauwai muriwatanama mate a naḡona Kapeniam meagaine. Be taudi dabudine a taumiana raḡan bisanama. ");
INSERT INTO dww_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Be Naḡopore soinama raḡaninama ya tavatavana aubainama, Yesu ya saḡa ya naḡona Jerusalemma. ");
INSERT INTO dww_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Be dabudine tempol nopone taukune banegidima ya kitedina, taudi kau, sipu be kiu bunebune a gimagimaredina. Be mane tauwai sensinama banegidima mate ya kitedina dabudine a miamiana. ");
INSERT INTO dww_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dabudine Yesu kwapu taie ya voie, yodibe taukune, sipu, kau mate, matabudi tempol nopone be ya tavu dobiḡedina. Be mate mane tauwai sensinama banegidima adi vatarama ya rika be mane doḡae yai yaraiedina. ");
INSERT INTO dww_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Be taudi aitauḡa kiu bunebune a rarau gimaredina ya riuedina, “Uma yabedima ko nawedi ḡavoe! Tamaguma na vadama nam ko voie da anikune gabunama e tubuḡa!” ");
INSERT INTO dww_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Uma kauinama ya tubutubuḡana raḡanine, na tauwai muriwatanama aba giruma porane a girugirumidina vutuna a noḡotina: “Taugu am vadama nuaboyanama nopogue kai maika e vakivakina.” ");
INSERT INTO dww_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Dabudine Jius babadidima Yesu a riuena, “Mataira kwa voie be tauma ka kita be ka kataie da tam ḡarome rewapana e kenakenana, aubainama uma kauidima kwa voivoiedina.” ");
INSERT INTO dww_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Be Yesu taudi ya riuedina, “Uma tempolnama ko katiwei be taugu raḡan rabuiteḡa nopodie tokare yà keri munaḡena.” ");
INSERT INTO dww_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Be Jius a paribee be a riuna, “Uma tempolnama modi matabudi 46 nopodie a kerina. Be tam nema raḡan rabuiteḡa nopodie kwa keri munaḡa bake?” ");
INSERT INTO dww_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Be Yesu aba tempolnama ya giugiuena, inam tauna tubuḡa ḡominama ya giugiuena. ");
INSERT INTO dww_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Be Yesu ya guri be ya midimidisuḡu munaḡana raḡanine, na tauwai muriwatanama uma giudima Yesu ya vatovatodina a noḡotidina. Be taudi Yesu na giuma be girugiruminama poredie aba a riuriuena ai sumaḡedina. ");
INSERT INTO dww_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Raḡanine Yesu Jerusalemma Naḡopore soinama nopone ya miamiana maika, tauna mataira toitoi ya voiedina, dabudine banaga toitoi mataira a kitedi be Yesu isane ai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Be Yesu inam banegidima adi yawasanama nemanama, tauna ya kataiedina, vutuna aubainama tauna nam i sumaḡedina. ");
INSERT INTO dww_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tauna nam i ḡoeḡoena da aitau tenaḡa ya naḡo tauna ḡarone be banaga adi yawasanama sibo ya giue, baninama tauna kaite banaga nopodima matabuna ya kataiedina. ");
INSERT INTO dww_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Raḡan tenaḡa Nikodimas tauna Yesu ḡarone ya tavana. Nikodimas tauna Parisi, Jius adi badama tenaḡana. ");
INSERT INTO dww_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tauna kupie giu aubainama Yesu ḡarone ya verau be ya riuna, “Tauwai katakatai, tauma kè kataiena da tam Mamaitua ya riuporemna tauma waikatakataimaima aubainama. Baninama am matairama tawai maḡatarana da tam Mamaitua ya riuporemna.” ");
INSERT INTO dww_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Be Yesu ya paribee be ya riuena, “Yà riuriu kauemna, deḡoda tam nam kwa tubuḡa vitara, Mamaitua na waiguyauma nopone tokare nam kwa saḡa.” ");
INSERT INTO dww_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dabudine Nikodimas ya riuna, “Deḡoda banaga kaite ya moraba poraḡana, tauna tokare nema e tubuḡa vitara bako? Nema tinanama kapone e saḡa munaḡa bako be e tubuḡa vitara?” ");
INSERT INTO dww_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Be Yesu ya paribee be ya riuena, “Yà riuriu kauemna, banaga upae be Arua Babaue nam e tubuḡa vitara, tauna tokare Mamaitua na waiguyauma nopone nam e saḡa. ");
INSERT INTO dww_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tubuḡa yawasaninama inam banage e tubutubuḡana, be yawasana arue inam Arua Babaue e tubutubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taugu è riuna da tam sibo kuya tubuḡa vitarana, be inam riunama nam ei basem. ");
INSERT INTO dww_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sive e manimaninina na ḡoane nama e naḡonaḡona. Tam gugurinama kwa vaivaiena, be deḡo yai kare be aikedae e naḡonaḡona nam ku kataiena. Inam kauinama teneḡinama nama aitau da Arue e tubutubuḡana, tam tokare nam kwa kataie.” ");
INSERT INTO dww_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Be Nikodimas Yesu yai taravirena, “Uma kauinama nema tokare e tubuḡa bako?” ");
INSERT INTO dww_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Be Yesu ya riuna, “Tam Israel adi tauwai katakataima be uma kauinama nam ku kataie, bo? ");
INSERT INTO dww_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Taugu yà riuriu kauemna, tauma aba kè katakataiena vutuna ka giugiuena, be aba kè kitekitedina kawai maḡataridina. Be yaḡoro taumi banegimima tauma ama giuma nam komawai aninedina. ");
INSERT INTO dww_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Taugu dobu kauidima è giuemi be nam koi sumaḡedina, vutuna aubainama anikitanama mara yawasanidima yà giuedina, be taumi tokare nam koi sumaḡa. ");
INSERT INTO dww_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nam aitau marae i naḡo rubuna, ibewa da Banaga Natunama taunaḡa noteḡo ya yovona. ");
INSERT INTO dww_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Boni Mousis dobu kavakavane mota brons voivoienama kai bogane yai dawena. Inam kauinama teneḡinama nama Banaga Natunama tokare kai bogane tai dawena, ");
INSERT INTO dww_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","be aitauḡa tauna tawai sumaḡena, taudi tokare yawasana kenakena nonoḡinama ta paḡona, ");
INSERT INTO dww_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","baninama Mamaitua dobu nuanama ya paḡo vavasaḡena aubainama, nuanuanama Natunama tenaḡa ḡominama yai utaena. Be aitauḡa tauna tawai sumaḡena, taudi tokare nam ta kodena, ibewa da yawasana kenakena nonoḡinama ta paḡona. ");
INSERT INTO dww_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mamaitua nam dobu kovoḡinama bo kawa gewagewanama aubainama Natunama i riuporena, ibewa da tauna dobu waiyawasaninama aubainama ya riuporena. ");
INSERT INTO dww_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Aitau da tauna ewai sumaḡena, Mamaitua inam baneginama nam imawai tara tautauena. Be aitau da tauna nam imawai sumaḡena, Mamaitua inam baneginama kaite yai tara tautaue be e miamiana, baninama inam baneginama Mamaitua Natunama tenaḡa ḡominama isanama nam i sumaḡena aubainama. ");
INSERT INTO dww_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Baninama uma aubainama waitaratautau ya tubuḡana: Yana dobue ya yovona be banaga tadiwanawana a ḡoe vavasaḡena, nam maika yana, baninama taudi adi voiama matabudi gewegewedima aubainama. ");
INSERT INTO dww_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Banaga aitauḡa gewagewa ta voivoiedina taudi yana nam tima ḡoeḡoena. Inam banegidima tokare nam yana nopone ta verau, baninama taudi ta nainairana deḡoda adi gewagewama tima maḡatara aubainama. ");
INSERT INTO dww_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Be banaga aitauḡa da riukaue ta miamiana, taudi yana nopone ma nuaveredi ta veraverauna, da banaga matabudi taudi sibo a kitedi be a kataie da taudi Mamaitua na ḡoanama ta voivoiedina.” ");
INSERT INTO dww_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Inam kauidima muridie Yesu na tauwai muriwatanama mate a naḡona Judia provinsnama nopone be dabudine taudi raḡan bisanama a rautapa miana be banaga awai babataitodina. ");
INSERT INTO dww_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Inam raḡanine Jon mate tauna Salim diane Aionma yawai babataitona, baninama dabudine upa dosinama aubainama. Be banaga raḡan matabuna a tavatavana babataito konorinama. ");
INSERT INTO dww_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Uma kauinama noḡone ya tubuḡana, muriḡa da Jon dibure a boru nawena. ");
INSERT INTO dww_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Naumeki da raḡan tenaḡa vaivai raukoḡanama debane waikawa riuriu ya nuasarina Jon na tauwai muriwatanama be Jius baneginama tenaḡa mate. ");
INSERT INTO dww_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jon na tauwai muriwatanama a verau tauna ḡarone be a riuena, “Tauwai katakatai, tauḡoma noḡone Jodanma be noaḡo nevane tè banavi be tam kuya riuna tauna Tauwai yawasana, tauna vutuna yodi banaga ewai babataitodina. Be banaga matabudi tauna ḡarone ta naḡonaḡona.” ");
INSERT INTO dww_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Be Jon ya paribeedi be ya riuna, “Mamaitua marae tauna banaga tenatenaḡaḡa adi noyama e vinevinedina. ");
INSERT INTO dww_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Taumi koya kataiena da taugu patare è riuemina da taugu nam Tauwai yawasana. Mamaitua taugu ya riuporeguna da Bada na kedama yà kawa didimanina, inam vutunaḡa. ");
INSERT INTO dww_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Waivi tokare e naḡona na ḡoapaparama ḡarone. Be waivi na ḡoapaparama ḡarone e tavatavana raḡanine, tauḡoma turanama tokare nuanama e vere kauana. Be tauḡoma turanama inam taugu. ");
INSERT INTO dww_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tauna banaga dosinama e tubuḡana, be taugu naumeki da yà ḡaubona. ");
INSERT INTO dww_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tauna marae be ya yovona aubainama, tauna yaba matabuna ya saḡa poredina. Be taugu dobu banegiguma, vutuna aubainama taugu yau noḡotama na ruvae yaba yà giugiuedina. Be tauna marae be ya yovona, vutuna aubainama tauna ya saḡa vavasaḡana. ");
INSERT INTO dww_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tauna marae yaba ya kitekitedi be ya vaivaiedina, vutudi ya riuedana. Be banaga raubisaḡa tawai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Be banaga aitauḡa da tauna na giuma tawai sumaḡena, taudi tawai kawa riukauana da Mamaitua tauna riuriu kauinama. ");
INSERT INTO dww_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Be Mamaitua banaga ya riuriuporena, tauna Mamaitua riunama e giugiuena, baninama tauna noponama Mamaitua Aruinama yai moḡavu taritarina. ");
INSERT INTO dww_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamanama Natunama nuanama ya paḡo kaue be yaba matabuna Natunama nimane ya biridina. ");
INSERT INTO dww_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Aitau da Mamaitua Natunama ei sumaḡena, tauna yawasana kenakena nonoḡinama ya paḡona. Be aitau da Mamaitua Natunama e tuatuaḡaiena, tauna tokare nam yawasana e banavi, baninama Mamaitua na medima tauna ḡarone tokare e kena nonoḡana.” ");
INSERT INTO dww_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisi ta vaiena be Yesu ya naḡo be banaga toitoi yai babataitodi be tauna awai muriwatanena, be na tauwai muriwatanama a toi kauana, nam maika Jon. ");
INSERT INTO dww_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Be Yesu tauna nam banaga iwai babataitodina, ibewa, tauna na tauwai muriwatanama taudiḡa banaga awai babataitodina. ");
INSERT INTO dww_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Raḡanine Yesu e vaiena be tauna aba ya voivoiena, Parisi kaite a kataiena, vutuna aubainama tauna Judia ya gose be ya munaḡana Galilima. ");
INSERT INTO dww_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tauna Galili naḡonama aubainama Samaria kedanaḡa ya naḡona. ");
INSERT INTO dww_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Naumeki da tauna Samaria nopone meagai isanama Saikama ya tavana. Boni Jeikob natunama Jousep doḡa ya utena, Saika meagainama diane. ");
INSERT INTO dww_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Inam dabudine Jeikob na upama domnama e kenakenana. Suaratopu nama Yesu ya babara siauana aubainama, inam upanama diane ya mia be ya siperena. ");
INSERT INTO dww_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Dabudine Samaria waivinama ya tavana upa redunama aubainama, be Yesu inam waivinama ya riuena, “Upa kwa utegu be yà tego.” ");
INSERT INTO dww_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Be Yesu na tauwai muriwatanama taudi inam dabudine nam mate. Taudi a naḡona meagaie kani gimeridima aubainama. ");
INSERT INTO dww_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Dabudine Samaria waivinama Yesu ya base be ya riuena, “Tam Jius banegimma be taugu Samaria waiviguma, be aba aubainama tam taugu kwa riuriueguna da upa yà utem?” Tauna nama ya riuna, baninama Jius banegidima nam airaḡan Samaria banegidima mate tiwai rawateḡeidina. ");
INSERT INTO dww_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Dabudine Yesu ya paribee be ya riuena, “Deḡoda tam Mamaitua na puyoma sibo ku kataiena, naumeki da taugu mate sibo kuya kataieguna, inam raḡanine tam tokare kuyai baḡagu be yawasana upanama sibo è utem be kuya tegona.” ");
INSERT INTO dww_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dabudine waivi ya riuna, “Bada, tam anirau redu ḡarome nam ima kenakenana da upa kwa redu, dom ya dau kauana. Yawasana upanama nema kwa redu bake? ");
INSERT INTO dww_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Waḡawaḡadama waḡedima Jeikob uma upanama ya uteutemaina, tam tauna kuya saḡapore, bo? Jeikob be na sedama be na yosima mate uma upanama a tegotegona.” ");
INSERT INTO dww_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Be Yesu inam waivinama ya paribee be ya riuna, “Aitauḡa uma upane ta tegotegona, taudi tokare nuedima e raukasakasa munaḡana, ");
INSERT INTO dww_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","be aitau da upa taugu yà ute be e tegona, tauna nam airaḡan nuanama e raukasakasa munaḡa. Be uma upanama taugu yà ute be tauna nopone bigabiga maika e manini watanana, be yawasana kenakena nonoḡinama e paḡona.” ");
INSERT INTO dww_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dabudine waivi ya riuena, “Inam upanama kwa utegu da nam airaḡan nuaguma e raukasakasa munaḡa be uma dabudine upa redunama aubainama nam yài veraverau.” ");
INSERT INTO dww_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Be Yesu inam waivinama ya riuena, “Kwa naḡo be am tauḡomama kwa riue be mate ko verauna.” ");
INSERT INTO dww_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Dabudine waivi ya riuna, “Ai, taugu nam ei naḡina.” Be Yesu ya riuena, “Inam riukaua, ");
INSERT INTO dww_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","be tam noḡone tautauḡoma 5 kuya naḡidina, be tauḡoma yodi vadae kuya gose be kuya verauna inam nam tam am tauḡoma.” ");
INSERT INTO dww_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dabudine waivi ya riuna, “Taugu yodi è kataie da tam peroveta. ");
INSERT INTO dww_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tauma tamatamamaima uma oyanama debane Mamaitua a rarau duneena. Be taumi Jius ko riuriuna da Jerusalem inam vutuna aniraudune gabunama, be dabudine banaga sibo Mamaitua a rauduneena.” ");
INSERT INTO dww_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Be Yesu waivi umanama ya riuena, “Aba yà riuriuena, kwai sumaḡena, raḡan e veraverauna e tavana, inam raḡanine banaga uma oyanama debane Tamadama ta raudunee bo Jerusalemma ta rauduneena, inam nam aiyaba, inam matabuna naumeki. ");
INSERT INTO dww_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Taumi Samaria banegimima Mamaitua ko rarau duneena nam ko katai kauena. Be tauma kè katai kaue be ka rarau duneena, baninama Tauwai yawasana tokare Jius ḡarodie be e verauna. ");
INSERT INTO dww_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Be raḡan e veraverauna e tavana, vutuna yodi ya tavana. Arua Babau na rewapanama banaga nopodie e noyanoyana da taudi riukaue Tamadama Mamaitua ta rauduneena. Tamadama Mamaitua inam nama rauduneenama e ḡoeḡoe kauena. ");
INSERT INTO dww_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Baninama Mamaitua tauna Arua, vutuna aubainama taurauduneenama taudi naumeki da Arue be riukaue ta rauduneena.” ");
INSERT INTO dww_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Dabudine waivi Yesu ya riuena, “Taugu è kataiena da Tauwai yawasana tawai isana Keriso, tauna e veraverauna. Tauna e tavana raḡanine, tokare yaba matabudi ḡaromaie e giu waibatedina.” ");
INSERT INTO dww_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dabudine Yesu ya riuna, “Inam vutuna taugu, yodi tam mate tàwai giuna.” ");
INSERT INTO dww_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Inam raḡanine Yesu na tauwai muriwatanama a tava munaḡa da ta kitana be Yesu inam waivinama mate awai giuna, dabudine taudi a base kauena. Be nam aitau Yesu i taravirena da tauna aba inam waivinama ḡarone ya ḡoeḡoe, bo aba aubainama inam waivinama mate awai giu. ");
INSERT INTO dww_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dabudine waivi upa duginama ya gose pore da ya munaḡana meagaie be banaga umanama ya riuedina, ");
INSERT INTO dww_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ko verau be tauḡoma tenaḡa ko kita. Tauna abaḡa boni è voivoiedina matabuna ya giuedina. Tauna agunai Tauwai yawasana?” ");
INSERT INTO dww_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Naumeki da banaga meagai a gose pore be a naḡona Yesu ḡarone. ");
INSERT INTO dww_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Inam kauidima a tubutubuḡana maika, tauwai muriwatana Yesu a riuena da tauna kani sibo ya kanina. ");
INSERT INTO dww_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Be Yesu ya paribeedi be ya riuna, “Taugu yau kanima e kenakenana yà kanina, taumi nam ko kataiena.” ");
INSERT INTO dww_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dabudine tauwai muriwatana ai giu vivira be a riuna, “Banaga aitau agunai muriḡa ya tava, be kani ya utena.” ");
INSERT INTO dww_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Be Yesu ya riuedina, “Taugu yau kanima inam tauriuporeguma na ḡoanama yà voiena, be noya ya uteuteguna yai kovina. ");
INSERT INTO dww_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Taumi ko riuriuna da nawaravi 4 ta kovi be muridie maura e ravusana. Be yodi ko kita, maura kaiteka ya tavana. ");
INSERT INTO dww_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Maura taurawatupanama, taudi tokare adi maesama verenama ta paḡona. Be maura ta rawarawa tupatupana inam giunama, baninama taudi banaga ta veraverauḡedina Mamaitua na waiguyauma nopone. Be taukuma be maura taurawatupanama, taudi rabuidi tokare tai nuavere tenaḡana. ");
INSERT INTO dww_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Inam riunama ‘Banaga ḡesau taukuma, be banaga ḡesau maura taurawatupanama’, inam riukaua. ");
INSERT INTO dww_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Avedi da taumi nam ko sipina, be taugu è riuporemina da maura ko rawatupetupedina. Banaga ḡesaudima a noyana be taumi nonoḡinama ko rawatupatupana.” ");
INSERT INTO dww_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Dabudine Samaria banegidima toitoi inam meagaine Yesu ai sumaḡena, baninama waivi umanama ya giuna aubainama, “Taugu abaḡa boni è voivoiedina, matabuna tauna ya giuedina.” ");
INSERT INTO dww_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Be Samaria banegidima Yesu ḡarone a tavatavana raḡanine, taudi Yesu ai baḡana da mate sibo adi meagaie a miana. Naumeki da Yesu taudi mate raḡan rabui kavakava a miana. ");
INSERT INTO dww_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Be Yesu na rauguguyama kana taiye banaga riba ai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Dabudine taudi waivi a riuena, “Noḡone tauma am giuma aubainama kèi sumaḡana, be yodi tauma mabimaie tauna na giuma kè vaie be kèi sumaḡana, yodi kè kataiena da tauna riukaua Tauwai yawasana dobu matabuna aubainama.” ");
INSERT INTO dww_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Be raḡan rabui muridie Yesu inam meagainama ya gose, be ya naḡona Galilima. ");
INSERT INTO dww_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ko noḡoti da Yesu boni ya riuna da peroveta na dobu ḡomae nam tima vivivivirena. ");
INSERT INTO dww_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tauna Galilima ya tavatavana raḡanine, Galili banegidima ai aninena, baninama taudi na voiama dosidima Jerusalemma Naḡopore soinama nopone a kitedina aubainama. ");
INSERT INTO dww_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Be Yesu na vaḡaie ya munaḡana Keinama deḡo maiḡone upa ya voie be yai rawawaenna. Be inam meagaine gabeman tenaḡa ya miamiana, tauna natunama tauḡominama Kapeniamma ya sida kauana. ");
INSERT INTO dww_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Inam tauḡominama e vaiena be Yesu Judiaḡa ya veraverauna Galilima. Naumeki da tauna Yesu yai baḡana da tauna na vadae sibo ya naḡo be natunama yai yawasanina, inam gomeninama ḡaubonaḡa da sibo ya gurina. ");
INSERT INTO dww_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Be Yesu ya riuena, “Taumi sibo koyawai sumaḡana, be nam mataira kitanama koyawai rabe.” ");
INSERT INTO dww_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Be gabeman ya riuna, “Bada, kwa verau makai muriḡa da natuguma e gurina.” ");
INSERT INTO dww_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Be Yesu gabeman ya riuena, “Kwa naḡo natumma ya yawasana.” Be gabeman Yesu aba ya riuriuena yai sumaḡe be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Gabeman tauna ya munaḡa ya naḡonaḡo be na taunoyama kedae a banavi be a riuena, “Natumma ya yawasanana.” ");
INSERT INTO dww_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dabudine gabeman taudi yai taraviredina da suara aba gomana ya yawasana. Be taudi gabeman a paribee be a riuna, “Maiḡo suaratopu 1 okoroki poyapoya gomana ya gosena.” ");
INSERT INTO dww_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Be dabudine gomana tamanama e noḡotina be maiḡo inam suerinama nama ruvane Yesu ya riuna, “Natumma ya yawasanana.” Dabudine tauna be na vadama noponama banegidima mate, matabudi Yesu ai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Uma inam mataira aniwai rabuinama Yesu Galili provinsne ya voiena. ");
INSERT INTO dww_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Uma kauinama muridie Yesu ya saḡa ya naḡona Jerusalemma Jius adi soima aubainama. ");
INSERT INTO dww_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Be Jerusalem gananama bogane matakeda tenaḡa, inam Sipu adi matakedama. Be inam matakedanama diane topa ya midimidina, Hibru bonane tawai isana Betesda. Be inam topanama dianaḡa banaga sidesidedima adi vaguruma kerikeridima matabudi 5 a midimidina. ");
INSERT INTO dww_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Be vagurudima nopodie anikaba miae banaga sidesidedima toitoi a miamiana. Banaga ḡesaudima matapotepotedima, ḡesaudima kaḡa nuakudukududima, be ḡesaudima nuakudukududima. ");
INSERT INTO dww_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Taudi awai rabana da upa sibo yai burukwakwakwana. ");
INSERT INTO dww_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Be nopodie banaga tenaḡa dabudine kaḡanama ya nuakuduna modi 38 a kovina. ");
INSERT INTO dww_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu inam tauḡominama doḡae ya kenakenana ya kitana, be ya vaie da inam tauḡominama sida bonideḡo ya paḡona. Dabudine Yesu inam tauḡominama yai taravirena, “Tam yawasana kwa ḡoeḡoe bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Be tauḡoma ya paribee be ya riuena, “Bada, topa ewai dagudaguna raḡanine, taugu nam aitau turagu da ya sagugu be topae sibo è naḡo. Taugu topae naḡonama yàwai taina raḡanine, banaga ḡesaunama kaite e dokadoka ḡomena.” ");
INSERT INTO dww_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dabudine Yesu tauḡoma ya riuena, “Kwa midisuḡu, am duyama kwa paḡo be kwa naḡo.” ");
INSERT INTO dww_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Inam dabudine yai raḡantenaḡe da tauḡoma ya yawasanana, be na duyama ya paḡo da ya naḡona. Inam kauinama Sabat raḡanine ya tubuḡana, ");
INSERT INTO dww_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","vutuna aubainama Jius babadidima tauḡoma ya yawayawasanana umanama a riuena, “Manaka Sabat! Tarawatu e riuriuna tam am duyama nam kwa kiroḡi!” ");
INSERT INTO dww_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Be tauḡoma ya paribeedi be ya riuna, “Banaga tauwai yawasaniguma tauna ya riueguna, ‘Am duyama kwa kiroḡi be kwa naḡo.’” ");
INSERT INTO dww_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Be taudi tauḡominama ai taravirena, “Inam ai banaga nama ya riuem da tam am duyama sibo kuya kiroḡi, wa?” ");
INSERT INTO dww_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Be tauḡoma nam i kataiena aitau tauna yai yawasani, baninama Yesu patara nopodie ya rausonaḡe be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Muriḡanama Yesu inam tauḡominama tempol nopone ya banavi be ya riuena, “Yodi kuya kita, tam kuya yawasanana. Nam gewagewa kwa voia munaḡe, da tokare nam kai matane kwa naḡo.” ");
INSERT INTO dww_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Naumeki da tauḡoma ya naḡo be Jius babadidima yai varidina da Yesu tauna yai yawasanina. ");
INSERT INTO dww_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesu Sabat raḡandie noya ya voivoiedina. Vutuna aubainama Jius babadidima tauna raukivigewegewenama ai karena. ");
INSERT INTO dww_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Be Yesu taudi ya riuedina, “Taugu Tamaguma raḡan matabuna na noyama è voivoiena naumeki da yodi. Vutuna aubainama taugu mate yà noyanoyana.” ");
INSERT INTO dww_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Uma giudima aubainama Jius a rarau rubu guratana da sibo Yesu ai gurina, nam Sabat tarawatunama waikatikotovinama taunaḡa debane, ibewa be mate tauna ya riuriuna da Mamaitua inam tauna Tamaḡominama. Be inam kauine tauna kabe Mamaitua i ruvaruva. ");
INSERT INTO dww_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Be Yesu umanama ya paribeedina, “Taugu yà riuriu kauemina da Mamaitua Natunama nam tokare mabine aba e voiedi, ibewa. Tauna Tamanama abaḡa ya voiedi be ya kitakitana, vutudiḡa tauna e voivoiedina. ");
INSERT INTO dww_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Baninama Tamanama Natunama nuanama ya paḡona aubainama, yaba matabudi ya voivoiedina nama tauna Natunama yai katai be e voivoiedina. Be Natunama tokare voia ḡesaudima dosidima mate e voiedi be ko basedina, be nam banaga waiyawasaninama taunaḡa. ");
INSERT INTO dww_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tamanama banaga gurie be e kawakawa midisuḡu munaḡedina, be kauinama teneḡinama nama Natunama na ḡoane banaga gurie be e kawa midisuḡu munaḡedi, be yawasana ta paḡopaḡona. ");
INSERT INTO dww_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Be Tamanama etara matabudi Natunama nimane ya biridina ");
INSERT INTO dww_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","da banaga matabudi sibo Natunama a vivirena Tamanama ta vivivivirena maika. Be aitauḡa Natunama nam tima vivivivirena, taudi Tamanama mate nam tima vivivivirena, baninama Tamanama tauna vutuna Natunama ya riuporena. ");
INSERT INTO dww_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Taugu yà riuriu kauemina aitauḡa da yau giuma ta vaivaie, be tauriuporeguma tawai sumaḡena, taudi yawasana kenakena nonoḡinama kaite a paḡona, be nam tokare ta naḡo gienae. Taudi gurie be a davuna yawasanae. ");
INSERT INTO dww_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Be mate yà riuriu kauemina da raḡan e veraverauna e tavana, vutuna yodi ya tavana. Inam raḡanine banaga guriguridima taudi taugu Mamaitua Natunama bonaguma tai beavaiena, be aitauḡa bonaguma ta vaivaiena, taudi tokare yawasana ta paḡona. ");
INSERT INTO dww_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Taugu nama è riuemina, baninama Tamaguma tauna vutuna yawasana pakanama, be inam yawasaninama tauna nopone e kenakenana. Be tauna ya voie da Natunama mate nopone inam yawasaninama e kenakenana. ");
INSERT INTO dww_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Be tauna rewapana Natunama ya utena da banaga e etaredina, baninama tauna vutuna Banaga Natunama. ");
INSERT INTO dww_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nam ko base da raḡan e veraverauna e tavana, inam raḡanine banaga kokoagae kenekenedima matabudi tokare Mamaitua Natunama bonanama ta vaie be ta midisuḡuna. ");
INSERT INTO dww_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Be aitauḡa vere a voivoiena, taudi ta midisuḡu be ta yawasana nonoḡana. Be aitauḡa gewagewa a voivoiena, taudi ta midisuḡu be gienae ta naḡona, inam vutuna adi kovoḡama. ");
INSERT INTO dww_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Taugu nam nuague yaba ama voivoiedina, ibewa da Tamaguma yaba ewai aninedina ruvane, nama yà voivoiedina. Vutuna aubainama yau rauetarama inam didimaninama, baninama tauriuporeguma ya riuriueguna, ruvane nama banaga yà etaetaredina, be nam taugu yau ḡoane. ");
INSERT INTO dww_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Deḡoda taugume yai matamata munaḡeguna, tokare yau giuma nam tai kawa riukaue. ");
INSERT INTO dww_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Be taugu è kataiena da tauwai matemateguma ḡesau tauna taugu e giugiueguna, inam matabuna riukaua. ");
INSERT INTO dww_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Taumi boni tauwai noyanoya koya riupore nawedina Jon ḡarone, be tauna ḡarodie taugu ya giueguna inam matabuna riukaua. ");
INSERT INTO dww_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Taugu Jon na giuma yà riuriu wainoḡotimina da taumi yawasana ko banavina. Be taugu yau matamatama inam nam banaga ḡoma. ");
INSERT INTO dww_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon tauna kodam maika ya yanayanana, be taumi na yanae ami ḡoanama ruvane raḡan ḡaubonaḡa koyawai nuaverena. ");
INSERT INTO dww_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jon aubaiguma aba ya giugiuemina, inam matabuna ya verena. Be taugu yau matamatama vere vavasaḡidima inam voia dosidima, Tamaguma ya uteuteguna yà voivoiedina. Inam voiedima dosidima tawai maḡatarana da taugu Tamaguma ya riuporeguna. ");
INSERT INTO dww_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Be Tamaguma tauriuporeguma tauna mate aubaiguma riukaue e giugiuna. Be taumi nam airaḡan bonanama ko vaie bo noḡonama ko kitana. ");
INSERT INTO dww_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tauna ya riuporeguna be taumi nam koi sumaḡeguna, vutuna aubainama na giuma nopomie nam tima kenakenana. ");
INSERT INTO dww_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Taumi buka poredima ko sievidi be kowai nuanoḡonoḡotedina da kabe yawasana kenakena nonoḡinama dabudine ko banavi. Be inam bukanama taugu e giugiueguna, ");
INSERT INTO dww_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","taumi sibo ḡarogue koya verau be yawasana koya paḡona. Be taumi debemima ya bado kauana. ");
INSERT INTO dww_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Deḡoda taumi ko kawa saḡegu bo ibewa, inam giudima taugu ḡarogue nam banibiribiridi, ");
INSERT INTO dww_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","baninama taugu è kataiena da taumi nopomie Mamaitua nam komawai nuapaḡoena. ");
INSERT INTO dww_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Taugu Tamaguma isane ḡaromie è yovona, be taumi nam koi anineguna. Be deḡoda banaga ḡesau tauname isane ḡaromie e tavatavana, taumi kowai aninena. ");
INSERT INTO dww_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Vutuna aubainama taumi nam teneteneḡina da koi sumaḡegu, baninama taumi ami banagama ta kawa saḡemina, vutuna ko ḡoeḡoe guratena. Be Mamaitua sibo taumi ya kawa saḡemina, taumi nam koma ḡoeḡoena. ");
INSERT INTO dww_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Be taugu tokare Tamaguma ḡarone nam ya samanimi. Taumi ami voiama maika kabe Mousis kowai muriwatane be kowai sumaḡe. Be Mousis tauna tokare Tamaguma ḡarone e samanimina, ");
INSERT INTO dww_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","be deḡoda taumi Mousis koi sumaḡena, naumeki da taugu mate sibo koyai sumaḡeguna, baninama Mousis na bukae taugu mate ya giueguna. ");
INSERT INTO dww_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Be deḡoda tauna aba ya girugirumidina nam koi sumaḡedi, naumeki da taugu yau giuma tokare nema koi sumaḡa bakedi?” ");
INSERT INTO dww_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Raḡan bisanama muridie Yesu wagae ya geru be yawawa Galilima ya davu be ya naḡona noaḡo nevane gerese. Be inam yawawinama isanama ḡesau ta riuriuna: Taiberias yawawinama. ");
INSERT INTO dww_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Be patara dosinama Yesu ai muriwatanena, baninama tauna mataira dosidima banaga sidesidedima ḡarodie ya voivoiedina aubainama. ");
INSERT INTO dww_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dabudine Yesu tauna ya saḡa ya naḡona oyae be na tauwai muriwatanama mate a miana. ");
INSERT INTO dww_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Be Naḡopore soinama raḡaninama kaiteka maida ya tavatava be uma kauidima a tubuḡana.) ");
INSERT INTO dww_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Be Yesu patara ya kitedi be tauna ḡarone a saḡasaḡana, dabudine tauna Pilip ya riuena, “Kani deḡo tà gimara be uma banegidima tai kanidi?” ");
INSERT INTO dww_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tauna nama ya riuna Pilip raurubunama aubainama, be Yesu kaite ya katai munaḡena da tauna tokare aba e voiena. ");
INSERT INTO dww_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Be Pilip ya paribee be ya riuna, “Ai Bada, deḡoda tauda ḡarode 200 Denari sibo i kena be kani sibo tè gimarana, yaḡoro uma patarinama matabuna tokare nam tei kanidi be teneteneḡina.” ");
INSERT INTO dww_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dabudine Saemon Pita tuaḡanama Endru ya riuna, ");
INSERT INTO dww_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Uma gomeninama tauḡominama ḡaubonama, tauna ḡarone buredi 5 be iyana rabui ta kenakenana. Be inam nam teneteneḡina uma patara ya moraba kauana.” ");
INSERT INTO dww_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dabudine Yesu na tauwai muriwatanama ya riuedina, “Banaga matabudi ko riuedi da ta mia.” Naumeki da banaga matabudi mui debedie a miana. Be tautauḡoma sievinama 5 tausand nama. ");
INSERT INTO dww_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Naumeki da tauna buredi ya ragaudi, da Mamaitua yai kaiwe be patara ḡarodie buredi ya soiedina. Be murine kauinama teneḡinama nama iyana ya voiena. Be banaga matabudi a kani da a kani siauana. ");
INSERT INTO dww_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Be banaga a kanikani kovina murine, Yesu na tauwai muriwatanama ya riuedina, “Yodi ko naḡo be kani kanikani gosedima matabudi ko rawateḡeteḡeidi, nam i verena da kani tai yakaredi.” ");
INSERT INTO dww_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Naumeki da taudi buredi kanikani gosedima matabudi a rawateḡeteḡeidi be posa matabudi 12 ai moḡavudina. ");
INSERT INTO dww_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Be raḡanine banaga uma matairinama nama a kitakitana, taudi a riuna, “Tauna vutuna riukaua da peroveta boni a riuriuena yodi ya tavana.” ");
INSERT INTO dww_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu ya kita da taudi a ḡoeḡoena da tauna sibo a kawa guyau makaiena. Vutuna aubainama Yesu taunaḡa ya rausonaḡe be oya debane ya naḡona. ");
INSERT INTO dww_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Naumeki da ravi ya tavana, be Yesu na tauwai muriwatanama ḡarodie nam i tava munaḡana. Vutuna aubainama taudi a dobi be a munaḡana gerese. Be dabudine wagae a geru da yawawa a davu be a naḡona Kapeniamma. ");
INSERT INTO dww_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Taudi a taunaḡo ḡaubonaḡa be sive dosinama yai ravusa be rabama yai karena. ");
INSERT INTO dww_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Inam raḡanine ta kitana be Yesu topa debanaḡa ya babara be ḡarodie ya naḡonaḡona. Dabudine taudi a naira kauana, ");
INSERT INTO dww_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","be tauna ya riuedina, “Taugu! Nam ko naira!” ");
INSERT INTO dww_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dabudine tauwai muriwatana a ḡoeḡoena da tauna sibo a soru tavaitena wagae. Be yai raḡantenaḡe da waga kaite noaḡo nevane gerese ya midimidina. ");
INSERT INTO dww_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pomai raḡanboiboi patara muridie a gosegosedina, taudi Yesu a raberabena, baninama taudi maiḡo ravie a kita da waga tenaḡa kavakava dabudine ya midimidina be tauwai muriwatana taudiḡa inam wagane a geru da a naḡona, be nam Yesu mate. ");
INSERT INTO dww_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Be waga ḡesaudima Taiberiasḡa a veraverauna a tava da deḡo Bada buredi yai aiaini be banaga a kanikanina, dabudine a ḡotana. ");
INSERT INTO dww_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Raḡanine patara ta kitana be Yesu be na tauwai muriwatanama mate taudi nam dabudi, naumeki da inam wagedie a geru be a munaḡana Kapeniamma Yesu wanenama aubainama. ");
INSERT INTO dww_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Raḡanine taudi noaḡo nevane a tava be Yesu a banabanavina raḡanine, taudi ai taravire be a riuena, “Tauwai katakatai, tam nema kuya verau bako?” ");
INSERT INTO dww_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Be Yesu ya paribeedi be ya riuna, “Maiḡo taugu èi kani siauemina, aubainama taumi taugu ko wanewaneguna. Be yau voiama dosidima aba tawai maḡataridina yaḡoro taumi nam koma katakataiena. Be inam voiedima tawai maḡatariguna da Mamaitua taugu ya riuporeguna. ");
INSERT INTO dww_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Taumi nam kani ḡoma aubainama ko noyanoya, avedi, inam tokare ta bova be tai kavena. Be taumi yawasana kaninama ko wanena, vutuna tokare e kena nonoḡana. Yodibe Banaga Natunama yawasana kenakena nonoḡinama è utemina, baninama Tamadama Mamaitua tauna vutuna yai aninena.” ");
INSERT INTO dww_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Be taudi ai taravire be a riuna, “Mamaitua aba e ḡoeḡoena ka voie?” ");
INSERT INTO dww_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Be Yesu ya riuna, “Mamaitua na ḡoanama inam aitau ya riuriuporena tauna koi sumaḡena.” ");
INSERT INTO dww_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Be taudi a riuena, “Aba matairinama kwa voie da tauma ka kita, yodibe kai sumaḡemna. ");
INSERT INTO dww_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Maika girugiruminama porane ya riuna da Mousis waḡawaḡadama mara kaninama ya utedi be a kanina dobu kavakavane a babababarana raḡanine.” ");
INSERT INTO dww_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Be Yesu ya riuna, “Ibewa, yà riuriu kauemina da inam nam Mousis mara kaninama i utedina. Ibewa da Tamaguma marae miemieninama ya utedina be yodi tauna mara kani ḡominama e uteutemina. ");
INSERT INTO dww_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Be mara kani ḡominama inam tauna aitau marae be ya yovona da banaga matabuna dobue ei yawasanidina.” ");
INSERT INTO dww_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Be taudi a riuna, “Bada, inam kaninama raḡan patapatanama kwa utemai.” ");
INSERT INTO dww_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Be Yesu ya riuna, “Yawasana kaninama inam vutuna taugu! Be aitauḡa ḡarogue ta veraverauna, taudi nam airaḡan kani e karatidi, be aitauḡa tawai sumaḡeguna, taudi nam airaḡan nuedima e raukasakasa. ");
INSERT INTO dww_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Be taumi ko kitakitaguna, be yaḡoro nam komawai sumaḡeguna. ");
INSERT INTO dww_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Be taudi aitauḡa Tamaguma ya uteuteguna, taudi tokare ḡarogue ta verauna, be taugu tokare nam yà riutuaḡaiedi. ");
INSERT INTO dww_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Taugu marae be è yovona tauriuporeguma na ḡoanama yà voiena aubainama, be nam taugu. ");
INSERT INTO dww_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Be Mamaitua na ḡoanama inam umanama, tauna aitauḡa taugu ya uteuteguna nam tenaḡa maika yà viri yakasi, ibewa da raḡan damone taudi tokare gurie be yà kawa midisuḡu munaḡedina. ");
INSERT INTO dww_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tamaguma na ḡoanama inam banaga aitauḡa Mamaitua Natunama ta kita be tawai sumaḡena, taudi tokare yawasana kenakena nonoḡinama ta paḡona, be raḡan damone taudi gurie be yà kawa midisuḡu munaḡedina.” ");
INSERT INTO dww_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Inam raḡanine Jius banegidima momodu ai karena, baninama Yesu ya riuna da tauna vutuna kani marae, be ya yovona. ");
INSERT INTO dww_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Be taudi a riuna, “Uma tauna Yesu, Jousep natunama. Na dosima tauda tè kataiedina. Be nemanama da tauna e riuriuna, ‘Taugu marae be è yovona.’”? ");
INSERT INTO dww_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Be Yesu ya riuedina, “Momodu ko gose pore! ");
INSERT INTO dww_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nam aitau teneḡinama da tokare ḡarogue e verau. Be Tamaguma tauriuporeguma aitauḡa e veraverauḡedina ḡarogue, taudi tokare ḡarogue ta verauna. Be taudi vutudi tokare raḡan damone gurie be yà kawa midisuḡu munaḡedina. ");
INSERT INTO dww_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Baninama girugiruminama porane peroveta umanama a riuna, ‘Taudi matabudi Mamaitua tokare ei kataidina.’ Be aitauḡa Tamaguma bonanama tawai beavaie be riunama ta paḡopaḡona, taudi tokare ḡarogue ta verauna. ");
INSERT INTO dww_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nam aitau tenaḡa Tamadama i kita rubuna. Ibewa da taugu Mamaitua ḡarone be è yovona, tauguḡa Tamadama è kitana. ");
INSERT INTO dww_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Yà riuriu kauemina, aitau da taugu ewai sumaḡeguna, tauna kaite yawasana kenakena nonoḡinama ya paḡona. ");
INSERT INTO dww_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yawasana kaninama inam vutuna taugu! ");
INSERT INTO dww_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Taumi waḡewaḡemima boni dobu kavakavane mana a kanikanina, yaḡoro a gurina. ");
INSERT INTO dww_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Be aitau uma kaninama marae yovoyovonama e kanina, tauna tokare nam e guri. ");
INSERT INTO dww_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Be taugu vutuna yawasana kaninama marae be è yovona. Be aitau da inam kaninama e kanina, tauna tokare e mia nonoḡana. Be inam kaninama vutuna taugu tubuḡa ḡomiguma yai utaena, da dobue banaga ta yawasanana aubainama.” ");
INSERT INTO dww_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dabudine Jius banegidima ai saḡasaḡa gurata be a riuna, “Nemanama da uma baneginama tubuḡinama e uteda be tà kani?” ");
INSERT INTO dww_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Be Yesu ya paribeedi be ya riuna, “Yà riuriu kauemina, deḡoda Banaga Natunama tubuḡinama nam taumi ko kani be kosininama nam ko tego, taumi nopomie yawasana ibewa. ");
INSERT INTO dww_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Be aitau da tubuḡa ḡomiguma e kanikani be kosiniguma e tegotegona, tauna yawasana kenakena nonoḡinama kaite ya paḡona. Be raḡan damone tokare gurie be yà kawa midisuḡu munaḡedina. ");
INSERT INTO dww_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Baninama taugu tubuḡa ḡomiguma inam vutuna kani kaua. Be kosiniguma inam vutuna tego kaua. ");
INSERT INTO dww_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Be aitau da tubuḡa ḡomiguma e kanikani be kosiniguma e tegotegona, tauna taugu nopogue be taugu tauna nopone. ");
INSERT INTO dww_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamaguma yawayawasaninama ya riuriuporeguna na rewapanae taugu yà miamiana. Teneḡinama nama aitauḡa taugu ta kanikaniguna, taudi tokare yau rewapanae ta miana. ");
INSERT INTO dww_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Be taugu vutuna kani kaua marae be è yovona. Taumi waḡewaḡemima boni mana a kanikanina, taudi a gurina. Be aitau uma kaninama e kanina, tauna tokare e mia nonoḡana.” ");
INSERT INTO dww_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu inam giudima matabudi Kapeniamma sinagog nopone banaga yai katakataidina. ");
INSERT INTO dww_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Be raḡanine Yesu na tauwai muriwatanama toitoi nama giudima a vaivaiedina, taudiḡa ai giu vivira be a riuna, “Uma waikatakatainama nam i vere kauana, aitau tokare e paḡo?” ");
INSERT INTO dww_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Dabudine Yesu ya kataie da na tauwai muriwatanama tauna na giuma aubainama a momomomoduna, naumeki be ya riuedina, “Taugu yau giuma ami waisumaḡama e kawakawa gewagewa, bo? ");
INSERT INTO dww_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Be Banaga Natunama marae e munamunaḡana ko kitana raḡanine, taumi nema ko noḡota bako? ");
INSERT INTO dww_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mamaitua Aruinama tauna vutuna yawasana kenakena nonoḡinama banaga e uteutedina. Tubuḡa taunaḡa nam yawasana e utemi. Be taugu yau giuma aba è riuriuemina, inam vutuna Mamaitua Aruinama, yawasana e uteutemina. ");
INSERT INTO dww_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Be yaḡoro taumi ḡesaumima nam komawai sumaḡeguna.” Yesu tauna noḡone ya kataiedina da aitauḡa tauna nam timawai sumaḡena, be aitau tauna tokare e boru dobiḡena. ");
INSERT INTO dww_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Be Yesu giu yai kare munaḡe be ya riuna, “Vutuna aubainama noḡone è riuemina da nam aitau teneḡinama da tokare ḡarogue e verau. Be Tamaguma aitau rewapana e uteutena, tauna tokare ḡarogue e verauna.” ");
INSERT INTO dww_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Uma giune Yesu na tauwai muriwatanama toitoi tauna a gose be ai naḡo teḡateḡana. ");
INSERT INTO dww_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dabudine Yesu na tauwai muriwatanama 12 a miamia kwasana yai taraviredi be ya riuna, “Taumi nemanama? Taumi mate naḡo ko ḡoeḡoe, bo?” ");
INSERT INTO dww_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Be Saemon Pita Yesu ya paribee be ya riuna, “Bada, aitau ḡarone ka naḡo? Tam yawasana kenakena nonoḡinama riudima tamḡa ḡarome ta kenakenana, ");
INSERT INTO dww_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","be tauma kawai sumaḡemna be kè kataiena da tam vutuna Mamaitua na Babau vinevinema.” ");
INSERT INTO dww_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dabudine Yesu ya riuna, “Taumi 12 taugu è vinemina be nopomie tenaḡa tauna Seitan na taunoyama.” ");
INSERT INTO dww_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tauna inam Judas ya giugiuena. Be tauna Saemon Iskariot natunama. Be avedi da Judas tauwai muriwatana 12 nopodie, be tauna yaḡoro Yesu ya boru dobiḡena. ");
INSERT INTO dww_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Inam kauidima muridie Yesu Galili noponaḡa ya babababara naḡona. Be tauna Judia naḡonama nam i ḡoena, baninama inam dabudine Jius babadidima Yesu kana kasirama a tomtomna da sibo ai gurina. ");
INSERT INTO dww_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Be Kapekape soinama raḡaninama maida ya tavatavana aubainama, ");
INSERT INTO dww_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu tasitasinama tauna a riuena, “Tam Galili sibo kuya gose be kuya naḡona Judiama soie, be dabudine patare sibo mataira kuya voiedi be am tauwai muriwatanama sibo a kitedina. ");
INSERT INTO dww_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tam deḡoda kwa ḡoeḡoena banaga matabudi ta kataiemna, naumeki da patara matedie mataira dosidima kwa voiedina, be nam kwa miamia yababa.” ");
INSERT INTO dww_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Taudi nama a riuna, baninama avedi da Yesu tasitasiḡominama taudi mate Yesu nam ti sumaḡena. ");
INSERT INTO dww_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Vutuna aubainama Yesu taudi ya riuedina, “Taugu yau raḡan yaḡama nam i tavana. Be taumi naumeki da ami ḡoane nama ko naḡona. ");
INSERT INTO dww_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Banaga tokare nam ta tuaḡaiemi, be taugu ta tuatuaḡaieguna, baninama taugu yà riuriuedina da adi voiama a gewagewana. ");
INSERT INTO dww_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Naumeki taumi ko naḡo soie, be taugu inam nam ama naḡonaḡona, baninama yau raḡan yaḡama yaḡoro nam i tavana aubainama.” ");
INSERT INTO dww_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Naumeki da Yesu Galilima ya mia kwasana. ");
INSERT INTO dww_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Be tasitasinama taudi a naḡonaḡona soie raḡanine, tauna mate muriḡa moisiriḡa ya naḡona soie. Be nam patare i taimaḡatarina. ");
INSERT INTO dww_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Be soi nopone Jius babadidima Yesu a wane be a riuriuna, “Uma baneginama tauna deḡo?” ");
INSERT INTO dww_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Be inam dabudine patara dosinama taudi kasave mareḡa Yesu awai giugiuena. Banaga ḡesaudima a riuna, “Tauna banaga verenama”. Be ḡesaudima a riuna, “Ibewa, tauna banaga e biribiri waideḡedina.” ");
INSERT INTO dww_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Be nam aitau tenaḡa debanama i tora be patare i giu guratana, baninama taudi Jius babadidima a nairedina aubainama. ");
INSERT INTO dww_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Soi ḡaubonaḡa da sibo ya kovina, Yesu ya saḡa ya naḡo tempol nopone be waikatakatai yai karena. ");
INSERT INTO dww_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Dabudine Jius banegidima tauna a base be a riuna, “Uma baneginama tauna nam aikedae i girumana. Be nemanama da uma yabedima matabudi ya kataiedi?” ");
INSERT INTO dww_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Be Yesu taudi ya riuedina, “Aba yàwai katakataimina inam nam taugu nuague ama waikatakataimina. Ibewa da inam tauriuporeguma tauna na waikatakataima. ");
INSERT INTO dww_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Be aitau da Mamaitua na ḡoanama voienama e ḡoeḡoena, tauna tokare e kataie da inam waikatakatainama Mamaitua na waikatakatai, bo taugume yau waikatakatai. ");
INSERT INTO dww_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Banaga aitau da na noḡote e giugiuna, inam baninama tauna e rarau rubuna da banaga tauna kabe ta kawa saḡe. Be tauna aitau da tauriuporenama kawa saḡenama aubainama e giugiuna, tauna inam banaga verenama, be tokare nam ḡarone gewagewa ta banavi. ");
INSERT INTO dww_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mousis tarawatu ya utemina, be nam aitau tenaḡa inam tarawatudima kumawai muriwatanedina. Aba aubainama taugu waiguriguma ko ḡoeḡoe? Taumi inam tarawatu kowai kati kotovina.” ");
INSERT INTO dww_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dabudine banaga Yesu a riuena, “Tauma nam tam waigurimma ke riuena, tam agunai penama ya kokumna.” ");
INSERT INTO dww_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Be Yesu taudi ya riuedina, “Taugu Sabat raḡanine tauḡoma tenaḡa èi yawasani be taumi nuemima yai medina. ");
INSERT INTO dww_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Be you, taumi mate Sabat raḡanine ko noyanoyana. Taumi Mousis na tarawatuma ruvane seda tautauḡomidima ḡarodie kopitom ko voivoiedina. Be inam vaivainama novemai Eibraham ḡarone be ya saḡana, muriḡa da Mousis tarawatu ya yovoḡena. ");
INSERT INTO dww_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Deḡoda gomana Sabat raḡanine kopitom e paḡona, inam naumeki Mousis na tarawatuma na ruvae. Nama teneḡine taugu yodi banaga Sabat raḡanine èi yawasanina, yodi nemanama? Be aba aubainama yodi ḡarogue ko medimedi? ");
INSERT INTO dww_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Inam kauidima ko kita yaḡedi da nam voia ḡavoe kitakitanama, vutuna ko kitakita wairuva. Avedi, be didimanae yaba ko kita wairuvedi be muriḡa da ko giuedi.” ");
INSERT INTO dww_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Inam giudima aubaidima Jerusalem banegidima ḡesaudima a riuna, “Uma baneginama vutuna waigurinama ta riuriue, bo? ");
INSERT INTO dww_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tauna yodi umanema patare e giugiuna, be taudi nam aba ḡarone tima riuriuena. Agunai tauda dà babadama a banavi da tauna naumeki Tauwai yawasana. ");
INSERT INTO dww_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Be inam nemanama? Uma baneginama tauda tè kataiena da tauna aikedae be ya tavana. Be Tauwai yawasana aikedae be e tavana nam aitau i kataiena.” ");
INSERT INTO dww_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu tauna yaḡoro tempol nopone yawai katakataina maika, tauna bonanama dosine ya riuna, “Inam riukaua taumi koya kataiena da taugu aitau be aikedae è tavana. Taugu nam yau ḡoane uma dabudine e tavana. Ibewa da Tamaguma ya riuporeguna, be tauriuporeguma riukaua e miamiana, be taumi tauna nam ko kataiena. ");
INSERT INTO dww_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Be taugu tauna è kataiena, baninama taugu tauna ḡarone be è yovona. Tauna ya riuporeguna.” ");
INSERT INTO dww_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Umanama giudima debedie taudi a rarau rubuna da sibo a vunuḡina, be nam ti vunuḡina, baninama na raḡan yaḡama nam i tavana aubainama. ");
INSERT INTO dww_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Be patara nopodie banaga toitoi Yesu ai sumaḡe be a riuna, “Tauwai yawasana e tavana raḡanine, mataira ḡesaudima dosidima uma baneginama ya voivoiedina nama tokare e voiedi, bo? Vutuna aubainama uma tauna naumeki vutuna.” ");
INSERT INTO dww_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Dabudine patara kasave Yesu awai giugiuena, Parisi a vaiedina. Vutuna aubainama taudi be pirisi adi babadama mate porisiman a riuporedina da Yesu sibo a vunuḡi be a panina. ");
INSERT INTO dww_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Be Yesu ya riuna, “Taugu taumi mate raḡan ḡaubonaḡa tà miana, muriḡa be yà munaḡana tauriuporeguma ḡarone. ");
INSERT INTO dww_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Taumi tokare ko waneguna be nam ko banavigu, baninama deḡo taugu yà miamiae, dabudi taumi tokare nam ko tava.” ");
INSERT INTO dww_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dabudine Jius babadidima adi banagama adi banagama mate a riuna, “Inam baneginama deḡo naḡonama ewai tai? Agunai tauna uma dobunama e gose be e naḡona wari dobue da nam tà kita munaḡe. Agunai tauna Jius banegidima ai daberaridi be wari dobue ta miamiana ḡarodie e naḡona. Bo Gurik banegidima ḡarodie e naḡo be ei katakataidina. ");
INSERT INTO dww_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tauna ya riuna, ‘Taumi tokare ko wanegu be nam ko banavigu be deḡo yà miamiana, dabudi taumi tokare nam ko tava’. Uma giudima banidima aba?” ");
INSERT INTO dww_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Soi raḡaninama dosinama damone Yesu ya midisuḡu be bonanama dosine ya riuna, “Aitau da nuamma e rarau kasakasana kwa verau ḡarogue be upa yà utem be kwa tegona. ");
INSERT INTO dww_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aitau da taugu ewai sumaḡeguna, inam baneginama nopone yawasana watutunama e manini dobina maika girugiruminama porane ya riuriuna nama.” ");
INSERT INTO dww_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu upa ya giuena inam Arua e giugiuena, be taudi aitauḡa tauna tawai sumaḡena tokare e utedina. Inam raḡanine Arua yaḡoro nam i yovona, baninama Yesu yaḡoro dobue ya miamiana, tauna nam gurie i midisuḡu be i naḡona marae. ");
INSERT INTO dww_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Be banaga umanama giudima a vaivaiedina, dabudine ḡesaudima a riuna, “Riukaua da inam tauḡominama tauna vutuna peroveta Mamaitua ya sausaugena raḡan damone e tavana, vutuna yodi ya tavana.” ");
INSERT INTO dww_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Be banaga ḡesaudima a riuna, “Tauna Tauwai yawasana.” Be ḡesaudima a riuna, “Ibewa, Tauwai yawasana nam tokare Galilima be e verau, ");
INSERT INTO dww_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","baninama girugiruminama porane e riuriuna da Tauwai yawasana tauna guyau Deivid na damma nopone e tubuḡana. Be tauna tokare Deivid na meagaie Betliemma be e verauna.” ");
INSERT INTO dww_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Naumeki da Yesu kana taiye banaga adi noḡotama ruvedie nama a dariḡa munaḡedina. ");
INSERT INTO dww_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Banaga ḡesaudima a ḡoeḡoena da sibo a vunuḡina, be nam aitau tenaḡa nimanama Yesu tunine i boru rubuna. ");
INSERT INTO dww_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Naumeki da porisiman a tava munaḡana Parisi be pirisi adi babadama ḡarodie. Be inam babadidima porisiman ai taraviredi be a riuna, “Aba aubainama Yesu nam ko vunuḡi be ko pani verauḡe?” ");
INSERT INTO dww_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Be porisiman a riuna, “Uma baneginama na giuma ai rewapana kauana, nam aitau airaḡan nama i giu rubu be ke vaiena.” ");
INSERT INTO dww_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Be Parisi a riuedina, “Taumi mate yodi tauna kowai murinaḡonaḡo, bo? Tauna inam banaga tauboru waideḡedima. ");
INSERT INTO dww_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ami babadama be tauma Parisi ko kitamai, inam tauḡominama kawai muriwatane, bo? ");
INSERT INTO dww_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ibewa, be uma pataridima buebuedima tarawatu nam ti kataiena, vutuna aubainama tokare Mamaitua ei tara tautauedina.” ");
INSERT INTO dww_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dabudine Parisi tenaḡa isanama Nikodimas, tauna vutuna boni Yesu ḡarone ya tavatavana, tauna ya midisuḡu be ya riuna, ");
INSERT INTO dww_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Tauda dà tarawatuma nema e riuriu bakeda? Banaga tà kovoḡa yababe, bo noḡone tà etara doke be muriḡa tà kovoḡi?” ");
INSERT INTO dww_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dabudine na banagama a paribee be a riuna, “Tam mate Galili banegim, bo? Girugiruminama porane kwa sievi be kwa kita da nema e riu bakem. Nam airaḡan peroveta Galiliḡa tokare e verau.” ");
INSERT INTO dww_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Naumeki da ai daberaridi be tenatenaḡaḡa a naḡona adi vadae. ");
INSERT INTO dww_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Be Yesu tauna ya naḡona oya olip debane. ");
INSERT INTO dww_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pomainama raḡanboiboi tauna ya munaḡana tempol nopone be dabudine patara a rawateḡeidina. Naumeki da tauna ya mia be waikatakataidima yai karena. ");
INSERT INTO dww_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tauna dabudi ya giugiuna maika, tarawatu tauwai katakataidima be Parisi taudi waivi tenaḡa a kita banavina, tauna na banagama debedie mui tauporenama. Vutuna aubainama taudi a verauḡena Yesu ḡarone. Be waivinama a riue da patara noḡodie ya midi ");
INSERT INTO dww_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","be taudi Yesu a riuena, “Tauwai katakatai, uma waivinama na banagama debedie mui ya porepore be kè banavina. ");
INSERT INTO dww_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nema kwa noḡonoḡota bake? Mousis na tarawatuma e riuriuna da umanama waivinama tauma sibo kè rauyeku be ya gurina.” ");
INSERT INTO dww_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Be inam babadidima taudi keda a wanewanena da Yesu sibo aba ya vato waigewa be inam giudie sibo ai wavuna. Be Yesu ya raudune yovo be nimarakurakune doḡa debane yawai girugirumana. ");
INSERT INTO dww_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Be taudi yaḡoro waitaravira awai borudidina. Naumeki da Yesu ya tausuḡu be ya riuedina, “Tam aitau da gewagewa nam ku voia rubuna, naumeki da tam banegimma yeku kwa rubu dokena.” ");
INSERT INTO dww_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dabudine tauna ya raudune munaḡa be doḡa debane waigirugiruma yai kare munaḡena. ");
INSERT INTO dww_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Raḡanine waivi tauwai wavunama nama giunama a vaivaiena, naumeki da tenatenaḡaḡa ai naḡo teḡeteḡedina, be babada poredima taudi inam a doka ḡomedina. Be Yesu inam waivinama mate taudiḡa a gose poredina. ");
INSERT INTO dww_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Naumeki da Yesu ya tausuḡu be waivinama yai taravirena, “Tauwai wavumama aikedae a naḡo? Taudi nam ti rauyekum, bo?” ");
INSERT INTO dww_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Be waivi ya riuna, “Ibewa Bada.” Be Yesu tauna ya riuena, “Taugu mate nam tokare yà rauyekum. Kwa naḡona, be nam gewagewa kwa voie munaḡe!” ");
INSERT INTO dww_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu patara ḡarodie giu yai kare munaḡa be ya riuna, “Taugu vutuna dobu na yanama. Aitau da taugu ewai muriwataneguna, tauna tokare nam tadiwanawanae ei suratou naḡo. Ibewa da tauna nopone yana e kenana, inam raḡanine yawasana e banavina.” ");
INSERT INTO dww_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Be Parisi taudi a paribee be a riuna, “Tam inam kaiyovue tamḡa aubaimma kwa giugiu raukosoḡaiḡai.” ");
INSERT INTO dww_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Be Yesu taudi ya riuedina, “Deḡoda taugume aubaiguma sibo è giu raukosoḡaiḡaina, inam yaḡoro riukaua. Baninama taugu aikedae è verau be aikedae yà naḡonaḡona taugu è kataiena, be taumi nam ko kataiena. ");
INSERT INTO dww_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","“Taumi ko etaetareguna inam banaga ḡoma ami noḡotama ruvane ko etaetareguna. Be taugu nam aitau ama etaetarena. ");
INSERT INTO dww_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Be deḡoda taugu banaga etaredima è ḡoena, taugu yau rauetarama tokare didimanae è voiena, baninama Tamaguma tauriuporeguma murigue e midimidina, be nam tauguḡa ama miamiana. ");
INSERT INTO dww_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Taumi ami tarawatuma e riuriuna da raḡanine matamata rabui giu teneḡinama ta vatona, inam giunama banaga tokare nam ta riuwai kaikaiyovu. ");
INSERT INTO dww_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Taugu inam matemie yodi aubaiguma yà giugiuna, be wairabuiguma inam Tamaguma tauna vutuna tauriuporeguma.” ");
INSERT INTO dww_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dabudine taudi Yesu a riuena, “Yodi tamamma deḡo?” Be Yesu ya paribeedi be ya riuna, “Taumi taugu Tamaguma mate nam ko kataiemaina. Deḡoda taugu sibo ko kataieguna, taumi tokare Tamaguma mate koya kataiena.” ");
INSERT INTO dww_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu tauna tempol nopone deḡo mane aniborunama gabune, dabudi ya midi be inam yabedima matabudi yai katakataidina. Be nam aitau Yesu i kaididi be i pani nawena, baninama tauna na raḡan yaḡama yaḡoro nam i tavana. ");
INSERT INTO dww_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Be Yesu inam babadidima ya riu munaḡedina, “Taugu tokare yà naḡona, be taumi ko waneguna be ami gewagewae tokare ko gurina. Be deḡo yà naḡonaḡona, taumi tokare nam dabudi ko tava.” ");
INSERT INTO dww_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Be Jius babadidima a riuna, “Yodi agunai waiguri munaḡenama ewai nuanoḡonoḡotena. Vutuna aubainama tauna ya riuna, ‘Deḡo yà naḡonaḡona, taumi tokare nam dabudi ko tava’. Bo inam giunama baninama aba?” ");
INSERT INTO dww_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Dabudi Yesu na giuma ya kaiwatani be ya riuedina, “Taumi inam uma dobunama ḡaronama, be taugu ibewa. Taugu inam note banagiguma. ");
INSERT INTO dww_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Vutuna aubainama è riuemina da taumi tokare ami gewagewae ko gurina. Be taugu inam vutuna taugu. Be deḡoda nam koi sumaḡegu, taumi tokare naumeki da ami gewagewae ko gurina.” ");
INSERT INTO dww_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Be taudi a riuena, “Tam aitau?” Be Yesu ya riuedina, “Kaite yà riuriuemina, taugu inam vutuna taugu. ");
INSERT INTO dww_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Taumi ami voiama debane nema sibo è riuriu bakemina, be tokare nam nama yà voia. Be tauna aitau tauriuporeguma riukaua da tauna e miamiana. Tauna vutuna aba e riuriueguna ruvane, nama dobue banaga yà riuriuedina.” ");
INSERT INTO dww_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Be banaga dabudine taudi nam ti kataiena da tauna inam Tamanama ya giugiuena. ");
INSERT INTO dww_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Vutuna aubainama Yesu ya riuna, “Raḡanine taumi Banaga Natunama ko kaisuḡu be koi dawena, inam raḡanine taumi tokare ko kataiegu da taugu vutuna taugu. Be taugu nam yau ḡoane yaba ama giugiuedina, ibewa da Tamaguma nema ewai katakataiguna ruvane, nama yà giugiuedina. ");
INSERT INTO dww_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tauriuporeguma tauna raḡan matabuna taugu mate be nam ima gosegoseguna, baninama taugu raḡan matabuna na ḡoanama yà voiedi be tauna ewai nuaverena.” ");
INSERT INTO dww_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Banaga toitoi uma giudima a vaivaiena, taudi Yesu ai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Taudi aitauḡa Yesu awai sumaḡena, tauna ya riuedina, “Deḡoda yau waikatakataima ko kaidididi be ko voteyeteyedina, taumi riukaua da yau tauwai muriwatanama. ");
INSERT INTO dww_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Inam raḡanine taumi riukaua ko kataie be riukaua taumi e kuvesimina.” ");
INSERT INTO dww_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Be taudi a paribee be a riuena, “Nemanama kwa riuriuna da kwa kuvesimai? Tauma Eibraham na damma, nam aitau ḡarone kamawai yaragana, riukaua nema e kuvesa bakemai?” ");
INSERT INTO dww_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Be Yesu ya riuedina, “Yà riuriu kauemina, aitau da gewagewa e voivoiena, tauna gewagewa ḡarone ewai yaragana. ");
INSERT INTO dww_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Be aitau da gewagewa ḡarone ewai yaragana, tauna Mamaitua na damma nopone nam na waibadama ima kenakenana. Be Mamaitua Natuḡominama tauna na waibadama e kenakena watanana. ");
INSERT INTO dww_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Vutuna aubainama deḡoda Mamaitua Natuḡominama e kuvesimina, taumi naumeki da kuvekuvesimima ko miana. ");
INSERT INTO dww_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Taugu è kataiena taumi Eibraham na damma, be yaḡoro taumi waiguriguma kowai taina, baninama taugu yau giuma taumi nopomie nam ima kenakenana aubainama. ");
INSERT INTO dww_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Taugu Tamaguma ḡarone yaba è kitekitedina vutudi yà riuriuemina. Be taumi tamemima aba ya riuriuemina, vutuna koi muriwatanena.” ");
INSERT INTO dww_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Be taudi a riuna, “Tauma tamamaima Eibraham.” Be Yesu ya riuna, “Ibewa, Eibraham inam nam taumi tamemi. Deḡoda taumi sibo tamemima, Eibraham naumeki da tauna yaba ya voivoiedina ruvane, nama sibo koya voiedina. ");
INSERT INTO dww_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Taugu riukaua Mamaitua ḡarone è vaie be è riuriuemina be yaḡoro da taumi vunuḡiguma kowai taina. Eibraham tauna tokare nam nama ya voia. ");
INSERT INTO dww_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Taumi ami voiama ewai maḡatarana da taumi tamaḡomimima inam banaga ḡesau, be tauna na voiama kowai muriwatanena.” Be taudime a gudutaraḡa munaḡedi be a riuna, “Tauma Tamaḡomimaima inam Mamaitua be nam keda sedamai.” ");
INSERT INTO dww_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Be Yesu ya riuedina, “Ibewa, Mamaitua inam nam taumi tamemi. Taumi deḡoda sibo tamemima Mamaitua, naumeki da taumi koyai nuapaḡoeguna, baninama taugu Mamaitua ḡarone be è yovona. Be taugu nam mabigue è yovona, ibewa da tauna ya riuporegu be è yovona. ");
INSERT INTO dww_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","44","Taumi tamemima Diaboro, vutuna aubainama taugu yau giuma koya nuababaḡena, be taugu aba yà giugiuedina, taumi nam koma vaivaiedina. Taumi tamemima na ḡoanama vutudi kowai muriwatanedina. Tauna boni pakane da yodi tauna taurau vunuḡa. Baninama tauna riukaua e tuatuaḡaie be nopone nam riukaua ima kenakenana. Tauna taukaikaiyovu be kaiyovu Tamanama, tauna naumeki na yawasanama vutuna. ");
INSERT INTO dww_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Vutuna aubainama taugu raḡanine riukaua yà giugiuena, taumi nam taugu komawai sumaḡeguna. ");
INSERT INTO dww_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Aba gewagewane taumi tokare koi wavugu? Deḡoda taugu yà riuriu kauana, naumeki da taumi sibo koyai sumaḡeguna. ");
INSERT INTO dww_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tam aitau da Mamaitua ḡaronama, tam tauna riunama kwa vaivaiena. Be deḡoda riuguma nam kuma vaivaiena, inam anikitanama tam nam Mamaitua ḡarona.” ");
INSERT INTO dww_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Be Jius babadidima a riuena, “Tam maiḡone aba kè riuem? Tam gewagewa banegimma be penama ya kokumna!” ");
INSERT INTO dww_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Be Yesu ya riuna, “Taugu nam penama i kokuguna, ibewa da taugu Tamaguma yà vivivivirena, be taumi taugu nam koma vivivivireguna. ");
INSERT INTO dww_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Taugu nam ama kawakawa saḡe munaḡeguna, ibewa da Tamaguma Mamaitua tauna e kawakawa saḡeguna, be tauna vutuna yaba matabuna taukita wairuvanama. ");
INSERT INTO dww_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Taugu yà riuriu kauemina, Tam aitau da riuguma kwa voteyeteyedina, tam nam airaḡan tokare guri e taukonim.” ");
INSERT INTO dww_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dabudine Jius babadidima tauna a riuena, “Yodi kè vaia kauemna da tam riukaua penama ya kokumna. Tam kuya riuna da aitau riumma e voteyeteyedina, guri nam airaḡan tokare tauna e taukoni. Be you, Eibraham be peroveta taudi a gurina. ");
INSERT INTO dww_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tam nema maika kitam? Tamadama Eibraham be peroveta taudi a gurina, tam kwa saḡa poredi, bo?” ");
INSERT INTO dww_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Dabudine Yesu ya riuna, “Deḡoda taugume yà kawa saḡe munaḡeguna, inam kawasaḡenama nam baniboruboruna. Taugu Tamaguma e kawakawa saḡeguna, tauna vutuna taumi ko riuriuna ami Mamaituama. ");
INSERT INTO dww_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Be taumi tauna nam ko kataiena. Be taugu tauna è kataiena. Deḡoda taugu sibo è riuna taugu nam tauna e kataiena, inam raḡanine taugu tokare banaga kaikaiyovuguma è tubuḡana taumi maika. Be inam nam nama! Taugu tauna è kataie be riunama yà vovo teyeteyena. ");
INSERT INTO dww_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Tamemima Eibraham ya noḡonoḡotina da yau kaba verauma raḡaninama e kitana, aubainama tauna nuanama ya mosarina. Be inam raḡaninama tauna kaite ya kita be yai nuaverena.” ");
INSERT INTO dww_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Be Jius Yesu a riuena, “Tam am suarama ḡauboḡominama nam 50 ku paḡona. Be nemanama da kwa riuriuna tam Eibraham kuya kita?” ");
INSERT INTO dww_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Be Yesu ya paribeedi be ya riuna, “Riukaua yà riuriuemina, muriḡa da Eibraham ya tubuḡana, taugu miemieniguma nama yà miamiana.” ");
INSERT INTO dww_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Inam giunama debane taudi yeku a ragaudi da Yesu sibo a rauyekuna. Be tauna tempol ya dobi pore, da ya rausonaḡe be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Naumeki da Yesu ya babababara naḡo, be tauḡoma matapotapotanama ya kitana. Be inam tauḡominama matapotapotanama tauna nama ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Be Yesu na tauwai muriwatanama tauna ai taravirena, “Tauwai katakatai, gewagewa aikedae ya tava be uma tauḡominama ya voie da ma matapotapotana ya tubuḡa? Tauname na gewagewa bo na dosima adi gewagewa?” ");
INSERT INTO dww_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Be Yesu ya riuedina, “Ibewa, nam tauna na gewagewa bo dosi adi gewagewa. Uma kauinama ya tubuḡana da inam tauḡominama ḡarone Mamaitua na rewapanama ei maḡatari be tà kitana. ");
INSERT INTO dww_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Raḡan yodi e yanayanae tauriuporeguma na noyama tà voiena. Be kupi e veraverauna e tavana, inam raḡanine nam aitau tokare noya e voie be teneteneḡina. ");
INSERT INTO dww_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Taugu dobue yà miamiana maika, taugu vutuna dobu na yanama.” ");
INSERT INTO dww_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Raḡanine nama ya riuriuna, tauna doḡae ya kaviso be nimane kavisonama ya voie da dogodogo ya tubuḡana, be dogodogonama tauḡominama matanama debane ya rodana. ");
INSERT INTO dww_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yodibe ya riuena, “Yodi kwa naḡo kwa siguna Silom topane.” (isa ‘Silom’ baninama inam ‘Riupore’). Naumeki da tauḡoma ya naḡo be ya sigusiguna murine, matanama yai kita be ya verau munaḡana. ");
INSERT INTO dww_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tauna na banagama be banaga ḡesaudima taudi noḡone a kitana da tauna taukiḡikiḡi matapotapotanama. Dabudine taudi a riuna, “Inam tauḡominama vutuna kabe taukiḡikiḡi matapotapotana, bo?” ");
INSERT INTO dww_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Be banaga ḡesaudima a riuna, “Ee, inam tauna”. Be ḡesaudima a riuna, “Ibewa, inam waria, be kitanama maika tauna.” Be tauḡominama ya riu raukosoḡaiḡai be ya riuriuna, “Inam vutuna taugu.” ");
INSERT INTO dww_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Be taudi a riuna, “Aitau matamma yai yawasani?” ");
INSERT INTO dww_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Be inam tauḡominama taudi ya riuedina, “Tauḡoma tenaḡa tawai isana Yesu, tauna dogodogo ya voie da matague ya roda be ya riuegu da Silom topane è siguna. Naumeki da è naḡo è sigusiguna murine, taugu èi kitana.” ");
INSERT INTO dww_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Be banaga inam tauḡominama a riuena, “Baneginama yodi deḡo?” Be tauna ya riuedina, “Bai, taugu nam e kataiena.” ");
INSERT INTO dww_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","(-) ");
INSERT INTO dww_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Inam kauinama Sabat raḡanine Yesu ya voiena. (v13) Vutuna aubainama taudi inam tauḡominama noḡone matapotapotanama ai doka nawena Parisi ḡarodie. ");
INSERT INTO dww_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Be dabudine tauḡoma nema be yai kita bakona, vutuna Parisi tauna ai taravirevirena. Be tauḡominama ya paribeedi be ya riuedina, “Tauna dogodogo matague ya roda, da murine è sigu, yodibe taugu èi kitana.” ");
INSERT INTO dww_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Dabudine Parisi ḡesaudima a riuna, “Inam tauḡominama tauna Sabat nam ima vivivivirena. Inam kauine tauma kè kataiena da Mamaitua nam tauna i riuporena.” Be ḡesaudima a riuna, “Gewagewa baneginama mataira dosidima tokare e voiedi, bo?” Naumeki da Parisi inam giudima debedie taudi a dariḡa munaḡedina. ");
INSERT INTO dww_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dabudine taudi inam tauḡominama noḡone mata potapotanama ai taravira munaḡe be a riuena, “Tam aba kwa noḡonoḡoti, inam baneginama matamma yawai yawasanidina, tauna aitau?” Be tauḡoma ya riuna, “Tauna agunai peroveta.” ");
INSERT INTO dww_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Be Jius babadidima taudi inam tauḡominama nam ti sumaḡena da tauna noḡone matapotapotana. Vutuna aubainama taudi na dosima a riuedi da a tava, ");
INSERT INTO dww_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","yodi be ai taraviredina, “Uma taumi natumi, bo? Tauna matapotapotanama nama ya tubuḡa, bo? Yodi nemanama da matanama yai kita?” ");
INSERT INTO dww_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Dabudine na dosima a riuna, “Ee, inam tauma natumaima be tauna matapotapotanama nama ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Be yodi nemanama da yai kitana tauma nam ke kataiena. Tauna koi taravire be e riuemina, tauna ya morabana.” ");
INSERT INTO dww_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tauḡoma na dosima nama a riuna, baninama taudi Parisi a nairedina aubainama. Baninama Parisi taudi noḡone adi ogama a taraḡina da banaga aitau e riuna, ‘Yesu tauna Tauwai yawasana’, inam raḡanine baneginama tokare sinagog nopone be tà tavu dobiḡena. ");
INSERT INTO dww_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Inam kauinama aubainama na dosima a riuna, “Tauna koi taravire be e riuemina, tauna kaite ya morabana.” ");
INSERT INTO dww_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Naumeki da taudi inam tauḡominama raḡan wairabuinama a riue da ya saḡa munaḡa be a riuena, “Tam Mamaitua sibo kuya vivire be tauma riukaua sibo kuya riuemaina, baninama tauma ke kataie da Yesu tauna gewagewa baneginama.” ");
INSERT INTO dww_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dabudine inam tauḡominama ya riuna, “Taugu nam e kataiena tauna gewagewa banegina bo ibewa. Be aba è kataiena inam taugu mataguma potapotanama be yodi èi kitana.” ");
INSERT INTO dww_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dabudine Parisi tauḡoma matapotapotanama ai taravira munaḡe be a riuena, “Nema yai yawasana bakem? Aiyaba ya voie?” ");
INSERT INTO dww_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Be tauḡominama ya riuna, “Taugu kaite è riuemina be taumi nam kowai beavaiana. Yodi aba aubainama ko ḡoeḡoena ko vaia munaḡe? Taumi mate tauna waimuriwatanenama ko ḡoeḡoe, bo?” ");
INSERT INTO dww_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dabudine taudi inam tauḡominama a kunure be a riuna, “Tam inam baneginama na tauwai muriwatanama, be tauma inam Mousis na tauwai muriwatanama! ");
INSERT INTO dww_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mamaitua Mousis ḡarone ya giuna, vutuna tauma kè kataiena. Be inam tauḡominama aikedae be ya tavana tauma nam ke kataiena.” ");
INSERT INTO dww_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Be tauḡoma ya riuna, “Taumi ko nuanua babaḡana inam naumeki, taugu mate nam e kataiena tauna deḡo be ya tava, be mataguma yai yawasanina, inam vutuna è kataiena. ");
INSERT INTO dww_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tauda matabuda tè kataiena da gewagewa banegidima adi waibaḡama Mamaitua nam ima vaivaiena. Ibewa da aitauḡa tauna ta vivivivire be na ḡoanama ta voivoiena, taudi adi waibaḡama tauna e vaivaiena. ");
INSERT INTO dww_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Boni pakane da yodi nam aitau tenaḡa ke vaie da banaga ma matapotapotana tubutubuḡinama i yawasana rubuna. ");
INSERT INTO dww_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Uma baneginama tauna riukaua da Mamaitua ḡaronama, be deḡoda ibewa, tauna nam teneteneḡina da umanama kauinama tokare ya voie.” ");
INSERT INTO dww_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Be Parisi a riuena, “Tam kuya tubutubuḡe gewagewa ya kaididimna naumeki da yodi. Be yodi tauma kwai katakataimai, bo?” Naumeki da taudi inam tauḡominama sinagog nopone be a tavu dobiḡena. ");
INSERT INTO dww_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ya vaie da Parisi inam tauḡominama sinagog nopone be a tavu dobiḡena. Be Yesu raḡanine inam tauḡominama ya banabanavina ya riuena, “Tam Banaga Natunama kwawai sumaḡe bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Dabudine inam tauḡominama ya riuna, “Bada, inam aitau? Kwa riuegu be yài sumaḡe.” ");
INSERT INTO dww_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Be Yesu ya riuna, “Tam vutuna yodi kwa kitakitana, be ḡarome e giugiuna.” ");
INSERT INTO dww_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naumeki da inam tauḡominama ya riuna, “Bada, yàwai sumaḡana.” Dabudine tauna ya rauduneena. ");
INSERT INTO dww_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Be Yesu ya riuena, “Taugu è yovona dobue banaga waitarapiriedima aubainama, da banaga matapotepotedima tai kitana, be banaga waikitedima taudi ta noḡonoḡotina da kabe tiwai kita, ibewa da taudi matedima ya potana.” ");
INSERT INTO dww_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Be Parisi ḡesaudima dabudi a midimidina nama a vaivaiena, taudi a riuna, “Aiyaba, tauma mate matamaima ya pota, bo?” ");
INSERT INTO dww_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Be Yesu ya riuedina, “Deḡoda taumi sibo ko riuna, ‘Tauma matamaima ya potana’, inam raḡanine taugu tokare è sagumi da gewagewa nam ḡaromie ya kena. Be yodi taumi ko riuriuna da taumi matemima ewai kitana, vutuna aubainama taugu tokare nam yà sagumi, be ami gewagewama naumeki da nama ta kenana.” ");
INSERT INTO dww_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu ya riuna, “Taugu yà riuriu kauemina, banaga aitau sipu adi ganama matakedane nam e saḡa be tauna gana boganaḡa e raukai saḡana, inam baneginama tauna taudanedanene. ");
INSERT INTO dww_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Be tauyosi tauna matakedaḡa be e saḡasaḡana sipu ḡarodie. ");
INSERT INTO dww_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","4","Be matakeda taurabenama tauna matakeda e kaiporena tauyosi aubainama. Be tauyosi tauna na sipuma tenaḡaḡa isedima e vatodi be tauna bonanama ta vaie, yodibe tauna ewai doka dobiḡedina. Be sipu tauna tawai muriwatanena, baninama tamedima bonanama a vaia maraḡamena. ");
INSERT INTO dww_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Be banaga tabunama bonanama ta vaiena, taudi tokare naira ta naḡona, baninama tauna bonanama nam ti maraḡamena.” ");
INSERT INTO dww_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Taudi aitauḡa inam wainasinama nama a vaivaiena, taudi wainasi baninama nam ti kataiena da Yesu aba ya giugiue. ");
INSERT INTO dww_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Naumeki da tauna wainasinama, baninama ya giu yaḡedina, “Yà riuriu kauemina, taugu vutuna sipu adi matakedama. ");
INSERT INTO dww_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Be banaga ḡesaudima noḡogue tavetavedima, taudi inam banaga danedanenedima, vutuna aubainama sipu taudi bonedima a vaia nuababaḡedina. ");
INSERT INTO dww_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Be matakeda inam vutuna taugu. Aitau nopogue e saḡa be e naḡona gana nopone, tauna tokare yawasana e banavina, tauna tokare e mia genuana be kani nonoḡinama e kanina. ");
INSERT INTO dww_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Taudanedanene e tavana, tauna sipu e danenedi, e vunuḡidi be e kawa gewegewedina aubainama e tavana. Be taugu è tavana sipu yài yawasanidina aubainama, be taudi yawasana verenama tai maurena, be nam aba ta maruabie. ");
INSERT INTO dww_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Taugu vutuna tauyosi vereguma. Be tauyosi verenama na yawasanama tokare ei utaena sipu waiyawasanidima aubainama. ");
INSERT INTO dww_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Be tauyosi mane aubainama e vovo bagibagina, inam tauna nam tauyosi verena, be tauna nam sipu tamedi. Baninama tabei ta tavatavana raḡanine, inam taunoyanama na yawasanama aubainama naira e naḡona. Dabudine tabei tokare sipu tai retedi be tai daberaridina. ");
INSERT INTO dww_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Inam tauḡominama naira e naḡona, baninama tauna mane aubainama e noyanoyana, be nam sipu imawai nuaboyedina. ");
INSERT INTO dww_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Taugu tauyosi vereguma. Taugu Tamaguma è kataiena, be tauna taugu ya kataieguna, teneḡinama nama taugu yau sipuma è kataiedina, be taudi taugu a kataieguna. Be taudi waiyawasanidima aubainama taugu yau yawasanama yài utaena. ");
INSERT INTO dww_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Be taugu yau sipuma ḡesaudima gana ḡesaudie ta miamiana, taudi mate yà saḡedina gana nopone. Da taudi mate taugu bonaguma ta vaie be adi banagama mate dam tenaḡa ta tubuḡana, yodibe taudi tauyosi tenaḡa vagurune ta miana. ");
INSERT INTO dww_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taugu yau yawasanama yài utae be ya paḡo munaḡena, vutuna aubainama Tamaguma ewai nuapaḡoeguna. ");
INSERT INTO dww_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Be nam aitau tokare yau yawasanama e paḡo pore! Ibewa da taugume yau ḡoane yau yawasanama yài utaena. Taugu rewapana ḡarogue e kenakenana da yau yawasanama yài utaena, be rewapana ḡarogue da yà paḡo munaḡena. Nama Tamaguma ya riu vavasaḡeguna.” ");
INSERT INTO dww_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Inam nama ya giugiuna raḡanine, Jius banegidima dabudine ai kawa dariḡa munaḡana, ");
INSERT INTO dww_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","be banaga toitoi a riuna, “Tauna ya bua kauana, penama ya kokuna. Aba aubainama kowai beavaie?” ");
INSERT INTO dww_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Be banaga ḡesaudima a riuna, “Tauna na giuma vaienama nam banaga penama kokukokuna maika. Baninama penama nam teneteneḡina da banaga matapotapotanama ei yawasani.” ");
INSERT INTO dww_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tururu raḡanine Jerusalemma tempol soinama raḡaninama ya tavana, ");
INSERT INTO dww_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","be tempol nopone gabu isanama ‘Solomon na wagapatae’ dabudine Yesu ya babababara naḡona. ");
INSERT INTO dww_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Be Jius banegidima tauna a midiḡuruvi be a riuena, “Tam Tauwai yawasana teika da kwa riu ḡomemai. Be nam kwa kawa nuaraḡaraḡa guratemai.” ");
INSERT INTO dww_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Be Yesu ya riuna, “Taugu maiḡoka è riuemina, be nam komawai sumaḡeguna. Mataira dosidima Tamaguma isane yà voivoiedina taudi tawai maḡatariguna, ");
INSERT INTO dww_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","be yaḡoro taumi nam komawai sumaḡana, baninama taumi nam taugu yau sipu. ");
INSERT INTO dww_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Taugu yau sipuma taudi bonaguma vaienama a kataiena, be taugu taudi è kataiedi be tawai muriwataneguna. ");
INSERT INTO dww_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Be taugu yawasana kenakena nonoḡinama taudi yà uteutedina, da taudi tokare nam airaḡan gienae ta naḡo. Be nam aitau tokare e kwayagu be teneteneḡina. ");
INSERT INTO dww_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baninama Tamaguma tauna yai rewapana vavasaḡana nam maika aitau ḡesau. Tauna vutuna sipu ya uteguna, be nam aitau tokare tauna nimane e kwaya be teneteneḡina. ");
INSERT INTO dww_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tamaguma be taugu, tauma tenaḡa.” ");
INSERT INTO dww_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Naumeki da Jius banegidima yeku a tama munaḡedi da Yesu sibo a rauyekuna. ");
INSERT INTO dww_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Be Yesu taudi ya riuedina, “Taugu mataira dosidima toitoi Tamaguma na rewapanae è voiedi be koya kitedina. Yodi deḡo matairinama debane taumi rauyekuguma kowai tai?” ");
INSERT INTO dww_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Be Jius banegidima a riuena, “Tauma nam inam matairidima aubaidima rauyekumna kamawai taina, ibewa da tam am waidiboḡama aubainama rauyekuma kawai taina. Tam banaga ḡoma be kwa riuriu munaḡemna da tam kabe Mamaitua.” ");
INSERT INTO dww_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Be Yesu ya paribeedi be ya riuna, “Koya kataie bo ibewa da ami bukama porane a giruma be umanama a riuna, ‘Taugu è riuemina da taumi dobu mamaituedima.’” ");
INSERT INTO dww_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Be giruminama poranama aba e riuriuena inam riukaua! Avedi da Mamaitua riunama Israel babadidima ḡarodie ya riupore yovoḡena, be yaḡoro tauna yai isedina ‘mamaitua’. ");
INSERT INTO dww_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Be yodi taugu yà riuriuna da taugu Mamaitua Natunama be aba aubainama taumi ko medimediegu? Taugu nam amawai diboḡana. Taugu Tamaguma ya vinegu be ya riupore yovoḡeguna dobue. ");
INSERT INTO dww_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Deḡoda taugu Tamaguma na voiama nam yà voiedi, naumeki da nam koi sumaḡegu. ");
INSERT INTO dww_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Be deḡoda yau giuma mate nam koi sumaḡe, naumeki da mataira dosidima yà voivoiedina, vutudi sibo koya kitedi be koyai sumaḡana. Inam raḡanine taumi tokare ko kataie da Tamaguma taugu nopogue, be taugu Tamaguma nopone.” ");
INSERT INTO dww_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dabudine Jius banegidima a rarau rubu munaḡana da Yesu sibo a vunuḡina, be taudi tauna a viri yakasi be ya naḡo poredina. ");
INSERT INTO dww_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Inam kauinama murine Yesu upa Jodan ya davu be ya munaḡana deḡo boni Jon banaga yawai babataitodie, dabudine ya miana. ");
INSERT INTO dww_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Be banaga toitoi a tava be a riuna, “Jon tauna nam airaḡan voia dosidima i voia rubudina, be tauna uma baneginama ya giugiuena inam matabuna riukaua.” ");
INSERT INTO dww_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Vutuna aubainama inam dabudine banaga toitoi Yesu ai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Beteni meagaine tauḡoma tenaḡa isanama Lasares tauna ya sida kauana, be nuvunuvunama rabui mate a miamiana. Tauna nuvunuvunama isedima Meri be Mata. ");
INSERT INTO dww_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Uma Merinama tauna vutuna upa ḡabuḡabunama Yesu kaḡane ya ḡini be debavuvuḡine ya ravusina. Tauna vutuna nuvunama ya sidana. ");
INSERT INTO dww_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Vutuna aubainama inam waiwaividima rabui Yesu na riuma a riupore be a riuna, “Bada, turamma nuamma taupaḡonama ya sidana.” ");
INSERT INTO dww_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Raḡanine Yesu inam varinama ya vaivaiena, tauna ya riuna, “Inam sidanama tokare nam Lasares ei guri. Ibewa da inam sidane Mamaitua neneḡarinama ei maḡatarina, be inam neneḡarine Mamaitua Natunama e kawa saḡena.” ");
INSERT INTO dww_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu, tauna Mata, Meri be Lasares ewai nuapaḡoedina, ");
INSERT INTO dww_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","be yaḡoro tauna nam i naḡo makaina ḡarodie. Tauna raḡan rabui ya miana be muriḡa da ya naḡona ḡarodie. ");
INSERT INTO dww_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Naumeki da raḡan rabui a kovina murine, Yesu na tauwai muriwatanama ya riuedina, “Yodi tà munaḡana Judiama.” ");
INSERT INTO dww_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Be na tauwai muriwatanama tauna a riuena, “Tauwai katakatai, maiḡone kuya kita! Inam dabudine Jius babadidima rauyekumma awai taina. Be yodi tam dabudi kwa munaḡa, bo?” ");
INSERT INTO dww_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Be Yesu ya paribeedina, “Raḡan e yanayanae tauda noya tà voiena. Banaga raḡan e yanayanae ta babarana tokare nam kaḡedima tai tutu, baninama taudi dobu yanayanane keda ta kitakita kauena. ");
INSERT INTO dww_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Be kupie taudi tokare kaḡedima tai tutuna, baninama nam yana.” ");
INSERT INTO dww_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Be na giuma ya kaiwatani be ya riuedina, “Turadama Lasares ya kena nuakoana, be taugu yà naḡonaḡona ḡarone taiḡosorinama aubainama.” ");
INSERT INTO dww_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Be na tauwai muriwatanama a riuna, “Bada, deḡoda tauna ima kenakena, inam tokare sida e yawasanana.” ");
INSERT INTO dww_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Be Lasares tauna ya gurina, vutuna Yesu ya giugiue be na tauwai muriwatanama ai noḡotana kabe tauna kena ḡoma i giugiue. ");
INSERT INTO dww_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Vutuna aubainama Yesu taudi ya riu ḡomedi be ya riuna, “Lasares ya gurina. ");
INSERT INTO dww_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Be taumi aubaimima nuaguma ya verena da nam ḡarone e tavana. Yodi inam keda ḡesaunama e kenakenana da taumi tokare koi sumaḡana. Yodi tà naḡona tauna ḡarone.” ");
INSERT INTO dww_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Dabudine Tomas awai isana ‘Raḡaraḡa’ tauna tauwai muriwatana ḡesaudima ya riuedina, “Naumeki, matabuda tà naḡo be tauna mate tà guri tenaḡana.” ");
INSERT INTO dww_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu Betenima ya tavatavana, tauna ya vaie da Lasares ya guri be kokoagae ya kenana raḡan 4 a kovina. ");
INSERT INTO dww_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Beteni da Jerusalem nam madani i dauna, ");
INSERT INTO dww_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","vutuna aubainama banaga toitoi Meri be Mata nuadubuedima aubainama a tavana Betenima, taudi nuvudima ya kovina aubainama. ");
INSERT INTO dww_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Dabudine Mata e vaiena be Yesu ya veraverauna ḡarodie, naumeki da ya dobi ya naḡona Yesu verau bodebodenama aubainama. Be Meri tauna vadae ya mia kwasana. ");
INSERT INTO dww_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Be Mata Yesu ya riuena, “Bada, deḡoda tam maiḡone uma dabudine ku tavana, nuvuguma tokare nam ya guri. ");
INSERT INTO dww_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Be taugu è kataiena deḡoda yodi aba kwai baḡena, Mamaitua tokare e utemna.” ");
INSERT INTO dww_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Be Yesu tauna ya riuena, “Nuvumma tokare e midisuḡu munaḡana.” ");
INSERT INTO dww_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Be Mata ya riuna, “Taugu è kataiena da raḡan damone midisuḡu munaḡa raḡanine tauna tokare e midisuḡuna.” ");
INSERT INTO dww_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Be Yesu tauna ya riuena, “Taugu vutuna midisuḡu munaḡa be yawasana. Aitauḡa da tawai sumaḡeguna, taudi avedi da a gurina, be yaḡoro tokare ta yawasanana. ");
INSERT INTO dww_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Be banaga miemienidima aitauḡa taugu tawai sumaḡeguna, taudi tokare nam airaḡan ta guri. Inam giunama kwawai sumaḡe bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Be Mata ya riuna, “Bada, taugu yàwai sumaḡana da tam vutuna Tauwai yawasana Mamaitua Natunama, dobue kuya yovona.” ");
INSERT INTO dww_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nama ya giugiu rovona murine, tauna ya munaḡana vadae tasinama Meri ḡarone be mareḡa ya riue da ḡavoe be ya riuena, “Tauwai katakatai ya tava be e ḡoeḡoena e kitamna.” ");
INSERT INTO dww_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Be Meri inam giunama ya vaivaiena, tauna waiḡapa ya midisuḡu makai be ya naḡona Yesu ḡarone. ");
INSERT INTO dww_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mata deḡo Yesu ya banabanavie, inam dabudine Yesu ya miamiana be nam meagaie i tavana. ");
INSERT INTO dww_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jius banegidima Meri a miamia roguena, dabudine a kita da Meri vadae be ma girigirina ya dobi makaina. Dabudine taudi a noḡotina da Meri kabe nuvunama kokoagine ḡaba aubainama i naḡonaḡo, naumeki da taudi ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Raḡanine Meri Yesu ḡarone ya tavatavana, tauna ya raupari be ya riuna, “Bada, deḡoda tam maiḡone uma dabudine ku tavana, nuvuguma tokare nam ya guri.” ");
INSERT INTO dww_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu e kitana be Meri ya ḡabaḡabana, be Jius banegidima Meri a miamia roguena taudi mate a ḡabaḡabana. Inam raḡanine Yesu medi noponama ya karati be nuanama ya gewagewana. ");
INSERT INTO dww_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dabudine Yesu taudi yai taraviredi be ya riuna, “Lasares deḡo dabudine koyai kokoagi?” Be taudi a riuna, “Bada, tà naḡo be kwa kita.” ");
INSERT INTO dww_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Naumeki da Yesu ya ḡabana. ");
INSERT INTO dww_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Be banaga dabudine a midimidina taudi a riuna, “Ko kita, Lasares tauna nuanama ya paḡo kauena.” ");
INSERT INTO dww_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Be ḡesaudima a riuna, “Uma tauḡominama banaga matapotapotanama yai yawasanina, be aba aubainama tauna Lasares varinama ya vaia yababe be ya guri?” ");
INSERT INTO dww_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Dabudine Yesu medi noponama ya kara munaḡe be kokoagae ya tavana. Lasares kokoaginama inam gubae. Be gubanama gayane yeku dosinama ai miditomna. ");
INSERT INTO dww_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Be Yesu ya riuna, “Yeku ko taurie ḡavoe e naḡo!” Be Mata ya riuna, “Bada, yodi tokare pana e morabana, baninama tauna kokoagae ya kenana raḡan 4 a kovina.” ");
INSERT INTO dww_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Be Yesu ya riuena, “Taugu è riuem bo ibewa da tam kwai sumaḡana tokare Mamaitua neneḡarinama kwa kitana.” ");
INSERT INTO dww_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dabudine taudi Yeku a raurie da ḡavoe ya naḡo, yodibe Yesu gunuma ya kitasaḡe be ya riuna, “Mamai, yàwai kaiwemna da tam taugu bonaguma kuya vaiena. ");
INSERT INTO dww_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Taugu è kataiena da tam raḡan matabuna taugu bonaguma kwa vaivaiena, be uma banegidima ta midimidina, taudi kadi taiye taugu bonaguma dosine yà riuna da taudi sibo a vaie be ai sumaḡa da tam taugu kuya riuporeguna.” ");
INSERT INTO dww_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu nama ya giugiu kovina, tauna bonanama dosine ya riuna, “Lasares, kwa dobi!” ");
INSERT INTO dww_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Naumeki da tauḡoma gurigurinama gubae be ya dobina. Tauna nimanama, kaḡanama, debanama be tuninama matabuna garae sumasumanama. Naumeki da Yesu ya riuna, “Gara ko kuvesa poredi be e naḡona!” ");
INSERT INTO dww_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jius banegidima toitoi Meri nuadubuenama aubainama a tavatavana, taudi Yesu aba ya voivoiena a kita be tauna ai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Be banaga ḡesaudima taudi a naḡo be Yesu aba ya voivoiena Parisi ḡarodie ai samanina. ");
INSERT INTO dww_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Dabudine pirisi adi babadama be Parisi ai rawateḡeidina Sanedrion waiborunama aubainama. Be dabudine taudi a riuna, “Yodi aba tà voie? Uma tauḡominama mataira toitoi e voivoiedina. ");
INSERT INTO dww_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Deḡoda tauda tà kita yababena, banaga matabudi tokare tauna tai muriwatanena. Inam raḡanine tauiḡara Romḡa tokare ta verau, be dà tempolma be dà dobuma ta kawa gewegewedina.” ");
INSERT INTO dww_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Naumeki da tauḡoma tenaḡa isanama Kaiyapas, tauna pirisi adi badama inam modinama nopone. Tauna ya midisuḡu be ya riuna, “Taumi buebuemima, ");
INSERT INTO dww_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nam aiyaba ko kataiena. Ya verena da inam baneginama tenaḡa sibo ya gurina, be tauda matabuda sibo tè yawasanana.” ");
INSERT INTO dww_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Inam giunama nam Kaiyapas nuane i giu yababana, ibewa. Be tauna pirisi adi badama ya miamiana inam modinama nopone, vutuna aubainama tauna yai perovetana da Yesu sibo ya gurina Jius banegidima matabudi aubaidima. ");
INSERT INTO dww_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Be nam Jius taudiḡa, ibewa da Mamaitua na sedama dobu matabuna nopone a daberara be ta miamiana, taudi mate aubaidima tauna e guri be e rawateḡeidi da taudi tenaḡa ta tubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Naumeki da inam raḡanine be nokoi ya naḡona taudi Yesu na kasirama tomnama ai karena da sibo ai gurina. ");
INSERT INTO dww_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Vutuna aubainama Yesu nam patara nopodie i noya munaḡana, tauna ya gosedi be ya naḡona Epreim meagaine. Inam meagainama dobu kavakavanama diane, be dabudine tauna na tauwai muriwatanama mate a miana. ");
INSERT INTO dww_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Naumeki da Naḡopore soinama raḡaninama maida ya tavatavana aubainama, banaga toitoi Israel nopone miemienidima a rauria be a saḡa a naḡona Jerusalemma. Baninama muriḡa da Naḡopore soinama sibo ya tavana, be noḡone taudi adi vaivaima da sibo a sigu dokana. ");
INSERT INTO dww_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dabudine taudi a ḡoeḡoena da Yesu sibo a kitana. Vutuna aubainama taudi tempol dianaḡa a midi babara be adi banagama adi banagama ai taraviredi be a riuriuna, “Aba ko noḡonoḡoti, Yesu tokare soie e saḡa bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Inam dabudine pirisi adi babadama be Parisi, taudi adi giuma bagibaginama a boruna da aitau Yesu e kitana, waiḡapa taudi ḡarodie ei maḡatarana. Yodibe tauna ta vunuḡina. ");
INSERT INTO dww_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Raḡan 6 a kenakenana muriḡa da Naḡopore soinama e tavana. Be Yesu tauna ya naḡona Betenima Lasares na vadae, tauna vutuna ya gurina be Yesu ya kawa midisuḡu munaḡena. ");
INSERT INTO dww_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Dabudine Yesu na kanima a vokaukauena. Naumeki da Mata kani ya tebodi be Yesu, Lasares be banaga ḡesaudima mate gunie a miamiana ya ute nawedina. ");
INSERT INTO dww_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Be Meri dabudine upa ḡabuḡabunama ya paḡo da Yesu kaḡanama debane ya ḡini be deba vuvuḡine Yesu kaḡanama ya ravusina. Be inam upanama isanama ‘Nad’ be maesinama dosinama. Be inam vadanama noponama matabuna ḡabuḡa ya kaiyaḡotina. ");
INSERT INTO dww_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Be Yesu na tauwai muriwatanama tenaḡa isanama Judas Iskariot, tauna vutuna tokare Yesu e boru dobiḡena, tauna umanama ya riuna, ");
INSERT INTO dww_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Inam upanama ḡabuḡabunama maesinama ya moraba kauana! Taumi sibo koya raugimare be mane banaga waikaruwaḡewaḡedima sibo koya utedina.” ");
INSERT INTO dww_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas nam banaga waikaruwaḡewaḡedima i noḡotidi be inam giunama i vatona, ibewa da tauna banaga danedanenenama, aubainama nama ya giuna. Baninama Judas tauna mane taurabenama be wari raḡan tauname aubainama mane nevedima ya rarau soru poraḡana. ");
INSERT INTO dww_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Be Yesu tauna ya paribee be ya riuna, “Nam Meri kwa tainuaraḡaraḡa, kwa gose pore. Tauna umanama ya voiana inam ya kawa nonoḡiguna waikokoagiguma aubainama. ");
INSERT INTO dww_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Banaga waikaruwaḡewaḡedima raḡan matabuna taumi mate ko miamiana. Be taugu nam tokare taumi mate tà mia gurata.” ");
INSERT INTO dww_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Taudi dabudine yaḡoro a kanikanina, be patara dosinama a kataie da Yesu tauna Lasares na vadae ya miamiana. Vutuna aubainama a verauna kitanama aubainama, be nam Yesu taunaḡa, Lasares mate kitanama aubainama a verauna, baninama tauna ya gurina, be Yesu yai yawasani munaḡena. ");
INSERT INTO dww_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Inam kauinama aubainama pirisi babadidima adi ogama a taraḡina da Lasares mate sibo ai gurina. ");
INSERT INTO dww_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Baninama tauna kana taiye banaga toitoi Jius babadidima a gosedi be Yesu ai muriwatanena. ");
INSERT INTO dww_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pomainama banaga soi aubainama a tavatavana, taudi a vaie da Yesu ya saḡasaḡana Jerusalemma. ");
INSERT INTO dww_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Vutuna aubainama banaga toitoi garamo a ragaudi da a dobi a naḡona veraubodenama aubainama, be bonedima dosine a yogo be a riuriuna, “Hosana, waiaiaininama tauna vutuna Bada isane e veraverauna! Israel guyaunama waiaiaininama!” ");
INSERT INTO dww_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu donki natunama ya banavi be debane ya miana, maika girugiruminama porane ya riuriuna nama, ");
INSERT INTO dww_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jerusalem banegimima nam ko naira, ko kitana ami guyauma donki natunama ya gerue be ḡaromie e veraverauna.” ");
INSERT INTO dww_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesu na tauwai muriwatanama uma kauidima noḡone nam ti kataiedina. Be Yesu marae ya saḡa ya naḡonaḡona murine, girugiruminama porane aba a riuriuedina, vutudi Yesu na tauwai muriwatanama a noḡotidina, be a kataie da noḡone aba awai perovetaena yodi a tubuḡa be a kitana. ");
INSERT INTO dww_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Be maiḡone Lasares ya guri da kokoagae ya kenakenana. Be Yesu Lasares gurigurinama kokoagae ya riue, be ya kawa midisuḡu munaḡe da ya dobina. Inam raḡanine banaga toitoi dabudi mate, be Yesu aba ya voie be a kitakitana, taudi inam varinama ai daberarina. ");
INSERT INTO dww_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Be banaga toitoi inam varinama a vaiena. Vutuna aubainama taudi garamo a ragaudi be a dobi a naḡona Yesu naḡobodenama aubainama. ");
INSERT INTO dww_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Dabudine Parisi taudi adi banagama adi banagama a riuedina, “Yodi aba tà voie? Banaga matabudi Yesu tawai muriwatanena.” ");
INSERT INTO dww_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Inam soinama nopone dabudine Gurik banegidima ḡesaudima mate inam soinama aubainama a tavana. ");
INSERT INTO dww_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Taudi a verauna Pilip ḡarone. (Pilip tauna Betsaida baneginama Galili provins nopone.) Be taudi Pilip ai baḡa be a riuna, “Yau tura, tauma Yesu kitanama ka ḡoeḡoena.” ");
INSERT INTO dww_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Naumeki da Pilip ya naḡo Endru yai vari be rabuidi a naḡona Yesu riunama aubainama. ");
INSERT INTO dww_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Be Yesu ya paribeedi be ya riuna, “Yodi raḡan ya tavana da Banaga Natunama neneḡarinama e maḡatarana. ");
INSERT INTO dww_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yà riuriu kauemina, deḡoda pesi nam doḡa nopone ko kuma be e guri, inam tokare kitanama teneḡinama nama e kenakenana. Be deḡoda pesi doḡa nopone kwa kuma be e gurina, inam raḡanine tokare e gogo tava be baninama toitoi e sivudina. ");
INSERT INTO dww_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aitau da tauname na yawasanama ewai nuaboyena, tokare na yawasanama e kawa gewagewana. Be aitau da uma dobune nam na yawasanama imawai nuaboyena, tauna tokare yawasana kenakena nonoḡinama e paḡona. ");
INSERT INTO dww_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aitau aubaiguma noya e ḡoeḡoena, naumeki da ei muriwataneguna. Deḡo yà naḡonaḡo bo yà miamiana, tauna taugu mate. Be Tamaguma inam banegidima aitauḡa aubaiguma ta noyanoyana, tokare e kawa saḡedina. ");
INSERT INTO dww_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Be yodi taugu èi nuaboya kauana be nema yà riu bako? Umanama yà riu bo avedi, ‘Mamai, kwa sagugu da uma nuaboyanama nam yà sigue.’ Ibewa, nam nama yà riu, baninama inam vutuna aubainama uma dobudine è yovona. ");
INSERT INTO dww_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taugu umanama yà riuna, ‘Mamai, tamḡa isamma kwa kawa saḡe munaḡemna.’” Naumeki da bona marae ya dobi be ya riuna, “Taugu kaiteka isaguma è kawa saḡe munaḡeguna be yodi yà voia munaḡena.” ");
INSERT INTO dww_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Inam raḡanine patara bona a vaivaiena, banaga ḡesaudima a riuna, “Inam parere.” Be ḡesaudima a riuna, “Ibewa, inam anea Yesu ḡarone e giugiuna.” ");
INSERT INTO dww_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dabudine Yesu ya riuna, “Taumi anisagumima aubainama inam bonanama ya dobina, nam taugu. ");
INSERT INTO dww_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yodi raḡan ya tavana da Mamaitua dobu ei tarapirie be dobunama tauwai badenama e tavu dobiḡena. ");
INSERT INTO dww_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Be taudi korosie tawai daweguna raḡanine, taugu yau banagama matabudi yà verauḡedina ḡarogue.” ");
INSERT INTO dww_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Inam giudima tauna ya vatodina da banaga sibo a kataie da tauna tokare nema e guri bakona. ");
INSERT INTO dww_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Dabudine banaga a riuna, “Tauma tarawatu nopone kè kataiena da Tauwai yawasana tauna tokare e mia nonoḡana. Be yodi nemanama da kwa riuriuna, ‘Banaga Natunama tokare korosie tai dawe? Banaga Natunama inam aitau?’” ");
INSERT INTO dww_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Be Yesu ya riuedina, “Taugu vutuna ami yanama, be taugu tokare nam taumi mate tà mia gurata. Vutuna aubainama yodi raḡan daumorine taumi inam yananama noponaḡa ko babarana. Inam kedane tadiwanawana tokare nam e rupu tawemi. Baninama aitauḡa tadiwanawana noponaḡa ta babababarana, taudi keda nam tima kitakitana, taudi ta naḡonaḡona aikedae ta tavana nam ti kataiena. ");
INSERT INTO dww_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Taumi yana yodi ḡaromie e miamiana maika, naumeki da taumi yananama koi sumaḡena, inam raḡanine taumi tokare yana natunatunama ko tubuḡana.” Be Yesu na giuma yawai kovina, murine tauna ya gosedi be ya naḡo waimatapoviedina. ");
INSERT INTO dww_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu mataira toitoi Jius matedie ya voiedina, be taudi yaḡoro nam ti sumaḡena, ");
INSERT INTO dww_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","baninama peroveta Aisaia aba ya riuriuena nama a tubuḡana. Tauna umanama ya riuna, “Bada, aitau tokare ama giuma ei sumaḡe? Be aitau ḡarodie tokare am rewapanama kwai maḡatari?” ");
INSERT INTO dww_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Be mate Aisaia gabu ḡesaune umanama ya riuna, ");
INSERT INTO dww_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mamaitua taudi matedima be nuedima yai potedina, inam kedane taudi matedie nam aba sibo a kita, bo nuedie nam aba sibo a kataie da nuedima a vitaredi be sibo ei yawasanidi.” ");
INSERT INTO dww_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia nama ya riuna, baninama tauna kaite Yesu neneḡarinama ya kita be ya giuena. ");
INSERT INTO dww_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Be yaḡoro banaga toitoi be Jius babadidima toitoi mate Yesu ai sumaḡena. Be taudi Parisi a nairedina, baninama deḡoda sinagog nopone be tima tavu dobiḡedi. Vutuna aubainama taudi nam ti maḡatara munaḡedina da taudi tauwai sumaḡa, ");
INSERT INTO dww_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","baninama taudi a ḡoeḡoena da Mamaitua sibo ya kawa saḡedina. Be adi ḡoana kauama inam sibo banaga taudi a kawa saḡedina. ");
INSERT INTO dww_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dabudine Yesu bonanama dosine ya riuna, “Banaga aitau taugu ewai sumaḡeguna, inam nam tauguḡa imawai sumaḡeguna, ibewa da tauriuporeguma mate ewai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Be deḡoda aitau taugu ya kitaguna, inam tauriuporeguma kaite ya kitana. ");
INSERT INTO dww_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Taugu è yovona dobu waiyananama aubainama. Be aitau taugu ewai sumaḡeguna, tauna tokare nam tadiwanawanae e mia. ");
INSERT INTO dww_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Be aitau da yau giuma e vaivaiedina be nam e voteyeteyedi, taugu nam yodi tauna yài tarapirie, baninama taugu nam dobu waitarapirienama aubainama e yovona, ibewa da taugu dobu waiyawasaninama aubainama è yovona. ");
INSERT INTO dww_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Be aitau da taugu e riuriu tuatuaḡaiegu be yau giuma nam ei aninedi, tauna tokare kovoḡa e banavina. Baninama raḡan damone taugu yau giuma tokare tauna ta etarena. ");
INSERT INTO dww_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Taugu nam nuague ama giugiu yababana, ibewa da Tamaguma tauriuporeguma tauna ya riu vavasaḡeguna da taugu aba yà giuena. ");
INSERT INTO dww_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Be taugu è kataiena da tauna na giuma ewai kataimina da taumi yawasana kenakena nonoḡine ko tavana. Vutuna aubainama Tamaguma aba ya riuriueguna, ruvane nama yà giugiuna.” ");
INSERT INTO dww_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Naumeki da Naḡopore Soinama raḡaninama ḡaubonaḡa da sibo ya tavana. Be Yesu tauna kaite ya kataiena da na raḡanima ya tavana da uma dobunama e gose be e munaḡana Tamanama risine. Dabudine tauna na tauwai muriwatanama yai kataidi da tauna ewai nuapaḡo kauedina. ");
INSERT INTO dww_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ravie kani na raḡanie Diaboro kaite Judas Iskariot, nopone noḡota gewagewanama ya boruna da Yesu e boru dobiḡena, Judas tauna vutuna Saemon natunama. ");
INSERT INTO dww_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Be Yesu ya kataiena da Tamanama rewapana matabuna tauna nimane ya boruna da yaba matabudi ei badedina. Be mate tauna ya kataiena da tauna Mamaitua ḡarone be ya yovona, be yodi e munamunaḡana. ");
INSERT INTO dww_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Vutuna aubainama Yesu kani nopone ya midisuḡu da na kwamama ya kaipore, be taweri ya paḡo da bogane yai rauvirina. ");
INSERT INTO dww_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yodibe tauna disi ya paḡo da nopone upa ya ḡini be na tauwai muriwatanama kaḡedima ya koḡedi be inam tawerine kaḡedima ya ravusidina. ");
INSERT INTO dww_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Be raḡanine Yesu Saemon Pita ḡarone ya tavatavana, Pita ya riuena, “Bada umanema nama da tam taugu kaḡaguma kwa koḡa?” ");
INSERT INTO dww_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Be Yesu tauna ya riuena, “Taugu yodi aba yà voivoiena baninama tam nam ku kataiena, be tokare kwa kataie da baninama aba.” ");
INSERT INTO dww_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Be Pita ya riuna, “Avedi, nam airaḡan kaḡaguma kwa koḡedi!” Be Yesu ya paribeena, “Deḡoda taugu kaḡamma nam yà koḡa, tam taugu nam yau tauwai muriwatana.” ");
INSERT INTO dww_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Be Saemon Pita ya riuna, “O Bada, deḡoda nama, naumeki da nam kaḡaguḡa kwa koḡedi, be nimaguma be debaguma mate kwa koḡedina.” ");
INSERT INTO dww_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Be Yesu ya riuena, “Banaga aitau da tuninama matabuna topa nopone ya yovo be ya sigu ḡomana, inam baneginama kaḡanama taunaḡa tokare e koḡedina, baninama tauna kaite ya sigu be verenama e miamiana. Be taumi inam koya sigu be veremima ko miamiana, be ḡesaumima nam veremi.” ");
INSERT INTO dww_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu nama ya riuna, baninama tauna kaite ya kataie da aitau tokare tauna e boru dobiḡena. Vutuna aubainama tauna ya riuna, ‘Ḡesaumima nam veremi’. ");
INSERT INTO dww_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Raḡanine taudi kaḡedima ya koḡakoḡa kovina, tauna na kwamama ya kote munaḡe da ya munaḡa na gabue ya mia be yai taraviredina, “Taugu aba yodi è voiena baninama koya kataie bo ibewa? ");
INSERT INTO dww_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Taumi ko riuriueguna ‘Tauwai katakatai’ be ‘Bada’. Be inam ko riuriu kauana, baninama inam vutuna taugu. ");
INSERT INTO dww_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Be yodi koya kita, taugu ami Badama be ami Tauwai katakataima be yaḡoro kaḡemima è koḡedina. Vutuna aubainama taumi taumiḡa ami banagama ami banagama mate kaḡemima sibo nama koya koḡedina. ");
INSERT INTO dww_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Taugu yodi mataira verenama è voie be koya kitana, be taumi nama sibo koya voiana, ");
INSERT INTO dww_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","baninama taunoya tauna nam tokare na badama e saḡa pore, be mate tauwai noyanoya tauna nam tokare tauriuporenama e saḡa pore. ");
INSERT INTO dww_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yodi taumi uma yabedima koya kitedi be koya kataiedina, be deḡoda ko voiedina, taumi tokare waiaiaina ko banavina. ");
INSERT INTO dww_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Taugu nam matabumi ḡaromie uma yabedima ama giugiuedina, ibewa da taugu è vinemina aubainama tenatenaḡaḡa ami yawasanama è kataiedina. Be girugiruminama porane aba a riuriuena inam riukaua, taudi a riuna, ‘Banaga aitau da yau kanima nevanama ya kanina, tauna vutuna ya midi vitare be yai ḡavieguna.’ ");
INSERT INTO dww_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Uma kauinama muriḡa da e tubuḡana yodi yà riuriu wainonoḡimina, be tokare e tubuḡana raḡanine, dabudine koi sumaḡa da taugu vutuna Tauwai yawasana. ");
INSERT INTO dww_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Taugu yà riuriu kauemina, aitau da yau tauwai noyanoyama ei aninena, tauna inam taugu ewai anineguna. Be aitau da taugu ei anineguna, tauna inam tauriuporeguma ewai aninena.” ");
INSERT INTO dww_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu nama ya riuriuna murine, tauna noponama nuaboya ya moḡavu be ya riuna, “Yà riuriu kauemina, nopomie tenaḡa tokare taugu e boru dobiḡeguna.” ");
INSERT INTO dww_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dabudine tauwai muriwatana tenatenaḡaḡa turanama turanama matanama ya kita be a nuanua babaḡana da Yesu aitau e riuriue. ");
INSERT INTO dww_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Be taudi nopodie tenaḡa Yesu tura kaukauinama tauna Yesu diane ya miamiana. ");
INSERT INTO dww_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Naumeki da Saemon Pita inam baneginama Yesu diane miemieninama mamareḡa ya riu kasave be ya riuena, “Bada kwa riue, aitau tauna e riuriue?” ");
INSERT INTO dww_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dabudine inam baneginama Yesu diane miemieninama ya kekera naḡo Bada diaḡomine be mamareḡa ya riu kasavena, “Bada, aitau tokare tam e boru dobiḡem?” ");
INSERT INTO dww_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu ya paribee be ya riuna, “Kwa kita be taugu raḡanine buredi riku nopone yai gayo be banaga aitau yà utena, inam baneginama vutuna taugu e boru dobiḡeguna.” Naumeki da Yesu buredi riku nopone yai gayo be Judas Iskariot ya utena. Tauna vutuna Saemon natunama. ");
INSERT INTO dww_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Raḡanine Judas buredi ya paḡo be ya kanikanina, Seitan Judas nopone ya saḡana, dabudine Yesu Judas ya riuena, “Tam aba voienama yodi kwawai nuanoḡonoḡotena, naumeki da waiḡapa kwa voiena.” ");
INSERT INTO dww_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Be ḡesaudima dabudine a kanikanina nam ti kataiena aba aubainama Yesu nama Judas ya riue. ");
INSERT INTO dww_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Be Judas tauna mane taurabenama. Vutuna aubainama, na banagama ḡesaudima ai noḡotana kabe Yesu Judas i riuriupore nawe soi kanima gimerinama aubaina, bo mane banaga waikaruwaḡewaḡedima kabe e utedi. ");
INSERT INTO dww_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Dabudine Judas ya dobi be kupiḡa ya naḡona. ");
INSERT INTO dww_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Raḡanine Judas ya dobi be ya naḡonaḡona murine Yesu ya riuna, “Yodi raḡan ya tavana da taugu Banaga Natunama neneḡariguma e maḡatarana. Be abaḡa taugu ḡarogue ta tubutubuḡana raḡanine, Mamaitua neneḡara dosinama e paḡona. ");
INSERT INTO dww_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Inam raḡanine Mamaitua tokare waiḡapa banaga ei kataidi da Banaga Natunama tauna ya saḡa vavasaḡana. ");
INSERT INTO dww_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yau sedama, noḡone nema Jius babadidima è riuriuedina, nama yodi taumi yà riuriuemina, da taugu tokare taumi mate nam tà mia gurata. Taumi tokare ko waneguna, be deḡo taugu yà naḡonaḡona, dabudi taumi tokare nam ko tava. ");
INSERT INTO dww_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Be yodi riuvavasaḡa vaunama yà utemina inam: Ami banagama ami banagama nuemima ta paḡona, nema taugu yàwai nuapaḡoemina nama. ");
INSERT INTO dww_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Deḡoda koi nuapaḡo vivirana, inam raḡanine banaga matabudi tokare ta kataiemi da taumi taugu yau tauwai muriwatanama.” ");
INSERT INTO dww_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dabudine Saemon Pita Yesu yai taravirena, “Bada, tam deḡo kwa naḡonaḡo?” Be Yesu ya riuna, “Taugu deḡo yà naḡonaḡona, dabudi tam yodi nam kwa tava be teneḡina, be tokare tam dabudine kwa tavana.” ");
INSERT INTO dww_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Be Pita ya riuna, “Bada, aba aubainama dabudine yodi nam yà tava? Taugu yodi inam teneteneḡinama da tam mate tà gurina.” ");
INSERT INTO dww_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Be Yesu tauna ya riuena, “Tam kuya noḡoti da teneḡinama taugu mate tà gurina. Be taugu yà riuriu kauemna da tam tokare raḡan rabuiteḡa taugu kwa bovieguna, muriḡa da kamkam e riuna. ");
INSERT INTO dww_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Nam koi nuaboya, Mamaitua koi sumaḡe, be mate taugu koi sumaḡeguna. ");
INSERT INTO dww_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tamaguma na vadae gabu toitoi ta kenakenana, be taugu yodi dabudine yà naḡonaḡona ami gabuma yà vokaukauedina. Be deḡoda gabu sibo ibewa, taugu tokare nam e riuemi. ");
INSERT INTO dww_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Be raḡanine yà naḡo be gabu yà vokaukaua rovona murine, taugu tokare yà verau munaḡa be matabumi yai doka nawemina yau kaba miae. Be dabudine matabuda tokare tà mia tenaḡana. ");
INSERT INTO dww_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Be taugu deḡo yà naḡonaḡona kedanama taumi koya kataiena.” ");
INSERT INTO dww_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Be Tomas Yesu ya riuena, “Bada, keda nema ka kataie bake? Tauma nam ke kataiena tam aikedae kwa naḡonaḡo.” ");
INSERT INTO dww_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Be Yesu tauna ya paribee be ya riuna, “Taugu vutuna Keda, Riukaua be Yawasana. Be nam aitau tokare Tamaguma ḡarone e tava be teneteneḡina, ibewa da taugue tokare Tamaguma ḡarone ko tavana. ");
INSERT INTO dww_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Deḡoda taumi ko katai kaueguna, taumi tokare Tamaguma mate sibo koya kataiena. Taumi yodi da nokoi ya naḡona Tamaguma koya kataiena, baninama tauna kaite koya kitana.” ");
INSERT INTO dww_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Dabudine Pilip ya riuna, “Bada, Tamamma kwai kataimai, yodibe nuamaima e verena.” ");
INSERT INTO dww_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Be Yesu ya riuna, “Pilip, taugu noya èwai karee da yodi taugu raḡan matabuna taumi mate tè miamiana, be yaḡoro tam nam ku kataieguna da taugu aitau. Be aba aubainama kwa riuriuna, ‘Tamamma kwai kataimai’? Banaga aitau da taugu ya kitaguna, inam Tamaguma ya kitana. ");
INSERT INTO dww_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Taugu inam Tamaguma nopone be tauna taugu nopogue, inam riunama tam kwawai sumaḡe bo ibewa? Abaḡa yà giugiuedina inam nam nuague ama giugiu yababedina, ibewa da Tamaguma nopogue e miamiana, tauna vutuna na noyama e voivoiedina. ");
INSERT INTO dww_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taugu inam Tamaguma nopone be tauna taugu nopogue, inam riunama tam naumeki kwai sumaḡena. Be deḡoda ibewa, naumeki da mataira dosidima yà voivoiedina, vutudi sibo kuya kitedi be kuyai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Yà riuriu kauemina, aitau ewai sumaḡeguna, tauna tokare voia dosidima taugu è voivoiedina, teneḡidima nama tauna e voiedina. Be nam inam vutudiḡa, ibewa da tauna tokare voia dosi vavasaḡidima mate e voiedina, nam maika taugu è voivoiedina nama. Baninama taugu Tamaguma ḡarone yà naḡonaḡona aubainama. ");
INSERT INTO dww_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Be aiyaba taugu isague koi baḡena, taugu tokare yà voiena, Tamaguma isanama kawa saḡenama aubainama. ");
INSERT INTO dww_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Be taugu isague aba koi baḡaguna, tokare yà voiena. ");
INSERT INTO dww_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Taumi deḡoda koi nuapaḡoeguna, taugu aba è riuriu vavasaḡemina, tokare ko voteyeteyedina. ");
INSERT INTO dww_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","“Taugu tokare Tamaguma yài baḡa da tauna tokare ami tausaguma ḡesau e riupore yovoḡe ");
INSERT INTO dww_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","be taumi mate ko mia nonoḡana, tauna vutuna Riukaua Aruinama. Be dobu banegidima taudi nam teneteneḡina da tauna tai anine be adi tausaguma e tubuḡa, baninama taudi nam Arua tima wanewanena da sibo a kataie. Be taumi tauna koya kataiena, baninama inam Aruinama yodi taumi mate ko miamiana, be tokare tauna nopomie e miana. ");
INSERT INTO dww_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Taugu nam tokare yà gose pore yababemi seda kedekededima maika. Ibewa, taugu tokare yà verau munaḡana ḡaromie. ");
INSERT INTO dww_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Raḡan ḡaubonaḡa dobu banegidima tokare nam ta kita munaḡegu. Be taumi tokare ko kita munaḡeguna. Taugu yà yawasana munaḡana, aubainama taumi mate tokare ko yawasanana. ");
INSERT INTO dww_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Taugu yà guri be yà midisuḡu munaḡana raḡanine, dabudine taumi tokare ko kataie da taugu Tamaguma nopone. Be taumi taugu nopogue, be taugu taumi nopomie. ");
INSERT INTO dww_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tauna aitau yau riuvavasaḡama e vovo teyeteyedina, tauna vutuna taugu ewai nuapaḡoeguna. Be tauna ewai nuapaḡoeguna aubainama, Tamaguma be taugu tokare tauna kai nuapaḡoena, be ḡarone taugu yà maḡatarana.” ");
INSERT INTO dww_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dabudine Judas ḡesau (nam Judas Iskariot), tauna Yesu ya riuena, “Bada, aba aubainama taumaḡa ḡaromaie kwa maḡatara be nam dobu banegidima ḡarodie?” ");
INSERT INTO dww_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Be Yesu ya paribee be ya riuna, “Aitau ewai nuapaḡoeguna, tauna yau giuma matabuna tokare e voteyeteyedina. Be Tamaguma inam baneginama ei nuapaḡoe, be tauma inam baneginama ḡarone ama kaba miama kai tubuḡi be dabudine ka miana. ");
INSERT INTO dww_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Be aitau nam imawai nuapaḡoeguna, tauna yau giuma tokare nam e voteyeteyedi. Inam giudima nam nuague amawai tubuḡidi be ama giugiuedina, ibewa da Tamaguma tauriuporeguma tauna uma giudima ya utegu be yà giugiuedina. ");
INSERT INTO dww_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Taugu yodi yaḡoro taumi mate tà miamiana, aubainama uma kauidima yà giugiuedina. ");
INSERT INTO dww_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Taugu isague Tamaguma tokare tausagu Arua Babau e riupore yovoḡena ḡaromie. Be tauna tokare yaba matabuna ei katakataimina, be abaḡa è giugiuedina tokare tauna e riuwai noḡotimina. ");
INSERT INTO dww_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Taugu yà naḡonaḡona be yau subama nopomie yà boruna. Taugu yau subama inam nam dobu banegidima suba ta voivoiena maika, vutuna aubainama nam ko naira bo koi nuaboya. ");
INSERT INTO dww_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Taugu è riuemina da taugu yà naḡona, be tokare yà verau munaḡana ḡaromie. Deḡoda nuemima tabutabune sibo koi nuapaḡoeguna, taumi sibo nuemima ya verena da taugu yà naḡonaḡona Tamaguma ḡarone. Baninama tauna ya saḡa guratana nam maika taugu. ");
INSERT INTO dww_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Uma kauidima muriḡa da ta tubuḡana yodi yà riuriu wainonoḡimina, be tokare ta tubuḡana raḡanine, dabudine koi sumaḡa da taugu aba è riuriuemina inam matabudi riukaua. ");
INSERT INTO dww_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Be yodi nam gavogavo ima kenakenana da tà giu gurata, baninama uma dobunama kana guyauma kaiteka maida e tavatavana. Tauna nam na rewapanama ḡarogue ima kenakenana. ");
INSERT INTO dww_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Taugu Tamaguma aba ya riuriuena, vutuna yà voiena. Yodibe dobu banegidima tokare ta kataie da taugu Tamaguma yàwai nuapaḡoena. Ko midisuḡu tà naḡo. ");
INSERT INTO dww_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Taugu vutuna waen kainama, be Tamaguma tauna waen taukumanama. ");
INSERT INTO dww_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Be waen ragedima ḡesaudima nam votevotedi, tauna ewai miaraka poraḡana. Be raga ḡesaudima votevotedima, tauna e tomtom vuneḡidina da taudi ta vota kauana. ");
INSERT INTO dww_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Be taugu yau waikatakataie Tamaguma kaite taumi ya tom vuneḡimi be koya verena. ");
INSERT INTO dww_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Taumi naumeki da taugu nopogue ko miana, be taugu taumi nopomie yà miana. Baninama deḡoda waen raganama e nuagasi poraḡana inam raganama tokare nam e vota. Be teneḡinama nama deḡoda taumi nam nopogue ko mia, taumi tokare nam ko vota. ");
INSERT INTO dww_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Taugu vutuna waen kainama, be taumi waen ragedima. Aitau da taugu nopogue e miana, be taugu tauna nopone yà miana, tauna tokare e vota kauana. Be deḡoda taumi ko gosegu be ḡavoe ko midi teḡana, taumi tokare nam ko vota rubu. ");
INSERT INTO dww_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Be aitau nopogue nam e mia, tauna inam waen raganama ta tom pore be ta pokipokina maika. Inam ragedima pokipokidima tokare ta ragaudi be kai matane ta gabu gorudina. ");
INSERT INTO dww_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Deḡoda taumi nopogue ko mia nonoḡa be riuguma taumi nopomie e kenana, taumi aba kowai baḡena, tokare ko banavina. ");
INSERT INTO dww_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Taumi ko votavota kauana raḡanine, Tamaguma neneḡarinama tokare dabudi e maḡatarana. Inam kedane banaga tokare ta kataie da taumi taugu yau tauwai muriwatanama. ");
INSERT INTO dww_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Tamaguma nema taugu yai nuapaḡo bakeguna, nama taumi yàwai nuapaḡoemina. Be yodi inam wainuapaḡone ko miana! ");
INSERT INTO dww_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Deḡoda taugu yau riuvavasaḡama ko voteyeteyedina, taumi tokare yau wainuapaḡoe ko miana, nema taugu Tamaguma na riuvavasaḡama è voteyeteyedi be na wainuapaḡoe yà miamiana nama. ");
INSERT INTO dww_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Taugu nama yà riuriuemina da nuavere taugu nopogue kenakenanama, teneḡinama taumi nopomima e moḡavuna. ");
INSERT INTO dww_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Be taugu yau riuvavasaḡama inam uma: Ami banagama ami banagama nuemima ta paḡona, nema taugu yàwai nuapaḡoemina nama. ");
INSERT INTO dww_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wainuapaḡo dosinama inam umanama: Banaga deḡoda na yawasanama ei utae be na banagama aubaidima e gurina, inam vutuna wainuapaḡo dosi vavasaḡinama inam baneginama ya voiena. ");
INSERT INTO dww_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Be taumi deḡoda yau riuvavasaḡama ko voteyeteyedina, taumi vutuna taugu yau banagama. ");
INSERT INTO dww_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Boni taugu è riuriuemina, taumi taunoya. Be taunoya tauna na badama aba e voivoiedina, tauna nam ima katakataiedina. Vutuna aubainama yodi yà riuriuemina, taumi taugu yau banagama, baninama taugu Tamaguma aba ya riuriueguna, matabudi taumi è riuemina. ");
INSERT INTO dww_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Taumi nam taugu ko vineguna, be taugu taumi è vinemina da ko naḡo be ko votana. Be inam votedima tokare ta kena nonoḡana. Yodibe aba isague koi baḡena, Tamaguma tokare e utemina. ");
INSERT INTO dww_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yà riuriu vavasaḡemina da ami banagama ami banagama mate koi nuapaḡona. ");
INSERT INTO dww_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Deḡoda dobu banegidima taumi ta tuaḡaiemina, dabudine ko noḡoti da taugu noḡone a tuaḡai dokeguna. ");
INSERT INTO dww_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","“Deḡoda taumi sibo dobu ḡaronama, taudi tokare ai nuapaḡoemina. Be ibewa da taumi nam dobu ḡarona, baninama taugu è vinemina da inam dobunama ko dobi porena. Vutuna aubainama dobu banegidima ta tuatuaḡaiemina. ");
INSERT INTO dww_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Be banaga taudi kaite taugu ta raraukivi gewegeweguna. Be noḡone aba è riuriuemina, vutudi ko noḡotidi: ‘Taunoya tauna nam tokare na badama e saḡapore.’ Vutuna aubainama taumi mate tokare nama ta raukivi gewegewemina. Be deḡoda banaga yau giuma sibo ti vovo teyeteyedina, naumeki da taumi mate ami giuma tokare a voteyeteyedina. ");
INSERT INTO dww_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Be taumi taugu ḡaroḡaroguma aubainama, banaga tokare taumi ta raukivi gewegewemina. Baninama taudi tauriuporeguma nam ti kataiena. ");
INSERT INTO dww_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Taugu ḡarodie è maḡatara be Tamaguma riunama è giuena. Be taudi yaḡoro da ḡarogue nama ta voivoiana, vutuna aubainama taudi ḡarodie naumeki da gewagewa e kenakenana. Be deḡoda taugu ḡarodie nam sibo e yovo be e giu, taudi tokare nam gewagewa ḡarodie ya kena. ");
INSERT INTO dww_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aitau taugu e tuatuaḡaieguna, tauna Tamaguma mate e tuatuaḡaiena. ");
INSERT INTO dww_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Taugu ḡarodie mataira dosidima è voiedina, nam aitau deḡo nama matairidima i voia rubudina. Be taudi inam matairidima a kitedina, be yaḡoro da Tamaguma be taugu ta tuatuaḡaiemaina, vutuna aubainama taudi ḡarodie gewagewa e kenakenana. Be deḡoda taugu sibo mataira dosidima voiedima ibewa, taudi tokare nam gewagewa ḡarodie ya kena. ");
INSERT INTO dww_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Be adi tarawatuma bukane umanama ewai perovetana, ‘Taudi nam aba gewagewanama ḡarogue ti banavina be a tuaḡai yababeguna.’ Inam giudima yodi ta maḡamaḡatarana. ");
INSERT INTO dww_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Taugu tokare tausagu yà riupore yovoḡena ḡaromie. Tauna vutuna Riukaua Aruinama. Tauna Tamaguma ḡarone e yovo be taugu yau voiama e giuedina. ");
INSERT INTO dww_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Be taugu noya èwai karee da yodi taumi mate tè naḡonaḡona. Aubainama taumi mate yau voiama banaga ḡesaudima ḡarodie ko giuedina. ");
INSERT INTO dww_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Uma kauidima matabudi noḡone è riuemina da taumi ami waisumaḡe tokare nam ko beku. ");
INSERT INTO dww_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Taumi tokare sinagog nopodie be ta tavu dobiḡemina. Be raḡan e veraverauna e tavana, banaga tokare tai gurimina, baninama taudi tawai noḡotana kabe Mamaitua na ḡoanama ti voivoie. ");
INSERT INTO dww_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Taudi inam kauidima nama ta voiedina, baninama Tamaguma be taugu taudi nam ti kataiemaina. ");
INSERT INTO dww_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Uma giudima noḡone taugu nam e riu dokemina, baninama taugu yaḡoro taumi mate tè miamiana aubainama. Be yodi uma kauidima yà riuriu wainonoḡimina, be inam kauidima ta tubuḡana raḡanine, aba è riuriuemina vutudi tokare ko noḡotidina. ");
INSERT INTO dww_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Taugu yodi yà naḡonaḡona tauriuporeguma ḡarone. Be nam aitau kui taraviregu be ku riuna, ‘Tam deḡo kwa naḡonaḡo?’ ");
INSERT INTO dww_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","baninama taugu è riuemina aubainama, taumi koyai nuaboyana. ");
INSERT INTO dww_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Be taugu yà riuriu kauemina, ya verena da taugu yà naḡona, be deḡoda nam yà naḡo, tausagu tokare nam e yovo. Be taugu yà naḡona raḡanine, tausagu tokare yà riupore yovoḡena ḡaromie. ");
INSERT INTO dww_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tausagu e yovona raḡanine, tauna tokare dobu banegidima matedima e viriḡaridi da taudime adi gewagewama ta kitedina, be mate tauna didimana kedanama be Mamaitua na etarama ei kataidi da ta kataiedina. ");
INSERT INTO dww_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Be banaga nam timawai sumaḡeguna, taudi tokare tausagu ei kataidi da inam vutuna gewagewa. ");
INSERT INTO dww_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Be taugu yà naḡonaḡona Tamaguma ḡarone. Inam raḡanine taumi tokare nam ko kita munaḡegu, vutuna aubainama tausagu tauna didimana kedanama tokare banaga ei kataidina. ");
INSERT INTO dww_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Be mate tauna banaga ei kataidi da Mamaitua tokare banaga matabudi adi gewagewama aubaidima e etaredina, nema Mamaitua kaite dobu guyaunama etarenama yai karena maika. ");
INSERT INTO dww_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Taugu giu ḡesaudima toitoi mate sibo è riuemina, be taumi nam teneteneḡimi da uma giudima matabudi yodi ko ragaudi. ");
INSERT INTO dww_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Vutuna aubainama Riukaua Aruinama e yovona raḡanine, tauna tokare riukaua matabuna ei kataimina. Tauna nam tokare nuane e giu yababa, ibewa da aba ḡarogue e vaivaiena, vutuna e giuedina. Be mate yaba ḡesaudima muriḡa da ta tubuḡana, tauna ei maḡatara dokedina. ");
INSERT INTO dww_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tauna yaba matabudi ḡarogue e ragaudi be taumi ḡaromie ei maḡataridina. Inam kedane tauna isaguma e kawakawa saḡena. ");
INSERT INTO dww_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yaba matabudi Tamaguma ḡaronama, inam taugu ḡaroguma, vutuna aubainama taugu umanama è riuna, ‘Arua yaba matabudi ḡarogue e ragaudi be taumi ḡaromie ei maḡataridina’. ");
INSERT INTO dww_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Raḡan ḡaubonaḡa tokare nam ko kita munaḡegu. Be raḡan bisanama muridie taumi tokare ko kita munaḡeguna.” ");
INSERT INTO dww_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Be na tauwai muriwatanama ḡesaudima taudi adi banagama adi banagama mate ai giu be a riuna, “Uma giunama baninama aba, tauna ya riuna, ‘Raḡan ḡaubonaḡa tokare nam ko kita munaḡegu. Be raḡan bisanama muridie taumi tokare ko kita munaḡeguna’. Be mate ya riuna, ‘Taugu yà naḡonaḡona Tamaguma ḡarone’, inam giunama baninama aba?” ");
INSERT INTO dww_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Be riu ḡesau ya riuna, ‘Raḡan ḡaubonaḡa’ inam giunama baninama aba? Tauna na giuma aba ya giugiuedina tauda nam te kataiedina.” ");
INSERT INTO dww_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu ya kataie da taudi a ḡoeḡoena uma giudima aubaidima tauna sibo ai taravirena. Vutuna aubainama tauna ya riuedina, “Taumi aba è giugiuemina, vutudi ko nuanua babaḡedi, bo? Taugu è riuna, ‘Raḡan ḡaubonaḡa tokare nam ko kita munaḡegu. Be raḡan bisanama muridie taumi tokare ko kita munaḡeguna’. ");
INSERT INTO dww_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yà riuriu kauemina da taumi tokare koi nuaboya be ko ḡabana. Inam raḡanine dobu banegidima tokare tai nuaverena. Taumi tokare koi nuaboya guratana, be murine koi nuavere kauana. ");
INSERT INTO dww_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Inam kauinama maika waivi gomana e suru be e tepatepana nama. Be gomana e tubuḡana raḡanine nuaboya e kovina, inam raḡanine waivi nuanama e verena, baninama banaga vaunama dobue ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Inam kauinama teneḡinama nama taumi ḡaromie. Yodi ami nuaboyama raḡaninama ya tavana, be tokare ko kita munaḡeguna raḡanine, taumi koi nuaverena. Be inam wainuaverenama nam aitau tenaḡa tokare ḡaromie e paḡo pore. ");
INSERT INTO dww_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Inam raḡanine taumi tokare nam koi baḡagu, ibewa. Taugu aba yà riuemina inam, taugu isague Tamaguma koi baḡa be tauna ami ḡoanama e utemina. ");
INSERT INTO dww_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Noḡone be ya saḡa da yodi nam airaḡan isague aiyaba koi baḡa rubuna. Be yodi yà riuriuemina da koi baḡa be taumi ami ḡoanama e utemina, inam raḡanine taumi tokare nuemima e vere vavasaḡana. ");
INSERT INTO dww_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Taugu inam yabedima matabudi wainasie è giugiuemina. Be raḡan e veraverauna e tavana, inam raḡanine taugu tokare nam wainasie yà giuemi, ibewa da taugu giu didimanidie Tamaguma na kauama ḡaromie yà giuedina. ");
INSERT INTO dww_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Inam raḡanine taugu nam taumi aubaimima Tamaguma yài baḡa. Ibewa da taumiḡa aubaimima Tamaguma koi baḡana taugu isague, ");
INSERT INTO dww_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","baninama taumi kowai nuapaḡoegu be kowai sumaḡeguna da taugu Mamaitua ḡarone be è yovona. Vutuna aubainama Tamaguma nuanama ko paḡopaḡona. ");
INSERT INTO dww_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Taugu Tamaguma ḡarone be è yovona dobue, be yodi taugu dobu yà gose pore be yà munamunaḡana Tamaguma ḡarone.” ");
INSERT INTO dww_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dabudine Yesu na tauwai muriwatanama tauna a riuena, “Yodi tam nam wainasie kuma giugiuna, ibewa da giu didimanidie kwa giugiu yaḡana. ");
INSERT INTO dww_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yodi tauma kè kita be kè kataie da tam banaga adi noḡotama matabudi kuya kataiedina, be nam aitau tokare kwai taravire be na noḡotama tam e riuem. Uma kauinama aubainama tauma kawai sumaḡemna da tam Mamaitua ḡarone be kuya yovona.” ");
INSERT INTO dww_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Be Yesu ya riuedina, “Yodi koyai sumaḡa! ");
INSERT INTO dww_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Be raḡan e veraverauna kaiteka ya tavana, taumi matabumi tokare ko gosegu be naira koi naḡo teḡateḡana, be Tamaguma tauna yaḡoro taugu mate. ");
INSERT INTO dww_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Uma kauidima matabudi è riuwai nonoḡimina, taumi taugu nopogue ko miana, inam raḡanine suba taumi nopomie e kenana. Uma dobune taumi tokare piripiri ko banavidina, be nam koi nuaboya! Baninama taugu dobu rewapanidima matabuna è vaisubedina.” ");
INSERT INTO dww_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Dabudine Yesu na giuma yawai kovina murine, tauna mara ya kitasaḡe be umanama ya moiragina, “Mamai, raḡan ya tavana yodi natumma neneḡarinama kwai maḡatarina. Inam kedane natumma tam neneḡarimma ei maḡatarina. ");
INSERT INTO dww_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Baninama tam natumma rewapana kuya utena da tauna banaga matabudi ei badedina. Be banaga aitauḡa tam natumma nimane kuya biribiridina, tauna yawasana kenakena nonoḡinama taudi e utedina. ");
INSERT INTO dww_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Be yawasana kenakena nonoḡinama kedanama inam umanama: Banaga sibo a kataiem da riukaua Mamaituanama inam vutuna tam. Be mate sibo a kataie da Yesu Keriso tam kuya riuporena, yodibe taudi sibo ai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Taugu noya matabuna tam kuya uteuteguna dobue è voia rovodina, inam kedane am rewapanama èi maḡatarina. ");
INSERT INTO dww_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mamai, yodi taugu noḡome kwa voiegu da neneḡara dosinama nopone yà saḡa be yà miana, maika boni tè miamiana nama, muriḡa da dobu ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Tam uma banegidima dobue a miamiana, be yodi nimague kuya biridina. Be taudi ḡarodie taugu tam èi maḡatarimna. Taudi noḡone tam ḡaromma, be yodi kuya uteguna, taudi am giuma a paḡo be a kaidididina. ");
INSERT INTO dww_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Be yodi taudi a kataiena da yaba matabudi kuya uteuteguna, inam tam ḡarome be ta yovoyovona. ");
INSERT INTO dww_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Am giuma taugu è riuedina, be giunama taudi a paḡona. Be taudi a katai kauena da taugu tam ḡarome be è yovona. Be mate taudi ai sumaḡana da tam taugu kuya riuporeguna. ");
INSERT INTO dww_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Taugu nam dobu banegidima aubaidima amawai baḡamna, ibewa da taudi aitauḡa kuya uteuteguna aubaidima yà moimoiragi be yàwai baḡamna, baninama taudi tam ḡaroḡaromma aubainama. ");
INSERT INTO dww_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yaba matabudi taugu ḡarogue inam tam ḡaroḡaromma, be yaba matabudi tam ḡarome inam taugu ḡaroḡaroguma. Be taudie taugu neneḡariguma e maḡatarana. ");
INSERT INTO dww_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Taugu taudi uma dobune yà gosegosedina, baninama taugu yà saḡasaḡana ḡarome. Mamai Babaumma, yàwai baḡamna da taudi aitauḡa kuya uteuteguna taudi isamma na rewapanae kwa rabe kauedina. Be kwa voiedi da taudi tenaḡa ta tubuḡana, maika tam be taugu tauda tenaḡa. ");
INSERT INTO dww_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Be taugu taudi mate kè miamiana raḡanine, inam isanama teneḡine taugu è rabe kauedina. Be nam aitau tenaḡa e kawa gewagewana. Be tenaḡa vinevinenama aubainama tauna wari keda ya watanina, da aba awai perovetaena ruvane ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Yodi taugu yà saḡasaḡana ḡarome. Be taugu taudi mate kè miamiana raḡanine, yaba toitoi taudi è giuedina da nuavere nopogue kenakenanama, taudi nopodima e moḡavuna. ");
INSERT INTO dww_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Taugu riumma taudi è utedina. Vutuna aubainama dobu banegidima taudi a tuaḡaiedina, baninama taudi maika taugu, tauma nam dobu ḡarona. ");
INSERT INTO dww_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Taugu nam yodi amawai baḡamna da taudi dobue be kwa nawedi ḡavoe, ibewa da yàwai baḡamna da gewagewa Tamanama na rewapanama nam taudi e kawa gewegewedi. ");
INSERT INTO dww_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taudi maika taugu, tauma nam dobu ḡarona. ");
INSERT INTO dww_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Am riukaue kwa voiedi da taudi banaga babaudima ta tubuḡana. Be inam riukauinama vutuna tam riumma. ");
INSERT INTO dww_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tam taugu kuya riuporeguna dobue, be nama taugu taudi yà riuriuporedina dobue. ");
INSERT INTO dww_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Taudi kadi taiye taugume ei uta munaḡeguna ḡarome, inam kedane taudi mate riukaua na rewapanae tokare banaga babaudima ta tubuḡana. Yesu tauwai muriwatana ḡesaudima mate aubaidima ya moiragina. ");
INSERT INTO dww_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Mamai, taugu nam uma taudiḡa aubaidima amawai baḡamna. Ibewa da taudi adi rauguguye aitauḡa da muriḡa tai sumaḡeguna mate aubaidima yàwai baḡamna ");
INSERT INTO dww_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","da taudi matabudi tenaḡa ta tubuḡana, maika tam be taugu tauda tenaḡa. Mamai, kwa voiedi da taudi nopode ta miana, maika tam taugu nopogue, be taugu tam nopome. Inam kedane dobu banegidima tokare ta kita be tai sumaḡa da tam taugu kuya riuporeguna ḡarodie. ");
INSERT INTO dww_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tam neneḡara taugu kuya uteuteguna, vutuna taudi è utedina da taudi tenaḡa ta tubuḡana maika tauda tenaḡa, ");
INSERT INTO dww_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","taugu taudi nopodie be tam taugu nopogue. Be taudi tenaḡa ta tubuḡana raḡanine, dobu banegidima tokare ta kataie da tam taugu kuya riuporeguna. Be mate ta kataie da tam nema taugu kwawai nuapaḡo bakeguna, nama taudi aitauḡa kuya uteuteguna, kwawai nuapaḡoedina. ");
INSERT INTO dww_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mamai, muriḡa da dobu ya tubuḡana tam nuamma è paḡona aubainama neneḡara dosinama kuya uteguna. Be taugu yà ḡoeḡoena da taudi aitauḡa taugu kuya uteuteguna, taudi taugu mate ka mia tenaḡa, be yau neneḡarama ta kitana. ");
INSERT INTO dww_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Mamai, tam didimana Mamaituamma, be dobu banegidima nam ti kataiemna. Taugu tam è kataiemna be uma tauwai muriwatanidima taudi a kataiena da tam kuya riuporeguna. ");
INSERT INTO dww_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Taudi ḡarodie taugu tam yàwai maḡatarimna. Nama yà voivoiana, baninama tam kwawai nuapaḡo gurateguna, be taugu yà ḡoeḡoena inam wainuapaḡonama taudi nopodie e kena, be taugu taudi nopodie yà miana.” ");
INSERT INTO dww_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu ya moimoiragina murine, tauna na tauwai muriwatanama mate upa Kidron a davu be a naḡona noaḡo nevane sipi nopone. ");
INSERT INTO dww_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Be Judas tauborudobiḡa, tauna inam gabunama ya kataiena, baninama Yesu raḡan toitoi na tauwai muriwatanama mate inam dabudine a naḡonaḡona. ");
INSERT INTO dww_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Naumeki da pirisi be Parisi taudi Yesu vunuḡinama aubainama banaga iḡeiḡeridima be tempol taubodamenama Judas a utena da tauna ei doka nawedina Yesu ḡarone, vunuḡinama aubainama. Be inam banegidima adi kodam be adi madama a ragaudina, yodibe Judas yai dokedi be inam sipine a tavana. ");
INSERT INTO dww_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu ya kitedi be ya kataiena da yodi aba ḡarone e tubuḡana, naumeki da tauna ya naḡo ḡarodie be yai taraviredina, “Aitau ko wanewane?” ");
INSERT INTO dww_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Be taudi a paribee be a riuna, “Tauma Nasaret Yesunama ka wanewanena.” Be Yesu ya riuna, “Tauna vutuna taugu.” Be Judas tauborudobiḡa, tauna mate tauiḡara nopodie ya midimidina. ");
INSERT INTO dww_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Be raḡanine taudi ta vaiena be Yesu ya riuna, “Tauna vutuna taugu”, inam raḡanine tauiḡara a beku be tauridie a ravusedina. ");
INSERT INTO dww_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Dabudine Yesu yai taravira munaḡedina, “Aitau ko wanewane?” Taudi a paribea munaḡe be a riuna, “Tauma Nasaret Yesunama ka wanewanena.” ");
INSERT INTO dww_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Be Yesu ya riuna, “Kaite è riuemina da tauna vutuna taugu. Be deḡoda taumi taugu koma wanewanegu, naumeki da yau tauwai muriwatanama nam nema ko bakedi.” ");
INSERT INTO dww_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tauna nama ya riuna, baninama aba noḡone ya riuriuena, nama ya tubuḡana. Noḡone Yesu umanama ya riuna, “Nam aitau tenaḡa kuya uteuteguna taugu e kawa gewagewana.” ");
INSERT INTO dww_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dabudine Saemon Pita kwatikwati ya soru pore, be pirisi adi badama na taunoyama tenaḡa isanama Marukas beanama kasaunama yai miarakana. ");
INSERT INTO dww_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Be Yesu Pita ya riuena, “Kwatikwati kwa boru pore! Tam kuya kataie bo ibewa da taugu yodi Tamaguma na ḡoanama aubainama naumeki da ḡoraḡoranama yà siguena.” ");
INSERT INTO dww_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Naumeki da tauiḡara adi babadama mate be tempol taubodamenama taudi Yesu a pani be ");
INSERT INTO dww_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","noḡone a nawe dokena Kaiyapas botianama Anas ḡarone. Inam modinama nopone Kaiyapas tauna pirisi adi badama. ");
INSERT INTO dww_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyapas tauna vutuna boni Jius babadidima ḡesaudima umanama ya riuedina, “Ya verena da inam baneginama tenaḡa sibo ya gurina, be tauda matabuda sibo tè yawasanana.” ");
INSERT INTO dww_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saemon Pita be tauwai muriwatana ḡesaunama mate taudi Yesu awai muriwatanena. Be pirisi adi badama inam tauwai muriwataninama ya kataiena, aubainama tauna Yesu mate a saḡana pirisi na vadae. ");
INSERT INTO dww_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Be Pita tauna doḡae matakeda diane ya mia kwasana. Dabudine tauwai muriwatana vadae saḡasaḡa dokanama ya dobi munaḡa, be waivi matakeda taurabenama ya riue be Pita vada nopone ya saḡana. ");
INSERT INTO dww_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Inam raḡanine waivi matakeda taurabenama tauna Pita yai taravire be ya riuna, “Tam mate agunai Yesu na tauwai muriwatanama.” Be Pita ya riuena, “Ibewa, nam taugu!” ");
INSERT INTO dww_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Dobu ya tururuna aubainama, taunoya kai a suve be taudi tempol taubodamenama mate kai a midi kwaviviro be a marimaririna. Be Pita tauna mate dabudi ya midi be kai ya marimaririna. ");
INSERT INTO dww_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Taudi kai a marimaririna maika, pirisi adi badama Yesu ya etare be ya riuena, “Am tauwai muriwatanama aitauḡa? Be aiyabaḡa banaga kwawai katakataidi?” ");
INSERT INTO dww_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Be Yesu tauna ya paribee be ya riuna, “Taugu yaba matabudi patara matedie è giugiuedina. Taugu sinagog be tempol nopodie deḡo banaga awai rawateḡeidie dabudine èwai katakataina. Be nam airaḡan moisirie aba e giuedina. ");
INSERT INTO dww_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yodi aba aubainama kwawai taraviregu? Banaga ḡesaudima aitauḡa awai beavaieguna, taudi kwai taraviredi be ta riuemna.” ");
INSERT INTO dww_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dabudine tempol taubodamenama tenaḡa Yesu ya raunevakau be ya riuena, “Tam aitau ya riuem da pirisi adi badama ḡarone nama kwa riuriu?” ");
INSERT INTO dww_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Be Yesu ya paribee be ya riuna, “Deḡoda taugu aiyaba è vato waigewana, naumeki da kwa riu, taugu aiyaba gewagewanama è vato. Be deḡoda ibewa, aba aubainama kuya raunevakaugu?” ");
INSERT INTO dww_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dabudine Anas Yesu ma panipanina ya riupore nawena pirisi adi badama Kaiyapas ḡarone. ");
INSERT INTO dww_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saemon Pita kai ya marimaririna maika banaga ḡesaudima ai taravire be a riuena, “Tam mate agunai Yesu na tauwai muriwatanama.” Be Pita ya bovi munaḡa be ya riuena, “Ibewa, nam taugu!” ");
INSERT INTO dww_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dabudine pirisi adi badama na taunoyama ḡesaunama, tauḡoma beanama waimia rakanama tauna na damma baneginama. Inam taunoyanama tauna Pita ya riuena, “Taugu sipie tam mate è kitemna.” ");
INSERT INTO dww_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dabudine Pita ya bovibovi munaḡana murine, kamkam ya riuna. ");
INSERT INTO dww_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Raḡanboiboi kupinaḡa Jius babadidima Yesu tauna Kaiyapas ḡarone, be ai doka nawena Rom gabemannama isanama Paelat ḡarone. Be Jius taudi nam ti ḡoena da tai mira munaḡedi. Vutuna aubainama taudi nam Paelat na vadae ti saḡana. Baninama deḡoda tai mira munaḡedina, taudi tokare Naḡopore soinama nam ta kani. ");
INSERT INTO dww_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Vutuna aubainama Paelat doḡae ya dobi be taudi yai taraviredina, “Tauna na gewagewama aba, be kowai wavu?” ");
INSERT INTO dww_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Be taudi Paelat a riuena, “Tauna banaga gewagewanama, vutuna aubainama kè verauḡena ḡarome.” ");
INSERT INTO dww_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Be Paelat taudi ya riuedina, “Koi doka nawe be ko etarena taumi ami tarawatuma na ruvae.” Be Jius babadidima tauna a paribee be a riuena, “Tauma tam am waibadama dibune ka miamiana, vutuna aubainama nam ama rewapanama ima kenakenana da banaga kai guri.” ");
INSERT INTO dww_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Uma giudima inam nema Yesu e guri bakona noḡone ya giugiuedina, ruvane nama a tubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Dabudine Paelat ya munaḡa na vadae, be na tauiḡarama ya riuedi da Yesu ai doka saḡena ḡarone. Yodibe Paelat Yesu yai taravirena, “Tam Jius adi guyau, bo?” ");
INSERT INTO dww_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Be Yesu ya riuena, “Tam am wainua noḡonoḡotama ruvane taugu kwawai taraviregu, bo banaga a giugiuna ruvane kwawai taraviregu?” ");
INSERT INTO dww_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Be Paelat ya paribee be ya riuna, “Taugu nam Jius banegigu, da banaga adi noḡotama ruvane sibo èi taravirem. Tam am banagama be pirisi adi babadama taudi a verauḡemna ḡarogue. Aba aubaina? Aba gewagewanama tam kuya voie?” ");
INSERT INTO dww_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Be Yesu ya riuena, “Taugu yau waiguyauma nam dobue ima kenakenana. Deḡoda dobue i kenana, yau taunoyama tokare murigue a midi be iḡara ai tubuḡina. Inam raḡanine Jius banegidima tokare nam sibo a vunuḡigu be a panigu. Vutuna aubainama taugu è riuemna da taugu yau waiguyauma nam dobue ima kenakenana.” ");
INSERT INTO dww_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dabudine Paelat ya riuna, “Tam naumeki riukaua guyau, bo?” Be Yesu ya riuena, “Inam riukaua, taugu guyau, inam vutuna aubainama è tubuḡana. Taugu è yovona dobue da riukaua yà giuena banaga ḡarodie, be aitauḡa riukaua ḡaroḡaronama taudi bonaguma ta vaivaiena.” ");
INSERT INTO dww_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dabudi Paelat yai taravire be ya riuna, “Riukaua inam aiyaba?” Paelat nama ya riuriuna, tauna ya dobi munaḡa doḡae be Jius babadidima ya riuedina, “Uma baneginama tauna nam aiyaba i voia waigewana da yà etare. ");
INSERT INTO dww_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Be taumi ami vaivaima e kenakenana da Naḡopore soinama raḡanine, dibura baneginama tenaḡa yà kaikaiporena. Taumi ko ḡoeḡoena Jius guyaunama yà kaipore, bo?” ");
INSERT INTO dww_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Be taudi matabudi bonedima dosine a yogo munaḡa be a riuna, “Nam tauna! Tauma ka ḡoeḡoena Barabas kwa kaiporena.” Be Barabas tauna iḡara tauwai karenama. ");
INSERT INTO dww_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Dabudine Paelat na tauiḡarama ya riuedi, da Yesu kwapue ai madarouna. ");
INSERT INTO dww_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Be taudi gedara a pinou da Yesu debane ai mieni be a virididina. Taudi gara gatugatunama Yesu ai kote, ");
INSERT INTO dww_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","yodibe taudi ḡarone a saḡa da ai varavara be a riuriuna, “Ebom, Jius adi guyauma.” Be taudi nimedie noḡonama a riḡana. ");
INSERT INTO dww_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Dabudine Paelat ya dobi munaḡa be Jius banegidima ya riuedina, “Taugu uma baneginama yà yovoyovoḡa munaḡena ḡaromie, be yà riuriuemina da taugu nam aiyaba gewagewanama ḡarone e banavina.” ");
INSERT INTO dww_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Naumeki da Yesu vadae be ya dobina. Tauna gara gatugatunama waikotenama be debane gedara boruborunama. Be Paelat ya riuna, “Inam baneginama umanema.” ");
INSERT INTO dww_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dabudine pirisi adi babadama be tempol taubodamenama Yesu a kitakitana raḡanine, taudi bonedima dosine a yogo be a riuna, “Kwa tuparatu! Kwa tuparatu!” Be Paelat ya riuedina, “Taumi ko tuparatu, taugu nam aiyaba gewagewanama tauna ḡarone e banavina.” ");
INSERT INTO dww_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Be Jius babadidima a riuna, “Tauma ama tarawatuma e riuriuna da tauna e gurina, baninama tauna e riuriu munaḡena da tauna kabe Mamaitua Natuna.” ");
INSERT INTO dww_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Be Paelat inam giunama nama ya vaivaiena, tauna ya naira kaua ");
INSERT INTO dww_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","be ya munaḡana vadae. Dabudine tauna Yesu yai taravire be ya riuna, “Tam aikedae be kuya tava?” Be Yesu nam Paelat i paribeena. ");
INSERT INTO dww_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dabudine Paelat ya riuna, “Tam nam ḡarogue giu kuma ḡoeḡoe, bo? Taugu ḡarogue rewapana e kenakenana da tam yà riuporem kwa naḡo bo yà tuparatumna, inam vutuna kuya kataie bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dabudine Yesu ya paribee be ya riuna, “Mamaitua inam rewapaninama ya utemna, vutuna aubainama naumeki da taugu am waibadama dibune yà miamiana. Deḡoda ibewa, taugu tokare nam am waibadama dibune e mia. Be aitau da taugu nimame ya boruguna, tauna na gewagewama ya moraba vavasaḡana.” ");
INSERT INTO dww_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Inam dabudine be nokoi ya naḡona Paelat ya rarau rubu guratana da Yesu sibo ya raukaigose be ya naḡona. Be Jius babadidima bonedima dosine a riuna, “Deḡoda tam inam baneginama kwa kaipore be e naḡona, naumeki da tam nam Sisa turana, baninama banaga aitau e riuna, ‘Taugu guyau’, inam baneginama tauna Sisa na ḡaviama.” ");
INSERT INTO dww_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paelat inam nama giunama ya vaivaiena, tauna Yesu yai doka dobiḡa munaḡena. Yodibe anikaba etara gabunama tawai isana ‘Gasana’, be gasana debane anikaba mia ya midimidina. Dabudine Paelat ya mia be etara yai karena. Hibru bonane inam gabunama tawai isana ‘Gabata’. ");
INSERT INTO dww_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Uma kauidima matabudi suaratopu a tubuḡana, Naḡopore soinama na vokaukauama raḡanine. Be Paelat banaga ya riuedina, “Ami guyauma umanema.” ");
INSERT INTO dww_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dabudine taudi a yogo be a riuna, “Kwa nawe ḡavoe! Kwa tuparatuna.” Be Paelat ya riuna, “Uma inam taumi ami guyauma, be yà tuparatu, bo?” Be pirisi adi babadama a riuna, “Tauma nam aba guyaunama ḡaromaie ima miamiana. Sisa taunaḡa tauma ama guyauma.” ");
INSERT INTO dww_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Naumeki da Jius adi ḡoanama aubainama Paelat tauna Yesu tauiḡara nimedie ya boruna tuparatunama aubainama. Naumeki da tauiḡara Yesu a nawena. ");
INSERT INTO dww_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu tauname na korosima ya kiroḡi be a naḡona gabu Hibru bonane tawai isana ‘Golgota’. Riu ‘Golgota’ inam baninama ‘debagarere’. ");
INSERT INTO dww_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Inam dabudine taudi Yesu a tuparatuna. Be Yesu diane banaga rabui mate a tuparatudina. Tenaḡa Yesu kasaunama yauwanine, be tenaḡa seninama yauwanine. ");
INSERT INTO dww_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Be Paelat kai ḡaubonama bogane ya giruma be Yesu debane, korosi bogane ya tutuna. Tauna inam kainama bogane umanama ya girumina: ");
INSERT INTO dww_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Inam giunama tauna Hibru bonane, Letin bonane, be Gurik bonane ya girumidina. Taudi Yesu Jerusalem meagainama diane a tuparatuna, vutuna aubainama Jius banegidima toitoi inam girumidima a siesievidina. ");
INSERT INTO dww_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Be pirisi adi babadama inam giruminama a riutuaḡaie be Paelat a riuena, “Nam nama kwa giruma, umanama kwa girumana: ‘Inam baneginama ya riuna da tauna kabe Jius adi guyauma.’” ");
INSERT INTO dww_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Be Paelat ya riuna, “Aba è girumina, inam è girumina.” ");
INSERT INTO dww_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Naumeki da tauiḡara matabudi 4 Yesu a tupatuparatuna murine, taudi Yesu na garama a ragaudi da a soiedi be taudi matabudi inam garedima a ragaudina. Be gara tenaḡa dibune ya kotekotena ya vere kauana, be inam garanama a rautenaḡe da a voiena be nam popopona, ");
INSERT INTO dww_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","vutuna aubainama taudi a riuna, “Uma garanama nam tà sika. Tauda tài kasie be aitau kasie ei rewapanana, tauna inam garanama e paḡona. Inam kauine girugiruminama porane aba awai perovetaena nama yodi a tubuḡana.” Girugiruminama porane umanama ya riuna, “Taudi yau garama a soiedina be ḡesau ai kasiena.” Inam kauinama yodi tauiḡara ai tubuḡina. ");
INSERT INTO dww_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Be korosi diane waiwaivi matabudi 4 a midimidina. Tenaḡa inam Yesu tinanama, be ḡesau inam Yesu tinanama tasinama, be Meri Klopas na visarama, yodibe Meri Megdalin. ");
INSERT INTO dww_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Dabudi Yesu e kitana be tinanama be tura kaukauinama tauna diane a midimidina. Naumeki be tinanama ya riuena, “Waivi, inam tauna yodi tam natumma.” ");
INSERT INTO dww_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Be turanama ḡarone ya riuena, “Inam tauna yodi tam tinamma.” Dabudine inam tauwai muriwataninama tauna na vadae Meri yai doka nawe be dabudine ya rabena. ");
INSERT INTO dww_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Uma kauidima murine Yesu ya kataie da na noyama yodi ya kovina. Be girugiruminama porane aba awai perovetaena, nama e tubuḡana. Dabudine Yesu ya riuna, “Nuaguma ya raukasakasana.” ");
INSERT INTO dww_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Inam dabudine waen ḡoraḡoranama duginama ya midimidina. Be banaga anitaiyo kai isune a pani be waen ḡoraḡoranama nopone ai sonom be Yesu mudune a boruna. ");
INSERT INTO dww_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Be Yesu inam waennama ḡoraḡoranama ya tegotegona raḡanine, tauna ya riuna, “Yodi matabuna ya kovina.” Dabudine iwanama ya taukotovi be aruinama Tamanama nimane ya boru be ya gurina. ");
INSERT INTO dww_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Inam kauidima Naḡopore soinama vokaukauinama raḡaninama nopone a tubuḡana. Be pomainama inam Sabat raḡaninama dosinama. Jius babadidima taudi nam ti ḡoeḡoena da Sabat nopone banaga tubuḡidima korosie sibo a kena. Vutuna aubainama taudi Paelat ai baḡana da inam banegidima korosie kaḡedima sibo ai miakotovidi be tubuḡidima a kaiporaḡana. ");
INSERT INTO dww_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Naumeki da tauiḡara inam banegidima aitauḡa Yesu mate a tupatuparatudina, kaḡedima ai mia kotovidina. ");
INSERT INTO dww_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Be taudi Yesu ta kitana be tauna ya gurina, vutuna aubainama tauna kaḡanama nam ti mia kotovidina. ");
INSERT INTO dww_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Be tauiḡara tenaḡa keae Yesu girigirinama ya tiretiremina, yai raḡantenaḡe da kosina upa mate a dobina. ");
INSERT INTO dww_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tauna aitau uma kauidima ya kitedi be ya giuedina, inam matabudi riukaua. Inam baneginama ya kataiena da aba e giugiuedina, matabudi inam riukaua, vutuna aubainama tauna ḡaromie ewai matematena da taumi mate koi sumaḡana. ");
INSERT INTO dww_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Uma kauidima a tubuḡana da girugiruminama porane aba awai perovetaena nama a tubuḡana. Girugiruminama poranama umanama ya riuna: “Nam turiḡinama tenaḡa maika tokare e nuakotova.” ");
INSERT INTO dww_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Be girugiruminama ḡesaune umanama ya riuna, “Taudi tokare inam baneginama a tiretiremina ta raubigena.” ");
INSERT INTO dww_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Inam kauidima muridie Jousep Arimatia tauḡominama, tauna Paelat yai baḡana Yesu tubuḡinama paḡonama aubainama. Jousep tauna Yesu na tauwai muriwatanama. Tauna Jius babadidima ya nairedina aubainama, tauna moisirie Yesu yawai sumaḡena. Be Paelat Jousep yai anine da tauna Yesu tubuḡinama ya kaipore be ya nawena. ");
INSERT INTO dww_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Be Nikodimas tauna ya sagu be mate a naḡona. Nikodimas tauna vutuna dokane kupie Yesu ḡarone ya tavana. Be tauna bunama toitoi ya verauḡedina Yesu tuninama viredima aubainama. ");
INSERT INTO dww_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Taudi adi waikokoagama vaivainama ruvane Yesu garae bunama mate a sumana. ");
INSERT INTO dww_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Be Yesu deḡo a tupatuparatuna gabunama diane, dabudi sipi. Be inam sipine kokoaga gabunama vaunama, be inam kokoagine nam aitau ti kokoaga rubuna. ");
INSERT INTO dww_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Be Naḡopore soinama raḡaninama kaiteka maida ya tavatavana, aubainama taudi Yesu inam kokoagine ai kokoagina, baninama inam kokoaginama maida aubainama. ");
INSERT INTO dww_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Be Sande raḡanboiboi kupinaḡa Meri Megdalin ya naḡona kokoagae. Be dabudine tauna e kitana be yeku matakeda waimiditomnama ai rawakui be ḡavoe ya naḡona. ");
INSERT INTO dww_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dabudine tauna ya manini da ya munaḡa be Saemon Pita be Yesu tura kaukauinama ya banavidi be ya riuedina, “Banaga Bada tubuḡinama kokoagae a kaipore be aikedae a boruna taugu nam e kataiena.” ");
INSERT INTO dww_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dabudine Pita be tauwai muriwatana ḡesaunama mate a manini a naḡona kokoagae. ");
INSERT INTO dww_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Taudi a manimanini be Pita turanama tauna ya manini raukosoḡaiḡai da kokoagae ya tava dokana. ");
INSERT INTO dww_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tauna ya rauduru be kokoaga nopone yai kita saḡa be gara ya kitedina a kenakenana. Be nam kokoaga nopone i naḡona. ");
INSERT INTO dww_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Be tauna murine Saemon Pita ya manimaninina ya tava da kokoaga nopone ya naḡona. Dabudine tauna gara ya kitedina a kenakenana ");
INSERT INTO dww_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","be gara ḡesau Yesu debanama a sumasumana, inam garanama nokunoku yaḡenama, taunaḡa ḡavoe ya kenakenana ya kitana. ");
INSERT INTO dww_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dabudine Pita turanama kokoagae tavatava dokanama, tauna mate kokoaga nopone ya saḡa da gara nama ya kitedi be yai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Be girugiruminama porane ya riuna da Tauwai yawasana tokare e guri be e midisuḡu munaḡana. Be taudi inam riunama yaḡoro nam ti kataiena. ");
INSERT INTO dww_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dabudine tauwai muriwatana rabui taudi a munaḡana adi vadae, ");
INSERT INTO dww_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","be Meri tauna kokoaga diane ya midi be ya ḡabaḡabana. Be tauna ma ḡabaḡabana kokoaga nopone ei kita saḡana, ");
INSERT INTO dww_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","be anea rabui ya kitedina, adi garama a ḡavoḡavorana. Taudi deḡo Yesu ya kenakenae, dabudine a miamiana, tenaḡa Yesu kaḡanama yauwanine be tenaḡa debanama yauwanine. ");
INSERT INTO dww_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dabudine anea Meri ai taravire be a riuena, “Aba kwa ḡabeḡabe?” Be Meri ya riuedina, “Bada tubuḡinama kokoagae be banaga a nawe da deḡo a boruna, taugu nam e kataiena.” ");
INSERT INTO dww_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Inam nama ya giugiuna murine tauna yai tautinamuri da murine Yesu ya midimidina ya kitana. Tauna ya kitana, be yaḡoro nam i kataiena da inam tauna Yesu. ");
INSERT INTO dww_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Be Yesu ya riuena, “Tam aba kwa ḡabeḡabe? Aitau kwa wanewane?” Be Meri yai noḡotana kabe sipi taurabena, vutuna aubainama tauna ya riuena, “Tura, tam deḡoda Bada tubuḡinama kuma kirokiroḡa nawe, naumeki da kwa riuegu deḡo kuya boru da taugu yà naḡo be yà verauḡena.” ");
INSERT INTO dww_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Be Yesu ya riuena, “Meri!” Dabudine Meri ya midi vitare Yesu ḡarone be ya riuna, “Tauwai katakatai!” ");
INSERT INTO dww_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Be Yesu tauna ya riuena, “Nam kwa taukonigu! Baninama taugu yaḡoro nam Tamaguma ḡarone e naḡona. Be yodi tam kwa naḡo tasitasiguma ḡarodie be kwa riuedina, ‘Taugu yà munamunaḡana Tamaguma ḡarone, be taumi mate Tamemima. Tauna yau Mamaituama, be taumi mate ami Mamaituama.’” ");
INSERT INTO dww_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Naumeki da Meri Megdalin vari ya munaḡena tauwai muriwatana ḡarodie be ya riuna, “Taugu Bada è kitana!” Be Bada aba tauna ya riuriuena, vutudi taudi yai varidina. ");
INSERT INTO dww_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Inam raḡaninama teneḡine Sande ravikupikupie tauwai muriwatana taudi Jius babadidima a nairedina aubainama, taudi adi matakedama a babaḡavi be vada nopone a miamiana. Be yai raḡantenaḡe da taudi poudie Yesu ya midi maḡatara be ya riuna, “Suba ḡaromie e kena!” ");
INSERT INTO dww_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tauna nama ya riuriuna murine, tauna nimanama be girigirinama tauwai muriwatana yai kataidina. Dabudine taudi a kita be nuedima ya vere kauana. ");
INSERT INTO dww_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dabudine Yesu ya riu munaḡana, “Suba ḡaromie e kena! Tamaguma ya riuriuporeguna nama, taumi yà riuriuporemina.” ");
INSERT INTO dww_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Dabudine Yesu taudi debedie yavutu gayane ya suve pore be ya riuna, “Arua Babau ko paḡona! ");
INSERT INTO dww_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Taumi aitauḡa adi gewagewama ko noḡota poredina, naumeki da Mamaitua taudi adi gewagewama e noḡota poredina. Be deḡoda banaga adi gewagewama ko kaidididina, nama tokare Mamaitua taudi adi gewagewama e kaidididina.” ");
INSERT INTO dww_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesu tauwai muriwatana ḡarodie ya maḡatarana raḡanine, Tomas tauna nam dabudi mate. Tomas tauna tenaḡa tauwai muriwatana 12 nopodie, be tawai isana ‘Raḡaraḡa’. ");
INSERT INTO dww_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Vutuna aubainama tauwai muriwatana ḡesaudima Tomas a riuena, “Tauma Bada kè kitana.” Be Tomas taudi ya riuedina, “Taugu tokare nam yài sumaḡa. Noḡone taugu tutu kividima yà kitedi be nimague tutu gabudima yà taukonidi, be girigirinama a tiretiremina yà taukoni, yodibe yài sumaḡana.” ");
INSERT INTO dww_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wiki tenaḡa murine, tauwai muriwatana taudi a rawateḡei munaḡedi da matakeda a babaḡavi be vada nopone a miamiana, be Tomas mate dabudine. Be yai raḡantenaḡe da Yesu taudi poudie ya raumidire be ya riuna, “Suba ḡaromie e kena!” ");
INSERT INTO dww_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dabudine tauna Tomas ya riuena, “Nimatabaguma kwa kitedi be kwa taukonidi. Be girigiriguma kwa taukoni. Nam kwa noḡota bekubeku be kwai sumaḡana.” ");
INSERT INTO dww_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dabudine Tomas tauna ya riuena, “Tam yau Badama be yau Mamaituama!” ");
INSERT INTO dww_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Inam raḡanine Yesu Tomas ya riuena, “Tam yodi kuya kitaguna, vutuna aubainama kuyai sumaḡana. Be nuavere taudi aitauḡa nam ti kitaguna be yaḡoro awai sumaḡana.” ");
INSERT INTO dww_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu boni mataira dosidima toitoi na tauwai muriwatanama matedie ya voiedina. Be mataira ḡesaudima nam buka nopone ti girumidina. ");
INSERT INTO dww_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Be mataira uma bukanama nopone a girumidi be ta kenakenana, taudi vutudi ko kitedi be koi sumaḡa da Yesu tauna vutuna Tauwai yawasana, Mamaitua Natunama. Be raḡanine tauna koi sumaḡena, taumi tokare tauna isane yawasana ko banavina. ");
INSERT INTO dww_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Raḡan bisanama muridie Galili yawawinama diane Yesu na tauwai muriwatanama ḡarodie ya maḡatara munaḡana. Inam kauinama umanama ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Raḡan tenaḡa Galili yawawinama geresine tauwai muriwatana ḡesaudima ai rawateḡeidina. Taudi inam Saemon Pita, Tomas (tawai isana Raḡaraḡa), Nataniel (tauna Galili nopone Keina meagainama baneginama), yodibe Sebedi natunatunama be tauwai muriwatana ḡesaudima rabui mate. ");
INSERT INTO dww_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Dabudine Saemon Pita na banagama ya riuedina, “Taugu yà naḡo yài sagidana.” Be na banagama a riuna, “Tauma mate tà naḡo tài sagidana.” Naumeki da taudi wagae a saḡa be a naḡona. Be inam kupine taudi ai sagida raḡanina, be nam aiyaba ti vunuḡa rubuna. ");
INSERT INTO dww_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Be raḡanboiboi kupinaḡa Yesu gerese ya raumidirena. Taudi a kitana be nam ti kataiena da tauna Yesu. ");
INSERT INTO dww_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Be tauna bonanama dosine taudi yai taraviredi be ya riuna, “Yau bana, iyana koya vunuḡa bo ibewa?” Be taudi a riuna, “Ibewa!” ");
INSERT INTO dww_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dabudine Yesu ya riuna, “Ami sagidama kasaumima yauwanine ko pore be dabudi tokare iyana ko konedina.” Naumeki da taudi Yesu aba ya riuriuedina, nama a voiana. Inam raḡanine, taudi iyana toitoi a konedina, vutuna aubainama taudi nam teneteneḡina da sagida sibo wagae a soru tavaite. ");
INSERT INTO dww_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Inam raḡanine Yesu tura kaukauinama, tauna Pita ya riuena, “Inam Bada!” Be Saemon Pita raḡanine nama giunama ya vaivaiena, tauna na garama ya kotedi da topae ya poti dobi be ya yaka naḡona barabarae. ");
INSERT INTO dww_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Be tauwai muriwatana ḡesaudima taudi wagae a munaḡana gerese. Be geresa inam maida aubainama taudi sagida a soru ḡome be a naḡona. ");
INSERT INTO dww_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Be taudi gerese a ḡotaḡotana raḡanine, taudi kai ya karakaratina a kitana. Be kaipou debane iyana be buredi a gabudi be a kenakenana a kitedina. ");
INSERT INTO dww_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dabudine Yesu ya riuedina, “Iyana koya vunuvunuḡidina ḡesaudima ko verauḡedi.” ");
INSERT INTO dww_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Naumeki da Saemon Pita wagae ya poti tava da sagida ya paḡo be ya soru nawena barabarae. Sagida nopone iyana dosidima sievidima 153, be yaḡoro sagida nam i nuagigina. ");
INSERT INTO dww_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Dabudine Yesu ya riuedina, “Ko verau be ko kani.” Be nam aba tauwai muriwataninama Yesu i taravira rubu be i riuna, “Tam aitau.” Baninama taudi matabudi a kataiena da tauna Bada. ");
INSERT INTO dww_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Naumeki da Yesu buredi be iyana ya ragaudi be taudi ya utedina. ");
INSERT INTO dww_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu ya guri be ya midisuḡu munaḡana murine, uma inam raḡan aniwai rabuiteḡanama na tauwai muriwatanama ḡarodie ya maḡatarana. ");
INSERT INTO dww_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Naumeki da a kanikani rovona murine, Yesu Saemon Pita ya riuena, “Saemon, Jon natunama, tam naumeki kwawai nuapaḡo gurategu, nam am banagama kwawai nuapaḡoedina maika, bo?” Dabudine Pita ya paribee be ya riuna, “Ee Bada, kuya kataiena da tam nuaguma kwa paḡopaḡona.” Dabudine Yesu ya riuena, “Yau sipuma natunatudima kwai kani bagibagidina.” ");
INSERT INTO dww_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Be Yesu raḡan aniwai rabuinama ya riu munaḡana, “Saemon, Jon natunama, tam naumeki kwawai nuapaḡo gurategu, bo?” Dabudine Pita ya paribee be ya riuna, “Ee Bada, kuya kataiena da tam nuaguma kwa paḡopaḡona.” Dabudine Yesu ya riuena, “Yau sipuma kwa rabedina.” ");
INSERT INTO dww_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Naumeki da Yesu raḡan aniwai rabuiteḡanama ya riu munaḡena, “Saemon, Jon natunama, tam naumeki kwawai nuapaḡoegu, bo?” Inam raḡanine Pita yai nuaboyana, baninama Yesu raḡan aniwai rabuiteḡanama ya riuna, ‘Tam naumeki kwawai nuapaḡoegu, bo?’. Dabudine Pita ya paribee be ya riuna, “Bada, tam yaba matabudi kuya kataiedina. Be kuya kataiena da tam nuaguma kwa paḡopaḡona.” Dabudine Yesu ya riuena, “Yau sipuma kwai kani bagibagidina. ");
INSERT INTO dww_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Yà riuriu kauemna da tam raḡanine vaume am tanama kuya paḡo be am ḡoane nama kuya naḡonaḡona. Be kwai rawadosina raḡanine, nimamma tokare banaga kwa utedi, da taudi nimame ta kaididi be adi ḡoane nama tai dokem be ko naḡona. Avedi da tam inam dobunama naḡonama nam kuma ḡoeḡoena, be yaḡoro tai dokem be ko naḡona.” ");
INSERT INTO dww_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu nama Pita ya riuena, baninama tauna tokare nema e guri bakona, vutuna ya giuena. Inam kedane Pita tokare Mamaitua isanama e kawa saḡena. Be Yesu nama ya giugiuna murine, tauna Pita ya riuena, “Kwai muriwatanegu!” ");
INSERT INTO dww_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Dabudine Pita yai tautinamuri da Yesu tura kaukauinama ya kitana, tauna muridiḡa ya veraverauna. Tauna vutuna noḡone Naḡopore soinama a kanikani be ya raukekera naḡo Yesu ḡarone be ya riuna, “Bada, aitau tokare e boru dobiḡem?” ");
INSERT INTO dww_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Be Pita Yesu tura kaukauinama ya kitakitana raḡanine, tauna Yesu ya riuena, “Bada uma tauna nemanama?” ");
INSERT INTO dww_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Be Yesu ya paribee be ya riuna, “Tam nam am noyama aba tauna ḡarone ima kenakenana. Deḡoda taugu è ḡoena, tauna tokare yawayawasaninama e miamia be yà verau munaḡana. Be tam taugu kwai muriwataneguna.” ");
INSERT INTO dww_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Inam riunama tauwai muriwatana a vaia waigewa be taudi tauwai sumaḡa ḡesaudima ḡarodie inam giunama ai daberari be a riuriuna, “Yesu tura kaukauinama tokare nam e guri.” Be inam nam nama. Yesu nam i riuna tura kaukauinama tokare nam e guri. Ibewa, be tauna umanama Pita ya riuena, “Tam nam am noyama aba tauna ḡarone ima kenakenana. Deḡoda taugu e ḡoena, tauna tokare yawayawasaninama e miamia be yà verau munaḡana.” ");
INSERT INTO dww_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Inam tauwai muriwataninama tauna vutuna inam yabedima matabudi ya kitedi be ya girumidina. Tauda matabuda tè kataiena da yaba matabudi tauna ya girugirumidina inam riukaua. ");
INSERT INTO dww_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu yaba ḡesaudima toitoi mate ya voiedina. Be deḡoda inam yabedima matabudi sibo ti giruma rovodina, taugu è noḡotina da buka tokare dobu matabuna ya moḡavu taritarina. ");
INSERT INTO dww_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kapore Tiopilas! Yau letama noḡone è girugirumina, inam matabuna Yesu aba pakane ya voivoiedina be yawai katakataina taudi vutuna è girumidina. ");
INSERT INTO dww_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yesu na noyama yai kare be yaba toitoi ya voiedina, naumeki da Mamaitua ya nawena marae. Vutudi matabudi è girumidina. Muriḡa da ya naḡona marae, be noḡone na apasolma vinevinedima Arua Babaue ya riuwai noḡotidina da muriḡa aba ta voiena. ");
INSERT INTO dww_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu ya gurina murine inam apasoldima ḡarodie ya maḡatarana raḡan toitoi da taudi ta kataie da tauna ya yawasanana. Raḡan 40 nopone namaḡa ya voivoiana be Mamaitua na waiguyauma ḡarodie ya giugiuena. ");
INSERT INTO dww_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Be raḡan tenaḡa tauna na apasolma mate a rawateḡeidi be ya riu vavasaḡedina, “Nam Jerusalem ko gose be koi raba da Tamaguma puyo e riupore yovoḡena maika noḡone ya riuriuna nama e voiena. Taugu uma yabanama noḡone è riuemina. ");
INSERT INTO dww_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon banaga upae yai babataitodina, be raḡan ḡaubonaḡa taumi Arua Babaue ko babataitona.” ");
INSERT INTO dww_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Adi wairawateḡeie taudi Yesu ai taravirena, “Bada, tam yodi Israel waiguyau kwa ute munaḡedi, bo?” ");
INSERT INTO dww_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Be tauna ya riuedina, “Tamaguma na rewapanae tauna inam raḡaninama ya vinena, be taumi nam ami noyama aba ima kenakenana da ko kataie. ");
INSERT INTO dww_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Be Arua Babau ḡaromie e yovona raḡanine, taumi tokare rewapana ko paḡo da taumi taugu yau matamatama, Jerusalem, Judia be Samaria nopodie, be dobu matabuna.” ");
INSERT INTO dww_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Raḡanine umanama ya riuriuna, matedie Mamaitua tauna Yesu ya kaisuḡu nawe be giyou ya suma be nam ti kita munaḡena. ");
INSERT INTO dww_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Be tauna nema ya saḡa ya naḡo bakona, taudi yaḡoro gunuma a kitakita be, tautauḡoma rabui adi garama ḡavoḡavoridima, ai raḡantenaḡe diedie a raumidiredi ");
INSERT INTO dww_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","be a riuna, “Taumi mani-Galili aba aubainama uma dabudi ko midi be gunuma ko kitakita? Uma Yesunama yodi Mamaitua ḡaromie ya paḡo nawena marae, tauna nema koya kita be ya saḡa ya naḡonaḡona marae, nama tokare e yovo munaḡana.” ");
INSERT INTO dww_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Dabudine taudi oya isanama Olip, a gose be a munaḡana Jerusalemma. Uma oyanama Jerusalem diane, na madanima kilomita tenaḡa. ");
INSERT INTO dww_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Be raḡanine taudi a munamunaḡana, taudi vada tenaḡa be nopone vatavatara rabui be debane vatarine a saḡana. Dabudine adi kaba mianama. Be banaga dabudine taudi Pita, Jon, Jeims, Andru, Pilip, Tomas, Batolomiu, Metiu be Jeims tauna Alpius natunama, be Saemon tauna awai isana ‘Selot’ be Judas tauna Jeims natunama. ");
INSERT INTO dww_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Uma banegidima raḡan matabuna a mia be a moimoiragina. Nopodie waiwaivi ḡesaudima mate, be Meri Yesu tinanama, be Yesu tasitastinama mate. ");
INSERT INTO dww_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Be inam raḡandie dabudine tauwai sumaḡa matabudi 120 be Pita tuatuaḡanama nopodie ya midisuḡu be ya giuna, ");
INSERT INTO dww_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Yau bana, dokane Arua Babau Deivid ya riuena da banaga tenaḡa Yesu e boru dobiḡena. Be nama Deivid girugiruminama porane ya girumina. Be yodi uma riunama ya tubuḡana. Be uma baneginama tauna Judas. Be tauna Yesu tauvunuḡinama yai keda dokedina. ");
INSERT INTO dww_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Be uma baneginama noḡone Yesu tauna ya vinena da tauna tauda mate tè noyana. ");
INSERT INTO dww_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas Yesu borudobiḡenama aubainama mane a utena. Be uma manene doḡa ya gimeri. Be dabudine tauna debane ya beku be ya kati sari be tinaḡenama a daberarana. ");
INSERT INTO dww_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Be banaga matabuna Jerusalem nopone uma varinama a vaiena, vutuna aubainama uma doḡanama adi bonae ai isana ‘Akeldamak’. Inam baninama ‘kosina doḡanama’. ");
INSERT INTO dww_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Uma kauinama ya tubuḡana, baninama buka Salamo nopone ya girugirumina nama, “Na kaba mianama e kavakava be nam aitau nopone e mia”! Banaga ḡesau na noyama gabunama sibo ya paḡo” ");
INSERT INTO dww_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Vutuna aubainama tauḡoma ḡesau tà ḡoeḡoena da tauna tauda mate Yesu ya midimidisuḡu munaḡana tài matematena. Tauna aitau tauda mate tè naḡonaḡona, Jon yawai babataitona raḡanine, naumeki da Mamaitua Yesu ya nawena marae.” ");
INSERT INTO dww_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Naumeki da banaga rabui a vinedi. Jousep awai isana Basabas be awai isaisana Jastas be Mataias. ");
INSERT INTO dww_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Be dabudine a moiragina, “Bada, tam banaga matabudi nopodima kuya kataiena. Naumeki kwai kataimai da uma rabui nopodie deḡo tauna kuya vine ");
INSERT INTO dww_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","da tauna sibo apasol noyanama ya paḡo, baninama Judas uma noyanama ya gose pore be ya naḡona na kaba miae.” ");
INSERT INTO dww_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Naumeki da taudi yeku rabui bogedie inam banegidima isedima a girumidi da koukou nopone a biridina. Yodibe banaga tenaḡa yai matapota be koukou nopone yeku tenaḡa ya paḡo da e kitana be Mataias isanama yeku bogane. Naumeki da Mataias apasol 11 nopodie ya saḡana. ");
INSERT INTO dww_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Raḡanine Jius adi soima isanama Pentekost raḡaninama ya tavatavana, tauwai sumaḡa matabudi gabu tenaḡa ai rawateḡeidina. ");
INSERT INTO dww_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Be yai raḡantenaḡe da gavasa marae be ya yovona maika kaibitibiti gugurinama, be a miamiana vadanama noponama yai moḡavuna. ");
INSERT INTO dww_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dabudine taudi yaba a kitana maika kai menanama ya daberara be tenatenaḡaḡa debediḡa ya mia naḡona. ");
INSERT INTO dww_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Be matabudi Arua Babau nopodima ya moḡavu, be taudi bona da bona giudima ai karena, maika Arua Babau ya uteutedina nama. ");
INSERT INTO dww_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jerusalemma Jius banegidima toitoi a miamiana, Mamaitua a vivivivirena, be uma Jiusdima dobu ḡesaudie miemienidima mate a tavana. ");
INSERT INTO dww_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Be raḡanine uma gavasinama a vaivaiena, naumeki taudi gabu tenaḡa a rawateḡeidi be taudi a basedina da Yesu na tauwai muriwatanama bona be bona a giugiuedina. ");
INSERT INTO dww_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Be taudi a base kaue be a riuna, “Uma taudi Galili banegidima, ");
INSERT INTO dww_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","be nemanama da tauda tenaḡaḡa dà bonae dà bonae ta giugiu be tà vaivaiena? ");
INSERT INTO dww_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tauda matabuda dobu ḡesaudie be tè tavana, inam Paritia, Midia, Elam, Mesopotamia banegidima, Judia, Kapadosia, Pontus, Eisia, ");
INSERT INTO dww_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirigia, Pampilia, Ijipt, Libia Sairin diane be Rom. ");
INSERT INTO dww_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Rom banegidima taudi Jius be eteni banegidima ai rawajiusna. Be Kereti be Arebia banegidama mate tà miamia, be matabuda Mamaitua na kauama dosidima dà bonae dà bonae taudi ta giugiuedina tauda tà vaivaiedina.” ");
INSERT INTO dww_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yaḡoro taudi a base be a nuababaḡa be awai giu vivivirana, “Uma kauinama baninama aba?” ");
INSERT INTO dww_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Be banaga ḡesaudima ai varevaredi be a riuna, “Uma banegidima waen a tego guratena, vutuna aubainama a buana.” ");
INSERT INTO dww_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dabudine Pita be apasol 11 a midisuḡu be Pita bonanama dosine banaga ya riuedina, “Taumi Jius be aitauḡa Jerusalemma ko miamiana, koi beavaia kaua be aba yà giuena! ");
INSERT INTO dww_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Uma banegidima nam ti tego buana taumi ko noḡonoḡotina maika, baninama yodi 9 okoroki raḡanboiboi. ");
INSERT INTO dww_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ibewa, be girugiruminama porane peroveta Joel aba ya giugiuena yodi e tubutubuḡana. Joel ya giuna umanama: ");
INSERT INTO dww_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mamaitua ya riuna, Raḡan damodie taugu tokare yau Aruama yà ḡini poraḡana banaga matabudi ḡarodie. Be natunatumima tautauḡomidi be waiwaividima taudi tokare tai perovetana. Be ami tautauḡomama vaudima tokare matedie yaba ta kitedina maika rauboni, be ami banagama poredima taudi rauboni ta kitedina. ");
INSERT INTO dww_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Be inam ragandie yau taunoyama tautauḡomidima, be waiwaividima matabudi ḡarodie yau aruama yà ḡini poraḡa da taudi tokare tai perovetana. ");
INSERT INTO dww_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Be taugu mataira gunume be dobue yà voiedina, kosina, kai be basu mate. ");
INSERT INTO dww_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Suara ei kupikupina be nawaravi e sabana maika kosina be muriḡa da Bada na raḡanima dosinama waimatakanikaninama e tavana. ");
INSERT INTO dww_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aitauḡa Bada ḡarone sagu tawai baḡena, taudi tokare ei yawasanidina.’ ");
INSERT INTO dww_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel banagimima, uma riudima ko vaiedi: Nasaret Yesunama, tauna Mamaitua ḡarone be ya yovona ḡaromie. Be taumi sibo koya kataiena da Mamaitua tauna ya riuporena, baninama Mamaitua rewapana Yesu ya utena da voia dosidima be mataira ya voiedina. ");
INSERT INTO dww_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Be yaḡoro taumi banaga nam waisumeḡidi koya riuedi da tauna korosie a tuparatuna. Be nama Mamaitua na ogama. ");
INSERT INTO dww_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Be Mamaitua Yesu ḡarone guri tunimuyana be nuaboyanama ya kaipore be ya kawa midisuḡu munaḡena. Baninama guri nam teneteneḡina da Yesu ya kaididi. ");
INSERT INTO dww_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Baninama Deivid tauna Yesu na kauama umanama ya giuena: ‘Bada raḡan matabuna ewai dokeguna è kitana, baninama tauna taugu mate da taugu nam yà vabeku. ");
INSERT INTO dww_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Vutuna aubainama nuaguma ya vere be yau giuma be yau sarema mosari mate. Be avedi da taugu yà gurina, yaḡoro è kataiena da matabuna inam naumeki be yài nuaverena. ");
INSERT INTO dww_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Baninama tam tokare aruiguma nam guriguridima adi gabue kwa gose, be tam nam kui aninana da am Taunoya babauma e bova. ");
INSERT INTO dww_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tam yawasana kedanama kuyai kataigu be tam taugu mate da nopoguma mosari ya moḡavuna.’ ");
INSERT INTO dww_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Yau bana, naumeki da guyau Deivid na kauama yà riu ḡomemina. Deivid ya guri da a dobona be na kokoagama yaḡoro yodi ḡarode e kenakenana. ");
INSERT INTO dww_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tauna peroveta, vutuna aubainama tauna ya kataiena da na damma nopone tokare Mamaitua na waiguyauma banaga tenaḡa e utena, baninama Mamaitua ya sauga wapana da nama e voiana. ");
INSERT INTO dww_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Vutuna aubainama Deivid yai perovetana da Keriso e midisuḡu munaḡana, be tauna nam guriguridima adi gabue i gose be tuninama i bovana. ");
INSERT INTO dww_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Tauma matabumai matamata da Mamaitua uma Yesunama gurie ya kawa midisuḡuna ");
INSERT INTO dww_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","be na rewapanae ya kawa saḡe be kasaune yai mienina. Murine tamanama Arua Babau ya utena maika noḡone ya riuriuna nama. Be Yesu tauna tauma ḡaromaie e ḡiniḡini porena, vutuna yodi taumi ko kitakita be ko vaivaiena. ");
INSERT INTO dww_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Be Deivid nam marae i naḡona, be yaḡoro umanama ya riuna, ‘Mamaitua taugu yau Badama ya riuena, Kasaugue kwa miana ");
INSERT INTO dww_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","naumeki da taugu am ḡaviama yà vaḡaḡaridi be kaḡamma dibune yà biridina maika guni.’ ");
INSERT INTO dww_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Vutuna aubainama Israel banegimima matabumi ko kataie da uma Yesunama koya tupatuparatuna Mamaitua tauna vutuna ya voie da yodi tauna Bada be Tauwai yawasana.” ");
INSERT INTO dww_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Raḡanine banaga umanama a vaivaiena, nuedima ya karati be Pita be aposels ḡesaudima a riuedina, “Tuatuaḡamaima, yodi aba ka voie?” ");
INSERT INTO dww_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Be Pita ya paribeedi, “Tenatenaḡaḡa nuenuemima ko vitaredi be ko babataitona Yesu Keriso isane da ami gewagewama e noḡota pore be Mamaitua puyo Arua Babau e utemina. ");
INSERT INTO dww_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Baninama Mamaitua ya riu vavasaḡana da nama e voiena. Vutuna aubainama uma puyonama inam taumi be ami sedama mate aubaimima, be banaga ḡesaudima madanie aitauḡa Bada dà Mamaituama e yokoedina.” ");
INSERT INTO dww_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Be giu toitoi ḡesaudima mate Pita ya riuwai noḡotidi be ya duḡudina, “Mamaitua ko gose da ei yawasanimi, da nam uma damnama adi yawasanama barebaredima adi kovoḡama ko paḡo.” ");
INSERT INTO dww_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yodi taudi aitauḡa riunama a paḡopaḡona, taudi a babataitona. Inam raḡanine banaga sievinama 3 tausand nama adi banagama waisumeḡidima nopodie a saḡana. ");
INSERT INTO dww_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Be apasol adi waikatakataima a vaivaia nonoḡedi be a raberabedina, be taudi a turituriya be moiragie matabudi awai rawateḡeidina. ");
INSERT INTO dww_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Be matabudi nopodima naira ma vivirina ya moḡavu be mate apasol voia dosidima be mataira toitoi a voivoiedina. ");
INSERT INTO dww_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Be banaga tauwai sumaḡa matabudi a rawateḡeidi be yaba matabuna ḡarodie teneteneḡinama a ragaudina, ");
INSERT INTO dww_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","be taudi doḡa be purapura a gimaredi da mane a paḡo be adi banagama waikaruwaḡewaḡedima a utedina. ");
INSERT INTO dww_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Raḡan matabuna tempol nopone taudi awai rawateḡedina, be adi vadama nopodiḡa taudi ma nuaveredi buredi a giva be a kanikanina. ");
INSERT INTO dww_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Be taudi Mamaitua a kaikai suḡu be banaga ḡesaudima nuedima a paḡopaḡona. Be raḡan matabuna Bada banaga ḡesaudima yawai yawasanidina ya saḡedina adi banagama nopodie. ");
INSERT INTO dww_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Raḡan tenaḡa ravie suara 3 okoroki inam moiragi raḡaninama aubainama, Pita be Jon a saḡa a naḡonaḡona tempol nopone. ");
INSERT INTO dww_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Be tempol nopone matakeda tenaḡa ya kenakenana isanama ‘Verekaua’. Be raḡan matabuna banaga dabudine tuera ya tubuḡena a kiroḡi be inam matakedanama diane ai mieni be aitauḡa tempol nopone a naḡonaḡona ḡarodie mane ya kiḡikiḡiedina. ");
INSERT INTO dww_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Raḡanine Pita be Jon tempol nopone ḡaubonaḡa sibo a saḡana, be tauna ya kitedi be mane aubainama ya kiḡiedina. ");
INSERT INTO dww_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dabudi Pita be Jon tauna a kitadidi be Pita ya riuna, “Kwa kitamai!” ");
INSERT INTO dww_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Naumeki da, tauḡoma ya kitedi be yawai noḡotana da aiyaba sibo ḡarodie ya paḡona. ");
INSERT INTO dww_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Be Pita ya riuna, “Silva be gold nam ḡarogue be aiyaba ḡarogue, vutuna tam yà utemna. Nasaret Yesu Kerisonama isane: Kwa midisuḡu be kwa naḡo!” ");
INSERT INTO dww_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dabudine nimanama kasaune ya kaididi be ya soru waimidisuḡuna. Be inam raḡanine tauḡoma kaḡanama be kaḡa matabiwanama ai rewapana munaḡana ");
INSERT INTO dww_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","be tauna kaḡane ya poti be naḡo yai karena. Naumeki da taudi mate a naḡona tempol nopone, be tauna tempol noponaḡa ya naḡo be yai potipoti be Mamaitua isanama ya kaikai suḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Be banaga matabudi inam tauḡominama a kitana ya naḡo be Mamaitua isanama ya kaikai suḡusuḡuna. ");
INSERT INTO dww_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Be banaga tauna a kitakitana a kataiḡome da tauna baneginama raḡan matabuna tempol noḡone matakeda isanama ‘Verekaua’. Dabudine ya mia be mane ya kiḡikiḡi dobidobina. Be banaga matabudi a ḡosoridi be a base da aba ḡarone ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Naumeki da taukiḡikiḡi Pita be Jon ya kaidididi be banaga matabudi a base kauena be a manini taudi ḡarodie gabu isanama ‘Solomon na wagapatama’. ");
INSERT INTO dww_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Raḡanine Pita nama e kitedina be ya riuedina, “Israel banegimima, taumi aba ko basebase be ko kitakitamai da tauma kabe uma baneginama kè kawa naḡo ama rewapanae bo ama voteyateyama Mamaitua ḡarone? ");
INSERT INTO dww_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mamaitua, noḡone tamatamadama Eibraham, Aisik be Jeikob awai sumaḡena, tauna na taunoyama Yesu ya kawa saḡena. Uma Yesunama taumi koyai utaena waigurinama aubainama. Be avedi da Paelat ya ḡoeḡoena sibo ya riupore ya naḡona be taumi koya raukosoḡaiḡaina. ");
INSERT INTO dww_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tauna banaga babaunama be didimana vavasaḡinama be taumi nam ko ḡoeḡoena da tauna sibo ya yawasana be taumi banaga tauwai gurinama tauna aubainama Paelat koyai baḡa da ya yawasanana. ");
INSERT INTO dww_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Taumi yawasana tauverauḡenama koyai gurina. Be Mamaitua gurie yai yawasanina be tauma uma kauinama na matamatama. ");
INSERT INTO dww_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Be uma tauḡominama matabumi ko kitakita be ko katakataiena, tauma ama waisumaḡama Yesu isane aubainama, Yesu isane yai rewapanana. Yesu uma waisumeḡinama ya utena da tauna ya yawasanana da yodi matabumi ko kitakitana. ");
INSERT INTO dww_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Be yodi yau banagama, taugu è kataiena da taumi ami babadama mate bua maika koya voivoiana. ");
INSERT INTO dww_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Be umanama Mamaitua na giuma yai maḡatarina, baninama noḡone peroveta matabudi ḡarodie ya riuna da tokare na Kerisoma ei nuatoitoina. ");
INSERT INTO dww_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Vutuna aubainama nuemima ko vitaredi be Mamaitua ḡarone ko naḡo da tauna ami gewagewama e kaiporaḡa be nuemima e subana. ");
INSERT INTO dww_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dabudine Tauwai yawasana ya vinevinena e riuporena ḡaromie. Uma tauwai yawasaninama tauna Yesu. ");
INSERT INTO dww_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tauna marae e miana, naumeki da raḡan e tava da Mamaitua yaba matabuna e rawavau munaḡedina, baninama inam nama dokane tauna na babau perovetama ḡarodie ya riuna. ");
INSERT INTO dww_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Be Mousis mate ya riuna nama, ‘Bada ami Mamaituama tauna tokare nopomie peroveta tenaḡa e vinena maika taugu. Tauna raḡanine yaba matabuna e giugiuemina, taumi koi beavaiena! ");
INSERT INTO dww_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Be aitau tenaḡa tauna nam ei beavaie naumeki da Mamaitua tokare tauna e tavu dobiḡe be e kawa gewagewana.’ ");
INSERT INTO dww_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Be Pita na giuma ya kaiwatani be ya riuna, “Be peroveta ḡesaudima taudi mate a riuna da uma kauidima tokare ta tubuḡana, maika yodi uma raḡandie ta tubutubuḡana nama. Inam perovetedima taudi Samuel be ḡesaudima murine a tubutubuḡana. ");
INSERT INTO dww_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Be taumi inam perovetedima adi sedama, vutuna aubainama Mamaitua boni ami dosima ḡarodie riuwai noḡota ya boruna, inam taumi mate aubaimima nama ya riuna. Be Mamaitua na riuwai noḡotama inam umanama Eibraham ḡarone ya boruna, ‘Tokare am dame peroveta tenaḡa e tubuḡana. Be taune taugu dam matabudi dobue yài aiainidina.’ ");
INSERT INTO dww_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Vutuna aubainama Mamaitua na taunoyama gurie ya kawakawa midisuḡu munaḡena, noḡone ya riupore yovoḡena taumi ḡaromie. Be inam taunoyanama e voiemi da ami gewagewama ko gose poredina, yodibe tauna ei aiainimina.” ");
INSERT INTO dww_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita be Jon yaḡoro banaga ḡarodie a giugiuna maika, pirisi, Sadisi be tempol taurabedima adi badama Pita be Jon ḡarodie a tavana. ");
INSERT INTO dww_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Taudi nuedima yai medina, baninama Pita be Jon banaga awai katakataidi be a riuriuedina da Yesu gurie ya midisuḡu munaḡana aubainama, tokare banaga matabudi gurie be ta midisuḡu munaḡana. ");
INSERT INTO dww_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Vutuna aubainama a panidi be ravi aubainama dibure a biridina naumeki da raḡan ya tom. ");
INSERT INTO dww_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Be banaga toitoi Pita na giuma a vaivaiena ai sumaḡana. Be yodi tauwai sumaḡa tautauḡoma sievinama ya tausaḡana 5 tausand. ");
INSERT INTO dww_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Naumeki da pomainama Jius adi babadama be babada dosidima be tarawatu tauwai katakataidima ai rawateḡeidi be ai boruna Jerusalem nopone. ");
INSERT INTO dww_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Banaga uma borune, Anas tauna pirisi adi badama, Kaiyapas, Jon, Alexanda be tautauḡoma ḡesaudima pirisi adi badama na dame banegidima mate. ");
INSERT INTO dww_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Taudi Pita be Jon poudie ai midiridi be ai taraviredina, “Aba rewapanine bo aba isane taumi uma kauinama koya voie?” ");
INSERT INTO dww_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dabudine Pita noponama Arua Babau ya moḡavu be ya riuedina, “Jius babadimima be babada dosimima koi beavaia. ");
INSERT INTO dww_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Tauma manaka kowai taravireviremaina, voia verenama banaga tuera paḡopaḡonama ḡarone ya tubuḡana aubainama. Taumi kowai taravireviremaina da aiyabae uma baneginama ya yawasana. ");
INSERT INTO dww_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Naumeki da ka riuemi be taumi be Israel banagimima matabumi ko vaie. Nasaret Yesu Kerisonama taumi koya tupatuparatuna, tauna Mamaitua gurie ya kawa midisuḡu munaḡena, tauna isane uma baneginama yodi ya yawasana be noḡomie e midimidina. ");
INSERT INTO dww_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘Tauna yekunama vutuna taumi vada taukerinama koya tuaḡaiena, be yekunama Mamaitua ya voie da na vadama yasinama ya tubuḡana’. ");
INSERT INTO dww_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Nam aitau tenaḡa tokare ei yawasanimi, baninama dobu matabuna nopone nam ai isa ima kenakenana da isane yawasana tai baḡe, ibewa da Yesu taunaḡa isane.” ");
INSERT INTO dww_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Raḡanine Pita be Jon adi raudebatorama a kitakitana, taudi a base kauedina, baninama taudi a kataiena da Pita be Jon taudi nam giruma kaua banegidi, be taudi banaga yababa. Taudi a kataiena da uma banegidima noḡone Yesu mate naḡonaḡodima. ");
INSERT INTO dww_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Be yodi taudi ta kitana be banaga waiwai yawasaninama tauna diedie mate a midimidina. Vutuna aubainama taudi nam teneteneḡina da sibo ḡarodie aba a giue. ");
INSERT INTO dww_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Naumeki be Sanedrion nopone be a riupore dobiḡedi be babada taudiḡa ai tarapiri vivirana. ");
INSERT INTO dww_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Be taudiḡa ai taravira munaḡedina, “Uma banegidima nema tà bakedi? Jerusalem banegidima matabudi a kataiena da uma banegidima mataira dosinama a voiena, be tauda nam teneteneḡina da tà boviedi. ");
INSERT INTO dww_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Be uma kauinama tà riutuaḡaie da nam banaga ḡarodie e daberara, vutuna aubainama uma banegidima nuedima tà boru da nam aitau ḡarone Yesu isane ta giu munaḡa.” ");
INSERT INTO dww_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dabudine Pita be Jon a riuedi da Sanedrion nopone a saḡa munaḡa be a riu vavasaḡedina da nam sibo Yesu isane a giu bo ai katakatai rubu. ");
INSERT INTO dww_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Be taudi a paribeedi be a riuna, “Taumiḡa ko kaivira da Mamaitua matane deḡo tauna ya vere. Mamaitua riunama ka voie bo taumi riumima ka voie? ");
INSERT INTO dww_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tauma nam teneteneḡina da aba ke kitakitana be ke vaivaiena giuenama ka gose.” ");
INSERT INTO dww_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Naumeki da a riuwai nainairidi be a gosedi da a naḡona, baninama taudi nam ti kataiena da nema sibo a kovoḡa bakedi. Be banaga matabudi inam matairinama dosinama aubainama, Mamaitua isanama a kaikai suḡusuḡuna, ");
INSERT INTO dww_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","baninama uma tauḡominama tuera paḡopaḡonama tauna nama ya tubuḡena naumeki da yodi na suarama 40 be ya saḡa porena. ");
INSERT INTO dww_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Raḡanine Pita be Jon a riuriuporedina, taudi a munaḡana adi banagama tauwai sumaḡa ḡarodie be yaba matabuna pirisi adi babada be babada dosidima aba a giugiuedina, nama ai maḡataridina. ");
INSERT INTO dww_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Raḡanine adi banagama nama a vaivaiena, taudi a rawateḡeidi be a moiragina Mamaitua ḡarone, “Bada dosimma, tam mara, dobu, egasi be nopodie yaba matabuna kuya voiedina. ");
INSERT INTO dww_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tauma tamamaima Deivid, tam taunoyama, tam Arua Babaue kuya voie da tauna umanama ya giuna, ‘Eteni banegidima aba aubainama ta medimedi? Inam banegidima aba aubainama taudi am kasirama ta tomtom yababe? Inam kasirinama kavakavanama. ");
INSERT INTO dww_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dobu guyaguyaudima a midi be babada dosidima a rawateḡeidi da Bada be na vinevinema tawai ḡaviedina.’ ");
INSERT INTO dww_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Riukaua, Herod, Pontis Paelat, eteni banegidima be Israel mate uma meagaine a rawateḡeidi be am taunoyama babauna Yesu kuya vinevinena ai ḡaviena. ");
INSERT INTO dww_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Be taudi aba am rewapanae be am ḡoanama oganama kuya tarataraḡina da sibo ya tubuḡana, nama yodi a voiena. ");
INSERT INTO dww_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Be Bada, yodi adi raukivigewagewama ḡaromaie kwa noḡoti be kwa voiemai da tauma am taunoyama riumma raudebatorae ka giue. ");
INSERT INTO dww_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nimamma kwai yoyo waiyawasana aubainama da mataira be voia dosidima kwai tubuḡidina am taunoyama babaunama Yesu isane.” ");
INSERT INTO dww_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Raḡanine moiragi ya kovikovina taudi deḡo awai rawateḡeidina gabunama yai tauyoyona. Be taudi matabudi Arua Babau yai moḡavudi be taudi Mamaitua riunama ma raudebatoredi a giuena. ");
INSERT INTO dww_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tauwai sumaḡa banegidima matabudi nuenuedima be adi noḡotama tenaḡa. Be nam aitau tenaḡa i riuna taunaḡa na purapura, ibewa da matabudi ai sagu vivirana. ");
INSERT INTO dww_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Dabudine apasol ma rewapana vavasaḡidi Bada Yesu ya guri ya midisuḡuna awai matematena. Be Mamaitua sagu dosinama matabudi ḡarodie ya riupore yovoḡena. ");
INSERT INTO dww_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Be dabudine nam aitau poudie aba i maruabiena, baninama kana raḡanie aitauḡa doḡa be vada ḡarodie, a raugimaredi be mane ");
INSERT INTO dww_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","apasol ḡarodie a sivudina. Be aitau aba ya marumaruabiena, nama mane a utedina. ");
INSERT INTO dww_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Maika Jousep tauna Livai damnama nopone be Saiprasma ya tubuḡana be apasol tauna awai isaisana Banabas. Isa Banabas baninama inam ‘taurau duḡu’. ");
INSERT INTO dww_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tauna doḡa yawai badena ya gimare be manenama ya verauḡena apasol ḡarodie dariḡenama aubainama. ");
INSERT INTO dww_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tauḡoma tenaḡa isanama Ananaias, be na visarama Sapira, tauna mate adi doḡama tenaḡa ya gimare da ");
INSERT INTO dww_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","mane isunama tauna aubainama ya kaididi kwasena be mane isunama apasol ya utedina. Be na visarama Sapira tauna mate yai aninana. ");
INSERT INTO dww_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Be Pita ya riuena, “Aba aubainama Seitan kuyai anine da nopomma yai moḡavu be Arua Babau ḡarone kuya kaiyovu be doḡa kuya gimagimarena manenama isudima tam aubaimma kuya rabe kwasedi? ");
INSERT INTO dww_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tam sibo doḡa kuya rabe kwasena bo doḡa kuya gimarena murine, mane sibo kuya rabe kwasena. Be aba aubainama uma kauinama nopome kuyai nuanoḡonoḡote be nama kuya voia? Tam nam banaga ḡarone ku kaiyovuna, ibewa da Mamaitua ḡarone kuya kaiyovuna.” ");
INSERT INTO dww_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Raḡanine Ananaias nama giunama ya vaivaiedina, tauna ya beku be ya gurina. Be banaga aitauḡa inam nama kauinama a vaivaiena, taudi a naira kauana. ");
INSERT INTO dww_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Raḡanine Ananaias ya gurigurina, dabudine yarayaraga a tava da a suma be a kiroḡa nawe da a dobona. ");
INSERT INTO dww_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Suara ruvanama 3 awasnama a kovina murine, Ananaias na visarama ya tava be nam i kataiena da aba ya tubuḡa. ");
INSERT INTO dww_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita yai taravirena, “Kwa riuegu, doḡa koya gimagimarena manenama, naumeki umanama, bo?” Be waivi ya riuna, “Ee, inam naumeki nama.” ");
INSERT INTO dww_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Be Pita ya riuena, “Aba aubainama taumi koyai anina da Bada Aruinama koya raurubu? Banaga am tauḡomama a dobodobona, taudi matakedae tawai rabana da tam mate ta kiroḡa dobiḡemna.” ");
INSERT INTO dww_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Naumeki da waivi yai raḡantenaḡe da Pita kaḡane ya beku be ya gurina. Dabudine yarayaraga a saḡa vadae, ta kitana be waivi ya gurina. Naumeki da a kiroḡa dobiḡe be na tauḡomama diane a dobona. ");
INSERT INTO dww_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Be Mamaitua na damma matabudi be banaga ḡesaudima aitauḡa inam riunama a vaivaiena, taudi a naira kauana. ");
INSERT INTO dww_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apasol mataira be voia dosidima toitoi a voiedina banaga ḡarodie. Be tauwai sumaḡa matabudi kana raḡanie Solomon na wagapatae awai rawateḡeidina, ");
INSERT INTO dww_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","be banaga ḡesaudima nam waisumeḡidi taudi wairawateḡei a naira be yaḡoro banaga ḡesaudima a vivivivira kauedina. ");
INSERT INTO dww_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Be tautauḡoma be waiwaivi ḡesaudima mate Bada awai sumaḡena, inam damnama nopone a saḡana. ");
INSERT INTO dww_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Taudi banaga sidesidedima a kiroḡa nawedi kedae da vatara be guni debedie ai kenedina. Nama a voiana, baninama Pita ya veraverauna vagurunama sibo ya taukonidina. ");
INSERT INTO dww_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Patara ḡesaudima Jerusalem diane meagaidima mate a rawateḡeidi, be banaga sidesidedi be banaga nopodie arua gewegewedima miemienidima mate a tavaitedina, be matabudi ai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dabudine pirisi adi badama be na banagama Sadisi mate taudi nopodima unura ya moḡavuna. ");
INSERT INTO dww_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Taudi Apasol a panidi be dibure a biridina. ");
INSERT INTO dww_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Be kupie Bada na aneama dibura matakedanama ya kaipore da yai doka dobiḡedi be ya riuedina, ");
INSERT INTO dww_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ko naḡo, tempol nopone ko midi be uma yawasaninama vaunama, matabuna banaga ko riuedi!” ");
INSERT INTO dww_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Raḡanine uma riunama a vaivaiena, taudi raḡantomtom a naḡo tempol nopone be waikatakatai ai karena. Pirisi adi badama be na banagama mate a tavana raḡanine, taudi boru isanama Sanedrion a voiena Israel babadidima mate. Dabudine banaga a riuporedina dibure, apasol waidokedima aubainama. ");
INSERT INTO dww_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Raḡanine taudi dibure a tavatavana apasol nam ti banavidina, vutuna aubainama a munaḡa be babada ḡarodie ai maḡatara ");
INSERT INTO dww_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","be a riuna, “Dibura matakedanama gudugudu yaḡenama be taurabenama matakedae a midimidina. Be matakeda kè kaikaiporena raḡanine, nam aitau tenaḡa ke banavina.” ");
INSERT INTO dww_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Raḡanine tempol taurabenama adi bada be pirisi adi babadama uma riunama a vaivaiena, taudi a nuababaḡa be nam ti kataiena aba tokare e tubuḡa. ");
INSERT INTO dww_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dabudine banaga tenaḡa ya tava be ya riuna, “Tautauḡoma dibure koya sivusivudina, taudi yodi tempol nopone ta midi be banaga tawai katakataidina.” ");
INSERT INTO dww_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dabudine tempol taurabedima adi badama mate a naḡo be apasol a verauḡedina. Be nam ti segeridina, baninama taudi a nairana banaga tima rauyekudi aubainama. ");
INSERT INTO dww_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Taudi apasol a verauḡedina Sanedrion noḡodie da pirisi adi badama ei taravireviredina. ");
INSERT INTO dww_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Be tauna ya riuna, “Kè riu vavasaḡemina da taumi nam sibo Yesu isane koyai katakatai. Be taumi yaḡoro koyawai katakatai da uma riunama yodi Jerusalem noponama ya moḡavuna, be ko riuriuna da uma baneginama ya gurina wavunama tauma kabe ka kiroḡi.” ");
INSERT INTO dww_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Be Pita apasol ḡesaudima mate a riuna, “Tauda Mamaitua sibo tè voteyeteyena, be nam banaga. ");
INSERT INTO dww_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Taumi Yesu kai bogane koyai gurina, be tamatamadama adi Mamaituama tauna gurie be kawa midisuḡu munaḡena. ");
INSERT INTO dww_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Be Mamaitua na rewapanae Yesu ya kawa midisuḡu da tauna Bada be Tauwai yawasana ya tubuḡana, baninama taune Mamaitua ya voie da Israel banegidima adi noḡotama ta vitaredi be adi gewagewama e noḡota poredina. ");
INSERT INTO dww_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tauma be Arua Babau inam kauidima kadi matamatama. Be aitauḡa Mamaitua a vovo teyeteyena, naumeki da taudi Arua Babau ya utedina.” ");
INSERT INTO dww_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Raḡanine taudi umanama giunama a vaivaiena taudi nuedima yai medi kaua be waiguridima a ḡoena. ");
INSERT INTO dww_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Be Parisi tenaḡa isanama Gamaliel, tauna tarawatu tauwai katakatainama be banaga matabudi tauna a vivivivirena. Naumeki da tauna Sanedrion nopone ya midisuḡu be ya riuedi da apasol doḡae a dobiḡedina raḡan ḡaubonaḡa. ");
INSERT INTO dww_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dabudine na banagama ya riuedina, “Israel babadimima taumi ko kita kaua da aba uma banegidima ḡarodie ko voiena. ");
INSERT INTO dww_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dokane nama tauḡoma isanama Tudas ya naḡomidisuḡu be ya riuna da tauna kabe banaga dosina, be banaga sievinama 400 nama ai muriwatanena. Be raḡanine tauna awai gurina, naumeki da tauwai muriwatana ai daberaridi be yaba matabuna ya kovina. ");
INSERT INTO dww_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Be murine, Galili tauḡominama isanama Judas, tauna sensus raḡandie ya naḡomidisuḡu be banaga kourunama yai doka waigewedina. Be tauna mate ai gurina, be na tauwai muriwatanama mate ai daberaridina. ");
INSERT INTO dww_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Vutuna aubainama yodi yà rarau kuremina da uma tautauḡomidima ko gose poredi be ta naḡo. Baninama deḡoda adi noyama banage, tokare noyanama e bekuna, ");
INSERT INTO dww_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","be deḡoda Mamaituae, taumi tokare nam teneteneḡina da uma tautauḡomidima ko riutuaḡaiedi deḡoda taumi Mamaitua kowai ḡaviena.” Naumeki da inam babadidima taudi Gamaliel na raukurama a voteyeteyena. ");
INSERT INTO dww_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Dabudine apasol ai doka saḡedi da kwapue a riḡedi, be a riu vavasaḡedina da nam Yesu isane ta giu munaḡa. Naumeki da a raukai gosedi be a naḡona. ");
INSERT INTO dww_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Dabudine apasol ma nuavereveredi Sanedrion a gose porena, baninama Mamaitua ya vinedina da taudi teneteneḡinama da tai nuatoitoina Yesu isanama aubainama. ");
INSERT INTO dww_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Be raḡan matabuna tempol be banaga adi vadama nopodiḡa waikatakatai nam ti gosena, be a rarau guguyana da Yesu tauna Tauwai yawasana. ");
INSERT INTO dww_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Inam raḡandie, tauwai muriwatana sievinama ya moramorabana. Be Grik Jiusdima ai riusinḡaḡayana Hibru Jius ḡarodie, baninama Gurik Jiusdima adi kaiyababama a kitakita poredina, raḡanine kani a soisoiedina nopone. ");
INSERT INTO dww_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Vutuna aubainama 12 apasol tauwai muriwatana ai rawateḡeidi be a riuna, “Nam i vere da tauma kani ka soisoi koe be Mamaitua riunama ka gose. ");
INSERT INTO dww_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Vutuna aubainama, yau bana, koi kita wanawana da tautauḡoma 7, aitauḡa koya kataiedina Arua Babau be nuauyauya nopodima ya moḡavuna ko ragaudi da taudi uma noyanama ta paḡo be ta voiena. ");
INSERT INTO dww_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Be tauma naumeki da ama noyama moiragi be rauguguya ka kaididina.” ");
INSERT INTO dww_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dabudine banaga matabudi apasol adi giuma ai anine be taudi uma banegidima a vinedina: Stepen, tauna tauḡoma noponama waisumaḡa be Arua Babau ya moḡavu; be Pilip, Porokurus, Nikanor, Timon, Pamenas be Nikolas, tauna Antiok baneginama, be tauna yai rawajiusna. ");
INSERT INTO dww_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Uma tautauḡomidima apasol ḡarodie a verauḡedi be taudi aubaidima a moiragi be nimedima debedie a sivudina. ");
INSERT INTO dww_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Naumeki da Mamaitua riunama ya daberarana. Tauwai muriwatana Jerusalem nopone sievidima ya morabana, be pirisi toitoi mate Yesu ai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stepen tauna Mamaitua na wainuapaḡo be na rewapanama noponama ya moḡavuna. Be tauna mataira be voia dosidima banaga ḡarodie ya voiedina. ");
INSERT INTO dww_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Be raḡan tenaḡa Jius sinagog nopone isanama ‘Libatine’, banegidima taudi Stepen a riuvirevirena. Dabudine Jius ḡesaudima, Sairin be Alexandria be Silisia be Eisia provins banegidima mate Stepen a riuvirevirena. ");
INSERT INTO dww_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Be Arua Babau Stepen noḡota verenama ya utena da taudi nam teneteneḡina da na giuma sibo a riḡa. ");
INSERT INTO dww_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Vutuna aubainama taudi waimoisirie banaga a ragaudi be a riuedina da sibo umanama a giuna, “Tauma kè vaiena da Stepen, Mousis be Mamaitua ya riuwai gewegewedina.” ");
INSERT INTO dww_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Uma giunama debane banaga, babada dosidima be tarawatu tauwai katakataidima a kawa nuamedimedidina. Vutuna aubainama Stepen a pani be a verauḡena Sanedrion babadidima noḡodie. ");
INSERT INTO dww_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Be taudi tauwai matamata kaikaiyovudima a voiedi da taudi a riuna, “Uma baneginama raḡan matabuna tempol be tarawatu e riuriu tuatuaḡaiedina. ");
INSERT INTO dww_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Baninama tauma kè vaiena da tauna umanama ya riuna, ‘Uma Nasaret Yesunama tauna tokare uma gabunama e kawa gewagewana be Mousis tarawatu ya riuriuedana matabudi e vitaredina.’” ");
INSERT INTO dww_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Banaga matabudi Sanedrion nopone a miamiana Stepen a kitadidi be taudi a kitana da noḡonama maika kabe anea noḡona. ");
INSERT INTO dww_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pirisi adi badama Stepen ya riuena, “Uma banegidima aba ḡarome ta giugiuena, riukaua, bo?” ");
INSERT INTO dww_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Be Stepen ya paribeedina, “Tamatamaguma be tuatuaḡaguma koi beavaiegu! Mamaitua ma neneḡarina tauna tamadama Eibraham ḡarone ya maḡatarana tauna Mesopotamiama ya miamiana raḡanine. Muriḡa da ya naḡo be Haranma ya miana. ");
INSERT INTO dww_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Be Mamaitua tauna ya riuena, ‘Am dobu be am banagama kwa gosedi be kwa naḡona deḡo dobunama yai kataimna dabudine!’ ");
INSERT INTO dww_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Dabudine tauna dobu isanama Kaldea ya gose be ya naḡona Haranma, dabudine ya miana. Be raḡanine tamanama ya gurina, murine Mamaitua ya riuporena uma dabudine, deḡo yodi taumi ko miamiaena. ");
INSERT INTO dww_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Be nam deḡo gabu ḡaubonaḡa i ute rubuna. Be Mamaitua ya saugana da wari raḡan uma dobunama tauna be na damma muriḡa e utedina. Avedi da Eibraham nam i natunana, be Mamaitua nama ya riuena. ");
INSERT INTO dww_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Be Mamaitua umanama ya riuena: ‘Tokare tam am damma taudi vaḡavaḡai dobu ḡesaune be inam dobunama banegidima tai taunoyedi be ta raukivi gewegewedina modi 400 nopodie. ");
INSERT INTO dww_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Be taugu uma dobunama banegidima yà kovoḡidina, baninama tam am banagama awai taunoyedina. Be raḡan muriḡa inam dobunama ta gose be taudi uma dabudine yau noyama ta voiena.’ ");
INSERT INTO dww_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Naumeki da Mamaitua kopitom riuwai noḡotinama Eibraham ya utena. Vutuna aubainama raḡanine Aisik ya tubuḡana, be raḡan aniwai 8-nama nopone tamanama Eibraham Aisik ḡarone kopitom ya voiena. Be muriḡa, Aisik natunama Jeikob ḡarone kopitom ya voiena, be Jeikob natunatunama 12 ḡarodie kopitom ya voiedina. Be uma banegidima 12 taudi dede pakanama ai karena. ");
INSERT INTO dww_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Be dede pakanama banegidima taudi Jousep a nurena. Vutuna aubainama Ijipt banegidima ḡarodie a raugimarena. Be Mamaitua tauna mate, ");
INSERT INTO dww_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","be na wainuatoitoie ya sagu da nuauyauya dosinama ya utena be Jousep tauna adi guyauma Pero ya tatai nuavaina. Be vutuna aubainama guyau Pero ya voie da Jousep Ijipt be na vadama tauna yai badedina. ");
INSERT INTO dww_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Naumeki da Ijipt be Kanan nopodie meiḡara dosinama ya tubuḡa be banaga ai nuatoitoi kauana be tamatamadama nam kani ti banavidina. ");
INSERT INTO dww_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Raḡanine Jeikob e vaiena be Ijiptma witi ya kenakenana, naumeki da tamatamadama ya riupore nawedina dabudine. Nam airaḡan Ijiptma ti naḡonaḡo rubuna, naumeki da inam raḡanine naḡona. ");
INSERT INTO dww_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Adi naḡoma wairabuine Jousep tuatuaḡanama be tasitasinama ya riuedina da tauna aitau be dabudine guyau Pero Jousep na damma ya kataiedina. ");
INSERT INTO dww_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Naumeki da Jousep tuatuaḡanama be tasitasinama ya riuporedina da tamanama Jeikob na banagama mate matabudi ta verauḡedina. Be na damma sievinama matabudi 75. ");
INSERT INTO dww_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Naumeki da Jeikob ya naḡona Ijiptma, dabudine tauna be tamatamadama a gurina. ");
INSERT INTO dww_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Be taudi tubuḡidima a verau munaḡedi Sikemma be dabudine gubae a biridina. Uma gubanama Sikemma, boni Eibraham manee ya gimerina Hemor natunatunama ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Muriḡa da Mamaitua na saugama ya boruboruna raḡaninama sibo ya tavana, be Mamaitua ya riuna, ‘Yodi taugu aba Eibraham è sausaugena, ḡaubonaḡa yà voiena.’ Be Ijipt nopone dà banagama Israel banegidima sievidima ya moraba kauana. ");
INSERT INTO dww_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Naumeki da guyau Pero ya guri be murine tauḡoma ḡesau Ijiptma guyau ya tubuḡana be tauna Jousep nam i kataiena. ");
INSERT INTO dww_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Be tauna dà dosima kadi kasirama ya tom be ya raukivi gewegewedina be ya segeridi da seda wawaidima ai poraḡa dobiḡedi da sibo a gurina. ");
INSERT INTO dww_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Inam raḡandie Mousis ya tubuḡana, be Bada matane tauna nam kamai gomagomana. Be tauna nawaravi rabuiteḡa tamanama na vadae a rabena. ");
INSERT INTO dww_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Be muriḡa nam teneteneḡina da vadae a semo, naumeki da a dobiḡe be a nawena. Be guyau Pero natunama waivinama ya banavi be ya yosina maika kabe natuḡomina. ");
INSERT INTO dww_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Be Mousis Ijipt adi katai be adi nuauyauyama matabudi ya ragaudina, be na giuma be yaba ya voivoiedina matabudi ai rewapana kauana. ");
INSERT INTO dww_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Raḡanine Mousis na suarama 40 a kovikovina, tauna nopone noḡota ya saḡa da na banagama, Israel banegidima, e vakitekitedina. ");
INSERT INTO dww_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Be Mousis e kitana be Ijipt tauḡominama tenaḡa Israel tauḡominama ya raraukivi gewegewena. Naumeki da Mousis ya midi ḡaḡari be turanama biwanama ya paḡo be Ijipt tauḡominama ya kati gabana. ");
INSERT INTO dww_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mousis yai noḡotana, ‘Israel banegidima sibo a kataie da Mamaitua taugu ya riuporeguna taudi waiyawasanidima aubainama.’ Be taudi nam ti kataiena. ");
INSERT INTO dww_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Pomainama tauna e tava e kitana be Israel banegidima rabui taudiḡa awai kawa ḡasiḡasina. Dabudine tauna yai sasarana be ya riuna, ‘Ei! Turamma mate aba aubaina kowai kawa ḡasiḡasi?’ ");
INSERT INTO dww_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Be tauḡoma iḡara tauwai karenama tauna Mousis ya biusuriḡi be ya riuna, ‘Tam aitau ya voiem da tauma kwawai bademai be kwawai tara piriemai? ");
INSERT INTO dww_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tam maiḡo Ijipt tauḡominama kuya vunuḡi be manaka kwa ḡoeḡoena taugu kwa vunuḡigu, bo?’ ");
INSERT INTO dww_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Raḡanine Mousis uma giunama ya vaivaiena, tauna naira Ijipt ya gose be ya naḡona dobu isanama Midian. Inam dabudine ware ya miamiana, be na sedama tautauḡomidima rabui ya tikedina. ");
INSERT INTO dww_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Modi 40 a kovina murine dobu kavakavane anea Mousis ḡarone ya maḡatarana gedara kodekoderinama menanama nopone, oya isanama Sainai diane. ");
INSERT INTO dww_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Raḡanine Mousis uma matairinama ya kitakitana, tauna ya base be ya naḡona diane kita yaḡenama aubainama. Dabudine be Bada bonanama ya vaiena: ");
INSERT INTO dww_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Taugu tametamemima Eibraham, Aisik be Jeikob adi Mamaituama.’ Be Mousis tauna naira ya kawa gusugusu be Mamaitua kitanama ya nairana. ");
INSERT INTO dww_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Naumeki da Bada Mousis ya riuena, ‘Am kaḡasumama kwa kaiporaḡa, baninama gabu inam kwa midimidina, tauna doḡa babaunama. ");
INSERT INTO dww_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Taugu è kitana nema Ijipt banegidima yau banagama a raukivi gewagewa bakedina. Taugu yau banagama a yakeyakei be a ḡabaḡabana è vaiedina. Be yodi è yovona yài yawasanidina. Be yodi tam kwa verau be yà riupore nawemna Ijiptma.’ ");
INSERT INTO dww_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Naumeki nama Mamaitua ya voie da Mousis banaga ei dokedi be ei yawasanidina, baninama nama Mousis na giuma Mamaitua anea ya utena gedara nopodie. Be taudi Mousis a tuaḡaie be a riuena, ‘Tam aitau yai aninem da tauma kwai bademai bo kwai tara piriemai?’ ");
INSERT INTO dww_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Be yaḡoro tauna Ijiptma yai doka dobiḡedi be voia dosidima be mataira Ijiptma be egasi sabasabane ya voiedina. Be muriḡa modi 40 nopodie dobu kavakavane voia dosidima be mataira ya voiedina. ");
INSERT INTO dww_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Be uma Mousisnama tauna Israel banegidima ya riuedina, ‘Taumi ḡomimima ḡaromie tokare Mamaitua peroveta tenaḡa ei tubuḡina maika taugu.’ ");
INSERT INTO dww_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Be raḡanine tamatamadama taudi dobu kavakavane awai rawateḡeina, Mousis ya naḡona oya Sainai debane be anea tauna ḡarone yawasana riunama ya giuena. ");
INSERT INTO dww_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Be tamatamadama taudi nam ti voteyeteye be a tuaḡaiena. Be taudi nopodie awai nuanoḡonoḡotana da sibo a munaḡana Ijiptma. ");
INSERT INTO dww_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Be taudi Eron a riuena, ‘Kokoitau aubaimaima kwa voiedi da taudi ama mamaituama be taudi sibo ai dokemaina, baninama tauma nam ke kataiena da Mousis Ijiptma yai doka dobiḡemai be tauna aikedae ya naḡo.’ ");
INSERT INTO dww_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Dabudine taudi kokoitau a voiena kitanama maika kau natunama. Be taudi a puyo be nuedima ya vere kauana, baninama nimedie yaba ai tubiḡina aubainama. ");
INSERT INTO dww_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Be Mamaitua ya mia tautauriedi be ya voie da adi gewagewama yai rewapana be gewagewa banaga yai dokedi da gunuma kiporidima ta rauduneedina. Peroveta na bukae ya girugirumina nama: ‘Taumi Israel banegimima dobu kavakavane modi 40 koya miana. Be nopone taumi aitau aubainama tipa be puyo koya verauḡedi? Taugu aubaigu, bo? ");
INSERT INTO dww_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ibewa, taumi ami kokoitauma koya voiedi be ko rarau duneedina. Be taumi Molok na kapema koya keri be Repan na kiporama matairinama koya voie be koyai midirina. Vutuna aubainama taugu yà riuporemi be ko naḡo kwasana Babilon be murine.’ ");
INSERT INTO dww_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Dobu kavakavane tamatamadama taudi kape babaunama ḡarodie anitaparoro aubainama. Be inam kapenama babaunama tamatamadama a voiena maika Mamaitua Mousis kape aruinama yai kataiena, be ya riuena da nama sibo ya voiena. ");
INSERT INTO dww_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Naumeki da tamatamadama adi raḡanie Josua mate uma kapenama a kiroḡa saḡena raḡanine eteni adi gabuma a kwayedina. Baninama Mamaitua eteni ya tavu dobiḡedina. Be kape babaunama dabudine ya kenana naumeki da Deivid na raḡanima ya tavana. ");
INSERT INTO dww_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Be Mamaitua Deivid ḡarone ya raukiviverena, vutuna aubainama Deivid na ḡoanama da sibo Jeikob na Mamaituama na tempolma ya voiena, ");
INSERT INTO dww_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","be ibewa aubainama da Solomon tempol ya kerina Mamaitua aubainama. ");
INSERT INTO dww_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Be yaḡoro banaga vada ta kerikeridie Mamaitua saḡasaḡa vavasaḡinama nam e mia, maika boni peroveta ya riuriuna nama: ");
INSERT INTO dww_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Bada ya riuna, ‘Mara inam yau kaba miama be yau kaba waibadama be dobu inam yau kaḡamesuama, be tam vada nema maika kitanama aubaiguma kwa keri? Bo deḡo dobudine yau kaba sipere? ");
INSERT INTO dww_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Taugu uma yabedima matabudi nimague è voiedina!’ ");
INSERT INTO dww_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Taumi banaga debabadobadomima. Taumi nuenuemima be beemima madanie be nam Mamaitua ḡarone, maika eteni banegidima. Taumi raḡan matabuna Arua Babau kowai ḡakena maika tametamemima. ");
INSERT INTO dww_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ami dosima peroveta matabudi a raukivi gewegewedina. Be aitauḡa didimana baneginama na kaba verauma a giugiuena, taudi mate ai guridina. Be uma didimana baneginama vutuna taumi yodi koya boru dobiḡe be koyai gurina. ");
INSERT INTO dww_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Anea Mamaitua na tarawatuma a verauḡedina ḡaromie be taumi nam ko voteyeteyena.” ");
INSERT INTO dww_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Raḡanine umanama giudima a vaivaiena, taudi nuedima yai medi kaua be mokedima a sanadididina. ");
INSERT INTO dww_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Be Stepen noponama Arua Babau ya moḡavu be marae yai kita saḡa da Mamaitua neneḡarinama be Yesu Mamaitua kasaune ya midimidina ya kitedina, ");
INSERT INTO dww_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","be ya riuna, “Ko kita, taugu mara ya kaiporena yà kitakitana be Banaga Natunama Mamaitua kasaune e midimidina.” ");
INSERT INTO dww_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dabudine taudi arasa be beedima a viri tomdi be matabudi Stepen a puri ");
INSERT INTO dww_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","da meagai dosine be a soru dobiḡena ḡavoe. Dabudine rauyekunama ai karena. Be tauwai matamata kaikaiyovudima adi garama tauḡoma, isanama Sol, kaḡapakane ai damdi da tauna e rabedina. ");
INSERT INTO dww_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Be Stepen yekue a riḡariḡana raḡanine, tauna ya moiragi be ya riuna, “Bada Yesu, aruiguma kwa paḡo!” ");
INSERT INTO dww_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dabudine tuapikane ya beku be bonanama dosine ya riuna, “Bada, uma gewagewanama ḡarodie nam kwa noḡoti!” Nama ya riuriuna, naumeki da ya gurina. ");
INSERT INTO dww_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Be Sol ya riuna da na rauvunuḡama ya vere kauana. Inam raḡaninama teneḡine Jerusalemma raukivi gewagewa dosinama Mamaitua na damma ḡarodie ya tubuḡana. Be dabudi tauwai sumaḡa matabudi ai daberaridina Judia be Samaria nopodiḡa be apasol taudiḡa Jerusalem nopone a mia kwasana. ");
INSERT INTO dww_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tautauḡoma Mamaitua tauwai sumaḡenama taudi Stepen a dobo be a ḡaba guratena. ");
INSERT INTO dww_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Be dabudine Sol Mamaitua na damma kawa gewegewedima yai karena. Tauna vada da vada ya naḡo be tautauḡoma be waiwaivi ya soru dobiḡedi be dibure ya biridina. ");
INSERT INTO dww_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Naumeki da tauwai sumaḡa aitauḡa a dabedaberarana dobu matabuna a naḡo be Mamaitua na giuma a rauguguya nawena. ");
INSERT INTO dww_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pirip ya dobi be ya naḡona Samaria meagainama nopone, be dabudine Yesu Tauwai yawasana na kauama ya rauguguyena. ");
INSERT INTO dww_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Be tauna mataira ya voivoiedina, banaga a kitedi be na giuma ai beavaia kauena. ");
INSERT INTO dww_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Baninama arua gewegewedima banaga a gosedi be ma raserasedi a dobina. Be Pirip banaga toitoi tuera be kito ragaragaudima yai yawasanidina. ");
INSERT INTO dww_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Vutuna aubainama inam meagaine nuavere dosinama ya kenana. ");
INSERT INTO dww_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Noḡonenama tauḡoma isanama Saemon tauna ginauri meagai nopone ya voiedi be Samaria banegidima matabudi tauna a basebasena, be tauna ya seḡaseḡara munaḡena da kabe banaga dosina. ");
INSERT INTO dww_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Be banaga matabudi, banaga dosidi be banaga ḡoma, tauna awai muriwatanena, be a riuriuna, “Uma tauḡominama Mamaitua na rewapanama ḡarone, be uma rewapaninama yai rewapana vavasaḡana.” ");
INSERT INTO dww_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Be taudi awai muriwatanena, baninama Saemon na ginaurie raḡaninama daudaunama yawai basedina. ");
INSERT INTO dww_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Be raḡanine Pirip riu veredima Mamaitua na waiguyauma be Yesu Keriso ya rarau guguyedina, dabudine tautauḡoma be waiwaivi a babataitona. ");
INSERT INTO dww_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Be Saemon mate yai sumaḡa be ya babataitona. Be deḡo Pirip ya naḡonaḡona tauna yai muri watane, be mataira be voia dosidima aubaidima ya base kauedina. ");
INSERT INTO dww_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Raḡanine apasol Jerusalemma ta vaiena be Samaria banegidima Mamaitua na giuma a paḡopaḡona, naumeki da taudi Pita be Jon a riupore nawedina ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Raḡanine taudi a dobidobina, naumeki da aubaidima a moiragi da sibo Arua Babau a paḡona, ");
INSERT INTO dww_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","baninama Arua Babau yaḡoro nam aitau tenaḡa i paḡona be taudi Yesu isane a babataito ḡomana. ");
INSERT INTO dww_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Dabudine Pita be Jon nimedima debedie a biridi be banaga Arua Babau a paḡona. ");
INSERT INTO dww_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Raḡanine Saemon e kitana be apasol nimedima banaga debedie a biridi be taudi Arua a paḡopaḡona, naumeki da tauna ḡarodie mane yai yoyo be ya riuna, ");
INSERT INTO dww_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Uma rewapaninama taugu mate ko utegu da taugu nimaguma banaga debedie yà boruboruna raḡanine taudi Arua Babau ta paḡona.” ");
INSERT INTO dww_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Be Pita ya paribeena, “Tam am manema mate ko naḡo gienae, baninama tam kwa noḡonoḡoti da Mamaitua na puyoma kabe manee kwa paḡo. ");
INSERT INTO dww_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tam am gabuma uma noyanama nopone nam ima kenakenana, baninama Mamaitua matane tam nopomma nam didimanina. ");
INSERT INTO dww_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Vutuna aubainama am noḡotama kwa vitaredi be inam gewagewanama kwa kuvesa pore da Bada ḡarone kwa moiragi da tauna uma noḡotidima gewegewedima nopome e noḡota poredina, be deḡoda Bada am gewagewama e noḡota poredina. ");
INSERT INTO dww_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Baninama taugu yà kitakitamna da nopome ḡora ya moḡavu be gewagewa dosinama ya panimna.” ");
INSERT INTO dww_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Be Saemon ya paribee be ya riuna, “Bada ḡarone aubaiguma ko moiragi da uma gewegewedima giudima koya riuriueguna nam ḡarogue ta tubuḡa.” ");
INSERT INTO dww_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Raḡanine Pita be Jon Bada na giuma a rarau guguya kovina, taudi a munaḡana Jerusalemma. Be kedae taudi riu verenama a rauguguyedina Samaria meagaidima nopodiḡa. ");
INSERT INTO dww_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bada na aneama Pirip ya riuena, “Kwa midisuḡu be yavaragwae yauwanine kwa naḡo. Kwa naḡo keda Jerusalemma be Gasama naḡonaḡonama dabudi kwa dobi! Uma kedanama inam mutuyuae be banaga nam tima miamiana.” ");
INSERT INTO dww_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Naumeki tauna ya midisuḡu be ya naḡo be kedae tauna Itiopia baneginama ya banavina. Uma baneginama tauna tauḡoma kaikaivainama be tauna banaga dosinama be Kandake na manema taurabenama. Kandake tauna Itiopia banegidima adi guyauma waivinama. Inam tauḡominama kaikaivainama Mamaitua rauduneenama aubainama Jerusalemma ya naḡona, ");
INSERT INTO dww_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","be yodi tauna ya munamunaḡana na dobue. Tauna na tureirama debane ya mia be peroveta Aisaia na bukama ya siesievina. ");
INSERT INTO dww_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Be Arua Pirip ya riuena, “Kwa naḡo be noa seroitnama dianaḡa kwai naḡonaḡo.” ");
INSERT INTO dww_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Dabudine Pirip ya manini ya naḡo tureira diane be e vaiena be tauḡoma peroveta Aisaia na bukama ya siesievi be Pirip tauḡoma yai taravirena, “Aba kwa siesievina kwa katakataie bo ibewa?” ");
INSERT INTO dww_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Be tauḡoma ya paribeena, “Ibewa, nema yà katai bake deḡoda banaga nam aitau e giu waibategu?” Vutuna aubainama tauna Pirip ya riue da tureira debane ya saḡa be diane ya miana. ");
INSERT INTO dww_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Be tauḡoma girugiruminama poranama girugiruminama ya siesievina mudu gabunama umanama ya riuna: ‘Banaga tauna ai doka nawena waigurinama aubainama maika sipu tawai doka nawedina adi kaba waiguridima gabune. Be nema sipu natunama deba vuvuḡinama ta tom be ewai nuatuḡutuḡuna, nama tauna yai nuatuḡutuḡuna. ");
INSERT INTO dww_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Be banaga tauna a raukivi gewegewe be a boru yovoḡa vavasaḡena. Be raḡanine tauna ya yovoyovo vavasaḡana Mamaitua ya kaisagu be na yawasanama dobue ya kaipore be ya nawena. Be yodi nam aitau teneteneḡina da natunatunama e sievidi.’ ");
INSERT INTO dww_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tauḡoma kaikaivainama Pirip yai taravirena, “Kwa riuegu peroveta aitau e giugiue? Taunaḡa e giugiu munaḡe, bo aitau?” ");
INSERT INTO dww_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dabudine Pirip giu yai kare be tauḡoma kaikaivainama Aisaia na bukama ya siesievina nopone dabudine yai kare be Yesu varinama verenama ya ya giu waibatena. ");
INSERT INTO dww_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Naumeki da taudi a naḡonaḡo da upae a tavana, be dabudine tauḡoma kaikaivainama ya riuna, “Kwa kita upa umanema. Naumeki bo ibewa da sibo è babataito?” ");
INSERT INTO dww_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Be Pirip ya riuena, “Deḡoda tam nuamma tabutabune kwai sumaḡana, inam naumeki.” Be tauḡoma kaikaivainama ya paribee be ya riuna, “Taugu yàwai sumaḡana da Yesu Tauwai yawasana tauna naumeki Mamaitua Natunama.” ");
INSERT INTO dww_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Naumeki da tauḡoma kaikaivainama tureira ya riutuaḡaie da ya midi kwasana, be dabudine tauna be Pilip a naḡona upae, be Pirip tauḡoma yai babataitona. ");
INSERT INTO dww_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Raḡanine taudi upae be a tavatava munaḡana Bada Aruinama yai raḡantenaḡe da Pirip ya nawena. Naumeki tauḡoma kaikaivainama nam Pirip i kita munaḡena, be tauna ma mosarine ya naḡona. ");
INSERT INTO dww_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Naumeki da Pirip Asdod meagaine ya maḡatara be tauna meagai matabudi nopodiḡa ya babara naḡo be vari verenama ya rarau guguyena, naumeki da Seseriama ya tavana. ");
INSERT INTO dww_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Inam raḡaninama teneḡine Sol yaḡoro nuanama yai medi kaua be ya riuna da Bada na tauwai muriwatanama ei guridina. Vutuna aubainama tauna ya naḡo pirisi adi badama ḡarone ");
INSERT INTO dww_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","be yai baḡana da pirisi adi badama leta sibo ya girumidina sinagog Damaskasma aubaidima da sinagog banegidima sibo Sol a sagu be Yesu na kauama tauwai muriwatanenama, tautauḡomidi be waiwaividima a banavidi da sibo a vunuḡidi, a panidi be muriḡa Sol sibo ya verauḡedina Jerusalemma. ");
INSERT INTO dww_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Raḡanine Sol Damaskas meagainama diane ya tavatavana, yana marae yai raḡantenaḡe be ");
INSERT INTO dww_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","yai yana kwa vivirona be dabudine ya beku da doḡae ya ravuse da e vaiena be bona marae ya riuna, “Sol, Sol, aba aubainama kwa raraukivi gewegewegu?” ");
INSERT INTO dww_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol yai taravirana, “Tam aitau, Bada?” be Yesu ya paribeena, “Taugu Yesu vutuna kwa raraukivi gewegeweguna. ");
INSERT INTO dww_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yodi kwa midisuḡu be kwa naḡona meagaie, be dabudine ta riuem da aba kwa voiena.” ");
INSERT INTO dww_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tautauḡoma Sol mate naḡonaḡodima, dabudine a midi be ai nuadau kwasana, baninama taudi bona a vaiena be nam aitau ti kitana. ");
INSERT INTO dww_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Naumeki Sol ya midisuḡu munaḡa da sibo yai kitana be matanama yai kupikupi da nam aba i kita. Naumeki da nimane a kaididi nawena Damaskasma. ");
INSERT INTO dww_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Be ma matapotapotana, nama ya miana raḡan rabuiteḡa be tauna nam aiyaba i kani bo i tego rubuna. ");
INSERT INTO dww_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskas nopone tauwai muriwatana tauḡoma tenaḡa isanama Ananaias ya miamiana. Be Bada ya maḡatara da ya yoko be ya riuna, “Ananaias!” Be tauna ya riuna, “Bada, taugu umanema.” ");
INSERT INTO dww_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Be Bada ya riuena, “Kwa midisuḡu be kwa naḡo keda tawai isana ‘Keda-Didimana’. Be kwa naḡona Judas na vadae be dabudine Tasus tauḡominama isanama ‘Sol’ kwa wanena. Tauna dabudine e moimoiragina, ");
INSERT INTO dww_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","be matane rauboni ya kitana da tauḡoma isanama ‘Ananaias’ vadae ya saḡana, be nimanama debane ya biridina da tauna matapotapotanama kabe iwai kita munaḡa.” ");
INSERT INTO dww_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dabudine Ananaias ya paribee be ya riuna, “Bada, uma tauḡominama na kauama toitoi è vaiedina, da tauna voia gewegewedima toitoi ya voiedina am banagama Jerusalemma ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Be yodi pirisi adi babadama rewapana a ute be uma dabudine tauna ya tavana da aitauḡa tam isame tawai sumaḡana sibo ya vunuḡidi be ya panidina.” ");
INSERT INTO dww_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Be Bada ya riuena, “Kwa naḡo, baninama uma tauḡominama è vinena yau noyama anivoienama, da tauna isaguma e kiroḡi be ei babarina eteni banegidima, guyaguyau be Israel banegidima ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Be taugu yài kataina da tauna nema ei nuatoitoi bakona, taugu isaguma aubainama.” ");
INSERT INTO dww_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dabudine Ananaias ya naḡo da vadae ya saḡa be nimanama Sol debane ya sivudi be ya riuna, “Tuai Sol, Bada Yesu, vutuna kedae ya maḡatarana raḡanine, tam uma dobudine kuya veraverauna, tauna ya riuporeguna ḡarome da tam kwai kita munaḡa be Arua Babau nopomma ei moḡavumna.” ");
INSERT INTO dww_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Be yai raḡantenaḡe da yaba kitanama maika kabe iyana veveḡinama matane i bekubeku, dabudine be yai kita munaḡana. Naumeki da Sol ya midisuḡu be ai babataitona. ");
INSERT INTO dww_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tauna ya kanikanina, dabudine tuninama ya bagibagi munaḡana. Sol tauwai muriwatana mate Damaskasma raḡan bisanama a taumiana. ");
INSERT INTO dww_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Be dabudine tauna synagog nopodie rauguguya yai karena da Yesu tauna Mamaitua Natunama. ");
INSERT INTO dww_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Be aitauḡa dabudine tauna a vaivaiena, taudi a nuababaḡa be ai taravirana, “Uma tauḡominama vutuna kabe tauwai sumaḡa Jerusalem nopone i vunuvunuḡidi? Be uma dabudine ya tavana da tauwai sumaḡa kabe e panidi be e verauḡedi pirisi adi babadama ḡarodie.” ");
INSERT INTO dww_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Naumeki da Sol na rauguguyama yawai rewapana be tauna Jius banegidima Damaskasma miemienidima ya tainuababaḡidina, baninama tauna yai kataidi da Yesu tauna Tauwai yawasana, be taudi nam teneteneḡidi da sibo a riuḡare munaḡe. ");
INSERT INTO dww_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Raḡan toitoi muridie be Jius banegidima ai rawateḡeidi be oga a taraḡina da Sol sibo ai gurina. ");
INSERT INTO dww_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Be Sol adi ogama ya vaiena. Be taudi kupi da suara meagai ganaganakukunama kededima matedie a bodabodamana da Sol sibo a vunuḡi be ai gurina. ");
INSERT INTO dww_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Be kupi tenaḡa tauwai muriwatana taudi Sol siriga nopone a boru be garigari bogane gaure ai dawe dobiḡena. ");
INSERT INTO dww_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Raḡanine Sol ya naḡona Jerusalemma be e raurubuna da Yesu tauwai muriwatanenama sibo ya rawakapudina, be taudi matabudi Sol a naire be nam ti sumaḡena da tauna tauwai muriwatana. ");
INSERT INTO dww_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Be Banabas tauna Sol yai doka saḡena apasol ḡarodie be na gututuma ya riuedi da nema kedae tauna Bada Yesu ya kita be mate ai giuna. Be muriḡa tauna Damaskasma Yesu isane nam ma nairina i rauguguyana. ");
INSERT INTO dww_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dabudine taudi Sol mate Jerusalemma a miana be ma raudebatorana Bada Yesu isanama ya rarau guguyena. ");
INSERT INTO dww_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Be tauna Jius banegidima Gurik bonane taugiunama mate a giu be ai saḡasaḡana. Be taudi a ḡoeḡoena da sibo Sol ai gurina. ");
INSERT INTO dww_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Be raḡanine tauwai sumaḡa nama a vaivaiena, taudi Sol ai doka dobiḡena Seseriama be dabudine a riupore nawena Tasusma. ");
INSERT INTO dww_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Naumeki da dabudine Mamaitua na damma, Judia, Galili be Samaria nopodiḡa ḡarodie suba ya kenana. Be taudi ai rewapana be a miana Mamaitua a vivivivirena. Be Mamaitua na damma sievinama ya moramorabana, baninama Arua Babau ya duḡudina. ");
INSERT INTO dww_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita dobu matabuna ya babababara naḡona. Raḡan tenaḡa tauna ya naḡona Lidama, banaga babaudima vakitedima aubainama. ");
INSERT INTO dww_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Dabudine tauna tauḡoma isanama Aneas ya banavina. Inam tauḡominama tuera ya paḡo be na kaba kenae ya kenana modi sievinama 8 a kovina. ");
INSERT INTO dww_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Be Pita ya riuena, “Aneas! Yesu Keriso ewai yawasanimna. Kwa midisuḡu be am gunima kwa nokudi.” Naumeki da tauna waiḡapa ya midisuḡuna. ");
INSERT INTO dww_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Be Lida be Saron banegidima matabudi Aneas a kitakitana, naumeki da nuedima a vitarena Bada ḡarone. ");
INSERT INTO dww_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa meagaine tauwai muriwatana waivinama tenaḡa isanama Tabita ya miamiana. Tauna isanama Gurik bonane a vitare da Dokas. Tauna raḡan matabuna vere ya voivoiedina, be banaga waikaruwaḡewaḡedima ya sagusagudina. ");
INSERT INTO dww_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Raḡan tenaḡa tauna ya sida be ya gurina. Naumeki da banaga ḡesaudima tubuḡinama a koḡana, baninama adi vaivaima nama. Be vada vatavatara rabui nopone be debane vatarine a boruna. ");
INSERT INTO dww_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa tauna Lida meagainama diane. Be raḡanine tauwai muriwatana ta vaiena be Pita tauna Lidama, naumeki da taudi tautauḡoma rabui a riuporedina, be taudi Pita ai baḡa be a riuena, “Naumeki bo ibewa da tam yodi sibo kuya verauna ama meagaie” ");
INSERT INTO dww_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Naumeki da Pita ya midisuḡu be taudi mate a naḡona. Raḡanine tauna dabudi ya tavatavana, taudi Pita ai doka saḡena debane vatarine. Be kaiyababa matabudi ma ḡabeḡabedi Pita ḡarone a tava, be kwama be gara, Dokas ya popopopodina ai kataina raḡanine, tauna ma mienina. ");
INSERT INTO dww_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Dabudine Pita matabudi ya tavu dobiḡedi be tuapikane ya raupari be ya moiragina. Naumeki da tauna guri ḡarone yai tauvitare be ya riuna, “Tabita, kwa midisuḡu!” Dabudine matanama yai kita be Pita ya kitakitana raḡanine, tauna ya midisuḡu be ya miana. ");
INSERT INTO dww_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nimane ya kaididi be ya soru waimidisuḡuna. Be muriḡa Pita banaga babaudima be kaiyababa ya yokoedi da Tabita yawayawasaninama ḡarodie ya verauḡena. ");
INSERT INTO dww_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Inam kauinama Jopa nopone banaga matabudi a vaiena, be banaga toitoi Bada ḡarone ai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Be Pita Jopama ya miana raḡan toitoi Saemon mate. Saemon tauna musara kopidima taukwaridima. ");
INSERT INTO dww_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Seseria meagainama nopone Rom tauḡoma isanama Konilias ya miamiana. Tauna iḡeiḡeridima adi debama awai isana ‘Itali Deba’ adi torima matanama. ");
INSERT INTO dww_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tauna na sedama mate yawasana verene a miana banaga Mamaitua tauwai sumaḡenama maika. Tauna banaga waikaruwaḡewaḡedima ya sagusagu kauedi be raḡan matabuna Mamaitua ḡarone ya moimoiragina. ");
INSERT INTO dww_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Raḡan tenaḡa 3 okorokinama, be tauna Mamaitua na aneama matane ya kitana kabe raubonie i kitakita, be anea ya saḡa be ya riuena, “Konilias!” ");
INSERT INTO dww_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias ma nairina ya kita kwase be ya riuna, “Bada, aiyaba?” Be anea tauna ya riuena, “Am moiragi be am waisaguma waikaruwaḡawaḡa banegidima ḡarodie Mamaitua nam nuanama i koana. ");
INSERT INTO dww_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Be yodi tautauḡoma ḡesaudima kwa riuporaḡa nawedina Jopama be Saemon tawai isaisana Pita tai doka verauḡena. ");
INSERT INTO dww_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tauna Saemon musara kopidima taukwaridima mate ta miamiana, tauna na vadama egasi diane.” ");
INSERT INTO dww_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Raḡanine anea na giuma ya kovikovina, naumeki da ya naḡona. Dabudine Konilias na taunoyama rabui be na tauiḡarama tenaḡa ya riupore nawedina Pita ḡarone. Be uma tauiḡerinama na yawasanama verene ya miamiana banaga Mamaitua tauwai sumaḡenama maika. ");
INSERT INTO dww_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Inam dabudine Konilias yaba matabuna ya tubutubuḡana yai varidi be ya riupore nawedina Jopama. ");
INSERT INTO dww_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pomainama suaratopu be taudi meagai diane a tavatavana maika, Pita ya naḡona vada debane moiragi aubainama. ");
INSERT INTO dww_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dabudine tauna kani ya karati be ya ḡoeḡoena da sibo aiyaba ya kani. Be raḡanine tauna na kanima vadae a vovo kaukauena maika, tauna yaba matane ya kitana kabe raubonie i kitakita. ");
INSERT INTO dww_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tauna e kitana be mara kedanama ya nuaporaḡa be yaba kitanama maika rupu dosinama kawa susunama matabudi 4, kawa susudie a ragaudi be awai dawe dobiḡena dobue, ya kitana. ");
INSERT INTO dww_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Be inam rupunama nopone dobu museridima tabu be tabu a miamiana. Musara kaḡedima 4, musara daredaredima be kiu. ");
INSERT INTO dww_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dabudine bona ya riuena, “Pita, kwa midisuḡu, inam museridima kwai guridi be kwa kanidi!” ");
INSERT INTO dww_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Be Pita ya paribeena, “Ibewa Bada, nam teneteneḡina! Baninama inam museridima tauma ama waiyawama be nam airaḡan taugu yaba yau waiyawama e kani rubuna.” ");
INSERT INTO dww_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dabudine bona aniwai rabuinama ya riu munaḡana, “Deḡo yabanama Mamaitua ya riuna da am waiyawama be yodi e riuriuna da nam am waiyawa, vutuna aubainama tam nam kwa riuna ‘yau waiyawa’.” ");
INSERT INTO dww_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Uma kauinama raḡan rabuiteḡa nama ya tubuḡana, muriḡa be rupu a paḡo nawena marae. ");
INSERT INTO dww_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Raḡanine Pita uma kauinama ya kitakitana, yaḡoro baninama yawai nuanoḡonoḡote be tautauḡoma Konilias ya riuriuporedina, taudi Saemon na vadama a banavi be matakedae vada noḡone a midina. ");
INSERT INTO dww_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Taudi a riu rubu be ai taravira da Saemon awai isaisana Pita dobudine e miamia bo ibewa. ");
INSERT INTO dww_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita mataḡomine rauboni ya kitakitana, baninama yaḡoro yawai nuanoḡonoḡote be Arua ya riuena, “Saemon, tautauḡoma rabuiteḡa tam konorimma a tavana, ");
INSERT INTO dww_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","vutuna aubainama kwa midisuḡu, kwa dobi kwa naḡo be taudi mate ko naḡona, be nam kwa noḡota bekubeku, baninama taugu è riuporedina.” ");
INSERT INTO dww_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita ya dobi be tautauḡoma ya riuedi, “Taugu vutuna ko wanewaneguna, aba aubainama koya verau?” ");
INSERT INTO dww_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Dabudine tautauḡoma a paribee be a riuna, “Tauma banaga iḡeiḡeridima adi torima matanama, isanama Konilias ḡarone be kè verauna. Tauna banaga didimanae be Mamaitua tauvivirenama be Jius banegidima matabudi tauna ta vivivivirena. Be anea babau ya riuena da tauna tam sibo yai doka nawem na vadae be aba sibo kuya giue da tauna ya vaiena.” ");
INSERT INTO dww_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Naumeki da Pita tautauḡoma yai doka saḡedi vadae, kani ya utedi be dabudi a kenana. Be pomainama Pita ya midisuḡu be tautauḡoma mate a naḡona. Be tuatuaḡanama ḡesaudima Jopama mate a naḡona. ");
INSERT INTO dww_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Be mainokomḡo raḡanine taudi Seseriama a tavana. Be Konilias na damma be na banaga kauama ya rawateḡeidi da awai raba be Pita na banagama mate a tavana. ");
INSERT INTO dww_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Raḡanine Pita vada nopone ya saḡasaḡana, Konilias ya naḡo bode da kaḡane ya beku be ya rauduneena. ");
INSERT INTO dww_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Be Pita ya soru waimidisuḡu be ya riuena, “Kwa midisuḡu taugu banaga ḡoma maika tam.” ");
INSERT INTO dww_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Dabudine Pita Konilias rabuina vada noponaḡa a giugiu naḡona, be banaga toitoi Pita a miamia rabena, ya banavidina. ");
INSERT INTO dww_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Be Pita ya riuedina, “Taumi koya kataiena da Jius banegidima nam teneteneḡina da eteni banegidima mate tai rawateḡeidi bo ta vakitekitedi. Be yodi Mamaitua yai kataigu da tauna banaga matabuna nuanama e paḡopaḡona, be nam Jius taudiḡa. Vutuna aubainama taugu nam yà riuna banaga ḡesaudima kamai banabanaga. ");
INSERT INTO dww_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Vutuna aubainama raḡanine tam yau riuma kuya riuporena, taugu nam nuaguma i raḡaraḡana, be naumeki da è verauna. Be yodi yài taraviremna: Aba aubainama kuya riuegu da è verau?” ");
INSERT INTO dww_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dabudine Konilias ya paribee be ya riuna, “Raḡan 4 a kovina taugu yau vadae è mia be suara 3 okorokinama taugu è moimoiragina. Be yai raḡantenaḡe da tauḡoma na garama waimatakanikaninama noḡogue ya midi ");
INSERT INTO dww_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","be ya riuna, ‘Konilias! Mamaitua am moiragima ya vaiena be am waisaguma waikaruwaḡawaḡa banegidima ḡarodie Mamaitua nuanama nam i koana. ");
INSERT INTO dww_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Be yodi tautauḡoma ḡesaudima kwa riuporaḡa nawedina Jopama be Saemon tawai isaisana Pita tai doka verauḡena. Tauna Saemon musara kopidima taukwaridima mate ta miamiana, tauna na vadama egasi diane.’ ");
INSERT INTO dww_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Vutuna aubainama taugu am riuma waiḡapa è riuporena be ya vere kauana da tam kuya verauna. Be yodi tauma matabumai kèi rawateḡeimaina, Mamaitua matane be kawai rabana da aba Bada ya riuriuemna kwa giue da ka vaiena.” ");
INSERT INTO dww_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dabudine Pita giu yai karena, “Yodi taugu è katai kauena da Mamaitua banaga matabuna nuanama e paḡopaḡona, be nam Jius taudaḡa. ");
INSERT INTO dww_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Be banaga aitauḡa dobu matabuna Mamaitua ta vivivivire be voia didimanidima ta voivoiedina, taudi Mamaitua ewai aninedina. ");
INSERT INTO dww_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Taumi kaite koya kataiena da Mamaitua riu ya riuporena Israel banegidima ḡarodie da tauna suba ya voiena. Be uma riunama, vari verenama Yesu Keriso ya rauguguyena. Be Yesu banaga be yaba matabuna ewai badedina. ");
INSERT INTO dww_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Be uma kauidima Judiama a tubuḡana, be taudi Galilima ai karena Jon na rauguguyama be na waibabataitoma raḡaninama murine. ");
INSERT INTO dww_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Inam raḡanine Mamaitua Arua Babau be rewapana, Nasaret Yesunama ḡarone ya ḡini porena. Dabudine Yesu ya babara naḡo be voia veredima ya voivoiedina be banaga aitauḡa Diaboro yawai badedina naumeki Yesu yai yawasanidina, baninama Mamaitua tauna ḡarone. ");
INSERT INTO dww_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Be Yesu yaba matabuna Jius adi dobue be Jerusalem nopone ya voivoiedina, tauma adi matamatama. Be tauna vutuna Korosi bogane ai dawe be ai gurina. ");
INSERT INTO dww_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Be Mamaitua raḡan aniwai rabuiteḡane gurie ya kawa midisuḡu munaḡe be ya kawa maḡatarina banaga ḡarodie da a kitana. ");
INSERT INTO dww_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Be nam banaga matabudi ti kitana, be tauwai matamata aitauḡa Mamaitua noḡone ya vinevinedina, taudiḡa a kitana. Be uma banegidima Mamaitua ya vinevinedina inam tauma. Be tauna gurie ya midisuḡu munaḡa be murine tauma tauna mate kè kani be kè tegona. ");
INSERT INTO dww_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Be tauna ya riu vavasaḡemaina da tauma banaga ḡarodie ka rauguguya be ka riuedi da tauma kè katai kauena da tauna banaga yawai yawasanidi be guriguridima adi taurau etarama. ");
INSERT INTO dww_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Peroveta matabudi tauna a giugiuena da tauna vutuna, aitau Yesu isane tawai sumaḡana, tokare Mamaitua adi gewagewama e noḡota porena Yesu isane.” ");
INSERT INTO dww_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Raḡanine Pita yaḡoro umanama ya giugiuna, Arua Babau ya yovona taudi aitauḡa dabudi awai beavaiana ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Be Jius nopone aitauḡa tauwai sumaḡa banegidima Pita mate a veraverauna, taudi a base kauena baninama Mamaitua puyo Arua Babau eteni banegidima ḡarodie ya ḡini porena. ");
INSERT INTO dww_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Taudi a vaie da inam dabudine eteni banegidima bona ḡesaudima nam adi kaba kataiedi a giugiuedi be Mamaitua isanama a kaikai suḡusuḡuna. Dabudine Pita ya riuna, ");
INSERT INTO dww_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Taugu è noḡotina da uma banegidima sibo upae tèi babataitodina be nam aitau e riutuaḡaiedi, baninama taudi kaite Arua Babau a paḡona maika tauda.” ");
INSERT INTO dww_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Vutuna aubainama Pita ya riuna da taudi Yesu Keriso isane sibo ai babataitodina. Naumeki da taudi Pita ai baḡana da tauna taudi mate sibo a taumiana raḡan bisanama. ");
INSERT INTO dww_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apasol be tauwai sumaḡa matabudi Judia nopone ta vaiena be eteni banegidima mate Mamaitua riunama a paḡona. ");
INSERT INTO dww_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Be Pita Jerusalemma ya tavana raḡanine, Jius nopodie aitauḡa tauwai sumaḡa banegidima taudi Pita mate ai saḡasaḡa ");
INSERT INTO dww_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","be a riuna, “Tam aba aubainama kuya naḡo eteni banegidima adi vadae be mate koya kanikani?” ");
INSERT INTO dww_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dabudine Pita yaba matabuna ya tubutubuḡana ya giu yaḡedi be ya riuna, ");
INSERT INTO dww_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Taugu Jopa meagaine è moimoiragi be rauboni mata ḡomae kitakitanama è kitana. Taugu marae yaba kitanama maika rupu dosinama è kitana. Be inam rupunama kawasusune a ragaudi be ai dawe dobiḡena noḡo ḡomigue. ");
INSERT INTO dww_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Taugu rupu yà kitana be nopone dobu museridima tabu be tabu a miamiana, musara yosiyosi, dobira museridima, musara daredaredima be kiu. ");
INSERT INTO dww_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dabudine taugu bona è vaie be ya riuna, ‘Pita, kwa midisuḡu, kwai guridi be kwa kanidi!’ ");
INSERT INTO dww_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Be taugu è paribeena, ‘Ibewa Bada, nam teneteneḡina! Baninama inam museridima tauma ama waiyawama be nam airaḡan taugu yaba yau waiyawama e kani rubuna.’ ");
INSERT INTO dww_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dabudine bona marae aniwai rabuinama ya riu munaḡana, ‘Deḡo yabanama Mamaitua ya riuna da am waiyawama be yodi e riuriuna da nam am waiyawa, vutuna aubainama tam nam kwa riuna ‘yau waiyawa’.’ ");
INSERT INTO dww_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Uma kauinama raḡan rabuiteḡa nama a tubuḡana, muriḡa be matabuna a paḡo nawena marae. ");
INSERT INTO dww_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Naumeki be tautauḡoma rabuiteḡa inam vadane deḡo taugu è miamiae a tavana. Be taudi inam Seseriama be a riupore verauḡedina ḡarogue. ");
INSERT INTO dww_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Be Arua ya riueguna, ‘Nam kwa noḡota bekubeku be taudi mate ko naḡo!’ Naumeki be taugu inam tautauḡomidima 6 mate kè naḡo be Konilias na vadae kè saḡana. ");
INSERT INTO dww_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Be dabudine tauna ya riuemaina da anea ya kitana, na vadae ya midimidina be anea tauna ya riuena, ‘Tautauḡoma ḡesaudima kwa riuporaḡa nawedina Jopama, be Saemon tawai isaisana Pita tai doka verauḡena. ");
INSERT INTO dww_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tauna riu e verauḡe be inam riune tam am vadama banegidima mate ko yawasanana.’ ");
INSERT INTO dww_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Raḡanine taugu giu èwai karena, Arua Babau ḡarodie ya yovona maika dokane Pentekost raḡanine tauda ḡarode ya yovoyovona nama. ");
INSERT INTO dww_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Dabudine Bada aba ya riuriuena è noḡotina, ‘Jon tauna upae yai babataitona be taumi tokare Arua Babaue ko babataitona.’ ");
INSERT INTO dww_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Vutuna aubainama deḡoda Mamaitua eteni banegidima puyo teneḡinama ya utedina, maika tauda ya uteutedana nama, baninama Bada Yesu Tauwai yawasana tèwai sumaḡena aubainama, naumeki da taugu nam teneteneḡina da Mamaitua yài ḡake.” ");
INSERT INTO dww_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Raḡanine Jius nopone aitauḡa tauwai sumaḡa banegidima umanama a vaivaiena, naumeki da adi waisaḡasaḡama dabudi ya kovi be Mamaitua isanama a kaisuḡu be a riuna, “Riukaua, Mamaitua eteni banegidima mate ya voiedi da ta noḡota vitara be yawasana ta paḡona.” ");
INSERT INTO dww_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Raḡanine Stepen awai gurina, tauwai sumaḡa ḡesaudima raukivigewegewedima ai kare be toitoi a daberara be ai naḡo teḡeteḡedina Ponitia, Saipras be Antiok paratidima. Be dabudine taudi riu verenama Jius taudiḡa ai varidina. ");
INSERT INTO dww_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Be ḡesaudima, Saipras be Sairin tautauḡomidima taudi a naḡona Antiokma be dabudine taudi eteni banegidima mate ḡarodie Bada Yesu varinama verenama a rauguguyena. ");
INSERT INTO dww_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Be taudi Bada na rewapanae banaga sievidima toitoi ai sumaḡa be nuedima a vitarena Bada ḡarone. ");
INSERT INTO dww_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Uma varinama Mamaitua na damma matabudi Jerusalemma a vaiena, vutuna aubainama taudi Banabas a riuporena Antiokma. ");
INSERT INTO dww_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Raḡanine Antiokma ya tavatavana tauna Mamaitua na wainuapaḡoma votanama ya kita be nuanama ya vere kauana. Be tauna ya duḡudi da taudi sibo Bada mate a miana nuedima tabutabune. ");
INSERT INTO dww_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas tauna banaga verenama, be tauna noponama Arua Babau be waisumaḡa ya moḡavuna, vutuna aubainama tauna banaga toitoi ya verauḡedina Bada ḡarone. ");
INSERT INTO dww_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dabudine tauna ya naḡona Tasusma, Sol wanenama aubainama. ");
INSERT INTO dww_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Be raḡanine ya banabanavina, tauna yai doka verauḡena Antiokma. Naumeki da modi tabutabunama taudi rabuidi Mamaitua na damma mate Antiokma a mia, be banaga toitoi awai katakataidina. Inam raḡanine tauwai muriwatana Antiokma ai isedina ‘Kuristen banegidima.’ ");
INSERT INTO dww_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Inam raḡandie peroveta ḡesaudima Jerusalemma be a yovona Antiokma. ");
INSERT INTO dww_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Be poudie tenaḡa isanama Agabas, tauna ya midisuḡu be Arua Babaue ya riuna da tokare dobu matabuna meiḡara dosinama e tubuḡana. Naumeki da Klaudias na waibadama raḡanine meiḡara ya tavana. ");
INSERT INTO dww_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Vutuna aubainama Kuristen matabudi Antiokma ai oga da taudi sibo tauwai sumaḡa Judiama a sagudina. Be tauwai muriwatana tenatenaḡaḡa sibo a kaigurate da sibo ai saguna. ");
INSERT INTO dww_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Naumeki da nama a voiana be adi puyoma Banabas be Sol a utedi da a ragau nawedina Jerusalemma, tauwai sumaḡa babadidima ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Inam raḡanine nama guyau Herod tauwai sumaḡa ḡesaudima ya vunuḡidi be ya raukivi gewegewedina. ");
INSERT INTO dww_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tauna Jon tuaḡanama Jeims kwatikwatie yai gurina. ");
INSERT INTO dww_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Be raḡanine Herod e kitana be Jius nuedima ya vere kauana tauna na voiama aubainama, vutuna aubainama Pita mate ya vunuḡi be ya panina. Uma kauinama Buredi-Nam-Sasanina soinama nopone ya tubuḡana. ");
INSERT INTO dww_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Naumeki da Herod Pita ya pani da dibure ya boru, yodibe banaga 16 ya riupore nawedi da taudi sibo Pita a kita watanina. Be Herod na ogama ya tarataraḡina da Naḡopore soinama murine tauna sibo Pita ya dobiḡe patare da sibo ya etarena. ");
INSERT INTO dww_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Naumeki da Pita dibure a rabena, be Mamaitua na damma tauna aubainama Mamaitua ḡarone a moimoiragina. ");
INSERT INTO dww_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pomainama sibo Herod Pita ya dobiḡena etarenama aubainama be manakanama kupine Pita banaga iḡeiḡeridima rabui poudie ya kenakenana. Be tauna seini rabui a raupaniedina, tenaḡa kasaune be tenaḡa senine. Be inam seinidima teneḡidie isudima banaga iḡeiḡeridima nimedie a panidina. Be dibura matakedane taubodama a midimidina. ");
INSERT INTO dww_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Be yai raḡantenaḡe da Bada na aneama ya raumidire be Pita na kaba kenama dobunama ya yanana. Be tauna Pita girigirinama ya riḡa da ya taiḡosori be ya riuena, “Kwa midisuḡu makai!” Naumeki be seinidima nimane a nuaporaḡana. ");
INSERT INTO dww_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Dabudine anea ya riuena, “Am gara be am kaḡasumama kwa kotedi!” Be Pita nama ya voiena. Dabudine anea ya riuena, “Yodi am kwamama kwa kote be kwai muriwatanegu!” ");
INSERT INTO dww_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Naumeki be Pita anea yai muriwatane be dibura a dobi porena. Be tauna nam i kataiena da aba anea ya voivoiana, naumeki baniḡominama vutuna ya tubutubuḡana, be tauna yai noḡotana kabe rauboni matae kitakitanama i kitakita. ");
INSERT INTO dww_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Taudi taubodama noḡone be murine ai muridi be a dobina meagai kedanama matane, matakeda irama boruborune a dobi be matakeda mabine ya nuaporaḡa be anea Pita mate ḡavoe a dobi be kedaḡa a naḡonaḡo be anea yai raḡantenaḡe da Pita ya gosena. ");
INSERT INTO dww_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Be raḡanine Pita na noḡotama ya tava munaḡana, tauna ya riuna, “Yodi è katai kauena da riukaua. Bada na aneama ya riuporena da taugu Herod na rewapanae be Jius adi ogama gewegewedie yai yawasaniguna.” ");
INSERT INTO dww_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Naumeki da tauna na noḡotama ya yana, be ya naḡona Meri na vadae. Meri, tauna Jon tawai isaisana Mak tinanama, be banaga toitoi na vadae ai rawateḡeidi be a moimoiragina. ");
INSERT INTO dww_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Naumeki da Pita matakedae ya raupewapewa be taunoya waivinama isanama Roda, tauna matakeda kaiporenama aubainama ya verauna. ");
INSERT INTO dww_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Be raḡanine Pita bonanama ya vaivaiena, tauna nuanama ya vere kaua be matakeda kaiporenama nuanama ya koa be ya manini ya munaḡa be ya riuna, “Pita matakedae e midimidina”. ");
INSERT INTO dww_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Be taudi a riuena, “Tam kuya bua, bo?” Be tauna ya riu raukosoḡaiḡaina, aubainama taudi a riuna, “Agunai Pita keyaunama.” ");
INSERT INTO dww_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Be Pita yaḡoro ya rarau pewapewana. Dabudine taudi matakeda a kaipore, be Pita ta kitana be nuedima ya mosarina. ");
INSERT INTO dww_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Be Pita nimane ya raukati tawedina da sibo ai nuatuḡuna. Dabudine tauna, nema Bada dibure be ya dobiḡa bakena ya gututuena. Be ya riuna, “Uma kauinama Jeims be tuatuaḡanama ḡesaudima mate koi varidi!” Naumeki da tauna ya dobi munaḡa be wari kedae ya naḡona. ");
INSERT INTO dww_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Raḡanboiboi taubodama a nuababaḡa be nuedima ya rovo be a riuna, “Pita nema ya bako?” ");
INSERT INTO dww_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Be Herod ya ḡoeḡoedina sibo Pita a nawena ḡarone, taudi nam ti banavina. Vutuna aubainama tauna taubodama yai taravireviredi, be dabudine tauna banaga ḡesaudima ya riuedi da taudi taubodama tai guridina. Dabudine Herod Judia ya gose be ya naḡona Seseriama, be dabudine ya miana. ");
INSERT INTO dww_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Be Herod tauna Taiya be Saidon banegidima ḡarodie nuanama yai medi kaua. Vutuna aubainama taudi adi babadama a riuporedina Herod ḡarone. Be taudi Herod na vadama taurabenama, isanama Blastas ai turane be a riuena da tauna guyau Herod ya riue da tauna sibo suba ya voiena, baninama taudi inam guyaunama na dobue kani sibo a paḡopaḡona. ");
INSERT INTO dww_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Vutuna aubainama Herod raḡan ya vine da deḡo raḡanine sibo patara ḡarodie sibo ya giuna. Naumeki da tauna na waiguyauma garedima ya kotedi be na kaba miae ya mia, be na giuma yai karena. ");
INSERT INTO dww_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na giuma poune be banaga bonedima dosine a riuna, “Inam mamaitua bonanama, nam banaga ḡoma!” ");
INSERT INTO dww_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Vutuna aubainama Bada na aneama yai raḡantenaḡe da Herod ya kati waibakoko be motamota noponama a kani rovo da ya gurina, baninama tauna nam Mamaitua i vivirena aubainama. ");
INSERT INTO dww_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Be Mamaitua riunama ya moraba be ya daberarana. ");
INSERT INTO dww_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Raḡanine Banabas be Sol adi noyama Jerusalemma awai kovina, naumeki taudi, Jon awai isaisana Mak, mate a munaḡana. ");
INSERT INTO dww_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokma Mamaitua na damma nopodie peroveta be tauwai katakatai a miamiana. Taudi isedima Banabas, Simeon awai isaisana Niga, Lusias tauna Sairin baneginama, Manaen tauna guyau Herod mate a moraba tenaḡana, be Sol. ");
INSERT INTO dww_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Raḡanine taudi Bada awai yarage be a widiwidinana, Arua Babau ya riuedina, “Banabas be Sol aubaiguma ḡavoe ko vinedina, baninama taudi è vinedina da yau noyama ta voiena.” ");
INSERT INTO dww_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Be dabudine taudi a widina be a moiragina. Murine nimedima debedie a biridi be a riuporedina. ");
INSERT INTO dww_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Sol be Banabas taudi Arua Babau ya riuporedina aubainama, taudi rabuidi a dobi a naḡona Selusiama, be dabudine taudi kukakukae a naḡona Saiprasma. ");
INSERT INTO dww_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Raḡanine taudi Salamisma a tavana, taudi Mamaitua riunama a rauguguyena Jius adi sinagogma nopodie. Be dabudine taukaisagudima Jon-Mak mate. ");
INSERT INTO dww_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Taudi Saipras bonabonanaḡa a babara naḡona, naumeki da Paposma a tavana. Dabudine taudi Jius tauḡominama a banavina, tauna peroveta kaikaiyovunama be banaga barabaraunama isanama Bar-Yesu. ");
INSERT INTO dww_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Be tauna inam primia Sergius Polas turanama. Sergius Polas tauna banaga nuanuauyauyanama be tauna Banabas be Sol ya riuedi da na vadae a saḡana, baninama tauna Mamaitua riunama vaienama ya ḡoeḡoena aubainama. ");
INSERT INTO dww_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Be taubarabarau, Gurik bonane ta riuriuna Elimas, tauna taudi adi giuma ya riuriu tuatuaḡaiedina, baninama tauna ya ḡoeḡoena da primia Sol be Banabas adi giuma nam sibo yai sumaḡedi. ");
INSERT INTO dww_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Be Sol tawai isana Pol, tauna Arua Babau noponama ya moḡavu be taubarabarau ya kitadidi ");
INSERT INTO dww_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","be ya riuna, “Tam Diaboro natunama, tam nopomma kaiyovu be gewagewa ya moḡavuna, tam yaba matabudi veredima kwawai ḡaviedi, be raḡan patapatanama tam Bada riunama didimanidima kwa kawakawa barebaredina. ");
INSERT INTO dww_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Vutuna aubainama tam yodi Bada e kovoḡim da tam matamma e potana, be raḡan bisanama nam suara matanama kwa kita.” Inam raḡanine kupi be tadiwanawana ya ruputawa be tauna ya pomnaḡona da aitau sibo ya banavi da nimane ya kaididi be sibo yai dokena. ");
INSERT INTO dww_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Raḡanine primia aba ya tubutubuḡana ya kitakitana, tauna Bada na waikatakataima ya basena aubainama yai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Raḡanine Pol na banagama mate Papos a gosena, dabudine taudi kukae a naḡona Perga meagaine, Pampilia provins nopone. Be inam dobudine Jon ya gosedi be ya munaḡana Jerusalemma. ");
INSERT INTO dww_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Be taudi Pergama be a naḡona Antiok meagaine Pisidia provins nopone. Be Sabat raḡanine taudi a naḡo sinagog nopone be a miana. ");
INSERT INTO dww_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Dabudine sinagog babadidima tarawatu be peroveta adi bukama a sievidina, be murine taudi Banabas be Pol ai baḡedi be a riuedina, “Taumi tuatuaḡamaima, deḡoda taumi rauduḡu giunama banaga aubaidima ḡaromie teika, naumeki da ko giu!” ");
INSERT INTO dww_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dabudine Pol ya midisuḡu da nimanama ya kaisuḡu be giu yai karena, “Taumi Israel banegimima be aitauḡa Mamaitua kowai sumaḡena, koi beavaia. ");
INSERT INTO dww_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel banegidima adi Mamaituama tamatamadama ya vinedi be ya voiedi da banaga damnama ya morabana, be taudi vaḡavaḡai Ijiptma a miana. Be Mamaitua na rewapanama dosi vavasaḡine tauna Ijiptma be yai doka dobiḡedina. ");
INSERT INTO dww_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Be taudi modi 40 nopone, avedi da taudi Mamaitua a kawakawa nuaḡoraḡorana, be yaḡoro tauna ya rabedina dobu kavakavane. ");
INSERT INTO dww_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Be muriḡa tauna dam dosidima 7 Keinan dobune ya kawa gewegewedi be adi dobuma na banagama Israel banegidima ya utedi be ai buderiena. ");
INSERT INTO dww_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Uma kauidima matabudi modi 450 nopodie a tubutubuḡana. Be uma kauidima muridie Mamaitua taurau etara ya utedina naumeki da peroveta Samuel na raḡanie. ");
INSERT INTO dww_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Be inam raḡanine taudi guyau a ḡoena. Vutuna aubainama Mamaitua Sol ya utedina, tauna Kis natunama, Benjiman damnama nopone. Be tauna modi 40 nopone yai guyauna. ");
INSERT INTO dww_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Be Mamaitua Sol ya kaipore be e paiyanama Deivid ya vine da taudi adi guyauma. Be Mamaitua Deivid na kauama umanama ya giuena: ‘Taugu Deivid, Jese natunama è banavina. Tauna tauḡominama nuaguma e noḡonoḡotina maika, be tauna yaba matabuna yà ḡoeḡoedina tokare e voiedina.’ ");
INSERT INTO dww_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Naumeki da uma baneginama na dame, Tauwai yawasana Yesu ya riupore dobiḡena Israel banegidima ḡarodie, baninama noḡone ya riuriuna maika. ");
INSERT INTO dww_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Muriḡa da Yesu ya tavana, noḡone Jon noḡota viravira be babataito ya rauguguyena Israel banegidima ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Raḡanine Jon na noyama yawai kovina tauna ya riuna: ‘Taumi ko noḡonoḡotina da taugu aitau? Agunai taumi ko noḡonoḡotina kabe taugu Tauwai yawasana, be ibewa. Tauna murigue e veraverauna e tavana, be taugu nam veregu da na kaḡasumama yà kaiporaḡa.’ ");
INSERT INTO dww_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Taumi tuatuaḡaguma Eibraham natunatunama, be aitauḡa Mamaitua kowai sumaḡena, koi beavaia. Mamaitua yawasana varinama verenama uma ya riuporena tauda aubaidama. ");
INSERT INTO dww_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem taumieninama be adi babadama mate taudi Yesu a nuababaḡena. Taudi Yesu a vunuḡina, be taudi Yesu a vunuvunuḡina raḡanine, dabudine taudi peroveta adi giuma, Sabat patapatanama a siesievidina, a maḡatara. ");
INSERT INTO dww_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Be avedi da nam aba gewagewanama Yesu ḡarone ti banavina, be yaḡoro taudi Paelat ai baḡa da tauna sibo Yesu yai gurina. ");
INSERT INTO dww_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Be raḡanine taudi kauidima matabudi peroveta a giugiuedina a voia kovina, naumeki da taudi kai bogane a kiroḡa dobiḡe be gubae a boruna. ");
INSERT INTO dww_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Be Mamaitua gurie ya kawa midisuḡuna. ");
INSERT INTO dww_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Be taudi aitauḡa tauna mate Galilima be Jerusalemma a naḡonaḡona, taudi ḡarodie raḡan toitoi ya maḡatarana. Be inam banegidima taudi yodi tauna na matamatama, banaga ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Be yodi tauma vari verenama kai varimina: Aba Mamaitua Tamatamadama ya riuriuedina, ");
INSERT INTO dww_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tauna yodi tauda natunatudima aubaidama yai maḡatarina, baninama tauna Yesu gurie ya kawa midisuḡuna. Salamo wairabuinama nopone girugiruminama umanama: ‘Tam taugu Natuguma, be taugu tam Tamaḡomimma. Manaka taugu tam è tikam da tam taugu Natuguma.’ ");
INSERT INTO dww_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Be mate Mamaitua umanama ya riuna: ‘Taugu yaba babau be kenakena nonoḡidima yà utemina maika boni Deivid è riuriuena nama.’ ");
INSERT INTO dww_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Vutuna aubainama wari babae mate ya riuna umanama: ‘Tam nam kui aninana da am vinevinema Babaunama e bova.’ ");
INSERT INTO dww_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Be Deivid na raḡanie tauna Mamaitua na ḡoanama ya voivoiedina, be murine tauna ya guri be tubuḡinama tamatamanama diedie a dobo, be ya bovana. ");
INSERT INTO dww_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Be uma baneginama Mamaitua gurie ya kawakawa midisuḡuna, tauna nam i bovana. ");
INSERT INTO dww_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Vutuna aubainama yau bana, yodi ka rarau guguyana ḡaromie da taumi ko katai kaua da uma baneginama tauna teneteneḡinama da ami gewagewama e noḡota poredina. ");
INSERT INTO dww_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Be Mousis na tarawatuma nam teneteneḡina da tokare ami gewagewama e noḡota pore be taumi e kawa didimanimi. Be aitauḡa Yesu koi sumaḡena, tauna ami gewagewama e noḡota poredina be taumi e kawa didimanimina. ");
INSERT INTO dww_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ko kita kaua da aba peroveta a riuriuedina nam ḡaromie ta tubuḡa. Peroveta umanama a riuna: ");
INSERT INTO dww_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Taumi waidiboḡa banegimima, ko kita, ko base be ko gurina, baninama taumi ami raḡanie taugu noya yà voiena, be uma noyanama, avedi da aitau e riuemina, be taumi tokare yaḡoro nam koi sumaḡa.’” ");
INSERT INTO dww_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Raḡanine Pol be Banabas sinagog a dobidobi porena, banaga Pol be Banabas a riuedina da Sabat ḡesaune sibo a verau munaḡa be uma yabedima sibo ḡarodie a giu munaḡedina. ");
INSERT INTO dww_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Taparoro murine Jius be eteni banegidima toitoi Pol be Banabas kedaḡa ai muriwatanedina. Be taudi aitauḡa Bada awai sumaḡena, Pol mate adi giuma ai sumaḡedina. Be Pol be Banabas banaga a riu guratedi da taudi sibo Mamaitua waimuriwatanenama a kaiguratena. ");
INSERT INTO dww_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabat ḡesaune anikitanama meagai banegidima matabudi a rawateḡeidina, Bada riunama vaienama aubainama. ");
INSERT INTO dww_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Be Jius banegidima nama ta kitana be banaga toitoi a veraverauna, dabudine taudi a unura be Pol na giuma a riutuatuaḡaie be ai varavarana. ");
INSERT INTO dww_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Be Pol be Banabas ma raudebatoredi a paribeedina, “Tauma Mamaitua riunama kabe taumi ḡaromie ka giue doke, be anikitanama taumi ko tuatuaḡaiena, be yawasana kenakena nonoḡinama nam koma ḡoeḡoena aubainama, tauma yodi ka gosemi be ka naḡona eteni ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Baninama Bada umanama ya riuemaina: ‘Taugu è voiemna da tam eteni banegidima adi yanama, da tam yawasana kwa kiroḡa nawena, naumeki da dobu damone.’” ");
INSERT INTO dww_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Raḡanine eteni nama a vaivaiena, taudi nuedima ya vere kaua be Bada riunama a kaisuḡusuḡuna. Be aitauḡa Mamaitua ya vinedi da yawasana kenakena nonoḡine ta tavana, naumeki da taudi ai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Be Bada riunama ya daberara be inam dobunama yai moḡavuna. ");
INSERT INTO dww_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Be Jius banegidima, taudi tauwai sumaḡa waiwaividima isedima dosidima, be meagai babadidima mate a kawa nuamedimedidina. Be dabudine taudi adi dobue Pol be Banabas a raukivi gewegewedi be a tavu dobiḡedina. ");
INSERT INTO dww_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Vutuna aubainama Pol be Banabas popokau kaḡedie a vayasayasaidina ḡarodie, be a naḡona Ikoniumma. ");
INSERT INTO dww_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Dabudine tauwai sumaḡa mosari be Arua Babau nopodima ya moḡavuna. ");
INSERT INTO dww_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoniumma Pol be Banabas a naḡona Jius adi sinagogma nopone. Be dabudine adi rauguguyama yai rewapana kauana, vutuna aubainama Jius be eteni banegidima ya toi kauana ai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Be Jius aitauḡa waisumaḡa nam ti ḡoeḡoena, taudi eteni banegidima a kawa nopogedegederidina tauwai sumaḡa ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol be Banabas dabudine a taumia gurata be ma debatoredi Bada Yesu isane a giugiuna. Be Bada rewapana ya utedi da taudi mataira be voia dosidima a voiedina. Dabudine banaga a kita da Bada riunama wainuapaḡopaḡonama inam riukaua. ");
INSERT INTO dww_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Inam meagaine banaga taudiḡa a dariḡa munaḡedi da ḡesaudima Jius a riu sagusagudina be ḡesaudima apasol a riu sagusagudina. ");
INSERT INTO dww_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Vutuna aubainama Jius be eteni banegidima adi babadama mate a rawateḡeidi da apasol adi kasirama a tomna da sibo a raukivi gewegewedi be a rauyekudina. ");
INSERT INTO dww_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Raḡanine taudi adi kasirama a tomtomna ta vaivaiena, taudi a naḡo moisiriedi be a naḡona Listra be Derebe meagaidie, Likonia provins nopone. Be inam meagaidie be meagai diane, ");
INSERT INTO dww_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","dabudine vari verenama a rauguguyena. ");
INSERT INTO dww_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra nopone tauḡoma kaḡa nuakudunama ya miamiana. Tauna nama ya tubuḡena, be nam airaḡan i babababara rubuna. ");
INSERT INTO dww_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tauna Pol na giuma ya vaivaiena. Be Pol tauna ya kitadidi be raḡanine e kitana, be nopone yawai sumaḡana da tauna sibo ya yawasanana, ");
INSERT INTO dww_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","naumeki da Pol bonanama dosine ya riuena, “Kaḡame kwa midisuḡu!” Be yai raḡantenaḡe da tauḡoma ya poti be naḡo yai karena. ");
INSERT INTO dww_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Raḡanine patara Pol aba ya voivoiena nama a kitakitana, taudi Likonia bonane a yogo be a riuna, “Uma mamaituedima yodi a dobina, ai rawabanaga ḡomana kitedima maika tauda!” ");
INSERT INTO dww_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Be Banabas ai isana ‘Sus’ be Pol ai isana ‘Hemes’, baninama tauna taugiugiu. ");
INSERT INTO dww_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Be Sus na pirisima tauna meagai diane be kau tautauḡomidima be berana duriduridima ya verauḡedi meagai kedanama matane be na banagama mate a ḡoeḡoena da Pol be Banabas sibo a puyodina. ");
INSERT INTO dww_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Raḡanine apasol Banabas be Pol nama a vaivaiena, taudi adi garama a sikedi be a manini a naḡona patara nopodie be bonedima dosine ");
INSERT INTO dww_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","a riuna, “Tautauḡoma, aba aubainama umanama ko voivoia? Tauma banaga ḡoma maika taumi. Tauma vari verenama kè verauḡena ḡaromie da uma bariawidima nam banibiribiridi, ko gose poredi be ami yawasanama ko vitaredina Mamaitua miamia nonoḡinama ḡarone. Baninama tauna mara, dobu be egasi be yaba matabudi nopodie ya voiedina. ");
INSERT INTO dww_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Boni tauna banaga matabudi ya gosedi be adi ḡoane nama a naḡonaḡona. ");
INSERT INTO dww_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Be yaḡoro tauna yai kataimi da tauna e miamiana, baninama ḡaromie na kiviverema ya voivoiedina. Tauna kusana gunume ya utemi be ya voie da ami kanima a gogogogo kauana, be maura ya uteutemi da taumi nuemima ya vereverena.” ");
INSERT INTO dww_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Uma giunama ya kovikovina, banaga ḡaubonaḡa a rautamtamḡotana. Be yaḡoro ya piripiri kauana da sibo a riutuaḡaiedina puyo aubainama. ");
INSERT INTO dww_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Dabudine Jius banegidima ḡesaudima Antiok be Ikoniumḡa tavetavedina adi giue patara a kawa nopogedegederidina. Vutuna aubainama matabudi Pol a rauyeku be a soru dobiḡena meagai diane, baninama taudi ai noḡotana kabe i guriguri. ");
INSERT INTO dww_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Be raḡanine tauwai muriwatana a midi kwavivirona, tauna ya midisuḡu be ya munaḡana meagaie. Pomainama tauna Banabas mate a naḡona Derebema. ");
INSERT INTO dww_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Inam meagaine taudi vari verenama a rauguguye be banaga toitoi a voiedi da taudi Bada ai muriwatanena. Dabudine taudi a munaḡana Listra, Ikonium be Antiokma. ");
INSERT INTO dww_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Dabudine taudi tauwai muriwatana a duḡudi be a kawa debatoredi be a riuedi da taudi adi waisumaḡe nama sibo a miana, be taudi a riuedina, “Tauda muriḡa da Mamaitua na waiguyauma nopone tà saḡana, be noḡone tauda ḡoraḡoranama tà siguena.” ");
INSERT INTO dww_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Be inam meagaidie a naḡonaḡona nopodie, Pol be Banabas, Mamaitua na damma nopodie, adi babadama a vinedina. Be muriḡa taudi a moiragi, a widina be Bada ḡarone ai maḡataridina, baninama tauna vutuna awai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Naumeki da taudi Pisidia provins noponaḡa a naḡonaḡo da taudi Pampilia provinsne a tavana. ");
INSERT INTO dww_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Dabudine taudi Pega meagaine Mamaitua riunama a rarau guguya kovina raḡanine, taudi a dobi a naḡona Atalia meagaine. ");
INSERT INTO dww_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Naumeki da dabudine kukakukae a munaḡa Antiokma. Inam meagaine noḡone tauwai sumaḡa taudi Banabas be Pol Mamaitua nimane a biridina, be tauna e sagudi da uma noyanama ta voiena, vutuna noyanama umanema yodi damonama. ");
INSERT INTO dww_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Adi kaba tava munaḡe tauwai muriwatana matabudi a rawateḡeidi be yaba matabudi Mamaitua eteni ḡarodie ya voivoiedina ai varidina. Mamaitua yodi eteni adi kedama ya kaipore da taudi ai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Naumeki da taudi inam dabudine tauwai muriwatana mate a mia watanana. ");
INSERT INTO dww_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tautauḡoma ḡesaudima taudi Judiaḡa a yovona Antiokma. Be dabudine tauwai sumaḡa umanama awai katakataidina, “Deḡoda taumi nam kopitom ko paḡo maika Mousis ya riuriuna nama, taumi tokare nam yawasana ko paḡo.” ");
INSERT INTO dww_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Uma giudima aubaidima Pol be Banabas taudi mate ai saḡasaḡana. Vutuna aubainama tauwai sumaḡa Antiokma taudi Pol, Banabas be tauwai sumaḡa ḡesaudima a vinedi da taudi sibo a naḡona Jerusalemma. Be dabudine taudi apasol be babada uma kauinama sibo a giuena. ");
INSERT INTO dww_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Naumeki da, Mamaitua na damma taudi a riupore nawedina. Be kedae Ponitia be Samaria nopodiḡa a naḡo be dabudine Pol be Banabas banaga tauwai sumaḡa a riuriuedina da eteni banegidima adi yawasanama a vitaredina. Be uma varinama aubainama tauwai sumaḡa matabudi nuedima ya verena. ");
INSERT INTO dww_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Raḡanine taudi Jerusalemma a tavatavana, dabudine Mamaitua na damma, apasol be babada taudi Pol be Banabas adi banagama mate ai kaiwedi be a rabedina. Dabudine Pol be Banabas Jerusalem banegidima, Mamaitua yaba matabuna ya voivoiedina, a riuedina. ");
INSERT INTO dww_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Dabudine Parisi nopodie tauwai sumaḡa ḡesaudima a midisuḡu be a riuna, “Tauwai sumaḡa eteni nopodie, taudi naumeki da kopitom ta paḡo be Mousis na tarawatuma ta voteyeteyena.” ");
INSERT INTO dww_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Dabudine apasol be babada ai boru be kopitom kauinama a giu guratena. ");
INSERT INTO dww_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Dabudine ai tarapiri guratana be muriḡa Pita ya midisuḡu be ya riuedina, “Yau bana! Taumi koya kataie da dokane poumie Mamaitua ya vinegu da taugu mudugue eteni banegidima vari verenama sibo a vaie be ai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Be Mamaitua nopo matabudi ya kataiedina, be tauna yai kataiguna da eteni banegidima yai aninedina, baninama Arua Babau ya utedina maika tauda. ");
INSERT INTO dww_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Be tauna nam i voie da taudi tabu be tauda tabu, baninama tauna nopodima ya koḡedina, adi waisumaḡama aubainama. ");
INSERT INTO dww_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Vutuna aubainama taumi nam sibo tauwai sumaḡa koya kawa nuaraḡeraḡedi, baninama tamatamadama bo tauda nam teneteneḡina da uma vitanama tokare te kiroḡi. Deḡoda nama ko voiana, taumi Mamaitua ko rarau rubuna da tauna nuanama ei medina. ");
INSERT INTO dww_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ibewa nam nama, tauda tài sumaḡa da Bada Yesu na raukiviveree tè yawasanana. Be teneḡinama nama eteni banegidima.” ");
INSERT INTO dww_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Be borue banaga matabudi ai nuatuḡutuḡu be Banabas be Pol adi giuma awai beavaiedina nema Mamaitua mataira be voia dosidima taudie eteni ḡarodie ya voivoiedina ai maḡataridina. ");
INSERT INTO dww_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Raḡanine adi giuma awai kovina, dabudine Jeims ya riuna, “Yau bana, koi beavaiegu! ");
INSERT INTO dww_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saemon tauda kaite ya riuedana da Mamaitua na damma eteni nopodie ya vinedina. ");
INSERT INTO dww_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Be peroveta adi giuma a girugirumina mate teneḡinama, umanama a girumina: ");
INSERT INTO dww_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Raḡan muriḡa taugu yà verau munaḡa be Deivid na kapema pupunama yà keri munaḡena. Be deḡo dobudima nuanuakotovidima, taugu yà rawa vau munaḡedina. ");
INSERT INTO dww_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nama taugu yà voie da Israel banegidima tautaugosedima be eteni matabudi taugu è vinevinedina, taudi Bada tai muriwatanena. Nama Bada ya riuna. Tauna uma yabedima ya voiedina. ");
INSERT INTO dww_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Be inam kauidima yà giugiuemina, boni banaga a kataiedina.’ ");
INSERT INTO dww_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Vutuna aubainama taugu è noḡotina umanama: Deḡoda eteni banegidima aitauḡa Bada tawai sumaḡena, naumeki da nam sibo tè tainuaraḡeraḡedi. ");
INSERT INTO dww_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Be tauda sibo leta tè girumidi be tè riuedi da taudi kani raurauobedima nam ta kani be nam ta rauwaivi yabayababa. Deḡoda tai naḡina, inam naumeki adi visavisarama taudiḡa mate, be nam waiwaivi ḡesaudima mate. Be taudi nam musara gadonama kikikinama bo kosina ta kanidi, ");
INSERT INTO dww_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","baninama Mousis na tarawatuma boni da yodi meagai da meagai ta rauguguye be Sabat patapatanama sinagog nopodie ta siesievidina.” ");
INSERT INTO dww_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Naumeki da dabudine apasol, babada be Mamaitua na damma matabudi, nopodie taudi tautauḡoma ḡesaudima a vinedi da a riupore nawedina Antiokma Pol be Banabas mate. Taudi Judas awai isaisana Basabas, be Saelas a vinedina. Taudi rabuidi tauwai sumaḡa nopodie tauwai kedadoka. ");
INSERT INTO dww_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Naumeki da apasol uma letanama taudi mate a riupore nawedina: “Kapore eteni banegimima aitauḡa kowai sumaḡana. Tauma tuatuaḡemima apasol be babada, tauma uma letanama kè girumina taumi tauwai sumaḡa Antiok, Siria be Silisiama ḡaromie. ");
INSERT INTO dww_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Tauma kè vaiena da tauma ama damma nopone banaga ḡesaudima taudi adi giue a tainuaraḡeraḡemi be a tainuaboyemina. Be tauma nam ke riuedina da nama sibo a voia. ");
INSERT INTO dww_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Vutuna aubainama tauma matabumai kèi aninana, da tautauḡoma ḡesaudima kè vinedi be taudi tauma ama banagama Banabas be Pol mate kè riuporedina ḡaromie. ");
INSERT INTO dww_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Uma tautauḡomidima taudi adi yawasanama ai utaedina dà Badama Yesu Keriso aubainama. ");
INSERT INTO dww_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tauma Judas be Saelas ka riuriuporedina da aba letae kè girugirumina, taudi mududie ta giu yaḡemina. ");
INSERT INTO dww_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","“Arua Babau be tauma kèi anina da nam vita debemie ka boru. Be taumi sibo uma yabediḡa koya voiedina: ");
INSERT INTO dww_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kani raurauobedima nam ko kanidi be kosina bo musara gadonama kikikinama nam ko kanidi. Be nam ko rauwaivi yabayababa. Deḡoda koi naḡina, inam naumeki ami visavisarama taudiḡa mate, be nam waiwaivi ḡesaudima mate. Deḡoda uma yabedima ko gosedina, taumi tokare naumeki. “Ebom matabumi be ko mia kaua.” ");
INSERT INTO dww_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Dabudine tautauḡoma a riuporedi be a dobi a naḡona Antiokma. Raḡanine taudi dabudi a dobidobina, naumeki da banaga matabudi ai rawateḡeidi be leta a utedina. ");
INSERT INTO dww_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Dabudine banaga leta a sievi be nuedima ya verena duḡu giudima aubainama. ");
INSERT INTO dww_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas be Saelas taudi peroveta be adi giue a duḡudi be a voiedi da ai rewapanana. ");
INSERT INTO dww_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Taudi dabudine a rautapa miana, muriḡa be taudi tuatuaḡedima ai aiainidi be suba mate a riupore munaḡedina aitauḡa a riuriuporedina ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(-) ");
INSERT INTO dww_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Be Pol be Banabas taudi Antiokma a mia kwasa be taudi banaga ḡesaudima mate Bada na giuma awai katakatai be a rarau guguyena. ");
INSERT INTO dww_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","A mia raḡan bisanama be Pol Banabas ya riuena, “Agunai tà munaḡa meagai matabudi nopodiḡa deḡo Bada riunama tè rarau guguyedina, dabudi dà banagama tà vakitekitedi da taudi nema ta naḡonaḡo bako.” ");
INSERT INTO dww_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Dabudine Banabas ya ḡoeḡoena da Jon awai isaisana Mak taudi mate sibo a naḡona. ");
INSERT INTO dww_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Be Pol ya noḡoti da nam i verena da taudi Mak mate ta naḡo, baninama tauna noḡone Pampiliama ya gose poredina. Be tauna nam taudi mate ti noyana. ");
INSERT INTO dww_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Dabudine taudi uma kauinama aubainama ai kawa riuriu vavasaḡa be ai daberaridina. Naumeki da Banabas Mak yai doke be kukakukae a davuna Saiprasma. ");
INSERT INTO dww_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Be Pol tauna Saelas yai doke be a naḡona. Be tauwai sumaḡa a moiragi da Mamaitua Pol be Saelas e rabedina. ");
INSERT INTO dww_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Taudi Siria be Silisia nopodiḡa a naḡo be Mamaitua na damma matabudi a voiedi da ai rewapanana. ");
INSERT INTO dww_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tauna Debe be Listrama ya tavana. Dabudine tauwai muriwatana isanama Timoti ya miamiana. Tauna tinananama Jius baneginama be tauna tauwai sumaḡa, be tamanama tauna Gurik baneginama. ");
INSERT INTO dww_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tauwai sumaḡa matabudi Listra be Ikonium nopodie taudi a riuna da Timoti tauna banaga verenama. ");
INSERT INTO dww_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Vutuna aubainama Pol ya ḡoeḡoena da Timoti mate sibo a naḡona. Inam dabudine Jius a miamiana be Pol kopitom Timoti ḡarone ya voiena, baninama Jius banegidima kadi taiye, baninama taudi matabudi a kataiena da Timoti tamanama tauna Gurik baneginama. ");
INSERT INTO dww_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Muriḡa taudi meagai da meagai a naḡo be apasol be babada Jerusalem nopone abaḡa awai aninedina, nama banaga a riu nawedina da taudi yabedima nama sibo a voteyeteyedina. ");
INSERT INTO dww_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Naumeki da Mamaitua na damma a voiedi da adi waisumaḡama yai rewapana be banaga raḡaninama patapatanama sievinama ya moramorabana. ");
INSERT INTO dww_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol na banagama mate taudi Pirigia be Galesia provins noponaḡa a naḡonaḡona, baninama Arua Babau ya riutuaḡaiedina da taudi nam Mamaitua na giuma Eisia provins nopone sibo a rauguguye. ");
INSERT INTO dww_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Raḡanine taudi Misia provinsne a tavatavana, taudi a raurubu da Bitinia provinsne sibo a naḡona, be Yesu Aruinama ya riutuaḡaiedina. ");
INSERT INTO dww_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Dabudine taudi Misia ai muri be a dobi a naḡona Troas meagaine. ");
INSERT INTO dww_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Inam kupine Pol rauboni matae kitakitanama ya kitana. Tauna Masedonia baneginama ya kitana, noḡone ya midi be yawai baḡana, “Kwa verau Masedoniama be kwa sagumaina!” ");
INSERT INTO dww_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Uma rauboninama murine tauma waiḡapa kè vokaukauana Masedonia naḡonama aubainama, baninama tauma kè noḡoti da Mamaitua ya yokoemaina da inam dabudine sibo vari verenama kè rauguguyena banaga ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tauma Troas kè gose be kukakukae kè naḡona Samotres. Be pomainama kè davuna Neapolisma. ");
INSERT INTO dww_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Dabudine da tauma kè naḡona Pilipi. Inam Masedonia adi meagaima dosinama be Rom banegidima adi kaba miama. Be dabudine tauma raḡan bisanama kè miana. ");
INSERT INTO dww_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Be Sabat raḡanine tauma kè dobi kè naḡona upae meagai kedanama matane. Dabudine tauma kè noḡoti da Jius adi kaba moiragima gabunama sibo kè banavina. Tauma kè mia be waiwaivi aitauḡa dabudi awai rawateḡeina ḡarodie kè giuna. ");
INSERT INTO dww_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Dabudine waivi tenaḡa isanama Lidia tauna Mamaitua taurauduneenama. Tauna Tayatira meagaine be gara gatugatunama taurau gimaredima. Be tauna uma giunama ya vaivaiedina, Bada tauna nuanama ya vitare be Pol aba ya giugiuedina yawai beavaia kauedina. ");
INSERT INTO dww_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Dabudine tauna be na vadama banegidima matabudi ai babataitodina. Muriḡa tauna yai baḡamaina, “Deḡoda taumi ko noḡotina da taugu naumeki Bada yàwai sumaḡena, naumeki da ko verau be taugu mate tà miana yau vadae.” Dabudine tauna nuamaima ya riu vitarena. ");
INSERT INTO dww_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Raḡan tenaḡa tauma kè naḡona Jius adi kaba moiragima gabune. Be kedae taunoya waivinama kè banavina, tauna nopone koitiri aruinama. Be inam aruinama tauna kaua nam anikaba kataiedi tauna yawai maḡataridina. Be uma waivinama taupakinama taudi mane dosinama a paḡopaḡona na koitirima aubainama. ");
INSERT INTO dww_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Uma waivinama tauma Pol mate yai muriwatanemai be bonanama dosine umanama ya riuriuna, “Uma banegidima taudi Mamaitua saḡasaḡa vavasaḡinama na taunoyama, be taudi yawasana kedanama ta riuriuemina.” ");
INSERT INTO dww_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Uma kauinama raḡan matabuna namaḡa ya voivoiana. Be raḡan tenaḡa Pol tuninama ya tuaḡai da yai tautinamuri be koitiri aruinama ya riuena, “Yesu Keriso isane yà riuriu vavasaḡemna: Uma waivinama kwa dobi pore!” Inam dabudine arua waivi ya dobi porena. ");
INSERT INTO dww_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Raḡanine waivi taupakinama ta kitana be adi manema anivoienama kedanama ya kovina, naumeki da taudi Pol be Saelas a vunuḡidi be a soru nawedina anikune gabune etaredima aubainama. ");
INSERT INTO dww_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Taudi a verauḡedina meagaie gewagewa tauwai tarapiriedima ḡarodie a verauḡedi be a riuna, “Uma tautauḡomidima taudi Jius banegidima, da meagaima ta kawakawa gewagewana. ");
INSERT INTO dww_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Baninama taudi vaivai tabudima tawai katakataidana, be tauda nam naumeki da tài aninedi be tà voiedi, baninama tauda Rom banegidama.” ");
INSERT INTO dww_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Be dabudine patara ai rawateḡeidi da Pol be Saelas a mediedina. Be gewagewa tauwai tarapiriedima taudi Pol be Saelas adi garama a sikedi be tautauḡoma ḡesaudima a riuedi da taudi a kwapudina. ");
INSERT INTO dww_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Be taudi a kwapudina raḡan ya riba kaua be dibure a sivudi be dibura taubodamenama a riue da e rabe kauedina. ");
INSERT INTO dww_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Uma riunama aubainama taubodama dibura nopo vavasaḡine ya biridi be kaḡèdima kaie yai ḡavitadididina. ");
INSERT INTO dww_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kupi poune nama Pol be Saelas a moimoiragi be a saresarena Mamaitua ḡarone. Be dibura banegidima ḡesaudima taudi awai beavaiedina. ");
INSERT INTO dww_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Yai raḡantenaḡe da yoyo dosinama ya tubuḡa be dibura vadanama matabuna ya gusu da dibura matakededima matabudi a nuaporaporaḡa be seini banaga a panipanidina matabudi a nuakuvesana. ");
INSERT INTO dww_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Be dibura taubodamenama ya ḡosori da e kitana be dibura matakededima matabudi a nuaporaporaḡana, dabudine tauna yai noḡotana dibura banegidima matabudi kabe naira ti naḡonaḡo. Vutuna aubainama tauna na kwatikwatima ya soru tavaite be ya ḡoeḡoena sibo taunaḡa yai guri munaḡena. ");
INSERT INTO dww_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Be Pol bonanama dosine ya riuna, “Nam kwai guri munaḡem! Tauma matabumai uma.” ");
INSERT INTO dww_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dabudine tauna kodam ya riuwane be ya manini naḡona vada nopodiḡa be Pol da Saelas noḡodie ma nairina ya rauduneedina. ");
INSERT INTO dww_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Dabudine yai doka dobiḡedi be yai taraviredina, “Yau bana, aba yà voie be yawasana yà banavi?” ");
INSERT INTO dww_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Be taudi a paribeena, “Bada Yesu kwai sumaḡe be tam kwa yawasanana. Tam be am vadama banegidima mate.” ");
INSERT INTO dww_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Be Pol da Saelas Bada riunama tauna be na vadama banegidima mate a riuedina. ");
INSERT INTO dww_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Be inam raḡanine kupie tauna yai dokedi da kerodima ya koḡedi be waiḡapa tauna be na sedama mate ai babataitodina. ");
INSERT INTO dww_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Dabudine taubodama yai doka nawedina na vadae be adi kanima ya vokaukauena. Be tauna na sedama mate mosari nopodima ya moḡavuna, baninama taudi yodi Mamaitua tawai sumaḡena. ");
INSERT INTO dww_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pomainama raḡan ya tom da gewagewa tauwai tarapiriedima babadidima taudi tauwai kwapu banegidima a riuporedina dibura taubodamenama ḡarone be umanama a riuena, “Inam banegidima kwa kaiporaḡa be ta naḡona.” ");
INSERT INTO dww_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Naumeki da dibura taubodamenama uma riunama Pol ya riuena, “Gewagewa tauwai tarapiriedima a riuna da taumi sibo è kaiporemi. Vutuna aubainama yodi ma nuasubemi ko naḡo!” ");
INSERT INTO dww_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Be Pol tauwai kwapu ya riuedina, “Avedi da tauma Rom banegimaima be taudi nam ti katai kauemaina, be mate nam ama gewagewama ti kataie be patara nopodie a kwapu yababemai be dibure a birimaina. Be yodi taudi ta ḡoeḡoena moisirie ta kaiporemai, bo? Ibewa! Nam nama. Taudi ḡomidima sibo a verau be ai doka dobiḡemaina.” ");
INSERT INTO dww_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Be tauwai kwapu inam giudima gewagewa tauwai tarapiriedima ḡarodie ai maḡataridina. Raḡanine taudi ta vaiena be Pol da Saelas taudi Rom banegidima, dabudine taudi a naira kauana. ");
INSERT INTO dww_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Naumeki da taudi a verau da Pol be Saelas ai kaiwedi be ai baḡedi da sibo meagai a gose pore be a naḡona. Naumeki da taudi dibure be ai doka dobiḡedina. ");
INSERT INTO dww_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Raḡanine Pol be Saelas dibura a dobidobi porena taudi a naḡona Lidia na vadae. Dabudine taudi tauwai sumaḡa a banavidi da a duḡudi be muriḡa taudi a naḡona. ");
INSERT INTO dww_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Raḡanine taudi a babara naḡona Ampipolis be Apolonia meagaidima, a gosedi be Tesalonaikama a tavatavana, dabudine Jius adi sinagogma a kitana. ");
INSERT INTO dww_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Naumeki da Pol tauna nopone ya naḡona maika noḡone na kaba voiama nama. Sabat rabuiteḡa nopodie tauna banaga mate buka poredima girugirumidima ai tarapiriedi ");
INSERT INTO dww_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","be ya giugiu waibatedina da Tauwai yawasana ei nuatoitoi be gurie e midisuḡu munaḡana yawai maḡataridina. Tauna umanama ya riuriuna, “Uma Yesunama taugu ḡaromie yà rarau guguyena tauna Tauwai yawasana”. ");
INSERT INTO dww_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Naumeki da Jius banegidima ḡesaudima ai sumaḡa be Pol be Saelas ai muriwatanedina. Be teneḡinama nama Gurik banegidima Mamaitua taurauduneenama toitoi be waiwaivi isanaḡonaḡodima bisanama. ");
INSERT INTO dww_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Be Jius banegidima a unurana, vutuna aubainama banaga adi yawasanama gewegewedima anikune gabune a rawateḡeidina, be taudi iḡara inam meagaine ai karena. Taudi a naḡo Jeison na vadae a saḡana. Taudi Pol be Saelas a wanewanedina da sibo a dobiḡedina banaga ḡarodie. ");
INSERT INTO dww_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Be taudi a wana rereḡedina aubainama, Jeison be tauwai sumaḡa ḡesaudima a soru dobiḡedina meagai babadidima noḡodie, be bonedima dosine a riuna, “Uma tautauḡomidima taudi gewagewa dobu matabuna a voivoiedina be yodi uma a tavana. ");
INSERT INTO dww_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Be Jeison ya riuedi da na vadae ya saḡedina. Be taudi Sisa na giuma a rawaḡaiḡaiedi be a riuna da banaga ḡesaunama, tauna guyau, isanama Yesu.” ");
INSERT INTO dww_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Raḡanine taudi umanama giudima a vaivaiedina, patara be meagai babadidima ma medidi a naḡo midisuḡuna. ");
INSERT INTO dww_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Dabudine babada Jeison na banagama mate a riuedi da mane bisa a ḡoeḡoedina nama ai maesa be a riuporedi da a naḡona. ");
INSERT INTO dww_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Raḡanine kupi ya tavatavana tauwai sumaḡa Pol be Saelas a riupore nawedina Bereama. Dabudine a tavatavana, taudi Jius adi sinagogma nopone a naḡona. ");
INSERT INTO dww_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Be banaga dabudi Bereama miemienidima taudi banaga veredima, nam Tesalonaika banegidima maika. Baninama taudi raḡan matabuna Mamaitua riunama nuedima tabutabune a vaivaie be a paḡopaḡona. Dabudine taudi girugiruminama poranama raḡan patapatanama a kitakita yaḡedina, da aba Pol ya riuriuedina inam riukaua bo ibewa. ");
INSERT INTO dww_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Be Jius banegidima toitoi be Gurik waiwaividi be tautauḡomidima isanaḡonaḡodima toitoi matabudi ai sumaḡana. ");
INSERT INTO dww_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Raḡanine Jius banegidima Tesalonaikama ta vaiena be Pol Mamaitua riunama Bereama ya rarau guguyena, taudi mate dabudi a naḡo be patara a kawa nopogedegederidina. ");
INSERT INTO dww_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Naumeki da tauwai sumaḡa Pol waiḡapa a riupore nawena gerese, be Saelas be Timoti Bereama a mia kwasana. ");
INSERT INTO dww_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Be tautauḡoma aitauḡa Pol awai dokena taudi mate a naḡona, naumeki da Aten paratinama. Be Pol na giuma a munaḡena Bereama da Saelas be Timoti ta riuedi be yaḡiyaḡina Pol murine ta naḡona. ");
INSERT INTO dww_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Raḡanine Pol yaḡoro Saelas be Timoti Atensma ya raberabedina, tauna yai nuaboya kauana, baninama e kitana be meagai noponama kokoitau ya moḡavuna. ");
INSERT INTO dww_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tauna Jius be Gurik tauwai sumaḡa banegidima mate sinagog nopone ai tarapirina, be raḡan patapatanama anikune gabune aitauḡa a tavatavana mate awai tarapirina. ");
INSERT INTO dww_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Dabudine tautauḡoma nuanuauyauyedima Epikuria be Stoiki damdima, taudi Pol umanama a riu virevirena, “Inam baneginama giugiu buabuanama aba e giue?” Be banaga ḡesaudima a riuna, “Anikitanama maika tauna wari dobu mamaituedima e giugiuedina.” Nama taudi a riuna, baninama Yesu tauna gurie be ya midisuḡu munaḡana, vutuna Pol ya rarau guguyena. ");
INSERT INTO dww_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dabudine taudi Pol ai doka nawena Areopagas oyanama debane be a riuena, “Tauma sibo kè kataie da uma waikatakatainama vaunama aba tam kwai katakataiedi? ");
INSERT INTO dww_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tam am giuma vaiedima ditabu beamaie ta yovoyovona. Vutuna aubainama tauma ka ḡoeḡoena da am giuma pakanama sibo kè katai kauena.” ");
INSERT INTO dww_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Naumeki Aten banegidima be vaḡavaḡai matabudi dabudi miemienidima taudi nam aba noyanama ti voivoiena, be taudi raḡan matabuna a miaboni be giu vaudima a giugiuedi be awai beavaiedina. ");
INSERT INTO dww_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Dabudine Areopagas oyane adi kaba waiborue dabudine Pol ya midisuḡu be ya riuna, “Yau bana! Taugu yà kitakitana da taumi bariawa tabu be tabu ko rarau duneedina, maika kabe Mamaitua. ");
INSERT INTO dww_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Taugu ami meagaiḡa è babababara naḡo raḡanine, taugu olta tenaḡa è banavina da debane umanama a girumana: Uma oltanama tauna mamaitua nam katakataiena tauna aubainama. Taumi uma Mamaituanama nam ko kataiena be ko rarau duneena. Tauna vutuna yodi yà rauguguyena ḡaromie. ");
INSERT INTO dww_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Inam Mamaituanama, tauna dobu be nopone yaba matabuna ya voiedina. Be tauna mara be dobu ewai badedina, be tauna nam vada banaga nimedie a voivoiedina nopodie ima miamiana. ");
INSERT INTO dww_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Be banaga nam teneḡina da tauna tai kani be ta rabe, baninama tauna nam aba ḡarode ima ḡoeḡoena. Ibewa! Tauna vutuna yaba matabuna e raberabedina, be tauna yawasana, yavutu be yaba matabudi e uteutedina. ");
INSERT INTO dww_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tauna tauḡoma tenaḡa pakane yai tubuḡina be taune dam matabudi dobue yai tubuḡidina, baninama ya ḡoena da banaga sibo dobu matabuna a miana. Be tauna banaga adi raḡanima ya vinedi be adi kaba miama deḡo dabudine sibo a miana mate ya vinedina. ");
INSERT INTO dww_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“Nama Mamaitua e voivoiana, baninama tauna e ḡoeḡoena da banaga ta wane be tai suratou gurata da ta banavina. Be tauna tauda diade be nam i naḡo poredana. ");
INSERT INTO dww_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Baninama taune tà yawayawasana, tà naḡonaḡo be tà miamiana. Be ami sarema taubiridima ḡesaudima taudi umanama a vatovatodina, ‘Tauda tauna natunatunama.’ ");
INSERT INTO dww_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Vutuna aubainama tauda deḡoda Mamaitua Natunatunama, naumeki da tauda nam sibo tèi noḡotana Mamaitua tauna kokoitau, banaga adi nuauyauyae gold, siruva bo yekue a sarisaridina maika. ");
INSERT INTO dww_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dokane Mamaitua bua ya kita poredina, be yodi banaga dobu matabuna e riuriuedina da nuedima ta vitaredina, ");
INSERT INTO dww_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","baninama tauna raḡan ya vinena da airaḡan tauna dobue banaga matabudi adi voiama ruvane ei tarapiriedina. Be tauna tauḡoma tenaḡa ya vinena da tauna uma kauinama ei badena. Uma baneginama Mamaitua gurie ya kawa midisuḡu munaḡena, da matabuda sibo tè kataiena da Mamaitua uma noyanama tauna ya utena.” ");
INSERT INTO dww_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Raḡanine taudi gurie midimidisuḡu muneḡinama a vaivaiena, dabudine ḡesaudima taudi ai kwatekwateve be ḡesaudima a riuna, “Tauma ka ḡoeḡoena uma riunama wari raḡan kwa giu munaḡe be ka vaiena.” ");
INSERT INTO dww_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Naumeki da Pol ya gosedi be ya naḡona. ");
INSERT INTO dww_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Be tautauḡoma bisanama na giuma ai sumaḡe be ai muriwatanena. Taudi nopodie tauḡoma tenaḡa isanama Dionisus, tauna Areopagas oyanama baneginama. Be ḡesau tauna waivinama isanama Damaris, be ḡesaudima mate. ");
INSERT INTO dww_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Uma kauidima muridie Pol Aten ya gose pore be ya naḡona Korint. ");
INSERT INTO dww_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Inam dabudine Jius tauḡominama isanama Akwila ya banavina, tauna Pontasma ya tubuḡana. Tauna na waivima Prisila mate maiḡo ḡoma Italima be a tavana, baninama Sisa Klaudias ya riu vavasaḡana da Jius banegidima Romma ta gosena. Be Pol ya naḡona kitedima aubainama. ");
INSERT INTO dww_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Be na noyama teneḡinama maika taudi. Vutuna aubainama taudi mate a mia be parai a voivoiedina vada aubaidima. ");
INSERT INTO dww_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Be Sabat matabudi sinagog nopone yawai tarapirina, be ya rarau rubuna da Jius be Gurik banegidima sibo nuedima a vitaredina. ");
INSERT INTO dww_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Raḡanine Saelas be Timoti Masedoniama be a tavana, dabudine Pol parai voienama ya gose be raḡan matabuna Mamaitua riunaḡa ya giugiu nonoḡena, be Jius ḡarodie yawai maḡatarana da Yesu tauna naumeki Tauwai yawasana. ");
INSERT INTO dww_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Be Jius taudi tauna na giuma a riu virevire be a kunurena. Vutuna aubainama tauna na garae popokau ya rawakurukuruvidi be ya riuedina, “Deḡoda yawasana nam ko banavi, inam taumiḡa ami wavuma. Be wavumima taumiḡa ko paḡo munaḡena be nam taugu yau wavu. Yodi be nokoi ya naḡona taugu yà naḡona eteni ḡarodie.” ");
INSERT INTO dww_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Naumeki da Pol sinagog ya dobi pore be ya naḡona Taitos Jastas na vadae sinagog diane. Inam baneginama tauna Mamaitua taurauduneenama. ");
INSERT INTO dww_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispas sinagog tauwai badenama be na vadama banegidima matabudi Bada ai sumaḡena. Be Korint banegidima toitoi nama a vaivaiena, taudi mate ai sumaḡa be a babataitona. ");
INSERT INTO dww_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kupi tenaḡa Pol Bada ya kitana, be Bada umanama ya riuena, “Nam kwa naira, tam naumeki da kwa giugiuna, nam kwai nuatuḡutuḡu, ");
INSERT INTO dww_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","baninama taugu tam mate, be nam aitau tokare e midisuḡu be e raukivi gewegewem. Baninama yau banagama toitoi uma meagaine ta miamiana.” ");
INSERT INTO dww_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Naumeki da Pol modi tenaḡa be nawaravi 6 dabudi ya mia be Mamaitua riunama banaga yawai katakataidina. ");
INSERT INTO dww_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio tauna Akaia provins nopone yawai primiana raḡanine, dabudine Jius banegidima a rawateḡeidi da Pol a vunuḡi be a verauḡena etara aubainama. ");
INSERT INTO dww_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Taudi Pol ai wavu be a riuna, “Uma tauḡominama tauna banaga nuedima ya riu vitaredi da taudi Mamaitua a rarau dunee be isanama a kaikai suḡuna. Be tauma ama tarawatuma nam nama ima kenakenana.” ");
INSERT INTO dww_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Dabudine Pol ḡaubonaḡa sibo giu yai karena be Galio Jius ya riuedina, “Taumi Jius koi beavaia! Deḡoda uma baneginama gewagewa i voiena, naumeki da taugu sibo bonemima è paḡona. ");
INSERT INTO dww_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Be uma kauinama tauna ya voiena, inam taumi ami waikatakataima na ruvae be ami tarawatuma isedie. Vutuna aubainama uma kauidima taumiḡa koi tarapiriedi be nam taugu yau noyama dabudi ima kenakenana.” ");
INSERT INTO dww_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Vutuna aubainama tauna anietara vadane be ya tavu dobiḡedina. ");
INSERT INTO dww_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Dabudine Jius banegidima matabudi sinagog tauwai badenama Sostenes a vunuḡi be Galio noḡone a riḡa yabayababena. Be Galio nam aba i riuena. Pol ya munaḡana Antiokma. ");
INSERT INTO dww_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Be tauna Korintma ya mia guratana. Muriḡa na banagama yai kaiwedi be kukakukae, Prisila be Akwila mate a naḡona Siriama. Muriḡa da ya geruna tauna Kenkeriama debanama a maku porena, na saugama Mamaitua ḡarone aubainama. ");
INSERT INTO dww_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Taudi Epesesma a tava be dabudine Pol Prisila be Akwila ya gosedi be ya naḡona sinagog nopone be Jius banegidima mate ai tarapirina. ");
INSERT INTO dww_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Dabudine Jius banegidima tauna ai baḡana da mate a taumia gurata be tokare sibo ya naḡona. Be tauna ya tuaḡaina. ");
INSERT INTO dww_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Naumeki da yai kaiwedi be ya riuedina, “Deḡoda Mamaitua e ḡoeguna, naumeki da tokare yà verau munaḡana.” Be dabudine tauna Epeses ya gose be kukakukae ya naḡona. ");
INSERT INTO dww_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Raḡanine tauna Seseriama ya tavana, tauna ya saḡana Jerusalemma Mamaitua na damma waikaiwedima aubainama, be muriḡa tauna ya dobi ya naḡona Antiokma. ");
INSERT INTO dww_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol dabudine Antiokma ya taumia guratana. Muriḡa uma dobunama ya gose be tauna ya babara naḡona meagai da meagai, Galesia be Pirigia provinsdima nopodiḡa, be tauwai muriwatana matabudi ya voiedi da taudi ai rewapanana. ");
INSERT INTO dww_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Inam raḡanine Jius tauḡominama tenaḡa isanama Apolos, ya verauna Epeses meagaine. Tauna Alexandriama ya tubuḡana, be tauna taugiuyaḡayaḡa be girugiruminama poranama tauna ya katai kauena. ");
INSERT INTO dww_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Be tauna Bada Yesu na yawasanama kedanama a giu kauena. Be na giuma vaiedima ai rewapana vavasaḡana. Avedi da tauna Jon na babataitoma taunaḡa ya kataiena, be yaḡoro Yesu na kauama ya giu yaḡeyaḡedina. ");
INSERT INTO dww_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tauna ma raudebatorana sinagog nopone ya giuna. Raḡanine Prisila be Akwila tauna na giuma ta vaiena be taudi a riue be ai doka nawena adi vadae. Be dabudine taudi Mamaitua na yawasanama kedanama Apolos a giu yaḡena. ");
INSERT INTO dww_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Raḡanine Apolos Akaia naḡonama ya waitaina, naumeki tauwai sumaḡa Epesesma taudi leta a girumina Akaiama tauwai sumaḡa ḡarodie da raḡanine Apolos dabudine e tavana inam taudi nimedie. Apolos na kaba tavama raḡanine, tauna tauwai sumaḡa ya sagu kauedina, waikatakatai puyonama tauna ḡarone aubainama. ");
INSERT INTO dww_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Be na giuma wairewapana vavasaḡidie Jius banegidima adi giuma patara nopodie ya riḡedina, be tauna girugiruminama porane ḡarodie yai maḡatarana da Yesu tauna naumeki Tauwai yawasana. ");
INSERT INTO dww_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Raḡanine Apolos tauna Korintma ya miamiana maika, Pol tauna oya tauridiḡa kedanama ya paḡona, naumeki da Epesesma ya dobina. Dabudine tauwai muriwatana ḡesaudima ya banavidi ");
INSERT INTO dww_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","be yai taraviredina, “Taumi koyawai sumaḡana raḡanine, Arua Babau koya paḡo bo ibewa?” Be taudi a paribeena, “Ibewa, tauma nam airaḡan deḡo Arua Babau riunama ke vaia rubuna.” ");
INSERT INTO dww_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Naumeki da Pol ya riuna, “Be taumi aba babataitonama koya paḡo?” Be taudi a paribeena, “Jon na waibabataitoma.” ");
INSERT INTO dww_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Dabudine Pol ya riuna, “Jon na waibabataitoma inam taudi aitauḡa adi noḡotama ta vitavitaredina aubaidima. Tauna banaga ya riuedina da, banaga murine e veraverauna, tauna tai sumaḡena, inam tauna Yesu.” ");
INSERT INTO dww_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Taudi umanama giunama a vaivaiena, taudi Bada Yesu isane a babataitona. ");
INSERT INTO dww_vpl VALUES ("AC19_6","074_19_6","ACT","19"