﻿USE sofia;
DROP TABLE IF EXISTS sofia.dwrl_vpl;
CREATE TABLE dwrl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dwrl_vpl WRITE;
INSERT INTO dwrl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","S'oossay salotuwaanne sa'aa koyro med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","He wode sa'ay giigibeennanne ayaynne baynna mela; c'iimmuwaa bollan d'umay de'ee; S'oossaa Ayyaanay haatsaappe bollanna mayyi utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","S'oossay hewaappe guyye hawaadan yaagiide haasayeedda; «Poo'uu Hano» yaageedda; poo'uukka haneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Poo'uu lo\"a gideeddawaa S'oossay be'eedda; yaatiide poo'uwaa d'umaappe shaakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","S'oossay poo'uwaa «Gallassaa» giide suntseedda; d'umaa «K'ammaa» giide suntseedda. Sa'ay k'ammeeddanne wontteedda; hewenne koyro gallassaa. ");
INSERT INTO dwrl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","S'oossay hewaappe guyye hawaadan yaagiide haasayeedda; «Bollanna de'iyaa haatsaa garssanna de'iyaa haatsaappe shaakkiyaa saluwaa guufantsuu hano» yaageedda; geetettowaadankka haneedda. S'oossay saluwaa guufantsuwaa giigissiide, saluwaa guufantsuwaappe bollanna de'iyaa haatsaa garssanna de'iyaa haatsaappe shaakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","S'oossay he guufantsuwaa «Saluwaa» giide suntseedda. Sa'ay k'ammeeddanne wontteedda; hewenne laa'entso gallassaa. ");
INSERT INTO dwrl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","S'oossay hewaappe guyye hawaadan yaagiide haasayeedda; «Saluwaappe garssanna de'iyaa haatsay ittisaan eello; mela sa'ay k'onc'c'o» yaageedda; hewaappe guyyiyaan haneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","S'oossay he mela sa'aa «Biittaa» giide suntseedda; k'ay itti sa'aan eelleedda haatsaa «Abbaa» giide suntseedda. Yaatiide S'oossay hewe lo\"a gideeddawaa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hewaappe simmiide S'oossay, «Biittay mitsaa maataa dolisso; zeretsaa ayfii de'iyaa katsaanne zeretsaa ayfiyaana de'iyaa teeriyaa mitsaa dolisso» yaageedda; hewekka haneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Biittay, mitsaa maataa Aa k'ommuwaan k'ommuwaan doleedda. S'oossay hewe lo\"a gideeddawaa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Sa'ay k'ammeeddanne wontteedda; hewenne heezzentso gallassaa. ");
INSERT INTO dwrl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","S'oossay hewaappe guyye hawaadan yaagiide haasayeedda; «Gallassaa k'ammaappe shaakkanaw poo'otuu saluwaa guufantsuwaan hanino; unttuttu gallassaa, wodiyaanne laytsaa erissanaw mallaa gidino; ");
INSERT INTO dwrl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","sa'aa bollan poo'issana mala unttuttu saluwaa guufantsuwaan poo'ino» yaageedda; hewaappe guyyiyaan haneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","S'oossay laa\"u wolk'k'aama poo'otuwaa, dariyaawe gallassaa mooddanaadaninne k'eera\"iyaawe k'ammaa mooddanaadan med'd'eedda; s'oolinttetuwaakka I med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","S'oossay unttuttu ha sa'aa bollan poo'issana mala, gallassaanne k'ammaa mooddana malanne poo'uwaa d'umaappe shaakkana mala, saluwaa guufantsuwaan unttuntta wotseedda. Yaatiide S'oossay hewe lo\"a gideeddawaa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Sa'ay k'ammeeddanne wontteedda; hewenne oyddentso gallassaa. ");
INSERT INTO dwrl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","S'oossay hewaappe guyye hawaadan yaagiide haasayeedda; «De'uwaan de'iyaa dumma dumma med'etatuu haatsaan darino; kafuukka sa'aappe bollananne saluwaa guufantsuwaappe garssana paallo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Yaatiide S'oossay abbaan de'iyaa wolk'k'aamaa do'atuwaa, haatsaa giddon wos's'i k'aas's'iyaa med'etaa ubbaanne k'efiyaana de'iyaa kafuwaa ubbaa Aa k'ommuwaan k'ommuwaan med'd'eedda. S'oossay hewe lo\"a gideeddawaa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","S'oossay unttuntta, «Yelettite; c'orite; abbaa haatsaa kumite; kafuukka biittaa bollan c'oratto» yaagiide anjjeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Sa'ay k'ammeeddanne wontteedda; hewenne ichcheshentso gallassaa. ");
INSERT INTO dwrl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","S'oossay hewaappe guyye hawaadan yaagiide haasayeedda; «De'uwaan de'iyaa med'etatuu barenttu k'ommuwaan k'ommuwaan: mehetuu, biittaana gooshettiyaa med'etatuunne do'atuu barenttu k'ommuwaan k'ommuwaan biittaa bollan kesino» yaageedda; haneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","S'oossay do'atuwaa unttunttu k'ommuwaan k'ommuwaan, mehetuukka unttunttu k'ommuwaan k'ommuwaan, biittaana gooshettiyaa med'etatuwaakka ubbaa unttunttu k'ommuwaan k'ommuwaan med'd'eedda. S'oossay hewe lo\"a gidiyaawaa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hewaappe simmiide S'oossay, «Asaa nu leemisuwaan nuuna malattisiidde ane med'd'oytte; unttunttu abbaa moliyaa, saluwaa kafuwaa, biittaa bolla wos's'i k'aas's'iyaa med'etaa ubbaa mooddino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hawaadan S'oossay asaa bare leemisuwaan med'd'eedda; I asaa S'oossaa leemisuwaan med'd'eedda; I unttuntta attuma asaanne mac'c'a asaa ootsiide med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","S'oossay unttuntta hawaadan yaagiide anjjeedda; «Yelettite; c'orite; ha sa'aa kumitenne mooddite; abbaa moliyaa, saluwaa kafuwaanne biittaa bolla wos's'i k'aas's'iyaa, de'uwaan de'iyaa med'etaa ubbaa mooddite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hewaappe simmiide S'oossay, «Be'ite! Taani ha biittaa ubbaa bollan zeretsaa ayfiiyaana de'iyaa katsaa ubbaanne zeretsaa ayfiiyaana de'iyaa teeriyaa mitsaa ubbaa hinttenttoo immaad; unttunttu hinttenttoo k'uma gidana. ");
INSERT INTO dwrl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","K'aykka ha sa'aan de'iyaa mehiyawunne do'aa ubbaw, saluwaa kafuwaa ubbaw, biittaana gooshettiyaa med'etaa ubbawunne shemppuwaanna de'iyaa med'etaa ubbaw miyaawaa gidanaadan, irs's'a mitsaanne maataa immaad» yaageedda; haneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","S'oossay bare med'd'eedda ubbabaakka s'eelleedda; daro lo\"a gideeddawaa be'eedda. Sa'ay k'ammeeddanne wontteedda; hewenne usuppuntso gallassaa. ");
INSERT INTO dwrl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Salotuunne sa'ay unttunttun de'iyaawe ubbabay hawaadan med'etti poletteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","S'oossay bare ootseedda oosuwaa usuppuntsa gallassi poliide, bare ootseedda oosuwaa ubbaappe laappuntsa gallassi shemppeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","K'ay S'oossay laappuntsa gallassaa anjjeeddanne geeshsha ootseedda; ayaw gooppe, S'oossay bare ootsiyaa oosuwaa wurssiide shemppeeddawe he gallassaana. ");
INSERT INTO dwrl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Saluunne sa'ay med'etteeddawe hawaadaana. Med'inaa Goday S'oossay sa'aanne saluwaanne med'd'eedda wode, ");
INSERT INTO dwrl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","sa'aa bollan mitsaynne maatay dolibeenna; c'arshshaynne c'aaribeenna; ayaw gooppe, Med'ina Goday S'oossay iraa bukkissibeenna; k'ay biittaa ootsiyaa asaykka baawa. ");
INSERT INTO dwrl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Gidooppenne sa'aappe haatsay pude kesiide, biittaa ubbaa irs's'issee. ");
INSERT INTO dwrl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hewaappe guyye, Med'inaa Goday S'oossay biittaa baanaappe itti asaa med'd'iide Aa siid'iyaan de'uwaa shemppuwaa shemppi gelisseedda; yaatina bitanii de'uwaan de'iyaa asaa gideedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Med'inaa Goday S'oossay away doliyaa baggana Edene giyaa sa'aan gennetiyaa tokkeedda; yan bare med'd'eedda bitaniyaa wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Med'inaa Goday S'oossay s'eellanaw lo\"iyaa, maanawukka mal\"iyaa ubbaa k'ommo mitsaa biittaappe doliseedda. Gennetiyaa gidduwaan de'uwaa mitsaanne lo'uwaanne iitaa erissiyaa mitsaa wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Gennetiyaa ushshiyaa shaafaa haatsay Edeneppe goggee. Edeneppe keseeddawaappe guyye, oyddu shaafaa kes shaakettee. ");
INSERT INTO dwrl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Koyro shaafaa suntsay Pisoona; Pisooni work'k'ay de'iyaa Ewulaas'a giyaa biittaa ubbaa bollan goggee. ");
INSERT INTO dwrl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","He biittaa work'k'ay geeshsha work'k'aa; k'ay al\"o shittuunne loytsi lo\"iyaa shuchchay yan de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Laa\"entso shaafaa suntsay Giyoona; Giyooni Top'p'iyaa biittaa ubbaa bollan goggee. ");
INSERT INTO dwrl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Heezzentso shaafaa suntsay S'egiroosa; S'egiroosi Asooreppe away doliyaa baggana goggee. K'ay oyddentso shaafay Efiraas'iisa. ");
INSERT INTO dwrl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Bitanii Edene Gennetiyaa ootsana malanne naagana mala, Med'inaa Goday S'oossay Aa afiide wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Med'inaa Goday S'oossay bitaniyaa, «Gennetiyaa mitsaa teeraa ubbaappe neeni maana gooppe ma; ");
INSERT INTO dwrl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","shin lo\"uwaanne iitaa erissiyaa mitsaa teeraappe mooppa; ayaw gooppe, neeni aappe meedda gallassi tumu hayk'k'ana» yaagiide azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hewaappe guyye Med'inaa Goday S'oossay, «Bitanii barekka de'iyaawe lo\"a gidenna; taani aw injjetiyaanonne Aa maaddiyaano med'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Med'inaa Goday S'oossay mehetuwaa ubbaa, do'atuwaa ubbaanne saluwaa kafotuwaa ubbaa biittaappe med'd'eedda; k'ay bitanii unttuntta waagi suntsanenttonne be'anaw aakko aheedda; bitanii de'uwaan de'iyaa med'etaa ubbaa suntseedda suntsay unttunttu suntsaa gidiide atteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Hewaadan bitanii mehetuwaa ubbaa, saluwaa kafotuwaanne bazuwaa do'atuwaa ubbaa suntseedda; shin Addaamaw injjetiyaanne Aa maaddiyaawe beettibeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hewaa diraw Med'inaa Goday S'oossay bitaniyaa gem\"ishshuwaa kayroyeedda; I gem\"ishshuwaa kayrotti de'ishshin, Aa miyyiyaa mek'etsaappe ittuwaa akkiidde, he sa'aa ashuwaa kuntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Med'inaa Goday S'oossay bitaniyaappe akkeedda mek'etsaa mac'c'aano ootseedda; yaatiide izo bitaniyaakko aheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Yaatina bitanii, «Hayanaasho! Ha mek'etsatta ta mek'etsaappe, ha ashattakka ta ashuwaappe aketteeddawunno; izakka attuma asaappe aketeedda diraw, mac'c'awunno geetettu» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hewaa diraw Asay bare aawuwaanne bare aatto aggiide, bare machchattinna ittippe de'ana; unttunttu laa\"u itti asho gidanawantta. ");
INSERT INTO dwrl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Bitaniinne Aa machatanne laa\"attukka kallo s'iira de'ino; shin ittuu ittoo yeellattikkino. ");
INSERT INTO dwrl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Shooshshay Med'inaa Goday S'oossay med'd'eedda do'aa ubbaappe aad'd'eedda genanchcha. Itti gallassi shooshshay he mishiratto, «S'oossay tumu hinttentta, ‹Gennetiyaan de'iyaa mitsaa teeraa ubbaappe mooppite› geeddee?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Mishirata shooshshaw zaaraade, «Tuytti, S'oossay hawaadan gibeenna; nuuni gennetiyaan de'iyaa mitsatuwaa teeraa maanaw danddayeetto; shin S'oossay nuuna, Gennetiyaa gidduwaan de'iyaa mitsaa teeraa mooppite; bochchoppite; hewe d'ayooppe hinttenttu hayk'k'anita geedda» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Shooshshay mishiratto, «Tuytti, hinttenttu ayine hayk'k'ikitta; ");
INSERT INTO dwrl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","S'oossay hewaa geeddawe, he mitsaa teeraa hinttenttu mooppe, hinttenttu ayfii dooyettina, lo\"uwaanne iitaa S'oossaadan hinttenttu eranawaa I eriyaa diraassa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mishirata he mitsaa teeray maanaw mal\"iyaawaa, s'eellanaw lo\"iyaawaa, k'ay Asay aad'd'eedda eraa demmanaw amoyiyaawaa gidiyaawaa be'aaddu; he mitsaa teeraappe akkaade maaddu; k'ay barenana de'iyaa bare asinawukka hewaappe immina, ikka meedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Hewaappe unttunttu laa\"uwaa ayfiikka dooyetteedda; yaatina unttunttu barenttoo kallo s'iira de'iyaawaa ereeddino; balasiyaa giyaa mitsaa haytsaa sikkiide, barenttoo k'antsaan danc'c'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Sa'ay omarsseedda wode, gennetiyaa gidduwaan Med'inaa Goday S'oossay hamettishin, Aa kooshshaa bitaniinne Aa machata siseeddino; unttunttu gennetiyaa mitsaa giddon Med'inaa Godaa S'oossaappe k'osetteeddinno. ");
INSERT INTO dwrl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Shin Med'inaa Goday S'oossay bitaniyaa s'eesiide, «Addaamaa, hak'an de'ay?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Bitanii, «Gennetiyaa gidduwaan ne kooshshaa sisaadde, taani kallo de'iyaa diraw, yayaade k'osettaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Med'ina Goday S'oossay Aa, « ‹Neeni kallo de'aasa› giide new odeeddawe oonee? Taani neena, ‹Mooppa› gaade azazeedda mitsaa teeraappe maadiyyee?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Shin I, «Taananna de'anaadan neeni immeedda mac'c'awunna he mitsaa teeraappe taw immina maad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Med'inaa Goday S'oossay hewaappe guyye machchatto, «Neeni hewaa ayaw ootsaad?» yaagiide oochcheedda. Mishirata, «Taana shooshshay c'immina maad» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Med'inaa Goday S'oossay hewaappe guyye shooshshaa, «Neeni hawaa ootseedda diraw, mehiyaa ubbaanne do'aa ubbaa garssan ne s'alalay shek'k'etteeddawaa! Neeni ne uluwaan biittaana gooshettana; ne de'uwaa laytsaa ubbaan baanaa laac'c'ana. ");
INSERT INTO dwrl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Taani neenanne mishirato, ne zeretsaanne izi zeretsaa morkke kessana; I ne huup'iyaa k'os's'ana; neenikka Aa ginddiyaa dukkanaassa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Mishirattokka Med'inaa Goday S'oossay, «Ne shahaaro wode daro tuggatana; k'ay neeni wolk'k'aama oytsan naanaa yelana. Gidooppenne neeni ne asinaana de'anaw amottana; I neena mooddana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Bitaniyaakka Med'inaa Goday S'oossay hawaadan yaageedda; «Neeni ne machchatti oduwaa siseedda dirawunne taani neena, ‹He mitsaa teeraa mooppa› gaade azazeedda mitsaa ayfiyaa neeni meedda diraw, biittay ne gaasuwaan shek'etteeddawaa gido! Neeni ne de'uwaa laytsaa ubbaan wolk'k'aama daaburan biittaa goshaadde maana. ");
INSERT INTO dwrl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Biittay new aguntsaanne kashiyaa dolana; neeni woran doleeddawaa maana. ");
INSERT INTO dwrl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Neeni biittaw simmana gakkanaw, daaburan ne som\"i c'awattina ootseedda ne k'umaa maana; ayaw gooppe, neeni biittaappe aketaadda; neeni baana; neeni baanaw simmana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Addaame bare machchatto Hewaano giide suntseedda; ayaw gooppe, iza de'uwaan de'iyaa asaa ubbaw aatto. ");
INSERT INTO dwrl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Med'inaa Goday S'oossay Addaamawunne Aa machatiw c'alaa giigissiide unttuntta mayzzeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hewaappe guyye Med'inaa Goday S'oossay, «Simmi Asay nuuppe ittuwaadan lo\"uwaanne iitaa eriyaawaa gideedda. I bare kushiyaa yeddiide, de'uwaa mitsaappe akkiidde, k'ay meenna malanne med'inaw de'uwaan de'enna mala te'ettanaw koshshee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hewaa diraw, I bare aketeedda biittaa ootsana mala, Med'ina Goday S'oossay Edene Gennetiyaappe Aa keseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Aa kesi diggiide, de'uwaa mitsaakko afiyaa ogiyaa naagana mala, kiruubeela giyaa kiitanchchatuwaanne aad'd'i aad'd'i wod'd'iyaa tamaa lac'uwaa mashshaa Edene Gennetiyaappe away doliyaa baggana wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Addaami bare machchatti Hewaanina ak'eeda; iza shahaaro wode attuma na'aa yelaaddu; «Med'inaa Goday taana maaddina, attuma na'aa demmaad» gaade Aa K'aayeela suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","K'ay Aa ishaa Aabeela yelaaddu. Aabeeli dorssaa heemmee; k'ay K'aayeeli biittaa goshee. ");
INSERT INTO dwrl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Unddenna wodiyaappe guyye, K'aayeeli bare gaden doliyaa katsaappe Med'inaa Godaw yarshshuwaa yarshsheedda; ");
INSERT INTO dwrl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","shin Aabeeli bare dorssaa wudiyaa giddon bayira yeletteedda maratuwaappe akki shukkiide, unttunttu ashuwaappe mod'd'iyaawaa yarshsheedda. Med'inaa Goday Aabeelanne Aa yarshshuwaa akkeedda; ");
INSERT INTO dwrl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","shin K'aayeelanne Aa yarshshuwaa akibeenna. Hewaa diraw, K'aayeeli loytsi yiloteedda; bare deemuwaakka d'umisseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yaatina Med'inaa Goday K'aayeela, «Ayaw yilotay? Ne deemuukka ayaw d'umeedee? ");
INSERT INTO dwrl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Neeni lo\"obaa ootsowaa gidintto, ne som\"i pashikkennee? Shin neeni lo\"obaa ootsana d'ayooppe, nagaray do'aadan ne penggiyaan muggee; I neena mooddana koyee; shin neeni Aa s'oonana bessee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hewaappe guyye, K'aayeeli bare ishaa Aabeela, «Ane dembbaa boytte» yaageedda. Unttunttu dembban de'ishshin, K'aayeeli bare ishaa Aabeela bolla denddiide wod'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Med'inaa Goday K'aayeela, «Ne ishay Aabeeli hak'anee?» yaagiide oochcheedda. K'aayeeli zaariide, «Taani erikke; ta ishaa naagiyaawe taaneeyye?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Med'inaa Goday K'aayeela, «Hawaa ayaw ootsaad? Be'a; ne ishaa suutsay biittaappe taakko waassee. ");
INSERT INTO dwrl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ne kushiyaappe ne ishaa suutsaa akkiide, mittanaw hanggeedda biittaappe ha\"i neeni shek'etteeddawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Neeni goshinakka biittay new ayfena; betiyaadan neeni sa'aa bollan toyilakattanaassa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","K'aayeeli Med'inaa Godaa, «Poora! Neeni taana muriyaa muray taani ubbakka danddayennawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Hekko neeni taana hachche ha biittaappe yederssaassa; taani ne sintsaappe k'osettana; betiyaadan taani sa'aa bollan toyilakattana; taana demmowe ooninne wod'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Med'inaa Goday Aa, «Neena ooninne wod'ena; wod'ooppe, ne haluwaa aan laappun kushiyaa kesana» yaageedda. Hewaa diraw, demmowe ooninne Aa wod'enaadan Med'inaa Goday Aa bolla malaataa wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","K'aayeeli Med'inaa Godaa sintsaappe kesiide, Edene baggaappe away doliyaa baggana de'iyaa Nooda biittaan de'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","K'aayeeli bare machchattina ak'eeda; Iza shahaaro wode Heenooka yelaaddu. K'aayeeli katamaa he wode kees's'iide, he katamaa bare na'aa suntsan «Heenooka» giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Heenooki Iraada yeleedda; Iraadi Mahuyaa'eela yeleedda; Mahuyaa'eeli Matushaa'eela yeleedda; Matushaa'eeli Laameeka yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Laameeki Aadonne S'iilo giyaa laa\"u machatuwaa dawutsaa akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aada Yaabaala yelaaddu; Yaabaali mehiyaa mooddiyaa, dunkkaaniyaan de'iyaa asatuwaa aawuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Aa ishaa suntsay Yuubaala; Yuubaali k'ay diitsaa diis's'iyaanne uldduudiyaa punniyaa asatuwaa ubbaa aawuwaa; ");
INSERT INTO dwrl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","S'iila k'ay Tubaalik'ayna giyaa na'aa yelaaddu; Tubaalik'ayni nahaasiyaappenne birataappe dumma dumma miishshatuwaa k'os'iyaawaa. Tubaalik'ayna michchata Naa'imo. ");
INSERT INTO dwrl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Itti gallassi Laameeki bare machchetuwaa, «Aadee, S'iilee, sisite; ta machattoo, ane taani odiyaawaa hayzitte. Itti bitanii taana dechcheedda diraw, taani Aa wod'aad; ee, taani he taana masuntseedda wodallaa wod'aad. ");
INSERT INTO dwrl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","K'aayeela haluwaa kessanaw laappun kushii koshooppe, Laameeka haluwaa kessanaw laappun tammanne laappun kushii koshshee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Addaame bare machchattina gisina hara na'aa yelaade, «K'aayeeli wod'eedda Aabeela diraw S'oossay taw hara na'aa immeedda» gaade, Aa Seeta gaade suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seetikka attuma na'aa yeleedda; Aa «Heenoosa» giide suntseedda. Aasi Med'inaa Godaa suntsaa s'eesiide goyniyaawaa he wode doomeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Addaama yeletay hawaappe kaalliide s'aafetteedda. S'oossay asaa med'd'eedda gallassi barena malatisiidde med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","I attuma asaanne mac'c'a asaa ootsi med'd'iide, unttuntta anjjeedda. Unttuntta med'd'iide Asaa giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Addaami 130 laytsaa de'iide, barena malatiyaa attuma na'aa yeleedda; Aa «Seeta» giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Addaami Seeta yeleeddawaappe guyye, 800 laytsaa de'eedda; hara attuma naanaanne mac'c'a naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Addaami mule 930 laytsaa de'iide hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seeti 105 laytsaa de'iide, Heenoosa yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seeti Heenoosa yeleeddawaappe guyye, 807 laytsaa de'eedda; hara attuma naanaanne mac'c'a naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seeti mule 912 laytsaa de'iide hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Heenoosi 90 laytsaa de'iide, K'aynaana yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Heenoosi K'aynaana yeleeddawaappe guyye, 815 laytsaa de'eedda; hara attuma naanaanne mac'c'a naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Heenoosi mule 905 laytsaa de'iide hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","K'aynaani 70 laytsaa de'iide, Malaali'eela yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","K'aynaani Malaali'eela yeleeddawaappe guyye, 840 laytsaa de'eedda; hara attuma naanaanne mac'c'a naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","K'aynaani mule 910 laytsaa de'iide hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malaali'eeli 65 laytsaa de'iide, Yaareedda yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Malaali'eeli Yaareedda yeleeddawaappe guyye, 830 laytsaa de'eedda; hara attuma naanaanne mac'c'a naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Malaali'eeli mule 895 laytsaa de'iide hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaareed 162 laytsaa de'iide, Heenooka yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaareed Heenooka yeleeddawaappe guyye, 800 laytsaa de'eedda; hara attuma naanaanne mac'c'a naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaareed mule 962 laytsaa de'iide hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Heenooki 65 laytsaa de'iide, Maatusaala yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Maatusaala yeleeddawaappe guyye, Heenooki 300 laytsaa S'oossanna hamettiidde de'eedda; hara attuma naanaanne mac'c'a naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Heenooki mule 365 laytsaa de'eedda; ");
INSERT INTO dwrl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","I S'oossanna hamettiidde d'ayeedda; ayaw gooppe, S'oossay Aa afeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Maatusaali 187 laytsaa de'iide, Laameeka yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Maatusaali Laameeka yeleeddawaappe guyye, 782 laytsaa de'eedda; hara attuma naanaanne mac'c'a naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Maatusaali mule 969 laytsaa de'iide hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Laameeki 182 laytsaa de'iide, attuma na'aa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","«Ha na'ay Med'inaa Goday shek'k'eedda biittaa bollan nuuna nu kushiyaa oosuwaa daaburaappe shemppissana» giide Noha suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Laameeki Noha yeleeddawaappe guyye, 595 laytsaa de'eedda; hara attuma naanaanne mac'c'a naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Laameeki mule 777 laytsaa de'iide hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nohe 500 laytsaa de'iide, Seema, Kaamanne Yaafeeta yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Aasi sa'aa bollan dareedda wode, unttunttoo mac'c'a naanay yeletteeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","«Saluwaa Med'etatuwaa» geetettiyaawanttu ha asaa mac'c'a naanay malaa lo\"a gidiyaawaa be'eeddino; yaatiide unttunttuppe barenttoo dooreeddawantta akkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Med'inaa Goday, «Ta Ayyaanay asan med'inaw de'enna; ayaw gooppe, Asay hayk'k'iyaawaa; Aa laytsatuukka itti s'eetanne laatama gidana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","He wodenne hewaappe guyye Saluwaa med'etatuu asaa mac'c'a naanaa akkina, naanay yeletteedda wode, wogga adussa asatuu sa'aa bollan de'eeddino. Unttunttune beni wode olaw minanne eretteedda asaa. ");
INSERT INTO dwrl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Med'inaa Goday he wode sa'aa bollan de'iyaa asaa iitatetsay dareeddawaanne unttunttu wozanay k'oppiyaabay ubbay ubbaa wodekka iita s'alala gideeddawaa be'eedda; ");
INSERT INTO dwrl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Med'inaa Goday asaa ha sa'aa bollan med'd'eeddawoo kayyotteedda; bare wozanaan loytsi seeletteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Hewaa diraw Med'inaa Goday, «Taani med'd'eedda asaa ha sa'aa bollappe mule d'ayssana; asaa, mehiyaa, do'aa, biittaana gooshettiyaa med'etatuwaanne saluwaa kafotuwaa d'ayssana; ayaw gooppe, taani unttuntta med'd'eeddawoo kayyottaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Shin Nohe Med'inaa Godaa sintsan nashetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nohe haneeddabay hawaappe kaalliide s'aafetteedda. Nohe s'illo asaa; I bare wodiyaan de'eedda asaa giddon suure asaa; Nohe S'oossanna hametteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nohe Seema, Kaamanne Yaafeeta giyaa heezzu attuma naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","He wode biittay sa'ay S'oossaa sintsan tuneedda; sa'ay ubbay makkalan kumeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","S'oossay ha sa'aa s'eelleedda; sa'ay tuneeddawaa be'eedda; ayaw gooppe, sa'aan de'iyaa Asay ubbay bare ogiyaa tunissi wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Hewaa diraw, S'oossay Noha hawaadan yaagiide azazeedda; «Taani asaa ubbaa d'ayssana hanay; unttunttu gaasuwaan sa'ay makkalan kumeedda diraw, taani tumuppe asaakka sa'aakka d'ayssana. ");
INSERT INTO dwrl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Hewaa diraw, mino mitsaappe new markkabiyaa kees's'a; he markkabiyaa giddon c'ora k'ol\"otuwaa kessa; yaataade soonnanne karenna shidiyaan bara. ");
INSERT INTO dwrl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Markkabiyaa hawaadan yaataade kees's'a; adussatetsaa heezzu s'eetu wad'aa, gomppaa ishatamu wad'aa, geesaa hattamu wad'aa ootsa; ");
INSERT INTO dwrl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","markkabiyaw kaaraa med'd'a; kaaraappenne godaappe gidduwaan itti wad'aa gidiyaa sa'aa kallo agga basha; penggiyaa markkabiyaw miyiyaanna kessa; markkabiyaa heezzu pook'iyaa kessaade kees's'a. ");
INSERT INTO dwrl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«Taani saluwaappe garssan de'uwaa shemppuwaanna de'iyaa med'etaa ubbaa d'ayssanaw, ha sa'aa bollan bashshaa haatsaa yeddana; ha sa'aan de'iyaabay ubbay d'ayana. ");
INSERT INTO dwrl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Shin taani ta k'aalaa c'aak'k'uwaa neenana c'aak'k'ettana. Neeni ne machchatto, ne attuma naanaanne ne attuma naanaa machatuwaa neenanna akkaade markkabiyaa giddo gela. ");
INSERT INTO dwrl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Unttunttu neenana shemppuwaanna attana mala, shemppuu de'iyaa med'etaa ubbaappe k'ommuwaan k'ommuwaan attumawaanne mac'c'awaa laa\"uwaa laa\"uwaa akkaade, markkabiyaa giddo gelissa. ");
INSERT INTO dwrl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Dumma dumma k'ommo kafuwaappe, dumma dumma k'ommo mehiyaappenne biittaana gooshettiyaa dumma dumma k'ommo med'etatuwaa ubbaappe laa\"uwaa laa\"uwaa gidiide, shemppuwaanna attana mala neekko yaana. ");
INSERT INTO dwrl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","K'ay neeninne neenanna de'iyaawanttu maanaw, dumma dumma k'ommu miyaa katsaa Eefeera, markkabiyaa giddon k'ola» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nohe ubbabaakka S'oossay azazeeddawaadan ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Med'inaa Goday hewaappe guyye Noha hawaadan yaageedda; «Neeni ne soo asaa ubbaanna markkabiyaa giddo gela; ayaw gooppe, taani ha wodiyaa yeletaa giddon neeni s'illo gideeddawaa be'aaddi. ");
INSERT INTO dwrl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Neeni geeshsha gideedda mehiyaanne do'aa ubbaappe Aa k'ommuwaappe k'ommuwaappe attumawaanne mac'c'awaa laappunuwaa laappunuwaa, geeshsha gidenna mehiyaanne do'aa ubbaappe Aa k'ommuwaappe k'ommuwaappe itti attumawaanne itti mac'c'awaa, k'ay saluwaa kafuwaappe Aa k'ommuwaappe k'ommuwaappe attumawaanne mac'c'awaa laappunuwaa laappunuwaa ootsaade, sa'aa ubbaa bollan dumma dumma zeretsay shemppuwaanna attana mala neenana akkaade gela. ");
INSERT INTO dwrl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ayaw gooppe, laappun gallassaappe guyye, taani oytamu gallassaanne oytamu k'ammaa ha sa'aa bollan iraa bukissana; yaataade taani med'd'eedda med'etaa ubbaa sa'aa bollaappe d'ayssana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nohe Med'inaa Goday Aa azazeedda ubbabaa ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Bashshaa haatsay ha sa'aa bolla yeedda wode, Nohe laytsay usuppun s'eeta. ");
INSERT INTO dwrl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nohe, Aa attuma naanay, Aa machatanne Aa naanaa machchetuu bashshaa haatsaappe attanaw markkabiyaa giddo geleeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Geeshsha mehiyaappenne do'aappe, geeshsha gidenna mehiyaappenne do'aappe, kafuwaappenne biittaana gooshettiyaawanttu ubbaappe ");
INSERT INTO dwrl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","S'oossay Noha azazeeddawaadankka attumawenne mac'c'awe laa\"uwaa laa\"uwaa gidi, Nohekko yiide markkabiyaa giddo geleeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Laappun gallassaappe guyye, bashshaa haatsay ha sa'aa bollan yeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nohe usuppun s'eetu laytsaa de'ina, laa\"entsa aginaan, tammanne laappuntsa gallassan, he gallassan biittaa giddon de'iyaa wolk'k'aama c'iimmaa pulttuwaa ubbay d'uuk'k'i aggeeda; saluwaan de'iyaa haatsaa penggetuukka dooyetti wod'd'eeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Iray ha sa'aa bollan oytamu gallassaanne oytamu k'ammaa bukkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","He gallassan Nohenne Aa attuma naanay, Seeme, Kaamenne Yaafeeti, Nohe machatanne Aa naanaa heezzatuwaa machatuu ittippe markkabiyaa giddo geleeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Unttunttune do'aa ubbaappe bare k'ommuwaan k'ommuwaan, mehiyaa ubbaappe bare k'ommuwaan k'ommuwaan, sa'aanna gooshettiyaawanttu ubbaappe bare k'ommuwaan k'ommuwaan, kafuwaa ubbaappe bare k'ommuwaan k'ommuwaan, unttunttunna ittippe geleeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","de'uwaa shemppuwaanna de'iyaawanttu ubbay laa\"uwaa laa\"uwaa gidi, Nohekko yiide markkabiyaan geleeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","S'oossay Noha azazeeddawaadan, med'etaa ubbaappe attumawaanne mac'c'awaa gidiide, markkabiyaa giddo geli simmowaan, Med'inaa Goday markkabiyaa penggiyaa gorddeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Bashshaa haatsay oytamu gallassaa sa'aa bollan bukkiidde gam\"eedda; haatsay dariide, markkabiyaa biittappe pude dentseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Haatsay biittaa bollan loytsi darina, markkabii haatsaa bollan tooketteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Saluwaappe garssaana de'iyaa d'ok'k'a deretuu ubbay mitettana gakkanaw, haatsay ha sa'aa bollan loytsi wolk'k'aappe dareedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Haatsay deretuwaa s'eeraappe aad'd'iide, tammanne ichcheshu wad'aa gakkanaw tookeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yaatina sa'aa bollan shemppuwaanna k'aas's'iyaa med'etatuu ubbay: kafuu, mehii, do'ay, sa'aa bollan sham\"i giyaa med'etaa ubbaynne Asay ubbay hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ee, mela biittaa bollan de'iyaa, bare siid'iyaan de'uwaa shemppuwaa shemppiyaa ubbaykka hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ha sa'aan pas'a de'iyaabay ubbay: asay, mehiinne do'ay, biittaana gooshettiyaa med'etatuunne saluwaa kafotuu ubbaykka sa'aappe d'ayeeddino. Nohe s'alalaynne aanana markkabiyaa giddon de'iyaawanttu atteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","He haatsay s'eetanne ishatamu gallassaa gakkanaw sa'aa bollan gam\"eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Shin S'oossay Noha, aanana markkabiyaa giddon de'iyaa do'aa ubbaanne mehiyaa ubbaa k'oppeedda; sa'aa bollan c'arkkuwaa c'arkkisseedda; he haatsay wod'd'i wod'd'i beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","K'ay biittaa gidduwaan de'iyaa c'iimmuwaa pulttuunne saluwaan de'iyaa haatsaa penggetuu gorddetteeddino; iraykka saluwaan ek'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Yaatina haatsay wod'd'i wod'd'i beedda. He s'eetanne ishatamuntsa gallassaappe guyye, haatsay wod'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Haatsay wod'd'ina markkabii laappuntsa aginaan, tammanne laappuntsa gallassan Araaraate giyaa deretuwaa bolla utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Haatsay tammantsa aginay gakkanaw wod'd'i wod'd'i beedda; tammantsa aginaw koyro gallassi deretoo s'eeray beetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Oytamu gallassaappe guyye, Nohe bare kees's'eedda markkabiyaa maskkootiyaa dooyyeedda; ");
INSERT INTO dwrl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","yaatiide itti k'uuruwaa kare yeddina; k'uuruu haatsay biittaa bollappe melana gakkanaw, yaanne haanne paalliidde gam\"eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","K'ay Nohe haatsay biittaa bollappe wod'd'i wureeddenttonne be'anaw itti harap'p'atto kare yedeedda; ");
INSERT INTO dwrl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","shin he harap'p'atta haatsay biittaa ubbaa bollan ha\"ikka de'iyaa diraw, shemppiyaa sa'aa demmabeykku. Hewaa diraw simmaade, markkabiyaa giddon de'iyaa Nohekko yaaddu; I bare kushiyaa yeddiide, barekko markkabiyaa giddo akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Hewaappe guyye, hara laappun gallassaa gam\"iide, Dogomatto zaariidekka markkabiyaa giddoppe kessiide yeddeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","He harap'p'atta sa'ay omarssiyaa wode aakko simmaade yaaddu; wogaraa malatiyaa mitsaappe duutseedda irs's'a haytsaa bare doonaan sa\"a akkaade yaaddu. Hewaa diraw, haatsay biittaa bollappe wod'd'eeddawaa Nohe ereedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","K'ay Nohe hara laappun gallassaa gam\"iide, he harap'p'atto zaaretsiide yedeedda; shin he harap'p'atta aakko simmaade yabeykku. ");
INSERT INTO dwrl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nohe usuppun s'eetanne itti laytsaa de'ina, koyro aginaan koyro gallassi, haatsay biittaa bollappe s'i\"eedda; Nohe markkabiyaa k'um\"iyaa dooyi s'eelliide, biittay s'i\"eeddawaa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Laa\"entso aginaan laatamanne laappuntsa gallassan, biittay mule meleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","S'oossay he wode Noha hawaadan yaagiide azazeedda; ");
INSERT INTO dwrl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Neeni ne machchatto, ne attuma naanaanne ne naanaa machatuwaa akkaade markkabiyaa giddoppe kesa. ");
INSERT INTO dwrl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Unttunttu yelettiide, dariide c'orana mala, shemppuu de'iyaa med'etaa ubbaappe neenana de'iyaawantta: kafotuwaa, mehetuwaa, do'atuwaanne biittaana gooshettiyaa ubbaa neenana kessa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nohe bare attuma naanatuwaan, bare machchattinanne bare naanaa machchetuwaanna markkabiyaa giddoppe kesseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mehiyaanne do'aa ubbay, biittaana gooshettiyaa med'etaa ubbay, kafuwaa ubbaynne sa'aa bollan wos's'i k'aas's'iyaabaa ubbay bare k'ommuwaan k'ommuwaan markkabiyaa giddoppe keseeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nohe Med'inaa Godaw yarshshiyaa sa'aa gimbbeedda; geeshsha mehiyaanne do'aa ubbaappenne geeshsha kafuwaa ubbaappe akkiide, yarshshiyaa sa'aan s'uuggiide yarshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yaatina Med'inaa Goday yarshshuwaa peenuwaa sawiyaawaa singgiide, bare wozanaan hawaadan yaageedda; «Na'atetsaappe doommina, Asay wozanaan k'oppiyaabay ubbay iita gidooppenne, taani asaa diraw gaade laa'entso ubbakka ha sa'aa shek'k'ikke. K'ay taani ha\"i ootseeddawaadan pas'a de'iyaa med'etaa ubbaa laa'entso ubbakka d'ayssikke. ");
INSERT INTO dwrl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ha sa'ay de'eedda keeshshaa ubbaan, zeriyaa wodiinne c'akkiyaa wodii, meeguunne hombbii, boniinne balgguu, gallassaynne k'ammay ubbaadekka de'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","S'oossay Nohanne Aa attuma naanaa hawaadan yaagiide anjjeedda; «Yelettite; c'orite; sa'aa ubbaa kumite. ");
INSERT INTO dwrl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Sa'aa do'atuu ubbay, saluwaa kafatuu ubbay, gadiyaan wos's'i k'aas's'iyaabaa ubbaynne abban de'iyaa moletuu ubbay hinttenttoo yayyinonne dagammino. Unttunttu hinttenttoo aad'd'iide imetteeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","taani mokkiyaa dumma dumma katsatuwaa hinttenttoo immeeddawaadankka, shemppuu de'iyaa wos's'i k'aas's'iyaa med'etaa ubbay hinttenttoo k'uma gidana. ");
INSERT INTO dwrl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Shin suutsaa giddon shemppuu de'iyaa diraw suutsay Aa gidduwaan de'iyaa ashuwaa mooppite. ");
INSERT INTO dwrl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Taani hinttenttu shemppuwaanna de'iyaa hinttenttu suutsaa do'aa ubbaappe tumu achchana; k'ay asaa ubbaappe, Aa mala asaa suutsaa achchana. ");
INSERT INTO dwrl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","S'oossay asaa barena malatisiidde med'd'eedda diraw, asaa suutsaa gussiyaa oonanne gidooppenne, Aa suutsaykka asaa kushiyaan gukkanawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Hinttenttu yelettite; c'orite; sa'aan darite; an c'orite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hewaappe guyye, S'oossay Nohanne aanana de'iyaa Aa attuma naanaa, ");
INSERT INTO dwrl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","«Simmi ha\"i, taani ta c'aak'uwaa hinttenana, hintteppe guyye hinttenttu zeretsaannanne pas'a neenana de'iyaa med'etaa ubbaanna c'aak'k'etay; ee, taani ta c'aak'k'uwaa kafuwaanna, mehiyaanna, sa'aa do'aa ubbaananne, markkabiyaappe hinttenana keseedda, shemppuwaanna de'iyaa med'etaa ubbaanna c'aak'k'ay. ");
INSERT INTO dwrl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Taani hinttenana ta c'aak'k'uwaa c'aak'k'etay; hawaappe sintsan shemppuu de'iyaabay ubbay bashshaa haatsaan ubbakka bayenna; ha sa'aa bayzziyaa haatsay hawaappe sintsan ubbakka de'enna» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","K'aykka S'oossay, «Taani taappenne hintteppe, hinttenana de'iyaa pas'a med'etatuwaa ubbaappe gidduwaan yaana yeletaa ubbaanna c'aak'k'etiyaa c'aak'uwaa malaatay hawaa; ");
INSERT INTO dwrl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","taani ta zuluwaa shaariyaan essaad; I taappenne ha sa'aappe gidduwaan de'iyaa c'aak'k'oo mallaa gidana. ");
INSERT INTO dwrl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Taani sa'aappe bollan shaariyaa aheedda wodenne shaariyaan zuluu beetteedda wode, ");
INSERT INTO dwrl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","taappenne hintteppe shemppuu de'iyaa dumma dumma k'ommo med'etaa ubbaappe gidduwaan c'aak'k'eteedda ta c'aak'uwaa hassayana; pas'a de'iyaawaa ubbaa d'ayssanaw hawaappe sintsan ubbakka bashshaa haatsay yeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Zuluu shaariyaan beetteedda wode awudenne, taani Aa be'ana; taappe S'oossaappenne ha sa'aa bollan shemppuwaanna de'iyaa dumma dumma k'ommo med'etaa ubbaappe gidduwaan c'aak'k'eteedda med'ina c'aak'k'uwaa taani hassayana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","S'oossay Noha, «Taani taappenne ha sa'aa bollan shemppuwaanna de'iyaawaa ubbaappe gidduwaan c'aak'k'etteedda c'aak'k'uwaa malay hawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Markkabiyaappe keseedda Nohe attuma naanay Seema, Kaamanne Yaafeeta; Kaame Kanaane aawuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Hawanttu heezzuukka Nohe naanaa; sa'aan ubbaan de'iyaa Asay unttunttuppe yeletteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nohe goshshanchcha; I woyniyaa turaa toketsaa doommeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Itti gallassi I he woyniyaa eessaa ushiidde matsotteedda; bare dunkkaaniyaa giddon kallo s'iira giseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaane aawuwaa Kaame bare aawuwaa kalluwaa be'eedda; kare kesiide, bare laa\"u ishatoo odeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shin Seeminne Yaafeeti afilaa ittuwaa akkiide, laa\"attukka barenttu hashiyaana hashiyaana gatsi oyk'k'iide, guyyegutsaan hametti geliide, barenttu aawuwaa kalluwaa kammeeddino; unttunttu barenttu aawuwaa kalluwaa be'enna mala barenttu deemuwaa wora zaareeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nohe matsuu aad'd'ina beegottiide, Aa na'ay ubbaappe teefay Aa ootseeddawaa ereedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Aa, «Kanaane shek'etteeddawaa gido! I bare ishatoo wurssetsa ayiliyaa gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","K'aykka Nohe, «Med'inaa Goday, Seema S'oossay galatetto! Kanaane Seema ayiliyaa gido; ");
INSERT INTO dwrl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","S'oossay Yaafeeta biittaa aasso. Yaafeeta zaratuu Seema zaratuwaa giddon de'ino; Kanaane Yaafeeta ayiliyaa gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bashshaa haatsaappe guyye, Nohe 350 laytsaa de'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nohe mule 950 laytsaa de'iide hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nohe naanaa, Seema, Kaamanne Yaafeeta yeletay hawaappe kaalliide s'aafetteeddawaa; bashshaa haatsaappe guyye, unttunttoo attuma naanay yeletteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yaafeeta attuma naanay: Goomera, Maagooga, Maadaaya, Yaawaana, Tubaala, Meshekanne Tiiraasa. ");
INSERT INTO dwrl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Goomera attuma naanay: Ashkkanaaza, Riifaatanne Togarmma. ");
INSERT INTO dwrl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yaawaana attuma naanay: Eliisha, Tarsseese, Kitiimanne Rooda. ");
INSERT INTO dwrl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Hawanttuppe abbaa doonaan de'iyaa Asay ubbay bare gadiyaan gadiyaan, bare k'aalan k'aalan, bare yaran yaraaninne, bare kawutetsan kawutetsan shaaketteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kaama attuma naanay: Kuusha, Mis'irayma, Puus'anne Kanaana. ");
INSERT INTO dwrl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuusha attuma naanay: Saaba, Ewulaas'a, Saabita, Raa'imanne Sabttaka. Raa'ima attuma naanay: Saabanne Dadaana. ");
INSERT INTO dwrl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuushi Naamiruuda yeleedda; Naamiruudi ha sa'aan koyro wolk'k'aama olanchchaa gideedda; ");
INSERT INTO dwrl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Med'inaa Godaa sintsankka I wolk'k'aama shankkanchcha gideedda; «Naamiruudadan Med'inaa Godaa sintsan wolk'k'aama shankkanchcha gideedda» guussay hewaa diraassa. ");
INSERT INTO dwrl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Aa kawutetsay koyro katamati Sanaa'oore gadiyaan de'iyaa Baabloone, Ereeka, Akkaadanne Kalnna. ");
INSERT INTO dwrl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","I he biittaappe Asoore biide, Nenewe, Rohobootanne Kaalaha kees's'eedda; k'ay Nanaweppenne Kaalaahappe gidduwaan de'iyaa Reseena giyaa wolk'k'aama katamaakka kees's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Mis'irayme Ludetuwaa, Anaamaawatuwaa, Lahaabetuwaa, Nafttuuhetuwaa, Patiroosatuwaa, Kaasiluhetuwaanne Piliss's'eematuwaa zeretsatuwaa yeleedda Kafttooretuwaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","18","Kanaane bare bayira na'aa Sidoonanne Heeta yeleedda; k'ay Kanaane Yaabuusa asaa, Amoore asaa, Gerggeese asaa, Hiiwe asaa, Ark'k'e asaa, Siina asaa, Ariwaade asaa, S'amaare asaanne Hamaata asaa yeleedda. Hewaappe guyye, Kanaane zaratuu laalettina, ");
INSERT INTO dwrl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaane biittaa zaway Sidoonappe doommiide, Geeraarananne Gaazaanna aad'd'iidde, Sodoomaanne Gamoora, Adaamanne S'aboyma biide, Lashaa'an zawatee. ");
INSERT INTO dwrl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Kaame attuma naanay barenttu yaran yaran, barenttu k'aalan k'aalan, barenttu biittan biittaaninne barenttu kawutetsan kawutetsan s'aafetteeddawanttu hawantta. ");
INSERT INTO dwrl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemaw naanay yeletteeddino; I Yaafeetaw bayira ishaanne Eboora naanaa ubbaw mayza aawuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seema attuma naanay: Elaama, Asoora, Arifaakisaada, Luudanne Araama. ");
INSERT INTO dwrl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Araama attuma naanay: Uus'a, Huula, Geteeranne Mesheka. ");
INSERT INTO dwrl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arifaakisaadi Shelaaha yeleedda. Shelaahi Eboora yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebooraw laa\"u attuma naanay yeletteeddino. Ittuwaa suntsay Peeleega; ayaw gooppe, sa'aan de'iyaa Asay Aa wodiyaan shaakketeedda; Aa ishaa suntsay Yok'is'aana. ");
INSERT INTO dwrl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yok'is'aani naanaa yeleedda. Unttunttune: Almmodaada, Sheleefa, Has'armmaaweta, Yeraaha, ");
INSERT INTO dwrl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoraama, Uzaala, Diik'ila, ");
INSERT INTO dwrl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Oobaala, Abimaa'eela, Saaba, ");
INSERT INTO dwrl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiira, Hawiilanne Yobaaba. Hawanttu ubbaykka Yok'is'aana attuma naanaa. ");
INSERT INTO dwrl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Unttunttu de'eedda heeray Meeshappe biide away doliyaa baggana de'iyaa derii dariyaa gadiyaan Safaara gakkee. ");
INSERT INTO dwrl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Seema attuma naanay barenttu yaran yaran, barenttu k'aalan k'aalan, barenttu gadiyaan gadiyaaninne barenttu kawutetsan kawutetsan s'aafetteeddawanttu hawantta. ");
INSERT INTO dwrl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hawanttu barenttu yaran yaraaninne barenttu kawutetsan kawutetsan s'aafetteedda Nohe attuma naanaa zaratuwaa. Bashshaa haatsaappe simmiide, kawutetsatuwaa hawanttuppe sa'aa ubbaw yeletti aakkeeddinno. ");
INSERT INTO dwrl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sa'aa bollan de'iyaa Asay ubbay koyro itti doonaanne itti k'aalaa haasayiino. ");
INSERT INTO dwrl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Asatuu away kesiyaa bagga simmiide beedda wode, Sanaa'oore giyaa gadiyaan dembbaa ittuwaa demmiide yan, utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Unttunttu ittuu ittuwaa, «Haa yiite; s'uubiyaa med'd'iide, taman s'uuggoytte» yaageeddino. Unttunttu shuchchaa diraw s'uubiyaa, urk'k'aa diraw shidiyaa akkeeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","«Haa yiite; nu suntsaa s'eesissanawunne k'ay nuuni ha sa'aa ubbaa bollan laalettennaan attanaw itti wolk'k'aama katamaanne s'eeray saluwaa gakkiyaa itti pook'iyaa nuw kees's'oytte» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Shin Goday asatuu kees's'eedda wolk'k'aama katamaanne pook'iyaa be'anaw duge wod'd'eedda; ");
INSERT INTO dwrl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Med'inaa Goday «Hekko unttunttu itti asaa; k'ay unttunttu ubbaykka itti k'aalan haasayiino; unttunttu ha\"i hawaa ootsanaw doommowaappe guyye, unttunttu barenttoo ootsanaw k'oppowaa unttunttoo danddayettenawe ayaynne baawa. ");
INSERT INTO dwrl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Haa yiite; duge wod'd'iide unttunttu ittuu haasayiyaa k'aalaa ittuu erenna mala, unttunttu k'aalaa dummayoyitte» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Med'inaa Goday unttuntta hewaappe sa'aa ubbaa bollan laalina, unttunttu he wolk'k'aama katamaa kees's'iyaawaa aggiisheedino. ");
INSERT INTO dwrl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Med'inaa Goday sa'aa asaa k'aalaa yan dummayeedda diraw, he katamay Baabeela geetetteedda. Goday unttuntta hewaappe sa'aa ubbaa bollan laaleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seema yeletay hawaappe kaaliide s'aafetteeddawaa. Bashshaa haatsaappe guyye, laa\"u laytsaa gidina, Seema laytsay 100 gideedda wode, Seemi Arifaakisaada yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Seemi Arifaakisaada yeleeddawaappe guyye, 500 laytsaa de'eedda; hara attuma naanaakka mac'c'a naanaakka yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arifaakisaadi 35 laytsaa de'iide, Shelaaha yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arifaakisaadi Shelaaha yeleeddawaappe guyye, 403 laytsaa de'eedda; hara attuma naanaakka mac'c'a naanaakka yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelaahi 30 laytsaa de'iide, Eboora yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shelaahi Eboora yeleeddawaappe guyye, 403 laytsaa de'eedda; hara attuma naanaakka mac'c'a naanaakka yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eboori 34 laytsaa de'iide, Peeleega yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eboori Peeleega yeleeddawaappe guyye, 430 laytsaa de'eedda; hara attuma naanaakka mac'c'a naanaakka yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peeleegi 30 laytsaa de'iide, Raa'a yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peeleegi Raa'a yeleeddawaappe guyye, 209 laytsaa de'eedda; hara attuma naanaakka mac'c'a naanaakka yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Raa'u 32 laytsaa de'iide, Saruuga yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Raa'u Saruuga yeleeddawaappe guyye, 207 laytsaa de'eedda; hara attuma naanaakka mac'c'a naanaakka yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Saruugi 30 laytsaa de'iide, Naakoora yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Saruugi Naakoora yeleeddawaappe guyye, 200 laytsaa de'eedda; hara attuma naanaakka mac'c'a naanaakka yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naakoori 29 laytsaa de'iide, Taara yeleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naakoori Taara yeleeddawaappe guyye, 119 laytsaa de'eedda; hara attuma naanaakka mac'c'a naanaakka yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taari 70 laytsaa de'iide, Abraama, Naakooranne Haaraana yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Taara yeletay hawaappe kaaliide s'aafetteeddawaa. Taari Abraama, Naakooranne Haaraana yeleedda; Haaraani Loos'a yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haaraani bare aawuu Taari pas'a de'ishshin, bare yeletteedda Kaladaawetuwaa gadiyaan, Uura giyaa wolk'k'aama kataman hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abraaminne Naakoorinne laa\"attuukka akkeeddino; Abraamo machchatti suntsay Saaro; k'ay Naakoora machchatti suntsay Milkko; Milkka Haaraana naatto; Haaraani Milkkiwunne Yiskkaaniw aawuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saara mantsato; iziw na'i baawa. ");
INSERT INTO dwrl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taari bare na'aa Abraama, bare na'aa Haaraana na'aa Loos'anne, bare na'aa Abraamo machchatto Saaro akkiidde kesina, unttunttu ittippe Kanaane gadiyaa baanaw Uuri giyaa Kaladaawetuwaa katamaappe denddeeddino; shin unttunttu Kaaraane giyaa katamaa gakkanaw biide, yan utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Taari 205 laytsaa de'iide, Kaaraanen hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Med'inaa Goday Abraama yaageedda; «Neeni ne gadiyaappe, ne dabbotuwaappenne ne aawuwaa golle asaappe shaakettaade, taani neena bessiyaa gadiyaa ba. ");
INSERT INTO dwrl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Taani neena wolk'k'aama kawutetsaa ootsana; k'ay taani neena anjjana; taani ne suntsaa gitayana; yaatina neeni anjjo gidana; ");
INSERT INTO dwrl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","taani neena anjjiyaawantta anjjana; k'ay neena shek'k'iyaawantta taani shek'k'ana; ha sa'aa bollan de'iyaa Asay ubbay ne baggana anjjettana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abraame Med'inaa Goday aw odeeddawaadan denddiide beedda; Loos'ekka aanana beedda; Abraame Kaaraaneppe beedda wode, aw laytsay laappun tammanne ichchesha. ");
INSERT INTO dwrl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abraame bare machchatto Saaro, bare ishaa na'aa Loos'a, yan shiishsheedda barenttu mas'uwaa ubbaanne, Kaaraanen unttunttu demmeedda k'oomatuwaa akkiide, Kanaane gadiyaa baanaw denddeedda; biide unttunttu Kanaane gadiyaa gakkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abraame he gadiyaan Sekeema giyaa sa'aan de'iyaa Moore giyaa wolk'k'aama wolaa gakkanaw hametiidde beedda. He wode Kanaane asatuu he gadiyaan de'ino. ");
INSERT INTO dwrl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Shin Med'inaa Goday Abraamaw k'onc'c'iide Aa, «Ha gadiyaa taani ne zeretsaw immana» yaageedda. I barew k'onc'c'eedda Med'inaa Godaw he sa'aan yarshshiyaa sa'aa kees's'iide goynneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Hewaappe denddiide, Beeteeleppe away doliyaa baggana de'iyaa deretiyaa sa'aa biide, hewaan Beeteele away wulliyaa bagga aggiide, k'ay Ayi away doliyaa bagga aggiide, gidduwaan bare dunkkaaniyaa d'ogeedda; hewaan Med'inaa Godaw yarshshiyaa sa'aa kees's'iide, Med'inaa Godaa suntsaa s'eeseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hewaappe guyye, Abraame yaappe denddi biide Neegeeba bazzuwaa gakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","He wode he gadii koshateedda; koshay s'iis's'i de'iyaa diraw, Abraame amareeda wodiyaa de'anaw duge Gibis'e wod'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Gibis'e gelana hanishin, Abraame bare machchatto Saaro hawaadan yaageedda; «Sisa; neeni loytsa malaa lo\"o mac'c'a asaa gidiyaawaa taani eray. ");
INSERT INTO dwrl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Gibis'e asatuu neena be'iyaa wode unttunttu, ‹Hanna Aa machchatto› yaagiide unttunttu taana wod'ana; shin neena pas'a aggana. ");
INSERT INTO dwrl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Simmi unttunttu taw ne gaasuwaan keekana malanne, k'ay taani hayk'k'ennan ne gaasuwaan attana mala neeni, ‹Taani Aa michchato› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abraame Gibis'e biittaa geleedda wode, Gibis'e asatuu he mishirata daro malaa lo\"o mac'c'a asaa gidiyaawaa be'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","K'ay Gibis'e kaatiyaw ootsiyaa kaappatuukka izo be'eedda wode, kaatiyaa sintsan izo nashsheeddino; yaatiide izo kaatiyaa golle afeedino. ");
INSERT INTO dwrl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Yaatina izi gaasuwaan kaatii Abraama lo\"o ayfiyaan s'eelleedda; Abraamaw dorssatuwaanne booratuwaa, attuma haretuwaanne mac'c'a haretuwaa, attuma k'oomatuwaanne mac'c'a k'oomatuwaa, gaaluwaa immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Shin Med'inaa Goday Abraama machchatti Saari gaasuwaan Gibis'e kaatiyaa bollanne Aa soo asaa bolla daro kaa'iyaa harggiyaa yeddeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yaatina kaatii Abraama s'eesiide, «Neeni hawaa ayaw ta bolla ootsaad? iza ne machchatto gideeddawaa ayaw taw odabeykkii? ");
INSERT INTO dwrl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Neeni izo, ‹Iza ta michchato› gaade taw ayaw odaaddii? Taani izo taw machche ootsanaw akkeeddawe hewaa diraassa. Simmi ha\"i ne machchatto hanno be'a; izo akkaade ba» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Bare asaa azazina, unttunttu Abraama Aa machchattinanne aw de'iyaa ubbabaanna kessiide yeddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hewaa diraw Abraame bare machchattinanne, barew de'iyaawaa ubbaanna Gibs'eppe Negeeba bazzuwaa beedda; Loos'ekka aanana beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abraame he wode miizaa, biraaninne work'k'aan darii duretteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","I Negeebappe denddiide Beeteele gakkanaw beedda; he sa'aynne Beeteeleppenne Ayippe gidduwaan I koyro bare dunkkaaniyaa d'ogeedda sa'aanne ");
INSERT INTO dwrl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","yarshshiyaa sa'aa I koyro kees's'eedda sa'aa. Yan Abraame Med'inaa Godaa suntsaa s'eeseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abraamena yuuyyiyaa Loos'ewukka miizzay, dorssaa wudiinne dunkkaanii de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Shin unttunttu ittippe de'anaw unttunttoo biittay gidibeenna; unttunttoo daro mehii de'iyaa diraw, unttunttu ittippe de'anaw danddayibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hewaa gaasuwaan Abraamo wudiyaa heemmiyaawanttu giddoninne Loos'e wudiyaa heemmiyaawanttu giddon walassay kesseedda. He wode Kanaanatuunne Parzzetuu he gadiyaan de'ino. ");
INSERT INTO dwrl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Yaanina Abraame Loos'a, «Nuuni ishatuwaa gidiyaa diraw, ta giddoninne ne giddon, ta wudiyaa heemmiyaawanttu giddoninne ne wudiyaa heemmiyaawanttu giddon walassaa kessoppa. ");
INSERT INTO dwrl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Biittaa ubbay ne sintsan de'ennee? Ane nuuni shaakettoytte; neeni haddirssa bagga booppe, taani ushechcha bagga baana; neeni ushechcha bagga booppe, taani haddirssa bagga baana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loos'e yuuyyi aad'd'i s'eelliide, Yorddaanoosa Shaafaa wombbay ubbay biide Zoo'aara gakkanaw, Med'inaa Godaa gennetiyaa woy Gibis'e biittaa mala daro haatsay de'iyaawaa gidiyaawaa be'eedda. (Hewenne Med'ina Goday Sodoomanne Gamoora geetettiyaa katamato d'ayissanaappe kase). ");
INSERT INTO dwrl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hewaa diraw Loos'e barew Yorddaanoosa wombbaa ubbaa dooriide, away doliyaa bagga beedda; yaatina unttunttu ittuu ittiwaappe shaaketteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abraame Kanaane gadiyaan de'eedda; shin Loos'e wombban de'iyaa wolk'k'aama katamatuwaa gidduwaan uttiide, Sodooma katamaa matan bare dunkkaaniyaa d'ogeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","He wode Sodooma asatuu iitanne Med'inaa Godaa bolla pala nagaraa ootsiyaawantta. ");
INSERT INTO dwrl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Loos'e Abraameppe shaaketteeddawaappe guyye, Med'inaa Goday Abraama hawaadan yaageedda; «D'ok'k'u gaade neeni de'iyaasaappe away doliyaa bagganne away wulliyaa bagga, k'ay huup'issa bagganne gedissa bagga s'eella. ");
INSERT INTO dwrl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ha neeni s'eelliyaa biittaa ubbaa taani newunne ne zariyaw med'inaw immana; ");
INSERT INTO dwrl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","taani ne zariyaa sa'aa shafiyaadan darissana; ooninne sa'aa shafiyaa paydana danddayooppe, ne zariikka paydettana. ");
INSERT INTO dwrl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Dendda; biittaa gomppan pudenne dugenne hininne haanne hamettaadde be'a; ayaw gooppe, taani ha biittaa new immana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abraame bare dunkkaaniyaa shoddiide, Kebroone katamaan de'iyaa Mamire wolatuwaa woggatuwaa matan de'anaw beedda. Hewaan Med'inaa Godaw yarshshiyaa sa'aa kees's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","He wode Sanaa'oore Kaatii Amiraafeeli, Elaasaara Kaatii Ariyooki, Elaama Kaatii Kadorllaa'oomerinne Goyma Kaatii Tidi'aali oydduu, ");
INSERT INTO dwrl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Sodooma Kaatiyaa Beera'aara, Gamoora Kaatiyaa Birshshaara, Adaama Kaatiyaa Shin\"aabaara, S'aboyma Kaatiyaa Shemebeeraaranne (S'oo'aaro geetettiyaa) Belaa'a Kaatiyaanna olaw salppeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Hawanttu ichcheshu kaatetu gaketiide itti wolk'k'aa gidiide, (Mas'ine Abbaa giyaa) Siiddima Wombban shiik'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Unttunttu kase tammanne laa\"u laytsaa Kadorllaa'oomeraw moodetteeddino; shin tammanne heezzentsa laytsan aw makkaleeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tammanne oyddentso laytsan Kadorllaa'oomerinne aanana zuppeteedda kaatetu barenttu olanchchatuwaa akki biide, Asttaarooti s'arnnayman de'iyaa Raafaayeta, Haaman de'iyaa Zuuzetanne Shaawe-K'iriyaatayman de'iyaa Eemeta oliide s'ooneeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hoora biittaa asatuwaakka Se'iira Deriyaan oliide, bazzuwaa matan de'iyaa Elpparaana giyaa sa'aa gakkanaw yedersseeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hewaappe guyye simmiide, Ayin-Mishppaas'a yeeddino. (Ha\"i he sa'ay K'aadeesa geetettee.) Unttunttu Amaaleek'atuwaa biittaa ubbaanne k'ay Has'aas'oone Taamaara giyaa sa'aan de'iyaa Amooratuwaa oliide s'ooneeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hewaappe simmiide, Sodooma kaatii, Gamoora kaatii, Addaama kaatii, S'aboyma kaatiinne (S'oo'aaro geetettiyaa) Belaa'a kaatii denddeeddino; Siiddima Wombban salppeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Hawanttu ubbay Elaama kaatiyaanna, Goyma kaatiyaanna, Sanaa'oore kaatiyaannanne Elaasaara kaatiyaanna (ha ichcheshu kaatetu oyddu kaatetuwaanna) oletteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siiddima Wombban he wode, shidiyaadan oyk'k'iyaabay kumeedda ollay besseedda; Sodooma kaatiinne Gamoora kaatii barenttu olanchchatuwaanna olaappe bak'atishin, unttunttuppe amareedawanttu he ollatuwaan kunddeeddino; shin atteedawanttu deriyaa bak'ateeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Oyddu kaatetu Sodoomanne Gamoora katamatuwaa mas'uwaa ubbaanne unttunttu k'umaa ubbaa bonk'k'iide akkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abraamo ishaa na'ay Loos'e Sodooman de'iyaa diraw, aakka Aa mas'uwaakka akkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Hewaappe guyye, itti bitanii bak'ati yiide Ibraawiyaa Abraamaw hawaa odeedda. Abraame he wode, Eshkkolanne Aneera ishaa Amooriyaa Mamire wolaa matan de'ee. Unttunttu ubbaykka olaa zaaranaw Abraamena c'aak'k'uwaa c'aak'k'eti utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abraame bare dabbuu omoodetteeddawaa siseedda wode, olaa eriyaa bare son yeletteedda 318 asaa dentseedda; he oyddu kaatetuwaa kaalliidde Daani giyaa katamaa gakkanaw beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","K'amman bare asaa c'uguwaan c'uguwaan shaakki, bare morkkatuwaanna olettiide unttuntta s'ooneedda. Demask'k'oppe huup'issa baggana de'iyaa Hooba giyaa sa'aa gakkanaw yedersseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Mas'uwaa ubbaa, k'ay bare dabbuwaa Loos'anne Aa mas'uwaa, mac'c'a asaanne hara asaa wotsi akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abraame Kadorllaa'oomeranne aanana zuppeteedda kaatetuwaa s'ooniide simmeeddawaappe guyye, Sodooma kaatii, (Kaatetuwaa Wombbaa giyaa) Shaaweeha Wombban Aa mokkanaw keseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","He wode, Saleeme Kaatii Malkka-S'edek'k'i ukitsaanne woyniyaa eessaa akkiide yeedda; I Ubbaappe d'ok'k'iyaa S'oossaa k'eesiyaa. ");
INSERT INTO dwrl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","I Abraama hawaadan yaagiide anjjeedda; «Ubbaappe D'ok'k'iyaa S'oossay, saluwaanne sa'aa med'd'eeddawe Abraama anjjo. ");
INSERT INTO dwrl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","K'ay Ubbaappe D'ok'k'iyaa S'oossay, ne morkkatuwaa ne kushiyaan aatsi immeeddawe galatetto» yaageedda. Abraame ubbabaappe asiraataa kessiide, Malkka-S'edek'k'aw immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodooma kaatii Abraama, «Asaa taw immaade, mas'uwaa new akka» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Shin Abraame Sodooma kaatiyaa, «Taani Med'inaa Godaw, Ubbaappe D'ok'k'iyaa S'oossaw, saluwaanne sa'aa med'd'eddawoo, ta kushiyaa dentsaade c'aak'k'aad. ");
INSERT INTO dwrl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","24","Ta Asay meeddawaappenne taananna beedda Aneera, Eshkkolanne Mamire gakkiyaawaappe attina, neeni, ‹Abraama taani dureyaad› ubbakka geena mala, taani newaappe haray atto k'unc'c'uutiyaa woy c'aammaa k'achchiyaawaanne akkikke. Unttunttu barena gakkiyaawaa akkino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hewaappe guyye, Med'inaa Godaa k'aalay sas'aani Abraamekko yiide, «Abraamaa, yayyoppa! Taani new gonddalle; ne gatii loytsi dara» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abraame, «Abeet Ubbaa Mooddiyaa Med'inaa Godaw, taw ubbakka na'i baynna diraw, neeni immiyaa gatii taw ayissee? Demask'k'o El\"eezeri taana laattana shin» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","K'aykka Abraame, «Neeni taw na'aa immabaakka; hewaa diraw ta son de'iyaa k'oomay taana laattiyaawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Med'inaa Godaa k'aalay aakko yiide, «Ha k'oomay neena laattenna; shin ne gulbbataappe kesiyaawe neena laattana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Simmiide kare Aa kessiide, «Saluwaa pude s'eella; neeni s'oolinttetuwaa paydanaw danddayooppe payda; ne zeretsaykka hawaa keeshshaa gidana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abraamo Med'inaa Godaa ammaneedda; Med'inaa Goday hewaa aw s'illotetsaadan paydeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Med'inaa Goday k'aykka Aa, «Taani neeni ha biittaa laattana mala new immanaw Uuri giyaa Kaladaawetuwaa katamaappe neena kessa aheedda Med'inaa Godaattee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Shin Abraamo Aa, «Abeet Ubbaa Mooddiyaa Med'inaa Godaw, taani ha biittaa laattanawaa ayaan eroo?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Med'inaa Goday Aa, «Heezzu laytsaa ussaa, heezzu laytsaa deeshshaa, heezzu laytsaa dorssaanne laa\"u k'ommo harap'p'etuwaa taw akkaade ya» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","I hawantta ubbaa aw afeedda; unttuntta p'alk'k'iide laa\"u keseedda; laa\"uwaa keseeddawaa ittuwaa ittuwaa baggan wotseedda; shin kafotuwaa laa\"u kessi p'alk'k'ibeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","He wode ankkotu he ashuwaa bolla wod'd'eeddino; shin Abraame unttuntta yedersseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Away wulliyaa wode Abraama wolk'k'aama gem\"ishuu oyk'k'eedda; d'ip'p'i geedda d'umay Aa bolla wod'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yaatina Med'inaa Goday Aa, «Ne zeretsay hara gadiyaan bete gidiide de'anawaa neeni tumuppe era; unttunttu ayiletiide oyddu s'eetu laytsaa naak'ettana. ");
INSERT INTO dwrl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Shin ayileyiide unttuntta mooddiyaa kawutetsaa taani murana; hewaappe guyye, unttunttu daro ak'uwaana he biittaappe kessana. ");
INSERT INTO dwrl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Neena gidooppe, neeni ne mayza aawotuwaakko sarotetsaan baana; neeni loytsa c'imaade hayk'k'ananne moogettana. ");
INSERT INTO dwrl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Shin oyddentso yeletaan ne zeretsay ha gadiyaa simmana; ayaw gooppe, Amooretuu nagaray biro likkiyaa gakkibeenna» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Away wullina sa'ay d'umeedda; c'ooc'iyaa c'uwaynne tamaa lac'uu akeekenan beettiide, he laa\"u kessi p'alk'k'eteeddawanttuppe gidduwaana aad'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","He gallassi Med'inaa Goday Abraamena hawaadan yaagiide c'aak'k'uwaa c'aak'k'eteedda; «Gibis'e Shaafaappe doommiide Efiraas'iisa giyaa wolk'k'aama shaafaa gakkanaw, ha biittaa taani ne zeretsaw immaad; ");
INSERT INTO dwrl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","ha biittay K'eenatuwaa, K'eniizetuwaa, K'adimoonetuwaa, Hiitetuwaa, Parzzetuwaa, Raafaayetuwaa, Amooretuwaa, Kanaanetuwaa, Gerggeesetuwaanne Yaabuusatuwaa biittaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abraamo machata Saara aw na'aa yelabeykku; shin iziw Gibis'eppe yeedda Aggaaro giyaa itti ayilata de'aw. ");
INSERT INTO dwrl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Hewaa diraw Saara Abraama s'eesaade, «Be'a, Med'inaa Goday taw yeluwaa diggeedda. Neeni baade, ta ayilatina gisa; ooni erii, taani izi baggana na'aa daayo gidanenttonne» yaagaaddu. Abraame Saari k'aalaa sisiide mayyeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abraame Kanaane gadiyaan tammu laytsaa utteeddawaappe guyye, Abraamo machata Saara Gibis'eppe aheedda bare ayilatto Aggaaro, bare asinaa Abraamaw machchetetsaw immaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Aggaaro akkeedda; iza shahaaraaddu. Iza barew shahaaray atteedawaa ereedda wode, bare godatto kad'iyaa doommaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","He wode Saara Abraama, «Taana ha naak'uwaa naak'k'issiyaawe neena; taani ta ayilatto new immina, iza ha\"i barew shahaaray atteeddawaa eraade, taana kad'aw. Nebaanne tabaa Med'inaa Goday pirddo» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abraame Saaro, «Hanno be'a; ne ayilata ne kushiyaanna; neeni izo new lo\"owaa ootsa» yaageedda. Hewaappe guyye, Saara Aggaaro naak'k'ina, iza kesaade iippe bak'attaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Med'inaa Godaa kiitanchchay pulttuwaa matan woran Aggaaro demmeedda; he pulttuu Shura giyaa gadiyaa afiyaa ogiyaa mataana. ");
INSERT INTO dwrl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","I Aggaaro, «Hanne Saari ayilattee Aggaaree, hak'appe yaad? K'ay hak'a bay?» yaagiide oochcheedda. Iza, «Taani ta godatti Saarippe bak'atay» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Med'inaa Godaa kiitanchchay iziw, «Neeni ne godattikko guyye simmaade ba; iziw moodeta» yaagiide odeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","K'aykka Med'inaa Godaa kiitanchchay izo, «Ne zarii paydanaw danddayettennawaa keenaa taani c'orissana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","K'aykka Med'inaa Godaa kiitanchchay izo, «Ha\"i neeni shahaara; neeni attuma na'aa yelana; Aa Isimaa'eela gaade suntsana; ayaw gooppe, Med'inaa Goday ne waasuwaa siseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","I woran yeda de'iyaa hariyaa mala asaa gidana; asaa ubbaanna I ek'ettana; k'ay Asay ubbaykka aanana ek'ettana; I bare ishatuwaa ubbaanna is'o gidiide de'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Aggaara, «Taani taana be'iyaawaa be'aade pas'a attanee?» yaagaaddu; iza barew haasayeedda Med'inaa Godaa, «Neeni taana be'iyaa S'oossaa» yaagaade suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Hewaa diraw he pulttuwaa ollay, «Taana Be'iyaa De'uwaa S'oossaa Pulttuwaa» geetetteedda; he ollay hanno gakkanaw K'aadeeseppenne Baareedappe gidduwaan de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Aggaara Abraamaw attuma na'aa yelaaddu; Abraame Aggaara yeleedda na'aa Isimaa'eela giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aggaara Isimaa'eela Abraamew yeleedda wode, Abraamo laytsay hosppun tammanne usuppuna. ");
INSERT INTO dwrl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abraamo laytsay udduppun tammanne udduppuna gidiyaa wode, Med'inaa Goday aw k'onc'c'iide Aa, «Taani Ubbaa Danddayiyaa S'oossaa; neeni ta sintsan hametta; suure gidaa. ");
INSERT INTO dwrl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Taani taappenne neeppe gidduwaan ta c'aak'k'uwaa wotsay; taani neena loytsa c'orissana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abraame bare deemuwaan duge guufanneedda; S'oossay aw hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Simmi, taani neenana c'aak'k'etiyaa c'aak'uu hawaa; neeni daro kawutetsaa aawuwaa gidana. ");
INSERT INTO dwrl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hawaappe doommiide ne suntsay Abraama geetettenna; shin ne suntsay Abrahaama gidana. Ayaw gooppe, taani neena daro kawutetsaa aawuwaa ootsaad. ");
INSERT INTO dwrl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Taani neena loytsa c'orissana; taani neeppe kawutetsatuwaa med'd'ana; kaatetuukka neeppe kesana. ");
INSERT INTO dwrl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Taani taappenne neeppe, neeppe guyye ne zeretsaappenne gidduwaan, yeletaappe yeletaa gakkanaw ta c'aak'k'uwaa c'aak'k'etay; ha c'aak'k'uu taani newunne neeppe guyye ne zeretsaw S'oossaa gidana mala med'inaa c'aak'uwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ha\"i neeni bete gidaade de'iyaa Kanaane biittay ubbay newunne neeppe guyye ne zeretsaw med'inaw laata gidana mala taani immana; k'ay taani unttunttu S'oossaa gidana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","K'aykka S'oossay Abrahaama, «Neena gidooppe, neeni ta c'aak'uwaa naaga; neenikka neeppe guyye ne zeretsaykka, yeletaappe yeletaa gakkanaw naagite. ");
INSERT INTO dwrl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Taappenne neeppenne, neeppe guyye ne zeretsaappe gidduwaan hinttenttu naagana ta c'aak'uu hawaa; hinttenttu gidduwaan de'iyaa attumawe ubbay k'as's'aretto. ");
INSERT INTO dwrl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Hinttenttu attumatetsaa shookuwaa k'as's'arettiita; hewe taappenne hintteppe gidduwaan de'iyaa c'aak'k'oo mallaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Hinttenttu giddon sintsappe yelettana attuma naanay ubbay yeletteedda hosppuntsa gallassan k'as's'arettanaw koshshee. Ne soon yeletteeddawantta gidina, woy allagaappe shaluwaan shametteedda ayiletuwaa gidina, ne zeretsaa gidenawanttakka attumawantta k'as's'aranaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ne son yeletteeddawanttu ne shaluwaan shamettowanttu k'as's'arettino. Hawe hinttenttu ashuwaan de'iyaa ta c'aak'k'uu med'inaa c'aak'uwaa gidana. ");
INSERT INTO dwrl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","K'as's'arettibeenna, bare shookuwaanna de'iyaa attuma Asay ubbay bare asaappe duus's'ana; ayaw gooppe, I ta c'aak'uwaa mentseedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","K'aykka S'oossay Abrahaame, «Simmi, ne machchatti Saari suntsaa Saaray gooppa; hawaappe sintsaw izi suntsay Saaro. ");
INSERT INTO dwrl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Taani izo anjjana; taani iippe new attuma na'aa tumu immana. Izo taani anjjana; iza kawutetsatuwaa aatto gidana; asaa kaatetu iippe yaana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrahaame bare deemuwaan guufanneedda; I miic'c'iide bare wozanaan, «S'eetu laytsaa Asay tumu na'aa yelanee? K'ay udduppun tammu laytsaa gideedda Saara na'aa yelanee?» yaagiide k'oppeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahaame S'oossaa, «Isimaa'eeli taana laattiyaawaa gidanaw danddayennee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Shin S'oossay, «Tuytti, ne machata Saara new attuma na'aa tumuppe yelana; neeni Yisaak'a gaade Aa suntsana. Aappe guyye, Aa zeretsaw med'inaa c'aak'uwaa gidana mala, taani aanana ta c'aak'uwaa c'aak'k'etana. ");
INSERT INTO dwrl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","K'ay Isimaa'eelabaa gidooppenne, neeni oochcheeddawaa taani sisaad; taani aakka anjjana; taani Aa anjjananne Aa zeretsaa loytsa c'orissana; I tammanne laa\"u yeletatuwaa yelana; taani Aa zeretsaa wolk'k'aama kawutetsaa ootsana. ");
INSERT INTO dwrl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Shin taani ta c'aak'uwaa laytsi hannoode Saara new yeliyaa Yisaak'ana c'aak'k'etana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","S'oossay Abrahaamaana haasayiide wursseeddawaappe guyye, Abrahaameppe shaakettiide pude beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","He gallassan Abrahaame bare na'aa Isimaa'eela, bare son yeletteedda ubbaa, bare shaluwaan shammeeddawantta ubbaa, bare son de'iyaa attuma asaa ubbaa, S'oossay aw odeeddawaadan unttunttu attumatetsaa k'as's'areedda. ");
INSERT INTO dwrl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahaame bare attumatetsaa k'as's'arettiyaa wode, udduppun tammanne udduppun laytsaa asaa; ");
INSERT INTO dwrl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Aa na'ay Isimaa'eeli bare attumatetsaa k'as's'arettiyaa wode, tammanne heezzu laytsaa na'aa. ");
INSERT INTO dwrl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahaamenne Aa na'ay Isimaa'eeli laa\"attuukka he gallassi k'as's'aretteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Abrahaame son de'iyaa attuma Asay ubbay, Aa son yeletteeddawanttunne shaluwaan shammeeddawanttu ubbay aanana k'as's'aretteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abrahaame Mamire wolatuwaa wogatuwaa garssan bare dunkkaaniyaa penggiyaan seeta gallassi utti de'ishshin, Med'inaa Goday aw k'onc'c'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahaame d'ok'k'u giide s'eelliide heezzu asatuu Aa matan ek'k'eeddawantta be'eedda; unttunttunna gaketanaw bare dunkkaaniyaa penggiyaappe denddi wos's'eedda; gakkiide, gediyaan hokkiide, unttunttu sintsan goyneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Simmiide I, «Abeet ta Godaw, taani ne sintsan nashshetteedawaa gidooppe, taana ne k'oomaa aggaade aad'd'oppa. ");
INSERT INTO dwrl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Hayanaa guutsa haatsay yo; hinttenttu gedii meec'ettina, ha mitsaa kuwaan shemppi akkite. ");
INSERT INTO dwrl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Hinttenttu ha\"i taakko hinttenttu k'oomaakko yeedda diraw, kam\"i giide hinttenttu biyaasa'aa baana mala, taani hinttenttoo miyaawaa ahay» yaageedda. Unttunttu, «Daro lo\"a; neeni giyaawaadan ootsa» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abrahaame dunkkaaniyaa giddo Saarikko elleelli biide, «Elleellaade liik'o d'iiliyaappe heezzu kere gidiyaawaa akka munak'aade ukitsaa uukka» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","K'ay, Abrahaame bare mehiyaakko wos's'i biide, lo\"o bolttiboltta bolttiboltta maraa dooriide, itti k'oomaw immina, I elleelli shukkiide giigisseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Yaatina Abrahaame me\"eedda maatsaanne giigisseedda maraa ashuwaa imatsatuwaa sintsa aatseedda; unttunttu miishshin, I he mitsaa garssan unttunttu matan ek'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Unttunttu Aa, «Ne machata Saara hak'anee?» yaagiide oochcheeddino. Iza, «Hini dunkkaaniyaa gidduwaan de'aw» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Med'inaa Goday Aa, «Taani laytsi hannoode tumu neekko simmana; he wode ne machata Saara attuma na'aa yelana» yaageedda. Saara he wode aappe guyye baggana de'iyaa dunkkaaniyaa penggiyaan de'iyaana hewaa sisaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahaamenne Saara barenttu laytsaa loytsi sugiide c'imeeddino. Saariw piilay yiyaawaa aggeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Hewaa diraw Saara bare wozanaan, «Taani ha\"i c'ima wura kichchowaappe guyyiyaaninne ta goday c'imowaappe guyye, ha\"i taw attuma asaana gaketiyaawe waan hananee?» yaagaade miic'c'aaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Med'inaa Goday Abrahaame he wode, « ‹Taani c'ima kichchowaappe guyye, tumu na'aa yelanitaayye?› gaade, Saara ayaw miic'c'aade? ");
INSERT INTO dwrl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Med'inaa Godaw danddayettennabay tumu de'ii? Laytsi hannoode taani neekko simmana; he wode Saara attuma na'aa yelana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saara loytsa yayyeedda diraw, «Taani miic'c'abeykke» yaagaade lakaaddu. Shin I, «Ee, neeni tumu miic'c'aadda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hewaappe guyye asatuu denddiide bi, Sodooma katamaa duge zaari s'eelleeddino; Abrahaamenne unttuntta moyzziide unttunttunna beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Med'inaa Goday he wode, «Taani ta ootsanaw haniyaabaa Abrahaameppe k'osikke. ");
INSERT INTO dwrl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abrahaame tumuppe gitanne wolk'k'aama kawutetsaa gidana; ha sa'aa kawutetsatuu ubbay Aa baggana anjjettana. ");
INSERT INTO dwrl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ayaw gooppe, s'illotetsaanne pirddaa ootsiide, Med'inaa Godaa ogiyaa naaganaadan bare naanaanne bareppe guyye, bare soo asaa I zorana mala, taani Aa dooraad; hewenne Med'inaa Goday Abrahaamew immana geeddawaa ubbaa polanaassa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","21","Med'inaa Goday Abrahaame, «Sodoomappenne Gamoorappe waassiyaa waasuu loytsi dareedda dirawunne unttunttu nagaray loytsi dees'eedda diraw, unttunttu ootseeddabay taakko gakkeedda waasuwaa keeshshaa iitenttonne be'anaw ane taani duge wod'd'ay; hewaa mala iita gidana d'ayinttonne erana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Hewaappe guyye, laa\"u asatuu Sodoomakko simmiide beeddino; shin Abrahaame Med'inaa Godaa sintsan woosi de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","He wode Abrahaame Med'inaa Godaakko shiik'iide yaageedda; «Tumu neeni s'illotuwaa iitatuwaana d'ayssay? ");
INSERT INTO dwrl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","He wolk'k'aama katamaan ishatamu s'illotuu de'inttokka, neeni d'ayssay? Neeni aan de'iyaa ishatamu s'illotuwaa diraw he katamaa ashshikkii? ");
INSERT INTO dwrl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Hewe neeppe haakko; s'illotuwaa iitatuwaana wod'iyaawenne s'illotuwaanne iitatuwaa itti ayfiyaan s'eelliyaawe neeppe haakko. Ha sa'aa ubbaa pirddiyaawe s'illuwaa pirddenneeyye?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Med'inaa Goday, «He Sodooma kataman ishatamu s'illotuu de'ooppe, he sa'aa ubbaa unttunttu diraw taani ashshana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Hewaappe guyye Abrahaame, «Taani biittanne bidintsaa gidaadde ta Godaana s'alaade haasayanaw simmi doomma kichchaad; ");
INSERT INTO dwrl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ishatamu s'illotuwaappe ichcheshu pac'c'intto, neeni he ichcheshatuwaa diraw he katamaa ubbaa d'ayssay?» yaageedda. Med'inaa Goday, «Taani yan oytamanne ichcheshu s'illotuwaa demmintto, he katamaa d'ayisikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahaame zaaretsiidekka, «Yan oytamu s'alalay beettintto shin?» yaageedda. I, «Taani he oytamatuwaa diraw, he katamaa d'ayisikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Hewaappe guyye I, «Hay Goday taw hank'k'ettoppo; taani gujjaadekka haasayay. Yan hattamu s'alalay beettintto shin?» yaageedda. Med'inaa Goday, «Taani yan hattamuwaa demmintto, he katamaa d'ayssikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahaame k'aykka, «Taani Godaana s'alaade haasayanaw doomma kichchaad; yan laatamuwaa s'alalay beettintto shin?» yaageedda. Med'inaa Goday, «He laatamatuwaa diraw taani Aa d'ayssikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Hewaappe guyye Abrahaame, «Hay Goday taw hank'k'ettoppo; taani mes's'i itti gede haasayay; yan tammu s'alalay beettintto shin?» yaageedda. Med'inaa Goday, «He tammatuwaa diraw taani he katamaa d'ayssikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Med'inaa Goday Abrahaamena haasayaa wursseeddawaappe guyye beedda; Abrahaamekka bare soo simmeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","He laa\"u kiitanchchatuu omarssi Sodooma katamaa gakkeeddino; he wode Loos'e he katamaa penggiyaan utteedda. Loos'e unttuntta be'inne unttunttunna gaketanaw ek'k'iide beedda; bare deemuwaa sa'aa gatsiide goyneedda; ");
INSERT INTO dwrl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","«Ta godatoo, hinttenttu k'oomaa soo simmeerikkitee; hinttenttu gediyaa meec'ettiide k'ammaa ak'ite; guuran denddiide hinttenttu biyaasa'aa baanita» yaageedda. Unttunttu, «Tuytti; nuuni ha katamaa dabaabaan ak'ana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Shin I unttuntta loytsi shoobbeedda diraw, aanana biide Aa soo geleeddino; I unttunttoo k'umaa katsiide, c'aalenna ukitsaa uukkiide aatsina, unttunttu meeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Unttunttu gisennan de'ishshin, Sodooma katamaa attuma Asay ubbay, naanatuwaappe c'imaa gakkanaw, ittuunne attenaan yiide, golliyaa yuuyyi aad'd'i dooddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Loos'a s'eesiide yaageeddino; «Hachche k'amma ne soo yeedda attuma asatuu hak'an de'iinoo? Nuuni unttunttunna sharmus'ana mala unttuntta nuukko kare kessa» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loos'e unttunttunna gaketanaw kare kesiide, kariyaa guyye gorddeedda; ");
INSERT INTO dwrl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","unttuntta hawaadan yaageedda; «Ta ishatoo, ha iita oosuwaa ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Simmi taw laa\"u mac'c'a naanay, attuma asaa eribeenna wodoratuu de'iino; taani unttuntta hinttenttoo kare kessay; hinttenttu unttuntta hinttew lo\"owaadan ootsana danddayiita. Shin ha asatuwaa bolla ayinne ootsoppite; ayaw gooppe, unttunttu ta golle geliide ta kaaraa garssan de'iino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Asatuu Aa, «Nu sintsaappe kichcha!» yaageeddino; k'aykka unttunttu, «Ha bitanii ha gadiyaan bete gidi yiide, ha\"i nu bolla pirddanaw kajjeeleedda! Ha\"i nuuni neena unttunttu bolla ootsanaw k'oppeeddawaappe iitaa ootsana!» yaageeddino. Unttunttu Loos'a guyye sugi yeggiide penggiyaa mentsanaw shiik'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Shin he laa\"u asatuu barenttu kushiyaa kare yeddiide, Loos'a soo goochchi gelissiide penggiyaa gorddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hewaappe guyye, unttunttu golle penggiyaan de'iyaa asaa, guutsaappe gitaa gakkanaw k'ook'isseeddino. Yaatina unttunttu penggiyaa demmanaw koyiide daabureeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","He laa\"u asatuu Loos'a, «New hawaan ne mac'c'a naanaa giigisseeddawanttu, ne attuma naanay woy ne mac'c'a naanay woy nebaa gideedda Asay oona gidooppene ha katamaan de'ii? Unttuntta hawaappe kessa digga. ");
INSERT INTO dwrl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ayaw gooppe, nuuni ha sa'aa d'ayssana haneetto. Unttunttu waassiyaa waasuu Godaa sintsan loytsi dareedda diraw, Med'inaa Goday nuuna ha katamaa d'ayssanaw kiitteedda» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Hewaa diraw Loos'e kesiide, bare mac'c'a naanaa giigisseeddawanttukko biide unttuntta, «Elleelli denddiide hawaappe kesite; ayaw gooppe, Med'inaa Goday ha katamaa d'ayssana hanee» yaageedda. Shin Aa mac'c'a naanaa giigisseeddawanttu I k'id'd'eedda giide k'oppeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Sa'ay wonttanaw holjjojji zo\"iyaa wode, he kiitanchchatuu Loos'a, «Dendda! Ne machchattonne hawaan de'iyaa ne laa\"u mac'c'a naanaa akkaade elleella kesa! Hewe d'ayooppe, ha katamay pirddettiyaa wode neenikka d'ayaassa» yaagiide dirbbiseeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Shin Loos'e yatti giina, he asatuu Aa kushiyaa, Aa machchatti kushiyaanne Aa mac'c'a naanaa laa\"uwaa kushiyaa oyk'k'iide, he katamaappe unttuntta kesseeddino; ayaw gooppe, Med'inaa Goday unttunttoo k'aretteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kiitanchchatuu unttuntta katamaappe kesseedda saannakka, he kiitanchchatuwaappe ittuu yaageedda; «Hinttenttu shemppuwaa akkiide bak'atite! Guye s'eelloppite! K'ay ha wombban hak'ankka ek'k'oppite! Deriyaakko bak'atite! Hinkkoode hinttenttu d'ayana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Shin Loos'e unttunttoo yaageedda; «Tuytti! Hay ta godatoo, yaagoppite. ");
INSERT INTO dwrl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Taani hinttenttu k'oomay hinttenttu sintsan nashshetteeddawaa diraw, taana ashshanaw taw daroppe loytsi maadeeddita. Shin taani deriyaakko bak'atanaw danddaykke; hawe bashshay gakkiide taana muukkananne taanikka hayk'k'ana. ");
INSERT INTO dwrl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","S'eellite; hawaan itti katamay de'ee; I wos's'anaw matanne guutsa katamaa. Taani yaa bak'atoo? I k'eeri guutsa katamaa gidennee? Ta shemppuu yan attanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kiitanchchay, «Ee, taani ne ooshaa sisana; taani neeni giyaa katamaa d'ayssikke. ");
INSERT INTO dwrl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Shin yaa elleella bak'ata; ayaw gooppe, neeni yaa gakkanaw, taani ayinne ootsanaw danddaykke» yaageedda. Hewaa diraw he katamaa suntsay zoo'aaro geetetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Loos'e S'oo'aaro gakkeedda wode, biro s'alk'k'ii doleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Med'inaa Goday he wode tamaanne ees's'iyaa diiniyaa Sodoomanne Gamoora bollan Med'inaa Godaa mataappe saluwaappe bukiide bayzzeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hewaadan ootsiide Med'ina Goday he katamata, he wombbaa ubbaa, he katamatuwaa giddon de'iyaa ubbaanne he gadiyaan de'iyaa mitsaa maataa d'aysseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Shin Loos'e machata guyye s'eellaade mas'ine tuussaa gidaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wonttetsa gallassi wontta guuran Abrahaame denddiide, Med'inaa Godaa sintsan kase I ek'k'eedda sa'aa simmiide beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","I Sodoomanne Gamoora he zanggaaraan de'iyaa biittaa ubbaa duge s'eelleedda; he wode c'uway c'ooc'iyaa tamaa c'uwaadan he biittaappe denddiyaawaa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","S'oossay he zanggaaraa katamatuwaa d'aysseedda wode, Abrahaama hassayeedda; Loos'e de'eedda katamatuwaa d'ayssiide Loos'a bashshaappe keseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loos'e zoo'aaran uttanaw yayyeedda diraw, bare mac'c'a naanaa laa\"uwaanna deriyaa keseedda; gonggolo giddon bare laa\"u mac'c'a naanatuwaanna utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Itti gallassi bayira naatta teefatto, «Nu aawuu c'imeedda; sa'aa ubbaan de'iyaa wogaadan nuunana gisanaw ha gadiyaan ubbakka attuma Asay baawa. ");
INSERT INTO dwrl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Haaya; woyniyaa eessaa nu aawuwaa ushshiide, aanana gisiide, nu aawuwaappe nu zariyaa turaa ashshooytte» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","He gallassaa k'amma barenttu aawuwaa woyniyaa eessaa ushsheeddino; bayirata gelaade aanana gisaaddu; iza aanana gisiyaa wodekka denddiyaa wodekka I eribeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wonttetsa gallassi bayirata teefatto, «Sisa; zino taani ta aabunna gisaad; hachche k'amma k'ay woyniyaa eessaa ushshina, neenikka gelaade aanana gisa; yaatiide nuuni nu aawuwaappe nu zariyaa turaa ashshoytte» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","He gallassi k'amma k'aykka woyniyaa eessaa ushsheeddino; teefatakka gelaade aanana gisaaddu; iza aanana gisiyaa wodekka denddiyaa wodekka I eribeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Yaatide Loos'e mac'c'a naanay laa\"attuukka barenttu aawuwaappe shahaareeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Bayirata attuma na'aa yelaaddu; Aa suntsaa Moo'aaba gaade suntsaaddu; inne hachche gakkanaw Moo'aabatuwaa aawuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","K'ay teefattakka attuma na'aa yelaaddu; Aa suntsaa Ben\"aama gaade suntsaaddu; inne hachche gakkanaw Amoonatuwaa aawuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahaame Mamireppe denddiide, Negeeba giyaa gadiyaa beedda; K'aadeesanne Shura giyaa katamatuwaappe gidduwaan de'eedda; Garaarankka amareeda wodiyaa takkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Yan Abrahaame bare machchatto Saaro, «Aa ta michchato» yaageedda. Garaara Kaatii Abimeleeki kiittiide Saaro afeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Shin S'oossay itti k'amman akumuwaan Abimeleekekko yiide, Aa hawaadan yaageedda; «Neeni aheedda machati gaasuwaan hayk'k'aasa; ayaw gooppe, iza asaa machchatto» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Shin Abimeleeki iikko shiik'ibeenna. Yaateeddawe, «Godaw, neeni s'illo kawutetsaa d'ayssaniiyye? ");
INSERT INTO dwrl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","I, ‹Iza ta michchato› gibeenneyye? K'ay iza, ‹I ta ishaa› gabeykkee? Taani ta wozanaa suuretetsaaninne ta kushiyaa geeshshatetsaan hawaa ootsaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Hewaappe guyye, S'oossay akumuwaan Aa yaageedda; «Ee, neeni ne wozanaa geeshshatetsaan ootseeddawaa taani eraad; hewaa diraw, neeni izo bochchenna malanne ta sintsan nagaraa ootsenna mala neena taani te'aad. ");
INSERT INTO dwrl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ha\"i ha bitaniyaa machchatto zaara; ayaw gooppe, I Timbbitiyaa odiyaawaa; I new S'oossaa woosana; neeni pas'a de'ana. Shin izo zaarana d'ayooppe, neeninne new de'iyaabay ubbay hayk'k'iyaawaa tumuppe era» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleeki wonttetsa gallassi wontta bare kawutetsaa kaappatuwaa ubbaa s'eeseedda; ha yewuwaa ubbaa unttunttoo odina, unttunttu loytsi daro yayyeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Yaatina Abimeleeki Abrahaama s'eesiide, «Neeni ayaa nu bolla ootsaaddii? Neeni ta bollanne ta kawutetsaa bolla wolk'k'aama nagaraa ahanaw taani new ay iitabaa ootsaadditaa? Neeni ta bolla oosetanaw bessenabaa ootsaadda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","K'aykka Abimeleeki Abrahaama, «Neena hawaa oosisseeddawe ayee?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahaame yaageedda; « ‹S'oossaw yayyiyaa itti asaynne ha sa'aan baawa› gaade k'oppeedda diraassanne, ‹Ta machchatti gaasuwaan unttunttu taana wod'ana› gaade k'oppeedda diraassa. ");
INSERT INTO dwrl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Hewaa bolla iza tumukka ta michchato; ta aati naatto gidukkuppe attin, ta aabbu naatto; k'ay iza ta machchatto gidaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","S'oossay taana ta aawuwaa golliyaappe kesseedda wode taani iziw, ‹Nuuni beedda gadiyaan ubbaan neeni taw ootsana keekatetsay hawaa; «I ta ishaa» gaade tabaa haasaya› yaagaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Hewaappe guyye Abimeleeki dorssaa, mehiyaa, mac'c'a ayiletuwaanne attuma ayiletuwaa ahiide, Abrahaamew immeedda; k'ay Aa machchatto Saaro aw zaareedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleeki, «Simmi ta biittay ne sintsaana; neena lo\"osan de'a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saarokka, «Taani ne ishaw itti sha\"a s'agaraa biraa immay; hawe simmi neenana de'iyaa ubbaa sintsan neeni s'illatto gidiyaawaanne neeni shatimmeeddawaa erissiyaawaa gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Med'inaa Goday Abrahaame machchatti Saari gaasuwaan Abimeleeka golle asaa ubbaa k'antsaa maynissi wotseedda diraw, Abrahaame S'oossaa woossina, Abimeleeki, Aa machatanne Aa mac'c'a k'oomatuwaa na'aa yelana mala S'oossay unttuntta patseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","S'oossay bare odeeddawaadan Saarikko yeedda; S'oossay Saaro bare geeddawaadan ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saara shahaaraade, c'imeedda Abrahaamew S'oossay geedda wodii gakkina, attuma na'aa yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Saara Aw yeleedda bare na'aa suntsaa Abrahaame «Yisaak'a» yaagiide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abrahaame bare na'aa Yisaak'a S'oossay azazeeddawaadan hosppuntsa gallassan k'as's'areedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aa na'aa Yisaak'i aw yeletteedda wode, Abrahaame laytsay s'eeta. ");
INSERT INTO dwrl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saara, «S'oossay taw miichchaa immeedda; k'ay hawaa sisiyaawe ubbay taananna miic'c'ana» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","K'aykka Saara, «Abrahaamew Saara na'aa d'antsana geeddawe oonee? Gidooppenne taani ha\"i aw I c'imeedda wodiyaan na'aa yelaad» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Guutsa na'ay dic'c'iide; d'antsaa duutseedda; Abrahaame Yisaak'i d'antsaa duutseedda gallassi wolk'k'aama baalaa keseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Shin Gibs'eppe yeedda Aggaara Abrahaamew yeleedda na'ay Yisaak'ana kaa'iyaawaa Saara be'aaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Abrahaama, «Ha ayilatti na'ay ta na'aa Yisaak'ana ubbakka laattenna diraw, ayilatonne izi na'aa kessa yedda» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ha yewuu bare na'aa bochchiyaa diraw, Abrahaame loytsi metooteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Shin S'oossay Abrahaame, «Na'awunne ne ayilatiw loytsa metoottoppa; Saara new odiyaawaa ubbaa sisa; ayaw gooppe, ne zeretsay Yisaak'a baggana s'eesettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","K'ay ayilatti na'aa taani kawutetsaa kessana; ayaw gooppe, ikka ne zare» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wontta guuran Abrahaame denddeedda; k'umaanne ogoruwaan haatsaa akkiide, Aggaaro hashiyaan toossiide, izi na'aakka iziw immiide kessi yeddeedda. Iza baade, Berssaabehe giyaa woraan toyilakattaw. ");
INSERT INTO dwrl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Haatsaykka ogoruwaan wureedda wode iza, «Na'ay hayk'k'ishin, uttaade be'ikke» yaagaade, na'aa itti buuraa garssan wotsaade, laa\"u s'eetu wad'aa gidiyaawaa keeshshaa baade uttaaddu. Matan uttaade, bare k'aalaa d'ok'k'issaade yeekkaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","S'oossay na'aa waasuwaa siseedda; S'oossaa kiitanchchay Aggaaro saluwaappe s'eesiide, «Aggaaree, waanaaddii? S'oossay na'ay giseedda sa'aan waassiyaawaa siseedda diraw yayyoppa; ");
INSERT INTO dwrl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","dendda ek'k'a; na'aanne ne kushiyaan dentsa; ayaw gooppe, taani Aa wolk'k'aama kawutetsaa ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","S'oossay izi ayfiyaa dooyina, haatsaa ollaa be'aaddu; baade ogoruwaan haatsaa kuntsaaddu; na'aakka ushshaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Na'ay dic'c'iyaa wode, S'oossay aanana gideedda; I woran de'iide, wonddaafiyaa dukkiyaa asaa gideedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","I Paaraana giyaa woran de'ishshin, Aa daaya Gibs'eppe aw machchatto demmaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","He wode, Abimeleeki bare wotaadaratuwaa kaappuwaa Pikoolaana Abrahaamekko biide, «Neeni ootsiyaa ubbaban S'oossay neenana de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Neeni ta bolla woy ta naanaa bolla woy ta zeretsaa bolla genebaa ootsenna mala, ha\"i hawaan, S'oossaa sintsan taw c'aak'k'a; taani new keekeeddawaadan, neenikka tawunne neeni imatsatetsan de'iyaa ha biittaw lo\"a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahaame, «Taani c'aak'k'ay» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","He wode, Abrahaame Abimeleeka k'oomatuu akkeedda haatsaa ollaabaa Abimeleekaw maganneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Shin Abimeleeki, «Hewaa ooni ootseedentto taani erikke; neenikka k'ay taw odabaakka; taani hachche gakkanaw hewaa sisabeykke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Hewaappe guyye Abrahaame dorssaanne miizzatuwaa ahiide, Abimeleekaw immina, unttunttu laa\"u c'aak'uwaa c'aak'k'eteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahaame laappun mac'c'a dorssaa maratuwaa wudiyaappe shaakkeedda; ");
INSERT INTO dwrl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleeki Abrahaama, «Ha neeni dumma shaakka wotseedda laappun mac'c'a dorssaa maratuwaa ayaw shaakkaadii?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahaame, «Taani ha haatsaa ollaa bookkeeddawoo markka gidana mala, ha laappun mac'c'a dorssaa maratuwaa ta kushiyaappe akka» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Hewaan he laa\"u asatuu c'aak'k'eteedda diraw, he sa'ay Berssaabehe geetetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Berssaabehen c'aak'uwaa c'aak'k'eteeddawaappe guyye, Abimeleekenne Aa wotaadaratuu kaappuwaa Pikooli denddiide, Pilss's'eema biittaa simmeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahaame Berssaabehen Tamaariskke geetettiyaa mitsaa tokkeedda. Hewaan Godaa, Med'ina S'oossaa, suntsaa s'eeseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahaame Pilss's'eema gadiyaan daro wodiyaa de'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hewaappe simmiide, S'oossay Abrahaama paac'c'eedda; I Aa, «Abrahaamee» yaagiide s'eeseedda. I, «Abee» yaagiide koyeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","S'oossay, «Neeni siik'iyaa ne mes's'i itti na'aa Yisaak'a akkaade, Mooriyaa giyaa gadiyaa ba; yan taani new odiyaa itti deriyaa bollan Aa s'uuggiyaa yarshshuwaa ootsaade taw yarshsha» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Wonttetsa gallassi Abrahaame guuran denddiide, bare hariyaa c'aaneedda; bare k'oomatuwaappe laa\"uwaanne bare na'aa Yisaak'a barenana akkiide, s'uuggiyaa yarshshuwaa mitsaa p'alk'k'i akkiide, S'oossay aw odeedda sa'aa baanaw denddeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Biide heezzentsa gallassi Abrahaame d'ok'k'u giide, he sa'aa haakuwaan be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abrahaame bare k'oomatuwaa, «Ha hariyaana hawaan de'ishshite; taaninne ta na'ay yaa biide S'oossaw goyinniide, hinttenttukko simmana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahaame yarshshuwaa mitsaa dentsiide, bare na'aa Yisaak'a tooseedda; tamaanne mashshaa I barew oyk'k'eedda. Unttunttu laa\"u ittippe biishshin, ");
INSERT INTO dwrl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yisaak'i bare aawuwaa Abrahaama, «Ta aawoo» yaageedda. Abrahaame, «Abee, ta na'aw» yaageedda. I, «Tamaynne mitsay hawesh; shin s'uuggiide yarshshiyaa dorssaa maray hak'anee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahaame, «Ta na'aw, s'uuggiide yarshshiyaa dorssaa maraa S'oossay giigisana» yaageedda. Unttunttu laa\"u ittippe beeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Unttunttu S'oossay aw odeedda sa'aa gakkeedda wode, Abrahaame yarshshuwaa yarshshiyaa sa'aa yan gimbbiide, mitsaa maari yeggeedda; bare na'aa Yisaak'a k'achchiide, he mitsaa bollan gisiseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abrahaame bare na'aa shukkanaw bare kushiyaa yeddiide mashshaa akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Shin Med'inaa Godaa kiitanchchay saluwaappe Aa, «Abrahaamee, Abrahaamee» yaagiide s'eeseedda. I, «Abee» giide koyeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Aa, «Na'aa bollan ne kushiyaa wotsoppa; Aa ayinne ootsoppa; neeni ne mes's'i itti na'aakka taana diggabeenna diraw, neeni S'oossaw yayyiyaawaa gidiyaawaa taani ha\"i eray» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrahaame d'ok'k'u gi s'eelliide, hewaan dorssaa ittuu kac'ii buuran geli k'as'etti utteeddawaa be'eedda. Abrahaame biide he dorssaa akkiide, bare na'aa diraw s'uuggiyaa yarshshuwaa ootsiide yarshshi basheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Hewaa diraw Abrahaame, «Med'ina Goday immana» yaagiide he sa'aa suntseedda; hachche gakkanaasikka, «Med'inaa Godaa deriyaan imettana» geetettee. ");
INSERT INTO dwrl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Med'inaa Godaa kiitanchchay saluwaappe laa\"entsiide Abrahaama s'eesiide yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«Med'ina Goday, ‹Hawaadan yaagaade new taani ta huup'iyaan c'aak'k'ay; neeni hawaa ootseedda dirawunne ne mes's'i itti na'aakka taana diggabeenna diraw, ");
INSERT INTO dwrl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","taani neena tumu anjjana; ne zeretsaakka taani saluwaa s'oolinttiyaa keenanne abbaa doonaa shafiyaa keena ootsaade c'orissana. Ne zeretsatuu barenttu morkkatuwaa katamatuwaa laattana. ");
INSERT INTO dwrl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Neeni taw azazetteedda diraw, ha sa'aa kawutetsatuu ubbay ne zeretsaa baggana anjjettana› yaagee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hewaappe guyye, Abrahaame bare k'oomatuwaakko simmiide, unttunttu ubbay ittippe Berssaabehe denddiide beeddino. Abrahaame Berssaabehen de'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hewaappe simmiide Abrahaamew, «Milkka ne ishaa Naakooraw naanaa yelaaddu; ");
INSERT INTO dwrl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","unttunttune bayiray Uus'a; Uus'a ishatuu Buuza, ");
INSERT INTO dwrl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Araama aawuwaa K'amu'eela, Keesade, Haazo, Pilddaasha, Yidilaafanne Baatu'eela. ");
INSERT INTO dwrl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Hawantta ha hosppun naanaakka Milkka Abrahaame ishaa Naakooraw yelaaddu; Baatu'eeli Ribik'o yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Raa'uma giyaa Aa k'oomata k'ay S'ebaaha, Gahaama, Tahaashanne Maa'ika yelaaddu» yaagiide odeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saara s'eetanne laatamanne laappun laytsaa de'aaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Hewaappe guyye iza Kanaane gadiyaan de'iyaa (Kebroone giyaa) K'iriyaati-Arbba'a kataman hayk'k'aaddu. Abrahaame Saariw yeekkanawunne kayyottanaw beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Yeekki simmiide, Abrahaame bare machchatti anhaa mataappe denddi biide, Hiitetuwaa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Taani hinttenttu giddon betenne imatsaa; ta machchatti anhaa mooganaw taw hinttenttu gadiyaappe duufuwaa zal\"eerikkitee!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Hiitetuu aw, «Godaw, nuuni odiyaawaa sisa; neeni nu giddon wolk'k'aama kaappuwaa; neeni ne machchatti anhaa nu duufuwaappe new lo\"eeddawaan mooga; neeni ne machchatti anhaa mooganaw bare duufuwaa ooninne neena diggenna» yaagi zaareeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Yaagina Abrahaame denddi ek'k'iide, Hiitetuwaa sintsan goynneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","I unttunttoo, «Hinttenttu taana, ‹Ne machchatti anhaa mooga› gooppe sisite; S'ohaara na'aa Efiroonaw Aa gadiyaa gas'an de'iyaa Maakip'eela giyaa gonggoluwaa taw duufuwaa kessanaw zal\"ana mala kumentsaa gatiyaan nuuna zal\"iseerikkite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hiitiyaa Efiroone he wode katamaa penggiyaan shiik'eedda bare asaa giddon utteedda; Hiitetuu ubbay sisishshin, Abrahaamew yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Hewaadan gidenna; ta godaw, ta odiyaawaa sisa; taani gadiyaakka Aa giddon de'iyaa gonggoluwaakka new immay; taani new Aa ta asaa sintsan immay; neeni ne machchatti anhaa mooga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahaame he gade asaa sintsan zaaretsi goynneedda, ");
INSERT INTO dwrl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","asay sisishshin Efiroona, «Ta odiyaawaa sisaarikkii! Taani he gadiyaa gatiyaa c'iggana; neeni taappe akkaarikkii! Hewaan taani ta machchatti anhaa moogana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Efiroone Abrahaamew zaariide, «Ta godaw, taani odiyaawaa sisa; gadii oyddu s'eetu s'agaraa biraa kessiyaawaa; shin hewe ne giddoninne ta giddon ayinne gidenna; ne machchatti anhaa mooga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahaame Hiitetuu sisishshin, Efiroone geedda gatiyaa mayyeedda; he wode shaluwaan oyddu s'eetu s'agaraa biraa Efiroonaw immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Mamire katamaa matan Maakip'eelan de'iyaa Efiroona gadii, hewan de'iyaa gonggoluunne he gadiyaan de'iyaa mitsaa ubbay, ");
INSERT INTO dwrl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","katamaa penggiyaan shiik'eedda Hiitetuwaa ubbaa sintsan higgiyaan Abrahaame gade gideedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Hewaappe guyye, Abrahaame bare machchatto Saaro Kanaane gadiyaan (Kebroone giyaa) Mamire katamaa matan de'iyaa Maakip'eela giyaa gade gonggoluwaan moogeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hewaa diraw he gadiinne hewaan de'iyaa gonggoluu Hiitetuwaa sintsan higgiyaan Abrahaamew duufuwaa gideedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahaame loytsi laytsaa sugiide c'imeedda; Med'ina Goday Aa ubbabankka anjjeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abrahaame bare k'oomaa, bare soo asaa ubbaw kaappotiyaa, bare asaa ubbaw godattiyaawaa hawaadan yaageedda; «Ne kushiyaan ta gulbbataa oyk'k'a; ");
INSERT INTO dwrl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","taani unttunttu giddon de'iyaa Kanaanetuwaa mac'c'a naanatuwaappe ta na'aw machchatto oochchenna mala, Med'inaa Godaan, saluwaa S'oossaaninne sa'aa S'oossan taani neena c'aak'k'etsay; ");
INSERT INTO dwrl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","shin neeni ta yeletteedda biittaa, ta dabbotuwaakko baade, ta na'aa Yisaak'aw machchatto oochcha» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Aa k'oomay, «Mac'c'aanna taananna yaanaw dosennabaa gidooppe, ne na'aa neeni yeedda gadiyaa guyye afoo?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahaame, «Ta na'aa yaa afenaadan neena era! ");
INSERT INTO dwrl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Med'ina Goday, saluwaa S'oossay, taana ta aawuwaa sooppenne ta yeletteedda biittaappe keseeddawe taw, ‹Ne zariyaw taani ha biittaa immana› yaagiide c'aak'k'eeddawe, neeni ta na'aw yaappe machchatto demmana mala, I bare kiitanchchaa neeppe sintsaw kiittana. ");
INSERT INTO dwrl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mishirata neenana guyye yaanaw dosennabaa gidooppe, ha taani neena c'aak'k'etseedda c'aak'uu new gometenna; shin ta na'aa yaa guyye ubbakka afoppa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","K'oomay bare godaa Abrahaame gulbbataa oyk'k'eedda; ha yewoo c'aak'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hewaappe guyye, k'oomay bare godaa gaalotuwaappe tammuwaa akkiidde, bare godaa miishshaappekka muruta murutaa akkiidde beedda; Masp'p'es'oomiyaa giyaa gadiyaan Naakoora katamaa gakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Omarssi, mac'c'a Asay haatsaa tikkanaw yiyaa wodiyaan, katamaappe gas'an haatsaa ollaa matan bare gaalotuwaa gulbbatisseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Yaatiide I hawaadan yaagiide woosseedda; «Med'inaa Godaw, ta godaa Abrahaame S'oossaw, hachche taani k'oppaade yeeddabaa taw injjeya; k'ay ta godaa Abrahaamew lo\"obaa ootsa. ");
INSERT INTO dwrl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Be'a! Taani ha haatsaa pulttiyaa matan ek'k'ay; ha katamaa asaa mac'c'a naanay haatsaa tikkanaw haa yaana. ");
INSERT INTO dwrl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Taani, ‹Ane otuwaa hokisaadde taana haatsaa ushsha› giyaa wode, izakka, ‹Hey usha; k'ay ne gaaluwaa taani ushshana› yaagiyaanna, henna ne k'oomaa Yisaak'aw neeni dooreeddaano gidu; neeni ta godaw lo\"obaa ootseeddawaa taani hewaan erana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Biro I woosaa wurissenaan de'ishshin, Ribik'a haatsaa otuwaa tookkaade puttu gaaddu. Izo Baatu'eeli yeleedda; Baatu'eeli Milkka na'aa; Milkka Abrahaame ishaa Naakoora machchatto. ");
INSERT INTO dwrl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ribik'a loytsa puulanchchanne attuma Asay bochchibeenna wodoratto. Pulttuwaa duge wod'd'aade, bare otuwaa kuntsaade kessaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","He k'oomay iikko wos's'i biide izo, «Ne otuwaappe taana guutsa haatsaa ushshaarikkii!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Iza, «Eeno ta godaw, ushikkii» yaagaaddu. Elleellaadde otuwaa bare hashiyaappe wotsaade, gede zaara oyk'k'aadde Aa ushshaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Aa ushsheeddawaappe guyye, «Ne gaalatuwaakka alana gakkanaw taani unttunttoo haatsaa duuk'k'ana» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Atteedda haatsaa elleella wonggiriyaan tigaade, hara haatsaa duuk'k'anaw ollaa wos's'aaddu; gaalatuu ubbay alana gakkanaw, haatsaa ollaappe duuk'k'a duuk'k'aade ahaade wonggiriyaan tigaade ushshaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","I k'oppiide yeedda k'ofaa Med'inaa Goday injjeyiidde de'intto eranaw bitanii c'o\"u giide izo s'eellee. ");
INSERT INTO dwrl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Gaalotuu haatsaa ushi simmiina, bitanii ichcheshu giraamenne bakka gideedda work'k'aa migiduwaanne, s'eetanne tammu giraame gideedda laa\"u work'k'aa sagaayetuwaa keseedda; ");
INSERT INTO dwrl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","izo, «Neeni O naatti? Ane taw oda; ne aawuwaa son nuw ak'iyaa sa'ay de'anee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Iza, «Taani Baatu'eela naatto; Baatu'eeli Milkka Naakooraw yeleedda na'aa. ");
INSERT INTO dwrl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nuwaan gidiyaa dalaynne bassuu de'ee; k'ay hinttenttu ak'anawukka sa'ay de'ee» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Bitanii gulbbati Med'inaa Godaw goynniidde, ");
INSERT INTO dwrl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","hawaadan yaageedda; «Ta godaw keekiyaawaanne ammanettiyaawaa aggibeenna Med'ina Goday, ta godaa Abrahaama S'oossay galatetto! Taani yiishshin, Med'inaa Goday taana ta godaa dabbatuwaa soy kaaletseedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Naatta wos's'a baade, bare aati son de'iyaa asaw haneeddabaa odaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribik'iw Laabaana giyaa ishay de'ee; Laabaani kare kesiide, haatsaa pulttuwaa matan de'iyaa bitaniyaakko wos's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Migiduwaanne bare michchati kushiyaan de'iyaa sagaayetuwaa be'eeddasaana Ribik'a bitanii barena geeddawaa odina sisosaanna, kesiide bitaniyaakko bi be'eedda; bitaniyaa gaalotuwaanna pulttuwaa matan ek'k'eeddawaa demmeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Aa, «Med'inaa Goday neena anjjeedawo, haaya! Neeni hawaan karen ayaw ek'k'ay? Taani new golliyaanne gaalotookka sa'aa giigissaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Bitanii soo geleedda; Laabaani gaalotuwaa c'aanaa billeedda; dalaanne bassuwaa gaalotoo yegeedda. Gediyaa meec'c'anaw aasinne aanana de'iyaa asatoo haatsaa aheedda; ");
INSERT INTO dwrl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","k'umaykka Aa sintsa aad'd'eedda. Shin I, «Taani taana aheedabaa hinttenttoo odennan de'aadde k'umaa miikke» yaageedda. Laabaani, «Yaatooppe oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Hewaa diraw I, «Taani Abrahaame k'oomaa. ");
INSERT INTO dwrl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Med'inaa Goday ta godaa loytsi anjjina, I duretteedda; dorssaa, miizzaa, biraa, work'k'aa, attuma k'oomatuwaa, mac'c'a k'oomatuwaa, gaalotuwaanne haretuwaa aw immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ta godaa machata Saara bare c'iimmatetsaa laytsan aw attuma na'aa yelaaddu; I barew de'iyaawaa ubbaa aw immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ta goday taana hawaadan c'aak'k'iseedda; ‹Taani de'iyaa Kanaane biittaa mac'c'a naanatuwaappe ta na'aw machchatto oochchoppa; ");
INSERT INTO dwrl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","shin ta aawuwaa asaakko, ta zaratuwaakko baade, ta na'aw machchatto oochcha› yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Taani ta godaa, ‹Naatta taananna yaanaw dosennan aggooppe shin?› yaagaad. ");
INSERT INTO dwrl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","I, ‹Med'inaa Goday, taani Aa sintsan hametteeddawe neenana bare kiitanchchaa kiittana; neeni ta na'aw ta aawuwaa asaappe, ta zaratuwaappe machchatto demmana mala, ne biyaasaakka injjeyana. ");
INSERT INTO dwrl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Neeni ta zaratuwaakko biina, unttunttu new izo immennan is's'ooppe, he wode new c'aak'uu gometenna› yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«Taani hachche ha pulttuwaakko yeedda wode yaagaad; ‹Med'inaa Godaw, ta godaa Abrahaame S'oossaw, ne shene gidooppe, taani biyaa yewuwaa injjeya. ");
INSERT INTO dwrl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Be'a; taani ha pulttuwaa matan ek'k'ay; gellayatta ittina haatsaa tikkanaw yooppe, taani izo, «Taana ne otuwaappe guutsa haatsaa ushshaarikkii!» yaagana. ");
INSERT INTO dwrl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Iza taana, «Eeno usha; k'ay ne gaalotookka taani haatsaa duuk'k'ana» yaagiyaanna, Med'inaa Goday ta godaa na'aw dooreeddaano gidu› yaagaad. ");
INSERT INTO dwrl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«Taani ta wozanaan woossiyaawaa wurissenaan de'ishshin, Ribik'a bare otuwaa tookka akkaade, puttu gaaddu; pulttuwaa duge wod'd'aade haatsaa duuk'k'aadu; taani izo, ‹Taana haatsaa ushshaarikkii› yaagaad. ");
INSERT INTO dwrl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","«Iza elleella bare hashiyaappe otuwaa wotsaade, ‹Hekko usha; k'ay taani ne gaalotuwaa ushshana› yaagaaddu. Taani ushaad; k'ay ta gaalotuwaa iza ushshaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","«Taani izo, ‹Neeni O naatti?› yaagaad. «Iza, ‹Taani Baatu'eela naatto; Baatu'eeli, Milkka Naakooraw yeleedda na'aa› yaagaaddu. «Taani iziw migiduwaa aatsaad; izi kushiyaankka sagaayetuwaa wotsaad. ");
INSERT INTO dwrl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Hewaappe guyye taani gulbbataade, Med'inaa Godaw goynnaad; taani Med'inaa Godaa, ta godaa Abrahaame S'oossaa, ta godaa ishaa na'aa naatto Aa na'aw akkanaw taana likke ogiyaa kaaletseeddawaa galatay. ");
INSERT INTO dwrl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ha\"ikka hinttenttu ta godaw keekanabaanne ammanettanawaa gidooppe, taw odite; gidana d'ayinttonne odite; hewaappe sintsan taani hananawaa erana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laabaaninne Baatu'eeli zaariide yaageeddino; «Ha yewuu Med'inaa Godaappe yeedda; nuuni new yaa haa gaanaw danddayokko. ");
INSERT INTO dwrl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ribik'o hanno be'a; akkaade ba; Med'inaa Goday geeddawaadan ne godaa na'aw machchatto gidu» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abrahaama k'oomay unttunttu giyaawaa siseedda wode, sa'aan gulbbatiide Med'inaa Godaw goynneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","K'oomay biraa alleek'k'uwaanne work'k'aa alleek'k'uwaa, mayuwaakka kessiide, Ribik'iw immeedda; k'ay al\"o miishshatuwaa izi ishawunne izi aatiw immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Hewaappe guyye, inne aanana de'iyaawanttu meeddinonne usheeddino; yaatiide yan ak'eedino; unttunttu guuran denddiide, «Taana ta godaakko yeddite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Izi ishaynne izi aata, «Naatta itti tammu gallassaa keeshshaa nuunana takku; hewaappe guyye iza baana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Shin I, «Med'inaa Goday taani yeeddawaa injjey diggina, hinttenttu taana gam\"etsoppite; taani ta godaakko baana mala taana moyzzite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Unttunttu, «Naatto s'eesiide ane izo oochchoytte» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ribik'o s'eesiide, «Ha bitaniyaanna baanii?» yaagiide oochcheeddino. Iza, «Ee; taani baana» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Unttunttu barenttu michchato Ribik'o, izo dichchiyaanina, Abrahaama k'oomaananne Aa asatuwaana moyzzeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Unttunttu Ribik'o, «Nu michchati Ribik'ee, sha\"aappe sha\"aa gakkanaw c'oratta. Ne zaratuu barenttu morkkatuwaa katamatuwaa laattino» yaagiide anjjeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hewaappe guyye, Ribik'anne izi danggaas'iretuu denddiide, gaalotuwaa toggiide, bitaniyaanna beeddino. Yaatina k'oomay Ribik'o akkiidde beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","He wode Yisaak'i, «Taana Be'iyaa De'uwaa S'oossaa Pulttuwaa» giyaa pulttuwaa mata biide, Neegeeba woran de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Itti gallassi omarssi Yisaak'i bare wozanaan k'oppiide dembbaa kesiide yuuyyee; I d'ok'k'u giide s'eelliyaa wode, gaalatuu yiyaawantta be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribik'akka d'ok'k'u gaade s'eelliyaa wode, Yisaak'a be'aaddu; gaaluwaappe wod'd'aaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","K'oomaa, «Ha nuunana gaketanaw dembbaana yiyaa bitanii oonee?» yaagaaddu. K'oomay, «I ta godaattee» yaageedda. Iza bare shaashiyaa akkaade gullottaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","K'ay k'oomay bare ootseeddawaa ubbaa Yisaak'aw odeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Yisaak'i Ribik'o bare aati Saari dunkkaaniyaa afeedda. Izo akeedda; izakka aw machchatto gidaaddu. Yaatina I izo siik'eeddanne bare aati hayk'k'uwaan kayyottiyaawaappe minetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","K'ay Abrahaame K'as'uro geetettiyaa hara machchatto akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Iza Ziimiraana, Yok'ishaana, Madaana, Midiyaama, Yishibaak'anne Shuha aw yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yok'ishaani Saabanne Dadaana yeleedda. Dadaani Ashooreta, Les'uushetanne Le'aamata yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyaama naanay Eefa, Eefeera, Hanooka, Abiidaa'anne Elddaa'a. Hawanttu ubbaykka K'as'uri naanaa. ");
INSERT INTO dwrl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahaame barewaa ubbaa Yisaak'a laatisseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Shin I biro pas'a de'iidde, bare hara machatuwaappe yeleedda naanaatoo barew de'iyaawaappe woyteedda. Bare na'aa Yisaak'appe unttuntta shaakki, away doliyaa bagga biittaw yeddeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahaame mule itti s'eetanne laappun tammanne ichcheshu laytsaa de'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abrahaame daro wodiyaa de'iide, lo\"o c'imiide hayk'k'eedda; bare mayzzatuwaanna gaketteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Aa naanay Yisaak'inne Isimaa'eeli Aa Maakip'eela giyaa gonggolo duufuwaan moogeeddino; he gonggoluu Mamire matan, Hiitiyaa S'ohaara na'aa Efiroona gadiyaan de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Hewenne Abrahaame Hiitetuwaappe shammeedda gadiyaa. Abrahaame bare machata Saara moogetteedda sa'aan moogetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrahaame hayk'k'eeddawaappe guyye, S'oossay Aa na'aa Yisaak'a anjjeedda. He wode Yisaak'i, «Taana Be'iyaa De'uwaa S'oossaa Pulttuwaa» giyaa pulttuwaa matan de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Saari ayilata, Gibs'eppe yeedda Aggaara, Abrahaamew yeleedda na'aa Isimaa'eela yeletay hawaappe kaalliide s'aafetteeddawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isimaa'eela naanay barenttu suntsaaninne barenttu yeletaa maaran hawantta; hewanttunne: Nabaayoota, K'eedaara, Adibi'eela, Mibssaama, ");
INSERT INTO dwrl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishimaa'a, Duuma, Maasa, ");
INSERT INTO dwrl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadaada, Teema, Yis'ura, Naafiishanne K'eedima. ");
INSERT INTO dwrl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isimaa'eela naanay hawantta; unttunttu suntsay unttunttu mootsaaninne de'iyaa sa'aan hawaa. Unttunttu barenttu yaran tammanne laa\"u kaappatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimaa'eeli mule s'eetanne hattamanne laappun laytsaa de'iide, hayk'k'eedda; bare mayzzatuwaanna gaketteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isimaa'eela zaratuu Gibs'eppe away doliyaa baggan de'iyaa Hawiilappenne Shurappe gidduwaan, Asoora afiyaa ogiyaa matan de'eeddino. Unttunttu barenttu ishatuwaa ubbaanna morkkiyaan de'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abrahaama na'aa Yisaak'a yeletay hawaappe kaaliide s'aafetteeddawaa. Abrahaame Yisaak'a yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Yisaak'aw laytsay oytamuwaa gideedda wode, Ribik'o akkeedda; iza Masp'p'es'oomiyaan de'iyaa Sooriyaa Baatu'eela naattiwune Sooriyaa Laabaana michchato. ");
INSERT INTO dwrl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Yisaak'i bare machata mantsato gideedda diraw, iziw Med'inaa Godaa woosseedda; Med'inaa Goday Aa woosaa siseedda. Yaatina Aa machata Ribik'a shahaaraaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Shin izi ulo giddon de'iyaa naanay mantte gidi uttiide, ittuu ittuwaanna sugetteeddino; yaatina iza, «Hawe taw ayaw hanii?» yaagaaddu. Hewaa diraw Med'inaa Godaa oochchanaw baaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Med'inaa Goday iziw, «Ne uluwaan laa\"u kawutetsay de'ee; K'ay ne gidduwaan de'iyaa laa\"u gade asatuu ittuu ittuwaappe shaakettana; Itti gade asatuu hinkkotuwaappe minnana; K'ay bayiray teefaw azazettana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Iza yeliyaa wodii gakkina, izi uluwaan mantte attuma naanay de'iino. ");
INSERT INTO dwrl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Koyro yeletteeddawe arssa; Aa bollaa ubbaa isikii mayyeedda; hewaa diraw unttunttu Aa Eesaw giide suntseeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Hewaappe guyye, Aa ishay yeletteedda; I bare kushiyaan Eesaw ginddiyaa oyk'k'i utteedda; hewaa diraw Aa Yaak'ooba giide suntseeddino. Ribik'a unttuntta yeleedda wode, Yisaak'aw usuppun tammu laytsaa gideedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Naanay dic'c'eeddino; Eesay shankkaa hiillaa eriyaa bazuwaa asaa gideedda; shin Yaak'oobi dunkkaaniyaan de'iyaa woppa asaa gideedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yisaak'i Eesaa siik'eedda; ayaw gooppe, I shankkateeddabaappe maanaw doseedda; shin Ribik'a Yaak'ooba siik'aaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Itti gede Yaak'oobi wos'iyaa katsishin, Eesay koshay wod'eeddawe, woraappe yeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Eesay Yaak'ooba, «Taana ha zo'o wos'iyaappe miza; taana koshay wod'eedda» yaageedda. (Hewaa diraw k'ay Aa suntsay Eedooma geetetteedda). ");
INSERT INTO dwrl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaak'oobi Aa, «Koyro taw ne bayiratetsaa zal\"a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Eesay, «Be'a! Taani hayk'k'ana hanay; ha bayiratetsay taw ayaa go\"i de'ii?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaak'oobi zaariide, «Ane taw koyro neeni c'aak'k'a» yaageedda. I c'aak'k'eedda; bare bayiratetsaa Yaak'oobaw zal\"eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yaak'oobi Eesaw sooluwaanne missiriyaa wos'iyaa immeedda; I meeddanne usheedda; hewaappe guyye denddiide beedda. Eesay bare bayiratetsaa hawaadan kad'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","He gadiyaan kase Abrahaame wodiyaan de'iyaa koshaa bolla hara koshay denddeedda; yaatina Yisaak'i Piliss's'eema kaatiyaa Abimeleekekko Garaara beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Med'ina Goday Yisaak'aw k'onc'c'iide hawaadan yaageedda; «Gibis'e gadiyaa duge booppa; taani new odeedda gadiyaan de'a. ");
INSERT INTO dwrl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ha gadiyaan amareedawaa takkashsha; taani neenana gidana; neena anjjana; ayaw gooppe, ha biittaa ubbaa taani newunne ne zeretsaw immana; taani ne aawuwaa Abrahaamew c'aak'k'eedda c'aak'uwaa minisana. ");
INSERT INTO dwrl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ne zeretsaa saluwaa s'oolinttiyaadan darissana; ha biittaa ubbaa taani unttunttoo immana; sa'aa kawutetsaa ubbay ne zeretsaa baggana anjjettana. ");
INSERT INTO dwrl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ayaw gooppe, Abrahaame ta k'aalaa siseedda; ta pirddatuwaanne ta azazuwaa, ta awaayotuwaanne ta higgiyaa naageedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Hewaa diraw Yisaak'i Garaaran utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","He biittaa Asay Ribik'ibaa dentsiide Yisaak'a, «Hanna new ayee?» yaagiide oochcheedda. I, «Hanna taw michchato» yaageedda. Ayaw gooppe, I Ribik'a daro puulanchcha gidiyaa diraw, «Taani, ‹Iza ta machchatto gooppe›, ha gade Asay izi gaasuwaan taana wod'anenttonne» yaagi k'oppiide yayyeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Yisaak'i hewaan daro wodiyaa de'owaappe guyye, Pilss's'eema Kaatii Abimeleeki maskkootiyaanna duge s'eeliide, Yisaak'i bare machchatti Ribik'ina gaketishin be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Hewaa diraw Abimeleeki Yisaak'a s'eesiide, «Hekko iza tumu ne machchato! Neeni ayaw, ‹Iza ta michchato› gaaddii?» yaagiide oochcheedda. Yisaak'i, « ‹Iza ta machchatto gooppe›, izi gaasuwaan Asay taana wod'ana gaade gaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleeki, «Hawe neeni nu bollan ootseeddabay ayee? Ta asaappe itti Asay ne machchattina gisi diggeeddashin; neeni nu bollan gomiyaa ahaadashin» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hewaa diraw Abimeleeki bare asaa ubbaa, «Ha bitaniyaa woy Aa machchatto bochchiyaa ooninne tumu hayk'k'ana» yaagiide azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Yisaak'i he gadiyaan katsaa zeriide, he laytsan s'eetu kushiyaa c'akkeedda; ayaw gooppe, Med'inaa Goday Aa anjjeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","I duretteedda; duretaa bolla duretay aw dari dari beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yisaak'aw dorssaa wudii, miizzaa wudiinne k'oomatuu loytsi dareedda diraw, Pilss's'eema asatuu Aa k'anaateeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Hewaa diraw, Aa aawuwaa Abrahaame wodiyaan, Aa aawuwaa k'oomatuu bookkeedda haatsaa ollaa ubbaa Pilss's'eema asatuwaa biittaa zaariide bareedino. ");
INSERT INTO dwrl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","He wode Abimeleeki Yisaak'a, «Nuuppe shaakettaade ba; neeni nuuppe aad'd'a minnaadda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Yisaak'i hewaappe denddiide, Garaara Wombbaa biide yan utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Yisaak'i bare aawuwaa Abrahaame wodiyaan booketteedda haatsaa ollatuwaa, Abrahaame hayk'k'eeddawaappe guyye, Pilss's'eema asatuu bareedawantta zaari bookki kessiide, Aa aawuu suntseedda suntsan unttuntta s'eeseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Yisaak'a k'oomatuu wombban bookkiide, pulttiyaa haatsaa ollaa yan demmeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Shin Garaara hentsanchchatuu Yisaak'a hentsanchchatuwaana, «Haatsay nuwaa» yaagiide walak'etteeddino. Unttunttu aanana palumetteedda diraw, Yisaak'i he haatsaa ollaa, «Palumiyaa» giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Hewaappe guyye, unttunttu hara haatsaa ollaakka bookkeeddino; shin unttunttu he haatsaa ollaa geeduwaan walak'etteeddino; hewaa diraw I he haatsaa ollaa «Morkketiitta» giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hewaappe guutsaa zardda''iide, hara haatsaa ollaa bookisseedda; Aa gaasuwaan ooninne walak'ettibeenna; «S'oossay ha\"i nuw aasseeda; nuuni ha gadiyaan c'oraana» giide Aa, «Aako sa'aa» giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Hewaappe denddiide, pude Berssaabehe beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","He beedda gallassi k'amma Med'ina Goday Aw k'onc'c'iide Aa, «Taani ne aawuwaa Abrahaame S'oossaa; taani neenana de'iyaa diraw, neeni yayyoppa; taani neena anjjana; ta k'oomaa Abrahaame diraw ne zeretsaa taani c'orissana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yisaak'i hewaan yarshshiyaa sa'aa kees's'iide, Med'inaa Godaa suntsaa s'eeseedda. Yan I bare dunkkaaniyaa d'ogeedda; k'ay yan Aa k'oomatuu haatsaa ollaa bookkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hewaappe guyye, Abimeleeki barena zoriyaa Ahuuzatanne bare wotaadaratuwaa kaappuwaa Pikoola akkiidde, Garaarappe Yisaak'akko yeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yisaak'i unttuntta, «Hinttenttu kase taana is's'iide, hinttenttu biittaappe kessi yeddeeddita; ha\"i k'ay taakko ayaa akkana yedditee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Unttunttu Aa, «Med'inaa Goday neenana de'iyaawaa nuuni k'onc'c'iyaan be'eeddo. Hewaa diraw c'aak'k'o c'aak'uu nu giddoninne ne giddon de'ana koshshee yaagetto. Nuuni neena bochchibeykko; shin nuuni new keekatetsaa s'alalaa ootsiide, neena sarotetsaan moyzzi yeddeeddo. Hewaaddankka neeni nu bolla iitabaa ootsenna mala, ane neenana c'aak'uwaa c'aak'k'etoytte. Ha\"i neeni Med'inaa Goday anjjeedawaa» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","He wode Yisaak'i unttunttoo baalaa giigissina, meeddinonne usheeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wonttetsa gallassi wontta guuran denddiide, unttunttu ittuu ittuwaanna c'aak'k'eteeddino. Yisaak'i unttuntta moyzzina, unttunttu aappe saro shaakettiide beeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","He gallassi Yisaak'a k'oomatuu yiide, barenttu bookkeedda haatsaa ollaabaa aw odeeddino; «Nuuni haatsaa demmeeddo» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I he haatsaa ollaa Saabehi giide suntseedda; hewaa diraw he katamaa suntsay hachche gakkanaw Berssaabehi geetettee. ");
INSERT INTO dwrl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Eesaa laytsay oytamuwaa gidiyaa wode, Hiitiyaa Bi'eedo naatto Yooditonne Hiitiyaa Eloona naatto Baasemaato akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Unttunttu Yisaak'anne Ribik'o kayyoyiidde de'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yisaak'i c'imina, Aa ayfii s'eelaa is's'eedda wode, bare bayiratiyaa na'aa Eesaa s'eesiide Aa, «Ta na'aw» yaageedda. I, «Abee» giide koyeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","I, «Be'a, ha\"i taani c'imaad; taani hayk'ana gallassaa erikke. ");
INSERT INTO dwrl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yaatiyaa diraw, ha\"i ne shankkatiyaa wonddaafiyaanne zubbiyaa akkaade, bazuwaa ba; do'aa taw shankkataade, ashuwaa akkaade ya. ");
INSERT INTO dwrl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mal\"o k'umaa, taani dosiyaawaa katsaade aatsa; hewenne taani hayk'k'anaappe kase neena anjjanaassa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ribik'a Yisaak'i bare na'aa Eesaw odiyaa wode sisaaddu. Eesay do'aa shankkatiide ahanaw bazuwaa beeddawaappe guyye, ");
INSERT INTO dwrl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribik'a bare na'aa Yaak'ooba, «Ne aawuu ne ishaa Eesaw, ");
INSERT INTO dwrl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹Do'aa shankkata ahaade, taw mal\"o k'umaa taani maanaw katsaa; hewenne taani hayk'k'anaappe kasetaade, Med'inaa Godaa sintsaan neena anjjanaassa› yaagiyaawaa taani sisaad. ");
INSERT INTO dwrl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ta na'aw, ha\"i taani neena azaziyaawaa loytsaade sisa. ");
INSERT INTO dwrl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Wudiyaa garssa baade, laa\"u bolttiboltta deeshshaa maratuwaa taw akkaade ya; taani ne aabboo mal\"o k'umaa I dosiyaawaadan katsana. ");
INSERT INTO dwrl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ne aawuu miide hayk'k'ennan kasetiide neena anjjana mala, aw aatsaasa» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Shin Yaak'oobi bare aatto Ribik'o, «Ta ishaa Eesaa bollan isikii de'ee; shin ta bollay liik'o. ");
INSERT INTO dwrl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ta aawuu taana oyk'k'i be'ooppe shin? Taani Aa c'immiyaawaa aw malatina, taani anjjuwaa diraw shek'aa ta bolla ahanenttone» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Aa daaya Aa, «Ta na'aw, he shek'ay taana gakko. Taani new odiyaawaa ootsa; baade deeshsha maratuwaa taw akkaade ya» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Bi ahiide bare daayiw immeedda; Aa daaya mal\"o k'umaa Aa aawuu dosiyaawaadan katsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hewaappe guyye, Ribik'a son bare matan de'iyaa bare bayira na'aa Eesaa mayuwaa lo\"uwaa ahaade, bare teefa na'aa Yaak'ooba mayzzaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","K'ay he deeshshatuwaa galbbaa Aa kushiyaanne Aa liik'o k'ood'iyaa mayzzaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Bare katseedda mal\"o k'umaanne ukitsaa bare na'aa Yaak'ooba kushiyaan wotsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yaatina I bare aawuwaakko biide geliide, «Ta aawoo» yaageedda. I, «Abee! Ta na'aw, neeni oonee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaak'oobi bare aawuwaa, «Taani ne bayira na'aa Eesaa; neeni taana azazeeddawaadan taani ootsaad; dendda; dendda uttaade, taani shankkaappe aheedawaa ma; yaataade taana anjja» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yisaak'i bare na'aa, «Ta na'aw, waata elleella demmad?» yaagiide oochcheedda. I, «Med'inaa Goday ne S'oossay taana maaddeedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yisaak'i Yaak'ooba, «Ta na'aw, neeni tumu ta na'aa Eesenttonne taani oyk'k'a be'anaw ane taakko shiik'a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaak'oobi bare aawuwaa Yisaak'akko shiik'ina oyk'k'i be'iide, «Ha k'aalay Yaak'ooba k'aalaa; shin kushii Eesaa kushiyaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aa kushii Aa ishaa Eesaa kushiyaadan isikiyaana de'iyaa diraw, eribeenna; I erennan Aa anjjeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Aa, «Tumu neeni ta na'aa Eeseyee?» yaagiide oochcheedda. I, «Ee, taanattee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","I, «Ta na'aw, taani neeni shankkateeddawaa maanaw haa aatsa; maade taani neena anjjana» yaageedda. Yaak'oobi aatsina, I meedda; k'ay I aw woyniyaa eessaa ahina usheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Hewaappe guyye Aa aawuwaa Yisaak'i, «Ta na'aw, haaya; shiik'aade taana yera» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yaak'oobi shiik'iide Aa yereedda; Yisaak'i Aa mayuwaa singgi sisiide, hawaadan yaagiide anjjeedda; «Ta na'aa peenuu Med'inaa Goday anjjeedda goshshaadan sawee. ");
INSERT INTO dwrl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","S'oossay saluwaa c'okkuwaanne sa'aa shic'aa, katsaanne ooratsa woyniyaa eessaa darssiide new immo. ");
INSERT INTO dwrl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kawutetsatuu new moodettino; asatuu new gulbbatino. Neeni ne ishatoo goda gida; ne aati zaratuu new gulbbatino. Neena shek'k'iyaawe shek'etteeddawaa gido; neena anjjiyaawe anjjetteeddawaa gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yisaak'i Yaak'ooba anjji wursseeddawaappe guyye, Yaak'oobi bare aawuwaa Yisaak'a sintsaappe kesowaan Eesay shankkaappe puttu geedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ikka k'ay mal\"o k'umaa katsiide, bare aawoo aatseedda. Aa, «Ta aawoo, dendda; dendda uttaade, taani shankkateeddawaappe ma; yaataade taana anjja» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aa aawuu Yisaak'i Aa, «Neeni oonee?» yaagiide oochcheedda. I, «Taani ne na'aa, ne bayira na'aa Eesaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yisaak'i dagammiide kokkoriidde; «Yaatina do'aa shankkateeddawaa akkiidde taw aatseedawe oonee? Taani ha\"i neeni yaana sintsan maade, Aa anjja diggaad; tumukka I anjjetteeddawaa gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Eesay bare aawuwaa k'aalaa siseedda wode, bare k'aalaa d'ok'k'u ootsiide, daro yibbaata yeekuwaa yeekkiide bare aawuwaa, «Taana anjja; ta aawoo, taanakka anjja!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Shin I, «Ne ishay yiide c'immiidde, ne anjjuwaa aki diggeedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Eesay, «Aa eriide Yaak'ooba suntseedda; I taana c'immoode, hawe laa\"entsuwaa; I ta bayiratetsaa akkeedda; k'ay ha\"i ta anjjuwaa akkeedda» yaageedda. K'ay I, «Neeni taw anjjuwaappe ayaanne ashshabeykkii?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yisaak'i Eesaa, «Taani Aa new goda ootsaad; Aa ishatuwaa ubbaakka Aa k'oomatuwaa ootsaad; k'ay taani katsaaninne ooratsa woyniyaa eessan Aa minisaad. Yaatina, ta na'aw, new taani ayaa ootsoo?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eesay bare aawuwaa, «Ta aawoo, new itti anjjo s'alalay de'ii? Ta aawoo, taanakka k'ay anjja» yaageedda. Hewaappe guyye, Eesay bare k'aalaa d'ok'k'u ootsiide yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Aa aawuwaa Yisaak'i zaariide, «Ne de'iyaa ha sa'aa duretetsaappe haakkaade de'ana; Saluwaa c'okkuukka new wod'd'enna; ");
INSERT INTO dwrl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Neeni ne mashshaan ak'ana; Neeni ne ishaw moodetana. Shin neeni aanana ek'ettiyaa wode, Aa morge mitsa ne morggiyaappe olana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Yaak'ooba Aa aawuu anjjeedda diraw, Eesay bare uluwaan Aa morkkeedda; I bare wozanaan, «Ta aawuu hayana mateedda; taani aw kayyotta simmaade, ta ishaa Yaak'ooba wod'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Shin Ribik'a ha bare bayira na'aa Eesaa k'aalaa siseedda diraw, bare teefa na'aa Yaak'ooba s'eesissa ahaade hawaadan yaagaaddu; «Ne ishay Eesay neena wod'iide haluwaa kesanaw halchcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Hayyanaa ta na'aw, taani new odowaa ootsa. Dendda! Kaaraanen de'iyaa ta ishaa Laabaanakko bak'ata! ");
INSERT INTO dwrl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Yaataade ne ishaa hank'k'uu dochchana gakkanaw, amareeda wodiyaa aanana de'ashsha. ");
INSERT INTO dwrl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ne ishay new hank'k'ettiyaawaa aggiyaa wodenne, neeni Aa bolla ootseeddawaa I dogiyaa wode, taani kiittaade neena yaappe ahissana. Taani itti gallassi hinttenttu laa\"uwaappe mela kessana koyikke» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hewaappe guyye Ribik'a Yisaak'a, «Eesay akkeedda Hiitetuwaa mac'c'a naanaa gaasuwaan taani ta de'uwaa shenetaad; k'ay Yaak'oobikka hawanttu mala Hiitetuwaa mac'c'a naanatuwaappe machchatto akkooppe, taani simmi hayk'k'anaw koyaad» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hewaa diraw, Yisaak'i Yaak'ooba s'eesiide hawaadan anjjeedanne azazeedda; «Kanaane gadiyaa mac'c'a naanatuwaappe new machchatto akkoppa. ");
INSERT INTO dwrl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Dendda! Ne daay aawuwaa Baatu'eelakko, Masp'p'es'oomiyaa gadiyaa baade yaappe ne daay ishaa Laabaana mac'c'a naanatuwaappe ittinno new machchatto ootsaade akka. ");
INSERT INTO dwrl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ubbaa Danddayiyaa S'oossay neena anjjo; I ne yeletaa aasso; neeni itti dere asaa keena gakkanaw neena c'orisso. ");
INSERT INTO dwrl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Neeni ha\"i betetetsan utteedda ha biittaa newaa ootsana mala newunne ne zeretsaw S'oossay Abrahaame anjjuwaa immo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yisaak'i Yaak'ooba yeddeedda; Yaak'oobi Masp'p'es'oomiyaa gadiyaa Laabaanakko beedda. Laabaani Yaak'oobanne Eesaa yeleedda aati Ribik'a ishaanne Sooriyaa Baatu'eela na'aa. ");
INSERT INTO dwrl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Yisaak'i Yaak'ooba anjjeedawaanne, yaappe machchatto akkanaw Masp'p'es'oomiyaa gadiyaa Aa yedeeddawaa, k'ay I Yaak'ooba anjjeedda wode, «Kanaane mac'c'a asaa akkoppa» yaagiide azazeeddawaanne, ");
INSERT INTO dwrl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yaak'oobi bare aawuwaanne bare aatonne azazettiide, Masp'p'es'oomiyaa gadiyaa beeddawaa Eesay ereedda. ");
INSERT INTO dwrl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Eesay hewaan Kanaane biittaa mac'c'awunna bare aawuwaa Yisaak'a ay keeshshaa iitintto akeekeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hewaa diraw Eesay Abrahaame na'aa Isimaa'eelekko biide, Aa naatto Maahilaato bare machatuwaa bolla gujjiide akkeedda. Iza Nabaayoota michchato. ");
INSERT INTO dwrl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaak'oobi Berssaabeheppe Kaaraane baanaw denddeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I itti sa'aa gakkina away wullina, yan k'ammaa ak'eeda. He sa'aan de'iyaa shuchchatuwaappe ittuwaa akkiidde, bare huup'iyaan borkkotiide he sa'aan gem\"isheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I akumuwaa akumeteedda; he akumuwaan gayyiyaa ittuu biittan ek'k'ina, aw s'eeray saluwaa gakkiyaawaan, S'oossaa kiitanchchatuu gi\"ishiinanne wod'd'ishin be'eedda; ");
INSERT INTO dwrl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","gayyiyaw bolla s'eeran Med'inaa Goday ek'k'iide Aa, «Taani Med'inaa Godaa, ne aawuwaa Abrahaama S'oossaa, Yisaak'a S'oossaa. Ha neeni giseedda biittaa newunne ne zeretsaw immana; ");
INSERT INTO dwrl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ne zeretsay sa'aa shafiyaadan darana; neeni away wulliyaa baggananne, away doliyaa baggana, huup'issananne hirkki baggana de'iyaa sa'aa gakkanaw aakkana; sa'aa bollan de'iyaa Asay ubbay ne baggananne ne zeretsaa baggana anjjettana ");
INSERT INTO dwrl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Taani neenana de'ay; neeni biyaasa'aa ubbaan taani neena naagana; k'ay taani neena ha gadiyaa guyye zaaraade ahana; taani new ootsana geeddawaa ootsana gakkanaw neena yeggikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaak'oobi gem\"ishuwaappe beegotteedda wode, «Med'inaa Goday tumu ha sa'aan de'ee; taani erabeykkeppe attin» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","I yayyiide, «Ha sa'ay wooti yashshii! Ha sa'ay S'oossaa golliyaappe attin, ayinne hara sa'aa gidenna; hawe saluwaa penggiyaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Wonttetsa gallassi wontta guuran Yaak'oobi denddiide, bare borkkoteedda shuchchaa akkiidde, tuussaadan essiide, S'oossaw dummayanaw Aa bolla zayitiyaa tigeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yaak'oobi he sa'aa Beeteele giide s'eeseedda. Shin he katamay hewaappe kase Looza geetettee. ");
INSERT INTO dwrl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Yaak'oobi hawaadan yaagiide shiik'k'eedda; «Ta aawuwaa soo taani saro simmana mala S'oossay taananna gidooppe, taani biyaa ha buussan taana naagooppenne taw miyaa k'umaanne mayiyaa mayuwaa immooppe, Med'inaa Goday ta S'oossaa gidana; ");
INSERT INTO dwrl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","taani tuussaadan esseedda ha shuchchay S'oossaa golliyaa gidana. Neeni taw immiyaawaa ubbaappe tammuwaappe ittuwaa taani new immana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Hewaappe guyye, Yaak'oobi denddi biide, away doliyaa bagga asatuwaa gadiyaa gakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Itti haatsaa ollay dembban de'iyaawaa be'eedda; heezzu dorssaa wudii k'ay he ollaa matan giseeddino. Ayaw gooppe, wudii ubbay haatsaa ushiyaawe he ollaappe. He haatsaa ollaa doonaan de'iyaa shuchchay wolk'k'aama. ");
INSERT INTO dwrl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Dorssaa wudii ubbay hewaan dagatteedda wode, he wudiyaa heemmiyaawanttu haatsaa ollaa doonaappe he shuchchaa gonddorssiide dorssaa ushshiino. He shuchchaa ollaa doonaan zaariide wotsino. ");
INSERT INTO dwrl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaak'oobi unttuntta, «Ta ishatoo, hinttenttu hak'appe yeddite?» yaagiide oochcheedda. Unttunttu, «Nuuni Kaaraaneppe yeeddo» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","I, «Naakoora na'aa na'aa Laabaana hinttenttu eriiteyye?» yaageedda. Unttunttu, «Ee, Aa ereetto» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yaak'oobi unttuntta, «I lo\"o de'ii?» yaagiide oochcheedda. Unttunttu, «Ee, lo\"a; Aa naatta Raaheela dorssaa akkaade yewunno hanno be'a» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yaak'oobi unttuntta, «Be'ite; away ha\"i wullibeena; wudiyaa mehii soo shiik'iyaa wodii biro gakkibeenna; dorssaa ha\"i ushshi afiide, heemmite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Shin unttunttu, «Wudii ubbay shiik'ana gakkanaw, shuchchaa haatsaa ollaa doonaappe gonddorssana gakkanaw, nuuni ushshanaw danddayokko. Hewaappe guyye, nuuni dorssaa ushshana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","I biro haasayishin, Laabaana naatta Raaheela bare aawuwaa dorssatuwaa laagga akkaade gakkaaddu; ayaw gooppe, iza dorssaa hentsanchchaa. ");
INSERT INTO dwrl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaak'oobi bare aati ishaa Laabaana naatto Raaheelo be'eedda wodenne, bare aati ishaa Laabaana dorssaa be'eedda wode, biide ollaa doonaappe shuchchaa gonddorsseedda; bare aati ishaa dorssatuwaa haatsaa ushsheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yaak'oobi Raaheelo yeriide, nashechchaw bare k'aalaa d'ok'k'isiide yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yaak'oobi iziw aawuwaa dabbonne Ribik'i na'aa gidiyaawaa Raaheeliw odeedda. Hewaa diraw iza wos's'a baade bare aawoo odaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laabaani bare michchati na'aa Yaak'ooba woriyaa siseedda saannakka, aanana gaketanaw wos's'eedda. Aa idimmi yeriide, bare soo afeedda. Yan Yaak'oobi haneeddawaa ubbaa Laabaanaw odeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laabaani Aa, «Neeni tumu ta ashonne ta suutsaa» yaageedda. Yaak'oobi aanana itti aginaa kumentsaa utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Hewaappe guyye Laabaani Aa, «Neeni taw dabbo gideedda diraw, taw c'oo mela ootsaniyee? Ane new ayaa c'igganaw bessintto taw oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laabaanaw laa\"u mac'c'a naanatuu de'iino; bayirati suntsay Liyo, teefattiwe Raaheelo. ");
INSERT INTO dwrl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liya ayfiyaana c'uuc'a; shin Raaheela geesanchanne malaa lo\"a. ");
INSERT INTO dwrl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaak'oobi Raaheelo siik'iide Aa, «Taani ne teefa naatti Raaheeli diraw new laappun laytsaa ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laabaani, «Izo hara asaw immanaappe new immiyaawe lo\"a; neeni taananna hawaan de'a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hewaa diraw Yaak'oobi Raaheelo akkanaw laappun laytsaa ootseedda; shin I izo siik'iyaa diraw, aw amareeda gallassaa malateedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hewaappe guyye Yaak'oobi Laabaana, «Ta machchato taw imma; ta wodii poletteedda; taani izo akkanaw koyaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Hewaa diraw Laabaani hewaan de'iyaa asaa ubbaa s'eesiide, bullachchaa keseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Shin sa'ay k'ammina, I bare naatto Liyo afiide Yaak'oobaw immeedda. Yaak'oobi izo akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","K'ay Laabaani bare k'oomatoo Zilppo bare naatti Liyiw danggaas'ire gidanaadan immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sa'ay wonttina s'eelliyaa wode, hekko Liyo! Yaatina Yaak'oobi Laabaana, «Hawe neeni ta bolla ootseeddawe ayee? Taani new ootseeddawe Raaheeli dirassa gidenneeyye? Taana ayaw c'immaad?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laabaani Aa, «Nu biittan bayirata de'ishshin, teefatto asinaw immiyaawe woga gidenna. ");
INSERT INTO dwrl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","He mishiraa saaminttaa wurssa; k'ay teefatiyaanokka nuuni new immana; hewaappe guyye, hara laappun laytsaa taw ootsaasa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaak'oobi hewaadan haniide he saaminttaa wursseedda; hewaappe guyye, Laabaani bare naatto Raaheelo aw immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","K'ay Laabaani bare k'oomato Baalo bare naatti Raaheeliw danggaas'ire gidanaadan immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaak'oobi Raaheelo akkeedda. Raaheelo Liyippe aatsiide siik'eedda. Hara laappun laytsaa Laabaanaw ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Med'inaa Goday Liya siik'ettabeennawaa be'iide, iziw yeliyaa uluwaa dooyeedda; shin Raaheela mantsato. ");
INSERT INTO dwrl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liya shahaaraade attuma na'aa yelaaddu. Aa suntsakka Roobeela suntsaaddu; ayaw gooppe iza, «Med'inaa Goday ta metuwaa be'eedda; ha\"i tumu taana ta asinay siik'ana» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Iza haraakka shahaaraade attuma na'aa yelaaddu. Iza, «Med'inaa Goday taani siik'ettabeenawaa siseedda diraw, taw hawaakka gujjeedda» yaagaadde, Aa Simoona suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Aa haraakka shahaaraade attuma na'aa yelaaddu. Iza, «Taani aw heezzu attuma naanaa yeleedda diraw, ta asinay ha\"i taananna waas'ettana» yaagaadde, Aa Leewii suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Aa haraakka shahaaraade attuma na'aa yelaaddu. Iza, «Hachchiwaan taani Med'inaa Godaa galatana» yaagaaddu. Hewaa diraw Aa Yihudaa suntsaaddu. Hewaappe guyye yeluwaa essaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raaheela Yaak'oobaw naanaa yelabeennawaa be'eedda wode, bare michchato k'anaataaddu; hewaa diraw Yaak'ooba, «Taw naanaa imma; hewe d'ayooppe, taani hayk'k'ana» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaak'oobi Raaheelo hank'k'etsiide, «Taana new yeluwaa diggeedda S'oossaa gaaddiyye?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Iza, «Ta danggaas'irato Baalo hinno be'a; iza ta diraw yelana mala neeni izo akka; yaatooppe izi baggana taanikka na'aa daayo gidana» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Bare danggaas'iratto Baalo machchatto ootsiide akkana mala, aw immaaddu; Yaak'oobi izo akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Baala shahaaraade attuma na'aa Yaak'oobaw yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Yaatina Raaheela, «S'oossay taw daannateedda; ta woosaakka sisiide, taw attuma na'aa immeedda» yaagaaddu. Hewaa diraw Aa Daana suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Raaheeli danggaas'irata Baala haraa shahaaraade, Yaak'oobaw laa\"entsuwaa attuma na'aa yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raaheela, «Taani ta michchatina wolk'k'aama baas'iyaa baas'etaade s'oonaad» yaagaaddu. Hewaa diraw Aa Nifttaaleema suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Liya barew yeluu ek'k'eeddawaa be'aade, bare danggaas'irato Zilppo afaade Yaak'oobi izo akkana mala immaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Liya danggaas'irata Zilppa attuma na'aa Yaak'oobaw yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liya, «Laa hawe ayaa lo\"o kaac'ee!» yaagaaddu. Hewaa diraw Gaada suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Liya danggaas'irata Zilppa Yaak'oobaw laa\"entsuwaa attuma na'aa yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Liya, «Taani ay keeshshaa nashettayttaasha! Mac'c'a Asay taana nashettiyaanno gaana» yaagaaddu. Hewaa diraw Aa Aaseera suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Zarggaa c'akkiyaa aginaan Roobeeli gade biide, inkkoyiyaa giyaa timaatimiyaa malatiyaa teeraa demmiide, bare aati Liyiw aheedda. Raaheela Liyo, «Ne na'aa inkkoyiyaappe taw imma» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Shin Liya, «Ta asina neeni wotsa akkeeddawe gidennaan is's'ina, k'ay ta na'aa inkkoyiyaa akkay?» yaagaaddu. Raaheela, «Yaatooppe, ne na'aa inkkoyiyaa diraw Yaak'oobi hachche k'ammaa neenanna ak'o» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","He gallassaa omarssi Yaak'oobi woraappe yeedda wode, Liya Aa mokkanaw kesaade Aa, «Neeni taananna ak'ana koshshee; ayaw gooppe, taani ta na'aa inkkoyiyaan neena keraw akka diggaad» yaagaaddu. Hewaa diraw I he gallassaa k'amma izina ak'eeda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","S'oossay Liya woosaa siseedda; iza shahaaraade, ichcheshantsa attuma na'aa Yaak'oobaw yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Liya, «Taani ta danggaas'irato ta asinaw immeedda diraw, S'oossay hewaa keraa taw c'iggeedda» yaagaaddu. Hewaa diraw Aa Yisaakoora gaade suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Liya haraakka shahaaraade, usuppuntsa attuma na'aa Yaak'oobaw yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Liya, «S'oossay taw al\"o imotaa immeedda; taani ta asinaw usuppun naanaa yeleedda diraw, ha\"i I taana bonchchanawaa» yaagaaddu. Hewaa diraw Aa Zaabiloona suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hewaappe guyye itti mac'c'a naatto yelaaddu; izo Diino suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","S'oossay Raaheelo hassayeedda; izi woosaa sisiide izi yeliyaa uluwaa dooyeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Iza shahaaraade attuma na'aa yelaaddu; «S'oossay ta yeellaa k'aareedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Med'ina Goday taw hara attuma na'aakka gujjeerenneeshsha» yaagaaddu. Hewaa diraw Aa Yooseefo suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raaheela Yooseefa yeleeddawaappe guyye, Yaak'oobi Laabaana, «Taani ta aawuwaa gadiyaa simmana mala, taana moyzza. ");
INSERT INTO dwrl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Taani unttunttu diraw new ootseedda ta machatuwaanne ta naanaa hamma; taani baana; ayaw gooppe, taani new ay keeshshaa oosuwaa ootseedentto neeni eraasa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Shin Laabaani Aa, «Taani new ittibaa oday; Med'inaa Goday ne gaasuwaan taana anjjeedawaa taani be'aaddi. ");
INSERT INTO dwrl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ne dirgguwaa taw oda; taani new c'iggana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaak'oobi, «Taani new waata ootseedentto, ne mehiikka waan yeletteeddentto neeni eraasa. ");
INSERT INTO dwrl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Taani yaanaappe kase new de'iyaa guutsay ha\"i loytsi dareedda; Med'inaa Goday neena taani aad'd'eedda sa'aan ubbaan anjjeedda. Shin ha\"i, taani ta soo asaw ootsanawe awudee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laabaani, «Taani new ayaa immoo?» yaagiide Aa oochcheedda. Yaak'oobi, «Taw ayinne immoppa; shin neeni taw ittibaa ootsooppe, taani ne wudiyaa k'aykka heemmananne naagana. ");
INSERT INTO dwrl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Taani hachche ne wudiyaa ubbaa gidduwaana aad'd'ana; hewaan ne dorssaappe punc'c'ariyaa woy gazzaa ubbaa, karetsa dorssaa mara ubbaanne deeshshaappe gazzaanne punc'c'ariyaa ubbaa taani shaakkana; unttunttu ta dirgguwaa gidana. ");
INSERT INTO dwrl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Hewaa diraw ta s'illotetsay neeni taw c'iggeedda dirgguwaa paydanaw sintsappe yiyaa wode, taw markkattana; ta deeshshaappe gazza woy punc'c'are gidennawe woy karetsa gidenna ay dorssaa maraynne ta matan beettintto, wuu\"etteeddawaadan payddettana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laabi, «Mayyaad; neeni geeddawaadan gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Shin he gallassan Laabi danc'c'aa woy gazza gideedda attuma deeshshaa ubbaa, punc'c'are woy gazza gideedda mac'c'a deeshshaa ubbaa, bootsa gideedda ubbaanne karetsa dorssaa mara ubbaa kessiide, bare attuma naanaa hentseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yaatiide he wudiyaanna heezzu gallassaa ogiyaa Yaak'oobappe haakkiide beedda. Shin Yaak'oobi atteeda Laabaana wudiyaa heemmeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaak'oobi deeshsha loomiyaappe, gumariyaappenne s'ank'k'arssaappe k'ayye gatimaa kessiide, pok'uwaa pok'k'i pok'k'iide, giddo bootsa bagga k'aariide gazzayeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Wudii haatsaa ushanaw yiyaa sa'aa ubbaan, wonggiriyaan, wudiyaa sintsan pok'k'eedda gatimatuwaa wotseedda. Kahowanttu haatsaa ushanaw yiide, ");
INSERT INTO dwrl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","he gatimatuwaa sintsan birasseeddino; unttunttu danc'c'aa, punc'c'arenne gazza maratuwaa yeleeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaak'oobi maratuwaa wudiyaappe shaakki dumma wotseedda; atteeda wudiyaa danc'c'anne karetsa gideedda Laabaana mehiyaa sintsa zaareedda. Yaatiide barew wudiyaa dummayeedda; Laabaana mehetuwaanna unttuntta gatsibeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Pas's'anne mino mac'c'awanttu kahiyaa wode awudenne, unttunttu he gatimatuwaa matan birassana mala, Yaak'oobi he gatimatuwaa haatsaa wonggiriyaan, miizatuwaa sintsaan wotsee. ");
INSERT INTO dwrl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Shin mehetuu laafa gidooppe, unttunttu sintsaan gatimatuwaa wotsenna. Hewaa diraw laafiyaa mehetuu Laabawaa gidina, dariyaawanttu Yaak'oobawaa gideeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Hawaadan haniide, Yaak'oobi loytsi duretiide, daro wudiyaa, mac'c'a k'oomatuwaanne attuma k'oomatuwaa, daro gaalotuwaanne haretuwaa mooddeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yaak'oobi Laabaana naanay barena, «Yaak'oobi nu aawuwaa ubbaa aki diggeedda; ha duretaa ubbaa nu aawuwaappe demmeedda» giyaawaa siseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaak'oobi Laabaana som\"i barew kasewaa mala gidennawaa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","He wode Med'inaa Goday Yaak'ooba, «Neeni ne aawotuwaa gadiyaa, ne dabbotuwaakko guyye simma; taani neenana gidana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yaak'oobi Raaheelonne Liyo bare wudii de'iyaa sa'aa dembbaa yaana mala kiittiide s'eesisseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","I unttuntta, «Hinttenttu aawuwaa som\"i taw kasewaa mala gidennawaa taani be'ay; shin ta aawuwaa S'oossay taananna de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Taani ta wolk'k'aa ubbaan hinttenttu aawuu ootseeddawaa hinttenttu eriita; ");
INSERT INTO dwrl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","shin hinttenttu aawuu taana c'immiidde, ta dirgguwaa tammu gede laammeedda. Gidooppenne S'oossay taana I k'ohenaadan diggeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","I, ‹Punc'c'aretuu ne dirgguwaa gidana› giina, wudii ubbay punc'c'ariyaa yeleedda; k'ay I, ‹shachchatuu ne dirgguwaa gidana› giina, wudii ubbay shachchaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","S'oossay hawaadan hinttenttu aawuwaa mehiyaa wotsi akkiidde taw immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Mehetuu kahiyaa aginaan, taani itti akumuwaa akumetaad; he akumuwaan taani s'eelliyaa wode, wudiyaa birassiyaa deeshsha koletuu danc'c'aa, punc'c'arenne gazza. ");
INSERT INTO dwrl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","S'oossaa kiitanchchay akumuwaan taana, ‹Yaak'ooba› yaageedda; taani, abee yaagaadde koyaad. ");
INSERT INTO dwrl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Taana I, d'ok'k'u gaade wudiyaa s'aaliyaa deeshshaa koliyaa ubbaa shachchaa, punc'c'ariyaanne gazzaa be'a; ayaw gooppe, Laabi ne bolla ootsiyaawaa ubbaa taani be'aaddi. ");
INSERT INTO dwrl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Neeni esseedda shuchchaa okkaadde, taw shiik'etteedda Beeteele S'oossay taana ha\"i dendda; ha biittaappe kesa; guyye ne yeletaa gadiyaa simma yaageedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Hewaappe guyye, Raaheelanne Liya hawaadan yaagiide zaareeddino; «Nu aawuwaappe nuuna gakkanabay ayee? ");
INSERT INTO dwrl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","I nuuna allagaadan s'eellee gidennee? I nuuna zal\"i akkeedda; zal\"iidde akkeeddawaakka mi d'aysseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","S'oossay nu aawuwaappe wotsi akkeedda mas'uu ubbay tumukka nuwaanne nu naanaawaa. Hewaa diraw s'oossay new odeeddawaa ubbaa ootsa» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Yaak'oobi Kanaane gadiyaan de'iyaa bare aawuwaa Yisaak'akko baanaw denddeedda; I bare naanaanne bare machatuwaa gaaluwaa togisseedda; wudiyaa ubbaa bareppe sintsanna laaggiide, Masp'p'es'oomiyaan de'iidde I shiishsheedda mas'uwaa ubbaa akkiidde beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laabi bare dorssatuwaa isikiyaa k'ans's'anaw bidigeeddoshin, Raaheela bare aawuwaa soo misiletuwaa wuu'aaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","K'ay Yaak'oobi Sooriyaa Laabaanaw bare bak'atiyaawaa odenaan c'immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","I barew de'iyaawaa ubbaa akkiidde bak'ateedda; Efiraas'iisa Shaafaa pinniide, Gala'aade giyaa gezziyaakko simmiide beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Heezzentsa gallassan, Laabi Yaak'oobi bak'ati bi kichcheeddawaa siseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Bare dabbotuwaa barenana akkiidde, laappun gallassaa ogiyaa Yaak'ooba geeduwaa kaalliidde, Gala'aade gezziyaan Aa gakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","He wode S'oossay k'amma Sooriyaa Laabaanakko akumuwaan yiide Aa, «Neeni Yaak'ooba bolla iita gidina, lo\"a gidina, ayinne haasayennaadan neena era!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laabi gakkiyaa wode, Yaak'oobi Gala'aade gezziyaan dunkkaaniide utteedda; k'ay Laabinne Aa dabbotuu yan dunkkaaneeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Hewaappe guyye Laabi Yaak'ooba, «Neeni hawaadan ayaw ootsaaddii? Neeni taana c'immaade, ta mac'c'a naanaa olan omoodetteeddawaadan laaggaade kessaadda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Neeni ayaw k'osuwaan taappe kessa akkaade, taana c'immaadii? Taani neena nashechchaaninne yetsaan, karabuwaaninne diitsaan moyzzana mala taw ayaw odabeykkii? ");
INSERT INTO dwrl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Neeni haray atto, ta naanaa naanaanne ta mac'c'a naanaa taani yera akkena mala diggaadda. Neeni eeyyabaa ootsaadda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Taani neena genanaw taw wolk'k'ay de'ee; shin ne aawuwaa S'oossay zino k'amma taana, ‹Yaak'ooba bolla iita gidina, lo\"a gidina, ayinne haasayennaadan neena era!› yaagiide taw odeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ha\"i gidooppenne, neeni ne aawuwaa soo baanaw loytsa laamoteedda diraw kesaadda. Shin ta soo misiletuwaa neeni ayaw wuu'aadii?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaak'oobi Laabaana, «Neeni ne naanaa taappe wolk'k'an wotsa akkaninttonne gaade k'oppeedda dirawunne yayyeedda diraw, hawaadan ootsaad. ");
INSERT INTO dwrl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Shin ne soo misiletuwaa oyk'k'eedda asaa oonanne neeni demmooppe, he uray siifetto! Newaa gideeddawe ta matan beettintto, nu dabbatuwaa sintsan koya; newaa gidooppe akka» yaageedda; ayaw gooppe, Yaak'oobi Raaheela he soo misiletuwaa wuu'eeddawaa eribeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Hewaa diraw Laabi Yaak'ooba dunkkaaniyaa giddo, Liya dunkkaaniyaa giddon laa\"u k'oomatuwaa dunkkaaniyaa giddo geleedda; shin ayinne demmibeenna. Liya dunkkaaniyaappe kesiide, Raaheeli dunkkaaniyaa geleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raaheela soo misiletuwaa akkaade, gaaluwaa kooraa garssan k'osaade, Aa bolla uttaaddu. Laabi dunkkaaniyaan de'iyaawaa ubbaa bulluuk'k'i koyeedda; shin ayinne demmibeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raaheela bare aawuwaa, «Ta godaw, taana hank'k'etsoppa; taani new ek'k'ana danddaykke; taw piilay yi utteedda» yaagaaddu. I koyeedda; shin soo misiletuwaa demmibeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaak'oobi Laabaana hank'k'ettiide wok'k'aseedda; Yaak'oobi Laabaana, «Taani ayaa bayzaadittaa? Hawaa neeni taana kaallanaw, taani ootseedda nagaray ayee? ");
INSERT INTO dwrl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ha\"i neeni ta miishshaa ubbaa bulluk'k'aadde koyaadda; ne soo miishshaappe ayaa demmaad? Unttunttu nu laa\"uwaa gidduwaan pirddana mala, ta dabbatuwaa sintsaaninne ne dabbatuwaa sintsaan hawaan wotsa. ");
INSERT INTO dwrl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","«Taani neenana laatamu laytsaa kumentsaa de'aad; ne dorssaykka ne deeshshaykka boshetibeenna; woy ne wudiyaappe s'abootiyaa mabeykke. ");
INSERT INTO dwrl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Do'ay mentseeddawaanne new ahabeyikke; shin hewaa taanan paydaad. Gallassi wuu'etteeddawaa woy k'amma wuu'etteeddawaa taana c'igissaadda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Gallassaa suuluu, k'amma meeguu taana k'oheedda; gem\"ishuu taappe d'ayeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Taani hawaadan ne soon laatamu laytsaa de'aad; tammanne oyddu laytsaa ne laa\"u mac'c'a naanaa dirawunne usuppun laytsaa ne wudiyaa diraw new ootsaadde de'aad; shin neeni ta dirgguwaa tammu gede laammaadda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ta aawuwaa S'oossay, Abrahaame S'oossay, Yisaak'i yayyeeddawe taananna gidibeennawaa gidintto, sid'e baynnan neeni taana mela kushe kessa yeddaadda; shin S'oossay ta tuggaanne ta kushiyaa oosuwaa be'iide, zino k'amma neena seereedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laabi Yaak'ooba, «Machatuu ta mac'c'a naanaa; naanaykka ta naanaa; wudiikka ta wudiyaa; neeni be'iyaa ubbay tawaa. Hachche ha mac'c'a naanaa tawanttu bollanne unttunttu yeleedda naanaa bolla ayaa ootsanaw danddayayitaa? ");
INSERT INTO dwrl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ha\"i haaya; neeninne taani c'aak'uwaa c'aak'k'etoytte; hewe neeppenne taappe gidduwaan markka gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hewaa diraw Yaak'oobi itti shuchchaa akkiidde tuussaadan esseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","I bare dabbotuwaa, «Shuchchaa shiishshite» yaageedda; unttunttu shuchchaa shiishshiide keeleeddinno; he keelaa lank'k'iyaan meeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laabi he keelaa, Yigaari-Sahaaduta giide suntseedda; k'ay Yaak'oobi Aa C'imeedda giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laabi, «Ha keelay neeppenne taappe gidduwaan hachche markka» yaageedda. Hewaa diraw Aa suntsay C'imeedda geetetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","K'ay I he shuchchaa tuussaa Mis'ip'p'a giide suntseedda; ayaw gooppe, Laabi, «Nuuni ittuu ittuwaappe haakkiide de'iyaa wode, Med'inaa Goday ne gidduwaaninne ta gidduwaan gidiide naago. ");
INSERT INTO dwrl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Neeni ta mac'c'a naanaa naak'k'ooppe, woy neeni ta mac'c'a naanaa bolla hara machatuwaa akkooppe, nuunana ha\"i ooninne baynnawaa gidooppenne ne gidduwaaninne ta gidduwaan S'oossay markka gidiyaawaa hassaya» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laabi k'aykka Yaak'ooba, «Keeleteedda shuchchay hawesh; k'ay taani ne gidduwaaninne ta gidduwaan esseedda shuchchaa tuussay hawesh. ");
INSERT INTO dwrl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Taani ha keelaappe neena genanaw neekko aad'd'enaaddan, neenikka taana genanaw ha keelaappenne ha shuchchaa tuussaappe aad'd'enaaddan, ha keelaynne ha shuchchaa tuussay markka. ");
INSERT INTO dwrl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abrahaame S'oossay, Naakoora S'oossay, unttunttu aawuwaa S'oossay, nu gidduwaan I pirddo» yaageedda. Yaak'oobi bare aawuu Yisaak'i Yayyeeddawaa suntsaan c'aak'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yaak'oobi deriyaa bollan yarshshuwaa yarshsheedda; bare dabbotuwaakka k'umaa maanaw s'eeseedda. Unttunttu miide deriyaa bollan ak'eedino. ");
INSERT INTO dwrl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Wonttetsa gallassi guuran Laabi denddiide, bare naanaa naanaanne bare mac'c'a naanaa yereedda; k'ay unttuntta anjjeedda. Bare soo simmeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaak'oobi denddiide bare ogiyaa biishshin, S'oossaa kiitanchchatuu aanana gaketeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaak'oobi unttuntta be'eedda wode, «Hawe S'oossay ak'iyaa sa'aa» yaagiide, he sa'aa Maahinayma giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yaak'oobi Se'iira giyaa sa'aan, Eedooma biittan de'iyaa bare ishaa Eesaakko kiitaa bareppe sintsaw kiitteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I unttuntta hawaadan yaagiide azazeedda; «Hinttenttu ta godaa Eesaw gaanawe hawaa; ‹Ne k'oomay Yaak'oobi, «Taani Laabaana matan de'aadde hanno gakkanaw gam\"aad. ");
INSERT INTO dwrl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Taw miizzaynne harii, dorssaynne deeshshay, attuma k'oomatuunne mac'c'a k'oomatuu de'iino; ha\"i taani ha kiitaa ta godaa sintsaan nashettana mala kiittaad» yaageedda› yaagite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kiitetteeddawanttu Yaak'oobakko simmiide Aa, «Nuuni ne ishaa Eesaakko beeddo; ha\"i I k'ay neenana gaketanaw yee; aanana oyddu s'eetu Asay de'ee» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yaak'oobi yayyiide batibateedda; barenana de'iyaa asaa laa\"u c'itan shaakkeedda; k'ay bare dorssaa, deeshshaa, miizzaanne gaaluwaa laa\"u c'itan shaakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I, «Eesay yiide itti c'itaa oliyaawaa gidooppe, atteeda c'uguu kessi akkooppenne» yaagiide k'oppeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","He wode Yaak'oobi hawaadan yaagiide woosseedda; «Abeet Med'inaa Godaw, ta aawuwaa Abrahaame S'oossaw, ta aawuwaa Yisaak'a S'oossaw, taana, ‹Ne gadiyaa, ne dabbotuwaakko simma; taani new lo\"obaa ootsana› geeddawoo, ");
INSERT INTO dwrl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","neeni ne k'oomaw ootseedda keekkatetsawunne tumatetsaw ubbaw taani bessenawaa. Taani ha Yorddaanoosa Shaafaa pinneedda wode, taw itti s'am\"aa s'alalay de'ee; shin ha\"i taani laa\"u c'ugo gidaaddi. ");
INSERT INTO dwrl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Taani neena woossay; ta ishaa Eesaa kushiyaappe taana ashsha; ayaw gooppe, I yiide, taananne mac'c'awantta unttunttu naanatuwaakka d'ayssanawenttonne gaade yayaad. ");
INSERT INTO dwrl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Shin neeni taana, ‹Taani new tumu lo\"obaa ootsana; taani ne zeretsaanne paydanaw danddayettenna abbaa shafiyaa keeshshaa ootsana› geeddawaa k'oppa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","He gallassaa k'amma I yan ak'eeda; barew de'iyaawaa ubbaappe bare ishaa Eesaw immiyaawaa k'oriide keseedda; ");
INSERT INTO dwrl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","I kesseeddawanttu laa\"u s'eetu mac'c'a deeshshatuwaanne laatamu deeshsha koletuwaa, laa\"u s'eetu mac'c'a dorssatuwaanne laatamu dorssaa koletuwaa, hattamu d'antsiyaa gaalotuwaa unttunttu maratuwaanna, oytamu mac'c'a miizzatuwaa, tammu korumaa booratuwaa, laatamu mac'c'a haretuwaanne tammu attuma haretuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Hawantta wudiyaan wudiyaan shaakki, bare k'oomatuwaa kushiyaan wotsiide, bare k'oomatuwaa, «Taappe sintsaw biide, wudiyaa wudiyaappe haakuwaan haakuwaan laaggite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Sintsan kaaletsiyaawaa, «Ta ishay Eesay neenana gaketiide neena, ‹Neeni oossee? Neeni hak'a bay? Ne sintsan de'iyaa mehiyaa ubbay oossee?› yaagiide oochchiyaawaa gidooppe, ");
INSERT INTO dwrl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","neeni aw, ‹Hawanttu ne k'oomaa Yaak'oobawaa; unttunttu ta godaa Eesaw immanaw yeddeeddawantta; k'ay ikka nuuppe guyyenna yide'ee› yaaga» yaagiide azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","K'ay I laa'entsa heezzantsuwaan wudiyaa kaalliyaa haratuwaa ubbatuwaa hawaadan azazeedda; «Hinttenttu Eesaanna gaketiyaa wode, hanniidankka giita; ");
INSERT INTO dwrl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‹Ne k'oomaa Yaak'oobi nuuppe guyyenna yide'ee› geenan aggoppite» yaageedda. Ayaw gooppe I, «Taani taappe sintsaw immanaw kiitteeddawaan Aa doshissana; ooni erii, hewaappe guyye taani aanana gaketiyaa wode, I taana mokki akkanenttonne» yaagiide k'oppeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Hewaa diraw bare immiyaawaa bareppe sintsaw yeddeedda. Shin I bare huup'iyaw he gallassi k'amma yan ak'eeda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","He gallassi k'amma Yaak'oobi denddiide, bare laa\"u machatuwaa, bare laa\"u k'oomatuwaanne bare naanaa tammanne ittatuwaa akkiidde, Yaabook'a giyaa pinuwaa gakkeedda; I unttuntta shaafaa pintseedda; barew de'iyaawaa ubbaakka pintsiide yeddeedda; ");
INSERT INTO dwrl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","shin Yaak'oobi barekka atteedda. He wode itti Asay sa'ay wonttana gakkanaw aanana baas'eteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","He Asay Aa s'oonanaw danddayibeenawaa be'eedda wode, Yaak'oobaw muk'k'eechchaa mek'etsaa bochcheedda; Aa muk'k'eechchaa mek'etsay kes wod'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Yaatina bitanii Aa, «Sa'ay wontteedda diraw, taana yedda» yaageedda. Shin Yaak'oobi Aa, «Neeni taana anjjenan taani neena yeddikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Bitanii Aa, «Ne suntsay oonee?» yaagiide oochcheedda. I, «Yaak'ooba» yaagiide zaareedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Bitanii Aa, «Hawaappe sintsaw ne suntsay Israa'eeliyaa geetettooppe attina, Yaak'ooba geetettoppo; ayaw gooppe, neeni S'oossaananne asaana baas'etaade s'oonaadda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yaak'oobi Aa, «Ne suntsay oonee?» yaagiide oochcheedda. Shin bitanii, «Neeni ta suntsaa ayaw oochchay?» yaageedda giide Aa anjjeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Hewaa diraw Yaak'oobi he sa'aa P'iini\"eela giide suntseedda; ayaw gooppe I, «Taani S'oossaa bazzuwaan s'eellaad; gidooppenne taani pas'a ataad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","I P'iini\"eelappe denddiyaa wode, Aa bolla s'alk'k'ii doleedda. I bare muk'k'eechchaa mek'etsaa diraw dooggee. ");
INSERT INTO dwrl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yaak'ooba muk'k'eechchaa ashuwaa matan bosheteedda diraw, Israa'eeliyaa Asay mehiyaa muk'k'eechchaa ashuwaa hachche gakkanaw meenna. ");
INSERT INTO dwrl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaak'oobi d'ok'k'u gi s'eelliide, Eesay bare oyddu s'eetu asaana yiyaawaa be'eedda. Hewaa diraw naanaa Liyiw, Raaheeliwunne laa\"u k'oomatuwaakko shaakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","K'oomatuwaanne unttunttu naanaa sintsan, Liyonne I naanaa unttunttu geeduwaan, Raaheelonne Yooseefa wurssetsan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Shin I bare huup'iyaw sintsaw aad'd'iide, bare ishaakko matiidde, sa'aa gakki gakkiide laappun kaala goynneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Shin Eesay aanana gaketanaw wos's'iide, Aa k'ood'iyaa k'oommi yereedda. Unttunttu yeekkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Yaatina Eesay d'ok'k'u gi s'eelliide, machatuwaanne naanaa be'eedda; I, «Ha neenana de'iyaawanttu oonee?» yaagiide oochcheedda. Yaak'oobi, «Unttunttu S'oossay ne k'oomaw keekatetsaan immeedda naanaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","K'oomatuu barenttu naanatuwaanna shiik'iide goynneeddinno. ");
INSERT INTO dwrl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Hewaappe guyye, Liyanne izi naanay yiide goynneeddinno; wurssetsaan Yooseefonne Raaheela yiide goynneeddinno. ");
INSERT INTO dwrl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Eesay, «Ha sintsan taananna gaketeedda wudii ubbay k'ay ayee?» yaagiide oochcheedda. I, «Ta godaw, hewe taani ne sintsaan nashettanaassa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Shin Eesay, «Ta ishaw, taw darobay de'ee; newe neessa gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaak'oobi, «Tuytti, ha\"i taani ne sintsaan nashshetteedawaa gidooppe, ha taani immiyaawaa taappe akka. Neeni taana mokka akkeedda diraw, taani ne deemuwaa be'iyaawe S'oossaa deemuwaa be'iyaawaa mala. ");
INSERT INTO dwrl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Taani new aheedda ha imuwaa akka; ayaw gooppe, S'oossay keekiidde immina, taw besseedda» yaageedda. Yaak'oobi shoobiyaa toleedda diraw, Eesay hewaa akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hewaappe guyye Eesay, «Ane dendda; nu ogiyaa boytte; taani neenana ittippe baana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Shin Yaak'oobi Aa, «Ta godaw, naanay shuga gidiyaawaa eraasa; k'ay taani barenttu galo maratuwaa d'antsiyaa dorssatuwaanne miizzaa naagana koshshee; Asay unttunttu itti gallassaa dirbbissi laaggooppe, mehiyaa ubbay hayk'k'ana. ");
INSERT INTO dwrl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Hewaa diraw, ta godaw, ne k'oomaappe sintsataade ba; taani Se'iiran ta godaa gakkanaw, ta sintsaan de'iyaa mehiyaa hemetaa keenaanne naanaa hemetaa keenaa loddan kaallana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Eesay Aa, «Yaatooppe taani ta asaappe amareedawaa new ashshay» yaageedda. Shin Yaak'oobi Aa, «Hewe ayissee? Taani ta godaa sintsaan nashshettiyaawe taw gidana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hewaa diraw Eesay he gallassi ogiyaan geliide, Se'iira simmeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Shin Yaak'oobi Sukkoota beedda; yan barew golliyaa kees's'eedda; bare mehetookka daasiyaa daaseedda. Hewaa diraw he sa'aa Sukkoota giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaak'oobi Masp'p'es'oomiyaappe simmeedda wode, Kanaane biittan de'iyaa Sekeeme giyaa katamaa sarotetsaan gakkeedda; I he katamaw bazzuwaan utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Bare dunkkaaniyaa d'ogeedda gadiyaa Shekeema aawuwaa Hamoora naanatuwaappe s'eetu s'agaraa biran shammeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yan yarshshiyaa sa'aa kees's'iide Aa, «S'oossaa, Israa'eeliyaa S'oossaa» giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Liya Yaak'oobaw yeleedda naatta Waana, he wode he gadiyaa mac'c'awantta be'anaw kesaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","He gadiyaa mooddiyaa Hiwiyaa Hamoora na'aa Shekeeme izo be'iide, izo hori afiide bayzzeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Aa wozanay Yaak'ooba naatto Diino amotteedda; I izo siik'eedda; iziw lo\"iyaawaa haasayeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekeeme bare aawuwaa Hamoora, «Taw ha naatto machchetetsaw oochchaarikki» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaak'oobi bare naatta Diinaa bayeeddawaa sisiyaa wode, Aa attuma naanay woran mehiyaanna de'ino; hewaa diraw unttunttu gakkanaw c'o\"u geedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hewaappe guyye, Shekeema aawuwaa Hamoori Yaak'oobanna haasayanaw yeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaak'ooba attuma naanay hewaa siseedda saanna woraappe yeeddino; unttunttu kayyotteeddinonne hank'k'eteeddino; ayaw gooppe, Shekeeme Yaak'ooba naatto hori afiide bayzziyaawaa, Israa'eeliyaa bolla pokkobaa, ootsanaw bessenabaa ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Shin Hamoori unttuntta, «Ta na'ay Shekeeme hinttenttu naattiw darssi dagammeedda; hayyanaa izo aw machchetetsaw immeerikkitee! ");
INSERT INTO dwrl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nuunana akettitenne gelettite; hinttenttu mac'c'a naanaa nuw immite; nu mac'c'a naanaanne hinttenttoo akkite. ");
INSERT INTO dwrl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Hinttenttu nu giddon uttanaw danddayiita; biittay loytsi aaka; aan de'ite; zal\"ite; aan mas'uwaa demmite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","He wode Shekeeme Diini aawuwaanne I ishatuwaa, «Taani hinttenttu sintsaan nashettooppe, hinttenttu oochchiyaawaa ayaa gidooppenne immana. ");
INSERT INTO dwrl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Hinttenttu mishira naattiw immiyaawaanne c'ilooshshaa hinttenttu koyowaa keeshshaa darissiide taana oochchite; taani hinttenttu taana oochcheeddawaa ayaanne immana; shin taani akkanaaddan naatto taw immeerikkitee!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Barenttu michchato Diino Shekeeme tunisseedda diraw, Yaak'ooba attuma naanay Shekeemawunne Aa aawuwaa Hamooraw wordduwaa odeeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","unttuntta hawaadan yaageeddino; «Nuuni hewaa mallaa ootsana danddayokko; nuuni nu michchato k'as's'arettibeenna asaw immokko; hewe nuuna kawushshiyaawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nuuni hinttenttu ittibaa ootsooppe hinttenttoo, ‹Eeno› gaana; hewe ayee gooppe, hinttenttu gadiyaa attuma Asay ubbay k'as's'arettiide nuunaadan hanooppe, ");
INSERT INTO dwrl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","nuuni nu mac'c'a naanaa hinttenttoo immanaw ‹Eeno› gaana; hinttenttu mac'c'a naanaakka nuw akkana. Nuuni hinttenttu giddon uttiide, hinttenana itti asaa gidana. ");
INSERT INTO dwrl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Shin hinttenttu k'as's'arettanaw eeno geenawaa gidooppe, nuuni nu michchato akkiidde baana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Unttunttu geeddawe Hamoorawunne Aa na'aa Shekeemaw lo\"a malateedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","He wodallay, bare aawuwaa gollen de'iyaa ubbaappe aad'd'i bonchchetteeddawe, Yaak'ooba naattin nashetteedda diraw, unttunttu geeddawaa ootsanaw gam\"ibeena. ");
INSERT INTO dwrl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","He wode Hamoorinne Aa na'ay Shekeeme barenttu katamaa gutaraa biide, barenttu katamaa asaw hawaadan yaagiide odeeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Ha asatuu nuunana siga; unttunttu nu biittan de'iinonne zal\"iino; biittay loytsi aaka. Unttunttu mac'c'a naanaakka nuuni akkana; unttunttukka nu mac'c'a naanaa akkana. ");
INSERT INTO dwrl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Shin nuunana unttunttu itti asaadan de'anaw nuuni ittibaa mayettanaw koshshee; hewenne, unttunttu k'as's'aretteeddawaadan nu attuma Asay ubbay k'as's'arettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nuuni hewaadan ootsooppe, unttunttu miizzay, unttunttu mas'uunne unttunttu hara mehii ubbay nuwaa gidennee? Hewaa diraw ane nuuni unttunttu giyaawaa eeno goytte; unttunttukka nu giddon de'ana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Katamaa gutaraa shiik'eedda asatuu ubbay Hamoorawunne Aa na'aa Shekeemaw, «Eeno» geeddino. Yaatina he katamaa attuma asatuu ubbay k'as's'aretteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Heezzentso gallassi, unttunttu ubbay barenttu k'as's'araa madutsan saketi de'ishshin, Yaak'ooba attuma naanatuwaappe laa\"uu, Simooninne Leewii, Diini ishatuu, barenttu mashshaa akkiidde, ooninne erennan katamaa geliide, attuma asatuwaa ubbaa wod'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamooranne Aa na'aa Shekeema mashshaan wod'iide, barenttu michchato Diino Shekeema golliyaappe akkiidde afeedino. ");
INSERT INTO dwrl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yaak'ooba attuma naanay he anhatuwaa bolla geliide, barenttu michchato Diino tunisseedda katamaa bonk'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Unttunttu dorssaa wudiyaa, miizzaa wudiyaa, hariyaa, katamaa giddon de'iyaawaanne gas'an de'iyaawaa ubbaa akkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Unttunttu mas'uwaa ubbaa, unttunttu naanaa ubbaanne machatuwaa ubbaa omoodeeddino; gollen de'eeddawaa ubbaa bonk'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaak'oobi Simoonanne Leewiyaa, «Hinttenttu ta bolla metuwaa ahi kichcheedditta; ha gadiyaan de'iyaa Kanaanatuunne Parzzetuu taana is's'anawantta; nuuni payduwaan guutsa; unttunttu ittippe gidiide ta bolla denddooppe, taaninne ta soo Asay d'ayana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Shin unttunttu, «Yaatina I nu michchato sharmus'aadan ootsana bessii?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","S'oossay hewaappe guyye Yaak'ooba, «Denddaade pude Beeteele baade yan de'a. Neeni ne ishaa Eesaappe bak'atiyaa wode new k'onc'c'eedda S'oossaw yan yarshshiyaa sa'aa kees's'a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaak'oobi bare soo asaanne barenana de'iyaawantta ubbaa, «hinttenttu gidduwaan de'iyaa allaga S'oossatuwaa misiletuwaa diggite; hinttenttu bollaa geeshshite; hinttenttu mayuwaanne laammite. ");
INSERT INTO dwrl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ane denddiide, pude Beeteele boytte; ta metuwaa gallassi taana siseedda, taani beedda sa'aan ubbaan taananna gideedda S'oossaw, taani yan yarshshiyaa sa'aa kees's'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Hewaa diraw unttunttu barenttoo de'iyaa allaga s'oossatuwaa misiletuwaa ubbaanne barenttu haytsaan de'iyaa gudichchaa ubbaa Yaak'oobaw immeeddino; Yaak'oobi hewantta Sekeeman de'iyaa wolaa garssan moogeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Hewaappe guyye, Yaak'oobinne Aa attuma naanay denddiide biishshin, itti uraynne unttuntta oyk'k'anaw kaallibeenna; ayaw gooppe, unttunttu biishshin, unttunttu yuushshuwaan de'iyaa katamaa asaa ubbaa bolla S'oossaa dagamay wod'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaak'oobinne aanana de'iyaa Asay ubbay Kanaane gadiyaan de'iyaa (Beeteele giyaa) Looza gakkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yan I yarshshiyaa sa'aa kees's'eedda; I he sa'aa El-Beeteele giide suntseedda; ayaw gooppe, I bare ishaappe bak'atiide biyaa wode, S'oossay aw k'onc'c'eedda sa'ay hewaa. ");
INSERT INTO dwrl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ribik'o dichchiyaa Deboora yan hayk'k'aaddu; Beeteeleppe hirkkinna de'iyaa wolaa garssan iza moogettaaddu; hewaa diraw he mitsaa suntsay Yeekuwaa Wolaa geetetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yaak'oobi Masp'p'es'oomiyaappe simmeeddawaappe guyye, S'oossay aw zaaretsi k'onc'c'iide, Aa anjjeedda; ");
INSERT INTO dwrl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","S'oossay Aa, «Ne suntsay Yaak'ooba; shin hawaappe sintsanaw neeni ubbakka Yaak'ooba geetettakka; ne suntsay israa'eeliyaa gidana» yaagiide I Aa israa'eeliyaa suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","K'ay S'oossay Yaak'ooba, «Taani Ubbaa Danddayiyaa S'oossaa; neeni yeletta; c'oratta; kawutetsatuunne kawutetsaa Asay neeppe kessana; kaatetuukka ne gulbbataappe kessana. ");
INSERT INTO dwrl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Taani Abrahaamewunne Yisaak'aw immeedda biittaa, k'ay new immay; neeppe guyyenna taani ha biittaa ne zeretsaw immana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Hewaappe guyye, S'oossay aanana haasayeedda sa'aappe pude kesseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaak'oobi S'oossay barenana haasayeedda sa'aan shuchchaa essiide, Aa bolla ushshaa yarshshuwaa tigeedda; zayitiyaakka bolla tigeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yaak'oobi S'oossay barenana haasayeedda sa'aa «Beeteele» giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Unttunttu hewaappe guyye, Beeteeleppe denddeeddino. Unttunttu Efiraataa gakkanaw laafaa ashshiyaa wode, Raaheelo yeluu oyk'k'eedda; yeluwaan iza loytsa waayettaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Yeluu izo waayisseedda wode izo yelissiyaana, «Yayyoppa; hawekka attuma na'aa» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Shin iza hayk'k'aadde, shemppu kesishshin, bare na'aa Been\"oona suntsaaddu; shin Aa aawuu Aa Biiniyaama suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Hewaappe guyye, Raaheela hayk'k'a bashaaddu; Beeteleeme giyaa Efiraataa afiyaa ogiyaa doonaan moogettaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaak'oobi izi duufuwaan hawulttiyaa shuchchaa esseedda; he hawulttii hachche gakkanaw Raaheeli duufuwaa erissee. ");
INSERT INTO dwrl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israa'eelii hewaappe denddiide, Edera gimbbiyaappe hefintsaan bare dunkkaaniyaa tokkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israa'eelii he gadiyaan de'ishshin, Roobeeli biide, bare aawoo yeleedda k'oomatti Baalina giseedda. Israa'eelii ha yewuwaa siseedda. Yaak'ooba attuma naanay tammanne laa\"a. ");
INSERT INTO dwrl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Liya naanay Yaak'ooba bayira na'aa Roobeela, Simoona, Leewa, Yihudaa, Yisaakooranne Zaabiloona. ");
INSERT INTO dwrl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raaheeli attuma naanay Yooseefanne Biiniyaama. ");
INSERT INTO dwrl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raaheeli danggaas'iratti Baali attuma naanay Daananne Nifttaaleema. ");
INSERT INTO dwrl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Liya danggaas'iratti Zilppi attuma naanay Gaadanne Aaseera. Hawanttu Masp'p'es'oomiyaan Yaak'oobaw yeletteedda Aa attuma naanaa. ");
INSERT INTO dwrl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaak'oobi (Kebroona giyaa) K'iriyaati-Arbba'a matan Maamiren de'iyaa, bare aawuwaa Yisaak'a soo yeedda; he sa'ay kase Abrahaamenne Yisaak'i de'eedda sa'aa. ");
INSERT INTO dwrl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Yisaak'i s'eetanne hosppun tammu laytsaa de'eedda; ");
INSERT INTO dwrl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","I daro wodiyaa de'iide, lo\"o c'imi hayk'k'iidde bare mayzzan gaketeedda. Aa naanay Eesaynne Yaak'oobi Aa moogeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Eedooma giyaa Eesaa yeletay hawaappe kaalliide s'aafetteeddawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Eesay Kanaane biittaa mac'c'a naanatuwaappe barew machchetuwaa akkeedda; unttunttune Hiitiyaa Eloona naatto Aado, Hiiwiyaa S'ibaa'oona na'ay Aani yeleedda Oholiibaamonne. ");
INSERT INTO dwrl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Isimaa'eela naatto, Nabaayoota michchato Baasemaato. ");
INSERT INTO dwrl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Aada Eesaw Elifaaza yelaaddu; Baasemaatakka Ra'u'eela yelaaddu; ");
INSERT INTO dwrl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholiibaama Ya'uusha, Yaa'ilaamanne K'oraaha yelaaddu; Kanaane gadiyaan Eesaw yeletteedda attuma naanay hawantta. ");
INSERT INTO dwrl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Eesay bare machchetuwaa, bare attuma naanaanne mac'c'a naanaa, bare soo asaa ubbaa, bare miizzatuwaanne bare mehiyaa ubbaa Kanaane gadiyaan I mooddeeddawaa ubbaa akkiidde, bare ishaa Yaak'oobappe haakkiyaa gadiyaa beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Unttunttu mas'uu dareedda diraw, unttunttu ittippe de'anaw danddayibeykkino; unttunttu mehii dareedda diraw, unttunttu de'iyaa biittay unttunttu mehiyaw gidanaw danddayibeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yaatina Eedooma giyaa Eesay Se'iira giyaa gezziyaan utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Se'iira gezziyaan de'eedda Eedoomatuwaa aawuwaa Eesaa yeletay hawaappe kaalliide s'aafetteeddawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Hawe Eesaa attuma naanaa suntsaa; hewanttunne Eesaa machchatti Aadi na'aa Elifaazanne Eesaa machchatti Baasemaati na'aa Ra'u'eela. ");
INSERT INTO dwrl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaaza naanay Temaana, Omaara, S'afa, Ga'itaamanne K'anaaza. ");
INSERT INTO dwrl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","K'ay Timinaa'a Eesaa na'aa Elifaazaw k'oomatuwaa; iza Elifaazaw Amaaleek'a yelaaddu. Hawanttu Eesaa machchatti Aadi na'aa naanaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ra'u'eela attuma naanay Nahaata, Zaraaha, Shammanne Miizaa; hawanttu Eesaa machchatti Baasemaati na'aa naanaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","S'ibaa'oona na'ay Aani yeleedda Oholiibaama attuma naanay hawantta; iza Eesaw Ya'uusha, Yaa'ilaamanne K'oraaha yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Eesaa yeletaa kaappatuu hawaappe kaalliide s'aafetteeddawantta. Eesaw bayira na'aa Elifaaza attuma naanay, kaappuwaa gideeddawanttu Temaana, Omaara, S'afa, K'anaaza, ");
INSERT INTO dwrl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","K'oraaha, Ga'itaamanne Amaaleek'a; Eedooma biittan Elifaazi yeleedda kaappatuu hawantta; hawanttu ubbay Aadi na'aa naanaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Eesaa na'aa Ra'u'eela attuma naanay, kaappuwaa gideeddawanttu Nahaata, Zaraaha, Shammanne Miizaa; Eedooma biittan Ra'u'eeli yeleedda kaappatuu hawantta; unttunttu Eesaa machchatti Baasemaati na'aa naanaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Eesaa machchatti Oholiibaami attuma naanay, kaappuwaa gideeddawanttu Ya'uusha, Yaa'ilaamanne K'oraaha; unttunttu Aana naatti, Eesaa machchatti Oholiibaamippe yeletteedda kaappatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Eedooma giyaa Eesaa attuma naanay hawantta; unttunttu kaappatuukka hawantta. ");
INSERT INTO dwrl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Eedooma gadiyaan de'iyaa Hooriyaa Se'iira attuma naanay hawaappe kaalliide s'aafetteeddawantta; hewanttukka Los'aana, Shobaala, S'ibaa'oona, Aana, ");
INSERT INTO dwrl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoona, Es'eeranne Dishaana; hewanttu, Eedooma gadiyaan de'iyaa Se'iira attuma naanay, Hooretuwaa kaappatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Los'aana attuma naanay Hooranne Heemaama; Los'aana michchata Timinaa'o. ");
INSERT INTO dwrl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobaala attuma naanay Aaliwaana, Maanahaata, Eebaala, Shefanne Oonaama. ");
INSERT INTO dwrl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","S'ibaa'oona attuma naanay Aayanne Aana; hawe Aani woran bare aawuwaa S'ibaa'oona haretuwaa heemiidde haatsaa bol\"uwaa demmeeddawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aana na'ay Dishoona; naatta k'ay Oholiibaamo. ");
INSERT INTO dwrl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishoona attuma naanay Hemddaana, Eshibaana, Yitiraananne Karaana. ");
INSERT INTO dwrl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Es'eera attuma naanay Bilihaana, Za'iwaananne Ak'ana. ");
INSERT INTO dwrl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishaana attuma naanay Uus'anne Araana. ");
INSERT INTO dwrl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hooretuwaa kaappatuu hawantta; Los'aana, Shobaala, S'ibaa'oona, Aana, ");
INSERT INTO dwrl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishoona, Es'eeranne Dishaana. Hawanttu Se'iira biittan barenttu yaran yaran shaaketteedda Hooretuwaa kaappatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israa'eelan kaatii kawutanaappe kase Eedooma biittan kaateteedda kaatetu hawaappe kaalliide s'aafetteeddawantta. ");
INSERT INTO dwrl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ba'oora na'ay Belaa'i Eedooman kaateteedda; Aa katamaa suntsay Dinaaba geetettee. ");
INSERT INTO dwrl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Belaa'i hayk'k'ina, Boos'irappe yeedda Zaraaha na'ay Yobaabi kaateteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobaabi hayk'k'ina, Temaana biittaappe yeedda Hushaami kaateteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushaami hayk'k'ina, Badaada na'ay Hadaadi, Midiyaama asaa moo'aabe gadiyaan s'ooneeddawe kaateteedda; Aa katamaa suntsay Awiita geetetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaadi hayk'k'ina, Maasireek'appe yeedda Saamili kaateteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Saamili hayk'k'ina, shaafaa matan de'iyaa Rahobootappe yeedda Shaa'uuli kaateteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaa'uuli hayk'k'ina, Akiboora na'ay Ba'aalihanaani kaateteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akiboora na'aa Ba'aalihanaani hayk'k'ina, Hadaari kaateteedda; Aa katamaa suntsay Paa'u geetettee; Aa machata Mezaahaaba naatta Maas'ireeda yeleedda Mahes'aabi'eelo geetettaw. ");
INSERT INTO dwrl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Eesaa yeletaa kaappatuu barenttu yaran yaran, barenttu sa'aan ellekka barenttu suntsan suntsan hawantta; Timinaa'a, Aliwa, Yeteeta, ");
INSERT INTO dwrl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholiibaama, Eela, Piinoona, ");
INSERT INTO dwrl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","K'anaaza, Temaana, Mibs's'aara, ");
INSERT INTO dwrl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Maagidi'eelanne Iraama. Hawanttu barenttu mooddiyaa biittan, barenttu de'iyaa sa'aan de'iyaa sa'aan Eedooma kaappatuwaa. Hawe Eesay, Eedoomatuwaa aawuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaak'oobi bare aawuu de'eedda Kanaane biittan utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yaak'ooba naanay haneeddabay hawaappe kaalliide s'aafetteeddawaa. Yooseefo tammanne laappun laytsaa na'aa gideedda wode, bare aawoo hara machchetuwaappe, Baalippenne Zilppippe yeletteedda bare ishatuwaanna wudiyaa heeme. He wode I bare aawoo unttunttu ootseedda iitabaa odeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israa'eelii Yooseefa c'imiide yeleedda diraw, bare hara attuma naanaa ubbaappe aatsiide siik'ee. I aw alleek'k'eedda mayuwaa giigisseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Aa ishatuu barenttu aawuu Aa unttunttuppe aatsiide siik'iyaawaa be'eedda wode, unttunttu Aa is's'iide, lo\"o k'aalaa aw haasayanaw danddayibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yooseefo akumuwaa akumetiide, bare ishatoo odeedda; unttunttu Aa yaa darissiide is's'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","I unttuntta, «Taani akumeteedda akumuwaa sisite. ");
INSERT INTO dwrl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nuuni gaden pochchiyaa k'achchishin, ta mirk'k'ii itti kutsaan denddiide sitti gi ek'k'ishshina, hinttenttu mirk'k'etuu yuuyyi aad'd'iide ta mirk'k'iyaw goynneeddinno» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Aa ishatuu Aa, «Neeni nu bollan kaatetana hanayiyee? Woy nuuna tumu mooddana hanayiyee?» yaageeddino. Unttunttu Aa akumuwaa dirawunne Aa oduwaa diraw, yaa darissiide is's'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","K'ay Yooseefo hara akumuwaa akumetiide, bare ishatoo odeedda; «sisite; taani hara akumuwaakka akumetaad. He akumuwaan away, aginaynne tammanne itti s'oolinttetuu taw goynniino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Bare aawoonne bare ishatoo he akumuwaa odeedda wode, Aa aawuu Aa, «Hawe neeni akumeteedawe ayaa akumee? Tumu taani, ne daayanne ne ishatuu yiide, ne sintsaan sa'aan guufaniide new goynnaneyye?» yaagiide seereedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Aa ishatuu Aa k'anaateeddino; shin Aa aawuu ha yewuwaa bare wozanaan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Itti gallassi Aa ishatuu Sekeema matan barenttu aawuwaa dorssaa heemanaw beeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israa'eelii Yooseefa, «Ne ishatuu Sekeeman wudiyaa heemiyaawaa eraasa. Haaya; taani neena unttunttukko kiittana» yaageedda. Yooseefo, «Eeno» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","I Aa, «Ba; ne ishatuwaanne wudii sara gidiyaawaa be'a; unttunttubaa taw odaasa» yaageedda. Aa Kebroona dilbbaappe kiitteedda. I Sekeema beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Yan dembbaa giddon yaa haa simerettishin, itti Asay Aa demmiide, «Laa ayaa koyay?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","I, «Ta ishatuwaa koyay; unttunttu wudiyaa heemiyaa sa'ay hak'anentto hayana taw odaarikkii!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Bitanii, «Hawaappe denddi kichcheeddino; unttunttu, ‹Nuuni Dootaana beto› giishin sisaad» yaageedda. Hewaa diraw, Yooseefo bare ishatuwaa geeduwaa biide, unttuntta Dootaanan demmeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Shin I haakuwaan de'ishshin, unttunttu Aa be'eeddino; I unttunttukko gakkennan de'ishshin, unttunttu Aa wod'anaw Aa bolla mak'etteeddinno. ");
INSERT INTO dwrl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ittuu ittuwaa, «Be'ite! Akumuwaawu yee. ");
INSERT INTO dwrl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Haayite; Aa wod'iide, ha ollatuwaappe ittuwaa giddo yeggoytte. Hewaappe guyye, ‹Iita do'ay Aa meedda› yaagana; yaatiide Aa akumuu ahiyaawaa be'ana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Roobeeli hewaa siseedda wode, unttunttu kushiyaappe Aa ashshanaw koyiide, «Aa wod'enaan aggoytte. ");
INSERT INTO dwrl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Suutsaa gussoppite; Aa hinttenttu woran de'iyaa ha ollaa giddo olite; Aa bolla kushiyaa wotsoppite» yaageedda. Roobeeli hawaa Aa unttunttuppe ashshiide guyye Aa aawuwaakko yeddanaw geedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yooseefo bare ishatuwaakko gakkeedda wode, I mayyeedda alleek'k'eedda mayuwaa aappe k'aari akkeeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Aa afiide haatsay baynna mela ollaan yegeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Unttunttu barenttu k'umaa maanaw utti de'ishshin, Isimaa'eela asatuu Gibs'e baanaw Gala'aadeppe yiyaawantta d'ok'k'u giide be'eeddino; unttunttu barenttu gaaluwaan sawuwaa, balasaane giyaa d'aliyaanne karbbiyaa c'aani wotseeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yihuday bare ishatuwaa, «Nuuni nu ishaa wod'iide Aa suutsaa k'osiyaawaa gidooppe nuuna ayaa go\"ii? ");
INSERT INTO dwrl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Haayite; Aa Isimaa'eelatoo zal\"oytte; Aa bolla nu kushiyaa wotsokko; ayaw gooppe, I nu ishaa, nu ashuwaa» yaageedda. Aa ishatuu mayetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hewaa diraw Midiyaama biittaa zal\"anchchatuu hewaanna aad'd'ishshin, Aa ishatuu Yooseefa ollaappe kessiide, Isimaa'eela asatoo laatamu s'agaraa biraan zal\"eeddino. Unttunttu Yooseefa Gibs'e gadiyaa afeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Roobeeli ollaakko simmiide, Yooseefo yan baynnawaa be'eedda wode, kayyotiide bare mayuwaa pooshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","I guyye bare ishatuwaakko biide, «Na'ay yan baawa; ha\"i taani hak'a booshsha!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hewaappe guyye unttunttu Yooseefo mayuwaa akkiidde, deeshsha orggiyaa shukkiide, he suutsan naak'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Alleek'k'eedda Aa mayuwaa barenttu aawuwaakko afiide Aa, «Nuuni hawaa demmeeddo; hawe ne na'aa mayenttonne ane s'eella» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Mayuwaa I eriide, «Hawe ta na'aa mayuwaa! wora do'ay Aa mi diggeedda. Yooseefo tumukka dus's'ereti kichcheedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yaak'oobi kayyottiidde, bare mayuwaa peed'eedda; bare s'eessan waaruwaa danc'c'iidde, bare na'aw daro gallassaa yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Aa attuma naanaynne mac'c'a naanay ubbay Aa mintsetsanaw yeeddino; shin I minnenaan is's'iide, «tuytti, taani yeekkaadde ta na'aakko baade, duufuwaan gelana» yaagiide, Aa aawuu aw yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","He wode Miidiyaama biittaa asatuu Yooseefa Gibs'e kaatiyaa oosanchchaa P'oos'ifaaraw Gibs'en zal\"eeddino; I naagiyaawanttu kaappuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","He wode Yihuday bare ishatuwaappe shaakettiide, Adulaama giyaa kataman de'iyaa Hiira giyaa bitaniyaanna de'anaw beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yan Yihuday Shuu'a giyaa Kanaane naattinna gaketeedda; I izo akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Iza aw shahaaraade attuma na'aa yelaaddu; Aa Eera suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","K'aykka shahaaro wode attuma na'aa yelaaddu; Aa Oonaana suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","K'ay gujjaadekka attuma na'aa yelaaddu; Aa Sheela suntsaaddu. Iza yeleeddawe Akiziiba giyaa biittaana. ");
INSERT INTO dwrl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yihuday bare bayira na'aa Eeraw Ti'imaaro giyaa machchato immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yihudaa bayira na'ay, Eeri, Med'inaa Godaa sintsaan iita asaa gidiyaa diraw, Med'ina Goday Aa wod'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yihuday Oonaana, «Ne ishaa machchatikko gelaade, izo akka; ne ishaw na'aa yelaade Aa s'eesissa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Shin Oonaani yelettiyaa naanay barewantta gidenawaa ereedda; hewaa diraw bare ishaa machchattinna gisiyaa wode awudenne, bare ishaw na'i yelettenna mala, bare zeretsaa biittan gussee. ");
INSERT INTO dwrl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","I ootseeddabay Med'inaa Godaa sintsaan iitabaa gideedda diraw, Med'inaa Goday aakka wod'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Hewaappe guyye, Yihuday bare na'aa machchato Ti'imaaro, «Ta na'ay Sheeli dic'c'ana gakkanaw ne aawuwaa soo baade, am\"etetsaan de'ashsha» yaageedda. Hewaa I ayaw geedde gooppe, ikka bare ishatuwaadan hayk'k'anenttonne giide hirggeedda diraassa. Hewaa diraw Ti'imaara baade bare aawuwaa soon de'aaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Daro wodiyaappe guyye Yihudaa machata, Shuu'a naatta hayk'k'aaddu. Yihuday bare kayyuwaappe minetteedda wode, bare dorssaa isikiyaa meediyaa asatuwaakko Timina kesseedda; k'ay Aa lagge, Adulaamiyaa Hiiri aanana beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Aasi Ti'imaaro, «Be'a; ne bolluu Yihuday, bare dorssatuwaa isikiyaa meedanaw Timina kesseedda» yaagiide odeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Iza bare am\"etetsaa mayuwaa k'aaraaddu; barena baletsanaw shaashiyaa akkaade gullottaaddu. Timina afiyaa ogiyaa doonaan de'iyaa Enayma katamaa penggiyaan uttaaddu. Hewaa iza ootseeddawe, Sheeli dic'c'i gakkinkka iza aw machchatto gidanaw imettabeennawaa ereedda diraassa. ");
INSERT INTO dwrl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yihuday izo be'eedda wode, sharmus'atto giide k'oppeedda; ayaw gooppe, iza bare deemuwaa gullotta uttaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Bare na'aa machchato gidiyaawaa erennan de'iide, ogiyaa gas'aa iikko shiik'iide izo, «Taananna gisaarikii!» yaageedda. Iza, «Taani neenana gisooppe, neeni taw ayaa immanii?» yaagaadde oochchaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","I, «Taani ta wudiyaappe itti deeshsha maraa new yeddana» yaageedda. Iza, «Neeni hewaa taw yeddana gakkanaw ayaa ootsanii?» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","I, «Ayaa ootsoo?» yaageedda. Iza, «Ne maatafaa wotsiyaa migiduwaa, Aa aatsiyaa sak'k'iyaanne ne kushiyaan de'iyaa gatimaa oytsa» yaagaaddu. I hewantta immiide, izina gisina, iza aw shahaaraaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Iza hewaappe denddaade beeddawaappe guyye, bare gullotsaa shaashiyaa k'aaraade, bare am\"etetsaa mayuwaa mayyaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yihuday bare oytseeddawaa he mishiratippe zaari akkanaw deeshsha maraa bare laggiyaa Adulaama bolla iziw kiitteedda; shin I izo demmibeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","I he biittaa asaa, «Enayma kataman, ogiyaa doonaan utteedda sharmus'a mishirata hak'anee?» yaagiide oochcheedda. Aasi, «Sharmus'a mac'c'aanna hawaan ubbakka baawa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","I Yihudaakko simmiide Aa, «Taani izo demmabeykke; hewaa bollakka he biittaa asay, ‹Sharmus'a mac'c'aanna hawaan ubbakka baawaa› yaageedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yihuday, «Bare oyk'k'eeddawaa barew akku; hewe d'ayooppe, Asay nuuna miic'c'ana. Simmi taani iziw deeshsha maraa yeddaad; shin neeni izo demmabeykka» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Heezzu aginaa keeshshaappe guyye asay, «Ne na'aa machata Ti'imaara sharmus'aade shahaaraaddu» yaagiide Yihudaw odeedda. Yihuday, «Izo kare kessiide taman s'uuggite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Izo kare kessiyaa wode, «Taani shahaareeddawe ha miishshaa godaassa; be'a; ha maatafaa wotsiyaa migiduu, Aa aatsiyaa sak'k'iinne gatimay oowentto erana danddayooppe era» yaagaadde bare bolloo kiitaa kiittaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yihuday he miishshatuwaa eriide, «Taappe iza s'illa; ayaw gooppe, taani izo ta na'aa Sheelaw immabeykke» yaageedda. Hewaappe guyye, I izina zaari gisibeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Iza yelana haniyaa wode, izi uluwaan mantte attuma naanay de'iino. ");
INSERT INTO dwrl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Iza yelishiin, unttunttuppe ittuu bare kushiyaa keseedda; maarissiyaanna, «Be'ite; hawe koyro kesseedda» gaanaw zo'o k'unc'c'uutiyaa akkaade Aa kushiyaan k'achchaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Shin I bare kushiyaa guyye akkeedda wode, Aa ishay kesseedda; iza, «Neeni waana portsu gaade kesaadii!» yaagaaddu. Hewaa diraw, Paareesa gaade Aa suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Hewaappe guyye, Aa kushiyaan zo'o k'unc'c'uutii de'iyaa Aa ishay keseedda; Aa suntsay Zaaraaha geetetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isimaa'eela asatuu Yooseefa Gibs'e afi wotseeddino. Gibs'aawe P'oos'ifaari, kaatiyaa oosanchchatuwaappe ittuu, naagiyaawanttu kaappuu Yooseefa Isimaa'eeletuwaappe shammeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Med'inaa Goday Yooseefonna de'ee; hewaa diraw, I ootsiyaawaa ubbaa aw injjeyeedda; yaatina bare godaa, Gibs'aawiyaa soon de'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Med'inaa Goday aanana de'iyaawaanne Med'inaa Goday I ootseeddawaa ubbaa aw suurisiyaawaa P'oos'ifaari be'eedda wode, ");
INSERT INTO dwrl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yooseefo Aa sintsaan nashetteedda; I aw kiitetteedda. P'oos'ifaari Aa bare golle asaa bolla suntseedda; barew de'iyaawaa ubbaa Aa kushiyaan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","P'oos'ifaari bare gollen de'iyaawaa ubbaa bollanne bare mas'uwaa ubbaa bolla suntseedda wodiyaappe doommiide, Med'inaa Goday Gibs'e bitaniyaa golliyaa Yooseefo diraw anjjeedda. Med'inaa Godaa anjjuu P'oos'ifaara sooninne gaden de'eedda ubbabaa bolla wod'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Hewaa diraw barew de'iyaa ubbabaa Yooseefow sheed'd'eedda; I bare miyaa k'umaappe attina, ayinne k'oppenna. Yooseefo geesanchanne malaa lo\"o asaa. ");
INSERT INTO dwrl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Amareeda wodiyaappe guyye, Aa godaa machata Yooseefa s'eella be'aade, «Haaya; taananna gisa» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Shin I is's'eedda. Bare godaa machchatto, «Be'a; ta goday taw sheed'd'iide bare son de'iyaabaw ayawunne hirggenna; barew de'iyaawaa ubbaa ta kushiyaan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ha son taappe gitatiyaawe ooninne baawa. Neeni Aa machchatto gidiyaa diraw ne s'alalaappe attina, ta goday taw immibeennabay baawa. Yaatina taani waataade hawaa mala daro iitabaa hanaade S'oossaa bolla nagaraa ootsoo?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Iza ha yewuwaa hachche hachche Yooseefow odooppenne, I izina gisennan woy izi matan uttennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Itti gallassi I bare oosuwaa ootsanaw soo geliyaa wode, soo k'oomatuwaappe ooninne son baawa. ");
INSERT INTO dwrl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Iza Yooseefo afilaa oyk'k'aadde, «Taananna gisa» yaagaaddu. Shin I bare afilaa I kushiyaan yeggiide, sooppe kare wos's'iide kesseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yooseefo bare afilaa I kushiyaan yeggiide, sooppe kare wos's'i kesowaa iza be'eedda wode, ");
INSERT INTO dwrl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","bare soo k'oomatuwaa s'eesaade unttuntta, «Be'ite; ta asinay aheedda ha Ibraawe bitanii taana baletsi diggiide ashsheeda; I taananna gisanaw hawaa geleedda; shin taani ta kooshshaa d'ok'k'issaade waassaad. ");
INSERT INTO dwrl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Taani waassina siseedda wode, I bare afilaa ta matan yeggiide, sooppe kare wos's'iide kesseedda» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Aa goday soo yaana gakkanaw iza Yooseefo afilaa bare matan wotsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Hewaappe guyye, iza aw hawaadan yaagaadde odaaddu; «Hewe neeni nuw aheedda Ibraawe ayilii taananna gisanaw taakko geleedda; ");
INSERT INTO dwrl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","shin taani ta k'aalaa d'ok'k'issaade waassowe, bare afilaa ta matan yeggiide, sooppe kare wos's'eedda» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Aa goday bare machata, «Ne ayilii taana hawaadan ootseedda» yaagaadde odeedda k'aalaa sisiide, hank'k'uwaan pentteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yooseefa A goday afiide, kaatiyaa k'ashuwaa sa'ay de'iyaa k'asho gollen yeggeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Shin Yooseefo yan k'asho gollen de'iyaa wode, Med'inaa Goday aanana de'ee. I aw k'aretteedda; k'asho golle kaappuwaa sintsan aw nashshuwaa immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Yaatina k'asho golle kaappuu k'ashuwaa asaa ubbaa Yooseefo kushiyaan wotseedda; hewaan oosettiyaawaa ubbaa ootsiyaawe Aa. ");
INSERT INTO dwrl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","K'asho golle kaappuu Yooseefo kushiyaan de'iyaabaw ayawunne hirggenna; ayaw gooppe, Med'inaa Goday aanana de'ee; I ootsiyaawaakka ubbaa aw injjeyeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Amareeda wodiyaappe guyye, Gibs'e kaatew eessaa tigiyaawenne ukitsaa uukkiyaawe barenttu godaa Gibs'e kaatiyaa naak'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kaatii eessaa tigiyaawanttu kaappuwaanne ukitsaa uukkiyaawanttu kaappuwaa laa\"uwaakka loytsi hank'k'etteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Yooseefo k'ashetteedda k'asho gollen, naagiyaawanttu kaappuwaa son unttuntta wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Naagiyaawanttu kaappuu unttuntta Yooseefow sheed'd'eedda; I unttunttoo ootsee. Unttunttu k'asho gollen amareeda wodiyaa utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gibs'e kaatiyaw eessaa tigiyaawenne ukitsaa uukkiyaawe, k'asho gollen de'iyaa laa\"attuukka, itti k'amma dumma dumma akumuwaa akumeteeddino. K'ay akumotoo huup'iyaan huup'iyaan unttunttu biletsay de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yooseefo wontta unttunttukko geleedda wode, kayyoti utteeddawantta be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Hewaa diraw bare godaa soon barenana k'asho gollen de'iyaa kaatiyaa oosanchchatuwaa, «Hachche hinttenttu demuu ayaw d'umeedee?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Unttunttu Aa, «Nuuni laa\"u akumuwaa akumetteeddo; shin nuw biliyaawe d'ayeedda» yaageeddino. Yooseefo unttuntta, «Akumuwaa biletsay S'oossawaa gidenneeyyee? Hinttenttu akumuwaa taw odite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Eessaa tigiyaawanttu kaappuu bare akumuwaa Yooseefow hawaadan yaagiide odeedda; «Taani ta akumuwaan itti woyniyaa turaa ta sintsaan be'aaddi. ");
INSERT INTO dwrl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","K'ay he woyniyaa turaw heezzu tashii de'ee. I maraa yeliide, c'iishshaa c'iishiide, wurc'c'uwaa wurc'c'eedda; wurc'c'unne teereedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kaatiyaa wanc'c'ay ta kushiyaan de'ee; taani woyniyaa teeraa akkaade, kaatiyaa wanc'c'an gum\"aade, he wanc'c'aa Aa kushiyaan wotsaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yooseefo, «Hewaa birshshetsay hawaa; heezzu tashetuu heezzu gallassatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Heezzu gallassaa gidduwaan kaatii neena dentsana; I neena kase ne suntsatetsaw zaarana; kase neeni eessaa tigiyaa wode ootseeddawaadan, neeni kaatiyaa wanc'c'aa Aa kushiyaan wotsana. ");
INSERT INTO dwrl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Shin new sa'ay lo\"eedda wode taana dogoppa; taw lo\"a; tabaa kaatiyaw odaadde, ha k'asho golliyaappe taana kesissa; ");
INSERT INTO dwrl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ayaw gooppe, taana Ibraawetuwaa biittaappe gidiide aheeddino; haray atto hawankka taana k'ashissiyaawaa ayinne ootsabeykke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ukitsaa uukkiyaawanttu kaappuu Yooseefo akumuwaa loytsi billeeddawaa be'eedda wode Yooseefo, «Taanikka akumuwaa akumetaad; ta huup'iyaan heezzu samppa ukitsay de'ee; ");
INSERT INTO dwrl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","bolla bagga samppan Gibs'e kaatiyaw uuketteedda ubbaa k'ommo ukitsay de'ee. Shin kafuu hewaa ta huup'iyaan de'iyaa samppaappe mee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yooseefo, «Hewaa birshshetsay hawaa; heezzu samppatuu heezzu gallassatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Heezzu gallassaa giddon kaatii neena dentsana; ne k'ood'iyaa muuc'issiide mitsaan kak'issana; ne ashuwaakka kafuu maana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Heezzentso gallassan Gibs'e kaatii bare yeletteedda gallassi bare oosanchchatuwaa ubbaw baalaa giigisseedda. Eessaa tigiyaawanttu kaappuwaanne ukitsaa uukkiyaawanttu kaappuwaa dentsiide, bare oosanchchatuwaa giddon esseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Eessaa tigiyaawanttu kaappuwaa Aa suntsatetsaw zaarina, I kaatiyaa kushiyaan wanc'c'aa wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Shin kaatii ukitsaa uukkiyaawanttu Kaappuwaa unttunttu akumuwaa biletsaa Yooseefo odeeddawaadankka kak'isseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Shin eessaa tigiyaawanttu kaappuu Yooseefo hassayibeenna; dogiisheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Laa\"u laytsaa kumentsay aad'd'eedda wode, Gibs'e kaatii akumuwaa akumeteedda; akumuwaan I Nayle Shaafaa doonaan ek'k'eedda; ");
INSERT INTO dwrl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Laappun orddenne mod'd'o miizzatuu Nayle Shaafaappe kes wod'd'iide, mak'k'aa gidduwaan miyaawantta be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Unttunttuppe simmiide, hara laappun malaa iitanne gilk'k'a miizzatuu Nayle Shaafaappe keseeddino; shaafaa doonaan de'iyaa hara miizzatuu matan ek'k'eeddinno. ");
INSERT INTO dwrl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","He malaa iitanne gilk'k'a miizzatuu laappun orddanne mod'd'o miizzatuwaa meeddino. Hewaappe guyye kaatii beegotteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","I zaaretsi gem\"ishiide, laa\"entso akumuwaakka akumeteedda; laappun lo\"anne muruta tishatuu itti anuwaan dic'c'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Unttunttuppe simmiide, c'eec'c'edanne away doliyaa bagga c'arkkuwaan shulleedda hara laappun tishatuu keseeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","He c'eec'c'eedda tishatuu lo\"anne muruta tishatuwaa mitteeddino. Hewaappe guyye kaatii beegottiide, akumuwaa gidiyaawaa ereedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Sa'ay wonttina, Aa wozanay shabbiretteedda; hewaa diraw Gibs'en de'iyaa bitiyaawanttu ubbawunne aad'd'eeda eranchchatuwaa ubbaw kiittiide s'eesisseedda; kaatii unttunttoo bare akumuwaa odeedda; shin aw he akumuwaa birshshiyaawe d'ayeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Eessaa tigiyaawanttu kaappuu he wode Gibs'e kaatiyaa hawaadan yaageedda; «Taani ta bayzzuwaa hachche hassayay. ");
INSERT INTO dwrl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Itti gede kaatii bare k'oomatoo hank'k'ettiide, taananne ukitsaa uukkiyaawanttu kaappuwaa k'asho gollen yeggeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yan de'iidde nuuni huup'iyaan huup'iyaan akumuwaa akumetteeddo; akumoo dumma dumma birshshetsay de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","He wode naagiyaawanttu kaappuu, k'oomay, Ibraawe wodallay nuunana k'asho gollen de'ee. Nuuni nu akumuwaa aw odeeddo; I nuw huup'iyaan huup'iyaan akumuwaa birshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Yaanina he yewotuu I nuw billeeddawaadankka haneeddino. Hewe ayee gooppe, taani ta suntsatetsaw simmaad; hinkko bitanii kak'etteedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Gibs'e kaatii Yooseefow kiittiide s'eesisseedda. Unttunttu Aa k'asho golliyaappe ellekka aheeddino. I meedettiide bare mayuwaa laammiide, kaatiyaakko geleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kaatii Yooseefo, «Taani akumuwaa akumetaad; shin Aa ittuunne billanaw danddayibeenna. Shin taani, ‹Yooseefo akumuwaa sisooppe, billanaw danddayee› giyaawaa sisaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yooseefo, «Taani hewaa danddaykke; shin S'oossay kaatiyaw likke birshshetsaa immana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kaatii, «Taani ta akumuwaan Nayle Shaafaa doonaan ek'k'a de'ishin, ");
INSERT INTO dwrl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","laappun orddanne mod'd'o miizzatuu Nayle Shaafaappe kesiide, mak'k'aa gidduwaan miino. ");
INSERT INTO dwrl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Unttunttuppe simmiide, hara laappun malaa iita, gilk'k'anne laafa miizzatuu keseeddino; taani hewaa mala malaa iita miizzaa Gibs'e gadiyaan ubbakka be'a erikke. ");
INSERT INTO dwrl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Malaa iitanne laafa miizzatuu koyrowantta, laappun mod'd'o miizzatuwaa meeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Shin unttuntta meeddawaappe guyyenna, unttunttu meeddawaa ooninne eranaw danddayibeenna; ayaw gooppe, unttunttu malay kasewaadankka iiti utteedda. Hewaappe guyye taani beegottaad. ");
INSERT INTO dwrl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«Taani ta akumuwaan k'ay laappun lo\"anne muruta tishatuwaa itti anuwaan dic'c'eeddawantta be'aaddi. ");
INSERT INTO dwrl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Unttunttuppe simmiide, c'eec'c'edanne away doliyaa bagga c'arkkuwaan shulleedda hara laappun tishatuu keseeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","He c'eec'c'eedda tishatuu laappun lo\"o tishatuwaa mitteeddino. Taani ha akumuwaa bitiyaawanttoo odaad; shin taw akumuwaa biliyaawe beettibeenna» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Hewaappe guyye Yooseefo Gibs'e kaatiyaa, «Kaatiyaa akumotuu ittuwaa. S'oossay bare ootsana haniyaawaa kaatiyaw k'onc'c'isseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","He laappun lo\"o miizzatuu laappun laytsatuwaa; k'ay laappun lo\"o tishatuu laappun laytsatuwaa; ha akumuu ittuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","He laappun malaa iitanne laafa miizzatuu laappun laytsatuwaa; k'ay away doliyaa bagga c'arkkuwaan shulleedda, c'eec'o laappun tishatuu laappun koshaa laytsatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","«Taani kaatiyaw odeeddawaadankka, S'oossay bare ootsana haniyaawaa kaatiyaw besseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Laappun daro kalo laytsatuu Gibs'e biittaw ubbaw yaana; ");
INSERT INTO dwrl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","shin laappun koshaa laytsay hewaa kaallana. He wode Gibs'e kaluu ubbay dogettana; koshay biittaa s'iis's'ana. ");
INSERT INTO dwrl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","He biittaa kaluu hassayettenan attanawaa; ayaw gooppe, hewaa kaalleedda koshay loytsi suullana. ");
INSERT INTO dwrl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Laa\"u ogiyaan kaatiyaw he akumuu beetteeddawe ayaasee gooppe, ha yewuwaa S'oossay minisiidde k'achcho diraassa; S'oossay hewaa ellekka ootsana. ");
INSERT INTO dwrl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«Ha\"i simmi, kaatii aad'd'eeda eranchchanne c'inc'c'a asaa koyiide, Gibs'e biittan suntso. ");
INSERT INTO dwrl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kaatii biittan suntsatuwaa laappun kalo laytsaan bukiyaa katsaappe ichcheshu kushiyaappe ittuwaa shiishshanaw suntso. ");
INSERT INTO dwrl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Unttunttu yiyaa kalo laytsatuwaan katsaa shiishshiide, kaatiyaa aawotetsaan minjjino; he katsaa katamatuwaan naagino. ");
INSERT INTO dwrl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Biittay koshaan d'ayenna mala, ha katsay Gibs'e biittan laappun laytsaan denddana koshaw minjjettiide de'o» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ha yewuu Gibs'e kaatiyawunne Aa oosanchchatoo lo\"a gidiide beetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Hewaa diraw kaatii unttuntta, «Nuuni S'oossaa Ayyaanana de'iyaa hawaa mala hara asaa demmaneeyye?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hewaappe guyye kaatii Yooseefo, «S'oossay hawaa ubbaa neena erisseedda diraw, ne mala aad'd'eeda eraynne c'inc'c'atetsay de'iyaawe ooninne baawa. ");
INSERT INTO dwrl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Taani neena ta gollen suntsay; ta Asay ubbay new azazettana; taani neeppe aad'd'iyaawe ta kawutetsaa araataa s'alalaana gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Hewaa diraw kaatii Yooseefo, «Be'a; taani neena Gibs'e gadiyaa ubbaa bollan suntsaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Hewaappe guyye, kaatii bare paramiyaa migiduwaa bare birad'd'iyaappe kessiide, Yooseefo birad'd'iyaan wotseedda. Talbbaappe dadetteedda mayuwaa I Aa mayzziide, Aa k'ood'iyaankka work'k'aa sanssalataa aatseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kaatii bare laa\"entso paraa gaariyaa Yooseefa togisseedda; k'oomatuu, «Goynnite! Goynnite!» yaagiidde aappe sintsanna hametteeddino. Hawaadan ootsiide, kaatii Aa Gibs'e biittaa ubbaa bollan suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Hewaappe guyye kaatii Yooseefo, «Taani kaatiyaa; shin neeni dentso geenan Gibs'e biittaa ubbaan ooninne kushiyaa woy gediyaa dentsenna» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kaatii Yooseefa, «S'aafinaati-Pa'inaaha» giide suntseedda; I aw Oona giyaa katamaa k'eesiyaa P'oos'ifaara naatto Asinaato machche ootsi immeedda. Yaatina Yooseefo Gibs'e biittaa ubbaa saanna aad'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yooseefo Gibs'e kaatiyaw ootsanaw doommiyaa wode, aw laytsay hattama. K'ay Yooseefo kaatiyaa sintsappe kesiide, Gibs'e biittaa ubbaa gidduwaa hametteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","He laappun kalo laytsatuwaan biittay daro katsaa doleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yooseefo Gibs'e biittan he laappun kalo laytsaa katsaa ubbaa shiishshiide, katamatuwaan minjjeedda. Itti itti katamaa yuushshuwaan de'iyaa goshshaa katsaa ubbaa he katamatuwaan minjjeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yooseefo abbaa shafiyaa keeshshaa daro katsaa minjjeedda; katsay darina, makkanaw danddayibeenna diraw, makki makki k'oliyaawaa aggi basheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Koshaa laytsay yaanaappe kase, Oona katamaa k'eesiyaa P'oos'ifaara naatti Asinaatippe Yooseefo laa\"u attuma naanaa yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yooseefo bare bayira na'aa Minaasa suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Laa\"entso na'aa Efireema suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Gibs'e biittan de'iyaa he laappun kalo laytsatuu wureeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","K'ay Yooseefo odeeddawaadan laappun koshaa laytsatuu doommeeddino. Hara biittan ubbaan koshay denddeedda; shin Gibs'e biittaa ubbaan katsay de'ee. ");
INSERT INTO dwrl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Gibs'e biittay ubbay koshateedda wode, Asay katsaw kaatiyaa waasseedda. Kaatii Gibs'e asaa ubbaa, «Yooseefokko biite; I odiyaawaa ootsite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Koshay Gibs'e biittaa ubbaa gakkeedda wode, Yooseefo katsaa minjjeedda golliyaa ubbaa dooyiide, katsaa Gibs'e asaw zal\"eedda; ayaw gooppe, Gibs'en koshay pentteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Sa'aa ubbaan koshay s'iis's'i de'iyaa diraw, sa'aan de'iyaa Asay ubbay katsaa Yooseefoppe woomanaw Gibs'e yeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaak'oobi Gibs'en katsay de'iyaawaa siseedda wode, bare attuma naanaa, «hinttenttu ittuu ittuwaa ayaw s'eelliitee? ");
INSERT INTO dwrl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Be'ite! Gibs'en katsay de'iyaawaa taani sisaad; yaa duge biide, nuuni hayk'k'ennan pas'a de'ana mala, yaappe amareedawaa nuw woomite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yooseefo ishatuu tamattu katsaa woomanaw duge Gibs'e beeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Shin Yaak'oobi Yooseefo ishaa Biiniyaama Aa ishatuwaanna yeddibeenna; ayaw gooppe, I k'ohettanenttonne giide k'oppeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaane biittan wolk'k'aama koshay de'iyaa diraw, katsaa woomanaw yeeddawanttuna israa'eeliyaa attuma naanay Gibs'e geleeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","He wode Yooseefo he biittaa ayissiyaawanttanne biittan de'iyaa asaw ubbaw katsaa zal\"iyaawaa; hewaa diraw Yooseefo ishatuu gakkeedda wode, barenttu deemuwaa sa'aa gatsiide aw goynneeddinno. ");
INSERT INTO dwrl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yooseefo bare ishatuwaa be'o saani eri aggeeda; shin I unttuntta erennawaadan laametteedda; I unttuntta, «hinttenttu hak'appe yeedditee?» yaagiide oochcheedda. Unttunttu, «Katsaa woomanaw, Kanaane biittaappe yeeddo» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yooseefo bare ishatuwaa ereedda; shin unttunttu Aa eribeykkino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Hewaappe guyye, Yooseefo unttunttuwaa akumeteedda bare akumuwaa hassayiide unttuntta, «hinttenttu geeddi s'eelliyaa asaa; hinttenttu nu biittan naagu leppiyaa baggay hak'awentto be'anaw yeeddita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Unttunttu, «tuytti, nu godaw, nuuni geeddi s'eelliyaa asaa gidokko; nuuni ne k'oomatuu katsaa woomanaw yeeddo. ");
INSERT INTO dwrl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nuuni ubbaykka itti aawuwaa naanaa. Nuuni ne k'oomatuu ammanettiyaa asaa» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yooseefo unttuntta, «tuytti; hinttenttu nu biittan naagu leppiyaa baggay hak'awentto be'anaw yeeddita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Shin unttunttu, «Nuuni ne k'oomatuu tammanne laa\"u ishatuwaanne Kanaane biittan de'iyaa itti bitaniyaa naanaa. Wurssetsa d'antsaa duusuu ha\"i nu aabunna de'ee; ittuu d'ayeedda» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yooseefo unttuntta, «Taani hinttenttoo odeeddawaadankka hinttenttu biittaa geediyaawantta. ");
INSERT INTO dwrl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","K'ay hinttenttu paac'ettanawe hawaana; tumuwaappe kaatii hayk'k'o; hinttenttu wurssetsa teefa ishay hawaa yaana d'ayooppe, hinttenttu hawaappe biikkita. ");
INSERT INTO dwrl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Hinttenttu odiyaawe tuma gidiyaawaa paac'c'anaw, hintteppe ittuwaa kiittite; I hinttenttu ishaa akkiidde yo; atteedawanttu k'asho gollen gam\"iita. Hewaa gidana d'ayooppe, kaatii hayk'k'o; hinttenttu biittaa geediyaawantta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Unttuntta heezzu gallassaw k'asho gollen yeggeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Heezzentso gallassan Yooseefo unttuntta, «Taani S'oossaw yayyiyaa asaa; hinttenttu ittibaa ootsooppe, pas'a de'ana. ");
INSERT INTO dwrl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Hinttenttu tumukka ammanettiyaa asaa gidooppe, hinttenttu ishatuwaappe ittuu hawaan k'asho gollen de'o; atteedawanttu koshatiyaa hinttenttu soo asaw katsaa akkiidde afite; ");
INSERT INTO dwrl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","shin hinttenttu k'aalaa tumayana malanne hinttenttu hayk'k'enna mala hinttenttu hinttenttu wurssetsa teefa ishaa taakko ahana koshshee» yaageedda. Unttunttunne ha yewuwaa mayyeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Unttunttu ittuu ittuwaa, «Tumu nuuni nu ishaw ootseeddabay nuuna kaa'ee. I bare shemppo haniyaabay is's'ina, nuw watiwatiyaa wode, nuuni sisiide is's'eeddo; ha waayii nuuna gakkeeddawe hewaa diraassa» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Roobeeli, «Taani hinttentta, ‹Na'aa bolla nagaraa ootsoppite› gaade odabeykkitaa? Shin hinttenttu sisennan is's'eeddita. Simmi ha\"i, Aa suutsay nuuna achchee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Unttunttu giyaabaa Yooseefo ereeddawaa unttunttu akeekibeykkino; ayaw gooppe, I unttunttunna wokkaaliyaan haasayiyaa diraassa. ");
INSERT INTO dwrl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","I unttunttuppe wora simmiide yeekkeedda; shin k'ay unttunttukko simmiide, unttunttoo gujjiide haasayeedda. I Simoona unttunttuppe duutsi ashshiide unttunttu be'ishin k'achcheeda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yooseefo bare k'oomatuwaa, «Katsaa unttunttu ogoruwaa kuntsite; unttunttu biraakka zaariide, unttunttu ogoruwaan ogoruwaan wotsite; k'ay unttunttu ogiyaw shink'k'aa immite» yaagiide azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","I geeddawaadan ootseeddawaappe guyye, Yooseefo ishatuu katsaa barenttu haretuwaan c'aaniide, denddiide beeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Unttunttu k'ammaa ak'anaw simmeeddino unttunttuppe ittuu bare hariyaw katsaappe yegganaw bare ogoruwaa biliide, he ogoruwaa doonaan de'iyaa bare biraa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","I bare ishatuwaa, «Ta biray taw simmeedda; tumu hawaa be'ite! Ta ogoruwaan de'ee» yaageedda. Unttunttu wozanay dagaminna, kokkoriidde ittuu ittuwaakko simmiide, «S'oossay nu bolla ootseeddabay hawe ayee?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Unttunttu Kanaane biittan de'iyaa barenttu aawuwaa Yaak'oobakko yeedda wode, barena gakkeeddawaa ubbaa aw odeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Unttunttu aw, «He biittaw goda gideedda bitanii nuuna hank'k'eteedda. Hewaappe guyye, I nuuna he biittaa geeddiyaawaadan godatteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Shin nuuni Aa, ‹Nuuni ammanettiyaa asaa; biittaa geediyaawantta gidokko. ");
INSERT INTO dwrl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nuuni tammanne laa\"u ishatuu itti aawuwaa naanaa; ittuu d'ayeedda; wurssetsa teefay Kanaane biittan ha\"i nu aabunna de'ee› yaageeddo. ");
INSERT INTO dwrl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","He biittaw goda gideedda bitanii nuuna, ‹Hintte ammanettiyaa asaa gidiyaawaa taani hawaan erana; hinttenttu ishatuwaappe ittuwaa hawaan ta matan yeggiide, koshatiyaa hinttenttu soo asaw katsaa akkiidde biite. ");
INSERT INTO dwrl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Hinttenttu biittaa geediyaawantta gidenaan, ammanettiyaa asaa gidiyaawaa taani erana mala, hinttenttu wurssetsa teefa ishaa taakko akki yiite. Yaatooppe taani haan atteeda hinttenttu ishaa hinttenttoo zaaraadde immana; hinttenne ha biittan zal\"iita› geedda» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Unttunttu barenttu ogoruwaappe katsaa k'oliidde, barenttu ogoruwaan ogoruwaan barenttu biraa k'ashuwaana utteeddawaa demmeeddino. Unttunttunne unttunttu aawuu he k'ashuwaana de'iyaa biraa be'iide yayyeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Unttunttu aawuwaa Yaak'oobi unttuntta, «hinttenttu taana ta naanatuwaappe mela kesseeddita; Yooseefo baawa, Simooni baawa; k'ay hinttenttu Biiniyaama afana koyiita. Ubbabay taw tiraan sitti geedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Hewaappe guyye Roobeeli bare aawuwaa, «Taani Biiniyaama new zaaraadde ahana d'ayooppe, ta attuma naanaa laa\"uwaakka wod'a; taana ammanettaade Aa ta kushiyaan wotsa; k'ay taani Aa zaaraadde ahana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Shin Yaak'oobi unttuntta, «Ta na'ay hinttenana yaa duge beenna; Aa ishay hayk'k'ina, atteedawe Aa s'alala; hinttenttu afishshin, ogiyaan iitabay Aa gakkiyaawaa gidooppe, hinttenttu ta puuluntsaa huup'iyaa kayyuwaan duufuwaan yeggiita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ha\"inne koshay Kanaane biittan wolk'k'aameedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yaatina unttunttu Gibs'eppe aheedda katsaa ubbaa mi wurssi diggina, unttunttu aawuu, «K'aykka guyye biide nuw amareeda katsaa woomite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Shin Yihuday Aa, «He bitanii nuuna, ‹Hintte ishay hinttenana yaana d'ayooppe, ta deemuwaa zaari be'ikkita› yaagiide loytsi odeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Neeni nu ishaa nuunana yeddooppe, nuuni duge biide new katsaa shammana. ");
INSERT INTO dwrl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Shin neeni Aa yeddennawaa gidooppe, nuuni duge bookko; ayaw gooppe, he bitanii nuuna, ‹Hintte ishay hinttenana yaana d'ayooppe, hinttenttu ta deemuwaa zaari be'ikkita› geedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israa'eelii, «Hinttenttu, ‹Nuw hara ishay de'ee› giide odiide ha metuwaa ta bolla ayaw aheedditee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Unttunttu Aa, «He bitanii nubaanne nu soo asaabaa loytsi oochcheedda. I nuuna, ‹Hintte aawuu ha\"ikka pas'a de'ii? hinttenttoo hara ishay de'ii?› yaagiide oochcheedda. Nuuni I oochcheeddawaa aw zaareeddo. I nuuna, ‹Hintte ishaa duge haa ahite› gaanawaa nuuni ayan eranee?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yihuday bare aawuwaa israa'eeliyaa, «Nuunikka neenikka nu naanaykka pas'a de'ana malanne hayk'k'ennan attana mala, na'aa taananna yedda; nuuni ellekka baana. ");
INSERT INTO dwrl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Na'aa ta waasetetsaan imma; aban taana oochcha; taani Aa new saro zaaraadde ahana d'ayooppe, ta de'uwaa ubbaan ne shek'ay taana gakko! ");
INSERT INTO dwrl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nuuni gam\"ibeenawaa gidintto, hannoode laa'entsuwaa yaa gakkiide simmana shin» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Hewaappe guyye unttunttu aawuu Israa'eele unttuntta, «Hewaa gidooppe, yaatite; he bitaniyaw kushiyaa gentsiyaawaa ha biittan doleeddawaa ubbaappe lo\"iyaawaa doorite; hewenne balasaane giyaa d'aliyaa, eessaa, sawuwaa, karbbiyaanne tamire lawuziyaa giyaa mitsatuwaa teeraa hinttenttu ogoruwaan yeggiide akki biite. ");
INSERT INTO dwrl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Hinttenttu ogoruwaa doonaan simmeedda biray baletseeddawaa gidanaw danddayiyaa diraw, biraakka laa\"u kushe ootsiide akki biite. ");
INSERT INTO dwrl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","K'ay hinttenttu ishaanne akkiidde, he bitaniyaakko ellekka guyye biite. ");
INSERT INTO dwrl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","I hinkko hinttenttu ishaa yeddana mala, Biiniyaamenne hinttenana yaana mala, Ubbaa Danddayiyaa S'oossay he bitanii hinttenttoo k'arettanaadan ootso. Taana gidooppe, ta naanatuwaappe mela attooppenne ataad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hewaa diraw he asatuu imotaanne laa\"u kushe biraanne k'ay Biiniyaamanne akkeeddino. Unttunttu duge Gibs'e biide, Yooseefo sintsa shiik'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yooseefo Biiniyaama unttunttunna be'eedda wode, bare golle kaappuwaa, «He asaa ta soo akkaade ba; itti mehiyaa shukkaade giigissa; unttunttu seeta gallassan laas'aa taananna miino» yaagiide azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yaatina I Yooseefo aw odeeddawaadan he asaa Yooseefo soo afeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Asatuu Yooseefo soo beedda diraw, yayyeeddino; unttunttu, «Nuuni hawaa yeeddawe koyro ogoruwaanna simmiide beedda biraa diraassa; I nuuna wad'd'anaw, ayiletetsaan mooddanawunne nu haretuwaa akkanaw haneedda» yaagiide k'oppeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Hewaa diraw unttunttu Yooseefo golle penggiyaa gakkiide, golliyaa kaappuwaa haasayisseeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Ta godaw, nuuni koyro katsaa woomanaw hawaa yeeddo; ");
INSERT INTO dwrl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","simmiide nuuni k'ammaa ak'iyaa sa'aan ogoruwaa biliide, huup'iyaan huup'iyaan nu biray pac'c'ennan nu ogoruwaa doonaan de'iyaawaa demmeeddo; hewaa diraw ha\"i nuuni Aa guyye akkiidde yeeddo. ");
INSERT INTO dwrl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","K'ay nuuni katsaa woomanaw hara biraakka aheeddo. Nu biraa nu ogoruwaa ogoruwaa doonaan ooni wotseeddenttonne erokko» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","I unttuntta, «Hewe ayinne baawa; yayyoppite! hinttenttu S'oossay, hinttenttu aawuwaa S'oossay, hinttenttu ogoruwaa giddon hinttenttoo biraa immeedda; taani hinttenttu biraa akkaad» yaageedda. Hewaappe guyye, I Simoona unttunttukko keseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","He bitanii he asaa Yooseefo soo afiide, unttunttu gediyaw haatsaa ayina, barenttu gediyaa meec'etteeddino. Unttunttu haretoo hark'k'uwaa yeggeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Yooseefo seeta gallassi yiina immanaw, unttunttu barenttu immotaa aw giigisseeddino; ayaw gooppe, unttunttu yan maanawaa sisi utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yooseefo bare soo geleedda wode, unttunttu soo aheedda barenttu immiyaawaa son aw immeeddino; unttunttu Aa sintsan sa'aa gakkiide goynneeddinno. ");
INSERT INTO dwrl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","I unttunttu sarotetsaa oochchi simmiide, «Hinttenttu taw odeedda hinttenttu aawuu c'imay lo\"ee? Ha\"ikka I pas'a de'ii?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Unttunttu, «Ee, ne k'oomay, nu aawuu ha\"ikka pas'a de'ee; I lo\"a» yaagiide hokkiide aw goynneeddinno. ");
INSERT INTO dwrl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","I bare aati na'aa Biiniyaama be'eedda wode unttuntta, «hinttenttu odeedda wurssetsa teefa hinttenttu ishay hawe?» yaageedda. K'ay I Biiniyaama, «Ta na'aw, neena S'oossay anjjo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yooseefo Aa ishay aw gomppay mishetteedda diraw, yeekkanaw itti sa'aa lawuhu geedda. I bare dumma k'ol\"uwaa geliide yan yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","I bare deemuwaa meec'ettowaappe guyye kesiide, barena mintsetsiide, «K'umaa aatsite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Unttunttu aw dumma, he ishatoo dumma, hewaan aanana miyaa Gibs'e asatoo dumma aatseeddino; ayaw gooppe, Gibs'e asatuu Ibraawe asatuwaana ittippe miikkino. Hewe Gibs'e biittaa asaa sheneyiyaawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Unttunttu Yooseefo sintsan bayiray bare bayiratetsaadan, teefay bare teefatetsaadan maaran utteeddino. Unttunttu ittuu ittuwaa s'eelliide, unttuntta wooti utisseeddinontto be'iide maalaleteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yooseefo maaddaappe unttunttoo k'umaa gishiyaa wode, Biiniyaamew gakkeeddawe haratuwaappe ichcheshu kushiyaa daree; yaatina unttunttu nashettiidde aanana meeddinonne usheeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yooseefo bare golle kaappuwaa, «Neeni ha asatuwaa ogoruu akiyaawaa keeshshaa katsaa unttunttoo kuntsaa; unttunttu ubbaa biraakka unttunttu ogoruwaa ogoruwaa doonaan wotsa; ");
INSERT INTO dwrl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","yaataade wurssetsa teefaa ogoruwaa doonaan ta biraa wanc'c'aanne Aa katsaa biraa wotsa» yaagiide azazeedda; I Yooseefo geeddawaadan ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sa'ay wonttina he asatuu barenttu haretuwaa akkiidde baanaw moyzzeteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Unttunttu he katamaappe kesiide haakki beennan de'ishshin, Yooseefo bare golle kaappuwaa, «Dendda! Ha asatuwaa geeduwaa kaala; neeni unttuntta gakkeedda wode unttunttu, ‹Hintte ayaw keekaa iitan zaareedditee? ");
INSERT INTO dwrl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Hawe ta goday ushiyaanne k'ay s'uurabaa demmiyaa wanc'c'aa gidennee? Hawe hinttenttu ootseeddabay balabaa› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","I unttunttu geeduwaa gakkiide, ha geeddawaadankka unttunttoo odeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Shin unttunttu, «Ta goday hawaa mala k'aalaa ayaw haasayii? Hewaa malaa ootsiyaawe nuuppe ne k'oomatuwaappe haakko! ");
INSERT INTO dwrl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nuuni haray atto nu ogoruwaa doonaappe demmeedda biraa Kanaane biittaappe guyye new zaari aheeddo. ");
INSERT INTO dwrl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ne godaa golliyaappe nuuni work'k'aa woy biraa wooti wuu'eetoo? Ne k'oomatuwaa giddon he wanc'c'ay beetteedda uray hayk'k'o; k'ay atteeda nuuni nu godaw ayile gidana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","I unttuntta, «Hewaa gidooppe lo\"a; hinttenttu geeddawaadan wanc'c'aa akkeedda ooninne ta ayile gidana; hinkko atteeda hinttenttu boriyaappe saro attana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Hewaappe guyye, unttunttu ellekka barenttu ogoruwaa ogoruwaa sa'aan wotsiide billeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","He kaappuu ubbaappe bayiratiyaawaa ogoruwaappe doommiide wurssetsa teefa gakkanaw koyeedda; he wanc'c'aa Biiniyaama ogoruwaa giddoppe demmeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Hewaan unttunttu kayyotiide, barenttu mayuwaa peed'eeddino; barenttu ogoruwaa barenttu haretuwaan c'aaniide, guyye katamaa simmeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yihuday bare ishatuwaanna Yooseefokko geliyaa wode, Yooseefo son de'ee; unttunttu Aa sintsan sa'aan guufanneeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yooseefo unttuntta, «hinttenttu ayaa iitabaa ootseeddite? Ta mala Asay s'uurabaa demmiyaawaa erikkiteeyye?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yihuday, «Ta godaw nuuni ayaa gaanee? Nuuni ayaa haasayanee? Woy nuuni s'illuwaa gidiyaawaa wooti bessanee? S'oossay ne ayiletuwaa bayzzuwaa k'onc'c'issi diggeedda. Simmi nuunikka he wanc'c'ay aappe beetteeddawekka ta godaw ayile gideedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Shin Yooseefo, «Hawaa malaa ootsiyaawe taappe haakko; ta wanc'c'ay aappe beetteedda bitaniyaa s'alalay ta ayile gidana. Hinkko hinttenttu hinttenttu aawuwaakko guyye saro simmite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yihuday aakko shiik'iide Aa, «Ta godaw, taani itti k'aalaa haasayana mala neena woossay; taana ne ayiliyaa hank'k'ettoppa; ayaw gooppe, neeni kaatiyaa mala. ");
INSERT INTO dwrl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Neeni ta goday nuuna ne ayiletuwaa, ‹Hinttenttoo aawuu de'iiyye woy ishay de'ii?› yaagaadde oochchaadda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nuunikka, ‹Nuw c'imeedda aawuu de'ee; I c'imi kichchiide yeleedda teefa na'aykka de'ee; he na'aa ishay hayk'k'eedda; bare aatiw itti Aa s'alalay atteedda; Aa aawuu Aa siik'ee› yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","«Neeni ne ayiletuwaa, ‹Taani Aa be'ana mala taw ahite› yaagaadda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nuuni ta godaa, ‹He na'ay bare aawuwaappe shaakettanaw danddayenna; shaakettooppe Aa aawuu hayk'k'anita› yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Shin neeni ne ayiletuwaa, ‹Hintte teefa ishay hinttenana duge yaana d'ayooppe, laa\"entsuwaa ta deemuwaa be'ikkita› yaagaadda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nuuni ne ayilatuu nu aawuwaakko simmiide beedda wode, ta goday geeddawaa aw odeeddo. ");
INSERT INTO dwrl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«Nu aawuu, ‹Guye biide amareeda katsaa woomite› yaagina, ");
INSERT INTO dwrl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","nuuni Aa, ‹Nu teefa ishay nuunana booppe attin, duge baanaw danddayokko; ayaw gooppe, nu ishay teefay nuunana beennawaa gidooppe, nuuni he bitaniyaa deemuwaa be'anaw danddayokko› yaageeddo. ");
INSERT INTO dwrl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","«Nu aawuu ne ayili nuuna, ‹Ta machata Raaheela taw laa\"u attuma naanaa yeleeddawaa hinttenttu eriita; ");
INSERT INTO dwrl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","unttunttuppe ittuu taappe shaakettiide biina, «Tumu Aa do'ay puuzereetsi meedda» yaagaad; hachche gakkanaw taani Aa be'abeykke. ");
INSERT INTO dwrl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Hawaa k'ay hinttenttu taappe shaakki afina, iitabay Aa gakkooppe, hinttenttu ta puuluntsaa huup'iyaa kayyuwaan duufuwaan yeggana› yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","«Hewaa diraw, ha\"i taani guyye ne ayiliyaa ta aawuwaakko biyaa wode, ta aawuu, na'aa bare shemppuwaadan siik'iyaawe, na'ay nuunana baynnaawaa be'ooppe hayk'k'i aggana. Nuuni ne ayiletuu nu aawuwaa puuluntsaa huup'iyaa kayyuwaan duufuwaan yeggeetto. ");
INSERT INTO dwrl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Taani ne ayili na'aa ta waasetetsaan akkaad; taani Aa, ‹Ta aawoo, taani Aa new saro zaaraadde ahana d'ayooppe, ta de'uwaa ubbaan ne shek'ay taana gakko!› yaaga wotsaad. ");
INSERT INTO dwrl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«Yaateedda diraw, taani ne ayili ta godaw na'aa diraw ayiletaade, hawaan attina, na'ay bare ishatuwaanna guyye simmo. ");
INSERT INTO dwrl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Na'ay baynnan taani waanaade guyye ta aawuwaakko simmanee? tuytti, taana ta aawuu seelettana seelaa bessoppa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","He wode Yooseefo he asaa ubbaa sintsaan genc'c'ana danddayibeenna; «Asaa ubbaa ta sintsaappe kessite» yaagiide waasseedda. Hewaa diraw Yooseefo barena bare ishatoo erisseedda wode, aanana ooninne baawa. ");
INSERT INTO dwrl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","I bare k'aalaa d'ok'k'isiide, Gibs'etuu Aa sisana gakkanaw loytsi yeekkeedda. Kaatiyaa soo Asay he woriyaa siseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yooseefo bare ishatoo, «Taani Yooseefattee! Ta aawuu hanno gakkanaw pas'a de'iiyye?» yaagiide oochcheedda. Shin Aa ishatuu loytsi dagammeedda diraw, aw zaarana danddayibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yaatina Yooseefo bare ishatuwaa, «Taakko haa shiik'ite» yaageedda. Unttunttu aakko shiik'eeddino; I unttuntta, «Taani hinttenttu ishaa Yooseefa; hinttenttu Gibs'e biittaw zal\"eeddawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","K'ay hinttenttu taana hawoo zal\"eedda diraw, k'um\"ettopitenne kayyotoppite; ayaw gooppe, S'oossay taana hintteppe sintsaw kiitteeddawe asaa shemppuwaa ashshanaassa. ");
INSERT INTO dwrl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ha biittaa koshay geloodeppe laa\"entso laytsaa; k'ay yiyaa ichcheshu laytsatuwaan Asay goshenna woy c'akkenna. ");
INSERT INTO dwrl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Shin taani sa'aan hinttenttoo zeretsaa ashshana malanne hinttenttu de'uwaa darissa ashshana mala, S'oossay taana hintteppe sintsaw kiitteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Simmi taana ha sa'aa kiitteeddawe S'oossaa gidiyaawaappe attina, hinttentta gidikkita. I taana Gibs'e kaatiyaw aawuwaa, aw de'iyaawaa ubbaw godanne Gibs'e biittaa mooddiyaawaa ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«Ha\"i elleelli guyye ta aawuwaakko biide Aa, ‹Ne na'ay Yooseefo hawaadan yaagee; «S'oossay taana Gibs'e biittaa ubbaa bollan goda keseedda; neeni taakko duge haaya; gam\"oppa. ");
INSERT INTO dwrl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Neeni Geseeme biittan uttaasa; k'ay neeni, ne naanay, ne naanaa naanay, ne dorssaa wudii, ne miizzaa wudiinne new de'iyaabay ubbay ta matan de'iita. ");
INSERT INTO dwrl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Biro ichcheshu koshaa laytsatuu atteeddino; neena, ne soo asaanne ne mehiyaa koshay oyk'k'enna mala, taani neena mizana» yaageedda› yaagite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","K'aykka Yooseefo unttuntta, «Hinttekka ta ishaa Biiniyaamekka, ha hinttenanna haasayiyaawe tumu taana Yooseefa gidiyaawaa hinttenttu ayfiyaan be'iita. ");
INSERT INTO dwrl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Taw Gibs'e biittan de'iyaa bonchchuwaa ubbaanne hinttenttu be'eeddawaa ubbaa ta aawoo odite; ta aawuwaanne ellekka haa duge akki yiite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Bare ishaa Biiniyaama k'ood'iyaa k'oommi yeekkeedda; Biiniyaamekka bare ishaa k'oommi yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yooseefo bare ishatuwaa ubbaa yeriide, unttunttu bollankka yeekkeedda. Hewaappe guyye, Aa ishatuu aanana haasayeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yooseefo ishatuu yeedda worii kaatiyaa golle gakkeedda wode, kaatiinne Aa oosanchchatuu nashetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kaatii Yooseefo, «Neeni ne ishatuwaa yaatite ga; ‹Hintte mehiyaa c'aaniide, Kanaane gadiyaa simmite; ");
INSERT INTO dwrl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","hinttenttu aawuwaanne hinttenttu soo asaa akkiidde, guyye taakko haa ahite. Taani hinttenttoo Gibs'e biittan ubbaa sa'aappe lo\"iyaa sa'aa immina, hinttenttu ha biittaa mod'd'uwaa kaashana› yaaga. ");
INSERT INTO dwrl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","K'aykka neeni ne ishatuwaa, ‹Paraa gaariyaa hinttenttu naanatuwaanne hinttenttu mac'c'a asatuwaa ahiyaawantta Gibs'eppe akkiide biite; hinttenttu aawuwaanne akkiidde yiite. ");
INSERT INTO dwrl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Gibs'e biittan de'iyaa ubbaappe aad'd'i lo\"iyaawe hinttessa gidiyaa diraw, hinttenttu mas'uwaa k'oppoppite› yaagaade oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Israa'eeliyaa attuma naanay geeddawaadan ootseeddino. Yooseefo kaatii azazeeddawaadan paraa gaaretuwaanne ogiyaw shink'k'aa unttunttoo immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Unttunttoo ubbawukka huup'iyaan huup'iyaan ooratsa mayuwaa immeedda; shin Biiniyaamew heezzu s'eetu s'agaraa biraanne ichcheshu kumentsaa mayuwaa immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","I bare aawoo yeddeeddawe hawaa; Gibs'en de'iyaa ubbabaappe lo\"iyaawaa tammu hariyaan c'aaniide, k'ay ogiyaw katsaa, ukitsaanne hara shink'k'aa tammu mac'c'a haretuwaan c'aaniide yedeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yooseefo bare ishatuwaa moyzzeedda. Unttunttu biishshin I unttuntta, «Ogiyaan biidde walak'ettoppite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Unttunttu Gibs'eppe kesiide beeddino; Kanaane biittaa biide, barenttu aawuwaa Yaak'oobakko gakkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Unttunttu aw hawaadan yaagiide odeeddino; «Yooseefo pas'a de'ee! I hewaappenne Gibs'e biittaa ubbaa mooddiyaawaa» yaageeddino; Yaak'ooba dagamay wozanaa bayzzeedda diraw, unttuntta ammanibeenna. ");
INSERT INTO dwrl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Shin unttunttu Yooseefo barenttoo odeeddawaa ubbaa aw odinanne Aa akki ahana mala Yooseefo kiitteedda paraa gaaretuwaa I be'ina, unttunttu aawuwaa Yaak'ooba shemppu simmeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israa'eelii, «Hewe taw gidee; ta na'aa Yooseefo hanno gakkanaw pas'a de'ee! Taani hayk'k'anaappe kase baade, Aa be'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israa'eelii barew de'iyaawaa ubbaa akki denddiide, Berssaabeha gakkeedda; I bare aawuwaa Yisaak'a S'oossaw yarshshuwaa yarshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","S'oossay k'amma akumuwaan Aa, «Yaak'ooba, Yaak'ooba» yaageedda. I, «abee» giide koyeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Aa, «Taani S'oossaa, ne aawuwaa S'oossaa; neeni duge Gibs'e baanaw yayyoppa; ayaw gooppe, taani neena yan wolk'k'aama kawutetsaa kesana. ");
INSERT INTO dwrl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Taani neenana ittippe Gibs'e baana; k'ay taani ne zeretsaa yaappe kesana. Yooseefo bare kushiyaan ne ayfiyaa shiishshana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hewaappe guyye, Yaak'oobi Berssaabeheppe denddeedda; Israa'eeliyaa attuma naanay barenttu aawuwaa Yaak'ooba, barenttu naanaanne barenttu machatuwaa Gibs'e kaatii unttunttoo kiitteedda paraa gaariyaan wotsiide afeedino. ");
INSERT INTO dwrl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Unttunttu Kanaane biittan mooddeedda mas'uwaanne mehiyaa ubbaa afeedino. Yaak'oobinne Aa zeretsaa ubbay aanana Gibs'e beeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","I bare attuma naanaanne bare naanaa attuma naanaa, bare mac'c'a naanaanne bare naanaa mac'c'a naanaa, hewenne bare zeretsaa ubbaa barenana Gibs'e afeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israa'eelana Gibs'e gadiyaa beedda israa'eeliyaa naanaa suntsay hawaappe kaalliide s'aafetteeddawaa. Yaak'ooba bayira na'ay Roobeela; ");
INSERT INTO dwrl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Roobeela attuma naanay Hanooka, Paalu, Hes'iroonanne Karmma. ");
INSERT INTO dwrl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simoona attuma naanay Yimu'eela, Yaamiina, Ohaada, Yaakiina, S'ohaaranne Kanaane mishiratti na'aa Shaa'uula. ");
INSERT INTO dwrl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leewii attuma naanay Gershshoona, K'ahaatanne Maraara. ");
INSERT INTO dwrl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yihudaa attuma naanay Eera, Oonaana, Sheela, Paareesanne Zaraaha; shin Eerinne Oonaani Kanaane biittan hayk'k'eeddino. Paareesa attuma naanay Hes'iroonanne Hamuula. ");
INSERT INTO dwrl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yisaakoora attuma naanay Tolaa'a, Puuwa, Yaashuubanne Shimiroona. ");
INSERT INTO dwrl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zaabiloona attuma naanay Sereeda, Eloonanne Yaahila'eela. ");
INSERT INTO dwrl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hawanttu Liya Masp'p'es'oomiyaan Yaak'oobaw yeleedda attuma naanaa; I mac'c'a naatta Diino. Hawanttu Aa naanaynne naanaa naanay mulii hattamanne heezza. ");
INSERT INTO dwrl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaade attuma naanay S'afoona, Hagga, Shuuna, Es'iboona, Eri, Aroodanne Ari\"eela. ");
INSERT INTO dwrl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aaseera attuma naanay Yimina, Yishiwa, Yishiwaahanne Barii'a; unttunttu michchata Seraaho. Barii'a attuma naanay Hebeeranne Malkki'eela. ");
INSERT INTO dwrl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Laabaani bare naatti Liyo immeedda Zilppa Yaak'oobaw yeleedda naanay hawantta; unttunttu mulii tammanne usuppuna. ");
INSERT INTO dwrl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaak'ooba machchatti Raaheeli attuma naanay Yooseefonne Biiniyaama. ");
INSERT INTO dwrl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Oona katamaa k'eesiyaa P'oos'ifaara naatta Asinaata Yooseefow Gibs'en Minaasanne Efireema yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Biiniyaama naanay Belaa'a, Bekeera, Ashibeela, Geera, Naa'imaana, Eeha, Roosha, Muppiima, Huppiimanne Arada. ");
INSERT INTO dwrl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yaak'oobaw yeletteedda Raaheeli attuma naanay hawantta; unttunttu mulii tammanne oydda. ");
INSERT INTO dwrl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Diinaa attuma na'ay Hushiima. ");
INSERT INTO dwrl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nifttaaleema attuma naanay Yaahis'i'eela, Guna, Yes'eeranne Shiileema. ");
INSERT INTO dwrl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Laabaani bare naatti Raaheeliw immeedda Baala Yaak'oobaw yeleedda naanay hawantta; unttunttu mulii laappuna. ");
INSERT INTO dwrl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yaak'oobanna Gibs'e beedda, Aa gulbbataappe yeletteeddawanttu, Aa naanaa machatuwaa gujjennan, mulii usuppun tammanne usuppuna. ");
INSERT INTO dwrl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Gibs'en Yooseefow yeletteedda laa\"u naanaa gujjina, Gibs'e beedda Yaak'ooba soo Asay mulii laappun tamma. ");
INSERT INTO dwrl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Geseeme biittan mokkana mala, Yaak'oobi Yihudaa bareppe sintsaw Yooseefokko kiitteedda; unttunttu Geseeme gakkeedda wode, ");
INSERT INTO dwrl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yooseefo bare paraa gaariyaa giigissiide, bare aawuwaa Israa'eelana gaketanaw Geseeme beedda. Yooseefo bare aawuwaa demmeedda saannakka Aa k'ood'iyaan s'aas'etti k'oommi, daro wodiyaa yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israa'eelii Yooseefo, «Neeni pas'a de'ishshin, taani ne ayfiyaa be'eedda diraw, ha\"i taani hayk'k'inttonne ayinne baawa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hewaappe guyye, Yooseefo bare ishatuwaanne bare aawuwaa soo asaa, «Taani Gibs'e kaatiyaakko baana; aw, ‹Kanaane biittan de'iyaa ta ishatuwaanne ta aawuwaa soo Asay taakko yeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Unttunttu dorssaa hentsanchchaa; unttunttu mehiyaa heemmino; unttunttu barenana barenttu dorssatuwaa, barenttu miyatuwaanne barenttoo de'iyaawaa ubbaa akkiidde yeeddino› yaagana. ");
INSERT INTO dwrl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kaatii hinttentta s'eesissiide, ‹Hintte kiittay ayee?› yaagiide oochchooppe, ");
INSERT INTO dwrl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","hinttenttu aw, ‹Nuuni ne k'oomatuu na'atetsaappe doommiide, nu aawotuwaadan mehiyaa heemmeetto› yaagite. I hinttentta Geseeme gadiyaan wotsanawaa; ayaw gooppe, dorssaa hentsanchchaa ubbay Gibs'e asan kad'eteeddawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yooseefo geliide Gibs'e kaatiyaw hawaadan yaagiide odeedda; «Ta aawunne ta ishatuu, barenttu dorssaa wudiyaanna, barenttu miyaa wudiyaannanne barenttoo de'iyaawaa ubbaanna Kanaane biittaappe yiide, ha\"i Geseeme biittan de'ino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","I bare ishatuwaappe ichcheshatuwaa dooriide kaatiyaa sintsa aatseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kaatii he ishatuwaa, «hinttenttu kiittay ayee?» yaagiide oochcheedda. Unttunttu kaatiyaw, «Nuuni ne k'oomatuu nu aawotuwaadankka dorssaa wudiyaa heemmeetto» yaagiide zaareeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","K'ay unttunttu aw, «Kanaane biittan koshay s'iis's'i de'iyaa dirawunne ne k'oomatuwaa mehiyaw miyaabay ayinne baynna diraw, nuuni hawaan amareeda wodiyaa de'anaw yeeddo; hayyanaa nuuna ne k'oomatuwaa Geseemen wotsaarikkii!» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kaatii Yooseefo, «Ne aawunne ne ishatuu neekko yeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Simmi Gibs'e biittay ne kushiyaan de'ee; ha gadiyaan ubbaa saappe aad'd'iide lo\"iyaasan ne aawuwaanne ne ishatuwaa wotsa; unttunttu Geseeme biittan de'iino. Neeni erina, unttunttu giddoppe dumma eratetsay de'iyaawanttu de'ooppe, hewantta ta mehiyaa bolla suntsaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hewaappe guyye, Yooseefo bare aawuwaa Yaak'ooba gelissiide, kaatiyaa sintsa aatseedda. Yaak'oobi Gibs'e kaatiyaa anjjeedawaappe guyye, ");
INSERT INTO dwrl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","kaatii Yaak'ooba, «New woyssa laytsee?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaak'oobi kaatiyaa, «Taani yuuyyaadde de'eedda laytsay s'eetanne hattama; ta laytsay beni ta aawotuu yuuyyiidde de'eedda laytsatuwaappe guutsanne metuu dareeddawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hewaappe guyye, Yaak'oobi kaatiyaa anjjiide, Aa sintsaappe kare kesseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yooseefo bare aawuwaanne bare ishatuwaa Gibs'e biittan wotseedda; kaatii azazeeddawaadan Gibs'e biittan Raamisa giyaa katamaa matan de'iyaa, ubba saappe aad'd'iide lo\"iyaa gadiyaa unttunttoo immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yooseefo k'ay bare aawoo, bare ishatoonne bare aawuwaa soo asaa ubbaw unttunttu naanaa payduwaadan katsaa immeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Gidooppenne koshay s'iis's'i de'iyaa diraw, he biittaa ubbaan katsi baawa. He koshan Gibs'enne Kanaane biittay laa\"attuukka k'ohetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yooseefo Gibs'e katsaa zal\"iidde, Gibs'enne Kanaane biittatuwaan de'iyaa miishshaa ubbaa shiishsheedda; Gibs'e kaatiyaa golle gelisseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Gibs'enne Kanaane shaluu wureedda wode, Gibs'e Asay ubbay Yooseefokko yiide Aa, «Nuw katsaa imma; nu shaluu wureedda diraw, nuuni ne sintsan ayaw hayk'k'eettoo?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yooseefo unttuntta, «Yaatooppe hinttenttu mehiyaa akki yiite; hinttenttu shaluu wuri kichcheeddawaa gidooppe, taani katsaa hinttenttu mehiyaanna laammana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Hewaa diraw unttunttu barenttu mehiyaa Yooseefow aheeddino. Yooseefo unttunttu paraa, dorssaa, deeshshaa, miyaanne hariyaa katsanna laammeedda; I he laytsaa unttunttu mehiyaa ubbaanna katsaa laammiidde unttuntta mizi shaachcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","He laytsay wurina, unttunttu laa\"entsa laytsan aakko yiide Aa, «Nuuni nu godaappe k'osiyaabay baawa; nu miishshaa ubbay wuri diggina, nu mehiyaakka new sheed'd'iide, nu bollaappenne nu gadiyaappe attin, nu godaw atteedabay harabay baawa. ");
INSERT INTO dwrl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nuuni ne sintsan ayaw hayk'k'eettoo? Nu gadiikka ayaw d'ayii? Nuunakka nu gadiyaakka katsaan shamma; nuuni kaatiyaw ayiletana; nu gadiikka aawaa gido; nuuni pas'a attana mala, hayk'k'enna malanne nu gadiikka os's'enna mala, zeretsaa nuw imma» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yooseefo Gibs'e biittaa ubbaa kaatiyaw shammeedda. Gibs'etuu ubbay koshay s'iis's'i de'iyaa diraw, barenttu gadiyaa zal\"eeddino; gadii kaatiyaawaa gideedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yooseefo asaa ubbaa Gibs'ew ha gas'aappe doommiide hini gas'aa gakkanaw kaatiyaw ayile kesseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Gidooppenne I k'eesetuwaa gadiyaa shammibeenna; ayaw gooppe, kaatii k'eesatoo katsaa immeedda. Hewaa diraw barenttu gadiyaa zal\"ibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yooseefo asaa, «Simmi hachche taani hinttenanne hinttenttu gadiyaa kaatiyaw shammaad. Zeretsaa afiide, gaden zerite. ");
INSERT INTO dwrl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Shin katsaa c'akki gelissiyaa wode, ayfeeddawaappe ichcheshu kushiyaappe itti kushiyaa kaatiyaw immite. Ichcheshu kushiyaappe atteeda oyddu kushii hinttenttu gadiyaa zeretsaanne hinttenttoo, hinttenttu soo asawunne hinttenttu naanaw k'uma gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Unttunttu, «Neeni nuuna ashshaada! Nu godaa sintsan nuuni sabaa demeerokoshsha; nuuni kaatiyaw ayiletana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Hewaa diraw, Yooseefo Gibs'en biittappe ayfeeddawaappe ichcheshu kushiyaappe ittuwaa kaatiyaw immiyaawaa higgiyaa kesseedda. He higgii hachche gakkanaw ek'k'iide de'ee. Kaatiyaawaa gidibeenna gadii k'eesetuwaa gadiyaa s'alala. ");
INSERT INTO dwrl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israa'eeletuu Gibs'e biittan Geseeme giyaa saan utteeddino; unttunttu yan mas'uwaa demmeeddino; unttunttu yeletteeddinonne daro c'oratteeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaak'oobi Gibs'e biittaan tammanne laappun laytsaa de'eedda. Yaak'oobi de'eedda laytsay s'eetanne oytamanne laappuna. ");
INSERT INTO dwrl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israa'eele hayk'k'iyaa wodii matattina, bare na'aa Yooseefa s'eesissiide hawaadan yaageedda; «Taani ne sintsan sabetteeddawaa gidooppe, ne kushiyaa ta gulbbatan wotsaade, ane geppa. ");
INSERT INTO dwrl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Shin taani ta mayzzan gaketiyaa wode, taana Gibs'eppe afaade, unttunttu moogetteedda sa'aan mooga» yaageedda. Yooseefo, «Taani neena neeni geeddawaadan ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yaak'oobi Aa, «Ane taw c'aak'k'a» yaageedda. Yooseefo aw c'aak'k'eedda; hewaappe guyye, Israa'eelii bare hiis'an guufanniide, S'oossaw goynneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hewaappe guyye Asay Yooseefo, «Ne aawuu saketteedda» yaagiide odeedda. I bare laa\"u attuma naanaa Minaasanne Efireema akkiidde beedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Aasi Yaak'ooba, «Be'a; ne na'ay Yooseefo neekko yeedda» yaageedda; Israa'eelii minettiide bare hiis'an utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaak'oobi Yooseefo, «Ubbaa Danddayiyaa S'oossay Kanaane biittaan Looza giyaa sa'aan taw k'onc'c'iide, yan taana anjjeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","I taana, ‹Taani neena yelettissananne c'orissana; taani neena daro dere ootsana. Ha biittaa taani neeppe guyye, ne zeretsaw med'ina laata ootsaadde immana› yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«Simmi ha\"i, ne laa\"u attuma naanay, taani neekko hawaa yaanaappe kase Gibs'en new yeletteeddawanttu tawantta; Efireeminne Minaase taw Roobeelanne Simoona mala. ");
INSERT INTO dwrl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Unttunttuppe guyye new yeletteeddawanttu newantta; unttunttu laattana biittay Efireemanne Minaasa suntsan gido. ");
INSERT INTO dwrl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Taani Masp'p'es'oomiyaappe simmishin, Efiraataa gakkanaw laafa ashshiyaa wode, Raaheela Kanaane biittaan hayk'k'aaddu. Taani izo Beeteleeme giyaa Efiraataa afiyaa ogiyaa doonaan moogaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israa'eelii Yooseefo attuma naanaa laa\"atuwaa be'eedda wode, «hawanttu oonee?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yooseefo bare aawuwaa, «hawanttu S'oossay taw hawaan immeedda ta naanaa» yaageedda. Israa'eelii, «Taani unttuntta anjjana mala, unttuntta taakko haa shiishsha» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israa'eelii c'imina Aa ayfii labbaneedda diraw, s'eellanaw danddayenna. Hewaa diraw Yooseefo bare attuma naanaa aakko shiishshina, Aa aawuu unttuntta idimmiide yereedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israa'eele Yooseefa, «Taani ne deemuwaa be'ana gaade k'oppabeykke; shin S'oossay hekko ne naanaakka taana besseedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yooseefo unttuntta Aa gulbbataappe dentsiide, bare deemuwaa sa'aa gatsiide goynneedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yooseefo bare laa\"u attuma naanaa, Efireema bare ushechcha baggan Israa'eeliyaw haddirssa baggana, Minaasa bare haddirssa baggan Israa'eeliyaw ushechcha baggana akkiide, aakko shiishsheedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Efireeme teefa gidooppenne, Israa'eelii bare ushechcha kushiyaa yeddiide Aa huup'iyaan wotseedda; k'ay Minaase bayira gidooppenne, Israa'eelii bare kushiyaa yediidde, bare haddirssa kushiyaa Minaase huup'iyaan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hewaappe guyye, Yaak'oobi Yooseefa hawaadan yaagiide anjjeedda; «Ta aawotuu Abrahaamenne Yisaak'i Aa sintsan hemetteedda S'oossay, Ta de'uwaa ubbaan hachche gakkanaw taana heemmeedda S'oossay, ");
INSERT INTO dwrl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Iitabaa ubbaappe taana ashsheeda kiitanchchay, ha naanaa anjjo. Ta suntsaynne ta aawotuwaa Abrahaamanne Yisaak'a suntsay unttunttun s'eesetto. Unttunttu sa'aa bollan c'orattino» yaagiide anjjeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yooseefo bare aawuu bare ushechcha kushiyaa Efireema huup'iyaan wotseeddawaa be'eedda wode dosibeenna. Hewaa diraw, Efireema huup'iyaappe dentsiide, Minaase huup'iyaan wotsanaw bare aawuwaa kushiyaa oyk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yooseefo bare aawuwaa, «Ta aawoo, hewaa gidenna; bayiray hawaatte; ne ushechcha kushiyaa hawaa bolla wotsa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Shin Aa aawuu is's'iide Aa, «Taani eray; ta na'aw, taani eray; ikka wolk'k'aama dere gidana. Gidooppenne Aa teefa ishay aappe aad'd'i gitatana; Aa zeretsaykka darii wolk'k'aama kawutetsaa gidana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","I he gallassi unttuntta anjjiide, «Israa'eelatuu anjjiyaa wode, ‹S'oossay hinttentta Efireemedaaninne Minaasedan ootso› Yaagiide hinttenttu suntsan anjjana» yaageedda. Efireema Minaaseppe sintsayeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hewaappe guyye Israa'eelii Yooseefo, «Taani hayana hanay; shin S'oossay hinttenana gidana; k'ay I hinttenttu aawotuwaa gadiyaa hinttentta guyye zaarana. ");
INSERT INTO dwrl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","K'ay neena ne ishatuwaanna gakkiyaa biittaappe itti saamaa darissaade new immay; hewenne taani Amooratuwaappe ta mashshaaninne ta wonddaafiyaan akkeedda biittaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Hewaappe guyye, Yaak'oobi bare attuma naanaa s'eesissiide hawaadan yaageedda; «Sintsappe hinttenttoo hananabaa taani hinttenttoo odana mala shiik'ite.» ");
INSERT INTO dwrl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«Hinttenttoo Yaak'ooba naanaatoo, ittippe shiik'iide sisite; hinttenttu aawuu Israa'eelii hinttenttoo odiyaawaa hayzitte. ");
INSERT INTO dwrl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«Roobeelaa, ta bayira na'aw, neeni ta wolk'k'aa; ta minotetsaw koyruwaa. Neeni bonchchuwaankka wolk'k'ankka ubbaappe aad'd'iyaawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Neeni di'uwaa mala; ek'k'osa'an de'akka; neeni ubbaappe aad'd'iyaawaa gidakka. Ayaw gooppe, neeni ne aawuwaa gisuwaa kesaadda; ne aawuwaa gisuwaa tunissaadda. ");
INSERT INTO dwrl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Simooninne Leewii ishatuwaa; unttunttu mashshay makkalatetsaw olaa miishshaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Taani unttunttu zoretan gelikke; taani unttunttu shiik'uwaankka uttikke; ayaw gooppe, unttunttu barenttu hank'k'uwaan asaa wod'eeddino barena akka akka giina, booratuwaa k'ans's'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Unttunttu suulo hank'k'uu unttunttu mek'etsaa iitatetsaynne shek'etteeddawaa gido! Taani unttuntta Yaak'ooba asaa gidduwaan laalana; Israa'eeliyaa biittaan tiskki ootsana. ");
INSERT INTO dwrl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«Yihudaw, ne ishatuu neena galatana. Ne kushii ne morkkatuwaa pillanttiyaa oyk'k'ana. Ne aawuwaa naanay new hokkiide goynnana. ");
INSERT INTO dwrl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yihudaw, neeni wodalla gaammo. Ta na'aw, neeni shankkaappe wod'i simmiide, c'ogottiide giseedda gaammuwaa mala. Neeni asaa bosheretsanaw koyenna mac'c'a gaammatti mala. ");
INSERT INTO dwrl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ayissiyaawe yaana gakkanaw, Kawutetsaa s'am\"ay Yihudaappe, deriyaa ayissiyaawanttu gatimay Aa gediyaa giddoppe shaakettenna. K'ay deriyaa Asay aw azazettana. ");
INSERT INTO dwrl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","I bare hariyaa woyniyaa anuwaan, bare hare maraa muruta woyniyaa turaan k'achchana. I bare afilaa woyniyaa eessan, bare mayuwaa suutsaa malatiyaa woyniyaa eessan meec'c'ana. ");
INSERT INTO dwrl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Aa ayfii woyniyaa eessaappe aad'd'i zo\"ana; Aa achchaykka maatsaappe aad'd'i boos's'ana. ");
INSERT INTO dwrl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Zaabiloone abbaa doonaan de'ana; I abbaa doonaan markkabatuu ek'k'iyaa sa'aa gidana; Aa zaway Sidoona gakkanawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Yisaakoore mino hariyaa; c'aaniyaa laa\"u doonniyatuwaa gidduwaan gis bashee ");
INSERT INTO dwrl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","I bare shemppiyaasaa lo\"a gidiyaawaanne bare biittay nashechiyaawaa gidiyaawaa be'iyaa wode, c'aanaa tookkanaw bare hashiyaa hokisiide, ayiletetsaa oosuwaa ootsana. ");
INSERT INTO dwrl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Daani israa'eeliyaa zaratuwaappe ittuwaa gideedda bare asaa bolla daannatanawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daani ogiyaa doonaan de'iyaa shooshshaa; Paraa toggeeddawe guyye kunddana mala paraa ginddiyaa dukkiyaa, ogiyaan de'iyaa hasuwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Abeet Med'inaa Godaw, taani neeni ashshanaadan naagay. ");
INSERT INTO dwrl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gaadi bonk'k'iyaawanttun deshettanawaa; Shin ikka unttunttu k'atamaa kaalliide unttuntta bonk'k'anawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aaseera ukitsay ordduwaa; kaatiyaw I lo\"o k'umaa immana. ");
INSERT INTO dwrl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nifttaaleeme k'ashettennan yeda de'iyaa, lo\"o maratuwaa yeliyaa gen\"iyaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yooseefo ayfiyaana yonddodeedda woyniyaa turaa. I pulttuwaa matan yonddodda ayfiyaana de'iyaa, daashshaykka godaappe bollaanna zaa'iyaa woyniyaa turaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Wonddaafiyaa dukkiyaawanttu Aa bolla dooddeeddino; barenttu wonddaafiyaankka, dukkeeddinonne mayttiseeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Aa wonddaafii min utteedda; Aa wolk'k'aykka minniide gam\"eedda. Hewekka Yaak'ooba S'oossaa Wolk'k'aama kushiyaa gaasuwaana, ne hentsanchchaa, Israa'eeliyaa Zaallaa gaasuwaana, ");
INSERT INTO dwrl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Neena maaddiyaa ne aawotuwaa S'oossaa gaasuwaaninne, neena bolla saluwaa anjjuwaan, garssa c'iimmaa anjjuwaan, d'antsaa anjjuwaaninne yeliyaa uluwaa anjjuwaan anjjiyaa, Ubbaa Danddayiyaa S'oossaa gaasuwaana. ");
INSERT INTO dwrl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ne aawuwaa anjjuu beni deretuwaa anjjuwaappekka med'inaappe de'iyaa anjjuwaappekka aad'd'ee. Hawe ubbay Yooseefo huup'iyaan, bare ishatuwaa gidduwaan kaappuwaa gidiyaawaa liip'iyaan shemppo. ");
INSERT INTO dwrl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Biiniyaame bonk'k'iyaa walliyaa. Bare shankkateeddawaa wontta mee; bare omoodeeddawaa omarssi shaakkee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Hawanttu tammanne laa\"u israa'eeliyaa zaratuwaa; k'ay unttunttu aawuu unttuntta huup'iyaan huup'iyaan unttunttoo bessiyaa anjjuwaa anjjiidde unttunttoo geeddawe hawaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Hewaappe guyye, I unttuntta hawaadan yaagiide azazeedda; «Taani ta mayza asatuwaan gakettanaw hanay; taana Hiitiyaa Efiroona gaden de'iyaa gonggoluwaan, ta aawotuwaana moogite. ");
INSERT INTO dwrl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Hewekka Kanaane biittaan, Mamire matan de'iyaa, Maakip'eela giyaa gonggoluwaa; hewe Abrahaame Hiitiyaa Efiroonappe Aa gadiyaanna shammeedda gonggoluwaa. ");
INSERT INTO dwrl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abrahaamenne Aa machata Saara yan moogetteeddino; Yisaak'inne Aa machata Ribik'a yan moogetteeddino; taani k'ay Liyo yan moogaad. ");
INSERT INTO dwrl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","He gadiinne an de'iyaa gonggoluu Hiitetuwaappe shametteeddawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaak'oobi bare naanaw azazuwaa wursseedda wode, bare gediyaa pude bare hiis'aw shiishshi akkiidde, hayk'k'i aggeeda; bare mayzzan gaketeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yooseefo bare aawuwaa anhaa bolla kunddiide, yeekkeeddanne Aa yereedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Hewaappe guyye, Yooseefo d'aliyaa shiishshiyaa bare oosanchchatuwaa bare aawuwaa israa'eeliyaa ahaa sawiyaa shittuwaa okkiide melissana mala azazeedda; unttunttu okkiide melisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Shittuwaa okkiyaawe oytamu gallassaa kumentsaa wursseedda; ayaw gooppe, hewe gadiyaa wogaan oytamu gallassaa akkeedda. Gibs'e asatuu aw laappun tammu gallassaa yeekkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yeekuwaa gallassatuu aad'd'eedda wode, Yooseefo Gibs'e kaatiyaa golle asaa, «Taani hinttenttu sintsan nashetteeddawaa gidooppe, hinttenttu kaatiyaw hawaadan yaagiide odite; ");
INSERT INTO dwrl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‹Ta aawuu taana itti c'aak'uwaa c'aak'k'iseedda; I taana, «Taani hayana hanay; taani taw Kanaane biittaan bookkeedda gonggolo duufuwaan taana mooga» yaageedda. Hewaa diraw ha\"i taani pude baade ta aawuwaa moogana mala yeddaarikkii! Hewaappe guyye taani simmana› yaagite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kaatii, «I neena c'aak'k'iseeddawaadan pude baade ne aawuwaa mooga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yooseefo bare aawuwaa mooganaw pude beedda. Kaatiyaa oosanchchatuu ubbay, Aa kaatiyaa gollen de'iyaa wolk'k'aama Asay ubbaynne Gibs'e biittaan de'iyaa wolk'k'aama Asay ubbay Yooseefa kaalliide beeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","K'ay Yooseefo soo Asay ubbay, Aa ishatuwaanne Aa aawuwaa soo Asay beeddino; unttunttu naanay, unttunttu miizzaynne unttunttu dorssaa wudii s'alalay Geseemen atteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Paraa gaaretuukka paraa asatuukka aanana pude beeddino; Aa kaalliide beedda Asay loytsi dara. ");
INSERT INTO dwrl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Unttunttu Yorddaanoosa Shaafaa matan de'iyaa As'aade giyaa udduma gakkiidde, barenttu k'aalaa d'ok'k'u ootsiide, aw zilaaleeddinonne yeekkeeddino; yan Yooseefo bare aawuwaa yeekuwaan laappun gallassaa utteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","He biittaan de'iyaa Kanaane asatuu As'aade giyaa uddumaan he yeekuwaa be'eedda wode, «Gibs'etuu ayaa yibbaata yeekuwaa yeekkino!» yaageeddino. Hewaa diraw Yorddaanoosa matan de'iyaa he sa'ay, Aabeeli-Mis'irayma geetetteedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yaak'ooba naanay barenttu aawuu unttuntta azazeeddawaadan ootseeddino; ");
INSERT INTO dwrl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","unttunttu Aa ahaa Kanaane gadiyaa afiide, Mamire matan de'iyaa Maakip'eela giyaa gonggoluwaan, Abrahaame Hiitiyaa Efiroonappe moogoo shammeedda gadiyaan Aa moogeeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yooseefo bare aawuwaa moogeeddawaappe guyye, bare ishatuwaannanne Aa aawuwaa mooganaw aanana beedda hara asatuwaa ubbatuwaanna Gibs'e simmeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Unttunttu aawuu hayk'k'i diggeeddawaa be'iide, Yooseefo ishatuu barenttu gidduwaan, «Ooni erii Yooseefo nuuna bare uluwaan morkkooppenne nuuni aw ootseedda iitabaa ubbaw haluwaa kessana koyooppe, nuuni waananee?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Hewaa diraw Yooseefokko hawaa mala kiitaa kiitteeddino; «Ne aawuu hayk'k'anaappe kase; ");
INSERT INTO dwrl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‹Hintte Yooseefo, «Neeni ne ishatuwaa nagaraanne unttunttu neena naak'k'eedda iita naak'uwaa hayyanaa atto yaaga» yaageedda giide odite› yaageedda. Hewaa diraw ha\"i hayyanaa, nu nagaraa, ne aawuwaa S'oossaa k'oomatuwaa nagaraa atto yaaga» yaageeddino. Kiitay barekko gakkeedda wode, Yooseefo yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hewaappe guyye Aa ishatuu barenttu huup'iyaw aakko yiide, Aa sintsan guufanniide, «Nuuni ne ayiletuwaa» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Shin Yooseefo unttuntta, «Yayyoppite; taana hinttenttoo S'oossaa geedditeyye? ");
INSERT INTO dwrl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Hinttenttu taw iitanaw ootseeddita; shin hachchewaadan daro Asay hayk'k'ennan attana mala, S'oossay lo\"otetsaw hawaa ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Hewaa diraw simmi hinttenttu yayyoppite; taani hinttenanne hinttenttu naanaa mizana» yaagiide, I unttuntta mintsetsiide lo\"o k'aalaa haasayeedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yooseefo bare aawuwaa soo asaa ubbaanna Gibs'en gam\"eedda; I s'eetanne tammu laytsaa de'eedda; ");
INSERT INTO dwrl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Efireema naanaa, heezzentsa yeletaa be'eedda; k'ay Minaase na'aa Maakiina naanaanne I bare naanaa ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Hewaappe guyye Yooseefo bare ishatuwaa, «Taani hayana hanay; shin S'oossay hinttentta maaddanaw tumu s'omoosana; I hinttentta ha biittaappe kessiide, Abrahaamew, Yisaak'awunne Yaak'oobaw immana giide c'aak'k'eedda biittaa afana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yooseefo israa'eeliyaa naanaa, «S'oossay hinttentta maaddanaw tumu s'omoosiyaa wode, hinttenttu ta mek'etsaa ha biittaappe pude akkiidde biite» yaagiide c'aak'k'iseedda. ");
INSERT INTO dwrl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yooseefo s'eetanne tammu laytsaa de'iide hayk'k'eedda; unttunttu shittuwaan Aa anhaa okkiide melisseeddawaappe guyye, Gibs'e biittaan saas'iniyaan yeggeeddino.");
INSERT INTO dwrl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yaak'oobanna Gibs'e beedda Israa'eeliyaa attuma naanaa suntsay hawaappe kaaliide s'aafetteedda; unttunttu ubbaykka barenttu soy asaa akkiide beeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Hewanttukka: Roobeela, Simoona, Leewa, Yihudaa, ");
INSERT INTO dwrl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Yisaakoora, Zaabiloona, Biiniyaama, ");
INSERT INTO dwrl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daana, Nifttaaleema, Gaadanne Aaseera. ");
INSERT INTO dwrl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yaak'ooba zeretsatuu ubbay laappun tamma; Yooseefo kasekka Gibs'e bi utteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yooseefo, Aa ishatuunne he yeletaa ubbay hayk'k'eedda; ");
INSERT INTO dwrl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","shin Israa'eeliyaa zeretsay ayfeeddinonne loytsi dareeddino; he biittaa kumana gakkanaw unttunttu loytsi c'oratteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hewaappe guyyiyaan, Yooseefo erenna ooratsa kaatii Gibs'e gadiyaan denddeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","I bare asaa, «Be'ite; ha Israa'eelatuu nuuppe loytsi c'oratteeddinonne wolk'k'aameeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Haa yiite, ane nuuni unttuntta hiillan oyk'k'oytte; hewe d'ayooppe unttunttu kasewaappe yaa darana. Ooni eri olay denddooppe, unttunttu nu morkkatuwaanna dantsiide, nuuna olananne gadiyaa yeggiide kesi akkiide baanawantta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Hewaa diraw, dees'o kiitaan unttuntta tuggayana mala, unttunttu bolla mek'etsi baynna kaappotuwaa suntseeddino. Unttunttu kaatiyaw Piitoomanne Ramissa geetettiyaa miishshaa minjjiyaa katamatuwaa kees's'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Shin Gibs'etuu unttuntta un\"uwaa dariyaa wode, unttunttu c'oratti yeletteeddinonne biittaa gakkeeddino. Hewaa diraw, Gibs'etuu Israa'eelatoo yayyeeddino; ");
INSERT INTO dwrl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","k'arettay baynna hanotan ayiletetsan kiitisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","K'arettay baynna wolk'k'aama kiitaan, siminttuwaaninne s'uubiyaa med'uwaan, k'ay shooyk'aan ootsiyaa ubbaa k'ommo kiitaan, unttunttu de'uwaa c'amisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Gibs'e kaatii Ibraawe mac'c'awantta maarissiyaa S'ipaaronne Puuho geetettiyaa laa\"u mac'c'awantta hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«Ibraawe mac'c'a asatuu yeliyaa wode hinttenttu maarissiide, yelissowe attuma na'aa gidooppe, wod'ite; shin mac'c'a naatto gidooppe wod'oppite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Shin maarissiyaawanttu S'oossaw yayyiide, Gibs'e kaatii unttuntta azazeeddawaadan ootsibeykkino. Unttunttu attuma naanaa shemppuwaanna ashsheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Hewaappe guyyiyaan Gibs'e kaatii he maarissiyaawantta s'eesiide, «Hinttenttu ayaw hawaadan ootsiitee? Attuma naanaa ayaw shemppuwaanna aggiitee?» yaagiide unttuntta oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Maarissiyaawanttu zaariide, «Ibraawe mac'c'a asatuu Gibs'e mac'c'awanttu mala gidikkino; unttunttu mina gidiyaa diraw, maarissiyaawanttu gakkanaappe kasetiide yeli diggiino» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Hewaa diraw, S'oossay maarissiyaawanttoo keekkeedda. Asaa payduukka gujji gujji biide, kasewaappe yaa c'oratteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","K'ay maarissiyaawanttu S'oossaw yayyeedda diraw, S'oossay unttunttoo lo\"obaa ootseedda. Ittoo ittookka soo asaa immeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Hewaappe guyyiyaan kaatii bare asaa ubbaa, «Ibraawatuwaappe yelettiyaa attuma naanaa ubbaa Nayle Shaafaa haatsaan olite; shin mac'c'a naanay yeletooppe, shemppuwaanna aggi bashite» yaagiide azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","He wode itti Leewiyaa k'ommo gideedda bitanii Leewawe mac'c'awunno akkeedda; ");
INSERT INTO dwrl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Iza shahaaraade attuma na'aa yelaaddu. Na'ay mallaa lo\"o na'aa gidiyaawaa iza be\"aade, heezzu aginaa k'osaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Shin iza hewaappe daruwaa k'osanaw danddayennawaa eraade, c'ariyaappe k'un\"aa aw daddaaddu; yaataade haatsay gelenna mala shidiyaan maragaade, na'aa Aa giddon wotsaaddu; Nayle Shaafaa geetettiyaa haatsaa doonaan c'ariyaa giddon wotsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Aa michchata I haniyaabaa be\"anaw haakuwaan ek'k'aaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Gibs'e kaatiyaa naatta bollaa meec'ettanaw Nayle giyaa shaafaa wod'd'aaddu; izi mac'c'a k'oomatuu haatsaa doonaan yaanne haanne hamettiino; iza k'un\"aa c'ariyaa giddon be'aade, baade akkaa yaana mala bare k'oomatto kiittaaddu; ");
INSERT INTO dwrl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","k'un\"aa pokaade, be'ite hawaan k'eeri na'ay yeekki de'ee; iza aw k'arettaade; «Hawe Ibraawetu k'eeri naanatuwaappe ittuwaa» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","He wode Aa michchata kaatiyaa naatto, «New ha na'aa d'antsanaw Ibraawe mac'c'a asaappe ittinno s'eesanaw boo?» yaagaade oochchaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Iza, «Ee, ba» yaagaaddu. Naatta baade, he na'aa daayo ahaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kaatiyaa naatta he mishiratto, «Ha na'aa afaade, taw d'antsashsha; taani new dirgguwaa c'iggana» yaagaaddu. Mishirata na'aa afaade, d'antsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Na'ay dic'c'ina, kaatiyaa naattikko Aa ahaadu; I iziw na'aa gideedda; «Taani haatsaappe Aa kessaad» gaade, Musa ga suntsaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Muse dic'c'i woggaa gidiide, itti gallassi bare Asay de'iyaa sa'aa biide; unttunttu dees'o kiitta kiitettishin s'eelleedda. Gibs'e biittaa asaa ittuu, ishatuwaa gideedda Ibraawatuwaappe ittuwaa wad'd'ishin be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","I yaa haa s'eellina, ooninne baynnawaa be'iide, he Gibs'e bitaniyaa; wod'iide shafiyaa giddon k'oseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Wonttetsa gallassi kesiide, be'ite! Hachche k'ay laa\"u Ibraawetuu wad'ettiino. Naak'k'eeddawaa I, «Neeni ne ishaa gideedda Ibraawiyaa ayaw dechchay?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","He bitanii, «Neena nu bolla mooddiyaawaanne daanna ootsi suntseeddawe oonee? Neeni he Gibs'e bitaniyaa wod'eeddawaadan, taanakka wod'anaw k'oppay?» yaageedda. Muse he wode, «Taani ootseeddabay eretti diggeedda» yaagi k'oppiide yayyeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kaatiikka hawaa siseedda wode, Musa wod'anaw koyyeedda; shin Muse kaatiyaappe bak'atiide, Miidiyaama gadiyaan de'anaw biide haatsaa ollaa doonaan utteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","He wode Miidiyaama k'eesatuwaappe ittoo laappun mac'c'a naanay de'iino; unttunttu barenttu aawuwaa dorssatuwaa haatsaa ushshanaw wonggiriyaan haatsaa duuk'k'i kuntsanaw yeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Hentsanchchatuu yiide mac'c'a naanaa yedersseeddino; shin Muse denddi ek'k'iide, unttuntta ashsheeddanne unttunttu dorssatuwaa haatsaa ushsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Unttunttu barenttu aawuwaa Yootoorekko yeedda wode, «Hachche waan ellekka yeedditee?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Unttunttu zaariide, «Gibs'e gade asaa ittuu nuuna hentsanchchatuwaappe ashsheeda; I nuw haatsaakka duuk'k'iide dorssaa wudiyaa ushsheedda» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","I bare mac'c'a naanaa, «Yaatina I hak'an de'ii? Hinttenttu he bitaniyaa ayaw aggi basheedditee? Ane Aa s'eesiide, miyaabaa shoobbite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Muse he bitaniyaanna yaan de'anaw mayetteedda; bitaniikka bare naatto S'ipaaro Musew machchato ootsiide immeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","S'ipaara attuma na'aa yelina, Muse Aa, «Taani asaa gadiyaan bete gidaad» yaagiide, Gershshooma gi suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","C'ora laytsaappe guyyiyaan, Gibs'e kaatii hayk'k'eedda. Israa'eelatuu barenttu ayiletetsaappe un\"ettiide waasseeddino; unttunttu waasseedda waasuu pude S'oossakko gakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","S'oossay unttunttu un\"aa waasuwaa sisiide, I Abrahaamena, Yisaak'ananne Yaak'oobanna c'aak'k'eedda c'aak'uwaa hassayeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Hewaa diraw, S'oossay Israa'eelatuwaa s'eelliide unttunttu diraw k'oppeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Itti wode Muse Miidiyaama gade k'eesiyaa, bare bolluwaa Yotoora dorssatuwaa heemmee; I he wudiyaa laaggi akkiide mela biittaa gas'aa gakkanaw afiide S'oossaa Deriyaa Siina gakkeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","He sa'aan Med'inaa Godaa kiitanchchay aac'an, ees's'iyaa tamaa lac'uwaa giddon aw beetteedda; aac'ay tamaan s'uugettinttokka, tamay aac'aa meennawaa Muse be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Hewaa diraw, Muse, «Taani yaa baade, aac'ay ayaw tamaan meetettibeennetto ha ooratsabaa ane be'ana» yaagiide k'oppeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","I be'anaw yaa beeddawaa Med'inaa Goday be'iide aac'aa giddoppe S'oossay Aa, «Muse! Muse!» yaagiide s'eeseedda. Muse, «Abee» giide koyyeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","S'oossay Aa, «Haa shiik'oppa. Neeni ek'k'eedda biittay geeshsha gidiyaa diraw, ne gediyaan de'iyaa c'aammaa kessa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","K'aykka S'oossay Aa, «Taani ne aawuwaa S'oossaa, Abrahaamo S'oossaa, Yisaak'a S'oossaa, Yaak'ooba S'oossaa» yaageedda. Muse S'oossaa s'eellanaw yayyeedda diraw, bare deemuwaa gentseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Med'inaa Goday k'aykka hawaadan yaageedda; «Taani Gibs'e gadiyaan ta Asay tuggatiyaa tuggaa geeshsha be'aade, unttunttu barenttu kaappotuwaappe waassiyaa waasuwaa sisaade, taani unttunttu metuwaa ubbaa d'iishaad. ");
INSERT INTO dwrl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Hewaa diraw, taani unttuntta Gibs'e gadiyaa asatuwaa kushiyaappe ashshanawunne he gadiyaappe unttuntta kessaade, aakonne lo\"o gadiyaa ahanaw wod'd'aaddi. He gadii maatsaynne eessay goggiyaa biittaa; he gadiyaan Kanaanetuu, Hiitetu, Amoorawaanatu, Parzzawanatu, Hiiwetunne Yaabuusawaanatuu ha\"i de'iino. ");
INSERT INTO dwrl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ha\"i Israa'eeletuwaa waasuu taakko gakkeedda; Gibs'e gadiyaa asatuu unttuntta naak'k'iyaa naak'uwaa taani be'aaddi; ");
INSERT INTO dwrl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","hewaa diraw, ha\"i ba; ta asatuwaa, Israa'eelatuwaa Gibs'eppe kessana mala, Gibs'e kaatiyaakko taani neena kiittay» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Shin Muse S'oossaa, «Kaatiyaakko baanawunne Israa'eelatuwaa Gibs'eppe kessanaw taani oonee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","S'oossay Aa, «Taani neenana gidana; k'ay taani neena kiitteeddawoo mallay hawaa: neeni he asaa Gibs'eppe kesseedda wode, ha deriyaa bollan hinttenttu S'oossaw goynnanita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Muse S'oossaa, «Gido shin, taani Israa'eeletuwaakko baade, unttuntta, ‹Hintte aawotuwaa S'oossay taana hinttenttukko kiitteedda› yaagina, unttunttu taana, ‹Aa suntsay oonee?› yaagiide oochchooppe, he wode taani unttunttoo waaga odoo?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","S'oossay Musa, «Taani Taana; neeni Israa'eeletoo, ‹Taana geetettiyaawe hinttenttukko taana kiitteedda› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","S'oossay Musa k'ay, «Neeni Israa'eelatoo, ‹Med'inaa Goday hinttenttu aawotuwaa S'oossay, Abrahaamo S'oossay, Yisaak'a S'oossay, Yaak'ooba S'oossay, I taana hinttenttukko kiitteedda› yaaga; hawe yeletaappe yeletay gakkanaw taani hassayettiyaa med'inaw ta suntsaa. ");
INSERT INTO dwrl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«Simmi; baade Israa'eeliyaa c'imatuwaa shiishshaade, ‹Med'inaa Goday hinttenttu aawotuwaa S'oossay, Abrahaama, Yisaak'anne Yaak'ooba S'oossay taw k'onc'c'iide; taana, Taani hinttentta s'omoosaad; Gibs'en hinttenttu bolla oosetteeddawaakka taani be'aaddi. ");
INSERT INTO dwrl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Taani hinttentta Gibs'e gadiyaa tuggaappe kessaade, maatsaynne eessay goggiyaa Kanaanetuwaa, Hiitetuwaa, Amoorawaanatuwaa, Parzzawaanatuwaa, Hiiwetuwaanne Yaabusawaanatuwaa gadiyaa afana ga uttaad.› ");
INSERT INTO dwrl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Israa'eeliyaa c'imatuu ne k'aalaa sisanawantta; hewaappe guyyiyaan neeninne he c'imatuu Gibs'e kaatiyaakko biide Aa, ‹Med'inaa Goday, Ibraawetuwaa S'oossay, nuunanna gaketteedda. Ha\"i nuuni heezzu gallassaa ogiyaa mela biittaa hametti biide, Med'inaa Godaa, nu S'oossaw, yarshshuwaa yarshshana mala nuuna yedda› yaagite. ");
INSERT INTO dwrl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Shin Wolk'k'aama kushii, Aa, wolk'k'an yedissana d'ayooppe, Gibs'e kaatii hinttentta yeddennawaa taani eray. ");
INSERT INTO dwrl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Hewaa diraw, Taani Ta kushiyaa yeddaade, unttunttu giddon Taani ootsiyaa Ta malaatatuwaa ubbaan Gibs'etuwaa shoc'ana. Hewaappe guyyiyaan I hinttentta yeddanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","«K'ay taani Gibs'etuwaan ha asaa sabbissana; yaatooppe hinttenttu kesiyaa wode kushe mela kesikita. ");
INSERT INTO dwrl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ibraawe mac'c'awunna ubbatta bare Gibs'e shooratikkonne bare soon de'iyaa Gibs'e mac'c'a asaa oonanne gidooppe iikko biide, biraa miishshatuwaa, work'k'aa miishshatuwaanne attuma naanaynne mac'c'a naanay mayyana mayotuwaa ‹Immite› giide oochchanawantta. Hewaadan ootsiide hinttenttu Gibs'etuwaa mas'uwaa bonk'k'anitta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Muse zaariide, «Unttunttu taana ammanennaan is's'ooppe, woy taani odiyaawaa sisennan is's'iide, ‹Med'inaa Goday new k'onc'c'ibeenna› gooppe waanoo?» yaagi zaareedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Med'inaa Goday Aa, «He ne kushiyaan de'iyaawe ayee?» yaagiide oochcheedda. Ikka «S'am\"aa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Med'inaa Goday Aa, «Ane he s'am\"aa sa'aan ola» yaageedda. Muse he s'am\"aa sa'aan oleedda wode shooshshaa gideedda; yaatina, Muse aappe wos's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Hewaappe guyyiyaan Med'inaa Goday Aa, «Ne kushiyaa yeddaade, Aa dufiyaa oyk'k'a» yaageedda. Muse yeddiide shooshshaa oyk'k'ina, shooshshay Aa kushiyaan simmiide, s'am\"aw laametteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Med'inaa Goday, «Hawe haneeddawe, Med'inaa Goday ne aawotuwaa S'oossay, Abrahaama S'oossay, Yisaak'a S'oossaynne Yaak'ooba S'oossay new k'onc'c'eeddawaa unttunttu ammananaadana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Hewaappe guyyiyaan Med'inaa Goday Aa, «Ne kushiyaa ne shop'p'iyaan yedda» yaagina, Muse bare kushiyaa shop'p'iyaan yeddeedda; I kessi s'eeliide, «ta kushii oollotiide shachchaadan boos's'eedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","S'oossay Aa, «Ne kushiyaa ne shop'p'iyaan zaaraade yedda» yaageedda. Muse bare kushiyaa bare shop'p'iyaan zaari yediidde kessiyaa wode, «ta kushii simmiide hinkko bollaa mala gideedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","K'aykka Med'inaa Goday Aa, «Unttunttu neena ammanennaan d'ayooppenne koyro malaataa ammanennaan is's'ooppe, laa'entso malaata unttunttu ammananawantta. ");
INSERT INTO dwrl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Shin unttunttu ha laa\"u malaatatuwaa ammanennan d'ayooppe, woy neeni odiyaawaa sisennan is's'ooppe, Nayle Shaafaappe haatsaa akkaade, mela biittan gussa; neeni shaafaappe akkeedda haatsay biittan suutsaa gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Muse Med'inaa Godaa, «Abeet Med'inaa Godaw, taani hawaappe kasekka, woy neeni ne k'oomaw haasayoodeppe doomina taani haasayanaw danddaykke; taani deeddotaadde haasayay; k'ay ta ins's'arssaykka lufaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Med'inaa Goday Aa, «Asaw doonaa med'd'eeddawe oonee? Aa duude, woy tulle ootsiyaawe oonee? S'eelliyaawaanne k'ook'aa ootsiyaawe oonee? Taana Med'inaa Godaa gidikkitaayye? ");
INSERT INTO dwrl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Neeni ha\"i ba; taani neena haasayanaadan maaddana; neeni gaanabaa taani neena tamaarissana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Shin Muse, «Abeet Godaw, hayyanaa, hawaa ootsanaw hara asaa kiittaarikkii!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Hewaappe guyyiyaan Med'inaa Goday Musew loytsi hank'k'ettiide Aa, «Leewiyaa gideedda ne ishaa Aaroonee? I lo\"o haasayana danddayiyaawaa taani eray; ha\"i I neenana gaketanaw yiidde ogiyaa bollan de'ee; I neena be'iyaa wode Aa wozanay nashettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Neeni, ‹Yaaga; yaaga› gaade aw odana; taani hinttentta laa\"uwaakka haasayanaw maaddananne hinttenttu ootsanabaa tamaarissana. ");
INSERT INTO dwrl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","I asaw ne diraa haasayanawaa; hewekka, I new doonaa mala gidanawaa, neeni aw S'oossaa mala gidanaassa giyaawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Shin malaatatuwaa an ootsanaw, neeni ha s'am\"aa akkaade ba» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Hewaappe guyyiyaan Muse bare bolluwaa Yotoorekko simmi biide, «Hanno gakkanaw shemppuwaanna de'iyaa Asay de'ooppe be'anaw, taani guyye ta asaakko Gibs'e boo?» yaageedda. Yootoore Musa, «Ee ba; saro gakka» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Muse Miidiyaama gadiyaan de'ishshin Med'inaa Goday Aa, «Neena wod'anaw koyeedda asatuu ubbay hayk'k'i diggeedda diraw, guyye Gibs'e gadiyaa simmaade ba» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Muse bare machatonne bare attuma naanaa hariyaa togissi akkiide, guyye Gibs'e simusaa doommeedda; Muse S'oossaa s'am\"aa bare kushiyaan oyk'k'iide beedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Med'inaa Goday Musa, «Neeni Gibs'e simmaade biyaa wode, taani new immeedda wolk'k'an neeni ootsana malaatatuwaa ubbaa Gibs'e kaatiyaa sintsaan neeni ootsanawaa baloppa. Yaatinakka asaa I yeddenna mala, taani Aa wozanaa donc'c'ilisanna. ");
INSERT INTO dwrl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","He wode taani Med'inaa Goday, giyaawaa kaatiyaw hawaadan yaagaade oda; ‹ «Israa'eelii ta bayira na'aa. ");
INSERT INTO dwrl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","I taw goynnana mala, ta na'aa neeni yeddana mala, taani new odaaddi; shin neeni Aa yeddenaan is's'aadda; hewaa diraw, taani ne bayira attuma na'aa wod'ana» yaagee› yaagaade oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ogiyaan shemppiyaasan Med'inaa Goday Musena gaketeedda; Aa wod'ana haneedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Aa machatta S'ipaara saliyaa akkaade, bare na'aa k'as's'araaddu. He shookuwaan Muse gediyaa bochchaaddu. Iza Musa, «Neeni taw tumu suutsaa mishiraa» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Med'inaa Goday hewaa diraw Aa wod'enaan aggeeda. He wode k'as's'araa malaatanaw Aa, «Neeni taw suutsaa mishiraa» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Med'inaa Goday Aaroona, «Neeni Musena gaketanaw mela biittaa ba» yaageedda. I biide, Musena S'oossaa deriyaan gakettiide Aa yereedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Hewaappe guyyiyaan Muse Med'inaa Goday bare bolla kiitteedda k'aalaa ubbaanne ootsana mala, barena azazeedda ooratsa malaatatuwaa ubbaa Aaroonaw odeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musenne Aaroone biide, Israa'eeletuwaa c'imatuwaa ubbaa shiishsheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaroone Med'inaa Goday Musew odeedda k'aalaa ubbaa unttunttoo odeedda. Malaatatuwaakka he asaa sintsan ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Unttunttukka ammaneeddino. Med'inaa Goday unttunttoo k'oppeeddawaanne unttunttu tuggaa be'eeddawaa siseedda wode, unttunttu guufanniide goynneeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hewaappe guyyiyaan Musenne Aaroone Gibs'e kaatiyaakko yiide Aa, «Med'inaa Goday, Israa'eeliyaa S'oossay hawaadan yaagee; ‹Ta Asay taw mela biittaan baalaa bonchchana mala, unttuntta yedda› yaagee» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Kaatii, «Taani aw azazettaade Israa'eeliyaa yeddanaw he Med'inaa Goday oonee? Taani Med'inaa Godaa erikke; Israa'eeliyaakka yeddikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Hewaappe guyyiyaan unttunttu, «Ibraawetuwaa S'oossay nuunanna gaketeedda. Ha\"i nuuni Med'inaa Godaa, nu S'oossaw, yarshshuwaa yarshshanaw heezzu gallassaa ogiyaa mela biittaa giddo baanaw nuuna yeddaarikkii; hewe d'ayooppe, I nuuna iita harggiyaan woy olan wod'anawaa» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Shin Gibs'e kaatii yaageedda; «Muse! Aaroona! Asaa ayaw kiittaa diggiittee? Hinttenttu kiittaw simmiide biite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kaatii he wode, «Be'ite, ha gadiyaan Asay c'oratteedda; k'ay hinttenttu unttuntta kiittaa diggiita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Kaatii he gallassi Gibs'etuwaa kaappotuwaanne Israa'eeletuwaa daguwaa suntsatuwaa azaziide, ");
INSERT INTO dwrl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Haroodewaadan s'uubiyaa med'd'iyaa utulaa asaw immoppite; unttunttu utulaa barenttoo biide shiishshino; ");
INSERT INTO dwrl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","shin unttunttu payduwaan kasewaa keeshshaa s'uubiyaa med'd'iide, sheed'd'anaadan azazite; he payduwaappe pac'issoppite; ayaw gooppe, unttunttu azalla; unttunttu, ‹Nuuni nu S'oossaw yarshshuwaa yarshshana mala, nuuna yeddaarikkii› yaagiide waassiyaawe hawaassa. ");
INSERT INTO dwrl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Unttunttu kiitaan sheekkana malanne wordduwaa haasayaa sisennan aggana mala, unttunttoo oosuwaa dees'isite» yaagiide azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Hewaappe guyyiyaan, he kaappotuunne he suntsatuu kesiide asaa, «Kaatii hawaadan yaagee; ‹Simmi taani hinttenttoo ubbakka utulaa immikke; ");
INSERT INTO dwrl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","hinttenttu utulaa demmana danddayiyaasaappe hinttenttu huup'iyaw shiishshite; shin hinttenttu sheed'd'iyaa s'uubiyaa payduu ubbakka pac'c'enna› yaageedda» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Aasi utulaw haniyaawaa shiishshanaw Gibs'e biittaa ubbaan laaletteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Gibs'etuwaa kaappotuu unttuntta, «Hinttenttoo utulaa immiyaa wode hinttenttu hachche hachche ootsiyaawaa keeshshaa ootsite» yaagiide unttuntta godeteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Gibs'etuwaa kaappotuu Israa'eeletuwaa daguwaa suntsatuwaa wad'd'iide, «Hinttenttu kase ootsiyaawaa keeshshaa s'uubiyaa zino woy hachche ayaw ootsi wurssibeykkitee?» yaagiide oochcheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Hewaappe guyyiyaan Israa'eeliyaa suntsatuu biide kaatiyaw maganeeddino; unttunttu barenttu metuwaappe denddowaan Aa, «Neeni ne k'oomatuwaa hawaadan ayaw ootsay? ");
INSERT INTO dwrl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ne k'oomatoo utulaa immikkino; shin, ‹S'uubiyaa med'd'ite› yaagiino; nuuna ne k'oomatuwaa wad'd'iino; shin balay ne asaa bollana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Shin kaatii unttuntta, «Ha azallatuu! Hinttenttu azalla! Hewaa diraw, hinttenttu zaari zaariide, ‹Nuuni Med'inaa Godaw yarshshana baanaw nuuna yeddaarikkii› yaagiita. ");
INSERT INTO dwrl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ha\"i biite; ootsite; unttunttu hinttenttoo ay utulaakka immikkino; shin hinttenttu kasewaa keeshshaa s'uubiyaa med'd'iita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israa'eelatuwaa suntsatuu, «Hinttenttu hachche hachche med'd'iyaa s'uubiyaa payduwaa kasewaappe pac'issoppite» geedda wode, unttunttu metuwaan geleeddawaa akeekeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Unttunttu kaatiyaa mataappe kesiide, Musenne Aaroone unttunttunna gakettanaw naagiyaawantta demmeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Unttunttu, «Hinttena Med'inaa Goday s'eello! Hinttenttu bolla I pirddo! Hinttenttu nuuna kaatiyaananne Aa oosanchchatuwaan is'isseeddita; k'ay unttunttu nuuna wod'ana mala, mashshaa unttunttu kushiyaan wotseeddita» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Muse Med'inaa Godaakko simmiide, «Abeet Godaw, neeni ha asaa bolla metuwaa ayaw ahaadii? Neeni taana kiitteeddawe hawaassee? ");
INSERT INTO dwrl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Taani ne suntsan kaatiyaw haasayanaw beedda wodeppe doommina, I ha asaa bolla metuwaa aheedda. K'ay neenikka ne asaa mule ashshabaakka» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Hewaappe guyyiyaan Med'inaa Goday Musa, «Taani Gibs'e kaatiyaa ootsanabaa neeni ha\"i be'ana; ta wolk'k'aama kushiyaa gaasuwaan I unttuntta yeddanawaa; ta wolk'k'aama kushiyaa gaasuwaan I unttuntta bare gadiyaappe laaggiide kessana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","S'oossay k'aykka Musa, «Taani Med'inaa Godaa; ");
INSERT INTO dwrl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Taani Abrahaamew, Yisaak'awunne Yaak'oobaw Ubbaa Danddayiyaa S'oossaa gidaade k'onc'c'aad; shin Taani, Med'inaa Godaa giyaa ta suntsan, taanatetsaa unttuntta erissabeykke. ");
INSERT INTO dwrl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","K'ay taani unttunttoo unttunttu bete gidiide de'eedda Kanaane gadiyaa immanaw ta k'aalaa c'aak'uwaa unttunttunna c'aak'k'etaad. ");
INSERT INTO dwrl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","K'aykka Gibs'e asatuu ayileyiyaa Israa'eeletuwaa ooliyaa taani sisaade, ta k'aalaa c'aak'uwaa hassayaadi. ");
INSERT INTO dwrl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","«Hewaa diraw, neeni Israa'eelatuwaa, ‹Taani Med'inaa Godaa; Taani hinttentta Gibs'etuwaa naak'uwaappe kessana; Taani hinttentta unttunttu ayiletetsaappekka la\"a kessana; k'ay Taani ta wolk'k'aama wolk'k'aan Gibs'etuwaa bolla iita pirddaa ahaade hinttentta wozana. ");
INSERT INTO dwrl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Taani hinttentta ta huup'e asaadan akkananne taani hinttenttu S'oossaa gidana. He wode hinttenttu Taani Med'inaa Godaa hinttenttu S'oossaa hinttentta Gibs'etuwaa ayiletetsaappe kesseeddawaa gidiyaawaa erana. ");
INSERT INTO dwrl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","K'ay Taani Abrahaamew, Yisaak'awunne Yaak'oobaw immanaw c'aak'k'eedda biittaw ahana; he gadiyaa taani hinttenttoo gade ootsaade immana; Taani Med'inaa Godaa yaaga› » yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Muse hawaa Israa'eeletoo odeedda; shin unttunttu ayaanay me\"eedda gaasuwaaninne mek'etsi baynna ayiletetsaa gaasuwaan Aa k'aalaa sisibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Hewaappe guyyiyaan Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Baade Gibs'e kaatiyaa, ‹Israa'eeletuwaa ne gadiyaappe kessaade yedda› yaagaade oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Shin Muse Med'inaa Godaa, «Haray atto Israa'eeletuu tabaa sisennan is's'eeddino shin taani deeddotiyaa ins's'arssan haasayiyaawaa kaatii wooti sisanee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Med'inaa Goday Musanne Aaroona, «Biide, hinttenttu Israa'eeliyaa asaa Gibs'eppe kessana mala, taani hinttentta yeddeeddawaa Israa'eeliyaa asawunne Gibs'e kaatiyaw odite» yaagiide azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Unttunttu soy soy mayza aawotuu hawantta. Israa'eeliyaw bayira na'aa Roobeela attuma naanay, Heenooka, Paalu, Hes'iroonanne Karmma; hawanttu Roobeela yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simoona attuma naanay, Yimu'eela, Yaamiina, Ohaada, Yaakiina, S'oohaaranne Kanaane gade mishirattippe yeletteedda Shaa'ula; hawanttu Simoona yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Leewiyaa attuma naanay barenttu yeletaa maaraadan Gershshoona, K'ahaatanne Maraara. Leewii s'eetanne hattamanne laappun laytsaa de'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershshoona attuma naanay barenttu yaran yaran Liibinanne Shim\"a geetettiino. ");
INSERT INTO dwrl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","K'ahaate attuma naanay Amiraama, Yis'ihaara, Kebroonanne Uzi'eela. K'ahaate s'eetanne hattamanne heezzu laytsaa de'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Maraara attuma naanay Maahilanne Musha giyaawantta. Barenttu Yeletaa maaran hawaappe k'ommonna s'eegeteedda Leewiyaa yaratuu hawantta. ");
INSERT INTO dwrl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amiraame bare aawuwaa michchato Yokebeedo akkeedda. Iza Aaroonanne Musa aw yelaaddu. Amiraame s'eetanne hattamanne laappun laytsaa de'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yis'ihaara attuma naanay, K'oraaha, Nefeeganne Ziikira. ");
INSERT INTO dwrl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uuzi'eela attuma naanay, Mishaa\"eela, Els's'aafaananne Siitira. ");
INSERT INTO dwrl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaroone Aminaadaaba naatto, Na'aasoona michchato Elisheebo akkeedda. Yaatina iza aw Nadaaba, Abiiha, El\"aazaranne Ittaamaara geetettiyaa attuma naanaa yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","K'ore attuma naanay, Asiira, Elk'k'aananne Abiyaasaafa; hawanttu K'ore yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaroona na'ay El\"aazare Puti'eela naanatuwaappe ittinno akkeedda; iza aw Piinihaasa yelaaddu. Hawanttu barenttu yaran yaran Leewatuwaa golliyaa mayza asatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Med'inaa Goday, «Gibs'e gadiyaappe Israa'eelatuwaa olaw giigo c'uguwaadan c'uguwaadan kessite» yaageeddawe ha Musanne Aaroona. ");
INSERT INTO dwrl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Israa'eelatuwaa Gibs'e gadiyaappe kessiyaawaa Gibs'e kaatiyaw haasayeeddawanttu unttuntta. Hewanttukka Musanne Aaroona. ");
INSERT INTO dwrl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Med'inaa Goday Gibs'en Musew haasayeedda wode Aa, ");
INSERT INTO dwrl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","«Taani Med'inaa Godaa; Taani new odiyaawaa ubbaa neeni Gibs'e kaatiyaw oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Shin Muse Med'inaa Godaa, «Taani deeddotiyaa ins's'arssan haasayiyaawaa gidishin, kaatii taani odiyaawaa wooti sisanee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Hewaappe guyyiyaan Med'inaa Goday Musa, «Be'a; taani neena Gibs'e kaatiyaw S'oossaa mala ootsaad; ne ishay Aaroone ne nabiyaadan gidanawaa; ");
INSERT INTO dwrl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","taani neena azazeedda ubbaa neeni aw odaasa; ne ishaa Aaroone Israa'eelatuwaa bare gadiyaappe kessi yeddana mala, kaatiyaw odee. ");
INSERT INTO dwrl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Shin taani kaatiyaa wozanaa d'ulissana; taani Gibs'e gadiyaan ta c'ora malaatanne maalaalissiyaabaa darissaade ootsinttokka, ");
INSERT INTO dwrl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","I hinttenttu odiyaawaa sisenna. He wode taani ta kushiyaa Gibs'etuwaa bolla dentsana; taani ta c'uguwaa, ta asaa Israa'eeliyaa, Gibs'e asaa bollan wolk'k'aama pirddaa ahaade kessana. ");
INSERT INTO dwrl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Hewaappe guyiyaan Gibs'etuu, taani ta kushiyaa Gibs'e bolla dentsaade, Israa'eelatuwaa unttunttu giddoppe kesseedda wode, taani Med'inaa Godaa gidiyaawaa unttunttu eranawantta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musenne Aaroone likke Med'inaa Goday unttuntta azazeeddawaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Unttunttu kaatiyaw odiyaa wode, Muse hosppun tammu laytsaa asaa; Aaroone k'ay hosppun tammanne heezzu laytsaa asaa. ");
INSERT INTO dwrl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Med'inaa Goday Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Kaatii hinttentta, ‹S'oossay ootsiyaa malaataa taana bessite› giyaa wode, neeni Aaroona, ‹Ne s'am\"aa akkaade, kaatiyaa sintsan ola› yaaga; yaatooppe I shooshshaa kessana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musenne Aaroone kaatiyaakko geliide Med'inaa Goday unttuntta azazeeddawaadan ootseeddino; Aaroone bare s'am\"aa kaatiyaa sintsaaninne Aa oosanchchatuwaa sintsan olina shooshshaa kesseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Hewaappe guyyiyaan kaatii eranchchatuwaanne bitiyaawantta s'eesissina unttunttukka, ha Gibs'etuwaa shareechchotuu barenttu d'amaashuwaan hewaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Unttunttu ubbaykka barenttu s'am\"aa s'am\"aa olina, s'am\"atuu shooshshaa kesseeddino; shin Aaroona s'am\"ay unttunttu s'am\"atuwaa mitteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Gidooppenne Med'inaa Goday odeeddawaadankka kaatiyaa wozanay donc'c'ileedda; I unttunttu oduwaa sisennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Med'inaa Goday Musa, «Kaatiyaa wozanay donc'c'ileedda; asaa I yeddennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kaatii haatsaakko biyaa wode, guuraade neeni aakko baade aanana gaketanaw Nayle Shaafaa doonaan ee\"a; shooshshaw laametteedda s'am\"aa oyk'k'a akkaade ba. ");
INSERT INTO dwrl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Neeni Aa, ‹Med'inaa Goday, Ibraawetuwaa S'oossay neena, mela biittaan taw goynnana mala, ta asaa yedda yaagiide, taana neekko kiitteedda; shin hanno gakkanaw neeni sisabeykka. ");
INSERT INTO dwrl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Med'inaa Goday, Taani Med'inaa Godaa gidiyaawaa neeni hawaan erana. Taani Nayle Shaafaa haatsaa ta kushiyaan de'iyaa s'am\"an shoc'ina haatsay suutsaw laamettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nayle Shaafaa moliikka hayk'k'anawaa; shaafaykka s'ink'k'anawaa; Gibs'etuu he shaafaa haatsaa ushanaw danddaykkino› yaagaade oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Med'inaa Goday Musa hawaadan yaageedda; «Neeni Aaroona, ‹Ne s'am\"aa oyk'k'aade Gibs'e haatsatuwaa bolla, shaafatuwaa bolla, zeereeto haatsatuwaa bolla, di'uwaa ollaa bollan ne kushiyaa mic'c'a› yaaga; I mic'c'ina unttunttu suutsaw laamettanawaa; Gibs'e biittaa ubbaan, haray attina, mitsaappenne shuchchaappe wooc'iide kesseedda haatsaa tigiyaa miishshaa ubbaa garssan de'iyaa haatsay suutsaw laamettana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musenne Aaroone Med'inaa Goday azazeeddawaadan ootseeddino. Kaatiyaa sintsaaninne Aa oosanchchatuwaa sintsaan I bare s'am\"aa dentsiide, shaafaa haatsaa shoc'ina haatsaa ubbay suutsaw laametteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","He shaafaa haatsaa gidduwaan de'iyaa moletuu hayk'k'eeddino; shaafaa haatsay loytsi zee\"eedda diraw, Gibs'e Asay ushanaw danddayibeenna. Gibs'en ubba saan suutsay kumeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Gibs'e shareechchotuukka barenttu d'amaashuwan hewaadan ootseeddino; Med'inaa Goday odeeddawaadankka kaatiyaa wozanay donc'c'ilina, Musenne Aaroone odeeddawaa sisennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Hewaappe guyyiyaan kaatii hawoo ayinne hirggennan bare soo simmiide beedda. ");
INSERT INTO dwrl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Gibs'e Asay ubbay Nayle Shaafaa haatsaa ushanaw danddayibeenna diraw, ushiyaa haatsaa demmanaw Nayle Shaafaa gas'aan ollaa bookkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Med'inaa Goday haatsaa shoc'oodeppe laappun gallassaa gideedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Hewaappe guyyiyaan Med'inaa Goday Musa, «Ba; Gibs'e kaatiyaakko baade, ‹Med'inaa Goday hawaadan yaagee; «Taw goynnana mala, ta asaa yedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Neeni unttuntta yeddennan is's'ooppe, taani ne biittaa ubbaan shed'd'iyaa kuntsana. ");
INSERT INTO dwrl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nayle Shaafaan shed'd'ii shohakkattana. Unttunttu shohakkatti kesiide ne soo, ne siris'aa, ne gisuwaa giddo, ne oosanchchatuwaa golliyaa giddo gelana; ne asaa bolla kesana; ne c'ooc'iyaanne ne d'iiliyaa wotsiyaa keriyaan gelana. ");
INSERT INTO dwrl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Shed'etuu ne bolla, ne asaa bollanne ne oosanchchatuwaa ubbaa bolla kesana» yaagee› yaagaade oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Hewaappe guyyiyaan Med'inaa Goday Musa, «Neeni Aaroona, ‹Ne s'am\"aa oyk'k'aadde, shaafatuwaa bolla, zeereeto haatsatuwaa bollanne di'uwaa ollaa bolla ne kushiyaa mic'c'aade shed'etuu Gibs'e gadiyaa bollan kessanaadan ootsa› yaagaadde oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaroone Gibs'e haatsatuwaa bolla bare kushiyaa mic'c'ina shed'etuu kesiide, Gibs'e gadiyaa mayyeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Shareechchatuukka barenttu d'amaashuwaan hewaadan ootseeddino; unttunttukka Gibs'e gadiyaan shed'd'ii kessanaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kaatii Musanne Aaroona s'eesissiide, «Ha shed'etuwaa taappenne ta asaappe diggana mala, Med'inaa Godaa hinttenttu woossite; yaatooppe Med'inaa Godaw yarshshuwaa yarshshana mala, taani asaa yeddana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Muse kaatiyaa, «Kaatiyaw shed'etuu neeppenne ne sooppe d'ayana malanne Nayle Shaafaa s'alalan attana mala, taani new, ne oosanchchatoonne ne asaw woosana wodiyaa neeni keera» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Kaatii, «Wontta» yaageedda. Muse, «Med'inaa Godaa Nu S'oossaa, malay ooninne baynnawaa neeni erana mala, neeni geeddawaadan hananawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","He shed'etuu neeppe, ne golliyaappe, ne oosanchchatuwaappenne ne asaappe d'ayanawantta; unttunttukka Nayle Shaafaa s'alalan attanawantta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Musenne Aaroone kaatiyaa mataappe kesseeddino; kaatiyaa bolla Med'inaa Goday aheedda shed'd'etuwaabaa Muse Med'inaa Godaakko woosseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Med'inaa Goday Muse oochcheeddawaadan ootseedda; shed'etuu son kareninne dembban hayk'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Gibs'e Asay unttuntta shiishshi shiishshiide dooreeddino; biittay hewaa s'ink'k'uwaan zee\"eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Shin kaatii shed'etuu baynnawaa be'eedda wode Aa wozanay donc'c'ileedda; Med'inaa Goday odeeddawaadankka, I Musenne Aaroone odeedda oduwaa sisennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Med'inaa Goday hewaappe guyyiyaan, Musa «Neeni Aaroona, ‹Ne s'am\"aa mic'c'aade, biittaa baana shoc'a› yaagaade oda. Gibs'e biittaa ubbaan baanay c'uuchchaa kessanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Unttuttu hewaadan ootseeddino; Aaroone s'am\"aa oyk'k'iide bare kushiyaa mic'c'iidde; bare s'am\"an biittaa baana shoc'ina asaanne, mehiyaa bolla c'uuchchay yeedda. Gibs'e gadiyaan ha gas'aappe ya gas'aa gakkanaw, baana ubbay c'uuchchaa kesseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Shareechchatuukka barenttu d'amaashuwaan hewaadan ootsanaw baas'eteeddino; shin danddayibeykkino. C'uuchchay asaa bollanne, mehiyaa bolla kummeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Shareechchatuu kaatiyaa, «Hawe S'oossaa oosuwaa» yaageeddino. Shin kaatiyaa wozanay donc'c'ileedda; S'oossay geeddawaadankka, I unttunttu odiyaawaa sisennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Med'inaa Goday Musa, «Guuran denddaade, kaatii shaafaa biishshin aanana gakettaade neeni Aa, ‹Med'inaa Goday yaagee; «Taw ootsana mala, ta asaa yedda; ");
INSERT INTO dwrl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","neeni ta asaa yeddennan is's'ooppe, taani ne bolla, ne oosanchchatuwaa bolla, ne asaa bollanne ne golletuwaa giddo uduns's'iyaa wudiyaa yeddana; Gibs'etuwaa golleninne unttunttu de'iyaa biittaa ubbaan uduns's'ii kumanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Shin he gallassi ta Asay bete gidiide de'iyaa Goshena gadiyaan uduns's'ii kumenaadan taani te'aade, unttunttu biittaa shaakana; Taani Med'inaa Goday, ha gadiyaa ubbaan de'iyaawaa neeni hewaan erana. ");
INSERT INTO dwrl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Taani ta asaanne ne asaa shaakana; ha wolk'k'aama malaatay wontti hanana» yaagee› yaagaadde oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Med'inaa Goday hewaappe guyyiyaan, geeddawaadan ootseedda; kaatiyaa sooninne Aa oosanchchatuwaa son daro uduns's'iyaa wudii yeedda; Gibs'e gadiyaa ubbaa bayzzeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","He wode kaatii Musanne Aaroona s'eesissiide, «Biite; ha gadiyaan hinttenttu S'oossaw yarshshite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Shin Muse, «Hewe likke gidenna; nuuni Med'inaa Godaa Nu S'oossaw shiishshiyaa yarshshotuu Gibs'etuwaa sheneyiyaawaa gidanawaa; nuuni unttuntta sheneyiyaa yarshshotuwaa unttunttu s'eellishin yarshshooppe, unttunttu nuuna shuchchaan c'addikkinoo? ");
INSERT INTO dwrl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nuuni Med'inaa Godaa, nu S'oossaw, yarshshotuwaa shiishshanaw I nuuna azaziyaawaadan, heezzu gallassaa ogiyaa mela biittaa baana koshshee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kaatii, «Med'inaa Godaw, hinttenttu S'oossaw, hinttenttu mela biittaa biide yarshshana mala, taani hinttentta yeddana; shin hinttenttu haakkiide booppite; taw ha\"i woossite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Muse, «Taani ne mataappe keso sa'aannakka Med'inaa Godaa woosana; ha uduns's'iyaa wudii wontti kaatiyaappe, Aa oosanchchatuwaappenne Aa asaappe kichchanawaa. Shin Med'inaa Godaw yarshshanaw asaa yeddennan is's'anaw kaatii nuuna zaari c'immenna mala akeeko» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Hewaappe guyyiyaan Muse kaatiyaa mataappe kesiide, Med'inaa Godaa woosseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Med'inaa Goday Muse oochcheeddawaadan ootseedda; uduns's'iyaa kaatiyaappe, Aa oosanchchatuwaappenne Aa asaappe ittuunne attenan kichcheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Shin ha\"ikka k'ay kaatiyaa wozanay donc'c'ilina, asaa yeddennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Med'inaa Goday Musa hawaadan yaageedda; «Gibs'e kaatiyaakko baade, ‹Med'inaa Goday, Ibraawetuwaa S'oossay neena, «Unttunttu taw goynnana mala ta asaa yedda» yaagee. ");
INSERT INTO dwrl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Neeni yeddennan is's'aade, unttuntta oyk'k'a uttiyaawaa gidooppe, ");
INSERT INTO dwrl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Med'inaa Godaa kushii deriyaan de'iyaa ne mehiyaa bolla, paratuwaa bolla, haretuwaa bolla, gaalotuwaa bolla, miyaa bolla, dorssatuwaa bollanne deeshshatuwaa bolla wolk'k'aama iita harggiyaa yeddana. ");
INSERT INTO dwrl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Shin Taani Med'inaa Goday Israa'eeliyaa mehiyaa gidduwaaninne Gibs'etuwaa mehiyaa gidduwaan shaakotaa med'd'ana. Israa'eelatuu mehiyaappe ittuunne hayk'k'enna› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Med'inaa Goday wodiyaa keeriide, «Taani wontti hawaa ha gadiyaa bollan ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Wonttetsa gallassi Med'inaa Goday hewaa ootseedda. Gibs'e asaa mehiyaa ubbay hayk'k'eedda; shin Israa'eeliyaa asaa mehiyaappe ittuunne hayk'k'ibeenna. ");
INSERT INTO dwrl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kaatii ha yewuwaa paac'c'anaw asaa kiittiide, Israa'eeletuwaa mehiyaappe, haray atto, ittuunne hayk'k'ibeennawaa ereedda. Gidooppenne kaatiyaa wozanay donc'c'ilo sa'aappe simmenaan is's'ina, asaa yeddennan diggeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Meed'inaa Goday hewaappe guyyiyaan, Musanne Aaroona, «Hinttenttu kushiyaa kuntsiidde c'ooc'iyaappe bidintsaa uuc'c'ite; Muse kaatii s'eellishin, hewaa pude c'arkkoo laalo; ");
INSERT INTO dwrl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","hewe Gibs'e biittaa ubbaa bolla liik'o baana gidanawaa; Gibs'e biittaa ubbaan asaa bollanne mehiyaa bolla giiyyiyaa s'iibbay wod'd'anawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Unttunttu c'ooc'iyaappe bidintsaa akkiide, kaatiyaa sintsan ek'k'eeddinno; Muse hewaa pude c'arkkuwaan laalina, asaa bollanne mehiyaa bolla giiyiyaa s'iibbay wod'd'i aggeeda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Shareechchatuukka unttunttu bollanne Gibs'e asaa ubbaa bolla wod'd'eedda s'iibbay essuwaa diggina, Muse sintsan ek'k'anaw danddayibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Shin Med'inaa Goday Musew geeddawaadankka, kaatiyaa wozana donc'c'iliseedda diraw, Musenne Aaroone odiyaawaa kaatii sisennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Hewaappe guyyiyaan Med'inaa Goday Musa, «Guuran dendda baade, kaatiyaanna gakettaade Aa, ‹Med'inaa Goday, Ibraawetuwaa S'oossay neena, «Taw goynnana mala ta asaa yedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Hewe d'ayooppe, ne bolla, ne oosanchchatuwaa bollanne ne asaa bolla ta boshaw de'iyaa kumentsaa wolk'k'aa taani kiittana; sa'aan ubbaan ta mali baynnawaa neeni hewaan eranaassa. ");
INSERT INTO dwrl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Taani hannoode ta kushiyaa yeddaade, neenanne ne asaa iita harggiyaan ha sa'aa bollappe mils's'i udanashin. ");
INSERT INTO dwrl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Taani neena ta wolk'k'aa bessanawunne ta suntsay sa'aa ubbaa bollan odettanaw, hewoo taani neena kaate ootsaade wotsaad. ");
INSERT INTO dwrl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Neeni ha\"ikka otorettaade, ta asaa yeddennan is's'aadda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Hewaa diraw, taani wontti hannoode Gibs'e Gibs'e gidoodeppe hachche gakkanaw ubbakka wod'd'i erenna, darii wolk'k'aama shachchaa bukissana. ");
INSERT INTO dwrl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ha\"i neeni ne mehiyaanne gaden new de'iyaawaa ubbaa ellekka soo gelissanaadan azaza; ayaw gooppe, soy gelenaan biro gaden de'iyaa asaa ubbaa bollanne mehiyaa ubbaa bolla shachchay wod'd'anawaa; Unttuttu hayk'k'ana» yaagee› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kaatiyaa oosanchchatuwaappe Med'inaa Godaa k'aalaw yayyeeddawanttu barenttu ayiletuwaanne barenttu mehiyaa elleelliidde soy geliseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Shin Med'inaa Godaa k'aalaa kad'eeddawanttu barenttu ayiletuwaanne barenttu mehiyaa gaden aggi basheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Hewaappe guyyiyaan Med'inaa Goday Musa, «Gibs'e biittaa ubbaa bollan: asaa bolla, mehiyaa bollanne Gibs'e goshshatuwaan dic'c'iyaabaa ubbaa bolla shachchay wod'd'anaadan, ne kushiyaa saluwaa dentsa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Muse bare gatimaa saluwaa zaariide dentseedda wode, S'oossay guguntsaanne shachchaa yeddeedda; walk'k'antsaykka duge sa'aw walk'k'ammeedda. S'oossay Gibs'e gadiyaan shachchaa yaati bukisseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Shachchay wod'd'eedda; walk'k'antsay yaanne haanne walk'k'ammeedda; Gibs'e gadiyaan kaatii kaatetoodeppe doommina, Gibs'e biittaa ubbaan wod'd'eedda shachchaa ubbaappe hewe aad'd'iyaa iita shachchaa. ");
INSERT INTO dwrl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","He shachchay Gibs'e biittaa ubbaa gaden de'iyaa ubbabaa, asaakka mehiyaakka shoc'eedda; gaden doleeddabaa ubbaa duge zaariide bidoyeedda; mitsaa ubbaa mentsereetseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Shachchay wod'd'ibeenna gadii Israa'eelatuu utteedda Goshena gadiyaa s'alala. ");
INSERT INTO dwrl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kaatii kiitti Musanne Aaroona s'eesissiide, «Ha\"i simmi, taani nagaraa ootsaad; Med'inaa Goday tumanchchaa; taaninne ta Asay bayzzanchcha. ");
INSERT INTO dwrl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Nuw guuguntsaynne shachchay dareedda diraw, Med'inaa Godaa woossite. Taani hinttentta yeddana; simmi hawaappe sintsan hinttenttu hawaan gam\"ikkita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Muse Aa, «Taani ha katamaappe keseedda wode, taani woossanaw ta kushiyaa Med'inaa Godaakko mic'c'ana; yaatooppe guuguntsay agganawaa; k'ay shachchaa wod'etsay ek'k'ana; sa'ay Med'inaa Godaawaa gidiyaawaa neeni hewaan erana. ");
INSERT INTO dwrl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Shin neeninne ne oosanchchatuu Med'inaa Godaw S'oossaw ha\"ikka yayyenawaa taani eray» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Talbbay c'iisheedda dirawunne banggay tisheedda diraw, talbbaynne banggay shachchan bayeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Shin zarggaynne k'ambbaray ka\"iyaa wodii bira gideedda diraw, shachchan bayibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Hewaappe guyyiyaan Muse kaatiyaa mataappe denddiide, katamaappe gas'aa kesseedda. Bare kushiyaa Med'inaa Godaakko mic'c'eedda; yaatina guguntsaynne shachchay aggeedda; iraykka biittaa bollan duge tigettiyaawe ek'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Shin kaatii iray, shachchaynne guguntsay aggeedawaa be'eedda wode zaariiddekka nagaraa ootseedda; ikka Aa oosanchchatuukka barenttu wozanaa donc'c'ilisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Med'inaa Goday Muse doonaan haasayeeddawaadankka kaatiyaa wozanay donc'c'ilina, Israa'eelatuwaa I yeddennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","2","Hewaappe guyyiyaan Musa Med'inaa Goday hawaadan yaageedda; «Gibs'e kaatiyaakko ba; ayaw gooppe, taani Gibs'etuwaa gidon mallaanne wolk'k'aama malaataa ta woota ootseeddentto hinttenttu hinttenttu naanawunne hinttenttu naanaa naanaatoo odana mala, k'ay hinttenttukka Taani Med'inaa Godaa gidiyaawaa erana mala, ta wolk'k'aama malaataa unttunttu giddon ootsanaw Aa wozanaanne Aa oosanchchatuwaa wozanaa taani donc'c'ilissa wotsaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musenne Aaroone kaatiyaakko geliide Aa, «Med'inaa Goday, Ibraawetuwaa S'oossay neena hawaadan yaagee; ‹Neeni taw azazettenan awude gakkanaw is's'ay? Taw goynnana mala ta asaa yedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Neeni unttuntta yeddennan is's'ooppe, ne biittaa bolla Taani wontti booliyaa ahana; ");
INSERT INTO dwrl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","boolii ooninne biittaa demmanaw danddayennaadan biittaa kammanawaa. Hinttenttoo shachchaappe atteeda guutsabaa, gaden dic'c'iyaa mitsaykka attenaan ubbaa maanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ne gollen ne suntsatuwaa golleninne Gibs'e asaa ubbaa gollen unttunttu kumanawantta; hewe ne aawotuwaa, woy ne mayza aawotuu ha biittaan uttoodeppe hanno gakkanaw mule be'ibeenabaa› yaagee» yaageeddino. Hewaappe guyyiyaan Muse kaatiyaa sintsaappe kesiide beedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Kaatiyaa suntsatuu kaatiyaa, «Ha bitanii nuw awude gakkanaw metuwaa gaaso gidanawe? Unttunttu Med'inaa Godaw, barenttu S'oossaw, goynnana mala, neeni asaa yedda; Gibs'e biittay bayeeddawaa neeni ha\"ikka akeekikkii?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Hewaa diraw, kaatii Musanne Aaroona guyye zaariide, «Biite; Med'inaa Godaw, hinttenttu S'oossaw goynnite; shin biyaawanttu oona oonee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Muse, «Nuuni nu c'ima asaanne nu guutsaa naanatuwaanna, nu dorssaa wudetuwaannanne miizzaa wudetuwaanna ittippe baana; ayaw gooppe, nuuni biyaasan Med'inaa Godaa baalaa bonchchanaw koshshee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kaatii, «Taani hinttentta hinttenttu naanaanne hinttenttu machchetuwaa yeddiyaawaa gidooppe, Med'inaa Goday hinttentta naaganaw koshshee. Shin be'ite; hinttenttu hinttenttu wozanaan iitabaa k'oppeeddawe k'onc'c'iyaan erettee. ");
INSERT INTO dwrl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Tuytti, hinttenttu, ‹S'oossaw goynnana› giide oochchiyaawaa gidooppe, attuma asaa s'alaalay biide Med'inaa Godaw goynnite» yaageedda. Hewaappe guyyiyaan Musenne Aaroone kaatiyaa sintsaappe yederssetiide kesseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Med'inaa Goday Musa, «Boolii Gibs'e gadiyaan kesanaadan, shachchaappe attiide gaden dic'c'iyaabaa ubbaa lim\"i ootsana mala, ne kushiyaa Gibs'e gadiyaa bollan mic'c'a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Muse bare gatimaa Gibs'e gadiyaa bollan mic'c'ina, Med'inaa Goday away doliyaa bagga c'arkkuwaa he gallassanne k'amma ubbaa he gadiyaa bollan c'arkkisseedda; wontteedda wode he c'arkkuu booliyaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Boolii Gibs'e biittaa ubbaa bolla sham\"i giide, biittaa ubba saan kessi utteedda. Hawaa keeshshaa booliyaa boshay he biittaan hawaappe kasenna hanibeenna; woy hawaappe sintsawunne zaaretsiide hanenna. ");
INSERT INTO dwrl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Biittay kares's'ana gakkanaw boolii biittaa ubbaa kammeedda. He boolii shachchaappe attiide gaden dic'c'iyaabaa ubbaanne mitsaa bollan de'iyaa ayfiyaa ubbaa mils's'i ootseedda. Yaatina mitsaa bollan irs's'a haytsay, woy gaden ataakilttii Gibs'e biittaa ubbaan ayaynne attibeena. ");
INSERT INTO dwrl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kaatii Musanne Aaroona ellekka s'eesissiide, «Med'inaa Godaa hinttenttu S'oossanne hinttentta taani naak'k'aad; ");
INSERT INTO dwrl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","simmi hinttenttu taw ta nagaraa ha itti gede s'alalaw atto giite; ha wod'd'iyaa boshaa taappe diggana mala, Med'inaa Godaa hinttenttu S'oossaa woossite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Muse kaatiyaa mataappe kesiide, Med'inaa Godaa woossina; ");
INSERT INTO dwrl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Med'inaa Goday he c'arkkuwaa away wulliyaa bagga wolk'k'aama c'arkkoo laammina booliyaa tookki, Zo'o Abbaakko afeedda. Gibs'e biittaa ubbaan itti booliinne attibeena. ");
INSERT INTO dwrl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Gidooppenne, Med'inaa Goday kaatiyaa wozanaa donc'c'iliseedda diraw, Israa'eelatuwaa yeddennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Med'inaa Goday Musa, «Gibs'e gadiyaan Asay bochchi be'anaw danddayiyaa keeshshaa d'umay d'umana mala, ne kushiyaa saluwaa dentsa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Muse bare kushiyaa saluwaa dentseedda; Gibs'e biittaa ubbaan heezzu gallassaa kumentsaa bara d'umay d'umeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","He heezzu gallassatuwaan Asay ooninne ittuu ittuwaa be'ennaan, woy bare sa'aappe denddiide beennan takkeedda. Shin Israa'eeletuu de'iyaa sa'aan ubbaan unttunttoo poo'uu de'ee. ");
INSERT INTO dwrl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kaatii Musa s'eesissiide, «Biite; Med'inaa Godaw goynnite; hinttenttu machchetuukka hinttenttu naanaykka hinttenana baanaw danddayiino. Hinttenttu dorssaa wudiyaanne hinttenttu miizzaa wudiyaa s'alalaa yeggiide biite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Shin Muse Aa, «Nuuni yarshshuwaanne s'uuggiide yarshshiyaa yarshshuwaa Med'inaa Godaa, nu S'oossaw, shiishshanaw, mehiyaa nuw immaade yeddiyaawe neena guussakka? ");
INSERT INTO dwrl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nu mehii ubbaykka nuunana baanaw koshshee; k'inc'c'aafile ittuunne guyye attena. Med'inaa Godaa, nu S'oossaw, goynniyaa goynnaw he mehiyaappe dooriide akkanaw koshshee; nuuni yaa gakkennaan de'iidde, mehiyaappe hak'awaa hak'awaa Med'inaa Godaw yarshshanentto eranaw danddayokko» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Shin Med'inaa Goday kaatiyaa wozanaa donc'c'ilissina I unttuntta yeddanaw koyibeenna. ");
INSERT INTO dwrl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Hewaappe guyyiyaan kaatii Musa, «Ta mataappe kichcha! Laa\"entso ta sintsan lem\"i gaade neena era! Neeni ta ayfiyaa ta deemuwaa be'eedda gallassaykka new hayk'k'o» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Muse Aa, «Tumakka; neeni geeddawaadan taani neena laa\"entso ubbakka be'ikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Musew Med'inaa Goday, «Taani Gibs'e kaatiyaa bollanne Aa asaa bolla itti hara boshaa yeddana; hewaappe guyyiyaan I hinttentta ha gadiyaappe kessi yeddanawaa; I hinttentta ittuunne attenaan ubbaakka yederssanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Israa'eeliyaa asay, mac'c'awe attumawe bare shoorotuwaappe biraappenne work'k'aappe med'etteedda miishshatuwaa oochchana mala, unttunttoo oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Med'inaa Goday Israa'eeliyaa asatuu Gibs'etuwaa sintsan nashshettanaadan ootseedda. K'ay Muse bare huup'iyawukka Gibs'e gadiyaan kaatiyaa oosanchchatuwaaninne asan loytsi daro bonchchetteedda asaadan s'eeletteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Muse kaatiyaa hawaadan yaageedda; «Med'inaa Goday hawaadan yaagee; ‹K'amma giddo bilahiyaan taani Gibs'e gidduwaana aad'ana; ");
INSERT INTO dwrl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Gibs'e gadiyaan de'iyaa bayira attuma naanay ubbay, kawutetsaa oydiyaan uttiyaa kaatiyaa bayira na'aappe doommiide, wos'an gaac'c'iyaa k'oomati bayira na'aa gakkanaw bayira yeletteedda mehiikka attenan ubbay hayk'k'anawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Gibs'e biittaa ubbaan hawaappe kase baggan hanibeennanne sintsappekka hanenna wolk'k'aama yeekuu yeekettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Shin Israa'eelatuu gidduwaan, asaa bolla woy mehiyaa bolla kanaynne boc'c'enna› yaagee. He wode Med'inaa Goday Gibs'etuwaaninne Israa'eeliyaa gidduwaan shaakotaa med'd'iyaawaa neeni eranaassa. ");
INSERT INTO dwrl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ha ne oosanchchatuu ubbay taakko yiide, ta sintsan guufanni goynniide, ‹kesaade baarikkii! Neena kaalliyaa Asay ubbaykka bo!› gaanawantta. Hewaappe guyyiyaan taani baana» yaageedda. Hewaappe guyyiyaan Muse hank'k'uwaan ees's'etiidde, kaatiyaa sintsaappe kesiide beedda. ");
INSERT INTO dwrl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Musew Med'inaa Goday koyro, «Ta malalissiyaa malaatay Gibs'e gadiyaan darana mala, kaatii hinttenttu odiyaawaa sisennan is's'anawaa» yaagi wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musenne Aaroone ha malalissiyaa malaataa ubbaa kaatiyaa sintsan ootseeddino; shin Med'inaa Goday kaatiyaa wozanaa donc'c'ilisseedda; yaatina I Israa'eelatuwaa bare gadiyaappe yeddennan is's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Med'inaa Goday Gibs'e gadiyaan Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Ha aginay hinttenttoo laytsaw koyro aggina gido; ");
INSERT INTO dwrl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Israa'eeliyaa asaw ubbaw hawaa odite; ha aginay geleedda tammantsa gallassan, itti Asay bare soy asaw itti koliyaa dorssaa woy itti koliyaa deeshshaa aho. ");
INSERT INTO dwrl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","He golle asaa paydu he dorssaa wurssi maanaw guus's'ooppe, inne aw ubbaappe matattiyaa shooruu barenttu soo asaa paydiide itti itti Asay maanaw danddayiyaa keeshshaa akeekiide, he mehiyaa shukkiide ittippe miino. ");
INSERT INTO dwrl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Hinttenttu doori akkiyaa mehii yelettoodeppe itti laytsaa giddeeddawaa, Aa bollan ay pac'aynne baynna attumawaa gido. Hinttenttu dorssaappe woy deeshshaappe akkanaw danddayiita. ");
INSERT INTO dwrl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ha aginaw tammanne oyddentso gallassaa gakkanaw unttuntta heemmite; he gallassi omarssi Israa'eeliyaa Asay ubbay unttuntta shukkanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Yaatiide suutsaappe amareedawaa akkiide, unttunttu miyaa gollew laa\"u mak'aaniyaanne gubaniyaa okkino; ");
INSERT INTO dwrl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ashuwaa he gallassi k'amma taman s'iis's'i s'iis's'iide, c'ammiyaa bonc'c'iyaananne uukkeedda ukitsaanna miino. ");
INSERT INTO dwrl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ashuwaa k'ayiyaa woy doyssiide mooppite; huup'iyaakka gedetuwaakka k'antsaa giddo ashuwaakka ubbaa k'ans's'ennan muumiyaa s'iis's'ite; ");
INSERT INTO dwrl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","he ashuwaappe sa'ay wonttana gakkanaw ayinne ashshoppite; shin amareedawe attooppe, hewaa s'uugganaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Muussaa miidde, ogiyaw giigiyaa mayuwaa mayyiide, hinttenttu c'aammaa hinttenttu gediyaan wotsiide, hinttenttu gatimaa hinttenttu kushiyaan oyk'k'iide miita. Elleelli elleelli miite; hawe Med'inaa Godaa Paasigaa. ");
INSERT INTO dwrl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«Taani he gallassi k'amaana Gibs'en aad'aadde bayira yeletteedda ubbaa, asaakka, mehiyaakka wod'ana; Gibs'e eek'atuwaa ubbaa bollakka taani pirddana; Taani Med'inaa Godaattee. ");
INSERT INTO dwrl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","He suutsay hinttenttu de'iyaa golliyaa erissiyaa mallaa gidanawaa. Taani he suutsaa be'o wode, hinttentta aggaade aad'd'ana; taani Gibs'e gadiyaa boshaan shoc'iyaa wode, hinttentta ay boshaykka bochchenna. ");
INSERT INTO dwrl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«Ha gallassay hinttenttoo k'oppi k'oppi bonchchiyaa gallassaa gido; hinttenttu yeletay ubbay Med'inaa Godaa baalaa bonchchite; hawaa woga ootsiide ubbaa wode bonchchite. ");
INSERT INTO dwrl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«Laappun gallassay gakkanaw irshshuwaa yeggibeenna ukitsaa miite; shin koyro gallassi irshshuwaa hinttenttu sooppe diggite. He koyro gallassaappe doommiide laappuntsaa gallassi gakkanaw, irshshuwaana de'iyaa ukitsaa miyaa Asay Israa'eeliyaa asaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Koyro gallassi geeshsha shiik'uwaa shiik'ite; hara geeshsha shiik'uwaa k'ay laappuntsa gallassan shiik'ite; Asay maanaw k'umaa katsanawaappe attina, ha gallassaa ubbaan ayinne ootsoppite; hinttenttu ootsanabay hewaa s'alala. ");
INSERT INTO dwrl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Irshshuu gelibeenna Ukitsaa Baalaa bonchchite; ayaw gooppe, taani hinttenttu c'uguwaa Gibs'e gadiyaappe kesseeddawe he gallassaana. He gallassaa, yeletaappe yeletay gakkanaw pini kesiyaa wogaa ootsiide bonchchite. ");
INSERT INTO dwrl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Koyro aginaan, he aginaw tammanne oyddentso gallassaa omarssaappe doommiide, laatamanne ittentsuwaa omarssi gakkanaw irshshuu gelibeenna ukitsaa miite. ");
INSERT INTO dwrl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Laappun gallassay gakkanaw irshshuu hinttenttu son beettoppo; irshshuu geleeddawaa miyaa Asay bete giddina woy he biittaa asaa giddina, Israa'eeliyaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Irshshuu geleeddawaa ayaanne mooppite; hinttenttu de'iyaa sa'aan hak'ankka irshshuu gelibeenna ukitsaa maanaw koshshee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Hewaappe guyyiyaan Muse Israa'eeliyaa c'imatuwaa ubbaa s'eesissiide unttuntta hawaadan yaageedda; «Hinttenttu ellekka biide, hinttenttu soo asaw Paasigaw koliyaa, dorssaa woy deeshshaa shukkite. ");
INSERT INTO dwrl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Hisoop'p'iyaa geetettiyaa haytsaappe dankki akkiide, keriyaan de'iyaa suutsan naak'k'i kessiide, he suutsaa laa\"u mak'aaniyaaninne gubaniyaa okkite; hinttenttuppe itti asaynne sa'ay wonttana gakkanaw bare golliyaa penggiyaappe kare kesoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Med'inaa Goday Gibs'etuwaa shoc'i wod'anaw he biittaana aad'd'iyaa wode, suutsaa gubaniyaaninne laa\"u mak'aaniyaan be'ana; yaatiide karenna aad'd'ana; wod'iyaawe hinttenttu soo geliide, hinttentta wod'enaadan Aa hinttenttu soo gelissenna. ");
INSERT INTO dwrl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«Hinttenttu ha azazuwaa hinttenttoonne hinttenttu zeretsaw ubbaa wode woga ootsiide azazettite. ");
INSERT INTO dwrl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Med'inaa Goday kase immana geeddawaadan I immiyaa biittaa hinttenttu geliyaa wode, ha wogaa naagite. ");
INSERT INTO dwrl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Hinttenttu naanay hinttentta, ‹Ha bonchcho baalaa birshshetsay ayee?› yaagiide oochchiyaa wode, ");
INSERT INTO dwrl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","hinttenttu unttuntta, ‹Hawe S'oossaa bonchchanaw yarshshiyaa Paasigaa yarshshuwaa; ayaw gooppe, Med'inaa Goday Gibs'e gadiyaan Israa'eeliyaa asaa golliyaa aggi aad'd'i biide, Gibs'etuwaa wod'iide, nuuna ashsheeda diraassa› yaagite» yaageedda. Hewaappe guyyiyaan Asay gulbbatiide goynneedda. ");
INSERT INTO dwrl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Israa'eelatuu Med'inaa Goday Musanne Aaroona azazeeddawaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","K'amma giddo bilahiyaan Med'inaa Goday Gibs'en bayira yeletteedda ubbaa, kawutetsaa oydiyaan utteedda kaatiyaa bayira na'aappe doommiide, k'asho gollen de'iyaa omoodetteeddawanttu bayira na'aa gakkanaw, k'ay bayira yeletteedda mehiyaa ubbaa dippi ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Kaatii, Aa oosanchchatuu ubbaynne Gibs'e gadiyaa Asay ubbay k'amma denddeeddino. Gibs'e gadiyaan Asay hayk'k'ibeenna Gollii ubbakka baynna diraw, Asay kooshshaa d'ok'k'u ootsiide wolk'k'aama yeekuwaa yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","He gallassi k'amma kaatii Musanne Aaroona s'eesiide, «Denddite! Hinttekka Israa'eeliyaa asaykka ta asaa gidduwaappe kesi biide hinttenttu oochcheeddawaadankka Med'inaa Godaw goynnite! ");
INSERT INTO dwrl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Hinttenttu geeddawaadankka hinttenttu dorssaa wudiyaanne hinttenttu mehiyaa wudiyaa akkiide biite! K'ay tawukka woosite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Gibs'e Asay Israa'eelatuu gadiyaappe ellekka kesana mala dirbbiseeddino. Ayaw gooppe, unttunttu, «Hewe d'ayooppe, nuuni ubbaykka wureetto» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hewaa diraw, Israa'eeliyaa asatuu barenttu irshshuu gelibeenna munak'aa keriyaan kuntsiidde, barenttu mayuwaan s'aas'iide, hashiyaan tookeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israa'eeletuu Muse unttuntta azazeeddawaadan, Gibs'etuwaa biraa miishshatuwaa, work'k'aa miishshatuwaanne mayuwaa, «Immite» giide oochcheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Med'inaa Goday Gibs'etuwaa sintsan he Asay sabettanaadan ootsina, Gibs'etuu unttunttu oochcheeddawaa immeeddino. Hewaadan yaatiide unttunttu Gibs'e asatuwaa mas'uwaa bonk'k'i akkiide beeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israa'eelatuu Raamisa geetettiyaa katamaappe denddiide Sukkoota geetettiyaa sa'aa gediyaan hametiidde beeddino. Aasi naanaanne mac'c'awantta gujjennan paydina, usuppun s'eetu sha\"a. ");
INSERT INTO dwrl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","K'ay unttunttunna hara daro asay, daro mehiinne dorssaa deeshshaa wudii laagettiide beedda. ");
INSERT INTO dwrl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Gibs'eppe unttunttu akkiide keseedda munak'aa irshshuu gelibeenna ukitsaa uukkeeddino; ayaw gooppe, unttunttu Gibs'eppe dirbban keseeddino; barenttoo shink'k'aa katsanawukka, munak'k'ay denddina uukkanawukka unttuntta gatsibeenna. ");
INSERT INTO dwrl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israa'eelatuu Gibs'e gadiyaan de'eedda laytsay oyddu s'eetanne hattama. ");
INSERT INTO dwrl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","He oyddu s'eetanne hattamu laytsay wuriyaa he wurssetsa gallassan, Med'inaa Godaa c'uguu ubbay Gibs'e gadiyaappe keseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Med'inaa Goday bare asaa naagiide, Gibs'e gadiyaappe kesiyaa wode sa'ay k'amma; he k'ammay yeletaappe yeletaa gakkanaw, Israa'eeliyaa Asay beegottiide naagiidde ak'iyaa, Med'inaa Godaw dummateedda k'amma. ");
INSERT INTO dwrl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Med'inaa Goday Musanne Aaroona, «Paasigaa gallassaa bonchchiyaa wogay hawaa; bete Asay aappe ubbakka mooppo. ");
INSERT INTO dwrl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Hinttenttu shaluwaan shammeedda ayilii hinttenttu Aa k'as's'arowaappe guyyiyaan aappe mo. ");
INSERT INTO dwrl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Shin imatsatetsaan hinttenana gam\"iyaa imatsaynne keraa ootsiyaa imatsay aappe ubbakka mooppo. ");
INSERT INTO dwrl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","«Ha Paasigaa hinttenttu itti gollen miite; hinttenttu he ashuwaappe ayaanne kare kessoppite. Mek'etsatuwaappe ittuwaanne mentsoppite. ");
INSERT INTO dwrl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israa'eeliyaa maabaray ubbay Paasigaa bonchchanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","«Betii yiide hinttenttu giddon de'iyaa Asay Med'inaa Godaa Paasigaa bonchchanaw koyooppe, koyro he attuma Asay ubbay k'as's'aretto. Hewaappe guyyiyaan I he biittaan yeletteedda asaadan shiik'iide, Paasigaa bonchchanaw danddayee. Shin k'as's'arettibeenna Asay ubbakka aappe mooppo. ");
INSERT INTO dwrl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Hinttenttu biittaan yeletteeddawookka hinttenttu giddon bete gidiide de'iyaawawukka he wogay ittuwaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Israa'eelatuu ubbay Med'inaa Goday Musanne Aaroona azazeeddawaadankka ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","He gallassikka Med'inaa Goday Israa'eelatuwaa unttunttu c'uguwaan c'uguwaan Gibs'e gadiyaappe kesseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Bayira yeletteedda attumawaa ubbaa taw dummaya. Israa'eeliyaa asaa giddon uluwaappe yeletteedda bayira ubbay, mehiyaa giddina asaa giddina, ubbaykka tawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Hewaappe guyyiyaan Muse asaa, «Gibs'eppe, ayiletetsaa gadiyaappe hinttenttu kesseedda gallassaa, ha gallassaa hassayite; ayaw gooppe, Med'inaa Goday bare wolk'k'aama kushiyaan hinttentta kesseedda; hewaa diraw, irshshuu geleeddawaa ubbakka mooppite. ");
INSERT INTO dwrl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hinttenttu hachche, laytsaw koyro gideedda Abiiba aginaan kesiita. ");
INSERT INTO dwrl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Med'inaa Goday Kanaanetuwaa, Hiitetuwaa, Amoorawaanatuwaa, Hiiwetuwaanne Yaabuusawaanatuwaa gadiyaa hinttentta gatsiyaa wode, hinttenttu ha paasigaa ha aginaan bonchchiita. He biittay S'oossay hinttew immana mala, kase hinttenttu aawaatoo c'aak'k'i wotseedda biittaa. He biittay maatsaynne eessay goggiyaa biittaa. ");
INSERT INTO dwrl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Hinttenttu laappun gallassay gakkanaw irshshuu yegettibeenna ukitsaa maanitta; laappuntsa gallassay Med'inaa Godaa baalaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","He laappun gallassatuwaan irshshuu yegettibeenna ukitsaa hinttenttu maana; hinttenttu giddon irshshuwaana de'iyaabay ayaynne beettoppo; ne biittaa zawaan hak'aninne irshshuu beettoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","«He gallassi neeni ne na'aw, ‹Taani hawaa ootsiyaawe, taani Gibs'eppe kesiyaa wode, Med'inaa Goday taw ootseeddawaa hassayanaassa› yaagaade oda. ");
INSERT INTO dwrl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Med'inaa Goday hinttentta bare wolk'k'aama kushiyaan Gibs'eppe kesseedda diraw, Med'inaa Godaa wogay hinttenttu doonaappe wod'd'enaadan, ha bonchchettiyaa gallassay ne kushiyaan k'achcheeddanne ne deemuwaan wotseedda hassayissiyaawaa mala gidana. ");
INSERT INTO dwrl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Hewaa diraw, hinttenttu ha wogaa laytsan laytsan Aa wodiyaan bonchchite. ");
INSERT INTO dwrl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Med'inaa Goday hinttenttunne hinttenttu mayza aawaatoo immanaw c'aak'k'eeddawaadan, I hinttentta Kanaanetuwaa gadiyaa gelissiide, he gadiyaa hinttenttoo immiyaa wode, ");
INSERT INTO dwrl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","uluwaappe bayira yeletteedda ubbaa Med'inaa Godaw dummaya; ne miizaa bayiraa yelettiyaa attumawaa ubbay Med'inaa Godaawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Bayira yelettiyaa hariyaa ubbaa dorssaa maraan woza akka. Wozennawaa gidooppe, Aa morggiyaa mentsa; ne attuma naanaa giddon bayira yeletteeddawantta ubbaa woza. ");
INSERT INTO dwrl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Sintsanna yaana wodiyaan ne na'ay neena, ‹Hawe ayee?› yaagiide oochchooppe, neeni Aa, ‹Med'inaa Goday nuuna wolk'k'aama kushiyaan Gibs'eppe, ayiletetsaa gadiyaappe kesseedda; ");
INSERT INTO dwrl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Gibs'e kaatii donc'c'iliide nuuna yeddennan is's'ina, Med'inaa Goday Gibs'e gadiyaan de'iyaa bayiraa ubbaa, asaappe doommiide mehiyaa bayiraa gakkanaw wod'eedda. Taani aati uluwaappe koyro yeletteedda attumawaa ubbaa Med'inaa Godaw yarshshiyaawenne ta bayira attuma naanaa taani woziyaawe hewaassa› yaaga. ");
INSERT INTO dwrl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Med'inaa Goday nuuna bare wolk'k'aama kushiyaan Gibs'eppe kesseeddawoo, hawe hinttenttoo kushiyaan k'achcheeddanne deemuwaan wotseedda mallaa mala gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kaatii asaa yeddeedda wode, S'oossay unttuntta Piliss's'eema biittaana aatsiyaa ogii mata gidooppenne he ogiyaanna kaaletsibeenna; ayaw gooppe, S'oossay, «Aasi olaa be'ooppe, bare k'ofaa laammiide, guyye Gibs'e simmenaadan» yaagiide k'oppeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Hewaa diraw, S'oossay asaa mela biittaa ogiyaanna yuushshiide, Zo'o Abbaakko kaaletseedda. Israa'eeletuu Gibs'e gadiyaappe olaw giigiide pude keseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Yooseefo Israa'eeliyaa asaa c'aak'k'etsi wotseedda diraw, Muse Aa mek'etsaa barenana akkiide beedda; Yooseefo unttuntta, «S'oossay tumuppe hinttentta maaddanaw yaanawaa; he wode hinttenttu ta mek'etsaa ha sa'aappe pude hinttenana akkiide biite» yaagiide odi wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Unttunttu Sukkooteppe denddiide mela biittaa doonaan de'iyaa Etaaman utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Med'inaa Goday unttunttu gallassinne k'amma hamettana mala, gallassan unttuntta ogiyaa bessanaw shaariyaa tuussaan, k'amman unttunttoo poo'issana mala tamaa tuussaan unttuntta kaaletseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gallassi shaariyaa tuussay woy k'amma tamaa tuussay asaa sintsaappe kichchibeenna. ");
INSERT INTO dwrl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Hewaappe guyyiyaan Musa Med'inaa Goday; «Unttunttu guyye simmiide Migidoolappenne abbaappe gidduwaan, Pihaahiroota matan uttanaadan oda; unttunttu abbaa lank'k'iyaan Ba'aali-S'afoona sintsa mela biittaan uttino yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Kaatii, ‹Israa'eelatuu mela biittay gorddina, haniyaabaa d'ayiide biittaan c'oo toyilakattiino› yaagiide k'oppanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Taani kaatiyaa wozanaa donc'c'ilisanna; I unttuntta yederssana; taani kaatiyaaninne Aa olanchchatuwaa ubbaan bonchchettana; Gibs'etuukka taani Med'inaa Godaa gidiyaawaa erana» yaageedda. Israa'eelatuu I odeeddawaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Aasi bak'ati diggeeddawaa Gibs'e kaatiyaw odina, inne Aa suntsatuu Israa'eelatoo k'oppeedda barenttu k'ofaa laammiide, «Nuuni hawaa waateettoo? Nuuni Israa'eelatuwaa yeddiide, unttunttu nuw ootsiyaa wolk'k'aappe mela atteedo» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Hewaa diraw, I bare paraa gaariyaa kooriide, bare olanchchatuwaa barenana akkiide denddeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","I usuppun s'eetu dooreteedda paraa gaaretuwaa, Gibs'e gadiyaan de'iyaa hara gaaretuwaa ubbaanna, unttunttu ubbaw kaappuwaa kaappuwaa suntsiide akkiide beedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Med'inaa Goday Gibs'e gade kaatiyaa wozanaa d'ullissina, S'oossaa wolk'k'aan kessaa bolla de'iyaa Israa'eeliyaa asaa yedersseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Hewaappe guyyiyaan Gibs'e asatuu, kaatiyaa paratuu ubbaynne paraa gaaretuu, paraa asatuunne olanchchatuu Israa'eelatuwaa kaaliide yedersseeddino. Abbaa doonaan Ba'aali-S'afoona sintsa bazzuwaan de'iyaa Pihaahiroota matan unttunttu utteeddawantta demmeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kaatii mati diggina, Israa'eelatuu d'ok'k'u gi s'eelliyaa wode, Gibs'etuu unttunttu geeduwaa kaalliide yeeddawaa be'eeddino; yaatiide daroppe yayyiide, Med'inaa Godaakko waasseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Unttunttu Musa, «Neeni nuuna Gibs'en duufuu d'ayina mela biittaan hayk'k'anaadan kessaadiiyye? Nuuna Gibs'eppe ayaw ahaad? ");
INSERT INTO dwrl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Gibs'en de'iidde nuuni, ‹Nuuna agga basha; nuuni Gibs'etoo moodetana› yaagiide new odibeykkooyye? Mela biittaan hayk'k'anaappe unttunttoo moodetiyaawe nuw lo\"a shin» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Shin Muse asaa, «Yayyoppite; min ek'k'ite; Med'inaa Goday hachche hinttentta ashshiyaa ashuwaa hinttenttu be'ana. Hachche hinttenttu be'iyaa Gibs'etuwaa laa\"entso ubbakka be'ikkita. ");
INSERT INTO dwrl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Hinttenttu diraw Med'inaa Goday olettanawaa; hinttenttuppe koyettiyaawe c'o\"u guussa s'alala» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Med'inaa Goday Musa, «Neeni taakko ayaw waassay? Israa'eelatuu sintsaw hamettana mala oda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ne s'am\"aa dentsaade abbaa bolla mic'c'a; haatsay laa\"u kesiide shaakettanawaa; Israa'eelatuukka mela biittaana abbaa pinniide baanawantta. ");
INSERT INTO dwrl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Taani Gibs'etuwaa wozanaa donc'c'ilisina, unttunttu hinttenttu geeduwaa kaalliide abbaan gelanawantta. Taani kaatiyaanne Aa olanchchatuwaa ubbaa bollan, Aa paraa gaaretuwaanne Aa paraa asatuwaa bollan bonchchuwaa taw demmana. ");
INSERT INTO dwrl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Taani kaatiyaa bollan, Aa paraa gaaretuwaa bollaaninne Aa paraa asatuwaa bollan taw bonchchuwaa demmeedda wode, taani Med'inaa Godaa gidiyaawaa Gibs'etuu eranawantta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Hewaappe guyyiyaan S'oossaa kiitanchchay, Israa'eeliyaa olanchchatuwaappe sintsanna hamettiyaawe, guyye aad'd'iide unttunttuppe guyyenna hametteedda. Shaariyaa tuussaykka unttunttu sintsaan de'iyaa sa'aappe guyye bagga yuuyyiide, ");
INSERT INTO dwrl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Gibs'etuwaa olanchchatuwaappenne Israa'eeletuwaa olanchchatuwaappe gidduwaan ek'k'eedda. He shaarii k'amma ubbaan itti baggana d'umissiide, hinkko baggana poo'isseedda; yaatina k'amma ubbaa ittuu ittuwaakko shiik'ibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Hewaappe guyyiyaan Muse abbaa bollan bare kushiyaa mic'c'eedda; Med'inaa Goday he gallassi k'ammaa ubbaan away doliyaa baggappe wolk'k'aama c'arkkuwaa yeddiide, abbaa guyye zaariide mela biittaa kesseedda. Haatsay shaakketeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israa'eeletuu abbaa gidduwaana mela biittaan hametiidde, haatsay unttunttoo ushechchannanne haddirssaana godaadan ek'k'ina beeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Gibs'etuu unttuntta yedersseeddino; kaatiyaa paraa ubbatuu, Aa paraa gaaretuunne Aa paraa asatuu unttuntta kaalliide, abbaa giddo geleeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Biro wontta bakkaalii dolanaappe kasetiide, Med'inaa Goday tamaanne shaariyaa tuussaappe duge zaariide, Gibs'etuwaa olanchchatuwaa s'eelleedda; unttunttu wozanaa bayzzeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Laagay unttuntta waayissana mala, Med'inaa Goday unttunttu paraa gaaretuwaa gomaa k'aatsuwaa diggina Gibs'etuu, «Med'inaa Goday unttuntta maaddiide Gibs's'a oliyaa diraw, ane nuuni Israa'eeliyaa asaappe bak'atoytte» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Med'inaa Goday Musa, «Haatsay Gibs'etuwaa bolla, unttunttu paraa gaaretuwaa bollanne unttunttu paraa asatuwaa bolla guyye goggana mala, ne kushiyaa abbaa bollan mic'c'a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Muse bare kushiyaa abbaa bollan mic'c'eedda; sa'ay wonttishin, abbay bare kase sa'aa guyye simmeedda; Gibs'etuu yaa Aa giddo bak'atishin, Med'inaa Goday Gibs'etuwaa abbaa gidduwaan aatsi yeggeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Haatsay guyye simmiide, paraa gaaretuwaa paraa asatuwaana Israa'eelatuwaa kaalliide abbaa geleedda kaatiyaa olanchchatuwaa ubbaa mitti basheedda; unttunttuppe ittuunne attibeena. ");
INSERT INTO dwrl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Shin Israa'eeletuu abbaa gidduwaana mela biittaan hametiide, haatsay unttunttoo ushechchannanne haddirssana godaadan ek'k'ina beeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Med'inaa Goday he gallassi Israa'eeliyaa asaa Gibs'etuwaa kushiyaappe hawaadan ashsheeda. K'ay Israa'eeletuu Gibs'etuu hayk'k'iidde giseeddawantta abbaa doonaan be'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israa'eelatuukka Med'inaa Goday Gibs'etuwaa bolla besseedda wolk'k'aama wolk'k'aa be'eedda wode, Asay Med'inaa Godaw yayyiide aakka Aa k'oomaa Musakka ammaneedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","He wode Musenne Israa'eeliyaa Asay ha yetsaa Med'inaa Godaw yes's'eeddino; «Bonchchuwaan loytsi d'ok'k'u d'ok'k'u geedda diraw, taani Med'inaa Godaw mazimuriyaa yes's'ana. Paranne paraa gaariyaanne toggeeddawantta abbaan oleedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Med'inaa Goday ta wolk'k'aanne ta mazimuriyaa; I taana ashshiyaawaa gideedda. I ta S'oossaa; taani Aa sabbana. I ta aawuwaa S'oossaa; taani Aa d'ok'k'u d'ok'k'u ootsana. ");
INSERT INTO dwrl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Med'inaa Goday ereteedda olanchchaa; Aa suntsaykka Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Gibs'e kaatiyaa paraa gaaretuwaanne Aa olanchchatuwaa abbaan oleedda. Gibs'e kaatiyaa kaappatuu, ubbaappe aad'd'i lo\"iyaawanttu Zo'o Abbaan muuketteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","C'iimmo haatsay unttuntta kammeedda; unttunttu shuchchaadaan c'iimmuwaan mitetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«Abeet Med'inaa Godaw, ne ushechcha kushii wolk'k'an goobeeddawaa; Med'inaa Godaw, ne ushechcha kushii morkkiyaa mentsereetseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ne bonchchuwaa gitatetsaan neenana gaaddateeddawantta olaadda. Ne ees's'iyaa hank'k'uwaa neeni yeddina, I unttuntta dalaadan meedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ne siid'iyaanna kesiyaa shemppuwaan haatsay dooretteedda. Goggiyaa haatsaykka godaadan min ek'k'eedda; c'iimmo haatsay abbaa gomppan irkkiide minneedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","«Morkkii, ‹Taani unttuntta yederssaade oyk'k'ana. Taani unttunttu mas'uwaa shaakkaade, ta koyeeddawaa ubbaa akkana. Taani ta mashshaa shoddaade, unttuntta d'ayissana› yaagiide c'eek'etteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","«Shin Ne peenuwaan punnina, abbay unttuntta kammeedda. Unttunttu wolk'k'aama haatsaan biratay mitettiyaawaadan mitetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Abeet Med'inaa Godaw, s'oossatuwaa giddon ne malay oonee? Geeshshatetsaan bonchchettiyaawe, bonchchuwaan yayettiyaawe, malaliyaabaa ootsiyaawe ne malay oonee? ");
INSERT INTO dwrl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Neeni ne ushechcha kushiyaa mic'c'ina, biittay unttuntta mitteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","«Neeni wozeedda ne asaa aggena ne siik'uwaan kaaletsaadda. Neeni ne wolk'k'an unttuntta neeni de'iyaa geeshsha sa'aa gelissaadda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kawutetsatuu hewaa sisiide kokkoreeddino. Piliss's'eema gadiyaa asatuukka yeluu oyk'k'eeddawaadan un\"etteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","He wode Eedooma gade kaappatuu dagameeddino. Moo'aabe gadiyaa mooddiyaawantta yashshay kokkorsseedda. Kanaane asatuwaa shenii hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Abeet Med'inaa Godaw dagamaynne yashshay unttuntta oyk'k'ina, Unttunttu ne wolk'k'aa gitatetsaa be'iide, ne Asay aad'd'ana gakkanaw, neeni wozeedda Asay aad'd'ana gakkanaw, shuchchaadan muumiide ek'k'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Abeet Med'inaa Godaw Neeni unttuntta ahaade, ne buzo gaden de'iyaa deriyaa huup'iyaan toketteedda mitsaada wotsa. He sa'ay neeni new de'anaw ootseedda sa'aa, he geeshsha sa'ay neeni ne kushiyaan minisaadde esseedda sa'aa. ");
INSERT INTO dwrl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Med'inaa Goday med'inaappe med'inaw kawutanawaa.» ");
INSERT INTO dwrl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Gibs'e kaatiyaa paratuu, Aa paraa gaaretuunne Aa paraa asatuu abbaan geleedda wode, Med'inaa Goday unttunttu bolla abbaa haatsaa guyye zaariide unttunttu bolla aheedda; shin Israa'eelatuu abbaa gidduwaana mela biittaan hamettiidde beeddino yaagi yes's'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aaroona michchata, nabatta Mayraama darbbiyaa akkaaddu; mac'c'a Asay ubbay darbbiyaa bak'k'iiddenne yes's'iidde izo kaaleeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mayraama unttunttoo yetsaa yes's'aadde, «Med'inaa Goday loytsi d'ok'k'u d'ok'k'u geedda diraw, aw yes's'ite. Paraanne paraa toggeeddaawaa I abbaan oleedda» yaagaadde yes's'aaddu. ");
INSERT INTO dwrl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Hewaappe guyyiyaan Muse Israa'eeliyaa Zo'o Abbaappe kaaletsina, unttunttu Suuri geetettiyaa mela biittaa beeddino. He mela biittaan unttunttu haatsaa demmennaan heezzu gallassaa hametteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Unttunttu Maaraa giyaa sa'aa gakkeedda wode, Maaraa haatsay c'amo gideedda diraw, ushanaw danddayibeykkino; hewaa diraw, he sa'ay Maaraa geetetteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Hewaa diraw, asay, «Nuuni ayaa ushanee?» yaagiide Muse bolla zuuzummeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Muse Med'inaa Godaw waasseedda; Med'inaa Goday Aa itti mitsaa besseedda; Muse he mitsaa haatsaa giddo olina, haatsay mal\"eedda. Med'inaa Goday unttunttoo kalesetiyaa wogaa immeedda; yaan S'oossay unttuntta paac'c'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I unttuntta hawaadan yaageedda; «Med'inaa Goday hinttenttu S'oossay odiyaawaa minisiide sisooppenne Aa ayfiyaa sintsaan likkebaa ootsooppe, hinttenttu Aa azazuwaa hayzzooppenne Aa wogaa ubbaa naagooppe, taani Gibs'etuwaa bolla aheedda harggiyaappe ittuwaanne hinttenttu bolla ahikke; ayaw gooppe, taani hinttentta patsiyaa Med'inaa Godaattee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Hewaappe unttunttu Eliima giya gadiyaa yeeddino; yaan tammanne laa\"u haatsaa pulttotuunne laappun tammu zambbaa mitsatuu de'iino. Unttunttu yaan haatsaa doonaan utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Gibs'eppe keseedda laa\"entso aginaan, tammanne ichcheshantso gallassan Israa'eeliyaa asaa kumentsay Eliimappe denddiide, Eliimappenne Siinappe gidduwaan de'iyaa «Siin» geetettiyaa mela biittaa yeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Israa'eeliyaa asaa ubbay mela biittaan Muse bollanne Aaroona bolla zuuzummeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israa'eelatuu unttuntta, «Nuuni Gibs'e gadiyaan Med'inaa Godaa kushiyaan hayk'k'eeddo gideerokkooshsha! Yan nuuni nuwaa ashuwaa keriyaa yuuyyi aad'd'i uttiide, nuuni koyo k'umaa ubbaa meeddo; shin hinttenttu nuuna kessiide, ubbatuwaa koshaan wod'anaw mela biittaa aheedditee?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Med'inaa Goday Musa, «Taani hinttenttoo saluwaappe ukitsaa bukissana; Asay ubbaa gallassikka kesiide, hachche hachchew gidiyaawaa s'alalaa mas'anaw koshshee. Asay ta azazuwaa kaalintto kaalenentto taani unttuntta hewaan paac'c'ana. ");
INSERT INTO dwrl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Usuppuntsa gallassi unttunttu haroode mas'iyaawoo laa\"u kushiyaa mas'iide, katsiino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Hewaa diraw, Musenne Aaroone Israa'eeliyaa asaa ubbaw, «Hinttena Gibs'e gadiyaappe keseedda Med'inaa Godaa gidiyaawaa omarssi hinttenttu erana; ");
INSERT INTO dwrl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","k'ay Med'inaa Godaa bonchchuwaa wontta hinttenttu be'ana; ayaw gooppe, Aa bolla hinttenttu zuuzummeeddawaa I siseedda; hinttenttu nu bolla zuuzummanaw nuuni oonee?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Hewaappe guyyiyaan Muse, «I hinttenttoo maanaw omarssi ashuwaa immiinanne hinttenttu koyyiyaa ukitsaa ubbaa hinttenttoo wontta immina, I Med'inaa Godaa gidiyaawaa hinttenttu hewaan erana. Ayaw gooppe, hinttenttu Aa bolla zuuzummeeddawaa I siseedda. Nuuni oonee? Hinttenttu nu bolla zuuzummikkita; hinttenttu Med'inaa Godaa bolla zuuzummiita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Muse Aaroona, «Neeni Israa'eeliyaa asaa ubbaa, ‹Med'inaa Goday hinttenttu zuuzuntsaa siseedda diraw, Med'inaa Godaa sintsa haa shiik'ite› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaroone Israa'eeliyaa asaa ubbaw odiyaa wode, unttunttu mela biittaakko simmiide s'eelleeddino; hewaan Med'inaa Godaa bonchchuu shaariyaa giddon k'onc'c'iyaawaa be'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Med'inaa Goday Musa, «Taani Israa'eelatuu zuuzuntsaa sisaad; neeni unttunttoo, ‹Omarssan ashuwaa hinttenttu maana; wontta ukitsaa hinttenttu kallana; he wode hinttenttu taani Med'inaa Godaa hinttenttu S'oossaa gidiyaawaa erana› yaagaadde oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","He gallassi omarssan ashuu meetettiyaa kafotuu yiide, Israa'eeliyaa Asay de'iyaa sa'aa mayyeeddino; k'ay wontta unttunttu dunkkaanetuwaa yuushshuwaan ketterssay kumi utteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ketterssay s'i\"eedda wode, sa'aan wod'd'eedda shachchaa malatiyaa suuppa pok'uu mela biittaa bollan beeteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israa'eeletuu hewaa be'eedda wode, unttunttu ittuu ittuwaa, «Hawe ayee?» yaageeddino. Ayaw gooppe, unttunttu I ayentto eribeykkino. Yaatina Muse unttuntta, «Hinttenttoo maanaw Med'inaa Goday immeedda ukitsay hawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Med'inaa Goday hawaadan yaagiide azazeedda; ‹Golle asaw aawotiyaawe, ittoo ittoo maanaw koshshiyaawaa keeshshaa shiishsho; hinttenttu dunkkaaniyaa giddon de'iyaa Asay huup'iyaan huup'iyaan laa\"u s'aasa gidiyaawaa akkite› geedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israa'eelatuu Muse unttunttoo odeeddawaadan ootseeddino; ittuu darissiide, ittuu laafetsiidde shiishsheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Unttunttu s'aasan makkeedda wode, darissiide shiishsheeddawoo palahibeenna; laafa shiishsheeddawoo pac'c'ibeenna; ubbaykka huup'iyaan huup'iyaan barew miyaawaa keeshshaa shiishsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Hewaappe guyyiyaan Muse unttuntta, «Ooninne aappe wonttiw ashshoppo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Gido shin unttunttuppe ittuu ittuu Muse odiyaawaa akkenan aggiide, hewaa wontta gakkanaw wotseeddino; hewe gus'uniide s'ink'k'eedda. Hewaa diraw, Muse unttuntta hank'k'etteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Wontta wontta Asay ubbay barew koshshiyaawaa shiishsheedda; away ho\"iyaa wode sa'aan atteeddawe siili aggeeda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Usuppuntsa gallassan unttunttu kasewaappe laa\"u kushiyaa shiishsheeddino. Yaatina unttunttu kaappatuu ubbatuu yiide hewaa Musew odeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","I unttuntta, «Med'inaa Goday azazeeddawe hawaa; wontti kiitay baynna shemppo gallassaa, Med'inaa Godaw geeshsha Sambbataa. Hewaa diraw, hinttenttu uukkiyaawaa uukkite; hinttenttu doyssiyaawaanne doyssite; palaheeddawaa wonttiw ashshite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Hewaa diraw, unttunttu Muse azazeeddawaadan wonttiw wotsina s'ink'k'ibeena woy gus'unibeena. ");
INSERT INTO dwrl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","«Hachche miite; ayaw gooppe, hachche Med'inaa Godaa Sambbataa; hinttenttu Aa hachche dembbaan demmikkita. ");
INSERT INTO dwrl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Hinttenttu usuppun gallassan Aa shiishshanaw danddayiita; shin laappuntsa gallassay Sambbata. Sambbatan ayaynne de'enna» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Laappuntsa gallassan itti itti Asay shiishshanaw keseedda; shin unttunttu ayinne demmibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Med'inaa Goday Musa, «Ta azazatuwaanne ta higgiyaa naagiyaawaa awude gakkanaw is's'iitee? ");
INSERT INTO dwrl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Med'inaa Goday hinttenttoo Sambbataa immeeddawaa akeekite; usuppuntsa gallassan I hinttenttoo laa\"u gallassaa ukitsaa immiyaawe hewaa diraassa. Laappuntsa gallassi ubbay bare de'iyaa sa'aan de'iyaa sa'aan gam\"o; ooninne kare kesoppo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Hewaa diraw, Asay laappuntsa gallassan shemppeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israa'eeliyaa Asay he ukitsaa mannaa giide suntseedda. Mannay deebbuwaa ayfiyaadan bootsa; eessaanna uukkeedda ukitsaadan mal\"ee. ");
INSERT INTO dwrl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Muse Israa'eeliyaa asaa, «Med'inaa Goday azazeeddawe hawaa; ‹Taani hinttentta Gibs'e gadiyaappe kesseedda wode, woran mizeedda ukitsaa unttunttu be'ana mala, mannaappe laa\"u s'aasa gidiyaawaa hinttenttu yaana yeletaw ashshi wotsite› yaagiide azazeedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Muse Aaroona, «itti s'aaruwaa akkaade laa\"u liitiro kumentsaa mannaa an k'ola; yaataade yaana yeletaw minjjettana mala, Med'inaa Godaa sintsan wotsa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Med'inaa Goday Musa azazeeddawaadan minjjettana mala, Aaroone mannaa S'oossaa sintsan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israa'eelatuu barenttu de'iyaa gade yaana gakkanaw oytamu laytsaa mannaa meeddino; unttunttu Kanaane gade bagga gakkanaw mannaa miidde de'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Aasi makkiyaa eretteedda k'un\"ay laa\"u s'aasaappe tammu dakkuwaa daree. ");
INSERT INTO dwrl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israa'eeletuwaa maabaraa ubbay Med'inaa Goday azazeeddawaadan, itti sa'aappe hara sa'aa yuuyyiidde, Siin mela biittaappe denddi biide, Rafidiima geetettiyaa sa'aan utteeddino. Shin Asay ushanaw haatsay he sa'aan d'ayeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Unttunttu Musena walak'ettiidde Aa, «Nuw ushanaw haatsaa imma» yaageeddino. Muse zaariide, «Hinttenttu taananna ayaw walak'ettiitee? Med'inaa Godaa hinttenttu ayaw paac'c'iitee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Shin Asay yaan haatsaa saamettiide, Muse bolla zuuzummeeddino. Unttunttu Aa, «Neeni nuuna, nu naanaanne nu mehiyaa saamuwaan wod'anaw Gibs'eppe kesaade pude ayaw ahaad?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Muse, «Taani ha asaa waatoo? Unttunttu taana shuchchaan c'addana haniino» yaagiide Med'inaa Godaakko waasseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Med'inaa Goday Musa, «Neeni asaappe sintsaw hametta; Israa'eeliyaa asaa c'imatuwaappe neenana afa; ini neeni Nayle Shaafaa haatsaa shoc'eedda s'am\"aa ne kushiyaan oyk'k'aadde ba. ");
INSERT INTO dwrl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Taani Siinaa Deriyaa zaallaa bolla ne sintsan ek'k'ana; neeni he zaallaa shoc'a; Asay ushanaw aappe haatsay kesanawaa» yaageedda. Muse Israa'eeliyaa c'imatuwaa sintsan hewaadan ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Israa'eelatuu, «Med'inaa Goday nu giddon de'iiyye baawe?» yaagiide walak'etteedda dirawunne Med'inaa Godaa paac'c'eedda diraw, he sa'ay Masaahanne Mariiba geetettiide suntseteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amaaleek'atuu yiide, Rafiidiman Israa'eelatuwaana olaa gaketeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Muse Iyyaasa, «Neeni nuw asaa dooraade, kessaade Amaaleek'atuwaana oletta; taani wontti S'oossaa s'am\"aa oyk'k'aade, Zooziyaa huup'iyaan ek'k'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Hewaappe guyye Iyyaasu Muse geeddawaadan, Amaaleek'atuwaana oletteedda. Muse, Aaroonenne Huuri zooziyaa huup'iyaa kesseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Muse bare kushiyaa dentsi gam\"eedda keenan ubbaan Israa'eelatuu s'ooniino; shin I bare kushiyaa duge wotseedda wode Amaaleek'atuu s'ooniino. ");
INSERT INTO dwrl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Muse kushii arggaac'eedda wode, unttunttu shuchchaa akki yiide, Musa Aa bolla utisseeddino. Aaroonenne Huuri ittuu itti baggana ittuu hinkko baggana gidiide, Aa kushiyaa sitti ootsiidde oyk'k'eeddino. Yaatina away wullana gakkanaw Aa kushii sitti giide takkeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Hewaa diraw, Iyyaasu Amaaleek'atuwaa olanchchatuwaa mashshaan s'ooneedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Hewaappe simmina, Musa Med'inaa Goday hawaadan yaageedda; «Hawe ubbaa gede k'ofettana mala hawaa mas'aafan s'aafa. Yaataade Iyyaasa sissennan aggoppa; ayaw gooppe, saluwaappe garssan taani Amaaleek'a asatuwaa zaari k'ofetenaadan c'iraana d'ayssana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Muse yarshshuwaa yarshshiyaa sa'aa kees's'iide, «Med'inaa Goday taw s'oonuwaa immee» giide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","I hawaadan yaageedda; «Kushetuu pude Med'inaa Godaa kawutetsaa araataakko denddeeddino; yeletaappe yeletaa gakkanawukka Med'inaa Goday Amaaleek'atuwaana olettanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Miidiyaama gade k'eesii, Muse bolluu Yootoore, S'oossay Musewunne Aa asaa Israa'eeliyaw ootseeddabaa ubbaanne Med'inaa Goday Israa'eeliyaa Gibs'eppe kesseeddawaa siseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","He wode Muse bolluu, Yootoore, Muse aakko yediidde beedda Aa machato S'ipaaronne izi laa\"u naanaa aheedda. Unttunttuppe ittuwaa suntsay Gershshooma; ayaw gooppe, Muse, «Taani asaa gadiyaan bete gidaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Laa\"entsuwaa suntsay El\"aazara; ayaw gooppe, I, «Ta aawuwaa S'oossay taana maaddeeddawaa; I taana Gibs'e kaatiyaa mashshaappe ashsheeda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Muse bolluu Yootoore Aa attuma naanaanne Aa machchattina S'oossaa deriyaa matan de'iyaa Musekko mela biittaa yeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","I Musa, «Taani, ne bolluu Yootoore, ne machchattinanne izi laa\"u naanatuwaanna neekko yay» yaagiide aakko kiitti wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Hewaa diraw, Muse bare bolluwaanna gakettanaw kesiide, aw goynneedda, Aa yereedda. Unttunttu ittuu ittuwaa sarotsiide, dunkkaaniyaa giddo geleeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Med'inaa Goday Israa'eeliyaa asaa diraw, kaatiyaa bollanne Gibs'etuwaa bolla ootseedda ubbaa, ogiyaan unttuntta gakkeedda daaburaabaa ubbaanne Med'inaa Goday unttuntta ashsheeddawaa Muse bare bolloo odeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Israa'eeliyaa asaa Gibs'etuwaa kushiyaappe ashshanaw Med'inaa Goday ootseedda lo\"o oosotuwaabaa ubbaa sisiide, Yootoore nashetteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yaatiide «Hinttena Gibs'etuwaa kushiyaappenne kaatiyaa kushiyaappe ashsheeda Med'inaa Goday, Gibs'etuwaa kushiyaappe asaa kessi akkeeddawe, I galattetto. ");
INSERT INTO dwrl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Med'inaa Goday hara s'oossatuwaappe ubbaappe wolk'k'aama gidiyaawaa taani ha\"i eraad; ayaw gooppe, I ha Israa'eeliyaa asaa bolla oteretteedda Gibs'e s'oossatuwaa bolla hawaa ootseedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Hewaappe guyyiyaan Yootoore, Muse bolluu, shuketiide polo s'uugettiyaa itti mehiyaa yarshshuwaanne hara yarshshoo shuketeedda ashuu meetettiyaa mehiyaa yarshshuwaa S'oossaw aheedda; Aaroonenne Israa'eeliyaa c'imatuu ubbay S'oossaa sintsan Muse bolluwaanna k'umaa maanaw yeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Wonttetsa gallassi Muse asaw pirddanaw utteedda; Asay Muse yuushshuwaan wonttappe omarssi gakkanaw ek'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Muse bolluu Muse asaw ootsiyaawaa ubbaa be'iide, «Neeni ha asaw ootsiyaawe hawe ayee? Asay ubbay wonttappe doommiide omarssi gakkanaw ne yuushshuwaan ek'k'ide'ishshin, neeni neerekka daannaadan ayaw uttaad?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Muse bare bolluwaa, «Asay S'oossaa sheniyaa oochchanaw taakko yiyaa diraassa. ");
INSERT INTO dwrl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Unttunttoo yewuu de'ooppe taakko yiino; taani itti uraa gidduwaaninne Aa shooruwaa gidduwaan pirdday; S'oossaa azazuwaanne wogaa unttuntta erissay» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Muse bolluu, «Hawe neeni ootsiyaabay lo\"enna. ");
INSERT INTO dwrl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Neeninne neenana de'iyaa Asay daabura s'alalaa giddiita; ha kiittay new loytsi dees'o; neeni hawaa neerekka ootsanaw danddayakka. ");
INSERT INTO dwrl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ane ha\"i taani odiyaawaa sisa; taani neena zorana; S'oossay neenana gido. Neeni ha asaa diraw S'oossaa sintsa aad'd'a; neeni unttunttu yewuwaa S'oossaakko aha. ");
INSERT INTO dwrl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Azazuwaanne wogaa unttuntta neeni tamaarissa; unttunttu de'ana maaraanne ootsana oosuwaa ubbaa unttuntta bessa. ");
INSERT INTO dwrl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","K'ay asaa ubbaa giddon danddayiyaa asatuwaa, S'oossaw yayyiyaawantta, ammanetteedawanttanne magans's'aa miyaawaa is's'iyaawantta dooraade unttunttuppe asaw sha\"aa kaappatuwaa, s'eetuwaa kaappatuwaa, ishatamuwaa kaappatuwaanne tammuwaa kaappatuwaa suntsaa. ");
INSERT INTO dwrl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Unttunttu ubbaa wode asaw pirddino; shin waayissiyaa yewuwaa ubbaa neekko ahino; waayissenna yewuwaa ubbaa unttunttu wurssino. Unttunttu neenana shaakketiyaa diraw, tookuu new kawushanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Neeni hewaadan ootsooppenne hawe S'oossaa azazo gidooppe, neeni danddayana. K'ay ha Asay ubbaykka bare allaallii polettina, bare soo bare soo baanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Muse bare bolluwaa k'aalaa siseedda; I geeddawaa ubbaakka ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Muse Israa'eeliyaa ubbaa giddoppe danddayiyaa asatuwaa dooriide asaa kaaletsiyaa sha\"aa kaappatuwaa, s'eetuwaa kaappatuwaa, ishatamuwaa kaappatuwaanne tammuwaa kaappatuwaa suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Unttunttu asaw ubbaa wode pirddeeddino; unttunttu barena dees'eedda yewuwaa Musekko aheeddino; shin dees'ena yewuwaa ubbaa unttunttu wursseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Hewaappe guyyiyaan Muse bare bolluwaa moyzzina Yootoore bare gadiyaa simmeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israa'eeliyaa Asay Gibs'eppe keseedda heezzentsa aginaan he koyro gallassan Siina mela biittaa gakkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Unttunttu Rafiidimeppe denddiide Siina mela biittaa biide, hewaan de'iyaa deriyaa sintsa mela biittaan utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Muse S'oossakko pude deriyaa huup'iyaa kesina, Med'inaa Goday deriyaa huup'iyaan Aa s'eesiide, «Neeni Yaak'oobappe yeletteedda Israa'eeliyaa asaw hawaadan yaagaadde oda; ");
INSERT INTO dwrl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹Taani Gibs'etuwaa bolla ayaa ootsaadditanttonne k'ay arggantsaa k'efiyaan taani hinttentta waata tookkaade taakko ahaaditanttonne hinttenttu hinttenttu huup'iyaw be'eeddita. ");
INSERT INTO dwrl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Simmi ha\"i hinttenttu taw loytsi azazettooppenne ta k'aalaa c'aak'uwaa naagooppe, asaa ubbaa giddon hinttenttu taw buzo gidana. Kumentsaa sa'ay tawaa gidooppenne ");
INSERT INTO dwrl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","hinttenttu ta kawutetsaa k'eesatuwaanne geeshsha asaa gidana› yaaga; neeni Israa'eelatoo odana k'aalay hawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Muse guyye simmi biide, asaa kaletsiyaawantta s'eesi shiishshiide, Med'inaa Goday oda geedda ha k'aalatuwaa ubbaa unttunttoo odeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Asay ubbay itti doonaa gidiide, «Med'inaa Goday geeddawaa ubbaa nuuni ootsana» yaageeddino. Musekka unttunttu geeddawaa Med'inaa Godaakko afeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Med'inaa Goday Musa, «Taani neenana haasayishin Asay sisanaadaaninne unttunttu neenan ubbaa wodekka ammanettanaadan, taani neekko wolk'k'aama shaariyaa gidduwaana yaana» yaageedda. Hewaappe guyyiyaan Muse Asay geeddawaa Med'inaa Godaw odeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Med'inaa Goday Musa, «Neeni asaakko baade hachchenne wontti unttunttu geeyanaadan oda. Unttunttu barenttu mayuwaa meec'c'iide; ");
INSERT INTO dwrl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","heezzentso gallassaw giigino. Ayaw gooppe, heezzentso gallassan Asay ubbay be'ishin, Med'inaa Goday Siina Deriyaa bollan wod'd'anawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Neeni ha deriyaa yuushshuwaan asaw zawaa wotsaade unttunttoo, ‹Deriyaa pude kesenaadan woy deriyaa s'ap'uwaa bochchennaadan hinttentta erite. Deriyaa bochcheedda ooninne tumuppe hayk'k'anawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","He uray shuchchaan c'adettiide woy wonddaafiyaan c'adettiide hayk'k'ooppe attin; I kushiyaan boshettoppo. Mehe, woy asaa gidooppenne I shemppuwaanna attena› yaaga. Malakatay punettiyaa wode, he wode unttunttu deriyaa pude kesana gooppe kesino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Muse deriyaappe asaakko duge wod'd'eeddawaappe guyyiyaan unttuntta geeyanaadan odina, unttunttu barenttu mayuwaa meec'c'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Hewaappe guyyiyaan asaa I, «Heezzentso gallassaw giigite; machchiyaanna ak'oppite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Heezzentso gallassi wontta guuguntsaa guntsay sisetteedda. Walk'k'antsaynne wolk'k'aama shaarii deriyaa mayyiide beetteedda; malakataykka punettiyaa wolk'k'aama kooshshay sisetteedda. Hewaa diraw, bare de'iyaa sa'aan Asay ubbay kokkoreedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Hewaappe guyyiyaan Muse asaa S'oossaanna gatsanaw unttunttu de'iyaa dunkkaaniyaappe keseedda; unttunttu deriyaa garssa dembbaan ek'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Med'inaa Goday Siina Deriyaa bollan tamaanna wod'd'eedda diraw, Siina Derii c'uwaan kameteedda. Wolk'k'aama guuduwaappe c'uway kesiyaawaadan, aappe c'uway pude keseedda. Asay ubbay loytsi kokkoreedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Malakataa punuu loytsi dari dari beedda wode, Muse haasayina, S'oossaa kooshshay aw zaariide haasayeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Med'inaa Goday Siina Deriyaa kiikiyaan wod'd'iide, Musa pude deriyaw kiikiyaa s'eesina Muse pude keseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Med'inaa Goday Aa, «Neeni duge baade Asay Med'inaa Godaa be'ana giide, zawaa aad'd'enaadaninne unttunttuppe daruu hayk'k'ennaadan asaa seera. ");
INSERT INTO dwrl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Haray atto Med'inaa Godaa mata shiik'iyaa k'eesatuukka barena geeshshanaw koshshee; hewe d'ayooppe, Med'inaa Goday unttuntta murana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Muse Med'inaa Godaa, «Asay deriyaa pude yaanaw danddayenna; ayaw gooppe, neeni ne huup'iyaw, ‹Ha sa'aa geeshshaadan dummayiide, ha deriyaa yuushshuwaan zawaa wotsite› gaade nuw oda wotsaadda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Med'inaa Goday Aa, «Neeni duge baade Aaroona neenana pude akkaade ya. K'eesetuwaanne asaa Med'inaa Goday murenaadan, unttunttu zawaa aad'd'iidde pude Med'inaa Godaakko yooppino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Hewaa diraw, Muse duge asaakko wod'd'iide, S'oossay geeddawaa unttunttoo odeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","S'oossay ha k'aalatuwaa ubbaa hawaadan yaagiide haasayeedda; ");
INSERT INTO dwrl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Neena Gibs'eppe ayiletetsaa gadiyaappe keseedda Med'inaa Goday ne S'oossay taana. ");
INSERT INTO dwrl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Taappe attina, hara s'oossaw goynnoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Bolla saluwaan de'iyaa, woy garssa sa'aan de'iyaa, woy sa'aappe garssan haatsaa giddon de'iyaa ayyaanne malatissaade new goynniyaa misiletuwaa ootsoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Unttunttoo hokkoppa woy unttunttoo goynnoppa. Ayaw gooppe, taani, Med'inaa Goday ne S'oossay k'anaatanchcha S'oossaa; taana is's'iyaawantta aawotuwaa nagaraa diraw, naanaa heezzentso yeletaanne oyddentso yeletaa gakkanaw muriyaawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","K'ay taana siik'iyaanne ta azazuwaa naagiyaawanttoo sha\"a yeletay gakkanaw laamettena siik'uwaa bessiyaa Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Med'inaa Godaa ne S'oossaa suntsaa c'oo dentsoppa; ayaw gooppe, S'oossay bare suntsaa c'oo dentsiyaawaa murana. ");
INSERT INTO dwrl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Geeshsha ootsaade, Sambbata gallassaa naaga. ");
INSERT INTO dwrl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Neeni ootsiyaa oosuwaa ubbaa usuppun gallassatuwaan ootsa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Shin laappuntsa gallassay Med'inaa Godaa ne S'oossaw Sambbata. He gallassi ay oosuwaanne ootsoppa; neeni, woy ne attuma na'ay, woy ne mac'c'a naanaa, woy ne mac'c'anne attuma k'oomatuu, woy ne miizzay, woy hinttenttunna de'iyaa Israa'eeliyaa gidena Asay he gallassan ay kiitaakka kiitettoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ayaw gooppe, usuppun gallassaa giddon Med'inaa Goday saluwaanne, sa'aa, abbaanne unttunttu giddon de'iyaa ubbaa med'd'eedda; shin laappuntsa gallassan shemppeedda. Hewaa diraw, Med'inaa Goday Sambbata gallassaa anjjeedanne geeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Med'inaa Goday ne S'oossay new immiyaa biittaan ne laytsay aduk'k'ana mala, ne aabbanne ne daayo bonchcha. ");
INSERT INTO dwrl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Asaa wod'oppa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Woshummoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Wuu\"oppa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Ne shooruwaa bollan wordduwaa markkattoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Ne shooruwaa golliyaa amottoppa; ne shooruwaa machato, woy Aa k'oomaa, woy Aa k'oomato, woy Aa booraa, woy Aa hariyaa, woy aw de'iyaawaa ayaanne amottoppa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Asay ubbay guuguntsay guugummiyaawaanne walk'k'antsay wolk'k'aamiyaawaa be'eedda; malakataa waasuwaa siseedda; k'ay derii c'uwattiyaawaakka be'eedda; Asay yashshan kokkoriide, haakuwaan ek'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Unttunttu Musa, «Neeni nuw haasaya; nuuni sisana; shin nuuni hayk'k'ennaadan, S'oossay nuw haasayoppo» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Muse asaa, «S'oossay hinttentta paac'c'anaw, nagaraa hinttenttu ootsenna mala, Aa yashshay hinttenttu wozanaan de'anaadan, I yeedda diraw yayyoppite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Asay haakki ek'k'ide'ishshin, S'oossay de'iyaa sa'aa wolk'k'aama d'umaakko Muse shiik'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Hewaappe guyyiyaan, Med'inaa Goday Musa, «Israa'eeliyaa asaw hawaadan yaagaadde oda; ‹Taani saluwaappe hinttenttoo haasayeeddawaa hinttenttu hinttenttu huup'iyaw be'eeddita. ");
INSERT INTO dwrl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ta matan ay eek'aanne ootsoppite; biraa eek'aa woy work'k'aa eek'aa hinttenttoo ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","« ‹Neeni taw yarshshuwaa yarshshiyaa sa'aa urk'k'aappe med'd'aade ne s'uuggiyaa yarshshuwaa, ne ittippetetsaa yarshshuwaa, ne dorssatuwaanne ne deeshshatuwaappe ne miizzatuwaa Aa bolla yarshsha. Ta suntsay k'ofettana mala ootseedda sa'aa ubbaan, taani hinttenttukko yaade, hinttentta anjjana. ");
INSERT INTO dwrl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Neeni taw yarshshuwaa yarshshiyaa sa'aa shuchchaappe med'd'ooppe, masetteedda shuchchaappe med'd'oppa; ayaw gooppe, neeni massiyaa miishshan Aa bochchooppe, ne Aa tunissaasa. ");
INSERT INTO dwrl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ta yarshshuwaa sa'aa pude gayyiyaan kesoppa; ayaw gooppe, neeni kesiyaa wode, ne kalluu beette› yaagaadde oda. ");
INSERT INTO dwrl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«Neeni unttunttoo immana wogay hawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Neeni Ibraawe ayiliyaa shammooppe, I new usuppun laytsaa ootso; shin laappuntsa laytsaan I ayinne k'ans's'ennan, ayiletetsaappe c'oo kesiide bo. ");
INSERT INTO dwrl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","I barekka yeeddawaa gidooppe barekka bo; bare machchattina yeeddawaa gidooppe, Aa machatakka aanana bu. ");
INSERT INTO dwrl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Aa goday aw machato immeeddawaa gidooppenne machchata aw attuma naanaa woy mac'c'a naanaa yeleeddawaa gidooppe, he machatanne izi naanay Aa godaawaa; I barekka kesiide bo. ");
INSERT INTO dwrl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Shin he ayilii, ‹Taani ta godaa, ta machatonne ta naanaa siik'ay; taani ayiletetsaappe kesikke gooppe,› ");
INSERT INTO dwrl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Aa goday Aa pirddiyaawanttu sintsa aatso; hewaappe guyyiyaan pengge woy pengge mak'aaniyaakko Aa afiide, Aa haytsaa gootsan lukko. Simmi I bare de'uwaa laytsaa ubbaan aw ayiliyaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Asay bare mac'c'a naatto ayiletetsaw zal\"ooppe, attuma ayiletuu ayiletetsaappe kesiyaawaadan iza kesuppu. ");
INSERT INTO dwrl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Iza barena machchetetsaw dooriide afeedda godaw lo\"ana d'ayooppe, goday izo wozissanaw koshshee. I iziw ammanettibeenna diraw, izo allagaw zaal\"anaw aw maatay baawa. ");
INSERT INTO dwrl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","I izo bare na'aw immanaw doorooppe, mac'c'a naattiw bessiyaawaa iziw ootso. ");
INSERT INTO dwrl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","I barew hara machato akkooppe, koyro machatiw k'umaa, mayuwaa woy asinatetsaanne machchetetsaa maataa pac'issoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","I ha heezzubatuwaa iziw immana d'ayooppe, ayinne shaluwaa c'iggenan ayiletetsaappe kesaade bu. ");
INSERT INTO dwrl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Asaa shoc'iide wod'iyaa asaa tumuppe wod'anaw bessee. ");
INSERT INTO dwrl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Shin eriidde gidenaan I wod'iyaa wode, taani, S'oossay c'o\"u geeddawaa gidooppe, I bak'atana sa'aa unttunttoo taani giigisana. ");
INSERT INTO dwrl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Shin onne k'opiide eriidde hara bitaniyaa wod'ooppe, he uraa ta yarshshuwaa sa'aappe diggaade, haraa sa'aan wod'a. ");
INSERT INTO dwrl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Bare aabba woy bare daayo dechchiyaa uray ooninne tumuppe hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Asaa wolk'k'an oyk'k'iide zal\"iyaa uray woy wolk'k'aan oyk'k'eedda Asay Aa kushiyaan beetteedda Asay tumuppe hayk'k'anaw bessee. ");
INSERT INTO dwrl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Bare aabba woy bare daayo shek'k'iyaawe tumuppe hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","«Laa\"u asatuu walak'ettooppe, ittuu yenkkuwaa shuchchaan c'adooppe woy bokisooppe, he deshetteeddawe hayk'k'ennan attowaa gidooppenne harggiide gisuwaan gam\"ooppe, denddiide guufiyaana kare heeraan hamettooppe, he dechcheeddawe hayk'k'uwaappe attee; giddooppene I Aa kiitaa diggeedda diraw, shaluwaa c'igganawunne Aa patsanaw maaddana koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Asay bare attuma ayiliyaa woy mac'c'a ayilatto s'am\"an shoc'ooppenne hewaa gaasuwaan he uray he godaa kushiyaan hayk'k'intto, shoc'eeddawe tumuppe murettanaw bessee. ");
INSERT INTO dwrl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Shin he deshetteeddawe itti woy laa\"u gallassaan denddooppe, he ayilii Aa miishshaa gidiyaa diraw, I murettena. ");
INSERT INTO dwrl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Laa\"u asatuu ittuu ittuwaanna wad'ettiidde shahaara mishiratto dechchooppenne iza boshettooppe, hewaappe hara iita deshetsay d'ayooppe, he mishiratti asinay oochcheeddawaanne daannatuu pirddeeddawaa ayaanne c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Shin iziw deshetsay darooppe, shemppuu hayk'k'intto shemppuwaa, ");
INSERT INTO dwrl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ayfiyaa diraw ayfiyaa, achchaa diraw achchaa, kushiyaa diraw kushiyaa, gediyaa diraw gediyaa, ");
INSERT INTO dwrl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","s'uugetsaa diraw s'uugetsaa, madutsaa diraw madutsaa, k'oo'eedda diraw k'oo'uwaa akkanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Itti Asay bare attuma ayiliyaw woy mac'c'a ayilatiw ayfiyaa bak'k'iide toyssooppe, he ayfiyaa diraw ayiletetsaappe kessi yeddo. ");
INSERT INTO dwrl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Hewaadankka, bare ayiliyaa achchaa woy bare ayilatti achchaa mentsooppe, he achchaa diraw ayiletetsaappe kessi yeddo. ");
INSERT INTO dwrl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Booray mac'c'a asaa woy attuma asaa k'ayc'c'iide wod'ooppe, he booray shuchchaan c'adettiide hayk'k'o; Aa ashuu meetettoppo. Shin booraa goday murettoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Shin booray kasekka k'ayc'c'iyaa meezii de'iyaawaa gidiina, Asay Aa godaw odi wotsina, Aa goday k'achchennaan is's'ina, booray attuma asaa woy mac'c'a asaa wod'ooppe, he booray shuchchaan c'adettiide hayk'k'o; k'ay Aa godaykka hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Shin I barena wozanaadan ooshetooppe, unttunttu oochcheeddawaa ayaanne c'iggiide, bare shemppuwaa wozo. ");
INSERT INTO dwrl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Booray attuma na'aa woy mac'c'a naatto k'ayc'c'iide wod'ooppekka, pirdday itti mala gido. ");
INSERT INTO dwrl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Booray attuma ayiliyaa woy mac'c'a ayilatto k'ayc'c'iide wod'ooppe, booraa goday ayiliyaa godaw hattamu biraa santtimiyaa c'iggo. Booray shuchchaan c'adettiide hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Itti Asay ollaa k'um\"iyaa pokiide, woy ollaa bookkiide k'um\"ennaan aggooppe, booray woy harii he ollaan kunddooppe, ");
INSERT INTO dwrl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","he ollaa goday mehiyaa gatiyaa c'iggo. I Aa godaw gatiyaa c'iggiide, hayk'k'eedda mehiyaa barew akko. ");
INSERT INTO dwrl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«Itti asaa booray hara booraa k'ayc'c'iide wod'ooppe, pas'a booraa zal\"iide, Aa gatiyaanne hayk'k'eedda booraa likkiyaan shaakki akkino. ");
INSERT INTO dwrl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Shin he booray k'ayc'c'iyaawaa gidiyaawe kaseti erettishin, Aa goday Aa k'achchennaan aggeedawaa gidooppe, Aa goday booraa c'iggo. Yaatiide he hayk'k'eeddawaa barew akko. ");
INSERT INTO dwrl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Itti Asay booraa woy dorssaa wuu\"iide shukkooppe, woy zal\"ooppe, booraa diraw ichcheshu booraa, dorssaa diraw oyddu dorssaa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","«Kaysuu golliyaa bookkiide oyk'k'etooppenne shoc'ettiide hayk'k'intto, shoc'eeddawe suutsaa gusseeddawoo ooshettenna. ");
INSERT INTO dwrl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Shin hewe s'alk'k'ii doli kichchina hanooppe, I he gukkeedda suutsaa ac'uwaan ooshettee. Kaysuu bare wuu\"eeddawaa zaaro; shin aw ayaynne d'ayooppe, bare wuu\"eeddawaa zaaranaw I zal\"etto. ");
INSERT INTO dwrl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","I wuu\"eedda mehii pas'a de'iidde Aa kushiyaan beettintto, booraa, woy hariyaa, woy dorssaa gidooppenne, I bare wuu\"eeddawaa laa\"u kushiyaa aatsiide c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«Itti Asay bare mehiyaa dembban woy woyniyaa turaa giddon heemmishin, mehii hara asaa shoyk'aappe mooppe, I bare shoyk'aappe woy bare woyniyaa turaa ubbaappe lo\"iyaawaa afilaamaa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«S'aragay denddiide aguntsaa buuraanna laa'iide, dooriyaan de'iyaa katsaa, woy ek'uwaan de'iyaa katsaa, woy goshshaa ubbaa miyaawaa gidooppe, koyro s'aragaa oytseedda bitanii ac'aa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","«Itti Asay biraa woy hara miishshaa naagissanaw bare shooroo hadaraa immina, shooruwaa sooppe he miishshay wuu\"eettooppenne kaysuu oyk'k'etintto, kaysuu he miishshaw laa\"u kushiyaa aatsiide c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Shin kaysuu beettenaan d'ayooppe, golliyaa goday pirddiyaawanttukko shiik'iide bare shooruwaa miishshaa bolla bare kushiyaa wotsibeennawaa c'aak'k'o. ");
INSERT INTO dwrl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«Asay ay mootuwankka, booraa gaasuwaan, woy hariyaa gaasuwaan, woy dorssaa gaasuwaan, woy mayuwaa gaasuwaan, woy hara bayeeddawaa gaasuwaan, ‹Hawe tawaa› giide mootettooppe, laa\"u baggaykka barenttu mootuwaa pirddiyaawanttu sintsa aatsino; pirddiyaawanttu bayzzanchcha geedda uray bare shooroo laa\"u kushiyaa aatsiide c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","«Asay bare shooroo hariyaa, woy booraa, woy dorssaa, woy hara mehiyaa naagissanaw hadaraa immina hayk'k'intto, woy deshettintto, woy ooninne be'ennaan bonk'k'anchchay afooppe, ");
INSERT INTO dwrl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","hadaraa naagiyaawe bare shooruwaa mehiyaa bolla bare kushiyaa wotsibeennawaa Med'inaa Godaa sintsan c'aak'k'ina, unttunttu giddon de'iyaa yewuu mayetto. He mehiyaa goday c'aak'uwaa akko; c'iggaa immanaw koshshenna. ");
INSERT INTO dwrl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Shin mehii shooruwaappe wuu\"etteeddawaa gidooppe, izaawoo c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","He mehiyaa do'ay mentsereetsiide meeddawaa gidooppe, markka gidanaadan do'ay miishshin atteedawaappe akkiide yo; yaatiide me'eretteedda mehiyaa diraw c'iggoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","«Asay bare shooruwaappe mehiyaa gars's'ooppenne Aa goday baynna sa'aan he mehii deshettooppe woy hayk'k'ooppe, he mehiyaa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Shin Aa goday aanana de'ooppe, gars's'eedawe c'iggoppo; keraw akkeeddawaa gidooppe, keraw c'iggiyaa shaluu ac'uwaa c'iggeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«Itti Asay asinaw giigabeenna wodoratto c'immiidde, izina gisiyaawaa gidooppe, izo c'ilooshiide barew machato ootso. ");
INSERT INTO dwrl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Izi aabbu izo aw immanaw is's'ooppe, wodoratto akkiyaa uray c'ilooshiyaawaa keeshshaa biraa I aabboo immo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«Bitiyaa mishiratto pas'a wotsoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«Mehiyaanna gisiyaa ooninne tumuppe hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«Med'inaa Godaa s'alalaassappe attina, hara s'oossaw yarshshiyaawe ooninne mule d'ayo. ");
INSERT INTO dwrl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Betiide yeedda asaa k'ohoppite woy un\"oppite; ayaw gooppe, hinttenttukka Gibs'e gadiyaan bete gidiide de'eeddita. ");
INSERT INTO dwrl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Asinay hayk'k'eedda am\"attonne aawuu hayk'k'eedda hiyyeesaa un\"oppite. ");
INSERT INTO dwrl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Hinttenttu unttuntta un\"etsina, unttunttu taakko waassooppe, ");
INSERT INTO dwrl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","taani unttunttu waasuwaa tumuppe sisana; he wode ta hank'k'uu hinttenttu bolla denddana; taani hinttentta mashshaan wurssana; hinttenttu machatuu am\"e hinttenttu naanaykka aawuu hayk'k'owantta gidanawantta. ");
INSERT INTO dwrl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«Hinttenttu giddon de'iyaa ta asaappe itti hiyyeesaw shaluwaa tal\"ooppe, shaluwaa dichchaw immiyaa asaadan hanoppite; neeni dichchaa Aa oochchoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Neeni ac'uwaa diraw ne laggiyaa mayuwaa oyk'k'ooppe, away wullenan de'ishshin aw zaara; ");
INSERT INTO dwrl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ayaw gooppe, I bare bollaa kammiyaawe henni s'alalaana; harabaa ayaa mayyiide ak'anaw danddayii? I taw waassooppe, taani k'arettiyaawaa gidiyaa diraw, sisana. ");
INSERT INTO dwrl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«S'oossaa bolla shek'aa k'aalaa haasayoppa, woy ne deriyaa mooddiyaawaa shek'k'oppa. ");
INSERT INTO dwrl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ne katsaa s'eeraappenne ne woyniyaa gum\"etsaa kumentsaappe taw yarshshuwaa shiishsha. «Neeni ne attuma naanaa giddon bayiratiyaa na'aa taw immanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Miizzaappekka dorssaappekka hewaadan ootsa. Unttunttu laappun gallassay gakkanaw, barenttu aayetuwaana aayetuwaana gam\"ino; hosppuntsa gallassi unttuntta taw imma. ");
INSERT INTO dwrl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","«Hinttenttu taw geeshsha asaa gidanaw koshshee; hewaa diraw, bazuwaa do'ay mentsereetsiide wod'eedda mehiyaa ashuwaa mooppite; hewaa kanaw olite. ");
INSERT INTO dwrl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Worddo oduwaa puukkoppa; wordduwaa markka gidaade, iita asaa maaddoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Iitabaa ootsanaw c'ora asaa kaalloppa; pirddaa geellayanaw c'ora asaana itta gidaade markkattoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Hiyyeesay pirddaw shiik'ooppe, mootuwaan Aa metuwaa s'eellaade maaddoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Ne morkkiyaa booray woy harii bayeeddawaa demmooppe, zaaraadde aw afa. ");
INSERT INTO dwrl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Neena is's'iyaa bitaniyaa harii c'aanaana kunddeeddawaa be'ooppe, hewaan aggoppa; maaddaade aanana dentsa. ");
INSERT INTO dwrl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Pirddaa dabaaban maaddaade, hiyyeesaa asaa pirddaa geellayoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Worddo yewuwaa ubbaappe haakka; geeshsha woy s'illuwaa wod'oppa; ayaw gooppe, kobaa ootseeddawaa taani saro yeddikke. ");
INSERT INTO dwrl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Mattaayiyaa (magans's'aa) akkoppa; ayaw gooppe, mattaayii s'eelliyaawanttu ayfiyaa k'ook'iseenne s'illatuwaa k'aalaa mirk'k'ee. ");
INSERT INTO dwrl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Betiyaa naak'k'oppite; bete gidiyaawe ay keeshshaa kayyoyintto eriita; ayaw gooppe, hinttenttu hinttenttu huup'iyaw bete gidiide Gibs'e gadiyaan de'eedditta. ");
INSERT INTO dwrl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Neeni ne gadiyaa usuppun laytsaw goshaade, zeraade katsaa k'oyc'a akka. ");
INSERT INTO dwrl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Laappuntsa laytsaan gadiyaa goshenan shaachcha; yaatooppe, ne asaa giddon de'iyaa hiyyeesatuu hewaappe miyaabaa demmana; k'ay unttunttuppe attiyaawaa do'atuu maana. Neeni ne woyniyaa turaakka ne wogaraakka hewaadan ootsa. ");
INSERT INTO dwrl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Usuppun gallassaa ne kiitaa kiitetta; ne booraynne ne harii shemppana malanne ne son yeletteedda ayiliinne betii, shemppana mala, laappuntsa gallassi oosuwaa ootsoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Taani hinttentta geeddawaa ubbaa minisiide ootsite; hara s'oossatuwaa suntsaa s'eesoppite; hinttenttu ins's'arssaappe hewe sisettoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Laytsan heezzu gede hinttenttu taw baalaa bonchchite. ");
INSERT INTO dwrl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Magaage ukitsaa Baalaa bonchchite; taani hinttentta azazeeddawaadan, laappun gallassaa irshshuwaa yeggibeenna ukitsaa miite; hinttenttu Abiiba geetettiyaa aginaan keereedda gallassatuwaan ha baalaa bonchchite; ayaw gooppe, hinttenttu Gibs'eppe keseeddawe he aginaana. «Hintteppe itti asaynne ta sintsan mela kushe beettoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«K'ay hinttenttu hinttenttu gaden zerina, koyro gakkeedda katsaa c'akkiyaa wode, Katsaa c'akkiyaa Baalaa bonchchite. «K'aykka laytsaa wurssetsan, katsaa ayfiyaa gadeppe shiishshiyaa wode, Shiishuwaa Baalaa bonchchite. ");
INSERT INTO dwrl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Attuma Asay ubbay Ubbaa Mooddiyaa Med'inaa Godaa sintsan laytsan heezzu gede beetto. ");
INSERT INTO dwrl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Neeni yarshshuwaa suutsaa taw shiishshaadde, irshshuwaa yeggiide uukkeedda ukitsaanna shiishshoppa. Ta baalaa bonchchiyaa gallassi yarshshetteedda mod'd'uwaappe wonttaw ayinne attoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ne gaden bayira ka\"eedda katsaappe ubbaappe lo\"iyaawaa Med'inaa Godaa soo, ne S'oossaa soo aha. Deeshsha maraa Aa daay maatsan doyssoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Ne ogiyaan neena naagana malanne taani new giigisseedda sa'aa neena afana mala, taani kiitanchchaa ne sintsan kiittana. ");
INSERT INTO dwrl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","I odiyaawaa hayzza aw azazetta; Aa bolla makkaloppa; ta suntsay Aa bolla de'iyaa diraw, hinttenttu nagaraa ootsiyaawaa gidooppe, hinttenttoo I atto geena. ");
INSERT INTO dwrl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","I odiyaawaa hinttenttu minisiide hayzzooppenne taani odiyaawaa ubbaa ootsooppe, hinttenttu morkkatuwaa taani morkkana; hinttenana ek'ettiyaawanttuna taanikka ek'k'ettana. ");
INSERT INTO dwrl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ta kiitanchchay hintteppe sintsanna biide, hinttentta Amooraawaanatuwaa gadiyaa, Hiitetuwaa gadiyaa, Parzzaawaanatuwaa gadiyaa, Kanaanetuwaa gadiyaa, Hiiwetuwaa gadiyaanne Yaabuusawaanatuwaa gadiyaa ahana. Taani unttunttu ubbaa d'ayssana. ");
INSERT INTO dwrl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Unttunttu s'oossatuwaa sintsan hokkoppite, woy goynnoppite, woy unttunttu hanuwaa k'ulloppite. Hinttenttu unttunttu s'oossatuwaanne unttunttu shuchchaa misiletuwaa mentsereetsanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Med'inaa Godaa, hinttenttu S'oossaw, goynnite; yaatooppe, I hinttenttu k'umaanne hinttenttu haatsaa anjjanawaa; taani harggiyaa hinttenttu giddoppe diggana. ");
INSERT INTO dwrl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Hinttenttu biittaan ay mac'c'a asaynne boshetenna; maynenna. Taani hinttenttu de'ana laytsaa payduwaa adussana. ");
INSERT INTO dwrl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«Taani ta yashshaa hinttenttu sintsan yeddana; hinttenana gakettiyaa kawutetsaa ubbaa dagantsana; hinttenttu morkketuu ubbay hinttenttoo zokkiiyaa zaariide, bak'atanaadan taani ootsana. ");
INSERT INTO dwrl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Taani hintteppe sintsaw dukkiyaa kajiyaa yeddana; Hiiwetuwaa, Kanaanetuwaanne Hiitetuwaa hinttenttu sintsaappe laaggaade kessana. ");
INSERT INTO dwrl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Shin biittay mela attenaadaaninne bazuwaa do'ay hinttentta waayissenaadan, itti laytsaan unttuntta yederssikke. ");
INSERT INTO dwrl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Shin hinttenttu payduwaan dariide, he gadiyaa laattana gakkanaw, taani unttuntta laafa laafa laaggaade hinttenttu sintsaappe kessana. ");
INSERT INTO dwrl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Taani hinttenttu zawaa Zo'o Abbaappe Piliss's'eema Abbaa, mela biittaappe Efiraas'iisa Shaafaa gatsana. He gadiyaan de'iyaa ubbaa taani hinttenttu kushiyaan aatsaade immana; hinttenttukka unttuntta hinttenttu sintsaappe laaggiide kessana. ");
INSERT INTO dwrl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Unttunttunna woy unttunttu s'oossatuwaanna c'aak'uwaa wotsoppite. ");
INSERT INTO dwrl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Unttuntta hinttenttu gadiyaan wotsoppite; hewe d'ayooppe unttunttu hinttentta ta bolla nagaraa oosissanawantta; ayaw gooppe, unttunttu s'oossatoo goynniyaawe tumuppe hinttenttoo p'ire gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Hewaappe guyye Med'inaa Goday Musa, «Neeni, Aaroone, Naadaabe, Abiihinne Israa'eeliyaappe laappun tammu c'ima asatuu Med'inaa Godaakko deriyaa huup'iyaa pude kesiide haakuwaan goynnite. ");
INSERT INTO dwrl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Shin Muse, neeni neerekka Med'inaa Godaakko shiik'a; hara c'imatuu ta mata yooppino. K'ay asaykka neenana pude kesoppo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Muse yiide, Med'inaa Godaa k'aalaa ubbaanne Aa wogaa ubbaa asaw odina Asay ubbay itti k'aalaan, «Med'inaa Goday odeeddawaa ubbaa nuuni ootsana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Muse Med'inaa Goday odeeddawaa ubbaa s'aafeedda. Wonttetsa gallassi wontta guuran denddiide, deriyaa s'ap'uwaan yarshshiyaa sa'aa gimbbiide Israa'eeliyaa asaa yaraa tammanne laa\"uwaa suntsaan, tammanne laa\"u shuchchaa tuussaa esseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","I Israa'eelatuwaappe yalaga attuma asaa kiittina, unttunttu biide s'uuggiyaa yarshshuwaa shiishsheeddino; k'ay ittippetetsaa yarshshoo korumatuwaa Med'inaa Godaw yarshsheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Muse suutsaappe bagga akkiide keriyaan tigeedda; atteeda bakka suutsaa I yarshshiyaa sa'aan c'ac'c'afeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Hewaappe guyyiyaan K'aalaa c'aak'uwaa Mas'aafaa akkiide, asaw nabbabeedda; unttunttu, «Med'inaa Goday odeeddawaa ubbaa nuuni ootsana; nuuni azazettana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Hewaappe guyyiyaan Muse he suutsaa akkiide, asaa bolla c'ac'c'afiide unttuntta, «Be'ite, Med'inaa Goday ha k'aalaa ubbaan hinttenana wotseedda k'aalaa c'aak'uwaa suutsay hawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Muse, Aaroone, Naadaabe, Abiihinne Israa'eeliyaa c'imatuwaappe laappun tammuu pude keseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Israa'eeliyaa S'oossaa be'eeddino; Aa gediyaappe garssana saluwaadan geeyeedda samppeeriyaa geetettiyaa p'ooliyaa shuchchaappe oosetteeddawaa malatiyaa wuyggiyaa malabay de'ee. ");
INSERT INTO dwrl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Shin S'oossay Israa'eeliyaa asaa kaappatuwaa wod'ibeenna. Unttunttu S'oossaa be'eeddino; Aa sintsan meeddinonne usheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Med'inaa Goday Musa, «Neeni deriyaa pude haa taakko kesaade, hawaan gam\"a; yaatooppe neeni unttuntta tamaarissana mala, taani wogaanne azazuwaa s'aafeedda shuchchaa new immana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Hewaappe guyyiyaan Muse bare k'oomaa Iyyaasunna baanaw denddeedda; Muse S'oossaa deriyaa pude keseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Israa'eeliyaa asaa c'imatuwaa I, «Nuuni hinttenttukko simmanaw hawaan de'ishshite; Aaroonenne Huuri hawaan hinttenana de'iino; yewuu de'iyaa ooninne unttunttukko bo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Muse deriyaa pude keseedda wode, shaarii deriyaa kammeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","K'ay Med'inaa Godaa bonchchuu Siina Deriyaa bollan utteedda; he shaarii usuppun gallassaa mayyeedda; laappuntsa gallassan he shaariyaa giddoppe Med'inaa Goday Musa s'eeseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Israa'eelatoo Med'inaa Godaa bonchchuu deriyaa huup'iyaan s'uuggiyaa tamaa malatiide beetteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Hewaappe guyyiyaan Muse he shaariyaa giddo geliide, deriyaa pude kesiide deriyaa huup'iyaan oytamu gallassaanne oytamu k'ammaa gam\"eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Med'inaa Goday Musew hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Taw immiyaawaa ahanaadan neeni Israa'eelatoo oda; taw immanaw Aa wozanay Aa imma imma giyaa asaa ubbaa imotaa neeni taw akka. ");
INSERT INTO dwrl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Hinttenttu unttunttuppe akkana imotay hawaa: work'k'aa, biraa, nahaasiyaa birataa, ");
INSERT INTO dwrl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","saluwaa malatiyaa, ochchaa teeraa malatiyaanne, zo'o liik'o k'ac'inaa, deeshshaa isikiyaa, ");
INSERT INTO dwrl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","dorssaa orggiyaa galbbaa zo'o k'alamiyaan yeggi kesseeddawaa, hara galbbaa, odooruwaa, ");
INSERT INTO dwrl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","s'omppiyaw wogaraa zayitiyaa, okkiyaa zayitiyaanne is'aanaa sawetsiyaa k'imaamiyaa; ");
INSERT INTO dwrl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","K'eesatuwaa kaappuwaa eefuudiyaaninne tiraan wotsiyaawaan yeggiyaa margidiyaa geetettiyaa shuchchatuwaanne hara p'ooliyaa al\"o shuchchatuwaa aho. ");
INSERT INTO dwrl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","«Yaatiide taani unttunttu giddon ak'anaadan, unttunttu taw Geeshsha sa'aa giigissino. ");
INSERT INTO dwrl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Likke taani neena besseedda leemisuwaa ubbaadan S'oossaa Dunkkaaniyaanne Aa giddon de'iyaa miishshatuwaa ootsite. ");
INSERT INTO dwrl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Unttunttu odooruwaa mitsaappe adussatetsay laa\"u wad'anne bagga, gomppay itti wad'anne bagga, geesay k'ay itti wad'anne bagga gideedda Taabootaa med'd'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Soyaanne kariyaa walakay baynna work'k'aan sheeshsha; Aa yuushshuwaakka work'k'aa tigetsan yuushsha aatsa. ");
INSERT INTO dwrl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","He Taabootaw oyddu work'k'aa sagaayetuwaa tigaade oyddu gedetuwaan itti baggana laa\"u sagaayetuwaa, k'ay yenkko baggana laa\"u sagaayetuwaa aatsa. ");
INSERT INTO dwrl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Hewaappe guyyiyaan odooruwaappe kasuwaa kessaade work'k'aan sheeshsha. ");
INSERT INTO dwrl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Taabootaa tookkanaw, Taabootaa miyyiyaan de'iyaa sagaayetuwaan kasuwaa aatsa. ");
INSERT INTO dwrl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tookkiyaa kasotuu Taabootaa sagaayetuwaa giddon de'ino; unttunttu hewaappe ubbakka kesoppino. ");
INSERT INTO dwrl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Taabootaa giddon taani new immiyaa, tammu azazatuu s'aafetti utteedda laa\"u masetteedda markkatetsaa shuchchatuwaa wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Walakay baynna work'k'aappe laa\"u wad'anne bagga aduk'k'iyaa, itti wad'anne bagga aakkiyaa atto giyaa sa'aa k'um\"iyaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","K'um\"iyaw wurssetsaa laa\"u bagga gas'an laa\"u kiruubeeliyaa, k'os'etteedda work'k'aappe med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Itti kiruubiyaa itti bagga gas'an, laa\"entso kiruubiyaa yenkko bagga gas'an laa\"uwaakka k'um\"iyaanna gatsa oytsaade med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kiruubetuu barenttu k'efiyaa dentsiide, atto giyaa sa'aa k'um\"iyaa barenttu k'efiyaan kuway wotsino; k'ay ittuu ittuwaakko simmi uttiide, k'um\"iyaa s'eellino. ");
INSERT INTO dwrl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","K'um\"iyaa Taabootaw bolla baggan wotsa; k'ay taani new immiyaa azazatuu s'aafettiidde masetteedda shuchchatuwaa Taabootaa giddon wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Markkatetsaa Taabootaa bolla k'um\"iyaa bolla de'iyaa laa\"u kiruubetuwaappe gidduwaan taani neenana gakettaade Israa'eeliyaa asaw taani immiyaa azazuwaa ubbaa yaan new immana. ");
INSERT INTO dwrl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Odooruwaa mitsaappe adussatetsaa laa\"u wad'aa, gomppay itti wad'aa, geesay k'ay itti wad'anne bagga gidiyaa itti s'arp'p'eezaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Yaataade walakay baynna work'k'aan sheeshsha; k'ay Aa yuushshuwaan work'k'aa tigetsaa yuushsha aatsa. ");
INSERT INTO dwrl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Hewaadankka, k'ay gomppay takkaad'e gideedda shaashiyaa Aa bolla yuushsha aatsa. Yaataade Aa bolla work'k'aa tigetsaa yuushsha. ");
INSERT INTO dwrl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","He s'arip'p'eezaw oyddu work'k'aa sagaayetuwaa med'd'aade, s'arip'p'eezaa gedetuu de'iyaa oyddu gas'an wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","S'arip'p'eezaa tookkanaw kasuwaa aatsiyaa sagaayetuu s'arip'p'eezaw shaashiyaa gas'aan shiik'iide de'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","He tookkiyaa kasuwaa odooruwaappe kessaade, work'k'aan unttuntta sheeshsha. ");
INSERT INTO dwrl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Hewaadankka, k'ay shaatatuwaanne c'ilppatuwaa, duuk'k'iyaabatuwaanne s'uu'atuwaa walakay baynna work'k'aappe med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ta sintsa aatsiyaa geeshsha ukitsay ubbaa wodekka s'arip'p'eezaa bolla d'ayoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«S'omppiyaa wotsiyaa baalaa k'os'etteedda walakay baynna work'k'aappe med'd'a; he baallay ek'k'iyaa gediikka, k'ay giddo toomaykka ubbay k'os'etteedda work'k'aappe oosettanaw koshshee. Aa wanc'c'atuu, Aa kukkumotuu Aa c'iishshatuu ubbay aanana ittippe oyk'etti med'ettanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Miyyiyaanna usuppun maratuu aw kesiino; maratuwaappe heezzatuu itti baggana, k'ay heezzatuu yenkko baggana de'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Usuppun maratookka huup'iyaan huup'iyaan heezu heezu kukkumuunne c'iishshay de'iyaa lawuziyaa c'iishshaa malatiyaa wanc'c'ay de'o. ");
INSERT INTO dwrl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","S'omppiyaa wotsiyaa baallaw giddo toomay, kukkumotuwaa c'iishshatuu de'iyaa lawuziyaa c'iishshaa malatiyaa oyddu wanc'c'ay de'o. ");
INSERT INTO dwrl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Laa\"uu laa\"uu ittippe waatsan de'iyaa heezzu maratuwaappe garssana itti itti kukkumuu de'o. ");
INSERT INTO dwrl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Kukkumatuunne maratuu ubbay s'omppiyaa wotsiyaa baalaana ittippe, oyk'k'etti ittuwaa gidiide, walakay baynna work'k'aappe k'os'ettiide med'ettino. ");
INSERT INTO dwrl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«Hewaappe guyyiyaan s'omppiyaa wotsiyaa baallaw laappun s'omppetuwaa giigissaade, unttunttu sintsa giddow poo'ana mala d'ok'k'u ootsaadde wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","S'omppiyaa toyssiyaa k'ap'etuwaanne unttuntta wotsiyaawantta walakay baynna work'k'aappe med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","S'omppiyaa wotsiyaa baallaynne an go\"ettiyaa miishshaa ubbay hattamanne ichcheshu kiilo giraame gideedda walakay baynna work'k'aappe med'd'ettiino. ");
INSERT INTO dwrl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Akeeka; taani neena deriyaa huup'iyaan besseeddawaadan kiiteta. ");
INSERT INTO dwrl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«K'ay liik'o puuttuwaappe saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappe dadetteedda tammu gaarddotuwaappe S'oossaa Dunkkaaniyaa giigissa. He gaarddotuwaan itti hiillan kiruubetuwaa misiliyaa dadissa. ");
INSERT INTO dwrl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Gariddotuu ubbay itti likke gidino; geesay laatamanne hosppun wad'a; gomppay oyddu wad'aa gido. ");
INSERT INTO dwrl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ichcheshu gaarddotuwaa ittippe gatsaade sikka; yenkko atteeda ichcheshu gaarddotuwaakka unttunttuwaadan kiiteta. ");
INSERT INTO dwrl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ittippe gakettiide siketteedda gaarddotuwaappe itti gaariduwaa wurssetsa gas'an saluwaa malatiyaa c'ark'k'iyaappe mac'araa med'd'a; k'ay ittippe gaketi siketteedda yenkko gaardduwaankka hewaadan kiiteta. ");
INSERT INTO dwrl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ittippe gaketeedda itti gaardduwaa bolla ishatamu mac'araa, k'ay ittippe gaketeedda yenkko gaardduwaa bollakka ishatamu mac'araa med'd'a; he mac'aratuu ubbaykka ittuu ittoo maaran de'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Hewaappe guyyiyaan work'k'aappe ishatamu oyk'k'iyaawantta med'd'aade S'oossaa Dunkkaanii ittuwaa gidana mala, he gaarddotuwaa gas'aa gas'aa he oyk'k'iyaawanttun oytsa. ");
INSERT INTO dwrl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«K'ac'inaappe med'etteedda S'oossaa Dunkkaaniyaa bollanna kammana mala, tammanne itti gaarddatuwaa deeshshaa isikiyaappe daddaade, itti dunkkaaniyaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tammanne itti gaarddatuukka itti likke gidino; itti itti gaardduwaa geesay hattamu wad'aa, gomppay oyddu wad'aa gido. ");
INSERT INTO dwrl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ichcheshu gaarddotuwaa itti baggana, usuppun gaarddotuwaa k'ay yenkko baggana gatsaade sikka. Usuppuntsa gaardduu dakkotiide, dunkkaaniyaw sintsa baggana daabuletto. ");
INSERT INTO dwrl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Gatsi sikkeedda gaarddatuwaappe itti gaardduwaa gas'an ishatamu mac'araa med'd'a; k'ay gatsi sikkeedda yenkko gaarddotuwaappe gas'an ishatamu mac'araa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ishatamu nahaasiyaa oyk'k'iyaawaa med'd'aade, mac'aratuwaa giddo gelissa; yaataade dunkkaaniyaa ittippe gatsa oytsa. Yaatooppe ha laa\"u oyk'k'etteedda kamiyaawanttu ittuwaa gidana. ");
INSERT INTO dwrl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ha dunkkaaniyaa gaarddotuwaappe palaheedda bagga gaardduu S'oossaa Dunkkaaniyaw guyyenna kak'k'eto. ");
INSERT INTO dwrl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Dunkkaaniyaa gaarddotuu laa\"u bagganakka itti itti wad'aa keeshshaa palahino; he palaheeddawanttu S'oossaa Dunkkaaniyaa kammana mala, laa\"u bagga miyyiyaanna kak'k'etino. ");
INSERT INTO dwrl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«Deeshshaa agoozaappe med'etteedda dunkkaaniyaa bollanna kammanaw dorssaa orggiyaa galbbaa zo'o k'alamiyaan yeggi kesseeddawaa giigissa; k'ay Aa bollanna kammanaw k'um\"iyaa hara galbbaappe giigissa. ");
INSERT INTO dwrl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«S'oossaa Dunkkaaniyaa s'agaagiyaawantta sitti geedda odooruwaappe kessa. ");
INSERT INTO dwrl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Itti itti s'agaagiyaw geesay tammu wad'aa, gomppay itti wad'anne bagga gido. ");
INSERT INTO dwrl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Itti itti s'agaagiyaw ittuwaa ittuwaanna gatsi oytsiyaa laa\"u pootsaa med'd'a. S'oossaa Dunkkaaniyaa s'agaagetuwaa ubbaakka hewaadan kiitetta; ");
INSERT INTO dwrl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","S'oossaa Dunkkaaniyaw gedissa baggana laatamu s'agaagiyaawaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Itti itti s'agaagiyaw laa\"u pootsay geliyaa oytamu lukuwaa, ubbaakka biraappe giigissa. ");
INSERT INTO dwrl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","S'oossaa Dunkkaaniyaw huup'issa baggana, laatamu s'agaagiyaawaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Itti itti s'agaagiyaw laa\"u gedetuu, mule oytamu gedetuu, biraappe giigino. ");
INSERT INTO dwrl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","K'ay S'oossaa Dunkkaaniyaw guyye gas'an away wulliyaa baggana usuppun s'agaagiyaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Guyen de'iyaa gas'atoo laa\"u s'agaagiyaa giigissa. ");
INSERT INTO dwrl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Hewaa diraw, itti s'ap'uwaan laa\"u pootsaa giiga s'eeraa gakanaw itta gidi migiduwaan oyk'k'etanaw bessee; laa\"uu gas'aa oytsiyaa s'agaagatuukka hara s'agaagii oosettowaadan oosetanaw bessee. ");
INSERT INTO dwrl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Hewaa diraw itti itti s'agaagiyaw garssanna laa\"u laa\"u pootsay geliyaa lukatuu de'iino; ubbaanna hosppun s'agaagetuunne biraappe ooseteedda tammanne usuppun pootsay geliyaa lukatuu de'iino. ");
INSERT INTO dwrl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«K'ay odoorotuwaappe tuk'k'umetiyaa meegaa kessa. S'oossaa Dunkkaaniyaw itti bagga miyyiyaan de'iyaa s'agaagetoo ichcheshu tuk'k'umetiyaa meegaa, ");
INSERT INTO dwrl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","k'ay yenkko bagga miyyiyaan de'iyaa s'agaagetoo ichcheshu tuk'k'umetiyaa meegatuwaa giigissa. Hewaadankka, S'oossaa Dunkkaaniyaw guyye away wulliyaa baggana wurssetsa gas'an de'iyaa s'agaagetoo ichcheshu tuk'k'umetiyaa meegaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Giddo tuk'k'umetiyaa meegay s'agaagetoo giddo heeraana ha gas'aappe ya gas'aa gakkanaw pini kesanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","S'agaagetuwaa work'k'aan sheeshshaade, tuk'k'umetiyaa meegatuu aad'd'iyaa sagaayetuwaa work'k'aappe med'd'a; k'ay tuk'k'umetiyaa meegatuwaakka work'k'aan sheeshsha. ");
INSERT INTO dwrl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","S'oossaa Dunkkaaniyaa taani neena deriyaa bollan besseeddawaadan ootsaadde tokka. ");
INSERT INTO dwrl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne liik'o liinuwaappe itti gaardduwaa kiiteta; he gaardduwaa bolla itti hiillan kiruubetuwaa misiliyaa sikissa. ");
INSERT INTO dwrl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Yaataade work'k'aan sheeshsheedda oyddu, odooruwaa tuussatuwaan de'iyaa work'k'aappe oosetteedda kak'k'iyaawaan kak'k'a. He oyddu tuussatuu biraappe med'd'eedda oyddu pootsay geliyaasaan gelino. ");
INSERT INTO dwrl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","He gaardduwaa S'oossaa Dunkkaaniyaa kaaran de'iyaa oyk'k'iyaawanttuppe garssanna kak'k'eedda, K'aalaa C'aak'uwaa Taabootaa gaardduwaappe guyye baggan wotsa; yaatooppe he gaardduu Geeshsha sa'aa Ubbaappe Aad'd'eedda Geeshsha Sa'aappe shaakana. ");
INSERT INTO dwrl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Atto giyaa sa'aa k'um\"iyaa Ubbaappe Aad'd'eeda Geeshsha Sa'aan de'iyaa K'aalaa C'aak'uwaa Taabootaa bolla wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","S'arp'p'eezaa gaardduwaappe karenna, S'oossaa Dunkkaaniyaan geeshsha sa'aa gidduwaan huup'issa baggan wotsa; s'omppiyaa wotsiyaa baalaa k'ay Aa baggan gedissa baggana wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Dunkkaaniyaa geliyaa penggiyaw saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne liik'o liinuwaappe s'ilppiyaan alleek'k'issiyaawaan oosetteedda gaardduwaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Gaarddoo ichcheshu tuussatuwaa odoorotuwaappe kessaade, work'k'aan sheeshsha; kak'k'iyaawanttukka work'k'aappe oosetteeddawantta gidino; tuussatoo nahaasiyaa birataappe tigaade ichcheshu pootsatuu geliyaawaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Odooruwaappe yarshshiyaa sa'aa kees's'a. He yarshshiyaa sa'aw geesay ichcheshu wad'aa gido; gomppaynne itti likke, ichcheshu ichcheshu wad'aa; d'ok'k'atetsay heezu wad'aa, oyddu gas'ana de'o. ");
INSERT INTO dwrl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Wurssetsaa gas'an gas'an itti itti kac'iyaa med'd'a; kac'etuu yarshshiyaa sa'aanna ittippe oyk'k'ettiide med'ettino. Yaataade yarshshiyaa sa'aa nahaasiyaa birataan sheeshsha. ");
INSERT INTO dwrl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","An go\"ettiyaa miishshatuwaa, bidintsaa kessiyaa balddetuwaa, akaafatuwaa, suutsaa tigiyaa kuyis'aarotuwaa, K'ap'iyaa, seeliyaabaa oyk'k'iyaa miishshaa nahaasiyaa birataappe med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Yaataade nahaasiyaa birataappe zazziriyaa med'd'a; k'ay Aa oyddu gas'an oyddu sagaayetuwaa med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Yaataade yarshshiyaa sa'aw giddo baggan oytsaade wotsa ");
INSERT INTO dwrl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Odooruwaappe yarshshiyaa sa'aw kasotuwaa kessaade, nahaasiyaa birataan sheeshsha. ");
INSERT INTO dwrl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Yarshshiyaa sa'aa tookkiyaa wode maaddana mala, he kasuwaa laa\"u miyyiyaanna de'iyaa sagaayetuwaan aatsa. ");
INSERT INTO dwrl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Taani neena deriyaa bollan besseeddawaadan, yarshshiyaa sa'aa s'awulaappe med'd'iide, gomppaa mela kesino. ");
INSERT INTO dwrl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«S'oossaa Dunkkaaniyaw Asay shiik'iyaa dabaabaa giigissa. Dabaabay gedissa baggana s'eetu wad'aa aduk'k'o; he dabaabaw liik'o liinuwaappe dadetteedda gaarddotuwaa giigissa. ");
INSERT INTO dwrl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Aw nahaasiyaa birataappe laatamu tuussatuwaanne tuussatuu ek'k'iyaa laatamu pootsay geliyaa lukuwaa ootsa; unttunttu huup'iyaan k'ay biraappe kak'k'iyaawanttanne tuussatuwaa huup'iyaan k'achchiyaawantta ootsa. ");
INSERT INTO dwrl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Hewaadankka, dabaabaw huup'issa baggana s'eetu wad'aa aduk'k'o; k'ay laatamu tuussatuwaananne he tuussatoo laatamu nahaasiyaa pootsay geliyaa lukotuwaana de'iyaa gaaridduu de'o. Yaatiide biraappe oosetteedda kak'k'iyaawanttunne tuussatuwaa huup'iyaan k'achchiyaawanttu dabaabaw de'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","«Dabaabaw away wulliyaa bagga gomppay ishatamu wad'aa aakko; tammu tuussatuunne, tuussatoo tammu pootsay geliyaa lukatuu de'iyaa gaariddotuu aw de'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","K'ay away doliyaa bagga dabaabaa gomppaykka ishatamu wad'aa gido. ");
INSERT INTO dwrl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Dabaabaa geliyaa sa'aappe away doliyaa baggana tammanne ichcheshu wad'aa aduk'k'iyaa gaarddotuu de'ino; unttunttoo heezzu tuussatuunne heezzu pootsay geliyaa lukotuu de'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Hewaadankka, hinkko baggana gaarddotuu tammanne ichcheshu wad'aa aduk'k'iyaa gaarddotuu de'ino; unttunttoo heezzu tuussatuunne tuussatoo heezzu pootsay geliyaa lukotuu de'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","«Dabaabaa geliyaa sa'aw laatamu wad'aa aduk'k'iyaa gaardduwaa giigissa; hewekka saluwaa malatiyaa, ochchaa teeraa malatiyaanne, shololla zo'o k'ac'inaappenne liik'o liinuwaappe dadetteeddawaa, s'ilppiyaan alleek'k'issiyaawaan giigissa. Oyddu tuussatuwaanne tuussatoo oyddu pootsay geliyaa lukotuwaa giigissa. ");
INSERT INTO dwrl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Dabaabaa yuushshuwaan de'iyaa tuussatuwaa ubbaw biraappe oosetteedda k'achchiyaawanttunne kak'k'iyaawanttu, nahaasiyaappe oosetteedda pootsay geliyaa lukotuu de'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Dabaabay adusatetsay s'eetu wad'aa, gomppay ishatamu wad'aa gido; pudiyaa ichcheshu wad'aa d'ok'k'iyaa liik'uwaan dadetteedda liinuwaappe oosetteedda gaarddotuu de'ino; yaatiide tuusatuwaa nahaasiyaappe oosetteedda pootsay geliyaa lukotuu gidino. ");
INSERT INTO dwrl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","«S'oossaa Dunkkaaniyaan ootsiyaa oosoo go'ettiyaa miishshaa ubbay, unttunttu go\"ay ayaa gidooppenne, S'oossaa Dunkkaaniyaa d'ogetu ubbaananne dabaabaa d'ogetu ubbaannakka gujjina, nahaasiyaa birataappe med'ettiino. ");
INSERT INTO dwrl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«S'omppii to'ennan ees's'iidde de'ana mala, aw koshshiyaa S'illo zayitiyaa wogaraa teeraa c'addiide gum\"ina kesseeddawaa new ahana mala, Israa'eelatuwaa azaza. ");
INSERT INTO dwrl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaroonenne Aa naanay, s'omppii S'oossaa sintsaan k'ammeedda sa'ay wonttana gakkanaw poo'ana mala, Med'inaa Godaa Dunkkaaniyaa giddon, Markkatetsaa Taabootaa sintsaan de'iyaa gaardduwaappe karenna eetsino. Hawe Israa'eeliyaa asaw med'inaw wotso woga gidiide de'o. ");
INSERT INTO dwrl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«Ne ishaa Aaroonanne Aa naanaa Nadaaba, Abiiha, El\"aazaaranne Itaamaara neekko ahaade; unttunttu k'eesatuwaa gidiide taw ootsana mala, Israa'eeliyaa asaa giddoppe unttuntta dummaya. ");
INSERT INTO dwrl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Aw bonchchuwaanne puulaa immana mala, ne ishaa Aaroonaw k'eesatetsaa mayotuwaa giigissa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Taani aad'd'eeda era immeedda kushiyaa hiilaa eriyaa asaa ubbaa s'eesaade, Aaroonaw mayotuwaa giigissana mala oda; I k'eesee gidiide, taw ootsanaw dummatanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Unttunttu giigissana mayotuukka hawantta: tiraan wotsiyaawaa, eefuudiyaa, adussa mayuwaa, alleek'k'ettiide dadetteedda adussa shaamic'c'iyaa, shaashiyaanne hara danc'c'uwaa. Ne ishay Aaroonenne Aa naanay k'eesatuwaa gidiide taw ootsiide geeshsha mayotuwaa mayyana mala, sikkiyaawanttu giigissiino. ");
INSERT INTO dwrl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kushiyaa hiilaa eriyaawanttukka ha mayotuwaa giigissanaw work'k'aa, saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaanne liik'o liinuwaa go'ettino. ");
INSERT INTO dwrl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Eefuudiyaa geetettiyaa mayuwaa work'k'aappe, saluwaa malatiyaa k'ac'inaappe, ochchaa teeraa malatiyaa k'ac'inaappe, shololla zo'o k'ac'inaappenne liik'o liinuwaa k'ac'inaappe kushiyaa hiillanchchatuu alleek'k'issiide giigissiino. ");
INSERT INTO dwrl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Laa\"u baggay gakettiide ittuwaa gidana mala, laa\"u hashiyaa bolla gatsiide oytsiyaa c'ark'k'ii de'o. ");
INSERT INTO dwrl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Hiilanchchay aleek'k'issiide daddeedda danc'c'uukka eefuudiyaanna itta gidiide, work'k'aappe, saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne lee'issi bak'k'eedda liinuwaappe oosetto. ");
INSERT INTO dwrl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","«Marggidiyaa geetettiyaa laa\"u shuchchatuwaa ahaade, Israa'eeliyaa naanatuwaa suntsaa unttunttu bolla wooc'aade s'aafa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Unttunttu yeletaa maaraadan itti shuchchaa bolla usuppun suntsaa, hinkko shuchchaa bolla k'ay atteeda usuppunatuwaa suntsaa wooc'aade s'aafa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Maatafaa bolla suntsaa wooc'iide s'aafiyaawaadan, he laa\"u shuchchatuwaa bolla Israa'eeliyaa naanatuwaa suntsaa wooc'aade s'aafa; he shuchchatuwaa work'k'aappe med'd'eedda shuchchaa oyk'k'iyaawaa bolla wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Yaataade tammanne laa\"u Israa'eeliyaa zeretsaa hassayiyaawaa gidana mala, ha laa\"u shuchchatuwaa eefuudiyaanna oytseedda hashiyaa c'ark'k'iyaan wotsa; yaatooppe Med'inaa Godaa sintsan ubbaade k'ofettana mala, ha suntsatuwaa Aaroone bare hashiyaan tookko. ");
INSERT INTO dwrl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","He shuchchatuwaa oyk'k'iyaawaa work'k'aappe med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","K'ay walakay baynna work'k'aappe wodoruwaadan dook'k'eedda laa\"u sanssalatatuwaa giigissaade, he laa\"u shuchchaa oyk'k'iyaawanttunna gatsa oytsa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«S'oossaa shenii ayentto oochchiide eriyaa tiraan wotsiyaawaa kushiyaa hiilanchchaan oosissa. He tiraan wotsiyaawaa eefuudiyaa daddeeddawaadan, work'k'aappe, saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne liik'o liinuwaappe dadda. ");
INSERT INTO dwrl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Aw oyddu gas'ay de'ee; geesaykka gomppay itti itti takkaad'e gidiide dakkotto. ");
INSERT INTO dwrl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Hewaappe guyyiyaan Aa bolla oyddu maaran al\"o shuchchatuwaa wotsa; koyro maaran wotseedda shuchchay, sarddiyoona, toop'aaziyooniyaanne p'ooliyaa ink'k'uwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Laa\"entso maaran baluuriyaa, samppeeriyaanne almmaaziyaa giyaa al\"o shuchchatuwaa; ");
INSERT INTO dwrl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","heezzentso maaran yaakinttiyaa, kelk'k'edooniyaanne ametess's'inoosiyaa; ");
INSERT INTO dwrl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","oyddentso maaran biralli, marggidiyaa, yasp'p'iidiyaa. Hawanttu ubbay work'k'aappe oosetteedda shuchchaa oyk'k'iyaawaa bolla uttino. ");
INSERT INTO dwrl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Israa'eeliyaa naanatuwaa suntsaa payduwaadan, shuchchatuwaa payduukka tammanne laa\"uwaa gidino; ittuu ittuu maatafaadan wooc'ettiide, tammanne laa\"u zaratuwaa suntsay he shuchchatuwaan s'aafetto. ");
INSERT INTO dwrl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Tiraan wotsiyaawoo wodoruwaadan dook'eteedda sanssalataa walakay baynna work'k'aappe med'd'a. ");
INSERT INTO dwrl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Laa\"u work'k'aa migidatuwaa med'd'aade, tiraan wotsiyaawoo k'ommo gas'aa gatsaade oytsa wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","He laa\"u work'k'aa sanssalatatuwaa tiraan wotsiyaawoo gas'an de'iyaa migidotuwaanna gatsaade oytsa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","He sanssalatatoo yenkko bagga s'eeraa k'ay eefuudiyaw sintsa baggana, hashiyaa c'ark'k'iyaan de'iyaa shuchchaa oyk'k'iyaawanttunna gatsa k'achcha. ");
INSERT INTO dwrl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","K'aykka laa\"u work'k'aa migidatuwaa med'd'aade, eefuudiyaappe garssan kaalliide de'iyaa tiraan wotsiyaawoo soo baggana de'iyaa laa\"u gas'aa s'eeran aatsa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Hewaadankka, work'k'aappe hara laa\"u migidatuwaa med'd'aade; eefuudiyaw sintsa baggana, hashiyaa c'ark'k'iyaappe garssa baggana, eefuudiyaa s'eessan k'achchiyaawaappe k'ommonna, sikuu gaketeedda sa'aa matan karenna unttuntta oytsa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tiraan wotsiyaawaan de'iyaa migidatuwaa eefuudiyaan de'iyaa migidotuwaanna gatsiide, saluwaa malatiyaa bak'etsaan k'achcha; yaatooppe, tiraan wotsiyaawe s'eessaappe k'ommonna de'iyaa diraw, k'ashuu shol\"enna. ");
INSERT INTO dwrl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«Aaroone Geeshsha sa'aa geliyaa wode, ha tiraan wotsiyaa Med'inaa Godaa sheniyaa bessiyaawe de'iyaa Israa'eeliyaa zaratuwaa suntsatuwaa tookko. Yaatooppe taani Med'inaa Goday ubbaade ta asaa hassayana. ");
INSERT INTO dwrl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","K'ay Uuriimiyaanne Tuumiimiyaa geetettiyaawantta tiraan wotsiyaawaan yegga. Aaroone Med'inaa Godaa sintsa aad'd'iidde, bare tiraan wotsi akkiide gelo. Ta shenii ayentto Israa'eeliyaa asaa erissana mala, I ta sintsan ootsanaw geliyaa wode ubbaan bare tiraa kiisiyaappe d'ayssoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Eefuudiyaappe garssanna mayiyaa adussa mayuwaa ubbaa saluwaa malatiyaa c'ark'k'iyaappe giigissa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","He adussa mayoo k'ood'iyaa aatsiyaa sa'aa med'd'a. He sa'ay peed'ettenaadan, yuushsha aatsaade gujja gujja sikka. ");
INSERT INTO dwrl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Adussa mayuwaa duge bagga mac'araa yuushshuwaan saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o roomaaniyaa ayfiyaa teeraa misiletuwaa med'd'a. Yaataade unttunttu gidduwaan work'k'aappe oosetteedda dawalatuwaa walakan ootsa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Work'k'aa dawalatuunne roomaaniyaa teeraa misiletuu he adussa mayuwaa duge bagga s'eeraw yuushshuwaan walakan aad'd'ino. ");
INSERT INTO dwrl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaroone k'eesatetsan ootsiyaa wode, ha adussa mayuwaa mayyo; Med'inaa Godaa sintsa Geeshsha sa'aa geliyaa wodenne kesiyaa wode, dawalay waassana. Hewaa diraw I hayk'k'enna. ");
INSERT INTO dwrl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Walakay baynna work'k'aappe itti alleek'k'uwaa med'd'aade maatafaa bolla wooc'iyaawaadan, Aa bolla wooc'aade, ‹Med'inaa Godaw Geeshsha gidiide Dummateedda› yaagaadde s'aafa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Huup'iyaan s'aas'iyaa shaashiyaappe s'adenna deemuwaan k'achchana mala, saluwaa malatiyaa bak'etsaa an aatsa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaroone Aa bare deemuwaan wotso; hewaan Israa'eeliyaa Asay Med'inaa Godaw geeshsha yarshshoo immiyaawan pac'ay de'ooppe, he bayzzuwaa Aaroone tookkee. Asay ahiyaawaa ubbaa Med'inaa Goday akkana mala, I hewaa ubbaa gedekka bare demuwaan wotsanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Aaroona adussa Shaamic'c'iyaa liik'o liinuwaappe dadda; huup'iyaan s'aas'iyaa shaashiyaakka liinuwaappe giigissa. K'ay danc'c'uwaa s'ilppiyaan alleek'k'issiyaawaan sikissa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaroona naanaw bonchchonne alleek'k'o gidana mala, adussa shaamic'c'iyaa, danc'c'otuwaanne huup'iyaan s'aas'iyaa shaashetuwaa giigissa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Neeni ha mayotuwaa ne ishaa Aaroonanne Aa naanaa mayzzeeddawaappe guyyiyaan, unttuntta k'eesetetsan suntsaade taw ootsana mala okkaadde dummaya. ");
INSERT INTO dwrl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","«Unttunttu kalluu kametana mala garssanna mayiyaa mayuwaa, s'eessaappe biide wodiriyaa gakkanaw kammiyaawaa, liik'o liinuwaa k'ac'inaappe daddaade giigissa. ");
INSERT INTO dwrl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaroonenne Aa naanay S'oossaa Dunkkaaniyaa geliyaa wode, woy yarshshuwaa yarshshiyaa geeshsha sa'aan k'eesatetsan ootsanaw shiik'iyaa wode, ha mayotuwaa mayno. Hewaadan hanooppe, unttunttu barenttu bolla bayzzuwaanne hayk'k'uwaa ahikkino. «Hawe Aaroonawunne Aa zaretoo med'inaw woga gido. ");
INSERT INTO dwrl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Aaroonenne Aa naanay k'eesatuwaa gidiide taw ootsana mala, neeni unttuntta dummayanaw hawaadan ootsa; tilla bollaanna de'iyaa itti korumaa, laa\"u dorssaa koletuwaa akka; ");
INSERT INTO dwrl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","muruta zarggaa d'iiliyaa akkaade, irshshuwaa yeggenaan ukitsaa uukka; k'ay irshshuwaa yeggenaan zayitiyaan komppuwaa komppa; hewaaddankka, irshshuwaa yeggenaan lee\"o ukitsaa uukkaade, zayitiyaa okka. ");
INSERT INTO dwrl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Neeni unttuntta samppan wotsaade, korumaananne laa\"u dorssaa koletuwaanna ittippe taw shiishsha. ");
INSERT INTO dwrl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«Yaataade Aaroonanne Aa naanaa S'oossaa Dunkkaaniyaa pengge ahaade, haatsaan unttuntta meec'c'a. ");
INSERT INTO dwrl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Hewaappe guyyiyaan mayotuwaa akkaade, adussa shaamic'c'iyaa, eefuudiyaa garssana mayiyaa adussa mayuwaa, eefuudiyaanne tiraan wotsiyaawaa Aaroona mayzzaade eefuudiyaa hiillan dadetteedda danc'c'uwaan danc'c'issa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Shaashiyaakka Aa huup'iyaan s'aas'aade, ‹S'oossaw geeshsha gidiide dummatteedda› yaagiyaawe s'aafetteedda alleek'k'uwaa sintsa demuwaan shaashiyaa miyiyaan aatsa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Okkiyaa zayitiyaakka akkaade, Aa huup'iyaan tigaade okka. ");
INSERT INTO dwrl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Aa naanaakka ahaade adussa shaamic'c'iyaa mayza. ");
INSERT INTO dwrl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Shaashiyaakka unttunttu huup'iyaan s'aas'a. Hewaappe guyyiyaan Aaroonanne Aa naanaa danc'c'uwaa danc'c'issa. K'eesatetsay unttunttoo med'inaa woga gido. Simmi Aaroonanne Aa naanaa yaataade k'eesatuwaa ootsaasa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«Korumaa, S'oossaa Dunkkaaniyaa sintsa neeni ahina, Aaroonenne Aa naanay Aa huup'iyaan barenttu kushiyaa wotsiino. ");
INSERT INTO dwrl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Korumaa, Med'inaa Godaa Dunkkaaniyaa geliyaa penggiyaan Med'inaa Godaa matan shukka. ");
INSERT INTO dwrl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Korumaa suutsaappe amareedawaa ne birad'd'iyaan akkaade, yarshshiyaa sa'aa bolla de'iyaa kac'etuwaa okkishshin atteedawaa yarshshiyaa sa'aappe garssa baggana gussa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Hewaappe guyyiyaan k'antsaa ashuwaa kammeedda mood'iyaa ubbaa, tiriyaa s'eeraa bolla de'iyaa mood'iyaa, laa\"u kilahotuwaanne unttuntta kameedda mood'iyaa akkaade, yarshshiyaa sa'aa bolla s'uugga. ");
INSERT INTO dwrl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Shin korumaa ashuwaa, Aa galbbaanne Aa marac'c'iyaan de'iyaa toc'iyaa Asay utto heeraappe haasaade s'uugga; hewe nagaraa diraw yarshshiyaa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«Laa\"u dorssaa koletuwaappe ittuwaa neeni akkina, Aaroonenne Aa naanay barenttu kushiyaa Aa huup'iyaan wotsino. ");
INSERT INTO dwrl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Yaatooppe dorssaa koliyaa shukkaade, suutsaa yarshshiyaa sa'aa miyyiyaan ubbaa sa'aan pushakka. ");
INSERT INTO dwrl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Dorssaa koliyaa ashuwaa k'ans's'ereetsaade, k'antsaa ashuwaakka gediyaa meec'c'aade huup'iyaa bollanne hara k'ommo ashotuwaa bolla unttuntta wotsa; ");
INSERT INTO dwrl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","hewaappe guyyiyaan, dorssaa koliyaa ubbaanna yarshshiyaa sa'aan s'uugga; hewe Med'inaa Godaw s'uugettiyaa yarshshuwaa, sawuwaa toshikku giyaa yarshshuwaanne Med'inaa Godaw taman yarshshiyaa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«K'ay yenkko dorssaa koliyaa Aaroonenne Aa naanay barenttu kushiyaa Aa huup'iyaan wotsana mala neeni aha. ");
INSERT INTO dwrl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","He dorssaa koliyaa shukkaade, Aa suutsaappe amareedawaa akkaade, Aaroonawunne Aa naanaw ushechcha haytsatuwaa s'eeraa, unttunttu ushechcha kushetoo wogga birad'd'etuwaanne unttunttu ushechcha gedetoo wogga birad'd'etuwaa okka; hewaappe guyyiyaan, atteeda suutsaa yarshshiyaa sa'aa miyyiyaan ubbaa sa'aan pushakka. ");
INSERT INTO dwrl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Yarshshiyaa sa'aan de'iyaa suutsaappe amareedawaanne tigiyaa zayitiyaappekka amareedawaa akka, Aaroona bollanne Aa mayuwaa bolla, Aa naanatuwaa bollanne unttunttu mayuwaa bolla pushakka. Inne Aa naanay, unttunttu mayuu S'oossaa oosoo dummatanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«Ha dorssaa koliyaappe mod'd'uwaa, nasiyaa, k'antsaa ashuwaa bolla de'iyaa mood'iyaa, tiriyaa s'eeraa bolla de'iyaa mood'iyaa, laa\"u kilahotuwaa, unttuntta kammeedda mood'iyaanne ushechcha baggana de'iyaa guyye gediyaa akka; hawe k'eesatetsaa suntsaa immiyaa wode shukkiyaa dorssaa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Med'inaa Godaa sintsan wotseedda irshshuu gelibeenna ukitsaa, samppaappe zayitii walakettibeenna ukitsaa, zayitiyaanna uukkeedda itti komppuwaanne itti lee\"o ukitsaa akka. ");
INSERT INTO dwrl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Neeni ha k'umaa ubbaa Aaroona kushiyaaninne Aa naanatuwaa kushiyaan wotsiide wus'akkanaadan ootsa. Unttuntta Med'inaa Godaa sintsan pudenne dugenne k'aatsino. ");
INSERT INTO dwrl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Hewaappe guyyiyaan unttunttu kushiyaappe hawantta akkaade, yarshshiyaa sa'aa bolla wotsaade, s'uuggiyaa yarshshuwaanna gatsaade, Med'inaa Godaw sawuwaa toshikku gaanaadan, yarshshiyaa sa'aa bolla taman s'uugga. ");
INSERT INTO dwrl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Aaroone k'eesa gidiide suntsettiyaa wode shukkeedda dorssaa koliyaa anggoosuwaa akkaade, Med'inaa Godaa sintsan k'aatsiyaa yarshshuwaadan k'aatsaa; hewe neena gakkiyaa ne miyaa gishuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«He shukkeedda dorssaa ashuwaa k'ommotuwaappe, yarshshuwaa ootsiide k'aatseedda anggoosuwaanne S'oossaa sintsan pude tookkeedda gediyaa geeshsha; hewanttu Aaroonawunne Aa naanaw gishuwaa gidanawantta. ");
INSERT INTO dwrl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Israa'eelatuu Med'inaa Godaw immiyaa ittippetetsaa yarshshuwaappe k'aatsiyaa baggaw wogay, ubbaa gedekka Israa'eeliyaa asaappe shiik'oode Aaroonawunne Aa naanaw gakkiyaa gishuwaa gido. ");
INSERT INTO dwrl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Aaroona k'eesatetsaa geeshsha mayuu Aa hayk'k'uwaappe guyyiyaan Aa zaretoo de'o; unttunttu k'eesatuwaa kaappuwaa gidiyaa wode ha mayuwaa oketanawunne dumatanaw mayyino. ");
INSERT INTO dwrl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Aa naanatuwaappe Aa sa'aan k'eesatuwaa gidiide, Geeshsha Sa'aan ootsanaw S'oossaa Dunkkaaniyaa yiyaa na'ay, he mayuwaa laappun gallassaw mayyo. ");
INSERT INTO dwrl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Aaroonenne Aa naanay k'eesatuwaa gidiide suntsettiyaa wode shuketteedda dorssaa koliyaa ashuwaa akkaade, geeshsha sa'aan doyssa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaroonenne Aa naanay dorssaa orggiyaa ashuwaakka masoofiyaan de'iyaa ukitsaa S'oossaa Dunkkaaniyaa geliyaa penggiyaan miino. ");
INSERT INTO dwrl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Unttunttu k'eesatuwaa gidiide suntsettanawunne dummatanaw nagaray atto geetettanaadan yarshshetteedda ha yarshshotuwaa miino. Shin he yarshshotuu geeshsha gideedda diraw, hara Asay onne mooppo. ");
INSERT INTO dwrl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","K'eesiyaa gidiide suntsettiyaa wode shukkeedda dorssaa koliyaa ashuwaappe woy Ukitsaappe wontta gakkanaw palahiide ak'ooppe, taman s'uugetto; geeshsha gideedda diraw meetettoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«Aaroonenne Aa naanay k'eesatuwaa gidiide suntsettiyaa wode wotsiyaa wogaa likke taani neena azazeeddawaadan ootsaadde, laappun gallassaa garssan pola. ");
INSERT INTO dwrl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Nagaray atto geetettanaadan hachche hachche nagaraa yarshshuwaadan itti korumaa yarshsha. Hewaan yarshshiyaa sa'aa geeshsha; yaataade yarshshiyaa sa'aa dummayanaw okka. ");
INSERT INTO dwrl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Yarshshiyaa sa'aa nagaraa atto giyaa wogaa laappun gallassan polaade, Aa dummaya. Yaatooppe yarshshiyaa sa'ay geeshsha ubbaappe ittuwaa gideedda geeshsha. Aa bochchiyaa ubbaykka geeyyana. ");
INSERT INTO dwrl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Yarshshiyaa sa'aan neeni hachche hachche shiishshana yarshshuu hawaa. Yelettoodeppe itti laytsaa gideedda laa\"u dorssaa orggetuwaa yarshsha. ");
INSERT INTO dwrl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Dorssaa koletuwaappe ittuwaa wontta, k'ay laa'entsuwaa omarssi yarshsha. ");
INSERT INTO dwrl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Koyro dorssaa maraanna itti kiilo giraame gideedda muruta zarggaa d'iiliyaa itti liitiro gum\"eteedda zayitiyaan munak'aade yarshsha; itti liitiro woyniyaa eessaakka ushshaa yarshshuwaa ootsaadde yarshsha. ");
INSERT INTO dwrl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Laa\"entso dorssaa orggiyaa omarssi yarshshaadde wonttawaa keeshshaa, d'iiliyaa, zayitiyaanne woyniyaa eessaa shiishsha. Hewe Med'inaa Godaw taman yarshshettiyaa, sawuwaa toshikku giyaa yarshshuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","«Ha s'uuggiyaa yarshshuu yiyaa yeletaa ubbaan S'oossaa Dunkkaaniyaa geliyaa penggiyaan Med'inaa Godaa sintsan pac'c'i baynnan yarshshettanaw koshshee. Taani yaan hinttenttunna gakettaade, neenana haasayana. ");
INSERT INTO dwrl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","K'ay yaan taani Israa'eelatuwaana gakettanaw, ta bonchchuukka he sa'aa duma sa'aa kessana. ");
INSERT INTO dwrl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","«Hewaa diraw, taani S'oossaa Dunkkaaniyaanne yarshshiyaa sa'aa dummayana; unttunttu taw k'eesatuwaa gidiide taw ootsana mala, Aaroonanne Aa naanaa taani dummayana. ");
INSERT INTO dwrl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Yaataade taani Israa'eeletuwaa giddon de'ana; k'ay taani unttunttu S'oossaa gidana. ");
INSERT INTO dwrl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Taani unttunttu giddon de'ana mala, Gibs'eppe unttuntta kesseedda Med'inaa Godaa unttunttu S'oossaa gidiyaawaa unttunttu erana. Ee, taani Med'inaa Godaa unttunttu S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Is'aanaa c'uwayiyaa miishshaa odoorotuwaappe med'd'a; ");
INSERT INTO dwrl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","aw oyddu gas'ay de'o; adusatetsay itti wad'aa, gomppay itti wad'aa, geesay laa\"u wad'aa gido; kac'etuukka aanana ittuwaa gidiide oyk'k'etti med'ettino. ");
INSERT INTO dwrl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Aw bolla doonaa, oyddu bagga ubbaanne Aa kac'etuwaa walakay baynna work'k'aan sheeshsha; Aa yuushshuwaankka work'k'aa tigetsaa yuushsha aatsa. ");
INSERT INTO dwrl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","He work'k'aa tigetsaappe garssanna is'aanaa c'uwayiyaa saas'iniyaw work'k'aappe laa\"u sagaayetuwaa med'd'a; yaataade ya baggananne ha baggana laa\"uwaa laa\"uwaa oytsa. Hewantta tookkiyaa wode kasuwaa aatsanaw maaddanaassa. ");
INSERT INTO dwrl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kasotuwaa odoorotuwaappe kessaade, unttuntta work'k'aan sheeshsha. ");
INSERT INTO dwrl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ha yarshshiyaa miishshaa K'aalaa C'aak'uwaa Taabootaa sintsan kak'etteedda gaaridduwaappe kare baggana, hewaakka taani neenana gaketiyaa K'aalaa C'aak'uwaa Taabootaa bolla de'iyaa atto giyaa sa'aa k'um\"iyaa sintsan wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","«Aaroone wontta wontta s'omppetuwaa giigisanaw yiyaa wode, sawiyaa is'aanaa yarshshiyaa sa'aan c'uwayo. ");
INSERT INTO dwrl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aaroone omarssi s'omppetuwaa poo'issiyaa wode, zaaretsiidekka is'aanaa c'uwayo; yaatooppe, is'aanay Med'inaa Godaa sintsan yiyaa yeletaw ubbaade c'uwattana. ");
INSERT INTO dwrl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ha is'aanaa c'uwissiyaa miishshaan hara ay is'aananne, woy s'uugiyaa yarshshuwaa, woy katsaa yarshshuwaa yarshshoppa; ushshaa yarshshuwaakka Aa bolla tigoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaroone laytsaappe itti gede nagaraappe maarettanaw shukkiyaa mehiyaa suutsaa akkiide, he yarshshiyaa sa'aa bolla de'iyaa kac'etuwaa bolla wotso. Yaatiide geeshshiyaa wogaa polo. Ha wogay sintsanna yaana wodetuwaa ubbaan laytsaan laytsaan poletto. Ha is'aanay c'uwiyaa miishshay Med'inaa Godaw dummati loytsi geeyeeddawaa gido» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Hewaappe guyyiyaan Med'inaa goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Neeni Israa'eeliyaa asaa payduwaan akkanaw unttuntta paydiyaa wode, itti itti uray paydettiide, bare shemppuwaa wozanaw Med'inaa Godaw shaluwaa c'iggo. Neeni unttuntta paydiyaa wode, unttunttu bolla boshay yeenna. ");
INSERT INTO dwrl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Payduwaan geliyaa Asay huup'iyaan huup'iyaan Dunkkaaniyaan eretiyaa miizaanaa likkiyaan Biraa c'iggo. Itti itti uray hawaa Med'inaa Godaw imotaa ootsiidde immo. ");
INSERT INTO dwrl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Payduwaan geliyaa Asay laytsay laatamu kumeeddawenne hewaappe bollaa ubbay, Med'inaa Godaw immiyaawaa aho. ");
INSERT INTO dwrl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Hinttenttu hinttenttu nagaraappe maarettanaw Med'inaa Godaw imuwaa immishin, duriikka mank'k'uukka itti likkiyaa immanaappe attina, durii darissiide woy mank'k'uu laafetsiidde immoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Nagaraappe maretanaw c'iggiyaa shaluwaa Israa'eeliyaa asaappe akkaade, Med'inaa Godaa Dunkkaaniyaa giddo oosoo peeshsha. Ha shaluu hinttenttu nagaraappe maarettanaw, Med'inaa Godaa sintsan Israa'eeliyaa asaawaa hassayiyaawaa gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Hewaappe guyyiyaan Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Meechchaa keriyaanne Aa wotsiyaawaa nahaasiyaappe med'd'aade S'oossaa Dunkkaaniyaappenne yarshshiyaa sa'aappe gidduwaan wotsa; an haatsaa tiga. ");
INSERT INTO dwrl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaroonenne Aa naanay barenttu kushiyaanne barenttu gediyaa meec'ettana. ");
INSERT INTO dwrl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Unttunttu hayk'k'enna mala, S'oossaa Dunkkaaniyaa geliyaa wode, awudenne he haatsaan meec'ettino. K'ay Med'inaa Godaw taman yarshshuwaa yarshshanaw yarshshiyaa sa'aa mata shiik'eedda wode, ");
INSERT INTO dwrl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","unttunttu hayk'k'enna mala, barenttu kushiyaanne barenttu gediyaa meec'ettino. Hawe Aaroonawunne Aa zaretoo, yiyaa yeletaa ubbaw med'inaw woga gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Muruta k'imaametuwaa, hewanttukka, usuppun kiilo giraame gukkiyaa karbbiyaa, heezzu kiilo giraame sawiyaa k'arafaa, heezzu kiilo giraame sawiyaa gunc'echchaanne ");
INSERT INTO dwrl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","usuppun kiilo giraame zimbbaanuwaa akka. Ha ubbaykka Dunkkaaniyaan eretiyaa miizaanaa likkiyaan gido. Hewaa bollakka oyddu liitiro Wogaraa zayitiyaa gujja. ");
INSERT INTO dwrl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Hawantta shittuwaa ootsiyaa eran walakkaade, sawiyaa geeshsha okkiyaa zayite kessa. ");
INSERT INTO dwrl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Yaataade S'oossaa Dunkkaaniyaa, K'aalaa c'aak'uwaa Taabootaa, ");
INSERT INTO dwrl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","s'arp'p'eezaanne Aa bolla wotsiyaa miishshaa ubbaa, s'omppiyaa wotsiyaa ballanne Aa miishshatuwaa, is'aanaa c'uwayiyaa miishshaa, ");
INSERT INTO dwrl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","s'uuggiyaa yarshshuwaa yarshshiyaa sa'aanne an de'iyaa ubbaa miishshatuwaa, meechchaa keriyaanne Aa wotsiyaawaa okka. ");
INSERT INTO dwrl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Unttunttu loytsi geeshsha gidana mala, neeni unttuntta dummaya; unttuntta bochchiyaawe ubbaykka geeshsha gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","«Hewaappe guyyiyaan Aaroonenne Aa naanay k'eesatuwaa gidiide taw ootsana mala, unttuntta okkaadde dummaya; ");
INSERT INTO dwrl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israa'eeliyaa asaw hawaadan yaagaadde oda; ‹Hawe yiyaa yeletawukka okettiyaa ta geeshsha zayite gido; ");
INSERT INTO dwrl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ha zayitiyaa asaa bollan gussoppa; k'ay ay zayitiikka hewaa ootseedda likkiyaan ootsoppa. I geeshsha gideedda diraw, hinttenttukka Aa geeshshabaadan k'oppite. ");
INSERT INTO dwrl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Hawaa mala shittuwaa giigissiyaa uraynne k'eesatuwaa gidenna hara asaa okkiyaa uray ooninne bare asaa giddoppe bohetto› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Hewaappe guyye Med'inaa Goday Musa hawaadan yaageedda; «Sawiyaa k'imaametuwaa: mitsaa c'ooshshaa, d'aad'd'iyaa gollen de'iyaa shittuwaa, sawiyaa shidiyaanne sawiyaa geeshsha is'aanaa akka; unttunttu ubbaa dees'uukka itti likke gido. ");
INSERT INTO dwrl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Shittuwaadan walaketteedda is'aanaa ootsaade, unttunttun go'etta; walakay baynnawaanne geeshsha gidanaadan, an mas'iniyaa yegga. ");
INSERT INTO dwrl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Aappe amareedawaa akkaade liik'issaade c'adda; yaataade taani neenana gaketiyaa S'oossaa Dunkkaaniyaa giddon K'aalaa c'aak'uwaa Taabootaa sintsan wotsa. I new loytsi geeshsha gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Hawaa med'd'eeddawaa likkiyaan hara is'aanaa med'd'oppite. Hewe Med'inaa Godaw dumma geeshsha gidiyaawaa erite. ");
INSERT INTO dwrl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Hawaa malatiyaawaa med'd'iide, Aa sawuwaa singgiide nashettanaw koyiyaa uray de'ooppe, I bare asaa giddoppe bohetto» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Be'a; taani Yihudaa zare gideedda Huura na'aa na'aa, Uura na'aa, Bas'aali'eela dooraad. ");
INSERT INTO dwrl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Aa taani S'oossaa Ayyaanan, hiillan, akeekaaninne oosuwaa ubbaa ootsiyaa eraan kuntsaad; ");
INSERT INTO dwrl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","hewekka hiillan kiitaa halchchuwaa kessiide, work'k'aappe, biraappenne nahaasiyaappe dumma dummabaa I ootsanaassa. ");
INSERT INTO dwrl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Hewaadankka, shuchchaa massiide giigissanaaddaaninne, mitsaa massanaw hara oosuwaa ubbaa I ootsanaassa. ");
INSERT INTO dwrl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","«Hewaa bollakka k'ay Aa maaddana mala, Daana zare gideedda Ahisamaaka na'aa Oholi'aaba suntsaad. Taani neena azazeeddawaa ubbaa unttunttu ootsana mala, kushiyaa hiillaa eriyaawanttoo ubbatoo eraa immaad. ");
INSERT INTO dwrl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Unttunttu ootsanaw: S'oossaa Dunkkaaniyaa, K'aalaa c'aak'uwaa Taabootaa, Aa bolla wotsiyaa atto giyaa sa'aa k'um\"iyaa, S'oossaa Dunkkaaniyaa giddon go'ettiyaa miishshaa ubbaa, ");
INSERT INTO dwrl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","s'arp'p'eezaanne Aa miishshatuwaa, s'omppiyaa wotsiyaa ballaa walakay baynna work'k'aappe oosetteeddawaanne Aa miishshaa ubbaanna, is'aanaa c'uwissiyaa miishshaa, ");
INSERT INTO dwrl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","s'uuggiyaa yarshshuwaa yarshshiyaa sa'aanne Aa miishshaa ubbaanna, meec'ettiyaa keriyaanne Aa wotsiyaawaanna, ");
INSERT INTO dwrl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","dadetteedda mayuwaa, k'eesatuwaa ubbatuwaa kaappuu Aaroone mayyana geeshsha k'eesatetsaa mayotuwaanne Aa attuma naanay k'eesatetsaa ootsiidde mayyana mayuwaa, ");
INSERT INTO dwrl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","k'ay okettiyaa zayitiyaanne Geeshsha Sa'aw sawuwaa toshikku giyaa is'aanaa. Unttunttu hawaa ubbaa taani neena azazeeddawaadan ootsino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Hewaappe guyyiyaan Med'inaa Goday Musa hawaadan yaagiide azazeedda; ");
INSERT INTO dwrl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Israa'eeliyaa asaa neeni, ‹Ta Sambbataa bonchchite. Hewe taani Med'inaa Goday hinttentta taw geeshsha ootsaadde dooreeddawaa bessiyaawaa gidiide, yaana yeletaa ubbaw taappenne hintteppe gidduwaan malaataa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Hinttenttoo I geeshsha gidiyaa diraw, Sambbataa bonchchite. Aa tunissiyaawenne he gallassaan ootsiyaa Asay ubbay asaa gidoppe hayk'k'uwaan bohetto. ");
INSERT INTO dwrl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Usuppun gallassatuwaan neeni oosuwaa ootsa; shin laappuntsa gallassay Med'inaa Godaw dummatteedda shemppo Sambbataa; Sambbataa gallassan ay oosonne ootsiyaa ooninne hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israa'eelatuu ha Sambbataa gallassaa yeletaappe yeletaw med'ina k'aalaa c'aak'uwaa ootsiide bonchchino. ");
INSERT INTO dwrl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Med'inaa Goday usuppun gallassatuwaan saluwaanne sa'aa med'd'eedda dirawunne k'ay laappuntsa gallassan taani kiitaa aggaade shemppeedda diraw, ta gidduwaaninne Israa'eelatuu gidduwaan hawe med'inaw malaata gidana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Med'inaa Goday Musew Siinaa Deriyaa bollan haasayiyaawaa wursseedda wode, S'oossay bare birad'd'iyaan s'aafeedda tammu azazuwaa oyk'k'iide laa\"u massetteedda k'aalaa c'aak'uwaa shuchchatuwaa Musew immeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Asay Muse deriyaappe wod'd'ennaan loytsi gam\"eeddawaa be'eedda wode, Aaroona yuushshuwaan shiik'iide, «Haaya; neeni nuuna kaaletsiyaa s'oossatuwaa nuw med'd'a. Gibs'e gadiyaappe nuuna kesseedda Musa gidooppe, I waaneedenttonne nuuni erokko!» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaroone unttuntta, «Hinttenttu machatuwaa haytsaaninne hinttenttu attuma naanaanne mac'c'a naanatuwaa haytsaan de'iyaa work'k'aa kessiide, taw akkiide ahite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Hewaappe guyyiyaan Asay ubbay bare haytsaa work'k'aa kessiide, Aaroonaw aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","I hewaa unttunttu kushiyaappe akkiide, siiliseeddawaappe guyyiyaan k'os's'iyaaban k'os's'iide, maraa malatiyaa eek'aa ootsiidde med'd'eedda. Asay, «Israa'eelatoo, hinttentta Gibs'e gadiyaappe kesseedda hinttenttu s'oossatuu hawantta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaroone hawaa be'eedda wode, he maraa sintsan yarshshiyaa sa'aa gimbbiide, «Wontta Med'inaa Godaa baalaa gallassaa gidanawaa» yaagiide eriseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Hewaa diraw, wonttetsa gallassi Asay guuran denddiide, s'uuggiyaa yarshshuwaa shiishsheedda; ittippetetsaa yarshshuwaakka yarshsheedda. Yaatiide Asay maanawunne ushanaw utteedda. Mi ushi simmiide, k'ay duranaw denddeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yaanina Med'inaa Goday Musa, «Neeni ellekka duge wod'd'a; ayaw gooppe, ne asay, neeni Gibs'eppe kessaade aheeddawe nagaraa ootsiidde, barenttu huup'iyaa tunisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Taani unttuntta azazeedda ogiyaappe unttunttu ellekka sher\"i geeddino. Work'k'aa siiliseedda maraa malatissiide, barenttoo eek'aa med'd'iide aw goynneeddino; aw yarshsheeddino. Unttunttu, ‹Israa'eelatoo, hinttentta Gibs'e gadiyaappe kesseedda hinttenttu s'oossatuu hawantta› yaageeddino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Med'inaa Goday Musa, «Taani ha asaa be'aad; unttunttu morggii d'uleefatteedda asaa. ");
INSERT INTO dwrl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ha\"i ta hank'k'uu unttunttu bolla ees's'i kesina, taani unttuntta bayzzanawaa neeni taana diggoppa. Yaataade taani neena wolk'k'aama kawutetsaa ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Shin Muse Med'inaa Godaa bare S'oossaa hawaadan yaagiide woosseedda; «Abeet Med'inaa Godaw neeni ne wolk'k'aama wolk'k'aaninne ne mino kushiyaan Gibs'eppe kessaade aheedda ne asaa bolla ne hank'k'uu ayaw ees's'i kesi? ");
INSERT INTO dwrl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Gibs'etuu, ‹S'oossay unttuntta deretuwaa bollan wod'anawunne gadiyaappe pitti d'ayssanaw, iita halchchuwaan kesseedda› ayaw ginoo? Ne yashshiyaa hank'k'uwaappe simma; ne asaa d'ayssanaw k'oppowaa agga basha. ");
INSERT INTO dwrl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ne ayiletuwaa Abrahaama, Yisaak'anne Yaak'ooba hassaya; neeni unttunttoo, ‹Taani hinttenttu zariyaa saluwaa s'oolinttetuwaadan darssana; ha taani hinttenttoo immana geedda gadiyaa ubbaakka hinttenttu zariyaw immana; unttunttu he gadiyaa med'inaw laattana› gaade ne huup'iyaan neeni c'aak'k'eedda k'aalaa hassaya» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Hewaa diraw, Med'inaa Goday bare asaa bolla iitabaa ahanaw odeeddawaa aggiide, unttuntta maareedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Hewaappe guyyiyaan Muse tammu azazatuu unttunttun s'aafetti utteedda laa\"u Markkatetsaa shuchchatuwaa bare kushiyaan oyk'k'iide, deriyaappe duge wod'd'eedda. He shuchchatuu laa\"u bagganakka s'aafetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","He masetteedda shuchchatuwaa giigisseeddawe S'oossaa; shuchchaa bolla wooc'iide s'aafeeddawekka S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Iyyaasu asaa c'abbuwaa siseedda wode, Musa hawaadan yaageedda; «Dunkkaaneedda sa'aan olaa waasuu sisetee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Muse zaariide, «Taani sisiyaawe hawe yetsaappe attina, s'ooneeddawanttu kooshshaa woy s'oonetteeddawanttu kooshshaa gidenna» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Muse dunkkaaneedda sa'aa mateedda wode, maraanne duruwaa be'iide loytsi hank'k'ettiide bare kushiyaan oyk'k'o markkatetsaa shuchchatuwaa deriyaa s'ap'uwaan oliide mentsereetseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Unttunttu med'd'eedda maraakka akkiide, taman s'uuggeedda; hewaappe guyyiyaan liik'ana gakkanaw gaac'c'iide haatsaa bolla laaliide, Israa'eeliyaa Asay ushanaadan ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Hewaappe guyyiyaan, Muse Aaroona, «Ha Asay neena wootinee neeni unttuntta hawaa mala wolk'k'aama nagaraw kaaletseeddawe?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaroonikka zaariide, «Ta godaw, hank'k'etoppa; ha Asay iitaa ootsanaw ay keeshshaa koyintto neeni eraasa. ");
INSERT INTO dwrl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Unttunttu taana, ‹Nuuna kaaletsiyaa s'oossatuwaa nuw med'd'a. Ayaw gooppe, ha nuuna Gibs'eppe aheedda Muse I waaneedenttonne nuuni erokko!› yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Taani unttuntta, ‹Hintte bolla de'iyaa work'k'aa kessiide, hammite› yaagaad. Hewaappe guyyiyaan unttunttu taw immeedda work'k'aa taani taman yeggina, ha maray keseedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Aaroone asaa gede c'oo yeddi aggina, Asay bare morkkatuwaa sintsan kawushiide kad'etteeddawaa Muse be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Hewaa diraw, Muse dunkkaaneedda sa'aa geliyaa penggiyaan ek'k'iide hawaadan yaageedda; «Med'inaa Godaa bagga gideedda Asay ooninne taakko yo!» yaageedda. Leewatuu ubbay aakko shiik'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Hewaappe guyyiyaan I unttuntta, «Med'inaa Goday Israa'eeliyaa S'oossay hawaadan yaagee; ‹Asay ubbay mashshaa bare s'eessan s'eessan danc'c'oo; dunkkaaneedda sa'aan gas'aappe gas'aa gakkanaw, guyyewunne sintsawunne simeretto; ittuu ittuu bare ishaa, bare laggiyaanne bare shooruwaa wod'o yaagee› » yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Leewatuu Muse azazeeddawaadan ootseeddino; he gallassi asaappe heezzu sha\"aa keeshshay hayk'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Hewaappe guyyiyaan Muse Leewatuwaa, «Hachche hinttenttu S'oossaw dummateeddita; ayaw gooppe, hinttenttu hinttenttu naanaanne hinttenttu ishatuwaa wod'anawukka azazeteeddita; hachche Med'inaa Goday hinttentta anjjana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Wonttisa gallassi Muse asaa, «Hinttenttu wolk'k'aama nagaraa ootseeddita; shin ha\"i taani Med'inaa Godaakko pude deriyaa kesana; hinttenttu nagaraa taani atto giissanitanttonne» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Yaatina Muse Med'inaa Godaakko simmi biide hawaadan yaageedda; «Ha Asay wolk'k'aama nagaraa ootseedda; unttunttu barenttoo work'k'aappe s'oossatuwaa med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Shin hayyanaa, ha\"i unttunttu nagaraa atto yaaga; hewe d'ayooppe, neeni s'aafeedda mazggobiyaappe taana k'uc'c'a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Med'inaa Goday zaariide Musa, «Taani ta mazggabaappe k'uc'c'anawe ta bolla nagaraa ootseedda asatuwaa suntsaa. ");
INSERT INTO dwrl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ha\"i baade, ha asaa taani new odeedda sa'aa kaaletsa; ta kiitanchchaykka neena kaaletsana; shin taani muranaw wodii gakkina, unttuntta unttunttu nagaraa diraw murana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aaroone work'k'aappe maraa misiliyaa med'd'anaadan Asay ootseedda diraw, Med'inaa Goday asaa bolla wolk'k'aama boshaa yeddeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Hewaappe guyyiyaan Med'inaa Goday Musa hawaadan yaageedda; «Neeninne neeni Gibs'eppe kesseedda Asay ha sa'aappe denddite; ‹Taani hinttenttu yaratoo immana› yaagaadde wotseedda gadiyaa biite. He gadii taani Abrahaamew, Yisaak'awunne Yaak'oobaw immana yaagaadde c'aak'k'a wotseedda gadiyaa. ");
INSERT INTO dwrl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Taani hinttenttu sintsan kiitanchchaa kiittaade, Kanaanetuwaa, Amooretuwaa, Hiitetuwaa, Parzzetuwaa, Hiiwetuwaanne Yaabuusatuwaa yederssana. ");
INSERT INTO dwrl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Maatsaynne eessay goggiyaa he gadiyaa biite. Shin hinttenttu morggii d'uleefatoo asaa gideedda diraw, taani hinttentta ogiyaan d'ayssanaw, hinttenana biikke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Asay he yashshiyaa oduwaa sisiide loytsi yeekkeedda. He wodiyaappe doommiide ubbaykka bare alleek'k'uwaa aatsiyaawaa aggi basheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ayaw gooppe, Med'inaa Goday Musa hawaadan yaagi wotseedda; «Israa'eeliyaa hawaadan yaaga; ‹Hintte morggii d'uleefatoo asaa. Taani hinttenana haray atto guutsa wodiyaa binttokka, taani hinttentta d'ayssana. Ha\"i simmi hinttenttu alleek'k'uwaa kessi diggite; yaatooppe taani hinttentta ootsanabaa k'achchana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Israa'eelatuu Siinaa Deriyaappe doommiide barenttu alleek'k'otuwaa kessi wotseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Muse dunkkaaniyaa akki afiide, Asay dunkkaano sa'aappe karenna haassiide d'ogeedda. He dunkkaanii, «Gakettiyaa Dunkkaaniyaa» geetettiide s'eesetteedda. Med'inaa Godaa oochchanaw koyiyaa ubbay dunkkaano sa'aappe karenna de'iyaa Gakettiyaa Dunkkaaniyaa bee. ");
INSERT INTO dwrl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Muse he dunkkaaniyaa beedda wode, awudenne Asay ubbay denddiide, bare dunkkaaniyaa penggiyaan penggiyaan ek'k'ee; Muse he dunkkaaniyaa gelana gakkanaw Aa s'eellee. ");
INSERT INTO dwrl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Muse Gakettiyaa Dunkkaaniyaa giddo geleedda wode, shaariyaa tuussay duge wod'd'ee; Med'inaa Goday Musena shaariyaappe haasayishin, he dunkkaaniyaa penggiyaan gam\"ee. ");
INSERT INTO dwrl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Shaariyaa tuussaa he dunkkaaniyaa geliyaa penggiyaan be'eedda wode ubbaan, Asay ubbay bare Dunkkaaniyaa penggiyaan penggiyaan S'oossaw goynnee. ");
INSERT INTO dwrl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Asay bare laggiyaanna haasayiyaawaadan Med'inaa Goday Musena sintsan ek'k'iide, haasayee. Hewaappe guyyiyaan Muse Asay dunkkaaneedda sa'aa guyye simmee; shin Aa maaddiyaa yalagay, Neewi na'aa Iyyaasu, Gakettiyaa Dunkkaaniyaappe shaakettenna. ");
INSERT INTO dwrl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Muse Med'inaa Godaa hawaadan yaageedda; «Neeni taana, ‹Ha asaa kaaletsa› yaagaadda; shin taananna neeni oona kiittanintto, taana erissabeykka. Neeni, ‹Taani neena suntsan eray; k'aykka neeni taanan nashettaadda› yaagaadda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Neeni taana nashsheeddawaa gidooppe, taani neena erana malanne sintsawukka neena nashechchaade de'ana mala, ne ogiyaa taana bessa. Ha Asay ne asaa gidiyaawaa hassaya» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Med'inaa Goday zaariide, «Taani neenana baana; taani neena shemppissana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Yaatina Muse Aa, «Neeni nuunana beennawaa gidooppe, hawaappe nuuna yeddoppa. ");
INSERT INTO dwrl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Neeni nuunana beennan d'ayooppe, taananinne ne asaani neeni nashetteeddawaa Asay ubbay wooti eranawe? Biittaa ubbaan de'iyaa hara asaa ubbaappe taananne ne asaa dummayiyaawe harabay ayee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Med'inaa Goday Musa, «Taani neenan nashetteedda dirawunne neena ne suntsan eriyaa diraw, neeni taana oochcheedda ha yewuwaa taani ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Yaatina Muse, «Ne bonchchuwaa taana bessaarikkii?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Med'inaa Goday, «Taani ta lo\"otetsaa ubbaa ne sintsaana aatsana; ta geeshsha suntsaakka ne sintsaan awaayana. Taani Med'inaa Godaa; taani lo\"anaw koyiyaawanttoo lo\"ana; k'ay k'arettanaw koyiyawanttookka k'arettana. ");
INSERT INTO dwrl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Shin neeni ta deemuwaa be\"akka; ayaw gooppe, ooninne taana be'iide shemppuwaanna de'enna» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Hewaappe guyyiyaan Med'inaa Goday, «Neeni zaallaa bolla ek'k'anaw hawaan ta matan sa'ay de'ee. ");
INSERT INTO dwrl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ta bonchchu aad'd'iyaa wode, taani neena p'alk'k'etteedda zaallaa giddon wotsana; Taani aad'ana gakkanaw, ta kushiyaan neena kammana. ");
INSERT INTO dwrl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Hewaappe guyyiyaan taani ta kushiyaa diggina, neeni ta zokkiiyaa be'anaassa; shin ta som\"i be\"ettena» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Med'inaa Goday Musa hawaadan yaageedda; «Koyrowantta malatiyaa laa\"u shuchchatuwaa massaade giigissa; yaatooppe taani he masetteedda shuchchatuwaa bolla kase neeni mentseedda shuchchatuwaa bollan de'iyaa k'aalatuwaa s'aafana. ");
INSERT INTO dwrl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Wontta wontta pude Siinaa Deriyaa kesanaw giiga; yaataade taana yaan deriyaa huup'iyaan ek'k'a naaga. ");
INSERT INTO dwrl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Neenana ooninne kesoppo; woy deriyaa bolla hak'ankka beettoppo; haray atto dorssaa wudii woy mehiyaa wudiikka deriyaa sintsaan heemettoppo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Hewaa diraw, Muse koyro shuchchatuwaa malatiyaa laa\"u shuchchatuwaa massiide Med'inaa Goday azazeeddawaadan, shuchchatuwaa bare kushiyaan oyk'k'iide, wontta guuraanna pude Siinaa Deriyaa keseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Med'inaa Goday shaariyaan duge wod'd'iide, aanana yaan ek'k'eedda; «Taan Med'inaa Godaa» yaagiide bare suntsaa awaayeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Med'inaa Goday Muse sintsaana hawaadan yaagiide awaayiidde aad'd'eedda; «Taani Med'inaa Godaa; Taani Med'inaa Godaa; k'aretaynne maarotetsay kumeedda S'oossaa, danddayanchchaa, aggena siik'uu dareeddawaanne darii ammanettiyaawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Taani ta aggena siik'uwaa sha\"atoo naagiyaawaa; iitatetsaa, makkalaanne nagaraa atto yaagiyaawaa. Gidooppekka, bayzzowaa murenan aggenawaa; aawotuwaa nagaraa diraw naanaanne naanatuwaa naanaa, heezzentso yeletaanne oyddentso yeletaa gakkanaw muriyaawaa» yaagiide awaayeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Hewaappe guyye Muse ellekka biittaan guufaniide goynneedda; ");
INSERT INTO dwrl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","«Abeet Godaw, neeni taanan nashshetteedawaa gidooppe, nuunanna ittippe dendda. Hawe Asay morggii d'uleefatteeddawaa gidooppenne, nu iitatetsaanne nu nagaraa atto yaagaadde, nuuna ne asaa ootsa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yaatina Med'inaa Goday hawaadan yaageedda; «Taani hinttenana k'aalaa c'aak'uwaa gelaad; hawaappe kase sa'aa ubbaan de'iyaa kawutetsaa ubbaan hani erenna maalaalissiyaabaa ne asaa ubbaa sintsaan ootsana; taani Med'inaa Goday, hinttenttoo ootsiyaa kiitay ay keeshshaa maalaalissiyaabentto neeni unttunttu giddon de'iyaa Asay ubbay be'ana. ");
INSERT INTO dwrl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hachche taani hinttentta azaziyaa azazuwaa naagite; hinttenttu sintsaappe Amooretuwaa, Kanaanetuwaa, Hiitetuwaa, Parzzetuwaa, Hiiwetuwaanne Yaabuusatuwaa taani yederssana. ");
INSERT INTO dwrl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Unttunttu hinttenttoo p'ire gidenna mala, hinttenttu biyaa gadiyaan de'iyaa asaana k'aalaa c'aak'uwaa geloppite. ");
INSERT INTO dwrl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Unttunttu yarshshiyaa sa'aa kolite; unttunttu goynniyaa shuchchatuwaakka mentsereetsite; k'ay Asheero geetettiyaa unttunttu mac'c'a s'oossatti kaashshaa k'ans's'ereetsi olite. ");
INSERT INTO dwrl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Taani Med'inaa Goday k'anaatiyaa S'oossaa gidiyaa diraw, taappe hara s'oossatoo goynnoppite. ");
INSERT INTO dwrl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","«He gadiyaan de'iyaa asatuwaana ayaa k'aalaa c'aak'uwaakka geloppite; ayaw gooppe, unttunttu taanan ammanettennaan is's'iide barenttu s'oossatuwaa kaalliyaa wodenne unttunttoo yarshshiyaa wode, unttunttu hinttenakka shoobbana; hinttenttu unttunttu yarshshotuwaa maana. ");
INSERT INTO dwrl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","K'ay hinttenttu unttunttu mac'c'a naanatuwaappe dooriide, hinttenttu attuma naanaatoo immana; he wode he mac'c'a naanay taanan ammanettennaan is's'iide, barenttu s'oossatuwaa kaalliidde, hinttenttu attuma naanaakka barenttuwaaddan oosissanawantta. ");
INSERT INTO dwrl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Hinttenttoo goynniyaa s'oossatuwaa ayaappekka siilisiide med'd'oppite. ");
INSERT INTO dwrl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Magaage ukitsaa Baalaa bonchchite; taani hinttentta azazeeddawaadan, laappun gallassaw irshshuu gelennaan uuketteedda ukitsaa miite; hewaakka hinttenttu Gibs'eppe keseedda Abiiba aginaan ootsite. ");
INSERT INTO dwrl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Aati uluwaappe bayira yelettiyaa attuma na'aa ubbay tawaa; hinttenttu mehiyaa ubbaappe booraa gidina, woy dorssaa gidina, bayiray tawaa; ");
INSERT INTO dwrl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","koyro yeletteedda hariyaa maraa dorssaa maraanna laammaade woza; wozana d'ayooppe, Aa k'ood'iyaa mentsaade wod'a. Ne naanatuwaappe bayira yeletteedda attuma na'aa ubbaa woza. «Ooninne immiyaawaa oyk'k'ennan, mela kushiyaanna ta sintsaan beettoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Usuppun gallassaa ootsite; shin laappuntsa gallassan shemppite; goshiyaa wodiyaan k'ay katsaa c'akkiyaa wodiyaan laappuntsa gallassan shemppite. ");
INSERT INTO dwrl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Bayira zeretteedda zarggaa hinttenttu c'akkiyaa wode, Saaminttatuwaa Baalaa bonchchite; laytsaa wurssetsa katsaa shiishshiyaa wodekka, Shiishuwaa Baalaa bonchchite. ");
INSERT INTO dwrl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Laytsaan heezzu gede Israa'eeliyaa attuma Asay ubbay Ubbaa Mooddiyaa S'oossaa, Israa'eeliyaa Med'inaa Godaa sintsan beetino. ");
INSERT INTO dwrl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Kawutetsatuwaa taani hinttenttu sintsaappe yederssaade kessana; yaataade hinttenttu zawaa taani aassana. Med'inaa Godaa hinttenttu S'oossaa sintsaan hinttenttu laytsan heezzu gede beettanaw pude kesiyaa wode, ooninne hinttenttu gadiyaa amottenna. ");
INSERT INTO dwrl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Hinttenttu taw suutsaa yarshshuwaa yarshshiyaa wode, irshshuwaa yeggiide uukkeedda ukitsaanna yarshshoppite. Paasigaa bonchchiyaa gallassaw yarshsheedda yarshshuwaappe wonttiw ayaynne attoppo. ");
INSERT INTO dwrl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«Hinttenttu gaden bayira ka\"eedda katsaappe koyro murutaa Med'inaa Godaa hinttenttu S'oossaa golliyaa ahite. «Deeshsha maraa Aa aati maatsan doyssoppite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Med'inaa Goday Musa, «Taani neenananne Israa'eeliyaa asaana k'aalaa c'aak'uwaa geliyaawe ha k'aalatuu giyaa maarana gidiyaa diraw, ha k'aalatuwaa s'aafa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Muse k'umaa meennaaninne haatsaa ushennaan, oytamu gallassaanne oytamu k'ammaa Med'inaa Godaana yan gam\"eedda; k'aalaa c'aak'uwaa k'aalatuwaa, tammu azazuwaa masetteedda shuchchaan s'aafeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Muse S'oossanna haasayiide gam\"eedda diraw, he laa\"u markkatetsaa shuchchatuwaa I bare kushiyaan oyk'k'iide Siinaa Deriyaappe duge wod'd'eedda wode, Aa som\"ii poo'eedda; shin I hewaa eribeenna. ");
INSERT INTO dwrl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaroonenne Israa'eeliyaa Asay ubbay Musa s'eeliide, Aa som\"ii p'ooliyaawaa be'eeddino; Unttunttu aakko shiik'anaw yayyeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Shin Muse unttuntta s'eessina Aaroonenne shiik'uwaa kaaletsiyaa kaappatuu ubbay aakko simmeeddino; I unttuntta haasayisseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Hewaappe guyyiyaan Israa'eeliyaa Asay ubbay aakko shiik'ina Med'inaa Goday aw Siinaa Deriyaan immeedda azazuwaa ubbaa I unttunttoo immeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Muse unttunttoo odiyaawaa wursseedda wode, bare deemuwaa nas'alaan kammeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Shin Muse Med'inaa Godaa sintsa aanana haasayanaw geliyaa wode awudenne kesana gakkanaw, nas'alaa bare som\"uwaappe k'aari diggee. Hewaappe kesiide, Med'inaa Goday azazeeddawaa Israa'eeliyaa asaw odee. ");
INSERT INTO dwrl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Odiyaa wode, unttunttu Aa som\"ii p'ooliyaawaa be'eeddino. Hewaa diraw, Muse Med'inaa Godaana haasayanaw baana gakkanaw, bare deemuwaa zaaretsiidekka nas'alaan kammee. ");
INSERT INTO dwrl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Muse Israa'eeliyaa asaa shiik'uwaa ubbaa shiishshiide hawaadan yaageedda; «Hinttenttu ootsana mala, Med'inaa Goday azazeeddawe hawaa: ");
INSERT INTO dwrl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Saaminttaa giddon usuppun gallassaa kiitaa kiitettite; shin laappuntsa gallassay hinttenttoo geeshsha gallassaa; Med'inaa Godawukka shemppo Sambbataa. He gallassan ay oosonne ootsiyaa uray ooninne hayk'k'anaw bessee. ");
INSERT INTO dwrl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Sambbata gallassan hinttenttu soon soon tamaa eetsoppite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Muse Israa'eeliyaa maabaraw muliyaw hawaadan yaageedda; «Med'inaa Goday hawaadan yaagiide azazeedda: ");
INSERT INTO dwrl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","hinttenttoo de'iyaawaappe Med'inaa Godaw immiyaawaa ahite; Med'inaa Godaw immiyaawaa ahanaw koyiyaa ooninne work'k'aa, biraa, nahaasiyaa, ");
INSERT INTO dwrl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","saluwaa malatiyaa k'ac'inaa, ochchaa teeraa malatiyaa k'ac'inaa, shololla zo'o k'ac'inaanne liik'o suufiyaa, deeshshaa galbbaa, ");
INSERT INTO dwrl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","dorssaa koliyaa galbbaa zo'o k'alamiyaan yeggi kesseeddawaa, k'um\"iyaa, odooruwaa, ");
INSERT INTO dwrl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","s'omppiyaw wogaraa zayitiyaa, okettiyaa zayitiyaanne is'aanaa sawetsiyaa k'imaamiyaa; ");
INSERT INTO dwrl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","eefuudiyaaninne tiraan wotsiyaawaan yeggiyaa marggidiyaa geetettiyaa shuchchatuwaanne hara p'ooliyaa al\"o shuchchatuwaa aho. ");
INSERT INTO dwrl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«Hinttenttu giddon de'iyaa kushiyaa hiillaa eranchcha ubbatuu yiide, Med'inaa Goday azazeedda ubbaa ootsino: ");
INSERT INTO dwrl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Med'inaa Godaa Dunkkaaniyaa, Aa kammiyaa dunkkaaniyaanne Aa kammiyaawaa, oyk'k'iyaawaa, s'agaagetuwaa, shikaalatuwaa, tuussatuwaanne unttunttu ek'k'iyaa lukotuwaa, ");
INSERT INTO dwrl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Taabootaanne Aa tookkiyaa kasuwaa, atto giyaa sa'aa k'um\"iyaawaanne Taabootaa gentsiyaa gaaridduwaa; ");
INSERT INTO dwrl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","s'arp'p'eezaanne Aa tookkiyaa kasuwaa, Aa miishshatuwaa ubbaanne S'oossaa sintsaan wotsiyaa geeshsha ukitsaa; ");
INSERT INTO dwrl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","s'omppiyaa wotsiyaa ballaanne an maarana de'iyaa s'omppetuwaa, miishshatuwaa, s'omppiyaa zayitiyaa, ");
INSERT INTO dwrl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","is'aanaa c'uwayiyaa saas'iniyaanne Aa tookkiyaa kasuwaa, okettiyaa zayitiyaanne sawiyaa is'aanaa, S'oossaa Dunkkaaniyaa penggiyaa gaaridduwaa; ");
INSERT INTO dwrl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","s'uuggiyaa yarshshuwaa yarshshiyaa sa'aanne Aa nahaasiyaa zazziriyaa, Aa tookkiyaa kasotuwaanne Aa miishshatuwaa ubbaa, nahaasiyaappe oosetteedda meechchaa keriyaanne Aa wotsiyaawaa; ");
INSERT INTO dwrl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","soy dabaabaa godaa gaariddotuwaa, tuussatuwaanne unttunttu gedetuwaa, dabaabaa soo giddo geliyaa penggiyaa gaaridduwaa; ");
INSERT INTO dwrl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","S'oossaa Dunkkaaniyaa d'ogiyaa shikaalatuwaa, dabaabaa giddo d'ogetuwaa unttunttu wodorotuwaa; ");
INSERT INTO dwrl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Geeshsha Sa'aan ootsiidde go\"etanaw dadetteedda mayotuwaa, k'eesii Aaroone mayiyaa geeshsha mayuwaa Aa naanay k'eesetetsaa kiitaa ootsiidde mayiyaa mayuwaa med'd'ino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hewaappe guyyiyaan Israa'eeliyaa maabaray ubbay Muse sintsaappe keseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Immanaw koyeeddawanttunne unttunttu wozanay unttuntta imma imma geeddawanttu ubbay yeeddino; Med'inaa Godaa Dunkkaaniyaw, Aa giddon ootsiyaa oosuwaa ubbawunne geeshsha mayoo koshshiyaawaa ubbaa aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Immana koyeedda attumawaa ubbaynne mac'c'awe ubbay yiide, work'k'aappe med'd'eedda alleek'k'iyaawantta, haytsaa gudichchatuwaa, migidatuwaa, hara work'k'aa alleek'k'iyaawantta ahiide Med'inaa Godaw imotaa ootsiidde immeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Saluwaa malatiyaa k'ac'inay, ochchaa teeraa malatiyaa k'ac'inay, shololla zo'o k'ac'inay, woy liinuwaa geetettiyaa liik'o k'ac'inay, woy deeshshaa agoozaa, dorssaa orggiyaa galbbaa zo'o k'alamiyaan yeggi keseeddawe, woy manchchalay de'iyaa Asay ubbay aheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Biraa woy nahaasiyaa immanaw danddayiyaa ubbay barenttu imuwaa Med'inaa Godaw immeeddino; k'ay odooruu de'iyaa Asay ubbay dumma dumma oosoo odooruwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kushiyaa hiilaa eriyaa mac'c'a Asay ubbay barenttu kushiyaan suk'k'eedda saluwaa malatiyaa k'ac'inaa, ochchaa teeraa malatiyaa k'ac'inaa, shololla zo'o k'ac'inaanne liik'o liinuwaa aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","K'aykka imuwaa immanaw koyeedda mac'c'a Asay ubbay deeshshaa agoozaa daddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Kaappatuu eefuudiyaaninne tiraan wotsiyaawaan wotsiyaa marggidiyaanne hara bonchchetteedda shuchchatuwaa aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Unttunttu k'aykka s'omppiyaw, sawiyaa is'aanawunne okanaw haniyaa wogaraa zayitiyaanne k'imaamiyaa aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Israa'eelatuu Asay ubbay, attumawenne mac'c'awe, unttunttu ootsanaadan Med'inaa Goday Muse baggana azazeedda oosoo haniyaa imuwaa ubbaa barenttu sheniyaan Med'inaa Godaw aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Muse Israa'eeliyaa asaa hawaadan yaageedda; «Be'ite; Med'inaa Goday Yihudaa zariyaappe Huura na'aa na'aa, Uura na'aa, Bas'aali'eela dooreedda. ");
INSERT INTO dwrl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Med'inaa Goday Aa S'oossaa Ayyaanan, hiilan, akeekaaninne oosuwaa ubbaa ootsiyaa eran kuntseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Hewekka hiilan kiitaa halchchuwaa kessiide, work'k'aappe, biraappenne nahaasiyaappe dumma dummabaa I udanaassa. ");
INSERT INTO dwrl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Hewaadankka, al\"o shuchchaa massiide giigissanaassa; mitsaa massanaassanne ubbaa k'ommo oosuwaa hiilan ootsanaassa. ");
INSERT INTO dwrl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hewaa bollakka k'ay aasinne Daana zariyaa Ahisamaaka na'aa Oholi'aabaw, hara asaa tamaarissiyaa eraa immeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Unttunttu ubbaa k'ommo oosuwaa ootsanaadan, hiilan ootsiyaawantta, oosuwaa halchchuwaa kessiyaawantta, saluwaa malatiyaa k'ac'inan, ochchaa teeraa malatiyaa k'ac'inan, shololla zo'o k'ac'inaaninne liinuwaa k'ac'inan alleek'k'uwaa daddiyaawanttanne shemayinnetuwaa gidanaadan, S'oossay unttunttu eratetsaan kuntseedda. Unttunttu ubbaykka ubbaa k'ommo oosuwaa lus'iide eriyaa eranchcha gideeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Hewaa diraw, Bas'aali'eeli, Oholi'aabinne Med'inaa Godaa Dunkkaaniyaa kees's'ana malanne oosoo gidiyaa eraa Med'inaa Goday immina, lus'eedda Asay ubbay Med'inaa Goday azazeeddawaadan ubbabaa ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Hewaappe guyyiyaan Muse Basaal\"eela, Oholi'aabanne Med'inaa Goday dumma era immeeddawanttu oosuwaa ootsanaw yaana koyiyaa ubbaa s'eesiide shiishsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Israa'eeliyaa Asay S'oossaa Dunkkaaniyaa ootsanawunne oosoo gidiyaa imotaa ubbaa Museppe akkeeddino. K'ay Asay bare sheniyaan c'oo immiyaa imotaa wontta wontta gujji gujjiide ahiyaawaa aggibeenna. ");
INSERT INTO dwrl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Yaatina S'oossaa Dunkkaaniyaa ootsiyaa eray kumeedda Asay ubbay barenttu oosuwaa aggi bashiide, ");
INSERT INTO dwrl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Musa hawaadan yaageeddino; «Asay Med'inaa Goday azazeedda oosoo koshshiyaawaappe loytsi dariyaawaa ahiide de'ee» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Muse dunkkaaneedda sa'aan de'iyaa asaw hawaadan yaagiide azazeedda; «Laa\"entso ay attuma asaykka ay mac'c'a asaykka S'oossaa Dunkkaaniyaa oosoo immiyaawaa immanaw ahoppo» yaagina, Asay ahiyaawaa aggi basheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ayaw gooppe, unttunttu aheedda imotay oosuwaa ubbaa ootsanaw gidiide palahee. ");
INSERT INTO dwrl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Oosuwaa ootsiyaawanttu giddoppe hiillaa dariyaawanttu ubbatuu liik'o liinuwaappenne saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappe dadetteedda tammu gaarddutuwaappe S'oossaa Dunkkaaniyaa giigisseeddino. He gariddotuwaan itti hiillay kiruubetuwaa misiliyaa daddeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Gaariddotuu ubbay itti likke gidiide, geesay laatamanne hosppun wad'aa; gomppay oyddu wad'aa. ");
INSERT INTO dwrl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ichcheshu gaariddotuwaa ittippe gatsiide sikkeeddino; k'ay yenkko atteeda ichcheshu gaariddotuwaakka unttunttuwaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ittippe gatsiide sikkeedda gaariddutuwaappe itti gaariddoo wurssetsa gas'an saluwaa malatiyaa c'ark'k'iyaappe mac'araa med'd'eeddino. K'ay ittippe gaketi siketteedda yenkko gaaridduwaankka hewaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Unttunttu ittippe gaketteedda itti gaaridduwaa bolla ishatamu mac'araa, k'ay ittippe gaketteedda yenkko gaaridduwaa bollakka ishatamu mac'araa med'd'eeddino. He mac'aratuu ubbaykka ittuu ittoo maaran de'iino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Hewaappe guyyiyaan, work'k'aappe ishatamu oyk'k'iyaawaa med'd'eeddino. Dunkkaanii ittuwaa gidana mala, he gaariddotuwaa gas'aa gas'aa he oyk'k'iyaawanttun oytseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","S'oossaa Dunkkaaniyaa bollana kammiyaa dunkkaaniyaw tammanne itti gaariddotuwaa deeshshaa agoozaappe daddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Tammanne itti gaariddatuukka itti likke; itti itti gaaridduwaa geesay hattamu wad'aa, gomppay oyddu wad'aa. ");
INSERT INTO dwrl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ichcheshu gaariddotuwaa itti baggana, usuppun gaariddotuwaa k'ay yenkko baggana gatsiide sikkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Hewaappe guyyiyaan gatsi sikkeedda gaariddotuwaappe itti gaaridduwaa gas'an ishatamu mac'araa med'd'eeddino. K'aykka gatsi sikkeedda yenkko gaariddotuwaappe wurssetsa gaaridduwaa gas'an ishatamu mac'araa med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Laa\"u baggana de'iyaa gaariddotuwaa gatsiide itti Dunkkaane ootsanaw nahaasiyaappe ishatamu oyk'k'iyaawaa med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Hewaappe guyyiyaan dunkkaaniyaa kammanaw dorssaa orggiyaa galbbaa zo'o k'alamiyaan yeggi kesseeddawaa giigiseeddino; k'ay Aa bollana kammanaw k'um\"iyaa giigiseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","S'oossaa Dunkkaaniyaa s'agaagiyaawantta sitti geedda odoorotuwaappe kesseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Itti itti s'agaagiyaw geesay tammu wad'aa; gomppay itti wad'anne bagga. ");
INSERT INTO dwrl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Itti itti s'agaagiyaw ittuwaa ittuwaanna gatsi oytsiyaa laa\"u pootsatuwaa med'd'eeddino. S'oossaa Dunkkaaniyaa s'agaagetuwaa ubbaakka hewaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","S'oossaa Dunkkaaniyaw gedissa baggana laatamu s'agaagetuwaa med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Itti itti s'agaagiyaw laa\"u gedetuwaa, ubbaanna oytamu pootsay geliyaa lukatuwaa biraappe giigisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","S'oossaa Dunkkaaniyaw huup'issa baggana laatamu s'agaagetuwaa med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Itti itti s'agaagiyaw laa\"u pootsay geliyaa lukatuwaa, ubbaanna oytamu pootsay geliyaa lukatuwaa biraappe giigiseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","S'oossaa Dunkkaaniyaw guyye gas'an away wulliyaa baggana usuppun s'agaagetuwaa med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","S'oossaa Dunkkaaniyaa guyye gas'an de'iyaa gas'atoo laa\"u s'agaagetuwaa giigiseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ha laa\"u gas'atuwaan de'iyaa s'agaagetuwaa s'ap'uwaappe s'eeraa gakkanaw daabula gidi biide, s'eeran itti sagaayiyaan geli oyk'k'etteeddino. Unttunttu laa\"attuukka hewaadan haneeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Hewaa diraw, itti itti s'agaagiyaw garssaana laa\"u laa\"u gedetuu de'iino; ubbaanna hosppun s'agaagetuunne biraappe oosetteedda tammanne usuppun gedetuu de'iino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","K'ay unttunttu odoorotuwaappe shikaalatuwaa kesseeddino; S'oossaa Dunkkaaniyaw itti bagga miyyiyaan de'iyaa s'agaagetoo ichcheshu shikaalatuwaa, ");
INSERT INTO dwrl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","k'ay yenkko bagga miyyiyaan de'iyaa s'agaagetoo ichcheshu shikaalatuwaa giigisseeddino. Hewaadankka, S'oossaa Dunkkaaniyaw guyye away wulliyaa baggana wurssetsa gas'an de'iyaa s'agaagetoo ichcheshu shikaalatuwaa med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Giddo shikaalii s'agaagetoo giddo heeraana, ha gas'aappe ya gas'aa gakkanaw pini kesanaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","S'agaagetuwaa work'k'aan sheeshshiide, shikaalatuu aad'd'iyaa sagaayetuwaa work'k'aappe med'd'eeddino; k'ay shikaalatuwaakka work'k'aan sheeshsheeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Saluwaa malatiyaa, ochchaa teeraa malatiyaanne, shololla zo'o k'ac'inaappenne liik'o liinuwaappe itti gaaridduwaa ootseeddino. He Aa bolla itti hiillay kiruubetuwaa misiliyaa sikkeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Gaariddoo oyddu tuussatuwaa odooruwaappe giigissiide, work'k'aan sheeshsheeddino. Yaatiide work'k'aa kak'k'iyaawantta unttunttoo giigisseeddino. K'ay tuussatuwaa essiyaa oyddu gedetuwaa biraappe med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","S'oossaa Dunkkaaniyaa geliyaa penggiyaw saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne liik'o liinuwaappe daddetteeddawaa, s'ilppiyaa alleek'k'issiyaawaan gaaridduwaa giigisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","K'ay unttuntta kak'k'iyaa ichcheshu tuussatuwaa, kak'k'iyaa ballaana de'iyaawantta med'd'eeddino. Tuussatuu gumbbotuwaanne k'achchiyaawantta work'k'aan sheeshsheeddino. K'ay unttunttu pootsay geliyaa lukotuwaa ichcheshatuwaakka nahaasiyaappe med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bas'aali'eeli odooruwaa mitsaappe Taabootaa giigisseedda. He Taabootay adussatetsay laa\"u wad'anne bagga aduk'k'ee; gomppay itti wad'anne bagga aakkee; geesaykka itti wad'anne bagga d'ok'k'ee. ");
INSERT INTO dwrl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","He Taabootaa giigissiide, soyaanne kariyaa walakay baynna work'k'aan sheeshsheedda; yuushshuwaakka work'k'aa tigetsaan yuushshi aatseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","K'ay oyddu work'k'aa sagaayetuwaa tigiide, Taabootaw oyddu gedetuwaan, itti baggana laa\"u sagaayetuwaa, k'ay yenkko baggana laa\"u sagaayetuwaa aatseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Yaatiide odoorotuwaappe kasuwaa kessiide unttunttakka work'k'aan sheeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Taabootaa tookkanaw, Taabootaa miyyiyaan de'iyaa sagaayetuwaan kasuwaa aatseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Walakay baynna work'k'aappe laa\"u wad'anne bagga aduk'k'iyaa, itti wad'anne bagga aakkiyaa atto giyaa sa'aa k'um\"iyaa med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","K'um\"iyaw wurssetsa laa\"u bagga gas'an laa\"u kiruubeelatuwaa k'os'etteedda work'k'aappe med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Itti kiruubiyaa itti bagga gas'an, laa'entso kiruubiyaa yenkko bagga gas'an, laa'uwaakka k'um\"iyaanna gatsi oytsiidde med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kiruubetuu barenttu k'efiyaa dentsiide, atto giyaa sa'aa kammiyaa k'um\"iyaa barenttu k'efiyaan kuway wotseeddino; k'ay ittuu ittuwaakko simmi uttiide, k'um\"iyaa s'eeliino. ");
INSERT INTO dwrl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","K'ay adussatetsay laa\"u wad'aa, gomppay itti wad'aa, geesaykka itti wad'anne bagga gideedda s'arp'p'eezaa odooruwaappe med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Walakay baynna work'k'aan sheeshsheedda. Yuushshuwaakka work'k'aa tigetsaa yuushshi aatseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hewaadankka, gomppay takkaad'e gideedda shaashiyaa Aa bolla yuushshi aatseedda. Yaatiide Aa bolla work'k'aa tigetsaa yuushsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Oyddu work'k'aa sagaayetuwaa med'd'iide oyddu gedetuu med'etteedda oyddu gas'atuwaana oytseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","S'arp'p'eezaa tookkanaw kasuwaa aatsiyaa sagaayetuu s'arp'p'eezaw shaashiyaa gas'aan shiik'iide med'etteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","S'arap'p'eezaa tookkiyaa kasotuwaakka odooruwaappe kessiide, work'k'aan sheeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Hewaadankka, s'arp'p'eezaa bolla wotsiyaa dumma dumma miishshatuwaa walakay baynna work'k'aappe med'd'eedda; hewanttukka saanetuwaanne c'ilppatuwaa, k'ay ushshaa yarshshuwaa tigiyaa keretuwaanne s'uu'atuwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hewaappe guyyiyaan I s'omppiyaa wotsiyaa ballaa k'os'etteedda walakay baynna work'k'aappe med'd'eedda; he ballaa essiyaa gediyaakka, giddo toomaakka k'os's'eedda work'k'aappe med'd'eedda. Aa kukkumotuwaa, Aa lic'otuwaan Aa c'iishshatuwaa ubbaa aanana ittippe s'omppiidde med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Miyyiyaanna usuppun maratuwaa med'd'eedda; maratuwaa heezzatuwaa itti baggana, k'ay heezzatuwaa yenkko baggana kesseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Usuppun maratookka huup'iyaan huup'iyaan heezzu heezzu kukkumuunne c'iishshatuu de'iyaa lawuziyaa c'iishshaa malatiyaa wanc'c'aa med'd'eedda; ");
INSERT INTO dwrl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","s'omppiyaa wotsiyaa ballaw giddo toomay, kukkumotuwaa c'iishshatuu de'iyaa c'iishshaa malatiyaa oyddu wanc'c'aan alleek'k'etti utteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Laa\"uu laa\"uu ittippe waatsan de'iyaa heezzu maratuwaappe garssana itti itti kukkumay med'etti utteedda ubbaykka usuppun kuukummo. ");
INSERT INTO dwrl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Kukkumatuunne maratuu ubbay s'omppiyaa wotsiyaa ballana ittippe oyk'k'etti ittuwaa gidiide, walakay baynna work'k'aappe k'os'ettiide med'etteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","I k'ay s'omppiyaa wotsiyaa ballaw laappun s'omppetuwaa, s'omppiyaa toyssiyaa k'ap'etuwaanne unttuntta wotsiyaawantta walakay baynna work'k'aappe med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","S'omppiyaa wotsiyaa ballanne an go'ettiyaa miishshaa ubbaa med'd'anaw hattamanne ichcheshu kiilo giraame gideedda walakay baynna work'k'aa wursseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","K'ay is'aanaa c'uwissiyaa sa'aa odooruwaappe med'd'eedda. Aw oyddu gas'ay de'ee; adussatetsay itti wad'aa; gomppay itti wad'aa, geesay laa\"u wad'aa. Aa kac'etuukka aanana ittuwaa gidiide oyk'k'etti med'etteeddawantta. ");
INSERT INTO dwrl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Aw bolla doonaa, oyddu bagga ubbaanne Aa kac'etuwaa walakay baynna work'k'aan sheeshshiide, Aa yuushshuwaakka work'k'aa tigetsaa yuushshi aatseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He work'k'aa tigetsaappe garssana is'aanaa c'uwissiyaa saas'iniyaa work'k'aappe laa\"u sagaayetuwaa med'd'eedda; yaatiide ya baggananne ha baggana laa\"uwaa laa\"uwaa oytseedda. Hewanttu tookkiyaa wode kasuwaa aatsanaw maaddanaadaana. ");
INSERT INTO dwrl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Kasotuwaa odooruwaappe kessiide, unttuntta work'k'aan sheeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","K'ay geeshsha okettiyaa zayitiyaanne sawuwaa toshikku giyaa lo\"o is'aanaa shittuwaa ootsiyaa eran giigisseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Odooruwaappe s'uuggiyaa yarshshuwaa yarshshiyaa sa'aa kees's'eedda. He yarshshiyaa sa'aw geesay heezzu wad'aa, gomppaynne adussatetsay itti likke, ichcheshu ichcheshu wad'aa gidiide, oyddu gas'aana de'iyaawaa ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Oyddu gas'atuwaa wurssetsa gas'an gas'an itti itti kac'iyaa med'd'eedda. He kac'etuu yarshshiyaa sa'aanna ittippe oyk'k'ettiide oosetteeddino. Yaatina yarshshiyaa sa'aa nahaasiyaa birataan sheeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","An go'ettiyaa ubbaa miishshatuwaa, balddetuwaa, akaafatuwaa, bidintsaa shiishshiyaa kuyis'aarotuwaa, ashuwaa oyk'k'iyaa zambeeliyaanne tamaa c'ooc'etuwaa ubbaa nahaasiyaa birataappe med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Yaatiide nahaasiyaa birataappe zazziriyaa yarshshiyaa sa'aw giigissiide yarshshiyaa sa'aw duge giddo baggan de'iyaa shaashiyaa bolla wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Nahaasiyaa birataappe med'd'eedda zazziriyaw oyddu gas'an kasuwaa aatsanaw oyddu sagaayetuwaa med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Odooruwaappe yarshshiyaa sa'aw kasuwaa kessiide, nahaasiyaa birataan sheeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Yarshshiyaa sa'aa tookkiyaa wode maaddana mala, ha kasuwaa laa\"u miyyiyaanna de'iyaa sagaayetuwaan aatseedda. Yarshshiyaa sa'aa gidduwaa kofa kessiide, s'awulaappe med'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Nahaasiyaa birataappe meechchaa keriyaanne Aa wotsiyaawaa med'd'eedda; he biratay Gaketsaa Dunkkaaniyaa penggiyaan ootsiyaa mac'c'a asatuu aheedda heregaappe aketeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Hewaappe guyyiyaan dabaabaa giigisseedda. Dabaabaw gedissa bagga adussatetsaw s'eetu wad'aa ootsiide, liik'o liinuwaappe daddetteedda gaariddotuwaa giigisseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Aw nahaasiyaa birataappe laatamu tuussatuwaanne tuussatuu ek'k'iyaa nahaasiyaa lukatuwaa ootseedda; unttunttu huup'iyaan k'ay biraappe med'etteedda kak'k'iyaawanttanne tuussatuwaa huup'iyaan k'achchiyaawantta ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Dabaabaw huup'issa bagga adussatetsay s'eetu wad'aa adussa; k'ay laatamu tuussatuunne he tuussatoo laatamu nahaasiyaa gedetuu de'iino. Yaatiide biraappe med'etteedda kak'k'iyaawanttunne tuussatuwaa huup'iyaan k'achchiyaawanttu de'iino. ");
INSERT INTO dwrl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Away wulliyaa bagga dabaabaa gomppay ishatamu wad'aa aaka gidiide, tammu tuussatuunne tuussatoo tammu gedetuu de'iyaa gaariddotuwaa giigisseedda; he tuussatuwaa huup'iyaan biraappe med'etteedda kak'k'iyaawanttanne tuussatuwaa huup'iyaan k'achchiyaawantta ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","K'ay away doliyaa bagga dabaabaa gomppay ishatamu wad'aa aaka. ");
INSERT INTO dwrl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Dabaabaa geliyaa sa'aappe itti baggana tammanne ichcheshu wad'aa aduk'k'iyaa gaariddotuu, heezzu tuussatuunne tuussatoo heezzu gedetuu de'iino. ");
INSERT INTO dwrl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Hewaadankka, dabaabaa geliyaa sa'aappe hinkko baggana, tammanne ichcheshu wad'aa aduk'k'iyaa gaariddotuu, unttunttoo heezzu tuussatuunne tuussatoo heezzu gedetuu de'iino. ");
INSERT INTO dwrl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Dabaabaa yuushshuwaan de'iyaa gaariddotuu ubbay liik'o liinuwaappe dadetteeddawantta. ");
INSERT INTO dwrl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","He tuussatuwaa gedetuu nahaasiyaappe, kak'k'iyaawanttunne tuussatuwaa huup'iyaan k'achchiyaawanttu biraappe oosetteeddino; unttunttu huup'ii biran sheeshetteedda. Hewaa diraw, dabaabaa yuushshuwaan de'iyaa tuussatuwaa ubbaa huup'iyaan biraappe oosetteedda k'achchiyaawanttu de'iino. ");
INSERT INTO dwrl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Dabaabaa geliyaa sa'aan kak'k'iyaa gaariduu saluwaa malatiyaa ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne liik'o liinuwaappe daddiyaawaa s'ilppiyaan alleek'k'issiyaawan giigisseeddawaa. Aw adussatetsay laatamu wad'aa; geesay dabaabaa gaariddotuwaa likke, ichcheshu wad'aa. ");
INSERT INTO dwrl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Nahaasiyaa birataappe oosetteedda oyddu tuussatuunne tuussatoo oyddu gedetuu de'iino. Unttunttu kak'k'iyaawanttunne tuussatuwaa huup'iyaan k'achchiyaawanttu biraappe med'etteeddino; unttunttu huup'etuukka biran sheeshetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","S'oossaa Dunkkaaniyaa shikaalatuu ubbaynne Aa yuushshuwaan de'iyaa dabaabaa shikaalatuu ubbay nahaasiyaa birataappe med'etteeddawantta. ");
INSERT INTO dwrl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","S'oossaa Dunkkaaniyaw, hewekka K'aalaa c'aak'uwaa Dunkkaaniyaw, go'etteedda miishshatuwaa Leewatuu paydeeddinno. He miishshatuwaa k'eesiyaa Aaroona na'aa Itaamaara kaappotetsaa garssan de'iyaa Leewatuu mazggabaan s'aafanaadan Muse azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Yihudaa zare gideedda Hoora na'aa na'aa, Uura na'aa, Bas'aali'eeli Med'inaa Goday Musa azazeedda ubbaa ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Daana zare gideedda Ahisamaaka na'aa Oholi'aabi aanana de'ee; I kushiyaa hiillanchchanne ootsiyaabaw koyro halchchuwaa kessiyaawaa; k'ay saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaaninne liik'o liinuwaan daddiide, s'ilppiyaan alleek'k'issiyaa asaa. ");
INSERT INTO dwrl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","S'oossaa Dunkkaaniyaa oosoo S'oossaw imetteedda work'k'ay S'oossaa Dunkkaaniyaan eretiyaa miizaanan wotsina, itti sha\"a kiilo giraamiyaa dees'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Payduwaan de'iyaa maabaraa asaappe beetteedda biray S'oossaa Dunkkaaniyaan eretiyaa miizaanan wotsina, 3,430 kiilo giraamiyaa dees'eedda. ");
INSERT INTO dwrl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Asaa paydiyaa wode paydetteedda attuma Asay ubbay huup'iyaan huup'iyaan S'oossaa Dunkkaaniyaan eretiyaa miizaanan wotsina, usuppun giraame keeshshaa immeedda. Paydeteedda Asay laatamu laytsaa kumeeddawenne laatamuwaappe bollana de'iyaawe ubbay 603,550. ");
INSERT INTO dwrl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","S'oossaa Dunkkaaniyaa gaaridduwaa esseedda s'eetu pootsay geliyaa lukotuu 3,400 kiilo giraame biran oosetteeddino. Hewekka itti itti gediyaw hattamanne oyddu kiilo giraame biraa. ");
INSERT INTO dwrl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Atteeda hattamu kiilo giraame tigiyaa biraa tuussatuwaan kak'k'iyaawantta med'd'anaw, tuussatuwaa huup'iyaan sheeshshanawunne unttunttu huup'iyaan k'achchiyaawantta med'd'anaw go'etteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Hewaadankka, Asay S'oossaw aheedda nahaasiyaa biratay 2,425 kiilo giraame. ");
INSERT INTO dwrl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","He nahaasiyaa birataappe S'oossaa Dunkkaaniyaa geliyaa sa'aan ek'k'iyaa tuussatuwaa gedetuu, nahaasiyaa yarshshiyaa sa'aa giyaa yarshshiyaa sa'ay, Aa giddon hiis's'eedda nahaasiyaa zazziriinne Aa giddon go'ettiyaa dumma dumma miishshaa ubbay med'ettee. ");
INSERT INTO dwrl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Hewaadankka, k'ay dabaabaa yuushshuwaan de'iyaa dirssaanne geliyaa sa'aa penggii ek'k'eedda gedetuu, k'ay S'oossaa Dunkkaaniinne Aa yuushshuwaan de'iyaa dabaabaa dirssay d'ogetteedda shikaalatuu ubbay he nahaasiyaa birataappe med'etteeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","K'eesetuu S'oossaa Dunkkaaniyaan ootsiyaa wode go\"etiyaa mayuwaa, saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappe daddeeddino. Aaroone mayiyaa geeshsha k'eesatetsaa mayuwaakka Med'inaa Goday Musa azazeeddawaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","I eefuudiyaa, work'k'aappe, saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne liik'o liinuwaappe daddeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Unttunttu work'k'aa k'os's'iide, lee'iyaa yeechchaadaa, aappe k'araari k'araariide, k'ac'inaa kesseeddino. Yaatiide saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaanne liik'o liinuwaa gatsiide, kushiyaa hiillanchchatuu daddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Laa\"u baggay gakettiide ittuwaa gidana mala, laa\"u hashiyaa bolla gatsiide oytsiyaa c'ark'k'iyaa giigisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Med'inaa Goday Musa azazeeddawaadan, hiillay alleek'k'issiide daddeedda danc'c'uukka eefuudiyanna itta gidiide, work'k'aappe saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne liik'o liinuwaappe dadetteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Unttunttu marggidiyaa geetettiyaa laa\"u shuchchatuwaa giigissiide, work'k'aappe med'd'eedda shuchchaa oyk'k'iyaawaa bolla maarana wotseeddino. Maatafaa bolla suntsaa wooc'iide s'aafiyaawaadan, he shuchchatuwaa bolla tamanne laa\"u Israa'eeliyaa naanatuwaa suntsaa wooc'iide s'aafeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","S'oossay Musa azazeeddawaadan, tammanne laa\"u Israa'eeliyaa zeretsaa hassayiyaawaa gidana mala, ha shuchchatuwaa eefuudiyaanna oytseedda hashiyaa c'ark'k'iyaan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","I tiraan wotsiyaawaa kushiyaa hiillanchchan oosiseedda. He tiraan wotsiyaawaa eefuudiyaa work'k'aappe daddeeddawaadan, saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne liik'o liinuwaappe daddiseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Aw oyddu gas'ay de'ee; geesaynne gomppay itti itti takkaad'e; gideeddawaa dakkoyeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Hewaappe guyyiyaan Aa bolla oyddu maaran al\"o shuchchatuwaa wotseeddino; koyro maaran wotseedda shuchchay, sarddiyoona, toop'aaziyooniyaanne p'ooliyaa ink'k'uwaa; ");
INSERT INTO dwrl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","laa'entso maaran baluura, samppeeriyaanne almmaaziyaa geetettiyaa al\"o shuchchatuwaa; ");
INSERT INTO dwrl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","heezzentso maaran yaakinttiyaa, kelk'k'edooniyaanne ametess's'inoosiyaa; ");
INSERT INTO dwrl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","oyddentso maaran biralli, margidiyaanne yasp'p'iidiyaa. Hewantta ubbaa work'k'aappe oosetteedda shuchchaa oyk'k'iyaawaa bolla wotseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Israa'eeliyaa naanatuwaa suntsaa payduwaadan, shuchchatuwaa payduukka tammanne laa\"uwaa; ittuu ittuu maatafaadan wooc'ettiide, tammanne laa\"u zaratuwaa suntsay he shuchchatuwaan s'aafetteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Tiraan wotsiyaawoo wodoruwaadan dook'eteedda sanssalataa walakay baynna work'k'aappe med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Laa\"u work'k'aappe med'd'eedda shuchchaa oyk'k'iyaawantta ootseeddino; yaatiide laa\"u work'k'aa migidatuwaa med'd'eeddawantta, tiraan wotsiyaawoo k'ommo gas'aa gas'atuwaana gatsiide oysetseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","He laa\"u work'k'aa sanssalatatuwaa tiraan wotsiyaawoo gas'atuwaan de'iyaa migidotuwaanna gatsi oytseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","He sanssalatatoo hinkko bagga s'eeraa k'ay eefuudiyaw sintsa baggana, hashiyaa c'ark'k'iyaan de'iyaa shuchchaa oyk'k'iyaawanttuna gatsi k'achcheeddinno. ");
INSERT INTO dwrl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","K'aykka laa\"u work'k'aa migidatuwaa med'd'iide, eefuudiyaappe kaaliide de'iyaa tiraan wotsiyaawoo soy baggana de'iyaa laa\"u gas'atuwaa s'eeran aatseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Hewaadankka, work'k'aappe hara laa\"u migidatuwaa med'd'iide, eefuudiyaw sintsa baggana, hashiyaa c'ark'k'iyaappe garssa baggana eefuudiyaa s'eessan k'achchiyaawaappe k'ommonna, sikuu gaketeedda sa'aa matan karenna unttuntta oytseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Med'inaa Goday Musa azazeeddawaadan, tiraan wotsiyaawaan de'iyaa migidatuwaa eefuudiyaan de'iyaa migidatuwaanna gatsiide, saluwaa malatiyaa bak'etsaan k'achchina tiraan wotsiyaawe s'eessaappe k'ommonna de'iyaa diraw, k'ashuu shol\"enna. ");
INSERT INTO dwrl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Eefuudiyaappe garssanna mayiyaa adussa mayuwaa I saluwaa malatiyaa c'ark'k'iyaappe giigisseedda; hewe shemayinniyaa oosuwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","He adussa mayoo k'ood'iyaa aatsiyaa sa'aa med'd'eeddino; he sa'ay peed'ettenaadan, yuushshi aatsiide gujji gujji sikkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Unttunttu adussa mayuwaa duge bagga mac'araa yuushshuwaan saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o dook'eteedda roomaaniyaa teeraa misiletuwaa med'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Unttunttu k'ay work'k'aappe daalatuwaa med'd'iide, adussa mayoo duge bagga gas'aa yuushshi aatsiide, roomaaniyaa misiletuwaa gidduwaan, walakan aatseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Aaroone he mayoo duge bagga mac'araa yuushshi aatsiide, daalaanne roomaaniyaa teeraa misiliyaa walakkiide aatseeddino. Hewe Med'inaa Goday Musa azazeeddawaadan, unttunttu S'oossaa Dunkkaaniyaa oosuwaa ootsiidde mayyanaassa. ");
INSERT INTO dwrl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Unttunttu Aaroonawunne Aa naanaw sheemayinniyaa liinuwaappe adussa shaamic'c'iyaa giigisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","K'ay Aaroone huup'iyaan s'aas'iyaa shaashiyaa, Aa naanaw k'oobetuwaanne garssana mayiyaa mayotuwaa liik'o liinuwaappe daddiide giigisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Unttunttu Med'inaa Goday musa azazeeddawaadan saluwaa malatiyaa, ochchaa teeraa malatiyaanne shololla zo'o k'ac'inaappenne liik'o liinuwaappe daddiide, kushiyaa hiillan alleek'k'issiide, danc'c'uwaa giigisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Unttunttu geeshsha allek'k'uwaa misiliyaa walakay baynna work'k'aappe med'd'iide, maatafaa bolla wooc'iyaawaadan, Aa bolla, «Med'inaa Godaw Geeshsha Gidiide Dummatteedda» yaaggiyaawaa wooc'iide s'aafeeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Hewaappe guyyiyaan huup'iyaan shaashiyaappe s'aden k'achchanaadan, Med'inaa Goday Musa azazeeddawaadan saluwaa malatiyaa bak'etsaa an aatsiide k'achcheeddinno. ");
INSERT INTO dwrl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","S'oossaa Dunkkaaniyaa kiittay ubbay poletteedda. Israa'eelatuu ubbabaakka Med'inaa Goday Musa azazeeddawaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Hewaappe guyyiyaan unttunttu S'oossaa Dunkkaaniyaa Musekko aheeddino; hewekka: dunkkaaniyaanne Aa miishshaa ubbaa, gatsi oytsiyaawaa, s'agaagetuwaa, shikaalatuwaanne, tuussatuu ek'k'iyaa saas'inetuwaa, ");
INSERT INTO dwrl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","bollaa kamaade dorssaa orggiyaa galbbaa zo'o k'alamiyaan yeggi kesseeddawaa, hara galbbaappe med'eedda k'um\"iyaa, Taabootaa gentsiyaa gaaridduwaa, ");
INSERT INTO dwrl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","K'aalaa c'aak'uwa Taabootaa, Aa tookkiyaa kasotuwaanne atto giyaa sa'aa k'um\"iyaa, ");
INSERT INTO dwrl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","s'arp'p'eezaanne Aa miishshaa ubbaa S'oossaa sintsan wotsiyaa geeshsha ukitsaa, ");
INSERT INTO dwrl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","walakay baynna work'k'aappe oosetteedda s'omppiyaa wotsiyaa ballaanne an maaran de'iyaa s'omppetuwaa, unttunttu miishshatuwaa ubbaanne s'omppiyaa zayitiyaa, ");
INSERT INTO dwrl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","is'aanaa c'uwayiyaa work'k'aa saas'iniyaa, okettiyaa zayitiyaa, sawiyaa is'aanaa, S'oossaa Dunkkaaniyaa penggiyaa gaaridduwaa, ");
INSERT INTO dwrl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","nahaasiyaappe ootseedda yarshshiyaa sa'aa, Aa nahaasiyaa zazziriiyaana, Aa tookkiyaa kasuwaa, Aa miishshatuwaa ubbaa, meechchaa keriyaanne Aa wotsiyaawaa, ");
INSERT INTO dwrl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","dabaabaa gentsiyaa gaariddotuwaa, Aa tuussatuwaa, unttunttu ek'k'iyaa saas's'inetuwaa, dabaabaa geliyaa penggetuwaa gaaridduwaa, dabaabaa wodorotuwaanne shikaalatuwaa, S'oossaa Dunkkaaniyaa med'anaw koshshiyaa miishshatuwaa ubbaa; ");
INSERT INTO dwrl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","k'eesatuu Geeshsha sa'aan ootsiide go'etanaw dadetteedda mayotuwaa, Aaroone geeshsha mayuwaanne Aa naanay k'eesatetsaa ootsiidde mayiyaa mayotuwaa. ");
INSERT INTO dwrl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Israa'eelatuu oosuwaa ubbaakka Med'inaa Goday Musa azazeeddawaadan ubbabaa ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Muse oosuwaa ubbaa s'omoos s'eelliide, unttunttu Med'inaa Goday azazeeddawaadan ootseeddawaa be'eedda. Hewaa diraw, Muse unttuntta anjjeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Hewaappe guyyiyaan Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Koyro aginaw koyro gallassi, neeni Med'inaa Godaa Dunkkaaniyaa tokka. ");
INSERT INTO dwrl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","K'aalaa c'aak'uwaa Taabootaa Aa giddon wotsa; He Taabootaa garidduwaan kamma. ");
INSERT INTO dwrl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","S'arp'p'eezaa gelissaade, Aa bolla wod'd'anaw koshshiyaabaa ubbaa giigisaadde Aa bolla wotsa. Yaataade s'omppetuwaa wotsiyaa ballaa soo gelissaade, Aa bolla s'omppetuwaa eetsa. ");
INSERT INTO dwrl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Is'aanaa c'uwayiyaa work'k'aa saas'iniyaa K'aalaa c'aak'uwa Taabootaappe sintsanna wotsaade, S'oossaa Dunkkaaniyaa geliyaa gaaridduwaa sotta. ");
INSERT INTO dwrl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«S'uuggiyaa yarshshuwaa yarshshiyaa sa'aa S'oossaa Dunkkaaniyaappe sintsanna wotsa. ");
INSERT INTO dwrl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Meechchaa keriyaa S'oossaa Dunkkaaniyaappenne yarshshiyaa sa'aappe gidduwaan wotsaade, an haatsaa tiga. ");
INSERT INTO dwrl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","S'oossaa Dunkkaaniyaappe karenna yuushsha aatsaade dabaabaa giigissaade dabaabaa geliyaa sa'aan gaaridduwaa sotta. ");
INSERT INTO dwrl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Okkiyaa zayitiyaa akkaade, S'oossaa Dunkkaaniyaanne Aa giddon de'iyaa ubbabaa okka; aanne Aa giddon go'ettiyaa miishshaa ubbaa dummaya; yaatooppe I geeshsha gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Hewaappe guyyiyaan s'uuggiyaa yarshshuwaa yarshshiyaa sa'aanne aw go'ettiyaa miishshaa ubbaa okka; yarshshiyaa sa'aa dummaya; yaatooppe I ubbaappe aad'd'iyaa geeshsha gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Meechchaa keriyaanne Aa utissiyaa miishshaa okkaadde unttuntta dummaya. ");
INSERT INTO dwrl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Neeni Aaroonanne Aa naanaa S'oossaa Dunkkaaniyaa geliyaa pengge ahaade, haatsaan unttuntta meec'c'a. ");
INSERT INTO dwrl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Hewaappe guyyiyaan k'eesetetsaa Geeshsha mayuwaa Aaroona mayzzaade, I taw k'eesetetsan ootsanaadan, Aa okaade dummaya. ");
INSERT INTO dwrl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Aa attuma naanaakka ahaade shaamic'c'iyaa mayza. ");
INSERT INTO dwrl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Unttunttu taw k'eesetetsan ootsanaadan, unttunttu aawuwaa okkeeddawaadan, unttunttakka okka. Unttunttu okkay unttunttakka unttunttu sintsa yeletaa ubbaa k'eesatuwaa ootsiyaawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Muse ubbabaakka S'oossay barena azazeeddawaadan ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Hewaa diraw, Gibs'eppe unttunttu keseedda laa\"entsa laytsan, koyro aginaw koyro gallassan S'oossaa Dunkkaanii tokeetteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Muse S'oossaa Dunkkaaniyaa essiyaa wode, saas'inetuwaa unttunttu sa'aan sa'aan wotseedda; s'agaagetuwaanne tuussaa aatseedda; shikaalatuwaakka gelisseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Hewaappe guyye Muse Med'inaa Goday azazeeddawaadan, ha esseeddawaa bollan dunkkaaniyaa d'ogeedda; he essuwaa bollan kamuwaa kammeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Yaatiide tammu azazatuu s'aafetteedda markkatetsaa k'aalaa afiide, Taabootaa giddon wotseedda; tookkiyaa kasuwaa Taabootan aatseedda; atto giyaa sa'aa k'um\"iyaa Taabootaa bolla wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Hewaappe guyyiyaan Taabootaa S'oossaa Dunkkaaniyaa gelisseedda; gentsiyaa gaaridduwaa sottiide, Med'inaa Goday azazeeddawaadan K'aalaa c'aak'uwaa Taabootaa kammeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Med'inaa Goday Musa azazeeddawaadan, Muse s'arp'p'eezaa Med'inaa Godaa Dunkkaaniyaan gelissiide, gaariduwaappe karenna huup'issa baggana wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Aa bolla Med'inaa Godaa sintsan wotsiyaa geeshsha ukitsaa giigisseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Med'inaa Goday Musa azazeeddawaadan, s'omppiyaa wotsiyaa ballaa S'oossaa Dunkkaaniyaa giddo gelissiide, s'arp'p'eezaa hefintsana, S'oossaa Dunkkaaniyaw gedissa baggana wotseedda; ");
INSERT INTO dwrl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","k'ay s'omppetuwaa Med'inaa Godaa sintsan oytseedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Med'inaa Goday azazeeddawaadan, is'aanaa c'uwayiyaa work'k'aa saas'iniyaa S'oossaa Dunkkaaniyaa giddon gaaridduwaa sintsa baggana wotseedda; ");
INSERT INTO dwrl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Aa bolla sawiyaa is'aanaa c'uwayeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Hewaappe guyyiyaan S'oossaa Dunkkaaniyaa penggiyaan gaaridduwaa sotteedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","S'uuggiyaa yarshshuwaa yarshshiyaa sa'aa S'oossaa Dunkkaaniyaa geliyaa penggiyaa miyiyaan wotseedda; Aa bolla s'uuggiyaa yarshshuwaanne katsaa yarshshuwaa Med'inaa Goday azazeeddawaadan yarshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","S'oossay Musa azazeeddawaadan, meechchaa keriyaa S'oossaa Dunkkaaniyaappenne yarshshiyaa sa'aappe gidduwaan wotseedda. Yaatiide meec'ettanaw haatsaa an tigeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Muse, Aaroonenne Aa naanay barenttu kushiyaanne gediyaa an meec'ettiino. ");
INSERT INTO dwrl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Med'inaa Goday Musa azazeeddawaadan, unttunttu S'oossaa Dunkkaaniyaa geleedda wode woy yarshshiyaa sa'aakko shiik'eedda wode awudenne meec'ettiino. ");
INSERT INTO dwrl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","S'oossaa Dunkkaaniyaanne yarshshiyaa sa'aa yuushshi aatsiide dabaabaa keseedda; he dabaabaa penggiyaan gaaridduwaa sotteedda. Hewaadan ootsiidde, Muse oosuwaa poleedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Hewaappe guyyiyaan shaarii S'oossaa Dunkkaaniyaa kammeedda; Med'inaa Godaa bonchchuukka Aa kumeedda. ");
INSERT INTO dwrl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Shaarii S'oossaa Dunkkaaniyaa bolla utteedda dirawunne Med'inaa Godaa bonchchu Aa giddon kumeedda diraw, Muse Aa giddo gelanaw danddayibeenna. ");
INSERT INTO dwrl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Israa'eelatuu barenttu ogiyaa ubbaan, he shaarii S'oossaa Dunkkaaniyaappe denddiyaa wode awudenne Aa kaalliide hametaa doomino. ");
INSERT INTO dwrl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Shin he shaarii denddana d'ayooppe, I denddiyaa gallassay gakkanaw unttunttukka k'aas's'ikkino. ");
INSERT INTO dwrl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Unttunttu ogiyaa ubbaan Med'inaa Godaa shaarii Israa'eeliyaa Asay ubbay be'ishin, gallassi gallassi S'oossaa Dunkkaaniyaa kameenne k'amma k'amma k'ay tamay he shaariyaa giddon ees's'ee.");
INSERT INTO dwrl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Med'inaa Godaanna Gakkettiyaa Dunkkaaniyaa giddoppe Med'inaa Goday Musa s'eesiide, hawaadan yaagiide haasayeedda; ");
INSERT INTO dwrl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Hintteppe ooninne Med'inaa Godaw yarshshuwaa shiishshiyaa wode, he bare shiishshiyaa yarshshuwaa bare mehiyaappe woy bare dorssaa woy deeshshaa wudiyaappe aho. ");
INSERT INTO dwrl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","He yarshshuu mehiyaa wudiyaappe s'uuggiyaa yarshshuwaa gidooppe, attumawaa gidiide, tilla bollaanna de'iyaawaa gido. Med'inaa Goday akkana mala, I he yarshshuwaa Med'inaa Godaa Dunkkaaniyaa geliyaa penggiyaan yarshsho. ");
INSERT INTO dwrl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Yarshshuwaa shiishshiyaa bitanii s'uugiide yarshshanaw aheedda bare mehiyaa huup'iyaan bare kushiyaa wotso. Hewe Aa nagaraa atto gaanaw S'oossay akkeedda yarshshuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","I korumaa Med'inaa Godaa sintsan shukkina; Aaroona naanay k'eesatuu he suutsaa ahiide, Med'inaa Godaa Dunkkaaniyaa geliyaa penggiyaan de'iyaa yarshshiyaa sa'aa miyyiyaa ubbaan gussino. ");
INSERT INTO dwrl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Hewaappe guyyiyaan, I s'uuggiyaa yarshshoo mehiyaa galbbaa k'aaro; ashuwaa Aa k'ommuwaan k'ommuwaan kesso. ");
INSERT INTO dwrl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","K'eesiyaa Aaroona naanay yarshshiyaa sa'aa bollan tamaa eetsiide, mitsaa wotsino. ");
INSERT INTO dwrl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Hewaappe guyyiyaan, Aaroona naanay k'eesatuu he keseedda ashuwaa huup'iyaanne mod'd'uwaa gujjiide, yarshshiyaa sa'aa bollan taman de'iyaa mitsaa bollan maariide wotsino. ");
INSERT INTO dwrl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Shin he bitanii k'antsaa ashuwaanne gedetuwaa haatsaan meec'c'o. Yaatiide k'eesii hewaa ubbaakka ahiide, yarshshiyaa sa'aa bolla s'uuggo; hewe Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","« ‹S'uuggiyaa yarshshoo I immiyaa imuu dorssaa wudiyaappe woy deeshshaa wudiyaappe akettiyaawaa gidooppe, attumawaa gidiide, tilla bollana de'iyaawaa gido. ");
INSERT INTO dwrl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","He mehiyaa yarshshiyaa sa'aappe huup'issa baggana Med'inaa Godaa sintsan shukko. Aaroona naanay k'eesatuu Aa suutsaa akkiide, yarshshiyaa sa'aa miyyiyaa ubbaa bollan gussino. ");
INSERT INTO dwrl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Hewaappe guyyiyaan, he bitanii Aa k'ommuwaan k'ommuwaan keseedda ashuwaa ubbaa k'eesii akkiide, huup'iyaanne mod'd'uwaa gujjiide, yarshshiyaa sa'aa bollan taman de'iyaa mitsaa bollan wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Shin k'antsaa ashuwaanne gedetuwaa haatsaan meec'c'o; yaatiide k'eesii hewaa ubbaa ahiide yarshshiyaa sa'aa bollan s'uuggo; hewe Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","« ‹Med'inaa Godaw yarshshiyaa s'uuggiyaa yarshshuu kafuwaa gidooppe, harap'p'iyaa maraa, woy dogommuwaa aho. ");
INSERT INTO dwrl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","K'eesii hewaa akkiide, k'ood'iyaa mirk'k'o; yaatiide yarshshiyaa sa'aa bollan de'iyaa taman s'uuggo. Aa suutsay yarshshiyaa sa'aa bollappe miyyiyaanna duge goggi c'inggo; ");
INSERT INTO dwrl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ulo gidduwaa baalletuwaana kessiide, yarshshiyaa sa'aappe away doliyaa baggana, bidintsaa k'oliyaa sa'aan olo. ");
INSERT INTO dwrl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","I he kafuwaa k'efetuwaa oyk'k'iide p'alk'k'o, shin ubbaanna daakkoppo. Hewaappe guyyiyaan, k'eesii yarshshiyaa sa'aa bollan de'iyaa taman wotsiide s'uuggo; hewe Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","« ‹Ooninne katsaa yarshshuwaa Med'inaa Godaw shiishshiyaa wode, he yarshshuu liik'o d'iiliyaa gido; Aa bolla wogaraa zayitiyaanne is'aanaa gujjo. ");
INSERT INTO dwrl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Hewaa I Aaroona naanatuwaakko k'eesatuwaakko aho; k'eesatuu he liik'o d'iiliyaappenne zayitiyaappe itti kushiyaa kuntsi akkiide, is'aanaa ubbaanna akki, hassayissiyaawaa ootsiide, yarshshiyaa sa'aa bolla taman s'uuggo. Hewe Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Katsaa yarshshuwaappe atteedawe Aaroonassanne Aa naanatuwaassa. Hewe Med'inaa Godaw taman s'uugettiyaa geeshsha yarshshuwaa ubbaappe ittuwaa gideedda geeshsha yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","« ‹Yarshshoo shiishshiyaa ukitsay c'ooc'iyaan ka\"eeddawaa gidooppe, zayitiyaan munak'k'eedda liik'o d'iiliyaappe uuketteedda irshshuu yegettibeenna komppo, woy zayitiyaan oketteedda, irshshuu yegettibeenna lee\"o ukitsaa gido. ");
INSERT INTO dwrl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","« ‹Yarshshoo shiishshiyaa ukitsay bashiyaan uuketteeddawaa gidooppe, zayitiyaan munak'k'eedda, irshshuu bayna, liik'o d'iiliyaappe giigeeddawaa gido. ");
INSERT INTO dwrl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Aa mentsiide Aa bolla zayitiyaa tigo; hewaa katsaa yarshshuwaa ootsiide shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","« ‹Ne yarshshoo shiishshiyaa katsaa yarshshuu disttiyaan ka\"eeddawaa gidooppe, zayitiyaan munak'k'eedda liik'o d'iiliyaappe ka\"eeddawaa gido. ");
INSERT INTO dwrl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Hawaadan giigisseedda katsaa yarshshuwaa Med'inaa Godaw aha; k'eesiyaw imma. K'eesii hewaa akkiide yarshshiyaa sa'aa shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","K'eesii he katsaa yarshshuwaappe akkiide, hassayissiyaawaa ootsiide, yarshshiyaa sa'aa bollan s'uuggiyaa yarshshuwaadan taman s'uuggo; hewe Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Katsaa yarshshuwaappe atteedawe Aaroonessanne Aa naanatuwaassa. Hewe Med'inaa Godaw taman s'uuggeedda, geeshsha yarshshuwaa ubbaappe ittuwaa gideedda geeshsha yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","« ‹S'oossaw hintte ahiyaa ay katsaa yarshshuunne irshshuwaana de'iyaawaa gidoppo; ayaw gooppe neeni irshshuwaa woy eessaa ililuwaa S'oossaw taman s'uuggaade yarshshanaw koshshenna. ");
INSERT INTO dwrl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Hintte laytsan laytsan c'akettiyaa katsaappe s'eeraa kessiide, S'oossaw ahanaw danddayiita; shin hewaa sawuwaa toshukku giyaa yarshshuwaa ootsiide, S'oossaw yarshshiyaa sa'aa bollan s'uugettenna. ");
INSERT INTO dwrl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Neeni shiishshiyaa katsaa yarshshuwaa ubbaan mas'iniyaa yegga; ayaw gooppe, ne S'oossaa k'aalaa c'aak'uwaa mas'iniyaa aggoppa. Hewaa diraw ne katsaa yarshshuwaa ubbaa mas'iniyaan mal\"etsa. ");
INSERT INTO dwrl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Neeni koyiro katsaappe s'eeraa kessaade Med'inaa Godaw ahiyaa wode, he katsay s'iis's'etiide hars's'eteedda tisha katsaa gidanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Aa bolla zayitiyaa tiga; is'aanaakka aan wotsa; hewe katsaa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","K'eesii he zayitii tigetteedda hars's'eteedda katsaappe shakkuwaa akkiide, is'aanaa ubbaannakka hassayissiyaawaa ootsiide taman Med'inaa Godaw s'uuggo. ");
INSERT INTO dwrl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","« ‹Itti Asay ittippetetsaa yarshshoo bare wudiyaappe mac'c'awaa gidina attumawaa gidina itti mehiyaa shiishshiyaa wode, he mehii tilla bollaanna de'iyaawaa Med'inaa Godaa sintsan shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Yarshshanaw aheedda mehiyaa huup'iyaan bare kushiyaa wotsiide, S'oossaa Dunkkaaniyaa penggiyaan shukko. Hewaappe guyyiyaan, k'eesatuu Aaroona naanay suutsaa yarshshiyaa sa'aa miyyiyaa ubbaa bollan gusso. ");
INSERT INTO dwrl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ittippetetsaa yarshshuwaappe taman s'uuggiyaa yarshshuwaa ootsiide Med'inaa Godaw shiishsho; hewekka k'antsaa ashuwaa mayyeedda handdaa ubbaynne aanana gatsiyaa handday, ");
INSERT INTO dwrl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","laa\"u kilahotuwaa, unttunttu bolla de'iyaa handdaa, gaylliyaa matan de'iyaa handdaanne tiriyaa s'eeraa bolla de'iyaa handdaa kilahotuwaana gatsiide akkee. ");
INSERT INTO dwrl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aaroona attuma naanay hewaa hara s'uuggiyaa yarshshuwaanna yarshshiyaa sa'aa bolla de'iyaa mitsaa bolla wotsiide s'uuggino; hewe Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","« ‹Med'inaa Godaw ittippetetsaa yarshshuwaa shiishshiyaa uray dorssaa gidina deeshshaa, mac'c'awaa gidina attumawaa tilla bollaanna de'iyaawaa shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Itti uray dorssaa maraa yarshshiyaawaa gidooppe, Med'inaa Godaa sintsan shiishsho; ");
INSERT INTO dwrl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","bare kushiyaa Aa huup'iyaan wotsiide, Dunkkaaniyaa sintsan shukko. Hewaappe guyyiyaan, Aaroona attuma naanay suutsaa oyk'k'iide, yarshshiyaa sa'aa miyyiyaa ubbaa bollan gussino. ");
INSERT INTO dwrl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ittippetetsaa yarshshuwaappe taman s'uuggiyaa yarshshuwaa ootsiide, Med'inaa Godaw shiishsho; hewekka, ziizziyaappe k'ans's'eedda nasiyaa, ulo giddo ashuwaa mayyeedda mood'iyaanne hawantta gatsi oytsiyaa mood'iyaa ubbaa, ");
INSERT INTO dwrl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","laa\"u kilahotuwaa, unttunttu bolla de'iyaa handdaanne gaylliyaa matan de'iyaa mood'iyaa, tiriyaa s'eeraa bolla de'iyaa mood'iyaa kilahotuwaana gatsiide akkee. ");
INSERT INTO dwrl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","K'eesii he k'umaa yarshshuwaa Med'inaa Godaw taman s'uuggiyaa yarshshiyaa sa'aa bolla wotsiide s'uuggo. ");
INSERT INTO dwrl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","« ‹Aa yarshshuu deeshshaa gidooppe, I hewaa Med'inaa Godaa sintsan shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Yaatiide Aa huup'iyaan bare kushiyaa wotsiide, S'oossaa Dunkkaaniyaa sintsan shukko. Hewaappe guyyiyaan, Aaroona attuma naanay suutsaa oyk'k'iide, yarshshiyaa sa'aa yuushshuwaan ubbaan gussiino. ");
INSERT INTO dwrl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","I he yarshshiyaawaappe akkiide, taman s'uuggiyaa yarshshuwaa ootsiide Med'inaa Godaw shiishsho; hewekka k'antsaa ashuwaa mayyeedda handdaa ubbaanne he handdaa gatsi oytsiyaa hara handdaa, ");
INSERT INTO dwrl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","laa\"u kilahotuwaa, unttunttu bolla de'iyaa handdaanne gaylliyaa matan de'iyaa mood'iyaanne tiriyaa s'eeraa bolla de'iyaa mood'iyaa kilahotuwaana gatsiide akkee. ");
INSERT INTO dwrl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","K'eesii he k'umaa taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa ootsiide yarshshiyaa sa'aa bolla s'uuggo. Handdaa ubbay Med'inaa Godaassa. ");
INSERT INTO dwrl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","« ‹Handdaanne suutsaa hintte de'iyaa sa'aan hak'aninne mooppite. Hawe hinttenttoonne hintte yeletaw med'inaw naagettiyaa wogaa› yaagaade oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Neeni Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Ooninne k'oppennaan nagaraa ootsooppenne, Med'inaa Godaa azazotuwaappe ittuwaa hak'awaanne mentsooppe, hawaappe kaalliide de'iyaa wogaa naago. ");
INSERT INTO dwrl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","« ‹K'eesiyaa kaappuu nagaraa ootsooppenne he nagaray asaa bayzzanchcha kessiyaawaa gidooppe, I bare ootseedda nagaraa diraw, tilla bollaanna de'iyaa korumaa Med'inaa Godaw nagaraa yarshshuwaa ootsiide aho. ");
INSERT INTO dwrl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","He korumaa Med'inaa Godaa Dunkkaaniyaa pengge aatsiide, korumaa huup'iyaan bare kushiyaa wotsiide, Med'inaa Godaa sintsan shukko. ");
INSERT INTO dwrl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","K'eesiyaa kaappuu korumaa suutsaappe amareedawaa akkiide, Med'inaa Godaa Dunkkaaniyaa afo. ");
INSERT INTO dwrl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Bare kushiyaa birad'd'iyaa suutsan tushi tushi kessiide, Med'inaa Godaa Dunkkaaniyaa gaaridduwaa sintsan Med'inaa Godaa sintsan laappu gede dukko. ");
INSERT INTO dwrl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Hewaappe guyyiyaan, K'eesiyaa kaappuu amareeda suutsaa akkiide, Med'inaa Godaa Dunkkaaniyaa giddon Med'inaa Godaa sintsan sawiyaa is'aanaa c'uwissiyaa saas'iniyaa bolla de'iyaa kac'etuwaa bolla s'okisso. Atteeda suutsaa k'ay S'oossaa Dunkkaaniyaa geliyaa sa'aa baggana de'iyaa s'uuggiyaa yarshshuwaa yarshshiyaa sa'aappe garssa baggana de'iyaa sa'aan gusso. ");
INSERT INTO dwrl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Nagaraa yarshshoo shuketteedda ha korumaa mod'd'uwaa ubbaa, k'antsaa ashuwaa mayyeedda handdaanne unttuntta gatsi oytsiyaa mod'd'uwaa, ");
INSERT INTO dwrl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","laa\"u kilahotuwaa, unttuntta mayyeedda handdaanne gaylliyaa matan de'iyaa mood'iyaanne tiriyaa s'eeraa bolla de'iyaa mood'iyaa kilahotuwaana ittippe kessiide akko. ");
INSERT INTO dwrl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ittippetetsaa yarshshoo shuketteedda korumaappe akkeedda mod'd'uwaadan akko. K'eesiyaa kaappuu s'uuggiyaa yarshshuwaa yarshshiyaa sa'aa bollan s'uuggo. ");
INSERT INTO dwrl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Shin korumaa galbbaa, Aa ashuwaa ubbaa, Aa huup'iyaanne, Aa gedetuwaa, k'antsaa ashuwaa, toc'iyaa, ");
INSERT INTO dwrl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","korumaa ashuwaappe atteedawaa ubbaa dunkkaaneedda sa'aappe kare kessiide; bidintsaa k'oliyaa wogaadan geeshsha gideedda sa'aa afo; yan mitsaa taman s'uuggo. ");
INSERT INTO dwrl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","« ‹Israa'eeliyaa maabaray ubbay k'oppennaan nagaraa ootsooppenne, Med'inaa Godaa azazotuwaappe ittuwaa hak'awaanne mentsooppe, unttunttu bayzzanchcha gidiide paydetana. ");
INSERT INTO dwrl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Unttunttu ootseedda nagaray erettiyaa wode, nagaraa yarshshoo haniyaa korumaa S'oossaa Dunkkaaniyaa sintsa ahino. ");
INSERT INTO dwrl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","He maabaraa c'imatuu Med'inaa Godaa sintsan barenttu kushiyaa korumaa huup'iyaa bollan wotsiide, he korumaa Med'inaa Godaa sintsan shukkino. ");
INSERT INTO dwrl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Hewaappe guyyiyaan, k'eesiyaa kaappuu korumaa suutsaappe guutsaa akkiide, S'oossaa Dunkkaaniyaa giddo gelo; ");
INSERT INTO dwrl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","I bare kushiyaa birad'd'iyaa suutsan tushi tushi kessiide, gaaridduwaa sintsa baggana Med'inaa Godaa sintsan laappu gede dukko. ");
INSERT INTO dwrl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","K'ay amareeda suutsaa akkiide, Med'inaa Godaa Dunkkaaniyaa giddon sintsan is'aanaa c'uwissiyaa saas'iniyaa bolla de'iyaa kac'etuwaa bolla s'okisso. Atteeda suutsaa k'ay Med'inaa Godaa Dunkkaaniyaa geliyaasaa baggana de'iyaa s'uuggiyaa yarshshuwaa yarshshiyaa sa'aappe garssa baggana de'iyaa sa'aan gusso. ");
INSERT INTO dwrl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Mod'd'uwaa ubbaa akkiide, yarshshiyaa sa'aa bollan s'uuggo. ");
INSERT INTO dwrl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Nagaraa yarshshoo shuketteedda korumaa ootseeddawaadan ha korumaakka ootso. Hewaadan ootsiide, k'eesii nagaraa atto giissiyaa wogaa polana; asaykka nagaraappe maarettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Hewaappe guyyiyaan, korumaa dunkkaaneedda sa'aappe kare kessiide, kase korumaa s'uuggeeddawaadan aakka s'uuggo; hawe maabaraa nagaraw yarshshiyaa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","« ‹Asaa kaaletsiyaa suntsatuwaappe ittuu k'oppennaan nagaraa ootsooppenne Med'inaa Goday Aa S'oossay Aa azazeedda azazuwaappe ittuwaa hak'awaanne mentsooppe, he uray bayzzanchcha. ");
INSERT INTO dwrl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","I bare ootseedda nagaraa ereeddawaappe guyyiyaan, tilla bollaanna de'iyaa itti deeshshaa orggiyaa aho. ");
INSERT INTO dwrl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","He deeshshaa orggiyaa huup'iyaan bare kushiyaa wotsiide s'uuggiyaa yarshshuu Med'inaa Godaa sintsan shukettiyaa sa'aan shukko; hewe nagaraa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","K'eesiyaa kaappuu nagaraa yarshshuwaa suutsaa giddo bare kushiyaa birad'd'iyaa tushi tushi kessiide, s'uuggiyaa yarshshuwaa yarshshiyaa sa'aa bolla de'iyaa kac'etuwaa bolla s'okisso; atteeda suutsaa k'ay s'uuggiyaa yarshshuwaa yarshshiyaa sa'aappe garssa baggana de'iyaa sa'aan gusso. ");
INSERT INTO dwrl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Mod'd'uwaa ubbaa ittippetetsaa yarshshuwaa mod'd'uwaa yarshshiyaawaadan yarshshiyaa sa'aa bollan yarshsho. Hawaadan ootsiide, k'eesii bitaniyaa nagaraa atto giissee; bitaniikka bare nagaraappe maarettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","« ‹He maabaraa asaappe ittuu k'oppennaan nagaraa ootsooppenne Med'inaa Godaa azazuwaappe ittuwaa hak'awaanne mentsooppe, he uray bayzzanchcha gidiide paydettee. ");
INSERT INTO dwrl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","I bare ootseedda nagaray aw eretteeddawaappe guyyiyaan, tilla bollaanna de'iyaa mac'c'a deeshshatto bare nagaraw aho. ");
INSERT INTO dwrl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Bare kushiyaa nagaraa yarshshuwaa ootsiide shukkiyaa deeshshatti huup'iyaan wotso; yaatiide s'uuggiyaa yarshshuwaa yarshshiyaa sa'aan nagaraa yarshshuwaa ootsiide shukko. ");
INSERT INTO dwrl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Hewaappe guyyiyaan, k'eesiyaa kaappuu he deeshshatti suutsaappe bare kushiyaa birad'd'iyaan akkiide, s'uuggiyaa yarshshuwaa yarshshiyaa sa'aa bolla de'iyaa kac'etuwaa bolla s'okisso; atteeda suutsaa ubbaa yarshshiyaa sa'aappe garssa baggana de'iyaa sa'aan gusso. ");
INSERT INTO dwrl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Mod'd'uwaa ubbaa ittippetetsaa yarshshoo shukkeedda mehiyaappe kessiyaawaadan, he deeshshatti mod'd'uwaakka k'oriide kessi akkiide, yarshshiyaa sa'aa bolla wotsiide, Med'inaa Godaw sawuwaa toshukku giyaa yarshshuwaa gidana mala s'uuggo. Hewaadan ootsiide, k'eesii he bitaniyaa nagaraa atto giissee; bitaniikka bare nagaraappe maarettee. ");
INSERT INTO dwrl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","« ‹He bitanii bare nagaraa yarshshoo dorssaa shiishshanaw koyooppe, tilla bollaanna de'iyaa mac'c'awunno aho. ");
INSERT INTO dwrl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","I bare kushiyaa he dorssatti huup'iyaan wotsiide s'uuggiyaa yarshshoo shukkiyaa mehii shukettiyaa sa'aan izo shukko. ");
INSERT INTO dwrl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Hewaappe guyyiyaan, k'eesii nagaraa yarshshuwaa gideedda he dorssatti suutsan bare birad'd'iyaa tushi tushi kessiide, s'uuggiyaa yarshshuwaa yarshshiyaa sa'aa bolla de'iyaa kac'etuwaa bolla s'okisso; atteeda suutsaa k'ay yarshshiyaa sa'aappe garssa baggana de'iyaa sa'aan gusso. ");
INSERT INTO dwrl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ittippetetsaa yarshshoo shuketteedda mod'd'uwaa k'aariide kessiyaawaadan, he dorssatti mod'd'uwaakka k'aariide kesso. Yaatiide, yarshshiyaa sa'aa bolla Med'inaa Godaw taman s'uuggiyaa yarshshuwaa bolla wotsiide s'uuggo. Hawaadan ootsiide, k'eesii he bitaniyaa nagaraa atto giissee. Bitaniikka bare nagaraappe maarettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","« ‹Ay asaynne markkaw s'eesettiide bare be'eeddawaa woy bare ereeddawaa gutaran markkattennaan is's'ooppe, hewe aw nagaraa; hewaa diraw I bare nagaraan ooshettee. ");
INSERT INTO dwrl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","« ‹K'ay ay asaynne erennan de'iidde tunabaa, do'aa bakkutaa woy mehiyaa bakkutaa woy sa'aanna gooshettiyaa do'atuwaa bakkutaa bochchooppe, tuna gidiyaawaa I ereedda wodiyaappe doommiide bayzzanchcha gideedda. ");
INSERT INTO dwrl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","« ‹K'aykka ay asaynne erennan de'iidde, asaa bollappe goggiyaa tunissiyaabaa ayaa gidinakka bochchooppe, hewe tuna gidiyaawaa I ereedda wodiyaappe doommiide bayzzanchcha gideedda. ");
INSERT INTO dwrl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","« ‹Woy k'ay ay asaynne iitabaa gidina lo\"obaa ootsanaw ellekka c'aak'k'ooppenne bare c'aak'k'eeddawaakka I akeekenan d'ayooppe, I akeekeedda wodiyaappe doomiide bayzzanchcha gideedda. ");
INSERT INTO dwrl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","« ‹Ay asaynne ha odetteedda bayzzatuwaappe ittuwaa ootseeddawaa gidooppe, bare ootseedda nagaraa paas'o. ");
INSERT INTO dwrl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","I bare ootseedda nagaraa diraw Med'inaa Godaw bare wudiyaa giddoppe mac'c'a dorssaa woy mac'c'a deeshshaa nagaraa yarshshuwaa ootsiide shiishsho. K'eesii akkiide, he bitaniyaa nagaraa atto giissanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","« ‹Asay bare ootseedda nagaraw yarshshanaw, dorssaa woy deeshshaa shamanaw aw shaluu gidana d'ayooppe, laa\"u harap'p'etuwaa, woy laa\"u dogomattuwaa, ittuwaa nagaraa yarshshuwaa ootsiide, k'ay ittuwaa s'uuggiyaa yarshshuwaa ootsiide Med'inaa Godaw aho. ");
INSERT INTO dwrl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","I unttuntta k'eesiyaw immo. K'eesii laa\"u harap'p'etuwaappe ittinniw k'ood'iyaa muuc'enan c'oo mirk'k'iide, nagaraa yarshshuwaa ootsiide yarshsho. ");
INSERT INTO dwrl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Yaatiide he nagaraa yarshshuwaa suutsaappe amareedawaa akkiide, yarshshiyaa sa'aa miyyiyaan c'ac'c'afo; atteeda suutsaa yarshshiyaa sa'aappe garssa baggana gusso; hewe nagaraa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Yenkko harap'p'atto k'ay higgii azaziyaawaadan, s'uuggiyaa yarshshuwaa ootsiide s'uuggo. K'eesii hewaadan ootsiide, bitanii ootseedda nagaraa atto giissanaw yarshshuwaa yarshshee; bitaniikka bare nagaraappe maarettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","« ‹Shin itti uraw laa\"u wogga dogomattuwaa woy laa\"u harap'p'etuwaa ahanaw shaluu gidana d'ayooppe, laa\"u kiilo giraame liik'o d'iiliyaa bare nagaraw shiishshiyaa yarshshuwaa ootsiide aho. He d'iilii nagaraa yarshshuwaa gidiyaa diraw, wogaraa zayitii woy is'aanay aan gujettoppo. ");
INSERT INTO dwrl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","I hewaa ahiide k'eesiyaw immo; k'eesii he d'iiliyaappe itti kushiyaa kuntsi akkiide, Med'inaa Godaw shiishshiyaa hara yarshshuwaa bolla wotsiide, hassayissiyaawaa ootsiide yarshshiyaasan de'iyaa taman s'uuggo; hewe nagaraa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ha geetetteeddawanttuppe hak'awaaninne gido bitanii ootseedda nagaraw k'eesii hawaadan ootsiide, bitanii ootseedda nagaraa atto giissee; bitaniikka bare nagaraappe maarettanawaa. Katsaa yarshshuwaadankka atteedawaa k'eesii akko yaagaade oda› » yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Med'inaa Goday Musew hawaadan yaagiide odeedda; ");
INSERT INTO dwrl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Ooninne Med'inaa Godaw geeshshi wotseedda miishshatuwaa bolla ammanettenan d'ayooppe k'ay erennan nagaraa ootsooppe, bare naak'oo bare wudiyaa giddoppe tilla bollaanna de'iyaa itti dorssaa orggiyaa Med'inaa Godaw aho. Aa gatiikka Med'inaa Godaa Dunkkaaniyaan eretiyaa miizaanan wotsina eretto; hewe naak'uwaa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Med'inaa Godaw dummayi wotseedda miishshatuwaa bolla I nagaraa ootseedda diraw, I he miishshatuwaa gatiyaa c'iggo; kase gatiyaa bolla s'eetuwaappe laatamu kushiyaa gujjiide k'eesiyaw immo. K'eesii he naak'uwaa yarshshoo aheedda dorssaa yarshshiide, bitaniyaa nagaraa atto giissee; bitaniikka bare naak'uwaappe maarettanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Ay asaynne erennan de'iidde, Med'inaa Goday, ‹Ootsoppa› giide azazeeddawaappe ittuwaa ootsiide nagaran gelooppe, I erana d'ayooppe bayzzanchcha gidiyaa diraw, bare nagaraan ooshettee. ");
INSERT INTO dwrl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","I bare wudiyaappe tilla bollaanna de'iyaa itti dorssaa orggiyaa naak'uwaa yarshshoo k'eesiyaakko aho. He dorssay naak'oo c'iggiyaa gatiyaa kessiyaawaa gido; yaatooppe k'eesii he dorssaa yarshshiide, bitaniyaa naak'uwaa atto giissee; bitaniikka bare naak'uwaappe maarettee. ");
INSERT INTO dwrl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Hewe naak'uwaa yarshshuwaa. I tumukka Med'inaa Godaa naak'k'eedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Med'inaa Goday Musew hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Med'inaa Goday ooninne nagaraa ootsiide bare shooruwaa worddotiide c'immooppe hawaappe kaaliide de'iyaa higgetuwaa immeedda: shooruwaa matan hadaraa wotsobaa woy oytsiide tal\"eeddabaa kaadooppe, woy asaawaa bonk'k'ooppe, woy bare shooruwaa bollan sugetsaa ootsooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","woy bayeeddawaa demmiide ta be'abeykke gooppenne wordduwaan c'aak'k'ooppe, hawantta malatiyaawanttuppe ittuwaa ootsooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","I hak'awaanne gido, ootsiide, hewaan nagaranchcha gidooppe, bare bonk'k'i akkeeddawaa, woy oytsina kaddiide akkeeddawaa, woy hadaraa immeeddawaa woy, bayinna demmeeddawaa, ");
INSERT INTO dwrl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","woy wordduwaan c'aak'k'i akkeeddawaa ubbaakka Aa godaw zaaro. K'ay bare naak'uwaa yarshshuwaa yarshshiyaa gallassi bare akkeeddawaa bolla s'eetuwaappe laatamu kushiyaa gujjiide Aa godaw immo. ");
INSERT INTO dwrl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","K'aykka bare naak'uwaa diraw Med'inaa Godaw yarshshiyaa yarshshoo bare wudiyaa giddoppe tilla bollaanna de'iyaa itti dorssaa orggiyaa k'eesiyaakko aho. He dorssaa gatii suure k'ofetteeddawaa gido. ");
INSERT INTO dwrl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","K'eesii he dorssaa Med'inaa Godaa sintsan yarshshiide, bitaniyaa naak'uwaa atto giissee; bitaniikka bare naak'uwaa ubbaappe maarettanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Med'inaa Goday Musew hawaadan yaagiide odeedda; ");
INSERT INTO dwrl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«Aaroonanne Aa attuma naanatuwaa hawaadan yaagaade azaza; ‹S'uuggiyaa yarshshoo de'iyaa wogay hawaa: S'uuggiyaa yarshshuu k'amay wonttana gakkanaw yarshshiyaa sa'aan de'o. Tamaykka yarshshiyaa sa'aan ubbaa wode ees's'iidde de'o. ");
INSERT INTO dwrl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","K'eesii liinuwaappe dadetteedda k'amishiyaanne suriyaa mayyiide, s'uuggiyaa yarshshuwaa tamay mi simmina atteeda bidintsaa dentsiide, yarshshiyaa saa miyyiyaan laalo. ");
INSERT INTO dwrl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Hewaappe guyyiyaan, he mayuwaa k'aari wotsi hara mayuwaa mayyiide, he bidintsaa dunkkaaneedda sa'aappe gas'aa afiide, higgiyaadan geeyeedda sa'aan k'olo. ");
INSERT INTO dwrl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yarshshiyaa sa'aa bolla de'iyaa tamay to'ennan ubbaa wode ees's'iidde de'o. K'eesii wontta wontta mitsaa aan gujji gujjiide wotso. S'uuggiyaa yarshshuwaakka he mitsaa bolla maaran wotsiide, ittippetetsaa yarshshuwaa handdaa Aa bolla s'uuggo. ");
INSERT INTO dwrl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Tamay yarshshiyaa sa'aa bolla ubbaa wode ees's'iidde de'o; to'anaw koshshenna. ");
INSERT INTO dwrl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","« ‹Katsaa yarshshoo imetteedda wogay hawaa: Aaroona attuma naanaa gidiyaa k'eesatuu yarshshiyaa sa'aappe sintsa baggana Med'inaa Godaa sintsan shiishshino. ");
INSERT INTO dwrl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","K'eesii lo\"o d'iiliyaappe kop'p'iyaawaanne zayitiyaa akkiide, katsaa yarshshuwaa bolla de'iyaa is'aanaa ubbaakka dentsiide, Med'inaa Godaw sawuwaa toshukku giyaa yarshshuwaa ootsiide, hassayissiyaawaa gidanaadan yarshshiyaa sa'aa bolla s'uuggo. ");
INSERT INTO dwrl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Hewaappe atteedawaa Aarooninne Aa attuma naanay miino; hewaa unttunttu irshshuu yegettibeenna ukitsaa ootsi uukkiide, Dunkkaaniyaa dabaabaa giddon de'iyaa geeshsha sa'aan miino. ");
INSERT INTO dwrl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","He ukitsay irshshuwaa yeggenaan uuketto. Hewaa taw taman s'uuggiyaa yarshshuwaappe unttuntta gakkiyaawaa taani unttunttoo immaad. Nagaraa yarshshuwaadaaninne naak'uwaa yarshshuwaadan ikka loytsiide geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Med'inaa Godaw taman s'uuggiyaa yarshshuwaappe unttuntta gakkiyaawaa gidiyaa diraw, yiyaa laytsatuwaankka Aaroona zare gidiyaa attumawanttu ubbay hewaa miino. He yarshshuwaa bochchiyaa ayaynne geeshsha gidana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Med'inaa Goday k'aykka Musew hawaadan yaagiide odeedda; ");
INSERT INTO dwrl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«Aarooninne Aa attuma naanattuwaappe k'eesatetsaa kaappotetsaw okettiyaa gallassi laa\"u kiilo giraame gidiyaa lo\"o d'iiliyaa katsaa yarshshuwaa ootsiide Med'inaa Godaw ahino. Hewaappe bagga wontta, bagga omarssi yarshshino. ");
INSERT INTO dwrl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","He d'iilii zayitiyaan munak'etti lo\"o walakettiide bashiyaan uuketto; bunchchaade, sawuwaa toshukku giyaa katsaa yarshshuwaa ootsaade Med'inaa Godaw shiishsha. ");
INSERT INTO dwrl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","K'ay Aaroona attuma naanatuwaappe Aa k'eesetetsaa kaappotetsaa oosoo okettiyaa ubbaykka he wogaa ootsino. Hewe Med'inaa Godaw ubbaa gede yarshshiyaa yarshshuwaa gidiide ubbaanna s'uugetto. ");
INSERT INTO dwrl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","K'eesii shiishshiyaa katsaa yarshshuwaappe guyye attenaan wuri s'uugetto; aappe ayaynne meetettoppo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Med'inaa Goday Musew hawaadan yaagiide odeedda; ");
INSERT INTO dwrl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«Aaroonassanne Aa attuma naanaatoo, hawaadan yaaga; ‹Nagaraa yarshshuwaa wogay hawaa: Med'inaa Godaw s'uuggiyaa yarshshoo shiishshiyaa mehii shukettiyaa sa'aan nagaraa yarshshoo shiishshiyaa mehiikka hewaan S'oossaa sintsan shuketto; ikka geeshsha yarshshuwaa ubbaappe ittuwaa gideedda geeshsha yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","He yarshshuwaa yarshshiyaa k'eesii Dunkkaaniyaa dabaabaa giddon de'iyaa geeshsha sa'aan mo. ");
INSERT INTO dwrl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","He ashuwaa bochchiyaa ayaynne geeshsha gidanawaa; k'ay shukkishiin ay mayuwaa bollanne suutsay d'ac'ettooppe, he mayuu geeshsha sa'aan meec'etto. ");
INSERT INTO dwrl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ashuu doyssetteedda urk'k'aa miishshay me\"o; madaabiyaa birataa disttiyaan doyisseeddawaa gidooppe, he disttiyaa k'aac'iide haatsaan shoki digganaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","K'eesatuwaa zariyaappe attuma asaa gideedda ooninne he ashuwaa mo; he ashuu geeshsha ubbaappe ittuwaa gideedda loytsi geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Gido shin Geeshsha Sa'aan nagaraa atto giissanaw Aa suutsaa akkiide, Dunkkaaniyaa giddo gelisseedda ay mehiyaa ashuwaanne maanaw koshshenna; I taman s'uugettanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","« ‹Naak'uwaa yarshshuwaa wogay hawaa: ikka geeshsha ubbaappe ittuwaa gideedda geeshsha yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","S'uuggiyaa yarshshoo shiishshiyaa mehiyaa shukkiyaa sa'aan naak'uwaa yarshshuwaa mehiyaakka shukkino; Aa suutsaakka yarshshiyaa sa'aa miyyetuwaan d'ac'ino. ");
INSERT INTO dwrl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","K'ay Aa handdaa ubbaa: hewekka nasiyaa handdaa, k'antsaa ashuwaa mayyeedda handdaa, ");
INSERT INTO dwrl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","laa\"u kilahotuwaa, shinc'c'iyaa matan de'iyaa unttunttu mayyeedda handdaanne tiriyaa s'eeraa bolla de'iyaa mood'iyaa kilahotuwaana ittippe yarshshuwaa ootsiide shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Taman s'uugiide Med'inaa Godaw yarshshiyaa yarshshuwaadan, he shiik'eedda handdaa k'eesii yarshshiyaa sa'aa bollan s'uuggo; hewe naak'uwaa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","K'eesiyaa zare gideedda attuma Asay ubbay he yarshshuwaa ashuwaa mo. He yarshshuu geeshsha yarshshuwaa ubbaappe ittuwaa gidiyaa diraw, geeshsha sa'aan mo. ");
INSERT INTO dwrl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","« ‹Naak'uwaa yarshshuu nagaraa yarshshuwaakka mala; unttunttu laa\"uwaa wogay ittuwaa. Hewenne yarshshetteedda mehiyaa ashuu nagaraa atto giissanaw yarshshuwaa yarshsheedda k'eesiyaw imettee. ");
INSERT INTO dwrl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ooninne s'uuggiyaa yarshshuwaa ahooppe yarshshiyaa k'eesii he mehiyaa galbbaa barew akko. ");
INSERT INTO dwrl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","C'ooc'iyaan komppetteedda katsaa yarshshuwaa ubbaynne otuwaan doyssetteedda woy bashiyaan uuketteedda ubbaykka he yarshshuwaa yarshsheedda k'eesiyaw imettee. ");
INSERT INTO dwrl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","K'ay zayitiyaan munak'etteedda woy munak'ettibeenna katsaa yarshshuwaa ubbay Aaroona attuma naanaatoo ubbaw imettee; unttunttu hewaa k'aran gishi akkino. ");
INSERT INTO dwrl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","« ‹Asay ittippetetsaa yarshshuwaa Med'inaa Godaw yarshshiyaa wode aw de'iyaa wogay hawaa: ");
INSERT INTO dwrl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","I shiishshiyaa ittippetetsaa yarshshuu galataa yarshshuwaa gidooppe, he yarshshuwaanna ittippe zayitiyaan munak'k'eedda, irshshuwaa yeggennaan uukkeedda ukitsaa, zayitiyaan oketteedda, irshshuu gelibeenna lee\"o daabbuwaanne zayitiyaan loytsi munak'k'eedda, liik'o d'iiliyaappe uuketteedda komppuwaa shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","He galataw shiishshiyaa ittippetetsaa yarshshuwaanna ittippe irshshuwaa yegeedda munak'aappe uuketteedda ukitsaakka imotaa ootsiide shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","K'ay he ubbaa k'ommo ukitsatuwaappekka I ittuwaa ittuwaa dentsiide, Med'inaa Godaw yarshshuwaa ootsiide aho. Hewe ittippetetsaa yarshshuwaa suutsaa c'ac'c'afeedda k'eesiyaw imetto. ");
INSERT INTO dwrl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","He mehiyaa ashuu galataw shiik'iyaa ittipetetsaw yarshshetteedda gallassi meetetto; wonttaw ayaynne attoppo. ");
INSERT INTO dwrl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","« ‹Shin Aa yarshshuu shiik'k'eeddawaa gatsiyaa woy bare dosuwaan c'oo immiyaa yarshshuwaa gidooppe, he yarshshuwaa ashuu he yarshsheedda gallassi meetetto; aappe attiyaawaa k'ay wonttetsa gallassikka meetetto. ");
INSERT INTO dwrl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","He yarshshuwaa ashuwaappe palahiide heezzentso gallassaa gakkanaw gam\"iyaawe de'ooppe, hewe taman s'uugetto. ");
INSERT INTO dwrl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Itti Asay shiishsheedda ittippetetsaa yarshshuwaa ashuwaappe hak'awenne heezzentso gallassi meetettooppe, Aa yarshshuu aketena; I yarshsheeddawaadankka paydetenna. He yarshshuu tuna; aappe meedda ooninne bare nagaraan ooshettee. ");
INSERT INTO dwrl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","« ‹Tunabaa ayaanne bochcheedda ashuu meetettoppo; I taman s'uugettanaw koshshee. Ashuu geeshsha ashuwaa gidooppe, wogaan geeshsha gidiyaa Asay ooninne maana gooppe mo. ");
INSERT INTO dwrl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Shin itti Asay tuna gidi uttiide, Med'inaa Godaw shiishsheedda ittippetetsaa yarshshuwaa ashuwaappe miyaawaa gidooppe, he Asay bare asaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","K'ay itti Asay tunabaa ayaanne bochchooppe asaa tunatetsaa gidina woy tuna mehiyaa gidina, woy hara sheneyiyaa tunabaa bochchooppe simmiide Med'inaa Godaw yarshsheedda ittippetetsaa yarshshuwaa ashuwaappe mooppe, he uray bare asaa giddoppe bohetto› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Med'inaa Goday Musew hawaadan yaagiide odeedda; ");
INSERT INTO dwrl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Israa'eeliyaa asaw hawaadan yaaga; ‹Korumaa woy dorssaa woy deeshshaa ashuwaan mood'iyaa zawaa mulekka mooppite. ");
INSERT INTO dwrl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Hayk'k'eedda mehiyaa woy do'ay wod'eedda mehiyaa mood'iyaakka harabaw go'ettiteppe attina, aappe ayaanne mooppite. ");
INSERT INTO dwrl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ayaw gooppe, Med'inaa Godaw taman s'uuggiyaa yarshshoo shiishshiyaa mehiyaa mood'iyaa miyaa ooninne bare asaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Hintte de'iyaa sa'aan hak'an gidooppekka, kafuwaa suutsaa, mehiyaa suutsaa woy harabaa ayaa suutsaanne mooppite. ");
INSERT INTO dwrl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Suutsaa miyaa ay asaynne, he Asay bare asaa giddoppe bohetto› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Med'inaa Goday Musew hawaadan yaagiide odeedda; ");
INSERT INTO dwrl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«Israa'eeliyaa asaw hawaadan yaaga; ‹Med'inaa Godaw ittippetetsaa yarshshuwaa shiishshiyaa ay asaynne he ittippetetsaa yarshshuwaappe shaakkiide, bare huup'e imotaa dummayiide Med'inaa Godaw shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Hewaa I Med'inaa Godaw taman s'uuggiyaa yarshshuwaa ootsiide, bare kushiyaan akkiide aho; k'ay mod'd'uwaakka anggoosuwaana aho; anggoosuwaa wus'akkiyaa yarshshuwaa ootsiide, Med'inaa Godaa sintsan k'aatso. ");
INSERT INTO dwrl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","K'eesii yarshshiyaa sa'aa bollan mod'd'uwaa s'uuggo; shin anggoosu Aaroonassanne Aa attuma naanaatoo imetto. ");
INSERT INTO dwrl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Hintte ittippetetsaa yarshshuwaappe ushechcha gediyaa imotaa ootsiide k'eesiyaw immite. ");
INSERT INTO dwrl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Hewe ushechcha gedii Aaroona attuma naanatuwaappe ittippetetsaa yarshshuwaa suutsaanne mooddiyaa yarshshiyaawoo Aa gakkiyaa Aa gishuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Taani Israa'eeliyaa asaa ittippetetsaa yarshshuwaappe k'aatseedda anggoosuwaanne yarshshoo shiishsheedda gediyaa akkaade, k'eesiyaa Aaroonassanne Aa attuma naanaatoo immaad; hewe unttuntta gakkiyaa unttunttu gishuwaa gidiyaa diraw, Israa'eeliyaa Asay med'inaw hewaa unttunttoo immiidde de'ana› yaagaade oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Aarooninne Aa attuma naanay K'eesiyaa gidiide, Med'inaa Godaw ootsanaw suntsetteedda gallassi Med'inaa Godaw shiishsheedda taman s'uuggiyaa yarshshuwaappe hewe unttunttoo gishuwaa gidiide imetteedda. ");
INSERT INTO dwrl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Med'inaa Goday unttunttu k'eesetetsaw oketteedda gallassi, hewaa unttunttoo immana mala, Israa'eeliyaa asaa ubbaa azazeedda; sintsa yeletaan ubbankka hawe woga gidiide oosettee. ");
INSERT INTO dwrl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Simmi hawanttu, s'uuggiyaa yarshshoo, katsaa yarshshoo, nagaraa yarshshoo, naak'uwaa yarshshoo, k'eesatetsaw okettiyaa wode yarshshiyaa yarshshoonne ittippetetsaa yarshshoo imetteedda wogatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ha wogatuu Israa'eeliyaa Asay Siinaa mela sa'aan barenttu yarshshuwaa Med'inaa Godaw yarshshana mala Med'inaa Goday azazeedda gallassi, Siinaa Deriyaa bollan Med'inaa Goday Musa azazeedda wogatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Med'inaa Goday Musew hawaadan yaagiide odeedda; ");
INSERT INTO dwrl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Aaroonanne Aa attuma naanatuwaa k'ay unttunttunna ittippe, k'eesatetsaa mayuwaa, okkiyaa zayitiyaa, nagaraa yarshshoo shukkiyaa korumaa, laa\"u dorssaa orggetuwaanne, irshshuwaa yeggennaan uukkeedda ukitsaa wotseedda masoofiyaa akkaade ya. ");
INSERT INTO dwrl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","K'ay Israa'eeliyaa asaa ubbaakka s'eesaade, Dunkkaaniyaa kare shiishsha» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Muse Med'inaa Goday azazeeddawaadan ootseedda; asaykka ubbay Dunkkaaniyaa karen shiik'eedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Muse asaw, «Ootsana mala Med'inaa Goday azazeeddawe hawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Muse Aaroonanne Aa attuma naanatuwaa ahiide, haatsaan meec'c'eedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Aaroona k'amishiyaa mayzzeedda; danc'c'uwaakka danc'c'isseedda. K'ay adussa k'amishiyaa mayzziide, Aa bollan eefuudiyaa mayzzeedda. Eefuudiyaa hiillatiide daddeedda sak'k'iyaan Aaroonana gatsiide k'achcheedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","K'ay tiraan wotsiyaawaa Aaroona bollan aatsiide, Aa giddon Uuriimiyaanne Tuumiimiyaa wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","K'aykka Aaroona huup'iyaan shaashiyaa enc'c'urssaa wotseedda. Med'inaa Goday Musa azazeeddawaadan he enc'c'urssaa bollan sintsa baggana work'k'aa madaaliyaa, work'k'aappe med'd'eedda kalachchaa misiliyaa wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Yaatowaappe guyyiyaan Muse okkiyaa zayitiyaa akkiide, Dunkkaaniyaanne Dunkkaaniyaa giddon de'iyaa miishshaa ubbaa okkeedda; unttuntta geeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","K'ay he zayitiyaappe akkiide, yarshshiyaa sa'aa bolla laappu gede c'ac'c'afeedda; yarshshiyaa sa'aa, Aa miishshatuwaa, meechchaa keriyaanne Aa wotsiyaawaa, geeshshanaw he zayitiyaan okkeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","K'ay he okkiyaa zayitiyaappe amaraa Aaroona huup'iyaan tigiide, Aa geeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Med'inaa Goday Musa azazeeddawaadan, Muse Aaroona attuma naanatuwaa sintsaw aatsiide, k'amishiyaa mayzzeedda; danc'c'uwaan danc'c'isseedda. Unttunttu shaashiyaa enc'c'urssaa wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Hewaappe guyyiyaan, nagaraa yarshshoo korumaa Muse aatseedda; Aarooninne Aa attuma naanay he korumaa huup'iyaan barenttu kushiyaa wotseeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Muse he korumaa shukkeedda; Aa suutsaappe bare birad'd'iyaan akkiide, yarshshiyaa sa'aa kac'etuwaa okkiide, yarshshiyaa sa'aa geeshsheedda; k'ay yarshshiyaa sa'aa nagaraa atto giissanaw atteeda suutsaa aappe garssana gussiide, S'oossaw geeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","K'antsaa ashuwaa kammeedda handdaa ubbaa, tiriyaa s'eeraa bolla de'iyaa mood'iyaa, laa\"u kilahotuwaanne unttuntta kammeedda handdaa akkiide, Muse yarshshiyaa sa'aa bollan wotsiide s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Shin Med'inaa Goday Musa azazeeddawaadan, galbbaa, korumaappe atteedawaanne toc'iyaa dunkkaaneedda sa'aappe gas'aa kessiide, taman s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Yaati simmiide Muse s'uuggiyaa yarshshoo haniyaa dorssaa orggiyaa aheedda; Aarooninne Aa attuma naanay he dorssaa orggiyaa huup'iyaan barenttu kushiyaa wotseeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Muse he dorssaa orggiyaa shukkeedda; Aa suutsaa yarshshiyaa sa'aa miyyiyaa ubbaan gusseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","K'ay dorssaa orggiyaa ashuwaakka Aa k'ommuwaan k'ommuwaan k'ans's'eedda; k'ans's'etsaa, huup'iyaanne mood'iyaa yarshshiyaa sa'aa bolla wotsiide Muse s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","K'antsaa ashuwaanne gedetuwaa haatsaan meec'c'owaappe guyyiyaan, dorssaa ubbaanna Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa ootsiide, Med'inaa Goday Musa azazeeddawaadan yarshshiyaa sa'aa bollan wotsiide s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Hewaappe guyyiyaan, k'eesetetsaw okettiyaa wode shiishshiyaa laa'entso dorssaa Muse aheedda; Aarooninne Aa attuma naanay he dorssaa huup'iyaan barenttu kushiyaa wotseeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Muse he dorssaa shukkeedda; Aa suutsaappe akkiide, Aaroonaw ushechcha haytsaa s'eeraa, ushechcha kushiyaa wogga birad'd'iyaanne, ushechcha gediyaa wogga birad'd'iyaa okkeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","K'ay Muse Aaroona attuma naanatuwaakka sintsaw ahiide, he suutsaappe akkiide, unttunttu ushechcha haytsaa s'eeraa, unttunttu ushechcha kushiyaa wogga birad'd'iyaanne unttunttu ushechcha gediyaa wogga birad'd'iyaa okkeedda. Hewaappe guyyiyaan, Muse atteeda suutsaa yarshshiyaa sa'aa miyyiyaa ubbaan gusseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Yaatiide mod'd'uwaa, nasiyaa, k'antsaa ashuwaa mayyeedda mood'iyaa, tiriyaa s'eeraa bolla de'iyaa mood'iyaa, laa\"u kilahotuwaanne unttuntta mayyeedda handdaanne ushechcha gediyaa akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","K'ay irshshuwaa yeggenaan uukkeedda ukitsaa wotsiyaa Med'inaa Godaa sintsan de'iyaa masoofiyaappe itti komppuwaa, zayitiyaanna uukkeedda itti ukitsaanne itti lee\"o ukitsaa akkiide, hawantta mood'iyaa bollaaninne ushechcha gediyaa bollan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","I ha k'umaa ubbaa Aaroona kushiyaaninne Aa attuma naanatuwaa kushiyaan wotseedda; unttunttu Med'inaa Godaa sintsan k'aatsiyaa yarshshuwaa ootsiide k'aatseeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Hewaappe guyyiyaan, Muse he k'umaa unttunttu kushiyaappe akki, s'uuggiyaa yarshshuwaanna gatsiide, k'eesetetsaw okettiyaa wode Med'inaa Godaw taman s'uugiide shiishshiyaa, sawuwaa toshukku giyaa yarshshuwaadan, yarshshiyaa sa'aa bollan wotsiide s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","K'ay Muse anggoosuwaa akkiide, k'aatsiyaa yarshshuwaa ootsiide Med'inaa Godaa sintsan k'aatseedda; Med'inaa Goday Musa azazeeddawaadan, k'eesatetsaw okettiyaa wode yarshshiyaa dorssaa orggiyaa ashuwaappe hewe Musa gakkiyaa Aa gishuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Muse okkiyaa zayitiyaappenne yarshshiyaa sa'aa bollan de'iyaa suutsaappe akkiide, Aaroona bollanne Aa mayuwaa bolla, k'ay Aa attuma naanatuwaa bollanne, unttunttu mayuwaa bollakka c'ac'c'afeedda; yaatiide Aaroonanne Aa mayuwaa k'ay Aa naanatuwaanne Aa naanatuwaa mayuwaakka geeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Muse Aaroonanne Aa attuma naanatuwaa hawaadan yaageedda; «Ashuwaa Gakettiyaa Dunkkaaniyaa karen doyissite; ‹Aarooninne Aa naanay hewaa miino› yaagaade taani azazeeddawaadan, k'eesatetsaw okettiyaa wode shiishshiyaa yarshshuwaa wotsiyaa masoofiyaa giddon de'iyaa yarshshuwaa ukitsaanna hewan miite. ");
INSERT INTO dwrl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","He ashuwaappenne ukitsaappe palaheeddawe de'ooppe taman s'uuggite. ");
INSERT INTO dwrl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","K'eesatetsaw okkiyaa wogay laappun gallassaa akkiyaa diraw, he hintte k'eesatetsaw okettiyaa laappun gallassay wuranaw, Dunkkaaniyaa penggeppe kare kesoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ha hachchi oosetteeddawe Med'inaa Goday azazina, hintte nagaraa atto giissanaw oosetteedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dunkkaaniyaa penggiyaan laappun gallassaa kumentsaa gallassinne k'ammanne takkite; Med'inaa Godaa wogaakka naagite; is's'ooppe hintte hayk'k'ana. Taana Med'inaa Goday azazeeddawe hawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aarooninne Aa naanay Med'inaa Goday Muse baggana azazeeddawaa ubbaa ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Hosppuntsa gallassan Muse Aaroonanne Aa naanatuwaa, k'ay Israa'eeliyaa c'imatuwaakka s'eeseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Aaroona hawaadan yaageedda; «Nagaraa yarshshoo itti korumaa, k'ay s'uuggiyaa yarshshoo itti dorssaa orggiyaa Med'inaa Godaa sintsa shiishsha. Mehetuu laa\"uukka tilla bollaanna de'iyaawantta gidino. ");
INSERT INTO dwrl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","K'ay Israa'eeliyaa asaa hawaadan yaaga; ‹Med'inaa Goday hinttenttoo k'onc'c'iyaa diraw, Med'inaa Godaa sintsan yarshshanaw, nagaraa yarshshoo itti deeshshaa orggiyaa, s'uuggiyaa yarshshoo tilla bollaanna de'iyaa itti laytsaa maraanne itti laytsaa dorssaa aho. ");
INSERT INTO dwrl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ittippetetsaa yarshshoo itti korumaa, itti dorssaa orggiyaanne zayitiyaan munak'etteedda katsaa yarshshuwaa ahite yaaga› » yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Unttunttu Muse azazeeddawaa ubbaa S'oossaa Dunkkaaniyaa sintsa aheeddino; yaatiide maabaraa ubbay shiik'iide, Med'inaa Godaa sintsan ek'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Muse unttuntta, «Med'inaa Godaa bonchchuu hinttenttoo k'onc'c'ana mala, hintte ootsanaadan Med'inaa Goday hinttena azazeeddawe hawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","K'ay Muse Aaroonaw hawaadan yaageedda; «Yarshshiyaa saakko haa shiik'a; ne nagaraa yarshshuwaanne ne s'uuggiyaa yarshshuwaa yarshsha; yaataade ne huup'e nagaraanne ne asaa nagaraakka atto giissa. K'ay Med'inaa Goday azazeeddawaadan, Asay shiishshiyaa yarshshuwaa yarshshaade, unttunttu nagaraakka atto giissa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aarooni yarshshiyaa saakko yiide, bare huup'e nagaraw yarshshuwaa ootsi shiishsheedda korumaa shukkeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Aaroona attuma naanay suutsaappe akkiide aw aheeddino; I bare kushiyaa birad'd'iyaa he suutsan yeddi kessiide, yarshshiyaa sa'aa kac'etuwaa bochcheedda; atteeda suutsaakka yarshshiyaa sa'aappe garssa baggana gusseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Med'inaa Goday Musa azazeeddawaadan, k'ay he nagaraa yarshshuwaa ashuwaappe mod'd'uwaa, kilahotuwaanne tiriyaa s'eeraa bolla de'iyaa mood'iyaa yarshshiyaa sa'aa bollan wotsiide s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Shin atteeda ashuwaanne galbbaa dunkkaaneedda sa'aappe kare kessiide s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Hewaappe guyyiyaan, Aarooni s'uuggiyaa yarshshuwaa shukkeedda; Aa naanay suutsaa akkiide aw aheeddino; I yarshshiyaa sa'aa miyyiyaa ubbaan gusseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","K'ay unttunttu s'uuggiyaa yarshshuwaa k'ommuwaan k'ommuwaan kessiide, huup'iyaanakka aw aheeddino; I yarshshiyaa sa'aa bollan wotsiide s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","K'antsaa ashuwaanne gedetuwaakka haatsaan meec'c'iide, yarshshiyaa sa'aa bollan de'iyaa s'uuggiyaa yarshshuwaa bollan wotsiide s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hewaappe guyyiyaan, Aarooni asaa yarshshuwaa shiishsheedda; I asaa nagaraa yarshshoo gidiyaa deeshshaa orggiyaa akkiide shukkeedda; kase barewaadankka unttunttu nagaraw yarshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","K'ay I s'uuggiyaa yarshshuwaa mehiyaa ahiide, wogay azaziyaawaadan ootsiide yarshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Katsaa yarshshuwaakka shiishsheedda; aappe itti kop'p'iyaa gidiyaawaa akkiide, wontta wontta s'uuggiyaa yarshshuwaappe haraa Aa bollan wotsiide s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aarooni k'aykka asaa ittippetetsaa yarshshoo korumaanne dorssaa orggiyaa shukkeedda; Aa attuma naanay suutsaa aw aheeddino; I he suutsaa akkiide, yarshshiyaa sa'aa miyyiyaa ubbaa gusseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","K'ay korumaanne dorssaa orggiyaa ashuwaappe mod'd'uwaa, nasiyaa, k'antsaa ashuwaa mayyeedda handdaa, kilahotuwaanne tiriyaa s'eeraa bolla de'iyaa mood'iyaa Aaroona naanay aw aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Unttunttu he handdaa anggoosuwaa bolla wotsina, Aarooni yarshshiyaa sa'aa bollan hewaa s'uuggeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Shin Muse azazeeddawaadan, Aarooni anggoosotuwaanne ushechcha gediyaa k'aatsiyaa yarshshuwaa ootsiide, Med'inaa Godaa sintsan k'aatseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Hewaappe guyyiyaan, Aarooni bare kushiyaa asaakko zaari dentsiide unttuntta anjjeedda. I nagaraa yarshshuwaa, s'uuggiyaa yarshshuwaanne ittippetetsaa yarshshuwaa yarshshowaappe guyyiyaan, yarshshiyaa sa'aappe duge wod'eedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musenne Aarooni Med'inaa Godaa Dunkkaaniyaa giddo geleeddino; unttunttu hewaappe keseedda wode, asaa anjjeeddino. Yaatina Med'inaa Godaa bonchchuu asaa ubbaw beetteedda. ");
INSERT INTO dwrl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Med'inaa Godaa sintsaappe tamay wod'iide, yarshshiyaa sa'aa bollan de'iyaa s'uuggiyaa yarshshuwaanne mood'iyaa meedda. Asay ubbay hewaa be'eedda wode ilileedda; k'ay unttunttu barenttu som\"uwaan sa'aa bochchiide guufanneeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aaroona attuma naanay, Naadaabinne Abihu, barenttu is'aanaa c'uwissiyaa miishshaa akkiide, Aa bollan tamaa wotseeddino; tamaa bolla k'ay is'aanaa k'oleeddino; yaatiide, Med'inaa Goday unttuntta azazibeena, hara tamaa Med'inaa Godaa sintsan shiishsheeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Hewaa gaasuwaan Med'inaa Godaa sintsappe tamay yiide, unttuntta meedda; unttunttukka Med'inaa Godaa sintsan hayk'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Hewaappe guyyiyaan, Muse Aaroona, «Med'inaa Goday, « ‹Taani ta mata shiik'iyaawantta ta geeshshatetsaa bessana. K'ay asaa ubbaa sintsan taani bonchchettana› » giide haasayeeddawe be'a hawaa yaageedda. Aaroon c'o\"u geedda. ");
INSERT INTO dwrl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Muse Aaroona aawuwaa ishaa Uzi'eela attuma naanatuwaa, Mishaa'eelanne Els's'aafaana s'eegiide, «Haa yiite; hintte aawuwaa ishaa naanatuwaa anhaa S'oossaa Dunkkaaniyaa sintsaappe dentsiide, dunkkaaneedda sa'aappe gas'aa kessite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Hewaa diraw unttunttu yiide, Muse azazeeddawaadan, barenttu k'eesetetsaa mayuwaanna unttunttu anhaa tookkiide, dunkkaaneedda sa'aappe gas'a keseeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Hewaappe guyyiyaan, Muse Aaroonanne Aa attuma naanatuwaa, El\"aazaranne Itaamaara hawaadan yaageedda; «Hintte hayk'k'enna malanne, Med'inaa Goday maabaraa ubbaa bollan hank'k'ettenna mala, hintte huup'iyaa meedissoppite; hintte mayuwaakka peed'oppite. Shin hintte ishatuu, Israa'eeliyaa asatuu, Med'inaa Goday bare eetseedda taman s'uuggeeddawanttoo yeekkana gooppe unttunttu yeekkino. ");
INSERT INTO dwrl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","K'aykka hintte Dunkkaaniyaa penggiyaappe kare kesooppe hintte hayk'k'ana; ayaw gooppe S'oossay okkiyaa zayitii hintte bollan de'ee» yaageedda. Unttunttukka Muse geeddawaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Med'inaa Goday Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Hintte hayk'k'enna mala, Dunkkaaniyaa giddo geliyaa wode, neenikka ne naanaykka woyniyaa eessaa woy hara matsoyiyaa ushshaa ushshoppite; hewe sintsaappe yaana yeletawukka med'inaw higge gidiide de'ana. ");
INSERT INTO dwrl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Hintte geeshshanne geeshsha gidennabaa k'ay tunanne tuna gidennabaa shaakkiide erite. ");
INSERT INTO dwrl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Med'inaa Goday Muse baggana odeedda wogaa ubbaakka Israa'eeliyaa asaa tamaarissite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Muse Aaroonanne atteeda Aa attuma naanatuwaa El\"aazaranne Itaamaara hawaadan yaageedda; «Med'inaa Godaw taman s'uuggiyaa yarshshuwaappe atteeda katsaa yarshshuwaa akkiide; irshshuwaa yeggenaan uukkite; yaatiide I loytsi geeshsha gidiyaa diraw, yarshshiyaa sa'aa matan Aa miite. ");
INSERT INTO dwrl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Med'inaa Godaw taman s'uuggiyaa yarshshuwaappe hewe neenanne ne attuma naanatuwaa gakkiyaa hintte gishuwaa gidiyaa diraw, hewaa hintte geeshsha sa'aan miite; ayaw gooppe, S'oossay taana hewaadan ootsana mala azazeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Shin k'aatseedda anggoosuwaanne shiik'eedda gediyaa neeni, ne attuma naanaynne ne mac'c'a naanay wogaadan geeshsha sa'aan miite. Ayaw gooppe, hewe Israa'eeliyaa Asay shiishshiyaa ittippetetsaa yarshshuwaappe neenanne ne attuma naanatuwaa gakkiyaa hintte gishuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Med'inaa Godaw yarshsheedda gediyaanne k'aatseedda anggoosuwaa Asay taman s'uuggiyaa mood'iyaanna ittippe gatsiide, Med'inaa Godaa sintsan k'aatsiyaa yarshshuwaadan k'aatsanaw ahana. Med'inaa Goday azazeeddawaadan, hewe newunne neenana de'iyaa ne attuma naanaatoo med'inaw hinttena gakkiyaa hintte gishuwaa gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Muse nagaraa yarshshuwaa deeshshay waaneedenttonne eranaw koyiide oochcheedda; I s'uugetti diggeeddawaa ereedda wode, atteeda Aaroona attuma naanatuwaa, El\"aazaranne Itaamaara hank'k'etteedda; unttunttu, ");
INSERT INTO dwrl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Nagaraa yarshshuu loytsi geeshsha gideeddawanttu giduwaappe ittuwaa gideedda geeshsha; k'ay hewekka asaa nagaraa Med'inaa Godaa sintsan atto giissana mala hinttenttoo imetteedda; yaatina hintte Aa loytsi geeshsha sa'aan ayaw mibeykkitee? ");
INSERT INTO dwrl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","He mehiyaa suutsay Med'inaa Godaa Dunkkaaniyaa giddo gelibeennawaa gidoode, taani hinttena azazeeddawaadan, hintte Aa he geeshsha sa'aan maanaw bessee; shin aggeeddita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aarooni Musa, «Be'a; asatuu hachchi barenttu nagaraa yarshshuwaanne s'uuggiyaa yarshshuwaa Med'inaa Godaa sintsa aheeddino; gidooppenne k'ay hawaa malabay ta bolla gakkeedda. Yaatina won taani nagaraa yarshshuwaa hachchi meeddawaa gidinttonne, Med'inaa Goday nashettanawaa shin atteedeeshsha?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Muse hewaa siseedda wode, he zaaruu Aa aleeda. ");
INSERT INTO dwrl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Med'inaa Goday Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«Israa'eeliyaa asaw hawaadan yaagiide odite; ‹Biittaa bollan de'iyaa mehiyaa ubbaappe hintte maana mehetuunne do'atuu hawantta. ");
INSERT INTO dwrl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","S'uguntsay wuri p'alk'k'etteeddawanttanne waammotiyaa mehetuwaa ubbaa miite. ");
INSERT INTO dwrl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Shin waammo s'alalaa waammotiyaawantta woy k'ay s'uguntsaa s'alalay p'alk'k'etteeddawantta mooppite. Gaaluu waammotee shin s'uguntsay p'alk'k'etibeenna diraw I hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Guppallii waammotee shin s'uguntsay p'alk'k'etibeenna diraw I hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Harbbayinni waammotee shin mooppite; ayaw gooppe, I waammotiyaawaa gidooppenne, aw s'uguntsay p'alk'k'etsaa gidena diraw, I hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Guduntsaakka mooppite; ayaw gooppe, aw s'uguntsay p'alk'k'etsaa gidooppenne, waammotenna diraw, I hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Hintte hawanttu ashuwaa mooppite; unttunttu bakkutaakka bochchoppite; unttunttu hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","« ‹Haatsaa giddon de'iyaa med'etatuwaa ubbaappe hintte maanawanttu hawantta. Abbaa giddon gidina woy k'ay goggiyaa haatsaa giddon gidina de'iyaa ubbaappe moliyaa mala k'efiinne pok'uu de'iyaa ubbaa miite. ");
INSERT INTO dwrl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Shin abbaa giddon woy shaafaan sham\"isham\"iyaa med'etatuwaappenne shemppuu de'iyaa, k'aas's'iyaa med'etatuwaappe moliyaa mala k'efiinne pok'uu baynna ubbay hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Hawanttu hinttenttoo tuna; unttunttu ashuwaa mooppite; unttunttu bakkutaakka bochchoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","K'efiinne pok'uu baynna haatsaa giddon de'iyaa med'etatuu ubbay hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","« ‹Kafotuwaappe tuna gidiyaa diraw hintte meennawanttu hawantta: arggantsaa, bazzuwaa ankkuwaa, karetsa ankkuwaa, ");
INSERT INTO dwrl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","s'inggilliyaa, k'oolli zariyaa ubbaa, ");
INSERT INTO dwrl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","k'uuruwaa zariyaa ubbaa, ");
INSERT INTO dwrl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","sogoniyaa, Hazaziyaa, haatsaa kafuwaa, gac'iyaa zariyaa ubbaa, ");
INSERT INTO dwrl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","k'eeri guttuwaa, biyyuwaa, wogga guttuwaa, ");
INSERT INTO dwrl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","haatsaa kuttuwaa, moliyaa kafuwaa, bakkuta miyaa ankkuwaa, ");
INSERT INTO dwrl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","shimalaanne saabiissaa giyaa haatsaa kafotuwaa zariyaa ubbaa, jinjjilaatiyaanne shaaliyaa. ");
INSERT INTO dwrl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","« ‹K'efiyaana de'iyaa oyddu gediyaan hametiyaa k'eeri med'etatuu ubbay hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Gidooppenne, k'efii de'iyaa oyddu gediyaan hamettiyaawanttuppe unttunttu gediyaappe bollana guppanaw maaddiyaa gedii de'iyaawantta miite. ");
INSERT INTO dwrl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Hewanttukka, booliyaa zariyaa ubbaa, ukkubbo zariyaa ubbaanne bumbburetsaa zariyaa ubbaa. ");
INSERT INTO dwrl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Shin hara k'efiyaana de'iyaa oyddu gedii de'iyaa med'etatuu ubbay hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","« ‹Hawanttu hinttena tunissana; unttunttu bakkutaa bochchiyaa ubbay omarssi gakkanaw tuna gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Hawanttu bakkutaa dentsiyaa ooninne bare mayuwaa meec'c'o; shin gidooppenne omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","S'uguntsay de'iidde p'alk'k'etsaa gidennawantta woy k'ay, waammotennawanttu ubbay hinttenttoo tuna; unttunttu anhaa bochchiyaa oonikka k'ay tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Oyddu gedetuwaan hametiyaa mehiyaa ubbaappe adanetuwaa ginddiyaa mala ginddiyaan hametiyaawanttu hinttenttoo tuna; k'ay unttunttu bakkutaa bochchiyaa oonikka omarssi gakkanaw tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Hewanttu bakkutaa dentsiyaa ooninne bare mayuwaa meec'c'o; shin gidooppenne omarssi gakkanaw I tuna. Unttunttukka hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","« ‹Sa'aanna hamettiyaawaanttuppe hawanttu hinttenttoo tuna: oc'c'uu, ec'erii, dumma dumma k'ommo zarii, ");
INSERT INTO dwrl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","geeggi, hayllaashshuu, korchchii, wakkallaynne shaak'anchchay. ");
INSERT INTO dwrl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Sa'aanna hametiyaa ubbatuwaappe hinttenttoo tuna gidiyaawanttu hewantta; unttunttuppe hayeeddawaa bochchiyaa ubbay omarssi gakkanaw tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Unttunttuppe hayk'k'eeddawe ayaa bolla kunddooppekka he unttunttu Aa bolla kunddeedda miishshay tuna; mitsaa miishshaa woy mayuwaa woy galbbaa woy keeshshatuwaa gidinakka, go'ettiyaa miishshaa ubbaa haatsaa giddon wotsite; hewe omarssi gakkanaw tuna; Hewaappe guyyiyaan, geeshsha gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ha sa'aanna hamettiyaawanttuppe ittuwaa bakkutay ay urk'k'a miishshaa giddon kunddooppekka, Aa giddon de'iyaabay ubbay tuna; he miishshaa mentsite. ");
INSERT INTO dwrl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","He miishshaa giddon de'iyaa haatsaappe meetettiyaa ay k'uma bolla s'okooppekka, he k'umay tuna; k'ay ushiyaabaa ayaanne giddo, he miishshaa giddon de'ooppe, ikka tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Hawanttu anhay Aa bolla kunddiyaabay ayaa gidooppekka tuna. C'ooc'iyaa woy katsiyaa urk'k'aa miishshaa gidooppekka mentsite; unttunttu hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Hawanttu bakkutay bochchiyaabay ubbay tuna gidooppenne, pulttuunne haatsaa ollay geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Unttunttu bakkutaappe ittuu zeranaw wotseedda zeretsaa katsaa bolla kunddooppe, hewe tunenna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Shin he zeretsaa bolla haatsay gukki simmina, unttunttu bakkutaappe ittuunne Aa bolla kunddooppe, he zeretsay hinttenttoo tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","« ‹K'ay hintte miyaa mehetuwaappe ittuu hayk'k'ina, Aa bakkutaa bochchiyaa ooninne omarssi gakkanaw tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ooninne he mehiyaa bakkutaappe mooppe, bare mayuwaa meec'c'o; omarssi gakkanaw I tuna; k'ay ooninne Aa bakkutaa tookkiide dentsooppe, bare mayuwaa meec'c'o; omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","« ‹Sa'aanna gooshettiyaa med'etaa ubbay hinttenttoo tuna; Aa mooppite. ");
INSERT INTO dwrl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Uluwaan gooshettiyaawaa gidina, woy oyddu gediyaan hametiyaawaa gidina, woy k'ay daro gedii de'iyaawaa gidinakka, sa'aanna gooshettiyaa med'etaa ubbay tuna gidiyaa diraw Aa mooppite. ");
INSERT INTO dwrl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Sa'aanna gooshettiyaa med'etatuwaa ubbaan miide hintte huup'iyaw tunoppite; k'ay unttunttun hintte asatetsaa tunissoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Taani, Med'inaa Goday, hintte S'oossaa. Taani geeshsha gidiyaa diraw, hinttekka hinttena dummayiide, geeshsha gidite. Sa'aanna gooshettiyaawanttun hintte asatetsaa tunissoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ayaw gooppe, Taani hintte S'oossaa gidanaw, hinttena Gibs'e gadiyaappe kesseedda Med'inaa Godaa. Hewaa diraw, Taani geeshsha gidiyaa diraw, hinttekka geeshsha gidite yaagite yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","« ‹Mehetuwaa, kafotuwaa, haatsaa giddon pas'a k'aas's'iyaa med'etatuwaa ubbatuunne sa'aanna hametiyaa med'etatuwaa ubbatuwaa wogay hawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Hewenne hintte tunaanne geeshsha, k'ay shemppuu de'iyaa med'etatuwaappe miyaawanttanne meennawantta shaakkiide eranaassa.› » ");
INSERT INTO dwrl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Itti mac'c'awuna shahaaraade attuma na'aa yelooppe, bare piilay yeedda wode iza tuna gidiyaawaadankka, hewaadan iza laappun gallassay gakkanaw tuna gidanaanu. ");
INSERT INTO dwrl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Hosppuntsa gallassi na'ay k'as's'arettanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Hewaappe guyyiyaan, mac'c'awunna bare piilaa suutsay s'i\"ana gakkanaw, hattamanne heezzu gallassaa gam\"u; k'ay bare geeyiyaa gallassatuu wurana gakkanaw, geeshshabaa ayaanne bochchuppu; S'oossaa Geeshsha Sa'aakka geluppu. ");
INSERT INTO dwrl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","« ‹Shin itti mac'c'awuna mac'c'a naatto yelooppe, bare piilay yeedda wode iza tuna gidiyaawaadankka, hawaadan laa\"u saaminttaa gakkanaw, iza tuna gidana; Hewaappe guyyiyaan, bare piilaa suutsay s'i\"ana gakkanaw usuppun tammanne usuppun gallassaa gam\"u. ");
INSERT INTO dwrl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","« ‹Mac'c'awuna attuma na'aa gidina mac'c'a na'aa gidina yelaade, bare geeyiyaa wodiyaa wurssowaappe guyyiyaan, s'uuggiyaa yarshshoo itti laytsaa dorssaanne nagaraa yarshshoo k'ay itti harap'p'iyaa maraa woy itti mara dogommuwaa S'oossaa Dunkkaaniyaa penggiyaan de'iyaa k'eesiyaakko ahu. ");
INSERT INTO dwrl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","K'eesii hewaa Med'inaa Godaa sintsan yarshshiide, izi nagaraa atto giissee; yaatooppe iza bare yeluwaa suutsaa gogetsaappe geeyaw. Attuma na'aa woy mac'c'a na'aa yeliyaa mac'c'awuni wogay hewaa. ");
INSERT INTO dwrl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","« ‹Shin itti laytsaa dorssaa orggiyaa ahanaw iziw shaluu gidana d'ayooppe, laa\"u mara dogomattuwaa woy laa\"u mara harap'p'atuwaa ahu; unttunttuppe ittuu s'uuggiyaa yarshshuwaassa; ittuu k'ay nagaraa yarshshuwaassa; yaatooppe k'eesii hewantta yarshshiide, izi nagaraa atto giissee; izakka geeshsha gidaw› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Med'inaa Goday Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Ay asaa bollanne gaafu beetooppe, woy d'uussa madutsay woy ilahuu kesooppenne k'ay hewekka Aa galbban wolk'k'aama galbbaa harggiyaw laamettooppe, he bitaniyaa k'eesiyaa Aaroonakko woy k'eesiyaa gidiyaa Aa attuma naanatuwaappe ittuwaakko ahino. ");
INSERT INTO dwrl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","K'eesii Aa galbbaa bollan de'iyaa madutsaa be'o. He madus'eedda sa'aan de'iyaa isikkii boos's'ooppenne, madutsaykka ollatooppe, hewe wolk'k'aama galbbaa hargge. K'eesii hewaa be'iide, he bitanii tuna gidiyaawaa erisso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Shin Aa galbbaa bollan de'iyaa shattuu boos's'inttokka, galbbaappe lukkiide ollatibeennawaa gidooppenne he madutsaa bollan de'iyaa isikkii boos's'ibeennawaa gidooppe, k'eesii he bitaniyaa dumma kifiliyaan laappun gallassaa gorddiide wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Laappuntsa gallassan k'eesii Aa zaaretsiidekka be'o; I be'iyaa wode madutsay bitaniyaa galbbaa bollan aakkennan kasewaadankka de'ooppe, k'eesii he bitaniyaa laa\"entsuwaakka dumma kifiliyaan laappun gallassaa gorddiide wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","K'aykka laappuntsa gallassan k'eesii Aa; be'iyaa wode madutsay aakkiyaawaa aggiide d'ay d'ay booppenne d'umooppe, k'eesii I geeshsha gidiyaawaa erisso. Hewe shattuwaappe attina harabaa gidenna; hewaa diraw, I bare mayuwaa meec'c'iide geeshsha gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Shin I geeyanaw barena k'eesiyaa besseeddawaappe guyyiyaan, he shattuu Aa galbbaa bollan yaa aakki aakki booppe, I laa\"entsuwaa barena bessanaw k'eesiyaakko bo. ");
INSERT INTO dwrl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","K'eesiikka Aa be'o; he shattuu bitaniyaa galbbaa bollan yaa aakki aakki booppe, k'eesii I tuna gidiyaawaa erisso; ayaw gooppe hewe wolk'k'aama galbbaa harggiyaa. ");
INSERT INTO dwrl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Oonanne wolk'k'aama galbbaa harggii oyk'k'ooppe, k'eesiyaakko Aa ahino. ");
INSERT INTO dwrl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","K'eesii Aa be'o; be'iyaa wode Aa galbbaa bollan bootsa gaafuu de'ooppe, he gaafuu isikiyaakka bootsaw laammooppenne he gaafuwaa giddon ashuu muunni utteeddawaa gidooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","hewe Aa galbbaa bollan gam\"eedda wolk'k'aama galbbaa harggiyaa gidiyaa diraw, k'eesii I tuna gidiyaawaa erisso. I tuna gidiyaawe eretti diggeedda diraw, Aa dumma kifiliyaan gorddanaw koshshenna. ");
INSERT INTO dwrl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","«K'ay wolk'k'aama galbbaa harggii bitaniyaa galbbaa bollan aakkiide, huup'iyaappe gediyaa gakkanaw ubbaan mayyeeddawaa gidooppe, k'eesii be'o. ");
INSERT INTO dwrl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","He wolk'k'aama galbbaa harggii Aa bollaa ubbaa mayyooppe, k'eesii I geeshsha gidiyaawaa erisso; Aa bollay ubbaannakka laamettiide bootsa gideedda diraw, I geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Shin he madutsaa giddon muunneedda ashuu beettooppe I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","K'eesii he muunneedda ashuwaa; be'iide he bitanii tuna gidiyaawaa erisso. He muunneedda ashuu wolk'k'aama galbbaa harggiyaa gidiyaa diraw, I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Shin he muunneedda ashuu k'aykka laamettiide boos's'ooppe, he bitanii k'eesiyaakko yo. ");
INSERT INTO dwrl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","K'eesii Aa be'o; Aa madutsay boos's'eeddawaa gidooppe, he bitanii geeshsha gidiyaawaa k'eesii erisso; yaatooppe I geeshsha gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Itti asaa bolla madutsay wod'd'iide pas'ina, ");
INSERT INTO dwrl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Aa sa'aan bootsa gaafuu beetooppe woy zo\"eedda ilahuu kesooppe, he uray barena k'eesiyaa besso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","K'eesii Aa be'o; he madutsay ollatooppenne madutsaa bollan de'iyaa isikiikka laamettiide boos's'ooppe, he bitanii tuna gidiyaawaa k'eesii erisso. Hewe madutsaanna doommeedda wolk'k'aama galbbaa harggiyaa. ");
INSERT INTO dwrl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Shin k'eesii be'iyaa wode, isikkii boos's'ibeennawaa gidooppenne madutsaykka galbbaa lukkiide ollatibeennawaa gidooppe, k'ay d'ay d'ay booppe, k'eesii Aa dumma kifiliyaan laappun gallassaa gorddiide wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Hewe Aa galbbaa bollan aakki aakkiide booppe, he bitanii tuna gidiyaawaa k'eesii erisso; ayaw gooppe, hewe galbbaa harggiyaa. ");
INSERT INTO dwrl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Shin he ilahuu aakki aakki beennan ittisaa s'alalaan de'ooppe, hewe madutsay pas'eedda mallaa gidiyaa diraw, he bitanii geeshsha gidiyaawaa k'eesii erisso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Itti asaa galbbaa tamay mooppenne he meedda sa'aan boos's'eedda woy zo\"eedda ilahuu kesooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","k'eesii he sa'aa be'o; Aa sa'aan de'iyaa isikkii boos's'ooppenne madutsaykka lukkiide ollatooppe, hewe wolk'k'aama galbbaa harggiyaa. I tamay meeddasaana keseedda; hewaa diraw k'eesii I tuna gidiyaawaa erisso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Shin k'eesii be'iyaa wode, he ilahuwaa bollan de'iyaa isikkii boos's'ibeennawaa gidooppenne madutsaykka galbbaa lukkiide ollatibeennawaa gidooppe, k'ay d'ay d'ay beeddawaa gidooppe, k'eesii Aa dumma kifiliyaan laappun gallassaa gorddiide wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Laappuntsa gallassan k'eesii Aa be'o; he wode he sa'ay aakki aakki booppe, I tuna gidiyaawaa k'eesii erisso. Hewe wolk'k'aama galbbaa harggiyaa. ");
INSERT INTO dwrl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Shin he ilahuu galbbaa bollan aakkennan aggiide itti sa'aan uttooppenne ubbaa k'ay d'ay d'ay booppe, hewe tamay meeddasaan atteeda mallaa gidiyaa diraw, I geeshsha gidiyaawaa k'eesii erisso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Itti attuma asaw woy mac'c'a asaw huup'iyaa woy gac'uwaa bollan madutsay kesooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","k'eesii he madutsaa be'o. I be'iyaa wode madutsay galbbaa lukkiide ollatooppenne Aa bollan de'iyaa isikiikka adilliyaa c'iishshaa malatiyaa lee\"o gidooppe, he bitanii tuna gidiyaawaa k'eesii erisso. Hewe huup'iyaa woy gac'uwaa bollan kesiyaa k'aac'echchuwaanne wolk'k'aama galbbaa harggiyaa. ");
INSERT INTO dwrl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","K'ay k'eesii he harggiyaa be'iyaa wode, I galbbaa lukkiide ollatibeennawaa gidooppenne karetsa isikiikka Aa bolla d'ayooppe, he k'aac'echchuwaa harggiyaana de'iyaa bitaniyaa k'eesii dumma kifiliyaan laappun gallassaa gorddiide wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Laappuntsa gallassan k'eesii he harggiyaa; be'iyaa wode k'aac'echchuwaa harggii aakkennawaa gidooppe, Aa bollan adilliyaa c'iishshaa malatiyaa isikkii baynnawaa gidooppenne, ikka galbbaa lukkiide ollatibeennawaa gidooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","he bitanii he madutsaa yuushshuwaan de'iyaa isikiyaa meedo; k'aac'echchiyaa sa'aan de'iyaa isikiyaa mata meedoppo. K'eesii he bitaniyaa dumma kifiliyaan hara laappun gallassaa gorddiide wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Laappuntsa gallassan k'eesii he k'aac'echchiyaa sa'aa be'iyaa wode; hewe bitaniyaa galbbaa bollan aakkana d'ayooppe galbbaa lukkiide ollatana d'ayooppe, he bitanii geeshsha gidiyaawaa k'eesii erisso. Bitaniikka bare mayuwaa meec'c'iide, geeshsha gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Shin I geeyeeddawaappe guyyiyaan, k'aac'echchiyaawe he bitaniyaa galbbaa bollan aakki aakki booppe, ");
INSERT INTO dwrl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","k'eesii Aa be'iyaa wode he k'aac'echchiyaawe aakkeeddawaa gidooppe, k'eesii adilliyaa c'iishshaa malatiyaa isikiyaa koyoppo; ayaw gooppe, he bitanii tuneedda. ");
INSERT INTO dwrl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Shin k'eesii be'iyaa wode, he k'aac'echchiyaasay aakkibeennawaa gidooppenne karetsa isikiikka Aa bolla doleeddawaa gidooppe, he k'aac'echchiyaasay pas'eedda. He bitaniikka geeshsha gidiyaa diraw, I geeshsha gidiyaawaa k'eesii erisso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Itti attuma asaa woy mac'c'a asaa galbbaa bolla bootsa ilahuu kesooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","k'eesii Aa; be'iyaa wode he unttunttu galbbaa bollan de'iyaa ilahuu shololla bootsa gidooppe, hewe galbbaa bollan c'oo keseeddawaa; he bitaniikka geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Itti asaw huup'iyaa binnaanay k'ok'k'ofettooppe, I bo\"aa; gidoppe attina I geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","K'ay itti asaw huup'iyaa binnaanay sintsanna bo\"atooppe, Aa tiishshay meedda; gidoppe attina I geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Shin Aa bo\"aa woy Aa tiishshay meeddasaa bollan zo'o woy bootsa madutsay kesooppe, hewe Aa bo\"aan woy tiishshay meeddasaan keseedda wolk'k'aama galbbaa harggiyaa. ");
INSERT INTO dwrl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Aa k'eesii; be'iyaa wode Aa bo\"aa woy tiishshay meeddasaa bollan de'iyaa madutsay galbbaa bollan kesiyaa wolk'k'aama galbbaa harggiyaadan zo'o gidooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","he bitanii tumukka wolk'k'aama galbbaa harggii sakkiyaa hargganchcha. I tuna gidiyaa diraw I tuna gidiyaawaa k'eesii erisso; ayaw gooppe harggii Aa huup'iyaan de'ee. ");
INSERT INTO dwrl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Wolk'k'aama galbbaa harggii oyk'k'eedda Asay peed'eteedda mayuwaa mayyo; bare huup'iyaa pis'oppo; bare mettershshaakka kammo; yaatiide, bare k'aalaa d'ok'k'u ootsiide, ‹Taani tuna, taani tuna!› yaago. ");
INSERT INTO dwrl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","He harggii Aa bolla de'eedda keeshshan ubbaan I tuna. I tuna gidiyaa diraw, asaappe shaakettiide dunkkaaneedda sa'aappe karenna barekka de'o. ");
INSERT INTO dwrl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Ay mayuwaa bollanne borok'eedda sa'ay beettooppe, he mayuu suufe gidina woy liino gidina, ");
INSERT INTO dwrl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","k'ac'inaappe woy shaluwaappe dadetteedda liino woy suufe gidina, galbbaa woy galbbaappe oosetteedda mayuwaa gidina, ");
INSERT INTO dwrl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","he mayuwaa bolla kesiidde borok'uu maataa malatiyaa woy zo'o malaa bessooppe, I k'ac'inaappe woy shaluwaappe dadetteeddawaa gidina, galbbaa woy galbbaappe oosetteedda mayuwaa gidinakka, hewe borok'uu keseedda diraw, hewaa k'eesiyaa bessanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","K'eesii he borok'uwaa be'iide, he borok'uwaanna de'iyaa mayuwaa dumma kifiliyaan laappun gallassaa gorddiide wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Laappuntsa gallassan k'eesii he mayuwaa be'iyaa wode; he mayuwaa bollan aakki aakki booppe, I k'ac'inaa woy shalo mayuwaa gidina, galbbaa woy galbbaappe oosetteedda mayyo gidinakka, hewe ittuwaappe ittuwaa oyk'k'iyaa borok'o gidiyaa diraw, he mayuu tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","K'ay he mayuu k'ac'inaa woy shalo mayyo gidina, liino woy suufe gidina, galbbaappe oosetteeddawaa ayaa gidinakka, k'eesii Aa s'uuggo. Hewe ittuwaappe ittuwaa oyk'k'iyaa borok'o gidiyaa diraw, I s'uugettanaw bessee. ");
INSERT INTO dwrl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","«K'aykka k'eesii be'iyaa wode, he borok'uu mayuwaa bolla aakkibeennawaa gidooppe, I k'ac'inaa woy shalo mayyo woy galbbaappe oosetteeddawaa ayaa gidinakka, ");
INSERT INTO dwrl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","he borok'uu de'iyaa mayuwaa meec'c'anaadan k'eesii azazo. Hewaappe guyyiyaan, he mayuwaa dumma kifiliyaan hara laappun gallassaa gorddiide wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","He borok'o sa'ay de'iyaa mayuwaa meec'c'owaappe guyyiyaan, k'aykka k'eesii be'iyaa wode he borok'uu bare malaa laammibeennawaa gidooppe, I aakki aakki baana d'ayooppekka tuna. He borok'o sa'ay mayoo guyye baggana woy sintsa baggana de'inkka, he mayuu taman s'uugettanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Shin he mayuwaa meec'c'i simmina k'eesii be'iyaa wode borok'uu d'ay d'ay booppe, I galbbaa gidina, k'ac'inaa woy shalo mayyo gidinakka, he borok'uu de'iyaa sa'aa k'eesii daakkiide kessi diggo. ");
INSERT INTO dwrl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Hewaappe guyyiyaan, mayuwaa bolla simmiidekka kesooppe, he mayuu k'ac'inaa woy shalo mayyo gidina, galbbaappe oosetteeddawaa ayaa gidinakka, hewe aakki aakki biyaa borok'o saa gidiyaa diraw, he borok'uu de'iyaa mayuu taman s'uugettanaw bessee. ");
INSERT INTO dwrl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Shin meec'etteedda mayuu k'ac'inaa woy shalo mayyo gidina, woy galbbaappe oosetteedda ayaa mayyo gidinakka, borok'o sa'ay Aa bollappe d'ayooppe, he mayuu laa\"entsuwaa meec'etto; Hewaappe guyyiyaan, I geeshsha gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","«Itti mayuu suufe woy liino gidina, k'ac'inaa woy shalo mayyo gidina, woy k'ay galbbaappe oosetteeddawaa gidinakka, he mayuwaa geeshsha woy tuna giissanaw danddayiyaa borok'o sa'aa wogay hawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Med'inaa Goday Musew hawaadan yaagiide odeedda; ");
INSERT INTO dwrl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Wolk'k'aama galbbaa harggii oyk'k'eedda bitanii geeyiyaa gallassi ootsanaw koshshiyaa wogay hawaa. He bitaniyaa k'eesiyaakko afanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","K'eesii Asay dunkkaaneedda sa'aappe gas'aa kesiide, Aa harggiyaa be'o. He wode wolk'k'aama galbbaa harggii bitaniyaa bollaappe d'ayeeddawaa gidooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","k'eesii pas'a de'iyaa laa\"u geeshsha kafotuwaa, s'idiyaa mitsaa, zo'o k'ac'inaanne hisoop'p'iyaa bonc'c'iyaa he wolk'k'aama galbbaa harggiyaappe geeyiyaa bitaniyaa diraw ahanaadan unttuntta azazo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Hewaappe guyyiyaan, k'ay k'eesii laa\"u kafotuwaappe ittuwaa keriyaan de'iyaa pultto haatsaa bolla shukkanaadan azazo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Pas'a de'iyaa kafuwaa, k'ay zigaanna, zo'o k'ac'inaananne hisoop'p'iyaa bonc'c'iyaanna akki afiide, keriyaan de'iyaa pulttiyaa haatsaa bolla shukkeedda kafuwaa suutsaa giddo naak'k'o. ");
INSERT INTO dwrl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Kesseedda suutsaa he wolk'k'aama galbbaa harggiyaappe pas'iyaa bitaniyaa bolla laappu gede c'ac'c'afo; yaatiide he bitanii geeshsha gidiyaawaa erisso; pas'a de'iyaa kafuwaa gede dembbaa yeddo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«He harggiyaappe geeyeedda bitanii bare mayuwaa meec'c'o; bare bollan de'iyaa isikiyaa ubbaa meedetto; bare bollaakka meec'etto; yaatooppe I geeshsha gidanawaa. Hewaappe guyyiyaan, I dunkkaaneedda sa'aa yo; shin gidooppenne bare dunkkaaniyaa gelennaan laappun gallassaa karenna gam\"o. ");
INSERT INTO dwrl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Laappuntsa gallassan bare huup'iyaa, buuchchaa, goomaanne bare bollan de'iyaa hara isikiyaa ubbaa meedetto; k'ay bare mayuwaa meec'c'o; bare bollaakka meec'etto; Hewaappe guyyiyaan, I geeshsha gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«Hosppuntsa gallassan tilla bollaanna de'iyaa laa\"u dorssaa maratuwaanne itti laytsaa gideedda itti dorssato aho; k'ay katsaa yarshshoo zayitiyaan munak'etteedda usuppun kiilo giraame d'iiliyaanne itti liitiro wogaraa zayitiyaw heezzentso kushiyaa aho. ");
INSERT INTO dwrl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Aa geeshshiyaa k'eesii bitaniyaa I aheedawanttuna ittippekka Med'inaa Godaa Dunkkaaniyaa pengge Med'inaa Godaa sintsa shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","«K'eesiikka laa\"u dorssaa maratuwaappe ittuwaa akkiide, liitiro heezzentso kushiyaa zayitiyaanna ittippe naak'uwaa yarshshuwaa ootsiide shiishsho; he shiishsheeddawaa k'ay k'aatsiyaa yarshshuwaa ootsiide Med'inaa Godaa sintsan k'aatso. ");
INSERT INTO dwrl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Yaatiide I he dorssaa maraa nagaraa yarshshuwaanne s'uuggiyaa yarshshuwaa shukkiyaa geeshsha sa'aan shukko; nagaraa yarshshuwaadan naak'uwaa yarshshuukka k'eesiyaw imettee; ikka loytsi geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","K'eesii naak'uwaa yarshshuwaa suutsaappe guutsaa akkiide, he geeyiyaa bitaniyaw ushechcha bagga haytsaa s'eeraa, ushechcha kushiyaw wogga birad'd'iyaanne ushechcha gediyaw wogga birad'd'iyaa okko. ");
INSERT INTO dwrl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Hewaappe guyyiyaan, k'eesii wogaraa zayitiyaappe guutsaa akkiide, bare haddirssa kushiyaa gomppan tigo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","«He haddirssa kushiyaa gomppan de'iyaa wogaraa zayitiyaan bare ushechcha kushiyaa birad'd'iyaa naak'k'iide, Med'inaa Godaa sintsan laappu gede c'ac'c'afo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Yaati simmiide bare kushiyaa gomppan atteeda zayitiyaappe akkiide, geeyiyaa bitaniyaw ushechcha haytsaa s'eeraa, ushechcha kushiyaw wogga birad'd'iyaanne ushechcha gediyaw wogga birad'd'iyaa kase naak'uwaa yarshshuwaa suutsaa oketteedda sa'aan okko. ");
INSERT INTO dwrl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","K'ay bare kushiyaa gomppan atteeda zayitiyaa k'eesii geeyiyaa bitaniyaa huup'iyaan gusso; yaatiide Med'inaa Godaa sintsan he bitaniyaa nagaraa atto giisso. ");
INSERT INTO dwrl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","«Hewaappe guyyiyaan k'eesii bare tunatetsaappe geeyiyaa bitaniyaa nagaraa atto giissanaw nagaraa yarshshoo shiishsheedda mehiyaa shukkee; hewaappe simmiide k'ay s'uuggiyaa yarshshoo shiishsheedda mehiyaa yarshshee. ");
INSERT INTO dwrl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","K'ay k'eesii he s'uuggiyaa yarshshuwaa katsaa yarshshuwaanna ittippe yarshshiyaa sa'aa bollan wotsiide s'uuggee; yaatiide bitaniyaa nagaraa atto giissee; bitaniikka geeshsha gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Shin bitanii hewaa ubbaa ahanaw danddayenna mank'k'o gidooppe, S'oossaa sintsan k'aatsiide Aa nagaraa atto giissanaw, bare naak'uwaa yarshshoo itti dorssaa maraa aho. K'ay katsaa yarshshookka wogaraa zayitiyaan munak'etteedda laa\"u kiilo giraame lo\"o d'iiliyaanne itti liitiro heezzentso kushiyaa zayitiyaa ittippe aho. ");
INSERT INTO dwrl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","K'aykka barew danddayeeddawaadan laa\"u maraa harap'p'etuwaa woy laa\"u mara dogomattuwaa, ittuwaa nagaraa yarshshoo, ittuwaa k'ay s'uuggiyaa yarshshoo aho. ");
INSERT INTO dwrl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","«Hosppuntsa gallassan bare nagaraappe geeyanaw bitanii hawantta k'eesiyaakko Med'inaa Godaa Dunkkaaniyaa pengge Med'inaa Godaa sintsa aho. ");
INSERT INTO dwrl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","K'eesii naak'uwaa yarshshoo aheedda dorssaa maraanne littiro heezentso kushe zayitiyaa akkiide, k'aatsiyaa yarshshuwaa ootsiide Med'inaa Godaa sintsan k'aatso. ");
INSERT INTO dwrl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Yaatiide naak'uwaa yarshshoo aheedda dorssaa maraa shukkiide he naak'uwaa yarshshuwaa suutsaappe guutsaa akkiide, ha geeyiyaa bitaniyaw ushechcha haytsaa s'eeraa, ushechcha kushiyaw wogga birad'd'iyaanne ushechcha gediyaw wogga birad'd'iyaa okko. ");
INSERT INTO dwrl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","K'ay k'eesii zayitiyaappe guutsaa bare haddirssa kushiyaa gomppan tigo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","He haddirssa kushiyaa gomppan de'iyaa zayitiyaappe ushechcha kushiyaa s'eeran guutsaa akkiide, Med'inaa Godaa sintsan laappu gede c'ac'c'afo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","K'aykka k'eesii bare kushiyaa gomppan de'iyaa zayitiyaappe guutsaa akkiide, geeyiyaa bitaniyaw ushechcha haytsaa s'eeraa, ushechcha kushiyaw wogga birad'd'iyaanne ushechcha gediyaw wogga birad'd'iyaa kase naak'uwaa yarshshuwaa suutsaa oketteedda sa'aan okko. ");
INSERT INTO dwrl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","K'ay Med'inaa Godaa sintsan bitaniyaa nagaraa atto giissanaw, k'eesii bare kushiyaan atteeda zayitiyaa geeyiyaa bitaniyaa huup'iyaan okko. ");
INSERT INTO dwrl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Hewaappe guyyiyaan, he aawuu barew danddayeeddawaadan harap'p'iyaa maraa gidina woy mara dogommuwaa gidina, ");
INSERT INTO dwrl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ittuwaa nagaraa yarshshoo laa\"entsuwaa k'ay s'uuggiyaa yarshshoo katsaa yarshshuwaanna ittippe yarshsho. K'ay k'eesiikka he geeyiyaa bitaniyaw Med'inaa Godaa sintsan Aa nagaraa atto giisso. ");
INSERT INTO dwrl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Bare bollan de'iyaa wolk'k'aama galbbaa harggiyaappe geeyanaw koshshiyaa wogaa polanaw mank'k'otay diggeedda uraw de'iyaa wogay simmi hawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Med'inaa Goday Musanne Aaroona hawaadan yaageedda, ");
INSERT INTO dwrl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Taani hinttenttoo ak'o ootsaade immiyaa Kanaane biittaa hintte geliyaa wode, k'ay he gadiyaan de'iyaa hintte keetsaappe ittuwaan taani borok'uwaa yeddiyaa wode, ");
INSERT INTO dwrl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","he golliyaw k'eesiyaakko biide, ‹Ta son ayaa borok'entto de'ee› yaagiide odo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Gollen de'iyaabay ubbay tuna geetettennaadan, k'eesii borok'uwaa be'anaw gelanaappe kasetiide, son de'iyaawaa ubbaa kare kessanaadan azazo; yaati simmina k'eesii be'anaw golle gelo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Hewaan be'iyaa wode, borok'o sa'ay godaa bollan maataa malatiyaa, woy zo'o malaa bessooppenne k'ay godaappe ollatiide giddo gelooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","k'eesii golleppe kare kesiide, golliyaa laappun gallassaa gakkanaw gorddo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Laappuntsa gallassaan k'eesii he golliyaa zaaretsiide; s'eelliyaa wode he borok'uu golliyaa godaa bollan aakkooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","borok'uu de'iyaa shuchchatuwaa ubbaa godaappe shoddiide, katamaappe gas'aa yaa tuneedda sa'aw olanaadan azazo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","K'ay godaa dufeedda urk'k'aa soo baggana bookkishin, yuushshi aatsiide k'ok'k'ofanaadan ootso; yaatiide he k'ok'k'ofeedda urk'k'aa katamaappe gas'an de'iyaa tuna sa'aan olino. ");
INSERT INTO dwrl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Hewaappe guyyiyaan, he shoddeedda shuchchatuu sa'aan hara shuchchatuwaa wotsino; k'ay hara urk'k'ankka golliyaa dufino. ");
INSERT INTO dwrl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Shuchchatuwaa shod diggina, k'ay urk'k'aakka k'ok'k'ofiide hara urk'k'aa dufii simmina, laa\"entsuwaa simmiide borok'uu golliyaa giddon aakkooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","k'eesii hewaa be'iyaa wode; borok'uu he golliyaa giddon aakkooppe, hewe ittuwaappe ittuwaa oyk'k'iyaa borok'o gidiyaa diraw, he gollii tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Hewaa diraw I he golliyaa, Aa shuchchaa, Aa mitsaanne I dufeteedda urk'k'aa ubbaa kolo; hewantta katamaappe gas'aa afiide, tuna sa'aan olo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","K'ay he gollii gorddan takkiyaa wodiyaan Aa giddo geliyaa ooninne sa'ay k'ammana gakkanaw tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","He golliyaan gisiyaa uray woy k'umaa miyaa uray bare mayuwaa meec'c'o. ");
INSERT INTO dwrl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Shin k'eesii yiide s'eelliyaa wode, gollii dufetti simmina laa\"entsuwaa simmiide aakkana d'ayooppe, borok'uu d'ayeedda diraw, he gollii geeshsha gidiyaawaa k'eesii erisso. ");
INSERT INTO dwrl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Golliyaa geeshshanaw laa\"u kafotuwaa, s'idiyaa mitsaa, zo'o k'ac'inaanne hisoop'p'iyaa bonc'c'iyaa aho. ");
INSERT INTO dwrl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Kafotuwaappe ittuwaa keriyaan de'iyaa pulttuwaa haatsaa bollan shukko. ");
INSERT INTO dwrl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Hewaappe guyyiyaan s'idiyaa, hisoop'p'iyaa bonc'c'iyaa, zo'o k'ac'inaanne pas'a de'iyaa kafuwaa ittippe akkiide, keriyaan de'iyaa shukkeedda kafuwaa suutsaaninne pulttuwaa haatsaan yeggi kessiide, laappu gede he golliyaa c'ac'c'afo. ");
INSERT INTO dwrl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Yaatiide he golliyaa k'eesii kafuwaa suutsan, pulttuwaa haatsaan, pas'a de'iyaa kafuwaan, s'idiyaan, hisoop'p'iyaa bonc'c'iyaaninne zo'o k'ac'inan geeshsho. ");
INSERT INTO dwrl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","K'ay pas'a de'iyaa kafuwaa katamaappe gas'aa hini dembbaa yeddo. Hewaadan ootsiide, golliyaa geeshshiyaa wogaa polee; golliikka geeshsha gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","«Ay wolk'k'aama galbbaa hargge gidooppekka hawe woga; k'aac'echchiyaawaa gidina, ");
INSERT INTO dwrl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","mayuwaa bollan woy golliyaa bollan kesiyaa borok'o gidina, ");
INSERT INTO dwrl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","gaafuwaa gidina, d'uussa madutsaa gidina woy ilahuwaa gidinakka, ");
INSERT INTO dwrl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ittibay tuna gidiyaawaanne geeshsha gidiyaawaa erissanaw wolk'k'aama galbbaa harggiyaanne borok'uwaa wogay hawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Med'inaa Goday Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«Israa'eeliyaa asaw hawaadan yaagiide odite; ‹Ay asaa attuntsaappe ayayneekka goggooppe, he goggiyaabay tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","He goggiyaawaappe denddeedawaan he uray tuna gidiyaa wogay hawaa: He goggiyaabay aggenaan gogginakka woy k'ay goggiyaawaa agginttokka he Aa giddon de'iyaabay Aa tunissee. ");
INSERT INTO dwrl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","« ‹Aa bollaappe ayayneekka goggiyaa Asay gisiyaa ay gisuukka tuna; k'ay I uttiyaabay ayaa gidooppekka tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Aa gisuwaa bochchiyaa ooninne bare mayuwaa meec'c'o; bare bollaakka meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Goggiyaawaana de'iyaa Asay utteeddawaa bolla uttiyaa ooninne bare mayuwaa meec'c'o; bare bollaakka meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","« ‹Goggiyaabay de'iyaa asaa bollaa bochchiyaa ooninne bare mayuwaa meec'c'o; bare bollaakka meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","« ‹Goggiyaabay de'iyaa Asay geeshsha asaa bolla c'uchchooppe, he Asay bare mayuwaa meec'c'o; bare bollaakka meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","« ‹K'ay goggiyaabay de'iyaa Asay uttiyaa ay kooraykka tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Bareppe garssana de'iyaawaa ayan gidooppekka bochchiyaa ooninne omarssi gakkanaw tuna; k'ay hewantta malatiyaawantta tookkiyaa ooninne bare mayuwaa meec'c'o; bare bollaakka meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","« ‹Goggiyaawaana de'iyaa Asay bare kushiyaa meec'ettennaan de'iidde bochchiyaa Asay ooninne bare mayuwaa meec'c'o; bare bollaakka meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","« ‹K'ay goggiyaabay de'iyaa Asay bochchiyaa urk'k'aa miishshaa ubbaa mentsite; mitsaappe oosetteedda miishshaa ubbay k'ay haatsaan meec'etto. ");
INSERT INTO dwrl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","« ‹Goggiyaabay de'iyaa Asay he goggiyaawaappe geeyiyaa wode, barew laappun gallassaa paydo. Bare mayuwaa meec'c'o; bare bollaaka pulttuwaa haatsaan meec'etto; yaatiide I geeshsha gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Hosppuntsa gallassi laa\"u maraa harap'p'etuwaa woy laa\"u mara dogomattuwaa akkiide, Med'inaa Godaa Dunkkaaniyaa penggiyaa Med'inaa Godaa sintsa yiide, k'eesiyaw unttuntta immo. ");
INSERT INTO dwrl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","K'eesii harap'p'etuwaappe ittuwaa nagaraa yarshshoo, laa\"entsuwaa k'ay s'uuggiyaa yarshshoo yarshshee; yaatiide k'eesii bitaniyaa bollaappe goggiyaawaa diraw Med'inaa Godaa sintsan Aa nagaraa atto giissee. ");
INSERT INTO dwrl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","« ‹Ay attuma asaynne bare attumatetsaappe zeretsay gukkooppe, bare kumentsaa bollaa haatsaan meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Attumatetsaappe gukkeedda zeretsay bochcheedda mayuwaa ubbay woy galbbaa ubbay haatsaan meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","K'ay itti attuma Asay mac'c'a asaana gisina, Aa attumatetsaappe zeretsay gukkooppe, laa\"uukka haatsaan meec'ettino; k'ay omarssi gakkanaw unttunttu tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","« ‹Mac'c'a asaw aginaan aginaan yiyaa piilay yooppe, laappun gallassaa gakkanaw iza tuna; k'ay izo bochchiyaa ooninne omarssi gakkanaw tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","« ‹He piilaa wode iza gisiyaawe ubbay tuna; k'ay iza uttiyaawe ubbaykka tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Iza gisiyaa gisuwaa bochchiyaa ubbay bare mayuwaa meec'c'o; haatsaankka meec'etto; omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Iza uttiyaawaa bochchiyaa ubbay bare mayuwaa meec'c'o; bare bollaakka meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Iza gisiyaa gisuwaa gidinakka woy iza uttiyaawaa bochchiyaa ooninne omarssi gakkanaw tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","« ‹Ay attuma asaynne he piilaa wode iinanna gisooppe, he piilay k'ay Aa bochchooppe, laappun gallassaa gakkanaw I tuna; I gisiyaa gisuu ubbaykka tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","« ‹Itti mac'c'a mishiratiw izi piilaa wodiyaa gidenaan hara wodiyaan suutsay goggooppe, woy k'ay izi piilaykka bare wodiyaappe aatsiide ek'k'enan is's'iide goggooppe, I ek'k'ana gakkanaw iza tuna. Bare piilaa wodiyaan tuna gidiyaawaadan, he wodekka iza tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","He suutsay iippe goggiyaa wodiyaan iza giseedda gisuu ubbay, bare piilaa wode iza giseedda gisuwaakka mala tuna; k'ay iza uttiyaabay ubbaykka bare piilaa wode iza uttiyaabay tuna gidiyaawaadan tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","K'ay he tuneeddabatuwaa bochchiyaa ooninne tuna; I bare mayuwaa meec'c'o; bare bollaakka meec'etto; k'ay omarssi gakkanaw I tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","« ‹Izippe goggiyaabay ek'k'ooppe, iza he wodiyaappe doommaade laappun gallassaa paydu; Hewaappe guyyiyaan, iza geeshsha gidana. ");
INSERT INTO dwrl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Hosppuntsa gallassaan iza laa\"u mara harap'p'etuwaa woy laa\"u mara dogomattuwaa akkaade, S'oossaa Dunkkaaniyaa penggiyaa k'eesiyaakko ahu. ");
INSERT INTO dwrl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","K'eesii harap'p'etuwaappe ittuwaa nagaraa yarshshoo ittuwaa k'ay s'uuggiyaa yarshshoo yarshsho. Yaatiide k'eesii iippe goggiyaawaa tunatetsaa diraw Med'inaa Godaa sintsan I nagaraa atto giissee. ");
INSERT INTO dwrl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","« ‹Barenttu giddon de'iyaa S'oossaa Dunkkaaniyaa tunissiide Israa'eeliyaa Asay hayk'k'ennaadan, neeni hawaadan ootsaade unttunttu barena tunissiyaawaappe shaakettiide de'anaadan naaga. ");
INSERT INTO dwrl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","« ‹Aa bollaappe ayayneekka goggiyaa asawunne Aa attumatetsaappe gukkeedda zeretsaan tuniyaa asaw, ");
INSERT INTO dwrl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","k'ay bare piilaa gaasuwaan tuniyaa mac'c'a asaw, attuma gidina mac'c'awaa gidina goggiyaabay de'iyaa asawunne tuneedda mac'c'a asaana gisiyaa attuma asaw imetteedda wogay hewaa› yaagite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aaroona attuma naanay laa\"u Med'inaa Godaa sintsa shiik'iide hayk'k'eeddawaappe guyyiyaan, Med'inaa Goday Musa hawaadan yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«Med'inaa Goday Musa, ne ishay Aarooni Taabootaa bollan de'iyaa atto giyaa sa'aa k'um\"iyaa sintsan gaaridduwaappe guyye baggana de'iyaa Ubbaappe Aad'd'eeda Geeshsha Sa'aa ubbaa wode c'oo gelenaadan aw oda. C'oo gelooppe I hayk'k'ana; ayaw gooppe, Taani shaariyaa giddona atto giyaa sa'aa k'um\"iyaa bollan k'onc'c'ay. ");
INSERT INTO dwrl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aarooni nagaraa yarshshoo itti korumaanne k'ay s'uuggiyaa yarshshoo itti dorssaa orggiyaa akkiide, he Ubbaappe Aad'd'eeda Geeshsha Sa'aa gelo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","«Aarooni liinuwaappe oosetteedda geeshsha k'amishshiyaanne liinuwaappe oosetteedda garssana mayiyaa mayuwaa mayyo. K'ay liinuwaappe oosetteedda danc'c'uwaa danc'c'o; hewaadankka k'ay bare huup'iyaan liinuwaappe oosetteedda shaashiyaa enc'c'urssaa wotso. Hawaanttu geeshsha mayotuwaa gidiyaa diraw, I bare bollaa haatsaan meec'etti kichchiide mayyo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","«Israa'eeliyaa asaa maabaray nagaraa yarshshoo laa\"u deeshshaa koletuwaa, s'uuggiyaa yarshshookka itti dorssaa koliyaa Aaroonaw ayino. ");
INSERT INTO dwrl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aarooni bare nagaraanne bare soo asaa nagaraa atto giissanaw korumaa yarshsho. ");
INSERT INTO dwrl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Hewaappe guyyiyaan, laa\"u deeshshaa koletuwaa afiide, Med'inaa Godaa Dunkkaaniyaa penggiyaan Med'inaa Godaa sintsan esso. ");
INSERT INTO dwrl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Yaatiide he laa\"u deeshshatuwaan saamaa yeggina ittuu Med'inaa Godaassa; ittuu k'ay bazzuwaa yeddiyaawaa gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aarooni Med'inaa Godaw saamay keseedda deeshshaa ahiide, nagaraa yarshsho ootsiide yarshsho. ");
INSERT INTO dwrl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Shin bazzuwaa yeddiyaa saamay keseedda deeshshaa pas'a de'ishshin Med'inaa Godaw shiishsho; bazzuwaa Aa yederssiyaa wode, asaa nagaraa atto giissee. ");
INSERT INTO dwrl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Aarooni bare nagaraanne bare soo asaa nagaraa atto giissanaw, itti korumaa nagaraa yarshshuwaa ootsiide shiishsho. Yaatiide bare nagaraa yarshshoo he korumaa shukko. ");
INSERT INTO dwrl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","K'ay Med'inaa Godaa sintsan de'iyaa yarshshiyaa sa'aappe is'aanaa c'uwissiyaa miishshaa kumentsaa bonk'k'uwaanne, liik'i gaac'etteedda laa\"u kop'p'iyaa sawiyaa is'aanaa akkiide, gaaridduwaa giddo aho. ");
INSERT INTO dwrl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","I hayk'k'ennaadan, is'aanaa c'uway Taabootaa bollan de'iyaa atto giyaa sa'aa k'um\"iyaa kammana mala, is'aanaa Med'inaa Godaa sintsan de'iyaa taman wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","K'ay he orggiyaa suutsaappe guutsaa akkiide, bare birad'd'iyaa aan naak'k'iide, atto giyaa sa'aa k'um\"iyaw sintsa bagga c'ac'c'afo; k'ay atto giyaa sa'aa k'um\"iyaappe sintsa baggana de'iyaa sa'aakka laappu gede c'ac'c'afo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«Hewaappe guyyiyaan asaa nagaraa yarshshoo gidiyaa deeshshaa shukkiide, Aa suutsaa gaaridduwaa giddo aho; korumaa suutsaa c'ac'c'afeeddawaadan, atto giyaa sa'aa k'um\"iyaa sintsaanne atto giyaa sa'aa k'um\"iyaappe sintsa baggana de'iyaa sa'aa c'ac'c'afo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Yaatiide Ubbaappe Aad'd'eeda Geeshsha Sa'aa Israa'eeliyaa asaa tunatetsaappenne nagaraappe geeshshee. K'ay unttunttu tunabaa ootsishin, unttunttu giddon de'iyaa S'oossaa Dunkkaaniyaakka hewaadan ootsiide geeshsho. ");
INSERT INTO dwrl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","I Ubbaappe Aad'd'eeda Geeshsha Sa'aa geliide, bare nagaraa, bare soo asaa nagaraanne kumentsaa Israa'eeliyaa asaa nagaraa atto giissiide kesana gakkanaw, ooninne S'oossaa Dunkkaaniyaa giddon de'oppo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","«Hewaappe guyyiyaan I Med'inaa Godaa sintsan de'iyaa yarshshiyaa sa'aa yiide Aa nagaraa atto giisso. Korumaa suutsaappenne deeshshaa suutsaappe guutsaa guutsaa akkiide, yarshshiyaa sa'aa yuushshuwaan de'iyaa kac'etuwaa okko. ");
INSERT INTO dwrl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","K'ay he suutsaappe guutsaa bare birad'd'iyaan akkiide, laappu gede yarshshuwaa sa'aa bollaa c'ac'c'afiide, Israa'eeliyaa asaa tunatetsaappe he yarshshuwaa sa'aa geeshsho. ");
INSERT INTO dwrl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Aarooni Ubbaappe Aad'd'eeda Geeshsha Sa'aa, S'oossaa Dunkkaaniyaanne yarshshiyaa sa'aa geeshshiyaa wogaa poleeddawaappe guyyiyaan, pas'a de'iyaa deeshshaa shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aarooni bare laa\"u kushetuwaa pas'a de'iyaa deeshshaa huup'iyaan wotsiide, Israa'eeliyaa asaa naak'uwaa ubbaa, unttunttu makkalaa ubbaa, unttunttu nagaraa ubbaa paas'o; yaatiide he deeshshaa huup'iyaan hewaa toossiide he deeshshaa afanaadan giigisseedda asaa bollan bazzuwaa yeddo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","I deeshshaa bazzuwaa yeddina, deeshshay unttunttu nagaraa ubbaa tookkiide, Asay bayinna sa'aa bazzuwaa bo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«Hewaappe guyyiyaan, Aarooni S'oossaa Dunkkaaniyaa biide Ubbaappe Aad'd'eeda Geeshsha Sa'aa geleedda wode, kase bare mayyeedda liinuwaappe oosetteedda mayuwaa k'aariide hewaan wotso. ");
INSERT INTO dwrl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Geeshsha sa'aan I bare bollaa haatsaan meec'ettiide, hara mayuwaa mayyiide keso; yaatiide s'uuggiyaa yarshshuwaa barewaanne asaawaa yarshshiide, bare nagaraanne asaa nagaraa atto giissee. ");
INSERT INTO dwrl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","K'ay hewaadankka nagaraa yarshshuwaa handdaa yarshshiyaa sa'aa bollan wotsiide s'uuggo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Wora yeddiyaa deeshshaa afeeda bitaniikka bare mayuwaa meec'c'o; bare bollaakka haatsaan meec'etto. Yaati simmiide dunkkaaneeddasaa yo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","«Nagaraa atto giissanaw Aarooni Ubbaappe Aad'd'iyaa Geeshsha Sa'aa geleedda wode, nagaraa yarshshuwaa korumaa suutsaanne deeshshaa suutsaa akkiide geleedda; ha\"i hintte he korumaanne he deeshshaanne dunkkaaneedda sa'aappe gas'aa kessite. Unttunttu galbbaa, unttunttu ashuwaanne unttunttu toc'iyaa taman s'uuggite. ");
INSERT INTO dwrl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Hewaa taman s'uuggeedda bitanii bare mayuwaa meec'c'o; bare bollaakka haatsaan meec'etto; Hewaappe guyyiyaan, dunkkaaneedda sa'aa yo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Hawe hinttenttoo med'inawukka woga gido: laappuntsa aginay geleedda tammuntsa gallassan hintte huup'iyaa kawushshite; Israa'eeliyaa asaa gidina woy k'ay hintte giddon de'iyaa hara biittaa asaa gidinakka, ay oosonne ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ayaw gooppe, hinttena geeshshanaw, hintte nagaraa atto giissiyaa gallassay he gallassaa. Hinttekka Med'inaa Godaa sintsan hintte nagaraa ubbaappe geeyana. ");
INSERT INTO dwrl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hewe hintte waanna shemppuwaa shemppiyaa sambbata gallassaa. He gallassan hintte huup'iyaa kawushshite; hewe hinttenttoo med'inawukka woga gido. ");
INSERT INTO dwrl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","K'ay bare aawuwaa kotaan k'eese gidanaadan okettiyaawenne dummatiyaa Asay geeshsha gideedda liinuwaappe dadetteedda mayuwaa mayyiide, nagaraa atto giissiyaa wogaa polo. ");
INSERT INTO dwrl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","I Ubbaappe Aad'd'iyaa Geeshsha Sa'aa, S'oossaa Dunkkaaniyaa, yarshshiyaa sa'aa, k'eesetuwaanne Israa'eeliyaa asaa ubbaa geeshsho. ");
INSERT INTO dwrl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Israa'eeliyaa asaa nagaraa ubbaa atto giissiyaa wogaa hintte laytsan laytsan itti gede ootsanaadan, hawe hinttenttoo med'inawukka woga gido» yaageedda. Muse Med'inaa Goday azazeeddawaadan ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«Aaroonaw Aa attuma naanatoonne Israa'eeliyaa asaa ubbaw hawaadan yaagaade oda; ‹Med'inaa Goday azazeeddawe hawaa: ");
INSERT INTO dwrl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Israa'eeliyaa asaappe ooninne booraa woy dorssaa woy deeshshaa dunkkaaneedda sa'aan woy dunkkaaneedda sa'aappe gas'aana shukkiide, ");
INSERT INTO dwrl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Med'inaa Godaw imotaa ootsiide immanaw Med'inaa Godaa Dunkkaaniyaa penggiyaa Med'inaa Godaa sintsa ahana d'ayooppe, he suutsan I ooshettee; he Asay suutsaa gusseedda. Hewaa diraw I bare asaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Hewaa diraw Israa'eeliyaa Asay barenttu yarshshuwaa mehiyaa c'oo dembban shukkiyaawaa aggiide, haa Med'inaa Godaakko, Med'inaa Godaa Dunkkaaniyaa penggiyaan de'iyaa k'eesiyaakko ahino. K'eesii hewaa akkiide, Med'inaa Godaw ittippetetsaa yarshshuwaa ootsiide shukko. ");
INSERT INTO dwrl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","K'ay k'eesii Med'inaa Godaa Dunkkaaniyaa penggiyaan de'iyaa Med'inaa Godaw yarshshiyaa sa'aa bollan he suutsaa c'ac'c'afo; handdaakka Med'inaa Godaw sawuwaa toshukku giyaa yarshshuwaa ootsiide s'uuggo. ");
INSERT INTO dwrl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Israa'eeliyaa Asay S'oossaa kaalliyaawaa aggiide kaalleedda s'alahetoo laa\"entso barenttu yarshshuwaa yarshshoppino. Hawe unttunttoonne yiyaa yeletaa ubbaw med'inaw woga gido› yaaga. ");
INSERT INTO dwrl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«Unttuntta hawaadan yaaga; ‹Israa'eeliyaa asaappe gidina woy unttunttu giddon de'iyaa hara biittaa asaappe gidinakka, ooninne s'uuggiyaa yarshshuwaa woy hara yarshshuwaa shiishshiyaa wode, ");
INSERT INTO dwrl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Med'inaa Godaw yarshshanaw Med'inaa Godaa Dunkkaaniyaa penggiyaa ahana d'ayooppe, he Asay bare asaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","« ‹Israa'eeliyaa asaappe woy unttunttu giddon de'iyaa hara biittaa asaappe ooninne suutsaa mooppe, he suutsaa miyaa asaa bollan taani ta deemuwaa tukkana; taani he bitaniyaa asaa giddon bohana. ");
INSERT INTO dwrl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ayaw gooppe ashuwaa mayyeedda ubbaa de'uu Aa suutsaa giddon de'ee; suutsaykka k'ay de'uwaa shemppuu Aa giddon de'iyaawaappe denddeedawaan nagaraa atto giissiyaawaa gidiyaa diraw, hintte nagaraa atto giissanaadan, taani hinttenttoo yarshshiyaa sa'aa bollan yarshshanaadan immaad. ");
INSERT INTO dwrl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Hewaa diraw taani Israa'eeliyaa asaa, «Hintteppe woy hintte giddon de'iyaa hara biittaa asaappe ooninne suutsaa mooppo» yaagaad. ");
INSERT INTO dwrl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","« ‹Israa'eeliyaa asaappe woy unttunttu giddon de'iyaa hara biittaa asaappe ooninne miyaa do'aa woy kafuwaa shankkatiide wod'ooppe, Aa suutsaa sa'aan gussiide, biittaa kammo. ");
INSERT INTO dwrl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ayaw gooppe ashuwaa mayyeedda ubbaa shemppu Aa suutsaa giddona. Hewaa diraw taani Israa'eeliyaa asaa, «Ashuwaa mayyeedda med'etaa ubbaa shemppuukka Aa suutsaa giddon de'iyaa diraw, suutsaa mooppite; k'ay miyaa ooninne bare asaa giddoppe bohetto» yaagaad. ");
INSERT INTO dwrl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","« ‹Israa'eeliyaa asaa gidina woy unttunttu giddon de'iyaa hara biittaa asaa gidina, ooninne bakkuta woy do'ay oyk'k'iide wod'eedda ashuwaa mooppe, bare mayuwaa meec'c'o; bare bollaakka meec'etto; yaatiide omarssi gakkanaw I tuna. Hewaappe guyyiyaan, I geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Bare mayuwaa meec'c'ana d'ayooppe, bare bollaakka meec'ettana d'ayooppe, I bare nagaraan ooshettee› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Israa'eeliyaa asaa hawaadan yaaga; ‹Taani, Med'inaa Goday, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Hintte kase de'eedda Gibs'e biittaa Asay ootsiyaawaadan ootsoppite; woy ha\"i taani hinttena afiyaa Kanaane biittaa Asay ootsiyaawaadankka ootsoppite; unttunttu wogaakka kaalloppite. ");
INSERT INTO dwrl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Hintte ta azazuwaa ootsite; ta wogaakka naagite; k'ay aan biite. Taani, Med'inaa Goday, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Hewaa diraw ta azazuwaanne ta wogaa naagooppe, hintte pas'a de'ana. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","« ‹Hintteppe ooninne ashuwaa amuwaa polanaw bare mata dabbuwaana gisoppo. Taani S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ne ashuwaa amuwaa polanaw ne daayinna gisoppa; ne aawuwaa kawushshoppa. Iza ne daayo; iinanna gisoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ne ashuwaa amuwaa polanaw ne aawuwaa machchattinna gisoppa; ne aawuwaa kawushshoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","« ‹Ne ashuwaa amuwaa polanaw ne michchatina gisoppa; woy k'ay son yeletteedda woy karen yeletteedda ne aawuwaa woy ne daay naattinakka gisoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","« ‹Ne ashuwaa amuwaa polanaw ne na'aa naattinna woy ne naatti naattinna gisoppa. Ne huup'iyaw neena kawushshaasa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ne ashuwaa amuwaa polanaw ne aawuwaa machchati naattinna gisoppa; iza ne michchato gidiyaa diraw iinanna gisoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ne ashuwaa amuwaa polanaw ne aawuwaa michchatina gisoppa. Iza ne aawoo mata dabbo. ");
INSERT INTO dwrl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ashuwaa amuwaa polanaw ne daay michchatina gisoppa; iza ne daayiw mata dabbo. ");
INSERT INTO dwrl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ne aawuwaa ishaa kalluwaa k'aaraade ne ashuwaa amuwaa polanaw Aa machchattinna gisoppa; iza ne aawuwaa ishaa machchato. ");
INSERT INTO dwrl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ne ashuwaa amuwaa polanaw ne na'aa machchattinna gisoppa; iza ne na'aa machchato gidiyaa diraw, iinanna gisoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ne ashuwaa amuwaa polanaw ne ishaa machchattinna gisoppa; gisooppe ne ishaa kawushshaasa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","« ‹Ne ashuwaa amuwaa polanaw mishiratinanne I naattinanne laa'uwaanna gisoppa. I naatti naattinna woy k'ay I na'aa naattinakka gisoppa; unttunttu iziw mata dabbo gidiyaa diraw, hewe sharmus'a. ");
INSERT INTO dwrl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","« ‹Ne machchata pas'a de'ishshin, ne machchati michchato akkaade ne ashuwaa amuwaa polanaw iinanna gisoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","« ‹Ne ashuwaa amuwaa polanaw piilay yiina tuna utteedda mishiratina gisoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","« ‹Neeni tunennaadan ne shooruwaa machchattinna gisoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","« ‹Ne S'oossaa suntsaa tunissanaw ne naanatuwaappe ittuwaanne taman s'uugiide, Molooka giyaa eek'aw yarshshanaadan immoppa. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","« ‹Mac'c'a asaana gisiyaawaadan attuma asaana gisoppa; hewe sheneyiyaabaa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","« ‹Neeni tunennaadan ay mehiyaananne gisoppa, k'ay mac'c'a asaykka mehiyaanna gisanaw mehiyaa sintsa aad'd'oppo. Hewe wogay bayinawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","« ‹Taani hintte sintsaappe yederssiyaa kawutetsatuu ha oosotuwaan tuneedda diraw, hintte hawantta malatiyaawatuwaan tunoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Haray atto unttunttu biittaykka tuneedda diraw, Aa nagaraw taani Aa muraad; biittaykka barenan de'iyaawantta c'uchcheedda. ");
INSERT INTO dwrl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Shin hintte ta higgiyaanne ta azazuwaa naagiteppe attina, Israa'eeliyaa asaa gidina woy hintte giddon de'iyaa hara biittaa asaappe ooninne hawaa mala tuna oosuwaa ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","« ‹Hintteppe kase ha gadiyaan de'eedda asatuu hawaa mala tunabaa ootseedda diraw, biittay tuneedda. ");
INSERT INTO dwrl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Hintte ha biittaa tunissooppe, hintteppe kase de'eedda kawutetsatuwaa ha biittay c'uchcheeddawaadan, hinttenakka c'uchchennaadan naagettite. ");
INSERT INTO dwrl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Hewantta malatiyaa tuna oosotuwaappe ittuwaanne ootsiyaa Asay de'ooppe, he Asay bare asaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","« ‹Hewaa diraw hintteppe kase de'eedda asatuu ootseedda tuna oosotuwaa ubbaa ootsiide hintte tunennaadan, hintte ta azazuwaa naagite; Taani, Med'inaa Goday, hintte S'oossaa› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Israa'eeliyaa asaw ubbaw hawaadan yaagaade oda; ‹Taani, Med'inaa Goday, hintte S'oossay geeshsha gidiyaa diraw, hinttekka geeshsha gidite. ");
INSERT INTO dwrl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","« ‹Hintteppe ittuunne attenan bare aabbanne bare daayo bonchcho; ta Sambbatatuwaakka bonchchite. Taani, S'oossay, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","« ‹Taana aggiide eek'atoo goyinnoppite; woy k'ay birataappe siilisseedda, s'oossatuwaa hinttenttoo med'd'oppite. Taani, Med'inaa Goday, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","« ‹Hintte ittippetetsaa yarshshuwaa Med'inaa Godaw yarshshiyaa wode, he yarshshuu hintte diraw aketanaadan, bessiyaawaadan yarshshite. ");
INSERT INTO dwrl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","He yarshshuu hintte yarshsheedda gallassan woy wonttetsa gallassan meetetto; heezzentso gallassay gakkanaw atteedawe de'ooppe hewe s'uugetto. ");
INSERT INTO dwrl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Heezzantso gallassan Aa mooppe, hewe sheneyiyaabaa; taani hewaa akkikke. ");
INSERT INTO dwrl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Hewaa miyaa ooninne bare nagaran ooshettee; ayaw gooppe, I Med'inaa Godaw geeshsha gideeddawaa tunisseedda. He Asay bare asaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","« ‹Hintte gadiyaan mokkeedda katsaa hintte c'akkiyaa wode, gadiyaa gas'aa gakkanaw c'akkoppite; k'ay c'akaappe simmina de'iyaa k'aarimiyaakka k'aarimoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ne woyniyaa ayfiyaa mule mas'aade mitsaa kalloyoppa; sa'aan wod'd'eedda woyniyaa ayfiyaakka mas'oppa; hewaa hiyyeesatoonne betetoo agga. Taani, Med'inaa Goday, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","« ‹Hintte wuu\"oppite. « ‹Worddotoppite. « ‹Ittuu ittuwaa c'immoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","« ‹Ta suntsan wordduwaan c'aak'k'oppite; yaatiide hintte S'oossaa suntsaa tunissoppite. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","« ‹Ne shooruwaa sugoppa; woy bonk'k'oppa. « ‹Keraa ootsiyaa bitaniyaa dirgguwaa diggaade, itti k'ammaanne ne matan ayissoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","« ‹Tulliyaa shek'k'oppa; woy k'ay k'ook'iyaa sintsan d'ubbiyaawaa wotsoppa; shin neeni S'oossaw yayya. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","« ‹Pirddaa pirddaadde deshissoppa; hiyyeesaa Aa hiyyeesatetsaa diraw maaddaade pirddoppa; duriyaakka Aa duretetsaa diraw yayaade aggoppa. Shin ne shooroo tumatetsan pirddaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","« ‹Ne asaa giddon iita zigirssaa akkaade yuuyyoppa. « ‹Ne shooruwaa wod'iyaawaa ayaanne ootsoppa. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","« ‹Ne ishaa ne wozanaan is's'oppa. « ‹Ne shooruwaa gaasuwaan neeni nagaraa ootsenna mala, Aa seera. ");
INSERT INTO dwrl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","« ‹Kushshiyaa c'iggoppa; k'ay ne asaappe ittoonne uluwaan k'immiyaa oyk'k'oppa. Shin ne shooruwaa ne huup'iyaadan siik'a. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","« ‹Ta azazotuwaa naaga. « ‹Ne mehiyaappe itti k'ommo mehiyaa hara k'ommo dumma mehiyaan birassissoppa. « ‹Itti shoyk'aan laa\"u k'ommo zeretsaa zeroppa. « ‹K'ay laa\"u k'ommuwaappe dadetteedda mayuwaa mayyoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","« ‹Itti Asay hara asaa gelanaw giiga utteedda danggaas'iratina gisooppe, k'ay he danggaas'iratakka bare danggaas'iretetsaappe wozettabeennaano gidooppe, unttunttu murettanaw bessee; shin iza bare danggaas'iretetsaappe wozettabeenna diraw, unttuntta wod'anaw koshshenna. ");
INSERT INTO dwrl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Gidooppenne he bitanii bare naak'uwaa yarshshoo gidiyaa dorssaa orggiyaa S'oossaa Dunkkaaniyaakko Med'inaa Godaa sintsa aho. ");
INSERT INTO dwrl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","K'eesii he naak'uwaa yarshshuwaa dorssaa akkiide, bitanii ootseedda nagaraa Med'inaa Godaa sintsan atto giissee; I ootseedda nagaraykka atto geetettana. ");
INSERT INTO dwrl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","« ‹Hintte Kanaane biittaa geliyaa wode, ayfiyaa miyaa ay k'ommo mitsaa tokkooppekka, he mitsaa ayfiyaa meetettennawaadan paydite; heezzu laytsay wuranaw he mitsaa ayfii meetettenna; Aa mooppite. ");
INSERT INTO dwrl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Oyddentso laytsaan he mitsaa ayfii ubbay Med'inaa Godaw galataa shiishshiyaa geeshsha yarshshuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Shin he mitsaa ayfii hinttenttoo loytsi darana mala, ichcheshentso laytsaa ayfiyaa miite. Hintte hawaadan ootsooppe, hintte mitsaa ayfii darana. Taani Med'inaa Goday hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","« ‹Suutsay Aa giddon de'iyaa ay ashuwaakka mooppite. « ‹Kaayoppite woy shareechchoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","« ‹Hintte huup'iyaa binnaanaa garssana yuushshi aatsiide k'ans's'oppite; k'ay hintte buuchchaakka yuushshi aatsiide k'ans's'oppite. ");
INSERT INTO dwrl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","« ‹Hayk'k'eeda asaa diraw hintte bollaa k'ans's'ereetsoppite; woy c'achchaa malaataa hintte bollan kessoppite. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","« ‹Biittay woddalaa tunatetsan kumeeddawaa gidenna mala, ne naatto shaarmus'aa oosoo aatsa immaade tunissoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","« ‹Ta Sambbatatuwaa bonchchite; taw goynniyaa sa'aakka bonchchite. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","« ‹Moyttiliyaa haasayissiyaawanttukkonne shareechchotuwaakko booppite; hintte tunenna mala unttuntta koyyoppite. Taani, Med'inaa Goday, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","« ‹Puulummeedda asaanne c'imeedda asaa be'iyaa wode utteedda sa'aappe dendda ek'k'a; unttuntta bonchcha; ne S'oossaw yayya. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","« ‹Hintte gadiyaan hinttenana de'iyaa betetuwaa bollan sugetsaabaa ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Hintte gadiyaan hinttenana de'iyaa bete asaa hintte biittaa asaadan s'eellite; Aa hintte huup'iyaadan siik'ite. Ayaw gooppe, hinttekka kase Gibs'e gadiyaan bete gidiide de'eeddita. Taani, Med'inaa Goday, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","« ‹Hintte geesaa likkiyaaban, miizaanan wotsiide likkiyaabaaninne makkiyaaban worddotoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Hintte kiiluwaa miizaanay, hintte makkiyaabaynne likkiyaa miishshatuu ubbay likke gidino. Taani hinttena Gibs'e gadiyaappe kessaade aheedda Med'inaa Godaa hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Hintte ta higgiyaanne ta azazuwaa ubbaa naagitenne ootsite. Taani Med'inaa Godaa yaaga› » yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Israa'eeliyaa asaw hawaadan yaagaade oda, ‹Israa'eeliyaa asaappe gidina, woy betiide yiide Israa'eeliyaa giddon de'iyaa hara biittaa asaappe gidinakka, ooninne bare naanatuwaappe ittuwaa Molooka giyaa eek'aw aatsiide immooppe, he Asay hayk'k'o; he biittaa Asay Aa shuchchaan c'addiide wod'o. ");
INSERT INTO dwrl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Taani he bitaniyaa is's'ana; Aa asaa giddoppe shoddaade Aa d'ayissana. Ayaw gooppe, I bare naanatuwaappe ittuwaa Molooka giyaa eek'aw immiyaawan, ta Dunkkaaniyaa tunisseedda; ta geeshsha suntsaakka kawushshiseedda. ");
INSERT INTO dwrl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","He bitanii bare naanatuwaappe ittuwaa Molookaw immiyaa wode, he biittaa Asay be'iide, sheneko gooppe, k'ay bitaniyaakka wod'enaan aggooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","taani ta huup'iyaw he bitaniyaanne he soo asaa is's'ana; Molookena sharmus'anaw Aa kaalliyaa ubbatuwaa unttunttu asaa giddoppe bohitte. ");
INSERT INTO dwrl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","« ‹Ay asaynne taanan ammanettennan is's'iide, moyttilliyaa haasayissiyaawanttanne shareechchotuwaa oochchanaw booppe, taani Aa is's'ana; Aa asaa giddoppekka d'ayissana. ");
INSERT INTO dwrl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","« ‹Taani, Med'inaa Goday, hintte S'oossaa gidiyaa diraw, simmi hintte hinttena dummayite; k'ay geeshsha gidite. ");
INSERT INTO dwrl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ta higgiyaa naagitenne ootsite. Taani hinttena geeshshiyaa Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","« ‹Ay asaynne bare aawuwaa woy bare daayo shek'k'ooppe hayk'k'o. I bare aawuwaa woy bare daayo shek'k'eedda diraw, Aa suutsaa ac'uu Aa bollana. ");
INSERT INTO dwrl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","« ‹Itti Asay bare shooruwaa machchattinna gisooppe, he giseedda bitaniinne mishiritta laa\"uukka hayk'k'ino. ");
INSERT INTO dwrl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Bare aawuwaa machchattinna giseedda Asay bare aawuwaa kawushshiseedda; unttunttu laa\"uukka hayk'k'ino. Unttunttu suutsaa ac'uu unttunttu bollana. ");
INSERT INTO dwrl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Itti Asay bare na'aa machchattinna gisooppe, unttunttu laa\"uukka hayk'k'ino. Unttunttu tunabaa ootseeddino. Unttunttu suutsaa ac'uu unttunttu bollana. ");
INSERT INTO dwrl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","« ‹Itti attuma Asay mac'c'a asaana gisiyaawaadan attuma asaana gisooppe, unttunttu laa\"uukka tunabaa ootseedda diraw hayk'k'ino. Unttunttu suutsaa ac'uu unttunttu bollana. ");
INSERT INTO dwrl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Itti Asay naattonne aattonne ittippe akkiyaawaa gidooppe, hewe tunabaa; hintte giddon tunatetsay de'enna mala, inne unttunttunne taman s'uugettino. ");
INSERT INTO dwrl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","« ‹Itti Asay mehiyaanna gisooppe, I hayk'k'o; he mac'c'a mehattokka wod'ite. ");
INSERT INTO dwrl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Itti mac'c'a asi mehiyaanna gisooppe he mishiratonne he mehiyaa laa\"uwaakka wod'ite; unttunttu hayk'k'ino. Unttunttu suutsaa ac'uu unttunttu bollana. ");
INSERT INTO dwrl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","« ‹Itti Asay bare michchato bare aawuwaa naattinna woy bare daay naattinna gisooppe, hewe pokkobaa. Unttunttu barenttu asaa gidoppe bohettino. I bare michchato kawushsheedda diraw, I bare nagaran ooshettee. ");
INSERT INTO dwrl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Itti Asay piilay yeedda mac'c'aani kalluwaa k'aariide iinanna gisooppe, unttunttu laa\"uukka barenttu asaa giddoppe bohettino. Ayaw gooppe I izi suutsay goggiyaa pulttuwaa kalloyeedda; izakka bare suutsay goggiyaa pulttuwaa kalloyaaddu. ");
INSERT INTO dwrl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","« ‹Ne daay michchatina woy ne aawuwaa michchatina gisoppa; ayaw gooppe, hewaa ootsiyaawe bare mata dabbuwaa kawushshiyaawaa. Hintte laa\"uukka hintte nagaran ooshettana. ");
INSERT INTO dwrl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Itti Asay bare aawuwaa ishaa machchattinna gisooppe, I bare aawuwaa ishaa kawushshiseedda. Unttunttu barenttu nagaran ooshettana; unttunttu laa\"uukka na'aa yelennaan hayk'k'ana. ");
INSERT INTO dwrl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Itti Asay bare ishaa machchato akkooppe, hewe tunatetsa. I bare ishaa kawushshiseedda; unttunttu laa\"uukka na'aa yelikkino. ");
INSERT INTO dwrl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","« ‹Simmi hintte de'anaadan, taani hinttena gelissiyaa biittay hinttena c'uchchenna mala, hintte ta higgiyaanne ta azazuwaa naagitenne ootsite. ");
INSERT INTO dwrl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Taani hintte sintsaappe d'ayissiyaa asatuwaa de'uwaa wogaa kaalloppite. Unttunttu hawaa ubbaa ootseedda diraw, taani unttuntta shenetaad. ");
INSERT INTO dwrl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Shin taani hinttena, «Unttunttu biittaa hintte laattana; hintte he biittaa hinttewaa ootsanaadan, he maatsaynne eessay goggiyaa biittaa taani hinttenttoo immana» yaagaad. Taani hinttena hara asatuwaappe dummaya kesseedda Med'inaa Godaa hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","« ‹Hewaa diraw hintte geeshsha gideedda mehetuwaanne kafotuwaa geeshsha gidennawanttuppe shaakkiide erite. Taani hawanttu hinttenttoo tuna ga wotseedda mehetuwaan, kafotuwaaninne sa'aan k'aas'erettiyaabatuwaan ubbaan hintte huup'iyaa tunissoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Taani Med'inaa Goday geeshsha gidiyaa dirawunne hintte tawaa gidana mala hinttena hara asaappe dummayeedda diraw, hinttekka taw geeshsha gidite. ");
INSERT INTO dwrl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","« ‹Itti attuma Asay woy mac'c'a Asay moyttilliyaanna haasayiyaawaa woy shareechcho gidooppe, unttunttu hayk'k'anaw besse. Unttunttu shuchchaan c'adettino. Unttunttu suutsaa ac'uu unttunttu bollana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Med'inaa Goday Musa hawaadan yaageedda, «K'eesiyaa gidiyaa Aaroona attuma naanaatoo hawaadan yaagaade oda; ‹Hintteppe ooninne ");
INSERT INTO dwrl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","bare mata dabbo, bare daay, bare aawuwaa, bare attuma na'aa, bare mac'c'a naatti, bare ishaa, ");
INSERT INTO dwrl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","woy asinaa gelennaan, de'iyaa bare michchati anhaa gidana d'ayooppe, hayk'k'eedda asaa anhaa oowaanne bochchiide, barena tunissoppo. ");
INSERT INTO dwrl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","K'ay akuwaaninne geluwaan dabboteedda asaa anhaa bochchiidekka barena tunissoppo. ");
INSERT INTO dwrl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","« ‹K'eesetuu hayk'k'eeddawoo kayyottanaw barenttu huup'iyaa meedettoppino; barenttu buuchchaakka k'antsaan k'ans's'oppino; woy k'ay barenttu bollaakka k'ans's'ereetsoppino. ");
INSERT INTO dwrl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Unttunttu barenttu S'oossaw geeshsha gidino; k'ay barenttu S'oossaa suntsaakka tunissoppino. Ayaw gooppe unttunttu Med'inaa Godaw taman s'uugiide yarshshiyaa, k'umaa yarshshuwaa shiishshiyaawantta; hewaa diraw, unttunttu geeshsha gidanaw bessee. ");
INSERT INTO dwrl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","« ‹K'aykka k'eesatuu sharmus'a mac'c'a asaa, wodorotetsay aketti diggeedda mac'c'a asaa, woy asinay yeddeedda mac'c'a asaa akkoppino. Ayaw gooppe, k'eesatuu barenttu S'oossaw geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","K'eesii hintte S'oossaw k'umaa yarshshuwaa shiishshiyaawaa gidiyaa diraw, I hara asaappe dummato. Taani hinttena geeshshiyaa hintte Med'inaa Goday geeshsha gidiyaa diraw, ikka geeshsha gido. ");
INSERT INTO dwrl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ay k'eesiyaa naatto gidooppekka sharmus'aade barena tunissooppe, henna bare aawuwaa kawushshaaddu. Iza taman s'uugettaade hayk'k'u. ");
INSERT INTO dwrl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","« ‹K'eesiyaa ubbatuwaa kaappuu, Aa huup'iyaan okettiyaa zayitii gukkeedda dirawunne I k'eesetetsaa mayuwaa mayyanaw dummateedda asaa gidiyaa diraw, bare huup'iyaa binnaanaa kallo wotsoppo; woy bare mayuwaakka peed'oppo. ");
INSERT INTO dwrl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ay anhaa gidooppekka, de'iyaa sa'aa I geloppo; haray atto bare aawuwaa woy bare daay anhaa gidooppekka, barena hewaan tunissoppo. ");
INSERT INTO dwrl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Aa geeshshanaw okkiyaa S'oossaa zayitii Aa bollan de'iyaa diraw, k'eesii S'oossaa Dunkkaaniyaappe kesoppo; S'oossaa Dunkkaaniyaakka tunissoppo. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","« ‹K'eesii wodoro mac'c'a naatto akko. ");
INSERT INTO dwrl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Asinay hayk'k'eedda mishirato, woy asinay yeddeedda mishirato, woy woshumaa mishirato akkoppo. Shin bare asaa giddoppe wodoro mac'c'a naatto dooriide akko. ");
INSERT INTO dwrl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Yaanana d'ayooppe, I bare asaa giddon bare zeretsaa gidiyaa bare naanatuwaa tunissana. Taani Aa geeshshiyaawe, med'inaa Godaa yaaga› » yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Med'inaa Goday Musa, hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Neeni Aaroonaw hawaadan yaagaade oda; ‹Sintsanna yiyaa ne zeretsaappe bollay tilla gidenna Asay ooninne k'umaa yarshshuwaa taw immanaw shiik'oppo. ");
INSERT INTO dwrl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ayaw gooppe bollay tilla gidenna Asay ooninne shiik'anaw bessena. K'ook'a, woy wobba, woy demuu narp'p'etteedda, woy pac'a bollay de'iyaa asay, ");
INSERT INTO dwrl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","woy gediyaa woy kushiyaa silay, ");
INSERT INTO dwrl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","woy k'uunay, woy dinkkii, woy ayfii sakkiyaa asay, woy puussuu oyk'k'eedda asay, woy ilahuu oyk'k'eedda asay, woy goyro gidinakka bollay tilla gidenna asay, ooninne shiik'oppo. ");
INSERT INTO dwrl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","K'eesiyaa Aaroona zariyaappe bollay tilla gidenna Asay ooninne Med'inaa Godaw taman s'uuggiyaa yarshshuwaa shiishshanaw shiik'oppo. Aw bollay tilla gidennawaa gidowaappe hini baggan, bare S'oossaw k'umaa yarshshuwaa shiishshanaw I bessena. ");
INSERT INTO dwrl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","I geeshsha k'umaanne k'ay geeshsha ubbaappe ittuwaa gideedda geeshsha yarshshuwaa bare S'oossaa k'umaakka maanaw danddayee. ");
INSERT INTO dwrl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Shin aw bollay tilla gidenna diraw, I ta Dunkkaaniyaa tunissennaadan, gaaridduwaakko woy yarshshiyaa sa'aakko shiik'oppo. Ayaw gooppe, unttuntta geeshshiyaawe taani Med'inaa Godaa yaaga› » yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Muse Aaroonaw, Aa attuma naanawunne Israa'eeliyaa asaw ubbaw hawaa odeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Ta geeshsha suntsaa unttunttu tunissenna mala, Israa'eeliyaa Asay taw dummayeedda imotaa Aarooninne Aa attuma naanay bonchchuwaan akkiide, geeshshatetsaan naagana mala, unttunttoo oda. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","«Unttunttoo hawaadan yaaga; ‹Sintsanna yiyaa yeletaa ubbaan hintte zariyaappe ooninne tuni uttiide, Israa'eeliyaa Asay Med'inaa Godaw dummayeedda geeshsha yarshshuwaakko shiik'ooppe, he Asay ta sintsaappe bohetto. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","« ‹Aaroona zariyaappe wolk'k'aama galbbaa harggii de'iyaa, woy bollaappe ayayneekka goggiyaa ooninne geeyana gakkanaw, geeshsha yarshshuwaappe mooppo. Anhaa bochchiide tuneeddawaa woy Aa attumatetsaappe zeretsay gukkeedda uraa bochchiyaa ooninne tuna. ");
INSERT INTO dwrl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Woy k'ay sa'aanna gooshettiyaa, tunissiyaawantta, woy ay mala tunatetsaa gidooppenne tunissiyaa asaa bochchiyaa uray, ");
INSERT INTO dwrl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","woy hewaa malabaa ayaanne bochchiyaa asay, omarssi gakkanaw I tuna; bare bollaa haatsaan meec'ettennaan de'iidde, he geeshsha yarshshuwaappe I maanaw koshshenna. ");
INSERT INTO dwrl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Away wulliyaa wode I geeshsha gidee; Hewaappe guyyiyaan, he geeshsha yarshshuwaappe barena gakkiyaawaa mo gaasuukka hewe Aa k'umaa. ");
INSERT INTO dwrl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Barew hayk'k'eeddawaa woy do'ay wod'eedda mehiyaa ashuwaa mooppo; hewe tunissiyaabaa. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","« ‹K'eesetuu ta wogaa; naagennan is's'ooppe, unttunttu Aa tunissiide Aa nagaran hayk'k'ana. Unttuntta geeshshiyaawe Taana Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","« ‹He geeshsha yarshshuwaa k'eesiyaa soo asaappe attina, hara Asay mooppo; k'eesiyaa soo yeedda imatsaa gidina, woy k'as's'arettiide ootsiyaa k'oomaa gidinakka mooppo. ");
INSERT INTO dwrl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Shin k'eesii bare biran shammeedda ayiliyaa woy Aa son yeletteedda ayilii he k'umaappe mo. ");
INSERT INTO dwrl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","K'eesiyaa gidenna hara asaa geleedda k'eesiyaa naatta he geeshsha yarshshuwaappe muuppu. ");
INSERT INTO dwrl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Shin k'eesiyaa naatta asinay hayk'k'ina, woy asinay yeddina, na'aa yelennaan kase bare wodorotetsaan de'iyaawaadan simmaade bare aawuwaa golle yooppe, Aa bare aawuwaa gakkiyaa k'umaappe mu. Shin hara Asay ooninne hewaappe mooppo. ");
INSERT INTO dwrl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","« ‹Itti Asay erennan de'iidde geeshsha yarshshuwaappe mooppe, he I meedda k'umaa gatiyaa bolla s'eetuwaappe laatamu kushiyaa gujjiide k'eesiyaw immo. ");
INSERT INTO dwrl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Israa'eeliyaa Asay Med'inaa Godaw yarshshiyaa geeshsha yarshshuwaa k'eesatuu tunissoppino. ");
INSERT INTO dwrl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Unttunttu barenttu aheedda geeshsha yarshshuwaa barew miide, barenttu nagaran ooshettanaadan, k'eesatuu ootsanaw koshshenna. Ayaw gooppe, unttuntta geeshshiyaawe, taani Med'inaa Godaa yaaga› » yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Med'inaa Goday Musa hawaadan yaageedda, ");
INSERT INTO dwrl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Aaroonaw, Aa naanatoonne Israa'eeliyaa asaa ubbaw hawaadan yaagaade oda; ‹Israa'eeliyaa asaappe gidina woy unttunttu giddon de'iyaa betiyaappe ooninne Med'inaa Godaw s'uuggiyaa yarshshuwaa bare dosuwaan c'oo immiyaa woy bare shiik'k'owaa gatsanaw yarshshiyaa wode, ");
INSERT INTO dwrl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","he yarshshuu akettana mala, korumaappe woy dorssaappe woy deeshshaappe tilla bollaanna de'iyaa attumawaa gido. ");
INSERT INTO dwrl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Bollay tilla gidennawe ayaa gidooppenne aketena diraw, hewaa shiishshoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","« ‹K'ay oona gidooppenne bare shiik'k'owaa gatsanaw ittippetetsaa yarshshuwaa S'oossaw yarshshiyaa wode, woy bare mehiyaappe bare dosuwaan c'oo immiyaa imotaa Med'inaa Godaw shiishshiyaa wode, hewe aketana mala I tilla bollaanna de'iyaawaa gido. ");
INSERT INTO dwrl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Hintte mehiyaappe k'ook'iyaa, woy me'uwaa, woy gunddaa, woy giiyiyaa maytsay, woy puussuu, woy ilahuu de'iyaawaa Med'inaa Godaw yarshshoppite; k'ay taman s'uuggiyaa yarshshuwaa ootsiidekka yarshshiyaa sa'aa bollan Med'inaa Godaw shiishshoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Aa bollan pac'a med'etay woy pac'abay de'iyaa korumaa woy dorssaa itti Asay bare dosuwaan c'oo immiyaa yarshshoo shiishshanaw danddayee; shin shiik'uu gatso gidooppe, hewe aketena. ");
INSERT INTO dwrl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Sanggisetteeddawaa woy k'os'etteeddawaa woy kaatsay maytteeddawaa woy k'ans's'etteeddawaa Med'inaa Godaw yarshshoppite. Hintte gadiyaan hewaa malabaa ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Hintte giddon de'iyaa allaga asatuwaappe akkeedda hewaa mala mehiyaakka hintte S'oossaw k'uma ootsiide shiishshoppite. Unttunttu bollay tilla gidennawaa gaasuwaan unttunttun pokkuu de'iyaa diraw, unttunttu hintte diraw akettikino› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","K'aykka Med'inaa Goday Musa hawaadan yaageedda, ");
INSERT INTO dwrl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Miizzaa maray woy dorssaa maray woy deeshshaa maray yelettiyaa wode, laappun gallassaa bare daayinna gam\"o. Hosppuntsa gallassaappe doommiide, Med'inaa Godaw taman s'uugiide shiishshiyaa yarshsho ootsiide shiishshanaw danddayettee. ");
INSERT INTO dwrl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Miyatoo, dorssatoo, woy deeshshatoo I maraanna itti gallassi shukkoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«Hintte galataa yarshshuwaa Med'inaa Godaw shiishshiyaa wode, hintte yarshshuu aketanaadan yarshshite. ");
INSERT INTO dwrl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","He yarshshuu he gallassikka meetettanaw koshshee; aappe ayaanne wonttiw ashshoppite. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Ta azazuwaa naagitenne ootsite. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","K'ay ta geeshsha suntsaa hintte tunissoppite; Israa'eeliyaa asaa giddon taani geeshsha gidiyaawe erettanaw bessee. Hinttena geeshshiyaawe, taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Hinttew S'oossaa gidanaw, hinttena Gibs'e gadiyaappe kesseeddawe taana. Taani Med'inaa Godaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Geeshsha shiik'uwaa gi awaayiide, hintte bonchchanaw bessiyaa keeretteedda Med'inaa Godaa baalatuu hawantta. ");
INSERT INTO dwrl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","« ‹Hintte usuppun gallassaa oosuwaa ootsiita; shin laappuntsa gallassi hintte shemppiyaa Sambbata gallassaa; he gallassan geeshsha shiik'uwaa shiik'ite; ayaa oosonne ootsoppite; hintte de'iyaa sa'aan ubbaan hewe Med'inaa Godaw Sambbataa. ");
INSERT INTO dwrl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","« ‹Unttunttu wodiyaan wodiyaan geeshsha shiik'uwaa ootsi awaayiide hintte bonchchanaw bessiyaa Med'inaa Godaa baalatuu hawantta. ");
INSERT INTO dwrl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Koyro aginaan tammanne oyddentso gallassi sa'ay omarssiyaa wode, Med'inaa Godaa Paasigay doommee. ");
INSERT INTO dwrl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","« ‹K'ay he aginankka tammanne ichcheshentso gallassay Med'inaa Godaa magaage Ukitsaa Baalaa gallassaa; hewaa diraw laappun gallassatuwaan irshshuu gelibeenna ukitsaa miite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","He gallassatuwaappe koyiro gallassan geeshsha shiik'uwaa shiik'ite; daaburssiyaa oosuwaa ayaanne ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Laappun gallassaa ubbaa Med'inaa Godaw taman s'uuggiyaa yarshshuwaa shiishshite; laappuntsa gallassan k'ay geeshsha shiik'uwaa shiik'ite; daaburssiyaa oosuwaa ayaanne ootsoppite› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Taani hinttenttoo immiyaa biittaa geliide, hintte katsaa c'akkiyaa wode, he katsaw koyiro ayfiyaa mirk'k'iyaa k'eesiyaakko akki yiite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Med'inaa Goday hinttewaa akkana mala, Sambbata wonttetsa gallassi k'eesii he mirk'k'iyaa S'oossaa sintsan k'aatso. ");
INSERT INTO dwrl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","He hintte mirk'k'iyaa k'aatseedda gallassi tilla bollaanna de'iyaa itti laytsaa dorssaa orggiyaa s'uuggiyaa yarshshuwaa ootsiide Med'inaa Godaw shiishshite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","He yarshshuwaanna ittippe wogaraa zayitiyaan munak'etteedda laa\"u kiilo giraame lo\"o d'iiliyaa katsaa yarshshuwaa ootsiide shiishshite; hewe Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa gidanawaa; hewaanakka k'ay ittippe itti liitiro gidiyaa woyniyaa eessaa shiishshite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ha yarshshuwaa hintte hintte S'oossaw shiishshiyaa gallassay gakkanaw, ooratsa gakkeedda katsaappe ukitsaa, woy s'iis'aa gidina, k'ayiyaa gidinakka mooppite. Hawe hintte de'iyaa sa'aan ubbaan sintsanna yiyaa yeletaw ubbaw med'inaw woga. ");
INSERT INTO dwrl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","« ‹Hintte k'aatsiyaa yarshshuwaa mirk'k'iyaa aheedda Sambbata wonttetsappe doommiide, laappun saaminttaa kumentsaa paydite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Laappuntsa Sambbataa wonttetsa gallassay gakkanaw, ishatamu gallassaa paydiidde, ooratsa gakkeedda katsaa yarshshuwaa Med'inaa Godaw shiishshite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Hintte ak'iyaa sa'aappe laa\"u kiilo giraame gidiyaa lo\"o d'iiliyaappe irshshuwaa yeggiide uukkeedda laa\"u ukitsaa k'aatsanaw akki yiite. Hewe koyiro gakkeedda katsaa ayfiyaappe Med'inaa Godaw yarshshuwaa gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","He ukitsaanna ittippe tilla bollaanna de'iyaa itti laytsaa gideedda laappun dorssaa maratuwaa, itti korumaanne laa\"u dorssaa orggetuwaa shiishshite. Katsaa yarshshuwaananne ushshaa yarshshuwaanna ittippe Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa ootsiide yarshshite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","K'ay itti deeshshaa orggiyaa nagaraa yarshshoo, itti laytsaa gideedda laa\"u dorssaa orggetuwaakka ittippetetsaa yarshshoo shiishshite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","« ‹K'eesii he koyiro gakkeedda katsaa ayfiyaa ukitsaanne he laa\"u dorssatuwaa k'aatsiyaa yarshshuwaa ootsiide, Med'inaa Godaa sintsan k'aatsee; hewanttu Med'inaa Godaw geeshsha; k'ay k'eesiyaawukka gishuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","He gallassikka awaayiide geeshsha shiik'uwaa shiik'ite; daaburssiyaa ooso ayaanne ootsoppite. Hawe hintte de'iyaa saan ubbaan sintsanna yiyaa yeletaw ubbaw med'inaw woga. ");
INSERT INTO dwrl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","« ‹Hintte gadiyaan mokkeedda katsaa hintte c'akkiyaa wode, hintte shoyk'aa gas'aa gakkanaw c'akkoppite; c'akkishin attiyaa k'aarimiyaakka k'oroppite; hewaa hiyyeesatoonne betetoo aggi bashite. Taani, Med'inaa Goday, hintte S'oossaa› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Med'inaa Goday Musa hawaadan yaageedda, ");
INSERT INTO dwrl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Laappuntsa aginaan koyiro gallassaa shemppo gallassaa ootsiide bonchchite; hassayissuwaa malakataykka punettiyaa wode, geeshsha shiik'uwaa shiik'ite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","He gallassan Med'inaa Godaw taman s'uuggiyaa yarshshuwaa shiishshiteppe attina, daaburssiyaa oosuwaa ayaanne ootsoppite› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Med'inaa Goday Musa hawaadan yaageedda, ");
INSERT INTO dwrl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Ha laappuntsa aginaw tammantsa gallassay nagaraa atto giissiyaa gallassaa; he gallassi geeshsha shiik'uwaa shiik'ite; k'ay hintte huup'iyaa kawushshite; yaatiide Med'inaa Godaw taman s'uuggiyaa yarshshuwaa shiishshite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","He gallassay Med'inaa Godaa hintte S'oossaa sintsan hintte nagaray atto geetettana mala, hintte nagaraa atto giissiyaa gallassaa gidiyaa diraw, he gallassi ay oosuwaanne ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","He gallassi barenatetsaa kawushshenna Asay ooninne bare asaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","He gallassi ayaa oosuwaa gidooppenne ootsiyaa asaa taani Aa asaa giddoppe d'ayissana. ");
INSERT INTO dwrl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","He gallassi ay oosuwaanne ootsoppite. Hawe hintte de'iyaa saan ubbaan sintsanna yiyaa yeletaw ubbaw med'inaw woga. ");
INSERT INTO dwrl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hewe hintte waanna shemppuwaa shemppiyaa Sambbata gallassaa. He gallassan hintte huup'iyaa kawushshite. He aginaan udduppuntsa gallassan omarssaappe doommiide, tammantsa gallassaa omarssay gakkanaw, hintte Sambbataa bonchchite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Med'inaa Goday Musa hawaadan yaageedda, ");
INSERT INTO dwrl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Ha laappuntsa aginaan tammanne ichcheshentso gallassaappe doommiide, laappun gallassay Med'inaa Godaw Daasiyaa Baala. ");
INSERT INTO dwrl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","He gallassatuwaappe koyiro gallassan geeshsha shiik'uwaa shiik'ite; daaburssiyaa oosuwaa ayaanne ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Laappun gallassan ubbaan Med'inaa Godaw taman s'uuggiyaa yarshshuwaa shiishshite; hosppuntsa gallassan k'ay geeshsha shiik'uwaa shiik'ite; Med'inaa Godaw taman yarshshiyaa yarshshuwaakka shiishshite. He gallassay hintte shiik'uwaa poliyaa gallassaa gidiyaa diraw, daaburssiyaa oosuwaa ayaanne ootsoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","« ‹Taman s'uuggiyaa yarshshuwaanne katsaa yarshshuwaa, k'ay hara yarshshotuwaa ubbaanne ushshaa yarshshuwaa, koshshiyaawaa keenaa keereedda gallassan Med'inaa Godaw shiishshanaw, hintte geeshsha shiik'uwaa ootsiide awaayana Med'inaa Godaa baalatuu hawantta. ");
INSERT INTO dwrl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ha baalatuu Med'inaa Godaa Sambbatatuwaappe, hintte imotaa ootsiide Med'inaa Godaw immiyaawanttuppe, shiik'uwaa gatsiyaawanttuppenne hintte hintte dosuwaan c'oo immiyaawanttuppe dumma. ");
INSERT INTO dwrl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","« ‹Laappuntsa aginaan tammanne ichcheshentso gallassan hintte gadiyaan mokkeeddawaa c'akkiide shiishsheeddawaappe guyyiyaan, Med'inaa Godaa baalaa laappun gallassaa bonchchite; koyiro gallassaynne hosppuntsa gallassay hinttenttoo waanna shemppo gallassaa. ");
INSERT INTO dwrl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Koyro gallassan lo\"o mitsaa ayifiyaappe, zambbaa tashiyaappe, irs's'a haytsaana de'iyaa mitsaa tashiyaappenne shaafaa matan dic'c'iyaa lee\"o tashiyaappe akkiide, Med'inaa Godaa hintte S'oossaa sintsan nashetiidde, laappun gallassaa baalaa bonchchite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","He baalaa laytsan laytsan laappun gallassaa Med'inaa Godaw bonchchite. Hewe sintsanna yiyaa yeletaw ubbaw med'inaw woga. Hintte hewaa laappuntsa aginaan bonchchite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","He laappun gallassaa hintte daasiyan de'ite; Israa'eeliyaa biittaa asaa gidiyaa ubbay daasiyan de'ite. ");
INSERT INTO dwrl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Hewe sintsanna yiyaa yeletay ubbay Israa'eeliyaa asaa taani Gibs'eppe Kesseedda wode, unttunttu daasiyan de'anaadan ootseeddawaa eranaassa. Taani Med'inaa Godaa hintte S'oossaa› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Hewaadan ootsiide, Muse Med'inaa Godaa Baalatuwaa bonchchiyaa wogaa Israa'eeliyaa asaw odeedda. ");
INSERT INTO dwrl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Med'inaa Goday Musa hawaadan yaageedda, ");
INSERT INTO dwrl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«S'omppii to'ennan ees's'iidde de'ana mala, Asay koshshiyaa zayitiyaa wogaraa teeraa c'addiide gum\"ina geeshsha new ahana mala, Israa'eelatuwaa azaza. ");
INSERT INTO dwrl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Med'inaa Godaa Dunkkaaniyaa giddon de'iyaa markkatetsaa gaariduwaappe kare baggana, omarssaappe wontta gakkanaw, Aarooni Med'inaa Godaa sintsan he s'omppiyaa ubbaa wode eetso. Sintsanna yiyaa yeletaw ubbaw hewe med'inaw woga. ");
INSERT INTO dwrl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","S'omppiyaa wotsiyaa, walakay bayinna work'k'aa ballaa bolla de'iyaa s'omppetuu Med'inaa Godaa sintsan ubbaa wode ees's'anaadan Aarooni naago. ");
INSERT INTO dwrl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Laatamanne oyddu kiilo giraame gidiyaa liik'o d'iiliyaa akkaade tammanne laa\"u ukitsaa uukka. ");
INSERT INTO dwrl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","He ukitsatuwaa usuppunatuwaa ittuwaa ittuwaa bolla usuppunatuwaa ittuwaa ittuwaa bollan Med'inaa Godaa sintsan de'iyaa walakay bayinna work'k'aa s'arap'p'eezaa bollan wotsa. ");
INSERT INTO dwrl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Med'inaa Godaw taman s'uugganaw shiishsheedda k'umaa yarshshuwaa gidiyaawaa erissanaw, laa\"u maaratuwaa matan matan geeshsha is'aanaa hassayisiyaawaa ootsaade wotsa. ");
INSERT INTO dwrl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ha ukitsaa Sambbatan Sambbatan ubbaa wode Aarooni Med'inaa Godaa sintsan Israa'eeliyaa asaa diraw wotso. Hewe Israa'eeliyaa Asay ubbaa wode ootsanaw koshshiyaa k'aalaa c'aak'uwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Hewe Aaroonawunne Aa attuma naanaatoo imetto; I Med'inaa Godaw taman s'uuggiyaa yarshshuwaappe wogaadan Aaroonanne Aa naanatuwaa gakkiyaa ubbaappe geeshsha gideedda yarshshuwaappe ittuwaa gidiyaa geeshsha yarshshuwaa gidiyaa diraw, unttunttu hewaa geeshsha sa'aan miino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Aata Israa'eeliyaa asaa, aawuu k'ay Gibs'e asaa gidiyaa itti bitanii de'ee. Itti gallassi I hara Israa'eeliyaa asaa gidiyaa ittuwaanna dunkkaaneedda sa'aan wad'etteedda. ");
INSERT INTO dwrl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ha aw aata Israa'eeliyaa asaa gideedda bitanii wad'etaa giddon S'oossaa suntsaa shek'k'eedda. Yaatina Aa Musekko aheeddino. He bitaniyaa aata Daana yaraa gidiyaa S'iibira naatto. I suntsaykka Shalomiito. ");
INSERT INTO dwrl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ha bitaniyaa waatanentto Med'inaa Godaa shenii unttunttoo k'onc'c'ana gakkanaw, unttunttu Aa k'asho golliyaan wotseeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Med'inaa Goday Musa hawaadan yaageedda, ");
INSERT INTO dwrl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«He shek'k'eedda bitaniyaa dunkkaaneedda sa'aappe gas'aa kessa; I shek'ishshin siseedda Asay ubbay barenttu kushiyaa Aa huup'iyaa bollan wotsino; yaatooppe Israa'eeliyaa asaa maabaray ubbay Aa shuchchaan c'addiide wod'o. ");
INSERT INTO dwrl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Israa'eeliyaa asaw hawaadan yaagaade oda; Ay asaynne bare S'oossaa shek'k'ooppe, I bare nagaran ooshettee. ");
INSERT INTO dwrl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Med'inaa Godaa suntsaa shek'k'iyaa Asay hayk'k'o; Israa'eeliyaa asaa maabaray ubbay Aa shuchchaan c'addo. Betiide yeeddawaa gidina woy biittaa asaa gidinakka Med'inaa Godaa suntsaa shek'k'ooppe hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","« ‹Asa wod'iyaa Asay hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Asaa mehiyaa wod'iyaa Asay ooninne bare wod'eedda mehiyaa diraw pas'a mehiyaa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Itti Asay bare shooruwaa k'ohooppe, I ootseeddawaadan Aa bollankka oosetto. ");
INSERT INTO dwrl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Mentsooppe me\"o; ayfiyaa diraw ayfiyaa; achchaa diraw achchaa. Asaa bollan k'ohuwaa gatseedda oonikka I gatseedda k'ohuwaa malay Aa bollankka gakko. ");
INSERT INTO dwrl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Mehiyaa wod'eedda Asay mehiyaa c'iggo; shin asaa wod'eedda Asay hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Betiyawukka Israa'eeliyaa asaw higgii itti mala gido; ayaw gooppe Taani Med'inaa Godaa hintte S'oossaa› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Hewaa ubbaa Muse Israa'eeliyaa asaw ubbaw odeedda; unttunttu he shek'k'eedda bitaniyaa dunkkaaneedda sa'aappe gas'aa kessiide, shuchchaan c'addiide wod'eeddino. Yaatiide Israa'eeliyaa Asay Med'inaa Goday Musa azazeeddawaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Siinaa Deriyaa bollan Med'inaa Goday Musew hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Neeni Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Taani hinttenttoo immiyaa biittaa hintte geliyaa wode, biittaykka Med'inaa Godaa Sambbataa bonchcho. ");
INSERT INTO dwrl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Usuppun laytsaa kumentsaa hintte shoyk'aan zerite; k'ay usuppun laytsaa kumentsaakka hintte woyniyaa turaa s'eeraa s'unk'k'ite; Aa ayfiyaakka mas'i akkite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Shin laappuntsa laytsay biittaw shemppo Sambbata; hewe Med'inaa Godawukka Sambbata. He laappuntsa laytsan hintte shoyk'aan zeroppite; hintte woyniyaa s'eeraakka s'unk'k'oppite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Hintte gadiyaan azabbaa gidiide mokkiyaawaakka c'akkoppite; k'ay s'unk'k'ennan de'ishshin c'oo ayfeedda woyniyaakka shiishshoppite. He laytsay biittaw ubbaanna shemppo laytsaa gido. ");
INSERT INTO dwrl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","7","He Sambbata laytsan biittay oosettana d'ayooppe hinttenttoo, hintte mac'c'anne attuma k'oomatoo, hinttenttoo keraa ootsiyaawanttoo, betiide yiide hinttenana de'iyaawanttoo, hintte mehiyawunne hintte gadiyaan de'iyaa do'atoo gidiyaa k'umaa immana; biittay mokkiyaabay ubbay meetetto. ");
INSERT INTO dwrl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","« ‹Laytsatuwaa giddon de'iyaa laappun Sambbatatuwaa payda; laappun Sambbatatuwaa laytsaa payduu laappu gede laappuna; hewekka oytamanne udduppun laytsaa. ");
INSERT INTO dwrl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Hewaappe guyyiyaan, laappuntsa aginaan, tammantsa gallassan bonchchettiyaa nagaraa atto giissiyaa gallassan malakataa punniyaa asaa hintte gadiyaan ubbaan kiittite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ishatamantso laytsaa dummayiide, he gadiyaan de'iyaa ubbaw la\"atetsaa awaayite. Hewe hinttenttoo Ishatamantso Laytsaa Baalaa. He wodiyaan hintte ubbaykka hintte gadiyawunne hintte yaraw yaraw simmite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","He laytsay hinttenttoo Ishatamantso Laytsaa Baalaa. He laytsan zeroppite; azabbaa gidiide mokkeeddawaakka c'akkoppite; k'ay hintte Aa s'eeraa s'unk'k'ennan ayfeedda woyniyaa ayfiyaakka shiishshoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Hewe Ishatamantso Laytsaa Baala gidiyaa diraw, I hinttenttoo geeshsha; goshenan c'oo dembban mokkeeddawaa miite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","« ‹Ha Ishatamantso Laytsaa Baalaa wode Asay ubbay bare gadiyaa simmo. ");
INSERT INTO dwrl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","« ‹Hintte hintte shooruwaappe gadiyaa shammooppe, woy k'ay aw zal''ooppe, ittuu ittuwaa c'immoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Hintte Ishatamantso Laytsaa Baalaappe guyyiyaan de'iyaa laytsatuwaa payduwaadan hintte shooruwaappe shammite; hintte shooruukka k'ay gadii katsaa mokkanaw de'iyaa laytsatuwaa payduwaadan zal\"o. ");
INSERT INTO dwrl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Laytsatuwaa paydu daro gidooppe, gatii daree; laytsatuwaa payduu guus's'ooppe, gatiikka guus's'ee. Ayaw gooppe, hintte c'akkana katsaa c'akaa payduwaadan hintte shooruu hinttenttoo zal''ee. ");
INSERT INTO dwrl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Hintte ittuu ittuwaa c'immoppite; shin hintte hintte S'oossaw yayyite. Taani Med'inaa Goday, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","« ‹Ta azazuwaa ootsite; ta higgiyaakka naagitenne ootsite; yaatooppe hintte ha gadiyaan sarotetsaan de'ana. ");
INSERT INTO dwrl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Biittay bare ayfiyaa hinttenttoo immana; hintte kallana gakkanaw maana; k'ay he biittankka hintte sarotetsaan de'ana. ");
INSERT INTO dwrl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Hintte, «Nuuni zerana d'ayooppe, k'ay katsaakka c'akkiide shiishshana d'ayooppe, laappuntsa laytsan ayaa maanee?» gooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","taani usuppuntsa laytsan ta anjjuwaa hintte bollan kiittana; yaatooppe biittay heezzu laytsaw gidiyaa ayfiyaa ayfana. ");
INSERT INTO dwrl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Hosppuntsa laytsan hintte hintte gadiyaan zeriyaa wodekka, kase shaachcha katsaa maana; k'ay hintte zeriyaa katsaa ayfiyaa udduppuntsa laytsan shiishshana gakkanawukka, shaachcha katsaa maana. ");
INSERT INTO dwrl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","« ‹Biittay tawaa gidiyaa dirawunne hinttekka ha gadiyaan imatsaanne bete gidiide de'iyaa diraw, biittaa laa\"entso simmennaadan bayizzoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Hintte oyk'k'eedda gadiyaan ubbaan de'iyaa gadiyaa godatuu wozana mala, unttunttu maataa naaganaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","« ‹Ne ishay hiyyeesiide bare gadiyaappe zal\"ooppe, aw matattiyaa dabbuu yiide, he gadiyaa aw wozo. ");
INSERT INTO dwrl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Aw he gadiyaa woziyaa dabbuu d'ayooppe, k'ay ikka simmi duretiide woziyaa miishshaa demmooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","bare zal\"eedda wodiyaappe doommiide de'iyaa laytsaa paydiidde, atteeda laytsaa miishshaa shammeeddawoo zaaro; yaatiide I bare gadiyaw simmo. ");
INSERT INTO dwrl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Shin aw he gadiyaa wozanaw gidiyaa shaluu d'ayooppe, Ishatamantso Laytsaa Baalay gakkanaw gadii shammeedda bitaniyaa kushiyaan gam\"o; Ishatamantso Laytsaa Baalaa wode, Aa gadii aw simmo; ikka bare gadiyaw simmo. ");
INSERT INTO dwrl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","« ‹Gimbbetti utteedda katamaa giddon itti Asay de'iyaa golliyaa hara uraw zal\"ooppe, I zal\"osaappe biide itti laytsaa gakkanaw de'iyaa wodiyaan zaariide wozanaw aw maatay de'ee. ");
INSERT INTO dwrl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Itti laytsaa kumentsaa giddon wozana d'ayooppe, he gimbbetteedda katamaa giddon de'iyaa gollii shammeeddawoo na'aa na'aw med'inaw aawaa gidee. Ishatamantso Laytsaa Baalaa wodekka simmenna. ");
INSERT INTO dwrl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Shin gimbbettibeenna heeratuwaan de'iyaa golletuu shoyk'aa mala. Unttunttu wozettiino; Ishatamantso Laytsaa Baalaa wodekka zal\"eeddawoo simmiino. ");
INSERT INTO dwrl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","« ‹Gidooppenne Leewatuwaa katamatuwaan de'iyaa barenttu golliyaa Leewatuu barenttu koyeedda wodiyaan wozi akkanaw danddayiino. ");
INSERT INTO dwrl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Leewatuwaappe itti Asay unttunttu katamaa giddon de'iyaa golliyaa zal\"iide wozana d'ayooppe, he unttunttu katamaa giddon de'iyaa gollii Ishatamantso Laytsaa Baalaa wode simmee. Ayaw gooppe, Leewatuwaa katamaa giddon de'iyaa golletuu Israa'eeliyaa asaa giddon Leewatoo ak'o. ");
INSERT INTO dwrl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Shin unttunttu katamaa yuushshuwaan unttunttu ubbaw ittippe de'iyaa biittay unttunttoo med'inaw ak'o gidiyaa diraw zal\"ettenna. ");
INSERT INTO dwrl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","« ‹K'ay ne ishay hiyyeesiide barena danddayana d'ayooppe, imatsaadaaninne betiyaadan I neenana de'ana mala, neeni Aa maadda. ");
INSERT INTO dwrl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ne ishaa neenana wotsanaw aappe dichchaa akkoppa; woy wod'iyaa mooppa. Shin neeni ne S'oossaw yayya. ");
INSERT INTO dwrl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ne biraa aw dichchaw tal\"oppa; ne k'umaakka aw wod'iyaan zal\"oppa. ");
INSERT INTO dwrl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Hinttew Kanaane biittaa immanawunne hintte S'oossaa gidanaw, hinttena Gibs'e gadiyaappe kesseeddawe, taani Med'inaa Goday, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","« ‹New dabbo gidiyaa Israa'eeliyaa Asay mank'k'iide, barena new ayiletetsaw zal\"ooppe, neeni Aa ayiliyaadan oosissoppa. ");
INSERT INTO dwrl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","I keraa ootsiyaa asaadaaninne betiyaadan neenana de'o; Ishatamantso Laytsaa Baalay gakkanaw I new ootso. ");
INSERT INTO dwrl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","He wode I bare naanatuwaannakka ittippe ne golleppe kesiide bare golliyaa asaakko bo; bare aawuwaa gadiyaakkokka simmo. ");
INSERT INTO dwrl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Israa'eelatuu taani Gibs'e gadiyaappe Kesseedda ta ayiletuwaa gidiyaa diraw, unttunttu ayiletetsaw zal\"ettoppino. ");
INSERT INTO dwrl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Neeni unttunttoo mek'etsaa iitaade mooddoppa; shin neeni ne S'oossaw yayya. ");
INSERT INTO dwrl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","« ‹New attumanne mac'c'a ayiletuu de'ana mala koyooppe, ne yuushshuwaan de'iyaa kawutetsatuwaappe shamma. ");
INSERT INTO dwrl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","K'ay hintte gadiyaan de'iyaa betetuwaappenne hintte gadiyaan de'ishshin yeletteedda unttunttu soo asaappe shammanaw danddayiita; unttunttu hinttenttoo ak'o gidino. ");
INSERT INTO dwrl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Hintteppe guyyiyaan hintte naanay unttuntta med'inaw laattana mala, hintte naanaw immite. Hintte unttunttuppe ubbaa wodekka ayiliyaa shammanaw danddayiita; shin hintte ishaa gidiyaa Israa'eeliyaa asaa mek'etsaa iisiide mooddoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","« ‹Ne matan de'iyaa imatsaa woy bete Asay duretina, k'ay Aa matan de'iyaa ne ishay mank'k'iide, he ne matan de'iyaa imatsaw woy betiyaw woy imatsaa bitaniyaa zariyaappe ittoo barena zal\"ooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","I zal\"etti simmina Aa wozanaw danddayettee; Aa ishatuwaappe ittuu Aa wozo. ");
INSERT INTO dwrl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Woy Aa aawuwaa ishay, woy Aa aawuwaa ishaa na'ay Aa wozo; woy Aa yaraappe aw mata dabbo gidiyaa Asay Aa wozo; woy k'ay I bare huup'iyaw durettooppe I barena wozo. ");
INSERT INTO dwrl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","I barena shammeedda bitaniyaanna ittippe gidiide, I barena zal\"eedda laytsaappe doommiide Ishatamantso Laytsaa Baalay gakkanaw de'iyaa laytsaa paydo; Aa biliyaa gatii he laytsaa payduwaa keeshshaa gido. I barena shammeeddawaanna gam\"eedda wodiyaa gatii itti Asay keraa ootsiide demmiyaa miishshaa keeshsha gido. ");
INSERT INTO dwrl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ishatamantso Laytsaa Baalay gakkanaw biro daro laytsay atteedawaa gidooppe, bare zal\"etteedda gatiyaappe he laytsaa payduwaan barena woziyaa gatiyaa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","K'ay Ishatamantso Laytsaa Baalay gakkanaw atteeda laytsay guutsaa gidooppe, barena shammeeddawaanna ittippe paydiidde, he laytsaa payduwaan barena woziyaa gatiyaa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","I laytsan laytsan keraa ootsiyaa asaadan barena shammeeddawaanna de'oppe attina, hintte s'eelliidde Israa'eeliyaa asaa gidiyaa bitaniyaa mek'etsaa iisiide mooddoppite. ");
INSERT INTO dwrl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","« ‹Shin I hewaa mala ogiyaan wozettana d'ayooppe, Ishatamantso Laytsaa Baalay gakkiyaa wode inne Aa naanay k'oomatetsaappe kesino. ");
INSERT INTO dwrl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ayaw gooppe, Israa'eeliyaa Asay ta k'oomatuwaatee; taani Gibs'e gadiyaappe Kesseedda ta k'oomatuwaa. Taani, Med'inaa Goday, hintte S'oossaa› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Med'inaa Goday hawaadan yaagee; «Hintte unttunttoo goynnanaw eek'atuwaa med'd'oppite; k'ay hawulttiyaa, masetteedda misiliyaa woy masetteedda shuchchaa essoppite. Taani, Med'inaa Goday, hintte S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ta Sambbatatuwaa naagite; ta Dunkkaaniyaa bonchchite; Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Hintte ta higgiyaan booppe, ta azazotuwaakka naagooppenne ootsooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","taani hinttenttoo iraa wodiyaan bukissana; biittaykka katsaa darissiide mokkana; dembbaa mitsatuukka ayfiyaa ayifana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Hintte katsaa bukkiyaa wodiyaappe biide woyniyaa ayfiyaa mas'iyaa wodii gakkanaw katsaa k'os's'ana; k'ay woyniyaa ayfiyaa mas'uukka biide katsaa zeriyaa wodii gakkanaw wurenna. Hintte kallana gakkanaw k'umaa maana; k'ay hintte hintte biittankka saruwaan de'ana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","«Taani biittaw sarotetsaa immana; ooninne yashissennan hintte gisana. Iita do'atuwaa taani gadiyaappe d'ayissana; hintte gadiyaan laa\"entso olay denddenna. ");
INSERT INTO dwrl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Hintte morkkatuwaa hintte yederssana; hintte sintsan unttunttu mashshaan hayk'k'ana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Hintteppe ichcheshu s'eetuwaa yederssana; k'ay s'eetuu tammu sha\"aa yederssana. Hintte morkketuu hintte sintsan mashshaan hayk'k'ana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","«Taani ta deemuwaa hinttekko zaarana; hinttena ayfissana; hinttena darissana. K'ay taani ta c'aak'uwaa hinttenana minisana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Hintte shaachcha katsaa maana; k'ay ha laytsaa katsaa wotsanaw, shaachcha katsaa diggiide sa'aa kessana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Taani ta de'iyaa sa'aa hintte giddon ootsana; taani hinttena shaattikke. ");
INSERT INTO dwrl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Taani hintte gidduwaan hamettana; k'ay hintte S'oossaa gidana; hinttekka ta asaa gidanita. ");
INSERT INTO dwrl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Hintte Gibs'etoo ayiliyaa gidennaadan, Gibs'e gadiyaappe hinttena kesseeddawe Taani Med'inaa Goday hintte S'oossaa. Taani hintte ayiletetsaa morgge mitsaa mentsaad; k'ay hinttekka d'ok'k'u giide hemettanaadan ootsaad. ");
INSERT INTO dwrl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Shin hintte taani giyaawaa sisennan is's'ooppenne, ha azazotuwaa ubbaakka ootsennan is's'ooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ta wogaa hintte kad'ooppe, k'ay ta azazotuwaa ubbaa ootsennan is's'iide ta c'aak'uwaa mentsanaw hintte ta higgiyaa shaattooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","he wode taani hintte bolla hawaa ootsana: Hintte akeekenan de'ishshin yashshaa, gilk'k'atetsaa, hintte ayfiyaa jollisiyaanne hinttena loytsi harggissiyaa mishuwaa hintte bolla ahana. Hintte zeretsaa zerana; shin I hada; ayaw gooppe, hewaa hintte morkketuu maana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Taani ta som\"uwaa hintte bolla tukkana; hintte morkkatuwaa sintsan hintte kunddana; hinttena is's'iiyaawanttu hinttena mooddana; k'ay ooninne yederssenan hintte bak'atana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Hawaa ubbaa ootsinakka hintte taana sisennan is's'ooppe, taani hintte nagaraa diraw hintte muraa laappun dakkuwaa gujjana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Hintte wolk'k'aa otoruwaa taani mentsana; saluwaa birataa mala ootsana; hintte biittaakka nahaasiyaa giyaa birataa mala ootsana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Hintte wolk'k'ay hadasan wurana; ayaw gooppe, hintte biittay katsaa mokkenna; gadiyaan de'iyaa mitsatuukka ayfiyaa ayfikkino. ");
INSERT INTO dwrl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«Hintte taw is's'eeddo gooppenne taani giyaawaakka sisennan is's'ooppe, hintte nagaraa keeshshaa laappun dakkuwaa boshaa taani hintte bollan ahana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Taani hintte bolla bazzuwaa do'atuwaa yeddana; unttunttu hintte naanatuwaa bonk'k'ana; hintte mehetuwaa d'ayssana; hintte payduwaakka guutsana; hewaa gaasuwaan hintte hamettiyaa ogii bazzuwaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Ha ubbaa murankka hintte taakko simmennaan is's'aaddi giide booppe, ");
INSERT INTO dwrl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","he wode taanikka hinttenttoo is's'aaddi gaana; k'ay hintte nagaraa diraw taani ta huup'iyaw hinttena laappun dakkuwaa murana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ta c'aak'uwaa mentseedda haluwaa kesiyaa mashshaa taani hintte bolla ahana; hintte hintte katamatuwaan shiik'ooppekka, taani hintte bollan iita harggiyaa yeddana. K'ay hinttekka hintte morkkatuwaa kushiyaan aad'd'iide imettana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Hintte katsaa taani d'ayssiyaa wode, tammu mac'c'a asatuu itti bashiyaan ukitsaa uukkana; hewaakka miizaanan likkiide shaakkana; hintte hewaa maana, shin kallikkita. ");
INSERT INTO dwrl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Ha ubbankka hintte taani giyaawaa sisennan is's'aaddi giide booppe, ");
INSERT INTO dwrl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","he wode taanikka hintte bolla hank'k'uwaan denddana; hintte nagaraa diraw taani ta huup'iyaw hinttena laappun dakkuwaa muran. ");
INSERT INTO dwrl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Hintte hintte attuma naanatuwaanne hintte mac'c'a naanatuwaa ashuwaa maana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Hintte goynniyaa d'ok'k'a sa'aa taani kolana; hintte is'aanaa yarshshiyaa sa'aakka d'ayssana. Taani hintte anhaa hintte eek'atuwaa anhaa bollan olana; taani hinttena mule shaataanna. ");
INSERT INTO dwrl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Taani hintte katamatuwaa mela ootsana; hintte goynniyaa sa'atuwaakka kolereetsana; hintte sawiyaa yarshshuwaakka singgikke. ");
INSERT INTO dwrl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","«Taani hintte biittaa d'ayssana; yaatooppe he hintte gadiyaan yiide uttiyaa morkketuukka hewaan malalettana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Taani hinttena kawutetsatuwaa giddon laalana; hintte bollankka ta mashshaa shoddana. Hintte biittay bayana; hintte katamatuukka mela gidana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","He hintte hintte morkkatuwaa gadiyaan de'iyaa wode, bayiide c'oo de'iyaa hintte biittay bare Sambbatatuwaa bonchchiidde nashettana. He wode hintte biittay shemppananne bare Sambbatatuwaa bonchchiidde nashettana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Hintte he gadiyaan de'eedda wodiyaan ubbaan hintte Sambbatatuwaan demmibeenna shemppuwaa ha\"i bayiide c'oo de'iyaa wodiyaan demmana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«Hintte hintte morkkatuwaa gadiyaan de'iyaa wode, hintteppe shaakettiide guyye attiide de'iyaawanttu wozanaan taani yashshaa yeddana; c'arkkuu k'aatsiyaa bonc'c'iyaa kooshshay unttuntta shabbirana; unttunttu mashshaappe bak'atiyaawaadan bak'atana; k'ay unttunttu ooninne yederssenan kunddana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Hinttena yederssiyaawe bayinnan de'ishshin, hintte olaappe bak'atiyaawaadan ittuu ittuwaanna d'ubettana; k'ay hintte hintte morkkatuwaa sintsan ek'k'anawukka hinttenttoo ayaa wolk'k'inne de'enna. ");
INSERT INTO dwrl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Hintte kawutetsatuwaa giddon bayana; hintte morkkatuwaa biittaykka hinttena mittana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Hintteppe shaakettiide hintte morkkatuwaa gadiyaan atteedawaanttu barenttu nagaraa gaasuwaaninne barenttu aawotuwaa nagaraa gaasuwaan gilk'k'ana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«Shin unttunttu taani unttunttoo is's'eedda gaanaadaaninne unttunttu morkkatuwaa biittaw unttuntta yeddanaadan ootseedda barenttu nagaraa, barenttu mayza aawotuwaa nagaraa, unttunttu taana c'immeedda c'imuwaanne unttunttu taw is's'aaddi geeddawaa paas'ooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","hewan k'ay unttunttu azazettena wozanaykka zik'k'i gooppenne unttunttu barenttu nagaraa muraa akkooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","he wode taani Yaak'oobana c'aak'k'eteedda ta c'aak'uwaa hassayana; k'ay Yisaak'ananne Abrahaamena c'aak'k'eteedda ta c'aak'uwaa hassayana; biittaakka hassayana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Unttunttu d'ay diggina, unttunttu biittay mela attana; he unttunttu d'ayina bayiyaawaa gidiide c'oo de'iyaa wodiyaan biittay bare Sambbatatuwaa bonchchiidde nashettana. Unttunttu ta azazuwaa kad'eedda dirawunne unttunttu shemppuukka ta wogaa shaatteedda diraw, unttunttu barenttu nagaraa muraa akkana. ");
INSERT INTO dwrl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","«Gidooppenne unttunttu barenttu morkkatuwaa gadiyaan de'iyaa wode, unttunttu ubbaanna d'ayana gakkanawunne unttunttunna de'iyaa ta c'aak'k'uwaakka mentsana gakkanaw, taani unttuntta olikke; k'ay shaattikke. Taani, Med'inaa Goday, unttunttu S'oossaa. ");
INSERT INTO dwrl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Taani unttunttu S'oossaa gidanaw, kawutetsatuu s'eellishin, Gibs'e gadiyaappe Kesseedda unttunttu mayza aawotuwaana taani c'aak'k'eteedda c'aak'uwaa unttunttu diraw hassayana. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","«Med'inaa Goday Siinaa Deriyaa bollan Muse bagganna bareppenne Israa'eeliyaa asaappe gidduwaan wotseedda wogatuu, azazotuunne higgetuu hawantta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Itti Asay Med'inaa Godaw immanaw shiik'ooppe, neeni k'oppiyaawaadan he asaa diraw miishshaa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Hewenne laatamu laytsaappe biide usuppun tammu laytsaa gakkanaw de'iyaa attumawoo usuppun s'eetu giraamiyaa dees'iyaa s'agaraa biraa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Mac'c'a asaa gidooppe k'ay hattamu s'agaraa biraa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","K'ay ichcheshu laytsaappe biide laatamu laytsaa gakkanaw de'iyaa attumawoo laatamu s'agaraa biraanne mac'c'aaniw tammu s'agaraa biraa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","K'aykka itti aginaappe biide ichcheshu laytsaa gakkanaw de'iyaa attumawoo ichcheshu s'agaraa biraanne mac'c'aaniw heezzu s'agaraa biraa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Hewaadankka k'ay usuppun tammu laytsanne hewaappe bollana de'iyaa attumawoo tammanne ichcheshu s'agaraa biraanne mac'c'aaniw tammu s'agaraa biraa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","K'ay shiik'k'eedda bitanii neeni k'oppeeddawaa c'igganaw danddayenna daro mank'k'o gidooppe, I bare shiik'uwaa gatsanaw immeedda asaa ahiide k'eesiyaa sintsan essooppe shiik'k'eedda bitanii c'igganaw danddayiyaawaa keenaa k'oppiide k'eesii gammato. ");
INSERT INTO dwrl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","« ‹I shiik'etteeddawe Asay Med'inaa Godaw yarshshiyaa sa'aa mala mehiyaa yarshshanaw gidooppe, hewaa mala Asay Med'inaa Godaw immiyaa mehii ubbay geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","I he mehiyaa diraw hara mehiyaa immoppo; woy Aa hara mehiyaanna laammoppo. Lo\"uwaa iitaanna woy k'ay iitaakka lo\"uwaanna laammoppo; shin I laammooppe, koyiro mehiinne laamiyaa immeedda mehii laa\"uukka geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","I shiik'etteedda mehii Med'inaa Godaw yarshshuwaa ootsiide shiishshanaw geeshsha gidenna mehiyaa gidooppe, he bitanii he mehiyaa k'eesiyaa sintsa aho. ");
INSERT INTO dwrl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Lo\"o gidina iita gidina, k'eesii he mehiyaa gammato; yaatooppe k'eesii gammateeddawe Aa gatiyaa gido. ");
INSERT INTO dwrl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Shin he mehiyaa goday Aa zaariide wozanaw koyooppe, he mehiyaa gatiyaa bolla s'eetuwaappe laatamu kushiyaa gujjo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","« ‹Itti Asay bare golliyaa geeshsha gidanaadan Med'inaa Godaw dummayooppe, lo\"o gidina iita gidina, k'eesii he golliyaa gammato. Yaatooppe k'eesii gammateeddawaadan Aa gatii hewaadankka gido. ");
INSERT INTO dwrl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","K'ay bare golliyaa S'oossaw geeshsha ootsi dummayeedda Asay zaaretsiide wozanaw koyooppe, he golliyaa gatiyaa bollan s'eetuwaappe laatamu kushiyaa gujjo; yaatooppe gollii aassa gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","« ‹Itti Asay bare laata gadiyaappe shaakkiide geeshsha ootsi Med'inaa Godaw dummayooppe, he gadiyaa gatii aan zeriyaa zeretsaan k'ofetto. Hewenne laatamu kiilo giraame banggaa zeriyaa keeshshaa shoyk'aa gidooppe, tammu s'agaraa biraa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","I bare gadiyaa Ishatamantso Laytsaa Baalaappe doommiide geeshsha ootsi S'oossaw dummayooppe, he gadiyaw kumentsaa gatiyaa c'iggo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Shin I bare gadiyaa Ishatamantso Laytsaa Baalay aad'd'i simmina geeshsha ootsi S'oossaw dummayooppe, kaalliide de'iyaa Ishatamantso Laytsaa Baalay gakkanaw de'iyaa wodiyaa k'eesii paydo; yaatooppe Aa kumentsaa gatiyaappe wod'd'ee. ");
INSERT INTO dwrl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","He gadiyaa geeshsha ootsi S'oossaw dummayeedda Asay zaaretsi wozanaw koyooppe, I gammatetteedda miishshaa bolla s'eetuwaappe laatamu kushiyaa gujjo; yaatooppe gadii simmiide aawaa gidee. ");
INSERT INTO dwrl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Shin I gadiyaa zaaretsiide, wozanaappe kasetiide hara asaw zal\"ooppe, he gadiyaa wozanaw danddayenna. ");
INSERT INTO dwrl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ishatamantso Laytsaa Baalay gakkina gadii yedettiyaa wode, he gadii laa\"entso guyye akkanawaadan Med'inaa Godaw geeshsha gidee. He gishuu k'eesiyaassa. ");
INSERT INTO dwrl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","« ‹Itti Asay hara asaappe shammeedda gadiyaa geeshsha ootsi Med'inaa Godaw dummayanaw koyooppe, ");
INSERT INTO dwrl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kaalliyaa Ishatamantso Laytsaa Baalay gakkanaw de'iyaa gatiyaa k'eesii gammato; bitanii he gallassikka he gimmitiyaa c'iggo; he miishshay Med'inaa Godaw dummateedda miishshaa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ishatamantso Laytsaa Baalay gakkiyaa wode, he gadii koyiro laatan akkiide zal\"eedda bitaniyaw simmee. ");
INSERT INTO dwrl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","« ‹Aa gatii S'oossaa Dunkkaaniyaan erettiyaa miizaanan gammatettee. ");
INSERT INTO dwrl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","« ‹Shin ooninne bayira yeletteedda mehiyaa Med'inaa Godaw dummayiide shiishshanaw danddayenna; ayaw gooppe, I kasekka Med'inaa Godaassa. Miizzaa mara gidina woy dorssaa mara gidinakka I Med'inaa Godaawaa. ");
INSERT INTO dwrl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","He mehii geeshsha gidana d'ayooppe, ne gammateedda gatiyaa bolla s'eetuwaappe laatamu kushiyaa gujjiide Aa goday zaaretsiide wozo. I wozana d'ayooppe, ne gammateedda gatiyaan hara asaw zal\"eteedda. ");
INSERT INTO dwrl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","« ‹Itti Asay barewaappe Med'inaa Godaw immeeddawe ayaa gidooppekka, asaa gidina mehiyaa gidina, woy Aa laatan gakkeedda gade gidinakka, zal\"etenanne wozettenna. Dummayeeddawe ubbabay Med'inaa Godaw geeshsha ubbaappe ittuwaa gideedda geeshsha yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Asaa giddoppe shaakettiide d'ayanaadan imetteedda Asay wozettoppo; he Asay hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","« ‹Biittaa asiraatay ubbay gadiyaappe mokkeedda katsaa gidina woy mitsaa ayfiyaa gidinakka Med'inaa Godaassa. Hewe Med'inaa Godaw geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Itti Asay bare asiraataa wozanaw koyooppe, Aa gatiyaa bollan s'eetuwaappe laatamu kushiyaa gujjo. ");
INSERT INTO dwrl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Miizzaa asiraataa gidina, dorssaa asiraataa gidina, woy deeshshaa asiraataa gidinakka, hentsanchchaa gatimaappe garssana aad'd'iyaa hak'awenne tammuntsi Med'inaa Godaw geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Tammuntsa mehiyaa iita gidina lo\"o gidinakka dooroppo; woy Aa haraana laammoppo. Laammooppenne koyirowenne laamiyaa immeeddawenne laa\"uukka S'oossaw geeshsha gidiinoppe attina, zaariide wozanaw danddayenna› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Siinaa Deriyaa bollan Med'inaa Goday Muse baggana Israa'eeliyaa asaa azazeedda azazotuu hawantta.");
INSERT INTO dwrl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Siinaa Mela Biittaa, Med'inaa Godaa Dunkkaaniyaa giddon, Israa'eeliyaa Asay Gibs'e gadiyaappe keseedda laa\"entso laytsan, laa\"entso aginaan, he aginaw koyiro gallassan, Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Israa'eeliyaa asaa ubbaa unttunttu yaran yaraaninne golliyaan golliyaan paydaade, attuma asaa unttunttu suntsan suntsan s'aafa. ");
INSERT INTO dwrl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Neeninne Aarooni yelettoodeppe laatamu laytsanne hewaappe bollana de'iyaa Israa'eelatuwaa, olaa baanaw danddayiyaawantta ubbatuwaa, unttunttu c'itan c'itan paydite. ");
INSERT INTO dwrl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Zariyaappe zariyaappe itti itti Asay bare golliyaa asaw kaappuwaa gidiide, hinttena maaddo. ");
INSERT INTO dwrl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Hinttena maaddana asatuu suntsay hawaappe kaalliide de'iyaawaa: Zariyaa Golliyaa Asaa Kaappuwaa Roobeela Shade'uura na'aa Eliis'uura, ");
INSERT INTO dwrl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simoona S'uriishadaaya na'aa Shalumi'eela, ");
INSERT INTO dwrl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yihudaa Aminaadaaba na'aa Na'asoona, ");
INSERT INTO dwrl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Yisaakoora S'u'aara na'aa Nataani'eela, ");
INSERT INTO dwrl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zaabiloona Heloona na'aa Eli'aaba, ");
INSERT INTO dwrl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yooseefo naanaappe Efireema Amihuuda na'aa Elishamaa'a, Minaase Padaas'uura na'aa Gamaali'eela, ");
INSERT INTO dwrl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Biiniyaama Giidi'oona na'aa Abidaana, ");
INSERT INTO dwrl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Daanappe Amishadaaya na'aa Ahi'eezera, ");
INSERT INTO dwrl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aaseera Okiraana na'aa Paagi'eela, ");
INSERT INTO dwrl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gaada Da'u'eela na'aa Eliyasaafa, ");
INSERT INTO dwrl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nifttaaleema Enaana na'aa Ahiraa'a; ");
INSERT INTO dwrl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ha asatuu barenttu aawotuwaa golliyaa asatuwaappe kaaletsanaw dooretteeddawantta; unttunttu Israa'eeliyaa yaratoo kaappatuwaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musenne Aarooni suntsay s'eesetteedda ha asatuwaa afeedino. ");
INSERT INTO dwrl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Laa\"entsa aginaan koyiro gallassi kumentsaa maabaraa s'eesiide, ittippe shiishsheeddino. Asay bare yaran yaraaninne bare golliyaan golliyaan odiide, yelettoodeppe laatamu laytsanne hewaappe bollana de'iyaa attuma asatuwaa ubbaa suntsay ubbaanna s'aafetteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Med'inaa Goday Aa azazeeddawaadan, Muse unttuntta Siinaa mela biittaan paydeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","Olaw baanaw danddayiyaa attuma asatuu ubbay, laatamu laytsanne hewaappe bollana de'iyaawanttu paydetiide, huup'iyaan huup'iyaan s'aafetteeddino. Unttunttu barenttu yaran yaraaninne barenttu golliyaan golliyaan shaakettiide, hawaappe kaalliide de'iyaa payduwaan mazggobetteeddino. Zariyaa Olanchchatuwaa Payduwaa; Roobeela (Israa'eeliyaa na'aa bayiraa) 46,500; ");
INSERT INTO dwrl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","Simoona 59,300; ");
INSERT INTO dwrl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","Gaada 45,650; ");
INSERT INTO dwrl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","Yihudaa 74,600; ");
INSERT INTO dwrl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","Yisaakoora 54,400; ");
INSERT INTO dwrl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","Zaabiloona 57,400; ");
INSERT INTO dwrl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","Yooseefo na'aa Efireema 40,500; ");
INSERT INTO dwrl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","Yooseefo na'aa Minaasa 32,200; ");
INSERT INTO dwrl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","Biiniyaama 35,400; ");
INSERT INTO dwrl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","Daana 62,700; ");
INSERT INTO dwrl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","Aaseera 41,500; ");
INSERT INTO dwrl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","Nifttaaleema 53,400; ");
INSERT INTO dwrl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Muse, Aarooninne tammanne laa\"u Israa'eeliyaa zaratuu kaappatuu paydeedda Asay hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Olaw baanaw danddayiyaa attuma asatuu ubbay laatamu laytsanne hewaappe bollana de'iyaawanttu barenttu aawuwaa golliyaan golliyaan paydeteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Hewanttu ubbaanna 603,550. ");
INSERT INTO dwrl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Shin Leewiyaa zaratuu ha paydeteedda asaana paydettibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ayaw gooppe, Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Leewiyaa zaratuwaa paydoppa; unttuntta atteeda Israa'eelatuwaa payduwaan yeggoppa. ");
INSERT INTO dwrl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Leewatuwaa S'oossaa Dunkkaaniyaa bollaninne Aa giddon de'iyaa miishshatuwaa ubbaa bollan kaappuwaa ootsaade suntsaa. Unttunttu he Dunkkaaniyaanne Aa giddon de'iyaa miishshata tookkino; unttunttu Aa giddon ootsinonne Aa yuushshuwaan dunkkaanino. ");
INSERT INTO dwrl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","S'oossaa Dunkkaanii shodettiyaa wode Leewatuu shoddino; S'oossaa Dunkkaanii ek'k'iyaa wodekka Leewatuu essino. Unttunttuppe haray ooninne aakko shiik'ooppe, hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israa'eeliyaa asatuu ubbay barenttu armman armmaaninne barenttu c'itan c'itan shaakettiide, barenttu dunkkaaniyaa dunkkaanino. ");
INSERT INTO dwrl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Shin S'oossaa hank'k'uu Israa'eeliyaa maabaraa bolla wod'd'enna mala, Leewatuu S'oossaa Markkatetsaa Dunkkaaniyaa yuushshuwaan barenttu dunkkaaniyaa dunkkaanino; Leewatuu S'oossaa Dunkkaaniyaan aawotino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israa'eelatuu hawaa ubbaa Med'inaa Goday Musa azazeeddawaadan ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Med'inaa Goday Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Israa'eeliyaa Asay barenttu bagga bagga erissiyaa armmaanne barenttu yaraa yaraa erissiyaa banddiraa kaalliide, S'oossaa Dunkkaaniyaappe guutsaa haakkiide, Aa yuushshuwaan dunkkaanino. ");
INSERT INTO dwrl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","4","«Away doliyaa baggana Yihudaa baggay barenttu armmaa kaalliide dunkkaanino. Unttunttu zaratuwaa suntsay, zaratuwaa kaappatuwaa suntsaynne olanchchatuwaa paydu hawaappe kaallee: Yihudaa Aminaadaaba na'aa Na'asoona 74,600; ");
INSERT INTO dwrl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","6","Yisaakoora S'u'aara na'aa Nataani'eela 54,400; ");
INSERT INTO dwrl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","8","Zaabiloona Heloona na'aa Eli'aaba 57,400; ");
INSERT INTO dwrl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Yihudaa baggaappe paydeteedda olanchchatuu ubbaanna 186,400. Hara sa'aa biyaa wode unttunttu koyiro kesiyaawantta. ");
INSERT INTO dwrl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","11","«K'ay dugehaa baggana Roobeela baggay barenttu armmaa kaalliide dunkkaanino. Unttunttu zaratuu suntsay, zaratuwaa kaappatuwaa suntsaynne olanchchatuwaa paydu hawaappe kaallee: Roobeela Shade'uura na'aa Eliis'uura 46,500; ");
INSERT INTO dwrl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","13","Simoona S'uriishadaaya na'aa Shalumi'eela 59,300; ");
INSERT INTO dwrl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","15","Gaada Re'u'eela na'aa Eliyasaafa 45,650. ");
INSERT INTO dwrl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Roobeela baggaappe paydeteedda olanchchatuu ubbaanna 151,450. Hara sa'aa biyaa wode unttunttu laa\"entso kesiyaawantta. ");
INSERT INTO dwrl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","«Hewaappe guyyiyaan, S'oossaa Dunkkaaniinne Leewiyaa zaratuu koyiro kesiidde laa\"u baggaappenne guyyeppe kesiyaa laa\"u baggaappe gidduwaan kesino; yaatiide barenttu dunkkaaneedda maaran maaraaninne barenttu banddiraa banddiraa kaalliide kesino. ");
INSERT INTO dwrl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","19","«K'ay away wulliyaa baggana Efireema baggay barenttu armmaa kaalliide dunkkaanino. Unttunttu zaratuwaa suntsay, zaratuwaa kaappatuwaa suntsaynne olanchchatuwaa paydu hawaappe kaallee: Efireema Amihuuda na'aa Elishamaa'a 40,500; ");
INSERT INTO dwrl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","21","Minaasa Padaas'uura na'aa Gamaali'eela 32,200; ");
INSERT INTO dwrl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","23","Biiniyaama Giidi'oona na'aa Abidaana 35,400; ");
INSERT INTO dwrl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Efireema baggaappe paydeteedda olanchchatuu ubbaanna 108,100. Hara sa'aa biyaa wode, unttunttu heezzentso kesiyaawantta. ");
INSERT INTO dwrl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","26","«K'aykka huup'issa baggana Daana baggay barenttu armmaa kaalliide dunkkaanino. Unttunttu zaratuwaa suntsay, zaratuwaa kaappatuwaa suntsaynne olanchchatuwaa paydu hawaappe kaallee: Daana Amishadaaya na'aa Ahi'eezera 62,700; ");
INSERT INTO dwrl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","28","Aaseera Okiraana na'aa Paagi'eela 41,500; ");
INSERT INTO dwrl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","30","Nifttaaleema Enaana na'aa Ahiraa'a 53,400; ");
INSERT INTO dwrl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Daana baggaappe paydeteedda olanchchatuu ubbaanna 157,600. Hara sa'aa biyaa wode unttunttu wurssetsan bare banddiran kesiyaawantta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Bare yaran yaran shaakettiide paydeteedda Israa'eeliyaa olanchchatuu ubbaanna 603,550. ");
INSERT INTO dwrl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Shin Med'inaa Goday Musa azazeeddawaadan, Leewatuu hara Israa'eelatuwaana paydettibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israa'eelatuu Med'inaa Goday Musa azazeeddawaa ubbabaa ootseeddino. Simmi unttunttu barenttu banddiraa kaalliide, hewaadan dunkkaaneeddino; k'ay barenttu yaraa yaraanne barenttu soo asaa asaa kaalliide, hewaadan keseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Med'inaa Goday Siinaa Deriyaa bollan Musena haasayeedda wode de'iyaa Aaroonanne Muse golliyaa Asay hawaappe kaalliide s'aafetteeddawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaroona attuma naanatuwaa suntsay bayiray Nadaaba, Abiiha, El\"aazaranne Itaamaara. ");
INSERT INTO dwrl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","He Aaroona attuma naanay ubbay k'eese gidiide ootsanaw okettiide suntsetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Shin unttunttu giddoppe Naadaabinne Abihu Siinaa mela biittaan S'oossay azazibeena tamaa yarshshiide, Med'inaa Godaa sintsan hayk'k'eeddino; unttunttoo na'i baawa. Hewaa diraw, unttunttu aawuu Aarooni pas'a de'eedda laytsaa ubbaan El\"aazaranne Itaamaara s'alalay k'eese gidiide ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Leewatuwaa haa akka yaade k'eesiyaa Aaroona maaddana mala, unttuntta Aa sintsa shiishsha. ");
INSERT INTO dwrl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Unttunttu Aaroonawunne Israa'eeliyaa maabaraw ubbaw S'oossaa Dunkkaaniyaa sintsan dumma dumma oosuwaa ootsino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Unttunttu S'oossaa Dunkkaaniyaan de'iyaa miishshaa ubbaa aawotetsaa akkino; Israa'eeliyaa asaa diraw S'oossaa Dunkkaaniyaan ooso ubbaa unttunttu ootsino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Neeni Leewatuwaa Aaroonanne Aa attuma naanatuwaa maaddanaadan suntsaa; unttunttu Israa'eeliyaa giddoppe ubbaanna Aaroonaw imetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaroonanne Aa attuma naanatuwaa k'eese ootsaade suntsaa. Unttunttuppe hara Asay ooninne S'oossaa Dunkkaaniyaakko shiik'ooppe, hayk'k'o» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","K'ay Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Taani Israa'eelatuwaa mac'c'a Asay bayira yeliyaa attuma naanatuwaa ubbaa diraw Israa'eelatuwaa giddoppe Leewatuwaa akkaad. Leewatuu tawaa; ");
INSERT INTO dwrl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ayaw gooppe, bayira yeletteedda ubbay tawaa. Taani Gibs'e gadiyaan bayira yeletteeddawaa ubbaa wod'eedda gallassan, Israa'eelatuwaan bayira yeletteeddawaa ubbaa, asaa gidina, mehiyaa gidina, taw dummayaad; unttunttu tawaa gidana. Taani Med'inaa Godaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","K'aykka Med'inaa Goday Musa Siinaa mela biittaan, ");
INSERT INTO dwrl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Neeni Leewatuwaa unttunttu soo asan asaaninne unttunttu yaran yaran payda; yelettoodeppe itti aginanne hewaappe bollana de'iyaa attumawantta ubbaa payda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Med'inaa Goday azazeeddawaadan, Muse unttuntta paydeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Leewiyaa attuma naanay Gershshoona, K'ahaatanne Maraara. ");
INSERT INTO dwrl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gershshoona attuma naanay Liibinanne Shim\"a. ");
INSERT INTO dwrl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","K'ahaata attuma naanay Amiraama, Yis'ihaara, Kebroonanne Uuzi'eela. ");
INSERT INTO dwrl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Maraara attuma naanay k'ay Maahilanne Musha. Leewatuwaa mayzza aawotuu hawantta. ");
INSERT INTO dwrl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Liibina yaratuunne Shim\"a yaratuu Gershshoona zaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Unttunttuppe paydina, yelettoodeppe itti aginanne hewaappe bollana de'iyaa attumawanttu ubbaanna 7,500. ");
INSERT INTO dwrl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gershshoona yaratuu S'oossaa Dunkkaaniyaappe guyye away wulliyaa baggana dunkkaaniino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gershshoona yaratuwaa soo asaa kaappuu Laa'eela na'aa Eliyasaafa. ");
INSERT INTO dwrl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gershshoona yaratuu S'oossaa Dunkkaaniyaa, Dunkkaaniyaa kammiyaawantta geliyaasaa gaaridduwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","dabaabaa gaariddotuwaa, S'oossaa Dunkkaaniyaanne yarshshiyaa sa'aa yuushshuwaan de'iyaa dabaabaa geliyaasan gaaridduwaa, wodorotuwaanne unttunttu go\"aanna gaketiyaabatuwaa ubbabaa aawotetsaa akkiino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amiraama yaratuu, Yis'ihaara yaratuu, Kebroona yaratuunne Uuzi'eela yaratuu K'ahaata zaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Yelettoodeppe itti aginanne hewaappe bollana de'iyaa attumawanttu ubbaanna 8,600. K'ahaata yaratuu S'oossaa Dunkkaaniyaa aawotetsaa akkiino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","K'ahaata yaratuu S'oossaa Dunkkaaniyaappe gedissa baggana dunkkaaniino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","K'ahaata yaratuwaa soo asaa kaappuu Uuzi'eela na'aa Els's'aafaana. ");
INSERT INTO dwrl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Unttunttu Taabootaa, s'arap'p'eezaa, s'omppiyaa wotsiyaa ballaa, yarshshiyaa sa'aa, ootsiyaa wode go'ettiyaa S'oossaa Dunkkaaniyaa miishshatuwaa, gaaridduwaanne unttunttu go\"aanna gaketiyaabatuwaa ubbabaa aawotetsaa akkiino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Leewatuwaa kaappatuwaa kaappuu k'eesiyaa Aaroona na'aa El\"aazara; Geeshsha Sa'aa aawotiyaawanttu bolla I suntsetteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Maahila yaratuunne Musha yaratuu Maraara zaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Unttunttuppe paydina, yelettoodeppe itti aginanne hewaappe bollana de'iyaa attumawanttu ubbaanna 6,200. ");
INSERT INTO dwrl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Maraara yaratuwaa soo asaa kaappuu Abihayila na'aa S'urii'eela. Maraara yaratuu S'oossaa Dunkkaaniyaappe huup'issa baggana dunkkaaniino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Maraara yaratuu Dunkkaaniyaa s'agaagetuwaa, kulbbotuwaa, tuussatuwaa, gedetuwaa, he oosoo koshshiyaa miishshatuwaa ubbaanne unttunttu go\"aanna gaketiyaabatuwaa ubbaa aawotetsaa akkiino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Hewaa bollakka gujjiide, yuushshuwaan de'iyaa dabaabaa tuussatuwaanne unttunttu gedetuwaa, shikaaliyaanne wodorotuwaa aawotetsaa akkiino. ");
INSERT INTO dwrl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","K'ay S'oossaa Dunkkaaniyaappe sintsa away doliyaa baggana Muse, Aarooninne Aa attuma naanay dunkkaaniino. Unttunttu Israa'eelatuwaa diraw S'oossaa Dunkkaane giddon ootsiyaa oosuwaa aawotetsaa akkiino. Hara Asay S'oossaa Dunkkaaniyaakko shiik'ooppe, hayk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Med'inaa Goday azazina, Musenne Aarooni paydeedda attuma Leewatuu, yelettoodeppe itti aginanne hewaappe bollana de'iyaa attumawanttu ubbaanna 22,000. ");
INSERT INTO dwrl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Med'inaa Goday Musa, «Israa'eelatuwaa bayira attuma naanatuwaa, yelettoodeppe itti aginanne hewaappe bollana de'iyaawantta ubbaa paydaade unttunttu suntsaa s'aafa. ");
INSERT INTO dwrl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Israa'eelatuwaan bayira yeletteedda ubbaa kotaw Leewatuwaa taw akka; k'ay Israa'eelatuwaa mehiyaan bayira yeletteedda ubbaa kotaw Leewatuwaa mehiyaa taw akka. Taani Med'inaa Godaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Muse Med'inaa Goday Aa azazeeddawaadan, Israa'eelatuwaan bayira yeletteedda ubbaa paydeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Yelettoodeppe itti aginanne hewaappe bollana de'iyaa bayira yeletteedda attumawanttu, suntsaykka s'aafetteeddawanttu ubbaanna 22,273. ");
INSERT INTO dwrl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Med'inaa Goday Musa k'aykka hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Leewatuwaa Israa'eeliyaa attumawanttu ubbaa kotaw akka; Leewatuwaa mehetuwaa Israa'eelatuwaa mehiyaa kotaw akka; Leewatuu tawaa gidanawantta. Taani Med'inaa Godaa. ");
INSERT INTO dwrl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Leewatuwaa payduwaappe dariyaa 273 bayira gidiide yeletteedda Israa'eeliyaa attuma naanatuwaa wozanaw, ");
INSERT INTO dwrl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ittoo ittoo ichcheshu s'agaraa biraa S'oossaa Dunkkaaniyaan erettiyaa miizaaniyaa likkiyaan akka; Itti S'agaraa Biray Laatamu Geera keeshshaa. ");
INSERT INTO dwrl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Palaheedda Israa'eelatuwaa woziyaa he miishshaa Aaroonawunne Aa attuma naanaw imma» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Muse, Leewatuwaan wozetteeddawanttuppe palaheeddawantta woziyaa miishshaa shiishsheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Bayira yeletteedda Israa'eelatuwaappe 1,365 s'agaraa biraa S'oossaa Dunkkaaniyaan erettiyaa miizaaniyaa likkiyaan I shiishsheedda; ");
INSERT INTO dwrl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Med'inaa Goday azazeedda azazuwaadan, Muse woziyaa miishshaa Aaroonawunne Aa attuma naanaw immeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Med'inaa Goday Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Leewiyaa zaratuwaan K'ahaata yaratuwaa unttunttu dabbuwaan dabbuwaaninne unttunttu soo asan asan shaakkaade payda; ");
INSERT INTO dwrl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","yelettoodeppe laytsay hattamuwaappe biide ishatamuwaa gakkeedda attuma asaa ubbaa, S'oossaa Dunkkaaniyaa giddon ootsanaw yiyaawantta payda. ");
INSERT INTO dwrl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","K'ahaata yaratuu S'oossaa Dunkkaaniyaa giddon ootsana oosuu hawaa: unttunttu ubbaappe aad'd'eeda geeshsha miishshatuwaan aawotiino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","«Asay dunkkaaneedda saappe baanaw haniyaa wode, Aarooninne Aa attuma naanay S'oossaa Dunkkaaniyaa giddo geliide, Taabootaa sintsa gaaridduwaa kak'uwaappe wotsino; he C'aak'uwaa Taabootaa aan kammino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","He kammeeddawaa bollakka wod'iyaa irbbaaniyaa kammino; hewaa bollakka k'ay gujjiide, saluwaa malatiyaa c'ark'k'iyaa kammino; tookkiyaa kasotuwaa unttunttu sagaayetuwaan aatsino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«S'oossaa sintsa shiishshiyaa ukitsaa wotsiyaa s'arap'p'eezaa bollan saluwaa malatiyaa c'ark'k'iyaa hiis's'ino; Aa bolla saanetuwaa, c'ilppatuwaa, s'uu'atuwaanne ushshaa yarshshoo go'ettiyaa ototuwaa wotsino; k'ay ukitsay ubbaa wodekka Aa bollappe d'ayoppo. ");
INSERT INTO dwrl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Hewaa bollan zo'o c'ark'k'iyaa hiis's'iide, irbbaniyaa k'ay Aa bolla kammino; tookkiyaa kasotuwaa sagaayetuwaan aatsino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«Unttunttu saluwaa malatiyaa c'ark'k'iyaa akkiide, s'omppiyaa wotsiyaa ballatuwaa s'omppetuwaanna, toyissiyaa k'ap'etuwaana, unttuntta wotsiyaabatuwaananne zayitiyaa tigiyaa s'aarotuwaanakka ubbaa kammino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Yaatiide aakka miishshatuwaa ubbaakka irbbaniyan kammiide, tookkiyaa shanchchamaa bollan wotsino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«Is'aanaa c'uwissiyaa work'k'aa saas'iniyaa bollan saluwaa malatiyaa c'ark'k'iyaa hiis's'eeddawaa k'ay irbbaniyan kammino; tookkiyaa kasotuwaa unttunttu sagaayetuwaan aatsino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Hewaadankka, k'ay S'oossaa Dunkkaaniyaa giddon go'ettiyaa miishshatuwaa ubbaa akkiide, saluwaa malatiyaa c'ark'k'iyaan s'aas'ino; irbbaniyan kammiide, tookkiyaa shanchchamaa bollan wotsino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","«Yaatiide nahaasiyaappe ootseedda yarshshiyaa sa'aa bolla de'iyaa bidintsaa diggiide Aa bolla ochchaa teeraa malatiyaa c'ark'k'iyaa hiis's'ino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Aa bolla yarshshiyaasan go'ettiyaa miishshatuwaa ubbaa, tamaa c'ooc'etuwaa, ashuwaa k'ap'iyaa k'ap'etuwaa, akaafatuwaanne kaashiyaa kuyis'aarotuwaa wotsino. Irbbaniyan kammino; tookkiyaa kasotuwaa unttunttu sagaayetuwaan aatsino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«Aarooninne Aa attuma naanay, geeshshabatuwaanne geeshsha miishshatuwaa ubbaa kammiide makkooppenne dunkkaaneedda sa'aappe denddiyaa wodii gakkooppe, hewaa ubbaa tookkanaw K'ahaata yaratuu yiino. Shin geeshsha miishshatuwaa unttunttu bochchooppe hayk'k'ino. S'oossaa Dunkkaaniyaa giddon de'iyaa he miishshaa K'ahaata yaratuu tookkino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«K'eesiyaa Aaroona na'ay El\"aazari s'omppiyaa zayitiyaw, sawiyaa is'aanaw, hachchi hachchi yarshshiyaa katsaa yarshshuwaanne okkiyaa zayitiyaw, k'ay S'oossaa Dunkkaaniyaa muliyaanne Aa giddon de'iyaa dumma geeshsha miishshatuwaa ubbaa bolla aawoto» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","K'ay Med'inaa Goday Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«K'ahaata yaratuu Leewiyaa zaratuwaappe hayk'k'iide d'ayenna mala s'eellite. ");
INSERT INTO dwrl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ubbaappe aad'd'eedda geeshsha miishshaa mata shiik'iyaa wode, unttunttu hayk'k'ennan pas'a attiide de'ana mala, unttunttoo hawaadan ootsite: Aarooninne Aa attuma naanay S'oossaa Dunkkaaniyaa giddo geliide K'ahaata yaratuu ubbay huup'iyaan huup'iyaan ootsana oosuwaanne tookkana tookuwaa shaakki shaakkiide gishino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","K'ahaata yaratuu hayk'k'ennaadan, ubbaappe aad'd'iyaa geeshshatuwaa k'eesatuu s'aas'ishin be'anaw gidduwaa geloppino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Gershshoona yaratuwaakka unttunttu dabbuwaan dabbuwaaninne unttunttu soo asan asan shaakkaade payda; ");
INSERT INTO dwrl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","yelettoodeppe laytsay hattamuwaappe biide ishatamuwaa gakkeedda attuma asaa ubbaa, S'oossaa Dunkkaaniyaa giddon ootsanaw yiyaawantta payda. ");
INSERT INTO dwrl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","«Gershshoona yaratuu ootsiyaa oosuunne tookkiyaa tookku hawaa: ");
INSERT INTO dwrl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","unttunttu S'oossaa Dunkkaaniyaa gaariddotuwaa, S'oossaa Dunkkaaniyaa, Aa kammiyaabatuwaanne bollana kammiyaa irbbaniyaa, S'oossaa Dunkkaaniyaa geliyaasan sottiyaa gaaridduwaa tookkino; ");
INSERT INTO dwrl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","k'ay S'oossaa Dunkkaaniyaanne yarshshiyaa sa'aa yuuyyi aad'd'eeda dabaabaa gaariddotuwaa, dabaabaa geliyaasaa gaaridduwaa, wodorotuwaanne unttunttoo go\"iya miishshatuwaa ubbaa tookkino. Gershshoona yaratuu ha miishshatuwaan ootsanaw bessiyaa oosuwaa ubbaa ootsino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tookkiyaawaa gidina, hara oosuwaa gidinakka unttunttu ootsiyaa oosuwaa ubbay Aarooninne Aa attuma naanay unttuntta azazina oosettino. Neeni unttunttu tookkanaw bessiyaabatuwaa ubbaa unttunttu aawotetsaa aawotetsaadan unttunttoo gisha. ");
INSERT INTO dwrl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","S'oossaa Dunkkaaniyaa giddon Gershshoona yaratuu ootsana oosuu ubbay hawaa. Unttunttu ootsana oosuwaa ubbay k'eesiyaa Aaroona na'aa Itaamaara aawotetsaa garssaana gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Maraara yaratuwaa unttunttu dabbuwaan dabbuwaaninne unttunttu soo asan asan shaakkaade payda; ");
INSERT INTO dwrl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","yelettoodeppe laytsay hattamuwaappe biide ishatamuwaa gakkeedda attuma asaa ubbaa, S'oossaa Dunkkaaniyaa giddon ootsanaw yiyaawantta payda. ");
INSERT INTO dwrl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","«Unttunttu S'oossaa Dunkkaaniyaa giddon ootsana oosotuu hawantta: unttuntta Dunkkaaniyaa s'agaagetuwaa, kulbbotuwaa, tuussatuwaanne gedetuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","k'aykka dabaabaa yuushshuwaan ek'k'iyaa tuussatuwaa, he tuussatuu gedetuwaa, toliyaa s'agaagetuwaa, wodorotuwaa, hewanttoo koshshiyaa miishshatuwaa ubbaanne he miishshatuwaanna gaketiyaabatuwaa ubbaa tookkino. Itti itti uraw I tookkanawaa shaakkaade gisha. ");
INSERT INTO dwrl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","S'oossaa Dunkkaaniyaa giddon Maraara yaratuu ootsana oosuu ubbaanna hawaa. Unttunttu ootsana ooso ubbay k'eesiyaa Aaroona na'aa Itaamaara aawotetsaa garssaana gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Muse Aarooninne maabaraa kaappatuu K'ahaata yaratuwaa attuma asaa unttunttu dabbuwaan dabbuwaaninne unttunttu soo asan asan shaakkiide paydeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Yelettoodeppe laytsay hattamuwaappe biide ishatamuwaa gakkeedda attuma asatuu ubbatuu, S'oossaa Dunkkaaniyaa giddon ootsanaw yiyaawanttu, ");
INSERT INTO dwrl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","unttunttu soo asan asan paydina ubbaanna 2,750. ");
INSERT INTO dwrl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","K'ahaata yaratuwaan S'oossaa Dunkkaaniyaa giddon ootseedda asaa paydu hawaa. Med'inaa Goday Muse baggana azazeeddawaadan, Musenne Aarooni unttuntta paydeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gershshoona yaratuukka barenttu dabbuwaan dabbuwaaninne barenttu soo asan asan shaakettiide paydeteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Yelettoodeppe laytsay hattamuwaappe biide ishatamuwaa gakkeedda attuma asatuu ubbatuu, S'oossaa Dunkkaaniyaa giddon ootsanaw yiyaawanttu, ");
INSERT INTO dwrl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","unttunttu soo asan asan paydina ubbay 2,630. ");
INSERT INTO dwrl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Gershshoona yaratuwaan S'oossaa Dunkkaaniyaa giddon ootseedda asaa paydina hawaa. Med'inaa Goday Muse baggana azazeeddawaadan, Musenne Aarooni unttuntta paydeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Maraara yaratuukka k'ay dabbuwaan dabbuwaaninne barenttu soo asan asan shaakettiide paydeteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Yelettoodeppe laytsay hattamuwaappe biide ishatamuwaa gakkeedda attuma asatuu ubbatuu, S'oossaa Dunkkaaniyaa giddon ootsanaw yiyaawanttu, ");
INSERT INTO dwrl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","unttunttu soo asan asan paydina ubbay 3,200. ");
INSERT INTO dwrl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Maraara yaratuwaa paydu hawaa. Med'inaa Goday Muse baggana azazeeddawaadan, Musenne Aarooni unttuntta paydeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Hewaa ootsiide Muse, Aarooninne Israa'eeliyaa kaappatuu Leewatuwaa ubbaa, unttunttu yaran yaraaninne unttunttu soo asan asan shaakkiide paydeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Yelettoodeppe laytsay hattamuwaappe biide ishatamuwaa gakkeedda attuma asatuu ubbatuu, S'oossaa Dunkkaaniyaa giddon oosuwaa ootsanawunne aw go\"iya miishshatuwaa ubbaa tookkanaw yeeddawanttu ");
INSERT INTO dwrl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ubbay 8,580. ");
INSERT INTO dwrl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Med'inaa Goday Muse baggana azazeeddawaadan, unttunttu huup'iyaan huup'iyaan ootsana oosuu woy tookkana tookuukka unttunttoo odetteedda. Med'inaa Goday Musa azazeeddawaadan, unttunttu ubbaykka paydeteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Med'inaa Goday Musa hawaadan yaageedda: ");
INSERT INTO dwrl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Neeni Israa'eelatuwaa, ‹Hintte giddon wolk'k'aama galbbaa harggii oyk'k'eedda uraa, woy bollaappe ayayneekka goggiyaa uraa, woy anhaa oyk'k'iide tuneedda uraa oonakka hintte dunkkaaneedda sa'aappe kessi diggite› yaagaade azaza. ");
INSERT INTO dwrl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Hewe mac'c'awaa attumawaa gidinakka kessino. Taani unttunttu gidduwaan de'iyaa unttunttu dunkkaaneeddasaa hewanttu tunissenna mala, unttunttu dunkkaaneedda sa'aappe kessa yedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Med'inaa Goday Musa azazeeddawaadan, Israa'eelatuu unttunttu ubbaa dunkkaaneedda sa'aappe kessiide yeddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Hewaappe guyyiyaan, Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Neeni Israa'eelatuwaa hawaadan yaaga; ‹Itti attuma Asay woy itti mac'c'a Asay ay ogiyaaninne hara asaa naak'k'ooppenne hewan Med'inaa Godaw ammanettennan is's'ooppe, he uray bayzzanchcha. ");
INSERT INTO dwrl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Hewaa diraw, I bare ootseedda nagaraa paas'o; bare bayzzeeddawaa kumentsaa zaariide c'iggo; hewaa bollakka ichcheshentso kushiyaa gujjiide, bare naak'k'eedda uraw ac'c'o. ");
INSERT INTO dwrl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Shin he naak'etteedda uray hayk'k'eeddawaa gidooppenne, ac'c'aa akkanaw aw mata dabbuu d'ayooppe, he ac'c'ay Med'inaa Godaassa. He ac'c'iyaa ac'c'ay naak'k'eedda uray maarettanaw yarshshoo immiyaa dorssaa orggiyaana ittippe k'eesiyaw imetto. ");
INSERT INTO dwrl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","K'ay Israa'eelatuu k'eesiyaw immiyaa geeshsha imuwaa ubbay he k'eesiyaassa. ");
INSERT INTO dwrl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Itti itti Asay immiyaa imotay he immeedda uraabaa; shin k'eesiyaw I immiyaa imotay he k'eesiyaassa› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Hewaappe guyyiyaan Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Neeni Israa'eelatoo hawaadan yaagaade oda; ‹Itti uraa machchata kare hamettaade, aw ammanettennan is's'aade, ");
INSERT INTO dwrl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","hara attuma asaana gisooppe, k'ay hewaa iza bare asinaappe k'osooppe, markkay baynnawaa gidooppenne, iza sharmus'aade oyk'k'ettennan attooppe, ");
INSERT INTO dwrl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Iza tuneedda diraw, I golliyaw izo sid'iyaawaa gidanaw danddayee; woy iza tunennan de'ishshin, I bare machchato sid'iyaawaa gidanaw danddayee. ");
INSERT INTO dwrl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Yaatooppe, he bitanii bare machchato k'eesiyaakko afo; k'ay izi diraw yarshshanaw itti kiilo giraame banggaa d'iiliyaa afo. Shin d'iiliyaa bolla zayitiyaa tigoppo, woy is'aanaa Aa bolla wotsoppo; ayaw gooppe, he d'iilii I bare machchato sid'eedda diraw yarshshiyaa katsaa yarshsho; k'ay hewe bayzzuwaa k'onc'c'issiyaa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","« ‹Hewaappe guyyiyaan, k'eesii he mishirato shiishiide, Med'inaa Godaa sintsan esso. ");
INSERT INTO dwrl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Anjjetteeda haatsaa kuyis'aaruwaan akko. Hewaappe guyyiyaan, S'oossaa Dunkkaaniyaa wuyggiyaan de'iyaa baanaa akkiide, he haatsaan gujjo. ");
INSERT INTO dwrl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","He mishiratto Med'inaa Godaa sintsan esso; hewaappe guyyiyaan, he mishiratti huup'iyaa billo; sid'eedda diraw yarshshiyaa izi bayzzuwaa k'onc'c'issiyaa katsaa yarshshuwaa izi kushiyan wotso; k'ay he k'eesii bare kushiyan shek'k'aa ahiyaa c'amo haatsaa kuyis'aaruwaanna oyk'k'o. ");
INSERT INTO dwrl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Mishirato hawaadan yaagiide c'aak'k'etso; «Neeni hara attuma asaana gisabeennawaa gidooppenne, ne asinaa aggaade kare hamettaade tunabeennawaa gidooppe, shek'k'aa ahiyaa ha c'amo haatsay new gometoppo. ");
INSERT INTO dwrl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Shin neeni ne asinaa aggaade kare hamettaade tuneeddawaa gidooppenne, hara attuma asaana giseeddawaa gidooppe, ");
INSERT INTO dwrl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Med'inaa Goday ne yeluwaa golliyaa gunddissiyaawaaninne ne uluwaakka gaafisiyaawan, ne asan neena shek'iso. ");
INSERT INTO dwrl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ha shek'k'aa ahiyaa haatsay ne ulo giddo geliide ne uluwaa gaafiso; ne yeluwaa keetsaakka gunddisso» yaagiide c'aak'k'etso. « ‹Mishiratakka, «Amen\"i; amen\"i» yaagu. ");
INSERT INTO dwrl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","« ‹Hewaappe guyyiyaan, k'eesii ha shek'atuwaa s'aas'etteedda mas'aafan s'aafo; shek'atuwaa c'amo haatsaa giddo meec'c'o. ");
INSERT INTO dwrl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Yaatiide shek'k'aa ahiyaa he c'amo haatsaa mishirato ushsho; shek'k'aa ahiyaa haatsay mishiratti uluwaan geliide, izo c'amo sakuwaa sakkana. ");
INSERT INTO dwrl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","K'eesii mishiratti kushiyaappe sid'eedda diraw yarshshiyaa katsaa yarshshuwaa akkiide, he yarshshuwaa Med'inaa Godaa sintsan k'aatsiide, yarshshiyaa sa'aa aho. ");
INSERT INTO dwrl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","K'eesii katsaa yarshshuwaappe kop'p'iyaawaa akkiide bayzzanchcha gidekkentto k'onc'c'issiyaa yarshshuwaa ootsiide, yarshshiyaasan s'uuggo. Hewaappe guyyiyaan, mishirato he haatsaa ushsho. ");
INSERT INTO dwrl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Haatsaa izo ushsheeddawaappe guyyiyaan, hawaadan hanana: iza bare asinaw ammanettana d'ayaade tuneeddawaa gidooppe, shek'k'aa ahiyaa haatsay I uluwaan geliide, izo c'amo sakuwaa sakkana; izi uluukka gaafana; izi yeluwaa golliikka gunddana. Iza bare asan shek'k'etteedaano gidana. ");
INSERT INTO dwrl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Shin iza tunabeenna s'illo mac'c'a asaa gidooppe, Aa saro ataade naanatuwaa yelana. ");
INSERT INTO dwrl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","« ‹Itti Asay bare machchato sid'iyaa wode ootsana wogay hawaa. Iza kare hamettaade tunooppe, woy itti Asay bare machchato sid'ooppe, Med'inaa Godaa sintsan izo essiide k'eesii ha wogaa ubbaa izi bolla polo. ");
INSERT INTO dwrl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Asinay bayzzuwaa ubbaappe saro attana; shin mac'c'awunno bare nagaraa gaasuwaan yiyaawaa tookkana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Med'inaa Goday Musa hawaadan yaageedda, ");
INSERT INTO dwrl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Neeni Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Attuma Asay woy mac'c'a Asay Naaziraawe gidiide, barena Med'inaa Godaw dummayanaw geppooppe, ");
INSERT INTO dwrl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","woyniyaa eessaanne hara matsoyiyaa ushshaa ushoppo; woyniyaa ayifiyaappe agettiya c'aalabaanne matsoyiyaabaa ushoppo; woyniyaa teeraa gum\"eeddawaa ushoppo. Woy woyniyaa teeraa shuguwaa gidina, mela gidinakka mooppo; ");
INSERT INTO dwrl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","I barena dummayeedda wodiyaan ubbaan, woyniyaa turaappe beettiyaawaa ubbaa, woyniyaa zeretsaa gidina, woy woyniyaa pok'uwaa gidinakka mooppo. ");
INSERT INTO dwrl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","« ‹I barena Med'inaa Godaw dummayanaw geppeedda wodiyaan ubbaan, Aa huup'ii meedettoppo woy k'ans's'ettoppo. I bare huup'iyaa binnaanaakka adussiide dichcho. I barena Med'inaa Godaw dummayeedda wodii polettana gakkanaw, geeshsha gidanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","« ‹I barena Med'inaa Godaw dummayeedda wodiyaan ubbaan anhaakko shiik'oppo. ");
INSERT INTO dwrl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Haray attina Aa aawuu, woy Aa daaya, woy Aa ishay, woy Aa michchata hayk'k'ooppekka, I barena tunissoppo. Ayaw gooppe, I barena S'oossaw dummayeeddawaa erissiyaawe bare huup'iyaana. ");
INSERT INTO dwrl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","I barena S'oossaw dummayeedda wodiyaan ubbaan I Med'inaa Godaw geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","« ‹Asay Aa matan akeekenan hayk'k'ina, S'oossaw dummayeedda Aa huup'ii tunooppe, laappun gallassaa gam\"iide, bare geeyiyaa he laappuntsa gallassi bare huup'iyaa meedetto. ");
INSERT INTO dwrl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Hosppuntsa gallassan laa\"u harap'p'etuwaa woy laa\"u mara harap'p'etuwaa S'oossaa Dunkkaaniyaa pengge K'eesiyaw aho. ");
INSERT INTO dwrl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","K'eesii harap'p'etuwaappe ittuwaa nagaraa yarshshoo, ittuwaa k'ay s'uuggiyaa yarshshoo yarshsho. Ayaw gooppe, anhay Aa mata shiik'eedda bayzzuwaa diraw, aw atto giissanaassa. He gallassi I bare huup'iyaa wogaadan geeshsho; ");
INSERT INTO dwrl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","I barena kase geppeedda wodiyaa keenaa barena S'oossaw dummayanaw koshshee. Yaatiide yelettoodeppe itti laytsaa gidiyaa attuma dorssaa naak'oo immiyaa yarshshuwaa ootsiide yarshsho. Shin hewaappe kase I barena S'oossaw dummayeedda gallassatuu paydetikkino; ayaw gooppe, I barena dummayeedda he wodetuwaa giddon barena tunissi diggeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","« ‹Bare gefaa wodiyaa wursseedda wode barena S'oossaw dummayeedda Naaziraawiyaa wogay hawaa: S'oossaa Dunkkaaniyaa pengge I shiik'o; ");
INSERT INTO dwrl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Med'inaa Godaw tilla bollana de'iyaa itti laytsaa attuma dorssaa s'uuggiyaa yarshshoo, tilla bollana de'iyaa itti laytsaa dorssato nagaraa yarshshoonne tilla bollana de'iyaa dorssaa orggiyaa ittippetetsaa yarshshoo he sa'aa aho. ");
INSERT INTO dwrl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","K'ay katsaa yarshshuwaanne ushshaa yarshshuwaa unttunttunna ittippe yarshshanaw aho; he katsaa yarshshuu irshshuu gelibeennawaa gido; k'ay zayitiyaan munak'k'eedda liik'o d'iiliyaa komppotuwaanne zayitiyaa oketteedda lee\"o ukitsatuwaa masoofiyan aho. ");
INSERT INTO dwrl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","« ‹K'eesii hewaa ubbaa shiishiide, nagaraa yarshshuwaanne s'uuggiyaa yarshsho ootsiide, Med'inaa Godaw Aa diraw yarshsho. ");
INSERT INTO dwrl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","K'eesii dorssaa orggiyaa, irshshuu gelibeenna komppotuwaanne ukitsatuwaa ittippetetsaa yarshshuwaa ootsiide, Med'inaa Godaw yarshsho. K'ay hewaana ittippe katsaa yarshshuwaanne ushshaa yarshshuwaa yarshsho. ");
INSERT INTO dwrl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Hewaappe guyyiyaan, Naaziraawii S'oossaw dummayeedda bare huup'iyaa S'oossaa Dunkkaaniyaa penggiyaan meedetto; meedetteedda binnaanaa afiide, ittippetetsaa yarshshuwaappe garssa baggana de'iyaa taman yeggo. ");
INSERT INTO dwrl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","« ‹Barena S'oossaw dummayeedda Naaziraawii bare huup'iyaa meedetteeddawaappe guyyiyaan, k'eesii doyisetteedda dorssaa orggiyaa missaa, irshshuu gelibeenna itti komppuwaanne itti lee\"o ukitsaa akkiide, ha Naaziraawiyaa kushiyan wotso. ");
INSERT INTO dwrl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","K'eesii unttuntta k'aatsiyaa yarshshuwaa ootsiide, Med'inaa Godaa sintsan k'aatso. Yaatooppe hewanttu wus'akkeedda anggoosuwaananne yarshsheedda gediyaana geeshshanne k'eesiyaassa. Hewaappe guyyiyaan, Med'inaa Godaw barena dummayeedda Naaziraawii woyniyaa eessaa ushana gooppe usho. ");
INSERT INTO dwrl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","« ‹Simmi S'oossaw barena dummayanaw geppeedda Naaziraawiyaw wotso wogay hawaa: barena Med'inaa Godaw yarshshanaw koshshiyaa yarshshotuwaappe aad'd'iyaawaa immanaw geppeeddawaa gidooppe, I bare geppeedda gefaa keenaa gatsanaw koshshee› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Aaroonawunne Aa attuma naanaatoo hawaa oda; ‹Israa'eeliyaa asaa hintte hawaadan yaagiide anjjite: ");
INSERT INTO dwrl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«Med'inaa Goday hinttena anjjonne hinttena naago; ");
INSERT INTO dwrl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Med'inaa Goday hinttenttoo bare som\"uwaa poo'issonne hinttenttoo k'aretto; ");
INSERT INTO dwrl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Med'inaa Goday hinttena bare keeka ayifiyaan s'eellonne hinttenttoo sarotetsaa immo» yaagiide anjjite› yaaga. ");
INSERT INTO dwrl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","«Hawaadan unttunttu Israa'eeliyaa asaa bolla ta suntsaa wotsana, taani unttuntta anjjana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Muse S'oossaa Dunkkaaniyaa toliide makkeedda wode, he Dunkkaaniyaanne Aa miishshaa ubbaa okkiide geeshsheedda; k'ay yarshshiyaa saanne Aa miishshaa ubbaakka okkiide geeshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Hewaappe guyyiyaan, Israa'eeliyaa asaa kaaletseeddawanttu, hewanttunne zaratuwaa paydeedda soo asaa kaappotuu imotaa aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Med'inaa Godaw imotaa shiishsheeddino; hewanttukka kameteedda usuppun gaaretuwaa, tammanne laa\"u booratuwaa, kaappuwaan kaappuwaan itti itti booraanne laa\"u laa\"u kaappotuu itti itti gaariyaa S'oossaa Dunkkaaniyaa aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«S'oossaa Dunkkaaniyaa oosoo go\"ana mala, neeni hewantta unttunttuppe akkaade, Leewatoo unttunttu oosoo oosoo koshshiyaawaadan shaakkaade imma» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Muse gaaretuwaanne booratuwaa akkiide, Leewatoo immeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gershshoona yaratoo unttunttu oosoo koshshiyaawaadan shaakkiide, laa\"u gaaretuwaanne oyddu booratuwaa immeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","K'ay Maraara yaratoo unttunttu oosoo koshshiyaawaadan shaakkiide, oyddu gaaretuwaanne hosppun booratuwaa immeedda. Unttunttu ubbaykka k'eesiyaa Aaroona na'aa Itaamaara aawotetsaa garssaana. ");
INSERT INTO dwrl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Shin Muse K'ahaata yaratoo hewaappe ayaanne immibeenna; ayaw gooppe, unttunttu aawotetsaan de'iyaa geeshsha miishshatuu barenttu hashiyaan tookkanaw koshshiyaawantta gidiyaa diraassa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Yarshshiyaa saa Muse okkiide geeshsheedda gallassan, kaappotuu yarshshiyaa sa'aa anjjissanaw barenttu imuwaa akkiide, he yarshshuwaa sa'aa sintsa aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Med'inaa Goday Musa kase, «Itti itti gallassi itti kaappuu yarshshiyaa sa'aa anjjanaw bare imuwaa S'oossaw immo» yaagi wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Koyro gallassi bare imuwaa aheedawe Yihudaa zariyaappe Aminaadaaba na'aa Na'asoona. ");
INSERT INTO dwrl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Na'asooni aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii zayitiyaan munak'k'eeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda, is'aanay kumeedda shaataa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","s'uuggiyaa yarshshoo, itti korumaa, itti dorssaa orggiyaanne itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","nagaraa yarshshoo itti deeshshaa orggiyaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Aminaadaaba na'ay Na'asooni aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Laa\"entsa gallassi Yisaakoora zaratuu kaappuu, S'u'aara na'ay Nataani'eeli bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Nataani'eeli aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii zayitiyaan munak'k'eeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda, is'aanay kumeedda shaataa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","s'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","nagaraa yarshshoo itti deeshshaa orggiyaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. S'u'aara na'ay Nataani'eeli aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Heezzentsa gallassi Zaabiloona zaratuu kaappuu, Heloona na'ay Eli'aabi bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Eli'aabi aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii zayitiyaan munak'k'eteeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda, is'aanay kumeedda shaataa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","s'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","nagaraa yarshshoo itti deeshshaa orggiyaa, ");
INSERT INTO dwrl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Heloona na'ay Eli'aabi aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Oyddentso gallassi Roobeela zaratuu kaappuu Shade'uura na'ay Eliis'uuri bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Eliis'uuri aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii zayitiyaan munak'k'eeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda, is'aanay kumeedda shaataa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","s'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","nagaraa yarshshoo itti deeshshaa orggiyaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Shade'uura na'ay Eliis'uuri aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ichcheshantsa gallassi Simoona zaratuu kaappuu, S'uriishadaaya na'ay Shalumi'eeli bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Shalumi'eeli aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii zayitiyaan munak'k'eeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda is'aanay kumeedda shaataa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","s'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne, itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","nagaraa yarshshoo itti deeshshaa orggiyaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. S'uriishadaaya na'ay Shalumi'eeli aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Usuppuntsa gallassi Gaada zaratuu kaappuu, Re'u'eela na'ay Eliyasaafi bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Eliyasaafi aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii zayitiyaan munak'k'eeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda is'aanay kumeedda shaataa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","s'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","nagaraa yarshshoo itti deeshshaa orggiyaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Re'u'eela na'ay Eliyasaafi aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Laappuntsa gallassi Efireema zaratuwaa kaappuu Amihuuda na'ay Elishamaa'i bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Elishamaa'i aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii zayitiyaan munak'k'eeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda is'aanay kumeedda shaataa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","s'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne, itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","nagaraa yarshshoo itti deeshshaa orggiyaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Amihuuda na'aa Elishamaa'a imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Hosppuntsa gallassi Minaase zaratuu kaappuu Padaas'uura na'ay Gamaali'eeli bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Gamaali'eeli aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw lik'k'o d'iilii zayitiyaan munak'k'eeddawe kumeeddawantta ");
INSERT INTO dwrl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda is'aanay kumeedda shaataa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","s'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne, itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","nagaraa yarshshoo itti deeshshaa orggiyaa, ");
INSERT INTO dwrl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Padaas'uura na'ay Gamaali'eeli aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Udduppuntsa gallassi Biiniyaama zaratuu kaappuu Giidi'oona na'ay Abidaani bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Abidaani aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii, zayitiyaan munak'k'eeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda, is'aanay kumeedda shaataa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","s'uuggiyaa yarshshoo itti korumaa itti dorssaa orggiyaanne, itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","nagaraa yarshshoo itti deeshshaa orggiyaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne, itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Giidi'oona na'ay Abidaani aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Tammantsa gallassi Daana zaratuu kaappuu Amishadaaya na'ay Ahi'eezeri bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ahi'eezeri aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii, zayitiyaan munak'k'eeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda, is'aanay kumeedda shaataa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","S'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne, itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","nagaraa yarshshoo itti deeshshaa orggiyaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Amishadaaya na'ay Ahi'eezeri aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Tammanne ittentsa gallassi Aaseera zaratuu kaappuu Okiraana na'ay Paagi'eeli bare yarshshuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Paagi'eeli aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshoo yarshshanaw liik'o d'iilii, zayitiyaan munak'k'eeddawe kumeeddawantta; ");
INSERT INTO dwrl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda shaataa, is'aanay kumeeddawaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","s'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","nagaraa yarshshoo itti deeshshaa orggiyaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Okiraana na'ay Paagi'eeli aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Tammanne laa\"entso gallassi Nifttaaleema zaratuu kaappuu Enaana na'ay Ahiraa'i bare imuwaa aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ahiraa'i aheedda imuu eretteedda miizaanan wotsina, itti kiilo giraamenne bagga dees'iyaa biraappe med'd'eedda itti keriyaanne hosppun s'eetu giraame dees'iyaa biraappe med'd'eedda itti kuyis'aaruwaa, laa\"uukka katsaa yarshshuwaa yarshshanaw liik'o d'iilii, zayitiyaan munak'k'eeddawe kumeeddawantta, ");
INSERT INTO dwrl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","k'ay itti s'eetanne tammu giraame dees'iyaa work'k'aappe med'd'eedda itti shaataa, is'aanay kumeeddawaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","s'uuggiyaa yarshshoo itti korumaa, itti dorssaa orggiyaanne itti laytsay kumeedda attuma dorssaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","nagaraa yarshshoo itti deeshshaa orggiyaa, ");
INSERT INTO dwrl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ittippetetsaa yarshshoo laa\"u korumatuwaa, ichcheshu dorssaa orggetuwaa, ichcheshu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda ichcheshu attuma dorssatuwaa. Enaana na'ay Ahiraa'i aheedda imuu hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Yarshshiyaa sa'ay oketteedda wode, Israa'eelatuwaa kaappatuu yarshshiyaa sa'aa anjjanaw aheedda imotay ubbaanna hawantta: Biraappe med'd'eedda tammanne laa\"u keretuwaa, biraappe med'd'eedda tammanne laa\"u kuyis'aarotuwaanne work'k'aappe med'd'eedda tammanne laa\"u shaatetuwaa; ");
INSERT INTO dwrl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","biraappe med'd'eedda itti itti kerii itti kiilo giraamenne bagga dees'ee; biraappe med'd'eedda itti itti kuyis'aaruu hosppun s'eetu giraame dees'ee; biraappe med'etteedda keriyaanne kuyis'aaruu eretteedda miizaanan wotsina, ubbaanna laatamanne hosppun kiilo giraame keenaa dees'iino. ");
INSERT INTO dwrl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Tammanne laa\"u work'k'aa shaatatuu eretteedda miizaanan wotsina ittuu ittuu itti s'eetanne tammu giraame, ubbaanna itti kilonne heezzu s'eetu giraame dees'iino. Unttunttun is'aanay kumi utteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Katsaa yarshshuwaanna ittippe s'uuggiyaa yarshshoo aheedda mehii ubbaanna tammanne laa\"u korumatuwaa, tammanne laa\"u dorssaa orggetuwaanne itti laytsay kumeedda tammanne laa\"u attuma dorssatuwaa. Unttunttu nagaraa yarshshoo aheedda deeshshaa orggetuu ubbaanna tammanne laa\"a. ");
INSERT INTO dwrl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Unttunttu ittippetetsaa yarshshoo aheedda mehii ubbaanna laatamanne oyddu korumatuwaa, usuppun tammu dorssaa orggetuwaa, usuppun tammu gakkeedda deeshshaa orggetuwaanne itti laytsay kumeedda usuppun tammu attuma dorssatuwaa. Yarshshiyaa sa'ay oketteeddawaappe guyyiyaan, anjjoo aheedda imotay hawantta. ");
INSERT INTO dwrl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Muse Med'inaa Godaana haasayanaw S'oossaa Dunkkaaniyaa geliyaa wode, Markkatetsaa Taabootaa bollan de'iyaa atto giyaa sa'aa k'um\"uwaa bollan, laa\"u kiruubetuwaappe gidduwaana Med'inaa Goday haasayiyaa kooshshaa siseedda; Ikka aanana haasayeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Neeni Aaroonaw hawaadan yaagaade oda; ‹Neeni laappun s'omppetuwaa wotsiyaa wode s'omppetuu s'omppiyaa wotsiyaa ballatuwaappe sintsa baggana de'iyaa heeratuwaa poo'iino› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","I geeddawaadan Aarooni ootseedda. Med'inaa Goday Musa azazeeddawaadan, Aarooni s'omppetuwaa wotsiyaa ballatuwaappe sintsa baggana de'iyaa heeratuwaa poo'issanaadan ootsiide, ballatuwaan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","S'omppiyaa wotsiyaawe garssa gediyaappe bolla c'iishshaana alleek'k'etteedda ballatuwaa s'eeraa gakkanaw k'os'etteedda work'k'aappe med'etteedda. S'omppiyaa wotsiyaa ballay Med'inaa Goday Musa besseedda leemisuwaadan oosetteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","K'ay Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Hara Israa'eeliyaa asaa gidduwaappe Leewatuwaa akkaade, unttuntta wogaadan geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Neeni unttuntta geeshshanaw hawaadan ootsa: geeshshiyaa haatsaa akkaade unttuntta pushakka; unttunttu barenttu bollaa ubbaa meedettino; barenttu mayuwaakka meec'c'ino; yaatiide unttunttu wogaadan geeshsha gidana. ");
INSERT INTO dwrl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Hewaappe guyyiyaan, unttunttu korumaa ittuwaanne liik'o d'iiliyaa zayitiyaan munak'k'eeddawaa katsaa yarshshoo akkino; neeni k'ay laa\"entso korumaa nagaraa yarshshoo akka. ");
INSERT INTO dwrl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Yaataade Leewatuwaa S'oossaa Dunkkaaniyaa sintsa ayaa; Israa'eeliyaa asaa maabaraa ubbaa shiishsha. ");
INSERT INTO dwrl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Neeni Leewatuwaa Med'inaa Godaa sintsa ahina, Israa'eeliyaa Asay unttunttu bolla barenttu kushiyaa wotsino. ");
INSERT INTO dwrl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Leewatuu Med'inaa Godaa oosuwaa ootsanaw giigana mala, Aarooni Israa'eeliyaa asaappe Leewatuwaa k'aatsiyaa yarshshuwaa ootsiide, Med'inaa Godaa sintsa shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«Leewatuu barenttu kushiyaa korumatuu huup'iyaan wotsino; ittuwaa nagaraa yarshshuwaa ootsaade, ittuwaa k'ay Leewatuu atto geetettana mala, s'uuggiyaa yarshshuwaa ootsaade Med'inaa Godaw yarshsha. ");
INSERT INTO dwrl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Leewatuwaa Aaroonanne Aa attuma naanatu aawotetsaa garssan wotsa; yaataade unttuntta k'aatsiyaa yarshshuwaa ootsaade, Med'inaa Godaa sintsa shiishsha. ");
INSERT INTO dwrl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Hewaadan ootsaade Leewatuwaa hara Israa'eeliyaa asaappe dummaya; dummayooppe Leewatuu tawaa gidana. ");
INSERT INTO dwrl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","«Neeni Leewatuwaa geeshsheeddawaappenne k'aatsiyaa yarshshuwaa ootsaade shiishsheeddawaappe guyyiyaan, S'oossaa Dunkkaaniyaan barenttu oosuwaa ootsanaw yiino. ");
INSERT INTO dwrl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Israa'eeliyaa asaa gidduwaappe unttunttu taw ubbaanna imetteeddino; Israa'eeliyaa mac'c'a asaappe yeletteedda bayira attumawanttu ubbaa diraw taani Leewatuwaa taw akkaad. ");
INSERT INTO dwrl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Israa'eeliyaa asaa gidduwaan bayira yeletteeddawe asaa gidina, mehiyaa gidinakka ubbay tawaa. Taani Gibs'e gadiyaan bayira ubbaa wod'eedda gallassan, unttuntta taw dummayaad. ");
INSERT INTO dwrl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Israa'eeliyaa bayira attumawanttu ubbaa diraw taani Leewatuwaa akkaad. ");
INSERT INTO dwrl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Israa'eeliyaa asaa ubbaa gidduwaappe taani Leewatuwaa Aaroonawunne Aaroona attuma naanaw imuwaa ootsaade immaad. Israa'eeliyaa Asay Gaketiyaa Dunkkaaniyaa shiik'iyaa wode, boshay unttuntta bochchenna mala, Leewatuu Israa'eeliyaa asaa gishsha Gaketiyaa Dunkkaaniyaan barenttu oosuwaa ootsinonne unttunttu diraw atto geetettino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Med'inaa Goday Musa Leewatuwaa dummayanaw azazeeddawaadan Muse, Aarooninne Israa'eeliyaa asaa maabaray ubbay ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leewatuu barena geeshsheeddino; barenttu mayuwaakka meec'c'eeddino. Aarooni unttunttu k'aatsiyaa yarshshuwaa ootsiide, Med'inaa Godaa sintsa shiishsheedda; unttuntta geeshshanaw unttuntta atto giisseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Hewaappe guyyiyaan, Leewatuu Aaroonanne Aaroona attuma naanatu aawotetsaa garssan, Gaketiyaa Dunkkaaniyaa giddon barenttu oosuwaa ootsanaw yeeddino. Med'inaa Goday Musa Leewatuwaa dummayanaw azazeeddawaadan unttunttu ootseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","K'aykka Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Hawe Leewatuwaa s'eelliyaa wogaa: laytsay laatamanne ichcheshanne hewaappe bollana de'iyaa attumawanttu oosuwaa ootsanaw Gaketiyaa Dunkkaaniyaa yiino. ");
INSERT INTO dwrl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Shin unttunttu laytsay ishatamuwaa gidiyaa wode unttunttu barenttu oosuwaappe s'urataa kesino; simmiide laa\"entso ootsoppino. ");
INSERT INTO dwrl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Unttunttu Gaketiyaa Dunkkaaniyaan ootsiyaa barenttu ishatuwaa ootsi maaddana gooppe maaddinoppe attina, unttunttu barekka ay oosonne ootsoppino. Simmi neeni Leewatuwaa oosuwaa hawaadan oosissaasa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Israa'eeliyaa Asay Gibs'eppe keseedda laa\"entso laytsan koyiro agenaan Siinaa Mela biittaan Med'inaa Goday Musew hawaadan yaagiide haasayeedda; ");
INSERT INTO dwrl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Israa'eeliyaa Asay Paasigaa Baalaa keereedda gallassan bonchcho. ");
INSERT INTO dwrl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ha aginaan tammanne oyddentso gallassan, Aa keereedda wode, away wullana haniyaa wode, Aa wogaa ubbaadaaninne Aa azazo ubbaadan bonchcho» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Muse Israa'eeliyaa Asay Paasigaa Baalaa bonchchana mala, unttunttoo odeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Koyro aginaw tammanne oyddentso gallassi, away wullana haniyaa wode Siinaa Mela biittaan unttunttu Paasigaa Baalaa bonchcheeddino. Israa'eeliyaa Asay Med'inaa Goday Musa azazeeddawaadan ubbabaa ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Shin unttunttuppe amareedawanttu hayk'k'eedda asaa anhaa bochchiide tuneedda diraw, he gallassi Paasigaa Baalaa bonchchanaw danddayibeykkino. Hewaa diraw, unttunttu Musekkonne Aaroonakko he gallassi yiide, ");
INSERT INTO dwrl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Musa, «Nuuni hayk'k'eedda asaa anhaa bochcheedda diraw tuneeddo; shin keereedda wodiyaan hara Israa'eeliyaa asaanna Med'inaa Godaw yarshshuwaa shiishshiyaawaa nuuni ayaw digetteettoo?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Muse unttuntta, «Med'inaa Goday hinttewaa taw azaziyaawaa taani sisana gakkanaw hintte takkishshite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Hewaappe guyyiyaan Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Neeni Israa'eeliyaa asaa hawaadan yaaga; ‹Hintteppe woy hintte zaratuwaappe ooninne anhaa bochchiide tunooppe, woy manddareeddawaa gidooppe, I Med'inaa Godaw Paasigaa Baalaa bonchcho; ");
INSERT INTO dwrl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","laa\"entso aginaan tammanne oyddentso gallassi away wullana haniyaa wode Paasigaa Baalaa bonchcho. Paasigaa dorssaa irshshuu gelibeenna ukitsaananne c'amo bonc'c'iyaanna mo. ");
INSERT INTO dwrl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Sa'ay wonttanaw he dorssaappe ayaanne ashshoppo; k'ay Aa mek'etsaappekka ittuwaanne mentsoppo. Paasigaa Baalaw Aa woga ubbaa ootso. ");
INSERT INTO dwrl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Shin manddaribeenna geeshsha Asay Paasigaa bonchchennaan is's'ooppe, hewaappe sintsaw I ta asaa giddoppe bohetto. Ayaw gooppe, Med'inaa Godaa yarshshuwaa keereedda wodiyaan I shiishshibeenna. He Asay bare nagaray aheedda metuwaa akkanaw besse. ");
INSERT INTO dwrl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","« ‹Hintte gidduwaan de'iyaa bete Asay Paasigaa Baalaa Med'inaa Godaw bonchchana koyooppe, Paasigaa wogaadan bonchcho. Betiyawukka gade asawukka itti mala wogay de'o› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Dunkkaanii toletteedda gallassi shaarii Markkatetsaa Dunkkaaniyaa mayyeedda; omarssaappe doommiide, wonttana gakkanaw Dunkkaaniyaappe bollana de'iyaa shaarii tamaa malatee. ");
INSERT INTO dwrl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Hewaadan ubbaa wode gallassi gallassi shaarii mayyee; k'amma k'amma he shaarii tamaadan poo'ee. ");
INSERT INTO dwrl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","He shaarii Dunkkaaniyaa bollaappe denddiyaa wode awudenne Israa'eelatuu barenttu dunkkaaneedda sa'aappe denddiino; k'ay he shaarii wod'd'iyaa ay sa'aaninne Israa'eelatuu dunkkaaniino. ");
INSERT INTO dwrl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Israa'eelatuu Med'inaa Godaa azazuwaan denddino; hewaadankka, Med'inaa Godaa azazuwaan dunkkaaniino. Shaarii Dunkkaaniyaa bollan gam\"iyaa wode ubbaan barenttu dunkkaaneeddasan gam\"ino. ");
INSERT INTO dwrl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Shaarii Dunkkaaniyaa bollan daro gallassaa gam\"ooppe, Israa'eelatuu Med'inaa Godaa azazuwaa naagiinoppe attina, hak'anne biikkino. ");
INSERT INTO dwrl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Itti itti gede shaarii Dunkkaaniyaa bollan amareeda gallassaa gam\"ee. Med'inaa Godaa azazuwaan unttunttu dunkkaaniino; k'ay hewaadankka, S'oossaa azazuwaan unttunttu denddino. ");
INSERT INTO dwrl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Itti itti gede shaarii omarssaappe wonttana gakkanaw s'alalaa gam\"ee; wonttina shaarii denddiyaa wode unttunttukka denddino. Gallassaa gidina, k'amma gidina, shaarii denddiyaa wode unttunttukka denddino. ");
INSERT INTO dwrl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Shaarii Dunkkaaniyaa bollan laa\"u gallassaa gam\"ina, woy itti aginaa, woy itti laytsaa gam\"ina, Israa'eelatuu barenttu dunkkaaneeddasan gam\"iinoppe attina biikkino. Shin shaarii denddiyaa wode unttunttukka denddino. ");
INSERT INTO dwrl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Unttunttu Med'inaa Godaa azazuwaan dunkkaaniinonne k'ay Med'inaa Godaa azazuwaan denddino; Med'inaa Goday Muse baggana azazeeddawaadan, unttunttu Med'inaa Godaa azazuwaa naageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Laa\"u s'urumbbatuwaa biraappe k'os's'aade ootsa; yaataade asaa shiik'oo s'eeganawunne k'ay dunkkaaneedda saappe denddanaw dentsetsanaadan punna. ");
INSERT INTO dwrl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ha laa\"u s'urumbbatuu punettiyaa wode, Asay ubbay Gaketiyaa Dunkkaaniyaa penggii neekko shiik'o. ");
INSERT INTO dwrl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Shin itti s'urumbba s'alalay punettooppe, Israa'eeliyaa zaratuwaa kaappatuu ne sintsa shiik'ino. ");
INSERT INTO dwrl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Neeni s'urumbbaa d'ok'k'u ootsaade punniyaa wode, away doliyaa baggana dunkkaaneedda zaratuu denddino. ");
INSERT INTO dwrl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","S'urumbbaa laa\"entso d'ok'k'u ootsaade punniyaa wode, gedissa baggana dunkkaaneedda zaratuu denddino. S'urumbbay d'ok'k'u gi punettiyaawe denddanaw mallaa gido. ");
INSERT INTO dwrl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Yaa'aw asaa shiishshanaw s'urumbbaa punna; shin kooshshaa d'ok'k'u ootsaade punnoppa. ");
INSERT INTO dwrl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aaroona naanay k'eesatuu s'urumbba punnino. Hawe newunne yiyaa yeletaa ubbaw med'ina woga gido. ");
INSERT INTO dwrl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«Hintte gadiyaan metuwaa dentsiyaa hintte morkkiyaanna hintte olettanaw kesiyaa wode, he s'urumbbatuwaa d'ok'k'u ootsiide punnite. Hewaan Med'inaa Goday hintte S'oossay hinttena he wode hassayiide, hintte morkkiyaappe hinttena ashshana. ");
INSERT INTO dwrl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Hewaadankka, k'ay hintte nashettiyaa gallassi, baalaa bonchchanaw hintte keereedda gallassinne agenay s'eeriya baalan, hintte s'uuggiyaa yarshshuwaa yarshshiyaa wodenne hintte ittippetetsaa yarshshuwaa yarshshiyaa wode he s'urumbbatuwaa punnite; hewe S'oossaa sintsan hinttena hassayissiyaawaa gidana. Taani Med'inaa Godaa, hintte S'oossaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Laa\"entsa laytsan laa\"entso aginaan laatamantsa gallassi, shaarii Markkatetsaa Dunkkaaniyaa bollappe denddeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Hewaappe guyyiyaan, Israa'eeliyaa Asay Siinaa Mela biittaappe denddeedda; shaarii Paaraana giyaa mela biittaa gakkiide wod'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Unttunttu ha koyiro buussaw Med'inaa Goday Muse baggana azazeeddawaadan denddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yihudaa zaratuwaanna dunkkaaneedda baggay barenttu armmaa oyk'k'iide koyro denddeeddino. Yihudaa zaratuu kaappuu Aminaadaaba na'aa Na'asoona; ");
INSERT INTO dwrl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Yisaakoora zaratuu kaappuu S'u'aara na'aa Nataani'eela; ");
INSERT INTO dwrl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zaabiloona zaratuu kaappuu Heloona na'aa Eli'aaba. ");
INSERT INTO dwrl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Hewaappe guyyiyaan, Dunkkaaniyaa shoddina, Gershshoona yaratuunne Maraara yaratuu tookkiide denddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kaalliide Roobeela zaratuwaanna dunkkaaneedda baggay barenttu armmaa oyk'k'iide denddeedda. Roobeela zaratuu kaappuu Shade'uura na'aa Eliis'uura; ");
INSERT INTO dwrl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simoona zaratuu kaappuu S'uriishadaaya na'aa Shalumi'eela; ");
INSERT INTO dwrl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gaada zaratuu kaappuu Re'u'eela na'aa Eliyasaafa. ");
INSERT INTO dwrl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Hewaappe guyyiyaan, K'ahaata yaratuu geeshsha miishshatuwaa tookkiide denddeeddino. Unttunttu gakkanaappe kasetiide, Dunkkaanii toletti utteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Kaalliide Efireema zaratuwaanna dunkkaaneedda baggay bare armmaa oyk'k'iide denddeedda. Efireema zaratuu kaappuu Amihuuda na'aa Elishamaa'a; ");
INSERT INTO dwrl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Minaase zaratuu kaappuu Padaas'uura na'aa Gamaali'eela; ");
INSERT INTO dwrl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Biiniyaama zaratuu kaappuu Giidi'oona na'aa Abidaana. ");
INSERT INTO dwrl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Wurssetsan, ha c'uguwaa ubbaw guyye baggan naagiyaa Daana zaratuwaanna dunkkaaneedda baggay bare armmaa oyk'k'iide denddeedda. Daana zaratuu kaappuu Amishadaaya na'aa Ahi'eezera; ");
INSERT INTO dwrl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aaseera zaratuu kaappuu Okiraana na'aa Paagi'eela; ");
INSERT INTO dwrl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Nifttaaleema zaratuu kaappuu Enaana na'aa Ahiraa'a. ");
INSERT INTO dwrl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Israa'eeliyaa Asay bare baggan baggan denddiide biyaa maaray hawaadaana. ");
INSERT INTO dwrl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Muse Midiyaama asaa gidiyaa bare bolluwaa Re'u'eela na'aa Hobaaba, «Nuuni Med'inaa Goday, ‹Taani hinttenttoo immana› geedda sa'aa beeto; Med'inaa Goday Israa'eeliyaw lo\"obaa ootsana geedda diraw, neeni nuunana dendda. Nuuni new lo\"obaa ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobaabi, «Tuytti, taani biikke; taani ta biittaa ta asaakko baana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Muse Aa, «Hayyanaa, nuuna yeggaade boopparikkii! mela biittaan nuuni dunkkaananaw bessiyaasa neeni eraasa; neeni nu biyaa ogiyaa nuuna kaaletsanawukka danddayaasa. ");
INSERT INTO dwrl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Neeni nuunana booppe, Med'inaa Goday nuw immiyaa anjjuwaa ubbaa nuuni neenana shaakkana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Yaatina unttunttu Med'inaa Godaa deriyaappe denddiide, heezzu gallassaa keeshshaa ogiyaa beeddino. Med'inaa Godaa C'aak'uwaa Taabootay unttunttu shemppiyaa sa'aa demmanaw he heezzu gallassan unttunttuppe sintsaw beedda. ");
INSERT INTO dwrl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Unttunttu dunkkaaneedda sa'aappe denddiyaa wode ubbaan, Med'inaa Godaa shaarii gallassi gallassi unttunttuppe bollana de'ee. ");
INSERT INTO dwrl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Taabootay denddiyaa wode ubbaan Muse, «Abeet Med'inaa Godaw, dendda! Ne morkketuu laalettino; Neena is's'iyaawanttukka ne sintsaappe bak'atino» yaagee. ");
INSERT INTO dwrl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Taabootay shemppiyaa wode ubbaan Muse, «Abeet Med'inaa Godaw, ha daro sha\"an paydetiyaa Israa'eeliyaa asaakko neeni simma» yaagee. ");
INSERT INTO dwrl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Asay bare metoo Med'inaa Godaa bolla zuuzummeedda; unttunttu zuuzummiina S'oossay sisiide, hank'k'uwaa ees's'i keseedda. Yaatina Med'inaa Godaa tamay unttunttu gidduwaan ees's'iide, unttunttu dunkkaaneedda sa'aw itti itti gas'aa bagga meedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Yaatina Asay Musew waassina, Muse Med'inaa Godaa woosseedda. Tamay to'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Med'inaa Godaa tamay unttunttu gidduwaan ees's'eedda diraw, he sa'ay Tabi'eera geetetti s'eesetteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Israa'eelatuwaana de'iyaa dumma dumma gade Asay hara k'umaa loytsi amotteedda. Israa'eeliyaa asaykka k'ay hawaadan yaagiide yeekuwaa doommeedda; «Laa nuuni ashuwaa hak'appe demmanee? ");
INSERT INTO dwrl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nuuni Gibs'e gadiyaan miishshaa c'iggenan c'oo miyaa moliyaa hassayeetto; k'ay k'ayiyaa miyaa paranjjiyaa leekiyaa, zolddo leekiyaa malatiyaa mal\"iyaa haatsay kumeedda meelooniyaa, adussa paranjjiyaa sunk'k'uruttiyaanne tuumuwaa hassayeetto. ");
INSERT INTO dwrl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Shin ha\"i nu k'ood'ii gorddetteedda; nu ayifiikka ha mannaappe attina, harabaa ayinne be'enna» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mannay deebbuwaa ayfiyaa malatee; Aa malay boos's'iyaa mitsaa c'ooshshaa malatee. ");
INSERT INTO dwrl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Asay yuuyyi yuuyyi Aa k'oree; wos'aan gaac'c'ee, woy udulan c'addee; unttunttu Aa otuwaan penttissiide, bashiyan komppiino. I zayitiyaan munak'k'iide uukkeedda ukitsaadan mal\"ee. ");
INSERT INTO dwrl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","K'amma dunkkaaneeddasan s'aasay wod'd'iyaa wode, mannay aanana wod'd'ee. ");
INSERT INTO dwrl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Asay bare dunkkaaniyaa penggiyaan penggiyaan yeekkishin, Muse siseedda. Med'inaa Godaa hank'k'uu ees's'i keseedda diraw, Muse un\"etteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Hewaa diraw, Muse Med'inaa Godaa hawaadan yaagiide oochcheedda; «Neeni ta bolla ne k'oomaa bolla ayaw ha metuwaa ahaadii? Neeni taanan ayaw nashetabeykkii? Neeni ha asaa ubbaa tookuwaa ta bolla ayaw wotsaaddii? ");
INSERT INTO dwrl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ha asaa ubbaa taani shahaaraadditaayye? Woy unttuntta taani yelaadditaa? ‹Neeni unttunttu mayzza aawaatoo, «Taani hinttenttoo immana» gaade c'aak'k'eedda biittaa gatsanaw, naanatuwaa dichchiyaana d'antsiyaa na'aa bare kiwuwaan idimmiyaawaadan, neeni unttuntta ne kiwuwaan idimma› yaagaade taw ayaw oday? ");
INSERT INTO dwrl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ha asaw ubbaw taani ashuwaa hak'appe demmanee? Unttunttu taana, ‹Miyaa ashuwaa nuw imma› yaagiide yeekkiino. ");
INSERT INTO dwrl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Taani ha asaa ubbaa taarekka tookkana danddaykke; tookku taw loytsi dees'ee. ");
INSERT INTO dwrl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Simmi neeni taana hawaadan metootanaadan ootsanawaappe taw k'arettaade taana ha\"i wod'a basha; yaatooppe, taani metuwaappe shemppana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Med'inaa Goday Musa, «Israa'eeliyaa c'imatuwaappe kaaletsiyaawanttanne kaappatuwaa gidiyaa, neeni eriyaa laappun tammu c'imatuwaa taw shiishsha; unttunttu neenana yan ek'k'ana mala, S'oossaa Dunkkaaniyaakko, unttuntta neeni ayaa. ");
INSERT INTO dwrl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Taani duge wod'd'aade neenana yan haasayana; taani neenan de'iyaa Ayyaanaappe akkaade, he Ayaanaa unttunttu bolla wotsana. Neeni neerekka tookkenna mala, unttunttu asaa tookuwaa tookkiide, neena maaddana. ");
INSERT INTO dwrl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«Neeni asaw hawaadan gaade oda, ‹Wonttiw hinttena geeshshite; yaatiide hintte ashuwaa maana. Hintte, «Laa nuuni ashuwaa hak'appe demmanee? Nuw Gibs'e gadiyaan sa'ay lo\"a shin!» yaagiide yeekkeeddawaa Med'inaa Goday siseedda. Med'inaa Goday ashuwaa ha\"i hinttenttoo immana; immina hintte maana. ");
INSERT INTO dwrl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","20","Hintte gidduwaan de'iyaa Med'inaa Godaa hintte kad'eedda dirawunne hintte, «Nuuni Gibs'e gadiyaappe ayaw keseeddo?» yaagiide Aa sintsan yeekkeedda diraw, hintte itti gallassaa, woy laa\"u gallassaa, woy ichcheshu gallassaa, woy tammu gallassaa, woy laatamu gallassaa s'alalaa ashuwaa miikkita; shin hinttenttoo siid'iyaanna kesana gakkanaw, hinttena saletsana gakkanaw, itti aginaa kumentsaa hintte ashuwaa maana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Shin Muse S'oossaa, «Be'a, taani usuppun s'eetu sha\"a gidiyaa asaa gidduwaan de'ay; neeni, ‹Itti aginaa kumentsaa unttunttu maanaw unttunttoo taani ashuwaa immana› gaadda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Miizzaa wudiyaanne dorssaa wudiyaa unttunttoo shukkina kalissanee? Abban de'iyaa moliyaa ubbaa shiishshiyaawaa gidinttonne, unttunttoo gidanee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Med'inaa Goday Musa, «Med'inaa Godaa kushii k'antseeyye? Taani new giyaabay tumenttonne worddentto neeni ha\"i be'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Muse kare kesiide, Med'inaa Goday geeddawaa asaw odeedda. I Israa'eeliyaa c'imatuwaappe laappun tammu asaa shiishiide, Dunkkaaniyaa yuushshuwaan esseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Med'inaa Goday shaariyan duge wod'd'iide, aananna haasayeedda; yaatiide Aa bollan de'iyaa Ayyaanaappe akkiide, he laappun tammu c'imatuwaa bolla wotseedda. Ayyaanay unttunttu bollan shemppeedda wode, unttunttu timbbitiyaa odeeddino. Shin hewaappe guyyiyaan, zaaretsiide timbbitiyaa odibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","He laappun tammu c'imatuwaanna mazggobiyaan s'aafetteedda asatuu Elddaadanne Medaada giyaa laa\"atuu dunkkaaneeddasan atteeddino; Dunkkaaniyaakko yibeykkino; shin unttunttu bollakka Ayyaanay wod'd'ina, dunkkaaneeddasan timbbitiyaa odeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Itti wodallay wos's'i yiide, Musa, «Elddaadinne Medaadi dunkkaaneeddasan timbbitiyaa odiino» yaagiide odeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Bare yalagatetsaappe doommiide, Musa maaddiyaa Neewe na'ay Iyyaasu Musa, «Ta godaw Muse, neeni unttuntta te\"a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Shin Muse Aa, «Ta gishshataa ne mishettay? Med'inaa Godaa Asay ubbay timbbitiyaa odiyaawaanne Med'inaa Goday bare Ayaanaa unttunttu bolla wotsiyaawaa gideerenneeshsha!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Hewaappe guyyiyaan, Musenne Israa'eeliyaa c'imatuu dunkkaaneeddasaa simmeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Hewaappe guyyiyaan, Med'inaa Goday c'arkkuwaa dentsina, abbaa baggappe akkaa Asay dunkkaaneeddasaa ubbaa yuushshuwaakko c'arkkuu aheedda; he kafotuu sa'aa doonaana gadiyaappe pude laa\"u wad'aa keeshshan paalleeddino. Yiide unttunttu dunkkaaneeddasaa ubbaappe gas'aana, itti gallassaa oge keenaa sa'aan utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","He gallassaa ubbaan, he k'amma ubbaaninne wonttetsa gallassaa ubbaan Asay kare kesiide, ha akkatuwaa oyk'k'iide shiishsheedda; unttunttuppe ooninne itti sha\"a kiilo giraameppe guutsaa shiishshibeenna. Unttunttu hewaappe guyyiyaan, dunkkaaneeddasaa yuushshuwaa ubbaan melissanaw mic'c'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Shin ashuu biro unttunttu matan de'ishshin, unttunttu c'oommiide mittennan de'ishshin, Med'inaa Godaa hank'k'uu asaa bolla ees's'i keseedda; yaatina Med'inaa Goday asaa wolk'k'aama boshaan shoc'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Yaatina he sa'ay Kibroot Hattaabaa (Amuwaa Duufuwaa) geetetti suntsetteedda; ayaw gooppe, ashuwaa amotteedda asaa unttunttu he sa'aan moogeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Asay hewaappe denddiide Has'eroota giyaasaa biide, yan dunkkaaneedda. ");
INSERT INTO dwrl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Muse Toop'p'iyaa biittaa mishirato akkeedda. I akkeedda Toop'p'iyaa mac'c'aani diraw, Miiriyaamanne Aarooni Musa boreeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Unttunttu, «Med'inaa Goday Muse bagga s'alalana haasayeeddeyye? K'ay I nu baggana haasayibeenneeyye?» yaageeddino. Med'inaa Goday hewaa siseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Muse gadiyaan sa'aan ubbaan de'iyaa asaa ubbaappe aad'd'iyaa ashkke asaa. ");
INSERT INTO dwrl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Med'inaa Goday ellekka Musew, Aaroonawunne Miiriyaamiw, «Hintte heezzuukka Gaketiyaa Dunkkaaniyaakko kesite» yaageedda; unttunttu heezzuukka keseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","S'oossay shaariyaa tuussaan duge wod'd'eedda; Dunkkaaniyaa penggiyaan ek'k'iide, Aaroonanne Miiriyaamo s'eeseedda. Unttunttu laa\"uukka Aa sintsa shiik'ina, ");
INSERT INTO dwrl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","I unttuntta, «Ta odiyaawaa sisite: Hintte gidduwaan timbbitiyaa odiyaawe de'ooppe, taani Med'inaa Goday taana aw sas'aan k'onc'c'issay; taani aw akumuwaan oday. ");
INSERT INTO dwrl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Shin ta k'oomaa Musena hewaadan gidenna; I ta golliyaa ubbaan ammanetteedawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Taani Musena sintsa sintsaan haasayayippe attina, leemisuwaan haasayikke. I Med'inaa Godaa malaa be'ee. Yaatina ta k'oomaa Musa boranaw hintte ayaw yayyibeykkitee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Med'inaa Godaa hank'k'uu unttunttu bolla ees's'i keseedda; Med'inaa Goday beedda. ");
INSERT INTO dwrl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Shaarii Dunkkaaniyaa bollaappe denddeedda wode, Miiriyaama wolk'k'aama galbbaa harggiyaan mils's'i gaade boos's'aaddu. Aarooni iikko simmiide s'eelliyaa wode, wolk'k'aama galbbaa harggiyaan oyk'k'etteeddaano be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Yaatina I Musa, «Hay ta godaw, nuuni eeyyatetsan ootseedda nagaraw nuuna muroppa. ");
INSERT INTO dwrl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Bare daay uluwaappe kesiyaa wode, Aa ashuwaappe baggay meetetti kichchina, hayk'k'i kichchiide yeletteedda gac'ino na'aa mala gidoppaarekkee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Muse, «Hay S'oossaw, izo patsaarikkii!» yaagiide Med'inaa Godaw waasseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Med'inaa Goday Musa, «I aawuu I som\"iyaan c'uchchaa c'uchcheeddawaa gidinttonne, laappun gallassaa iza yeellaa mayyaade uttana gidekkeeyye? Hewaa diraw, neeni izo laappun gallassaa dunkkaaneedda sa'aappe gas'aa baggana dumma sa'aan utissa; hewaappe guyyiyaan, simmaade yu» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Yaatina Miiriyaama Asay dunkkaaneedda sa'aappe gas'aa kesaade laappun gallassaa uttaaddu. Aa simmana gakkanaw Asay baanaw denddibeenna. ");
INSERT INTO dwrl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Hewaappe guyyiyaan, Asay Has'eroota giyaa saappe denddiide, Paaraana mela biittaa dunkkaaneedda. ");
INSERT INTO dwrl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Med'inaa Goday, Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Taani Israa'eelatoo immiyaa Kanaane biittaa wochchana mala, amareeda asaa kiitta; unttunttu zare ubbaappe itti itti kaappuwaa kiitta» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Muse Med'inaa Godaa azazuwaan Paaraana Mela biittaappe unttuntta kiitteedda. Unttunttu ubbaykka Israa'eeliyaa asaa kaappatuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Unttunttu suntsay hawaappe kaalliide s'aafetteeddawaa: Zariyaa Kaappuwaa Roobeela Zakkuura na'aa Shaamu'a; ");
INSERT INTO dwrl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simoona Hoora na'aa Shafaas'a; ");
INSERT INTO dwrl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yihudaa Yifune na'aa Kaaleeba; ");
INSERT INTO dwrl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Yisaakoora Yooseefo na'aa Yigi'aala; ");
INSERT INTO dwrl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efireema Neewe na'aa Hoshee'a; ");
INSERT INTO dwrl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Biiniyaama Raafu na'aa Pals's'a; ");
INSERT INTO dwrl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zaabiloona Sooda na'aa Gaddi'eela; ");
INSERT INTO dwrl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yooseefo na'aa Minaasa Suusa na'aa Gadda; ");
INSERT INTO dwrl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Daana baggappe Gamaalla na'aa Ami'eela; ");
INSERT INTO dwrl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aaseera Mikaa'eela na'aa Satuura; ");
INSERT INTO dwrl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nifttaaleema Waafisa na'aa Naahiba; ");
INSERT INTO dwrl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gaada Maaka na'aa Ge'u'eela. ");
INSERT INTO dwrl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","He biittaa wochchana mala, Muse kiitteedda asatuu suntsay hawaappe k'ommonna de'iyaawaa. Muse Neewe na'aa Hoshee'a suntsaa Iyyaasa yaagiide suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Unttunttu Kanaane biittaa wochchana mala, Muse unttuntta kiittiyaa wode hawaadan yaageedda; «Hawaappe Neegeeba mela biittaa pude kesiide, yaappe huup'issa baggan de'iyaa gezze biittaa biite. ");
INSERT INTO dwrl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Biittay ay mala biittenttonne be'ite; he gadiyaan de'iyaa Asay minenttonne laafaantto, guutseenttonne darentto, ");
INSERT INTO dwrl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","unttunttu de'iyaa biittay lo\"enttonne iitentto, unttunttu de'iyaa katamaynne ay mala katamentto, gimbbiyaan diretti utteeddenttonne direttibeennentto, ");
INSERT INTO dwrl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","biittay ay mala tu'enttonttonne ladentto, he gadiyaan mitsay de'inttonne baawentto be'ite. Minnite! He gadiyaan mokkeeddawaa ayifiyaappe akkenan yooppite» yaageedda. He wodii woyniyaa turay koyiro ayfiyaa ayifiyaa wode. ");
INSERT INTO dwrl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Unttunttu pude kesiide, S'iina giyaa mela biittaappe doommiide, biide Hamaata Pinuwaa matan de'iyaa Rahooba gakkanaw he biittaa wochcheeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Neegeeba pude kesiide, Kebroona gakkeeddino; hewan Ahimaana, Sheshaayanne Talmmaaya geetettiyaa Anaak'e zaratuu de'iino. Kebrooni Gibs'en de'iyaa S'o'aane katamaappe laappun laytsaa kaseti kees'etteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Hewaana aad'd'iidde, Unttunttu Eshkkoola giyaa zanggaaraa biide gakkeedda wode, woyniyaa turaa ittuwaappe itti wurc'c'uwaanna de'iyaa itti tashiyaa k'ans's'eeddino; unttunttuppe laa\"u kasuwaa gidduwaan gelissi tookkeeddino. Hewaana roomaaniyaanne balasiyaa giyaa mitsatuwaa ayfiyaa aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Israa'eeliyaa asatuu hewaappe k'ans's'eedda woyniyaa turaa wurc'c'uwaa diraw, he sa'aa Eshkkoola Zanggaaraa giide s'eeseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Unttunttu he biittaa wochchiidde, oytamu gallassaappe guyyiyaan simmeeddino; ");
INSERT INTO dwrl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Paaraana Mela Biittaan K'aadeesa giyaa saan de'iyaa Musekko, Aaroonekkonne Israa'eeliyaa asaa maabaraa ubbaakko yeeddino. Barenttu be'eeddawaa unttunttoonne asaa ubbaw odeeddino; he gadiyaan ayifiyaa ayfiyaakka unttuntta besseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Unttunttu Musew hawaadan yaagiide odeeddino; «Neeni nuuna kiitteedda biittaa nuuni beeddo; he gadiyaan maatsaynne eessay goggee. Aan ayifiyaa ayfiyaakka hawaa be'a. ");
INSERT INTO dwrl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Shin he gadiyaan de'iyaa Asay wolk'k'aama; unttunttu katamaykka gimbbiyaa dirssaan diretti utteeddawaanne wolk'k'aama. Nuuni k'ay Anaak'e zaratuwaa yan be'eeddo. ");
INSERT INTO dwrl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Neegeeba Amaaleek'a asatuu de'iino; gezziyaan Hiitetuu, Yaabuusatuunne Amooratuu de'iino; k'ay Kanaanetuu Meediteraane Abbaa doonaaninne Yorddaanoosa Shaafaa gas'aan de'iino» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaaleebi asaa Muse sintsan c'o\"u giissiide, «Nuuni tumu s'oonanaw danddayiyaa diraw, pude ha\"i kesiide, he biittaa oliide ane oyk'k'oytte» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Shin Kaaleebena pude beedda asatuu, «He biittaa Asay nuuppe minniyaa diraw, nuuni unttuntta s'oonanaw danddayokko» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Unttunttu yuuyyi wochcheedda biittaa Israa'eeliyaa asaw hawaadan giide, iita oduwaa odeeddino, «Nuuni wochcheedda biittay barenan de'iyaa asaakka miyaawaa; Asay ubbaykka loytsi adussa. ");
INSERT INTO dwrl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nuuni wogga adussa asatuu yara gidiyaa Anaak'e zaratuwaa yan be'eeddo; nuuni nu ayifiyaan nuuna s'eelliyaa wode bumbburetsaa malateetto; k'ay nuuni unttunttu ayifiyaan hewaakka mala» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","He gallassaa k'amma maabaray ubbay barenttu k'aalaa d'ok'k'issiide yeekkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israa'eeliyaa Asay ubbay Muse bollanne Aaroona bolla zuuzummeeddino. Maabaray kumentsay unttuntta, «Nuuni Gibs'e gadiyaan de'iidde hayk'k'eeddawaa gideerokko! Woy nuuni ha mela biittaan hayk'k'eeddawaa gideerokko! ");
INSERT INTO dwrl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mashshaan nuuna wod'i wurssanaw Med'inaa Goday ha biittaa nuuna ayaw ahii? Nu machchetuunne nu naanay omoodettana. Hewaappe guyye Gibs'e biittaa simmiyaawe nuw keekenneeyye?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","K'ay unttunttu ittuu ittuwaa, «Nuuni kaaletsiyaawaa dooriide, guyye Gibs'e simmeetto» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musenne Aarooni hewan shiik'eedda Israa'eeliyaa asaa maabaraa ubbaa sintsan som\"uwaa sa'aan gatsiide guufanneeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","He biittaa wochcheedda asatuu giddoppe Neewe na'ay Iyyaasunne Yifune na'ay Kaaleebi barenttu mayuwaa peed'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Israa'eeliyaa asaa maabaraa ubbaw, «Nuuni kantsi kesiide wochcheedda biittay loytsi daro lo\"a. ");
INSERT INTO dwrl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Med'inaa Goday nuunan nashettiyaawaa gidooppe, maatsaynne eessay goggiyaa he biittaw nuuna I gelissana; he biittaa nuw I immana. ");
INSERT INTO dwrl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Hewaa diraw, Med'inaa Godaa bolla makkalaa makkaloppite. He biittaa asaw yayyoppite; unttunttu nuw haatsaa ushshakka gakkikkino. Unttunttoo ambboomiyaawe baawa; shin Med'inaa Goday nuunana de'ee. Hintte unttunttoo yayyoppite!» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Maabaray ubbay unttuntta shuchchaan c'addanaw haasayeeddino. He wode Med'inaa Godaa bonchchuu Gaketiyaa Dunkkaaniyaan Israa'eeliyaa asaa ubbaw k'onc'c'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Med'inaa Goday Musa, «Ha Asay awude gakkanaw taana kad'anee? Taani unttunttu gidduwaan ootseedda malaataa ubbaa be'iide, awude gakkanaw unttunttu taanan ammanennan is's'anee? ");
INSERT INTO dwrl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Taani unttuntta iita harggiyaan shoc'aade d'ayissana; yaataade taani neena unttunttuppe dariyaanne minniyaa kawutetsaw aawuwaa ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Muse Med'inaa Godaa hawaadan yaagiide woosseedda; «Neeni ne wolk'k'an ha asaa Gibs'eppe pude kesseeddawaa eriyaa Gibs'etuu hawaa sisooppe, unttunttu waaganee? ");
INSERT INTO dwrl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Unttunttu ha gadiyaan de'iyaawanttookka hewaa odana. Abeet Med'inaa Godaw, neeni ha asaa gidduwaan de'iyaawaa unttunttu siseeddino. Abeet Med'inaa Godaw, nuuni neena be'eeddawaa unttunttu ereeddino; ne shaarii unttunttuppe bollana takkiyaawaanne gallassi shaariyaa tuussaan, k'amma tamaa tuussaan neeni unttunttu sintsan biyaawaa be'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ha\"i neeni ha asaa ubbaa itti kutsan wod'iyaawaa gidooppe, ne kase ootseeddawaa siseedda kawutetsatuu, ");
INSERT INTO dwrl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Med'inaa Goday ha asaa, ‹Hinttew immana giide c'aak'k'eedda biittaa unttuntta afanaw danddayibeenna diraw, mela biittaan unttuntta wod'eedda› yaagiide haasayana. ");
INSERT INTO dwrl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","18","«Hewaa diraw, Godaw, neeni ne wolk'k'aa nuuna bessa; neeni gaade, ‹Med'inaa Goday danddayanchchanne aggena siik'uwaan kumeeddawaa; nagaraanne makkalaa atto giyaawaa; gidooppenne, bayzzanchchaa murenan aggenawaa; aawotuwaa nagaraa diraw naanatuwaa heezzentsanne oyddentso yeletaa gakkanaw muriyaawaa› gaade oda wotseeddawaa pola. ");
INSERT INTO dwrl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ha Asay Gibs'eppe kesoodeppe doommaade hachchi gakkanaw neeni atto geeddawaadan, ne aggena siik'uwaa daruwaan ha asaa nagaraa atto gaarikkii!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Med'inaa Goday Musa, «Neeni oochcheeddawaadan taani unttunttoo atto gaad. ");
INSERT INTO dwrl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Shin ta de'uwaan c'aak'k'ay; Med'inaa Godaa bonchchuu sa'aa ubbaa kumiyaawaadan, ");
INSERT INTO dwrl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","ha asaappe ittuunne he biittaa be'enna. Ta bonchchuwaanne Gibs'e biittaaninne mela biittaa taani ootseedda malaataa ha asatuu be'eeddino; shin unttunttu tammu gede taana paac'c'eeddinonne ta k'aalaa sisennan is's'eeddino. Hewaa diraw, taani unttunttu mayzza aawaatoo immana gaade c'aak'k'eedda biittaa taana kad'eeddawanttuppe ittuunne mulekka be'enna. ");
INSERT INTO dwrl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Shin ta k'oomay Kaaleebi unttunttuppe dummatiyaa dirawunne I taana polo wozanaappe kaalleedda diraw, taani I kase beedda biittaa Aa gatsana; Aa zeretsay he biittaa laattana. ");
INSERT INTO dwrl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Shin ha\"i Amaaleek'atuunne Kanaanetuu zanggaaraan de'iyaa diraw, wontti guyye simmiide, Zo'o Abbaakko afiyaa ogiyaa oyk'k'iide mela biittaa biite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","K'ay Med'inaa Goday Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Ha iita Asay ta bolla awude gakkanaw zuuzummanee? Taani Israa'eeliyaa asaa zuuzuntsaa ubbaa sisaad. ");
INSERT INTO dwrl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Hewaa diraw, neeni unttunttoo hawaadan yaagaade oda; ‹Ta de'uwaan c'aak'k'ay; taani hintte haasayishin ta haytsaan siseeddawaa hinttenttoo ootsana. Taani Med'inaa Goday hewaa oday. ");
INSERT INTO dwrl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Hintte anhay ha mela biittaan kunddana; ayaw gooppe, asaa paydiyaa wode paydeteedda laatamu laytsanne hewaappe bollana de'iyaa Asay ubbay ta bolla zuuzummeeddita. ");
INSERT INTO dwrl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Yifune na'aa Kaaleebappenne Neewe na'aa Iyyaasuppe attina, hintteppe ooninne taani hinttena wotsanaw c'aak'k'eedda he biittaa gelenna. ");
INSERT INTO dwrl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Hintte, «Nu naanay omoodettana» geedda hintte guutsaa naanatuwaa he hintte kad'eedda biittaa gelissana; biittaykka unttunttussa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Shin hinttena gidooppe, hintte anhay ha mela biittaan kunddana. ");
INSERT INTO dwrl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Hintte ammanettibeenna diraw, hintte wurssetsa anhay ha mela biittaa wullana gakkanaw, hintte naanay waayettiidde, ha mela biittaa oytamu laytsaa hentsanchchaa gidiide yuuyyana. ");
INSERT INTO dwrl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Hintte he biittaa wochcheedda he oytamu gallassaa payduwaan, itti gallassaw itti laytsaa, hewenne, oytamu laytsaw hintte nagaraa diraw hintte waayettana; taani hintte bolla denddiyaawaa hintte erana› yaaga oda. ");
INSERT INTO dwrl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Taani Med'inaa Goday hawaa oday. Ta bolla shiik'i utteedda ha iita maabaraa bolla hawaadan tumu ootsana: unttunttu ha mela biittaan wurana; hawaan unttunttu hayk'k'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","He biittaa wochchana mala, Muse unttuntta kiittina biide simmeedda asatuu, he biittaa iita oduwaa odiide, Muse bolla Asay ubbay zuuzummana mala ootseeddawanttu, ");
INSERT INTO dwrl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","he iita oduwaa odeedda asatuu, Med'inaa Godaa sintsa boshaan hayk'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","He biittaa wochchanaw beedda asatuwaappe Yifune na'ay Kaaleebinne Neewe na'ay Iyyaasu s'alalay pas'a atteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Muse hawaa Israa'eeliyaa asaw ubbaw odeedda wode, Asay loytsi yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Wonttetsa gallassi wontta guuran unttunttu denddiide, pude gezze biittaa kesiide, «Nuuni nagaraa ootseeddo; shin ha\"i S'oossay nuw immana geedda sa'aa pude kesana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Shin Muse unttuntta, «Med'inaa Godaa azazuwaa hintte ayaw mentsiitee? Hinttew hanenna. ");
INSERT INTO dwrl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Med'inaa Goday hinttenana de'enna diraw, pude kesoppite; hintte morkketuu hinttena s'oonana. ");
INSERT INTO dwrl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amaaleek'a asatuwaananne Kanaane asatuwaana hintte olettana; hintte mashshaan hayk'k'ana. Med'inaa Godaappe hintte wora simmeedda diraw, Med'inaa Goday hinttenana de'enna» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Shin unttunttu Med'inaa Godaa C'aak'uwaa Taabootaynne Musenne dunkkaaneedda sa'aappe denddana d'ayooppekka, gezze biittaa kesanaw s'aliide denddeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Gezze gadiyaan de'iyaa Amaaleek'a asatuunne Kanaane asatuu wod'd'iide unttunttu olay s'ooniide, Horima gakkanaw unttuntta yedersseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Israa'eeliyaa asaw hawaadan yaaga; ‹Hintte de'ana mala, taani hinttenttoo immiyaa biittaa geliyaa wode, ");
INSERT INTO dwrl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mehiyaappe woy dorssaappe, s'uuggiyaa yarshshuwaa gidina, woy shiik'k'owaa gatsanaw yarshshiyaa yarshshuwaa gidina, woy Med'ina Goday keereedda baala gallassatuwaan hintte dosuwaan c'oo immiyaa yarshshuwaa gidina, Med'inaa Godaw taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshotuwaa yarshshite. ");
INSERT INTO dwrl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Yarshshuwaa shiishshiyaa uray katsaa yarshshoo itti kiilo giraame d'iiliyaa itti liitiro wogaraa zayitiyaan munak'k'eeddawaakka Med'inaa Godaw aho. ");
INSERT INTO dwrl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","K'ay s'uuggiyaa yarshshoo, woy hara yarshshoo ahiyaa itti itti dorssaanna itti liitiro woyniyaa eessaa ushshaa yarshshuwaa ootsiide giigissite. ");
INSERT INTO dwrl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","« ‹Dorssa orggiyaa yarshshanaw shiishshiyaa wode, katsaa yarshshoo laa\"u kiilo giraame d'iiliyaa itti liitironne bagga wogaraa zayitiyaan munak'k'eeddawaanne ");
INSERT INTO dwrl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","itti liitironne bagga woyniyaa eessaa ushshaa yarshshoo ahite. Med'inaa Godaw sawuwaa toshukku giyaa yarshshuwaa yarshshite. ");
INSERT INTO dwrl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","« ‹Itti korumaa s'uuggiyaa yarshshuwaa, woy shiik'uwaa gatsiyaa yarshshuwaa, woy ittippetetsaa yarshshuwaa ootsiide yarshshanaw Med'inaa Godaw ahiyaa wode, ");
INSERT INTO dwrl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","korumaanna ittippe katsaa yarshshoo heezzu kiilo giraame d'iiliyaa laa\"u liitiro wogaraa zayitiyaan munak'k'eeddawaanne ");
INSERT INTO dwrl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ushshaa yarshshoo laa\"u liitiro woyniyaa eessaakka ahite. Med'inaa Godaw sawuwaa toshukku giyaa yarshshuwaa taman yarshshite. ");
INSERT INTO dwrl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","« ‹Itti itti korumaa booraa, woy itti itti dorssaa orggiyaa, woy yalaga deeshshaa orggiyaa, woy attuma dorssaa maraa yarshshanaw shiishshiyaa wode, katsaa yarshshuunne ushshaa yarshshuu hawaadan ittippe shiik'ee. ");
INSERT INTO dwrl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Itti mehiyaappe daruu shiik'iyaa wode, katsaa yarshshuunne ushshaa yarshshuu hewaadan dariide shiik'ee. ");
INSERT INTO dwrl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Israa'eeliyaa asaa gidiyaa ooninne taman s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa Med'inaa Godaw shiishshiyaa wode ubbaan, hawaadan ootsanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Sintsappe yaana yeletaan hintte giddon de'iyaa betii woy hara Asay ooninne s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa Med'inaa Godaw shiishshanaw koyooppe, ikka hintte ootsiyaawaadan ootsanaw koshshee. ");
INSERT INTO dwrl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Hinttewukka hintte giddon de'iyaa betetookka ha wogay ittuwaa; hawe sintsaappe yaana yeletawukka ek'k'iide de'iyaa woga. Hinttekka betetuukka Med'inaa Godaa sintsan ittuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Hinttewukka hintte giddon de'iyaa bete asatookka higgiinne wogay ittuwaa gidana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Hewaappe guyyiyaan, Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Taani hinttena afiyaa biittaa hintte geliide, ");
INSERT INTO dwrl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","he gadiyaan mokkiyaa katsaa miyaa wode, he katsaappe s'eeraa kessiide, hintte Med'inaa Godaw yarshshuwaa ootsiide shiishshite. ");
INSERT INTO dwrl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Hewekka, bayira ka\"eedda katsaappe uukkeedda koyiro komppuwaa, katsaa bukkiyaa uddumaappe immiyaa yarshshuwaa ootsiide shiishshite. ");
INSERT INTO dwrl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Yaana yeletaa ubbaan hintte hintte gadiyaan mokkeedda katsaappe s'eeraa Kesseedda komppuwaa, Med'inaa Godaw yarshshuwaa ootsiide shiishshite. ");
INSERT INTO dwrl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","« ‹Med'inaa Goday odeedda ha azazotuwaa ubbaa hintte erana d'ayiide, naagennan aggooppe, ");
INSERT INTO dwrl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Med'inaa Goday Aa baggana hinttena azazeedda azazotuwaa ubbaa, Med'inaa Goday immeedda gallassaappe doommiide, yaana yeletaa gakkanaw, pac'c'ennan naagennan aggooppe, ");
INSERT INTO dwrl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","k'ay hewaa maabaray erennan ootseeddawaa gidooppe, maabaray ubbay Med'inaa Godaw itti korumaa s'uuggiyaa, sawuwaa toshukku giyaa yarshshuwaa ootsiide, aw wogay azaziyaawaadan, katsaa yarshshuwaananne ushshaa yarshshuwaanna shiishsho; k'ay nagaraa yarshshuwaa ootsiide, itti deeshshaa orggiyaa shiishsho. ");
INSERT INTO dwrl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Yaatooppe k'eesii kumentsaa Israa'eeliyaa maabaraa nagaraa atto giissiyaa wogaa polo; unttunttu nagaray atto geetettana. Ayaw gooppe, unttunttu eriidde ootsibeykkino; k'ay unttunttu barenttu bayzzuwaa diraw, Med'inaa Godaw taman s'uuggiyaa yarshshuwaanne barenttu nagaraa yarshshuwaa shiishsheeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Asay ubbay erennan he bayzzuwaan hambbalaachchetteedda diraw, kumentsaa Israa'eeliyaa maabarawukka unttunttu giddon de'iyaa bete asawukka atto geetettana. ");
INSERT INTO dwrl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","« ‹Itti Asay barekka erana d'ayiide nagaraa ootsooppe, yelettoodeppe itti laytsaa gidiyaa itti deeshshatto nagaraa yarshshuwaa ootsiide shiishsho; ");
INSERT INTO dwrl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","erennan de'iidde nagaraa ootseedda uraw k'eesii Med'inaa Godaa sintsan nagaraa atto giissiyaa wogaa polo; Aa nagaray atto geetettana. ");
INSERT INTO dwrl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Erennan de'iidde nagaraa ootsiyaa asaa ubbaw, yeletaan Israa'eeliyaa asaa gidinakka bete asaa gidinakka ha higgii ittuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","« ‹Shin yeletaan Israa'eeliyaa asaa gidinakka bete asaa gidinakka eriidde otoruwaan nagaraa ootsiyaa uray Med'inaa Godaa boree. He uray bare asaa giddoppe bohetto. ");
INSERT INTO dwrl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","He aawuu Med'inaa Godaa k'aalaa kad'eedda dirawunne Aa azazuwaa mentseedda diraw, I tumuwaappe asaa gidoppe bohettanaw besse; Aa bayzzuu aana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Itti gallassi Israa'eeliyaa Asay mela biittaa de'ishshin, itti bitanii Sambbatan mitsaa mis'iidde beetteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Mitsaa I mis'ishin demmeedda asatuu Musekko, Aaroonekkonne kumentsaa shiik'uwaakko Aa aheeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Unttunttu Aa ootsanawaa eribeenna diraw, k'ashuwaan takkisseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Hewaappe guyyiyaan Med'inaa Goday Musa, «Ha bitanii hayk'k'anaw besse; kumentsaa yaa'ay barenttu dunkkaaneedda sa'aappe gas'aa kessiide, shuchchaan c'addiide Aa wod'o» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Kumentsaa yaa'ay Med'inaa Goday Musa azazeeddawaadan, dunkkaaneedda sa'aappe gas'aa kessiide, shuchchaan c'addiide Aa wod'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Israa'eeliyaa asaw hawaadan yaagaade oda; ‹Hinttekka sintsaappe yaana yeletaykka hintte mayuwaa gas'aa s'eeran s'eeran mac'araa kessite; he mac'araa bolla saluwaa malatiyaa k'ac'inaa sikkite. ");
INSERT INTO dwrl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","He mac'araa hintte be'iyaa wode ubbaan Med'inaa Godaa azazotuwaa hassayiide polite; yaatooppe, hintte hintte ayifiyaanne hintte wozanaa amuwaa kaalliide, taappe wora simmikkita. ");
INSERT INTO dwrl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","He mac'araa be'iyaawaan hintte ta azazotuwaa ubbaa hassayiide polananne hintte hintte S'oossaw geeshsha gidana. ");
INSERT INTO dwrl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Taani Med'inaa Godaa, hintte S'oossaattee; taani hintte S'oossaa gidanaw, hinttena Gibs'eppe kessaad. Taani Med'inaa Godaa, hintte S'oossaa› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Leewiyaa zariyaappe K'ahaata yara gidiyaa Yis'ihaara na'ay K'oraahi, Roobeela zariyaappe Eli'aaba naanay Daataaninne Abiiraaminne k'ay Peleeta na'ay Oonis, ");
INSERT INTO dwrl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Muse bolla denddeeddino. Unttunttunna laa\"u s'eetanne ishatamu Israa'eeliyaa asatuu de'iino; unttunttu eretteedda asanne maabaran dooretteedda kaaletsiyaawantta. ");
INSERT INTO dwrl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Unttunttu Musenne Aaroona sintsa shiik'iide, hawaadan yaageeddino; «Hintte darisseeddita! Maabaray ubbay huup'iyaan huup'iyaan geeshsha; Med'inaa Godaykka unttunttu gidduwaan de'ee; yaatina Med'inaa Godaa maabaraa bolla hinttena ayaw d'ok'k'u d'ok'k'u ootsiitee?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Muse hawaa siseedda wode S'oossaa sintsan sa'aan guufanneedda; ");
INSERT INTO dwrl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","K'oraahanne Aa c'itaa ubbaa, «Wontti wontta Med'inaa Goday ooni nagaranchchenttonne ooni geeshshentto bessana; I he dooriyaa asaa barekko shiishshana. ");
INSERT INTO dwrl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","K'oraaha, neeninne ne c'itay ubbay hawaa ootsite: wontti is'aanaa c'uwayiyaawantta akkiide, ");
INSERT INTO dwrl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","bonk'k'uwaa aan wotsiide, Med'inaa Godaa sintsan is'aanaa c'uwayite. Med'inaa Goday dooriyaa asay, I geeshsha gidanawaa. Leewiyaa zaretoo, hintte darisseeddita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Muse k'aykka K'oraaha, «Hinttenoo Leewiyaa zaretoo, sisite! ");
INSERT INTO dwrl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Israa'eeliyaa Med'inaa Goday hinttena Israa'eeliyaa maabaraappe dummayiide, Med'inaa Godaa Dunkkaaniyaa oosuwaa ootsana malanne asaa sintsan he oosuwaa ootsanaw hintte ek'k'ana mala, barekko shiishsheeddawe hinttenttoo guus's'eeddee? ");
INSERT INTO dwrl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","I hinttenanne hintte ishatuwaa Leewatuwaa ubbaa barekko shiishsheedda; k'ay ha\"i hintte k'eesetetsaakka kajjeeliita. ");
INSERT INTO dwrl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Neeninne ne c'itay ubbay Aaroona bolla zuuzummiyaawe, I oonee? hinttenttu Med'inaa Godaa bolla makkaliita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Hewaappe guyyiyaan, Muse kiittiide Eli'aaba naanatuwaa, Daataananne Abiiraama s'eesisseedda; shin unttunttu Aa, «Nuuni bookko! ");
INSERT INTO dwrl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Neeni mela biittaan nuuna wod'anaw maatsaynne eessay goggiyaa gadiyaappe kesseeddawe guus's'eeddee? K'ay ha\"i neeni nu bolla kaappuwaa gidanaw koyay? ");
INSERT INTO dwrl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Hewaa bollakka k'ay maatsaynne eessay goggiyaa biittaa neeni nuuna gelissabaakka, woy neeni nuw laata ootsaade gadiyaanne woyniyaa turaa immabaakka; neeni ha asaa c'immaasa. Nuuni bookko!» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Muse loytsi hank'k'ettiide Med'inaa Godaa, «Unttunttu yarshshiyaa yarshshuwaa akkoppa; taani unttunttuppe hariyaa ittuwaanne akkabeyikke, woy taani unttunttuppe itti asanne naak'k'abeykke» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","K'ay Muse K'oraaha, «Wontti neeni, ne c'itay ubbaynne Aarooni Med'inaa Godaa sintsan gidite. ");
INSERT INTO dwrl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Itti itti Asay bare is'aanaa c'uwayiyaawaa ubbaanna laa\"u s'eetanne ishatamuwaa akkiide, is'aanaa aan wotsiide, Med'inaa Godaa sintsa shiishsho. K'ay neeninne Aarooni hintte is'aanaa c'uwayiyaawantta ahite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Asay ubbaykka bare is'aanaa c'uwayiyaawaa akkiide, bonk'k'uwaanne is'aanaa aan wotseedda; Gaketiyaa Dunkkaaniyaa penggiyaan Musenanne Aaroonana ek'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","K'oraahi kumentsaa maabaraa Gaketiyaa Dunkkaniyaa penggiyaan shiishsheedda. He wode Med'inaa Godaa bonchchuu kumentsaa maabaraw k'onc'c'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Med'inaa Goday Musanne Aaroona, ");
INSERT INTO dwrl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Taani itti kutsan ha maabaraa d'ayissana haniyaa diraw, unttunttuppe shaakettite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Shin Musenne Aarooni sa'aan guufanniide, «Abeet S'oossaw, ashuwaa mayyeedda asaa ubbaa med'd'eedda S'oossaw, itti uray nagaraa ootsooppe, neeni kumentsaa maabaraa hank'k'ettay?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yaatina Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Neeni maabaraa, ‹K'oraaha, Daataananne Abiiraama dunkkaanetuwaappe kichchite› yaagaade oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Muse denddiide, Daataanekkonne Abiiraamekko biina, Israa'eeliyaa c'imatuu Aa kaalleeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Maabaraa I, «Ha iita asatuu dunkkaanetuwaappe kichchite; unttunttuwaa gideeddawaa ayaanne bochchoppite. Henkkoode unttunttu nagaraa ubbaa gaasuwaan hinttekka pitetti d'ayana» yaagiide minisiide odeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Unttunttu K'oraaha, Daataananne Abiiraama dunkkaanetuwaappe kichcheeddino. Daataaninne Abiiraami kare kesiide, barenttu machchetuwaanna, barenttu naanatuwaanna barenttu guutsaa naanatuwaanna barenttu dunkkaanetuwaa penggiyaan ek'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Muse asaa, «Taani ha ooso ubbaa ootsana mala, Med'inaa Goday taana kiitteeddawaanne taani ta sheniyaan ootsennawaa hintte hawaan erana. ");
INSERT INTO dwrl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ha asatuu Asay hayk'k'iyaawaadan hayk'k'ooppe, woy asaa bolla gakkiyaawaa s'alalay unttunttu bolla gakkooppe, Med'inaa Goday taana kiittibeenna. ");
INSERT INTO dwrl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Shin Med'inaa Goday ubbaanna ooratsabaa ootsina, biittay dooyettiide unttunttanne unttunttoo de'iyaawaa ubbaa mitti aggooppe, unttunttu pas'a de'iidde Si'ooliyaa duge wod'ooppe, he wode ha asatuu Med'inaa Godaa kad'eeddawaa hintte erana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","I yaagiide wursseedda wode, unttunttu ek'k'eedda biittay p'alk'k'etti wod'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Biittay dooyettiide, unttunttanne unttunttu soo asaa, K'oraaha c'itaa ubbaa unttunttoo de'iyaawaa ubbaanna mitti aggeeda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Yaatina unttunttu barew de'iyaawaa ubbaanna pas'a de'iidde, Si'ooliyaa duge wod'd'eeddino. Biittaykka unttunttu bolla gorddetti aggeeda; unttunttu maabaraa giddoppe tippi giide d'ay aggeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Unttunttu waasuwaan unttunttu matan de'iyaa Israa'eelatuu ubbay, «Biittay nuunakka k'ay mittana hanee!» yaagiid bak'ateeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","K'ay tamaykka Med'inaa Godaa mataappe yiide, is'aanaa c'uwayiyaa laa\"u s'eetanne ishatamu asaa mi aggeeda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Hewaappe guyyiyaan Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«Neeni k'eesiyaa Aaroona na'aa El\"aazaraw yaagaade oda, ‹Is'aanaa c'uwayiyaabatuwaa taman s'uugetteedda asaa giddoppe akka; bonk'k'uwaa c'uwayiyaabatuwaappe haassaade laala. He is'aanaa c'uwayiyaabatuu geeshsha. ");
INSERT INTO dwrl_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Bare nagaraa diraw hayk'k'eedda ha asatuu is'aanaa c'uwayiyaabatuwaa lee'issaade k'os's'aade, yarshshuwaa saas'iniyaa kamma. Unttunttu hewantta Med'inaa Godaa sintsan shiishsheedda diraw, hewanttu geeshsha; hewanttu Israa'eelatuwaa hassayissiyaa malaataa gidana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","K'eesii El\"aazari s'uugetteedda asatuu shiishsheedda nahaase birataappe oosetteedda is'aanaa c'uwayiyaabatuwaa akkiide, yarshshuwaa saas'iniyaa kammanaw lee'issiide k'os's'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Aaroona zare gidenna ooninne Med'inaa Godaa sintsan is'aanaa c'uwayanaw shiik'enna mala, K'oraahanne Aa c'itaa gakkeeddawe Aa gakkenna mala, Israa'eelatuwaa hassayissanaw hawantta ootseedda. Med'inaa Goday Muse baggana El\"aazara azazeeddawaadan hawe haneedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Wonttetsa gallassi Israa'eeliyaa maabaray ubbay, «Med'inaa Godaa asaa hintte wod'eeddita» yaagiide, Muse bollanne Aaroona bolla zuuzummeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Maabaray Musenne Aaroona bolla denddanaw shiik'iide, Gaketiyaa Dunkkaaniyaakko simmi s'eelliyaa wode, shaarii Gaketiyaa Dunkkaaniyaa kammina, Med'inaa Godaa bonchchuu k'onc'c'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Hewaappe guyyiyaan, Musenne Aarooni Gaketiyaa Dunkkaaniyaa sintsaw yeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«Ha asaa gidduwaappe kichchite; taani unttuntta itti kutsan d'ayissa bashana» yaageedda. Unttunttu sa'aan guufanneeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Muse Aaroona, «Ne is'aanaa c'uwayiyaawaa akkaade, bonk'k'uwaa yarshshiyaa sa'aappe akkaade, is'aanaa aan wotsa; unttunttoo atto giissanaw ellekka maabaraakko afa. Ayaw gooppe, Med'inaa Godaa hank'k'uu Aa mataappe kesi kichcheedda; boshaykka doommi kichcheedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Muse geeddawaadan Aarooni bare is'aanaa c'uwayiyaawaa akkiide, maabaraa giddo wos's'eedda. Boshay asaa gidduwaan doommi de'ishin, Aarooni is'aanaa c'uwayiide, asaw atto giisseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Yaatiide I hayk'k'eeddawanttuppenne pas'a de'iyaawanttuppe gidduwaan ek'k'ina, boshay aggi aggeeda. ");
INSERT INTO dwrl_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","K'oraaha gaasuwaan hayk'k'eedda Asay paydettenan, ha boshaan hayk'k'eeddawanttu 14,700. ");
INSERT INTO dwrl_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Boshay ek'k'eeddawaappe guyyiyaan, Aarooni Gaketiyaa Dunkkaaniyaa penggiyaan de'iyaa Musekko simmeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Neeni, ‹Hintte zariyaan zariyaan hintte kaappatuwaappe huup'iyaan huup'iyaan itti itti s'am\"aa ubbaanna tammanne laa\"u s'am\"aa taw immite› yaagaade Israa'eelatuwaappe akka. Itti itti asaa suntsaa s'am\"aa bollan s'aafa. ");
INSERT INTO dwrl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Itti itti zariyaa kaappoo itti s'am\"aa gidiyaa diraw, Leewiyaa s'am\"an Aaroona suntsaa s'aafa. ");
INSERT INTO dwrl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Gaketiyaa Dunkkaaniyaa giddon taani neenana gaketiyaa Markkatetsaa Taabootaa sintsan wotsa. ");
INSERT INTO dwrl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Taani dooriyaa asaa s'am\"ay aac'ana; hawaadan ootsaade hintte bollan Israa'eelatuu zuuzummiyaa zuuzuntsaa taani mule d'ayissana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Muse Israa'eeliyaa asaw odina, unttunttu kaappatuu tammanne laa\"u s'am\"atuwaa, itti itti zariyaa kaappatuu itti itti s'am\"aa aw immeeddino. He s'am\"atuwaa gidduwaan Aaroona s'am\"aykka de'ee. ");
INSERT INTO dwrl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Muse he s'am\"aa ubbaa Markkatetsaa Dunkkaaniyaa giddon Med'inaa Godaa sintsan wotseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Wonttetsa gallassi Markkatetsaa Dunkkaaniyaa giddo Muse geleedda wode, Leewiyaa zare gidiyaa Aaroona s'am\"ay aac'eeddawaa, gumbbeeddawaa, c'iisheeddawaanne c'iishiide lawuziyaa giyaa mitsaa ayfiyaa ayifeeddawaa be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Hewaappe guyyiyaan, Muse s'am\"aa ubbaa Med'inaa Godaa sintsaappe Israa'eeliyaa asaa ubbaakko aheedda. Asay unttuntta be'eeddawaappe guyyiyaan, kaappatuu barenttu s'am\"aa s'am\"aa akkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Med'inaa Goday Musa, «Aaroona s'am\"aa Taabootaa sintsan zaara wotsa. Hewaa makkaleeddawanttu ta bolla laa\"entso zuuzummiide hayk'k'ennaadan, unttunttoo malaataa ootsaade naaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Med'inaa Goday azazeeddawaadan Muse ootseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israa'eeliyaa Asay Musa, «Nuuni hayk'k'ana; d'ayana; nuuni ubbaykka d'ayana! ");
INSERT INTO dwrl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Med'inaa Godaa Dunkkaaniyaakko, haray atto mataa shiik'iyaa uray ooninne hayk'k'ana. Simmi nuuni ubbaykka hayk'k'eettoo?» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Med'inaa Goday Aaroona, «Neeni, ne attuma naanatuunne Leewatuu geeshsha sa'aa oosuwaan polettiyaa nagaraa tookkana; neeninne ne attuma naanatu s'alalay hintte k'eesetetsaa oosuwaan polettiyaa nagaraa tookkana. ");
INSERT INTO dwrl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Neeninne ne attuma naanay Markkatetsaa Dunkkaaniyaa sintsan ootsiyaa wode, neenana gidiide maaddana mala, Leewiyaa zare gidiyaa ne dabbotuwaa aha. ");
INSERT INTO dwrl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Unttunttu hintteppe garssana Dunkkaaniyaa ooso ubbaa ootsino; shin unttunttukka hinttekka ittippe hayk'k'ennaadan, unttunttu geeshsha sa'aa miishshaakkonne yarshshiyaa saakko shiik'oppino. ");
INSERT INTO dwrl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Unttunttu hinttenana ittippe gidino; Gaketiyaa Dunkkaaniyaan de'iyaa ooso ubbaa ootsino. Leewatuwaappe attina, hara uray ooninne hinttekko shiik'oppo. ");
INSERT INTO dwrl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Laa\"entsuwaa Israa'eelatuwaa bolla hank'k'uu wod'd'enna mala, geeshsha sa'aanne yarshshiyaa sa'aa oosuwaa ootsite. ");
INSERT INTO dwrl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Leewatuwaa hintte dabbotuwaa Israa'eelatuwaa giddoppe taani ta huup'iyaw dooraad. Unttunttu Gaketiyaa Dunkkaaniyaa oosuwaa ootsanaw hinttenttoo imuwaadan immaade, Med'inaa Godaw dummayaad. ");
INSERT INTO dwrl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Shin neeninne ne attuma naanatu s'alalay yarshshiyaa sa'aa oosuwaa ubbaanne gaariduwaa giddon de'iyaa k'eesetetsaa ooso ubbaa ootsite. K'eesetetsaa oosuwaa taani hinttenttoo imuwaadan ootsaade immay; hara uray ooninne geeshsha sa'aakko shiik'iyaawe hayk'k'o» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Hewaappe guyyiyaan Med'inaa Goday Aaroona, «Israa'eelatuu taw immiyaa geeshsha imotaa ubbaa taani new immaad. Taani new ne dirawunne ne attuma naanaw unttunttu diraw med'inaw gishsha ootsaade immaaddi. ");
INSERT INTO dwrl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Taw immiyaa aad'd'eeda geeshsha imuwaappe taman s'uugettenna baggay hinttessa gidanawaa: unttunttu taw immiyaa geeshsha imuwaa ubbaappe katsaa yarshshuu, woy nagaraa diraw yarshshiyaa yarshshuu, woy naak'uwaa diraw yarshshiyaa yarshshuu neessanne ne attuma naanatuwaassa gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Hintte hewaa geeshsha sa'aan miite; attumawe ubbay hewaa mo; hewe hinttew geeshsha gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«Hawe k'ay neessa. Israa'eelatuwaa k'aatso yarshshuwaa ubbaa new, ne attuma naanatoonne ne mac'c'a naanaw med'inaw gishsha ootsaade immay; hintte golliyaa asaa giddon wogaadan geeshsha gidiyaa ubbay hewaa mo. ");
INSERT INTO dwrl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","«Unttunttu taw immiyaa koyiro ayifiyaappe lo\"o wogaraa zayitiyaa ubbaa, yalaga woyniyaa eessaa ubbaanne muruta katsaa ubbaa Med'inaa Godaw immay. ");
INSERT INTO dwrl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Unttunttu Med'inaa Godaw ahiyaa unttunttu gadiyaan de'iyaa koyiro gakkeedda ayfii hinttessa; hintte golliyaa asaa giddon wogaadan geeshsha gidiyaa ubbay hewaa mo. ");
INSERT INTO dwrl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","«Israa'eeliyaan Med'inaa Godaw dummateeddabay ubbay hinttessa. ");
INSERT INTO dwrl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Bayira yeletteedda Asay woy mehii, Israa'eelatuu Med'inaa Godaw immeeddawe hinttessa. Shin bayira yeletteedda asanne bayira yeletteedda geeshsha gidenna mehiyaa hintte wozanaw besse. ");
INSERT INTO dwrl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Itti agenaa naanatuwaa wozanaw Dunkkaaniyaan erettiyaa miizaaniyaa (20 Geera) likkiyaan ichcheshu s'agaraa biraa wozo gatiyaa k'ans's'ite. ");
INSERT INTO dwrl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Shin miizzaa bayiraa, woy dorssaa bayiraa, woy deeshshaa bayiraa hintte wozanaw koshshenna; unttunttu geeshsha. Neeni unttunttu suutsaa yarshshiyaa sa'aa bollan c'ac'c'afa; Med'inaa Godaa toshukku giide sawana mala, unttunttu mod'd'uwaa taman s'uugga. ");
INSERT INTO dwrl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Unttunttuppe beettiyaa ashuu wus'akkeedda anggoosuwaadaaninne ushechcha gediyaadan hinttessa. ");
INSERT INTO dwrl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Israa'eelatuu Med'inaa Godaw immiyaa geeshsha yarshshuwaa ubbaa new, ne attuma naanatoonne ne mac'c'a naanaatoo med'inaw gishsha ootsaade immay. Hawekka Med'inaa Goday neenananne ne zeretsatuwaanna c'aak'k'etiyaa Mas'iniyaa c'aak'uwaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","K'aykka Med'inaa Goday Aaroona, «Unttunttu gadiyaan neeni ayinne laattakka; unttunttu giddon neena gakkiyaa shaakuu ayaykka baawa; Israa'eelatuwaa giddon ne laataynne neena gakkiyaa shaakuu taana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","S'oossay, «Leewatuu Gaketiyaa Dunkkaaniyaan ootsiyaa oosuwaa diraw, Israa'eelatuwaa asiraataa ubbaa unttunttoo immaad. ");
INSERT INTO dwrl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Hachcheppe doommiide, Israa'eeliyaa asatuu barenttu nagaran hayk'k'enna mala, Gaketiyaa Dunkkaaniyaakko shiik'oppino. ");
INSERT INTO dwrl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Gaketiyaa Dunkkaaniyaa oosuwaa ootsiyaawanttunne hewan polettiyaa nagaraa tookkiyaawanttu Leewatuwaa. Hawe yeletaa ubbaw med'inaa wogaa. Leewatuu Israa'eeliyaa asaa gidduwaan ayinne laattikkino. ");
INSERT INTO dwrl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Hewaa diraw, Israa'eelatuu Med'inaa Godaw imuwaadan immiyaa asiraataa, taani Leewatoo unttuntta laataadan immaad. Taani unttunttubaa, ‹Unttunttu Israa'eeliyaa asaa gidduwaan ayinne laattikkino› yaageeddawe hewaassa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","K'ay Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Neeni Leewatuwaa hawaadan yaaga; ‹Taani hinttenttoo laataadan immeedda asiraataa hintte Israa'eeliyaa asaappe akkiyaa wode, hintte he asiraataappe asiraataa Med'inaa Godaw immite. ");
INSERT INTO dwrl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Hintte imuu hinttenttoo katsaa bukkiyaa uddumaa katsaadaaninne gum\"iyaa woyniyaa ayifiyaadan paydettee. ");
INSERT INTO dwrl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","K'ay hawaadan Israa'eeliyaa asaappe hintte akkiyaa asiraataa ubbaappe imuwaa Med'inaa Godaw immite; ha asiraataappe Med'inaa Godaa diraw k'eesiyaa Aaroonaw hintte immanaw besse. ");
INSERT INTO dwrl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Hintte akkiyaa imotaa ubbaappe, lo\"iyaawaanne geeshsha Med'inaa Godaw gishuwaa ootsiide, hintte immanaw bessee› yaaga. ");
INSERT INTO dwrl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","«K'ay neeni Leewatuwaa, ‹Ubbaappe lo\"o imuwaa hintte immeeddawaappe guyyiyaan, atteedawe hinttenttoo katsaa bukkiyaa uddumaa katsaadaaninne gum\"iyaa woyniyaa ayifiyaadan paydetana. ");
INSERT INTO dwrl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Hinttenne hintte golliyaa Asay hewaappe atteedawaa hak'aninne miite; ayaw gooppe, hewe Gaketiyaa Dunkkaaniyaan hintte ootsiyaa oosoo hintte dirgguwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Lo\"o bagga S'oossaw immi diggeeddawaappe guyyiyaan hintte miyaa wode, bayzzanchcha gidikkita. Shin lo\"o bagga he imotaappe kessennaan de'iidde, hintte Israa'eeliyaa asaa imotaa tunissennaadan naagettite. Hewaadan ootsana d'ayooppe, hintte hayk'k'ana› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Med'inaa Goday Musanne Aaroona hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Med'inaa Goday higgiyan azazeedda wogay hawaa: Tilla bollana de'iyaa woy borssiyaabay bayinna, I morggiyaan k'ambbaray wod'd'ibeenna zo'o ussatto new ahana mala, Israa'eeliyaa asaw odite. ");
INSERT INTO dwrl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","K'eesiyaa El\"aazaraw izo immite; I izo dunkkaaneedda sa'aappe gas'aa afina, itti Asay izo Aa sintsan shukko. ");
INSERT INTO dwrl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","K'eesiyaa El\"aazari I suutsaappe amareedawaa bare birad'd'iyan akkiide, Gaketiyaa Dunkkaaniyaw sintsa baggana laappun gede c'ac'c'afo. ");
INSERT INTO dwrl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","I s'eellishin ussatta s'uugettu; I galbbay, ashuu, suutsaynne toc'ii s'uugetto. ");
INSERT INTO dwrl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","K'eesii zigaa, hiisoop'p'iyaa tashiyaanne zo'o k'unc'c'uutiyaa akkiide, ussatto s'uuggiyaa taman olo. ");
INSERT INTO dwrl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Hewaappe guyyiyaan, k'eesii bare mayuwaa meec'c'o; bare bollaakka haatsaan meec'etto; yaatiide dunkkaaneeddasaa gelo; shin omarssa gakkanaw I wogaadan tuna gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","He ussatto s'uuggeeddawe k'ay bare mayuwaa meec'c'o; bare bollaakka haatsaan meec'etto; ikka k'ay omarssa gakkanaw wogaadan tuna gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","«Hewaappe guyyiyaan, geeshsha Asay ussatta s'uugetteedda bidintsaa shiishiide, dunkkaaneedda sa'aappe gas'aana geeshsha sa'aan wotso. Israa'eeliyaa Asay tunatetsaappe geeyiyaa haatsaan go'ettanaw hewaa naagi wotsana; hewe nagaraappe geeshshanaassa. ");
INSERT INTO dwrl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","K'ay ussatti bidintsaa shiishsheedda Asay bare mayuwaa meec'c'o; omarssi gakkanaw I wogaadan tuna gidanawaa. Ha wogay Israa'eeliyaa asawunne unttunttu gidduwaan de'iyaa hara gade asaw laa''ookka med'inaa woga gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Hayk'k'eedda asaa anhaa bochchiyaa ooninne laappun gallassaa wogaadan tunana. ");
INSERT INTO dwrl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","He tunatetsaappe geeyiyaa haatsaan heezzantsa gallassinne laappuntsa gallassi, I barena geeshsho; hewaappe guyyiyaan, I wogaadan geeshsha gidanawaa; shin heezzantsa gallassaaninne laappuntsa gallassan barena geeshshana d'ayooppe, I geeshsha gidenna. ");
INSERT INTO dwrl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Hayk'k'eedda uraa anhaa bochchiyaa ooninne barena geeshshennan aggooppe, Med'inaa Godaa Dunkkaaniyaa I tunissee; he uray Israa'eeliyaa asaa giddoppe bohetto. Tunatetsaappe geeyiyaa haatsay Aa bollan c'ac'c'afettibeenna diraw, I tuna; Aa tunatetsay Aa bollan gam\"ee. ");
INSERT INTO dwrl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«Itti uray dunkkaaniyaa giddon hayk'k'ooppe de'iyaa wogay hawaa: dunkkaaniyaa giddo geliyaa ooninne, k'ay dunkkaaniyaa giddon de'iyaa ubbaykka laappun gallassaa tuna gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Hewaadankka, k'um\"ettennaan dooyaa de'iyaa miishshaa ubbay tuna gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","K'ay dembban mashshaan hayk'k'eedda asaa, woy c'oo hayk'k'eedda anhaa, woy asaa mek'etsaa, woy duufuwaa bochchiyaa ooninne laappun gallassaa tuna gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«Tunatetsaappe geeshshanaw s'uuggeedda ussatti bidintsaappe amareedawaa akkaade, otuwaan wotsaade, pultto haatsaa aan tiga; ");
INSERT INTO dwrl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","geeshsha Asay hiisoop'p'iyaa bonc'c'iyaa akkiide, haatsaan tushi kessiide, dunkkaaniyaa, dunkkaaniyaan de'iyaa miishshaa ubbaaninne hewan de'iyaa asaa ubbaa bollan c'ac'c'afo. K'ay asaa mek'etsaa, woy duufuwaa, woy wod'eedda uraa, woy hayk'k'eedda uraa bochcheedda asaa bolla I c'ac'c'afo. ");
INSERT INTO dwrl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Geeshsha Asay heezzentsanne laappuntsa gallassan tuneedda uraa bollan c'ac'c'afo. I laappuntsa gallassan he uraa tunatetsaappe geeshsho; he geeyeedda bitanii bare mayuwaa meec'c'o; bare bollaakka haatsaan meec'etto; he gallassaa omarssi I geeshsha gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«Shin tuna uray barena geeshshennawaa gidooppe, he uray Med'inaa Godaa geeshsha sa'aa tunisseedda diraw, Israa'eeliyaa asaa giddoppe bohetto; tunatetsaappe geeyiyaa haatsay Aa bollan c'ac'c'afettibeenna diraw, I tuna. ");
INSERT INTO dwrl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hawe hinttenttoo med'inaa woga gidanawaa. K'ay tunatetsaappe geeyiyaa haatsaa c'ac'c'afiyaa Asay bare mayuwaa meec'c'o; tunatetsaappe geeyiyaa haatsaa bochchiyaa ooninnekka omarssi gakkanaw tuna gidanawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Tuna uray bochchiyaa ayaynne tunee. K'ay hewaa bochchiyaa ooninne omarssa gakkanaw tuna gidee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Koyro aginaan Israa'eelatuu ubbay S'iina giyaa mela biittaa gakkiide, K'aadeesa giyaa saan dunkkaaneeddino. Hewaan Miiriyaama hayk'k'aade moogettaaddu. ");
INSERT INTO dwrl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Hewaan asaw haatsay d'ayina, Asay shiik'iide, Muse bollanne Aaroona bolla denddeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Unttunttu, «Nu ishatuu Med'inaa Godaa sintsan hayk'k'eedda wode, nuunikka hayk'k'eeddawaa gideerokkooshsha! ");
INSERT INTO dwrl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nuuninne nu mehii ha mela biittan hayk'k'anaadan, Med'inaa Godaa asaa hawaa hintte ayaw aheedditee? ");
INSERT INTO dwrl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ha wolk'k'aama sa'aa nuuna Gibs'eppe pude ayaw aheedditee? Hawaan katsaa ayfii, woy balasiyaa, woy woyniyaa ayfii, woy roomaanii baawa; k'ay ushiyaa haatsaykka hawaan baawa» yaagiide Musena walak'etteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Yaatina Musenne Aarooni asaa mataappe Gaketiyaa Dunkkaaniyaa pengge biide guufanneeddino; Med'inaa Godaa bonchchuu unttunttoo k'onc'c'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Ne gatimaa akka; neeninne ne ishaa Aarooni shiik'uwaa shiishshite; unttunttu sintsan zaallay haatsaa goggana mala oda. Zaallaappe haatsaa hintte kessiide, shiik'uwaanne unttunttu mehiyaa ushshana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Med'inaa Goday azazeeddawaadan, Muse Med'inaa Godaa sintsaappe gatimaa akkeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Inne Aarooni shiik'uwaa zaallaa sintsan shiishsheeddino; Muse unttuntta, «Hinttenoo makkalanchchatoo, sisite; ha zaallaappe haatsaa hinttenttoo nuuni tumu kessanee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Muse bare kushiyaa d'ok'k'u ootsiide, bare gatiman laa\"u gede zaallaa shoc'ina, haatsay d'uuk'k'iide kesina yaa'aynne unttunttu mehii ushsheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Shin Med'inaa Goday Musanne Aaroona, «Israa'eeliyaa asaa sintsan hintte ta geeshshatetsaa bessanaw ammanettibeenna diraw, taani unttunttoo immiyaa biittaa ha asaa hintte gelissikkita» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Israa'eeliyaa Asay Med'inaa Godaanna walak'ettowe I bare geeshshatetsaa unttunttu giddon k'onc'c'isseeddasay ha Mariiba haatsaana. ");
INSERT INTO dwrl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Muse K'aadeesappe Eedooma biittaa kaatiyaakko, bare kiitettiyaawantta hawaadan yaagiide kiitteedda; «Ne dabbo gidiyaa Israa'eeliyaa Asay hawaadan yaagee; ‹Nuuna gakkeedda metuwaa ubbaa neeni eraasa. ");
INSERT INTO dwrl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nu mayzza aawotuu duge Gibs'e wod'd'eeddino; yan nuuni daro laytsaa de'eeddo. Gibs'etuu nuunanne nu aawotuwaa uk'k'inneeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Nuuni Med'inaa Godaw waassina, nu waasuwaa sisiide, kiitanchchaa kiittiide, nuuna Gibs'eppe kesseedda. Ha\"i nuuni ne biittaa gas'an de'iyaa K'aadeesa kataman de'eetto. ");
INSERT INTO dwrl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Hayyanaa, nuuna ne biittaana aatsaarikkii! Nuuni ay gade giddooppekka woy woyniyaa turaa giddooppekka bochchokko! K'ay nuuni ay haatsaa ollaappenne haatsaa ushokko. Nuuni Kaatiyaa Ogiyaa oyk'k'iide baana; nuuni ne biittaana aad'ana gakkanaw, haddirssa woy ushechcha gookko› yaagee» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Shin Eedooma kaatii, «Nu biittaana aatsikke; hintte hawaana mentsana kajjeelooppe, nuuni denddiide hinttena mashshaan olana» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israa'eelatuu Aa, «Nuuni Kaatiyaa Ogiyaanna baana; nuuni woy nu mehii hintte haatsaa ushooppe, nuuni hewoo gatiyaa c'iggana. Nuuni gediyaan aad'd'etsa s'alalaa koyeetto; harabaa ayaanne koyokko» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Eedooma kaatii zaaretsiide, «Hinttena aatsikke» yaageedda. Hewaappe guyyiyaan, daronne wolk'k'aama olanchchatuwaa akkiide, Israa'eeliyaa asaana olaa gakkettanaw keseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Eedoomatuu barenttu biittaana Israa'eeliyaa Asay aad'd'anaw diggeedda diraw, Israa'eeliyaa Asay simmiide hara ogiyaa beedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Israa'eeliyaa Asay ubbay K'aadeesappe denddiide, Hoora giyaa deriyaa beeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Eedooma zawaa matan de'iyaa Hoora Deriyan, Med'inaa Goday Musanne Aaroona, ");
INSERT INTO dwrl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Aarooni hayk'k'iide bare mayzzan gaketiyaa wodii gakkeedda. Mariiba haatsaa matan hintte laa\"uukka ta azazuwaa bolla makkaleedda diraw, Israa'eeliyaa asaw taani immiyaa biittaa I gelenna. ");
INSERT INTO dwrl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaroonanne Aa na'aa El\"aazara akkaade, Hoora Deriyaa aha. ");
INSERT INTO dwrl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Aaroona mayuwaa k'aaraade, Aa na'aa El\"aazara mayzza. Aarooni bare mayzzan gakettana; I yan hayk'k'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Med'inaa Goday azazeeddawaadan Muse ootseedda; Asay ubbay s'eellishin, unttunttu Hoora Deriyaa keseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Muse Aaroona mayuwaa k'aariide, Aa na'aa El\"aazara mayzzeedda. Aarooni he deriyaa huup'iyaan hayk'k'eedda. Hewaappe guyyiyaan, Musenne El\"aazari deriyaappe wod'd'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Aarooni hayk'k'eeddawaa Asay ubbay ereedda wode, Israa'eeliyaa Asay ubbay Aaroonaw hattamu gallassaa yeekkeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Neegeeba mela biittaa, Kanaane gadiyaan de'iyaa Araada kaatii Israa'eeliyaa Asay Ataarima afiyaa ogiyaa baggana yiyaawaa siseedda wode, I Israa'eelatuwaana olaa gakettiide, unttunttuppe amareedawantta omoodeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","He wode Israa'eeliyaa asay, «Neeni ha asaa nu kushiyan aatsaade immooppe, nuuni unttunttu katamatuwaa ubbaanna d'ayissana» yaagiide Med'inaa Godaw shiik'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Med'inaa Goday Israa'eeliyaa k'aalaa sisiide, he Kanaanetuwaa unttunttoo aatsi immeedda; unttunttu he Kanaanetuwaanne unttunttu katamatuwaa ubbaanna d'ayisseeddino. Hewaa diraw, he sa'ay Horima geetetti suntsetteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Israa'eeliyaa Asay Hoora Deriyaappe denddiide, Eedooma biittaa yuushshuwaa baanaw Zo'o Abbaa afiyaa ogiyaanna beeddino; shin ogiyaa bollan asaw danddayay wureedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Asay, «Nuuni mela biittaan hayk'k'anaw Gibs'eppe pude nuuna ayaw aheedditee? K'umi baawa; haatsay baawa; ha iita k'umay nuuna sheneyeedda» yaagiide S'oossaa bollanne Muse bolla zuuzummeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Med'inaa Goday asaa gidduwaan marzziyaanna de'iyaa shooshshatuwaa yeddeedda; unttunttu dukkina, daro Israa'eelatuu hayk'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Unttunttu Musekko yiide Aa, «Nuuni Med'inaa Godaa bollanne ne bolla zuuzummiide, nagaraa ootseeddo. Nuuppe ha shooshshaa haassana mala, neeni Med'inaa Godaa woossa» yaageeddino. Muse asaa diraw woosseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Hewaappe guyyiyaan Med'inaa Goday Musa, «Neeni shooshshaa med'd'aade, unttunttu sintsan mitsaa bollan kak'k'a; duketteedda ooninne Aa s'eellooppe pas'ana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Muse nahaase birataappe shooshshaa med'd'iide, mitsaa bollan kak'k'eedda. Hewaappe guyyiyaan, shooshshay dukkeedda Asay ubbay nahaasiyaa shooshshaa s'eelliide pas'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israa'eeliyaa Asay denddiide, Oboota giyaa saan dunkkaaneeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Obootappe denddiide, Moo'aabappe sintsanna de'iyaa bazzuwaan, away doliyaa baggana, laaletteedda Iye Abaarima kataman dunkkaaneeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Hewaappe denddiide, Zereedda Zanggaaraan dunkkaaneeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Hewaappe denddiide, Amooretuu biittaa gas'aa gakkanaw biyaa mela biittaa giddon Arnnoona Shaafaappe hefintsan dunkkaaneeddino. Arnnoona Shaafay Moo'aaba biittaappenne Amooretuu gadiyaappe gidduwaan de'iyaa zawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Hewaa diraw, S'oossaa Olaa Mas'aafan, «Suufa heeraan de'iyaa Waaheeba katamaanne Arnnoona Shaafaa zanggaaraa, ");
INSERT INTO dwrl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Eera katamaa gakkanawunne Moo'aaba zawaa gakkanaw de'iyaa zanggaaraa dugetsaa» yaagetti s'aafetteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Unttunttu hewaappe denddiide, Beera giyaasaa beeddino; hewe S'oossay Musa, «Asaa shiishsha; taani unttunttoo haatsaa immana» yaagiide odeedda haatsaa ollaa. ");
INSERT INTO dwrl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Hewaan Israa'eeliyaa Asay ha mazimuriyaa yes's'eedda. «Haatsaa ollaw, pultta! ");
INSERT INTO dwrl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Kaappatuu bookkeedda haatsaa ollaw, asaa kaaletsiyaawanttu ollaw, kaatetuwaa s'am\"aaninne unttunttu kazaran bookkeedda haatsaa ollaw ane yes's'eetto» yaageedda. Unttunttu he bazzuwaappe Mataana giyaasaa beeddino; ");
INSERT INTO dwrl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mataanappe Naahili'eela, Naahili'eelappe Baamoota giyaasaa, ");
INSERT INTO dwrl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Baamootappe denddiide, Moo'aaben de'iyaa zanggaaraa beeddino; ha zanggaaray Pisgga Deriyaappe garssan bazzuwaa matan de'ee. ");
INSERT INTO dwrl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Hewaappe guyyiyaan, Israa'eeliyaa Asay Amoore biittaa Kaatiyaa Sihoonakko kiitettiyaawantta hawaadan yaagiide kiitteedda; ");
INSERT INTO dwrl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Nuuna ne biittaana aatsaarikkii! Nuuni ne gadiyaa gidduwaa woy woyniyaa turaa gidduwaa gelokko; k'ay haatsaa ollaa hak'awaappenne ushokko. Nuuni ne biittaana aad'd'ana gakkanaw, Kaatiyaa Ogiyaanna baana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Shin Sihooni bare biittaana Israa'eeliyaa asaa aatsenan diggeedda; I bare olanchchatuwaa ubbaa shiishiide, Israa'eeliyaa asaa olanaw mela biittaa beedda; Yahaas'a giyaasaa bi gakkiide, Israa'eeliyaa asaana oletteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Shin Israa'eeliyaa Asay olan Amooretuwaappe daruwaa wod'iide, unttuntta biittaa Arnnoona Shaafaappe doommiide, Amoonatuwaa zawaan de'iyaa Yaabook'a Shaafaa gakkanaw oyk'k'eedda. Amoona asatuu biittaa zaway gimbbetti utteedda diraw, unttunttu yaa gelibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Yaatina Israa'eelatuu Amooretuu katamatuwaa ubbaa s'ooniide akkeeddino. K'ay Haseboonanne Aa yuushshuwaan de'iyaa k'eeri katamatuwaakka ubbaa oyk'k'iide, yan utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Haseboona katamay Amooretuu Kaatiyaa Sihoona katamaa. Sihooni Moo'aaba biittaa kaatiyaa kasewaa oliide, Arnnoona Shaafaa gakkanaw Aa biittaa ubbaa aappe akkeeddawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Hewaa diraw, leemisuwaan hawaadan yaageeddino; «Haseboona haayite; he katamay zaaretsi kees'etto; Sihoona wolk'k'aama katamay wod'd'i ek'k'iide kees'etto! ");
INSERT INTO dwrl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ayaw gooppe, tamay Haseboonappe, lac'uu Sihoona katamaappe keseedda; Moo'aaben de'iyaa Eeranne Arnnoona Shaafaa heeraan gezziyaan de'iyaa kaappatuwaa meedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Moo'aabaa, new aayye ana! Kaamooshaw goyinniyaawanttoo, hintte d'ayeeddita. Hintte s'oossay, Kaamooshi, hintte attuma naanatuwaa bak'atanaw, hintte mac'c'a naanatuwaa omoodoo, Amooretuu Kaatiyaa Sihoonaw immeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Hintte zeretsatuu Haseboonappe doommiide, Diboona gakkanaw ubbaanna d'ayeeddino. Medaaba matan de'iyaa Nofaaha gakkanaw wurssiide bayzzeeddino» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Hewaadan haniide, Israa'eelatuu Amooretuu gadiyaan utteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","K'ay Muse wochchiyaawantta Yaa'izeera giyaa katamaa yeddina, Israa'eelatuu he katamaanne Aa heeraan de'iyaa k'eeri katamatuwaa oyk'k'iide, hewan de'iyaa Amooretuwaa kessiide yedersseeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Hewaappe guyyiyaan, Israa'eelatuu simmiide, Baasaane afiyaa ogiyaanna keseeddino. Baasaane Kaatii Oogi bare olanchchatuwaa ubbaanna Ediraa'a giyaa katamaa unttunttunna olettanaw keseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Shin Med'inaa Goday Musa, «Aw yayyoppa! Ayaw gooppe, taani Kaatiyaa Ooga Aa asaa ubbaananne Aa biittaana ne kushiyan aatsaade immaaddi. Haseboonan uttiide mooddeedda Amooretuu Kaatiyaa Sihoona bolla ootseeddawaadan, neeni Aa bollakka ootsana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Israa'eelatuu Ooga, Aa attuma naanatuwaanne Aa asaa ubbaa ittuwaanne pas'a ashshenan wod'eeddino. Unttunttu Aa biittaa laatteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Hewaappe guyyiyaan Israa'eeliyaa Asay denddiide, Iyaarikko likkiyaan Yorddaanoosa hefintsan de'iyaa Moo'aaba dembban dunkkaaneedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Israa'eeliyaa Asay Amooretuu bolla ootseeddawaa ubbaa S'ippoora na'ay Baalaak'i siseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Israa'eeliyaa Asay loytsi daro gideedda diraw, Moo'aabatuu loytsi dagammiide yayyeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moo'aabatuu Midiyaama c'imatuwaa, «Booray maataa mi d'ayssiyaawaadan ha wude Asay nu yuushshuwaan de'iyaa ubbaa mi d'ayissana» yaageeddino. He wode Moo'aaba Kaatii, S'ippoora na'ay Baalaak'i ");
INSERT INTO dwrl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Amaawa gadiyaan Efiraas'iisa Shaafaa matan Patoora kataman de'iyaa Bi'oora na'aa Balaamakko asaa kiitteedda. Baalaak'i, «Be'a, Gibs'eppe daro Asay keseedda; unttunttu biittaa ubbaa mayyiide, taappe ya baggan de'iino. ");
INSERT INTO dwrl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Unttunttu taw loytsi wolk'k'aamiyaa diraw, hayyanaa ha\"i yaade, unttuntta taw shek'k'aarikkii! Ooni erii, taani unttuntta s'oonanawunne gadiyaappe kessanaw danddayanenttonne. Ayaw gooppe, neeni anjjeedawe anjjetteedawaanne neeni shek'k'eeddawe shek'etteeddawaa gidiyaawaa taani eray» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moo'aaba c'imatuunne Midiyaama c'imatuu shek'k'issiyaa gatiyaa akkiide, Balaamakko beeddino. Baalaak'i geeddawaa aw odeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaami unttuntta, «Hachche k'amma hawaan ak'ite; Med'inaa Goday taw odiyaawaa taani hinttenttoo odana» yaageedda. Moo'aaba kaappatuu Balaamawaan takkeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","S'oossay Balaamakko yiide, «Hawanttu neenana de'iyaa asatuu oonee?» yaagiide oochcheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaami S'oossaa, «Moo'aaba Kaatii, S'ippoora na'ay Baalaak'i, ");
INSERT INTO dwrl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹Gibs'eppe daro Asay keseedda; unttunttu biittaa ubbaa mayyeeddino. Ha\"i neeni yaade, unttuntta taw shek'k'aarikkii! Ooni erii, taani unttuntta s'oonanawunne gadiyaappe kessanaw danddayanenttonne› yaagiide unttuntta taakko kiitteedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","S'oossay Balaama, «Neeni unttunttunna booppa. Israa'eelatuu anjjetteedawantta gidiyaa diraw, neeni he asaa shek'k'oppa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Wonttetsa gallassi wontta Balaami denddiide, Baalaak'a kaappatuwaa, «Taani hinttenana beennaadan Med'inaa Goday diggeedda diraw, hintte biittaa simmite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moo'aaba kaappatuu yaappe denddiide, Baalaak'akko simmiide Aa, «Balaami nuunana yeennan is's'eedda» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Zaariidekka Baalaak'i kasewanttuppe aad'd'i bonchchetteeddanne payduwaankka c'oratteedda hara kaappatuwaa aakko kiitteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Unttunttu Balaamakko yiide, «S'ippoora na'ay Baalaak'i neena, ‹Neeni taakko yaanawaa neena ayaynne te\"oppo. ");
INSERT INTO dwrl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ayaw gooppe, taani new daro woytuwaa immana; neeni giyaawaa ubbaa ayaanne taani ootsana. Yaade ha asaa taw shek'k'aarikkii› » yaagiide odeeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Shin Balaami unttunttoo, «Baalaak'i haray atto biraynne work'k'ay kumeedda bare kaatiyaa golliyaa taw immeeddawaa gidinttonne, Med'inaa Godaa ta S'oossaa azazuwaappe aad'aadde, taani ayaanne pac'issanaw woy gujjanaw danddaykke. ");
INSERT INTO dwrl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Med'inaa Goday taw odiyaa harabay de'ooppe taani eranaadan, hinttekka hachchi k'amma hawaan ak'ite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","He gallassaa k'amma S'oossay Balaamakko yiide, «Ha Asay neena s'eesanaw yeedda diraw, neeni unttunttunna ba. Shin taani new odiyaawaa s'alalaa ootsa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Wonttetsa gallassi Balaami bare haratto kooriide, Moo'aaba kaappatuwaanna beedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Shin I biyaa wode S'oossaa hank'k'uu ees's'i keseedda; yaatina Med'inaa Godaa kiitanchchay Aa te\"anaw ogiyaan ek'k'eedda. He wode Balaami bare haratto toggowaan, Aa laa\"u k'oomatuu aanana de'iino. ");
INSERT INTO dwrl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Med'inaa Godaa kiitanchchay mashshaa zaaretsi oyk'k'iide, ogiyaan ek'k'eeddawaa haratta be'anee, ogiyaa aggaade, goshshaa giddo gelaaddu. Balaami ogiyaa zaaranaw haratto shoc'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Yaatina Med'inaa Godaa kiitanchchay laa\"u woyniyaa turaa sa'atuwaappe gidduwaan, ya baggananne ha baggana gimbbiyaan diretti utteedda un\"o ogiyaan ek'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Haratta Med'inaa Godaa kiitanchchaa be'eedda wode, gimbbiyaa dirssaakko shiik'aade, Balaama gediyaa gimbbiyaa dirssaana daras'aadu; I haratto laa\"entsuwaakka shoc'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Hewaappe guyyiyaan, Med'inaa Godaa kiitanchchay sintsawukko aad'd'iide, haddirssa bagganakka ushechcha baggana aad'd'iyaa sa'ay bayinna un\"o sa'aan ek'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Haratta Med'inaa Godaa kiitanchchaa be'aade, Balaami toggowaan gisaaddu. Balaami loytsi hank'k'ettiide, bare s'am\"an haratto bukkeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Hewaappe guyyiyaan, Med'inaa Goday harati doonaa dooyina, haratta Balaama, «Taani new ay ootsinee neeni taana ha heezzu gede bukkeeddawe?» yaagaaddu. ");
INSERT INTO dwrl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaami haratto, «Neeni taana eeyetseedda diraassa. Ta kushiyan mashshay de'eeddawaa gidinttonne, taani neena ha\"i wod'ana shin!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Haratta Balaama, «Taani ne de'o ubbaan hachchi gakkanaw toggiyaa ne haratto gidikkitaa? Taani new hawaadan hana erayttaa?» yaagaaddu. Balaami, «Hana erakka» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Hewaappe guyyiyaan, Med'inaa Goday Balaama ayfiyaa dooyina, Med'inaa Godaa kiitanchchay shookuwaappe shoddeedda mashshaa oyk'k'iide, ogiyaan ek'k'eeddawaa be'eedda. I lic'c'i giide, som\"uwaa sa'aa gatsiide guufanneedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Med'inaa Godaa kiitanchchay Aa, «Ne haratto ha heezzu gede ayaw bukkaadii? Ne ogii ta sintsan geella gidiyaa diraw, taani neena te\"anaw hawaa yaad. ");
INSERT INTO dwrl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Haratta taana be'aade, ta sintsaappe heezzu gede wora simmaaddu. Haratta wora simmabeennawaa gidinttonne, taani neena hannoode tumu wod'a diggaade, haratto ashshana shin» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaami Med'inaa Godaa kiitanchchaa zaariide, «Taani nagaraa ootsaad. Neeni taana te\"anaw ogiyaa bollan ek'k'eeddawaa taani erabeykke. Neeni dosabeennabaa gidooppe, taani ha\"i guyye simmana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Med'inaa Godaa kiitanchchay Balaama, «Neeni ha asatuwaana ba; shin taani new odiyaawaa s'alalaa haasaya» yaageedda. Balaami Baalaak'a biittaa kaappatuwaanna beedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaami yiyaawaa Baalaak'i siseedda wode, Arnnoona Shaafaa zawaan bare biittaa gas'an de'iyaa Moo'aabatuwaa kataman aanana gakkettanaw beedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Baalaak'i Balaama, «Neeni ellekka yaanaadan taani kiittabeykkittaa? Neeni ayaw taakko ellekka yabeykkii? Taani new woytanaw tumu danddaykkitaa?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaami Baalaak'a, «Be'a, ha\"i taani neekko yaad; shin taani ayaanne gaanaw tumu danddaykke. S'oossay taana haasayissiyaawaa s'alalaa taani haasayana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Hewaappe guyyiyaan, Balaami Baalaak'ana K'iriyaati-Hus'oota giyaa katamaa beedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Baalaak'i miizzaanne dorssaa yarshshiide, ashuwaappe amareedawaa Balaamawunne aanana de'iyaa kaappatoo immeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Wonttetsa gallassi wontta Baalaak'i Balaama akkiide, Baamooti-Ba'aali giyaasaa pude kesseedda; hewan ek'k'iide, Balaami Israa'eeliyaa asaappe bagga be'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaami Baalaak'a, «Hawaan neeni taw laappun yarshshiyaa sa'aa gimbba; k'ay laappun korumaa booraanne laappun dorssaa orggetuwaa neeni taw giigissa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaami geeddawaadan Baalaak'i ootseedda; unttunttu laa\"uukka itti itti yarshshiyaa sa'aan itti korumaa booraanne itti dorssaa orggiyaa yarshsheeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Hewaappe guyyiyaan, Balaami Baalaak'a, «Neeni ne s'uuggiyaa yarshshuwaa matan hawaan ek'k'ashsha; taani gedekko bay. Med'inaa Goday taananna gakkettanaw hak'eti yeennan aggena. I taw k'onc'c'issiyaawaa ayaanne taani new odana» yaageedda. D'ok'k'a zoozetiyaa mela sa'aa keseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Hewaan S'oossay Balaamana gakettina Balaami, «Taani laappun yarshshiyaa sa'aa giigissaad; itti itti yarshshiyaa sa'aan itti korumaa booraanne itti dorssaa orggiyaa yarshshaad» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Balaami gaanabaa Med'inaa Goday aw odiidde, «Neeni Baalaak'akko simmaade, aw ha timbbitiyaa oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","I Baalaak'akko simmiyaa wode, Baalaak'i Moo'aaba kaappatuu ubbaanna bare s'uuggiyaa yarshshuwaa matan ek'k'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Hewaappe guyyiyaan, Balaami bare timbbitiyaa hawaadan yaagiide odeedda; «Moo'aaba kaatii Baalaak'i away doliyaa bagga deretuwaappe, Sooriyaa gadiyaappe taana hawaadan yaagiide aheedda; ‹Haaya; Yaak'ooba taw shek'k'a! Israa'eeliyaa asaa, «Wurite!» yaaga› yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","S'oossay shek'k'ibeenawantta taani waata shek'k'oo? Med'inaa Goday, ‹Wurite!› yaagibeennawantta, taani waataade, ‹Wurite!› yaagoo? ");
INSERT INTO dwrl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Taani d'ok'k'a zaallaa huup'iyaan ek'k'aade unttuntta s'eellay; zooziyaan ek'k'aade taani unttuntta be'ay. Unttunttu barekka de'iyaa asaa; unttunttu barena kawutetsatuwaappe ittuwaadan paydikkino. ");
INSERT INTO dwrl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Baanaadan c'oratteedda Yaak'ooba zeretsaa ooni paydanaw danddayii? Haray atto Israa'eeliyaa asaw oyddentso kushiyaa ooni paydanaw danddayii? Ta hayk'k'uu s'illotuwaa hayk'uwaa mala gido; ta de'uwaa wurssetsaykka unttunttuwaadan hano!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Baalaak'i Balaama, «Neeni ta bolla ootsiyaabay ayee? Taani neena ta morkkatuwaa shek'k'anaadan ahaad; shin neeni unttuntta anjjaaddappe attina, harabaa ayinne ootsabaakka!» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaami zaariide, «Taani Med'inaa Goday taana haasayissiyaawaappe haraa haasayooyye?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Hewaappe guyyiyaan, Baalaak'i Aa, «Unttunttu neeni be'anaw danddayiyaa harasaa taananna dendda. Neeni unttunttuppe amareedawaa be'anaappe attina, unttuntta ubbaa be'akka. Neeni hewan taw unttuntta shek'k'aarikkii» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Pisgga giyaa deriyaa huup'iyaan de'iyaa S'ofiima dembbaa akkiide afeeda. Hewaan laappun yarshshiyaa sa'aa gimbbeedda; itti itti yarshshiyaa sa'aan itti korumaa booraanne itti dorssaa orggiyaa yarshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaami Baalaak'a, «Taani hinina S'oossaanna gaketiyaa wode, neeni hawaan ne s'uuggiyaa yarshshuwaa matan ek'k'ashsha» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Med'inaa Goday Balaamana gakettiide kiittiidde, «Neeni Baalaak'akko simmaade, aw ha timbbitiyaa oda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","I aakko simmiide, bare s'uuggiyaa yarshshuwaa matan Moo'aaba biittaa kaappatunna ek'k'eeddawaa demmeedda. Baalaak'i Aa, «Med'inaa Goday odiyaabay ayee?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaami bare timbbitiyaa hawaadan yaagiide odeedda; «S'ippoora na'aa Baalaak'aa dendda sisa; taani odiyaawaa sisa! ");
INSERT INTO dwrl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","S'oossay worddotanaw asaa gidenna; bare k'ofaa laammanaw I asaa na'aa gidenna. I odiidde, bare odeeddawaa ootsenee? Woy I bare geeddawaa polennee? ");
INSERT INTO dwrl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Taani anjjanaw azazuwaa akkaad. I anjji kichcheedda; taani hewaa laammanaw danddaykke. ");
INSERT INTO dwrl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Yaak'ooba zariyaw iitabay yaanabay, Israa'eeliyaa asaw metuu gakkanabay taw beettibeenna. Med'inaa Goday unttunttu S'oossay unttunttunna de'ee; I unttunttoo kaatiyaa gidiyaawaa awaayiino. ");
INSERT INTO dwrl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","S'oossay unttuntta Gibs'eppe kesseedda; I mino mentsaadan unttunttoo de'ee. ");
INSERT INTO dwrl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Yaak'ooba bolla gakkana bitay baawa; Israa'eeliyaa asaa k'ohana murunuukka baawa. Asay ha\"i, ‹Yaak'oobawunne Israa'eelaw S'oossay ootseeddawaa be'ite› yaagana. ");
INSERT INTO dwrl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ha Asay mac'c'a gaammattidan denddeedda. Bare oyk'k'eeddawaa maana gakkanawunne, bare wod'eeddawaa suutsaa ushana gakkanaw, Shemppenna gaammuwaadan unttunttu ek'k'i denddino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Hewaappe guyyiyaan, Baalaak'i Balaama, «Neeni unttuntta mulekka shek'k'oppanne mulekka anjjoppa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaami zaariide, «Med'inaa Goday giyaawaa ubbaa ootsana gaade taani new odabeykkitaa?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Hewaappe guyyiyaan, Baalaak'i Balaama, «Haaya; taani neena harasaa afana. Ooni erii, neena yaa afina S'oossay nashettiide, neena unttuntta taw shek'isanentto» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Baalaak'i Balaama mela biittaa bollana duge s'eelliyaa Pa'oora Deriyaa huup'iyaa afeeda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaami, «Neeni hawaan taw laappun yarshshiyaa sa'aa gimbba; k'ay laappun korumaa booratuwaanne laappun dorssaa orggetuwaa taw giigissa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaami geeddawaadan Baalaak'i ootseedda; itti itti yarshshiyaa sa'aan itti korumaa booraanne itti dorssaa orggiyaa yarshsheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Israa'eeliyaa anjjiyaawe Med'inaa Godaa nashechcheeddawaa Balaami be'eedda wode, kase I ootseeddawaadan murunanaw koyibeenna; shin bare som\"uwaa mela biittaakko zaareedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Yaatiide d'ok'k'u gi s'eelliide, Israa'eeliyaa Asay bare zariyaan zariyaan dunkkaani utteeddawaa be'eedda; S'oossaa Ayyaanay Aa bolla wod'd'eedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","I bare timbbitiyaa hawaadan yaagiide odeedda; «Bi'oora na'aa Balaama timbbitii, Aa ayfii tishshi ootsi s'eelliyaawaa timbbitii, ");
INSERT INTO dwrl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","S'oossay giyaawaa sisiyaawaa timbbitii, Lic'c'i giide guufannina, Aa ayfii dooyetteeddawaanne Ubbaa Danddayiyaa S'oossaa sas'aa be'iyaawaa timbbitii hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Yaak'ooba zaretoo, hintte dunkkaanetuu, Israa'eeliyaa asaw, hintte de'iyaa sa'atuukka, wooti lo\"ee! ");
INSERT INTO dwrl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Unttunttu mic'etteedda wombbaadan, Shaafaa doonaan de'iyaa ataakilttiyaa sa'aadan, Med'inaa Goday tokkeedda godare uutsaadaaninne haatsaa doonaan de'iyaa zigaadan haniino. ");
INSERT INTO dwrl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Unttunttoo daro haatsay pulttana; unttunttu zaretoo gidiyaa haatsay de'ana. Unttunttu kaatii Kaatiyaa Agaagappe gitatana; unttunttu kawutetsaykka bonchchettana. ");
INSERT INTO dwrl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","S'oossay unttuntta Gibs'eppe kesseedda; I mino mentsaadan unttunttoo de'ee. Unttunttu morkke kawutetsaa mittana; unttunttu mek'etsaakka liik'issana; unttunttu barenttu wonddaafiyaa zubbiyaan unttuntta c'addana. ");
INSERT INTO dwrl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Israa'eeliyaa Asay gaammuwaadan gisee. Mac'c'a gaammattidan unttuntta dentsanaw ooni s'alanee? Hinttena anjjiyaa ubbay anjjetteedawaa gidanawaa; hinttena shek'k'iyaa ubbay shek'etteeddawaa gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Hewaappe guyyiyaan, Baalaak'i Balaama bolla hank'k'uwaa ees's'i keseedda. Baalaak'i bare kushiyaa dukkiide Balaama, «Ta morkkatuwaa k'angganaadan taani neena s'eesaad; shin neeni ha heezzu gedekka unttuntta anjjaadda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Simmi ha\"i neeni ne golle bak'ata; ‹Taani new darobaa woytana› gaad; shin neeni woytuwaa akkenaadan Med'inaa Goday neena diggeedda» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaami Baalaak'a zaariide, «Neeni taakko kiitteeddawanttunne, ");
INSERT INTO dwrl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹Baalaak'i haray atto bare biraynne work'k'ay kumeedda bare kaatiyaa golliyaa taw immeeddawaa gidinttonne, Med'inaa Goday odeeddawaa aad'aadde, lo\"uwaa woy iitaa ta sheniyaan ootsanaw danddaykke. Taani Med'inaa Goday giyaawaa s'alalaa gaana› yaagaade new odabeykkitayye?» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Yaagiide, «Taani ha\"i ta asaakko bay; shin neeni haaya; ha Asay wurssetsa wodiyaan ne asaa ootsanawaa taani new odana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","I bare timbbitiyaa hawaadan yaagiide odeedda; «Bi'oora na'aa Balaama timbbitii, Aa ayfii tishshi ootsiide s'eelliyaawaa timbbitii, ");
INSERT INTO dwrl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","S'oossay giyaawaa sisiyaawaanne, Ubbaappe d'ok'k'iyaa S'oossaappe gideedda eratetsay de'iyaawaa timbbitii, Lip'p'i giide guufannina, Aa ayfii dooyetteeddawaanne Ubbaa Danddayiyaa S'oossaa sas'aa be'iyaawaa timbbitii hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Taani Aa be'ay; shin wodii ha\"a gidenna; taani Aa s'eellay; shin matan gidenna. Yaak'ooba zariyaappe s'oolinttii kesana. Israa'eeliyaappe kaatetuwaa s'am\"ay kesana. Moo'aaba asaa som\"uwaa I gaac'c'i k'olana. Seete asaa ubbaa huup'iyaa I kinchchana. ");
INSERT INTO dwrl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Eedoomi s'oonettana; Aa morkkii Se'iirikka s'oonettana; Shin Israa'eelii min minniide baana. ");
INSERT INTO dwrl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yaak'oobappe mooddiyaawe kesana; unttunttu kataman pas'a atteedawantta d'ayissana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Hewaappe guyyiyaan, Balaami Amaaleek'a asatuwaa be'iide, bare timbbitiyaa hawaadan yaagiide odeedda: «Kawutetsatuwaa giddon Amaaleek'i koyiro; shin unttunttu wurssetsay d'ayo» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","K'ay Balaami K'eena asatuwaa be'iide, bare timbbitiyaa hawaadan yaagiide odeedda; «Hintte de'iyaa sa'ay saro saa gidee; hintte gollii zaallaa bollan kees'etteedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Shin Asooretuu hinttena omooddiyaa wode, hintte K'eena asatuu d'ayana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Hewaappe guyyiyaan, Balaami bare timbbitiyaa hawaadan yaagiide odeedda; «Aayye ana! S'oossay hawaa ootsiyaa wode, ooni de'ana danddayii? ");
INSERT INTO dwrl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Markkabatuu Kitiima haruuruwaappe yaana; unttunttu Asooretuwaanne Ebeeratuwaa uk'k'unnana; Shin k'ay unttunttukka d'ayana» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Hewaappe guyyiyaan, Balaami denddiide, bare golle simmeedda; Baalaak'ikka bare ogiyaa beedda. ");
INSERT INTO dwrl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israa'eelatuu Shiis'ima giyaa saan dunkkaaneedda wode, Asay Moo'aaba biittaa machchetuwaanna shaarmus'uwaa doommeedda. ");
INSERT INTO dwrl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","He mac'c'a asatuu barenttu s'oossatuwaa yarshshuwaa maanaw unttuntta shoobbeeddino; unttunttu miide, unttunttu s'oossatoo goyinneeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israa'eelatuu Pa'oora Ba'aala giyaa eek'aa kaalleedda diraw, Med'inaa Godaa hank'k'uu unttunttu bollan ees's'i keseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Yaatina Med'inaa Goday Musa, «Med'inaa Godaa hank'k'uu Israa'eeliyaappe wora simmana mala, ha asaa kaaletsiyaawantta ubbaa afaade, seeta gallassi Med'inaa Godaa sintsan kak'k'a» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Muse Israa'eeliyaa daannatuwaa, «Pa'oora Ba'aala giyaa eek'aw goyinneedda hintte asaa ubbaa hintte huup'iyaan huup'iyaan wod'ite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Musenne Israa'eeliyaa maabaray ubbay Gaketiyaa Dunkkaaniyaa penggiyaan yeekkishin, Israa'eelatuwaappe ittuu Midiyaama biittaa mishirato unttunttu sintsanna aatsiide, bare golliyaa asaakko aheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","K'eesiyaa Aaroona na'aa El\"aazara na'ay Piinihaasi hewaa be'eedda wode, maabaraa giddoppe denddiide, tooraa bare kushiyan oyk'k'iide, ");
INSERT INTO dwrl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","he Israa'eeliyaa bitaniyaa kaalliide, dunkkaaniyaa giddo geleedda. Israa'eeliyaa bitaniyaanne mishiratonne laa\"uwaakka tooraan c'addiide, kantsi kesseedda. Hewaadan hanina, boshay Israa'eelatuwaappe k'aaretteedda; ");
INSERT INTO dwrl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","shin he boshaan hayk'k'eedda Asay laatamanne oyddu sha\"a. ");
INSERT INTO dwrl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Hewaappe guyyiyaan, Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«K'eesiyaa Aaroona na'aa El\"aazara na'ay Piinihaasi Israa'eeliyaa asaa giddon taani ta bonchchoo mishettiyaawaadan mishetteedda diraw, unttunttu bolla taani hank'k'etteedda hank'k'uu dochcheedda; taanikka unttuntta ta hank'k'uwaan d'ayissabeykke. ");
INSERT INTO dwrl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Hewaa diraw, taani ta sarotetsaa c'aak'uwaa aanana c'aak'k'etiyaawaa Piinihaasaw neeni oda. ");
INSERT INTO dwrl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","I bare S'oossaa bonchchoo mishetteedda gishshawnne Israa'eeliyaa asaw atto giisseedda diraw, inne Aa zeretsatuu med'inaw k'eese gidanawaa» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Midiyaama biittaa mishiratina wod'eedda Israa'eeliyaa bitaniyaa suntsay Saalu na'aa Zimira; Saalu Simoona zaratuwaan itti yaraa kaappuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Hayk'k'eedda Midiyaama biittaa mishiratti suntsay Kozibo; I aawuu S'uuri Midiyaamatuu yaraa kaappuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Med'inaa Goday Musa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Midiyaama biittaa asatuwaa morkkite; unttuntta wod'ite. ");
INSERT INTO dwrl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Ayaw gooppe, unttunttu hinttena Pa'ooran c'immiidde, hinttew morkke gideeddino; k'ay boshaa gallassi Pa'ooran wod'eedda mishiratti, Midiyaamatuu yaraa kaappuwaa naatti Kozibi gaasuwaan unttunttu hinttena morkkeeddino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Boshaappe guyyiyaan, Med'inaa Goday Musanne k'eesiyaa Aaroona na'aa El\"aazara, ");
INSERT INTO dwrl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Yelettoodeppe laatamu laytsanne hewaappe bollana de'iyaa Israa'eelatuwaa, olaw baanaw danddayiyaawantta ubbatuwaa, unttunttu golliyaan golliyaan paydite» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musenne k'eesii El\"aazari Yorddaanoosa Shaafaappe hefintsa baggana, Iyaarikko matan, Moo'aaba Dembban unttunttunna haasayiidde, ");
INSERT INTO dwrl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Med'inaa Goday Musa azazeeddawaadan, yelettoodeppe laatamu laytsanne hewaappe bollana de'iyaa asaa paydite» yaageeddino. Gibs'eppe keseedda Israa'eelatuu hawantta: ");
INSERT INTO dwrl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Israa'eeliyaa bayira na'aa Roobeela zaratuu: Hanooka yaratuwaa, Paalu yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hes'iroona yaratuwaanne Karmma yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Hawanttu Roobeela zaratuwaa; unttunttu ubbaanna 43,730. ");
INSERT INTO dwrl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Paalu na'ay Eli'aaba; ");
INSERT INTO dwrl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eli'aaba attuma naanay Nemu'eela, Daataananne Abiiraama; ha Daataaninne Abiiraami maabaray dooreeddawantta. Unttunttu K'oraahanne Aa kaalliyaawanttuna zuppetiide, Muse bolla, Aaroona bollanne Med'inaa Godaa bolla makkaleeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Biittay dooyettiide, unttuntta K'oraahaana ittippe mitteedda; unttuntta kaalliyaa laa\"u s'eetanne ishatamu asaa tamay miina hayk'k'eeddino. Yaatina unttunttu Asay be'iide duus's'iyaa malaataa gideeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Shin K'oraaha attuma naanay he gallassi hayk'k'ibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simoona zaratuu barenttu yaran yaran: Nemu'eela yaratuwaa, Yaamiina yaratuwaa, Yaakiina yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zaraaha yaratuwaanne Shaa'ula yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Hawanttu Simoona zaratuwaa; unttunttu ubbaanna 22,200. ");
INSERT INTO dwrl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gaada zaratuu barenttu yaran yaran: S'aafoona yaratuwaa, Hagga yaratuwaa, Shuuna yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Oozina yaratuwaa, Eera yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arooda yaratuwaanne Ari\"eela yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Hawanttu Gaada zaratuwaa; unttunttu ubbaanna 40,500. ");
INSERT INTO dwrl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yihudaa attuma naanay Eeranne Oonaana; shin unttunttu Kanaane gadiyaan hayk'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yihudaa zaratuu barenttu yaran yaran: Sheela yaratuwaa, Paareesa yaratuwaanne Zaraaha yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Paareesa zaratuu Hes'iroona yaratuwaanne Hamuula yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Hawanttu Yihudaa zaratuwaa; unttunttu ubbaanna 76,500. ");
INSERT INTO dwrl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Yisaakoora zaratuu barenttu yaran yaran: Tolaa'a yaratuwaa, Puuwa yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yaashuuba yaratuwaanne Shimiroona yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Hawanttu Yisaakoora zaratuwaa; unttunttu ubbaanna 64,300. ");
INSERT INTO dwrl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zaabiloona zaratuu barenttu yaran yaran: Sereeda yaratuwaa, Eloona yaratuwaanne Yaahila'eela yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Hawanttu Zaabiloona zaratuwaa; unttunttu ubbaanna 60,500. ");
INSERT INTO dwrl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Minaasenne Efireema aawuwaa Yooseefo zaratuu hawaappe kaalliide s'aafetteeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Minaase zaratuu Minaase na'aa Maakiira yaratuwaa, Maakiiri na'aa Gala'aade yaratuwaanne Gala'aade naanatu yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gala'aade zaratuu I'eezera yaratuwaa, Heleek'a yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asiri'eela yaratuwaa, Shekeema yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shamidaa'a yaratuwaanne Hefeera yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hefeera na'ay S'alofihaad mac'c'a naanatu s'alalaa yeleedda; aw attuma na'i baawa. S'alofihaada mac'c'a naanatu suntsay Maahilo, No'o, Hoogilo, Milkkonne Tirs's'o. ");
INSERT INTO dwrl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Hawanttu Minaase zaratuwaa; unttunttu ubbaanna 52,700. ");
INSERT INTO dwrl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efireema zaratuu barenttu yaran yaran: Shutelaaha yaratuwaa, Bekeera yaratuwaa, Tahaana yaratuwaanne ");
INSERT INTO dwrl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Shutelaaha na'aa Erana yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Hawanttu Efireema zaratuwaa; unttunttu ubbaanna 32,500. Yooseefo zaratuu barenttu yaran yaran hewantta. ");
INSERT INTO dwrl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Biiniyaama zaratuu barenttu yaran yaran: Belaa'a yaratuwaa, Ashibeela yaratuwaa, Ahiraama yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shafufaama yaratuwaa, Hufaama yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Belaa'a na'aa Arada yaratuwaanne Belaa'a na'aa Naa'imaana yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Hawanttu Biiniyaama zaratuwaa; unttunttu ubbaanna 45,600. ");
INSERT INTO dwrl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Daana zaratuu Shuhaama yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Shuhaama yaratuu ubbaanna 64,400. ");
INSERT INTO dwrl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Aaseera zaratuu barenttu yaran yaran: Yimina yaratuwaa, Yishiwaaha yaratuwaa, Barii'a yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Barii'a na'aa Hebeera yaratuwaanne Barii'a na'aa Malkki'eela yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aaseeraw Seraaho giyaa mac'c'a naatta de'aw. ");
INSERT INTO dwrl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Hawanttu Aaseera zaratuwaa; unttunttu ubbaanna 53,400. ");
INSERT INTO dwrl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nifttaaleema zaratuu barenttu yaran yaran: Yaa'izi'eela yaratuwaa, Guuna yaratuwaa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yes'eera yaratuwaanne Shilleema yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Hawanttu Nifttaaleema zaratuwaa; unttunttu ubbaanna 45,400. ");
INSERT INTO dwrl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Paydeteedda Israa'eeliyaa attuma Asay ubbaanna 601,730. ");
INSERT INTO dwrl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","K'aykka Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Ha zaretoo unttunttu suntsaa suntsaa payduwaadan biittay shaakettiide, laata gidiide unttunttoo imetto. ");
INSERT INTO dwrl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Payduwaan c'oratoo unttunttu c'oratetsaa keenaa, payduwaan guutsatoo unttunttu guutsatetsaa keenaa shaakkaade imma. Ubbaykka s'aafetteedda barenttu payduwaa keenaa keenaa akkino. ");
INSERT INTO dwrl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Shin biittay saamaan shaaketto; itti itti zarii laattiyaa biittay unttunttu aawuwaa zariyaa suntsaadan gido. ");
INSERT INTO dwrl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Laata ubbay payduwaan c'oratuwaappenne payduwaan guutsatuwaappe gidduwaan es's'an shaaketto» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Bare yaran yaran paydeteedda Leewatuu hawantta: Gershshoona yaratuwaa, K'ahaata yaratuwaanne Maraara yaratuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Hawanttukka k'ay Leewatuwaa yaratuwaa: Liibina yaratuwaa, Kebroona yaratuwaa, Maahila yaratuwaa, Musha yaratuwaanne K'oraaha yaratuwaa. K'ahaati Amiraama yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amiraama machchati suntsay Yokebeedo; Aa Gibs'en Leewiyaw yeletteedda naatto. Iza Amiraamaw Aaroona, Musanne unttunttu michchato Miiriyaamo yelaaddu. ");
INSERT INTO dwrl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aarooni Nadaaba, Abiiha, El\"aazaranne Itaamaara yeleedda. ");
INSERT INTO dwrl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Shin Med'inaa Goday azazibeena tamaa Aa sintsan yarshsheedda wode, Naadaabinne Abihu hayk'k'eeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Yelettoodeppe itti aginanne hewaappe bollana de'iyaa paydeteedda attuma Leewatuu ubbaanna laatamanne heezzu sha\"a. Israa'eelatuwaa gidduwaan unttunttoo laattiyaa biittay imettibeenna diraw, unttunttu Israa'eelatuwaana paydettibeykkino. ");
INSERT INTO dwrl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Yorddaanoosa Shaafaappe hefintsa baggana, Iyaarikko matan, Moo'aaba Dembban Musenne k'eesii El\"aazari Israa'eelatuwaa paydeedda wode, paydeteedda Asay hawaa. ");
INSERT INTO dwrl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Musenne k'eesii Aarooni kase Siinaa mela biittaan Israa'eelatuwaa paydeedda wode, paydeteedda asaappe haray atto mes's'i itti asaynne attibeena. ");
INSERT INTO dwrl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ayaw gooppe, Med'inaa Goday he Israa'eelatuwaawaa odiidde, «Unttunttu mela biittaan tumu hayk'k'ana» yaagi wotseedda. Yifune na'aa Kaaleebappenne Neewe na'aa Iyyaasuppe attina, haray itti asaynne attibeena. ");
INSERT INTO dwrl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","S'alofihaada mac'c'a naanay Maahilo, No'o, Hoogilo, Milkkonne Tirs's'o. S'alofihaad Hefeera na'aa; Hefeeri Gala'aade na'aa; Gala'aade Maakira na'aa; Maakiri Minaase na'aa; Minaase Yooseefo na'aa. ");
INSERT INTO dwrl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ha mac'c'a naanay Gaketiyaa Dunkkaaniyaa penggiyaan Muse sintsan, k'eesiyaa El\"aazara sintsan, kaappatuu sintsaaninne maabaraa ubbaa sintsan ek'k'iide, hawaadan yaageeddino; ");
INSERT INTO dwrl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Nu aawuu bazzuwaan hayk'k'eedda; I bare nagaran hayk'k'eeddappe attina, Med'inaa Godaa bolla denddeedda K'oraaha kaalliyaawanttu giddon de'enna. Aw attuma na'i baawa. ");
INSERT INTO dwrl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Attuma na'i aw baynnawaa gidooppenne, nu aawuwaa suntsay Aa dabbotuwaa gidduwaappe ayaw d'ayii? Nu aawuwaa ishanttu giddon nuw laattiyaa biittaa imma» yaageeddino. ");
INSERT INTO dwrl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Muse unttunttu ooshaa Med'inaa Godaa sintsa shiishsheedda. ");
INSERT INTO dwrl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«S'alofihaada mac'c'a naanay oochcheeddawe likke; unttunttu aawuwaa ishanttu giddon neeni unttunttoo laattiyaa biittaa imma; Aa laatay unttuntta gakko. ");
INSERT INTO dwrl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","K'ay neeni Israa'eelatuwaa hawaadan yaaga; ‹Itti Asay attuma na'i bayinnan hayk'k'iyaawaa gidooppe, Aa biittaa Aa mac'c'a na'i laatto; ");
INSERT INTO dwrl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","mac'c'a na'ikka aw baynnawaa gidooppe, Aa biittaa Aa ishatuu laattino; ");
INSERT INTO dwrl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","aw ishatuu baynnawaa gidooppe, Aa aawuwaa ishatuu laattino; ");
INSERT INTO dwrl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Aa aawuwaa ishatuukka baynnawaa gidooppe, Aa zariyaappe ubbaappe matattiyaa dabbuwaa laatissa. Taani Med'inaa Goday neena Musa azazeeddawaadan, hawe Israa'eelatoo higge gido› yaaga» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Hewaappe guyyiyaan, Med'inaa Goday Musa, «Pude Abaarima Deretuwaa kesaade, taani Israa'eeliyaa asaw immeedda biittaa be'a. ");
INSERT INTO dwrl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Be'eeddawaappe guyyiyaan, ne ishaa Aaroonedan neenikka hayk'k'aade, ne mayzzan gakettana. ");
INSERT INTO dwrl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Ayaw gooppe, S'iina Bazzuwaan de'iyaa haatsaan Asay ubbay makkaleedda wode, hintte laa\"uukka unttunttu sintsan taana geeshshaadan bonchchanaw taw azazettibeykkita» yaageedda. Hewe haatsay S'iina mela biittaan, K'aadeesan de'iyaa Mariiba haatsaa. ");
INSERT INTO dwrl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Muse Med'inaa Godaa hawaadan yaageedda; ");
INSERT INTO dwrl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","«Abeet Med'inaa Godaw, asaa ubbaw de'uwaa immiyaa S'oossaw, ne asay, S'oossaa Asay hentsanchchay bayinna wudiyaa mala gidennaadan, ha asaa sintsan kesiyaanne geliyaa, unttunttukka kaaletsiide kessiyaanne gelissiyaa, itti asaa ha maabaraa bolla suntsaarkkii» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Med'inaa Goday Musa, «Ayyaanay aan de'iyaa Neewe na'aa Iyyaasa akkaade, ne kushiyaa Aa bolla wotsa; ");
INSERT INTO dwrl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","yaataade k'eesiyaa El\"aazara sintsaaninne maabaraa ubbaa sintsan essaade, unttunttu be'ishin suntsaa. ");
INSERT INTO dwrl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Israa'eelatuwaa maabaraa ubbay aw azazettanaadan, ne maataappe aw shaakkaade imma. ");
INSERT INTO dwrl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","K'eesiyaa El\"aazara sintsan I ek'k'o; El\"aazari Uuriimiyaan aw Med'inaa Godaa sheniyaa oochcho. Iyyaasunne Israa'eeliyaa maabaray ubbay El\"aazara azazuwaan kesinonne Aa azazuwaan gelino» yaageedda. ");
INSERT INTO dwrl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Med'inaa Goday azazeeddawaadan Muse ootseedda; Iyyaasa afiide, k'eesiyaa El\"aazara sintsaaninne maabaraa ubbaa sintsan esseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Med'inaa Goday S'oossay azazeeddawaadan, Muse bare kushiyaa Aa bolla wotsiide, Aa suntseedda. ");
INSERT INTO dwrl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Med'inaa Goday Musa, ");
INSERT INTO dwrl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Israa'eelatuwaa hawaadan yaagaade azaza; ‹Ta k'umaa, taana toshukku giide sawana mala, taman yarshshiyaa ta yarshshuwaa keereedda wodiyaan wodiyaan taw naagiide immite› yaaga. ");
INSERT INTO dwrl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","K'ay neeni unttuntta, ‹Med'inaa Godaw taman yarshshiyaa yarshshuu hawaa: tilla bollana de'iyaa, itti laytsaa gideedda laa\"u dorssaa orggetuwaa hachchi hachchi s'uuggiyaa yarshshoo yarshshite; ");
INSERT INTO dwrl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","dorssaa orggetuwaappe ittuwaa wontta, laa\"entsuwaa omarssi yarshshite. ");
INSERT INTO dwrl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","K'ay hewaana itti liitiro gidiyaa zayitiyaan munak'etteedda itti kiilo giraame muruta zarggaa d'iiliyaa katsaa yarshshoo yarshshite. ");
INSERT INTO dwrl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Hawe Med'inaa Godaa toshukku giide sawana mala, Siinaa Deriyaa bollan azazetteedda, hachchi hachchi taman s'uuggiyaa yarshshuwaa. ");
INSERT INTO dwrl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Hewaana yarshshiyaa ushshaa yarshshuu itti dorssaa orggiyaw itti liitiro gidiyaa woyniyaa eessaa. Ushshaa yarshshuwaa Geeshsha S