﻿USE sofia;
DROP TABLE IF EXISTS sofia.dwrNT_vpl;
CREATE TABLE dwrNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dwrNT_vpl WRITE;
INSERT INTO dwrNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hawe Daawita zariyaanne Abraahaame zare gideedda Yesuusi Kiristtoosa yeletaa odiyaa maxaafaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraahaame, Yisaaqa yeleedda; Yisaaqi, Yayiqooba yeleedda; Yayiqoobi, Yihudaanne A ishatuwaa yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yihuday Ti7imaarippe Paareesanne Zaraahaa yeleedda; Paareese, Hexiroona yeleedda; Hexiroone, Raama yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raame Aminadaaba yeleedda; Aminadaabe, Na7asoona yeleedda; Na7asoone, Selimoona yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Selimoone, Ra7aabo geetettiyaa mishirattippe Boo7eeza yeleedda; Boo7eezi, Uruuto geetettiyaa mishirattippe Iyyoobeeda yeleedda; Iyyoobeede, Issey yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Issey Kaatiyaa Daawita yeleedda. Kaatiyaa Daawite, Ooriyaa machchattippe Solomona yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomone, Robi7aama yeleedda; Robi7aame, Aabiyaa yeleedda; Aabiyay, Aasaafa yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasaafe, Yoosaafeexa yeleedda; Yoosaafeexe, Iyyooraama yeleedda; Iyyooraame, Ooziyaana yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ooziyaane, Iyyoo7aataama yeleedda; Iyyoo7aataame, Akaaza yeleedda; Akaaze, Hizqqiyaasa yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizqqiyaase Minaasa yeleedda; Minaase, Amooxa yeleedda; Amooxe, Iyyoosiyaasa yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Isra7eeliya asay omodettiide, Baabiloone gadiya beedda wode, Iyyoosiyaase Ikkoniyaananne A ishatuwaa yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baabiloone omodduwaappe guyyiyan, Ikkoniyaananne Salaatiyaala yeleedda; Salaatiyaale, Zerubaabeela yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubaabeeli, Abiyuuda yeleedda; Abiyuude, Eeliyaaqeema yeleedda; Eeliyaaqeemi, Azoora yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoore Saadooqa yeleedda; Saadooqe, Akiima yeleedda; Akiime Eliyuuda yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuude, Ali7aazara yeleedda; Ali7aazare, Maataana yeleedda; Maataane, Yayiqooba yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yayiqoobe, Kiristtoosa geetettiyaa Yesuusa yeleedda Mayraamo oochcheedda Yooseefa yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Simmi yeletay ubbay Abraahaamoppe Daawita gakkanaw tammanne oyddu yeleta; Daawiteppe doommiide, asay Baabiloone gadiya omodettiide beedda wodiyaa gakkanaw tammanne oyddu yeleta; asay Baabiloone gadiya omodettiide beedda wodiyaappe Kiristtoosi yeletteedda wodiya gakkanaw tammanne oyddu yeleta. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesuusi Kiristtoosa yeletay hawaa mala; A daaya Mayraama Yooseefoo ooshetta qashetta uttaaddu. He wode Yooseefonna gakettennaan de7aadde, Geeshsha Ayyaanan shahaaraaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Izo giigissi wotheedda Yooseefo xillo asa gideedda diraw, izo kawushshanaw koyyibeenna; iibaa qonccissennaan izo agganaw qoppeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Shin I hewaa qoppishshin, Godaa kiitanchchay akumuwan aananna gakettiide, “Daawite na7aa Yooseefoo, Mayraama Geeshsha Ayyaanan shahaareedda diraw izo akkanaw yayyoppa. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iza attuma na7aa yelanawunnu; neenikka, I asaa nagaraappe ashshiyaa diraw A sunthaa Yesuusa gaade xeesanaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Qassi Goday nabiyaa bagganna, “Wodoratta shahaaranawunnu; na7aakka yelanawunnu; A sunthaykka Ammaneela geetettanawaa” yaageeddawe polettana mala, hawe ubbay haaneedda; “Ammaneela” yaagiyaawe, “Xoossay nuunanna de7ee” yaagiyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yooseefo gemi77ishuwaappe beegottiide, Godaa kiitanchchay barena azazowaadan, Mayraamo bare golle afeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Shin na7ay yelettana gakkanaw Yooseefo izikko shiiqibeenna; qassi na7aakka Yesuusa giide suntheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesuusi Yihudaa gadiyan Beeteliheeme geetettiyaa katamaan Heroodise kawutiide de7iyaa wode yeletteedda; hewaappe guyyiyan, xoolinttiyaa paydiyaa asay awayfi doliyaa baggappe Yeerusalaame yiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ayihuda kaatiyaa gidanaw yeletteedda na7ay haqan de7ii? Nuuni awayfi doliyaa bagganna keseedda A xoolinttiyaa be7iide, aw goyinnanaw yeeddo” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kaatiyaa Heroodise, hewaa sisiide dagammeedda; Yeerusalaamen de7iyaa asay ubbaykka wozanaa bayeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Heroodise qeesatuwaa kaappatuwaa ubbatuwaanne Muse higgiyaa tamaarissiyaawantta xeesiide, “Kiristtoosi haqan yelettanddeeshsha?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Unttunttu zaariide, “Yihudaa gadiyan Beeteliheeme katamaan yelettanawaa. Nabii, ‘Yihudaa gadiyan de7iyaa Beeteliheeme, neeni Yihudaa gadiyan de7iyaa woliqqaama katamatuwaappe laafakka. Isra7eeliya mooddiyaawe neeppe kesanawaa’ giide xaafeedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hewaappe kaalla, Heroodise awayfi doliyaa baggappe yeedda asatuwaa geeman xeesiide, xoolinttii unttunttoo beetteedda wodiyaa unttunttuppe geeshshiide ereedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yaatiide Beeteliheeme unttuntta yeddiidde, “Biide na7aa loythi koyyite; A demmeedda wode taanikka baade aw goyinnanaadan, taanakka erissite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Unttunttu kaatii geeddawaa sisi biidde ogiyaan awayfi doliyaa bagganna unttunttu kase be7eedda xoolinttiyaa be7eeddino; na7ay de7iyaasaa gakkiide eqqana gakkanaw, xoolinttii unttuntta kaaletheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Unttunttu he xoolinttiyaa be7eedda wode, zaway baynna daro nashechchaa nashetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Golle geliide, na7ay bare daayi Mayraaminna de7iyaawaa be7eeddino; gulbbatiide aw goyinneeddino; hewaappe kaalla, barenttu saaxiniyaa dooyyiide, worqqaa, ixaanaanne kawaraa aw imotaa shiishsheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Unttunttu Heroodisakko simmenna mala, Xoossay akumuwan unttuntta, “Hinttena erite” giina hara ogiyaanna barenttu gade simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Unttunttu beeddawaappe guyyiyan, Godaa kiitanchchay akumuwan Yooseefoo beettiide, “Heroodise na7aa wodhanaw koyyiyaa diraw, denddaade na7aanne A daayo akkaade Gibxe gadiyaa beta; taani new odana gakkanaw, yaani de7ashsha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","15","Yooseefo qamma denddiide, na7aanne A daayo akkiide, Gibxe gadiyaa beedda; Goday nabiyaa bagganna, “Taani ta na7aa Gibxe gadiyaappe xeesaaddi” yaageeddawe polettana mala, Heroodise hayqqana gakkanaw I yaani de7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hewaappe guyyiyan, Heroodise awayfi doliyaa baggappe yeeddawanttu barena cimmeeddawaa ereedda wode, daro hanqqettiide, xoolinttii kase beetteedda wodiyaa unttunttuppe siseeddawaadan, wottaaddaratuwaa yeddiide, Beeteliheemeninne yuushshuwaan de7iya laa77u laythaa attuma naanaanne laa77u laythaappe garssanna de7iyaa attuma naanaa ubbaa wodhisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Nabiyaa Ermiyaasi, “Yeekuunne zilassay Raama geetettiyaa katamaan sisetteedda; Raaheela bare naanaw yeekkaw. Unttunttu hayqqidiggo diraw, agga giina, aggennaan ixxaaddu” giide odeeddawe poletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heroodise hayqqeeddawaappe guyyiyan, Godaa kiitanchchay Gibxen Yooseefoo akumuwan beettiide ");
INSERT INTO dwrNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A, “Dendda; na7aanne A daayo akkaade, Isra7eeliya gadiya simma. Na7aa wodhanaw koyyiyawanttu hayqqidiggeeddino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yooseefo denddiide, na7aanne A daayo akkiide, Isra7eeliya simmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Shin Yooseefo Arkkelawoosi bare aawuwaa Heroodisa oydiyaan Yihudaa gadiyan kawuteeddawaa siseedda wode, yaa baanaw yayyeedda; Xoossay aw akumuwan hinttena erite giina, Galiilaa gadiya beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nabatuu, “Asay A, ‘Naazireetiyaa asa’ giide xeesana” yaageeddawe polettana mala, Naazireete geetettiyaa katamaa biide de7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","He wode Xammaqiyaa Yohaannisi asaa, “Saluwaa kawutethay matatteedda diraw, hintte nagaraappe simmite” yaagiidde, Yihudaa mela biittaan odiidde yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ayissi gooppe, nabiyaa Iisiyaase, Yohaannisabaa odiidde, “Ittuu mela biittaan bare qaalaa dhoqqu udiide, ‘Godaa ogiyaa giigissite. I hemettana loossuwaakka aw sitti udite’ geedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohaannisaw gaaluwaa iskiyan dadetteedda mayuu de7ee; qassi bare xeessan dafuwaa dancceedda; I miyaa qumaykka booliyaanne bazzuwaa eessaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Asay he wode Yeerusalaameppe, Yihudaa gadiyaa ubba saappenne Yorddaanoosa Shaafaa heeran de7iyaa gadiya ubbaappe aakko yiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Barenttu nagaraa paaxina, Yorddaanoosa Shaafan asaa xammaqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Shin Yohaannisi daro Parisaawatuunne Saduqaawanatuu xammaqettanaw barekko yiyaawantta be7iide, “Ha shooshshatoo, Xoossaa hanqquu yaana haniyawaappe attana mala, hinttew oone odeeddawe? ");
INSERT INTO dwrNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Simmi hintte, hinttenttu nagaraappe simmeeddawaa erissiyaa oosuwaa, oothite. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hintte hinttenttu wozanaan, ‘Abraahaame nu aabba’ giide qoppiyaawaa hinttew malatoppo. Ayissi gooppe, taani hinttenttussi oday; Xoossay ha shuchchatuwaappe Abraahaamossi naanaa udi denthanaw danddayee. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Beexi mithaa xaphuwan qanxxanaw giigi utteedda; lo77o ayfiyaa ayfenna mithaa ubbay qanxxettiide, tamaan yegettana. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Hintte hinttenttu nagaraappe simmiyaawaa bessanaw, taani hinttena haathaan xammaqay; shin taappe guyyenna yiyaawe, hinttentta Geeshsha Ayyaanaaninne tamaan xammaqana. I taappe daro minnee; A caammaa tookkanawukka taani bessiyaa asa gidikke. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A kushiyan kathaa sexxiyaa layday de7ee. Uddummaan de7iyaa kaathaa loythi geeshshee; bare zarggaa diyyiyan qolana; shin dalaa to7enna tamaan guuddana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesuusi he wode Yohaannisan xammaqettanaw, Galiilaappe Yorddaanoosa geetettiyaa shaafaa aakko beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Shin Yohaannisi, “Taani neenan xammaqettanaw bessiyaa wode, neeni taakko yay?” yaagiide, A digganaw koyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Shin Yesuusi zaariide A, “Nuuni xillotethaa oosuwaa ubbaa hawaadan polanaw bessiyaa diraw, ha77i taw eeno ga” yaageedda. Yohaannisikka aw eeno geedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesuusi xammaqettowaappe guyyiyan, ellekka haathaappe keseedda; saluu dooyettina, Xoossaa Ayyaanay haraphphiyaadan saluwaappe wodhdhiide bare bolla yiyaa wode be7eedda; ");
INSERT INTO dwrNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","qassi saluwaappe, “Taani siiqiyaa, taana nashechchiyaa, ta Na7ay hawaa” yaagiyaa qaalay yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hewaappe guyyiyan, xalahiyaan paacettana mala, Geeshsha Ayyaanay asay de7enna sa7aa Yesuusa afeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesuusi oytamu gallassaanne oytamu qammaa xoomowaappe guyyiyan koshatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xalahii yiide A, “Neeni Xoossaa Na7aa gidooppe, ane ha shuchchatuwaa ukithaa gidana mala ga” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Shin Yesuusi zaariide, “Xoossaa maxaafaan, ‘Asay Xoossay haasayiyaa qaalaa ubbaan de7anaappe attin, ukithaa xalalaan de7enna’ yaagetti xaafetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hewaappe guyyiyan, xalahii Yesuusa geeshsha katamaa afi Geeshsha Golliyaa xeeraan essiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Neeni Xoossaa Na7aa gidooppe, ane duge kundda. Ayissi gooppe, Xoossaa maxaafaan, ‘Xoossay bare kiitanchchatuwaa new azazanawaa’ qassi ‘Unttunttu ne gedi shuchchaan dhubettenna mala, barenttu kushiyan neena denthanawantta’ yaagetti xaafetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesuusi zaariide A, “Qassikka Xoossaa maxaafaan, ‘Godaa ne Xoossaa paaccoppa’ yaagetti xaafetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Qassi xalahii Yesuusa itti daro wolqqaama deriyaa xeeraa kessiide, ha alamiyaan de7iyaa kawutethaa ubbaanne unttunttu bonchchuwaa ");
INSERT INTO dwrNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","bessiide A, “Neeni taw gulbbataade goyinnooppe, taani hawaa ubbaa new immana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","He wode Yesuusi zaariide A, “Laa ha Seexaanaw haakka; ayissi gooppe, Xoossaa maxaafaan, ‘Godaw, ne Xoossaw goyinna; A xalalaa gosheta’ geetetti xaafetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hewaappe guyyiyan, xalahii Yesuusa aggina, kiitanchchatuu yiide, aw ootheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yohaannisi qashetteeddawaa Yesuusi siseedda wode, Galiilaa geetettiyaa gadiyaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naazireeteppe kesiide, Qifirinaahooma katamaa biide, yaani de7eedda; Qifirinaahoomi Zaabiloonaninne Nifttaaleeme gadiyan de7iyaa Galiilaa abbaa mataan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hawe haneeddawe nabiyaa Iisiyaasi, ");
INSERT INTO dwrNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zaabiloone gadiyaninne Nifttaaleeme gadiyan, abbaa ogiyaan Yorddaanoosa Shaafaappe hefintha baggan, Ayihuda gidenna asay de7iyaa Galiilaan, ");
INSERT INTO dwrNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","dhumaani de7iyaa asay wolqqaama poo7uwaa be7eedda. Qassi hayquwaa kuway de7iyaa gadiyan utteeddawanttoo poo7uu keseedda” yaageeddawe polettana malaassa. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","He wodiyaappe doommiide Yesuusi, “Hintte nagaraa paaxite; ayissi gooppe, saluwaa kawutethay matatteedda diraassa” giide qaalaa oduwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuusi Galiilaa Abbaa mataanna aadhdhiidde, laa77u ishatuu Phexiroosa geetettiyaa Simooninne A ishaa Inddiraasi, moliyaa oyqqiyaawantta gido diraw, dabbaa abbaan yeggiyaawantta be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Unttuntta, “Taana kaallite; taani hinttena moliyaa oyqqiyaawaadan asaa taakko ahiyaa ogiyaa tamaarissana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Unttunttu ellekka barenttu dabbaa aggiide, Yesuusa kaalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesuusi hewaappe sinthakko biidde, hara laa77u ishatuwaa, Zabiddiyoosa naanaa Yayiqoobanne A ishaa Yohaannisa be7eedda; unttunttu barenttu aawuwaa Zabiddiyoosanna haathaa bollan biyaa wonggiriyaa giddon barenttu dabbaa giigissiyaawantta be7iide, xeeseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Unttunttu ellekka haathaan biyaa wonggiriyaanne barenttu aawuwaa aggiide, Yesuusa kaalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuusi Ayihuda woosa golletuwan tamaarissiidde, kawutethaa mishiraachchuwaa qaalaa odiiddinne qassi harggiyaa ubbaappenne sakuwaa ubbaappe asaa pathiidde, Galiilaa gadiyaa ubbaan yuuyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A waarii Sooriyaa gadiyaa ubbaa gakkeedda; dumma dumma harggiyaan oyqettiide harggeedda asaa ubbaa, xalahatuwaan oyqetteeddawantta, yiicuwaa sakuu de7iyaawantta, qassi gunddeedddawantta asay Yesuusakko aheedda; I unttuntta patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Cora asay Galiilaappe, tammu katamatuwappe, Yeerusalaameppe, Yihudaappenne Yorddaanoosappe hefinthan de7iyaa gadiyaappe Yesuusa kaalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuusi cora asaa be7iide, pude deriyaa kesiide utteedda. A kaalliyaawanttu aakko shiiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Unttuntta hawaadan yaagi tamaarissuwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Barenttu ayyaanaa de7uwaan hiyyeesaa gideeddawaa eriyaawanttu anjjetteeddawantta; ayissi gooppe, saluwaa kawutethay unttunttussa. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kayyottiyaawanttu anjjetteeddawantta; ayissi gooppe, Xoossay unttuntta minissana. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ashikke gideeddawanttu anjjetteeddawantta; ayissi gooppe, unttunttu sa7aa laattana. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Xillotethaa koshattiyaawanttunne saamettiyaawanttu anjjetteeddawantta; ayissi gooppe, Xoossay unttuntta kalissana. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Maariyaawanttu anjjetteeddawantta; ayissi gooppe, Xoossay unttuntta maarana. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wozanaa geeshshatuu anjjetteeddawantta; ayissi gooppe, unttunttu Xoossaa be7ana. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Asaa sigethiyaawanttu anjjetteeddawantta; ayissi gooppe, Xoossay unttuntta, bare naanaa giide xeesana. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Xillotethaa diraw yedersettiyaawanttu anjjetteeddawantta; ayissi gooppe, saluwaa kawutethay unttunttussa. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Hintte taana kaalliyaa diraw, asay hinttena boriyaa wodenne waayissiyaa wode, qassi hintte bolla iitabaa ubbaa wordduwan haasayiyaa wode, hintte anjjetteeddawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hinttew saluwan wolqqaama woytay de7iyaa diraw, nashettite; hashshu giite; ayissi gooppe, asay hintteppe kase de7eedda nabatuwaa hewaadan yedersseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Asaa ubbaassi hintte maxine mala; shin maxinii mal77ana dhayooppe, zaariide A wooti mal77ethanee? Kare olina, asay A yedhdhi hamettanaappe attin, sinthaw aynne maaddenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ha alamew hintte poo7o; deriyaa huuphiyan keexetteedda katamay geemmana danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Xomppiyaa xomppiide, soyin de7iyaa asaa ubbaw poo7ana mala, dhoqqiyaa saan wotheeppe attin, kammiyaa miishshaa giddon qum77i wothiyaa asay ooninne baawa. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hewaadankka, asay hintte oothiyaa lo77o oosuwaa be7iide, saluwan de7iya hintte Aawuwaa bonchchana mala, hintte poo7uu asaa sinthaan poo7o. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Taani Muse higgiyaanne nabatuu tamaarissiyaawaa dhayissanaw yeeddawaa hinttew malatoppo; taani polanaw yeeddawaappe attin, dhayissanaw yabeykke. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ayissi gooppe, taani hinttew tumuwaa oday; saluunne sa7ay aadhdhana gakkanaw, qassi ubbabaykka polettana gakkanaw, higgiyaappe itti cachchaykka woy qeeri pidoliikka aadhdhenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hewaa diraw, ha azazuwaa ubbaappe guuxxiyaa itti azazuwaa menthiyaa uray ooninne, qassi haratuukka barewaadan hananaadan tamaarissiyaa uray ooninne, saluwaa kawutethaan ubbaappe guutha gidana; shin azazuwaa oothiyaawenne haranttukka oothanaadan tamarissiyaawe ooninne saluwaa kawutethaan dhoqqa gidana. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ayissi gooppe, hintte xillotethay Muse higgiyaa tamaarissiyaawanttu xillotethaappenne Parisaawatuwaa xillotethaappe darana dhayooppe, saluwaa kawutethaa hintte mule gelennawaa taani oday. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Beni asaw, ‘Asaa wodhoppa; asaa wodheedda ooninne pirddettana’ geeddawaa siseeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Shin taani hinttew oday; bare ishaa hanqqettiyaa ubbay pirddettana; bare ishaa boriyaa ubbay shangguwaa pirddaw shiiqana; qassi bare ishaa, ‘Dhullowe’ giyaa ubbay Gaannamiyaa tamaa pirddaw shiiqana. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Hewaa diraw, neeni yarshshiyaasaan yarshshishshin, ne ishaa naaqqeeddabay new hewaan hassayettooppe, ");
INSERT INTO dwrNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ne yarshshuwaa hewaan aggaade ba; kasetaade ne ishaanna sigetta digga; hewaappe kaalla yaade, ne yarshshuwaa yarshsha. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Neena mootiyaawaanna wodii de7ishshin elle aananna sigetta digga; hewe dhayooppe, I neena daannaa sintha aathana; qassi daannay neena polisew aathi immina, polisii neena qasho gollen yeggana. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Taani new tumuwaa oday; neeni itti santtimii attennaan, ne maggaccuwaa wurssaade ciggana gakkanaw, mulekka qasho golleppe kesakka. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ ‘Woshummoppa’ geeddawaa siseeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Shin taani hinttew yaagay; ‘Maccawunno xeelliide amottiyaa ubbay, bare wozanaa giddon he wode iinanna woshummeedda.’ ");
INSERT INTO dwrNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne ushechcha ayfii neena nagaraa oosisooppe, neeppe woocaade olaa agga; ayissi gooppe, ne bollay mulekka Gaannamiyaa tamaan olettiyaawaappe, aappe ittuu paccintto new lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Qassi ne ushechcha kushii neena nagaraa oosisooppe, neeppe qanxxaade olaa agga; ayissi gooppe, ne bollay mulekka Gaannamiyaa tamaan olettiyaawaappe, aappe ittuu paccintto new lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ ‘Qassi bare machchatto yeddiyaa ooninne izo yeddiyaa paramaa immo’ geetetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Shin taani hinttew yaagay; ‘Bare machchatta woshummennaan de7ishshin yeddiyaa ooninne izo woshumma kessee; qassi asinay yeddeedda mishiratto akkiyawe ooninne woshummee.’ ");
INSERT INTO dwrNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Qassi beni asaw, ‘Wordduwan caaqqoppa; shin ne Godaw caaqqeeddawaa pola’ geeddawaa siseeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Shin taani hinttew yaagay; ‘Ubbakka caaqqoppite’; saluu Xoossaa kawutethaa oydiyaa gidiyaa diraw, ‘Saluwan caaqqoppite’ ");
INSERT INTO dwrNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","qassi sa7ay A gedi yedhdhiyaasaa gidiyaa diraw, ‘Sa7aan caaqqoppite’; qassikka, Yeerusalaame wolqqaama kaatiyaa katamaa gidiyaa diraw, ‘Yeerusalaamenikka caaqqoppite’ ");
INSERT INTO dwrNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Neeni itti binnanaakka bootha woy karethaa kessanaw danddayenna diraw, ‘Ne huuphiyankka caaqqoppa.’ ");
INSERT INTO dwrNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Shin hintte, ‘E’ woy, ‘Gidenna’ giite; hawanttuppe haray Seexaanaappe yee. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ ‘Ayifiyaa diraw ayifiyaa; achchaa diraw achchaa’ geeddawaa siseeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Shin taani hinttew yaagay; ‘Hinttew iitabaa oothiyaa uraw iitan zaaroppite; ooninne ne ushechcha bagga shayyiyaa baqqooppe, ne haddirssa bagga shayyiyaakka A bessa; ");
INSERT INTO dwrNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ne shaamiciyaa akkanaw itti uray neena mootooppe, he uraw ne kootiyaakka gujja imma. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ooninne neena itti saatiyaa ogiyaa barenanna baanaadan wolqqanthooppe, aananna laa77u saatiyaa ogiyaa ba. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Neena woossiyaa uraw imma; qassi neeppe tal77ana koyyiyaa urawukka diggoppa.’ ");
INSERT INTO dwrNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ ‘Ne laggethatuwaa siiqa; ne morkkiyaa morkka’ geeddawaa siseeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","Shin taani hinttew yaagay; saluwan de7iyaa hintte Aawuwassi naanaa gidana mala, hintte morkketuwaa siiqite; hinttena sheqqiyaawantta anjjite; hinttena ixxiyaawanttoo lo77obaa udite; hinttena yederssiyaawanttoo, Xoossaa woossite; ayissi gooppe, iita asawukka lo77o asawukka Xoossay bare awaa awaxxissee; qassi xillatuwassikka nagaranchchatuwaassikka bare iraa bukissee. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hintte hinttena siiqiyaawanttu xalalaa siiqooppe, hinttew ay woytay de7ii? Haray atto, nagaranchchatuukka hewaadan udiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hintte hinttenttu ishatuwaa xalalaa sarotooppe, haratuu udiyaawaappe aadhdhiyaabaa ayaa udeedditee? Haray atto, Ayihude gidenna asaykka hewaadan udee. ");
INSERT INTO dwrNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hewaa diraw, saluwan de7iyaa hintte Aawuu polo gidowaadan, hinttekka polo gidite. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Hintte lo77o oosuwaa asaa bessanaw asaa sinthaan oothenna mala naagettite; hewe dhayooppe, saluwan de7iya hintte Aawuu hinttew gatiyaa immenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Hewaa diraw, hintte awudenne hiyyeesaw immiyaa wode, lo77a malatiyaa iitatuu barentta bonchchissanaw, Ayihuda woosa golleninne ogiyaan haraani be7ettanaw udiyaawaadan udoppite; taani hinttew tumuwaa oday; unttunttu barenttu gatiyaa akkidiggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Shin neeni hiyyeesaw immiya wode, geeman immanaadan, ne ushechcha kushii oothiyaawaa haddirssa kushii eroppo. Geeman ootheeddawaa be7iyaa ne Aabbu, ne lo77o oosuwaa gatiyaa zaaranawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Xoossaa woossiidde, lo77a malatiyaa iitatuwadan hanoppite; ayissi gooppe, barentta asay be7ana mala, Ayihuda woosa golleninne ogiyaa doonan eqqiide, Xoossaa woossiyaawaa dosiino; taani hinttew tumuwaa oday; unttunttu barenttu gatiyaa ubbaakka akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Shin neeni Xoossaa woossiyaa wode, ne golle gela; ipithaa qachchaade, beettenna ne Aawuuwaa woossa; geeman oosettowaa be7iyaa ne Aabbu new immanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Xoossaa hintte woossiyaa wode, Xoossaa ammanenna asaadan, coo mela zaarethuwaa darissoppite; unttunttu haasayaa daruwan sisettee giide qoppiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hewaa diraw, he asaadan hanoppite; ayissi gooppe, hintte Aabbu hinttena koshshiyaawaa hinttenttu woossanaappe kasetiide eree. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Simmi hinttenttu hawaa mala woosaa woossite; ‘Saluwan de7iyaa nu Aabboo, ne geeshsha sunthay anjjetto. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ne Kawutethay yo; ne shenii saluwan haneeddawaadan, sa7ankka hano. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gallassaan gallassan koshshiyaa qumaa nuussi hachche imma. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nuuni nuuna naaqqowanttussi atto yaagiyaawaadan, neenikka nu naaquwaa atto ga. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nuuna iitabaappe ashshappe attin, paaciyaan gelissoppa. Kawutethay, wolqqaynne bonchchuu medhinawukka neessa. Amen77i’ ");
INSERT INTO dwrNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Hinttenttu hinttena naaqqeedda hara asaa naaquwaa atto gooppe, saluwan de7iyaa hinttenttu Aawuukka hinttew atto gaana. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","“Shin hinttenttu hinttena naaqqeedda hara asaa naaquwaa atto gaana dhayooppe, hinttenttu Aawuukka hintte naaquwaa atto geenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Qassi hinttenttu xoomiyaa wode, lo77a malatiyaa iitatuwaadan, kayyottiyaawaa malatoppite; ayissi gooppe, unttunttu xoomiyaawaa asay be7ana mala, barenttu som77iyaa bullaalissiino; taani hinttenttoo tumuwaa oday; unttunttu barenttu gatiyaa akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","“Shin hinttenttu xoomiyaa wode, hinttenttu Aabbu hintte xoomiyaawaa erooppe attin, asay erenna mala, hintte som77iyaa meecettite; hintte huuphiyaakka okettite; yaatooppe, beettenna hintte Aawuu hinttenttu oothiyaawaa geeman be7iide, hintte gatiyaa immanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Miishshaa bil77ay miyasaaninne biratay shi7iide bayizziyaasan, kayisuukka bookkiide wuu77iyaasan, ha sa7aan hinttenttu huuphiyaassi dagayoppite. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Shin bil77ay meennasaaninne shi7enna saan, kayisuukka bookkiide wuu77enna saan hinttenttu huuphiyaassi saluwan miishshaa dagayite. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ayissi gooppe, ne wozanay ne miishshay de7iyaasaan de7ana. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Bollaa poo7uu ayfiyaa; hewaa diraw, ne ayfii paxa gidooppe, ne bollaa ubbay poo7o gidana. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Shin ne ayfii paxa gidana dhayooppe, ne bollaa ubbay dhumana; simmi neenan de7iyaa poo7uu dhumooppe, dhumay ay keenaa daranee! ");
INSERT INTO dwrNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Laa77u godatuwaassi moodettanaw danddayiyaawe ooninne baawa; ayissi gooppe, ittuwaa ixxiide, yokkuwaa siiqee; woy ittuwaa bonchchiide, yokkuwaa kadhee; itti asay Xoossaassinne shaluwaassi moodettanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Hewaa diraw, taani hinttenttoo oday; hintte de7oo maanabawunne ushanabaw, woy hintte bollaw mayyanabaw hirggoppite; shemppuu qumaappe aadhdhennee? Qassi bollay mayuwaappe aadhdhennee? ");
INSERT INTO dwrNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Paalliyaa kafatuwaa xeellite; unttunttu zerikkino; cakkikkino; diyyiyankka qolikkino; shin saluwan de7iyaa hinttenttu Aawuu unttuntta mizee; hinttenttu unttunttuppe loythi darkkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hinttenttu giddon darissi hirggiide, bare geesaa bolla itti wadhaa gujjanaw danddayiyaawe oonee? ");
INSERT INTO dwrNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ayissi mayuwassi hirggiitee? Dembban de7iya ciishshatuu wooti dicciinontto, akeeki xeellite; unttunttu daaburikkino woy puuttuwaa suqqikkino. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Shin taani hinttenttoo oday; haray atto, Solomone hewaa keena bonchchetteeddawaa gidiidde, he ciishshatuwaappe ittuwaa malaakka mayyibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Shin laafa ammanuu de7iyaawanttoo, Xoossay, hachche de7iide, wontti tamaan eexxiyaa dembbaa maataa mayizziyawe, hinttena unttuwaappe aathiide wooti mayizzennee? ");
INSERT INTO dwrNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Simmi, ‘Nuuni ayaa maanee? Woy ayaa ushanee? Woy ayaa mayyanee?’ yaagiide hirggoppite. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ayissi gooppe, he ubbabaa Xoossaa ammanennawanttu darissiide koyyiino; he ubbay hinttena koshshiyaawaa saluwan de7iyaa hinttenttu Aawuu eree. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Shin kasetiide, Xoossaa kawutethaanne A xillotethaa koyyite; I hinttenttoo he ubbabaa immana. ");
INSERT INTO dwrNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hewaa diraw, wonttibaassi hirggoppite; ayissi gooppe, wontti gallassay barew hirggana; gallassaa ubbawukka A huuphew gidiyaa waayyii de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Xoossay hinttenttu bolla pirddenna mala, hinttekka haratuwaa bolla pirddoppite. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ayissi gooppe, hinttenttu haratuwaa bolla pirddiyaawaadan, Xoossay hinttenttu bolla pirddana; qassi hinttenttu haratuwaassi immanaw makkiyaabaan I hinttew makkana. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ne ayfiyan de7iyaa tuussaa be7akka; shin ne ishaa ayfiyan de7iyaa suullaa ayissi xeellay? ");
INSERT INTO dwrNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Woy ne ayfiyan tuussay de7ishshin, neeni ne ishaa, ‘Taani ne ayfiyaappe suullaa kessoo’ waanaade gaanaw danddayay? ");
INSERT INTO dwrNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Laa ha lo77uwaa malatiyaa iitaw! Kasetaade ne ayfiyaappe tuussaa kessadigga; hewaappe guyyiyan, ne ishaa ayfiyaappe suullaa kessanaw geeshshaade xeellanaw danddayaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Geeshshabaa kanatuwassi immoppite; unttunttu guyye simmiide, hinttena sa77ana. Qassi inqquwaa geetettiyaa hinttenttu al77o shuchchaa gudunthatuwaa sinthan oloppite; unttunttu barenttu gediyan yedhdhana. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Woossite; hintte akkana. Koyyite; hintte demmana. Kariyaakko yiide xeesite; hinttew penggi dooyettana. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ayissi gooppe, woossiyaa ubbay akkana; koyyiyaa uray demmana; qassi kariyaakko yiide xeesiyaa uraw penggi dooyettana. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Woy hinttenttu giddon bare na7ay, ‘Ukithaa imma’ gooppe, shuchchaa immiyaa aawuu de7ii? ");
INSERT INTO dwrNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Qassi, ‘Moliyaa imma’ gooppe, aw shooshshaa immanawee? ");
INSERT INTO dwrNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hinttenttu iita gidiidde, hinttenttu naanatuwassi lo77obaa immiyaawaa erooppe, yaatina, saluwan de7iyaa hinttenttu Aawuu barena woossiyaawanttussi lo77obaa wooti darissi immennee! ");
INSERT INTO dwrNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Hewaa diraw, hara asay hinttew oothanaw koyyiyaa ubbabaa hinttekka asaw oothite; ayissi gooppe, Muse higgiyaa bilethaynne nabatuu tamaarissiyaawe hawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Un77a penggiyaanna gelite. Ayissi gooppe, bayethaw afiyaa penggi aakuwaa; ogiikka woggaa. Hewaanna geliyaa asaykka cora. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","“Shin, de7oo afiyaa penggi un77a; ogiikka xunthaa. Qassi hewaa demmiyaawanttukka guutha. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Bolla bagganna dorssaa malatiide, hinttekko yiyaa worddo nabatuwaappe naagettite; shin unttunttu garssa bagganna wallatuwaa mala. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Unttunttu ayfiya ayfiyaawaan hintte unttuntta erana; agunthay woddenthaa ayfiyaa ayfenna; gomi77oriikka kookiyaa ayfiyaa ayfenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hewaadankka, lo77o mithaa ubbay lo77o ayfiya ayfee; shin iita mithay iita ayfiyaa ayfee. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lo77o mithay iita ayfiyaa ayfanaw danddayenna; qassi iita mithaykka lo77o ayfiyaa ayfanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lo77o ayfiyaa ayfenna mithaa ubbay qanxxettiide, tamaan yegettana. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hewaa diraw, hintte unttunttu ayfiyaa ayfiyaawaan unttuntta eranita. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Saluwan de7iyaa Ta Aabbu geeddawaa oothiyaa uray saluwaa kawutethaa gelanaappe attin, ‘Godaw, Godaw’ giyaa ubbay gelenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pirdda gallassi daro asay taana, ‘Godaw, Godaw, nuuni ne sunthan Xoossay kiittowaa odibeykkoo? Ne sunthan xalahatuwaa kessibeykkoo? Qassi nuuni Xoossay oothiyaa maalalissiyaabaa ne sunthaan oothibeykkoo?’ yaaganawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Taani he wode unttuntta, ‘Taani hinttena ubbakka erikke; iitabaa oothiyaawanttu hintte ta matappe haakkite’ yaagana. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Hewaa diraw, hawaa ta qaalaa sisiide oothiyaa ubbay mino zaallaa bolla bare golliya keexxeedda wozanaama asaa mala. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iray bukkiide, di7uu di77eedda; carkkuukka carkkiide, he golliya sugeedda. Shin golli mino zaallaa bolla keexetteedda diraw, kunddibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Hawaa ta qaalaa sisiide oothenna asay ubbay, bare golliya shafiyaa bolla keexxeedda booza asaa mala. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iray bukkiide, di7uu di77eedda; carkkuukka carkkiide, he golliya sugina, golli ellekka kunddeedda. He golli wolqqaama kunddethaa kunddeedda.” ");
INSERT INTO dwrNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuusi bare haasayiyawaa wursseedda wode, asay I tamaarissiyawaan maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ayissi gooppe, I unttuntta tamaarissiidde, Muse higgiya tamaarissiyaawanttudaan gidennaan, maatay de7iyaa asaadan tamaarisso diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuusi deriyaappe wodhdheedda wode, cora asay A kaalleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","He wode oolluu oyqqeedda itti bitani Yesuusakko yi A sinthaan gulbbatiide, “Godaw, ne shene gidooppe, taana pathaade geeshshanaw danddayaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesuusi bare kushiyaa yeddi A bochchiide, “Taani koyyay; paxaade geeyya!” yaageedda. Ellekka oolluu bitaniyaa yeddi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesuusi A, “Simmi hawaa oossinne odoppa; shin qeesaakko baade ne paxaade geeyyeeddawaa A bessa; ne paxaade geeyyeeddawaa asaa erissanaw Muse azazeedda yarshshuwaa Xoossaw yarshsha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Yesuusi Qifirinaahooma katamaa geleedda wode, itti Roomaa gade Xeetuwaa Kaappuu aakko yiide, “Ta Godaw, ta qoomaa bollay gunddina, daro sakettiidde, soyin giseedda; hayyagodo taw pathaarikki” yaagi woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesuusi, “Taani baade A pathana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Shin xeetuwaa kaappuu zaariide, “Ta Godaw, neena ta soy gelissanaw taw bessenna; shin neeni qaalaa xalalaa haasaya; ta qoomay paxanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ayissi gooppe, taani taappe bollanna de7iyaawanttoo eeno giyaa asa; qassi taappe garssaanna wottaaddaratuu de7iino. Taani ittuwaa, ‘Ba!’ gooppe bee; qassi yokkuwaa, ‘Haaya!’ gooppe yee; ta qoomaa, ‘Hawaa ootha!’ gooppe oothee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuusi hewaa siseedda wode maalalettiide, barena kaalliyaa asaa, “Taani hinttew tumuwaa oday; taani hawaa mala ammanuwaa haray atto, Isra7eeliya gadiyankka be7abeykke. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Cora asay awayfi doliyaa baggappenne wulliyaa baggappe yiide, Abraahaamonna, Yisaaqannanne Yayiqoobanna saluwaa kawutethaa gayitaan ittippe uttanawantta yaagay. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Shin kawutethaan de7anaw bessiyaa asay wolqqaama dhumaa garssa kare olettana; hewaan unttunttu yeekkananne barenttu achchaa dhaqanawantta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hewaappe kaalla Yesuusi xeetuwaa kaappuwaa, “Ne soy ba; neeni ammaneeddawaadan new hano” yaageedda; xeetuwaa kaappuwaa qoomay he saatiyankka paxi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuusi Phexiroosa soy biide, A bollotatta qoxuwaa harggaade giseeddawunno be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Izi kushiyaa Yesuusi bochchina, qoxuu izo bashi aggeedda; izakka denddaade aw miyaabaa giigissaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","17","Sa7ay omarsseedda wode, asay iita ayyaanatu oyqqeedda cora asaa Yesuusakko aheedda; nabiyaa Iisiyaasi, “I nu daaburaa barew akkeedda; qassi nu harggiyaakka tookkeedda” yaageeddawe polettana mala, Yesuusi iita ayyaanatuwaa bare qaalaan kessiide, harggeedda asaa ubbaakka patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuusi cora asay bare yuushshuwaan de7iyaawantta be7iide, abbaappe hefintha pinnana mala, barena kaalliyaawantta azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hewaappe guyyiyaan Muse higgiyaa tamaarissiyaa ittuu aakko yiide, “Tamaarissiyaawoo, neeni biyaasaa ubbaa taani neena kaallana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesuusi A, “Worakanatuwassi ollay de7ee; kafatuwaassikka keethay de7ee; shin Taw, Asaa Na7aw, shemppa akkiyaasaykka baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Qassi kaalliyaawanttuppe ittuu Yesuusa, “Godaw, taani sinthata baade ta aabba mooganaw ba yaagaarikkii” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Shin Yesuusi A, “Neeni taana kaalla; hayqqeeddawanttu barenttu anhaa moogino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuusi wonggiriyaan geloode, A kaalliyaawanttu aananna beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Beetay wonggiriyaa mittana gakkanaw, abbaan wolqqaama hobbii denddeedda; shin Yesuusi gemi77isheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A kaalliyaawanttu aakko biide, gemi77ishuwaappe dentheeddino; hewaappe simmiide A, “Godaw, nuuni dhayeetto; nuuna ashshaarikkii” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesuusi unttuntta, “Ha ammanuu pacceeddawanttoo, ayissi yayyiitee?” yaageedda. Hewaappe guyyiyan denddiide, gotuwanne beetaa aggite giina, gotuunne beetay co77u geedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Asay maalalettiide, “Hawe laa haray atto, gotuunne beetay azazettiyaawe ayba asee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesuusi Galiilaa abbaappe hefinthan de7iyaa Gerggesenoona geetettiyaa gadiyaa pinneedda; iita ayyaanatuu oyqqeedda laa77u asatuu he gadiyaan de7iyaawanttu duufuwaappe kesiide, aananna gaketteeddino. Unttunttu daro iita gidiyaa diraw, ooninne he ogiyaanna aadhdhanaw danddayibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Unttunttu barenttu qaalaa dhoqqu oothiide, “Xoossaa Na7aw, nuunanna new ayi allaalli de7ii? Wodii gakkennaan nuuna muranaw yaaddii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Unttunttuppe laafaa haakkiyaasan gudunthaa wudii heemettee. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Iita ayyanatuu Yesuusa, “Neeni nuuna kessiyawaa gidooppe, hini gudunthaa wudiyaa giddo yeddaarkkii” yaagiide woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesuusi unttuntta, “Biite!” giina unttunttu bitanatuwaappe kesi biide, gudunthatuwan geleeddino. Gudunthaa wudii ubbay kakaa lanqqiyanna kajjottiidde, abbaan geliide, mitetti aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gudunthaa wudiyaa heemmiyaawanttu baqatiide katamaa bi aggeeddino; beeddasaan iita ayyanatuu oyqqeedda asatuu haneeddabaa ubbaa odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hewaa siseedda katamaan de7iyaa asay ubbay Yesuusanna gakettanaw keseeddino; A be7eedda wode, barenttu gadiyaappe baana mala woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hawaappe kaalla Yesuusi wonggiriyaan geliide, abbaa pinniide, bare katamaa yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Amareedda asay bollay gunddeeddda itti bitaniyaa shanchchamaan tookkiide, Yesuusakko aheeddino; Yesuusi unttunttu ammanuwaa be7iide, bollay gunddeeddda bitaniyaa, “Ta na7aw, yayyoppa; ne nagaray atto geetetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Higgiyaa tamaarissiyaawanttuppe ittu ittu barenttu wozanaan, “Laa ha bitani Xoossaa bolla iitabaa haasayeettee!” yaagi qoppeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuusi unttunttu qofaa eriide, unttuntta hawadaan yaageedda; “Hinttenttu hintte wozanaan hawa mala iitabaa ayissi qoppiitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Ne nagaray atto geetetteedda’ yaagiyaawe mateeyee? Woy, ‘Dendda eqqaade hametta’ yaagiyaawe matee? ");
INSERT INTO dwrNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Shin sa7aa bollan nagaraa atto gaanaw taw, Asaa Na7aw, maatay de7iyaawaa taani hinttena erissana” yaagiide, hewaappe guyye I he bollay gunddeedda bitaniyaa, “Dendda eqqa; yaataade ne shanchchamaa tookkaade, ne golle ba” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gunddeedda bitaniikka denddi eqqiide, bare golle beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Shin daro asay hewaa be7iide yayyeeddino; asaw hawaa mala maataa immeedda Xoossaa galateeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuusi hewaanna aadhdhiidde, Maatoossa yaagiyaawe qaraxaa qanxxiyaa saan utteeddawaa demmiide A, “Taana kaalla” yaageedda. Maatoossikka denddi eqqiide, A kaalleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesuusi Maatoossa gollen qumaa maanaw utti de7ishshin, qaraxaa akkiya cora asaynne nagaranchchatuu yiide, aanannanne A kaalliyaawanttunna ittippe gayitaan utteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Itti itti Parisaawatuu hewaa be7iide, Yesuusa kaalliyawantta, “Hinttena tamaarissiyaawe qaraxaa qanxxiyaawanttunnanne nagaranchchatuwanna qumaa ayissi ittippe mii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Shin Yesuusi unttunttu yaagiyaawaa sisiide, “Hargganchchatuwaassappe attin, paxatuwaassi aakimii koshshenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Shin hinttenttu biide, Xoossaa Maxaafay, ‘Taani maarotethaa koyyayppe attin, yarshshuwaa koyyikke’ yaagiyaawe waagiyaawentto erite; ayissi gooppe, taani nagaranchchatuwaa xeesanaw yeeddawaappe attin, xillatuwaa xeesanaw yabeykke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","He wode Yohaannisa kaalliyawanttu Yesuusakko yiide, “Nuuninne Parisaawatuu ubba wode xoomeetto; shin neena kaalliyawanttu ayissi xoomikkinoo?” yaagiide A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesuusi unttuntta, “Bullachchaa yeedda asay machchatto akkiyawe barenttunna de7ishshin, kayyottanaw danddayiinoo? Danddayikkino; shin machchatto akkiyawaa unttunttu matappe afana wodii yaana; unttunttu he wode xoomanawantta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Eca mayuwaa bolla ooratha dhefiyaa wothiide sikkiyaa asay baawa; ayissi gooppe, ooratha dhefii eca mayuwaa peedhereethana; peedhethaykka kasewaappe daranawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ho77o woyiniyaa eessaa eca ogoruwan naa77iyaa asay baawa. Shin naa77ooppe, he woyiniyaa eessay ogoruwaa daakkana; barewukka woofettana; ogoruukka bayanawaa. Shin, ho77o woyiniyaa eessaa ooratha ogoruwaan naa77anaw bessee; laa77uukka baykkino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuusi unttunttoo hewaa odishshin, Ayihude Woosa Golle kaappatuwaappe ittuu aakko yi A sinthaan gulbbatiide, “Ta naatta ha77i hayqqaaddu; shin neeni yaade ne kushiyaa izi bolla wothaarikkii; iza de7uwaan de7anawunnu” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesuusi denddiide, barena kaalliyawanttunna ittippe bitaniyaa kaalliide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","He wode tammanne laa77u laythaa kumenthaa, izi bollaappe suuthay goggiyaa itti mishiratta guyyenna shiiqaade, Yesuusa mayuwaa macaraa bochchaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Hawaa iza udowe, iza bare wozanaan, “Taani A mayuwaa xalalaa bochchantto paxana” yaagaade qoppaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Shin Yesuusi yuuyyi izo xeelliide, “Ta naattee, yayyoppa; neena ne ammanuu patheedda” yaageedda. He man77iyankka mishiratta paxaa aggaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesuusi Ayihuda Woosa Golle kaappuwaa soy gakkeedda wode, yeekuwan dinkkaa punniyaa asaanne yeekkiyaa asaa be7iide, ");
INSERT INTO dwrNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Kare kesite; guutha naatta gemi77ishaadduppe attin, hayqqabeykku” yaageedda. Hewaappe guyyiyan asay A bolla darii miicceedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Shin cora asaa kare I kesseeddawaappe guyyiyan, golle geliide, naatti kushiyaa oyqqeedda; naattakka dendda aggaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","He waarii, he man77iyankka he gadiyan ubbaan sisetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuusi hewaanna aadhdhiide biyaa wode, laa77u qooqatuu barenttu qaalaa dhoqqu udiide, “Daawite na7aw, nuuna maaraarikki” yaagiidde A kaalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesuusi golle geleeddda wode, qooqatuu aakko yeeddino; Yesuusi unttuntta, “Taani hawaa oothanaw danddayiyaawaa ammaniitee?” yaageedda. Unttunttu, “E Godaw” yaagi zaareeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hewaappe guyyiyan, Yesuusi unttunttu ayfiyaa bare kushiyaan bochchiide unttuntta, “Hinttew hinttenttu ammanuwaadan hano” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Unttunttu ayfii dooyetti aggeedda; Yesuusi unttunttoo, “Hawaa oossinne odoppite” yaagiide minissiide odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Shin unttunttu biide, he gadiyaa ubbaan Yesuusabaa odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Unttunttu kesiide biya wode, amareedda asay iita ayyanay oyqqina duudeedda bitaniyaa Yesuusakko aheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesuusi iita ayyaanaa kesseeddawaappe guyyiyan, duude bitani haasayeedda. Asay, “Hawe oorathabaa; hawaa malabay Isra7eeliyaa gadiyaan ubbakka hanibeenna” yaagi maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Shin Parisaawatuu, “I iita ayyaanatuwaa kaappuwaa wolqqaan xalahatuwaa kessee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuusi unttuntta Ayihuda woosa golletuwan tamaarissiiddenne kawutethaa wonggalaa mishiraachchuwaa odiidde, qassi harggiyaa ubbaappenne sakuwaa ubbaappe asaa pathiidde, wogga katamatuwaninne qeeri katamatuwaa ubbaan yuuyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cora asaa be7iide, heemmiyaa asay baynna dorssaadan asay hirggettiyaa dirawunne asaa maaddiyaabay baynna diraw, asaw qaretteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yaatiide barena kaalliyaawantta, “Qoychchaw gakka kathay dara; shin cakkiyaa asay guutha. ");
INSERT INTO dwrNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Simmi kathaa Goday kathaa cakkanaw oosanchchatuwaa yeddana mala, A woossite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuusi bare tammanne laa77u kaalliyawantta xeesiide, unttunttu iita ayyaanaa kessana mala, qassi harggiyaa ubbaanne sakuwaa ubbaa pathana mala, unttunttoo maataa immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesuusi kiitteedda tammanne laa77atuwaa sunthay, koyrowe Phexiroosa geetettiyaa Simoonanne A ishaa Inddiraasa, Zabiddiyoosa naanaa, Yayiqoobanne Yohaannisa, ");
INSERT INTO dwrNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piliphphoosa, Barttalamoosa, Toomaasa, qaraxaa akkiya Maatoossa, Ilppiyoosa na7aa Yayiqoobanne Taadoosa; ");
INSERT INTO dwrNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","bare gadew qarettiyaa Simoonanne Yesuusa aathi immeedda Asqqorootu Yihudaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuusi ha tammanne laa77atuwaa hawaadan yaagiide kiitteedda; “Ayihuda gidenna asaa gadiyaa booppite; qassi Samaaretuwaa katamaakka geloppite; ");
INSERT INTO dwrNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","hewaa diraa bayeedda dorssaakko, Isra7eeliya asaakko ");
INSERT INTO dwrNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","biide, ‘Saluwaa kawutethay mateedda’ yaagiide odite. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hargganchchatuwaa pathite; anhaa hayquwaappe denthite; oolluu oyqqeeddawantta pathite; iita ayyanatuwakka kessite. Hinttenttu coo akkeeddita; coo immite. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Worqqaa woy biraa woy santtimiyaa hinttenttu kiisiyan oyqqoppite; ");
INSERT INTO dwrNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","woy ogew qarcciitiyaa, woy laa7ethiyaa mayuwaa, woy caammaa woy xam77aa oyqqoppite. Ayissi gooppe, oosanchchaw koshshiyaabay qumaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Hinttenttu geliyaa katamaan woy qeeri katamaa ubbaan hinttena mokkanaw nashettiyaawe oonentto akeekan xomoosite; hinttenttu hewaappe kesana gakkanaw, hewaan uttite. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Qassi golle geliidde sarotite. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","He gollen de7iyaa asay hinttena mokkooppe, hinttenttu saroteedda sarotay unttuntta gakko. Shin unttunttu hinttena mokkennaan ixxooppe, hinttenttu saroteedda sarotay hinttew guyye simmo. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Qassi itti itti golli woy katamay hinttena mokkennaan woy hinttenttu odiyaawaa sisennaan ixxooppe, he golleppe woy he katamaappe kesiidde, hinttenttu gediyaappe baanaa shocite. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Taani hinttew tumuwaa oday; Xoossay pirddiyaa gallassi he katamaa asaappe, Sodoomaa katamaa asawunne Gamooraa katamaa asaw pirddaa kawushissana. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Be7ite! Taani hinttena dorssaa wallatuwaa giddo yeddiyaawaadan yedday. Hewaa diraw, shooshshaadan cincca gidite; qassi haraphphiyaadan, ashikke gidite. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Shin asaappe naagettite. Ayissi gooppe, asay hinttena pirdda gollew aathiide immana; qassi bare Ayihuda woosa golletuwaanikka hinttena lissuwan peeddana. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gadiyaa ayissiyaawanttu sinthaaninne kaatatuwaa sinthaan ta diraw hinttenttu eqqiide, unttunttussinne Ayihuda gidenna asaa sinthaan taw markka gidanita. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Shin unttunttu hinttena pirddaw aathiyaa wode, hinttenttu haasayanabaa he saatiyaan Xoossay hinttew immiya diraw, hinttenttu gaanabawunne woy waagiide haasayanenttonne hirggoppite. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ayissi gooppe, hinttenttun aqiide haasayiyaawe hinttenttu Aawuuwaa Geeshsha Ayyaanaappe attin, haasayiyaawanttu hinttentta gidikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ishay bare ishaa, aawuu bare na7aa bolla denddana; naanay barenttu aattinne aawuwaa bolla denddiide, unttuntta wodhissana. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Qassi asay ubbay hinttentta ta sunthaa diraw ixxana; shin wursethay gakkanaw gencciyaawe attanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Unttunttu hinttena itti katamaappe yederssooppe, hara katamaa biite. Ayissi gooppe, taani hinttew tumuwaa gay; taani, Asaa Na7ay, yaana gakkanaw, hinttenttu hintte oosuwaa Isra7eeliyaa katamaa ubbaan oothiide wurssikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tamaariyaawe barena tamaarissiyaawaappe darenna; qoomaykka bare godaappe darenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tamaariyaawe barena tamaarissiyaawaa keena gidiyaawe, qoomaykka bare godaa keena gidiyaawe aw gidana; unttunttu golle godaa Bi7eel-Zeebula giide xeesooppe, A golle asaa waagi xeesaneeshsha! ");
INSERT INTO dwrNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Simmi asaassi yayyoppite; ayissi gooppe, genthi wotheeddabay qoncciyaa kesennaan attenna; qoseeddabaykka erettennaan attenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Taani hinttenttoo dhumaani odiyaabaa poo7uwan haasayite; hinttew haythaan saasukkiide odeeddawaa, dhoqqa saan awaayyite. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ashuwaa wodhiyaawanttoo yayyoppite; unttunttu, shemppuwaa wodhanaw danddaykkino. Shin shemppuwaanne ashuwaa Gaannamiyan dhayissanaw danddayiyaa Xoossaassi yayyite. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Laa77u suunniyaa kafatuu santtimiyaan zali77ettikkinoo? Hinttenttu Aawuuwaa sheniyaa gidana dhayooppe, he suunniyaa kafatuwaappe ittinnakka sa7aan wodhdhaade bayukku. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Shin haray atto, hinttenttu huuphiyan de7iyaa binnanay ubbaykka payduwaan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Simmi yayyoppite; daro suunniyaa kafatuwaappe hinttenttu aadhdhiita. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Hewaa diraw, asaa sinthaan tabaa markkattiyaa oossi gidooppenne, taanikka saluwan de7iya ta Aabbu sinthan markkattana; ");
INSERT INTO dwrNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","shin asaa sinthaan taana kaddiyaa oonanne taanikka qassi saluwan de7iya ta Aabbu sinthaan A kaddana. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Taani sa7aassi sarotethaa ahanaw yeeddawaa hinttessi malatoppo; taani tooraa ahanaw yeeddawaappe attin, sarotethaa ahanaw yabeykke. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ayissi gooppe, taani na7aa A aabbuppe, naatto izi daayippe, na7aa machchattokka izi bollotattippe shaakkanaw yaaddi; ");
INSERT INTO dwrNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","asaassi morkketuu A golle asatuwaa gidanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Bare aabba woy bare daayo taappe aathiide siiqiyaawe tawaa gidanaw bessenna; bare attuma na7aa woy bare macca naatto taappe aathiide siiqiyaawe tawaa gidanaw bessenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bare masqqaliyaa tookkiide, ta geeduwaa kaallennawe tawaa gidanaw bessenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bare shemppuwaa ashshiyaawe bayizzanawaa; shin ta diraw bare shemppuwaa bayizziyaawe ashshanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hinttentta mokkiyaawe taana mokkee; qassi taana mokkiyaawe taana kiitteeddawaa mokkee. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nabiyaa, nabiyaa sunthaan mokkiyaawe, nabiyaa gatiyaa aananna gishettanawaa; qassi xilluwaa, xilluwaa sunthaan mokkiyaawe, xilluwaa gatiyaa aananna gishettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ooninne ha taana kaalliyaawanttuppe guuxxiyaa ittoo, haray atto buliyaa haathaa xalalaa ushanaw immooppekka, taani hinttenttoo tumuwaa gay; I bare gatiyaa akkana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuusi bare tammanne laa77u kaalliyawantta azaziyaawaa poleedda wode, hewaappe denddiide, katamatuwaan tamaarissanawunne odanaw beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Xammaqiyaa Yohaannisi qasho gollen de7iidde, Yesuusi ootheeddawaa sisiide, barena kaalliyawantta aakko kiittiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Yaanawe neeneeyee? Woy haraa naaganee?” yaagi oochchanaadan udeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesuusi zaariide, unttunttoo hawadaan yaageedda; “Biide hinttenttu be7iyaawaanne sisiyaawaa Yohaannisaw odite; ");
INSERT INTO dwrNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","qooqatuu xeelliino; wobbatuu hamettiino; oolluu oyqqeeddawanttu paxiide geeyyiino; tullatuu sisiino; hayqqeeddawanttu denddiino; hiyyeesatuu wonggalaa mishiraachchuwaa sisiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tabaa sidhenna uray anjjetteeddaawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohaannisa kaalliyaawanttu simmi beedda wode, Yesuusi Yohaannisabaa shiiqeedda asaassi hawaadan yaagi haasayeedda; “Ayaa be7anaw asay de7enna mela biittaa keseedditee? Carkkuu qaathiyaa maqqaa be7anaw keseedditee? ");
INSERT INTO dwrNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yaatina, ayaa be7anaw keseedditee? Lo77iyaa mayuwaa mayyeedda bitaniyaa be7anaw keseedditee? Lo77iyaa mayuwaa mayyeeddawanttu kaatatuwaa gollen de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yaatina, ayaa be7anaw keseedditee? Nabiyaa be7anaw keseedditee? E, Taani hinttew oday; nabiyaappekka aadhdhiyaawaa be7eeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ayissi gooppe, Xoossaa Maxaafan, ‘Xoossay, “Be7a, taani kiittiyaawaa neeppe sinthaw yeddana. I new ogiyaa giigissanawaa” yaageedda geetettiide Yohaannisabay xaafetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Taani hinttenttoo tumuwaa oday; aatti uluwaappe yeletteedda asaa ubbaan Xammaqiyaa Yohaannisappe aadhdhiyaawe ooninne denddibeenna; shin saluwaa kawutethaan ubbaappe laafiyaawe aappe aadhdhana. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Xammaqiyaa Yohaannisa wodiyaappe doommiide, hachche gakkanaw, saluwaa kawutethatta daro naaqettaw; minni baaxetiyaawanttu izo demmiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ayissi gooppe, nabatuu ubbatuunne Muse higgii Yohaannisa wodii gakkanaw, timbbitiyaa haasayeeddino; ");
INSERT INTO dwrNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","simmi hinttenttu unttunttu haasayowaa ammananawaa gidooppe, yaanawaa geetetteedda Eelaas ha Yohaannisa. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sisiyaa haythay de7iyaawe siso! ");
INSERT INTO dwrNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Shin taani ha wodiyaa asaa ayaanna leemisoo? Unttunttu qocaan uttiyaa naanaa malatiino; unttunttu barenttu laggethatuwaa xeesiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nuuni hinttenttoo hixixiyaa punneeddo; shin duribeykkita; yeekuwaa yethaakka kesseeddo; shin yeekkibeykkita’ yaagiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ayissi gooppe, Yohaannisi xoomiiddinne woyiniyaa eessaa ushennaan yiina unttunttu, ‘A bolla iita ayyanay de7ee’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Taani, Asaa Na7ay, maaddenne ushaadde yiina, unttunttu taana, ‘Ha nafisaamaanne woyiniyaa eessaa ushiyaawaa be7ite; qaraxaa qanxxiyaawanttunnanne nagaranchchatuwanna siiqettee’ yaagiino; shin Xoossaa aadhdheedda eratethay bare oosuwaan tuma gidiide beettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hewaappe guyyiyan, Yesuusi bare malaataappe dariya baggaa ootheedda katamatuwaan de7iya asay barenttu nagaraappe simmibeenna diraw, unttuntta hawadaan yaagiide, toshiyaa doommeedda; ");
INSERT INTO dwrNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Koraaziine katamaw, new aayyero; Beetesayda katamaw, newukka aayyero; ayissi gooppe, hinttenttu bolla Xoossay ootheedda malaatay Xiiroosa katamaaninne Sidoonaa katamaan oosettowaa gidintto, unttunttu maaqiyaa mayyiide, bidinthaa okettiide, beni barenttu nagaraappe simmanawanttashshin. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Taani hinttew oday; pirddaa gallassi Xoossay hintteppe Xiiroosa katamawunne Sidoonaa katamaw pirddaa kawushissana. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Qassi Qifirinaahooma katamaw, neeni saluwaa pude dhoqqu gaanaw koyyaaddii? Neeni Si7ooliyaa duge yegettana; ayissi gooppe, ne bolla Xoossay ootheedda malaatay Sodoomaa katamaan oosettowaa gidintto, Sodoomaa katamay hachche gakkanaassikka de7anawaashshin. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Taani hinttew oday; pirddaa gallassi Xoossay neeppe Sodoomaw pirddaa kawushissana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yesuusi he wode zaariide, hawadaan yaageedda; “Ta Aabboo, saluwaa sa7aa Godaw, neeni hawaa aadhdheedda eranchchatuwaappenne akeekanchchatuwaappe genthaade, erenna naanatuwassi qonccisseedda diraw, neena galatay; ");
INSERT INTO dwrNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E ta Aabboo, ayissi gooppe, hawe ne sheniyaadan oosetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ta Aabbu taw ubbabaa immeedda; Aawuwaappe haray Na7aa erenna; Na7aappenne Na7ay Aawuuwaa qonccissanaw koyyiyaa asaappe attin, haray Aawuwaa erenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Daaburanchchatoo, deexuwaa tookkowanttoo ubbatoo, taakko haa yiite; taani hinttentta shemppissana. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Taani garanne ta wozanaan ashikke gido diraw, ta morgge mithaan waaxettite; taappe tamaarite; hinttenttu sheemppuwassikka hintte shemppuwaa demmana. ");
INSERT INTO dwrNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ayissi gooppe, ta morgge mithay giigaa; qassi taani hinttentta toosseeddawekka kawushsha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yesuusi he wode Sambbata gallassi, tisha banggaa giddonna aadhdhishshin A kaalliyaawanttu koshattiide, tisha banggaa duuthiide, muussaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Shin Parisaawatuu hewaa be7iide Yesuusa, “Be7a, neena kaalliyawanttu Sambbata gallassi oothanaw woga gidennabaa oothiino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Shin Yesuusi unttunttussi hawadaan yaageedda; “Daawitenne aananna de7iyaawanttu koshatteedda wode, Daawite ootheeddawaa nabbabibeykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Daawite Xoossaa golle geliide, qeesatuwaa xalalay maanaappe attin, iinne aananna de7iyaawanttu maanaw woga gidenna Xoossaassi yarshsheedda qumaa meedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Woy Sambbataa ubbaan Geeshsha Golliyan de7iya qeesatuu Sambbataa wogaa menthiyaawaa, qassi unttunttussi hewe bayizzo gidennawaa Muse higgiyan nabbabibeykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Shin taani hinttew oday; Geeshsha Golliyaappe aadhdhiyaawe hawaan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Xoossaa Maxaafay, ‘Taani maarotethaa koyyayppe attin, yarshshuwaa koyyikke’ yaagiyaawe waagiyaawentto hinttenttu eriitentto, bayizzuu baynna asaa bolla pirddikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ayissi gooppe, taani, Asaa Na7ay, Sambbataa Godaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuusi hewaappe denddiide, Ayihuda woosa golle beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hewaan kushii gunddeedda itti bitani de7ee; Yesuusa mootanaw gaasuwaa koyyiyaa asatuu, “Sambbataan, hargganchchaa pathiyaawe wogee?” yaagiide A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesuusi unttuntta, “Hinttenttu giddon itti dorssay de7iya uray, he dorssay Sambbata gallassi ollaan kunddooppe, oyqqiide kessennawe oone? ");
INSERT INTO dwrNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yaatina, asay dorssaappe wooti loythiide darennee! Hewaa diraw, Sambbata gallassi lo77obaa oothiyaawe woga” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hewaappe guyyiyan bitaniyaa, “Ne kushiyaa piddi ootha” yaagina bitani piddi oothowaappe guyyiyan, A kushii yokko kushiyaawadankka paxi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Shin Parisaawatuu kare kesiide, Yesuusa wooti wodhanentto maqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Shin Yesuusi unttunttu zoretaa eriide, hewaappe aggiide biya wode, daro asay A kaalleedda; harggeedda ubbaa patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","17","Xoossay nabiyaa Isiyaasa bagganna odeeddawe polettana mala, Yesuusi asatuwassi, “Tabaa hara asaassi odoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Xoossay Isiyaasa bagganna hawadaan yaageedda; “Taani dooreedda ta ayillii, taani siiqiyaa, taana nashechchiyaawe haweku. Taani ta Ayyaanaa A bolla wothana. I suure pirddaa asaw ubbaw odanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I palumettenna; woy waasseenna. Bare qaalaakka ogiyaan sissenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Suure pirdday xooni kesana gakkanaw, tinccetteedda maqqaa menthenna qassi cuwattiyaa muqaaddaa qunccuutiyaakka I toyissenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ayihuda gidenna asay ubbay aabolla barenttu hidootaa wothana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hewaappe guyyiyan, amareedda asatuu iita ayyanay oyqqina duudeedda itti qooqa bitaniyaa Yesuusakko aheeddino; Yesuusi he duude bitaniyaa patheedda; bitaniikka haasayaanne xeelaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Asay ubbay maalalettiide, “Laa hawe Daawite na7aa gidanddeeshsha?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Shin Parisaawatuu hewaa sisiide, “Ha bitani iita ayyaanatuwaa kaappuu ‘Bi7eel-Zeebuli’ barew wolqqaa immina, xalahatuwaa kessee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Shin Yesuusi unttunttu qofaa eriide, unttuntta hawadaan yaageedda; “Bare giddon shaakettiyaa kawutethay ubbay dhayana; qassi bare giddon shaakettiyaa katamay woy gollen de7iyaa asaykka minnenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Qassi Seexaanay Seexaanaa kessiyaawaa gidooppe, bare giddon shaakettee; yaatina, A kawutethay waaniide minni eqqanawee? ");
INSERT INTO dwrNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Taw Bi7eel-Zeebuli wolqqaa immina, taani xalahatuwaa kessiyaawaa gidooppe, hinttenttu asaw wolqqaa ooni immina xalahatuwaa kessanee? Hewaa diraw, unttunttu hintte bolla pirddana. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Shin Xoossaa Geeshsha Ayyaanay taw wolqqaa immina, taani xalahatuwaa kessiyaawaa gidooppe, simmi Xoossaa kawutethay hintte bolla yidiggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Woy asay kasetiide, wolqqaama asaa qachchennaan de7iidde, A golle geliide, A miishshaa bonqqanaw waaniide danddayii? Qachcheeddawaappe guyyiyan, A miishshaa bonqqanaw danddayee. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ta bagga gidenna uray tawaa ixxee; qassi taananna ittippe shiishshennawe laalee. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hewaa diraw, taani hinttew oday; Xoossay asaw ay nagaraa gidinakka, qassi ay bore gidinakka atto gaana; shin Geeshsha Ayyaanaa boriyaawaa atto geenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ta bolla, Asaa Na7aa bolla, iitabaa haasayiyaa O nagaraanne Xoossay atto gaana; shin Geeshsha Ayyaanaa bolla iitabaa haasayiyaa O nagaraanne sa7aan gidina, saluwankka Xoossay atto geenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Lo77o ayfiyaa demmanaw lo77o mithaa dichchanaw bessee; iita mithaa hinttenttu dichchooppe, iita ayfiyaa demmanita; ayissi gooppe, mithay erettiyaawe bare ayfiyaa ayfiyawaana. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Shooshshatoo, hinttenttu iita gidiidde, wooti lo77obaa haasayanaw danddayiitee? Ayissi gooppe, doonay wozanaa giddon kumeeddawaa haasayee. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lo77o asay bare lo77o minjjuwaappe lo77obaa kessee; qassi iita asay bare iita minjjuwaappe iitabaa kessee. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Taani hinttenttoo oday; asay bare haasayeedda maaddenna haasayaa ubbaw pirddaa gallassi zaaruwaa immanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ayissi gooppe, ne haasayay neena xillissana; woy ne haasayay ne bolla pirddissana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hewaappe guyyiyan, higgiya tamaarissiyaa itti itti asaynne Parisaawatuu zaariide Yesuusa, “Tamaarissiyaawoo, neeni malaataa oothishshin, nuuni be7anaw koyyeetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Shin I zaariide, unttunttoo hawadaan yaageedda; “Ha wodiyaa asay iitanne Xoossaa ammanenna diraw, malaataa koyyee; nabiyaa Yoonaasa malaataappe attin, hara malaatay imettenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yoonaasi wogga moliyaa uluwaan heezzu gallassaanne heezzu qammaa de7eeddawaadan, Asaa Na7aykka, biittaa giddon heezzu gallassaanne heezzu qammaa de7anawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nennewe asay Yoonaasi odeeddawaan barenttu nagaraappe simmeedda diraw, pirddaa gallassi denddiide, hinttentta mootanawantta; beyte, Yoonaasappe aadhdhiyaawe hawaan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Duge bagga gadiya kaatatta Solomonew de7iyaa aadho eratethaa sisanaw sa7aa gaxaappe yeedda diraw, pirddaa gallassi denddaade, hinttentta mootanawunnu; beyte, Solomoneppekka aadhdhiyaawe hawaan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Iita ayyaanay asaappe keseedda wode, barew shemppiyaasaa koyyiide, haathay baynna melasaanna yuuyyee; shin demmenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","He wode, ‘Taani aggaade yeedda ta golle simmana’ yaagee; simmiide yiyaa wode, gollii mela de7iyaawaanne pitetti geeyyiide, giigi utteeddawaa demmee. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hewaappe guyyiyan, biide bareppe iitiya laappu hara ayyaanatuwa akkiide yee; he ayyaanatuu geliide, hewaan de7iino. He bitaniyaa de7uu kasewaappe darii iitee. Ha wodiyaa iita asawukka qassi hewaadan hanana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuusi daro asaw haasayishshin, A daayanne A ishatuu aananna haasayanaw koyyiide, karen eqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hewaan de7iyaa asaappe ittuu A, “Ne daayanne ne ishatuu neenanna haasayanaw koyyiide, karen eqqeeddino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Shin Yesuusi zaariide, “Ta daaya oone? Ta ishatuu oone?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bare kushiyan barena kaalliyaawanttukko xorssiide, “Beyte, ta daayanne ta ishatuu hawanttushi. ");
INSERT INTO dwrNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ayissi gooppe, saluwan de7iyaa ta Aabbu sheniyaa oothiyaa ubbay, ta ishaa, ta michchattonne ta daayo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yesuusi he gallassi soyippe kesiide, abbaa gaxaan utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Daro cora asay bare yuushshuwaan yuuyyi aadhdhiide shiiqina, wonggiriyaa giddo geliide utteedda; asay ubbay abbaa gaxaan eqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Asaassi leemisuwan darobaa hawaadan yaagiide odeedda; “Itti bitani zerethaa zeranaw keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","I zerishshin, itti itti zerethay ogiyaa doonan wodhdheedda; yaatina kafuu yiide meedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Qassi itti itti zerethay ancco gideedda biittaa bolla wodhdheedda; daro biittay baynna diraw, he zerethay ellekka doleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Shin away keseedda wode carshshay shulleedda; adussa xaphuwaa yeddibeenna diraw melii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Itti itti zerethay agunthaa giddon wodhdheedda; hewaan doleeddawaa agunthay dicciide cuulleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Itti itti zerethay tu7e biittaan wodhdhiide doleedda; ittuu xeetu ayfiyaa, ittuu usuppun tammuwaa, ittuu hattamuwaa ayfeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sisiyaa haythay de7iyaa uray siso!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesuusa kaalliyaawanttu aakko shiiqiide, “Neeni ayissi asaassi leemisuwan oday?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesuusi zaariide, unttunttussi hawadaan yaageedda; “Hinttenttussi saluwaa kawutethaa xuuraa erussay imetteedda; shin unttunttussi imettibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ayissi gooppe, de7iyaawoo gujettana; aw daranawaa; shin baynnawaappe haray atto, he de7iyaawekka akettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Taani unttunttu xeelliidde xeellennawaadan, sisiidde sisennawaadan haniyaa diraw, woy qassi akeekenna diraw unttunttoo leemisuwan oday. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Isiyaasi unttunttubaa hawaadan odowe polettanawaa; ‘Hinttenttu sissaa sisana; shin hinttenttoo gelenna; hinttenttu xeelaa xeellana; shin be7ikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ayissi gooppe, ha asaa wozanay guzumeedda; barenttu haythaa tullisseeddino; barenttu ayifiyaakka ciilummeeddino. Hawe baawentto, unttunttu barenttu ayfiyan be7ana; barenttu haythaan sisana; barenttu wozanankka akeekaanna; unttunttu taakko, Xoossaakko simmana; taanikka unttuntta pathana’ yaagee. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Shin hinttenttu ayfii xeelliyaa dirawunne hinttenttu haythaykka sisiyaa diraw, hinttenttu anjjetteeddawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Taani hinttenttoo tumuwaa oday; daro nabatuunne xillatuu hinttenttu be7iyaawaa be7anaw amotteeddino; shin be7ibeykkino. Hinttenttu sisiyaawaa sisanaw amotteeddino; shin sisibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Simmi kathaa zeriyaawaa leemisuwaa bilethay giyawaa sisite. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kawutethaa qaalaa sisiide, akeekenna ooninne ogiyaa doonan wodhdheedda zerethaa mala; xalahiyaa kaappuu yiide, unttunttu wozanaan zeretteeddawaa maxi diggee. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ancco biittaan wodhdheedda zerethay qaalaa sisiide, ellekka nashechchaan akkiyawantta malatee. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Shin he asatuu ha77issaappe attin, unttunttun xaphuu baawa; qaalaa gaasuwan metuu woy yedesay yiyaa wode, ellekka dhubetti aggiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Qassi agunthaa giddon wodhdheeddawe qaalaa sisiyaawaa bessee; shin ha sa7aa de7uwaassi hirggussaynne duretethaa siiqussay qaalaa cuullee; ha gasuwaan he zerethaykka ayfennaan atti aggee. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tu7e biittaan zeretteeddawe, qaalaa sisiide, akeekiyaa asaa bessee; ikka ayfee; ittuu xeetuwaa, ittuu usuppun tammuwaa, ittuu hattamuwaa ayfee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuusi unttunttoo hara leemisuwaa hawaadan yaagiide odeedda; “Saluwaa kawutethay bare goshshan lo77o zerethaa zereedda bitaniyaa malatee. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Shin qamma asay gemi77ishidiggina, A morkkii yiide, zarggaa zereeddawaa bolla zaaringgiyaa zeriide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Shin zarggay doli ayfeedda wode, zaaringgi he wode beetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“A qoomatuu aakko yiide, ‘Godaw, neeni ne goshshan lo77o zerethaa zerabeykkii? Yaatina, zaaringgi haqappe yeeddee?’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Hewaappe guyyiyan goday, ‘Hewaa morkkii ootheedda’ yaageedda. “Qoomatuu, ‘Nuuni biide shoddanaadan dosay?’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Shin I, ‘Aggite, zaaringgiyaa hinttenttu shoddiidde, zarggaanna shoddanita. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bochchoppite; qoyciyaa wodii gakkanaw, ittippe diccino. Qoyciyaa wodii gakkoode, taani qoyciyaawantta, kasetiide zaaringgiyaa maxite; tamaan guuddanaw pochchiyan pochchiyan qachchite; shin zarggaa shiishshiide diyyiyan qolite’ gaana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuusi unttunttoo hara leemisuwaa yaagiide odeedda; “Saluwaa kawutethay sannaaficiyaa geetettiyaa guutha mithatti ayfiya malatee; he mithatti ayfiya asay akkiide, bare goshshan zereedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","He zerethatta hara zerethaa ubbaappe guuxxaw; shin dicceedda wode, hara atakilttiyaa ubbaappe daraw; kafuu yiide, izi qankkaan keexxiyaawaa keena wogga mithaa gidaaddu” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Qassikka Yesuusi hara leemisuwaa unttunttoo yaagiide odeedda; “Saluwaa kawutethay itti mishiratta heezzu keriyaa dhiilliyaa akkaade, munaqqeedda munaqay ubbay denddana gakkanaw, aani tigeedda irshshuwaa malatee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","35","Yesuusi asaw he ubbaa leemisuwan odeedda; leemisuu baynnaan I ittibaakka odenna; nabii, “Taani unttunttoo haasayiyaa wode, leemisuwan haasayay. Alamii medhettoodeppe doommiide geemmeedda yewatuwaa oday” yaageeddawe polettana mala, hewaa I odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hewaappe guyyiyan, Yesuusi asaa aggiide, soy geleedda; A kaalliyaawanttu aakko biide, “Goshshan de7iyaa zaaringgiyaa leemisuwaa bilethaa nuussi oda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesuusi zaariide, hawaadan yaageedda; “Lo77o zerethaa zeriyaawe Asaa Na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","goshshay ha alamiyaa; lo77o zerethay Xoossaa kawutethaa asaa; zaaringgi xalahiyaa kaappuwaa naanaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Zaaringgiyaa zereeddawe morkkiyaa xalahiyaa; qoychchaa wodii, wodiyaa wurssethaa; qassi qoyciyaawanttu kiitanchchatuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Hewaa diraw, zaaringgiyaa maxiide, tamaan guuddiyaawaadan, wodiyaa wurssethaan hewaa mala gidanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Asaa Na7ay, kiitanchchatuwaa kiittanawaa; unttunttu A kawutethaa giddon nagaraw gaaso gidiyaa ubbatuwaanne iitabaa oothiyaawantta maxiide kessanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yaatiide to7enna tamaan olanawantta; hewaan unttunttu yeekkanawanttanne achchaa dhaqanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","He wode xillatuu barenttu aabbu kawutethaan awaadan poo7ana. Sisiyaa haythay de7iya uray siso! ");
INSERT INTO dwrNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Saluwaa kawutethay goshshaan moogetteedda miishshaa bessee; itti bitani he miishshaa demmiide, zaariide moogi aggeedda; daro nashettiidde biide, barew de7iyaawaa ubbaa zali77iide, he goshshaa shammeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Qassi saluwaa kawutethay inqquwaa geetettiyaa daro al77o shuchchaa shammanaw koyyiyaa zali77anchchaa malatee. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","He zali77anchchay daro al77o inqquwaa demmiide, biide barew de7iyaawaa ubbaa zali77iide, A shammeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Qassi saluwaa kawutethay ubba qommo moliyaa oyqqiyaa, abbaan yegetteedda dabbaa malatee. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Molii dabbaa kumeedda wode, moliyaa oyqqiyaa asatuu abbaappe gaxaa kesiide utteeddino; yaatiide lo77o moliyaa qoriide, yeggiyaa miishshaan yeggeeddino; shin iita moliyaa wora oleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wodiyaa wurssethaan hewaadan hanana; kiitanchchatuu yiide, nagaranchchatuwaa xillatuwaa gidooppe qoriide, ");
INSERT INTO dwrNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","to7enna tamaan olanawantta; hewaan unttunttu yeekkanawanttanne achchaa dhaqanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Hawe ubbay hinttenttoo geleeddee?” yaagiide unttuntta oochcheedda. Unttunttu, “E,” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","I, “Hewaa diraw, saluwaa kawutethaa xuuraa loythi eriyaa, higgiyaa tamaarissiyaa ubbay, bare miishshaa shiishshi wotheedda golliyaappe ooratha miishshaanne eca miishshaa shaakki kessiyaa izawa malatee” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuusi ha leemisatuwaa odi wurssowaappe guyyiyan, hewaappe denddiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","bare katamaa Naazireete beedda. Ayihuda woosa gollen tamaarissiyaawaa siseedda asay maalalettiide, hawaadan yaageedda; “Hawe ha aadho eratethaanne Xoossay oothiyaa malaataa oothanaw wolqqaa haqappe akkeeddee? ");
INSERT INTO dwrNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hawe anaaxiyaa na7aa gidennee? A daaya Mayraamo gidekkee? A ishatuu Yayiqoobaa, Yooseefa, Simoonanne Yihudaa gidikkinoo? ");
INSERT INTO dwrNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A michchatuu ubbay nuunanna de7ikkinoo? Yaatina, I ha eraa ubbaa haqappe demmeeddee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Unttunttu I giyaabaa akkennaan ixxeeddino. Shin Yesuusi he asaassi, “Nabii bare gadiyaninne bare soy asaan bonchchettenna; shin harasaa ubbaan bonchchettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Unttunttu ammanibeenna diraw, Yesuusi daro malaataa he saan oothibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","He wode Galiilaa gadiyaa ayissiyaa Heroodise Yesuusabaa siseedda; ");
INSERT INTO dwrNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yaatiide bare qoomatuwaassi, “Hawe hayquwaappe denddeedda Xammaqiyaa Yohaannisa; Xoossay oothiyaa wolqqaama malaataa I oothiyaawe hewaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ayissi gooppe, Heroodisi bare ishaa Piliphphoosa machchatti Heeroodiyaadi gaasotaan Yohaannisa oythi qashissiide, qasho gollen yeggi wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ayissi gooppe, Yohaannisi Heroodisa, “Neeni Heeroodiyaado, ne ishaa machchatto akkanaw higgii diggee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroodisi Yohaannisa wodhanaw koyyeedda; shin Yihudaa asay nabiyaadan Yohaannisa xeelleedda diraw, asaw yayyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Shin Heroodisi yeletteedda gallassaa baalay gakkina, Heeroodiyaadi naatta asaa sinthaan duraade Heroodisa nashechchaw. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Heroodisi naatto, “Neena lo77eeddawaa ayaanne gidooppe, taana oochcha; taani new immana” yaagiide iziw caaqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naatta bare daay zoriyaa akkaade Heroodisa, “Xammaqiyaa Yohaannisa huuphiyaa ha wociitiyaan wothaade taw imma” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kaatii aw qaretteedda; shin bare caaquwaa dirawunne barenanna maaddaan utteedda imathaa diraw, iziw Yohaannisa huuphii imettana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kaatii kiittiide, Yohaannisa qoodhiyaa qasho gollen muucisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Huuphiyaa wociitiyaan wothi ahiide, naattiw immeeddino; naatta he huuphiyaa bare aattikko afaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohaannisa kaalliyaawanttu yiide, A anhaa afiide moogeeddino; hewaappe simmiide ha yewuwaa Yesuusaw biide odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuusi hewaa sisiide, wonggiriyaan geliide, hewaappe barekka asay baynnasaa beedda; asay hewaa sisiide, katamaappe denddiide, gediyan A kaalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesuusi wonggiriyaappe keseedda wode, daro asaa be7iide, he asaw qaretteedda; yaatiide unttunttunna de7iyaa hargganchchatuwaa patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sa7ay omarssiyaa wode, Yesuusa kaalliyawanttu aakko yiide, “Hawe sa7ay asay baynnasaa; ha77i sa7ay qammidiggeedda; asay ubbay qeeri katamatuwaa biide, barenttoo qumaa shammana mala, asaa moyizza” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Shin Yesuusi unttuntta, “Asay baanaw koshshenna; asaw meetettiyaabaa hinttenttu immite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Unttunttu zaariide A, “Nuussi hawaan ichcheshu ukithaappenne laa77u moliyaappe attin, haray baawa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesuusi unttuntta, “Hewantta, haa taakko ahite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Asay maataani uttana mala, Yesuusi azazeedda; ichcheshu ukithaanne laa77u moliyaa oyqqiide, saluwaa pude xeelliide, Xoossaa galateedda; he ukithaa menthiide, barena kaalliyaawanttussi immina, unttunttu cora asaw gisheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Asay ubbay miide kalleedda; atteedda suuppa dokkaa tammanne laa77u zambbeeliyaa kumeeddawaa dentheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Meedda asay macca asaanne naanaa paydennaan, ichcheshu sha77aa gidiyaawaa keena. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesuusi cora asaa moyizziidde, barena kaalliyawantta wonggiriyaan geliide, bareppe sinthatiide, abbaappe hefintha pinnana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Asaa moyizziide, Xoossaa woossanaw deriyaa huuphiyaa barekka keseedda; sa7ay qammi digginakka hewaan barekka de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Shin wonggirii he wode, abbaa bollan de7ishshin, sintha bagganna carkkuu carkkiyaa diraw, beetay wonggiriyaa yaanne haanne sugee. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bayra kuttuu waassi simmina, Yesuusi abbaa bolla hamettiidde, unttunttukko yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","A kaalliyaawanttu abbaa bolla I hamettishshin be7i dagammiide, “Hawe moytilliyaa gidennee!” gi yayyiide waasseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Shin Yesuusi ellekka unttuntta, “Aynne baawa; taanattennee; yayyoppite!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Phexiroosi zaariide A, “Ta Godaw, hawe neena gidooppe, taani haathaa bollanna neekko baana mala, taana azazaarikkii” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesuusi Phexiroosa, “Haaya!” yaageedda. Phexiroosi wonggiriyaappe wodhdhiide, haathaa bollanna hamettiidde, Yesuusakko buussaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Shin carkkuwaa wolqqaa be7iide, yayyeedda; haathay barena mituwaa doommeedda wode, bare kooshshaa dhoqqu oothiide, “Ta Godaw taana ashshaarikkii!” yaagi waasseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","He man77iyankka Yesuusi bare kushiyaa yeddi Phexiroosa oyqqiide, “Laa ha ammanuu laafeeddawoo! Ayissi sidhaaddii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Unttunttu laa77uu wonggiriyaan geleedda wode, carkkuu woppu geedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wonggiriyaa giddon de7iyaa A kaalliyaawanttu Yesuusa, “Neeni Xoossaa Na7aa gideeddawe tuma” yaagiide aw goyinneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Unttunttu abbaa pinniide, Gensaareexa geetettiyaa gadiyaa gakkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","He gadiyaa asay Yesuusa gidiyaawaa ereeddino; hewaa heeraa gadiyaa ubbaa kiittiide, harggiyaa asaa ubbaa aakko aheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Harggiyaa asay A mayuwaa macaraa xalalaa bochchana mala, A woosseeddino; A mayuwaa macaraa bochcheedda ubbaykka paxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hewaappe guyyiyan, higgiya tamaarissiyaa itti itti asaynne Parisaawatuu Yeerusalaameppe Yesuusakko yiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Neena kaalliyawanttu ayissi nu aawotuwa wogaa bayzziinoo? Ayissi gooppe, unttunttu qumaa maanaappe kasetiide, barenttu kushiyaa meecettikkino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuusi zaariide, unttuntta hawadaan yaageedda; “Hinttenttu hintte wogaa diraw, Xoossaa azazuwaa poliyaawaa ayissi ixxiitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ayissi gooppe Xoossay, ‘Ne aabbanne ne daayo bonchcha’ qassi, Bare aabba woy bare daayo boriyaawe hayqqo yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Shin hinttenttu, ‘Itti asay bare aabba woy bare daayo maaddiyaabay barew de7iina, “Hewe Xoossaawaa” gooppe, bare aabba woy bare daayo bonchchanaw bessenna’ yaagiita; yaatiide hinttenttu hinttenttu wogaa polanaw Xoossaa qaalaw azazettikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ha lo77a malatiyaa iita asatoo, Isiyaasi balennaan hinttenttubaw timbbitiyaa odiidde, ");
INSERT INTO dwrNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Xoossay hawadaan yaageedda; “Hawe asay taana bare bolla doonan bonchchee; shin unttunttu wozanay taappe haakuwan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Asay taw mela goyinnee; ayissi gooppe, asay ootheedda azazuwaa Xoossaa higgiya malatissiide tamaarisseeddino” geedda’ ” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuusi daro asaa barekko xeesiide, “Sisitenne akeekite; ");
INSERT INTO dwrNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","asaa tunissiyaawe doona giddo geliyaawaa gidenna; shin asaa tunissiyaawe doonaappe kesiyaawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hewaappe guyyiyan, A kaalliyawanttu aakko yiide, “Parisaawatuu neeni haasayeeddawaa sisiide, hanqqetteeddawaa akeekay?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Shin Yesuusi zaariide, “Saluwan de7iya ta Aabbu tokkibeenna mithaa ubbay shodettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Unttunttoo hirggoppite; unttunttu qooqaa kaalethiyaa qooqatuwaa; qooqay qooqaa kaalethooppe, laa77uukka ollaan kunddee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Phexiroosi zaariide, “Ha leemisuwaa bilethaa nuussi odaarikkii” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesuusi unttuntta hawaadan yaageedda; “Hinttenttoo qassi ha77i gakkanawukka gelibeennee? ");
INSERT INTO dwrNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Doonaanna geliyaa ubbay uluwaa giddo biide, qassi uluwaappe kare kesiyaawaa erikkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Shin doonaappe kesiyaawe wozanaappe kesee; asaa tunissiyaawe hewaa malaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ayissi gooppe, wozanaa giddoppe iita qofay, wodhiyaawe, woshummiyaawe, qassi woshummanaw kajjeeliyaawe ubbay, wuu77iyaawe, wordduwaan markkattiyaawe, borii kesee. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hewaa malatiyaawe asaa tunissiyaawaappe attin, meeccibeenna kushiyaan miyaawe asaa tunissenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hewaappe guyyiyan, Yesuusi hewaappe aggiide, Xiiroosanne Sidoonaa geetettiyaa katamatuu de7iya gadiya beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanaane geetettiyaa gadiya maccawunna ittinna hewaappe Yesuusakko yaade, bare kooshshaa dhoqqu oothaade, “Ta Godaw, Daawita na7aw, taw qarettaarikkii; ta naatto iita ayyanay lo77enna oythaa oyqqeedda” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Shin Yesuusi iziw ay qaalaanne qaattibeenna; A kaalliyawanttu aakko yiide, “Ha mishiratta nu geeduwaa kaalla kaallaade, bare kooshshaa dhoqqu oothaade odaw; hewaa diraw, neeni izo yeddaarkkii” yaagiide woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesuusi zaariide, “Taani bayeedda dorssaw, Isra7eeliya asa xalalaw kiitettaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Shin iza yaade, “Ta Godaw, taana maaddaarikkii!” yaagaade aw goyinnaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Qassi I zaariide, “Naanaa qumaa akkiide, kana maraw oliyaawe lo77a gidenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mishiratta, “E ta Godaw, hewe tuma; shin haray atto kana maratuu barenttu godatuu miina, samppaappe laaletteedda suuppaa miinottennee” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesuusi zaariide izo, “Ha mishirattee, ne ammanuu wolqqaama; neeni koyyeeddawaadan new hano” yaageedda. Izi naatta ellekka paxa aggaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuusi hewaappe denddiide, Galiilaa Abbaa mataa beedda; qassi itti deriyaa bolla kesiide, hewaan utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Daro asay wobbatuwaa, qooqatuwaa, quunatuwaanne duudetuwaa, qassi hara coratuwaa aakko ahiide, A mataan wotheedda. Yesuusi unttuntta patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hewaa diraw, asay duudatuu haasayishshin, quunatuu suurishshin wobbatuu hamettishshin, qooqatuu xeellishshin be7i maalalettiide, Isra7eeliyaa Xoossaa galateeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuusi barena kaalliyawantta barekko xeesiide, “Ha cora asay taananna heezzu gallassay gakkanaw gami77eedda diraw, taani ha asaw qarettay; unttunttoo ha77i miyaawe baawa. Qassi unttunttu ogiyaan daaburiide kunddenna mala, qumaa mizennaan unttuntta mela yeddanawukka koyyikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A kaalliyawanttu zaariide Yesuusa, “Nuuni ha bazzuwan hawaa keena asaa kalissiyaa qumaa haqappe demmanee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Qassi Yesuusi unttuntta, “Hinttenttoo aappun ukithay de7ii?” yaagiide oochcheedda. Unttunttu, “Laappu ukithaynne moletuwaappe amareeddawanttu de7iino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesuusi asaa, “Sa7aan uttite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","He laappu ukithaanne moliyaa oyqqiide, Xoossaa galateedda; menthereethiide barena kaalliyaawanttussi immeedda; qassi unttunttu cora asaassi immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Asay ubbay miide kalleedda; miina atteedda laappu zambbeeliyaa kumeedda suuppaa A kaalliyawanttu dentheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Meedda asay macca asaanne naanaa paydennaan, oyddu sha77a attuma asaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuusi asaa yeddowaappe guyyiyan, wonggiriyaan geliide, Megedoone geetettiyaa gadiya beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Itti itti Parisaawatuunne Saduqaawanatuu Yesuusakko yiide, A paaccanaw koyyeeddino; yaatiide barentta saluwaappe malaata bessana mala woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Shin Yesuusi zaariide, unttuntta hawadaan yaageedda; “Sa7ay qammiyaa wode hinttenttu, ‘Saluu zo77eedda diraw, sa7ay shammanawaa’ yaagiita; ");
INSERT INTO dwrNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","wonttumaathaan qassi, ‘Saluu zo77iide gubbaneedda diraw, hachche iray bukkanawaa’ yaagiita; saluwaa xeelliide, sa7ay hananawaa eranaw danddayiita; shin ta yuussaa wodiyaa malaataa shaakki eranaw danddaykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ha wodiyaa asay iitaynne woshummiyaawe, Xoossaw ammanettennawe, malaataa koyyee; nabiyaa Yoonaasa malaataappe attin, hara malaatay aw imettenna” yaageedda. Hewaappe simmiide, unttuntta aggiide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","A kaalliyawanttu abbaa pinneedda wode, qumaa afanawaa dogeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesuusi unttuntta, “Parisaawatuwaa irshshuwaappenne Saduqaawanatuwaa irshshuwaappe hinttentta eriide naagettite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Unttunttu barenttu giddon, “I hawaa yaagiyaawe nuuni qumaa ahibeenna diraassa” yaagiide haasayaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Shin unttunttu giyaawaa Yesuusi eriide, “Ha ammanuu pacceeddawanttoo, qumay baynna diraw, ayissi hinttenttu giddon haasayiitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ha77ikka hinttenttoo gelibeennee? Taani ichcheshu ukithaa ichcheshu sha77a asaa mizaade kalisseeddawaa, qassi hinttenttu aappun zambbeeliyaa kunthiide atteedda suuppaa dentheedditentto wozanaa aathikkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Woy taani laappu ukithaa oyddu sha77a asaa miza kalisseeddawaa, qassi hinttenttu aappun zambbeeliyaa kunthiide atteedda suuppaa dentheedditentto wozanaa aathikkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Taani hinttentta Parisaawatuwaa irshshuwaappenne Saduqaawanatuwaa irshshuwaappe naagettite giyawaappe attin, ukithaabaa hinttenttoo haasayabeennaawaa hinttenttu waaniide akeekikkitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","A kaalliyawanttu Yesuusi barenttoo odeeddawaa, Parisaawatuwaa timirttiyaappenne Saduqaawanatuwaa timirttiyaappe unttunttu naagettana mala odettowaappe attin, munaqaan tigiyaa irshshuwaappe naagettana mala gidennaawaa he wode akeekeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuusi Qiisaariyaa Piliiphphoosa geetettiyaa gadiya gakkeedda wode, barena kaalliyaawantta, “Asay taana, Asa Na7aa oona gii?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A kaalliyawanttu zaariide, “Neena itti itti asay, Xammaqiyaa Yohaannisa yaagee; haranttu qassi Eelaasa yaagiino; qassi haranttu Ermiyaasa woy nabatuwaappe ittuwaa yaagiino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesuusi unttuntta, “Yaatina hinttenttu taana oona giitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simooni Phexiroosi zaariide, “Neeni de7uwa Xoossaa Na7aa Kiristtoosa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesuusi zaariide, hawadaan yaageedda; “Yoona na7aa Simoonaa, hawaa new saluwan de7iya ta Aabbu erisseeddawaappe attin, asay ooninne neena erissibeenna diraw, neeni anjjetteeddaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Phexiroosaa, taani new oday; neeni shuchchaa; taani ha zaallaa bolla ta woosa golliya keexxana; ta woosa golliya haray atto, Si7ooliyaa wolqqaykka xoonanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Taani new saluwaa kawutethaa qulppiyaa immana; neeni sa7an hano goowe ubbay saluwan Xoossaa sinthan hanana; shin neeni sa7aan hanoppo geeddawe saluwankka hanenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hewaappe guyyiyan, I Kiristtoosa gideeddawaa A kaalliyawanttu oossinne odenna mala, unttuntta azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","He wodiyaappe doommiide Yesuusi, “Taani Yeerusalaame biina, taana cimatuu, qeesatuwaa kaappatuunne higgiya tamaarissiyaawanttu darii waayissanaw bessee; unttunttu taana wodhanawunne taani heezzentho gallassi hayquwaappe denddanaw bessee” yaagiide, barena kaalliyaawanttussi geeshshiide oduwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Phexiroosi A itti bagga zaariide, “Ta Godaw, Xoossay neena hewaappe ashsho; hawe ne bolla ubbakka yeenna” yaagiide A zoranaw doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Shin Yesuusi guyye simmiide Phexiroosa, “Ha Seexaanaw, neeni ta matappe kichcha; neeni asay dosiyaawaa qoppiyaawaappe attin, Xoossay dosiyaawaa qoppenna diraw, taw dhubo gidaadda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hewaappe guyyiyan, Yesuusi barena kaalliyawantta hawadaan yaageedda; “Taana kaallanaw koyyiyaa uray de7ooppe, barena kaado; yaatiide bare masqqaliyaa tookkiide, taana kaallo. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ayissi gooppe, bare shemppuwaa ashshanaw koyyiyaa uray bayizzanawaa; shin bare shemppuwaa ta diraw bayizziya uray ashshanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Itti uray sa7an de7iya ubbabaa barew shiishshiide, bare shemppuwaa bayizzooppe, A ayaa maaddanee? Woy itti uray bare shemppuwaa wozanaw ayaa immana danddayii? ");
INSERT INTO dwrNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ayissi gooppe, taani, Asa Na7ay, ta Aabbu bonchchuwan ta kiitanchchatuwaanna yaana hanay; asaa ubbaw he wode A oosuwaa gatiyaa immana. ");
INSERT INTO dwrNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Taani hinttenttoo tumuwaa gay; amareedda asatu, taani, Asa Na7ay, kaatiyaa gidaade yiyaawaa be7ana gakkanaw, hayqqennawanttu hawaan de7iino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesuusi usuppun gallassaappe guyyiyan, barenanna Phexiroosa, Yayiqoobanne, Yayiqooba ishaa Yohaannisa akkiide, unttunttu xalalaa wogga deriyaa huuphiyaa kesseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Qassi unttunttu xeellishshin, unttunttu sinthaan laametteedda; A deemuu awayfiyaadaan poo7eedda; A mayuukka poo7uwaadan phooleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Musenne Eelaas Yesuusanna haasayishshin, ha heezzu A kaalliyawanttu be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Phexiroosi Yesuusa, “Ta Godaw, nuuni hawaan de7iyaawe nuussi lo77a; neeni dosooppe, nuuni hawaan heezzu daasiyaa ittuwa new, ittuwa Musew, ittuwa Eelaasaw keexxana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","I haasayishshin, poo7iyaa shaarii yiinne unttuntta kammi aggeedda; shaariyaa giddoppe, “Hawe taani siiqiyaa taana nashechchiyaa ta Na7aa; I giyaawaa sisite” giya qaalay yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","A kaalliyawanttu he qaalaa siseedda wode, daro yayyiide, guufanni aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesuusi unttunttukko yiide, unttuntta bochchiide, “Denddite; yayyoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Unttunttu dhoqqu giide xeelliyaa wode, Yesuusa xalalaappe attin, hara asaa oonanne be7ibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Unttunttu deriyaappe wodhdhishshin, Yesuusi unttuntta, “Taani Asa Na7ay, hayquwaappe denddana gakkanaw, ha hinttenttu be77eeddawaa oossinne odoppite” yaagiide azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A kaalliyawanttu Yesuusa, “Yaatina, higgiyaa tamaarissiyaawanttu ayissi, ‘Eelaas kasetiide yaanaw bessee’ giinoo?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","I zaariide yaageedda; “Eelaas kaset yiide, ubbabaa giigissanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Shin taani hinttenttoo oday; Eelaas hawaappe kase yidiggeedda. Hewode asay A, barenttoo koyyeeddawaadan ubbaa ootheeddawaappe attin A eribeykkino; hewaadankka, qassi taana, Asa Na7aa, asay waayissanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","A kaalliyawanttu he wode barenttoo Yesuusi Xammaqiyaa Yohaannisabaa odiyaawaa akeekeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Unttunttu daro asaakko yeedda wode, itti bitani Yesuusakko yiide, A sinthaan gulbbatiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ta Godaw, ta na7aa wozanaa bayizziyaa harggii oyqqina, I daro wode tamaan, qassi daro wode haathaan kunddiyaa diraw, I darii sakettee; A pathaarikki. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Neena kaalliyaawanttukkokka A ahaaddi; shin pathanaw danddayibeykkino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesuusi zaariide unttuntta, “Ammanenna ha wodiyaa geella asaw! Taani hinttenanna awude gakkanaw de7anee? Qassi hinttenttubaa awude gakkanaw danddayanee? Na7aa taakko haa akkiide yiite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesuusi iita ayyaana, “Aappe kesa” giide azazina, iita ayyanay na7aappe kesi aggeedda; ellekka na7ay paxi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hewaappe guyyiyan, A kaalliyawanttu barenttu xalala Yesuusakko yiide, “Nuuni iita ayyaana kessanaw ayissi danddayibeykkoo?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesuusi unttuntta yaageedda; “Hewe hinttenttu ammanuu guuxxeedda diraassa; taani hinttenttoo tumuwaa oday; hinttenttoo sannaaficiyaa geetettiyaa guutha mithatti ayfiya keena ammanuu de7intto, hinttenttu ha deriyaa, ‘Hawaappe yaa shiiqa’ yaagintto I shiiqana; hinttenttu ayaanne oothanawukka danddayanita. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Shin hawaa malaa woosaappenne xoomaappe harabay kessanaw danddayenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","A kaalliyawanttu Galiilaan, ittippe shiiqi utti de7ishshin, Yesuusi unttuntta, “Taana, Asa Na7aa, asay asaw aathiide immana. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Asay taana wodhanawaa; hewaappe guyyiyan taani heezzenthiyaa gallassi hayquwaappe denddana” yaageedda. A kaalliyawanttu daro qaretteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuusinne A kaalliyawanttu Qifirinaahooma katamaa yeedda wode, Geeshsha Golliyaassi qaraxaa akkiyawanttu Phexiroosakko yiide, “Hinttentta tamarissiyaawe Geeshsha Golliyaa giiraa giirennee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","I zaariide, “Giiree” yaageedda. Phexiroosi soy geleedda wode, Yesuusi kasetiide A, “Simoonaa, ne qofay ayee? Ha sa7aa kaatatuu qaraxaa woy giiraa ooppe akkiinoo? Barenttu gadiya asaappe akkiinoo woy hara gadiya asaappe akkiinoo?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Phexiroosi, “Hara gadiya asaappe akkiino” yaageedda. Yesuusi Phexiroosa, “Yaatooppe, gadiya asay giiranaw bessenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Shin nuuni ha asatuwa hanqqethanaw koyyokko; neeni abbaa baade aani dabbaa yegga; yaataade koyro kesiyaa moliyaa oyqqaade, A doonaa pooqiyaa wode, giiraw gidiyaa miishshaa neeni demmana. Hewaa akkaade, ta giiraanne ne giiraa unttunttoo imma” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A kaalliyawanttu Yesuusakko he wode yiide, “Saluwaa kawutethaan ubbaappe aadhdhiyaawe oone?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesuusi itti guutha na7aa xeesi unttunttu giddon essiide, hawadaan yaageedda; ");
INSERT INTO dwrNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Taani hinttenttoo tumuwaa oday; Xoossaakko hinttenttu simmiide, guutha naanaadan hanana dhayooppe, saluwaa kawutethaa ubbakka gelanaw danddayikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Simmi ha guutha na7aadan, barena kawushshiyaa ooninne saluwaa kawutethaan ubbaappe aadhdhiyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Qassi hawaa mala na7aa ta sunthaan mokkiyaa ooninne taana mokkee. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Shin taana ammaniyaa ha guutha naanaappe ittuwa balethiya ooninne, gaacciyaa wogga woxaa bare qoodhiyaan qachchiide, abbaa ciimmuwaan mitettiyaawe aw lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Alamii asaa dhubbiyaa diraw, sa7aw aayyero; ayissi gooppe, dhubbiyaabay yuussaa aggenna; shin dhubuu A gaasotaan yiyaa uraw aayyero. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Neena kushii woy ne gedi neena balethooppe, neeppe qanxxa ola; neeni laa77u kushiyaannanne laa77u gediyaanna medhinaa tamaan olettiyaawaappe wobba woy duuxa kushiyaanna medhinaa de7uwaa geliyaawe new lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Qassi ne ayfii neena balethooppe, neeppe wooca kessa ola; neeni laa77u ayifiyanna Gaannamiyaa tamaan olettiyaawaappe itti ayifiyanna medhinaa de7uwaa geliyaawe new lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hinttenttu ha guuthatuwappe ittuwanne kadhenna mala, hinttentta naagite; ayissi gooppe, taani hinttenttoo oday; saluwan unttunttu kiitanchchatuu ubba wode, saluwan de7iya ta Aabbu sinthaan de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ayissi gooppe, taani, Asa Na7ay, bayeeddawaa ashshanaw yaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Itti asaw xeetu dorssatuu de7iyaawanttuppe ittuu bayooppe, udduppu tammanne udduppunuwaa deriyaan aggiide, he bayeeddawaa koyyanaw beennee? Hinttenttu waagiitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Taani hinttenttoo tumuwaa gay; I demmooppe, bayibeenna udduppu tammanne udduppu dorssatuwaappe aathiide, he itti dorssaan nashettee. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hewaadankka, saluwan de7iya hinttenttu Aabbu ha guuthatuwappe ittuu bayanawaakka koyyenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ne ishay neena naaqqooppe, neerekka aakko baade, A naaquwaa aw oda; I newaa sisooppe, ne ishaa balaappe zaaraadda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Shin I newaa sisennaan ixxooppe, laa77u woy heezzu markkay markkattowaan yewuu ubbay tumattiyaa diraw, hara itti woy laa77u asaa neenanna ittippe afa. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","I unttunttubaa sisennaan ixxooppe, ubbabaa ammaniyaa asaw oda; qassi ammaniyaa asay giyaawaakka I sisennaan ixxooppe, ammanenna asaadaaninne qaraxaa shiishshiyaa asaadan A payda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Taani hinttenttoo tumuwaa gay; neeni sa7aan hano goowe ubbay saluwan Xoossaa sinthaan hanana; shin neeni sa7aan hanoppo geeddawe saluwankka hanenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Qassikka taani hinttenttoo oday; hintteppe laa77u uray sa7an Xoossaa woossiyaawaan ay yewuwaaninne itti wozanaa gidooppe, saluwan de7iya ta Aabbu hewaa hinttenttoo immana. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ayissi gooppe, laa77u uray woy heezzu uray ta sunthaan shiiqiyaasaan, taani hewaan unttunttu gidduwan de7ay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Phexiroosi; he wode Yesuusakko yiide, “Godaw, ta ishay taana aappu kaalla naaqqooppe taani aw atto gaanaw bessii? Laappunuwaa gakkanaw naaqqineeyee?” yaagiide A oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesuusi zaariide A, “Gidenna, taani neena laappun tammu kaalla laappunuwaa gayippe attin, laappunuwaa xalalaa giikke. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ayissi gooppe, saluwaa kawutethay bare qoomatuwaanna miishshaa heetettanaw qoppeedda kaatiyaa bessee. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","He kaatii miishshaa heetettanaw doommeedda wode, daro miiloone biraa acuu de7iyaa itti bitaniyaa aakko aheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Shin he qoomaw acuwaa ciggiyaawe dhayina, A goday he acuwaa cigganaw, A machchattanne iinne A naanay, qassi aw de7iya ubbabay zali77ettana mala, A azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hewaa diraw, qoomay bare godaa sinthaan gulbbatiide, ‘Ta godaw, hayyagodo guutha wodiyaa naagarikkii; taani new ubbabaakka ciggana yaagiide A woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A goday aw qarettiide, A yeddi aggeedda; A acuwaakka aw maarii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Shin he qoomay kesiide, bare laggethaa qoomatuwaappe ittuu bareppe xeetu biraa santtimiyaa tal77eeddawaanna gakettiide, ‘Ne bolla de7iya ta miishshaa cigga’ yaagi oyqqiide, A cuulleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Yaatina he A laggethaa qoomay A sinthaan gulbbatiide, ‘Ha77i ta7ishay guutha wodiyaa naagarikkii; taani new ubbabaakka ciggana’ yaagiide A woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Shin ixxi akki biide, A laggethay he acuwaa qanxxana gakkanaw, qasho golle gelisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hewaa diraw, A laggethaa qoomatuu hewaa be7iide, daro yiloteeddino; barenttu godaakko biide, I ootheedda ubbabaa aw odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Hewaappe guyyiyan, goday he qoomaa xeesiide, ‘Ha iita qoomaw, neeni taana woosseedda diraw, taani he acuwaa ubbaa new maaraa aggaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Taani new he acuwaa maareeddawaadaan, neenikka ne laggetha qoomaw maaranaw bessennee?’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hewaappe simmiide aw daro hanqqettiide, bare acuwaa ubbaa I ciggi wurssana gakkanaw, paxa kaa7ettana mala, qasho golle gelisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Hinttenttu huuphiyan huuphiyan hinttenttu ishaw wozanappe atto gaana dhayooppe, he goday bare qoomaa ootheeddawaadan, saluwan de7iya ta Aabbukka hinttentta hewaadan oothana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuusi he haasayaa wurssowaappe guyyiyan, Galiilaappe denddiide, Yorddaanoosa Shaafaappe hefinthan de7iya Yihudaa gadiya beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Daro asay A kaalliide beeddawaa hewaan patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Itti itti Parisaawatuu paaccanaw Yesuusakko yiide, “Itti asay ay gaasuwaaninne, bare machchatto yeddanaw nu higgii azazii?” yaagiide A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesuusi zaariide, hawaadan yaageedda; “Xoossay koyro unttuntta medhdhiidde, attumawaanne maccawunno ootheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hewaa diraw, ‘Itti asay bare aabbanne bare daayo aggiide, bare machchattinna ittippe de7ee; unttunttu laa77uu itti asaa gidiino’ yaagiyaa qaalaa nabbabibeykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hewaa diraw, unttunttu itti asa gidiyaawaappe attin, laa77u asa gidikkino; hewaa diraw, Xoossay ittippe de7anaadan gathowaa asay shaakkoppo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisaawatuu Yesuusa, “Yaatina, Muse ayaw itti uray bare machchatto pirimaa peedhiide yeddana mala azazeeddee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesuusi zaariide, “Hinttenttu hinttenttu machchatuwaa yeddana mala, Muse hinttentta azazeeddawe, hinttenttu odina sisenna guzuma gido diraappe attin, koyro hewaa mala gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Taani hinttenttoo oday; bare machchatto woshummennaan de7ishshin yeddiide, hararo akkiya ooninne woshummee; haray yeddeeddawunno akkiyawekka woshummee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesuusa kaalliyawanttu A, “Asinaa gidduwaninne machchatti gidduwaan de7iya wogay hewaa mala gidooppe, akkennaaninne gelennaan de7iyaawe lo77a” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Shin Yesuusi unttuntta yaageedda; “Hewaa mala timirttii Xoossay immowanttussappe attin, asaa ubbaassa gidenna; ");
INSERT INTO dwrNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ayaw gooppe, barenttu daayi uluwaappe yelettiyaa wodekka, shuufa gideeddawanttu de7iino; qassi asay qaaratina mureesa gideeddawanttu de7iino; qassi saluwaa kawutethaa diraw, barentta shuufa udeeddawanttu de7iino; ha timirttiyaa akkanaw danddayiyaawe ooninne akko” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yesuusi he wode bare kushiyaa guutha naanaa bolla wothiide, Xoossaa woossana mala, itti itti asay naanaa aakko aheedda; shin Yesuusa kaalliyawanttu he asaa ahenna mala hanqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Shin Yesuusi, “Qeeri naanay taakko yiyaawaa diggoppite; ayaw gooppe, saluwaa kawutethay hewanttu malaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hewaappe simmiide bare kushiyaa unttunttu bolla wotheeddawaappe guyyiyan, hewaappe bashi beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Itti bitani Yesuusakko yiide, “Tamaarissiyaawoo, taani medhinaa de7uwaa demmanaw lo77obaa ayaa oothoo?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesuusi A, “Lo77obay ayentto taana ayaw oochchay? Ittuwaa xalalay lo77a; shin neeni medhinaw de7anaw koyyooppe, azazatuwaa naaga” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Bitani, “Haqawantta?” yaagiide oochcheedda. Yesuusi zaariide, “Wodhoppa; woshummoppa; wuu77oppa; wordduwaa markkattoppa; ");
INSERT INTO dwrNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ne aabbanne ne daayo bonchcha; ne shooruwaakka ne huuphiyaadaan siiqa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","He yalaga bitani Yesuusa, “Taani hewaa ubbaakka guuthatethaappe doommaade naagaaddi; yaatina, taw pacciyaawe ayee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuusi bitaniyaa, “Neeni polo asa gidanaw koyyooppe, baade new de7iyaawaa zali77aade, he miishshaa hiyyeesaw imma; neeni saluwan durettana; yaataade yaade taana kaalla” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Shin he yalaga bitani hewaa siseedda wode, I daro dure gidiyaa diraw, qarettiidde bashi beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesuusi barena kaalliyaawanttussi, “Taani hinttenttoo tumuwaa gay; dure asay saluwaa kawutethaa gelanawe daro meto gidanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Taani gujjaadekka hinttenttoo oday; dure asay Xoossaa kawutethaa gelanaappe, gaaluu marppiyaa lukuwaanna aadhdhanawe matattee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","A kaalliyawanttu hewaa sisi maalalettiide, “Yaatina, ooni attanaw danddayii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesuusi unttuntta caddi xeelliide, “Hawe asaw danddayettenna; shin Xoossaw ubbabay danddayettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Phexiroosi he wode zaariide Yesuusa, “Be7a, nuuni nuussi de7iya ubbabaa bashiide, neena kaalleeddo; yaatiide nuuni ayaa demmaneeshsha?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesuusi unttuntta hawadaan yaageedda; “Taani hinttenttoo tumuwaa gay; taani, Asa Na7ay, ooratha gadiyan ta kawutethaa oydiyaan uttiyaa wode, taana kaalleedda hinttenttukka tammanne laa77u Isra7eeliya zaratuwaa bolla pirddanaw, tammanne laa77u kawutethaa oydiyaan uttanita. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta sunthaa diraw, golliya woy ishatuwaa woy michchatuwaa, woy aawuwaa woy aatto woy machchatto, woy naanaa woy gadiyaa aggeedda ooninne, xeetu dakkuwaappe daruwaa akkana; qassi medhinaa de7uwaakka laattana. ");
INSERT INTO dwrNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Shin coratuu ha77i sinthateeddawanttu guyyetanawantta; qassi coratuu ha77i guyyen de7iyaawanttu sinthatanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Saluwaa kawutethay woyiniyaa geetettiyaa turaa gidduwaa oothiyaawantta uniyaa oosissanaw, wontta guuraan keseedda woyiniyaa turaa godaa bessee. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","I he oosanchchatoo hachche hachche ootheeddawaa wolqqaa gatiyaa cigganaw unttunttunna giigiide, bare woyiniyaa turaa gidduwaa oosissanaw unttuntta yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Qassi heezzu saatiyaa gidoode kesiide, oosuu baynnaan qocaan eqqeedda hara asatuwa be7iide, ");
INSERT INTO dwrNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","unttuntta, ‘Hinttenttukka qassi ta woyiniyaa turaa gidduwaa oothanaw biite; taani hinttenttoo bessiyaa gatiyaa ciggana’ yaageedda; hewaappe guyyiyan unttunttu beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Laa7ethuwaakka usuppun saatiyaaninne udduppu saatiyaan kesiide, hewaadan ootheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tammanne itti saatiyaa heran I kesiyaa wode, haranttu hewaan eqqeeddawantta demmiide, ‘Oosuwaa oothennaan kumentha gallassaa hawaan ayaw eqqi peeshedditee?’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Unttunttu, ‘Nuuna oosissiyaa asay dhayeedda diraw eqqi peesheeddo’ yaageeddino. “I, ‘Hinttunttukka qassi ta woyiniyaa turaa gidduwaa oothanaw biite’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Sa7ay omarssiyaa wode, woyiniyaa turaa goday oothiyaawanttu kaappuwaa, ‘Oosanchchatuwaa xeesaade, wurssethaan oosuwan geleeddawanttuppe doommaade koyro geleeddawantta gakkanaw, unttunttu oosuwaa dirgguwaa cigga’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Tammanne itti saatiyaa heeran oosuwaa doommeeddawanttu yiide, huuphiyan huuphiyan oothiide peesheedda wolqqaa gatiyaa akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Koyro oosuwaa doommeedda asay yeedda wode, daruwaa akkanaw qoppeeddino; shin unttunttukka huuphiyan huuphiyan barenttu oosuwaa wolqqaa gatiyaa akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Hewaappe guyyiyan, ‘Ha guyyeppe yeeddawanttu itti saatiyaa xalalaa ootheeddino; kumentha gallassaa daaburiide cawotteedda nuwaanna unttunttu oosuwaa dirgguwaa qaraa oothaadda’ yaagiide barentta oosuwan gelisseeddawaa bolla zuuzummeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Shin I unttunttuppe ittuwa hawadaan yaageedda; ‘Ta laggew, taani neena naaqqabeykki; oothaade peesheedda wolqqaa gatiyaa taananna giigabeykkiyee? ");
INSERT INTO dwrNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Newaa akkaade ba; taani ha77i wurssethaan oosuwan geleeddawookka newaa keenaa immanaw koyyay. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Taani ta miishshaan ta koyyeeddawaadan oothanaw taw maatay baawee? Woy taani lo77a gideedda diraw, neeni qanaatay?’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Hewaadankka, qassi guyyeteeddawanttu sinthatanawantta; sinthateeddawanttu qay guyyetanawantta; ayaw gooppe, xeesetteeddawanttu cora; shin dooretteeddawanttu guutha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuusi Yeerusalaame biidde, ogiyaan barenanna biya tammanne laa77u barena kaalliyaawantta gaxaa kessiide, dumma unttunttussi yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Be7ite, nuuni Yeerusalaame ha77i keseetto. Yaani taana, Asa Na7aa qeesatuwaa kaappatuwaassinne higgiya tamaarissiyaawanttussi aathiide immanawantta; unttunttu ta bolla hayquwaa pirddaa pirddanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Qassi Ayihuda gidenna asaassikka taana aathiide immanawantta; he Ayihuda gidenna asay ta bolla qilliiccanawanttanne taana lissuwan shocanawantta; yaatiide masqqaliyaa bolla misimaariyan dhishiide, taana kaqqanawantta; taani heezzenthiyaa gallassi hayquwaappe denddana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","He wode Zabiddiyoosa naanaa daaya bare naanaanna Yesuusakko yaaddu; A sinthaan gulbbataade ittibaa A woossaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesuusi izo, “Ayaa koyyay?” yaagiide oochcheedda. Iza zaaraade, “Ha ta laa77u naanay ne kawutethaan ittuu neeppe ushechcha bagganna, qassi ittuu neeppe haddirssa bagganna uttino yaagaarikkii” yaagaade woossaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Shin Yesuusi zaariide naanaa, “Hinttenttu ayaa woossanaw bessintto erikkita. Taana gakkiya woliqqaama metuwaa metootanitee? Taani xammaqettana xinqqataa xammaqettanaw danddayiitee?” yaageedda. Unttunttu, “E danddayana” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesuusi, “Taana gakkiya woliqqaama metuwaa tumakka hinttenttu metootanita; shin taappe ushechcha baggannanne haddirssa bagganna uttanawantta dooranaw taw maatay baawa; shin he sa7ay ta Aabbu immanaw giigissi wotheeddawanttussa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yokko tammu Yesuusa kaalliyawanttu hewaa siseedda wode, he laa77u ishatuwassi hanqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Shin Yesuusi unttunttu ubbatuwakka barekko xeesiide, hawadaan yaageedda; “Ahizaabe asatuwaa kaappatuunne hawantta kaalethiyaa asatu barenttu asaa ayissiyaawaa eriita. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Hinttenttu gidduwaan hewaa mala gidenna; shin hinttenttu gidduwaan dhoqqatethaa koyyiyaa ooninne hinttenttoo qooma gidanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Qassi hinttenttu gidduwaan ubbaappe bolla gidanaw koyyiyaawe ooninne hinttenttoo aylle gidanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hewaadan taani, Asaa Na7ay, asaw oothanawunne daro asaa wozanaw ta shemppuwaa immanaw yeeddawaappe attin, asay taw oothana mala yabeykke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesuusinne A kaalliyawanttu Iyyarkkoppe kesishshin, daro asay unttuntta kaalleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Laa77u qooqa asatuu ogiyaa doonaan utteeddawanttu Yesuusi hewaanna aadhdhiyaawaa sisiide, barenttu kooshshaa dhoqqu oothiide, “Godaw, Daawita na7aw, nuussi qarettaarikkii” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Daro asay unttuntta, “Hayzzite” giide hanqqetteedda; shin unttunttu barenttu kooshshaa darii dhoqqu oothiide, “Godaw, Daawita na7aw, nuuna maaraarikki!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesuusi ogiyaan eqqiide, unttuntta xeesiide, “Taani hinttenttoo ayaa oothana mala koyyiitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Qooqatuu, “Godaw, nu ayfiyaa pathaarikki” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuusi unttunttoo qarettiide, unttunttu ayfiyaa bochcheedda; ellekka unttunttu ayfii xeelli aggina, A kaallii aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Unttunttu Yeerusalaame matiide, Debre Zayte geetettiyaa deriyaa lanqqiyan de7iya Beetefaage geetettiyaa qeeri katamaa gakkeeddino; Yesuusi barena kaalliyaawanttuppe laa77uwaa sinthaw kiittiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","unttuntta hawadaan yaageedda; “Hinttenttuppe sinthaan de7iya qeeri katamaa biite; hewaan itti haratta qashuwan de7ewunno izi maraanna hinttenttu bi simmo sankka demmanita; unttuntta billiide, taw akki yiite. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ooninne hinttentta oochchooppe, ‘Goday hawantta koyyee’ yaagite; ellekka I unttuntta yeddi agganawaa.” ");
INSERT INTO dwrNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Timbbitiyaa odiyaa nabii, “Xiyoone katamaa asaw, ‘Be7a, ne kaatii ashikke gidiide, hariyaa bolla, hare maraa bolla uttiide, neekko yee’ yaagite” yaagiide haasayeeddawe polettana mala, hawe haaneedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A kaalliyawanttu biide, Yesuusi barentta azazowaadan ootheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Harattonne hare maraa ahiide, barenttu mayuwaa unttunttu zokkiyaan wotheeddino; hewaappe simmina Yesuusi toggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","He cora asaappe dariya baggay bare mayuwaa ogiyaan hiixxeedda; qassi haranttu mithaa haythaa kar kariide, ogiyaan yeggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yesuusappe sinthanna hamettiyaa cora asaynne qassi A geeduwaa kaalliyaa cora asay, barenttu kooshshaa dhoqqu oothiide, “Daawita na7ay galatetto! Godaa sunthaan yiyaawe anjjetteeddawaa! Xoossay galatetto!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesuusi Yeerusalaame katamaa geleedda wode, katamaan de7iya asay ubbay, “Hawe oone?” yaagiide shabbiretteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Asay, “Hawe Galiilaan de7iya Naazireete geetettiyaa katamaappe yeedda nabiyaa Yesuusa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuusi Geeshsha Golliyaa geliide, hewaan zali77iyaawanttanne shammiyaawantta ubbaa kare yedersseedda; qassi miishshaa laammiyaawanttu xaraphpheezaanne dogommuwaa zali77iyaawanttu oydiyaa guphi yeggiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","unttuntta, “Xoossaa Maxaafan, ‘Ta gollii Xoossaa woossiyaa golliyaa geetettana’ yaagettiide xaafetti utteedda; shin hinttenttu A bonqqiyaawanttu qosettiyaa gonggoluwaa kesseeddita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Qooqatuunne gedi sileeddawanttu Yesuusakko Geeshsha Golliyaa yiina, I unttuntta patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Shin qeesatuwaa kaappatuunne higgiya tamaarissiyaawanttu Yesuusi oothiyaa oorathabaa be7eedda wodenne, guutha naanay Geeshsha Golliyan barenttu kooshshaa dhoqqu oothiide, “Daawita na7ay galatetto” yaagiyaawaa be7eedda wode hanqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yaatiide Yesuusa, “Hawanttu giyaawaa sisay?” yaageeddino. Yesuusi, “E sisay; Xoossaa Maxaafay, ‘Guutha naanaynne dhammiyaa naanay neena galatana mala, unttuntta erissaadda’ yaagiyaawaa ubbakka nabbabibeykkitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesuusi unttuntta aggiide, he katamaappe Biitaaniyaa geetettiyaa katamaa biide, yaani aqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesuusi wontta guuraanna katamaa beedda diraw koshatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ogiyaa doonaan itti balasiyaa geetettiyaa mithatto be7iide, iikko beedda; bi gakkiya wode he mithattin haythaa xalalaappe attin, ayfiya aynne demmibeenna; izo, “Laa7ethuwaa medhinawukka ayfoppa” yaagina, he balasatta man77iyan melaa aggaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","A kaalliyawanttu hewaa be7iide maalalettiide, “Ha balasatta waanaade itti kuthaan mela aggaaddee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesuusi zaariide, “Taani hinttenttoo tumuwaa gay; hinttenttu ammanuu de7iyaawanttanne sidhennawantta gidooppe, ha balasatto taani ootheeddawaa mala xalalaa oothikkita; shin haray atto hinttenttu ha deriyaa, ‘Denddaade abbaan kundda’ ginttokka hanana; ");
INSERT INTO dwrNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","hinttenttu ammaniide Xoossaa woossiyaawaa ayaa gidinttokka akkana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuusi Geeshsha Golliyaa yiide tamaarissishshin, qeesatuwaa kaappatuunne Ayihuda cimatuu aakko yiide, “Neeni hawaa oothanaw new ay maatay de7ii? New ha maataa oone immeeddawee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesuusi zaariide unttuntta, “Taanikka hinttentta ittibaa oochchana; hinttenttu taw hewaa odooppe, taani hawaa ay maataani oothaytantto, hinttenttoo odana; ");
INSERT INTO dwrNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohaannisi xammaqiyaa maatay haqappe yeeddee? Xoossaappe yeeddeyee asaappe yeeddee?” yaageedda. Unttunttu barenttu gidduwaan palumaa doommiide, “Nuuni, ‘Xoossaappe yeedda’ yaagooppe I nuuna, ‘Yaatooppe, Yohaannisi odeeddawaa ayaw ammanibeykkitee?’ yaaganawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Shin nuuni, ‘Asaappe yeedda’ yaagooppe, asay ubbay Yohaannisi nabiyaa gideeddawaa eriya diraw, asaw yayyeetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Unttunttu Yesuusaw, “Nuuni erokko” yaagiide zaareeddino. Yesuusi, “Taanikka hawaa ay maataani oothaytantto, hinttenttoo odikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Shin hinttenttu ayaa qoppiitee? Laa77u naanay de7iya itti bitani de7ee; he bitani bayra na7aakko biide, ‘Ta na7aw, hachche baade ta woyiniyaa turaa ootha’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na7ay zaariide, ‘Biikke’ geedda; shin guyyeppe bare wozanaan qoppi akkiide, woyiniyaa turaa oothanaw beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aawuu yokko na7aakko biide, bayraw geeddawaadankka aw geedda; teefa na7ay zaariide, ‘Lo77a ta godaw’ yaageedda; shin bibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ha laa77u naanaappe bare aawuu koyyeeddawaa ootheeddawe haqawee?” yaageedda. Unttunttu, “Bayraa” yaageeddino. Yesuusi unttuntta hawaadan yaageedda; “Taani hinttenttoo tumuwaa gay; qaraxaa akkiyawanttunne woshummiyaawanttu hintteppe sinthatiide, Xoossaa kawutethaa gelana. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ayissi gooppe, Xammaqiyaa Yohaannisi xillotethaa ogiyaa tamaarissiidde, hinttekko yiina, I giyaawaa ammanibeykkita. Shin qaraxaa akkiyawanttunne woshummiyaawanttu I giyaawaa ammaneeddino; hinttenttu haray atto hewaa be7iidikka, hinttenttu nagaraappe simmiide, I giyiyawaa ammanibeykkita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Qassikka Yesuusi hawaadan yaageedda; “Hara leemisuwaakka sisite; woyiniyaa geetettiyaa turaa tokkeedda itti bitani de7ee; woyiniyaa turaa yuushshi aathiide direedda; qassi he woyiniyaa gumi77iyaa ollaakka bookkeedda; hewaa naagiyaa asaw adussa shuchchaa gimbbeedda. Hewaappe guyyiyan, kothaa oothiyaa asaw immiide, hara gade beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Woyiniyaa ayfiyaa maxiyaa wodii gakkina, barena gakkiyawaa akkiide yaana mala, bare qoomatuwaa bare kothawatuwaakko kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kothaawatuu A qoomatuwaa oyqqiide, ittuwa wodheeddino; qassi yokkuwaa shuchchan phalqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Qassikka he bitani kasewanttuppe dariya hara qoomatuwaa kiitteedda; kothawatuu he qoomatuwaakka kasewanttuwaadaan ootheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Shin wurssethaan I, ‘Ta na7aa unttunttu bonchchanawantta’ yaagiide bare na7aa unttunttukko kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Shin kothawatuu na7aa be7iide, barenttu gidduwaan, ‘Gadiyaa laattanawe hawaa; biide A wodhiide, gadiyaa nuuni laattana’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na7aa oyqqiide, woyiniyaa turaa giddoppe gaxaa kessiide wodheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Simmi woyiniyaa turaa goday yiyaa wode, he kothawatuwaa wootanee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Unttunttu, “I he iita asatuwa wodhi wurssiide, woyiniyaa turay ayfiya wode barena gakkiyawaa wodiyaan sheedhdhiyaa hara kothaawatuwaassi immana” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesuusi unttuntta hawadaan yaageedda; “ ‘Gimbbiyaawanttu kadhiide ixxeedda shuchchay godaa xaphuwaa minissiyaa, ubbaappe aadhdhiyaa shuchchaa gideedda. Hawe Goday ootheeddawaa; qassi nu xeelawukka maalalissiyaawaa’ yaagiyaawaa Xoossaa maxaafaappe ubbakka nabbabibeykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Hewaa diraw, taani hinttenttoo oday; Xoossaa kawutethay hintteppe akettiide, lo77o ayfiyaa immiya asaw imettanawa. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","He shuchchaa bolla kunddiyaa ubbay me7erettana; qassi he shuchchay asaa bolla kunddooppe, he kunddeedda uraa liiqissana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Qeesatuwaa kaappatuunne Parisaawatuu Yesuusi odeedda leemisuwaa siseedda wode, barenttuwaa haasayiyawaa ereeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Unttunttu Yesuusa oyqqanaw koyyeeddino; shin Yesuusa daro asay nabiyaa giide qoppi utteedda diraw, he asaw yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuusi asaw laa7ethuwaa leemisuwan hawadaan yaagiide haasayeedda; ");
INSERT INTO dwrNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Saluwaa kawutethay bare na7aw machchiyaa immanaw ubbabaa makkeedda kaatiyaa mala. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","He kaatii bullachchaw odi wotheedda asatuwa xeesanaw bare qoomatuwaa kiitteedda; shin asatu yaanaw koyyibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Qassi hara qoomatuwaa, ‘Xeesetteeddawantta, “Taani qumaa giigissaaddi; ta sanggatuunne ta modhdho miyatuu shuketteeddino; ubbabaykka maketteedda. Bulachchaa haa yiite” yaagite’ yaagiide kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Shin xeesetteeddawanttu koyyennaan ixxiide, barenttu oosoo beeddino; ittuu bare goshshaw biina, yokkuu bare zali77ew beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Atteeddawanttu qassi kaatiyaa qoomatuwaa oyqqi wadhdhiide wodheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Kaatii daro hanqqetteedda; qassi bare wottaaddaratuwaa yeddiide, he shemppuwaa wodheeddawantta wodhissiide, unttunttu katamaa guudisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hewaappe guyyiyan, bare qoomatuwaa, ‘Bullachchay maketteedda; shin xeesetteeddawanttu bullachchaw bessiyaa asa gidikkino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hewaa diraw, wogga qadhdhaa biide, hinttenttu demmeedda asaa ubbaa bullachchaw xeesite’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","He qoomatuu qadhdhaa biide, barenttu demmeedda asaa ubbaa lo77uwaa iitaa shiishshiide, bullachchaa daasiyaa kuntheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Shin kaatii qumaa maanaw utteedda asaa be7anaw geleeddda wode, bullachchaa mayuwaa mayyibeenna itti bitaniyaa hewaan be7iide, ");
INSERT INTO dwrNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Ta laggew, bullachchaa mayuwaa mayyennaan waanaade hawaa gelaaddii?’ yaagina bitani co77u geedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Hewaappe guyyiyan, kaatii bare qoomatuwaa, ‘Ha bitaniyaa kushiyaanne gediya qachchiide, kare dhumaa kessi olite; I hewaan yeekkananne achchaa dhaqana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ayissi gooppe, xeesetteeddawanttu dara; shin dooretteeddawanttu guutha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hewaappe guyyiyan, Parisaawatuu biide, A haasayaappe balaa demmiide, A oyqqana mala maqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Qassi barentta kaalliyaawanttupenne Heroodisa baggatuwaappe amareeddawantta aakko kiitteeddino. Unttunttu, “Tamaarissiyaawoo, neeni tumuwaa haasayiyaawaanne Xoossaa ogiyaa tumatethaan tamaarissiyaawaa nuuni ereetto; ayaw gooppe, neeni asaappe asaa shaakkakkanne dummayakka. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ne qofay ayentto nuussi oda; nuuni Roome gadiya Kaatiyaa Qeesaarew giiraa giiriyaawe wogeeyee woga gidennee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Shin Yesuusi unttunttu iita qofaa eriide, “Ha lo77a malatiyaa iita asatoo, ayaw taana paacciitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Giiraa giiriyaa miishshaa taana bessite” yaageedda. Hewaappe guyye unttunttu biraa santtimiyaa aw aheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","I, “Ha malaynne sunthay oowee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hewaappe simmiide unttuntta oochchina, unttunttu, “Roome gadiya Kaatiyaa Qeesaarewaa” yaageeddino. Hewaappe guyyiyan, Yesuusi unttuntta, “Yaatooppe, Qeesaarewaa Qeesaaressi, Xoossaawaa Xoossaassi immite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Unttunttu hewaa siseedda wode, maalalettiide A aggiide beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hayqqeedda asay denddenna giyaa Saduqaawanatuwaappe itti itti asatuu he gallassi Yesuusakko yiide, hawadaan yaagiide, A oochcheeddino; ");
INSERT INTO dwrNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tamaarissiyaawoo, Muse, ‘Itti asay na7aa yelennaan hayqqooppe, he hayqqeeddawaa ishay A machchatto laattiide, bare ishaw na7aa yelanaw bessee’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nuunanna laappu ishatuu de7iino; bayray machchatto akkiide, na7aa yelennaan hayqqeedda; hewaappe guyyiyan A machchatto A ishay akkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Qassi laa7ethiyaawekka hayqqeedda; heezzethiyaawekka, laappuntha gakkanawukka hewaadan haneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ubbaappe guyyiyan, he mishiratta hayqqaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yaatina, hayqqeedda asay hayquwaappe denddiyaa gallassi he mishiratta laappunatuwaappe haqawoo machche gidanee? Ayissi gooppe, laappunatuu ubbaykka izo akkeeddino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesuusi zaariide, hawaadan yaageedda; “Xoossaa Maxaafatuwaa woy A wolqqaa hinttenttu erenna diraw baliita. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ayissi gooppe, hayqqeedda asay hayquwaappe denddiyaa gallassi, saluwan de7iya kiitanchchatuwa mala gidanaappe attin, attuma asaynne akkenna; macca asaynne gelenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Shin hayqqeeddawanttu dendduwaabaa gidooppe, Xoossay, ‘Taani Abraahaame Xoossaa, Yisaaqa Xoossaa, Yayiqooba Xoossaa’ yaagiide hinttew odeeddawaa ubbakka nabbabibeykkitee? Xoossay paxa de7iyaawanttu Xoossaa gidiyaawaappe attin, hayqqeeddawanttu Xoossaa gidenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Daro asay hewaa sisiide, A timirttiyaan maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Shin Yesuusi Saduqaawanatuwaa co77u ootheeddawaa Parisaawatuu siseedda wode, ittisaa shiiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Unttunttu giddoppe higgiya tamaarissiyaa ittuu, Yesuusa paaccanaw ittibaa oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tamaarissiyaawoo, higgiya gidduwaan ubbaappe aadhdhiyaa azazu haqawee?” yaagiide A oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesuusi zaariide, hawaadan yaageedda; “ ‘Neeni Godaa ne Xoossaa ne kumentha wozanaappe, ne kumentha shemppuwaappe, ne kumentha qofaappe siiqa’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hewe ubbaappe dariya azazuwaanne qassi ubbaappe aadhdhiyaa azazuwa. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Qassi laa7ethiyaa azazuukka A mala; hewe, ‘Neeni ne shooruwaa ne huuphiyaadaan siiqa’ giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Muse higgiya ubbaynne nabatuwaa timirttii ha laa77u azazatuwaan qashettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Parisaawatuu ittisaa shiiqeeddasaan Yesuusi unttuntta, “Kiristtoosabaa waagiide qoppiitee? I O na7ee?” yaagiide oochcheedda. Unttunttu, “Kiristtoosi Daawita na7aa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesuusi unttuntta, “Yaatina, Daawite barena Geeshsha Ayyaanay haasayissina Kiristtoosa waagiide, ‘Godaa’ giide xeesii? ");
INSERT INTO dwrNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Qassikka Daawite, ‘Goday ta Godaa, “Taani ne morkketuwaa neeni yedhdha eqqiyaawaa oothana gakkanaw, hawaan taappe ushechcha bagganna uttaade taananna ittippe daannata geedda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Daawite Kiristtoosa, ‘Godaa’ giide xeesooppe, yaatina, Kiristtoosi waaniide Daawita na7aa gidii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesuusaw itti qaalaa zaaranaw danddayeedda itti asaynne baawa; qassi he gallassaappe doommina, hara ooshaa A oochchanaw xaleeddawe ooninne baawa. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hewaappe guyyiyan, Yesuusi shiiqeedda asawunne barena kaalliyaawanttoo hawaadan yaagiide haasayeedda; ");
INSERT INTO dwrNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Higgiyaa tamaarissiyaawanttunne Parisaawatuu Muse higgiyaa tamaarissiyaa maataanna de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hewaa diraw, hinttenttu oothana mala, unttunttu hinttentta azaziya ubbabaa oothitenne qassi naagite; shin unttunttu oothiyaawaadan oothoppite; ayaw gooppe, unttunttu barenttu odiyaawaa oothikkino. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tookkanaw deexiyaa tookuwaa unttunttu qachchiide, asaa toossiino; shin barenttu huuphiyaan haray atto, he tookuwaa biradhdhiyan bochchanawukka koyyikkino. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Shin unttunttu barenttu oosuwaa ubbaa asay be7anaadan oothiino; ayaw gooppe, barenttu som77iyaaninne barenttu kushiyaa qessiyan qachchiyaa xiqisiyaanna de7iya kitaafaa aassiinonne barenttu mayuwaa macaraakka adussiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Asay barentta shoobbiide afosaan bonchcho utuwaa dosiino; qassi Ayihuda woosa golletuwaanikka daro lo77iyaa oydiyaa dosiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Asay gewaan barentta bonchchiide sarotana malanne ‘Tamaarissiyaawoo’ giide barentta xeesanaadan koyyiino. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Shin hinttentta tamaarissiyaawe ittuwa xalalaa gideedda dirawunne hinttenttu ubbay ishatuwaa gideedda diraw, ittuu ittuwa, ‘Tamaarissiyaawoo’ giide xeesoppite. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ha sa7an oonanne ‘Aawuwaa’ giide xeesoppite; ayaw gooppe, hinttenttoo saluwan de7iya itti Aawuu de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ittu ittuwaa, ‘Tamaarissiyaawoo’ giidekka xeesoppite; ayaw gooppe, hinttenttoo itti Goday, Kiristtoosa xalalay de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hinttenttu giddon ubbaappe dariyaawe hinttenttoo qooma gidanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Barena darissiyaawe ooninne tooshettana; qassi barena toochchiyaawe ooninne dhoqqu gaana. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Lo77a malatiyaa iitatoo, higgiya tamaarissiyaawanttoonne Parisaawatoo, asaw saluwaa kawutethaa hinttenttu gorddiya diraw, hinttenttoo aayyero; ayaw gooppe, hinttenttu huuphewunne gelikkita; qassi gelanaw koyyiyaawanttakka gelissikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Lo77a malatiyaa iitatoo, higgiya tamaarissiyaawanttoonne Parisaawatoo am77etuwaa golliyaa hinttenttu bonqqiide, hinttenttoo lo77a malatanaw Xoossaa woosaa adussiita; hewaa diraw, hinttenttoo aayyero; ubbaappe aadhdhiyaa pirddaa hinttenttu akkana. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Lo77a malatiyaa iitatoo, higgiya tamaarissiyaawanttoonne Parisaawatoo hinttenttu itti uraa ammanthanaw abbaaninne sa7an yuuyyiyaa dirawunne qassi hinttenttu A ammanthiya wode, he uraa hinttenttuwaappe laa77u kushiyaa iiteedda Gaannamew na7a oothiyaa diraw, hinttenttoo aayyero. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ ‘Ooninne Geeshsha Golliyan caaqqooppe, aynne baawa; shin Geeshsha Golliyan de7iya worqqaan caaqqooppe, he caaquu A gakkee’ giya hinttenttoo qooqi uttiide asaa kaalethiyaawanttoo, hinttenttoo aayyero. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ha eeyatuu, ha qooqatuu, worqqay aadhdhiiyee? Worqqaa geeshsha oothiyaa Geeshsha Golli aadhdhii? ");
INSERT INTO dwrNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Qassi hinttenttu, ‘Ooninne yarshshuwaa yarshshiyaaban caaqqooppe, aynneekka baawa; shin ooninne A bolla de7iya yarshshuwaan caaqqooppe, he caaquu A gakkee’ yaagiide tamaarissiita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ha eeyatuu, ha qooqatuu, yarshshuu aadhdhiiyee? Woy yarshshuwaa geeshsha oothiyaa A yarshshiyaabay aadhdhii? ");
INSERT INTO dwrNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hewaa diraw, yarshshuwaa yarshshiyaaban caaqqiya uray he yarshshiyaawaanikka caaqqee; qassi A bolla de7iya ubbabankka caaqqee. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Geeshsha Golliyan caaqqiya uray, he Geeshsha Golliyaninne A giddon de7iya Xoossaan caaqqee. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Saluwan caaqqiya uray, Xoossaa kawutethaa oydiyaaninne he oydiyaan uttiyaawan caaqqee. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Lo77a malatiyaa iitatoo, higgiya tamaarissiyaawanttoonne Parisaawatoo, hinttenttoo aayyero. Ayissi gooppe, karethaa anuugaappe, shillaariyaappenne okashiyaappe asirataa hinttenttu immiita; shin higgiyan de7iya darii koshshiyaawantta aggiita; hewanttu pirddaa, maarotethaanne xillotethaa. Haranttakka aggennaan, hinttenttu oothanaw bessiyaa yewatuu hawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hinttenttoo qooqi uttiide, asaa kaalethiyaawanttoo, hinttenttu ushshaappe udunxxiyaa gacciide, gaaluwaa mittiita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Lo77a malatiyaa iitatoo, higgiya tamaarissiyaawanttoonne Parisaawatoo, hinttenttoo aayyero. Ayissi gooppe, hinttenttu shaataanne keriyaa bolla baggaa geeshshiita; shin A gidduwan bonqqiyaaninne uuzetethaan kuntheeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ha qooqa Parisaawew, shaataanne keriyaa garssaa kasetaade geeshsha digga; hewaappe guyyiyan, bolla baggaykka geeshsha gidanawa. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Lo77a malatiyaa iitatoo, higgiya tamaarissiyaawanttoonne Parisaawatoo, hinttenttoo aayyero. Ayissi gooppe, kare bagganna booshinchchaan okettiide, lo77i uttiide, qassi garssa bagganna hayqqeedda asaa meqethaynne wooqqeeddabay ubbabay kumeedda duufotuwa malatiita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hewaadankka, qassi bolla bagganna asaa ubbaw xilluwaa malatiita; shin hinttenttoo garssa bagganna lo77a malatiyaa iitatethaynne makkalay kumi utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Lo77a malatiyaa iitatoo, higgiya tamaarissiyaawanttoonne Parisaawatoo, hinttenttoo aayyero. Ayissi gooppe, nabatuwaa duufuwaa bolla golliyaa keexxiita; qassi xillatuwaa duufuwaakka loythiita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Qassi hinttenttu, ‘Nuuni beni nu aawotuwa wode de7eeddawantta gidintto, unttunttunna ittippe nabatuwaa wodhokko shin’ yaagiita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hewaa gidooppe, nabatuwaa wodheeddawanttu naanaa hinttenttu gideeddawaa hinttenttu huuphiyaan markkattiita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Simmi hinttenttu aawotuu doommeeddawaa polikkitee! ");
INSERT INTO dwrNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ha shooshshatoo, shooshshaa naanaw, Gaannamiyaa pirddaappe waaniide attanitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hewaa diraw, beyte, taani nabatuwaa aadho eranchchatuwaanne higgiya tamaarissiyaawantta hinttekko kiittana. Unttunttuppe ittuwa ittuwa hinttenttu wodhananne masqqaliyaa bolla misimaariyan dhishiide kaqqanita; qassi ittuwa ittuwa hinttenttu woosa golletun lissuwan shocanitanne katamaappe katamaa yederssanita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hewaa diraw, xilluwaa Aabeela wodhoodeppe doommiide, Geeshsha Golliyaappenne yarshshiyaasaappe gidduwan hinttenttu wodheedda Baraakiyya na7aa Zakkaraasa wodiyaa gakkanaw, hayqqeedda xillatuwa ubbatuwaa suuthaa diraw, hinttenttu murettanita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Taani hinttenttoo tumuwaa oday; ha ubbabay ha wodiyaa asaa bolla gakkanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yeerusalaame katamaa asaw, Yeerusalaame katamaa asaw, nabatuwaa hinttenttu wodhiita; Xoossay hinttenttukko kiitteeddawanttakka shuchchan caddiita; kuttatta bare maratuwaa bare qefiyan haphphiyaawaadan, taani hinttenttu asaa ittisaa shiishshanaw aappu kaalla koyyaaddita! Shin taana diggeeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Be7ite, hinttenttu gollii ubbakka ona gidanawa. ");
INSERT INTO dwrNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ayissi gooppe, taani hinttenttoo oday; hinttenttu, ‘Godaa sunthaan yiyaawe anjjetteeddawaa gaana gakkanaw, laa7enthuwaa taana be7ikkita’ gay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuusi Geeshsha Golliyaappe kesiide biya wode, Geeshsha Golliyaa dirssaa giddon de7iya golliya bessanaw A kaalliyawanttu aakko yeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesuusi zaariide unttuntta, “Hewaa ubbaa be7iite? Taani hinttenttoo tumuwaa oday; ha golletuwan de7iya itti shuchchaynne attennaan ubbay kolettana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuusi Debre Zayte geetettiyaa deriyaa bollan uttide7ishshin, A kaalliyawanttu barenttu xalalaa aakko yiide A, “Hewe awude hananentto, nuussi odaarikkii; qassi ne yuussawunne wodiyaa wursethaw mallay ayaa gidanee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesuusi zaariide, unttuntta hawaadan yaageedda; “Hinttentta ooninne balethenna mala naagettite. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ayissi gooppe, daro asay ta sunthaan, ‘Taani Kiristtoosa’ yaagiidde yaana; yaatiide daro asaa balethana. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Matan de7iya olaa waasuwanne haakuwan de7iya olaa oduwaa sisanaw hinttenttu de7iita; hewaa malabay hananaw bessiyaa diraw, naagettite; hirggoppite; shin wursethay bira. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ayissi gooppe, itti gadiya asay hara gadiya asaanna olettana; qassi itti kawutethay hara kawutethaanna olettana; koshaynne biittaa qaathay ubbasan de7anawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hewe ubbaykka koyro oythaa mala. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Asay he wode hinttentta wayyissananne wodhanawaa; ta sunthaa diraw, gade ubbay hinttentta ixxanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","He wode cora asay ammanuwaa agganawantta; barenttu giddon ittuu ittuwa aathiide immananne ittuu ittuwa ixxanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Qassi worddo nabatuu coratuu denddiide, daro asaa cimmanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Makkalay dariya diraw, cora asaa siiquu irxxanawa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Shin wurssethay gakkanaw gencciyaa uray attanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Asaw ubbaw markka gidana mala, kawutethaa wonggalaa mishiraachchuu sa7aa ubbaan odettanawaa; hewaappe guyyiyan, wursethay gakkanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Hewaa diraw, nabiyaa Daaneel odeedda bashshaa tunatethay geeshsha saan eqqeeddawaa hinttenttu be7ana; hewe waagiyaawentto, nabbabiyaawe akeeko. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Yihudaa gadiyan he wode de7iyaawanttu deriyaakko kesino. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Golliyaa huuphiyan de7iya uraykka bare soyin de7iyaawaa akkanaw wodhdhoppo. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gaden de7iyaawe bare mayuwaa akkanaw guyye simmoppo. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","He wode shahaara maccawanttussinne dhanthiyaa maccawanttussi aayyero. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Balgguwan woy Sambbataan hinttenttu betenna mala, Xoossaa woossite; ");
INSERT INTO dwrNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ayaw gooppe, alamii medhettoodeppe hachche gakkanaw de7ibeennabaynne qassi hawaappe sinthawukka ubba de7enna iita waayyii he wode de7anawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Xoossay he gallassatuwaa payduwaa guuthiyaawe baawentto, asaa gideedda ooninne attenna; shin I bare dooreedda asatuwa diraw, he gallassatuwaa payduwaa guuthanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“He wode ooninne hinttentta, ‘Be7ite. Kiristtoosi hawaan de7ee’ woy, ‘Hewaan de7ee’ yaagooppe awaa ammanoppite. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ayissi gooppe, worddo Kiristtoosatuunne worddo nabatuu denddana; yaatiide barenttoo danddayettooppe, haray atto Xoossay dooreeddawanttakka balethanaw wolqqaama malaataanne maalalissiyaabaa bessanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Be7ite, taani hinttew hewaa kasetaade odaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Hewaa diraw, asay hinttentta, ‘Be7ite, Kiristtoosi bazzuwan de7ee’ gooppe, yaa booppite; woy hinttentta, ‘Be7ite, qol77on de7ee’ ginttokka, unttunttubaa ammanoppite. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ayissi gooppe, walqqanthay awayfi doliyaa baggappe walqqammiide, awayfi wulliyaa bagga gakkanaw pholqqugiyaawaadan, ta yuussay, Asaa Na7aa yuussay, hewaadan hananawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Bakutay de7iyaasaa shorttii shiiqana. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“He wode waayyiyaappe guyyiyan, man77iyan away dhumaana; agenay poo7iyaawaa agganawaa; xoolinttatuu saluwaappe kunddanawantta; qassi saluwan de7iya wolqqatuukka qaaxettanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","He wode ta mallay, Asa Na7aa mallay, saluwan beettanawaa; sa7an he wode de7iya asaa zarii ubbay yeekkanawantta. Qassi taani, Asaa Na7ay, wolqqaannanne wolqqaama bonchchuwaanna saluwaappe shaariyaa giddonna yiishshin, unttunttu be7ana. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","I bare kiitanchchatuwa wolqqaama malakataanna kiittana; kiitanchchatuu alamew ha gaxaappe ya gaxaa gakkanaw, qassi sa7aan oyddu baggappe aw dooretteedda asaa shiishshanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Leemisuwaa balasatto geetettiyaa mithattippe akeekite; balasatta aaciya wodenne izi haythay qolettiyaa wode, bonii mateeddawaa hinttenttu eranita. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hewaadankka, hinttenttu he ubbabaa be7iyaa wode, I matiide penggiyaa shiiqeeddawaa erite. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Taani hinttenttoo tumuwaa oday; ha ubbabay hanana gakkanaw, ha wodiyaa asay hayqqidiggenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Saluunne sa7ay aadhdhana; shin ta qaalay ubbakka aadhdhenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Shin he gallassaanne he saatiyaa Aawuwaa xalalaappe attin, haray atto saluwan de7iya kiitanchchatuwa gidina, woy taana Na7aa gidinakka ooninne eriyaawe baawa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ta yuussay, Asaa Na7aa yuussay, Nohe wode hanowaa mala gidanawa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ayissi gooppe, bashshaa haathaa yuussaappe kase wode, Nohe markkabiyaan geleedda gallassay gakkanaw, asay meenne usheenne; qassi attuma asay akkeenne macca asay asinaa gelee. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bashshaa haathay yiide, unttuntta ubbaa afana gakkanaw, unttunttu akeeki beykkino; taani, Asa Na7ay, yiyaa wodii, hewaa mala gidanawa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“He wode laa77u asatuu gaden oothiyaawanttuppe ittuwa afana; ittuu attanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Laa77u maccawanttu woxaan gaacciyaawanttuppe ittinno afana; ittinna attana. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Simmi hintte Goday ay gallassi yaanawentto hinttenttu erenna diraw, naagi uttite. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Shin kayisuu qammaappe woysa wodiyaan yaanentto golliya goday ereeddentto, bare gollii bookettenna mala, beegottiide naagi uttanawaa erite. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hewaa diraw, hinttenttukka giigi uttite; ayaw gooppe, taani, Asaa Na7ay, hinttenttu qoppenna saatiyaan yaana. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Yaatina, bare soy asaw qumaa koshshiyaa wodiyaan immana mala, A goday suntheedda ammanetteedda wozanaama qoomay oonee? ");
INSERT INTO dwrNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","I hewaadan oothishshin, A goday yiide demmiyaa qoomay anjjetteeddaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Taani hinttenttoo tumuwaa oday; goday he qoomaa barewaa ubbaa bolla sunthana. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Shin qoomay iita gidooppe, ‘Ta goday gami77iide yaanawaa’ yaagiide bare wozanaan qoppiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bare laggethaa qoomatuwaa wadhaa doommooppe, mathottiyaawanttunna mooppenne ushooppe, ");
INSERT INTO dwrNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","he qoomaa goday I qoppibeenna gallassaaninne I eribeenna saatiyaan yaana. ");
INSERT INTO dwrNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hewaappe guyyiyan A qanxxereethiide, lo77a malatiyaa iita asatuu de7iyaasaan wothana; hewaan I yeekkananne achchaa dhaqana. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“He wode saluwaa kawutethay barenttu kuraaziyaa oyqqiide, machchatto akkiyawaa mokkanaw kare keseedda tammu wodoratuwaa malatana. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Unttunttuppe ichcheshatuu boozatuwaa; qassi ichcheshatuu cincca. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Boozatuu barenttu kuraaziyaa oyqqeeddino; shin lambbaa oyqqibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Shin cinccatuu barenttu kuraaziyaanne xaarumusiyan lambbaa oyqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Machchatto akkiyawe yeennaan gami77ina, he wodoratuu barentta gemi77ishissina gisii aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Bilahe gideedda wode, ‘Be7ite, machchatto akkiyawe gakkeedda; A mokkanaw kare kesite’ yaagiyaa wolqqaama cabbuu denddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“He wode he wodoratuu ubbatuu beegottiide, barenttu kuraaziyaa giigisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Boozatuu cinccatuwaa, ‘Nu kuraazi to7ana haniyaa diraw, hinttenttu lambbaappe nuussi immeerikkitee’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Shin cinccatuu zaariide unttuntta, ‘Aggite, nuussinne hinttenttussi gidenna; hewaa dira hinttew zali77iyaawanttukko biide shammi akkite’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hewaappe guyye booza wodoratuu lambbaa shammanaw bidiggina, machchatto akkiyawe puttu giina, giigi utteedda ichcheshu wodoratuu aananna ittippe bullachchaa golliyaa geleeddino; ipithaykka gorddetti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Guyyeppe qassi yokko wodoratuu yiide, ‘Godaw, godaw, nuussi dooyyaarikkii’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Shin machchatto akkiyawe zaariide, ‘Taani hinttenttoo tumuwaa oday; taani hinttentta erikke’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Simmi taani, Asaa Na7ay, yaana gallassaa woy saatiyaa hinttenttu erenna diraw, naagi uttite. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ayissi gooppe, saluwaa kawutethay bare qoomatuwaa xeesiide, barew de7iyaawaa unttunttoo sheedhdhiide, ogiyaa baana haniyaa bitaniyaa bessee. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Unttunttu huuphiyan huuphiyan unttunttu wolqqaa keenaa ittoo ichcheshu sha77a biraa, ittoo laa77u sha77a biraa, qassi ittoo itti sha77a biraa immiide, bare ogiyaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ichcheshu sha77a biraa akkeedda qoomay ellekka biide zali77iide, hara ichcheshu sha77a biraa wodhisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hewaadankka, qassi laa77u sha77a biraa akkeedda qoomay hara laa77u sha77a biraa wodhisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Shin itti sha77a biraa akkeeddawe biide, ollaa bookkiide, bare godaa miishshaa moogi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Daro wodiyaappe guyyiyan, he qomatuwaa goday yiide, bare miishshaa unttunttunna heetetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ichcheshu sha77a biraa akkeedda qoomay yiide, hara ichcheshu sha77a biraa sheedhdhiidde, ‘Ta godaw, neeni taw ichcheshu sha77a biraa immaadda; be7a, hara ichcheshu sha77a biraa wodhissaaddi’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A goday A, ‘Hayyanaashsho! Neeni lo77anne ammanettiya qoomaa; neeni guuthaban ammanettaadda. Taani neena darobaw kaappo oothana; haa gelaade ne godaanna nashetta’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Qassi laa77u sha77a biraa akkeeddawekka yiide, ‘Ta godaw, neeni taw laa77u sha77a biraa immaadda; be7a, taani hara laa77u sha77a biraa wodhissaaddi’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A goday A, ‘Hayyanaashsho! Neeni lo77anne ammanettiyaa qoomaa; neeni guuthaban ammanettaadda. Taani neena darobaw kaappo oothana; haa gelaade ne godaanna nashetta’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Itti sha77a biraa akkeeddawe qassi yiide, ‘Ta godaw, neeni zerabeennasaappe qoyciyaa asa gidiyaawaanne kathaa laalabeennasaappe maxiyaa meqethi baynna asa gidiyaawaa taani eray. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Taani yayyaaddi; yaataade baade ne biraa biittaan moogaaddi; be7a, ne biray haweku’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“A goday zaariide, A hawadaan yaageedda; ‘Ha iita azalla ashikkarew, taani zerabeennasaappe qoyciyaa asa gidiyaawaanne kathaa laalabeennasaappe maxiyaa asa gidiyaawaa eraaddii? ");
INSERT INTO dwrNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yaatina, neeni ta miishshaa wodhissiyaawanttu matan wotheeddawaa gidintto, taani simmiyaa wode ta miishshaa wodhiyaanna akkanawaashshin atteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hewaa diraw, he miishshaa aappe wothi akkiide, tammu sha77a biray de7iyaawoo immite. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ayissi gooppe, de7iya ubbaw haray gujettana; I barew gidiyaawaappe darissiide akkana; shin baynnawoo haray atto, he aw de7iya guuthaykka aappe akettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Go77enna qoomaa kare dhumaa kessi olite; hewaan I yeekkananne bare achchaa dhaqana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Taani, Asaa Na7ay, kiitanchchatuwa ubbatuwanna bonchchuwan yiyaa wode, ta bonchcho kawutethaa oydiyaan uttana. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sa7aan de7iya asay ubbay ta sintha shiiqanawantta; heemmiyaawe dorssatuwaa deeshshatuwaappe shaakkiyawaadan, taani he asaa laa77u kessaade shaakkana. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Qassi dorssatuwaa taappe ushechcha bagganna essaade, deeshshatuwaa taappe haddirssa bagganna essana. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Hewaappe guyyiyan, taani kaatii taappe ushechcha bagganna de7iyaawantta hawaadan yaagana; ‘Ta Aabbu anjjeeddawantto, haa yiide sa7ay medhettoodeppe hachche gakkanaw, hinttenttoo giigeedda kawutethaa laattite. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ayissi gooppe, taani koshattina mizeeddita; saamettina ushsheeddita; imatha gidaade biinakka mokkeeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Taani kallottina mayizzeeddita; harggina be7eeddita; qashettina taakko gakkiide oochcheeddita’ yaagana. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Hewaappe guyyiyan, xillatuu zaariide, A hawaadan yaagana; ‘Godaw, neeni koshattina, awude be7iide mizeeddoo? Woy neeni saamettina, awude be7iide ushsheeddoo? ");
INSERT INTO dwrNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Neeni imatha gidaade yiina awude be7iide mokkeeddoo? Woy neeni kallottina awude mayizzeeddo? ");
INSERT INTO dwrNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Qassi neeni harggina, woy qashettina neekko biide awude neena be7eeddoo?’ yaaganawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Taani kaatii zaaraade, ‘Taani hinttenttoo tumuwaa oday; hinttenttu ha ta ishatuwaa ubbaappe haray atto, laafiyaa ittoo ootheeddawaa gidinttokka, hewaa taw ootheeddita’ yaagana. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“He wode, taappe haddirssa bagganna de7iyaawantta taani yaagana; ‘Ha sheqetteeddawanttoo, ta matappe kichchite; biide xalahiyaa kaappoonne A kiitanchchatuwaassi giigeedda medhinaa tamaan gelite. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ayissi gooppe, taani koshattina, taana mizibeykkita; saamettina ushshibeykkita. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Taani imatha gidaade biina, taana mokkibeykkita; kallottina mayizzibeykkita; qassi harggina, qashettinakka taana be7ibeykkita’ yaagana. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“He wode unttunttu qassi hawaadan yaagiide zaaranawantta; ‘Godaw, neeni koshattina woy saamettina, woy imatha gidaade biina woy kallottina, woy harggina woy qashettina, awude be7iide, neena maaddennaan ixxeeddoo?’ yaaganawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“He wode taani kaatii zaaraade unttuntta, ‘Taani hinttenttoo tumuwaa oday; hinttenttu ha ubbaappe laafiyaa ittuwa maaddennaan ixxeeddawee, taana maaddennaan ixxeeddawaa’ yaagana. ");
INSERT INTO dwrNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hewanttu medhinaa muraw baana; shin xillatuu medhinaa de7oo baana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuusi ha timirttiyaa ubbaa wurisseedda wode, barena kaalliyaawantta, ");
INSERT INTO dwrNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Laa77u gallassaappe guyyiyan, Paasigaa Baalaa bonchchiya gallassa gidiyaawaa eriita. He gallassi Taana, Asa Na7aa, asay masqqaliyaa bolla misimaariyan dhishiide kaqqanaw aathiide immana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","He wode qeesatuwaa kaappatuunne gadiyaa cimatuu Qayaafaa geetettiyaa qeesatuwaa ubbatuwaa kaappuwaa wogga golliyan shiiqiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","asay erennaan Yesuusa oyqqiide, wodhanaw maqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Shin unttunttu, “Asay walassaa kessenna mala, Paasigaa bonchchiyaa gallassi hewaa oothokko” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuusi Biitaaniyaa katamaan oolluwaa harggiyaa Simoona soyin de7ishshin, ");
INSERT INTO dwrNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","itti mishiratta albbasxxiroosa geetettiyaa shuchchaappe oosetteedda bilqqaasiyaa kumeedda darii al77o shittuwaa akkaade yeeddawunna qumaa I miina, he shittuwaa Yesuusa huuphiyan caccafaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Shin Yesuusa kaalliyawanttu hewaa be7iide, “Ha shittuwaa coo bayizzussay ayaassee? ");
INSERT INTO dwrNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ayissi gooppe, ha shittuwaa al77o gatiyaan zali77iide, miishshaa hiyyeesaw immanaw danddayettee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesuusi unttunttu giyaawaa eriide, unttuntta hawaadan yaageedda; “Ha mishiratto ayaw waayyissiitee? Iza taw lo77obaa oothaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hiyyeesatuu ubba wode hinttenanna de7iino; shin taani hinttenanna ubba wode de7ikke; ");
INSERT INTO dwrNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iza ha shittuwaa ta bolla tigiyaawe taana mooganaw giigissanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Taani hinttenttoo tumuwaa oday; sa7aa ubbaan ha wonggalaa mishiraachchuwaa odiyaasan haqaninne, asay izo wozanaa aathana mala, iza ootheeddawe odettanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","He wode tammanne laa77u Yesuusa kaalliyaawanttuppe ittuu Yihudaa Asqqorootu yaagettiyaawe qeesatuwaa kaappatuwakko ");
INSERT INTO dwrNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","biide, “Taani hinttenttussi Yesuusa oythooppe, taw ayaa immanitee?” yaagina unttunttu aw hattamu biraa qoppiide immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hewaappe guyyiyan, Yihuday Yesuusa aathi immanaw injjetiyaa wodiyaa wochchee. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Baalaa daabbuwaa miyaa gallassaa bonchchiya koyro gallassi, Yesuusa kaalliyawanttu aakko yiide, “Paasigaa bonchchiya gallassi neeni maana qumaa haqan giigissanee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hewaappe guyye Yesuusi unttuntta, “Katamaa biide, itti bitaniyaa, ‘Tamaarissiyaawe neena, “Taw wodii gakkeedda; taani taana kaalliyawanttunna Paasigaa bonchchiya gallassaa ne soyin aathana” geedda’ giite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A kaalliyawanttu Yesuusi barentta azazowaadan oothiide, Paasigaa bonchchiya gallassi maana qumaa giigisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sa7ay omarsseedda wode, Yesuusi tammanne laa77u A kaalliyaawanttunna qumaa maanaw utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Unttunttu miishshin, Yesuusi unttuntta, “Taani hinttenttoo tumuwaa oday; hintteppe itti uray taana aathiide immanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Unttunttu darii dagammiide, huuphiyan huuphiyan, “Godaw, tumu taaneeshsha?” guussaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesuusi zaariide, “Bare kushiyaa taananna ittippe wociitiyaappe yeddiide tushiyaawe taana aathi immana. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Taani, Asaa Na7ay, Xoossaa Maxaafay hayqqana geeddawaadan hayqqana; shin Taana, Asaa Na7aa, aathi immiya uraw aayyero; he uray yelettennaan atteeddentto aw lo77ashshin” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A aathi immiyaa Yihuday zaariide, “Tamaarissiyaawoo, neeni giyaawe tanee?” yaageedda. Yesuusi zaariide A, “Neeni ne huuphiyaan gaadda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Unttunttu miishshin, Yesuusi daabbuwaa akkiide, Xoossaa galateedda; he daabbuwaa menthereethiide, barena kaalliyaawanttussi immiidde, “Heyte; miite; hawe ta ashuwaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Xuu7aa akkiide, Xoossaa galateedda. Unttunttoo immiidde, “Ubbay hawaappe ushite; ");
INSERT INTO dwrNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ayaw gooppe, hawe daro asaa nagaray atto geetettana diraw gukkiyaa ta suuthaa; ta suuthay ooratha caaquwaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Shin taani hinttenttoo oday; taani ta Aabbu kawutethaan ooratha woyiniyaa eessaa hinttenttunna ushana gallassay gakkanaw, laa7ethuwaa ha woyiniyaa eessaa ubbakka ushikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mazimuriyaa yexxowaappe guyyiyan, Debre Zayte geetettiyaa deriyaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesuusi he wode unttuntta, “Hachche qamma hinttenttu ubbay taana aggiide kichchana; ayaw gooppe, Xoossaa Maxaafay, ‘Xoossay dorssaa heemmiyaawaa wodhanawaa; hewaappe guyyiyan dorssaa wudii laalettanawaa’ yaagee. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Shin taani hayquwaappe denddowaappe guyyiyan, hintteppe kasetaade Galiilaa baana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Phexiroosi zaariide, “Unttunttu ubbatuu neena aggiide kichchanawantta; taani neena ubbakka yeggaade kichchikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesuusi Phexiroosa, “Taani new tumuwaa oday; hachche qamma kuttuu waassanaappe kase, neeni taana heezzu kaalla kaadanaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Phexiroosi zaariide, “Taani haray atto, neenanna ittippe hayqqinttokka, neena ubbakka kaddikke” yaageedda. Qassi Yesuusa kaalliyawanttu ubbatuukka hewaadan geeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesuusi he wode barena kaalliyawanttunna Geetesemaaniyaa geetettiyaasaa biide unttuntta, “Taani hini baade Xoossaa woossishshin, hinttenttu hawaan uttiishshite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hewaappe guyye Phexiroosanne Zabiddiyoosa naanaa laa77uwaa barenanna afiide, daro kayyuwaanne ugaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Qassi unttuntta, “Taani hayqqana gakkanaassikka kayyottay; hawaan beegottiide, taananna naagite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Laafaa sinthakko shiiqiide, sa7aan guufanniide, “Ta Aabboo, danddayettiyaawaa gidooppe, ha xuu7aa taappe digga; shin neeni koyyiyaawadan hanoppe attin, taani koyyiyaawadan hanoppo” yaagiide Xoossaa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesuusi barena kaalliyaawanttukko simmiide yeedda; gemi77ishowantta demmiide Phexiroosa, “Hinttenttu itti saatenttonneekka gemi77ishennaan taananna naaganaw danddayibeykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Paaciyaan hinttenttu gelenna mala, minnittenne Xoossaa woossite; ayyaanay giigi utteedda; shin asatethaa eeshshay daaburanchchaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesuusi qassi laa7enthuwaa biide, “Ta Aabboo, taani ha woliqqaama metuwaa akkennaan de7ishshin xuu7aa denthanaw danddayettenawaa gidooppe, neeni giyaawe hano” yaagiide Xoossaa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Qassikka simmi yiide, A kaalliyaawanttu ayfiyaa gemi77ishuu goozzi wotheedda diraw, gemi77ishowantta demmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Qassikka unttuntta yeggi biide, hezenthuwaa kase qaalaa zaariide, Xoossaa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hewaappe guyyiyan, barena kaalliyaawanttoo yiide, “Ha77i gakkanawukka gemi77ishiiteenne shemppiitee? Be7ite, Taana, Asaa Na7aa, nagaranchcha asatuwassi aathiide immiya wodii gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Denddina boytte; be7ite, taana aathi immiyaawe haweku gakkeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuusi hewaa biro haasayishshin, tammanne laa77u A kaalliyaawanttuppe ittuu, Yihuday, gakki wodhdheedda; qassi qeesatuwaa kaappatuunne gadiyaa cimatuu kiittina, mashshaanne xam77aa oyqqeedda cora asay aananna ittippe yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesuusa aathi immiyaawe he cora asaa, “Taani yeriyaawe A; A oyqqite” yaagiide mallaa odi wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ellekka Yesuusakko shiiqiide, “Tamaarissiyaawoo, saro de7ay” yaagiide A yeri akkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesuusi Yihudaa, “Ta laggew, neeni oothanabaa ootha agga” yaageedda. Hewaappe guyyiyan, he cora asay shiiqiide, Yesuusa loythi oyqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesuusanna de7iyaawanttuppe ittuu bare mashshaa kessiide qeesatuwaa ubbatuwaa kaappuwaa qoomaa haythaa qanxxi oleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesuusi he wode A hawaadan yaageedda; “Ne mashshaa akkeeddasaani zaaraade wotha; ayaw gooppe, mashshaa denthiyaa ubbay mashshaan hayqqana. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ta Aabbu daro sha77a kiitanchchatuwa itti kuthaan yeddiide, taana maaddana mala, taani A woossanaw danddayiyaawaa erikkii? ");
INSERT INTO dwrNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yaatina, Xoossaa qaalay hawaadan hananaw bessee yaageeddawe waaniide polettanaw danddayii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hewaappe guyyiyan, Yesuusi hewaan shiiqeedda cora asaa hawaadan yaageedda; “Taana kayiso kessiide, kayisuwaa oyqqiyaawaadan oyqqanaw mashshaanne xam77aa oyqqiide yeedditee? Taani Geeshsha Golliyan tamaarissaadde, gallassan gallassan hinttenttunna oothiyaa wode taana oyqqibeykkita; ");
INSERT INTO dwrNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","shin hawe ubbay haneeddawe nabatuu Xoossaa qaalaan xaafeeddawe polettanaassa” yaageedda. Yesuusa kaalliyawanttu he wode ubbatuu A yeggi beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesuusa oyqqeeddawanttu qeesatuwaa ubbatuwaa kaappuwaa Qayaafaakko, higgiya tamaarissiyaawanttunne cimatuu shiiqeeddasaa aakkiide beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Shin Phexiroosi qeesatuwaa ubbatuwaa kaappuwaa dirssaa giddo gakkanaw, haakuwan A kaalleedda; yewuwaa wurssethaa be7anaw dirssaa giddo geliide, naagiyaawanttunna utti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Qeesatuwaa kaappatuunne shiiqeedda asay ubbay Yesuusa wodhanaw A bolla wordduwaa markkaa demmanaw koyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Shin haray atto cora asay yiide, A bolla wordduwaan markkattinakka aappe aynne demmibeykkino. Guyyeppe laa77atuu yiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ha bitani, ‘Taani Xoossaa Geeshsha Golliyaa kolaade, heezzu gallassaan zaaraade keexxanaw danddayay’ geedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Qeesatuwaa ubbatuwaa kaappuu denddi eqqiide Yesuusa, “Hawanttu neena mootiyaa mootoo new zaariyaabay baawee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Shin Yesuusi co77u geedda; qassikka qeesatuwaa ubbatuwaa kaappuu A, “Taani neena de7uwa Xoossaa sunthaan callay; neeni Xoossaa Na7aa Kiristtoosa gidooppe nuussi oda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesuusi zaariide, “Neeni ne huuphewukka gaadda; shin taani hinttenttussi oday; hawaappe sinthaan, hinttenttu taana, Asaa Na7aa, wolqqaama Xoossaappe ushechcha bagganna utteeddawaanne saluwaa shaariyaanna yiishshin be7ana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hewaappe guyyiyan, qeesatuwaa ubbatuwaa kaappuu bare mayuwaa pheedhi oliide, “Hawe boreedda; nuuna hawaappe sinthan ayaw hara markkaa koshshii? I ha77i boriyaawaa hinttenttu siseeddita. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hinttenttu qofay ayee?” yaageedda. Unttenttu, “Aw hayquu bessee” yaagiide zaareeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hewaappe guyyiyan, unttunttu A deemuwaan cuchchiide, A dechcheeddino; haranttu qassi A baqqiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Kiristtoosaa! Neen neena nabe gaasashshin, neena shoceeddawe oonentto ane nuussi oda!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Phexiroosi golliyaappe karenna dirssaa giddon uttide7ishshin, itti ashikkaratta aakko yaade, “Neenikka Galiilaa Yesuusanna ittippe de7aa” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Shin I unttunttu ubbaa sinthaan he ashikkaratto, “Neeni giyaawe ayentto taani erikke” yaagiide kaadeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Qassi biide dirssaa penggiyaakko kesishshin, hara ashikkaratta A be7aade, hewaan de7iya asatuwassi, “Ha bitani Naazireetiyaa Yesuusanna de7ee” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Phexiroosi laa7enthuwaa caaqqiidde, “Taani hewaa bitaniyaa erikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Laafaa gami77ishshin, hewaan eqqeedda asay Phexiroosakko yiide, “Neenikka tuma unttunttunna ittippe de7aa; ayaw gooppe, neeni haasayiyaa haasayaykka neena erissee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hewaappe guyyiyan Phexiroosi, “Taani hewaa bitaniyaa erikke!” yaagiide, barena sheqaanne caaquwaa doommeedda. He wode ellekka kuttuu waassi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Phexiroosi barena Yesuusi, “Neeni kuttuu waassanaappe kase heezzu kaalla taana kaadanaassa” geeddawaa hassayiide, kare kesiide, seeletti yeekkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wontta guuraan qeesatuwaa kaappatuu ubbatuunne gadiyaa cimatuu Yesuusa wodhanaw maqqetteeddino; ");
INSERT INTO dwrNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","unttunttu Yesuusa qachchi afiide, gadiyaa ayissiyaa Philaaxoosaw aathi immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesuusa he wode oytheedda Yihuday Philaaxoosi Yesuusa bolla pirddeeddawaa be7iide, “Aayyeero! Oythennaan aggaarikkita!” yaagiide, he man77iyankka hattamu biraa qeesatuwaa kaappatoonne gadiyaa cimatoo guyye zaariide, ");
INSERT INTO dwrNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Taani geeshsha asaa oythaade nagaraa oothaaddi” yaageedda. Shin unttunttu A, “Hewe nuussi ayaa metee? Hewe ne shene” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yihuday biraa Geeshsha Golliyan oli aggeedda; unttunttu matappe biide, suletti hayqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Qeesatuwaa kaappatuu biraa akkiide, “Ha biray suuthaa miishshaa gidishshin, nuuni Geeshsha Golliyaa miishshaanna gathiyaawe woga gidenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hewaappe guyye ittippe zorettiide, imatha asaw moogo gadiya oothanaw urqqaappe miishshaa medhdhiyaawanttu gadiyaa shammeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hewaa diraw, he gadii hachche gakkanawukka, suuthaa gadiya geetettiide xeesettee. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nabiyaa Ermiyaasi, “Unttunttu aw immanaw qoppeedda hattamu shuchchaa biraa akkiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Goday taana azazowaadan, urqqaappe miishshaa medhdhiyaawanttu gadiya shammanaw immeeddino” geetettowe he wode poletteedda geedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesuusi gadiyaa ayissiyaawaa sintha shiiqina, gadiyaa ayissiyaawe A, “Neeni Ayihudatuwaa kaatee?” yaagiide oochcheedda. Yesuusi A, “Neenikka gade7aa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Qeesatuwaa kaappatuunne gadiyaa cimatuu A mootina, unttunttoo aynne zaaruwaa immibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","He wode, Philaaxoosi Yesuusa, “Hawanttu neena mootiyaabaa ubbaa sisikkii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesuusi haray atto, itti qaalaakka zaarennaan ixxina, gadiyaa ayissiyaawanttu darii maalaletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gadiyaa ayissiyaawe Paasigaa bonchchiya gallassaan, asay koyyiyaa itti uraa qashuwaappe billiyaa wogay de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","He wode itti Barbbaana geetettiyaa Yesuusi daro eretteedda iita bitani qasho gollen de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hewaa diraw, cora asay ittisaa shiiqeeddasaan Philaaxoosi, “Taani hinttenttoo Barbbaana giyaa Yesuusa billoo, woy Kiristtoosa geetettiyaa Yesuusa billoo?” yaagiide asaa oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ayissi gooppe, unttunttu qanaatiide Yesuusa ootheeddawaa I eree. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Philaaxoosi pirdda gollen uttide7ishshin, A machchatta aw, “He xillo bitaniyaa aynne oothoppa; ayaw gooppe, taani hachche qamma akumuwan aabaan daro metootaaddi” yaagaade kiittaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Shin qeesatuwaa kaappatuunne gadiyaa cimatuu Philaaxoosi Barbbaana billiide, Yesuusa wodhanaadan, shiiqeedda asay A woossana mala, asaa cimmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Philaaxoosi zaariide unttuntta, “Taani unttunttu laa77atuwaappe hinttew oona billanaadan koyyiitee?” yaagina unttunttu, “Barbbaana billanaadan koyyeetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Philaaxoosi, “Yaatina, Kiristtoosa geetettiyaa Yesuusa wootoo?” yaagiide unttuntta oochchina ubbay, “Masqqaliyaa bolla misimaariyan dhishettiide kaqetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Philaaxoosi asaa, “Ayissi? Ay iitabaa ootheeddee?” yaageedda. Shin asay kasewaappekka barenttu kooshshaa dhoqqu oothiide, “Masqqaliyaa bolla misimaariyan dhishettiide I kaqetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Walassay denddanawaappe attin, aynne hanennawaa Philaaxoosi be7iide, haathaa akkiide, “Ha bitani hayqqiyaawaan taani gelikke; hewaa hinttenttu erite” yaagiide shiiqeedda asaa sinthaan bare kushiyaa meecetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Shiiqeedda asay ubbay zaariide, “A suuthaa gomii nuunanne nu naanaa gakko” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hewaappe guyyiyan, Philaaxoosi Barbbaana unttunttoo billeedda; lissuwan Yesuusa shociide, masqqaliyaa bolla misimaariyan dhishiide kaqqanaw unttunttoo aathiide immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hewaappe guyyiyan, Philaaxoosa wottaaddaratuu Yesuusa gadiyaa ayissiyaawaa beeruwaa afina, wottaaddaratuu ubbay A miyyiyaan yuuyyi aadhdhiide eqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A mayuwaa qaari akkiide, zo7o mayuwaa A mayizzeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Qassi agunthaa akililiyaa giigissiide, A huuphiyan wotheeddino; A ushechcha kushiyan maqqaa xam77aa oythiide, A sinthan gulbbatiide, “Ayihudatuwaa kaatew, saro de7ay!” yaagiide, A bolla qilliicceeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A bolla cuchcheeddino; he maqqaa xam77aa akkiide, A huuphiyaa shoceeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Unttunttu A bolla qilliicceeddawaappe guyyiyan, zo7o mayuwaa aappe qaari akkiide, A mayuwaa A mayizzeeddino; qassi masqqaliyaa bolla misimaariyan dhishiide A kaqqanaw afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Unttunttu kare kesiide, itti Simoona geetettiyaa Qereena gade asaa demmiide, Yesuusa masqqaliyaa wolqqaan toosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golgootaa geetettiyaasaa gakkeeddino. “Golgootaa” yaagettiyaawe “Huuphiyaasaa” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hewaan unttunttu cammeedda woyiniyaa eessaa Yesuusaw ushanaw immeeddino; I hewaa ganxxi xeelliide, ushennaan ixxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Unttunttu masqqaliyaa bolla misimaariyan dhishiide A kaqqowaappe guyyiyan, A mayuwaa shaakkiide, saamaa yeggiide akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hewaappe guyyiyan, A naaganaw hewaan utti aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Qassi, “Hawe Ayihudatu Kaatiyaa Yesuusa” yaagiide mootuu xaafettowaa A huuphe bagganna wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yesuusanna he wode laa77u kayisatuwaa ittuwa aappe ushechcha bagganna, qassi ittuwa aappe haddirssa bagganna, masqqaliyaa bolla misimaariyan dhishiide kaqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ogiyaanna aadhdhiya asay Yesuusa kadhiide, barenttu huuphiyaa qaathiidde boreeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Geeshsha Golliyaa kolaade heezzu gallassa giddon keexxiyaawoo, ne huuphiyaa ashsha; neeni Xoossaa Na7aa gidooppe, ane masqqaliyaa bollappe wodhdha” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hewaadankka, qeesatuwaa kaappatuu higgiya tamaarissiyaawanttunnanne cimatuwaanna ittippe Yesuusa bolla qilliicciidde, hawaadan yaageeddino; ");
INSERT INTO dwrNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Harantta ashsheedda; shin barena ashshanaw danddayenna. I Isra7eeliya kaatiyaa; ane masqqaliyaa bollappe ha77i wodhdho; nuunikka qassi aani ammanana. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xoossaan I ammanettee; Xoossay A ashshanaw koyyooppe ane ashsho; ayaw gooppe, I barena, ‘Taani Xoossaa Na7aa’ gee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Qassi haray atto, aananna masqqaliyaa bolla misimaariyan dhishettiide kaqetteedda kayisatuukka hewaadan giide, A bolla qilliicceeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Usuppun saatiyaappe doommiide, udduppu saatiyaa gakkanaw, biittay ubbay dhumeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Udduppu saate gidiyaa heeran Yesuusi bare qaalaa dhoqqu oothiide, “Elohee, Elohee, laamaa sabaqitaanii?” yaageedda. Hewaa guussay, “Ta Xoossaw, ta Xoossaw, taana ayissi co77u gaaddi?” guussaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hewaan eqqeedda asaappe ittuu hewaa sisiide, “Ha bitani Eelaasa xeesee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","He man77iyankka unttunttuppe ittuu woxxiidde, ispponjjiyaa akkiide, caala woyiniyaa eessaa giddo yeggiide, hewaa maqqaa xam77aa xeeraan wothiide, ushshanaw A doonaakko shiishsheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Shin yokkonttu, “Ane de7ashsha, Eelaas A ashshanaw yaanawentto be7ana” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuusi laa7enthuwaa bare qaalaa dhoqqu oothi waassiide, hayqqi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Akeekite; Geeshsha Golliyan kaqetteedda gaariiduu qommoppe duge gakkanaw, laa77u kesiide, pooshetti wodhdheedda; sa7ay qaaxxeedda. Qassi zaallaykka phalqqetteedda; ");
INSERT INTO dwrNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","cora duufuu dooyetteedda. Xoossaa asaappe coratuu hayqqeeddawanttu, hayquwaappe denddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Unttunttu duufuwaappe kesiide, Yesuusi hayquwaappe denddowaappe guyyiyan, geeshsha katamaa beeddino; hewaan unttuntta cora asay be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Xeetuwaa kaappuunne aananna Yesuusa naagiyaa wottaaddaratuu sa7ay qaaxxiyaawaanne hewaan haneeddawaa ubbaa be7eedda wode daro yayyeeddino; yashshaa gaasuwaan, “Tumu hawe Xoossaa Na7aa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hewaan cora maccawanttu, Galiilaappe doommiide, Yesuusa maaddiidde kaalliyaawanttu, haakuwan eqqiide xeelliino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Unttunttu giddon Magdala geetettiyaa katamaappe yeedda Mayraama, Yayiqoobanne Yooseefo daaya Mayraamanne Zabiddiyoosa naanaa daaya de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sa7ay omarssiyaa wode, Yooseefa geetettiyaa itti dure bitani, Armmaatiyaasa katamaa bitani yeedda; I bare huuphewukka Yesuusa kaalliyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yooseefo Philaaxoosakko biide, Yesuusa anhaa akkanaw woosseedda; Philaaxoosi Yooseefoo imettana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yesuusa anhaa akkiide, geeshsha mooguwaa mayuwaan ");
INSERT INTO dwrNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","xaaxiide barew moogettanaw shuchchaa wooceedda ooratha gonggoluwaa giddon A anhaa wotheedda; qassi he gonggoluwaa doonan wogga shuchchaa gonddorssi wothiide, bashi beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdala katamaappe yeedda Mayraamanne yokko Mayraama hewaan gonggoluwaakko simmiide utteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sambbataassi giigettiyaa gallassaappe wonttetha gallassi, qeesatuwaa kaappatuunne Parisaawatuu Philaaxoosanna gakettiide, hawaadan yaageeddino; ");
INSERT INTO dwrNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Godaw, he wordduu paxa de7iya wode, ‘Taani heezzu gallassaappe guyyiyan, hayquwaappe denddana’ yaagowaa nuuni hassayeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hewaa diraw, A moogeedda gonggoluwaa heezzu gallassa gakkanaw, loythi naagana mala azazaarikkii; hewe dhayooppe A kaalliyaawanttu biide, A anhaa wuu77iide asaw, ‘Hayquwaappe denddeedda’ yaaganawantta; laa7enthiyaa balay kase balaappe ubba yaa iitana” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Philaaxoosi unttuntta, “Hinttenttoo naagiyaawanttu de7iino; biide hinttenttoo danddayettiyaa keenaa naagishshite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hewaappe guyye unttunttu biide, shuchchaa bolla maatafaa attamiide, qassi naagiyaawaa yaani wothiide, Yesuusa moogeedda gonggoluwaa naagisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sambbatay aadhdhina Woggaa gallassi wonttaa bakkaaliyan, Magdala geetettiyaa katamaappe yeedda Mayraamanne yokko Mayraama Yesuusi moogetteedda gonggoluwaa be7anaw beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Godaa kiitanchchay saluwaappe wodhdheedda diraw, sa7ay daro qaaxxeedda; he kiitanchchay yiide, shuchchaa gonddorssi oliide, A bolla kesi utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A malay walqqantha malatee; A mayuukka shachchaadan boothaa. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Naagiyaawanttu kiitanchchaw yashshaa kokkoriide, hayqqeedda asaadan haneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kiitanchchay maccawantta hawaadan yaageedda; “Yayyoppite; ayaw gooppe, masqqaliyaa bolla misimaariyan dhishiide kaqqeedda Yesuusa hinttenttu koyyiyaawaa taani eray. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I hawaan baawa; ayaw gooppe, I bare geeddawaadankka hayquwaappe denddi diggeedda; haa yiide, I moogetti gisosaa be7ite. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hinttenttu ha77i ellekka biide, Yesuusa kaalliyaawanttoo, ‘Yesuusi hayquwaappe denddi diggeedda. Qassi I hintteppe kasetiide, Galiilaa bee; hinttenttu A yaani be7ana’ yaagiide odite. Be7ite, taani hinttenttussi odaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Unttunttu yayyiiddinne qassi daro nashettiidde, Yesuusi moogetteedda gonggoluwaa matappe ellekka kichchiide, Yesuusa kaalliyaawanttoo odanaw woxxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","He man77iyankka Yesuusi unttunttunna gakettiide unttuntta, “Saro de7iitee” yaagi aggeedda; unttunttu aakko shiiqi A gediya oyqqiide, aw goyinneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesuusi he wode unttuntta, “Yayyoppite; ta ishatuu Galiilaa baana mala, biide unttunttoo odite; unttunttu taana yaani be7anawantta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","He maccawanttu biya wode, gonggoluwaa naagiyaa wottaaddaratuwaappe amareeddawanttu katamaa biide, haneeddawaa ubbaa qeesatuwaa kaappatoo odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Qeesatuwaa kaappatuu cimatuwanna ittippe shiiqi zorettiide, wottaaddaratoo daro miishshaa immiide, ");
INSERT INTO dwrNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ ‘Nuuni gemi77ishuwaan de7ishshin A kaalliyaawanttu qamma yiide, A anhaa wuu77eeddino’ yaagite. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ha yewuwaa gadiyaa ayissiyaawe sisooppe, nuuni aw odi ammanthana; qassi hinttentta aynne hirggissennaadan oothana” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wottaaddaratuu miishshaa akkiide, barenttoo odeeddawaadan ootheeddino. Ha yewuu Ayihudatuwaa mataan hachche gakkanaw, odettiidde de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","17","Shin tammanne itti A kaalliyaawanttu Yesuusi barentta biite geedda Galiilaa gadiyaa biide A be7eedda wode, aw goyinneeddino; shin unttunttuppe ittu ittu sidheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesuusi unttunttukko shiiqiide, unttuntta hawaadan yaageedda; “Maatay ubbay saluwaaninne sa7aan taw imetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hewaa diraw, hinttenttu biide, asaa ubbaa taana kaalliyawantta oothite; Aawuwaa sunthaan, Na7aa sunthaaninne Geeshsha Ayyaanaa sunthaan unttuntta xammaqite. ");
INSERT INTO dwrNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Taani hinttentta azazeeddabaa ubbaa unttunttu naagana mala, unttuntta tamaarissite; taani wodiyaa wursethay gakkanaassikka ubba wode hinttenttunna de7iyaawaa akeekite” yaageedda.");
INSERT INTO dwrNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Xoossaa Na7aa Yesuusi Kiristtoosa wonggalaa mishiraachchuwaa doomethaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nabiyaa Isiyaasi xaafeedda Maxaafan Xoossay, “Be7a; ta kiittiyaawaa taani neeppe sinthaw yeddana. I new ogiyaa kessanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Itti bitani biittaa bazzuwan bare kooshshaa dhoqqu oothiide, ‘Godaa ogiyaa giigissite. I hamettana loossuwakka aw suurissite’ geeddawaadan” haneedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Xammaqiyaa Yohaannisi asaa xammaqiiddinne, “Xoossay hintte nagaraa atto gaana mala, hinttenttu nagaraappe simmiide xammaqettite” yaagi qaalaa odiidde biittaa bazzuwan kesi wodhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yihudaa gadiyaan de7iyaa asay ubbaynne Yeerusalaame katamaa asay ubbay Yohaannisakko yeeddino. Barenttu nagaraakka paaxina, Yohaannisi he asaa Yorddaanoosa Shaafan xammaqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohaannisi gaaluwaa iskiyaappe dadetteedda mayuwaa mayyiide, bare xeessan dafuwaa dancceedda; qassi booliyaanne woraa eessaa meedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohaannisi qaalaa odiidde, “Taappe guyyenna daro minniyaawe yee; haray atto, A caammaakka gediyaappe kessa tookkanaw taani bessikke. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taani hinttentta haathaan xammaqay; shin I hinttentta Geeshsha Ayyaanan xammaqanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yesuusi he wode Galiilaa gadiyaan de7iyaa Naazireete katamaappe yiina, Yohaannisi Yorddaanoosa Shaafan A xammaqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesuusi haathaappe kesosaanna saluu dooyettishiinanne Geeshsha Ayyaanay bare bolla haraphphiyaadan wodhdhishshin be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Qassi saluwaappe, “Taani siiqiyaa ta Na7ay neena; taana nebay nashechchee” yaagiyaa qaalay sisetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ellekka Geeshsha Ayyaanay asay bayinna melasaa A yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesuusi asay bayinnasaani barena Seexaanay paaccishshin, oytamu gallassaa gatheedda; du7aannakka de7eedda; kiitanchchatuukka yiide, aw ootheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohaannisi qashettowaappe guyyiyan, Yesuusi Xoossaa kawutethaa wonggalaa mishiraachchuwaa odiidde, Galiilaa gadiyaa biide, ");
INSERT INTO dwrNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Wodii gakkeedda; Xoossaa kawutethaykka matatteedda. Hinttenttu nagaraappe simmiide, wonggalaa mishiraachchuwaa ammanite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesuusi Galiilaa Abbaa lanqqiyanna aadhdhiidde, moliyaa oyqqiyaawantta, Simoonanne A ishaa Inddiraasa, barenttu dabbaa abbaan yeggiyaawantta be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yaatiide unttuntta, “Taana kaallite; taani hinttentta moliyaa oyqqiyaawaadan asaa taakko ahiyaa ogiyaa tamaarissana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hewaappe guyyiyan unttunttu ellekka barenttu dabbaa aggiide, Yesuusa kaalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesuusi guuthaa sinthawukko biide, Zabiddiyoosa naanaa laa77u ishatuwaa, Yayiqoobanne Yohaannisa wonggiriyaa giddon barenttu dabbaa giigissiyaawantta be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","I be7osankka unttuntta xeesina, barenttu aawuwaa, Zabiddiyoosa, A oosanchchatuwanna wonggiriyaa giddon aggiide, Yesuusa kaalliide beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Unttunttu Qifirinaahooma geetettiyaa katamaa yiide geleeddino; Yesuusi Sambbata gallassay gakko wode, Ayihuda woosa golle geliide, tamaarissuwaa doommi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Barew maatay de7iyaa asaadan, asaa I tamarissiyaawaappe attin, higgiyaa tamaarissiyaawanttudan tamaarissenna diraw, asay A timirttiyaan maalaletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","He wode iita ayyaanay de7iyaa itti bitani Ayihuda woosa golle gelosaannakka bare kooshshaa dhoqqu oothiide, ");
INSERT INTO dwrNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Naazireetiyaa Yesuusaa, Neeni nuuppe ayaa koyyay? Nuuna dhayissanaw yaaddi? Neeni oonentto eray; neeni Xoossaappe kiitetteedda geeshshaa gidikkii!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesuusi he iita ayyaanaa, “Hayzza; bitaniyaappe kesa” yaagiide azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Iita ayyaanay bitaniyaa bucerethi, darii waasissiide, aappe kesii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Asay ubbay maalalettiide, “Hawe ayee? Ha bitani bare maataani haray atto, iita ayyaanatuwakka azazeedda; unttunttukka qassi aw azazettiino; hawe aybe ooratha timirttee?” yaagiide, bare giddon ittu ittuwaa oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Galiilaa gadiyaan de7iyaa heeray ubbay ellekka Yesuusa waariyaa siiseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesuusi Ayihuda woosa golliyaappe kesosaan, Yayiqoobannanne Yohaannisanna ittippe Simoonanne Inddiraasa soy bi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoona bollotatta qoxuwaa harggaade giseeddawunnibaa I yaa gakkosaannakka aw odi aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I izikko shiiqiide, izi kushiyaa oyqqiide, izo denthi esseedda; qoxuu izo aggina, iza unttunttoo oothaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Harggeedda asaa ubbaanne iita ayyaanatuu oyqqeedda asaa ubbaa omarssi away wulleeddawaappe guyyiyan, asay aakko aheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Katamaan de7iyaa asay ubbay he kariyaa shiiqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesuusi dumma dumma harggiyan oyqetteedda cora asaa pathiide, cora xalahatuwakka kesseedda. I Kiristtoosa gidiyaawaa iita ayyaanatuu ereedda diraw, unttuntta haasayissennaani diggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesuusi guura wonttumaathaani denddiide, soyippe kesiide, asay baynnasaa biide yaani Xoossaa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simooninne aananna de7iyaawanttu A koyyiidde beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Unttunttu A demmiide, “Asay ubbay neena koyyee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hewaappe guyye Yesuusi qassi unttuntta, “Hewaa heeran de7iyaa hara katamatuwaa boytte; taani hewaan qaalaa odanaw bessee; ayissi gooppe, taani yeeddawe hewaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayihuda woosa golletuwaan qaalaa odiiddinne iita ayyaanatuwaa kessiidde, Galiila gadiyaa ubbaa yuuyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Oolluu oyqqeedda itti bitani Yesuusakko yiide, A sinthan gulbbatiide, “Neeni koyyooppe, taana geeshsha pathanaw danddayaa” yaagiide woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesuusi aw qaretteedda; bare kushiyaa yeddi, A bochchiide, “Taani koyyay; geeyya; paxa!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ellekka oolluu bitaniyaa yeddi aggina, bitani geeyyi paxi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuusi darii hanqqettiide, ellekka A kessi yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","I bitaniyaa, “Neena era! Hawaa oossinne odoppa; shin baade ne bollaa qeesaa bessa; qassi neeni ha77i geeshsha gideeddawaa asaa erissanaw, Muse azazeedda yarshshuwaa yarshsha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Shin bitani biide, yewuwaa ubbasan asaa ubbaw oduwanne laalethaa doommeedda; hewaa diraw, Yesuusi qoncciyaa kesiide, katamaa gelanaw danddayibeenna; shin asay bayinnasaa gaxaan de7eedda; qassi asay ubbasaappe aakko yeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Amareedda gallassaappe guyyiyan, “Yesuusi Qifirinaahooma guyye simmiide, soyin de7ee” giyaa haasayay sisetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gollii akkennaan ixxina, haray atto, kariikka un77ana gakkanaassi cora asay shiiqeedda; hewanttussi Yesuusi qaalaa odee. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Oyddu asatuu bollay sileedda itti bitaniyaa tookkiide, aakko aheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Asay coreedda diraw, bitaniyaa Yesuusakko afanaw unttunttoo danddayettennan ixxina, Yesuusi de7iyaa bagganna golliya qaariide, kaaraa lukkeeddino; he lukkeeddasaanna bitaniyaa I giseedda shanchchamaanna duge wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesuusi unttunttu ammanuwaa be7iide, he bollay sileedda bitaniyaa, “Ta na7aw, ne nagaray atto geetetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Higgiyaa tamaarissiyaawanttuppe hewaan utteedda ittu ittu barenttu wozanaani, ");
INSERT INTO dwrNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Laa ha bitani hawaa mala iitabaa Xoossaa bolla ayissi haasayi? Xoossaa xalalaappe attin, haray oone nagaraa atto gaanaw danddayiyaawe?” yaagiide qoppeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Unttunttu barenttu wozanaan hewaadan qoppowaa Yesuusi ellekka bare ayyaanan eriide, unttuntta “Hinttenttu hintte wozanaan ayissi hewaadan qoppiitee? ");
INSERT INTO dwrNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bollay sileedda bitaniyaa, ‘Ne nagaray atto geetetteedda’ giyaawe mateeyee? Woy, ‘Dendda eqqaade ne shanchchamaa tookkaade hametta’ giyaawe matee? ");
INSERT INTO dwrNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Shin taani, Asaa Na7aw, sa7aa bollan nagaraa atto gaanaw maatay de7iyaawaa taani hinttentta erissana” yaagiide he bollay sileedda bitaniyaa, ");
INSERT INTO dwrNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Neena gay; dendda eqqa; yaataade ne shanchchamaa tookkaade ne soy ba” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Bitani ellekka denddi eqqiide, bare shanchchamaa tookkiide, asay ubbay xeellishshin biina asay ubbay maalalettiide, “Nuuni hawaa malabaa ubbakka be7i erokko” yaagiide Xoossaa galateeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesuusi gujjikka Galiilaa Abbaa doonaa beedda; asay ubbay aakko yeeddawantta tamaarisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hewaanna aadhdhiidde, Ilppiyoosa na7aa Leewiyaa, giyaawe qaraxaa qanxxiyaasaan utteeddawaa demmiide, “Taana kaalla” yaageedda. Hewaappe guyye Leewii denddi eqqiide, A kaalleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesuusi qumaa maanaw Leewiyaa soyin utteedda wode, qaraxaa akkiya cora asaynne nagaranchchatuu aanannanne A kaalliyaawanttunna ittippe utteeddino. A kaalliyaawanttu giddon hewanttu mala asatuu dareeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Higgiyaa tamaarissiyaa itti itti Parisaawatuu Yesuusi nagaranchchatuwaannanne qaraxaa akkiyawanttunna qumaa miishshin be7iide, “I ayissi nagaranchchatuwaannanne qaraxaa akkiyawanttunna qumaa mii?” yaagiide, A kaalliyaawantta oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesuusi unttunttu giyaawaa sisiide, “Hargganchchatuwappe attin, paxa asaw aakimii koshshenna; taani nagaranchchatuwaa xeesanaw yeeddawaappe attin, xillatuwaa xeesanaw yabeykke” yaagiide unttunttoo zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Xammaqiyaa Yohaannisa kaalliyaawanttunne Parisaawatuu xoomiino; amareedda asatuu Yesuusakko yiide, “Yohaannisa kaalliyaawanttunne Parisaawatuwaa kaalliyaawanttu xoomiino; shin neena kaalliyaawanttu ayissi xoomikkinoo?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesuusi unttuntta “Bullachchaa yeedda asatuu machchatto akkiyawe barenttunna de7ishshin, xoomanaw danddayiinoo? Machchatto akkiyawe unttunttunna de7ishshin, xoomanaw danddaykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Shin machchatto akkiyawaa unttunttu matappe afana wodii yaanawaa; unttunttu he wode xoomanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Eca mayuwaa bolla ooratha dhefiyaa wothi sikkiyaa asay baawa; ecaa wothi sikkooppe, ooratha dhefii eca mayuwaa peedherethee; peedhethaykka koyrowaappe darana. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Qassi ho77o woyiniyaa eessaa eca ogoruwan naa77iyaa asay baawa; shin naa77ooppe, he woyiniyaa eessay ogoruwaa daakkee; barewukka woofettee; ogoruukka bayee; shin ho77o woyiniyaa eessaa ooratha ogoruwan naa7ettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesuusi itti Sambbata gallassi tisha banggaa giddonna aadhdhishshin, A kaalliyaawanttunna aananna biidde, banggaa tishaappe duusaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisaawatuu Yesuusa, “Be7a; neena kaalliyaawanttu Sambbata gallassi higge gidennabaa ayissi oothiinoo?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesuusi unttuntta, “Daawite koshattiide, miyaabaa koyyeedda wode, barenanna de7iyaawanttunna ootheeddawaa ubbakka nabbabibeykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiyaataari qeesatoo ubbatoo kaappo gideedda wode, Daawite Xoossaa golliya geliide, qeesatuwaa xalalay maanaappe attin, ooninne maanaw higge gidennawaa Godaa sinthan wotheedda qumaa miide, barenanna de7iyaawanttookka immeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Qassikka Yesuusi unttuntta, “Sambbatay asaw medhetteeddawaappe attin, asay Sambbataw medhettibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hewaa diraw, taani, Asaa Na7ay, haray atto, Sambbatawukka Godaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesuusi Ayihuda woosa golliyaa shirettikka geleedda; hewaan kushii sileedda itti bitani de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Itti itti asay Yesuusa mootanaw koyyiide, kushii sileedda bitaniyaa Sambbataan I pathooppe be7anaw naagee. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuusi he kushii sileedda bitaniyaa, “Dendda eqqaade sinthaw haa ya” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hewaappe guyyiyan asaa, “Sambbataan lo77obaa oothiyaawe wogeeyee iitabaa oothiyaawe wogee? Asaa shemppuwaa ashshiyaawe wogeeyee wodhiyaawe wogee?” yaagiide oochcheedda. Shin asay co77u geedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesuusi hanqqettiide, unttuntta yuushshi aathi xeelliide, unttunttu odina sisennawantta gidiyaa diraw, unttunttoo darii kayyotteedda; he bitaniyaa, “Ne kushiyaa piddi ootha” yaageedda; bitani piddi oothina, A kushii paxi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisaawatuu Ayihuda woosa golliyappe kare kesiide, Yesuusa wooti wodhanentto Heroodisanna de7iyaawanttunna maqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuusi barena kaalliyaawanttunna Galiilaa Abbaa beedda; Galiilaappe cora asay A kaalleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Qassikka cora asay Yihuudaappe, Yeerusalaameppe, Eedomiyaasappe, Yorddaanoosa Shaafaappe hefintha baggappe, Xiiroosa katamaappenne Sidoonaa katamaappe Yesuusi ootheeddawaa sisiide, aakko yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesuusi cora asay barena sugi un77ethenna mala, barena kaalliyaawantta wonggiriyaa barew gami77ethana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Daro asaa I patheedda diraw, harggiyaa asay ubbay A bochchanaw sugerettee. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iita ayyaanay de7iyaa asatuukka A be7eedda wode ubbaan A sinthan guufanniide, barenttu qaalaa dhoqqu oothiide, “Neen Xoossaa Na7aa gidikkii!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesuusi he iita ayyanatuu barebaa asaw odiide, barena qoncciyaa kessenna mala, unttuntta minissiide azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesuusi deriyaa bolla kesiide, bare koyyeedda asatuwaa barekko xeeseedda; hewaappe guyye aakko beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Unttunttu barenanna de7ana malanne qaalaa odanaw unttuntta kiittana mala, iita ayyaanatuwaa asaappe kessanaw unttunttoo maatay de7ana mala, tammanne laa77u asatuwaa dooreedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I dooreedda tammanne laa77atuu hawantta: Phexiroosa yaagiide suntheedda Simoona, ");
INSERT INTO dwrNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Bo7aanerggeessa yaagiide suntheedda Zabiddiyoosa naanaa Yayiqoobanne Yayiqooba ishaa Yohaannisa. “Bo7aanerggeessa” giyaawe “Wolqqaama asatuwaa” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Inddiraasanne Piliphphoosa, Barttalamoosanne Maatoossa, Toomaasanne Ilppiyoosa na7aa Yayiqooba, Taadoosanne bare biittaw seelettiyaa Simoona, ");
INSERT INTO dwrNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yesuusa aathi immeedda Yihudaa Asqqoroota. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesuusi soy beedda; laa7enthuwaakka qassi cora asay shiiqina, inne A kaalliyaawanttunna haray atto, qumaa maanawukka danddaybeykkino; ");
INSERT INTO dwrNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","asay A, “Gooyee” giyaa diraw, A dabbatuu hewaa sisiide, A akkanaw beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Higgiyaa tamaarissiyaa itti itti asatuu Yeerusalaameppe yiide, “Yesuusa bolla Bi7eel-Zebuul de7ee” yaageeddino; qassi, “Xalahatuwaa kaappuu barew wolqqaa immina, iita ayyaanatuwaa kessee” yaagiide haaseyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesuusi asaa barekko xeesiide, leemisuwaa odiidde, “Seexaanay Seexaanaa wooti kessanaw danddayi? ");
INSERT INTO dwrNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Itti kawutethay bare giddon shaakettooppe, he kawutethay eqqanaw danddayenna; ");
INSERT INTO dwrNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","qassi itti golle asaykka bare giddon shaakettooppe, he golle asaykka eqqanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Seexaanay barenanna walaqettiide shaakettooppe, bayanaappe attin, de7ana danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Shin wolqqaama asaa golle geliide kasetiide A qachchennaan de7iidde, A miishshaa bonqqanaw danddayiyaa asay baawa; qachcheeddawaappe guyyiyan, A golliya bonqqanaw danddayee. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Taani hinttenttoo tumuwaa gay; Xoossay asaa naanaw nagaraa ubbaanne unttunttu boriyaa boriyaa ubbaa atto gaana; ");
INSERT INTO dwrNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","shin Geeshsha Ayyaanaa bolla iita boriyaa haasayiyaa oossinne medhinaw nagaraa gidanaappe attin, Xoossay ubbakka atto geenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesuusi hewaa geeddawe, itti itti asatuu, “Yesuusa bolla iita ayyaanay de7ee” yaageedda diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesuusa daayanne A ishatuu yiide, karen eqqi aakko asaa kiittiide, A xeesisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Cora asay A matan utteeddino; he kiitetteeddawe A, “Be7a; ne daayanne ne ishatuu karen eqqiide, neenanna gakettanaw koyyiino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesuusi zaariide, “Ta daaya oone? Qassi ta ishatuu oone?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bare matan utteedda asaa yuushshi aathi xeelliide, “Be7ite; ta daayanne ta ishatuu hawanttushi. ");
INSERT INTO dwrNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Xoossay koyyiyaawaa oothiyaa ubbay ta ishaa, ta michchattonne ta daayo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuusi shirettikka Galiilaa Abbaa mataan tamaarissuwaa doommeedda; cora asay bare miyyiyaan yuuyyi aadhdhiide shiiqi uttina, abbaan de7iyaa wonggiriyaa giddo geliide, aani utteeddino; qassi he asay ubbay abbaa miyyiyaan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","I unttuntta darobaa leemisuwan tamaarissiidde, ");
INSERT INTO dwrNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sisite; itti bitani zerethaa zeranaw keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","I zerishshin, itti itti zerethay ogiyaa doonan wodhdheedda; hewaa kafuu yiide meedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Itti itti zerethay ancco biittaa bolla wodhdheedda; daro biittay baynna diraw, he zerethay ellekka mokkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Away keseedda wode shulleedda; adussa xaphuwaa yeddibeenna diraw, melii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Itti itti zerethay agunthaa giddon wodhdheedda; hewaan mokkeeddawaa agunthay dicciide cuullina, ayfennaan atteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Itti itti zerethay tu7e biittaan zerettiide mokkeedda; dicciide ittu hattamuwaa, ittu usuppun tammuwaa ayfina, ittu xeetuwaa ayfeedda.” ");
INSERT INTO dwrNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Qaykka Yesuusi, “Sisanaw haythay de7iyaa uray siso” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tammanne laa77u Yesuusa kaalliyaawanttunne I odeeddawaa siseedda hara asatuu I barekka de7ishshin aakko shiiqiide, he leemisuwaa bilethaa A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Yesuusi unttunttussi, “Hinttenttoo Xoossaa kawutethaa xuuraa yewuwaa eray imetteedda; shin haratuu kawutethaappe karenna de7iyaawanttu, xeelaa xeelliidde be7enna mala, qassi sissaa sisiiddikka akeekenna mala, unttunttu shirettiide Xoossaakko simmina, I unttunttu nagaraa atto geenna mala, unttunttoo ubbabay leemisuwan odettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuusi unttuntta, “Ha leemisuwaa erikkitee? Yaatina, leemisuwaa ubbaa wooti eranitee? ");
INSERT INTO dwrNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Zeriyaawe Xoossaa qaalaa zeree. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Qaalay zerettiyaa ogiyaa doonan de7iyaawanttu hawantta; unttunttu qaalaa sisiyaa wode, Seexaanay ellekka yiide, unttunttu wozanaan zeretteedda qaalaa afidiggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hawaadankka qassi anccotiyaa biittaan zeretteeddawanttu hawantta; unttunttu qaalaa sisiide, ellekka nashechchaan akkiino. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Unttunttu ha77iw de7iinoppe attin, unttunttoo mino xaphuu baawa; guyyeppe qaalaa gaasuwan waayyii woy yederssuu yiyaa wode, unttunttu ellekka dhubetti aggiino. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Qassi agunthaa giddon zeretteeddawanttu hawantta; unttunttu qaalaa sisiyaawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Shin ha sa7aa de7oo hirggiyaawe duretethaa dosiyaawenne harabaa amottiyaawe unttunttu wozanaan geliide, qaalaa cuullina ayfennaan atti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Shin tu7e biittaan zeretteeddawanttu qaalaa sisiide akkiyawantta; ittu hattamuwaa, ittu usuppun tammuwaa ayfina, ittu xeetuwaa ayfeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuusi gujjiide, “Xomppiyaa ahiide, gillaappe woy arssaappe garssanna wothiyaa asay de7ii? Dhoqqasaan wothennee? ");
INSERT INTO dwrNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ayissi gooppe, qoseeddabay ubbay qoncciyaa kesanawaa; qassi geeman wotheeddabay ubbay beettennaan attenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sisanaw haythay de7iyaa uray de7ooppe siso” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Qassikka unttuntta, “Hinttenttu sisiyaawaa akeekiide sisite; Xoossay hintte makkeedda qun77aan hinttenttoo makkanawaa. I hinttenttoo darissiide immana; ");
INSERT INTO dwrNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","de7iyaa uraw gujji immana; baynnawaappe haray atto, aw de7iyaa he guuthattokka akkidiggana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuusi qassikka, “Xoossaa kawutethay gaden kathaa zeriyaa asaa mala. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","He bitani qamma gemi77ishee; guura denddee; I bare huuphew waanintto erennaan, he zerethay mokkeenne diccee. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Biittay kathaa barekka mokkeenne ayfee; koyro carshshay caaree; guyyeppe ayfanaw kuukummee; qassi wurssethaan kumentha ayfiyaa ayfee. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Shin kathay gakkiyaa wode, kathaa shiishshiyaa wodii gakkeedda diraw, bitani ellekka baacaan cakuwaa gelii aggeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuusi, “Nuuni Xoossaa kawutethaa ayaa malatee gaanee? Woy ayaanna leemisanee? ");
INSERT INTO dwrNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xoossaa kawutethay sannaaficiyaa ayfatto malatee. He ayfatta zeriyaa wode, sa7aan de7iyaa mithaa ayfiiyaa ubbaappekka guuxxaw; ");
INSERT INTO dwrNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","henno zerina mokkaade hara atakilttiyaa ubbaappe daraw; daro daashshaa daashaw. Kafuu izi qankkaa kuwaan golliya keexxana danddayee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuusi hawaa mala daro leemisuwan asay sisanaw danddayiyaawaa keenaa, bare qaalaa odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Asaw leemisuu baynnaan odenna; shin Yesuusi barena kaalliyaawanttu xalalaanna de7iyaa wode, unttunttoo ubbabaa billiide odee. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","He gallassi sa7ay omarssina, Yesuusi barena kaalliyaawantta “Abbaappe hefintha pinnoytte” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A kaalliyaawanttu asaa aggiide, Yesuusi kase geli utteedda wonggiriyaan geliide, Yesuusa barenttunna afeeddino; hara wonggiratuukka hewaan de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wolqqaama gotuu denddina, beetay wongiriyaa shocina, haathay kumana gakkanaw wongiriyaa giddo geleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","He wode Yesuusi wonggiriyaan guyye bagganna borkkothaa borkkotiide gemi77isheedda. Yesuusa kaalliyaawanttu A denthiide, “Tamaarissiyaawoo, nuuni dhayiyaa wode co77u gaade xeellay?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I beegottiide gotuwaa, “Co77u ga” giide, abbaakka, “Woppu ga” geedda; gotuukka co77u giina, ubbabaykka woppu geedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesuusi barena kaalliyaawantta “Ayissi hawaadan yayyiitee? Hinttenttu waani ammanikkitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Unttunttu daro yayyiide barenttu giddon, “Hawe laa haray atto, gotuunne abbay azazettiyaawe oone?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesuusinne A kaalliyaawanttu abbaappe hefinthaw pinniide, Gerggesenoona geetettiyaa gadiyaa gakkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Asaa moogiyaa duufuu de7iyaasaappe iita ayyaanay de7iyaa itti bitani kesiide, Yesuusi wonggiriyaappe keseedda wode, Yesuusanna gaketteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Bitani he duufuu de7iyaasaan aqi peeshiide, yaani de7ee; A ooninne haray atto, santhalataan qachchanawukka danddaybeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ayissi gooppe, I daro wode uqqinnaaninne santhalataan qashettiide de7ee; shin santhalataa duseretheedda; uqqinnaakka menthereetheedda; A xoonanaw danddayeeddawe ooninne baawa. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","I ubba wode gallassinne qamma, he duufuu de7iyaasaaninne deriyaa bolla waassee; bare bollaakka shuchchan gaaree. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesuusa haakuwaan be7eedda wode, aakko woxxi yiide aw goyinneedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","He bitani bare kooshshaa dhoqqu oothiide, “Ubbaappe Bolla Xoossaa Na7aw, Yesuusaa, neenanne taana ayee gathii? Taana murenna mala, taani neena Xoossaa sunthan woossay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","I hewaa ayissi geeddee gooppe, Yesuusi A, “Laa ha iita ayyaanaw, ha bitaniyaappe kesa” yaageeddawaassa. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesuusi A, “Ne sunthay oone?” yaagiide oochcheedda. I, “Nuuni cora gidiyaa diraw, ta sunthay Leegiyoona” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iita ayyaanatuwaa he gadiyaappe kessi yeddenna mala, Yesuusa minissiide woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","He deriyaa bollan cora gudunthaa wudii heemettee; ");
INSERT INTO dwrNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","iita ayyanatuu Yesuusa, “Nuuna hini gudunthaa wudiyaakko yeddaarkkii; unttunttun biide gelana” yaagiide woossina, ");
INSERT INTO dwrNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesuusi, “Biite” yaageedda. Iita ayyanatuu bitaniyaappe kesiide, gudunthatuwaan geleeddino; laa77u sha77a gidiyaa gudunthaa wudii kakaa huuphiyaanna kajjottiidde, abbaan geliide, mitetti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gudunthaa wudiyaa heemmiyaawanttu baqatiide, haneeddawaa katamaaninne katamaappe gaxaa gadiyaan odeeddino; hewaa be7anaw asay yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Asay Yesuusakko yiide, cora iita ayyaanatuu beni oyqqeedda bitani bare wozanay simmina, mayuwaa mayyiide, hewaan utteeddawaa be7iide, ubbay yayyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hewaa be7eedda asatuu iita ayyaanatuu oyqqeedda bitani haneeddawaanne qassi gudunthaa wudiyaabaa he asaassi odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hewaa diraw, asay barenttu gadiyaappe Yesuusi baana mala, woosaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesuusi wonggiriyaan gelishshin, iita ayyaanatuu oyqqeedda bitani Yesuusanna de7ana mala, Yesuusa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Shin Yesuusi ixxiide A, “Ne soy simmaade, Goday new ay mala wolqqaamabaa ootheeddenttonne qassi I new ay mala keekentto ne soy asaw oda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bitani biide, Tammu Katamaa giyaasan yuuyyiide, Yesuusi barew ay mala wolqqaamabaa ootheeddentto, oduwaa doommeedda; I odeeddawaa siseedda asay ubbay maalaletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuusi simmiide, wonggiriyaan geliide, abbaa pinneeddawaappe guyyiyan, cora asay abbaa mataan Aakko yuuyyi aadhdhiide shiiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yaa7iroosa giyaawe, Ayihuda woosa golliya kaappatuwaappe ittuu, Yesuusa be7eedda wode aakko yi A gediyaan kunddiide, ");
INSERT INTO dwrNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Ta naatta harggaade hayqqana hanaw; iza paxaade lo77o de7ana mala, yaade ne kushiyaa izi bolla wothaarikkii” yaagiide Yesuusa minissiide woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesuusi Yaa7iroosanna beedda; I biishshin cora asay A kaalliidde metootheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tammanne laa77u laythaa ubbaa izi bollaappe suuthay goggiyaa itti mishiratta de7aw. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Cora aakimatuu izo aakimishshinkka, iza paxa kaa7ettaaddu; bare miishshaa ubbaa wurssinakka iziw haa iiteeddawaappe attin, aynne izo maaddibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","He mishiratta Yesuusabaa sisaade, asaa giddonna Yesuusappe guyyenna yaade, A mayuwaa bochchaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ayissi gooppe iza, “Taani haray atto, A mayuwaa bochchooppekka paxana” yaagaade qoppaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Iippe goggiyaa suuthay ellekka eqqi aggeedda; iza bare waayyiyaappe paxeeddawaa bare bollaan eraa aggaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesuusi bareppe wolqqay kesseeddawaa bare huuphew eriide, ellekka cora asaa giddon guyye simmiide, “Ta mayuwaa bochcheeddawe oone?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yesuusa kaalliyaawanttu A, “Asay neena sugiyaa wode be7aadde, ‘Taana oone bochcheeddawe?’ yaagay?” geeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesuusi hewaa oone ootheeddenttonne be7anaw yuushshi aathiide xeelleedda; ");
INSERT INTO dwrNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","shin mishiratta barew haneeddawaa eraade, yashshaa kokkoraadde yaade Yesuusa sinthan guufannaaddu; qassi tumatethaan haneeddawaa ubbaa aw odaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesuusi izo, “Ta naattee, neena ne ammanuu patheedda; saruwan ba; ne waayyiyaappenne paxa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuusi biro hewaa giishshin, Ayihuda woosa golliya kaappuwaa soyippe kiitetteedda asatuu yiide, “Ne naatta hayqqadiggaaddu; simmi tamaarssiyaawaa ayissi daaburssay?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Shin Yesuusi unttunttu giyaawaa sisiide, Ayihuda woosa golliya kaappuwaa, “Ammano xalalaa ammanappe attin, yayyoppa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesuusi Phexiroosappe, Yayiqoobappenne Yayiqooba ishaa Yohaannisappe haray ooninne barena kaallenna mala diggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Unttunttu Ayihuda woosa golliya kaappuwaa soy gakkeedda wode, Yesuusi asay loythi yeekkiyaawaanne zilaliyaawaa be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Geliide asaa, “Ayissi loythi yeekkiitee? Naatta gemi77ishaadduppe attin, hayqqabeykku” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hewaappe guyye asay A bolla miicceedda; shin asaa ubbaa kare kessiide, naatti aawuwaanne aatto hewaan barenanna de7iyaa A kaalliyaawanttanne akkiide, naatta de7iyaasaa geleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesuusi naatti kushiyaa oyqqiide, “Xaalitaa, quumii” yaageedda; hewaa bilethay, “Guutha naattee, taani neena dendda gay” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Naatta ellekka dendda eqqaade hamettaaddu; iza tammanne laa77u laythaa naatto; hewe haniyaawaan asay daro maalaletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuusi hewaa unttunttu oossinne odenna mala, unttuntta minissi azaziide, “Iziw miyaabaa immite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuusi hewaappe kesiide, bare gadiyaa Naazireete katamaa beedda; A kaalliyaawanttukka A kaalliide beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sambbataa gallassi Ayihuda woosa golliyan tamaarissuwaa doommeedda; I tamaarssiyaawaa siseedda cora asay maalalettiide, “Hawe ha ubbabaa haqappe demmeeddee? Ha aw imetteedda aadho eratethay ayee? Xoossay oothiyaa malaataa I wooti oothii? ");
INSERT INTO dwrNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hawe anaaxiyaa gidennee? Mayraami na7aa, Yayiqooba ishaa, Yoosa ishaa, Yihudaa ishaa, Simoona ishaa gidennee? A michchatuu nuunanna hawaan de7iyaawantta gidikkinoo?” yaagiide, I giyaawaa akkennaan ixxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesuusi he asaassi, “Nabii bare gadiyaan, bare dabbatuwaaninne barenttu soy asaan bonchchettennawaappe attin, ubbasan bonchchettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","I hewaan bare kushiyaa amareedda asatuwaa bolla wothiide, unttuntta patheeddawaappe attin, cora malaataa oothanaw aynne danddaybeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Asay ammanibeenna diraw maalaletteedda. Hewaappe guyyiyan, Yesuusi hewaa heeran de7iyaa qeeri katamatuwaan yuuyyi yuuyyiide, asaa tamaarsseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesuusi tammanne laa77u barena kaalliyaawantta barekko xeesiide, laa77uwaa laa77uwaa kiitteedda; qassi unttunttoo iita ayyaanatuwaa kessiyaa maataa immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Unttuntta, “Ogiyaa xam77aappe attin, qumaa, qarcciitiyaa, hinttew miishshaa ayaanneekka oyqqoppite. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hinttenttu gediyaan caammaakka wothite; shin laa77u mayuwaa mayyoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Qassikka unttuntta, “Hinttentta asay haqan mokkooppenne, hewaappe kesana gakkanaw, he golliyan utti aggite. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hinttentta asay mokkennasaa woy hintte odiyaabaa sisennasaa haqa gidooppekka, he gadiyaan de7iyaa asaw hewe markka gidana mala, hewaappe kesiidde, hintte gediyaappe baanaa shocite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tammanne laa77u A kaalliyaawanttu biide, asay barenttu nagaraappe simmanaadan, qaalaa odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Unttunttu asaappe daro iita ayyaanatuwaa kessiide, harggiyaa asaa coraa zaytiyaa okkiide patheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Asay Yesuusa sunthaa denthiyaa diraw, Kaatiyaa Heroodise hewaa ubbaa siseedda; itti itti asay, “Xammaqiyaa Yohaannisi hayquwaappe denddeedda; hewaassi aw wolqqaama malaataa oothiyaa wolqqay de7ee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Shin haranttu A, “Hawe Eelaasa” yaageeddino. Haranttu qassi, “Hawe beni wode nabatuwaa malatiyaa nabiyaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Shin Heroodise hewaa siseedda wode, “Hewe taani qoodhiyaa muucisseedda xammaqiyaa Yohaannisa. I hayquwaappe paxeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ayissi gooppe, Heroodise bare ishaa Piliphphoosa machchatto Heroodiyaado akki wotheedda; Heroodise izi diraw, bare huuphew asaa kiittiide, Yohaannisa oythiide, qashissi wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ayissi gooppe, Yohaannisi Heroodisa, “Neeni ne ishaa machchatto akkanaw bessenna” yaagi wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Heroodiyaada Yohaannisaw uluwaan morkkiyaa oyqqaade A wodhissanaw koyyaaddu; shin danddayabeykku. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yohaannisi xillo asanne geeshsha asaa gideeddawaa Heroodise ereedda diraw, aw yayyiide, loythi naagi wotheedda; Yohaannisi giyaawaa sisiide, bare wozanaan darissi metootiiddekka aabaa nashechchaan siseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Heroodise bare yeletteedda gallassi, gadiyaa ayissiyaawanttoo, shaalaqatuwaassinne Galiilaan de7iyaa wolqqaama asaw shoobiyaa giigisseedda wode, wurssethaan Heroodiyaada injje gallassaa demmaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heroodiyaadi naatta imathaa mokkiyaasaa gela duraade, Heroodisanne A imathatuwaa nashechchaaddu; Hewaappe guyye kaatii naattiw, “Neena lo77eeddawaa ayaa gidooppenne taana oochcha; taani new immana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Qassi iziw darii caaqqiide, “Neeni oochcheeddawaa ayaa gidooppekka, taani new immana; haray atto, ta kawutethaappe baggaa gidooppekka, taani new immana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Naatta kare kesaade bare daayo, “Ayaa imma goo?” yaagaade oochchaaddu. I daaya, “Xammaqiyaa Yohaannisa huuphiyaa imma ga” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Naatta ellekka kaatiyaakko baade A, “Xammaqiyaa Yohaannisa huuphiyaa wociitiyaan wothaade, neeni ha77i taw immanaadan koyyay” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hewaappe guyye kaatii darii qaretteedda; shin bare caaquwaa dirawunne bare imathatuwaa diraw iziw caaqqeedda caaquwaa kolanaw koyyibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hewaa diraw, ellekka naagiyaawaa kiittiide, Yohaannisa huuphiyaa ahana mala azazeedda; naagiyaawe qasho golle biide, Yohaannisa qoodhiyaa muuceedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","He muuceeddawaa wociitiyaan wothi ahiide, naattiw immeedda; naatta qassi bare aattiw immaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohaannisa kaalliyaawanttu hewaa siseedda wode yiide, A anhaa afiide moogeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesuusi kiitteeddawanttu simmiide, Yesuusanna gakettiide, barenttu ootheeddabaanne barenttu tamaarsseeddabaa ubbaa Yesuusassi odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Biya asaynne yiyaa asay darina, haray atto qumaa maanawukka unttuntta gathennaan ixxeedda diraw, Yesuusi unttuntta, “Nuurekka guuthaa shemppi akkanaw asay baynnasaa boytte” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yesuusinne unttunttu barenttu xalalaa wonggiriyaan uttiide, asay baynnasaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Unttunttu biishshin, cora asay unttuntta be7iide ereedda; katamaa ubbaappe gediyaan woxxiidde, unttunttu biyaasaa unttunttuppe kasetiide gakkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesuusi wonggiriyaappe kesiide, cora asaa be7eedda; asay heemmiyaa asay baynna dorssaa mala gideedda diraw, qarettiide asaa darobaa tamaarissuwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sa7ay omarssiyaa wode, Yesuusa kaalliyaawanttu aakko yiide, “Hawe sa7ay asay baynna sa7aa; ha77i sa7aykka qammidiggeedda; ");
INSERT INTO dwrNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","asay heeraanne qeeri katamatuwaa giddo biide, barenttoo miyaabaa shammana mala, asaa moyizza” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Shin Yesuusi zaariide unttuntta, “Asaw miyaabaa hintte immite” yaageedda. Hewaappe guyye unttunttu, “Nuuni biide, laa77u xeetu biraa santtimiyaa qumaa shammiide, asay maanaw immanee?” yaagiide A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesuusi unttuntta, “Hinttenttoo aappun daabbuu de7ii? Biide be7ite” yaageedda. Unttunttu be7iide, “Ichcheshu daabbuwaanne laa77u moliyaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesuusi barena kaalliyaawantta asaa ubbaa citan citan shaakki shaakkiide, maataan utissana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Asay xeetuu xeetuunne ishatamuu ishatamuu citan citan utteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesuusi ichcheshu daabbuwaanne laa77u moliyaa oyqqiide, pude saluwaa xeelliide, Xoossaa galateedda; daabbotuwaa menthiide asaw gishana mala, barena kaalliyaawanttussi immeedda; qassi laa77u moliyaakka unttunttu ubbaw shaakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Asay ubbay miide kalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hewaappe guyye atteedda daabbotuwaa dokkaynne moliyaa dokkay tammanne laa77u zambbeeliyaa kumeeddawaa Yesuusa kaalliyaawanttu dentheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Daabbuwaa meedda attuma asay ichcheshu sha77a. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ellekka Yesuusi he cora asaa moyizziide, barena kaalliyaawanttu wonggiriyaan geliide, abbaappe hefinthan de7iyaa Beetesayda giyaa katamaa bareppe sinthatiide baanaadan azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Unttuntta moyizzeeddawaappe guyyiyan, Xoossaa woossanaw zooziyaa keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sa7ay qammiyaa wode wonggirii wombbaa gidduwan de7ishshin, Yesuusi wombbaappe gaxaan barekka de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Carkkuu A kaalliyaawanttukko carkkiyaa diraw, barena kaalliyaawantta wombbaa beetay metoothiyaawaa Yesuusi be7iide, kuttuu waassana haniyaa wode wombbaa bollan hamettiidde, unttunttukko yeedda; unttuntta yeggi aadhdhanaw koyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Shin wombbaa bollan I hamettishshin, unttunttu A be7iide, barenttoo moytilliyaa malatina waasseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ayissi gooppe, unttunttu ubbay A be7iide, yashshaa kokkoreeddino; shin ellekka Yesuusi unttuntta, “Aynne baawa; taanattennee yayyoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesuusi unttunttunna ittippe wonggiriyaan gelina, carkkuu woppu geedda; unttunttu daro maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ayissi gooppe, unttunttu wozanay jolleedda diraw, unttunttu ukithaabaa akeekibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Unttunttu abbaa pinniide, Gensaareexa giyaa biittaa gakkeeddino; yaani wongiriyaa gaxaa shiishshi qachcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Unttunttu wonggiriyaappe wodhdhiyaawaan, asay ellekka Yesuusa erinne ");
INSERT INTO dwrNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","hewaa heeran de7iyaa gadiyaa ubbaan woxerettiide, hargganchchatuwaa shanchchamaan tookkiide, “Yesuusi de7ee” giina siseeddasaa ahuwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesuusi beeddasaa ubbaan qeeri katamaan gidina, wolqqaama katamaan gidina, heeraa giddon gidinakka, geyaa denbbaan asay hargganchchatuwaa aakko afee. Yesuusi bare mayuwaa macaraa gidooppenne hargganchchatuwaa boshissana mala, asay A woosseedda; bochcheedda ubbay paxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisaawatuunne Yeerusalaameppe yiide, Muse higgiyaa tamaarissiyaa amareedda asatuu Yesuusakko shiiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesuusa kaalliyaawanttuppe ittu ittu tuna kushiyan, hewaa giyaawe meecettennaan qumaa miyaawantta be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ayissi gooppe, Parisaawatuunne Ayihuda asay ubbay barenttu aawatuwa wogaa naagiide, barenttu kushiyaa loythi meecettennaan miikkino. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Qassi geyaappe yiidekka meecettennaan de7iidde miikkino. Qassi unttunttu barenttu aawatuwappe akkeedda hara cora wogay de7ee; hewekka wanccaa, keriyaa, birataappe medhdheedda miishshaanne arssaa meecciyaa wogaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parisaawatuunne Muse higgiyaa tamaarssiyaawanttu Yesuusa, “Neena kaalliyaawanttu ayissi nu aawatuwa wogaa kaallennaan ixxiide, barenttu kushiyaa meecettennaan qumaa miinoo?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Yesuusi unttuntta hawaadan yaageedda; “Isiyaasi timbbitiyaa odeedda wode, hinttenttubaa, lo77a malatiyaa iitatubaa xaafeeddawaadankka, ‘Xoossay, “Hawe asay taana bare bolla doonan bonchchee. Shin unttunttu wozanay taappe haakuwaan de7ee; asay taw mela goyinnee. Ayissi gooppe, asay ootheedda azazuwaa Xoossaa higgiyaa malatissiide tamaarssee” geedda’ yaagiide timbbitiyaa tumuwaa odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Xoossaa azazuwaa hintte aggiide, asaa wogaa minissiide naagiita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Qassikka Yesuusi, “Hinttenttu hintte wogaa naaganaw Xoossaa azazuwaa aggiita. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ayissi gooppe Muse, ‘Ne aabbanne ne daayo bonchcha’ Qassi, ‘Bare aabbanne bare aatto boriyaawe hayquwan muretto’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Shin itti uraw bare aawuwaa woy bare aatto maaddiyaabay de7ishshin I, ‘Hawe qurbbaaniyaa; hawaa guussay Xoossaabaa giyaawaa’ gooppe, ");
INSERT INTO dwrNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","I bare aawuwaa woy bare aatto wodeppe maaddanaawaa aynne koyyikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ha hanotaan hintte hinttenttu wogaa naaganaw, Xoossaa qaalaa koliide, hewaa mala darobaa oothiita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuusi cora asaa qassikka barekko xeesiide, “Ubbay taani giyaawaa sisitenne akeekite. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Asaappe kesiyaawe asaa tunissiyaawaappe attin, kareppe asaa giddo geliide, asaa tunissiyaabay aynne baawa; ");
INSERT INTO dwrNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","sisanaw haythay de7iyaa uray ooninne siso” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesuusi cora asaa aggiide soy geleedda wode, A kaalliyaawanttu he leemisuwaabaa A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","I unttuntta, “Hinttenttookka qassi gelibeennee? Kareppe asaa wozanaan geliyaabay aynnee asaa tunissanaw danddayennawaa akeekiitee? ");
INSERT INTO dwrNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ayissi gooppe, qumay asaa uluwaa giddo geliide, karew kesiyaawaappe attin, asaa wozanaa giddo gelenna” yaageedda. Hawaadankka Yesuusi qumaa ubbay tuna gidennawaa erisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Qassikka Yesuusi hawaadan yaageedda; “Asaa tunissiyaabay asaa wozanaa giddoppe kesiyaabaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ayissi gooppe, asaa wozanaa giddoppe kesiyaawe iita qofaa; woshummiyaawaa; wuu77iyaawaa; wodhiyaawaa; caaratethaa; ");
INSERT INTO dwrNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yoratethaa; uuziyaa woy barena dosiyaawaa; iitatethaa woy cimmiyaawaa; geniyaa; maccawaa amottiyaawaa; qanaatiyaawaa; boriyaawaa woy zigiriyaawaa; ayyuwaa; eeyatethaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ha iitabay ubbay asaa wozanaa giddoppe kesiide, asaa tunissee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuusi hewaappe aggiide, Xiiroosanne Sidoonaa giyaa katamatuwaa matan de7iyaa gadiyaa biide, itti golliya geleedda; qassi I yaani de7iyaawaa ooninne eranawaa koyyibeenna; shin qosettiide gami77anaw danddayibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Shin bare guutha naatti bolla iita ayyaanay de7iyaa itti mishiratta Yesuusabaa sisaade, ellekka aakko yaanne A gediyaan guufannaa aggaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","He mishiratta Ayihuda asa gidukku; A yeletteeddawekka Sooriyaa giyaa gadiyaana; A bare naattippe xalahiyaa kessana mala, Yesuusa woossaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Shin Yesuusi zaariide, “Naanay kasetiide qumaa kallino; ayissi gooppe, naanaa qumaa akkiide, kanatuwassi oliyaawe lo77a gidenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mishiratta zaaraade, “Tumakka ta Godaw, haray atto samppaa miyyiyaan de7iyaa kanatuukka naanatuwappe atteedda suuppaa miino” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesuusi qassi izo, “Ha neeni hasayeedda qaalaa diraw, xalahii ne naattippe keseedda; simmi ne soy ba” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mishiratta bare soy biyaa wode, izi naattippe xalahii kesina, hiixan giseeddawunno demmaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuusi Xiiroosa gadiyaappe kesiide, Sidoonaannanne Tammu Katamaa giyaa gadiyaanna kanthiide, Galiilaa Abbaakko beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Asay tullenne duude gideedda bitaniyaa Yesuusakko ahiide, bare kushiyaa A bollan wothana mala, Yesuusa woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesuusi barekka he bitaniyaa cora asaappe gaxaa kessiide, bare biradhdhiyaa A haythaan yeddeedda; qassi cuchchaa cuchchiide, A inxxarssaa bochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Saluwaa pude xeelliide, tookki shemppiide, “Eftahi” yaageedda; hewaa giyaawe dooyetta giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bitaniyaa haythay ellekka dooyetti aggeedda; qassi A haasayenna inxxarssaykka biletti aggeedda; bitani aynne waayyettennan haasayii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesuusi asaw, “Hawaa oossinne odoppite” yaagiide odeedda; shin I darissi minissi odina, asay qassi oduwaa yaa darisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hewaa siseedda asay ubbay daro maalalettiide, “Ubbabaakka I loythi oothee. Haray atto tulliyaakka sissee; qassi duudiyaakka haasayissee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hewode, cora asay qassi Yesuusakko shiiqeedda; asaw miyaabay dhayina, Yesuusi barena kaalliyaawantta barekko xeesiide, ");
INSERT INTO dwrNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ha cora asay taananna heezzu gallassay gakkanaw gami77iide, miyaabaa aynne demmibeenna diraw, taani unttunttoo qarettay. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Taani unttuntta koshaanna soy yeddooppe, biidde ogiyaan daaburiide kunddana; ayissi gooppe, ittu ittu haakosaappe yeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A kaalliyaawanttu zaariide, “Ha asay bayinna saan ha asaa ubbaa mizanaw gidiyaa qumaa demmanaw danddayiyaawe oone?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesuusi unttuntta, “Hinttenttoo aappun daabbuu de7ii?” yaagiide oochcheedda. Unttunttu, “Laappu daabbuu de7ee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesuusi asaa, “Sa7aan uttite” yaagiide azazeedda; qassi laappu daabbuuwaa akkiide, Xoossaa galateedda; he daabbuwaa menthiide, asaw gishana mala, barena kaalliyaawanttoo immeedda. Yesuusa kaalliyaawanttu he cora asaassi gisheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Unttunttoo qassikka amareedda suuppaa moletuu de7iino; Yesuusi hewanttookka Xoossaa galatiide, asaw gishana mala, barena kaalliyaawantta azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Asay ubbay miide kallina atteedda dokkay laappu zambbeeliyaa kumeeddawaa A kaalliyaawanttu dentheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Qumaa meedda asay oyddu sha77a gidana; hewaappe guyyiyan, Yesuusi asaa yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","I qassi barena kaalliyaawanttunna ellekka wonggiriyaan geliide, Dalmmanutaa giyaa gadiyaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisaawatuu yiide, Yesuusanna palumaa doommeeddino. Yesuusa paaccanaw koyyiide, saluwaappe malaataa barentta bessana mala oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesuusi darissi tookki shemppiide, “Ha wodiyaa asay ayissi malaataa koyyii? Taani hinttenttoo tumuwaa oday; ha wodiyaa asaw malaatay ubbaakka imettenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Qassi unttuntta hewaan aggiide, zaari wonggiriyaan geliide, abbaappe hefintha pinneedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesuusa kaalliyaawanttu qumaa afanawaa dogeeddino; unttunttoo wongiriyaa giddon itti ukithaappe haray baawa. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesuusi unttuntta, “Hinttentta erite; Parsaawatuwaa irshshuwaappenne Heroodisa irshshuwaappe naagettite” yaagiide azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Unttunttu barenttu giddon, “I hawaa giyaawe nuussi qumay baynna diraassa” yaagiide haasayaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesuusi unttunttu giyaawaa eriide, “Hinttenttoo daabbuu bayinnawaa ayissi haasayiitee? Ha77i gakkanaw hinttew gelennee? Woy akeekikkitee? Hintte wozanay jolleeddee? ");
INSERT INTO dwrNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Hinttenttoo ayfii de7ee; be7ikkitee? Qassi haythay de7ee; siskkitee? Hinttenttoo hassayettennee? ");
INSERT INTO dwrNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Taani ichcheshu daabbuwaa ichcheshu sha77a asaw mentha immeedda wode, aappun zambbeeliyaa kumeedda dokkaa dentheedditee?” yaageedda. Unttunttu, “Tammanne laa77u zambbeeliyaa kumeedda dokkaa dentheeddo” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Taani qassikka laappu daabbuwaa oyddu sha77a asaw menthaade immeedda wode, aappun zambbeeliyaa kumeedda dokkaa dentheedditee?” yaageedda. Unttunttu, “Laappu zambbeeliyaa kumeedda dokkaa dentheeddo” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","I qassi, “Ha77ikka akeekibeykkitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesuusinne A kaalliyaawanttu Beetesayda giyaa katamaa beeddino; asatuu qooqa bitaniyaa Yesuusakko ahiide, he bitaniyaa bochchana mala, A woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuusi qooqa bitaniyaa kushiyaa oyqqiide, heeraappe gaxaa kesseedda; A ayfiyaan cuchchiide, bare kushiyaa A bolla wothiide, “New ayentto beettii?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bitani dhoqqiide, “Taani asaa be7ay; shin asay hamettiidde, mithaa malatee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hewaappe guyyiyan, Yesuusi shirettiide bitaniyaa ayfiyaan bare kushiyaa wotheedda. A ayfii paxeedda; bitaniikka loythi xeelleedda; qassi ubbabaakka geeshshiide be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesuusi bitaniyaa, “Heeraa geloppa” yaagi A soy yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuusi barena kaalliyaawanttunna Qiisaariyaa Piliiphphoosa de7iyaa qeeri heeratuwaa beedda; I biishshin ogiyaan Yesuusi, “Taana asay oona gii?” yaagiide barena kaalliyaawantta oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A kaalliyaawanttu, “Itti itti asay neena, ‘Xammaqiyaa Yohaannisa’ gee; haranttuu, ‘Eelaasa’ giino; qassi haranttuu, ‘Nabatuwaappe ittuwaa’ giino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesuusi unttuntta, “Hintteshi taana oona giitee?” yaagiide oochcheedda. Phexiroosi, “Neeni Dooretteedda Kiristtoosa” yaagiide zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesuusi, “Tabaa oossinne odoppite” yaagiide unttuntta azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuusi barena kaalliyaawantta, “Taani, Asaa Na7ay, darii waayyettanaw bessee; cimatuu, qeesatuwaa kaappatuunne higgiyaa tamaarssiyaawanttu taana ixxanaw bessee; unttunttu taana wodhanawunne taani heezzenthiyaa gallassaappe guyyiyan, hayquwaappe denddanaw bessee” yaagiide tamaarissuwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hewaa I unttunttoo geeshshiide odeedda; Phexiroosi A itti bagga zaariide, zoretaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Shin Yesuusi guyye simmiide, barena kaalliyaawantta xeelliide Phexiroosa, “Ha Seexaanaw, kichcha ta matappe! Neen asay qoppiyaawaa qoppaasappe attin, Xoossay qoppiyaawaa gidenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesuusi cora asaanne barena kaalliyaawantta barekko xeesiide, “Taana kaallana koyyiyaa uray de7ooppe, barena kaddo; yaatiide bare masqqaliyaa tookkiide, taana kaallo. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ayissi gooppe, bare shemppuwaa ashshana koyyiyaa uray bayizzanawaa; shin ta dirawunne wonggalaa mishiraachchuwaa diraw bare shemppuwaa bayizziyaa uray ashshanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Itti uray sa7aan de7iyaa ubbabaa barew shiishshiide, bare shemppuwaa bayizzooppe, A ayaa maaddanee? ");
INSERT INTO dwrNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Itti uray bare shemppuwaa wozanaw ayaa immana danddayi? ");
INSERT INTO dwrNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Xoossaa ammanenna ha nagaranchcha yeletaa wodiyaan, itti uray taananinne ta qaalaan yeellatooppe, taanikka, Asaa Na7ay, qassi ta Aawuwaa bonchchuwan geeshsha kiitanchchatuwaanna yiyaa wodekka, aani yeellatana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuusi unttuntta, “Taani hinttenttoo tumuwaa gay; amareedda asatuu Xoossaa kawutethay wolqqaanna yiyaawaa be7ennaan hayqqennawanttu hawaan de7iino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesuusi usuppun gallassaappe guyyiyan, barenanna Phexiroosa, Yayiqoobanne Yohaannisa akkiide, unttunttu xalalaa wolqqaama deriyaa bolla kesseedda; unttunttu sinthaan laametteedda; ");
INSERT INTO dwrNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A mayuukka phooleedda; sa7aan mayuwaa meecciyaa ooninne geeshshanaw danddayennawaa keenaa darii booxxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","He heezzu Yesuusa kaalliyaawanttu, Eelaasinne Muse Yesuusanna haasiyaawantta be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phexiroosi Yesuusa, “Tamaarissiyaawoo, nuuni hawaan de7iyaawe nuussi lo77a; nuuni heezzu daasatuwaa ittuwaa new, ittuwaa Musew, qassi ittuwaa Eelaasassi keexxana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","I waaganenttonne eribeenna; ayissi gooppe, ikka yokkonttukka darii yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hewaappe guyyiyan, shaarii yiide unttuntta kammina shaariyaappe, “Hawe taani siiqiyaa ta Na7aa; I giyaawaa sisite” giyaa qaalay yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ellekka unttunttu yuushshi aathi xeelliyaa wode, Yesuusappe attin, haraa oonanne barenttu matan be7ibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Unttunttu deriyaappe wodhdhishshin, Yesuusi unttuntta, “Taani, Asaa Na7ay, hayquwaappe denddana gakkanaw, hintte be7eeddabaa oossinne odoppite” yaagiide azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","I azazeeddawaa unttunttu, “ ‘Eeno’ giide, ha hayquwaappe denddiyaawaa giyaawe waagiyaawe” yaagiide, barenttu giddon haasayetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Unttunttu Yesuusa, “Higgiyaa tamaarssiyaawanttu ayissi, ‘Eelaas kasetiide yaanaw bessee’ giinoo?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I zaariide yaageedda; “Tumakka, Eelaas kaset yiide, ubbabaa giigissee; yaatina, ayissi Xoossaa Maxaafay, ‘Asaa Na7ay darii waayyettananne ixettana’ yaagii? ");
INSERT INTO dwrNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Shin taani hinttenttoo oday; Eelaas yeedda; qassi aabay Xoossaa Maxaafan xaafetteeddawaadankka, asay A bare koyyeeddabaa ootheedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesuusi, Phexiroosi, Yayiqoobinne Yohaannisi yokko Yesuusa kaalliyaawanttukko simmiide yiyaa wode, cora asay he kaalliyaawanttu yuushshuwaan eqqeeddawaanne higgiyaa tamaarissiyaa amareedda asatuu unttunttunna palumettiyaawantta be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","He cora asay Yesuusa be7eedda wode maalaletti dagammiide, ellekka aakko woxxi yiide, A saroteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesuusi barena kaalliyaawantta “Unttunttunna ayaa palumettiitee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","He cora asaa giddoppe itti bitani zaariide, “Tamaarissiyaawoo, ta na7aa bollan haasayaa diggiyaa iita ayyaanay de7iyaa diraw, A neekko akkaade yaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ha iita ayyaanay A oyqqiyaa wode ubbaan, A olee; A doonaannakka hoommuu paarottee; qassi achchaa garccissee; bollaakka zoolissee. Aappe ha iita ayyaanaa kessana mala, neena kaalliyaawanttoo odaaddi, shin kessanaw danddaybeykkino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesuusi zaariide unttuntta, “Ammanenna ha wodiyaa asaw! Taani hinttenttunna awude gakkanaw de7anee? Qassi hinttenttubaa awude gakkanaw danddayanee? Na7aa taakko haa akki yiite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Unttunttu na7aa aakko aheeddino; he iita ayyaanay Yesuusa be7eedda man77iyankka na7aa kokkorssii aggeedda; na7ay sa7aan kunddiide, doonaanna hoommuu goppu giishshin gonddoretteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesuusi he na7aa aawuwaa, “Hawe ne na7aa oyqqoodeppe woysa wode gidanee?” yaagiide oochcheedda. Na7aa aabbu, “I na7atethaan de7iyaa wodiyaappe doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A wodhanaw daro wode tamaaninne haathaan oleedda; shin neeni danddayooppe, nuussi qarettaade nuuna maaddaarikkii” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesuusi A, “Neeni danddayooppe gay? Ammaniyaa asaw ubbabay danddayettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ellekka na7aa aabbu bare kooshshaa dhoqqu oothiide, “Taani ammanay; shin gujja ammananaadan, taana maaddaarikkii” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesuusi asay dari dari biyaawaa be7iide, iita ayyaanaa, “Na7aa tullenne duude udeedda ayyaanaw, ha na7aappe kesa gaade neena ta azazay; qassi zaarethaade aani geloppa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","He iita ayyaanay waassiide, na7aa darissi kokkorssiide, aappe keseedda. Na7ay hayqqeeddawaa malatina, daro asay, “Na7ay hayqqeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Shin Yesuusi na7aa kushiyaa oyqqiide denthina, na7ay denddi eqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuusi soy geleeddawaappe guyyiyan, A kaalliyaawanttu Yesuusa dumma, “Nuuni he iita ayyaanaa kessanaw ayissi danddaybeykkoo?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesuusi zaariide, “Hewaa malay woosappenne xoomaappe attin, harabaan kesanaw danddayenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Unttunttu hewaappe denddiide, Galiilaanna aadhdhiide beeddino; Yesuusi bare de7iyaasaa ooninne erana mala koyyibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ayissi gooppe, I barena kaalliyaawantta “Taana, Asaa Na7aa, asay asaw aathiide immananne wodhana; taani qassi heezzu gallassaappe guyyiyan, hayquwaappe denddana” yaagiide tamaarissee. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Shin unttunttoo I giyaawe gelibeenna; qassi A oochchanawukka yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Unttunttu Qifirinaahooma giyaa katamaa beeddino; soy geleeddawaappe guyyiyan, Yesuusi unttuntta, “Ogiyaan ayaa palumettiitee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Shin unttunttu biidde ogiyaan, “Nu giddon nu ubbaappe aadhdhiyaawe oone?” yaagiide palumetteedda diraw, co77u geeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesuusi uttiide, tammanne laa77u barena kaalliyaawantta xeesiide unttuntta, “Ooninne sinthaw aadhdhana koyyooppe, ubbaappe guyye aadhdhiide, he ubbaw qooma gidanaw bessee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Itti guutha na7aa oyqqiide, unttunttu giddon esseedda; he guutha na7aa idimmiide unttuntta, ");
INSERT INTO dwrNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hawanttu mala guutha naanaappe ittuwaa ta sunthan mokkiyaa ooninne taana mokkee; qassi taana mokkiyaa ooninne taana kiitteeddawaa mokkiyaawaappe attin, ta xalalaa mokkenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohaannisi A, “Tamaarissiyaawoo, itti asay ne sunthan iita ayyaanatuwaa kessiyaawaa nuuni be7iide, nu bagga gidenna diraw, A diggeeddo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Shin Yesuusi yaageedda; “Ooninne ta sunthan malaataa oothiide, ellekka ta bolla iitabaa haasayanaw danddayiyaawe bayinna diraw diggoppite; ");
INSERT INTO dwrNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ayissi gooppe, nubaa eqettenna uray nu bagga. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taani hinttenttoo tumuwaa oday; hintte tawantta Kiristtoosawantta gidiyaa diraw, ooninne hinttenttoo ta sunthan buliyaa haathaa ushanaw immooppekka, bare gatiyaa akkanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Taana ammaniyaa ha guuthatuwaappe ittuwaa balethiya oonanne, gaacciyaa wogga woxaa A qoodhiyaan qachchiide, abbaan A oliyaawe aw lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ne kushii neena balethooppe, qanxxa ola; neeni laa77u kushiyaanna qassi ubbakka to7enna Gaannamiyaa tamaan geliyaawaappe, duuxa kushiyaanna de7uwaa geliyaawe new lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ne gedi neena balethooppe, qanxxa ola; neen laa77u gediyaanna ubbakka to7enna Gaannamiyaa tamaan yegettiyaawaappe, dooma gidaade de7uwaa geliyaawe new lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Ne ayfii neena balethooppe, wooca ola; neeni laa77u ayfiyaanna ubbakka to7enna Gaannamiyaa tamaan yegettiyaawaappe, itti ayfiyaanna Xoossaa kawutethaa geliyaawe new lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Qumaan maxiniyaa yeggiyaawaadan, tamay asaa ubbaa bolla yegettana. ");
INSERT INTO dwrNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maxinii lo77a; shin I mal77ana dhayooppe, zaariide A wooti mal77ethanitee? Hinttenttun maxinii de7o; yaatiide ittu ittuwaanna sarotethaan de7ite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuusi hewaappe denddiide, Yorddaanoosa Shaafaappe hefintha bagganna Yihudaa gadiyaa beedda. Cora asay shirettiide aakko shiiqina, kase I oothiyaawaadankka he asaa tamaarissuwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Itti itti Parisaawatuu paaccanaw Yesuusakko yiide, “Itti asay bare machchatto yeddanaw nuussi higgii azazii?” yaagiide A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","I zaariide, “Muse hinttentta waagi azazeeddee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Unttunttu, “Muse, ‘Itti asay bare machchatto paramaa immiide yeddo’ geedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesuusi zaariide unttuntta, “Hinttenttu odina sisennawantta gidiyaa diraw, Muse ha azazuwaa hinttenttoo xaafeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Shin Xoossay koyro medhdhiyaa wode, attuma asanne macca asa oothiide, unttuntta medhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Hewaa diraw, itti asay bare aabbanne bare daayo aggiide, bare machchattinna ittuwaa gidee; ");
INSERT INTO dwrNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","unttunttu laa77atuu itti asho gidiino; hewaa diraw, unttunttu itti asa gidiyaawaappe attin, laa77u asa gidikkino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hewaa diraw, Xoossay ittippe gatheeddawaa asay shaakkoppo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Unttunttu soy simmeedda wode, Yesuusa kaalliyaawanttu ha yewuwaabaa Yesuusa zaari oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesuusi unttuntta, “Bare machchatto yeddiide, hararo akkiyaa uray ooninne izinna woshummee. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Qassi maccawunnakka bare asinaappe kesaade hara asinaa gelooppe woshummaw” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yesuusi guutha naanaa bochchana mala, itti itti asay naanaa aakko aheedda; shin Yesuusa kaalliyaawanttu he asaa seereeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesuusi hewaa be7iide, barena kaalliyaawantta hanqqetteedda; unttuntta, “Guutha naanay taakko yiyaawantta diggoppite; ayissi gooppe, Xoossaa kawutethay hawanttu malaassa. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Taani hinttenttoo tumuwaa gay; Xoossaa kawutethaa guutha na7aadan akkenna uray ooninne he kawutethaa ubbakka gelenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Guutha naanaa idimmiide, bare kushiyaa unttunttu bolla huuphiyan huuphiyan wothiide, unttuntta anjjeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesuusi baanaw keseedda wode, itti bitani woxxiidde yi A sinthan gulbbatiide, “Lo77o tamaarssiyaawoo, medhinaa de7uwaa laattanaw taani ayaa oothoo?” yaagiide A oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesuusi, “Ayissi taana lo77oo gay? Xoossaa xalalaappe attin, hara lo77uu ooninne baawa. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xoossaa azazuwaa, ‘Wodhoppa; woshummoppa; wuu77oppa; wordduwaa markkattoppa; cimmoppa; ne aabbanne ne daayo bonchcha’ yaagiyaawaa eraasa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bitani Yesuusa, “Tamaarissiyaawoo, taani hewaa ubbaa na7atethaappe doommaade ha77i gakkanawukka naagay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesuusi bitaniyaa doseedda; A caddi xeelliide, “New ittibay pacceedda; baade new de7iyaabaa ubbaa zal77aade, he miishshaa hiyyeesaw imma; neen saluwan durettana. Yaatowaappe guyyiyan yaade taana kaalla” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Shin bitani hewaa sisiide, I daro dure gidiyaa diraw, bare som77iyaa dhumissiide, nashettennaan aggiide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesuusi barena kaalliyaawantta yuushshi aathi xeelliide, “Daro dure asay Xoossaa kawutethaa gelanaw waani metanddeeshsha!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A kaalliyaawanttu A haasayaa sisiide maalaletteeddino; shin Yesuusi qassikka unttuntta, “Naatoo, Xoossaa kawutethaa gelanaw wooti metanddeeshsha! ");
INSERT INTO dwrNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dure asay Xoossaa kawutethaa gelanawaappe, gaaluu marppiyaa xoo7iyaanna aadhdhanawe matattee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesuusa kaalliyaawanttu maalalettiide, “Yaatina, oone attanaw danddayiyaawe?” yaagiide ittu ittuwaa oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesuusi unttuntta caddi xeelliide, “Hawe Xoossaw danddayettiyaawaappe attin, asaw danddayettenna; ayissi gooppe, Xoossaw ubbabaykka danddayettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Phexiroosi Yesuusa, “Be7a; nuuni nubaa ubbaa aggiide, neena kaalleeddo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesuusi, “Taani hinttenttoo tumuwaa gay; ta dirawunne wonggalaa mishiraachchuwaa diraw, golliya woy ishatuwaa woy michchatuwaa, woy aawuwaa woy aatto woy machchatto, woy naanaa woy gadiyaa ageedda asay ooninne, ");
INSERT INTO dwrNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ha77i ha wodiyaan xeetu dakkuwaappe dariya golletuwaa, ishatuwaa, michchatuwaa, aatto, naanaa, gadiyaa, qassi metuwakka akkanawaa. Sinthappe yaana wodiyankka medhinaa de7uwaa akkanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Shin coratuu ha77i sinthan de7iyaawanttu guyye aadhdhana; qassi coratuu ha77i guyyen de7iyaawanttu sinthaw aadhdhana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Unttunttu Yeerusalaame biidde, ogiyaan de7iino; Yesuusi barena kaalliyaawanttuuppe sinthanna hamettee. Unttunttu maalaletteeddino; A kaalliyaawanttu yayyeeddino. Zaariide tammanne laa77u barena kaalliyaawantta gaxaa kessiide, barena gakkanabaa dummayiide unttunttussi hawaadan yaagiide odeedda; ");
INSERT INTO dwrNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Be7ite; nuuni Yeerusalaame ha77i kesoytte; yaani taana, Asaa Na7aa, qeesatuwaa kaappatuwassinne Muse higgiyaa tamaarssiyaawanttussi aathiide immana. Unttunttu ta bollan hayquwaa pirddaa pirddana; qassi Ayihuda gidenna asaassikka taana aathiide immana. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","He Ayihuda gidenna asay ta bolla qilliiccananne cuchchana; taana lissuwan shocananne wodhana; taani qassi heezzu gallassaappe guyyiyan, hayquwaappe denddana.” ");
INSERT INTO dwrNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zabiddiyoosa naanay Yayiqoobinne Yohaannisi Yesuusakko yiide, “Tamaarissiyaawoo, nuuni neena woossiyaabaa ubbabaa nuussi oothaarikkii” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesuusi unttuntta, “Taani hinttenttoo ayaa oothoo?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Unttunttu A, “Ne bonchcho kawutethaan neeni uttiyaa wode, nuuppe ittuwaa neeppe ushechcha bagganna qassi ittuwaa haddirssa bagganna utissaarikkii” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Shin Yesuusi unttuntta, “Hinttenttu ayaa woossanaw bessinttokka erikkita; taani ushanaw bessiyaa metuwaa xuu7aa ushanaw danddayiitee? Qassi taani xammaqettanaw bessiyaa xinqqataa xammaqettanaw danddayiitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hewaappe guyye unttunttu zaariide, “E danddayeetto” yaageeddino. Yesuusi qassi, “Taani ushanaw bessiyaa metuwaa xuu7aa hintte ushana; taani xammaqettanaw bessiyaa xinqqataakka hintte xammaqettana. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Shin taappe ushechcha baggannanne haddirssa bagganna uttanawantta dooriyawe taana gidikke; shin he sa7ay Xoossay immanaw giigissi wotheeddawanttussa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yokko tammu Yesuusa kaalliyaawanttu hewaa siseedda wode, Yayiqoobanne Yohaannisa hanqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesuusi unttuntta ubbaa barekko xeesiide, hawaadan yaageedda; “ ‘Ayihuda gidennawantta mooddiyaawantta’ giide qoppiyaawanttunne hewantta kaalethiyaa asatuu barenttu asaa mooddiyaawaa eriita. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Shin hintte giddon hewaa mala gidenna; hintte giddon woggatana koyyiyaa ooninne hinttenttoo qoomaa gidanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Qassi hintte giddon ubbaappe bolla gidana koyyiyaa ooninne hintte ubbaw ayille gidanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ayissi gooppe, haray atto taani, Asaa Na7aykka, asaw oothanawunne coratuwaa wozanaw yeeddawaappe attin, asay taw oothana mala yabeykke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Unttunttu Iyarkko giyaa katamaa beeddino; Yesuusi barena kaalliyaawanttunnanne cora asaanna Iyarkkoppe kesishshin, Ximoosa na7ay qooqay, Barxxamoosa giyaawe, ogiyaa doonan woossiidde utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Barxxamoos Naazireetiyaa Yesuusa gideeddawaa sisiide, bare kooshshaa dhoqqu oothiide, “Daawite na7aa Yesuusaa, taana maaraarikki!” yaagussaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cora asay A, “Hayzza!” giide hanqqetteedda. Shin, I bare kooshshaa kasewaappekka darissi dhoqqu oothiide, “Daawite na7aw, taana maaraarikki!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesuusi ogiyaan eqqiide, “A haa xeesite” yaageedda. Unttunttu qooqaa, “Aynne baawa; dendda eqqa; neena xeesee” yaagiide xeeseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Qooqay bare mayuwaa olii aggiide, guppi denddi eqqiide, Yesuusakko beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuusi A, “Taani new ayaa oothanaw koyyay?” yaageedda. Qooqay, “Tamaarissiyaawoo, taani xeellanawaa koyyay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesuusi A, “Ba; ne ammanuu neena patheedda” yaageedda. Elekka A ayfii xeellii aggina, ogiyaan Yesuusa kaallii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Unttunttu Yeerusalaame matiidde, Debre Zayte Deriyaa matan de7iyaa Beetefaagenne Biitaaniyaa gakkeeddino; Yesuusi barena kaalliyaawanttuppe laa77uwaa sinthaw kiittiide, ");
INSERT INTO dwrNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Hinttenttuppe sinthan de7iyaa heraa biite; yaa gelosaanna ooninne ubba toggibeenna qashuwan de7iyaa hare maraa hintte demmana; A billi haa akkiide yiite. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ooninne hinttentta, ‘Hewaa ayissi oothite?’ yaagiide oochchooppe, ‘Godaw hawe koshshee; ellekka zaari haa yeddanawaa’ yaagite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Unttunttu biide, hare maraa penggiyaa matan ogiyaan qachchi wotheeddawaa demmiide billeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hewaan eqqeedda itti itti asatuu unttuntta, “Hare maraa wootanaw billiitee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesuusa kaalliyaawanttu Yesuusi barentta azazeeddawaa odina, asatuu yeddii aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Unttunttu hare maraa Yesuusakko ahiide, barenttu mayuwaa A zokkiyaan wotheeddino; Yesuusi he hare maraa toggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Cora asay barenttu mayuwaa ogiyaan hiixxeedda; qassi harantuu mithaa haythaa kar kariide, ogiyaan hiixxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesuusappe sinthanna hamettiyaa asaynne A geeduwaa kaalliyaa asay barenttu kooshshaa dhoqqu oothiide, “Xoossay galatetto! Godaa sunthan yiyaawe anjjetteeddawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Godaa sunthan yiyaa nu aawuwaa Daawite kawutethay anjjetteeddawaa. Saluwaa ubbaappe bolla saluwan de7iyaa Xoossay galatetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesuusi Yeerusalaame biide, Geeshsha Golliyaa geleedda; qassi ubbabaa yuuyyi yuuyyi xeelleeddawaappe guyyiyan, sa7ay qammiyaa diraw, tammanne laa77u Yesuusa kaalliyaawanttunna Biitaaniyaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wonttetha gallassi unttunttu Biitaaniyaappe kesiide biishshin, Yesuusi koshatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Haakuwan itti balasiyaa giyaa mithatto haythaa mayya utteeddawunno be7iide, ooni eri I bolla ayfii beettooppenne giide, be7anaw izikko beedda; shin izikko I biyaa wode, haythaa xalalaappe attin, aynne ayfiyaa demmibeenna; ayissi gooppe, balasii ayfiyaa wodii gakkibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesuusi he balasatto, “Neeppe shirettiide medhinaw ooninne ayfiyaa mooppo” yaageedda. Yesuusa kaalliyaawanttu I giyaawaa siseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Unttunttu Yeerusalaame beeddino; Yesuusi Geeshsha Golliyaa geliide, hewaan zali77iyaawanttanne shammiyaawantta kare yederssuwaa doommeedda; qassi miishshaa laammiyaawanttu xaraphpheezaanne dogommuwaa zali77iyaawanttu oydiyaa aathi yeggiide, ");
INSERT INTO dwrNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ooninne ayentto tookkiide, Geeshsha Golliyaa gibbiyaa giddonna aadhdhanawaa diggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yesuusi asaa hawaadan yaagiide tamaarisseedda: “Xoossaa Maxaafan, ‘Ta golli Ayihuda gidenna asay ubbay Xoossaa woossiyaa golle geetettana’ yaagettiide xaafeetti utteedda; shin hintte A bonqqanchchatuu qosettiyaa gonggoluwaa kesseeddita.” ");
INSERT INTO dwrNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Qeesatuwaa kaappatuunne Muse higgiyaa tamaarssiyaawanttu hewaa sisiide, A wodhana ogiyaa koshshaa doommeeddino; shin cora asay I tamaarissiyaawaan maalalettiyaa diraw, aw yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sa7ay omarsseedda wode, Yesuusinne A kaalliyaawanttu katamaappe gaxaa keseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Unttunttu wonttetha gallassi guura ogiyaanna aadhdhiidde, he balasatta xaphuwaanna meladiggeeddawunno be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Phexiroosi hassayiide, “Tamaarissiyaawoo, be7a; neen sheqqeedda balasatta meladiggaaddu” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesuusi zaariide, unttuntta hawaadan yaageedda; “Xoossaa ammanite. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Taani hinttenttoo tumuwaa gay; ooninne bare wozanaan sidhennaan bare geeddabay hananawaa ammaniide, ha deriyaa, ‘Denddaade abbaan kundda’ gooppe hanana. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hewaa diraw, Xoossaa hintte woossiyaabaanne oochchiyaabaa ubbaa akkidiggowaadan ammanite; hintte akkana. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Xoossaa woossanaw hintte eqqiyaa wode, saluwan de7iyaa hintte Aawuu hintte nagaraa atto gaana mala, ooninne hinttentta naaqqeeddabay de7ooppe, aw atto giite. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Shin asaa nagaraa hintte atto gaana dhayooppe, saluwan de7iyaa hintte Aawuukka hintte nagaraa hinttenttoo atto geenna.” ");
INSERT INTO dwrNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Unttunttu qassikka Yeerusalaame beeddino; Yesuusi Geeshsha Golliyan hamettishshin, qeesatuwaa kaappatuu, Muse higgiyaa tamaarissiyaawanttunne cimatuu Yesuusakko yeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","A, “Neeni hawaa oothanaw new ay maatay de7ii? Woy new ha maataa immeeddawe oone?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesuusi zaariide unttuntta, “Taanikka hinttentta ittibaa oochchana; taw odite; taani qassi hawaa ay maataan oothaytantto, hinttenttoo odana. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohaannisi xammaqiyaa maataa akkeeddawe Xoossaappeeyee woy asaappee? Taw odite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Unttunttu barenttu giddon palumaa doommiide, “Nuuni, ‘Xoossaappe yeedda’ yaagooppe, I nuuna, ‘Yaatina, Yohaannisi odeeddawaa ayissi ammanibeykkitee?’ yaagana. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Shin, ‘Asaappe yeedda gaanee?’ ” yaageeddino; qassi asay ubbay Yohaannisi nabiyaa gideeddawaa eriyaa diraw, asaw yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hewaa diraw, unttunttu Yesuusaw, “Nuuni erokko” yaagiide zaareeddino; Yesuusi, “Taanikka hawaa ay maataan oothaytantto, hinttenttoo odikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuusi unttunttoo oduwaa leemisuwan yaagiide doommeedda; “Itti bitani woyiniyaa giyaa turaa tokkiide, dirssaa yuushshi aathiide direedda; qassi he woyiniyaa gumi77iyaa ollaakka bookkeedda; hewaa naagiyaa asaw naagiyaasaa keexxeedda; hewaappe guyyiyan, kothaa oothiyaa asaw immiide, hara gade beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Woyiniyaa ayfiyaa maxiyaa wodii gakkina, barena gakkiyawaa akkiide yaana mala, itti qoomaa bare kothaawatuwaakko kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kothaa oothiyaawanttu A qoomaa oyqqi wadhdhiide, kushe mela yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Laa7ethuwaa hara qoomaa unttunttukko kiitteedda; unttunttu he qoomaa huuphiyaa phalqqiide pokkissi yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Woyiniyaa turaa goday qassikka hara qoomaa kiitteedda; he qoomaa wodheeddino; qassi hara coratuwakka hewaadan ootheeddino; ittuwaa ittuwaa wadhdhiide, haratuwaa wodheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Woyiniyaa turaa godaw kiittanaw ubbaappe wurssethaan I darii siiqiyaa A na7aa xalalay atteedda; I, ‘Unttunttu ta na7aa bonchchennaan aggikkino’ giide, bare na7aa unttunttukko kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Shin kothaa oothiyaawanttu barenttu giddon, ‘Laattanawe hawaa; biide A wodhoytte; aw de7iyaawe nuwaa gidana!’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na7aa oyqqi wodhiide, A anhaa woyiniyaa turaa giddoppe gaxaa kessi oleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Simmi woyiniyaa turaa goday wootanee? Yiide he kothawatuwaa wodhi wurssiide, woyiniyaa turaa kothaa oothiyaa hara asaw immanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","‘Gimbbiyaawanttu kadhi ixxeedda shuchchay godaa xaphuwaa minissiyaa, ubbaappe aadhdhiyaa shuchcha gideedda. Hawe Goday ootheeddawaa; qassi nuunakka maalalissiyaawaa’ yaagiyaawaa Xoossaa maxaafaappe nabbabibeykkitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Qeesatuwaa kaappatuu, higgiyaa tamaarissiyaawanttunne cimatuu Yesuusi he leemisuwaa barenttun leemiseeddawaa ereedda diraw, A oyqqanaw koyyeeddino; shin asaw yayyiide, bashi beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Qassi A haasayaappe balaa demmana mala, Parisaawatuwaappenne Heroodisa baggatuwaappe amareeddawanttu aakko kiittina yiide, ");
INSERT INTO dwrNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","“Tamaarissiyaawoo, neeni tumuwaa haasayiyaawaanne asaappe asaa shaakkeennawaa nuuni ereetto; ayissi gooppe, neeni asaa dummayakka; qassi Xoossaa ogiyaa tumatethaan tamaarissaa. Nuuni Roomaa Kaatiyaa Qeesaarew giiraa giiriyaawe wogeeyee woga gidennee? Giiraa giiraneeyee digganee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Shin unttunttu lo77a malatiyaa iita asaa gideeddawaa Yesuusi eriide, “Taana ayissi paacciitee? Itti santtimiyaa haa taakko ahite; taani ane be7ana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Unttunttu aw aheeddino; “Ha malaynne sunthay oowee?” yaagiide unttuntta oochcheedda. Unttunttu, “Qeesaarewaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesuusi zaariide unttuntta, “Yaatooppe, Qeesaarewaa Qeesaaressi, Xoossaawaa Xoossaassi immite” yaagina unttunttu aabaa maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hayqqeedda asay denddenna giyaa Saduqaawanatuwappe itti itti asatuu Yesuusakko yiide, hawaadan yaagiide, A oochcheeddino; ");
INSERT INTO dwrNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tamaarissiyaawoo, Muse nuussi higgiyaa xaafiidde, ‘Machchatto akkeedda asay na7aa yelennaan hayqqooppe, he hayqqeeddawaa ishay A machchatto laattiide, bare ishaw na7aa yelanaw bessee’ yaagiyaawaa xaafeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Itti wode laappu ishatuu de7iyaawanttuppe bayray machchatto akkiide, na7aa yelennaan hayqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Laa7ethiyaa ishay izo akkeedda; ikka na7aa yelennaan hayqqeedda; heezzenthiyaawekka hewaadan haneedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Laappunatuukka izo akkiide, na7aa yelennaan hayqqeeddino; ubbaappe guyyiyan, qassi he mishiratta hayqqaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yaatina, hayqqeedda asay hayquwaappe denddiyaa wode, iza unttunttuppe haqawoo machche gidanee? Ayissi gooppe, laappunatuukka izo akkeeddino”. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesuusi zaariide unttuntta, “Hinttenttu balettiyaawe, Xoossaa Maxaafatuwaanne A wolqqaa erenna diraassa! ");
INSERT INTO dwrNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ayissi gooppe, hayqqeedda asay hayquwaappe denddiyaa wode, saluwan de7iyaa kiitanchchatuwaa mala gidanaappe attin, attuma asaynne akkenna; macca asaynne gelenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Shin hayqqeeddawanttu dendduwaabaa gidooppe, Muse maxaafan xaafetteedda xaragay miyaa buuraabaa odiyaa sa7aan, Xoossay Musa, ‘Taani Abraahaame Xoossaa, Yisaaqa Xoossaa, Yayiqooba Xoossaa’ gidiyaawaa ubbakka nabbabibeykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","I paxa de7iyaawanttu Xoossaa gidiyaawaappe attin, hayqqeeddawanttu Xoossaa gidenna; hintte darissi baleeddita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Higgiyaa tamaarissiyaawanttuppe ittu unttunttu palumettiyaawaa shiiqiide siseedda; qassi Yesuusi unttunttoo lo77o zaareeddawaa sisiide, “Azazuwaa ubbaappe aadhdhiyaa azazuu haqawee?” yaagiide Yesuusa oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesuusi zaariide, A “Azazuwaa ubbaappe aadhdhiyaa azazuwaa, ‘Israa7eeliyaa asay sisite, Goday nu Xoossay itti Godaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Hinttenttu Godaa hintte Xoossaa hintte kumentha wozanaappe, hintte kumentha shemppuwaappe, hintte kumentha qofaappe, hintte kumentha wolqqaappe siiqite’ yaagee. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Qassi azazuwaa ubbaappe aadhdhiyaa laa7entho azazuu hawaa; ‘Neeni ne shooruwaa ne huuphiyaadan siiqa’ giyaawaa; hawanttuppe aadhdhiyaa hara azazuu baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Higgiyaa tamaarissiyaawe Yesuusa yaageedda; “Tamaarissiyaawoo, tumuwaa gaadda; neeni ‘Xoossay itti Xoossa xalala. Aappe attin, haray baawa’ geeddawe tuma. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Xoossaa kumentha wozanaappe, kumentha qofaappenne kumentha wolqqaappe dosiyaawenne qassi bare shooruwaakka bare huuphiyaadan siiqiyaawe, guuddiyaa yarshshuwaappenne hara yarshshuwaa ubbaappe aadhdhee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesuusi higgiyaa tamaarssiyaawaa zaaruu aadho eranchcha asaa zaaruwaa gideeddawaa be7iide, “Neeni Xoossaa kawutethaappe haakkabeykka” yaageedda; hewaappe guyyiyan, Yesuusa harabaa oochchanaw ooninne xalibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuusi Geeshsha Golliyan tamaarissiidde, “Higgiyaa tamaarssiyaawanttu Kiristtoosa wooti Daawite na7aa giinoo? ");
INSERT INTO dwrNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daawite barena Geeshsha Ayyaanay haasayissina, ‘Goday ta Godaa, “Taani ne morkketuwaa neeni yedhdha eqqiyaabaa oothana gakkanaw, hawaan taappe bonchchettaade ushechcha bagganna utta” geedda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daawite bare huuphew Kiristtoosa, ‘Godaa’ giide xeesooppe, yaatina, Kiristtoosi waaniide, Daawite na7aa gidii?” yaageedda. Cora asay Yesuusi giyaawaa nashechchaan siseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuusi tamaarissiidde, “Higgiyaa tamaarissiyaawanttuppe naagettite; unttunttu adussa mayuwaa mayyiide yuuyyiyaawaanne geyaa heerankka asay unttuntta bonchchiide sarotiyaawaa dosiino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Unttunttu Ayihuda woosa golletuwaan darii lo77iyaa oydiyaa dosiino; qassi asay barentta imathatethaan mokkiyaasankka bonchcho sa7aa dosiino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Unttunttu am77etu golliya bonqqiidde, barenttoo lo77a malatanaw Xoossaa woosaa adussiino; unttunttu ubbaappe aadhdhiyaa muraa akkanawantta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuusi Geeshsha Golliyan imotaa yeggiyaa saaxniyaa matan uttiide, asay bare miishshaa he saaxniyaan yeggiyaawaa be7eedda; cora dure asay daro miishshaa he saaxniyaan yeggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Itti hiyyeesaa am77atta yaade, itti santtimiyaan laamettiyaa laa77u sembberatuwaa he saaxniyaan yeggaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesuusi barena kaalliyaawantta xeesiide, “Taani hinttenttoo tumuwaa gay; imotaa saaxniyaan yeggeedda asaa ubbaappe ha hiyyeesaa am77atta darissaade yeggaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ayissi gooppe, haratuu ubbay barenttoo palaheedda miishshaappe yeggeeddino; shin iza bare pacaappe, barew de7iyaa de7uwaa mulekka immaa aggaaddu” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuusi Geeshsha Golliyaappe kesishshin, A kaalliyaawanttuppe ittu A, “Tamaarissiyaawoo, hawe aybe lo77o shuchchatenttonne qassi aybe lo77o shuchchaa gollatuwaa be7ay!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesuusi zaariide, “Ha wolqqaama shuchchaa gollatuwaa be7ay? Ha gollatuwaan de7iyaa itti shuchchaynne attennaan ubbay kolettana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesuusi Geeshsha Golliyaappe hini bagganna Debre Zayte Deriyaa bollan utteedda wode, Phexiroosi, Yayiqoobi, Yohaannisinne Inddiraasi barenttu xalala aakko yiide A, ");
INSERT INTO dwrNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Hewe awude hananentto, nuussi odaarikkii; qassi hewe ubbay polettana wodiyaa erissiyaa mallatuu ayaa gidanee?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesuusi qassi unttunttoo hawaadan yaagiide, oduwaa doommeedda; “Hinttentta ooninne balethenna mala naagettite. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Cora asatuu ta sunthan, ‘Taani Kiristtoosa’ yaagiidde yaanawaa; cora asaa balethana. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Matan de7iyaa olaa kooshshaanne haakuwaan de7iyaa olaa oduwaa hintte sisiyaa wode, hirggoppite; hewaa malabay hananaw bessee; shin wurssethay bira. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ayissi gooppe, itti gade asay hara gade asaanna olettana; qassi itti kawutethay hara kawutethaanna olettana; biittaa qaathay ubbasan de7ana; koshaykka de7ana; shin hewe koyro yeluwaa oythaa mala. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Shin hintte hinttenttu huuphew naagettite; ayissi gooppe, asay hinttentta oyqqiide, pirdda gollew aathiide immana; qassi bare Ayihuda woosa golletuwanikka hinttentta lissuwan shocana; gadiyaa mooddiyaawanttu sinthaaninne kaatatuwaa sinthan ta diraw hintte markkattanaw eqqana. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mishiraachchuwaa qaalay koyronna asaw ubbaw odettidigganaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Unttunttu hinttentta pirdda golle ahiyaa wodenne aathiide immiyaa wode, wooti haasayanitentto koyronna hirggoppite; he saatiyaan Xoossay hinttenttoo immiyaabaa haasayite. Ayissi gooppe, Geeshsha Ayyaanay haasayanaappe attin, haasayiyaawanttu hinttentta gidikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ishay bare ishaa, aawuu bare na7aa wodhissana; qassi naanay barenttu aawatuwa bollaninne barenttu aayetuwaa bolla denddiide, unttuntta wodhissana. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Asay ubbay hinttentta ta sunthaa diraw ixxana; shin wurssethay gakkanaw gencciyaawe attana. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Shin nabiyaa Daaneel odeedda bashshaa tunatethay eqqanaw bessennasan eqqishshin hintte be7iyaa wode, hewe waagiyaawentto, nabbabiyaawe akeeko; Yihudaa gadiyaan he wode de7iyaawanttu deriyaakko betino. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Golliyaa huuphiyan de7iyaa uraykka ittibaa akkanaw duge wodhdhiide, bare soy geloppo. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gaden de7iyaawekka bare mayuwaa akkanaw guyye simmoppo. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","He wode shahaara maccawanttoonne dhanthiyaa maccawanttoo aayyeero. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Shin hawe ubbay haniyaa wodii balgguwaa gidenna mala, Xoossaa woossite; ");
INSERT INTO dwrNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ayissi gooppe, Xoossay sa7aa koyro medhdheeddawaappe doommiide, ha77i gakkanaw, ubbakka de7ibeenna metuu, qassi hawaappe sinthawukka ubba de7enna metuu asaa bolla he wode de7ana. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Goday he gallassatuwaa payduwaa guuthiyaawe baawentto, asaa gideedda ooninne attenna; shin I bare dooreedda asatuwaa diraw, he gallassatuwaa payduwaa guutheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“He wode ooninne hinttentta, ‘Be7ite; Kiristtoosi hawaan de7ee’ woy, ‘Be7ite; Kiristtoosi hewaan de7ee’ yaagooppe, hewaa ammanoppite. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ayissi gooppe, worddanchcha Kiristtoosatuunne worddo nabatuu denddiide barenttoo danddayettooppe, haray atto Xoossay dooreeddawanttakka balethanaw malaataanne maalalissiyaabaa bessana. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Shin hintte naagettite; taani hinttenttoo ubbabaa kasetaade odaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Shin he wode he waayyiyaappe guyyiyan, away dhumaana; agenay poo7iyaawaa aggana; ");
INSERT INTO dwrNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","xoolinttatuu saluwaappe kunddana; qassi saluwan de7iyaa wolqqatuukka qaaxettana. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","He wode taani, Asaa Na7ay, wolqqaama wolqqaannanne bonchchuwaanna shaariyaa giddonna yiishshin, unttunttu be7ana. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","He wode taani kiitanchchatuwaa sa7aa oyddu bagga kiittana; sa7aa gaxaappe saluwaa gaxaa gakkanaw, Xoossay dooreedda asaa shiishshana. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Leemisuwaa balasatto giyaa mithattippe tamaarite; balasatta aaciya wodenne izi haythay haytiyaa wode, bonii mateeddawaa hintte eriita. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hawaadankka hintte he ubbabay haniyaawaa be7iyaa wode, I matattiide penggiyaa shiiqeeddawaa erite. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Taani hinttenttoo tumuwaa oday; ha ubbabay hanana gakkanaw, ha wodiyaa yeletay hayqqidiggenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Saluunne sa7ay aadhdhana; shin ta qaalay ubbakka aadhdhenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Shin he gallassaanne he saatiyaa Aawuwaa xalalaappe attin, haray atto saluwan de7iyaa kiitanchchatuwaa gidina, woy taana Na7aa gidinakka ooninne eriyaabay baawa. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","He wodii awude gidanentto, hintte erenna diraw, naagettite; minnite; Xoossaa woossite. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ta yuussay bare golliya aggiide, ogiyaa biyaa bitaniyaa mala; bitani bare qoomatuwassi huuphiyaan huuphiyaan oosuwaa immiide, unttuntta bare oosuwaassi kaappo ootheedda; qassi kariyaa naagiyaawekka minissiide naagana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Hewaa diraw, minnite; ayissi gooppe, golliyaawu omarssa gidina, woy qamma bilahe gidina, woy kuttuu waassiyaa wode gidina, woy guura wonttumaathaana gidina awude yaanentto, hintte erikkita. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Hinttenttu akeekennaan I yooppe, hinttentta gemi77isheeddawantta demmenna mala minnite. ");
INSERT INTO dwrNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Taani hinttenttoo odiyaawaa asaa ubbaw oday; minnite.” ");
INSERT INTO dwrNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Paasigaa Baalaa giyaawaa bonchchiya gallassaynne Caalibeenna ukithaa muussaa bonchchiya baalaa gallassay gakkanaw laa77u gallassay atteedda; qeesatuwaa kaappatuunne higgiyaa tamaarssiyaawanttu asay erennaan Yesuusa oyqqiide wodhana ogiyaa koyyiino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Asay walassaa kessenna mala, Paasigaa bonchchiya gallassi hewaa oothokko” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuusi Biitaaniyaa gadiyan oolluwaa harggiyaa Simoona soyin qumaa maanaw utteedda wode, itti mishiratta bilqqaasiyaa kumeedda narddoosa giyaa darii al77o shittuwaa akkaade yaaddu; he bilqqaasiyaa menthaade shittuwaa Yesuusa huuphiyan tigaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Hewaan de7iyaa asaappe ittu ittu hanqqettiide, “Ha shittuwaa coo ayaw bayizzay? Ha shittuwaa heezzu xeetu biraa santtimiyaan zali77iide, miishshaa hiyyeesaw immanaw danddayettee” yaagiide barenttu giddon haasayiino; yaatiide he mishiratto darissi hanqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Shin Yesuusi hawaadan yaageedda; “Ha mishiratto aynne gooppite; izo ayissi metoothiitee? Iza taw lo77obaa oothaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hiyyeesatuu ubba wode hinttenttunna de7iino; hintte koyyeedda wode awudenne unttuntta maaddanaw danddayiita; shin taani ubba wode hinttenttunna de7ikke. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iza barew danddayetteeddawaa oothaaddu; qassi ta asatethay moogettanaappe kasetaade moogoo giigissanaw shittuwaa okkaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Taani hinttenttoo tumuwaa oday; sa7aa ubbaan wonggalaa mishiraachchuwaa odiyaasan haqaninneekka, asay izo qoppana mala, ha iza ootheeddawe odettana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tammanne laa77u Yesuusa kaalliyaawanttuppe ittuu Yihudaa Asqqorootu giyaawe, Yesuusa qeesatuwaa kaappatuwaassi aathiide immanaw unttunttukko beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Unttunttu hewaa siseedda wode nashettiide, “Nuuni new miishshaa immana” yaageeddino; Yihudaa Asqqorootu Yesuusa aathiide immanaw injjetiyaa wodiyaa wochchee. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Caalibeenna ukithaa miyaa baalaa gallassaa bonchchiya koyro gallassi, Paasigaa qumaa maanaw dorssaa shukkiyaa wode, Yesuusa kaalliyaawanttu A, “Paasigaa bonchchiya gallassi neeni maana qumaa nuuni haqa biide giigissanee?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesuusi barena kaalliyaawanttuppe laa77atuwaa hawaadan yaagiide kiitteedda; “Katamaa biite; hintte biishshin, otuwan haathaa tookkeedda itti bitani hinttenttunna gakettanawaa; A kaallite. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","I biide geliyaa golliyaawuwaa, ‘Tamaarissiyaawe neena, “Taani taana kaalliyaawanttunna Paasigaa qumaa maanaw ta imathaa kifili haqanee?” yaagee’ yaagite. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Golliyaawuu hinttentta pooqiyaa bollan de7iyaa giigi utteedda aako kifiliyaa bessana; hewaan nuussi giigissite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","He laa77u Yesuusa kaalliyaawanttu kesiide, katamaa beeddino; Yesuusi barenttoo odeeddawaadankka ubbabaa demmiide, Paasigaa qumaa giigsseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sa7ay omarssiyaa wode Yesuusi tammanne laa77u barena kaalliyaawanttunna yaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Unttunttu uttiide samppaappe qumaa miishshin, Yesuusi unttuntta, “Taani hinttenttoo tumuwaa oday; hinttenttuppe ittu taananna miyaawe, taana aathiide immanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A kaalliyaawanttu loythi sisettina, huuphiyan huuphiyan A, “Tumu taaneeshsha?” giyaawaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesuusi zaariide, “I ha hinttenttu tammanne laa77atuwaappe ittuwaa; I taananna ittippe tushanaw bare daabbuwaa shaataan yeddiyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Taani, Asaa Na7ay, Xoossaa maxaafay hayqqana geeddawaadan hayqqana; shin taana, Asaa Na7aa, aathiide immiyaa uraw aayyeero; he uray yelettennaan atteeddentto, aw lo77a shin” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Unttunttu miishshin, Yesuusi daabbuwaa akkiide, Xoossaa galateedda; he daabbuwaa menthiide, barena kaalliyaawanttoo immiidde, “Heyte; hawe ta ashuwaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Xuu7aa akkiide, Xoossaa galatiide, unttunttoo immeedda; ubbay he xuu7aappe usheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesuusi, “Hawe ooratha caaquwaan cora asaa diraw gukkiyaa ta suuthaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Taani hinttenttoo tumuwaa oday; taani Xoossaa kawutethaan ooratha woyiniyaa eessaa ushana gallassay gakkanaw, laa7enthuwaa ha woyiniyaa eessaa ubbakka ushikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mazimuriyaa yexxeeddawaappe guyyiyan, Debre Zayte Deriyaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuusi barena kaalliyaawanttoo, “Hinttenttu ubbay taana yeggiide woxxanita; ayissi gooppe, Xoossaa Maxaafay, ‘Xoossay dorssaa heemmiyaawaa wodhana; hewaappe guyyiyan dorssay ubbay laalettana gee’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Shin taani hayquwaappe denddeeddawaappe guyyiyan, hinttenttuppe kasetaade Galiilaa baana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phexiroosi zaariide, “Unttunttu ubbatuu neena yeggiide booppekka, taani neena mulekka yeggikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesuusi Phexiroosa, “Taani new tumuwaa oday; hachche qamma kuttuu laa7ethuwaa waassanaappe kase, neen taana heezzu gede kaddanaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Shin Phexiroosi kasewaappekka minissiide, “Taani haray atto, neenanna ittippe hayqqinttokka, neena mulekka kaddikke” yaageedda. Qassi haratuu ubbatuukka hewaadan geeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Geetesemaane giyaa sa7aa beeddino; Yesuusi barena kaalliyaawantta “Taani Xoossaa woossanaassi, hinttenttu hawaan uttiishshite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesuusi Phexiroosa, Yayiqoobanne Yohaannisa barenanna afeedda; darii kayyotteeddanne metooteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Qassi unttuntta, “Taani hayqqana gakkanawukka kayyottay; hawaan takkishshite; gemi77ishoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Guuthaa sinthakko shiiqiide, sa7aan guufanniide, danddayettiyaawaa gidooppe, he wodii bareppe aadhdhana mala, Xoossaa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Qassikka, “Abbabbo, ta Aabboo, ubbabay new danddayettee; ha xuu7aa taappe digga; shin ne sheniyaadan hanoppe attin, ta sheniyaadan hanoppo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesuusi barena kaalliyaawanttukko simmi yiide, gemi77isheeddawantta demmiide Phexiroosa, “Simoonaa, gemi77ishaaddii? Neen itti saatenttonne naaganaw danddayabeykkii? ");
INSERT INTO dwrNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Paaciyaan hintte gelenna mala, naagettitenne Xoossaa woossite; ayyaanay giigi utteedda; shin ashuu daaburanchcha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Qassikka biide kasewaadankka Xoossaa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A kaalliyaawanttukko guyye simmiide I yiyaa wode, gemi77isheeddawantta demmeedda; unttunttu ayfiyaa gemi77ishuu goozzi wotheedda diraw, aw ayaa haasayiinonttokka eribeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Heezzenthuwaa unttunttukko yiide, “Ha77i gakkanawukka gemi77ishiiteenne shemppiitee? Gidana; wodii gakkeedda; be7ite, taana, Asaa Na7aa, nagaranchcha asatuwaa kushiyaan aathiide immiyaa wodii gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Denddina boytte; be7ite, taana aathiide immiyaawe haweku gakkeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuusi hewaa biro haasayishshin, tammanne laa77u A kaalliyaawanttuppe ittuu, Yihudaa Asqqorootu, ellekka gakki wodhdheedda; qassi qeesatuwaa kaappatuu higgiyaa tamaarissiyaawanttunne cimatuu kiittina, mashshaanne xam77aa oyqqeedda cora asay aananna ittippe yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yesuusa aathi immiyaawe he cora asaw, “Taani yeriyaawe A; A oyqqiide loythi naagiide, afite” yaagiide mallaa odi wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yihudaa Asqqorootu gakkosaannakka Yesuusakko shiiqiide, “Tamaarissiyaawoo” yaagiide Yesuusa yeri akkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","He cora asay Yesuusa minissi oyqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Shin matan eqqeeddawanttuppe ittuu bare cubiyaa shoddinne qeesatuwaa ubbatuwaa kaappuwaa qoomaa shociide, A haythaa qanxxi oleedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuusi zaariide, he shiiqeedda cora asaa, “Taana bonqqanchcha kessiide, bonqqanchchaa oyqqiyaawaadan oyqqanaw cubiyaanne xam77aa oyqqiide yeedditee? ");
INSERT INTO dwrNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Taani Geeshsha Golliyan tamaarissaadde, gallassan gallassan hinttenttunna de7iyaa wode taana oyqqibeykkita; shin Xoossaa Maxaafatuu geeddawe polettanaw bessee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesuusa kaalliyaawanttu ubbatuu A yeggiide bii aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Naxalaa xalalaa mayyeedda itti yalaga bitani Yesuusa kaalliyaawaa asay oyqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Shin he bitani naxalaa oliide, kallo xiira woxxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Asay Yesuusa qeesatuwaa ubbatuwaa kaappuwaa soy, qeesatuwaa kaappatuwaa ubbatuu, cimatuunne higgiyaa tamaarssiyaawanttu shiiqeeddasaa afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phexiroosi qeesatuwaa ubbatuwaa kaappuwaa dirssaa gidduwaa gakkanaassi haakuwaan A kaalleedda; yaani naagiyaawaanna tamaa kashiidde, utti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Qeesatuwaa kaappatuunne hewaan shiiqeedda asay ubbay Yesuusa wodhanaw A bolla markkaa koyyeeddino; shin aynne demmibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ayissi gooppe, cora asatuu A bollan wordduwaa markkatteeddino; shin unttunttu markkatethay itti mala gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Itti itti asatuu denddi eqqiide Yesuusa bolla, “I, ‘Taani asay keexxeedda ha Geeshsha Golliyaa kolaade, asay keexxibeenna hara Geeshsha Golliyaa heezzu gallassaa giddon keexxana’ giishshin, nuuni siseeddo” yaagiide wordduwaa markkatteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Shin haray atto unttunttu markkatethay hewaan itti mala gidibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Qeesatuwaa ubbatuwaa kaappuu asaa ubbaa sinthan denddi eqqiide Yesuusa, “Hawanttu neena mootiyaa mootoo new zaariyaabay baawee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Shin Yesuusi co77u giide, aynne zaaribeenna; qeesatuwaa ubbatuwaa kaappuu A, “Anjjetteedda Xoossaa Na7ay Kiristtoosi neenee?” yaagiide laa7enthuwaa oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesuusi zaariide, “E, taana; hintte taana, Asaa Na7aa, wolqqaama Xoossaappe ushechcha bagganna uttide7ishshinanne saluwaa shaariyaanna yiishshin be7ana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Qeesatuwaa ubbatuwaa kaappuu bare mayuwaa peedhi oliide, “Nuuna hawaappe sinthan ayissi hara markkaa koshshii? ");
INSERT INTO dwrNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hinttenttu A boriyaa siseeddita; hintte qofay ayee?” yaageedda; unttunttu ubbay, “I hayqqana bessee” yaagiide A bolla pirddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Unttunttuppe ittu ittu A bolla cushethaa doommeeddino; A ayfiyaa kammi dechchiide, “Neena dechcheeddawe oone? Ane timbbitiyaa oda!” yaageeddino; qassi naagiyaawanttukka A qinxxalliyaa baqqiidde afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Phexiroosi dirssaa giddon hirkkinna de7ishshin, qeesatuwaa ubbatuwaa kaappuwaa macca ashikkaratuwaappe ittinna yaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Phexiroosi tamaa kashiyaawaa be7aade, cadda xeellaade, “Neenikka Naazireetiyaa Yesuusanna ittippe de7aa” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Shin Phexiroosi, “Neeni giyaawe ayentto taani erikke; taw akeekettenna” yaagiide kaddeedda; yaatiide dirssaa penggiyaakko keseedda; kuttuukka waasseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","He ashikkaratta Phexiroosa be7aade, A matan eqqeedda asatuwaa, “Ha bitaniikka unttunttunna de7ee” gaade gujjaade oduwaa doommaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Shin Phexiroosi qassikka kaddeedda. Guuthaa gami77ishshin, matan eqqeedda asatuu laa7enthuwaa Phexiroosa, “Neeni tuma unttunttunna ittippe de7aa; ayissi gooppe, neeni Galiilaa gadiyaa asaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Shin Phexiroosi, “Taani hewaa hintte giyaa bitaniyaa erikke!” yaagiide barena sheqaanne caaquwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Elekka kuttuu laa7ethuwaa waassii aggeedda; Phexiroos barena Yesuusi, “Neeni kuttuu laa7ethuwaa waassanaappe kase heezzu gede taana kaddanaassa” geeddawaa hassayiide, darii yeekkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wontta guuran ellekka qeesatuwaa kaappatuu cimatuwaannannee Muse higgiyaa tamaarissiyaawaanttunna hewaan shiiqeedda Ayihuda shanggatuwaa ubbaanna maqqettiide, Yesuusa qachchi afiide, Philaaxoosaw aathiide immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Philaaxoosi A, “Neeni Ayihudatuwaa kaatee?” yaagiide oochcheedda. Yesuusi zaariide A, “Ne giyaawaadana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Qeesatuwaa kaappatuu Yesuusa daroban mooteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Philaaxoosi shirettiide Yesuusa, “New zaariyaabay baawee? Unttunttu ne bolla woyisa mootuwaa ahintto be7ikkii?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Shin Yesuusi harabaa zaarennaan ixxina, Philaaxoosi maalaletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Philaaxoosaw Paasigaa Baalaa bonchchiya gallassaan asay koyyiyaa itti uraa qashuwaappe billiyaa wogay de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","He wode itti Barbbaana giyaa bitani walassaa kessiide shemppuwaa wodheedda asatuwaanna ittippe qasho golliyan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Shiiqeedda cora asay Philaaxoosi kase erettowaadankka barenttoo maarotaa oothana mala, A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Philaaxoosi asaa zaariide, “Taani hinttenttoo Ayihudatuwaa kaatiyaa billiyaawaa koyyiitee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ayissi gooppe, qeesatuwaa kaappatuu Yesuusa qanaatiide aathi immeeddawaa Philaaxoosi ereedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Shin qeesatuwaa kaappatuu Yesuusa kotaa Barbbaana billanaadan, he shiiqeedda asay Philaaxoosa woossana mala, asaa maqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Philaaxoosi laa7enthuwaa zaariide, “Yaatina, ha Ayihuda kaatiyaa hinttenttu giyaawaa wootoo?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Asay Philaaxoosaw zari zari barenttu kooshshaa dhoqqu oothiide, “A kaqqa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Philaaxoosi asaa, “Ayissi? I ay iitabaa ootheeddee?” yaageedda. Shin asay kasewaappekka bare kooshshaa dhoqqu oothiide, “A kaqqa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Philaaxoosi asaa nashechchanaw koyyiide, Barbbaana asaw billeedda; yaatiide lissuwan Yesuusa wottaaddaratuwaan shocissiide, kaqqana mala unttunttoo aathi immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hewaappe guyyiyan, wottaaddaratuu Yesuusa gadiyaa mooddiyaawaa gibbiyaa afiide, hara wottaaddaratuwaa ubbaa ittippe xeeseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Qassi zo7o mayuwaa A mayizzeeddino; agunthaa akililiyaa giigissiide, A huuphiyan wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hewaappe guyyiyan A, “Ayihudatuwaa kaatew, sarotay new gido” yaagi sarotiidde, A qilliiccuwaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yesuusa huuphiyaa maqqaa xam77aan shoceeddino; qassi A bollan cuchcheeddino; gulbbatiide aw goyinneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","A bolla qilliicceeddawaappe guyyiyan, zo7o mayuwaa aappe qaari akkiide, A mayuwaa A mayizzeeddino; yaatiide masqqaliyaa bollan misimaariyan dhishiide, A kaqqanaw afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Unttunttu biide, Iskkinddiranne Rufoosa yeleedda aawuwaa, itti Simoona giyaa Qereena gadiyaa asay, gaxaappe katamaa yiyaawaanna gakettiide, Yesuusa masqqaliyaa wolqqaan toosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yaatiide Golgootaa geetettiyaasaa Yesuusa afeeddino. “Golgootaa” giyaawe “Huuphiyaa Gosiyaasaa” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kawaraa giyaa dhalii walaketteedda woyiniyaa eessaa Yesuusaw ushanaw immeeddino; shin I ushennaan ixxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Unttunttu A kaqqeeddino; qassi oona oona gakkanentto eranaw A mayuwaa shaakkiide, saamaa yeggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Unttunttu A kaqqiyaa wode, wonttaappe heezzu saate. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","“Ayihudatuwaa kaatiyaa” yaagi A mootiyaa xaafuu xaafeetti utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yesuusanna laa77u kayisatuwaa ittuwaa aappe ushechcha bagganna, qassi ittuwaa aappe haddirssa bagganna masqqaliyaa bolla misimaariyan dhishiide kaqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Xoossaa Maxaafay, “Iitabaa ootheedda asatuwaanna I paydetteedda” yaagiyaawe poletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ogiyaanna aadhdhiyaa asay Yesuusa kadhiide, barenttu huuphiyaa qaathiidde boreeddino; “Simmi, Geeshsha Golliyaa kolaade heezzu gallassaa giddon keexxiyaawoo, ");
INSERT INTO dwrNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ane masqqaliyaa bollappe wodhdhaade, ne huuphiyaa ashsha” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hawaadankka qeesatuwaa kaappatuu Muse higgiyaa tamaarissiyaawaanttunna ittippe Yesuusa bolla, “Hara asatuwaa ashsheedda; shin barena ashshanaw danddayenna; ");
INSERT INTO dwrNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","nuuni be7iide ammanana mala, Kiristtoosi Israa7eeliyaa kaatii, ane masqqaliyaa bollappe ha77i wodhdho” giide qilliicceeddino. Qassi haray atto, aananna masqqaliyaa bolla misimaariyan dhishettiide kaqetteeddawanttukka A bolla qilliicceeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Usuppun saatiyaappe doommiide, udduppu saatiyaa gakkanaw, gadiyaa ubbay dhumeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Udduppu saatiyaan Yesuusi bare qaalaa dhoqqu oothiide, “Elohee, Elohee, laamaa sabaqitaanii?” yaageedda. Hewaa giyaawe, “Ta Xoossaw, ta Xoossaw, taana ayissi aggaaddii?” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hewaan eqqeedda asaappe ittu ittu hewaa sisiide, “Be7ite; Eelaasa xeesee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","He asaappe ittu woxxi yiide, zanzaa malatiyaawaan caala woyiniyaa eessaa kuntheedda; hewaa maqqaa gatimaa xeeraan wothiide, “De7ishshite ane; Eelaas masqqaliyaappe A wothanaw yaanenttonne ane be7oytte” yaagiidde Yesuusa doonaakko ushshanaw shiishsheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesuusi qaalaa dhoqqu oothi waassiide, hayqqi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Geeshsha Golliyan qashetteedda gaariduu qommoppe duge gakkanaw, laa77u kesiide pooshetti wodhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Masqqaliyaappe sintha bagganna hewaan eqqeedda itti xeetuwaa Kaappuu, hewaa keenaa Yesuusi waassiide hayqqeeddawaa be7eedda wode, “Ha bitani tumu Xoossaa Na7aa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hewaan haakuwaan eqqiide xeelliyaa amareedda maccawanttu de7iino; unttunttu giddon Magdala giyaa katamaappe yeedda Mayraama, tefaa Yayiqoobanne Yoosa daaya Mayraamanne Salooma de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","He macca asatuu Yesuusi Galiilaan de7iyaa wode, A kaalleeddawanttanne A maaddeeddawantta; qassi Yesuusanna ittippe Yeerusalaame beedda hara cora macca asatuu hewaan de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sa7ay omarsseedda wode, hewaan shiiqeedda asaan bonchchetteedda itti Yooseefa giyaa bitani, Xoossaa kawutethay yaanawaa naagi utteeddawe, Armmaatiyaasa giyaa katamaa asay yeedda; he gallassay wonttetha Sambbataw giigettiyaa gallassaa gideedda diraw, Yooseefo xaliide Philaaxoosakko biide, Yesuusa anhaa akkanaw woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Philaaxoosi, Yesuusi man77iyankka hayqqidiggeeddawaa siseedda wode maalaletteedda; xeetuwaa kaappuwaa xeesiide, “I hayqqoodeppe gami77eeddee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Philaaxoosi Yesuusi hayqqeeddawaa xeetuwaa kaappuwaappe sisiide, A anhaa Yooseefo akkanaadan udeedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yooseefo mooguwaa mayuwaa shammeedda; Yesuusa anhaa masqqaliyaappe wothi mayuwan xaaxiide, shuchchaa wooceedda asaa moogiyaa gonggoluwaa giddon A anhaa wotheedda; qassi he gonggoluwaa doonaan wolqqaama shuchchaa gonddorssiide wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdala katamaappe yeedda Mayraamanne Yoosa daaya Mayraama Yesuusa anhaa unttunttu haqan wothintto be7iino. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sambbatay aadhdheeddawaappe guyyiyan, Magdala katamaappe yeedda Mayraama, Yayiqooba daaya Mayraamanne Salooma biide, Yesuusa anhaa okkanaw shittuwaa shammeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Woggaa gallassi wonttumaatha daro guuran xalqqii kesishshin, he gonggoluwaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Unttunttu barenttu giddon ittu ittuwaanna, “Gonggoluwaa doonaappe nuussi shuchchaa oone gonddorssiide digganaweeshsha?” yaagiide haasayiino. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Unttunttu xeelliyaa wode, he daro wolqqaama shuchchaa gonddorssidiggeeddawaa be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yesuusi moogetteedda gonggoluwaa giddo geliyaa wode, itti wodalla bitani bootha mayuwaa mayyiide, ushechcha bagganna utteeddawaa be7iide dagammeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Shin I unttuntta, “Dagammoppite. Masqqaliyaa bolla kaqetteedda Naazireetiyaa Yesuusa hinttenttu koyyiyaawaa eray. I hawaan baawa; denddidiggeedda. Unttunttu A wotheeddasaa hawaa be7ite. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Shin biide Yesuusi barena kaalliyaawanttoonne Phexiroosaw, ‘Yesuusi hinttenttuppe kasetiide Galiilaa bee; I hinttenttoo odeeddawaadankka hinttenttu A yaani be7ana’ yaagiide hawaa odite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Macca asatuu yashshaan kokkoriidde, Yesuusi moogetteedda gonggoluwaappe kesiide baqati aggeeddino; qassi unttunttu yayyeedda diraw, asaw hewaa oossinne aynne odibeykkino. Macca asatuu biide, barenttoo odetteeddabaa ubbaa Phexiroosawunne aananna de7iyaawanttoo qanthaan odeeddino; hewaappe guyyiyan, Yesuusi bare huuphew barena kaalliyaawanttu bolla, medhinaw ashshiyaa laamettenna geeshsha mishiraachchuwaa qaalaa, away mokkiyaasaappe wulliyaasaa gakkanaw kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuusi hayquwaappe denddeeddawaappe guyyiyan, Woggaa gallassi guura, laappu iita ayyaanatuwaa kesseedda Magdala katamaappe yeedda Mayraamiw kasetiide beetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iza baade kase aananna de7iyaawanttoo, qarettiiddinne yeekkiidde utteeddawanttoo odaaddu; ");
INSERT INTO dwrNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","shin Yesuusi paxa de7iyaawaanne iziw beetteeddawaa unttunttu siseedda wode, Izi oduwaa tuma gibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hewaappe guyyiyan, unttunttuppe laa77atuu katamaappe kesiide biishshin, ogiyaan Yesuusi koyrowaappe dummatiide, unttunttoo beetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Unttunttu guyye simmiide, haratuwassi odeeddino; shin hewanttu unttunttu oduwaa tuma gibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Guyyeppe tammanne itti Yesuusa kaalliyaawanttu qumaa miishshin, Yesuusi unttunttoo beetteedda. Unttunttoo ammanuu baynna diraw, I unttuntta seereedda; qassi hayquwaappe I denddeeddawaa be7eeddawanttu unttunttoo odina, unttunttu ammanennaan ixxeedda dirawunne odina sisennawantta gidiyaa diraw, I unttuntta seereedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I unttuntta hawaadan yaageedda; “Alamiyaa ubbaa biide, asaa ubbaw wonggalaa mishiraachchuwaa qaalaa odite. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ammanowenne xammaqettowe attana; shin ammanennawaa bolla Xoossay pirddana. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Taanan ammaniyaawanttu ha malaatatuwaa oothanawantta: unttunttu ta sunthan iita ayyaanatuwaa kessanawantta; qassi unttunttu dumma dumma oratha qaalaan haasayanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Unttunttu shooshshaa oyqqoopekka, woy ayaanne wodhiyaa marzziyaa ushinttokka unttuntta qohenna. Qassi unttunttu barenttu kushiyaa hargganchchatuwaa bolla wothana; he hargganchchatuu paxana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Godaa Yesuusi barena kaalliyaawanttunna haasayeeddawaappe guyyiyan, Xoossay A pude saluwaa afina, Xoossaappe ushechcha bagganna utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A kaalliyaawanttu biide, ubbasan wongalaa mishiraachchuwaa odeeddino. Godaykka unttunttunna ittippe oothee; unttunttu odiyaa qaalaykka tuma gideeddawaa unttunttu oothiyaa malaatatuwaan erisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Bonchchetteedda Toofiloosa, koyro barenttu ayfiyan be7eeddawanttunne barenttu qaalaan markkatteeddawanttu nuussi odeeddino. Xaafetteedda yewuwaa ta baggan ubbaa xaphuwappe bidda xeellowaappe guyye, taarikiyaa maaraa naageedda ogiyaan new xaafanaw lo77a gideeddawe taw beetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yihudaa gadiyaa Kaatiyaa Heroodisa wodiyaan, Aabiyaa qeesatethaa oosuwaa baggappe gideedda Zakkaraasa geetettiyaa itti qeesay de7ee. Machchattakka Elssaabeexo geetettiyaa Aaroone yaraappe yeletteeddawunno. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Laa77atuukka Godaa azazuwanne seeraa darissiide naagiyaawanttanne kadhee banttaan Xoossaa sinthan de7iyaa xillatuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Gidoppe attin Elssaabeexa mantha gido diraw, yeluu unttunttoo baawa. Laa77atuukka laythaa sugeeddawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Itti gallassi Zakkaraasi bare bagga kaallaan Xoossaa sinthan Qeesatethan oothiyaa wode, ");
INSERT INTO dwrNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","bare Qeesatethaa wogaa dooyaadan Geeshsha Golliyaa geliide ixaanaa cuwissuwaa saamay A gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ixaanay cuwiyaa wode asay ubbay karen eqqiide woossi de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Godaa kiitanchchay ixaanaa yarshshuwaasaappe ushechchanna eqqiide aw beetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakkaraasikka be7eedda wode dagammiide yashshaan mitetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kiitanchchaykka qassi yaageedda, “Zakkaraasaa, yayyoppa; ne woosay sisetteedda, ne machchatta Elssaabeexa attuma na7aa yelanawunnu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A yeletaan nashetaynne ishaluu new hananawaa; coratuukka I yeletto diraw hashshu gaanawantta; ");
INSERT INTO dwrNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ikka Godaa sinthan dara gidanawaa. Mathoyiyaa woyiniyaa ushshaa gido haraa mathoyiyaa ushshaa aynne ushenna; bare daay uluwaan de7ishshin Ayyaanaa Geeshshay aani kumanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Isra7eeliyaa asatuwaappekka coratuwaa unttunttu Godaa Xoossaakko, I zaaranawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ikka giigenna asaa Godaw giigissanaw, aawatuwaa wozanaa naanatuwaakko, azazettennawanttakka xillotethaa eraakko zaaranaw, Eelaasa ayyaanaaninne wolqqaan Godaappe sinthanna bee.” ");
INSERT INTO dwrNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakkaraasikka kiitanchchaa, “Taani cimaaddi, tamachchattakka bare laythaan sugeeddawunno, hawaa taani ayaan eranitaa?” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kiitanchchaykka zaariide, “Taani Xoossaa sinthan eqqiyaa Gabreela; hawaa mishiraachchuwaa new odanaw neekko kiitettaaddi; ");
INSERT INTO dwrNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hekko he wodiyaan hanana ta qaalaa ne ammana beenna diraw, ha yewuu hanana gallassay gakkanaw neeni duude gidanaassa; haasayanawukka danddayakka” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","He wode asay, Zakkaraasi Geeshsha Golliyaappe kesennaan ayaw gami77eeddentto maalalettiidde naagiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Keseedda wodiyankka haasayanaw danddaybeenna; Geeshsha Golliyan saxaa I be7eeddawaa akeekeeddino; ikka haasayanaw danddayibeennawaa xorssi bessiide, duude gidiide de7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakkaraasikka bare oosuwaa wodiyaa wursso wode, bare golle simmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hewaappe guyyiyan A machchatta Elssaabeexa shahaaraade ichcheshu agenaa barena genthaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elssaabeexakka, “Ta tooshiyaa asaa giddoppe digganaw Goday bare maarotethaan taana xeello wode, hawaadan taw ootheedda” gaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Usuppuntha agenaan Xoossaa kiitanchchaa Gabreel Galiilaa gadiyaan Naazireete Katamaa ");
INSERT INTO dwrNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Daawita yaraappe gideedda Yooseefa geetettiyaa bitanew ooshetta qashetteedda wodorattikko Xoossaa matappe kiitetteedda; wodoratti sunthaykka Mayraamo geetettee. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kiitanchchaykka Mayraamikko yiide, “Darissaade dosettawunne, sarotethay new gido; Godaykka neenanna gatho de7ee; Neenikka maccawanttu giddon anjjetteeddawunno” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mayraamakka A haasayaappe denddowaan darissa dagammaade, “Hawe ayaa mala sarotaa gidanee” gaade yewuwaa qoppaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kiitanchchay izo, “Hanne Mayraamee, Xoossaa matan sabaa demmaadda yayyoppa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Neeni shahaaraade, attuma na7aa yelanaassa; A sunthaakka Yesuusa gaanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ikka dara gidanawaa; Ubbaappe Dhoqqa Xoossaa Na7aa geetettana; Godaa Xoossay A aabbu Daawita kaawutethaa oydiyaa aw immanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ikka Yayiqooba gollen medhinaw kawutanawaa; A kawutethawukka wurssethay baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mayraamakka kiitanchchaa, “Taani wodoratto gido diraw, hawe wooti hananawee?” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kiitanchchaykka zaariide iziw, “Ayyaanaa Geeshshay ne bolla yaanawaa; Dhoqqa Xoossaa wolqqay neenan shemppanawaa. Hewaa diraw, neeppe yelettiyaawe geeshsha Xoossaa Na7aa geetettana. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ne dabbatta Elssaabeexa bare cimatethaa wodiyaan attuma na7aa shahaaraaddu. Mantha geetetteeddawunna Elssaabeexa shahaaroodeppe usuppuntha agenaa oyqqaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xoossaa xooniyaa yewuu baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mayraamakka, “Taani Godaa ayllatto; neeni goowaadan hano” gaaddu. Hewaappe guyyiyan kiitanchchay izi matappe beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mayraamakka he agenaa giddon denddaade killi zoozetiyaa Yihudaa gaden de7iyaa itti katamaa elleella kesaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakkaraasa golle gelaade Elssaabeexo sarotaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elssaabeexakka Mayraami sarotaa siseedda wode, izi uluwaan de7iyaa shahaaray guppeedda; Elssaabeexakka Ayyaanaa Geeshshaan kumaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bare kooshshaakka dhoqqu oothaade, “Neeni maccawanttu giddoppe anjjetteeddawunno. Neeppe yelettiyaawekka anjjettowaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Neeni ta Godaa daaya taakko yaanaw taani oone? ");
INSERT INTO dwrNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hekko ne sarotaa kooshshay ta haythaan sisetteedda wode, ta uluwaan de7iyaa shahaaray nashechchaan guppeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Goday polettee giide iziw odeeddawaa ammaneeddawunna iza anjjetteeddawunno” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mayraamakka, “Ta shemppatta ta Godaa bonchchaw, ");
INSERT INTO dwrNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ta ayyaanaykka ta Xoossaa, ta dhaliyan loytha nashettaw. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ikka bare ayllatti tooshiyaa xeelleedda. Hachcheppe dommiide yeletay ubbay anjjetteeddawunnee giino. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wolqqaama gideedda I daro yewuwaa taw ootheedda; A sunthaykka geeshshaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A maarotay yayyiyaawanttussi yeletaappe yeletay gakkanaw de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bare wolqqaan mino kiitaa kiitetteedda; barenttu wozanaa qofaan otorettiyaawantta laaleedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mooddiyaawantta kawutethaa maataa oydiyaappe wotheedda; ashikkatuwaakka qassi dhoqqu dhoqqu ootheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Koshatteeddawantta lo77o yewuwaan kalisseedda; duratuwaa qassi mela yedersseedda ");
INSERT INTO dwrNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Bare maarotethaa qoppiide bare aylliyaa Israa7eeliyaa maaddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nu aawatoo I odeeddawaadan Abraahaamewunne A yaraw geeddawaa medhinaw naagana diraassa” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mayraamakka heezzu agenaa keena Elssaabeexi matan gami77owaappe guyyiyan bare golle simmaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elssaabeexiwukka yeliyaa wodii gakkina, attuma na7aa yelaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Izi shooratuunne izi dabbo gideeddawanttu, Goday maarotethaa iziw ootheeddawaa sisiide izinna ittippe nashetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hosppuntha gallassaan na7aa qaxxaranaw yeeddino; A, aawuwaa sunthaan Zakkaraasa giide sunthanaw koyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A daaya qassi, “Hanenna, Yohaannisa geetettanaw koshshee” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Unttunttukka izo, “Ne dabbatuwaappe hachche gakkanaw ittuukka ha sunthaan xeesettibeenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A aabba, oona giyaa sunthan xeegettanaw koyyintto xorssi oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A aabbukka xaafiyaabaa oochchi akkiide, “Na7aa sunthay Yohaannisa” giide xaafina, ubbatuukka yewuwaan maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hewankka Zakkaraasa doonay dooyetteedda, A inxxarssaykka bilettina haasayaa doommeedda, Xoossaakka galateedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A shooratuukka de7iyaasaa ubbaan yashshaan kumeeddino. Ha yewuukka zoozetiyaa Yihudaa gadiyaa ubbaan darii haasayetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hawaakka siseeddawanttu ubbatuu, “Ha na7ay ayaa gidaneeshsha?” yaagiide yewuwaa barenttu wozanaan oyqqeeddino; Xoossaykka aananna de7iyaawaa ereeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yohaannisa aabbu Zakkaraasi Ayyaanaa Geeshshaan kumiide timbbitiyaa yaagi odeedda: ");
INSERT INTO dwrNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israa7eeliyaa Goday Xoossay anjjetto; yiide bare asaa xomooseeddanne wozeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bare aylliyaa Daawite golliyan; wolqqaama ashshiyaawaa nuussi giigisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hawekka beni Godaa geeshsha nabatuwaa doonan odettowaadan, ");
INSERT INTO dwrNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","I nuuna, nu morkketuwaappenne nuunanna eqettiyaawanttu kushiyaappe ashshanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Hawaakka I ootheeddawe, nu aawatoo maarotethaa bessanaassanne, bare geeshsha caaquwaa wozanaa aathanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nu aawuwaa Abraahaamossi caaqqeedda caaquwaa qoppanaw, ");
INSERT INTO dwrNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nu morkketuwaa kushiyaappe kesiide yashshay banttaan aw oothanaadan maataa nuussi immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Hawenneekka, nuuna nu wodiyaa ubbaan geeshshatethaaninne xillotethaan bare sinthaan essana diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zaariidekka, neenoo, ta na7aw, Dhoqqa Xoossaa nabiyaa geetettanaassa; ogiyaa giigissanaw Godaappe sinthanna baanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Asaa nagaraa maariyaa atotethaa eraa unttunttoo immanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Hewekka killippe yeedda poo7uu, nuuna xomooseeddawe nu Xoossaa maarotethaanne qaretaa gaasuwana. ");
INSERT INTO dwrNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","A poo7uukka dhumaaninne hayquwaa kuwaan utteeddawanttoo poo7issee; nu gediyaakka sarotethaa ogiyaan suurissee.” ");
INSERT INTO dwrNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na7aykka dicciide, ayyaanaan minneedda; Israa7eeliyaa asaw beetteedda gallassay gakkanaw mela biittaan de7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","He wode Roomaa kawutethaa garssan de7iyaa asay ubbay sunthaa xaafettanaadaninne paydettanaadan Awugisxxoose Qeesareppe azazuu keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hewenneekka, Qereneyoose Sooriyaa gadiyaa mooddiyaa wode haneedda koyro asaa payduwaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hawaa diraw itti itti asay xaafettanaw bare katamaa bare katamaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yooseefokka Daawita golliyaappenne yaraappe gidiyaa diraw Galiilaa Awuraajjaan de7iyaa Naazireete katamaappe denddiide Daawita katamaa gideeddawunnikko Yihudaan de7iyaa Beeteliheeme geetettiyaa katamaa keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","He wode yeliyaa wodii mateedda aw ooshetta utteedda Mayraamakka aananna ittippe baaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Unttunttu hewaan de7ishshin iziw yeliyaa wodii gakkii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Izakka bayra Na7aa gideedda attuma Na7aa yelaaddu; imathay shemppiyaasaa demma beenna diraw, na7aa mayuwan xaaxaade gaphatiyaan qeraaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","He gadiyaan qamma barenttu wudiyaa heemmiidde dembban aqiyaawanttu de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Xoossaa kiitanchchay qoppennaan yiide unttunttu miyyiyaan eqqeedda; Godaa bonchchuu unttunttu yuushshuwaan poo7eedda wode, wolqqaama yashshay unttuntta oyqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kiitanchchay unttuntta, “Yayyoppite, asaw ubbaw haniyaa daro nashechchiyaa mishiraachchuwaa taani hinttenttoo ahaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hachche Daawita katamaan ashshiyaawe yeletteedda. Ikka Godaa Kiristtoosa. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hawe hinttenttoo malla gido: Gacino na7ay mayuwan xaaxettiide gaphatiyaa giddon giseeddawaa demmanita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Qoppennaan cora Xoossaa kiitanchchatuu koyro kiitanchchaanna ittippe qoncceeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Xoossaakka galatiide, hawadan geeddino: “Bonchchuu Xoossaw bolla saluwan gido. sa7an I dosiyaa asaw sarotethay gido” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kiitanchchatuu unttunttuppe shaakettiide saluwaa kesowaappe guyye, wudiyaa heemmiyaawanttu, “Goday nuussi qonccisseeddawaa, hawaa haneedda yewuwaa be7anaw Beeteliheeme boytte” geetetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Unttunttukka elleelliide beeddino. Mayraamonne Yooseefa demmiide, gacino na7aykka gaphatiyaan giseeddawaa be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hewaappe guyyiyan guutha na7aa diraw odetteeddawaa qonccissiide odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Hawaa siseedda ubbay unttunttu odeedda yewuwaan maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mayraama qay hawaa ubbaa bare wozanaan oyqqaade qoppaadde gami77aaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wudiyaa heemmiyaawanttukka ubba yewuu unttunttoo odetteeddawaadan hanina demmo diraw, siseeddawoonne be7eeddawoo ubbaw Xoossaa bonchchiiddinne galatiidde simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na7aw hosppun gallassa gidina qaxxarettiyaa wodii gakko wode, I aatti uluwaan attanaappe kase, kiitanchchay kesso sunthaan, Yesuusa geetetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Muse wogaa maaraadan geeyyiyaa wodii poletteedda wode Yooseefonne Mayraama gacino na7aa Xoossaw sheedhdhanaw Yeerusalaame akki beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Hewenneekka Godaa wogaan, “Attuma na7aa gideedda bayra na7ay ubbay Xoossaw dummateeddawaa gidanawaa” geetetti xaafetteeddawaadaninne, ");
INSERT INTO dwrNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","qassikka Godaa wogaan, “Laa77u dogommatuwaa woy laa77u haraphphe maratuwaa” geetettowaadan, Godaw yarshshuwaa yarshshanaw afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","He wode xillonne gencca gideedda Simoona geetettiyaa itti bitani Yeerusalaamen de7ee. Ikka, Israa7eeliyaa asaw atotethaa hidootaa naagiyaawaanne Ayyaanaa Geeshshay A bollaan shemppeedda asa. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Godan oketteedda Kiristtoosa be7ennaan hayqqennawaa Ayyaanaa Geeshshaan aw qonccisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ikka he wode Ayyaanaa Geeshshay kaalethina, Geeshsha Golliyaa geleedda. Na7aa yelawanttu eriya wogaa maaraadan, koshshiyaawaa aw polanaw guutha na7aa Yesuusa oyqqiide gelo wode, ");
INSERT INTO dwrNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoone mokki akki na7aa idimmiide Xoossaa galatiidde hawaa yaageedda: ");
INSERT INTO dwrNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Godaw, Neeni qaalaa gelo maaraadan ha77i taana ne aylliyaa saruwan neekko afa. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Gaasuukka, ta ayfatuu asaa ubbaa sinthan Neeni giigisseedda, ashshiyaa hidootaa be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hewekka Israa7eeliyaa gidenna asaw qonccethaa immiya poo7uwaa. Qassi Ne asaw Israa7eelew bonchchuwaa.” ");
INSERT INTO dwrNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yooseefonne A daaya A diraw haasayetteedda yewuwaassi maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoonikka anjjiide Mayraamo, “Hawe Na7ay Israa7eeliyan coratuwassi dendduwassinne kunddethaw gaaso gidanaw, qassikka iitaa haasayiyaawanttussi malla gidanaw dooretteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Coratookka wozanaa qofay qonccowaa gidanaw, ne shemppuukka mashshaan qanxxowaadan seelettanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Qassikka Aaseera yaraappe gideedda Paanu7eela naatta Haanno geetettiyaa nabatta de7aw; Izakka loytha cimaaddu. Bare wodorotethaan geleedda asinaanna laappu laythaa de7eeddawunno. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Izi laythaykka hosppun tammanne oydduwaa gidana gakkanaw gallassaanne qammaa geeshsha golliyaappe shaakettennaan xoomaaninne woosaan kiitettaadde am77e gidaade gami77aaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","He wodekka shiiqaade Xoossaa galataaddu; Qassikka Yeerusalaame asay wozettanaw naagiyaawanttoo ubbatoo gacino Na7aa Yesuusabaa odaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yooseefonne Mayraama Godaa higgiyan azazetteeddawaa ubbaa polowaappe guyye Galiilaa Awuraajjaan de7iyaa barenttu katamaa Naazireete simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Guutha na7aykka dicciiddenne minniidde beedda; aadho eraanikka kumeedda; Xoossaa aadho keekatethay Aabollaan shemppeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yooseefonne Mayraama laythaan laythaan Paasigaa Baalaa bonchchanaw Yeerusalaame katamaa biino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na7awukka tammanne laa77u laythaa gido wode dooyaadan baalaw hini Yeerusalaame keseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baalaa polowaappe kaalla barenttu golle unttunttu simmoode guutha na7aa Yesuusi Yooseefonne Mayraama erennaan Yeerusalaamen atti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Unttunttunna ittippe de7iyaawaa malatina itti gallassaa ogiyaa hametteeddino. Guyyeppe qassikka barenttu dabbatuwaannanne barenttu siiqettiyaawanttu matan koshshaa dommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dhayo wode koyyiidde hini Yeerusalaame simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Heezzu gallassaappe guyye, tamaarissiyaawanttu giddon Yesuusi uttiide unttunttu giyaawaa sisiiddenne unttuntta oochchiidde Geeshsha Golliyaa garssan de7iyaawaa be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sisiyaawanttu ubbatuukka, A akeekaaninne A zaaruwan maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yooseefonne A daaya A be7o wode maalaletteeddino. A daayakka, “Ta Na7aw, ayaw nuuna hawadan oothay? Ne aabbunne taanne Neena koyyiidde, daro metooteeddo” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesuusikka unttunttoo, “Ayaw taana koyyiitee? Ta aabbu gollen de7anaw taw koshshiyaawaa eribeykkitee?” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hewaa yaagi odoppe attin, unttunttoo I odeedda yewuu ayaa gintto gelibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hewaappe simmiide, unttunttunna ittippe hini Naazireete beedda; hewankka unttunttoo azazettee. A daayakka hewaa ubbaa bare wozanaan wothaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesuusikka eraaninne geesan, sabaanikka Xoossaanne asaa sinthan dicceedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Xibaariyoosa geetettiyaa kaatii kawuteedda tammanne ichcheshethiyaa laythaan Phenxxenaawiyaa Philaaxoosi Yihudaa mooddiyaa wode, Heroodise Galiilaan oyddenthiyaa shaakuwaa mooddiyaa wode, A ishay Piliphphoosikka Ixuuriyaaninne Xirkkonddoosan oyddenthiyaa shaakuwaa mooddiyaa wode, Lisaaniyoosikka Abileenen oyddenthiyaa shaakuwaa mooddiyawaa gidiide mooddi de7ishshin, ");
INSERT INTO dwrNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Haanninne Qeyyaafay qeesatuwaa kaappatuwaa gidiide de7ishshin, Xoossaa qaalay Zakkaraasa na7aa Yohaannisakko mela biittaan yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohaannisi Yorddaanoosa Shaafaa heeraa ubbaa biide, “Hintte nagaray atto geetettana mala nagaraa paaxiide xammaqettite” yaagi tamaarisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nabiyaa Iisiyaasa maxaafan xaafetteedda qaalaadan, “Mela biittaan waassiyaa bitaniyaa kooshshay, ‘Godaw ogiyaa giigissite; A ogiyaakka suurissite. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“ ‘Ollay ubbay kumo; deriinne zoozii denbbaa gido, giigenna ogi ubbay giigo, hanchchiro ogi ubbay liiqo. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","“ ‘Hewaa gidooppe Asay ubbay Xoossay ashshiyaawaa be7ana’ ” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hawaa diraw Yohaannisi A kushiyan xammaqettanaw keseedda asaw hawaadan oduwaa doommeedda, “Hentteno, shooshshaa naatoo; yiyaa hanqquwaappe attana mala hinttentta ooni maqqeeddee? ");
INSERT INTO dwrNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Simmi hinttenttu nagaraappe simmeeddawanttoo bessiyaa ayfiyaa ayfite. Hinttenttu wozanaan Abraahaamo nu aabbu de7ee gooppite. Xoossay Abraahaamossi naanaa ha shuchchatuwaappe denthanaw danddayee yaagaade taani hinttenttoo oday. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ha77i ubba beexi mithaa xaphuwan qanxxanaw giigi utteedda; simmi lo77o ayfiyaa ayfenna mithay ubbay qanxxettiide tamaan olettanawaa.” ");
INSERT INTO dwrNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“Yaatina ha77i nu ayaa udanee?” yaagiide A cora asay oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohaannisikka, “Laa77u mayuu de7iyaawe baynnawoo immo; qumay de7iyaawekka baynnawoo gisho” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Qaraxaa shiishshiyaawanttukka xammaqettanaw yiide, “Tamaarssiyaawoo, nu ayaa udanee?” yaagi oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I unttunttoo, “Geetettowaappe aadho qaraxaa aathi shiishshoppite” yaagi odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Hewaappe kaalla wottaaddaratuu, “Nuunishi, ayaa udanee?” yaagi A oochcheeddino. Yohaannisikka, “Asaa shaluwaa naaquwaan bonqqi akkoppite, oonanne wordduwan mootoppite, hinttenttu dirgguu hinttenttoo gidana” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","He wode asay ubbay Kiristtoosa yuussaa naagiidde de7iyaa diraw Yohaannisa, “Hawekka Kiristtoosa gidennaan attenna” yaagiide barenttu wozanaan maleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohaannisi ubbatuwaakka, “Taani haathaan xammaqay; gidoppe attin taappe wolqqaamaynne taanikka A caammaa qashuwaa billana danddayennawe biro yaanawaa; ikka Ayyaanaa Geeshshaaninne tamaan xammaqanawaa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A kushiyan kathaa dalaappe shaakki geeshshiyaa layday de7ee. Kathaa uddummaan bukkowaa geeshshi punniide ayfiyaa diyyiyan qolee; shin dalaa to7enna tamaan guuddee.” ");
INSERT INTO dwrNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohaannisikka hara cora qaalaan cora asaa maqqiidde mishiraachchuwaa qaalaa odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Galiilaa mooddiyaa Heroodisa qassi bare ishaa Piliphphoosa machchatto Herodiyaado I akkeedda dirawunne haraakka cora iita kiitaa kiitetto diraw, Yohaannisi seereedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hawaa diraw ha ubbaa gujjiide Heroodise Yohaannisa qasho golle gelsseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Asay ubbay xammaqetti simmowaappe guyyiyan Yesuusi xammaqetteedda. I woossi de7ishshinkka saluu dooyetti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Geeshsha Ayyaanaykka haraphphiya malatiide A bollaan wodhdheedda. Saluwaappekka, “Ta dosiyaa na7ay neena; neenan Taani nashettay” yaagiyaa qaalay yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuusi tamaarssuwaa doommoode aw hattamu laythaa gideedda; cora asaykka barenttoo malatowaadan A Yooseefo na7aa yaagiino; Yooseefo Eele na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eele Maate na7aa; Maate Leewiyaa na7aa; Leewii Milkke na7aa; Milkke Yoona na7aa; Yooni Yooseefo na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yooseefo Maataatiyaa na7aa; Maataati Amooxe na7aa; Amooxe Naahoome na7aa; Naahoome Esiliime na7aa; Esiliime Naage na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naage Maa7aate na7aa; Maa7aate Maataatiyyu na7aa; Maataatiyyu Seemeye na7aa; Seemeyi Yooseefo na7aa; Yooseefo Yooda na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoodi Yoonaana na7aa; Yoonaani Reese na7aa; Reese Zerubaabeela na7aa; Zerubaabeeli Salaatiyaala na7aa; Salaatiyaale Neele na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neeli Milkke na7aa; Milkke Haadde na7aa; Haadde Yoosaase na7aa; Yoosaase Qoosaama na7aa; Qoosaami Elmaadoome na7aa; Elmaadoome Eere na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eere Yoosee7e na7aa; Yoosee7e, Eli7eezera na7aa; Eli7eezere, Yooraame na7aa; Yooraami Maaxaate na7aa; Maaxaate Leewiyaa na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leewii Simoona na7aa; Simoone Yihudaa na7aa; Yihuday Yooseefo na7aa; Yooseefo Yoonaana na7aa; Yoonaani Eeliyaaqeema na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eeliyaaqeemi Meeliya na7aa; Meeliye Mayinaana na7aa; Mayinaani Maaxaate na7aa; Maaxaate Naataane na7aa; Naataane Daawite na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daawite Issey na7aa; Issey Iyyoobeeda na7aa; Iyoobeedi Boo7eeza Na7aa; Boo7eezi Salmoona na7aa; Salmooni Nahishoona na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahishooni Aminadaaba na7aa; Aminaadaabi Raama na7aa; Raami Ariina na7aa; Ariinay Hezroona na7aa; Hezrooni Pereeza na7aa; Pereezi Yihudaa na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yihuday Yayiqooba na7aa; Yayiqoobi Yisaaqa na7aa; Yisaaqi Abraahaamo na7aa; Abraahaamo Taara na7aa; Taari Naakoora na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naakoori Seeroohe na7aa; Seeroohi Ragawa na7aa; Ragawi Pelega na7aa; Pelegi Abeera na7aa; Abeeri Saalla na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Saalli Qaynaana na7aa; Qaynaani Arfaakisiide na7aa; Arfaakisiide Seeme na7aa; Seemi Nohe na7aa; Nohe Laameehe na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laameehi Maatusaala na7aa; Maatusaali Heenooke na7aa; Heenooki Yaareda na7aa; Yaaredi Malaali7eela na7aa; Malaali7eeli Qaynaana na7aa; ");
INSERT INTO dwrNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Qaynaani Heenoosa na7aa; Heenoosi Seete na7aa; Seeti Addaama na7aa; Addaami Xoossaa na7aa. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesuusi Geeshsha Ayyaanaan kumiide Yorddaanoosa Shaafaappe simmeedda; Ayyaanaan mela sa7aa kaalesettiide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hewaan oytamu gallassaa daabiloosan paacetteedda. He gallassatuwan ayaanne mibeenna diraw wurssethaa poluwaa heeran I koshatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Daabiloosikka, “Neeni Xoossaa Na7aa gidooppe ha shuchchaa, ‘Ukitha gida’ gaade azaza” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesuusikka, “ ‘Asay Xoossaa Qaalaa ubbaappe attin ukithaa xalalaan de7enna’ geetetti Xoossaa Qaalaan xaafetteedda” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Daabiloosikka dhoqqa gideedda deriyaa Yesuusa kessiide alamiyaa kawutethaa ubbaa lipho ayfii simmanaw besseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Daabiloosikka, “Ha kawutethaa maataynne bonchchuu ubbay taw imetteedda. Taani ta dosiyaa oossinne immana; newukka immana. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hewaa gidiyaa diraw, ne ta sinthaan taw goyinnooppe ha ubbay neessa gidanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesuusikka zaariide, “ ‘Godaa Xoossaw goyinna, A xalalaa Godaya’ geetetti Xoossaa Qaalaan xaafetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Daabiloosikka Yesuusa Yeerusalaame afiide Geeshsha Golliyaa huuphiyaa kessiide, “ ‘Xoossay neena naagana mala kiitanchchatuwaa kiittanawaa, unttunttukka ne gedi shuchchaan dhubettenna mala barenttu kushiyaan neena denthanawantta’ yaagettiide Geeshsha Maxaafaan xaafetteedda; ane Neeni Xoossaa Na7aa gidooppe hawaappe duge neena ola” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesuusikka zaariide, “ ‘Ne Godaa Xoossaa paaccoppa’ geetetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Daabiloosikka paaciyaa ubbaa wurssowaappe guyye guutha wodew Yesuusappe shaaketteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesuusikka Ayyaanaa wolqqaan Galiilaa gadiyaa simmeedda. A waariikka yuushshuwaan de7iyaa ubbaa gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesuusikka Ayihudatuwaa Woosa Golliyan tamaarissiide asaan ubbaan galatetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","I bare dicco katamaa Naazireete yeedda; kase oothiyaawadankka sambbata gallassi Ayihudatuwaa woosa golle geliide nabbabanaw denddiide eqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","19","Nabiyaa Isiyaasan xaafettiide xaaxetteedda maxaafaa aw immeeddino. He maxaafaa billiide: “Taani hiyyesatuwassi mishiraachchuwaa odanaw oketteedda diraw Godaa Ayyaanay Ta bollan de7ee. Qashetteeddawanttussi bilethaa, qooqatuwassi xeellana mala odanaw, qaykka naaqetteeddawantta naaquwaappe kessana mala dosetteedda Godaa laythaa odana mala, Taana kiitteedda” geetetti xaafetteeddasaa demmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Maxaafaakka xaaxiide Ayihudatuwaa woosa golliyan oothiyaawoo immiide utteedda. Ayihudatuwaa woosa golliyan de7iyaa asay ubbay A caddi xeelleedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesuusikka, “Hachche hinttew nabbabettina hinttenttu siseedda qaalay poletteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ubbay aw markkatteeddino. A doonaappe kesiyaa aadho keekatethaa qaalaappe denddeeddawaan maalalettiidde, “Hawe Yooseefo na7aa gidennee?” geeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesuusikka sidhe banttaan ha leemisuwan, “Hinttenttu taw ‘Dhaliyaa Godaw, ne huuphiyaa patha, neeni Qifirinaahooman oothina nu sisowaa ubbaa ha ne katamaanikka qassi ootha’ yaagiide odiita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Qassikka, “Tumuwaa yaagay, nabii bare yeletto gadiyaan gammakka bonchchettenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Yewuwaan qassi tumuwaa oday: Eelaasa wodiyaan heezzu laythanne usuppun agenaa iray bukkennaan ixxina sa7aa ubbaan wolqqaama koshay geleedda wode, Israa7eelen cora am77atuu de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eelaasikka Sidoonaa gadiyaan de7iyaa Seraafta heeraa itti am77attikko kiitetteeddappe attin ookkonne kiitetti beenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nabiyaa Elssaa7a wodiyankka Israa7eeliyaan cora oolluwaa harggiyan oyqetteeddawanttu de7iino; Sooriyaa biittaan de7iyaa Ni7imaaneppe attin unttunttuppe ooninne paxi beenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayihudatuwaa woosa golliyan de7iyaawanttu ubbatuu hawaa sisiide darissiide hanqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Unttunttu denddiide Yesuusa katamaappe gaxaa kessiide duge olanaw katamay keexetteedda deriyaa huuphiyaa afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Shin Yesuusi unttunttu gidduwanna aadhdhiide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hewaappe guyyiyaan Yesuusi Galiilaa gadiyaan de7iyaa Qifirinaahooma katamaa beedda. Sambbata gallassaankka asaa tamaarisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","I tamaarissiyaa timirttii maataan gidiyaa diraw siseedda asay ubbay maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ayihudatuwaa woosa golliyan iita ayyaanay oyqqeedda bitani de7ee; bare kooshshaa dhoqqu udi waassiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hayya godo aggaarikki Naazireetiyaa Yesuusa; nuussi neenanna ay ittippetethay de7ii? Nuuna bayizzanaw yaaddi? Neeni oonentto eraaddi; Neeni Xoossaa Aawuu kiitteedda geeshshaa gidikkii!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesuusikka, “Co77u ga, aappekka kesa” yaagi seereedda. Iita ayyaanay bitaniyaa unttunttu gidduwan kunddissiide aynne qohennaan aappe keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Asay ubbay maalalettiide ittu ittoo, “Hawe ayaa qaalee? Barew de7iyaa maataaninne wolqqaan iita ayyaanatuwaa seeree; qassi iita ayyaanaykka kesee” yaagiidde haasayeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A waariikka he yuushshuwaan de7iyaa gadiyaa ubbaa gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesuusi Ayihudatuwaa woosa golliyappe denddiide Simoona golliyaa geleedda, Simoona bollotatta wolqqaama qoxuwaa harggiyan harggettaade giseeddawunniw Yesuusi izo pathanaadan asay A woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I matan eqqiide qoxuwaa harggiyaa seerina, harggii yeddiisheedda; hewodiyankka denddaade unttunttoo kiitettaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Away wullo wodiyaan dumma dumma harggiyan oyqetteedda harganchchatuwa ubbaa aakko aheeddino; ikka ittuwa ittuwa bolla bare kushiyaa wothiide patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iita ayyaanatuukka, “Neeni Kiristtoosa Xoossaa Na7aa” yaagi waassiidde cora asaappe keseeddino. I Kiristtoosa gidowaa unttunttu ereedda diraw haasayenna mala diggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sa7ay wontto wode asay baynnasaa beedda; asay ubbay A koyyiidde I de7iyaasaa yeeddino. Barenttuppe shaaketti beennaadan digganaw koyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","I qay, “Hini hara katamatuwassi baade Xoossaa Kawutethaa mishiraachchuwaa Qaalaa odanaw koshshee; taani kiitetteeddawe hawaa diraassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Galiilaan de7iyaa Ayihudatuwaa woosa gollen Qaalaa tamaarissiidde gami77eedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Itti gallassi Yesuusi Gensaareexe Abbaa gaxaan eqqiide de7ishshin cora asay aakko shiiqiide Xoossaa qaalaa sisanaw sugetti de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","He wode laa77u wongiratuu Abbaa gaxaan eqqowaa I be7eedda; moliyaa phiriyaawanttu qassi wonggiratuwappe wodhdhiide barenttu dabbaa meecci de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesuusi wonggiratuwaa giddoppe Simoonawunno gideeddawunnini geliide sa7aappe yaa abbaakko guuthaa shiishshanaadan oochcheedda. Hewaappe guyye wonggiriyaa bollan uttiide asaa tamaarissuwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tamaarissuwaa bethowaappe guyyiyan Simoona, “Wonggiriyaa yaa abbaa ciimmuwakko shiishshite; hinttenttu dabbaakka moliyaa phiranaw olite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoonikka, “Godaw, qammaa kummenthaa daaburi aqiide ayinneekka oyiqqibeykko; shin ha77i Neeni goowaadan dabbaa oleetto” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hewaadankka ootheedda wode, daro cora moliyaa oyqqeeddino. Unttunttu dabbatuukka duuxerettanaw haneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hara wonggiriyaan de7iyaa laggethatuu yiide maaddanaadan wutteeddino; unttunttu laa77u wonggiratuwankka moliyaa kunthina wonggiratuu mitettussaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simooni Phexiroosikka hawaa be7eedda wode Yesuusa gulbbatan kunddiide, “Godaw, taani nagaranchcha asa gido diraw taappe shaaketta” yageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Hawaa geeddawe inne aananna ittippe de7iyaawanttu ubbay barenttu oyqqeedda moliyaa coratethaan maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hewaadankka qay Simoona laggethaa gideeddawanttu Zabiddiyoosa naanatuu Yayiqoobinne Yohaannisi maalaletteeddino. Yesuusikka Simoona, “Yayyoppa hawaappe guyyiyan asaa phiriyaawaa gidanaassa” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Unttunttukka wonggiratuwaa haathaappe gaxaa kessiide, ubbabaa aggiide Yesuusa kaalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuusi katamatuwaappe ittuwan de7ishshin oolluu bollaa ubbaa meedda bitani de7iyaawe Yesuusa be7iide A sinthankka kunddiide, “Godaw, neeni koyyooppe taana pathanaw danddayaa” yaagiide woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesuusikka bare kushiyaa yeddi bochchiide, “Dosay geeyya!” geedda. Heman77iyankka oolluu A yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuusi A, “Hawaa oossinne odoppa. Shin qeesaakko baade neena bessa. Hewaappe guyye oolluwaa harggiyaappe paxeeddawaassi markka gidanaadan Muse higgiyan azazetteedda yarshshuwaa shiishsha” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gidoshshin A waarii loythi aakkiidde beedda; daro cora asaykka Yesuusi odiyaawaa sisanawunne barenttu harggiyappe paxanaw shiiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesuusi cora wode geemasaa biide woossee. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Itti gallassi Yesuusi tamaarissiidde de7ishshin Galiilaappenne Yihuudaa heeraa ubbaappe, Yeerusalaame yeedda Parisaawatuunne higgiyaa tamaarissiyaawanttu utti de7ishshin hargganchchatuwaa pathana mala Xoossaa Aawuwaa wolqqay aw imetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","He wode bollay sileedda itti bitaniyaa amareedda asay shanchchamaan tookki ahi golle gelssiide Yesuusa sinthan wothanaw koyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Asaa coratethaappe denddeeddawaan Yesuusakko shiiqanaw danddayi beykkino. Hewaa diraw bollaw gi77i golliyaa kaaraa qaariide A, shanchchamaanna asaa giddon Yesuusa sinthaan wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesuusikka unttunttu ammanuwaa be7iide, “Ha bitanew, ne nagaray atto geetetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Muse higgiyaa tamaarissiyaawanttunne Parisaawatuu, “Hawe Xoossaa boriyaawe oone? Itti Xoossaappe attin nagaraa atto gaanaw ooni danddayii?” yaagi qofaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesuusikka unttunttu qofaa ero diraw hawaadan geedda, “Ayissi hinttenttu wozanaan hawaadan qoppiitee? ");
INSERT INTO dwrNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Ne nagaray atto geetetteedda’ gaanawaappenne ‘Denddaade ba’ gaanawaappe haqawe matee? ");
INSERT INTO dwrNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yewuwaan qassi hawaa taani geeddawe, Asaa Na7ay biittaa bollan nagaraa maaranaw maatay de7iyaawaa hinttenttu eranaadana.” Hewaappekka gunddeedda bitaniyaa, “Dendda ne shanchchamaa tookkaade ne golle ba gay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Gunddaykka asaa sinthaan dendowaashshin bare shanchchamaa tookkiide Xoossaa galatiidde bare soy beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ha wode ubbatuukka darii maalaletteeddino; Xoossaakka galatiidde, “Hachche malabaa be7eeddo” yaagiide yashshaan kumeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hewaappe guyyiyan Yesuusi kesiide beedda; Leewiyaa geetettiyaa qaraxaa shiishshiyaawe, qaraxaa shiishshiyaasan uttowaa be7iide, “Taana kaalla” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ikka denddiide ubbabaa aggiide A kaalleedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hewaappe simmiide Leewii bare gollen daro shoobiyaa giigisseedda; cora qaraxaa shiishshiyaawanttunne hara cora asaykka unttunttunna uttiide mide7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisaawatuunne higgiya tamaarissiyaa, unttunttunna oothiyaawanttu, Yesuusa kaalliyaawanttu bollan, “Ayissi qaraxaa qanxxiyaawanttunnanne nagaranchchatuwaanna miiteennee ushiitee?” yaagiide zuuzummeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesuusikka, “Hargganchcha asaappe attin paxa asaassi aakimiyaa koshshenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Taani yeeddawe, nagaranchchatuu barenttu nagaraa paaxiide simmanaadanappe attin, xillatuwaa xeesanaw yabeykke” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hawaappe guyyiyan Yesuusa, “Yohaannisa kaalliyawanttunne Parisaawatuwaa kaalliyaawanttu ubba wode xoomiinonne woossiino; shin Neena kaalliyaawanttu qassi ubba gallassi miinonne ushiino” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesuusikka, “Mishiray unttunttunna de7ishshin miyaatatuu xoomanaw danddayiinoo? ");
INSERT INTO dwrNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yewuwaan qassi mishiray unttunttuppe shaakettiide baana wodii yaanawaa; he wode xoomanawantta” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesuusikka kaalliyaa leemisuwaa odeedda: “Ooratha mayuwaappe peedhi akkiide eca mayuwaa bollan dheppiyaawe baawa; gaasuukka hawaada udooppe ooratha mayuwaa peedhee; ooratha dhefiikka eca mayuwaan giigenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hawaadankka eceedda cilggiyaan ooratha woyiniyaa eessaa wothiyaawe baawa; wothooppe qay ooratha woyiniyaa eessay cilggiyaa dhuussee; eessaykka gukkee; cilggayikka bayee. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ooratha woyiniyaa eessaa, ooratha cilggiyaan wothanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Eca woyiniyaa eessaa ushiide oorathaa koyyiyaawe ooninne baawa; gaasuukka ecay mal77ee giya diraw.” ");
INSERT INTO dwrNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sambbata gallassi Yesuusi barena kaalliyaawanttunna ittippe itti goshshaa gidduwanna aadhdhiya wode A kaalliyaawanttu zarggaappe tishaa duuthiide barenttu kushiyan shigechchiide muussaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisaawatuwaa giddoppe, “Sambbata gallassaan oothanaw woga gidennawaa ayaw oothiitee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesuusi, “Kaatiyaa Daawitenne ittippe de7iyaawanttu koshatteedda wode ootheeddawaa nabbabi beykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daawite Xoossaa golliya geliide qeesatuwaappe attin hara asay meennaadan digetteedda, Xoossaw yarshshetteedda qumaa meedda. Ittippe de7iyaawanttukka I imminaade meeddino” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hawaappe kaalliide Yesuusi, “Asaa na7ay sambbataw Godaa!” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hara sambbata gallassaan Yesuusi Ayihudatuwaa woossiyaa golliyaa geliide tamaarissi de7ee. Hewankka ushechcha kushii sileedda bitani de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Higgiyaa tamaarssiyaawanttunne Parisaawatuu Yesuusa mootiyaa gaasuwaa demmanaw I sambbataan asaa pathooppe be7ana giide naagi de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ikka unttunttu qofaa eriide kushii sileedda bitaniyaa, “Dendda asaa gidduwan eqqa” yaageedda. Bitaniikka denddi eqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hewaappe simmiide Yesuusi, “Haninttonne sambbata gallassaan lo77obaa oothanaw bessiiyee iitabaa oothanaw bessii? Shemppuwaa ashshanaw bessiyee wodhanaw bessii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesuusi bare yuushshuwaan de7iyaa asaa ubbaa xeellowaappe guyyiyan bitaniyaa, “Ne kushiyaa micca!” yaageedda. Ikka micciide paxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Unttunttu loythi hanqqeettiide Yesuusa bolla oothanawaa barenttu giddon maqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","He wodiyaan Yesuusi deriyaa bolla woossanaw keseedda; hewankka qammaa kumenthaa Xoossaakko woossiidde aqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sa7ay wonttowaan barena kaalliyaawantta xeeseedda. Hewanttuppekka tammanne laa77atuwaa dooriide, “Kiitetteeddawantta” yaagiide suntheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Unttunttu sunthaykka: Phexiroosa giide I suntheedda Simoona, A ishaa Inddiraasa, Yayiqooba, Yohaannisa, Piliphphoosanne Barttalamoosa, ");
INSERT INTO dwrNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maatoossa, Toomaasa, Ilppiyoosa na7aa Yayiqooba, bare gadew seelettiyaa Simoona, ");
INSERT INTO dwrNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yayiqooba na7aa Yihudaanne Yesuusa aathi immeedda asqqorttu Yihudaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuusikka unttunttunna ittippe deriyaappe wodhdhiide dembbasaan eqqeedda. A kaalliyaawanttuppekka cora asay hewaan de7ee. Qaykka Aappe sisanawunne barenttu harggiyaappe paxanaw Yihudaa gadiyaappe, Yeerusalaame katamaappe, abbaa matan de7iyaa Xiiroosappenne Sidonaappe yeedda cora asay hewaan de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ha asaykka A sisanawunne barenttu harggiyaappe paxanaw yeeddino. Tuna ayyaanan oyqettiide metootiyaawanttukka paxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wolqqay aappe kesiide ubbaa pathiyaa diraw asay ubbay A bochchanaw koyyee. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Barena kaalliyaawantta xeelliide yaageedda: “Hinttenttu manqqatuu anjjetteeddawantta; Ayissi gooppe, Xoossaa kawutethay hinttenttuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hinttenttu ha77i koshattiyaawanttu anjjetteeddawantta; gidini kaallanita; hinttenttu ha77i yeekkiyaawanttu anjjetteeddawantta; gidini miiccanita. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Asaa na7aa diraw hinttentta asay ixxiyaa wodenne toochchiyaa wode, hinttenttu sunthaakka iitaan denthiyaa wode, anjjetteeddita. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Saluwan hinttenttu akkana woytay dara gidiyaa diraw he gallassi nashechchaan guppite; gaasuukka kase hinttenttu aawotuu nabatuwaa bollan hawaadan oothiidde de7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yewuwaan qassi dure asatoo hinttenttoo aayyee; hinttenttu ishalo de7uwan de7eeddita. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hinttenttoo ha77i kalleeddawanttoo aayyee; gidini koshattanita; hinttenttoo ha77i miicciyaawanttoo aayyee; gidini kayyottanitanne yeekkanita. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Asay ubbay hinttenttu lo77otethaabaa haasayiyaa wode, hinttenttoo aayyee; kase hinttenttu aawotuu worddo nabatoo hawaadan ootheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Shin Taani odiyaawaa sisiyaawanttoo yaagay: hinttenttu morkketuwaa dosite; hinttena ixxiyaawanttoo, lo77uwaa oothite; ");
INSERT INTO dwrNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","hinttena sheqqiyaawantta anjjite, hinttena naaqqiyaawanttoo, woossite. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Itti bagga shayyiyaa baqqiyaawoo, laa7ethuwaakka bessa; ooninne ne kootiya akkiyawoo, ne shaamiciyaakka diggoppa. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“New de7iyaawaa neena woossiyaawoo, imma; newaa akkeeddawaa, zaara gaade oochchoppa. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Asay hinttenttoo oothana mala hinttenttu dosiyaawadan, hinttenttukka haraw hawaadan oothite. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Hinttentta dosiyaawantta xalalaa dosooppe ay galatay de7ii? Hawaa gidooppe nagaranchchatuukka barena dosiyaawantta dosiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hinttenttoo lo77obaa oothiyaawanttu xalalaw hinttenttu lo77obaa oothooppe hewoo ay galatay de7ii? Nagaranchchatuukka hawaadan oothiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tal77iide hinttew zaaranaw danddayiyaawanttu xalalaw tal77ooppe ay galatay de7ii? Bare tal77eeddawaa zaariide akkanaw nagaranchchatuukka barenttu garssan tal77ettiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Shin hinttenttu, hinttenttu morkkiyaa dosite; unttunttookka lo77obaa oothite; hinttenttuppe tal77owaa zaariidi akkanaw qoppoppite. Hawaa hinttenttu polooppe hinttenttoo gatii daranawaa. Qassi hinttenttu Ubbaappe Bolla Xoossaa naanaa gidanita. I iitatoonne galatennawanttookka keeka. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hinttenttu aabbu maariyaawaa gidowaadan hinttenttukka maariyaawantta gidite. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“O bollankka pirddoppite, hinttenttu bollankka pirddettenna; haraa bolla kunaaniyaa oothoppite; hinttenttu bollankka kunaani oosettenna. Atto giite; Xoossay hinttenttoo atto gaana. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Immite; hinttenttoo imettana. Hinttenttu makkeedda makaan hinttenttoo makettana. Baqqi naaqqina siilli kumi palah laalettiyaa makaa hinttenttu kiwuwaan idinthana” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Qassikka Yesuusi hawaappe kaalliyaa leemisuwaa odeedda; “Qooqay qooqaa kaalethanaw danddayii? Qooqay qooqaa kaalethooppe laa77atuukka oyqettiide ollaan kunddikkinoo? ");
INSERT INTO dwrNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tamaariyaawe barena tamaarissiyaawaappe aadhdhenna; tamaariyaawe minni tamaarooppe barena tamaarissowaa mala gidanaw danddayee. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ne ayfiyaa giddon de7iyaa tuussaa kessennaan de7aadde hara ne laggiyaa ayfiyaa giddon de7iyaa suullaa ayaw xeellay? ");
INSERT INTO dwrNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne ayfiyaa garssan de7iyaa tuussaa be7ennaan hara asaakko shiiqaade, ‘Ta ishaw, ne ayfiyaa garssappe suullaa ta kessoo?’ yaaganaw woota danddayay? Ha lo77uwaa malatiyaa iitaw, koyrottaade ne ayfiyaa giddon de7iyaa tuussaa kessa. Hewaappe guyyiyan ne ishaa ayfiyaa giddon de7iyaa suullaa kessanaw geeshshaade xeellanaw danddayaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Lo77o mithay iita ayfiyaa ayfenna; hewaadankka iita mithay lo77o ayfiyaa ayfanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mithay ubbay bare ayfiyaa ayfiyaawan erettee. Agunthaappe woddenthaa ayfii maxettenna; hawaadankka, xundduqiyaappe laadiyaa ayfiyaa maxanaw danddayettenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lo77o asay bare lo77o wozanaappe lo77o yewuwaa haasayee. Qay iita asay bare iita wozanaappe iita yewuwaa haasayee. Ayissi gooppe, asay bare doonan haasayiyawe bare wozanaan kumeeddawaa doonay haasayiyaa diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Taani odowaa oothikkita, shin ayaw Godaw, Godaw, yaagiide Taana xeegiitee? ");
INSERT INTO dwrNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Taakko yiyaa ubbay ta qaalaakka sisiide oosuwan peeshshiyaawe oona malatintto ta hinttentta bessana; ");
INSERT INTO dwrNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ikka golliyaa keexxiidde daro ollaa bookkiide zaallaa bolla ginbbiide keexxeedda asaa malatee; di7uu di77iide he golliyaa suginakka, mino zaallaa bolla keexetto diraw qaathanaw danddaybeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Qay Ta qaalaa sisiide oosuwaan peeshshenna uray baasuu banttasaa shafiyaa bollan golliyaa keexxeeddawaa malatee. Di7uu di77iide he golliyaa sugo wode man77iyankka kunddeedda; he golliikka iita wodaa woddiide bayeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuusikka hawaa ubba asaa sinthan haasay wurssowaappe guyyiyan hini Qifirinaahooma beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hewankka itti xeetuwaa kaappuu de7ee. I daroppe dosiyaa A qoomay harggiide hayyanaw mateedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ikka Yesuusabaa siseedda wode, bare qoomaa woossiide pathana mala Yihudaa cimatuwaa hini aakko kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Unttunttukka Yesuusakko yiide, “Ha bitani, Neeni A maaddanaadan daroppe koyyeedda; ");
INSERT INTO dwrNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","gaasuukka nu asaa I daroppe dosiide Ayihudatuwaa woossiyaa golliyaa keexissowekka A” yaagiide daroppe woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesuusikka unttunttunna ittippe beedda. Ikka hini golliyaa heeraa gakkeedda wode xeetuwaa kaappuu bare laggethatuwaa barekko xeesiide, “Ta Godaw, daaburoppa; ayissi gooppe, neena ta golliyaa kaaraappe garssa bagganna gelssanaw taw bessenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hawaa diraw ne sinthaan eqqanawukka haray atto bessiyaawaa gidikke. Shin neeni qaalaa xalalaa oda; ta qoomaykka paxanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Taani taappe bollanna maatay de7iyaawanttussi eeno gaade de7iyaa asa. Taappe garssannakka taani kiitissiyaa wottaaddaratuu de7iino. Ittuwaa, ‘Ba’ yaagiyaa wode, bee; haraakka qay, ‘Haaya’ gooppe yee. Ta qoomaykka, hawaa ‘Ootha’ giyaa wode azazettee; oothee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuusikka hawaa sisiide A yewuwaan maalaletteedda; guyye simmiide A kaalliyaa daro asaa, “Taani hinttenttoo tumuwaa gay; taani hawaa mala ammanuwaa haray atto, Israa7eeliyaa garssankka be7abeykke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kase kiitetteedda asatuukka xeetuwaa kaappuwaa golle guyye simmiyaa wode, A qoomay paxowaa be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wonttissa gallassi Yesuusi barena kaalliyaawanttunnanne cora asaanna ittippe Nayno geetettiyaa katamatto beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesuusi katamaa gakkana mato wode, asay hayqqeedda anhaa tookkiide keseeddino. Hayqqowekka bare daayiw mexxi itti na7aa; aattakka asinay baynna am77atto. Daro katamaa asaykka izo kaalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yesuusikka izo be7eedda wode qarettiide, “Yeekkoppa!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Shiiqiide shanchchamaa bochcheedda; tookkowanttukka eqqeeddino. Yesuusi, “Neeno yalagaw, dendda gay!” yaagina, ");
INSERT INTO dwrNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","bitani suuri utteedda. Hasayaakka doommeedda. Yesuusikka A, A daayiw immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ubbaykka yashshaan kumiide, “Wolqqaama nabii nu garssan denddeedda; Xoossaykka bare asaa ashshanaw yeedda!” yaagiide Xoossaa galateeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hewenneekka Yesuusa waarii Yihudaa yuushshuwaan de7iyaa gadiyaa ubbaan sisetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohaannisa kaalliyaawanttu hanowaa ubbaa aw odeeddino. Yohaannisikka barena kaalliyaawanttuppe laa77atuwaa xeesiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Yaanawe neeneyee? Woy nuuni haraa naaganee?” yaagi, unttunttu oochchana mala hini Yesuusakko kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Asatuukka Yesuusakko yiide, “Xammaqiyaa Yohaannisi, yaana getetteeddawe neeneyee? Woy haraa naaganee? Yaagiide oochchana mala neekko kiitteedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","He wodiyaan Yesuusi cora asaa dumma dumma harggiyaappe patheedda; tuna ayyaanatuwaakka asaappe kesseedda; cora qooqatuwaa ayfiyaa dooyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesuusikka Yohaannisi kiittowanttoo, “Biide hinttenttu be7eeddawaanne siseeddawaa Yohaannisaw odite; qooqatuu xeellanawantta; gunddatuu hamettanawantta; oolluu oyqqowanttu geeyyanawantta; tulleeddawanttu sisanawantta; hayqqeeddawanttu denddanawantta; hiyyeesatuwaasikka mishiraachchuwaa qaalay odettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Taanan dhubettenna asay ubbay anjjetteeddawantta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohaannisi kiitteeddawanttu bidiggowaappe guyyiyan Yesuusi asaw Yohaannisabaa oduwaa doommeedda: “Ayaa be7anaw biittaa bazzuwaa keseedditee? Carkkuu qaathiyaa uusunthaa? ");
INSERT INTO dwrNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Woy ayaa be7anaw keseedditee? Lo77o mayuwaa mayyeedda asaa de7uwaa? Lo77o mayuwaa mayyeeddawanttunne barena giigissiyaawanttu kaatiyaa gollen de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Woy ayaa be7anaw keseedditee? Nabiyaa be7anaw keseedditee? E; taani hinttenttoo yaagay; hinttenttu be7anaw kesowe nabiyaappekka aadhuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Xoossaa Maxaafan, ‘Ne ogiyaa neeppe sinthanna giigissiyaa kiitanchchaa neeppe sinthayaade kiittana’ geetetti Yohaannisabay xaafetteeddawe hawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Maccawanttuppe yeletteeddawanttu garssan xammaqiyaa Yohaannisappe aadhdhiyaa ooninne baawa. Xoossaa kawutethaan qassi ubbaappe laafa geetettiyaawekka aappe aadhdhanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Haray attoshshin qaraxaa kessiyaawanttu attennaan hawaa Yesuusi haasayowaa siseedda ubbay Yohaannisa kushiyan xammaqettowanttu Xoossaw bessiyaa bonchchuwaa immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Shin higgiyaa tamaarissiyaawanttunne Parisaawatuu Yohaannisan xammaqettibeenna diraw, Xoossay unttunttoo qoppeeddawaa ixxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuusi, “Simmi Taani ha wodiyaa asaa ayaanna leemisoo? Unttunttu ayaa malatiinoo? ");
INSERT INTO dwrNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Unttunttu geyaasan uttiide ittu ittuwa xeesiide, ‘Suusulliyaa hinttennttoo punninakka kaa7ibeykkita; yeekuwaa yethaa kesseeddoshshinkka yeekkibeykkita yaagettiyaa naanaa malatiino’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xammaqiyaa Yohaannisi qumaa meennaan woyiniyaa eessaakka ushennaan yiina, ‘A bollaan gaaleenay de7ee’ yaageeddita. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Taani Asaa Na7ay maaddenne ushaadde yiina, ‘Hawe nafisaamaa; woyiniyaa eessaakka ushiyaawaa; qaraxiyaawanttoonne nagaranchchatoo dabbuwaa’ yaagiita. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Gidoppe attin Xoossaa aadho eratethay bare oosuwan tuma gidiide beetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisaawatuwaappe ittu barenanna qumaa maana mala shoobbina, Yesuusi A soy biide maanaw utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","He katamaan nagaranchchaa geetetteedda itti mishiratta de7ewunna, Yesuusi A soyin utteeddawaa sisaade, albbasxxiroosa geetettiyaa shuchchaappe oosetteedda bilqqaasiyaa kumeedda shittuwaa akkaa yaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Guyyenna A gediyaa mataan eqqaade, yeekkaadde A gediyaakka bare afothaan okaa doommaaddu; izi afothay bayizzeedda A gediyaakka bare huuphiyaa binnanaan quccaaddenne A gediyaa yeraadde gediyan shittuwaakka caccafaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yesuusa bare soy xeeseedda Parisaawiikka hawaa be7iide, “Hawe nabiyaa gideeddentto, hanna A bochchiyaa mishiratta oonenttonne qaykka iza nagaranchchaa gidiyaawaa I eranashshin” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesuusikka zaariide, “Simoona, taani new odiyaa yewuu de7ee” yaagina, Simoonikka, “Tamaarissiyaawoo, oda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesuusi, “Itti bitaniyaappe miishshaa tal77eedda laa77u asatuu de7iino. Ittuwaa matan ichcheshu xeetu diinaari, qay yokkuwaa matan ishatamuu de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Laa77atookka ciggiyaawe dhayina, laa77atuwaa acuwaakka maarii aggeedda. Hawanttuppe haqawe loythi dosiyawaa malatii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoonikka zaariide, “Daruwaa aggowa malatee” yaageedda. Yesuusikka, “Tumuwaa zaaraadda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesuusi mishirattikko xeelliide, Simoona hawaadan yaageedda; “Hanno mishiratto be7aaddii? Taani ne golle yiina haray attoshshin haathaakka ta gedew immabeykka; shin iza bare afothaan tagediyaa irxxissaaddu; bare huuphiyaa binnanaanikka quccaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Neeni Taana yera beykka; shin iza taani geloodeppe doommaade tagediyaa yeriyaawaa agga beykku. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Neeni ta huuphiyan zaytiyaa okka beykka; shin iza ta gediyan shittuwaa caccafaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hawaa diraw ta hinttenttoo oday: daroppe iza doseeddawaa diraw, daro nagaray iziw de7iyaawe maaretteedda; guuthay maarettiyaawe guuthaa dosee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesuusi mishiratto, “Ne nagaray qucetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yesuusanna ittippe qumaa maanaw utteeddawanttu barenttu wozanaan, “Nagaraa maaranaw danddayiyaawe hawe oone?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuusi mishiratto, “Ne ammanuu neena ashsheedda, sarotethaan ne golle ba” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yesuusi hawaappe simmiide, sabbakiiddinne Xoossaa kawutethaa mishiraachchuwaa qaalaa katamaaninne heeraan odiidde aadhdheedda. Tammanne laa77u Yesuusa kaalliyaawanttukka aananna ittippe de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Iita ayyaanaappenne wolqqaama harggiyaappe paxeeddawanttu itti itti maccawanttukka de7iino. Hewanttukka: Laappu xalahii keseedda Magdala geetettiyaa katamaappe yeedda Mayraamonne, ");
INSERT INTO dwrNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Heroodisa golliyan suntha gideedda Kuuza machchatti Yohaanno, Soosina geetettewunnanne hara coratuwanna ittippe gidiide, Yesuusanne A kaalliyaawantta miishshaan maaddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cora asay daro katamatuwaappe shiiqiide, Yesuusakko yeedda wodiyaan leemisuwan, ");
INSERT INTO dwrNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Zeriyaawe zerethaa zeranaw keseedda. Zeriyaa wode itti itti zerethay, ogiyaa doonan wodhdhiide yedhetteedda. Yatina saluwaa kafuu hewaa meedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Haray qay zaallaa bolla wodhdhiide doleedda wode koshshiyaa haathaa demmenna diraw meleedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hara zerethay agunthaa garssan wodhdheedda. Agunthay ittippe dicciide mitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Haray lo77iyaa tu7e biittaan wodhdheedda. Dolowaappe guyyiyan, zerettowaappe xeetu kushiyaa dakkuwaa mokkeedda” yaageedda. Yesuusi hawaa haasayiidde, “Haythay de7iyaa ubbay siso” yaagi qaalaa dhoqqu udiide waasseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A kaalliyaawanttu, “Ha leemisuu ayaa guussee?” yaagi A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ikka zaariide, “Hinttenttoo Xoossaa kawutethaa xuuraa eray imetteedda; shin haratoo, xeelliiddikka erenna mala, sisiiddikka akeekenna mala leemisuwan oday” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesuusi, “Zerethaa leemisuu hawaa: Zerethay Xoossaa qaalaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ogiyaa gaxaan wodhdheedda zerethay, guutha wodew qaalaa sisiyaa asaa; ellekka xalahii yiinne, unttunttu sisowaan amman attenna malanne qaalay wozanaappe dogettana mala oothee. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Zaallaa bollan wodhdheedda zerethay, koyro qaalaa nashechchaan sisiyaawantta. Hewanttukka guutha wodiyaa ammaninnee paacii gakkiyaa wodiyaan xaphuu bantta diraw ellekka ammanuwaa kaddiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Agunthaa garssan wodhdheedda zerethay, qaalaa sisiyaawantta; shin de7uwaa hirggaynne duretethaa ishaluu cuulleeddawantta. Hewanttu lo77o ayfiyaa immanaw danddayikkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lo77o tu7e biittaan wodheedda zerethay bessiyaawe, lo77anne xillo wozanaan qaalaa sisiide naagiyaa asaanne he qaalaan minni eqqiide lo77o ayfiyaa ayfiyaawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Xomppiyaa sathiide ittibaan qum77i aggiyaawe woy arssaappe garssanna wothiyaawe ooninne baawa. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Qonccennaan qosuwan attiyaabay itti yewuunne baawa. Erettennaaninne beettiyaasaa kesennaan attanabay aynne baawa. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hewaa gidiyaa diraw loythi akeekaan sisite. Wozanaappe sisiyaawoo ubbaw gujji akeekay imettana; akeekennawaappe he aw de7iyaawaa malatiyaa akeekaykka akettanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","He wodiyaan aattanne ishatuu Yesuusanna gakettanaw aakko yeeddino; shin asaa coratethaappe denddo gaasuwan A demmanaw danddaybeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Itti bitani, “Ne daayanne ne ishatuu neenanna gakettanaw koyyo diraw karen yiide eqqeeddino” yaagi odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ikka, “Ta daayanne ta ishatuu, Xoossaa qaalaa sisiide oosuwaa bollan peeshshiyaawantta” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Itti gallassi Yesuusi barena kaalliyawanttunna ittippe wonggiriyaa geliide, “Abbaappe hefintha boytte” geedda. Unttunttukka denddiide hametaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pinni de7iyaa wode, Yesuusi gemi77isheedda. Abbaan gotuwaa carkkuu denddo diraw, wonggiriyaa garssan haathay kumina daro metooteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Unttunttu Yesuusakko shiiqiide, “Godaw, Godaw! Nuuni bayoyttettee!” yaagiide A beegotheeddino. Ikka beegottiide gotuwaanne haathaa beetaa seerina, gotuunne haathaa beetay eqqeedda; ubbabaykka co77u geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ikka, “Hinttenttoo ammanuu haqan de7ii?” yaageedda. Unttunttukka yayyi maalalettiide ittu ittuwaa, “Hawaadan carkkuunne haathay co77u giite giina azazettiyaawe hawe oone?” yaagetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galiilaa Abbaappe hefinthanna de7iyaa Gerggesenoona geetettiyaa gadiyaa, Yesuusinne A kaalliyaawanttu, wonggiriyaan pinniide gakkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","He haathaappe pinni sa7aa wodhdho wode, iita ayyaanan oyqetteedda itti bitani, katamaappe kesiide aananna gaketteedda. Daro wodiyaappe doommiide mayuwaa mayyennaan kallo golliyaa aggiide duufuwan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yesuusa demmowaappe guyyiyan, waassi A sinthaan guufanniide wolqqaama kooshshaan, “Wolqqaama Xoossaa na7aa Yesuusaa, tawunne new aybe ittippetethay de7ii? Taana waayissoppaarikki; ta neena woossay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","I hewaa ayissi geeddee gooppe, bitaniyaa yeggi kesana mala Yesuusi A azazo diraassa. Iita ayyaanay bitaniyaa oyqqoodeppe daro wode gido diraw, birataa santhalataan gediyaanne kushiyaa qashettiide naagettee. Santhalataa duuthi akkiide iita ayyaanay kaalethina bazzuwaa bee. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuusikka, “Ne sunthay oone?” yaagi oochcheedda. Ikka cora iita ayyaanay geli utto diraw, “Leegiyoona” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Barentta Yesuusi, “Hini ciimmo ollaa biite” yaagenna mala woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hewaan de7iyaa zooziyaa gaxaan hemettiyaa cora gudunthatuu de7iino. Cora tuna ayyaanatuu, he gudunthatuwaa garssa, “Gelite” gaana mala Yesuusa woosseeddino. Ikka, “Biide gelite” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iita ayyaanatuukka bitaniyaappe kesiide gudunthatuwaa garssa geleeddino. Gudunthaa wudiikka lanqqiyappe kajjottiidde ellekka abbaan mitetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Gudunthaa heemmiyaawanttu hanowaa ubbaa be7o wode harasaa biide, he katamaaninne yuushshuwaan hanowaa odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ayee haneeddentto be7anaw kesiide, asay Yesuusakko yeeddino. Iita ayyaanay keseedda bitani, A wozanay simmina mayuwaa mayyiide Yesuusa gediyaa mataan uttowaa be7iide yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iita ayyaanan oyqetteedda bitani wooti paxeeddentto be7eedda asay, hara asaw odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerggesenoona gadiyaaninne he heeran de7iyaa asay ubbay darii yayyeedda diraw, Yesuusi barenttu matappe baana mala woosseeddino. Ikka wonggiriyaan geliide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iita ayyaanay keseedda bitaniikka Yesuusanna baana giide, A woosseedda; shin Yesuusi, ");
INSERT INTO dwrNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ne golle simmaade Xoossay new ootho wolqqaamabay ayentto markkatta” yaagi yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesuusi simmeedda wode asay ubbay naagi de7iyaa diraw, A mokki akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","He wode, Ayihude asaa woosa gollew sunthaa gideedda Yaa7iroosa yaagettiyaa bitani aakko yeedda. Ikka Yesuusa gediya sinthaan kunddiide, bare golle gelana mala woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Gaasotethaykka tammanne laa77u laythay kumeedda aw de7iyaa itti naatta hayqqanaw mata utto diraassa. Yesuusi biya wode cora asay A yuushshuwaan sugettiidde metootheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","He asaa giddon he wodiyaan tammanne laa77u laythaa ubbaa suuthay goggiyaa mishiratta de7aw. Bare de7iyaa shaluwaa ubbaa dhaliyaa eriyaawanttoo wurssinakka pathanaw danddayowe ooninne baawa. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Guyyenna yaade A mayuwaa macaraa bochchaaddu; he man77iyankka iippe goggiyaa suuthay eqqii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesuusi, “Oone taana bochchowe?” yaageedda. Ubbay kaddina Phexiroosi, “Godaw, asay sugettiidde metoothiyaa wode, ‘Oone taana bochchowe’ yaagay?” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Shin Yesuusi, “Itti asay taana bochcheedda; wolqqaykka taappe kesowaa taani eray” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mishirattakka, Yesuusa iza bochchowe erettennaan attibeennawaa eraade, kokkoraadde yoonna Yesuusa sinthan kunddaa aggaaddu. Ayaa gaasuwan Yesuusa bochchaaddentto iza paxowaa ubba asaa sinthan odaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ikka iziw, “Ha mishirattee! Ne ammanuu neena patheedda; saro ba” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuusi haasay de7ishshin, Ayihuda asaa ammaniyaawanttu sunthaa soyippe itti bitani yeeddawe, “Ne naatta hayyaaddu; simmi tamaarissiyaawaa metoothoppa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesuusi hawaa sisiide, “Yaa7iroosaa, ammanappe attin, yayyoppa! Iza paxanawunnu” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Soy geliide: Phexiroosappe, Yayiqoobappe, Yohaannisappe, naatti aabbuppenne naatti daayippe attin, ooninne gelanaadan eeno gibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ubbay he naattiw yeekkiiddenne kayyottiiddi de7iino. Shin Yesuusi, “Yeekkoppite, gisaadduppe attin hayyabeykku” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iza hayqqeeddawaa eriide A bolla miicceeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gidoppe attin Yesuusi izi kushiyaa ooyqqiide, “Ha naattee, beegotta!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Izi shemppuukka simmina ellekka dendda eqqina maanabaa immana mala, Yesuusi azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Izi aabbunne izi daaya maalaletteeddino; shin Yesuusi unttuntta, hano yewuwaa oossinne odenna mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuusi tammanne laa77u A kaalliyaawantta ittippe barekko xeesiide, xalahiyaa ubba asaappe kessanawunne harggiyaawantta pathana mala wolqqaanne maataa immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xoossaa kawutethaabaa odanawunne hargganchchatuwaa pathana mala unttuntta kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","I unttuntta kiittiidde, “Ogiyaa biidde, xam77aa gidinakka, woy qarcciitiyaa, woy qumaa, woy miishshaa gidinakka ayaanne oyqqoppite; laa7ethiyaa mayuwaakka oyqqoppite. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hinttena asay haqan mokkooppenne, hewaappe kesana gakkanaw, hinttenttu geleedda golliyan gami77ite. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","He katamaa asay hinttena mokkennaan ixxooppe, hewaappe kesiidde, unttunttu hinttena mokkennaan ixxowoo markka gidana mala, hinttenttu gediyaappe baanaa shoci diiggiide biite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A kaalliyaawanttu biide, qeeri katamaa ubbaan mishiraachchuwaa qaalaa odiiddenne hargganchchaa pathiidde yuuyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ha77i Galiilaa biittaa kaatiyaa Heroodisekka haneedda yewuwaa sisiide yatti geedda. Gaasotethaynneekka itti itti asay, “Yohaannisi hayquwaappe denddeedda” yaagee. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Hara asay, “Eelaasi kesiide beetteedda” yaagiyaa wode, haranttu qassi, “Beni nabatuwaappe ittu hayquwaappe denddeedda” yaagiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heroodisekka, “Taani Yohaannisa qoodhiyaa qanxxissa diggaaddishshin, hawaadan asay haasayiyaa bitani oonee?” yaagiide, Yesuusa be7anaw koyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesuusi kiittowanttu simmiide, unttunttu ootheeddawaa ubbabaa Yesuusaw odeeddino. Ikka unttuntta akkiide, Beetesayda yaagettiyaa katamaa matan de7iyaa takkasaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Asay I de7iyaasaa eriide kaallina, unttuntta mokki akkiide Xoossaa kawutethaabaa odeedda; harggiyaappe paxanaw bessiyaawanttakka patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sa7ay omarssiyaa wode, Yesuusa kaalliyaa tammanne laa77atuu aakko yiide, “Ha asay ubbay nu yuushshuwaan de7iyaa heeraa giddonne qeeri katamatuwaa giddo biide, aqiyaasaanne qumaa demmana mala moyizza; ayaw gooppe nuuni hawaan asay baynnasan de7eetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Shin Yesuusi unttuntta, “Asaw meetettiyaabaa hinttenttu immite” yaageedda. Unttunttu zaariide, “Ane biide, ha ubba asaw qumaa shammennaan dhayooppe nuussi ichcheshu soolluwaappenne laa77u moliyaappe haray baawa; hewaassi nuuni ha cora asaw qumaa shammana mala koyyay?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Gaasuukka, hewaan de7iyaa asay ichcheshu sha77aa keena) Yesuusi barena kaalliyaawantta, “Ishatamu ishatamu asaa citan citan shaakki shaakki utissite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Unttunttukka I gowaadan ubba asaakka utisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesuusikka ichcheshu soolluwanne laa77u moliyaa oyqqiide, pude saluwaa bonggotti xeelliidde Xoossaa galateedda; duuthiide, asaw gishana mala A kaalliyaawanttoo immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Asay ubbaykka miide kalleeddino. Unttunttuppe atteedda dokkaa, tammanne laa77u samppaa kumeeddawaa dentheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Itti gallassi Yesuusi barekka woossiyaa wode, A kaalliyaawanttukka aananna ittippe de7ishshin, “Asay taana oona giinoo?” giide unttuntta oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Unttunttu zaariide, “Asay neena xammaqiyaa Yohaannisa yaagee; hara asay qassi Eelaasa yaagee; haray qassi beni nabatuwaappe ittu denddeedda yaagee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesuusi unttuntta, “Hintteshi, taana oona giitee?” yaageedda. Phexiroosikka zaariide, “Neeni Xoossay okkeedda Kiristtoosa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesuusikka unttuntta, “Hawaa oossinne odoppite” yaagi minissi azaziidde, ");
INSERT INTO dwrNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Taani, Asaa Na7ay, daro metuwaa akkanaw bessee; cimatuwan, qeesatuwaa kaappatuwaaninne Muse higgiyaa tamaarissiyaawanttun ixettanaw koshshee; unttunttu taana wodhanawantta; taanikka heezzentho gallassi hayquwaappe denddanaw bessee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuusikka asaa ubbaa, “Taana kaallanaw dosiyaawe de7ooppe, bare huuphiyaa kaddo; bare masqqaliyaa gallassaan gallassaan tookkiide taana kaallo. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bare shemppuwaa ashshanaw dosiyaawe ubbay bayizzee; shin ta diraw bare shemppuwaa bayizziyaawe ubbay ashshee. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Itti uray ha alamiyaabaa ubbaa ashshiide bare shemppuwaa bayizzooppe woy barew pacissooppe, ayaa maaddii? ");
INSERT INTO dwrNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Asay taananinne taqaalaan yeellatooppe, taani Asaa Na7ay, ta bonchchuwaannanne geeshsha kiitanchchatuwa bonchchuwanna yiyaa wode aani yeellatanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Taani hinttenttoo tumuwaa yaagay; hawaan de7iyaa asaappe, Xoossaa kawutethaa be7ana gakkanaw hayquwaa hayqqennawanttu ittu ittu de7iino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuusi hawaa goowaappe guyyiyan, itti saaminttaa keena gami77iide, Phexiroosanne Yohaannisa, Yayiqoobakka akkiide, woossanaw deriyaa huuphiyaa keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","I woossishshin, A deemuwaa malay laametteedda; A mayuukka booxxiide pholqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Qoppennaan laa77u asatuu, Musenne Eelaas kesi beettiide, Yesuusanna haasay de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Unttunttu bonchchuwan qoncci beettiide, Yesuusi Xoossaa qofaa polanaw Yeerusalaamen hayqqanawaa aananna haasayeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Phexiroosanne aananna ittippe de7iyaawantta gemi77ishuu geeroyeeddashshin, ellekka beegottiide A bonchchuwanne aananna gatho eqqeedda laa77u asatuwaa be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","He laa77u asatuu, Yesuusa miyyiyaappe shaakettiyaa wode, Phexiroosi Yesuusa, “Godaw, hawaan de7iyaawe nuussi lo77a gidiyaa diraw, heezzu daasiyaa ittuwaa new, ittuwaa Musew, ittuwaa Eelaasaw keexxana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Phexiroosi hewaa haasay de7ishshin, shaarii yiide unttuntta kammi aggina Yesuusa kaalliyaawanttu yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Shaariyaappekka, “Taani dooreedda ta Na7ay hawaa; I giyaawaa sisite” yaagiyaa qaalay yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Qaalay sisettowaappe guyyiyan, Yesuusi bare xalalaa gidiide beetteedda; unttunttukka yewuwaa barenttu wozanaan oyqqiide he wodiyan ooninneekka ayaanne odibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wonttetha gallassi, Yesuusinne heezzu A kaalliyaawanttu deriyaappe duge wodhdhiyaa wode, cora asay Yesuusanna gaketteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","He wode asaappe itti bitani bare kooshshaa dhoqqu oothiide, “Tamaarissiyaawoo, taw de7iyaawe itti na7aa gido diraw, neeni A be7ana mala neena woossay; ");
INSERT INTO dwrNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","qassi iita ayyaanay wozanaa aathennaan denddiide A waasissee; doonaanna paaroyana gakkanaw A kokkorssiide, ubba gallassi metoothiyaawaappe attin, A elle yeddenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Neena kaalliyaawanttu he iita ayyaanaa kessana mala, taani unttuntta woossaaddi; shin danddaybeykkino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesuusi zaariide unttuntta, “Ammanenna ha wodiyaa desha asaw, taani hinttenanna awude gakkanaw de7anee? Qassi hinttenttubaa awude gakkanaw danddayanee? Ne na7aa haa akkaaya” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na7ay yiidde de7ishshin, iita ayyaanay A sa7aan oliide kokkorsseedda; Yesuusi iita ayyaanaa agga gi na7aa pathiide A aabboo zaariide immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Asay ubbaykka Xoossaa wolqqaama wolqqaappe denddowaan maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Taana Asaa Na7aa, asay asaa kushiyaan aathiide immanawaa; hinttenttu ha yewuwaa dogoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Shin I giyaawaa unttunttu akeekibeykkino. Unttunttoo gelenna mala unttunttuppe geemmeedda diraw, ha yewuwaa Yesuusa oochchanaw yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A kaalliyaawanttu, “Nu giddoppe dariyawe oonee?” yaagiide palumetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuusi unttunttu wozanaa qofaa eriide, guutha na7aa ahiide, bare matan essiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Ha guutha na7aa ta sunthaan mokkiyaawe ooninne taana mokkeedda; qassi taana mokkiyaa ubbay, taana kiitteedda ta aabba mokkee. Hinttenttu ubbaappe guuxxiyaawe ubbaappe dara” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohaannisikka zaariide, “Godaw, itti asay ne sunthaan iita ayyaanatuwaa kessiyaawaa nuuni be7iide, nu bagga gidenna diraw, A diggeeddo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Shin Yesuusi A, “Hinttenttu giyaawaa phalqqennawe hinttenttu bagga gidiyaa diraw, A diggoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuusi saluwaa biyaa wodii matina, bare wozanaa qofaa Yeerusalaamekko zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bareppe sinthaw ubba yewuwaa giigissana mala, kiitettiyaa asaa Sammariyaa katamaa kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Shin I Yeerusalaame baanaw denddeedda diraw, asay A mokkibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","A kaalliyaawanttu Yayiqoobinne Yohaannisi hewaa be7iide, “Godaw, nuuni Eelaasi udowaadan, tamay saluwaappe yiide unttuntta maanaadan xeesana mala koyyay?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Shin Yesuusi guyye simmiide, unttuntta seereedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","“Taani, Asaa Na7ay, asaa shemppuwaa ashshanaw yoowaappe attin, bayizzanaw yabeykke” yaageedda. Unttunttu harasaan de7iyaa qeeri katamaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Unttunttu ogiyanna biishshin, itti bitani Yesuusa, “Godaw, neeni biyaasaa ubbaa taani neena kaallana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesuusi A, “Worakanatoo ollay, saluwaa kafatookka gollii de7ee; shin taani, Asaa Na7ay, gela shemppa akkiyasay taw baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesuusi hara uraa, “Taana kaalla” yaageedda. Shin, bitani, “Godaw, taani kasiyan baade ta aabba moogana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesuusi, “Hayqqowantta barenttu hayqqowanttu moogino; neeni baade, Xoossaa kawuteethaabaa oda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Qassi hara bitani, “Godaw, taani neena kaallana; shin koyruwaan ta soy asaa baade sarotana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Shin Yesuusi A, “Booraa goshanaw doommowe ooninne guyye xeellooppe Xoossaa kawutethaw bessenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hawaappe kaalla Goday hara laappun tammu asaa sunthiide laa77uwaa laa77uwaa udiide I baanaw de7iyaa katamaa ubbaa kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesuusi unttuntta, “Qoychchaw gakkeedda kathay dara; kiitettiyaa asay guutha. Simmi qoycettiyaa kathaa Goday, qoychchaw kiitettiyaawantta yeddana mala woossite. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Taani dorssatuwaadan wallatuwaa giddo hinttena kiittay, biite. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hinttenttu ogew ayaanne oyqqoppite: borssaa, qarcciitiyaa, caammaa, gidinakka oyqqoppite; asaanna sarotettiidde ogiyaan wodiyaa wurssoppite. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Hinttenttu geliyaa golle ubbaa kasiyan, ‘Sarotethay ha gollew gido’ yaagite. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","He golliyan sarotethaa dosiyaa asay de7ooppe, hinttenttu sarotay he golliyan aqanawaa; koyyennawaa gidooppe, hinttenttu sarotay hinttenttoo simmanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","He golliyan unttunttoo de7iyaawaappe miiddinne ushiidde de7ishshite; oosanchchaw A dirgguwaa cigay koshshee; itti golliyaappe hara golliyaa yuuyyoppite. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ay katamaanne hinttenttu geliyaa wode, asay hinttena mokki akkiide mizanaw shiishshowaa ayaanne miite. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","He katamattin de7iyaa hargganchchatuwaa pathiidde asaw, ‘Xoossaa Kawutethay hinttekko mateedda’ yaagiide odite. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yewuwaan qassi ay katamaanne geloode, asay hinttentta mokki akkennawantta gidooppe he katamaa qadhdhaakko kesinnee, ");
INSERT INTO dwrNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nuuni hinttena yeellayanaw, haray atto nu gediya bollan de7iyaa hinttenttu katamaa baanaakka hinttenttoo qoqqofeetto; yewuwaan qassi, Xoossaa Kawutethay hinttenttukko mateeddawaa erite’ yaagite. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pirdda gallassi ha katamattippe Sodoomaa katamaa gakkeedda muray kawushanawaa yaagaade taani hinttew oday. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Aayye new Koraaziine; aayye new Beetesayde; hinttenttun haneedda malaatatuu Xiiroosa katamaaninne Sidoonaa katamaan haneeddentto, hewaan de7iyaa asatuu kayyuwaa mayuwaa mayyiide, bidinthaa bollan uttiide, benippe barenttu nagaraappe simmanawanttashshin. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hawaa diraw, murettiyaa gallassi hinttenttuppe aathiide Xiiroosa katamawunne Sidoonaa katamaw muray kawushanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hanne Qifirinaahoome, neeni saluwaa pude dhoqqu gaanaw koyyaaddi? Duge Si7ooliyaa wodhdhanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Hinttenttu giyaawaa sisiyaa asay, taani giyaawaa sisee; hinttentta ixxiyaa uray taana ixxee; taana ixxiyaa uray taana kiitteeddawaakka ixxee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Laappun tammu asatuukka, “Godaw, iita ayyaanatuukka ne sunthaan nuussi azazetteeddino” yaagiidde nashechchaan simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesuusikka unttunttoo, “Seexaanay walqqanthaadan saluwaappe wodhdhishshin be7aaddi. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Simmi shooshshaanne sogguwaa yedhdhanaadan hinttenttu morkkiyaa xalahiyaa wolqqaa xoonana mala maataa immaaddi. Hinttentta qohanawe aynneekka de7enna. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Gidoppe attin hinttenttu sunthay saluwaa maziggobiyaan xaafetto diraw, nashettiteppe attin iita ayyaanatuu azazetto diraw nashettoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","He wodiyaan Yesuusi Ayyaanaa Geeshshaan daro nashettiide, “Saluwaanne sa7aa Godaw, neeni ha yewuwaa tamaarowanttuppenne aadho eranchchatuwaappe genthaade, qeeri naanaw qonccisso diraw, neena galatay; E, ta Aabboo, ayissi gooppe, hawaa oothanaw ne lo77o shene gideedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ubba yewuu taw ta Aabbuppe imetteedda. Na7ay oonentto Aawuwappe attishshin ooninne eriyaawe baawa; hewaadankka Aawuu oonentto Na7aappenne I qonccissanaw koyyo uraappe attin, haray ooninne eriyaawe baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kaalliiddekka Yesuusi barena kaalliyaawanttukko simmi wodhdhiide, unttunttu xalalaa, “Hinttenttu be7iyaawaa xeelliyaa ayfatuu anjjetteeddawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ta hinttew odiyaawe ayee gooppe, cora nabatuunne kaatatuu hinttenttu be7iyaawaa be7anaw amotteeddinoshshin be7ibeykkino; hinttenttu sisiyawaakka sisanaw amotteeddino; shin sisibeykkino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Itti gallassi higgiyaa eriyaawe ittu Yesuusa paaccanaw aakko yiide, “Tamaarissiyaawoo, medhinaa de7uwa laattanaw, taani ayaa udoo?” yaagi oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesuusi zaariide, “Muse higgiyaa maxaafan xaafettowe ayee? Neeni ayaa gaade billay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bitaniikka, “Muse higgiyaa maxaafay, ‘Xoossaa ne Godaa polo ne wozanaappe, polo ne shemppuwaappe, polo ne wolqqaappenne polo ne qofaappe siiqa; hewaadankka ne laggethaakka ne huuphiyaadan dosa’ gee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesuusi A, “Likke, tumuwaa gaadda; simmi neenikka hawaa ootha; de7uwan de7anaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Muse higgiyaa tamaarissiyaa bitani qay barena xillo oothanaw koyyiide Yesuusa, “Hanoshshin, ta laggethay oonee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesuusi zaariide, “Itti bitani Yeerusalaameppe Iyyarkko biidde de7ishshin, ogiyaa bollan paannatuu A demmiide, A mayuwaa qaarowaappe guyye shociide, hayqqanaw pollu goode oliide beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Qoppennaan itti qeesay he ogiyaanna bide7iyaawe, shocettiide kunddeedda bitaniyaa be7eedda wode, ayaanne udennaan miyyiyaanna aadhdhiide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hewaadankka itti Leewii he ogiyaanna bide7ee. Ikka bitaniyaa be7iide, miyyeti aadhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Shin Sammaariyaa asa gideedda itti bitani, he bagganna aadhdhiidde, ha bitaniyaakko yeedda. A be7eedda wode aw qaretteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aakkokka shiiqiide, zaytiyaanne woyiniyaa eessaa A maythaan tigiide, qachcheedda. Hewaappe guyye bare hariyaa togissiide, imathay aqiyaa golliyaa akki beedda; hewaan bidhayiidde naageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wonttetha gallassi guutha biraa bare kiisiyaappe kessiide, imathay aqiyaa golliyaa godaw immiide, ‘Ha bitaniyaa taw loytha bidhaya; hawaappe daruwaa neeni kessooppekka, taani simmiyaa wode new ciggana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Simmi ha heezzu asatuwaappe, paannatuwaa kushiyan shocettiide kunddeedda bitanew, lagge gideeddawe haqawaa malatii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Higgiyaa tamaarissiyaawekka, “He aw qarettowaa” yaageedda. Yesuusikka A, “Simmi baade neenikka hewaadan ootha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuusi barena kaalliyaawanttunna ogiyaa biidde, itti heeraa garssa gakkeedda. Hewaan Martto geetettiyaa itti mishiratta bare gollen mokkaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iziwukka Mayraamo geetettiyaa michchatta de7aw; hennakka Yesuusa gediyaa mataan uttaade, I odiyaawaa hayzzaadde de7aw. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martta qay soybaa giigissaadde daabura de7aw; hewaa diraw Yesuusakko shiiqaade, “Hanna ta michchatta, kiitaa ubbaa ta bolla olina, taani taarekka labbanoode xeellaadde co77u gay? Hayyanaa taana maaddanaadan iziw oda” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesuusikka zaariide izo, “Marttee, Marttee, neeni cora yewuwaa qoppaadde hirggaa; qassikka metootaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Shin koshshiyaawe ittibaa; Mayraama bareppe ooninne akkenna lo77obaa dooraaddu” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Itti gallassi Yesuusi ittisaan woosaa woossi de7ee. Woosaa wurssowaappe guyye A kaalliyaawanttuppe ittuu, “Godaw! Yohaannisi barena kaalliyaawantta woosaa tamaarissowaadan, nuunakka neeni waagi woossanentto tamaarissa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ikka unttuntta, “Xoossaa woossiidde yaagi woossite: ‘Saluwan de7iyaa nu aabboo, ne sunthay anjjetto; ne kawutethay yo; ne shenii saluwan hanowaadan sa7ankka hano; ");
INSERT INTO dwrNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","“ ‘Gallassaan gallassaan koshshiyaa qumaa nuussi hachche imma; ");
INSERT INTO dwrNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","“ ‘Nuuni nuuna naaqqeeddawanttuwaa ubbaa atto goowaadan, neenikka nunaaquwaa atto yaaga; nuuna iitaappe naagappe attin, paaciyaan gelssoppa’ yaagite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Qaykka Yesuusi barena kaalliyaawantta, “Hinttenttuppe ittoo siiqo laggi de7intto giddo bilahiyan aakko yiide, ‘Ta siiqo laggew, taw heezzu soolluwaa tal77a; ");
INSERT INTO dwrNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ayissi gooppe, itti ta laggethay yiina A miziyaawaa dhayaaddi’ yaagi woosseedda goytte. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bare gollen de7iyaa A siiqo laggi soyippe haasayiidde, ‘Taana metoothoppa; penggi qashetteedda; tanaanaykka taananna giseeddino; hewaa diraw taani denddaade new aynne immanaw danddaykke’ gaanawee? ");
INSERT INTO dwrNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Taani hinttenttoo odiyaawe ayee gooppe, I aw siiqo laggiyaa gido diraw, immennenttonneekka un77etho diraw I koyyiyaawaa ubbaa immee. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hawaa diraw, ‘Woossite, hinttenttookka imettanawaa; koyyite, demmanita; kariyaa yiide xeesite, hinttenttoo dooyettanawaa’ yaagay. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gaasuukka, woossiyaa ubbay akkanawaa; koyyiyaa uraykka demmanawaa; kariyaa yiide xeesiyaa uraw, kari dooyettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Hinttenttu giddoppe bare na7aw, moliyaa woossina shooshshaa, qumaa imma giina shuchchaa immiya aawuu de7ii? ");
INSERT INTO dwrNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Woy quuqulliyaa woossina sogguwaa immiyee? ");
INSERT INTO dwrNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hinttenttu iita gidi de7iidde hinttenttu naanaw lo77obaa immiyaawaa erooppe, yaatina saluwan de7iyaa hinttenttu aawuu barena woossiyaawanttoo Ayyaanaa Geeshshaa wooti darissiide immanddeeshsha?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Itti gallassi Yesuusi itti bitaniyaappe duudissiyaa ayyaanaa kessowaappe guyye duude bitani haasayaa doommina, asay maalaletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Shin unttunttuppe ittu ittu, “Gaalenatuwaa kaappuwaa Bi7eel-Zebuuli aw wolqqaa immina gaaleenatuwaa kessee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ittu ittu qassi Yesuusa paaccanaw saluwaappe malaataa bessanaadan aappe koyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Shin Yesuusikka unttunttu qofaa eriide unttuntta hawaa yaageedda: “Bare giddon shaakettiyaa kawutethay ubbay dhayanawaa; shaakettiyaa golliikka kunddee. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yaatina Seexaanaa kawutethay bare giddon shaakettooppe A kawutethay wooti eqqanawee? Hinttenttu taana, ‘Xalahiyaa kaappuwaa Bi7eel-Zebuuli new wolqqaa immina kessaa’ yaagi haasayiita. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Simmi taani bi7eel-zebuula wolqqaan gaaleenatuwaa kessiyaawaa gidooppe hinttenttu naanay O wolqqaan kessanawanttee? Hawaa gidiyaa diraw, unttunttu hinttenttu bollan pirddiyaawantta gidanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Shin taani gaaleenatuwaa kessiyaawe Xoossaa wolqqaana gidooppe, simmi Xoossaa kawutethay hinttenttukko yeeddawaa erite. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Wolqqaama asay bessiyaawaadan minniide bare golliyaa naagooppe, A shaluu loythi naagettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yewuwaan qassi aappe minuwaa dariyaawe yiide A qohooppenne xoonooppe I ammanetteedda tooraanne gonddalliyaa aappe wothi akkiide, aw de7iyaa miishshaa gishetti akkee. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ta bagga gidennawe taananna eqettee; taananna shiishshi beennawekka laalee. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Tuna ayyaanay asaappe keseedda wode, barew shemppiyaasaa koyyiidde, haathay banttasaanna aadhdhi bee. Shemppiyaasaa demmennaan attooppe, ‘Taani kase yegga keseedda ta golliyaa simmana’ yaagee; ");
INSERT INTO dwrNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","simmiyaa wodekka golli pitettiide giigowaa demmee. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hewaappe kaalla, biide haraa aappe iita laappu tuna ayyaanatuwaa akki yaa geliide, hewaan de7iino; he bitaniyaa de7uu koyrowaappe kaallawe iitowaa gidee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuusi hawaa haasay de7ishshin, itti mishiratta cora asaa giddoppe bare kooshshaa dhoqqu oothaade, “Neena yeleeddawunnanne dhantheedda ne daaya anjjetteeddawunno” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesuusi qassi, “Anjjetteeddawanttu Xoossaa qaalaa sisiide azazettiyaawantta” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cora asay shiiqo wode Yesuusi, “Ha yeletay iita; ooratha malaataa koyyee; shin nabiyaa Yoonaasa malaataappe haray imettenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gaasuukka Yoonaasi Nennewe katamaa asaw malaata gidowaadan, Taani, Asaa Na7aykka, ha yeletaw malaata gidana. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Away mokkiyaasaa xeelliyaa wode, ushechcha dugebagganna de7iyaa gadiyaa kaatatta Solomonew de7iyaa aadho eratethaa sisanaw biittaa gaxaappe yeedda diraw, pirddaa wode ha yeletaan denddaade pirddanawunnu; be7ite, Solomoneppekka aadhdhiyaawe hawaan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nennewe asay pirddaa wode hinttenttu bolla denddiide pirddanawantta; ayaw gooppe, unttunttu Yoonaasi odowaa sisiide barenttu nagaraa paaxi simmeedda diraassa; be7ite, Yoonaasappe aadhdhiyaawe hawaan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Soy geliyaa asaw poo7anaadan, Xomppiyaa xomppiide dhoqqasaan wothanaappe attin, geemasaan woy poo7uwaa kammiyaa yewuwaappe garssanna wothiyaawe ooninne baawa. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ne asatethaw ne ayfii xomppiyaa mala; ne ayfi paxa gidooppe ne kumentha asatethaykka poo7uwaa demmee; shin ne ayfii harggooppe ne kumentha asatethaykka dhumaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Akeeka; hewaa gidiyaa diraw, ne garssan de7iyaa poo7uu dhumennaadan naagetta. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Simmi ne asatethay ubbay poo7uwan kumeeddawaa gidooppenne, dhumeedda asatethay neenan baynnawaa gidooppe, ne asatethay ubbay, xomppii bare poo7uwaa ne bollan poo7issiyaawadan, ne bollan wagagga poo7uwaa gidanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuusi haasayaa wurssowaappe kaalla, itti Parisaawe bitani bare gollen qumaa maanaadan ataalleedda; Yesuusikka ittippe geliide gayitaan utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Parisaawiikka Yesuusa qumaa maanaappe kasiyan kushiyaa meecetti beennawaa be7iide maalalettina, ");
INSERT INTO dwrNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Godaykka, “Hinttenttoo Parisaawatoo, xuu7aanne shaataa bolla bagga geeshshiita; shin hinttenttu garssay uuziyaaninne iitatethaan kumeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hinttenttoo eeyatoo! Bolla bagga medhdheeddawe garssaa medhdhibeennee? ");
INSERT INTO dwrNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Shin hinttenttu xuu7aaninne shaataa garssan de7iyaawaa hiyyeesatoo immite; hewode ubbabaykka hinttew geeshsha gidanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Shin hinttenttoo Parisaawatoo, hinttew aayyee! Ayaw gooppe, anuugaappenne xalotiyaappe, aguppiyaa do7uwaappe, tammu kushiyaappe itti kushiyaa Xoossaw immiita; shin tumu pirddaanne Xoossaa siiqiyaawaa hinttenttu aggiita. Yewuwaan qassi hewaa aggennaan hawaa oothanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Hinttenttoo Parisaawatoo, hinttew aayyee! Ayaw gooppe, Ayihuda asaa woosa gollen bonchcho utuwaa, geyaa giddonikka bonchcho sarotaa koyyiita. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Asay erennaan bollanna hamettiyaa beettenna duufuwaa malatiyaa diraw hinttew aayyee!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Muse higgiyaa tamaarissiyaawanttuppe ittuu, “Tamaarissiyaawoo, neeni hawaa yaaga haasayo diraw nuuna boraadda” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesuusi, “Hintteno higgiyaa eriyaawantto, henttew aayyee! Ayaw gooppe, asay tookkiide danddayenna deexo tookuwaa haraa toossiita; shin hinttenttu hintte huuphew biradhdhiyankka bochchikkita. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Hinttenttu aawotuu wodheedda nabatuwaa duufuwaa loythiyaa diraw hinttew aayyee! ");
INSERT INTO dwrNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Simmi hinttenttu aawotuu nabatuwaa wodhina, hinttenttu unttunttu duufuwaa bollan golliyaa keexxiyaa diraw, ‘Nabatuwaa oosuu lo77a’ yaagiide, unttunttuwaa markkattiita. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hawaa diraw, Xoossaa aadho eratethay, ‘Taani nabatuwaanne Yesuusi kiittowantta unttunttukko kiittana; unttunttukka hewanttuppe ittuwaa ittuwaa wodhanawantta; ittuwaa ittuwaa metoothanawantta’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hawaa gidiyaa diraw, ha alami medhettoodeppe doommiide gukkeedda nabatuwaa suuthaw ha yeletay ooshettee. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aabeelappe doommiide yarshshuwaasaappenne geeshsha golliyaappe gidduwan gukkeedda Zakkaraasa suuthaa gakkanaw koyettee. E! Taani gay; ha yeletay hawoo ooshettiyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Hinttenttoo Muse higgiyaa eriyaawanttoo, hinttew aayyee! Ayaw gooppe eraa penggiyaa dooyyiyaa qulppiyaa akkeeddita. Hinttenttu hintte huuphewukka gelibeykkita; qassi gelanaw koyyiyaawanttakka diggeeddita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuusi hewaappe kesowaappe guyyiyaan, higgiyaa tamaarissiyaawanttunne Parisaawatuu A ooshaan urggunthussaanne eqettussaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","A doonaappe lo77ennabay kesooppe ooyqqanaw geeddiino; shin demmibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","He wodiyaan cora sha77aan paydettiyaa asay ittu ittuwaa yedhdhana gakkanaw shiiqi de7ishshin, Yesuusi barena kaalliyaawanttoo koyro odanaw doommiidde, “Parisaawatuwaa irshshuwaappe naagettite; hawekka lo77a malatiyaa unttunttu immiyaa iita timirttiyaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Shin ayaaninne kametteedda yewuu qoncciyaa kesennaan attenna; qassikka geemmeedda yewuu erettennaan attenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hewaa diraw hintte dhumaani haasayowe ubbay, gallassi poo7uwan sisettanawaa; hinttenttu asay baynnasaan hini giso golliyaan haythaan saasukkowe ubbay dhoqqu geedda sisettiyaa qonccesaan awaajjettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Taanaadan ammaniyaawanttoo, taani hinttew yaagay; ha77i ashuwaa wodhiyaawantta, hewaappe kaalla qay ayaanne oothanaw danddayennawantta yayyoppite. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yewuwaan qassi hinttenttu oossi yayyanaw bessintto taani hinttentta erissana; hewekka wodhowaappe guyyiyaan gaannamiyan olanaw maatay de7iyaa Xoossaa xalalaw yayyite; E, aw yayyite yaagay. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ichcheshu suunniyaa kafatuu santtimiyaan shamettikkinoyee? Hewanttuppe ittinnonne usa Xoossay dogenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Shin haray atto hinttenttu huuphiyan de7iyaa binnanay ubbaykka paydetteeddawaa; hawaa diraw yayyoppite; hinttenttu cora suunniyaa kafatuwaappe dariita. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Taani hinttew oday; tabaa asaa sinthan markkattiyaawoo oossinne Taanikka Asaa Na7ay, qassi Xoossaa kiitanchchatuwaa sinthan markkattana; ");
INSERT INTO dwrNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","shin asaa sinthan taana kaddiyawantta taanikka asaa na7ay, qassi Xoossaa kiitanchchatuwaa sinthan kaddana. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ta bolla, asaa na7aa bolla, boriyaa qaalaa haasayiyaawe de7ooppe A naaquu atto geetettana; shin Geeshsha Ayyaanaa bolla boriyaa qaalaa haasayiyaawe de7ooppe qay A naaquu atto geetettenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Asay hinttentta Ayihude woossiyaa golliyaakko, gadiyaa ayissiyaawanttukkonne maatay de7iyaawanttu sintha pirddaassi shiishshiyaa wode, ‘Waagi zaaraneeshsha? Woy ayaa giide haasayaneeshsha?’ yaagiide hirggoppite; ");
INSERT INTO dwrNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ayaw gooppe, hinttena Ayyaanaa Geeshshay hinttenttu he saatiyaan haasayanaw bessiyaabaa tamaarissanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Asaa garssappe itti bitani Yesuusa, “Tamaarissiyaawoo, nu aabbu hayqqina nuuni laattana mala atteeddabaa, taw gishana mala hayyagodo ta ishaw oda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesuusi qay, “Ha bitanew, hinttenttu bollan pirddiyaawaa gidanaadanne hewaa hinttew gishanaadan taana oone suntheeddawe?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gujjiidekka ubbatuwaa, “Asaa shemppuwaassi shaluwaa duretethay de7uwaa immenna diraw, yaaretiyaawaappenne yorattiyaawaappe naagettite; duretethaa amuwaa ubbaappekka hinttena naagite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kaalliiddekka hawaadan yaagi leemisuwaa unttunttoo odeedda: “Aw de7iyaa biittay darissiide kathaa mokkeedda itti dure bitani de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ha bitani, ‘Taw ta kathaa wothanaw gidiyaa sa7ay banttawaa diraw ayaa udooshsha?’ yaagiide, bare wozanaan qoppeedda; ");
INSERT INTO dwrNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","hawaadan yaagi maleedda; ‘Taani wootane gooppe, taw de7iyaa yeesiyaa kolaade, hara aakkiya yeesiyaa medhdhana yaagiide maleedda; hewaan ta kathaanne taw de7iyaa miishshaa ubbaa wothana. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yaataade taana, “Ne kaacay daro lo77a; new daro wodiyaassi gidiyaa maxuwaa shiishshaadda; simmi shemppaade ma, usha, nashetta” gaana’ yaageeddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Shin Xoossay A, ‘Ha boozaw, hachche qamma neeni hayqqaa. Yaatina ha neeni shiishsheedda maxuu ubbay oossi gidanawee?’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Barew biittaa bollan shaluwaa shiishshiyaawe, Xoossaa sinthan qay manqqo gideedda asay habitaniyaa mala” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hawaappe kaalla Yesuusi barena kaalliyaawantta, “Hawaa diraw, ta hinttew oday: hinttenttu paxa de7anaw ayaa maanee? Hinttenttu bollaassi ayaa mayyanee? yaagiide hirggoppite. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","“Gaasuukka, shemppuu qumaappe, qassi asatethay mayuwaappe aadhdhennee? ");
INSERT INTO dwrNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ane quuratuwaa xeellite; unttunttu zerikkino; cakkikkino; unttunttoo kathaa shiishshiyaa sa7ay woy yeesii baawa; hanoppe attin, unttuntta Xoossay mizee; hinttenttu kafatuwaappe daroppe darikkitee? ");
INSERT INTO dwrNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hinttenttuppe darii qoppiide daro wodiyaa de7anaw danddayiyaawe oonee? ");
INSERT INTO dwrNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Simmi hinttenttu ha laafabaa oothanaw danddayennawantta gidooppe ayaw harabaw hirggettiitee? ");
INSERT INTO dwrNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ciishshatuu wooti dicciinontto ane xeellite; unttunttu kiitaan daaburikkino; puuttuwaa suqqikkino; gidoshshin taani hinttew odiyaawe, Solomone hewaa keena bonchchetteeddawaa gidiide, he ciishshatuwaappe ittuwaa malaanne mayyibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hinttenttoo laafa ammanuu de7iyaawanttoo, yaatooppe Xoossay hachche beettiide, wontti tamaan eexxanaw olettiyaa, denbban doliyaa maataa hawaadan mayizziyaawaa gidooppe, hinttentta wootiide unttunttuppe aathiide mayizzennee? ");
INSERT INTO dwrNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Hawaa diraw, ‘Ayaa maanee? Ayaa ushanee?’ yaagiide ubba wode koyyoppitenne hirggoppite. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ayaw gooppe, hawaa demmanaw ha alamiyaan de7iyaa Xoossaan ammanettenna asay hirggettiino. Hinttenttoo hawe ubbay koshshiyaawaa saluwan de7iyaa hinttenttu aawuu eree. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hewaa haniyaawaa aggiide, Xoossaa kawutethaa koyyite; I hinttentta koshshiyaawaa ubbaa immanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Hinttenttu guutha gidinttonne, saluwaa hinttenttu aawuu bare kawutethaa hinttenttoo immanaw nashetteedda diraw yayyoppite. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Hinttew de7iyaawaa zali77iide manqqoo immite; kayisuu shiiqennasaan, bil77aykka meennasaan, saluwan wurenna miishshaa dagayiidde, ecenna qarccitatuwaa hinttenttu huuphew wothite. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ayaw gooppe, hinttenttu wozanay hintte miishshay de7iyaasaan de7anawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Hintte xeessay danccettowaa, hintte xomppiikka po7eeddawaa gido. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Hinttenttukka, barenttu Goday yiide penggiyaa qoxxiyaa wode, ellekka dooyyanaw bullachchaappe simmana gakkanaw naagiyaa oosanchchatuwaa malatite. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Barenttu Goday soy yeedda wode beegotti de7ishshin demmiyaa he oosanchchatuu anjjetteeddawantta. Taani tumuwaa gay; I unttuntta, ‘Uttite’ giide, bare danccuwaa minissiide unttunttoo qumaa aathiide shoobbanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Goday hekka bilahiyan woy hekka bilahiyappe kaalla yeedda wode, beegottiide gencci naagiidde beettiyaa qoomatuu anjjetteeddawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hawaa qay erite; kayisuu ay saatiyaan yintto golliyaawuu erintto, golli bookettiyaa wode co77u giide xeellennashshin. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Asaa na7ay qoppenna saatiyaan yaanawaa; hinttenttu giigetti naagite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Phexiroosikka “Godaw, ha leemisuwaa neeni odiyaawe nuxalalaassee haraa ubbaassikka ittippe oday?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Godaykka, “Simmi unttunttu bare soy asaw qumaa immanaw bessiyaa saatiyaan immana mala, A goday sunthiyaa ammanetteeddanne eranchcha miziyaa qoomay oonee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Goday simmiyaa wode hawaadan kiitettiina demmiyaa qoomay I anjjetteeddawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Taani hinttew tumuwaa oday; de7iyaa maxuwaa ubbaa bollan A sunthanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yewuwaan qassi he qoomay, “Ta goday elle yeenna; gami77anawaa” yaagi bare wozanaan qoppooppenne attumanne macca qoomatuwaa shochchaa doommooppe, qaykka koyyowaadan muussaanne ushshaa, mathottussaakka doommooppe, ");
INSERT INTO dwrNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","he qoomaa goday, I qoppenna gallassinne sidhibeenna saatiyaan yaanawaa; he wodiyan A qanxxereethiide, A gishuwaa maadaaraakka ammanennawanttunna ittisaa udanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bare godaa sheniyaa eriide giigennawenne aasheniyaadan kiitettenna qoomay, I iita dhoobaa dhoobettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Eribeennawe qay dhoobettanaw bessiyaawaa udeeddawe, guuthaa dhoobettee. Darobay imetteedda asaa ubbaappe, aappe darobay koyettee; wolqqaama hadaray imettowaappe, aappe darissiide koyettee. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesuusi, “Taani yeeddawe, ha sa7aa bolla tamaa sathanaassa; ha77ikka eexxeeddentto, taana ay keena nashechchanaweeshsha. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Taani xammaqettana metuwaa xinqqatay polettana gakkanaw waanaade un77ettaytaa! ");
INSERT INTO dwrNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ha sa7aa taani yeeddawe, sarotethaa ahanaassa malatiiyee? Hinttew malatoppo. Taani yoowe, sarotaassi gidennaan shaakkanaassappe attin. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ayaw gooppe, ha77ippe doommina itti golliyan de7iyaa ichcheshu asatuu shaakettanawantta; heezzatuu laa77atuwaa bolla, laa77atuukka heezzatuwaa bolla denddiide walaqettanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aawuu na7aa bolla, na7aykka aawuwaa bolla, aatta naatti bolla, naattakka aatti bolla, bollotatta na7aa machchi bolla, na7aa machchakka bollotatti bolla, walassaan denddiide shaakettanawantta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Qaykka Yesuusi asaassi, “Away wulliyaa bagganna hintte shaariyaa be7ooppe, ‘Ha77i ha saatiyan hekko wolqqaama iray bukkana hanee’ yaagiita; tumukka qay bukkee. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Duge bagganna carkkuu carkkoode, ‘Hachche shammanawaa’ yaagiita; geetettowaadankka qay hanee. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hintteno lo77a malatiyaa iitatoo, sa7aanne saluwaa xeelliide, hananawaa eriita; shin ha wodiyaabaa wooti eranaw danddaykkitee? ");
INSERT INTO dwrNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Wode hinttenttu xillo gideedda yewuwaa hinttenttoo ayaw pirddikkitee? ");
INSERT INTO dwrNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ne morkkiyaanna ittippe pirddiyaa daannaa sinthan shiiqanaw boode, biro ogiyaa bolla de7ishshin sigetta digga. Hewe dhayooppe neena goochchiide pirddiyaa daannaakko afana; daannaykka polisew aathi immanawaa; polisii qasho gollen yegganawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Taani new odiyaawe, wursethaa acuwaa ciggana gakkanaw hewaappe kesakka” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","He wodiyaan itti itti asatuu Yesuusakko yiide Philaaxoosi Galiilaa asaa wodhiide unttunttu suuthaa yaarshshuwanna ittippe walakkeeddawaa aw odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesuusikka zaariide, “Hawanttu Galiilaa asatuu hayqqeedda diraw, yaatina unttunttoo hara Galiilaa asaa ubbaappekka aadhdhiide nagaranchchatuwaa gidowantta malatiinoo? ");
INSERT INTO dwrNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Taani yaagay, hawaadan gidenna; yewuwaan qassi hintte nagaraa paaxiide nagaraappe simmennaan ixxooppe, hinttenttu ubbatuukka hewaadan hayqqiita. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Woy Salihooma gimbbii unttunttu bolla kunddiide, wodheedda tammanne hosppun asatuwaa Yeerusalaamen de7iyaawanttu ubbaappe aadhdhiide naaqqowantta malatiinoo? ");
INSERT INTO dwrNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Hawaadan gidenna yaagay; yewuwaan qassi nagaraa paaxana dhayooppe ubbatuukka hawaadan bayanita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesuusikka hawaadan yaagi leemisuwaa odeedda, “Itti bitanew woyiniyaa turaa goshshaa gaden toketteedda balasiyaa geetettiyaa ayfii meetettiyaa mithatta de7aw; he bitaniikka mithatta ayfaaddenttonne giide yeeddawe, aynneekka ayfiyaa demmibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Woyiniyaa turaa naagiyaawaa I, ‘Taani ha balasiyaa geetettiyaa mithattippe ayfiyaa demmanaw heezzu laythaa simerettaade ayaanne demmabeykke. Hewaa diraw deka dentha digga; ayaw biittaa coo melissay?’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Naagiyaawekka zaariide, ‘Godaw, taani I yuushshuwaa harumanaassinne pituwaa olanaassi, ha laythaa xalalaw basha. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sinthaw ayfooppe lo77a; shin ayfennaan ixxooppe dekettu’ geedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesuusikka itti Sambbataa gallassi Ayihudaa woosa gollatuwappe ittuwaan tamaarissi de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hewaanikka tammanne hosppun laythaa kumenthaa tuna ayyaanay quunisseedda mishiratta de7aw. Izakka suuraade eqqanaw aynne danddayabeykku. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuusikka izo be7eedda wode xeesiide, “Ha mishirattee, ne harggiyaappe paxaadda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesuusi bare kushiyaa izi bolla wothina, hewode suura sitti ga eqqaade bare Xoossaa galataaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Shin Ayihuda woosa golle kaappuu qassi Yesuusi Sambbataan patheeddawaa diraw hanqqetti zaarowaashshin asatuwaa, “Kiitettanaw bessiyaa usuppun gallassatuu de7iino; he gallassatun yiide paxiteppe attin Sambbataan gidenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Godaykka zaariide, “Ha lo77a malatiyaa iita asatoo, hinttenttuppe ittuunneekka Sambbata gallassi booraa magaduwappe woy hariyaa gaaxaataappe billiide haathaa ushshanaw afennee? ");
INSERT INTO dwrNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hanna Abraahaamo yaraa gideeddawunna, tammanne hosppun laythaa kumenthaa xalahii qachcheeddawunna sambbata gallassi he qashuwaappe bilettanaw bessekkee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hawaa odeedda wode eqettiyaawanttu ubbay yeellateeddino; asay ubbay qay I ootheedda maalalissiyaa oosuwan ubbaan nashetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuusikka, “Xoossaa kawutethay ayaa malatii? I ayaa malatintto, taani hinttentta woota bessoo? ");
INSERT INTO dwrNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Xoossaa kawutethay sannaaficiyaa geetettiyaa qeeri mithatti ayfiyaa malatee. He mithatti ayfiyaa asay akkiide goshshaa garssan zereedda; zerettoonna diccaade wogga mithaa gidaaddu; yaatina saluwaa kafatuukka izi aacaa bolla barenttoo golliyaa keexxeeddino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesuusikka zaariide, “Xoossaa kawutethay ayaa malatintto, taani hinttentta woota bessoo? ");
INSERT INTO dwrNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Itti mishiratta heezzu keriyaa dhiilliyaa akkaade, munaqqeedda munaqay ubbay denddana gakkanaw, aani tigeedda irshshuwaa malatee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hewaappe kaalla Yesuusi Yeerusalaame biide, wogga katamaaninne qeeri katamaan de7iyaa asaa tamaarissiidde aadhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","He wode itti bitani shiiqiide A, “Godaw, Xoossaa pirddaappe attiyaawanttu guutha asa xalalee?” yaageedda. Hewaappe guyye Yesuusi unttuntta, ");
INSERT INTO dwrNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Taani hinttenttoo oday; un77a penggiyaanna gelanaw baaxetite. Cora asay gelanaw koyyiino; shin danddaybeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Golliyaawuu denddiide, ipithaa qachchowaappe guyye hinttenttu karen eqqiide, ‘Godaw, Godaw, nuussi dooyyaarikkii’ yaagiide xeessaa doommiyaa wode, ikka zaariide, ‘Haqappe yeedditentto, taani hinttentta erikke’ yaaganawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“He wode hinttenttu, ‘Nuuni neenanna ittippe meeddo; usheeddo; neeni nu heerankka tamaarissaadda’ yaaganawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Yesuusi qassi, ‘Taani hinttenttoo oday; hinttenttu haqappe yeedditentto, taani hinttentta erikke; ubbatuukka makkalanchchatuu tamatappe haakkite’ yaagaanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Abraahaamo, Yisaaqi, Yayiqoobinne nabatuu ubbay hinttenttu karen eqqishshin, Xoossaa kawutethaan de7iyaawantta hinttenttu be7iyaa wode, hinttenttoo yeekonne achchaa dhaquwaa gidanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","“Asay away doliyaasaappenne wulliyaasaappe, qassi killibaggappenne hirkkibaggappe yiide, Xoossaa kawutethaa gayitaan uttiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Be7ite; guyyeteeddawanttu, sinthatanawantta; sinthateeddawanttu qay guyyetanawantta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","He wode Parisaawatuwaappe ittu ittu Yesuusakko yiide, “Heroodise neena wodhanaw koyyiyaa diraw, hawaappe badigga” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesuusi zaariide, “Biide he worakanaassi, ‘Hachchenne wontti iita ayyaanatuwaa kessana; hargganchchatuwakka pathana; heezzentho gallassi ta oosuwaa wurssana’ yaagite. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hanoppe attin nabii Yeerusalaameppe harasaan hayqqanaw bessenna diraw, taani hachche, wonttinne wonttipeeshi ogiyaa bolla de7anaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yeerusalaame katamaa asaw, Yeerusalaame katamaa asaw, Nabatuwaa wodhiyaawanttoo, hinttenttukko kiitettowantta shuchchaan caddiyaawanttoo, kuttatta bare maratuwaa bare qefiyaappe garssanna shiishsha haphphiyaawaadan, taani hinttenttu naanaa itti gadiyaa shiishshanaw aappu gede koyyaadditaa! Shin taana diggeeddita. ");
INSERT INTO dwrNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Be7ite; Xoossay hinttenttu golliyaa aynne olibeenna; taani hinttenttoo yaagay; hinttenttu, ‘Godaa sunthaan yiyaawe anjjetteeddawaa’ gaana gakkanaw, taana be7ikkita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sambbata gallassi Parisaawatuwaa sunthatuwaappe ittuwaa golle Yesuusi qumaa maanaw geleedda wode, ayaa kiitettintto be7anaw asatuu naagide7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bollay gaafina metootiyaa itti bitani Yesuusappe sinthanna de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesuusi higgiyaa tamaarissiyaawanttanne Parisaawatuwaa, “Sambbataan pathanaw danddayetti danddayettennee?” giide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Unttunttukka co77u geeddino. I he bitaniyaa bollaa bochchi pathiide A moyizzeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesuusi unttuntta, “Hinttenttuppe harii woy booray ollaan kunddintto, Sambbataa giide elleelli kessennawe oonee?” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Unttunttukka ha yewuwaassi itti zaaruwanne immanaw danddayibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesuusi shoobettowanttu bonchchosaa dooriyaa wode xelliide, ");
INSERT INTO dwrNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ooninne bullachchaa xeesooppe, bonchchetteeddasaan uttoppa; ooni eri neeppe aathiide bonchchettowe xeesetteeddawaa gidanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Neenanne aanne xeesawe yiide, ‘Hawo, utuwaa aw yeedda’ yaagina; hewodiyan yeellataade xadenna de7iyaasaan utuwaa doommaasa; ");
INSERT INTO dwrNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yewuwaan qassi neeni xeeseetto wode neena xeesowe yiide, ‘Ta laggew, killi dhoqqasaan utta’ gaana mala, baade ubbaappe hokasaan utta; he wode neenanna ittippe utteeddawanttu ubbatuwaa sinthan new bonchchuu imettanawaa; ");
INSERT INTO dwrNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bare huuphiyaa dhoqqu udiyaa ubbay tooshettanawaa; bare huuphiyaa toochchiyaawanttu dhoqqu giino” yaagi leemisuwaa unttunttoo odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesuusi barena xeeseeddawaa zaariide, “Neeni laaxaa woy kawuwaa giigisseedda wode, ne laggethatuwaa woy ne ishatuwaa woy dure ne shooratuwaa xeesoppa; ayaw gooppe, unttunttu neena barenttu taraan xeesiide kushiyaa ciggana danddayiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Shin ataalliyaabaa giigisseedda wode, hiyyeesatuwaa, gunddatuwaa, doomatuwaanne qooqatuwaa xeesa. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Unttunttu new kushiyaa zaaranaw danddayennawantta gidiyaa diraw, neeni anjjettanaassa. Xillatuu hayquwaappe denddiyaa wode Xoossay new kushiyaa zaaranawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuusi haasayaa wurssiyaa wode, qumaa maanaw utto asaappe ittuu hawaa sisiide, “Xoossaa kawutethaa gayitaan uttiyaawe anjjetteeddawaa” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesuusikka hawaadan geedda; “Itti bitani daro lo77o kawuwaa giigissiide, cora asatuwaa xeeseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kawuwaa wodii gakkina, kase xeesettowantta, ‘Ha77i kawuu giigeedda, haayite’ giide xeesana mala bare gollen kiitettiyaa qoomaa unttunttukko kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Shin ubbatuukka ittippe, beennaadan aggana mala woosseeddino; koyro bitani qoomaw odiidde, ‘Taani biittaa shammeedda diraw baade be7anaw koshshee; hewaa diraw hayya godo taw hanqqettoppaarikki’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Laa7ethiyaawe qassi, ‘Taani ichcheshu waatha booratuwaa shammeeddawantta waaxa be7anaw biya diraw, hayya godo taw hanqqettoppaarikki’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Haray qassi, ‘Taani machchatto akkeedda diraw, yaanaw daanddayabeykke’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Qoomaykka yiide bare godaw, hanowaa ubbaa odeedda. He wode Goday daro hanqqettiide, bare golliyan kiitettiyaa qoomaa, ‘Hini katamaa ogiyaanne loosso ogiyaa elleellaade kesa; manqqatuwaanne gunddatuwaa, doomatuwaanne qooqatuwaa haa akkaade ya’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“A qoomaykka, ‘Godaw, neeni taana azazowaadan oothaaddi; shin ha77ikka hara asaa akkiyasay de7ee’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Godaykka bare qoomaa, ‘Ta gollii kumanaadan hini ogiyaappe kare bagganne dirssaa gaxaa ubbaa kesaade, asaa ta golle akkaade ya. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ayaw gooppe, koyro ta golle shoobetteeddawanttuppe itti asaynne ta qumaa meenna’ geedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cora asay Yesuusanna ittippe bide7iyaa wode, ikka asaakko guyye simmiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ooninne taakko yiyaawe de7ooppe bare aabbanne aatto, bare machchattonne bare naanaa, bare ishatuwaanne michchatuwaa, bare de7uwaa ashshennaan taappe aathi dosooppe, taana kaalliyaawaa geetettanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ooninne bare masqqaliyaa tookkiide, ta geeduwaa kaallennaan dhayooppe, taana kaalliyaawaa gidanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Hinttenttuppe ittuu shuchchaa golliyaa keexxanaw koyyooppe, kiitaa wurssanaw gidiyaa shaluwaa kasetiide utti heettennawe oonee? ");
INSERT INTO dwrNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Hewe dhayooppe, golliyaa doommiide, kiitaa wurssanaw wolqqay ixxooppe, ");
INSERT INTO dwrNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","be7eeddawanttu ubbay, ‘Ha bitani keexxanaw doommeedda; shin kiitaa wurssanaw ixetteedda’ giide qilliicciino. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Woy tammu sha77a olanchchatuwaa oyqqeedda itti kaatii, hara laatamu sha77a olanchchatuwaa oyqqeeddawanttunna olettanaw danddayooppenne koyronna, taani xoonanee xoonikkitaashsha giide utti qoppennee? ");
INSERT INTO dwrNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Barew danddayettennaan dhayooppe, olaw yiyaa yokko kaatii haakuwan de7ishshin kiittiide sigettanaw woossee. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Simmi hawaadankka hinttenttuppe ooninne barew de7iyaawaa ubbaa aggennawe, taana kaalliyaawaa gidanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Maxinii lo77a; shin loqiloqennaan dhayooppe, laa7etho A wooti loqiloqissanaw danddayettii? ");
INSERT INTO dwrNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Biittawukka lo77enna; tu7eyanawukka maaddennawaa gido diraw, asay A oli aggee. Sisiyaa haythay de7iyaawe hawaa siso” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Itti gallassi, qaraxaa shiishshiyaawanttunne nagaranchchatuu ubbay Yesuusa sisanaw aakko shiiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisaawatuunne Muse higgiyaa tamaarissiyaawanttu, “Ha bitani, nagaranchchatuwaa shiishshiyaawaanne unttunttunna qumaa miyaawaa” yaagiide zuuzummeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesuusikka leemisuwan zaaruwaa hawaadan yaagi odeedda: ");
INSERT INTO dwrNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Xeetu dorssay de7iyaa uray hinttenttu giddoppe de7intto hewaappe ittuu bayintto udduppu tammanne udduppunuwaa denbban aggiide bayeeddawaa beettana gakkanaw koyyennawe oonee? ");
INSERT INTO dwrNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Demmeedda wode nashechchaan bare hashiyaa bollan dorssaa tookki, ");
INSERT INTO dwrNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","bare golle simmiide, bare dosiyaawanttanne shooratuwaa ittippe xeesiide, ‘Bayeedda ta dorssaa demmo diraw, taananna ittippe nashettite’ yaagiide odee. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hewaadankka nagaraa paaxethaa koshshenna udduppu tammanne udduppu xillatuwaappe aathiide nagaraa paaxiyaa itti nagaranchchaan saluwan daro nashechchay gidanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Qaykka tammu nahaasiyaa santtimii de7iyaa mishiratta tammuwappe ittuu bayintto demmana gakkanaw xomppiyaa xomppaade, golliyaa pittaade loytha koyyennawunna iza oonee? ");
INSERT INTO dwrNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Izakka demmeedda wodiyaan bare dosiyaawanttanne bare shooratuwaa ittippe xeesaade, ‘Taappe bayeedda santtimiyaa demmeedda diraw, taananna ittippe nashettite’ yaagaade odaw. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hewaadankka nagaraa paaxiyaa itti nagaranchchaa gaasotethaan Xoossaa kiitanchchatuwaa sinthan nashechchay hananawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Gujjiide Yesuusi, “Laa77u naanay de7iyaa itti bitani de7ee; ");
INSERT INTO dwrNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","unttunttuppekka teefa na7ay, ‘Ne maxuwaappe taana gakkiyawaa imma’ geedda. Aawuukka bare maxuwaappe naanatoo gisheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Guutha wodiyaappe guyyiyan teefa na7ay barena gakkeeddawaa ubbaa shiishshi akkiide hini haako gade beedda; hewaan bare akkeedda miishshaa ubbaa laali wurssi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ikka de7iyaawaa ubbaa wursseeddawaappe guyyiyan he gaden wolqqaama koshay geleedda; ikka metuwan un77ettussaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hawaa diraw he gaden de7iyaawanttuppe ittuwakko shiiqiide, ‘Taana new qoomaa oothaarikkii?’ yaagina, bitaniikka bare gudunthaa wudiyaa heemmana mala A dembbaa yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Gudunthaa wudii miyaa hal77uwaa maanaw amotteedda; shin hewenttokka aw immiyaawe beettibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Bare bayizzuwaa ero wode, ‘Qumay xooniide sa7aan attiyaa ta aabboo oothiyaawanttu aappunee; shin taani hawaan koshaan hayqqana mataytaa? ");
INSERT INTO dwrNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Denddaade ta aabbukko baanne’ hawaadan yaagana; ‘Ta aabboo, Xoossaakka neenakka naaqqaaddi; ");
INSERT INTO dwrNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Hannippe guyye ne na7aa yaagettaade xeesettanaw bessikke; new kiitettiyaawanttuppe ittuwaadan taana wothaarikkii gaana’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","He man77iyankka denddiide bare aabbukko yeedda. “I biro haakuwan de7ishshin, aawuu be7iide, aw qaretteedda; aakko woxxi biide, A idimmi yereedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Na7aykka, ‘Ta aabboo, taani Xoossaakka neenakka naaqqaaddi; hannippe guyye ne na7aa geetettaade xeesettanaw bessikke’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Shin aawuu bare oosanchatuwaa, ‘Elleelli biide, ubbaappe dooretteedda lo77o mayuwaa ahiide, A mayizzite; A biradhdhiyan migiduwaa, A gediyankka caammaa wothite. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Modhdheedda korumaa ahiide shukkite; moytte, nashettoytte. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ayaw gooppe, hawe ta na7ay hayqqeedda; shin ha77i paxeedda; bayeedda; shin ha77i beetteedda’ yaagina, nashechchaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“He wodiyaan, bayra na7ay gaden de7iyaawe yiide gollekko matiyaa wode, yethaanne duruwaa kooshunchchaa siseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ikka yewuu ayentto eranaw koyyiide, qoomatuwaappe ittuwaa xeesiide, ‘Hawe ayee?’ giide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Qoomatuukka, ‘Ne ishay saro yeedda diraw, ne aabbu modhdho korumaa aw shukkeedda’ yaagi odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Bayra na7ay hanqqettiide golle gelikke yaagi ixxina, aawuu karew keesiide, gelanaada woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Shin I zaariide bare aabba, ‘Hekko hawaa keena wodiyaa qoomaadan new kiitettaaddi; ne azazowaappe ittuwanneekka pacissa beykke; ta laggethatuwanna ittippe nashettana mala haray atto itti deeshshaa bul77uwanne taw imma beykka; ");
INSERT INTO dwrNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","shin hawe ne na7ay ne miishshaa caaratuwaanna ittippe diifissiide yiina, dhiiko booraa shukkaadda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aawuukka A, ‘Ta na7aw, neeni ubba gallassa taananna ittippe de7aa; taassa gideeddabay ubbaykka newaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Shin hawe ne ishay, hayqqeeddawe paxo dirawunne bayeeddawe beetto diraw, nuuni miiddinne ushiidde nashettanaw bessee’ yaageedda” giide odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuusi barena kaalliyaawanttoo odiidde, “Itti dure bitani, bare golliyaa ubbaa bolla suntheedda itti bitani de7ee; shin ha bitani A miishshaa bayizzee yaagiyaa zigirssay A gakkeedda; ");
INSERT INTO dwrNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","hewaa diraw bare suntheedda bitaniyaa xeesiide, ‘Hawe taani sisiyaa yewuu ayee? Hannippe guyye neeni ta Golliyaaninne ta miishshaa bolla taappe garssanna sunthettaade kiitettanaw danddayabeenna diraw, hachche gakkanaw kiitetteeddawaa heettaade sheedhdha’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Sunthetteeddawe bare wozanaan, ‘Ta goday taana sunthatethaappe kolana hanee; shin ta waanooshsha? Goshanaw wolqqay taw baawa; woossanaw qassi taw pokkee. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ta oothanabaa ta eray; I taana sunthatethaappe kessooppe, barenttu golle biina, taana mokkiyaa laggethatuwaa taani demmana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Bare godaappe shaluwaa tal77eedda asatuwaa huuphiyan huuphiyan xeesiide, koyro bitaniyaa, ‘Neeni ta godaappe woysa keena shaluwaa tal77aaddii?’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ikka, ‘Taani xeetu baareetaa kumeedda zaytiyaa tal77aaddi’ yaageedda. “Sunthetteedda bitaniikka, Neeni paramana waraqataa hey; uttaade ellekka ‘Ishatama’ gaade xaafa yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Hewaappe hara bitaniyaa, ‘Neeni aappunuwa tal77aaddii?’ yaageedda. “ ‘Xeetu qun77aa zarggaa’ yaageedda. “Sunthaykka, ‘Waraqataa hey; hosppun tamma gaade xaafa’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“He sunthay cinccatethaan ootheedda diraw, A goday A galateedda; ayaw gooppe, ha alamiyaa asay barenttuwoo poo7uwaa asaappe aadhdheedda cinccatuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Taani hinttenttoo yaagay, ‘Ha alamiyaa shaluu wuriyaa wode, medhinaw wurenna golliyan hinttentta mokkana mala, ha miishshaan hinttenttoo laggiyaa demmite. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Laafa yewuwaan ammanetteeddawe, woggabaanikka ammanettee. Shin laafa yewuwaan ammanettibeennawe, woggabaanikka ammanettenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Simmi hinttenttu ha alamiyaa shaluwaan ammanettennawaa gidooppe, tumatethaa shaluwaa hinttenttoo oone hadara giide immanawe? ");
INSERT INTO dwrNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hinttenttu hara asaa shaluwaan ammanettennawaa gidooppe, hinttenttu miishshaa oone hinttenttoo immanawe?’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Itti kaalla laa77u godatoo qoomatanaw danddayiyaawe ay qoomaykka baawa; ayaw gooppe, ittuwaa ixxiide, haraa dosee; woy ittuwaa bonchchiide, haraa kadhee; Xoossawunne shaloo modettanaw danddaykkita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Shaluwaa dosiyaa Parisaawatuu hawaa ubbaa sisiide, Yesuusa bolla qilliicceeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Shin Yesuusi unttuntta, “Hinttenttu asaa sinthan hinttentta xillo asa oothiyaawantta; shin Xoossay hinttenttu wozanaa eree; ayaw gooppe, asaa sinthan bonchchetteeddawe Xoossaa sinthan tuna gidee. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Muse higgiyaanne nabatuu xaafeedda maxaafaa Yohaannisa wodiyaa gakkanaw asay azazettiidde de7eeddino; hewaappe kaalla qay Xoossaa kawutethay odetteedda; asay ubbay yaa gelanaw keesettee. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Shin higgiyaappe ittibay attiyaawaappe saluunne sa7ay aadhdhiyaawe matattee. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Bare machchatto billiide hararo akkiyawe ubbay woshummee; qassi asinaappe biletteedda maccawunno akkiyawe ooninneekka woshummee. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Gatii loythiide al77o gideedda mayuwaa mayyiiddinne gallassaan gallassaan otoruwan nashettiidde de7iyaa itti dure bitani de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Qassikka kumentha asatethan maythay de7iyaa itti Ali7aazara geetettiyaa hiyyeesay, ha dure bitaniyaa kariyan giseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ha dure bitaniyaa samppaappe laaletteedda suuppaa maanaw amottee; haray atto kanatuukka yiide A maythaa laacciino. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ha hiyyeesaa bitani hayqqina, kiitanchchatuu A Abraahaamo bagga bonchchosaa afeeddino; dure bitaniikka qassi hayqqiide moogetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Si7ooliyan daro seelettiidde de7ishshin, dhoqqu giide haakuwan Ali7aazara, Abraahaamo baggan de7iyaawaa be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Ikka bare kooshshaa dhoqqu udiide, ‘Abraahaamo, ta aabboo, taw qaretta. Ha tamaa seelaan metoota de7iyaa diraw, Ali7aazar bare biradhdhiyaa xeeraa haathaan bochchiide, ta inxxarssaa irxxissanaadan hayyanaa taakko kiittaarikkii’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Abraahaamo qassi, ‘Ta na7aw, neeni paxa de7aadde, lo77o de7uwaa de7ina, Ali7aazar lo77enna meto de7uwaa de7eeddawaa qoppa. Ha77i qay I hawaani nashettiyaa wode, neeni metuwaa bolla de7aa. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“ ‘Hawaappe haray qay, hawaappe yaa hinttenttukko aadhdhanaw koyyiyaawanttu aadhdhennaadan, yaani de7iyaawanttukka qassi haa nuukko pinnennaadan, nu giddoninne hinttenttu giddon wogga aafuu medhetteedda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Dure bitaniikka, ‘Abraahaamo, simmi hewaa gidooppe, neeni Ali7aazara ta aabbu golle yeddana mala, neena woossay. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ayaw gooppe, taw ichcheshu ishatuu de7iyaa diraw, unttunttu qay ha metuwasaa yeenna mala, unttunttoo Ali7aazar biide markkatto’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraahaamo qassi, ‘Musenne nabatuu xaafeedda maxaafay unttunttoo de7ee; he maxaafay giyaawaa unttunttu sisiino’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Dure bitani, ‘Hi77ii; Abraahaamo, ta aabboo, hewaa gidenna; shin itti bitani hayquwaappe denddiide, unttunttukko bintto, unttunttu barenttu nagaraa paaxiide, simmanawantta’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abraahaamokka, ‘Unttunttu Musenne nabatuu xaafeedda maxaafaa sisennawaa gidooppe, haray atto itti uray hayquwaappe denddi yinttokka ammanikkino’ geedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuusi barena kaalliyaawantta, “Asaa balethiyaawe yeennaan attenna; shin balethiyaawaa ahiyaa uraw aw aayyee; ");
INSERT INTO dwrNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","He bitani ha guuthatuwappe ittuwaa balethiyaawaappe, gaacciyaa woxaa bare qoodhiyaan qashettiide abbaan mitettiyaawe aw lo77a. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hintte huuphew naagettite. “Ne ishay neena naaqqooppe, A zora. Qassi nagaraappe I simmooppe, aw atto yaaga. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Itti gallassi I neena laappu gede naaqqiide, laappu gedekka, ‘Neena ta naaqqaaddi, taana maara’ giidde neekko yooppe, aw atto ga” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kiitetteeddawanttukka Godaa, “Nuussi ammanuwaa gujja” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Godaykka, “Hinttew sannaaficiyaa ayfiyaa keena ammanuu de7intto, hinttenttu ha boo7iyaa, ‘Hawaappe shodettaade, abbaan tooketta’ gintto hinttew eeno gaana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Qassikka Yesuusi, “Hintteppe goshiyaawe woy miyaa heemmiyaa qoomay de7iyaa asay haqet de7ooppe, goshsha gadeppe woy miyaa gadeppe simmo wode ellekka, ‘Haaya shemppa akka, qumaa maanaw utta’ yaagiyaawe oonee? ");
INSERT INTO dwrNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yewuwaan qassi, ‘Ta maana kawuwaa giigissa; ta maananne ushana gakkanaw minnaade taana eqqaade miza. Hewaappe guyye new ma, usha’ yaagiyaawaa gidennee? ");
INSERT INTO dwrNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","He qoomay kiitetteeddabaa ootheedda diraw, he bitani galatanaw bessennee? ");
INSERT INTO dwrNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hewaadankka hintte qassi asay hinttena kiitto oosuwaa ootheedda wode, ‘Nuuni maaddenna qoomatuwaa; nu ooso xalalaa ootheeddo’ yaagite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuusi Yeerusalaame biidde, Galiilaappenne Sammaariyaa giyaa gadatuwaappe gidduwanna aadhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","I itti guutha katamatto geliyaa wodiyaan, haakuwan eqqeedda tammu oolluwan oyqetteeddawanttu A be7eeddino. Unttunttukka haakuwan eqqiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","barenttu kooshshaa dhoqqu udiide, “Yesuusa, Godaw, hayya godo nuuna pathaarikki!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesuusi unttuntta be7iide, “Biide, hinttenttu bollaa qeesatuwaa bessite” yaageedda. Unttunttukka qeesatuwaakko bide7iidde oolluwaappe paxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Unttunttuppe ittuu bare harggiyaappe paxeeddawaa be7iide, bare kooshshaa dhoqqu udiide, Xoossaa bonchchiidde simmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Galatiiddekka Yesuusa gediyaa matan gulbbateedda. He bitani Sammaariyaa asa. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesuusi zaariide, “Tammuu paxibeykkinoo? Yaatina udduppunatuu haqan de7iinoo? ");
INSERT INTO dwrNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ayihuda asa gidenna Sammariyaa bitaniyaappe attin, Xoossaa bonchchanaw simmeeddawanttu baawa guussee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesuusi A, “Dendda ba; ne ammanuu neena patheedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisaawatuu itti gallassi, “Xoossaa kawutethay awude yaanee?” giide oochchina Yesuusi, “Xoossaa kawutethay hinttenttu naagiyaa ogiyaan yeenna” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Qassikka, “Ooninne, ‘Xoossaa Kawutethay hawaan de7ee’, woy ‘Hewaan de7ee’ gaanaw danddayenna; Xoossaa Kawutethay hinttenttu wozanaa giddon de7ee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesuusi barena kaalliyawanttoo odiidde, “Asaa Na7ay qoncciyaa gallassatuwaappe ittuwaa be7anaw hinttenttu amottiyaa wodii yaana; shin be7ikkita. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Qassi unttunttu hinttena, ‘Haweku hawaana’ woy ‘Hewaana’ yaaganawantta. Shin unttuntta kaalliide, unttunttunna booppite. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Walqqanthay saluwan wolqqaamiyaa wode, ha gaxaappe hini gaxaa poo7uu po7iyaawaadan, asaa na7aa yuussaykka hewaadan hananawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Shin koyrottiide Asaa Na7ay daro metuwaa metootanawunne he wodiyan de7iyaa yeletaan ixettanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nohe wodiyaan hanowaadankka, Asaa Na7ay qoncciyaa gallassankka hewaadan hananawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nohe markkabiyaa gelo gallassay gakkanaw unttunttu, miiddinne ushiidde, akkiiddinne akettiidde de7ishshin, bashshaa haathay yiide ubba asaakka bayizzeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Hewaadankka, Looxe wodiyaan, asay miiddinne ushiidde, zali77iidde, tokkiiddinne golliyaa keexxiidde de7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Shin Looxe, Sodoomaappe keso gallassaan qassi saluwaappe tamaynne eexxiyaa bonqqo shuchchay bukkeedda; ubbabaakka miide wursseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Asaa na7ay qoncciyaa gallassaankka hawaadan hananawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","He gallassaan, golliyaa huuphiyaan de7iyaawe, golle garssan de7iyaa miishshaa akkanaw wodhdhoppo; hawaadankka goshsha gaden de7iyaawe, guyye simmoppo. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ane Looxe machchattibaa qoppite! ");
INSERT INTO dwrNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bare shemppuwaa ashshanaw koyyiyaa ubbay, bayizzee; bare shemppuwaa bayizziyaa ubbay, de7uwan naagee. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ta hinttew odiyaawe ayee gooppe, he qammaan laa77u asatuu itti gisuwan gisanawantta; unttunttuppe ittuu akettina laa7ethiyaawe attanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Laa77u macca asatuu itti woxaan gaaccanawantta; ittinna akettina, ittinna attanawunnu. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Laa77u asatuu goshsha garssan de7iino; ittuu akettanawaa, laa7ethiyaawe attanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","A kaalliyaawanttu Yesuusa, “Godaw, hewe haqan hananawee?” yaageeddino. Ikka zaariide, “Bakutay de7iyaasaa shorttii shiiqanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuusi barena kaalliyaawnttoo, salettennaan ubba gallassi woossanaadan leemisuwan odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ikka, “Itti katamaan Xoossaw yayyennawe, asaakka bonchchenna itti daannay de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","He katamaan am77e mishiratta de7aw. Izakka he daannaakko yaade, ‘Ta morkkewunne taw de7iyaa yewuwaa pirdda’ yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Daro wodiyaan iziw pirddennaan ixxeedda. Shin bare wozanaan qoppiide, ‘Taani, ubba Xoossaw yayyana dhayooppekka, asaakka qay bonchchana dhayooppe, ");
INSERT INTO dwrNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ha am77e mishiratta taana labbanthiyaa dirawunne ubba wode taakko yaade taana daaburssenna mala, taani iziw pirddana’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“He makkalanchcha daannay goowaa akeekite. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xoossay gallassinne qamma barentta maaddana mala, danddayaan aakko waassiyaa doorettawanttussi pirddenneyee? I unttunttoo ellekka zaarennee? ");
INSERT INTO dwrNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Taani hinttenttoo yaagay; unttunttoo elleelli pirddana; shin Asaa Na7ay yiyaa wode ha biittaan ammanuwaa demmaneeshsha?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Barentta geeshsha giide ammanettiyaawanttoonne haraa ubbaa darii kadhiyaawanttoo, Yesuusi ha leemisuwaa odeedda: ");
INSERT INTO dwrNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Laa77u asatuu woossanaw geeshsha golliyaa geleeddino. Hewanttuppe ittu Parisaawiyaa; ittu qay qaraxaa qanxxiyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisaawii denddi eqqiide bare wozanaan woossiidde, ‘Xoossaw, taani hara asaadan: bonqqiyaawanttudan, makkaliyaawanttudan, woshummiyaawanttudan, woy hawaadan qaraxaa shiishshenna diraw neena galatay. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Saaminttaan laa77u kaalla xoomay; taani demmiyaa ubbaappe tammu kushiyaappe ittuwaa immay’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Shin qaraxiyaa bitani haakuwan eqqiide, bare ayfiyan pude saluwaa dhoqqu giide xeellanawukka koyyibeenna. Shin bare tiraa baqqiidde, ‘Xoossaw, taani nagaranchchaa; taana maara’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Taani hinttenttoo odiyaawe ayee gooppe, kase bitaniyaappe aadhdhiide ha bitani xillo gidiide bare golle simmeedda; barena dhoqqu oothiyaa ubbay kawushana; barena qay kawushissiyaa uray dhoqqu gaana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesuusi bare kushiyaa wothiide anjjana mala asay guutha naanaa akkiide aakko yeeddino. A kaalliyaawanttukka be7iide, asaa ahenna mala geeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesuusi qassi guutha naanaa barekko xeesiide, “Guutha naanay taakko yaana mala aggite, diggoppite; Xoossaa kawutethay hawanttu malaassa. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Taani hinttenttoo tumuwaa oday; Xoossaa kawutethaa guutha na7aadan akkennawanttu ubbay he kawutethaa mulekka gelenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yihudaa biittaa Mooddiyaawanttuppe ittu, “Lo77o tamaarissiyaawoo, taani medhinaa de7uwaa laattanaw ayaa oothanaw bessii?” yaagiide Yesuusa oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesuusikka aw, “Ayaw taana lo77oo, yaagay? Itti Xoossaappe attin, lo77uu ooninne baawa; ");
INSERT INTO dwrNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xoossaa azazatuwaa, ‘Woshummoppa, wodhoppa, wuu77oppa, wordduwaa markkattoppa, ne aabbanne ne daayo bonchcha yaagiyaawaa eraa’ ” yaagiide zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bitani zaariide, “Hawaa ubbaa, na7atethaappe doommaade naagaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesuusikka hawaa sisiide, “Ittibay neeni biroon oothennaani attowe de7ee; hewenneekka, new de7iyaawaa ubbaa zali77aade manqqatoo imma; hawaa oothooppe saluwankka neeni durettana; hewaappe guyye ta geeduwaa kaalla” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","He bitani qassi hewaa sisiide daro dure gido diraw daro kayyotteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuusikka ha bitani daro kayyottowaa be7iide, “Dure asay Xoossaa kawutethaa gelanaw wooti metanddeeshsha! ");
INSERT INTO dwrNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Dure asay Xoossaa kawutethaa gelanawaappe gaaluu marppiyaa xoo7iyaanna aadhdhanawe matattee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hewaa siseedda asay, “Simmi ooni attanaw danddayii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ikka qay zaariide, “Asaw danddayettennawe Xoossaw danddayettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Phexiroosi zaariide, “Simmi nuuni nuussi de7iyaa ubbaa aggiide neena kaalleeddo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ikka, “Tumuwaa gay, Xoossaa kawutethaa diraw bare golliyaa, woy barena yelawantta, woy bare machchiyaa, woy bare naanaa, woy ishatuwaa aggeeddawe, ");
INSERT INTO dwrNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hawodiyan daro dakkuwaa, sintha yiyaa kawutethaanikka medhinaa de7uwaa akkennawe ooninne baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuusikka tammanne laa77u barena kaalliyaawantta barekko xeesiide, “Simmi Yeerusalaame baana; Asaa Na7aabaykka nabatuu maxaafan xaafetteeddabay ubbay yaani polettana. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ayihude gidennawanttoo A aathi immana, qilliiccana, daro metothana, A bollan cuchchana; ");
INSERT INTO dwrNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","shocowaappe guyyiyan wodhana, heezzenthiyaa gallassi I denddana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Unttunttukka ha yewuwaappe ayaanne akeekibeykkino; hayiquukka unttunttoo akeekettibeenna diraw I haasayobaakka eribeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuusi Iyarkkokko mateedda wodiyaan, itti qooqa bitani woossiidde ogiyaa gaxaan utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cora asay aadhdhiyaawaa sisiide, “Hawe ayeeshsha?” yaagi oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Asaykka aw, “Naazireetiyaa Yesuusi hawaanna aadhdhiidde de7ee” yaagi zaareeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ikka, “Daawite na7aa Yesuusaa, taana maaraarikki” giide waasseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aappe sinthanna biidde de7iyaawanttukka, co77u gaanaadan hanqqetteeddino. I qay, “Daawite na7aw, taana maaraarikki” giide darii waasseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesuusikka eqqiide, barekko ahanaadan asaw odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Yesuusakko I mato wodiyaan, Yesuusi, “Taani new ayaa oothanaadan koyyay?” yaagiide A oochcheedda. Ikka zaariide, “Godaw, xeellanaw koyyay” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesuusikka, “Xeella, ne ammanuu neena patheedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","He wodiyankka xeellii aggeedda; Xoossaakka bonchchiidde A geeduwaa kaalleedda. Asay ubbay bitaniyaa xeelliide, Xoossaa galateeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesuusi hini Iyyarkko katamaa geliide, hewaanna aadhdhi de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Sunthay Zakkiyoosa geetettiyaa itti dure bitani hewaan de7ee. Ikka qaraxiyaawanttussi kaappuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zakkiyoosi Yesuusa geetettiyaawe haqawentto be7anaw koyyishshin qantha gideeddawaa diraw, asaa coratethaappe denddowaan be7anaw danddayibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yesuusi he ogiyanna aadhdhiyaa diraw, sinthaw aadhdhiide itti boo7iyaa bolla keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesuusi he sa7aa gakkiide, dhoqqu gi pude xeelliide, “Zakkiyoosa, hachche ne gollen peeshanaw bessiyaa diraw elle wodhdha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ikka elleelli boo7iyaappe wodhdhiide, nashechchaan Yesuusa mokkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hewaan de7iyaa asaa ubbay hawaa be7iide, “Hawe nagaranchchaa gollen geliide imatha gidiide shoobettana hanee” giide ubbatuukka zuuzunthaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakkiyoosikka qassi eqqiide Godaa, “Godaw, simmi taw de7iyaawaa ubbaappe baggaa hiyyesatoo immana; ooppenneekka wordduwan akkeeddawaa gidooppe, ooyddu dakkuwaa udaade zaarana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesuusikka Zakkiyoosaw odiidde, “Neenikka Abraahaamo sheeshshaa gidiyaa diraw, hachche atotethay ha golle asaw yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ayaw gooppe, Asaa Na7ay bayeeddawaa koyyanawunne ashshanaw yeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Asay hawaa sisiidde de7ishshin Yesuusi, hini Yeerusalaame mato dirawunne unttunttoo Xoossaa kawutethay ha77ikka qoncciyaawaa malato diraw leemisuwaa odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hawaadan yaagi doommeedda; “Itti wolqqaama bitani barew kaawutethaa bonchchuwaa akkiide simmanaw, hini haako gadiyaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bare qoomatuwaa giddoppe tammuwaa xeesiide, unttunttoo tammu miinaa geetettiyaa miishshaa immowaashshin, ‘Taani simmaade yaana gakkanaw, hamiishshaan zali77ishshite’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Shin A gadiyaa asay A ixxo diraw, ‘Ha bitani nu bolla kawutanaadan nuuni koyyokko’ yaagiide, guyyenna I de7iyaasaa asaa kiitteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Gidoppe attin, ha bitani kaate gidiide hini bare gade simmeedda. He qoomatuu huuphiyan huuphiyan I immo miishshaan zali77iide ay keena wodhisseeddinontto eranaw xeesisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Koyro qoomay shiiqiide, ‘Godaw, neeni taw immeedda tammu miinaa wodhiyaa tammuwaa demmaaddi’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A Goday A, ‘Hayyanaashsho! Neeni lo77o qoomaa; neeni guutha yewuwaan ammanetteeddawaa gidaade beetto diraw, tammu katamatuwaa bollan maatay new imetteedda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Laa7ethiyaawekka shiiqiide, ‘Godaw, neeni taw immeedda ichcheshu miinaa geetettiyaa miishshay ichcheshuwaa wodhdheedda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A Godaykka A, ‘New ichcheshu katamatuwaa bollan maatay imetteedda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hara heezzenthiyaa qoomay shiiqiide, ‘Godaw, curqqaan xaaxa wotheedda ne miishshaa hawaa be7a. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ayaw gooppe, neeni wothabeennasaappe akkiyawaa; zerabeennawaa qoyciyaa meqethi baynna asa gidiyaa diraw, new yayyaaddi’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Godaykka, ‘Ha iita qoomay; neeni haasayo qaalaan ne bolla taani pirddana. Wothabeennawaa akkiyawaa, zerabeennawaa qoyciyaa meqethi baynna asa gidiyaawaa erooppe, ");
INSERT INTO dwrNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","taani yaade ta miishshaa wodhiyaanna akkana mala, ayissi wodhissiyaawanttoo immabeykkii?’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Godaykka, hewaan eqqowantta, ‘Ha miishshaa aappe wothi akkiide tammu miinay de7iyaawoo immite’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Unttunttukka, ‘Godaw, aw tammu miinay de7ee’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ikka, ‘Taani hinttenttoo odiyaawe, de7iyaawoo ubbaw gujettanawaa; baynnawaappe qassi he de7iyaawekka akettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yewuwaan qassi taani unttunttu bollan kawutennaadan koyyeedda ta morkkatuwaa taakko ahiide ta sinthaan shukkite’ geedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuusi hawaa goowaappe kaalla hini Yeerusalaame kesanaw barena kaalliyaawanttuppe sinthatiide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Debre Zayte geetettiyaa deriyaa matan de7iyaa hini Beetefaagen Biitaaniyaa geetettiyaa heeraa katamatuwaakko shiiqeedda wode barena kaalliyaawanttuppe laa77atuwaa, ");
INSERT INTO dwrNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Hinttenttuppe sinthan de7iyaa qeeri katamatuwaa biite; yaa hinttenttu geliyaa wode, ooninne biro uttibeenna hare maray qashetti utteeddawaa demmanita; A billiide haa akki yiite. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ooninne hinttentta, ‘Hawaa ayaw billiitee?’ giide oochchooppe, ‘I bare godaw koshshiyaa diraassa’ yaagite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kiitetteeddawanttukka biide, Yesuusi unttunttoo odowaadan hanina demmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Unttunttu hare maraa billiyaa wode be7iide hariyaa Goday, “Hare maraa ayaw billiitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Unttunttukka, “Godaw hawe koshshee” yaagiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","hare maraa Yesuusakko aheeddino; barenttu mayuwaa A bollan wothiide Yesuusa hariyaa togisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Asaykka Yesuusi biya ogiyaa bolla barenttu mayuwaa hiixxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","I Debre Zayte geetettiyaa deriyaa dugethaa afiyaa ogiyaa mateedda wode, daro cora gideedda A kaalliyaawanttu be7eedda Xoossay ootheedda malaataw ubbaw nashettiide, barenttu kooshshaa dhoqqu oothiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Godaa sunthaan yiyaa kaatii anjjetteeddawaa; saluwan sarotay gido. Qassi killi dhoqqa saluwan de7iyaa Xoossay bonchchetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Asaa garssan de7iyaa itti itti Parisaawatuu Yesuusa, “Tamarssiyaawoo, neena kaalliyaawantta co77u oothaarikki” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ikka zaariide, “Taani hinttenttoo oday, unttunttu co77u gooppe, shuchchaykka waassanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesuusi Yeerusalaame mateedda wode, katamatto be7iide, yeekkiidde, ");
INSERT INTO dwrNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Ne sarotaw gidiyaawaa neeni hachche eraaddintto lo77a; shin ha77i hewe ne ayfiyaappe geemmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ayaw gooppe, ne bolla yaana wodii de7ee; he wode neena ixxiyaawanttu ne yuushshuwaan dirssaa diriide, yaappenne haappenne dooddiide, neena un77ethiyaa wodii yaanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Neenanne ne dirssaa garssan de7iyaa ne asaa menthereethana. Xoossay neena be7anaw yeedda wodiyaa neeni erabeenna diraw, neena ixxiyaawanttu shuchchaa ubbaa ittuwaa ittuwaa bollappe denthiide laalanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hawaappe kaalla Yesuusi geeshsha golliyaa geliide, zali77iyaawantta hewaappe kesseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yesuusi zaariide, “ ‘Ta golli Xoossaa woossiyaa golliya gidanawaa’ geetettiide Xoossaa qaalaan xaafetteedda. Shin hinttenttu A paannuwaa gonggoluwaa ootheeddita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesuusi ubba wode geeshsha golliyan tamaarissi de7ishshin, qeesatuwaa kaappatuu, Muse higgiyaa tamaarissiyaawanttunne asaa ayissiyaawanttu A wodhanaw koyyiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Shin asay ubbay A haasayaappe ittuunne attennaan sisi utto diraw, A wodhiyaa ogiyaa unttunttu dhayeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Itti gallassi Yesuusi asaa geeshsha golliyan tamaarissiiddenne mishiraachchuwaa qaalaa odiidde de7iyaa wode, qeesatuwaa kaappatuunne Muse higgiyaa tamaarissiyaawanttu gadiyaa cimatuwanna ittippe Yesuusakko yeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Unttunttukka, “Ha yewuwaa neeni udiyaawe ay maataanentto oda; ha maataakka new immeeddawe I oonee?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ikka, “Ta hinttena itti ooshaa oochchiyawe de7iyaawaa ane zaarite. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohaannisa xinqqatay Xoossaappee woy asaappee?” yaagi oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Unttunttu bare giddon maqqettiidde, “Xoossaappe gooppe, hewaa gidooppe ‘Ayaw ammanibeykkitee’ nuuna yaaganawaa; ");
INSERT INTO dwrNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘Asaappe’ gooppe, asay ubbay Yohaannisi nabiyaa gidiyaawaa ammaniyaa diraw shuchchaan nuuna dechchanawantta” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hawaassi, “Haqappe yeeddentto erokko” giide aw zaareeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesuusikka, “Hawaa gidooppe taakka, taani O maataan ha yewuwaa oothaytantto hinttenttoo odikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hawaappe simmiide Yesuusi asaw ha leemisuwaa yaagi oduwaa doommeedda: “Itti bitani daro woyiniyaa turatuwaa tokkeedda. Goshshanchchatuwassi kothaw immiide, I hini hara gadiyaa biide cora wodiyaa gami77eedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Woyini ayfiyaa ayfo wode, woyiniyaa goshshaa Goday barena gakkiyawaa ahanaadan itti qoomaa kothaawatuwakko kiitteedda. Kiitetti beeddawaakka dhoobbiide, mela kushiyaa yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hewaappe hara qoomaa kiitteedda. Unttunttu hewaakka qassi dhoobbiide, toochchiide, mela kushiyaa yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ha77ikka haraa heezzenthiyaa qoomaa kiitteedda. Unttunttukka qassi A masunthiide, hini kare oleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“He woyiniyaa turaa Godaykka, ‘Simmi ayaa udoo? Ane ha77i ta dosiyaa na7aa kiittana; ooni eri A bonchchooppenne’ geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Goshshanchchatuu qassi na7aa be7eedda wode, ‘Hawe A laattiyaawaa gido diraw, hayite wodhoytte; hewaappe guyye, biittay nuussa gidanawaa’ giide zoretteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Woyiniyaa turaa sa7aappe, hini karew kessiide A wodheeddino. “Woyiniyaa turaa Godaykka unttuntta ayaa oothanddeeshsha? ");
INSERT INTO dwrNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yooppe he goshshanchchatuwaa, wodhanawaa; woyiniyaa turaa sa7aakka haranttoo immanawaa” yaageeddino. Asatuukka hawaa siso wode, “Hawaa malabaa ahoppo” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesuusikka hini unttunttukko xeelliide, “ ‘Simmi shuchchaa golliyaa keexxiyaawanttu kadheedda shuchchay, I waanna golliyaa minissiyaa huuphe shuchchaa gideedda’ geetettiide xaafetteeddawaa bilethay ayee? ");
INSERT INTO dwrNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ha shuchchaa bollan kunddiyaa ubbay me7erettee; shuchchaykka A bollan kunddiyaa ubbay bunchchettanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Muse higgiyaa xaafiyaawanttunne qeesatuwaa kaappatuu Yesuusi haasayeedda leemisuu, unttunttu bollan geetettowaa ero diraw, he saatiyankka A oyqqanaw koyyeeddino. Shin asaw yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yesuusa, he gadiyaa mooddiyawaassinne A maataassi aathiide immanaw A doonaappe kesiyaa qaalaan oyqqanaw injjetiyaa wodiyaa naagiino. Hewaa diraw geeshshaa malatiidde oythanaw wochchiyaawantta kiitteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","He kiitettowanttukka Yesuusa, “Tamaarissiyaawoo, neeni tuma yewuwaa haasayiyaawaanne tamaarissiyaawaa, hewaadankka qay Xoossaa ogiyaa tumatethaan tamaarissiyaawaanne oossinne dummayennawaa nuuni ereetto. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Qassikka unttunttu, Roomaa kaatiyaa Qeesaarew giiraa cigganaw koshshii woy koshshennee?” yaagi oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","I qassi unttunttu deshatethaa eriide, ");
INSERT INTO dwrNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ane taana itti diinaariyaa bessite; hewaa bollan de7iyaa misiliinnee xaafettowe oona bessii?” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Unttunttukka, “Qeesaarewaa” giide zaareeddino. Inneekka, “Hewaa gidooppe: Qeesaarewaa, Qeesaarew immite; Xoossaawaa, Xoossaw immite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Unttunttukka, I haasayeedda qaalaan asaa sinthan oyqqanaw danddayi beykkino. A zaaruwan maalalettiide co77u geeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduqaawanatuppe ittu ittuu Yesuusakko yiide, ooshaa aw shiishsheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Unttunttukka Yesuusa, “Tamaarissiyaawoo, itti bitani machchatto akkiide na7aa yelennaan hayyiyaawaa gidooppe, mishiratto hewaa ishay laataa akki na7aa yeliide bare ishaw zerethaa wothana mala Muse nuussi xaafeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Itti wodiyaan laappu ishatuu de7iyaawanttuppe, bayray machchatto akkiide yelennaan hayqqii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Laa7ethiyaawekka izo laatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Heezzenthiyaawekka qassi izo akkeedda; laappunatuukka izo akkiide na7aa yelennaan hayqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wursethaan mishirattakka hayqqaa aggaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Simmi laappunatuukka he mishiratto akkeedda diraw, hayquwaappe denddeedda wode, iza oossi machche gidanee?” yaagi oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesuusikka, “Ha alamiyaa naanay akkiinonne akettiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Shin hayquwaappe denddiide, sinthappe yiyaa wodiyaan de7anaw bessiyaawanttu akkikkinonne akettikkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Unttunttu Xoossaa kiitanchchaa malatiide de7iyaa diraw, hewaappe simmiide hayqqikkino. Hayquwaappe denddiyaawantta gidiyaa diraw unttunttu Xoossaa naanaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Muse, Xoossay aw qoncceedda woraabaa xaafeedda taarikiyaa garssan, Godaa Xoossaa, “Abraahaamo Xoossaa, Yisaaqa Xoossaa, Yayiqooba Xoossaa” yaagiide xeesussay, hayqqawanttu denddiyaawaa bessee. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ubbaykka aw hayqqi beennawantta gidiyaa diraw, I hayqqibeennawanttu Xoossaappe attin, hayqqowanttuwaa gidenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Itti itti Muse higgiyaa xaafeeddawanttukka, “Tamaarissiyaawoo, lo77uwaa haasayaadda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hawaappe simmiide, ittuukka A oochchanaw xalowe baawa. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hawaappe kaalla Yesuusi unttuntta, “Asay Kiristtoosa wooti ‘Daawite na7aa’ yaagiinoo? ");
INSERT INTO dwrNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Gasotethaynneekka, Daawite bare huuphew Mazimure Maxaafaa garssan, ‘Goday ta Godaa, “Taani ne morkketuwaa ne gediyaappe garssanna de7anaadan oothana gakkanaw, ta ushechchaan utta” geedda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Simmi Daawite Kiristtoosa, ‘Godaa’, giide xeesiyaawaa gidooppe, wooti aw na7aa gidana danddayii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Asay ubbay sisishshin barena kaalliyaawanttoo, ");
INSERT INTO dwrNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Muse higgiyaa tamaarissiyaawanttuppe naagettite; unttunttukka, adussa qamishiyaa mayyiide yuuyyanaw, geyay de7iyaasaan bonchcho sarotaa akkanaw, woossiyaa gollen bonchcho oydiyan uttanaw, shoobetteeddasan bonchchosaa koyyiyaawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hewanttukka am77atuwaa golliyaa kalloyiyaawantta; barentta bessanaw woosaa adussiyaawantta; unttuntta iita pirdday naage” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesuusi dhoqqu giide xeelliyaa wode, dure asay geeshsha golliyan imotaa shiishshiyaa miishshaa giddon barenttoo de7iyaawaappe unttunttu yeggiyaa wode be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Qassikka itti hiyyeesaa am77e mishiratta laa77u sembberiyaa hewaan yeggiyaa wode be7iide, ");
INSERT INTO dwrNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Ta hinttew tumuwaa gay, ha hiyyeesaa am77e mishiratta, ooppenne daruwaa immaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ha asay ubbay barenttoo palahowaappe immeeddino; shin iza bare hiyyeesatethaa wolqqaan barew de7iyaawaa ubbaa immaaddu” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A kaalliyaawanttuppe ittu ittuu, “Geeshsha golli lo77o shuchchaaninnee baalaa shiiquwaa imotaan lo77eeddawaa” yaagi haasayiyaa wode Yesuusi, ");
INSERT INTO dwrNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Hawe hinttenttu be7iyaawe ubbay kolettennaan, shuchchay shuchchaa bollan keelettiide attenna wodii yaanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Unttunttukka, “Tamaarissiyaawoo, simmi hawe hananawe awudee? Qassikka hawe hananaw mallay ayee?” yaagiidi oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ikka, “Ooninne balethennaadan naagettite; cora asay, ‘Taani Kiristtoosa’ yaagiidde qassikka, ‘Wodii mateedda’ yaagiidde ta sunthaan yaanawantta; hinttenttu qassi unttuntta kaalloppite. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Olaa yewuwaanne asaa makkalaabaa sisiyaa wode dagammoppite; hawe koyro hananaw bessiyaawaa gido diraappe attin wursethay bira” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Hewaappe kaalliide asaw, “Asay asaa bolla, kawutethaykka kawutethaa bolla, denddanawaa; ");
INSERT INTO dwrNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","wolqqaama biittaa qaathay hananawaa; koshaynne harggii, dumma dummasaan medhettanawaa; yashshiyaa yewuunne ubbaakka wolqqaama malaatay saluwaappe hananawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Hawe ubbay hananaappe kasiyan qassi asay hinttentta oyqqanawantta, metoothanawantta; hini Ayihudatuwaa woosa golle asaw aathi immanawantta; qasho gollekka gelissanawantta; kaatatuwaa sinthaninne mooddiyaawanttu sinthan shiishshanawantta; hawe ubbay ta sunthaa gaasuwan hinttentta gakkanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hawekka markkattanaw hinttew lo77o qaada gidanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hawaa gidiyaa diraw, ay zaaruwaa immanee giidde koyrottiide hinttenttu un77ettenna mala hawaa wozanaa aathite. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Eqettiyaawanttu ubbay, eqettanawunne lakanaw danddayenna qaalaanne aadho cinccatethaa taani hinttenttoo immana. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hinttentta yeleeddawanttunne hinttenttu ishatuu, hinttenttu dabbatuunne hinttenttu laggethatuukka attennaan hinttentta aathi immanawantta; hinttenttuppekka ittuwaa ittuwaa wodhanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ta sunthaa diraw asaa ubbaa matan ixetteeddawantta gidanita. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yewuwaan qassi hinttenttu huuphiyaa binnanaappekka ittinnanne bayukku. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Minni eqqiide hinttenttu shemppuwaa ashshiita. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Yeerusalaame olaa asaan doodetteedda wode, izi bayethay mateeddawaa erite. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","He wode Yihudaan de7iyaawanttu deriyaakko baqatino; katamaan de7iyaawanttu qay hewaappe kesino; baalaagariyan de7iyaawanttukka yaa katamaakko geloppino; ");
INSERT INTO dwrNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Xoossaa qaalaan xaafetteeddawe ubbay polettanaadan hawe haluwaa kesiyaa wodiyaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Biittaa bollan wolqqaama metuu hananawaa; ha77i de7iyaa asaa bollan hanqquu yaanawaa; hewaa diraw hewodiyan shahaarowanttoonne dhanthiyawanttoo aayyee! ");
INSERT INTO dwrNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Asay ubbay mashshaan hayqqanawantta; Xoossaa erenna gadiyaa ubbatuukka omodduwaan baanawantta; Yeerusalaamekka Ayihudaa gidennawanttu wodii polettana gakkanaw, unttunttun yedhetteeddawunno gidanawunnu. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Awaa, agenaaninne xoolinttiyaa bolla malaatay hananawaa; abbaappenne beetaa kooshshaappe denddo gaasuwan biittaa bollan de7iyaa asay ubbay un77ettanawantta; hirgganawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Saluwaa wolqqay ubbay qaaxxiyaa diraw asay yashshaaninne alamiyaa bolla ayee yaanaweeshsha yaagiidde naaguwaan daaburanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","He wode Asaa Na7ay wolqqaaninne wolqqaama bonchchuwan shaariyaan yiyaa wode be7anawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hinttenttukka, ha yewuu polettussaa doommiyaa wode, wozuu mato diraw sitti giide eqqite; pude dhoqqu giide xeellite” geedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kaalliiddekka, hawaa yaagi leemisuwaa odeedda, “Woddenthaappenne hara mithaa ubbaappe xeellite; ");
INSERT INTO dwrNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Haythay aacina be7iyaa wode, he wode bonii mateeddawaa hinttenttu eriita. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hewaadankka qassi yewatuu polettiyaawaa be7iyaa wode, Xoossaa Kawutethatta mateeddawunno erite. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Taani hinttew tumuwaa gay; hawe ubbay polettana gakkanaw ha yeletay aadhdhenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Saluunne sa7ay aadhdhana; shin ta qaalay aadhdhenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Simmi zaway baynna de7uwan, ushshaa daruwanne de7uwaaban un77ettishshin hinttenttu wozanay leppennaadaninne he gallassay phiriyaadan qoppennaan hinttena gakkennaadan naagettite; ");
INSERT INTO dwrNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hawe biittaa ubbaan de7iyaawanttu ubbatuwaa bollan gakkanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Simmi yiyaa iitabaa ubbaappe hinttenttu attanaadaaninne asaa na7aa sinthankka eqqanaw danddayana mala, ubba wode minni woossite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesuusi gallassi gallassi geeshsha golliyan tamaarissiide, qamma qamma Debre Zayte yaagettiyaa deriyaakko kesiide aqee. ");
INSERT INTO dwrNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Asay ubbay A sisanaw guuran yaa geeshsha golliyaa aakko yiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Paasigaa geetettiyaa magaage Ukithaa Miyaa Baalay mateedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Qeesatuwaa kaappatuunne Muse higgiyaa xaafiyaawanttu Yesuusa wooti wodhanentto, wodhiyaa ogiyaa geeman koyyiino; shin asaw yayyiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Xalahiikka tammanne laa77u kaalliyaawanttuppe ittuwaa gideedda Asqqorootu Yihudaan geleedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ikka biide, Yesuusa wooti aathi immanentto qeesatuwaa kaappatuwaannanne geeshsha golliyaa naagiyaawanttu kaappattuwaanna ittippe haasayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Unttunttukka nashettiide, miishshaakka Yihudaw immanaw wuletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ikka eeno geedda; asay baynna saan Yesuusa aathi immanaw injjetiyaa wodiyaa koyyee. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Magaage Ukithaa Miyaa Baalaa bonchchiya wodii gakkeedda; he wodiikka Paasigaw dorssaa shukkanaw bessiyaa wodiyaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesuusi Phexiroosanne Yohaannisa, “Paasigaa qumaa nuuni maanaadan biide giigissite” giide kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Unttunttukka zaariide, “Haqan giigissanaadan koyyay?” yaagi oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ikka, “Hinttenttu, katamaa geliyaa wode otuwaanna haathaa tookkeedda bitani hinttenttunna gakettanawaa; I geliyaa golliyaa A kaalliide gelite; ");
INSERT INTO dwrNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","He golliyaawaakka, ‘Tamaarissiyaawe neena, “Taani, taana kaalliyaawanttunna ittippe Paasigaa qumaa miyaa imathaa kifili haqa bagganna de7ii?” yaagee’ giite. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","He bitaniikka pooqiyaa bollan de7iyaa hiixetti utteedda aako kifiliyaa hinttentta bessanawaa; hewaanikka sa7aa giigissite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Unttunttu biide, Yesuusi goowaadankka bitaniyaa demmiide Paasigaa qumaa giigisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Paasigaa qumay meetettiyaa saati gakko wode, tammanne laa77u kiitettowanttunna ittippe qumaa maanaw utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ikka, “Taana metuu gakkanaappe kasiyan hinttenttunna ha Paasigaa qumaa maanaw daro amottaadde de7ay. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ayissi gooppe, ta hinttew odiyaawe, hawe Xoossaa kaawutethan polettana gakkanaw, taani laa7ethuwaa hawaappe miikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Xuu7aa akkiide, Xoossaa galatiide, “Hawaa heyte, hinttenttu gidduwan gishetti ushite. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ayissi gooppe, ta hinttenttoo yaagay, Xoossaa Kawutethay yaana gakkanaw, hachcheppe doommaade woyiniyaa eessaa ushikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Qassi magaage ukithaa akkiide, Xoossaa galateedda; he ukithaa menthi unttunttoo immiidde, “Hawe hinttenttoo imettiyawe ta ashuwaa; hawaan taana qoppana mala hawaa miite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kawuwaa moowaappe guyyiyan, kasewaadan xuu7aa denthi unttunttoo immiide, hawaadan yaageedda: “Ha xuu7ay, ta hinttenttu diraw gussiyaa ta suuthaa qopethiyaa ooratha caaquwaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Shin be7ite, taana aathi immanaw de7iyaa bitani gayitaan taananna ittippe mee. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ayaw gooppe, taani Asaa Na7ay Xoossay goowaadan bay; shin taana aathiide immiyaa uraw aw aayyee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Unttunttu giddoppe hewaa oothanaw de7iyaawe oona gidanentto, barenttu giddon ooshaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Qassi barenttu giddoppe ooni aadhentto yaagettiyaa palumay unttunttu giddon keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesuusi unttuntta yaageedda: “Ha alamiyaa mooddiyaawanttu barenttu asaa bolla godattiino; unttuntta mooddiyaawanttu keekatuwaa geetettiino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Shin hinttenttu hawaadan hanoppite; yewuwaan qassi hinttenttuppe dhoqqa gideeddawe hintte ubbaappe guxxiyawaa; hinttentta moddiyaawekka, hinttenttoo qoomaadan hano. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Qumaa maanaw utteeddawaappenne qumaa asaw aathiyaawaappenne ooni bonchchettii? Qumaa maanaw utteeddawaa gidennee? Taani qassi hinttenttu giddon qumaa aathiyaa qoomaa mala. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Qassi taani paacettiyaa wodiyaan hinttenttu taananna ittippe minni eqqeeddawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","A kawutethaa oydiyaan uttana mala Ta aabbu taana sunthowaadan, Taani qassi Ta kawutethaan ta gaytaappe maanaadaaninne ushanaadan, tammanne laa77u Israa7eeliyaa yaratuwaa bolla pirddiidde, kawutethaa oydiyaan uttana mala hinttentta sunthaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Goday, “Simoonaa, Simoonaa, taani odiyaawaa sisa; xalahii hinttentta asay zarggaa hal77iyaawaadan, hal77anaw Xoossaa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Shin taani ne ammanuu bayennaadan ne diraw gaannataaddi. Neeni taakko simmiyaa wode ne ishatuwaa minissa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simooni zaariide, “Godaw, taani neenanna qashettanawunne neenanna ittippe hayqqanaw giiga uttaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesuusi qassi, “Phexiroosa, taani new yaagay; hachche bilahiyan, kuttuu waassanaassi heezzu gede taana neeni, ‘A taani erikke’ gaade kaadanaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesuusi barena kaalliyaawanttoo, “Korojuu, qarcciitiinne caammay banttaan taani hinttentta kiitto wode, hinttenttoo ittibay paccowe de7ii?” yaageedda. Unttunttukka, “Itti baynne nuussi pacci beenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ikka zaariide, “Ha77i qassi korojuu de7iyaawe akki bo; qarcciiti de7iyaawekka hewaadan udo; baynnawe qay bare mayuwaa zali77iide mashshaa shammo. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ayaw gooppe ta hinttew yaagay, ‘Hawe makkalanchchatunna ittippe paydetteedda’ yaagetti Xoossaa Maxaafan xaafetteeddawe, taanan polettennaan attenna. E, taw geetetteeddawe ha77i polettanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A kaalliyaawanttu, “Godaw, hawaan laa77u mashshay de7ee” yaagina ikka, “Hewe gidanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesuusi katamaappe kesiide, hara gallassi biyaawaadankka Debre Zayte beedda. Qassi A kaalliyaawanttukka A geeduwaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","He sa7aa gakkiide, “Paaciyaan hinttenttu gelennaan attana mala, woossite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Shuchchaa olina gakkiyaasaa keena unttunttuppe haakki beedda. Gulbbatiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ta Aabboo, neeni koyyiyaawaa gidooppe, ha metuwaa xuu7aa taappe digga; shin ta shene gidoppo; ne shene gidoppe attin” yaagiide woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Saluwaappe yiide minissiyaa kiitanchchay aw beetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Bare wozanaa giddon seelettiidde, darii woosseedda. I cawottiyaa cawuukka sa7aa bollan xokiyaa suuthaa malateedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Woosaappe denddiide, barena kaalliyaawanttukko guyye biide, unttunttu daroppe qaretteedda diraw, daaburiide gemi77ishowantta xeelliide, ");
INSERT INTO dwrNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Ayaw gemi77ishiitee? Paaciyaan gelennaadan denddi woossite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesuusi hewaa haasay de7ishshin, cora asay yeeddino. Tammanne laa77u A kaalliyaawanttuppe ittuwaa gideedda Yihudaa geetettiyaawe he asaa kaalethiide yeranaw Yesuusakko shiiqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesuusi qay, “Yihudaw, neeni taana Asaa Na7aa yeraade aatha immay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","A yuushshuwaan de7iyaa A kaalliyaawanttu hanettiyaa yewuwaa be7o wode A, “Godaw, ha asaa nuuni mashshaan qanxxanee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Unttunttuppe ittu, Qeesatuwaa ubbatuwaa kaappuwaa qoomaa shociide, A ushechcha haythaa qanxxi oleedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesuusi qay zaariide, “Aggite, bashite” yaageedda. Bitaniyaa haythaakka bochchiide patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesuusikka barekko yeedda qeesatuwaa kaappatoo, geeshsha golliyaa naagiyaawanttoo, sunthatuwaassinne gadiyaa cimatoo, “Paanuwaa oyqqiyaawaadan mashshaanne xam77aa oyqqiide yiitee? ");
INSERT INTO dwrNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Geeshsha golliyan taani gallassaan, gallassaan hinttenttunna de7iyaa wode, taana oyqqibeykkita; shin ha77i hawe hinttenttu wodenne dhumaa wolqqaa wode” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yesuusa oyqqi qachchiide, Qeesatuwaa ubbaa kaappuwaa golle afiide gelisseeddino. Phexiroosikka unttunttuppe guyye haakuwan unttunttu geeduwaa kaallee. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dirssaa giddon tamaa eethiide, ittippe utti de7ishshin, Phexiroosi unttunttu giddon yiide utti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tamay poo7iyaa bagganna Phexiroosi uttiide de7ishshin, itti ashikkaratta loytha xeellaade, “Hawekka aananna ittippe de7ee” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Phexiroosi qay, “Hanne mishirattee, taani A erikke” yaagi kaddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Guutha wodiyaappe guyyiyan, hara bitani Phexiroosa be7iide, “Neeni unttunttunna gatho de7aa” yaagina; Phexiroosi qassi, “Hawo bitanew, taani aananna gatho de7ikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Itti saate gidiyaawaa gammi77iide hara bitani qonccissiide, “I Galiilaa gade asa gidiyaa diraw, ha bitani aananna ittippe de7iyaawe tuma” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Phexiroosi qassi, “Ha bitanew, neeni giyawe ayentto taani erikke” yaageedda. He wodiyan I birokka haasay de7ishshin, ellekka kuttuu waassi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Goday guyye simmiide, Phexiroosa xeelleedda. Phexiroosi Goday barena, “Hachche kuttuu waassana gakkanaw, heezzu gede taana kaddanaassa” geedda Godaa qaalay aw qofetti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Phexiroosi dirssaappe kare kesiide, seelettiide yeekkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesuusa oyqqeedda asay qilliicciinonne shociino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","A ayfiya goozzi baqqiide, “Neena baqqeeddawe oonee? Nabiyaa gidooppe neena dechchawaa ane oda” yaagiide A oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Qassi A hara cora boriya boreeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sa7ay wonttina gadiyaa cima asatuu, qeesatuwaa kaappatuunne Muse higgiyaa tamaarissiyaawanttu, Yesuusa barenttu shiiqeeddasaa afiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Kiristtoosi neenee? Ane nu oda” yaageeddino. Shin I, “Taani hinttenttoo odooppe taana ammanikkita; ");
INSERT INTO dwrNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Qassi hinttentta taani oochchooppe odikkita; woy qashuwaappe taana billikkita. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Shin ha saatiyaappe doommin taani Asaa Na7ay, ha77ippe doommaade, wolqqaama Xoossaa ushechcha bagganna uttana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Unttunttu ubbay Yesuusa, “Yaatina neeni Xoossaa Na7ee?” yaageeddino. Ikka zaariide, “Taani Xoossaa Na7aa gidowaa hinttenttu haasayeeddita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Unttunttukka, “Nuuni nu huuphew A doonaappe siseeddo; hawaappe sinthaw ay markkaa koshshii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hewaan shiiqeedda ubbatuukka ittippe denddiide, Yesuusa Philaaxoosakko afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Unttunttukka, “Habitani nu asaa balethiide, asay Roome biittaa kawuwaa Qeesaraw giiraa immenna mala diggiide, qassi, ‘Taani Kaatiyaa’ yaagishshin demmeeddo” yaagiide mootuwaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Philaaxoosikka Yesuusa, “Hawo, Ayihudatuwaa kaatii neenee?” yaagiide oochcheedda. Yesuusi zaariide A, “Neeni ga de7aasa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Philaaxoosi qeesatuwaa kaappatuwaassinne asaassi odiidde, “Taani ha bitaniyaa bollan aynne iita oosuwaa demma beykke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gidoppe attin unttunttu, “Ha bitani Galiilaappe doommiide, haray atto hawaa gakkanawukka, Yihudaa gadiyaa ubbaa bare timirttiyaan qaathiidde de7ee” yaagiide minissi odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Philaaxoosikka hawaa sisiide, “I Galiilaa asee?” yaagiide eranaw oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Philaaxoosi Heroodise mooddiyaa gadiyaappe Yesuusi yeeddawaa ereedda wode, Heroodisekka qay hewodiyan Yeerusalaamen de7iyaa diraw, aakko Yesuusa yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroodise daro wodiyaappe doommiide Yesuusa be7anaw amotti de7iyaa diraw, A be7eedda wode daroppe nashetteedda. Yesuusa waariyaa siseeddawaa diraw, I oorathabaa oothishshin be7anaw hidootaan gami77eedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Heroodise Yesuusa darobaa oochcheedda; shin Yesuusi aw ayaanne zaaribeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Qeesatuwaa kaappatuunne Muse higgiyaa tamaarissiyaawanttu hewaan eqqiide, Yesuusa loythi mootiidde de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroodisenne A wottaaddaratuu Yesuusa kadhiide, A bolla qilliicceeddino. Bonchchetteedda mayuwaa A mayizziide, Philaaxoosakko zaariide yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Heroodisenne Philaaxoosi hawaappe kasenna morkkiyan de7iino; shin he gallassi sigetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Philaaxoosi qeesatuwaa kaappatuwaa, ayissiyaawanttanne hara cora asaa ittippe xeesiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Hawaadan yaageedda, “ ‘Ha bitani asaa makkalatethaw denthethee’, yaagiide taakko aheeddita; taakka hinttenttu sinthaan bidda xeellaade, hinttenttu shiishsheedda mootuwan itti balaanne A bollan demma beykke. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Qassi Heroodisekka A bollan aynne demmibeenna diraw, haa nuukko zaari yeddeedda; hinttenttu be7iyaawaadankka, habitani A hayqoo gathiyaabaa aynne udibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hawaa diraw taani A muraade billana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Asay ubbay ittippe gidiide, “Ha bitaniyaa yaa digga! Barbbaana giya Yesuusa nuussi billa!” yaagiide cabbotteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barbbaan katamaan walassaa denthiide, asaa wodheedda diraw, qashetteeddawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Philaaxoosi Yesuusa billanaw koyyiide, asaw laa7ethuwaa gujjiide haasayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Shin unttunttu, “Masqqaliyaa bolla misimaariyan dhishaade kaqqa! Kaqqa!” yaagi waasseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Philaaxoosikka heezzenthuwaa unttuntta, “Ayaw? Habitani ootheedda iita oosuu ayee? Taani A hayqoo gathiyaa naaquwaa aynne aappe demmabeykke; hawaa diraw, A muraade billa yeddana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Shin unttunttu barenttu kooshshaa dhoqqu oothiide, kaqettanaadaan darii waasseeddino. Unttunttu waasuukka Philaaxoosa qofaa laammeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hawaa diraw, Philaaxoosikka unttunttu ooshay simmanaadan Yesuusa bollan pirddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Asaa makkalaw denthethiiddenne shemppuwaa wodhiide, qashetteedda bitaniyaa bilettanaadan unttunttu woosso diraw, he bitaniyaa billeedda. Shin Yesuusa barenttu sheniyaadan koyyowaa oothana mala, aathi immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesuusa oyqqi afiidde de7ishshin, Simoona geetettiyaa Qereena bitani heeraappe yiidde de7ishshin demmiide, masqqaliyaa toossiide Yesuusanna baana mala udeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Daro cora asaynne yeekkiyaa maccawanttu guyyenna kaalliino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesuusi guyye simmiide unttunttoo, “Hintteno, Yeerusalaame maccawanttoo, hinttenttu huuphewunne hinttenttu naanaw yeekkiteppe attin, taw yeekkoppite; ");
INSERT INTO dwrNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‘Mantha gideeddawanttunne yelibeenna uluu, dhanthibeenna dhanthay, anjjetteeddawantta’ geetettiyaa wodii yaanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","He wodiyan, ‘Zoozatoo, nu bolla woddite; zukkullatuwaakka, nuuna qosite’ yaaganita. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Simmi qayye mithaan hawaadan hanooppe, mela mithaan waanannawee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yesuusanna ittippe kaqettana mala, iita oosuwaa ootheedda hara laa77u asatuwaakka afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Qeeraanew geetettiyaasaa gakkeedda wodiyaan, Yesuusa kaqqeeddino. Iitaa oothowanttakka, ittuwaa ushechchanna, yokkuwaa haddirssanna kaqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesuusi, “Ta Aabboo, unttunttu barenttu oothiyaawaa erenna diraw, unttunttu nagaraa atto ga” yaageedda. Unttunttukka A mayuwaa saamaa yegettiide gishetti akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Asay eqqii xeellishshin, gadiyaa mooddiyaawanttu, “Harantta ashshee; Xoossaan dooretteedda Kiristtoosi A gidooppe, ane bare huuphiyaa ashshennee?” yaagiide qilliicceeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Qassi wottaaddaratuukka shiiqiide qilliicceeddino; cammeedda woyiniyaa eessaa aw ahi immiide, ");
INSERT INTO dwrNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Hawo, neeni Ayihudaa kaatiyaa gidooppe, ne huuphiyaa ashsha!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Huuphissannakka, “Hawe Ayihudaa kaatiyaa” yaagiyaa xaafuwaa xaafeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iitaa oothiide kaqetteeddawanttuppe ittuu, boriiddinne toochchiidde, “Hawo neeni Kiristtoosa gidikkii? Ane A gidooppe, ne huuphiyanne nuuna ashsha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yokkuu qay A, “Neeni hawaa malatiyaa pirddaa bolla de7aaddekka Xoossaw yayyikkii? ");
INSERT INTO dwrNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nuuni kiitetteedda balaan muraa akkiidde de7eetto; nuussi bessiyaa muraa bollan de7eetto; shin ha bitani itti iitabaanne oothibeenna” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","I Yesuusa, “Neeni ne kawutethaa wolqqaan yiyaa wode, taana qoppa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesuusikka, “Taani new tumuwaa oday, hachche taananna ittippe gannatiyaan de7anaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","He wode usuppun saate gidiyaa keena; hewaappe udduppu saatiyaa gakkanaw, biittaa ubbaa bollan dhuma gideedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Awaykka bare poo7uwaa diggeedda; geeshsha golliyaa gaariduukka peedhettiide laa77uwaa keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesuusikka daro dhoqqu geedda qaalaan waassiide, “Ta Aabboo, taani ta shemppuwaa ne kushiyaan aatha immay!” yaagi simmowaappe guyyiyan I hayqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Xeetuwaa kaappuu haneedda yewuwaa be7eedda wode, “Ha bitani tumakka xillo asa” yaagiide Xoossaa galateedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hawaa be7anaw ittisaa shiiqeedda asay ubbay haneedda yewuwaa be7iide, barenttu tiraa baqqiidde simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesuusa eriyaa asay ubbaynne Galiilaappe doommiide A kaalleedda maccawanttu hawaa xeelliide, haakuwan eqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ayihudaa shanggatuwaa gideeddawanttuppe ittuu, Yooseefa geetettiyaa lo77anne xillo bitani de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ha bitani shanggatuwaa maqquwaanne unttunttu oosuwan ittippetethaa oothibeenna. Xoossaa kawutethaa yuussaa hidootaan naagiidde de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yooseefokka Philaaxoosakko biide, Yesuusa anhaa akkanaw woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Akkanaadan geetettowaappe guyye, anhaa bollappe wothiide, lo77o mooguwaa mayuwaan xaaxiide, shuchchaappe woocettiide medhetteedda, ooninne kase moogetti beenna ollaa giddon wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Gallassaykka sambbataa mokkanaw giigiyaa gallassaa; sambbataykka gelana hanee. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galiilaappe doommiide Yesuusanna ittippe yeedda maccawanttu kaalliidde, duufuwan A anhaa wootiide wotheeddinontto be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Unttunttu hawaappe soy simmiide, shittuwanne okkiyaawaa anhaw giigisseeddino. Higgiyaa maaraadan sambbata gallassi shemppeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Saaminttaappe koyro gallassa, maccawanttu giigisseedda shittuwaa oyqqiide darii guuriide duufuwakko beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Shuchchaykka duufuwaa doonaappe gonddorettina be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Unttunttu duufuwaa garssa ollaa gelo wode, Godaa Yesuusa anhaa demmibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Maccawanttu sidhiidde de7ishshin, waciwaciyaa mayuwaa mayyeedda laa77u asatuu, qoppennaan unttunttu miyyiyaan eqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Maccawanttukka yashshaappe denddowaan sa7aa xeelliidde de7ishshin, laa77u asatuu, “De7uwan de7iyaawaa, A ayaw hayqqowanttu giddoppe koyyiitee? ");
INSERT INTO dwrNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","I denddeedda; hawaan baawa. Qaykka Galiilaan de7iyaa wodiyaan, ‘Asaa na7ay nagaranchchatuwaa kushiyan aadhdhi imettanawaa; masqqaliyaa bollan kaqettanawaa, heezzentho gallassi hayquwaappe denddanawaa’ yaagettowaa qoppite” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Maccawanttukka he wode qaalaa akeekeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Unttunttukka duufuwappe simmiide ha ubba yewuwaa tammanne itti kiitettowanttoonne unttuntta kaalliyaawanttoo ubbattoo odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hawaa Yesuusi kiittowanttoo odeeddawanttu: Magdalappe yeedda Mayraamo, Yohaanno, Yayiqooba daayo Mayraamonne unttunttunna ittippe de7iyaa hara Maccawantta. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Unttunttoo maccawanttu odiyaa qaalay qaajjiyaawaa malatina ammanibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Shin he wode Phexiroosi denddiide duufuwakko woxxeedda. Yaa gakkiide hokki xeelliyaa wode, garssan mooguwaa mayo xalalay de7iyaawaa be7eedda. Hano yewuwankka maalalettiide, golle simmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","He gallassi Yesuusa kaalliyaawanttuppe laa77u asatuu Yeerusalaameppe laa77u saatiyaa haakkiyaa Emaahuusa geetettiyaa heeraa biidde; ");
INSERT INTO dwrNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ittu ittuwanna haneedda yewuwaa ubbaa haasay de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Unttunttu haasayiiddinne zorettiidde de7ishshin, Yesuusi bare huuphew yiide unttunttu miyyiyaa shiiqiide unttunttunna biidde de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Shin unttunttu bare ayfiyan xeelliidde A gidiyaawaa shaakki eranaw danddaybeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesuusi, “Hinttenttu ogiyaa bollan ittu ittuwanna haasayiyaawe ayee?” yaagi oochcheedda. Unttunttukka dagaman lechchummiide eqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unttunttuppe ittuu Qeliyoophaa geetettiyaawe, “Ha gidduwan Yeerusalaamen hano yewuwaa erennawe ne xalalay hagadew imathee?” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesuusi, “I ayee?” yaagina, unttunttukka, “Xoossaa sinthaninne asaa ubbaa sinthan qaalaaninne kiitaan mino nabiyaa gideedda Naazireetiyaa Yesuusabaa haasayeetto. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aakka qeesatuwaa kaappatuunne nuuna mooddiyaawanttu hayquwaa pirddaw aathi immeeddino; masqqaliyaa bollan wodheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nuuni kasenna, ‘Israa7eeliyaa asaa wozanawaa’ yaagi hidootowe A; shin ha yewuu hanettiide aadhdhoodeppe heezzu qamma gideedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nu giddoppe itti itti maccawanttu nuuna maalalisseeddino. Unttunttu guuraan hini duufuwaa beeddino, ");
INSERT INTO dwrNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","shin Yesuusa anhaa unttunttu dhayo wode shiretti simmiide, “I denddeedda; yaagiyaawaa kiitanchchatuu odishshin be7eeddo” yaagi odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nu giddoppekka itti itti asay duufuwaa biide unttunttu goowaadan hanina be7eeddino; shin Yesuusa anhaa demmibeykkino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesuusi unttunttoo, “Hintteno, akeekenna asatoo, hinttenttu wozanaan nabatuu odowaa ubbaa elle ammanennawanttoo; ");
INSERT INTO dwrNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kiristtoosi ha metuwaa akkanawunne bare bonchchuwaakko gelanaw bessennee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hewaappe simmiide Yesuusi Muse maxaafatuwaappenne Nabatuu xaafeedda maxaafatuwaappe doommiide, Xoossaa Maxaafatuwaa ubbaan xaafetteedda barebaa unttunttoo billiide odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Unttunttu bide7iyaa heeraa mateedda wode, Yesuusi harasaa biyaawaa malateedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","He wode unttunttu A, “Gallassay qammiidde de7iyaa diraw, omarssay mateedda; nuunanna ittippe aqa!” yaagi minissi woosseeddino. Hawaa diraw, ikka unttunttunna ittippe aqanaw geleedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Unttunttu ittippe gayitaan utteedda wode, daabbuwaa denthiide anjjeedda; menthiide unttunttoo immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Unttunttu ayfiikka A akeekaanna mala dooyettina, Yesuusa gidiyaawaa ereeddino. Ikka unttunttu sinthaappe geemmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Unttunttukka ittu ittuwaa, “Qadhdhaan ittippe nu de7ishshin, nuuna I haasayissiyaa wodiyaaninne Xoossaa maxaafatuwakka nuussi qonccissiide I odiyaa wodiyaan, nu wozanaa giddon tamaadan seellee gidennee?” geetetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","He woddiyankka denddiide Yeerusalaame simmeeddino. Yesuusi kiitto tammanne ittatoonne unttunttunna ittippe de7iyaawanttoo, “Goday tumuwaakka denddeedda, Simoonawukka beetteedda” yaagiide hewaan ittippe shiiqi utteeddawantta demmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","He laa77atuu, qadhdhaan haneeddawaanne Yesuusi daabbuwaa menthiyaa wode wooti A ereeddinontto unttunttoo odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hawaa unttunttu haasay de7ishshin, Yesuusi unttunttu giddon eqqiide, “Sarotethay hinttew gido” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Unttunttoo moytilliyaa be7owaa malatina dagammiide, yashshaan kumeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ikka unttuntta, “Ayaw dagammiitee? Ayaa diraw hinttenttu wozanay sidhii? ");
INSERT INTO dwrNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Taani Yesuusa gidiyaawaa eranaw, ane ta kushiyaanne ta gediyaa be7ite; taanan hinttenttu be7iyaawaadan, moytillew ashuunne meqethay baawa. Ane taana hinttenttu kushiyaan oyqqi be7ite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hawaa yaagi simmiide, bare kushiyaanne bare gediyaa besseedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Unttunttukka nashechchaappe denddowaan, ammanennaan maalaletti de7ishshin I, “Hawaan meetettiyaawe hinttenttoo de7ii?” yaagi unttuntta oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Unttunttukka, xiixetteedda moliyaappe laafa puruwaa aw immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ikka akkiide unttunttu sinthaan meedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ikka, “Taani hinttenttunna ittippe de7aadde, ‘Muse maxaafaan, nabatuwaa maxaafaaninne qaalaan xaafetto mazimuratun ta diraw xaafetteedda ubbay polettanaw bessee’ yaagaade hinttenttoo odeedda yewuu hawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","He wodiyankka Xoossaa Maxaafatuwan geetettowaa akeekaanna mala, unttunttu wozanaa dooyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Unttunttoo, “ ‘Kiristtoosa metuu gakkanawaa; heezzenthiyaa gallassi hayquwaappe denddanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A asunthan nagaraa paaxethaynne maarotaa demussay Yeerusalaameppe doommiide asaw ubbaw odettanawaa’ yaagettiide xaafetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Hinttenttukka hawoo markkatuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ta hinttenttoo, Ta aabbu qaalaa geleedda hidootaa yeddana; hewe gakkanawunne hinttenttoo wolqqay saluwaappe imettana gakkanaw, Yeerusalaame katamaan naagishshite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hawaappe guyyiyan, Biitaaniyaa geetettiyaa katamaa gakkanaw, unttuntta afeedda; bare kushiyaa micciide unttuntta anjjeedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Unttunttuppe shaakettiide, saluwaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Unttunttu aw goyinniide, daro nashechchaan Yeerusalaame simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Qassi paccennaan Xoossaa galatiidde, Geeshsha Golliyan de7eeddino.");
INSERT INTO dwrNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Qaalay koyro de7ee; qaalaykka Xoossaanna ittippe de7ee; qaalaykka Xoossaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","I koyroppekka Xoossaanna de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ubbabay qaalaa bagganna medhetteedda. Medhetteeddabaani ubbabaani I baynnaan ittibaynne medhettibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aani de7uu de7ee; de7uu asaw poo7uwaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Poo7uu dhumaani poo7ee; dhumay poo7uwaa xoonibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Xoossaappe kiitetti yeedda A sunthay Yohaannisa geetettiyaa itti bitani de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Asay ubbay A bagganna ammanana mala, poo7uwaabaa markkattanaw yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Poo7uwaabaa markkattanaw yeeddappe attin, I bare huuphew poo7uwaa gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ikka tumu poo7uwaa gideeddawe asaw poo7issanaw ha sa7aa yiyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Qaalay alamiyaan de7ee; Xoossay Qaalaan alamiyaa medhdheedda; shin alami A eribeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I bare baggatuwakko yeedda; shin unttunttu A shiishshi akkibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gidoppe attin I barena shiishshi akkeedda ubbatoo, bare sunthaani ammaneeddawanttoo, Xoossaa naanaa gidana mala, maataa immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Unttunttu Xoossaappe yeletteeddinoppe attin, asay yeliyaa maaraani woy ashuwaa sheniyaan woy attuma asaa sheniyaa xalalaan yelettibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Qaalay asa gidiide, aadho keekatethaaninne tumatethaan kumiide nu gidduwan de7eedda. Nuuni, I bare aabboo itti Na7aa gidiide akkeedda aw de7iyaa bare Aawuwaa bonchchuwaa be7eeddo. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohaannisi aabaa bare kooshshaa dhoqqu oothiide, “Taani, ‘Taappe kaalla yiyaawe taappe bollaa; ayissi gooppe, ta yellettanaappe kasenna I de7iyaawaa’ gaade hinttenttoo odowe hawaa” yaagi markkatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nuuni ubbay A kumentha aadho keekatethaan palaheedda anjjuwaa akkeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Xoossay higgiyaa Muse bagganna immeedda; shin aadho keekatethaynne tumatethay Yesuusi Kiristtoosa bagganna yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xoossaa be7eedda asay ooninne baawa; bare Aawuwaa matan de7iyaa bare huuphew Xoossaa gideeddawe itti Na7aa xalalay aabaa markkatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yeerusalaamen de7iyaa Ayihudatuwaa ayissiyaawanttu qeesatuwaanne Leewatuwaa Yohaannisakko, “Neeni oonee?” giide A oochchana mala kiittina, Yohaannisi unttunttussi markkatteedda markkatethay hawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohaannisi, “Taani Kiristtoosa gidikke” yaagiide geeshshi markkatteeddawaappe attin, markkattussa ixxibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Unttunttu, “Yaatina, neeni oonee? Neeni Eelaasee?” yaagiide oochcheeddino. Yohaannisi, “A gidikke” yaageedda. Qassikka unttunttu, “Neeni nabee?” yaagiide oochcheeddino. Yohaannisi, “Gidikke” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Unttunttu, “Yaatina neeni oonee? Nuuni nuuna kiitteeddawanttoo odana mala, neeni neena oona gay?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohaannisi zaariide, “Nabiyaa Isayaase geeddawaadan, woraan bare qaalaa dhoqqu udiide, ‘Godaa ogiyaa sitti oothite!’ giyaa kooshshay tawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Qassi Parisaawatuu kiitteedda asatuu ");
INSERT INTO dwrNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yohaannisa, “Neeni Kiristtoosa woy, Eelaasa woy nabiyaa gidana dhayooppe, yaatina ayissi xammaqay?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohaannisi, “Taani haathaan xammaqay; shin hinttenttu erennawe ittu hawaani hinttenttu gidduwan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I taappe kaalla yee. Taani A caammaa qashuwaa billanawukka bessikke” yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hawe ubbay Yorddaanoosa Shaafaappe hefintha bagga Yohaannisi xammaqiyaasaa Biitaaniyaan haneedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yohaannisi wonttetha gallassi Yesuusi barekko yiyaawaa be7iide, “Xoossaa orgge dorssaa, Alamiyaa asaa nagaraa dhayissiyaawe, haweshi! ");
INSERT INTO dwrNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Taani, ‘Taappe kaalla ittu yaanawaa; I taappe bollaa; ayissi gooppe, ta yelettanaappe kasenna I de7iyaawaa’ gaade odeeddawe hawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","I oonentto taani erikke; shin Israa7eliyaa asaw A qonccissanaw haathaan xammaqaadde yaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohaannisi markkattiidde, “Geeshsha Ayyaanay saluwaappe haraphphiyaadan wodhdhishiinanne A bollan uttishshin, taani be7aaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Taani A erikke; shin haathaani xammaqana mala taana kiitteedda Xoossay, ‘Geeshsha Ayyaanay wodhiide, itti asaa bolla shemppishshin, neeni be7ana; ikka Geeshsha Ayyaanaan xammaqee’ yaagiide taw odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Taani hewaa be7aaddi; I Xoossaa Na7aa gidiyaawaakka markkattay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wonttetha gallassi Yohaannisi shirettiidekka barena kaalliyaawanttuppe laa77atuwanna ittippe eqqeedda; ");
INSERT INTO dwrNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","I Yesuusi aadhdhishshin be7iide, “Xoossaa dorssay haweshi!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yohaannisa kaalliyaa laa77atuu Yohaannisi giyaawaa sisiide, Yesuusa kaalleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesuusi barena kaalliyaawantta guyye simmi be7iide, “Ayaa koyyiitee?” yaagi oochcheedda. Unttunttu zaariide, “Rebii, neeni haqan de7ay?” yaageeddino. “Rebii” guussay “Tamaarissiyaawoo” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesuusi unttuntta, “Haa yiide be7ite” yaageedda. Unttunttu biide, I de7iyaasaa be7eeddino; he gallassi sa7ay tammu saate heera gidiyaa diraw, unttunttu aananna peesheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yohaannisi geeddawaa sisiide, Yesuusa kaalleedda laa77u asatuwaappe ittuu, Simoona Phexiroosa ishaa Inddiraasa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Inddiraase koyro bare ishaa Simoona demmiide, “Nuuni Xoossay kiitteeddawaanna gaketteeddo” yaageedda. Hewaa guussay “Kiristtoosa” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Inddiraase Simoona Yesuusakko aheedda. Yesuusi Simoona be7iide, “Neeni Yohaannisa na7aa Simoona; ne sunthay Keefaa geetettanawaa” yaageedda. “Keefaa” giyaawaa bilethay “Phexiroosa” woy “Zaallaa” giyawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wonttetha gallassi Yesuusi Galiilaa baanaw qofaa qachcheedda; I Piliphphoosanna gakettiide, “Taana kaalla!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piliphoosi, Inddiraasinne Phexiroose de7eedda Beetesayda geetettiyaa katamaappe yeedda asa. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Piliphoosi Naatinaa7eelanna gakettiide, “Muse maxaafatuwaaninne Nabatuwaa maxaafatuwaan aabay xafetteeddawaadan, Yooseefo na7aa Yesuusi Naazireete katamaan de7iyaawaanna nuuni gaketteeddo” yaagi odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naatinaa7eeli zaariide, “Naazireete katamaappe lo77obay kesanaw danddayii?” yaageedda. Piliphoosi, “Yaade be7a” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Naatinaa7eeli barekko yiyaawaa Yesuusi be7iide, “Makkalay baynna tumu Israa7eliyaa asay hawaa!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Naatinaa7eeli Yesuusa, “Neeni taana haqan eray?” yaagi oochcheedda. Yesuusi zaariide, “Piliphoosi neena xeesanaappe kase, neeni balasiyaa geetettiyaa mithaappe hirkkinna de7ishshin, taani neena be7aaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naatinaa7eeli zaariide, “Tamaarissiyaawoo, neeni Xoossaa Na7aa! Neeni Israa7eliyaa kaatiyaa!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesuusi, “Taani neena balasiyaa geetettiyaa mithaappe hirkkinna be7aaddi geedda diraw ammanay? Neeni hawaappe aadhdhiyaawaa be7ana!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Qassikka Yesuusi, “Taani hinttenttussi tumuwaa oday; saluu dooyettina, Xoossaa kiitanchchatuu ta bolla, Asa Na7aa bolla, pude kesishshiinanne duge wodhdhishshiina, hinttenttu be7ana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Heezzentho gallassi Galiilaa gadiyan Qaanaa geetettiyaa katamaan bullachchay bullachchetteedda; Yesuusa daaya he bullachchaan de7aw. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesuusikka barena kaalliyawanttunna ittippe he bullachchaa xeesetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Woyiniyaa ushshay wuridiggina, Yesuusa daaya A, “Unttunttussi woyiniyaa ushshay wuridiggeedda” yaaga oochchaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesuusi zaariide, “Ta daayee, hawe ta oosuwaa gidiyaa diraw, ne yayyana koshshenna. Ta wodii biro gakkibeenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesuusa daaya kiitettiyaawanttussi, “I hinttenttussi odiyaawaa ayaa giddoppennee oothite” yaaga odaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayihudatuu kase oothiyaa dooyaadan, meechchaa wogaw ittu ittuu xeetu xaarimusiyaa oyqqiyaa usuppun shuchchaa baathatuu hewan de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuusi kiitettiyaawantta, “Baathatuwani haathaa kunthite” yaageedda; geetettowaadankka unttunttu baathatuwani doonaa gakkanaw haathaa kuntheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesuusi unttuntta, “Ha77i duuqqiide, bullachchaa kaappoo immite” yaageedda; unttunttu aw afiide immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bullachchaa kaappuu woyiniyaa ushshaa gideedda haathaa ganxxi xeelliide, haqappe yeeddentto eribeenna; shin haathaa kuntheedda oosanchchatuu eriino. Bullachchaa kaappuu machchatto akkiyawaa xeesiide, ");
INSERT INTO dwrNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Ooninne ayife gideedda woyiniyaa ushshaa imatha asaa kasetiide ushshee; yaatiide asay darissi usheeddawaappe guyyiyaan, qiraariyaa ushshee. Shin neeni ayife gideedda woyiniyaa ushshaa hanno gakkanaw naagaadda!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuusi bare ootheedda wolqqaama malaatatuwaappe hawaa koyruwaa Galiilaa gadiyan Qaanaa geetettiyaa heeraan ootheedda; hewan bare bonchchuwaa I qonccissina, A kaalliyaawanttu aani ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hewaappe guyyiyan, Yesuusi bare daayinna, bare ishatuwaannanne barena kaalliyaawanttunna ittippe Qifirinaahooma geetettiyaa katamaa biide amareedda gallassaa takkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayihudatuu bonchchiya Paasigaa Baalaa gallassay matattina, Yesuusi Yeerusalaame beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Geeshsha Golliyaa gibbiyan mizzaa, dorssaanne dogommatuwaa zali77iyaa asaa demmeedda; qassi haratuu barenttu oydiyan uttiidde, miishshaa laammiyaawantta demmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","I golaa jiraafiyaa dooqqiide, asaa ubbaa dorssaannanne miyaanna Geeshsha Golliyaa gibbiyaappe karew kessiide yederisseedda. Miishshaa laammiyaawanttu oydiyaakka aathi yeggiide, unttunttu miishshaa laaleedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dogommuwaa zali77iyaawantta I, “Ha dogommatuwaa hawaappe kessite; Ta Aabbu golliyaa geyaa oothoppite!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesuusa kaalliyaawanttu Xoossaa maxaafan, “Taani ne gollew seelettiyaa seelay taana tamaadan guuddee” geetettiide xaafetteeddawaa hassayeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hewaappe guyye, Ayihude asaa ayissiyaawanttu zaariide, “New hawaa oothanaw danddayiyaa maatay de7iyaawaa nuuna ayaa malaataa bessanii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesuusi, “Ha Geeshsha Golliyaa kolite; taani heezzu gallassaani zaaraade keexxana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Qassikka Ayihude asaa ayissiyaawanttu, “Ha Geeshsha Golliyaa keexxanaw oytamanne usuppun laythaa akkeedda; shin neeni heezzu gallassaani keexxanii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Shin I haasayeedda Geeshsha Golli bare asatethaabaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hewaa diraw, Yesuusi hayquwappe denddeeddawaappe guyyiyan, Yesuusa kaalliyaawanttu I hewaa geeddawaa hassayeeddino. Qassi unttunttu Xoossaa Maxaafay geeddawaanne Yesuusi haasayeeddawaa ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Paasigaa baalaa bonchchiya wode, Yesuusi Yeerusalaamen de7ishshin, I ootheedda malaataa be7iide, cora asay A ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Shin Yesuusi asaa ubbaa eriya diraw, hewantta ammanibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Asaabaa ooninne aw markkattana mala koyyibeenna; ayissi gooppe, asaa wozanaani ayee de7intto, I bare huuphew eriyaa diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisaawatuwaappe gideedda kaappuwaa Niqoodimoosa geetettiyaa itti bitani de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Niqoodimoosi qamma Yesuusakko yiide, “Tamaarissiyaawoo, neeni nuuna tamaarissana mala Xoossay kiitteedda gidiyaawaa nuuni ereetto; ayissi gooppe, Xoossay aananna de7iyaa asaappe attin, ha neeni oothiyaa wolqqaama malaatatuwaa oothanaw danddayiyaa asay baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesuusi zaariide, “Taani new tumuwaa oday; asay laa7enthuwa yelettana dhayooppe, Xoossaa kawutethaa be7anaw danddayenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niqoodimoosi, “Cima asay waaniide laa7enthuwa yelettanaw danddayii? Bare daay uluwaa simmi geliide, laa7enthuwa yelettanaw asay danddayii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesuusi zaariide, “Taani new tumuwaa oday; asay haathaappenne Geeshsha Ayyaanaappe yelettana dhayooppe, Xoossaa kawutethaa gelanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Asay ashuwan asaappe yelettee; shin asay ayyaanaani Geeshsha Ayyaanaappe yelettee; ");
INSERT INTO dwrNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘Hinttenttu laa7enthuwa yelettanaw bessee’ gaade taani odeedda diraw, maalalettoppa. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Carkkuu bare koyyeeddasaa carkkee. Neeni A kooshunchchaa sisaasa; shin I haqappe yintto woy haqa bintto erakka. Geeshsha Ayyaanaappe yeletteedda ubbay hewaa mala” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Niqoodimoosi, “Hawe waaniide hananaw danddayii?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesuusi zaariide, “Neeni Israa7eelatuwaa tamaarissiyaawaa gidaadde hawaa erikkii? ");
INSERT INTO dwrNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Taani new tumuwaa oday; nuuni eriyaawaa haasayeettonne be7eeddawaa markkatteetto; shin nuuni markkattiyaawaa hinttenttu akkikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Taani hinttenttussi sa7aabaa odina, ammanennawantta gidooppe, saluwaabaa odina waani ammananitee? ");
INSERT INTO dwrNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Saluwaappe wodhdheedda taappe attin, saluwaa keseeddawe ooninne baawa; saluwan de7iya Asaa Na7ay taana. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","“Muse woraan xanqqimaaluwaa shooshshaa sulleeddawaadan, taana ammaneedda ubbay medhinaa de7uwa akkana mala, taani Asa Na7ay masqqaliyaa bolla pude denddana bessee. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Xoossaa Na7aa ammaniyaa ubbay medhinaa de7uwa akkanaappe attin, dhayenna mala, Xoossay ha alamiyaa asaa loythi siiqeedda diraw, bare mexxi itti Na7aa immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ayissi gooppe, Xoossay bare Na7aa ha alamiyaa asaa pirddanaw kiittibeenna; shin unttuntta A bagganna ashshanaw kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“A Na7aa ammaniyaa ooninne pirddettenna; shin Na7aan ammanenna ooninne, Xoossaa Na7aa ittuwa ammanibeenna diraw, ha77ikka pirddetti utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Asaa bolla yiyaa pirdday hawaa: Poo7uu ha alamiyaa yeedda; shin asaa kiitay iita gidiyaa diraw, poo7uwaappe aathiide, dhumaa siiqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iitabaa oothiyaa ooninne poo7uwaa ixxee; ayissi gooppe, bare kiitay qonccenna mala, poo7uwaakko shiiqenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Shin tumuwaa oothiyaa ooninne Xoossay azazeeddawaadan, I ootheeddawaa poo7uu qonccissana mala, poo7uwaakko shiiqee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hewaappe guyyiyan, Yesuusinne A kaalliyawanttu Yihudaa gadiyaa beeddino; Yesuusi he gadiyan unttunttunna amareedda wodiyaa uttiide, asaa xammaqiidde de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Qassi Yohaannisi Saaleeme mataan de7iyaa Henoona giyaa saan wogga haathay de7iyaa diraw, asay aakko yiina xammaqee. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Hewe haneeddawe Yohaannisi qashettanaappe kasenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hewaappe guyyiyan, Yohaannisa kaalliyaawanttunna amareedda Ayihudatuwaa meechchaa wogaabaa palumetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Unttunttu Yohaannisakko biide, “Tamaarissiyaawoo, Yorddaanoosa Shaafaappe hefinthan neenanna de7iyaawe, neeni aabaa markkattowe, be7a ha77i xammaqee; asay ubbaykka aakko bee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohaannisi zaariide, “Xoossay immana dhayooppe, asay aynne akkanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Taani Kiristtoosa gidikke; shin taani aappe sinthaw kiitettaaddi’ geeddawaassi hintte hinttenttu huuphew markka. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mishira maccawunna de7iya uray iikka mishiraa; he mishiraa miyaatay eqqiide, I giyaawaa sisiyaawe A haasayaan daro nashettee. Hewaa diraw, hawe ta nashechchay poletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","I darina ta guuxxana bessee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Bollappe yiyaawe ubbaappe bollaa. Sa7aappe beetteeddawe sa7aassa. Ikka sa7aabaa haasayee. Saluwaappe yiyaawe ubbaappe bollaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","I bare be7eeddabaanne siseeddabaa markkattee; shin A markkattethaa akkiyawe baawa. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","A markkattethaa akkiya ooninne Xoossay tumanchcha gidiyaawaa hewan markkattee. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Xoossay kiitteeddawe Xoossaa qaalaa odee; ayissi gooppe, Xoossay bare Geeshsha Ayyaanaa palahissiide immee. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Xoossay bare Na7aa siiqiide ubbabaa A kushiyan wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na7aa ammaniyaa uraw medhinaa de7uu de7ee; shin Na7aa ammanennaawaa bolla Xoossaa hanqquu de7anaawaappe attin, I de7uwaa be7enna. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Yesuusi Yohaannisawaappe dariyaa barena kaalliyaawantta barekko shiishsheennee xammaqee giyaawaa Parisaawatuu siseeddawaa Yesuusi ereedda wode, Yihudaa aggiide, Galiilaa beedda; gidooppenne, Yesuusa kaalliyaawanttu xammaqeeddawaappe attin, Yesuusi bare huuphew oonanne xammaqibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galiilaa biidde, Sammaariyaanna aadhdhanawe A ashshennabaa gideedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Hewaa diraw, Yayiqoobi bare na7aa Yooseefoo immeedda gadiyaa matan de7iya Sikaaro geetettiyaa Sammaariyaa katamaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","He sa7an Yayiqooba haathaa ollay de7ee; Yesuusi hametan daaburiide, he haathaa ollaa matan utteedda. He wode sa7ay usuppun saatiyaa heera. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sammaariyaa mishiratta haathaa duuqqanaw yeeddawunno Yesuusi, “Taana haathaa ushshaarikkii!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yesuusa kaalliyaawanttu qumaa shammanaw katamaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","He Mishiratta zaaraade A, “Neeni Ayihuda asaa gidaadde, Sammaariyaa macca asa gideedda taana, woota de7uwaa immiyaa haathaa ushsha gay?” yaagaaddu; ayissi gooppe, Ayihudatoonne Sammaariyaa asaw ittipetethay baynna diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesuusi zaariide izo, “Neeni Xoossaa imotaanne qassi neena ‘Taana haathaa ushsha’ giyaawe oonentto eriyaawaa gidintto, A woossanaassa; ikka new de7uwa immiyaa haathaa immana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mishiratta zaaraade, “Godaw, new duuqqiyaabay baawa; ollaykka ciimmuwaa. Yaatina, de7uwa immiyaa haathaa haqappe akkani? ");
INSERT INTO dwrNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nuussi ha haathaa ollaa immeedda nu aawuwaa Yayiqoobappe neeni daray? I, A naanaynne A mehii hawaappe usheeddino” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesuusi zaariide, “Ha haathaappe ushiyaa ooninne laa7enthuwaa saamettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Shin taani immiyaa haathaa ushiyaa ooninne laa7enthuwaa saamettenna. Taani immiyaa haathay he A giddon medhinaa de7uwaassi pulttiyaa pulttuwaa gidanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mishiratta, “Godaw, taani saamettenna malanne haathaa tikkanawukka haa yeenna mala, taw he haathaa imma!” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesuusi izo, “Baade ne asinaa xeesaade haa simma” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mishiratta zaaraade, “Taw asinay baawa” yaagaaddu. Yesuusi, “Taw asinay baawa giyaawaan tumuwaa gaadda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Neeni ichcheshu asinaa gelaadda; ha77i neenanna de7iyaa bitani ne asinaa gidenna. Neeni ha77i taw odeeddawe tuma” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mishiratta qay, “Godaw, neeni nabiyaa gidiyaawaa ta ha77i eraaddi; ");
INSERT INTO dwrNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","nu Sammaariyaa asaa aawatuu ha deriyaan goyinneeddino; shin Ayihudatuu hinttenttu asay Xoossaw goyinnanaw bessiyaa sa7ay Yeerusalaamena yaagiita” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesuusi, “Ha mishirattee, taana ammana; ha deriyaan woy Yeerusalaamen Aawuwaa Xoossaw hinttenttu goyinnenna wodii yaanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hinttenttu Sammaariyaa asay hintte erennabaw goyinniita; Xoossay nuuna Ayihudatuwaa go77ettiide atotethaa ahiyaa diraw, nuuni nu eriyaawoo goyinneetto. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Shin Aawuwaa Xoossaw tumuwaappe goyinniyaawanttu A, Geeshsha Ayyaanaa wolqqaaninne Xoossaa Xoossaatethaadan goyinniya wodii matatteedda; ubba ha77ikka gakkeedda. Ayissi gooppe, asaa barew goyinnana mala, Aawuu Xoossaykka ha ogiyaan goyinniyaawantta koyyee. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Xoossay Ayyaanaa; aw goyinniyaawanttukka Geeshsha Ayyaanaa wolqqaani Xoossaa Xoossatethaadan goyinnanaw bessee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mishiratta, “Masihiyaa geetettiyaa Okettowe yaanawaa taani eray. I yiyaa wode nuussi ubbabaa odanawaa” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesuusi, “Ha neenanna haasayiyaawe taani A” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hawaa unttunttu haasayishshin, Yesuusa kaalliyaawanttu beeddasaappe simmeeddino. Yesuusi mishirattinna haasayishshin unttunttu be7iide darissi maalaletteeddino; shin mishiratto, “Ayaa koyyay?” woy Yesuusa, “Iinanna ayissi haasayay?” giide oochchowe ooninne baawa. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hewaappe guyyiyan, Mishiratta bare haathaa otuwaa agga basha guyye katamaa baade asaw, ");
INSERT INTO dwrNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Taani ootheeddawaa ubbaa taw odeedda bitaniyaa be7anaw denddite; hewe Kiristtoosa gidaanddeeshsha?” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Asay katamaappe kesiide, Yesuusakko beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hewe hanishshin, A kaalliyaawanttu Yesuusa, “Guuthabaa maarikkii!” yaagiide woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Shin I, “Taw hinttenttu erenna qumay taani miiyaawe de7ee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hewaa diraw, A kaalliyaawanttu barenttu giddon, “Aw miyaabaa aheedda asay de7anddeeshsha?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesuusi unttunttussi, “Ta qumay taana kiitteeddawaa sheniyaa udussaanne A oosuwaa polussaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Hinttenttu, ‘Oyddu agenaappe guyyiyan, kathay cakettanawaa’ giikkiteeyee? Taani hinttenttussi oday; goshshaa loythi xeellite; kathay caka besseedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Zeriyaawenne cakkiyaawe ittippe nashettana mala, cakkiyaawe dirgguwaa akkeenne kathaa medhinaa de7oo shiishshee. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ha gaasuwaan, ‘Ittu zeree; qassi ittu cakkee’ giyaa haasayay tuma. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Hinttenttu daaburibeennawaa cakkana mala, taani hinttentta kiittaaddi; haratuu oothi daabureeddino; hinttenttu haratuwaa daaburan geleeddita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mishiratta, “I taani ootheedda ubbabaa odeedda” gaade markkatteedda diraw, he katamaan de7iyaa Sammaariyaa asaappe coray Yesuusa ammaneedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sammaariyaa asay Yesuusakko yeedda wode, barenttu mataan gami77ana mala, Yesuusa woossina I yaani laa77u gallassaa utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","I odiyaa qaalaa diraw, kasewaappe cora asay ammaneedda; ");
INSERT INTO dwrNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","qassi unttunttu mishiratto, “Nuuni nu huuphew I giyaawaa sisiide ammaneeddawaappe attin, neeni markkatteedda diraassa gidenna; I tumu alamiyaa asaa ashshiyaawaa gidiyaawaakka nuuni ereeddo” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Laa77u gallassaappe guyyiyan, Yesuusi Sammaariyaappe kesiide, Galiilaa gadiya beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ayissi gooppe, I bare huuphew, “Nabii bare gadiyan bonchchettenna” yaagi odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesuusi Galiilaa gakkeedda wode, Galiilaa asay A mokkeedda; Paasigaa bonchchiya gallassi unttunttu Yeerusalaamen de7iya diraw, I ootheedda ubbabaa be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesuusi haathaa woyiniyaa ushshaa kesseedda, Galiilaan de7iya Qaanaa katamaa beedda. Qifirinaahooman A na7ay sakettiyaa, kaatiyaa gollen oothiyaa itti kaappuu de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yesuusi Yihudaappe Galiilaa yeeddawaa he kaappuu sisiide, aakko yiide hayqqanaw mateedda bare na7aa biide pathana mala, Yesuusa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesuusi he kaappuwaa, “Xoossay oothiyaa malaataanne hechcho giissiyaabaa be7ennaani de7iidde, hinttenttu ayinne ammanikkita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","He kaappuu zaariide, “Godaw, ta na7ay hayqqennan de7ishshin, taananna baarikkii” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesuusi, “Ba; ne na7ay paxa de7anawaa!” yaageedda. He kaappuu Yesuusi geeddawaa ammaniide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","I bare golle biishshin, A qoomatuu aananna ogiyaan gakettiide A, “Ne na7ay paxa de7ee” geeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I bare qoomatuwaa bare na7aw ay saatiyaan keekeeddentto oochchina unttunttu, “Zino laappu saatiyaan qooxuu A aggeedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na7aa aawuu Yesuusi barew, “Ne na7ay paxa de7anawaa” geeddawe he saatiyaana gideeddawaa hassayeedda. Hewaa diraw, inne A soy asay ubbay ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hawe Yesuusi Yihudaappe Galiilaa yiide ootheedda laa7entho malaataa. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hewaappe guyyiyan, Yesuusi Ayihudatuu bonchchiya baalaw Yeerusalaame beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yeerusalaamen dorssaa penggiyaa matan Ibraayisxxe qaalaan Beetesayda geetettiyaa dagatti utteedda haathay de7ee; he dagatti utteedda haathaa yuuyyi aadhdheedda ichcheshu kashay de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Hewaan cora hargganchchatuu, qooqatuu, wobbatuunne sileeddawanttu giseeddino. Haathay qaaxxiyaawaa naagiino. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ayissi gooppe, itti itti gede Godaa kiitanchchay he dagatteedda haathaakko geliide, haathaa qaathee; haathay qaaxxeeddawaappe guyyiyan, koyro geleedda uray barena oyqqeedda ay harggiyaappekka paxee. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hewaan hattamanne hosppun laythaa saketteedda itti bitani de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","He bitani hewan giseeddawaa Yesuusi be7iide, daro wodiyaa saketteeddawaakka eriide bitaniyaa, “Paxanaw koyyay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sakettiyaa bitani zaariide, “Godaw, haathay qaaxxiyaa wode, taana haathaan yeggiyaa asay dhayeedda; taani gelana haniyaa wode, hara uray taappe kasetiide geli aggee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesuusi A, “Dendda eqqa; neeni gisowaa tookkaade ba” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Bitani elekka paxi aggeedda; bare gisuwaa tookkiide beedda. Hewe haneeddawe Sambbata gallassaana. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hewaa diraw, Ayihudatuu paxeedda bitaniyaa, “Hachche sa7ay Sambbataa; neeni ne gisuwaa tookka biyaawe woga gidenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Shin bitani, “Taana patheeddawe, ‘Ne gisuwaa tookkaade ba’ yaageedda” giide unttunttussi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Unttunttu A, “Neena, ‘Ne gisuwaa tookkaade ba’ geeddawe I oonee?” giide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Shin hewaan cora asay de7iyaa dirawunne, Yesuusikka geemetteedda diraw, bitani barena patheeddawe oonentto erenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yesuusi guyyeppe he bitaniyaa Geeshsha Golliyan demmiide, “Be7a, neeni ha77i paxaadda; hawaappekka iitabay neena gakkenna mala, laa7entho nagaraa oothoppa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hewaappe guyyiyan, bitani biide, barena patheeddawe Yesuusa gidiyaawaa Ayihuda asaa kaappatoo odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesuusi hawaa Sambbataan ootheedda diraw, unttunttu Yesuusa yedesaan waayissuwaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesuusi zaariide unttunttussi, “Ta Aabbu ubba wode oothee; taanikka oothanaw bessee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hewaa diraw, Yesuusi Sambbata gallassaa bonchchenna diraa xalalaassa gidennaan, barena Xoossaanna qarayiide, “Xoossay ta Aabba” geedda diraw, Ayihuda asaa kaappatuu A wodhanaw kasewaappe minissiide koyyiino. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesuusi zaariide unttunttussi, “Taani hinttenttussi tumuwaa oday; Na7ay barekka aynne oothenna. I bare Aabbu oothishshin be7iyaawaa xalalaa oothee; Aawuu oothiyaawaa Na7aykka oothee. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ayissi gooppe, Aawuu bare Na7aa siiqee; qassi I oothiyaa oosuwaa ubbabaa bare Na7aa bessee. Ubba hinttenttu maalalettana gakkanaw, I hawaappe aadhdhiya oosuwaakka bare Na7aa bessanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gaasuunnee, Aawuu hayqqeeddawantta hayquwaappe denthiide shemppuwaanna wothiyawaadan, Na7aykka qassi bare koyyowantta shemppuwaanna wothee. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Asay ubbay Aawuwaa bonchchiyawaadan, Na7aakka bonchchana mala, Aawuu pirddaa ubbaa Na7aw immeeddawaappe attin, I oonanne pirddenna; Na7aa bonchchenna uray, A kiitteedda Aawuwaakka bonchchenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Taani hinttenttussi tumuwaa oday; ta qaalaa sisiyaawoonne taana kiitteeddawaan ammaniyaawoo medhinaa de7uu de7ee. Hayquwaappe de7oo I pinneeddawaappe attin, pirddettenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Taani hinttenttussi tumuwaa oday; hayqqeedda asay Xoossaa Na7aa kooshshaa sisiyaa wodii yaanawaa; hewenneekka ha77a. He kooshshaa sisiyawanttu shemppuwaanna de7ana. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ayissi gooppe, Aawoo de7uwaa immiyaa wolqqay de7iyaawaadan, de7uwaa immiyaa he wolqqaa bare Na7awukka immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Xoossaa Aawuu bare Na7aw pirddiyaa maataa immeedda; ayissi gooppe, Na7ay Asaa Na7aa. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Hawaan malalettoppite; ayissi gooppe, duufuwan de7iyaawanttu A kooshshaa sisiyaa wodii yee. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Sisiide unttunttu duufuwaappe gaxaa kesana; lo77obaa ootheeddawanttu de7uwaan de7anaw denddana; qassi iitabaa ootheeddaawanttu pirddettanaw denddanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Taani taappe aynne oothanaw danddayikke; Xoossay taw odeeddawaadan pirdday. Ta pirdday tuma; ayissi gooppe, taani taana kiitteeddawaa sheniyaa poliyaawaappe attin, taani dosiyaawaa oothikke. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Taani ta huuphew tabaa markkattooppe, ta markkatethay tuma gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tabaa markkattiyaawe haray de7ee; I tabaa markkattiyaawe tuma gidiyaawaa taani eray. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Hinttenttu Yohaannisakko asaa kiittina, I unttunttoo tumuwaa markkatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Taani hewaa hinttentta attino gaade giyaawaappe attin, asaa markkatethay taw koshshina gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohaannisi muqaaddaadan, eexxeeddanne poo7isseedda; hinttenttukka amareedda wodiyaa A poo7uwan nashettanaw koyyeeddita. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Shin taw Yohaannisawaappe aadhdhiyaa markkatethay de7ee; ayissi gooppe, taani wurssanaw Ta Aabbu taw immeedda kiitay, ha taani oothiyaawe, I taana kiitteeddawaa gidiyaawaa markkattee. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Qassi taana kiitteedda Ta Aabbu bare huuphew tabaa markkattee. Hinttenttu A kooshshaa aynne sisibeykkita; A malaakka be7ibeykkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","I kiitteeddawaa ammanenna diraw, A qaalay hinttenttu wozanaan baawa. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Xoossaa Maxaafatuwaappe medhinaa de7uwaa demmiyaawaa hinttew malatina, unttuntta biddiita; unttunttukka tabaa markkattiyaawantta. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Shin de7uwaa demmanaw taakko yiyaawaa hinttenttu koyyikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Taani asaappe bonchchuwaa koyyikke. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Shin taani hinttenttu wozanaan Xoossaa siiquu baynnawaa eray. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Taani ta Aabbu sunthan yaaddi; shin taana akkibeykkita. Shin hara asay bare sunthan yiyaa wode, A akkiita. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hinttenttu ittu ittuwaa bonchchiita; shin itti Xoossaappe yiyaa bonchchuwaa koyyikkita. Yaatina, waaniide ammananaw danddayiite? ");
INSERT INTO dwrNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Taani Ta Aabbu sinthan hinttentta mootiyaawaa hinttew malatoppo; hinttentta mootiyaawe, hintte hidootaa wothiyaa Musa. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Hinttenttu Musa ammaneeddabaa gidintto, taanakka ammananita; ayissi gooppe, tabaa xaafeeddawe A. ");
INSERT INTO dwrNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Shin hinttenttu I xaafeeddawaa ammanennaan ixxooppe, taani giyaawaa wooti ammananitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hewaappe guyyiyan, Yesuusi Galiilaa Abbaappe woy Xibiriyaadoosa Abbaappe hefintha pinneedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","I hargganchchatuwaa bolla ootheedda wolqqaama malaataa be7eedda diraw, cora asay A kaalleedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesuusi deriyaa kesiide, yaani barena kaalliyaawanttunna ittippe utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ayihudatuu bonchchiya Paasigaa gallassay gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesuusi sinthakko xeelliide, cora asay barekko yiyaawaa be7iide Piliphphoosa, “Ha asaa ubbaa mizanaw gidiyaa qumaa haqappe shammanee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","I hewaa Piliphphoosa paaccanaw geedda; ayissi gooppe, I bare huuphew ayaa oothana bessintto oothanabaa eree. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Piliphphoosi zaariide Yesuusa, “Huuphiyan huuphiyan, haray atto itti itti barssuwa gathanaw, laa77u xeetu dinaariyaan shammeedda ukithaykka gidenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Qassi Yesuusa kaalliyaawanttuppe ittu, Simooni Phexiroosa ishay Inddiraasi, ");
INSERT INTO dwrNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Banggaa ukithaa ichcheshuunne laa77u molii de7iyaa itti na7ay hawaan de7ee; shin ha asaa ubbaw hewe wooti gidanee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesuusi barena kaalliyaawantta, “Asay uttanaadan udite” yaageedda. He sa7an daro maatay de7ee. Asay ubbay utteedda; attuma asay ichcheshu sha77aa gidiyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesuusi ukithaa akeedda; Xoossaa galatiide, hewan utteedda asaw gisheedda. Moliyaakka hewaadan oothina asay bare koyyeeddawaa keenaa meedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Unttunttu ubbay kalleeddawaappe guyyiyan, Yesuusi barena kaalliyawantta “Ittibaykka coo bayenna mala, atteedda dokkaa shiishshite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hewaa diraw, unttunttu ubbaakka shiishsheeddino; asay kallina atteedda banggaa ukithaa dokkaa shiishshiide, tammanne laa77u zambbeeliyaa kuntheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Asay Yesuusi ootheedda wolqqaama malaataa be7eedda wode, “Hawe tumuwaappe ha sa7aa yaana geedda nabiyaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Unttunttu yiide barena wolqqan oyqqi kaatiyaa oothanaw haniyaawaa Yesuusi eriide, barekka deriyaa bolla shirettiide keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sa7ay omarisseedda wode, Yesuusa kaalliyaawanttu abbaakko beeddino; ");
INSERT INTO dwrNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Sa7ay qammeedda; shin Yesuusi unttunttukko he saati gakkanaw yibeenna; hewaassi unttunttu wonggiriyaan geliide, abbaa pinni hefintha Qifirinaahooma beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wolqqaama carkkuu carkkeedda diraw, abbay qaaxxeedda; ");
INSERT INTO dwrNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","itti saatiyaa keenaa unttunttu abbaa shaagowaappe guyyiyan, Yesuusi abbaa bollanna hamettiidde yiyaawaa be7iide yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Shin I, “Yayyoppite; taanattee!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Unttunttu wonggiriyaan A gelissanaw koyyeeddino; wonggirii unttunttu biyaasaa abbaa gaxaa ellekka gakki aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wonttetha gallassi, abbaappe hefinthanna atteedda cora asay abbaa bolla itti wonggiriyaa xalalay de7iyaawaa be7eeddino; Yesuusi barena kaalliyaawanttunna wonggiriyaan geliide, unttunttunna beennaan, unttunttu barekka beeddawaa akeekeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Shin Xibiriyaadoosappe hara wongiratuu Yesuusi Xoossaa galatina, asay ukithaa meeddasaa mataa yeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Asay Yesuusi woy A kaalliyaawanttu hewaan baynnawaa be7iide, Yesuusa koyyanaw wonggiriyan geliide, Qifirinaahooma beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Asay Yesuusa abbaappe hefinthan demmeedda wode, “Tamaarissiyaawoo, hawaa awude yaaddii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesuusi zaariide, “Taani hinttenttussi tumuwaa oday; hinttenttu taana koyyiyaawe ukithaa meedda diraassanne kalleedda diraassa gidiyaawaappe attin, wolqqaama malaataa be7eedda diraassa gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Medhinaa de7uwa qumaw, taani Asa Na7ay hinttenttussi immanawoo, oothiteppe attin, samiyaa qumaw oothoppite; ayissi gooppe, Aawuu Xoossay hewaa dhiishissanaw maatafaa attami wotheedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Hewaappe guyyiyan unttunttu, “Nuuni Xoossaa oosuwaa oothanaw ayaa oothanaw bessii?” yaagiide Yesuusa oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesuusi zaariide, “Hinttenttu oothana mala, Xoossay koyyiyaa kiitay hawaa; I kiitteeddawaan ammanite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Unttunttu zaariide, “Nuuni be7iide, neenan ammanana mala, ay wolqqaama malaataa oothanii? Ayaa kiitettanii? ");
INSERT INTO dwrNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Xoossaa maxaafaan, ‘Unttunttu mannaa mala saluwaappe ukithaa immeedda’ yaagetti xaafettowaadan, nu aawatuu mela biittaan mannaa meeddino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesuusi, “Taani hinttenttussi tumuwaa oday; hinttenttussi saluwaappe tumu ukithaa immiyaawe ta Aabbappe attin, hinttenttussi saluwaappe ukithaa immeeddawe Musa gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ayissi gooppe, tuma gideedda Xoossaa ukithay, saluwaappe wodhdhiyaawe ha alamiyaa asaw de7uwaa immee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Unttunttu zaariide, “Godaw, nuukka he ukithaa ubba wode imma” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesuusi, “Taani de7uwaa ukithaa; taakko yiyaa uray ubbakka koshattenna. Qassi taana ammaniyaa uray aynne saamettenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Shin taani hinttenttussi odeeddawaadan, hinttenttu taana be7eeddita; shin ammanikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta Aabbu taw immiya ubbay taakko yaanawaa; qassi taakko yiyaa oonanne ubbakka taani kare yeddikke. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ayissi gooppe, taani taana kiitteeddawaa sheniyaa polanaw saluwaappe yaaddippe attin, ta sheniyaa polanaw yabeykke. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Taana kiitteeddawe koyyiyaawe hawaa; taani I taw immeedda ubbatuwaakka wurssethaa gallassi denthanaappe attin, ittuwakka bayizzana mala koyyenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ayissi gooppe, ta Aabbu koyyiyaawe hawaa; taana Na7aa be7iide, ammaniyaa ubbatuu medhinaa de7uwa akkanawantta; taanikka he ubbatuwaa wurssethaa gallassi denthana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesuusi, “Taani saluwaappe wodhdheedda ukithaa” geedda diraw, Ayihudatuu A bolla zuuzummeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Unttunttu, “Hawe nuuni A aawuwanne A aatto eriya Yooseefo na7aa Yesuusa gidennee? Yaatina, I waagiide, ‘Taani saluwaappe wodhdhaaddi’ gaanaw danddayii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesuusi zaariide, “Ittu ittuwaanna zuuzummiyaawaa aggite. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taana kiitteedda ta Aabbu taakko aheedda asaappe attin, taakko yaanaw danddayiyaa asay baawa; taanikka wurssethaa gallassi A denthana. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nabatuu ‘Xoossay asaa ubbaa tamaarissana’ yaagiide xaafeeddino; Aawuu giyaawaa sisiyaawenne Aawuwaappe tamaariyaawe ooninne taakko yee. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Xoossaa matappe yeeddawaappe attin, Xoossaa be7eedda asay baawa; A xalalay Xoossaa be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Taani hinttenttussi tumuwaa oday; taana ammaniyaa uraw medhinaa de7uu de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Taani de7uwa ukithaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Hinttenttu aawatuu mela biittaan mannaa meeddino; shin hayqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Asay aappe miide hayqqenna ukithay saluwaappe yiyaawe hawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Saluwaappe wodhdheedda de7uwaa ukithay taana; ooninne ha Ukithaappe mooppe, medhinaw de7anawaa; qassi ha alamiyaa asaw de7o gidana mala, taani immana ukithay ta ashuwaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ayihudatuu, “Ha bitani bare ashuwaa nuuni maana mala, nuussi wootiide immanaw danddayii?” yaagiide barenttu gidduwan palumetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hewaa diraw, Yesuusi unttuntta, “Taani hinttenttussi tumuwaa oday; ta ashuwaa, Asa Na7aa ashuwaa, hinttenttu maana dhayooppe, qassi ta suuthaakka ushana dhayooppe, hinttew de7uu baawa. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ta ashuwaa miyaa urawunne, ta suuthaa ushiyaa uraw medhinaa de7uu de7ee. Taani wurssetha gallassi unttuntta denthana. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ayissi gooppe, ta ashuu tumu qumaa; ta suuthaykka tumu ushshaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ta ashuwaa miyaa uraynne ta suuthaa ushiyaa uray taanan de7ee; taanikka aanani de7ay. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","De7uwa Aawuu taana kiittina, taani A gaasuwan de7iyaawaadan, taana miyaa uraykka ta gaasuwan de7ana. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Saluwaappe wodhdheedda ukithay hawaa; hinttenttu aawatuu miide hayqqeedda mannaa mala gidenna; ha ukithaa miyaa uray medhinaw de7ana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuusi Qifirinaahooma katamaan Ayihuda woosa gollen tamaarissiidde, hawaa odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesuusa kaalliyaawanttuppe dariya baggay hewaa siseedda wode, “Hawe gelenna timirttiyaa; hawaa ooni akkanawee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Shin Yesuusi barena kaalliyaawanttu hewoo zuuzummeeddawaa eriide, “Hawe hinttentta dhubbii? ");
INSERT INTO dwrNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Simmi taani, Asaa Na7ay, kase de7iyaasaa pude kesishshin be7intto ayaa gaanitee? ");
INSERT INTO dwrNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Geeshsha Ayyaanay de7uwaa immee; asaa minotay aynne go77enna. Taani hinttenttussi odeedda qaalay ayyaanaanne de7uwaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Shin hinttenttu gidduwan ammanennawanttu de7iino” yaageedda; ayissi gooppe, ammanennawanttu haqawanttenttonne barena aathi immanawe oonentto Yesuusi koyroppe doommiide ereedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Qassikka Yesuusi, “Ta Aabbuppe gidana dhayooppe ooninne taakko yaanaw danddayenna yaagaade ta odeeddawe hewaa diraassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hewaa gaasuwan, Yesuusa kaalliyaawanttuppe coratuu A aggiide, guyye simmeeddino; laa7entho A kaallibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesuusi qassi tammanne laa77u barena kaalliyaawantta “Hinttekka aggiide baanaw koyyiitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simooni Phexiroose zaariide, “Godaw, nuuni ookko baanee? New medhinaa de7uwaa qaalay de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Neeni Xoossaa Geeshshaa gidiyaawaa nuuni ammaneettonne ereetto” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesuusi unttuntta, “Taani hinttentta tammanne laa77atuwaa doorabeykkitaa? Qassi hintteppe ittu xalahiyaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesuusi hewaa Simoona na7aa Yihudaa Asqqoroota gee; ayissi gooppe, Yihuday Yesuusa kaalliyaa tammanne laa77atuwaappe ittuwa; I Yesuusa aathi immanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hewaappe guyye, Yesuusi Galiilaan yaa haa yuuyyeedda; Ayihudatuu A wodhanaw koyyiyaa diraw, Yihudaan yuuyyana koyyibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ayihudatuu bonchchiya Daasiyaa Baalay gakki utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hewaa diraw, Yesuusa ishatuu A, “Neena kaalliyaawanttu neeni oothiyaawaa be7ana mala, hawaappe denddaade Yihudaa gadiya ba. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ayissi gooppe, barew erettanaw koyyiyaa asay ooninne bare oosuwaa genthenna. Neeni hawantta oothina, nebaa alamiyaa ubbay ero!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ayissi gooppe, haray atto A ishatuukka A ammanibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesuusi unttuntta, “Taw injjetiyaa wodii gakkibeenna; shin hinttenttussi ay wodekka injjetee. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Sa7ay hinttentta ixxanaw danddayenna; shin taani sa7aa kiittay iita gidiyaawaa markkattiyaa diraw, taana ixxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Baalaa bonchchiyaasaa hinttenttu biite; taw injjetiyaa wodii gakkibeenna diraw, taani baalaa bonchchiyasaa baanawe bira” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","I hawaa giide, Galiilaan atteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Shin A ishatuu baalaa gallassaa bonchchiyasaa beeddawaappe guyyiyan, ikka asay be7ennaan geeman yaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayihudatuu baalaa gallassaa bonchchiyaasan A koyyiinonne, “I haqan de7ii?” yaagiidde, A labiino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Asaa gidduwan daro zuuzunthay denddeedda. Amareedda asay, “I lo77o asa” yaagee; haratuu qassi, “A, I asaa balethee” yaagiino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Shin Ayihudatuu yayyeedda diraw, ooninne aabaa qoncciyaan haasayenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Baalaa bonchchiya gallassaa baggan, Yesuusi Geeshsha Golliyaa biide, tamaarissuwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayihudatuu maalalelettiide, “Ha bitani aynne tamaarennaan hawaa keena waani ereeddee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hewaa diraw, Yesuusi zaariide, “Taana tamaarissiyaawe taana kiitteedda Xoossaa matappe yiyaawaappe attin, tawaa gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Xoossaa sheniyaa oothanaw dosiyaa ooninne ha taani tamaarissiyaawe Xoossaa matappe yintto woy qassi taani taappe haasayayitantto erana. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Barewaa haasayiyaa uray bare huuphiyaassi bonchchuwaa koyyee; shin barena kiitteeddawe bonchchettana mala koyyiyaa uray tumanchchaa; aani worddobay baawa. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muse hinttenttussi higgiyaa immibeennee? Shin hintteppe ittuunne higgiyaa naagenna. Taana ayissi wodhanaw koyyiitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Asay zaariide, “Neenan xalahii de7ee; neena wodhanaw oonee koyyeeddawe?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesuusi, “Taani itti wolqqaamabaa oothina, hinttenttu ubbay maalaletteeddita. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Hinttenttu naanaa hinttenttu dookaalana mala, Muse hinttentta azazeedda. Shin dookaalussay hinttenttu aawatuwanna yeeddawaappe attin, Musenna yibeenna; hewaassi hinttenttu Sambbataan attuma naanaa dookaaliita. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Muse higgii azazeedda diraw, hinttenttu Sambbataan dookaaliyaawaa gidooppe, yaatina taani itti asaw kumentha bollaa patheedda diraw, taana ayissi hanqqettiitee? ");
INSERT INTO dwrNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tumu pirddaa pirdditeppe attin, asaa deemuwaa xeelliide pirddoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hewaa diraw, Yeerusalaame asaappe ittu ittuu, “Unttunttu wodhanaw koyyiyaa bitani hawaa gidennee? ");
INSERT INTO dwrNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Be7ite, qoncciyaan I haasayee; unttunttu A aynne giikkino. Hawe Kiristtoosa gidiyaawaa nu kaappatuu tumu eriinooshsha? ");
INSERT INTO dwrNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Shin nuuni A haqappe yeeddentto eroytte; Kiristtoosi yiyaa wode, I haqappe yinttonne ooninne erenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hewaappe guyyiyan, Yesuusi Geeshsha Golliyan tamaarissiidde, bare qaalaa dhoqqu udiide, “Hinttenttu taana eriita; qassi taani haqappe yeeddenttokka eriita. Taani ta sheniyaan yabeykke; shin taana kiitteeddawe tumanchchaa; hinttenttu A erikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Shin taani A eray; ayissi gooppe, I taana kiittina, taani A matappe yaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hewaa diraw, unttunttu A oyqqanaw koyyeeddino; shin A wodii biro gakkibeenna diraw, ooninne A bolla kushiyaa wothibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Shin daro asay Yesuusa ammaniide, “Kiristtoosi yiyaa wode, ha bitani ootheedda malaataappe dariyaawaa oothaneeyee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisaawatuu daro asay Yesuusabaa zuuzummiyaawaa siseeddino; qeesatuwaa kaappatuunne Parisaawatuu A oyqqi qashissanaw amareedda wottaddaratuwaa kiitteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesuusi, “Taani hinttenanna laafaa gami77ana; hewaappe guyyiyan, taana kiitteeddawaakko baana. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hinttenttu taana koyyana; shin demmikkita; ayissi gooppe, taani de7iyaa sa7aa hinttenttu baanaw danddayikkita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ayihudatuu ittu ittuwanna, “Hawe nuuni A demmennaassa haqa baana hanii? Ayihudatuu de7iya Giriike katamaa biide, Giriike asatuwaa tamaarissana hanii? ");
INSERT INTO dwrNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","I, ‘Hintte taana koyyana; shin demmikkita’ qassi, ‘Taani de7iyaasaa hinttenttu baanaw danddayikkita’ yaagee; hewaa giyaawe waagiyaawee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","He baalaa gallassaa bonchchiya gallassaappe waannatiyaa wurssetha gallassaani Yesuusi denddi eqqiide, bare qaalaa dhoqqu udiide, “Saametteedda uray ooninne taakko yiide usho. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Taanan ammaniyaawoo, Xoossaa Maxaafay giyawaadan, A uluwaappe de7uwaa immiyaa haathaa pulttuu gogganawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","I hewaa A ammaneeddawanttu akkana Geeshsha Ayyaanaabaa haasayeedda. Yesuusi biro bare bonchchuwaakko kesibeenna diraw, he wode Geeshsha Ayyaanay unttunttoo imettibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","He asaappe dariya baggay I giyaawaa sisiide, “Tumu hawe naagettiyaa Nabiyaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Haranttu, “Hawe Kiristtoosa” yaageeddino. Shin haranttu qassi, “Kiristtoosi Galiilaappee yeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Xoossaa Maxaafay, ‘Kiristtoosi Daawite zariyaappe, Daawite de7eedda Beeteliheeme katamaappe yaana’ geenneyee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yesuusa gaasuwan asay bare gidduwan shaaketteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","He asaappe ittu ittu A oyqqanaw koyyeeddino; shin kushiyaaninne A bochchibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Geeshsha Golliyaa naagiyaawanttu qeesatuwaa kaappatuwaakkonne Parisaawatuwaakko simmi yeedda wode unttunttu naagiyaawantta, “Ayissi A ahibeykkitee?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Geeshsha Golliyaa naagiyaawanttu unttunttussi, “Ha bitani haasayeeddawaadan, ubbakka ooninne haasayibeenna!” yaagiide zaareeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisaawatuu zaariide, “I hinttenakka balethuwaa? ");
INSERT INTO dwrNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kaappatuwaappe woy Parisaawatuwaappe A ammaneedda asay de7ii? ");
INSERT INTO dwrNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Shin higgiyaa erenna ha asay sheqetteeddawaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Unttunttuppe ittuu kasenna Yesuusakko beedda Niqoodimoosi unttuntta, ");
INSERT INTO dwrNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Itti uray giyaabaa sisennaan woy I ayaa ootheeddentto erennaan de7iidde, kasetiide A bolla pirddiyaawe nu higgiyan de7ii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Unttunttu zaariide A, “Neenikka qassi Galiilaa gadiya asee? Galiilaa gadiyaappe Nabii beettennawaa Xoossaa Maxaafatuwaa biddaade era” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Asay ubbay aggiide, bare soy bare soy beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Shin Yesuusi Wogaraa Mithaan eretteedda Deriyaakko beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wonttetha gallassi guuran Geeshsha Golliyaa simmeedda; ubba asay aakko yiina, uttiide unttuntta tamaarissuwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Muse higgiyaa tamaarissiyaawanttunne Parisaawatuu woshummishshin oyqetteedda itti mishiratto aakko aheeddino. Unttunttu asaa ubbaa sinthan izo essiide Yesuusa, ");
INSERT INTO dwrNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Tamaarissiyaawoo, ha mishiratta woshummaade oyqettaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Higgiyaa bollan Muse hanni mala macca asaa shuchchaan caddana mala, nuuna azazeedda. Yaatina neeni waagay?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Unttunttu hewaa geeddawe Yesuusa mootiyaawaa demmiide A paaccanaassa; shin Yesuusi hokkiide, bare biradhdhiyan biittaa bolla xaafeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Unttunttu A oochchiide aggennaan ixxina, pude dhoqqu giide, “Hintenttu gidduwan nagaraa oothibeenna asay kasetiide, izo shuchchan caddo” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Qassikka hokkiide, biittaa bolla xaafeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Unttunttu hewaa siseedda wode, kasetiide cimatuu kesina, ittu ittuu kesiidde wureeddino; A sinthaan mishiratta eqqa de7ishshin, Yesuusi bare xalalaa atteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","I pude dhoqqu giide mishiratto, “Mishirattee, asatuu haqan de7iino? Ooninne ne bolla pirddibeennee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mishiratta, “Godaw, ooninne ta bolla pirddibeenna” yaagaaddu. Yesuusi izo, “Taanikka ne bolla pirddikke; ba; laa7enthaade nagaraa oothoppa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Qassikka Yesuusi asaw, “Taani alamew poo7uwaa; Taana kaalliyaa ooninne de7uwa immiyaa poo7uwaa demmanappe attin, dhumaani ubbaakka hamettenna” yaagiide haasayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Hewaappe guyye Parisaawatuu, “Neeni nebaa markkattaasa; ne markkatethay tuma gidenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesuusi zaariide, “Taani Tabaa markkattooppekka, Ta markkatethay tuma; ayissi gooppe, Taani haqappe yaadditanttonne qassi haqa baytantto eray; shin hinttenttu erikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Asay pirddiyaa ogiyaan hinttenttu pirddiita; Taani itti uraa bollaakka pirddikke. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Shin Taani pirddiyaawaa gidooppenne, Ta pirdday tuma; ayissi gooppe, Taana kiitteedda Ta Aabbu Taananna de7eeppe attin, Taani Taarekka de7ikke. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Laa77u asaa markkatethay tuma gidiyaawe hinttenttu higgiyaan xaafetti utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Taani Tabaa Ta huuphew markkattaaddi; qassi Taana kiitteedda Ta Aabbukka Tabaa markkattee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Unttunttu, “Ne aabbu haqan de7ii?” yaagiide Yesuusa oochcheeddino. Yesuusi zaariide, “Hinttenttu Taanakka woy Ta Aabbakka erikkita; Taana ereeddawaa gidintto, Ta Aabbakka eranita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuusi Geeshsha Golliyaa tamaarissiidde, imotaa miishshay uttiyaa saaxiniyaa matan hewaa haasayeedda. A ooninne oyqqibeenna; ayissi gooppe, A wodii biro gakkidiggibenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Qassikka Yesuusi unttuntta, “Taani baana hinttenttu Taana koyyana; shin hinttenttu, hinttenttu nagaraan hayqqanita. Taani biyaa sa7akka baanaw hinttenttu danddayikkita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayihudatuu, “I, ‘Taani biyaasaa hinttenttu baanaw danddaykkita’ yaagee; I barena barekka wodhaneeyee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesuusi zaariide, “Hinttenttu garssa asa; Taani bolla asa. Hinttenttu ha alamiyaa asa; Taani ha alamiyaa asa gidikke. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hinttenttu, hinttenttu nagaraan hayiqqanawaa Taani hinttenttussi odeeddawe hawaassa; Taani Taana gidiyaawaa hinttenttu ammanana dhayooppe, hinttenttu, hinttenttu nagaraan hayyanita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Unttunttu, “Neeni oonee?” yaagiide oochcheeddino. Yesuusi zaariide, “Taani Taana. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Taani hinttebaa haasayiyabaynne pirddiyaabay darobay de7ee. Shin Taana kiitteeddawe tumanchchaa; qassi Taani aappe siseeddawaa alamiyaa asaw oday” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","I bare Aawuwabaa haasayiyawaa unttunttu akeekibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hewaa diraw, Yesuusi unttuntta, “Taana Asaa Na7aa hinttenttu masqqaliyaa bolla pude denthiyaa wode, Taani Taana gidiyaawaanne qassi Taani Ta Aabbu Taana tamaarisseeddawaadan haasayiyawaappe attin, Ta sheniyaan aynne oothennawaa hinttenttu eranita. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Qassi taana kiitteeddawe Taananna de7ee; Taani ubba wode A nashechchiyaawaa oothiyaa diraw, I Ta xalalaa aggibeenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuusi hewaa haasayishshin siseedda daro asay A ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuusi barena ammaneedda Ayihudatuwaa, “Hinttenttu Taani tamaarissiyaawoo azazettooppe, tumu Taana kaalliyaawantta. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Hinttenttu tumatethaakka eranita; qassi tumatethay hinttentta aylletethaappe kessanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Unttunttu zaariide, “Nuuni Abraahaamo zare; nuuni oossinneekka aylletibeykko. Yaatina neeni waagaade, ‘Aylletethaappe hinttenttu kesanita’ gay?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesuusi, “Taani hinttenttussi tumuwaa oday; nagaraa oothiyaa ooninne nagaraa aylliyaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ayllii ubba wode soyin de7enna; shin na7ay medhinaw gollen de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Na7ay hinttentta aylletethaappe kesooppe, hinttenttu aylletethaappe tumu kessanita. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Hinttenttu Abraahaamo zare gidiyaawaa Taani eray; shin Ta tamaarissiyaawaa hinttenttu akkenna diraw, Taana wodhanaw koyyiita. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Taani Ta Aabbu Taana besseddawaa haasayay; qassi hinttenttukka hinttenttu aawuwaappe siseeddawaa oothiita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Unttunttu zaariide, “Nu aabbu Abraahaama” yaageeddino. Yesuusi unttuntta, “Hinttenttu Abraahaamo naanaa gideeddentto, I ootheedda oosuwaa malaa oothanita. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Shin Xoossaappe siseedda tumuwaa odeedda Taana hinttenttu wodhanaw koyyiita; Abraahaame hewaadan oothibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hinttenttu, hinttenttu aawuu ootheeddawaa oothiita” yaageedda. Unttunttu zaariide, “Nuuni woshumaan diqaalatethaa yelettibeykko; nuussi itti Aawuu, Xoossaa xalalay de7ee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesuusi unttuntta, “Hinttenttu Xoossaa naanaa tumu gideeddentto, Taana siiqana; ayissi gooppe, Taani Xoossaa matappe yaade hawaan de7ay. Taana I kiitteeddawaappe attin, Taani Ta sheniyaan yabeykke. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Taani tamaarissiyaawaa hinttenttu akeekennawe ayaassee? Taani tamaarissiyaawaa hinttenttu akkenna diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Hinttenttu, hinttenttu aawuwaa iita ayyaanaa naanaa; qassi hinttenttu, hinttenttu aawuu amottiyaawaa oothanaw koyyiita. I kaseppe doommiide, shemppuwaa wodheeddawaa; tumatethay aani baynna diraw, tumatethaakko shiiqi erenna. I wordduwaa haasayiyaa wode, bareppe haasayee; ayissi gooppe, I worddanchchaanne qassi worddookka aawuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Shin Taani tumuwaa haasayiyaa diraw, hinttenttu Taana ammanikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hintteppe Taana nagaraa oothishshin be7aaddi gaanaw danddayiyaawe oonee? Taani tumuwaa haasayiyaawaa gidoppe, Taana ayissi ammanikkitee? ");
INSERT INTO dwrNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xoossaa asa gideedda uray Xoossay giyaawaa sisee; hinttenttu Xoossaa asa gidenna diraw, Xoossay giyaawaa sisikkita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayihudatuu zaariide, “Nuuni neena, ‘Neeni Sammaariyaa asa; neenan iita ayyaanay de7ee’ giidde bayizzeeddoo?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesuusi unttuntta, “Ta bolla iita ayyaanay baawa. Taani Ta Aabba bonchchay; shin hinttenttu Taana kawushshiita. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Taani Ta huuphiyassi bonchchuwaa koyyikke; hewaa Taw koyyiyaawenne pirddiyaawe de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Taani hinttenttussi tumuwaa oday; Taani tamaarissiyaawaa naagiyaa ooninne ubbakka hayqqenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayihudatuu zaariide, “Ne bolla iita ayyaanay de7iyaawaa nuuni ha77i ereeddo. Abraahaame hayqqeedda; nabatuu hayqqeeddino; shin neeni, ‘Ta qaalaa naagiyaa ooninne ubbakka hayqqenna’ yaagaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Neeni hayqqeedda nu aawuwaa Abraahaamoppe daray? Nabatuu qassi hayqqeeddino. Neeni neena oona gaade qoppay?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesuusi, “Taani Taana bonchchooppe, Ta bonchchuu mela; hinttenttu nu Xoossaa giya Ta Aabbu Taana bonchchee. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Hinttenttu A erana dhayooppekka, Taani A eray. Taani A erikke gooppe, hinttenttuwaadan worddo giday; shin Taani A eray; qassi A qaalaakka naagay. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hinttenttu aawuu Abraahaame, Ta yuussaa wodiyaa be7anaw laamoteedda; be7iidekka nashetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayihudatuu zaariide A, “New haray atto ishatamu laythaa kumibeennawe Abraahaama be7aaddii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesuusi unttuntta, “Taani hinttenttussi tumuwaa oday; Abraahaamo yelettanaappekka kase Taani Taana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hewaa diraw, unttunttu Yesuusa caddanaw shuchchaa akkeeddino; shin Yesuusi unttunttuppe geemettiide, Geeshsha Golliyaappe beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesuusi biidde, yelettoodeppe qooqa gidiide de7iya itti bitaniyaa be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yesuusa kaalliyaawanttu Yesuusa, “Tamaarissiyaawoo, ha bitani qooqa gidiide yelettanaadan, nagaraa ootheeddawe oonee? I ootheeddeyee? Woy A yeleeddawanttu ootheeddinoo?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesuusi, “Xoossaa kiitay A bollan qonccana mala qooqeeddappe attin, I woy A daayanne A aabbu nagaraa oothibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nuuni sa7ay qammennaan de7ishshin, Taana kiitteeddawaa oosuwaa oothanaw bessee. Ooninne oothanaw danddayenna qammay yee. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Taani alamiyaan de7aadde alamew poo7o” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesuusi hewaa giide, sa7an cuchcheedda; bare cuchchaani guutha urqqaa shugissiide, he urqqaani qooqa bitaniyaa ayfiyaa okkiide, ");
INSERT INTO dwrNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Baade Saliihooma giya dagatteedda haathaan ne ayfiyaa meecca” yaageedda. “Saliihooma” giyaawe “Kiitetteeddawaa” guussaa. Hewaa diraw, bitani biide, bare ayfiyaa meecettiide, xeelliidde simmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bitaniyaa shooratuunne bitani kase woossishshin be7eedda asay, “Hawe uttiide woossiyaa bitaniyaa gidenneeyee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Qassi amareeddawanttu, “Hawe aattennee” yaageeddino. Haranttu qassi, “Tuytti, hawe A malatiyaawappe attin, A gidenna” yaageeddino. Shin bitani, “Taani aattee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Unttunttu bitaniyaa, “Yaatina, ne ayfi waani xeelleeddee?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I zaariide, “Yesuusa geetettiyaa bitani guutha urqqaa shugissiide, ta ayfiyaa okkiide, ‘Saliihooma geetettiyaa dagatteedda haathaani baade ne ayfiyaa meecetta’ yaageedda. Taani baade meecettaade xeellaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Unttunttu A, “I haqan de7ii?” yaagiide oochcheeddino. Bitani, “Taani erikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Unttunttu kase qooqiide xeelleedda bitaniyaa Parisaawatuwakko afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuusi urqqaa shugissiide, bitaniyaa ayfiyaa patheedda gallassay Sambbata gallassaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hewaa diraw, bitani waani xeelleeddenttonne Parisaawatuu A gujjiide oochcheeddino. Bitani unttunttussi, “I ta ayfiyan guutha urqqaa wotheedda. Ta ayfiyaa meecettaade ha77i xeellaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisaawatuwaappe ittu ittuu, “Hawaa ootheedda bitani Sambbataa higgiyaa naagenna diraw, Xoossaa mataappe yibeenna” yaageeddino. Shin haranttu, “Nagaranchcha asay hawaa mala wolqqaama malaataa waani oothanaw danddayii?” yaagiide unttunttu barenttu gidduwan shaaketteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hewaa diraw, Parisaawatuu bitaniyaa itti kaalla gujjiide, “I ne ayfiyaa dooyyeedda diraw, aabaa waagay?” yaageeddino. Bitani, “I nabiyaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ayihudatuu he xeelleedda bitaniyaa aattonne aawuwaa xeesiide oochchana gakkanaw, bitani qooqa gideeddawaanne ha77i I xeelliyaawaa ammanibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ayihudatuu A aattonne aawuwaa, “Hinttenttu, ‘Qooqa gidiide yeletteedda’ giya hinttenttu na7ay hawee? Yaatina, ha77i waaniide xeelleeddee?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bitaniyaa daayanne aawuu, “Hawe nu na7aa gideeddawaanne qooqa gidiide yeletteeddawaa nuuni ereetto. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Shin ha77i I waani xeelleeddentto, nuuni erokko; woy A ayfiyaa ooni patheeddentto, nuuni erokko. A oochchite; I donzza asa; barebaa haasayanaw danddayee!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bitaniyaa daayanne aawuu Ayihudatoo yayyeedda diraw, hewaa geeddino; ayissi gooppe, Ayihudatuu Yesuusi Kiristtoosa yaagiide markkattiyaa uray de7ooppe, he uraa Ayihuda woosa golliyaaappe kessanaw kaset qofaa qachchi wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","A daayanne aawuu, “I donzza asa; A oochchite!” geeddawe hawaassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hewaa diraw, qooqa gidiide yeletteedda bitaniyaa unttunttu laa7enthuwaa xeesiide, “Xoossaa galata; ha bitani nagaranchcha gidiyaawaa nuuni ereetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bitani, “I nagaranchcha gidiyaawaanne, gidennawaa erikke; taani qooqa gidiyaawaanne ha77i xeelliyaawaa he ittiba eray” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Unttunttu zaariide bitaniyaa, “I new ayaa ootheeddee? I ne ayfiyaa wooti patheeddee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","I unttuntta, “Taani hinttenttussi odaaddi; sisibeeykkita. Ayissi laa7enthuwa sisanaw koyyiitee? Hinttekka Yesuusa kaalliyaawantta giddanaw koyyiitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Unttunttu A boriidde, “Neeni he bitaniyaa kaalliyaawaa; nuuni Musa kaalliyaawantta. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xoossay Musessi haasayeeddawaa nuuni ereetto; shin ha bitaniyaa gidooppe, I haqappe yeeddenttonne nuuni erokko” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Bitani, “I haqappe yeeddenttonne hinttenttu erennawe maalalissiyaawaa; shin I ta ayfiyaa patheedda! ");
INSERT INTO dwrNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Xoossaw yayyiyaa uraynne Xoossay koyyiyaawaa oothiyaa uray de7ooppe, he uraabaa Xoossay sisiyaawappe attin, nagaranchchatuwaabaa sisenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Qooqa gidiide yeletteedda asaa ayfiyaa ooninne pathina, sa7ay medhettoodeppe doommina, sisetti erenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ha bitani Xoossaappe yibeennawaa gidintto, ittibaanne oothanawukka danddayenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Unttunttu zaariide aw, “Neeni nagaraan yelettaade dicceeddawe nuuna tamaarissanaw koyyay?” yaageeddino; Ayihuda woosa golliyaaappe kare A kesseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Unttunttu bitaniyaa kare kesseeddawaa Yesuusi siseedda; Yesuusi bitaniyaa demmiide, “Asa Na7aa ammanay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bitani Yesuusa, “Godaw, taani A ammananaadan I oonee? Taw odarikkii!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesuusi bitaniyaa, “Neeni A be7aadda; ha neenanna haasayiyaawekka A” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bitani zaariide, “Godaw, ammanay” yaagiide Yesuusaw goyinneedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuusi, “Qooqatuu xeellana malanne xeelliyaawanttu qooqana mala, taani pirddanaw ha sa7aa yaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Aananna de7iya amareedda Parisaawatuu hewaa sisiide, “Nuunikka qooqeyee?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesuusi, “Hinttenttu qooqa gideeddentto, hinttenttussi nagaraa gidenna; shin ha77i hinttenttu, ‘Nuuni xeelleetto’ yaagiita; hinttenttu nagaraanna de7iita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuusi, “Taani hinttenttussi tumuwaa oday; dorssaa sikkuwaa penggiyaanna gelennaan harasaanna geliyaa ooninne kaysuwaanne paanuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Shin penggiyanna geliyaawe dorssaa heemmiyaa asaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Penggiyaa naagiyaawe aw penggiyaa dooyyee; dorssatuukka A kooshshaa sisana; I bare dorssatuwaa unttunttu sunthan sunthan xeesiide, kare kaalethana. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","I barewantta kare kesseeddawaappe guyyiyan, unttunttuppe sinthanna hamettee; unttunttukka A kooshshaa eriya diraw, A kaalliino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Hara uraa kooshshaa unttunttu erenna diraw, aappe baqatanaappe attin, A geeduwaa kaallikkino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuusi unttunttussi ha leemisuwaa odeedda; shin I unttunttussi ay odinttonekka unttunttu akeekibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesuusi qassikka unttunttussi, “Taani hinttenttussi tumuwaa oday; taani dorssatoo geliyaa penggiyaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Taappe kase yeedda ubbay kayisuwaanne paanuwaa; shin dorssatuu unttunttu giyaawaa sisibeeyikkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Penggi taana; taanan geliyaa ooninne attanawaa. I gelananne kesana; qassi lo77o maatay de7iyaa sa7akka demmanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kayisuu wuu77anaw, wodhanawunne dhayissanaw yiyaawaappe attin, harabaw yeenna; taani unttunttussi de7uu de7ana malanne kumiide palahana mala yaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Taani dorssaa loytha heemmiyaawa; dorssaa loythi heemmiyaawe he dorssatuwaa diraw hayqqee. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Miishshaa akkiide heemmiyaa uray walliyaa yiyaawode be7iide, dorssatuwaa yeggi bashiide baqatee. Ayissi gooppe, dorssatuu aawantta gidikkino; qassi ikka dorssatuwaa heemmiyaawa gidenna. Hewaa diraw, dorssatuwaa oyqqeenne laalee. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Shaluwaa akkiide heemmiyaawe bare shaloo heemmiyaa dirawunne dorssaabay A qofethenna diraw, dorssatuwaa aggiide baqatee. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Taani dorssaa loytha heemmiyaawa; Ta Aabbu Taana eriyawaadan, Taanikka qassi Ta Aabba eray. Hewaadankka, Taani Ta dorssatuwaa eray; Ta dorssatuukka Taana eriino. Qassi Taani Ta dorssatuwaa diraw, hayqqanaw koyyaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ha sikkuwan baynna hara dorssatuukka Taw de7iino. Taani unttunttakka ahanaw bessee. Qassi unttunttu Ta kooshshaa sisana; itti wudii de7ana; heemmiyawekka ittuwa gidanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taani Ta shemppuwaa zaaraadde akkana mala, aathaade immanaw koyyiyaa diraw, Ta Aabbu Taana siiqee. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Taani dosaade Ta shemppuwaa aatha immiyaawaappe attin, Taappe ooninne akkenna. Taw Ta shemppuwaa aatha immiyaa maatay de7ee; qassi zaaraadde akkanawukka maatay de7ee. Taani ha azazuwaa Ta Aawuwaappe akkaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","He haasayaa diraw, Ayihudatuwaa gidduwaan qassikka shaakuu medhetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Unttunttuppe dariya baggay, “Aani xalahii de7ee! I gooyee! A haasayaa ayissi sisiitee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Haratuu qassi, “Xalahii oyqqeedda asay hawaadan haasayenna; xalahii qooqa asaa ayfiya xeelissanaw danddayiiyee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yeerusalaamen Geeshsha Golliyaa anjjisseedda gallassaa hassayissiyaa Baalay gakkeedda; sa7ay he wode balgguwa. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesuusi Geeshsha Golliyaan Solomona baranddaan, yaanne haanne hamettee. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayihudatuu Yesuusa matan yuuyyi aadhdhiide, “Neeni nuuna awude gakkanaw sidhissaadde wothanii? Neeni Kiristtoosa giddoppe, nuussi geeshshaade oda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesuusi unttunttussi zaariide, “Taani hinttenttussi odaaddi; shin Taana ammanikkita; Taani Ta Aabbu sunthan oothiyaa kiitay Tabaa markkattee. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Shin hinttenttu Ta dorssaa gidenna diraw ammanikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta dorssatuu Ta kooshshaa sisiino; Taani unttuntta eray; unttunttukka Taana kaalliino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Taani unttunttussi medhinaa de7uwaa immay; qassi unttunttu ubbakka hayqqikkino. Ooninne Ta kushiyaappe unttuntta wothi akkanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Unttuntta Taw immeedda Ta Aabbu ooppenne aadhdhee; ooninne Ta Aabbu kushiyaappe unttuntta wothi akkanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tanne Ta Aabbu ittuwa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayihudatuu Yesuusa caddanaw qassikka shuchchaa dentheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesuusi unttuntta, “Taani oothanaw Ta Aabbu Taw immeedda daro lo77o oosuwaa hinttentta bessaaddi; hewanttuppe haqawanttu diraw, Taana shuchchan caddanaw koyyiitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayihudatuu zaariide, “Nuuni neena lo77o oosuwaa diraw, shuchchan caddanaw koyyokko; shin neeni Xoossaa bolla boriyaa qaalaa haasayiyaa dirawunne qassi asaa gidaadde ne huuphiyaa Xoossaa ootheedda diraw, caddanaw koyyeetto!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesuusi zaariide, “Hinttenttu higgiyan Xoossay, ‘Hintte xoossatuwaa’ geeddawe xaafettibeennee? ");
INSERT INTO dwrNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Xoossaa Maxaafatuwaa laammanaw danddayettenna; Xoossay bare qaalay yeedda asatuu, ‘xoossatuwaa’ giide xeeseeddawaa gidooppe, ");
INSERT INTO dwrNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Taani, ‘Taani Xoossaa Na7aa’ geedda diraw, Ta Aabbu anjjiide, sa7aa kiitteedda Taana, ‘Xoossaa bolla boriyaa qaalaa haasayaa’ yaagiitee? ");
INSERT INTO dwrNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taani Ta Aabbu oothiyaawaa oothana dhayooppe, Taana ammanoppite. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Shin Taani oothiyaawaa gidooppe, haray atto hinttenttu Taana ammanana dhayooppekka, Ta Aabbu Taanan de7iyaawaanne Taanikka Ta Aabbun de7iyaawaa eranaadaaninne akeekanaadan, Ta oosuwaa ammanite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Qassikka unttunttu A oyqqanaw koyyeeddino; shin I unttunttuppe kessi akkiide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yohaannisi kase xammaqiyaasaa Yorddaanoosa Shaafaappe hefintha Yesuusi pinniide, yaani de7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Daro asay Yesuusakko yiide, “Yohaannisi wolqqaama malaata oothibeenna; shin I ha bitaniyaabaa haasayeeddabay ubbay tuma” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yaani daro asay Yesuusa ammaneedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Biitaaniyaa giya qeeri katamaan Ali7aazara giya itti bitani harggeedda; he katamay Mayraamanne izi michchatta Martta de7eedda katamaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Godaa gediyaa shittuwaa okkaade, bare binnanaan A gediya qucceeddawunna he Mayraamo; harggeeddawe qassi izi ishaa Ali7aazara. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hewaa diraw, michchatuu, “Godaw, neeni siiqiyaawe harggeedda” giide Yesuusaw kiitteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesuusi hewaa siseedda wode, “Taani Xoossaa Na7ay harggiyaa gaasuwan bonchchettana mala, Xoossaa bonchchuwaassi ha harggii Ali7aazara oyqqeeddappe attin, wodhiyaa harggiyaa gidenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuusi Martto, izi michchattonne Ali7aazara siiqee; ");
INSERT INTO dwrNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ali7aazar harggeeddawaa Yesuusi siseedda wode, bare de7iya sa7an laa77u gallassaa peesheedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hewaappe guyyiyan, Yesuusi barena kaalliyaawantta “Laa7enthuwaa Yihudaa gadiya boytte” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yesuusa kaalliyaawanttu zaariide, “Tamaarissiyaawoo, guutha wodiyaappe kase Ayihudatuu neena shuchchan caddanaw koyyeeddino; qassikka yaa baanii?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesuusi, “Itti gallassan tammanne laa77u saati de7enneeyee? Gallassi hamettiyaa asay dhubettenna; ayissi gooppe, I ha sa7aa poo7uwaa be7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Shin qamma hamettiyaa uray de7ooppe, poo7uu aani baynna diraw, dhubettee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesuusi hewaa geeddawaappe guyyiyaan, qassikka unttunttussi, “Nu dabbu Ali7aazar gemi77isheedda; shin gemi77ishuwaappe A denthanaw Taani bay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yesuusa kaalliyaawanttu zaariide, “Godaw, I gemi77isheeddawaa gidooppe, aw lo77anawaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ali7aazar hayqqeeddawaa Yesuusi odeedda; shin Ali7aazar gemi77ishiide giseeddawaa odeedda giide, unttunttu qoppeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hewaa diraw, Yesuusi geeshshiide unttuntta, “Ali7aazar hayqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Hinttenttu ammanana mala, taani he sa7an de7ennawoo, hinttenttu diraw nashettay. Shin denddite; aakko boytte” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hewaappe guyyiyan, manttiyaa geetettiyaa Toomaasi bare laggethatuwaa Yesuusa kaalliyaawantta, “Yesuusanna hayqqanaw nuunikka qassi boytte!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuusi gakkiya wode, Ali7aazaraw moogettoodeppe oyddu gallassa gideeddawaa demmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Biitaaniyaa katamay Yeerusalaameppe heezzu kiilo miitiriyaa keenaa haakkee. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Daro Ayihudatuu Marttonne Mayraamo unttunttu ishay hayqqeeddawoo menthethanaw yeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martta Yesuusi yeeddawaa sisaadde, A mokkanaw kessaaddu; shin Mayraama gollen attaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martta Yesuusa, “Godaw, neeni hawaan de7eeddawaa gidintto, ta ishay hayqqenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Shin neeni woossiyaawaa ay gidooppenne, Xoossay new haray atto ha77ikka immanawaa taani eray” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesuusi, “Ne ishay hayquwaappe denddana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martta, “Wodiyaa wurssethaan dendduwaa gallassi, I hayquwaappe denddanawaa taani eray” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesuusi iziw, “Taani dendduwaanne de7uwa; Taana ammaniyaa uray haray atto, hayqqoppekka de7uwan de7anawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Qassi de7uwan de7iya uraynne Taana ammaniyaa uray ubbay ubbaakka hayqqenna; hewaa neeni ammanay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martta zaaraadde, “Godaw, E taani ammanay; neeni Xoossaa Na7aa, sa7aa yaanaw de7iya Kiristtoosa gidiyaawaa taani ammanay” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martta hewaa geeddawaappe guyyiyan, baade bare michchattiw geeman xeessaade, “Tamaarissiyaawe yiide, neena koyyee” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mayraama hewaa siseedda wode, elleela dendda eqqaade Yesuusakko baaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesuusi Martta A mokkeedda sa7an de7eeppe attin, biro qeeri katamaa gakkibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mayraamo menthethiidde, gollen izinna de7iya Ayihudatuu, iza ellekka dendda eqqaade kare kesiyaawaa be7iide, Ali7aazar moogetteedda duufuwaa baade yaani yeekkanaw hanaw yaagiide, izo kaalliide keseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mayraama Yesuusi de7iyaasaa baade Yesuusa be7eedda wode, A gediya bollan kunddaaddu; “Godaw, neeni hawaan de7eeddawaa gidintto, ta ishay hayqqenna shin!” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesuusi iza yeekkiyaawaanne qassi izinna yeedda Ayihudatuukka yeekkiyaawaa be7iide, bare wozanaan daro seeletteedda; qassi tookki shemppeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Unttuntta, “Haqan moogeedditee?” yaagiide oochchina, “Godaw, yaade be7a” yaagiide zaareedino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesuusi afoxxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hewaa diraw, Ayihudatuu, “Ali7aazara I ay keenaa siiqintto be7ite!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Shin unttunttuppe ittu ittu, “Hawe qooqa bitaniyaa xeelisseeddawe ha bitani hayqqennaadan udanaw danddayennee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesuusi qassikka wozanaappe qarettiide, Ali7aazar moogetteedda duufuwaakko beedda; he duufuu gonggoluwaa gidiide shuchchan qum77etti utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesuusi, “Shuchchaa diggite!” yaagiide azazeedda. Hayqqeedda bitaniyaa michchatta Martta, “Godaw, I hayqqoodeppe oyddu gallassa gideedda diraw, ha77i xinqqanawaa!” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesuusi Martto, “Ammaniyaawaa gidooppe, neeni Xoossaa bonchchuwaa be7anawaa Taani new odabeykittaa?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Unttunttu shuchchaa dentheeddino; Yesuusi saluwaa pude xeelliide, “Aawoo, Taani giyaawa neeni siseedda diraw, neena galatay. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Neeni ubba wode sisiyaawaa Taani eray; shin hawaan yuuyyi aadhdhiide eqqeedda asay neeni Taana kiitteeddawaa ammanana mala, hawaa Taani unttunttu diraw gay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesuusi hewaa geeddawaappe guyyiyan, bare qaalaa dhoqqu udiide, “Ali7aazaraa, haa kessa!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hayqqeedda Ali7aazara kushiinne gedi shaluwaan qashetti uttiide A deemuuka afilan kametti utteeddawe kesina Yesuusi unttuntta, “Billii aggite! Bo!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hewaa diraw, Mayraamikko yeedda Ayihudatuwaappe coratuu Yesuusi ootheeddawaa be7iide, A ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Shin unttunttuppe ittu ittuu Parisaawatuwaakko biide, Yesuusi ootheeddawaa unttunttussi odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hewaappe guyyiyan, qeesatuwaa kaappatuunne Parisaawatuu yaa7aa shiishshiide, “Ha bitani daro wolqqaama malaataa oothiyaa diraw, ayaa oothanee? ");
INSERT INTO dwrNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nuuni A co77u giide, aggooppe, asay ubbay A ammananawaa; qassi Roome gadiya asatu yiide, nu Geeshsha Golliyaanne nu asaa dhayissana” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Unttunttuppe ittu Qayaafaa giyaa, he laythi qeesatuwaa ubbatuwaa kaappo gideeddawe, “Hinttenttu aynne erikkita! ");
INSERT INTO dwrNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Asay ubbay dhayiyawaappe asa ubbaa diraw, itti asay hayqqiyaawe lo77a gidiyaawaa hinttenttu akeekite?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","I hewaa bareppe gibeenna; shin he laythi qeesatuwaa ubbatuwaa kaappo gidiyaa diraw, Yesuusi Ayihuda asaa diraw hayqqanaw bessiyawaa Nabii odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Qassi Yesuusi Ayihuda asaa xalalaw hayqqenna; shin laaletti de7iya Xoossaa naanaa ittuwaa udi shiishshanaw hayqqanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","He gallassaappe doommiide, unttunttu A wodhanaw maqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hewaa diraw, Yesuusi Ayihudatu gidduwaan qoncciyaan yaa haa hamettibeenna; shin mela biittaa gaxaan de7iya gadiya, Efireema geetettiyaa katamaa beedda. Barena kaalliyaawanttunna hewaan takkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayihudatuu Paasigaa bonchchiya gallassay mateedda; qassi daro asay barena geeshshanaw, Paasigaa bonchchiya gallassay gakkanaappe kase dumma dumma saappe Yeerusalaame beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Unttunttu Yesuusa koyyiino; Geeshsha Golliyaan eqqiide, “Ayaa qoppiitee? Paasigaa bonchchiyaasaa Yesuusi yeennee?” yaagiide ittu ittuwaa oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Qassi qeesatuwaa kaappatuunne Parisaawatuu Yesuusa qachchanaw, I de7iyaasaa eriyaawe ooninne barenttoo odana mala azazeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paasigaa bonchchiya gallassaappe usuppun gallassaa kasetiide, Yesuusi I hayquwaappe dentheedda Ali7aazar de7iya Biitaaniyaa giya katamaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","He sa7an unttunttu aw kawuwaa katheeddino; Ali7aazar aananna uttiide ittippe miyaawanttu giddon utti de7ishshin, Martta kawuwaa gisha mizaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mayraama daro shalluwaan zali77ettiyaa itti xaarimusiyaa gidiyaa narddoosa geetettiyaa geeshsha shittuwaa ahaade, Yesuusa gediya okkaade bare binnanaan A gediya quccaaddu; golliyaa ubbay shittuwaa sawuwaan toshikku gee. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Shin Yesuusa kaalliyaawanttuppe ittuu, Yesuusa aathi immanawe, Yihudaa Asqqorootu, ");
INSERT INTO dwrNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ha shittuu heezzu xeetu diinaariyaani zali77ettina, ayaassi hewe hiyyeesaw imettennee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","I kayisuwaa gideedda diraw, hewaa geeddappe attin, hiyyeesaw qarettiide gibeenna; I miishshaa qarcciitiyaa oyqqiyaawaa gidiyaa diraw, ubba wode aappe barew akkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesuusi, “Ha shittuwaa Taani moogettiyaa gallassay gakkanaw iza ayaw minjjanee? Izo aggite. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Hiyyeesatuu ubba wode hinttenanna de7ana; shin Taani ubba wode hinttenaana de7ikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ayihudatuwaappe daro asay Yesuusi Biitaaniyan de7iyaawaa sisiide, yaa beedda; unttunttu Yesuusa be7ana gishsha xalalaw gidennaan, I hayquwaappe dentheedda Ali7aazarakka be7anaw beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hewaa diraw, qeesatuwaa kaappatuu Ali7aazarakka qassi wodhanaw maqqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ayissi gooppe, Ali7aazara gaasuwaan daro Ayihudatuu barena kaalethiyaawantta aggiide, Yesuusa ammaniino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wonttetha gallassi Paasigaa bonchchiyaasaa yeedda daro asay Yesuusi Yeerusalaame biyaawaa siseedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yaatiide zambbaa haythaa oyqqiide, A mokkanaw keseeddino. Barenttu kooshshaa dhoqqu udiide, “Xoossay galatetto! Xoossaa sunthan yiyaa Israa7eeliyaa kaatii anjjetteeddawaa!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Xoossaa Maxaafay, “Xiyoone katamaw, yayyoppa! Be7a, ne kaatii hare maraa bolla uttiidde yee” giyawaaddan, Yesuusi hare maraa demmiide, A toggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesuusa kaalliyaawanttu hewaa kase akeekibeykkino; shin Yesuusi bonchchetteeddawaappe guyyiyaan, Xoossaa Maxaafay hewaa ubbaa geeddawaanne qassi unttunttukka hewaa ubbaa Yesuusaw ootheeddawaa hassayeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ali7aazar moogetteedda gonggoluwaappe Yesuusi A xeesiide, hayquwaappe dentheedda wode, Yesuusanna de7iya daro asay Yesuusaw markkatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Daro asay A mokkanaw kesseeddawe, I he wolqqaama maalaliyaawaa ootheedda diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hewaa diraw, Parisaawatuu ittu ittuwaa, “Hinttenttu aynne oothanaw danddayennawaa be7iite! Be7ite, gade ubbay A geeduwaa kaalleedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Paasigaa bonchchiya gallassi goyinnanaw Yeerusalaame beeddawanttu giddon itti itti Giriike asatuu de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Unttunttu Galiilaa gadiyan Beetesayda geetettiyaa katamaappe yeedda Piliphphoosakko biide, “Godaw, nuuni Yesuusa be7anaw koyetto” yaagiide woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Piliphphoosi biide, Inddiraasaw odina laa77atuukka biide, Yesuusaw odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesuusi unttunttussi hawaadan yaageedda; “Taani, Asa Na7ay, bonchchettiyaa saati gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Taani hinttenttussi tumuwaa oday; itti zarggaa ayfatta biittaan wodhdhaade wooqqana dhayooppe, barekka attaw. Shin he zarggaa ayfatta wooqqooppe, daro ayfiyaa ayfaw. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Bare shemppuwaa siiqiyaa ooninne bayizzee; qassi bare shemppuwaa ha sa7an ixxiyaa ooninne medhinaa de7oo ashshee. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ooninne Taw oothooppe, Taana kaallanaw bessee; qassi Taani de7iya sa7an Taw oothiyaawekka de7anawaa. Taw oothiyaa oonanne, Ta Aabbukka A bonchchanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ha77i Ta shemppuu daro un77etteedda; yaatina waagoo? Taani, ‘Ta Aabboo, Taana ha saatattippe ashsharkki’ yaagoo? Tuytti, Taani ha saatiyaan yeeddawe hawaa diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ta Aabboo, ne sunthaa bonchcha” yaageedda. He wode saluwaappe, “Taani Ta sunthaa bonchchaaddi; qassikka gujjaade bonchchana” yaagiyaa qaalay yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","He sa7an eqqeedda cora asay he qaalaa sisiide, “Hewe guugunthaa” yaageedda. Haranttu qassi, “Kiitanchchay aw haasayeedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesuusi zaariide unttuntta, “Ha qaalay hinttenttu diraw yeeddawaappe attin, Ta diraassa gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ha sa7ay pirddettiyaa wodii ha77a; ha sa7aa mooddiyaawe ha77i kare olettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Qassi Taani masqqaliyaa bolla kaqettiyaa wode, asa ubbaa Taakko goochchana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","I hewaa geeddawe ay mala hayquwaa I hayqqanenttonne unttuntta erissanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Daro asay zaariide Yesuusa, “Nu higgii Kiristtoosi medhinaw de7iyaawaa odee. Yaatina, neeni waagaade, ‘Asa Na7ay masqqaliyaa bolla kaqettana’ gay? He Asa Na7ay oonee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesuusi, “Poo7uu hinttenanna guutha wodiyaa gami77annawaa. Hinttenttussi dhumenna mala, poo7uu de7ishshin, poo7uwaan hamettite. Dhumaani hamettiyaa uray haqa binttonne erenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Poo7uwaa asa gidana mala, hinttenttussi poo7uu de7ishshin, poo7uwaa ammanite” yaageedda. Yesuusi hewaa haasayeeddawaappe guyyiyan, biide unttunttuppe geemetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","38","I hewaa keena wolqqaama malaata unttunttu sinthan oothooppekka, nabiyaa Isayaase, “Godaw, nu markkatethaa ooni ammaneeddee? Goday bare wolqqaa oona besseedee?” geeddawe tuma gidana mala, unttunttu A ammanibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Isayaase qassikka, “Unttunttu ayfi xeellenna mala, unttunttu wozanaykka akeekenna mala, unttunttu Xoossaakko simmina, I unttuntta pathenna mala, Xoossay unttunttu ayfiyaa qooqisseedda. Unttunttu wozanaa dammisseedda” geedda diraw, unttunttu ammananaw danddayibeyikkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayaase Yesuusa bonchchuwaa be7eedda dirawunne qassi aabaa haasayeedda diraw, hewaa geedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hewaa gidinakka, haray atto Ayihudatu kaappatuwaappekka coratuu Yesuusa ammaneeddino. Shin Parisaawatuu barena Ayihudatuu woosa golliyaappe kessiino giide yayyeedda diraw, ammaneedda giide markkattibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ayissi gooppe, unttunttu Xoossaa sabaappe aathiide, asa sabaa siiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesuusi bare qaalaa dhoqqu udiide yaageedda; “Taana ammaniyaa ooninne Taana kiitteeddawaakka ammaniyaawaappe attin, Ta xalalaa ammanenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Taana be7iyaa ooninne Taana kiitteeddawaakka be7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Taana ammaniyaa ubbay dhumaani de7enna mala, Taani poo7uwaa gidaade sa7aa yaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta qaalaa sisiide azazettenna uraa oonanne Taani pirddikke; ayissi gooppe, Taani alamiyaa ashshanaw yeeddawaappe attin, pirddanaw yabeykke. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Taana ixxiyaa oonanne qassi Ta qaalaa akkenna oonanne pirddiyaawe de7ee. Taani odeedda qaalay wurssethaa gallassi he uraa pirddana. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ayissi gooppe, Taani hawaa Taappe haasayabeykke; shin Taana kiitteedda Ta Aabbu Taani gaanawaanne haasayanawaa Taana azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Qassi A azazuu medhinaa de7uwa ahiyaawaa Taani eray; hewaa diraw, Taani odiyaawe Ta Aabbu Taana oda giide odeeddawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paasigaa bonchchiya gallassay gakkanaappe kasetiide, ha sa7aappe shaakettiide, Aawuwaakko biya wodii gakkeeddawaa Yesuusi ereedda; ha sa7an de7iya barewantta ubba wode siiqeedda; wurssethay gakkanaw unttuntta siiqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesuusinne kaalliyaawanttu kawuwaa miishshin, Simoona na7aa Yihudaa Asqqorootu Yesuusa aathi immanaadan, xalahii A qofissi wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuusi bare Aawuu ubbabaa A kushiyan wotheedawa, qassi Xoossaa matappe I yeeddawaanne, simmiide aakko baanawaa ereedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yesuusi miyasaappe denddi eqqiide, bolla bagga mayuwaa qaari wothiide, pooxaa bare xeessan danceedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hewaappe guyyiyan, haathaa meechchaa miishshaan tigiide, barena kaalliyaawanttu gediya meechchaanne bare xeessan danceedda pooxan qucussaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesuusi Simooni Phexiroosakko yiina Phexiroose, “Godaw, neeni ta gediya meeccanaw hanayiyee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesuusi zaariide A, “Taani oothiyaawaa neeni ha77i erakka; shin guyyeppe eranaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Phexiroose, “Neeni ta gediya ubbakka meeccakka!” yaageedda. Yesuusi A, “Taani ne gediya meeccana dhayooppe, newunne Tawunne ittipetethay baawa” yaagiide zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoona Phexiroose Yesuusa, “Godaw, yaatooppe, ta gediya xalalaa meeccoppa; ta kushiyaakka ta huuphiyaakka meecca!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesuusi zaariide, “Bollaa meecettidiggeedda uray ooninne gediyaappe harabaa meecettanaw koshshenna; aw ubbasaykka geeshsha. Qassi hinttenttukka geeshsha; shin ubbay geeshsha gidikkita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ayissi gooppe, Yesuusi barena aathi immana uray oonenttonne ereedda; I, “Hinttenttu ubbay geeshsha gidikkita” geeddawe hawaassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Unttunttu gediya meecceeddawaappe guyyiyan, Yesuusi bare mayuwaa mayyiide, baresaa guyye simmi bi uttiide unttuntta yaageedda; “Taani hinttenttussi ootheeddawaa akeekiitee? ");
INSERT INTO dwrNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hinttenttu Taana, tamaarissiyaawoonne Godaw giita; Taani he hinttenttu giyawaa gidiyaa diraw, loytheeddita. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Taani hinttenttussi Godaanne hinttentta tamaarissiyaawaa gidaadde, hinttenttu gediya meecciyaawaa gidooppe, hinttenttukka ittu ittuwa gediya meeccanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ayissi gooppe, Taani hinttenttussi ootheeddawaadan, hinttenttukka oothana mala, hinttenttussi leemisuwaa gidaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Taani hinttenttussi tumuwaa oday; qoomay bare godaappe aadhdhenna. Qassi kiitetteedda uraykka barena kiitteeddawaappe aadhdhenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hinttenttu hewaa eriide oothiyaawaa gidooppe anjjetteeddawantta. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Taani hinttenttoo ubbabaa haasayikke. Taani dooreeddawantta eray; shin Xoossaa Maxaafay, ‘Taani barsseeddawe Ta kushiyaa sa77eedda’ geeddawe tuma giddanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Hewe haniyaa wode Taani Taana gidiyaawaa hinttenttu ammanana mala, hewe hananaappe kasetaade hinttenttussi hananawaa oday. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Taani hinttenttussi tumuwaa oday; Taani kiittiya oonanne mokkiyaa uray taanakka mokkee; qassi Taana mokkiyaa ooninne Taana kiitteeddawaa mokkee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuusi hewaa haasayeeddawaappe guyyiyan, bare wozanaan daro metootiide, “Taani hinttenttussi tumuwaa oday; Taana hintteppe ittuu aathi immanawaa” giide qoncciyaan odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","I oona haasayinttonne, kaalliyaawanttussi ubbaakka erettennaan ixxina, ittuu ittuwa xeelleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesuusa kaalliyaawanttuppe ittuu, Yesuusi siiqiyaawe, Yesuusa matan utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Hewaa diraw, Simoona Phexiroose he kaalliyaawaa simi77iide, “I oona gintto, ane A oochcha” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hewaa diraw, he kaalliyaawe Yesuusa haythaakko shiqiide, “Godaw, I oonee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesuusi zaariide, “Taani ukithaan cabbaa tushaade immiyaawe A” yaageedda. Qassi ukithaa menthi akkiide, cabbaa tushiide, Simoona na7aa, Yihudaa Asqqorootussi immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yihuday ukithaa menthowaa akowaappe guyyiyan, Seexaanay elekka Yihudaan geleedda. Yesuusi A, “Neeni oothanawaa elleella ootha!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Shin he sa7an utteeddawantuppe ooninne Yesuusi hewaa A ayissi geeddenttonne eribeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yihuday miishshaa qarcciitiyaa oyqqiyaa diraw, kaalliyaawanttuppe ittu ittuu Yesuusi Yihudaa, “Paasigaa bonchchiya gallassaw barena koshshiyaawaa baade shamma woy hiyyeesaw mixuwaataa imma geedda” yaagiide qoppeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yihuday ukithaa menthowaa akkiide, elekka kare kesseedda; he wode sa7ay qamma. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yihuday kare keseeddawaappe guyyiyan, Yesuusi yaageedda; “Ha77i Taani Asa Na7ay bonchchettaaddi: Xoossaykka Ta bagganna bonchchetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Xoossay Ta bagganna, Asa Na7aa bagganna bonchchettooppe, I bare huuphew Taana Asa Na7aa bonchchanawaa; qassi I Taana elekka bonchchanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ta naatoo, Taani hinttenanna daro wodiyaa gami77ikke. Hinttenttu Taana koyyana; shin Taani Ayihudatuwaa, ‘Taani biyaasaa hinttenttu baanaw danddayikkita’ geeddawaadan, hinttewukka ha77i oday. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Taani hinttentta ooratha azazuwaa azazay; ittu ittuwa siiqite. Taani hinttentta siiqeeddawaadankka, hinttenttu ittu ittuwa siiqana bessee. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Hinttenttu ittu ittuwaanna siiqettooppe, Taana kaalliyaawantta gidiyaawaa asay ubbay erana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simooni Phexiroose Yesuusa, “Godaw, neeni haqa bay?” yaageedda. Yesuusi zaariide, “Taani biyaasaa neeni ha77i Taana kaallanaw danddayakka; shin guyyeppe kaallana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Phexiroose, “Godaw, taani neena ha77i kaallanaw ayissi danddayikkitaa? Taani ne diraw, hayqqanawukka giiga uttaaddi!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesuusi zaariide, “Ta diraw hayqqanaw ha77i tumu giiga uttaaddii? Taani new tumuwaa oday; kuttuu waassanaappe kase, neeni Taana heezzu gede kaddanaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuusi kaalliyaawantta “Hinttenttu wozanay hirggoppo; Xoossaan ammanite; Taanankka ammanite. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ta Aabbu gollen daro sa7ay de7ee. Hewaa gidennentto, Taani hinttenttussi hewaa odikke; Taani hinttenttussi sa7aa giigissanaw bay. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Taani baade sa7aa giigisseeddawaappe guyyiyan, Taani de7iya sa7an hinttenttukka de7ana mala, simma yaade hinttentta Taakko aakka afana. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Qassi hinttenttu Taani biya ogiyaa eriita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomaasi, “Godaw, neeni biyaasaa nuuni erokko; ogiyaa waaniide eranaw danddayeetto?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesuusi zaariide, “Ogii, tumuunne de7uu Taana; Ta baggannappe attin, ooninne Ta Aabbukko baanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Hinttenttu Taana eriyaawaa gidintto, Ta Aabbakka erana; ha77ippe doommiide, hinttenttu A eriitanne qassi A be7eeddita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Piliphphoosi Yesuusa, “Godaw, Aawuwaa nuuna bessa; hewe nuussi gidanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesuusi zaariide yaageedda; “Piliphphoosaa, Taani hawaa keena wodiyaa hinttenanna de7inakka Taana erikkii? Taana be7eedda uray Aawuwaakka be7eedda; yaatina, neeni waagaade, ‘Aawuwaa nuuna bessa’ gay?” ");
INSERT INTO dwrNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Taani Aawuwaa giddon de7iyaawaa qassi Aawukka Ta giddon de7iyaawaa neeni ammanikkii? Taani hinttenttussi odiyaa qaalaa Taani Taappe odikke; shin Ta giddon de7iya Aawuu bare oosuwaa oothee. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taani Aawuwaa giddon de7iyaawaanne qassi Aawukka Ta giddon de7iyaawaa Taana ammanite; hewe dhayooppe, Ta oosuwaabaw Taana ammanite. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Taani hinttenttussi tumuwaa oday; Taana ammaniyaa uray Taani oothiyaa oosuwaa oothana. Taani Aawuwaakko biya diraw, he uray hawaappe aadhdhiyaa oosuwaa oothana. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aawuu Na7aa gasuwan, Ta bagganna bonchchettana mala, Ta sunthan hinttenttu woossiyaa ubbabaa Taani hinttenttussi polana. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Hinttenttu Ta sunthan Taana ayaanne oochchooppekka, Taani polana. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Hinttenttu Taana siiqiyaawaa gidooppe, Ta azazuwaa naagana. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Taani Aawuwaa woossana; hinttenanna medhinaw de7ana mala, tumatethaa Ayyaanaa, hara menthethiyaawaa hinttenttussi I immana. Ha sa7ay he tumatethaa Ayyaana be7ennawaanne erennaawaa gidiyaa diraw, A akkanaw danddayenna; shin I hinttenanna de7iya dirawunne hinttenttu giddon de7ana diraw, hinttenttu A eriita. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Taani hinttentta aawuunne aatta baynna yii7o naanaadan hintterekka aggabashikke; Taani simmaade hinttenttukko yaana. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Guutha wodiyaappe guyyiyan, alamii Taana laa7enthuwa be7enna; shin hinttenttu Taana be7ana; Taani de7uwan de7iya diraw, hinttenttukka qassi de7uwan de7ana. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Taani Ta Aawuwaa giddon de7iyaawaanne hinttenttu Ta giddon de7iyaawaa, qassi Taani hinttenttu giddon de7iyaawaanne hinttenttu he gallassi erana. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ta azazuu A matan de7iya asay, qassi he azazuwaakka naagiyawe, I Taana siiqiyaa asa. Taana siiqiyaa asa Ta Aabbukka siiqee; Taanikka A siiqay. Taani aw qonccana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yihudaa Asqqoroota gidenna Yihuday Yesuusa, “Godaw, neeni ne huuphiya alamiyaa bessennaan, nuuna bessana giyaawaa waagaade gay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesuusi, “Taana siiqiyaa ooninne Ta qaalaa naagee; Ta Aabbu A siiqanawaa; qassi Ta Aabbunne Taaninne aakko yiide, aananna de7ana. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Taana siiqenna uray ooninne Ta qaalaw azazettenna; hinttenttu sisiyaa qaalay Taana kiitteedda Aawuwaappe attin, Tawaa gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Taani hinttenanna ittippe de7aadde hawaa hinttenttussi odaaddi; ");
INSERT INTO dwrNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","shin Geeshsha Ayyaanay, menthethiyaawe, Aawuu Ta sunthan kiittanawe, hinttentta ubbabaa tamaarissanawaa. Taani hinttenttussi odeedda ubbabaakka hinttentta hassayissanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Taani sarotethaa hinttenanna wothay; Ta sarotethaa hinttenttussi immay. Taani alamii immiya sarotethaa malaa immikke. Hinttenttu hirggoppitenne yayyoppite. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Taani hinttenttussi, ‘Taani bay; shin simmaade hinttenttukko yaana’ geeddawaa siseeddita; hinttenttu Taana siiqeeddawaa gidintto, Taappe Aawuu dariya diraw, Taani Aawuwakko biyaawan hinttenttu nashettanitta. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hewe haniyaa wode hinttenttu ammanana mala, hewe hanennaan de7ishshin, haananna kasetaade Taani hinttenttussi odaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Ha alamiyaa mooddiyaawe yiyaa diraw, Taani hawaappe sinthan hinttenanna loytha haasayikke. Taana I aynne oothanaw danddayenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Shin Taani Aawuwaa siiqiyaawaa alamii eranaw bessee; qassi Taanikka Aawuu Taana azazeeddawaadan oothay. Denddi eqqite; hawaappe boytte. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Taani woyiniyaa geetettiyaa turaw tumu ano; goshshanchchay Ta Aabba. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta giddon de7iya ayfiya ayfenna turaa maraa ubbaa I karee; ayfiya turaa maraa ubbay kasewaappe loythi ayfanaadan, he maraa xeeraa I ciggiide geeshshana. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Taani hinttenttussi ha77i odeedda qaalaa gaasuwan, hinttenttu geeshsha. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ta giddon de7ite; Taanikka hinttenttu giddon de7ana. Woyiniyaa turaa maray anuwaanna ittippe de7ennaan dhayooppe, he maray barekka ayfiya ayfanaw danddayennawaadan, hinttenttukka Ta giddon de7ennaan dhayooppe, ayfiyaa ayfanaw danddayikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Taani woyiniyaa turaw ano; hinttenttu he turaa maratuwaa. Ta giddon de7iya uray, Taanikka A giddon de7iya uray, daro ayfiya ayfana; ayissi gooppe, Taani baynnaan hintterekka aynne oothanaw danddayikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ta giddon de7enna uray turaa maraadan, karen yeggina meleeddawaa shiishshiide tamaan wothina, I eexxanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Hinttenttu Ta giddon de7ooppe, qassi Ta qaalaykka hinttenttu giddon de7ooppe, hinttenttu koyyeeddawaa ayaa gidinakka woossite; hinttenttu akkanita. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hinttenttu daro ayfiyaa ayfooppenne qassi Taana kaalliyaawantta gidooppe, hewan Ta Aabbu bonchchettanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Aawuu Taana siiqeeddawaadan, Taanikka hinttentta siiqaaddi; Ta siiquwan de7ite. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Taani Ta Aabbu azazuwaa naagaade A siiquwan de7eeddawaadan, hinttenttukka Ta azazuwaa naagooppe, Ta siiquwan de7anita. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ta nashechchay hinttenanna de7ana malanne, hinttenttu nashechchay kumentha gidana mala, Taani hawaa hinttenttussi odaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ta azazuu hawaa; Taani hinttentta siiqiyaawaadan, hinttenttukka ittu ittuwanna siiqettite. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bare shemppuwaa bare laggew aathiide immiyaawaappe aadhdhiyaa siiquu oossinneekka baawa. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Taani hinttentta azazeedawaa ubbaa oothooppe, hinttenttu Ta laggetuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Ayllii bare goday oothiyaawaa erenna diraw, Taani hinttentta hawaappe sinthaw ayllatuwaa giikke; shin Taani hinttentta Ta laggetuwaa gaaddi. Ayissi gooppe, Ta Aawuwaappe siseedda ubbabaa Taani hinttenttussi odaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Taani hinttentta dooreeddawaappe attin, hinttenttu Taana dooribeykkita. Hinttenttu biide ayfiyaa ayfana malanne de7ana mala, Taani hinttentta sunthaaddi. Qassi Aawuukka hinttenttu Ta sunthan woosseeddawaa ubbaa immana. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Taani hinttentta azaziyaawe hawaa; ittu ittuwaanna siiqettite. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Alami hinttentta ixxooppe, kasetiide Taana ixxeeddawaa akeekite. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Hinttenttu alamiyaassa gideedentto, alamii barewaadan hinttentta siiqana; shin Taani hinttentta alamiyaappe dooreeddawaappe attin, hinttenttu alamiyaassa gidikkita; alamii hinttentta ixxiyaawe hawaassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘Aylli bare godaappe darenna’ gaade Taani hinttenttussi odeeddawaa hassayite. Unttunttu Taana yedersseeddawaa gidooppe, hinttenakka yederssana. Unttunttu Ta qaalaa naageeddawaa gidooppe, hinttenttu qaalaakka naaganawantta. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Shin unttunttu Taana kiitteeddawaa erenna diraw, ha ubbaa Ta gaasuwan unttunttu hinttenttu bolla oothanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Taani yaade unttunttussi odennawaa gidintto, unttunttussi nagaraa gidenna; shin ha77i unttunttu oothiyaa nagaraa gaasoyiyaawe baawa. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","24","Taana ixxiyaawe Ta Aawuwaakka ixxeedda. Ooninne oothibeenna oosuwaa unttunttu giddon Taani oothabeennabaa gidintto, unttunttussi nagaraa gidennaan attanawaa; shin ha77i unttunttu Taani ootheedda oosuwaa be7iide, Taanakka Ta Aawuwaakka ixxeedino. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Shin unttunttu higgiyan, ‘Taana coo ixxeeddino’ geetettiide xaafetteeddawe polettana mala, hawe haneedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Shin Aawuwaappe yiyaa tumatethaa Ayyaanay menthethiyaawe yaanawaa. Taani Aawuwaappe hinttenttussi A yeddana; qassi I Tabaa markkattanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hinttekka qassi kaseppe doommiide, Taananna de7iya diraw, Tabaa markkattana. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Taani hawaa hinttenttu dhubettenna mala, hinttenttussi odaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Unttunttu hinttentta barenttu Ayihuda woosa golliyaaappe kessi yeddanawantta. Hewaa bolla qassi hinttentta wodhiyaa uray Xoossaw oothiyaawaa aw malatiyaa wodii yaanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Unttunttu hewaa hinttenttu bolla oothiyaawe Taananne Aawuwaa erenna diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Shin unttunttu hewaa hinttenttu bolla oothiyaa wodii gakkiya wode, Taani hinttenttussi odeeddawaa hinttenttu hassayana mala, Taani hinttenttussi hawaa odaaddi. “Taani hinttenanna de7iya diraw, koyro hewaa hinttenttussi odabeykke. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Shin ha77i Taani Taana kiitteeddawaakko bay; shin hintteppe ooninne, ‘Haqa bay?’ giide Taana oochchiyawe baawa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Shin Taani hawaa odeedda diraw, hinttenttu wozanaan daro kayyuu de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Shin Taani hinttenttussi tumuwaa oday; Taani biyaawe hinttenttussi lo77a. Ayissi gooppe, Taani baana dhayooppe, menthethiyaawe hinttentukko yeenna; shin Taani booppe, A hinttenttukko yeddana. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Qassi menthethiyaawe yiide, unttunttu nagaraabaa, Xoossaa xillotethaabaanne pirddaabaa ha sa7aa asay bayizzeeddawaa bessanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nagaraabay asay Taana ammanenna diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Xillotethaabay qassi Taani Aawuwakko biya diraw, hinttenttu Taana laa7enthuwa be7ikkita. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Xoossaa pirddaabay qassi alamiyaa mooddiyaawe pirddetteedda diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Taani hinttenttussi odiyaabay darobay de7ee; shin ha77i hinttenttussi gelenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tumatethaa Ayyaanay yiyaa wode, hinttentta tumatethaa ubbaakko kaallethanawaa. Ayissi gooppe, I bare siseeddawaa odanaappe attin, bareppe aynne odenna. Qassi sinthappe yaanabaa hinttenttussi I odanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","I Taana bonchchanawaa; ayissi gooppe, I Taw de7iyaawaappe akkiide, hinttenttussi odanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Aawoo de7iyaabay ubbay Tawaa; menthethiyaawe Taw de7iyaabaappe akkiide, hinttenttussi odanawaa Taani geeddawe hawaassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Guutha wodiyaappe guyyiyan, hinttenttu Taana be7ikkitta; qassi guutha wodiyaappe guyyiyan, hinttenttu Taana be7ana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesuusa kaaliyaawanttuppe ittu ittuu barenttu giddon, “ ‘Guutha wodiyaappe guyyiyan, hinttenttu Taana be7ikkitta; qassi guutha wodiyaappe guyyiyan, hinttenttu Taana be7anita; ayissi gooppe, Taani Aawuwaakko bay’ giyawe hewe waagiyaawe?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“ ‘Guutha wodiyaappe guyyiyan’ giyawe waagiyaawe? I ayissi haasayinttonne nuussi erettenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Unttunttu barena oochchanaw koyyiyaawaa Yesuusi eriide, unttuntta yaageedda; “Taani, ‘Guutha wodiyaappe guyyiyan, hinttenttu Taana be7ikkitta; qassi guutha wodiyaappe guyyiyaan, hinttenttu Taana be7ana’ geeddawoo hinttenttu ittu ittuwaa oochchiitee? ");
INSERT INTO dwrNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Taani hinttenttussi tumuwaa oday. Hinttenttu yeekkananne kayyottana; shin ha alamii nashettana. Qassi hinttenttu kayyottana; shin hinttenttu kayyottowe nashechchaa gidanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Itti mishiratta na7aa yelana haniyaa wode, bare yeliyaa wodii gakkeedda diraw, oyqettaw; shin na7ay yeletteeddawaappe guyyiyan, na7ay ha sa7an yeletteedda nashechchaa diraw, bare oythaa hassayukku. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Hewaa diraw, hinttenttukka hinttenttu wozanaan kayyottiita; shin Taani laa7enthuwa hinttentta be7ana; qassi hinttenttu wozanay loythi nashettana; hinttenttu nashechchaa ooninne hintteppe akkenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“He gallassi hinttenttu Taana aynne woossikkita. Taani hinttenttussi tumuwaa oday; hinttenttu Ta sunthan woossiyaawaa ubbaa Aawuu hinttenttussi immanawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ha77i gakkanaassi Ta sunthan aynne woossibeeykkita; hinttenttu nashechchay polettana mala, Xoossaa woossite; hinttenttu akkana. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Hawaa Taani hinttenttussi leemisuwan odaaddi; shin Taani leemisuwan odenna wodii yaanawaa; shin Aawuwaabaa Taani hinttenttussi qoncciyaan odana. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Taani he gallassi, hinttenttu Ta sunthan Aawuwaa woossana; qassi hinttenttu diraw, Taani Aawuwaa woossana giikke. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ayissi gooppe, Aawuu bare huuphew hinttentta siiqee; hinttenttu Taana siiqiyaa dirawunne Taani Aawuwaa matappe yeeddawaa ammano diraw, I hinttentta siiqee. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Taani Aawuwaa matappe ha alamiyaa yaaddi; qassi ha alamiyaa aggaade Aawuwaakko baana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesuusa kaalliyaawanttu zaariide Yesuusa, “Be7a, ha77i neeni qoncciyaan haasayaasa; leemisuwan aynne haasayakka. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Neeni ubbabaa eriyaawaa nuuni ha77i ereetto; qassi neena ooninne oochchana mala, neeni koyyennawaa ereetto. Hewe nuuna neeni Xoossaappe yeeddawaa ammanthee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesuusi zaariide unttuntta, “Ha77i ammaniitee? ");
INSERT INTO dwrNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Be7ite, hinttenttu hinttenttu golle golle laalettiyaa wodiinne Ta xalalaa yeggi bashiyaa wodii yaanawaa; ha77ikka yidiggeedda. Shin Aawuu Taananna de7iya diraw, Ta xalalaa gidikke. ");
INSERT INTO dwrNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Hinttenttu Ta giddon de7iidde, saro de7ana mala, Taani hawaa hinttenttussi odaaddi. Alamiyan hinttenttu waayyettana. Shin minnite; Taani alamiyaa xoonaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuusi hewaa haasayeeddawaappe guyyiyan, pude saluwaa xeelliide, hawaadan yaageedda; “Ta Aabboo, wodii gakkeedda; ne Na7ay neena bonchchana mala, neenikka ne Na7aa bonchcha. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ayissi gooppe, neeni aw immeedda ubbaw medhinaa de7uwaa I immana mala, asaa ubbaa bollan aw maataa immaadda. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Asay neena itti tumu Xoossaa gideeddawaa erana malanne, qassi neeni kiitteedda Yesuusi Kiristtoosa erana mala, hawe medhinaa de7uwaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Neeni Taw oothanaw immeedda oosuwaa polaade, neena sa7an bonchchaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ha77ikka qassi Aawoo, alamii medhettanaappe kase ne matan Taw de7iya bonchchuwan ne sinthan Taana bonchcha. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Alamiyaa asaappe neeni Taw immeeddawanttoo ne sunthaa erissaaddi; unttunttu newantta; qassi neeni unttuntta Taw immaadda. Unttunttu ne qaalawukka azazetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ha77i neeni Taw immeedda ubbabay neeppe yeeddawaa unttunttu eriino. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ayissi gooppe, neeni Taw immeedda qaalaa Taani unttunttussi immaaddi; unttunttukka he qaalaa akkeeddino. Taani ne matappe yeeddawe tuma gidiyaawaa eriide Neeni Taana kiitteeddawaakka ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Taani unttunttussi woossay; alamew neena woossikke. Shin Neeni Taw immeedda asaw woossay; ayissi gooppe, unttunttu newantta. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Taw de7iya ubbabay nebaa; qassi New de7iyaa ubbabaykka Tabaa. Taani unttunttu bagganna bonchchettaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Taani hawaappe guyyiyan, alamiyan de7ikke; unttunttu alamiyan de7iino; Taani ha77i neekko bay. Geeshsha Aawoo, ha Neeni Taw immeeddawanttu Neeninne Taani ittuwaa gidiyaawaadan, unttunttu ittuwaa gidana mala, unttuntta ne sunthan naaga. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Taani unttunttunna alamiyan de7aadde, neeni Taw immeedda ne sunthaa wolqqan unttuntta naagaaddi. Taani unttuntta naagaaddi; Xoossaa Maxaafay geeddawe polettana mala, bashshay bessiyaa uraappe attin, unttunttuppe haray ooninne baybeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ha77i Taani Neekko bay; unttunttu wozanaan Ta nashechchay polettana mala, hawaa Taani alamiyan haasayay. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Taani unttunttussi ne qaalaa immaaddi; Taani alamiyaassa gidennawaadan, unttunttukka alamiyaassa gidenna diraw, alamii unttuntta ixxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Neeni xalahiyaappe unttuntta naagana mala woossiyaawaappe attin, alamiyaappe kessana mala woossikke. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taani alamiyaassa gidennawaadan, unttunttukka alamiyaassa gidikkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Neeni tumatethaan unttuntta newantta ootha; ne qaalaykka tumatethaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Neeni Taana alamiyaa kiitteeddawaadan, Taanikka unttuntta alamiyaa kiittaaddi; ");
INSERT INTO dwrNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","qassi unttunttu tumatethaan new dummatana mala, unttunttu diraw, Taani Ta huuphiya new dummayaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Taani unttunttu xalalaw woossikke; shin unttunttu qaalaa odina, Taana ammaneeddawanttookka woossay. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Unttunttu ubbay ittuwa gidana mala, Taani woossay. Aawoo, Neeni Ta giddon de7iyaawaadan, qassi Taanikka Ne giddon de7iyaawaadan, unttunttu nu giddon de7iino. Qassi neeni Taana kiitteeddawaa alamii ammanana mala, unttunttu ittuwa gidino. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neeninne Taani ittuwa gidiyaawadan, unttunttu ittuwa gidana mala, neeni Taana bonchcheeddawaadan, Taanikka unttuntta bonchchaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Taani unttunttu giddon de7ina, Neeni Ta giddon de7ina, qassi Neeni Taana siiqiyaawaadan, unttunttakka siiqowaanne Neeni Taana ha alamiyaa kiitteeddawaa alamii eranaadan, unttunttu ubba ittuwaa gidino. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Aawoo, sa7ay medhettanaappe kase Neeni Taana siiqeedda diraw, Taw immeedda Ta bonchchuwaa unttunttu be7ana mala, Neeni Taw immeeddawanttu Taani de7iya sa7an Taananna de7ana mala koyyaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Xillo Aawoo, alamiyaa asay Neena erenna; shin Taani neena eray. Qassi Neeni Taana kiitteeddawaa hawanttu eriino. ");
INSERT INTO dwrNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Neeni Taana siiqeedda siiquu unttunttu giddon de7ana mala, qassi Taanikka unttunttu giddon de7ana mala, Taani Ne sunthaa unttuntta erissaaddi; sinthawukka erissana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuusi hewaa giide, Xoossaa woosseeddawaappe guyyiyan, barena kaalliyaawanttunna Qediroona giya zanggaaraa pinneedda. He sa7an atikilttiyaa sa7ay de7ee; Yesuusinne Yesuusa kaalliyaawanttu geleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesuusa aathi immeedda Yihuday he sa7aa ereedda; ayissi gooppe, Yesuusi ubba wode barena kaalliyaawanttunna hewan shiiqee. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hewaa diraw, kaalethiyaa qeesatuwaa kaappatuunne Parisaawatuu Yihudaanna baanaadan immeedda Roomaa wottaaddaratuunne Geeshsha Golliyaa naagiyaawanttu kuraaziyaa, yabbiyaanne tooraa oyqqiide he sa7aa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesuusi barena gakkanaw haniyaa ubbabaa eriide, gaxaa kesiide, “Oona koyyiitee?” yaageedda ");
INSERT INTO dwrNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Unttunttu zaariide, “Naazireetiyaa Yesuusa koyyeetto” yaageeddino. Yesuusi zaariide, “Taani A” yaageedda. Yesuusa aathi immeedda Yihudaykka hewan unttunttunna eqqeedda; ");
INSERT INTO dwrNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuusi, “Taani A” geedda wode, unttunttu guyyekko shiiqiide, sa7an kunddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesuusi qassikka, “Oona koyyiitee?” Yaagi oochchina unttunttu, “Naazireetiyaa Yesuusa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesuusi zaariide, “Taani A gidiyaawaa hinttenttussi odaaddi; simmi hinttenttu Taana koyyiyaawaa gidooppe, hawantta yeddite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","I, “Ta Aabboo, neeni Taw immeeddawanttuppe haray atto, ittuwaakka bayizzabeykke” geeddawe polettana mala, hewaa geedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simooni Phexiroosaw mashshay de7ee; I he mashshaa shoddinne qeesatuwaa ubbatuwaa kaappuwaa qoomaa ushechcha haythaa shociide, qanxxi yeggeedda. He qoomaa sunthay Malkkoosa. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesuusi Phexiroosa, “Ne mashshaa shookuwan zaaraade wotha! Ta Aabbu Taw immeedda metuwaa xuu7aa Taani ushikkitaa?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Shaalaqay, daro wottaaddaratuunne qassi Geeshsha Golliyaa naagiyaawanttu Yesuusa oyqqiide qachcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Koyro Yesuusa Haannakko afeeddino; Haanni he laythi qeesatuwaa kaappatuwaa gideedda Qayaafaa bolluwa. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","“Asa ubbaa diraw, itti asay hayqqintto lo77a” giide Ayihudatuwaa zoreeddawe Qayaafaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simooni Phexiroosinne hara itti kaalliyawe Yesuusa kaalliide beeddino. He hara kaalliyaawaa qeesatuwaa kaappuu ereedda; hewe Yesuusanna qeesatuwaa kaappuwaa dirssaa garssa geleedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Shin Phexiroose karenna dirssaa penggiyan eqqeedda. Qeesatuwaa ubbatuwaa kaappuu eriyaa hara kaalliyaawe kare kesiide, penggiyaa naagiyaa naattiw odiide, Phexiroosa dirssaa garssa gelisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Penggiyaa naagiyaa naatta Phexiroosa, “Neeni ha bitaniyaa kaalliyawantuppe ittuwa gidikkiiyee?” yaagaaddu. I, “Tuytti, taani gidikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sa7ay meeggiyaa diraw, ayllatuunne Geeshsha Golliyaa naagiyaawanttu tamaa eexxiidde, bonqqeeddawaa yuuyyi aadhdhi eqqiide kashiino; Phexiroosikka unttunttunna eqqiide, he tamaa kashshee. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Qeesatuwaa ubbatuwaa Kaappuu, Yesuusa kaalliyaawanttubaane A timirttiyaabaa oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesuusi aw zaariide, “Taani asaa ubbaw qoncciyaan odaaddi. Taani Ayihuda ubbay shiiqiyaa Ayihuda woosa golleninne Geeshsha Golliyaan ubba wode tamaarissaaddi; geeman ayinne haasayabeykke. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yaatina, neeni Taana ayissi oochchay? Taani odeeddawaa siseedda asaa oochcha; he asay Taani odeeddawaa ereedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuusi hewaa geedda wode, hewaan eqqeedda wottaaddaratuwaappe ittuu Yesuusa baqqiide, “Qeesatuwaa ubbatuwaa kaappuwaa bolla hawaadan zaaray?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesuusi zaariide, “Taani balabaa haasayeeddawaa gidooppe, hawaan de7iya asaa ubbaw oda; shin Taani tumuwaa haasayeeddawaa gidooppe, Taana ayissi baqqay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hewaa diraw, Haanni, qashetti utteedda Yesuusa, qeesatuwaa ubbatuwaa kaappuwaa, Qayaafaakko yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Phexiroosi hewan eqqiide, tamaa kashshee; haranttu A, “Neeni ha bitaniyaa kaalliyaawanttuppe ittuwa gidikkiiyee?” yaageedda. Phexiroose, “Tuytti; taani gidikke” yaagiide kaddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Qeesatuwaa ubbatuwaa kaappuwaa qoomatuwaappe ittuwaa, Phexiroose haythaa qanxeedda bitaniyaa dabbu Phexiroosa, “Taani neena aananna daro ataakilttiyaa giddon be7abeykkitayee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Phexiroose qassikka kaddeedda; elekka kuttuu waassii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Unttunttu Yesuusa Qayaafaa golleppe Roome asaa ayissiyaawaa ooso golliya afeeddino. Sa7ay wontta guura; Ayihudatuu Paasigaa bonchchiya gallassa qumaa maanaw, barenttu huuphiyassi tunenna mala, Roome asaa ayissiyaawaa ooso golliya gelibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hewaa diraw, Philaaxoosi unttunttukko kare kesiide, “Ha bitaniyaa hinttenttu ayaani mootiitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Unttunttu, “I iitabaa oothibeennawaa gidintto, nuuni A neekko ahokko” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Philaaxoosi zaariide unttunttussi, “Hinttenttu A afiide, hinttenttu higgii giyawaaddan, A bolla pirddite” yaageedda. Ayihudatuu, “Oonanne wodhiyaa maatay nuussi baawa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hawe haneeddawe Yesuusi ay mala hayquwaa hayqqanentto erissanaw haasayeeddawe polettanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Philaaxoosi bare oosuwaa golle laa7ethuwa geliide, Yesuusa xeesiide, “Neeni Ayihuda katee?” yaagiide A oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesuusi Philaaxoosa, “Ha ooshaa neeni neeppe oochchayiye woy hara asay new tabaa odeeddee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Philaaxoosi zaariide, “Taana Ayihuda asa gay? Ne zaretuunne qeesatuwaa kaappatuu neena taw aathi immeeddino; neeni ayaa oothaddii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesuusi, “Ta kawutethay ha alamiyaana gidenna. Ta kawutethay ha alamiyaana gideeddentto, Taana Ayihudatoo aathi immennaadan, Taw oothiyaawanttu Taw olettana; shin Ta kawutethay ha almiyaana gidenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hewaa diraw, Philaaxoosi Yesuusa, “Yaatina, neeni kaateyee?” yaagiide oochcheedda. Yesuusi zaariide, “Neeni Taana kaatiyaa gaadda. Taani tumaa markkattana diraw yelettaaddi; qassi hewaa diraw, ha alamiyaa yaaddi. Tumuwaa bagga gideedda ooninne Taani giyaawa siseedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Philaaxoosi, “Tumuu ayee?” yaageedda. Philaaxoosi hewaa geeddawaappe guyyiyaan, Ayihudatuwaakko kare kesiide, “Taani aani ay balaanne demmabeykke. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Shin Paasigaa bonchchiya gallassi, itti asaa taani hinttenttussi qashuwaappe billiyaa dooyay de7ee; taani hinttenttussi Ayihudatu kaatiyaa billiyawaa koyyiitee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Unttunttu zaariide, barenttu kooshshaa dhoqqu udiide, “Barbbaana billappe attin, A gidenna!” yaageeddino. Shin Barbbaani paannuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hewaappe guyyiyan, Philaaxoosi Yesuusa oyqqiide, lissuwan shoceedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wottaaddaratuu agunthaappe akililiyaa giigissiide, A huuphiyaan wotheeddino; qassi zo7o mayuwaakka A mayizzeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Aakko shiiqiide, “Ayihuda kaatew, shemppuwaa gami77a!” yaagiide A shayyiyaa baqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Philaaxoosi qassikka kare kesiide Ayihudatuwaa, “Be7ite, taani aani ay balaanne demmabeennawaa hinttenttu erana mala, A hinttenttukko kare kessana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hewaappe guyyiyan, Yesuusi agunthaa akililiyaa bare huuphiyaan wothiide, zo7o mayuwaa mayyiide, kare kesseedda; Philaaxoosi Ayihudatuwaa, “Bitaniyaa hawaa be7ite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Qeesatuwaa kaappatuunne wottaaddaratuu A be7eedda wode, barenttu kooshshaa dhoqqu udiide, “Masqqaliyaa bolla misimaariyan dhishaade A sulla! Sulla!” yaageeddino. Philaaxoosi unttuntta, “Hinttenttu A afiide, masqqaliyaa bolla misimaariyan dhishiide sullite; ayissi gooppe, taani ay balaanne demmabeykke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayihudatuu zaariide, “Nuussi higgii de7ee; nu higgii giyawaaddan, I hayqqanaw bessee; ayissi gooppe, I barena Xoossaa Na7aa ootheedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Philaaxoosi hewaa siseedda wode, kasewaappe loythi yayyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Qassikka Philaaxoosi bare oosuwaa golle simmi geliide Yesuusa, “Neeni haqappe yaaddii?” yaagiide oochcheedda; shin Yesuusi aw aynne zaaribeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hewaa diraw, Philaaxoosi A, “Taw odikkii? Neena billanaw woy masqqaliyaa bolla misimaariyan dhishaade kaqqanaw taw maatay de7iyaawaa erikkiiyee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesuusi, “Xoossay new bollappe maataa immibeennabaa gidintto, new Ta bolla maatay de7enna shin. Hewaa diraw, Taana new aathi immeeddawe aadhdhiyaa nagaraa ootheedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Philaaxoosi hewaa siseedda wode, Yesuusa billanaw ogiyaa koyyeedda; shin Ayihudatuu barenttu kooshshaa dhoqqu udiide, “Neeni A billiyawaa gidooppe, Kaatiyaa Qeessaare dabbo gidakka! Barena kaatiyaa giya ooninne Qeessaare morkke!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Philaaxoosi hewaa sisiide, Yesuusa kare kesseedda. Yaatiide shuchchaa baasuwaa giya sa7an pirdda oydiyaan utteedda; Ibraayisxxe qaalaan he sa7ay gaytaa giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","He gallassay Paasigaa bonchchiyaa gallassaw giigissiyaa gallassaa; sa7ay usuppun saatiyaa heera gidanawa. Philaaxoosi Ayihudatuwaa, “Hinttenttu kaatiyaa hawaa be7ite!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ayihudatuu barenttu kooshshaa dhoqqu udiide, “Digga! Digga! Masqqaliyaa bolla misimaariyan dhishaade sulla!” yaageeddino. Philaaxoosi zaariide, “Hinttenttu kaatiyaa taani masqqaliyaa bolla misimaariyan dhishaade sulliyaawaa koyyiitee?” yaagiide oochcheedda. Qeesatuwaa kaappatuu, “Qeessaareppe hara kaatii nuussi baawa!” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hewaappe guyyiyan, unttunttu masqqaliyaa bolla misimaariyan dhishiide, Yesuusa kaqqana mala, Philaaxoosi unttunttussi aathi immeedda. Unttunttu Yesuusa oyqqiide, afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesuusi bare masqqaliyaa tookkiide, Guuggiyaasaa geetettiyaasaa beedda. “Guuggiyaasaa” giyaawe Ibraayisxxe qaalaan “Golgotha” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Unttunttu he sa7an masqqaliyaa bolla misimaariyan dhishiide, Yesuusa kaqqeeddino; qassi aananna hara laa77u asatuu, ittuwa ya bagganna qassi ittuwa ha bagganna Yesuusa gidduwan wothiide, masqqaliyaa bolla misimaariyan dhishiide kaqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Philaaxoosi xifatiyaa xaafiide, masqqaliyaa bolla wotheedda. I xaafeeddawe, “Ayihudatu Kaatiyaa, Naazireetiyaa Yesuusa” yaagee. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesuusi masqqaliyaa bolla misimaariyan dhishettiide suletteedda sa7ay katamaa matan de7iya diraw, daro Ayihudatuu he xifatiyaa nabbabeeddino. Xifatii Ibraayisxxe qaalaan, Roomaysxxe qaalaaninne Giriike qaalaan xaafetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Hewaa diraw, Ayihuda qeesatuwaa kaappatuu Philaaxoosa, “ ‘Ha bitani barena Ayihuda kaatiyaa yaageedda’ gaade xaafappe attin, ‘Ayihuda kaatiyaa’ gaade xaafoppa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Philaaxoosi, “Taani xaafeeddawaa xaafa diggaaddi” yaagiide zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wottaaddaratuu masqqaliyaa bolla misimaariyan dhishiide, Yesuusa kaqqeeddawaappe guyyiyan, A mayuwaa akkiide, oyddu kessi shaakkeeddino; itti itti wottaaddaraa itti shaakuu gakkeedda. A adussa mayuwaakka akkeeddino; adussa mayuu hashiyaappe doommiide, duge gakkanaw yeddi mayettiyaawaappe attin, qanxxettiide sikettibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wottaaddaratuu ittu ittuwaa, “Oona gakkanentto, saamaa woy exaa yegganaappe attin, mayuwaa peedhokko” yaageeddino. Hewe haneeddawe Xoossaa Maxaafay, “Ta mayuwaa shaakki akkeeddino; ta adussa mayuwaan saamaa yeggeeddino” giyaawe polettanaassa. Hewaa diraw, wottaaddaratuu hewaa ootheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Shin Yesuusa masqqaliyaa matan A daaya, A aatti michchatta, Qaliyoophaa machchatta Mayraamanne Magdala geetettiyaa katamaappe yeedda Mayraama eqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesuusi bare daayanne I siiqiyaa kaalliyaawe hewan eqqeeddaawantta be7iide, bare daayo, “Ha mishirattee, ne na7aa hawaa be7a!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hewaappe guyyiyan, he kaalliyaawaa “Ne daayo hanno be7a!” yaageedda. He kaalliyaawe izo he saatiyaappe doommiide, bare soy afeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hewaappe guyyiyan, Yesuusi ubbabay ha77i poletteeddawaa eriide, Xoossaa Maxaafay geeddawe polettana mala, “Taana saammee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","He sa7an itti xuggaa kumeedda caala woyiniyaa eessay de7ee. Unttunttu ispponjjiyaa he woyiniyaa eessaan yeggiide, hisoophiyaa geetettiyaa mithaa xeeraan wothiide, Yesuusa doonaakko shiishsheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesuusi woyiniyaa eessaa ganxxi be7eeddawaappe guyyiyan, “Poletteedda” yaageedda. Qassi hewaappe guyyiyan, bare huuphiya toochchiide, bare shemppuwaa immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","He gallassay Ayihudatuwaassi giigettiyaa gallassaa gidiyaa dirawunne qassi he Sambbatay daro bonchcho gidiyaa diraw, Sambbataan asatuwa anhay masqqaliyaa bolla peeshenna mala, suletteedda asatuwa suyiliyaa menthiide, masqqaliyaappe wothana mala, Ayihudatuu Philaaxoosa woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hewaa diraw, wottaaddaratuu yiide, Yesuusanna suletteedda koyro bitaniyaa suyiliyaa mentheeddino; qassi aananna suleteedda laa7etho bitaniyaa suyiliyaakka mentheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Shin Yesuusakko yeedda wode I hayqqidiggeeddawaa be7iide, A suyiliyaa menthibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Gidoopenne, wottaaddaratuwaappe ittuu A miyyiyaa tooraan caddeedda. Elekka suuthaynne haathay goggi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Hinttenttu ammanana mala, hawaa be7eeddawe markkatteedda; I markkattiyaawekka tumuwaa; qassi bare haasayay tuma gidiyaawaa I ereedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Hewe haneeddawe Xoossaa Maxaafay, “A meqethatuwaappe ittunne me77enna” geeddawe polettanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Qassikka Xoossaa Maxaafay haray, “Asay bare caddeeddawaa be7ana” yaagee. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hewaappe guyyiyan, Armmaatiyaasa geetettiyaa katamaappe yeedda Yooseefo Yesuusa anhaa akkiide afanaw Philaaxoosa woosseedda; Yooseefo Ayihudatoo yayyeedda diraw, asay erennaan Yesuusa kaalliyaawaa. Yooseefo woossina Philaaxoosi, “Afa” yaageedda. Hewaa diraw, Yooseefo biide, Yesuusa anhaa afeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Qassi Niqoodimoosi hewaappe kase Yesuusakko qamma yeeddawe, kawaraannanne godare uuthaanna walaketteedda oytamanne ichcheshu kiilo giraame gidiyaawaa keena shittuwaa oyqqi akkiide, Yooseefonna yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","He laa77u asatu Yesuusa anhaa akkiide, Ayihudatuu anhaa xaaxiyaa wogaadan, shittuwaanna gathiide, mooguwaa afilaan xaaxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesuusi masqqaliyaa bolla misimaariyan dhishettiide suletteedda sa7an daro atikilttiyaa sa7ay de7ee; he atikilttiyaa sa7aa giddon shuchchaa wooci kesseedda biro ooninne moogettibeenna ooratha duufuu de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","He duufuu matan de7iya dirawunne qassi Ayihudatuu Sambbataw giigettiyaa gallassa gidiyaa diraw, Yesuusa yaani wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Woggaa gallassi guuran, biro daabidaabiyaawaan, Magdala geetettiyaa katamaappe yeedda Mayraama Yesuusi moogetteedda duufuwaakko baade shuchchay he gonggoluwaa doonaappe denddikichcheeddawaa be7aaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Simooni Phexiroosakkonne Yesuusi siiqiyaa yokko kaalliyaawaakko, iza woxxaadde baade, “Duufuwaappe Godaa afidiggeeddino; haqan A wotheeddinonttonne nuuni erokko” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hewaa diraw, Phexiroosinne yokko kaalliyaawe aggiide, duufuwaakko beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Laa77uukka ittippe woxxeeddino; shin yokko kaalliyaawe Phexiroosappe aadhdhi kasetiide, he duufuwaakko gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","He kaalliyaawe hokkiide, mooguwaa afilaa be7eedda; shin giddo gelibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simooni Phexiroose A kaalli yiide, duufuwaa giddo geleedda. Yaatiide mooguwaa afilay hewan de7iyaawaa be7eedda; ");
INSERT INTO dwrNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","qassi Yesuusa huuphiyaan xaaxetti utteedda afilay he xaaxetteeddawaadankka dumma itti sa7an de7iyaawaa be7eedda; he afilay dumma de7eeppe attin, mooguwaa afilaanna ittippe de7enna. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","He wode, kasetiide gonggoluwaakko gakkeedda yokko kaalliyaawe geli be7iide ammaneedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yesuusi hayquwaappe denddanaw bessiyaawaa odiyaa Xoossaa maxaafaa unttunttu biro akeekibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hewaappe guyyiyan, kaalliyaawanttu barenttu golle simmiide beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Shin Mayraama he duufuwaa doonan eqqaade yeekkaadde hokkaade duufuwaa giddo xeellaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bootha mayuwaa mayyeedda laa77u kiitanchchatuu Yesuusa anhay giseedda sa7an ittu huuphissanna ittuu gedissanna utteeddawaantta be7aaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Unttunttu izo, “Mishirattee, ayissi yeekkay?” yaagiide oochcheeddino. Iza, “Asatu ta Godaa afidiggeeddino; unttunttu haqqan wotheeddinonttonne taani erikke” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hewaa geeddawaappe guyyiyan, guyye simma xeellaade, Yesuusi eqqeedawaa be77aaddu. Shin I Yesuusa gideeddawaa akeekabeykku. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesuusi izo, “Mishirattee, ayissi yeekkay? Oona koyyay?” yaagiide oochcheedda. Mayraama atikkilttiyaa naagiyaawaa gaade, “Godaw, neeni akkeeddawaa gidooppe, A haqan wothaaddintto, taw odaarikki; taani A akkana” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesuusi izo, “Mayraamee” yaageedda. A aakko simmaade, Ibraayisxxe qaalaan “Rabunii” yaagaaddu; hewaa bilethay “Tamaarissiyaawoo” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuusi izo, “Taani biro Ta Aawuwaakko babeenna diraw, Taana bochchoppa; shin Ta ishatuwaakko baade, ‘Taani Ta Aawuwaakkonne hinttenttu Aawuwaakko, Ta Xoossaakkonne hinttenttu Xoossaakko, pude bay geedda’ gaade unttunttussi oda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magdala geetettiyaa katamaappe yeedda Mayraama Godaa be7eeddawaanne iziw I hewaa odeeddawaa baade kaalliyaawanttussi odaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","He Woggaa gallassi omarssi, kaalliyaawanttu Ayihudatuw yayyeedda diraw, penggiyaa gorddiidde, shiiqi utti de7ishshin, Yesuusi yiide, unttunttu gidduwan eqqiide, “Sarotethay hinttenttussi gido” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hewaa geeddawaappe guyyiyan, bare kushiyaanne bare miyyiyaa unttuntta besseedda; kaalliyaawanttu Godaa be7eedda wode loythi nashetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuusi laa7enthuwa unttunttussi, “Sarotethay hinttenttussi gido; Ta Aabbu Taana kiitteeddawaadan, Taanikka hinttentta kiittay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hewaa geeddawaappe guyyiyan, unttunttu bolla uffu giide shemppeedda; qassi, “Geeshsha Ayyaanaa akkite. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hinttenttu atto geedda asaa nagaray atto geetettanawaa; hinttenttu atto geennaawanttu nagaray atto geetettenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Shin tammanne laa77u kaalliyaawanttuppe ittuu, Manttiyaa giyaa Toomaasi, Yesuusi yeedda wode unttunttunna baawa. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hewaa diraw, yokko kaalliyaawanttu Toomaasaw, “Nuuni Godaa be7eeddo!” yaageeddino. Shin Toomaasi unttunttussi, “Misimaariyan I cadetteedda A kushiyan de7iya mallaa be7ennaaninne he mallaa ta biradhdhiyan bochchennan, qassi ta kushiyaa A miyyiyaan yeedda be7ennaan taani ammanikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Saaminttaappe guyyiyan, Yesuusa kaalliyaawanttu qassikka gollen shiiqi utteeddino; Toomaasikka unttunttunna de7ee. Penggi qashetti utti de7ishshin, Yesuusi yiide, unttunttu gidduwaan eqqiide, “Sarotethay hinttenttussi gido” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hewaappe guyyiyan, Yesuusi Toomaasa, “Ne kushiyaa haa ahaade, Ta kushiyaa be7a, qassi ne kushiyaa haa ahaadde, Ta miyyiyaan yeedda be7a, neeni ammaniyaawaa gidappe attin, ammanennawaa gidoppa!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomaasi zaariide, “Ta Godaw, ta Xoossaw!” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesuusi, “Neeni Taana be7eedda diraw ammanaadda; be7ennaan ammaneeddawanttu anjjetteeddawantta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuusi ha maxaafan xaafettibeenna hara daro malaatatuwaa barena kaalliyaawanttu sinthan ootheedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Shin Yesuusi, I Kiristtoosa, Xoossaa Na7aa gidiyaawaa hinttenttu ammanana malanne, qassi A ammaniide A sunthan de7uwaa hinttenttu demmana mala, hawe xaafetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hewaappe guyyiyan, Yesuusi Xibiriyaadoosa geetettiyaa abbaa gaxaan bare kaalliyaawanttussi laa7enthuwaa beetteedda. I unttunttussi hawaadan beetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simooni Phexiroosinne manttiyaa geetettiyaa Toomaasi, Qaanaa Galiilaappe yeedda Naatinaa7eeli, Zabiddiyoosa naanaynne Yesuusa kaalliyaawanttuppe hara laa77atuu ittippe de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simooni Phexiroose unttunttussi, “Taani moliyaa oyqqanaw bay” yaageedda. Unttunttu, “Nuunikka neenanna baana” yaagiide, kesiide wongiriyaa giddo geleeddino; shin unttunttu he gallassi qamma moliyaa aynne oyqqibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wonttiyaa wode away kessanaappe kase, Yesuusi abbaa gaxaan eqqeedda; shin A kaalliyaawanttu Yesuusa gideeddawaa eribeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesuusi unttuntta, “Naatoo, moliyaa oyqqibeykkiteyee?” yaageedda. Unttunttu zaariide, “Aynne oyqqibeykko” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","I zaariide, “Hinttenttu dabbaa wonggiriyaappe ushechcha baggakko yeggite; amareeddawa hinttenttu oyqqana” yaageedda. Hewaa diraw, dabbaa ushechcha baggakko yeggina, molii dareedda diraw, goochchi kessanawe unttuntta xooneedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesuusi siiqiyaa A kaalliyaawe Phexiroosa, “Hawe Godaattennee!” yaageedda. Simooni Phexiroose Godaa I gideeddawaa siseedda wode, kallo de7iya diraw, bare mayuwaa mayyiide, abbaa giddo guppi geleedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Shin yokko kaalliyaawanttu molii kumi utteedda dabbaa goochchiidde, wonggiriyan abbaappe gaxaa kesseeddino; unttunttu abbaappe laa77u xeetu wadhaa keenaa haakkiide de7iinoppe attin, loythi haakkiide de7ikkino. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Unttunttu abbaappe gaxaa kesseedda wode, xiixuntha bonqquwan molii de7iyaawaanne ukithaa be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuusi unttuntta, “Ha77i hinttenttu oyqqeedda moliyaappe amareeddawaa haammite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simooni Phexiroose wonggiriyan geliide, xeetanne ishatamanne heezzu wogga moletuu kumi utteedda dabbaa goochchiide, abbaappe gaxaa kesseedda; molii hewaa keena daro gidinakka dabbay daakettibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuusi unttuntta, “Ha yiide, qan77iyaa qan77ite” yaageedda. Yesuusa kaalliyawanttuppe ittunne, “Neeni oonee?” giide A oochchanaw xalibeenna; ayissi gooppe, Godaa I gideeddawaa unttunttu ereeddino. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesuusi yiide, ukithaa akkiide, unttunttussi immeedda; moliyaakka hewaadan immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuusi hayquwaappe denddeeddawaappe guyyiyan, bare kaalliyaawanttussi beettishshin hawe heezzenthuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Unttunttu qumaa meeddawaappe guyyiyan, Yesuusi Simooni Phexiroosa, “Yohaannisa na7aa Simoonaa, Taana hawanttuppe aathaade siiqay?” yaageedda. Simooni Phexiroose, “E Godaw, taani neena dosiyaawaa neeni eraasa” yaageedda. Yesuusi A, “Ta dorssa maratuwaa heemma” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesuusi qassikka, “Yohaannisa na7aa Simoonaa, Taana siiqay?” yaageedda. Simooni Phexiroose, “E Godaw, taani neena dosiyaawaa neeni eraasa” yaageedda. Yesuusi, “Ta dorssatuwaa heemma” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesuusi heezzenthuwaa, “Yohaannisa na7aa Simoonaa, Taana dosay?” yaageedda. Yesuusi heezzenthuwaa Simooni Phexiroosa, “Taana dosay?” yaagiide oochcheedda diraw, Phexiroose azzaniide, “Godaw, neeni ubbabaa eraasa; taani neena dosiyaawaa neeni eraasa” yaageedda. Yesuusi, “Ta dorssatuwaa heemma. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Taani new tumuwaa oday; neeni wodallatethaan de7iya wode, ne xeessan saqqiyaa neerekka danccaadde, neeni koyyeeddasaa baasa. Shin cimeeddawaappe guyyiyan, ne kushiyaa micca bessaasa. Neena hara uray dancissanawaa; neeni dosennasaakka afee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuusi hewaa Phexiroose ay mala hayquwaa hayqqiide, Xoossaa bonchchissanenttonne erissanaw geedda; qassi hewaa geeddawaappe guyyiyan, Yesuusi Phexiroosa, “Taana kaalla” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phexiroose guyye simmiide, Yesuusi siiqiyaa kaalliyaawe bareppe guyyenna yiyaawaa be7eedda; he kaalliyaawe kawuwaa miyaa sa7an Yesuusakko shiiqiide A, “Godaw, neena aathi immanawe oonee?” yaageeddawaa. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Phexiroose he kaalliyaawaa be7iide Yesuusa, “Godaw, ha bitani qassi waananee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesuusi A, “Taani yaana gakkanaw I de7ana mala Taani koyyooppe, hewe neena ayaa metii? Neeni Taana kaalla” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hewaa diraw, he kaalliyaawe hayqqenna giya haasayay ishatuwaa ubbaakko gakkeedda; shin Yesuusi, “Taani yaana gakkanaw, I de7ana mala, Taani koyyooppe, neena ayaa metii?” geeddawaappe attin, “Hayqqenna” gibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","He yewuwaabaa markkatteeddawenne qassi hewaa xaafeeddawe he kaalliyaawaa A markkatethay tuma gidiyaawaa nuuni ereetto. ");
INSERT INTO dwrNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuusi ootheedda hara darobaykka de7ee; ubbabay huuphiyaan huuphiyaan xaafettintto, xaafettiyaa maxaafatoo ha mule alamii gidanawaa taw malatenna.");
INSERT INTO dwrNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Toofiloosaa, Yesuusi saluwaa beedda gallassay gakkanaw, oothanawunne tamaarissanaw doommeeddawaa ubbabaa taani ta koyro maxaafaan xaafaaddi. Saluwaa baanaappe kase I bare dooriide kiitteeddawantta Geeshsha Ayyaanaan azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","I bare kiitteeddawanttoo oytamu gallassaa beettiiddinne qassi Xoossaa kawutethaabaa unttunttoo odiidde, bare waayyiyaappe guyyiyan, hayquwaappe denddeeddawaa sidhe baynnaan loythi ammanthiide, barena unttuntta besseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Unttunttunna ittippe de7iidde, unttuntta hawaadan yaagiide azazeedda; “Yeerusalaameppe kesoppite; shin hinttenttu Taappe siseedda Ta Aabbu hinttenttoo immana giide hidooteeddawaa naagite. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ayissi gooppe, Yohaannisi haathaan xammaqeedda; shin guutha wodiyaappe guyyiyan, Geeshsha Ayyaanaan hinttenttu xammaqettanita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesuusi kiitteeddawanttu Yesuusanna gaketteedda wode A, “Godaw, ha wodiyaan Israa7eelatuwassi kawutethaa zaaranii?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesuusi unttuntta, “Ta Aabbu bare godatethaan keereedda agenaanne wodiyaa hinttenttu eranaassa gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Shin Geeshsha Ayyaanay hinttenttu bolla wodhdhiyaa wode, wolqqaa hinttenttu akkanita; yaatiide Yeerusalaameninne Yihudaa gadiyaa ubbaan, Sammaariyaaninne gadiyaa gaxaa ubbaa gakkanaw Taw markkattiyaawantta gidanita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hewaa geeddawaappe guyyiyan, unttunttu xeellishshin, dhoqqu dhoqqu giidde, saluwaa biina, unttunttu ayfiyaappe shaarii A gentheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesuusi bollaw denddiyaa wode, unttunttu saluwaa caddi xeellishshin, bootha mayuwaa mayyeedda laa77u asatuu ellekka unttunttu matan eqqiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galiilaa asatoo, saluwaa xeelliidde, hinttenttu ayissi eqqeedditee? Ha hinttenttuppe saluwaa beedda Yesuusi saluwaa biyaawaa hinttenttu be7eeddawaadankka, simmiide yaanawaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hewaappe guyyiyan, Yesuusi kiitteeddawanttu Debre Zayte geetettiyaa Wogaraa mithaa deriyaappe Yeerusalaame simmeeddino. Wogaraa mithaa derii Yeerusalaameppe itti kiilo mitiriyaa keena. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yesuusi kiitteeddawanttu Yeerusalaame geliide, barenttu de7iyaa sa7aa dhoqqaa pude keseeddino; yaa keseeddawanttu sunthay Phexiroosa, Yohaannisa, Yayiqooba, Inddiraasa, Piliphphoosa, Toomaasa, Barttalamoosa, Maatoossa, Ilppiyoosa na7aa Yayiqooba, bare gadiyaassi seelettiyaa Simoonanne Yayiqooba na7aa Yihudaa. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Hawanttu ubbatuu maccawanttunna, Yesuusa dayi Mayraamminnanne Yesuusa ishatuwaanna ubbay itti wozanaa gidiide, ubba wode ittippetethaan woossaw shiiqiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","He wode, Phexiroosi xeetanne laatama gidiyaa ammaniyaa asaa shiiquwaan ittippe de7iyaa bare ishatuwaa giddon denddi eqqiide, hawaadan yaageedda; ");
INSERT INTO dwrNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Taanaadan ammaniyaawanttoo, Yesuusa oyqqeeddawantta kaaletheedda Yihudaabaa Geeshsha Ayyaanay kase Daawite doonaan odeedda Xoossaa maxaafaa qaalay polettanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ayissi gooppe, Yihudaa Asqqorootu nuunanna de7ee; qassi nuunanna ittuwaa gidi paydettiide oosuwaa baggay de7ana mala dooretteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yihudaa Asqqorootu bare iita oosuwan demmeedda miishshaan gadiyaa shammeedda; sinthaw guufanniide kunddina, A uluu gidduwaappe daaketteedda; A maraccii ubbaykka karew phulxxetti kesi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yihudaa bolla haneeddawaa Yeerusalaamen de7iyaa asay ubbay siseedda; hewaa diraw, he gadiyaa barenttu qaalaan Akelddaamaa giide suntheeddino; hewaa bilethay suuthaa gadiyaa giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Phexiroosi odiidde, “Ayissi gooppe, Mazimuriyaa Maxaafaan, ‘A golli mela atto; ooninne hewaan de7oppo’ qassi ‘A sunthatethaakka haray akko’ geetettiide xaafetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Hewaa diraw, itti asay Godaa Yesuusa dendduwaa markkattanaw, nuunanna gakettanaw bessee; Yohaannisi xammaqeedda wodiyaappe doommiide, Yesuusi nuuppe saluwaa beedda wodii gakkanaassi, Godaa Yesuusi nuunanna hametteedda wodiyaa ubbaan I nuunanna de7iyaawanttuppe ittuwaa gidi sunthettanaw bessee.” ");
INSERT INTO dwrNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hewaappe guyye ammaniyaa asay dooruwaassi Yosxxoosa giyaa Barssaabaa geetettiyaa Yooseefanne Maatiyaasa laa77uwaa esseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Hewaappe guyyiyan, Xoossaa woossiidde, “Ubbaa wozanaa eriyaa Godaw, Yihudaa Asqqorootu baresaa baanaw yeggiide beedda oosuwaanne Yesuusi kiitteedda oosuwaa hadaraa akkanaadan, ha laa77u asatuwaappe ittuwaa neeni dooreeddawaa nuuna bessa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Unttunttun saamaa yeggeeddino; saamay Maatiyaasa bollan wodhdhina, Maatiyaasi Yesuusi kiitteedda tammanne itti kiitettawanttunna paydetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Phenxxeqostte giyaa gallassay gakkeedda wode, ammaniyaawanttu ubbatuu ittippe gidiide, ittisaa shiiqi de7ishshin, ");
INSERT INTO dwrNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","wolqqaama gotuwaadan guummiyaa gunthay wozanaa aathennaan saluwaappe yiide, unttunttu utteedda golliyaa ubbaa kumeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Qassi tamaa lacuwaadan poddugiyaawe unttunttoo beettiide, shaaketti shaaketti, unttunttu ubbaa bolla wodhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Unttunttu ubbaan Geeshsha Ayyaanay kumiide, dumma dumma qaalaan haasayana mala, unttuntta danddayissina, haasayaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sa7aan de7iyaa asaa zerethaa ubbaappe yiide, Xoossaw yayyiyaa ittippe de7iyaa Ayihudatuu Yeerusalaamen de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ha gunthaa siseedda wode, asay ubbay shiiqeedda; unttunttu barenttu qaalaan qaalaan haasayishshin siseedda diraw, giyaawaa dhayeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Asay ubbay maalalettiiddenne hawe oorathabaa giidde, “Be7ite; ha haasayiyaawanttu ubbatuu Galiilaa asatuwaa gidikkinoo? ");
INSERT INTO dwrNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yaatina, nuuni nu yeletteedda gade qaalaan unttunttu haasayishshin waaniide siseettoo? ");
INSERT INTO dwrNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nuuni Phartte asatuu, Meedoone asatuu, Elaameexe asatuu, laa77u shaafatuwaappe gidduwan de7iyaawanttu, Yihudaan, Qaphphadooqiyan, Phanxxoossan, Iisiyan, ");
INSERT INTO dwrNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Pirggiyan, Phinifiliyan, Gibxen, Qereena baggan de7iyaa Liibiyaa woradatuwan de7iyaawanttu, Roomeppe yeedda immathatuu, Ayihudatuu, Ayihudatethaw laametteedda nuuppe amareeddawanttu, Qarixxeese asatuunne, Arabiyaa asatuu, Xoossay ootheedda wolqqaama oosuwaa nu qaalaan unttunttu haasayishshin siseeddo” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ubbaykka maalalettiide, yewuu barenttoo gelennaan ixxina barenttu giddon, “Laa hawe waagiyaawee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Shin hara asatuu ammaniyaawanttu bollan Qilliicciidde, “Hawanttu ushiide mathotteeddino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Shin Phexiroosi, Yesuusi kiitteedda hara tammanne itti kiitettowanttunna denddi eqqiide, bare kooshshaa dhoqqu oothiide, unttunttoo hawaadan yaagi odeedda; “Ayihudatoo, qassi Yeerusalaamen de7iyaa ubbatoo, taani odiyaawaa sisite. Hawe hinttenttoo eretto; hinttenttu qoppiyaawaadan, hawanttu mathottibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ayissi gooppe, wonttaappe biro heezzu saate gidee. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Shin hawe Nabiyaa Iyu7eel haasayeeddawaa. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“I haasayiidde, ‘Xoossay hawaadan yaageedda; wodiyaa wurssethaan hawaadan hananawaa. Taani asaa ubbaa bollan ta Ayyaanaa gussana. Hinttenttu attuma naanaynne hinttenttu macca naanay timbbitiyaa odanawantta. Hinttenttu wodalla naanaykka saxaa be7anawantta; hinttenttu cimatuukka akumuwaa akumettanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","He gallassatun ta attuma qoomatuwaa bollaninne ta macca ashikkaratuwaa bollan Taani Ta Ayyaanaa gussana. Hewaappe guyye unttunttu timbbitiyaa odanawantta. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Qassi Taani bolla saluwan oorathabaa, garssa sa7ankka malaataa bessana. Suuthay, tamaynne shaariyaadan kammeedda cuway de7ana. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wolqqaamanne bonchcho gideedda Godaa gallassay gakkanaappe kase away dhumaana; agenaykka suuthaa malatana. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","He wode hawaadan hananawaa; Godaa sunthaa xeesiyaa ooninne attana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israa7eeliyaa asatoo, ha qaalaa sisite; Naazireetiyaa Yesuusi hinttenttu giddon Xoossay barenan ootheedda wolqqaama oosuwan, oorathabaaninne malaatan hinttenttoo dhiishisseedda asa; hewaa hinttenttukka eriita. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesuusi hinttenttoo imettana mala, Xoossay kase bare sheniyaaninne bare eraan bare qofaa qachchi wotheedda; yaatina, A hinttenttu nagaranchchatuwaa kushiyan masqqaliyaa bolla misimaariyan dhishissiide, kaqissi wodhisseeddita. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Shin hayquu Yesuusa oyqqanaw danddayibeenna diraw, Xoossay hayquwaa seelaa aappe dhayissiide, A dentheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ayissi gooppe, Daawite Yesuusabaa hawaadan yaageedda; ‘Taani metootennaadan, Goday ta ushechchaan de7iyaa diraw, taani ubba wode Godaa ta matan be7ay. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hewaa diraw, ta wozanay nashetteedda; ta inxxarssankka nashechchay kumeedda. Qassi ta bollaykka lo77o de7ana giide, nashechchaan naagee. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ayissi gooppe, ta shemppuwaa Si7ooliyan aggakka. Qassi ne Geeshsha Na7aa anhaakka wooqethakka. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Neeni taana de7uwaa ogiyaa erssaadda. Neeni taananna de7iyaawaan taani darii nashettay’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ishatoo, nu aawatuwa kaappuwaa Daawitebaa taani hinttenttoo geeshshaade odanaw bessee; Daawite hayqqiide moogetteedda; A duufuu hachche gakkanawukka nu matan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daawite Nabiyaa gideedda dirawunne Xoossay A naanaa zerethaappe ittuwaa A kawutethaa oydiyaan utissanaw aw caaqqeeddawaa ereedda diraw, ");
INSERT INTO dwrNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kiristtoosa dendduwaa sinthaw xeelliide, ‘A shemppuu Si7ooliyan attibeenna; A bollaykka wooqqibeenna’ giide odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Xoossay Yesuusa hayquwaappe dentheeddawaassi nuuni ubbay markka. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hewaa diraw, Xoossay bareppe ushechcha baggan A dhoqqu dhoqqu udiide, aw Geeshsha Ayyaanaa immana geeddawaadan, Geeshsha Ayyaanaa akkiide, hawaa hinttenttu ha77i be7iyaawaanne sisiyaawaa nu bolla gusseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Ayissi gooppe, Daawite bare huuphew saluwaa kesibeenna; shin yaageedda; ‘Goday ta Godaa; “Taani ne morkketuwaa neeni gediyaan yedhdha eqqiyaawaa oothana gakkanaw hawaan taappe ushechcha bagganna utta” geedda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Hewaa diraw, Xoossay masqqaliyaa bolla misimaariyan ha hinttenttu dhishiide kaqqeedda Yesuusa Godanne Kiristtoosa ootheeddawaa Israa7eeliyaa asaa zerethay ubbay tumuppe ero” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Asay Phexiroosi geeddawaa siseedda wode, asaw wozanay daroppe boshettina, Phexiroosanne Yesuusi kiitteedda haratuwaa, “Nu ishatoo, yaatina nuuni ayaa udanee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phexiroosi unttuntta, “Hinttenttu nagaray atto geetettana mala, nagaraappe simmiide, hinttenttu huuphiyan huuphiyan Yesuusi Kiristtoosa sunthan xammaqettite. Xoossay immiyaa Geeshsha Ayyaanaa hinttenttu akkana. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ayissi gooppe, Xoossay immana geedda qaalay hinttenttussa, hinttenttu naanatuwassanne Goday nu Xoossay barekko xeesiyaa haakuwaan de7iyaawanttu ubbaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Phexiroosi unttunttoo qaalaa haraakka gujji markkattiide, “Ha wodiyaa geella asaappe hinttenttu huuphiyaa ashshite” yaagiide zoreedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Phexiroosi odeeddawaa akkeeddawanttu xammaqetteeddino; he gallassi heezzu sha77a gidiyaa asay ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Unttunttu Yesuusi kiitteeddawanttu timirttiyaan, ittippetethaan ukithaa menthi miyaawaaninne Xoossaa woosan gencciino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yesuusi kiitteeddawanttu kushiyan daro oorathabaynne malaatatuu oosettina, asaa ubbaa yashshay oyqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ammaneedda ubbatuu ittippe de7iino; qassi barenttoo de7iyaabaa ubbaakka ittippe shaakki akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Unttunttu barenttu gadiyaanne barenttoo de7iyaabaa zali77i zali77iide, oonanne koshsheedda keena miishshaa ubbaw shaakkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Qassi ubba gallassi, itti wozanaa gidiide, Geeshsha Golliyaan paccennaan gakettiide, barenttu golle golle xeesettiide nashechchaaninne pashikka wozanaan qumaa miino. ");
INSERT INTO dwrNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xoossaa galatiidde, asaa ubbaan sabetteeddino. Qassi Goday ammani attiyaawantta gallassi gallassikka unttunttu bolla gujjee. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Itti gallassi, Phexiroossinne Yohaannisi Xoossaa woossanaw udduppu saatiyaan Geeshsha Golliyaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yelettoodeppe doommiide, gundda gidiide de7iyaa itti bitani Geeshsha Golliyaa geliyaa asaappe miishshaa woossanaw, ubba gallassi darii lo77a giyaa Geeshsha Golliyaa penggiyan asay afiide wothiyaawe de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","He wobba bitani, Phexiroossinne Yohaannisi Geeshsha Golliyaa gelana hanishshin be7iide, miishshaa unttuntta woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Phexiroosi Yohaannisanna A caddi xeelliide, “Nuukko haa xeella” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wobba bitani unttunttuppe ittibaa akkanaw koyyiide, unttunttukko xeelleedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Shin Phexiroosi A, “Taw miishshay baawa; shin taw de7iyaabaa taani new immana; Naazireetiyaa Yesuusi Kiristtoosa sunthan denddaade hametta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yaatiide, wobba bitaniyaa bare ushechcha kushiyan oyqqiide, pude dentheedda; ellekka A gediinne meeshi meqethay minnii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Bitani pude guppiide, denddi eqqeedda; yaanne haanne hametaa doommeedda. Hewaappe guyyiyan hamettiidde, guppiiddinne Xoossaa galatiidde, unttunttunna ittippe Geeshsha Golliyaa geleedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","I hamettishshiinanne Xoossaa galatishshin, asay ubbay A be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Yaatiide, miishshaa woossanaw darii lo77a giyaa Geeshsha Golliyaa penggiyaan utteeddawe A gideeddawaa akeekeeddino; I haneeddawaa be7iide maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bitani Phexiroosanne Yohaannisa oyqqi utteedda wode, asay ubbay maalalettiide, Solomone baranddaa giyaasan ittippe unttunttukko woxxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Phexiroosi asaa be7eedda wode unttunttoo yaageedda; “Israa7eeliyaa asatoo, ayissi hawoo maalalettiitee? Woy ayissi nuuna caddi xeelliitee? Nuuni nu wolqqaan woy Xoossaa malatiyaawaan ha bitaniyaa hametheeddawaa hinttenttoo malatii? ");
INSERT INTO dwrNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraahaamo Xoossay, Yisaaqa Xoossay, Yayiqooba Xoossay, nu aawatuwa Xoossay, hinttenttu aathi immeeddawaa Philaaxoosi billanaw qoppi utteedda wode, hinttenttu A sinthan, ‘Nuuni A erokko’ geedda bare Na7aa Yesuusa bonchcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Shin hinttenttu geeshshaanne xilluwaa, ‘Nuuni A erokko’ giide, shemppuwaa wodheeddawaa A diraa hinttenttoo billanaw Philaaxoosa woosseeddita. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","De7uwaa immiyaawaa hinttenttu wodheeddita; shin Xoossay hayquwaappe A dentheeddawaassi nuuni markka. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ha wobba bitaniyaa Yesuusa sunthaa wolqqay minisseedda; hinttenttu be7iyaawenne eriyaawekka I A sunthan ammaniyaawaan oosetteedda; ha hinttenttu ubbaa sinthan A hawaadan loytheeddawe, Yesuusa I ammaniyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ha77ikka taanaadan ammaniyaawanttoo, hinttenttukka hinttentta kaalliyaawanttudan, erennaan ootheeddawaa taani eray. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Shin Xoossay beni, nabatuwaa ubbatuwaa doonaan, ‘Kiristtoosi waayyettana bessee’ yaagiide odeedda; bare odeeddawaakka hewaadan poleedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Simmi Xoossay hinttenttu nagaraa maaranaadan, Godaa matappe ayyaanaa minotethaa wodii hinttenttoo yaanaadaaninne Xoossay Yesuusi Kiristtoosa kase hinttenttoo odettowaadan yeddanaadan, hinttenttu nagaraa paaxiide Xoossaakko simmite. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Xoossay geeshshaa gideedda bare nabatuwaa doonan benippe doommiide haasayeeddawaadan, ubbabay ooraxxiyaa wodii gakkanaw, Yesuusi saluwan gami77anaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muse, ‘Goday Xoossay, hinttenttu zariyaa giddoppe hinttenttoo taanaadan nabiyaa denthana; hinttenttu I giyaawaa ubbaa sisite. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","He nabii odiyaawaa sisenna asay ooninne asaa giddoppe shaaketti dhayo’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Qassi Saameelappe doommiide, aappe kaalla denddeedda nabatuu ubbatuu, ha wodiyaabaa odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hinttenttu nabatuwaa naanaa; qassi Xoossay Abraahaamossi, ‘Sa7aan de7iyaa asaa ubbaa taani ne zerethaa bagganna anjjana’ yaagiide nu aawatuwanna caaqqeedda caaquwaa laattiyaa naanaa. ");
INSERT INTO dwrNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Xoossay hinttentta ubbatuwaa hinttenttu iita oosuwaappe zaariide anjjana mala, bare Qoomaa denthiide, hinttenttoo koyro yeddeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Phexiroossinne Yohaannisi asaassi odishshin, qeesatuwaa kaappatuu, Geeshsha Golliyaa wottaaddaratuwaa azaziyaawenne Saduuqaawanatuu, ");
INSERT INTO dwrNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","unttunttu asaa tamaarissiyaa dirawunne hara asatuu hayquwaappe denddanawoo markka gidana mala, Yesuusi hayquwaappe denddeeddawaa odeedda diraw, darii yilotiide, unttunttukko yeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Unttuntta oyqqiide, sa7ay omarssidiggo diraw wonttanaassi qasho golle gelisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Shin qaalaa siseeddawanttuppe coratuu ammaneeddino; attuma asaa payduu ichcheshu sha77a keena gideedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Wonttetha gallassi, unttuntta mooddiyaawanttu, Ayihuda asaa cimatuu, Muse higgiyaa tamaarssiyaawanttu, qeesatuwaa ubbatuwaa kaappatuu Haanni, Qayaafi, Yohaannisi Iskkinddirinne qeesatuwaa ubbatuwaa kaappatuwaa dabbatuu ubbay Yeerusalaamen shiiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yesuusi kiitteeddawantta barenttu gidduwan essiide, “Ayaa wolqqaan woy O sunthan hawaa hinttenttu ootheedditee?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","He wode Phexiroosi barenan Geeshsha Ayyaanay kumina, unttuntta hawaadan yaageedda; “Asaa kaalethiyaawanttoo, Ayihuda asaa cimatoo, ");
INSERT INTO dwrNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","hachche ha hargganchcha bitaniyaassi oosetteedda lo77o oosuwaabaanne I waani paxeeddentto, hinttenttu nuuna oochchooppe, ");
INSERT INTO dwrNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","masqqaliyaa bolla misimaariyan hinttenttu dhishiide kaqqina, Xoossay hayquwaappe dentheedda Naazireetiyaa Yesuusi Kiristtoosa sunthan ha bitani paxiide, hinttenttu sinthaan eqqeeddawe hinttenttu ubbaassinne Israa7eeliyaa asaa ubbaw eretto. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Golliyaa keexxiyaawanttu hinttenttu kadhiide ixxeedda tuussay golliyaa ubbaa tookkiyaa koshshiyaa tuussaa gideedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Asay atotethaa Yesuusa bagganna demmanaappe attin, hara O baggannanne demmenna; nuuni A sunthan oothanaw bessee; ayissi gooppe, Xoossay saluwaappe garssan asaassi immeedda hara sunthay baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Shiiquwaa asay Phexiroossinne Yohaannisi xaleedda xalaa be7eedda wode, unttunttu tamaaribeenna coo asaa gideeddawaa akeekiide maalaletteeddino; unttunttu Yesuusanna de7iyaawaakka ereeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Qassi paxeedda bitani Phexiroossannanne Yohaannisanna eqqeeddawaa asay be7iide, giyaawaa dhayeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Shin Phexiroossinne Yohaannisi shiiquwaappe kare kesana mala asay azaziide, bare giddon zorettiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ha asatuwaa ayaa udanee? Ayissi gooppe, unttunttu kushiyan oosetteedda wolqqaama malaatatuu Yeerusalaamen de7iyaa ubbaw beetteedda. Nuuni hewaa erokko gaanaw danddayokko. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Shin yewuu asaw laalettenna mala, hawaappe sinthaw ha asatuu Yesuusa sunthaa oossinne odennaadan, minissiide unttuntta, ‘Hinttena erite’ goytte” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Unttunttu xeesiide, Yesuusa sunthaa mulekka denthenaadaninne aabaa tamaarissennaadan azazeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Shin Phexiroossinne Yohaannisi zaariide, “Xoossaw eeno giyaawaa aggiide, hinttenttoo eeno giyaawe Xoossaa sinthan lo77enttonne ane hintte pirddite. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ayissi gooppe, nuuni be7eeddabaanne siseeddabaa odennaan agganaw danddayokko” yaagiide shiiqeedda asaw odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Shiiqeedda asay unttuntta muranaw gaasottiyaabay dhayina, laa7ethuwaa darissi palumettiide, haneeddabaw asay ubbay Xoossaa galatiyaa diraw, unttuntta billiide yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","He harggiyaappe pathiyaa malaatatuu aw oosetteedda bitani yelettoodeppe laythay aw oytamuwaappe aadhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Phexiroossinne Yohaannisi bilettiide, barenttu dabbatuwakko biide, qeesatuwaa kaappatuunne Ayihuda cimatuu barentta geeddabaa ubbaa unttunttoo odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Unttunttu hewaa siseedda wode, itti wozana gidiide, Xoossaa hawaadan yaagiide woosseeddino; “Ubbaa Mooddiyaa Godaw, saluwaa, sa7aa, abbaanne unttunttu giddon de7iyaa ubbabaa medhdheeddawoo, ");
INSERT INTO dwrNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Neeni New oothiyaa nu aawuwaa Daawite doonaan Geeshsha Ayyaanan haasayaadde, ‘Ayihuda gidenna asay ayissi yiloteeddee? Qassi asay ayissi danbbennabaw maqqetteeddee? ");
INSERT INTO dwrNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sa7aa kaatatuu giigetteeddino; gadiyaa mooddiyaawanttu Godaa bollaninne I okkeedda Kiristtoosa bolla ittippe denddeeddino’ yaagaade haasayaadda. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ayissi gooppe, Heeroodisinne Phenxxenaawiyaa Philaaxoosi Ayihuda gidenna asaannanne Israa7eeliyaa asaanna, neeni okkeedda Kiristtoosa ne Geeshsha Na7aa Yesuusa bolla denddanaw, ha katamaan shiiqeeddawe tuma. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Qassi neeni ne wolqqaaninne ne sheniyaan hanana gaade qoppa utteeddabaa ubbaa oothanaw shiiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ha77ikka Godaw, unttunttu naasiyaa xeella; nuuni neena kaalliyaawanttu, ne qaalaa kumentha qonccetethaan odanaadan, nuuna danddayissa. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pathanaw ne wolqqaa bessa; qassi ne Geeshsha Na7aa Yesuusa sunthan oorathabaanne malaataa oosissa” giide woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Unttunttu Xoossaa woosseeddawaappe guyyiyan, he unttunttu shiiqeeddasay qaaxxeedda. Unttunttu ubbaan Geeshsha Ayyaanay kumina, Xoossaa qaalaa qonccetethaan odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ammaniyaawanttu ubbatuu qofaaninne wozanaan ittuwaa gideeddino. Unttunttu mehii ubbay ittippe de7iyaawaappe attin, barew de7eeddabaa ooninne barenttubaa gibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yesuusi kiitteeddawanttu Godaa Yesuusi hayquwaappe denddeeddawaa wolqqaama wolqqaan markkattiino; qassi Xoossay unttunttoo ubbaw aadho keekatethaa darissiide immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ammaniyaawanttu giddon metootanchchay ittuunne baawa; ayissi gooppe, biittay woy golli de7iyaawanttu ubbatuu zali77iide, akkeedda miishshaa ahiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Yesuusi kiitteeddawanttussi immiino; he miishshay asaw koshshiyaawaadan shaaketti, huuphiyan huuphiyan imettee. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qophiroosa geetettiyaa saan yeletteedda Yooseefa giyaa Leewiyaa zarii ittuu de7ee; A sunthaa Yesuusi kiitteeddawanttu Barnaabaasa geeddino. Hewaa bilethay “Menthethiyaa Na7aa” giyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Barnaabaasi barew de7iyaa gadiyaa zali77eedda miishshaa ahiide, Yesuusi kiitteeddawanttussi immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Itti Hanaaniyaa geetettiyaa bitani bare machchatti Saphphiirinna gadiyaa zali77eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","He zali77eedda miishshaappe bare machchatta erishshin ashshiide, attowaa Yesuusi kiitteeddawanttussi immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Shin Phexiroosi Hanaaniyaa, “Neeni Geeshsha Ayyaanaa cimmaade ne gadiyaa zali77eedda miishshaappe shaakka ashshana mala, xalahii ne wozanaan ayissi geleeddee? ");
INSERT INTO dwrNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Neeni zali77anaappe kase gadii newaa gidennee? Qassi neeni zali77a simminakka miishshay neessa gidennee? Yaatina, hawaa malabaa oothanaw ayissi ne wozanaan qoppaaddii? Neeni Xoossaw worddotowaappe attin, asaw worddotabeykka” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hanaanii he qaalaa siseedda man77iyankka kunddiide hayqqi aggeedda; hewaa siseedda ubbay daro yayyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wodalla asatuu soy geliide, A anhaa xaaxiide, karew kesi A moogeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Heezzu saate gidowaappe guyyiyan, Hanaaniyaa machchatta hewaa erennaan de7aadde gelaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phexiroosi izo, “Hinttenttu gadiyaa hanni keena miishshaan zali77eedditee? Ane taw oda” yaageedda. Iza, “E hanni keena miishshaan zali77eeddo” yaagaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Phexiroosi mishiratto, “Neeninne ne asinay Godaa Ayyaanaa paaccanaw ayissi zoretteedditee? Be7a; ne asinaa moogeedda asatuu karen de7iino; ne anhaakka unttunttu kare kessana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mishiratta he man77iyankka Phexiroosa gediyaa matan kunddaade hayqqaa aggaaddu; wodalla asatuu geliyaa wode hayqqeeddawunno demmiide, kare kesseeddawaappe guyye, izi asinaa duufuwaa matan moogeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ammaniyaa asaa ubbaynne hewaa siseedda hara asay ubbay darii yayyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesuusi kiitteeddawanttu daro malaataanne oorathabaa asaa giddon oothiino; ammaniyaa ubbatuu Solomone baranddaan ittippe shiiqiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hara asaappe unttunttunna gakettanaw haray atto ittuunne xalibeenna; shin asay unttuntta bonchchee. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ammaniyaa attuma asaynne macca asay kasewaappe coray Godaassi gujettee. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hewaa diraw, asay hargganchchatuwaa shanchchamaaninne saleenan qeri tookkiide, Phexiroosi hewaanna aadhdhiyaa wode haray atto, aw kuwenttonne unttunttuppe ittuwaa ittuwaa bollanna aadhdhana mala, katamaa ogiyaa doonaa kessiide wothee. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Qassi cora asay Yeerusalaame matan de7iyaa katamatuwaappe harganchchatuwanne iita ayyaanan oyqetteedda asatuwaa akki yeeddino; ubbatuukka paxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hewaappe simmina qeesatuwaa kaappuunne aananna de7iyaa Saduqaawanatuu ubbatuu Yesuusi kiitteeddawantta daro qanaatiide, unttunttu bolla denddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Qassi Yesuusi kiitteeddawantta oyqqiide, ubba asaa qachchiyaa golliyaan yeggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Shin Godaa kiitanchchay qamma qasho golle penggiyaa dooyyiide, Yesuusi kiitteeddawantta kare kessiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Hinttenttu biide, Geeshsha Golliyan eqqiide, ha ooratha de7uwaa qaalaa ubba asaw odite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yesuusi kiitteeddawanttu hewaa siseedda wode, wonttumaathaan Geeshsha Golliyaa geliide, tamaarssanaw doommeeddino. Qassi qeesatuwaa kaappuunne aananna de7iyaawanttu yiide, shiiqeedda asaanna Israa7eeliyaa cimatuwaa ubbatuwaa ittippe xeesiide, Yesuusi kiitteeddawantta barenttu sintha ahana mala, wottaaddaratuwaa qasho golle kiitteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Shin wottaaddaratuu qasho golle biide, Yesuusi kiitteeddawantta demmibeykkino; guyye simmiide shiiqeedda asaw, “Nuuni biyaa wode qasho golle kariyaa daro minissi qachchina, naagiyaawanttukka penggiyaan eqqeeddawantta demmeeddo; shin nuuni qasho golliyaa dooyyiyaa wode, golle garssan haray atto itti asaynne baawa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Geeshsha Golliyaa wottaaddaratuwaa kiittiyaawenne qeesatuwaa kaappatuu hewaa siseedda wode, “Hawe waanuwashshaa? Qassi gidini aye hananddeeshsha?” yaagiide hirggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hewaappe guyyiyan, itti bitani unttunttukko yiide, “Be7ite; qasho golliyaan hintte qachcheedda asatuu Geeshsha Golliyan eqqiide, asaa tamaarissiino” yaagiide unttunttoo odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Geeshsha Golliyaa wottaaddaratuwaa azaziyaawe wottaaddaratuwaanna biide, Yesuusi kiitteeddawantta aheedda; shin unttunttu barentta asay shuchchan caddanawantta giide yayyeedda diraw, unttuntta loddaan aheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Unttunttu Yesuusi kiitteeddawantta ahiide, hewaa shiiqeedda shangguwaa sinthan essina, qeesatuwaa kaappuu unttuntta, ");
INSERT INTO dwrNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Hinttentta nuuni he bitaniyaa sunthan tamaarissenna mala minissiide azazibeykkoo? Be7ite; hintte timirttiyaa Yeerusalaame katamaa ubbaa gatheeddita; qassi he bitaniyaa shemppuwaan nuuna oythanaw qoppiita!” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phexiroossinne Yesuusi kiitteedda haranttu zaariide yaageeddino; “Nuuni asaw azazettanaappe Xoossaw azazettanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Masqqaliyaa bolla misimaariyan dhishi kaqqiide, hintte wodheedda Yesuusa nu aawatuwa Xoossay hayquwaappe dentheedda; ");
INSERT INTO dwrNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israa7eelatuwassi nagaraappe simaanne nagaraa atto guussaa Yesuusi immana mala, Xoossay mooddiyaawaanne ashshiyaawaa A oothiide, bareppe ushechcha baggan dhoqqu dhoqqu ootheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Hewaassi nuuni markka; qassi Xoossay barew azazettiyaawanttussi immeedda Geeshsha Ayyaanaykka markka” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Shiiqeedda asay hewaa siseedda wode, daro yilotiide, Yesuusi kiitteeddawantta wodhanaw qoppeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Shin asaa ubbaan daro bonchchetteedda Gamaaliyaala geetettiyaa, higgiyaa tamaarissiyaa itti Parisaawii, shiiquwaan denddi eqqiide, Yesuusi kiitteeddawanttu guutha wodiyaa kare kesana mala ");
INSERT INTO dwrNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","azaziide hewaan shiiqeedda asaa hawaadan yaageedda; “Israa7eeliyaa asatoo, hintte ha asatuwaa oothana qoppiyaawaan hinttentta naagite. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ayissi gooppe, hawaappe kase wodiyaan Tewodaasa geettettiyaawe barena wolqqaama giide denddeedda; denddina oyddu xeetu gidiyaa asatuu aananna gaketteeddino; shin A wodhina, A kaalleedda ubbatuukka laalettiide, maaddenna asa gidiide atteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hewaappe guyyiyan, asay paydettiyaa wode, Galiilaa Yihuday denddiide, daro asaa paannuwaa udiide kaaletheedda; shin aakka wodhina, A kaalleedda asay ubbay laaletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Ha77ikka taani hinttenttoo oday; ha asatuwaappe shaakettite; unttuntta bochchoppite. Ayissi gooppe, ha qofaynne ha oosuu asay ootheeddawaa gidooppe dhayana. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Shin ha qofaynne ha oosuu Xoossaappe yeeddawaa gidooppe, hintte unttuntta dhayissanaw danddaykkita; ooni eri hawaa haniide Xoossaanna hintte iitettennaadan” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hewaappe guyye shiiqeedda asay Gamaaliyaala zoriyaa akkiide, Yesuusi kiitteeddawantta xeesiide, lissuwan shocisseeddino; hewaappe guyyiyan unttuntta, “Yesuusa sunthaa laa7ethuwaa ubbakka denthoppite” gi billiide yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesuusa sunthaa diraw, unttunttu ugatiidde yeellatanaw bessiyaabaa qoppeedda diraw, shangguwaa sinthaappe nashettiide keseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Unttunttu ubba gallassi Geeshsha Golliyaaninne asaa soyin Yesuusi, Kiristtoosa gideeddawaa tamaarissiyaawaanne odiyaawaa yaa gujjeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","He wode, kaalliyaawanttu payduu dari dari biishshin, Giriike qaalaa haasayiyaa Ayihudatuunne Yihudaan de7iyaa Ayihudatuu walaqetteeddino; ayissi gooppe, Giriike qaalaa haasayiyaa Ayihudatuu, “Ubba gallassi gishettiyaa qumaan nu asinay hayqqo maccawanttu naaqettiino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yesuusi kiitteedda tammanne laa77atuu woosa golle asaa ubbaa xeesiide, hawaadan yaageeddino; “Nuuni Xoossaa qaalaa odiyaawaa aggiide, qumaa gishanaw nuussi bessenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ishatoo, lo77a geetettiyaawantta Geeshsha Ayyaanaynne aadho eratethay kumeedda laappu asatuwaa hintte giddoppe doorite; nuuni qassi unttuntta ha oosuwaassi sunthana. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Shin nuuni Xoossaa woosaaninne qaalaa oduwan minnana” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yesuusi kiitteeddawanttu haasayeedda haasayay asaa ubbaa nashechcheedda; hewaappe guyye, ammanuunne Geeshsha Ayyaanay kumeedda Isxxifaanoosa, Piliphphoosa, Phirookoroosa, Niqaaroona, Ximoona, Pharimeenanne Ayihudatuwaa ammanuwan geleedda Anxxookiyaa Niiqolaawoosa dooreeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yaatiide Yesuusi kiitteeddawanttu sinthaan unttuntta essina, Yesuusi kiitteeddawanttu Xoossaa woosseeddawaappe guyyiyan, barenttu kushiyaa unttunttu bolla wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Xoossaa qaalay aakki aakki beedda; kaalliyaawanttu payduwaan Yeerusalaamen darissi dari dari beedda; qassi cora qeesatuukka ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aadho keekatethaynne wolqqay kumeedda Isxxifaanoosi, asaa giddon oorathabaanne wolqqaama malaataa oothee. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aylletethaappe keseedda asaa giyaa Ayihuda ammaniyaawanttuppe, Qereenappe, Iskkinddiriyaa asatuwaappe, Kilqqiyaappenne Iisiyappe yeedda itti itti asatuu denddiide, Isxxifaanoosanna palumetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Shin Isxxifaanoosi aadho eratethaaninne Ayyaanaan haasayiyaawaa digganaw danddaybeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","He wode unttunttu, “Muse bollanne Xoossaa bolla I boriyaa qaalaa haasayishshin siseeddo” giyaa worddo asatuwaa shammeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Asaa ubbaa, cimatuwaanne Muse higgiyaa tamaarissiyaawantta hanqqetheeddino; Isxxifaanoosakko yiide A oyqqiide, shiiqeedda asaakko ahina, ");
INSERT INTO dwrNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","A bolla xeeseedda worddo markkatuu, “Ha bitani ha Geeshsha Golliyaanne Muse higgiyaa boriyaawaa awudenne aggenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ayissi gooppe I, ‘Hawe Naazireetiyaa Yesuusi ha Geeshsha Golliyaa kolana; Muse nuussi immeedda higgiyaakka laammana’ yaagishshin, nuuni siseeddo” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Shiiquwaan utteedda asay ubbay Isxxifaanoosa akeekiide xeelliyaa wode, A som77i kiitanchchaa som77iyaa malatee. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Qeesatuwaa ubbatuwaa kaappuu Isxxifaanoosa, “Hawe tumee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Isxxifaanoosi “Taanaadan ammaniyaawanttoo, ta aawatoo, sisite! Nu aawuwaa Abraahaamo biro Kaaraane baanaappe kase Masiphphexoomiyan de7ishshin, bonchcho Xoossay aw beettiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Ne biittaappenne ne dabbatuwaappe shaakettaade, taani neena bessiyaa gadiyaa ba’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","He wode Abraahaamo Kaladaawatuu gadiyaappe kesiide, Kaaraanen de7anaw beedda. A aabbu hayqqeeddawaappe guyyiyan, Xoossay A ha gade hintte ha77i de7iyaasaa aheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","I ha gadiyaappe haray atto, gediyaan yedhdhiyaa sa7aakka Abraahaamossi immibeenna; shin aw na7ay dhayooppekka, Xoossay A, ‘Taani newunne neeppe guyyiyan, ne zerethaw ha gadiyaa laata oothaade immana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xoossay Abraahaamossi, ‘Ne zaratuu hara gadiyan de7ana; yaani oyddu xeetu laythaw unttunttu aylletananne naaqettana. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Shin taani ne zerethaa mooddiyaa asaa bolla pirddana; hewaappe guyyiyan, unttunttu he gadiyaappe kesiide, hawaan taw goyinnana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xoossay Abraahaame zerethay qaxxarettana mala aananna caaqqina, Yisaaqa I yeliide, hosppuntha gallassi qaxxareedda; Yisaaqi Yayiqooba qaxxarina, qassi Yayiqoobi tammanne laa77u aawatuwa kaappatuwaa qaxxareedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Aawatuwaa kaappatuu Yooseefa qanaatiide, Gibxe gadiyaassi aylletanaadan, A zali77eeddino; shin Xoossay aananna ittippe de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Xoossay waayyiyaa ubbaappekka A kesseedda; qassi Gibxe kaatiyaa sinthankka nashshuwaanne aadho eratethaa aw immeedda; Gibxe kaatii Yooseefossi Gibxe gadiyaanne bare golliyaa ubbaa mooddanaadan, sunthatethaa immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Gibxe gadiyaaninne Kanaane gadiyan ubbaan koshay geliide, cora asaa metootheedda; he gaasuwaan nu aawatuu qumaa demmibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yayiqoobi Gibxe gadiyan kathay de7iyaawaa sisiide, nu aawatuwaa koyro yaa yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Laa7ethuwaa buussan Yooseefo bare ishatuwaassi eretteedda; qassi Gibxe kaatiikka Yooseefo zariyaa ereedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yooseefo bare aawuwaa Yayiqoobinne bare dabbu ubbay mulekka laappun tammanne ichcheshu asay barekko yaana mala, kiittiide xeegisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yayiqoobi Gibxe gadiyaa wodhdhiide hayqqeedda; nu aawatuukka yaani hayqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Unttunttu anhay hewaappe Sekeema geetettiyaa gadiyaa tookettiide, yaani Abraahaamo Hamoora naanaappe daro biraan shammeedda duufuwan moogetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","18","“Shin Xoossay Abraahaamossi immana geeddawe polettiyaa wodii gakkana matina, Yooseefa erenna hara kaatii Gibxe gadiyan denddana gakkanaassi, asay dari dari beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","He kaatii nu zariyaa cimmiide, guutha naanay hayqqana mala, kare unttuntta kessi olanaadan, nu aawatuwa un77etheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Muse yeletteeddawe he wode; Xoossaa sinthan I daro lo77o na7aa gideedda; bare aawuwaa golliyaan heezzu agenaa gakkanaassi dicceedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Muse wora oletteedda wode, Gibxe kaatiyaa naatta demmaade bare na7aadan A dichchaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Muse Gibxatuwaa aadho eratethaa ubbaa tamaariide, qaalaaninne oosuwan wolqqaama asa gideedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Shin Musew yelettoodeppe laythay oytamuwaa kumeedda wode, bare ishatuwaa, Israa7eeliyaa asatuwaa be7anaw bare wozanaan qoppeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Isra7eelatuwappe ittuwaa Gibxeppe ittu naaqqishshin be7iide, he Israa7eeliyaa maaddeedda; he naaqqeedda Gibxe bitaniyaa wodhiide, A haluwaa kesseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Muse bare ishatuwaa bare bagganna Xoossay ashshana haniyaawaa unttunttu akeekeeddino giide qoppeedda; shin unttunttu akeekibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Wonttetha gallassi laa77u Israa7eeliyaa asatuu ittu ittuwaanna wadhettiyaawantta demmiide, unttuntta sigethanaw koyyiide, ‘Asatoo, ishatuu hinttenttu ayissi ittu ittuwaa naaqqiitee?’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Shin he bare shooruwaa naaqqiyaawe Musa, ‘Neena nu bolla mooddiyaawaanne daannaa udiide, suntheeddawe oonee? ");
INSERT INTO dwrNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Neeni zino Gibxe bitaniyaa wodheeddawaadan, taanakka wodhanaw koyyay?’ yaagiide, Musa karew sugi yegeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Muse hewaa siseedda wode Gibxeppe kesiide, Midiyaama gadiyan bete gidi de7iidde, laa77u attuma naanaa yaani yeleedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Godaa kiitanchchay oytamu laythaappe guyyiyan, Siinaa Deriyaa matan de7iyaa bazzuwaa buuran eexxiyaa tamaa lacuwaa giddon Musew beetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Muse bare be7eeddawoo maalalettiide, akeeki xeellanaw buuraa mataan I shiiqide7ishshin, Godaa qaalay, ‘Taani ne aawatuwa Xoossaa, Abraahaame Xoossaa, Yisaaqa Xoossaa, Yayiqooba Xoossaa’ yaagiide Musekko yeedda. Muse yashshaa kokkoriide, xeellanaw xalibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Goday Musa, ‘Neeni eqqeedda biittay geeshsha gidiyaa diraw, ne gediyaan de7iyaa caammaakka kessa. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Taani Gibxen de7iyaa Ta asaa waayyiyaa geeshsha be7aade, qassi unttunttu ooliyaakka sisaade, unttuntta ashshanaw wodhdhaaddi. Ha77i haa ya. Taani neena Gibxe kiittana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“He Musa Israa7eelatuu; ‘Neena nuuna mooddiyaawaanne daannaa udiide suntheeddawe oonee?’ yaagiide ixxeeddino; buuraa giddon aw beetteedda kiitanchchan mooddiyaawaanne ashshiyaawaa gidana mala, Xoossay A kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","He Muse Israa7eelatuwaa Gibxe gadiyan Zo7o Abbaaninne mela biittaan, oytamu laythaw oorathabaanne malaataa oothiide, Gibxeppe kaaletheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Israa7eeliyaa asaassi, ‘Xoossay taana dentheeddawaadan, hintte zariyaa giddoppe ta mala nabiyaa hinttenttoo denthanawaa’ yaageeddawe he Musa. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","I Israa7eeliyaa asaa maabaraanna ittippe mela biittaan de7eeddawaa; I nu aawatuwannanne Siinaa Deriyaa bollan barew haasayeedda kiitanchchaanna ittippe de7eedda. Yaatiide Xoossaappe de7uwaa qaalaa nuussi immanaw akkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Musew nu aawatuu azazettanaw dosibeykkino; shin gede A sugi oliide, guyye Gibxe simmanaw amotteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Qassi Aaroona, ‘Nuuna kaalethiyaa xoossatuwaa nuussi medhdha; ayissi gooppe, ha nuuna Gibxeppe aheedda Muse waaneeddentto nuuni erokko’ yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Miizzaa Maraa malatissiide, he wode eeqaa ootheeddino; he eeqaassi yarshshuwaa yarshshiide, barenttu kushii ootheedda oosuwan nashetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Shin Xoossay unttunttoo zokkiyaa zaareedda; unttunttu saluwaa xoolinttiyaassi goyinnanaadan, unttuntta aggeedda; nabatuwaa maxaafan, ‘Israa7eeliyaa asatoo, oytamu laythaa asay baynna saan shukkeedda mehiyaanne yarshshuwaa taw yarshsheedditee? ");
INSERT INTO dwrNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hinttenttu hinttenttoo goyinnanaw ootheedda eeqatuwaa, Molooka dunkkaaniyaanne Refaana giyaa hintte xoossaa xoolinttiyaa tookkeeddita. Taani hinttentta Baabilooneppe hini bagga yeddana’ geetettiide xaafetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Muse bare be7eeddawaa malatissiide, Goday aw odeeddawaadan medhdheedda markkaa dunkkaanii nu aawatuwassi mela biittaan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Qassi nu aawatuu dunkkaaniyaa barenttu aawatuwappe kaallaan akkiide, Xoossay kase yedersseedda Ayihuda gidenna asaa biittaa oyqqeedda wode, Iyyaasunna gelisseeddino; he dunkkaanii Daawite de7iyaa wodii gakkanawukka hewaan de7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daawite Xoossaan sabetteedda; qassi Yayiqooba, Goday de7ana golliyaa keexxanaw Xoossaa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Shin aw golliyaa keexxeeddawe Solomona. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","50","“Shin nabii, ‘Goday, “Saluu ta kawutethaa oydiyaa; sa7aykka ta gedi yedhdhiyaasaa. Yaatina, taw ayaa mala golliyaa keexxanitee? Woy taani shemppanasay haqanee? Ha ubbabaa ta kushiyan medhdhabeykkitaa?” yaagee’ geeddawaadan, Ubbaappe Bolla Xoossay asay keexxeedda golliyaan de7enna. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Hinttenttu aybe morggii mino asee? Hinttenttu wozanay Xoossaa qaalaa akkanaw aybe dammeeddawee? Hinttenttu haythaykka waani tulleeddee? Ubba wode Geeshsha Ayyaanaassi azazettennan ixxiita. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","53","Nabatuwan hinttenttu aawatuu yederssibeennawe oonee? Xoossaa Na7ay Xilluu yaanawaa kasetiide odeeddawanttakka wodheeddino. Ha77i hinttenttukka kiitanchchatuwaa kushiyaappe Xoossaa higgiyaa akkiide azazettibeennawanttu, Xilluwaa aathi immiide wodheeddita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Unttunttu hewaa siseedda wode, barenttu wozanaan Isxxifaanoosassi daro yiillotiide, barenttu menttershshaa sa77iide naasseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Shin Isxxifaanoosi barenan Geeshsha Ayyaanay kumina, saluwaa pude caddi xeelliide, Xoossaa bonchchuwaanne Yesuusi Xoossaappe ushechcha baggan eqqeeddawaa be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yaatiide, “Xeellite, taani saluu dooyettina, Asaa Na7ay Xoossaappe ushechcha baggan eqqeeddawaa be7ay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kooshshaa dhoqqu oothi waassiidde, barenttu haythaa tucciide, ittippe gidi aakko woxxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Katamaappe gaxaa A kessiide, shuchchan caddeeddino. Markkatuukka barenttu mayuwaa kessiide, itti Saa7oola geetettiyaa wodallaa matan wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Isxxifaanoosi, “Ta Godaa Yesuusaa, ta shemppuwaa akka” yaagiide xeegishshin, unttunttu shuchchan A dechchiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","He wode I gulbbatiide, bare kooshshaa dhoqqu oothiide, “Ta Godaw, ha nagaraa unttunttoo atto ga” yaageedda. Hewaa giinnee hayqqi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saa7ooli Isxxifaanose hayquu lo77a gi akkeedda. He gallassi Yeerusalaamen de7iyaa ammaniyaawanttu bolla wolqqaama yederssuu denddeedda; Yesuusi kiitteeddawanttuppe attin, ammaniyaawanttu ubbatuu Yihudaa gadiyaaninne Sammaariyaa gadiyan laaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Xoossaa asatuu Isxxifaanoosa moogeeddino; qassi aw daro yeekkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Shin Saa7ooli ammaniyaa asaa dhayissanaw baaxetee; ubbaa golliyaa geli geliide, attuma asaanne macca asaa goochchi goochchiide, qasho golle yeddee. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Laaletteedda ammaniyaawanttu qaalaa odiidde, ubbasaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Piliphphoosi Sammaariyaa katamaa wodhdhiide, Kiristtoosabaa asaassi odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Cora asay Piliphphoosi geeddawaa darissi akeekiide siseedda; I oothiyaa malaataakka be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ayissi gooppe, iita ayyanatuu kooshshaa dhoqqu oothi haasayiidde, cora asaappe keseeddino; qassi cora sileeddawanttunne wobbatuu paxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","He katamaan asay daro nashetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Shin Simoona geetettiyaa itti bitani kase, barena wolqqaama gi kaayiiddi, Sammaariyaa asaa, “Laa hawe aybe oorathabee” giissiidde he katamaan de7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Guuthatethaappe doommiide, woggatethaa gakkanaw, asay ubbay, “Xoossaa wolqqay daro wolqqaamay hawaa” giide aabaa sisee. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Daro wodiyaappe doommiide, kaayuwan Sammaariyaa asaa “Laa hawe ayba oorathabee” giisseedda diraw, asay aabaa sisee. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Shin Piliphphoosi Xoossaa kawutethaabaanne Yesuusi Kiristtoosa sunthaabaa attumawanttussinne maccawanttussi mishiraachchuwaa odiidde, unttunttu aabaa ammaniide xammaqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Qassi Simoonikka bare huuphew ammaniide xammaqetteeddawaappe guyyiyan, Piliphphoosanna ittippe de7iidde, oosettiyaa malaataanne Xoossay ootheedda wolqqaama malaataa be7iide maalaletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yesuusi kiitteedda Yeerusalaamen de7iyaawanttu, Sammaariyaa asay Xoossaa qaalaa akkeeddawaa siseedda wode, Phexiroosanne Yohaannisa unttunttukko yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Phexiroossinne Yohaannisi wodhdhiide, ammaniyaawanttu Geeshsha Ayyaanaa akkana mala, unttunttoo Xoossaa woosseeddino; ");
INSERT INTO dwrNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ayissi gooppe, Sammaariyaa asatuu Godaa Yesuusa sunthan xinqqataa xalalaa xammaqetteeddawaappe attin, unttunttuppe ittuwaa bollaninne Geeshsha Ayyaanay wodhdhibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","He wode Phexiroossinne Yohaannisi barenttu kushiyaa unttunttu bolla wothowaappe guyyiyaan unttunttu Geeshsha Ayyaanaa akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Yesuusi kiitteeddawanttu barenttu kushiyaa unttunttu bolla wothina, unttunttoo Geeshsha Ayyaanay imetteeddawaa Simooni be7eedda wode, Phexiroosassinne Yohaannisassi miishshaa ahiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Taanikka ta kushiyaa wothiyaa ubbay Geeshsha Ayyaanaa akkana mala, ha maataa tawukka immeerikkitee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Shin Phexiroosi aw hawaadan yaageedda; “Neeni Xoossaa imotaa miishshaan shammanaw qoppeedda diraw, ne miishshay neenanna coo dhayo. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ne wozanay Xoossaa sinthan suure gidenna diraw, new hawaan gishuu baawa. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Yaatowaappe guyyiyaan ha ne wozanaa iita qofaa diraw, nagaraappe simma; ooni eri ne wozanaan de7iyaa iita qofaa Xoossay atto gaanenttonne Xoossaa woossa. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ayissi gooppe, neeni daro qanaatiyaa oyqqaade nagaraa qashuwan de7iyaawaa taani be7ay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hewaappe guyye Simooni Phexiroosassinne Yohaannisassi zaariide, “Hinttenttu geeddawaappe ittibaynne taana gakkenna mala, hintte taw Xoossaa woossite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Phexiroossinne Yohaannisi markkatteeddawaappenne Godaa qaalaa odeeddawaappe guyyiyan, guyye Yeerusalaame simmeeddino; yaatiide Sammaariyan de7iyaa daro qeeri katamatuwaan mishiraachchuwaa qaalaa odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Godaa kiitanchchay Piliphphoosa, “Denddaade Yeerusalaameppe Gaaza afiyaa asi baynna mela sa7aa ogiyaakko ba; he ogii away kesiyaasaa xeelliyaa wode ushechcha dugehaa bagganna de7ee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Piliphphoosi denddiide beedda. Hinddeko geetettiyaa Tophphiyaa kaatattissi biittaa mooddiyaa I miishshaa ubbaakka naagiyaa Tophphiyaa asa gideedda itti shuufay de7iyaawe goyinnanaw Yeerusalaame beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Paray goochchiyaa gaariyaan uttiide, Yeerusalaameppe guyye simmiide, nabiyaa Isiyaasa maxaafaa nabbabee. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Geeshsha Ayyaanay Piliphphoosa, “He gaariyaakko shiiqaade ittippe gida” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Piliphphoosi woxxi yiide, nabiyaa Isiyaasa maxaafaa shuufay nabbabishshin sisiide A, “Neeni nabbabiyaawaa akeekay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Shuufay, “Taw odiide akeekissiya asay baynnaan waaniide akeekettii?” yaageedda; qassi barenanna gaariyaan kesiide uttana mala, Piliphphoosa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Shuufay nabbabiyaa maxaafay “Dorssaadan I shukettanaw laagettee. Dorssa maray bare isikiyaa qanxxiyaawaa sinthan co77u giyaawaadan, ikka bare doonaa pokibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","I kawusheeddawaadan aw xillo pirdday dhayeedda. Yesuusa de7uu ha sa7aappe pude akettidiggeedda diraw, A zariyaabaa oonee odanawe?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Shuufay zaariide Piliphphoosaw, “Nabii hawaa oowaa odii? Barebaa odiyee woy hara asaabaa odii? Taw odaarikkii” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Piliphphoosi zaariide, Xoossaa maxaafaa I nabbabiyaasaappe doommiide, Yesuusabaa mishiraachchuwaa qaalaa aw odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Unttunttu ogiyaa oyqqi biidde, haathay de7iyaasaa gakkeeddino; shuufay, “Haathaa hawaa be7a; xammaqettiyaawaa taana diggiyaawe ayee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Piliphphoosi A, “Neeni ne kumentha wozanaappe ammanooppe, danddayaa” yaageedda. I zaariide, “Yesuusi Kiristtoosi Xoossaa Na7aa gidiyaawaa taani ammanay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Gaari eqqana mala shuufay azazina, inne Piliphphoosi laa77atuu duge wodhdhiide, haathaan gelina Piliphphoosi A xammaqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Unttunttu haathaappe gaxaa keseedda wode, Godaa Ayyaanay Piliphphoosa liphphi udiide, afi aggeedda; laa7ethuwaa shuufay Piliphphoosa be7ibeenna; shin bare ogiyaa nashettiide beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Piliphphoosi bare huuphew Azoxxoosan de7iyaawaa ereedda; qassi Qiisaariyaa yaana gakkanawukka, katamaa ubbaan yuuyyiidde mishiraachchuwaa qaalaa odee. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Shin Saa7ooli Godaa kaalliyaawantta wodhanaw manddiide, qeesatuwaa ubbatuwaa kaappuwaakko beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Yaatiide Godaa ogiyaa kaalliyaa asatuwaa maccawanttanne attumawantta demmooppe, qachchiide Yeerusalaame ahanaw, Damasqqon de7iyaa Ayihuda woosa golletoo dabidaabbiyaa xaafanaw A woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","I biidde, Damasqqo katamaa gakkana matoode, qoppennaan saluwaappe wolqqaama poo7uu A yuushshuwaa ubbaani poo7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saa7ooli sa7aan kunddi uttina, “Saa7oolaa Saa7oolaa, ayissi Taana waayissay?” giyaa qaalaa siseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saa7ooli, “Ta Godaw, neeni oonee?” yaagiide oochcheedda. Yesuusikka, “Taani neeni yederssaadde de7iyaa Yesuusa.” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Shin Saa7ooli kokkoriiddinne maalalettiidde, “Ta Godaw, taani ayaa oothanaadan koyyay?” yaageedda. Goday A, “Denddaade katamaa gela; neeni oothanaw bessiyaabay new yaani odettanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saa7oolanna ogiyaan biyaa asatuu aynne haasayennan eqqi aggiide, kooshshaa sisiino; shin oonanne be7ibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saa7ooli sa7aappe denddina, A ayfii doyetteedda wode, aynne xeellanaw danddayibeenna; hewaa diraw, unttunttu A kushiyaa oyqqi goochchiidde, Damasqqo gelisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Heezzu gallassa gakkanawukka I xeellibeenna; aynne mibeenna; ayaanneekka ushibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasqqon itti Hanaaniyaa giyaa kaalliyaawe de7ee; Goday saxaan A, “Hanaanew” yaageedda. Hanaanii, “Ta Godaw, hawaan de7ay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Goday A, “Denddaade Suure geetettiyaa ogiyaa baade, Yihudaa soyin itti Saa7oola giyaa Xersseeseppe yeedda bitaniyaa koyya; ayissi gooppe, I woossee. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Qassi Hanaaniyaa giyaa bitani geliide, Saa7ooli laa7enthuwaa xeellanaadan, bare kushiyaa A bolla wothiyaawaa saxaan be7eedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hanaanii zaariide, “Ta Godaw, Yeerusalaamen ne geeshsha asaa bolla he bitani ay keena iitabaa ootheeddentto, taani daro asaappe sisaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Qassi Damasqqon ne sunthaa xeesiyaawantta ubbaa qachchanaw, qeesatuwaa kaappatuu aw maataa immeeddino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Shin Goday A, “Saa7ooli Ayihuda gidenna asaa sinthan, kaatatuwaa sinthaaninne Israa7eeliyaa asaa sinthan, Ta sunthaa erissanawunne Taw oothanaadan dooretteedda miishshaa gidiyaa diraw, neeni ba. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ayissi gooppe, Ta sunthaa diraw, I ayikeenaa waayyettanaw bessintto, Taani A bessana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hanaanii biide, soy geliide, bare kushiyaa Saa7oola bolla wothiide, “Ta ishaw Saa7oolaa, neeni yiyaa ogiyaan new beetteedda Yesuusi, neeni xeellana malanne Geeshsha Ayyaanay neenan kumana mala, taana kiitteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ellekka, ayentto poquwaa malay Saa7oola ayfiyaappe wodhdhina, Saa7ooli laa7enthuwaa xeelleedda; qassi denddiide xammaqetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Qumaa miide minetti, Damasqqon de7iyaa kaalliyaawanttunna amareedda gallassaa gami77eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ellekka, “Yesuusi Kiristtoosi Xoossaa Na7aa” yaagiide, Ayihuda woosa golletuwaan qaalaa odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Hewaa siseedda ubbay maalalettiide, “Hawe Yeerusalaamen Yesuusa sunthaa xeesiyaawantta dhayissiyaawaa gidennee? Qassi unttuntta qachchiide, qeesatuwaa kaappatuwaa sintha afanaw yibeenneeyee?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Shin Saa7ooli qaalaa odiyaa oduu minni minni beedda; Yesuusi qassi Kiristtoosa gidiyaawaakka I akeekissiide odeedda diraw, Damasqqon de7iyaa Ayihudatuu aw zaariyaawaa dhayeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cora gallassaappe guyyiyan, Ayihudatuu shiiqiide, Saa7oola wodhanaw zoretteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Shin Ayihudatuu barena wodhanaw qoppowaa Saa7ooli siseedda; unttunttu A wodhanaw qammanne gallassi katamaa penggiyaa naagiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Shin kaalliyaawantta A qamma afiide, dirssaa huuphiyaanna taayyiyaan duge wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saa7ooli Yeerusalaame gakkeedda wode, kaalliyaawanttunna ittippe gakettanaw shiiqi be7eedda; shin kaalliyaawaa I gideeddawaa ubbay ammanennaan ixxiide, aw yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Shin Barnaabaasi Saa7oola Yesuusi kiitteeddawanttukko afeedda; ogiyaan Godaa I waaniide be7eeddentto, aw Goday wooti haasayeeddenttonne qassi Saa7ooli Damasqqon Yesuusa sunthan yayyennaan wooti qaalaa odeeddentto, unttunttoo geeshshiide odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saa7ooli Yeerusalaamen yuuyyiiddenne Godaa Yesuusa sunthan yayyennaan qaalaa odiidde, Yesuusi kiitteeddawanttunna ittippe de7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Qassi Saa7ooli Giriike qaalaa haasayiyaa Ayihudatuwaanna haasayeenne palumettee; shin unttunttu A wodhanaw koyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ishatuu hewaa sisiide, Saa7oola duge Qiisaariyaa afiide, Xersseese yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yihudaan, Galiilaaninne Sammaariyan ubbaan de7iyaa ammaniyaa asatuu sarotethaan de7eeddino; qassi minneeddino; Godaassi yayyiyaawaaninne Geeshsha Ayyaanaa maaduwan geemettiidde, payduwankka dari dari beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Phexiroosi ubbasan yuuyyiidde, Liidaan de7iyaa geeshsha asatuwaakko qassi wodhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yaatiide hewaan hosppun laythaa siliide, arssaan gisiide de7iyaa itti Eeniyaa giyaa bitaniyaa demmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phexiroosi Eeniyaa, “Eenaw, Yesuusi Kiristtoosi neena pathee; denddaade ne hiixaa yegga” yaageedda. Hewaappe guyye ellekka denddi eqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Liidaaninne Saaroonan de7iyaa asay ubbay Eeniyaa be7iide, Godaakko simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yoophphe katamaan itti Xaabito geetettiyaa ammanewunna de7aw; Xaabito guussay Giriike qaalaan Dorqqo giyaawaa. Iza bare de7eedda wodiyaa ubbaan lo77obaa oothaaddenne hiyyeesaa maaddaadde de7aw. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","He wode iza harggaade hayqqina, asay izi anhaa meecciide, pooqiyaa pude kessiide gisisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Liiday Yoophphessi mata; kaalliyaawanttu Phexiroosi Lidiyan de7iyaawaa Yoophphen sisiide, “Hayyanaa nuukko ellekka yaarikkii” yaagiyaa kiitaa laa77u asatuwaa bolla aakko kiitteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hewaappe guyye Phexiroosi denddiide, unttunttunna bi gakkina, pooqiyaa pude A kessiide, kifiliyaa gelisseeddino. Asini baynna am77e maccawanttu ubbay yeekkiiddenne Dorqqa unttunttunna de7iyaa wode ootheedda qamishatuwanne mayatuwaa ubbaa Phexiroosa bessiidde, A yuushshuwaan yuuyyi aadhdhiide eqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Phexiroosi unttuntta ubbaa kare kessiide, gulbbati Xoossaa woosseedda; qassi anhaakko simmiide, “Xaabitee, dendda” yaageedda; Xaabitakka bare ayfiyaa dooyya Phexiroosa be7aade, dhoqqa uttaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Phexiroosi izo bare kushiyan maaddiide, denthi esseedda; hewaappe guyyiyan, ammaniyaawanttanne asini baynna am77e maccawantta xeesiide, paxeeddawunno unttunttoo immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ha yewuu Yoophphe katamaa ubbaan laalettina cora asay Godaa ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Phexiroosi Yoophphen itti Simoona giyaa galbbaa qaaciyaawaanna daro wodiyaa gami77eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Qiisaariyaan “Xaalatuwaa Olaa asatuwaa” geetettiyaa olanchchatoo itti xeetatuwaa kaappuu Qornneliyoosa giyaawe de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Qornneliyoosi Xoossaa loythiide ammaniyaa asanne, bare soy asaa ubbaanna ittippe Xoossaassi goyinniyaa asa; Ayihuda hiyyeesaakka I daro maaddee; qassi Xoossaa ubba wode woossee. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Itti gallassi udduppu saatiyaa heeran, “Qornneliyoosa” giide xeesiyaa Xoossaa kiitanchchay barekko gelishshin, Qornneliyoosi saxaan geeshshiide be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Qornneliyoosi yayyiide, kiitanchchaa caddi xeelliide, “Ta Godaw, I ayee?” yaageedda. Kiitanchchay zaariide, hawaadan yaageedda; “Ne woosaynne neeni hiyyeesaa maaddiyawe Xoossaa sinthan hassayettanaw saluwaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ha77i Yoophphe asaa kiittaade, Phexiroosa geetettiyaa Simoona ahissa. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Phexiroosi abbaa doonan de7iyaa galbbaa qaaciyaa Simoona gollen imathatethaani utteedda; neeni oothanaw bessiyaawaa I new odanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Qornneliyoosi barew odeedda kiitanchchay biina, bare qoomatuwaappe laa77atuwaanne Xoossaassi goyinniyaa bareppe shaakettenna wottaaddaratuwaappe ittuwaa xeesiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","unttunttoo ubbabaa odiide, unttuntta Yoophphe kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wonttetha gallassi unttunttu biide, Yoophphe katamaakko matishshin, Phexiroosi usuppun saatiyaa heeran golliyaa bollan dembbayiide ootheeddasaa Xoossaa woossanaw keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Qassi koshattiide, qumaa maanaw koyyeedda; shin qumay ka77ishshin, saxaa be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Saluu dooyettina, wolqqaama mayuwaa malatiyaabay oyddu bagganna oyqettiide, sa7aan wodhdhishshin, Phexiroosi be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Hewaan oyddu gediyaanna de7iyaa mehii, do7ay, shooshshay, zariinne kafuu ubbay de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","“Phexiroosaa, dendda eqqaade shukka ma” giyaa qaalay aakko yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Shin Phexiroosi, “Ta Godaw, hanenna! Taani tunabaanne sheneyiyaabaa ubbakka ma erikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Qassi laa7enthuwaa, “Xoossay geeshsheeddawaa neeni tunissoppa” giyaa qaalay aakko yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Heezzu gede hewaadan geedda; hewaappe guyyiyan, ellekka he wolqqaama mayuwaa malatiyaawe pude saluwaa aketti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Phexiroosi bare be7eedda saxaa bilethay ayaa gidanddeeshsha? Yaagiide, bare wozanaa giddon, “Laa hawe ayee?” giishshin, Qornneliyoosi kiitteedda asatuu Simoona golli de7iyaasaa koyyiidde, A penggiyaan eqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Barenttu kooshshaa dhoqqu oothiide, “Phexiroosa geetettiyaa Simoona giyaa imathay hewaan de7ii?” yaagiide oochcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Phexiroosi saxaan be7eeddabaa akeekanaw qofaan sheekkide7ishshin, Geeshsha Ayyaanay A, “Be7a, heezzu asatuu neena koyyiino; ");
INSERT INTO dwrNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","denddaade wodhdha; Taani unttuntta kiitteedda diraw, sidhennaan unttunttunna ba” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Phexiroosi asatuwaakko wodhdhiide, “Hinttenttu koyyiyaawe taana. Ayaa akkana yeedditee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Unttunttu, “Xoossaassi yayyiyaa xilluu Ayihuda asaa ubbaan daro bonchchetteedda xeetatuwaa kaappuwaa Qornneliyoosi, neena bare soy afissiide, qaalaa neeppe sisana mala, Xoossaa geeshsha kiitanchchay aw odeedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Phexiroosi asatuwaa immatha udi shoobbanaw soy mokkeedda. Wonttetha gallassi, denddiide unttunttunna beedda; Yoophphe katamaan de7iyaa ishatuwaappe ittu ittu aananna ittippe beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wonttetha gallassi, Qiisaariyaa gakkeeddino; Qornneliyoosi bare dabbatuwanne bare laggethatuwaa ittippe xeesi shiishshiide, Phexiroosa naagee. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Phexiroosi gelana hanishshin, Qornneliyoosi aananna gakettiide, A sinthan kunddiide, aw goyinneedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Shin Phexiroosi, “Dendda! Taanikka ta huuphew asa” yaagiide A dentheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Phexiroosi Qornneliyoosanna haasayiidde, soy geleedda; I geliyaa wode cora asay shiiqeeddawaa demmiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","asaa, “Ayihuda asay hara zariyaanna ittippetethaan de7anaw, woy gakettanaw woga gidennawaa hintte huuphew eriita; shin taani oonanne tunaa woy sheneyiyaabaa geenna mala, Xoossay taana besseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hewaa diraw, hintte taw kiittina, palumay baynnaan yaaddi. Ha77i, ‘Taana ayissi ahisseedditee?’ yaagaade hinttentta oochchay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Qornneliyoosi hawaadan yaageedda; “Taani hachche oyddu gallassaappe kase ha saatiyaan udduppu saatiyaa woosaa ta soyin Xoossaa woossishshin, pholqqiyaa mayuwaa mayyeedda asay ta sinthaan eqqiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","taana, ‘Qornneliyoosa, Xoossay ne woosaa siseedda; neeni hiyyeesaa maaddiyaawaakka hassayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Simmi asaa Yoophphe kiittaade, Simooni Phexiroosa giyaawaa xeesissa; Simooni Phexiroosi Simoona giyaa galbbaa qaacciyaawaa gollen abbaa doonaan imathatethaa utteedda’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hewaa diraw, taani neekko ellekka kiittaaddi; neeninne yaadde loythaadda; simmi neeni nuussi odanaw Xoossay neena azazeeddawaa ubbaa sisanaw ha77i nuuni ubbay hawaan Xoossaa sinthan de7eetto” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Phexiroosi haasayaa hawaadan yaagi doommeedda; “Xoossay asaa som77iyaa xeellenna; shin gade ubbaan barew yayyiyaawaanne xillo oosuwaa oothiyaawaa galatiyaawaa taani tumu akeekaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Xoossay asaa ubbaa Godaa, Yesuusi Kiristtoosa bagganna, sarotethaa odiidde, ha wonggalaa mishiraachchuwaa Israa7eeliyaa asaassi kiitteeddawaa hinttenttu eriita. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yohaannisi qaalaa odeedda xinqqataappe guyyiyan, Galiilaappe doommiide, Yihudaa gadiyaa ubbaan haneeddawaa hintte eriita. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xoossay Naazireetiyaa Yesuusa Geeshsha Ayyaanaaninne wolqqaan kuntheedda; Xoossay aananna de7iyaa diraw, lo77obaa I oothiiddinne xalahiyaa kaappuwaassi moodetteedda ubbaa pathiidde yuuyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ayihuda gadiyaaninne Yeerusalaamen I ootheedda ubbabaassi nuuni markka. Unttunttu masqqaliyaa bolla misimaariyan dhishi kaqqiide, A wodheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Shin Xoossay heezzenthiyaa gallassan hayquwaappe A denthiide besseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Xoossay koyro dooreedda markkatuwaa nuuna, A besseeddappe attin, asaa ubbaa gidenna; hayquwaappe I denddeeddawaappe guyyiyan, nuuni aananna meeddonne usheeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Xoossay wonggalaa mishiraachchuwaa asaassi nuuni odanawunne, paxa de7iyaawanttu bollaninne hayqqeeddawanttu bollan pirddanaw I suntheeddawe Yesuusa gideeddawaa nuuni markkattanaw nuuna azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Xoossay aani ammaniyaa ubbaa nagaraa A sunthan atto gaanawaa nabatuu ubbatuu markkattiino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Phexiroosi biro he yewuwaa odishshin, qaalaa sisiyaa ubbaa bolla Geeshsha Ayyaanay wodhdhii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Phexiroosanna Yoophpheppe yeedda, ammaniyaa qaxxaretteedda Ayihuda ubbatuu Ayihuda gidennawanttu bollankka Geeshsha Ayyaanaa imotay gukkeedda diraw maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ayissi gooppe, unttunttu dumma dumma qaalaan haasayishshiininne Xoossaa darotethaa sabbishshin siseeddino. He wode Phexiroosi zaariide, ");
INSERT INTO dwrNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Hawanttu qassi nuunaadan Geeshsha Ayyaanaa akkeeddawanttu xammaqettennaadan, haathaa unttuntta digganaw danddayiyaawe oonee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Unttunttu Yesuusi Kiristtoosa sunthan xammaqettana mala, unttuntta azazeedda; hewaappe guyyiyan, unttunttu barenttunna amareedda gallassaa uttana mala, A woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesuusi kiitteeddawanttunne Yihudaa ubbaan de7iyaa ishatuu, Ayihuda gidennawanttukka Xoossaa qaalaa akkeeddawaa siseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Phexiroosi Yeerusalaame beedda wode, qaxxaretteedda asatuu aananna palumettiidde, ");
INSERT INTO dwrNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","A, “Neeni qaxxarettibeennawanttukko gelaade, unttunttunna qumaa maadda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Shin Phexiroosi haneeddawaa koyruwaappe doommiide, maaran maaran hawaadan yaagiide odeedda; ");
INSERT INTO dwrNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Taani Yoophphe katamaan Xoossaa woossishshin, taani ayyaanaani gidaade saxaa be7aaddi; wolqqaama mayuwaa malatiyaawe oyddu bagganna oyqettiide, saluwaappe wodhdhiide, taakko yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Hewaa gidduwaa taani cadda xeelliyaa wode, oyddu gedi de7iyaa mehiyaa, du7aa, shooshshaa, zariyaanne kafuwaa be7aaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Qassi, ‘Phexiroosaa, dendda; shukka ma’ giyaa qaalaa taani sisaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Shin taani, ‘Ta Godaw, hanenna! Tunabay woy sheneyiyaabay ubbakka ta doonaakko shiiqi erenna’ gaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Qaalay saluwaappe laa7ethuwaakka, ‘Xoossay geeshsheeddawaa neeni tunaa gooppa’ yaagiide taw zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Hewe heezzu gede hanina, wurssethaan ubbabay saluwaa pude gooshetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","He man77iyankka heezzu asatuu Qiisaariyaappe taakko kiitettiide, taani de7iyaa golliyaa gakki aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Taanikka sidhennaani unttunttunna baana mala, Geeshsha Ayyaanay taw odeedda. Qassi ha usuppun ishatuu Yoophpheppe taananna Qiisaariyaa biina, nuuni Qornneliyoosa soy geleeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","14","Kiitanchchay bare soyin eqqiide barena, ‘Phexiroosa geetettiyaa Simoona xeesanaw asaa Yoophphe kiitta; neeninne ne golle asay ubbay attiyaa qaalaa I new odanawaa’ geeddawaa Qornneliyoosi wooti siseeddentto, nuussi odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Taani haasayanaw doommiyaawan Geeshsha Ayyaanay koyro nu bolla wodhdheeddawaadan, unttunttu bollaakka wodhdhii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Goday, ‘Yohaannisi haathaan xammaqeedda; shin hinttenttu Geeshsha Ayyaanaan xammaqettanita’ yaageedda qaalaa taani hassayaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Xoossay nuussi Godaa Yesuusi Kiristtoosa ammaneeddawanttussi immeedda imotaa malaa Ayihuda gidennawanttookka qassi immooppe, simmi Xoossaa digganaw taani oonee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Unttunttu hawaa siseedda wode barenttu palumaa aggiide, “Yaatina, Xoossay Ayihuda gidennawanttukka qassi nagaraappe simmiide de7anaadan, unttuntta qaadeedda” yaagiide Xoossaa galateeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Isxxifaanoosa bolla gakkeedda waayyiyaa geeduwan laaletteedda ammaniyaawanttu qaalaa Ayihudatuwaa xalalaappe attin, haraassi ittuwaassinne odennaan, Pinqqe, Qophiroosanne Anxxookiyaa gakkanaw yuuyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Shin Qophiroosappenne Qereenappe yeedda itti itti ammaniyaa asatuu Anxxookiyaa biide, Godaa Yesuusa wonggalaa mishiraachchuwaa odiidde, Giriike asaassikka odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Godaa wolqqay unttunttunna de7ee; qassi cora asay ammaniide, Godaakko simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ha yewuu Yeerusalaamen de7iyaa ammaniyaa asaassi sisettina, ammaniyaa asay Barnaabaasa Anxxookiyaa kiitteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnaabaasi Anxxookiyaa beedda wode, Xoossaa aadho keekatethaa oosuwaa be7iide nashetteedda; unttunttu ubbay Godan barenttu kumentha wozanaappe minni de7anaadan, unttuntta zoreedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ayissi gooppe, Barnaabaasi Geeshsha Ayyaanaynne ammanuu kumeedda lo77o asaa; he gaasuwan cora asay Godaakko yeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hewaappe guyyiyan, Barnaabaasi Saa7oola koyyanaw Xersseese beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Yaatiide Saa7oola demmeedda wode, Anxxookiyaa aheedda. Barnnaabaasinne Saa7ooli ammaniyaa asaanna itti laythaa kumenthaa uttiide, cora asaa tamaarisseeddino; kaalliyaawanttu Anxxookiyan Ammaniyaa asaa geetettiide, koyro xeesetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nabatuu Yeerusalaameppe Anxxookiyaa he wode wodhdheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Unttunttu giddoppe Agaaboosa giyaawe denddiide, sa7aa ubbaan wolqqaama koshay denddanawaa Ayyaanaa wolqqaan timbbitiyaa odeedda; hewe haneeddawe Qalawudeyoosa kawutethaa wodiyaana. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kaalliyaawanttu huuphiyan huuphiyan barenttu wolqqaa keena miishshaa kessiide, Yihudaan de7iyaa barenttu ishatuwaassi maaduwaa yeddanaw qofaa qachcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Unttunttu hewaadan oothiide, miishshaa Barnaabaasa bollaninne Saa7oola bolla woosa golle cimatoo yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kaatiyaa Heroodise he wode woosa golle asaappe amareeddawantta waayissuwaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yohaannisa ishaa Yayiqooba mashshaan wodhisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hewe Ayihudatuwaa nashechcheeddawaa be7iide, gujji Phexiroosakka oyqqeedda; hewe Maagage Ukithaa Baalaa bonchchiya gallassatuwana. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Phexiroosa oyqqiide qachcheedda. Paasigaa Baalaa Bonchchiya gallassatuwaappe guyyiyan, gade asaa sintha aathanaw qoppiide, oyddu oyddu wottaaddaratuu A naaganaadan, tammanne usuppun wottaaddaratuwaassi aathiide immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hewaa diraw, Phexiroosi qasho golliyaan naagettee; shin woosa golle asay aw minissiide Xoossaa woossee. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Heroodise Phexiroosa asaa sintha aathanaw qoppanaappe kase qamma, Phexiroosi laa77u santhalataan qashettiide, laa77u wottaadaratuwaappe gidduwan gemi77isheedda; naagiyaawanttukka qasho golle penggiyaan eqqiide naagiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Akeekennaan de7ishshin, Godaa kiitanchchay hewaan eqqi aggeedda; qasho gollenkka poo7uu poo7ii aggeedda. Kiitanchchay Phexiroosa miyyiyaa dechchi beegothiide A, “Elle dendda” yaageedda; he man77iyankka santhalatay A kushiyaappe wodhdhii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kiitanchchay A, “Ne suriyaa dancca; ne caammaakka wotha” yaagina, Phexiroosi hewaadan ootheedda; kiitanchchay, “Ne mayuwaa mayyaade taana kaalla” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Phexiroosi qasho golliyaappe kesiide, kiitanchchaa kaalleedda; aw saxaa be7iyaawaa malateeddappe attin, kiitanchchay oothiyaabay tuma gideeddawaa eribeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kiitanchchaynne Phexiroosi koyro wottaaddaraappenne laa7entho wottaaddaraappe aadhdhiide, katamaa afiyaa birataa penggiyaakko gakkeeddino; penggiikka unttunttoo barekka dooyetti aggeedda; unttunttu kesiide itti ogiyaanna biishshin, kiitanchchay ellekka Phexiroosappe shaaketti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Phexiroosi barena gakkeeddabaa akeekiide, “Taana Goday bare kiitanchchaa kiittiide, Heroodisa kushiyaappenne Ayihuda asay naagi utteedda ubbabaappe ashsheeddawaa ha77i tumu eraaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","I hewaa akeekeedda wode, cora asay ittippe shiiqiide Xoossaa woossiyaasaa, Marqqoossa giyaa Yohaannisa dayi Mayraami soy ");
INSERT INTO dwrNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","biide penggiyaan xeesina, itti Roodo giyaa ashikkaratta dooyyanaw yaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Rooda Phexiroosa qaalaa gideeddawaa ereedda wode, barena nashechchina, penggiyaa dooyyennan guyye woxxaadde, Phexiroosi karen eqqeeddawaa asaassi odaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Asay izo, “Hanne, neeni gooyaa” yaageedda. Rooda Phexiroosa gideeddawaa geeshshaade odaaddu. Unttunttu, “Hewe A kiitanchchaa” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Shin Phexiroosi karen xeesiide aggennaan ixxina, asay kariyaa dooyyi, A be7iide maalaletteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Shin unttunttu co77u gaana mala, Phexiroosi bare kushiyan xorssiide, Goday qasho golliyaappe A wooti kesseeddentto, unttunttoo qonccissi odiide, “Hawaa Yayiqoobassinne ishatuwaassi odite” giide, kesi harasaa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sa7ay wontteedda wode, Phexiroosi haqa bidiggeeddentto giina wottaaddaratuwaa giddon daro walassay keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroodise Phexiroosa koyyishshin, I dhayeedda wode, naagiyaawantta qoriide, unttuntta wodhana mala azazeedda; hewaappe guyyiyan, Yihudaappe Qiisaariyaa wodhdhiide, hewaan amareedda wodiyaa utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heroodise Xiiroosa asaassinne Sidoonaa asaassi loythi hanqqetteedda; unttunttu gade asay kathaa Heroodisa gade asaappe demmiyaa diraw, unttunttu ittippe gidiide, A golliyaa kaappuwaa Bilasxxoosa barenttu bagga oothiide, sigettana mala woossanaw Heeroodisakko beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Heroodise sunthetteedda gallassi, bare kawutethaa mayuwaa mayyiide, kawutethaa oydiyan uttiide, asaassi haasayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Asay, “Hawe Xoossaa qaalaa; asaa qaalaa gidenna” yaagiide kooshshaa dhoqqisside haasayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Heroodise Xoossaa bonchchibeenna diraw, he man77iyankka Godaa kiitanchchay A dechchina, guxuniyan meetettiide, hayqqi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Shin Xoossaa qaalay dicceenne dar dar bee. ");
INSERT INTO dwrNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnnaabaasinne Saa7ooli barenttu oosuwaa poliide, Marqqoossa giyaa Yohaannisa barenttunna akkiide, Yeerusalaameppe simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anxxookiyan de7iyaa ammaniyaa asaa giddon nabatuunne tamaarssiyaawanttu de7iino; unttunttukka Barnaabaasa, Karethaa giyaa Simoona, Qereenappe yeedda Luuqiyoosa, gadiyaa mooddiyaa Heroodisanna dicceedda Minaahanne Saa7oola. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Unttunttu Godaassi goyinnishshinanne xoomishshin, Geeshsha Ayyaanay, “Taani xeeseedda oosuwaassi Barnnaabaasanne Saa7oola taw dummayite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Unttunttu xoomeeddawaappenne woosseeddawaappe guyyiyan, barenttu kushiyaa Barnaabaasa bollaninne Saa7oola bollan wothiide, unttuntta yeddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Hewaa diraw, Geeshsha Ayyaanay unttuntta kiittina, Seeluuqiyaa wodhdheeddino; hewaappe wonggiriyaan geliide, Qophiroosa haathaani doodetteeddasaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Unttunttu Silmaana gakkiide, Ayihuda woosa golletuwaan Xoossaa qaalaa odeeddino; unttuntta maaddanaw Yohaannisi unttunttunna de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Unttunttu Qophiroosa haathaan doodetteedda sa7aa ubbaa Phaafu gakkanaw yuuyyiide, nabiyaa itti worddanchchaa, Ayihuda asaa Bar-Yesuusa giyaa shareechchuwaa demmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","He sharechchuu gadiyaa mooddiyaa Sarggiyoosa Phawuloosa giyaa akeekanchcha bitaniyaanna de7ee. Sarggiyoosa Phawuloosa Barnnaabaasanne Saa7oola barekko xeesiide, Xoossaa qaalaa sisanaw koyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Shin shareechchuwaa Elimaasi (Giriike qaalaan hewe A sunthaa) gadiyaa mooddiyaawaa ammanuwaa digganaw koyyiide, unttunttu haasayaa phalqqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Shin Phawuloosa giyaa Saa7ooli barenan Geeshsha Ayyaanay kumina, shareechchuwaa caddi xeelliide, ");
INSERT INTO dwrNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","A, “Laa ha xalahiyaa kaappuwaa na7aw, genetethay ubbaynne iitatethay ubbay kumeeddawoo, xillotethaa ubbaa morkkew, Godaa ogiyaa suuriyaa geellayiyaawaa aggikkii? ");
INSERT INTO dwrNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Be7a; ha77i Godaa kushii ne bolla de7ee; neeni qooqa gidana; amareedda wodii gakkanaw, awaa poo7uwaa be7akka” yaageedda. He man77iyankka shaannochchaynne dhumay A ayfiyaa goozzina, bare kushiyaa oyqqiide, kaalethiyaa uraa koyyiidde yuuyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","He wode gadiyaa mooddiyaawe hewaa be7eedda wode, Goday tamaarissiyaawaan maalalettiide ammaneedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Phawuloosinne aananna de7iyaawanttu Phaafuppe denddiide, Phinifiliyan de7iyaa Phergge wonggiriyaan beeddino; Yohaannisi unttunttuppe shaaketti, Yeerusalaame simmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Shin unttunttu Pherggeppe aadhdhiide, Phiisiidiyan de7iyaa Anxxookiyaa gakkeeddino; Sambbata gallassan Ayihuda woosa golle geliide utteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Muse higgiinne nabatuwaa maxaafay nabbabetteeddawaappe guyyiyan, Ayihuda woosa golle kaappatuu, “Nu ishatoo asaa minissiyaa qaalay hinttenttoo de7ooppe, asaw haasayeerikkitee” yaagiide unttunttoo kiitteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Phawuloosi denddi eqqiide, bare kushiyan xorssiide, hawaadan yaageedda; “Israa7eeliyaa asatoo, Xoossaassi yayyiyaawanttoo sisite. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ha Israa7eeliyaa asaa Xoossay nu aawatuwa dooriide, Gibxe gadiyan imathatethaan unttunttu de7ishshin, unttuntta corisseedda; bare wolqqaama wolqqaanikka Gibxe gadiyaappe unttuntta kesseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Bazzuwan oytamu laythaa keenaa nu aawatuwa I danddayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanaane giyaa gadiyan Ayihuda gidenna laappu kawutethaa dhayissiide, unttunttu gadiyaa bare asaa laatisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Hewaappe guyyiyan, nabiyaa Saameela wodiyaa gakkanaassi, oyddu xeetanne ishatamu laythaa keenaa daannatuwaa unttunttoo immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Hewaappe guyyiyan, unttunttu barenttoo kaatiyaa immana mala woossina, Xoossay Biiniyaama zariyaappe Qiisa na7aa Saa7oola oytamu laythaw kawutana mala, unttunttoo immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Xoossay Saa7oola shaareeddawaappe guyyiyan, unttunttu bolla Daawite kawutana mala, A dentheedda; Daawitebaa markkattiidde, ‘Taani koyyiyaa ubbabaa ta wozanaadan oothiyaa Issey na7aa Daawita demmaaddi’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Xoossay, ‘Taani Daawita zariyaappe Israa7eeliyaa asaa ashshiyaawaa ahana’ qaalaa geleeddawaadankka, Yesuusa aheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesuusi yaanaappe kase Israa7eeliyaa asay ubbay barenttu nagaraappe simmiide xammaqettana mala, Yohaannisi qaalaa odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Qassi Yohaannisi bare oosuwaa wurssana haniidde asaa, ‘Taana oona giide qoppiitee? Taani hintte naagiyaawaa gidikke; shin be7ite, A gediyaa caammaa qashuwaakka gediyaappe billanaw taw bessennawe taappe guyyenna yee’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Taanaadan ammaniyaawanttoo, Abraahaame zerethatoo, qassi hawaan Ayihuda gidennawanttoo Xoossaassi yayyiyaawanttoo, ha atotethaa qaalay nuussi kiitetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ayissi gooppe, Yeerusalaamen de7iyaa asaynne unttunttu kaappatuu Yesuusanne Sambbata gallassaa ubbaan nabbabettiyaa nabatuwaa qaalaa akeekibeenna diraw, A bolla pirddiide, nabatuwaa qaalaa poleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yesuusa wodhissanaw itti gaasuukka unttunttoo beettennaan ixxina, Philaaxoosi A wodhana mala woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Unttunttu Yesuusabay Xoossaa Maxaafan xaafetteeddawaa ubbaa poleedda wode, masqqaliyaappe A wothiide moogeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Shin Xoossay hayquwaappe Yesuusa dentheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Hewaappe guyyiyan I barenanna Galiilaappe Yeerusalaame yeedda asatoo cora gallassaa beetteedda unttunttu ha77i aabaa asaassi markkattiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Xoossay nu aawatuwassi immana geedda wonggalaa mishiraachchuwaa nuuni hinttenttoo odeetto. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Daawite Mazimuriyaa Maxaafaan laa7etho shemppuwaan, ‘Neeni Ta Na7aa. Hachche Taani ne Aawuwaa gidaaddi’ geetettiide xaafetteeddawaadan, Xoossay Yesuusa denthiide, nu aawatuwassi immana geeddawaa nuussi unttunttu naanaassi poleedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Laa7enthuwaa I hayqqenna mala, hayquwaappe A dentheeddawaassi Xoossay, ‘Taani Daawitew immana geedda ammanetteedda geeshsha anjjuwaa hinttenttoo immana’ yaagiide haasayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hewaa diraw, Mazimuriyaa Maxaafaan harasaan qassi, ‘Ne Geeshsha Na7aa anhaakka musissakka’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ayissi gooppe, Daawite bare wodiyaan Xoossaa qofaa ootheeddawaappe guyyiyan hayqqiide, bare aawatuwanna hayqqi museedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Shin Xoossay hayquwaappe dentheeddawe musibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Hewaa diraw, taanaadan ammaniyaawanttoo, nagaraa atto geetetteeddawe hinttenttoo Yesuusa bagganna odetteeddawenne, Muse higgiyan xillanaw hinttenttoo danddayettenna ubbabaappe aani ammaniyaa ubbay xillanawe hinttenttoo eretto. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Hewaa diraw, nabatuu geeddawe hintte bolla gakkenna mala naagettite; ");
INSERT INTO dwrNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Xoossay geeddabaa qilliicciyaawanttoo, be7ite; haray atto itti uray hinttenttoo odinttokka, hintte ammanenna oosuwaa taani hinttenttu wodiyaan oothiyaa diraw, poora giite; hayqqite’ geeddino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Phawuloosinne Barnaabaasi Ayihuda woosa golliyaappe kesishshin, asay unttuntta laa7enthuwaa Sambbatankka hewaa gujjiide odana mala woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Shiiquu laaletteeddawaappe guyyiyan, cora Ayihudatuunne Ayihudatuwaa ammanuwan geliide Xoossaw yayyiyaa coratuu, Phawuloosanne Barnaabaasa kaalleeddino; Yesuusi kiitteeddawanttu Xoossaa aadho keekatethaan minni de7ana mala, unttunttoo odiide minisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Laa7enthuwaa Sambbataan amareedda asatuwaappe attin, katamaa asay ubbay Xoossaa qaalaa sisanaw shiiqeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Shin Ayihudatuu cora asaa be7eedda wode, Phawuloosa qanaateeddino; A haasayaa phalqqiide, A boreeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Phawuloosinne Barnaabaasi xaliide, “Xoossaa qaalay kasetiide hinttenttoo odettanaw koshshee; shin qaalaa hintte ixxeedda dirawunne medhinaa de7uwaa akkanaw hinttenttoo bessenna giide, hintte hinttenttu huuphiyan pirddeedda diraw, be7ite, nuuni Ayihuda gidennawanttukko simmeetto. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ayissi gooppe, Goday nuuna, “ ‘Asay ubbay hintte bagganna attana mala, hinttentta taani Ayihuda gidennawanttoo poo7uwaa oothaaddi’ yaagi azazeedda” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ayihuda gidennawanttu hewaa siseedda wode, nashettiide Xoossaa qaalaa bonchcheeddino; qassi medhinaa de7uwaassi dooretteedda ubbay ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Godaa qaalay he gadiyaa ubbaa gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Shin Ayihudatuu Xoossaw goyinniyaa bonchchetteedda maccawanttanne katamaan de7iyaa wolqqaama asatuwaa Phawuloosa bollaninne Barnaabaasa bolla denthethina, asatuu unttuntta yederssuwaa doommiide, barenttu gadiyaappe keseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Shin Yesuusi kiitteeddawanttu unttuntta ixxiyaawanttussi malaata gidana mala, barenttu gediyaappe baanaa shociide, Iqooniyoone katamaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Qassi Anxxookiyan de7iyaa kaalliyaawanttunikka Geeshsha Ayyaanaynne nashechchay kumeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kasewaadankka Phawuloosinne Barnaabaasi Iqooniyoonen Ayihudatuwaa woosa golle geliide, qaalaa odeeddino; hewaappe guyyiyan cora Ayihudatuunne Ayihuda gidennawanttu ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Shin ammanibeenna Ayihudatuu Ayihuda gidennawanttu wozanaa laammiide, ishatuwaa bolla hanqqetheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Yesuusi kiitteeddawanttu hewaan daro wodiyaa gami77eeddino; unttunttu Godaabaa yayyennaan odeeddino; Goday malaataanne oorathabaa unttunttu oothana mala, unttunttoo wolqqaa immeeddawaan bare aadho keekatethaa qaalaabay tuma gideeddawaa markkatteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Shin katamaa asay shaaketti, baggay Ayihudatuwakko, baggay Yesuusi kiitteeddawanttukko simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ayihuda gidennawanttunne Ayihudatuu barenttu kaappatuwaanna ittippe Yesuusi kiitteeddawantta qohanawunne shuchchan caddanaw qoppeedda wode, ");
INSERT INTO dwrNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Yesuusi kiitteeddawanttu hewaa eriide, Lisxxiraanne Derbbe geetettiyaa Liqaa7ooniyaa katamatuwaanne unttunttu heeran de7iyaa gadiyaa bii aggeeddino; ");
INSERT INTO dwrNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","hewaan wonggalaa mishiraachchuwaa odiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Bare dayi uluwaappe yelettoodeppe doommiide, laa77u gedi silina, ubbakka hamettenna itti bitani Lisxxiraan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","He bitani Phawuloosi odishshin sisee; Phawuloosi A caddi xeelliyaa wode, paxanaw aw ammanuu de7iyaawaa be7iide, ");
INSERT INTO dwrNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","kooshshaa dhoqqissiide A, “Sitti gaade ne gediyaan eqqa” yaageedda; guppi denddiide, hametaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Phawuloosi ootheeddawaa asay be7iide, bare kooshshaa Liqaa7ooniyaa qaalaan dhoqqu oothiide, “Xoossatuu asaa malatiide nuukko wodhdheeddino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Asay Barnaabaasa, “Diyaa” giide, Phawuloosi haasayaassi waannatiyaa diraw, A, “Hermeesa” giide suntheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Geeshsha Golli katamaa matan de7iyaa Diyaa qeesaynne asay korumatuwaanne darii lo77iyaa ciishshatuwaa Yesuusi kiitteeddawanttussi yarshshuwaa yarshshanaw koyyiide, penggiyaa aheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Shin Yesuusi kiitteedda Barnnaabaasinne Phawuloosi hewaa siseedda wode barenttu mayuwaa peedhiide, asaa giddo woxxiidde, ");
INSERT INTO dwrNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","barenttu kooshshaa dhoqqu oothiide, hawaadan yaageeddino; “Asaw, hawaa ayissi oothiitee? Nuunikka hinttenttuwaadan medhetteedda asaa; ha pathenna yewuwaappe saluwaanne sa7aa, abbaanne unttunttu giddon de7iyaa ubbabaa medhdheedda de7uwaa Xoossaakko hintte simmana mala, hinttenttoo nuuni wonggalaa mishiraachchuwaa odeetto. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","I beni asaa zerethay ubbay barenttu ogiyaa baana mala yeddii aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hinttenttoo iraa saluwaappe bukisseedda; kathaakka I wodiyaan immeedda; qassi qumaa immiide, hinttentta loythi nashechchee; yaatiide hinttenttoo lo77obaa oothiide, ubba wodekka barew markkaa dhayibeenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yesuusi kiitteeddawanttu hewaa giide, barenttoo asay yarshshenna mala, metootiide diggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Anxxookiyaappenne Iqooniyooneppe yeedda Ayihudatuu asaa barenttu bagga zaariide, shuchchan Phawuloosa caddeeddino; unttunttoo hayqqeeddawaa malatina, katamaappe karew A goochchi kesseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Shin kaalliyaawanttu A matan yuuyyi aadhdhiide eqqishshin, I denddiide, katamaa geleedda. Wonttetha gallassi Barinabaasanna ittippe Derbbe beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","22","Unttunttu Deribe katamaan wonggalaa mishiraachchuwaa odiide, cora asay Yesuusa ammanana mala ootheeddawaappe guyyiyan, Lisxxiraa, Iqooniyoonenne Phiisiidiyan de7iyaa Anxxookiyaa simmeeddino; yaatiide hewaan kaalliyaawantta minissiiddenne unttunttu ammanuwan minni de7ana mala zoriidde, “Nuuni Xoossaa kawutethaa gelanaw loythi waayyettana bessee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Qassi ammaniyaawanttoo de7iyaasan de7iyaasan cimatuwaa dooriide, xoomeeddawaappenne woosseeddawaappe guyyiyan, unttunttu ammaneedda Godaassi unttuntta hadaraa immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Phiisiidiyaa gadiyaappe aadhdhiide, Phinifiliyaa yeeddino; ");
INSERT INTO dwrNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pherggen qaalaa odeeddawaappe guyyiyan, Axaaliyaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Hewaappe unttunttu barenttu poleedda oosuwaa diraw, asay unttunttu hadaraa Xoossaa aadho keekatethaw immeedda Anxxookiyaa Markkabiyan simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anxxookiyaa gakkeedda wode ammaniyaa asaa shiishshiide, Xoossay barenttunna ittippe ootheedda ubbabaanne, Ayihuda gidenna asay ammanana mala, unttunttoo penggiyaa dooyyeeddawaa, asaw odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Yaatiide hewaan kaalliyaawanttunna daro wodiyaa gami77eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Itti itti asatuu Yihudaappe Anxxookiyaa wodhdhiide, “Muse wogaadan, hintte qaxxarettennawaa gidooppe, attanaw danddaykkita” yaagiide ishatuwaa tamaarissuwaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Phawuloosinne Barnaabaasi unttunttunna darissi walaqettiide palumettina, Anxxookiyan de7iyaa itti itti hara asatuu he palumaa diraw, Phawuloosannanne Barinabaasanna Yeerusalaame biide, Yesuusi kiitteeddawanttunnanne cimatuwaanna gakettanaw qofay qashetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ammaniyaa asatuu unttuntta kiittiide ogiyaan maaddishshin, Ayihuda gidennawanttu Xoossaakko simmeeddawaa odiidde, Pinqqiyaannanne Sammaariyaanna aadhdheeddino; hewe ishatuwaa ubbaa loythi nashechcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Unttunttu Yeerusalaame gakkeedda wode, ammaniyaawanttu, Yesuusi kiitteeddawanttunne cimatuu unttuntta mokkeeddino; Xoossay barenttun ootheeddawaa ubbaa odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Shin Parisaawatuwaa baggappe ammaneedda itti itti asatuu denddi eqqiide, “Hinttenttu unttuntta qaxxaranawunne Muse higgiyaa naagana mala azazanaw bessee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yesuusi kiitteeddawanttunne cimatuu hewaa zorettanaw shiiqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Loythi haasayeeddawaappe guyyiyan, Phexiroosi denddi eqqiide, unttuntta hawaadan yaageedda; “Taanaadan ammaniyaawanttoo, Ayihuda gidennawanttu wonggalaa mishiraachchuwaa qaalaa ta doonaappe sisiide ammanana mala, taana Xoossay hintte giddoppe beni dooreeddawaa hinttenttu eriita. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Asaa wozanaa eriyaa Xoossay Geeshsha Ayyaanaa nuussi immeeddawaadan, unttunttookka immiide tumayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Unttunttu ammaneedda diraw, I unttunttu wozanaa geeshshiide, nu gidduwaaninne unttunttu gidduwan dummatethaa wothibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hewaa diraw, nu aawatuunne nuuni tookkanaw danddayibeenna wolqqaama tookuwaa kaalliyaawanttu morggiyan wothiide, ha77i hintte ayissi Xoossaa paacciitee? ");
INSERT INTO dwrNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Shin Godaa Yesuusi Kiristtoosa aadho keekatethaan unttunttu atteeddawaadan, nuunikka atteeddawaa ammaneetto” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Asay ubbay co77u giide, Barnnaabaasinne Phawuloosi Ayihuda gidenna asaa giddon barenttu bagganna Xoossay ootheedda malaataanne oorathabaa ubbaa odishshin sisee. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Unttunttu haasayaa wursseeddawaappe guyyiyan, Yayiqoobi hawaadan yaagiide zaareedda; “Ishatoo, taani giyaawaa sisite. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Xoossay Ayihuda gidennawanttu giddoppe barew haniyaa asaa akkanaw Ayihuda gidennawanttoo koyro wooti qoppeeddentto Simooni odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","18","Nabiyaa qaalay hawaanna giigee; Goday daro wodiyaappe doommiide, asaa hawaa erissiide, Xoossaa Maxaafan hawaadan yaageedda; ‘Hawaappe guyyiyan, sa7aan de7iyaa hara asay ubbaynne tawaa gidanaw taani xeeseedda Ayihuda gidenna asay ubbay Godaa koyyana mala, taani simmana. Taani kolettiide kunddeedda golliyaadan haneedda Daawite kawutethaa denthana. Koletteeddawaakka zaaraade keexxana; taani laa7ethuwaa A essana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Hewaa diraw, ta qofaa gidooppe, Ayihuda gidennawanttuppe Xoossaakko simmiyaawantta nuuni metothanaw koshshenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Shin unttunttu eeqaani tuneeddawaa meenna mala, woshummenna mala, bakuteedda mehiyaa ashuwaa meenna malanne suuthaa ushenna mala, unttunttoo nuuni dabidaabbiyaa xaafanaw koshshee. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ayissi gooppe, Muse higgiyaa kase yeletaappe doommiide Sambbataan Sambbataan Ayihuda woosa golletuwaan nabbabiidde, A qaalaa katamaa ubbaan odiyaawanttu de7iino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hewaappe guyyiyan, Yesuusi kiitteeddawanttunne cimatuu woosa golle asaa ubbaanna ittippe barenttu giddoppe amareedda asatuwaa dooriide, Phawuloosannanne Barinabaasanna Anxxookiyaa yeddanaw qofaa qachcheeddino; unttunttu daro bonchchetteedda laa77u asatuwaa Barssaabaa geetettiyaa Yihudaanne Sillaasa dooreeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yaatiide hawaadan giyaa dabidaabbiyaa xaafiide, unttunttu bolla kiitteeddino; “Nuuni Yesuusi kiitteeddawanttunne cimatuu hintte ishatuu, Anxxookiyan, Sooriyaaninne Kilqqiyaan de7iyaa Ayihuda bagga gidenna ishatuwaassi nu sarotaa kiitteetto. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Nuuni azazibeenna asatuu nu giddoppe biide, ‘Hinttenttu qaxxarettanawunne Muse higgiyaa naaganaw bessee’ giide, hinttentta metootheeddawaanne yiloyeeddawaa sisiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","nu Godaa Yesuusi Kiristtoosa sunthaa diraw, barenttu shemppuwaa oleedda nuuni siiqiyaa Barnnaabaasannanne Phawuloosanna dooretteedda asatuwaa hinttenttukko kiittanaw itti wozanaan nu qofaa qachcheeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Hewaa diraw, nuuni xaafeeddawaa unttunttu barenttu huuphew barenttu doonaan hinttenttoo odana mala, Yihudaanne Sillaasa kiitteeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","“Ayissi gooppe, eeqaw yarsheeddawaa mooppite; suuthaa ushoppite; bakuteedda mehiyaa ashuwaa mooppite; woshummoppite. Ha koshshiyaawanttuppe attin, hara deexiyaa yewuwaa hinttentta toossenna mala, nuuninne Geeshsha Ayyaanay yewuwaa eeno giide akkeeddo; ha ubbabaappe hintte huuphiyaa naagooppe, hinttenttu lo77obaa oothiita. Simmi saro de7ite” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Hewaa diraw, kiitetteeddawanttu moyizzetti, Anxxookiyaa wodhdhiide, ammaniyaa asaa shiishshiide, dabidaabbiyaa asaassi immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Unttunttu he minissiyaa dabidaabbiyaa nabbabeedda wode, nashetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Qassi Yihudaynne Sillaase barenttu huuphew nabatuwaa gidiyaa diraw, ishatuwaa loythi maqqiide minisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Unttunttu Anxxookiyan amareedda gallassaa utteeddawaappe guyyiyan, ishatuu sarotethaan moyizzina, barentta kiitteeddawanttukko simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Shin Sillaase yaani attanaw bare qofaa qachcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Qassi Phawuloosinne Barnaabaasi hara cora asatuwaanna ittippe Godaa qaalaa tamaarissiiddenne wonggalaa mishiraachchuwaa odiidde, Anxxookiyan utteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Amareedda gallassaappe guyyiyan, Phawuloosi Barnaabaasa, “Nuuni Godaa qaalaa odeedda katamaa ubbaan nu ishatuu wooti de7iinontto, guyye simmiide, xomoosi be7oytte” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Hewaappe guyye Barnaabaasi Marqqoossa geetettiyaa Yohaannisa barenttunna afanaw koyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Shin Phawuloosi Marqqoossa barenttunna afanaw koyyibeenna; ayissi gooppe, I unttunttuppe Phinifiliyan shaaketteedda; qassi unttunttunna oosuwaassi bibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Unttunttu gidduwan lo77enna walassay kesina, ittu ittuwaappe shaaketteedda; Barnaabaasi Marqqoossa akkiide, markkabiyaan Qophiroosa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Shin Phawuloosi Sillaasa akkina, ishatuu A hadaraa Xoossaa aadho keekatethaw immeeddawaappe guyyiyan beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Yaatiide ammaniyaa asatuwaa minissiide, Sooriyaannanne Kilqqiyaanna aadhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Phawuloosi qassi Derbbenne Lisxxiraa beedda; hewaan Ximootoosa geetettiyaa kaalliyaawe, itti ammaniyaa Ayihuda mishiratti na7ay de7ee; A aabbu Giriike asa. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lisxxiraaninne Iqooniyoonen de7iyaa ishatuu Ximootoosabaa loythi markkatteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Phawuloosi Ximootoosa barenanna afanaw koyyiide, A aabbu Giriike asa gideeddawaa hewaan de7iyaa Ayihuda ubbay eriyaa diraw, A oyqqiide qaxxareedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Unttunttu katamatuwaanna biidde, Yesuusi kiitteedda Yeerusalaamen de7iyaawanttunne cimatuu wotheedda higgiyaa ammaniyaawanttu naagana mala, unttunttoo odiidde aadhdheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hewaa diraw, ammaniyaawanttu ammanuwan minni, payduwankka gallassaappe gallassan dari dari beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Iisiyan qaalaa odenna mala, Geeshsha Ayyaanay unttuntta diggeedda diraw, Pirggiyaa gadiyaannanne Galaatiyaa gadiyaanna aadhdheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Unttunttu Miisiyaa zawaa gakkeedda wode, Biitiiniya baanaw koyyeeddino; shin Yesuusa Ayyaanay unttuntta diggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hewaa diraw, unttunttu Miisiyaa mataanna aadhdhiide, Xiro7aadaa wodhdheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Phawuloosi qamma saxaan itti Maqidooniyaa bitani barena, “Maqidooniyaa pinnaade nuuna maaddaarikkii” yaagiidde eqqi woossishshin be7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Saxaa I be7eeddawaappe guyyiyan, nuuni ellekka Maqidooniyaa baanaw koyyeeddo; ayissi gooppe, wonggalaa mishiraachchuwaa yaani de7iyaa asaassi odanaw, Xoossay nuuna xeeseeddawaa nuussi malateedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hewaa diraw, Xiro7aadappe denddiide, sitti giide markkabiyaan Saamootiraaqe beeddo; wonttetha gallassi Naaphphule beeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Hewaappe Piliphphisiyoosa beeddo; Piliphphisiyoosi Maqidooniyaa biittaw huuphe katamaa; qassi Roome asay de7iyaa katamaa; nuuni he katamaan amareedda gallassaa utteeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sambbata gallassi, katamaappe gaxaan shaafaa doonaan Ayihudatuu Xoossaa woossiyaa sa7ay de7iyaawaa akeekiide beeddo; hewaan uttiide shiiqeedda macca asaassi qaalaa odeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Itti Liidiyaa geetettewunna, Tiyaaxiroona katamaappe yaade Xoossaa ammanewunna, zo7o mayuwaa zali77iyaa mishiratta, nuuni odiyaawaa sisaaddu; Phawuloosi odiyaawaakka iza sisana mala Xoossay I wozanaa doyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Liidiyaa bare soy asaanna ittippe xammaqetteeddawaappe guyyiyan nuuna, “Hinttenttu taana Godaa tumatethaan ammanaw giide qoppooppe, ta soyin de7ishshite” gaade woossaaddu; minissaade shoobbaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nuuni Xoossaa woossiyaasaa biishshin, iita ayyaanay izi bolla aqina kaayiyaa itti ashikkare naatta nuunanna gakettaaddu; he naatta kaayaade daro miishshaa bare godatuwaassi demmaaddu. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Gakettaade Phawuloosanne nuuna kaallaadde, “Hawanttu hinttenttoo attana ogiyaa odiyaawanttu, Ubbaappe Bolla Xoossaa aylletuwaa” gaade kooshshaa dhoqqu oothaade haasayaw. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ubba gallassi hewaadan gaw; shin Phawuloosi yilotiide guyye simmi, he iita ayyaanaa, “Neeni iippe kesana mala Yesuusi Kiristtoosa sunthan neena azazay” yaageedda; he man77iyankka iita ayyaanay iippe kesi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Shin izi godatuu barenttu miishshaa demmana ogii dhayeeddawaa be7iide, Phawuloosanne Sillaasa oyqqiide, geyaa sa7aan de7iyaa daannatuwaa sintha goochchi kesseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Daannatuwaa sintha unttuntta afiide, “Hawanttu Ayihuda asaa gidiide, nu katamaa asaa loythi metoothiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nuuni Roome gadiyaa asaa gidiide, akkanawunne oothanaw woga gidennabaa tamaarissiino” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Asay itti bagga gidiide, Phawuloosa bollaninne Sillaasa bolla denddeedda; daannatuukka unttunttu mayuwaa qaari akkiide, xam77aan unttuntta shocana mala azazeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Unttunttu darissi wadhdheeddawaappe guyyiyan, qasho golliyaan yeggeeddino. Qasho golliyaa naagiyaawekka unttuntta minissi naaganaadan azazeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Qasho golliyaa naagiyaawe he azazuwaa akkiide, Phawuloosanne Sillaasa qasho golliyaa qol77o gelisseedda; unttunttu gediyaakka mithaanna gathi daraxiide qachcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Shin qamma bilahe gidiyaa heeran Phawuloosinne Sillaase Xoossaa woossiidde, mazimuriyaa yexxiide Xoossaa galatiino; qashetto asay unttunttu giyaawaa sisee. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Qasho golliyaa xaphuu qaaxxana gakkanaw wozanaa aathennaan biittay darissi qaaxxeedda; he man77iyankka penggiikka ubbay dooyetti aggina, qashetteedda asaa ubbaa santhalatay biletti wodhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Qasho golliyaa naagiyaawe gemi77ishuwaappe beegottiyaa wode, qasho golliyaa penggiikka ubbay dooyetteeddawaa be7iide, qashetto asay kessi akkiide bidiggeeddawaa aw malatina, barena wodhanaw qoppiide, cubiyaa akkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Shin Phawuloosi kooshshaa dhoqqu oothiide, “Neeni neena ayanne udoppa; ayissi gooppe, nuuni ubbay hawaan de7eetto” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Qasho golliyaa naagiyaawe xomppiyaa woossi akkiide, ellekka qol77o woxxeedda; kokkoriidde Phawuloosa sinthaaninne Sillaase sinthan guufanneedda; ");
INSERT INTO dwrNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","unttuntta kare kessiide, “Ta godatoo, taani attanaw ayaa oothana bessii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Phawuloosinne Sillaase A, “Godaa Yesuusi Kiristtoosa ammana; neeni attana; ne soy asaykka” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Unttunttu awunne A soyin de7iyaa ubbaw Godaa qaalaa odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Qamma he saatiyankka qasho golliyaa naagiyaawe unttuntta afiide unttunttu maythaa meecceedda; he man77iyankka bare soy asaa ubbaanna xammaqetti aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Phawuloosanne Sillaasa pude bare soy afiide, unttunttoo qumaa aatheedda; I bare soy asaa ubbaanna Xoossaa ammaneedda diraw, nashetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wonttina daannatuu, “He asatuwaa billa” yaagiide, polisiyaa kaappatuwaa aakko kiitteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Hewaappe guyye qasho golliyaa naagiyaawe, “Hinttenttu bilettana mala, daannatuu taw kiitteeddino; simmi ha77i kesiide sarotethaan biite” yaagiide he kiitaa Phawuloosaw odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Shin Phawuloosi he polisiyaa kaappatuwaa, “Nuuni Roome gade asaa gidishshin, unttunttu nuuna pirdday baynnaan asaa sinthan wadhdhiide, qasho golliyaan yeggeeddino. Ha77i nuuna geeman kessi yeddiinoo? Hanenna; unttunttu barenttu huuphew yiide, nuuna kessino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Polisiyaa kaappatuu daannatuwaassi hewaa odina, Phawuloosinne Sillaase Roome gade asa gideeddawaa siseedda wode, yayyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Hewaa diraw, daannatuu yiide unttuntta, “Nuuni hinttentta naaqqeeddo” geeddino. Qasho golliyaappe kare unttuntta kessiide, katamaappe kesiide baana mala woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Phawuloosinne Sillaase qasho golliyaappe kesiide, Liidiyaa soy beeddino; yaani ishatuwaanna gakettiide, unttuntta minissiide hewaappe beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Phawuloosinne Sillaase, Amppipholiisaannanne Apholooniyanna aadhdhiide, Teselonqqe yeeddino; Teselonqqen Ayihuda woosa golli de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Phawuloosi bare dooyaadankka yaa geleedda; hewaan heezzu Sambbata gallassatuwan Xoossaa Maxaafatuwaappe asaanna haasayeedda; ");
INSERT INTO dwrNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kiristtoosi waayyiyaa akkanawunne hayquwaappe denddanaw bessiyaawaa unttunttoo billiide odiiddinne tuma gideeddawaakka unttuntta erissiidde, “Yesuusi ha taani hinttenttoo odiyaawe Kiristtoosa” yaagee. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Unttunttuppe ittu ittuu yewuu tuma gideeddawaa akeekiide, Phawuloosannanne Sillaasenna gaketteeddino; hawaadankka, Xoossaassi goyinniyaa cora Giriike asaynne cora bonchchetteedda maccawanttu, Phawuloosannanne Sillaasenna gaketteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Shin Ayihudatuu qanaatiide, itti itti oosuu bayinna iita asatuwaa qocaappe shiishshiide katamaa asaa walasseeddino; Phawuloosanne Sillaasa asaakko kessana mala koyyiide, Yaasoona golliyaa dooddeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Phawuloosinne Sillaase unttunttoo beettennaan ixxina, Yaasoonanne itti itti ishatuwaa katamaa kaappatuwaakko afiide, “Hawanttu gadiyaa ubbaa metootheeddawanttu, hawaakka yeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yaatina Yaasooni unttuntta bare soyin wotheedda; hawanttu ubbay, ‘Yesuusa giyaa hara kaatii de7ee’ giide Qeesaare azazuwaa minissiino” yaagiide, kooshshaa dhoqqisside haaseyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Shiiqeedda asaynne katamaa kaappatuu hewaa sisiide metooteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kaappatuu Yaasoonanne haratuwaa waasiyan billeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ammaniyaawanttu Phawuloosanne Sillaasa sa7ay qammiyaawaani ellekka Beeriyaa yeddeeddino. Yaa gakkiide, Ayihuda woosa golle geleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beeriyaa asatuu Teselonqqen de7iyaa asatuwaappekka aadhdhi dooyetto wozanay de7iyaa diraw, “Phawuloosi geeddawe tumenttonne” yaagiide, ubba gallassi Xoossaa Maxaafatuwaa tamaariidde, qaalaa kumentha laamotaan akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hewaa diraw, unttunttuppe coratuu, Giriikatuwappe bonchchetteedda cora maccawanttunne cora attuma asatuu ammaneeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Shin Teselonqqen de7iyaa Ayihudatuu Phawuloosi Xoossaa qaalaa Beeriyankka odeeddawaa siseedda wode, Beeriyaa yiide, asaa aananna walasseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Hewaappe guyyiyan, ishatuu ellekka Phawuloosa abbaa mataan yeddii aggeeddino; shin Sillaasenne Ximootoose Beeriyan atteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Phawuloosa moyizzeedda asatuu Ateenaa gatheeddino; he asatuu Sillaasenne Ximootoose barenttoo danddayetteeddawaadan, ellekka barekko yaana mala, Phawuloosi kiitteedda kiitaa akkiide, Beeriyaa simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Phawuloosi Ateenaan Sillaasanne Ximootoosa naagiidde, katamaan eeqay kumeeddawaa be7iide yiloteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hewaa diraw, Ayihuda woosa golliyaan Ayihudatuwannanne Xoossassi goyinniyaa Ayihuda gidenna asatuwaanna palumettee; qassi ubba gallassi geyaan barenanna gakettiyaa asaannakka palumettee. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Qassi Eppiqoroosappenne Isxxo7ikiyaappe yeedda itti itti eranchchatuu Phawuloosanna palumetteeddino; unttunttuppe ittu ittuu, “Ha toofiinay ayaa haasayanaw koyyii?” yaageeddino. Haratuu Phawuloosa Yesuusabaanne hayquwaappe I denddeeddawaa barenttoo odiyaa diraw, “Ooratha xoossatubaa odiyaawaa malatee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Phawuloosa oyqqiide, “Ha neeni tamaarissiyaa ooratha yewuu ayentto nuuna erissaarikkii? Ayissi gooppe, neeni nuussi oorathabaa odaasa; simmi hawe ayentto nuuni eranaw koyyeetto” yaagiide Phawuloosa Ariyosppaagoosa geetettiyaasaa afeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ateenaa asay ubbaynne hewaan de7iyaa immathatuu oorathabaa haasayiiddinne sisiidde peeshiyaawaappe attin, harabaan peeshikkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Phawuloosi Ariyosppaagoosan de7iyaa shiiquwaa sinthan eqqiide, hawaadan yaageedda; “Ateenaa asatoo, xoossatuwassi ubbabaani hinttenttu darii yayyiyaawaa taani be7ay. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ayissi gooppe, taani hinttenttu goyinniyaawaa xeellaadde aadhdhishshin, ‘Erettenna Xoossaassi’ geetettiide xaafetteedda yarshshuwaa sa7aa qassi demmaaddi; hewaa diraw, ha hintte erennaan goyinniyaawaa taani hinttenttoo oday. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Alamiyaanne alamiyaan de7iyaa ubbabaa medhdheedda Xoossay saluwaanne sa7aa Goday, asay keexxeedda Geeshsha Golliyan de7enna. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ayentto pacceedda asaadan, asaa kushiyaa I xeellenna; ayissi gooppe, I bare huuphew de7uwaa shemppuwaanne ubbabaa asaa ubbaw immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Xoossay asaa zariyaa ubbaa itti uraappe medhdhiide, gadiyaa ubbaan wotheedda; I bare huuphew unttunttu de7ana wodiyaanne sa7aa kase zawayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“I hewaa ootheeddawe unttunttu oyqqi oyqqi xeelliide, barena koyyiidde, ooni eri demmanawantteeshsha giyaawaana; gidooppenne, Xoossay nuuppe oossinne haako gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ayissi gooppe, hinttenttuppe itti itti eranchchatuu, ‘Nuuni A naanaa’ geeddawaadan, nuuni aani paxa de7eettonne qaaxetteetto. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Simmi nuuni Xoossaa naanaa gideedda diraw, Xoossay asaa cinccatethaaninne qofaan worqqaappe woy biraappe woy shuchchaappe oosetteeddawaa malatee yaagiide, qoppanaw bessenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Hewaa diraw, Xoossay asay eribeenna wodiyaa aatheedda; shin ha77i ubbasan asay ubbay nagaraappe simmana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ayissi gooppe, Xoossay wodiyaa keeri wotheedda; he wodiyaan bare dooreedda uraan sa7aan de7iyaa asaa ubbaa bolla xillo pirddaa I pirddana; asaa ubbaw hayquwaappe Yesuusa dentheeddawaan hewaa tumayeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Unttunttuppe itti itti asatuu hayquwaappe dendduwaabaa Phawuloosappe sisiide, A bolla qilliicceeddino; shin hara asatuu A, “Nuuni hawaa neeppe gujjiide sisana koyyeetto” geeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Hewaa diraw, Phawuloosi unttunttu giddoppe keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Shin itti itti attuma asatuu Phawuloosanna gakettiide ammaneeddino; unttunttu gidduwan Ariyosppaagoosan de7iyaa pirdda golle daannay Diyoonaasiyoosi, Damaariiso geetettiyaa itti mishirattinna hara asatuu de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hewaappe guyyiyan, Phawuloosi Ateenaappe kesiide, Qoronttoosa beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Hewaan Aqiilaa giyaa itti Ayihuda bitaniyaa demmeedda; Aqiilay Phanxxoossan yeletteedda; Ayihuda asay ubbay Roomeppe kesana mala, Qalawudeyoosi azazeedda diraw, amareedda wodiyaappe kase, I bare machchatti Phirisqqillaanna Xaaliyappe yeedda; Phawuloosi unttunttunna gakettanaw beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","A oosuunne unttunttu oosuu itti mala dunkkaaniyaa sikaa gidiyaa diraw, unttunttunna uttiide, ittippe ootheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Phawuloosi Sambbataa ubbaan Ayihudatuwaanna Giriikatuwaa ammanthanaw Ayihuda woosa golliyaan palumettee. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sillaasenne Ximootoose Maqidooniyaappe yeedda wode, Phawuloosi Ayihudatuwaassi Yesuusi bare huuphew Kiristtoosa gideeddawoo qaalaa oduwaa toleedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Shin unttunttu Phawuloosa haasayaa phalqqinanne A borina, Phawuloosi bare mayuwaappe baanaa qoqqofiidde, “Hinttenttu iitatethay hinttentta oyqqo; taani hewaan gelikke; hawaappe hini baggan taani Ayihuda gidenna asaakko bay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Hewaappe kesiide, Xoossaassi goyinniyaa Yosxxoosa giyaa bitaniyaa soy beedda; Yosxxoosa golli Ayihuda woosa golliyaa matan de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ayihuda woosa golle kaappuu Qarisiphphoosi bare soy asaa ubbaanna Godaa ammaneedda; Qoronttoosa asatuwaappekka coratuu Xoossaa qaalaa siseedda wode, ammaniide xammaqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Goday itti qamma saxaan Phawuloosa, “Yayyoppa; oda; co77u gooppa. Taani neenanna de7iyaa diraw, neena qohanaw iitabaan yeggana asay ooninne baawa; ayissi gooppe, taw ha katamaan cora asay de7ee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Phawuloosi Xoossaa qaalaa asaa tamaarissiidde, itti laythanne usuppun agenaa unttunttunna utteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gaaliyoose Akaayiyaa gadiyaa mooddiyaa wode, Ayihudatuu ittippe Phawuloosa bolla denddiide, pirdda golle A afiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Ha bitani Muse higgiyaa ixxiide, asay Xoossaassi goyinnana mala cimmee” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Phawuloosi haasayana hanishshin, Gaaliyoose Ayihudatuwaa, “Ayihudatoo, hewe bala oosuwaa woy iita naaqo gidooppe, taani hinttenttubaa danddayaade sisanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Shin qaalaassi sunthaassinne hintte huuphe higgiyaassi hinttenttu palumettooppe, hintte huuphew erite; hawaa taani pirddikke” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Pirdda golliyaappe karew unttuntta kesseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Hewaappe guyyiyan, Giriike asay ubbay Ayihuda woosa golle kaappuwaa Sostteniisa oyqqiide, pirdda golliyaa sinthan shoceeddino; shin Gaaliyoosa hewe aynne metibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Phawuloosi daro wodiyaa Qoronttoosan utteeddawaappe guyyiyan, ishatuwaa sarotiide, Phirisqqillinnanne Aqiilaanna markkabiyaan Sooriyaa beedda; barew shiiqqeedda gasuu de7iyaa diraw, Kinkkiriyaa katamaan bare huuphiyaa meedetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Unttunttu Efesoone gakkeedda wode, Phawuloosi Phirisqqillonne Aqiilaa yaani yeggi yeedda; shin barew Ayihuda woosa golle geliide, Ayihudatuwaanna palumetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Unttunttu barenttunna daro wodiyaa uttana mala Phawuloosa woossina I ixxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Shin unttunttuppe shaakettiide, “Xoossay gooppe, laa7ethuwaa hinttenttukko simmana” yaagiide Efesoonappe markkabiyaan beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Qiisaariyaa gakkeedda wode Yeerusalaame biide, ammaniyaa asaa saroteeddawaappe guyyiyan, Anxxookiyaa wodhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Yaani amareedda wodiyaa gami77iide beedda; kaalliyaawantta ubbaa minissiide, Galatiyaannanne Pirggiyaanna aadhdheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iskkinddiriyan yeletteedda Ayihuda asaa itti Aphiloosa giyaa lo77o haasayiyaawe Efesoone beedda; Xoossaa Maxaafatuwaa I darissi eriyaa asa. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Godaa ogiyaakka tamaareedda asa; Yohaannisa xinqqataa xalalaa eriide, ayyaanan bare garssan eexettiidde, Yesuusabaa suurissiide haasayeeddanne tamaarsseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yaatiide Ayihuda woosa golliyaan yayyennaan haasayaa doommeedda. Phirisqqillaynne Aqiilay I odiyaawaa siseedda wode, barenttunna soy A afiide, Xoossaa ogiyaa kaseppe suurissiide, aw geeshshi odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aphiloosi Akaayiyaa pinnana koyyina, ishatuu A minissiide, Akaayiyaan de7iyaa kaalliyaawanttu A mokkana mala, unttunttoo dabidaabbiyaa xaafeeddino; I yaa gakkiide, Xoossaa aadho keekatethaan ammaniyaawantta daro maaddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ayissi gooppe, Yesuusi bare huuphew Kiristtoosa gideeddawaa Ayihudatuwaassi Xoossaa Maxaafatuwaappe qonccissiide, asaa sinthan minissiide odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aphiloosi Qoronttoosan de7ishshin, Phawuloosi qommo bagganna aadhdhiide, Efesoone beedda; itti itti kaalliyaawantta demmeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Phawuloosi unttuntta, “Hinttenttu ammaneedda wode Geeshsha Ayyaanaa akkeedditee?” yaagiide oochcheedda. Unttunttu, “Tuytti, akkibeykko; haray atto, Geeshsha Ayyaanay de7iyaawaakka sisibeykko” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Phawuloosi unttuntta, “Yaatina, Ayaan xammaqetteedditee?” yaageedda. Unttunttu, “Nuuni Yohaannisa xinqqataani xammaqetteeddo” yaagiide zaareeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Phawuloosi, “Yohaannisi bareppe guyyiyan yiyaa Yesuusi Kiristtoosan asay ammanana mala, asaassi odiidde, nagaraappe simmiyaa xinqqataani xammaqeedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Unttunttu hewaa siseedda wode, Godaa Yesuusi Kiristtoossassi gidanaw xammaqetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Phawuloosi bare kushiyaa unttunttu bolla wotheedda wode Geeshsha Ayyaanay unttunttu bollan wodhdhina, dumma dumma qaalaan haaseyeeddino; qassi timbbitiyaakka odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Hewaan tammanne laa77u asatuwaa gidiyaawanttu de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Phawuloosi Ayihuda woosa golle geliide, Xoossaa kawutethaabaa palumettiiddinne akeekissiidde, asaanna heezzu agenaa gidiyaawaa keenaa yayyennaan haasayee. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Shin unttunttuppe ittu ittuu makkaliide, cora asaa sinthan Godaa ogiyaa boriidde ammanennaan ixxina, Phawuloosi unttunttuppe shaaketti, barena kaalliyaawantta barenanna afeedda; Xiraanoosa giyaa timirtte golliyaan ubba gallassi palumettee. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Phawuloosi laa77u laythaa gakkanaw qaalaa odeedda; hewaa diraw, Iisiyan de7iyaa asay ubbay, Ayihudatuukka Ayihuda gidennawanttukka Godaa qaalaa siseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Xoossay Phawuloosa bagganna dumma malaataa ootheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Hewaa diraw, asay A bollay bochcheedda maarabiyaa woy mayuwaa hargganchchatuwassi afee; hargganchchatuukka paxiino; iita ayyaanatuukka unttunttuppe kesiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Iita ayyaanatuwaa kessiidde yuuyyiyaa Ayihudatuwaappe ittu ittuu, “Phawuloosi qaalaa odiyaa Yesuusa sunthan nuuni hinttentta kesite giide azazeetto” yaagiide, iita ayyanatuu de7iyaa asatuwaa bollan Godaa Yesuusa sunthaa xeesi be7eeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Qeesatuwaa kaappuwaa Asqqeewa giyaa itti Ayihuda bitaniyaassi hewaa ootheedda laappu naanay de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Iita ayyaanay unttunttoo zaariide, “Taani Yesuusa eray; Phawuloosakka eray. Shin hinttenttu oonee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Iita ayyaanay de7iyaa bitani unttunttu bolla guppi wodhdhina, unttunttu masunxxiide, he golliyaappe kallo woxxana gakkanaassi, wolqqaamiide xooneedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efesoonen de7iyaa Ayihudatuunne Ayihuda gidennawanttu ubbay hewaa sisiide ubbay daro yayyeeddino; Godaa Yesuusa sunthaykka daro bonchchetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ammaniyaawanttuppe cora asatuu barenttu ootheeddawaa paaxiiddinne qoncciyaan odiidde yiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bitiyaawanttuppe coratuu barenttu maxaafatuwaa shiishshiide, asaa ubbaa sinthan guuddeeddino; he maxaafatuwaa gatiyaa heettiyaa wode, ishatamu sha77a Biraa santtimiyaa gideedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Hewaa mala wolqqaama ogiyaan Xoossaa qaalay dicceenne aakkee. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Hewe poletteeddawaappe guyyiyan Phawuloosi, “Taani Yeerusalaame baade Roomekka qassi be7anaw bessee” yaagiide, Maqidooniyaannanne Akaayiyaanna aadhdhiide, Yeerusalaame baanaw qofaa qachcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Qassi barena maaddiyaawanttuppe laa77atuwaa Ximootoosanne Erasxxoosa Maqidooniyaa kiittiide, barew Iisiyan amareedda wodiyaa gami77eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Godaa ogiyaa diraw, he wode daro walassay keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ayissi gooppe, xagaraa biraa muushissiide tigi medhdhiyaa Dimexiroosa giyaa itti bitani Arxxemiisi Geeshsha Golliyaa misiliyaa biraappe tigi tigiide, oosanchchatuwaassi daro wodhiyaa demmee. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Hewanttanne unttunttuwaa mala oosuwaa oothiyaawantta ittippe shiishshiide, hawaadan yaageedda; “Asaw, nu duretethay ha oosuwaanna gidiyaawaa hintte eriita. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Hewe Phawuloosi, ‘Asaa kushii medhdheeddawanttu xoossatuwaa gidikkino’ yaagiide, Efesoone xalalaan gidennaan amareedda gadatuwaappe attin, Iisiyan ubbaan cora asaassi odi ammantheeddawaa hinttenttu be7eedditanne siseeddita. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Lo77ennabay, nu oosuu kadhettanawaa xalalaa gidenna; shin Iisiyan de7iyaa ubbatuunne sa7aa ubbaan de7iyaawanttu goyinniyaa wolqqaama xoossatto geetettiyaa Arxxemiisi geeshsha golli bonchchettennan attanawaanne, izi darotethay kunddanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Asay hewaa siseedda wode loythi hanqqettiide “Efesoone Arxxemiisa wolqqaama” yaagiide cabbotteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Katamaa ubbaan walassay denddeedda; Phawuloosanna hamettiyaa Maqidooniyaa asatuwaa Gaayoosanne Arisxxirokoosa barenttunna oyqqi akkiide, ittippe kaassaa sa7aa woxxeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Phawuloosikka asay shiiqeeddasaa gelanaw koyyeedda. Shin kaalliyaawanttu A diggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Iisiyaa gadiyaa kaappatuwaappe Phawuloosa laggethatuwaappe ittu ittuu Phawuloosaw kiittiide, kaassaa sa7aan qoncciyaa kesiide I beettenna mala, A woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Shiiquwaan walassay denddina, dariya bagga asay haray atto ayissi shiiqeeddentto erenna diraw, ittu ittibaw walaqettiyaa wode, yokkuu qay harabaw walaqettee. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayihudatuu Iskkinddira aathi bessina, itti itti asay I haasayana mala, asaa giddoppe sinthaw A aatheedda; asay co77u gaana mala, I bare kushiyan xorssi bessiide, asaassi mootettanaw koyyeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Shin Iskkinddire Ayihuda asaa gideeddawaa asay ereedda wode, laa77u saate gidiyaawaa keenaa ubbay itti qaalaan, “Efesoone Arxxemiisa wolqqaama” yaagiide cabbotteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Katamaw xaafe gideeddawe asaa co77u oothiide, hawaadan yaageedda; “Efesoone asaw, Efesoone katamay wolqqaama Arxxemiisissinne saluwaappe wodhdheedda eeqaa shuchchaassi eeqaa golliyaa naagiyaawaa gideeddawaa erenna asay oonee? ");
INSERT INTO dwrNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hawaa kaddiyaa asay baynna diraw, hinttenttu woppu gaanawunne dirbbennan agganaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ayissi gooppe, hawanttu Geeshsha Golliyaa miishshaa wuu77ibeennawantta nu xoossatuwaakka boribeennawantta aheeddita. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Hewaa diraw, Dimexiroosinne aananna de7iyaa oosanchchatuu asaa mootanaw koyyooppe, pirdda golli dooya de7ee; qassi gadiyaa mooddiyaawanttukka de7iino; unttunttu barenttu giddon mootettiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Shin hintte hara yewuwaa koyyooppe, higgiyaa shiiquwaan yewuwaa qachchana. ");
INSERT INTO dwrNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ayissi gooppe, hachche haneeddawaa shabbirethaa giide, Roome gadiyaa asatuu nuuna mootana; ha shiiqookka gaasuu bayinna diraw, nuuni gaasuwaa odanaw danddayokko” ");
INSERT INTO dwrNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","yaagiide shiiquwaa laaleedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Walassay irxxeeddawaappe guyyiyan, Phawuloosi kaalliyaawantta ahissiide zoreedda; unttuntta, “Saruwan de7ite” giide, Maqidooniyaa baanaw keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","He gadiyaanna aadhdhiidde, qaalaa odiide, asaa loythi minisseeddawaappe guyyiyan, Giriike gade yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","I hewaan heezzu agenaa uttiide, markkabiyaan Sooriyaa baanaw qoppishshin, Ayihudatuu barena wodhanaw koyyiyaawaa be7iide, Maqidooniyaanna guyye simmanaw bare qofaa qachcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Phawuloosa moyizzeeddawanttu, Beeriyaappe Pharihaasa na7aa Sosiiphaaxiroosa, Teselonqqeppe Arisxxirokoosanne Sikonddisa, Derbbeppe Gaayoosanne Iisiyappe Tikiqoosanne Xirofimoosa, qassi Ximootoosa. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Hewanttu sinthaw biide, nuuna Xiro7aadan naagiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nuuni Ukithaa Baalaa gallassaa bonchchowaappe guyyiyan, Piliphphisiyoosa giyaa gadiyaappe markkabiyaan denddiide, ichcheshu gallassan Xiro7aadan unttuntta gakkiide, yaani laappu gallassaa utteeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nuuni Woggaa gallassi ukithaa menthanaw shiiqide7ishshin, Phawuloosi wonttina baanaw qoppeedda diraw, unttunttoo qaalaa odiidde, qamma bilahii gakkanaw yewuwaa adusseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nuuni shiiqi utteedda pooqiyan cora xomppii de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ewuxikoosa giyaa itti wodallay maskkootiyaa bolla uttiide, darissi gemi77isheedda. Phawuloosi haasayaa adusseedda wode, Ewuxikoosi gemi77ishuwan hayreeddawe heezzenthiyaa pooqiyaappe sa7aan kunddiide hayqqeeddawaa asay dentheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Shin Phawuloosi wodhdhiide, A bolla guufanneedda. A idimmiide, “A shemppuu kesibeenna diraw hirggoppite” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Yaatiide pude pooqiyaa kesiide, ukithaa menthiide meedda; sa7ay wonttana gakkanaassi, daro wodiyaa haasayeeddawaappe guyyiyan beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wodallay paxina, soy afiide, darissi nashetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Shin Phawuloosi barena yaappe nuuni mokkana mala, nuussi odeedda diraw, kasetiide markkabiyaakko biide, Asoosa baanaw denddeeddo; ayissi gooppe, gediyaan baanaw I qoppeedda diraw nuuna hewaadan azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","I nuunanna Asoosan gakettina, markkabiyaan A akkiide Mixiliine yeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wonttetha gallassi yaappe markkabiyaan denddiide, Kiyoosa heeraa gakkeeddo; qassi wonttetha gallassi Saamoosa pinneeddo; Tirogiliyoomen aqiide, wonttina Miliixe yeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ayissi gooppe, Phawuloosi Iisiyan darii gami77ennaan Efesoone lanqqiyanna aadhdhanaw bare qofaa qachcheedda; barew danddayettooppe, Phenxxeqostte geetettiyaa gallassi Yeerusalaame gakkanaw elleellee. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Phawuloosi Miliixeppe Efesoone kiittiide, ammaniyaa asaa kaalethiyaawantta xeegisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","19","Woosa golle cimatuu Phawuloosakko yiina, unttuntta I hawaadan yaageedda; “Taani Iisiya geleedda koyro gallassaappe doommin, kawushshatethaaninne daro afothaani Godaassi oothaadde, Ayihudatuwaa shiiquwaappe taana gakkeedda paace gideedda wodiyaa ubbaan hinttenttunna waanaade de7aadditantto hinttenttu eriita. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","21","Nagaraappe Xoossaakko simmiyaawaanne nu Godaa Yesuusi Kiristtoosa ammaniyaawaa Ayihudatuwassinne Ayihuda gidennawanttoo markkattaadde, shiiquwankka hinttenttu gollen gollenkka hinttenttoo odaadde tamaarisseeddawaappe attin, hinttentta go77iyaabaappe ittibaanne pacissa beykke. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Be7ite; ha77ikka taani Geeshsha Ayyaanaassi azazettaade, Yeerusalaame bay; yaani taw ayee kesanenttonne erikke. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Geeshsha Ayyaanay qashuunne waayyii taana naagiyaawaa katamaa ubbaan taw odee. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Shin ta wothaa polanawunne Godaa Yesuusi Kiristtoosappe taani akkeedda oosuwaa Xoossaa aadho keekatethaa wonggalaa mishiraachchuwaa markkattiyaawaa polanaw, ta shemppuwaa maaddennawaadan payday. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Be7ite; taani ha77ikka Xoossaa kawutethaabaa odaadde, hinttenttu ubbaa giddon yuuyyaaddi; simmi hawaappe sinthaw hinttenttuppe ooninne taana be7ennawaa eray. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Hewaa diraw, hinttenttuppe itti uray bayooppekka taani hewaan gelennawaa hachche hinttenttoo geeshshaade oday. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ayissi gooppe, Xoossay oothanaw qoppeeddawaa ubbaa hinttenttoo aynne ashshennaan odaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Yesuusi bare suuthaan wozeedda Xoossaa ammaniyaawantta naagite; qassi Geeshsha Ayyaanay hinttentta kaappatuwaa oothiide suntheedda wudiyaa ubaanne hinttenttu huuphiyaa naagite. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","30","Taani beeddawaappe guyyiyan, wudiyaassi qarettenna iita worakanatuu hinttenttu giddo gelanawanttanne, kaalliyaawantta barenttu geeduwaa kaalethanaw wordduwaa haasayiyaa asatuu hinttenttu giddoppe denddanawaa eray. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Hewaa diraw, taani heezzu laythaa qammanne gallassaa afothaani hinttentta huuphiyan huuphiyan minissiyaawaa aggabeennawaa qoppiide genccite. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ha77ikka hinttentta minissanawunne geeshsha asaa ubbaa giddon laatissanaw danddayiyaa Xoossaassinne A aadho keekatethaa qaalaassi hinttentta hadaraa immay. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Taani ooppenne biraa woy worqqaa woy mayuwaa amottabeykki; ");
INSERT INTO dwrNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","taani ha ta kushiyan taananne taananna ittippe de7iyaawantta kooshsheeddawaa ootheeddawaa hinttenttu hinttenttu huuphew eriita. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Hinttenttu hawaadan daaburi oothiidde, daaburanchchatuwaa maaddanaassinne Godaa Yesuusi bare huuphew, ‘Akkiyawaappe immiyaawe anjjetteeddawaa’ geeddawaadan, A qaalaa hinttenttu wozanaa aathanaw bessiyaawaa taani cora ogiyaan hinttentta bessaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Phawuloosi hewaa haasay wurssiide, unttunttu ubbaanna ittippe gulbbatiide, Xoossaa woosseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Unttunttu ubbay Phawuloosa idimmiide, yeekkiidde yereeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ubbaappe I, “Taana laa7ethuwaa ubbakka be7ikkita” yaageedda qaalay unttuntta daro qarethina markkabiyaa gakkanaw A moyizzeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nuuni Efesoone cimatuwaappe shaakettiide, Qoosa geetettiyaa haathaan doodetto sa7aa yii aggeeddo; wonttissa gallassi Rooda gakkeeddo; hewaappe Phaaxira beeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pinqqe pinniyaa markkabiyaa demmiide, aani geliide baanaw denddeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nuuni Qophiroosappe be7anaw danddayiyaasaa yiide, away kesiyaasaa xeelliyaa wode Qophiroosa haddirssa bagga yeggiide, Sooriyaa beeddo; hewaappe guyyiyaan Xiiroosa gakkeeddo; ayissi gooppe, markkabii bare caanaa Xiiroosan wothee. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Yaani kaalliyaawantta demmiide, unttunttunna laappu gallassaa utteeddo; Phawuloosi Yeerusalaame beenna mala, unttunttu aw Ayyaanaan odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nuuni unttunttunna uttiyaa wodii wurina, kesiide beeddo; unttunttu ubbatuu barenttu maccawanttunnanne barenttu naanaanna ittippe katamaappe karew kessana gakkanaassi, nuuna moyizzeeddino; nuuni abbaa doonaan gulbbatiide, Xoossaa woosseeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Hewaappe guyyiyan, ittu ittuwaa sarotiide, markkabiyaan geleeddo; unttunttu barenttu soy simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nuuni abbaa ogiyaa wurssiide, Xiiroosappe Phexelemayse gakkeeddo; ishatuwaa sarotiidde, unttunttu matan itti gallassaa peesheeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wonttissa gallassi kesiide, Qiisaariyaa beeddo; wonggalaa mishiraachchuwaa odiyaa Piliphphoosa soy gakkiide, A matan utteeddo; Yeerusalaamen dooretteedda laappunatuwappe I ittuwaa. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Piliphphoosassi nabatuwaa gideedda oyddu wodoro macca naanatuu de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nuuni unddenneedda gallassaa utteedda wode, nabiyaa Agaaboosa giyaa bitani Yihudaappe Qiisaariyaa yeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nuukko yiide, Phawuloosa saqqiyaa akkiide bare kushiyaanne bare gediyaa qachchiide, “Geeshsha Ayyaanay giyaawe hawaa; ha saqqiyaa godaa Yeerusalaamen Ayihudatuu hawaadan qachchiide, Ayihuda gidenna asatuwaassi aathiide immana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nuuni hewaa siseedda wode, nuuninne yaani de7iyaa asatuu Phawuloosi Yeerusalaame beenna mala woosseeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Shin Phawuloosi zaariide, “Hinttenttu yeekkiiddenne ta wozanaa qaretissiidde waaniitee? Taani Godaa Yesuusa sunthaa diraw qashettanawaa xalalaa gidennaan, haray atto Yeerusalaamen hayqqanawukka giiga uttaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Zoriyaa I akkennaan ixxina, “Goday geeddawe hano” yaagiide co77u geeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Yaani amareedda wodiyaa gami77eeddawaappe guyyiyan, giigettiide Yeerusalaame baanaw keseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Qiisaariyaan de7iyaa kaalliyaawanttuppe amareeddawanttu qassi nuunanna beeddino; unttunttu nuuni aqanasaa Minaasoona giyaa Qophiroosa bitaniyaa soy nuuna afeeddino; Minaasooni daro wodiyaappe doommiide kaalliyaawaa. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nuuni Yeerusalaame gakkeedda wode, ishatuu nuuna nashechchaan mokkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wonttissa gallassi, Phawuloosinne nuuni Yayiqoobanna gakettanaw beeddo. Woosa golle cimatuu ubbatuukka de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Phawuloosi unttuntta saroteeddawaappe guyyiyan, Ayihuda gidenna asaa giddon bare bagganna Xoossay ootheeddawaa unttunttoo wurssiide odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Unttunttu hewaa siseedda wode Xoossaa galatiide, Phawuloosa hawaadan yaageeddino; “Nu ishaw, Ayihudatuwaa giddon Xoossaa ammaneeddawanttuppe aappun sha77ay de7iinontto be7aasa; unttunttu ubbay higgiyaa minissi naagiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Yeerusalaame Ayihudatuu, Ayihuda gidennawanttu gadiyan de7iyaa Ayihuda ubbatuu barenttu naanaa qaxxarenna mala, woy Ayihudatuu oothiyaawaa kaallenna mala, Muse higgiyaakka bayizzana mala neeni tamaarssiyaawaa siseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yaatina, ayee lo77uu? Neeni yeeddawaa coratuu sisiyaa diraw, shiiqennaan aggikkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","“Hewaa diraw, hawaa nuuni new odiyaawaa ootha; ittippe shiiquu de7iyaa oyddu asatuu nu matan de7iino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Unttuntta akkaade unttunttunna geeyya; qassi unttunttu barenttu huuphiyaa meedettana mala, unttunttoo miishshaa imma; unttunttu ubbay newaa siiseeddawe tuma gidennawaanne neeni ne huuphewukka qassi Muse higgiyaa naagaadde maaran de7iyaawaa erana. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Shin ammaneedda Ayihuda gidenna asatuwaa gidooppe, unttunttu eeqaw yarsheeddawaa meenna malanne suuthaa ushenna mala, bakuteedda mehiyaa ashuwaa meenna malanne woshummenna mala, nuuni yewuwaa qachchiide, unttunttoo dabidaabbiyaa xaafeeddo” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Hewaappe guyyiyan, Phawuloosi wonttissa gallassi asatuwaa akkiide, unttunttunna geeyyeedda; I barentta geeshshussaa awude polintto erissanawunne qassi yarshshuwaa huuphiyan huuphiyan awude immanentto erissanaw Geeshsha Golliyaa geleedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","28","Laappu gallassay wurana hanoode, Iisiyappe yeedda Ayihudatuu Geeshsha Golliyaan Phawuloosa be7iide, asaa ubbaa hanqqethiide, “Israa7eeliyaa asaw, nuuna maaddite; Israa7eeliyaa asaa, Muse higgiyaanne ha Geeshsha Golliyaa ixxiide, ubbasan asaa ubbaa tamaarissiyaawe ha bitaniyaa; gujjiide qassi Giriike asaakka Geeshsha Golliyaa gelissiide, ha geeshsha sa7aa tunisseedda” yaagi waassiidde, Phawuloosa oyqqeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Unttunttu kase Efesoonen de7iyaa Xirofimoosa Phawuloosanna katamaan be7eedda diraw, Geeshsha Golliyaa Phawuloosi A gelisseeddawaa unttunttoo malateedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Katamaa ubbay shabbiretteedda; asay ubbay shiiqiide Phawuloosa oyqqiide, Geeshsha Golliyaappe karew goochchi kesseedda; he man77iyankka Geeshsha Golliyaa penggetuu qashettii aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Asay Phawuloosa wodhana hanishshin, “Yeerusalaame katamay mulekka shabbirettidiggeedda” giyaa haasayay Roome gadiyaa olaa kaappuwaassi gakkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","He olaa kaappuu wottaaddaratuwaanne xeetatuwaa kaappatuwaa ittippe akkiide, woxxiidde asaa bolla kesi wodhdheedda; asay olaa kaappuwaanne wottaaddaratuwaa be7eedda wode, Phawuloosa shociyaawaa bashi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","He wode, he olaa kaappuu shiiqi, Phawuloosa oyqqiide, laa77u santhalataan qashettana mala azaziide, I oonenttonne qassi ayaa ootheeddenttonne asaa oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Asaappe baggay ittibaw waassiyaa wode, baggay harabaw waassee; waasuu coreedda diraw, olaa kaappuwaassi tumuwaa eranaw danddayettennan ixxina, wottaaddaratuu Phawuloosa barenttu de7iyaasaa afana mala, unttuntta azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Yedhdhiide kesiyaa dethaa Phawuloosi gakkeedda wode, asaa sugethaa diraw, wottaaddaratuu A tookkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ayissi gooppe, cora asay, “A wodha!” yaagiiddinne waassiidde kaallee. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wottaaddaratuu Phawuloosa barenttu de7iyaasaa afana hanishshin Phawuloosi olaa kaappuwaa, “Taani new ittibaa odoo?” yaageedda. He olaa kaappuu Phawuloosa, “Neeni Giriike qaalaa eray? ");
INSERT INTO dwrNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Neeni hawaappe kase wode, walassaa kessaade shemppuwaa wodheeddawanttuppe oyddu sha77a asatuwaa asay baynna mela sa7aa kaaletheedda Gibxe bitaniyaa gidikkii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Shin Phawuloosi, “Taani Ayihuda asa; qassi Kilqqiyaan de7iyaa Xersseesen yeletteedda huuphe katamaan de7iyaa asa. Hayyanaa taana asaassi haasayissarikkii?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Olaa kaappuu A, “Haasaya” yaagina, Phawuloosi yedhdhiide kesiyaa dethaan eqqiide, asay co77u gaana mala, bare kushiyan asaakko xorsseedda. Asay co77u giina, Ibraayisxxe qaalaan haasayiidde, hawaadan yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Taanaadan ammaniyaawanttoo, ta aawatoo, taani ha77i hinttenttoo odiyaa yewuwaa sisite!” ");
INSERT INTO dwrNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Phawuloosi unttunttoo Ibraayisxxe qaalaan haasayiyaawaa sisiide, kaseppe loythi co77u giina I hawaadan yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Taani Kilqqiyaan de7iyaa Xersseesen yelettaade, ha katamaan Gamaaliyaali taana tamaarissina diccaade, nu aawatuwa higgiyaakka minissa tamaaraade, hachche hintte ubbay haniyaawaadankka, taani Xoossaa yewuwaassi seelettiyaa Ayihuda asa. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Taani macca asaanne attuma asaa oyqqa oyqqaade qasho gollen yeggeedda asaanne, ha ogiyaa kaalliyaa asaa wodhissana gakkanaassi metootheedda asa. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hawaadankka, qassi, qeesatuwaa ubbatuwaa kaappuunne cimaa ubbaa shiiquu tawaa markkattanaw danddayee; taani Damasqqon de7iyaa unttunttu ishatuwaa Ayihudatuwaassi, unttunttuppe dabidaabbiyaa akkaade, hewaan de7iyaa asatuu qashettiide murettanaadan, Yeerusalaame unttuntta ahanaw yaa baaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Taani baade Damasqqo mateedda wode, seeta gallassaa gidishshin, qoppennaan saluwaappe wolqqaama poo7uu ta matan yuuyyi aadhdhiide poo7eedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Taani sa7aan kundda uttaade, ‘Saa7oolaa, Saa7oolaa, taana ayaw yederssay?’ giyaa qaalaa sisaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Taani zaaraade, ‘Ta Godaw, neeni oonee?’ yaagaaddi. “Hewaappe guyye, ‘Taani neeni yederssiyaa Naazireetiyaa Yesuusa’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Taananna ittippe de7iyaawanttu poo7uwaa be7iide yayyeeddino; shin taw haasayiyaawaa qaalaa sisibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“ ‘Ta Godaw, taani ayaa udoo?’ yaagaaddi. “Goday taana, ‘Denddaade Damasqqo ba. Neeni oothanaw Xoossay qoppeedda ubbabay new yaani odettanawaa’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","He wolqqaama poo7uwaa diraw, ta ayfii qooqina, taananna de7iyaa asatuu ta kushiyaa oyqqiide, taana goochchina, Damasqqo gakkaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Damasqqon de7iyaa Ayihuda ubbay loythi bonchchiya itti Hanaaniyaa giyaa bitani, nu higgiyaassi azazettiide, Xoossaw imetteedda asa. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Hanaanii taakko yiide, ta matan eqqiide taana, ‘Ta ishaw Saa7oolaa, xeella’ yaageedda. Taani he wode he man77iyankka aakko xeellaa aggaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“I taana hawaadan yaageedda; ‘Nu aawatuwa Xoossay neeni A qofaa eranaw, A xillo Na7aa be7anawunne A doonaappekka haasayaa sisanaw neena kasenna dooreedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ayissi gooppe, neeni be7eeddabaanne siseeddabaa asaa ubbaa sinthan aw markkattanaassa. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ha77ikka ayaw gami77ay? Denddaade xammaqetta; A sunthaa xeesaadde, ne nagaraappekka meecetta’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Taani guyye Yeerusalaame simmaade Geeshsha Golliyan woossishshin, ta ayyaanaan gidaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Goday taana, ‘Elleellaade, Yeerusalaame kesa ayaw gooppe, neeni taw hawaan markkattiyaawaa asay akkenna’ yaagishshin taani A be7aaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Taani, ‘Ta Godaw, Ayihuda woosa golliyaa ubbaan neena ammaniyaawantta oyqqaade wadhdheeddawaanne qasho golliyaan yeggeeddawaa unttunttu eriino. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Unttunttu ne markkaa Isxxifaanoosa wodhiyaa wode, taani he yewuwaa eeno gaaddi. Qassi unttunttu miyyiyaan eqqaade, A wodhiyaawanttu mayuwaa naagay’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Goday taana, ‘Taani neena Ayihuda gidenna asaakko haakosaa kiittiyaa diraw ba’ geedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Phawuloosi he qaalaa haasayana gakkanaw asay I giyaawaa sisee; hewaappe guyyiyan, barenttu kooshshaa dhoqqu oothiide, “Hawaa gadiyaappe dhayissa; I de7anaw bessenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","24","Unttunttu waassishshin, barenttu mayuwaa bollaw olishshiininne baanaa carkkuwan laalishshin, olaa kaappuu wottaaddaratuu Phawuloosa barenttu de7iyaasaa afana mala azazeedda. Qassi asay ayissi hewaadan aabolla waasseeddinontto eranaw, Phawuloosa lissuwan shocana mala, unttuntta azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Shin wottaaddaratuu Phawuloosa dafuwan minissi qachcheedda wode, Phawuloosi bare matan eqqeedda xeetatuwaa kaappuwaa, “Roome gadiyaa asaa pirdday baynnaan shociyaawe hinttenttoo wogee?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Hewaa xeetatuwaa kaappuu siseedda wode, olaa kaappuwaakko biide, “Ha bitani Roome asa. Neeni ayaa oothana qoppay?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Olaa kaappuu Phawuloosakko shiiqiide, “Neeni Roome asee? Taw oda” yaageedda. Phawuloosi, “E” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Olaa kaappuu Phawuloosaw zaariide, “Taani ha zaretethaa daro miishshaan shammaaddi” yaageedda. Shin Phawuloosi, “Taani he zerethaappe yelettaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Hewaa diraw, Phawuloosa biddanaw qooppeeddawanttu man77iyan aappe shaaketti aggeeddino. Olaa kaappuukka Phawuloosi Roome asa gideeddawaa ereedda wode yayyeedda; ayissi gooppe, santhalataan A qashissi wotheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Wonttetha gallassi olaa kaappuu, Ayihudatuu Phawuloosa ayissi mooteeddinonttonne geeshshiide eranaw koyyiide, Phawuloosa billeedda. Yaatiide qeesatuwaa kaappatuunne asay ubbay shiiqana mala azazeedda; qassi Phawuloosa duge wothiide, unttunttu sinthan esseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Phawuloosi hewaan shiiqeedda asaa caddi xeelliide, “Taanaadan ammaniyaawanttoo, taani hachche gakkanawukka Xoossaa sinthan ta de7uwaa ubbaan tilla wozanaan de7aaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Qeesatuwaa ubbatuwaa kaappuu Hanaanii, Phawuloosa doonaa baqqana mala, A matan eqqeeddawantta azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Phawuloosi he wode A, “Laa ha booshinchchaan okkeedda godaw, Xoossay neena baqqana. Neeni ta bolla higgiyan pirddanaw uttaade, wogay baynnaan taana baqqana mala azazay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Phawuloosa matan eqqeeddawanttu A, “Neeni Xoossaa qeesatuwaa ubbatuwaa kaappuwaa boray?” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Hewaappe guyye Phawuloosi, “Taanaadan ammaniyaawanttoo, I qeesatuwaa ubbatuwaa kaappuwaa gideeddawaa taani erabeykke; ayissi gooppe, ‘Ne gadiyaa mooddiyaawaa bolla iita qaalaa haasayoppa’ geetettiide Xoossaa Maxaafan xaafetteedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Shin Phawuloosi baggatuu Saduqaawanatuwaa; baggatuu Parisaawatuwaa gideeddawaa be7iide, “Taanaadan ammaniyaawanttoo, taani Parisaawiyaanne Parisaawiyaa na7aa; ‘Hayqqeeddawanttu hayquwaappe denddanawantta’ gaade taani nashechchaan naagiyaa diraw, unttunttu ta bolla pirddiino” yaagiide, dhoqqu oothiide haasayeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Phawuloosi hewaa yaagina, Parisaawatuwaa giddoninne Saduqaawanatuwaa giddon walassay kesina, shiiqeedda asay laaletteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ayissi gooppe, Saduuqaawanatuu, “Hayqqeedda asay denddenna; kiitanchchaykka ayyaanaykka baawa” yaageeddino; Parisaawatuu qassi laa77uukka de7iyaawaa ammaniino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Wolqqaama walassay denddeedda; Parisaawatuwaa baggappe Muse higgiyaa tamaarssiyaawanttu denddi eqqiide, “Ha bitaniyaa bolla aynne balaa demmibeykko; aw ayyaanay woy kiitanchchay haasayennan aggenna” yaagiide palumetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Walassay darina, olaa kaappuu Phawuloosa unttunttu menthereethanenttonne gi yayyiide, bare wottaaddaratuu wodhdhiide, unttunttu giddoppe A ellekka kesiide, barenttu de7iyaasaa afana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","He qamma Goday Phawuloosa matan eqqiide, “Phawuloosaa, neeni taw Yeerusalaamen markkatteeddawaadan, Roomenkka markkattanaw bessee; minna; aynne baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wonttissa gallassi, Ayihudatuu Phawuloosa wodhana gakkanaassi, meennaadaaninne ushennaadan, caaqettiide giigetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Phawuloosa bolla hewaa maqqetteedda asatuu oytamuwaappe dariino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Unttunttu qeesatuwaa kaappatuwakkonne cimatuwaakko yiide, “Nuuni Phawuloosa wodhana gakkanaassi, aynne baarennaadan, giigetti utteeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Hewaa diraw, hinttenttunne shiiqeedda asay Phawuloosabaa geeshshiide biddiyaawaa malatiide, olaa kaappuu A hinttenttukko duge wothana mala oochchite; nuuni I haa shiiqanaappe kasenna A wodhanaw giigi utteeddo” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Shin Phawuloosa michchatti na7ay he maqquwaa siseedda wode, biide wottaaddaratuu de7iyaasaa geliide, Phawuloosaw odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Phawuloosi xeetatuwaa kaappatuwaappe ittuwaa xeesiide, “Ha na7aa olaa kaappuwaakko afa; ayissi gooppe, olaa kaappuwaassi I odiyaawe de7ee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Hewaa diraw, xeetatuwaa kaappuu na7aa olaa kaappuwaakko afiide, “Qasho gollen de7iyaa Phawuloosi, ha na7ay new ayentto odiyaabay de7iyaa diraw, taana barekko xeesiide, A neekko ahanaadan, taana woosseedda” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Olaa kaappuu na7aa kushiyaa oyqqiide, dumma gaxaa kessiide, “Neeni taw odanabay ayee?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na7ay olaa kaappuwaassi, “Ayihudatuu Phawuloosabaa kaseppe minissi oochchiyaawaa malatiide, neeni shiiquwaa A utissanaadan, neena wontti woossanaw zoretaa qachcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Shin neeni unttunttu giyaawaa sisoppa; ayissi gooppe, oytamuwaappe dariya asatuu Phawuloosa wodhana gakkanaassi, qumaa meennaadaaninne haathaa ushennaadan, caaqettiide geemetti uttiide A naagiino; neeni giyaawaa sisanaw ha77ikka giigetti uttiide naagiino” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Hewaa diraw, olaa kaappuu na7aa, “Ha yewuwaa neeni taana erisseeddawaa oossinne odoppa” yaagiide azazeeddawaappe guyyiyan, A yeddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Olaa kaappuu xeetatuwaa kaappatuwaappe laa77uwaa xeesiide, “Qiisaariyaa baanaw, laa77u xeetu wottaaddaratuwaa, laappun tammu paraa oyqqeedda asatuwaanne laa77u xeetu tooranchchatuwaa qammaappe heezzu saatiyaan giigissite; ");
INSERT INTO dwrNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","gadiyaa mooddiyaa Filikisakko Phawuloosa sarotethaan gathanaw togissiyaa mehiyaanne giigissite” yaagiide, unttuntta azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Olaa kaappuu hawaadan giyaa dabidaabbiyaa xaafeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Qalawudeyoosa Luusiyoosappe; gadiyaa mooddiyaa bonchchetteedda Filikisaa! Sarotethay new gido. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ayihudatuu ha bitaniyaa oyqqiide wodhana hanishshin, Roome katamaa asa I gideeddawaa eraade, wottaddaratuwaanna gakkaade A ashshaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Unttunttu A ayissi mooteeddinontto eranaw koyyaade, duge unttunttu shiiquwaassi A afaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Unttunttu barenttu higgiyaabaa I oochcheeddawaassi A mooteeddawaappe attin, A wodhissiyaa woy qashissiyaa mooto gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Unttunttu ha bitaniyaa bolla maqqetti utteedda zigirissay taana gakkina, taani he man77iyankka A neekko yeddaa aggaaddi; A mootiyaawanttukka biide, ne sinthan mootana mala odaaddi; saro de7a” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Hewaa diraw, wottaaddaratuu azazetteeddawaadankka Phawuloosa akkiide, qamma Anttiphaaxiriisa gatheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wonttissa gallassi aananna baana mala paraa toggo asatuwaa wothiide, gediyaan biyaawanttu guyye wottaaddaratuu de7iyaasaa simmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Paraawanttu Qiisaariyaa geliide, dabidaabbiyaa gadiyaa mooddiyaawoo immiide, Phawuloosa A sintha aatheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gadiyaa mooddiyaawe dabidaabbiyaa nabbabeeddawaappe guyyiyan, Phawuloosi haqa awuraajjaa asentto A oochcheedda; Kilqqiyaa asa I gideeddawaa ereedda wode, ");
INSERT INTO dwrNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Taani nebaa neena mootiyaawanttu yiyaa wode sisana” yaagiide, wottaaddaratuu Heroodisa kawutethaa gollen A naagana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ichcheshu gallassaappe guyyiyan, qeesatuwaa ubbatuwaa kaappuu, Hanaaniyaa, cimatuwaannannee Xarxxaluusa giyaa itti xabaqaanna duge Qiisaariyaa wodhdheedda; unttunttu gadiyaa mooddiyaawaa bolla Phawuloosa mooteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Phawuloosi xeesetteedda wode, Xarxxaluuse A hawaadan yaagiide, mootuwaa doommeedda. “Bonchchetteedda Filikisaa, nuuni ne bagganna daro sarotethaa demmeeddoshshin, ne qofaan ha gadiyaassi ubbabaani ubbasankka lo77o laamii beettiyaawoo neena loythi galatiide, hawaa akkeetto. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Shin taani neena gami77ethennaan, dooya gideedda ne keekatethaan nubaa neeni qanthaan sisana mala, neena woossay. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ayissi gooppe, ha bitani dhubo gidiide, sa7aa ubbaan de7iyaa Ayihudatuwaa giddon walassaa dentheedda, Naaziraawatu bagga asaa kaalethiyaawaa gideeddawaa ereeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Haray atto Geeshsha Golliyaakka tunissanaw koyyishshin A oyqqiide, nu higgiyaadan, A bolla pirddanaw qoppeeddo; ");
INSERT INTO dwrNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","shin olaa kaappuwaa Luusiyoosi yiide, wolqqaan nu kushiyaappe A wothi akkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","A mootiyaawanttukka neekko yaana mala azazeedda; neeni ne huuphew ha bitaniyaa biddaade, nuuni A mootiyaa yewuwaa ubbaa eranaw danddayaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayihudatuukka qassi, “Ha yewuu tuma” giide, A qofaa akkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gadiyaa mooddiyaawe Phawuloosa yaanaadan wuttina, I hawaadan yaagiide zaareedda; “Neeni daro wodiyaappe doommaade, ha asaassi pirddaadde de7iyaawaa taani eraade, ta yewuwaa nashechchaan zaaray. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Taani Yeerusalaame goyinnanaw kesoodeppe tammanne laa77u gallassaappe darennawaa neeni ne huuphew erana danddayaa. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ayihudatuu taana Geeshsha Golliyan gidina, Ayihuda woosa gollen gidina, katamaan gidina, oonannanne palumettishshin woy asaa shiishshaade maqqishshin, itti uraannanne be7ibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Unttunttu ha77ikka taana mootiyaawaa shatimmanaw danddaykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Shin taani hawaa new oday; taani Muse higgiyan de7iyaawaanne nabatuu xaafeedda ubbabaa ammananaadan, nu aawatuwa Xoossaassi unttunttu worddo giyaa ogiyaan goshetay. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Hawanttu barenttu huuphew, ‘Asay ubbay, wordduukka xilluukka hayquwaappe denddanawantta’ giyaawaadan, taanikka unttunttu denddiyaawaa Xoossaani hidootaa wothaade amuwaani naagay. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Hewaa diraw, taani qassi, Xoossaa sinthaninne asaa sinthan ubba wode, pokkuu baynna tilla wozanay taw de7ana mala minnay. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Taani Yeerusalaameppe kesoodeppe cora laythaappe guyyiyan, ta gade hiyyeesaassi miishshaa immanawunne yarshshuwaa yarshshanaw Yeerusalaame baaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Hewaa oothishshin, asay shiiqennaan, walassay denddennaan, taani Geeshsha Golliyan geeyyishshin, unttunttu taana demmeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Shin Iisiyappe yeedda itti itti Ayihudatuu hewaan de7iino; unttunttu ta bolla yewuwaa koyyooppe, yiide taana ne bollan mootanaw bessee. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","21","Woy taani unttunttu giddon eqqaade, ‘Hayqqeeddawanttu denddanawaa ammaniyaa diraw, hachche hintte sinthaan ta bolla pirddiino’ gaade haa dhoqqissaade hasayeedda itti qaalaappe attin, shiiquwaa sinthan eqqishshin, ta bolla itti bayizzuwaa demmeeddawaa gidooppe, hawanttu barenttu huuphew hawaan odanawantta” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Shin Filikise Xoossaa ogiyaabaa geeshshi ereedda diraw, “Taani hintte yewuwaa olaa kaappuwaa Luusiyoosi yiyaa wode ogiyaa oythana” yaagiide, pirddiyaa wodiyaa sinthaw keereedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Filikise qassi Phawuloosa qachchennaan naagana malanne A dabbatuwaappe ooninne aw oothishshin, woy aakko yiishshin diggenna mala, xeetatuwaa kaappuwaa azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Amareedda gallassaappe guyyiyan, Filikise Ayihuda asaa zare gideedda bare machchatti Dirusillinna yiide, Phawuloosa kiitti ahissiide, Yesuusi Kiristtoosan ammaniyaa ogiyaa I haasayishshin siseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Phawuloosi xillotethaabaa, bare huuphiyaa naaguwaabaanne yaana pirddaabaa haasayishshin, Filikise yayyiide, “Neeni ha77iw ba; taw miikkeedda wode, neena kiittaade xeegissana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","He wode qassi Phawuloosi bilettanaw, barew maganxxaa immanddeeshsha giide qoppeedda; hewaa diraw, daro wode A ahissi ahissiide, aananna haasayee. ");
INSERT INTO dwrNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Laa77u laythaa kumeeddawaappe guyyiyan, Filikisa kotaa Phorqqiyoosa Pisxxoosi akkeedda. Filikise Ayihudatuwaa nashechchanaw koyyiide, qasho gollen Phawuloosa bashi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pisxxoosi awuraajjaa geleedda heezzenthiyaa gallassaappe guyyiyan, Qiisaariyaappe Yeerusalaame beedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Yaani qeesatuwaa kaappatuunne Ayihudatuwaa kaalethiyaawanttu Phawuloosa mooteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Unttunttu Phawuloosa wodhanaw ogiyaan qosetti uttanaw, barenttoo lo77obaa udiide A Yeerusalaame ahana mala, Pisxxoosa woosseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pisxxoosi unttunttoo, “Phawuloosi Qiisaariyaan qashetti utteedda; taani ta huuphewukka ellekka yaa guyye simmanaw qoppa uttaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Hewaa diraw, I ayentto bayizzeeddawe de7ooppe, hinttenttu giddon aawotiyawanttu taananna Qiisaariyaa biide, A mootino” yaagiide zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pisxxoosi Yeerusalaamen hosppun woy tammu gallassaappe aathennaan uttiide, Qiisaariyaa beedda; wonttissa gallassi pirddiyaasan uttiide, Phawuloosa ahana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","I gakkeedda wode, Yeerusalaameppe yeedda Ayihudatuu A matan yuuyyi aadhdhi eqqiide, barenttoo shatimmanaw danddayettenna daro deexo mootuwaa A bolla wotheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Phawuloosi mootettiidde, “Taani Ayihudatuwaa higgiyaakka Geeshsha Golliyaakka Roome Kaatiyaa Qeesaarakka aynne naaqqabeykki” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pisxxoosi Ayihudatuwaa nashechchanaw koyyiide Phawuloosa, “Pude Yeerusalaame kesaade, ha yewuwaabaa yaani ta sinthan ooshettanaw koyyay?” yaagiide oochcheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Shin Phawuloosi, “Taani ooshettanaw bessiyaa Qeesaara pirdda gollen eqqaaddi. Neenikka loytha eriyaawaadan, taani Ayihudatuwaa aynne naaqqabeykki. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Simmi taani naaqqeeddawaa woy hayqqanaw bessiyaawaa ootheeddawaa gidooppe, hayquwaappe attana giikke; shin unttunttu taana mootiyaa mootuu mela gideeddawaappe hini baggan, ooninne taana unttunttoo aathiide immanaw danddayenna; Qeesaare tabaa pirddo gaade oochchay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Hewaappe guyyiyan, Pisxxoosi barenanna zorettiyaawanttunna zoretti simmiide A, “Neeni Qeesaare tabaa pirddo gaade oochchaadda; Qeesaarakko baanaassa” yaagiide zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Amareedda gallassaappe guyyiyan, Kaatiyaa Agriiphphaynne Bariniiqe Pisxxoosa sarotanaw Qiisaariyaa beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Yaani unttunttu cora gallassaa utti de7ishshin, Pisxxoosi kaatiyaassi Phawuloosabaa hawaadan yaagiide odeedda; “Hawaan Filikise qachchiide bashi beedda itti bitani de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Taani Yeerusalaamen de7ishshin, qeesatuwaa kaappatuunne Ayihuda cimatuu A bolla pirddana mala, taana woossiidde, aabaa taw odeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Taani, ‘Mootetteedda uray barena mootiyaawanttunna ittippe eqqennaaninne barena mooteedda yewuwaassi zaaruwaa immennaan, oona gidooppenne aathiide immiyaawe Roome asaassi woga gidenna’ yaagaade unttunttoo zaaraaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Hewaa diraw, unttunttu hawaan shiiqeedda wode, taani gami77ennaan wonttissa gallassi, pirdda golle gelaade Phawuloosa ahana mala azazaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","A mootiyaawanttu eqqiide, iitabaan A mootennaan aggikkino gaade taani qoppeeddawaadan, aynne A mootibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Shin unttunttu barenttu ammaneeddabanttubaanne Phawuloosi, ‘Paxa de7ee’ giyaa hayqqeedda itti Yesuusa geetettiyaa bitaniyaabaa aananna palumetteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Taani ha yewuwaa wootaade bidda demmanitantto, qofaa qachchennaan de7aadde, Phawuloosi Yeerusalaame biide, ha yewuwaa yaani ooshettanaw koyyinttonne gaade A oochchaaddi; ");
INSERT INTO dwrNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","shin Phawuloosi bare yewuwaa Awugisxxoose Qeesaare ogiyaa oythana gakkanaw naagettanaadan oochchina, taani A Qeesaarakko yeddana gakkanaassi, I qashettana mala azazaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Hewaappe guyye Agriiphphay Pisxxoosa, “Taani ta huuphewukka qassi he bitani giyaawaa sisana koyyay” yaageedda. Pisxxoosi A, “Neeni wontti I giyaawaa sisanaassa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wonttissa gallassi, Agriiphphaynne Bariniiqe daro bonchchuwan olaa kaappatuwaannanne katamaan de7iyaa wolqqaama asaanna yiide, pirdda golle geleeddino; Pisxxoosi Phawuloosa ahana mala azazina aheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Pisxxoosi hawaadan yaageedda; “Kaatiyaa Agriiphphaa, hawaan nuunanna de7iyaa asaa ubbaw, Ayihuda asay ubbay Yeerusalaamenikka hawankka waassiidde, ‘I hawaappe sinthaw paxa de7anaw bessenna’ yaagiide, taana woosseedda bitaniyaa hawaa be7iita. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Shin I aynne hayqqanaw bessiyaawaa ootheeddawaa taani demmabeykke; I bare huuphew, ‘Awugisxxoose Qeesaare tabaa pirddo yaagaade oochchaaddi’ geedda diraw, Qeesaarakko A yeddanaw taani qoppaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Taani aabaa ta godaa Awugisxxoose Qeesaaressi xaafanaw tumu yewuu taw aynnee baawa; hewaa diraw, I loythi ooshettowaappe guyyiyan, taani xaafiyaabaa demmana mala, hinttenttu sintha, Kaatiyaa Agriiphphaa, ubba ne sintha A ahaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ayissi gooppe, qashetteedda uraa kiittiyaa wode, A ayaw mooteeddentto, erissennaan co77u gi bashiyaawe taw eeyatethaa malatee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agriiphphay Phawuloosa, “Neeni nebaa haasayanaw danddayaa” yaageedda. He wode Phawuloosi bare kushiyaa micciide hawaadan yaagi zaareedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","3","“Kaatiyaa Agriiphphaa, Ayihudatuwaa wogaanne palumaa ubbaa neeni loythaade eriyaa diraw, taana Ayihudatuu mootiyaa yewuwaa ubbaa hachche taani ne sinthan zaariyaawoo ta qaaday darissi lo77a yaagaade qoppay; hewaa diraw, neeni ta haasayaa salettennaan sisana mala, neena woossay. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Taani na7atethaappe doommaade ta asaa giddoninne Yeerusalaamen de7eedda ta de7uwaa Ayihuda ubbatuu kaseppe doommiide eriino. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Taani koyroppe doommaade, nu ammanuwaa higgiyaa ooppenne minissiide naagiyaa Parisaawatuwaa bagga Parisaawe gidaade de7iyaawaa, unttunttu markkattanaw koyyooppe eriino. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Taani ha77ikka Xoossay nu aawatuwassi immana geeddawaa nashechchaan naagiyaa diraw, pirddettanaassi hawaan eqqay. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Qassi tammanne laa77u nu aawatuwa zaratuu Xoossaw qammanne gallassi ubbaade minissi goyinniidde, Xoossay immana geeddawaa akkanaw nashechchaan naagiino; Kaatiyaa Agriiphphaa, Ayihudatuu taana mootiyaawe taani hewaa nashechchaan naagiyaa diraassa. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ayihudatoo, Xoossay hayqqeeddawantta denthiyaawaa ayissi ammanikkitee? ");
INSERT INTO dwrNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Taani ta huuphewukka Naazireetiyaa Yesuusa eqettanaw bessee gaade kase qoppaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Taani Yeerusalaamen ootheeddawe hawaa; qeesatuwaa kaappatuwaappe maataa akkaade, Xoossaa asatuwaappe coratuwaa qashissaaddi; unttuntta wodhiyaa wodekka unttunttu hayqqiyaawaa dosaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ayihuda woosa golle ubbaan daro wode unttuntta muraadde, barenttu ammanuwaa unttunttu aggana mala godetaaddi; taani wogay baynnawaa unttunttoo hanqqettaade, haray atto, hara gadiyaa katamaa gakkanawukka unttuntta metoothay. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Taani ha yewuwaassi qeesatuwaa kaappatuwaappe maataanne azazuwaa akkaade Damasqqo baaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kaatew, taani seeta gallassi ogiyaan de7ishshin, awaa poo7uwaappe loythi aadhdhiyaa poo7uu taananne taananna beeddawantta yuuyyi aadhdhiide, saluwaappe poo7ishshin be7aaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nuuni ubbay sa7aan kunddeedda wode, Ibraayisxxe qaalaan, ‘Saa7oolaa, Saa7oolaa, taana ayaw yedesaan metoothay? Neeni taana ixussaan neena qohaasa’ yaagiide taw odishshin sisaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Yaataade, ‘Ta Godaw, neeni oonee?’ yaagaaddi. “Goday, ‘Taani neeni yedesaan metoothiyaa Yesuusa. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Shin dendda eqqa; ayissi gooppe, hachche neeni taana bee7eeddawaanne taani neena sinthappe bessanawaa haranttoo markkattana mala, taw oothiyaawaa udaade neena sunthanaw new qonccaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","18","Unttunttu taana ammanina, unttunttu nagaray atto geetettanaadan, Xoossay dooreedda asaa giddon unttunttu barenttu de7iyaasaa demmanaadan, qassi dhumaappe poo7uwaa simmanaadaaninne xalahiyaa godatethaappekka Xoossaakko simmanaadan, unttunttu ayfiyaa neeni dooyyana mala, Israa7eeliyaa asaappenne taani neena unttunttukko kiittiyaa Ayihuda gidennawanttuppe neena ashshana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Kaatiyaa Agriiphphaa, hewaa diraw, taw saluwaappe beetteedda saxaassi taani azazettanawaa ixxabeykke. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Shin taani kasetaade, Damasqqoninne Yeerusalaamen hewaappe guyyiyan, Yihudaa gadiyaa ubbaan de7iyaawanttussinne Ayihuda gidennawanttoo barenttu nagaraappe simmana mala, qassi nagaraappe simmanaw bessiyaawaa oothiidde, Xoossaakko simmana mala qaalaa odaaddi. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Hewaa diraw, Ayihudatuu taana Geeshsha Golliyan oyqqiide wodhanaw koyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","23","Hewaa diraw, taani Xoossaa maaduwaa akkaade, daroonne guuthaw hachche gakkanawukka eqqaade markkattay. Nabatuunne Muse, ‘Kiristtoosi metootanaw bessee; qassi hayquwaappe koyro denddiide, Ayihudatuwassinne Ayihuda gidennawanttoo atotethaa poo7uwaa odanaw bessee’ geeddawaadan, taanikka unttunttu haasayeeddawaappe haraa ittibaanne haasayeeddabay baawa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Phawuloosi barenttubaa hawaadan yaagiide zaarishshin, Pisxxoosi kooshshaa dhoqqu udiide A haasayaa dhubbanaw, “Phawuloosaa, neeni gooyaa; neeni darii tamaareeddawe neena gooshshana hanee” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Shin Phawuloosi hawaadan yaageedda; “Bonchchetteedda Pisxxoosaa, taani tumatethaan lo77o yewuwaanne wozanaa qofaa haasayiyaawaappe attin gooyikke. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Taani Kaatiyaa Agriiphphaassi ha yewuwaa qoncciyaan odiyaawaa I eree; ayissi gooppe, ha yewuu geeman oosettibeenna diraw, hawaappe ittuunne aappe geemmennawaa taani geeshshaade eray. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","“Kaatiyaa Agriiphphaa, neeni nabatuu geeddawaa ammanay? Neeni unttunttu geeddawaa ammaniyaawaa taani eray” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kaatiyaa Agriiphphay Phawuloosa, “Ha77i ha qantha wodattinkka taana ammanthanaw koyyay?” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Hewaappe guyye Phawuloosi, “Daro wode gidina, guutha wode gidina, ne xalalaa gidakka; shin hachche taani odiyaawaa sisiyaa ubbay qassi tawaadan qashettoppino attin, ta mala gidanaadan Xoossaa woossay” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Hewaappe guyyiyan kaatii, mooddiyaa Pisxxoose, Bariniiqenne, unttunttunna de7iyaa ubbay denddi, ");
INSERT INTO dwrNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","itti bagga simmiide, ittu ittuwaanna, “Ha bitani hayqussay atto shin, qashuwaassikka bessiyaabaa oothibeenna” yaagi haaseyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agriiphphay Pisxxoosa, “Ha bitani, ‘Qeesaari tabaa pirddo’ gibeennentto, bilettanaw danddayee shin” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nuuni markkabiyaan Xaaliya baanaw qoppi utteedda wode, Phawuloosanne hara amareedda qashetteedda asatuwaa Awugisxxoosa wottaaddaratuwaa giyaawanttuppe itti Yuuliyoosa giyaa xeetatuwaa kaappuwaassi aathiide immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Iisiya gaxaan de7iyaa gadatuwaa biyaa Adiraamixiyoona markkabiyaan geliide beeddo; Maqidooniyaa asa gidiyaa Teselonqqe Arisxxirokoosi nuunanna de7ee. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wonttissa gallassi nuuni Sidoonaa gakkishshin, Yuuliyoosi Phawuloosaw daroppe A, “Ne dabbatuu neena koshshiyaabaa maaddana mala, neeni unttunttukko baanaw danddayaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Hewaappe denddiide, sinthanna nu bolla carkkiyaa diraw, Qophiroosa haathaan doodetteedda sa7aan carkkenna bagga beeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilqqiyaa mataaninne Phinifiliyaa matan de7iyaa abbaa pinniide, Liqiyan de7iyaa Muura gakkeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Hewaan xeetatuwaa kaappuu Xaaliya biyaa Iskkinddiriyaa markkabiyaa demmiide, aani nuuna gelisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nuuni cora wodiyaa loddaan biidde, daro metuwan Qenidoosa katamaa gakkeeddo; hewaanna baanaw nuuna carkkuu diggina Salmoonanna aadhdhiide, haathaan doodetteedda Qarxxeesan carkkuwaappe te7ettiidde beeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Qassikka daro metuwan gaxanna gaxanna aadhdhiide, Laasiya katamaa matan de7iyaa abbaa doonaan Markkabii Woppu Giide Shemppiyaasaa geetettiyaasaa yeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nuuni hewaan cora wodiyaa gami77eeddawaappe guyyiyan, Xoomay bilettidiggeedda diraw, markkabiyaan biyaawekka hirggishshin Phawuloosi unttuntta zoriidde, ");
INSERT INTO dwrNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Asaw, nu buussan wolqqaama boshaynne daro bashshay de7anawe taw beettee; bashshay yiyaawe caanaa bollanne markkabiyaa bolla xalalaan gidenna; nu shemppuwaa bollaakka yaanawaa” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Shin xeetatuwaa kaappuu Phawuloosi geeddawaappe aathiide, markkabiyaan de7iyaawantta azaziyaawenne markkabiyaa goday giyaawaa ammanee. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","He abbaa mataa katamay balgguwaa shaaccanaw unttunttoo miikkenna katamaa; hewaa diraw, cora asatuu barenttoo danddayettooppe, Pinqqe giyaa katamaa gakkiide, balgguwaa yaani shaaccana mala, yaappe denddanaw zoretteeddino; Pinqqen de7iyaa markkabii shemppiyaa miikko sa7ay doyetteeddawe, away wulliyaasaappenne ushechcha baggappe gidduwan, qassi wulliyaasaappenne haddirssappe gidduwana. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Away kesiyaasaa xeelliyaa wode ushechcha dugehaa bagga carkkuu loddaan carkkeedda wode, barenttu qoppeeddawaadan haneeddawaa unttunttoo malatina denddeeddino; markkabii beenna mala oyqqiyaa birataa pude dafiide, Qarxxeesa matattiide, lanqqiyanna aadhdheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Shin darii gami77ennaan, “Awuraaqiis” giyaa daro wolqqaama gotuu haathaa giddon de7iyaa sa7aappe duge unttunttu bolla denddeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","He gotuu markkabiyaa dechchiide aathennaan diggina, baanaw nuussi danddayettennan ixxeedda diraw, markkabiyaa I afiyaasaa aggiide beeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nuuni Qeeda giyaa haathaan doodetteedda carkkuwaappe geemmeedda saanna aadhdhiyaa wode, darissi metootiide markkabiyaa wonggiriyaan naagi ashshanaw danddayeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Unttunttu wonggiriyaa pude kesseeddawaappe guyyiyan, gaadiyaan markkabiyaa xaaxiide, minissi qachcheeddino; Sirxxisa giyaa shafii kumeedda saan barentta kunddissanenttonne giide hirggiide, markkabiyaa afiyaa sharaa wothiide, carkkuwan markkabiyaa coo yeddii aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Gotuu wolqqaamiide nu bollan wolqqaameedda diraw, wonttissa gallassi caanaappe abbaan oluwaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Heezzenthiyaa gallassikka markkabiyaan de7iyaa miishshaa unttunttu barenttu kushiyan oleeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nuuni daro wodiyaa awaanne xoolinttiyaa be7ennaan, wolqqaama uushuu nu bolla bukkishshin, sinthappe dhayanaan attokko giide qoppeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Unttunttu daro wodiyaa qumaa meennaan gami77eeddawaappe guyyiyan, Phawuloosi he wode unttunttu giddon denddi eqqiide, hawaadan yaageedda; “Asaw, hinttenttu ta zoriyaa akkeeddenttonne Qarxxeesappe denddennaan atteeddentto, hawaa mala bayethaynne qohuu nuuna gakkenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Shin ha77ikka taani hinttentta yayyoppite gaade zoray; ayissi gooppe, ha markkabii bayanaappe attin, hinttenttuppe itti uraa shemppuukka bayenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ayissi gooppe, Xoossaa kiitanchchay, taana mooddeedda taani goyinniyaa Xoossaawe, zino qamma ta matan eqqiide, ");
INSERT INTO dwrNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Phawuloosaa, yayyoppa; neeni Roome gadiyaa Kaatiyaa Qeesaara sinthan eqqanaw bessee; be7a, Xoossay bare keekatethaan neenanna biyaa asaa ubbaa shemppuwaa ashshana’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Hewaa diraw asaw, yayyoppite. Ayissi gooppe, he kiitanchchay taw odeeddawaadan hananawaa taani Xoossaa ammanay; ");
INSERT INTO dwrNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","shin carkkuu nuuna itti haathaan doodetteedda sa7aan abbaa doonaan dom77issana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tammanne oyddentho gallassi Meediteraaniyaa Abbaan nuuna carkkuu yaanne haanne sugishshin, markkabiyaan oothiyaawanttussi qamma bilahii biittaakko mateeddawaa malateedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Unttunttu likkiyaa gaadiyaa xeeraan dexiyaabaa qachchiide, haathaan yeggina, haathay oytamu mitiriyaa ciimmateeddawaa ereeddino. Guuthaa gami77iidde, laa7ethuwaa yeggiide, hattamu mitiriyaa ciimmateeddawaa ereeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Unttunttu shuchchattiyaasan kunddenna mala yayyiide, markkabii beenna mala oyqqiyaa oyddu birataa markkabiyaappe guyyenna abbaan yeggiide, sa7ay wonttana mala, barenttu xoossatuwaa woossiino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Markkabiyan oothiyaawanttu markkabiyaappe kichchanaw koyyiide, markkabii beenna mala oyqqiyaa amareedda biratatuwaa markkabiyaappe sintha bagganna abbaan yeggiyaawaa malatiide, wonggiriyaa abbaan wotheedda wode, ");
INSERT INTO dwrNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Phawuloosi xeetatuwaa kaappuwaanne wottaaddaratuwaa, “Hawanttu markkabiyaa giddon de7ana dhayooppe, hinttenttu attanaw danddaykkita” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Hewaappe guyyiyan, wottaaddaratuu wonggirii qashetteedda gaadiyaa qanxxiide, yeddii aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Sa7ay wonttana hanishshin, Phawuloosi ubbay qumaa maana mala, hawaadan yaagiide woosseedda; “Hinttenttu hachchenna tammanne oyddu gallassaa naageeddita; qassi he ubbankka qumaa mibeykkita. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Hewaa diraw, guutha qumaa hinttenttu maana mala, taani hinttentta woossay; ayissi gooppe, hinttenttu paxa de7anaw guutha qumaa maana koshshee; haray atto hinttenttu huuphiyaa binnanaappe ittuukka bayenna” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Phawuloosi hawaa giide, ukithaa akkiide, ubbaa sinthan Xoossaa galateedda; menthi Muussaa doommeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Hewaappe guyyiyaan ubbay loythi, barenttoo qassi qumaa meeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nuuni markkabiyaan de7iyaawanttu laa77u xeetanne laappun tammanne usuppuna. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Unttunttu miide kaalleedda wode, caanaa zarggaa abbaan oliide markkabiyaa deexuwaa kawushisseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Sa7ay wontteedda wode, markkabiyaan oothiyaawanttu gadiyaa eribeykkino; shin haathay goggiide abbaan geleeddasaa miyyiyaan de7iyaa shafiyaa akeekaan xeelleeddino. Barenttussi danddayettintto, markkabiyaa he shafiyaakko laagganaw barenttu qofaa qachcheeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Yaatiide markkabii beenna mala oyqqiyaa biratatuwaa billiide, abbaa giddo yeggeeddino; he wode, markkabiyaa koyyeeddasaa zaariide laaggiyaa mithaa qachcheedda gaadiyaa billeeddino; hewaappe guyyiyan, carkkuu markkabiyaa sinthaw sugana mala, markkabiyaa afiyaa sharaa sintha bagganna dhoqqu udiide, buussaa doommeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Shin markkabii ciimmuu de7iyaasaappe aadhdhiide haathaan doodetteedda sa7aa matan de7iyaa dethasaan dom77etti eqqeedda; markkabiyaassi guyye baggay beetaa sugethaan me7erettishshin, sintha baggay duge dhishettiide, qaaxxennaan ixxi aggeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wottaaddaratuu qashetteedda asaappe ittuunne haathaa wadhdhiide kessi akki beenna mala, unttuntta wodhanaw zoretteeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Shin xeetatuwaa kaappuu Phawuloosa ashshanaw koyyiide, wottaaddaratuwaa maqquwaa ixxeedda; haathaa wadhaa eriyaa ubbay markkabiyaappe haathaan guppi guppiide kasetiide gaxaa kesana mala azazeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Atteeddawanttuppe amareeddawanttu sanqqaan, amareeddawanttu qay markkabiyaa me7uwan kesana mala azazeedda; hewaadan ubbatuukka gaxaa sarotethaan keseeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nuuni gaxaa sarotethaan keseedda wode, he haathaan doodetteedda sa7ay Malttaa geetettiyaawaa ereeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Haathaan doodetteedda sa7aan de7iyaa asatuu nuussi daro keekatethaa keekeeddino; iray bukkanaw doommeedda dirawunne meeguwaa diraw, tamaa eethiide, nuuna ubbaa mokkeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Phawuloosi daro qayxeeriyaa mithaa mixiide tamaan yeggishshin, marzzaama shooshshay seelaa diraw kesiide, A kushiyan xaaxettiide, A dukkeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Haathaan doodetteedda sa7aan de7iyaa asatuu qirccanttiyaa shooshshay Phawuloosa kushiyan xaaxetteeddawaa be7eedda wode ittu ittuwaassi, “Tumu ha bitani shemppuwaa wodhiyaa asa; haray atto abbaappe I attinakka nu Xoossaa pirdday A paxa de7o gibeenna” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Shin Phawuloosi bare kushiyaappe qirccanttiyaa shooshshaa wuxakkiide, tamaan oleedda; A aynne oothibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Unttunttu, “A bollay gaafee; woy akeekennaan kunddiide hayqqee” yaagiide A naagiino; shin cora wodiyaa naagiide, A bollan aynnee dummateeddabay dhayina, “Hawe xoossaa” yaagiide barenttu qofaa bashi aggeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Hewaa heeran haathaan doodetti utteedda sa7aa kaappuwaa Pupiliyoosa giyaawaassi gadii de7ee; I nuuna imathatethaa, heezzu gallassaa siiquwan mokki moyizzeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pupiliyoosa aabbu qoxuwaa, seelaanne uluwaa kadhaa saketti gisiide de7ee; Phawuloosi A soy geliide, aw Xoossaa woosseedda; bare kushiyaa A bolla wothiide, A patheedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hewaappe guyyiyan, he haathaan doodetteedda sa7aan harggiyaa hara ubba asaykka qassi yiide paxeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Hewaappe simmina nuuna daro bonchchuwaa bonchcheeddino; nuuni markkabiyaan baanaw denddeedda wode, ogew nuuna koshshiyaabaa nuussi immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Heezzu agenaappe guyyiyan, haathaan doodetteedda sa7aan balgguwaa aathiide, “mantte xoossaa” giyaa Iskkinddiriyaa markkabiyaan baanaw denddeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nuuni Siraakuse giyaa katamaa geliide, yaani heezzu gallassaa utteeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Hewaappe yuuyyiidde, Regiiyume giyaa katamaa gakkeeddo. Itti gallassaappe guyyiyan, away kesiyaasaa xeelliyaa wode ushechcha dugehaa bagga carkkuu carkkina, wonttissa gallassi Putiyaaluusa giyaa katamaa yeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Hewaan nuuni itti itti ammaniyaawantta demmina, barenttunna laappu gallassaa uttana mala, nuuna woosseeddino; hewaappe qassi Roome yeeddo. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Roomen de7iyaa ammaniyaawanttu nubaa sisiide, Afiyaasaa Geyaanne “Heezzu Aqiyaasaa geetettiyaasaa” gakkanaassi nuuna mokkanaw yeeddino; Phawuloosi unttuntta be7eedda wode Xoossaa galatiide, wozanaan minisseedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nuuni Roome geleedda wode, Phawuloosi barena naagiyaa wottaaddaraanna barekka de7anaadan udetteedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Heezzu gallassaappe guyyiyan, Phawuloosi Ayihudatuwaa kaappatuwaa barekko xeeseedda; unttunttu shiiqeedda wode, unttuntta hawaadan yaageedda; “Taanaadan ammaniyaawanttoo, taani nu asaa woy nu aawatuwa wogaa iitabaa aynne oothennaan, taana Yeerusalaamen qachchiide, Roome asaassi aathiide immeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Unttunttu taana biddeeddawaappe guyye, hayqqanaw bessiyaabay ta bolla aynne bayinna diraw, taana billanaw koyyeeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Shin hewaa Ayihudatuu eeno geennaan ixxeedda wode, ‘Tabaa Qeesaare pirddo’ gaanawe taana koshsheeddappe attin, taani ta zariyaa mootiyaabay taw de7ina gidenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Taani hinttenttunna gakettanawunne haasayanaw hinttentta xeeseeddawe hewaassa; ayissi gooppe, Israa7eeliyaa asay nashechchaan naagiyaawaa diraw taani ha santhalataan qashettaaddi” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ayihuda cimatuu Phawuloosa, “Nuuni Yihudaappe nebaw dabidaabbiyaa akkibeykko. Nu ishatuwaappekka haray atto, ittuukka yiide, nebaa odibeenna; woy ne sunthaa bayizziide, nuussi odibeenna. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Shin he asaa sunthaa ubbasan asay bayizziide haasayiyaawaa nuuni eriyaa diraw, ne qofaa sisanaw koyyeetto” yaageeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Unttunttu barenttu yaana gallassaa Phawuloosaw keeriide, he gallassi coriide I de7iyaasaa yeeddino; ikka unttunttoo Xoossaa kawutethaabaa markkatteedda. Qassi unttunttu Yesuusabaa ammanana mala, Muse higgiyaappenne nabatuu xaafeeddawaappe akkiide unttuntta tamaarissiidde, wonttappe omarssi gakkanaw loythi odeedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Baggatuu Phawuloosi geeddawaa ammaneeddino; shin baggatuu ammanibeykkino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Unttunttu barenttu giddon yewuwaa eeno geennaan ixxeedda wode, Phawuloosi ittibaa geeddawaappe guyyiyan beeddino; I hawaadan yaageedda; “Geeshsha Ayyaanay nu aawatuwassi nabiyaa Iisiyaasa maxaafaan, ");
INSERT INTO dwrNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Neeni he asaakko baade hawaadan ga; “Hinttenttu sissaa sisana, shin hinttenttoo gelenna; hinttenttu xeelaa xeellana, shin be7ikkita. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ayissi gooppe, ha asaa wozanay guzumeedda; barenttu haythaa tullisseeddino; barenttu ayifiyaakka ciilummeeddino. Hewe baawentto, barenttu ayfiyaan be7ana; unttunttu haythaykka sisana; unttunttu wozanaykka akeekana; unttunttu taakko Xoossaakko simmana. Qassi taanikka unttuntta pathana” yaaga’ yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Simmi hawe Xoossaa atotethay, Ayihuda gidennawanttoo kiitetteeddawe hinttenttoo eretto. Qassi unttunttukka sisana” yaageedda. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Phawuloosi hewaa geeddawaappe guyyiyan, Ayihudatuu barenttu giddon daro palumettiidde beeddino. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Phawuloosi kiraa golliyaan laa77u laythaa kumenthaa de7iidde, barekko yiyaa ubbaa mokkee. ");
INSERT INTO dwrNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Barena ooninne diggennan Xoossaa kawutethaabaanne Godaa Yesuusi Kiristtoosabaa odiidde, yayyennaan darii qonccissiide tamaarsseedda.");
INSERT INTO dwrNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Bare mishiraachchuwaa qaalaa odanaw Xoossay dooriide xeeseedda Kiristtoosa Yesuusa qoomay, Yesuusi Kiristtoosi kiitteedda Phawuloosi, taani ha dabidaabbiyaa xaafay. ");
INSERT INTO dwrNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Xoossay daro wodeppe kase bare nabatuwaa bagganna mishiraachchuwaa qaalaa immana yaageeddawe Xoossaa Geeshsha Maxaafatuwan xaafetteedda; ");
INSERT INTO dwrNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","he mishiraachchuwaa qaalay asa gidiide Daawite zariyaappe yeletteedda Xoossaa Na7aa, nu Godaa Yesuusi Kiristtoosabaa. ");
INSERT INTO dwrNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Qassi I bare Geeshsha Ayyaanaan hayquwaappe denddeeddawaan, Xoossaa Na7aa gidiyaawaa wolqqaama wolqqaan besseedda. ");
INSERT INTO dwrNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ayihuda gidenna asay ubbay ammananaadaaninne azazettanaadan, nuuni unttuntta kaalethana mala, Xoossay Kiristtoosa sunthaa diraw, Kiristtoosa bagganna aadho keekatethaanne Yesuusi kiitteeddawantta gidiyaa maataa nuussi immeedda. ");
INSERT INTO dwrNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Yesuusi Kiristtoosawaa gidanaadan, Xoossay xeeseedda hinttenttukka hewanttu giddon de7iita. ");
INSERT INTO dwrNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Xoossay siiqiyaawanttoonne geeshshabaa oothanaw xeeseedda Roome gadiyan de7iyaa ubbatoo Xoossaa nu Aawuwaappenne Godaa Yesuusi Kiristtoosappe aadho keekatethaynne sarotethay hinttenttoo gido. ");
INSERT INTO dwrNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kasetaade taani hinttenttu ammanuu sa7aa ubbaan sisetteedda diraw, Yesuusi Kiristtoosa bagganna hinttenttoo taani Xoossaa galatay. ");
INSERT INTO dwrNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","10","Ayissi gooppe, taani ubba wode ta woosaan hinttentta hassayissiyaawoo, Xoossay, taani A Na7aa mishiraachchuwaa qaalaa odiyaawaan ta ayyaanan aw oothiyaawe markka. Xoossa