﻿USE sofia;
DROP TABLE IF EXISTS sofia.dwrENT_vpl;
CREATE TABLE dwrENT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dwrENT_vpl WRITE;
INSERT INTO dwrENT_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ጾሳይ ሳሎቱዋነ ሳኣ ኮይሮ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ሄ ዎደ ሳአይ ጊግቤናነ አያይነ ባይና መላ፤ ጪሙዋ ቦላን ꬉማይ ደኤ፤ ጾሳ አያናይ ሃꬃፐ ቦላና ማይ ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ጾሳይ ሄዋፐ ጉየ ሀዋዳን ያጊደ ሃሳዬዳ፤ “ፖኡ ሀኖ” ያጌዳ፤ ፖኡካ ሀኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ፖኡ ሎአ ግዴዳዋ ጾሳይ በኤዳ፤ ያቲደ ፖኡዋ ꬉማፐ ሻኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ጾሳይ ፖኡዋ “ጋላሳ” ጊደ ሱንꬄዳ፤ ꬉማ “ቃማ” ጊደ ሱንꬄዳ። ሳአይ ቃሜዳነ ዎንቴዳ፤ ሄዌነ ኮይሮ ጋላሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","ጾሳይ ሄዋፐ ጉየ ሀዋዳን ያጊደ ሃሳዬዳ፤ “ቦላና ደእያ ሃꬃ ጋርሳና ደእያ ሃꬃፐ ሻክያ ሳሉዋ ጉፋንꬁ ሀኖ” ያጌዳ፤ ጌተቶዋዳንካ ሀኔዳ። ጾሳይ ሳሉዋ ጉፋንꬁዋ ጊግሲደ፥ ሳሉዋ ጉፋንꬁዋፐ ቦላና ደእያ ሃꬃ ጋርሳና ደእያ ሃꬃፐ ሻኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ጾሳይ ሄ ጉፋንꬁዋ “ሳሉዋ” ጊደ ሱንꬄዳ። ሳአይ ቃሜዳነ ዎንቴዳ፤ ሄዌነ ላኤንꬆ ጋላሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ጾሳይ ሄዋፐ ጉየ ሀዋዳን ያጊደ ሃሳዬዳ፤ “ሳሉዋፐ ጋርሳና ደእያ ሃꬃይ እትሳን ኤሎ፤ መላ ሳአይ ቆንጮ” ያጌዳ፤ ሄዋፐ ጉይያን ሀኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ጾሳይ ሄ መላ ሳኣ “ቢታ” ጊደ ሱንꬄዳ፤ ቃይ እት ሳኣን ኤሌዳ ሃꬃ “አባ” ጊደ ሱንꬄዳ። ያቲደ ጾሳይ ሄዌ ሎአ ግዴዳዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ሄዋፐ ስሚደ ጾሳይ፥ “ቢታይ ምꬃ ማታ ዶልሶ፤ ዘረꬃ አይፊ ደእያ ካꬃነ ዘረꬃ አይፍያና ደእያ ቴርያ ምꬃ ዶልሶ” ያጌዳ፤ ሄዌካ ሀኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ቢታይ፥ ምꬃ ማታ አ ቆሙዋን ቆሙዋን ዶሌዳ። ጾሳይ ሄዌ ሎአ ግዴዳዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ሳአይ ቃሜዳነ ዎንቴዳ፤ ሄዌነ ሄዘንꬆ ጋላሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ጾሳይ ሄዋፐ ጉየ ሀዋዳን ያጊደ ሃሳዬዳ፤ “ጋላሳ ቃማፐ ሻካናዉ ፖኦቱ ሳሉዋ ጉፋንꬁዋን ሀንኖ፤ ኡንቱቱ ጋላሳ፥ ዎድያነ ላይꬃ ኤርሳናዉ ማላ ግድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ሳኣ ቦላን ፖእሳና ማላ ኡንቱቱ ሳሉዋ ጉፋንꬁዋን ፖእኖ” ያጌዳ፤ ሄዋፐ ጉይያን ሀኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ጾሳይ ላኡ ዎልቃማ ፖኦቱዋ፥ ዳርያዌ ጋላሳ ሞዳናዳንነ ቄራእያዌ ቃማ ሞዳናዳን መꬌዳ፤ ጾልንተቱዋካ እ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","ጾሳይ ኡንቱቱ ሀ ሳኣ ቦላን ፖእሳና ማላ፥ ጋላሳነ ቃማ ሞዳና ማላነ ፖኡዋ ꬉማፐ ሻካና ማላ፥ ሳሉዋ ጉፋንꬁዋን ኡንቱንታ ዎꬄዳ። ያቲደ ጾሳይ ሄዌ ሎአ ግዴዳዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ሳአይ ቃሜዳነ ዎንቴዳ፤ ሄዌነ ኦይደንꬆ ጋላሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ጾሳይ ሄዋፐ ጉየ ሀዋዳን ያጊደ ሃሳዬዳ፤ “ደኡዋን ደእያ ዱማ ዱማ መታቱ ሃꬃን ዳርኖ፤ ካፉካ ሳኣፐ ቦላናነ ሳሉዋ ጉፋንꬁዋፐ ጋርሳና ፓሎ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ያቲደ ጾሳይ አባን ደእያ ዎልቃማ ዶአቱዋ፥ ሃꬃ ግዶን ዎጽ ቃጽያ መታ ኡባነ ቀፍያና ደእያ ካፉዋ ኡባ አ ቆሙዋን ቆሙዋን መꬌዳ። ጾሳይ ሄዌ ሎአ ግዴዳዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ጾሳይ ኡንቱንታ፥ “የለትተ፤ ጮርተ፤ አባ ሃꬃ ኩምተ፤ ካፉካ ቢታ ቦላን ጮራቶ” ያጊደ አንጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ሳአይ ቃሜዳነ ዎንቴዳ፤ ሄዌነ እቼሸንꬆ ጋላሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ጾሳይ ሄዋፐ ጉየ ሀዋዳን ያጊደ ሃሳዬዳ፤ “ደኡዋን ደእያ መታቱ ባረንቱ ቆሙዋን ቆሙዋን: መሄቱ፥ ቢታና ጎሸትያ መታቱነ ዶአቱ ባረንቱ ቆሙዋን ቆሙዋን ቢታ ቦላን ከስኖ” ያጌዳ፤ ሀኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ጾሳይ ዶአቱዋ ኡንቱንቱ ቆሙዋን ቆሙዋን፥ መሄቱካ ኡንቱንቱ ቆሙዋን ቆሙዋን፥ ቢታና ጎሸትያ መታቱዋካ ኡባ ኡንቱንቱ ቆሙዋን ቆሙዋን መꬌዳ። ጾሳይ ሄዌ ሎአ ግድያዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ሄዋፐ ስሚደ ጾሳይ፥ “አሳ ኑ ሌምሱዋን ኑና ማላትሲደ አነ መꬎይተ፤ ኡንቱንቱ አባ ሞልያ፥ ሳሉዋ ካፉዋ፥ ቢታ ቦላ ዎጽ ቃጽያ መታ ኡባ ሞድኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ሀዋዳን ጾሳይ አሳ ባረ ሌምሱዋን መꬌዳ፤ እ አሳ ጾሳ ሌምሱዋን መꬌዳ፤ እ ኡንቱንታ አቱማ አሳነ ማጫ አሳ ኦꬂደ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ጾሳይ ኡንቱንታ ሀዋዳን ያጊደ አንጄዳ፤ “የለትተ፤ ጮርተ፤ ሀ ሳኣ ኩምተነ ሞድተ፤ አባ ሞልያ፥ ሳሉዋ ካፉዋነ ቢታ ቦላ ዎጽ ቃጽያ፥ ደኡዋን ደእያ መታ ኡባ ሞድተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ሄዋፐ ስሚደ ጾሳይ፥ “በእተ! ታን ሀ ቢታ ኡባ ቦላን ዘረꬃ አይፊያና ደእያ ካꬃ ኡባነ ዘረꬃ አይፊያና ደእያ ቴርያ ምꬃ ኡባ ህንተንቶ እማድ፤ ኡንቱንቱ ህንተንቶ ቁማ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ቃይካ ሀ ሳኣን ደእያ መህያዉነ ዶኣ ኡባዉ፥ ሳሉዋ ካፉዋ ኡባዉ፥ ቢታና ጎሸትያ መታ ኡባዉነ ሸምፑዋና ደእያ መታ ኡባዉ ምያዋ ግዳናዳን፥ እርጻ ምꬃነ ማታ እማድ” ያጌዳ፤ ሀኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ጾሳይ ባረ መꬌዳ ኡባባካ ጼሌዳ፤ ዳሮ ሎአ ግዴዳዋ በኤዳ። ሳአይ ቃሜዳነ ዎንቴዳ፤ ሄዌነ ኡሱፑንꬆ ጋላሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ሳሎቱነ ሳአይ ኡንቱንቱን ደእያዌ ኡባባይ ሀዋዳን መት ፖለቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ጾሳይ ባረ ኦꬄዳ ኦሱዋ ኡሱፑንꬃ ጋላስ ፖሊደ፥ ባረ ኦꬄዳ ኦሱዋ ኡባፐ ላፑንꬃ ጋላስ ሸምፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ቃይ ጾሳይ ላፑንꬃ ጋላሳ አንጄዳነ ጌሻ ኦꬄዳ፤ አያዉ ጎፐ፥ ጾሳይ ባረ ኦꬅያ ኦሱዋ ዉርሲደ ሸምፔዳዌ ሄ ጋላሳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ሳሉነ ሳአይ መቴዳዌ ሀዋዳና። መꬍና ጎዳይ ጾሳይ ሳኣነ ሳሉዋነ መꬌዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ሳኣ ቦላን ምꬃይነ ማታይ ዶልቤና፤ ጫርሻይነ ጫርቤና፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ጾሳይ እራ ቡክስቤና፤ ቃይ ቢታ ኦꬅያ አሳይካ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ግዶፐነ ሳኣፐ ሃꬃይ ፑደ ከሲደ፥ ቢታ ኡባ እርጽሴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ሄዋፐ ጉየ፥ መꬍና ጎዳይ ጾሳይ ቢታ ባናፐ እት አሳ መꬊደ አ ሲꬍያን ደኡዋ ሸምፑዋ ሸምፕ ገልሴዳ፤ ያትና ብታኒ ደኡዋን ደእያ አሳ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","መꬍና ጎዳይ ጾሳይ አዋይ ዶልያ ባጋና ኤደነ ግያ ሳኣን ገነትያ ቶኬዳ፤ ያን ባረ መꬌዳ ብታንያ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","መꬍና ጎዳይ ጾሳይ ጼላናዉ ሎእያ፥ ማናዉካ ማልእያ ኡባ ቆሞ ምꬃ ቢታፐ ዶልሴዳ። ገነትያ ግዱዋን ደኡዋ ምꬃነ ሎኡዋነ ኢታ ኤርስያ ምꬃ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ገነትያ ኡሽያ ሻፋ ሃꬃይ ኤደነፐ ጎጌ። ኤደነፐ ከሴዳዋፐ ጉየ፥ ኦይዱ ሻፋ ከስ ሻከቴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ኮይሮ ሻፋ ሱንꬃይ ፕሶና፤ ፕሶን ዎርቃይ ደእያ ኤዉላጻ ግያ ቢታ ኡባ ቦላን ጎጌ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ሄ ቢታ ዎርቃይ ጌሻ ዎርቃ፤ ቃይ አልኦ ሽቱነ ሎይꬅ ሎእያ ሹቻይ ያን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ላኤንꬆ ሻፋ ሱንꬃይ ግዮና፤ ግዮን ቶጵያ ቢታ ኡባ ቦላን ጎጌ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ሄዘንꬆ ሻፋ ሱንꬃይ ጸግሮሳ፤ ጸግሮስ አሶረፐ አዋይ ዶልያ ባጋና ጎጌ። ቃይ ኦይደንꬆ ሻፋይ ኤፍራጺሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ብታኒ ኤደነ ገነትያ ኦꬃና ማላነ ናጋና ማላ፥ መꬍና ጎዳይ ጾሳይ አ አፊደ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","መꬍና ጎዳይ ጾሳይ ብታንያ፥ “ገነትያ ምꬃ ቴራ ኡባፐ ኔን ማና ጎፐ ማ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ሽን ሎኡዋነ ኢታ ኤርስያ ምꬃ ቴራፐ ሞፓ፤ አያዉ ጎፐ፥ ኔን አፐ ሜዳ ጋላስ ቱሙ ሀይቃና” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ሄዋፐ ጉየ መꬍና ጎዳይ ጾሳይ፥ “ብታኒ ባረካ ደእያዌ ሎአ ግደና፤ ታን አዉ እንጀትያኖነ አ ማድያኖ መꬋና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","መꬍና ጎዳይ ጾሳይ መሄቱዋ ኡባ፥ ዶአቱዋ ኡባነ ሳሉዋ ካፎቱዋ ኡባ ቢታፐ መꬌዳ፤ ቃይ ብታኒ ኡንቱንታ ዋግ ሱንꬃነንቶነ በአናዉ አኮ አሄዳ፤ ብታኒ ደኡዋን ደእያ መታ ኡባ ሱንꬄዳ ሱንꬃይ ኡንቱንቱ ሱንꬃ ግዲደ አቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ሄዋዳን ብታኒ መሄቱዋ ኡባ፥ ሳሉዋ ካፎቱዋነ ባዙዋ ዶአቱዋ ኡባ ሱንꬄዳ፤ ሽን አዳማዉ እንጀትያነ አ ማድያዌ ቤትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ሄዋ ድራዉ መꬍና ጎዳይ ጾሳይ ብታንያ ገምእሹዋ ካይሮዬዳ፤ እ ገምእሹዋ ካይሮት ደእሽን፥ አ ምይያ መቀꬃፐ እቱዋ አኪደ፥ ሄ ሳኣ አሹዋ ኩንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","መꬍና ጎዳይ ጾሳይ ብታንያፐ አኬዳ መቀꬃ ማጫውኖ ኦꬄዳ፤ ያቲደ እዞ ብታንያኮ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ያትና ብታኒ፥ “ሀያናሾ! ሀ መቀꬃታ ታ መቀꬃፐ፥ ሀ አሻታካ ታ አሹዋፐ አከቴዳውኖ፤ እዛካ አቱማ አሳፐ አከቴዳ ድራዉ፥ ማጫውኖ ጌተቱ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ሄዋ ድራዉ አሳይ ባረ አዉዋነ ባረ አቶ አጊደ፥ ባረ ማቻትና እትፐ ደአና፤ ኡንቱንቱ ላኡ እት አሾ ግዳናዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ብታኒነ አ ማቻታነ ላአቱካ ካሎ ጺራ ደእኖ፤ ሽን እቱ እቶ ዬላትክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ሾሻይ መꬍና ጎዳይ ጾሳይ መꬌዳ ዶኣ ኡባፐ አꬌዳ ገናንቻ። እት ጋላስ ሾሻይ ሄ ምሽራቶ፥ “ጾሳይ ቱሙ ህንተንታ፥ ‘ገነትያን ደእያ ምꬃ ቴራ ኡባፐ ሞፕተ’ ጌዴ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","ምሽራታ ሾሻዉ ዛራደ፥ “ቱይት፥ ጾሳይ ሀዋዳን ግቤና፤ ኑን ገነትያን ደእያ ምꬃቱዋ ቴራ ማናዉ ዳንዳዬቶ፤ ሽን ጾሳይ ኑና፥ ገነትያ ግዱዋን ደእያ ምꬃ ቴራ ሞፕተ፤ ቦቾፕተ፤ ሄዌ ꬋዮፐ ህንተንቱ ሀይቃንታ ጌዳ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ሾሻይ ምሽራቶ፥ “ቱይት፥ ህንተንቱ አይነ ሀይቂክታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ጾሳይ ሄዋ ጌዳዌ፥ ሄ ምꬃ ቴራ ህንተንቱ ሞፐ፥ ህንተንቱ አይፊ ዶየትና፥ ሎኡዋነ ኢታ ጾሳዳን ህንተንቱ ኤራናዋ እ ኤርያ ድራሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ምሽራታ ሄ ምꬃ ቴራይ ማናዉ ማልእያዋ፥ ጼላናዉ ሎእያዋ፥ ቃይ አሳይ አꬌዳ ኤራ ደማናዉ አሞይያዋ ግድያዋ በኣዱ፤ ሄ ምꬃ ቴራፐ አካደ ማዱ፤ ቃይ ባረናና ደእያ ባረ አስናዉካ ሄዋፐ እምና፥ እካ ሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ሄዋፐ ኡንቱንቱ ላኡዋ አይፊካ ዶየቴዳ፤ ያትና ኡንቱንቱ ባረንቶ ካሎ ጺራ ደእያዋ ኤሬድኖ፤ ባላስያ ግያ ምꬃ ሀይꬃ ስኪደ፥ ባረንቶ ቃንꬃን ዳንጬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ሳአይ ኦማርሴዳ ዎደ፥ ገነትያ ግዱዋን መꬍና ጎዳይ ጾሳይ ሀመትሽን፥ አ ኮሻ ብታኒነ አ ማቻታ ስሴድኖ፤ ኡንቱንቱ ገነትያ ምꬃ ግዶን መꬍና ጎዳ ጾሳፐ ቆሰቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ሽን መꬍና ጎዳይ ጾሳይ ብታንያ ጼሲደ፥ “አዳማ፥ ሀቃን ደአይ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ብታኒ፥ “ገነትያ ግዱዋን ነ ኮሻ ስሳደ፥ ታን ካሎ ደእያ ድራዉ፥ ያያደ ቆሰታድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","መꬍና ጎዳይ ጾሳይ አ፥ “ ‘ኔን ካሎ ደኣሳ’ ጊደ ነዉ ኦዴዳዌ ኦኔ? ታን ኔና፥ ‘ሞፓ’ ጋደ አዛዜዳ ምꬃ ቴራፐ ማድዬ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ሽን እ፥ “ታናና ደአናዳን ኔን እሜዳ ማጫውና ሄ ምꬃ ቴራፐ ታዉ እምና ማድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","መꬍና ጎዳይ ጾሳይ ሄዋፐ ጉየ ማቻቶ፥ “ኔን ሄዋ አያዉ ኦꬃድ?” ያጊደ ኦቼዳ። ምሽራታ፥ “ታና ሾሻይ ጭምና ማድ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","መꬍና ጎዳይ ጾሳይ ሄዋፐ ጉየ ሾሻ፥ “ኔን ሀዋ ኦꬄዳ ድራዉ፥ መህያ ኡባነ ዶኣ ኡባ ጋርሳን ነ ጻላላይ ሸቀቴዳዋ! ኔን ነ ኡሉዋን ቢታና ጎሸታና፤ ነ ደኡዋ ላይꬃ ኡባን ባና ላጫና። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ታን ኔናነ ምሽራቶ፥ ነ ዘረꬃነ እዝ ዘረꬃ ሞርከ ከሳና፤ እ ነ ሁጲያ ቆጻና፤ ኔንካ አ ግንድያ ዱካናሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ምሽራቶካ መꬍና ጎዳይ ጾሳይ፥ “ነ ሻሃሮ ዎደ ዳሮ ቱጋታና፤ ቃይ ኔን ዎልቃማ ኦይꬃን ናና የላና። ግዶፐነ ኔን ነ አስናና ደአናዉ አሞታና፤ እ ኔና ሞዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ብታንያካ መꬍና ጎዳይ ጾሳይ ሀዋዳን ያጌዳ፤ “ኔን ነ ማቻት ኦዱዋ ስሴዳ ድራዉነ ታን ኔና፥ ‘ሄ ምꬃ ቴራ ሞፓ’ ጋደ አዛዜዳ ምꬃ አይፍያ ኔን ሜዳ ድራዉ፥ ቢታይ ነ ጋሱዋን ሸቀቴዳዋ ግዶ! ኔን ነ ደኡዋ ላይꬃ ኡባን ዎልቃማ ዳቡራን ቢታ ጎሻደ ማና። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ቢታይ ነዉ አጉንꬃነ ካሽያ ዶላና፤ ኔን ዎራን ዶሌዳዋ ማና። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ኔን ቢታዉ ስማና ጋካናዉ፥ ዳቡራን ነ ሶምእ ጫዋትና ኦꬄዳ ነ ቁማ ማና፤ አያዉ ጎፐ፥ ኔን ቢታፐ አከታዳ፤ ኔን ባና፤ ኔን ባናዉ ስማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","አዳመ ባረ ማቻቶ ሄዋኖ ጊደ ሱንꬄዳ፤ አያዉ ጎፐ፥ እዛ ደኡዋን ደእያ አሳ ኡባዉ አቶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","መꬍና ጎዳይ ጾሳይ አዳማዉነ አ ማቻትዉ ጫላ ጊግሲደ ኡንቱንታ ማይዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ሄዋፐ ጉየ መꬍና ጎዳይ ጾሳይ፥ “ስም አሳይ ኑፐ እቱዋዳን ሎኡዋነ ኢታ ኤርያዋ ግዴዳ። እ ባረ ኩሽያ የዲደ፥ ደኡዋ ምꬃፐ አኪደ፥ ቃይ ሜና ማላነ መꬍናዉ ደኡዋን ደኤና ማላ ተኤታናዉ ኮሼ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ሄዋ ድራዉ፥ እ ባረ አከቴዳ ቢታ ኦꬃና ማላ፥ መꬍና ጎዳይ ጾሳይ ኤደነ ገነትያፐ አ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","አ ከስ ድጊደ፥ ደኡዋ ምꬃኮ አፍያ ኦግያ ናጋና ማላ፥ ክሩቤላ ግያ ኪታንቻቱዋነ አꬍ አꬍ ዎꬍያ ታማ ላጩዋ ማሻ ኤደነ ገነትያፐ አዋይ ዶልያ ባጋና ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","አዳም ባረ ማቻት ሄዋንና አቄዳ፤ እዛ ሻሃሮ ዎደ አቱማ ናኣ የላዱ፤ “መꬍና ጎዳይ ታና ማድና፥ አቱማ ናኣ ደማድ” ጋደ አ ቃዬላ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ቃይ አ እሻ አቤላ የላዱ። አቤል ዶርሳ ሄሜ፤ ቃይ ቃዬል ቢታ ጎሼ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ኡንደና ዎድያፐ ጉየ፥ ቃዬል ባረ ጋደን ዶልያ ካꬃፐ መꬍና ጎዳዉ ያርሹዋ ያርሼዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ሽን አቤል ባረ ዶርሳ ዉድያ ግዶን ባይራ የለቴዳ ማራቱዋፐ አክ ሹኪደ፥ ኡንቱንቱ አሹዋፐ ሞꬍያዋ ያርሼዳ። መꬍና ጎዳይ አቤላነ አ ያርሹዋ አኬዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ሽን ቃዬላነ አ ያርሹዋ አክቤና። ሄዋ ድራዉ፥ ቃዬል ሎይꬅ ይሎቴዳ፤ ባረ ዴሙዋካ ꬉምሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ያትና መꬍና ጎዳይ ቃዬላ፥ “አያዉ ይሎታይ? ነ ዴሙካ አያዉ ꬉሜዴ? ");
INSERT INTO dwrENT_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ኔን ሎኦባ ኦꬆዋ ግድንቶ፥ ነ ሶምእ ፓሽከኔ? ሽን ኔን ሎኦባ ኦꬃና ꬋዮፐ፥ ናጋራይ ዶኣዳን ነ ፐንግያን ሙጌ፤ እ ኔና ሞዳና ኮዬ፤ ሽን ኔን አ ጾናና በሴ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ሄዋፐ ጉየ፥ ቃዬል ባረ እሻ አቤላ፥ “አነ ደምባ ቦይተ” ያጌዳ። ኡንቱንቱ ደምባን ደእሽን፥ ቃዬል ባረ እሻ አቤላ ቦላ ደንዲደ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","መꬍና ጎዳይ ቃዬላ፥ “ነ እሻይ አቤል ሀቃኔ?” ያጊደ ኦቼዳ። ቃዬል ዛሪደ፥ “ታን ኤርከ፤ ታ እሻ ናግያዌ ታኔየ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","መꬍና ጎዳይ ቃዬላ፥ “ሀዋ አያዉ ኦꬃድ? በአ፤ ነ እሻ ሱꬃይ ቢታፐ ታኮ ዋሴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ነ ኩሽያፐ ነ እሻ ሱꬃ አኪደ፥ ምታናዉ ሀንጌዳ ቢታፐ ሀእ ኔን ሸቀቴዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ኔን ጎሽናካ ቢታይ ነዉ አይፈና፤ በትያዳን ኔን ሳኣ ቦላን ቶይላካታናሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ቃዬል መꬍና ጎዳ፥ “ፖራ! ኔን ታና ሙርያ ሙራይ ታን ኡባካ ዳንዳየናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ሄኮ ኔን ታና ሀቼ ሀ ቢታፐ የደርሳሳ፤ ታን ነ ስንꬃፐ ቆሰታና፤ በትያዳን ታን ሳኣ ቦላን ቶይላካታና፤ ታና ደሞዌ ኦንነ ዎꬋና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","መꬍና ጎዳይ አ፥ “ኔና ኦንነ ዎና፤ ዎꬎፐ፥ ነ ሀሉዋ አን ላፑን ኩሽያ ከሳና” ያጌዳ። ሄዋ ድራዉ፥ ደሞዌ ኦንነ አ ዎናዳን መꬍና ጎዳይ አ ቦላ ማላታ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ቃዬል መꬍና ጎዳ ስንꬃፐ ከሲደ፥ ኤደነ ባጋፐ አዋይ ዶልያ ባጋና ደእያ ኖዳ ቢታን ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ቃዬል ባረ ማቻትና አቄዳ፤ እዛ ሻሃሮ ዎደ ሄኖካ የላዱ። ቃዬል ካታማ ሄ ዎደ ኬጺደ፥ ሄ ካታማ ባረ ናኣ ሱንꬃን “ሄኖካ” ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ሄኖክ እራዳ የሌዳ፤ እራድ ማሁያኤላ የሌዳ፤ ማሁያኤል ማቱሻኤላ የሌዳ፤ ማቱሻኤል ላሜካ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ላሜክ አዶነ ጺሎ ግያ ላኡ ማቻቱዋ ዳዉꬃ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","አዳ ያባላ የላዱ፤ ያባል መህያ ሞድያ፥ ዱንካንያን ደእያ አሳቱዋ አዉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","አ እሻ ሱንꬃይ ዩባላ፤ ዩባል ቃይ ዲꬃ ዲጽያነ ኡልዱድያ ፑንያ አሳቱዋ ኡባ አዉዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ጺላ ቃይ ቱባልቃይና ግያ ናኣ የላዱ፤ ቱባልቃይን ናሃስያፐነ ብራታፐ ዱማ ዱማ ሚሻቱዋ ቆጽያዋ። ቱባልቃይና ምቻታ ናእሞ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","እት ጋላስ ላሜክ ባረ ማቼቱዋ፥ “አዴ፥ ጺሌ፥ ስስተ፤ ታ ማቻቶ፥ አነ ታን ኦድያዋ ሀይዝተ። እት ብታኒ ታና ደቼዳ ድራዉ፥ ታን አ ዎꬋድ፤ ኤ፥ ታን ሄ ታና ማሱንꬄዳ ዎዳላ ዎꬋድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ቃዬላ ሀሉዋ ከሳናዉ ላፑን ኩሺ ኮሾፐ፥ ላሜካ ሀሉዋ ከሳናዉ ላፑን ታማነ ላፑን ኩሺ ኮሼ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","አዳመ ባረ ማቻትና ግስና ሀራ ናኣ የላደ፥ “ቃዬል ዎꬌዳ አቤላ ድራዉ ጾሳይ ታዉ ሀራ ናኣ እሜዳ” ጋደ፥ አ ሴታ ጋደ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ሴትካ አቱማ ናኣ የሌዳ፤ አ “ሄኖሳ” ጊደ ሱንꬄዳ። አሳይ መꬍና ጎዳ ሱንꬃ ጼሲደ ጎይንያዋ ሄ ዎደ ዶሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","አዳማ የለታይ ሀዋፐ ካሊደ ጻፈቴዳ። ጾሳይ አሳ መꬌዳ ጋላስ ባረና ማላትሲደ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","እ አቱማ አሳነ ማጫ አሳ ኦꬅ መꬊደ፥ ኡንቱንታ አንጄዳ። ኡንቱንታ መꬊደ አሳ ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","አዳም 130 ላይꬃ ደኢደ፥ ባረና ማላትያ አቱማ ናኣ የሌዳ፤ አ “ሴታ” ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","አዳም ሴታ የሌዳዋፐ ጉየ፥ 800 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናነ ማጫ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","አዳም ሙለ 930 ላይꬃ ደኢደ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ሴት 105 ላይꬃ ደኢደ፥ ሄኖሳ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ሴት ሄኖሳ የሌዳዋፐ ጉየ፥ 807 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናነ ማጫ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ሴት ሙለ 912 ላይꬃ ደኢደ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ሄኖስ 90 ላይꬃ ደኢደ፥ ቃይናና የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ሄኖስ ቃይናና የሌዳዋፐ ጉየ፥ 815 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናነ ማጫ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ሄኖስ ሙለ 905 ላይꬃ ደኢደ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ቃይናን 70 ላይꬃ ደኢደ፥ ማላልኤላ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ቃይናን ማላልኤላ የሌዳዋፐ ጉየ፥ 840 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናነ ማጫ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ቃይናን ሙለ 910 ላይꬃ ደኢደ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ማላልኤል 65 ላይꬃ ደኢደ፥ ያሬዳ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ማላልኤል ያሬዳ የሌዳዋፐ ጉየ፥ 830 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናነ ማጫ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ማላልኤል ሙለ 895 ላይꬃ ደኢደ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ያሬድ 162 ላይꬃ ደኢደ፥ ሄኖካ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ያሬድ ሄኖካ የሌዳዋፐ ጉየ፥ 800 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናነ ማጫ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ያሬድ ሙለ 962 ላይꬃ ደኢደ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ሄኖክ 65 ላይꬃ ደኢደ፥ ማቱሳላ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ማቱሳላ የሌዳዋፐ ጉየ፥ ሄኖክ 300 ላይꬃ ጾሳና ሀመቲደ ደኤዳ፤ ሀራ አቱማ ናናነ ማጫ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ሄኖክ ሙለ 365 ላይꬃ ደኤዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","እ ጾሳና ሀመቲደ ꬋዬዳ፤ አያዉ ጎፐ፥ ጾሳይ አ አፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ማቱሳል 187 ላይꬃ ደኢደ፥ ላሜካ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ማቱሳል ላሜካ የሌዳዋፐ ጉየ፥ 782 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናነ ማጫ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ማቱሳል ሙለ 969 ላይꬃ ደኢደ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ላሜክ 182 ላይꬃ ደኢደ፥ አቱማ ናኣ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","“ሀ ናአይ መꬍና ጎዳይ ሸቄዳ ቢታ ቦላን ኑና ኑ ኩሽያ ኦሱዋ ዳቡራፐ ሸምፕሳና” ጊደ ኖሀ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ላሜክ ኖሀ የሌዳዋፐ ጉየ፥ 595 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናነ ማጫ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ላሜክ ሙለ 777 ላይꬃ ደኢደ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ኖሄ 500 ላይꬃ ደኢደ፥ ሴማ፥ ካማነ ያፌታ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","አሳይ ሳኣ ቦላን ዳሬዳ ዎደ፥ ኡንቱንቶ ማጫ ናናይ የለቴድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","“ሳሉዋ መታቱዋ” ጌተትያዋንቱ ሀ አሳ ማጫ ናናይ ማላ ሎአ ግድያዋ በኤድኖ፤ ያቲደ ኡንቱንቱፐ ባረንቶ ዶሬዳዋንታ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","መꬍና ጎዳይ፥ “ታ አያናይ አሳን መꬍናዉ ደኤና፤ አያዉ ጎፐ፥ አሳይ ሀይቂያዋ፤ አ ላይꬃቱካ እት ጼታነ ላታማ ግዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ሄ ዎደነ ሄዋፐ ጉየ ሳሉዋ መታቱ አሳ ማጫ ናና አክና፥ ናናይ የለቴዳ ዎደ፥ ዎጋ አዱሳ አሳቱ ሳኣ ቦላን ደኤድኖ። ኡንቱንቱነ በን ዎደ ኦላዉ ምናነ ኤረቴዳ አሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","መꬍና ጎዳይ ሄ ዎደ ሳኣ ቦላን ደእያ አሳ ኢታተꬃይ ዳሬዳዋነ ኡንቱንቱ ዎዛናይ ቆፕያባይ ኡባይ ኡባ ዎደካ ኢታ ጻላላ ግዴዳዋ በኤዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","መꬍና ጎዳይ አሳ ሀ ሳኣ ቦላን መꬌዳዎ ካዮቴዳ፤ ባረ ዎዛናን ሎይꬅ ሴለቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ሄዋ ድራዉ መꬍና ጎዳይ፥ “ታን መꬌዳ አሳ ሀ ሳኣ ቦላፐ ሙለ ꬋይሳና፤ አሳ፥ መህያ፥ ዶኣ፥ ቢታና ጎሸትያ መታቱዋነ ሳሉዋ ካፎቱዋ ꬋይሳና፤ አያዉ ጎፐ፥ ታን ኡንቱንታ መꬌዳዎ ካዮታድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ሽን ኖሄ መꬍና ጎዳ ስንꬃን ናሸቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ኖሄ ሀኔዳባይ ሀዋፐ ካሊደ ጻፈቴዳ። ኖሄ ጽሎ አሳ፤ እ ባረ ዎድያን ደኤዳ አሳ ግዶን ሱረ አሳ፤ ኖሄ ጾሳና ሀመቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ኖሄ ሴማ፥ ካማነ ያፌታ ግያ ሄዙ አቱማ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ሄ ዎደ ቢታይ ሳአይ ጾሳ ስንꬃን ቱኔዳ፤ ሳአይ ኡባይ ማካላን ኩሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ጾሳይ ሀ ሳኣ ጼሌዳ፤ ሳአይ ቱኔዳዋ በኤዳ፤ አያዉ ጎፐ፥ ሳኣን ደእያ አሳይ ኡባይ ባረ ኦግያ ቱንስ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ሄዋ ድራዉ፥ ጾሳይ ኖሀ ሀዋዳን ያጊደ አዛዜዳ፤ “ታን አሳ ኡባ ꬋይሳና ሀናይ፤ ኡንቱንቱ ጋሱዋን ሳአይ ማካላን ኩሜዳ ድራዉ፥ ታን ቱሙፐ አሳካ ሳኣካ ꬋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ሄዋ ድራዉ፥ ምኖ ምꬃፐ ነዉ ማርካብያ ኬጻ፤ ሄ ማርካብያ ግዶን ጮራ ቆልኦቱዋ ከሳ፤ ያታደ ሶናነ ካረና ሽድያን ባራ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ማርካብያ ሀዋዳን ያታደ ኬጻ፤ አዱሳተꬃ ሄዙ ጼቱ ዋꬋ፥ ጎምፓ እሻታሙ ዋꬋ፥ ጌሳ ሀታሙ ዋꬋ ኦꬃ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ማርካብያዉ ካራ መꬋ፤ ካራፐነ ጎዳፐ ግዱዋን እት ዋꬋ ግድያ ሳ ካሎ አጋ ባሻ፤ ፐንግያ ማርካብያዉ ምይያና ከሳ፤ ማርካብያ ሄዙ ፖቅያ ከሳደ ኬጻ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“ታን ሳሉዋፐ ጋርሳን ደኡዋ ሸምፑዋና ደእያ መታ ኡባ ꬋይሳናዉ፥ ሀ ሳኣ ቦላን ባሻ ሃꬃ የዳና፤ ሀ ሳኣን ደእያባይ ኡባይ ꬋያና። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ሽን ታን ታ ቃላ ጫቁዋ ኔናና ጫቀታና። ኔን ነ ማቻቶ፥ ነ አቱማ ናናነ ነ አቱማ ናና ማቻቱዋ ኔናና አካደ ማርካብያ ግዶ ገላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ኡንቱንቱ ኔናና ሸምፑዋና አታና ማላ፥ ሸምፑ ደእያ መታ ኡባፐ ቆሙዋን ቆሙዋን አቱማዋነ ማጫዋ ላኡዋ ላኡዋ አካደ፥ ማርካብያ ግዶ ገልሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ዱማ ዱማ ቆሞ ካፉዋፐ፥ ዱማ ዱማ ቆሞ መህያፐነ ቢታና ጎሸትያ ዱማ ዱማ ቆሞ መታቱዋ ኡባፐ ላኡዋ ላኡዋ ግዲደ፥ ሸምፑዋና አታና ማላ ኔኮ ያና። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ቃይ ኔንነ ኔናና ደእያዋንቱ ማናዉ፥ ዱማ ዱማ ቆሙ ምያ ካꬃ አፋደ፥ ማርካብያ ግዶን ቆላ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ኖሄ ኡባባካ ጾሳይ አዛዜዳዋዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","መꬍና ጎዳይ ሄዋፐ ጉየ ኖሀ ሀዋዳን ያጌዳ፤ “ኔን ነ ሶ አሳ ኡባና ማርካብያ ግዶ ገላ፤ አያዉ ጎፐ፥ ታን ሀ ዎድያ የለታ ግዶን ኔን ጽሎ ግዴዳዋ በኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","ኔን ጌሻ ግዴዳ መህያነ ዶኣ ኡባፐ አ ቆሙዋፐ ቆሙዋፐ አቱማዋነ ማጫዋ ላፑኑዋ ላፑኑዋ፥ ጌሻ ግደና መህያነ ዶኣ ኡባፐ አ ቆሙዋፐ ቆሙዋፐ እት አቱማዋነ እት ማጫዋ፥ ቃይ ሳሉዋ ካፉዋፐ አ ቆሙዋፐ ቆሙዋፐ አቱማዋነ ማጫዋ ላፑኑዋ ላፑኑዋ ኦꬃደ፥ ሳኣ ኡባ ቦላን ዱማ ዱማ ዘረꬃይ ሸምፑዋና አታና ማላ ኔናና አካደ ገላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","አያዉ ጎፐ፥ ላፑን ጋላሳፐ ጉየ፥ ታን ኦይታሙ ጋላሳነ ኦይታሙ ቃማ ሀ ሳኣ ቦላን እራ ቡክሳና፤ ያታደ ታን መꬌዳ መታ ኡባ ሳኣ ቦላፐ ꬋይሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ኖሄ መꬍና ጎዳይ አ አዛዜዳ ኡባባ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ባሻ ሃꬃይ ሀ ሳኣ ቦላ ዬዳ ዎደ፥ ኖሄ ላይꬃይ ኡሱፑን ጼታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ኖሄ፥ አ አቱማ ናናይ፥ አ ማቻታነ አ ናና ማቼቱ ባሻ ሃꬃፐ አታናዉ ማርካብያ ግዶ ገሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ጌሻ መህያፐነ ዶኣፐ፥ ጌሻ ግደና መህያፐነ ዶኣፐ፥ ካፉዋፐነ ቢታና ጎሸትያዋንቱ ኡባፐ ");
INSERT INTO dwrENT_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ጾሳይ ኖሀ አዛዜዳዋዳንካ አቱማዌነ ማጫዌ ላኡዋ ላኡዋ ግድ፥ ኖሄኮ ዪደ ማርካብያ ግዶ ገሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ላፑን ጋላሳፐ ጉየ፥ ባሻ ሃꬃይ ሀ ሳኣ ቦላን ዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ኖሄ ኡሱፑን ጼቱ ላይꬃ ደእና፥ ላኤንꬃ አግናን፥ ታማነ ላፑንꬃ ጋላሳን፥ ሄ ጋላሳን ቢታ ግዶን ደእያ ዎልቃማ ጪማ ፑልቱዋ ኡባይ ꬉቂ አጌዳ፤ ሳሉዋን ደእያ ሃꬃ ፐንገቱካ ዶየት ዎꬌድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","እራይ ሀ ሳኣ ቦላን ኦይታሙ ጋላሳነ ኦይታሙ ቃማ ቡኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ሄ ጋላሳን ኖሄነ አ አቱማ ናናይ፥ ሴመ፥ ካመነ ያፌት፥ ኖሄ ማቻታነ አ ናና ሄዛቱዋ ማቻቱ እትፐ ማርካብያ ግዶ ገሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ኡንቱንቱነ ዶኣ ኡባፐ ባረ ቆሙዋን ቆሙዋን፥ መህያ ኡባፐ ባረ ቆሙዋን ቆሙዋን፥ ሳኣና ጎሸትያዋንቱ ኡባፐ ባረ ቆሙዋን ቆሙዋን፥ ካፉዋ ኡባፐ ባረ ቆሙዋን ቆሙዋን፥ ኡንቱንቱና እትፐ ገሌድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ደኡዋ ሸምፑዋና ደእያዋንቱ ኡባይ ላኡዋ ላኡዋ ግድ፥ ኖሄኮ ዪደ ማርካብያን ገሌድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ጾሳይ ኖሀ አዛዜዳዋዳን፥ መታ ኡባፐ አቱማዋነ ማጫዋ ግዲደ፥ ማርካብያ ግዶ ገል ስሞዋን፥ መꬍና ጎዳይ ማርካብያ ፐንግያ ጎርዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ባሻ ሃꬃይ ኦይታሙ ጋላሳ ሳኣ ቦላን ቡኪደ ጋምኤዳ፤ ሃꬃይ ዳሪደ፥ ማርካብያ ቢታፐ ፑደ ደንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ሃꬃይ ቢታ ቦላን ሎይꬅ ዳርና፥ ማርካቢ ሃꬃ ቦላን ቶከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ሳሉዋፐ ጋርሳና ደእያ ꬎቃ ደረቱ ኡባይ ምተታና ጋካናዉ፥ ሃꬃይ ሀ ሳኣ ቦላን ሎይꬅ ዎልቃፐ ዳሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ሃꬃይ ደረቱዋ ጼራፐ አꬊደ፥ ታማነ እቼሹ ዋꬋ ጋካናዉ ቶኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ያትና ሳኣ ቦላን ሸምፑዋና ቃጽያ መታቱ ኡባይ: ካፉ፥ መሂ፥ ዶአይ፥ ሳኣ ቦላን ሻምእ ግያ መታ ኡባይነ አሳይ ኡባይ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ኤ፥ መላ ቢታ ቦላን ደእያ፥ ባረ ሲꬍያን ደኡዋ ሸምፑዋ ሸምፕያ ኡባይካ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ሀ ሳኣን ፓጻ ደእያባይ ኡባይ: አሳይ፥ መሂነ ዶአይ፥ ቢታና ጎሸትያ መታቱነ ሳሉዋ ካፎቱ ኡባይካ ሳኣፐ ꬋዬድኖ። ኖሄ ጻላላይነ አናና ማርካብያ ግዶን ደእያዋንቱ አቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ሄ ሃꬃይ ጼታነ እሻታሙ ጋላሳ ጋካናዉ ሳኣ ቦላን ጋምኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ሽን ጾሳይ ኖሀ፥ አናና ማርካብያ ግዶን ደእያ ዶኣ ኡባነ መህያ ኡባ ቆፔዳ፤ ሳኣ ቦላን ጫርኩዋ ጫርክሴዳ፤ ሄ ሃꬃይ ዎꬍ ዎꬍ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ቃይ ቢታ ግዱዋን ደእያ ጪሙዋ ፑልቱነ ሳሉዋን ደእያ ሃꬃ ፐንገቱ ጎርደቴድኖ፤ እራይካ ሳሉዋን ኤቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ያትና ሃꬃይ ዎꬍ ዎꬍ ቤዳ። ሄ ጼታነ እሻታሙንꬃ ጋላሳፐ ጉየ፥ ሃꬃይ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ሃꬃይ ዎꬍና ማርካቢ ላፑንꬃ አግናን፥ ታማነ ላፑንꬃ ጋላሳን አራራተ ግያ ደረቱዋ ቦላ ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ሃꬃይ ታማንꬃ አግናይ ጋካናዉ ዎꬍ ዎꬍ ቤዳ፤ ታማንꬃ አግናዉ ኮይሮ ጋላስ ደረቱ ጼራይ ቤቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ኦይታሙ ጋላሳፐ ጉየ፥ ኖሄ ባረ ኬጼዳ ማርካብያ ማስኮትያ ዶዬዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ያቲደ እት ቁሩዋ ካረ የድና፤ ቁሩ ሃꬃይ ቢታ ቦላፐ መላና ጋካናዉ፥ ያነ ሃነ ፓሊደ ጋምኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ቃይ ኖሄ ሃꬃይ ቢታ ቦላፐ ዎꬍ ዉሬደንቶነ በአናዉ እት ሀራጳቶ ካረ የዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ሽን ሄ ሀራጳታ ሃꬃይ ቢታ ኡባ ቦላን ሀእካ ደእያ ድራዉ፥ ሸምፕያ ሳኣ ደማበይኩ። ሄዋ ድራዉ ስማደ፥ ማርካብያ ግዶን ደእያ ኖሄኮ ያዱ፤ እ ባረ ኩሽያ የዲደ፥ ባረኮ ማርካብያ ግዶ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ሄዋፐ ጉየ፥ ሀራ ላፑን ጋላሳ ጋምኢደ፥ ዶጎማቶ ዛሪደካ ማርካብያ ግዶፐ ከሲደ የዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ሄ ሀራጳታ ሳአይ ኦማርስያ ዎደ አኮ ስማደ ያዱ፤ ዎጋራ ማላትያ ምꬃፐ ዱꬄዳ እርጻ ሀይꬃ ባረ ዶናን ሳአ አካደ ያዱ። ሄዋ ድራዉ፥ ሃꬃይ ቢታ ቦላፐ ዎꬌዳዋ ኖሄ ኤሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ቃይ ኖሄ ሀራ ላፑን ጋላሳ ጋምኢደ፥ ሄ ሀራጳቶ ዛረꬂደ የዴዳ፤ ሽን ሄ ሀራጳታ አኮ ስማደ ያበይኩ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ኖሄ ኡሱፑን ጼታነ እት ላይꬃ ደእና፥ ኮይሮ አግናን ኮይሮ ጋላስ፥ ሃꬃይ ቢታ ቦላፐ ጽኤዳ፤ ኖሄ ማርካብያ ቁምእያ ዶይ ጼሊደ፥ ቢታይ ጽኤዳዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ላኤንꬆ አግናን ላታማነ ላፑንꬃ ጋላሳን፥ ቢታይ ሙለ መሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ጾሳይ ሄ ዎደ ኖሀ ሀዋዳን ያጊደ አዛዜዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ኔን ነ ማቻቶ፥ ነ አቱማ ናናነ ነ ናና ማቻቱዋ አካደ ማርካብያ ግዶፐ ከሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ኡንቱንቱ የለቲደ፥ ዳሪደ ጮራና ማላ፥ ሸምፑ ደእያ መታ ኡባፐ ኔናና ደእያዋንታ: ካፎቱዋ፥ መሄቱዋ፥ ዶአቱዋነ ቢታና ጎሸትያ ኡባ ኔናና ከሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ኖሄ ባረ አቱማ ናናቱዋናኔ፥ ባረ ማቻትናነ ባረ ናና ማቼቱዋና ማርካብያ ግዶፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","መህያነ ዶኣ ኡባይ፥ ቢታና ጎሸትያ መታ ኡባይ፥ ካፉዋ ኡባይነ ሳኣ ቦላን ዎጽ ቃጽያባ ኡባይ ባረ ቆሙዋን ቆሙዋን ማርካብያ ግዶፐ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ኖሄ መꬍና ጎዳዉ ያርሽያ ሳኣ ግምቤዳ፤ ጌሻ መህያነ ዶኣ ኡባፐነ ጌሻ ካፉዋ ኡባፐ አኪደ፥ ያርሽያ ሳኣን ጹጊደ ያርሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ያትና መꬍና ጎዳይ ያርሹዋ ፔኑዋ ሳዊያዋ ስንጊደ፥ ባረ ዎዛናን ሀዋዳን ያጌዳ፤ “ናአተꬃፐ ዶምና፥ አሳይ ዎዛናን ቆፕያባይ ኡባይ ኢታ ግዶፐነ፥ ታን አሳ ድራዉ ጋደ ላኤንꬆ ኡባካ ሀ ሳኣ ሸቂከ። ቃይ ታን ሀእ ኦꬄዳዋዳን ፓጻ ደእያ መታ ኡባ ላኤንꬆ ኡባካ ꬋይስከ። ");
INSERT INTO dwrENT_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ሀ ሳአይ ደኤዳ ኬሻ ኡባን፥ ዘርያ ዎዲነ ጫክያ ዎዲ፥ ሜጉነ ሆምቢ፥ ቦኒነ ባልጉ፥ ጋላሳይነ ቃማይ ኡባደካ ደአና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ጾሳይ ኖሀነ አ አቱማ ናና ሀዋዳን ያጊደ አንጄዳ፤ “የለትተ፤ ጮርተ፤ ሳኣ ኡባ ኩምተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ሳኣ ዶአቱ ኡባይ፥ ሳሉዋ ካፋቱ ኡባይ፥ ጋድያን ዎጽ ቃጽያባ ኡባይነ አባን ደእያ ሞለቱ ኡባይ ህንተንቶ ያይኖነ ዳጋምኖ። ኡንቱንቱ ህንተንቶ አꬊደ እመቴድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ታን ሞክያ ዱማ ዱማ ካꬃቱዋ ህንተንቶ እሜዳዋዳንካ፥ ሸምፑ ደእያ ዎጽ ቃጽያ መታ ኡባይ ህንተንቶ ቁማ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ሽን ሱꬃ ግዶን ሸምፑ ደእያ ድራዉ ሱꬃይ አ ግዱዋን ደእያ አሹዋ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ታን ህንተንቱ ሸምፑዋና ደእያ ህንተንቱ ሱꬃ ዶኣ ኡባፐ ቱሙ አቻና፤ ቃይ አሳ ኡባፐ፥ አ ማላ አሳ ሱꬃ አቻና። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ጾሳይ አሳ ባረና ማላትሲደ መꬌዳ ድራዉ፥ አሳ ሱꬃ ጉስያ ኦናነ ግዶፐነ፥ አ ሱꬃይካ አሳ ኩሽያን ጉካናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ህንተንቱ የለትተ፤ ጮርተ፤ ሳኣን ዳርተ፤ አን ጮርተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ሄዋፐ ጉየ፥ ጾሳይ ኖሀነ አናና ደእያ አ አቱማ ናና፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","“ስም ሀእ፥ ታን ታ ጫቁዋ ህንተናና፥ ህንተፐ ጉየ ህንተንቱ ዘረꬃናነ ፓጻ ኔናና ደእያ መታ ኡባና ጫቀታይ፤ ኤ፥ ታን ታ ጫቁዋ ካፉዋና፥ መህያና፥ ሳኣ ዶኣ ኡባናነ፥ ማርካብያፐ ህንተናና ከሴዳ፥ ሸምፑዋና ደእያ መታ ኡባና ጫቃይ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ታን ህንተናና ታ ጫቁዋ ጫቀታይ፤ ሀዋፐ ስንꬃን ሸምፑ ደእያባይ ኡባይ ባሻ ሃꬃን ኡባካ ባየና፤ ሀ ሳኣ ባይዝያ ሃꬃይ ሀዋፐ ስንꬃን ኡባካ ደኤና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ቃይካ ጾሳይ፥ “ታን ታፐነ ህንተፐ፥ ህንተናና ደእያ ፓጻ መታቱዋ ኡባፐ ግዱዋን ያና የለታ ኡባና ጫቀትያ ጫቁዋ ማላታይ ሀዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ታን ታ ዙሉዋ ሻርያን ኤሳድ፤ እ ታፐነ ሀ ሳኣፐ ግዱዋን ደእያ ጫቆ ማላ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ታን ሳኣፐ ቦላን ሻርያ አሄዳ ዎደነ ሻርያን ዙሉ ቤቴዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ታፐነ ህንተፐ ሸምፑ ደእያ ዱማ ዱማ ቆሞ መታ ኡባፐ ግዱዋን ጫቀቴዳ ታ ጫቁዋ ሀሳያና፤ ፓጻ ደእያዋ ኡባ ꬋይሳናዉ ሀዋፐ ስንꬃን ኡባካ ባሻ ሃꬃይ ዬና። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ዙሉ ሻርያን ቤቴዳ ዎደ አዉደነ፥ ታን አ በአና፤ ታፐ ጾሳፐነ ሀ ሳኣ ቦላን ሸምፑዋና ደእያ ዱማ ዱማ ቆሞ መታ ኡባፐ ግዱዋን ጫቀቴዳ መꬍና ጫቁዋ ታን ሀሳያና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ጾሳይ ኖሀ፥ “ታን ታፐነ ሀ ሳኣ ቦላን ሸምፑዋና ደእያዋ ኡባፐ ግዱዋን ጫቀቴዳ ጫቁዋ ማላይ ሀዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ማርካብያፐ ከሴዳ ኖሄ አቱማ ናናይ ሴማ፥ ካማነ ያፌታ፤ ካመ ካናነ አዉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ሀዋንቱ ሄዙካ ኖሄ ናና፤ ሳኣን ኡባን ደእያ አሳይ ኡንቱንቱፐ የለቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ኖሄ ጎሻንቻ፤ እ ዎይንያ ቱራ ቶከꬃ ዶሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","እት ጋላስ እ ሄ ዎይንያ ኤሳ ኡሺደ ማꬆቴዳ፤ ባረ ዱንካንያ ግዶን ካሎ ጺራ ግሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ካናነ አዉዋ ካመ ባረ አዉዋ ካሉዋ በኤዳ፤ ካረ ከሲደ፥ ባረ ላኡ እሻቶ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ሽን ሴምነ ያፌት አፍላ እቱዋ አኪደ፥ ላአቱካ ባረንቱ ሀሽያና ሀሽያና ጋꬅ ኦይቂደ፥ ጉየጉꬃን ሀመት ገሊደ፥ ባረንቱ አዉዋ ካሉዋ ካሜድኖ፤ ኡንቱንቱ ባረንቱ አዉዋ ካሉዋ በኤና ማላ ባረንቱ ዴሙዋ ዎራ ዛሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ኖሄ ማꬁ አꬍና ቤጎቲደ፥ አ ናአይ ኡባፐ ቴፋይ አ ኦꬄዳዋ ኤሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","አ፥ “ካናነ ሸቀቴዳዋ ግዶ! እ ባረ እሻቶ ዉርሰꬃ አይልያ ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ቃይካ ኖሄ፥ “መꬍና ጎዳይ፥ ሴማ ጾሳይ ጋላተቶ! ካናነ ሴማ አይልያ ግዶ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ጾሳይ ያፌታ ቢታ አሶ። ያፌታ ዛራቱ ሴማ ዛራቱዋ ግዶን ደእኖ፤ ካናነ ያፌታ አይልያ ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ባሻ ሃꬃፐ ጉየ፥ ኖሄ 350 ላይꬃ ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ኖሄ ሙለ 950 ላይꬃ ደኢደ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ኖሄ ናና፥ ሴማ፥ ካማነ ያፌታ የለታይ ሀዋፐ ካሊደ ጻፈቴዳዋ፤ ባሻ ሃꬃፐ ጉየ፥ ኡንቱንቶ አቱማ ናናይ የለቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ያፌታ አቱማ ናናይ: ጎመራ፥ ማጎጋ፥ ማዳያ፥ ያዋና፥ ቱባላ፥ መሸካነ ቲራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ጎመራ አቱማ ናናይ: አሽካናዛ፥ ሪፋታነ ቶጋርማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ያዋና አቱማ ናናይ: ኤሊሻ፥ ታርሴሰ፥ ክቲማነ ሮዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ሀዋንቱፐ አባ ዶናን ደእያ አሳይ ኡባይ ባረ ጋድያን ጋድያን፥ ባረ ቃላን ቃላን፥ ባረ ያራን ያራንነ፥ ባረ ካዉተꬃን ካዉተꬃን ሻከቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ካማ አቱማ ናናይ: ኩሻ፥ ምጽራይማ፥ ፑጻነ ካናና። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ኩሻ አቱማ ናናይ: ሳባ፥ ኤዉላጻ፥ ሳብታ፥ ራእማነ ሳብታካ። ራእማ አቱማ ናናይ: ሳባነ ዳዳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ኩሽ ናምሩዳ የሌዳ፤ ናምሩድ ሀ ሳኣን ኮይሮ ዎልቃማ ኦላንቻ ግዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","መꬍና ጎዳ ስንꬃንካ እ ዎልቃማ ሻንካንቻ ግዴዳ፤ “ናምሩዳዳን መꬍና ጎዳ ስንꬃን ዎልቃማ ሻንካንቻ ግዴዳ” ጉሳይ ሄዋ ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","አ ካዉተꬃይ ኮይሮ ካታማት ሳናኦረ ጋድያን ደእያ ባብሎነ፥ ኤሬካ፥ አካዳነ ካልና። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","እ ሄ ቢታፐ አሶረ ቢደ፥ ነነዌ፥ ሮሆቦታነ ካላሀ ኬጼዳ፤ ቃይ ናናዌፐነ ካላሀፐ ግዱዋን ደእያ ረሴና ግያ ዎልቃማ ካታማካ ኬጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","ምጽራይመ ሉደቱዋ፥ አናማዋቱዋ፥ ላሃበቱዋ፥ ናፍቱሄቱዋ፥ ፓትሮሳቱዋ፥ ካስሉሄቱዋነ ፕልስጼማቱዋ ዘረꬃቱዋ የሌዳ ካፍቶረቱዋ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","18","ካናነ ባረ ባይራ ናኣ ሲዶናነ ሄታ የሌዳ፤ ቃይ ካናነ ያቡሳ አሳ፥ አሞረ አሳ፥ ገርጌሰ አሳ፥ ሂዌ አሳ፥ አርቀ አሳ፥ ሲና አሳ፥ አርዋደ አሳ፥ ጻማረ አሳነ ሀማታ አሳ የሌዳ። ሄዋፐ ጉየ፥ ካናነ ዛራቱ ላለትና፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ካናነ ቢታ ዛዋይ ሲዶናፐ ዶሚደ፥ ጌራራናነ ጋዛና አꬊደ፥ ሶዶማነ ጋሞራ፥ አዳማነ ጻቦይማ ቢደ፥ ላሻአን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ካመ አቱማ ናናይ ባረንቱ ያራን ያራን፥ ባረንቱ ቃላን ቃላን፥ ባረንቱ ቢታን ቢታንነ ባረንቱ ካዉተꬃን ካዉተꬃን ጻፈቴዳዋንቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ሴማዉ ናናይ የለቴድኖ፤ እ ያፌታዉ ባይራ እሻነ ኤቦራ ናና ኡባዉ ማይዛ አዉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ሴማ አቱማ ናናይ: ኤላማ፥ አሶራ፥ አርፋክሳዳ፥ ሉዳነ አራማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","አራማ አቱማ ናናይ: ኡጻ፥ ሁላ፥ ገቴራነ መሸካ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","አርፋክሳድ ሸላሀ የሌዳ። ሸላህ ኤቦራ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ኤቦራዉ ላኡ አቱማ ናናይ የለቴድኖ። እቱዋ ሱንꬃይ ፔሌጋ፤ አያዉ ጎፐ፥ ሳኣን ደእያ አሳይ አ ዎድያን ሻከቴዳ፤ አ እሻ ሱንꬃይ ዮቅጻና። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ዮቅጻን ናና የሌዳ። ኡንቱንቱነ: አልሞዳዳ፥ ሸሌፋ፥ ሀጻርማዌታ፥ የራሀ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ሀዶራማ፥ ኡዛላ፥ ዲቅላ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ኦባላ፥ አብማኤላ፥ ሳባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ኦፊራ፥ ሀዊላነ ዮባባ። ሀዋንቱ ኡባይካ ዮቅጻና አቱማ ናና። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ኡንቱንቱ ደኤዳ ሄራይ ሜሻፐ ቢደ አዋይ ዶልያ ባጋና ደእያ ደሪ ዳርያ ጋድያን ሳፋራ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ሴማ አቱማ ናናይ ባረንቱ ያራን ያራን፥ ባረንቱ ቃላን ቃላን፥ ባረንቱ ጋድያን ጋድያንነ ባረንቱ ካዉተꬃን ካዉተꬃን ጻፈቴዳዋንቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ሀዋንቱ ባረንቱ ያራን ያራንነ ባረንቱ ካዉተꬃን ካዉተꬃን ጻፈቴዳ ኖሄ አቱማ ናና ዛራቱዋ። ባሻ ሃꬃፐ ስሚደ፥ ካዉተꬃቱዋ ሀዋንቱፐ ሳኣ ኡባዉ የለት አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ሳኣ ቦላን ደእያ አሳይ ኡባይ ኮይሮ እት ዶናነ እት ቃላ ሃሳዪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","አሳቱ አዋይ ከስያ ባጋ ስሚደ ቤዳ ዎደ፥ ሳናኦረ ግያ ጋድያን ደምባ እቱዋ ደሚደ ያን፥ ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ኡንቱንቱ እቱ እቱዋ፥ “ሃ ዪተ፤ ጹብያ መꬊደ፥ ታማን ጹጎይተ” ያጌድኖ። ኡንቱንቱ ሹቻ ድራዉ ጹብያ፥ ኡርቃ ድራዉ ሽድያ አኬድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","“ሃ ዪተ፤ ኑ ሱንꬃ ጼስሳናዉነ ቃይ ኑን ሀ ሳኣ ኡባ ቦላን ላለተናን አታናዉ እት ዎልቃማ ካታማነ ጼራይ ሳሉዋ ጋክያ እት ፖቅያ ኑዉ ኬጾይተ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ሽን ጎዳይ አሳቱ ኬጼዳ ዎልቃማ ካታማነ ፖቅያ በአናዉ ዱገ ዎꬌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","መꬍና ጎዳይ “ሄኮ ኡንቱንቱ እት አሳ፤ ቃይ ኡንቱንቱ ኡባይካ እት ቃላን ሃሳዪኖ፤ ኡንቱንቱ ሀእ ሀዋ ኦꬃናዉ ዶሞዋፐ ጉየ፥ ኡንቱንቱ ባረንቶ ኦꬃናዉ ቆፖዋ ኡንቱንቶ ዳንዳየተናዌ አያይነ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ሃ ዪተ፤ ዱገ ዎꬊደ ኡንቱንቱ እቱ ሃሳይያ ቃላ እቱ ኤረና ማላ፥ ኡንቱንቱ ቃላ ዱማዮይተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","መꬍና ጎዳይ ኡንቱንታ ሄዋፐ ሳኣ ኡባ ቦላን ላልና፥ ኡንቱንቱ ሄ ዎልቃማ ካታማ ኬጽያዋ አጊሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","መꬍና ጎዳይ ሳኣ አሳ ቃላ ያን ዱማዬዳ ድራዉ፥ ሄ ካታማይ ባቤላ ጌተቴዳ። ጎዳይ ኡንቱንታ ሄዋፐ ሳኣ ኡባ ቦላን ላሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ሴማ የለታይ ሀዋፐ ካሊደ ጻፈቴዳዋ። ባሻ ሃꬃፐ ጉየ፥ ላኡ ላይꬃ ግድና፥ ሴማ ላይꬃይ 100 ግዴዳ ዎደ፥ ሴም አርፋክሳዳ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ሴም አርፋክሳዳ የሌዳዋፐ ጉየ፥ 500 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናካ ማጫ ናናካ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","አርፋክሳድ 35 ላይꬃ ደኢደ፥ ሸላሀ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","አርፋክሳድ ሸላሀ የሌዳዋፐ ጉየ፥ 403 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናካ ማጫ ናናካ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ሸላህ 30 ላይꬃ ደኢደ፥ ኤቦራ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ሸላህ ኤቦራ የሌዳዋፐ ጉየ፥ 403 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናካ ማጫ ናናካ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ኤቦር 34 ላይꬃ ደኢደ፥ ፔሌጋ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ኤቦር ፔሌጋ የሌዳዋፐ ጉየ፥ 430 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናካ ማጫ ናናካ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ፔሌግ 30 ላይꬃ ደኢደ፥ ራአ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ፔሌግ ራአ የሌዳዋፐ ጉየ፥ 209 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናካ ማጫ ናናካ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ራኡ 32 ላይꬃ ደኢደ፥ ሳሩጋ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ራኡ ሳሩጋ የሌዳዋፐ ጉየ፥ 207 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናካ ማጫ ናናካ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ሳሩግ 30 ላይꬃ ደኢደ፥ ናኮራ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ሳሩግ ናኮራ የሌዳዋፐ ጉየ፥ 200 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናካ ማጫ ናናካ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ናኮር 29 ላይꬃ ደኢደ፥ ታራ የሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ናኮር ታራ የሌዳዋፐ ጉየ፥ 119 ላይꬃ ደኤዳ፤ ሀራ አቱማ ናናካ ማጫ ናናካ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ታር 70 ላይꬃ ደኢደ፥ አብራማ፥ ናኮራነ ሃራና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ታራ የለታይ ሀዋፐ ካሊደ ጻፈቴዳዋ። ታር አብራማ፥ ናኮራነ ሃራና የሌዳ፤ ሃራን ሎጻ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ሃራን ባረ አዉ ታር ፓጻ ደእሽን፥ ባረ የለቴዳ ካላዳዌቱዋ ጋድያን፥ ኡራ ግያ ዎልቃማ ካታማን ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","አብራምነ ናኮርነ ላአቱካ አኬድኖ፤ አብራሞ ማቻት ሱንꬃይ ሳሮ፤ ቃይ ናኮራ ማቻት ሱንꬃይ ምልኮ፤ ምልካ ሃራና ናቶ፤ ሃራን ምልክዉነ ይስካንዉ አዉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ሳራ ማንꬃቶ፤ እዝዉ ናእ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ታር ባረ ናኣ አብራማ፥ ባረ ናኣ ሃራና ናኣ ሎጻነ፥ ባረ ናኣ አብራሞ ማቻቶ ሳሮ አኪደ ከስና፥ ኡንቱንቱ እትፐ ካናነ ጋድያ ባናዉ ኡር ግያ ካላዳዌቱዋ ካታማፐ ደንዴድኖ፤ ሽን ኡንቱንቱ ካራነ ግያ ካታማ ጋካናዉ ቢደ፥ ያን ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ታር 205 ላይꬃ ደኢደ፥ ካራነን ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","መꬍና ጎዳይ አብራማ ያጌዳ፤ “ኔን ነ ጋድያፐ፥ ነ ዳቦቱዋፐነ ነ አዉዋ ጎለ አሳፐ ሻከታደ፥ ታን ኔና በስያ ጋድያ ባ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ታን ኔና ዎልቃማ ካዉተꬃ ኦꬃና፤ ቃይ ታን ኔና አንጃና፤ ታን ነ ሱንꬃ ግታያና፤ ያትና ኔን አንጆ ግዳና፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ታን ኔና አንጅያዋንታ አንጃና፤ ቃይ ኔና ሸቂያዋንታ ታን ሸቃና፤ ሀ ሳኣ ቦላን ደእያ አሳይ ኡባይ ነ ባጋና አንጀታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","አብራመ መꬍና ጎዳይ አዉ ኦዴዳዋዳን ደንዲደ ቤዳ፤ ሎጸካ አናና ቤዳ፤ አብራመ ካራነፐ ቤዳ ዎደ፥ አዉ ላይꬃይ ላፑን ታማነ እቼሻ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","አብራመ ባረ ማቻቶ ሳሮ፥ ባረ እሻ ናኣ ሎጻ፥ ያን ሺሼዳ ባረንቱ ማጹዋ ኡባነ፥ ካራነን ኡንቱንቱ ደሜዳ ቆማቱዋ አኪደ፥ ካናነ ጋድያ ባናዉ ደንዴዳ፤ ቢደ ኡንቱንቱ ካናነ ጋድያ ጋኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","አብራመ ሄ ጋድያን ሰኬማ ግያ ሳኣን ደእያ ሞረ ግያ ዎልቃማ ዎላ ጋካናዉ ሀመቲደ ቤዳ። ሄ ዎደ ካናነ አሳቱ ሄ ጋድያን ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ሽን መꬍና ጎዳይ አብራማዉ ቆንጪደ አ፥ “ሀ ጋድያ ታን ነ ዘረꬃዉ እማና” ያጌዳ። እ ባረዉ ቆንጬዳ መꬍና ጎዳዉ ሄ ሳኣን ያርሽያ ሳኣ ኬጺደ ጎይኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ሄዋፐ ደንዲደ፥ ቤቴለፐ አዋይ ዶልያ ባጋና ደእያ ደረትያ ሳኣ ቢደ፥ ሄዋን ቤቴለ አዋይ ዉልያ ባጋ አጊደ፥ ቃይ አይ አዋይ ዶልያ ባጋ አጊደ፥ ግዱዋን ባረ ዱንካንያ ꬎጌዳ፤ ሄዋን መꬍና ጎዳዉ ያርሽያ ሳኣ ኬጺደ፥ መꬍና ጎዳ ሱንꬃ ጼሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ሄዋፐ ጉየ፥ አብራመ ያፐ ደንድ ቢደ ኔጌባ ባዙዋ ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ሄ ዎደ ሄ ጋዲ ኮሻቴዳ፤ ኮሻይ ጺጽ ደእያ ድራዉ፥ አብራመ አማሬዳ ዎድያ ደአናዉ ዱገ ግብጼ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ግብጼ ገላና ሀንሽን፥ አብራመ ባረ ማቻቶ ሳሮ ሀዋዳን ያጌዳ፤ “ስሳ፤ ኔን ሎይꬃ ማላ ሎኦ ማጫ አሳ ግድያዋ ታን ኤራይ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ግብጼ አሳቱ ኔና በእያ ዎደ ኡንቱንቱ፥ ‘ሀና አ ማቻቶ’ ያጊደ ኡንቱንቱ ታና ዎꬋና፤ ሽን ኔና ፓጻ አጋና። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ስም ኡንቱንቱ ታዉ ነ ጋሱዋን ኬካና ማላነ፥ ቃይ ታን ሀይቀናን ነ ጋሱዋን አታና ማላ ኔን፥ ‘ታን አ ምቻቶ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","አብራመ ግብጼ ቢታ ገሌዳ ዎደ፥ ግብጼ አሳቱ ሄ ምሽራታ ዳሮ ማላ ሎኦ ማጫ አሳ ግድያዋ በኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ቃይ ግብጼ ካትያዉ ኦꬅያ ካፓቱካ እዞ በኤዳ ዎደ፥ ካትያ ስንꬃን እዞ ናሼድኖ፤ ያቲደ እዞ ካትያ ጎለ አፌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ያትና እዝ ጋሱዋን ካቲ አብራማ ሎኦ አይፍያን ጼሌዳ፤ አብራማዉ ዶርሳቱዋነ ቦራቱዋ፥ አቱማ ሀረቱዋነ ማጫ ሀረቱዋ፥ አቱማ ቆማቱዋነ ማጫ ቆማቱዋ፥ ጋሉዋ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ሽን መꬍና ጎዳይ አብራሞ ማቻት ሳር ጋሱዋን ግብጼ ካትያ ቦላነ አ ሶ አሳ ቦላ ዳሮ ካእያ ሀርግያ የዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ያትና ካቲ አብራማ ጼሲደ፥ “ኔን ሀዋ አያዉ ታ ቦላ ኦꬃድ? እዛ ነ ማቻቶ ግዴዳዋ አያዉ ታዉ ኦዳበይኪ? ");
INSERT INTO dwrENT_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ኔን እዞ፥ ‘እዛ ታ ምቻቶ’ ጋደ ታዉ አያዉ ኦዳዲ? ታን እዞ ታዉ ማቼ ኦꬃናዉ አኬዳዌ ሄዋ ድራሳ። ስም ሀእ ነ ማቻቶ ሀኖ በአ፤ እዞ አካደ ባ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ባረ አሳ አዛዝና፥ ኡንቱንቱ አብራማ አ ማቻትናነ አዉ ደእያ ኡባባና ከሲደ የዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ሄዋ ድራዉ አብራመ ባረ ማቻትናነ፥ ባረዉ ደእያዋ ኡባና ግብጼፐ ነጌባ ባዙዋ ቤዳ፤ ሎጸካ አናና ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","አብራመ ሄ ዎደ ሚዛ፥ ብራንነ ዎርቃን ዳሪ ዱረቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","እ ነጌባፐ ደንዲደ ቤቴለ ጋካናዉ ቤዳ፤ ሄ ሳአይነ ቤቴለፐነ አይፐ ግዱዋን እ ኮይሮ ባረ ዱንካንያ ꬎጌዳ ሳኣነ ");
INSERT INTO dwrENT_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ያርሽያ ሳኣ እ ኮይሮ ኬጼዳ ሳኣ። ያን አብራመ መꬍና ጎዳ ሱንꬃ ጼሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","አብራመና ዩይያ ሎጸዉካ ሚዛይ፥ ዶርሳ ዉዲነ ዱንካኒ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ሽን ኡንቱንቱ እትፐ ደአናዉ ኡንቱንቶ ቢታይ ግድቤና፤ ኡንቱንቶ ዳሮ መሂ ደእያ ድራዉ፥ ኡንቱንቱ እትፐ ደአናዉ ዳንዳይበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ሄዋ ጋሱዋን አብራሞ ዉድያ ሄምያዋንቱ ግዶንነ ሎጸ ዉድያ ሄምያዋንቱ ግዶን ዋላሳይ ከሴዳ። ሄ ዎደ ካናናቱነ ፓርዘቱ ሄ ጋድያን ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ያንና አብራመ ሎጻ፥ “ኑን እሻቱዋ ግድያ ድራዉ፥ ታ ግዶንነ ነ ግዶን፥ ታ ዉድያ ሄምያዋንቱ ግዶንነ ነ ዉድያ ሄምያዋንቱ ግዶን ዋላሳ ከሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ቢታ ኡባይ ነ ስንꬃን ደኤኔ? አነ ኑን ሻከቶይተ፤ ኔን ሀድርሳ ባጋ ቦፐ፥ ታን ኡሸቻ ባጋ ባና፤ ኔን ኡሸቻ ባጋ ቦፐ፥ ታን ሀድርሳ ባጋ ባና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ሎጸ ዩይ አꬍ ጼሊደ፥ ዮርዳኖሳ ሻፋ ዎምባይ ኡባይ ቢደ ዞኣራ ጋካናዉ፥ መꬍና ጎዳ ገነትያ ዎይ ግብጼ ቢታ ማላ ዳሮ ሃꬃይ ደእያዋ ግድያዋ በኤዳ። (ሄዌነ መꬍና ጎዳይ ሶዶማነ ጋሞራ ጌተትያ ካታማቶ ꬋይሳናፐ ካሰ)። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ሄዋ ድራዉ ሎጸ ባረዉ ዮርዳኖሳ ዎምባ ኡባ ዶሪደ፥ አዋይ ዶልያ ባጋ ቤዳ፤ ያትና ኡንቱንቱ እቱ እትዋፐ ሻከቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","አብራመ ካናነ ጋድያን ደኤዳ፤ ሽን ሎጸ ዎምባን ደእያ ዎልቃማ ካታማቱዋ ግዱዋን ኡቲደ፥ ሶዶማ ካታማ ማታን ባረ ዱንካንያ ꬎጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ሄ ዎደ ሶዶማ አሳቱ ኢታነ መꬍና ጎዳ ቦላ ፓላ ናጋራ ኦꬅያዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ሎጸ አብራመፐ ሻከቴዳዋፐ ጉየ፥ መꬍና ጎዳይ አብራማ ሀዋዳን ያጌዳ፤ “ꬎቁ ጋደ ኔን ደኢያሳፐ አዋይ ዶልያ ባጋነ አዋይ ዉልያ ባጋ፥ ቃይ ሁጲሳ ባጋነ ገድሳ ባጋ ጼላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ሀ ኔን ጼልያ ቢታ ኡባ ታን ነዉነ ነ ዛርያዉ መꬍናዉ እማና፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ታን ነ ዛርያ ሳኣ ሻፍያዳን ዳርሳና፤ ኦንነ ሳኣ ሻፍያ ፓይዳና ዳንዳዮፐ፥ ነ ዛሪካ ፓይደታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ደንዳ፤ ቢታ ጎምፓን ፑደነ ዱገነ ህንነ ሃነ ሀመታደ በአ፤ አያዉ ጎፐ፥ ታን ሀ ቢታ ነዉ እማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","አብራመ ባረ ዱንካንያ ሾዲደ፥ ከብሮነ ካታማን ደእያ ማምረ ዎላቱዋ ዎጋቱዋ ማታን ደአናዉ ቤዳ። ሄዋን መꬍና ጎዳዉ ያርሽያ ሳኣ ኬጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ሄ ዎደ ሳናኦረ ካቲ አምራፌል፥ ኤላሳራ ካቲ አርዮክ፥ ኤላማ ካቲ ካዶርላኦመርነ ጎይማ ካቲ ትድኣል ኦይዱ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ሶዶማ ካትያ ቤራኣራ፥ ጋሞራ ካትያ ብርሻራ፥ አዳማ ካትያ ሽንአባራ፥ ጻቦይማ ካትያ ሸመቤራራነ (ጾኣሮ ጌተትያ) በላአ ካትያና ኦላዉ ሳልፔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ሀዋንቱ እቼሹ ካተቱ ጋከቲደ እት ዎልቃ ግዲደ፥ (ማጽነ አባ ግያ) ሲድማ ዎምባን ሺቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ኡንቱንቱ ካሰ ታማነ ላኡ ላይꬃ ካዶርላኦመራዉ ሞደቴድኖ፤ ሽን ታማነ ሄዘንꬃ ላይꬃን አዉ ማካሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ታማነ ኦይደንꬆ ላይꬃን ካዶርላኦመርነ አናና ዙፐቴዳ ካተቱ ባረንቱ ኦላንቻቱዋ አክ ቢደ፥ አስታሮት ጻርናይማን ደእያ ራፋየታ፥ ሃማን ደእያ ዙዘታነ ሻዌ-ቅርያታይማን ደእያ ኤመታ ኦሊደ ጾኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ሆራ ቢታ አሳቱዋካ ሰኢራ ደርያን ኦሊደ፥ ባዙዋ ማታን ደእያ ኤልፓራና ግያ ሳኣ ጋካናዉ የደርሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ሄዋፐ ጉየ ስሚደ፥ አይን-ምሽፓጻ ዬድኖ። (ሀእ ሄ ሳአይ ቃዴሳ ጌተቴ።) ኡንቱንቱ አማሌቃቱዋ ቢታ ኡባነ ቃይ ሀጻጾነ ታማራ ግያ ሳኣን ደእያ አሞረቱዋ ኦሊደ ጾኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ሄዋፐ ስሚደ፥ ሶዶማ ካቲ፥ ጋሞራ ካቲ፥ አዳማ ካቲ፥ ጻቦይማ ካቲነ (ጾኣሮ ጌተትያ) በላአ ካቲ ደንዴድኖ፤ ሲድማ ዎምባን ሳልፔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ሀዋንቱ ኡባይ ኤላማ ካትያና፥ ጎይማ ካትያና፥ ሳናኦረ ካትያናነ ኤላሳራ ካትያና (ሀ እቼሹ ካተቱ ኦይዱ ካተቱዋና) ኦለቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ሲድማ ዎምባን ሄ ዎደ፥ ሽድያዳን ኦይቂያባይ ኩሜዳ ኦላይ በሴዳ፤ ሶዶማ ካቲነ ጋሞራ ካቲ ባረንቱ ኦላንቻቱዋና ኦላፐ ባቃትሽን፥ ኡንቱንቱፐ አማሬዳዋንቱ ሄ ኦላቱዋን ኩንዴድኖ፤ ሽን አቴዳዋንቱ ደርያ ባቃቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ኦይዱ ካተቱ ሶዶማነ ጋሞራ ካታማቱዋ ማጹዋ ኡባነ ኡንቱንቱ ቁማ ኡባ ቦንቂደ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","አብራሞ እሻ ናአይ ሎጸ ሶዶማን ደእያ ድራዉ፥ አካ አ ማጹዋካ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ሄዋፐ ጉየ፥ እት ብታኒ ባቃት ዪደ እብራዊያ አብራማዉ ሀዋ ኦዴዳ። አብራመ ሄ ዎደ፥ ኤሽኮላነ አኔራ እሻ አሞርያ ማምረ ዎላ ማታን ደኤ። ኡንቱንቱ ኡባይካ ኦላ ዛራናዉ አብራመና ጫቁዋ ጫቀት ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","አብራመ ባረ ዳቡ ኦሞደቴዳዋ ስሴዳ ዎደ፥ ኦላ ኤርያ ባረ ሶን የለቴዳ 318 አሳ ደንꬄዳ፤ ሄ ኦይዱ ካተቱዋ ካሊደ ዳን ግያ ካታማ ጋካናዉ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ቃማን ባረ አሳ ጩጉዋን ጩጉዋን ሻክ፥ ባረ ሞርከቱዋና ኦለቲደ ኡንቱንታ ጾኔዳ። ደማስቆፐ ሁጲሳ ባጋና ደእያ ሆባ ግያ ሳኣ ጋካናዉ የደርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ማጹዋ ኡባ፥ ቃይ ባረ ዳቡዋ ሎጻነ አ ማጹዋ፥ ማጫ አሳነ ሀራ አሳ ዎꬅ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","አብራመ ካዶርላኦመራነ አናና ዙፐቴዳ ካተቱዋ ጾኒደ ስሜዳዋፐ ጉየ፥ ሶዶማ ካቲ፥ (ካተቱዋ ዎምባ ግያ) ሻዌሀ ዎምባን አ ሞካናዉ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ሄ ዎደ፥ ሳሌመ ካቲ ማልካ-ጸደቂ ኡክꬃነ ዎይንያ ኤሳ አኪደ ዬዳ፤ እ ኡባፐ ꬎቂያ ጾሳ ቄስያ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","እ አብራማ ሀዋዳን ያጊደ አንጄዳ፤ “ኡባፐ ꬎቂያ ጾሳይ፥ ሳሉዋነ ሳኣ መꬌዳዌ አብራማ አንጆ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ቃይ ኡባፐ ꬎቂያ ጾሳይ፥ ነ ሞርከቱዋ ነ ኩሽያን አꬅ እሜዳዌ ጋላተቶ” ያጌዳ። አብራመ ኡባባፐ አስራታ ከሲደ፥ ማልካ-ጸደቃዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ሶዶማ ካቲ አብራማ፥ “አሳ ታዉ እማደ፥ ማጹዋ ነዉ አካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ሽን አብራመ ሶዶማ ካትያ፥ “ታን መꬍና ጎዳዉ፥ ኡባፐ ꬎቂያ ጾሳዉ፥ ሳሉዋነ ሳኣ መዳዎ፥ ታ ኩሽያ ደንꬃደ ጫቃድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","24","ታ አሳይ ሜዳዋፐነ ታናና ቤዳ አኔራ፥ ኤሽኮላነ ማምረ ጋክያዋፐ አትና፥ ኔን፥ ‘አብራማ ታን ዱረያድ’ ኡባካ ጌና ማላ፥ ታን ነዋፐ ሀራይ አቶ ቁንጩትያ ዎይ ጫማ ቃችያዋነ አክከ። ኡንቱንቱ ባረና ጋክያዋ አክኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ሄዋፐ ጉየ፥ መꬍና ጎዳ ቃላይ ሳጻን አብራመኮ ዪደ፥ “አብራማ፥ ያዮፓ! ታን ነዉ ጎንዳለ፤ ነ ጋቲ ሎይꬅ ዳራ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","አብራመ፥ “አቤት ኡባ ሞድያ መꬍና ጎዳዉ፥ ታዉ ኡባካ ናእ ባይና ድራዉ፥ ኔን እምያ ጋቲ ታዉ አይሴ? ደማስቆ ኤልኤዛር ታና ላታና ሽን” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ቃይካ አብራመ፥ “ኔን ታዉ ናኣ እማባካ፤ ሄዋ ድራዉ ታ ሶን ደእያ ቆማይ ታና ላትያዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","መꬍና ጎዳ ቃላይ አኮ ዪደ፥ “ሀ ቆማይ ኔና ላተና፤ ሽን ነ ጉልባታፐ ከስያዌ ኔና ላታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ስሚደ ካረ አ ከሲደ፥ “ሳሉዋ ፑደ ጼላ፤ ኔን ጾልንተቱዋ ፓይዳናዉ ዳንዳዮፐ ፓይዳ፤ ነ ዘረꬃይካ ሀዋ ኬሻ ግዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","አብራሞ መꬍና ጎዳ አማኔዳ፤ መꬍና ጎዳይ ሄዋ አዉ ጽሎተꬃዳን ፓይዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","መꬍና ጎዳይ ቃይካ አ፥ “ታን ኔን ሀ ቢታ ላታና ማላ ነዉ እማናዉ ኡር ግያ ካላዳዌቱዋ ካታማፐ ኔና ከሳ አሄዳ መꬍና ጎዳቴ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ሽን አብራሞ አ፥ “አቤት ኡባ ሞድያ መꬍና ጎዳዉ፥ ታን ሀ ቢታ ላታናዋ አያን ኤሮ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","መꬍና ጎዳይ አ፥ “ሄዙ ላይꬃ ኡሳ፥ ሄዙ ላይꬃ ዴሻ፥ ሄዙ ላይꬃ ዶርሳነ ላኡ ቆሞ ሀራጰቱዋ ታዉ አካደ ያ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","እ ሀዋንታ ኡባ አዉ አፌዳ፤ ኡንቱንታ ጳልቂደ ላኡ ከሴዳ፤ ላኡዋ ከሴዳዋ እቱዋ እቱዋ ባጋን ዎꬄዳ፤ ሽን ካፎቱዋ ላኡ ከስ ጳልቂቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ሄ ዎደ አንኮቱ ሄ አሹዋ ቦላ ዎꬌድኖ፤ ሽን አብራመ ኡንቱንታ የደርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","አዋይ ዉልያ ዎደ አብራማ ዎልቃማ ገምእሹ ኦይቄዳ፤ ꬍጵ ጌዳ ꬉማይ አ ቦላ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ያትና መꬍና ጎዳይ አ፥ “ነ ዘረꬃይ ሀራ ጋድያን በተ ግዲደ ደአናዋ ኔን ቱሙፐ ኤራ፤ ኡንቱንቱ አይለቲደ ኦይዱ ጼቱ ላይꬃ ናቀታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ሽን አይለዪደ ኡንቱንታ ሞድያ ካዉተꬃ ታን ሙራና፤ ሄዋፐ ጉየ፥ ኡንቱንቱ ዳሮ አቁዋና ሄ ቢታፐ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ኔና ግዶፐ፥ ኔን ነ ማይዛ አዎቱዋኮ ሳሮተꬃን ባና፤ ኔን ሎይꬃ ጭማደ ሀይቃናነ ሞገታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ሽን ኦይደንꬆ የለታን ነ ዘረꬃይ ሀ ጋድያ ስማና፤ አያዉ ጎፐ፥ አሞረቱ ናጋራይ ብሮ ልክያ ጋክቤና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","አዋይ ዉልና ሳአይ ꬉሜዳ፤ ጮጭያ ጩዋይነ ታማ ላጩ አኬከናን ቤቲደ፥ ሄ ላኡ ከስ ጳልቀቴዳዋንቱፐ ግዱዋና አꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ሄ ጋላስ መꬍና ጎዳይ አብራመና ሀዋዳን ያጊደ ጫቁዋ ጫቀቴዳ፤ “ግብጼ ሻፋፐ ዶሚደ ኤፍራጺሳ ግያ ዎልቃማ ሻፋ ጋካናዉ፥ ሀ ቢታ ታን ነ ዘረꬃዉ እማድ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","ሀ ቢታይ ቄናቱዋ፥ ቀኒዘቱዋ፥ ቃድሞነቱዋ፥ ሂተቱዋ፥ ፓርዘቱዋ፥ ራፋየቱዋ፥ አሞረቱዋ፥ ካናነቱዋ፥ ገርጌሰቱዋነ ያቡሳቱዋ ቢታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","አብራሞ ማቻታ ሳራ አዉ ናኣ የላበይኩ፤ ሽን እዝዉ ግብጼፐ ዬዳ አጋሮ ግያ እት አይላታ ደአዉ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ሄዋ ድራዉ ሳራ አብራማ ጼሳደ፥ “በአ፥ መꬍና ጎዳይ ታዉ የሉዋ ድጌዳ። ኔን ባደ፥ ታ አይላትና ግሳ፤ ኦን ኤሪ፥ ታን እዝ ባጋና ናኣ ዳዮ ግዳነንቶነ” ያጋዱ። አብራመ ሳር ቃላ ስሲደ ማዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","አብራመ ካናነ ጋድያን ታሙ ላይꬃ ኡቴዳዋፐ ጉየ፥ አብራሞ ማቻታ ሳራ ግብጼፐ አሄዳ ባረ አይላቶ አጋሮ፥ ባረ አስና አብራማዉ ማቼተꬃዉ እማዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","አጋሮ አኬዳ፤ እዛ ሻሃራዱ። እዛ ባረዉ ሻሃራይ አቴዳዋ ኤሬዳ ዎደ፥ ባረ ጎዳቶ ካꬍያ ዶማዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ሄ ዎደ ሳራ አብራማ፥ “ታና ሀ ናቁዋ ናቂስያዌ ኔና፤ ታን ታ አይላቶ ነዉ እምና፥ እዛ ሀእ ባረዉ ሻሃራይ አቴዳዋ ኤራደ፥ ታና ካꬋዉ። ነባነ ታባ መꬍና ጎዳይ ፕርዶ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","አብራመ ሳሮ፥ “ሀኖ በአ፤ ነ አይላታ ነ ኩሽያና፤ ኔን እዞ ነዉ ሎኦዋ ኦꬃ” ያጌዳ። ሄዋፐ ጉየ፥ ሳራ አጋሮ ናቂና፥ እዛ ከሳደ ኢፐ ባቃታዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","መꬍና ጎዳ ኪታንቻይ ፑልቱዋ ማታን ዎራን አጋሮ ደሜዳ፤ ሄ ፑልቱ ሹራ ግያ ጋድያ አፍያ ኦግያ ማታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","እ አጋሮ፥ “ሀነ ሳር አይላቴ አጋሬ፥ ሀቃፐ ያድ? ቃይ ሀቃ ባይ?” ያጊደ ኦቼዳ። እዛ፥ “ታን ታ ጎዳት ሳርፐ ባቃታይ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","መꬍና ጎዳ ኪታንቻይ እዝዉ፥ “ኔን ነ ጎዳትኮ ጉየ ስማደ ባ፤ እዝዉ ሞደታ” ያጊደ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ቃይካ መꬍና ጎዳ ኪታንቻይ እዞ፥ “ነ ዛሪ ፓይዳናዉ ዳንዳየተናዋ ኬና ታን ጮርሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ቃይካ መꬍና ጎዳ ኪታንቻይ እዞ፥ “ሀእ ኔን ሻሃራ፤ ኔን አቱማ ናኣ የላና፤ አ እስማኤላ ጋደ ሱንꬃና፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ነ ዋሱዋ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","እ ዎራን የዳ ደእያ ሀርያ ማላ አሳ ግዳና፤ አሳ ኡባና እ ኤቀታና፤ ቃይ አሳይ ኡባይካ አናና ኤቀታና፤ እ ባረ እሻቱዋ ኡባና እጾ ግዲደ ደአና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","አጋራ፥ “ታን ታና በእያዋ በኣደ ፓጻ አታኔ?” ያጋዱ፤ እዛ ባረዉ ሃሳዬዳ መꬍና ጎዳ፥ “ኔን ታና በእያ ጾሳ” ያጋደ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ሄዋ ድራዉ ሄ ፑልቱዋ ኦላይ፥ “ታና በእያ ደኡዋ ጾሳ ፑልቱዋ” ጌተቴዳ፤ ሄ ኦላይ ሀኖ ጋካናዉ ቃዴሰፐነ ባሬዳፐ ግዱዋን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","አጋራ አብራማዉ አቱማ ናኣ የላዱ፤ አብራመ አጋራ የሌዳ ናኣ እስማኤላ ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","አጋራ እስማኤላ አብራመዉ የሌዳ ዎደ፥ አብራሞ ላይꬃይ ሆስፑን ታማነ ኡሱፑና። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","አብራሞ ላይꬃይ ኡዱፑን ታማነ ኡዱፑና ግድያ ዎደ፥ መꬍና ጎዳይ አዉ ቆንጪደ አ፥ “ታን ኡባ ዳንዳይያ ጾሳ፤ ኔን ታ ስንꬃን ሀመታ፤ ሱረ ግዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ታን ታፐነ ኔፐ ግዱዋን ታ ጫቁዋ ዎꬃይ፤ ታን ኔና ሎይꬃ ጮርሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","አብራመ ባረ ዴሙዋን ዱገ ጉፋኔዳ፤ ጾሳይ አዉ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ስም፥ ታን ኔናና ጫቀትያ ጫቁ ሀዋ፤ ኔን ዳሮ ካዉተꬃ አዉዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ሀዋፐ ዶሚደ ነ ሱንꬃይ አብራማ ጌተተና፤ ሽን ነ ሱንꬃይ አብራሃማ ግዳና። አያዉ ጎፐ፥ ታን ኔና ዳሮ ካዉተꬃ አዉዋ ኦꬃድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ታን ኔና ሎይꬃ ጮርሳና፤ ታን ኔፐ ካዉተꬃቱዋ መꬋና፤ ካተቱካ ኔፐ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ታን ታፐነ ኔፐ፥ ኔፐ ጉየ ነ ዘረꬃፐነ ግዱዋን፥ የለታፐ የለታ ጋካናዉ ታ ጫቁዋ ጫቀታይ፤ ሀ ጫቁ ታን ነዉነ ኔፐ ጉየ ነ ዘረꬃዉ ጾሳ ግዳና ማላ መꬍና ጫቁዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ሀእ ኔን በተ ግዳደ ደእያ ካናነ ቢታይ ኡባይ ነዉነ ኔፐ ጉየ ነ ዘረꬃዉ መꬍናዉ ላታ ግዳና ማላ ታን እማና፤ ቃይ ታን ኡንቱንቱ ጾሳ ግዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ቃይካ ጾሳይ አብራሃማ፥ “ኔና ግዶፐ፥ ኔን ታ ጫቁዋ ናጋ፤ ኔንካ ኔፐ ጉየ ነ ዘረꬃይካ፥ የለታፐ የለታ ጋካናዉ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ታፐነ ኔፐነ፥ ኔፐ ጉየ ነ ዘረꬃፐ ግዱዋን ህንተንቱ ናጋና ታ ጫቁ ሀዋ፤ ህንተንቱ ግዱዋን ደእያ አቱማዌ ኡባይ ቃጻረቶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ህንተንቱ አቱማተꬃ ሾኩዋ ቃጻረቲታ፤ ሄዌ ታፐነ ህንተፐ ግዱዋን ደእያ ጫቆ ማላ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ህንተንቱ ግዶን ስንꬃፐ የለታና አቱማ ናናይ ኡባይ የለቴዳ ሆስፑንꬃ ጋላሳን ቃጻረታናዉ ኮሼ። ነ ሶን የለቴዳዋንታ ግድና፥ ዎይ አላጋፐ ሻሉዋን ሻመቴዳ አይለቱዋ ግድና፥ ነ ዘረꬃ ግደናዋንታካ አቱማዋንታ ቃጻራናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ነ ሶን የለቴዳዋንቱ ነ ሻሉዋን ሻመቶዋንቱ ቃጻረትኖ። ሀዌ ህንተንቱ አሹዋን ደእያ ታ ጫቁ መꬍና ጫቁዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ቃጻረትቤና፥ ባረ ሾኩዋና ደእያ አቱማ አሳይ ኡባይ ባረ አሳፐ ዱጻና፤ አያዉ ጎፐ፥ እ ታ ጫቁዋ መንꬄዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ቃይካ ጾሳይ አብራሃመ፥ “ስም፥ ነ ማቻት ሳር ሱንꬃ ሳራይ ጎፓ፤ ሀዋፐ ስንꬃዉ እዝ ሱንꬃይ ሳሮ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ታን እዞ አንጃና፤ ታን ኢፐ ነዉ አቱማ ናኣ ቱሙ እማና። እዞ ታን አንጃና፤ እዛ ካዉተꬃቱዋ አቶ ግዳና፤ አሳ ካተቱ ኢፐ ያና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","አብራሃመ ባረ ዴሙዋን ጉፋኔዳ፤ እ ሚጪደ ባረ ዎዛናን፥ “ጼቱ ላይꬃ አሳይ ቱሙ ናኣ የላኔ? ቃይ ኡዱፑን ታሙ ላይꬃ ግዴዳ ሳራ ናኣ የላኔ?” ያጊደ ቆፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","አብራሃመ ጾሳ፥ “እስማኤል ታና ላትያዋ ግዳናዉ ዳንዳየኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ሽን ጾሳይ፥ “ቱይት፥ ነ ማቻታ ሳራ ነዉ አቱማ ናኣ ቱሙፐ የላና፤ ኔን ይሳቃ ጋደ አ ሱንꬃና። አፐ ጉየ፥ አ ዘረꬃዉ መꬍና ጫቁዋ ግዳና ማላ፥ ታን አናና ታ ጫቁዋ ጫቀታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ቃይ እስማኤላባ ግዶፐነ፥ ኔን ኦቼዳዋ ታን ስሳድ፤ ታን አካ አንጃና፤ ታን አ አንጃናነ አ ዘረꬃ ሎይꬃ ጮርሳና፤ እ ታማነ ላኡ የለታቱዋ የላና፤ ታን አ ዘረꬃ ዎልቃማ ካዉተꬃ ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ሽን ታን ታ ጫቁዋ ላይꬅ ሀኖደ ሳራ ነዉ የልያ ይሳቃና ጫቀታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ጾሳይ አብራሃማና ሃሳዪደ ዉርሴዳዋፐ ጉየ፥ አብራሃመፐ ሻከቲደ ፑደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ሄ ጋላሳን አብራሃመ ባረ ናኣ እስማኤላ፥ ባረ ሶን የለቴዳ ኡባ፥ ባረ ሻሉዋን ሻሜዳዋንታ ኡባ፥ ባረ ሶን ደእያ አቱማ አሳ ኡባ፥ ጾሳይ አዉ ኦዴዳዋዳን ኡንቱንቱ አቱማተꬃ ቃጻሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","አብራሃመ ባረ አቱማተꬃ ቃጻረትያ ዎደ፥ ኡዱፑን ታማነ ኡዱፑን ላይꬃ አሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","አ ናአይ እስማኤል ባረ አቱማተꬃ ቃጻረትያ ዎደ፥ ታማነ ሄዙ ላይꬃ ናኣ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","አብራሃመነ አ ናአይ እስማኤል ላአቱካ ሄ ጋላስ ቃጻረቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","አብራሃመ ሶን ደእያ አቱማ አሳይ ኡባይ፥ አ ሶን የለቴዳዋንቱነ ሻሉዋን ሻሜዳዋንቱ ኡባይ አናና ቃጻረቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","አብራሃመ ማምረ ዎላቱዋ ዎጋቱዋ ጋርሳን ባረ ዱንካንያ ፐንግያን ሴታ ጋላስ ኡት ደእሽን፥ መꬍና ጎዳይ አዉ ቆንጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","አብራሃመ ꬎቁ ጊደ ጼሊደ ሄዙ አሳቱ አ ማታን ኤቄዳዋንታ በኤዳ፤ ኡንቱንቱና ጋከታናዉ ባረ ዱንካንያ ፐንግያፐ ደንድ ዎጼዳ፤ ጋኪደ፥ ገድያን ሆኪደ፥ ኡንቱንቱ ስንꬃን ጎይኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ስሚደ እ፥ “አቤት ታ ጎዳው፥ ታን ነ ስንꬃን ናሸቴዳዋ ግዶፐ፥ ታና ነ ቆማ አጋደ አꬎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ሀያና ጉꬃ ሃꬃይ ዮ፤ ህንተንቱ ገዲ ሜጨትና፥ ሀ ምꬃ ኩዋን ሸምፕ አክተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ህንተንቱ ሀእ ታኮ ህንተንቱ ቆማኮ ዬዳ ድራዉ፥ ካምእ ጊደ ህንተንቱ ብያሳኣ ባና ማላ፥ ታን ህንተንቶ ምያዋ አሀይ” ያጌዳ። ኡንቱንቱ፥ “ዳሮ ሎአ፤ ኔን ግያዋዳን ኦꬃ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","አብራሃመ ዱንካንያ ግዶ ሳርኮ ኤሌል ቢደ፥ “ኤሌላደ ሊቆ ꬊልያፐ ሄዙ ከረ ግድያዋ አካ ሙናቃደ ኡክꬃ ኡካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ቃይ፥ አብራሃመ ባረ መህያኮ ዎጽ ቢደ፥ ሎኦ ቦልትቦልታ ቦልትቦልታ ማራ ዶሪደ፥ እት ቆማዉ እምና፥ እ ኤሌል ሹኪደ ጊግሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ያትና አብራሃመ መኤዳ ማꬃነ ጊግሴዳ ማራ አሹዋ እማꬃቱዋ ስንꬃ አꬄዳ፤ ኡንቱንቱ ሚሽን፥ እ ሄ ምꬃ ጋርሳን ኡንቱንቱ ማታን ኤቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ኡንቱንቱ አ፥ “ነ ማቻታ ሳራ ሀቃኔ?” ያጊደ ኦቼድኖ። እዛ፥ “ህን ዱንካንያ ግዱዋን ደአዉ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","መꬍና ጎዳይ አ፥ “ታን ላይꬅ ሀኖደ ቱሙ ኔኮ ስማና፤ ሄ ዎደ ነ ማቻታ ሳራ አቱማ ናኣ የላና” ያጌዳ። ሳራ ሄ ዎደ አፐ ጉየ ባጋና ደእያ ዱንካንያ ፐንግያን ደእያና ሄዋ ስሳዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","አብራሃመነ ሳራ ባረንቱ ላይꬃ ሎይꬅ ሱጊደ ጭሜድኖ። ሳርዉ ፒላይ ይያዋ አጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ሄዋ ድራዉ ሳራ ባረ ዎዛናን፥ “ታን ሀእ ጭማ ዉራ ክቾዋፐ ጉይያንነ ታ ጎዳይ ጭሞዋፐ ጉየ፥ ሀእ ታዉ አቱማ አሳና ጋከትያዌ ዋን ሀናኔ?” ያጋደ ሚጫዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","መꬍና ጎዳይ አብራሃመ ሄ ዎደ፥ “ ‘ታን ጭማ ክቾዋፐ ጉየ፥ ቱሙ ናኣ የላንታየ?’ ጋደ፥ ሳራ አያዉ ሚጫደ? ");
INSERT INTO dwrENT_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","መꬍና ጎዳዉ ዳንዳየተናባይ ቱሙ ደኢ? ላይꬅ ሀኖደ ታን ኔኮ ስማና፤ ሄ ዎደ ሳራ አቱማ ናኣ የላና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ሳራ ሎይꬃ ያዬዳ ድራዉ፥ “ታን ሚጫበይከ” ያጋደ ላካዱ። ሽን እ፥ “ኤ፥ ኔን ቱሙ ሚጫዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ሄዋፐ ጉየ አሳቱ ደንዲደ ብ፥ ሶዶማ ካታማ ዱገ ዛር ጼሌድኖ፤ አብራሃመነ ኡንቱንታ ሞይዚደ ኡንቱንቱና ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","መꬍና ጎዳይ ሄ ዎደ፥ “ታን ታ ኦꬃናዉ ሀንያባ አብራሃመፐ ቆስከ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","አብራሃመ ቱሙፐ ግታነ ዎልቃማ ካዉተꬃ ግዳና፤ ሀ ሳኣ ካዉተꬃቱ ኡባይ አ ባጋና አንጀታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","አያዉ ጎፐ፥ ጽሎተꬃነ ፕርዳ ኦꬂደ፥ መꬍና ጎዳ ኦግያ ናጋናዳን ባረ ናናነ ባረፐ ጉየ፥ ባረ ሶ አሳ እ ዞራና ማላ፥ ታን አ ዶራድ፤ ሄዌነ መꬍና ጎዳይ አብራሃመዉ እማና ጌዳዋ ኡባ ፖላናሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","21","መꬍና ጎዳይ አብራሃመ፥ “ሶዶማፐነ ጋሞራፐ ዋስያ ዋሱ ሎይꬅ ዳሬዳ ድራዉነ ኡንቱንቱ ናጋራይ ሎይꬅ ዴጼዳ ድራዉ፥ ኡንቱንቱ ኦꬄዳባይ ታኮ ጋኬዳ ዋሱዋ ኬሻ ኢተንቶነ በአናዉ አነ ታን ዱገ ዎꬋይ፤ ሄዋ ማላ ኢታ ግዳና ꬋይንቶነ ኤራና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ሄዋፐ ጉየ፥ ላኡ አሳቱ ሶዶማኮ ስሚደ ቤድኖ፤ ሽን አብራሃመ መꬍና ጎዳ ስንꬃን ዎስ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ሄ ዎደ አብራሃመ መꬍና ጎዳኮ ሺቂደ ያጌዳ፤ “ቱሙ ኔን ጽሎቱዋ ኢታቱዋና ꬋይሳይ? ");
INSERT INTO dwrENT_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ሄ ዎልቃማ ካታማን እሻታሙ ጽሎቱ ደእንቶካ፥ ኔን ꬋይሳይ? ኔን አን ደእያ እሻታሙ ጽሎቱዋ ድራዉ ሄ ካታማ አሽኪ? ");
INSERT INTO dwrENT_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ሄዌ ኔፐ ሃኮ፤ ጽሎቱዋ ኢታቱዋና ዎꬍያዌነ ጽሎቱዋነ ኢታቱዋ እት አይፍያን ጼልያዌ ኔፐ ሃኮ። ሀ ሳኣ ኡባ ፕርድያዌ ጽሉዋ ፕርደኔየ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","መꬍና ጎዳይ፥ “ሄ ሶዶማ ካታማን እሻታሙ ጽሎቱ ደኦፐ፥ ሄ ሳኣ ኡባ ኡንቱንቱ ድራዉ ታን አሻና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ሄዋፐ ጉየ አብራሃመ፥ “ታን ቢታነ ብድንꬃ ግዳደ ታ ጎዳና ጻላደ ሃሳያናዉ ስም ዶማ ክቻድ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","እሻታሙ ጽሎቱዋፐ እቼሹ ፓጭንቶ፥ ኔን ሄ እቼሻቱዋ ድራዉ ሄ ካታማ ኡባ ꬋይሳይ?” ያጌዳ። መꬍና ጎዳይ፥ “ታን ያን ኦይታማነ እቼሹ ጽሎቱዋ ደምንቶ፥ ሄ ካታማ ꬋይስከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","አብራሃመ ዛረꬂደካ፥ “ያን ኦይታሙ ጻላላይ ቤትንቶ ሽን?” ያጌዳ። እ፥ “ታን ሄ ኦይታማቱዋ ድራዉ፥ ሄ ካታማ ꬋይስከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ሄዋፐ ጉየ እ፥ “ሀይ ጎዳይ ታዉ ሀንቀቶፖ፤ ታን ጉጃደካ ሃሳያይ። ያን ሀታሙ ጻላላይ ቤትንቶ ሽን?” ያጌዳ። መꬍና ጎዳይ፥ “ታን ያን ሀታሙዋ ደምንቶ፥ ሄ ካታማ ꬋይስከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","አብራሃመ ቃይካ፥ “ታን ጎዳና ጻላደ ሃሳያናዉ ዶማ ክቻድ፤ ያን ላታሙዋ ጻላላይ ቤትንቶ ሽን?” ያጌዳ። መꬍና ጎዳይ፥ “ሄ ላታማቱዋ ድራዉ ታን አ ꬋይስከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ሄዋፐ ጉየ አብራሃመ፥ “ሀይ ጎዳይ ታዉ ሀንቀቶፖ፤ ታን መጽ እት ገደ ሃሳያይ፤ ያን ታሙ ጻላላይ ቤትንቶ ሽን?” ያጌዳ። መꬍና ጎዳይ፥ “ሄ ታማቱዋ ድራዉ ታን ሄ ካታማ ꬋይስከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","መꬍና ጎዳይ አብራሃመና ሃሳያ ዉርሴዳዋፐ ጉየ ቤዳ፤ አብራሃመካ ባረ ሶ ስሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ሄ ላኡ ኪታንቻቱ ኦማርስ ሶዶማ ካታማ ጋኬድኖ፤ ሄ ዎደ ሎጸ ሄ ካታማ ፐንግያን ኡቴዳ። ሎጸ ኡንቱንታ በእነ ኡንቱንቱና ጋከታናዉ ኤቂደ ቤዳ፤ ባረ ዴሙዋ ሳኣ ጋꬂደ ጎይኔዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“ታ ጎዳቶ፥ ህንተንቱ ቆማ ሶ ስሜርክቴ፤ ህንተንቱ ገድያ ሜጨቲደ ቃማ አቅተ፤ ጉራን ደንዲደ ህንተንቱ ብያሳኣ ባንታ” ያጌዳ። ኡንቱንቱ፥ “ቱይት፤ ኑን ሀ ካታማ ዳባባን አቃና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ሽን እ ኡንቱንታ ሎይꬅ ሾቤዳ ድራዉ፥ አናና ቢደ አ ሶ ገሌድኖ፤ እ ኡንቱንቶ ቁማ ካꬂደ፥ ጫለና ኡክꬃ ኡኪደ አꬂና፥ ኡንቱንቱ ሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ኡንቱንቱ ግሰናን ደእሽን፥ ሶዶማ ካታማ አቱማ አሳይ ኡባይ፥ ናናቱዋፐ ጭማ ጋካናዉ፥ እቱነ አተናን ዪደ፥ ጎልያ ዩይ አꬍ ዶዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ሎጻ ጼሲደ ያጌድኖ፤ “ሀቼ ቃማ ነ ሶ ዬዳ አቱማ አሳቱ ሀቃን ደኢኖ? ኑን ኡንቱንቱና ሻርሙጻና ማላ ኡንቱንታ ኑኮ ካረ ከሳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ሎጸ ኡንቱንቱና ጋከታናዉ ካረ ከሲደ፥ ካርያ ጉየ ጎርዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ኡንቱንታ ሀዋዳን ያጌዳ፤ “ታ እሻቶ፥ ሀ ኢታ ኦሱዋ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ስም ታዉ ላኡ ማጫ ናናይ፥ አቱማ አሳ ኤርቤና ዎዶራቱ ደኢኖ፤ ታን ኡንቱንታ ህንተንቶ ካረ ከሳይ፤ ህንተንቱ ኡንቱንታ ህንተዉ ሎኦዋዳን ኦꬃና ዳንዳዪታ። ሽን ሀ አሳቱዋ ቦላ አይነ ኦꬆፕተ፤ አያዉ ጎፐ፥ ኡንቱንቱ ታ ጎለ ገሊደ ታ ካራ ጋርሳን ደኢኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","አሳቱ አ፥ “ኑ ስንꬃፐ ክቻ!” ያጌድኖ፤ ቃይካ ኡንቱንቱ፥ “ሀ ብታኒ ሀ ጋድያን በተ ግድ ዪደ፥ ሀእ ኑ ቦላ ፕርዳናዉ ካጄሌዳ! ሀእ ኑን ኔና ኡንቱንቱ ቦላ ኦꬃናዉ ቆፔዳዋፐ ኢታ ኦꬃና!” ያጌድኖ። ኡንቱንቱ ሎጻ ጉየ ሱግ የጊደ ፐንግያ መንꬃናዉ ሺቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ሽን ሄ ላኡ አሳቱ ባረንቱ ኩሽያ ካረ የዲደ፥ ሎጻ ሶ ጎች ገልሲደ ፐንግያ ጎርዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ሄዋፐ ጉየ፥ ኡንቱንቱ ጎለ ፐንግያን ደእያ አሳ፥ ጉꬃፐ ግታ ጋካናዉ ቆቅሴድኖ። ያትና ኡንቱንቱ ፐንግያ ደማናዉ ኮዪደ ዳቡሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ሄ ላኡ አሳቱ ሎጻ፥ “ነዉ ሀዋን ነ ማጫ ናና ጊግሴዳዋንቱ፥ ነ አቱማ ናናይ ዎይ ነ ማጫ ናናይ ዎይ ነባ ግዴዳ አሳይ ኦና ግዶፐነ ሀ ካታማን ደኢ? ኡንቱንታ ሀዋፐ ከሳ ድጋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","አያዉ ጎፐ፥ ኑን ሀ ሳኣ ꬋይሳና ሀኔቶ። ኡንቱንቱ ዋስያ ዋሱ ጎዳ ስንꬃን ሎይꬅ ዳሬዳ ድራዉ፥ መꬍና ጎዳይ ኑና ሀ ካታማ ꬋይሳናዉ ኪቴዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ሄዋ ድራዉ ሎጸ ከሲደ፥ ባረ ማጫ ናና ጊግሴዳዋንቱኮ ቢደ ኡንቱንታ፥ “ኤሌል ደንዲደ ሀዋፐ ከስተ፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ሀ ካታማ ꬋይሳና ሀኔ” ያጌዳ። ሽን አ ማጫ ናና ጊግሴዳዋንቱ እ ቅꬌዳ ጊደ ቆፔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ሳአይ ዎንታናዉ ሆልጆጅ ዞእያ ዎደ፥ ሄ ኪታንቻቱ ሎጻ፥ “ደንዳ! ነ ማቻቶነ ሀዋን ደእያ ነ ላኡ ማጫ ናና አካደ ኤሌላ ከሳ! ሄዌ ꬋዮፐ፥ ሀ ካታማይ ፕርደትያ ዎደ ኔንካ ꬋያሳ” ያጊደ ድርቢሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ሽን ሎጸ ያት ጊና፥ ሄ አሳቱ አ ኩሽያ፥ አ ማቻት ኩሽያነ አ ማጫ ናና ላኡዋ ኩሽያ ኦይቂደ፥ ሄ ካታማፐ ኡንቱንታ ከሴድኖ፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ኡንቱንቶ ቃረቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ኪታንቻቱ ኡንቱንታ ካታማፐ ከሴዳ ሳናካ፥ ሄ ኪታንቻቱዋፐ እቱ ያጌዳ፤ “ህንተንቱ ሸምፑዋ አኪደ ባቃትተ! ጉየ ጼሎፕተ! ቃይ ሀ ዎምባን ሀቃንካ ኤቆፕተ! ደርያኮ ባቃትተ! ህንኮደ ህንተንቱ ꬋያና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ሽን ሎጸ ኡንቱንቶ ያጌዳ፤ “ቱይት! ሀይ ታ ጎዳቶ፥ ያጎፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ታን ህንተንቱ ቆማይ ህንተንቱ ስንꬃን ናሸቴዳዋ ድራዉ፥ ታና አሻናዉ ታዉ ዳሮፐ ሎይꬅ ማዴድታ። ሽን ታን ደርያኮ ባቃታናዉ ዳንዳይከ፤ ሀዌ ባሻይ ጋኪደ ታና ሙካናነ ታንካ ሀይቃና። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ጼልተ፤ ሀዋን እት ካታማይ ደኤ፤ እ ዎጻናዉ ማታነ ጉꬃ ካታማ። ታን ያ ባቃቶ? እ ቄር ጉꬃ ካታማ ግደኔ? ታ ሸምፑ ያን አታናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ኪታንቻይ፥ “ኤ፥ ታን ነ ኦሻ ስሳና፤ ታን ኔን ግያ ካታማ ꬋይስከ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ሽን ያ ኤሌላ ባቃታ፤ አያዉ ጎፐ፥ ኔን ያ ጋካናዉ፥ ታን አይነ ኦꬃናዉ ዳንዳይከ” ያጌዳ። ሄዋ ድራዉ ሄ ካታማ ሱንꬃይ ዞኣሮ ጌተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ሎጸ ጾኣሮ ጋኬዳ ዎደ፥ ብሮ ጻልቂ ዶሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","መꬍና ጎዳይ ሄ ዎደ ታማነ ኤጽያ ዲንያ ሶዶማነ ጋሞራ ቦላን መꬍና ጎዳ ማታፐ ሳሉዋፐ ቡኪደ ባይዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ሄዋዳን ኦꬂደ መꬍና ጎዳይ ሄ ካታማታ፥ ሄ ዎምባ ኡባ፥ ሄ ካታማቱዋ ግዶን ደእያ ኡባነ ሄ ጋድያን ደእያ ምꬃ ማታ ꬋይሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ሽን ሎጸ ማቻታ ጉየ ጼላደ ማጽነ ቱሳ ግዳዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ዎንተꬃ ጋላስ ዎንታ ጉራን አብራሃመ ደንዲደ፥ መꬍና ጎዳ ስንꬃን ካሰ እ ኤቄዳ ሳኣ ስሚደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","እ ሶዶማነ ጋሞራ ሄ ዛንጋራን ደእያ ቢታ ኡባ ዱገ ጼሌዳ፤ ሄ ዎደ ጩዋይ ጮጭያ ታማ ጩዋዳን ሄ ቢታፐ ደንድያዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ጾሳይ ሄ ዛንጋራ ካታማቱዋ ꬋይሴዳ ዎደ፥ አብራሃማ ሀሳዬዳ፤ ሎጸ ደኤዳ ካታማቱዋ ꬋይሲደ ሎጻ ባሻፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ሎጸ ዞኣራን ኡታናዉ ያዬዳ ድራዉ፥ ባረ ማጫ ናና ላኡዋና ደርያ ከሴዳ፤ ጎንጎሎ ግዶን ባረ ላኡ ማጫ ናናቱዋና ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","እት ጋላስ ባይራ ናታ ቴፋቶ፥ “ኑ አዉ ጭሜዳ፤ ሳኣ ኡባን ደእያ ዎጋዳን ኑናና ግሳናዉ ሀ ጋድያን ኡባካ አቱማ አሳይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ሃያ፤ ዎይንያ ኤሳ ኑ አዉዋ ኡሺደ፥ አናና ግሲደ፥ ኑ አዉዋፐ ኑ ዛርያ ቱራ አሾይተ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ሄ ጋላሳ ቃማ ባረንቱ አዉዋ ዎይንያ ኤሳ ኡሼድኖ፤ ባይራታ ገላደ አናና ግሳዱ፤ እዛ አናና ግስያ ዎደካ ደንድያ ዎደካ እ ኤርቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ዎንተꬃ ጋላስ ባይራታ ቴፋቶ፥ “ስሳ፤ ዝኖ ታን ታ አቡና ግሳድ፤ ሀቼ ቃማ ቃይ ዎይንያ ኤሳ ኡሽና፥ ኔንካ ገላደ አናና ግሳ፤ ያቲደ ኑን ኑ አዉዋፐ ኑ ዛርያ ቱራ አሾይተ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ሄ ጋላስ ቃማ ቃይካ ዎይንያ ኤሳ ኡሼድኖ፤ ቴፋታካ ገላደ አናና ግሳዱ፤ እዛ አናና ግስያ ዎደካ ደንድያ ዎደካ እ ኤርቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ያትደ ሎጸ ማጫ ናናይ ላአቱካ ባረንቱ አዉዋፐ ሻሃሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ባይራታ አቱማ ናኣ የላዱ፤ አ ሱንꬃ ሞኣባ ጋደ ሱንꬃዱ፤ እነ ሀቼ ጋካናዉ ሞኣባቱዋ አዉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ቃይ ቴፋታካ አቱማ ናኣ የላዱ፤ አ ሱንꬃ በንኣማ ጋደ ሱንꬃዱ፤ እነ ሀቼ ጋካናዉ አሞናቱዋ አዉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","አብራሃመ ማምረፐ ደንዲደ፥ ነጌባ ግያ ጋድያ ቤዳ፤ ቃዴሳነ ሹራ ግያ ካታማቱዋፐ ግዱዋን ደኤዳ፤ ጋራራንካ አማሬዳ ዎድያ ታኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ያን አብራሃመ ባረ ማቻቶ ሳሮ፥ “አ ታ ምቻቶ” ያጌዳ። ጋራራ ካቲ አብመሌክ ኪቲደ ሳሮ አፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ሽን ጾሳይ እት ቃማን አኩሙዋን አብመሌከኮ ዪደ፥ አ ሀዋዳን ያጌዳ፤ “ኔን አሄዳ ማቻት ጋሱዋን ሀይቃሳ፤ አያዉ ጎፐ፥ እዛ አሳ ማቻቶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ሽን አብመሌክ ኢኮ ሺቅቤና። ያቴዳዌ፥ “ጎዳዉ፥ ኔን ጽሎ ካዉተꬃ ꬋይሳኒየ? ");
INSERT INTO dwrENT_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","እ፥ ‘እዛ ታ ምቻቶ’ ግቤነየ? ቃይ እዛ፥ ‘እ ታ እሻ’ ጋበይኬ? ታን ታ ዎዛና ሱረተꬃንነ ታ ኩሽያ ጌሻተꬃን ሀዋ ኦꬃድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ሄዋፐ ጉየ፥ ጾሳይ አኩሙዋን አ ያጌዳ፤ “ኤ፥ ኔን ነ ዎዛና ጌሻተꬃን ኦꬄዳዋ ታን ኤራድ፤ ሄዋ ድራዉ፥ ኔን እዞ ቦቼና ማላነ ታ ስንꬃን ናጋራ ኦና ማላ ኔና ታን ተኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ሀእ ሀ ብታንያ ማቻቶ ዛራ፤ አያዉ ጎፐ፥ እ ትምቢትያ ኦድያዋ፤ እ ነዉ ጾሳ ዎሳና፤ ኔን ፓጻ ደአና። ሽን እዞ ዛራና ꬋዮፐ፥ ኔንነ ነዉ ደእያባይ ኡባይ ሀይቂያዋ ቱሙፐ ኤራ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","አብመሌክ ዎንተꬃ ጋላስ ዎንታ ባረ ካዉተꬃ ካፓቱዋ ኡባ ጼሴዳ፤ ሀ የዉዋ ኡባ ኡንቱንቶ ኦድና፥ ኡንቱንቱ ሎይꬅ ዳሮ ያዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ያትና አብመሌክ አብራሃማ ጼሲደ፥ “ኔን አያ ኑ ቦላ ኦꬃዲ? ኔን ታ ቦላነ ታ ካዉተꬃ ቦላ ዎልቃማ ናጋራ አሀናዉ ታን ነዉ አይ ኢታባ ኦꬃድታ? ኔን ታ ቦላ ኦሰታናዉ በሰናባ ኦꬃዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ቃይካ አብመሌክ አብራሃማ፥ “ኔና ሀዋ ኦስሴዳዌ አዬ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","አብራሃመ ያጌዳ፤ “ ‘ጾሳዉ ያይያ እት አሳይነ ሀ ሳኣን ባዋ’ ጋደ ቆፔዳ ድራሳነ፥ ‘ታ ማቻት ጋሱዋን ኡንቱንቱ ታና ዎꬋና’ ጋደ ቆፔዳ ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ሄዋ ቦላ እዛ ቱሙካ ታ ምቻቶ፤ ታ አት ናቶ ግዱኩፐ አትን፥ ታ አቡ ናቶ፤ ቃይ እዛ ታ ማቻቶ ግዳዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ጾሳይ ታና ታ አዉዋ ጎልያፐ ከሴዳ ዎደ ታን እዝዉ፥ ‘ኑን ቤዳ ጋድያን ኡባን ኔን ታዉ ኦꬃና ኬካተꬃይ ሀዋ፤ “እ ታ እሻ” ጋደ ታባ ሃሳያ’ ያጋድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ሄዋፐ ጉየ አብመሌክ ዶርሳ፥ መህያ፥ ማጫ አይለቱዋነ አቱማ አይለቱዋ አሂደ፥ አብራሃመዉ እሜዳ፤ ቃይ አ ማቻቶ ሳሮ አዉ ዛሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","አብመሌክ፥ “ስም ታ ቢታይ ነ ስንꬃና፤ ኔና ሎኦሳን ደአ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ሳሮካ፥ “ታን ነ እሻዉ እት ሻአ ጻጋራ ብራ እማይ፤ ሀዌ ስም ኔናና ደእያ ኡባ ስንꬃን ኔን ጽላቶ ግድያዋነ ኔን ሻትሜዳዋ ኤርስያዋ ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","መꬍና ጎዳይ አብራሃመ ማቻት ሳር ጋሱዋን አብመሌካ ጎለ አሳ ኡባ ቃንꬃ ማይንስ ዎꬄዳ ድራዉ፥ አብራሃመ ጾሳ ዎስና፥ አብመሌክ፥ አ ማቻታነ አ ማጫ ቆማቱዋ ናኣ የላና ማላ ጾሳይ ኡንቱንታ ፓꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ጾሳይ ባረ ኦዴዳዋዳን ሳርኮ ዬዳ፤ ጾሳይ ሳሮ ባረ ጌዳዋዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ሳራ ሻሃራደ፥ ጭሜዳ አብራሃመዉ ጾሳይ ጌዳ ዎዲ ጋክና፥ አቱማ ናኣ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ሳራ አዉ የሌዳ ባረ ናኣ ሱንꬃ አብራሃመ “ይሳቃ” ያጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","አብራሃመ ባረ ናኣ ይሳቃ ጾሳይ አዛዜዳዋዳን ሆስፑንꬃ ጋላሳን ቃጻሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","አ ናኣ ይሳቅ አዉ የለቴዳ ዎደ፥ አብራሃመ ላይꬃይ ጼታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ሳራ፥ “ጾሳይ ታዉ ሚቻ እሜዳ፤ ቃይ ሀዋ ስስያዌ ኡባይ ታናና ሚጫና” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ቃይካ ሳራ፥ “አብራሃመዉ ሳራ ናኣ ꬋንꬃና ጌዳዌ ኦኔ? ግዶፐነ ታን ሀእ አዉ እ ጭሜዳ ዎድያን ናኣ የላድ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ጉꬃ ናአይ ድጪደ፤ ꬋንꬃ ዱꬄዳ፤ አብራሃመ ይሳቅ ꬋንꬃ ዱꬄዳ ጋላስ ዎልቃማ ባላ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ሽን ግብጼፐ ዬዳ አጋራ አብራሃመዉ የሌዳ ናአይ ይሳቃና ካእያዋ ሳራ በኣዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","አብራሃማ፥ “ሀ አይላት ናአይ ታ ናኣ ይሳቃና ኡባካ ላተና ድራዉ፥ አይላቶነ እዝ ናኣ ከሳ የዳ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ሀ የዉ ባረ ናኣ ቦችያ ድራዉ፥ አብራሃመ ሎይꬅ መቶቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ሽን ጾሳይ አብራሃመ፥ “ናአዉነ ነ አይላትዉ ሎይꬃ መቶቶፓ፤ ሳራ ነዉ ኦድያዋ ኡባ ስሳ፤ አያዉ ጎፐ፥ ነ ዘረꬃይ ይሳቃ ባጋና ጼሰታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ቃይ አይላት ናኣ ታን ካዉተꬃ ከሳና፤ አያዉ ጎፐ፥ እካ ነ ዛረ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ዎንታ ጉራን አብራሃመ ደንዴዳ፤ ቁማነ ኦጎሩዋን ሃꬃ አኪደ፥ አጋሮ ሀሽያን ቶሲደ፥ እዝ ናኣካ እዝዉ እሚደ ከስ የዴዳ። እዛ ባደ፥ በርሳበሄ ግያ ዎራን ቶይላካታዉ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","ሃꬃይካ ኦጎሩዋን ዉሬዳ ዎደ እዛ፥ “ናአይ ሀይቂሽን፥ ኡታደ በእከ” ያጋደ፥ ናኣ እት ቡራ ጋርሳን ዎꬃደ፥ ላኡ ጼቱ ዋꬋ ግድያዋ ኬሻ ባደ ኡታዱ። ማታን ኡታደ፥ ባረ ቃላ ꬎቂሳደ ዬካዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ጾሳይ ናኣ ዋሱዋ ስሴዳ፤ ጾሳ ኪታንቻይ አጋሮ ሳሉዋፐ ጼሲደ፥ “አጋሬ፥ ዋናዲ? ጾሳይ ናአይ ግሴዳ ሳኣን ዋስያዋ ስሴዳ ድራዉ ያዮፓ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ደንዳ ኤቃ፤ ናኣነ ነ ኩሽያን ደንꬃ፤ አያዉ ጎፐ፥ ታን አ ዎልቃማ ካዉተꬃ ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ጾሳይ እዝ አይፍያ ዶይና፥ ሃꬃ ኦላ በኣዱ፤ ባደ ኦጎሩዋን ሃꬃ ኩንꬃዱ፤ ናኣካ ኡሻዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ናአይ ድጭያ ዎደ፥ ጾሳይ አናና ግዴዳ፤ እ ዎራን ደኢደ፥ ዎንዳፍያ ዱክያ አሳ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","እ ፓራና ግያ ዎራን ደእሽን፥ አ ዳያ ግብጼፐ አዉ ማቻቶ ደማዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ሄ ዎደ፥ አብመሌክ ባረ ዎታዳራቱዋ ካፑዋ ፕኮላና አብራሃመኮ ቢደ፥ “ኔን ኦꬅያ ኡባባን ጾሳይ ኔናና ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ኔን ታ ቦላ ዎይ ታ ናና ቦላ ዎይ ታ ዘረꬃ ቦላ ገነባ ኦና ማላ፥ ሀእ ሀዋን፥ ጾሳ ስንꬃን ታዉ ጫቃ፤ ታን ነዉ ኬኬዳዋዳን፥ ኔንካ ታዉነ ኔን እማꬃተꬃን ደእያ ሀ ቢታዉ ሎአ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","አብራሃመ፥ “ታን ጫቃይ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ሄ ዎደ፥ አብራሃመ አብመሌካ ቆማቱ አኬዳ ሃꬃ ኦላባ አብመሌካዉ ማጋኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ሽን አብመሌክ፥ “ሄዋ ኦን ኦꬄደንቶ ታን ኤርከ፤ ኔንካ ቃይ ታዉ ኦዳባካ፤ ታን ሀቼ ጋካናዉ ሄዋ ስሳበይከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ሄዋፐ ጉየ አብራሃመ ዶርሳነ ሚዛቱዋ አሂደ፥ አብመሌካዉ እምና፥ ኡንቱንቱ ላኡ ጫቁዋ ጫቀቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","አብራሃመ ላፑን ማጫ ዶርሳ ማራቱዋ ዉድያፐ ሻኬዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","አብመሌክ አብራሃማ፥ “ሀ ኔን ዱማ ሻካ ዎꬄዳ ላፑን ማጫ ዶርሳ ማራቱዋ አያዉ ሻካዲ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","አብራሃመ፥ “ታን ሀ ሃꬃ ኦላ ቦኬዳዎ ማርካ ግዳና ማላ፥ ሀ ላፑን ማጫ ዶርሳ ማራቱዋ ታ ኩሽያፐ አካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ሄዋን ሄ ላኡ አሳቱ ጫቀቴዳ ድራዉ፥ ሄ ሳአይ በርሳበሄ ጌተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","በርሳበሄን ጫቁዋ ጫቀቴዳዋፐ ጉየ፥ አብመሌከነ አ ዎታዳራቱ ካፑዋ ፕኮል ደንዲደ፥ ፕልስጼማ ቢታ ስሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","አብራሃመ በርሳበሄን ታማርስከ ጌተትያ ምꬃ ቶኬዳ። ሄዋን ጎዳ፥ መꬍና ጾሳ፥ ሱንꬃ ጼሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","አብራሃመ ፕልስጼማ ጋድያን ዳሮ ዎድያ ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ሄዋፐ ስሚደ፥ ጾሳይ አብራሃማ ፓጬዳ፤ እ አ፥ “አብራሃሜ” ያጊደ ጼሴዳ። እ፥ “አቤ” ያጊደ ኮዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ጾሳይ፥ “ኔን ሲቅያ ነ መጽ እት ናኣ ይሳቃ አካደ፥ ሞርያ ግያ ጋድያ ባ፤ ያን ታን ነዉ ኦድያ እት ደርያ ቦላን አ ጹግያ ያርሹዋ ኦꬃደ ታዉ ያርሻ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ዎንተꬃ ጋላስ አብራሃመ ጉራን ደንዲደ፥ ባረ ሀርያ ጫኔዳ፤ ባረ ቆማቱዋፐ ላኡዋነ ባረ ናኣ ይሳቃ ባረናና አኪደ፥ ጹግያ ያርሹዋ ምꬃ ጳልቂ አኪደ፥ ጾሳይ አዉ ኦዴዳ ሳኣ ባናዉ ደንዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ቢደ ሄዘንꬃ ጋላስ አብራሃመ ꬎቁ ጊደ፥ ሄ ሳኣ ሃኩዋን በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","አብራሃመ ባረ ቆማቱዋ፥ “ሀ ሀርያና ሀዋን ደእሽተ፤ ታንነ ታ ናአይ ያ ቢደ ጾሳዉ ጎይኒደ፥ ህንተንቱኮ ስማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","አብራሃመ ያርሹዋ ምꬃ ደንꬂደ፥ ባረ ናኣ ይሳቃ ቶሴዳ፤ ታማነ ማሻ እ ባረዉ ኦይቄዳ። ኡንቱንቱ ላኡ እትፐ ቢሽን፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ይሳቅ ባረ አዉዋ አብራሃማ፥ “ታ አዎ” ያጌዳ። አብራሃመ፥ “አቤ፥ ታ ናአዉ” ያጌዳ። እ፥ “ታማይነ ምꬃይ ሀዌሽ፤ ሽን ጹጊደ ያርሽያ ዶርሳ ማራይ ሀቃኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","አብራሃመ፥ “ታ ናአዉ፥ ጹጊደ ያርሽያ ዶርሳ ማራ ጾሳይ ጊግሳና” ያጌዳ። ኡንቱንቱ ላኡ እትፐ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ኡንቱንቱ ጾሳይ አዉ ኦዴዳ ሳኣ ጋኬዳ ዎደ፥ አብራሃመ ያርሹዋ ያርሽያ ሳኣ ያን ግምቢደ፥ ምꬃ ማር የጌዳ፤ ባረ ናኣ ይሳቃ ቃቺደ፥ ሄ ምꬃ ቦላን ግስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","አብራሃመ ባረ ናኣ ሹካናዉ ባረ ኩሽያ የዲደ ማሻ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ሽን መꬍና ጎዳ ኪታንቻይ ሳሉዋፐ አ፥ “አብራሃሜ፥ አብራሃሜ” ያጊደ ጼሴዳ። እ፥ “አቤ” ጊደ ኮዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","አ፥ “ናኣ ቦላን ነ ኩሽያ ዎꬆፓ፤ አ አይነ ኦꬆፓ፤ ኔን ነ መጽ እት ናኣካ ታና ድጋቤና ድራዉ፥ ኔን ጾሳዉ ያይያዋ ግድያዋ ታን ሀእ ኤራይ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","አብራሃመ ꬎቁ ግ ጼሊደ፥ ሄዋን ዶርሳ እቱ ካጪ ቡራን ገል ቃጸት ኡቴዳዋ በኤዳ። አብራሃመ ቢደ ሄ ዶርሳ አኪደ፥ ባረ ናኣ ድራዉ ጹግያ ያርሹዋ ኦꬂደ ያርሽ ባሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ሄዋ ድራዉ አብራሃመ፥ “መꬍና ጎዳይ እማና” ያጊደ ሄ ሳኣ ሱንꬄዳ፤ ሀቼ ጋካናስካ፥ “መꬍና ጎዳ ደርያን እመታና” ጌተቴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","መꬍና ጎዳ ኪታንቻይ ሳሉዋፐ ላኤንꬂደ አብራሃማ ጼሲደ ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“መꬍና ጎዳይ፥ ‘ሀዋዳን ያጋደ ነዉ ታን ታ ሁጲያን ጫቃይ፤ ኔን ሀዋ ኦꬄዳ ድራዉነ ነ መጽ እት ናኣካ ታና ድጋቤና ድራዉ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ታን ኔና ቱሙ አንጃና፤ ነ ዘረꬃካ ታን ሳሉዋ ጾልንትያ ኬናነ አባ ዶና ሻፍያ ኬና ኦꬃደ ጮርሳና። ነ ዘረꬃቱ ባረንቱ ሞርከቱዋ ካታማቱዋ ላታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ኔን ታዉ አዛዘቴዳ ድራዉ፥ ሀ ሳኣ ካዉተꬃቱ ኡባይ ነ ዘረꬃ ባጋና አንጀታና’ ያጌ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ሄዋፐ ጉየ፥ አብራሃመ ባረ ቆማቱዋኮ ስሚደ፥ ኡንቱንቱ ኡባይ እትፐ በርሳበሄ ደንዲደ ቤድኖ። አብራሃመ በርሳበሄን ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ሄዋፐ ስሚደ አብራሃመዉ፥ “ምልካ ነ እሻ ናኮራዉ ናና የላዱ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ኡንቱንቱነ ባይራይ ኡጻ፤ ኡጻ እሻቱ ቡዛ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","አራማ አዉዋ ቃሙኤላ፥ ኬሳደ፥ ሃዞ፥ ፕልዳሻ፥ ይድላፋነ ባቱኤላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ሀዋንታ ሀ ሆስፑን ናናካ ምልካ አብራሃመ እሻ ናኮራዉ የላዱ፤ ባቱኤል ርብቆ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ራኡማ ግያ አ ቆማታ ቃይ ጸባሀ፥ ጋሃማ፥ ታሃሻነ ማእካ የላዱ” ያጊደ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ሳራ ጼታነ ላታማነ ላፑን ላይꬃ ደኣዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ሄዋፐ ጉየ እዛ ካናነ ጋድያን ደእያ (ከብሮነ ግያ) ቅርያት-አርባአ ካታማን ሀይቃዱ። አብራሃመ ሳርዉ ዬካናዉነ ካዮታናዉ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ዬክ ስሚደ፥ አብራሃመ ባረ ማቻት አሃ ማታፐ ደንድ ቢደ፥ ሂተቱዋ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ታን ህንተንቱ ግዶን በተነ እማꬃ፤ ታ ማቻት አሃ ሞጋናዉ ታዉ ህንተንቱ ጋድያፐ ዱፉዋ ዛልኤርክቴ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","ሂተቱ አዉ፥ “ጎዳዉ፥ ኑን ኦድያዋ ስሳ፤ ኔን ኑ ግዶን ዎልቃማ ካፑዋ፤ ኔን ነ ማቻት አሃ ኑ ዱፉዋፐ ነዉ ሎኤዳዋን ሞጋ፤ ኔን ነ ማቻት አሃ ሞጋናዉ ባረ ዱፉዋ ኦንነ ኔና ድገና” ያግ ዛሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ያግና አብራሃመ ደንድ ኤቂደ፥ ሂተቱዋ ስንꬃን ጎይኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","እ ኡንቱንቶ፥ “ህንተንቱ ታና፥ ‘ነ ማቻት አሃ ሞጋ’ ጎፐ ስስተ፤ ጾሃራ ናኣ ኤፍሮናዉ አ ጋድያ ጋጻን ደእያ ማክጴላ ግያ ጎንጎሉዋ ታዉ ዱፉዋ ከሳናዉ ዛልአና ማላ ኩመንꬃ ጋትያን ኑና ዛልእሴርክተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ሂትያ ኤፍሮነ ሄ ዎደ ካታማ ፐንግያን ሺቄዳ ባረ አሳ ግዶን ኡቴዳ፤ ሂተቱ ኡባይ ስስሽን፥ አብራሃመዉ ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ሄዋዳን ግደና፤ ታ ጎዳዉ፥ ታ ኦድያዋ ስሳ፤ ታን ጋድያካ አ ግዶን ደእያ ጎንጎሉዋካ ነዉ እማይ፤ ታን ነዉ አ ታ አሳ ስንꬃን እማይ፤ ኔን ነ ማቻት አሃ ሞጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","አብራሃመ ሄ ጋደ አሳ ስንꬃን ዛረꬅ ጎይኔዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","አሳይ ስስሽን ኤፍሮና፥ “ታ ኦድያዋ ስሳርኪ! ታን ሄ ጋድያ ጋትያ ጭጋና፤ ኔን ታፐ አካርኪ! ሄዋን ታን ታ ማቻት አሃ ሞጋና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","ኤፍሮነ አብራሃመዉ ዛሪደ፥ “ታ ጎዳዉ፥ ታን ኦድያዋ ስሳ፤ ጋዲ ኦይዱ ጼቱ ጻጋራ ብራ ከስያዋ፤ ሽን ሄዌ ነ ግዶንነ ታ ግዶን አይነ ግደና፤ ነ ማቻት አሃ ሞጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","አብራሃመ ሂተቱ ስስሽን፥ ኤፍሮነ ጌዳ ጋትያ ማዬዳ፤ ሄ ዎደ ሻሉዋን ኦይዱ ጼቱ ጻጋራ ብራ ኤፍሮናዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ማምረ ካታማ ማታን ማክጴላን ደእያ ኤፍሮና ጋዲ፥ ሄዋን ደእያ ጎንጎሉነ ሄ ጋድያን ደእያ ምꬃ ኡባይ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ካታማ ፐንግያን ሺቄዳ ሂተቱዋ ኡባ ስንꬃን ህግያን አብራሃመ ጋደ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ሄዋፐ ጉየ፥ አብራሃመ ባረ ማቻቶ ሳሮ ካናነ ጋድያን (ከብሮነ ግያ) ማምረ ካታማ ማታን ደእያ ማክጴላ ግያ ጋደ ጎንጎሉዋን ሞጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ሄዋ ድራዉ ሄ ጋዲነ ሄዋን ደእያ ጎንጎሉ ሂተቱዋ ስንꬃን ህግያን አብራሃመዉ ዱፉዋ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","አብራሃመ ሎይꬅ ላይꬃ ሱጊደ ጭሜዳ፤ መꬍና ጎዳይ አ ኡባባንካ አንጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","አብራሃመ ባረ ቆማ፥ ባረ ሶ አሳ ኡባዉ ካፖትያ፥ ባረ አሳ ኡባዉ ጎዳትያዋ ሀዋዳን ያጌዳ፤ “ነ ኩሽያን ታ ጉልባታ ኦይቃ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ታን ኡንቱንቱ ግዶን ደእያ ካናነቱዋ ማጫ ናናቱዋፐ ታ ናአዉ ማቻቶ ኦቼና ማላ፥ መꬍና ጎዳን፥ ሳሉዋ ጾሳንነ ሳኣ ጾሳን ታን ኔና ጫቀꬃይ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ሽን ኔን ታ የለቴዳ ቢታ፥ ታ ዳቦቱዋኮ ባደ፥ ታ ናኣ ይሳቃዉ ማቻቶ ኦቻ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","አ ቆማይ፥ “ማጫውና ታናና ያናዉ ዶሰናባ ግዶፐ፥ ነ ናኣ ኔን ዬዳ ጋድያ ጉየ አፎ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","አብራሃመ፥ “ታ ናኣ ያ አፈናዳን ኔና ኤራ! ");
INSERT INTO dwrENT_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","መꬍና ጎዳይ፥ ሳሉዋ ጾሳይ፥ ታና ታ አዉዋ ሶፐነ ታ የለቴዳ ቢታፐ ከሴዳዌ ታዉ፥ ‘ነ ዛርያዉ ታን ሀ ቢታ እማና’ ያጊደ ጫቄዳዌ፥ ኔን ታ ናአዉ ያፐ ማቻቶ ደማና ማላ፥ እ ባረ ኪታንቻ ኔፐ ስንꬃዉ ኪታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ምሽራታ ኔናና ጉየ ያናዉ ዶሰናባ ግዶፐ፥ ሀ ታን ኔና ጫቀꬄዳ ጫቁ ነዉ ጎመተና፤ ሽን ታ ናኣ ያ ጉየ ኡባካ አፎፓ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ቆማይ ባረ ጎዳ አብራሃመ ጉልባታ ኦይቄዳ፤ ሀ የዎ ጫቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ሄዋፐ ጉየ፥ ቆማይ ባረ ጎዳ ጋሎቱዋፐ ታሙዋ አኪደ፥ ባረ ጎዳ ሚሻፐካ ሙሩታ ሙሩታ አኪደ ቤዳ፤ ማስጰጾምያ ግያ ጋድያን ናኮራ ካታማ ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ኦማርስ፥ ማጫ አሳይ ሃꬃ ትካናዉ ይያ ዎድያን፥ ካታማፐ ጋጻን ሃꬃ ኦላ ማታን ባረ ጋሎቱዋ ጉልባትሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ያቲደ እ ሀዋዳን ያጊደ ዎሴዳ፤ “መꬍና ጎዳዉ፥ ታ ጎዳ አብራሃመ ጾሳዉ፥ ሀቼ ታን ቆፓደ ዬዳባ ታዉ እንጀያ፤ ቃይ ታ ጎዳ አብራሃመዉ ሎኦባ ኦꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","በአ! ታን ሀ ሃꬃ ፑልትያ ማታን ኤቃይ፤ ሀ ካታማ አሳ ማጫ ናናይ ሃꬃ ትካናዉ ሃ ያና። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ታን፥ ‘አነ ኦቱዋ ሆክሳደ ታና ሃꬃ ኡሻ’ ግያ ዎደ፥ እዛካ፥ ‘ሄይ ኡሻ፤ ቃይ ነ ጋሉዋ ታን ኡሻና’ ያግያና፥ ሄና ነ ቆማ ይሳቃዉ ኔን ዶሬዳኖ ግዱ፤ ኔን ታ ጎዳዉ ሎኦባ ኦꬄዳዋ ታን ሄዋን ኤራና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ብሮ እ ዎሳ ዉርሰናን ደእሽን፥ ርብቃ ሃꬃ ኦቱዋ ቶካደ ፑቱ ጋዱ። እዞ ባቱኤል የሌዳ፤ ባቱኤል ምልካ ናኣ፤ ምልካ አብራሃመ እሻ ናኮራ ማቻቶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ርብቃ ሎይꬃ ፑላንቻነ አቱማ አሳይ ቦችቤና ዎዶራቶ። ፑልቱዋ ዱገ ዎꬋደ፥ ባረ ኦቱዋ ኩንꬃደ ከሳዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ሄ ቆማይ ኢኮ ዎጽ ቢደ እዞ፥ “ነ ኦቱዋፐ ታና ጉꬃ ሃꬃ ኡሻርኪ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","እዛ፥ “ኤኖ ታ ጎዳዉ፥ ኡሽኪ” ያጋዱ። ኤሌላደ ኦቱዋ ባረ ሀሽያፐ ዎꬃደ፥ ገደ ዛራ ኦይቃደ አ ኡሻዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","አ ኡሼዳዋፐ ጉየ፥ “ነ ጋላቱዋካ አላና ጋካናዉ ታን ኡንቱንቶ ሃꬃ ዱቃና” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","አቴዳ ሃꬃ ኤሌላ ዎንግርያን ትጋደ፥ ሀራ ሃꬃ ዱቃናዉ ኦላ ዎጻዱ፤ ጋላቱ ኡባይ አላና ጋካናዉ፥ ሃꬃ ኦላፐ ዱቃ ዱቃደ አሃደ ዎንግርያን ትጋደ ኡሻዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","እ ቆፒደ ዬዳ ቆፋ መꬍና ጎዳይ እንጀዪደ ደእንቶ ኤራናዉ ብታኒ ጮኡ ጊደ እዞ ጼሌ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ጋሎቱ ሃꬃ ኡሽ ስሚና፥ ብታኒ እቼሹ ግራመነ ባካ ግዴዳ ዎርቃ ምግዱዋነ፥ ጼታነ ታሙ ግራመ ግዴዳ ላኡ ዎርቃ ሳጋየቱዋ ከሴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","እዞ፥ “ኔን ኦ ናት? አነ ታዉ ኦዳ፤ ነ አዉዋ ሶን ኑዉ አቅያ ሳአይ ደአኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","እዛ፥ “ታን ባቱኤላ ናቶ፤ ባቱኤል ምልካ ናኮራዉ የሌዳ ናኣ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ኑዋን ግድያ ዳላይነ ባሱ ደኤ፤ ቃይ ህንተንቱ አቃናዉካ ሳአይ ደኤ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ብታኒ ጉልባት መꬍና ጎዳዉ ጎይኒደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ሀዋዳን ያጌዳ፤ “ታ ጎዳዉ ኬክያዋነ አማነትያዋ አግቤና መꬍና ጎዳይ፥ ታ ጎዳ አብራሃማ ጾሳይ ጋላተቶ! ታን ዪሽን፥ መꬍና ጎዳይ ታና ታ ጎዳ ዳባቱዋ ሶይ ካለꬄዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ናታ ዎጻ ባደ፥ ባረ አት ሶን ደእያ አሳዉ ሀኔዳባ ኦዳዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ርብቅዉ ላባና ግያ እሻይ ደኤ፤ ላባን ካረ ከሲደ፥ ሃꬃ ፑልቱዋ ማታን ደእያ ብታንያኮ ዎጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ምግዱዋነ ባረ ምቻት ኩሽያን ደእያ ሳጋየቱዋ በኤዳሳና ርብቃ ብታኒ ባረና ጌዳዋ ኦድና ስሶሳና፥ ከሲደ ብታንያኮ ብ በኤዳ፤ ብታንያ ጋሎቱዋና ፑልቱዋ ማታን ኤቄዳዋ ደሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","አ፥ “መꬍና ጎዳይ ኔና አንጄዳዎ፥ ሃያ! ኔን ሀዋን ካረን አያዉ ኤቃይ? ታን ነዉ ጎልያነ ጋሎቶካ ሳኣ ጊግሳድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ብታኒ ሶ ገሌዳ፤ ላባን ጋሎቱዋ ጫና ብሌዳ፤ ዳላነ ባሱዋ ጋሎቶ የጌዳ። ገድያ ሜጫናዉ አስነ አናና ደእያ አሳቶ ሃꬃ አሄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ቁማይካ አ ስንꬃ አꬌዳ። ሽን እ፥ “ታን ታና አሄዳባ ህንተንቶ ኦደናን ደኣደ ቁማ ሚከ” ያጌዳ። ላባን፥ “ያቶፐ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ሄዋ ድራዉ እ፥ “ታን አብራሃመ ቆማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","መꬍና ጎዳይ ታ ጎዳ ሎይꬅ አንጅና፥ እ ዱረቴዳ፤ ዶርሳ፥ ሚዛ፥ ብራ፥ ዎርቃ፥ አቱማ ቆማቱዋ፥ ማጫ ቆማቱዋ፥ ጋሎቱዋነ ሀረቱዋ አዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ታ ጎዳ ማቻታ ሳራ ባረ ጪማተꬃ ላይꬃን አዉ አቱማ ናኣ የላዱ፤ እ ባረዉ ደእያዋ ኡባ አዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ታ ጎዳይ ታና ሀዋዳን ጫቂሴዳ፤ ‘ታን ደእያ ካናነ ቢታ ማጫ ናናቱዋፐ ታ ናአዉ ማቻቶ ኦቾፓ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ሽን ታ አዉዋ አሳኮ፥ ታ ዛራቱዋኮ ባደ፥ ታ ናአዉ ማቻቶ ኦቻ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ታን ታ ጎዳ፥ ‘ናታ ታናና ያናዉ ዶሰናን አጎፐ ሽን?’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","እ፥ ‘መꬍና ጎዳይ፥ ታን አ ስንꬃን ሀመቴዳዌ ኔናና ባረ ኪታንቻ ኪታና፤ ኔን ታ ናአዉ ታ አዉዋ አሳፐ፥ ታ ዛራቱዋፐ ማቻቶ ደማና ማላ፥ ነ ብያሳካ እንጀያና። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ኔን ታ ዛራቱዋኮ ቢና፥ ኡንቱንቱ ነዉ እዞ እመናን እጾፐ፥ ሄ ዎደ ነዉ ጫቁ ጎመተና’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“ታን ሀቼ ሀ ፑልቱዋኮ ዬዳ ዎደ ያጋድ፤ ‘መꬍና ጎዳዉ፥ ታ ጎዳ አብራሃመ ጾሳዉ፥ ነ ሸነ ግዶፐ፥ ታን ብያ የዉዋ እንጀያ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","በአ፤ ታን ሀ ፑልቱዋ ማታን ኤቃይ፤ ወዶራታ እትና ሃꬃ ትካናዉ ዮፐ፥ ታን እዞ፥ “ታና ነ ኦቱዋፐ ጉꬃ ሃꬃ ኡሻርኪ!” ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","እዛ ታና፥ “ኤኖ ኡሻ፤ ቃይ ነ ጋሎቶካ ታን ሃꬃ ዱቃና” ያግያና፥ መꬍና ጎዳይ ታ ጎዳ ናአዉ ዶሬዳኖ ግዱ’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“ታን ታ ዎዛናን ዎስያዋ ዉርሰናን ደእሽን፥ ርብቃ ባረ ኦቱዋ ቶካ አካደ፥ ፑቱ ጋዱ፤ ፑልቱዋ ዱገ ዎꬋደ ሃꬃ ዱቃዱ፤ ታን እዞ፥ ‘ታና ሃꬃ ኡሻርኪ’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“እዛ ኤሌላ ባረ ሀሽያፐ ኦቱዋ ዎꬃደ፥ ‘ሄኮ ኡሻ፤ ቃይ ታን ነ ጋሎቱዋ ኡሻና’ ያጋዱ። ታን ኡሻድ፤ ቃይ ታ ጋሎቱዋ እዛ ኡሻዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“ታን እዞ፥ ‘ኔን ኦ ናት?’ ያጋድ። “እዛ፥ ‘ታን ባቱኤላ ናቶ፤ ባቱኤል፥ ምልካ ናኮራዉ የሌዳ ናኣ’ ያጋዱ። “ታን እዝዉ ምግዱዋ አꬃድ፤ እዝ ኩሽያንካ ሳጋየቱዋ ዎꬃድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ሄዋፐ ጉየ ታን ጉልባታደ፥ መꬍና ጎዳዉ ጎይናድ፤ ታን መꬍና ጎዳ፥ ታ ጎዳ አብራሃመ ጾሳ፥ ታ ጎዳ እሻ ናኣ ናቶ አ ናአዉ አካናዉ ታና ልከ ኦግያ ካለꬄዳዋ ጋላታይ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ሀእካ ህንተንቱ ታ ጎዳዉ ኬካናባነ አማነታናዋ ግዶፐ፥ ታዉ ኦድተ፤ ግዳና ꬋይንቶነ ኦድተ፤ ሄዋፐ ስንꬃን ታን ሀናናዋ ኤራና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ላባንነ ባቱኤል ዛሪደ ያጌድኖ፤ “ሀ የዉ መꬍና ጎዳፐ ዬዳ፤ ኑን ነዉ ያ ሃ ጋናዉ ዳንዳዮኮ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ርብቆ ሀኖ በአ፤ አካደ ባ፤ መꬍና ጎዳይ ጌዳዋዳን ነ ጎዳ ናአዉ ማቻቶ ግዱ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","አብራሃማ ቆማይ ኡንቱንቱ ግያዋ ስሴዳ ዎደ፥ ሳኣን ጉልባቲደ መꬍና ጎዳዉ ጎይኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ቆማይ ብራ አሌቁዋነ ዎርቃ አሌቁዋ፥ ማዩዋካ ከሲደ፥ ርብቅዉ እሜዳ፤ ቃይ አልኦ ሚሻቱዋ እዝ እሻዉነ እዝ አትዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ሄዋፐ ጉየ፥ እነ አናና ደእያዋንቱ ሜድኖነ ኡሼድኖ፤ ያቲደ ያን አቄድኖ፤ ኡንቱንቱ ጉራን ደንዲደ፥ “ታና ታ ጎዳኮ የድተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","እዝ እሻይነ እዝ አታ፥ “ናታ እት ታሙ ጋላሳ ኬሻ ኑናና ታኩ፤ ሄዋፐ ጉየ እዛ ባና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ሽን እ፥ “መꬍና ጎዳይ ታን ዬዳዋ እንጀይ ድግና፥ ህንተንቱ ታና ጋምኤꬆፕተ፤ ታን ታ ጎዳኮ ባና ማላ ታና ሞይዝተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ኡንቱንቱ፥ “ናቶ ጼሲደ አነ እዞ ኦቾይተ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ርብቆ ጼሲደ፥ “ሀ ብታንያና ባኒ?” ያጊደ ኦቼድኖ። እዛ፥ “ኤ፤ ታን ባና” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ኡንቱንቱ ባረንቱ ምቻቶ ርብቆ፥ እዞ ድችያንና፥ አብራሃማ ቆማናነ አ አሳቱዋና ሞይዜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ኡንቱንቱ ርብቆ፥ “ኑ ምቻት ርብቄ፥ ሻኣፐ ሻኣ ጋካናዉ ጮራታ። ነ ዛራቱ ባረንቱ ሞርከቱዋ ካታማቱዋ ላትኖ” ያጊደ አንጄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ሄዋፐ ጉየ፥ ርብቃነ እዝ ዳንጋጽረቱ ደንዲደ፥ ጋሎቱዋ ቶጊደ፥ ብታንያና ቤድኖ። ያትና ቆማይ ርብቆ አኪደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ሄ ዎደ ይሳቅ፥ “ታና በእያ ደኡዋ ጾሳ ፑልቱዋ” ግያ ፑልቱዋ ማታ ቢደ፥ ኔጌባ ዎራን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","እት ጋላስ ኦማርስ ይሳቅ ባረ ዎዛናን ቆፒደ ደምባ ከሲደ ዩዬ፤ እ ꬎቁ ጊደ ጼልያ ዎደ፥ ጋላቱ ይያዋንታ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ርብቃካ ꬎቁ ጋደ ጼልያ ዎደ፥ ይሳቃ በኣዱ፤ ጋሉዋፐ ዎꬋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ቆማ፥ “ሀ ኑናና ጋከታናዉ ደምባና ይያ ብታኒ ኦኔ?” ያጋዱ። ቆማይ፥ “እ ታ ጎዳቴ” ያጌዳ። እዛ ባረ ሻሽያ አካደ ጉሎታዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ቃይ ቆማይ ባረ ኦꬄዳዋ ኡባ ይሳቃዉ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ይሳቅ ርብቆ ባረ አት ሳር ዱንካንያ አፌዳ። እዞ አኬዳ፤ እዛካ አዉ ማቻቶ ግዳዱ። ያትና እ እዞ ሲቄዳነ ባረ አት ሀይቁዋን ካዮትያዋፐ ምነቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ቃይ አብራሃመ ቃጹሮ ጌተትያ ሀራ ማቻቶ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","እዛ ዚምራና፥ ዮቅሻና፥ ማዳና፥ ምድያማ፥ ይሽባቃነ ሹሀ አዉ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ዮቅሻን ሳባነ ዳዳና የሌዳ። ዳዳን አሾረታ፥ ለጹሸታነ ለኣማታ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ምድያማ ናናይ አፋ፥ አፋደ፥ ሀኖካ፥ አቢዳአነ ኤልዳአ። ሀዋንቱ ኡባይካ ቃጹር ናና። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","አብራሃመ ባረዋ ኡባ ይሳቃ ላትሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ሽን እ ብሮ ፓጻ ደኢደ፥ ባረ ሀራ ማቻቱዋፐ የሌዳ ናናቶ ባረዉ ደእያዋፐ ዎይቴዳ። ባረ ናኣ ይሳቃፐ ኡንቱንታ ሻክ፥ አዋይ ዶልያ ባጋ ቢታዉ የዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","አብራሃመ ሙለ እት ጼታነ ላፑን ታማነ እቼሹ ላይꬃ ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","አብራሃመ ዳሮ ዎድያ ደኢደ፥ ሎኦ ጭሚደ ሀይቄዳ፤ ባረ ማይዛቱዋና ጋከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","አ ናናይ ይሳቅነ እስማኤል አ ማክጴላ ግያ ጎንጎሎ ዱፉዋን ሞጌድኖ፤ ሄ ጎንጎሉ ማምረ ማታን፥ ሂትያ ጾሃራ ናኣ ኤፍሮና ጋድያን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ሄዌነ አብራሃመ ሂተቱዋፐ ሻሜዳ ጋድያ። አብራሃመ ባረ ማቻታ ሳራ ሞገቴዳ ሳኣን ሞገቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","አብራሃመ ሀይቄዳዋፐ ጉየ፥ ጾሳይ አ ናኣ ይሳቃ አንጄዳ። ሄ ዎደ ይሳቅ፥ “ታና በእያ ደኡዋ ጾሳ ፑልቱዋ” ግያ ፑልቱዋ ማታን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ሳር አይላታ፥ ግብጼፐ ዬዳ አጋራ፥ አብራሃመዉ የሌዳ ናኣ እስማኤላ የለታይ ሀዋፐ ካሊደ ጻፈቴዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","እስማኤላ ናናይ ባረንቱ ሱንꬃንነ ባረንቱ የለታ ማራን ሀዋንታ፤ ሄዋንቱነ: ናባዮታ፥ ቄዳራ፥ አድብኤላ፥ ምብሳማ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ምሽማአ፥ ዱማ፥ ማሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ሀዳዳ፥ ቴማ፥ ይጹራ፥ ናፊሻነ ቄድማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","እስማኤላ ናናይ ሀዋንታ፤ ኡንቱንቱ ሱንꬃይ ኡንቱንቱ ሞꬃንነ ደእያ ሳኣን ሀዋ። ኡንቱንቱ ባረንቱ ያራን ታማነ ላኡ ካፓቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","እስማኤል ሙለ ጼታነ ሀታማነ ላፑን ላይꬃ ደኢደ፥ ሀይቄዳ፤ ባረ ማይዛቱዋና ጋከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","እስማኤላ ዛራቱ ግብጼፐ አዋይ ዶልያ ባጋን ደእያ ሀዊላፐነ ሹራፐ ግዱዋን፥ አሶራ አፍያ ኦግያ ማታን ደኤድኖ። ኡንቱንቱ ባረንቱ እሻቱዋ ኡባና ሞርክያን ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","አብራሃማ ናኣ ይሳቃ የለታይ ሀዋፐ ካሊደ ጻፈቴዳዋ። አብራሃመ ይሳቃ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ይሳቃዉ ላይꬃይ ኦይታሙዋ ግዴዳ ዎደ፥ ርብቆ አኬዳ፤ እዛ ማስጰጾምያን ደእያ ሶርያ ባቱኤላ ናትዉነ ሶርያ ላባና ምቻቶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ይሳቅ ባረ ማቻታ ማንꬃቶ ግዴዳ ድራዉ፥ እዝዉ መꬍና ጎዳ ዎሴዳ፤ መꬍና ጎዳይ አ ዎሳ ስሴዳ። ያትና አ ማቻታ ርብቃ ሻሃራዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ሽን እዝ ኡሎ ግዶን ደእያ ናናይ ማንተ ግድ ኡቲደ፥ እቱ እቱዋና ሱገቴድኖ፤ ያትና እዛ፥ “ሀዌ ታዉ አያዉ ሀኒ?” ያጋዱ። ሄዋ ድራዉ መꬍና ጎዳ ኦቻናዉ ባዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","መꬍና ጎዳይ እዝዉ፥ “ነ ኡሉዋን ላኡ ካዉተꬃይ ደኤ፤ ቃይ ነ ግዱዋን ደእያ ላኡ ጋደ አሳቱ እቱ እቱዋፐ ሻከታና፤ እት ጋደ አሳቱ ህንኮቱዋፐ ምናና፤ ቃይ ባይራይ ቴፋዉ አዛዘታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","እዛ የልያ ዎዲ ጋክና፥ እዝ ኡሉዋን ማንተ አቱማ ናናይ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ኮይሮ የለቴዳዌ አርሳ፤ አ ቦላ ኡባ እስኪ ማዬዳ፤ ሄዋ ድራዉ ኡንቱንቱ አ ኤሳዉ ጊደ ሱንꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ሄዋፐ ጉየ፥ አ እሻይ የለቴዳ፤ እ ባረ ኩሽያን ኤሳዉ ግንድያ ኦይቂ ኡቴዳ፤ ሄዋ ድራዉ አ ያቆባ ጊደ ሱንꬄድኖ። ርብቃ ኡንቱንታ የሌዳ ዎደ፥ ይሳቃዉ ኡሱፑን ታሙ ላይꬃ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ናናይ ድጬድኖ፤ ኤሳይ ሻንካ ሂላ ኤርያ ባዙዋ አሳ ግዴዳ፤ ሽን ያቆብ ዱንካንያን ደእያ ዎፓ አሳ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ይሳቅ ኤሳ ሲቄዳ፤ አያዉ ጎፐ፥ እ ሻንካቴዳባፐ ማናዉ ዶሴዳ፤ ሽን ርብቃ ያቆባ ሲቃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","እት ገደ ያቆብ ዎጽያ ካꬅሽን፥ ኤሳይ ኮሻይ ዎꬌዳዌ፥ ዎራፐ ዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ኤሳይ ያቆባ፥ “ታና ሀ ዞኦ ዎጽያፐ ምዛ፤ ታና ኮሻይ ዎꬌዳ” ያጌዳ። (ሄዋ ድራዉ ቃይ አ ሱንꬃይ ኤዶማ ጌተቴዳ)። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ያቆብ አ፥ “ኮይሮ ታዉ ነ ባይራተꬃ ዛልአ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ኤሳይ፥ “በአ! ታን ሀይቃና ሀናይ፤ ሀ ባይራተꬃይ ታዉ አያ ጎእ ደኢ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ያቆብ ዛሪደ፥ “አነ ታዉ ኮይሮ ኔን ጫቃ” ያጌዳ። እ ጫቄዳ፤ ባረ ባይራተꬃ ያቆባዉ ዛልኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ያቆብ ኤሳዉ ሶሉዋነ ምስርያ ዎጽያ እሜዳ፤ እ ሜዳነ ኡሼዳ፤ ሄዋፐ ጉየ ደንዲደ ቤዳ። ኤሳይ ባረ ባይራተꬃ ሀዋዳን ካꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ሄ ጋድያን ካሰ አብራሃመ ዎድያን ደእያ ኮሻ ቦላ ሀራ ኮሻይ ደንዴዳ፤ ያትና ይሳቅ ፕልስጼማ ካትያ አብመሌከኮ ጋራራ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","መꬍና ጎዳይ ይሳቃዉ ቆንጪደ ሀዋዳን ያጌዳ፤ “ግብጼ ጋድያ ዱገ ቦፓ፤ ታን ነዉ ኦዴዳ ጋድያን ደአ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ሀ ጋድያን አማሬዳዋ ታካሻ፤ ታን ኔናና ግዳና፤ ኔና አንጃና፤ አያዉ ጎፐ፥ ሀ ቢታ ኡባ ታን ነዉነ ነ ዘረꬃዉ እማና፤ ታን ነ አዉዋ አብራሃመዉ ጫቄዳ ጫቁዋ ምንሳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ነ ዘረꬃ ሳሉዋ ጾልንትያዳን ዳርሳና፤ ሀ ቢታ ኡባ ታን ኡንቱንቶ እማና፤ ሳኣ ካዉተꬃ ኡባይ ነ ዘረꬃ ባጋና አንጀታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","አያዉ ጎፐ፥ አብራሃመ ታ ቃላ ስሴዳ፤ ታ ፕርዳቱዋነ ታ አዛዙዋ፥ ታ አዋዮቱዋነ ታ ህግያ ናጌዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ሄዋ ድራዉ ይሳቅ ጋራራን ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ሄ ቢታ አሳይ ርብቅባ ደንꬂደ ይሳቃ፥ “ሀና ነዉ አዬ?” ያጊደ ኦቼዳ። እ፥ “ሀና ታዉ ምቻቶ” ያጌዳ። አያዉ ጎፐ፥ እ ርብቃ ዳሮ ፑላንቻ ግድያ ድራዉ፥ “ታን፥ ‘እዛ ታ ማቻቶ ጎፐ’፥ ሀ ጋደ አሳይ እዝ ጋሱዋን ታና ዎꬋነንቶነ” ያግ ቆፒደ ያዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ይሳቅ ሄዋን ዳሮ ዎድያ ደኦዋፐ ጉየ፥ ፕልስጼማ ካቲ አብመሌክ ማስኮትያና ዱገ ጼሊደ፥ ይሳቅ ባረ ማቻት ርብቅና ጋከትሽን በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ሄዋ ድራዉ አብመሌክ ይሳቃ ጼሲደ፥ “ሄኮ እዛ ቱሙ ነ ማቻቶ! ኔን አያዉ፥ ‘እዛ ታ ምቻቶ’ ጋዲ?” ያጊደ ኦቼዳ። ይሳቅ፥ “ ‘እዛ ታ ማቻቶ ጎፐ’፥ እዝ ጋሱዋን አሳይ ታና ዎꬋና ጋደ ጋድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","አብመሌክ፥ “ሀዌ ኔን ኑ ቦላን ኦꬄዳባይ አዬ? ታ አሳፐ እት አሳይ ነ ማቻትና ግስ ድጌዳሽን፤ ኔን ኑ ቦላን ጎምያ አሃዳሽን” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ሄዋ ድራዉ አብመሌክ ባረ አሳ ኡባ፥ “ሀ ብታንያ ዎይ አ ማቻቶ ቦችያ ኦንነ ቱሙ ሀይቃና” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ይሳቅ ሄ ጋድያን ካꬃ ዘሪደ፥ ሄ ላይꬃን ጼቱ ኩሽያ ጫኬዳ፤ አያዉ ጎፐ፥ መꬍና ጎዳይ አ አንጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","እ ዱረቴዳ፤ ዱረታ ቦላ ዱረታይ አዉ ዳር ዳር ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ይሳቃዉ ዶርሳ ዉዲ፥ ሚዛ ዉዲነ ቆማቱ ሎይꬅ ዳሬዳ ድራዉ፥ ፕልስጼማ አሳቱ አ ቃናቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ሄዋ ድራዉ፥ አ አዉዋ አብራሃመ ዎድያን፥ አ አዉዋ ቆማቱ ቦኬዳ ሃꬃ ኦላ ኡባ ፕልስጼማ አሳቱዋ ቢታ ዛሪደ ባሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ሄ ዎደ አብመሌክ ይሳቃ፥ “ኑፐ ሻከታደ ባ፤ ኔን ኑፐ አꬋ ምናዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ይሳቅ ሄዋፐ ደንዲደ፥ ጋራራ ዎምባ ቢደ ያን ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ይሳቅ ባረ አዉዋ አብራሃመ ዎድያን ቦከቴዳ ሃꬃ ኦላቱዋ፥ አብራሃመ ሀይቄዳዋፐ ጉየ፥ ፕልስጼማ አሳቱ ባሬዳዋንታ ዛር ቦክ ከሲደ፥ አ አዉ ሱንꬄዳ ሱንꬃን ኡንቱንታ ጼሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ይሳቃ ቆማቱ ዎምባን ቦኪደ፥ ፑልትያ ሃꬃ ኦላ ያን ደሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ሽን ጋራራ ሄንꬃንቻቱ ይሳቃ ሄንꬃንቻቱዋና፥ “ሃꬃይ ኑዋ” ያጊደ ዋላቀቴድኖ። ኡንቱንቱ አናና ፓሉመቴዳ ድራዉ፥ ይሳቅ ሄ ሃꬃ ኦላ፥ “ፓሉምያ” ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ሄዋፐ ጉየ፥ ኡንቱንቱ ሀራ ሃꬃ ኦላካ ቦኬድኖ፤ ሽን ኡንቱንቱ ሄ ሃꬃ ኦላ ጌዱዋን ዋላቀቴድኖ፤ ሄዋ ድራዉ እ ሄ ሃꬃ ኦላ “ሞርከቲታ” ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ሄዋፐ ጉꬃ ዛርዳኢደ፥ ሀራ ሃꬃ ኦላ ቦክሴዳ፤ አ ጋሱዋን ኦንነ ዋላቀትቤና፤ “ጾሳይ ሀእ ኑዉ አሴዳ፤ ኑን ሀ ጋድያን ጮራና” ጊደ አ፥ “አኮ ሳኣ” ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ሄዋፐ ደንዲደ፥ ፑደ በርሳበሄ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ሄ ቤዳ ጋላስ ቃማ መꬍና ጎዳይ አዉ ቆንጪደ አ፥ “ታን ነ አዉዋ አብራሃመ ጾሳ፤ ታን ኔናና ደእያ ድራዉ፥ ኔን ያዮፓ፤ ታን ኔና አንጃና፤ ታ ቆማ አብራሃመ ድራዉ ነ ዘረꬃ ታን ጮርሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ይሳቅ ሄዋን ያርሽያ ሳኣ ኬጺደ፥ መꬍና ጎዳ ሱንꬃ ጼሴዳ። ያን እ ባረ ዱንካንያ ꬎጌዳ፤ ቃይ ያን አ ቆማቱ ሃꬃ ኦላ ቦኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ሄዋፐ ጉየ፥ አብመሌክ ባረና ዞርያ አሁዛታነ ባረ ዎታዳራቱዋ ካፑዋ ፕኮላ አኪደ፥ ጋራራፐ ይሳቃኮ ዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ይሳቅ ኡንቱንታ፥ “ህንተንቱ ካሰ ታና እጺደ፥ ህንተንቱ ቢታፐ ከስ የዴድታ፤ ሀእ ቃይ ታኮ አያ አካና የድቴ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","ኡንቱንቱ አ፥ “መꬍና ጎዳይ ኔናና ደእያዋ ኑን ቆንጭያን በኤዶ። ሄዋ ድራዉ ጫቆ ጫቁ ኑ ግዶንነ ነ ግዶን ደአና ኮሼ ያገቶ። ኑን ኔና ቦችበይኮ፤ ሽን ኑን ነዉ ኬካተꬃ ጻላላ ኦꬂደ፥ ኔና ሳሮተꬃን ሞይዝ የዴዶ። ሄዋዳንካ ኔን ኑ ቦላ ኢታባ ኦና ማላ፥ አነ ኔናና ጫቁዋ ጫቀቶይተ። ሀእ ኔን መꬍና ጎዳይ አንጄዳዋ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ሄ ዎደ ይሳቅ ኡንቱንቶ ባላ ጊግስና፥ ሜድኖነ ኡሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ዎንተꬃ ጋላስ ዎንታ ጉራን ደንዲደ፥ ኡንቱንቱ እቱ እቱዋና ጫቀቴድኖ። ይሳቅ ኡንቱንታ ሞይዝና፥ ኡንቱንቱ አፐ ሳሮ ሻከቲደ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ሄ ጋላስ ይሳቃ ቆማቱ ዪደ፥ ባረንቱ ቦኬዳ ሃꬃ ኦላባ አዉ ኦዴድኖ፤ “ኑን ሃꬃ ደሜዶ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","እ ሄ ሃꬃ ኦላ ሳበህ ጊደ ሱንꬄዳ፤ ሄዋ ድራዉ ሄ ካታማ ሱንꬃይ ሀቼ ጋካናዉ በርሳበህ ጌተቴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ኤሳ ላይꬃይ ኦይታሙዋ ግድያ ዎደ፥ ሂትያ ብኤዶ ናቶ ዮድቶነ ሂትያ ኤሎና ናቶ ባሰማቶ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ኡንቱንቱ ይሳቃነ ርብቆ ካዮዪደ ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ይሳቅ ጭምና፥ አ አይፊ ጼላ እጼዳ ዎደ፥ ባረ ባይራትያ ናኣ ኤሳ ጼሲደ አ፥ “ታ ናአዉ” ያጌዳ። እ፥ “አቤ” ጊደ ኮዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","እ፥ “በአ፥ ሀእ ታን ጭማድ፤ ታን ሀይቃና ጋላሳ ኤርከ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ያትያ ድራዉ፥ ሀእ ነ ሻንካትያ ዎንዳፍያነ ዙቢያ አካደ፥ ባዙዋ ባ፤ ዶኣ ታዉ ሻንካታደ፥ አሹዋ አካደ ያ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ማልኦ ቁማ፥ ታን ዶስያዋ ካꬃደ አꬃ፤ ሄዌነ ታን ሀይቃናፐ ካሰ ኔና አንጃናሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ርብቃ ይሳቅ ባረ ናኣ ኤሳዉ ኦድያ ዎደ ስሳዱ። ኤሳይ ዶኣ ሻንካቲደ አሀናዉ ባዙዋ ቤዳዋፐ ጉየ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ርብቃ ባረ ናኣ ያቆባ፥ “ነ አዉ ነ እሻ ኤሳዉ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘ዶኣ ሻንካታ አሃደ፥ ታዉ ማልኦ ቁማ ታን ማናዉ ካꬃ፤ ሄዌነ ታን ሀይቃናፐ ካሰታደ፥ መꬍና ጎዳ ስንꬃን ኔና አንጃናሳ’ ያግያዋ ታን ስሳድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ታ ናአዉ፥ ሀእ ታን ኔና አዛዝያዋ ሎይꬃደ ስሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ዉድያ ጋርሳ ባደ፥ ላኡ ቦልትቦልታ ዴሻ ማራቱዋ ታዉ አካደ ያ፤ ታን ነ አቦው ማልኦ ቁማ እ ዶስያዋዳን ካꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ነ አዉ ሚደ ሀይቀናን ካሰቲደ ኔና አንጃና ማላ፥ አዉ አꬃሳ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ሽን ያቆብ ባረ አቶ ርብቆ፥ “ታ እሻ ኤሳ ቦላን እስኪ ደኤ፤ ሽን ታ ቦላይ ሊቆ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ታ አዉ ታና ኦይቂ በኦፐ ሽን? ታን አ ጭምያዋ አዉ ማላትና፥ ታን አንጁዋ ድራዉ ሸቃ ታ ቦላ አሀነንቶነ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","አ ዳያ አ፥ “ታ ናአዉ፥ ሄ ሸቃይ ታና ጋኮ። ታን ነዉ ኦድያዋ ኦꬃ፤ ባደ ዴሻ ማራቱዋ ታዉ አካደ ያ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ብ አሂደ ባረ ዳይዉ እሜዳ፤ አ ዳያ ማልኦ ቁማ አ አዉ ዶስያዋዳን ካꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ሄዋፐ ጉየ፥ ርብቃ ሶን ባረ ማታን ደእያ ባረ ባይራ ናኣ ኤሳ ማዩዋ ሎኡዋ አሃደ፥ ባረ ቴፋ ናኣ ያቆባ ማይዛዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ቃይ ሄ ዴሻቱዋ ጋልባ አ ኩሽያነ አ ሊቆ ቆꬍያ ማይዛዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ባረ ካꬄዳ ማልኦ ቁማነ ኡክꬃ ባረ ናኣ ያቆባ ኩሽያን ዎꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ያትና እ ባረ አዉዋኮ ቢደ ገሊደ፥ “ታ አዎ” ያጌዳ። እ፥ “አቤ! ታ ናአዉ፥ ኔን ኦኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ያቆብ ባረ አዉዋ፥ “ታን ነ ባይራ ናኣ ኤሳ፤ ኔን ታና አዛዜዳዋዳን ታን ኦꬃድ፤ ደንዳ፤ ደንዳ ኡታደ፥ ታን ሻንካፐ አሄዳዋ ማ፤ ያታደ ታና አንጃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ይሳቅ ባረ ናኣ፥ “ታ ናአዉ፥ ዋታ ኤሌላ ደማድ?” ያጊደ ኦቼዳ። እ፥ “መꬍና ጎዳይ ነ ጾሳይ ታና ማዴዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ይሳቅ ያቆባ፥ “ታ ናአዉ፥ ኔን ቱሙ ታ ናኣ ኤሰንቶነ ታን ኦይቃ በአናዉ አነ ታኮ ሺቃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ያቆብ ባረ አዉዋ ይሳቃኮ ሺቅና ኦይቂ በኢደ፥ “ሀ ቃላይ ያቆባ ቃላ፤ ሽን ኩሺ ኤሳ ኩሽያ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","አ ኩሺ አ እሻ ኤሳ ኩሽያዳን እስክያና ደእያ ድራዉ፥ ኤርቤና፤ እ ኤረናን አ አንጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","አ፥ “ቱሙ ኔን ታ ናኣ ኤሰዬ?” ያጊደ ኦቼዳ። እ፥ “ኤ፥ ታናቴ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","እ፥ “ታ ናአዉ፥ ታን ኔን ሻንካቴዳዋ ማናዉ ሃ አꬃ፤ ማደ ታን ኔና አንጃና” ያጌዳ። ያቆብ አꬅና፥ እ ሜዳ፤ ቃይ እ አዉ ዎይንያ ኤሳ አህና ኡሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ሄዋፐ ጉየ አ አዉዋ ይሳቅ፥ “ታ ናአዉ፥ ሃያ፤ ሺቃደ ታና የራ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ያቆብ ሺቂደ አ የሬዳ፤ ይሳቅ አ ማዩዋ ስንግ ስሲደ፥ ሀዋዳን ያጊደ አንጄዳ፤ “ታ ናኣ ፔኑ መꬍና ጎዳይ አንጄዳ ጎሻዳን ሳዌ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ጾሳይ ሳሉዋ ጮኩዋነ ሳኣ ሽጫ፥ ካꬃነ ኦራꬃ ዎይንያ ኤሳ ዳርሲደ ነዉ እሞ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ካዉተꬃቱ ነዉ ሞደትኖ፤ አሳቱ ነዉ ጉልባትኖ። ኔን ነ እሻቶ ጎዳ ግዳ፤ ነ አት ዛራቱ ነዉ ጉልባትኖ። ኔና ሸቂያዌ ሸቀቴዳዋ ግዶ፤ ኔና አንጅያዌ አንጀቴዳዋ ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ይሳቅ ያቆባ አንጅ ዉርሴዳዋፐ ጉየ፥ ያቆብ ባረ አዉዋ ይሳቃ ስንꬃፐ ከሶዋን ኤሳይ ሻንካፐ ፑቱ ጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","እካ ቃይ ማልኦ ቁማ ካꬂደ፥ ባረ አዎ አꬄዳ። አ፥ “ታ አዎ፥ ደንዳ፤ ደንዳ ኡታደ፥ ታን ሻንካቴዳዋፐ ማ፤ ያታደ ታና አንጃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","አ አዉ ይሳቅ አ፥ “ኔን ኦኔ?” ያጊደ ኦቼዳ። እ፥ “ታን ነ ናኣ፥ ነ ባይራ ናኣ ኤሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ይሳቅ ዳጋሚደ ኮኮሪደ፤ “ያትና ዶኣ ሻንካቴዳዋ አኪደ ታዉ አꬄዳዌ ኦኔ? ታን ሀእ ኔን ያና ስንꬃን ማደ፥ አ አንጃ ድጋድ፤ ቱሙካ እ አንጀቴዳዋ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ኤሳይ ባረ አዉዋ ቃላ ስሴዳ ዎደ፥ ባረ ቃላ ꬎቁ ኦꬂደ፥ ዳሮ ይባታ ዬኩዋ ዬኪደ ባረ አዉዋ፥ “ታና አንጃ፤ ታ አዎ፥ ታናካ አንጃ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ሽን እ፥ “ነ እሻይ ዪደ ጭሚደ፥ ነ አንጁዋ አክ ድጌዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ኤሳይ፥ “አ ኤሪደ ያቆባ ሱንꬄዳ፤ እ ታና ጭሞደ፥ ሀዌ ላኤንꬁዋ፤ እ ታ ባይራተꬃ አኬዳ፤ ቃይ ሀእ ታ አንጁዋ አኬዳ” ያጌዳ። ቃይ እ፥ “ኔን ታዉ አንጁዋፐ አያነ አሻበይኪ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ይሳቅ ኤሳ፥ “ታን አ ነዉ ጎዳ ኦꬃድ፤ አ እሻቱዋ ኡባካ አ ቆማቱዋ ኦꬃድ፤ ቃይ ታን ካꬃንነ ኦራꬃ ዎይንያ ኤሳን አ ምንሳድ። ያትና፥ ታ ናአዉ፥ ነዉ ታን አያ ኦꬆ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ኤሳይ ባረ አዉዋ፥ “ታ አዎ፥ ነዉ እት አንጆ ጻላላይ ደኢ? ታ አዎ፥ ታናካ ቃይ አንጃ” ያጌዳ። ሄዋፐ ጉየ፥ ኤሳይ ባረ ቃላ ꬎቁ ኦꬂደ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","አ አዉዋ ይሳቅ ዛሪደ፥ “ነ ደእያ ሀ ሳኣ ዱረተꬃፐ ሃካደ ደአና፤ ሳሉዋ ጮኩካ ነዉ ዎና፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ኔን ነ ማሻን አቃና፤ ኔን ነ እሻዉ ሞደታና። ሽን ኔን አናና ኤቀትያ ዎደ፥ አ ሞርገ ምꬃ ነ ሞርግያፐ ኦላና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ያቆባ አ አዉ አንጄዳ ድራዉ፥ ኤሳይ ባረ ኡሉዋን አ ሞርኬዳ፤ እ ባረ ዎዛናን፥ “ታ አዉ ሀያና ማቴዳ፤ ታን አዉ ካዮታ ስማደ፥ ታ እሻ ያቆባ ዎꬋና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ሽን ርብቃ ሀ ባረ ባይራ ናኣ ኤሳ ቃላ ስሴዳ ድራዉ፥ ባረ ቴፋ ናኣ ያቆባ ጼስሳ አሃደ ሀዋዳን ያጋዱ፤ “ነ እሻይ ኤሳይ ኔና ዎꬊደ ሀሉዋ ከሳናዉ ሀልቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ሀያና ታ ናአዉ፥ ታን ነዉ ኦዶዋ ኦꬃ። ደንዳ! ካራነን ደእያ ታ እሻ ላባናኮ ባቃታ! ");
INSERT INTO dwrENT_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ያታደ ነ እሻ ሀንቁ ዶቻና ጋካናዉ፥ አማሬዳ ዎድያ አናና ደአሻ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ነ እሻይ ነዉ ሀንቀትያዋ አግያ ዎደነ፥ ኔን አ ቦላ ኦꬄዳዋ እ ዶግያ ዎደ፥ ታን ኪታደ ኔና ያፐ አህሳና። ታን እት ጋላስ ህንተንቱ ላኡዋፐ መላ ከሳና ኮይከ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ሄዋፐ ጉየ ርብቃ ይሳቃ፥ “ኤሳይ አኬዳ ሂተቱዋ ማጫ ናና ጋሱዋን ታን ታ ደኡዋ ሸነታድ፤ ቃይ ያቆብካ ሀዋንቱ ማላ ሂተቱዋ ማጫ ናናቱዋፐ ማቻቶ አኮፐ፥ ታን ስም ሀይቃናዉ ኮያድ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ሄዋ ድራዉ፥ ይሳቅ ያቆባ ጼሲደ ሀዋዳን አንጄዳነ አዛዜዳ፤ “ካናነ ጋድያ ማጫ ናናቱዋፐ ነዉ ማቻቶ አኮፓ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ደንዳ! ነ ዳይ አዉዋ ባቱኤላኮ፥ ማስጰጾምያ ጋድያ ባደ ያፐ ነ ዳይ እሻ ላባና ማጫ ናናቱዋፐ እትኖ ነዉ ማቻቶ ኦꬃደ አካ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ኡባ ዳንዳይያ ጾሳይ ኔና አንጆ፤ እ ኔ የለታ አሶ፤ ኔን እት ደረ አሳ ኬና ጋካናዉ ኔና ጮርሶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ኔን ሀእ በተተꬃን ኡቴዳ ሀ ቢታ ነዋ ኦꬃና ማላ ነዉነ ነ ዘረꬃዉ ጾሳይ አብራሃመ አንጁዋ እሞ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ይሳቅ ያቆባ የዴዳ፤ ያቆብ ማስጰጾምያ ጋድያ ላባናኮ ቤዳ። ላባን ያቆባነ ኤሳ የሌዳ አት ርብቃ እሻነ ሶርያ ባቱኤላ ናኣ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ይሳቅ ያቆባ አንጄዳዋነ፥ ያፐ ማቻቶ አካናዉ ማስጰጾምያ ጋድያ አ የዴዳዋ፥ ቃይ እ ያቆባ አንጄዳ ዎደ፥ “ካናነ ማጫ አሳ አኮፓ” ያጊደ አዛዜዳዋነ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ያቆብ ባረ አዉዋነ ባረ አቶነ አዛዘቲደ፥ ማስጰጾምያ ጋድያ ቤዳዋ ኤሳይ ኤሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ኤሳይ ሄዋን ካናነ ቢታ ማጫውና ባረ አዉዋ ይሳቃ አይ ኬሻ ኢትንቶ አኬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ሄዋ ድራዉ ኤሳይ አብራሃመ ናኣ እስማኤለኮ ቢደ፥ አ ናቶ ማህላቶ ባረ ማቻቱዋ ቦላ ጉጂደ አኬዳ። እዛ ናባዮታ ምቻቶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ያቆብ በርሳበሄፐ ካራነ ባናዉ ደንዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","እ እት ሳኣ ጋክና አዋይ ዉልና፥ ያን ቃማ አቄዳ። ሄ ሳኣን ደእያ ሹቻቱዋፐ እቱዋ አኪደ፥ ባረ ሁጲያን ቦርኮቲደ ሄ ሳኣን ገምእሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","እ አኩሙዋ አኩመቴዳ፤ ሄ አኩሙዋን ጋይያ እቱ ቢታን ኤቂና፥ አዉ ጼራይ ሳሉዋ ጋክያዋን፥ ጾሳ ኪታንቻቱ ግእሺናነ ዎꬍሽን በኤዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ጋይያዉ ቦላ ጼራን መꬍና ጎዳይ ኤቂደ አ፥ “ታን መꬍና ጎዳ፥ ነ አዉዋ አብራሃማ ጾሳ፥ ይሳቃ ጾሳ። ሀ ኔን ግሴዳ ቢታ ነዉነ ነ ዘረꬃዉ እማና፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ነ ዘረꬃይ ሳኣ ሻፍያዳን ዳራና፤ ኔን አዋይ ዉልያ ባጋናነ፥ አዋይ ዶልያ ባጋና፥ ሁጲሳናነ ህርክ ባጋና ደእያ ሳኣ ጋካናዉ አካና፤ ሳኣ ቦላን ደእያ አሳይ ኡባይ ነ ባጋናነ ነ ዘረꬃ ባጋና አንጀታና ");
INSERT INTO dwrENT_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ታን ኔናና ደአይ፤ ኔን ብያሳኣ ኡባን ታን ኔና ናጋና፤ ቃይ ታን ኔና ሀ ጋድያ ጉየ ዛራደ አሀና፤ ታን ነዉ ኦꬃና ጌዳዋ ኦꬃና ጋካናዉ ኔና የግከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ያቆብ ገምእሹዋፐ ቤጎቴዳ ዎደ፥ “መꬍና ጎዳይ ቱሙ ሀ ሳኣን ደኤ፤ ታን ኤራበይከፐ አትን” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","እ ያዪደ፥ “ሀ ሳአይ ዎት ያሺ! ሀ ሳአይ ጾሳ ጎልያፐ አትን፥ አይነ ሀራ ሳኣ ግደና፤ ሀዌ ሳሉዋ ፐንግያ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ዎንተꬃ ጋላስ ዎንታ ጉራን ያቆብ ደንዲደ፥ ባረ ቦርኮቴዳ ሹቻ አኪደ፥ ቱሳዳን ኤሲደ፥ ጾሳዉ ዱማያናዉ አ ቦላ ዛይትያ ትጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ያቆብ ሄ ሳኣ ቤቴለ ጊደ ጼሴዳ። ሽን ሄ ካታማይ ሄዋፐ ካሰ ሎዛ ጌተቴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","ያቆብ ሀዋዳን ያጊደ ሺቄዳ፤ “ታ አዉዋ ሶ ታን ሳሮ ስማና ማላ ጾሳይ ታናና ግዶፐ፥ ታን ብያ ሀ ቡሳን ታና ናጎፐነ ታዉ ምያ ቁማነ ማይያ ማዩዋ እሞፐ፥ መꬍና ጎዳይ ታ ጾሳ ግዳና፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ታን ቱሳዳን ኤሴዳ ሀ ሹቻይ ጾሳ ጎልያ ግዳና። ኔን ታዉ እምያዋ ኡባፐ ታሙዋፐ እቱዋ ታን ነዉ እማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ሄዋፐ ጉየ፥ ያቆብ ደንድ ቢደ፥ አዋይ ዶልያ ባጋ አሳቱዋ ጋድያ ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","እት ሃꬃ ኦላይ ደምባን ደእያዋ በኤዳ፤ ሄዙ ዶርሳ ዉዲ ቃይ ሄ ኦላ ማታን ግሴድኖ። አያዉ ጎፐ፥ ዉዲ ኡባይ ሃꬃ ኡሽያዌ ሄ ኦላፐ። ሄ ሃꬃ ኦላ ዶናን ደእያ ሹቻይ ዎልቃማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ዶርሳ ዉዲ ኡባይ ሄዋን ዳጋቴዳ ዎደ፥ ሄ ዉድያ ሄምያዋንቱ ሃꬃ ኦላ ዶናፐ ሄ ሹቻ ጎንዶርሲደ ዶርሳ ኡሺኖ። ሄ ሹቻ ኦላ ዶናን ዛሪደ ዎꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ያቆብ ኡንቱንታ፥ “ታ እሻቶ፥ ህንተንቱ ሀቃፐ የድተ?” ያጊደ ኦቼዳ። ኡንቱንቱ፥ “ኑን ካራነፐ ዬዶ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","እ፥ “ናኮራ ናኣ ናኣ ላባና ህንተንቱ ኤሪተየ?” ያጌዳ። ኡንቱንቱ፥ “ኤ፥ አ ኤሬቶ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ያቆብ ኡንቱንታ፥ “እ ሎኦ ደኢ?” ያጊደ ኦቼዳ። ኡንቱንቱ፥ “ኤ፥ ሎአ፤ አ ናታ ራሄላ ዶርሳ አካደ የውኖ ሀኖ በአ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ያቆብ ኡንቱንታ፥ “በእተ፤ አዋይ ሀእ ዉልቤና፤ ዉድያ መሂ ሶ ሺቅያ ዎዲ ብሮ ጋክቤና፤ ዶርሳ ሀእ ኡሽ አፊደ፥ ሄምተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ሽን ኡንቱንቱ፥ “ዉዲ ኡባይ ሺቃና ጋካናዉ፥ ሹቻ ሃꬃ ኦላ ዶናፐ ጎንዶርሳና ጋካናዉ፥ ኑን ኡሻናዉ ዳንዳዮኮ። ሄዋፐ ጉየ፥ ኑን ዶርሳ ኡሻና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","እ ብሮ ሃሳይሽን፥ ላባና ናታ ራሄላ ባረ አዉዋ ዶርሳቱዋ ላጋ አካደ ጋካዱ፤ አያዉ ጎፐ፥ እዛ ዶርሳ ሄንꬃንቻ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ያቆብ ባረ አት እሻ ላባና ናቶ ራሄሎ በኤዳ ዎደነ፥ ባረ አት እሻ ላባና ዶርሳ በኤዳ ዎደ፥ ቢደ ኦላ ዶናፐ ሹቻ ጎንዶርሴዳ፤ ባረ አት እሻ ዶርሳቱዋ ሃꬃ ኡሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ያቆብ ራሄሎ የሪደ፥ ናሸቻዉ ባረ ቃላ ꬎቂሲደ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ያቆብ እዝዉ አዉዋ ዳቦነ ርብቅ ናኣ ግድያዋ ራሄልዉ ኦዴዳ። ሄዋ ድራዉ እዛ ዎጻ ባደ ባረ አዎ ኦዳዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ላባን ባረ ምቻት ናኣ ያቆባ ዎርያ ስሴዳ ሳናካ፥ አናና ጋከታናዉ ዎጼዳ። አ እድም የሪደ፥ ባረ ሶ አፌዳ። ያን ያቆብ ሀኔዳዋ ኡባ ላባናዉ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ላባን አ፥ “ኔን ቱሙ ታ አሾነ ታ ሱꬃ” ያጌዳ። ያቆብ አናና እት አግና ኩመንꬃ ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ሄዋፐ ጉየ ላባን አ፥ “ኔን ታዉ ዳቦ ግዴዳ ድራዉ፥ ታዉ ጮ መላ ኦꬃንዬ? አነ ነዉ አያ ጭጋናዉ በስንቶ ታዉ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ላባናዉ ላኡ ማጫ ናናቱ ደኢኖ፤ ባይራት ሱንꬃይ ልዮ፥ ቴፋትዌ ራሄሎ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ልያ አይፍያና ጩጫ፤ ሽን ራሄላ ጌሳንቻነ ማላ ሎአ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ያቆብ ራሄሎ ሲቂደ አ፥ “ታን ነ ቴፋ ናት ራሄል ድራዉ ነዉ ላፑን ላይꬃ ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ላባን፥ “እዞ ሀራ አሳዉ እማናፐ ነዉ እምያዌ ሎአ፤ ኔን ታናና ሀዋን ደአ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ሄዋ ድራዉ ያቆብ ራሄሎ አካናዉ ላፑን ላይꬃ ኦꬄዳ፤ ሽን እ እዞ ሲቅያ ድራዉ፥ አዉ አማሬዳ ጋላሳ ማላቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ሄዋፐ ጉየ ያቆብ ላባና፥ “ታ ማቻቶ ታዉ እማ፤ ታ ዎዲ ፖለቴዳ፤ ታን እዞ አካናዉ ኮያድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ሄዋ ድራዉ ላባን ሄዋን ደእያ አሳ ኡባ ጼሲደ፥ ቡላቻ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ሽን ሳአይ ቃምና፥ እ ባረ ናቶ ልዮ አፊደ ያቆባዉ እሜዳ። ያቆብ እዞ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ቃይ ላባን ባረ ቆማቶ ዝልፖ ባረ ናት ልይዉ ዳንጋጽረ ግዳናዳን እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ሳአይ ዎንትና ጼልያ ዎደ፥ ሄኮ ልዮ! ያትና ያቆብ ላባና፥ “ሀዌ ኔን ታ ቦላ ኦꬄዳዌ አዬ? ታን ነዉ ኦꬄዳዌ ራሄል ድራሳ ግደኔየ? ታና አያዉ ጭማድ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ላባን አ፥ “ኑ ቢታን ባይራታ ደእሽን፥ ቴፋቶ አስናዉ እምያዌ ዎጋ ግደና። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ሄ ምሽራ ሳምንታ ዉርሳ፤ ቃይ ቴፋትያኖካ ኑን ነዉ እማና፤ ሄዋፐ ጉየ፥ ሀራ ላፑን ላይꬃ ታዉ ኦꬃሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ያቆብ ሄዋዳን ሀኒደ ሄ ሳምንታ ዉርሴዳ፤ ሄዋፐ ጉየ፥ ላባን ባረ ናቶ ራሄሎ አዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ቃይ ላባን ባረ ቆማቶ ባሎ ባረ ናት ራሄልዉ ዳንጋጽረ ግዳናዳን እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ያቆብ ራሄሎ አኬዳ። ራሄሎ ልይፐ አꬂደ ሲቄዳ። ሀራ ላፑን ላይꬃ ላባናዉ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","መꬍና ጎዳይ ልያ ሲቀታቤናዋ በኢደ፥ እዝዉ የልያ ኡሉዋ ዶዬዳ፤ ሽን ራሄላ ማንꬃቶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ልያ ሻሃራደ አቱማ ናኣ የላዱ። አ ሱንꬃካ ሮቤላ ሱንꬃዱ፤ አያዉ ጎፐ እዛ፥ “መꬍና ጎዳይ ታ መቱዋ በኤዳ፤ ሀእ ቱሙ ታና ታ አስናይ ሲቃና” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","እዛ ሀራካ ሻሃራደ አቱማ ናኣ የላዱ። እዛ፥ “መꬍና ጎዳይ ታን ሲቀታቤናዋ ስሴዳ ድራዉ፥ ታዉ ሀዋካ ጉጄዳ” ያጋደ፥ አ ስሞና ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","አ ሀራካ ሻሃራደ አቱማ ናኣ የላዱ። እዛ፥ “ታን አዉ ሄዙ አቱማ ናና የሌዳ ድራዉ፥ ታ አስናይ ሀእ ታናና ዋጸታና” ያጋደ፥ አ ሌዊ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","አ ሀራካ ሻሃራደ አቱማ ናኣ የላዱ። እዛ፥ “ሀችዋን ታን መꬍና ጎዳ ጋላታና” ያጋዱ። ሄዋ ድራዉ አ ይሁዳ ሱንꬃዱ። ሄዋፐ ጉየ የሉዋ ኤሳዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ራሄላ ያቆባዉ ናና የላቤናዋ በኤዳ ዎደ፥ ባረ ምቻቶ ቃናታዱ፤ ሄዋ ድራዉ ያቆባ፥ “ታዉ ናና እማ፤ ሄዌ ꬋዮፐ፥ ታን ሀይቃና” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ያቆብ ራሄሎ ሀንቀቲደ፥ “ታና ነዉ የሉዋ ድጌዳ ጾሳ ጋድየ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","እዛ፥ “ታ ዳንጋጽራቶ ባሎ ህኖ በአ፤ እዛ ታ ድራዉ የላና ማላ ኔን እዞ አካ፤ ያቶፐ እዝ ባጋና ታንካ ናኣ ዳዮ ግዳና” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ባረ ዳንጋጽራቶ ባሎ ማቻቶ ኦꬂደ አካና ማላ፥ አዉ እማዱ፤ ያቆብ እዞ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ባላ ሻሃራደ አቱማ ናኣ ያቆባዉ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ያትና ራሄላ፥ “ጾሳይ ታዉ ዳናቴዳ፤ ታ ዎሳካ ስሲደ፥ ታዉ አቱማ ናኣ እሜዳ” ያጋዱ። ሄዋ ድራዉ አ ዳና ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ራሄል ዳንጋጽራታ ባላ ሀራ ሻሃራደ፥ ያቆባዉ ላኤንꬁዋ አቱማ ናኣ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ራሄላ፥ “ታን ታ ምቻትና ዎልቃማ ባጽያ ባጸታደ ጾናድ” ያጋዱ። ሄዋ ድራዉ አ ንፍታሌማ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ልያ ባረዉ የሉ ኤቄዳዋ በኣደ፥ ባረ ዳንጋጽራቶ ዝልፖ አፋደ ያቆብ እዞ አካና ማላ እማዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ልያ ዳንጋጽራታ ዝልፓ አቱማ ናኣ ያቆባዉ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ልያ፥ “ላ ሀዌ አያ ሎኦ ካጬ!” ያጋዱ። ሄዋ ድራዉ ጋዳ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ልያ ዳንጋጽራታ ዝልፓ ያቆባዉ ላኤንꬁዋ አቱማ ናኣ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ልያ፥ “ታን አይ ኬሻ ናሸታይታሻ! ማጫ አሳይ ታና ናሸትያኖ ጋና” ያጋዱ። ሄዋ ድራዉ አ አሴራ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ዛርጋ ጫክያ አግናን ሮቤል ጋደ ቢደ፥ እንኮይያ ግያ ትማትምያ ማላትያ ቴራ ደሚደ፥ ባረ አት ልይዉ አሄዳ። ራሄላ ልዮ፥ “ነ ናኣ እንኮይያፐ ታዉ እማ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ሽን ልያ፥ “ታ አስና ኔን ዎꬃ አኬዳዌ ግደናን እጽና፥ ቃይ ታ ናኣ እንኮይያ አካይ?” ያጋዱ። ራሄላ፥ “ያቶፐ፥ ነ ናኣ እንኮይያ ድራዉ ያቆብ ሀቼ ቃማ ኔናና አቆ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ሄ ጋላሳ ኦማርስ ያቆብ ዎራፐ ዬዳ ዎደ፥ ልያ አ ሞካናዉ ከሳደ አ፥ “ኔን ታናና አቃና ኮሼ፤ አያዉ ጎፐ፥ ታን ታ ናኣ እንኮይያን ኔና ከራዉ አካ ድጋድ” ያጋዱ። ሄዋ ድራዉ እ ሄ ጋላሳ ቃማ እዝና አቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ጾሳይ ልያ ዎሳ ስሴዳ፤ እዛ ሻሃራደ፥ እቼሻንꬃ አቱማ ናኣ ያቆባዉ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ልያ፥ “ታን ታ ዳንጋጽራቶ ታ አስናዉ እሜዳ ድራዉ፥ ጾሳይ ሄዋ ከራ ታዉ ጭጌዳ” ያጋዱ። ሄዋ ድራዉ አ ይሳኮራ ጋደ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ልያ ሀራካ ሻሃራደ፥ ኡሱፑንꬃ አቱማ ናኣ ያቆባዉ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ልያ፥ “ጾሳይ ታዉ አልኦ እሞታ እሜዳ፤ ታን ታ አስናዉ ኡሱፑን ናና የሌዳ ድራዉ፥ ሀእ እ ታና ቦንቻናዋ” ያጋዱ። ሄዋ ድራዉ አ ዛብሎና ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ሄዋፐ ጉየ እት ማጫ ናቶ የላዱ፤ እዞ ዲኖ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ጾሳይ ራሄሎ ሀሳዬዳ፤ እዝ ዎሳ ስሲደ እዝ የልያ ኡሉዋ ዶዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","እዛ ሻሃራደ አቱማ ናኣ የላዱ፤ “ጾሳይ ታ ዬላ ቃሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","መꬍና ጎዳይ ታዉ ሀራ አቱማ ናኣካ ጉጄረኔሻ” ያጋዱ። ሄዋ ድራዉ አ ዮሴፎ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ራሄላ ዮሴፋ የሌዳዋፐ ጉየ፥ ያቆብ ላባና፥ “ታን ታ አዉዋ ጋድያ ስማና ማላ፥ ታና ሞይዛ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ታን ኡንቱንቱ ድራዉ ነዉ ኦꬄዳ ታ ማቻቱዋነ ታ ናና ሀማ፤ ታን ባና፤ አያዉ ጎፐ፥ ታን ነዉ አይ ኬሻ ኦሱዋ ኦꬄደንቶ ኔን ኤራሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ሽን ላባን አ፥ “ታን ነዉ እትባ ኦዳይ፤ መꬍና ጎዳይ ነ ጋሱዋን ታና አንጄዳዋ ታን በኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ነ ድርጉዋ ታዉ ኦዳ፤ ታን ነዉ ጭጋና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ያቆብ፥ “ታን ነዉ ዋታ ኦꬄደንቶ፥ ነ መሂካ ዋን የለቴደንቶ ኔን ኤራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ታን ያናፐ ካሰ ነዉ ደእያ ጉꬃይ ሀእ ሎይꬅ ዳሬዳ፤ መꬍና ጎዳይ ኔና ታን አꬌዳ ሳኣን ኡባን አንጄዳ። ሽን ሀእ፥ ታን ታ ሶ አሳዉ ኦꬃናዌ አዉዴ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ላባን፥ “ታን ነዉ አያ እሞ?” ያጊደ አ ኦቼዳ። ያቆብ፥ “ታዉ አይነ እሞፓ፤ ሽን ኔን ታዉ እትባ ኦꬆፐ፥ ታን ነ ዉድያ ቃይካ ሄማናነ ናጋና። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ታን ሀቼ ነ ዉድያ ኡባ ግዱዋና አꬋና፤ ሄዋን ነ ዶርሳፐ ፑንጫርያ ዎይ ጋዛ ኡባ፥ ካረꬃ ዶርሳ ማራ ኡባነ ዴሻፐ ጋዛነ ፑንጫርያ ኡባ ታን ሻካና፤ ኡንቱንቱ ታ ድርጉዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ሄዋ ድራዉ ታ ጽሎተꬃይ ኔን ታዉ ጭጌዳ ድርጉዋ ፓይዳናዉ ስንꬃፐ ይያ ዎደ፥ ታዉ ማርካታና፤ ታ ዴሻፐ ጋዛ ዎይ ፑንጫረ ግደናዌ ዎይ ካረꬃ ግደና አይ ዶርሳ ማራይነ ታ ማታን ቤትንቶ፥ ዉኤቴዳዋዳን ፓይደታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ላብ፥ “ማያድ፤ ኔን ጌዳዋዳን ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ሽን ሄ ጋላሳን ላብ ዳንጫ ዎይ ጋዛ ግዴዳ አቱማ ዴሻ ኡባ፥ ፑንጫረ ዎይ ጋዛ ግዴዳ ማጫ ዴሻ ኡባ፥ ቦꬃ ግዴዳ ኡባነ ካረꬃ ዶርሳ ማራ ኡባ ከሲደ፥ ባረ አቱማ ናና ሄንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ያቲደ ሄ ዉድያና ሄዙ ጋላሳ ኦግያ ያቆባፐ ሃኪደ ቤዳ። ሽን ያቆብ አቴዳ ላባና ዉድያ ሄሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ያቆብ ዴሻ ሎምያፐ፥ ጉማርያፐነ ጻንቃርሳፐ ቃየ ጋትማ ከሲደ፥ ፖቁዋ ፖቂ ፖቂደ፥ ግዶ ቦꬃ ባጋ ቃሪደ ጋዛዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ዉዲ ሃꬃ ኡሻናዉ ይያ ሳኣ ኡባን፥ ዎንግርያን፥ ዉድያ ስንꬃን ፖቄዳ ጋትማቱዋ ዎꬄዳ። ካሆዋንቱ ሃꬃ ኡሻናዉ ዪደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ሄ ጋትማቱዋ ስንꬃን ብራሴድኖ፤ ኡንቱንቱ ዳንጫ፥ ፑንጫረነ ጋዛ ማራቱዋ የሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ያቆብ ማራቱዋ ዉድያፐ ሻክ ዱማ ዎꬄዳ፤ አቴዳ ዉድያ ዳንጫነ ካረꬃ ግዴዳ ላባና መህያ ስንꬃ ዛሬዳ። ያቲደ ባረዉ ዉድያ ዱማዬዳ፤ ላባና መሄቱዋና ኡንቱንታ ጋꬅቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ፓጻነ ምኖ ማጫዋንቱ ካህያ ዎደ አዉደነ፥ ኡንቱንቱ ሄ ጋትማቱዋ ማታን ብራሳና ማላ፥ ያቆብ ሄ ጋትማቱዋ ሃꬃ ዎንግርያን፥ ሚዛቱዋ ስንꬃን ዎꬄ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ሽን መሄቱ ላፋ ግዶፐ፥ ኡንቱንቱ ስንꬃን ጋትማቱዋ ዎና። ሄዋ ድራዉ ላፍያ መሄቱ ላባዋ ግድና፥ ዳርያዋንቱ ያቆባዋ ግዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ሀዋዳን ሀኒደ፥ ያቆብ ሎይꬅ ዱረቲደ፥ ዳሮ ዉድያ፥ ማጫ ቆማቱዋነ አቱማ ቆማቱዋ፥ ዳሮ ጋሎቱዋነ ሀረቱዋ ሞዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ያቆብ ላባና ናናይ ባረና፥ “ያቆብ ኑ አዉዋ ኡባ አክ ድጌዳ፤ ሀ ዱረታ ኡባ ኑ አዉዋፐ ደሜዳ” ግያዋ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ያቆብ ላባና ሶምእ ባረዉ ካሰዋ ማላ ግደናዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ሄ ዎደ መꬍና ጎዳይ ያቆባ፥ “ኔን ነ አዎቱዋ ጋድያ፥ ነ ዳቦቱዋኮ ጉየ ስማ፤ ታን ኔናና ግዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ያቆብ ራሄሎነ ልዮ ባረ ዉዲ ደእያ ሳኣ ደምባ ያና ማላ ኪቲደ ጼስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","እ ኡንቱንታ፥ “ህንተንቱ አዉዋ ሶምእ ታዉ ካሰዋ ማላ ግደናዋ ታን በአይ፤ ሽን ታ አዉዋ ጾሳይ ታናና ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ታን ታ ዎልቃ ኡባን ህንተንቱ አዉ ኦꬄዳዋ ህንተንቱ ኤሪታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ሽን ህንተንቱ አዉ ታና ጭሚደ፥ ታ ድርጉዋ ታሙ ገደ ላሜዳ። ግዶፐነ ጾሳይ ታና እ ቆሄናዳን ድጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","እ፥ ‘ፑንጫረቱ ነ ድርጉዋ ግዳና’ ጊና፥ ዉዲ ኡባይ ፑንጫርያ የሌዳ፤ ቃይ እ፥ ‘ሻቻቱ ነ ድርጉዋ ግዳና’ ጊና፥ ዉዲ ኡባይ ሻቻ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ጾሳይ ሀዋዳን ህንተንቱ አዉዋ መህያ ዎꬅ አኪደ ታዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“መሄቱ ካህያ አግናን፥ ታን እት አኩሙዋ አኩመታድ፤ ሄ አኩሙዋን ታን ጼልያ ዎደ፥ ዉድያ ብራስያ ዴሻ ኮለቱ ዳንጫ፥ ፑንጫረነ ጋዛ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ጾሳ ኪታንቻይ አኩሙዋን ታና፥ ‘ያቆባ’ ያጌዳ፤ ታን፥ አቤ ያጋደ ኮያድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ታና እ፥ ꬎቁ ጋደ ዉድያ ጻልያ ዴሻ ኮልያ ኡባ ሻቻ፥ ፑንጫርያነ ጋዛ በአ፤ አያዉ ጎፐ፥ ላብ ነ ቦላ ኦꬅያዋ ኡባ ታን በኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ኔን ኤሴዳ ሹቻ ኦካደ፥ ታዉ ሺቀቴዳ ቤቴለ ጾሳይ ታና ሀእ ደንዳ፤ ሀ ቢታፐ ከሳ፤ ጉየ ነ የለታ ጋድያ ስማ ያጌዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ሄዋፐ ጉየ፥ ራሄላነ ልያ ሀዋዳን ያጊደ ዛሬድኖ፤ “ኑ አዉዋፐ ኑና ጋካናባይ አዬ? ");
INSERT INTO dwrENT_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","እ ኑና አላጋዳን ጼሌ ግደኔ? እ ኑና ዛልእ አኬዳ፤ ዛልኢደ አኬዳዋካ ም ꬋይሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ጾሳይ ኑ አዉዋፐ ዎꬅ አኬዳ ማጹ ኡባይ ቱሙካ ኑዋነ ኑ ናናዋ። ሄዋ ድራዉ ጾሳይ ነዉ ኦዴዳዋ ኡባ ኦꬃ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","ያቆብ ካናነ ጋድያን ደእያ ባረ አዉዋ ይሳቃኮ ባናዉ ደንዴዳ፤ እ ባረ ናናነ ባረ ማቻቱዋ ጋሉዋ ቶግሴዳ፤ ዉድያ ኡባ ባረፐ ስንꬃና ላጊደ፥ ማስጰጾምያን ደኢደ እ ሺሼዳ ማጹዋ ኡባ አኪደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ላብ ባረ ዶርሳቱዋ እስክያ ቃንጻናዉ ብድጌዶሽን፥ ራሄላ ባረ አዉዋ ሶ ምስለቱዋ ዉኣዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ቃይ ያቆብ ሶርያ ላባናዉ ባረ ባቃትያዋ ኦደናን ጭሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","እ ባረዉ ደእያዋ ኡባ አኪደ ባቃቴዳ፤ ኤፍራጺሳ ሻፋ ፕኒደ፥ ጋላኣደ ግያ ገዝያኮ ስሚደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ሄዘንꬃ ጋላሳን፥ ላብ ያቆብ ባቃት ብ ክቼዳዋ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ባረ ዳቦቱዋ ባረናና አኪደ፥ ላፑን ጋላሳ ኦግያ ያቆባ ጌዱዋ ካሊደ፥ ጋላኣደ ገዝያን አ ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ሄ ዎደ ጾሳይ ቃማ ሶርያ ላባናኮ አኩሙዋን ዪደ አ፥ “ኔን ያቆባ ቦላ ኢታ ግድና፥ ሎአ ግድና፥ አይነ ሃሳየናዳን ኔና ኤራ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ላብ ጋክያ ዎደ፥ ያቆብ ጋላኣደ ገዝያን ዱንካኒደ ኡቴዳ፤ ቃይ ላብነ አ ዳቦቱ ያን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ሄዋፐ ጉየ ላብ ያቆባ፥ “ኔን ሀዋዳን አያዉ ኦꬃዲ? ኔን ታና ጭማደ፥ ታ ማጫ ናና ኦላን ኦሞደቴዳዋዳን ላጋደ ከሳዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ኔን አያዉ ቆሱዋን ታፐ ከሳ አካደ፥ ታና ጭማዲ? ታን ኔና ናሸቻንነ የꬃን፥ ካራቡዋንነ ዲꬃን ሞይዛና ማላ ታዉ አያዉ ኦዳበይኪ? ");
INSERT INTO dwrENT_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ኔን ሀራይ አቶ፥ ታ ናና ናናነ ታ ማጫ ናና ታን የራ አከና ማላ ድጋዳ። ኔን ኤያባ ኦꬃዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ታን ኔና ገናናዉ ታዉ ዎልቃይ ደኤ፤ ሽን ነ አዉዋ ጾሳይ ዝኖ ቃማ ታና፥ ‘ያቆባ ቦላ ኢታ ግድና፥ ሎአ ግድና፥ አይነ ሃሳየናዳን ኔና ኤራ!’ ያጊደ ታዉ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ሀእ ግዶፐነ፥ ኔን ነ አዉዋ ሶ ባናዉ ሎይꬃ ላሞቴዳ ድራዉ ከሳዳ። ሽን ታ ሶ ምስለቱዋ ኔን አያዉ ዉኣዲ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ያቆብ ላባና፥ “ኔን ነ ናና ታፐ ዎልቃን ዎꬃ አካንንቶነ ጋደ ቆፔዳ ድራዉነ ያዬዳ ድራዉ፥ ሀዋዳን ኦꬃድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ሽን ነ ሶ ምስለቱዋ ኦይቄዳ አሳ ኦናነ ኔን ደሞፐ፥ ሄ ኡራይ ሲፈቶ! ነዋ ግዴዳዌ ታ ማታን ቤትንቶ፥ ኑ ዳባቱዋ ስንꬃን ኮያ፤ ነዋ ግዶፐ አካ” ያጌዳ፤ አያዉ ጎፐ፥ ያቆብ ራሄላ ሄ ሶ ምስለቱዋ ዉኤዳዋ ኤርቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ሄዋ ድራዉ ላብ ያቆባ ዱንካንያ ግዶ፥ ልያ ዱንካንያ ግዶን ላኡ ቆማቱዋ ዱንካንያ ግዶ ገሌዳ፤ ሽን አይነ ደምቤና። ልያ ዱንካንያፐ ከሲደ፥ ራሄል ዱንካንያ ገሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ራሄላ ሶ ምስለቱዋ አካደ፥ ጋሉዋ ኮራ ጋርሳን ቆሳደ፥ አ ቦላ ኡታዱ። ላብ ዱንካንያን ደእያዋ ኡባ ቡሉቂ ኮዬዳ፤ ሽን አይነ ደምቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ራሄላ ባረ አዉዋ፥ “ታ ጎዳዉ፥ ታና ሀንቀꬆፓ፤ ታን ነዉ ኤቃና ዳንዳይከ፤ ታዉ ፒላይ ይ ኡቴዳ” ያጋዱ። እ ኮዬዳ፤ ሽን ሶ ምስለቱዋ ደምቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ያቆብ ላባና ሀንቀቲደ ዎቃሴዳ፤ ያቆብ ላባና፥ “ታን አያ ባይዛድታ? ሀዋ ኔን ታና ካላናዉ፥ ታን ኦꬄዳ ናጋራይ አዬ? ");
INSERT INTO dwrENT_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ሀእ ኔን ታ ሚሻ ኡባ ቡሉቃደ ኮያዳ፤ ነ ሶ ሚሻፐ አያ ደማድ? ኡንቱንቱ ኑ ላኡዋ ግዱዋን ፕርዳና ማላ፥ ታ ዳባቱዋ ስንꬃንነ ነ ዳባቱዋ ስንꬃን ሀዋን ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“ታን ኔናና ላታሙ ላይꬃ ኩመንꬃ ደኣድ፤ ነ ዶርሳይካ ነ ዴሻይካ ቦሸትቤና፤ ዎይ ነ ዉድያፐ ጻቦትያ ማበይከ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ዶአይ መንꬄዳዋነ ነዉ አሀበይከ፤ ሽን ሄዋ ታናን ፓይዳድ። ጋላስ ዉኤቴዳዋ ዎይ ቃማ ዉኤቴዳዋ ታና ጭግሳዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ጋላሳ ሱሉ፥ ቃማ ሜጉ ታና ቆሄዳ፤ ገምእሹ ታፐ ꬋዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ታን ሀዋዳን ነ ሶን ላታሙ ላይꬃ ደኣድ፤ ታማነ ኦይዱ ላይꬃ ነ ላኡ ማጫ ናና ድራዉነ ኡሱፑን ላይꬃ ነ ዉድያ ድራዉ ነዉ ኦꬃደ ደኣድ፤ ሽን ኔን ታ ድርጉዋ ታሙ ገደ ላማዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ታ አዉዋ ጾሳይ፥ አብራሃመ ጾሳይ፥ ይሳቅ ያዬዳዌ ታናና ግድቤናዋ ግድንቶ፥ ስ ባይናን ኔን ታና መላ ኩሸ ከሳ የዳዳ፤ ሽን ጾሳይ ታ ቱጋነ ታ ኩሽያ ኦሱዋ በኢደ፥ ዝኖ ቃማ ኔና ሴሬዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ላብ ያቆባ፥ “ማቻቱ ታ ማጫ ናና፤ ናናይካ ታ ናና፤ ዉዲካ ታ ዉድያ፤ ኔን በእያ ኡባይ ታዋ። ሀቼ ሀ ማጫ ናና ታዋንቱ ቦላነ ኡንቱንቱ የሌዳ ናና ቦላ አያ ኦꬃናዉ ዳንዳያይታ? ");
INSERT INTO dwrENT_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ሀእ ሃያ፤ ኔንነ ታን ጫቁዋ ጫቀቶይተ፤ ሄዌ ኔፐነ ታፐ ግዱዋን ማርካ ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ሄዋ ድራዉ ያቆብ እት ሹቻ አኪደ ቱሳዳን ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","እ ባረ ዳቦቱዋ፥ “ሹቻ ሺሽተ” ያጌዳ፤ ኡንቱንቱ ሹቻ ሺሺደ ኬሌድኖ፤ ሄ ኬላ ላንቂያን ሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ላብ ሄ ኬላ፥ ይጋር-ሳሃዱታ ጊደ ሱንꬄዳ፤ ቃይ ያቆብ አ ጭሜዳ ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ላብ፥ “ሀ ኬላይ ኔፐነ ታፐ ግዱዋን ሀቼ ማርካ” ያጌዳ። ሄዋ ድራዉ አ ሱንꬃይ ጭሜዳ ጌተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ቃይ እ ሄ ሹቻ ቱሳ ምጽጳ ጊደ ሱንꬄዳ፤ አያዉ ጎፐ፥ ላብ፥ “ኑን እቱ እቱዋፐ ሃኪደ ደእያ ዎደ፥ መꬍና ጎዳይ ነ ግዱዋንነ ታ ግዱዋን ግዲደ ናጎ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ኔን ታ ማጫ ናና ናቆፐ፥ ዎይ ኔን ታ ማጫ ናና ቦላ ሀራ ማቻቱዋ አኮፐ፥ ኑናና ሀእ ኦንነ ባይናዋ ግዶፐነ ነ ግዱዋንነ ታ ግዱዋን ጾሳይ ማርካ ግድያዋ ሀሳያ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ላብ ቃይካ ያቆባ፥ “ኬለቴዳ ሹቻይ ሀዌሽ፤ ቃይ ታን ነ ግዱዋንነ ታ ግዱዋን ኤሴዳ ሹቻ ቱሳይ ሀዌሽ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ታን ሀ ኬላፐ ኔና ገናናዉ ኔኮ አናዳን፥ ኔንካ ታና ገናናዉ ሀ ኬላፐነ ሀ ሹቻ ቱሳፐ አናዳን፥ ሀ ኬላይነ ሀ ሹቻ ቱሳይ ማርካ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","አብራሃመ ጾሳይ፥ ናኮራ ጾሳይ፥ ኡንቱንቱ አዉዋ ጾሳይ፥ ኑ ግዱዋን እ ፕርዶ” ያጌዳ። ያቆብ ባረ አዉ ይሳቅ ያዬዳዋ ሱንꬃን ጫቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ያቆብ ደርያ ቦላን ያርሹዋ ያርሼዳ፤ ባረ ዳቦቱዋካ ቁማ ማናዉ ጼሴዳ። ኡንቱንቱ ሚደ ደርያ ቦላን አቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ዎንተꬃ ጋላስ ጉራን ላብ ደንዲደ፥ ባረ ናና ናናነ ባረ ማጫ ናና የሬዳ፤ ቃይ ኡንቱንታ አንጄዳ። ባረ ሶ ስሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ያቆብ ደንዲደ ባረ ኦግያ ቢሽን፥ ጾሳ ኪታንቻቱ አናና ጋከቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ያቆብ ኡንቱንታ በኤዳ ዎደ፥ “ሀዌ ጾሳይ አቅያ ሳኣ” ያጊደ፥ ሄ ሳኣ ማህናይማ ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ያቆብ ሰኢራ ግያ ሳኣን፥ ኤዶማ ቢታን ደእያ ባረ እሻ ኤሳኮ ኪታ ባረፐ ስንꬃዉ ኪቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","እ ኡንቱንታ ሀዋዳን ያጊደ አዛዜዳ፤ “ህንተንቱ ታ ጎዳ ኤሳዉ ጋናዌ ሀዋ፤ ‘ነ ቆማይ ያቆብ፥ “ታን ላባና ማታን ደኣደ ሀኖ ጋካናዉ ጋምኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ታዉ ሚዛይነ ሀሪ፥ ዶርሳይነ ዴሻይ፥ አቱማ ቆማቱነ ማጫ ቆማቱ ደኢኖ፤ ሀእ ታን ሀ ኪታ ታ ጎዳ ስንꬃን ናሸታና ማላ ኪታድ” ያጌዳ’ ያግተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ኪተቴዳዋንቱ ያቆባኮ ስሚደ አ፥ “ኑን ነ እሻ ኤሳኮ ቤዶ፤ ሀእ እ ቃይ ኔናና ጋከታናዉ ዬ፤ አናና ኦይዱ ጼቱ አሳይ ደኤ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ያቆብ ያዪደ ባትባቴዳ፤ ባረናና ደእያ አሳ ላኡ ጭታን ሻኬዳ፤ ቃይ ባረ ዶርሳ፥ ዴሻ፥ ሚዛነ ጋሉዋ ላኡ ጭታን ሻኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","እ፥ “ኤሳይ ዪደ እት ጭታ ኦልያዋ ግዶፐ፥ አቴዳ ጩጉ ከስ አኮፐነ” ያጊደ ቆፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ሄ ዎደ ያቆብ ሀዋዳን ያጊደ ዎሴዳ፤ “አቤት መꬍና ጎዳዉ፥ ታ አዉዋ አብራሃመ ጾሳዉ፥ ታ አዉዋ ይሳቃ ጾሳዉ፥ ታና፥ ‘ነ ጋድያ፥ ነ ዳቦቱዋኮ ስማ፤ ታን ነዉ ሎኦባ ኦꬃና’ ጌዳዎ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ኔን ነ ቆማዉ ኦꬄዳ ኬካተꬃዉነ ቱማተꬃዉ ኡባዉ ታን በሰናዋ። ታን ሀ ዮርዳኖሳ ሻፋ ፕኔዳ ዎደ፥ ታዉ እት ጻምኣ ጻላላይ ደኤ፤ ሽን ሀእ ታን ላኡ ጩጎ ግዳድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ታን ኔና ዎሳይ፤ ታ እሻ ኤሳ ኩሽያፐ ታና አሻ፤ አያዉ ጎፐ፥ እ ዪደ፥ ታናነ ማጫዋንታ ኡንቱንቱ ናናቱዋካ ꬋይሳናዌንቶነ ጋደ ያያድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ሽን ኔን ታና፥ ‘ታን ነዉ ቱሙ ሎኦባ ኦꬃና፤ ታን ነ ዘረꬃነ ፓይዳናዉ ዳንዳየተና አባ ሻፍያ ኬሻ ኦꬃና’ ጌዳዋ ቆፓ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ሄ ጋላሳ ቃማ እ ያን አቄዳ፤ ባረዉ ደእያዋ ኡባፐ ባረ እሻ ኤሳዉ እምያዋ ቆሪደ ከሴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","እ ከሴዳዋንቱ ላኡ ጼቱ ማጫ ዴሻቱዋነ ላታሙ ዴሻ ኮለቱዋ፥ ላኡ ጼቱ ማጫ ዶርሳቱዋነ ላታሙ ዶርሳ ኮለቱዋ፥ ሀታሙ ꬋንꬅያ ጋሎቱዋ ኡንቱንቱ ማራቱዋና፥ ኦይታሙ ማጫ ሚዛቱዋ፥ ታሙ ኮሩማ ቦራቱዋ፥ ላታሙ ማጫ ሀረቱዋነ ታሙ አቱማ ሀረቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ሀዋንታ ዉድያን ዉድያን ሻክ፥ ባረ ቆማቱዋ ኩሽያን ዎꬂደ፥ ባረ ቆማቱዋ፥ “ታፐ ስንꬃዉ ቢደ፥ ዉድያ ዉድያፐ ሃኩዋን ሃኩዋን ላግተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ስንꬃን ካለꬅያዋ፥ “ታ እሻይ ኤሳይ ኔናና ጋከቲደ ኔና፥ ‘ኔን ኦሴ? ኔን ሀቃ ባይ? ነ ስንꬃን ደእያ መህያ ኡባይ ኦሴ?’ ያጊደ ኦችያዋ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ኔን አዉ፥ ‘ሀዋንቱ ነ ቆማ ያቆባዋ፤ ኡንቱንቱ ታ ጎዳ ኤሳዉ እማናዉ የዴዳዋንታ፤ ቃይ እካ ኑፐ ጉየና ይደኤ’ ያጋ” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ቃይ እ ላኤንꬃ ሄዛንꬁዋነ ዉድያ ካልያ ሀራቱዋ ኡባቱዋ ሀዋዳን አዛዜዳ፤ “ህንተንቱ ኤሳና ጋከትያ ዎደ፥ ሀንዳንካ ጊታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘ነ ቆማ ያቆብ ኑፐ ጉየና ይደኤ’ ጌናን አጎፕተ” ያጌዳ። አያዉ ጎፐ እ፥ “ታን ታፐ ስንꬃዉ እማናዉ ኪቴዳዋን አ ዶሽሳና፤ ኦን ኤሪ፥ ሄዋፐ ጉየ ታን አናና ጋከትያ ዎደ፥ እ ታና ሞክ አካነንቶነ” ያጊደ ቆፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ሄዋ ድራዉ ባረ እምያዋ ባረፐ ስንꬃዉ የዴዳ። ሽን እ ባረ ሁጲያዉ ሄ ጋላስ ቃማ ያን አቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","ሄ ጋላስ ቃማ ያቆብ ደንዲደ፥ ባረ ላኡ ማቻቱዋ፥ ባረ ላኡ ቆማቱዋነ ባረ ናና ታማነ እታቱዋ አኪደ፥ ያቦቃ ግያ ፕኑዋ ጋኬዳ፤ እ ኡንቱንታ ሻፋ ፕንꬄዳ፤ ባረዉ ደእያዋ ኡባካ ፕንꬂደ የዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ሽን ያቆብ ባረካ አቴዳ። ሄ ዎደ እት አሳይ ሳአይ ዎንታና ጋካናዉ አናና ባጸቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ሄ አሳይ አ ጾናናዉ ዳንዳይቤናዋ በኤዳ ዎደ፥ ያቆባዉ ሙቄቻ መቀꬃ ቦቼዳ፤ አ ሙቄቻ መቀꬃይ ከስ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ያትና ብታኒ አ፥ “ሳአይ ዎንቴዳ ድራዉ፥ ታና የዳ” ያጌዳ። ሽን ያቆብ አ፥ “ኔን ታና አንጀናን ታን ኔና የድከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ብታኒ አ፥ “ነ ሱንꬃይ ኦኔ?” ያጊደ ኦቼዳ። እ፥ “ያቆባ” ያጊደ ዛሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ብታኒ አ፥ “ሀዋፐ ስንꬃዉ ነ ሱንꬃይ እስራኤልያ ጌተቶፐ አትና፥ ያቆባ ጌተቶፖ፤ አያዉ ጎፐ፥ ኔን ጾሳናነ አሳና ባጸታደ ጾናዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ያቆብ አ፥ “ነ ሱንꬃይ ኦኔ?” ያጊደ ኦቼዳ። ሽን ብታኒ፥ “ኔን ታ ሱንꬃ አያዉ ኦቻይ?” ያጌዳ ጊደ አ አንጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ሄዋ ድራዉ ያቆብ ሄ ሳኣ ጲንኤላ ጊደ ሱንꬄዳ፤ አያዉ ጎፐ እ፥ “ታን ጾሳ ባዙዋን ጼላድ፤ ግዶፐነ ታን ፓጻ አታድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","እ ጲንኤላፐ ደንድያ ዎደ፥ አ ቦላ ጻልቂ ዶሌዳ። እ ባረ ሙቄቻ መቀꬃ ድራዉ ዶጌ። ");
INSERT INTO dwrENT_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ያቆባ ሙቄቻ አሹዋ ማታን ቦሸቴዳ ድራዉ፥ እስራኤልያ አሳይ መህያ ሙቄቻ አሹዋ ሀቼ ጋካናዉ ሜና። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ያቆብ ꬎቁ ግ ጼሊደ፥ ኤሳይ ባረ ኦይዱ ጼቱ አሳና ይያዋ በኤዳ። ሄዋ ድራዉ ናና ልይዉ፥ ራሄልዉነ ላኡ ቆማቱዋኮ ሻኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ቆማቱዋነ ኡንቱንቱ ናና ስንꬃን፥ ልዮነ እ ናና ኡንቱንቱ ጌዱዋን፥ ራሄሎነ ዮሴፋ ዉርሰꬃን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ሽን እ ባረ ሁጲያዉ ስንꬃዉ አꬊደ፥ ባረ እሻኮ ማቲደ፥ ሳኣ ጋክ ጋኪደ ላፑን ካላ ጎይኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ሽን ኤሳይ አናና ጋከታናዉ ዎጺደ፥ አ ቆꬍያ ቆም የሬዳ። ኡንቱንቱ ዬኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ያትና ኤሳይ ꬎቁ ግ ጼሊደ፥ ማቻቱዋነ ናና በኤዳ፤ እ፥ “ሀ ኔናና ደእያዋንቱ ኦኔ?” ያጊደ ኦቼዳ። ያቆብ፥ “ኡንቱንቱ ጾሳይ ነ ቆማዉ ኬካተꬃን እሜዳ ናና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ቆማቱ ባረንቱ ናናቱዋና ሺቂደ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ሄዋፐ ጉየ፥ ልያነ እዝ ናናይ ዪደ ጎይኔድኖ፤ ዉርሰꬃን ዮሴፎነ ራሄላ ዪደ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ኤሳይ፥ “ሀ ስንꬃን ታናና ጋከቴዳ ዉዲ ኡባይ ቃይ አዬ?” ያጊደ ኦቼዳ። እ፥ “ታ ጎዳዉ፥ ሄዌ ታን ነ ስንꬃን ናሸታናሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ሽን ኤሳይ፥ “ታ እሻዉ፥ ታዉ ዳሮባይ ደኤ፤ ነዌ ኔሳ ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ያቆብ፥ “ቱይት፥ ሀእ ታን ነ ስንꬃን ናሸቴዳዋ ግዶፐ፥ ሀ ታን እምያዋ ታፐ አካ። ኔን ታና ሞካ አኬዳ ድራዉ፥ ታን ነ ዴሙዋ በእያዌ ጾሳ ዴሙዋ በእያዋ ማላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ታን ነዉ አሄዳ ሀ እሙዋ አካ፤ አያዉ ጎፐ፥ ጾሳይ ኬኪደ እምና፥ ታዉ በሴዳ” ያጌዳ። ያቆብ ሾብያ ቶሌዳ ድራዉ፥ ኤሳይ ሄዋ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ሄዋፐ ጉየ ኤሳይ፥ “አነ ደንዳ፤ ኑ ኦግያ ቦይተ፤ ታን ኔናና እትፐ ባና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ሽን ያቆብ አ፥ “ታ ጎዳዉ፥ ናናይ ሹጋ ግድያዋ ኤራሳ፤ ቃይ ታን ባረንቱ ጋሎ ማራቱዋ ꬋንꬅያ ዶርሳቱዋነ ሚዛ ናጋና ኮሼ፤ አሳይ ኡንቱንቱ እት ጋላሳ ድርቢስ ላጎፐ፥ መህያ ኡባይ ሀይቃና። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ሄዋ ድራዉ፥ ታ ጎዳዉ፥ ነ ቆማፐ ስንꬃታደ ባ፤ ታን ሰኢራን ታ ጎዳ ጋካናዉ፥ ታ ስንꬃን ደእያ መህያ ሄመታ ኬናነ ናና ሄመታ ኬና ሎዳን ካላና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ኤሳይ አ፥ “ያቶፐ ታን ታ አሳፐ አማሬዳዋ ነዉ አሻይ” ያጌዳ። ሽን ያቆብ አ፥ “ሄዌ አይሴ? ታን ታ ጎዳ ስንꬃን ናሸትያዌ ታዉ ግዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ሄዋ ድራዉ ኤሳይ ሄ ጋላስ ኦግያን ገሊደ፥ ሰኢራ ስሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ሽን ያቆብ ሱኮታ ቤዳ፤ ያን ባረዉ ጎልያ ኬጼዳ፤ ባረ መሄቶካ ዳስያ ዳሴዳ። ሄዋ ድራዉ ሄ ሳኣ ሱኮታ ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ያቆብ ማስጰጾምያፐ ስሜዳ ዎደ፥ ካናነ ቢታን ደእያ ሰኬመ ግያ ካታማ ሳሮተꬃን ጋኬዳ፤ እ ሄ ካታማዉ ባዙዋን ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ባረ ዱንካንያ ꬎጌዳ ጋድያ ሸኬማ አዉዋ ሀሞራ ናናቱዋፐ ጼቱ ጻጋራ ብራን ሻሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ያን ያርሽያ ሳኣ ኬጺደ አ፥ “ጾሳ፥ እስራኤልያ ጾሳ” ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ልያ ያቆባዉ የሌዳ ናታ ዋና፥ ሄ ዎደ ሄ ጋድያ ማጫዋንታ በአናዉ ከሳዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ሄ ጋድያ ሞድያ ህውያ ሀሞራ ናኣ ሸኬመ እዞ በኢደ፥ እዞ ሆር አፊደ ባይዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","አ ዎዛናይ ያቆባ ናቶ ዲኖ አሞቴዳ፤ እ እዞ ሲቄዳ፤ እዝዉ ሎእያዋ ሃሳዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ሸኬመ ባረ አዉዋ ሀሞራ፥ “ታዉ ሀ ናቶ ማቼተꬃዉ ኦቻርክ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ያቆብ ባረ ናታ ዳና ባዬዳዋ ስስያ ዎደ፥ አ አቱማ ናናይ ዎራን መህያና ደእኖ፤ ሄዋ ድራዉ ኡንቱንቱ ጋካናዉ ጮኡ ጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ሄዋፐ ጉየ፥ ሸኬማ አዉዋ ሀሞር ያቆባና ሃሳያናዉ ዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ያቆባ አቱማ ናናይ ሄዋ ስሴዳ ሳና ዎራፐ ዬድኖ፤ ኡንቱንቱ ካዮቴድኖነ ሀንቀቴድኖ፤ አያዉ ጎፐ፥ ሸኬመ ያቆባ ናቶ ሆር አፊደ ባይዝያዋ፥ እስራኤልያ ቦላ ፖኮባ፥ ኦꬃናዉ በሰናባ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ሽን ሀሞር ኡንቱንታ፥ “ታ ናአይ ሸኬመ ህንተንቱ ናትዉ ዳርስ ዳጋሜዳ፤ ሀያና እዞ አዉ ማቼተꬃዉ እሜርክቴ! ");
INSERT INTO dwrENT_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ኑናና አከትተነ ገለትተ፤ ህንተንቱ ማጫ ናና ኑዉ እምተ፤ ኑ ማጫ ናናነ ህንተንቶ አክተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ህንተንቱ ኑ ግዶን ኡታናዉ ዳንዳዪታ፤ ቢታይ ሎይꬅ አካ፤ አን ደእተ፤ ዛልእተ፤ አን ማጹዋ ደምተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ሄ ዎደ ሸኬመ ዲን አዉዋነ እ እሻቱዋ፥ “ታን ህንተንቱ ስንꬃን ናሸቶፐ፥ ህንተንቱ ኦችያዋ አያ ግዶፐነ እማና። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ህንተንቱ ምሽራ ናትዉ እምያዋነ ጭሎሻ ህንተንቱ ኮዮዋ ኬሻ ዳርሲደ ታና ኦችተ፤ ታን ህንተንቱ ታና ኦቼዳዋ አያነ እማና፤ ሽን ታን አካናዳን ናቶ ታዉ እሜርክቴ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ባረንቱ ምቻቶ ዲኖ ሸኬመ ቱንሴዳ ድራዉ፥ ያቆባ አቱማ ናናይ ሸኬማዉነ አ አዉዋ ሀሞራዉ ዎርዱዋ ኦዴድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ኡንቱንታ ሀዋዳን ያጌድኖ፤ “ኑን ሄዋ ማላ ኦꬃና ዳንዳዮኮ፤ ኑን ኑ ምቻቶ ቃጻረትቤና አሳዉ እሞኮ፤ ሄዌ ኑና ካዉሽያዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ኑን ህንተንቱ እትባ ኦꬆፐ ህንተንቶ፥ ‘ኤኖ’ ጋና፤ ሄዌ አዬ ጎፐ፥ ህንተንቱ ጋድያ አቱማ አሳይ ኡባይ ቃጻረቲደ ኑናዳን ሀኖፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ኑን ኑ ማጫ ናና ህንተንቶ እማናዉ ‘ኤኖ’ ጋና፤ ህንተንቱ ማጫ ናናካ ኑዉ አካና። ኑን ህንተንቱ ግዶን ኡቲደ፥ ህንተናና እት አሳ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ሽን ህንተንቱ ቃጻረታናዉ ኤኖ ጌናዋ ግዶፐ፥ ኑን ኑ ምቻቶ አኪደ ባና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ኡንቱንቱ ጌዳዌ ሀሞራዉነ አ ናኣ ሸኬማዉ ሎአ ማላቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ሄ ዎዳላይ፥ ባረ አዉዋ ጎለን ደእያ ኡባፐ አꬍ ቦንቼቴዳዌ፥ ያቆባ ናትን ናሸቴዳ ድራዉ፥ ኡንቱንቱ ጌዳዋ ኦꬃናዉ ጋምእቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ሄ ዎደ ሀሞርነ አ ናአይ ሸኬመ ባረንቱ ካታማ ጉታራ ቢደ፥ ባረንቱ ካታማ አሳዉ ሀዋዳን ያጊደ ኦዴድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ሀ አሳቱ ኑናና ስጋ፤ ኡንቱንቱ ኑ ቢታን ደኢኖነ ዛልኢኖ፤ ቢታይ ሎይꬅ አካ። ኡንቱንቱ ማጫ ናናካ ኑን አካና፤ ኡንቱንቱካ ኑ ማጫ ናና አካና። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ሽን ኑናና ኡንቱንቱ እት አሳዳን ደአናዉ ኑን እትባ ማየታናዉ ኮሼ፤ ሄዌነ፥ ኡንቱንቱ ቃጻረቴዳዋዳን ኑ አቱማ አሳይ ኡባይ ቃጻረታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ኑን ሄዋዳን ኦꬆፐ፥ ኡንቱንቱ ሚዛይ፥ ኡንቱንቱ ማጹነ ኡንቱንቱ ሀራ መሂ ኡባይ ኑዋ ግደኔ? ሄዋ ድራዉ አነ ኑን ኡንቱንቱ ግያዋ ኤኖ ጎይተ፤ ኡንቱንቱካ ኑ ግዶን ደአና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ካታማ ጉታራ ሺቄዳ አሳቱ ኡባይ ሀሞራዉነ አ ናኣ ሸኬማዉ፥ “ኤኖ” ጌድኖ። ያትና ሄ ካታማ አቱማ አሳቱ ኡባይ ቃጻረቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ሄዘንꬆ ጋላስ፥ ኡንቱንቱ ኡባይ ባረንቱ ቃጻራ ማዱꬃን ሳከት ደእሽን፥ ያቆባ አቱማ ናናቱዋፐ ላኡ፥ ስሞንነ ሌዊ፥ ዲን እሻቱ፥ ባረንቱ ማሻ አኪደ፥ ኦንነ ኤረናን ካታማ ገሊደ፥ አቱማ አሳቱዋ ኡባ ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ሀሞራነ አ ናኣ ሸኬማ ማሻን ዎꬊደ፥ ባረንቱ ምቻቶ ዲኖ ሸኬማ ጎልያፐ አኪደ አፌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ያቆባ አቱማ ናናይ ሄ አሃቱዋ ቦላ ገሊደ፥ ባረንቱ ምቻቶ ዲኖ ቱንሴዳ ካታማ ቦንቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ኡንቱንቱ ዶርሳ ዉድያ፥ ሚዛ ዉድያ፥ ሀርያ፥ ካታማ ግዶን ደእያዋነ ጋጻን ደእያዋ ኡባ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ኡንቱንቱ ማጹዋ ኡባ፥ ኡንቱንቱ ናና ኡባነ ማቻቱዋ ኡባ ኦሞዴድኖ፤ ጎለን ደኤዳዋ ኡባ ቦንቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ያቆብ ስሞናነ ሌዊያ፥ “ህንተንቱ ታ ቦላ መቱዋ አህ ክቼድታ፤ ሀ ጋድያን ደእያ ካናናቱነ ፓርዘቱ ታና እጻናዋንታ፤ ኑን ፓይዱዋን ጉꬃ፤ ኡንቱንቱ እትፐ ግዲደ ታ ቦላ ደንዶፐ፥ ታንነ ታ ሶ አሳይ ꬋያና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ሽን ኡንቱንቱ፥ “ያትና እ ኑ ምቻቶ ሻርሙጻዳን ኦꬃና በሲ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ጾሳይ ሄዋፐ ጉየ ያቆባ፥ “ደንዳደ ፑደ ቤቴለ ባደ ያን ደአ። ኔን ነ እሻ ኤሳፐ ባቃትያ ዎደ ነዉ ቆንጬዳ ጾሳዉ ያን ያርሽያ ሳኣ ኬጻ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ያቆብ ባረ ሶ አሳነ ባረናና ደእያዋንታ ኡባ፥ “ህንተንቱ ግዱዋን ደእያ አላጋ ጾሳቱዋ ምስለቱዋ ድግተ፤ ህንተንቱ ቦላ ጌሽተ፤ ህንተንቱ ማዩዋነ ላምተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","አነ ደንዲደ፥ ፑደ ቤቴለ ቦይተ፤ ታ መቱዋ ጋላስ ታና ስሴዳ፥ ታን ቤዳ ሳኣን ኡባን ታናና ግዴዳ ጾሳዉ፥ ታን ያን ያርሽያ ሳኣ ኬጻና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ሄዋ ድራዉ ኡንቱንቱ ባረንቶ ደእያ አላጋ ጾሳቱዋ ምስለቱዋ ኡባነ ባረንቱ ሀይꬃን ደእያ ጉድቻ ኡባ ያቆባዉ እሜድኖ፤ ያቆብ ሄዋንታ ሰኬማን ደእያ ዎላ ጋርሳን ሞጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ሄዋፐ ጉየ፥ ያቆብነ አ አቱማ ናናይ ደንዲደ ቢሽን፥ እት ኡራይነ ኡንቱንታ ኦይቃናዉ ካልቤና፤ አያዉ ጎፐ፥ ኡንቱንቱ ቢሽን፥ ኡንቱንቱ ዩሹዋን ደእያ ካታማ አሳ ኡባ ቦላ ጾሳ ዳጋማይ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ያቆብነ አናና ደእያ አሳይ ኡባይ ካናነ ጋድያን ደእያ (ቤቴለ ግያ) ሎዛ ጋኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ያን እ ያርሽያ ሳኣ ኬጼዳ፤ እ ሄ ሳኣ ኤል-ቤቴለ ጊደ ሱንꬄዳ፤ አያዉ ጎፐ፥ እ ባረ እሻፐ ባቃቲደ ብያ ዎደ፥ ጾሳይ አዉ ቆንጬዳ ሳአይ ሄዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ርብቆ ድችያ ደቦራ ያን ሀይቃዱ፤ ቤቴለፐ ህርክና ደእያ ዎላ ጋርሳን እዛ ሞገታዱ፤ ሄዋ ድራዉ ሄ ምꬃ ሱንꬃይ ዬኩዋ ዎላ ጌተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ያቆብ ማስጰጾምያፐ ስሜዳዋፐ ጉየ፥ ጾሳይ አዉ ዛረꬅ ቆንጪደ፥ አ አንጄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ጾሳይ አ፥ “ነ ሱንꬃይ ያቆባ፤ ሽን ሀዋፐ ስንꬃናዉ ኔን ኡባካ ያቆባ ጌተታካ፤ ነ ሱንꬃይ እስራኤልያ ግዳና” ያጊደ እ አ እስራኤልያ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ቃይ ጾሳይ ያቆባ፥ “ታን ኡባ ዳንዳይያ ጾሳ፤ ኔን የለታ፤ ጮራታ፤ ካዉተꬃቱነ ካዉተꬃ አሳይ ኔፐ ከሳና፤ ካተቱካ ነ ጉልባታፐ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ታን አብራሃመዉነ ይሳቃዉ እሜዳ ቢታ፥ ቃይ ነዉ እማይ፤ ኔፐ ጉየና ታን ሀ ቢታ ነ ዘረꬃዉ እማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ሄዋፐ ጉየ፥ ጾሳይ አናና ሃሳዬዳ ሳኣፐ ፑደ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ያቆብ ጾሳይ ባረናና ሃሳዬዳ ሳኣን ሹቻ ኤሲደ፥ አ ቦላ ኡሻ ያርሹዋ ትጌዳ፤ ዛይትያካ ቦላ ትጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ያቆብ ጾሳይ ባረናና ሃሳዬዳ ሳኣ “ቤቴለ” ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ኡንቱንቱ ሄዋፐ ጉየ፥ ቤቴለፐ ደንዴድኖ። ኡንቱንቱ ኤፍራታ ጋካናዉ ላፋ አሽያ ዎደ፥ ራሄሎ የሉ ኦይቄዳ፤ የሉዋን እዛ ሎይꬃ ዋየታዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","የሉ እዞ ዋይሴዳ ዎደ እዞ የልስያና፥ “ያዮፓ፤ ሀዌካ አቱማ ናኣ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ሽን እዛ ሀይቃደ፥ ሸምፑ ከስሽን፥ ባረ ናኣ ቤንኦና ሱንꬃዱ፤ ሽን አ አዉ አ ቢንያማ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ሄዋፐ ጉየ፥ ራሄላ ሀይቃ ባሻዱ፤ ቤተሌመ ግያ ኤፍራታ አፍያ ኦግያ ዶናን ሞገታዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ያቆብ እዝ ዱፉዋን ሀዉልትያ ሹቻ ኤሴዳ፤ ሄ ሀዉልቲ ሀቼ ጋካናዉ ራሄል ዱፉዋ ኤርሴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","እስራኤሊ ሄዋፐ ደንዲደ፥ ኤደራ ግምቢያፐ ሄፍንꬃን ባረ ዱንካንያ ቶኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","እስራኤሊ ሄ ጋድያን ደእሽን፥ ሮቤል ቢደ፥ ባረ አዎ የሌዳ ቆማቲ ባልና ግሴዳ። እስራኤሊ ሀ የዉዋ ስሴዳ። ያቆባ አቱማ ናናይ ታማነ ላአ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ልያ ናናይ ያቆባ ባይራ ናኣ ሮቤላ፥ ስሞና፥ ሌዋ፥ ይሁዳ፥ ይሳኮራነ ዛብሎና። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ራሄል አቱማ ናናይ ዮሴፋነ ቢንያማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ራሄል ዳንጋጽራት ባል አቱማ ናናይ ዳናነ ንፍታሌማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ልያ ዳንጋጽራት ዝልፕ አቱማ ናናይ ጋዳነ አሴራ። ሀዋንቱ ማስጰጾምያን ያቆባዉ የለቴዳ አ አቱማ ናና። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ያቆብ (ከብሮና ግያ) ቅርያት-አርባአ ማታን ማምረን ደእያ፥ ባረ አዉዋ ይሳቃ ሶ ዬዳ፤ ሄ ሳአይ ካሰ አብራሃመነ ይሳቅ ደኤዳ ሳኣ። ");
INSERT INTO dwrENT_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ይሳቅ ጼታነ ሆስፑን ታሙ ላይꬃ ደኤዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","እ ዳሮ ዎድያ ደኢደ፥ ሎኦ ጭም ሀይቂደ ባረ ማይዛን ጋከቴዳ። አ ናናይ ኤሳይነ ያቆብ አ ሞጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ኤዶማ ግያ ኤሳ የለታይ ሀዋፐ ካሊደ ጻፈቴዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ኤሳይ ካናነ ቢታ ማጫ ናናቱዋፐ ባረዉ ማቼቱዋ አኬዳ፤ ኡንቱንቱነ ሂትያ ኤሎና ናቶ አዶ፥ ሂውያ ጽባኦና ናአይ አን የሌዳ ኦሆሊባሞነ ");
INSERT INTO dwrENT_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","እስማኤላ ናቶ፥ ናባዮታ ምቻቶ ባሰማቶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","አዳ ኤሳዉ ኤልፋዛ የላዱ፤ ባሰማታካ ራኡኤላ የላዱ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ኦሆሊባማ ያኡሻ፥ ያእላማነ ቆራሀ የላዱ፤ ካናነ ጋድያን ኤሳዉ የለቴዳ አቱማ ናናይ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ኤሳይ ባረ ማቼቱዋ፥ ባረ አቱማ ናናነ ማጫ ናና፥ ባረ ሶ አሳ ኡባ፥ ባረ ሚዛቱዋነ ባረ መህያ ኡባ ካናነ ጋድያን እ ሞዴዳዋ ኡባ አኪደ፥ ባረ እሻ ያቆባፐ ሃክያ ጋድያ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ኡንቱንቱ ማጹ ዳሬዳ ድራዉ፥ ኡንቱንቱ እትፐ ደአናዉ ዳንዳይበይክኖ፤ ኡንቱንቱ መሂ ዳሬዳ ድራዉ፥ ኡንቱንቱ ደእያ ቢታይ ኡንቱንቱ መህያው ግዳናዉ ዳንዳይቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ያትና ኤዶማ ግያ ኤሳይ ሰኢራ ግያ ገዝያን ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ሰኢራ ገዝያን ደኤዳ ኤዶማቱዋ አዉዋ ኤሳ የለታይ ሀዋፐ ካሊደ ጻፈቴዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ሀዌ ኤሳ አቱማ ናና ሱንꬃ፤ ሄዋንቱነ ኤሳ ማቻት አድ ናኣ ኤልፋዛነ ኤሳ ማቻት ባሰማት ናኣ ራኡኤላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ኤልፋዛ ናናይ ተማና፥ ኦማራ፥ ጻፋ፥ ጋእታማነ ቃናዛ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ቃይ ትምናአ ኤሳ ናኣ ኤልፋዛዉ ቆማቱዋ፤ እዛ ኤልፋዛዉ አማሌቃ የላዱ። ሀዋንቱ ኤሳ ማቻት አድ ናኣ ናና። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ራኡኤላ አቱማ ናናይ ናሃታ፥ ዛራሀ፥ ሻማነ ሚዛ፤ ሀዋንቱ ኤሳ ማቻት ባሰማት ናኣ ናና። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ጽባኦና ናአይ አን የሌዳ ኦሆሊባማ አቱማ ናናይ ሀዋንታ፤ እዛ ኤሳዉ ያኡሻ፥ ያእላማነ ቆራሀ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ኤሳ የለታ ካፓቱ ሀዋፐ ካሊደ ጻፈቴዳዋንታ። ኤሳዉ ባይራ ናኣ ኤልፋዛ አቱማ ናናይ፥ ካፑዋ ግዴዳዋንቱ ተማና፥ ኦማራ፥ ጻፋ፥ ቃናዛ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ቆራሀ፥ ጋእታማነ አማሌቃ፤ ኤዶማ ቢታን ኤልፋዝ የሌዳ ካፓቱ ሀዋንታ፤ ሀዋንቱ ኡባይ አድ ናኣ ናና። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ኤሳ ናኣ ራኡኤላ አቱማ ናናይ፥ ካፑዋ ግዴዳዋንቱ ናሃታ፥ ዛራሀ፥ ሻማነ ሚዛ፤ ኤዶማ ቢታን ራኡኤል የሌዳ ካፓቱ ሀዋንታ፤ ኡንቱንቱ ኤሳ ማቻት ባሰማት ናኣ ናና። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ኤሳ ማቻት ኦሆሊባም አቱማ ናናይ፥ ካፑዋ ግዴዳዋንቱ ያኡሻ፥ ያእላማነ ቆራሀ፤ ኡንቱንቱ አና ናት፥ ኤሳ ማቻት ኦሆሊባምፐ የለቴዳ ካፓቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ኤዶማ ግያ ኤሳ አቱማ ናናይ ሀዋንታ፤ ኡንቱንቱ ካፓቱካ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ኤዶማ ጋድያን ደእያ ሆርያ ሰኢራ አቱማ ናናይ ሀዋፐ ካሊደ ጻፈቴዳዋንታ፤ ሄዋንቱካ ሎጻና፥ ሾባላ፥ ጽባኦና፥ አና፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ድሾና፥ ኤጼራነ ድሻና፤ ሄዋንቱ፥ ኤዶማ ጋድያን ደእያ ሰኢራ አቱማ ናናይ፥ ሆረቱዋ ካፓቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ሎጻና አቱማ ናናይ ሆራነ ሄማማ፤ ሎጻና ምቻታ ትምናኦ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ሾባላ አቱማ ናናይ አልዋና፥ ማናሃታ፥ ኤባላ፥ ሸፋነ ኦናማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ጽባኦና አቱማ ናናይ አያነ አና፤ ሀዌ አን ዎራን ባረ አዉዋ ጽባኦና ሀረቱዋ ሄሚደ ሃꬃ ቦልኡዋ ደሜዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","አና ናአይ ድሾና፤ ናታ ቃይ ኦሆሊባሞ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ድሾና አቱማ ናናይ ሄምዳና፥ ኤሽባና፥ ይትራናነ ካራና። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ኤጼራ አቱማ ናናይ ብልሃና፥ ዛእዋናነ አቃና። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ድሻና አቱማ ናናይ ኡጻነ አራና። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ሆረቱዋ ካፓቱ ሀዋንታ፤ ሎጻና፥ ሾባላ፥ ጽባኦና፥ አና፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ድሾና፥ ኤጼራነ ድሻና። ሀዋንቱ ሰኢራ ቢታን ባረንቱ ያራን ያራን ሻከቴዳ ሆረቱዋ ካፓቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","እስራኤላን ካቲ ካዉታናፐ ካሰ ኤዶማ ቢታን ካተቴዳ ካተቱ ሀዋፐ ካሊደ ጻፈቴዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ባኦራ ናአይ በላእ ኤዶማን ካተቴዳ፤ አ ካታማ ሱንꬃይ ድናባ ጌተቴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","በላእ ሀይቂና፥ ቦጽራፐ ዬዳ ዛራሀ ናአይ ዮባብ ካተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ዮባብ ሀይቂና፥ ተማና ቢታፐ ዬዳ ሁሻም ካተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ሁሻም ሀይቂና፥ ባዳዳ ናአይ ሀዳድ፥ ምድያማ አሳ ሞኣበ ጋድያን ጾኔዳዌ ካተቴዳ፤ አ ካታማ ሱንꬃይ አዊታ ጌተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ሀዳድ ሀይቂና፥ ማስሬቃፐ ዬዳ ሳምል ካተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ሳምል ሀይቂና፥ ሻፋ ማታን ደእያ ራሆቦታፐ ዬዳ ሻኡል ካተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ሻኡል ሀይቂና፥ አክቦራ ናአይ ባኣልሀናን ካተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","አክቦራ ናኣ ባኣልሀናን ሀይቂና፥ ሀዳር ካተቴዳ፤ አ ካታማ ሱንꬃይ ፓኡ ጌተቴ፤ አ ማቻታ መዛሃባ ናታ ማጽሬዳ የሌዳ ማሄጻብኤሎ ጌተታዉ። ");
INSERT INTO dwrENT_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ኤሳ የለታ ካፓቱ ባረንቱ ያራን ያራን፥ ባረንቱ ሳኣን ኤለካ ባረንቱ ሱንꬃን ሱንꬃን ሀዋንታ፤ ትምናአ፥ አልዋ፥ የቴታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ኦሆሊባማ፥ ኤላ፥ ፒኖና፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ቃናዛ፥ ተማና፥ ምብጻራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ማግድኤላነ እራማ። ሀዋንቱ ባረንቱ ሞድያ ቢታን፥ ባረንቱ ደእያ ሳኣን ደእያ ሳኣን ኤዶማ ካፓቱዋ። ሀዌ ኤሳይ፥ ኤዶማቱዋ አዉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ያቆብ ባረ አዉ ደኤዳ ካናነ ቢታን ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ያቆባ ናናይ ሀኔዳባይ ሀዋፐ ካሊደ ጻፈቴዳዋ። ዮሴፎ ታማነ ላፑን ላይꬃ ናኣ ግዴዳ ዎደ፥ ባረ አዎ ሀራ ማቼቱዋፐ፥ ባልፐነ ዝልፕፐ የለቴዳ ባረ እሻቱዋና ዉድያ ሄመ። ሄ ዎደ እ ባረ አዎ ኡንቱንቱ ኦꬄዳ ኢታባ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","እስራኤሊ ዮሴፋ ጭሚደ የሌዳ ድራዉ፥ ባረ ሀራ አቱማ ናና ኡባፐ አꬂደ ሲቄ። እ አዉ አሌቄዳ ማዩዋ ጊግሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","አ እሻቱ ባረንቱ አዉ አ ኡንቱንቱፐ አꬂደ ሲቅያዋ በኤዳ ዎደ፥ ኡንቱንቱ አ እጺደ፥ ሎኦ ቃላ አዉ ሃሳያናዉ ዳንዳይበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ዮሴፎ አኩሙዋ አኩመቲደ፥ ባረ እሻቶ ኦዴዳ፤ ኡንቱንቱ አ ያ ዳርሲደ እጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","እ ኡንቱንታ፥ “ታን አኩመቴዳ አኩሙዋ ስስተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ኑን ጋደን ፖችያ ቃችሽን፥ ታ ምርቂ እት ኩꬃን ደንዲደ ስት ግ ኤቂሽና፥ ህንተንቱ ምርቀቱ ዩይ አꬊደ ታ ምርቂያዉ ጎይኔድኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","አ እሻቱ አ፥ “ኔን ኑ ቦላን ካተታና ሀናይዬ? ዎይ ኑና ቱሙ ሞዳና ሀናይዬ?” ያጌድኖ። ኡንቱንቱ አ አኩሙዋ ድራዉነ አ ኦዱዋ ድራዉ፥ ያ ዳርሲደ እጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ቃይ ዮሴፎ ሀራ አኩሙዋ አኩመቲደ፥ ባረ እሻቶ ኦዴዳ፤ “ስስተ፤ ታን ሀራ አኩሙዋካ አኩመታድ። ሄ አኩሙዋን አዋይ፥ አግናይነ ታማነ እት ጾልንተቱ ታዉ ጎይኒኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ባረ አዎነ ባረ እሻቶ ሄ አኩሙዋ ኦዴዳ ዎደ፥ አ አዉ አ፥ “ሀዌ ኔን አኩመቴዳዌ አያ አኩሜ? ቱሙ ታን፥ ነ ዳያነ ነ እሻቱ ዪደ፥ ነ ስንꬃን ሳኣን ጉፋኒደ ነዉ ጎይናነየ?” ያጊደ ሴሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","አ እሻቱ አ ቃናቴድኖ፤ ሽን አ አዉ ሀ የዉዋ ባረ ዎዛናን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","እት ጋላስ አ እሻቱ ሰኬማ ማታን ባረንቱ አዉዋ ዶርሳ ሄማናዉ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","እስራኤሊ ዮሴፋ፥ “ነ እሻቱ ሰኬማን ዉድያ ሄምያዋ ኤራሳ። ሃያ፤ ታን ኔና ኡንቱንቱኮ ኪታና” ያጌዳ። ዮሴፎ፥ “ኤኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","እ አ፥ “ባ፤ ነ እሻቱዋነ ዉዲ ሳራ ግድያዋ በአ፤ ኡንቱንቱባ ታዉ ኦዳሳ” ያጌዳ። አ ከብሮና ድልባፐ ኪቴዳ። እ ሰኬማ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ያን ደምባ ግዶን ያ ሃ ስመረትሽን፥ እት አሳይ አ ደሚደ፥ “ላ አያ ኮያይ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","እ፥ “ታ እሻቱዋ ኮያይ፤ ኡንቱንቱ ዉድያ ሄምያ ሳአይ ሀቃነንቶ ሀያና ታዉ ኦዳርኪ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ብታኒ፥ “ሀዋፐ ደንድ ክቼድኖ፤ ኡንቱንቱ፥ ‘ኑን ዶታና በቶ’ ጊሽን ስሳድ” ያጌዳ። ሄዋ ድራዉ፥ ዮሴፎ ባረ እሻቱዋ ጌዱዋ ቢደ፥ ኡንቱንታ ዶታናን ደሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ሽን እ ሃኩዋን ደእሽን፥ ኡንቱንቱ አ በኤድኖ፤ እ ኡንቱንቱኮ ጋከናን ደእሽን፥ ኡንቱንቱ አ ዎꬋናዉ አ ቦላ ማቀቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","እቱ እቱዋ፥ “በእተ! አኩሙዋው የ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ሃይተ፤ አ ዎꬊደ፥ ሀ ኦላቱዋፐ እቱዋ ግዶ የጎይተ። ሄዋፐ ጉየ፥ ‘ኢታ ዶአይ አ ሜዳ’ ያጋና፤ ያቲደ አ አኩሙ አህያዋ በአና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ሮቤል ሄዋ ስሴዳ ዎደ፥ ኡንቱንቱ ኩሽያፐ አ አሻናዉ ኮዪደ፥ “አ ዎናን አጎይተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ሱꬃ ጉሶፕተ፤ አ ህንተንቱ ዎራን ደእያ ሀ ኦላ ግዶ ኦልተ፤ አ ቦላ ኩሽያ ዎꬆፕተ” ያጌዳ። ሮቤል ሀዋ አ ኡንቱንቱፐ አሺደ ጉየ አ አዉዋኮ የዳናዉ ጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ዮሴፎ ባረ እሻቱዋኮ ጋኬዳ ዎደ፥ እ ማዬዳ አሌቄዳ ማዩዋ አፐ ቃር አኬድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","አ አፊደ ሃꬃይ ባይና መላ ኦላን የጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ኡንቱንቱ ባረንቱ ቁማ ማናዉ ኡት ደእሽን፥ እስማኤላ አሳቱ ግብጼ ባናዉ ጋላኣደፐ ይያዋንታ ꬎቁ ጊደ በኤድኖ፤ ኡንቱንቱ ባረንቱ ጋሉዋን ሳዉዋ፥ ባላሳነ ግያ ꬋልያነ ካርቢያ ጫን ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ይሁዳይ ባረ እሻቱዋ፥ “ኑን ኑ እሻ ዎꬊደ አ ሱꬃ ቆስያዋ ግዶፐ ኑና አያ ጎኢ? ");
INSERT INTO dwrENT_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ሃይተ፤ አ እስማኤላቶ ዛልኦይተ፤ አ ቦላ ኑ ኩሽያ ዎꬆኮ፤ አያዉ ጎፐ፥ እ ኑ እሻ፥ ኑ አሹዋ” ያጌዳ። አ እሻቱ ማየቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ሄዋ ድራዉ ምድያማ ቢታ ዛልአንቻቱ ሄዋና አꬍሽን፥ አ እሻቱ ዮሴፋ ኦላፐ ከሲደ፥ እስማኤላ አሳቶ ላታሙ ጻጋራ ብራን ዛልኤድኖ። ኡንቱንቱ ዮሴፋ ግብጼ ጋድያ አፌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ሮቤል ኦላኮ ስሚደ፥ ዮሴፎ ያን ባይናዋ በኤዳ ዎደ፥ ካዮቲደ ባረ ማዩዋ ፖሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","እ ጉየ ባረ እሻቱዋኮ ቢደ፥ “ናአይ ያን ባዋ፤ ሀእ ታን ሀቃ ቦሻ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ሄዋፐ ጉየ ኡንቱንቱ ዮሴፎ ማዩዋ አኪደ፥ ዴሻ ኦርግያ ሹኪደ፥ ሄ ሱꬃን ናቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","አሌቄዳ አ ማዩዋ ባረንቱ አዉዋኮ አፊደ አ፥ “ኑን ሀዋ ደሜዶ፤ ሀዌ ነ ናኣ ማየንቶነ አነ ጼላ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ማዩዋ እ ኤሪደ፥ “ሀዌ ታ ናኣ ማዩዋ! ዎራ ዶአይ አ ም ድጌዳ። ዮሴፎ ቱሙካ ዱጸረት ክቼዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ያቆብ ካዮቲደ፥ ባረ ማዩዋ ፔꬌዳ፤ ባረ ጼሳን ዋሩዋ ዳንጪደ፥ ባረ ናአዉ ዳሮ ጋላሳ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","አ አቱማ ናናይነ ማጫ ናናይ ኡባይ አ ምንꬃናዉ ዬድኖ፤ ሽን እ ምነናን እጺደ፥ “ቱይት፥ ታን ዬካደ ታ ናኣኮ ባደ፥ ዱፉዋን ገላና” ያጊደ፥ አ አዉ አዉ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ሄ ዎደ ሚድያማ ቢታ አሳቱ ዮሴፋ ግብጼ ካትያ ኦሳንቻ ጶጽፋራዉ ግብጼን ዛልኤድኖ፤ እ ናግያዋንቱ ካፑዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ሄ ዎደ ይሁዳይ ባረ እሻቱዋፐ ሻከቲደ፥ አዱላማ ግያ ካታማን ደእያ ሂራ ግያ ብታንያና ደአናዉ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ያን ይሁዳይ ሹአ ግያ ካናነ ናትና ጋከቴዳ፤ እ እዞ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","እዛ አዉ ሻሃራደ አቱማ ናኣ የላዱ፤ አ ኤራ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ቃይካ ሻሃሮ ዎደ አቱማ ናኣ የላዱ፤ አ ኦናና ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ቃይ ጉጃደካ አቱማ ናኣ የላዱ፤ አ ሼላ ሱንꬃዱ። እዛ የሌዳዌ አክዚባ ግያ ቢታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ይሁዳይ ባረ ባይራ ናኣ ኤራዉ ትእማሮ ግያ ማቻቶ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ይሁዳ ባይራ ናአይ፥ ኤር፥ መꬍና ጎዳ ስንꬃን ኢታ አሳ ግድያ ድራዉ፥ መꬍና ጎዳይ አ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ይሁዳይ ኦናና፥ “ነ እሻ ማቻትኮ ገላደ፥ እዞ አካ፤ ነ እሻዉ ናኣ የላደ አ ጼስሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ሽን ኦናን የለትያ ናናይ ባረዋንታ ግደናዋ ኤሬዳ፤ ሄዋ ድራዉ ባረ እሻ ማቻትና ግስያ ዎደ አዉደነ፥ ባረ እሻዉ ናእ የለተና ማላ፥ ባረ ዘረꬃ ቢታን ጉሴ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","እ ኦꬄዳባይ መꬍና ጎዳ ስንꬃን ኢታባ ግዴዳ ድራዉ፥ መꬍና ጎዳይ አካ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ሄዋፐ ጉየ፥ ይሁዳይ ባረ ናኣ ማቻቶ ትእማሮ፥ “ታ ናአይ ሼል ድጫና ጋካናዉ ነ አዉዋ ሶ ባደ፥ አምኤተꬃን ደአሻ” ያጌዳ። ሄዋ እ አያዉ ጌደ ጎፐ፥ እካ ባረ እሻቱዋዳን ሀይቃነንቶነ ጊደ ህርጌዳ ድራሳ። ሄዋ ድራዉ ትእማራ ባደ ባረ አዉዋ ሶን ደኣዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ዳሮ ዎድያፐ ጉየ ይሁዳ ማቻታ፥ ሹአ ናታ ሀይቃዱ። ይሁዳይ ባረ ካዩዋፐ ምነቴዳ ዎደ፥ ባረ ዶርሳ እስክያ ሜድያ አሳቱዋኮ ትምና ከሴዳ፤ ቃይ አ ላገ፥ አዱላምያ ሂር አናና ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","አሳይ ትእማሮ፥ “በአ፤ ነ ቦሉ ይሁዳይ፥ ባረ ዶርሳቱዋ እስክያ ሜዳናዉ ትምና ከሴዳ” ያጊደ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","እዛ ባረ አምኤተꬃ ማዩዋ ቃራዱ፤ ባረና ባለꬃናዉ ሻሽያ አካደ ጉሎታዱ። ትምና አፍያ ኦግያ ዶናን ደእያ ኤናይማ ካታማ ፐንግያን ኡታዱ። ሄዋ እዛ ኦꬄዳዌ፥ ሼል ድጭ ጋክንካ እዛ አዉ ማቻቶ ግዳናዉ እመታቤናዋ ኤሬዳ ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ይሁዳይ እዞ በኤዳ ዎደ፥ ሻርሙጻቶ ጊደ ቆፔዳ፤ አያዉ ጎፐ፥ እዛ ባረ ዴሙዋ ጉሎታ ኡታዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ባረ ናኣ ማቻቶ ግድያዋ ኤረናን ደኢደ፥ ኦግያ ጋጻ ኢኮ ሺቂደ እዞ፥ “ታናና ግሳርኪ!” ያጌዳ። እዛ፥ “ታን ኔናና ግሶፐ፥ ኔን ታዉ አያ እማኒ?” ያጋደ ኦቻዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","እ፥ “ታን ታ ዉድያፐ እት ዴሻ ማራ ነዉ የዳና” ያጌዳ። እዛ፥ “ኔን ሄዋ ታዉ የዳና ጋካናዉ አያ ኦꬃኒ?” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","እ፥ “አያ ኦꬆ?” ያጌዳ። እዛ፥ “ነ ማታፋ ዎꬅያ ምግዱዋ፥ አ አꬅያ ሳቂያነ ነ ኩሽያን ደእያ ጋትማ ኦይꬃ” ያጋዱ። እ ሄዋንታ እሚደ፥ እዝና ግስና፥ እዛ አዉ ሻሃራዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","እዛ ሄዋፐ ደንዳደ ቤዳዋፐ ጉየ፥ ባረ ጉሎꬃ ሻሽያ ቃራደ፥ ባረ አምኤተꬃ ማዩዋ ማያዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ይሁዳይ ባረ ኦይꬄዳዋ ሄ ምሽራትፐ ዛር አካናዉ ዴሻ ማራ ባረ ላግያ አዱላማ ቦላ እዝዉ ኪቴዳ፤ ሽን እ እዞ ደምቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","እ ሄ ቢታ አሳ፥ “ኤናይማ ካታማን፥ ኦግያ ዶናን ኡቴዳ ሻርሙጻ ምሽራታ ሀቃኔ?” ያጊደ ኦቼዳ። አሳይ፥ “ሻርሙጻ ማጫውና ሀዋን ኡባካ ባዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","እ ይሁዳኮ ስሚደ አ፥ “ታን እዞ ደማበይከ፤ ሄዋ ቦላካ ሄ ቢታ አሳይ፥ ‘ሻርሙጻ ማጫውና ሀዋን ኡባካ ባዋ’ ያጌዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ይሁዳይ፥ “ባረ ኦይቄዳዋ ባረዉ አኩ፤ ሄዌ ꬋዮፐ፥ አሳይ ኑና ሚጫና። ስም ታን እዝዉ ዴሻ ማራ የዳድ፤ ሽን ኔን እዞ ደማበይካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ሄዙ አግና ኬሻፐ ጉየ አሳይ፥ “ነ ናኣ ማቻታ ትእማራ ሻርሙጻደ ሻሃራዱ” ያጊደ ይሁዳዉ ኦዴዳ። ይሁዳይ፥ “እዞ ካረ ከሲደ ታማን ጹግተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","እዞ ካረ ከስያ ዎደ፥ “ታን ሻሃሬዳዌ ሀ ሚሻ ጎዳሳ፤ በአ፤ ሀ ማታፋ ዎꬅያ ምግዱ፥ አ አꬅያ ሳቂነ ጋትማይ ኦዌንቶ ኤራና ዳንዳዮፐ ኤራ” ያጋደ ባረ ቦሎ ኪታ ኪታዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ይሁዳይ ሄ ሚሻቱዋ ኤሪደ፥ “ታፐ እዛ ጽላ፤ አያዉ ጎፐ፥ ታን እዞ ታ ናኣ ሼላዉ እማበይከ” ያጌዳ። ሄዋፐ ጉየ፥ እ እዝና ዛር ግስቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","እዛ የላና ሀንያ ዎደ፥ እዝ ኡሉዋን ማንተ አቱማ ናናይ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","እዛ የልሺን፥ ኡንቱንቱፐ እቱ ባረ ኩሽያ ከሴዳ፤ ማርስያና፥ “በእተ፤ ሀዌ ኮይሮ ከሴዳ” ጋናዉ ዞኦ ቁንጩትያ አካደ አ ኩሽያን ቃቻዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ሽን እ ባረ ኩሽያ ጉየ አኬዳ ዎደ፥ አ እሻይ ከሴዳ፤ እዛ፥ “ኔን ዋና ፖርꬁ ጋደ ከሳዲ!” ያጋዱ። ሄዋ ድራዉ፥ ፓሬሳ ጋደ አ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ሄዋፐ ጉየ፥ አ ኩሽያን ዞኦ ቁንጩቲ ደእያ አ እሻይ ከሴዳ፤ አ ሱንꬃይ ዛራሀ ጌተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","እስማኤላ አሳቱ ዮሴፋ ግብጼ አፍ ዎꬄድኖ። ግብጻዌ ጶጽፋር፥ ካትያ ኦሳንቻቱዋፐ እቱ፥ ናግያዋንቱ ካፑ ዮሴፎ እስማኤለቱዋፐ ሻሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","መꬍና ጎዳይ ዮሴፎና ደኤ፤ ሄዋ ድራዉ፥ እ ኦꬅያዋ ኡባ አዉ እንጀዬዳ፤ ያትና ባረ ጎዳ፥ ግብጻዊያ ሶን ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","መꬍና ጎዳይ አናና ደእያዋነ መꬍና ጎዳይ እ ኦꬄዳዋ ኡባ አዉ ሱርስያዋ ጶጽፋር በኤዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ዮሴፎ አ ስንꬃን ናሸቴዳ፤ እ አዉ ኪተቴዳ። ጶጽፋር አ ባረ ጎለ አሳ ቦላ ሱንꬄዳ፤ ባረዉ ደእያዋ ኡባ አ ኩሽያን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ጶጽፋር ባረ ጎለን ደእያዋ ኡባ ቦላነ ባረ ማጹዋ ኡባ ቦላ ሱንꬄዳ ዎድያፐ ዶሚደ፥ መꬍና ጎዳይ ግብጼ ብታንያ ጎሊያ ዮሴፎ ድራዉ አንጄዳ። መꬍና ጎዳ አንጁ ጶጽፋራ ሶንነ ጋደን ደኤዳ ኡባባ ቦላ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ሄዋ ድራዉ ባረዉ ደእያ ኡባባ ዮሴፎዉ ሼꬌዳ፤ እ ባረ ምያ ቁማፐ አትና፥ አይነ ቆፐና። ዮሴፎ ጌሳንቻነ ማላ ሎኦ አሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","አማሬዳ ዎድያፐ ጉየ፥ አ ጎዳ ማቻታ ዮሴፋ ጼላ በኣደ፥ “ሃያ፤ ታናና ግሳ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ሽን እ እጼዳ። ባረ ጎዳ ማቻቶ፥ “በአ፤ ታ ጎዳይ ታዉ ሼꬊደ ባረ ሶን ደእያባዉ አያዉነ ህርገና፤ ባረዉ ደእያዋ ኡባ ታ ኩሽያን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ሀ ሶን ታፐ ግታትያዌ ኦንነ ባዋ። ኔን አ ማቻቶ ግድያ ድራዉ ነ ጻላላፐ አትና፥ ታ ጎዳይ ታዉ እምቤናባይ ባዋ። ያትና ታን ዋታደ ሀዋ ማላ ዳሮ ኢታባ ሀናደ ጾሳ ቦላ ናጋራ ኦꬆ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","እዛ ሀ የዉዋ ሀቼ ሀቼ ዮሴፎዉ ኦዶፐነ፥ እ እዝና ግሰናን ዎይ እዝ ማታን ኡተናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","እት ጋላስ እ ባረ ኦሱዋ ኦꬃናዉ ሶ ገልያ ዎደ፥ ሶ ቆማቱዋፐ ኦንነ ሶን ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","እዛ ዮሴፎ አፍላ ኦይቃደ፥ “ታናና ግሳ” ያጋዱ። ሽን እ ባረ አፍላ እ ኩሽያን የጊደ፥ ሶፐ ካረ ዎጺደ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ዮሴፎ ባረ አፍላ እ ኩሽያን የጊደ፥ ሶፐ ካረ ዎጽ ከሶዋ እዛ በኤዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ባረ ሶ ቆማቱዋ ጼሳደ ኡንቱንታ፥ “በእተ፤ ታ አስናይ አሄዳ ሀ እብራዌ ብታኒ ታና ባለꬅ ድጊደ አሼዳ፤ እ ታናና ግሳናዉ ሀዋ ገሌዳ፤ ሽን ታን ታ ኮሻ ꬎቂሳደ ዋሳድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ታን ዋስና ስሴዳ ዎደ፥ እ ባረ አፍላ ታ ማታን የጊደ፥ ሶፐ ካረ ዎጺደ ከሴዳ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","አ ጎዳይ ሶ ያና ጋካናዉ እዛ ዮሴፎ አፍላ ባረ ማታን ዎꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ሄዋፐ ጉየ፥ እዛ አዉ ሀዋዳን ያጋደ ኦዳዱ፤ “ሄዌ ኔን ኑዉ አሄዳ እብራዌ አይሊ ታናና ግሳናዉ ታኮ ገሌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ሽን ታን ታ ቃላ ꬎቂሳደ ዋሶዌ፥ ባረ አፍላ ታ ማታን የጊደ፥ ሶፐ ካረ ዎጼዳ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","አ ጎዳይ ባረ ማቻታ፥ “ነ አይሊ ታና ሀዋዳን ኦꬄዳ” ያጋደ ኦዴዳ ቃላ ስሲደ፥ ሀንቁዋን ፐንቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ዮሴፋ አ ጎዳይ አፊደ፥ ካትያ ቃሹዋ ሳአይ ደእያ ቃሾ ጎለን የጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ሽን ዮሴፎ ያን ቃሾ ጎለን ደእያ ዎደ፥ መꬍና ጎዳይ አናና ደኤ። እ አዉ ቃረቴዳ፤ ቃሾ ጎለ ካፑዋ ስንꬃን አዉ ናሹዋ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ያትና ቃሾ ጎለ ካፑ ቃሹዋ አሳ ኡባ ዮሴፎ ኩሽያን ዎꬄዳ፤ ሄዋን ኦሰትያዋ ኡባ ኦꬅያዌ አ። ");
INSERT INTO dwrENT_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ቃሾ ጎለ ካፑ ዮሴፎ ኩሽያን ደእያባዉ አያዉነ ህርገና፤ አያዉ ጎፐ፥ መꬍና ጎዳይ አናና ደኤ፤ እ ኦꬅያዋካ ኡባ አዉ እንጀዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","አማሬዳ ዎድያፐ ጉየ፥ ግብጼ ካትያው ኤሳ ትግያዌነ ኡክꬃ ኡክያዌ ባረንቱ ጎዳ ግብጼ ካትያ ናቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ካቲ ኤሳ ትግያዋንቱ ካፑዋነ ኡክꬃ ኡክያዋንቱ ካፑዋ ላኡዋካ ሎይꬅ ሀንቀቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ዮሴፎ ቃሸቴዳ ቃሾ ጎለን፥ ናግያዋንቱ ካፑዋ ሶን ኡንቱንታ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ናግያዋንቱ ካፑ ኡንቱንታ ዮሴፎዉ ሼꬌዳ፤ እ ኡንቱንቶ ኦꬄ። ኡንቱንቱ ቃሾ ጎለን አማሬዳ ዎድያ ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ግብጼ ካትያዉ ኤሳ ትግያዌነ ኡክꬃ ኡክያዌ፥ ቃሾ ጎለን ደእያ ላአቱካ፥ እት ቃማ ዱማ ዱማ አኩሙዋ አኩመቴድኖ። ቃይ አኩሞቶ ሁጲያን ሁጲያን ኡንቱንቱ ብለꬃይ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ዮሴፎ ዎንታ ኡንቱንቱኮ ገሌዳ ዎደ፥ ካዮት ኡቴዳዋንታ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ሄዋ ድራዉ ባረ ጎዳ ሶን ባረናና ቃሾ ጎለን ደእያ ካትያ ኦሳንቻቱዋ፥ “ሀቼ ህንተንቱ ደሙ አያዉ ꬉሜዴ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ኡንቱንቱ አ፥ “ኑን ላኡ አኩሙዋ አኩመቴዶ፤ ሽን ኑዉ ብልያዌ ꬋዬዳ” ያጌድኖ። ዮሴፎ ኡንቱንታ፥ “አኩሙዋ ብለꬃይ ጾሳዋ ግደኔየ? ህንተንቱ አኩሙዋ ታዉ ኦድተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ኤሳ ትግያዋንቱ ካፑ ባረ አኩሙዋ ዮሴፎዉ ሀዋዳን ያጊደ ኦዴዳ፤ “ታን ታ አኩሙዋን እት ዎይንያ ቱራ ታ ስንꬃን በኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ቃይ ሄ ዎይንያ ቱራዉ ሄዙ ታሺ ደኤ። እ ማራ የሊደ፥ ጪሻ ጪሺደ፥ ዉርጩዋ ዉርጬዳ፤ ዉርጩነ ቴሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ካትያ ዋንጫይ ታ ኩሽያን ደኤ፤ ታን ዎይንያ ቴራ አካደ፥ ካትያ ዋንጫን ጉምኣደ፥ ሄ ዋንጫ አ ኩሽያን ዎꬃድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ዮሴፎ፥ “ሄዋ ብርሸꬃይ ሀዋ፤ ሄዙ ታሸቱ ሄዙ ጋላሳቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ሄዙ ጋላሳ ግዱዋን ካቲ ኔና ደንꬃና፤ እ ኔና ካሰ ነ ሱንꬃተꬃዉ ዛራና፤ ካሰ ኔን ኤሳ ትግያ ዎደ ኦꬄዳዋዳን፥ ኔን ካትያ ዋንጫ አ ኩሽያን ዎꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ሽን ነዉ ሳአይ ሎኤዳ ዎደ ታና ዶጎፓ፤ ታዉ ሎአ፤ ታባ ካትያዉ ኦዳደ፥ ሀ ቃሾ ጎልያፐ ታና ከስሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","አያዉ ጎፐ፥ ታና እብራዌቱዋ ቢታፐ ግዲደ አሄድኖ፤ ሀራይ አቶ ሀዋንካ ታና ቃሽስያዋ አይነ ኦꬃበይከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ኡክꬃ ኡክያዋንቱ ካፑ ዮሴፎ አኩሙዋ ሎይꬅ ብሌዳዋ በኤዳ ዎደ ዮሴፎ፥ “ታንካ አኩሙዋ አኩመታድ፤ ታ ሁጲያን ሄዙ ሳምፓ ኡክꬃይ ደኤ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ቦላ ባጋ ሳምፓን ግብጼ ካትያዉ ኡከቴዳ ኡባ ቆሞ ኡክꬃይ ደኤ። ሽን ካፉ ሄዋ ታ ሁጲያን ደእያ ሳምፓፐ ሜ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ዮሴፎ፥ “ሄዋ ብርሸꬃይ ሀዋ፤ ሄዙ ሳምፓቱ ሄዙ ጋላሳቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ሄዙ ጋላሳ ግዶን ካቲ ኔና ደንꬃና፤ ነ ቆꬍያ ሙጭሲደ ምꬃን ካቅሳና፤ ነ አሹዋካ ካፉ ማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ሄዘንꬆ ጋላሳን ግብጼ ካቲ ባረ የለቴዳ ጋላስ ባረ ኦሳንቻቱዋ ኡባዉ ባላ ጊግሴዳ። ኤሳ ትግያዋንቱ ካፑዋነ ኡክꬃ ኡክያዋንቱ ካፑዋ ደንꬂደ፥ ባረ ኦሳንቻቱዋ ግዶን ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ኤሳ ትግያዋንቱ ካፑዋ አ ሱንꬃተꬃዉ ዛርና፥ እ ካትያ ኩሽያን ዋንጫ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ሽን ካቲ ኡክꬃ ኡክያዋንቱ ካፑዋ ኡንቱንቱ አኩሙዋ ብለꬃ ዮሴፎ ኦዴዳዋዳንካ ካቅሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ሽን ኤሳ ትግያዋንቱ ካፑ ዮሴፎ ሀሳይቤና፤ ዶጊሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ላኡ ላይꬃ ኩመንꬃይ አꬌዳ ዎደ፥ ግብጼ ካቲ አኩሙዋ አኩመቴዳ፤ አኩሙዋን እ ናይለ ሻፋ ዶናን ኤቄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ላፑን ኦርደነ ሞꬎ ሚዛቱ ናይለ ሻፋፐ ከስ ዎꬊደ፥ ማቃ ግዱዋን ምያዋንታ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ኡንቱንቱፐ ስሚደ፥ ሀራ ላፑን ማላ ኢታነ ግልቃ ሚዛቱ ናይለ ሻፋፐ ከሴድኖ፤ ሻፋ ዶናን ደእያ ሀራ ሚዛቱ ማታን ኤቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ሄ ማላ ኢታነ ግልቃ ሚዛቱ ላፑን ኦርዳነ ሞꬎ ሚዛቱዋ ሜድኖ። ሄዋፐ ጉየ ካቲ ቤጎቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","እ ዛረꬅ ገምእሺደ፥ ላኤንꬆ አኩሙዋካ አኩመቴዳ፤ ላፑን ሎአነ ሙሩታ ትሻቱ እት አኑዋን ድጬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ኡንቱንቱፐ ስሚደ፥ ጬጨዳነ አዋይ ዶልያ ባጋ ጫርኩዋን ሹሌዳ ሀራ ላፑን ትሻቱ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ሄ ጬጬዳ ትሻቱ ሎአነ ሙሩታ ትሻቱዋ ምቴድኖ። ሄዋፐ ጉየ ካቲ ቤጎቲደ፥ አኩሙዋ ግድያዋ ኤሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ሳአይ ዎንትና፥ አ ዎዛናይ ሻቢረቴዳ፤ ሄዋ ድራዉ ግብጼን ደእያ ብትያዋንቱ ኡባዉነ አꬌዳ ኤራንቻቱዋ ኡባዉ ኪቲደ ጼስሴዳ፤ ካቲ ኡንቱንቶ ባረ አኩሙዋ ኦዴዳ፤ ሽን አዉ ሄ አኩሙዋ ብርሽያዌ ꬋዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ኤሳ ትግያዋንቱ ካፑ ሄ ዎደ ግብጼ ካትያ ሀዋዳን ያጌዳ፤ “ታን ታ ባይዙዋ ሀቼ ሀሳያይ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","እት ገደ ካቲ ባረ ቆማቶ ሀንቀቲደ፥ ታናነ ኡክꬃ ኡክያዋንቱ ካፑዋ ቃሾ ጎለን የጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ያን ደኢደ ኑን ሁጲያን ሁጲያን አኩሙዋ አኩመቴዶ፤ አኩሞ ዱማ ዱማ ብርሸꬃይ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ሄ ዎደ ናግያዋንቱ ካፑ፥ ቆማይ፥ እብራዌ ዎዳላይ ኑናና ቃሾ ጎለን ደኤ። ኑን ኑ አኩሙዋ አዉ ኦዴዶ፤ እ ኑዉ ሁጲያን ሁጲያን አኩሙዋ ብርሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ያንና ሄ የዎቱ እ ኑዉ ብሌዳዋዳንካ ሀኔድኖ። ሄዌ አዬ ጎፐ፥ ታን ታ ሱንꬃተꬃዉ ስማድ፤ ህንኮ ብታኒ ካቀቴዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ግብጼ ካቲ ዮሴፎዉ ኪቲደ ጼስሴዳ። ኡንቱንቱ አ ቃሾ ጎልያፐ ኤለካ አሄድኖ። እ ሜደቲደ ባረ ማዩዋ ላሚደ፥ ካትያኮ ገሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ካቲ ዮሴፎ፥ “ታን አኩሙዋ አኩመታድ፤ ሽን አ እቱነ ብላናዉ ዳንዳይቤና። ሽን ታን፥ ‘ዮሴፎ አኩሙዋ ስሶፐ፥ ብላናዉ ዳንዳዬ’ ግያዋ ስሳድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ዮሴፎ፥ “ታን ሄዋ ዳንዳይከ፤ ሽን ጾሳይ ካትያዉ ልከ ብርሸꬃ እማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ካቲ፥ “ታን ታ አኩሙዋን ናይለ ሻፋ ዶናን ኤቃ ደእሽን፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ላፑን ኦርዳነ ሞꬎ ሚዛቱ ናይለ ሻፋፐ ከሲደ፥ ማቃ ግዱዋን ሚኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ኡንቱንቱፐ ስሚደ፥ ሀራ ላፑን ማላ ኢታ፥ ግልቃነ ላፋ ሚዛቱ ከሴድኖ፤ ታን ሄዋ ማላ ማላ ኢታ ሚዛ ግብጼ ጋድያን ኡባካ በአ ኤርከ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ማላ ኢታነ ላፋ ሚዛቱ ኮይሮዋንታ፥ ላፑን ሞꬎ ሚዛቱዋ ሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ሽን ኡንቱንታ ሜዳዋፐ ጉየና፥ ኡንቱንቱ ሜዳዋ ኦንነ ኤራናዉ ዳንዳይቤና፤ አያዉ ጎፐ፥ ኡንቱንቱ ማላይ ካሰዋዳንካ ኢት ኡቴዳ። ሄዋፐ ጉየ ታን ቤጎታድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“ታን ታ አኩሙዋን ቃይ ላፑን ሎአነ ሙሩታ ትሻቱዋ እት አኑዋን ድጬዳዋንታ በኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ኡንቱንቱፐ ስሚደ፥ ጬጨዳነ አዋይ ዶልያ ባጋ ጫርኩዋን ሹሌዳ ሀራ ላፑን ትሻቱ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ሄ ጬጬዳ ትሻቱ ላፑን ሎኦ ትሻቱዋ ምቴድኖ። ታን ሀ አኩሙዋ ብትያዋንቶ ኦዳድ፤ ሽን ታዉ አኩሙዋ ብልያዌ ቤትቤና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ሄዋፐ ጉየ ዮሴፎ ግብጼ ካትያ፥ “ካትያ አኩሞቱ እቱዋ። ጾሳይ ባረ ኦꬃና ሀንያዋ ካትያዉ ቆንጭሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ሄ ላፑን ሎኦ ሚዛቱ ላፑን ላይꬃቱዋ፤ ቃይ ላፑን ሎኦ ትሻቱ ላፑን ላይꬃቱዋ፤ ሀ አኩሙ እቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ሄ ላፑን ማላ ኢታነ ላፋ ሚዛቱ ላፑን ላይꬃቱዋ፤ ቃይ አዋይ ዶልያ ባጋ ጫርኩዋን ሹሌዳ፥ ጬጮ ላፑን ትሻቱ ላፑን ኮሻ ላይꬃቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“ታን ካትያዉ ኦዴዳዋዳንካ፥ ጾሳይ ባረ ኦꬃና ሀንያዋ ካትያዉ በሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ላፑን ዳሮ ካሎ ላይꬃቱ ግብጼ ቢታዉ ኡባዉ ያና፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ሽን ላፑን ኮሻ ላይꬃይ ሄዋ ካላና። ሄ ዎደ ግብጼ ካሉ ኡባይ ዶገታና፤ ኮሻይ ቢታ ጺጻና። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ሄ ቢታ ካሉ ሀሳየተናን አታናዋ፤ አያዉ ጎፐ፥ ሄዋ ካሌዳ ኮሻይ ሎይꬅ ሱላና። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ላኡ ኦግያን ካትያዉ ሄ አኩሙ ቤቴዳዌ አያሴ ጎፐ፥ ሀ የዉዋ ጾሳይ ምንሲደ ቃቾ ድራሳ፤ ጾሳይ ሄዋ ኤለካ ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ሀእ ስም፥ ካቲ አꬌዳ ኤራንቻነ ጭንጫ አሳ ኮዪደ፥ ግብጼ ቢታን ሱንꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ካቲ ቢታን ሱንꬃቱዋ ላፑን ካሎ ላይꬃን ቡክያ ካꬃፐ እቼሹ ኩሽያፐ እቱዋ ሺሻናዉ ሱንꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ኡንቱንቱ ይያ ካሎ ላይꬃቱዋን ካꬃ ሺሺደ፥ ካትያ አዎተꬃን ምንጅኖ፤ ሄ ካꬃ ካታማቱዋን ናግኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ቢታይ ኮሻን ꬋየና ማላ፥ ሀ ካꬃይ ግብጼ ቢታን ላፑን ላይꬃን ደንዳና ኮሻዉ ምንጀቲደ ደኦ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ሀ የዉ ግብጼ ካትያዉነ አ ኦሳንቻቶ ሎአ ግዲደ ቤቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ሄዋ ድራዉ ካቲ ኡንቱንታ፥ “ኑን ጾሳ አያናና ደእያ ሀዋ ማላ ሀራ አሳ ደማኔየ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ሄዋፐ ጉየ ካቲ ዮሴፎ፥ “ጾሳይ ሀዋ ኡባ ኔና ኤርሴዳ ድራዉ፥ ነ ማላ አꬌዳ ኤራይነ ጭንጫተꬃይ ደእያዌ ኦንነ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ታን ኔና ታ ጎለን ሱንꬃይ፤ ታ አሳይ ኡባይ ነዉ አዛዘታና፤ ታን ኔፐ አꬍያዌ ታ ካዉተꬃ አራታ ጻላላና ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ሄዋ ድራዉ ካቲ ዮሴፎ፥ “በአ፤ ታን ኔና ግብጼ ጋድያ ኡባ ቦላን ሱንꬃድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ሄዋፐ ጉየ፥ ካቲ ባረ ፓራምያ ምግዱዋ ባረ ብራꬍያፐ ከሲደ፥ ዮሴፎ ብራꬍያን ዎꬄዳ። ታልባፐ ዳደቴዳ ማዩዋ እ አ ማይዚደ፥ አ ቆꬍያንካ ዎርቃ ሳንሳላታ አꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ካቲ ባረ ላኤንꬆ ፓራ ጋርያ ዮሴፋ ቶግሴዳ፤ ቆማቱ፥ “ጎይንተ! ጎይንተ!” ያጊደ አፐ ስንꬃና ሀመቴድኖ። ሀዋዳን ኦꬂደ፥ ካቲ አ ግብጼ ቢታ ኡባ ቦላን ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ሄዋፐ ጉየ ካቲ ዮሴፎ፥ “ታን ካትያ፤ ሽን ኔን ደንꬆ ጌናን ግብጼ ቢታ ኡባን ኦንነ ኩሽያ ዎይ ገድያ ደንና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ካቲ ዮሴፋ፥ “ጻፍናት-ፓእናሀ” ጊደ ሱንꬄዳ፤ እ አዉ ኦና ግያ ካታማ ቄስያ ጶጽፋራ ናቶ አስናቶ ማቼ ኦꬅ እሜዳ። ያትና ዮሴፎ ግብጼ ቢታ ኡባ ሳና አꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ዮሴፎ ግብጼ ካትያዉ ኦꬃናዉ ዶምያ ዎደ፥ አዉ ላይꬃይ ሀታማ። ቃይ ዮሴፎ ካትያ ስንꬃፐ ከሲደ፥ ግብጼ ቢታ ኡባ ግዱዋ ሀመቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ሄ ላፑን ካሎ ላይꬃቱዋን ቢታይ ዳሮ ካꬃ ዶሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ዮሴፎ ግብጼ ቢታን ሄ ላፑን ካሎ ላይꬃ ካꬃ ኡባ ሺሺደ፥ ካታማቱዋን ምንጄዳ። እት እት ካታማ ዩሹዋን ደእያ ጎሻ ካꬃ ኡባ ሄ ካታማቱዋን ምንጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ዮሴፎ አባ ሻፍያ ኬሻ ዳሮ ካꬃ ምንጄዳ፤ ካꬃይ ዳርና፥ ማካናዉ ዳንዳይቤና ድራዉ፥ ማክ ማክ ቆልያዋ አግ ባሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ኮሻ ላይꬃይ ያናፐ ካሰ፥ ኦና ካታማ ቄስያ ጶጽፋራ ናት አስናትፐ ዮሴፎ ላኡ አቱማ ናና የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ዮሴፎ ባረ ባይራ ናኣ ምናሳ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ላኤንꬆ ናኣ ኤፍሬማ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ግብጼ ቢታን ደእያ ሄ ላፑን ካሎ ላይꬃቱ ዉሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ቃይ ዮሴፎ ኦዴዳዋዳን ላፑን ኮሻ ላይꬃቱ ዶሜድኖ። ሀራ ቢታን ኡባን ኮሻይ ደንዴዳ፤ ሽን ግብጼ ቢታ ኡባን ካꬃይ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ግብጼ ቢታይ ኡባይ ኮሻቴዳ ዎደ፥ አሳይ ካꬃዉ ካትያ ዋሴዳ። ካቲ ግብጼ አሳ ኡባ፥ “ዮሴፎኮ ቢተ፤ እ ኦድያዋ ኦꬅተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ኮሻይ ግብጼ ቢታ ኡባ ጋኬዳ ዎደ፥ ዮሴፎ ካꬃ ምንጄዳ ጎልያ ኡባ ዶዪደ፥ ካꬃ ግብጼ አሳዉ ዛልኤዳ፤ አያዉ ጎፐ፥ ግብጼን ኮሻይ ፐንቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ሳኣ ኡባን ኮሻይ ጺጽ ደእያ ድራዉ፥ ሳኣን ደእያ አሳይ ኡባይ ካꬃ ዮሴፎፐ ዎማናዉ ግብጼ ዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ያቆብ ግብጼን ካꬃይ ደእያዋ ስሴዳ ዎደ፥ ባረ አቱማ ናና፥ “ህንተንቱ እቱ እቱዋ አያዉ ጼሊቴ? ");
INSERT INTO dwrENT_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","በእተ! ግብጼን ካꬃይ ደእያዋ ታን ስሳድ፤ ያ ዱገ ቢደ፥ ኑን ሀይቀናን ፓጻ ደአና ማላ፥ ያፐ አማሬዳዋ ኑዉ ዎምተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ዮሴፎ እሻቱ ታማቱ ካꬃ ዎማናዉ ዱገ ግብጼ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ሽን ያቆብ ዮሴፎ እሻ ቢንያማ አ እሻቱዋና የድቤና፤ አያዉ ጎፐ፥ እ ቆሄታነንቶነ ጊደ ቆፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ካናነ ቢታን ዎልቃማ ኮሻይ ደእያ ድራዉ፥ ካꬃ ዎማናዉ ዬዳዋንቱና እስራኤልያ አቱማ ናናይ ግብጼ ገሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ሄ ዎደ ዮሴፎ ሄ ቢታ አይስያዋንታነ ቢታን ደእያ አሳዉ ኡባዉ ካꬃ ዛልእያዋ፤ ሄዋ ድራዉ ዮሴፎ እሻቱ ጋኬዳ ዎደ፥ ባረንቱ ዴሙዋ ሳኣ ጋꬂደ አዉ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ዮሴፎ ባረ እሻቱዋ በኦ ሳን ኤር አጌዳ፤ ሽን እ ኡንቱንታ ኤረናዋዳን ላመቴዳ፤ እ ኡንቱንታ፥ “ህንተንቱ ሀቃፐ ዬድቴ?” ያጊደ ኦቼዳ። ኡንቱንቱ፥ “ካꬃ ዎማናዉ፥ ካናነ ቢታፐ ዬዶ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ዮሴፎ ባረ እሻቱዋ ኤሬዳ፤ ሽን ኡንቱንቱ አ ኤርበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ሄዋፐ ጉየ፥ ዮሴፎ ኡንቱንቱዋ አኩመቴዳ ባረ አኩሙዋ ሀሳዪደ ኡንቱንታ፥ “ህንተንቱ ጌድ ጼልያ አሳ፤ ህንተንቱ ኑ ቢታን ናጉ ለፕያ ባጋይ ሀቃዌንቶ በአናዉ ዬድታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ኡንቱንቱ፥ “ቱይት፥ ኑ ጎዳዉ፥ ኑን ጌድ ጼልያ አሳ ግዶኮ፤ ኑን ነ ቆማቱ ካꬃ ዎማናዉ ዬዶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ኑን ኡባይካ እት አዉዋ ናና። ኑን ነ ቆማቱ አማነትያ አሳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ዮሴፎ ኡንቱንታ፥ “ቱይት፤ ህንተንቱ ኑ ቢታን ናጉ ለፕያ ባጋይ ሀቃዌንቶ በአናዉ ዬድታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ሽን ኡንቱንቱ፥ “ኑን ነ ቆማቱ ታማነ ላኡ እሻቱዋነ ካናነ ቢታን ደእያ እት ብታንያ ናና። ዉርሰꬃ ꬋንꬃ ዱሱ ሀእ ኑ አቡና ደኤ፤ እቱ ꬋዬዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ዮሴፎ ኡንቱንታ፥ “ታን ህንተንቶ ኦዴዳዋዳንካ ህንተንቱ ቢታ ጌድያዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ቃይ ህንተንቱ ፓጨታናዌ ሀዋና፤ ቱሙዋፐ ካቲ ሀይቆ፤ ህንተንቱ ዉርሰꬃ ቴፋ እሻይ ሀዋ ያና ꬋዮፐ፥ ህንተንቱ ሀዋፐ ቢክታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ህንተንቱ ኦድያዌ ቱማ ግድያዋ ፓጫናዉ፥ ህንተፐ እቱዋ ኪትተ፤ እ ህንተንቱ እሻ አኪደ ዮ፤ አቴዳዋንቱ ቃሾ ጎለን ጋምኢታ። ሄዋ ግዳና ꬋዮፐ፥ ካቲ ሀይቆ፤ ህንተንቱ ቢታ ጌድያዋንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ኡንቱንታ ሄዙ ጋላሳዉ ቃሾ ጎለን የጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ሄዘንꬆ ጋላሳን ዮሴፎ ኡንቱንታ፥ “ታን ጾሳዉ ያይያ አሳ፤ ህንተንቱ እትባ ኦꬆፐ፥ ፓጻ ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ህንተንቱ ቱሙካ አማነትያ አሳ ግዶፐ፥ ህንተንቱ እሻቱዋፐ እቱ ሀዋን ቃሾ ጎለን ደኦ፤ አቴዳዋንቱ ኮሻትያ ህንተንቱ ሶ አሳዉ ካꬃ አኪደ አፍተ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ሽን ህንተንቱ ቃላ ቱማያና ማላነ ህንተንቱ ሀይቀና ማላ ህንተንቱ ህንተንቱ ዉርሰꬃ ቴፋ እሻ ታኮ አሀና ኮሼ” ያጌዳ። ኡንቱንቱነ ሀ የዉዋ ማዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ኡንቱንቱ እቱ እቱዋ፥ “ቱሙ ኑን ኑ እሻዉ ኦꬄዳባይ ኑና ካኤ። እ ባረ ሸምፖ ሀንያባይ እጽና፥ ኑዉ ዋትዋትያ ዎደ፥ ኑን ስሲደ እጼዶ፤ ሀ ዋዪ ኑና ጋኬዳዌ ሄዋ ድራሳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ሮቤል፥ “ታን ህንተንታ፥ ‘ናኣ ቦላ ናጋራ ኦꬆፕተ’ ጋደ ኦዳበይክታ? ሽን ህንተንቱ ስሰናን እጼድታ። ስም ሀእ፥ አ ሱꬃይ ኑና አቼ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ኡንቱንቱ ግያባ ዮሴፎ ኤሬዳዋ ኡንቱንቱ አኬክበይክኖ፤ አያዉ ጎፐ፥ እ ኡንቱንቱና ዎካልያን ሃሳይያ ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","እ ኡንቱንቱፐ ዎራ ስሚደ ዬኬዳ፤ ሽን ቃይ ኡንቱንቱኮ ስሚደ፥ ኡንቱንቶ ጉጂደ ሃሳዬዳ። እ ስሞና ኡንቱንቱፐ ዱꬅ አሺደ ኡንቱንቱ በእሽን ቃቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ዮሴፎ ባረ ቆማቱዋ፥ “ካꬃ ኡንቱንቱ ኦጎሩዋ ኩንꬅተ፤ ኡንቱንቱ ብራካ ዛሪደ፥ ኡንቱንቱ ኦጎሩዋን ኦጎሩዋን ዎꬅተ፤ ቃይ ኡንቱንቱ ኦግያዉ ሽንቃ እምተ” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","እ ጌዳዋዳን ኦꬄዳዋፐ ጉየ፥ ዮሴፎ እሻቱ ካꬃ ባረንቱ ሀረቱዋን ጫኒደ፥ ደንዲደ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ኡንቱንቱ ቃማ አቃናዉ ስሜድኖ ኡንቱንቱፐ እቱ ባረ ሀርያዉ ካꬃፐ የጋናዉ ባረ ኦጎሩዋ ብሊደ፥ ሄ ኦጎሩዋ ዶናን ደእያ ባረ ብራ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","እ ባረ እሻቱዋ፥ “ታ ብራይ ታዉ ስሜዳ፤ ቱሙ ሀዋ በእተ! ታ ኦጎሩዋን ደኤ” ያጌዳ። ኡንቱንቱ ዎዛናይ ዳጋምና፥ ኮኮሪደ እቱ እቱዋኮ ስሚደ፥ “ጾሳይ ኑ ቦላ ኦꬄዳባይ ሀዌ አዬ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ኡንቱንቱ ካናነ ቢታን ደእያ ባረንቱ አዉዋ ያቆባኮ ዬዳ ዎደ፥ ባረና ጋኬዳዋ ኡባ አዉ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ኡንቱንቱ አዉ፥ “ሄ ቢታዉ ጎዳ ግዴዳ ብታኒ ኑና ሀንቀቴዳ። ሄዋፐ ጉየ፥ እ ኑና ሄ ቢታ ገድያዋዳን ጎዳቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ሽን ኑን አ፥ ‘ኑን አማነትያ አሳ፤ ቢታ ጌድያዋንታ ግዶኮ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ኑን ታማነ ላኡ እሻቱ እት አዉዋ ናና፤ እቱ ꬋዬዳ፤ ዉርሰꬃ ቴፋይ ካናነ ቢታን ሀእ ኑ አቡና ደኤ’ ያጌዶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ሄ ቢታዉ ጎዳ ግዴዳ ብታኒ ኑና፥ ‘ህንተ አማነትያ አሳ ግድያዋ ታን ሀዋን ኤራና፤ ህንተንቱ እሻቱዋፐ እቱዋ ሀዋን ታ ማታን የጊደ፥ ኮሻትያ ህንተንቱ ሶ አሳዉ ካꬃ አኪደ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ህንተንቱ ቢታ ጌድያዋንታ ግደናን፥ አማነትያ አሳ ግድያዋ ታን ኤራና ማላ፥ ህንተንቱ ዉርሰꬃ ቴፋ እሻ ታኮ አክ ዪተ። ያቶፐ ታን ሃን አቴዳ ህንተንቱ እሻ ህንተንቶ ዛራደ እማና፤ ህንተነ ሀ ቢታን ዛልኢታ’ ጌዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ኡንቱንቱ ባረንቱ ኦጎሩዋፐ ካꬃ ቆሊደ፥ ባረንቱ ኦጎሩዋን ኦጎሩዋን ባረንቱ ብራ ቃሹዋና ኡቴዳዋ ደሜድኖ። ኡንቱንቱነ ኡንቱንቱ አዉ ሄ ቃሹዋና ደእያ ብራ በኢደ ያዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ኡንቱንቱ አዉዋ ያቆብ ኡንቱንታ፥ “ህንተንቱ ታና ታ ናናቱዋፐ መላ ከሴድታ፤ ዮሴፎ ባዋ፥ ስሞን ባዋ፤ ቃይ ህንተንቱ ቢንያማ አፋና ኮዪታ። ኡባባይ ታዉ ትራን ስት ጌዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ሄዋፐ ጉየ ሮቤል ባረ አዉዋ፥ “ታን ቢንያማ ነዉ ዛራደ አሀና ꬋዮፐ፥ ታ አቱማ ናና ላኡዋካ ዎꬋ፤ ታና አማነታደ አ ታ ኩሽያን ዎꬃ፤ ቃይ ታን አ ዛራደ አሀና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ሽን ያቆብ ኡንቱንታ፥ “ታ ናአይ ህንተናና ያ ዱገ ቤና፤ አ እሻይ ሀይቂና፥ አቴዳዌ አ ጻላላ፤ ህንተንቱ አፍሽን፥ ኦግያን ኢታባይ አ ጋክያዋ ግዶፐ፥ ህንተንቱ ታ ፑሉንꬃ ሁጲያ ካዩዋን ዱፉዋን የጊታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ሀእነ ኮሻይ ካናነ ቢታን ዎልቃሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ያትና ኡንቱንቱ ግብጼፐ አሄዳ ካꬃ ኡባ ም ዉርስ ድግና፥ ኡንቱንቱ አዉ፥ “ቃይካ ጉየ ቢደ ኑዉ አማሬዳ ካꬃ ዎምተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ሽን ይሁዳይ አ፥ “ሄ ብታኒ ኑና፥ ‘ህንተ እሻይ ህንተናና ያና ꬋዮፐ፥ ታ ዴሙዋ ዛር በእክታ’ ያጊደ ሎይꬅ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ኔን ኑ እሻ ኑናና የዶፐ፥ ኑን ዱገ ቢደ ነዉ ካꬃ ሻማና። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ሽን ኔን አ የደናዋ ግዶፐ፥ ኑን ዱገ ቦኮ፤ አያዉ ጎፐ፥ ሄ ብታኒ ኑና፥ ‘ህንተ እሻይ ህንተናና ያና ꬋዮፐ፥ ህንተንቱ ታ ዴሙዋ ዛር በእክታ’ ጌዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","እስራኤሊ፥ “ህንተንቱ፥ ‘ኑዉ ሀራ እሻይ ደኤ’ ጊደ ኦዲደ ሀ መቱዋ ታ ቦላ አያዉ አሄድቴ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ኡንቱንቱ አ፥ “ሄ ብታኒ ኑባነ ኑ ሶ አሳባ ሎይꬅ ኦቼዳ። እ ኑና፥ ‘ህንተ አዉ ሀእካ ፓጻ ደኢ? ህንተንቶ ሀራ እሻይ ደኢ?’ ያጊደ ኦቼዳ። ኑን እ ኦቼዳዋ አዉ ዛሬዶ። እ ኑና፥ ‘ህንተ እሻ ዱገ ሃ አህተ’ ጋናዋ ኑን አያን ኤራኔ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ይሁዳይ ባረ አዉዋ እስራኤልያ፥ “ኑንካ ኔንካ ኑ ናናይካ ፓጻ ደአና ማላነ ሀይቀናን አታና ማላ፥ ናኣ ታናና የዳ፤ ኑን ኤለካ ባና። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ናኣ ታ ዋሰተꬃን እማ፤ አባን ታና ኦቻ፤ ታን አ ነዉ ሳሮ ዛራደ አሀና ꬋዮፐ፥ ታ ደኡዋ ኡባን ነ ሸቃይ ታና ጋኮ! ");
INSERT INTO dwrENT_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ኑን ጋምእቤናዋ ግድንቶ፥ ሀኖደ ላኤንꬁዋ ያ ጋኪደ ስማና ሽን” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ሄዋፐ ጉየ ኡንቱንቱ አዉ እስራኤለ ኡንቱንታ፥ “ሄዋ ግዶፐ፥ ያትተ፤ ሄ ብታንያዉ ኩሽያ ገንꬅያዋ ሀ ቢታን ዶሌዳዋ ኡባፐ ሎእያዋ ዶርተ፤ ሄዌነ ባላሳነ ግያ ꬋልያ፥ ኤሳ፥ ሳዉዋ፥ ካርቢያነ ታምረ ላዉዝያ ግያ ምꬃቱዋ ቴራ ህንተንቱ ኦጎሩዋን የጊደ አክ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ህንተንቱ ኦጎሩዋ ዶናን ስሜዳ ብራይ ባለꬄዳዋ ግዳናዉ ዳንዳይያ ድራዉ፥ ብራካ ላኡ ኩሸ ኦꬂደ አክ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ቃይ ህንተንቱ እሻነ አኪደ፥ ሄ ብታንያኮ ኤለካ ጉየ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","እ ህንኮ ህንተንቱ እሻ የዳና ማላ፥ ቢንያመነ ህንተናና ያና ማላ፥ ኡባ ዳንዳይያ ጾሳይ ሄ ብታኒ ህንተንቶ ቃረታናዳን ኦꬆ። ታና ግዶፐ፥ ታ ናናቱዋፐ መላ አቶፐነ አታድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ሄዋ ድራዉ ሄ አሳቱ እሞታነ ላኡ ኩሸ ብራነ ቃይ ቢንያማነ አኬድኖ። ኡንቱንቱ ዱገ ግብጼ ቢደ፥ ዮሴፎ ስንꬃ ሺቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ዮሴፎ ቢንያማ ኡንቱንቱና በኤዳ ዎደ፥ ባረ ጎለ ካፑዋ፥ “ሄ አሳ ታ ሶ አካደ ባ፤ እት መህያ ሹካደ ጊግሳ፤ ኡንቱንቱ ሴታ ጋላሳን ላጻ ታናና ሚኖ” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ያትና እ ዮሴፎ አዉ ኦዴዳዋዳን ሄ አሳ ዮሴፎ ሶ አፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","አሳቱ ዮሴፎ ሶ ቤዳ ድራዉ፥ ያዬድኖ፤ ኡንቱንቱ፥ “ኑን ሀዋ ዬዳዌ ኮይሮ ኦጎሩዋና ስሚደ ቤዳ ብራ ድራሳ፤ እ ኑና ዋꬋናዉ፥ አይለተꬃን ሞዳናዉነ ኑ ሀረቱዋ አካናዉ ሀኔዳ” ያጊደ ቆፔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ሄዋ ድራዉ ኡንቱንቱ ዮሴፎ ጎለ ፐንግያ ጋኪደ፥ ጎልያ ካፑዋ ሃሳይሴድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“ታ ጎዳዉ፥ ኑን ኮይሮ ካꬃ ዎማናዉ ሀዋ ዬዶ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ስሚደ ኑን ቃማ አቅያ ሳኣን ኦጎሩዋ ብሊደ፥ ሁጲያን ሁጲያን ኑ ብራይ ፓጨናን ኑ ኦጎሩዋ ዶናን ደእያዋ ደሜዶ፤ ሄዋ ድራዉ ሀእ ኑን አ ጉየ አኪደ ዬዶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ቃይ ኑን ካꬃ ዎማናዉ ሀራ ብራካ አሄዶ። ኑ ብራ ኑ ኦጎሩዋ ኦጎሩዋ ዶናን ኦን ዎꬄደንቶነ ኤሮኮ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","እ ኡንቱንታ፥ “ሄዌ አይነ ባዋ፤ ያዮፕተ! ህንተንቱ ጾሳይ፥ ህንተንቱ አዉዋ ጾሳይ፥ ህንተንቱ ኦጎሩዋ ግዶን ህንተንቶ ብራ እሜዳ፤ ታን ህንተንቱ ብራ አካድ” ያጌዳ። ሄዋፐ ጉየ፥ እ ስሞና ኡንቱንቱኮ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ሄ ብታኒ ሄ አሳ ዮሴፎ ሶ አፊደ፥ ኡንቱንቱ ገድያዉ ሃꬃ አይና፥ ባረንቱ ገድያ ሜጨቴድኖ። ኡንቱንቱ ሀረቶ ሀርቁዋ የጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ዮሴፎ ሴታ ጋላስ ዪና እማናዉ፥ ኡንቱንቱ ባረንቱ እሞታ አዉ ጊግሴድኖ፤ አያዉ ጎፐ፥ ኡንቱንቱ ያን ማናዋ ስስ ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ዮሴፎ ባረ ሶ ገሌዳ ዎደ፥ ኡንቱንቱ ሶ አሄዳ ባረንቱ እምያዋ ሶን አዉ እሜድኖ፤ ኡንቱንቱ አ ስንꬃን ሳኣ ጋኪደ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","እ ኡንቱንቱ ሳሮተꬃ ኦች ስሚደ፥ “ህንተንቱ ታዉ ኦዴዳ ህንተንቱ አዉ ጭማይ ሎኤ? ሀእካ እ ፓጻ ደኢ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ኡንቱንቱ፥ “ኤ፥ ነ ቆማይ፥ ኑ አዉ ሀእካ ፓጻ ደኤ፤ እ ሎአ” ያጊደ ሆኪደ አዉ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","እ ባረ አት ናኣ ቢንያማ በኤዳ ዎደ ኡንቱንታ፥ “ህንተንቱ ኦዴዳ ዉርሰꬃ ቴፋ ህንተንቱ እሻይ ሀዌ?” ያጌዳ። ቃይ እ ቢንያማ፥ “ታ ናአዉ፥ ኔና ጾሳይ አንጆ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ዮሴፎ አ እሻይ አዉ ጎምፓይ ምሸቴዳ ድራዉ፥ ዬካናዉ እት ሳኣ ላዉሁ ጌዳ። እ ባረ ዱማ ቆልኡዋ ገሊደ ያን ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","እ ባረ ዴሙዋ ሜጨቶዋፐ ጉየ ከሲደ፥ ባረና ምንꬂደ፥ “ቁማ አꬅተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ኡንቱንቱ አዉ ዱማ፥ ሄ እሻቶ ዱማ፥ ሄዋን አናና ምያ ግብጼ አሳቶ ዱማ አꬄድኖ፤ አያዉ ጎፐ፥ ግብጼ አሳቱ እብራዌ አሳቱዋና እትፐ ሚክኖ። ሄዌ ግብጼ ቢታ አሳ ሸነይያዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ኡንቱንቱ ዮሴፎ ስንꬃን ባይራይ ባረ ባይራተꬃዳን፥ ቴፋይ ባረ ቴፋተꬃዳን ማራን ኡቴድኖ። ኡንቱንቱ እቱ እቱዋ ጼሊደ፥ ኡንቱንታ ዎት ኡትሴድኖንቶ በኢደ ማላለቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ዮሴፎ ማዳፐ ኡንቱንቶ ቁማ ግሽያ ዎደ፥ ቢንያመዉ ጋኬዳዌ ሀራቱዋፐ እቼሹ ኩሽያ ዳሬ፤ ያትና ኡንቱንቱ ናሸቲደ አናና ሜድኖነ ኡሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ዮሴፎ ባረ ጎለ ካፑዋ፥ “ኔን ሀ አሳቱዋ ኦጎሩ አክያዋ ኬሻ ካꬃ ኡንቱንቶ ኩንꬃ፤ ኡንቱንቱ ኡባ ብራካ ኡንቱንቱ ኦጎሩዋ ኦጎሩዋ ዶናን ዎꬃ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ያታደ ዉርሰꬃ ቴፋ ኦጎሩዋ ዶናን ታ ብራ ዋንጫነ አ ካꬃ ብራ ዎꬃ” ያጊደ አዛዜዳ፤ እ ዮሴፎ ጌዳዋዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ሳአይ ዎንትና ሄ አሳቱ ባረንቱ ሀረቱዋ አኪደ ባናዉ ሞይዘቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ኡንቱንቱ ሄ ካታማፐ ከሲደ ሃክ ቤናን ደእሽን፥ ዮሴፎ ባረ ጎለ ካፑዋ፥ “ደንዳ! ሀ አሳቱዋ ጌዱዋ ካላ፤ ኔን ኡንቱንታ ጋኬዳ ዎደ ኡንቱንቱ፥ ‘ህንተ አያዉ ኬካ ኢታን ዛሬድቴ? ");
INSERT INTO dwrENT_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ሀዌ ታ ጎዳይ ኡሽያነ ቃይ ጹራባ ደምያ ዋንጫ ግደኔ? ሀዌ ህንተንቱ ኦꬄዳባይ ባላባ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","እ ኡንቱንቱ ጌዱዋ ጋኪደ፥ ሀ ጌዳዋዳንካ ኡንቱንቶ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ሽን ኡንቱንቱ፥ “ታ ጎዳይ ሀዋ ማላ ቃላ አያዉ ሃሳዪ? ሄዋ ማላ ኦꬅያዌ ኑፐ ነ ቆማቱዋፐ ሃኮ! ");
INSERT INTO dwrENT_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ኑን ሀራይ አቶ ኑ ኦጎሩዋ ዶናፐ ደሜዳ ብራ ካናነ ቢታፐ ጉየ ነዉ ዛር አሄዶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ነ ጎዳ ጎልያፐ ኑን ዎርቃ ዎይ ብራ ዎት ዉኤቶ? ነ ቆማቱዋ ግዶን ሄ ዋንጫይ ቤቴዳ ኡራይ ሀይቆ፤ ቃይ አቴዳ ኑን ኑ ጎዳዉ አይለ ግዳና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","እ ኡንቱንታ፥ “ሄዋ ግዶፐ ሎአ፤ ህንተንቱ ጌዳዋዳን ዋንጫ አኬዳ ኦንነ ታ አይለ ግዳና፤ ህንኮ አቴዳ ህንተንቱ ቦርያፐ ሳሮ አታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ሄዋፐ ጉየ፥ ኡንቱንቱ ኤለካ ባረንቱ ኦጎሩዋ ኦጎሩዋ ሳኣን ዎꬂደ ብሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ሄ ካፑ ኡባፐ ባይራትያዋ ኦጎሩዋፐ ዶሚደ ዉርሰꬃ ቴፋ ጋካናዉ ኮዬዳ፤ ሄ ዋንጫ ቢንያማ ኦጎሩዋ ግዶፐ ደሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ሄዋን ኡንቱንቱ ካዮቲደ፥ ባረንቱ ማዩዋ ፔꬌድኖ፤ ባረንቱ ኦጎሩዋ ባረንቱ ሀረቱዋን ጫኒደ፥ ጉየ ካታማ ስሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ይሁዳይ ባረ እሻቱዋና ዮሴፎኮ ገልያ ዎደ፥ ዮሴፎ ሶን ደኤ፤ ኡንቱንቱ አ ስንꬃን ሳኣን ጉፋኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ዮሴፎ ኡንቱንታ፥ “ህንተንቱ አያ ኢታባ ኦꬄድተ? ታ ማላ አሳይ ጹራባ ደምያዋ ኤርክቴየ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ይሁዳይ፥ “ታ ጎዳዉ ኑን አያ ጋኔ? ኑን አያ ሃሳያኔ? ዎይ ኑን ጽሉዋ ግድያዋ ዎት በሳኔ? ጾሳይ ነ አይለቱዋ ባይዙዋ ቆንጭስ ድጌዳ። ስም ኑንካ ሄ ዋንጫይ አፐ ቤቴዳዌካ ታ ጎዳዉ አይለ ግዴዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ሽን ዮሴፎ፥ “ሀዋ ማላ ኦꬅያዌ ታፐ ሃኮ፤ ታ ዋንጫይ አፐ ቤቴዳ ብታንያ ጻላላይ ታ አይለ ግዳና። ህንኮ ህንተንቱ ህንተንቱ አዉዋኮ ጉየ ሳሮ ስምተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ይሁዳይ አኮ ሺቂደ አ፥ “ታ ጎዳዉ፥ ታን እት ቃላ ሃሳያና ማላ ኔና ዎሳይ፤ ታና ነ አይልያ ሀንቀቶፓ፤ አያዉ ጎፐ፥ ኔን ካትያ ማላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ኔን ታ ጎዳይ ኑና ነ አይለቱዋ፥ ‘ህንተንቶ አዉ ደኢየ ዎይ እሻይ ደኢ?’ ያጋደ ኦቻዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ኑንካ፥ ‘ኑዉ ጭሜዳ አዉ ደኤ፤ እ ጭም ክቺደ የሌዳ ቴፋ ናአይካ ደኤ፤ ሄ ናኣ እሻይ ሀይቄዳ፤ ባረ አትዉ እት አ ጻላላይ አቴዳ፤ አ አዉ አ ሲቄ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“ኔን ነ አይለቱዋ፥ ‘ታን አ በአና ማላ ታዉ አህተ’ ያጋዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ኑን ታ ጎዳ፥ ‘ሄ ናአይ ባረ አዉዋፐ ሻከታናዉ ዳንዳየና፤ ሻከቶፐ አ አዉ ሀይቃንታ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ሽን ኔን ነ አይለቱዋ፥ ‘ህንተ ቴፋ እሻይ ህንተናና ዱገ ያና ꬋዮፐ፥ ላኤንꬁዋ ታ ዴሙዋ በእክታ’ ያጋዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ኑን ነ አይላቱ ኑ አዉዋኮ ስሚደ ቤዳ ዎደ፥ ታ ጎዳይ ጌዳዋ አዉ ኦዴዶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“ኑ አዉ፥ ‘ጉየ ቢደ አማሬዳ ካꬃ ዎምተ’ ያግና፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ኑን አ፥ ‘ኑ ቴፋ እሻይ ኑናና ቦፐ አትን፥ ዱገ ባናዉ ዳንዳዮኮ፤ አያዉ ጎፐ፥ ኑ እሻይ ቴፋይ ኑናና ቤናዋ ግዶፐ፥ ኑን ሄ ብታንያ ዴሙዋ በአናዉ ዳንዳዮኮ’ ያጌዶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“ኑ አዉ ነ አይል ኑና፥ ‘ታ ማቻታ ራሄላ ታዉ ላኡ አቱማ ናና የሌዳዋ ህንተንቱ ኤሪታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ኡንቱንቱፐ እቱ ታፐ ሻከቲደ ቢና፥ “ቱሙ አ ዶአይ ፑዘሬꬅ ሜዳ” ያጋድ፤ ሀቼ ጋካናዉ ታን አ በአበይከ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ሀዋ ቃይ ህንተንቱ ታፐ ሻክ አፍና፥ ኢታባይ አ ጋኮፐ፥ ህንተንቱ ታ ፑሉንꬃ ሁጲያ ካዩዋን ዱፉዋን የጋና’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“ሄዋ ድራዉ፥ ሀእ ታን ጉየ ነ አይልያ ታ አዉዋኮ ብያ ዎደ፥ ታ አዉ፥ ናኣ ባረ ሸምፑዋዳን ሲቅያዌ፥ ናአይ ኑናና ባይናዋ በኦፐ ሀይቂ አጋና። ኑን ነ አይለቱ ኑ አዉዋ ፑሉንꬃ ሁጲያ ካዩዋን ዱፉዋን የጌቶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ታን ነ አይል ናኣ ታ ዋሰተꬃን አካድ፤ ታን አ፥ ‘ታ አዎ፥ ታን አ ነዉ ሳሮ ዛራደ አሀና ꬋዮፐ፥ ታ ደኡዋ ኡባን ነ ሸቃይ ታና ጋኮ!’ ያጋ ዎꬃድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“ያቴዳ ድራዉ፥ ታን ነ አይል ታ ጎዳዉ ናኣ ድራዉ አይለታደ፥ ሀዋን አትና፥ ናአይ ባረ እሻቱዋና ጉየ ስሞ። ");
INSERT INTO dwrENT_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ናአይ ባይናን ታን ዋናደ ጉየ ታ አዉዋኮ ስማኔ? ቱይት፥ ታና ታ አዉ ሴለታና ሴላ በሶፓ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ሄ ዎደ ዮሴፎ ሄ አሳ ኡባ ስንꬃን ገንጫና ዳንዳይቤና፤ “አሳ ኡባ ታ ስንꬃፐ ከስተ” ያጊደ ዋሴዳ። ሄዋ ድራዉ ዮሴፎ ባረና ባረ እሻቶ ኤርሴዳ ዎደ፥ አናና ኦንነ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","እ ባረ ቃላ ꬎቂሲደ፥ ግብጼቱ አ ስሳና ጋካናዉ ሎይꬅ ዬኬዳ። ካትያ ሶ አሳይ ሄ ዎርያ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ዮሴፎ ባረ እሻቶ፥ “ታን ዮሴፋቴ! ታ አዉ ሀኖ ጋካናዉ ፓጻ ደኢየ?” ያጊደ ኦቼዳ። ሽን አ እሻቱ ሎይꬅ ዳጋሜዳ ድራዉ፥ አዉ ዛራና ዳንዳይበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ያትና ዮሴፎ ባረ እሻቱዋ፥ “ታኮ ሃ ሺቅተ” ያጌዳ። ኡንቱንቱ አኮ ሺቄድኖ፤ እ ኡንቱንታ፥ “ታን ህንተንቱ እሻ ዮሴፋ፤ ህንተንቱ ግብጼ ቢታዉ ዛልኤዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ቃይ ህንተንቱ ታና ሀዎ ዛልኤዳ ድራዉ፥ ቁምኤቶፕተነ ካዮቶፕተ፤ አያዉ ጎፐ፥ ጾሳይ ታና ህንተፐ ስንꬃዉ ኪቴዳዌ አሳ ሸምፑዋ አሻናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ሀ ቢታ ኮሻይ ገሎደፐ ላኤንꬆ ላይꬃ፤ ቃይ ይያ እቼሹ ላይꬃቱዋን አሳይ ጎሸና ዎይ ጫከና። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ሽን ታን ሳኣን ህንተንቶ ዘረꬃ አሻና ማላነ ህንተንቱ ደኡዋ ዳርሳ አሻና ማላ፥ ጾሳይ ታና ህንተፐ ስንꬃዉ ኪቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ስም ታና ሀ ሳኣ ኪቴዳዌ ጾሳ ግድያዋፐ አትና፥ ህንተንታ ግድክታ። እ ታና ግብጼ ካትያዉ አዉዋ፥ አዉ ደእያዋ ኡባዉ ጎዳነ ግብጼ ቢታ ሞድያዋ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“ሀእ ኤሌል ጉየ ታ አዉዋኮ ቢደ አ፥ ‘ነ ናአይ ዮሴፎ ሀዋዳን ያጌ፤ “ጾሳይ ታና ግብጼ ቢታ ኡባ ቦላን ጎዳ ከሴዳ፤ ኔን ታኮ ዱገ ሃያ፤ ጋምኦፓ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ኔን ገሴመ ቢታን ኡታሳ፤ ቃይ ኔን፥ ነ ናናይ፥ ነ ናና ናናይ፥ ነ ዶርሳ ዉዲ፥ ነ ሚዛ ዉዲነ ነዉ ደእያባይ ኡባይ ታ ማታን ደኢታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ብሮ እቼሹ ኮሻ ላይꬃቱ አቴድኖ፤ ኔና፥ ነ ሶ አሳነ ነ መህያ ኮሻይ ኦይቀና ማላ፥ ታን ኔና ምዛና” ያጌዳ’ ያግተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ቃይካ ዮሴፎ ኡንቱንታ፥ “ህንተካ ታ እሻ ቢንያመካ፥ ሀ ህንተናና ሃሳይያዌ ቱሙ ታና ዮሴፋ ግድያዋ ህንተንቱ አይፍያን በኢታ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ታዉ ግብጼ ቢታን ደእያ ቦንቹዋ ኡባነ ህንተንቱ በኤዳዋ ኡባ ታ አዎ ኦድተ፤ ታ አዉዋነ ኤለካ ሃ ዱገ አክ ዪተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ባረ እሻ ቢንያማ ቆꬍያ ቆም ዬኬዳ፤ ቢንያመካ ባረ እሻ ቆም ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ዮሴፎ ባረ እሻቱዋ ኡባ የሪደ፥ ኡንቱንቱ ቦላንካ ዬኬዳ። ሄዋፐ ጉየ፥ አ እሻቱ አናና ሃሳዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ዮሴፎ እሻቱ ዬዳ ዎሪ ካትያ ጎለ ጋኬዳ ዎደ፥ ካቲነ አ ኦሳንቻቱ ናሸቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ካቲ ዮሴፎ፥ “ኔን ነ እሻቱዋ ያትተ ጋ፤ ‘ህንተ መህያ ጫኒደ፥ ካናነ ጋድያ ስምተ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ህንተንቱ አዉዋነ ህንተንቱ ሶ አሳ አኪደ፥ ጉየ ታኮ ሃ አህተ። ታን ህንተንቶ ግብጼ ቢታን ኡባ ሳኣፐ ሎእያ ሳኣ እምና፥ ህንተንቱ ሀ ቢታ ሞꬉዋ ካሻና’ ያጋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ቃይካ ኔን ነ እሻቱዋ፥ ‘ፓራ ጋርያ ህንተንቱ ናናቱዋነ ህንተንቱ ማጫ አሳቱዋ አህያዋንታ ግብጼፐ አኪደ ቢተ፤ ህንተንቱ አዉዋነ አኪደ ዪተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ግብጼ ቢታን ደእያ ኡባፐ አꬍ ሎእያዌ ህንተሳ ግድያ ድራዉ፥ ህንተንቱ ማጹዋ ቆፖፕተ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","እስራኤልያ አቱማ ናናይ ጌዳዋዳን ኦꬄድኖ። ዮሴፎ ካቲ አዛዜዳዋዳን ፓራ ጋረቱዋነ ኦግያዉ ሽንቃ ኡንቱንቶ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ኡንቱንቶ ኡባዉካ ሁጲያን ሁጲያን ኦራꬃ ማዩዋ እሜዳ፤ ሽን ቢንያመዉ ሄዙ ጼቱ ጻጋራ ብራነ እቼሹ ኩመንꬃ ማዩዋ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","እ ባረ አዎ የዴዳዌ ሀዋ፤ ግብጼን ደእያ ኡባባፐ ሎእያዋ ታሙ ሀርያን ጫኒደ፥ ቃይ ኦግያዉ ካꬃ፥ ኡክꬃነ ሀራ ሽንቃ ታሙ ማጫ ሀረቱዋን ጫኒደ የዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ዮሴፎ ባረ እሻቱዋ ሞይዜዳ። ኡንቱንቱ ቢሽን እ ኡንቱንታ፥ “ኦግያን ቢደ ዋላቀቶፕተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ኡንቱንቱ ግብጼፐ ከሲደ ቤድኖ፤ ካናነ ቢታ ቢደ፥ ባረንቱ አዉዋ ያቆባኮ ጋኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ኡንቱንቱ አዉ ሀዋዳን ያጊደ ኦዴድኖ፤ “ዮሴፎ ፓጻ ደኤ! እ ሄዋፐነ ግብጼ ቢታ ኡባ ሞድያዋ” ያጌድኖ፤ ያቆባ ዳጋማይ ዎዛና ባይዜዳ ድራዉ፥ ኡንቱንታ አማንቤና። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ሽን ኡንቱንቱ ዮሴፎ ባረንቶ ኦዴዳዋ ኡባ አዉ ኦድናነ አ አክ አሀና ማላ ዮሴፎ ኪቴዳ ፓራ ጋረቱዋ እ በእና፥ ኡንቱንቱ አዉዋ ያቆባ ሸምፑ ስሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","እስራኤሊ፥ “ሄዌ ታዉ ግዴ፤ ታ ናኣ ዮሴፎ ሀኖ ጋካናዉ ፓጻ ደኤ! ታን ሀይቃናፐ ካሰ ባደ፥ አ በአና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","እስራኤሊ ባረዉ ደእያዋ ኡባ አክ ደንዲደ፥ በርሳበሀ ጋኬዳ፤ እ ባረ አዉዋ ይሳቃ ጾሳዉ ያርሹዋ ያርሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ጾሳይ ቃማ አኩሙዋን አ፥ “ያቆባ፥ ያቆባ” ያጌዳ። እ፥ “አቤ” ጊደ ኮዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","አ፥ “ታን ጾሳ፥ ነ አዉዋ ጾሳ፤ ኔን ዱገ ግብጼ ባናዉ ያዮፓ፤ አያዉ ጎፐ፥ ታን ኔና ያን ዎልቃማ ካዉተꬃ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ታን ኔናና እትፐ ግብጼ ባና፤ ቃይ ታን ነ ዘረꬃ ያፐ ከሳና። ዮሴፎ ባረ ኩሽያን ነ አይፍያ ሺሻና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ሄዋፐ ጉየ፥ ያቆብ በርሳበሄፐ ደንዴዳ፤ እስራኤልያ አቱማ ናናይ ባረንቱ አዉዋ ያቆባ፥ ባረንቱ ናናነ ባረንቱ ማቻቱዋ ግብጼ ካቲ ኡንቱንቶ ኪቴዳ ፓራ ጋርያን ዎꬂደ አፌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ኡንቱንቱ ካናነ ቢታን ሞዴዳ ማጹዋነ መህያ ኡባ አፌድኖ። ያቆብነ አ ዘረꬃ ኡባይ አናና ግብጼ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","እ ባረ አቱማ ናናነ ባረ ናና አቱማ ናና፥ ባረ ማጫ ናናነ ባረ ናና ማጫ ናና፥ ሄዌነ ባረ ዘረꬃ ኡባ ባረናና ግብጼ አፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","እስራኤላና ግብጼ ጋድያ ቤዳ እስራኤልያ ናና ሱንꬃይ ሀዋፐ ካሊደ ጻፈቴዳዋ። ያቆባ ባይራ ናአይ ሮቤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ሮቤላ አቱማ ናናይ ሀኖካ፥ ፓሉ፥ ሄጽሮናነ ካርማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ስሞና አቱማ ናናይ ይሙኤላ፥ ያሚና፥ ኦሃዳ፥ ያኪና፥ ጾሃራነ ካናነ ምሽራት ናኣ ሻኡላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ሌዊ አቱማ ናናይ ገርሾና፥ ቃሃታነ ማራራ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ይሁዳ አቱማ ናናይ ኤራ፥ ኦናና፥ ሼላ፥ ፓሬሳነ ዛራሀ፤ ሽን ኤርነ ኦናን ካናነ ቢታን ሀይቄድኖ። ፓሬሳ አቱማ ናናይ ሄጽሮናነ ሀሙላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ይሳኮራ አቱማ ናናይ ቶላአ፥ ፑዋ፥ ያሹባነ ሽምሮና። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ዛብሎና አቱማ ናናይ ሰሬዳ፥ ኤሎናነ ያህላኤላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ሀዋንቱ ልያ ማስጰጾምያን ያቆባዉ የሌዳ አቱማ ናና፤ እ ማጫ ናታ ዲኖ። ሀዋንቱ አ ናናይነ ናና ናናይ ሙሊ ሀታማነ ሄዛ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ጋደ አቱማ ናናይ ጻፎና፥ ሀጋ፥ ሹና፥ ኤጽቦና፥ ኤር፥ አሮዳነ አርኤላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","አሴራ አቱማ ናናይ ይምና፥ ይሽዋ፥ ይሽዋሀነ ባሪአ፤ ኡንቱንቱ ምቻታ ሰራሆ። ባሪአ አቱማ ናናይ ሄቤራነ ማልክኤላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ላባን ባረ ናት ልዮ እሜዳ ዝልፓ ያቆባዉ የሌዳ ናናይ ሀዋንታ፤ ኡንቱንቱ ሙሊ ታማነ ኡሱፑና። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ያቆባ ማቻት ራሄል አቱማ ናናይ ዮሴፎነ ቢንያማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ኦና ካታማ ቄስያ ጶጽፋራ ናታ አስናታ ዮሴፎዉ ግብጼን ምናሳነ ኤፍሬማ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ቢንያማ ናናይ በላአ፥ በኬራ፥ አሽቤላ፥ ጌራ፥ ናእማና፥ ኤሀ፥ ሮሻ፥ ሙፒማ፥ ሁፒማነ አራዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ያቆባዉ የለቴዳ ራሄል አቱማ ናናይ ሀዋንታ፤ ኡንቱንቱ ሙሊ ታማነ ኦይዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ዳና አቱማ ናአይ ሁሺማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ንፍታሌማ አቱማ ናናይ ያህጽኤላ፥ ጉና፥ የጼራነ ሺሌማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ላባን ባረ ናት ራሄልዉ እሜዳ ባላ ያቆባዉ የሌዳ ናናይ ሀዋንታ፤ ኡንቱንቱ ሙሊ ላፑና። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ያቆባና ግብጼ ቤዳ፥ አ ጉልባታፐ የለቴዳዋንቱ፥ አ ናና ማቻቱዋ ጉጀናን፥ ሙሊ ኡሱፑን ታማነ ኡሱፑና። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ግብጼን ዮሴፎዉ የለቴዳ ላኡ ናና ጉጅና፥ ግብጼ ቤዳ ያቆባ ሶ አሳይ ሙሊ ላፑን ታማ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ገሴመ ቢታን ሞካና ማላ፥ ያቆብ ይሁዳ ባረፐ ስንꬃዉ ዮሴፎኮ ኪቴዳ፤ ኡንቱንቱ ገሴመ ጋኬዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ዮሴፎ ባረ ፓራ ጋርያ ጊግሲደ፥ ባረ አዉዋ እስራኤላና ጋከታናዉ ገሴመ ቤዳ። ዮሴፎ ባረ አዉዋ ደሜዳ ሳናካ አ ቆꬍያን ጻጸት ቆም፥ ዳሮ ዎድያ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","እስራኤሊ ዮሴፎ፥ “ኔን ፓጻ ደእሽን፥ ታን ነ አይፍያ በኤዳ ድራዉ፥ ሀእ ታን ሀይቂንቶነ አይነ ባዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ሄዋፐ ጉየ፥ ዮሴፎ ባረ እሻቱዋነ ባረ አዉዋ ሶ አሳ፥ “ታን ግብጼ ካትያኮ ባና፤ አዉ፥ ‘ካናነ ቢታን ደእያ ታ እሻቱዋነ ታ አዉዋ ሶ አሳይ ታኮ ዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ኡንቱንቱ ዶርሳ ሄንꬃንቻ፤ ኡንቱንቱ መህያ ሄምኖ፤ ኡንቱንቱ ባረናና ባረንቱ ዶርሳቱዋ፥ ባረንቱ ምያቱዋነ ባረንቶ ደእያዋ ኡባ አኪደ ዬድኖ’ ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ካቲ ህንተንታ ጼስሲደ፥ ‘ህንተ ኪታይ አዬ?’ ያጊደ ኦቾፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ህንተንቱ አዉ፥ ‘ኑን ነ ቆማቱ ናአተꬃፐ ዶሚደ፥ ኑ አዎቱዋዳን መህያ ሄሜቶ’ ያግተ። እ ህንተንታ ገሴመ ጋድያን ዎꬃናዋ፤ አያዉ ጎፐ፥ ዶርሳ ሄንꬃንቻ ኡባይ ግብጼ አሳን ካቴዳዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ዮሴፎ ገሊደ ግብጼ ካትያዉ ሀዋዳን ያጊደ ኦዴዳ፤ “ታ አዉነ ታ እሻቱ፥ ባረንቱ ዶርሳ ዉድያና፥ ባረንቱ ምያ ዉድያናነ ባረንቶ ደእያዋ ኡባና ካናነ ቢታፐ ዪደ፥ ሀእ ገሴመ ቢታን ደእኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","እ ባረ እሻቱዋፐ እቼሻቱዋ ዶሪደ ካትያ ስንꬃ አꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ካቲ ሄ እሻቱዋ፥ “ህንተንቱ ኪታይ አዬ?” ያጊደ ኦቼዳ። ኡንቱንቱ ካትያዉ፥ “ኑን ነ ቆማቱ ኑ አዎቱዋዳንካ ዶርሳ ዉድያ ሄሜቶ” ያጊደ ዛሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ቃይ ኡንቱንቱ አዉ፥ “ካናነ ቢታን ኮሻይ ጺጽ ደእያ ድራዉነ ነ ቆማቱዋ መህያዉ ምያባይ አይነ ባይና ድራዉ፥ ኑን ሀዋን አማሬዳ ዎድያ ደአናዉ ዬዶ፤ ሀያና ኑና ነ ቆማቱዋ ገሴመን ዎꬃርኪ!” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ካቲ ዮሴፎ፥ “ነ አዉነ ነ እሻቱ ኔኮ ዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ስም ግብጼ ቢታይ ነ ኩሽያን ደኤ፤ ሀ ጋድያን ኡባ ሳፐ አꬊደ ሎኢያሳን ነ አዉዋነ ነ እሻቱዋ ዎꬃ፤ ኡንቱንቱ ገሴመ ቢታን ደኢኖ። ኔን ኤርና፥ ኡንቱንቱ ግዶፐ ዱማ ኤራተꬃይ ደእያዋንቱ ደኦፐ፥ ሄዋንታ ታ መህያ ቦላ ሱንꬃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ሄዋፐ ጉየ፥ ዮሴፎ ባረ አዉዋ ያቆባ ገልሲደ፥ ካትያ ስንꬃ አꬄዳ። ያቆብ ግብጼ ካትያ አንጄዳዋፐ ጉየ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ካቲ ያቆባ፥ “ነዉ ዎይሳ ላይꬄ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ያቆብ ካትያ፥ “ታን ዩያደ ደኤዳ ላይꬃይ ጼታነ ሀታማ፤ ታ ላይꬃይ በን ታ አዎቱ ዩዪደ ደኤዳ ላይꬃቱዋፐ ጉꬃነ መቱ ዳሬዳዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ሄዋፐ ጉየ፥ ያቆብ ካትያ አንጂደ፥ አ ስንꬃፐ ካረ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ዮሴፎ ባረ አዉዋነ ባረ እሻቱዋ ግብጼ ቢታን ዎꬄዳ፤ ካቲ አዛዜዳዋዳን ግብጼ ቢታን ራምሳ ግያ ካታማ ማታን ደእያ፥ ኡባ ሳፐ አꬊደ ሎእያ ጋድያ ኡንቱንቶ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ዮሴፎ ቃይ ባረ አዎ፥ ባረ እሻቶነ ባረ አዉዋ ሶ አሳ ኡባዉ ኡንቱንቱ ናና ፓይዱዋዳን ካꬃ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ግዶፐነ ኮሻይ ጺጽ ደእያ ድራዉ፥ ሄ ቢታ ኡባን ካꬅ ባዋ። ሄ ኮሻን ግብጼነ ካናነ ቢታይ ላአቱካ ቆሄቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ዮሴፎ ግብጼ ካꬃ ዛልኢደ፥ ግብጼነ ካናነ ቢታቱዋን ደእያ ሚሻ ኡባ ሺሼዳ፤ ግብጼ ካትያ ጎለ ገልሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ግብጼነ ካናነ ሻሉ ዉሬዳ ዎደ፥ ግብጼ አሳይ ኡባይ ዮሴፎኮ ዪደ አ፥ “ኑዉ ካꬃ እማ፤ ኑ ሻሉ ዉሬዳ ድራዉ፥ ኑን ነ ስንꬃን አያዉ ሀይቄቶ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ዮሴፎ ኡንቱንታ፥ “ያቶፐ ህንተንቱ መህያ አክ ዪተ፤ ህንተንቱ ሻሉ ዉር ክቼዳዋ ግዶፐ፥ ታን ካꬃ ህንተንቱ መህያና ላማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ሄዋ ድራዉ ኡንቱንቱ ባረንቱ መህያ ዮሴፎዉ አሄድኖ። ዮሴፎ ኡንቱንቱ ፓራ፥ ዶርሳ፥ ዴሻ፥ ምያነ ሀርያ ካꬃና ላሜዳ፤ እ ሄ ላይꬃ ኡንቱንቱ መህያ ኡባና ካꬃ ላሚደ ኡንቱንታ ምዝ ሻቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ሄ ላይꬃይ ዉርና፥ ኡንቱንቱ ላኤንꬃ ላይꬃን አኮ ዪደ አ፥ “ኑን ኑ ጎዳፐ ቆስያባይ ባዋ፤ ኑ ሚሻ ኡባይ ዉር ድግና፥ ኑ መህያካ ነዉ ሼꬊደ፥ ኑ ቦላፐነ ኑ ጋድያፐ አትን፥ ኑ ጎዳዉ አቴዳባይ ሀራባይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ኑን ነ ስንꬃን አያዉ ሀይቄቶ? ኑ ጋዲካ አያዉ ꬋዪ? ኑናካ ኑ ጋድያካ ካꬃን ሻማ፤ ኑን ካትያዉ አይለታና፤ ኑ ጋዲካ አዋ ግዶ፤ ኑን ፓጻ አታና ማላ፥ ሀይቀና ማላነ ኑ ጋዲካ ኦጸና ማላ፥ ዘረꬃ ኑዉ እማ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ዮሴፎ ግብጼ ቢታ ኡባ ካትያዉ ሻሜዳ። ግብጼቱ ኡባይ ኮሻይ ጺጽ ደእያ ድራዉ፥ ባረንቱ ጋድያ ዛልኤድኖ፤ ጋዲ ካትያዋ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ዮሴፎ አሳ ኡባ ግብጼዉ ሀ ጋጻፐ ዶሚደ ህን ጋጻ ጋካናዉ ካትያዉ አይለ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ግዶፐነ እ ቄሳቱ ዋ ጋድያ ሻምቤና፤ አያዉ ጎፐ፥ ካቲ ቄሳቶ ካꬃ እሜዳ። ሄዋ ድራዉ ባረንቱ ጋድያ ዛልእበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ዮሴፎ አሳ፥ “ስም ሀቼ ታን ህንተናነ ህንተንቱ ጋድያ ካትያዉ ሻማድ። ዘረꬃ አፊደ፥ ጋደን ዘርተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ሽን ካꬃ ጫክ ገልስያ ዎደ፥ አይፌዳዋፐ እቼሹ ኩሽያፐ እት ኩሽያ ካትያዉ እምተ። እቼሹ ኩሽያፐ አቴዳ ኦይዱ ኩሺ ህንተንቱ ጋድያ ዘረꬃነ ህንተንቶ፥ ህንተንቱ ሶ አሳዉነ ህንተንቱ ናናዉ ቁማ ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ኡንቱንቱ፥ “ኔን ኑና አሻዳ! ኑ ጎዳ ስንꬃን ኑን ሳባ ደሜሮኮሻ፤ ኑን ካትያዉ አይለታና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ሄዋ ድራዉ፥ ዮሴፎ ግብጼን ቢታፐ አይፌዳዋፐ እቼሹ ኩሽያፐ እቱዋ ካትያዉ እምያዋ ህግያ ከሴዳ። ሄ ህጊ ሀቼ ጋካናዉ ኤቂደ ደኤ። ካትያዋ ግድቤና ጋዲ ቄሳቱዋ ጋድያ ጻላላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","እስራኤለቱ ግብጼ ቢታን ገሴመ ግያ ሳን ኡቴድኖ፤ ኡንቱንቱ ያን ማጹዋ ደሜድኖ፤ ኡንቱንቱ የለቴድኖነ ዳሮ ጮራቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ያቆብ ግብጼ ቢታን ታማነ ላፑን ላይꬃ ደኤዳ። ያቆብ ደኤዳ ላይꬃይ ጼታነ ኦይታማነ ላፑና። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","እስራኤለ ሀይቂያ ዎዲ ማታትና፥ ባረ ናኣ ዮሴፋ ጼስሲደ ሀዋዳን ያጌዳ፤ “ታን ነ ስንꬃን ሳበቴዳዋ ግዶፐ፥ ነ ኩሽያ ታ ጉልባታን ዎꬃደ፥ አነ ገፓ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ሽን ታን ታ ማይዛን ጋከትያ ዎደ፥ ታና ግብጼፐ አፋደ፥ ኡንቱንቱ ሞገቴዳ ሳኣን ሞጋ” ያጌዳ። ዮሴፎ፥ “ታን ኔና ኔን ጌዳዋዳን ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ያቆብ አ፥ “አነ ታዉ ጫቃ” ያጌዳ። ዮሴፎ አዉ ጫቄዳ፤ ሄዋፐ ጉየ፥ እስራኤሊ ባረ ሂጻን ጉፋኒደ፥ ጾሳዉ ጎይኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ሄዋፐ ጉየ አሳይ ዮሴፎዉ፥ “ነ አዉ ሳከቴዳ” ያጊደ ኦዴዳ። እ ባረ ላኡ አቱማ ናና ምናሳነ ኤፍሬማ አኪደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","አሳይ ያቆባ፥ “በአ፤ ነ ናአይ ዮሴፎ ኔኮ ዬዳ” ያጌዳ፤ እስራኤሊ ምነቲደ ባረ ሂጻን ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ያቆብ ዮሴፎ፥ “ኡባ ዳንዳይያ ጾሳይ ካናነ ቢታን ሎዛ ግያ ሳኣን ታዉ ቆንጪደ፥ ያን ታና አንጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","እ ታና፥ ‘ታን ኔና የለትሳናነ ጮርሳና፤ ታን ኔና ዳሮ ደረ ኦꬃና። ሀ ቢታ ታን ኔፐ ጉየ፥ ነ ዘረꬃዉ መꬍና ላታ ኦꬃደ እማና’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“ስም ሀእ፥ ነ ላኡ አቱማ ናናይ፥ ታን ኔኮ ሀዋ ያናፐ ካሰ ግብጼን ነዉ የለቴዳዋንቱ ታዋንታ፤ ኤፍሬምነ ምናሰ ታዉ ሮቤላነ ስሞና ማላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ኡንቱንቱፐ ጉየ ነዉ የለቴዳዋንቱ ነዋንታ፤ ኡንቱንቱ ላታና ቢታይ ኤፍሬማነ ምናሳ ሱንꬃን ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ታን ማስጰጾምያፐ ስምሽን፥ ኤፍራታ ጋካናዉ ላፋ አሽያ ዎደ፥ ራሄላ ካናነ ቢታን ሀይቃዱ። ታን እዞ ቤተሌመ ግያ ኤፍራታ አፍያ ኦግያ ዶናን ሞጋድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","እስራኤሊ ዮሴፎ አቱማ ናና ላአቱዋ በኤዳ ዎደ፥ “ሀዋንቱ ኦኔ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ዮሴፎ ባረ አዉዋ፥ “ሀዋንቱ ጾሳይ ታዉ ሀዋን እሜዳ ታ ናና” ያጌዳ። እስራኤሊ፥ “ታን ኡንቱንታ አንጃና ማላ፥ ኡንቱንታ ታኮ ሃ ሺሻ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","እስራኤሊ ጭምና አ አይፊ ላባኔዳ ድራዉ፥ ጼላናዉ ዳንዳየና። ሄዋ ድራዉ ዮሴፎ ባረ አቱማ ናና አኮ ሺሽና፥ አ አዉ ኡንቱንታ እድሚደ የሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","እስራኤለ ዮሴፋ፥ “ታን ነ ዴሙዋ በአና ጋደ ቆፓበይከ፤ ሽን ጾሳይ ሄኮ ነ ናናካ ታና በሴዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ዮሴፎ ኡንቱንታ አ ጉልባታፐ ደንꬂደ፥ ባረ ዴሙዋ ሳኣ ጋꬂደ ጎይኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ዮሴፎ ባረ ላኡ አቱማ ናና፥ ኤፍሬማ ባረ ኡሸቻ ባጋን እስራኤልያዉ ሀድርሳ ባጋና፥ ምናሳ ባረ ሀድርሳ ባጋን እስራኤልያዉ ኡሸቻ ባጋና አኪደ፥ አኮ ሺሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ኤፍሬመ ቴፋ ግዶፐነ፥ እስራኤሊ ባረ ኡሸቻ ኩሽያ የዲደ አ ሁጲያን ዎꬄዳ፤ ቃይ ምናሰ ባይራ ግዶፐነ፥ እስራኤሊ ባረ ኩሽያ የዲደ፥ ባረ ሀድርሳ ኩሽያ ምናሰ ሁጲያን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ሄዋፐ ጉየ፥ ያቆብ ዮሴፋ ሀዋዳን ያጊደ አንጄዳ፤ “ታ አዎቱ አብራሃመነ ይሳቅ አ ስንꬃን ሄመቴዳ ጾሳይ፥ ታ ደኡዋ ኡባን ሀቼ ጋካናዉ ታና ሄሜዳ ጾሳይ፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ኢታባ ኡባፐ ታና አሼዳ ኪታንቻይ፥ ሀ ናና አንጆ። ታ ሱንꬃይነ ታ አዎቱዋ አብራሃማነ ይሳቃ ሱንꬃይ ኡንቱንቱን ጼሰቶ። ኡንቱንቱ ሳኣ ቦላን ጮራትኖ” ያጊደ አንጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ዮሴፎ ባረ አዉ ባረ ኡሸቻ ኩሽያ ኤፍሬማ ሁጲያን ዎꬄዳዋ በኤዳ ዎደ ዶስቤና። ሄዋ ድራዉ፥ ኤፍሬማ ሁጲያፐ ደንꬂደ፥ ምናሰ ሁጲያን ዎꬃናዉ ባረ አዉዋ ኩሽያ ኦይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ዮሴፎ ባረ አዉዋ፥ “ታ አዎ፥ ሄዋ ግደና፤ ባይራይ ሀዋተ፤ ነ ኡሸቻ ኩሽያ ሀዋ ቦላ ዎꬃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ሽን አ አዉ እጺደ አ፥ “ታን ኤራይ፤ ታ ናአዉ፥ ታን ኤራይ፤ እካ ዎልቃማ ደረ ግዳና። ግዶፐነ አ ቴፋ እሻይ አፐ አꬍ ግታታና፤ አ ዘረꬃይካ ዳሪ ዎልቃማ ካዉተꬃ ግዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","እ ሄ ጋላስ ኡንቱንታ አንጂደ፥ “እስራኤላቱ አንጅያ ዎደ፥ ‘ጾሳይ ህንተንታ ኤፍሬመዳንነ ምናሰዳን ኦꬆ’ ያጊደ ህንተንቱ ሱንꬃን አንጃና” ያጌዳ። ኤፍሬማ ምናሰፐ ስንꬃዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ሄዋፐ ጉየ እስራኤሊ ዮሴፎ፥ “ታን ሀያና ሀናይ፤ ሽን ጾሳይ ህንተናና ግዳና፤ ቃይ እ ህንተንቱ አዎቱዋ ጋድያ ህንተንታ ጉየ ዛራና። ");
INSERT INTO dwrENT_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ቃይ ኔና ነ እሻቱዋና ጋክያ ቢታፐ እት ሳማ ዳርሳደ ነዉ እማይ፤ ሄዌነ ታን አሞራቱዋፐ ታ ማሻንነ ታ ዎንዳፍያን አኬዳ ቢታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ሄዋፐ ጉየ፥ ያቆብ ባረ አቱማ ናና ጼስሲደ ሀዋዳን ያጌዳ፤ “ስንꬃፐ ህንተንቶ ሀናናባ ታን ህንተንቶ ኦዳና ማላ ሺቅተ።” ");
INSERT INTO dwrENT_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“ህንተንቶ ያቆባ ናናቶ፥ እትፐ ሺቂደ ስስተ፤ ህንተንቱ አዉ እስራኤሊ ህንተንቶ ኦድያዋ ሀይዝተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“ሮቤላ፥ ታ ባይራ ናአዉ፥ ኔን ታ ዎልቃ፤ ታ ምኖተꬃዉ ኮይሩዋ። ኔን ቦንቹዋንካ ዎልቃንካ ኡባፐ አꬍያዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ኔን ድኡዋ ማላ፤ ኤቆሳአን ደአካ፤ ኔን ኡባፐ አꬍያዋ ግዳካ። አያዉ ጎፐ፥ ኔን ነ አዉዋ ግሱዋ ከሳዳ፤ ነ አዉዋ ግሱዋ ቱንሳዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“ስሞንነ ሌዊ እሻቱዋ፤ ኡንቱንቱ ማሻይ ማካላተꬃዉ ኦላ ሚሻ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ታን ኡንቱንቱ ዞረታን ገልከ፤ ታን ኡንቱንቱ ሺቁዋንካ ኡትከ፤ አያዉ ጎፐ፥ ኡንቱንቱ ባረንቱ ሀንቁዋን አሳ ዎꬌድኖ ባረና አካ አካ ጊና፥ ቦራቱዋ ቃንጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ኡንቱንቱ ሱሎ ሀንቁ ኡንቱንቱ መቀꬃ ኢታተꬃይነ ሸቀቴዳዋ ግዶ! ታን ኡንቱንታ ያቆባ አሳ ግዱዋን ላላና፤ እስራኤልያ ቢታን ትስክ ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“ይሁዳዉ፥ ነ እሻቱ ኔና ጋላታና። ነ ኩሺ ነ ሞርከቱዋ ፕላንትያ ኦይቃና። ነ አዉዋ ናናይ ነዉ ሆኪደ ጎይናና። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ይሁዳዉ፥ ኔን ዎዳላ ጋሞ። ታ ናአዉ፥ ኔን ሻንካፐ ዎꬍ ስሚደ፥ ጮጎቲደ ግሴዳ ጋሙዋ ማላ። ኔን አሳ ቦሸረꬃናዉ ኮየና ማጫ ጋማት ማላ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","አይስያዌ ያና ጋካናዉ፥ ካዉተꬃ ጻምአይ ይሁዳፐ፥ ደርያ አይስያዋንቱ ጋትማይ አ ገድያ ግዶፐ ሻከተና። ቃይ ደርያ አሳይ አዉ አዛዘታና። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","እ ባረ ሀርያ ዎይንያ አኑዋን፥ ባረ ሀረ ማራ ሙሩታ ዎይንያ ቱራን ቃቻና። እ ባረ አፍላ ዎይንያ ኤሳን፥ ባረ ማዩዋ ሱꬃ ማላትያ ዎይንያ ኤሳን ሜጫና። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","አ አይፊ ዎይንያ ኤሳፐ አꬍ ዞአና፤ አ አቻይካ ማꬃፐ አꬍ ቦጻና። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“ዛብሎነ አባ ዶናን ደአና፤ እ አባ ዶናን ማርካባቱ ኤቂያ ሳኣ ግዳና፤ አ ዛዋይ ሲዶና ጋካናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ይሳኮረ ምኖ ሀርያ፤ ጫንያ ላኡ ዶንያቱዋ ግዱዋን ግስ ባሼ ");
INSERT INTO dwrENT_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","እ ባረ ሸምፕያሳ ሎአ ግድያዋነ ባረ ቢታይ ናሸችያዋ ግድያዋ በእያ ዎደ፥ ጫና ቶካናዉ ባረ ሀሽያ ሆክሲደ፥ አይለተꬃ ኦሱዋ ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ዳን እስራኤልያ ዛራቱዋፐ እቱዋ ግዴዳ ባረ አሳ ቦላ ዳናታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ዳን ኦግያ ዶናን ደእያ ሾሻ፤ ፓራ ቶጌዳዌ ጉየ ኩንዳና ማላ ፓራ ግንድያ ዱክያ፥ ኦግያን ደእያ ሀሱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","አቤት መꬍና ጎዳዉ፥ ታን ኔን አሻናዳን ናጋይ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ጋድ ቦንቂያዋንቱን ደሸታናዋ፤ ሽን እካ ኡንቱንቱ ቃታማ ካሊደ ኡንቱንታ ቦንቃናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","አሴራ ኡክꬃይ ኦርዱዋ፤ ካትያዉ እ ሎኦ ቁማ እማና። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","ንፍታሌመ ቃሸተናን የዳ ደእያ፥ ሎኦ ማራቱዋ የልያ ገንእያ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","ዮሴፎ አይፍያና ዮንዶዴዳ ዎይንያ ቱራ። እ ፑልቱዋ ማታን ዮንዶዳ አይፍያና ደእያ፥ ዳሻይካ ጎዳፐ ቦላና ዛእያ ዎይንያ ቱራ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ዎንዳፍያ ዱክያዋንቱ አ ቦላ ዶዴድኖ፤ ባረንቱ ዎንዳፍያንካ፥ ዱኬድኖነ ማይትሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","አ ዎንዳፊ ምን ኡቴዳ፤ አ ዎልቃይካ ምኒደ ጋምኤዳ። ሄዌካ ያቆባ ጾሳ ዎልቃማ ኩሽያ ጋሱዋና፥ ነ ሄንꬃንቻ፥ እስራኤልያ ዛላ ጋሱዋና፥ ");
INSERT INTO dwrENT_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ኔና ማድያ ነ አዎቱዋ ጾሳ ጋሱዋንነ፥ ኔና ቦላ ሳሉዋ አንጁዋን፥ ጋርሳ ጪማ አንጁዋን፥ ꬋንꬃ አንጁዋንነ የልያ ኡሉዋ አንጁዋን አንጅያ፥ ኡባ ዳንዳይያ ጾሳ ጋሱዋና። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ነ አዉዋ አንጁ በን ደረቱዋ አንጁዋፐካ መꬍናፐ ደእያ አንጁዋፐካ አꬌ። ሀዌ ኡባይ ዮሴፎ ሁጲያን፥ ባረ እሻቱዋ ግዱዋን ካፑዋ ግድያዋ ሊጲያን ሸምፖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","ቢንያመ ቦንቂያ ዋልያ። ባረ ሻንካቴዳዋ ዎንታ ሜ፤ ባረ ኦሞዴዳዋ ኦማርስ ሻኬ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ሀዋንቱ ታማነ ላኡ እስራኤልያ ዛራቱዋ፤ ቃይ ኡንቱንቱ አዉ ኡንቱንታ ሁጲያን ሁጲያን ኡንቱንቶ በስያ አንጁዋ አንጂደ ኡንቱንቶ ጌዳዌ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ሄዋፐ ጉየ፥ እ ኡንቱንታ ሀዋዳን ያጊደ አዛዜዳ፤ “ታን ታ ማይዛ አሳቱዋን ጋከታናዉ ሀናይ፤ ታና ሂትያ ኤፍሮና ጋደን ደእያ ጎንጎሉዋን፥ ታ አዎቱዋና ሞግተ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ሄዌካ ካናነ ቢታን፥ ማምረ ማታን ደእያ፥ ማክጴላ ግያ ጎንጎሉዋ፤ ሄዌ አብራሃመ ሂትያ ኤፍሮናፐ አ ጋድያና ሻሜዳ ጎንጎሉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","አብራሃመነ አ ማቻታ ሳራ ያን ሞገቴድኖ፤ ይሳቅነ አ ማቻታ ርብቃ ያን ሞገቴድኖ፤ ታን ቃይ ልዮ ያን ሞጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ሄ ጋዲነ አን ደእያ ጎንጎሉ ሂተቱዋፐ ሻመቴዳዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ያቆብ ባረ ናናዉ አዛዙዋ ዉርሴዳ ዎደ፥ ባረ ገድያ ፑደ ባረ ሂጻዉ ሺሽ አኪደ፥ ሀይቂ አጌዳ፤ ባረ ማይዛን ጋከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ዮሴፎ ባረ አዉዋ አሃ ቦላ ኩንዲደ፥ ዬኬዳነ አ የሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ሄዋፐ ጉየ፥ ዮሴፎ ꬋልያ ሺሽያ ባረ ኦሳንቻቱዋ ባረ አዉዋ እስራኤልያ አሃ ሳዊያ ሽቱዋ ኦኪደ መልሳና ማላ አዛዜዳ፤ ኡንቱንቱ ኦኪደ መልሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ሽቱዋ ኦክያዌ ኦይታሙ ጋላሳ ኩመንꬃ ዉርሴዳ፤ አያዉ ጎፐ፥ ሄዌ ጋድያ ዎጋን ኦይታሙ ጋላሳ አኬዳ። ግብጼ አሳቱ አዉ ላፑን ታሙ ጋላሳ ዬኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ዬኩዋ ጋላሳቱ አꬌዳ ዎደ፥ ዮሴፎ ግብጼ ካትያ ጎለ አሳ፥ “ታን ህንተንቱ ስንꬃን ናሸቴዳዋ ግዶፐ፥ ህንተንቱ ካትያዉ ሀዋዳን ያጊደ ኦድተ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘ታ አዉ ታና እት ጫቁዋ ጫቂሴዳ፤ እ ታና፥ “ታን ሀያና ሀናይ፤ ታን ታዉ ካናነ ቢታን ቦኬዳ ጎንጎሎ ዱፉዋን ታና ሞጋ” ያጌዳ። ሄዋ ድራዉ ሀእ ታን ፑደ ባደ ታ አዉዋ ሞጋና ማላ የዳርኪ! ሄዋፐ ጉየ ታን ስማና’ ያግተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ካቲ፥ “እ ኔና ጫቂሴዳዋዳን ፑደ ባደ ነ አዉዋ ሞጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ዮሴፎ ባረ አዉዋ ሞጋናዉ ፑደ ቤዳ። ካትያ ኦሳንቻቱ ኡባይ፥ አ ካትያ ጎለን ደእያ ዎልቃማ አሳይ ኡባይነ ግብጼ ቢታን ደእያ ዎልቃማ አሳይ ኡባይ ዮሴፋ ካሊደ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ቃይ ዮሴፎ ሶ አሳይ ኡባይ፥ አ እሻቱዋነ አ አዉዋ ሶ አሳይ ቤድኖ፤ ኡንቱንቱ ናናይ፥ ኡንቱንቱ ሚዛይነ ኡንቱንቱ ዶርሳ ዉዲ ጻላላይ ገሴመን አቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ፓራ ጋረቱካ ፓራ አሳቱካ አናና ፑደ ቤድኖ፤ አ ካሊደ ቤዳ አሳይ ሎይꬅ ዳራ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ኡንቱንቱ ዮርዳኖሳ ሻፋ ማታን ደእያ አጻደ ግያ ኡዱማ ጋኪደ፥ ባረንቱ ቃላ ꬎቁ ኦꬂደ፥ አዉ ዝላሌድኖነ ዬኬድኖ፤ ያን ዮሴፎ ባረ አዉዋ ዬኩዋን ላፑን ጋላሳ ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ሄ ቢታን ደእያ ካናነ አሳቱ አጻደ ግያ ኡዱማን ሄ ዬኩዋ በኤዳ ዎደ፥ “ግብጼቱ አያ ይባታ ዬኩዋ ዬክኖ!” ያጌድኖ። ሄዋ ድራዉ ዮርዳኖሳ ማታን ደእያ ሄ ሳአይ፥ አቤል-ምጽራይማ ጌተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ያቆባ ናናይ ባረንቱ አዉ ኡንቱንታ አዛዜዳዋዳን ኦꬄድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ኡንቱንቱ አ አሃ ካናነ ጋድያ አፊደ፥ ማምረ ማታን ደእያ ማክጴላ ግያ ጎንጎሉዋን፥ አብራሃመ ሂትያ ኤፍሮናፐ ሞጎ ሻሜዳ ጋድያን አ ሞጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ዮሴፎ ባረ አዉዋ ሞጌዳዋፐ ጉየ፥ ባረ እሻቱዋናነ አ አዉዋ ሞጋናዉ አናና ቤዳ ሀራ አሳቱዋ ኡባቱዋና ግብጼ ስሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ኡንቱንቱ አዉ ሀይቂ ድጌዳዋ በኢደ፥ ዮሴፎ እሻቱ ባረንቱ ግዱዋን፥ “ኦን ኤሪ ዮሴፎ ኑና ባረ ኡሉዋን ሞርኮፐነ ኑን አዉ ኦꬄዳ ኢታባ ኡባዉ ሀሉዋ ከሳና ኮዮፐ፥ ኑን ዋናኔ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ሄዋ ድራዉ ዮሴፎኮ ሀዋ ማላ ኪታ ኪቴድኖ፤ “ነ አዉ ሀይቃናፐ ካሰ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘ህንተ ዮሴፎ፥ “ኔን ነ እሻቱዋ ናጋራነ ኡንቱንቱ ኔና ናቄዳ ኢታ ናቁዋ ሀያና አቶ ያጋ” ያጌዳ ጊደ ኦድተ’ ያጌዳ። ሄዋ ድራዉ ሀእ ሀያና፥ ኑ ናጋራ፥ ነ አዉዋ ጾሳ ቆማቱዋ ናጋራ አቶ ያጋ” ያጌድኖ። ኪታይ ባረኮ ጋኬዳ ዎደ፥ ዮሴፎ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ሄዋፐ ጉየ አ እሻቱ ባረንቱ ሁጲያዉ አኮ ዪደ፥ አ ስንꬃን ጉፋኒደ፥ “ኑን ነ አይለቱዋ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ሽን ዮሴፎ ኡንቱንታ፥ “ያዮፕተ፤ ታና ህንተንቶ ጾሳ ጌድተየ? ");
INSERT INTO dwrENT_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ህንተንቱ ታዉ ኢታናዉ ኦꬄድታ፤ ሽን ሀቼዋዳን ዳሮ አሳይ ሀይቀናን አታና ማላ፥ ጾሳይ ሎኦተꬃዉ ሀዋ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ሄዋ ድራዉ ስም ህንተንቱ ያዮፕተ፤ ታን ህንተናነ ህንተንቱ ናና ምዛና” ያጊደ፥ እ ኡንቱንታ ምንꬂደ ሎኦ ቃላ ሃሳዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ዮሴፎ ባረ አዉዋ ሶ አሳ ኡባና ግብጼን ጋምኤዳ፤ እ ጼታነ ታሙ ላይꬃ ደኤዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ኤፍሬማ ናና፥ ሄዘንꬃ የለታ በኤዳ፤ ቃይ ምናሰ ናኣ ማኪና ናናነ እ ባረ ናና ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ሄዋፐ ጉየ ዮሴፎ ባረ እሻቱዋ፥ “ታን ሀያና ሀናይ፤ ሽን ጾሳይ ህንተንታ ማዳናዉ ቱሙ ጾሞሳና፤ እ ህንተንታ ሀ ቢታፐ ከሲደ፥ አብራሃመዉ፥ ይሳቃዉነ ያቆባዉ እማና ጊደ ጫቄዳ ቢታ አፋና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ዮሴፎ እስራኤልያ ናና፥ “ጾሳይ ህንተንታ ማዳናዉ ቱሙ ጾሞስያ ዎደ፥ ህንተንቱ ታ መቀꬃ ሀ ቢታፐ ፑደ አኪደ ቢተ” ያጊደ ጫቂሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ዮሴፎ ጼታነ ታሙ ላይꬃ ደኢደ ሀይቄዳ፤ ኡንቱንቱ ሽቱዋን አ አሃ ኦኪደ መልሴዳዋፐ ጉየ፥ ግብጼ ቢታን ሳጽንያን የጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ያቆባና ግብጼ ቤዳ እስራኤልያ አቱማ ናና ሱንꬃይ ሀዋፐ ካሊደ ጻፈቴዳ፤ ኡንቱንቱ ኡባይካ ባረንቱ ሶይ አሳ አኪደ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ሄዋንቱካ: ሮቤላ፥ ስሞና፥ ሌዋ፥ ይሁዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ይሳኮራ፥ ዛብሎና፥ ቢንያማ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ዳና፥ ንፍታሌማ፥ ጋዳነ አሴራ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ያቆባ ዘረꬃቱ ኡባይ ላፑን ታማ፤ ዮሴፎ ካሰካ ግብጼ ብ ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ዮሴፎ፥ አ እሻቱነ ሄ የለታ ኡባይ ሀይቄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ሽን እስራኤልያ ዘረꬃይ አይፌድኖነ ሎይꬅ ዳሬድኖ፤ ሄ ቢታ ኩማና ጋካናዉ ኡንቱንቱ ሎይꬅ ጮራቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ሄዋፐ ጉይያን፥ ዮሴፎ ኤረና ኦራꬃ ካቲ ግብጼ ጋድያን ደንዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","እ ባረ አሳ፥ “በእተ፤ ሀ እስራኤላቱ ኑፐ ሎይꬅ ጮራቴድኖነ ዎልቃሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ሃ ዪተ፥ አነ ኑን ኡንቱንታ ሂላን ኦይቆይተ፤ ሄዌ ꬋዮፐ ኡንቱንቱ ካሰዋፐ ያ ዳራና። ኦን ኤር ኦላይ ደንዶፐ፥ ኡንቱንቱ ኑ ሞርከቱዋና ዳንꬂደ፥ ኑና ኦላናነ ጋድያ የጊደ ከስ አኪደ ባናዋንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ሄዋ ድራዉ፥ ዴጾ ኪታን ኡንቱንታ ቱጋያና ማላ፥ ኡንቱንቱ ቦላ መቀꬅ ባይና ካፖቱዋ ሱንꬄድኖ። ኡንቱንቱ ካትያዉ ፒቶማነ ራምሳ ጌተትያ ሚሻ ምንጅያ ካታማቱዋ ኬጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ሽን ግብጼቱ ኡንቱንታ ኡንኡዋ ዳርያ ዎደ፥ ኡንቱንቱ ጮራት የለቴድኖነ ቢታ ጋኬድኖ። ሄዋ ድራዉ፥ ግብጼቱ እስራኤላቶ ያዬድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ቃረታይ ባይና ሀኖታን አይለተꬃን ኪትሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ቃረታይ ባይና ዎልቃማ ኪታን፥ ስምንቱዋንነ ጹብያ መꬉዋን፥ ቃይ ሾይቃን ኦꬅያ ኡባ ቆሞ ኪታን፥ ኡንቱንቱ ደኡዋ ጫምሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ግብጼ ካቲ እብራዌ ማጫዋንታ ማርስያ ጽፓሮነ ፑሆ ጌተትያ ላኡ ማጫዋንታ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“እብራዌ ማጫ አሳቱ የልያ ዎደ ህንተንቱ ማርሲደ፥ የልሶዌ አቱማ ናኣ ግዶፐ፥ ዎꬍተ፤ ሽን ማጫ ናቶ ግዶፐ ዎꬎፕተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ሽን ማርስያዋንቱ ጾሳዉ ያዪደ፥ ግብጼ ካቲ ኡንቱንታ አዛዜዳዋዳን ኦꬅበይክኖ። ኡንቱንቱ አቱማ ናና ሸምፑዋና አሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ሄዋፐ ጉይያን ግብጼ ካቲ ሄ ማርስያዋንታ ጼሲደ፥ “ህንተንቱ አያዉ ሀዋዳን ኦꬂቴ? አቱማ ናና አያዉ ሸምፑዋና አጊቴ?” ያጊደ ኡንቱንታ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ማርስያዋንቱ ዛሪደ፥ “እብራዌ ማጫ አሳቱ ግብጼ ማጫዋንቱ ማላ ግድክኖ፤ ኡንቱንቱ ምና ግድያ ድራዉ፥ ማርስያዋንቱ ጋካናፐ ካሰቲደ የል ድጊኖ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ሄዋ ድራዉ፥ ጾሳይ ማርስያዋንቶ ኬኬዳ። አሳ ፓይዱካ ጉጅ ጉጅ ቢደ፥ ካሰዋፐ ያ ጮራቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ቃይ ማርስያዋንቱ ጾሳዉ ያዬዳ ድራዉ፥ ጾሳይ ኡንቱንቶ ሎኦባ ኦꬄዳ። እቶ እቶካ ሶ አሳ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ሄዋፐ ጉይያን ካቲ ባረ አሳ ኡባ፥ “እብራዋቱዋፐ የለትያ አቱማ ናና ኡባ ናይለ ሻፋ ሃꬃን ኦልተ፤ ሽን ማጫ ናናይ የለቶፐ፥ ሸምፑዋና አግ ባሽተ” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ሄ ዎደ እት ሌዊያ ቆሞ ግዴዳ ብታኒ ሌዋዌ ማጫውኖ አኬዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","እዛ ሻሃራደ አቱማ ናኣ የላዱ። ናአይ ማላ ሎኦ ናኣ ግድያዋ እዛ በኣደ፥ ሄዙ አግና ቆሳዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ሽን እዛ ሄዋፐ ዳሩዋ ቆሳናዉ ዳንዳየናዋ ኤራደ፥ ጫርያፐ ቁንኣ አዉ ዳዳዱ፤ ያታደ ሃꬃይ ገለና ማላ ሽድያን ማራጋደ፥ ናኣ አ ግዶን ዎꬃዱ፤ ናይለ ሻፋ ጌተትያ ሃꬃ ዶናን ጫርያ ግዶን ዎꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","አ ምቻታ እ ሀንያባ በአናዉ ሃኩዋን ኤቃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ግብጼ ካትያ ናታ ቦላ ሜጨታናዉ ናይለ ግያ ሻፋ ዎꬋዱ፤ እዝ ማጫ ቆማቱ ሃꬃ ዶናን ያነ ሃነ ሀመቲኖ፤ እዛ ቁንኣ ጫርያ ግዶን በኣደ፥ ባደ አካ ያና ማላ ባረ ቆማቶ ኪታዱ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ቁንኣ ፖካደ፥ በእተ ሀዋን ቄር ናአይ ዬክ ደኤ፤ እዛ አዉ ቃረታደ፤ “ሀዌ እብራዌቱ ቄር ናናቱዋፐ እቱዋ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ሄ ዎደ አ ምቻታ ካትያ ናቶ፥ “ነዉ ሀ ናኣ ꬋንꬃናዉ እብራዌ ማጫ አሳፐ እትኖ ጼሳናዉ ቦ?” ያጋደ ኦቻዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","እዛ፥ “ኤ፥ ባ” ያጋዱ። ናታ ባደ፥ ሄ ናኣ ዳዮ አሃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ካትያ ናታ ሄ ምሽራቶ፥ “ሀ ናኣ አፋደ፥ ታዉ ꬋንꬃሻ፤ ታን ነዉ ድርጉዋ ጭጋና” ያጋዱ። ምሽራታ ናኣ አፋደ፥ ꬋንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ናአይ ድጭና፥ ካትያ ናትኮ አ አሃዱ፤ እ እዝዉ ናኣ ግዴዳ፤ “ታን ሃꬃፐ አ ከሳድ” ጋደ፥ ሙሳ ጋ ሱንꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ሙሴ ድጭ ዎጋ ግዲደ፥ እት ጋላስ ባረ አሳይ ደእያ ሳኣ ቢደ፤ ኡንቱንቱ ዴጾ ኪታ ኪተትሽን ጼሌዳ። ግብጼ ቢታ አሳ እቱ፥ እሻቱዋ ግዴዳ እብራዋቱዋፐ እቱዋ ዋꬍሽን በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","እ ያ ሃ ጼልና፥ ኦንነ ባይናዋ በኢደ፥ ሄ ግብጼ ብታንያ፤ ዎꬊደ ሻፍያ ግዶን ቆሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ዎንተꬃ ጋላስ ከሲደ፥ በእተ! ሀቼ ቃይ ላኡ እብራዌቱ ዋቲኖ። ናቄዳዋ እ፥ “ኔን ነ እሻ ግዴዳ እብራውያ አያዉ ደቻይ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ሄ ብታኒ፥ “ኔና ኑ ቦላ ሞድያዋነ ዳና ኦꬅ ሱንꬄዳዌ ኦኔ? ኔን ሄ ግብጼ ብታንያ ዎꬌዳዋዳን፥ ታናካ ዎꬋናዉ ቆፓይ?” ያጌዳ። ሙሴ ሄ ዎደ፥ “ታን ኦꬄዳባይ ኤረት ድጌዳ” ያግ ቆፒደ ያዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ካቲካ ሀዋ ስሴዳ ዎደ፥ ሙሳ ዎꬋናዉ ኮዬዳ፤ ሽን ሙሴ ካትያፐ ባቃቲደ፥ ሚድያማ ጋድያን ደአናዉ ቢደ ሃꬃ ኦላ ዶናን ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ሄ ዎደ ሚድያማ ቄሳቱዋፐ እቶ ላፑን ማጫ ናናይ ደኢኖ፤ ኡንቱንቱ ባረንቱ አዉዋ ዶርሳቱዋ ሃꬃ ኡሻናዉ ዎንግርያን ሃꬃ ዱቂ ኩንꬃናዉ ዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ሄንꬃንቻቱ ዪደ ማጫ ናና የደርሴድኖ፤ ሽን ሙሴ ደንድ ኤቂደ፥ ኡንቱንታ አሼዳነ ኡንቱንቱ ዶርሳቱዋ ሃꬃ ኡሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ኡንቱንቱ ባረንቱ አዉዋ ዮቶረኮ ዬዳ ዎደ፥ “ሀቼ ዋን ኤለካ ዬድቴ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ኡንቱንቱ ዛሪደ፥ “ግብጼ ጋደ አሳ እቱ ኑና ሄንꬃንቻቱዋፐ አሼዳ፤ እ ኑዉ ሃꬃካ ዱቂደ ዶርሳ ዉድያ ኡሼዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","እ ባረ ማጫ ናና፥ “ያትና እ ሀቃን ደኢ? ህንተንቱ ሄ ብታንያ አያዉ አግ ባሼድቴ? አነ አ ጼሲደ፥ ምያባ ሾቢተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ሙሴ ሄ ብታንያና ያን ደአናዉ ማየቴዳ፤ ብታኒካ ባረ ናቶ ጽፓሮ ሙሴዉ ማቻቶ ኦꬂደ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ጽፓራ አቱማ ናኣ የልና፥ ሙሴ አ፥ “ታን አሳ ጋድያን በተ ግዳድ” ያጊደ፥ ገርሾማ ግ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ጮራ ላይꬃፐ ጉይያን፥ ግብጼ ካቲ ሀይቄዳ። እስራኤላቱ ባረንቱ አይለተꬃፐ ኡንኤቲደ ዋሴድኖ፤ ኡንቱንቱ ዋሴዳ ዋሱ ፑደ ጾሳኮ ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ጾሳይ ኡንቱንቱ ኡንኣ ዋሱዋ ስሲደ፥ እ አብራሃመና፥ ይሳቃናነ ያቆባና ጫቄዳ ጫቁዋ ሀሳዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ሄዋ ድራዉ፥ ጾሳይ እስራኤላቱዋ ጼሊደ ኡንቱንቱ ድራዉ ቆፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","እት ዎደ ሙሴ ሚድያማ ጋደ ቄስያ፥ ባረ ቦሉዋ ዮቶራ ዶርሳቱዋ ሄሜ፤ እ ሄ ዉድያ ላግ አኪደ መላ ቢታ ጋጻ ጋካናዉ አፊደ ጾሳ ደርያ ሲና ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ሄ ሳኣን መꬍና ጎዳ ኪታንቻይ አጫን፥ ኤጽያ ታማ ላጩዋ ግዶን አዉ ቤቴዳ፤ አጫይ ታማን ጹገትንቶካ፥ ታማይ አጫ ሜናዋ ሙሴ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ሄዋ ድራዉ፥ ሙሴ፥ “ታን ያ ባደ፥ አጫይ አያዉ ታማን ሜተትቤነንቶ ሀ ኦራꬃባ አነ በአና” ያጊደ ቆፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","እ በአናዉ ያ ቤዳዋ መꬍና ጎዳይ በኢደ አጫ ግዶፐ ጾሳይ አ፥ “ሙሴ! ሙሴ!” ያጊደ ጼሴዳ። ሙሴ፥ “አቤ” ጊደ ኮዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ጾሳይ አ፥ “ሃ ሺቆፓ። ኔን ኤቄዳ ቢታይ ጌሻ ግድያ ድራዉ፥ ነ ገድያን ደእያ ጫማ ከሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ቃይካ ጾሳይ አ፥ “ታን ነ አዉዋ ጾሳ፥ አብራሃሞ ጾሳ፥ ይሳቃ ጾሳ፥ ያቆባ ጾሳ” ያጌዳ። ሙሴ ጾሳ ጼላናዉ ያዬዳ ድራዉ፥ ባረ ዴሙዋ ገንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","መꬍና ጎዳይ ቃይካ ሀዋዳን ያጌዳ፤ “ታን ግብጼ ጋድያን ታ አሳይ ቱጋትያ ቱጋ ጌሻ በኣደ፥ ኡንቱንቱ ባረንቱ ካፖቱዋፐ ዋስያ ዋሱዋ ስሳደ፥ ታን ኡንቱንቱ መቱዋ ኡባ ꬊሻድ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ሄዋ ድራዉ፥ ታን ኡንቱንታ ግብጼ ጋድያ አሳቱዋ ኩሽያፐ አሻናዉነ ሄ ጋድያፐ ኡንቱንታ ከሳደ፥ አኮነ ሎኦ ጋድያ አሀናዉ ዎꬋድ። ሄ ጋዲ ማꬃይነ ኤሳይ ጎግያ ቢታ፤ ሄ ጋድያን ካናነቱ፥ ሂተቱ፥ አሞራዋናቱ፥ ፓርዛዋናቱ፥ ሂዌቱነ ያቡሳዋናቱ ሀእ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ሀእ እስራኤለቱዋ ዋሱ ታኮ ጋኬዳ፤ ግብጼ ጋድያ አሳቱ ኡንቱንታ ናቂያ ናቁዋ ታን በኣድ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ሄዋ ድራዉ፥ ሀእ ባ፤ ታ አሳቱዋ፥ እስራኤላቱዋ ግብጼፐ ከሳና ማላ፥ ግብጼ ካትያኮ ታን ኔና ኪታይ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ሽን ሙሴ ጾሳ፥ “ካትያኮ ባናዉነ እስራኤላቱዋ ግብጼፐ ከሳናዉ ታን ኦኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ጾሳይ አ፥ “ታን ኔናና ግዳና፤ ቃይ ታን ኔና ኪቴዳዎ ማላይ ሀዋ: ኔን ሄ አሳ ግብጼፐ ከሴዳ ዎደ፥ ሀ ደርያ ቦላን ህንተንቱ ጾሳዉ ጎይናንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ሙሴ ጾሳ፥ “ግዶ ሽን፥ ታን እስራኤለቱዋኮ ባደ፥ ኡንቱንታ፥ ‘ህንተ አዎቱዋ ጾሳይ ታና ህንተንቱኮ ኪቴዳ’ ያግና፥ ኡንቱንቱ ታና፥ ‘አ ሱንꬃይ ኦኔ?’ ያጊደ ኦቾፐ፥ ሄ ዎደ ታን ኡንቱንቶ ዋጋ ኦዶ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ጾሳይ ሙሳ፥ “ታን ታና፤ ኔን እስራኤለቶ፥ ‘ታና ጌተትያዌ ህንተንቱኮ ታና ኪቴዳ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ጾሳይ ሙሳ ቃይ፥ “ኔን እስራኤላቶ፥ ‘መꬍና ጎዳይ ህንተንቱ አዎቱዋ ጾሳይ፥ አብራሃሞ ጾሳይ፥ ይሳቃ ጾሳይ፥ ያቆባ ጾሳይ፥ እ ታና ህንተንቱኮ ኪቴዳ’ ያጋ፤ ሀዌ የለታፐ የለታይ ጋካናዉ ታን ሀሳየትያ መꬍናዉ ታ ሱንꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“ስም፤ ባደ እስራኤልያ ጭማቱዋ ሺሻደ፥ ‘መꬍና ጎዳይ ህንተንቱ አዎቱዋ ጾሳይ፥ አብራሃሞ፥ ይሳቃነ ያቆባ ጾሳይ ታዉ ቆንጪደ፤ ታና፥ ታን ህንተንታ ጾሞሳድ፤ ግብጼን ህንተንቱ ቦላ ኦሰቴዳዋካ ታን በኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ታን ህንተንታ ግብጼ ጋድያ ቱጋፐ ከሳደ፥ ማꬃይነ ኤሳይ ጎግያ ካናነቱዋ፥ ሂተቱዋ፥ አሞራዋናቱዋ፥ ፓርዛዋናቱዋ፥ ሂዌቱዋነ ያቡሳዋናቱዋ ጋድያ አፋና ጋ ኡታድ።’ ");
INSERT INTO dwrENT_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“እስራኤልያ ጭማቱ ነ ቃላ ስሳናዋንታ፤ ሄዋፐ ጉይያን ኔንነ ሄ ጭማቱ ግብጼ ካትያኮ ቢደ አ፥ ‘መꬍና ጎዳይ፥ እብራዌቱዋ ጾሳይ፥ ኑናና ጋከቴዳ። ሀእ ኑን ሄዙ ጋላሳ ኦግያ መላ ቢታ ሀመት ቢደ፥ መꬍና ጎዳ፥ ኑ ጾሳዉ፥ ያርሹዋ ያርሻና ማላ ኑና የዳ’ ያግተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ሽን ዎልቃማ ኩሺ፥ አ፥ ዎልቃን የድሳና ꬋዮፐ፥ ግብጼ ካቲ ህንተንታ የደናዋ ታን ኤራይ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ሄዋ ድራዉ፥ ታን ታ ኩሽያ የዳደ፥ ኡንቱንቱ ግዶን ታን ኦꬅያ ታ ማላታቱዋ ኡባን ግብጼቱዋ ሾጫና። ሄዋፐ ጉይያን እ ህንተንታ የዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“ቃይ ታን ግብጼቱዋን ሀ አሳ ሳቢሳና፤ ያቶፐ ህንተንቱ ከስያ ዎደ ኩሸ መላ ከስክታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","እብራዌ ማጫውና ኡባታ ባረ ግብጼ ሾራትኮነ ባረ ሶን ደእያ ግብጼ ማጫ አሳ ኦናነ ግዶፐ ኢኮ ቢደ፥ ብራ ሚሻቱዋ፥ ዎርቃ ሚሻቱዋነ አቱማ ናናይነ ማጫ ናናይ ማያና ማዮቱዋ ‘እምተ’ ጊደ ኦቻናዋንታ። ሄዋዳን ኦꬂደ ህንተንቱ ግብጼቱዋ ማጹዋ ቦንቃንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ሙሴ ዛሪደ፥ “ኡንቱንቱ ታና አማነናን እጾፐ፥ ዎይ ታን ኦድያዋ ስሰናን እጺደ፥ ‘መꬍና ጎዳይ ነዉ ቆንጭቤና’ ጎፐ ዋኖ?” ያግ ዛሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","መꬍና ጎዳይ አ፥ “ሄ ነ ኩሽያን ደእያዌ አዬ?” ያጊደ ኦቼዳ። እካ “ጻምኣ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","መꬍና ጎዳይ አ፥ “አነ ሄ ጻምኣ ሳኣን ኦላ” ያጌዳ። ሙሴ ሄ ጻምኣ ሳኣን ኦሌዳ ዎደ ሾሻ ግዴዳ፤ ያትና፥ ሙሴ አፐ ዎጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ሄዋፐ ጉይያን መꬍና ጎዳይ አ፥ “ነ ኩሽያ የዳደ፥ አ ዱፍያ ኦይቃ” ያጌዳ። ሙሴ የዲደ ሾሻ ኦይቂና፥ ሾሻይ አ ኩሽያን ስሚደ፥ ጻምአዉ ላመቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","መꬍና ጎዳይ፥ “ሀዌ ሀኔዳዌ፥ መꬍና ጎዳይ ነ አዎቱዋ ጾሳይ፥ አብራሃማ ጾሳይ፥ ይሳቃ ጾሳይነ ያቆባ ጾሳይ ነዉ ቆንጬዳዋ ኡንቱንቱ አማናናዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ሄዋፐ ጉይያን መꬍና ጎዳይ አ፥ “ነ ኩሽያ ነ ሾጵያን የዳ” ያግና፥ ሙሴ ባረ ኩሽያ ሾጵያን የዴዳ፤ እ ከስ ጼሊደ፥ “ታ ኩሺ ኦሎቲደ ሻቻዳን ቦጼዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ጾሳይ አ፥ “ነ ኩሽያ ነ ሾጵያን ዛራደ የዳ” ያጌዳ። ሙሴ ባረ ኩሽያ ባረ ሾጵያን ዛር የዲደ ከስያ ዎደ፥ “ታ ኩሺ ስሚደ ህንኮ ቦላ ማላ ግዴዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ቃይካ መꬍና ጎዳይ አ፥ “ኡንቱንቱ ኔና አማነናን ꬋዮፐነ ኮይሮ ማላታ አማነናን እጾፐ፥ ላኤንꬆ ማላታ ኡንቱንቱ አማናናዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ሽን ኡንቱንቱ ሀ ላኡ ማላታቱዋ አማነናን ꬋዮፐ፥ ዎይ ኔን ኦድያዋ ስሰናን እጾፐ፥ ናይለ ሻፋፐ ሃꬃ አካደ፥ መላ ቢታን ጉሳ፤ ኔን ሻፋፐ አኬዳ ሃꬃይ ቢታን ሱꬃ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ሙሴ መꬍና ጎዳ፥ “አቤት መꬍና ጎዳዉ፥ ታን ሀዋፐ ካሰካ፥ ዎይ ኔን ነ ቆማዉ ሃሳዮደፐ ዶምና ታን ሃሳያናዉ ዳንዳይከ፤ ታን ዴዶታደ ሃሳያይ፤ ቃይ ታ እንጻርሳይካ ሉፋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","መꬍና ጎዳይ አ፥ “አሳዉ ዶና መꬌዳዌ ኦኔ? አ ዱደ፥ ዎይ ቱለ ኦꬅያዌ ኦኔ? ጼልያዋነ ቆቃ ኦꬅያዌ ኦኔ? ታና መꬍና ጎዳ ግድክታየ? ");
INSERT INTO dwrENT_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ኔን ሀእ ባ፤ ታን ኔና ሃሳያናዳን ማዳና፤ ኔን ጋናባ ታን ኔና ታማርሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ሽን ሙሴ፥ “አቤት ጎዳዉ፥ ሀያና፥ ሀዋ ኦꬃናዉ ሀራ አሳ ኪታርኪ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሴዉ ሎይꬅ ሀንቀቲደ አ፥ “ሌዊያ ግዴዳ ነ እሻ አሮኔ? እ ሎኦ ሃሳያና ዳንዳይያዋ ታን ኤራይ፤ ሀእ እ ኔናና ጋከታናዉ ዪደ ኦግያ ቦላን ደኤ፤ እ ኔና በእያ ዎደ አ ዎዛናይ ናሸታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ኔን፥ ‘ያጋ፤ ያጋ’ ጋደ አዉ ኦዳና፤ ታን ህንተንታ ላኡዋካ ሃሳያናዉ ማዳናነ ህንተንቱ ኦꬃናባ ታማርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","እ አሳዉ ነ ድራ ሃሳያናዋ፤ ሄዌካ፥ እ ነዉ ዶና ማላ ግዳናዋ፥ ኔን አዉ ጾሳ ማላ ግዳናሳ ግያዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ሽን ማላታቱዋ አን ኦꬃናዉ፥ ኔን ሀ ጻምኣ አካደ ባ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ሄዋፐ ጉይያን ሙሴ ባረ ቦሉዋ ዮቶረኮ ስም ቢደ፥ “ሀኖ ጋካናዉ ሸምፑዋና ደእያ አሳይ ደኦፐ በአናዉ፥ ታን ጉየ ታ አሳኮ ግብጼ ቦ?” ያጌዳ። ዮቶረ ሙሳ፥ “ኤ ባ፤ ሳሮ ጋካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ሙሴ ሚድያማ ጋድያን ደእሽን መꬍና ጎዳይ አ፥ “ኔና ዎꬋናዉ ኮዬዳ አሳቱ ኡባይ ሀይቂ ድጌዳ ድራዉ፥ ጉየ ግብጼ ጋድያ ስማደ ባ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ሙሴ ባረ ማቻቶነ ባረ አቱማ ናና ሀርያ ቶግስ አኪደ፥ ጉየ ግብጼ ስሙሳ ዶሜዳ፤ ሙሴ ጾሳ ጻምኣ ባረ ኩሽያን ኦይቂደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","መꬍና ጎዳይ ሙሳ፥ “ኔን ግብጼ ስማደ ብያ ዎደ፥ ታን ነዉ እሜዳ ዎልቃን ኔን ኦꬃና ማላታቱዋ ኡባ ግብጼ ካትያ ስንꬃን ኔን ኦꬃናዋ ባሎፓ። ያትናካ አሳ እ የደና ማላ፥ ታን አ ዎዛና ዶንጭልሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ሄ ዎደ ታን መꬍና ጎዳይ፥ ግያዋ ካትያዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ “እስራኤሊ ታ ባይራ ናኣ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","እ ታዉ ጎይናና ማላ፥ ታ ናኣ ኔን የዳና ማላ፥ ታን ነዉ ኦዳድ፤ ሽን ኔን አ የደናን እጻዳ፤ ሄዋ ድራዉ፥ ታን ነ ባይራ አቱማ ናኣ ዎꬋና” ያጌ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ኦግያን ሸምፕያሳን መꬍና ጎዳይ ሙሴና ጋከቴዳ፤ አ ዎꬋና ሀኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","አ ማቻታ ጽፓራ ሳልያ አካደ፥ ባረ ናኣ ቃጻራዱ። ሄ ሾኩዋን ሙሴ ገድያ ቦቻዱ። እዛ ሙሳ፥ “ኔን ታዉ ቱሙ ሱꬃ ምሽራ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","መꬍና ጎዳይ ሄዋ ድራዉ አ ዎናን አጌዳ። ሄ ዎደ ቃጻራ ማላታናዉ አ፥ “ኔን ታዉ ሱꬃ ምሽራ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","መꬍና ጎዳይ አሮና፥ “ኔን ሙሴና ጋከታናዉ መላ ቢታ ባ” ያጌዳ። እ ቢደ፥ ሙሴና ጾሳ ደርያን ጋከቲደ አ የሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ሄዋፐ ጉይያን ሙሴ መꬍና ጎዳይ ባረ ቦላ ኪቴዳ ቃላ ኡባነ ኦꬃና ማላ፥ ባረና አዛዜዳ ኦራꬃ ማላታቱዋ ኡባ አሮናዉ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ሙሴነ አሮነ ቢደ፥ እስራኤለቱዋ ጭማቱዋ ኡባ ሺሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","አሮነ መꬍና ጎዳይ ሙሴዉ ኦዴዳ ቃላ ኡባ ኡንቱንቶ ኦዴዳ። ማላታቱዋካ ሄ አሳ ስንꬃን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ኡንቱንቱካ አማኔድኖ። መꬍና ጎዳይ ኡንቱንቶ ቆፔዳዋነ ኡንቱንቱ ቱጋ በኤዳዋ ስሴዳ ዎደ፥ ኡንቱንቱ ጉፋኒደ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ሄዋፐ ጉይያን ሙሴነ አሮነ ግብጼ ካትያኮ ዪደ አ፥ “መꬍና ጎዳይ፥ እስራኤልያ ጾሳይ ሀዋዳን ያጌ፤ ‘ታ አሳይ ታዉ መላ ቢታን ባላ ቦንቻና ማላ፥ ኡንቱንታ የዳ’ ያጌ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ካቲ፥ “ታን አዉ አዛዘታደ እስራኤልያ የዳናዉ ሄ መꬍና ጎዳይ ኦኔ? ታን መꬍና ጎዳ ኤርከ፤ እስራኤልያካ የድከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ሄዋፐ ጉይያን ኡንቱንቱ፥ “እብራዌቱዋ ጾሳይ ኑናና ጋከቴዳ። ሀእ ኑን መꬍና ጎዳ፥ ኑ ጾሳዉ፥ ያርሹዋ ያርሻናዉ ሄዙ ጋላሳ ኦግያ መላ ቢታ ግዶ ባናዉ ኑና የዳርኪ፤ ሄዌ ꬋዮፐ፥ እ ኑና ኢታ ሀርግያን ዎይ ኦላን ዎꬋናዋ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ሽን ግብጼ ካቲ ያጌዳ፤ “ሙሴ! አሮና! አሳ አያዉ ኪታ ድጊቴ? ህንተንቱ ኪታዉ ስሚደ ቢተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ካቲ ሄ ዎደ፥ “በእተ፥ ሀ ጋድያን አሳይ ጮራቴዳ፤ ቃይ ህንተንቱ ኡንቱንታ ኪታ ድጊታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ካቲ ሄ ጋላስ ግብጼቱዋ ካፖቱዋነ እስራኤለቱዋ ዳጉዋ ሱንꬃቱዋ አዛዚደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ሀሮደዋዳን ጹብያ መꬍያ ኡቱላ አሳዉ እሞፕተ፤ ኡንቱንቱ ኡቱላ ባረንቶ ቢደ ሺሽኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ሽን ኡንቱንቱ ፓይዱዋን ካሰዋ ኬሻ ጹብያ መꬊደ፥ ሼꬋናዳን አዛዝተ፤ ሄ ፓይዱዋፐ ፓጭሶፕተ፤ አያዉ ጎፐ፥ ኡንቱንቱ አዛላ፤ ኡንቱንቱ፥ ‘ኑን ኑ ጾሳዉ ያርሹዋ ያርሻና ማላ፥ ኑና የዳርኪ’ ያጊደ ዋስያዌ ሀዋሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ኡንቱንቱ ኪታን ሼካና ማላነ ዎርዱዋ ሃሳያ ስሰናን አጋና ማላ፥ ኡንቱንቶ ኦሱዋ ዴጽስተ” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ሄዋፐ ጉይያን፥ ሄ ካፖቱነ ሄ ሱንꬃቱ ከሲደ አሳ፥ “ካቲ ሀዋዳን ያጌ፤ ‘ስም ታን ህንተንቶ ኡባካ ኡቱላ እምከ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ህንተንቱ ኡቱላ ደማና ዳንዳይያሳፐ ህንተንቱ ሁጲያዉ ሺሽተ፤ ሽን ህንተንቱ ሼꬍያ ጹብያ ፓይዱ ኡባካ ፓጨና’ ያጌዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","አሳይ ኡቱላዉ ሀንያዋ ሺሻናዉ ግብጼ ቢታ ኡባን ላለቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ግብጼቱዋ ካፖቱ ኡንቱንታ፥ “ህንተንቶ ኡቱላ እምያ ዎደ ህንተንቱ ሀቼ ሀቼ ኦꬅያዋ ኬሻ ኦꬅተ” ያጊደ ኡንቱንታ ጎደቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ግብጼቱዋ ካፖቱ እስራኤለቱዋ ዳጉዋ ሱንꬃቱዋ ዋꬊደ፥ “ህንተንቱ ካሰ ኦꬅያዋ ኬሻ ጹብያ ዝኖ ዎይ ሀቼ አያዉ ኦꬅ ዉርስበይክቴ?” ያጊደ ኦቼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ሄዋፐ ጉይያን እስራኤልያ ሱንꬃቱ ቢደ ካትያዉ ማጋኔድኖ፤ ኡንቱንቱ ባረንቱ መቱዋፐ ደንዶዋን አ፥ “ኔን ነ ቆማቱዋ ሀዋዳን አያዉ ኦꬃይ? ");
INSERT INTO dwrENT_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ነ ቆማቶ ኡቱላ እምክኖ፤ ሽን፥ ‘ጹብያ መꬍተ’ ያጊኖ፤ ኑና ነ ቆማቱዋ ዋꬊኖ፤ ሽን ባላይ ነ አሳ ቦላና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ሽን ካቲ ኡንቱንታ፥ “ሀ አዛላቱ! ህንተንቱ አዛላ! ሄዋ ድራዉ፥ ህንተንቱ ዛር ዛሪደ፥ ‘ኑን መꬍና ጎዳዉ ያርሻና ባናዉ ኑና የዳርኪ’ ያጊታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ሀእ ቢተ፤ ኦꬅተ፤ ኡንቱንቱ ህንተንቶ አይ ኡቱላካ እምክኖ፤ ሽን ህንተንቱ ካሰዋ ኬሻ ጹብያ መꬊታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","እስራኤላቱዋ ሱንꬃቱ፥ “ህንተንቱ ሀቼ ሀቼ መꬍያ ጹብያ ፓይዱዋ ካሰዋፐ ፓጭሶፕተ” ጌዳ ዎደ፥ ኡንቱንቱ መቱዋን ገሌዳዋ አኬኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ኡንቱንቱ ካትያ ማታፐ ከሲደ፥ ሙሴነ አሮነ ኡንቱንቱና ጋከታናዉ ናግያዋንታ ደሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ኡንቱንቱ፥ “ህንተና መꬍና ጎዳይ ጼሎ! ህንተንቱ ቦላ እ ፕርዶ! ህንተንቱ ኑና ካትያናነ አ ኦሳንቻቱዋን እጽሴድታ፤ ቃይ ኡንቱንቱ ኑና ዎꬋና ማላ፥ ማሻ ኡንቱንቱ ኩሽያን ዎꬄድታ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ሙሴ መꬍና ጎዳኮ ስሚደ፥ “አቤት ጎዳዉ፥ ኔን ሀ አሳ ቦላ መቱዋ አያዉ አሃዲ? ኔን ታና ኪቴዳዌ ሀዋሴ? ");
INSERT INTO dwrENT_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ታን ነ ሱንꬃን ካትያዉ ሃሳያናዉ ቤዳ ዎደፐ ዶምና፥ እ ሀ አሳ ቦላ መቱዋ አሄዳ። ቃይ ኔንካ ነ አሳ ሙለ አሻባካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ “ታን ግብጼ ካትያ ኦꬃናባ ኔን ሀእ በአና፤ ታ ዎልቃማ ኩሽያ ጋሱዋን እ ኡንቱንታ የዳናዋ፤ ታ ዎልቃማ ኩሽያ ጋሱዋን እ ኡንቱንታ ባረ ጋድያፐ ላጊደ ከሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ጾሳይ ቃይካ ሙሳ፥ “ታን መꬍና ጎዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ታን አብራሃመዉ፥ ይሳቃዉነ ያቆባዉ ኡባ ዳንዳይያ ጾሳ ግዳደ ቆንጫድ፤ ሽን ታን፥ መꬍና ጎዳ ግያ ታ ሱንꬃን፥ ታናተꬃ ኡንቱንታ ኤርሳበይከ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ቃይ ታን ኡንቱንቶ ኡንቱንቱ በተ ግዲደ ደኤዳ ካናነ ጋድያ እማናዉ ታ ቃላ ጫቁዋ ኡንቱንቱና ጫቀታድ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ቃይካ ግብጼ አሳቱ አይለይያ እስራኤለቱዋ ኦልያ ታን ስሳደ፥ ታ ቃላ ጫቁዋ ሀሳያድ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“ሄዋ ድራዉ፥ ኔን እስራኤላቱዋ፥ ‘ታን መꬍና ጎዳ፤ ታን ህንተንታ ግብጼቱዋ ናቁዋፐ ከሳና፤ ታን ህንተንታ ኡንቱንቱ አይለተꬃፐካ ላአ ከሳና፤ ቃይ ታን ታ ዎልቃማ ዎልቃን ግብጼቱዋ ቦላ ኢታ ፕርዳ አሃደ ህንተንታ ዎዛና። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ታን ህንተንታ ታ ሁጰ አሳዳን አካናነ ታን ህንተንቱ ጾሳ ግዳና። ሄ ዎደ ህንተንቱ ታን መꬍና ጎዳ ህንተንቱ ጾሳ ህንተንታ ግብጼቱዋ አይለተꬃፐ ከሴዳዋ ግድያዋ ኤራና። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ቃይ ታን አብራሃመዉ፥ ይሳቃዉነ ያቆባዉ እማናዉ ጫቄዳ ቢታዉ አሀና፤ ሄ ጋድያ ታን ህንተንቶ ጋደ ኦꬃደ እማና፤ ታን መꬍና ጎዳ ያጋ’ ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ሙሴ ሀዋ እስራኤለቶ ኦዴዳ፤ ሽን ኡንቱንቱ አያናይ መኤዳ ጋሱዋንነ መቀꬅ ባይና አይለተꬃ ጋሱዋን አ ቃላ ስስበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ባደ ግብጼ ካትያ፥ ‘እስራኤለቱዋ ነ ጋድያፐ ከሳደ የዳ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ሽን ሙሴ መꬍና ጎዳ፥ “ሀራይ አቶ እስራኤለቱ ታባ ስሰናን እጼድኖ ሽን ታን ዴዶትያ እንጻርሳን ሃሳይያዋ ካቲ ዎት ስሳኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","መꬍና ጎዳይ ሙሳነ አሮና፥ “ቢደ፥ ህንተንቱ እስራኤልያ አሳ ግብጼፐ ከሳና ማላ፥ ታን ህንተንታ የዴዳዋ እስራኤልያ አሳዉነ ግብጼ ካትያዉ ኦድተ” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ኡንቱንቱ ሶይ ሶይ ማይዛ አዎቱ ሀዋንታ። እስራኤልያዉ ባይራ ናኣ ሮቤላ አቱማ ናናይ፥ ሄኖካ፥ ፓሉ፥ ሄጽሮናነ ካርማ፤ ሀዋንቱ ሮቤላ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ስሞና አቱማ ናናይ፥ ይሙኤላ፥ ያሚና፥ ኦሃዳ፥ ያኪና፥ ጾሃራነ ካናነ ጋደ ምሽራትፐ የለቴዳ ሻኡላ፤ ሀዋንቱ ስሞና ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ሌዊያ አቱማ ናናይ ባረንቱ የለታ ማራዳን ገርሾና፥ ቃሃታነ ማራራ። ሌዊ ጼታነ ሀታማነ ላፑን ላይꬃ ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ገርሾና አቱማ ናናይ ባረንቱ ያራን ያራን ሊብናነ ሽምአ ጌተቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ቃሃተ አቱማ ናናይ አምራማ፥ ይጽሃራ፥ ከብሮናነ ኡዝኤላ። ቃሃተ ጼታነ ሀታማነ ሄዙ ላይꬃ ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ማራራ አቱማ ናናይ ማህላነ ሙሻ ግያዋንታ። ባረንቱ የለታ ማራን ሀዋፐ ቆሞና ጼገቴዳ ሌዊያ ያራቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","አምራመ ባረ አዉዋ ምቻቶ ዮከቤዶ አኬዳ። እዛ አሮናነ ሙሳ አዉ የላዱ። አምራመ ጼታነ ሀታማነ ላፑን ላይꬃ ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ይጽሃራ አቱማ ናናይ፥ ቆራሀ፥ ነፌጋነ ዚክራ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ኡዝኤላ አቱማ ናናይ፥ ምሻኤላ፥ ኤልጻፋናነ ሲትራ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","አሮነ አምናዳባ ናቶ፥ ናኣሶና ምቻቶ ኤልሼቦ አኬዳ። ያትና እዛ አዉ ናዳባ፥ አቢሀ፥ ኤልኣዛራነ እታማራ ጌተትያ አቱማ ናና የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ቆረ አቱማ ናናይ፥ አሲራ፥ ኤልቃናነ አብያሳፋ፤ ሀዋንቱ ቆረ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","አሮና ናአይ ኤልኣዛረ ፑትኤላ ናናቱዋፐ እትኖ አኬዳ፤ እዛ አዉ ፒንሃሳ የላዱ። ሀዋንቱ ባረንቱ ያራን ያራን ሌዋቱዋ ጎልያ ማይዛ አሳቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","መꬍና ጎዳይ፥ “ግብጼ ጋድያፐ እስራኤላቱዋ ኦላዉ ጊጎ ጩጉዋዳን ጩጉዋዳን ከስተ” ያጌዳዌ ሀ ሙሳነ አሮና። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","እስራኤላቱዋ ግብጼ ጋድያፐ ከስያዋ ግብጼ ካትያዉ ሃሳዬዳዋንቱ ኡንቱንታ። ሄዋንቱካ ሙሳነ አሮና። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","መꬍና ጎዳይ ግብጼን ሙሴዉ ሃሳዬዳ ዎደ አ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“ታን መꬍና ጎዳ፤ ታን ነዉ ኦድያዋ ኡባ ኔን ግብጼ ካትያዉ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ሽን ሙሴ መꬍና ጎዳ፥ “ታን ዴዶትያ እንጻርሳን ሃሳይያዋ ግድሽን፥ ካቲ ታን ኦድያዋ ዎት ስሳኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ “በአ፤ ታን ኔና ግብጼ ካትያዉ ጾሳ ማላ ኦꬃድ፤ ነ እሻይ አሮነ ነ ናብያዳን ግዳናዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ታን ኔና አዛዜዳ ኡባ ኔን አዉ ኦዳሳ፤ ነ እሻ አሮነ እስራኤላቱዋ ባረ ጋድያፐ ከስ የዳና ማላ፥ ካትያዉ ኦዴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ሽን ታን ካትያ ዎዛና ꬉልሳና፤ ታን ግብጼ ጋድያን ታ ጮራ ማላታነ ማላልስያባ ዳርሳደ ኦꬅንቶካ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","እ ህንተንቱ ኦድያዋ ስሰና። ሄ ዎደ ታን ታ ኩሽያ ግብጼቱዋ ቦላ ደንꬃና፤ ታን ታ ጩጉዋ፥ ታ አሳ እስራኤልያ፥ ግብጼ አሳ ቦላን ዎልቃማ ፕርዳ አሃደ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ሄዋፐ ጉይያን ግብጼቱ፥ ታን ታ ኩሽያ ግብጼ ቦላ ደንꬃደ፥ እስራኤላቱዋ ኡንቱንቱ ግዶፐ ከሴዳ ዎደ፥ ታን መꬍና ጎዳ ግድያዋ ኡንቱንቱ ኤራናዋንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ሙሴነ አሮነ ልከ መꬍና ጎዳይ ኡንቱንታ አዛዜዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ኡንቱንቱ ካትያዉ ኦድያ ዎደ፥ ሙሴ ሆስፑን ታሙ ላይꬃ አሳ፤ አሮነ ቃይ ሆስፑን ታማነ ሄዙ ላይꬃ አሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ካቲ ህንተንታ፥ ‘ጾሳይ ኦꬅያ ማላታ ታና በስተ’ ግያ ዎደ፥ ኔን አሮና፥ ‘ነ ጻምኣ አካደ፥ ካትያ ስንꬃን ኦላ’ ያጋ፤ ያቶፐ እ ሾሻ ከሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ሙሴነ አሮነ ካትያኮ ገሊደ መꬍና ጎዳይ ኡንቱንታ አዛዜዳዋዳን ኦꬄድኖ፤ አሮነ ባረ ጻምኣ ካትያ ስንꬃንነ አ ኦሳንቻቱዋ ስንꬃን ኦልና ሾሻ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ሄዋፐ ጉይያን ካቲ ኤራንቻቱዋነ ብትያዋንታ ጼስስና ኡንቱንቱካ፥ ሀ ግብጼቱዋ ሻሬቾቱ ባረንቱ ꬋማሹዋን ሄዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ኡንቱንቱ ኡባይካ ባረንቱ ጻምኣ ጻምኣ ኦልና፥ ጻምአቱ ሾሻ ከሴድኖ፤ ሽን አሮና ጻምአይ ኡንቱንቱ ጻምአቱዋ ምቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ግዶፐነ መꬍና ጎዳይ ኦዴዳዋዳንካ ካትያ ዎዛናይ ዶንጭሌዳ፤ እ ኡንቱንቱ ኦዱዋ ስሰናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","መꬍና ጎዳይ ሙሳ፥ “ካትያ ዎዛናይ ዶንጭሌዳ፤ አሳ እ የደናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ካቲ ሃꬃኮ ብያ ዎደ፥ ጉራደ ኔን አኮ ባደ አናና ጋከታናዉ ናይለ ሻፋ ዶናን ኤአ፤ ሾሻዉ ላመቴዳ ጻምኣ ኦይቃ አካደ ባ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ኔን አ፥ ‘መꬍና ጎዳይ፥ እብራዌቱዋ ጾሳይ ኔና፥ መላ ቢታን ታዉ ጎይናና ማላ፥ ታ አሳ የዳ ያጊደ፥ ታና ኔኮ ኪቴዳ፤ ሽን ሀኖ ጋካናዉ ኔን ስሳበይካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","መꬍና ጎዳይ፥ ታን መꬍና ጎዳ ግድያዋ ኔን ሀዋን ኤራና። ታን ናይለ ሻፋ ሃꬃ ታ ኩሽያን ደእያ ጻምአን ሾጭና ሃꬃይ ሱꬃዉ ላመታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ናይለ ሻፋ ሞሊካ ሀይቃናዋ፤ ሻፋይካ ጽንቃናዋ፤ ግብጼቱ ሄ ሻፋ ሃꬃ ኡሻናዉ ዳንዳይክኖ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ “ኔን አሮና፥ ‘ነ ጻምኣ ኦይቃደ ግብጼ ሃꬃቱዋ ቦላ፥ ሻፋቱዋ ቦላ፥ ዜሬቶ ሃꬃቱዋ ቦላ፥ ድኡዋ ኦላ ቦላን ነ ኩሽያ ምጫ’ ያጋ፤ እ ምጭና ኡንቱንቱ ሱꬃዉ ላመታናዋ፤ ግብጼ ቢታ ኡባን፥ ሀራይ አትና፥ ምꬃፐነ ሹቻፐ ዎጪደ ከሴዳ ሃꬃ ትግያ ሚሻ ኡባ ጋርሳን ደእያ ሃꬃይ ሱꬃዉ ላመታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ሙሴነ አሮነ መꬍና ጎዳይ አዛዜዳዋዳን ኦꬄድኖ። ካትያ ስንꬃንነ አ ኦሳንቻቱዋ ስንꬃን እ ባረ ጻምኣ ደንꬂደ፥ ሻፋ ሃꬃ ሾጭና ሃꬃ ኡባይ ሱꬃዉ ላመቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ሄ ሻፋ ሃꬃ ግዱዋን ደእያ ሞለቱ ሀይቄድኖ፤ ሻፋ ሃꬃይ ሎይꬅ ዜኤዳ ድራዉ፥ ግብጼ አሳይ ኡሻናዉ ዳንዳይቤና። ግብጼን ኡባ ሳን ሱꬃይ ኩሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ግብጼ ሻሬቾቱካ ባረንቱ ꬋማሹዋን ሄዋዳን ኦꬄድኖ፤ መꬍና ጎዳይ ኦዴዳዋዳንካ ካትያ ዎዛናይ ዶንጭልና፥ ሙሴነ አሮነ ኦዴዳዋ ስሰናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ሄዋፐ ጉይያን ካቲ ሀዎ አይነ ህርገናን ባረ ሶ ስሚደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ግብጼ አሳይ ኡባይ ናይለ ሻፋ ሃꬃ ኡሻናዉ ዳንዳይቤና ድራዉ፥ ኡሽያ ሃꬃ ደማናዉ ናይለ ሻፋ ጋጻን ኦላ ቦኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","መꬍና ጎዳይ ሃꬃ ሾጮደፐ ላፑን ጋላሳ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ “ባ፤ ግብጼ ካትያኮ ባደ፥ ‘መꬍና ጎዳይ ሀዋዳን ያጌ፤ “ታዉ ጎይናና ማላ፥ ታ አሳ የዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ኔን ኡንቱንታ የደናን እጾፐ፥ ታን ነ ቢታ ኡባን ሸꬍያ ኩንꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ናይለ ሻፋን ሸꬊ ሾሀካታና። ኡንቱንቱ ሾሀካት ከሲደ ነ ሶ፥ ነ ስርጻ፥ ነ ግሱዋ ግዶ፥ ነ ኦሳንቻቱዋ ጎልያ ግዶ ገላና፤ ነ አሳ ቦላ ከሳና፤ ነ ጮጭያነ ነ ꬊልያ ዎꬅያ ከርያን ገላና። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ሸቱ ነ ቦላ፥ ነ አሳ ቦላነ ነ ኦሳንቻቱዋ ኡባ ቦላ ከሳና” ያጌ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ “ኔን አሮና፥ ‘ነ ጻምኣ ኦይቃደ፥ ሻፋቱዋ ቦላ፥ ዜሬቶ ሃꬃቱዋ ቦላነ ድኡዋ ኦላ ቦላ ነ ኩሽያ ምጫደ ሸቱ ግብጼ ጋድያ ቦላን ከሳናዳን ኦꬃ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","አሮነ ግብጼ ሃꬃቱዋ ቦላ ባረ ኩሽያ ምጭና ሸቱ ከሲደ፥ ግብጼ ጋድያ ማዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ሻሬቻቱካ ባረንቱ ꬋማሹዋን ሄዋዳን ኦꬄድኖ፤ ኡንቱንቱካ ግብጼ ጋድያን ሸꬊ ከሳናዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ካቲ ሙሳነ አሮና ጼስሲደ፥ “ሀ ሸቱዋ ታፐነ ታ አሳፐ ድጋና ማላ፥ መꬍና ጎዳ ህንተንቱ ዎስተ፤ ያቶፐ መꬍና ጎዳዉ ያርሹዋ ያርሻና ማላ፥ ታን አሳ የዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ሙሴ ካትያ፥ “ካትያዉ ሸቱ ኔፐነ ነ ሶፐ ꬋያና ማላነ ናይለ ሻፋ ጻላላን አታና ማላ፥ ታን ነዉ፥ ነ ኦሳንቻቶነ ነ አሳዉ ዎሳና ዎድያ ኔን ኬራ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ካቲ፥ “ዎንታ” ያጌዳ። ሙሴ፥ “መꬍና ጎዳ ኑ ጾሳ፥ ማላይ ኦንነ ባይናዋ ኔን ኤራና ማላ፥ ኔን ጌዳዋዳን ሀናናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ሄ ሸቱ ኔፐ፥ ነ ጎልያፐ፥ ነ ኦሳንቻቱዋፐነ ነ አሳፐ ꬋያናዋንታ፤ ኡንቱንቱካ ናይለ ሻፋ ጻላላን አታናዋንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ሙሴነ አሮነ ካትያ ማታፐ ከሴድኖ፤ ካትያ ቦላ መꬍና ጎዳይ አሄዳ ሸቱዋባ ሙሴ መꬍና ጎዳኮ ዎሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","መꬍና ጎዳይ ሙሴ ኦቼዳዋዳን ኦꬄዳ፤ ሸቱ ሶን ካረንነ ደምባን ሀይቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ግብጼ አሳይ ኡንቱንታ ሺሽ ሺሺደ ዶሬድኖ፤ ቢታይ ሄዋ ጽንቁዋን ዜኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ሽን ካቲ ሸቱ ባይናዋ በኤዳ ዎደ አ ዎዛናይ ዶንጭሌዳ፤ መꬍና ጎዳይ ኦዴዳዋዳንካ፥ እ ሙሴነ አሮነ ኦዴዳ ኦዱዋ ስሰናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","መꬍና ጎዳይ ሄዋፐ ጉይያን፥ ሙሳ “ኔን አሮና፥ ‘ነ ጻምኣ ምጫደ፥ ቢታ ባና ሾጫ’ ያጋደ ኦዳ። ግብጼ ቢታ ኡባን ባናይ ጩቻ ከሳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ኡንቱቱ ሄዋዳን ኦꬄድኖ፤ አሮነ ጻምኣ ኦይቂደ ባረ ኩሽያ ምጪደ፤ ባረ ጻምአን ቢታ ባና ሾጭና አሳነ፥ መህያ ቦላ ጩቻይ ዬዳ። ግብጼ ጋድያን ሀ ጋጻፐ ያ ጋጻ ጋካናዉ፥ ባና ኡባይ ጩቻ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ሻሬቻቱካ ባረንቱ ꬋማሹዋን ሄዋዳን ኦꬃናዉ ባጸቴድኖ፤ ሽን ዳንዳይበይክኖ። ጩቻይ አሳ ቦላነ፥ መህያ ቦላ ኩሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ሻሬቻቱ ካትያ፥ “ሀዌ ጾሳ ኦሱዋ” ያጌድኖ። ሽን ካትያ ዎዛናይ ዶንጭሌዳ፤ ጾሳይ ጌዳዋዳንካ፥ እ ኡንቱንቱ ኦድያዋ ስሰናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","መꬍና ጎዳይ ሙሳ፥ “ጉራን ደንዳደ፥ ካቲ ሻፋ ቢሽን አናና ጋከታደ ኔን አ፥ ‘መꬍና ጎዳይ ያጌ፤ “ታዉ ኦꬃና ማላ፥ ታ አሳ የዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ኔን ታ አሳ የደናን እጾፐ፥ ታን ነ ቦላ፥ ነ ኦሳንቻቱዋ ቦላ፥ ነ አሳ ቦላነ ነ ጎለቱዋ ግዶ ኡዱንጽያ ዉድያ የዳና፤ ግብጼቱዋ ጎለንነ ኡንቱንቱ ደእያ ቢታ ኡባን ኡዱንጺ ኩማናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ሽን ሄ ጋላስ ታ አሳይ በተ ግዲደ ደእያ ጎሸና ጋድያን ኡዱንጺ ኩመናዳን ታን ተኣደ፥ ኡንቱንቱ ቢታ ሻካና፤ ታን መꬍና ጎዳይ፥ ሀ ጋድያ ኡባን ደእያዋ ኔን ሄዋን ኤራና። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ታን ታ አሳነ ነ አሳ ሻካና፤ ሀ ዎልቃማ ማላታይ ዎንት ሀናና” ያጌ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","መꬍና ጎዳይ ሄዋፐ ጉይያን፥ ጌዳዋዳን ኦꬄዳ፤ ካትያ ሶንነ አ ኦሳንቻቱዋ ሶን ዳሮ ኡዱንጽያ ዉዲ ዬዳ፤ ግብጼ ጋድያ ኡባ ባይዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ሄ ዎደ ካቲ ሙሳነ አሮና ጼስሲደ፥ “ቢተ፤ ሀ ጋድያን ህንተንቱ ጾሳዉ ያርሽተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ሽን ሙሴ፥ “ሄዌ ልከ ግደና፤ ኑን መꬍና ጎዳ ኑ ጾሳዉ ሺሽያ ያርሾቱ ግብጼቱዋ ሸነይያዋ ግዳናዋ፤ ኑን ኡንቱንታ ሸነይያ ያርሾቱዋ ኡንቱንቱ ጼልሽን ያርሾፐ፥ ኡንቱንቱ ኑና ሹቻን ጫድክኖ? ");
INSERT INTO dwrENT_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ኑን መꬍና ጎዳ፥ ኑ ጾሳዉ፥ ያርሾቱዋ ሺሻናዉ እ ኑና አዛዝያዋዳን፥ ሄዙ ጋላሳ ኦግያ መላ ቢታ ባና ኮሼ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ካቲ፥ “መꬍና ጎዳዉ፥ ህንተንቱ ጾሳዉ፥ ህንተንቱ መላ ቢታ ቢደ ያርሻና ማላ፥ ታን ህንተንታ የዳና፤ ሽን ህንተንቱ ሃኪደ ቦፕተ፤ ታዉ ሀእ ዎስተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ሙሴ፥ “ታን ነ ማታፐ ከሶ ሳኣናካ መꬍና ጎዳ ዎሳና፤ ሀ ኡዱንጽያ ዉዲ ዎንት ካትያፐ፥ አ ኦሳንቻቱዋፐነ አ አሳፐ ክቻናዋ። ሽን መꬍና ጎዳዉ ያርሻናዉ አሳ የደናን እጻናዉ ካቲ ኑና ዛር ጭመና ማላ አኬኮ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ሄዋፐ ጉይያን ሙሴ ካትያ ማታፐ ከሲደ፥ መꬍና ጎዳ ዎሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","መꬍና ጎዳይ ሙሴ ኦቼዳዋዳን ኦꬄዳ፤ ኡዱንꬅያ ካትያፐ፥ አ ኦሳንቻቱዋፐነ አ አሳፐ እቱነ አተናን ክቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ሽን ሀእካ ቃይ ካትያ ዎዛናይ ዶንጭልና፥ አሳ የደናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ “ግብጼ ካትያኮ ባደ፥ ‘መꬍና ጎዳይ፥ እብራዌቱዋ ጾሳይ ኔና፥ “ኡንቱንቱ ታዉ ጎይናና ማላ ታ አሳ የዳ” ያጌ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ኔን የደናን እጻደ፥ ኡንቱንታ ኦይቃ ኡትያዋ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","መꬍና ጎዳ ኩሺ ደርያን ደእያ ነ መህያ ቦላ፥ ፓራቱዋ ቦላ፥ ሀረቱዋ ቦላ፥ ጋሎቱዋ ቦላ፥ ምያ ቦላ፥ ዶርሳቱዋ ቦላነ ዴሻቱዋ ቦላ ዎልቃማ ኢታ ሀርግያ የዳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ሽን ታን መꬍና ጎዳይ እስራኤልያ መህያ ግዱዋንነ ግብጼቱዋ መህያ ግዱዋን ሻኮታ መꬋና። እስራኤላቱ መህያፐ እቱነ ሀይቀና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","መꬍና ጎዳይ ዎድያ ኬሪደ፥ “ታን ዎንት ሀዋ ሀ ጋድያ ቦላን ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ዎንተꬃ ጋላስ መꬍና ጎዳይ ሄዋ ኦꬄዳ። ግብጼ አሳ መህያ ኡባይ ሀይቄዳ፤ ሽን እስራኤልያ አሳ መህያፐ እቱነ ሀይቂቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ካቲ ሀ የዉዋ ፓጫናዉ አሳ ኪቲደ፥ እስራኤለቱዋ መህያፐ፥ ሀራይ አቶ፥ እቱነ ሀይቂቤናዋ ኤሬዳ። ግዶፐነ ካትያ ዎዛናይ ዶንጭሎ ሳኣፐ ስመናን እጽና፥ አሳ የደናን ድጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ሜꬍና ጎዳይ ሄዋፐ ጉይያን፥ ሙሳነ አሮና፥ “ህንተንቱ ኩሽያ ኩንꬂደ ጮጭያፐ ብድንꬃ ኡጭተ፤ ሙሴ ካቲ ጼልሽን፥ ሄዋ ፑደ ጫርኮ ላሎ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ሄዌ ግብጼ ቢታ ኡባ ቦላ ሊቆ ባና ግዳናዋ፤ ግብጼ ቢታ ኡባን አሳ ቦላነ መህያ ቦላ ጊይያ ጺባይ ዎꬋናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ኡንቱንቱ ጮጭያፐ ብድንꬃ አኪደ፥ ካትያ ስንꬃን ኤቄድኖ፤ ሙሴ ሄዋ ፑደ ጫርኩዋን ላልና፥ አሳ ቦላነ መህያ ቦላ ጊይያ ጺባይ ዎꬍ አጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ሻሬቻቱካ ኡንቱንቱ ቦላነ ግብጼ አሳ ኡባ ቦላ ዎꬌዳ ጺባይ ኤሱዋ ድግና፥ ሙሴ ስንꬃን ኤቃናዉ ዳንዳይበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ሽን መꬍና ጎዳይ ሙሴዉ ጌዳዋዳንካ፥ ካትያ ዎዛና ዶንጭልሴዳ ድራዉ፥ ሙሴነ አሮነ ኦድያዋ ካቲ ስሰናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ “ጉራን ደንዳ ባደ፥ ካትያና ጋከታደ አ፥ ‘መꬍና ጎዳይ፥ እብራዌቱዋ ጾሳይ ኔና፥ “ታዉ ጎይናና ማላ ታ አሳ የዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ሄዌ ꬋዮፐ፥ ነ ቦላ፥ ነ ኦሳንቻቱዋ ቦላነ ነ አሳ ቦላ ታ ቦሻዉ ደእያ ኩመንꬃ ዎልቃ ታን ኪታና፤ ሳኣን ኡባን ታ ማል ባይናዋ ኔን ሄዋን ኤራናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ታን ሀኖደ ታ ኩሽያ የዳደ፥ ኔናነ ነ አሳ ኢታ ሀርግያን ሀ ሳኣ ቦላፐ ምልጽ ኡዳናሽን። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ታን ኔና ታ ዎልቃ በሳናዉነ ታ ሱንꬃይ ሳኣ ኡባ ቦላን ኦደታናዉ፥ ሄዎ ታን ኔና ካተ ኦꬃደ ዎꬃድ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ኔን ሀእካ ኦቶረታደ፥ ታ አሳ የደናን እጻዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ሄዋ ድራዉ፥ ታን ዎንት ሀኖደ ግብጼ ግብጼ ግዶደፐ ሀቼ ጋካናዉ ኡባካ ዎꬍ ኤረና፥ ዳሪ ዎልቃማ ሻቻ ቡክሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ሀእ ኔን ነ መህያነ ጋደን ነዉ ደእያዋ ኡባ ኤለካ ሶ ገልሳናዳን አዛዛ፤ አያዉ ጎፐ፥ ሶይ ገለናን ብሮ ጋደን ደእያ አሳ ኡባ ቦላነ መህያ ኡባ ቦላ ሻቻይ ዎꬋናዋ፤ ኡንቱቱ ሀይቃና” ያጌ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ካትያ ኦሳንቻቱዋፐ መꬍና ጎዳ ቃላዉ ያዬዳዋንቱ ባረንቱ አይለቱዋነ ባረንቱ መህያ ኤሌሊደ ሶይ ገልሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ሽን መꬍና ጎዳ ቃላ ካꬌዳዋንቱ ባረንቱ አይለቱዋነ ባረንቱ መህያ ጋደን አግ ባሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ “ግብጼ ቢታ ኡባ ቦላን: አሳ ቦላ፥ መህያ ቦላነ ግብጼ ጎሻቱዋን ድጭያባ ኡባ ቦላ ሻቻይ ዎꬋናዳን፥ ነ ኩሽያ ሳሉዋ ደንꬃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ሙሴ ባረ ጋትማ ሳሉዋ ዛሪደ ደንꬄዳ ዎደ፥ ጾሳይ ጉጉንꬃነ ሻቻ የዴዳ፤ ዋልቃንꬃይካ ዱገ ሳአዉ ዋልቃሜዳ። ጾሳይ ግብጼ ጋድያን ሻቻ ያት ቡክሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ሻቻይ ዎꬌዳ፤ ዋልቃንꬃይ ያነ ሃነ ዋልቃሜዳ፤ ግብጼ ጋድያን ካቲ ካተቶደፐ ዶምና፥ ግብጼ ቢታ ኡባን ዎꬌዳ ሻቻ ኡባፐ ሄዌ አꬍያ ኢታ ሻቻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ሄ ሻቻይ ግብጼ ቢታ ኡባ ጋደን ደእያ ኡባባ፥ አሳካ መህያካ ሾጬዳ፤ ጋደን ዶሌዳባ ኡባ ዱገ ዛሪደ ብዶዬዳ፤ ምꬃ ኡባ መንሬꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ሻቻይ ዎꬍቤና ጋዲ እስራኤላቱ ኡቴዳ ጎሸና ጋድያ ጻላላ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ካቲ ኪት ሙሳነ አሮና ጼስሲደ፥ “ሀእ ስም፥ ታን ናጋራ ኦꬃድ፤ መꬍና ጎዳይ ቱማንቻ፤ ታንነ ታ አሳይ ባይዛንቻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ኑዉ ጉጉንꬃይነ ሻቻይ ዳሬዳ ድራዉ፥ መꬍና ጎዳ ዎስተ። ታን ህንተንታ የዳና፤ ስም ሀዋፐ ስንꬃን ህንተንቱ ሀዋን ጋምእክታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ሙሴ አ፥ “ታን ሀ ካታማፐ ከሴዳ ዎደ፥ ታን ዎሳናዉ ታ ኩሽያ መꬍና ጎዳኮ ምጫና፤ ያቶፐ ጉጉንꬃይ አጋናዋ፤ ቃይ ሻቻ ዎꬃይ ኤቃና፤ ሳአይ መꬍና ጎዳዋ ግድያዋ ኔን ሄዋን ኤራና። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ሽን ኔንነ ነ ኦሳንቻቱ መꬍና ጎዳዉ ጾሳዉ ሀእካ ያየናዋ ታን ኤራይ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ታልባይ ጪሼዳ ድራዉነ ባንጋይ ትሼዳ ድራዉ፥ ታልባይነ ባንጋይ ሻቻን ባዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ሽን ዛርጋይነ ሞርገ ምꬃይ ካእያ ዎዲ ብራ ግዴዳ ድራዉ፥ ሻቻን ባይበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ሄዋፐ ጉይያን ሙሴ ካትያ ማታፐ ደንዲደ፥ ካታማፐ ጋጻ ከሴዳ። ባረ ኩሽያ መꬍና ጎዳኮ ምጬዳ፤ ያትና ጉጉንꬃይነ ሻቻይ አጌዳ፤ እራይካ ቢታ ቦላን ዱገ ትገትያዌ ኤቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ሽን ካቲ እራይ፥ ሻቻይነ ጉጉንꬃይ አጌዳዋ በኤዳ ዎደ ዛሪደካ ናጋራ ኦꬄዳ፤ እካ አ ኦሳንቻቱካ ባረንቱ ዎዛና ዶንጭልሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","መꬍና ጎዳይ ሙሴ ዶናን ሃሳዬዳዋዳንካ ካትያ ዎዛናይ ዶንጭልና፥ እስራኤላቱዋ እ የደናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","2","ሄዋፐ ጉይያን ሙሳ መꬍና ጎዳይ ሀዋዳን ያጌዳ፤ “ግብጼ ካትያኮ ባ፤ አያዉ ጎፐ፥ ታን ግብጼቱዋ ግዶን ማላነ ዎልቃማ ማላታ ታ ዎታ ኦꬄደንቶ ህንተንቱ ህንተንቱ ናናዉነ ህንተንቱ ናና ናናቶ ኦዳና ማላ፥ ቃይ ህንተንቱካ ታን መꬍና ጎዳ ግድያዋ ኤራና ማላ፥ ታ ዎልቃማ ማላታ ኡንቱንቱ ግዶን ኦꬃናዉ አ ዎዛናነ አ ኦሳንቻቱዋ ዎዛና ታን ዶንጭልሳ ዎꬃድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ሙሴነ አሮነ ካትያኮ ገሊደ አ፥ “መꬍና ጎዳይ፥ እብራዌቱዋ ጾሳይ ኔና ሀዋዳን ያጌ፤ ‘ኔን ታዉ አዛዘተናን አዉደ ጋካናዉ እጻይ? ታዉ ጎይናና ማላ ታ አሳ የዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ኔን ኡንቱንታ የደናን እጾፐ፥ ነ ቢታ ቦላ ታን ዎንት ቦልያ አሀና፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ቦሊ ኦንነ ቢታ ደማናዉ ዳንዳየናዳን ቢታ ካማናዋ። ህንተንቶ ሻቻፐ አቴዳ ጉꬃባ፥ ጋደን ድጭያ ምꬃይካ አተናን ኡባ ማናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ነ ጎለን ነ ሱንꬃቱዋ ጎለንነ ግብጼ አሳ ኡባ ጎለን ኡንቱንቱ ኩማናዋንታ፤ ሄዌ ነ አዎቱዋ፥ ዎይ ነ ማይዛ አዎቱ ሀ ቢታን ኡቶደፐ ሀኖ ጋካናዉ ሙለ በእቤናባ’ ያጌ” ያጌድኖ። ሄዋፐ ጉይያን ሙሴ ካትያ ስንꬃፐ ከሲደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ካትያ ሱንꬃቱ ካትያ፥ “ሀ ብታኒ ኑዉ አዉደ ጋካናዉ መቱዋ ጋሶ ግዳናዌ? ኡንቱንቱ መꬍና ጎዳዉ፥ ባረንቱ ጾሳዉ፥ ጎይናና ማላ፥ ኔን አሳ የዳ፤ ግብጼ ቢታይ ባዬዳዋ ኔን ሀእካ አኬክኪ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ሄዋ ድራዉ፥ ካቲ ሙሳነ አሮና ጉየ ዛሪደ፥ “ቢተ፤ መꬍና ጎዳዉ፥ ህንተንቱ ጾሳዉ ጎይንተ፤ ሽን ብያዋንቱ ኦና ኦኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ሙሴ፥ “ኑን ኑ ጭማ አሳነ ኑ ጉꬃ ናናቱዋና፥ ኑ ዶርሳ ዉደቱዋናነ ሚዛ ዉደቱዋና እትፐ ባና፤ አያዉ ጎፐ፥ ኑን ብያሳን መꬍና ጎዳ ባላ ቦንቻናዉ ኮሼ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ካቲ፥ “ታን ህንተንታ ህንተንቱ ናናነ ህንተንቱ ማቼቱዋ የድያዋ ግዶፐ፥ መꬍና ጎዳይ ህንተንታ ናጋናዉ ኮሼ። ሽን በእተ፤ ህንተንቱ ህንተንቱ ዎዛናን ኢታባ ቆፔዳዌ ቆንጭያን ኤረቴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ቱይት፥ ህንተንቱ፥ ‘ጾሳዉ ጎይናና’ ጊደ ኦችያዋ ግዶፐ፥ አቱማ አሳ ጻላላይ ቢደ መꬍና ጎዳዉ ጎይንተ” ያጌዳ። ሄዋፐ ጉይያን ሙሰነ አሮነ ካትያ ስንꬃፐ የደርሰቲደ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","መꬍና ጎዳይ ሙሳ፥ “ቦሊ ግብጼ ጋድያን ከሳናዳን፥ ሻቻፐ አቲደ ጋደን ድጭያባ ኡባ ልምእ ኦꬃና ማላ፥ ነ ኩሽያ ግብጼ ጋድያ ቦላን ምጫ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ሙሴ ባረ ጋትማ ግብጼ ጋድያ ቦላን ምጭና፥ መꬍና ጎዳይ አዋይ ዶልያ ባጋ ጫርኩዋ ሄ ጋላሳነ ቃማ ኡባ ሄ ጋድያ ቦላን ጫርክሴዳ፤ ዎንቴዳ ዎደ ሄ ጫርኩ ቦልያ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ቦሊ ግብጼ ቢታ ኡባ ቦላ ሻምእ ጊደ፥ ቢታ ኡባ ሳን ከስ ኡቴዳ። ሀዋ ኬሻ ቦልያ ቦሻይ ሄ ቢታን ሀዋፐ ካሰና ሀንቤና፤ ዎይ ሀዋፐ ስንꬃዉነ ዛረꬂደ ሀነና። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ቢታይ ካረጻና ጋካናዉ ቦሊ ቢታ ኡባ ካሜዳ። ሄ ቦሊ ሻቻፐ አቲደ ጋደን ድጭያባ ኡባነ ምꬃ ቦላን ደእያ አይፍያ ኡባ ምልጽ ኦꬄዳ። ያትና ምꬃ ቦላን እርጻ ሀይꬃይ፥ ዎይ ጋደን አታክልቲ ግብጼ ቢታ ኡባን አያይነ አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ካቲ ሙሳነ አሮና ኤለካ ጼስሲደ፥ “መꬍና ጎዳ ህንተንቱ ጾሳነ ህንተንታ ታን ናቃድ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ስም ህንተንቱ ታዉ ታ ናጋራ ሀ እት ገደ ጻላላዉ አቶ ጊተ፤ ሀ ዎꬍያ ቦሻ ታፐ ድጋና ማላ፥ መꬍና ጎዳ ህንተንቱ ጾሳ ዎስተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ሙሴ ካትያ ማታፐ ከሲደ፥ መꬍና ጎዳ ዎስና፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","መꬍና ጎዳይ ሄ ጫርኩዋ አዋይ ዉልያ ባጋ ዎልቃማ ጫርኮ ላምና ቦልያ ቶክ፥ ዞኦ አባኮ አፌዳ። ግብጼ ቢታ ኡባን እት ቦሊነ አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ግዶፐነ፥ መꬍና ጎዳይ ካትያ ዎዛና ዶንጭልሴዳ ድራዉ፥ እስራኤላቱዋ የደናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","መꬍና ጎዳይ ሙሳ፥ “ግብጼ ጋድያን አሳይ ቦች በአናዉ ዳንዳይያ ኬሻ ꬉማይ ꬉማና ማላ፥ ነ ኩሽያ ሳሉዋ ደንꬃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ሙሴ ባረ ኩሽያ ሳሉዋ ደንꬄዳ፤ ግብጼ ቢታ ኡባን ሄዙ ጋላሳ ኩመንꬃ ባራ ꬉማይ ꬉሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ሄ ሄዙ ጋላሳቱዋን አሳይ ኦንነ እቱ እቱዋ በኤናን፥ ዎይ ባረ ሳኣፐ ደንዲደ ቤናን ታኬዳ። ሽን እስራኤለቱ ደእያ ሳኣን ኡባን ኡንቱንቶ ፖኡ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ካቲ ሙሳ ጼስሲደ፥ “ቢተ፤ መꬍና ጎዳዉ ጎይንተ፤ ህንተንቱ ማቼቱካ ህንተንቱ ናናይካ ህንተናና ባናዉ ዳንዳዪኖ። ህንተንቱ ዶርሳ ዉድያነ ህንተንቱ ሚዛ ዉድያ ጻላላ የጊደ ቢተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ሽን ሙሴ አ፥ “ኑን ያርሹዋነ ጹጊደ ያርሽያ ያርሹዋ መꬍና ጎዳ፥ ኑ ጾሳዉ፥ ሺሻናዉ፥ መህያ ኑዉ እማደ የድያዌ ኔና ጉሳካ? ");
INSERT INTO dwrENT_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ኑ መሂ ኡባይካ ኑናና ባናዉ ኮሼ፤ ቅንጫፍለ እቱነ ጉየ አተና። መꬍና ጎዳ፥ ኑ ጾሳዉ፥ ጎይንያ ጎይናዉ ሄ መህያፐ ዶሪደ አካናዉ ኮሼ፤ ኑን ያ ጋከናን ደኢደ፥ መህያፐ ሀቃዋ ሀቃዋ መꬍና ጎዳዉ ያርሻነንቶ ኤራናዉ ዳንዳዮኮ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ሽን መꬍና ጎዳይ ካትያ ዎዛና ዶንጭልስና እ ኡንቱንታ የዳናዉ ኮይቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ሄዋፐ ጉይያን ካቲ ሙሳ፥ “ታ ማታፐ ክቻ! ላኤንꬆ ታ ስንꬃን ለምእ ጋደ ኔና ኤራ! ኔን ታ አይፍያ ታ ዴሙዋ በኤዳ ጋላሳይካ ነዉ ሀይቆ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ሙሴ አ፥ “ቱማካ፤ ኔን ጌዳዋዳን ታን ኔና ላኤንꬆ ኡባካ በእከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ሙሴዉ መꬍና ጎዳይ፥ “ታን ግብጼ ካትያ ቦላነ አ አሳ ቦላ እት ሀራ ቦሻ የዳና፤ ሄዋፐ ጉይያን እ ህንተንታ ሀ ጋድያፐ ከስ የዳናዋ፤ እ ህንተንታ እቱነ አተናን ኡባካ የደርሳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","እስራኤልያ አሳይ፥ ማጫዌ አቱማዌ ባረ ሾሮቱዋፐ ብራፐነ ዎርቃፐ መቴዳ ሚሻቱዋ ኦቻና ማላ፥ ኡንቱንቶ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","መꬍና ጎዳይ እስራኤልያ አሳቱ ግብጼቱዋ ስንꬃን ናሸታናዳን ኦꬄዳ። ቃይ ሙሴ ባረ ሁጲያዉካ ግብጼ ጋድያን ካትያ ኦሳንቻቱዋንነ አሳን ሎይꬅ ዳሮ ቦንቼቴዳ አሳዳን ጼለቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ሙሴ ካትያ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳይ ሀዋዳን ያጌ፤ ‘ቃማ ግዶ ብላህያን ታን ግብጼ ግዱዋና አꬋና፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ግብጼ ጋድያን ደእያ ባይራ አቱማ ናናይ ኡባይ፥ ካዉተꬃ ኦይድያን ኡትያ ካትያ ባይራ ናኣፐ ዶሚደ፥ ዎጻን ጋጭያ ቆማት ባይራ ናኣ ጋካናዉ ባይራ የለቴዳ መሂካ አተናን ኡባይ ሀይቃናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ግብጼ ቢታ ኡባን ሀዋፐ ካሰ ባጋን ሀንቤናነ ስንꬃፐካ ሀነና ዎልቃማ ዬኩ ዬከታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ሽን እስራኤላቱ ግዱዋን፥ አሳ ቦላ ዎይ መህያ ቦላ ካናይነ ቦጨና’ ያጌ። ሄ ዎደ መꬍና ጎዳይ ግብጼቱዋንነ እስራኤልያ ግዱዋን ሻኮታ መꬍያዋ ኔን ኤራናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ሀ ነ ኦሳንቻቱ ኡባይ ታኮ ዪደ፥ ታ ስንꬃን ጉፋን ጎይኒደ፥ ‘ከሳደ ባርኪ! ኔና ካልያ አሳይ ኡባይካ ቦ!’ ጋናዋንታ። ሄዋፐ ጉይያን ታን ባና” ያጌዳ። ሄዋፐ ጉይያን ሙሴ ሀንቁዋን ኤጸቲደ፥ ካትያ ስንꬃፐ ከሲደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ሙሴዉ መꬍና ጎዳይ ኮይሮ፥ “ታ ማላልስያ ማላታይ ግብጼ ጋድያን ዳራና ማላ፥ ካቲ ህንተንቱ ኦድያዋ ስሰናን እጻናዋ” ያግ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ሙሴነ አሮነ ሀ ማላልስያ ማላታ ኡባ ካትያ ስንꬃን ኦꬄድኖ፤ ሽን መꬍና ጎዳይ ካትያ ዎዛና ዶንጭልሴዳ፤ ያትና እ እስራኤላቱዋ ባረ ጋድያፐ የደናን እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","መꬍና ጎዳይ ግብጼ ጋድያን ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ሀ አግናይ ህንተንቶ ላይꬃዉ ኮይሮ አግና ግዶ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","እስራኤልያ አሳዉ ኡባዉ ሀዋ ኦድተ፤ ሀ አግናይ ገሌዳ ታማንꬃ ጋላሳን፥ እት አሳይ ባረ ሶይ አሳዉ እት ኮልያ ዶርሳ ዎይ እት ኮልያ ዴሻ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ሄ ጎለ አሳ ፓይዱ ሄ ዶርሳ ዉርስ ማናዉ ጉጾፐ፥ እነ አዉ ኡባፐ ማታትያ ሾሩ ባረንቱ ሶ አሳ ፓይዲደ እት እት አሳይ ማናዉ ዳንዳይያ ኬሻ አኬኪደ፥ ሄ መህያ ሹኪደ እትፐ ሚኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ህንተንቱ ዶር አክያ መሂ የለቶደፐ እት ላይꬃ ግዴዳዋ፥ አ ቦላን አይ ፓጫይነ ባይና አቱማዋ ግዶ። ህንተንቱ ዶርሳፐ ዎይ ዴሻፐ አካናዉ ዳንዳዪታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ሀ አግናዉ ታማነ ኦይደንꬆ ጋላሳ ጋካናዉ ኡንቱንታ ሄምተ፤ ሄ ጋላስ ኦማርስ እስራኤልያ አሳይ ኡባይ ኡንቱንታ ሹካናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ያቲደ ሱꬃፐ አማሬዳዋ አኪደ፥ ኡንቱንቱ ምያ ጎለዉ ላኡ ማቃንያነ ጉባንያ ኦክኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","አሹዋ ሄ ጋላስ ቃማ ታማን ጺጽ ጺጺደ፥ ጫምያ ቦንጭያናነ ኡኬዳ ኡክꬃና ሚኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","አሹዋ ቃይያ ዎይ ዶይሲደ ሞፕተ፤ ሁጲያካ ገደቱዋካ ቃንꬃ ግዶ አሹዋካ ኡባ ቃንጸናን ሙምያ ጺጽተ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ሄ አሹዋፐ ሳአይ ዎንታና ጋካናዉ አይነ አሾፕተ፤ ሽን አማሬዳዌ አቶፐ፥ ሄዋ ጹጋናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ሙሳ ሚደ፥ ኦግያዉ ጊግያ ማዩዋ ማዪደ፥ ህንተንቱ ጫማ ህንተንቱ ገድያን ዎꬂደ፥ ህንተንቱ ጋትማ ህንተንቱ ኩሽያን ኦይቂደ ሚታ። ኤሌል ኤሌል ሚተ፤ ሀዌ መꬍና ጎዳ ፓስጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“ታን ሄ ጋላስ ቃማና ግብጼን አꬋደ ባይራ የለቴዳ ኡባ፥ አሳካ፥ መህያካ ዎꬋና፤ ግብጼ ኤቃቱዋ ኡባ ቦላካ ታን ፕርዳና፤ ታን መꬍና ጎዳቴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ሄ ሱꬃይ ህንተንቱ ደእያ ጎልያ ኤርስያ ማላ ግዳናዋ። ታን ሄ ሱꬃ በኦ ዎደ፥ ህንተንታ አጋደ አꬋና፤ ታን ግብጼ ጋድያ ቦሻን ሾጭያ ዎደ፥ ህንተንታ አይ ቦሻይካ ቦቼና። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ሀ ጋላሳይ ህንተንቶ ቆፕ ቆፕ ቦንችያ ጋላሳ ግዶ፤ ህንተንቱ የለታይ ኡባይ መꬍና ጎዳ ባላ ቦንችተ፤ ሀዋ ዎጋ ኦꬂደ ኡባ ዎደ ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“ላፑን ጋላሳይ ጋካናዉ እርሹዋ የግቤና ኡክꬃ ሚተ፤ ሽን ኮይሮ ጋላስ እርሹዋ ህንተንቱ ሶፐ ድግተ። ሄ ኮይሮ ጋላሳፐ ዶሚደ ላፑንꬃ ጋላስ ጋካናዉ፥ እርሹዋና ደእያ ኡክꬃ ምያ አሳይ እስራኤልያ አሳ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ኮይሮ ጋላስ ጌሻ ሽቁዋ ሺቅተ፤ ሀራ ጌሻ ሽቁዋ ቃይ ላፑንꬃ ጋላሳን ሺቅተ፤ አሳይ ማናዉ ቁማ ካꬃናዋፐ አትና፥ ሀ ጋላሳ ኡባን አይነ ኦꬆፕተ፤ ህንተንቱ ኦꬃናባይ ሄዋ ጻላላ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“እርሹ ገልቤና ኡክꬃ ባላ ቦንችተ፤ አያዉ ጎፐ፥ ታን ህንተንቱ ጩጉዋ ግብጼ ጋድያፐ ከሴዳዌ ሄ ጋላሳና። ሄ ጋላሳ፥ የለታፐ የለታይ ጋካናዉ ፕን ከስያ ዎጋ ኦꬂደ ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ኮይሮ አግናን፥ ሄ አግናዉ ታማነ ኦይደንꬆ ጋላሳ ኦማርሳፐ ዶሚደ፥ ላታማነ እተንꬁዋ ኦማርስ ጋካናዉ እርሹ ገልቤና ኡክꬃ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ላፑን ጋላሳይ ጋካናዉ እርሹ ህንተንቱ ሶን ቤቶፖ፤ እርሹ ገሌዳዋ ምያ አሳይ በተ ግድና ዎይ ሄ ቢታ አሳ ግድና፥ እስራኤልያ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","እርሹ ገሌዳዋ አያነ ሞፕተ፤ ህንተንቱ ደእያ ሳኣን ሀቃንካ እርሹ ገልቤና ኡክꬃ ማናዉ ኮሼ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ሄዋፐ ጉይያን ሙሴ እስራኤልያ ጭማቱዋ ኡባ ጼስሲደ ኡንቱንታ ሀዋዳን ያጌዳ፤ “ህንተንቱ ኤለካ ቢደ፥ ህንተንቱ ሶ አሳዉ ፓስጋዉ ኮልያ፥ ዶርሳ ዎይ ዴሻ ሹክተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ህሶጵያ ጌተትያ ሀይꬃፐ ዳንክ አኪደ፥ ከርያን ደእያ ሱꬃን ናቂ ከሲደ፥ ሄ ሱꬃ ላኡ ማቃንያንነ ጉባንያ ኦክተ፤ ህንተንቱፐ እት አሳይነ ሳአይ ዎንታና ጋካናዉ ባረ ጎልያ ፐንግያፐ ካረ ከሶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","መꬍና ጎዳይ ግብጼቱዋ ሾጭ ዎꬋናዉ ሄ ቢታና አꬍያ ዎደ፥ ሱꬃ ጉባንያንነ ላኡ ማቃንያን በአና፤ ያቲደ ካረና አꬋና፤ ዎꬍያዌ ህንተንቱ ሶ ገሊደ፥ ህንተንታ ዎናዳን አ ህንተንቱ ሶ ገልሰና። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“ህንተንቱ ሀ አዛዙዋ ህንተንቶነ ህንተንቱ ዘረꬃዉ ኡባ ዎደ ዎጋ ኦꬂደ አዛዘትተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","መꬍና ጎዳይ ካሰ እማና ጌዳዋዳን እ እምያ ቢታ ህንተንቱ ገልያ ዎደ፥ ሀ ዎጋ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ህንተንቱ ናናይ ህንተንታ፥ ‘ሀ ቦንቾ ባላ ብርሸꬃይ አዬ?’ ያጊደ ኦችያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ህንተንቱ ኡንቱንታ፥ ‘ሀዌ ጾሳ ቦንቻናዉ ያርሽያ ፓስጋ ያርሹዋ፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ግብጼ ጋድያን እስራኤልያ አሳ ጎልያ አግ አꬍ ቢደ፥ ግብጼቱዋ ዎꬊደ፥ ኑና አሼዳ ድራሳ’ ያግተ” ያጌዳ። ሄዋፐ ጉይያን አሳይ ጉልባቲደ ጎይኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","እስራኤላቱ መꬍና ጎዳይ ሙሳነ አሮና አዛዜዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ቃማ ግዶ ብላህያን መꬍና ጎዳይ ግብጼን ባይራ የለቴዳ ኡባ፥ ካዉተꬃ ኦይድያን ኡቴዳ ካትያ ባይራ ናኣፐ ዶሚደ፥ ቃሾ ጎለን ደእያ ኦሞደቴዳዋንቱ ባይራ ናኣ ጋካናዉ፥ ቃይ ባይራ የለቴዳ መህያ ኡባ ድፕ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ካቲ፥ አ ኦሳንቻቱ ኡባይነ ግብጼ ጋድያ አሳይ ኡባይ ቃማ ደንዴድኖ። ግብጼ ጋድያን አሳይ ሀይቂቤና ጎሊ ኡባካ ባይና ድራዉ፥ አሳይ ኮሻ ꬎቁ ኦꬂደ ዎልቃማ ዬኩዋ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ሄ ጋላስ ቃማ ካቲ ሙሳነ አሮና ጼሲደ፥ “ደንድተ! ህንተካ እስራኤልያ አሳይካ ታ አሳ ግዱዋፐ ከስ ቢደ ህንተንቱ ኦቼዳዋዳንካ መꬍና ጎዳዉ ጎይንተ! ");
INSERT INTO dwrENT_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ህንተንቱ ጌዳዋዳንካ ህንተንቱ ዶርሳ ዉድያነ ህንተንቱ መህያ ዉድያ አኪደ ቢተ! ቃይ ታዉካ ዎስተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ግብጼ አሳይ እስራኤላቱ ጋድያፐ ኤለካ ከሳና ማላ ድርቢሴድኖ። አያዉ ጎፐ፥ ኡንቱንቱ፥ “ሄዌ ꬋዮፐ፥ ኑን ኡባይካ ዉሬቶ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ሄዋ ድራዉ፥ እስራኤልያ አሳቱ ባረንቱ እርሹ ገልቤና ሙናቃ ከርያን ኩንꬂደ፥ ባረንቱ ማዩዋን ጻጺደ፥ ሀሽያን ቶኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","እስራኤለቱ ሙሴ ኡንቱንታ አዛዜዳዋዳን፥ ግብጼቱዋ ብራ ሚሻቱዋ፥ ዎርቃ ሚሻቱዋነ ማዩዋ፥ “እምተ” ጊደ ኦቼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","መꬍና ጎዳይ ግብጼቱዋ ስንꬃን ሄ አሳይ ሳበታናዳን ኦꬅና፥ ግብጼቱ ኡንቱንቱ ኦቼዳዋ እሜድኖ። ሄዋዳን ያቲደ ኡንቱንቱ ግብጼ አሳቱዋ ማጹዋ ቦንቂ አኪደ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","እስራኤላቱ ራምሳ ጌተትያ ካታማፐ ደንዲደ ሱኮታ ጌተትያ ሳኣ ገድያን ሀመቲደ ቤድኖ። አሳይ ናናነ ማጫዋንታ ጉጀናን ፓይድና፥ ኡሱፑን ጼቱ ሻአ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ቃይ ኡንቱንቱና ሀራ ዳሮ አሳይ፥ ዳሮ መሂነ ዶርሳ ዴሻ ዉዲ ላገቲደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ግብጼፐ ኡንቱንቱ አኪደ ከሴዳ ሙናቃ እርሹ ገልቤና ኡክꬃ ኡኬድኖ፤ አያዉ ጎፐ፥ ኡንቱንቱ ግብጼፐ ድርባን ከሴድኖ፤ ባረንቶ ሽንቃ ካꬃናዉካ፥ ሙናቃይ ደንድና ኡካናዉካ ኡንቱንታ ጋꬅቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","እስራኤላቱ ግብጼ ጋድያን ደኤዳ ላይꬃይ ኦይዱ ጼታነ ሀታማ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ሄ ኦይዱ ጼታነ ሀታሙ ላይꬃይ ዉርያ ሄ ዉርሰꬃ ጋላሳን፥ መꬍና ጎዳ ጩጉ ኡባይ ግብጼ ጋድያፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","መꬍና ጎዳይ ባረ አሳ ናጊደ፥ ግብጼ ጋድያፐ ከስያ ዎደ ሳአይ ቃማ፤ ሄ ቃማይ የለታፐ የለታ ጋካናዉ፥ እስራኤልያ አሳይ ቤጎቲደ ናጊደ አቅያ፥ መꬍና ጎዳዉ ዱማቴዳ ቃማ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","መꬍና ጎዳይ ሙሳነ አሮና፥ “ፓስጋ ጋላሳ ቦንችያ ዎጋይ ሀዋ፤ በተ አሳይ አፐ ኡባካ ሞፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ህንተንቱ ሻሉዋን ሻሜዳ አይሊ ህንተንቱ አ ቃጻሮዋፐ ጉይያን አፐ ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ሽን እማꬃተꬃን ህንተናና ጋምእያ እማꬃይነ ከራ ኦꬅያ እማꬃይ አፐ ኡባካ ሞፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ሀ ፓስጋ ህንተንቱ እት ጎለን ሚተ፤ ህንተንቱ ሄ አሹዋፐ አያነ ካረ ከሶፕተ። መቀꬃቱዋፐ እቱዋነ መንꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","እስራኤልያ ማባራይ ኡባይ ፓስጋ ቦንቻናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“በቲ ዪደ ህንተንቱ ግዶን ደእያ አሳይ መꬍና ጎዳ ፓስጋ ቦንቻናዉ ኮዮፐ፥ ኮይሮ ሄ አቱማ አሳይ ኡባይ ቃጻረቶ። ሄዋፐ ጉይያን እ ሄ ቢታን የለቴዳ አሳዳን ሺቂደ፥ ፓስጋ ቦንቻናዉ ዳንዳዬ። ሽን ቃጻረትቤና አሳይ ኡባካ አፐ ሞፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ህንተንቱ ቢታን የለቴዳዎካ ህንተንቱ ግዶን በተ ግዲደ ደእያዋዉካ ሄ ዎጋይ እቱዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","እስራኤላቱ ኡባይ መꬍና ጎዳይ ሙሳነ አሮና አዛዜዳዋዳንካ ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ሄ ጋላስካ መꬍና ጎዳይ እስራኤላቱዋ ኡንቱንቱ ጩጉዋን ጩጉዋን ግብጼ ጋድያፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ባይራ የለቴዳ አቱማዋ ኡባ ታዉ ዱማያ። እስራኤልያ አሳ ግዶን ኡሉዋፐ የለቴዳ ባይራ ኡባይ፥ መህያ ግድና አሳ ግድና፥ ኡባይካ ታዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ሄዋፐ ጉይያን ሙሴ አሳ፥ “ግብጼፐ፥ አይለተꬃ ጋድያፐ ህንተንቱ ከሴዳ ጋላሳ፥ ሀ ጋላሳ ሀሳይተ፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ባረ ዎልቃማ ኩሽያን ህንተንታ ከሴዳ፤ ሄዋ ድራዉ፥ እርሹ ገሌዳዋ ኡባካ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ህንተንቱ ሀቼ፥ ላይꬃዉ ኮይሮ ግዴዳ አቢባ አግናን ከሲታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","መꬍና ጎዳይ ካናነቱዋ፥ ሂተቱዋ፥ አሞራዋናቱዋ፥ ሂዌቱዋነ ያቡሳዋናቱዋ ጋድያ ህንተንታ ጋꬅያ ዎደ፥ ህንተንቱ ሀ ፓስጋ ሀ አግናን ቦንቺታ። ሄ ቢታይ ጾሳይ ህንተዉ እማና ማላ፥ ካሰ ህንተንቱ አዋቶ ጫቂ ዎꬄዳ ቢታ። ሄ ቢታይ ማꬃይነ ኤሳይ ጎግያ ቢታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ህንተንቱ ላፑን ጋላሳይ ጋካናዉ እርሹ የገትቤና ኡክꬃ ማንታ፤ ላፑንꬃ ጋላሳይ መꬍና ጎዳ ባላ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ሄ ላፑን ጋላሳቱዋን እርሹ የገትቤና ኡክꬃ ህንተንቱ ማና፤ ህንተንቱ ግዶን እርሹዋና ደእያባይ አያይነ ቤቶፖ፤ ነ ቢታ ዛዋን ሀቃንነ እርሹ ቤቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“ሄ ጋላስ ኔን ነ ናአዉ፥ ‘ታን ሀዋ ኦꬅያዌ፥ ታን ግብጼፐ ከስያ ዎደ፥ መꬍና ጎዳይ ታዉ ኦꬄዳዋ ሀሳያናሳ’ ያጋደ ኦዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","መꬍና ጎዳይ ህንተንታ ባረ ዎልቃማ ኩሽያን ግብጼፐ ከሴዳ ድራዉ፥ መꬍና ጎዳ ዎጋይ ህንተንቱ ዶናፐ ዎናዳን፥ ሀ ቦንቼትያ ጋላሳይ ነ ኩሽያን ቃቼዳነ ነ ዴሙዋን ዎꬄዳ ሀሳይስያዋ ማላ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ሄዋ ድራዉ፥ ህንተንቱ ሀ ዎጋ ላይꬃን ላይꬃን አ ዎድያን ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“መꬍና ጎዳይ ህንተንቱነ ህንተንቱ ማይዛ አዋቶ እማናዉ ጫቄዳዋዳን፥ እ ህንተንታ ካናነቱዋ ጋድያ ገልሲደ፥ ሄ ጋድያ ህንተንቶ እምያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ኡሉዋፐ ባይራ የለቴዳ ኡባ መꬍና ጎዳዉ ዱማያ፤ ነ ሚዛ ባይራ የለትያ አቱማዋ ኡባይ መꬍና ጎዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ባይራ የለትያ ሀርያ ኡባ ዶርሳ ማራን ዎዛ አካ። ዎዘናዋ ግዶፐ፥ አ ሞርግያ መንꬃ፤ ነ አቱማ ናና ግዶን ባይራ የለቴዳዋንታ ኡባ ዎዛ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ስንꬃና ያና ዎድያን ነ ናአይ ኔና፥ ‘ሀዌ አዬ?’ ያጊደ ኦቾፐ፥ ኔን አ፥ ‘መꬍና ጎዳይ ኑና ዎልቃማ ኩሽያን ግብጼፐ፥ አይለተꬃ ጋድያፐ ከሴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ግብጼ ካቲ ዶንጭሊደ ኑና የደናን እጽና፥ መꬍና ጎዳይ ግብጼ ጋድያን ደእያ ባይራ ኡባ፥ አሳፐ ዶሚደ መህያ ባይራ ጋካናዉ ዎꬌዳ። ታን አት ኡሉዋፐ ኮይሮ የለቴዳ አቱማዋ ኡባ መꬍና ጎዳዉ ያርሽያዌነ ታ ባይራ አቱማ ናና ታን ዎዝያዌ ሄዋሳ’ ያጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","መꬍና ጎዳይ ኑና ባረ ዎልቃማ ኩሽያን ግብጼፐ ከሴዳዎ፥ ሀዌ ህንተንቶ ኩሽያን ቃቼዳነ ዴሙዋን ዎꬄዳ ማላ ማላ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ካቲ አሳ የዴዳ ዎደ፥ ጾሳይ ኡንቱንታ ፕልስጼማ ቢታና አꬅያ ኦጊ ማታ ግዶፐነ ሄ ኦግያና ካለꬅቤና፤ አያዉ ጎፐ፥ ጾሳይ፥ “አሳይ ኦላ በኦፐ፥ ባረ ቆፋ ላሚደ፥ ጉየ ግብጼ ስመናዳን” ያጊደ ቆፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ሄዋ ድራዉ፥ ጾሳይ አሳ መላ ቢታ ኦግያና ዩሺደ፥ ዞኦ አባኮ ካለꬄዳ። እስራኤለቱ ግብጼ ጋድያፐ ኦላዉ ጊጊደ ፑደ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ዮሴፎ እስራኤልያ አሳ ጫቀꬅ ዎꬄዳ ድራዉ፥ ሙሴ አ መቀꬃ ባረናና አኪደ ቤዳ፤ ዮሴፎ ኡንቱንታ፥ “ጾሳይ ቱሙፐ ህንተንታ ማዳናዉ ያናዋ፤ ሄ ዎደ ህንተንቱ ታ መቀꬃ ሀ ሳኣፐ ፑደ ህንተናና አኪደ ቢተ” ያጊደ ኦድ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ኡንቱንቱ ሱኮተፐ ደንዲደ መላ ቢታ ዶናን ደእያ ኤታማን ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","መꬍና ጎዳይ ኡንቱንቱ ጋላስነ ቃማ ሀመታና ማላ፥ ጋላሳን ኡንቱንታ ኦግያ በሳናዉ ሻርያ ቱሳን፥ ቃማን ኡንቱንቶ ፖእሳና ማላ ታማ ቱሳን ኡንቱንታ ካለꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ጋላስ ሻርያ ቱሳይ ዎይ ቃማ ታማ ቱሳይ አሳ ስንꬃፐ ክችቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","ሄዋፐ ጉይያን ሙሳ መꬍና ጎዳይ፤ “ኡንቱንቱ ጉየ ስሚደ ምግዶላፐነ አባፐ ግዱዋን፥ ፕሃህሮታ ማታን ኡታናዳን ኦዳ፤ ኡንቱንቱ አባ ላንቂያን ባኣል-ጻፎና ስንꬃ መላ ቢታን ኡትኖ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ካቲ፥ ‘እስራኤላቱ መላ ቢታይ ጎርድና፥ ሀንያባ ꬋዪደ ቢታን ጮ ቶይላካቲኖ’ ያጊደ ቆፓናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ታን ካትያ ዎዛና ዶንጭልሳና፤ እ ኡንቱንታ የደርሳና፤ ታን ካትያንነ አ ኦላንቻቱዋ ኡባን ቦንቼታና፤ ግብጼቱካ ታን መꬍና ጎዳ ግድያዋ ኤራና” ያጌዳ። እስራኤላቱ እ ኦዴዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","አሳይ ባቃት ድጌዳዋ ግብጼ ካትያዉ ኦድና፥ እነ አ ሱንꬃቱ እስራኤላቶ ቆፔዳ ባረንቱ ቆፋ ላሚደ፥ “ኑን ሀዋ ዋቴቶ? ኑን እስራኤላቱዋ የዲደ፥ ኡንቱንቱ ኑዉ ኦꬅያ ዎልቃፐ መላ አቴዶ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ሄዋ ድራዉ፥ እ ባረ ፓራ ጋርያ ኮሪደ፥ ባረ ኦላንቻቱዋ ባረናና አኪደ ደንዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","እ ኡሱፑን ጼቱ ዶረቴዳ ፓራ ጋረቱዋ፥ ግብጼ ጋድያን ደእያ ሀራ ጋረቱዋ ኡባና፥ ኡንቱንቱ ኡባዉ ካፑዋ ካፑዋ ሱንꬂደ አኪደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","መꬍና ጎዳይ ግብጼ ጋደ ካትያ፥ ዎዛና ꬉልስና፥ ጾሳ ዎልቃን ከሳ ቦላ ደእያ እስራኤልያ አሳ የደርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ሄዋፐ ጉይያን ግብጼ አሳቱ፥ ካትያ ፓራቱ ኡባይነ ፓራ ጋረቱ፥ ፓራ አሳቱነ ኦላንቻቱ እስራኤላቱዋ ካሊደ የደርሴድኖ። አባ ዶናን ባኣል-ጻፎና ስንꬃ ባዙዋን ደእያ ፕሃህሮታ ማታን ኡንቱንቱ ኡቴዳዋንታ ደሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ካቲ ማት ድግና፥ እስራኤላቱ ꬎቁ ግ ጼልያ ዎደ፥ ግብጼቱ ኡንቱንቱ ጌዱዋ ካሊደ ዬዳዋ በኤድኖ፤ ያቲደ ዳሮፐ ያዪደ፥ መꬍና ጎዳኮ ዋሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ኡንቱንቱ ሙሳ፥ “ኔን ኑና ግብጼን ዱፉ ꬋይና መላ ቢታን ሀይቃናዳን ከሳዲየ? ኑና ግብጼፐ አያዉ አሃድ? ");
INSERT INTO dwrENT_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ግብጼን ደኢደ ኑን፥ ‘ኑና አጋ ባሻ፤ ኑን ግብጼቶ ሞደታና’ ያጊደ ነዉ ኦድበይኮየ? መላ ቢታን ሀይቃናፐ ኡንቱንቶ ሞደትያዌ ኑዉ ሎአ ሽን” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ሽን ሙሴ አሳ፥ “ያዮፕተ፤ ምን ኤቂተ፤ መꬍና ጎዳይ ሀቼ ህንተንታ አሽያ አሹዋ ህንተንቱ በአና። ሀቼ ህንተንቱ በእያ ግብጼቱዋ ላኤንꬆ ኡባካ በእክታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ህንተንቱ ድራዉ መꬍና ጎዳይ ኦለታናዋ፤ ህንተንቱፐ ኮየትያዌ ጮኡ ጉሳ ጻላላ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","መꬍና ጎዳይ ሙሳ፥ “ኔን ታኮ አያዉ ዋሳይ? እስራኤላቱ ስንꬃዉ ሀመታና ማላ ኦዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ነ ጻምኣ ደንꬃደ አባ ቦላ ምጫ፤ ሃꬃይ ላኡ ከሲደ ሻከታናዋ፤ እስራኤላቱካ መላ ቢታና አባ ፕኒደ ባናዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ታን ግብጼቱዋ ዎዛና ዶንጭልስና፥ ኡንቱንቱ ህንተንቱ ጌዱዋ ካሊደ አባን ገላናዋንታ። ታን ካትያነ አ ኦላንቻቱዋ ኡባ ቦላን፥ አ ፓራ ጋረቱዋነ አ ፓራ አሳቱዋ ቦላን ቦንቹዋ ታዉ ደማና። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ታን ካትያ ቦላን፥ አ ፓራ ጋረቱዋ ቦላንነ አ ፓራ አሳቱዋ ቦላን ታዉ ቦንቹዋ ደሜዳ ዎደ፥ ታን መꬍና ጎዳ ግድያዋ ግብጼቱ ኤራናዋንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ሄዋፐ ጉይያን ጾሳ ኪታንቻይ፥ እስራኤልያ ኦላንቻቱዋፐ ስንꬃና ሀመትያዌ፥ ጉየ አꬊደ ኡንቱንቱፐ ጉየና ሀመቴዳ። ሻርያ ቱሳይካ ኡንቱንቱ ስንꬃን ደእያ ሳኣፐ ጉየ ባጋ ዩዪደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ግብጼቱዋ ኦላንቻቱዋፐነ እስራኤለቱዋ ኦላንቻቱዋፐ ግዱዋን ኤቄዳ። ሄ ሻሪ ቃማ ኡባን እት ባጋና ꬉምሲደ፥ ህንኮ ባጋና ፖእሴዳ፤ ያትና ቃማ ኡባ እቱ እቱዋኮ ሺቅበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ሄዋፐ ጉይያን ሙሴ አባ ቦላን ባረ ኩሽያ ምጬዳ፤ መꬍና ጎዳይ ሄ ጋላስ ቃማ ኡባን አዋይ ዶልያ ባጋፐ ዎልቃማ ጫርኩዋ የዲደ፥ አባ ጉየ ዛሪደ መላ ቢታ ከሴዳ። ሃꬃይ ሻከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","እስራኤለቱ አባ ግዱዋና መላ ቢታን ሀመቲደ፥ ሃꬃይ ኡንቱንቶ ኡሸቻናነ ሀድርሳና ጎዳዳን ኤቂና ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ግብጼቱ ኡንቱንታ የደርሴድኖ፤ ካትያ ፓራ ኡባቱ፥ አ ፓራ ጋረቱነ አ ፓራ አሳቱ ኡንቱንታ ካሊደ፥ አባ ግዶ ገሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ብሮ ዎንታ ባካሊ ዶላናፐ ካሰቲደ፥ መꬍና ጎዳይ ታማነ ሻርያ ቱሳፐ ዱገ ዛሪደ፥ ግብጼቱዋ ኦላንቻቱዋ ጼሌዳ፤ ኡንቱንቱ ዎዛና ባይዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ላጋይ ኡንቱንታ ዋይሳና ማላ፥ መꬍና ጎዳይ ኡንቱንቱ ፓራ ጋረቱዋ ጎማ ቃꬁዋ ድግና ግብጼቱ፥ “መꬍና ጎዳይ ኡንቱንታ ማዲደ ግብጻ ኦልያ ድራዉ፥ አነ ኑን እስራኤልያ አሳፐ ባቃቶይተ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","መꬍና ጎዳይ ሙሳ፥ “ሃꬃይ ግብጼቱዋ ቦላ፥ ኡንቱንቱ ፓራ ጋረቱዋ ቦላነ ኡንቱንቱ ፓራ አሳቱዋ ቦላ ጉየ ጎጋና ማላ፥ ነ ኩሽያ አባ ቦላን ምጫ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ሙሴ ባረ ኩሽያ አባ ቦላን ምጬዳ፤ ሳአይ ዎንትሽን፥ አባይ ባረ ካሰ ሳኣ ጉየ ስሜዳ፤ ግብጼቱ ያ አ ግዶ ባቃትሽን፥ መꬍና ጎዳይ ግብጼቱዋ አባ ግዱዋን አꬅ የጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ሃꬃይ ጉየ ስሚደ፥ ፓራ ጋረቱዋ ፓራ አሳቱዋና እስራኤላቱዋ ካሊደ አባ ገሌዳ ካትያ ኦላንቻቱዋ ኡባ ምት ባሼዳ፤ ኡንቱንቱፐ እቱነ አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ሽን እስራኤለቱ አባ ግዱዋና መላ ቢታን ሀመቲደ፥ ሃꬃይ ኡንቱንቶ ኡሸቻናነ ሀድርሳና ጎዳዳን ኤቂና ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","መꬍና ጎዳይ ሄ ጋላስ እስራኤልያ አሳ ግብጼቱዋ ኩሽያፐ ሀዋዳን አሼዳ። ቃይ እስራኤለቱ ግብጼቱ ሀይቂደ ግሴዳዋንታ አባ ዶናን በኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","እስራኤላቱካ መꬍና ጎዳይ ግብጼቱዋ ቦላ በሴዳ ዎልቃማ ዎልቃ በኤዳ ዎደ፥ አሳይ መꬍና ጎዳዉ ያዪደ አካ አ ቆማ ሙሳካ አማኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ሄ ዎደ ሙሴነ እስራኤልያ አሳይ ሀ የꬃ መꬍና ጎዳዉ የጼድኖ፤ “ቦንቹዋን ሎይꬅ ꬎቁ ꬎቁ ጌዳ ድራዉ፥ ታን መꬍና ጎዳዉ ማዝሙርያ የጻና። ፓራነ ፓራ ጋርያነ ቶጌዳዋንታ አባን ኦሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","መꬍና ጎዳይ ታ ዎልቃነ ታ ማዝሙርያ፤ እ ታና አሽያዋ ግዴዳ። እ ታ ጾሳ፤ ታን አ ሳባና። እ ታ አዉዋ ጾሳ፤ ታን አ ꬎቁ ꬎቁ ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","መꬍና ጎዳይ ኤረቴዳ ኦላንቻ፤ አ ሱንꬃይካ መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ግብጼ ካትያ ፓራ ጋረቱዋነ አ ኦላንቻቱዋ አባን ኦሌዳ። ግብጼ ካትያ ካፓቱ፥ ኡባፐ አꬍ ሎእያዋንቱ ዞኦ አባን ሙከቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ጪሞ ሃꬃይ ኡንቱንታ ካሜዳ፤ ኡንቱንቱ ሹቻዳን ጪሙዋን ምተቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“አቤት መꬍና ጎዳዉ፥ ነ ኡሸቻ ኩሺ ዎልቃን ጎቤዳዋ፤ መꬍና ጎዳዉ፥ ነ ኡሸቻ ኩሺ ሞርክያ መንሬꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ነ ቦንቹዋ ግታተꬃን ኔናና ጋዳቴዳዋንታ ኦላዳ። ነ ኤጽያ ሀንቁዋ ኔን የድና፥ እ ኡንቱንታ ዳላዳን ሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ነ ሲꬍያና ከስያ ሸምፑዋን ሃꬃይ ዶረቴዳ። ጎግያ ሃꬃይካ ጎዳዳን ምን ኤቄዳ፤ ጪሞ ሃꬃይ አባ ጎምፓን እርኪደ ምኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“ሞርኪ፥ ‘ታን ኡንቱንታ የደርሳደ ኦይቃና። ታን ኡንቱንቱ ማጹዋ ሻካደ፥ ታ ኮዬዳዋ ኡባ አካና። ታን ታ ማሻ ሾዳደ፥ ኡንቱንታ ꬋይሳና’ ያጊደ ጬቀቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","“ሽን ነ ፔኑዋን ፑንና፥ አባይ ኡንቱንታ ካሜዳ። ኡንቱንቱ ዎልቃማ ሃꬃን ብራታይ ምተትያዋዳን ምተቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","አቤት መꬍና ጎዳዉ፥ ጾሳቱዋ ግዶን ነ ማላይ ኦኔ? ጌሻተꬃን ቦንቼትያዌ፥ ቦንቹዋን ያየትያዌ፥ ማላልያባ ኦꬅያዌ ነ ማላይ ኦኔ? ");
INSERT INTO dwrENT_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ኔን ነ ኡሸቻ ኩሽያ ምጭና፥ ቢታይ ኡንቱንታ ምቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“ኔን ዎዜዳ ነ አሳ አገና ነ ሲቁዋን ካለꬃዳ። ኔን ነ ዎልቃን ኡንቱንታ ኔን ደእያ ጌሻ ሳኣ ገልሳዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ካዉተꬃቱ ሄዋ ስሲደ ኮኮሬድኖ። ፕልስጼማ ጋድያ አሳቱካ የሉ ኦይቄዳዋዳን ኡንኤቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ሄ ዎደ ኤዶማ ጋደ ካፓቱ ዳጋሜድኖ። ሞኣበ ጋድያ ሞድያዋንታ ያሻይ ኮኮርሴዳ። ካናነ አሳቱዋ ሸኒ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","አቤት መꬍና ጎዳዉ ዳጋማይነ ያሻይ ኡንቱንታ ኦይቂና፥ ኡንቱንቱ ነ ዎልቃ ግታተꬃ በኢደ፥ ነ አሳይ አꬋና ጋካናዉ፥ ኔን ዎዜዳ አሳይ አꬋና ጋካናዉ፥ ሹቻዳን ሙሚደ ኤቂኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","አቤት መꬍና ጎዳዉ ኔን ኡንቱንታ አሃደ፥ ነ ቡዞ ጋደን ደእያ ደርያ ሁጲያን ቶከቴዳ ምꬃዳ ዎꬃ። ሄ ሳአይ ኔን ነዉ ደአናዉ ኦꬄዳ ሳኣ፥ ሄ ጌሻ ሳአይ ኔን ነ ኩሽያን ምንሳደ ኤሴዳ ሳኣ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","መꬍና ጎዳይ መꬍናፐ መꬍናዉ ካዉታናዋ።” ");
INSERT INTO dwrENT_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ግብጼ ካትያ ፓራቱ፥ አ ፓራ ጋረቱነ አ ፓራ አሳቱ አባን ገሌዳ ዎደ፥ መꬍና ጎዳይ ኡንቱንቱ ቦላ አባ ሃꬃ ጉየ ዛሪደ ኡንቱንቱ ቦላ አሄዳ፤ ሽን እስራኤላቱ አባ ግዱዋና መላ ቢታን ሀመቲደ ቤድኖ ያግ የጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","አሮና ምቻታ፥ ናባታ ማይራማ ዳርቢያ አካዱ፤ ማጫ አሳይ ኡባይ ዳርቢያ ባቂደነ የጺደ እዞ ካሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ማይራማ ኡንቱንቶ የꬃ የጻደ፥ “መꬍና ጎዳይ ሎይꬅ ꬎቁ ꬎቁ ጌዳ ድራዉ፥ አዉ የጽተ። ፓራነ ፓራ ቶጌዳዋ እ አባን ኦሌዳ” ያጋደ የጻዱ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ሄዋፐ ጉይያን ሙሴ እስራኤልያ ዞኦ አባፐ ካለꬅና፥ ኡንቱንቱ ሱር ጌተትያ መላ ቢታ ቤድኖ። ሄ መላ ቢታን ኡንቱንቱ ሃꬃ ደመናን ሄዙ ጋላሳ ሀመቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ኡንቱንቱ ማራ ግያ ሳኣ ጋኬዳ ዎደ፥ ማራ ሃꬃይ ጫሞ ግዴዳ ድራዉ፥ ኡሻናዉ ዳንዳይበይክኖ፤ ሄዋ ድራዉ፥ ሄ ሳአይ ማራ ጌተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ሄዋ ድራዉ፥ አሳይ፥ “ኑን አያ ኡሻኔ?” ያጊደ ሙሴ ቦላ ዙዙሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ሙሴ መꬍና ጎዳዉ ዋሴዳ፤ መꬍና ጎዳይ አ እት ምꬃ በሴዳ፤ ሙሴ ሄ ምꬃ ሃꬃ ግዶ ኦልና፥ ሃꬃይ ማልኤዳ። መꬍና ጎዳይ ኡንቱንቶ ካለሰትያ ዎጋ እሜዳ፤ ያን ጾሳይ ኡንቱንታ ፓጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","እ ኡንቱንታ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳይ ህንተንቱ ጾሳይ ኦድያዋ ምንሲደ ስሶፐነ አ አይፍያ ስንꬃን ልከባ ኦꬆፐ፥ ህንተንቱ አ አዛዙዋ ሀይዞፐነ አ ዎጋ ኡባ ናጎፐ፥ ታን ግብጼቱዋ ቦላ አሄዳ ሀርግያፐ እቱዋነ ህንተንቱ ቦላ አህከ፤ አያዉ ጎፐ፥ ታን ህንተንታ ፓꬅያ መꬍና ጎዳቴ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ሄዋፐ ኡንቱንቱ ኤላማ ጋድያ ዬድኖ፤ ያን ታማነ ላኡ ሃꬃ ፑልቶቱነ ላፑን ታሙ ዛምባ ምꬃቱ ደኢኖ። ኡንቱንቱ ያን ሃꬃ ዶናን ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ግብጼፐ ከሴዳ ላኤንꬆ አግናን፥ ታማነ እቼሻንꬆ ጋላሳን እስራኤልያ አሳ ኩመንꬃይ ኤሊማፐ ደንዲደ፥ ኤሊማፐነ ሲናፐ ግዱዋን ደእያ “ሲን” ጌተትያ መላ ቢታ ዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","እስራኤልያ አሳ ኡባይ መላ ቢታን ሙሴ ቦላነ አሮና ቦላ ዙዙሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","እስራኤላቱ ኡንቱንታ፥ “ኑን ግብጼ ጋድያን መꬍና ጎዳ ኩሽያን ሀይቄዶ ግዴሮኮሻ! ያን ኑን ኑዋ አሹዋ ከርያ ዩይ አꬍ ኡቲደ፥ ኑን ኮዮ ቁማ ኡባ ሜዶ፤ ሽን ህንተንቱ ኑና ከሲደ፥ ኡባቱዋ ኮሻን ዎꬋናዉ መላ ቢታ አሄድቴ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","መꬍና ጎዳይ ሙሳ፥ “ታን ህንተንቶ ሳሉዋፐ ኡክꬃ ቡክሳና፤ አሳይ ኡባ ጋላስካ ከሲደ፥ ሀቼ ሀቼዉ ግድያዋ ጻላላ ማጻናዉ ኮሼ። አሳይ ታ አዛዙዋ ካልንቶ ካለነንቶ ታን ኡንቱንታ ሄዋን ፓጫና። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ኡሱፑንꬃ ጋላስ ኡንቱንቱ ሀሮደ ማጽያዎ ላኡ ኩሽያ ማጺደ፥ ካꬂኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ሄዋ ድራዉ፥ ሙሴነ አሮነ እስራኤልያ አሳ ኡባዉ፥ “ህንተና ግብጼ ጋድያፐ ከሴዳ መꬍና ጎዳ ግድያዋ ኦማርስ ህንተንቱ ኤራና፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ቃይ መꬍና ጎዳ ቦንቹዋ ዎንታ ህንተንቱ በአና፤ አያዉ ጎፐ፥ አ ቦላ ህንተንቱ ዙዙሜዳዋ እ ስሴዳ፤ ህንተንቱ ኑ ቦላ ዙዙማናዉ ኑን ኦኔ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ሄዋፐ ጉይያን ሙሴ፥ “እ ህንተንቶ ማናዉ ኦማርስ አሹዋ እሚናነ ህንተንቱ ኮይያ ኡክꬃ ኡባ ህንተንቶ ዎንታ እምና፥ እ መꬍና ጎዳ ግድያዋ ህንተንቱ ሄዋን ኤራና። አያዉ ጎፐ፥ ህንተንቱ አ ቦላ ዙዙሜዳዋ እ ስሴዳ። ኑን ኦኔ? ህንተንቱ ኑ ቦላ ዙዙምክታ፤ ህንተንቱ መꬍና ጎዳ ቦላ ዙዙሚታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ሙሴ አሮና፥ “ኔን እስራኤልያ አሳ ኡባ፥ ‘መꬍና ጎዳይ ህንተንቱ ዙዙንꬃ ስሴዳ ድራዉ፥ መꬍና ጎዳ ስንꬃ ሃ ሺቅተ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","አሮነ እስራኤልያ አሳ ኡባዉ ኦድያ ዎደ፥ ኡንቱንቱ መላ ቢታኮ ስሚደ ጼሌድኖ፤ ሄዋን መꬍና ጎዳ ቦንቹ ሻርያ ግዶን ቆንጭያዋ በኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","መꬍና ጎዳይ ሙሳ፥ “ታን እስራኤላቱ ዙዙንꬃ ስሳድ፤ ኔን ኡንቱንቶ፥ ‘ኦማርሳን አሹዋ ህንተንቱ ማና፤ ዎንታ ኡክꬃ ህንተንቱ ካላና፤ ሄ ዎደ ህንተንቱ ታን መꬍና ጎዳ ህንተንቱ ጾሳ ግድያዋ ኤራና’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ሄ ጋላስ ኦማርሳን አሹ ሜተትያ ካፎቱ ዪደ፥ እስራኤልያ አሳይ ደእያ ሳኣ ማዬድኖ፤ ቃይ ዎንታ ኡንቱንቱ ዱንካነቱዋ ዩሹዋን ከተርሳይ ኩም ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ከተርሳይ ጽኤዳ ዎደ፥ ሳኣን ዎꬌዳ ሻቻ ማላትያ ሱፓ ፖቁ መላ ቢታ ቦላን ቤቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","እስራኤለቱ ሄዋ በኤዳ ዎደ፥ ኡንቱንቱ እቱ እቱዋ፥ “ሀዌ አዬ?” ያጌድኖ። አያዉ ጎፐ፥ ኡንቱንቱ እ አየንቶ ኤርበይክኖ። ያትና ሙሴ ኡንቱንታ፥ “ህንተንቶ ማናዉ መꬍና ጎዳይ እሜዳ ኡክꬃይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","መꬍና ጎዳይ ሀዋዳን ያጊደ አዛዜዳ፤ ‘ጎለ አሳዉ አዎትያዌ፥ እቶ እቶ ማናዉ ኮሽያዋ ኬሻ ሺሾ፤ ህንተንቱ ዱንካንያ ግዶን ደእያ አሳይ ሁጲያን ሁጲያን ላኡ ጻሳ ግድያዋ አክተ’ ጌዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","እስራኤላቱ ሙሴ ኡንቱንቶ ኦዴዳዋዳን ኦꬄድኖ፤ እቱ ዳርሲደ፥ እቱ ላፈꬂደ ሺሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ኡንቱንቱ ጻሳን ማኬዳ ዎደ፥ ዳርሲደ ሺሼዳዎ ፓላህቤና፤ ላፋ ሺሼዳዎ ፓጭቤና፤ ኡባይካ ሁጲያን ሁጲያን ባረዉ ምያዋ ኬሻ ሺሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ሄዋፐ ጉይያን ሙሴ ኡንቱንታ፥ “ኦንነ አፐ ዎንትዉ አሾፖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ግዶ ሽን ኡንቱንቱፐ እቱ እቱ ሙሴ ኦድያዋ አከናን አጊደ፥ ሄዋ ዎንታ ጋካናዉ ዎꬄድኖ፤ ሄዌ ጉጹኒደ ጽንቄዳ። ሄዋ ድራዉ፥ ሙሴ ኡንቱንታ ሀንቀቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ዎንታ ዎንታ አሳይ ኡባይ ባረዉ ኮሽያዋ ሺሼዳ፤ አዋይ ሆእያ ዎደ ሳኣን አቴዳዌ ሲል አጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ኡሱፑንꬃ ጋላሳን ኡንቱንቱ ካሰዋፐ ላኡ ኩሽያ ሺሼድኖ። ያትና ኡንቱንቱ ካፓቱ ኡባቱ ዪደ ሄዋ ሙሴዉ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","እ ኡንቱንታ፥ “መꬍና ጎዳይ አዛዜዳዌ ሀዋ፤ ዎንት ኪታይ ባይና ሸምፖ ጋላሳ፥ መꬍና ጎዳዉ ጌሻ ሳምባታ። ሄዋ ድራዉ፥ ህንተንቱ ኡክያዋ ኡክተ፤ ህንተንቱ ዶይስያዋነ ዶይስተ፤ ፓላሄዳዋ ዎንትዉ አሽተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ሄዋ ድራዉ፥ ኡንቱንቱ ሙሴ አዛዜዳዋዳን ዎንትዉ ዎꬅና ጽንቂቤና ዎይ ጉጹንቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","“ሀቼ ሚተ፤ አያዉ ጎፐ፥ ሀቼ መꬍና ጎዳ ሳምባታ፤ ህንተንቱ አ ሀቼ ደምባን ደምክታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ህንተንቱ ኡሱፑን ጋላሳን አ ሺሻናዉ ዳንዳዪታ፤ ሽን ላፑንꬃ ጋላሳይ ሳምባታ። ሳምባታን አያይነ ደኤና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ላፑንꬃ ጋላሳን እት እት አሳይ ሺሻናዉ ከሴዳ፤ ሽን ኡንቱንቱ አይነ ደምበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","መꬍና ጎዳይ ሙሳ፥ “ታ አዛዛቱዋነ ታ ህግያ ናግያዋ አዉደ ጋካናዉ እጺቴ? ");
INSERT INTO dwrENT_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","መꬍና ጎዳይ ህንተንቶ ሳምባታ እሜዳዋ አኬክተ፤ ኡሱፑንꬃ ጋላሳን እ ህንተንቶ ላኡ ጋላሳ ኡክꬃ እምያዌ ሄዋ ድራሳ። ላፑንꬃ ጋላስ ኡባይ ባረ ደእያ ሳኣን ደእያ ሳኣን ጋምኦ፤ ኦንነ ካረ ከሶፖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ሄዋ ድራዉ፥ አሳይ ላፑንꬃ ጋላሳን ሸምፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","እስራኤልያ አሳይ ሄ ኡክꬃ ማና ጊደ ሱንꬄዳ። ማናይ ዴቡዋ አይፍያዳን ቦꬃ፤ ኤሳና ኡኬዳ ኡክꬃዳን ማልኤ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ሙሴ እስራኤልያ አሳ፥ “መꬍና ጎዳይ አዛዜዳዌ ሀዋ፤ ‘ታን ህንተንታ ግብጼ ጋድያፐ ከሴዳ ዎደ፥ ዎራን ምዜዳ ኡክꬃ ኡንቱንቱ በአና ማላ፥ ማናፐ ላኡ ጻሳ ግድያዋ ህንተንቱ ያና የለታዉ አሽ ዎꬅተ’ ያጊደ አዛዜዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ሙሴ አሮና፥ “እት ጻሩዋ አካደ ላኡ ሊትሮ ኩመንꬃ ማና አን ቆላ፤ ያታደ ያና የለታዉ ምንጀታና ማላ፥ መꬍና ጎዳ ስንꬃን ዎꬃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ምንጀታና ማላ፥ አሮነ ማና ጾሳ ስንꬃን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","እስራኤላቱ ባረንቱ ደእያ ጋደ ያና ጋካናዉ ኦይታሙ ላይꬃ ማና ሜድኖ፤ ኡንቱንቱ ካናነ ጋደ ባጋ ጋካናዉ ማና ሚደ ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","አሳይ ማክያ ኤረቴዳ ቁንአይ ላኡ ጻሳፐ ታሙ ዳኩዋ ዳሬ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","እስራኤለቱዋ ማባራ ኡባይ መꬍና ጎዳይ አዛዜዳዋዳን፥ እት ሳኣፐ ሀራ ሳኣ ዩዪደ፥ ሲን መላ ቢታፐ ደንድ ቢደ፥ ራፍዲማ ጌተትያ ሳኣን ኡቴድኖ። ሽን አሳይ ኡሻናዉ ሃꬃይ ሄ ሳኣን ꬋዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ኡንቱንቱ ሙሴና ዋላቀቲደ አ፥ “ኑዉ ኡሻናዉ ሃꬃ እማ” ያጌድኖ። ሙሴ ዛሪደ፥ “ህንተንቱ ታናና አያዉ ዋላቀቲቴ? መꬍና ጎዳ ህንተንቱ አያዉ ፓጪቴ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ሽን አሳይ ያን ሃꬃ ሳመቲደ፥ ሙሴ ቦላ ዙዙሜድኖ። ኡንቱንቱ አ፥ “ኔን ኑና፥ ኑ ናናነ ኑ መህያ ሳሙዋን ዎꬋናዉ ግብጼፐ ከሳደ ፑደ አያዉ አሃድ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ሙሴ፥ “ታን ሀ አሳ ዋቶ? ኡንቱንቱ ታና ሹቻን ጫዳና ሀኒኖ” ያጊደ መꬍና ጎዳኮ ዋሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","መꬍና ጎዳይ ሙሳ፥ “ኔን አሳፐ ስንꬃዉ ሀመታ፤ እስራኤልያ አሳ ጭማቱዋፐ ኔናና አፋ፤ እን ኔን ናይለ ሻፋ ሃꬃ ሾጬዳ ጻምኣ ነ ኩሽያን ኦይቃደ ባ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ታን ሲና ደርያ ዛላ ቦላ ነ ስንꬃን ኤቃና፤ ኔን ሄ ዛላ ሾጫ፤ አሳይ ኡሻናዉ አፐ ሃꬃይ ከሳናዋ” ያጌዳ። ሙሴ እስራኤልያ ጭማቱዋ ስንꬃን ሄዋዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","እስራኤላቱ፥ “መꬍና ጎዳይ ኑ ግዶን ደኢየ ባዌ?” ያጊደ ዋላቀቴዳ ድራዉነ መꬍና ጎዳ ፓጬዳ ድራዉ፥ ሄ ሳአይ ማሳሀነ ማሪባ ጌተቲደ ሱንቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","አማሌቃቱ ዪደ፥ ራፊድማን እስራኤላቱዋና ኦላ ጋከቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ሙሴ ኢያሳ፥ “ኔን ኑዉ አሳ ዶራደ፥ ከሳደ አማሌቃቱዋና ኦለታ፤ ታን ዎንት ጾሳ ጻምኣ ኦይቃደ፥ ዞዝያ ሁጲያን ኤቃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ሄዋፐ ጉየ ኢያሱ ሙሴ ጌዳዋዳን፥ አማሌቃቱዋና ኦለቴዳ። ሙሴ፥ አሮነነ ሁር ዞዝያ ሁጲያ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ሙሴ ባረ ኩሽያ ደንꬅ ጋምኤዳ ኬናን ኡባን እስራኤላቱ ጾኒኖ፤ ሽን እ ባረ ኩሽያ ዱገ ዎꬄዳ ዎደ አማሌቃቱ ጾኒኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ሙሴ ኩሺ አርጋጬዳ ዎደ፥ ኡንቱንቱ ሹቻ አክ ዪደ፥ ሙሳ አ ቦላ ኡትሴድኖ። አሮነነ ሁር እቱ እት ባጋና እቱ ህንኮ ባጋና ግዲደ፥ አ ኩሽያ ስት ኦꬂደ ኦይቄድኖ። ያትና አዋይ ዉላና ጋካናዉ አ ኩሺ ስት ጊደ ታኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ሄዋ ድራዉ፥ ኢያሱ አማሌቃቱዋ ኦላንቻቱዋ ማሻን ጾኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ሄዋፐ ስምና፥ ሙሳ መꬍና ጎዳይ ሀዋዳን ያጌዳ፤ “ሀዌ ኡባ ገደ ቆፈታና ማላ ሀዋ ማጻፋን ጻፋ። ያታደ ኢያሳ ስሰናን አጎፓ፤ አያዉ ጎፐ፥ ሳሉዋፐ ጋርሳን ታን አማሌቃ አሳቱዋ ዛር ቆፈተናዳን ጭራና ꬋይሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ሙሴ ያርሹዋ ያርሽያ ሳኣ ኬጺደ፥ “መꬍና ጎዳይ ታዉ ጾኑዋ እሜ” ጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","እ ሀዋዳን ያጌዳ፤ “ኩሸቱ ፑደ መꬍና ጎዳ ካዉተꬃ አራታኮ ደንዴድኖ፤ የለታፐ የለታ ጋካናዉካ መꬍና ጎዳይ አማሌቃቱዋና ኦለታናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ሚድያማ ጋደ ቄሲ፥ ሙሴ ቦሉ ዮቶረ፥ ጾሳይ ሙሴዉነ አ አሳ እስራኤልያዉ ኦꬄዳባ ኡባነ መꬍና ጎዳይ እስራኤልያ ግብጼፐ ከሴዳዋ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","ሄ ዎደ ሙሴ ቦሉ፥ ዮቶረ፥ ሙሴ አኮ የዲደ ቤዳ አ ማቻቶ ጽፓሮነ እዝ ላኡ ናና አሄዳ። ኡንቱንቱፐ እቱዋ ሱንꬃይ ገርሾማ፤ አያዉ ጎፐ፥ ሙሴ፥ “ታን አሳ ጋድያን በተ ግዳድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ላኤንꬁዋ ሱንꬃይ ኤልኣዛራ፤ አያዉ ጎፐ፥ እ፥ “ታ አዉዋ ጾሳይ ታና ማዴዳዋ፤ እ ታና ግብጼ ካትያ ማሻፐ አሼዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ሙሴ ቦሉ ዮቶረ አ አቱማ ናናነ አ ማቻትና ጾሳ ደርያ ማታን ደእያ ሙሴኮ መላ ቢታ ዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","እ ሙሳ፥ “ታን፥ ነ ቦሉ ዮቶረ፥ ነ ማቻትናነ እዝ ላኡ ናናቱዋና ኔኮ ያይ” ያጊደ አኮ ኪት ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ሄዋ ድራዉ፥ ሙሴ ባረ ቦሉዋና ጋከታናዉ ከሲደ፥ አዉ ጎይኔዳ፥ አ የሬዳ። ኡንቱንቱ እቱ እቱዋ ሳሮꬂደ፥ ዱንካንያ ግዶ ገሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","መꬍና ጎዳይ እስራኤልያ አሳ ድራዉ፥ ካትያ ቦላነ ግብጼቱዋ ቦላ ኦꬄዳ ኡባ፥ ኦግያን ኡንቱንታ ጋኬዳ ዳቡራባ ኡባነ መꬍና ጎዳይ ኡንቱንታ አሼዳዋ ሙሴ ባረ ቦሎ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","እስራኤልያ አሳ ግብጼቱዋ ኩሽያፐ አሻናዉ መꬍና ጎዳይ ኦꬄዳ ሎኦ ኦሶቱዋባ ኡባ ስሲደ፥ ዮቶረ ናሸቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ያቲደ “ህንተና ግብጼቱዋ ኩሽያፐነ ካትያ ኩሽያፐ አሼዳ መꬍና ጎዳይ፥ ግብጼቱዋ ኩሽያፐ አሳ ከስ አኬዳዌ፥ እ ጋላተቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","መꬍና ጎዳይ ሀራ ጾሳቱዋፐ ኡባፐ ዎልቃማ ግድያዋ ታን ሀእ ኤራድ፤ አያዉ ጎፐ፥ እ ሀ እስራኤልያ አሳ ቦላ ኦተረቴዳ ግብጼ ጾሳቱዋ ቦላ ሀዋ ኦꬄዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ሄዋፐ ጉይያን ዮቶረ፥ ሙሴ ቦሉ፥ ሹከቲደ ፖሎ ጹገትያ እት መህያ ያርሹዋነ ሀራ ያርሾ ሹከቴዳ አሹ ሜተትያ መህያ ያርሹዋ ጾሳዉ አሄዳ፤ አሮነነ እስራኤልያ ጭማቱ ኡባይ ጾሳ ስንꬃን ሙሴ ቦሉዋና ቁማ ማናዉ ዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ዎንተꬃ ጋላስ ሙሴ አሳዉ ፕርዳናዉ ኡቴዳ፤ አሳይ ሙሴ ዩሹዋን ዎንታፐ ኦማርስ ጋካናዉ ኤቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ሙሴ ቦሉ ሙሴ አሳዉ ኦꬅያዋ ኡባ በኢደ፥ “ኔን ሀ አሳዉ ኦꬅያዌ ሀዌ አዬ? አሳይ ኡባይ ዎንታፐ ዶሚደ ኦማርስ ጋካናዉ ነ ዩሹዋን ኤቂደእሽን፥ ኔን ኔረካ ዳናዳን አያዉ ኡታድ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ሙሴ ባረ ቦሉዋ፥ “አሳይ ጾሳ ሸንያ ኦቻናዉ ታኮ ይያ ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ኡንቱንቶ የዉ ደኦፐ ታኮ ዪኖ፤ ታን እት ኡራ ግዱዋንነ አ ሾሩዋ ግዱዋን ፕርዳይ፤ ጾሳ አዛዙዋነ ዎጋ ኡንቱንታ ኤርሳይ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ሙሴ ቦሉ፥ “ሀዌ ኔን ኦꬅያባይ ሎኤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ኔንነ ኔናና ደእያ አሳይ ዳቡራ ጻላላ ግዲታ፤ ሀ ኪታይ ነዉ ሎይꬅ ዴጾ፤ ኔን ሀዋ ኔረካ ኦꬃናዉ ዳንዳያካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","አነ ሀእ ታን ኦድያዋ ስሳ፤ ታን ኔና ዞራና፤ ጾሳይ ኔናና ግዶ። ኔን ሀ አሳ ድራዉ ጾሳ ስንꬃ አꬋ፤ ኔን ኡንቱንቱ የዉዋ ጾሳኮ አሀ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","አዛዙዋነ ዎጋ ኡንቱንታ ኔን ታማርሳ፤ ኡንቱንቱ ደአና ማራነ ኦꬃና ኦሱዋ ኡባ ኡንቱንታ በሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ቃይ አሳ ኡባ ግዶን ዳንዳይያ አሳቱዋ፥ ጾሳዉ ያይያዋንታ፥ አማነቴዳዋንታነ ማጋንጻ ምያዋ እጽያዋንታ ዶራደ ኡንቱንቱፐ አሳዉ ሻኣ ካፓቱዋ፥ ጼቱዋ ካፓቱዋ፥ እሻታሙዋ ካፓቱዋነ ታሙዋ ካፓቱዋ ሱንꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ኡንቱንቱ ኡባ ዎደ አሳዉ ፕርድኖ፤ ሽን ዋይስያ የዉዋ ኡባ ኔኮ አህኖ፤ ዋይሰና የዉዋ ኡባ ኡንቱንቱ ዉርስኖ። ኡንቱንቱ ኔናና ሻከትያ ድራዉ፥ ቶኩ ነዉ ካዉሻናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ኔን ሄዋዳን ኦꬆፐነ ሀዌ ጾሳ አዛዞ ግዶፐ፥ ኔን ዳንዳያና። ቃይ ሀ አሳይ ኡባይካ ባረ አላሊ ፖለትና፥ ባረ ሶ ባረ ሶ ባናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ሙሴ ባረ ቦሉዋ ቃላ ስሴዳ፤ እ ጌዳዋ ኡባካ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ሙሴ እስራኤልያ ኡባ ግዶፐ ዳንዳይያ አሳቱዋ ዶሪደ አሳ ካለꬅያ ሻኣ ካፓቱዋ፥ ጼቱዋ ካፓቱዋ፥ እሻታሙዋ ካፓቱዋነ ታሙዋ ካፓቱዋ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ኡንቱንቱ አሳዉ ኡባ ዎደ ፕርዴድኖ፤ ኡንቱንቱ ባረና ዴጼዳ የዉዋ ሙሴኮ አሄድኖ፤ ሽን ዴጸና የዉዋ ኡባ ኡንቱንቱ ዉርሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ሄዋፐ ጉይያን ሙሴ ባረ ቦሉዋ ሞይዝና ዮቶረ ባረ ጋድያ ስሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","እስራኤልያ አሳይ ግብጼፐ ከሴዳ ሄዘንꬃ አግናን ሄ ኮይሮ ጋላሳን ሲና መላ ቢታ ጋኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ኡንቱንቱ ራፊድመፐ ደንዲደ ሲና መላ ቢታ ቢደ፥ ሄዋን ደእያ ደርያ ስንꬃ መላ ቢታን ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ሙሴ ጾሳኮ ፑደ ደርያ ሁጲያ ከስና፥ መꬍና ጎዳይ ደርያ ሁጲያን አ ጼሲደ፥ “ኔን ያቆባፐ የለቴዳ እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘ታን ግብጼቱዋ ቦላ አያ ኦꬃድታንቶነ ቃይ አርጋንꬃ ቀፍያን ታን ህንተንታ ዋታ ቶካደ ታኮ አሃድታንቶነ ህንተንቱ ህንተንቱ ሁጲያዉ በኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ስም ሀእ ህንተንቱ ታዉ ሎይꬅ አዛዘቶፐነ ታ ቃላ ጫቁዋ ናጎፐ፥ አሳ ኡባ ግዶን ህንተንቱ ታዉ ቡዞ ግዳና። ኩመንꬃ ሳአይ ታዋ ግዶፐነ ");
INSERT INTO dwrENT_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ህንተንቱ ታ ካዉተꬃ ቄሳቱዋነ ጌሻ አሳ ግዳና’ ያጋ፤ ኔን እስራኤላቶ ኦዳና ቃላይ ሀዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ሙሴ ጉየ ስም ቢደ፥ አሳ ካለꬅያዋንታ ጼስ ሺሺደ፥ መꬍና ጎዳይ ኦዳ ጌዳ ሀ ቃላቱዋ ኡባ ኡንቱንቶ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","አሳይ ኡባይ እት ዶና ግዲደ፥ “መꬍና ጎዳይ ጌዳዋ ኡባ ኑን ኦꬃና” ያጌድኖ። ሙሴካ ኡንቱንቱ ጌዳዋ መꬍና ጎዳኮ አፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","መꬍና ጎዳይ ሙሳ፥ “ታን ኔናና ሃሳይሽን አሳይ ስሳናዳንነ ኡንቱንቱ ኔናን ኡባ ዎደካ አማነታናዳን፥ ታን ኔኮ ዎልቃማ ሻርያ ግዱዋና ያና” ያጌዳ። ሄዋፐ ጉይያን ሙሴ አሳይ ጌዳዋ መꬍና ጎዳዉ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","መꬍና ጎዳይ ሙሳ፥ “ኔን አሳኮ ባደ ሀቼነ ዎንት ኡንቱንቱ ጌያናዳን ኦዳ። ኡንቱንቱ ባረንቱ ማዩዋ ሜጪደ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ሄዘንꬆ ጋላሳዉ ጊግኖ። አያዉ ጎፐ፥ ሄዘንꬆ ጋላሳን አሳይ ኡባይ በእሽን፥ መꬍና ጎዳይ ሲና ደርያ ቦላን ዎꬋናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ኔን ሀ ደርያ ዩሹዋን አሳዉ ዛዋ ዎꬃደ ኡንቱንቶ፥ ‘ደርያ ፑደ ከሰናዳን ዎይ ደርያ ጻጱዋ ቦቼናዳን ህንተንታ ኤርተ። ደርያ ቦቼዳ ኦንነ ቱሙፐ ሀይቃናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ሄ ኡራይ ሹቻን ጫደቲደ ዎይ ዎንዳፍያን ጫደቲደ ሀይቆፐ አትን፤ እ ኩሽያን ቦሸቶፖ። መሄ፥ ዎይ አሳ ግዶፐነ እ ሸምፑዋና አተና’ ያጋ። ማላካታይ ፑነትያ ዎደ፥ ሄ ዎደ ኡንቱንቱ ደርያ ፑደ ከሳና ጎፐ ከስኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ሙሴ ደርያፐ አሳኮ ዱገ ዎꬌዳዋፐ ጉይያን ኡንቱንታ ጌያናዳን ኦድና፥ ኡንቱንቱ ባረንቱ ማዩዋ ሜጬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ሄዋፐ ጉይያን አሳ እ፥ “ሄዘንꬆ ጋላሳዉ ጊግተ፤ ማችያና አቆፕተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ሄዘንꬆ ጋላስ ዎንታ ጉጉንꬃ ጉንꬃይ ስሰቴዳ። ዋልቃንꬃይነ ዎልቃማ ሻሪ ደርያ ማዪደ ቤቴዳ፤ ማላካታይካ ፑነትያ ዎልቃማ ኮሻይ ስሰቴዳ። ሄዋ ድራዉ፥ ባረ ደእያ ሳኣን አሳይ ኡባይ ኮኮሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ሄዋፐ ጉይያን ሙሴ አሳ ጾሳና ጋꬃናዉ ኡንቱንቱ ደእያ ዱንካንያፐ ከሴዳ፤ ኡንቱንቱ ደርያ ጋርሳ ደምባን ኤቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","መꬍና ጎዳይ ሲና ደርያ ቦላን ታማና ዎꬌዳ ድራዉ፥ ሲና ደሪ ጩዋን ካመቴዳ። ዎልቃማ ጉዱዋፐ ጩዋይ ከስያዋዳን፥ አፐ ጩዋይ ፑደ ከሴዳ። አሳይ ኡባይ ሎይꬅ ኮኮሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ማላካታ ፑኑ ሎይꬅ ዳር ዳር ቤዳ ዎደ፥ ሙሴ ሃሳይና፥ ጾሳ ኮሻይ አዉ ዛሪደ ሃሳዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","መꬍና ጎዳይ ሲና ደርያ ኪክያን ዎꬊደ፥ ሙሳ ፑደ ደርያዉ ኪክያ ጼስና ሙሴ ፑደ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","መꬍና ጎዳይ አ፥ “ኔን ዱገ ባደ አሳይ መꬍና ጎዳ በአና ጊደ፥ ዛዋ አናዳንነ ኡንቱንቱፐ ዳሩ ሀይቀናዳን አሳ ሴራ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ሀራይ አቶ መꬍና ጎዳ ማታ ሺቅያ ቄሳቱካ ባረና ጌሻናዉ ኮሼ፤ ሄዌ ꬋዮፐ፥ መꬍና ጎዳይ ኡንቱንታ ሙራና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ሙሴ መꬍና ጎዳ፥ “አሳይ ደርያ ፑደ ያናዉ ዳንዳየና፤ አያዉ ጎፐ፥ ኔን ነ ሁጲያዉ፥ ‘ሀ ሳኣ ጌሻዳን ዱማዪደ፥ ሀ ደርያ ዩሹዋን ዛዋ ዎꬅተ’ ጋደ ኑዉ ኦዳ ዎꬃዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","መꬍና ጎዳይ አ፥ “ኔን ዱገ ባደ አሮና ኔናና ፑደ አካደ ያ። ቄሳቱዋነ አሳ መꬍና ጎዳይ ሙረናዳን፥ ኡንቱንቱ ዛዋ አꬊደ ፑደ መꬍና ጎዳኮ ዮፕኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ሄዋ ድራዉ፥ ሙሴ ዱገ አሳኮ ዎꬊደ፥ ጾሳይ ጌዳዋ ኡንቱንቶ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ጾሳይ ሀ ቃላቱዋ ኡባ ሀዋዳን ያጊደ ሃሳዬዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ኔና ግብጼፐ አይለተꬃ ጋድያፐ ከሴዳ መꬍና ጎዳይ ነ ጾሳይ ታና። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“ታፐ አትና፥ ሀራ ጾሳዉ ጎይኖፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“ቦላ ሳሉዋን ደእያ፥ ዎይ ጋርሳ ሳኣን ደእያ፥ ዎይ ሳኣፐ ጋርሳን ሃꬃ ግዶን ደእያ አያነ ማላትሳደ ነዉ ጎይንያ ምስለቱዋ ኦꬆፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ኡንቱንቶ ሆኮፓ ዎይ ኡንቱንቶ ጎይኖፓ። አያዉ ጎፐ፥ ታን፥ መꬍና ጎዳይ ነ ጾሳይ ቃናታንቻ ጾሳ፤ ታና እጽያዋንታ አዎቱዋ ናጋራ ድራዉ፥ ናና ሄዘንꬆ የለታነ ኦይደንꬆ የለታ ጋካናዉ ሙርያዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ቃይ ታና ሲቅያነ ታ አዛዙዋ ናግያዋንቶ ሻአ የለታይ ጋካናዉ ላመተና ሲቁዋ በስያ መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“መꬍና ጎዳ ነ ጾሳ ሱንꬃ ጮ ደንꬆፓ፤ አያዉ ጎፐ፥ ጾሳይ ባረ ሱንꬃ ጮ ደንꬅያዋ ሙራና። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“ጌሻ ኦꬃደ፥ ሳምባታ ጋላሳ ናጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ኔን ኦꬅያ ኦሱዋ ኡባ ኡሱፑን ጋላሳቱዋን ኦꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ሽን ላፑንꬃ ጋላሳይ መꬍና ጎዳ ነ ጾሳዉ ሳምባታ። ሄ ጋላስ አይ ኦሱዋነ ኦꬆፓ፤ ኔን፥ ዎይ ነ አቱማ ናአይ፥ ዎይ ነ ማጫ ናና፥ ዎይ ነ ማጫነ አቱማ ቆማቱ፥ ዎይ ነ ሚዛይ፥ ዎይ ህንተንቱና ደእያ እስራኤልያ ግደና አሳይ ሄ ጋላሳን አይ ኪታካ ኪተቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","አያዉ ጎፐ፥ ኡሱፑን ጋላሳ ግዶን መꬍና ጎዳይ ሳሉዋነ፥ ሳኣ፥ አባነ ኡንቱንቱ ግዶን ደእያ ኡባ መꬌዳ፤ ሽን ላፑንꬃ ጋላሳን ሸምፔዳ። ሄዋ ድራዉ፥ መꬍና ጎዳይ ሳምባታ ጋላሳ አንጄዳነ ጌሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“መꬍና ጎዳይ ነ ጾሳይ ነዉ እምያ ቢታን ነ ላይꬃይ አዱቃና ማላ፥ ነ አባነ ነ ዳዮ ቦንቻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“አሳ ዎꬎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“ዎሹሞፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“ዉኦፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“ነ ሾሩዋ ቦላን ዎርዱዋ ማርካቶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ነ ሾሩዋ ጎልያ አሞቶፓ፤ ነ ሾሩዋ ማቻቶ፥ ዎይ አ ቆማ፥ ዎይ አ ቆማቶ፥ ዎይ አ ቦራ፥ ዎይ አ ሀርያ፥ ዎይ አዉ ደእያዋ አያነ አሞቶፓ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","አሳይ ኡባይ ጉጉንꬃይ ጉጉምያዋነ ዋልቃንꬃይ ዎልቃምያዋ በኤዳ፤ ማላካታ ዋሱዋ ስሴዳ፤ ቃይ ደሪ ጩዋትያዋካ በኤዳ፤ አሳይ ያሻን ኮኮሪደ፥ ሃኩዋን ኤቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ኡንቱንቱ ሙሳ፥ “ኔን ኑዉ ሃሳያ፤ ኑን ስሳና፤ ሽን ኑን ሀይቀናዳን፥ ጾሳይ ኑዉ ሃሳዮፖ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ሙሴ አሳ፥ “ጾሳይ ህንተንታ ፓጫናዉ፥ ናጋራ ህንተንቱ ኦና ማላ፥ አ ያሻይ ህንተንቱ ዎዛናን ደአናዳን፥ እ ዬዳ ድራዉ ያዮፕተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","አሳይ ሃክ ኤቂደእሽን፥ ጾሳይ ደእያ ሳኣ ዎልቃማ ꬉማኮ ሙሴ ሺቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ሙሳ፥ “እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ታን ሳሉዋፐ ህንተንቶ ሃሳዬዳዋ ህንተንቱ ህንተንቱ ሁጲያዉ በኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ታ ማታን አይ ኤቃነ ኦꬆፕተ፤ ብራ ኤቃ ዎይ ዎርቃ ኤቃ ህንተንቶ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘ኔን ታዉ ያርሹዋ ያርሽያ ሳኣ ኡርቃፐ መꬋደ ነ ጹግያ ያርሹዋ፥ ነ እትፐተꬃ ያርሹዋ፥ ነ ዶርሳቱዋነ ነ ዴሻቱዋፐ ነ ሚዛቱዋ አ ቦላ ያርሻ። ታ ሱንꬃይ ቆፈታና ማላ ኦꬄዳ ሳኣ ኡባን፥ ታን ህንተንቱኮ ያደ፥ ህንተንታ አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ኔን ታዉ ያርሹዋ ያርሽያ ሳኣ ሹቻፐ መꬎፐ፥ ማሰቴዳ ሹቻፐ መꬎፓ፤ አያዉ ጎፐ፥ ኔን ማስያ ሚሻን አ ቦቾፐ፥ ነ አ ቱንሳሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ታ ያርሹዋ ሳኣ ፑደ ጋይያን ከሶፓ፤ አያዉ ጎፐ፥ ኔን ከስያ ዎደ፥ ነ ካሉ ቤተ’ ያጋደ ኦዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“ኔን ኡንቱንቶ እማና ዎጋይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ኔን እብራዌ አይልያ ሻሞፐ፥ እ ነዉ ኡሱፑን ላይꬃ ኦꬆ፤ ሽን ላፑንꬃ ላይꬃን እ አይነ ቃንጸናን፥ አይለተꬃፐ ጮ ከሲደ ቦ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","እ ባረካ ዬዳዋ ግዶፐ ባረካ ቦ፤ ባረ ማቻትና ዬዳዋ ግዶፐ፥ አ ማቻታካ አናና ቡ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","አ ጎዳይ አዉ ማቻቶ እሜዳዋ ግዶፐነ ማቻታ አዉ አቱማ ናና ዎይ ማጫ ናና የሌዳዋ ግዶፐ፥ ሄ ማቻታነ እዝ ናናይ አ ጎዳዋ፤ እ ባረካ ከሲደ ቦ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ሽን ሄ አይሊ፥ ‘ታን ታ ጎዳ፥ ታ ማቻቶነ ታ ናና ሲቃይ፤ ታን አይለተꬃፐ ከስከ ጎፐ፥’ ");
INSERT INTO dwrENT_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","አ ጎዳይ አ ፕርድያዋንቱ ስንꬃ አꬆ፤ ሄዋፐ ጉይያን ፐንገ ዎይ ፐንገ ማቃንያኮ አ አፊደ፥ አ ሀይꬃ ጎꬃን ሉኮ። ስም እ ባረ ደኡዋ ላይꬃ ኡባን አዉ አይልያ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“አሳይ ባረ ማጫ ናቶ አይለተꬃዉ ዛልኦፐ፥ አቱማ አይለቱ አይለተꬃፐ ከስያዋዳን እዛ ከሱፑ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","እዛ ባረና ማቼተꬃዉ ዶሪደ አፌዳ ጎዳዉ ሎአና ꬋዮፐ፥ ጎዳይ እዞ ዎዝሳናዉ ኮሼ። እ እዝዉ አማነትቤና ድራዉ፥ እዞ አላጋዉ ዛልአናዉ አዉ ማታይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","እ እዞ ባረ ናአዉ እማናዉ ዶሮፐ፥ ማጫ ናትዉ በስያዋ እዝዉ ኦꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","እ ባረዉ ሀራ ማቻቶ አኮፐ፥ ኮይሮ ማቻትዉ ቁማ፥ ማዩዋ ዎይ አስናተꬃነ ማቼተꬃ ማታ ፓጭሶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","እ ሀ ሄዙባቱዋ እዝዉ እማና ꬋዮፐ፥ አይነ ሻሉዋ ጭገናን አይለተꬃፐ ከሳደ ቡ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“አሳ ሾጪደ ዎꬍያ አሳ ቱሙፐ ዎꬋናዉ በሴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ሽን ኤሪደ ግደናን እ ዎꬍያ ዎደ፥ ታን፥ ጾሳይ ጮኡ ጌዳዋ ግዶፐ፥ እ ባቃታና ሳኣ ኡንቱንቶ ታን ጊግሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ሽን ኦነ ቆፒደ ኤሪደ ሀራ ብታንያ ዎꬎፐ፥ ሄ ኡራ ታ ያርሹዋ ሳኣፐ ድጋደ፥ ሀራ ሳኣን ዎꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ባረ አባ ዎይ ባረ ዳዮ ደችያ ኡራይ ኦንነ ቱሙፐ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“አሳ ዎልቃን ኦይቂደ ዛልእያ ኡራይ ዎይ ዎልቃን ኦይቄዳ አሳይ አ ኩሽያን ቤቴዳ አሳይ ቱሙፐ ሀይቃናዉ በሴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ባረ አባ ዎይ ባረ ዳዮ ሸቂያዌ ቱሙፐ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“ላኡ አሳቱ ዋላቀቶፐ፥ እቱ የንኩዋ ሹቻን ጫዶፐ ዎይ ቦክሶፐ፥ ሄ ደሸቴዳዌ ሀይቀናን አቶዋ ግዶፐነ ሀርጊደ ግሱዋን ጋምኦፐ፥ ደንዲደ ጉፍያና ካረ ሄራን ሀመቶፐ፥ ሄ ደቼዳዌ ሀይቁዋፐ አቴ፤ ግዶፐነ እ አ ኪታ ድጌዳ ድራዉ፥ ሻሉዋ ጭጋናዉነ አ ፓꬃናዉ ማዳና ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“አሳይ ባረ አቱማ አይልያ ዎይ ማጫ አይላቶ ጻምአን ሾጮፐነ ሄዋ ጋሱዋን ሄ ኡራይ ሄ ጎዳ ኩሽያን ሀይቂንቶ፥ ሾጬዳዌ ቱሙፐ ሙረታናዉ በሴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ሽን ሄ ደሸቴዳዌ እት ዎይ ላኡ ጋላሳን ደንዶፐ፥ ሄ አይሊ አ ሚሻ ግድያ ድራዉ፥ እ ሙረተና። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ላኡ አሳቱ እቱ እቱዋና ዋቲደ ሻሃራ ምሽራቶ ደቾፐነ እዛ ቦሸቶፐ፥ ሄዋፐ ሀራ ኢታ ደሸꬃይ ꬋዮፐ፥ ሄ ምሽራት አስናይ ኦቼዳዋነ ዳናቱ ፕርዴዳዋ አያነ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ሽን እዝዉ ደሸꬃይ ዳሮፐ፥ ሸምፑ ሀይቂንቶ ሸምፑዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","አይፍያ ድራዉ አይፍያ፥ አቻ ድራዉ አቻ፥ ኩሽያ ድራዉ ኩሽያ፥ ገድያ ድራዉ ገድያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ጹገꬃ ድራዉ ጹገꬃ፥ ማዱꬃ ድራዉ ማዱꬃ፥ ቆኤዳ ድራዉ ቆኡዋ አካናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“እት አሳይ ባረ አቱማ አይልያዉ ዎይ ማጫ አይላትዉ አይፍያ ባቂደ ቶይሶፐ፥ ሄ አይፍያ ድራዉ አይለተꬃፐ ከስ የዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ሄዋዳንካ፥ ባረ አይልያ አቻ ዎይ ባረ አይላት አቻ መንꬆፐ፥ ሄ አቻ ድራዉ አይለተꬃፐ ከስ የዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ቦራይ ማጫ አሳ ዎይ አቱማ አሳ ቃይጪደ ዎꬎፐ፥ ሄ ቦራይ ሹቻን ጫደቲደ ሀይቆ፤ አ አሹ ሜተቶፖ። ሽን ቦራ ጎዳይ ሙረቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ሽን ቦራይ ካሰካ ቃይጭያ ሜዚ ደእያዋ ግዲና፥ አሳይ አ ጎዳዉ ኦድ ዎꬅና፥ አ ጎዳይ ቃቼናን እጽና፥ ቦራይ አቱማ አሳ ዎይ ማጫ አሳ ዎꬎፐ፥ ሄ ቦራይ ሹቻን ጫደቲደ ሀይቆ፤ ቃይ አ ጎዳይካ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ሽን እ ባረና ዎዛናዳን ኦሸቶፐ፥ ኡንቱንቱ ኦቼዳዋ አያነ ጭጊደ፥ ባረ ሸምፑዋ ዎዞ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ቦራይ አቱማ ናኣ ዎይ ማጫ ናቶ ቃይጪደ ዎꬎፐካ፥ ፕርዳይ እት ማላ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ቦራይ አቱማ አይልያ ዎይ ማጫ አይላቶ ቃይጪደ ዎꬎፐ፥ ቦራ ጎዳይ አይልያ ጎዳዉ ሀታሙ ብራ ሳንትምያ ጭጎ። ቦራይ ሹቻን ጫደቲደ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“እት አሳይ ኦላ ቁምእያ ፖኪደ፥ ዎይ ኦላ ቦኪደ ቁምኤናን አጎፐ፥ ቦራይ ዎይ ሀሪ ሄ ኦላን ኩንዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ሄ ኦላ ጎዳይ መህያ ጋትያ ጭጎ። እ አ ጎዳዉ ጋትያ ጭጊደ፥ ሀይቄዳ መህያ ባረዉ አኮ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“እት አሳ ቦራይ ሀራ ቦራ ቃይጪደ ዎꬎፐ፥ ፓጻ ቦራ ዛልኢደ፥ አ ጋትያነ ሀይቄዳ ቦራ ልክያን ሻክ አክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ሽን ሄ ቦራይ ቃይጭያዋ ግድያዌ ካሰት ኤረትሽን፥ አ ጎዳይ አ ቃቼናን አጌዳዋ ግዶፐ፥ አ ጎዳይ ቦራ ጭጎ። ያቲደ ሄ ሀይቄዳዋ ባረዉ አኮ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“እት አሳይ ቦራ ዎይ ዶርሳ ዉኢደ ሹኮፐ፥ ዎይ ዛልኦፐ፥ ቦራ ድራዉ እቼሹ ቦራ፥ ዶርሳ ድራዉ ኦይዱ ዶርሳ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“ካይሱ ጎልያ ቦኪደ ኦይቀቶፐነ ሾጨቲደ ሀይቂንቶ፥ ሾጬዳዌ ሱꬃ ጉሴዳዎ ኦሸተና። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ሽን ሄዌ ጻልቂ ዶል ክችና ሀኖፐ፥ እ ሄ ጉኬዳ ሱꬃ አጩዋን ኦሸቴ። ካይሱ ባረ ዉኤዳዋ ዛሮ፤ ሽን አዉ አያይነ ꬋዮፐ፥ ባረ ዉኤዳዋ ዛራናዉ እ ዛልኤቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","እ ዉኤዳ መሂ ፓጻ ደኢደ አ ኩሽያን ቤትንቶ፥ ቦራ፥ ዎይ ሀርያ፥ ዎይ ዶርሳ ግዶፐነ፥ እ ባረ ዉኤዳዋ ላኡ ኩሽያ አꬂደ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“እት አሳይ ባረ መህያ ደምባን ዎይ ዎይንያ ቱራ ግዶን ሄምሽን፥ መሂ ሀራ አሳ ሾይቃፐ ሞፐ፥ እ ባረ ሾይቃፐ ዎይ ባረ ዎይንያ ቱራ ኡባፐ ሎእያዋ አፍላማ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“ጻራጋይ ደንዲደ አጉንꬃ ቡራና ላኢደ፥ ዶርያን ደእያ ካꬃ፥ ዎይ ኤቁዋን ደእያ ካꬃ፥ ዎይ ጎሻ ኡባ ምያዋ ግዶፐ፥ ኮይሮ ጻራጋ ኦይꬄዳ ብታኒ አጫ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“እት አሳይ ብራ ዎይ ሀራ ሚሻ ናግሳናዉ ባረ ሾሮ ሀዳራ እምና፥ ሾሩዋ ሶፐ ሄ ሚሻይ ዉኤቶፐነ ካይሱ ኦይቀትንቶ፥ ካይሱ ሄ ሚሻዉ ላኡ ኩሽያ አꬂደ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ሽን ካይሱ ቤተናን ꬋዮፐ፥ ጎልያ ጎዳይ ፕርድያዋንቱኮ ሺቂደ ባረ ሾሩዋ ሚሻ ቦላ ባረ ኩሽያ ዎꬅቤናዋ ጫቆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“አሳይ አይ ሞቱዋንካ፥ ቦራ ጋሱዋን፥ ዎይ ሀርያ ጋሱዋን፥ ዎይ ዶርሳ ጋሱዋን፥ ዎይ ማዩዋ ጋሱዋን፥ ዎይ ሀራ ባዬዳዋ ጋሱዋን፥ ‘ሀዌ ታዋ’ ጊደ ሞተቶፐ፥ ላኡ ባጋይካ ባረንቱ ሞቱዋ ፕርድያዋንቱ ስንꬃ አꬅኖ፤ ፕርድያዋንቱ ባይዛንቻ ጌዳ ኡራይ ባረ ሾሮ ላኡ ኩሽያ አꬂደ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“አሳይ ባረ ሾሮ ሀርያ፥ ዎይ ቦራ፥ ዎይ ዶርሳ፥ ዎይ ሀራ መህያ ናግሳናዉ ሀዳራ እምና ሀይቂንቶ፥ ዎይ ደሸትንቶ፥ ዎይ ኦንነ በኤናን ቦንቃንቻይ አፎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ሀዳራ ናግያዌ ባረ ሾሩዋ መህያ ቦላ ባረ ኩሽያ ዎꬅቤናዋ መꬍና ጎዳ ስንꬃን ጫቂና፥ ኡንቱንቱ ግዶን ደእያ የዉ ማየቶ። ሄ መህያ ጎዳይ ጫቁዋ አኮ፤ ጭጋ እማናዉ ኮሸና። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ሽን መሂ ሾሩዋፐ ዉኤቴዳዋ ግዶፐ፥ እዛዎ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ሄ መህያ ዶአይ መንሬꬂደ ሜዳዋ ግዶፐ፥ ማርካ ግዳናዳን ዶአይ ሚሽን አቴዳዋፐ አኪደ ዮ፤ ያቲደ መኤረቴዳ መህያ ድራዉ ጭጎፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“አሳይ ባረ ሾሩዋፐ መህያ ጋርጾፐነ አ ጎዳይ ባይና ሳኣን ሄ መሂ ደሸቶፐ ዎይ ሀይቆፐ፥ ሄ መህያ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ሽን አ ጎዳይ አናና ደኦፐ፥ ጋርጼዳዌ ጭጎፖ፤ ከራዉ አኬዳዋ ግዶፐ፥ ከራዉ ጭግያ ሻሉ አጩዋ ጭጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“እት አሳይ አስናዉ ጊጋቤና ዎዶራቶ ጭሚደ፥ እዝና ግስያዋ ግዶፐ፥ እዞ ጭሎሺደ ባረዉ ማቻቶ ኦꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","እዝ አቡ እዞ አዉ እማናዉ እጾፐ፥ ዎዶራቶ አክያ ኡራይ ጭሎሽያዋ ኬሻ ብራ እ አቦ እሞ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“ብትያ ምሽራቶ ፓጻ ዎꬆፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“መህያና ግስያ ኦንነ ቱሙፐ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“መꬍና ጎዳ ጻላላሳፐ አትና፥ ሀራ ጾሳዉ ያርሽያዌ ኦንነ ሙለ ꬋዮ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","በቲደ ዬዳ አሳ ቆሆፕተ ዎይ ኡንኦፕተ፤ አያዉ ጎፐ፥ ህንተንቱካ ግብጼ ጋድያን በተ ግዲደ ደኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","አስናይ ሀይቄዳ አምአቶነ አዉ ሀይቄዳ ህዬሳ ኡንኦፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ህንተንቱ ኡንቱንታ ኡንኤꬅና፥ ኡንቱንቱ ታኮ ዋሶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ታን ኡንቱንቱ ዋሱዋ ቱሙፐ ስሳና፤ ሄ ዎደ ታ ሀንቁ ህንተንቱ ቦላ ደንዳና፤ ታን ህንተንታ ማሻን ዉርሳና፤ ህንተንቱ ማቻቱ አምኤ ህንተንቱ ናናይካ አዉ ሀይቆዋንታ ግዳናዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“ህንተንቱ ግዶን ደእያ ታ አሳፐ እት ህዬሳዉ ሻሉዋ ታልኦፐ፥ ሻሉዋ ድቻዉ እምያ አሳዳን ሀኖፕተ፤ ኔን ድቻ አ ኦቾፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ኔን አጩዋ ድራዉ ነ ላግያ ማዩዋ ኦይቆፐ፥ አዋይ ዉለናን ደእሽን አዉ ዛራ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","አያዉ ጎፐ፥ እ ባረ ቦላ ካምያዌ ሄን ጻላላና፤ ሀራባ አያ ማዪደ አቃናዉ ዳንዳዪ? እ ታዉ ዋሶፐ፥ ታን ቃረትያዋ ግድያ ድራዉ፥ ስሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ጾሳ ቦላ ሸቃ ቃላ ሃሳዮፓ፥ ዎይ ነ ደርያ ሞድያዋ ሸቆፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","ነ ካꬃ ጼራፐነ ነ ዎይንያ ጉምኤꬃ ኩመንꬃፐ ታዉ ያርሹዋ ሺሻ። “ኔን ነ አቱማ ናና ግዶን ባይራትያ ናኣ ታዉ እማናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ሚዛፐካ ዶርሳፐካ ሄዋዳን ኦꬃ። ኡንቱንቱ ላፑን ጋላሳይ ጋካናዉ፥ ባረንቱ አየቱዋና አየቱዋና ጋምእኖ፤ ሆስፑንꬃ ጋላስ ኡንቱንታ ታዉ እማ። ");
INSERT INTO dwrENT_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“ህንተንቱ ታዉ ጌሻ አሳ ግዳናዉ ኮሼ፤ ሄዋ ድራዉ፥ ባዙዋ ዶአይ መንሬꬂደ ዎꬌዳ መህያ አሹዋ ሞፕተ፤ ሄዋ ካናዉ ኦልተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ዎርዶ ኦዱዋ ፑኮፓ፤ ዎርዱዋ ማርካ ግዳደ፥ ኢታ አሳ ማዶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ኢታባ ኦꬃናዉ ጮራ አሳ ካሎፓ፤ ፕርዳ ጌላያናዉ ጮራ አሳና እታ ግዳደ ማርካቶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ህዬሳይ ፕርዳዉ ሺቆፐ፥ ሞቱዋን አ መቱዋ ጼላደ ማዶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“ነ ሞርክያ ቦራይ ዎይ ሀሪ ባዬዳዋ ደሞፐ፥ ዛራደ አዉ አፋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ኔና እጽስያ ብታንያ ሀሪ ጫናና ኩንዴዳዋ በኦፐ፥ ሄዋን አጎፓ፤ ማዳደ አናና ደንꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“ፕርዳ ዳባባን ማዳደ፥ ህዬሳ አሳ ፕርዳ ጌላዮፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ዎርዶ የዉዋ ኡባፐ ሃካ፤ ጌሻ ዎይ ጽሉዋ ዎꬎፓ፤ አያዉ ጎፐ፥ ኮባ ኦꬄዳዋ ታን ሳሮ የድከ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ማታይያ (ማጋንጻ) አኮፓ፤ አያዉ ጎፐ፥ ማታዪ ጼልያዋንቱ አይፍያ ቆቅሴነ ጽላቱዋ ቃላ ምርቄ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“በትያ ናቆፕተ፤ በተ ግድያዌ አይ ኬሻ ካዮይንቶ ኤሪታ፤ አያዉ ጎፐ፥ ህንተንቱ ህንተንቱ ሁጲያዉ በተ ግዲደ ግብጼ ጋድያን ደኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ኔን ነ ጋድያ ኡሱፑን ላይꬃዉ ጎሻደ፥ ዘራደ ካꬃ ቆይጫ አካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ላፑንꬃ ላይꬃን ጋድያ ጎሸናን ሻቻ፤ ያቶፐ፥ ነ አሳ ግዶን ደእያ ህዬሳቱ ሄዋፐ ምያባ ደማና፤ ቃይ ኡንቱንቱፐ አትያዋ ዶአቱ ማና። ኔን ነ ዎይንያ ቱራካ ነ ዎጋራካ ሄዋዳን ኦꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ኡሱፑን ጋላሳ ነ ኪታ ኪተታ፤ ነ ቦራይነ ነ ሀሪ ሸምፓና ማላነ ነ ሶን የለቴዳ አይሊነ በቲ፥ ሸምፓና ማላ፥ ላፑንꬃ ጋላስ ኦሱዋ ኦꬆፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ታን ህንተንታ ጌዳዋ ኡባ ምንሲደ ኦꬅተ፤ ሀራ ጾሳቱዋ ሱንꬃ ጼሶፕተ፤ ህንተንቱ እንጻርሳፐ ሄዌ ስሰቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ላይꬃን ሄዙ ገደ ህንተንቱ ታዉ ባላ ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ማጋገ ኡክꬃ ባላ ቦንችተ፤ ታን ህንተንታ አዛዜዳዋዳን፥ ላፑን ጋላሳ እርሹዋ የግቤና ኡክꬃ ሚተ፤ ህንተንቱ አቢባ ጌተትያ አግናን ኬሬዳ ጋላሳቱዋን ሀ ባላ ቦንችተ፤ አያዉ ጎፐ፥ ህንተንቱ ግብጼፐ ከሴዳዌ ሄ አግናና። “ህንተፐ እት አሳይነ ታ ስንꬃን መላ ኩሸ ቤቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“ቃይ ህንተንቱ ህንተንቱ ጋደን ዘርና፥ ኮይሮ ጋኬዳ ካꬃ ጫክያ ዎደ፥ ካꬃ ጫክያ ባላ ቦንችተ። “ቃይካ ላይꬃ ዉርሰꬃን፥ ካꬃ አይፍያ ጋደፐ ሺሽያ ዎደ፥ ሺሹዋ ባላ ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","አቱማ አሳይ ኡባይ ኡባ ሞድያ መꬍና ጎዳ ስንꬃን ላይꬃን ሄዙ ገደ ቤቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ኔን ያርሹዋ ሱꬃ ታዉ ሺሻደ፥ እርሹዋ የጊደ ኡኬዳ ኡክꬃና ሺሾፓ። ታ ባላ ቦንችያ ጋላስ ያርሸቴዳ ሞꬉዋፐ ዎንታዉ አይነ አቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ነ ጋደን ባይራ ካኤዳ ካꬃፐ ኡባፐ ሎእያዋ መꬍና ጎዳ ሶ፥ ነ ጾሳ ሶ አሀ። ዴሻ ማራ አ ዳይ ማꬃን ዶይሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“ነ ኦግያን ኔና ናጋና ማላነ ታን ነዉ ጊግሴዳ ሳኣ ኔና አፋና ማላ፥ ታን ኪታንቻ ነ ስንꬃን ኪታና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","እ ኦድያዋ ሀይዛ አዉ አዛዘታ፤ አ ቦላ ማካሎፓ፤ ታ ሱንꬃይ አ ቦላ ደእያ ድራዉ፥ ህንተንቱ ናጋራ ኦꬅያዋ ግዶፐ፥ ህንተንቶ እ አቶ ጌና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","እ ኦድያዋ ህንተንቱ ምንሲደ ሀይዞፐነ ታን ኦድያዋ ኡባ ኦꬆፐ፥ ህንተንቱ ሞርከቱዋ ታን ሞርካና፤ ህንተናና ኤቀትያዋንቱና ታንካ ኤቀታና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ታ ኪታንቻይ ህንተፐ ስንꬃና ቢደ፥ ህንተንታ አሞራዋናቱዋ ጋድያ፥ ሂተቱዋ ጋድያ፥ ፓርዛዋናቱዋ ጋድያ፥ ካናነቱዋ ጋድያ፥ ሂዌቱዋ ጋድያነ ያቡሳዋናቱዋ ጋድያ አሀና። ታን ኡንቱንቱ ኡባ ꬋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ኡንቱንቱ ጾሳቱዋ ስንꬃን ሆኮፕተ፥ ዎይ ጎይኖፕተ፥ ዎይ ኡንቱንቱ ሀኑዋ ቁሎፕተ። ህንተንቱ ኡንቱንቱ ጾሳቱዋነ ኡንቱንቱ ሹቻ ምስለቱዋ መንሬꬃናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","መꬍና ጎዳ፥ ህንተንቱ ጾሳዉ፥ ጎይንተ፤ ያቶፐ፥ እ ህንተንቱ ቁማነ ህንተንቱ ሃꬃ አንጃናዋ፤ ታን ሀርግያ ህንተንቱ ግዶፐ ድጋና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ህንተንቱ ቢታን አይ ማጫ አሳይነ ቦሸተና፤ ማይነና። ታን ህንተንቱ ደአና ላይꬃ ፓይዱዋ አዱሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“ታን ታ ያሻ ህንተንቱ ስንꬃን የዳና፤ ህንተናና ጋከትያ ካዉተꬃ ኡባ ዳጋንꬃና፤ ህንተንቱ ሞርከቱ ኡባይ ህንተንቶ ዞኪያ ዛሪደ፥ ባቃታናዳን ታን ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ታን ህንተፐ ስንꬃዉ ዱክያ ካጅያ የዳና፤ ሂዌቱዋ፥ ካናነቱዋነ ሂተቱዋ ህንተንቱ ስንꬃፐ ላጋደ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ሽን ቢታይ መላ አተናዳንነ ባዙዋ ዶአይ ህንተንታ ዋይሰናዳን፥ እት ላይꬃን ኡንቱንታ የደርስከ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ሽን ህንተንቱ ፓይዱዋን ዳሪደ፥ ሄ ጋድያ ላታና ጋካናዉ፥ ታን ኡንቱንታ ላፋ ላፋ ላጋደ ህንተንቱ ስንꬃፐ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ታን ህንተንቱ ዛዋ ዞኦ አባፐ ፕልስጼማ አባ፥ መላ ቢታፐ ኤፍራጺሳ ሻፋ ጋꬃና። ሄ ጋድያን ደእያ ኡባ ታን ህንተንቱ ኩሽያን አꬃደ እማና፤ ህንተንቱካ ኡንቱንታ ህንተንቱ ስንꬃፐ ላጊደ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ኡንቱንቱና ዎይ ኡንቱንቱ ጾሳቱዋና ጫቁዋ ዎꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ኡንቱንታ ህንተንቱ ጋድያን ዎꬆፕተ፤ ሄዌ ꬋዮፐ ኡንቱንቱ ህንተንታ ታ ቦላ ናጋራ ኦስሳናዋንታ፤ አያዉ ጎፐ፥ ኡንቱንቱ ጾሳቶ ጎይንያዌ ቱሙፐ ህንተንቶ ጲረ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ሄዋፐ ጉየ መꬍና ጎዳይ ሙሳ፥ “ኔን፥ አሮነ፥ ናዳበ፥ አቢህነ እስራኤልያፐ ላፑን ታሙ ጭማ አሳቱ መꬍና ጎዳኮ ደርያ ሁጲያ ፑደ ከሲደ ሃኩዋን ጎይንተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ሽን ሙሴ፥ ኔን ኔረካ መꬍና ጎዳኮ ሺቃ፤ ሀራ ጭማቱ ታ ማታ ዮፕኖ። ቃይ አሳይካ ኔናና ፑደ ከሶፖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ሙሴ ዪደ፥ መꬍና ጎዳ ቃላ ኡባነ አ ዎጋ ኡባ አሳዉ ኦድና አሳይ ኡባይ እት ቃላን፥ “መꬍና ጎዳይ ኦዴዳዋ ኡባ ኑን ኦꬃና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ሙሴ መꬍና ጎዳይ ኦዴዳዋ ኡባ ጻፌዳ። ዎንተꬃ ጋላስ ዎንታ ጉራን ደንዲደ፥ ደርያ ጻጱዋን ያርሽያ ሳኣ ግምቢደ እስራኤልያ አሳ ያራ ታማነ ላኡዋ ሱንꬃን፥ ታማነ ላኡ ሹቻ ቱሳ ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","እ እስራኤላቱዋፐ ያላጋ አቱማ አሳ ኪትና፥ ኡንቱንቱ ቢደ ጹግያ ያርሹዋ ሺሼድኖ፤ ቃይ እትፐተꬃ ያርሾ ኮሩማቱዋ መꬍና ጎዳዉ ያርሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ሙሴ ሱꬃፐ ባጋ አኪደ ከርያን ትጌዳ፤ አቴዳ ባካ ሱꬃ እ ያርሽያ ሳኣን ጫጫፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ሄዋፐ ጉይያን ቃላ ጫቁዋ ማጻፋ አኪደ፥ አሳዉ ናባቤዳ፤ ኡንቱንቱ፥ “መꬍና ጎዳይ ኦዴዳዋ ኡባ ኑን ኦꬃና፤ ኑን አዛዘታና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ሄዋፐ ጉይያን ሙሴ ሄ ሱꬃ አኪደ፥ አሳ ቦላ ጫጫፊደ ኡንቱንታ፥ “በእተ፥ መꬍና ጎዳይ ሀ ቃላ ኡባን ህንተናና ዎꬄዳ ቃላ ጫቁዋ ሱꬃይ ሀዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ሙሴ፥ አሮነ፥ ናዳበ፥ አቢህነ እስራኤልያ ጭማቱዋፐ ላፑን ታሙ ፑደ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","እስራኤልያ ጾሳ በኤድኖ፤ አ ገድያፐ ጋርሳና ሳሉዋዳን ጌዬዳ ሳምፔርያ ጌተትያ ጶልያ ሹቻፐ ኦሰቴዳዋ ማላትያ ዉይግያ ማላባይ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ሽን ጾሳይ እስራኤልያ አሳ ካፓቱዋ ዎꬍቤና። ኡንቱንቱ ጾሳ በኤድኖ፤ አ ስንꬃን ሜድኖነ ኡሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","መꬍና ጎዳይ ሙሳ፥ “ኔን ደርያ ፑደ ሃ ታኮ ከሳደ፥ ሀዋን ጋምአ፤ ያቶፐ ኔን ኡንቱንታ ታማርሳና ማላ፥ ታን ዎጋነ አዛዙዋ ጻፌዳ ሹቻ ነዉ እማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ሄዋፐ ጉይያን ሙሴ ባረ ቆማ ኢያሱና ባናዉ ደንዴዳ፤ ሙሴ ጾሳ ደርያ ፑደ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","እስራኤልያ አሳ ጭማቱዋ እ፥ “ኑን ህንተንቱኮ ስማናዉ ሀዋን ደእሽተ፤ አሮነነ ሁር ሀዋን ህንተናና ደኢኖ፤ የዉ ደእያ ኦንነ ኡንቱንቱኮ ቦ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ሙሴ ደርያ ፑደ ከሴዳ ዎደ፥ ሻሪ ደርያ ካሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ቃይ መꬍና ጎዳ ቦንቹ ሲና ደርያ ቦላን ኡቴዳ፤ ሄ ሻሪ ኡሱፑን ጋላሳ ማዬዳ፤ ላፑንꬃ ጋላሳን ሄ ሻርያ ግዶፐ መꬍና ጎዳይ ሙሳ ጼሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","እስራኤላቶ መꬍና ጎዳ ቦንቹ ደርያ ሁጲያን ጹግያ ታማ ማላቲደ ቤቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ሄዋፐ ጉይያን ሙሴ ሄ ሻርያ ግዶ ገሊደ፥ ደርያ ፑደ ከሲደ ደርያ ሁጲያን ኦይታሙ ጋላሳነ ኦይታሙ ቃማ ጋምኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ታዉ እምያዋ አሀናዳን ኔን እስራኤላቶ ኦዳ፤ ታዉ እማናዉ አ ዎዛናይ አ እማ እማ ግያ አሳ ኡባ እሞታ ኔን ታዉ አካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ህንተንቱ ኡንቱንቱፐ አካና እሞታይ ሀዋ: ዎርቃ፥ ብራ፥ ናሃስያ ብራታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ፥ ዞኦ ሊቆ ቃጭና፥ ዴሻ እስክያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ዶርሳ ኦርግያ ጋልባ ዞኦ ቃላምያን የግ ከሴዳዋ፥ ሀራ ጋልባ፥ ኦዶሩዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ጾምፕያዉ ዎጋራ ዛይትያ፥ ኦክያ ዛይትያነ እጻና ሳዌꬅያ ቅማምያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ቄሳቱዋ ካፑዋ ኤፉድያንነ ትራን ዎꬅያዋን የግያ ማርግድያ ጌተትያ ሹቻቱዋነ ሀራ ጶልያ አልኦ ሹቻቱዋ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“ያቲደ ታን ኡንቱንቱ ግዶን አቃናዳን፥ ኡንቱንቱ ታዉ ጌሻ ሳኣ ጊግስኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ልከ ታን ኔና በሴዳ ሌምሱዋ ኡባዳን ጾሳ ዱንካንያነ አ ግዶን ደእያ ሚሻቱዋ ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“ኡንቱንቱ ኦዶሩዋ ምꬃፐ አዱሳተꬃይ ላኡ ዋꬋነ ባጋ፥ ጎምፓይ እት ዋꬋነ ባጋ፥ ጌሳይ ቃይ እት ዋꬋነ ባጋ ግዴዳ ታቦታ መꬍኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ሶያነ ካርያ ዋላካይ ባይና ዎርቃን ሼሻ፤ አ ዩሹዋካ ዎርቃ ትገꬃን ዩሻ አꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ሄ ታቦታዉ ኦይዱ ዎርቃ ሳጋየቱዋ ትጋደ ኦይዱ ገደቱዋን እት ባጋና ላኡ ሳጋየቱዋ፥ ቃይ የንኮ ባጋና ላኡ ሳጋየቱዋ አꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ሄዋፐ ጉይያን ኦዶሩዋፐ ካሱዋ ከሳደ ዎርቃን ሼሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ታቦታ ቶካናዉ፥ ታቦታ ምይያን ደእያ ሳጋየቱዋን ካሱዋ አꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ቶክያ ካሶቱ ታቦታ ሳጋየቱዋ ግዶን ደእኖ፤ ኡንቱንቱ ሄዋፐ ኡባካ ከሶፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ታቦታ ግዶን ታን ነዉ እምያ፥ ታሙ አዛዛቱ ጻፈት ኡቴዳ ላኡ ማሰቴዳ ማርካተꬃ ሹቻቱዋ ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“ዋላካይ ባይና ዎርቃፐ ላኡ ዋꬋነ ባጋ አዱቂያ፥ እት ዋꬋነ ባጋ አክያ አቶ ግያ ሳኣ ቁምእያ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ቁምእያዉ ዉርሰꬃ ላኡ ባጋ ጋጻን ላኡ ክሩቤልያ፥ ቆጸቴዳ ዎርቃፐ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","እት ክሩብያ እት ባጋ ጋጻን፥ ላኤንꬆ ክሩብያ የንኮ ባጋ ጋጻን ላኡዋካ ቁምእያና ጋꬃ ኦይꬃደ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ክሩበቱ ባረንቱ ቀፍያ ደንꬂደ፥ አቶ ግያ ሳኣ ቁምእያ ባረንቱ ቀፍያን ኩዋይ ዎꬅኖ፤ ቃይ እቱ እቱዋኮ ስም ኡቲደ፥ ቁምእያ ጼልኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ቁምእያ ታቦታዉ ቦላ ባጋን ዎꬃ፤ ቃይ ታን ነዉ እምያ አዛዛቱ ጻፈቲደ ማሰቴዳ ሹቻቱዋ ታቦታ ግዶን ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ማርካተꬃ ታቦታ ቦላ ቁምእያ ቦላ ደእያ ላኡ ክሩበቱዋፐ ግዱዋን ታን ኔናና ጋከታደ እስራኤልያ አሳዉ ታን እምያ አዛዙዋ ኡባ ያን ነዉ እማና። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ኦዶሩዋ ምꬃፐ አዱሳተꬃ ላኡ ዋꬋ፥ ጎምፓይ እት ዋꬋ፥ ጌሳይ ቃይ እት ዋꬋነ ባጋ ግድያ እት ጻርጴዛ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ያታደ ዋላካይ ባይና ዎርቃን ሼሻ፤ ቃይ አ ዩሹዋን ዎርቃ ትገꬃ ዩሻ አꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ሄዋዳንካ፥ ቃይ ጎምፓይ ታካ ግዴዳ ሻሽያ አ ቦላ ዩሻ አꬃ። ያታደ አ ቦላ ዎርቃ ትገꬃ ዩሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ሄ ጻርጴዛዉ ኦይዱ ዎርቃ ሳጋየቱዋ መꬋደ፥ ጻርጴዛ ገደቱ ደእያ ኦይዱ ጋጻን ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ጻርጴዛ ቶካናዉ ካሱዋ አꬅያ ሳጋየቱ ጻርጴዛዉ ሻሽያ ጋጻን ሺቂደ ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ሄ ቶክያ ካሱዋ ኦዶሩዋፐ ከሳደ፥ ዎርቃን ኡንቱንታ ሼሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ሄዋዳንካ፥ ቃይ ሻታቱዋነ ጭልፓቱዋ፥ ዱቂያባቱዋነ ጹአቱዋ ዋላካይ ባይና ዎርቃፐ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ታ ስንꬃ አꬅያ ጌሻ ኡክꬃይ ኡባ ዎደካ ጻርጴዛ ቦላ ꬋዮፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“ጾምፕያ ዎꬅያ ባላ ቆጸቴዳ ዋላካይ ባይና ዎርቃፐ መꬋ፤ ሄ ባላይ ኤቂያ ገዲካ፥ ቃይ ግዶ ቶማይካ ኡባይ ቆጸቴዳ ዎርቃፐ ኦሰታናዉ ኮሼ። አ ዋንጫቱ፥ አ ኩኩሞቱ አ ጪሻቱ ኡባይ አናና እትፐ ኦይቀት መታናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ምይያና ኡሱፑን ማራቱ አዉ ከሲኖ፤ ማራቱዋፐ ሄዛቱ እት ባጋና፥ ቃይ ሄዛቱ የንኮ ባጋና ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ኡሱፑን ማራቶካ ሁጲያን ሁጲያን ሄዙ ሄዙ ኩኩሙነ ጪሻይ ደእያ ላዉዝያ ጪሻ ማላትያ ዋንጫይ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ጾምፕያ ዎꬅያ ባላዉ ግዶ ቶማይ፥ ኩኩሞቱዋ ጪሻቱ ደእያ ላዉዝያ ጪሻ ማላትያ ኦይዱ ዋንጫይ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ላኡ ላኡ እትፐ ዋꬃን ደእያ ሄዙ ማራቱዋፐ ጋርሳና እት እት ኩኩሙ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ኩኩማቱነ ማራቱ ኡባይ ጾምፕያ ዎꬅያ ባላና እትፐ፥ ኦይቀት እቱዋ ግዲደ፥ ዋላካይ ባይና ዎርቃፐ ቆጸቲደ መትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“ሄዋፐ ጉይያን ጾምፕያ ዎꬅያ ባላዉ ላፑን ጾምፐቱዋ ጊግሳደ፥ ኡንቱንቱ ስንꬃ ግዶዉ ፖአና ማላ ꬎቁ ኦꬃደ ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ጾምፕያ ቶይስያ ቃጰቱዋነ ኡንቱንታ ዎꬅያዋንታ ዋላካይ ባይና ዎርቃፐ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ጾምፕያ ዎꬅያ ባላይነ አን ጎኤትያ ሚሻ ኡባይ ሀታማነ እቼሹ ኪሎ ግራመ ግዴዳ ዋላካይ ባይና ዎርቃፐ መቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","አኬካ፤ ታን ኔና ደርያ ሁጲያን በሴዳዋዳን ኪተታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“ቃይ ሊቆ ፑቱዋፐ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐ ዳደቴዳ ታሙ ጋርዳቱዋ ጾሳ ዱንካንያ ጊግሳ። ሄ ጋርዳቱዋን እት ሂላን ክሩበቱዋ ምስልያ ዳድሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ጋርዶቱ ኡባይ እት ልከ ግድኖ፤ ጌሳይ ላታማነ ሆስፑን ዋꬋ፤ ጎምፓይ ኦይዱ ዋꬋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","እቼሹ ጋርዳቱዋ እትፐ ጋꬃደ ስካ፤ የንኮ አቴዳ እቼሹ ጋርዳቱዋካ ኡንቱንቱዋዳን ኪተታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","እትፐ ጋከቲደ ስከቴዳ ጋርዳቱዋፐ እት ጋርዱዋ ዉርሰꬃ ጋጻን ሳሉዋ ማላትያ ጫርቂያፐ ማጫራ መꬋ፤ ቃይ እትፐ ጋከት ስከቴዳ የንኮ ጋርዱዋንካ ሄዋዳን ኪተታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","እትፐ ጋከቴዳ እት ጋርዱዋ ቦላ እሻታሙ ማጫራ፥ ቃይ እትፐ ጋከቴዳ የንኮ ጋርዱዋ ቦላካ እሻታሙ ማጫራ መꬋ፤ ሄ ማጫራቱ ኡባይካ እቱ እቶ ማራን ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ሄዋፐ ጉይያን ዎርቃፐ እሻታሙ ኦይቂያዋንታ መꬋደ ጾሳ ዱንካኒ እቱዋ ግዳና ማላ፥ ሄ ጋርዳቱዋ ጋጻ ጋጻ ሄ ኦይቂያዋንቱን ኦይꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“ቃጭናፐ መቴዳ ጾሳ ዱንካንያ ቦላና ካማና ማላ፥ ታማነ እት ጋርዳቱዋ ዴሻ እስክያፐ ዳዳደ፥ እት ዱንካንያ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ታማነ እት ጋርዳቱካ እት ልከ ግድኖ፤ እት እት ጋርዱዋ ጌሳይ ሀታሙ ዋꬋ፥ ጎምፓይ ኦይዱ ዋꬋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","እቼሹ ጋርዳቱዋ እት ባጋና፥ ኡሱፑን ጋርዳቱዋ ቃይ የንኮ ባጋና ጋꬃደ ስካ። ኡሱፑንꬃ ጋርዱ ዳኮቲደ፥ ዱንካንያዉ ስንꬃ ባጋና ዳቡለቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ጋꬅ ስኬዳ ጋርዳቱዋፐ እት ጋርዱዋ ጋጻን እሻታሙ ማጫራ መꬋ፤ ቃይ ጋꬅ ስኬዳ የንኮ ጋርዳቱዋፐ ጋጻን እሻታሙ ማጫራ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","እሻታሙ ናሃስያ ኦይቂያዋ መꬋደ፥ ማጫራቱዋ ግዶ ገልሳ፤ ያታደ ዱንካንያ እትፐ ጋꬃ ኦይꬃ። ያቶፐ ሀ ላኡ ኦይቀቴዳ ካምያዋንቱ እቱዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ሀ ዱንካንያ ጋርዳቱዋፐ ፓላሄዳ ባጋ ጋርዱ ጾሳ ዱንካንያዉ ጉየና ካቀቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ዱንካንያ ጋርዶቱ ላኡ ባጋናካ እት እት ዋꬋ ኬሻ ፓላህኖ፤ ሄ ፓላሄዳዋንቱ ጾሳ ዱንካንያ ካማና ማላ፥ ላኡ ባጋ ምይያና ካቀትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“ዴሻ አጎዛፐ መቴዳ ዱንካንያ ቦላና ካማናዉ ዶርሳ ኦርግያ ጋልባ ዞኦ ቃላምያን የግ ከሴዳዋ ጊግሳ፤ ቃይ አ ቦላና ካማናዉ ቁምእያ ሀራ ጋልባፐ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“ጾሳ ዱንካንያ ጻጋግያዋንታ ስት ጌዳ ኦዶሩዋፐ ከሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","እት እት ጻጋግያዉ ጌሳይ ታሙ ዋꬋ፥ ጎምፓይ እት ዋꬋነ ባጋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","እት እት ጻጋግያዉ እቱዋ እቱዋና ጋꬅ ኦይꬅያ ላኡ ፖꬃ መꬋ። ጾሳ ዱንካንያ ጻጋገቱዋ ኡባካ ሄዋዳን ኪተታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ጾሳ ዱንካንያዉ ገድሳ ባጋና ላታሙ ጻጋግያዋ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","እት እት ጻጋግያዉ ላኡ ፖꬃይ ገልያ ኦይታሙ ሉኩዋ፥ ኡባካ ብራፐ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ጾሳ ዱንካንያዉ ሁጲሳ ባጋና፥ ላታሙ ጻጋግያዋ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","እት እት ጻጋግያዉ ላኡ ገደቱ፥ ሙለ ኦይታሙ ገደቱ፥ ብራፐ ጊግኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ቃይ ጾሳ ዱንካንያዉ ጉየ ጋጻን አዋይ ዉልያ ባጋና ኡሱፑን ጻጋግያ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ጉየን ደእያ ጋጻቶ ላኡ ጻጋግያ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ሄዋ ድራዉ፥ እት ጻጱዋን ላኡ ፖꬃ ጊጋ ጼራ ጋካናዉ እታ ግድ ምግዱዋን ኦይቀታናዉ በሴ፤ ላኡ ጋጻ ኦይꬅያ ጻጋጋቱካ ሀራ ጻጋጊ ኦሰቶዋዳን ኦሰታናዉ በሴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ሄዋ ድራዉ እት እት ጻጋግያዉ ጋርሳና ላኡ ላኡ ፖꬃይ ገልያ ሉካቱ ደኢኖ፤ ኡባና ሆስፑን ጻጋገቱነ ብራፐ ኦሰቴዳ ታማነ ኡሱፑን ፖꬃይ ገልያ ሉካቱ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“ቃይ ኦዶሮቱዋፐ ቱቁመትያ ሜጋ ከሳ። ጾሳ ዱንካንያዉ እት ባጋ ምይያን ደእያ ጻጋገቶ እቼሹ ቱቁመትያ ሜጋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ቃይ የንኮ ባጋ ምይያን ደእያ ጻጋገቶ እቼሹ ቱቁመትያ ሜጋቱዋ ጊግሳ። ሄዋዳንካ፥ ጾሳ ዱንካንያዉ ጉየ አዋይ ዉልያ ባጋና ዉርሰꬃ ጋጻን ደእያ ጻጋገቶ እቼሹ ቱቁመትያ ሜጋ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ግዶ ቱቁመትያ ሜጋይ ጻጋገቶ ግዶ ሄራና ሀ ጋጻፐ ያ ጋጻ ጋካናዉ ፕን ከሳናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ጻጋገቱዋ ዎርቃን ሼሻደ፥ ቱቁመትያ ሜጋቱ አꬍያ ሳጋየቱዋ ዎርቃፐ መꬋ፤ ቃይ ቱቁመትያ ሜጋቱዋካ ዎርቃን ሼሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ጾሳ ዱንካንያ ታን ኔና ደርያ ቦላን በሴዳዋዳን ኦꬃደ ቶካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ እት ጋርዱዋ ኪተታ፤ ሄ ጋርዱዋ ቦላ እት ሂላን ክሩበቱዋ ምስልያ ስክሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ያታደ ዎርቃን ሼሼዳ ኦይዱ፥ ኦዶሩዋ ቱሳቱዋን ደእያ ዎርቃፐ ኦሰቴዳ ካቂያዋን ካቃ። ሄ ኦይዱ ቱሳቱ ብራፐ መꬌዳ ኦይዱ ፖꬃይ ገልያሳን ገልኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ሄ ጋርዱዋ ጾሳ ዱንካንያ ካራን ደእያ ኦይቂያዋንቱፐ ጋርሳና ካቄዳ፥ ቃላ ጫቁዋ ታቦታ ጋርዱዋፐ ጉየ ባጋን ዎꬃ፤ ያቶፐ ሄ ጋርዱ ጌሻ ሳኣ ኡባፐ አꬌዳ ጌሻ ሳኣፐ ሻካና። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","አቶ ግያ ሳኣ ቁምእያ ኡባፐ አꬌዳ ጌሻ ሳኣን ደእያ ቃላ ጫቁዋ ታቦታ ቦላ ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ጻርጴዛ ጋርዱዋፐ ካረና፥ ጾሳ ዱንካንያን ጌሻ ሳኣ ግዱዋን ሁጲሳ ባጋን ዎꬃ፤ ጾምፕያ ዎꬅያ ባላ ቃይ አ ባጋን ገድሳ ባጋና ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“ዱንካንያ ገልያ ፐንግያዉ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ ጽልፕያን አሌቅስያዋን ኦሰቴዳ ጋርዱዋ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ጋርዱዋ እቼሹ ቱሳቱዋ ኦዶሮቱዋፐ ከሳደ፥ ዎርቃን ሼሻ፤ ካቂያዋንቱካ ዎርቃፐ ኦሰቴዳዋንታ ግድኖ፤ ቱሳቶ ናሃስያ ብራታፐ ትጋደ እቼሹ ፖꬃቱ ገልያዋ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“ኦዶሩዋፐ ያርሽያ ሳኣ ኬጻ። ሄ ያርሽያ ሳአዉ ጌሳይ እቼሹ ዋꬋ ግዶ፤ ጎምፓይነ እት ልከ፥ እቼሹ እቼሹ ዋꬋ፤ ꬎቃተꬃይ ሄዙ ዋꬋ፥ ኦይዱ ጋጻና ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ዉርሰꬃ ጋጻን ጋጻን እት እት ካጭያ መꬋ፤ ካጨቱ ያርሽያ ሳኣና እትፐ ኦይቀቲደ መትኖ። ያታደ ያርሽያ ሳኣ ናሃስያ ብራታን ሼሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","አን ጎኤትያ ሚሻቱዋ፥ ብድንꬃ ከስያ ባልደቱዋ፥ አካፋቱዋ፥ ሱꬃ ትግያ ኩይጻሮቱዋ፥ ቃጲያ፥ ሴልያባ ኦይቂያ ሚሻ ናሃስያ ብራታፐ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ያታደ ናሃስያ ብራታፐ ዛዝርያ መꬋ፤ ቃይ አ ኦይዱ ጋጻን ኦይዱ ሳጋየቱዋ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ያታደ ያርሽያ ሳአዉ ግዶ ባጋን ኦይꬃደ ዎꬃ ");
INSERT INTO dwrENT_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ኦዶሩዋፐ ያርሽያ ሳአዉ ካሶቱዋ ከሳደ፥ ናሃስያ ብራታን ሼሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ያርሽያ ሳኣ ቶክያ ዎደ ማዳና ማላ፥ ሄ ካሱዋ ላኡ ምይያና ደእያ ሳጋየቱዋን አꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ታን ኔና ደርያ ቦላን በሴዳዋዳን፥ ያርሽያ ሳኣ ጻዉላፐ መꬊደ፥ ጎምፓ መላ ከስኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“ጾሳ ዱንካንያዉ አሳይ ሺቅያ ዳባባ ጊግሳ። ዳባባይ ገድሳ ባጋና ጼቱ ዋꬋ አዱቆ፤ ሄ ዳባባዉ ሊቆ ሊኑዋፐ ዳደቴዳ ጋርዳቱዋ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","አዉ ናሃስያ ብራታፐ ላታሙ ቱሳቱዋነ ቱሳቱ ኤቂያ ላታሙ ፖꬃይ ገልያ ሉኩዋ ኦꬃ፤ ኡንቱንቱ ሁጲያን ቃይ ብራፐ ካቂያዋንታነ ቱሳቱዋ ሁጲያን ቃችያዋንታ ኦꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ሄዋዳንካ፥ ዳባባዉ ሁጲሳ ባጋና ጼቱ ዋꬋ አዱቆ፤ ቃይ ላታሙ ቱሳቱዋናነ ሄ ቱሳቶ ላታሙ ናሃስያ ፖꬃይ ገልያ ሉኮቱዋና ደእያ ጋርዱ ደኦ። ያቲደ ብራፐ ኦሰቴዳ ካቂያዋንቱነ ቱሳቱዋ ሁጲያን ቃችያዋንቱ ዳባባዉ ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“ዳባባዉ አዋይ ዉልያ ባጋ ጎምፓይ እሻታሙ ዋꬋ አኮ፤ ታሙ ቱሳቱነ፥ ቱሳቶ ታሙ ፖꬃይ ገልያ ሉካቱ ደእያ ጋርዶቱ አዉ ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ቃይ አዋይ ዶልያ ባጋ ዳባባ ጎምፓይካ እሻታሙ ዋꬋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ዳባባ ገልያ ሳኣፐ አዋይ ዶልያ ባጋና ታማነ እቼሹ ዋꬋ አዱቂያ ጋርዶቱ ደእኖ፤ ኡንቱንቶ ሄዙ ቱሳቱነ ሄዙ ፖꬃይ ገልያ ሉኮቱ ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ሄዋዳንካ፥ ህንኮ ባጋና ጋርዶቱ ታማነ እቼሹ ዋꬋ አዱቂያ ጋርዶቱ ደእኖ፤ ኡንቱንቶ ሄዙ ቱሳቱነ ቱሳቶ ሄዙ ፖꬃይ ገልያ ሉኮቱ ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“ዳባባ ገልያ ሳአዉ ላታሙ ዋꬋ አዱቂያ ጋርዱዋ ጊግሳ፤ ሄዌካ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ፥ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ ዳደቴዳዋ፥ ጽልፕያን አሌቅስያዋን ጊግሳ። ኦይዱ ቱሳቱዋነ ቱሳቶ ኦይዱ ፖꬃይ ገልያ ሉኮቱዋ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ዳባባ ዩሹዋን ደእያ ቱሳቱዋ ኡባዉ ብራፐ ኦሰቴዳ ቃችያዋንቱነ ካቂያዋንቱ፥ ናሃስያፐ ኦሰቴዳ ፖꬃይ ገልያ ሉኮቱ ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ዳባባይ አዱሳተꬃይ ጼቱ ዋꬋ፥ ጎምፓይ እሻታሙ ዋꬋ ግዶ፤ ፑድያ እቼሹ ዋꬋ ꬎቂያ ሊቁዋን ዳደቴዳ ሊኑዋፐ ኦሰቴዳ ጋርዶቱ ደእኖ፤ ያቲደ ቱሳቱዋ ናሃስያፐ ኦሰቴዳ ፖꬃይ ገልያ ሉኮቱ ግድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","“ጾሳ ዱንካንያን ኦꬅያ ኦሶ ጎኤትያ ሚሻ ኡባይ፥ ኡንቱንቱ ጎአይ አያ ግዶፐነ፥ ጾሳ ዱንካንያ ꬎገቱ ኡባናነ ዳባባ ꬎገቱ ኡባናካ ጉጅና፥ ናሃስያ ብራታፐ መቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“ጾምፒ ቶኤናን ኤጺደ ደአና ማላ፥ አዉ ኮሽያ ጽሎ ዛይትያ ዎጋራ ቴራ ጫዲደ ጉምእና ከሴዳዋ ነዉ አሀና ማላ፥ እስራኤላቱዋ አዛዛ። ");
INSERT INTO dwrENT_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","አሮነነ አ ናናይ፥ ጾምፒ ጾሳ ስንꬃን ቃሜዳ ሳአይ ዎንታና ጋካናዉ ፖአና ማላ፥ መꬍና ጎዳ ዱንካንያ ግዶን፥ ማርካተꬃ ታቦታ ስንꬃን ደእያ ጋርዱዋፐ ካረና ኤꬅኖ። ሀዌ እስራኤልያ አሳዉ መꬍናዉ ዎꬆ ዎጋ ግዲደ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“ነ እሻ አሮናነ አ ናና ናዳባ፥ አቢሀ፥ ኤልኣዛራነ እታማራ ኔኮ አሃደ፤ ኡንቱንቱ ቄሳቱዋ ግዲደ ታዉ ኦꬃና ማላ፥ እስራኤልያ አሳ ግዶፐ ኡንቱንታ ዱማያ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","አዉ ቦንቹዋነ ፑላ እማና ማላ፥ ነ እሻ አሮናዉ ቄሳተꬃ ማዮቱዋ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ታን አꬌዳ ኤራ እሜዳ ኩሽያ ሂላ ኤርያ አሳ ኡባ ጼሳደ፥ አሮናዉ ማዮቱዋ ጊግሳና ማላ ኦዳ፤ እ ቄሴ ግዲደ፥ ታዉ ኦꬃናዉ ዱማታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ኡንቱንቱ ጊግሳና ማዮቱካ ሀዋንታ: ትራን ዎꬅያዋ፥ ኤፉድያ፥ አዱሳ ማዩዋ፥ አሌቀቲደ ዳደቴዳ አዱሳ ሻምጭያ፥ ሻሽያነ ሀራ ዳንጩዋ። ነ እሻይ አሮነነ አ ናናይ ቄሳቱዋ ግዲደ ታዉ ኦꬂደ ጌሻ ማዮቱዋ ማያና ማላ፥ ስክያዋንቱ ጊግሲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ኩሽያ ሂላ ኤርያዋንቱካ ሀ ማዮቱዋ ጊግሳናዉ ዎርቃ፥ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናነ ሊቆ ሊኑዋ ጎኤትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ኤፉድያ ጌተትያ ማዩዋ ዎርቃፐ፥ ሳሉዋ ማላትያ ቃጭናፐ፥ ኦቻ ቴራ ማላትያ ቃጭናፐ፥ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋ ቃጭናፐ ኩሽያ ሂላንቻቱ አሌቂሲደ ጊግሲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ላኡ ባጋይ ጋከቲደ እቱዋ ግዳና ማላ፥ ላኡ ሀሽያ ቦላ ጋꬂደ ኦይꬅያ ጫርቂ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ሂላንቻይ አሌቂሲደ ዳዴዳ ዳንጩካ ኤፉድያና እታ ግዲደ፥ ዎርቃፐ፥ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሌእስ ባቄዳ ሊኑዋፐ ኦሰቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“ማርግድያ ጌተትያ ላኡ ሹቻቱዋ አሃደ፥ እስራኤልያ ናናቱዋ ሱንꬃ ኡንቱንቱ ቦላ ዎጫደ ጻፋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ኡንቱንቱ የለታ ማራዳን እት ሹቻ ቦላ ኡሱፑን ሱንꬃ፥ ህንኮ ሹቻ ቦላ ቃይ አቴዳ ኡሱፑናቱዋ ሱንꬃ ዎጫደ ጻፋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ማታፋ ቦላ ሱንꬃ ዎጪደ ጻፍያዋዳን፥ ሄ ላኡ ሹቻቱዋ ቦላ እስራኤልያ ናናቱዋ ሱንꬃ ዎጫደ ጻፋ፤ ሄ ሹቻቱዋ ዎርቃፐ መꬌዳ ሹቻ ኦይቂያዋ ቦላ ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ያታደ ታማነ ላኡ እስራኤልያ ዘረꬃ ሀሳይያዋ ግዳና ማላ፥ ሀ ላኡ ሹቻቱዋ ኤፉድያና ኦይꬄዳ ሀሽያ ጫርቂያን ዎꬃ፤ ያቶፐ መꬍና ጎዳ ስንꬃን ኡባደ ቆፈታና ማላ፥ ሀ ሱንꬃቱዋ አሮነ ባረ ሀሽያን ቶኮ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ሄ ሹቻቱዋ ኦይቂያዋ ዎርቃፐ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ቃይ ዋላካይ ባይና ዎርቃፐ ዎዶሩዋዳን ዶቄዳ ላኡ ሳንሳላታቱዋ ጊግሳደ፥ ሄ ላኡ ሹቻ ኦይቂያዋንቱና ጋꬃ ኦይꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“ጾሳ ሸኒ አየንቶ ኦቺደ ኤርያ ትራን ዎꬅያዋ ኩሽያ ሂላንቻን ኦስሳ። ሄ ትራን ዎꬅያዋ ኤፉድያ ዳዴዳዋዳን፥ ዎርቃፐ፥ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ ዳዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","አዉ ኦይዱ ጋጻይ ደኤ፤ ጌሳይካ ጎምፓይ እት እት ታካ ግዲደ ዳኮቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ሄዋፐ ጉይያን አ ቦላ ኦይዱ ማራን አልኦ ሹቻቱዋ ዎꬃ፤ ኮይሮ ማራን ዎꬄዳ ሹቻይ፥ ሳርድዮና፥ ቶጳዝዮንያነ ጶልያ እንቁዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ላኤንꬆ ማራን ባሉርያ፥ ሳምፔርያነ አልማዝያ ግያ አልኦ ሹቻቱዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ሄዘንꬆ ማራን ያክንትያ፥ ከልቀዶንያነ አመተስጽኖስያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ኦይደንꬆ ማራን ብራል፥ ማርግድያ፥ ያስጲድያ። ሀዋንቱ ኡባይ ዎርቃፐ ኦሰቴዳ ሹቻ ኦይቂያዋ ቦላ ኡትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","እስራኤልያ ናናቱዋ ሱንꬃ ፓይዱዋዳን፥ ሹቻቱዋ ፓይዱካ ታማነ ላኡዋ ግድኖ፤ እቱ እቱ ማታፋዳን ዎጨቲደ፥ ታማነ ላኡ ዛራቱዋ ሱንꬃይ ሄ ሹቻቱዋን ጻፈቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ትራን ዎꬅያዎ ዎዶሩዋዳን ዶቀቴዳ ሳንሳላታ ዋላካይ ባይና ዎርቃፐ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ላኡ ዎርቃ ምግዳቱዋ መꬋደ፥ ትራን ዎꬅያዎ ቆሞ ጋጻ ጋꬃደ ኦይꬃ ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ሄ ላኡ ዎርቃ ሳንሳላታቱዋ ትራን ዎꬅያዎ ጋጻን ደእያ ምግዶቱዋና ጋꬃደ ኦይꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ሄ ሳንሳላታቶ የንኮ ባጋ ጼራ ቃይ ኤፉድያዉ ስንꬃ ባጋና፥ ሀሽያ ጫርቂያን ደእያ ሹቻ ኦይቂያዋንቱና ጋꬃ ቃቻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ቃይካ ላኡ ዎርቃ ምግዳቱዋ መꬋደ፥ ኤፉድያፐ ጋርሳን ካሊደ ደእያ ትራን ዎꬅያዎ ሶ ባጋና ደእያ ላኡ ጋጻ ጼራን አꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ሄዋዳንካ፥ ዎርቃፐ ሀራ ላኡ ምግዳቱዋ መꬋደ፤ ኤፉድያዉ ስንꬃ ባጋና፥ ሀሽያ ጫርቂያፐ ጋርሳ ባጋና፥ ኤፉድያ ጼሳን ቃችያዋፐ ቆሞና፥ ስኩ ጋከቴዳ ሳኣ ማታን ካረና ኡንቱንታ ኦይꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ትራን ዎꬅያዋን ደእያ ምግዳቱዋ ኤፉድያን ደእያ ምግዶቱዋና ጋꬂደ፥ ሳሉዋ ማላትያ ባቀꬃን ቃቻ፤ ያቶፐ፥ ትራን ዎꬅያዌ ጼሳፐ ቆሞና ደእያ ድራዉ፥ ቃሹ ሾልኤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“አሮነ ጌሻ ሳኣ ገልያ ዎደ፥ ሀ ትራን ዎꬅያ መꬍና ጎዳ ሸንያ በስያዌ ደእያ እስራኤልያ ዛራቱዋ ሱንꬃቱዋ ቶኮ። ያቶፐ ታን መꬍና ጎዳይ ኡባደ ታ አሳ ሀሳያና። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ቃይ ኡሪምያነ ቱሚምያ ጌተትያዋንታ ትራን ዎꬅያዋን የጋ። አሮነ መꬍና ጎዳ ስንꬃ አꬊደ፥ ባረ ትራን ዎꬅ አኪደ ገሎ። ታ ሸኒ አየንቶ እስራኤልያ አሳ ኤርሳና ማላ፥ እ ታ ስንꬃን ኦꬃናዉ ገልያ ዎደ ኡባን ባረ ትራ ኪስያፐ ꬋይሶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ኤፉድያፐ ጋርሳና ማይያ አዱሳ ማዩዋ ኡባ ሳሉዋ ማላትያ ጫርቂያፐ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ሄ አዱሳ ማዮ ቆꬍያ አꬅያ ሳኣ መꬋ። ሄ ሳአይ ፔተናዳን፥ ዩሻ አꬃደ ጉጃ ጉጃ ስካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","አዱሳ ማዩዋ ዱገ ባጋ ማጫራ ዩሹዋን ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ሮማንያ አይፍያ ቴራ ምስለቱዋ መꬋ። ያታደ ኡንቱንቱ ግዱዋን ዎርቃፐ ኦሰቴዳ ዳዋላቱዋ ዋላካን ኦꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ዎርቃ ዳዋላቱነ ሮማንያ ቴራ ምስለቱ ሄ አዱሳ ማዩዋ ዱገ ባጋ ጼራዉ ዩሹዋን ዋላካን አꬍኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","አሮነ ቄሳተꬃን ኦꬅያ ዎደ፥ ሀ አዱሳ ማዩዋ ማዮ፤ መꬍና ጎዳ ስንꬃ ጌሻ ሳኣ ገልያ ዎደነ ከስያ ዎደ፥ ዳዋላይ ዋሳና። ሄዋ ድራዉ እ ሀይቀና። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“ዋላካይ ባይና ዎርቃፐ እት አሌቁዋ መꬋደ ማታፋ ቦላ ዎጭያዋዳን፥ አ ቦላ ዎጫደ፥ ‘መꬍና ጎዳዉ ጌሻ ግዲደ ዱማቴዳ’ ያጋደ ጻፋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ሁጲያን ጻጽያ ሻሽያፐ ጻደና ዴሙዋን ቃቻና ማላ፥ ሳሉዋ ማላትያ ባቀꬃ አን አꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","አሮነ አ ባረ ዴሙዋን ዎꬆ፤ ሄዋን እስራኤልያ አሳይ መꬍና ጎዳዉ ጌሻ ያርሾ እምያዋን ፓጫይ ደኦፐ፥ ሄ ባይዙዋ አሮነ ቶኬ። አሳይ አህያዋ ኡባ መꬍና ጎዳይ አካና ማላ፥ እ ሄዋ ኡባ ገደካ ባረ ደሙዋን ዎꬃናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“አሮና አዱሳ ሻምጭያ ሊቆ ሊኑዋፐ ዳዳ፤ ሁጲያን ጻጽያ ሻሽያካ ሊኑዋፐ ጊግሳ። ቃይ ዳንጩዋ ጽልፕያን አሌቅስያዋን ስክሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","አሮና ናናዉ ቦንቾነ አሌቆ ግዳና ማላ፥ አዱሳ ሻምጭያ፥ ዳንጮቱዋነ ሁጲያን ጻጽያ ሻሸቱዋ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ኔን ሀ ማዮቱዋ ነ እሻ አሮናነ አ ናና ማይዜዳዋፐ ጉይያን፥ ኡንቱንታ ቄሰተꬃን ሱንꬃደ ታዉ ኦꬃና ማላ ኦካደ ዱማያ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“ኡንቱንቱ ካሉ ካመታና ማላ ጋርሳና ማይያ ማዩዋ፥ ጼሳፐ ቢደ ዎድርያ ጋካናዉ ካምያዋ፥ ሊቆ ሊኑዋ ቃጭናፐ ዳዳደ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","አሮነነ አ ናናይ ጾሳ ዱንካንያ ገልያ ዎደ፥ ዎይ ያርሹዋ ያርሽያ ጌሻ ሳኣን ቄሳተꬃን ኦꬃናዉ ሺቅያ ዎደ፥ ሀ ማዮቱዋ ማይኖ። ሄዋዳን ሀኖፐ፥ ኡንቱንቱ ባረንቱ ቦላ ባይዙዋነ ሀይቁዋ አህክኖ። “ሀዌ አሮናዉነ አ ዛረቶ መꬍናዉ ዎጋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“አሮነነ አ ናናይ ቄሳቱዋ ግዲደ ታዉ ኦꬃና ማላ፥ ኔን ኡንቱንታ ዱማያናዉ ሀዋዳን ኦꬃ፤ ትላ ቦላና ደእያ እት ኮሩማ፥ ላኡ ዶርሳ ኮለቱዋ አካ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ሙሩታ ዛርጋ ꬊልያ አካደ፥ እርሹዋ የገናን ኡክꬃ ኡካ፤ ቃይ እርሹዋ የገናን ዛይትያን ኮምፑዋ ኮምፓ፤ ሄዋዳንካ፥ እርሹዋ የገናን ሌኦ ኡክꬃ ኡካደ፥ ዛይትያ ኦካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ኔን ኡንቱንታ ሳምፓን ዎꬃደ፥ ኮሩማናነ ላኡ ዶርሳ ኮለቱዋና እትፐ ታዉ ሺሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“ያታደ አሮናነ አ ናና ጾሳ ዱንካንያ ፐንገ አሃደ፥ ሃꬃን ኡንቱንታ ሜጫ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ሄዋፐ ጉይያን ማዮቱዋ አካደ፥ አዱሳ ሻምጭያ፥ ኤፉድያ ጋርሳና ማይያ አዱሳ ማዩዋ፥ ኤፉድያነ ትራን ዎꬅያዋ አሮና ማይዛደ ኤፉድያ ሂላን ዳደቴዳ ዳንጩዋን ዳንጭሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ሻሽያካ አ ሁጲያን ጻጻደ፥ ‘ጾሳዉ ጌሻ ግዲደ ዱማቴዳ’ ያግያዌ ጻፈቴዳ አሌቁዋ ስንꬃ ደሙዋን ሻሽያ ምይያን አꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ኦክያ ዛይትያካ አካደ፥ አ ሁጲያን ትጋደ ኦካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","አ ናናካ አሃደ አዱሳ ሻምጭያ ማይዛ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ሻሽያካ ኡንቱንቱ ሁጲያን ጻጻ። ሄዋፐ ጉይያን አሮናነ አ ናና ዳንጩዋ ዳንጭሳ። ቄሳተꬃይ ኡንቱንቶ መꬍና ዎጋ ግዶ። ስም አሮናነ አ ናና ያታደ ቄሳቱዋ ኦꬃሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ኮሩማ፥ ጾሳ ዱንካንያ ስንꬃ ኔን አህና፥ አሮነነ አ ናናይ አ ሁጲያን ባረንቱ ኩሽያ ዎꬂኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ኮሩማ፥ መꬍና ጎዳ ዱንካንያ ገልያ ፐንግያን መꬍና ጎዳ ማታን ሹካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ኮሩማ ሱꬃፐ አማሬዳዋ ነ ብራꬍያን አካደ፥ ያርሽያ ሳኣ ቦላ ደእያ ካጨቱዋ ኦክሽን አቴዳዋ ያርሽያ ሳኣፐ ጋርሳ ባጋና ጉሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ሄዋፐ ጉይያን ቃንꬃ አሹዋ ካሜዳ ሞꬍያ ኡባ፥ ትርያ ጼራ ቦላ ደእያ ሞꬍያ፥ ላኡ ክላሆቱዋነ ኡንቱንታ ካሜዳ ሞꬍያ አካደ፥ ያርሽያ ሳኣ ቦላ ጹጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ሽን ኮሩማ አሹዋ፥ አ ጋልባነ አ ማራጭያን ደእያ ቶጪያ አሳይ ኡቶ ሄራፐ ሃሳደ ጹጋ፤ ሄዌ ናጋራ ድራዉ ያርሽያ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ላኡ ዶርሳ ኮለቱዋፐ እቱዋ ኔን አክና፥ አሮነነ አ ናናይ ባረንቱ ኩሽያ አ ሁጲያን ዎꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ያቶፐ ዶርሳ ኮልያ ሹካደ፥ ሱꬃ ያርሽያ ሳኣ ምይያን ኡባ ሳኣን ፑሻካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ዶርሳ ኮልያ አሹዋ ቃንጸሬꬃደ፥ ቃንꬃ አሹዋካ ገድያ ሜጫደ ሁጲያ ቦላነ ሀራ ቆሞ አሾቱዋ ቦላ ኡንቱንታ ዎꬃ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ሄዋፐ ጉይያን፥ ዶርሳ ኮልያ ኡባና ያርሽያ ሳኣን ጹጋ፤ ሄዌ መꬍና ጎዳዉ ጹገትያ ያርሹዋ፥ ሳዉዋ ቶሽኩ ግያ ያርሹዋነ መꬍና ጎዳዉ ታማን ያርሽያ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ቃይ የንኮ ዶርሳ ኮልያ አሮነነ አ ናናይ ባረንቱ ኩሽያ አ ሁጲያን ዎꬃና ማላ ኔን አሀ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ሄ ዶርሳ ኮልያ ሹካደ፥ አ ሱꬃፐ አማሬዳዋ አካደ፥ አሮናዉነ አ ናናዉ ኡሸቻ ሀይꬃቱዋ ጼራ፥ ኡንቱንቱ ኡሸቻ ኩሸቶ ዎጋ ብራቱዋነ ኡንቱንቱ ኡሸቻ ገደቶ ዎጋ ብራቱዋ ኦካ፤ ሄዋፐ ጉይያን፥ አቴዳ ሱꬃ ያርሽያ ሳኣ ምይያን ኡባ ሳኣን ፑሻካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ያርሽያ ሳኣን ደእያ ሱꬃፐ አማሬዳዋነ ትግያ ዛይትያፐካ አማሬዳዋ አካ፥ አሮና ቦላነ አ ማዩዋ ቦላ፥ አ ናናቱዋ ቦላነ ኡንቱንቱ ማዩዋ ቦላ ፑሻካ። እነ አ ናናይ፥ ኡንቱንቱ ማዩ ጾሳ ኦሶ ዱማታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“ሀ ዶርሳ ኮልያፐ ሞꬉዋ፥ ናስያ፥ ቃንꬃ አሹዋ ቦላ ደእያ ሞꬍያ፥ ትርያ ጼራ ቦላ ደእያ ሞꬍያ፥ ላኡ ክላሆቱዋ፥ ኡንቱንታ ካሜዳ ሞꬍያነ ኡሸቻ ባጋና ደእያ ጉየ ገድያ አካ፤ ሀዌ ቄሳተꬃ ሱንꬃ እምያ ዎደ ሹክያ ዶርሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","መꬍና ጎዳ ስንꬃን ዎꬄዳ እርሹ ገልቤና ኡክꬃ፥ ሳምፓፐ ዛይቲ ዋላከትቤና ኡክꬃ፥ ዛይትያና ኡኬዳ እት ኮምፑዋነ እት ሌኦ ኡክꬃ አካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ኔን ሀ ቁማ ኡባ አሮና ኩሽያንነ አ ናናቱዋ ኩሽያን ዎꬂደ ዉጻካናዳን ኦꬃ። ኡንቱንታ መꬍና ጎዳ ስንꬃን ፑደነ ዱገነ ቃꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ሄዋፐ ጉይያን ኡንቱንቱ ኩሽያፐ ሀዋንታ አካደ፥ ያርሽያ ሳኣ ቦላ ዎꬃደ፥ ጹግያ ያርሹዋና ጋꬃደ፥ መꬍና ጎዳዉ ሳዉዋ ቶሽኩ ጋናዳን፥ ያርሽያ ሳኣ ቦላ ታማን ጹጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","አሮነ ቄሳ ግዲደ ሱንትያ ዎደ ሹኬዳ ዶርሳ ኮልያ አንጎሱዋ አካደ፥ መꬍና ጎዳ ስንꬃን ቃꬅያ ያርሹዋዳን ቃꬃ፤ ሄዌ ኔና ጋክያ ነ ምያ ግሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“ሄ ሹኬዳ ዶርሳ አሹዋ ቆሞቱዋፐ፥ ያርሹዋ ኦꬂደ ቃꬄዳ አንጎሱዋነ ጾሳ ስንꬃን ፑደ ቶኬዳ ገድያ ጌሻ፤ ሄዋንቱ አሮናዉነ አ ናናዉ ግሹዋ ግዳናዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","እስራኤላቱ መꬍና ጎዳዉ እምያ እትፐተꬃ ያርሹዋፐ ቃꬅያ ባጋዉ ዎጋይ፥ ኡባ ገደካ እስራኤልያ አሳፐ ሺቆደ አሮናዉነ አ ናናዉ ጋክያ ግሹዋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“አሮና ቄሳተꬃ ጌሻ ማዩ አ ሀይቁዋፐ ጉይያን አ ዛረቶ ደኦ፤ ኡንቱንቱ ቄሳቱዋ ካፑዋ ግድያ ዎደ ሀ ማዩዋ ኦከታናዉነ ዱማታናዉ ማይኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","አ ናናቱዋፐ አ ሳኣን ቄሳቱዋ ግዲደ፥ ጌሻ ሳኣን ኦꬃናዉ ጾሳ ዱንካንያ ይያ ናአይ፥ ሄ ማዩዋ ላፑን ጋላሳዉ ማዮ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“አሮነነ አ ናናይ ቄሳቱዋ ግዲደ ሱንትያ ዎደ ሹከቴዳ ዶርሳ ኮልያ አሹዋ አካደ፥ ጌሻ ሳኣን ዶይሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","አሮነነ አ ናናይ ዶርሳ ኦርግያ አሹዋካ ማሶፍያን ደእያ ኡክꬃ ጾሳ ዱንካንያ ገልያ ፐንግያን ሚኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ኡንቱንቱ ቄሳቱዋ ግዲደ ሱንታናዉነ ዱማታናዉ ናጋራይ አቶ ጌተታናዳን ያርሸቴዳ ሀ ያርሾቱዋ ሚኖ። ሽን ሄ ያርሾቱ ጌሻ ግዴዳ ድራዉ፥ ሀራ አሳይ ኦነ ሞፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ቄስያ ግዲደ ሱንትያ ዎደ ሹኬዳ ዶርሳ ኮልያ አሹዋፐ ዎይ ኡክꬃፐ ዎንታ ጋካናዉ ፓላሂደ አቆፐ፥ ታማን ጹገቶ፤ ጌሻ ግዴዳ ድራዉ ሜተቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“አሮነነ አ ናናይ ቄሳቱዋ ግዲደ ሱንትያ ዎደ ዎꬅያ ዎጋ ልከ ታን ኔና አዛዜዳዋዳን ኦꬃደ፥ ላፑን ጋላሳ ጋርሳን ፖላ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ናጋራይ አቶ ጌተታናዳን ሀቼ ሀቼ ናጋራ ያርሹዋዳን እት ኮሩማ ያርሻ። ሄዋን ያርሽያ ሳኣ ጌሻ፤ ያታደ ያርሽያ ሳኣ ዱማያናዉ ኦካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ያርሽያ ሳኣ ናጋራ አቶ ግያ ዎጋ ላፑን ጋላሳን ፖላደ፥ አ ዱማያ። ያቶፐ ያርሽያ ሳአይ ጌሻ ኡባፐ እቱዋ ግዴዳ ጌሻ። አ ቦችያ ኡባይካ ጌያና። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ያርሽያ ሳኣን ኔን ሀቼ ሀቼ ሺሻና ያርሹ ሀዋ። የለቶደፐ እት ላይꬃ ግዴዳ ላኡ ዶርሳ ኦርገቱዋ ያርሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ዶርሳ ኮለቱዋፐ እቱዋ ዎንታ፥ ቃይ ላኤንꬁዋ ኦማርስ ያርሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ኮይሮ ዶርሳ ማራና እት ኪሎ ግራመ ግዴዳ ሙሩታ ዛርጋ ꬊልያ እት ሊትሮ ጉምኤቴዳ ዛይትያን ሙናቃደ ያርሻ፤ እት ሊትሮ ዎይንያ ኤሳካ ኡሻ ያርሹዋ ኦꬃደ ያርሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ላኤንꬆ ዶርሳ ኦርግያ ኦማርስ ያርሻደ ዎንታዋ ኬሻ፥ ꬊልያ፥ ዛይትያነ ዎይንያ ኤሳ ሺሻ። ሄዌ መꬍና ጎዳዉ ታማን ያርሸትያ፥ ሳዉዋ ቶሽኩ ግያ ያርሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“ሀ ጹግያ ያርሹ ይያ የለታ ኡባን ጾሳ ዱንካንያ ገልያ ፐንግያን መꬍና ጎዳ ስንꬃን ፓጭ ባይናን ያርሸታናዉ ኮሼ። ታን ያን ህንተንቱና ጋከታደ፥ ኔናና ሃሳያና። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ቃይ ያን ታን እስራኤላቱዋና ጋከታናዉ፥ ታ ቦንቹካ ሄ ሳኣ ዱማ ሳኣ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“ሄዋ ድራዉ፥ ታን ጾሳ ዱንካንያነ ያርሽያ ሳኣ ዱማያና፤ ኡንቱንቱ ታዉ ቄሳቱዋ ግዲደ ታዉ ኦꬃና ማላ፥ አሮናነ አ ናና ታን ዱማያና። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ያታደ ታን እስራኤለቱዋ ግዶን ደአና፤ ቃይ ታን ኡንቱንቱ ጾሳ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ታን ኡንቱንቱ ግዶን ደአና ማላ፥ ግብጼፐ ኡንቱንታ ከሴዳ መꬍና ጎዳ ኡንቱንቱ ጾሳ ግድያዋ ኡንቱንቱ ኤራና። ኤ፥ ታን መꬍና ጎዳ ኡንቱንቱ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“እጻና ጩዋይያ ሚሻ ኦዶሮቱዋፐ መꬋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","አዉ ኦይዱ ጋጻይ ደኦ፤ አዱሳተꬃይ እት ዋꬋ፥ ጎምፓይ እት ዋꬋ፥ ጌሳይ ላኡ ዋꬋ ግዶ፤ ካጨቱካ አናና እቱዋ ግዲደ ኦይቀት መትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","አዉ ቦላ ዶና፥ ኦይዱ ባጋ ኡባነ አ ካጨቱዋ ዋላካይ ባይና ዎርቃን ሼሻ፤ አ ዩሹዋንካ ዎርቃ ትገꬃ ዩሻ አꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ሄ ዎርቃ ትገꬃፐ ጋርሳና እጻና ጩዋይያ ሳጽንያዉ ዎርቃፐ ላኡ ሳጋየቱዋ መꬋ፤ ያታደ ያ ባጋናነ ሀ ባጋና ላኡዋ ላኡዋ ኦይꬃ። ሄዋንታ ቶክያ ዎደ ካሱዋ አꬃናዉ ማዳናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ካሶቱዋ ኦዶሮቱዋፐ ከሳደ፥ ኡንቱንታ ዎርቃን ሼሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ሀ ያርሽያ ሚሻ ቃላ ጫቁዋ ታቦታ ስንꬃን ካቀቴዳ ጋርዱዋፐ ካረ ባጋና፥ ሄዋካ ታን ኔናና ጋከትያ ቃላ ጫቁዋ ታቦታ ቦላ ደእያ አቶ ግያ ሳኣ ቁምእያ ስንꬃን ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“አሮነ ዎንታ ዎንታ ጾምፐቱዋ ጊግሳናዉ ይያ ዎደ፥ ሳዊያ እጻና ያርሽያ ሳኣን ጩዋዮ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","አሮነ ኦማርስ ጾምፐቱዋ ፖእስያ ዎደ፥ ዛረꬂደካ እጻና ጩዋዮ፤ ያቶፐ፥ እጻናይ መꬍና ጎዳ ስንꬃን ይያ የለታዉ ኡባደ ጩዋታና። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ሀ እጻና ጩውስያ ሚሻን ሀራ አይ እጻናነ፥ ዎይ ጹግያ ያርሹዋ፥ ዎይ ካꬃ ያርሹዋ ያርሾፓ፤ ኡሻ ያርሹዋካ አ ቦላ ትጎፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","አሮነ ላይꬃፐ እት ገደ ናጋራፐ ማረታናዉ ሹክያ መህያ ሱꬃ አኪደ፥ ሄ ያርሽያ ሳኣ ቦላ ደእያ ካጨቱዋ ቦላ ዎꬆ። ያቲደ ጌሽያ ዎጋ ፖሎ። ሀ ዎጋይ ስንꬃና ያና ዎደቱዋ ኡባን ላይꬃን ላይꬃን ፖለቶ። ሀ እጻናይ ጩውያ ሚሻይ መꬍና ጎዳዉ ዱማት ሎይꬅ ጌዬዳዋ ግዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ኔን እስራኤልያ አሳ ፓይዱዋን አካናዉ ኡንቱንታ ፓይድያ ዎደ፥ እት እት ኡራይ ፓይደቲደ፥ ባረ ሸምፑዋ ዎዛናዉ መꬍና ጎዳዉ ሻሉዋ ጭጎ። ኔን ኡንቱንታ ፓይድያ ዎደ፥ ኡንቱንቱ ቦላ ቦሻይ ዬና። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ፓይዱዋን ገልያ አሳይ ሁጲያን ሁጲያን ዱንካንያን ኤረትያ ሚዛና ልክያን ብራ ጭጎ። እት እት ኡራይ ሀዋ መꬍና ጎዳዉ እሞታ ኦꬂደ እሞ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ፓይዱዋን ገልያ አሳይ ላይꬃይ ላታሙ ኩሜዳዌነ ሄዋፐ ቦላ ኡባይ፥ መꬍና ጎዳዉ እምያዋ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ህንተንቱ ህንተንቱ ናጋራፐ ማረታናዉ መꬍና ጎዳዉ እሙዋ እምሽን፥ ዱሪካ ማንቁካ እት ልክያ እማናፐ አትና፥ ዱሪ ዳርሲደ ዎይ ማንቁ ላፈꬂደ እሞፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ናጋራፐ ማረታናዉ ጭግያ ሻሉዋ እስራኤልያ አሳፐ አካደ፥ መꬍና ጎዳ ዱንካንያ ግዶ ኦሶ ፔሻ። ሀ ሻሉ ህንተንቱ ናጋራፐ ማረታናዉ፥ መꬍና ጎዳ ስንꬃን እስራኤልያ አሳዋ ሀሳይያዋ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ሜቻ ከርያነ አ ዎꬅያዋ ናሃስያፐ መꬋደ ጾሳ ዱንካንያፐነ ያርሽያ ሳኣፐ ግዱዋን ዎꬃ፤ አን ሃꬃ ትጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","አሮነነ አ ናናይ ባረንቱ ኩሽያነ ባረንቱ ገድያ ሜጨታና። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ኡንቱንቱ ሀይቀና ማላ፥ ጾሳ ዱንካንያ ገልያ ዎደ፥ አዉደነ ሄ ሃꬃን ሜጨትኖ። ቃይ መꬍና ጎዳዉ ታማን ያርሹዋ ያርሻናዉ ያርሽያ ሳኣ ማታ ሺቄዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ኡንቱንቱ ሀይቀና ማላ፥ ባረንቱ ኩሽያነ ባረንቱ ገድያ ሜጨትኖ። ሀዌ አሮናዉነ አ ዛረቶ፥ ይያ የለታ ኡባዉ መꬍናዉ ዎጋ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ሙሩታ ቅማመቱዋ፥ ሄዋንቱካ፥ ኡሱፑን ኪሎ ግራመ ጉክያ ካርቢያ፥ ሄዙ ኪሎ ግራመ ሳዊያ ቃራፋ፥ ሄዙ ኪሎ ግራመ ሳዊያ ጉንጨቻነ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ኡሱፑን ኪሎ ግራመ ዝምባኑዋ አካ። ሀ ኡባይካ ዱንካንያን ኤረትያ ሚዛና ልክያን ግዶ። ሄዋ ቦላካ ኦይዱ ሊትሮ ዎጋራ ዛይትያ ጉጃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ሀዋንታ ሽቱዋ ኦꬅያ ኤራን ዋላካደ፥ ሳዊያ ጌሻ ኦክያ ዛይተ ከሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ያታደ ጾሳ ዱንካንያ፥ ቃላ ጫቁዋ ታቦታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ጻርጴዛነ አ ቦላ ዎꬅያ ሚሻ ኡባ፥ ጾምፕያ ዎꬅያ ባላነ አ ሚሻቱዋ፥ እጻና ጩዋይያ ሚሻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ጹግያ ያርሹዋ ያርሽያ ሳኣነ አን ደእያ ኡባ ሚሻቱዋ፥ ሜቻ ከርያነ አ ዎꬅያዋ ኦካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ኡንቱንቱ ሎይꬅ ጌሻ ግዳና ማላ፥ ኔን ኡንቱንታ ዱማያ፤ ኡንቱንታ ቦችያዌ ኡባይካ ጌሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“ሄዋፐ ጉይያን አሮነነ አ ናናይ ቄሳቱዋ ግዲደ ታዉ ኦꬃና ማላ፥ ኡንቱንታ ኦካደ ዱማያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ሀዌ ይያ የለታዉካ ኦከትያ ታ ጌሻ ዛይተ ግዶ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ሀ ዛይትያ አሳ ቦላን ጉሶፓ፤ ቃይ አይ ዛይቲካ ሄዋ ኦꬄዳ ልክያን ኦꬆፓ። እ ጌሻ ግዴዳ ድራዉ፥ ህንተንቱካ አ ጌሻባዳን ቆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ሀዋ ማላ ሽቱዋ ጊግስያ ኡራይነ ቄሳቱዋ ግደና ሀራ አሳ ኦክያ ኡራይ ኦንነ ባረ አሳ ግዶፐ ቦሄቶ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ሄዋፐ ጉየ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ “ሳዊያ ቅማመቱዋ: ምꬃ ጮሻ፥ ꬋꬍያ ጎለን ደእያ ሽቱዋ፥ ሳዊያ ሽድያነ ሳዊያ ጌሻ እጻና አካ፤ ኡንቱንቱ ኡባ ዴጹካ እት ልከ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ሽቱዋዳን ዋላከቴዳ እጻና ኦꬃደ፥ ኡንቱንቱን ጎኤታ፤ ዋላካይ ባይናዋነ ጌሻ ግዳናዳን፥ አን ማጽንያ የጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","አፐ አማሬዳዋ አካደ ሊቅሳደ ጫዳ፤ ያታደ ታን ኔናና ጋከትያ ጾሳ ዱንካንያ ግዶን ቃላ ጫቁዋ ታቦታ ስንꬃን ዎꬃ። እ ነዉ ሎይꬅ ጌሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ሀዋ መꬌዳዋ ልክያን ሀራ እጻና መꬎፕተ። ሄዌ መꬍና ጎዳዉ ዱማ ጌሻ ግድያዋ ኤርተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ሀዋ ማላትያዋ መꬊደ፥ አ ሳዉዋ ስንጊደ ናሸታናዉ ኮይያ ኡራይ ደኦፐ፥ እ ባረ አሳ ግዶፐ ቦሄቶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“በአ፤ ታን ይሁዳ ዛረ ግዴዳ ሁራ ናኣ ናኣ፥ ኡራ ናኣ፥ ባጻልኤላ ዶራድ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","አ ታን ጾሳ አያናን፥ ሂላን፥ አኬካንነ ኦሱዋ ኡባ ኦꬅያ ኤራን ኩንꬃድ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ሄዌካ ሂላን ኪታ ሀልቹዋ ከሲደ፥ ዎርቃፐ፥ ብራፐነ ናሃስያፐ ዱማ ዱማባ እ ኦꬃናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ሄዋዳንካ፥ ሹቻ ማሲደ ጊግሳናዳንነ፥ ምꬃ ማሳናዉ ሀራ ኦሱዋ ኡባ እ ኦꬃናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","“ሄዋ ቦላካ ቃይ አ ማዳና ማላ፥ ዳና ዛረ ግዴዳ አህሳማካ ናኣ ኦሆልኣባ ሱንꬃድ። ታን ኔና አዛዜዳዋ ኡባ ኡንቱንቱ ኦꬃና ማላ፥ ኩሽያ ሂላ ኤርያዋንቶ ኡባቶ ኤራ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ኡንቱንቱ ኦꬃናዉ: ጾሳ ዱንካንያ፥ ቃላ ጫቁዋ ታቦታ፥ አ ቦላ ዎꬅያ አቶ ግያ ሳኣ ቁምእያ፥ ጾሳ ዱንካንያ ግዶን ጎኤትያ ሚሻ ኡባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ጻርጴዛነ አ ሚሻቱዋ፥ ጾምፕያ ዎꬅያ ባላ ዋላካይ ባይና ዎርቃፐ ኦሰቴዳዋነ አ ሚሻ ኡባና፥ እጻና ጩውስያ ሚሻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ጹግያ ያርሹዋ ያርሽያ ሳኣነ አ ሚሻ ኡባና፥ ሜጨትያ ከርያነ አ ዎꬅያዋና፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ዳደቴዳ ማዩዋ፥ ቄሳቱዋ ኡባቱዋ ካፑ አሮነ ማያና ጌሻ ቄሳተꬃ ማዮቱዋነ አ አቱማ ናናይ ቄሳተꬃ ኦꬂደ ማያና ማዩዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ቃይ ኦከትያ ዛይትያነ ጌሻ ሳአዉ ሳዉዋ ቶሽኩ ግያ እጻና። ኡንቱንቱ ሀዋ ኡባ ታን ኔና አዛዜዳዋዳን ኦꬅኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ ሀዋዳን ያጊደ አዛዜዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“እስራኤልያ አሳ ኔን፥ ‘ታ ሳምባታ ቦንችተ። ሄዌ ታን መꬍና ጎዳይ ህንተንታ ታዉ ጌሻ ኦꬃደ ዶሬዳዋ በስያዋ ግዲደ፥ ያና የለታ ኡባዉ ታፐነ ህንተፐ ግዱዋን ማላታ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ህንተንቶ እ ጌሻ ግድያ ድራዉ፥ ሳምባታ ቦንችተ። አ ቱንስያዌነ ሄ ጋላሳን ኦꬅያ አሳይ ኡባይ አሳ ግዶፐ ሀይቁዋን ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ኡሱፑን ጋላሳቱዋን ኔን ኦሱዋ ኦꬃ፤ ሽን ላፑንꬃ ጋላሳይ መꬍና ጎዳዉ ዱማቴዳ ሸምፖ ሳምባታ፤ ሳምባታ ጋላሳን አይ ኦሶነ ኦꬅያ ኦንነ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","እስራኤላቱ ሀ ሳምባታ ጋላሳ የለታፐ የለታዉ መꬍና ቃላ ጫቁዋ ኦꬂደ ቦንችኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","መꬍና ጎዳይ ኡሱፑን ጋላሳቱዋን ሳሉዋነ ሳኣ መꬌዳ ድራዉነ ቃይ ላፑንꬃ ጋላሳን ታን ኪታ አጋደ ሸምፔዳ ድራዉ፥ ታ ግዱዋንነ እስራኤላቱ ግዱዋን ሀዌ መꬍናዉ ማላታ ግዳና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","መꬍና ጎዳይ ሙሴዉ ሲና ደርያ ቦላን ሃሳይያዋ ዉርሴዳ ዎደ፥ ጾሳይ ባረ ብራꬍያን ጻፌዳ ታሙ አዛዙዋ ኦይቂደ ላኡ ማሰቴዳ ቃላ ጫቁዋ ሹቻቱዋ ሙሴዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","አሳይ ሙሴ ደርያፐ ዎናን ሎይꬅ ጋምኤዳዋ በኤዳ ዎደ፥ አሮና ዩሹዋን ሺቂደ፥ “ሃያ፤ ኔን ኑና ካለꬅያ ጾሳቱዋ ኑዉ መꬋ። ግብጼ ጋድያፐ ኑና ከሴዳ ሙሳ ግዶፐ፥ እ ዋኔደንቶነ ኑን ኤሮኮ!” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","አሮነ ኡንቱንታ፥ “ህንተንቱ ማቻቱዋ ሀይꬃንነ ህንተንቱ አቱማ ናናነ ማጫ ናናቱዋ ሀይꬃን ደእያ ዎርቃ ከሲደ፥ ታዉ አኪደ አህተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ሄዋፐ ጉይያን አሳይ ኡባይ ባረ ሀይꬃ ዎርቃ ከሲደ፥ አሮናዉ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","እ ሄዋ ኡንቱንቱ ኩሽያፐ አኪደ፥ ሲልሴዳዋፐ ጉይያን ቆጽያባን ቆጺደ፥ ማራ ማላትያ ኤቃ ኦꬂደ መꬌዳ። አሳይ፥ “እስራኤላቶ፥ ህንተንታ ግብጼ ጋድያፐ ከሴዳ ህንተንቱ ጾሳቱ ሀዋንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","አሮነ ሀዋ በኤዳ ዎደ፥ ሄ ማራ ስንꬃን ያርሽያ ሳኣ ግምቢደ፥ “ዎንታ መꬍና ጎዳ ባላ ጋላሳ ግዳናዋ” ያጊደ ኤርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ሄዋ ድራዉ፥ ዎንተꬃ ጋላስ አሳይ ጉራን ደንዲደ፥ ጹግያ ያርሹዋ ሺሼዳ፤ እትፐተꬃ ያርሹዋካ ያርሼዳ። ያቲደ አሳይ ማናዉነ ኡሻናዉ ኡቴዳ። ም ኡሽ ስሚደ፥ ቃይ ዱራናዉ ደንዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ያንና መꬍና ጎዳይ ሙሳ፥ “ኔን ኤለካ ዱገ ዎꬋ፤ አያዉ ጎፐ፥ ነ አሳይ፥ ኔን ግብጼፐ ከሳደ አሄዳዌ ናጋራ ኦꬂደ፥ ባረንቱ ሁጲያ ቱንሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ታን ኡንቱንታ አዛዜዳ ኦግያፐ ኡንቱንቱ ኤለካ ሸርእ ጌድኖ። ዎርቃ ሲልሴዳ ማራ ማላትሲደ፥ ባረንቶ ኤቃ መꬊደ አዉ ጎይኔድኖ፤ አዉ ያርሼድኖ። ኡንቱንቱ፥ ‘እስራኤላቶ፥ ህንተንታ ግብጼ ጋድያፐ ከሴዳ ህንተንቱ ጾሳቱ ሀዋንታ’ ያጌድኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","መꬍና ጎዳይ ሙሳ፥ “ታን ሀ አሳ በኣድ፤ ኡንቱንቱ ሞርጊ ꬉሌፋቴዳ አሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ሀእ ታ ሀንቁ ኡንቱንቱ ቦላ ኤጽ ከስና፥ ታን ኡንቱንታ ባይዛናዋ ኔን ታና ድጎፓ። ያታደ ታን ኔና ዎልቃማ ካዉተꬃ ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ሽን ሙሴ መꬍና ጎዳ ባረ ጾሳ ሀዋዳን ያጊደ ዎሴዳ፤ “አቤት መꬍና ጎዳዉ ኔን ነ ዎልቃማ ዎልቃንነ ነ ምኖ ኩሽያን ግብጼፐ ከሳደ አሄዳ ነ አሳ ቦላ ነ ሀንቁ አያዉ ኤጽ ከስ? ");
INSERT INTO dwrENT_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ግብጼቱ፥ ‘ጾሳይ ኡንቱንታ ደረቱዋ ቦላን ዎꬋናዉነ ጋድያፐ ፕት ꬋይሳናዉ፥ ኢታ ሀልቹዋን ከሴዳ’ አያዉ ግኖ? ነ ያሽያ ሀንቁዋፐ ስማ፤ ነ አሳ ꬋይሳናዉ ቆፖዋ አጋ ባሻ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ነ አይለቱዋ አብራሃማ፥ ይሳቃነ ያቆባ ሀሳያ፤ ኔን ኡንቱንቶ፥ ‘ታን ህንተንቱ ዛርያ ሳሉዋ ጾልንተቱዋዳን ዳርሳና፤ ሀ ታን ህንተንቶ እማና ጌዳ ጋድያ ኡባካ ህንተንቱ ዛርያዉ እማና፤ ኡንቱንቱ ሄ ጋድያ መꬍናዉ ላታና’ ጋደ ነ ሁጲያን ኔን ጫቄዳ ቃላ ሀሳያ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ሄዋ ድራዉ፥ መꬍና ጎዳይ ባረ አሳ ቦላ ኢታባ አሀናዉ ኦዴዳዋ አጊደ፥ ኡንቱንታ ማሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ሄዋፐ ጉይያን ሙሴ ታሙ አዛዛቱ ኡንቱንቱን ጻፈት ኡቴዳ ላኡ ማርካተꬃ ሹቻቱዋ ባረ ኩሽያን ኦይቂደ፥ ደርያፐ ዱገ ዎꬌዳ። ሄ ሹቻቱ ላኡ ባጋናካ ጻፈቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ሄ ማሰቴዳ ሹቻቱዋ ጊግሴዳዌ ጾሳ፤ ሹቻ ቦላ ዎጪደ ጻፌዳዌካ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ኢያሱ አሳ ጫቡዋ ስሴዳ ዎደ፥ ሙሳ ሀዋዳን ያጌዳ፤ “ዱንካኔዳ ሳኣን ኦላ ዋሱ ስሰቴ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ሙሴ ዛሪደ፥ “ታን ስስያዌ ሀዌ የꬃፐ አትና፥ ጾኔዳዋንቱ ኮሻ ዎይ ጾነቴዳዋንቱ ኮሻ ግደና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ሙሴ ዱንካኔዳ ሳኣ ማቴዳ ዎደ፥ ማራነ ዱሩዋ በኢደ ሎይꬅ ሀንቀቲደ ባረ ኩሽያን ኦይቆ ማርካተꬃ ሹቻቱዋ ደርያ ጻጱዋን ኦሊደ መንሬꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ኡንቱንቱ መꬌዳ ማራካ አኪደ፥ ታማን ጹጌዳ፤ ሄዋፐ ጉይያን ሊቃና ጋካናዉ ጋጪደ ሃꬃ ቦላ ላሊደ፥ እስራኤልያ አሳይ ኡሻናዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ሄዋፐ ጉይያን፥ ሙሴ አሮና፥ “ሀ አሳይ ኔና ዋትኔ ኔን ኡንቱንታ ሀዋ ማላ ዎልቃማ ናጋራዉ ካለꬄዳዌ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","አሮንካ ዛሪደ፥ “ታ ጎዳዉ፥ ሀንቀቶፓ፤ ሀ አሳይ ኢታ ኦꬃናዉ አይ ኬሻ ኮይንቶ ኔን ኤራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ኡንቱንቱ ታና፥ ‘ኑና ካለꬅያ ጾሳቱዋ ኑዉ መꬋ። አያዉ ጎፐ፥ ሀ ኑና ግብጼፐ አሄዳ ሙሴ እ ዋኔደንቶነ ኑን ኤሮኮ!’ ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ታን ኡንቱንታ፥ ‘ህንተ ቦላ ደእያ ዎርቃ ከሲደ፥ ሀምተ’ ያጋድ። ሄዋፐ ጉይያን ኡንቱንቱ ታዉ እሜዳ ዎርቃ ታን ታማን የግና፥ ሀ ማራይ ከሴዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","አሮነ አሳ ገደ ጮ የድ አግና፥ አሳይ ባረ ሞርከቱዋ ስንꬃን ካዉሺደ ካቴዳዋ ሙሴ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ሄዋ ድራዉ፥ ሙሴ ዱንካኔዳ ሳኣ ገልያ ፐንግያን ኤቂደ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳ ባጋ ግዴዳ አሳይ ኦንነ ታኮ ዮ!” ያጌዳ። ሌዋቱ ኡባይ አኮ ሺቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ሄዋፐ ጉይያን እ ኡንቱንታ፥ “መꬍና ጎዳይ እስራኤልያ ጾሳይ ሀዋዳን ያጌ፤ ‘አሳይ ኡባይ ማሻ ባረ ጼሳን ጼሳን ዳንጮ፤ ዱንካኔዳ ሳኣን ጋጻፐ ጋጻ ጋካናዉ፥ ጉየዉነ ስንꬃዉነ ስመረቶ፤ እቱ እቱ ባረ እሻ፥ ባረ ላግያነ ባረ ሾሩዋ ዎꬎ ያጌ’ ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ሌዋቱ ሙሴ አዛዜዳዋዳን ኦꬄድኖ፤ ሄ ጋላስ አሳፐ ሄዙ ሻኣ ኬሻይ ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ሄዋፐ ጉይያን ሙሴ ሌዋቱዋ፥ “ሀቼ ህንተንቱ ጾሳዉ ዱማቴድታ፤ አያዉ ጎፐ፥ ህንተንቱ ህንተንቱ ናናነ ህንተንቱ እሻቱዋ ዎꬋናዉካ አዛዘቴድታ፤ ሀቼ መꬍና ጎዳይ ህንተንታ አንጃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ዎንትሳ ጋላስ ሙሴ አሳ፥ “ህንተንቱ ዎልቃማ ናጋራ ኦꬄድታ፤ ሽን ሀእ ታን መꬍና ጎዳኮ ፑደ ደርያ ከሳና፤ ህንተንቱ ናጋራ ታን አቶ ጊሳንታንቶነ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ያትና ሙሴ መꬍና ጎዳኮ ስም ቢደ ሀዋዳን ያጌዳ፤ “ሀ አሳይ ዎልቃማ ናጋራ ኦꬄዳ፤ ኡንቱንቱ ባረንቶ ዎርቃፐ ጾሳቱዋ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ሽን ሀያና፥ ሀእ ኡንቱንቱ ናጋራ አቶ ያጋ፤ ሄዌ ꬋዮፐ፥ ኔን ጻፌዳ ማዝጎብያፐ ታና ቁጫ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","መꬍና ጎዳይ ዛሪደ ሙሳ፥ “ታን ታ ማዝጋባፐ ቁጫናዌ ታ ቦላ ናጋራ ኦꬄዳ አሳቱዋ ሱንꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ሀእ ባደ፥ ሀ አሳ ታን ነዉ ኦዴዳ ሳኣ ካለꬃ፤ ታ ኪታንቻይካ ኔና ካለꬃና፤ ሽን ታን ሙራናዉ ዎዲ ጋክና፥ ኡንቱንታ ኡንቱንቱ ናጋራ ድራዉ ሙራና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","አሮነ ዎርቃፐ ማራ ምስልያ መꬋናዳን አሳይ ኦꬄዳ ድራዉ፥ መꬍና ጎዳይ አሳ ቦላ ዎልቃማ ቦሻ የዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ “ኔንነ ኔን ግብጼፐ ከሴዳ አሳይ ሀ ሳኣፐ ደንድተ፤ ‘ታን ህንተንቱ ያራቶ እማና’ ያጋደ ዎꬄዳ ጋድያ ቢተ። ሄ ጋዲ ታን አብራሃመዉ፥ ይሳቃዉነ ያቆባዉ እማና ያጋደ ጫቃ ዎꬄዳ ጋድያ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ታን ህንተንቱ ስንꬃን ኪታንቻ ኪታደ፥ ካናነቱዋ፥ አሞረቱዋ፥ ሂተቱዋ፥ ፓርዘቱዋ፥ ሂዌቱዋነ ያቡሳቱዋ የደርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ማꬃይነ ኤሳይ ጎግያ ሄ ጋድያ ቢተ። ሽን ህንተንቱ ሞርጊ ꬉሌፋቶ አሳ ግዴዳ ድራዉ፥ ታን ህንተንታ ኦግያን ꬋይሳናዉ፥ ህንተናና ቢከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","አሳይ ሄ ያሽያ ኦዱዋ ስሲደ ሎይꬅ ዬኬዳ። ሄ ዎድያፐ ዶሚደ ኡባይካ ባረ አሌቁዋ አꬅያዋ አግ ባሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","አያዉ ጎፐ፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያግ ዎꬄዳ፤ “እስራኤልያ ሀዋዳን ያጋ፤ ‘ህንተ ሞርጊ ꬉሌፋቶ አሳ። ታን ህንተናና ሀራይ አቶ ጉꬃ ዎድያ ብንቶካ፥ ታን ህንተንታ ꬋይሳና። ሀእ ስም ህንተንቱ አሌቁዋ ከስ ድግተ፤ ያቶፐ ታን ህንተንታ ኦꬃናባ ቃቻና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","እስራኤላቱ ሲና ደርያፐ ዶሚደ ባረንቱ አሌቆቱዋ ከስ ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ሙሴ ዱንካንያ አክ አፊደ፥ አሳይ ዱንካኖ ሳኣፐ ካረና ሃሲደ ꬎጌዳ። ሄ ዱንካኒ፥ “ጋከትያ ዱንካንያ” ጌተቲደ ጼሰቴዳ። መꬍና ጎዳ ኦቻናዉ ኮይያ ኡባይ ዱንካኖ ሳኣፐ ካረና ደእያ ጋከትያ ዱንካንያ ቤ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ሙሴ ሄ ዱንካንያ ቤዳ ዎደ፥ አዉደነ አሳይ ኡባይ ደንዲደ፥ ባረ ዱንካንያ ፐንግያን ፐንግያን ኤቄ፤ ሙሴ ሄ ዱንካንያ ገላና ጋካናዉ አ ጼሌ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ሙሴ ጋከትያ ዱንካንያ ግዶ ገሌዳ ዎደ፥ ሻርያ ቱሳይ ዱገ ዎꬌ፤ መꬍና ጎዳይ ሙሴና ሻርያፐ ሃሳይሽን፥ ሄ ዱንካንያ ፐንግያን ጋምኤ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ሻርያ ቱሳ ሄ ዱንካንያ ገልያ ፐንግያን በኤዳ ዎደ ኡባን፥ አሳይ ኡባይ ባረ ዱንካንያ ፐንግያን ፐንግያን ጾሳዉ ጎይኔ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","አሳይ ባረ ላግያና ሃሳይያዋዳን መꬍና ጎዳይ ሙሴና ስንꬃን ኤቂደ፥ ሃሳዬ። ሄዋፐ ጉይያን ሙሴ አሳይ ዱንካኔዳ ሳኣ ጉየ ስሜ፤ ሽን አ ማድያ ያላጋይ፥ ነዊ ናኣ ኢያሱ፥ ጋከትያ ዱንካንያፐ ሻከተና። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ሙሴ መꬍና ጎዳ ሀዋዳን ያጌዳ፤ “ኔን ታና፥ ‘ሀ አሳ ካለꬃ’ ያጋዳ፤ ሽን ታናና ኔን ኦና ኪታንንቶ፥ ታና ኤርሳበይካ። ኔን፥ ‘ታን ኔና ሱንꬃን ኤራይ፤ ቃይካ ኔን ታናን ናሸታዳ’ ያጋዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ኔን ታና ናሼዳዋ ግዶፐ፥ ታን ኔና ኤራና ማላነ ስንꬃዉካ ኔና ናሸቻደ ደአና ማላ፥ ነ ኦግያ ታና በሳ። ሀ አሳይ ነ አሳ ግድያዋ ሀሳያ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","መꬍና ጎዳይ ዛሪደ፥ “ታን ኔናና ባና፤ ታን ኔና ሸምፕሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ያትና ሙሴ አ፥ “ኔን ኑናና ቤናዋ ግዶፐ፥ ሀዋፐ ኑና የዶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ኔን ኑናና ቤናን ꬋዮፐ፥ ታናንነ ነ አሳን ኔን ናሸቴዳዋ አሳይ ኡባይ ዎት ኤራናዌ? ቢታ ኡባን ደእያ ሀራ አሳ ኡባፐ ታናነ ነ አሳ ዱማይያዌ ሀራባይ አዬ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","መꬍና ጎዳይ ሙሳ፥ “ታን ኔናን ናሸቴዳ ድራዉነ ኔና ነ ሱንꬃን ኤርያ ድራዉ፥ ኔን ታና ኦቼዳ ሀ የዉዋ ታን ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ያትና ሙሴ፥ “ነ ቦንቹዋ ታና በሳርኪ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","መꬍና ጎዳይ፥ “ታን ታ ሎኦተꬃ ኡባ ነ ስንꬃና አꬃና፤ ታ ጌሻ ሱንꬃካ ነ ስንꬃን አዋያና። ታን መꬍና ጎዳ፤ ታን ሎአናዉ ኮይያዋንቶ ሎአና፤ ቃይ ቃረታናዉ ኮይያዋንቶካ ቃረታና። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ሽን ኔን ታ ዴሙዋ በአካ፤ አያዉ ጎፐ፥ ኦንነ ታና በኢደ ሸምፑዋና ደኤና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ሄዋፐ ጉይያን መꬍና ጎዳይ፥ “ኔን ዛላ ቦላ ኤቃናዉ ሀዋን ታ ማታን ሳአይ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ታ ቦንቹ አꬍያ ዎደ፥ ታን ኔና ጳልቀቴዳ ዛላ ግዶን ዎꬃና፤ ታን አꬋና ጋካናዉ፥ ታ ኩሽያን ኔና ካማና። ");
INSERT INTO dwrENT_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ሄዋፐ ጉይያን ታን ታ ኩሽያ ድግና፥ ኔን ታ ዞኪያ በአናሳ፤ ሽን ታ ሶምእ በኤተና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ “ኮይሮዋንታ ማላትያ ላኡ ሹቻቱዋ ማሳደ ጊግሳ፤ ያቶፐ ታን ሄ ማሰቴዳ ሹቻቱዋ ቦላ ካሰ ኔን መንꬄዳ ሹቻቱዋ ቦላን ደእያ ቃላቱዋ ጻፋና። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ዎንታ ዎንታ ፑደ ሲና ደርያ ከሳናዉ ጊጋ፤ ያታደ ታና ያን ደርያ ሁጲያን ኤቃ ናጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ኔናና ኦንነ ከሶፖ፤ ዎይ ደርያ ቦላ ሀቃንካ ቤቶፖ፤ ሀራይ አቶ ዶርሳ ዉዲ ዎይ መህያ ዉዲካ ደርያ ስንꬃን ሄመቶፖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ሄዋ ድራዉ፥ ሙሴ ኮይሮ ሹቻቱዋ ማላትያ ላኡ ሹቻቱዋ ማሲደ መꬍና ጎዳይ አዛዜዳዋዳን፥ ሹቻቱዋ ባረ ኩሽያን ኦይቂደ፥ ዎንታ ጉራና ፑደ ሲና ደርያ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","መꬍና ጎዳይ ሻርያን ዱገ ዎꬊደ፥ አናና ያን ኤቄዳ፤ “ታን መꬍና ጎዳ” ያጊደ ባረ ሱንꬃ አዋዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","መꬍና ጎዳይ ሙሴ ስንꬃና ሀዋዳን ያጊደ አዋዪደ አꬌዳ፤ “ታን መꬍና ጎዳ፤ ታን መꬍና ጎዳ፤ ቃረታይነ ማሮተꬃይ ኩሜዳ ጾሳ፥ ዳንዳያንቻ፥ አገና ሲቁ ዳሬዳዋነ ዳሪ አማነትያዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ታን ታ አገና ሲቁዋ ሻአቶ ናግያዋ፤ ኢታተꬃ፥ ማካላነ ናጋራ አቶ ያግያዋ። ግዶፐካ፥ ባይዞዋ ሙረናን አገናዋ፤ አዎቱዋ ናጋራ ድራዉ ናናነ ናናቱዋ ናና፥ ሄዘንꬆ የለታነ ኦይደንꬆ የለታ ጋካናዉ ሙርያዋ” ያጊደ አዋዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ሄዋፐ ጉየ ሙሴ ኤለካ ቢታን ጉፋኒደ ጎይኔዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“አቤት ጎዳዉ፥ ኔን ታናን ናሸቴዳዋ ግዶፐ፥ ኑናና እትፐ ደንዳ። ሀዌ አሳይ ሞርጊ ꬉሌፋቴዳዋ ግዶፐነ፥ ኑ ኢታተꬃነ ኑ ናጋራ አቶ ያጋደ፥ ኑና ነ አሳ ኦꬃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ያትና መꬍና ጎዳይ ሀዋዳን ያጌዳ፤ “ታን ህንተናና ቃላ ጫቁዋ ገላድ፤ ሀዋፐ ካሰ ሳኣ ኡባን ደእያ ካዉተꬃ ኡባን ሀን ኤረና ማላልስያባ ነ አሳ ኡባ ስንꬃን ኦꬃና፤ ታን መꬍና ጎዳይ፥ ህንተንቶ ኦꬅያ ኪታይ አይ ኬሻ ማላልስያበንቶ ኔን ኡንቱንቱ ግዶን ደእያ አሳይ ኡባይ በአና። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ሀቼ ታን ህንተንታ አዛዝያ አዛዙዋ ናግተ፤ ህንተንቱ ስንꬃፐ አሞረቱዋ፥ ካናነቱዋ፥ ሂተቱዋ፥ ፓርዘቱዋ፥ ሂዌቱዋነ ያቡሳቱዋ ታን የደርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ኡንቱንቱ ህንተንቶ ጲረ ግደና ማላ፥ ህንተንቱ ብያ ጋድያን ደእያ አሳና ቃላ ጫቁዋ ገሎፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ኡንቱንቱ ያርሽያ ሳኣ ኮልተ፤ ኡንቱንቱ ጎይንያ ሹቻቱዋካ መንሬꬅተ፤ ቃይ አሼሮ ጌተትያ ኡንቱንቱ ማጫ ጾሳት ካሻ ቃንጸሬꬅ ኦልተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ታን መꬍና ጎዳይ ቃናትያ ጾሳ ግድያ ድራዉ፥ ታፐ ሀራ ጾሳቶ ጎይኖፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ሄ ጋድያን ደእያ አሳቱዋና አያ ቃላ ጫቁዋካ ገሎፕተ፤ አያዉ ጎፐ፥ ኡንቱንቱ ታናን አማነተናን እጺደ ባረንቱ ጾሳቱዋ ካልያ ዎደነ ኡንቱንቶ ያርሽያ ዎደ፥ ኡንቱንቱ ህንተናካ ሾባና፤ ህንተንቱ ኡንቱንቱ ያርሾቱዋ ማና። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ቃይ ህንተንቱ ኡንቱንቱ ማጫ ናናቱዋፐ ዶሪደ፥ ህንተንቱ አቱማ ናናቶ እማና፤ ሄ ዎደ ሄ ማጫ ናናይ ታናን አማነተናን እጺደ፥ ባረንቱ ጾሳቱዋ ካሊደ፥ ህንተንቱ አቱማ ናናካ ባረንቱዋዳን ኦስሳናዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“ህንተንቶ ጎይንያ ጾሳቱዋ አያፐካ ሲልሲደ መꬎፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“ማጋገ ኡክꬃ ባላ ቦንችተ፤ ታን ህንተንታ አዛዜዳዋዳን፥ ላፑን ጋላሳዉ እርሹ ገለናን ኡከቴዳ ኡክꬃ ሚተ፤ ሄዋካ ህንተንቱ ግብጼፐ ከሴዳ አቢባ አግናን ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“አት ኡሉዋፐ ባይራ የለትያ አቱማ ናኣ ኡባይ ታዋ፤ ህንተንቱ መህያ ኡባፐ ቦራ ግድና፥ ዎይ ዶርሳ ግድና፥ ባይራይ ታዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ኮይሮ የለቴዳ ሀርያ ማራ ዶርሳ ማራና ላማደ ዎዛ፤ ዎዛና ꬋዮፐ፥ አ ቆꬍያ መንꬃደ ዎꬋ። ነ ናናቱዋፐ ባይራ የለቴዳ አቱማ ናኣ ኡባ ዎዛ። “ኦንነ እምያዋ ኦይቀናን፥ መላ ኩሽያና ታ ስንꬃን ቤቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ኡሱፑን ጋላሳ ኦꬅተ፤ ሽን ላፑንꬃ ጋላሳን ሸምፕተ፤ ጎሽያ ዎድያን ቃይ ካꬃ ጫክያ ዎድያን ላፑንꬃ ጋላሳን ሸምፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“ባይራ ዘረቴዳ ዛርጋ ህንተንቱ ጫክያ ዎደ፥ ሳምንታቱዋ ባላ ቦንችተ፤ ላይꬃ ዉርሰꬃ ካꬃ ሺሽያ ዎደካ፥ ሺሹዋ ባላ ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ላይꬃን ሄዙ ገደ እስራኤልያ አቱማ አሳይ ኡባይ ኡባ ሞድያ ጾሳ፥ እስራኤልያ መꬍና ጎዳ ስንꬃን ቤትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ካዉተꬃቱዋ ታን ህንተንቱ ስንꬃፐ የደርሳደ ከሳና፤ ያታደ ህንተንቱ ዛዋ ታን አሳና። መꬍና ጎዳ ህንተንቱ ጾሳ ስንꬃን ህንተንቱ ላይꬃን ሄዙ ገደ ቤታናዉ ፑደ ከስያ ዎደ፥ ኦንነ ህንተንቱ ጋድያ አሞተና። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ህንተንቱ ታዉ ሱꬃ ያርሹዋ ያርሽያ ዎደ፥ እርሹዋ የጊደ ኡኬዳ ኡክꬃና ያርሾፕተ። ፓስጋ ቦንችያ ጋላሳዉ ያርሼዳ ያርሹዋፐ ዎንትዉ አያይነ አቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“ህንተንቱ ጋደን ባይራ ካኤዳ ካꬃፐ ኮይሮ ሙሩታ መꬍና ጎዳ ህንተንቱ ጾሳ ጎልያ አህተ። “ዴሻ ማራ አ አት ማꬃን ዶይሶፕተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","መꬍና ጎዳይ ሙሳ፥ “ታን ኔናናነ እስራኤልያ አሳና ቃላ ጫቁዋ ገልያዌ ሀ ቃላቱ ግያ ማራና ግድያ ድራዉ፥ ሀ ቃላቱዋ ጻፋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ሙሴ ቁማ ሜናንነ ሃꬃ ኡሸናን፥ ኦይታሙ ጋላሳነ ኦይታሙ ቃማ መꬍና ጎዳና ያን ጋምኤዳ፤ ቃላ ጫቁዋ ቃላቱዋ፥ ታሙ አዛዙዋ ማሰቴዳ ሹቻን ጻፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ሙሴ ጾሳና ሃሳዪደ ጋምኤዳ ድራዉ፥ ሄ ላኡ ማርካተꬃ ሹቻቱዋ እ ባረ ኩሽያን ኦይቂደ ሲና ደርያፐ ዱገ ዎꬌዳ ዎደ፥ አ ሶምኢ ፖኤዳ፤ ሽን እ ሄዋ ኤርቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","አሮነነ እስራኤልያ አሳይ ኡባይ ሙሳ ጼሊደ፥ አ ሶምኢ ጶልያዋ በኤድኖ፤ ኡንቱንቱ አኮ ሺቃናዉ ያዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ሽን ሙሴ ኡንቱንታ ጼስና አሮነነ ሽቁዋ ካለꬅያ ካፓቱ ኡባይ አኮ ስሜድኖ፤ እ ኡንቱንታ ሃሳይሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ሄዋፐ ጉይያን እስራኤልያ አሳይ ኡባይ አኮ ሺቅና መꬍና ጎዳይ አዉ ሲና ደርያን እሜዳ አዛዙዋ ኡባ እ ኡንቱንቶ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ሙሴ ኡንቱንቶ ኦድያዋ ዉርሴዳ ዎደ፥ ባረ ዴሙዋ ናጻላን ካሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ሽን ሙሴ መꬍና ጎዳ ስንꬃ አናና ሃሳያናዉ ገልያ ዎደ አዉደነ ከሳና ጋካናዉ፥ ናጻላ ባረ ሶምኡዋፐ ቃር ድጌ። ሄዋፐ ከሲደ፥ መꬍና ጎዳይ አዛዜዳዋ እስራኤልያ አሳዉ ኦዴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ኦድያ ዎደ፥ ኡንቱንቱ አ ሶምኢ ጶልያዋ በኤድኖ። ሄዋ ድራዉ፥ ሙሴ መꬍና ጎዳና ሃሳያናዉ ባና ጋካናዉ፥ ባረ ዴሙዋ ዛረꬂደካ ናጻላን ካሜ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ሙሴ እስራኤልያ አሳ ሽቁዋ ኡባ ሺሺደ ሀዋዳን ያጌዳ፤ “ህንተንቱ ኦꬃና ማላ፥ መꬍና ጎዳይ አዛዜዳዌ ሀዋ: ");
INSERT INTO dwrENT_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ሳምንታ ግዶን ኡሱፑን ጋላሳ ኪታ ኪተትተ፤ ሽን ላፑንꬃ ጋላሳይ ህንተንቶ ጌሻ ጋላሳ፤ መꬍና ጎዳዉካ ሸምፖ ሳምባታ። ሄ ጋላሳን አይ ኦሶነ ኦꬅያ ኡራይ ኦንነ ሀይቃናዉ በሴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ሳምባታ ጋላሳን ህንተንቱ ሶን ሶን ታማ ኤꬆፕተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ሙሴ እስራኤልያ ማባራዉ ሙልያዉ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳይ ሀዋዳን ያጊደ አዛዜዳ: ");
INSERT INTO dwrENT_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ህንተንቶ ደእያዋፐ መꬍና ጎዳዉ እምያዋ አህተ፤ መꬍና ጎዳዉ እምያዋ አሀናዉ ኮይያ ኦንነ ዎርቃ፥ ብራ፥ ናሃስያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ሳሉዋ ማላትያ ቃጭና፥ ኦቻ ቴራ ማላትያ ቃጭና፥ ሾሎላ ዞኦ ቃጭናነ ሊቆ ሱፍያ፥ ዴሻ ጋልባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ዶርሳ ኮልያ ጋልባ ዞኦ ቃላምያን የግ ከሴዳዋ፥ ቁምእያ፥ ኦዶሩዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ጾምፕያዉ ዎጋራ ዛይትያ፥ ኦከትያ ዛይትያነ እጻና ሳዌꬅያ ቅማምያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ኤፉድያንነ ትራን ዎꬅያዋን የግያ ማርግድያ ጌተትያ ሹቻቱዋነ ሀራ ጶልያ አልኦ ሹቻቱዋ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“ህንተንቱ ግዶን ደእያ ኩሽያ ሂላ ኤራንቻ ኡባቱ ዪደ፥ መꬍና ጎዳይ አዛዜዳ ኡባ ኦꬅኖ: ");
INSERT INTO dwrENT_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","መꬍና ጎዳ ዱንካንያ፥ አ ካምያ ዱንካንያነ አ ካምያዋ፥ ኦይቂያዋ፥ ጻጋገቱዋ፥ ሽካላቱዋ፥ ቱሳቱዋነ ኡንቱንቱ ኤቂያ ሉኮቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ታቦታነ አ ቶክያ ካሱዋ፥ አቶ ግያ ሳኣ ቁምእያዋነ ታቦታ ገንꬅያ ጋርዱዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ጻርጴዛነ አ ቶክያ ካሱዋ፥ አ ሚሻቱዋ ኡባነ ጾሳ ስንꬃን ዎꬅያ ጌሻ ኡክꬃ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ጾምፕያ ዎꬅያ ባላነ አን ማራና ደእያ ጾምፐቱዋ፥ ሚሻቱዋ፥ ጾምፕያ ዛይትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","እጻና ጩዋይያ ሳጽንያነ አ ቶክያ ካሱዋ፥ ኦከትያ ዛይትያነ ሳዊያ እጻና፥ ጾሳ ዱንካንያ ፐንግያ ጋርዱዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ጹግያ ያርሹዋ ያርሽያ ሳኣነ አ ናሃስያ ዛዝርያ፥ አ ቶክያ ካሶቱዋነ አ ሚሻቱዋ ኡባ፥ ናሃስያፐ ኦሰቴዳ ሜቻ ከርያነ አ ዎꬅያዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ሶይ ዳባባ ጎዳ ጋርዳቱዋ፥ ቱሳቱዋነ ኡንቱንቱ ገደቱዋ፥ ዳባባ ሶ ግዶ ገልያ ፐንግያ ጋርዱዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ጾሳ ዱንካንያ ꬎግያ ሽካላቱዋ፥ ዳባባ ግዶ ꬎገቱዋ ኡንቱንቱ ዎዶሮቱዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ጌሻ ሳኣን ኦꬂደ ጎኤታናዉ ዳደቴዳ ማዮቱዋ፥ ቄሲ አሮነ ማይያ ጌሻ ማዩዋ አ ናናይ ቄሰተꬃ ኪታ ኦꬂደ ማይያ ማዩዋ መꬍኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ሄዋፐ ጉይያን እስራኤልያ ማባራይ ኡባይ ሙሴ ስንꬃፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","እማናዉ ኮዬዳዋንቱነ ኡንቱንቱ ዎዛናይ ኡንቱንታ እማ እማ ጌዳዋንቱ ኡባይ ዬድኖ፤ መꬍና ጎዳ ዱንካንያዉ፥ አ ግዶን ኦꬅያ ኦሱዋ ኡባዉነ ጌሻ ማዮ ኮሽያዋ ኡባ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","እማና ኮዬዳ አቱማዋ ኡባይነ ማጫዌ ኡባይ ዪደ፥ ዎርቃፐ መꬌዳ አሌቂያዋንታ፥ ሀይꬃ ጉድቻቱዋ፥ ምግዳቱዋ፥ ሀራ ዎርቃ አሌቂያዋንታ አሂደ መꬍና ጎዳዉ እሞታ ኦꬂደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ሳሉዋ ማላትያ ቃጭናይ፥ ኦቻ ቴራ ማላትያ ቃጭናይ፥ ሾሎላ ዞኦ ቃጭናይ፥ ዎይ ሊኑዋ ጌተትያ ሊቆ ቃጭናይ፥ ዎይ ዴሻ አጎዛ፥ ዶርሳ ኦርግያ ጋልባ ዞኦ ቃላምያን የግ ከሴዳዌ፥ ዎይ ማንቻላይ ደእያ አሳይ ኡባይ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ብራ ዎይ ናሃስያ እማናዉ ዳንዳይያ ኡባይ ባረንቱ እሙዋ መꬍና ጎዳዉ እሜድኖ፤ ቃይ ኦዶሩ ደእያ አሳይ ኡባይ ዱማ ዱማ ኦሶ ኦዶሩዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ኩሽያ ሂላ ኤርያ ማጫ አሳይ ኡባይ ባረንቱ ኩሽያን ሱቄዳ ሳሉዋ ማላትያ ቃጭና፥ ኦቻ ቴራ ማላትያ ቃጭና፥ ሾሎላ ዞኦ ቃጭናነ ሊቆ ሊኑዋ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ቃይካ እሙዋ እማናዉ ኮዬዳ ማጫ አሳይ ኡባይ ዴሻ አጎዛ ዳዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ካፓቱ ኤፉድያንነ ትራን ዎꬅያዋን ዎꬅያ ማርግድያነ ሀራ ቦንቼቴዳ ሹቻቱዋ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ኡንቱንቱ ቃይካ ጾምፕያዉ፥ ሳዊያ እጻናዉነ ኦካናዉ ሀንያ ዎጋራ ዛይትያነ ቅማምያ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","እስራኤላቱ አሳይ ኡባይ፥ አቱማዌነ ማጫዌ፥ ኡንቱንቱ ኦꬃናዳን መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳ ኦሶ ሀንያ እሙዋ ኡባ ባረንቱ ሸንያን መꬍና ጎዳዉ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ሙሴ እስራኤልያ አሳ ሀዋዳን ያጌዳ፤ “በእተ፤ መꬍና ጎዳይ ይሁዳ ዛርያፐ ሁራ ናኣ ናኣ፥ ኡራ ናኣ፥ ባጻልኤላ ዶሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","መꬍና ጎዳይ አ ጾሳ አያናን፥ ሂላን፥ አኬካንነ ኦሱዋ ኡባ ኦꬅያ ኤራን ኩንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ሄዌካ ሂላን ኪታ ሀልቹዋ ከሲደ፥ ዎርቃፐ፥ ብራፐነ ናሃስያፐ ዱማ ዱማባ እ ኡዳናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ሄዋዳንካ፥ አልኦ ሹቻ ማሲደ ጊግሳናሳ፤ ምꬃ ማሳናሳነ ኡባ ቆሞ ኦሱዋ ሂላን ኦꬃናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ሄዋ ቦላካ ቃይ አስነ ዳና ዛርያ አህሳማካ ናኣ ኦሆልኣባዉ፥ ሀራ አሳ ታማርስያ ኤራ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ኡንቱንቱ ኡባ ቆሞ ኦሱዋ ኦꬃናዳን፥ ሂላን ኦꬅያዋንታ፥ ኦሱዋ ሀልቹዋ ከስያዋንታ፥ ሳሉዋ ማላትያ ቃጭናን፥ ኦቻ ቴራ ማላትያ ቃጭናን፥ ሾሎላ ዞኦ ቃጭናንነ ሊኑዋ ቃጭናን አሌቁዋ ዳድያዋንታነ ሸማይነቱዋ ግዳናዳን፥ ጾሳይ ኡንቱንቱ ኤራተꬃን ኩንꬄዳ። ኡንቱንቱ ኡባይካ ኡባ ቆሞ ኦሱዋ ሉጺደ ኤርያ ኤራንቻ ግዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“ሄዋ ድራዉ፥ ባጻልኤል፥ ኦሆልኣብነ መꬍና ጎዳ ዱንካንያ ኬጻና ማላነ ኦሶ ግድያ ኤራ መꬍና ጎዳይ እምና፥ ሉጼዳ አሳይ ኡባይ መꬍና ጎዳይ አዛዜዳዋዳን ኡባባ ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ሄዋፐ ጉይያን ሙሴ ባሳልኤላ፥ ኦሆልኣባነ መꬍና ጎዳይ ዱማ ኤራ እሜዳዋንቱ ኦሱዋ ኦꬃናዉ ያና ኮይያ ኡባ ጼሲደ ሺሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","እስራኤልያ አሳይ ጾሳ ዱንካንያ ኦꬃናዉነ ኦሶ ግድያ እሞታ ኡባ ሙሴፐ አኬድኖ። ቃይ አሳይ ባረ ሸንያን ጮ እምያ እሞታ ዎንታ ዎንታ ጉጅ ጉጂደ አህያዋ አግቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ያትና ጾሳ ዱንካንያ ኦꬅያ ኤራይ ኩሜዳ አሳይ ኡባይ ባረንቱ ኦሱዋ አግ ባሺደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ሙሳ ሀዋዳን ያጌድኖ፤ “አሳይ መꬍና ጎዳይ አዛዜዳ ኦሶ ኮሽያዋፐ ሎይꬅ ዳርያዋ አሂደ ደኤ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ሙሴ ዱንካኔዳ ሳኣን ደእያ አሳዉ ሀዋዳን ያጊደ አዛዜዳ፤ “ላኤንꬆ አይ አቱማ አሳይካ አይ ማጫ አሳይካ ጾሳ ዱንካንያ ኦሶ እምያዋ እማናዉ አሆፖ” ያግና፥ አሳይ አህያዋ አግ ባሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","አያዉ ጎፐ፥ ኡንቱንቱ አሄዳ እሞታይ ኦሱዋ ኡባ ኦꬃናዉ ግዲደ ፓላሄ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ኦሱዋ ኦꬅያዋንቱ ግዶፐ ሂላ ዳርያዋንቱ ኡባቱ ሊቆ ሊኑዋፐነ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐ ዳደቴዳ ታሙ ጋርዱቱዋፐ ጾሳ ዱንካንያ ጊግሴድኖ። ሄ ጋርዳቱዋን እት ሂላይ ክሩበቱዋ ምስልያ ዳዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ጋርዶቱ ኡባይ እት ልከ ግዲደ፥ ጌሳይ ላታማነ ሆስፑን ዋꬋ፤ ጎምፓይ ኦይዱ ዋꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","እቼሹ ጋርዳቱዋ እትፐ ጋꬂደ ስኬድኖ፤ ቃይ የንኮ አቴዳ እቼሹ ጋርዳቱዋካ ኡንቱንቱዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","እትፐ ጋꬂደ ስኬዳ ጋርዱቱዋፐ እት ጋርዱዋ ዉርሰꬃ ጋጻን ሳሉዋ ማላትያ ጫርቂያፐ ማጫራ መꬌድኖ። ቃይ እትፐ ጋከት ስከቴዳ የንኮ ጋርዱዋንካ ሄዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ኡንቱንቱ እትፐ ጋከቴዳ እት ጋርዱዋ ቦላ እሻታሙ ማጫራ፥ ቃይ እትፐ ጋከቴዳ የንኮ ጋርዱዋ ቦላካ እሻታሙ ማጫራ መꬌድኖ። ሄ ማጫራቱ ኡባይካ እቱ እቶ ማራን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ሄዋፐ ጉይያን፥ ዎርቃፐ እሻታሙ ኦይቂያዋ መꬌድኖ። ዱንካኒ እቱዋ ግዳና ማላ፥ ሄ ጋርዳቱዋ ጋጻ ጋጻ ሄ ኦይቂያዋንቱን ኦይꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ጾሳ ዱንካንያ ቦላና ካምያ ዱንካንያዉ ታማነ እት ጋርዳቱዋ ዴሻ አጎዛፐ ዳዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ታማነ እት ጋርዳቱካ እት ልከ፤ እት እት ጋርዱዋ ጌሳይ ሀታሙ ዋꬋ፥ ጎምፓይ ኦይዱ ዋꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","እቼሹ ጋርዳቱዋ እት ባጋና፥ ኡሱፑን ጋርዳቱዋ ቃይ የንኮ ባጋና ጋꬂደ ስኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ሄዋፐ ጉይያን ጋꬅ ስኬዳ ጋርዳቱዋፐ እት ጋርዱዋ ጋጻን እሻታሙ ማጫራ መꬌድኖ። ቃይካ ጋꬅ ስኬዳ የንኮ ጋርዳቱዋፐ ዉርሰꬃ ጋርዱዋ ጋጻን እሻታሙ ማጫራ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ላኡ ባጋና ደእያ ጋርዳቱዋ ጋꬂደ እት ዱንካነ ኦꬃናዉ ናሃስያፐ እሻታሙ ኦይቂያዋ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ሄዋፐ ጉይያን ዱንካንያ ካማናዉ ዶርሳ ኦርግያ ጋልባ ዞኦ ቃላምያን የግ ከሴዳዋ ጊግሴድኖ፤ ቃይ አ ቦላና ካማናዉ ቁምእያ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ጾሳ ዱንካንያ ጻጋግያዋንታ ስት ጌዳ ኦዶሮቱዋፐ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","እት እት ጻጋግያዉ ጌሳይ ታሙ ዋꬋ፤ ጎምፓይ እት ዋꬋነ ባጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","እት እት ጻጋግያዉ እቱዋ እቱዋና ጋꬅ ኦይꬅያ ላኡ ፖꬃቱዋ መꬌድኖ። ጾሳ ዱንካንያ ጻጋገቱዋ ኡባካ ሄዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ጾሳ ዱንካንያዉ ገድሳ ባጋና ላታሙ ጻጋገቱዋ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","እት እት ጻጋግያዉ ላኡ ገደቱዋ፥ ኡባና ኦይታሙ ፖꬃይ ገልያ ሉካቱዋ ብራፐ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ጾሳ ዱንካንያዉ ሁጲሳ ባጋና ላታሙ ጻጋገቱዋ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","እት እት ጻጋግያዉ ላኡ ፖꬃይ ገልያ ሉካቱዋ፥ ኡባና ኦይታሙ ፖꬃይ ገልያ ሉካቱዋ ብራፐ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ጾሳ ዱንካንያዉ ጉየ ጋጻን አዋይ ዉልያ ባጋና ኡሱፑን ጻጋገቱዋ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ጾሳ ዱንካንያ ጉየ ጋጻን ደእያ ጋጻቶ ላኡ ጻጋገቱዋ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ሀ ላኡ ጋጻቱዋን ደእያ ጻጋገቱዋ ጻጱዋፐ ጼራ ጋካናዉ ዳቡላ ግድ ቢደ፥ ጼራን እት ሳጋይያን ገል ኦይቀቴድኖ። ኡንቱንቱ ላአቱካ ሄዋዳን ሀኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ሄዋ ድራዉ፥ እት እት ጻጋግያዉ ጋርሳና ላኡ ላኡ ገደቱ ደኢኖ፤ ኡባና ሆስፑን ጻጋገቱነ ብራፐ ኦሰቴዳ ታማነ ኡሱፑን ገደቱ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ቃይ ኡንቱንቱ ኦዶሮቱዋፐ ሽካላቱዋ ከሴድኖ፤ ጾሳ ዱንካንያዉ እት ባጋ ምይያን ደእያ ጻጋገቶ እቼሹ ሽካላቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ቃይ የንኮ ባጋ ምይያን ደእያ ጻጋገቶ እቼሹ ሽካላቱዋ ጊግሴድኖ። ሄዋዳንካ፥ ጾሳ ዱንካንያዉ ጉየ አዋይ ዉልያ ባጋና ዉርሰꬃ ጋጻን ደእያ ጻጋገቶ እቼሹ ሽካላቱዋ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ግዶ ሽካሊ ጻጋገቶ ግዶ ሄራና፥ ሀ ጋጻፐ ያ ጋጻ ጋካናዉ ፕን ከሳናዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ጻጋገቱዋ ዎርቃን ሼሺደ፥ ሽካላቱ አꬍያ ሳጋየቱዋ ዎርቃፐ መꬌድኖ፤ ቃይ ሽካላቱዋካ ዎርቃን ሼሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ፥ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ እት ጋርዱዋ ኦꬄድኖ። ሄ አ ቦላ እት ሂላይ ክሩበቱዋ ምስልያ ስኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ጋርዱዋ ኦይዱ ቱሳቱዋ ኦዶሩዋፐ ጊግሲደ፥ ዎርቃን ሼሼድኖ። ያቲደ ዎርቃ ካቂያዋንታ ኡንቱንቶ ጊግሴድኖ። ቃይ ቱሳቱዋ ኤስያ ኦይዱ ገደቱዋ ብራፐ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ጾሳ ዱንካንያ ገልያ ፐንግያዉ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ ዳደቴዳዋ፥ ጽልፕያ አሌቅስያዋን ጋርዱዋ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ቃይ ኡንቱንታ ካቂያ እቼሹ ቱሳቱዋ፥ ካቂያ ባላና ደእያዋንታ መꬌድኖ። ቱሳቱ ጉምቦቱዋነ ቃችያዋንታ ዎርቃን ሼሼድኖ። ቃይ ኡንቱንቱ ፖꬃይ ገልያ ሉኮቱዋ እቼሻቱዋካ ናሃስያፐ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ባጻልኤል ኦዶሩዋ ምꬃፐ ታቦታ ጊግሴዳ። ሄ ታቦታይ አዱሳተꬃይ ላኡ ዋꬋነ ባጋ አዱቄ፤ ጎምፓይ እት ዋꬋነ ባጋ አኬ፤ ጌሳይካ እት ዋꬋነ ባጋ ꬎቄ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ሄ ታቦታ ጊግሲደ፥ ሶያነ ካርያ ዋላካይ ባይና ዎርቃን ሼሼዳ፤ ዩሹዋካ ዎርቃ ትገꬃን ዩሽ አꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ቃይ ኦይዱ ዎርቃ ሳጋየቱዋ ትጊደ፥ ታቦታዉ ኦይዱ ገደቱዋን፥ እት ባጋና ላኡ ሳጋየቱዋ፥ ቃይ የንኮ ባጋና ላኡ ሳጋየቱዋ አꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ያቲደ ኦዶሮቱዋፐ ካሱዋ ከሲደ ኡንቱንታካ ዎርቃን ሼሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ታቦታ ቶካናዉ፥ ታቦታ ምይያን ደእያ ሳጋየቱዋን ካሱዋ አꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ዋላካይ ባይና ዎርቃፐ ላኡ ዋꬋነ ባጋ አዱቂያ፥ እት ዋꬋነ ባጋ አክያ አቶ ግያ ሳኣ ቁምእያ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ቁምእያዉ ዉርሰꬃ ላኡ ባጋ ጋጻን ላኡ ክሩቤላቱዋ ቆጸቴዳ ዎርቃፐ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","እት ክሩብያ እት ባጋ ጋጻን፥ ላኤንꬆ ክሩብያ የንኮ ባጋ ጋጻን፥ ላኡዋካ ቁምእያና ጋꬅ ኦይꬂደ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ክሩበቱ ባረንቱ ቀፍያ ደንꬂደ፥ አቶ ግያ ሳኣ ካምያ ቁምእያ ባረንቱ ቀፍያን ኩዋይ ዎꬄድኖ፤ ቃይ እቱ እቱዋኮ ስም ኡቲደ፥ ቁምእያ ጼሊኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ቃይ አዱሳተꬃይ ላኡ ዋꬋ፥ ጎምፓይ እት ዋꬋ፥ ጌሳይካ እት ዋꬋነ ባጋ ግዴዳ ጻርጴዛ ኦዶሩዋፐ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ዋላካይ ባይና ዎርቃን ሼሼዳ። ዩሹዋካ ዎርቃ ትገꬃ ዩሽ አꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ሄዋዳንካ፥ ጎምፓይ ታካ ግዴዳ ሻሽያ አ ቦላ ዩሽ አꬄዳ። ያቲደ አ ቦላ ዎርቃ ትገꬃ ዩሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ኦይዱ ዎርቃ ሳጋየቱዋ መꬊደ ኦይዱ ገደቱ መቴዳ ኦይዱ ጋጻቱዋና ኦይꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ጻርጴዛ ቶካናዉ ካሱዋ አꬅያ ሳጋየቱ ጻርጴዛዉ ሻሽያ ጋጻን ሺቂደ መቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ጻራጴዛ ቶክያ ካሶቱዋካ ኦዶሩዋፐ ከሲደ፥ ዎርቃን ሼሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ሄዋዳንካ፥ ጻርጴዛ ቦላ ዎꬅያ ዱማ ዱማ ሚሻቱዋ ዋላካይ ባይና ዎርቃፐ መꬌዳ፤ ሄዋንቱካ ሳነቱዋነ ጭልፓቱዋ፥ ቃይ ኡሻ ያርሹዋ ትግያ ከረቱዋነ ጹአቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ሄዋፐ ጉይያን እ ጾምፕያ ዎꬅያ ባላ ቆጸቴዳ ዋላካይ ባይና ዎርቃፐ መꬌዳ፤ ሄ ባላ ኤስያ ገድያካ፥ ግዶ ቶማካ ቆጼዳ ዎርቃፐ መꬌዳ። አ ኩኩሞቱዋ፥ አ ልጮቱዋን አ ጪሻቱዋ ኡባ አናና እትፐ ጾምፒደ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ምይያና ኡሱፑን ማራቱዋ መꬌዳ፤ ማራቱዋ ሄዛቱዋ እት ባጋና፥ ቃይ ሄዛቱዋ የንኮ ባጋና ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ኡሱፑን ማራቶካ ሁጲያን ሁጲያን ሄዙ ሄዙ ኩኩሙነ ጪሻቱ ደእያ ላዉዝያ ጪሻ ማላትያ ዋንጫ መꬌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ጾምፕያ ዎꬅያ ባላዉ ግዶ ቶማይ፥ ኩኩሞቱዋ ጪሻቱ ደእያ ጪሻ ማላትያ ኦይዱ ዋንጫን አሌቀት ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ላኡ ላኡ እትፐ ዋꬃን ደእያ ሄዙ ማራቱዋፐ ጋርሳና እት እት ኩኩማይ መት ኡቴዳ ኡባይካ ኡሱፑን ኩኩሞ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ኩኩማቱነ ማራቱ ኡባይ ጾምፕያ ዎꬅያ ባላና እትፐ ኦይቀት እቱዋ ግዲደ፥ ዋላካይ ባይና ዎርቃፐ ቆጸቲደ መቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","እ ቃይ ጾምፕያ ዎꬅያ ባላዉ ላፑን ጾምፐቱዋ፥ ጾምፕያ ቶይስያ ቃጰቱዋነ ኡንቱንታ ዎꬅያዋንታ ዋላካይ ባይና ዎርቃፐ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ጾምፕያ ዎꬅያ ባላነ አን ጎኤትያ ሚሻ ኡባ መꬋናዉ ሀታማነ እቼሹ ኪሎ ግራመ ግዴዳ ዋላካይ ባይና ዎርቃ ዉርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ቃይ እጻና ጩውስያ ሳኣ ኦዶሩዋፐ መꬌዳ። አዉ ኦይዱ ጋጻይ ደኤ፤ አዱሳተꬃይ እት ዋꬋ፤ ጎምፓይ እት ዋꬋ፥ ጌሳይ ላኡ ዋꬋ። አ ካጨቱካ አናና እቱዋ ግዲደ ኦይቀት መቴዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","አዉ ቦላ ዶና፥ ኦይዱ ባጋ ኡባነ አ ካጨቱዋ ዋላካይ ባይና ዎርቃን ሼሺደ፥ አ ዩሹዋካ ዎርቃ ትገꬃ ዩሽ አꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ሄ ዎርቃ ትገꬃፐ ጋርሳና እጻና ጩውስያ ሳጽንያ ዎርቃፐ ላኡ ሳጋየቱዋ መꬌዳ፤ ያቲደ ያ ባጋናነ ሀ ባጋና ላኡዋ ላኡዋ ኦይꬄዳ። ሄዋንቱ ቶክያ ዎደ ካሱዋ አꬃናዉ ማዳናዳና። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ካሶቱዋ ኦዶሩዋፐ ከሲደ፥ ኡንቱንታ ዎርቃን ሼሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ቃይ ጌሻ ኦከትያ ዛይትያነ ሳዉዋ ቶሽኩ ግያ ሎኦ እጻና ሽቱዋ ኦꬅያ ኤራን ጊግሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ኦዶሩዋፐ ጹግያ ያርሹዋ ያርሽያ ሳኣ ኬጼዳ። ሄ ያርሽያ ሳአዉ ጌሳይ ሄዙ ዋꬋ፥ ጎምፓይነ አዱሳተꬃይ እት ልከ፥ እቼሹ እቼሹ ዋꬋ ግዲደ፥ ኦይዱ ጋጻና ደእያዋ ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ኦይዱ ጋጻቱዋ ዉርሰꬃ ጋጻን ጋጻን እት እት ካጭያ መꬌዳ። ሄ ካጨቱ ያርሽያ ሳኣና እትፐ ኦይቀቲደ ኦሰቴድኖ። ያትና ያርሽያ ሳኣ ናሃስያ ብራታን ሼሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","አን ጎኤትያ ኡባ ሚሻቱዋ፥ ባልደቱዋ፥ አካፋቱዋ፥ ብድንꬃ ሺሽያ ኩይጻሮቱዋ፥ አሹዋ ኦይቂያ ዛምቤልያነ ታማ ጮጨቱዋ ኡባ ናሃስያ ብራታፐ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ያቲደ ናሃስያ ብራታፐ ዛዝርያ ያርሽያ ሳአዉ ጊግሲደ ያርሽያ ሳአዉ ዱገ ግዶ ባጋን ደእያ ሻሽያ ቦላ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ናሃስያ ብራታፐ መꬌዳ ዛዝርያዉ ኦይዱ ጋጻን ካሱዋ አꬃናዉ ኦይዱ ሳጋየቱዋ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ኦዶሩዋፐ ያርሽያ ሳአዉ ካሱዋ ከሲደ፥ ናሃስያ ብራታን ሼሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ያርሽያ ሳኣ ቶክያ ዎደ ማዳና ማላ፥ ሀ ካሱዋ ላኡ ምይያና ደእያ ሳጋየቱዋን አꬄዳ። ያርሽያ ሳኣ ግዱዋ ኮፋ ከሲደ፥ ጻዉላፐ መꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ናሃስያ ብራታፐ ሜቻ ከርያነ አ ዎꬅያዋ መꬌዳ፤ ሄ ብራታይ ጋከꬃ ዱንካንያ ፐንግያን ኦꬅያ ማጫ አሳቱ አሄዳ ሄረጋፐ አከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ሄዋፐ ጉይያን ዳባባ ጊግሴዳ። ዳባባዉ ገድሳ ባጋ አዱሳተꬃዉ ጼቱ ዋꬋ ኦꬂደ፥ ሊቆ ሊኑዋፐ ዳደቴዳ ጋርዳቱዋ ጊግሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","አዉ ናሃስያ ብራታፐ ላታሙ ቱሳቱዋነ ቱሳቱ ኤቂያ ናሃስያ ሉካቱዋ ኦꬄዳ፤ ኡንቱንቱ ሁጲያን ቃይ ብራፐ መቴዳ ካቂያዋንታነ ቱሳቱዋ ሁጲያን ቃችያዋንታ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ዳባባዉ ሁጲሳ ባጋ አዱሳተꬃይ ጼቱ ዋꬋ አዱሳ፤ ቃይ ላታሙ ቱሳቱነ ሄ ቱሳቶ ላታሙ ናሃስያ ገደቱ ደኢኖ። ያቲደ ብራፐ መቴዳ ካቂያዋንቱነ ቱሳቱዋ ሁጲያን ቃችያዋንቱ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","አዋይ ዉልያ ባጋ ዳባባ ጎምፓይ እሻታሙ ዋꬋ አካ ግዲደ፥ ታሙ ቱሳቱነ ቱሳቶ ታሙ ገደቱ ደእያ ጋርዳቱዋ ጊግሴዳ፤ ሄ ቱሳቱዋ ሁጲያን ብራፐ መቴዳ ካቂያዋንታነ ቱሳቱዋ ሁጲያን ቃችያዋንታ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ቃይ አዋይ ዶልያ ባጋ ዳባባ ጎምፓይ እሻታሙ ዋꬋ አካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ዳባባ ገልያ ሳኣፐ እት ባጋና ታማነ እቼሹ ዋꬋ አዱቂያ ጋርዶቱ፥ ሄዙ ቱሳቱነ ቱሳቶ ሄዙ ገደቱ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ሄዋዳንካ፥ ዳባባ ገልያ ሳኣፐ ህንኮ ባጋና፥ ታማነ እቼሹ ዋꬋ አዱቂያ ጋርዶቱ፥ ኡንቱንቶ ሄዙ ቱሳቱነ ቱሳቶ ሄዙ ገደቱ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ዳባባ ዩሹዋን ደእያ ጋርዶቱ ኡባይ ሊቆ ሊኑዋፐ ዳደቴዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ሄ ቱሳቱዋ ገደቱ ናሃስያፐ፥ ካቂያዋንቱነ ቱሳቱዋ ሁጲያን ቃችያዋንቱ ብራፐ ኦሰቴድኖ፤ ኡንቱንቱ ሁጲ ብራን ሼሸቴዳ። ሄዋ ድራዉ፥ ዳባባ ዩሹዋን ደእያ ቱሳቱዋ ኡባ ሁጲያን ብራፐ ኦሰቴዳ ቃችያዋንቱ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ዳባባ ገልያ ሳኣን ካቂያ ጋርዱ ሳሉዋ ማላትያ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ ዳድያዋ ጽልፕያን አሌቂስያዋን ጊግሴዳዋ። አዉ አዱሳተꬃይ ላታሙ ዋꬋ፤ ጌሳይ ዳባባ ጋርዳቱዋ ልከ፥ እቼሹ ዋꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ናሃስያ ብራታፐ ኦሰቴዳ ኦይዱ ቱሳቱነ ቱሳቶ ኦይዱ ገደቱ ደኢኖ። ኡንቱንቱ ካቂያዋንቱነ ቱሳቱዋ ሁጲያን ቃችያዋንቱ ብራፐ መቴድኖ፤ ኡንቱንቱ ሁጰቱካ ብራን ሼሸቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ጾሳ ዱንካንያ ሽካላቱ ኡባይነ አ ዩሹዋን ደእያ ዳባባ ሽካላቱ ኡባይ ናሃስያ ብራታፐ መቴዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ጾሳ ዱንካንያዉ፥ ሄዌካ ቃላ ጫቁዋ ዱንካንያዉ፥ ጎኤቴዳ ሚሻቱዋ ሌዋቱ ፓይዴድኖ። ሄ ሚሻቱዋ ቄስያ አሮና ናኣ እታማራ ካፖተꬃ ጋርሳን ደእያ ሌዋቱ ማዝጋባን ጻፋናዳን ሙሴ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ይሁዳ ዛረ ግዴዳ ሆራ ናኣ ናኣ፥ ኡራ ናኣ፥ ባጻልኤል መꬍና ጎዳይ ሙሳ አዛዜዳ ኡባ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ዳና ዛረ ግዴዳ አህሳማካ ናኣ ኦሆልኣብ አናና ደኤ፤ እ ኩሽያ ሂላንቻነ ኦꬅያባዉ ኮይሮ ሀልቹዋ ከስያዋ፤ ቃይ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናንነ ሊቆ ሊኑዋን ዳዲደ፥ ጽልፕያን አሌቂስያ አሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ጾሳ ዱንካንያ ኦሶ ጾሳዉ እመቴዳ ዎርቃይ ጾሳ ዱንካንያን ኤረትያ ሚዛናን ዎꬅና፥ እት ሻአ ኪሎ ግራምያ ዴጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ፓይዱዋን ደእያ ማባራ አሳፐ ቤቴዳ ብራይ ጾሳ ዱንካንያን ኤረትያ ሚዛናን ዎꬅና፥ 3,430 ኪሎ ግራምያ ዴጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","አሳ ፓይድያ ዎደ ፓይደቴዳ አቱማ አሳይ ኡባይ ሁጲያን ሁጲያን ጾሳ ዱንካንያን ኤረትያ ሚዛናን ዎꬅና፥ ኡሱፑን ግራመ ኬሻ እሜዳ። ፓይደቴዳ አሳይ ላታሙ ላይꬃ ኩሜዳዌነ ላታሙዋፐ ቦላና ደእያዌ ኡባይ 603,550. ");
INSERT INTO dwrENT_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ጾሳ ዱንካንያ ጋርዱዋ ኤሴዳ ጼቱ ፖꬃይ ገልያ ሉኮቱ 3,400 ኪሎ ግራመ ብራን ኦሰቴድኖ። ሄዌካ እት እት ገድያዉ ሀታማነ ኦይዱ ኪሎ ግራመ ብራ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","አቴዳ ሀታሙ ኪሎ ግራመ ትግያ ብራ ቱሳቱዋን ካቂያዋንታ መꬋናዉ፥ ቱሳቱዋ ሁጲያን ሼሻናዉነ ኡንቱንቱ ሁጲያን ቃችያዋንታ መꬋናዉ ጎኤቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ሄዋዳንካ፥ አሳይ ጾሳዉ አሄዳ ናሃስያ ብራታይ 2,425 ኪሎ ግራመ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ሄ ናሃስያ ብራታፐ ጾሳ ዱንካንያ ገልያ ሳኣን ኤቂያ ቱሳቱዋ ገደቱ፥ ናሃስያ ያርሽያ ሳኣ ግያ ያርሽያ ሳአይ፥ አ ግዶን ሂጼዳ ናሃስያ ዛዝሪነ አ ግዶን ጎኤትያ ዱማ ዱማ ሚሻ ኡባይ መቴ። ");
INSERT INTO dwrENT_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ሄዋዳንካ፥ ቃይ ዳባባ ዩሹዋን ደእያ ድርሳነ ገልያ ሳኣ ፐንጊ ኤቄዳ ገደቱ፥ ቃይ ጾሳ ዱንካኒነ አ ዩሹዋን ደእያ ዳባባ ድርሳይ ꬎገቴዳ ሽካላቱ ኡባይ ሄ ናሃስያ ብራታፐ መቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ቄሳቱ ጾሳ ዱንካንያን ኦꬅያ ዎደ ጎኤትያ ማዩዋ፥ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐ ዳዴድኖ። አሮነ ማይያ ጌሻ ቄሳተꬃ ማዩዋካ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","እ ኤፉድያ፥ ዎርቃፐ፥ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ ዳዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ኡንቱንቱ ዎርቃ ቆጺደ፥ ሌእያ ዬቻዳ፥ አፐ ቃራር ቃራሪደ፥ ቃጭና ከሴድኖ። ያቲደ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናነ ሊቆ ሊኑዋ ጋꬂደ፥ ኩሽያ ሂላንቻቱ ዳዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ላኡ ባጋይ ጋከቲደ እቱዋ ግዳና ማላ፥ ላኡ ሀሽያ ቦላ ጋꬂደ ኦይꬅያ ጫርቂያ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ሂላይ አሌቂሲደ ዳዴዳ ዳንጩካ ኤፉድያና እታ ግዲደ፥ ዎርቃፐ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ ዳደቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ኡንቱንቱ ማርግድያ ጌተትያ ላኡ ሹቻቱዋ ጊግሲደ፥ ዎርቃፐ መꬌዳ ሹቻ ኦይቂያዋ ቦላ ማራና ዎꬄድኖ። ማታፋ ቦላ ሱንꬃ ዎጪደ ጻፍያዋዳን፥ ሄ ሹቻቱዋ ቦላ ታማነ ላኡ እስራኤልያ ናናቱዋ ሱንꬃ ዎጪደ ጻፌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ጾሳይ ሙሳ አዛዜዳዋዳን፥ ታማነ ላኡ እስራኤልያ ዘረꬃ ሀሳይያዋ ግዳና ማላ፥ ሀ ሹቻቱዋ ኤፉድያና ኦይꬄዳ ሀሽያ ጫርቂያን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","እ ትራን ዎꬅያዋ ኩሽያ ሂላንቻን ኦስሴዳ። ሄ ትራን ዎꬅያዋ ኤፉድያ ዎርቃፐ ዳዴዳዋዳን፥ ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ ዳድሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","አዉ ኦይዱ ጋጻይ ደኤ፤ ጌሳይነ ጎምፓይ እት እት ታካ፤ ግዴዳዋ ዳኮዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ሄዋፐ ጉይያን አ ቦላ ኦይዱ ማራን አልኦ ሹቻቱዋ ዎꬄድኖ፤ ኮይሮ ማራን ዎꬄዳ ሹቻይ፥ ሳርድዮና፥ ቶጳዝዮንያነ ጶልያ እንቁዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ላኤንꬆ ማራን ባሉራ፥ ሳምፔርያነ አልማዝያ ጌተትያ አልኦ ሹቻቱዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ሄዘንꬆ ማራን ያክንትያ፥ ከልቀዶንያነ አመተስጽኖስያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ኦይደንꬆ ማራን ብራል፥ ማርግድያነ ያስጲድያ። ሄዋንታ ኡባ ዎርቃፐ ኦሰቴዳ ሹቻ ኦይቂያዋ ቦላ ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","እስራኤልያ ናናቱዋ ሱንꬃ ፓይዱዋዳን፥ ሹቻቱዋ ፓይዱካ ታማነ ላኡዋ፤ እቱ እቱ ማታፋዳን ዎጨቲደ፥ ታማነ ላኡ ዛራቱዋ ሱንꬃይ ሄ ሹቻቱዋን ጻፈቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ትራን ዎꬅያዎ ዎዶሩዋዳን ዶቀቴዳ ሳንሳላታ ዋላካይ ባይና ዎርቃፐ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ላኡ ዎርቃፐ መꬌዳ ሹቻ ኦይቂያዋንታ ኦꬄድኖ፤ ያቲደ ላኡ ዎርቃ ምግዳቱዋ መꬌዳዋንታ፥ ትራን ዎꬅያዎ ቆሞ ጋጻ ጋጻቱዋና ጋꬂደ ኦይሰꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ሄ ላኡ ዎርቃ ሳንሳላታቱዋ ትራን ዎꬅያዎ ጋጻቱዋን ደእያ ምግዶቱዋና ጋꬅ ኦይꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ሄ ሳንሳላታቶ ህንኮ ባጋ ጼራ ቃይ ኤፉድያዉ ስንꬃ ባጋና፥ ሀሽያ ጫርቂያን ደእያ ሹቻ ኦይቂያዋንቱና ጋꬅ ቃቼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ቃይካ ላኡ ዎርቃ ምግዳቱዋ መꬊደ፥ ኤፉድያፐ ካሊደ ደእያ ትራን ዎꬅያዎ ሶይ ባጋና ደእያ ላኡ ጋጻቱዋ ጼራን አꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ሄዋዳንካ፥ ዎርቃፐ ሀራ ላኡ ምግዳቱዋ መꬊደ፥ ኤፉድያዉ ስንꬃ ባጋና፥ ሀሽያ ጫርቂያፐ ጋርሳ ባጋና ኤፉድያ ጼሳን ቃችያዋፐ ቆሞና፥ ስኩ ጋከቴዳ ሳኣ ማታን ካረና ኡንቱንታ ኦይꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ትራን ዎꬅያዋን ደእያ ምግዳቱዋ ኤፉድያን ደእያ ምግዳቱዋና ጋꬂደ፥ ሳሉዋ ማላትያ ባቀꬃን ቃችና ትራን ዎꬅያዌ ጼሳፐ ቆሞና ደእያ ድራዉ፥ ቃሹ ሾልኤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ኤፉድያፐ ጋርሳና ማይያ አዱሳ ማዩዋ እ ሳሉዋ ማላትያ ጫርቂያፐ ጊግሴዳ፤ ሄዌ ሸማይንያ ኦሱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ሄ አዱሳ ማዮ ቆꬍያ አꬅያ ሳኣ መꬌድኖ፤ ሄ ሳአይ ፔተናዳን፥ ዩሽ አꬂደ ጉጅ ጉጅ ስኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ኡንቱንቱ አዱሳ ማዩዋ ዱገ ባጋ ማጫራ ዩሹዋን ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ዶቀቴዳ ሮማንያ ቴራ ምስለቱዋ መꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ኡንቱንቱ ቃይ ዎርቃፐ ዳላቱዋ መꬊደ፥ አዱሳ ማዮ ዱገ ባጋ ጋጻ ዩሽ አꬂደ፥ ሮማንያ ምስለቱዋ ግዱዋን፥ ዋላካን አꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","አሮነ ሄ ማዮ ዱገ ባጋ ማጫራ ዩሽ አꬂደ፥ ዳላነ ሮማንያ ቴራ ምስልያ ዋላኪደ አꬄድኖ። ሄዌ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ኡንቱንቱ ጾሳ ዱንካንያ ኦሱዋ ኦꬂደ ማያናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ኡንቱንቱ አሮናዉነ አ ናናዉ ሼማይንያ ሊኑዋፐ አዱሳ ሻምጭያ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ቃይ አሮነ ሁጲያን ጻጽያ ሻሽያ፥ አ ናናዉ ቆበቱዋነ ጋርሳና ማይያ ማዮቱዋ ሊቆ ሊኑዋፐ ዳዲደ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ኡንቱንቱ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ሳሉዋ ማላትያ፥ ኦቻ ቴራ ማላትያነ ሾሎላ ዞኦ ቃጭናፐነ ሊቆ ሊኑዋፐ ዳዲደ፥ ኩሽያ ሂላን አሌቂሲደ፥ ዳንጩዋ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ኡንቱንቱ ጌሻ አለቁዋ ምስልያ ዋላካይ ባይና ዎርቃፐ መꬊደ፥ ማታፋ ቦላ ዎጭያዋዳን፥ አ ቦላ፥ “መꬍና ጎዳዉ ጌሻ ግዲደ ዱማቴዳ” ያግያዋ ዎጪደ ጻፌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ሄዋፐ ጉይያን ሁጲያን ሻሽያፐ ጻደን ቃቻናዳን፥ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ሳሉዋ ማላትያ ባቀꬃ አን አꬂደ ቃቼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ጾሳ ዱንካንያ ኪታይ ኡባይ ፖለቴዳ። እስራኤላቱ ኡባባካ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ሄዋፐ ጉይያን ኡንቱንቱ ጾሳ ዱንካንያ ሙሴኮ አሄድኖ፤ ሄዌካ: ዱንካንያነ አ ሚሻ ኡባ፥ ጋꬅ ኦይꬅያዋ፥ ጻጋገቱዋ፥ ሽካላቱዋነ፥ ቱሳቱ ኤቂያ ሳጽነቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ቦላ ካማደ ዶርሳ ኦርግያ ጋልባ ዞኦ ቃላምያን የግ ከሴዳዋ፥ ሀራ ጋልባፐ መꬌዳ ቁምእያ፥ ታቦታ ገንꬅያ ጋርዱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ቃላ ጫቁዋ ታቦታ፥ አ ቶክያ ካሶቱዋነ አቶ ግያ ሳኣ ቁምእያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ጻርጴዛነ አ ሚሻ ኡባ ጾሳ ስንꬃን ዎꬅያ ጌሻ ኡክꬃ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ዋላካይ ባይና ዎርቃፐ ኦሰቴዳ ጾምፕያ ዎꬅያ ባላነ አን ማራን ደእያ ጾምፐቱዋ፥ ኡንቱንቱ ሚሻቱዋ ኡባነ ጾምፕያ ዛይትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","እጻና ጩዋይያ ዎርቃ ሳጽንያ፥ ኦከትያ ዛይትያ፥ ሳዊያ እጻና፥ ጾሳ ዱንካንያ ፐንግያ ጋርዱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ናሃስያፐ ኦꬄዳ ያርሽያ ሳኣ፥ አ ናሃስያ ዛዝሪያና፥ አ ቶክያ ካሱዋ፥ አ ሚሻቱዋ ኡባ፥ ሜቻ ከርያነ አ ዎꬅያዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ዳባባ ገንꬅያ ጋርዳቱዋ፥ አ ቱሳቱዋ፥ ኡንቱንቱ ኤቂያ ሳጽነቱዋ፥ ዳባባ ገልያ ፐንገቱዋ ጋርዱዋ፥ ዳባባ ዎዶሮቱዋነ ሽካላቱዋ፥ ጾሳ ዱንካንያ መꬋናዉ ኮሽያ ሚሻቱዋ ኡባ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ቄሳቱ ጌሻ ሳኣን ኦꬂደ ጎኤታናዉ ዳደቴዳ ማዮቱዋ፥ አሮነ ጌሻ ማዩዋነ አ ናናይ ቄሳተꬃ ኦꬂደ ማይያ ማዮቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","እስራኤላቱ ኦሱዋ ኡባካ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ኡባባ ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ሙሴ ኦሱዋ ኡባ ጾሞስ ጼሊደ፥ ኡንቱንቱ መꬍና ጎዳይ አዛዜዳዋዳን ኦꬄዳዋ በኤዳ። ሄዋ ድራዉ፥ ሙሴ ኡንቱንታ አንጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ኮይሮ አግናዉ ኮይሮ ጋላስ፥ ኔን መꬍና ጎዳ ዱንካንያ ቶካ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ቃላ ጫቁዋ ታቦታ አ ግዶን ዎꬃ፤ ሄ ታቦታ ጋርዱዋን ካማ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ጻርጴዛ ገልሳደ፥ አ ቦላ ዎꬋናዉ ኮሽያባ ኡባ ጊግሳደ አ ቦላ ዎꬃ። ያታደ ጾምፐቱዋ ዎꬅያ ባላ ሶ ገልሳደ፥ አ ቦላ ጾምፐቱዋ ኤꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","እጻና ጩዋይያ ዎርቃ ሳጽንያ ቃላ ጫቁዋ ታቦታፐ ስንꬃና ዎꬃደ፥ ጾሳ ዱንካንያ ገልያ ጋርዱዋ ሶታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“ጹግያ ያርሹዋ ያርሽያ ሳኣ ጾሳ ዱንካንያፐ ስንꬃና ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ሜቻ ከርያ ጾሳ ዱንካንያፐነ ያርሽያ ሳኣፐ ግዱዋን ዎꬃደ፥ አን ሃꬃ ትጋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ጾሳ ዱንካንያፐ ካረና ዩሻ አꬃደ ዳባባ ጊግሳደ ዳባባ ገልያ ሳኣን ጋርዱዋ ሶታ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ኦክያ ዛይትያ አካደ፥ ጾሳ ዱንካንያነ አ ግዶን ደእያ ኡባባ ኦካ፤ አነ አ ግዶን ጎኤትያ ሚሻ ኡባ ዱማያ፤ ያቶፐ እ ጌሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ሄዋፐ ጉይያን ጹግያ ያርሹዋ ያርሽያ ሳኣነ አዉ ጎኤትያ ሚሻ ኡባ ኦካ፤ ያርሽያ ሳኣ ዱማያ፤ ያቶፐ እ ኡባፐ አꬍያ ጌሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ሜቻ ከርያነ አ ኡትስያ ሚሻ ኦካደ ኡንቱንታ ዱማያ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“ኔን አሮናነ አ ናና ጾሳ ዱንካንያ ገልያ ፐንገ አሃደ፥ ሃꬃን ኡንቱንታ ሜጫ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ሄዋፐ ጉይያን ቄሰተꬃ ጌሻ ማዩዋ አሮና ማይዛደ፥ እ ታዉ ቄሰተꬃን ኦꬃናዳን፥ አ ኦካደ ዱማያ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","አ አቱማ ናናካ አሃደ ሻምጭያ ማይዛ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ኡንቱንቱ ታዉ ቄሰተꬃን ኦꬃናዳን፥ ኡንቱንቱ አዉዋ ኦኬዳዋዳን፥ ኡንቱንታካ ኦካ። ኡንቱንቱ ኦካይ ኡንቱንታካ ኡንቱንቱ ስንꬃ የለታ ኡባ ቄሳቱዋ ኦꬅያዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ሙሴ ኡባባካ ጾሳይ ባረና አዛዜዳዋዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ሄዋ ድራዉ፥ ግብጼፐ ኡንቱንቱ ከሴዳ ላኤንꬃ ላይꬃን፥ ኮይሮ አግናዉ ኮይሮ ጋላሳን ጾሳ ዱንካኒ ቶኬቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ሙሴ ጾሳ ዱንካንያ ኤስያ ዎደ፥ ሳጽነቱዋ ኡንቱንቱ ሳኣን ሳኣን ዎꬄዳ፤ ጻጋገቱዋነ ቱሳ አꬄዳ፤ ሽካላቱዋካ ገልሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ሄዋፐ ጉየ ሙሴ መꬍና ጎዳይ አዛዜዳዋዳን፥ ሀ ኤሴዳዋ ቦላን ዱንካንያ ꬎጌዳ፤ ሄ ኤሱዋ ቦላን ካሙዋ ካሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ያቲደ ታሙ አዛዛቱ ጻፈቴዳ ማርካተꬃ ቃላ አፊደ፥ ታቦታ ግዶን ዎꬄዳ፤ ቶክያ ካሱዋ ታቦታን አꬄዳ፤ አቶ ግያ ሳኣ ቁምእያ ታቦታ ቦላ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ሄዋፐ ጉይያን ታቦታ ጾሳ ዱንካንያ ገልሴዳ፤ ገንꬅያ ጋርዱዋ ሶቲደ፥ መꬍና ጎዳይ አዛዜዳዋዳን ቃላ ጫቁዋ ታቦታ ካሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ሙሴ ጻርጴዛ መꬍና ጎዳ ዱንካንያን ገልሲደ፥ ጋርዱዋፐ ካረና ሁጲሳ ባጋና ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","አ ቦላ መꬍና ጎዳ ስንꬃን ዎꬅያ ጌሻ ኡክꬃ ጊግሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ጾምፕያ ዎꬅያ ባላ ጾሳ ዱንካንያ ግዶ ገልሲደ፥ ጻርጴዛ ሄፍንꬃና፥ ጾሳ ዱንካንያዉ ገድሳ ባጋና ዎꬄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ቃይ ጾምፐቱዋ መꬍና ጎዳ ስንꬃን ኦይꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","መꬍና ጎዳይ አዛዜዳዋዳን፥ እጻና ጩዋይያ ዎርቃ ሳጽንያ ጾሳ ዱንካንያ ግዶን ጋርዱዋ ስንꬃ ባጋና ዎꬄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","አ ቦላ ሳዊያ እጻና ጩዋዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ሄዋፐ ጉይያን ጾሳ ዱንካንያ ፐንግያን ጋርዱዋ ሶቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ጹግያ ያርሹዋ ያርሽያ ሳኣ ጾሳ ዱንካንያ ገልያ ፐንግያ ምይያን ዎꬄዳ፤ አ ቦላ ጹግያ ያርሹዋነ ካꬃ ያርሹዋ መꬍና ጎዳይ አዛዜዳዋዳን ያርሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ጾሳይ ሙሳ አዛዜዳዋዳን፥ ሜቻ ከርያ ጾሳ ዱንካንያፐነ ያርሽያ ሳኣፐ ግዱዋን ዎꬄዳ። ያቲደ ሜጨታናዉ ሃꬃ አን ትጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ሙሴ፥ አሮነነ አ ናናይ ባረንቱ ኩሽያነ ገድያ አን ሜጨቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ኡንቱንቱ ጾሳ ዱንካንያ ገሌዳ ዎደ ዎይ ያርሽያ ሳኣኮ ሺቄዳ ዎደ አዉደነ ሜጨቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ጾሳ ዱንካንያነ ያርሽያ ሳኣ ዩሽ አꬂደ ዳባባ ከሴዳ፤ ሄ ዳባባ ፐንግያን ጋርዱዋ ሶቴዳ። ሄዋዳን ኦꬂደ፥ ሙሴ ኦሱዋ ፖሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ሄዋፐ ጉይያን ሻሪ ጾሳ ዱንካንያ ካሜዳ፤ መꬍና ጎዳ ቦንቹካ አ ኩሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ሻሪ ጾሳ ዱንካንያ ቦላ ኡቴዳ ድራዉነ መꬍና ጎዳ ቦንቹ አ ግዶን ኩሜዳ ድራዉ፥ ሙሴ አ ግዶ ገላናዉ ዳንዳይቤና። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","እስራኤላቱ ባረንቱ ኦግያ ኡባን፥ ሄ ሻሪ ጾሳ ዱንካንያፐ ደንድያ ዎደ አዉደነ አ ካሊደ ሀመታ ዶምኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ሽን ሄ ሻሪ ደንዳና ꬋዮፐ፥ እ ደንድያ ጋላሳይ ጋካናዉ ኡንቱንቱካ ቃጽክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ኡንቱንቱ ኦግያ ኡባን መꬍና ጎዳ ሻሪ እስራኤልያ አሳይ ኡባይ በእሽን፥ ጋላስ ጋላስ ጾሳ ዱንካንያ ካሜነ ቃማ ቃማ ቃይ ታማይ ሄ ሻርያ ግዶን ኤጼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","መꬍና ጎዳና ጋከትያ ዱንካንያ ግዶፐ መꬍና ጎዳይ ሙሳ ጼሲደ፥ ሀዋዳን ያጊደ ሃሳዬዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ህንተፐ ኦንነ መꬍና ጎዳዉ ያርሹዋ ሺሽያ ዎደ፥ ሄ ባረ ሺሽያ ያርሹዋ ባረ መህያፐ ዎይ ባረ ዶርሳ ዎይ ዴሻ ዉድያፐ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ሄ ያርሹ መህያ ዉድያፐ ጹግያ ያርሹዋ ግዶፐ፥ አቱማዋ ግዲደ፥ ትላ ቦላና ደእያዋ ግዶ። መꬍና ጎዳይ አካና ማላ፥ እ ሄ ያርሹዋ መꬍና ጎዳ ዱንካንያ ገልያ ፐንግያን ያርሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ያርሹዋ ሺሽያ ብታኒ ጹጊደ ያርሻናዉ አሄዳ ባረ መህያ ሁጲያን ባረ ኩሽያ ዎꬆ። ሄዌ አ ናጋራ አቶ ጋናዉ ጾሳይ አኬዳ ያርሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","እ ኮሩማ መꬍና ጎዳ ስንꬃን ሹክና፤ አሮና ናናይ ቄሳቱ ሄ ሱꬃ አሂደ፥ መꬍና ጎዳ ዱንካንያ ገልያ ፐንግያን ደእያ ያርሽያ ሳኣ ምይያ ኡባን ጉስኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ሄዋፐ ጉይያን፥ እ ጹግያ ያርሾ መህያ ጋልባ ቃሮ፤ አሹዋ አ ቆሙዋን ቆሙዋን ከሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ቄስያ አሮና ናናይ ያርሽያ ሳኣ ቦላን ታማ ኤꬂደ፥ ምꬃ ዎꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ሄዋፐ ጉይያን፥ አሮና ናናይ ቄሳቱ ሄ ከሴዳ አሹዋ ሁጲያነ ሞꬉዋ ጉጂደ፥ ያርሽያ ሳኣ ቦላን ታማን ደእያ ምꬃ ቦላን ማሪደ ዎꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ሽን ሄ ብታኒ ቃንꬃ አሹዋነ ገደቱዋ ሃꬃን ሜጮ። ያቲደ ቄሲ ሄዋ ኡባካ አሂደ፥ ያርሽያ ሳኣ ቦላ ጹጎ፤ ሄዌ መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘ጹግያ ያርሾ እ እምያ እሙ ዶርሳ ዉድያፐ ዎይ ዴሻ ዉድያፐ አከትያዋ ግዶፐ፥ አቱማዋ ግዲደ፥ ትላ ቦላና ደእያዋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ሄ መህያ ያርሽያ ሳኣፐ ሁጲሳ ባጋና መꬍና ጎዳ ስንꬃን ሹኮ። አሮና ናናይ ቄሳቱ አ ሱꬃ አኪደ፥ ያርሽያ ሳኣ ምይያ ኡባ ቦላን ጉስኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ሄዋፐ ጉይያን፥ ሄ ብታኒ አ ቆሙዋን ቆሙዋን ከሴዳ አሹዋ ኡባ ቄሲ አኪደ፥ ሁጲያነ ሞꬉዋ ጉጂደ፥ ያርሽያ ሳኣ ቦላን ታማን ደእያ ምꬃ ቦላን ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ሽን ቃንꬃ አሹዋነ ገደቱዋ ሃꬃን ሜጮ፤ ያቲደ ቄሲ ሄዋ ኡባ አሂደ ያርሽያ ሳኣ ቦላን ጹጎ፤ ሄዌ መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘መꬍና ጎዳዉ ያርሽያ ጹግያ ያርሹ ካፉዋ ግዶፐ፥ ሀራጵያ ማራ፥ ዎይ ዶጎሙዋ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ቄሲ ሄዋ አኪደ፥ ቆꬍያ ምርቆ፤ ያቲደ ያርሽያ ሳኣ ቦላን ደእያ ታማን ጹጎ። አ ሱꬃይ ያርሽያ ሳኣ ቦላፐ ምይያና ዱገ ጎግ ጭንጎ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ኡሎ ግዱዋ ባለቱዋና ከሲደ፥ ያርሽያ ሳኣፐ አዋይ ዶልያ ባጋና፥ ብድንꬃ ቆልያ ሳኣን ኦሎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","እ ሄ ካፉዋ ቀፈቱዋ ኦይቂደ ጳልቆ፥ ሽን ኡባና ዳኮፖ። ሄዋፐ ጉይያን፥ ቄሲ ያርሽያ ሳኣ ቦላን ደእያ ታማን ዎꬂደ ጹጎ፤ ሄዌ መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘ኦንነ ካꬃ ያርሹዋ መꬍና ጎዳዉ ሺሽያ ዎደ፥ ሄ ያርሹ ሊቆ ꬊልያ ግዶ፤ አ ቦላ ዎጋራ ዛይትያነ እጻና ጉጆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ሄዋ እ አሮና ናናቱዋኮ ቄሳቱዋኮ አሆ፤ ቄሳቱ ሄ ሊቆ ꬊልያፐነ ዛይትያፐ እት ኩሽያ ኩንꬅ አኪደ፥ እጻና ኡባና አክ፥ ሀሳይስያዋ ኦꬂደ፥ ያርሽያ ሳኣ ቦላ ታማን ጹጎ። ሄዌ መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ካꬃ ያርሹዋፐ አቴዳዌ አሮናሳነ አ ናናቱዋሳ። ሄዌ መꬍና ጎዳዉ ታማን ጹገትያ ጌሻ ያርሹዋ ኡባፐ እቱዋ ግዴዳ ጌሻ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘ያርሾ ሺሽያ ኡክꬃይ ጮጭያን ካኤዳዋ ግዶፐ፥ ዛይትያን ሙናቄዳ ሊቆ ꬊልያፐ ኡከቴዳ እርሹ የገትቤና ኮምፖ፥ ዎይ ዛይትያን ኦከቴዳ፥ እርሹ የገትቤና ሌኦ ኡክꬃ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“ ‘ያርሾ ሺሽያ ኡክꬃይ ባሽያን ኡከቴዳዋ ግዶፐ፥ ዛይትያን ሙናቄዳ፥ እርሹ ባይና፥ ሊቆ ꬊልያፐ ጊጌዳዋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","አ መንꬂደ አ ቦላ ዛይትያ ትጎ፤ ሄዋ ካꬃ ያርሹዋ ኦꬂደ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“ ‘ነ ያርሾ ሺሽያ ካꬃ ያርሹ ድስትያን ካኤዳዋ ግዶፐ፥ ዛይትያን ሙናቄዳ ሊቆ ꬊልያፐ ካኤዳዋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ሀዋዳን ጊግሴዳ ካꬃ ያርሹዋ መꬍና ጎዳዉ አሀ፤ ቄስያዉ እማ። ቄሲ ሄዋ አኪደ ያርሽያ ሳኣ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ቄሲ ሄ ካꬃ ያርሹዋፐ አኪደ፥ ሀሳይስያዋ ኦꬂደ፥ ያርሽያ ሳኣ ቦላን ጹግያ ያርሹዋዳን ታማን ጹጎ፤ ሄዌ መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ካꬃ ያርሹዋፐ አቴዳዌ አሮነሳነ አ ናናቱዋሳ። ሄዌ መꬍና ጎዳዉ ታማን ጹጌዳ፥ ጌሻ ያርሹዋ ኡባፐ እቱዋ ግዴዳ ጌሻ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘ጾሳዉ ህንተ አህያ አይ ካꬃ ያርሹነ እርሹዋና ደእያዋ ግዶፖ፤ አያዉ ጎፐ ኔን እርሹዋ ዎይ ኤሳ እልሉዋ ጾሳዉ ታማን ጹጋደ ያርሻናዉ ኮሸና። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ህንተ ላይꬃን ላይꬃን ጫከትያ ካꬃፐ ጼራ ከሲደ፥ ጾሳዉ አሀናዉ ዳንዳዪታ፤ ሽን ሄዋ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ኦꬂደ፥ ጾሳዉ ያርሽያ ሳኣ ቦላን ጹገተና። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ኔን ሺሽያ ካꬃ ያርሹዋ ኡባን ማጽንያ የጋ፤ አያዉ ጎፐ፥ ነ ጾሳ ቃላ ጫቁዋ ማጽንያ አጎፓ። ሄዋ ድራዉ ነ ካꬃ ያርሹዋ ኡባ ማጽንያን ማልኤꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ኔን ኮይሮ ካꬃፐ ጼራ ከሳደ መꬍና ጎዳዉ አህያ ዎደ፥ ሄ ካꬃይ ጺጸቲደ ሀርጸቴዳ ትሻ ካꬃ ግዳናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","አ ቦላ ዛይትያ ትጋ፤ እጻናካ አን ዎꬃ፤ ሄዌ ካꬃ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ቄሲ ሄ ዛይቲ ትገቴዳ ሀርጸቴዳ ካꬃፐ ሻኩዋ አኪደ፥ እጻና ኡባናካ ሀሳይስያዋ ኦꬂደ ታማን መꬍና ጎዳዉ ጹጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘እት አሳይ እትፐተꬃ ያርሾ ባረ ዉድያፐ ማጫዋ ግድና አቱማዋ ግድና እት መህያ ሺሽያ ዎደ፥ ሄ መሂ ትላ ቦላና ደእያዋ መꬍና ጎዳ ስንꬃን ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ያርሻናዉ አሄዳ መህያ ሁጲያን ባረ ኩሽያ ዎꬂደ፥ ጾሳ ዱንካንያ ፐንግያን ሹኮ። ሄዋፐ ጉይያን፥ ቄሳቱ አሮና ናናይ ሱꬃ ያርሽያ ሳኣ ምይያ ኡባ ቦላን ጉሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","እትፐተꬃ ያርሹዋፐ ታማን ጹግያ ያርሹዋ ኦꬂደ መꬍና ጎዳዉ ሺሾ፤ ሄዌካ ቃንꬃ አሹዋ ማዬዳ ሀንዳ ኡባይነ አናና ጋꬅያ ሀንዳይ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ላኡ ክላሆቱዋ፥ ኡንቱንቱ ቦላ ደእያ ሀንዳ፥ ጋይልያ ማታን ደእያ ሀንዳነ ትርያ ጼራ ቦላ ደእያ ሀንዳ ክላሆቱዋና ጋꬂደ አኬ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","አሮና አቱማ ናናይ ሄዋ ሀራ ጹግያ ያርሹዋና ያርሽያ ሳኣ ቦላ ደእያ ምꬃ ቦላ ዎꬂደ ጹግኖ፤ ሄዌ መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘መꬍና ጎዳዉ እትፐተꬃ ያርሹዋ ሺሽያ ኡራይ ዶርሳ ግድና ዴሻ፥ ማጫዋ ግድና አቱማዋ ትላ ቦላና ደእያዋ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","እት ኡራይ ዶርሳ ማራ ያርሽያዋ ግዶፐ፥ መꬍና ጎዳ ስንꬃን ሺሾ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ባረ ኩሽያ አ ሁጲያን ዎꬂደ፥ ዱንካንያ ስንꬃን ሹኮ። ሄዋፐ ጉይያን፥ አሮና አቱማ ናናይ ሱꬃ ኦይቂደ፥ ያርሽያ ሳኣ ምይያ ኡባ ቦላን ጉስኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","እትፐተꬃ ያርሹዋፐ ታማን ጹግያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳዉ ሺሾ፤ ሄዌካ፥ ዚዝያፐ ቃንጼዳ ናስያ፥ ኡሎ ግዶ አሹዋ ማዬዳ ሞꬍያነ ሀዋንታ ጋꬅ ኦይꬅያ ሞꬍያ ኡባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ላኡ ክላሆቱዋ፥ ኡንቱንቱ ቦላ ደእያ ሀንዳነ ጋይልያ ማታን ደእያ ሞꬍያ፥ ትርያ ጼራ ቦላ ደእያ ሞꬍያ ክላሆቱዋና ጋꬂደ አኬ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ቄሲ ሄ ቁማ ያርሹዋ መꬍና ጎዳዉ ታማን ጹግያ ያርሽያ ሳኣ ቦላ ዎꬂደ ጹጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘አ ያርሹ ዴሻ ግዶፐ፥ እ ሄዋ መꬍና ጎዳ ስንꬃን ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ያቲደ አ ሁጲያን ባረ ኩሽያ ዎꬂደ፥ ጾሳ ዱንካንያ ስንꬃን ሹኮ። ሄዋፐ ጉይያን፥ አሮና አቱማ ናናይ ሱꬃ ኦይቂደ፥ ያርሽያ ሳኣ ዩሹዋን ኡባን ጉሲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","እ ሄ ያርሽያዋፐ አኪደ፥ ታማን ጹግያ ያርሹዋ ኦꬂደ መꬍና ጎዳዉ ሺሾ፤ ሄዌካ ቃንꬃ አሹዋ ማዬዳ ሀንዳ ኡባነ ሄ ሀንዳ ጋꬅ ኦይꬅያ ሀራ ሀንዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ላኡ ክላሆቱዋ፥ ኡንቱንቱ ቦላ ደእያ ሀንዳነ ጋይልያ ማታን ደእያ ሞꬍያነ ትርያ ጼራ ቦላ ደእያ ሞꬍያ ክላሆቱዋና ጋꬂደ አኬ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ቄሲ ሄ ቁማ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ኦꬂደ ያርሽያ ሳኣ ቦላ ጹጎ። ሀንዳ ኡባይ መꬍና ጎዳሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘ሀንዳነ ሱꬃ ህንተ ደእያ ሳኣን ሀቃንነ ሞፕተ። ሀዌ ህንተንቶነ ህንተ የለታዉ መꬍናዉ ናገትያ ዎጋ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ኔን እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ኦንነ ቆፐናን ናጋራ ኦꬆፐነ፥ መꬍና ጎዳ አዛዞቱዋፐ እቱዋ ሀቃዋነ መንꬆፐ፥ ሀዋፐ ካሊደ ደእያ ዎጋ ናጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘ቄስያ ካፑ ናጋራ ኦꬆፐነ ሄ ናጋራይ አሳ ባይዛንቻ ከስያዋ ግዶፐ፥ እ ባረ ኦꬄዳ ናጋራ ድራዉ፥ ትላ ቦላና ደእያ ኮሩማ መꬍና ጎዳዉ ናጋራ ያርሹዋ ኦꬂደ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ሄ ኮሩማ መꬍና ጎዳ ዱንካንያ ፐንገ አꬂደ፥ ኮሩማ ሁጲያን ባረ ኩሽያ ዎꬂደ፥ መꬍና ጎዳ ስንꬃን ሹኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ቄስያ ካፑ ኮሩማ ሱꬃፐ አማሬዳዋ አኪደ፥ መꬍና ጎዳ ዱንካንያ አፎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ባረ ኩሽያ ብራꬍያ ሱꬃን ቱሽ ቱሽ ከሲደ፥ መꬍና ጎዳ ዱንካንያ ጋርዱዋ ስንꬃን መꬍና ጎዳ ስንꬃን ላፑ ገደ ዱኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ሄዋፐ ጉይያን፥ ቄስያ ካፑ አማሬዳ ሱꬃ አኪደ፥ መꬍና ጎዳ ዱንካንያ ግዶን መꬍና ጎዳ ስንꬃን ሳዊያ እጻና ጩውስያ ሳጽንያ ቦላ ደእያ ካጨቱዋ ቦላ ጾክሶ። አቴዳ ሱꬃ ቃይ ጾሳ ዱንካንያ ገልያ ሳኣ ባጋና ደእያ ጹግያ ያርሹዋ ያርሽያ ሳኣፐ ጋርሳ ባጋና ደእያ ሳኣን ጉሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ናጋራ ያርሾ ሹከቴዳ ሀ ኮሩማ ሞꬉዋ ኡባ፥ ቃንꬃ አሹዋ ማዬዳ ሀንዳነ ኡንቱንታ ጋꬅ ኦይꬅያ ሞꬉዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ላኡ ክላሆቱዋ፥ ኡንቱንታ ማዬዳ ሀንዳነ ጋይልያ ማታን ደእያ ሞꬍያነ ትርያ ጼራ ቦላ ደእያ ሞꬍያ ክላሆቱዋና እትፐ ከሲደ አኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","እትፐተꬃ ያርሾ ሹከቴዳ ኮሩማፐ አኬዳ ሞꬉዋዳን አኮ። ቄስያ ካፑ ጹግያ ያርሹዋ ያርሽያ ሳኣ ቦላን ጹጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ሽን ኮሩማ ጋልባ፥ አ አሹዋ ኡባ፥ አ ሁጲያነ፥ አ ገደቱዋ፥ ቃንꬃ አሹዋ፥ ቶጭያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ኮሩማ አሹዋፐ አቴዳዋ ኡባ ዱንካኔዳ ሳኣፐ ካረ ከሲደ፤ ብድንꬃ ቆልያ ዎጋዳን ጌሻ ግዴዳ ሳኣ አፎ፤ ያን ምꬃ ታማን ጹጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘እስራኤልያ ማባራይ ኡባይ ቆፐናን ናጋራ ኦꬆፐነ፥ መꬍና ጎዳ አዛዞቱዋፐ እቱዋ ሀቃዋነ መንꬆፐ፥ ኡንቱንቱ ባይዛንቻ ግዲደ ፓይደታና። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ኡንቱንቱ ኦꬄዳ ናጋራይ ኤረትያ ዎደ፥ ናጋራ ያርሾ ሀንያ ኮሩማ ጾሳ ዱንካንያ ስንꬃ አህኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ሄ ማባራ ጭማቱ መꬍና ጎዳ ስንꬃን ባረንቱ ኩሽያ ኮሩማ ሁጲያ ቦላን ዎꬂደ፥ ሄ ኮሩማ መꬍና ጎዳ ስንꬃን ሹክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ሄዋፐ ጉይያን፥ ቄስያ ካፑ ኮሩማ ሱꬃፐ ጉꬃ አኪደ፥ ጾሳ ዱንካንያ ግዶ ገሎ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","እ ባረ ኩሽያ ብራꬍያ ሱꬃን ቱሽ ቱሽ ከሲደ፥ ጋርዱዋ ስንꬃ ባጋና መꬍና ጎዳ ስንꬃን ላፑ ገደ ዱኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ቃይ አማሬዳ ሱꬃ አኪደ፥ መꬍና ጎዳ ዱንካንያ ግዶን ስንꬃን እጻና ጩውስያ ሳጽንያ ቦላ ደእያ ካጨቱዋ ቦላ ጾክሶ። አቴዳ ሱꬃ ቃይ መꬍና ጎዳ ዱንካንያ ገልያሳ ባጋና ደእያ ጹግያ ያርሹዋ ያርሽያ ሳኣፐ ጋርሳ ባጋና ደእያ ሳኣን ጉሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ሞꬉዋ ኡባ አኪደ፥ ያርሽያ ሳኣ ቦላን ጹጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ናጋራ ያርሾ ሹከቴዳ ኮሩማ ኦꬄዳዋዳን ሀ ኮሩማካ ኦꬆ። ሄዋዳን ኦꬂደ፥ ቄሲ ናጋራ አቶ ጊስያ ዎጋ ፖላና፤ አሳይካ ናጋራፐ ማረታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ሄዋፐ ጉይያን፥ ኮሩማ ዱንካኔዳ ሳኣፐ ካረ ከሲደ፥ ካሰ ኮሩማ ጹጌዳዋዳን አካ ጹጎ፤ ሀዌ ማባራ ናጋራዉ ያርሽያ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘አሳ ካለꬅያ ሱንꬃቱዋፐ እቱ ቆፐናን ናጋራ ኦꬆፐነ መꬍና ጎዳይ አ ጾሳይ አ አዛዜዳ አዛዙዋፐ እቱዋ ሀቃዋነ መንꬆፐ፥ ሄ ኡራይ ባይዛንቻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","እ ባረ ኦꬄዳ ናጋራ ኤሬዳዋፐ ጉይያን፥ ትላ ቦላና ደእያ እት ዴሻ ኦርግያ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ሄ ዴሻ ኦርግያ ሁጲያን ባረ ኩሽያ ዎꬂደ ጹግያ ያርሹ መꬍና ጎዳ ስንꬃን ሹከትያ ሳኣን ሹኮ፤ ሄዌ ናጋራ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ቄስያ ካፑ ናጋራ ያርሹዋ ሱꬃ ግዶ ባረ ኩሽያ ብራꬍያ ቱሽ ቱሽ ከሲደ፥ ጹግያ ያርሹዋ ያርሽያ ሳኣ ቦላ ደእያ ካጨቱዋ ቦላ ጾክሶ፤ አቴዳ ሱꬃ ቃይ ጹግያ ያርሹዋ ያርሽያ ሳኣፐ ጋርሳ ባጋና ደእያ ሳኣን ጉሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ሞꬉዋ ኡባ እትፐተꬃ ያርሹዋ ሞꬉዋ ያርሽያዋዳን ያርሽያ ሳኣ ቦላን ያርሾ። ሀዋዳን ኦꬂደ፥ ቄሲ ብታንያ ናጋራ አቶ ጊሴ፤ ብታኒካ ባረ ናጋራፐ ማረታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘ሄ ማባራ አሳፐ እቱ ቆፐናን ናጋራ ኦꬆፐነ መꬍና ጎዳ አዛዙዋፐ እቱዋ ሀቃዋነ መንꬆፐ፥ ሄ ኡራይ ባይዛንቻ ግዲደ ፓይደቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","እ ባረ ኦꬄዳ ናጋራይ አዉ ኤረቴዳዋፐ ጉይያን፥ ትላ ቦላና ደእያ ማጫ ዴሻቶ ባረ ናጋራዉ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ባረ ኩሽያ ናጋራ ያርሹዋ ኦꬂደ ሹክያ ዴሻት ሁጲያን ዎꬆ፤ ያቲደ ጹግያ ያርሹዋ ያርሽያ ሳኣን ናጋራ ያርሹዋ ኦꬂደ ሹኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ሄዋፐ ጉይያን፥ ቄስያ ካፑ ሄ ዴሻት ሱꬃፐ ባረ ኩሽያ ብራꬍያን አኪደ፥ ጹግያ ያርሹዋ ያርሽያ ሳኣ ቦላ ደእያ ካጨቱዋ ቦላ ጾክሶ፤ አቴዳ ሱꬃ ኡባ ያርሽያ ሳኣፐ ጋርሳ ባጋና ደእያ ሳኣን ጉሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ሞꬉዋ ኡባ እትፐተꬃ ያርሾ ሹኬዳ መህያፐ ከስያዋዳን፥ ሄ ዴሻት ሞꬉዋካ ቆሪደ ከስ አኪደ፥ ያርሽያ ሳኣ ቦላ ዎꬂደ፥ መꬍና ጎዳዉ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ግዳና ማላ ጹጎ። ሄዋዳን ኦꬂደ፥ ቄሲ ሄ ብታንያ ናጋራ አቶ ጊሴ፤ ብታኒካ ባረ ናጋራፐ ማረቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘ሄ ብታኒ ባረ ናጋራ ያርሾ ዶርሳ ሺሻናዉ ኮዮፐ፥ ትላ ቦላና ደእያ ማጫውኖ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","እ ባረ ኩሽያ ሄ ዶርሳት ሁጲያን ዎꬂደ ጹግያ ያርሾ ሹክያ መሂ ሹከትያ ሳኣን እዞ ሹኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ሄዋፐ ጉይያን፥ ቄሲ ናጋራ ያርሹዋ ግዴዳ ሄ ዶርሳት ሱꬃን ባረ ብራꬍያ ቱሽ ቱሽ ከሲደ፥ ጹግያ ያርሹዋ ያርሽያ ሳኣ ቦላ ደእያ ካጨቱዋ ቦላ ጾክሶ፤ አቴዳ ሱꬃ ቃይ ያርሽያ ሳኣፐ ጋርሳ ባጋና ደእያ ሳኣን ጉሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","እትፐተꬃ ያርሾ ሹከቴዳ ሞꬉዋ ቃሪደ ከስያዋዳን፥ ሄ ዶርሳት ሞꬉዋካ ቃሪደ ከሶ። ያቲደ፥ ያርሽያ ሳኣ ቦላ መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋ ቦላ ዎꬂደ ጹጎ። ሀዋዳን ኦꬂደ፥ ቄሲ ሄ ብታንያ ናጋራ አቶ ጊሴ። ብታኒካ ባረ ናጋራፐ ማረታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘አይ አሳይነ ማርካዉ ጼሰቲደ ባረ በኤዳዋ ዎይ ባረ ኤሬዳዋ ጉታራን ማርካተናን እጾፐ፥ ሄዌ አዉ ናጋራ፤ ሄዋ ድራዉ እ ባረ ናጋራን ኦሸቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘ቃይ አይ አሳይነ ኤረናን ደኢደ ቱናባ፥ ዶኣ ባኩታ ዎይ መህያ ባኩታ ዎይ ሳኣና ጎሸትያ ዶአቱዋ ባኩታ ቦቾፐ፥ ቱና ግድያዋ እ ኤሬዳ ዎድያፐ ዶሚደ ባይዛንቻ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ ‘ቃይካ አይ አሳይነ ኤረናን ደኢደ፥ አሳ ቦላፐ ጎግያ ቱንስያባ አያ ግድናካ ቦቾፐ፥ ሄዌ ቱና ግድያዋ እ ኤሬዳ ዎድያፐ ዶሚደ ባይዛንቻ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ ‘ዎይ ቃይ አይ አሳይነ ኢታባ ግድና ሎኦባ ኦꬃናዉ ኤለካ ጫቆፐነ ባረ ጫቄዳዋካ እ አኬከናን ꬋዮፐ፥ እ አኬኬዳ ዎድያፐ ዶሚደ ባይዛንቻ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“ ‘አይ አሳይነ ሀ ኦደቴዳ ባይዛቱዋፐ እቱዋ ኦꬄዳዋ ግዶፐ፥ ባረ ኦꬄዳ ናጋራ ፓጾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","እ ባረ ኦꬄዳ ናጋራ ድራዉ መꬍና ጎዳዉ ባረ ዉድያ ግዶፐ ማጫ ዶርሳ ዎይ ማጫ ዴሻ ናጋራ ያርሹዋ ኦꬂደ ሺሾ። ቄሲ አኪደ፥ ሄ ብታንያ ናጋራ አቶ ጊሳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘አሳይ ባረ ኦꬄዳ ናጋራዉ ያርሻናዉ፥ ዶርሳ ዎይ ዴሻ ሻማናዉ አዉ ሻሉ ግዳና ꬋዮፐ፥ ላኡ ሀራጰቱዋ፥ ዎይ ላኡ ዶጎማቱዋ፥ እቱዋ ናጋራ ያርሹዋ ኦꬂደ፥ ቃይ እቱዋ ጹግያ ያርሹዋ ኦꬂደ መꬍና ጎዳዉ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","እ ኡንቱንታ ቄስያዉ እሞ። ቄሲ ላኡ ሀራጰቱዋፐ እትንዉ ቆꬍያ ሙጨናን ጮ ምርቂደ፥ ናጋራ ያርሹዋ ኦꬂደ ያርሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ያቲደ ሄ ናጋራ ያርሹዋ ሱꬃፐ አማሬዳዋ አኪደ፥ ያርሽያ ሳኣ ምይያን ጫጫፎ፤ አቴዳ ሱꬃ ያርሽያ ሳኣፐ ጋርሳ ባጋና ጉሶ፤ ሄዌ ናጋራ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","የንኮ ሀራጳቶ ቃይ ህጊ አዛዝያዋዳን፥ ጹግያ ያርሹዋ ኦꬂደ ጹጎ። ቄሲ ሄዋዳን ኦꬂደ፥ ብታኒ ኦꬄዳ ናጋራ አቶ ጊሳናዉ ያርሹዋ ያርሼ፤ ብታኒካ ባረ ናጋራፐ ማረታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘ሽን እት ኡራዉ ላኡ ዎጋ ዶጎማቱዋ ዎይ ላኡ ሀራጰቱዋ አሀናዉ ሻሉ ግዳና ꬋዮፐ፥ ላኡ ኪሎ ግራመ ሊቆ ꬊልያ ባረ ናጋራዉ ሺሽያ ያርሹዋ ኦꬂደ አሆ። ሄ ꬊሊ ናጋራ ያርሹዋ ግድያ ድራዉ፥ ዎጋራ ዛይቲ ዎይ እጻናይ አን ጉጀቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","እ ሄዋ አሂደ ቄስያዉ እሞ፤ ቄሲ ሄ ꬊልያፐ እት ኩሽያ ኩንꬅ አኪደ፥ መꬍና ጎዳዉ ሺሽያ ሀራ ያርሹዋ ቦላ ዎꬂደ፥ ሀሳይስያዋ ኦꬂደ ያርሽያሳን ደእያ ታማን ጹጎ፤ ሄዌ ናጋራ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ሀ ጌተቴዳዋንቱፐ ሀቃዋንነ ግዶ ብታኒ ኦꬄዳ ናጋራዉ ቄሲ ሀዋዳን ኦꬂደ፥ ብታኒ ኦꬄዳ ናጋራ አቶ ጊሴ፤ ብታኒካ ባረ ናጋራፐ ማረታናዋ። ካꬃ ያርሹዋዳንካ አቴዳዋ ቄሲ አኮ ያጋደ ኦዳ’ ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጊደ ኦዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ኦንነ መꬍና ጎዳዉ ጌሽ ዎꬄዳ ሚሻቱዋ ቦላ አማነተናን ꬋዮፐ ቃይ ኤረናን ናጋራ ኦꬆፐ፥ ባረ ናቆ ባረ ዉድያ ግዶፐ ትላ ቦላና ደእያ እት ዶርሳ ኦርግያ መꬍና ጎዳዉ አሆ። አ ጋቲካ መꬍና ጎዳ ዱንካንያን ኤረትያ ሚዛናን ዎꬅና ኤረቶ፤ ሄዌ ናቁዋ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","መꬍና ጎዳዉ ዱማይ ዎꬄዳ ሚሻቱዋ ቦላ እ ናጋራ ኦꬄዳ ድራዉ፥ እ ሄ ሚሻቱዋ ጋትያ ጭጎ፤ ካሰ ጋትያ ቦላ ጼቱዋፐ ላታሙ ኩሽያ ጉጂደ ቄስያዉ እሞ። ቄሲ ሄ ናቁዋ ያርሾ አሄዳ ዶርሳ ያርሺደ፥ ብታንያ ናጋራ አቶ ጊሴ፤ ብታኒካ ባረ ናቁዋፐ ማረታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“አይ አሳይነ ኤረናን ደኢደ፥ መꬍና ጎዳይ፥ ‘ኦꬆፓ’ ጊደ አዛዜዳዋፐ እቱዋ ኦꬂደ ናጋራን ገሎፐ፥ እ ኤራና ꬋዮፐ ባይዛንቻ ግድያ ድራዉ፥ ባረ ናጋራን ኦሸቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","እ ባረ ዉድያፐ ትላ ቦላና ደእያ እት ዶርሳ ኦርግያ ናቁዋ ያርሾ ቄስያኮ አሆ። ሄ ዶርሳይ ናቆ ጭግያ ጋትያ ከስያዋ ግዶ፤ ያቶፐ ቄሲ ሄ ዶርሳ ያርሺደ፥ ብታንያ ናቁዋ አቶ ጊሴ፤ ብታኒካ ባረ ናቁዋፐ ማረቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ሄዌ ናቁዋ ያርሹዋ። እ ቱሙካ መꬍና ጎዳ ናቄዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“መꬍና ጎዳይ ኦንነ ናጋራ ኦꬂደ ባረ ሾሩዋ ዎርዶቲደ ጭሞፐ ሀዋፐ ካሊደ ደእያ ህገቱዋ እሜዳ: ሾሩዋ ማታን ሀዳራ ዎꬆባ ዎይ ኦይꬂደ ታልኤዳባ ካዶፐ፥ ዎይ አሳዋ ቦንቆፐ፥ ዎይ ባረ ሾሩዋ ቦላን ሱገꬃ ኦꬆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ዎይ ባዬዳዋ ደሚደ ታ በአበይከ ጎፐነ ዎርዱዋን ጫቆፐ፥ ሀዋንታ ማላትያዋንቱፐ እቱዋ ኦꬆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","እ ሀቃዋነ ግዶ፥ ኦꬂደ፥ ሄዋን ናጋራንቻ ግዶፐ፥ ባረ ቦንቂ አኬዳዋ፥ ዎይ ኦይꬅና ካዲደ አኬዳዋ፥ ዎይ ሀዳራ እሜዳዋ ዎይ፥ ባይና ደሜዳዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ዎይ ዎርዱዋን ጫቂ አኬዳዋ ኡባካ አ ጎዳዉ ዛሮ። ቃይ ባረ ናቁዋ ያርሹዋ ያርሽያ ጋላስ ባረ አኬዳዋ ቦላ ጼቱዋፐ ላታሙ ኩሽያ ጉጂደ አ ጎዳዉ እሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ቃይካ ባረ ናቁዋ ድራዉ መꬍና ጎዳዉ ያርሽያ ያርሾ ባረ ዉድያ ግዶፐ ትላ ቦላና ደእያ እት ዶርሳ ኦርግያ ቄስያኮ አሆ። ሄ ዶርሳ ጋቲ ሱረ ቆፈቴዳዋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ቄሲ ሄ ዶርሳ መꬍና ጎዳ ስንꬃን ያርሺደ፥ ብታንያ ናቁዋ አቶ ጊሴ፤ ብታኒካ ባረ ናቁዋ ኡባፐ ማረታናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጊደ ኦዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“አሮናነ አ አቱማ ናናቱዋ ሀዋዳን ያጋደ አዛዛ፤ ‘ጹግያ ያርሾ ደእያ ዎጋይ ሀዋ: ጹግያ ያርሹ ቃማይ ዎንታና ጋካናዉ ያርሽያ ሳኣን ደኦ። ታማይካ ያርሽያ ሳኣን ኡባ ዎደ ኤጺደ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ቄሲ ሊኑዋፐ ዳደቴዳ ቃምሽያነ ሱርያ ማዪደ፥ ጹግያ ያርሹዋ ታማይ ም ስምና አቴዳ ብድንꬃ ደንꬂደ፥ ያርሽያ ሳ ምይያን ላሎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ሄዋፐ ጉይያን፥ ሄ ማዩዋ ቃር ዎꬅ ሀራ ማዩዋ ማዪደ፥ ሄ ብድንꬃ ዱንካኔዳ ሳኣፐ ጋጻ አፊደ፥ ህግያዳን ጌዬዳ ሳኣን ቆሎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ያርሽያ ሳኣ ቦላ ደእያ ታማይ ቶኤናን ኡባ ዎደ ኤጺደ ደኦ። ቄሲ ዎንታ ዎንታ ምꬃ አን ጉጅ ጉጂደ ዎꬆ። ጹግያ ያርሹዋካ ሄ ምꬃ ቦላ ማራን ዎꬂደ፥ እትፐተꬃ ያርሹዋ ሀንዳ አ ቦላ ጹጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ታማይ ያርሽያ ሳኣ ቦላ ኡባ ዎደ ኤጺደ ደኦ፤ ቶአናዉ ኮሸና። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘ካꬃ ያርሾ እመቴዳ ዎጋይ ሀዋ: አሮና አቱማ ናና ግድያ ቄሳቱ ያርሽያ ሳኣፐ ስንꬃ ባጋና መꬍና ጎዳ ስንꬃን ሺሽኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ቄሲ ሎኦ ꬊልያፐ ኮጵያዋነ ዛይትያ አኪደ፥ ካꬃ ያርሹዋ ቦላ ደእያ እጻና ኡባካ ደንꬂደ፥ መꬍና ጎዳዉ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ኦꬂደ፥ ሀሳይስያዋ ግዳናዳን ያርሽያ ሳኣ ቦላ ጹጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ሄዋፐ አቴዳዋ አሮንነ አ አቱማ ናናይ ሚኖ፤ ሄዋ ኡንቱንቱ እርሹ የገትቤና ኡክꬃ ኦꬅ ኡኪደ፥ ዱንካንያ ዳባባ ግዶን ደእያ ጌሻ ሳኣን ሚኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ሄ ኡክꬃይ እርሹዋ የገናን ኡከቶ። ሄዋ ታዉ ታማን ጹግያ ያርሹዋፐ ኡንቱንታ ጋክያዋ ታን ኡንቱንቶ እማድ። ናጋራ ያርሹዋዳንነ ናቁዋ ያርሹዋዳን እካ ሎይꬂደ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋፐ ኡንቱንታ ጋክያዋ ግድያ ድራዉ፥ ይያ ላይꬃቱዋንካ አሮና ዛረ ግድያ አቱማዋንቱ ኡባይ ሄዋ ሚኖ። ሄ ያርሹዋ ቦችያ አያይነ ጌሻ ግዳና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","መꬍና ጎዳይ ቃይካ ሙሴዉ ሀዋዳን ያጊደ ኦዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“አሮንነ አ አቱማ ናናቱዋፐ ቄሳተꬃ ካፖተꬃዉ ኦከትያ ጋላስ ላኡ ኪሎ ግራመ ግድያ ሎኦ ꬊልያ ካꬃ ያርሹዋ ኦꬂደ መꬍና ጎዳዉ አህኖ። ሄዋፐ ባጋ ዎንታ፥ ባጋ ኦማርስ ያርሽኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ሄ ꬊሊ ዛይትያን ሙናቀት ሎኦ ዋላከቲደ ባሽያን ኡከቶ፤ ቡንቻደ፥ ሳዉዋ ቶሹኩ ግያ ካꬃ ያርሹዋ ኦꬃደ መꬍና ጎዳዉ ሺሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ቃይ አሮና አቱማ ናናቱዋፐ አ ቄሰተꬃ ካፖተꬃ ኦሶ ኦከትያ ኡባይካ ሄ ዎጋ ኦꬅኖ። ሄዌ መꬍና ጎዳዉ ኡባ ገደ ያርሽያ ያርሹዋ ግዲደ ኡባና ጹገቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ቄሲ ሺሽያ ካꬃ ያርሹዋፐ ጉየ አተናን ዉር ጹገቶ፤ አፐ አያይነ ሜተቶፖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጊደ ኦዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“አሮናሳነ አ አቱማ ናናቶ፥ ሀዋዳን ያጋ፤ ‘ናጋራ ያርሹዋ ዎጋይ ሀዋ: መꬍና ጎዳዉ ጹግያ ያርሾ ሺሽያ መሂ ሹከትያ ሳኣን ናጋራ ያርሾ ሺሽያ መሂካ ሄዋን ጾሳ ስንꬃን ሹከቶ፤ እካ ጌሻ ያርሹዋ ኡባፐ እቱዋ ግዴዳ ጌሻ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ሄ ያርሹዋ ያርሽያ ቄሲ ዱንካንያ ዳባባ ግዶን ደእያ ጌሻ ሳኣን ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ሄ አሹዋ ቦችያ አያይነ ጌሻ ግዳናዋ፤ ቃይ ሹክሺን አይ ማዩዋ ቦላነ ሱꬃይ ꬋጨቶፐ፥ ሄ ማዩ ጌሻ ሳኣን ሜጨቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","አሹ ዶይሰቴዳ ኡርቃ ሚሻይ መኦ፤ ማዳብያ ብራታ ድስትያን ዶይሴዳዋ ግዶፐ፥ ሄ ድስትያ ቃጪደ ሃꬃን ሾክ ድጋናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ቄሳቱዋ ዛርያፐ አቱማ አሳ ግዴዳ ኦንነ ሄ አሹዋ ሞ፤ ሄ አሹ ጌሻ ኡባፐ እቱዋ ግዴዳ ሎይꬅ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ግዶ ሽን ጌሻ ሳኣን ናጋራ አቶ ጊሳናዉ አ ሱꬃ አኪደ፥ ዱንካንያ ግዶ ገልሴዳ አይ መህያ አሹዋነ ማናዉ ኮሸና፤ እ ታማን ጹገታናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘ናቁዋ ያርሹዋ ዎጋይ ሀዋ: እካ ጌሻ ኡባፐ እቱዋ ግዴዳ ጌሻ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ጹግያ ያርሾ ሺሽያ መህያ ሹክያ ሳኣን ናቁዋ ያርሹዋ መህያካ ሹክኖ፤ አ ሱꬃካ ያርሽያ ሳኣ ምየቱዋን ꬋጭኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ቃይ አ ሀንዳ ኡባ: ሄዌካ ናስያ ሀንዳ፥ ቃንꬃ አሹዋ ማዬዳ ሀንዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ላኡ ክላሆቱዋ፥ ሽንጭያ ማታን ደእያ ኡንቱንቱ ማዬዳ ሀንዳነ ትርያ ጼራ ቦላ ደእያ ሞꬍያ ክላሆቱዋና እትፐ ያርሹዋ ኦꬂደ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ታማን ጹጊደ መꬍና ጎዳዉ ያርሽያ ያርሹዋዳን፥ ሄ ሺቄዳ ሀንዳ ቄሲ ያርሽያ ሳኣ ቦላን ጹጎ፤ ሄዌ ናቁዋ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ቄስያ ዛረ ግዴዳ አቱማ አሳይ ኡባይ ሄ ያርሹዋ አሹዋ ሞ። ሄ ያርሹ ጌሻ ያርሹዋ ኡባፐ እቱዋ ግድያ ድራዉ፥ ጌሻ ሳኣን ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘ናቁዋ ያርሹ ናጋራ ያርሹዋካ ማላ፤ ኡንቱንቱ ላኡዋ ዎጋይ እቱዋ። ሄዌነ ያርሸቴዳ መህያ አሹ ናጋራ አቶ ጊሳናዉ ያርሹዋ ያርሼዳ ቄስያዉ እመቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ኦንነ ጹግያ ያርሹዋ አሆፐ ያርሽያ ቄሲ ሄ መህያ ጋልባ ባረዉ አኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ጮጭያን ኮምፐቴዳ ካꬃ ያርሹዋ ኡባይነ ኦቱዋን ዶይሰቴዳ ዎይ ባሽያን ኡከቴዳ ኡባይካ ሄ ያርሹዋ ያርሼዳ ቄስያዉ እመቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ቃይ ዛይትያን ሙናቀቴዳ ዎይ ሙናቀትቤና ካꬃ ያርሹዋ ኡባይ አሮና አቱማ ናናቶ ኡባዉ እመቴ፤ ኡንቱንቱ ሄዋ ቃራን ግሽ አክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘አሳይ እትፐተꬃ ያርሹዋ መꬍና ጎዳዉ ያርሽያ ዎደ አዉ ደእያ ዎጋይ ሀዋ: ");
INSERT INTO dwrENT_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","እ ሺሽያ እትፐተꬃ ያርሹ ጋላታ ያርሹዋ ግዶፐ፥ ሄ ያርሹዋና እትፐ ዛይትያን ሙናቄዳ፥ እርሹዋ የገናን ኡኬዳ ኡክꬃ፥ ዛይትያን ኦከቴዳ፥ እርሹ ገልቤና ሌኦ ዳቡዋነ ዛይትያን ሎይꬅ ሙናቄዳ፥ ሊቆ ꬊልያፐ ኡከቴዳ ኮምፑዋ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ሄ ጋላታዉ ሺሽያ እትፐተꬃ ያርሹዋና እትፐ እርሹዋ የጌዳ ሙናቃፐ ኡከቴዳ ኡክꬃካ እሞታ ኦꬂደ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ቃይ ሄ ኡባ ቆሞ ኡክꬃቱዋፐካ እ እቱዋ እቱዋ ደንꬂደ፥ መꬍና ጎዳዉ ያርሹዋ ኦꬂደ አሆ። ሄዌ እትፐተꬃ ያርሹዋ ሱꬃ ጫጫፌዳ ቄስያዉ እመቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ሄ መህያ አሹ ጋላታዉ ሺቅያ እትፐተꬃዉ ያርሸቴዳ ጋላስ ሜተቶ፤ ዎንታዉ አያይነ አቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘ሽን አ ያርሹ ሺቄዳዋ ጋꬅያ ዎይ ባረ ዶሱዋን ጮ እምያ ያርሹዋ ግዶፐ፥ ሄ ያርሹዋ አሹ ሄ ያርሼዳ ጋላስ ሜተቶ፤ አፐ አትያዋ ቃይ ዎንተꬃ ጋላስካ ሜተቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ሄ ያርሹዋ አሹዋፐ ፓላሂደ ሄዘንꬆ ጋላሳ ጋካናዉ ጋምእያዌ ደኦፐ፥ ሄዌ ታማን ጹገቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","እት አሳይ ሺሼዳ እትፐተꬃ ያርሹዋ አሹዋፐ ሀቃዌነ ሄዘንꬆ ጋላስ ሜተቶፐ፥ አ ያርሹ አከተና፤ እ ያርሼዳዋዳንካ ፓይደተና። ሄ ያርሹ ቱና፤ አፐ ሜዳ ኦንነ ባረ ናጋራን ኦሸቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘ቱናባ አያነ ቦቼዳ አሹ ሜተቶፖ፤ እ ታማን ጹገታናዉ ኮሼ። አሹ ጌሻ አሹዋ ግዶፐ፥ ዎጋን ጌሻ ግድያ አሳይ ኦንነ ማና ጎፐ ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ሽን እት አሳይ ቱና ግድ ኡቲደ፥ መꬍና ጎዳዉ ሺሼዳ እትፐተꬃ ያርሹዋ አሹዋፐ ምያዋ ግዶፐ፥ ሄ አሳይ ባረ አሳ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ቃይ እት አሳይ ቱናባ አያነ ቦቾፐ አሳ ቱናተꬃ ግድና ዎይ ቱና መህያ ግድና፥ ዎይ ሀራ ሸነይያ ቱናባ ቦቾፐ ስሚደ መꬍና ጎዳዉ ያርሼዳ እትፐተꬃ ያርሹዋ አሹዋፐ ሞፐ፥ ሄ ኡራይ ባረ አሳ ግዶፐ ቦሄቶ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጊደ ኦዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“እስራኤልያ አሳዉ ሀዋዳን ያጋ፤ ‘ኮሩማ ዎይ ዶርሳ ዎይ ዴሻ አሹዋን ሞꬍያ ዛዋ ሙለካ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ሀይቄዳ መህያ ዎይ ዶአይ ዎꬌዳ መህያ ሞꬍያካ ሀራባዉ ጎኤትተፐ አትና፥ አፐ አያነ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","አያዉ ጎፐ፥ መꬍና ጎዳዉ ታማን ጹግያ ያርሾ ሺሽያ መህያ ሞꬍያ ምያ ኦንነ ባረ አሳ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ህንተ ደእያ ሳኣን ሀቃን ግዶፐካ፥ ካፉዋ ሱꬃ፥ መህያ ሱꬃ ዎይ ሀራባ አያ ሱꬃነ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ሱꬃ ምያ አይ አሳይነ፥ ሄ አሳይ ባረ አሳ ግዶፐ ቦሄቶ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጊደ ኦዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“እስራኤልያ አሳዉ ሀዋዳን ያጋ፤ ‘መꬍና ጎዳዉ እትፐተꬃ ያርሹዋ ሺሽያ አይ አሳይነ ሄ እትፐተꬃ ያርሹዋፐ ሻኪደ፥ ባረ ሁጰ እሞታ ዱማዪደ መꬍና ጎዳዉ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ሄዋ እ መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋ ኦꬂደ፥ ባረ ኩሽያን አኪደ አሆ፤ ቃይ ሞꬉዋካ አንጎሱዋና አሆ፤ አንጎሱዋ ዉጻክያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳ ስንꬃን ቃꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ቄሲ ያርሽያ ሳኣ ቦላን ሞꬉዋ ጹጎ፤ ሽን አንጎሱ አሮናሳነ አ አቱማ ናናቶ እመቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ህንተ እትፐተꬃ ያርሹዋፐ ኡሸቻ ገድያ እሞታ ኦꬂደ ቄስያዉ እምተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ሄዌ ኡሸቻ ገዲ አሮና አቱማ ናናቱዋፐ እትፐተꬃ ያርሹዋ ሱꬃነ ሞꬊድያ ያርሽያዎ አ ጋክያ አ ግሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ታን እስራኤልያ አሳ እትፐተꬃ ያርሹዋፐ ቃꬄዳ አንጎሱዋነ ያርሾ ሺሼዳ ገድያ አካደ፥ ቄስያ አሮናሳነ አ አቱማ ናናቶ እማድ፤ ሄዌ ኡንቱንታ ጋክያ ኡንቱንቱ ግሹዋ ግድያ ድራዉ፥ እስራኤልያ አሳይ መꬍናዉ ሄዋ ኡንቱንቶ እሚደ ደአና’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","አሮንነ አ አቱማ ናናይ ቄስያ ግዲደ፥ መꬍና ጎዳዉ ኦꬃናዉ ሱንቴዳ ጋላስ መꬍና ጎዳዉ ሺሼዳ ታማን ጹግያ ያርሹዋፐ ሄዌ ኡንቱንቶ ግሹዋ ግዲደ እመቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","መꬍና ጎዳይ ኡንቱንቱ ቄሰተꬃዉ ኦከቴዳ ጋላስ፥ ሄዋ ኡንቱንቶ እማና ማላ፥ እስራኤልያ አሳ ኡባ አዛዜዳ፤ ስንꬃ የለታን ኡባንካ ሀዌ ዎጋ ግዲደ ኦሰቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ስም ሀዋንቱ፥ ጹግያ ያርሾ፥ ካꬃ ያርሾ፥ ናጋራ ያርሾ፥ ናቁዋ ያርሾ፥ ቄሳተꬃዉ ኦከትያ ዎደ ያርሽያ ያርሾነ እትፐተꬃ ያርሾ እመቴዳ ዎጋቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ሀ ዎጋቱ እስራኤልያ አሳይ ሲና መላ ሳኣን ባረንቱ ያርሹዋ መꬍና ጎዳዉ ያርሻና ማላ መꬍና ጎዳይ አዛዜዳ ጋላስ፥ ሲና ደርያ ቦላን መꬍና ጎዳይ ሙሳ አዛዜዳ ዎጋቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጊደ ኦዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“አሮናነ አ አቱማ ናናቱዋ ቃይ ኡንቱንቱና እትፐ፥ ቄሳተꬃ ማዩዋ፥ ኦክያ ዛይትያ፥ ናጋራ ያርሾ ሹክያ ኮሩማ፥ ላኡ ዶርሳ ኦርገቱዋነ፥ እርሹዋ የገናን ኡኬዳ ኡክꬃ ዎꬄዳ ማሶፍያ አካደ ያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ቃይ እስራኤልያ አሳ ኡባካ ጼሳደ፥ ዱንካንያ ካረ ሺሻ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ሙሴ መꬍና ጎዳይ አዛዜዳዋዳን ኦꬄዳ፤ አሳይካ ኡባይ ዱንካንያ ካረን ሺቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ሙሴ አሳዉ፥ “ኦꬃና ማላ መꬍና ጎዳይ አዛዜዳዌ ሀዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ሙሴ አሮናነ አ አቱማ ናናቱዋ አሂደ፥ ሃꬃን ሜጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","አሮና ቃምሽያ ማይዜዳ፤ ዳንጩዋካ ዳንጭሴዳ። ቃይ አዱሳ ቃምሽያ ማይዚደ፥ አ ቦላን ኤፉድያ ማይዜዳ። ኤፉድያ ሂላቲደ ዳዴዳ ሳቂያን አሮናና ጋꬂደ ቃቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ቃይ ትራን ዎꬅያዋ አሮና ቦላን አꬂደ፥ አ ግዶን ኡሪምያነ ቱሚምያ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ቃይካ አሮና ሁጲያን ሻሽያ ኤንጩርሳ ዎꬄዳ። መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ሄ ኤንጩርሳ ቦላን ስንꬃ ባጋና ዎርቃ ማዳልያ፥ ዎርቃፐ መꬌዳ ካላቻ ምስልያ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ያቶዋፐ ጉይያን ሙሴ ኦክያ ዛይትያ አኪደ፥ ዱንካንያነ ዱንካንያ ግዶን ደእያ ሚሻ ኡባ ኦኬዳ፤ ኡንቱንታ ጌሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ቃይ ሄ ዛይትያፐ አኪደ፥ ያርሽያ ሳኣ ቦላ ላፑ ገደ ጫጫፌዳ፤ ያርሽያ ሳኣ፥ አ ሚሻቱዋ፥ ሜቻ ከርያነ አ ዎꬅያዋ፥ ጌሻናዉ ሄ ዛይትያን ኦኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ቃይ ሄ ኦክያ ዛይትያፐ አማራ አሮና ሁጲያን ትጊደ፥ አ ጌሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ሙሴ አሮና አቱማ ናናቱዋ ስንꬃዉ አꬂደ፥ ቃምሽያ ማይዜዳ፤ ዳንጩዋን ዳንጭሴዳ። ኡንቱንቱ ሻሽያ ኤንጩርሳ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ሄዋፐ ጉይያን፥ ናጋራ ያርሾ ኮሩማ ሙሴ አꬄዳ፤ አሮንነ አ አቱማ ናናይ ሄ ኮሩማ ሁጲያን ባረንቱ ኩሽያ ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ሙሴ ሄ ኮሩማ ሹኬዳ፤ አ ሱꬃፐ ባረ ብራꬍያን አኪደ፥ ያርሽያ ሳኣ ካጨቱዋ ኦኪደ፥ ያርሽያ ሳኣ ጌሼዳ፤ ቃይ ያርሽያ ሳኣ ናጋራ አቶ ጊሳናዉ አቴዳ ሱꬃ አፐ ጋርሳና ጉሲደ፥ ጾሳዉ ጌሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ቃንꬃ አሹዋ ካሜዳ ሀንዳ ኡባ፥ ትርያ ጼራ ቦላ ደእያ ሞꬍያ፥ ላኡ ክላሆቱዋነ ኡንቱንታ ካሜዳ ሀንዳ አኪደ፥ ሙሴ ያርሽያ ሳኣ ቦላን ዎꬂደ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ሽን መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ጋልባ፥ ኮሩማፐ አቴዳዋነ ቶጭያ ዱንካኔዳ ሳኣፐ ጋጻ ከሲደ፥ ታማን ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ያት ስሚደ ሙሴ ጹግያ ያርሾ ሀንያ ዶርሳ ኦርግያ አሄዳ፤ አሮንነ አ አቱማ ናናይ ሄ ዶርሳ ኦርግያ ሁጲያን ባረንቱ ኩሽያ ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ሙሴ ሄ ዶርሳ ኦርግያ ሹኬዳ፤ አ ሱꬃ ያርሽያ ሳኣ ምይያ ኡባን ጉሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ቃይ ዶርሳ ኦርግያ አሹዋካ አ ቆሙዋን ቆሙዋን ቃንጼዳ፤ ቃንጸꬃ፥ ሁጲያነ ሞꬍያ ያርሽያ ሳኣ ቦላ ዎꬂደ ሙሴ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ቃንꬃ አሹዋነ ገደቱዋ ሃꬃን ሜጮዋፐ ጉይያን፥ ዶርሳ ኡባና መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ያርሽያ ሳኣ ቦላን ዎꬂደ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ሄዋፐ ጉይያን፥ ቄሰተꬃዉ ኦከትያ ዎደ ሺሽያ ላኤንꬆ ዶርሳ ሙሴ አሄዳ፤ አሮንነ አ አቱማ ናናይ ሄ ዶርሳ ሁጲያን ባረንቱ ኩሽያ ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ሙሴ ሄ ዶርሳ ሹኬዳ፤ አ ሱꬃፐ አኪደ፥ አሮናዉ ኡሸቻ ሀይꬃ ጼራ፥ ኡሸቻ ኩሽያ ዎጋ ብራꬍያነ፥ ኡሸቻ ገድያ ዎጋ ብራꬍያ ኦኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ቃይ ሙሴ አሮና አቱማ ናናቱዋካ ስንꬃዉ አሂደ፥ ሄ ሱꬃፐ አኪደ፥ ኡንቱንቱ ኡሸቻ ሀይꬃ ጼራ፥ ኡንቱንቱ ኡሸቻ ኩሽያ ዎጋ ብራꬍያነ ኡንቱንቱ ኡሸቻ ገድያ ዎጋ ብራꬍያ ኦኬዳ። ሄዋፐ ጉይያን፥ ሙሴ አቴዳ ሱꬃ ያርሽያ ሳኣ ምይያ ኡባን ጉሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ያቲደ ሞꬉዋ፥ ናስያ፥ ቃንꬃ አሹዋ ማዬዳ ሞꬍያ፥ ትርያ ጼራ ቦላ ደእያ ሞꬍያ፥ ላኡ ክላሆቱዋነ ኡንቱንታ ማዬዳ ሀንዳነ ኡሸቻ ገድያ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ቃይ እርሹዋ የገናን ኡኬዳ ኡክꬃ ዎꬅያ መꬍና ጎዳ ስንꬃን ደእያ ማሶፍያፐ እት ኮምፑዋ፥ ዛይትያና ኡኬዳ እት ኡክꬃነ እት ሌኦ ኡክꬃ አኪደ፥ ሀዋንታ ሞꬍያ ቦላንነ ኡሸቻ ገድያ ቦላን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","እ ሀ ቁማ ኡባ አሮና ኩሽያንነ አ አቱማ ናናቱዋ ኩሽያን ዎꬄዳ፤ ኡንቱንቱ መꬍና ጎዳ ስንꬃን ቃꬅያ ያርሹዋ ኦꬂደ ቃꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ሄዋፐ ጉይያን፥ ሙሴ ሄ ቁማ ኡንቱንቱ ኩሽያፐ አክ፥ ጹግያ ያርሹዋና ጋꬂደ፥ ቄሰተꬃዉ ኦከትያ ዎደ መꬍና ጎዳዉ ታማን ጹጊደ ሺሽያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋዳን፥ ያርሽያ ሳኣ ቦላን ዎꬂደ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ቃይ ሙሴ አንጎሱዋ አኪደ፥ ቃꬅያ ያርሹዋ ኦꬂደ መꬍና ጎዳ ስንꬃን ቃꬄዳ፤ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ቄሳተꬃዉ ኦከትያ ዎደ ያርሽያ ዶርሳ ኦርግያ አሹዋፐ ሄዌ ሙሳ ጋክያ አ ግሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ሙሴ ኦክያ ዛይትያፐነ ያርሽያ ሳኣ ቦላን ደእያ ሱꬃፐ አኪደ፥ አሮና ቦላነ አ ማዩዋ ቦላ፥ ቃይ አ አቱማ ናናቱዋ ቦላነ፥ ኡንቱንቱ ማዩዋ ቦላካ ጫጫፌዳ፤ ያቲደ አሮናነ አ ማዩዋ ቃይ አ ናናቱዋነ አ ናናቱዋ ማዩዋካ ጌሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ሙሴ አሮናነ አ አቱማ ናናቱዋ ሀዋዳን ያጌዳ፤ “አሹዋ ጋከትያ ዱንካንያ ካረን ዶይስተ፤ ‘አሮንነ አ ናናይ ሄዋ ሚኖ’ ያጋደ ታን አዛዜዳዋዳን፥ ቄሳተꬃዉ ኦከትያ ዎደ ሺሽያ ያርሹዋ ዎꬅያ ማሶፍያ ግዶን ደእያ ያርሹዋ ኡክꬃና ሄዋን ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ሄ አሹዋፐነ ኡክꬃፐ ፓላሄዳዌ ደኦፐ ታማን ጹግተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ቄሳተꬃዉ ኦክያ ዎጋይ ላፑን ጋላሳ አክያ ድራዉ፥ ሄ ህንተ ቄሳተꬃዉ ኦከትያ ላፑን ጋላሳይ ዉራናዉ፥ ዱንካንያ ፐንገፐ ካረ ከሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ሀ ሀች ኦሰቴዳዌ መꬍና ጎዳይ አዛዝና፥ ህንተ ናጋራ አቶ ጊሳናዉ ኦሰቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ዱንካንያ ፐንግያን ላፑን ጋላሳ ኩመንꬃ ጋላስነ ቃማነ ታክተ፤ መꬍና ጎዳ ዎጋካ ናግተ፤ እጾፐ ህንተ ሀይቃና። ታና መꬍና ጎዳይ አዛዜዳዌ ሀዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","አሮንነ አ ናናይ መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳዋ ኡባ ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ሆስፑንꬃ ጋላሳን ሙሴ አሮናነ አ ናናቱዋ፥ ቃይ እስራኤልያ ጭማቱዋካ ጼሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","አሮና ሀዋዳን ያጌዳ፤ “ናጋራ ያርሾ እት ኮሩማ፥ ቃይ ጹግያ ያርሾ እት ዶርሳ ኦርግያ መꬍና ጎዳ ስንꬃ ሺሻ። መሄቱ ላኡካ ትላ ቦላና ደእያዋንታ ግድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ቃይ እስራኤልያ አሳ ሀዋዳን ያጋ፤ ‘መꬍና ጎዳይ ህንተንቶ ቆንጭያ ድራዉ፥ መꬍና ጎዳ ስንꬃን ያርሻናዉ፥ ናጋራ ያርሾ እት ዴሻ ኦርግያ፥ ጹግያ ያርሾ ትላ ቦላና ደእያ እት ላይꬃ ማራነ እት ላይꬃ ዶርሳ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","እትፐተꬃ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ ዛይትያን ሙናቀቴዳ ካꬃ ያርሹዋ አህተ ያጋ’ ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ኡንቱንቱ ሙሴ አዛዜዳዋ ኡባ ጾሳ ዱንካንያ ስንꬃ አሄድኖ፤ ያቲደ ማባራ ኡባይ ሺቂደ፥ መꬍና ጎዳ ስንꬃን ኤቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ሙሴ ኡንቱንታ፥ “መꬍና ጎዳ ቦንቹ ህንተንቶ ቆንጫና ማላ፥ ህንተ ኦꬃናዳን መꬍና ጎዳይ ህንተና አዛዜዳዌ ሀዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ቃይ ሙሴ አሮናዉ ሀዋዳን ያጌዳ፤ “ያርሽያ ሳኮ ሃ ሺቃ፤ ነ ናጋራ ያርሹዋነ ነ ጹግያ ያርሹዋ ያርሻ፤ ያታደ ነ ሁጰ ናጋራነ ነ አሳ ናጋራካ አቶ ጊሳ። ቃይ መꬍና ጎዳይ አዛዜዳዋዳን፥ አሳይ ሺሽያ ያርሹዋ ያርሻደ፥ ኡንቱንቱ ናጋራካ አቶ ጊሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","አሮን ያርሽያ ሳኮ ዪደ፥ ባረ ሁጰ ናጋራዉ ያርሹዋ ኦꬅ ሺሼዳ ኮሩማ ሹኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","አሮና አቱማ ናናይ ሱꬃፐ አኪደ አዉ አሄድኖ፤ እ ባረ ኩሽያ ብራꬍያ ሄ ሱꬃን የድ ከሲደ፥ ያርሽያ ሳኣ ካጨቱዋ ቦቼዳ፤ አቴዳ ሱꬃካ ያርሽያ ሳኣፐ ጋርሳ ባጋና ጉሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ቃይ ሄ ናጋራ ያርሹዋ አሹዋፐ ሞꬉዋ፥ ክላሆቱዋነ ትርያ ጼራ ቦላ ደእያ ሞꬍያ ያርሽያ ሳኣ ቦላን ዎꬂደ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ሽን አቴዳ አሹዋነ ጋልባ ዱንካኔዳ ሳኣፐ ካረ ከሲደ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ሄዋፐ ጉይያን፥ አሮን ጹግያ ያርሹዋ ሹኬዳ፤ አ ናናይ ሱꬃ አኪደ አዉ አሄድኖ፤ እ ያርሽያ ሳኣ ምይያ ኡባን ጉሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ቃይ ኡንቱንቱ ጹግያ ያርሹዋ ቆሙዋን ቆሙዋን ከሲደ፥ ሁጲያናካ አዉ አሄድኖ፤ እ ያርሽያ ሳኣ ቦላን ዎꬂደ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ቃንꬃ አሹዋነ ገደቱዋካ ሃꬃን ሜጪደ፥ ያርሽያ ሳኣ ቦላን ደእያ ጹግያ ያርሹዋ ቦላን ዎꬂደ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ሄዋፐ ጉይያን፥ አሮን አሳ ያርሹዋ ሺሼዳ፤ እ አሳ ናጋራ ያርሾ ግድያ ዴሻ ኦርግያ አኪደ ሹኬዳ፤ ካሰ ባረዋዳንካ ኡንቱንቱ ናጋራዉ ያርሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ቃይ እ ጹግያ ያርሹዋ መህያ አሂደ፥ ዎጋይ አዛዝያዋዳን ኦꬂደ ያርሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ካꬃ ያርሹዋካ ሺሼዳ፤ አፐ እት ኮጵያ ግድያዋ አኪደ፥ ዎንታ ዎንታ ጹግያ ያርሹዋፐ ሀራ አ ቦላን ዎꬂደ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","አሮን ቃይካ አሳ እትፐተꬃ ያርሾ ኮሩማነ ዶርሳ ኦርግያ ሹኬዳ፤ አ አቱማ ናናይ ሱꬃ አዉ አሄድኖ፤ እ ሄ ሱꬃ አኪደ፥ ያርሽያ ሳኣ ምይያ ኡባ ጉሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ቃይ ኮሩማነ ዶርሳ ኦርግያ አሹዋፐ ሞꬉዋ፥ ናስያ፥ ቃንꬃ አሹዋ ማዬዳ ሀንዳ፥ ክላሆቱዋነ ትርያ ጼራ ቦላ ደእያ ሞꬍያ አሮና ናናይ አዉ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ኡንቱንቱ ሄ ሀንዳ አንጎሱዋ ቦላ ዎꬅና፥ አሮን ያርሽያ ሳኣ ቦላን ሄዋ ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ሽን ሙሴ አዛዜዳዋዳን፥ አሮን አንጎሶቱዋነ ኡሸቻ ገድያ ቃꬅያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳ ስንꬃን ቃꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ሄዋፐ ጉይያን፥ አሮን ባረ ኩሽያ አሳኮ ዛር ደንꬂደ ኡንቱንታ አንጄዳ። እ ናጋራ ያርሹዋ፥ ጹግያ ያርሹዋነ እትፐተꬃ ያርሹዋ ያርሾዋፐ ጉይያን፥ ያርሽያ ሳኣፐ ዱገ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ሙሴነ አሮን መꬍና ጎዳ ዱንካንያ ግዶ ገሌድኖ፤ ኡንቱንቱ ሄዋፐ ከሴዳ ዎደ፥ አሳ አንጄድኖ። ያትና መꬍና ጎዳ ቦንቹ አሳ ኡባዉ ቤቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","መꬍና ጎዳ ስንꬃፐ ታማይ ዎꬊደ፥ ያርሽያ ሳኣ ቦላን ደእያ ጹግያ ያርሹዋነ ሞꬍያ ሜዳ። አሳይ ኡባይ ሄዋ በኤዳ ዎደ እልሌዳ፤ ቃይ ኡንቱንቱ ባረንቱ ሶምኡዋን ሳኣ ቦቺደ ጉፋኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","አሮና አቱማ ናናይ፥ ናዳብነ አብሁ፥ ባረንቱ እጻና ጩውስያ ሚሻ አኪደ፥ አ ቦላን ታማ ዎꬄድኖ፤ ታማ ቦላ ቃይ እጻና ቆሌድኖ፤ ያቲደ፥ መꬍና ጎዳይ ኡንቱንታ አዛዝቤና፥ ሀራ ታማ መꬍና ጎዳ ስንꬃን ሺሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ሄዋ ጋሱዋን መꬍና ጎዳ ስንꬃፐ ታማይ ዪደ፥ ኡንቱንታ ሜዳ፤ ኡንቱንቱካ መꬍና ጎዳ ስንꬃን ሀይቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ሄዋፐ ጉይያን፥ ሙሴ አሮና፥ “መꬍና ጎዳይ፥ “ ‘ታን ታ ማታ ሺቅያዋንታ ታ ጌሻተꬃ በሳና። ቃይ አሳ ኡባ ስንꬃን ታን ቦንቼታና’ ” ጊደ ሃሳዬዳዌ በአ ሀዋ ያጌዳ። አሮን ጮኡ ጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ሙሴ አሮና አዉዋ እሻ ኡዝኤላ አቱማ ናናቱዋ፥ ምሻኤላነ ኤልጻፋና ጼጊደ፥ “ሃ ዪተ፤ ህንተ አዉዋ እሻ ናናቱዋ አሃ ጾሳ ዱንካንያ ስንꬃፐ ደንꬂደ፥ ዱንካኔዳ ሳኣፐ ጋጻ ከስተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ሄዋ ድራዉ ኡንቱንቱ ዪደ፥ ሙሴ አዛዜዳዋዳን፥ ባረንቱ ቄሰተꬃ ማዩዋና ኡንቱንቱ አሃ ቶኪደ፥ ዱንካኔዳ ሳኣፐ ጋጻ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ሄዋፐ ጉይያን፥ ሙሴ አሮናነ አ አቱማ ናናቱዋ፥ ኤልኣዛራነ እታማራ ሀዋዳን ያጌዳ፤ “ህንተ ሀይቀና ማላነ፥ መꬍና ጎዳይ ማባራ ኡባ ቦላን ሀንቀተና ማላ፥ ህንተ ሁጲያ ሜድሶፕተ፤ ህንተ ማዩዋካ ፔꬎፕተ። ሽን ህንተ እሻቱ፥ እስራኤልያ አሳቱ፥ መꬍና ጎዳይ ባረ ኤꬄዳ ታማን ጹጌዳዋንቶ ዬካና ጎፐ ኡንቱንቱ ዬክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ቃይካ ህንተ ዱንካንያ ፐንግያፐ ካረ ከሶፐ ህንተ ሀይቃና፤ አያዉ ጎፐ ጾሳይ ኦክያ ዛይቲ ህንተ ቦላን ደኤ” ያጌዳ። ኡንቱንቱካ ሙሴ ጌዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","መꬍና ጎዳይ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ህንተ ሀይቀና ማላ፥ ዱንካንያ ግዶ ገልያ ዎደ፥ ኔንካ ነ ናናይካ ዎይንያ ኤሳ ዎይ ሀራ ማꬆይያ ኡሻ ኡሾፕተ፤ ሄዌ ስንꬃፐ ያና የለታዉካ መꬍናዉ ህገ ግዲደ ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ህንተ ጌሻነ ጌሻ ግደናባ ቃይ ቱናነ ቱና ግደናባ ሻኪደ ኤርተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","መꬍና ጎዳይ ሙሴ ባጋና ኦዴዳ ዎጋ ኡባካ እስራኤልያ አሳ ታማርስተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ሙሴ አሮናነ አቴዳ አ አቱማ ናናቱዋ ኤልኣዛራነ እታማራ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋፐ አቴዳ ካꬃ ያርሹዋ አኪደ፤ እርሹዋ የገናን ኡክተ፤ ያቲደ እ ሎይꬅ ጌሻ ግድያ ድራዉ፥ ያርሽያ ሳኣ ማታን አ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋፐ ሄዌ ኔናነ ነ አቱማ ናናቱዋ ጋክያ ህንተ ግሹዋ ግድያ ድራዉ፥ ሄዋ ህንተ ጌሻ ሳኣን ሚተ፤ አያዉ ጎፐ፥ ጾሳይ ታና ሄዋዳን ኦꬃና ማላ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ሽን ቃꬄዳ አንጎሱዋነ ሺቄዳ ገድያ ኔን፥ ነ አቱማ ናናይነ ነ ማጫ ናናይ ዎጋዳን ጌሻ ሳኣን ሚተ። አያዉ ጎፐ፥ ሄዌ እስራኤልያ አሳይ ሺሽያ እትፐተꬃ ያርሹዋፐ ኔናነ ነ አቱማ ናናቱዋ ጋክያ ህንተ ግሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","መꬍና ጎዳዉ ያርሼዳ ገድያነ ቃꬄዳ አንጎሱዋ አሳይ ታማን ጹግያ ሞꬍያና እትፐ ጋꬂደ፥ መꬍና ጎዳ ስንꬃን ቃꬅያ ያርሹዋዳን ቃꬃናዉ አሀና። መꬍና ጎዳይ አዛዜዳዋዳን፥ ሄዌ ነዉነ ኔናና ደእያ ነ አቱማ ናናቶ መꬍናዉ ህንተና ጋክያ ህንተ ግሹዋ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ሙሴ ናጋራ ያርሹዋ ዴሻይ ዋኔደንቶነ ኤራናዉ ኮዪደ ኦቼዳ፤ እ ጹገት ድጌዳዋ ኤሬዳ ዎደ፥ አቴዳ አሮና አቱማ ናናቱዋ፥ ኤልኣዛራነ እታማራ ሀንቀቴዳ፤ ኡንቱንቱ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ናጋራ ያርሹ ሎይꬅ ጌሻ ግዴዳዋንቱ ግዱዋፐ እቱዋ ግዴዳ ጌሻ፤ ቃይ ሄዌካ አሳ ናጋራ መꬍና ጎዳ ስንꬃን አቶ ጊሳና ማላ ህንተንቶ እመቴዳ፤ ያትና ህንተ አ ሎይꬅ ጌሻ ሳኣን አያዉ ምበይክቴ? ");
INSERT INTO dwrENT_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ሄ መህያ ሱꬃይ መꬍና ጎዳ ዱንካንያ ግዶ ገልቤናዋ ግዶደ፥ ታን ህንተና አዛዜዳዋዳን፥ ህንተ አ ሄ ጌሻ ሳኣን ማናዉ በሴ፤ ሽን አጌድታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","አሮን ሙሳ፥ “በአ፤ አሳቱ ሀች ባረንቱ ናጋራ ያርሹዋነ ጹግያ ያርሹዋ መꬍና ጎዳ ስንꬃ አሄድኖ፤ ግዶፐነ ቃይ ሀዋ ማላባይ ታ ቦላ ጋኬዳ። ያትና ዎን ታን ናጋራ ያርሹዋ ሀች ሜዳዋ ግድንቶነ፥ መꬍና ጎዳይ ናሸታናዋ ሽን አቴዴሻ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ሙሴ ሄዋ ስሴዳ ዎደ፥ ሄ ዛሩ አ አሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“እስራኤልያ አሳዉ ሀዋዳን ያጊደ ኦድተ፤ ‘ቢታ ቦላን ደእያ መህያ ኡባፐ ህንተ ማና መሄቱነ ዶአቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ጹጉንꬃይ ዉር ጳልቀቴዳዋንታነ ዋሞትያ መሄቱዋ ኡባ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ሽን ዋሞ ጻላላ ዋሞትያዋንታ ዎይ ቃይ ጹጉንꬃ ጻላላይ ጳልቀቴዳዋንታ ሞፕተ። ጋሉ ዋሞቴ ሽን ጹጉንꬃይ ጳልቀትቤና ድራዉ እ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ጉፓሊ ዋሞቴ ሽን ጹጉንꬃይ ጳልቀትቤና ድራዉ እ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ሀርባይን ዋሞቴ ሽን ሞፕተ፤ አያዉ ጎፐ፥ እ ዋሞትያዋ ግዶፐነ፥ አዉ ጹጉንꬃይ ጳልቀꬃ ግደና ድራዉ፥ እ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ጉዱንꬃካ ሞፕተ፤ አያዉ ጎፐ፥ አዉ ጹጉንꬃይ ጳልቀꬃ ግዶፐነ፥ ዋሞተና ድራዉ፥ እ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ህንተ ሀዋንቱ አሹዋ ሞፕተ፤ ኡንቱንቱ ባኩታካ ቦቾፕተ፤ ኡንቱንቱ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘ሃꬃ ግዶን ደእያ መታቱዋ ኡባፐ ህንተ ማናዋንቱ ሀዋንታ። አባ ግዶን ግድና ዎይ ቃይ ጎግያ ሃꬃ ግዶን ግድና ደእያ ኡባፐ ሞልያ ማላ ቀፊነ ፖቁ ደእያ ኡባ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ሽን አባ ግዶን ዎይ ሻፋን ሻምእሻምእያ መታቱዋፐነ ሸምፑ ደእያ፥ ቃጽያ መታቱዋፐ ሞልያ ማላ ቀፊነ ፖቁ ባይና ኡባይ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ሀዋንቱ ህንተንቶ ቱና፤ ኡንቱንቱ አሹዋ ሞፕተ፤ ኡንቱንቱ ባኩታካ ቦቾፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ቀፊነ ፖቁ ባይና ሃꬃ ግዶን ደእያ መታቱ ኡባይ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘ካፎቱዋፐ ቱና ግድያ ድራዉ ህንተ ሜናዋንቱ ሀዋንታ: አርጋንꬃ፥ ባዙዋ አንኩዋ፥ ካረꬃ አንኩዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ጽንግልያ፥ ቆል ዛርያ ኡባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ቁሩዋ ዛርያ ኡባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ሶጎንያ፥ ሀዛዝያ፥ ሃꬃ ካፉዋ፥ ጋጭያ ዛርያ ኡባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ቄር ጉቱዋ፥ ብዩዋ፥ ዎጋ ጉቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ሃꬃ ኩቱዋ፥ ሞልያ ካፉዋ፥ ባኩታ ምያ አንኩዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ሽማላነ ሳቢሳ ግያ ሃꬃ ካፎቱዋ ዛርያ ኡባ፥ ጅንጅላትያነ ሻልያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘ቀፍያና ደእያ ኦይዱ ገድያን ሀመትያ ቄር መታቱ ኡባይ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ግዶፐነ፥ ቀፊ ደእያ ኦይዱ ገድያን ሀመትያዋንቱፐ ኡንቱንቱ ገድያፐ ቦላና ጉፓናዉ ማድያ ገዲ ደእያዋንታ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ሄዋንቱካ፥ ቦልያ ዛርያ ኡባ፥ ኡኩቦ ዛርያ ኡባነ ቡምቡረꬃ ዛርያ ኡባ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ሽን ሀራ ቀፍያና ደእያ ኦይዱ ገዲ ደእያ መታቱ ኡባይ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘ሀዋንቱ ህንተና ቱንሳና፤ ኡንቱንቱ ባኩታ ቦችያ ኡባይ ኦማርስ ጋካናዉ ቱና ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ሀዋንቱ ባኩታ ደንꬅያ ኦንነ ባረ ማዩዋ ሜጮ፤ ሽን ግዶፐነ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ጹጉንꬃይ ደኢደ ጳልቀꬃ ግደናዋንታ ዎይ ቃይ፥ ዋሞተናዋንቱ ኡባይ ህንተንቶ ቱና፤ ኡንቱንቱ አሃ ቦችያ ኦንካ ቃይ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ኦይዱ ገደቱዋን ሀመትያ መህያ ኡባፐ አዳነቱዋ ግንድያ ማላ ግንድያን ሀመትያዋንቱ ህንተንቶ ቱና፤ ቃይ ኡንቱንቱ ባኩታ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ሄዋንቱ ባኩታ ደንꬅያ ኦንነ ባረ ማዩዋ ሜጮ፤ ሽን ግዶፐነ ኦማርስ ጋካናዉ እ ቱና። ኡንቱንቱካ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘ሳኣና ሀመትያዋንቱፐ ሀዋንቱ ህንተንቶ ቱና: ኦጩ፥ ኤጨሪ፥ ዱማ ዱማ ቆሞ ዛሪ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ጌግ፥ ሀይላሹ፥ ኮርቺ፥ ዋካላይነ ሻቃንቻይ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ሳኣና ሀመትያ ኡባቱዋፐ ህንተንቶ ቱና ግድያዋንቱ ሄዋንታ፤ ኡንቱንቱፐ ሀዬዳዋ ቦችያ ኡባይ ኦማርስ ጋካናዉ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ኡንቱንቱፐ ሀይቄዳዌ አያ ቦላ ኩንዶፐካ ሄ ኡንቱንቱ አ ቦላ ኩንዴዳ ሚሻይ ቱና፤ ምꬃ ሚሻ ዎይ ማዩዋ ዎይ ጋልባ ዎይ ኬሻቱዋ ግድናካ፥ ጎኤትያ ሚሻ ኡባ ሃꬃ ግዶን ዎꬅተ፤ ሄዌ ኦማርስ ጋካናዉ ቱና፤ ሄዋፐ ጉይያን፥ ጌሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ሀ ሳኣና ሀመትያዋንቱፐ እቱዋ ባኩታይ አይ ኡርቃ ሚሻ ግዶን ኩንዶፐካ፥ አ ግዶን ደእያባይ ኡባይ ቱና፤ ሄ ሚሻ መንꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ሄ ሚሻ ግዶን ደእያ ሃꬃፐ ሜተትያ አይ ቁማ ቦላ ጾኮፐካ፥ ሄ ቁማይ ቱና፤ ቃይ ኡሽያባ አያነ ግዶ፥ ሄ ሚሻ ግዶን ደኦፐ፥ እካ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ሀዋንቱ አሃይ አ ቦላ ኩንድያባይ አያ ግዶፐካ ቱና። ጮጭያ ዎይ ካꬅያ ኡርቃ ሚሻ ግዶፐካ መንꬅተ፤ ኡንቱንቱ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ሀዋንቱ ባኩታይ ቦችያባይ ኡባይ ቱና ግዶፐነ፥ ፑልቱነ ሃꬃ ኦላይ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ኡንቱንቱ ባኩታፐ እቱ ዘራናዉ ዎꬄዳ ዘረꬃ ካꬃ ቦላ ኩንዶፐ፥ ሄዌ ቱነና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ሽን ሄ ዘረꬃ ቦላ ሃꬃይ ጉክ ስምና፥ ኡንቱንቱ ባኩታፐ እቱነ አ ቦላ ኩንዶፐ፥ ሄ ዘረꬃይ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘ቃይ ህንተ ምያ መሄቱዋፐ እቱ ሀይቂና፥ አ ባኩታ ቦችያ ኦንነ ኦማርስ ጋካናዉ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ኦንነ ሄ መህያ ባኩታፐ ሞፐ፥ ባረ ማዩዋ ሜጮ፤ ኦማርስ ጋካናዉ እ ቱና፤ ቃይ ኦንነ አ ባኩታ ቶኪደ ደንꬆፐ፥ ባረ ማዩዋ ሜጮ፤ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘ሳኣና ጎሸትያ መታ ኡባይ ህንተንቶ ቱና፤ አ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ኡሉዋን ጎሸትያዋ ግድና፥ ዎይ ኦይዱ ገድያን ሀመትያዋ ግድና፥ ዎይ ቃይ ዳሮ ገዲ ደእያዋ ግድናካ፥ ሳኣና ጎሸትያ መታ ኡባይ ቱና ግድያ ድራዉ አ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ሳኣና ጎሸትያ መታቱዋ ኡባን ሚደ ህንተ ሁጲያዉ ቱኖፕተ፤ ቃይ ኡንቱንቱን ህንተ አሳተꬃ ቱንሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ። ታን ጌሻ ግድያ ድራዉ፥ ህንተካ ህንተና ዱማዪደ፥ ጌሻ ግድተ። ሳኣና ጎሸትያዋንቱን ህንተ አሳተꬃ ቱንሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","አያዉ ጎፐ፥ ታን ህንተ ጾሳ ግዳናዉ፥ ህንተና ግብጼ ጋድያፐ ከሴዳ መꬍና ጎዳ። ሄዋ ድራዉ፥ ታን ጌሻ ግድያ ድራዉ፥ ህንተካ ጌሻ ግድተ ያግተ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘መሄቱዋ፥ ካፎቱዋ፥ ሃꬃ ግዶን ፓጻ ቃጽያ መታቱዋ ኡባቱነ ሳኣና ሀመትያ መታቱዋ ኡባቱዋ ዎጋይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ሄዌነ ህንተ ቱናነ ጌሻ፥ ቃይ ሸምፑ ደእያ መታቱዋፐ ምያዋንታነ ሜናዋንታ ሻኪደ ኤራናሳ።’ ” ");
INSERT INTO dwrENT_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘እት ማጫዉና ሻሃራደ አቱማ ናኣ የሎፐ፥ ባረ ፒላይ ዬዳ ዎደ እዛ ቱና ግድያዋዳንካ፥ ሄዋዳን እዛ ላፑን ጋላሳይ ጋካናዉ ቱና ግዳናኑ። ");
INSERT INTO dwrENT_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ሆስፑንꬃ ጋላስ ናአይ ቃጻረታናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ሄዋፐ ጉይያን፥ ማጫዉና ባረ ፒላ ሱꬃይ ጽአና ጋካናዉ፥ ሀታማነ ሄዙ ጋላሳ ጋምኡ፤ ቃይ ባረ ጌይያ ጋላሳቱ ዉራና ጋካናዉ፥ ጌሻባ አያነ ቦቹፑ፤ ጾሳ ጌሻ ሳኣካ ገሉፑ። ");
INSERT INTO dwrENT_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“ ‘ሽን እት ማጫዉና ማጫ ናቶ የሎፐ፥ ባረ ፒላይ ዬዳ ዎደ እዛ ቱና ግድያዋዳንካ፥ ሀዋዳን ላኡ ሳምንታ ጋካናዉ፥ እዛ ቱና ግዳና፤ ሄዋፐ ጉይያን፥ ባረ ፒላ ሱꬃይ ጽአና ጋካናዉ ኡሱፑን ታማነ ኡሱፑን ጋላሳ ጋምኡ። ");
INSERT INTO dwrENT_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘ማጫዉና አቱማ ናኣ ግድና ማጫ ናኣ ግድና የላደ፥ ባረ ጌይያ ዎድያ ዉርሶዋፐ ጉይያን፥ ጹግያ ያርሾ እት ላይꬃ ዶርሳነ ናጋራ ያርሾ ቃይ እት ሀራጵያ ማራ ዎይ እት ማራ ዶጎሙዋ ጾሳ ዱንካንያ ፐንግያን ደእያ ቄስያኮ አሁ። ");
INSERT INTO dwrENT_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ቄሲ ሄዋ መꬍና ጎዳ ስንꬃን ያርሺደ፥ እዝ ናጋራ አቶ ጊሴ፤ ያቶፐ እዛ ባረ የሉዋ ሱꬃ ጎገꬃፐ ጌያዉ። አቱማ ናኣ ዎይ ማጫ ናኣ የልያ ማጫዉን ዎጋይ ሄዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“ ‘ሽን እት ላይꬃ ዶርሳ ኦርግያ አሀናዉ እዝዉ ሻሉ ግዳና ꬋዮፐ፥ ላኡ ማራ ዶጎማቱዋ ዎይ ላኡ ማራ ሀራጳቱዋ አሁ፤ ኡንቱንቱፐ እቱ ጹግያ ያርሹዋሳ፤ እቱ ቃይ ናጋራ ያርሹዋሳ፤ ያቶፐ ቄሲ ሄዋንታ ያርሺደ፥ እዝ ናጋራ አቶ ጊሴ፤ እዛካ ጌሻ ግዳዉ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“አይ አሳ ቦላነ ጋፉ ቤቶፐ፥ ዎይ ꬉሳ ማዱꬃይ ዎይ እላሁ ከሶፐነ ቃይ ሄዌካ አ ጋልባን ዎልቃማ ጋልባ ሀርግያዉ ላመቶፐ፥ ሄ ብታንያ ቄስያ አሮናኮ ዎይ ቄስያ ግድያ አ አቱማ ናናቱዋፐ እቱዋኮ አህኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ቄሲ አ ጋልባ ቦላን ደእያ ማዱꬃ በኦ። ሄ ማዱጼዳ ሳኣን ደእያ እስኪ ቦጾፐነ፥ ማዱꬃይካ ኦላቶፐ፥ ሄዌ ዎልቃማ ጋልባ ሀርገ። ቄሲ ሄዋ በኢደ፥ ሄ ብታኒ ቱና ግድያዋ ኤርሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ሽን አ ጋልባ ቦላን ደእያ ሻቱ ቦጽንቶካ፥ ጋልባፐ ሉኪደ ኦላትቤናዋ ግዶፐነ ሄ ማዱꬃ ቦላን ደእያ እስኪ ቦጽቤናዋ ግዶፐ፥ ቄሲ ሄ ብታንያ ዱማ ክፍልያን ላፑን ጋላሳ ጎርዲደ ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ላፑንꬃ ጋላሳን ቄሲ አ ዛረꬂደካ በኦ፤ እ በእያ ዎደ ማዱꬃይ ብታንያ ጋልባ ቦላን አከናን ካሰዋዳንካ ደኦፐ፥ ቄሲ ሄ ብታንያ ላኤንꬁዋካ ዱማ ክፍልያን ላፑን ጋላሳ ጎርዲደ ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ቃይካ ላፑንꬃ ጋላሳን ቄሲ አ፤ በእያ ዎደ ማዱꬃይ አክያዋ አጊደ ꬋይ ꬋይ ቦፐነ ꬉሞፐ፥ ቄሲ እ ጌሻ ግድያዋ ኤርሶ። ሄዌ ሻቱዋፐ አትና ሀራባ ግደና፤ ሄዋ ድራዉ፥ እ ባረ ማዩዋ ሜጪደ ጌሻ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ሽን እ ጌያናዉ ባረና ቄስያ በሴዳዋፐ ጉይያን፥ ሄ ሻቱ አ ጋልባ ቦላን ያ አክ አክ ቦፐ፥ እ ላኤንꬁዋ ባረና በሳናዉ ቄስያኮ ቦ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ቄሲካ አ በኦ፤ ሄ ሻቱ ብታንያ ጋልባ ቦላን ያ አክ አክ ቦፐ፥ ቄሲ እ ቱና ግድያዋ ኤርሶ፤ አያዉ ጎፐ ሄዌ ዎልቃማ ጋልባ ሀርግያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ኦናነ ዎልቃማ ጋልባ ሀርጊ ኦይቆፐ፥ ቄስያኮ አ አህኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ቄሲ አ በኦ፤ በእያ ዎደ አ ጋልባ ቦላን ቦꬃ ጋፉ ደኦፐ፥ ሄ ጋፉ እስክያካ ቦꬃዉ ላሞፐነ ሄ ጋፉዋ ግዶን አሹ ሙን ኡቴዳዋ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ሄዌ አ ጋልባ ቦላን ጋምኤዳ ዎልቃማ ጋልባ ሀርግያ ግድያ ድራዉ፥ ቄሲ እ ቱና ግድያዋ ኤርሶ። እ ቱና ግድያዌ ኤረት ድጌዳ ድራዉ፥ አ ዱማ ክፍልያን ጎርዳናዉ ኮሸና። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“ቃይ ዎልቃማ ጋልባ ሀርጊ ብታንያ ጋልባ ቦላን አኪደ፥ ሁጲያፐ ገድያ ጋካናዉ ኡባን ማዬዳዋ ግዶፐ፥ ቄሲ በኦ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ሄ ዎልቃማ ጋልባ ሀርጊ አ ቦላ ኡባ ማዮፐ፥ ቄሲ እ ጌሻ ግድያዋ ኤርሶ፤ አ ቦላይ ኡባናካ ላመቲደ ቦꬃ ግዴዳ ድራዉ፥ እ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ሽን ሄ ማዱꬃ ግዶን ሙኔዳ አሹ ቤቶፐ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ቄሲ ሄ ሙኔዳ አሹዋ፤ በኢደ ሄ ብታኒ ቱና ግድያዋ ኤርሶ። ሄ ሙኔዳ አሹ ዎልቃማ ጋልባ ሀርግያ ግድያ ድራዉ፥ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ሽን ሄ ሙኔዳ አሹ ቃይካ ላመቲደ ቦጾፐ፥ ሄ ብታኒ ቄስያኮ ዮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ቄሲ አ በኦ፤ አ ማዱꬃይ ቦጼዳዋ ግዶፐ፥ ሄ ብታኒ ጌሻ ግድያዋ ቄሲ ኤርሶ፤ ያቶፐ እ ጌሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“እት አሳ ቦላ ማዱꬃይ ዎꬊደ ፓጽና፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","አ ሳኣን ቦꬃ ጋፉ ቤቶፐ ዎይ ዞኤዳ እላሁ ከሶፐ፥ ሄ ኡራይ ባረና ቄስያ በሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ቄሲ አ በኦ፤ ሄ ማዱꬃይ ኦላቶፐነ ማዱꬃ ቦላን ደእያ እስኪካ ላመቲደ ቦጾፐ፥ ሄ ብታኒ ቱና ግድያዋ ቄሲ ኤርሶ። ሄዌ ማዱꬃና ዶሜዳ ዎልቃማ ጋልባ ሀርግያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ሽን ቄሲ በእያ ዎደ፥ እስኪ ቦጽቤናዋ ግዶፐነ ማዱꬃይካ ጋልባ ሉኪደ ኦላትቤናዋ ግዶፐ፥ ቃይ ꬋይ ꬋይ ቦፐ፥ ቄሲ አ ዱማ ክፍልያን ላፑን ጋላሳ ጎርዲደ ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ሄዌ አ ጋልባ ቦላን አክ አኪደ ቦፐ፥ ሄ ብታኒ ቱና ግድያዋ ቄሲ ኤርሶ፤ አያዉ ጎፐ፥ ሄዌ ጋልባ ሀርግያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ሽን ሄ እላሁ አክ አክ ቤናን እትሳ ጻላላን ደኦፐ፥ ሄዌ ማዱꬃይ ፓጼዳ ማላ ግድያ ድራዉ፥ ሄ ብታኒ ጌሻ ግድያዋ ቄሲ ኤርሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“እት አሳ ጋልባ ታማይ ሞፐነ ሄ ሜዳ ሳኣን ቦጼዳ ዎይ ዞኤዳ እላሁ ከሶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ቄሲ ሄ ሳኣ በኦ፤ አ ሳኣን ደእያ እስኪ ቦጾፐነ ማዱꬃይካ ሉኪደ ኦላቶፐ፥ ሄዌ ዎልቃማ ጋልባ ሀርግያ። እ ታማይ ሜዳሳና ከሴዳ፤ ሄዋ ድራዉ ቄሲ እ ቱና ግድያዋ ኤርሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ሽን ቄሲ በእያ ዎደ፥ ሄ እላሁዋ ቦላን ደእያ እስኪ ቦጽቤናዋ ግዶፐነ ማዱꬃይካ ጋልባ ሉኪደ ኦላትቤናዋ ግዶፐ፥ ቃይ ꬋይ ꬋይ ቤዳዋ ግዶፐ፥ ቄሲ አ ዱማ ክፍልያን ላፑን ጋላሳ ጎርዲደ ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ላፑንꬃ ጋላሳን ቄሲ አ በኦ፤ ሄ ዎደ ሄ ሳአይ አክ አክ ቦፐ፥ እ ቱና ግድያዋ ቄሲ ኤርሶ። ሄዌ ዎልቃማ ጋልባ ሀርግያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ሽን ሄ እላሁ ጋልባ ቦላን አከናን አጊደ እት ሳኣን ኡቶፐነ ኡባ ቃይ ꬋይ ꬋይ ቦፐ፥ ሄዌ ታማይ ሜዳሳን አቴዳ ማላ ግድያ ድራዉ፥ እ ጌሻ ግድያዋ ቄሲ ኤርሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“እት አቱማ አሳዉ ዎይ ማጫ አሳዉ ሁጲያ ዎይ ጋጩዋ ቦላን ማዱꬃይ ከሶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ቄሲ ሄ ማዱꬃ በኦ። እ በእያ ዎደ ማዱꬃይ ጋልባ ሉኪደ ኦላቶፐነ አ ቦላን ደእያ እስኪካ አድልያ ጪሻ ማላትያ ሌኦ ግዶፐ፥ ሄ ብታኒ ቱና ግድያዋ ቄሲ ኤርሶ። ሄዌ ሁጲያ ዎይ ጋጩዋ ቦላን ከስያ ቃጨቹዋነ ዎልቃማ ጋልባ ሀርግያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ቃይ ቄሲ ሄ ሀርግያ በእያ ዎደ፥ እ ጋልባ ሉኪደ ኦላትቤናዋ ግዶፐነ ካረꬃ እስኪካ አ ቦላ ꬋዮፐ፥ ሄ ቃጨቹዋ ሀርግያና ደእያ ብታንያ ቄሲ ዱማ ክፍልያን ላፑን ጋላሳ ጎርዲደ ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ላፑንꬃ ጋላሳን ቄሲ ሄ ሀርግያ፤ በእያ ዎደ ቃጨቹዋ ሀርጊ አከናዋ ግዶፐ፥ አ ቦላን አድልያ ጪሻ ማላትያ እስኪ ባይናዋ ግዶፐነ፥ እካ ጋልባ ሉኪደ ኦላትቤናዋ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ሄ ብታኒ ሄ ማዱꬃ ዩሹዋን ደእያ እስክያ ሜዶ፤ ቃጨችያ ሳኣን ደእያ እስክያ ማታ ሜዶፖ። ቄሲ ሄ ብታንያ ዱማ ክፍልያን ሀራ ላፑን ጋላሳ ጎርዲደ ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ላፑንꬃ ጋላሳን ቄሲ ሄ ቃጨችያ ሳኣ በእያ ዎደ፤ ሄዌ ብታንያ ጋልባ ቦላን አካና ꬋዮፐ ጋልባ ሉኪደ ኦላታና ꬋዮፐ፥ ሄ ብታኒ ጌሻ ግድያዋ ቄሲ ኤርሶ። ብታኒካ ባረ ማዩዋ ሜጪደ፥ ጌሻ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ሽን እ ጌዬዳዋፐ ጉይያን፥ ቃጨችያዌ ሄ ብታንያ ጋልባ ቦላን አክ አክ ቦፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ቄሲ አ በእያ ዎደ ሄ ቃጨችያዌ አኬዳዋ ግዶፐ፥ ቄሲ አድልያ ጪሻ ማላትያ እስክያ ኮዮፖ፤ አያዉ ጎፐ፥ ሄ ብታኒ ቱኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ሽን ቄሲ በእያ ዎደ፥ ሄ ቃጨችያሳይ አክቤናዋ ግዶፐነ ካረꬃ እስኪካ አ ቦላ ዶለዳዋ ግዶፐ፥ ሄ ቃጨችያሳይ ፓጼዳ። ሄ ብታኒካ ጌሻ ግድያ ድራዉ፥ እ ጌሻ ግድያዋ ቄሲ ኤርሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“እት አቱማ አሳ ዎይ ማጫ አሳ ጋልባ ቦላ ቦꬃ እላሁ ከሶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ቄሲ አ፤ በእያ ዎደ ሄ ኡንቱንቱ ጋልባ ቦላን ደእያ እላሁ ሾሎላ ቦꬃ ግዶፐ፥ ሄዌ ጋልባ ቦላን ጮ ከሴዳዋ፤ ሄ ብታኒካ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“እት አሳዉ ሁጲያ ብናናይ ቆቆፈቶፐ፥ እ ቦኣ፤ ግዶፐ አትና እ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ቃይ እት አሳዉ ሁጲያ ብናናይ ስንꬃና ቦአቶፐ፥ አ ቲሻይ ሜዳ፤ ግዶፐ አትና እ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ሽን አ ቦኣ ዎይ አ ቲሻይ ሜዳሳ ቦላን ዞኦ ዎይ ቦꬃ ማዱꬃይ ከሶፐ፥ ሄዌ አ ቦኣን ዎይ ቲሻይ ሜዳሳን ከሴዳ ዎልቃማ ጋልባ ሀርግያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","አ ቄሲ፤ በእያ ዎደ አ ቦኣ ዎይ ቲሻይ ሜዳሳ ቦላን ደእያ ማዱꬃይ ጋልባ ቦላን ከስያ ዎልቃማ ጋልባ ሀርግያዳን ዞኦ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ሄ ብታኒ ቱሙካ ዎልቃማ ጋልባ ሀርጊ ሳክያ ሀርጋንቻ። እ ቱና ግድያ ድራዉ እ ቱና ግድያዋ ቄሲ ኤርሶ፤ አያዉ ጎፐ ሀርጊ አ ሁጲያን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ዎልቃማ ጋልባ ሀርጊ ኦይቄዳ አሳይ ፔቴዳ ማዩዋ ማዮ፤ ባረ ሁጲያ ፕጾፖ፤ ባረ መተርሻካ ካሞ፤ ያቲደ፥ ባረ ቃላ ꬎቁ ኦꬂደ፥ ‘ታን ቱና፥ ታን ቱና!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ሄ ሀርጊ አ ቦላ ደኤዳ ኬሻን ኡባን እ ቱና። እ ቱና ግድያ ድራዉ፥ አሳፐ ሻከቲደ ዱንካኔዳ ሳኣፐ ካረና ባረካ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“አይ ማዩዋ ቦላነ ቦሮቄዳ ሳአይ ቤቶፐ፥ ሄ ማዩ ሱፈ ግድና ዎይ ሊኖ ግድና፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ቃጭናፐ ዎይ ሻሉዋፐ ዳደቴዳ ሊኖ ዎይ ሱፈ ግድና፥ ጋልባ ዎይ ጋልባፐ ኦሰቴዳ ማዩዋ ግድና፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ሄ ማዩዋ ቦላ ከሲደ ቦሮቁ ማታ ማላትያ ዎይ ዞኦ ማላ በሶፐ፥ እ ቃጭናፐ ዎይ ሻሉዋፐ ዳደቴዳዋ ግድና፥ ጋልባ ዎይ ጋልባፐ ኦሰቴዳ ማዩዋ ግድናካ፥ ሄዌ ቦሮቁ ከሴዳ ድራዉ፥ ሄዋ ቄስያ በሳናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ቄሲ ሄ ቦሮቁዋ በኢደ፥ ሄ ቦሮቁዋና ደእያ ማዩዋ ዱማ ክፍልያን ላፑን ጋላሳ ጎርዲደ ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ላፑንꬃ ጋላሳን ቄሲ ሄ ማዩዋ በእያ ዎደ፤ ሄ ማዩዋ ቦላን አክ አክ ቦፐ፥ እ ቃጭና ዎይ ሻሎ ማዩዋ ግድና፥ ጋልባ ዎይ ጋልባፐ ኦሰቴዳ ማዮ ግድናካ፥ ሄዌ እቱዋፐ እቱዋ ኦይቂያ ቦሮቆ ግድያ ድራዉ፥ ሄ ማዩ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ቃይ ሄ ማዩ ቃጭና ዎይ ሻሎ ማዮ ግድና፥ ሊኖ ዎይ ሱፈ ግድና፥ ጋልባፐ ኦሰቴዳዋ አያ ግድናካ፥ ቄሲ አ ጹጎ። ሄዌ እቱዋፐ እቱዋ ኦይቂያ ቦሮቆ ግድያ ድራዉ፥ እ ጹገታናዉ በሴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ቃይካ ቄሲ በእያ ዎደ፥ ሄ ቦሮቁ ማዩዋ ቦላ አክቤናዋ ግዶፐ፥ እ ቃጭና ዎይ ሻሎ ማዮ ዎይ ጋልባፐ ኦሰቴዳዋ አያ ግድናካ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ሄ ቦሮቁ ደእያ ማዩዋ ሜጫናዳን ቄሲ አዛዞ። ሄዋፐ ጉይያን፥ ሄ ማዩዋ ዱማ ክፍልያን ሀራ ላፑን ጋላሳ ጎርዲደ ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ሄ ቦሮቆ ሳአይ ደእያ ማዩዋ ሜጮዋፐ ጉይያን፥ ቃይካ ቄሲ በእያ ዎደ ሄ ቦሮቁ ባረ ማላ ላምቤናዋ ግዶፐ፥ እ አክ አክ ባና ꬋዮፐካ ቱና። ሄ ቦሮቆ ሳአይ ማዮ ጉየ ባጋና ዎይ ስንꬃ ባጋና ደእንካ፥ ሄ ማዩ ታማን ጹገታናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ሽን ሄ ማዩዋ ሜጭ ስምና ቄሲ በእያ ዎደ ቦሮቁ ꬋይ ꬋይ ቦፐ፥ እ ጋልባ ግድና፥ ቃጭና ዎይ ሻሎ ማዮ ግድናካ፥ ሄ ቦሮቁ ደእያ ሳኣ ቄሲ ዳኪደ ከስ ድጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ሄዋፐ ጉይያን፥ ማዩዋ ቦላ ስሚደካ ከሶፐ፥ ሄ ማዩ ቃጭና ዎይ ሻሎ ማዮ ግድና፥ ጋልባፐ ኦሰቴዳዋ አያ ግድናካ፥ ሄዌ አክ አክ ብያ ቦሮቆ ሳ ግድያ ድራዉ፥ ሄ ቦሮቁ ደእያ ማዩ ታማን ጹገታናዉ በሴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ሽን ሜጨቴዳ ማዩ ቃጭና ዎይ ሻሎ ማዮ ግድና፥ ዎይ ጋልባፐ ኦሰቴዳ አያ ማዮ ግድናካ፥ ቦሮቆ ሳአይ አ ቦላፐ ꬋዮፐ፥ ሄ ማዩ ላኤንꬁዋ ሜጨቶ፤ ሄዋፐ ጉይያን፥ እ ጌሻ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“እት ማዩ ሱፈ ዎይ ሊኖ ግድና፥ ቃጭና ዎይ ሻሎ ማዮ ግድና፥ ዎይ ቃይ ጋልባፐ ኦሰቴዳዋ ግድናካ፥ ሄ ማዩዋ ጌሻ ዎይ ቱና ጊሳናዉ ዳንዳይያ ቦሮቆ ሳኣ ዎጋይ ሀዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጊደ ኦዴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“ዎልቃማ ጋልባ ሀርጊ ኦይቄዳ ብታኒ ጌይያ ጋላስ ኦꬃናዉ ኮሽያ ዎጋይ ሀዋ። ሄ ብታንያ ቄስያኮ አፋናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ቄሲ አሳይ ዱንካኔዳ ሳኣፐ ጋጻ ከሲደ፥ አ ሀርግያ በኦ። ሄ ዎደ ዎልቃማ ጋልባ ሀርጊ ብታንያ ቦላፐ ꬋዬዳዋ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ቄሲ ፓጻ ደእያ ላኡ ጌሻ ካፎቱዋ፥ ጽድያ ምꬃ፥ ዞኦ ቃጭናነ ህሶጵያ ቦንጭያ ሄ ዎልቃማ ጋልባ ሀርግያፐ ጌይያ ብታንያ ድራዉ አሀናዳን ኡንቱንታ አዛዞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ሄዋፐ ጉይያን፥ ቃይ ቄሲ ላኡ ካፎቱዋፐ እቱዋ ከርያን ደእያ ፑልቶ ሃꬃ ቦላ ሹካናዳን አዛዞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ፓጻ ደእያ ካፉዋ፥ ቃይ ዝጋና፥ ዞኦ ቃጭናናነ ህሶጵያ ቦንጭያና አክ አፊደ፥ ከርያን ደእያ ፑልትያ ሃꬃ ቦላ ሹኬዳ ካፉዋ ሱꬃ ግዶ ናቆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ከሴዳ ሱꬃ ሄ ዎልቃማ ጋልባ ሀርግያፐ ፓጽያ ብታንያ ቦላ ላፑ ገደ ጫጫፎ፤ ያቲደ ሄ ብታኒ ጌሻ ግድያዋ ኤርሶ፤ ፓጻ ደእያ ካፉዋ ገደ ደምባ የዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“ሄ ሀርግያፐ ጌዬዳ ብታኒ ባረ ማዩዋ ሜጮ፤ ባረ ቦላን ደእያ እስክያ ኡባ ሜደቶ፤ ባረ ቦላካ ሜጨቶ፤ ያቶፐ እ ጌሻ ግዳናዋ። ሄዋፐ ጉይያን፥ እ ዱንካኔዳ ሳኣ ዮ፤ ሽን ግዶፐነ ባረ ዱንካንያ ገለናን ላፑን ጋላሳ ካረና ጋምኦ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ላፑንꬃ ጋላሳን ባረ ሁጲያ፥ ቡቻ፥ ጎማነ ባረ ቦላን ደእያ ሀራ እስክያ ኡባ ሜደቶ፤ ቃይ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ሄዋፐ ጉይያን፥ እ ጌሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“ሆስፑንꬃ ጋላሳን ትላ ቦላና ደእያ ላኡ ዶርሳ ማራቱዋነ እት ላይꬃ ግዴዳ እት ዶርሳቶ አሆ፤ ቃይ ካꬃ ያርሾ ዛይትያን ሙናቀቴዳ ኡሱፑን ኪሎ ግራመ ꬊልያነ እት ሊትሮ ዎጋራ ዛይትያዉ ሄዘንꬆ ኩሽያ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","አ ጌሽያ ቄሲ ብታንያ እ አሄዳዋንቱና እትፐካ መꬍና ጎዳ ዱንካንያ ፐንገ መꬍና ጎዳ ስንꬃ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“ቄሲካ ላኡ ዶርሳ ማራቱዋፐ እቱዋ አኪደ፥ ሊትሮ ሄዘንꬆ ኩሽያ ዛይትያና እትፐ ናቁዋ ያርሹዋ ኦꬂደ ሺሾ፤ ሄ ሺሼዳዋ ቃይ ቃꬅያ ያርሹዋ ኦꬂደ መꬍና ጎዳ ስንꬃን ቃꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ያቲደ እ ሄ ዶርሳ ማራ ናጋራ ያርሹዋነ ጹግያ ያርሹዋ ሹክያ ጌሻ ሳኣን ሹኮ፤ ናጋራ ያርሹዋዳን ናቁዋ ያርሹካ ቄስያዉ እመቴ፤ እካ ሎይꬅ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ቄሲ ናቁዋ ያርሹዋ ሱꬃፐ ጉꬃ አኪደ፥ ሄ ጌይያ ብታንያዉ ኡሸቻ ባጋ ሀይꬃ ጼራ፥ ኡሸቻ ኩሽያዉ ዎጋ ብራꬍያነ ኡሸቻ ገድያዉ ዎጋ ብራꬍያ ኦኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ሄዋፐ ጉይያን፥ ቄሲ ዎጋራ ዛይትያፐ ጉꬃ አኪደ፥ ባረ ሀድርሳ ኩሽያ ጎምፓን ትጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","“ሄ ሀድርሳ ኩሽያ ጎምፓን ደእያ ዎጋራ ዛይትያን ባረ ኡሸቻ ኩሽያ ብራꬍያ ናቂደ፥ መꬍና ጎዳ ስንꬃን ላፑ ገደ ጫጫፎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ያት ስሚደ ባረ ኩሽያ ጎምፓን አቴዳ ዛይትያፐ አኪደ፥ ጌይያ ብታንያዉ ኡሸቻ ሀይꬃ ጼራ፥ ኡሸቻ ኩሽያዉ ዎጋ ብራꬍያነ ኡሸቻ ገድያዉ ዎጋ ብራꬍያ ካሰ ናቁዋ ያርሹዋ ሱꬃ ኦከቴዳ ሳኣን ኦኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ቃይ ባረ ኩሽያ ጎምፓን አቴዳ ዛይትያ ቄሲ ጌይያ ብታንያ ሁጲያን ጉሶ፤ ያቲደ መꬍና ጎዳ ስንꬃን ሄ ብታንያ ናጋራ አቶ ጊሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“ሄዋፐ ጉይያን ቄሲ ባረ ቱናተꬃፐ ጌይያ ብታንያ ናጋራ አቶ ጊሳናዉ ናጋራ ያርሾ ሺሼዳ መህያ ሹኬ፤ ሄዋፐ ስሚደ ቃይ ጹግያ ያርሾ ሺሼዳ መህያ ያርሼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ቃይ ቄሲ ሄ ጹግያ ያርሹዋ ካꬃ ያርሹዋና እትፐ ያርሽያ ሳኣ ቦላን ዎꬂደ ጹጌ፤ ያቲደ ብታንያ ናጋራ አቶ ጊሴ፤ ብታኒካ ጌሻ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“ሽን ብታኒ ሄዋ ኡባ አሀናዉ ዳንዳየና ማንቆ ግዶፐ፥ ጾሳ ስንꬃን ቃꬂደ አ ናጋራ አቶ ጊሳናዉ፥ ባረ ናቁዋ ያርሾ እት ዶርሳ ማራ አሆ። ቃይ ካꬃ ያርሾካ ዎጋራ ዛይትያን ሙናቀቴዳ ላኡ ኪሎ ግራመ ሎኦ ꬊልያነ እት ሊትሮ ሄዘንꬆ ኩሽያ ዛይትያ እትፐ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ቃይካ ባረዉ ዳንዳዬዳዋዳን ላኡ ማራ ሀራጰቱዋ ዎይ ላኡ ማራ ዶጎማቱዋ፥ እቱዋ ናጋራ ያርሾ፥ እቱዋ ቃይ ጹግያ ያርሾ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“ሆስፑንꬃ ጋላሳን ባረ ናጋራፐ ጌያናዉ ብታኒ ሀዋንታ ቄስያኮ መꬍና ጎዳ ዱንካንያ ፐንገ መꬍና ጎዳ ስንꬃ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ቄሲ ናቁዋ ያርሾ አሄዳ ዶርሳ ማራነ ልትሮ ሄዘንꬆ ኩሸ ዛይትያ አኪደ፥ ቃꬅያ ያርሹዋ ኦꬂደ መꬍና ጎዳ ስንꬃን ቃꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ያቲደ ናቁዋ ያርሾ አሄዳ ዶርሳ ማራ ሹኪደ ሄ ናቁዋ ያርሹዋ ሱꬃፐ ጉꬃ አኪደ፥ ሀ ጌይያ ብታንያዉ ኡሸቻ ሀይꬃ ጼራ፥ ኡሸቻ ኩሽያዉ ዎጋ ብራꬍያነ ኡሸቻ ገድያዉ ዎጋ ብራꬍያ ኦኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ቃይ ቄሲ ዛይትያፐ ጉꬃ ባረ ሀድርሳ ኩሽያ ጎምፓን ትጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ሄ ሀድርሳ ኩሽያ ጎምፓን ደእያ ዛይትያፐ ኡሸቻ ኩሽያ ጼራን ጉꬃ አኪደ፥ መꬍና ጎዳ ስንꬃን ላፑ ገደ ጫጫፎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ቃይካ ቄሲ ባረ ኩሽያ ጎምፓን ደእያ ዛይትያፐ ጉꬃ አኪደ፥ ጌይያ ብታንያዉ ኡሸቻ ሀይꬃ ጼራ፥ ኡሸቻ ኩሽያዉ ዎጋ ብራꬍያነ ኡሸቻ ገድያዉ ዎጋ ብራꬍያ ካሰ ናቁዋ ያርሹዋ ሱꬃ ኦከቴዳ ሳኣን ኦኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ቃይ መꬍና ጎዳ ስንꬃን ብታንያ ናጋራ አቶ ጊሳናዉ፥ ቄሲ ባረ ኩሽያን አቴዳ ዛይትያ ጌይያ ብታንያ ሁጲያን ኦኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ሄዋፐ ጉይያን፥ ሄ አዉ ባረዉ ዳንዳዬዳዋዳን ሀራጵያ ማራ ግድና ዎይ ማራ ዶጎሙዋ ግድና፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","እቱዋ ናጋራ ያርሾ ላኤንꬁዋ ቃይ ጹግያ ያርሾ ካꬃ ያርሹዋና እትፐ ያርሾ። ቃይ ቄሲካ ሄ ጌይያ ብታንያዉ መꬍና ጎዳ ስንꬃን አ ናጋራ አቶ ጊሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ባረ ቦላን ደእያ ዎልቃማ ጋልባ ሀርግያፐ ጌያናዉ ኮሽያ ዎጋ ፖላናዉ ማንቆታይ ድጌዳ ኡራዉ ደእያ ዎጋይ ስም ሀዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ታን ህንተንቶ አቆ ኦꬃደ እምያ ካናነ ቢታ ህንተ ገልያ ዎደ፥ ቃይ ሄ ጋድያን ደእያ ህንተ ኬꬃፐ እቱዋን ታን ቦሮቁዋ የድያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ሄ ጎልያዉ ቄስያኮ ቢደ፥ ‘ታ ሶን አያ ቦሮቀንቶ ደኤ’ ያጊደ ኦዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ጎለን ደእያባይ ኡባይ ቱና ጌተተናዳን፥ ቄሲ ቦሮቁዋ በአናዉ ገላናፐ ካሰቲደ፥ ሶን ደእያዋ ኡባ ካረ ከሳናዳን አዛዞ፤ ያት ስምና ቄሲ በአናዉ ጎለ ገሎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ሄዋን በእያ ዎደ፥ ቦሮቆ ሳአይ ጎዳ ቦላን ማታ ማላትያ፥ ዎይ ዞኦ ማላ በሶፐነ ቃይ ጎዳፐ ኦላቲደ ግዶ ገሎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ቄሲ ጎለፐ ካረ ከሲደ፥ ጎልያ ላፑን ጋላሳ ጋካናዉ ጎርዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ላፑንꬃ ጋላሳን ቄሲ ሄ ጎልያ ዛረꬂደ፤ ጼልያ ዎደ ሄ ቦሮቁ ጎልያ ጎዳ ቦላን አኮፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ቦሮቁ ደእያ ሹቻቱዋ ኡባ ጎዳፐ ሾዲደ፥ ካታማፐ ጋጻ ያ ቱኔዳ ሳአዉ ኦላናዳን አዛዞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ቃይ ጎዳ ዱፌዳ ኡርቃ ሶ ባጋና ቦክሽን፥ ዩሽ አꬂደ ቆቆፋናዳን ኦꬆ፤ ያቲደ ሄ ቆቆፌዳ ኡርቃ ካታማፐ ጋጻን ደእያ ቱና ሳኣን ኦልኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ሄዋፐ ጉይያን፥ ሄ ሾዴዳ ሹቻቱ ሳኣን ሀራ ሹቻቱዋ ዎꬅኖ፤ ቃይ ሀራ ኡርቃንካ ጎልያ ዱፍኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ሹቻቱዋ ሾድ ድግና፥ ቃይ ኡርቃካ ቆቆፊደ ሀራ ኡርቃ ዱፊ ስምና፥ ላኤንꬁዋ ስሚደ ቦሮቁ ጎልያ ግዶን አኮፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ቄሲ ሄዋ በእያ ዎደ፤ ቦሮቁ ሄ ጎልያ ግዶን አኮፐ፥ ሄዌ እቱዋፐ እቱዋ ኦይቂያ ቦሮቆ ግድያ ድራዉ፥ ሄ ጎሊ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ሄዋ ድራዉ እ ሄ ጎልያ፥ አ ሹቻ፥ አ ምꬃነ እ ዱፈቴዳ ኡርቃ ኡባ ኮሎ፤ ሄዋንታ ካታማፐ ጋጻ አፊደ፥ ቱና ሳኣን ኦሎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ቃይ ሄ ጎሊ ጎርዳን ታክያ ዎድያን አ ግዶ ገልያ ኦንነ ሳአይ ቃማና ጋካናዉ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ሄ ጎልያን ግስያ ኡራይ ዎይ ቁማ ምያ ኡራይ ባረ ማዩዋ ሜጮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“ሽን ቄሲ ዪደ ጼልያ ዎደ፥ ጎሊ ዱፈት ስምና ላኤንꬁዋ ስሚደ አካና ꬋዮፐ፥ ቦሮቁ ꬋዬዳ ድራዉ፥ ሄ ጎሊ ጌሻ ግድያዋ ቄሲ ኤርሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ጎልያ ጌሻናዉ ላኡ ካፎቱዋ፥ ጽድያ ምꬃ፥ ዞኦ ቃጭናነ ህሶጵያ ቦንጭያ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ካፎቱዋፐ እቱዋ ከርያን ደእያ ፑልቱዋ ሃꬃ ቦላን ሹኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ሄዋፐ ጉይያን ጽድያ፥ ህሶጵያ ቦንጭያ፥ ዞኦ ቃጭናነ ፓጻ ደእያ ካፉዋ እትፐ አኪደ፥ ከርያን ደእያ ሹኬዳ ካፉዋ ሱꬃንነ ፑልቱዋ ሃꬃን የግ ከሲደ፥ ላፑ ገደ ሄ ጎልያ ጫጫፎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ያቲደ ሄ ጎልያ ቄሲ ካፉዋ ሱꬃን፥ ፑልቱዋ ሃꬃን፥ ፓጻ ደእያ ካፉዋን፥ ጽድያን፥ ህሶጵያ ቦንጭያንነ ዞኦ ቃጭናን ጌሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ቃይ ፓጻ ደእያ ካፉዋ ካታማፐ ጋጻ ህን ደምባ የዶ። ሄዋዳን ኦꬂደ፥ ጎልያ ጌሽያ ዎጋ ፖሌ፤ ጎሊካ ጌሻ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“አይ ዎልቃማ ጋልባ ሀርገ ግዶፐካ ሀዌ ዎጋ፤ ቃጨችያዋ ግድና፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ማዩዋ ቦላን ዎይ ጎልያ ቦላን ከስያ ቦሮቆ ግድና፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ጋፉዋ ግድና፥ ꬉሳ ማዱꬃ ግድና ዎይ እላሁዋ ግድናካ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","እትባይ ቱና ግድያዋነ ጌሻ ግድያዋ ኤርሳናዉ ዎልቃማ ጋልባ ሀርግያነ ቦሮቁዋ ዎጋይ ሀዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“እስራኤልያ አሳዉ ሀዋዳን ያጊደ ኦድተ፤ ‘አይ አሳ አቱንꬃፐ አያይኔካ ጎጎፐ፥ ሄ ጎግያባይ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ሄ ጎግያዋፐ ደንዴዳዋን ሄ ኡራይ ቱና ግድያ ዎጋይ ሀዋ: ሄ ጎግያባይ አገናን ጎግናካ ዎይ ቃይ ጎግያዋ አግንቶካ ሄ አ ግዶን ደእያባይ አ ቱንሴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘አ ቦላፐ አያይኔካ ጎግያ አሳይ ግስያ አይ ግሱካ ቱና፤ ቃይ እ ኡትያባይ አያ ግዶፐካ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","አ ግሱዋ ቦችያ ኦንነ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ጎግያዋና ደእያ አሳይ ኡቴዳዋ ቦላ ኡትያ ኦንነ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘ጎግያባይ ደእያ አሳ ቦላ ቦችያ ኦንነ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘ጎግያባይ ደእያ አሳይ ጌሻ አሳ ቦላ ጩቾፐ፥ ሄ አሳይ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘ቃይ ጎግያባይ ደእያ አሳይ ኡትያ አይ ኮራይካ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ባረፐ ጋርሳና ደእያዋ አያን ግዶፐካ ቦችያ ኦንነ ኦማርስ ጋካናዉ ቱና፤ ቃይ ሄዋንታ ማላትያዋንታ ቶክያ ኦንነ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘ጎግያዋና ደእያ አሳይ ባረ ኩሽያ ሜጨተናን ደኢደ ቦችያ አሳይ ኦንነ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘ቃይ ጎግያባይ ደእያ አሳይ ቦችያ ኡርቃ ሚሻ ኡባ መንꬅተ፤ ምꬃፐ ኦሰቴዳ ሚሻ ኡባይ ቃይ ሃꬃን ሜጨቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘ጎግያባይ ደእያ አሳይ ሄ ጎግያዋፐ ጌይያ ዎደ፥ ባረዉ ላፑን ጋላሳ ፓይዶ። ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ፑልቱዋ ሃꬃን ሜጨቶ፤ ያቲደ እ ጌሻ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ሆስፑንꬃ ጋላስ ላኡ ማራ ሀራጰቱዋ ዎይ ላኡ ማራ ዶጎማቱዋ አኪደ፥ መꬍና ጎዳ ዱንካንያ ፐንግያ መꬍና ጎዳ ስንꬃ ዪደ፥ ቄስያዉ ኡንቱንታ እሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ቄሲ ሀራጰቱዋፐ እቱዋ ናጋራ ያርሾ፥ ላኤንꬁዋ ቃይ ጹግያ ያርሾ ያርሼ፤ ያቲደ ቄሲ ብታንያ ቦላፐ ጎግያዋ ድራዉ መꬍና ጎዳ ስንꬃን አ ናጋራ አቶ ጊሴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘አይ አቱማ አሳይነ ባረ አቱማተꬃፐ ዘረꬃይ ጉኮፐ፥ ባረ ኩመንꬃ ቦላ ሃꬃን ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","አቱማተꬃፐ ጉኬዳ ዘረꬃይ ቦቼዳ ማዩዋ ኡባይ ዎይ ጋልባ ኡባይ ሃꬃን ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ቃይ እት አቱማ አሳይ ማጫ አሳና ግስና፥ አ አቱማተꬃፐ ዘረꬃይ ጉኮፐ፥ ላኡካ ሃꬃን ሜጨትኖ፤ ቃይ ኦማርስ ጋካናዉ ኡንቱንቱ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘ማጫ አሳዉ አግናን አግናን ይያ ፒላይ ዮፐ፥ ላፑን ጋላሳ ጋካናዉ እዛ ቱና፤ ቃይ እዞ ቦችያ ኦንነ ኦማርስ ጋካናዉ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘ሄ ፒላ ዎደ እዛ ግስያዌ ኡባይ ቱና፤ ቃይ እዛ ኡትያዌ ኡባይካ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","እዛ ግስያ ግሱዋ ቦችያ ኡባይ ባረ ማዩዋ ሜጮ፤ ሃꬃንካ ሜጨቶ፤ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","እዛ ኡትያዋ ቦችያ ኡባይ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","እዛ ግስያ ግሱዋ ግድናካ ዎይ እዛ ኡትያዋ ቦችያ ኦንነ ኦማርስ ጋካናዉ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘አይ አቱማ አሳይነ ሄ ፒላ ዎደ ኢናና ግሶፐ፥ ሄ ፒላይ ቃይ አ ቦቾፐ፥ ላፑን ጋላሳ ጋካናዉ እ ቱና፤ እ ግስያ ግሱ ኡባይካ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘እት ማጫ ምሽራትዉ እዝ ፒላ ዎድያ ግደናን ሀራ ዎድያን ሱꬃይ ጎጎፐ፥ ዎይ ቃይ እዝ ፒላይካ ባረ ዎድያፐ አꬂደ ኤቀናን እጺደ ጎጎፐ፥ እ ኤቃና ጋካናዉ እዛ ቱና። ባረ ፒላ ዎድያን ቱና ግድያዋዳን፥ ሄ ዎደካ እዛ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ሄ ሱꬃይ ኢፐ ጎግያ ዎድያን እዛ ግሴዳ ግሱ ኡባይ፥ ባረ ፒላ ዎደ እዛ ግሴዳ ግሱዋካ ማላ ቱና፤ ቃይ እዛ ኡትያባይ ኡባይካ ባረ ፒላ ዎደ እዛ ኡትያባይ ቱና ግድያዋዳን ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ቃይ ሄ ቱኔዳባቱዋ ቦችያ ኦንነ ቱና፤ እ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ቃይ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘እዝፐ ጎግያባይ ኤቆፐ፥ እዛ ሄ ዎድያፐ ዶማደ ላፑን ጋላሳ ፓይዱ፤ ሄዋፐ ጉይያን፥ እዛ ጌሻ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ሆስፑንꬃ ጋላሳን እዛ ላኡ ማራ ሀራጰቱዋ ዎይ ላኡ ማራ ዶጎማቱዋ አካደ፥ ጾሳ ዱንካንያ ፐንግያ ቄስያኮ አሁ። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ቄሲ ሀራጰቱዋፐ እቱዋ ናጋራ ያርሾ እቱዋ ቃይ ጹግያ ያርሾ ያርሾ። ያቲደ ቄሲ ኢፐ ጎግያዋ ቱናተꬃ ድራዉ መꬍና ጎዳ ስንꬃን እ ናጋራ አቶ ጊሴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘ባረንቱ ግዶን ደእያ ጾሳ ዱንካንያ ቱንሲደ እስራኤልያ አሳይ ሀይቀናዳን፥ ኔን ሀዋዳን ኦꬃደ ኡንቱንቱ ባረና ቱንስያዋፐ ሻከቲደ ደአናዳን ናጋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“ ‘አ ቦላፐ አያይኔካ ጎግያ አሳዉነ አ አቱማተꬃፐ ጉኬዳ ዘረꬃን ቱንያ አሳዉ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ቃይ ባረ ፒላ ጋሱዋን ቱንያ ማጫ አሳዉ፥ አቱማ ግድና ማጫዋ ግድና ጎግያባይ ደእያ አሳዉነ ቱኔዳ ማጫ አሳና ግስያ አቱማ አሳዉ እመቴዳ ዎጋይ ሄዋ’ ያግተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","አሮና አቱማ ናናይ ላኡ መꬍና ጎዳ ስንꬃ ሺቂደ ሀይቄዳዋፐ ጉይያን፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“መꬍና ጎዳይ ሙሳ፥ ነ እሻይ አሮን ታቦታ ቦላን ደእያ አቶ ግያ ሳኣ ቁምእያ ስንꬃን ጋርዱዋፐ ጉየ ባጋና ደእያ ኡባፐ አꬌዳ ጌሻ ሳኣ ኡባ ዎደ ጮ ገለናዳን አዉ ኦዳ። ጮ ገሎፐ እ ሀይቃና፤ አያዉ ጎፐ፥ ታን ሻርያ ግዶና አቶ ግያ ሳኣ ቁምእያ ቦላን ቆንጫይ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","አሮን ናጋራ ያርሾ እት ኮሩማነ ቃይ ጹግያ ያርሾ እት ዶርሳ ኦርግያ አኪደ፥ ሄ ኡባፐ አꬌዳ ጌሻ ሳኣ ገሎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“አሮን ሊኑዋፐ ኦሰቴዳ ጌሻ ቃምሽያነ ሊኑዋፐ ኦሰቴዳ ጋርሳና ማይያ ማዩዋ ማዮ። ቃይ ሊኑዋፐ ኦሰቴዳ ዳንጩዋ ዳንጮ፤ ሄዋዳንካ ቃይ ባረ ሁጲያን ሊኑዋፐ ኦሰቴዳ ሻሽያ ኤንጩርሳ ዎꬆ። ሀዋንቱ ጌሻ ማዮቱዋ ግድያ ድራዉ፥ እ ባረ ቦላ ሃꬃን ሜጨት ክቺደ ማዮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“እስራኤልያ አሳ ማባራይ ናጋራ ያርሾ ላኡ ዴሻ ኮለቱዋ፥ ጹግያ ያርሾካ እት ዶርሳ ኮልያ አሮናዉ አይኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","አሮን ባረ ናጋራነ ባረ ሶ አሳ ናጋራ አቶ ጊሳናዉ ኮሩማ ያርሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ሄዋፐ ጉይያን፥ ላኡ ዴሻ ኮለቱዋ አፊደ፥ መꬍና ጎዳ ዱንካንያ ፐንግያን መꬍና ጎዳ ስንꬃን ኤሶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ያቲደ ሄ ላኡ ዴሻቱዋን ሳማ የግና እቱ መꬍና ጎዳሳ፤ እቱ ቃይ ባዙዋ የድያዋ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","አሮን መꬍና ጎዳዉ ሳማይ ከሴዳ ዴሻ አሂደ፥ ናጋራ ያርሾ ኦꬂደ ያርሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ሽን ባዙዋ የድያ ሳማይ ከሴዳ ዴሻ ፓጻ ደእሽን መꬍና ጎዳዉ ሺሾ፤ ባዙዋ አ የደርስያ ዎደ፥ አሳ ናጋራ አቶ ጊሴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“አሮን ባረ ናጋራነ ባረ ሶ አሳ ናጋራ አቶ ጊሳናዉ፥ እት ኮሩማ ናጋራ ያርሹዋ ኦꬂደ ሺሾ። ያቲደ ባረ ናጋራ ያርሾ ሄ ኮሩማ ሹኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ቃይ መꬍና ጎዳ ስንꬃን ደእያ ያርሽያ ሳኣፐ እጻና ጩውስያ ሚሻ ኩመንꬃ ቦንቁዋነ፥ ሊቅ ጋጨቴዳ ላኡ ኮጵያ ሳዊያ እጻና አኪደ፥ ጋርዱዋ ግዶ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","እ ሀይቀናዳን፥ እጻና ጩዋይ ታቦታ ቦላን ደእያ አቶ ግያ ሳኣ ቁምእያ ካማና ማላ፥ እጻና መꬍና ጎዳ ስንꬃን ደእያ ታማን ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ቃይ ሄ ኦርግያ ሱꬃፐ ጉꬃ አኪደ፥ ባረ ብራꬍያ አን ናቂደ፥ አቶ ግያ ሳኣ ቁምእያዉ ስንꬃ ባጋ ጫጫፎ፤ ቃይ አቶ ግያ ሳኣ ቁምእያፐ ስንꬃ ባጋና ደእያ ሳኣካ ላፑ ገደ ጫጫፎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ሄዋፐ ጉይያን አሳ ናጋራ ያርሾ ግድያ ዴሻ ሹኪደ፥ አ ሱꬃ ጋርዱዋ ግዶ አሆ፤ ኮሩማ ሱꬃ ጫጫፌዳዋዳን፥ አቶ ግያ ሳኣ ቁምእያ ስንꬃነ አቶ ግያ ሳኣ ቁምእያፐ ስንꬃ ባጋና ደእያ ሳኣ ጫጫፎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ያቲደ ኡባፐ አꬌዳ ጌሻ ሳኣ እስራኤልያ አሳ ቱናተꬃፐነ ናጋራፐ ጌሼ። ቃይ ኡንቱንቱ ቱናባ ኦꬅሽን፥ ኡንቱንቱ ግዶን ደእያ ጾሳ ዱንካንያካ ሄዋዳን ኦꬂደ ጌሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","እ ኡባፐ አꬌዳ ጌሻ ሳኣ ገሊደ፥ ባረ ናጋራ፥ ባረ ሶ አሳ ናጋራነ ኩመንꬃ እስራኤልያ አሳ ናጋራ አቶ ጊሲደ ከሳና ጋካናዉ፥ ኦንነ ጾሳ ዱንካንያ ግዶን ደኦፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“ሄዋፐ ጉይያን እ መꬍና ጎዳ ስንꬃን ደእያ ያርሽያ ሳኣ ዪደ አ ናጋራ አቶ ጊሶ። ኮሩማ ሱꬃፐነ ዴሻ ሱꬃፐ ጉꬃ ጉꬃ አኪደ፥ ያርሽያ ሳኣ ዩሹዋን ደእያ ካጨቱዋ ኦኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ቃይ ሄ ሱꬃፐ ጉꬃ ባረ ብራꬍያን አኪደ፥ ላፑ ገደ ያርሹዋ ሳኣ ቦላ ጫጫፊደ፥ እስራኤልያ አሳ ቱናተꬃፐ ሄ ያርሹዋ ሳኣ ጌሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“አሮን ኡባፐ አꬌዳ ጌሻ ሳኣ፥ ጾሳ ዱንካንያነ ያርሽያ ሳኣ ጌሽያ ዎጋ ፖሌዳዋፐ ጉይያን፥ ፓጻ ደእያ ዴሻ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","አሮን ባረ ላኡ ኩሸቱዋ ፓጻ ደእያ ዴሻ ሁጲያን ዎꬂደ፥ እስራኤልያ አሳ ናቁዋ ኡባ፥ ኡንቱንቱ ማካላ ኡባ፥ ኡንቱንቱ ናጋራ ኡባ ፓጾ፤ ያቲደ ሄ ዴሻ ሁጲያን ሄዋ ቶሲደ ሄ ዴሻ አፋናዳን ጊግሴዳ አሳ ቦላን ባዙዋ የዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","እ ዴሻ ባዙዋ የድና፥ ዴሻይ ኡንቱንቱ ናጋራ ኡባ ቶኪደ፥ አሳይ ባይና ሳኣ ባዙዋ ቦ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“ሄዋፐ ጉይያን፥ አሮን ጾሳ ዱንካንያ ቢደ ኡባፐ አꬌዳ ጌሻ ሳኣ ገሌዳ ዎደ፥ ካሰ ባረ ማዬዳ ሊኑዋፐ ኦሰቴዳ ማዩዋ ቃሪደ ሄዋን ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ጌሻ ሳኣን እ ባረ ቦላ ሃꬃን ሜጨቲደ፥ ሀራ ማዩዋ ማዪደ ከሶ፤ ያቲደ ጹግያ ያርሹዋ ባረዋነ አሳዋ ያርሺደ፥ ባረ ናጋራነ አሳ ናጋራ አቶ ጊሴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ቃይ ሄዋዳንካ ናጋራ ያርሹዋ ሀንዳ ያርሽያ ሳኣ ቦላን ዎꬂደ ጹጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“ዎራ የድያ ዴሻ አፌዳ ብታኒካ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሃꬃን ሜጨቶ። ያት ስሚደ ዱንካኔዳሳ ዮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“ናጋራ አቶ ጊሳናዉ አሮን ኡባፐ አꬍያ ጌሻ ሳኣ ገሌዳ ዎደ፥ ናጋራ ያርሹዋ ኮሩማ ሱꬃነ ዴሻ ሱꬃ አኪደ ገሌዳ፤ ሀእ ህንተ ሄ ኮሩማነ ሄ ዴሻነ ዱንካኔዳ ሳኣፐ ጋጻ ከስተ። ኡንቱንቱ ጋልባ፥ ኡንቱንቱ አሹዋነ ኡንቱንቱ ቶጭያ ታማን ጹግተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ሄዋ ታማን ጹጌዳ ብታኒ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሃꬃን ሜጨቶ፤ ሄዋፐ ጉይያን፥ ዱንካኔዳ ሳኣ ዮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ሀዌ ህንተንቶ መꬍናዉካ ዎጋ ግዶ: ላፑንꬃ አግናይ ገሌዳ ታሙንꬃ ጋላሳን ህንተ ሁጲያ ካዉሽተ፤ እስራኤልያ አሳ ግድና ዎይ ቃይ ህንተ ግዶን ደእያ ሀራ ቢታ አሳ ግድናካ፥ አይ ኦሶነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","አያዉ ጎፐ፥ ህንተና ጌሻናዉ፥ ህንተ ናጋራ አቶ ጊስያ ጋላሳይ ሄ ጋላሳ። ህንተካ መꬍና ጎዳ ስንꬃን ህንተ ናጋራ ኡባፐ ጌያና። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ሄዌ ህንተ ዋና ሸምፑዋ ሸምፕያ ሳምባታ ጋላሳ። ሄ ጋላሳን ህንተ ሁጲያ ካዉሽተ፤ ሄዌ ህንተንቶ መꬍናዉካ ዎጋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ቃይ ባረ አዉዋ ኮታን ቄሰ ግዳናዳን ኦከትያዌነ ዱማትያ አሳይ ጌሻ ግዴዳ ሊኑዋፐ ዳደቴዳ ማዩዋ ማዪደ፥ ናጋራ አቶ ጊስያ ዎጋ ፖሎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","እ ኡባፐ አꬍያ ጌሻ ሳኣ፥ ጾሳ ዱንካንያ፥ ያርሽያ ሳኣ፥ ቄሳቱ ዋነ እስራኤልያ አሳ ኡባ ጌሾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","እስራኤልያ አሳ ናጋራ ኡባ አቶ ጊስያ ዎጋ ህንተ ላይꬃን ላይꬃን እት ገደ ኦꬃናዳን፥ ሀዌ ህንተንቶ መꬍናዉካ ዎጋ ግዶ” ያጌዳ። ሙሴ መꬍና ጎዳይ አዛዜዳዋዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“አሮናዉ አ አቱማ ናናቶነ እስራኤልያ አሳ ኡባዉ ሀዋዳን ያጋደ ኦዳ፤ ‘መꬍና ጎዳይ አዛዜዳዌ ሀዋ: ");
INSERT INTO dwrENT_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","እስራኤልያ አሳፐ ኦንነ ቦራ ዎይ ዶርሳ ዎይ ዴሻ ዱንካኔዳ ሳኣን ዎይ ዱንካኔዳ ሳኣፐ ጋጻና ሹኪደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","መꬍና ጎዳዉ እሞታ ኦꬂደ እማናዉ መꬍና ጎዳ ዱንካንያ ፐንግያ መꬍና ጎዳ ስንꬃ አሀና ꬋዮፐ፥ ሄ ሱꬃን እ ኦሸቴ፤ ሄ አሳይ ሱꬃ ጉሴዳ። ሄዋ ድራዉ እ ባረ አሳ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ሄዋ ድራዉ እስራኤልያ አሳይ ባረንቱ ያርሹዋ መህያ ጮ ደምባን ሹክያዋ አጊደ፥ ሃ መꬍና ጎዳኮ፥ መꬍና ጎዳ ዱንካንያ ፐንግያን ደእያ ቄስያኮ አህኖ። ቄሲ ሄዋ አኪደ፥ መꬍና ጎዳዉ እትፐተꬃ ያርሹዋ ኦꬂደ ሹኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ቃይ ቄሲ መꬍና ጎዳ ዱንካንያ ፐንግያን ደእያ መꬍና ጎዳዉ ያርሽያ ሳኣ ቦላን ሄ ሱꬃ ጫጫፎ፤ ሀንዳካ መꬍና ጎዳዉ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ኦꬂደ ጹጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","እስራኤልያ አሳይ ጾሳ ካልያዋ አጊደ ካሌዳ ጻላሄቶ ላኤንꬆ ባረንቱ ያርሹዋ ያርሾፕኖ። ሀዌ ኡንቱንቶነ ይያ የለታ ኡባዉ መꬍናዉ ዎጋ ግዶ’ ያጋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ኡንቱንታ ሀዋዳን ያጋ፤ ‘እስራኤልያ አሳፐ ግድና ዎይ ኡንቱንቱ ግዶን ደእያ ሀራ ቢታ አሳፐ ግድናካ፥ ኦንነ ጹግያ ያርሹዋ ዎይ ሀራ ያርሹዋ ሺሽያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","መꬍና ጎዳዉ ያርሻናዉ መꬍና ጎዳ ዱንካንያ ፐንግያ አሀና ꬋዮፐ፥ ሄ አሳይ ባረ አሳ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘እስራኤልያ አሳፐ ዎይ ኡንቱንቱ ግዶን ደእያ ሀራ ቢታ አሳፐ ኦንነ ሱꬃ ሞፐ፥ ሄ ሱꬃ ምያ አሳ ቦላን ታን ታ ዴሙዋ ቱካና፤ ታን ሄ ብታንያ አሳ ግዶን ቦሀና። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","አያዉ ጎፐ አሹዋ ማዬዳ ኡባ ደኡ አ ሱꬃ ግዶን ደኤ፤ ሱꬃይካ ቃይ ደኡዋ ሸምፑ አ ግዶን ደእያዋፐ ደንዴዳዋን ናጋራ አቶ ጊስያዋ ግድያ ድራዉ፥ ህንተ ናጋራ አቶ ጊሳናዳን፥ ታን ህንተንቶ ያርሽያ ሳኣ ቦላን ያርሻናዳን እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ሄዋ ድራዉ ታን እስራኤልያ አሳ፥ “ህንተፐ ዎይ ህንተ ግዶን ደእያ ሀራ ቢታ አሳፐ ኦንነ ሱꬃ ሞፖ” ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘እስራኤልያ አሳፐ ዎይ ኡንቱንቱ ግዶን ደእያ ሀራ ቢታ አሳፐ ኦንነ ምያ ዶኣ ዎይ ካፉዋ ሻንካቲደ ዎꬎፐ፥ አ ሱꬃ ሳኣን ጉሲደ፥ ቢታ ካሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","አያዉ ጎፐ አሹዋ ማዬዳ ኡባ ሸምፑ አ ሱꬃ ግዶና። ሄዋ ድራዉ ታን እስራኤልያ አሳ፥ “አሹዋ ማዬዳ መታ ኡባ ሸምፑካ አ ሱꬃ ግዶን ደእያ ድራዉ፥ ሱꬃ ሞፕተ፤ ቃይ ምያ ኦንነ ባረ አሳ ግዶፐ ቦሄቶ” ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘እስራኤልያ አሳ ግድና ዎይ ኡንቱንቱ ግዶን ደእያ ሀራ ቢታ አሳ ግድና፥ ኦንነ ባኩታ ዎይ ዶአይ ኦይቂደ ዎꬌዳ አሹዋ ሞፐ፥ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሜጨቶ፤ ያቲደ ኦማርስ ጋካናዉ እ ቱና። ሄዋፐ ጉይያን፥ እ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ባረ ማዩዋ ሜጫና ꬋዮፐ፥ ባረ ቦላካ ሜጨታና ꬋዮፐ፥ እ ባረ ናጋራን ኦሸቴ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“እስራኤልያ አሳ ሀዋዳን ያጋ፤ ‘ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ህንተ ካሰ ደኤዳ ግብጼ ቢታ አሳይ ኦꬅያዋዳን ኦꬆፕተ፤ ዎይ ሀእ ታን ህንተና አፍያ ካናነ ቢታ አሳይ ኦꬅያዋዳንካ ኦꬆፕተ፤ ኡንቱንቱ ዎጋካ ካሎፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ህንተ ታ አዛዙዋ ኦꬅተ፤ ታ ዎጋካ ናግተ፤ ቃይ አን ቢተ። ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ሄዋ ድራዉ ታ አዛዙዋነ ታ ዎጋ ናጎፐ፥ ህንተ ፓጻ ደአና። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘ህንተፐ ኦንነ አሹዋ አሙዋ ፖላናዉ ባረ ማታ ዳቡዋና ግሶፖ። ታን ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ነ አሹዋ አሙዋ ፖላናዉ ነ ዳይና ግሶፓ፤ ነ አዉዋ ካዉሾፓ። እዛ ነ ዳዮ፤ ኢናና ግሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ነ አሹዋ አሙዋ ፖላናዉ ነ አዉዋ ማቻትና ግሶፓ፤ ነ አዉዋ ካዉሾፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘ነ አሹዋ አሙዋ ፖላናዉ ነ ምቻትና ግሶፓ፤ ዎይ ቃይ ሶን የለቴዳ ዎይ ካረን የለቴዳ ነ አዉዋ ዎይ ነ ዳይ ናትናካ ግሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘ነ አሹዋ አሙዋ ፖላናዉ ነ ናኣ ናትና ዎይ ነ ናት ናትና ግሶፓ። ነ ሁጲያዉ ኔና ካዉሻሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ነ አሹዋ አሙዋ ፖላናዉ ነ አዉዋ ማቻት ናትና ግሶፓ፤ እዛ ነ ምቻቶ ግድያ ድራዉ ኢናና ግሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ነ አሹዋ አሙዋ ፖላናዉ ነ አዉዋ ምቻትና ግሶፓ። እዛ ነ አዎ ማታ ዳቦ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","አሹዋ አሙዋ ፖላናዉ ነ ዳይ ምቻትና ግሶፓ፤ እዛ ነ ዳይዉ ማታ ዳቦ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ነ አዉዋ እሻ ካሉዋ ቃራደ ነ አሹዋ አሙዋ ፖላናዉ አ ማቻትና ግሶፓ፤ እዛ ነ አዉዋ እሻ ማቻቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ነ አሹዋ አሙዋ ፖላናዉ ነ ናኣ ማቻትና ግሶፓ፤ እዛ ነ ናኣ ማቻቶ ግድያ ድራዉ፥ ኢናና ግሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ነ አሹዋ አሙዋ ፖላናዉ ነ እሻ ማቻትና ግሶፓ፤ ግሶፐ ነ እሻ ካዉሻሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘ነ አሹዋ አሙዋ ፖላናዉ ምሽራትናነ እ ናትናነ ላኡዋና ግሶፓ። እ ናት ናትና ዎይ ቃይ እ ናኣ ናትናካ ግሶፓ፤ ኡንቱንቱ እዝዉ ማታ ዳቦ ግድያ ድራዉ፥ ሄዌ ሻርሙጻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘ነ ማቻታ ፓጻ ደእሽን፥ ነ ማቻት ምቻቶ አካደ ነ አሹዋ አሙዋ ፖላናዉ ኢናና ግሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘ነ አሹዋ አሙዋ ፖላናዉ ፒላይ ዪና ቱና ኡቴዳ ምሽራትና ግሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘ኔን ቱነናዳን ነ ሾሩዋ ማቻትና ግሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘ነ ጾሳ ሱንꬃ ቱንሳናዉ ነ ናናቱዋፐ እቱዋነ ታማን ጹጊደ፥ ሞሎካ ግያ ኤቃዉ ያርሻናዳን እሞፓ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘ማጫ አሳና ግስያዋዳን አቱማ አሳና ግሶፓ፤ ሄዌ ሸነይያባ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘ኔን ቱነናዳን አይ መህያናነ ግሶፓ፥ ቃይ ማጫ አሳይካ መህያና ግሳናዉ መህያ ስንꬃ አꬎፖ። ሄዌ ዎጋይ ባይናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘ታን ህንተ ስንꬃፐ የደርስያ ካዉተꬃቱ ሀ ኦሶቱዋን ቱኔዳ ድራዉ፥ ህንተ ሀዋንታ ማላትያዋቱዋን ቱኖፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ሀራይ አቶ ኡንቱንቱ ቢታይካ ቱኔዳ ድራዉ፥ አ ናጋራዉ ታን አ ሙራድ፤ ቢታይካ ባረናን ደእያዋንታ ጩቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ሽን ህንተ ታ ህግያነ ታ አዛዙዋ ናግተፐ አትና፥ እስራኤልያ አሳ ግድና ዎይ ህንተ ግዶን ደእያ ሀራ ቢታ አሳፐ ኦንነ ሀዋ ማላ ቱና ኦሱዋ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","“ ‘ህንተፐ ካሰ ሀ ጋድያን ደኤዳ አሳቱ ሀዋ ማላ ቱናባ ኦꬄዳ ድራዉ፥ ቢታይ ቱኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ህንተ ሀ ቢታ ቱንሶፐ፥ ህንተፐ ካሰ ደኤዳ ካዉተꬃቱዋ ሀ ቢታይ ጩቼዳዋዳን፥ ህንተናካ ጩቼናዳን ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ሄዋንታ ማላትያ ቱና ኦሶቱዋፐ እቱዋነ ኦꬅያ አሳይ ደኦፐ፥ ሄ አሳይ ባረ አሳ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“ ‘ሄዋ ድራዉ ህንተፐ ካሰ ደኤዳ አሳቱ ኦꬄዳ ቱና ኦሶቱዋ ኡባ ኦꬂደ ህንተ ቱነናዳን፥ ህንተ ታ አዛዙዋ ናግተ፤ ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“እስራኤልያ አሳዉ ኡባዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳይ ጌሻ ግድያ ድራዉ፥ ህንተካ ጌሻ ግድተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘ህንተፐ እቱነ አተናን ባረ አባነ ባረ ዳዮ ቦንቾ፤ ታ ሳምባታቱዋካ ቦንችተ። ታን፥ ጾሳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘ታና አጊደ ኤቃቶ ጎይኖፕተ፤ ዎይ ቃይ ብራታፐ ሲልሴዳ፥ ጾሳቱዋ ህንተንቶ መꬎፕተ። ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘ህንተ እትፐተꬃ ያርሹዋ መꬍና ጎዳዉ ያርሽያ ዎደ፥ ሄ ያርሹ ህንተ ድራዉ አከታናዳን፥ በስያዋዳን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ሄ ያርሹ ህንተ ያርሼዳ ጋላሳን ዎይ ዎንተꬃ ጋላሳን ሜተቶ፤ ሄዘንꬆ ጋላሳይ ጋካናዉ አቴዳዌ ደኦፐ ሄዌ ጹገቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ሄዛንꬆ ጋላሳን አ ሞፐ፥ ሄዌ ሸነይያባ፤ ታን ሄዋ አክከ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ሄዋ ምያ ኦንነ ባረ ናጋራን ኦሸቴ፤ አያዉ ጎፐ፥ እ መꬍና ጎዳዉ ጌሻ ግዴዳዋ ቱንሴዳ። ሄ አሳይ ባረ አሳ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘ህንተ ጋድያን ሞኬዳ ካꬃ ህንተ ጫክያ ዎደ፥ ጋድያ ጋጻ ጋካናዉ ጫኮፕተ፤ ቃይ ጫካፐ ስምና ደእያ ቃርምያካ ቃርሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ነ ዎይንያ አይፍያ ሙለ ማጻደ ምꬃ ካሎዮፓ፤ ሳኣን ዎꬌዳ ዎይንያ አይፍያካ ማጾፓ፤ ሄዋ ህዬሳቶነ በተቶ አጋ። ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘ህንተ ዉኦፕተ። “ ‘ዎርዶቶፕተ። “ ‘እቱ እቱዋ ጭሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘ታ ሱንꬃን ዎርዱዋን ጫቆፕተ፤ ያቲደ ህንተ ጾሳ ሱንꬃ ቱንሶፕተ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘ነ ሾሩዋ ሱጎፓ፤ ዎይ ቦንቆፓ። “ ‘ከራ ኦꬅያ ብታንያ ድርጉዋ ድጋደ፥ እት ቃማነ ነ ማታን አይሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘ቱልያ ሸቆፓ፤ ዎይ ቃይ ቆቅያ ስንꬃን ꬉቢያዋ ዎꬆፓ፤ ሽን ኔን ጾሳዉ ያያ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘ፕርዳ ፕርዳደ ደሽሶፓ፤ ህዬሳ አ ህዬሳተꬃ ድራዉ ማዳደ ፕርዶፓ፤ ዱርያካ አ ዱረተꬃ ድራዉ ያያደ አጎፓ። ሽን ነ ሾሮ ቱማተꬃን ፕርዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘ነ አሳ ግዶን ኢታ ዝግርሳ አካደ ዩዮፓ። “ ‘ነ ሾሩዋ ዎꬍያዋ አያነ ኦꬆፓ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘ነ እሻ ነ ዎዛናን እጾፓ። “ ‘ነ ሾሩዋ ጋሱዋን ኔን ናጋራ ኦና ማላ፥ አ ሴራ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘ኩሽያ ጭጎፓ፤ ቃይ ነ አሳፐ እቶነ ኡሉዋን ቅምያ ኦይቆፓ። ሽን ነ ሾሩዋ ነ ሁጲያዳን ሲቃ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘ታ አዛዞቱዋ ናጋ። “ ‘ነ መህያፐ እት ቆሞ መህያ ሀራ ቆሞ ዱማ መህያን ብራስሶፓ። “ ‘እት ሾይቃን ላኡ ቆሞ ዘረꬃ ዘሮፓ። “ ‘ቃይ ላኡ ቆሙዋፐ ዳደቴዳ ማዩዋ ማዮፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘እት አሳይ ሀራ አሳ ገላናዉ ጊጋ ኡቴዳ ዳንጋጽራትና ግሶፐ፥ ቃይ ሄ ዳንጋጽራታካ ባረ ዳንጋጽረተꬃፐ ዎዘታቤናኖ ግዶፐ፥ ኡንቱንቱ ሙረታናዉ በሴ፤ ሽን እዛ ባረ ዳንጋጽረተꬃፐ ዎዘታቤና ድራዉ፥ ኡንቱንታ ዎꬋናዉ ኮሸና። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ግዶፐነ ሄ ብታኒ ባረ ናቁዋ ያርሾ ግድያ ዶርሳ ኦርግያ ጾሳ ዱንካንያኮ መꬍና ጎዳ ስንꬃ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ቄሲ ሄ ናቁዋ ያርሹዋ ዶርሳ አኪደ፥ ብታኒ ኦꬄዳ ናጋራ መꬍና ጎዳ ስንꬃን አቶ ጊሴ፤ እ ኦꬄዳ ናጋራይካ አቶ ጌተታና። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘ህንተ ካናነ ቢታ ገልያ ዎደ፥ አይፍያ ምያ አይ ቆሞ ምꬃ ቶኮፐካ፥ ሄ ምꬃ አይፍያ ሜተተናዋዳን ፓይድተ፤ ሄዙ ላይꬃይ ዉራናዉ ሄ ምꬃ አይፊ ሜተተና፤ አ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ኦይደንꬆ ላይꬃን ሄ ምꬃ አይፊ ኡባይ መꬍና ጎዳዉ ጋላታ ሺሽያ ጌሻ ያርሹዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ሽን ሄ ምꬃ አይፊ ህንተንቶ ሎይꬅ ዳራና ማላ፥ እቼሸንꬆ ላይꬃ አይፍያ ሚተ። ህንተ ሀዋዳን ኦꬆፐ፥ ህንተ ምꬃ አይፊ ዳራና። ታን መꬍና ጎዳይ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘ሱꬃይ አ ግዶን ደእያ አይ አሹዋካ ሞፕተ። “ ‘ካዮፕተ ዎይ ሻሬቾፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘ህንተ ሁጲያ ብናና ጋርሳና ዩሽ አꬂደ ቃንጾፕተ፤ ቃይ ህንተ ቡቻካ ዩሽ አꬂደ ቃንጾፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘ሀይቄዳ አሳ ድራዉ ህንተ ቦላ ቃንጸሬꬆፕተ፤ ዎይ ጫቻ ማላታ ህንተ ቦላን ከሶፕተ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘ቢታይ ዎዳላ ቱናተꬃን ኩሜዳዋ ግደና ማላ፥ ነ ናቶ ሻርሙጻ ኦሶ አꬃ እማደ ቱንሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘ታ ሳምባታቱዋ ቦንችተ፤ ታዉ ጎይንያ ሳኣካ ቦንችተ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘ሞይትልያ ሃሳይስያዋንቱኮነ ሻሬቾቱዋኮ ቦፕተ፤ ህንተ ቱነና ማላ ኡንቱንታ ኮዮፕተ። ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘ፑሉሜዳ አሳነ ጭሜዳ አሳ በእያ ዎደ ኡቴዳ ሳኣፐ ደንዳ ኤቃ፤ ኡንቱንታ ቦንቻ፤ ነ ጾሳዉ ያያ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘ህንተ ጋድያን ህንተናና ደእያ በተቱዋ ቦላን ሱገꬃባ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ህንተ ጋድያን ህንተናና ደእያ በተ አሳ ህንተ ቢታ አሳዳን ጼልተ፤ አ ህንተ ሁጲያዳን ሲቅተ። አያዉ ጎፐ፥ ህንተካ ካሰ ግብጼ ጋድያን በተ ግዲደ ደኤድታ። ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘ህንተ ጌሳ ልክያባን፥ ሚዛናን ዎꬂደ ልክያባንነ ማክያባን ዎርዶቶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ህንተ ኪሉዋ ሚዛናይ፥ ህንተ ማክያባይነ ልክያ ሚሻቱ ኡባይ ልከ ግድኖ። ታን ህንተና ግብጼ ጋድያፐ ከሳደ አሄዳ መꬍና ጎዳ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ህንተ ታ ህግያነ ታ አዛዙዋ ኡባ ናግተነ ኦꬅተ። ታን መꬍና ጎዳ ያጋ’ ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፥ ‘እስራኤልያ አሳፐ ግድና፥ ዎይ በቲደ ዪደ እስራኤልያ ግዶን ደእያ ሀራ ቢታ አሳፐ ግድናካ፥ ኦንነ ባረ ናናቱዋፐ እቱዋ ሞሎካ ግያ ኤቃዉ አꬂደ እሞፐ፥ ሄ አሳይ ሀይቆ፤ ሄ ቢታ አሳይ አ ሹቻን ጫዲደ ዎꬎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ታን ሄ ብታንያ እጻና፤ አ አሳ ግዶፐ ሾዳደ አ ꬋይሳና። አያዉ ጎፐ፥ እ ባረ ናናቱዋፐ እቱዋ ሞሎካ ግያ ኤቃዉ እምያዋን፥ ታ ዱንካንያ ቱንሴዳ፤ ታ ጌሻ ሱንꬃካ ካዉሽሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ሄ ብታኒ ባረ ናናቱዋፐ እቱዋ ሞሎካዉ እምያ ዎደ፥ ሄ ቢታ አሳይ በኢደ፥ ሸነኮ ጎፐ፥ ቃይ ብታንያካ ዎናን አጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ታን ታ ሁጲያዉ ሄ ብታንያነ ሄ ሶ አሳ እጻና፤ ሞሎከና ሻርሙጻናዉ አ ካልያ ኡባቱዋ ኡንቱንቱ አሳ ግዶፐ ቦህተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘አይ አሳይነ ታናን አማነተናን እጺደ፥ ሞይትልያ ሃሳይስያዋንታነ ሻሬቾቱዋ ኦቻናዉ ቦፐ፥ ታን አ እጻና፤ አ አሳ ግዶፐካ ꬋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ ግድያ ድራዉ፥ ስም ህንተ ህንተና ዱማይተ፤ ቃይ ጌሻ ግድተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ታ ህግያ ናግተነ ኦꬅተ። ታን ህንተና ጌሽያ መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘አይ አሳይነ ባረ አዉዋ ዎይ ባረ ዳዮ ሸቆፐ ሀይቆ። እ ባረ አዉዋ ዎይ ባረ ዳዮ ሸቄዳ ድራዉ፥ አ ሱꬃ አጩ አ ቦላና። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘እት አሳይ ባረ ሾሩዋ ማቻትና ግሶፐ፥ ሄ ግሴዳ ብታኒነ ምሽርታ ላኡካ ሀይቂኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ባረ አዉዋ ማቻትና ግሴዳ አሳይ ባረ አዉዋ ካዉሽሴዳ፤ ኡንቱንቱ ላኡካ ሀይቂኖ። ኡንቱንቱ ሱꬃ አጩ ኡንቱንቱ ቦላና። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","እት አሳይ ባረ ናኣ ማቻትና ግሶፐ፥ ኡንቱንቱ ላኡካ ሀይቂኖ። ኡንቱንቱ ቱናባ ኦꬄድኖ። ኡንቱንቱ ሱꬃ አጩ ኡንቱንቱ ቦላና። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘እት አቱማ አሳይ ማጫ አሳና ግስያዋዳን አቱማ አሳና ግሶፐ፥ ኡንቱንቱ ላኡካ ቱናባ ኦꬄዳ ድራዉ ሀይቂኖ። ኡንቱንቱ ሱꬃ አጩ ኡንቱንቱ ቦላና። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","እት አሳይ ናቶነ አቶነ እትፐ አክያዋ ግዶፐ፥ ሄዌ ቱናባ፤ ህንተ ግዶን ቱናተꬃይ ደኤና ማላ፥ እነ ኡንቱንቱነ ታማን ጹገትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘እት አሳይ መህያና ግሶፐ፥ እ ሀይቆ፤ ሄ ማጫ መሀቶካ ዎꬍተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","እት ማጫ አስ መህያና ግሶፐ ሄ ምሽራቶነ ሄ መህያ ላኡዋካ ዎꬍተ፤ ኡንቱንቱ ሀይቂኖ። ኡንቱንቱ ሱꬃ አጩ ኡንቱንቱ ቦላና። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘እት አሳይ ባረ ምቻቶ ባረ አዉዋ ናትና ዎይ ባረ ዳይ ናትና ግሶፐ፥ ሄዌ ፖኮባ። ኡንቱንቱ ባረንቱ አሳ ግዶፐ ቦሄትኖ። እ ባረ ምቻቶ ካዉሼዳ ድራዉ፥ እ ባረ ናጋራን ኦሸቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","እት አሳይ ፒላይ ዬዳ ማጫን ካሉዋ ቃሪደ ኢናና ግሶፐ፥ ኡንቱንቱ ላኡካ ባረንቱ አሳ ግዶፐ ቦሄትኖ። አያዉ ጎፐ እ እዝ ሱꬃይ ጎግያ ፑልቱዋ ካሎዬዳ፤ እዛካ ባረ ሱꬃይ ጎግያ ፑልቱዋ ካሎያዱ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘ነ ዳይ ምቻትና ዎይ ነ አዉዋ ምቻትና ግሶፓ፤ አያዉ ጎፐ፥ ሄዋ ኦꬅያዌ ባረ ማታ ዳቡዋ ካዉሽያዋ። ህንተ ላኡካ ህንተ ናጋራን ኦሸታና። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","እት አሳይ ባረ አዉዋ እሻ ማቻትና ግሶፐ፥ እ ባረ አዉዋ እሻ ካዉሽሴዳ። ኡንቱንቱ ባረንቱ ናጋራን ኦሸታና፤ ኡንቱንቱ ላኡካ ናኣ የለናን ሀይቃና። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","እት አሳይ ባረ እሻ ማቻቶ አኮፐ፥ ሄዌ ቱናተꬃ። እ ባረ እሻ ካዉሽሴዳ፤ ኡንቱንቱ ላኡካ ናኣ የልክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘ስም ህንተ ደአናዳን፥ ታን ህንተና ገልስያ ቢታይ ህንተና ጩቼና ማላ፥ ህንተ ታ ህግያነ ታ አዛዙዋ ናግተነ ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ታን ህንተ ስንꬃፐ ꬋይስያ አሳቱዋ ደኡዋ ዎጋ ካሎፕተ። ኡንቱንቱ ሀዋ ኡባ ኦꬄዳ ድራዉ፥ ታን ኡንቱንታ ሸነታድ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ሽን ታን ህንተና፥ “ኡንቱንቱ ቢታ ህንተ ላታና፤ ህንተ ሄ ቢታ ህንተዋ ኦꬃናዳን፥ ሄ ማꬃይነ ኤሳይ ጎግያ ቢታ ታን ህንተንቶ እማና” ያጋድ። ታን ህንተና ሀራ አሳቱዋፐ ዱማያ ከሴዳ መꬍና ጎዳ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘ሄዋ ድራዉ ህንተ ጌሻ ግዴዳ መሄቱዋነ ካፎቱዋ ጌሻ ግደናዋንቱፐ ሻኪደ ኤርተ። ታን ሀዋንቱ ህንተንቶ ቱና ጋ ዎꬄዳ መሄቱዋን፥ ካፎቱዋንነ ሳኣን ቃጸረትያባቱዋን ኡባን ህንተ ሁጲያ ቱንሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ታን መꬍና ጎዳይ ጌሻ ግድያ ድራዉነ ህንተ ታዋ ግዳና ማላ ህንተና ሀራ አሳፐ ዱማዬዳ ድራዉ፥ ህንተካ ታዉ ጌሻ ግድተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘እት አቱማ አሳይ ዎይ ማጫ አሳይ ሞይትልያና ሃሳይያዋ ዎይ ሻሬቾ ግዶፐ፥ ኡንቱንቱ ሀይቃናዉ በሰ። ኡንቱንቱ ሹቻን ጫደትኖ። ኡንቱንቱ ሱꬃ አጩ ኡንቱንቱ ቦላና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፥ “ቄስያ ግድያ አሮና አቱማ ናናቶ ሀዋዳን ያጋደ ኦዳ፤ ‘ህንተፐ ኦንነ ");
INSERT INTO dwrENT_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ባረ ማታ ዳቦ፥ ባረ ዳይ፥ ባረ አዉዋ፥ ባረ አቱማ ናኣ፥ ባረ ማጫ ናት፥ ባረ እሻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ዎይ አስና ገለናን፥ ደእያ ባረ ምቻት አሃ ግዳና ꬋዮፐ፥ ሀይቄዳ አሳ አሃ ኦዋነ ቦቺደ፥ ባረና ቱንሶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ቃይ አኩዋንነ ገሉዋን ዳቦቴዳ አሳ አሃ ቦቺደካ ባረና ቱንሶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘ቄሳቱ ሀይቄዳዎ ካዮታናዉ ባረንቱ ሁጲያ ሜደቶፕኖ፤ ባረንቱ ቡቻካ ቃንꬃን ቃንጾፕኖ፤ ዎይ ቃይ ባረንቱ ቦላካ ቃንጸሬꬆፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ኡንቱንቱ ባረንቱ ጾሳዉ ጌሻ ግድኖ፤ ቃይ ባረንቱ ጾሳ ሱንꬃካ ቱንሶፕኖ። አያዉ ጎፐ ኡንቱንቱ መꬍና ጎዳዉ ታማን ጹጊደ ያርሽያ፥ ቁማ ያርሹዋ ሺሽያዋንታ፤ ሄዋ ድራዉ፥ ኡንቱንቱ ጌሻ ግዳናዉ በሴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘ቃይካ ቄሳቱ ሻርሙጻ ማጫ አሳ፥ ዎዶሮተꬃይ አከት ድጌዳ ማጫ አሳ፥ ዎይ አስናይ የዴዳ ማጫ አሳ አኮፕኖ። አያዉ ጎፐ፥ ቄሳቱ ባረንቱ ጾሳዉ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ቄሲ ህንተ ጾሳዉ ቁማ ያርሹዋ ሺሽያዋ ግድያ ድራዉ፥ እ ሀራ አሳፐ ዱማቶ። ታን ህንተና ጌሽያ ህንተ መꬍና ጎዳይ ጌሻ ግድያ ድራዉ፥ እካ ጌሻ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","አይ ቄስያ ናቶ ግዶፐካ ሻርሙጻደ ባረና ቱንሶፐ፥ ሄና ባረ አዉዋ ካዉሻዱ። እዛ ታማን ጹገታደ ሀይቁ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘ቄስያ ኡባቱዋ ካፑ፥ አ ሁጲያን ኦከትያ ዛይቲ ጉኬዳ ድራዉነ እ ቄሰተꬃ ማዩዋ ማያናዉ ዱማቴዳ አሳ ግድያ ድራዉ፥ ባረ ሁጲያ ብናና ካሎ ዎꬆፖ፤ ዎይ ባረ ማዩዋካ ፔꬎፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","አይ አሃ ግዶፐካ፥ ደእያ ሳኣ እ ገሎፖ፤ ሀራይ አቶ ባረ አዉዋ ዎይ ባረ ዳይ አሃ ግዶፐካ፥ ባረና ሄዋን ቱንሶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","አ ጌሻናዉ ኦክያ ጾሳ ዛይቲ አ ቦላን ደእያ ድራዉ፥ ቄሲ ጾሳ ዱንካንያፐ ከሶፖ፤ ጾሳ ዱንካንያካ ቱንሶፖ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘ቄሲ ዎዶሮ ማጫ ናቶ አኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","አስናይ ሀይቄዳ ምሽራቶ፥ ዎይ አስናይ የዴዳ ምሽራቶ፥ ዎይ ዎሹማ ምሽራቶ አኮፖ። ሽን ባረ አሳ ግዶፐ ዎዶሮ ማጫ ናቶ ዶሪደ አኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ያናና ꬋዮፐ፥ እ ባረ አሳ ግዶን ባረ ዘረꬃ ግድያ ባረ ናናቱዋ ቱንሳና። ታን አ ጌሽያዌ፥ መꬍና ጎዳ ያጋ’ ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","መꬍና ጎዳይ ሙሳ፥ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ኔን አሮናዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ስንꬃና ይያ ነ ዘረꬃፐ ቦላይ ትላ ግደና አሳይ ኦንነ ቁማ ያርሹዋ ታዉ እማናዉ ሺቆፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","አያዉ ጎፐ ቦላይ ትላ ግደና አሳይ ኦንነ ሺቃናዉ በሰና። ቆቃ፥ ዎይ ዎባ፥ ዎይ ደሙ ናርጰቴዳ፥ ዎይ ፓጫ ቦላይ ደእያ አሳይ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ዎይ ገድያ ዎይ ኩሽያ ስላይ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ዎይ ቁናይ፥ ዎይ ድንኪ፥ ዎይ አይፊ ሳክያ አሳይ፥ ዎይ ፑሱ ኦይቄዳ አሳይ፥ ዎይ እላሁ ኦይቄዳ አሳይ፥ ዎይ ጎይሮ ግድናካ ቦላይ ትላ ግደና አሳይ፥ ኦንነ ሺቆፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ቄስያ አሮና ዛርያፐ ቦላይ ትላ ግደና አሳይ ኦንነ መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋ ሺሻናዉ ሺቆፖ። አዉ ቦላይ ትላ ግደናዋ ግዶዋፐ ህን ባጋን፥ ባረ ጾሳዉ ቁማ ያርሹዋ ሺሻናዉ እ በሰና። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","እ ጌሻ ቁማነ ቃይ ጌሻ ኡባፐ እቱዋ ግዴዳ ጌሻ ያርሹዋ ባረ ጾሳ ቁማካ ማናዉ ዳንዳዬ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ሽን አዉ ቦላይ ትላ ግደና ድራዉ፥ እ ታ ዱንካንያ ቱንሰናዳን፥ ጋርዱዋኮ ዎይ ያርሽያ ሳኣኮ ሺቆፖ። አያዉ ጎፐ፥ ኡንቱንታ ጌሽያዌ ታን መꬍና ጎዳ ያጋ’ ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ሙሴ አሮናዉ፥ አ አቱማ ናናዉነ እስራኤልያ አሳዉ ኡባዉ ሀዋ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ታ ጌሻ ሱንꬃ ኡንቱንቱ ቱንሰና ማላ፥ እስራኤልያ አሳይ ታዉ ዱማዬዳ እሞታ አሮንነ አ አቱማ ናናይ ቦንቹዋን አኪደ፥ ጌሻተꬃን ናጋና ማላ፥ ኡንቱንቶ ኦዳ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“ኡንቱንቶ ሀዋዳን ያጋ፤ ‘ስንꬃና ይያ የለታ ኡባን ህንተ ዛርያፐ ኦንነ ቱን ኡቲደ፥ እስራኤልያ አሳይ መꬍና ጎዳዉ ዱማዬዳ ጌሻ ያርሹዋኮ ሺቆፐ፥ ሄ አሳይ ታ ስንꬃፐ ቦሄቶ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘አሮና ዛርያፐ ዎልቃማ ጋልባ ሀርጊ ደእያ፥ ዎይ ቦላፐ አያይኔካ ጎግያ ኦንነ ጌያና ጋካናዉ፥ ጌሻ ያርሹዋፐ ሞፖ። አሃ ቦቺደ ቱኔዳዋ ዎይ አ አቱማተꬃፐ ዘረꬃይ ጉኬዳ ኡራ ቦችያ ኦንነ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ዎይ ቃይ ሳኣና ጎሸትያ፥ ቱንስያዋንታ፥ ዎይ አይ ማላ ቱናተꬃ ግዶፐነ ቱንስያ አሳ ቦችያ ኡራይ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ዎይ ሄዋ ማላባ አያነ ቦችያ አሳይ፥ ኦማርስ ጋካናዉ እ ቱና፤ ባረ ቦላ ሃꬃን ሜጨተናን ደኢደ፥ ሄ ጌሻ ያርሹዋፐ እ ማናዉ ኮሸና። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","አዋይ ዉልያ ዎደ እ ጌሻ ግዴ፤ ሄዋፐ ጉይያን፥ ሄ ጌሻ ያርሹዋፐ ባረና ጋክያዋ ሞ ጋሱካ ሄዌ አ ቁማ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ባረዉ ሀይቄዳዋ ዎይ ዶአይ ዎꬌዳ መህያ አሹዋ ሞፖ፤ ሄዌ ቱንስያባ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘ቄሳቱ ታ ዎጋ፤ ናገናን እጾፐ፥ ኡንቱንቱ አ ቱንሲደ አ ናጋራን ሀይቃና። ኡንቱንታ ጌሽያዌ ታና መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘ሄ ጌሻ ያርሹዋ ቄስያ ሶ አሳፐ አትና፥ ሀራ አሳይ ሞፖ፤ ቄስያ ሶ ዬዳ እማꬃ ግድና፥ ዎይ ቃጻረቲደ ኦꬅያ ቆማ ግድናካ ሞፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ሽን ቄሲ ባረ ብራን ሻሜዳ አይልያ ዎይ አ ሶን የለቴዳ አይሊ ሄ ቁማፐ ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ቄስያ ግደና ሀራ አሳ ገሌዳ ቄስያ ናታ ሄ ጌሻ ያርሹዋፐ ሙፑ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ሽን ቄስያ ናታ አስናይ ሀይቂና፥ ዎይ አስናይ የድና፥ ናኣ የለናን ካሰ ባረ ዎዶሮተꬃን ደእያዋዳን ስማደ ባረ አዉዋ ጎለ ዮፐ፥ አ ባረ አዉዋ ጋክያ ቁማፐ ሙ። ሽን ሀራ አሳይ ኦንነ ሄዋፐ ሞፖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘እት አሳይ ኤረናን ደኢደ ጌሻ ያርሹዋፐ ሞፐ፥ ሄ እ ሜዳ ቁማ ጋትያ ቦላ ጼቱዋፐ ላታሙ ኩሽያ ጉጂደ ቄስያዉ እሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","እስራኤልያ አሳይ መꬍና ጎዳዉ ያርሽያ ጌሻ ያርሹዋ ቄሳቱ ቱንሶፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ኡንቱንቱ ባረንቱ አሄዳ ጌሻ ያርሹዋ ባረዉ ሚደ፥ ባረንቱ ናጋራን ኦሸታናዳን፥ ቄሳቱ ኦꬃናዉ ኮሸና። አያዉ ጎፐ፥ ኡንቱንታ ጌሽያዌ፥ ታን መꬍና ጎዳ ያጋ’ ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“አሮናዉ፥ አ ናናቶነ እስራኤልያ አሳ ኡባዉ ሀዋዳን ያጋደ ኦዳ፤ ‘እስራኤልያ አሳፐ ግድና ዎይ ኡንቱንቱ ግዶን ደእያ በትያፐ ኦንነ መꬍና ጎዳዉ ጹግያ ያርሹዋ ባረ ዶሱዋን ጮ እምያ ዎይ ባረ ሺቆዋ ጋꬃናዉ ያርሽያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ሄ ያርሹ አከታና ማላ፥ ኮሩማፐ ዎይ ዶርሳፐ ዎይ ዴሻፐ ትላ ቦላና ደእያ አቱማዋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ቦላይ ትላ ግደናዌ አያ ግዶፐነ አከተና ድራዉ፥ ሄዋ ሺሾፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“ ‘ቃይ ኦና ግዶፐነ ባረ ሺቆዋ ጋꬃናዉ እትፐተꬃ ያርሹዋ ጾሳዉ ያርሽያ ዎደ፥ ዎይ ባረ መህያፐ ባረ ዶሱዋን ጮ እምያ እሞታ መꬍና ጎዳዉ ሺሽያ ዎደ፥ ሄዌ አከታና ማላ እ ትላ ቦላና ደእያዋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ህንተ መህያፐ ቆቅያ፥ ዎይ መኡዋ፥ ዎይ ጉንዳ፥ ዎይ ጊይያ ማይꬃይ፥ ዎይ ፑሱ፥ ዎይ እላሁ ደእያዋ መꬍና ጎዳዉ ያርሾፕተ፤ ቃይ ታማን ጹግያ ያርሹዋ ኦꬂደካ ያርሽያ ሳኣ ቦላን መꬍና ጎዳዉ ሺሾፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","አ ቦላን ፓጫ መታይ ዎይ ፓጫባይ ደእያ ኮሩማ ዎይ ዶርሳ እት አሳይ ባረ ዶሱዋን ጮ እምያ ያርሾ ሺሻናዉ ዳንዳዬ፤ ሽን ሺቁ ጋꬆ ግዶፐ፥ ሄዌ አከተና። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ሳንግሰቴዳዋ ዎይ ቆጸቴዳዋ ዎይ ካꬃይ ማይቴዳዋ ዎይ ቃንጸቴዳዋ መꬍና ጎዳዉ ያርሾፕተ። ህንተ ጋድያን ሄዋ ማላባ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ህንተ ግዶን ደእያ አላጋ አሳቱዋፐ አኬዳ ሄዋ ማላ መህያካ ህንተ ጾሳዉ ቁማ ኦꬂደ ሺሾፕተ። ኡንቱንቱ ቦላይ ትላ ግደናዋ ጋሱዋን ኡንቱንቱን ፖኩ ደእያ ድራዉ፥ ኡንቱንቱ ህንተ ድራዉ አከትክኖ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ቃይካ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ሚዛ ማራይ ዎይ ዶርሳ ማራይ ዎይ ዴሻ ማራይ የለትያ ዎደ፥ ላፑን ጋላሳ ባረ ዳይና ጋምኦ። ሆስፑንꬃ ጋላሳፐ ዶሚደ፥ መꬍና ጎዳዉ ታማን ጹጊደ ሺሽያ ያርሾ ኦꬂደ ሺሻናዉ ዳንዳየቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ምያቶ፥ ዶርሳቶ፥ ዎይ ዴሻቶ እ ማራና እት ጋላስ ሹኮፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“ህንተ ጋላታ ያርሹዋ መꬍና ጎዳዉ ሺሽያ ዎደ፥ ህንተ ያርሹ አከታናዳን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ሄ ያርሹ ሄ ጋላስካ ሜተታናዉ ኮሼ፤ አፐ አያነ ዎንትዉ አሾፕተ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“ታ አዛዙዋ ናግተነ ኦꬅተ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ቃይ ታ ጌሻ ሱንꬃ ህንተ ቱንሶፕተ፤ እስራኤልያ አሳ ግዶን ታን ጌሻ ግድያዌ ኤረታናዉ በሴ። ህንተና ጌሽያዌ፥ ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ህንተዉ ጾሳ ግዳናዉ፥ ህንተና ግብጼ ጋድያፐ ከሴዳዌ ታና። ታን መꬍና ጎዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ጌሻ ሺቁዋ ግ አዋዪደ፥ ህንተ ቦንቻናዉ በስያ ኬረቴዳ መꬍና ጎዳ ባላቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘ህንተ ኡሱፑን ጋላሳ ኦሱዋ ኦꬂታ፤ ሽን ላፑንꬃ ጋላስ ህንተ ሸምፕያ ሳምባታ ጋላሳ፤ ሄ ጋላሳን ጌሻ ሺቁዋ ሺቅተ፤ አያ ኦሶነ ኦꬆፕተ፤ ህንተ ደእያ ሳኣን ኡባን ሄዌ መꬍና ጎዳዉ ሳምባታ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘ኡንቱንቱ ዎድያን ዎድያን ጌሻ ሺቁዋ ኦꬅ አዋዪደ ህንተ ቦንቻናዉ በስያ መꬍና ጎዳ ባላቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ኮይሮ አግናን ታማነ ኦይደንꬆ ጋላስ ሳአይ ኦማርስያ ዎደ፥ መꬍና ጎዳ ፓስጋይ ዶሜ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“ ‘ቃይ ሄ አግናንካ ታማነ እቼሸንꬆ ጋላሳይ መꬍና ጎዳ ማጋገ ኡክꬃ ባላ ጋላሳ፤ ሄዋ ድራዉ ላፑን ጋላሳቱዋን እርሹ ገልቤና ኡክꬃ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ሄ ጋላሳቱዋፐ ኮይሮ ጋላሳን ጌሻ ሺቁዋ ሺቅተ፤ ዳቡርስያ ኦሱዋ አያነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ላፑን ጋላሳ ኡባ መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋ ሺሽተ፤ ላፑንꬃ ጋላሳን ቃይ ጌሻ ሺቁዋ ሺቅተ፤ ዳቡርስያ ኦሱዋ አያነ ኦꬆፕተ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ታን ህንተንቶ እምያ ቢታ ገሊደ፥ ህንተ ካꬃ ጫክያ ዎደ፥ ሄ ካꬃዉ ኮይሮ አይፍያ ምርቂያ ቄስያኮ አክ ዪተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","መꬍና ጎዳይ ህንተዋ አካና ማላ፥ ሳምባታ ዎንተꬃ ጋላስ ቄሲ ሄ ምርቂያ ጾሳ ስንꬃን ቃꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ሄ ህንተ ምርቂያ ቃꬄዳ ጋላስ ትላ ቦላና ደእያ እት ላይꬃ ዶርሳ ኦርግያ ጹግያ ያርሹዋ ኦꬂደ መꬍና ጎዳዉ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ሄ ያርሹዋና እትፐ ዎጋራ ዛይትያን ሙናቀቴዳ ላኡ ኪሎ ግራመ ሎኦ ꬊልያ ካꬃ ያርሹዋ ኦꬂደ ሺሽተ፤ ሄዌ መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ግዳናዋ፤ ሄዋናካ ቃይ እትፐ እት ሊትሮ ግድያ ዎይንያ ኤሳ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ሀ ያርሹዋ ህንተ ህንተ ጾሳዉ ሺሽያ ጋላሳይ ጋካናዉ፥ ኦራꬃ ጋኬዳ ካꬃፐ ኡክꬃ፥ ዎይ ጺጻ ግድና፥ ቃይያ ግድናካ ሞፕተ። ሀዌ ህንተ ደእያ ሳኣን ኡባን ስንꬃና ይያ የለታዉ ኡባዉ መꬍናዉ ዎጋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘ህንተ ቃꬅያ ያርሹዋ ምርቂያ አሄዳ ሳምባታ ዎንተꬃፐ ዶሚደ፥ ላፑን ሳምንታ ኩመንꬃ ፓይድተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ላፑንꬃ ሳምባታ ዎንተꬃ ጋላሳይ ጋካናዉ፥ እሻታሙ ጋላሳ ፓይዲደ፥ ኦራꬃ ጋኬዳ ካꬃ ያርሹዋ መꬍና ጎዳዉ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ህንተ አቅያ ሳኣፐ ላኡ ኪሎ ግራመ ግድያ ሎኦ ꬊልያፐ እርሹዋ የጊደ ኡኬዳ ላኡ ኡክꬃ ቃꬃናዉ አክ ዪተ። ሄዌ ኮይሮ ጋኬዳ ካꬃ አይፍያፐ መꬍና ጎዳዉ ያርሹዋ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ሄ ኡክꬃና እትፐ ትላ ቦላና ደእያ እት ላይꬃ ግዴዳ ላፑን ዶርሳ ማራቱዋ፥ እት ኮሩማነ ላኡ ዶርሳ ኦርገቱዋ ሺሽተ። ካꬃ ያርሹዋናነ ኡሻ ያርሹዋና እትፐ መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ኦꬂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ቃይ እት ዴሻ ኦርግያ ናጋራ ያርሾ፥ እት ላይꬃ ግዴዳ ላኡ ዶርሳ ኦርገቱዋካ እትፐተꬃ ያርሾ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“ ‘ቄሲ ሄ ኮይሮ ጋኬዳ ካꬃ አይፍያ ኡክꬃነ ሄ ላኡ ዶርሳቱዋ ቃꬅያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳ ስንꬃን ቃꬄ፤ ሄዋንቱ መꬍና ጎዳዉ ጌሻ፤ ቃይ ቄስያዉካ ግሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ሄ ጋላስካ አዋዪደ ጌሻ ሺቁዋ ሺቅተ፤ ዳቡርስያ ኦሶ አያነ ኦꬆፕተ። ሀዌ ህንተ ደእያ ሳን ኡባን ስንꬃና ይያ የለታዉ ኡባዉ መꬍናዉ ዎጋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘ህንተ ጋድያን ሞኬዳ ካꬃ ህንተ ጫክያ ዎደ፥ ህንተ ሾይቃ ጋጻ ጋካናዉ ጫኮፕተ፤ ጫክሽን አትያ ቃርምያካ ቆሮፕተ፤ ሄዋ ህዬሳቶነ በተቶ አግ ባሽተ። ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ላፑንꬃ አግናን ኮይሮ ጋላሳ ሸምፖ ጋላሳ ኦꬂደ ቦንችተ፤ ሀሳይሱዋ ማላካታይካ ፑነትያ ዎደ፥ ጌሻ ሺቁዋ ሺቅተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ሄ ጋላሳን መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋ ሺሽተፐ አትና፥ ዳቡርስያ ኦሱዋ አያነ ኦꬆፕተ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ሀ ላፑንꬃ አግናዉ ታማንꬃ ጋላሳይ ናጋራ አቶ ጊስያ ጋላሳ፤ ሄ ጋላስ ጌሻ ሺቁዋ ሺቅተ፤ ቃይ ህንተ ሁጲያ ካዉሽተ፤ ያቲደ መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ሄ ጋላሳይ መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ህንተ ናጋራይ አቶ ጌተታና ማላ፥ ህንተ ናጋራ አቶ ጊስያ ጋላሳ ግድያ ድራዉ፥ ሄ ጋላስ አይ ኦሱዋነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ሄ ጋላስ ባረናተꬃ ካዉሸና አሳይ ኦንነ ባረ አሳ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ሄ ጋላስ አያ ኦሱዋ ግዶፐነ ኦꬅያ አሳ ታን አ አሳ ግዶፐ ꬋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ሄ ጋላስ አይ ኦሱዋነ ኦꬆፕተ። ሀዌ ህንተ ደእያ ሳን ኡባን ስንꬃና ይያ የለታዉ ኡባዉ መꬍናዉ ዎጋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ሄዌ ህንተ ዋና ሸምፑዋ ሸምፕያ ሳምባታ ጋላሳ። ሄ ጋላሳን ህንተ ሁጲያ ካዉሽተ። ሄ አግናን ኡዱፑንꬃ ጋላሳን ኦማርሳፐ ዶሚደ፥ ታማንꬃ ጋላሳ ኦማርሳይ ጋካናዉ፥ ህንተ ሳምባታ ቦንችተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ሀ ላፑንꬃ አግናን ታማነ እቼሸንꬆ ጋላሳፐ ዶሚደ፥ ላፑን ጋላሳይ መꬍና ጎዳዉ ዳስያ ባላ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ሄ ጋላሳቱዋፐ ኮይሮ ጋላሳን ጌሻ ሺቁዋ ሺቅተ፤ ዳቡርስያ ኦሱዋ አያነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ላፑን ጋላሳን ኡባን መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋ ሺሽተ፤ ሆስፑንꬃ ጋላሳን ቃይ ጌሻ ሺቁዋ ሺቅተ፤ መꬍና ጎዳዉ ታማን ያርሽያ ያርሹዋካ ሺሽተ። ሄ ጋላሳይ ህንተ ሺቁዋ ፖልያ ጋላሳ ግድያ ድራዉ፥ ዳቡርስያ ኦሱዋ አያነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘ታማን ጹግያ ያርሹዋነ ካꬃ ያርሹዋ፥ ቃይ ሀራ ያርሾቱዋ ኡባነ ኡሻ ያርሹዋ፥ ኮሽያዋ ኬና ኬሬዳ ጋላሳን መꬍና ጎዳዉ ሺሻናዉ፥ ህንተ ጌሻ ሺቁዋ ኦꬂደ አዋያና መꬍና ጎዳ ባላቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ሀ ባላቱ መꬍና ጎዳ ሳምባታቱዋፐ፥ ህንተ እሞታ ኦꬂደ መꬍና ጎዳዉ እምያዋንቱፐ፥ ሺቁዋ ጋꬅያዋንቱፐነ ህንተ ህንተ ዶሱዋን ጮ እምያዉንቱፐ ዱማ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘ላፑንꬃ አግናን ታማነ እቼሸንꬆ ጋላሳን ህንተ ጋድያን ሞኬዳዋ ጫኪደ ሺሼዳዋፐ ጉይያን፥ መꬍና ጎዳ ባላ ላፑን ጋላሳ ቦንችተ፤ ኮይሮ ጋላሳይነ ሆስፑንꬃ ጋላሳይ ህንተንቶ ዋና ሸምፖ ጋላሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ኮይሮ ጋላሳን ሎኦ ምꬃ አይፍያፐ፥ ዛምባ ታሽያፐ፥ እርጻ ሀይꬃና ደእያ ምꬃ ታሽያፐነ ሻፋ ማታን ድጭያ ሌኦ ታሽያፐ አኪደ፥ መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ናሸቲደ፥ ላፑን ጋላሳ ባላ ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ሄ ባላ ላይꬃን ላይꬃን ላፑን ጋላሳ መꬍና ጎዳዉ ቦንችተ። ሄዌ ስንꬃና ይያ የለታዉ ኡባዉ መꬍናዉ ዎጋ። ህንተ ሄዋ ላፑንꬃ አግናን ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ሄ ላፑን ጋላሳ ህንተ ዳስያን ደእተ፤ እስራኤልያ ቢታ አሳ ግድያ ኡባይ ዳስያን ደእተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ሄዌ ስንꬃና ይያ የለታይ ኡባይ እስራኤልያ አሳ ታን ግብጼፐ ከሴዳ ዎደ፥ ኡንቱንቱ ዳስያን ደአናዳን ኦꬄዳዋ ኤራናሳ። ታን መꬍና ጎዳ ህንተ ጾሳ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ሄዋዳን ኦꬂደ፥ ሙሴ መꬍና ጎዳ ባላቱዋ ቦንችያ ዎጋ እስራኤልያ አሳዉ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ጾምፒ ቶኤናን ኤጺደ ደአና ማላ፥ አሳይ ኮሽያ ዛይትያ ዎጋራ ቴራ ጫዲደ ጉምእና ከስያ ጌሻ ነዉ አሀና ማላ፥ እስራኤላቱዋ አዛዛ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","መꬍና ጎዳ ዱንካንያ ግዶን ደእያ ማርካተꬃ ጋርዱዋፐ ካረ ባጋና፥ ኦማርሳፐ ዎንታ ጋካናዉ፥ አሮን መꬍና ጎዳ ስንꬃን ሄ ጾምፕያ ኡባ ዎደ ኤꬆ። ስንꬃና ይያ የለታዉ ኡባዉ ሄዌ መꬍናዉ ዎጋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ጾምፕያ ዎꬅያ፥ ዋላካይ ባይና ዎርቃ ባላ ቦላ ደእያ ጾምፐቱ መꬍና ጎዳ ስንꬃን ኡባ ዎደ ኤጻናዳን አሮን ናጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“ላታማነ ኦይዱ ኪሎ ግራመ ግድያ ሊቆ ꬊልያ አካደ ታማነ ላኡ ኡክꬃ ኡካ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ሄ ኡክꬃቱዋ ኡሱፑናቱዋ እቱዋ እቱዋ ቦላ ኡሱፑናቱዋ እቱዋ እቱዋ ቦላን መꬍና ጎዳ ስንꬃን ደእያ ዋላካይ ባይና ዎርቃ ጻራጴዛ ቦላን ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","መꬍና ጎዳዉ ታማን ጹጋናዉ ሺሼዳ ቁማ ያርሹዋ ግድያዋ ኤርሳናዉ፥ ላኡ ማራቱዋ ማታን ማታን ጌሻ እጻና ሀሳይስያዋ ኦꬃደ ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ሀ ኡክꬃ ሳምባታን ሳምባታን ኡባ ዎደ አሮን መꬍና ጎዳ ስንꬃን እስራኤልያ አሳ ድራዉ ዎꬆ። ሄዌ እስራኤልያ አሳይ ኡባ ዎደ ኦꬃናዉ ኮሽያ ቃላ ጫቁዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ሄዌ አሮናዉነ አ አቱማ ናናቶ እመቶ፤ እ መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋፐ ዎጋዳን አሮናነ አ ናናቱዋ ጋክያ ኡባፐ ጌሻ ግዴዳ ያርሹዋፐ እቱዋ ግድያ ጌሻ ያርሹዋ ግድያ ድራዉ፥ ኡንቱንቱ ሄዋ ጌሻ ሳኣን ሚኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","አታ እስራኤልያ አሳ፥ አዉ ቃይ ግብጼ አሳ ግድያ እት ብታኒ ደኤ። እት ጋላስ እ ሀራ እስራኤልያ አሳ ግድያ እቱዋና ዱንካኔዳ ሳኣን ዋቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ሀ አዉ አታ እስራኤልያ አሳ ግዴዳ ብታኒ ዋታ ግዶን ጾሳ ሱንꬃ ሸቄዳ። ያትና አ ሙሴኮ አሄድኖ። ሄ ብታንያ አታ ዳና ያራ ግድያ ጺብራ ናቶ። እ ሱንꬃይካ ሻሎሚቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ሀ ብታንያ ዋታነንቶ መꬍና ጎዳ ሸኒ ኡንቱንቶ ቆንጫና ጋካናዉ፥ ኡንቱንቱ አ ቃሾ ጎልያን ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ሄ ሸቀዳ ብታንያ ዱንካኔዳ ሳኣፐ ጋጻ ከሳ፤ እ ሸቅሽን ስሴዳ አሳይ ኡባይ ባረንቱ ኩሽያ አ ሁጲያ ቦላን ዎꬅኖ፤ ያቶፐ እስራኤልያ አሳ ማባራይ ኡባይ አ ሹቻን ጫዲደ ዎꬎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ አይ አሳይነ ባረ ጾሳ ሸቆፐ፥ እ ባረ ናጋራን ኦሸቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","መꬍና ጎዳ ሱንꬃ ሸቂያ አሳይ ሀይቆ፤ እስራኤልያ አሳ ማባራይ ኡባይ አ ሹቻን ጫዶ። በቲደ ዬዳዋ ግድና ዎይ ቢታ አሳ ግድናካ መꬍና ጎዳ ሱንꬃ ሸቆፐ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘አሳ ዎꬍያ አሳይ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","አሳ መህያ ዎꬍያ አሳይ ኦንነ ባረ ዎꬌዳ መህያ ድራዉ ፓጻ መህያ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","እት አሳይ ባረ ሾሩዋ ቆሆፐ፥ እ ኦꬄዳዋዳን አ ቦላንካ ኦሰቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","መንꬆፐ መኦ፤ አይፍያ ድራዉ አይፍያ፤ አቻ ድራዉ አቻ። አሳ ቦላን ቆሁዋ ጋꬄዳ ኦንካ እ ጋꬄዳ ቆሁዋ ማላይ አ ቦላንካ ጋኮ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","መህያ ዎꬌዳ አሳይ መህያ ጭጎ፤ ሽን አሳ ዎꬌዳ አሳይ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","በትያዉካ እስራኤልያ አሳዉ ህጊ እት ማላ ግዶ፤ አያዉ ጎፐ ታን መꬍና ጎዳ ህንተ ጾሳ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ሄዋ ኡባ ሙሴ እስራኤልያ አሳዉ ኡባዉ ኦዴዳ፤ ኡንቱንቱ ሄ ሸቀዳ ብታንያ ዱንካኔዳ ሳኣፐ ጋጻ ከሲደ፥ ሹቻን ጫዲደ ዎꬌድኖ። ያቲደ እስራኤልያ አሳይ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ሲና ደርያ ቦላን መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ኔን እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ታን ህንተንቶ እምያ ቢታ ህንተ ገልያ ዎደ፥ ቢታይካ መꬍና ጎዳ ሳምባታ ቦንቾ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ኡሱፑን ላይꬃ ኩመንꬃ ህንተ ሾይቃን ዘርተ፤ ቃይ ኡሱፑን ላይꬃ ኩመንꬃካ ህንተ ዎይንያ ቱራ ጼራ ጹንቂተ፤ አ አይፍያካ ማጽ አክተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ሽን ላፑንꬃ ላይꬃይ ቢታዉ ሸምፖ ሳምባታ፤ ሄዌ መꬍና ጎዳዉካ ሳምባታ። ሄ ላፑንꬃ ላይꬃን ህንተ ሾይቃን ዘሮፕተ፤ ህንተ ዎይንያ ጼራካ ጹንቆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ህንተ ጋድያን አዛባ ግዲደ ሞክያዋካ ጫኮፕተ፤ ቃይ ጹንቀናን ደእሽን ጮ አይፌዳ ዎይንያካ ሺሾፕተ። ሄ ላይꬃይ ቢታዉ ኡባና ሸምፖ ላይꬃ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","7","ሄ ሳምባታ ላይꬃን ቢታይ ኦሰታና ꬋዮፐ ህንተንቶ፥ ህንተ ማጫነ አቱማ ቆማቶ፥ ህንተንቶ ከራ ኦꬅያዋንቶ፥ በቲደ ዪደ ህንተናና ደእያዋንቶ፥ ህንተ መህያዉነ ህንተ ጋድያን ደእያ ዶአቶ ግድያ ቁማ እማና፤ ቢታይ ሞክያባይ ኡባይ ሜተቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘ላይꬃቱዋ ግዶን ደእያ ላፑን ሳምባታቱዋ ፓይዳ፤ ላፑን ሳምባታቱዋ ላይꬃ ፓይዱ ላፑ ገደ ላፑና፤ ሄዌካ ኦይታማነ ኡዱፑን ላይꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ሄዋፐ ጉይያን፥ ላፑንꬃ አግናን፥ ታማንꬃ ጋላሳን ቦንቼትያ ናጋራ አቶ ጊስያ ጋላሳን ማላካታ ፑንያ አሳ ህንተ ጋድያን ኡባን ኪትተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","እሻታማንꬆ ላይꬃ ዱማዪደ፥ ሄ ጋድያን ደእያ ኡባዉ ላአተꬃ አዋይተ። ሄዌ ህንተንቶ እሻታማንꬆ ላይꬃ ባላ። ሄ ዎድያን ህንተ ኡባይካ ህንተ ጋድያዉነ ህንተ ያራዉ ያራዉ ስምተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ሄ ላይꬃይ ህንተንቶ እሻታማንꬆ ላይꬃ ባላ። ሄ ላይꬃን ዘሮፕተ፤ አዛባ ግዲደ ሞኬዳዋካ ጫኮፕተ፤ ቃይ ህንተ አ ጼራ ጹንቀናን አይፌዳ ዎይንያ አይፍያካ ሺሾፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ሄዌ እሻታማንꬆ ላይꬃ ባላ ግድያ ድራዉ፥ እ ህንተንቶ ጌሻ፤ ጎሸናን ጮ ደምባን ሞኬዳዋ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘ሀ እሻታማንꬆ ላይꬃ ባላ ዎደ አሳይ ኡባይ ባረ ጋድያ ስሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘ህንተ ህንተ ሾሩዋፐ ጋድያ ሻሞፐ፥ ዎይ ቃይ አዉ ዛልኦፐ፥ እቱ እቱዋ ጭሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ህንተ እሻታማንꬆ ላይꬃ ባላፐ ጉይያን ደእያ ላይꬃቱዋ ፓይዱዋዳን ህንተ ሾሩዋፐ ሻምተ፤ ህንተ ሾሩካ ቃይ ጋዲ ካꬃ ሞካናዉ ደእያ ላይꬃቱዋ ፓይዱዋዳን ዛልኦ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ላይꬃቱዋ ፓይዱ ዳሮ ግዶፐ፥ ጋቲ ዳሬ፤ ላይꬃቱዋ ፓይዱ ጉጾፐ፥ ጋቲካ ጉጼ። አያዉ ጎፐ፥ ህንተ ጫካና ካꬃ ጫካ ፓይዱዋዳን ህንተ ሾሩ ህንተንቶ ዛልኤ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ህንተ እቱ እቱዋ ጭሞፕተ፤ ሽን ህንተ ህንተ ጾሳዉ ያይተ። ታን መꬍና ጎዳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘ታ አዛዙዋ ኦꬅተ፤ ታ ህግያካ ናግተነ ኦꬅተ፤ ያቶፐ ህንተ ሀ ጋድያን ሳሮተꬃን ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ቢታይ ባረ አይፍያ ህንተንቶ እማና፤ ህንተ ካላና ጋካናዉ ማና፤ ቃይ ሄ ቢታንካ ህንተ ሳሮተꬃን ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ህንተ፥ “ኑን ዘራና ꬋዮፐ፥ ቃይ ካꬃካ ጫኪደ ሺሻና ꬋዮፐ፥ ላፑንꬃ ላይꬃን አያ ማኔ?” ጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ታን ኡሱፑንꬃ ላይꬃን ታ አንጁዋ ህንተ ቦላን ኪታና፤ ያቶፐ ቢታይ ሄዙ ላይꬃዉ ግድያ አይፍያ አይፋና። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ሆስፑንꬃ ላይꬃን ህንተ ህንተ ጋድያን ዘርያ ዎደካ፥ ካሰ ሻቻ ካꬃ ማና፤ ቃይ ህንተ ዘርያ ካꬃ አይፍያ ኡዱፑንꬃ ላይꬃን ሺሻና ጋካናዉካ፥ ሻቻ ካꬃ ማና። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘ቢታይ ታዋ ግድያ ድራዉነ ህንተካ ሀ ጋድያን እማꬃነ በተ ግዲደ ደእያ ድራዉ፥ ቢታ ላኤንꬆ ስመናዳን ባይዞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ህንተ ኦይቄዳ ጋድያን ኡባን ደእያ ጋድያ ጎዳቱ ዎዛና ማላ፥ ኡንቱንቱ ማታ ናጋናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘ነ እሻይ ህዬሲደ ባረ ጋድያፐ ዛልኦፐ፥ አዉ ማታትያ ዳቡ ዪደ፥ ሄ ጋድያ አዉ ዎዞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","አዉ ሄ ጋድያ ዎዝያ ዳቡ ꬋዮፐ፥ ቃይ እካ ስም ዱረቲደ ዎዝያ ሚሻ ደሞፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ባረ ዛልኤዳ ዎድያፐ ዶሚደ ደእያ ላይꬃ ፓይዲደ፥ አቴዳ ላይꬃ ሚሻ ሻሜዳዎ ዛሮ፤ ያቲደ እ ባረ ጋድያዉ ስሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ሽን አዉ ሄ ጋድያ ዎዛናዉ ግድያ ሻሉ ꬋዮፐ፥ እሻታማንꬆ ላይꬃ ባላይ ጋካናዉ ጋዲ ሻሜዳ ብታንያ ኩሽያን ጋምኦ፤ እሻታማንꬆ ላይꬃ ባላ ዎደ፥ አ ጋዲ አዉ ስሞ፤ እካ ባረ ጋድያዉ ስሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘ግምበት ኡቴዳ ካታማ ግዶን እት አሳይ ደእያ ጎልያ ሀራ ኡራዉ ዛልኦፐ፥ እ ዛልኦሳፐ ቢደ እት ላይꬃ ጋካናዉ ደእያ ዎድያን ዛሪደ ዎዛናዉ አዉ ማታይ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","እት ላይꬃ ኩመንꬃ ግዶን ዎዛና ꬋዮፐ፥ ሄ ግምበቴዳ ካታማ ግዶን ደእያ ጎሊ ሻሜዳዎ ናኣ ናአዉ መꬍናዉ አዋ ግዴ። እሻታማንꬆ ላይꬃ ባላ ዎደካ ስመና። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ሽን ግምበትቤና ሄራቱዋን ደእያ ጎለቱ ሾይቃ ማላ። ኡንቱንቱ ዎዘቲኖ፤ እሻታማንꬆ ላይꬃ ባላ ዎደካ ዛልኤዳዎ ስሚኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘ግዶፐነ ሌዋቱዋ ካታማቱዋን ደእያ ባረንቱ ጎልያ ሌዋቱ ባረንቱ ኮዬዳ ዎድያን ዎዝ አካናዉ ዳንዳዪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ሌዋቱዋፐ እት አሳይ ኡንቱንቱ ካታማ ግዶን ደእያ ጎልያ ዛልኢደ ዎዛና ꬋዮፐ፥ ሄ ኡንቱንቱ ካታማ ግዶን ደእያ ጎሊ እሻታማንꬆ ላይꬃ ባላ ዎደ ስሜ። አያዉ ጎፐ፥ ሌዋቱዋ ካታማ ግዶን ደእያ ጎለቱ እስራኤልያ አሳ ግዶን ሌዋቶ አቆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ሽን ኡንቱንቱ ካታማ ዩሹዋን ኡንቱንቱ ኡባዉ እትፐ ደእያ ቢታይ ኡንቱንቶ መꬍናዉ አቆ ግድያ ድራዉ ዛልኤተና። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘ቃይ ነ እሻይ ህዬሲደ ባረና ዳንዳያና ꬋዮፐ፥ እማꬃዳንነ በትያዳን እ ኔናና ደአና ማላ፥ ኔን አ ማዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ነ እሻ ኔናና ዎꬃናዉ አፐ ድቻ አኮፓ፤ ዎይ ዎꬍያ ሞፓ። ሽን ኔን ነ ጾሳዉ ያያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ነ ብራ አዉ ድቻዉ ታልኦፓ፤ ነ ቁማካ አዉ ዎꬍያን ዛልኦፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ህንተዉ ካናነ ቢታ እማናዉነ ህንተ ጾሳ ግዳናዉ፥ ህንተና ግብጼ ጋድያፐ ከሴዳዌ፥ ታን መꬍና ጎዳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘ነዉ ዳቦ ግድያ እስራኤልያ አሳይ ማንቂደ፥ ባረና ነዉ አይለተꬃዉ ዛልኦፐ፥ ኔን አ አይልያዳን ኦስሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","እ ከራ ኦꬅያ አሳዳንነ በትያዳን ኔናና ደኦ፤ እሻታማንꬆ ላይꬃ ባላይ ጋካናዉ እ ነዉ ኦꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ሄ ዎደ እ ባረ ናናቱዋናካ እትፐ ነ ጎለፐ ከሲደ ባረ ጎልያ አሳኮ ቦ፤ ባረ አዉዋ ጋድያኮካ ስሞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","እስራኤላቱ ታን ግብጼ ጋድያፐ ከሴዳ ታ አይለቱዋ ግድያ ድራዉ፥ ኡንቱንቱ አይለተꬃዉ ዛልኤቶፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ኔን ኡንቱንቶ መቀꬃ ኢታደ ሞዶፓ፤ ሽን ኔን ነ ጾሳዉ ያያ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘ነዉ አቱማነ ማጫ አይለቱ ደአና ማላ ኮዮፐ፥ ነ ዩሹዋን ደእያ ካዉተꬃቱዋፐ ሻማ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ቃይ ህንተ ጋድያን ደእያ በተቱዋፐነ ህንተ ጋድያን ደእሽን የለቴዳ ኡንቱንቱ ሶ አሳፐ ሻማናዉ ዳንዳዪታ፤ ኡንቱንቱ ህንተንቶ አቆ ግድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ህንተፐ ጉይያን ህንተ ናናይ ኡንቱንታ መꬍናዉ ላታና ማላ፥ ህንተ ናናዉ እምተ። ህንተ ኡንቱንቱፐ ኡባ ዎደካ አይልያ ሻማናዉ ዳንዳዪታ፤ ሽን ህንተ እሻ ግድያ እስራኤልያ አሳ መቀꬃ ኢሲደ ሞዶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘ነ ማታን ደእያ እማꬃ ዎይ በተ አሳይ ዱረትና፥ ቃይ አ ማታን ደእያ ነ እሻይ ማንቂደ፥ ሄ ነ ማታን ደእያ እማꬃዉ ዎይ በትያዉ ዎይ እማꬃ ብታንያ ዛርያፐ እቶ ባረና ዛልኦፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","እ ዛልኤት ስምና አ ዎዛናዉ ዳንዳየቴ፤ አ እሻቱዋፐ እቱ አ ዎዞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ዎይ አ አዉዋ እሻይ፥ ዎይ አ አዉዋ እሻ ናአይ አ ዎዞ፤ ዎይ አ ያራፐ አዉ ማታ ዳቦ ግድያ አሳይ አ ዎዞ፤ ዎይ ቃይ እ ባረ ሁጲያዉ ዱረቶፐ እ ባረና ዎዞ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","እ ባረና ሻሜዳ ብታንያና እትፐ ግዲደ፥ እ ባረና ዛልኤዳ ላይꬃፐ ዶሚደ እሻታማንꬆ ላይꬃ ባላይ ጋካናዉ ደእያ ላይꬃ ፓይዶ፤ አ ብልያ ጋቲ ሄ ላይꬃ ፓይዱዋ ኬሻ ግዶ። እ ባረና ሻሜዳዋና ጋምኤዳ ዎድያ ጋቲ እት አሳይ ከራ ኦꬂደ ደምያ ሚሻ ኬሻ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","እሻታማንꬆ ላይꬃ ባላይ ጋካናዉ ብሮ ዳሮ ላይꬃይ አቴዳዋ ግዶፐ፥ ባረ ዛልኤቴዳ ጋትያፐ ሄ ላይꬃ ፓይዱዋን ባረና ዎዝያ ጋትያ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ቃይ እሻታማንꬆ ላይꬃ ባላይ ጋካናዉ አቴዳ ላይꬃይ ጉꬃ ግዶፐ፥ ባረና ሻሜዳዋና እትፐ ፓይዲደ፥ ሄ ላይꬃ ፓይዱዋን ባረና ዎዝያ ጋትያ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","እ ላይꬃን ላይꬃን ከራ ኦꬅያ አሳዳን ባረና ሻሜዳዋና ደኦፐ አትና፥ ህንተ ጼሊደ እስራኤልያ አሳ ግድያ ብታንያ መቀꬃ ኢሲደ ሞዶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘ሽን እ ሄዋ ማላ ኦግያን ዎዘታና ꬋዮፐ፥ እሻታማንꬆ ላይꬃ ባላይ ጋክያ ዎደ እነ አ ናናይ ቆማተꬃፐ ከስኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","አያዉ ጎፐ፥ እስራኤልያ አሳይ ታ ቆማቱዋቴ፤ ታን ግብጼ ጋድያፐ ከሴዳ ታ ቆማቱዋ። ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","መꬍና ጎዳይ ሀዋዳን ያጌ፤ “ህንተ ኡንቱንቶ ጎይናናዉ ኤቃቱዋ መꬎፕተ፤ ቃይ ሀዉልትያ፥ ማሰቴዳ ምስልያ ዎይ ማሰቴዳ ሹቻ ኤሶፕተ። ታን፥ መꬍና ጎዳይ፥ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","ታ ሳምባታቱዋ ናግተ፤ ታ ዱንካንያ ቦንችተ፤ ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ህንተ ታ ህግያን ቦፐ፥ ታ አዛዞቱዋካ ናጎፐነ ኦꬆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ታን ህንተንቶ እራ ዎድያን ቡክሳና፤ ቢታይካ ካꬃ ዳርሲደ ሞካና፤ ደምባ ምꬃቱካ አይፍያ አይፋና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ህንተ ካꬃ ቡክያ ዎድያፐ ቢደ ዎይንያ አይፍያ ማጽያ ዎዲ ጋካናዉ ካꬃ ቆጻና፤ ቃይ ዎይንያ አይፍያ ማጹካ ቢደ ካꬃ ዘርያ ዎዲ ጋካናዉ ዉረና። ህንተ ካላና ጋካናዉ ቁማ ማና፤ ቃይ ህንተ ህንተ ቢታንካ ሳሩዋን ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ታን ቢታዉ ሳሮተꬃ እማና፤ ኦንነ ያሽሰናን ህንተ ግሳና። ኢታ ዶአቱዋ ታን ጋድያፐ ꬋይሳና፤ ህንተ ጋድያን ላኤንꬆ ኦላይ ደንደና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ህንተ ሞርከቱዋ ህንተ የደርሳና፤ ህንተ ስንꬃን ኡንቱንቱ ማሻን ሀይቃና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ህንተፐ እቼሹ ጼቱዋ የደርሳና፤ ቃይ ጼቱ ታሙ ሻኣ የደርሳና። ህንተ ሞርከቱ ህንተ ስንꬃን ማሻን ሀይቃና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ታን ታ ዴሙዋ ህንተኮ ዛራና፤ ህንተና አይፍሳና፤ ህንተና ዳርሳና። ቃይ ታን ታ ጫቁዋ ህንተናና ምንሳና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ህንተ ሻቻ ካꬃ ማና፤ ቃይ ሀ ላይꬃ ካꬃ ዎꬃናዉ፥ ሻቻ ካꬃ ድጊደ ሳኣ ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ታን ታ ደእያ ሳኣ ህንተ ግዶን ኦꬃና፤ ታን ህንተና ሻትከ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ታን ህንተ ግዱዋን ሀመታና፤ ቃይ ህንተ ጾሳ ግዳና፤ ህንተካ ታ አሳ ግዳንታ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ህንተ ግብጼቶ አይልያ ግደናዳን፥ ግብጼ ጋድያፐ ህንተና ከሴዳዌ ታን መꬍና ጎዳይ ህንተ ጾሳ። ታን ህንተ አይለተꬃ ሞርገ ምꬃ መንꬃድ፤ ቃይ ህንተካ ꬎቁ ጊደ ሄመታናዳን ኦꬃድ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ሽን ህንተ ታን ግያዋ ስሰናን እጾፐነ፥ ሀ አዛዞቱዋ ኡባካ ኦናን እጾፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ታ ዎጋ ህንተ ካꬎኦፐ፥ ቃይ ታ አዛዞቱዋ ኡባ ኦናን እጺደ ታ ጫቁዋ መንꬃናዉ ህንተ ታ ህግያ ሻቶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ሄ ዎደ ታን ህንተ ቦላ ሀዋ ኦꬃና: ህንተ አኬከናን ደእሽን ያሻ፥ ግልቃተꬃ፥ ህንተ አይፍያ ጆልስያነ ህንተና ሎይꬅ ሀርግስያ ምሹዋ ህንተ ቦላ አሀና። ህንተ ዘረꬃ ዘራና፤ ሽን እ ሀዳ፤ አያዉ ጎፐ፥ ሄዋ ህንተ ሞርከቱ ማና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ታን ታ ሶምኡዋ ህንተ ቦላ ቱካና፤ ህንተ ሞርከቱዋ ስንꬃን ህንተ ኩንዳና፤ ህንተና እጺያዋንቱ ህንተና ሞዳና፤ ቃይ ኦንነ የደርሰናን ህንተ ባቃታና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ሀዋ ኡባ ኦꬅናካ ህንተ ታና ስሰናን እጾፐ፥ ታን ህንተ ናጋራ ድራዉ ህንተ ሙራ ላፑን ዳኩዋ ጉጃና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ህንተ ዎልቃ ኦቶሩዋ ታን መንꬃና፤ ሳሉዋ ብራታ ማላ ኦꬃና፤ ህንተ ቢታካ ናሃስያ ግያ ብራታ ማላ ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ህንተ ዎልቃይ ሀዳሳን ዉራና፤ አያዉ ጎፐ፥ ህንተ ቢታይ ካꬃ ሞከና፤ ጋድያን ደእያ ምꬃቱካ አይፍያ አይፍክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ህንተ ታዉ እጼዶ ጎፐነ ታን ግያዋካ ስሰናን እጾፐ፥ ህንተ ናጋራ ኬሻ ላፑን ዳኩዋ ቦሻ ታን ህንተ ቦላን አሀና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ታን ህንተ ቦላ ባዙዋ ዶአቱዋ የዳና፤ ኡንቱንቱ ህንተ ናናቱዋ ቦንቃና፤ ህንተ መሄቱዋ ꬋይሳና፤ ህንተ ፓይዱዋካ ጉꬃና፤ ሄዋ ጋሱዋን ህንተ ሀመትያ ኦጊ ባዙዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ሀ ኡባ ሙራንካ ህንተ ታኮ ስመናን እጻድ ጊደ ቦፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ሄ ዎደ ታንካ ህንተንቶ እጻድ ጋና፤ ቃይ ህንተ ናጋራ ድራዉ ታን ታ ሁጲያዉ ህንተና ላፑን ዳኩዋ ሙራና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ታ ጫቁዋ መንꬄዳ ሀሉዋ ከስያ ማሻ ታን ህንተ ቦላ አሀና፤ ህንተ ህንተ ካታማቱዋን ሺቆፐካ፥ ታን ህንተ ቦላን ኢታ ሀርግያ የዳና። ቃይ ህንተካ ህንተ ሞርከቱዋ ኩሽያን አꬊደ እመታና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ህንተ ካꬃ ታን ꬋይስያ ዎደ፥ ታሙ ማጫ አሳቱ እት ባሽያን ኡክꬃ ኡካና፤ ሄዋካ ሚዛናን ልኪደ ሻካና፤ ህንተ ሄዋ ማና፥ ሽን ካልክታ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ሀ ኡባንካ ህንተ ታን ግያዋ ስሰናን እጻድ ጊደ ቦፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ሄ ዎደ ታንካ ህንተ ቦላ ሀንቁዋን ደንዳና፤ ህንተ ናጋራ ድራዉ ታን ታ ሁጲያዉ ህንተና ላፑን ዳኩዋ ሙራን። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ህንተ ህንተ አቱማ ናናቱዋነ ህንተ ማጫ ናናቱዋ አሹዋ ማና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ህንተ ጎይንያ ꬎቃ ሳኣ ታን ኮላና፤ ህንተ እጻና ያርሽያ ሳኣካ ꬋይሳና። ታን ህንተ አሃ ህንተ ኤቃቱዋ አሃ ቦላን ኦላና፤ ታን ህንተና ሙለ ሻታና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ታን ህንተ ካታማቱዋ መላ ኦꬃና፤ ህንተ ጎይንያ ሳአቱዋካ ኮለሬꬃና፤ ህንተ ሳዊያ ያርሹዋካ ስንግከ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","“ታን ህንተ ቢታ ꬋይሳና፤ ያቶፐ ሄ ህንተ ጋድያን ዪደ ኡትያ ሞርከቱካ ሄዋን ማላለታና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ታን ህንተና ካዉተꬃቱዋ ግዶን ላላና፤ ህንተ ቦላንካ ታ ማሻ ሾዳና። ህንተ ቢታይ ባያና፤ ህንተ ካታማቱካ መላ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ሄ ህንተ ህንተ ሞርከቱዋ ጋድያን ደእያ ዎደ፥ ባዪደ ጮ ደእያ ህንተ ቢታይ ባረ ሳምባታቱዋ ቦንቺደ ናሸታና። ሄ ዎደ ህንተ ቢታይ ሸምፓናነ ባረ ሳምባታቱዋ ቦንቺደ ናሸታና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ህንተ ሄ ጋድያን ደኤዳ ዎድያን ኡባን ህንተ ሳምባታቱዋን ደምቤና ሸምፑዋ ሀእ ባዪደ ጮ ደእያ ዎድያን ደማና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ህንተ ህንተ ሞርከቱዋ ጋድያን ደእያ ዎደ፥ ህንተፐ ሻከቲደ ጉየ አቲደ ደእያዋንቱ ዎዛናን ታን ያሻ የዳና፤ ጫርኩ ቃꬅያ ቦንጭያ ኮሻይ ኡንቱንታ ሻቢራና፤ ኡንቱንቱ ማሻፐ ባቃትያዋዳን ባቃታና፤ ቃይ ኡንቱንቱ ኦንነ የደርሰናን ኩንዳና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ህንተና የደርስያዌ ባይናን ደእሽን፥ ህንተ ኦላፐ ባቃትያዋዳን እቱ እቱዋና ꬉበታና፤ ቃይ ህንተ ህንተ ሞርከቱዋ ስንꬃን ኤቃናዉካ ህንተንቶ አያ ዎልቂነ ደኤና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ህንተ ካዉተꬃቱዋ ግዶን ባያና፤ ህንተ ሞርከቱዋ ቢታይካ ህንተና ምታና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ህንተፐ ሻከቲደ ህንተ ሞርከቱዋ ጋድያን አቴዳዋንቱ ባረንቱ ናጋራ ጋሱዋንነ ባረንቱ አዎቱዋ ናጋራ ጋሱዋን ግልቃና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ሽን ኡንቱንቱ ታን ኡንቱንቶ እጼዳ ጋናዳንነ ኡንቱንቱ ሞርከቱዋ ቢታዉ ኡንቱንታ የዳናዳን ኦꬄዳ ባረንቱ ናጋራ፥ ባረንቱ ማይዛ አዎቱዋ ናጋራ፥ ኡንቱንቱ ታና ጭሜዳ ጭሙዋነ ኡንቱንቱ ታዉ እጻድ ጌዳዋ ፓጾፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ሄዋን ቃይ ኡንቱንቱ አዛዘተና ዎዛናይካ ዝቂ ጎፐነ ኡንቱንቱ ባረንቱ ናጋራ ሙራ አኮፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ሄ ዎደ ታን ያቆባና ጫቀቴዳ ታ ጫቁዋ ሀሳያና፤ ቃይ ይሳቃናነ አብራሃመና ጫቀቴዳ ታ ጫቁዋ ሀሳያና፤ ቢታካ ሀሳያና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ኡንቱንቱ ꬋይ ድግና፥ ኡንቱንቱ ቢታይ መላ አታና፤ ሄ ኡንቱንቱ ꬋይና ባይያዋ ግዲደ ጮ ደእያ ዎድያን ቢታይ ባረ ሳምባታቱዋ ቦንቺደ ናሸታና። ኡንቱንቱ ታ አዛዙዋ ካꬌዳ ድራዉነ ኡንቱንቱ ሸምፑካ ታ ዎጋ ሻቴዳ ድራዉ፥ ኡንቱንቱ ባረንቱ ናጋራ ሙራ አካና። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“ግዶፐነ ኡንቱንቱ ባረንቱ ሞርከቱዋ ጋድያን ደእያ ዎደ፥ ኡንቱንቱ ኡባና ꬋያና ጋካናዉነ ኡንቱንቱና ደእያ ታ ጫቁዋካ መንꬃና ጋካናዉ፥ ታን ኡንቱንታ ኦልከ፤ ቃይ ሻትከ። ታን፥ መꬍና ጎዳይ፥ ኡንቱንቱ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ታን ኡንቱንቱ ጾሳ ግዳናዉ፥ ካዉተꬃቱ ጼልሽን፥ ግብጼ ጋድያፐ ከሴዳ ኡንቱንቱ ማይዛ አዎቱዋና ታን ጫቀቴዳ ጫቁዋ ኡንቱንቱ ድራዉ ሀሳያና። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","“መꬍና ጎዳይ ሲና ደርያ ቦላን ሙሴ ባጋና ባረፐነ እስራኤልያ አሳፐ ግዱዋን ዎꬄዳ ዎጋቱ፥ አዛዞቱነ ህገቱ ሀዋንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘እት አሳይ መꬍና ጎዳዉ እማናዉ ሺቆፐ፥ ኔን ቆፕያዋዳን ሄ አሳ ድራዉ ሚሻ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ሄዌነ ላታሙ ላይꬃፐ ቢደ ኡሱፑን ታሙ ላይꬃ ጋካናዉ ደእያ አቱማዎ ኡሱፑን ጼቱ ግራምያ ዴጽያ ጻጋራ ብራ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ማጫ አሳ ግዶፐ ቃይ ሀታሙ ጻጋራ ብራ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ቃይ እቼሹ ላይꬃፐ ቢደ ላታሙ ላይꬃ ጋካናዉ ደእያ አቱማዎ ላታሙ ጻጋራ ብራነ ማጫንዉ ታሙ ጻጋራ ብራ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ቃይካ እት አግናፐ ቢደ እቼሹ ላይꬃ ጋካናዉ ደእያ አቱማዎ እቼሹ ጻጋራ ብራነ ማጫንዉ ሄዙ ጻጋራ ብራ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ሄዋዳንካ ቃይ ኡሱፑን ታሙ ላይꬃነ ሄዋፐ ቦላና ደእያ አቱማዎ ታማነ እቼሹ ጻጋራ ብራነ ማጫንዉ ታሙ ጻጋራ ብራ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ቃይ ሺቄዳ ብታኒ ኔን ቆፕዳዋ ጭጋናዉ ዳንዳየና ዳሮ ማንቆ ግዶፐ፥ እ ባረ ሺቁዋ ጋꬃናዉ እሜዳ አሳ አሂደ ቄስያ ስንꬃን ኤሶፐ ሺቄዳ ብታኒ ጭጋናዉ ዳንዳይያዋ ኬና ቆፒደ ቄሲ ጋማቶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘እ ሺቀቴዳዌ አሳይ መꬍና ጎዳዉ ያርሽያ ሳኣ ማላ መህያ ያርሻናዉ ግዶፐ፥ ሄዋ ማላ አሳይ መꬍና ጎዳዉ እምያ መሂ ኡባይ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","እ ሄ መህያ ድራዉ ሀራ መህያ እሞፖ፤ ዎይ አ ሀራ መህያና ላሞፖ። ሎኡዋ ኢታና ዎይ ቃይ ኢታካ ሎኡዋና ላሞፖ፤ ሽን እ ላሞፐ፥ ኮይሮ መህያነ ላምያ እሜዳ መሂ ላኡካ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","እ ሺቀቴዳ መሂ መꬍና ጎዳዉ ያርሹዋ ኦꬂደ ሺሻናዉ ጌሻ ግደና መህያ ግዶፐ፥ ሄ ብታኒ ሄ መህያ ቄስያ ስንꬃ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ሎኦ ግድና ኢታ ግድና፥ ቄሲ ሄ መህያ ጋማቶ፤ ያቶፐ ቄሲ ጋማቴዳዌ አ ጋትያ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ሽን ሄ መህያ ጎዳይ አ ዛሪደ ዎዛናዉ ኮዮፐ፥ ሄ መህያ ጋትያ ቦላ ጼቱዋፐ ላታሙ ኩሽያ ጉጆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘እት አሳይ ባረ ጎልያ ጌሻ ግዳናዳን መꬍና ጎዳዉ ዱማዮፐ፥ ሎኦ ግድና ኢታ ግድና፥ ቄሲ ሄ ጎልያ ጋማቶ። ያቶፐ ቄሲ ጋማቴዳዋዳን አ ጋቲ ሄዋዳንካ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ቃይ ባረ ጎልያ ጾሳዉ ጌሻ ኦꬅ ዱማዬዳ አሳይ ዛረꬂደ ዎዛናዉ ኮዮፐ፥ ሄ ጎልያ ጋትያ ቦላን ጼቱዋፐ ላታሙ ኩሽያ ጉጆ፤ ያቶፐ ጎሊ አሳ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘እት አሳይ ባረ ላታ ጋድያፐ ሻኪደ ጌሻ ኦꬅ መꬍና ጎዳዉ ዱማዮፐ፥ ሄ ጋድያ ጋቲ አን ዘርያ ዘረꬃን ቆፈቶ። ሄዌነ ላታሙ ኪሎ ግራመ ባንጋ ዘርያ ኬሻ ሾይቃ ግዶፐ፥ ታሙ ጻጋራ ብራ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","እ ባረ ጋድያ እሻታማንꬆ ላይꬃ ባላፐ ዶሚደ ጌሻ ኦꬅ ጾሳዉ ዱማዮፐ፥ ሄ ጋድያዉ ኩመንꬃ ጋትያ ጭጎ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ሽን እ ባረ ጋድያ እሻታማንꬆ ላይꬃ ባላይ አꬍ ስምና ጌሻ ኦꬅ ጾሳዉ ዱማዮፐ፥ ካሊደ ደእያ እሻታማንꬆ ላይꬃ ባላይ ጋካናዉ ደእያ ዎድያ ቄሲ ፓይዶ፤ ያቶፐ አ ኩመንꬃ ጋትያፐ ዎꬌ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ሄ ጋድያ ጌሻ ኦꬅ ጾሳዉ ዱማዬዳ አሳይ ዛረꬅ ዎዛናዉ ኮዮፐ፥ እ ጋማተቴዳ ሚሻ ቦላ ጼቱዋፐ ላታሙ ኩሽያ ጉጆ፤ ያቶፐ ጋዲ ስሚደ አዋ ግዴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ሽን እ ጋድያ ዛረꬂደ፥ ዎዛናፐ ካሰቲደ ሀራ አሳዉ ዛልኦፐ፥ ሄ ጋድያ ዎዛናዉ ዳንዳየና። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","እሻታማንꬆ ላይꬃ ባላይ ጋክና ጋዲ የደቲያ ዎደ፥ ሄ ጋዲ ላኤንꬆ ጉየ አካናዋዳን መꬍና ጎዳዉ ጌሻ ግዴ። ሄ ግሹ ቄስያሳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘እት አሳይ ሀራ አሳፐ ሻሜዳ ጋድያ ጌሻ ኦꬅ መꬍና ጎዳዉ ዱማያናዉ ኮዮፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ካልያ እሻታማንꬆ ላይꬃ ባላይ ጋካናዉ ደእያ ጋትያ ቄሲ ጋማቶ፤ ብታኒ ሄ ጋላስካ ሄ ግምትያ ጭጎ፤ ሄ ሚሻይ መꬍና ጎዳዉ ዱማቴዳ ሚሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","እሻታማንꬆ ላይꬃ ባላይ ጋክያ ዎደ፥ ሄ ጋዲ ኮይሮ ላታን አኪደ ዛልኤዳ ብታንያዉ ስሜ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“ ‘አ ጋቲ ጾሳ ዱንካንያን ኤረቲያ ሚዛናን ጋማተቴ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘ሽን ኦንነ ባይራ የለቴዳ መህያ መꬍና ጎዳዉ ዱማዪደ ሺሻናዉ ዳንዳየና፤ አያዉ ጎፐ፥ እ ካሰካ መꬍና ጎዳሳ። ሚዛ ማራ ግድና ዎይ ዶርሳ ማራ ግድናካ እ መꬍና ጎዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ሄ መሂ ጌሻ ግዳና ꬋዮፐ፥ ነ ጋማቴዳ ጋትያ ቦላ ጼቱዋፐ ላታሙ ኩሽያ ጉጂደ አ ጎዳይ ዛረꬂደ ዎዞ። እ ዎዛና ꬋዮፐ፥ ነ ጋማቴዳ ጋትያን ሀራ አሳዉ ዛልኤቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘እት አሳይ ባረዋፐ መꬍና ጎዳዉ እሜዳዌ አያ ግዶፐካ፥ አሳ ግድና መህያ ግድና፥ ዎይ አ ላታን ጋኬዳ ጋደ ግድናካ፥ ዛልኤተናነ ዎዘተና። ዱማዬዳዌ ኡባባይ መꬍና ጎዳዉ ጌሻ ኡባፐ እቱዋ ግዴዳ ጌሻ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","አሳ ግዶፐ ሻከቲደ ꬋያናዳን እመቴዳ አሳይ ዎዘቶፖ፤ ሄ አሳይ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘ቢታ አስራታይ ኡባይ ጋድያፐ ሞኬዳ ካꬃ ግድና ዎይ ምꬃ አይፍያ ግድናካ መꬍና ጎዳሳ። ሄዌ መꬍና ጎዳዉ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","እት አሳይ ባረ አስራታ ዎዛናዉ ኮዮፐ፥ አ ጋትያ ቦላን ጼቱዋፐ ላታሙ ኩሽያ ጉጆ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ሚዛ አስራታ ግድና፥ ዶርሳ አስራታ ግድና፥ ዎይ ዴሻ አስራታ ግድናካ፥ ሄንꬃንቻ ጋትማፐ ጋርሳና አꬍያ ሀቃዌነ ታሙንꬅ መꬍና ጎዳዉ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ታሙንꬃ መህያ ኢታ ግድና ሎኦ ግድናካ ዶሮፖ፤ ዎይ አ ሀራና ላሞፖ። ላሞፐነ ኮይሮዌነ ላምያ እሜዳዌነ ላኡካ ጾሳዉ ጌሻ ግዲኖፐ አትና፥ ዛሪደ ዎዛናዉ ዳንዳየና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ሲና ደርያ ቦላን መꬍና ጎዳይ ሙሴ ባጋና እስራኤልያ አሳ አዛዜዳ አዛዞቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ሲና መላ ቢታ፥ መꬍና ጎዳ ዱንካንያ ግዶን፥ እስራኤልያ አሳይ ግብጼ ጋድያፐ ከሴዳ ላኤንꬆ ላይꬃን፥ ላኤንꬆ አግናን፥ ሄ አግናዉ ኮይሮ ጋላሳን፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“እስራኤልያ አሳ ኡባ ኡንቱንቱ ያራን ያራንነ ጎልያን ጎልያን ፓይዳደ፥ አቱማ አሳ ኡንቱንቱ ሱንꬃን ሱንꬃን ጻፋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ኔንነ አሮን የለቶደፐ ላታሙ ላይꬃነ ሄዋፐ ቦላና ደእያ እስራኤላቱዋ፥ ኦላ ባናዉ ዳንዳይያዋንታ ኡባቱዋ፥ ኡንቱንቱ ጭታን ጭታን ፓይድተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ዛርያፐ ዛርያፐ እት እት አሳይ ባረ ጎልያ አሳዉ ካፑዋ ግዲደ፥ ህንተና ማዶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ህንተና ማዳና አሳቱ ሱንꬃይ ሀዋፐ ካሊደ ደእያዋ: ዛርያ ጎልያ አሳ ካፑዋ ሮቤላ ሻደኡራ ናኣ ኤሊጹራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ስሞና ጹሪሻዳያ ናኣ ሻሉምኤላ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ይሁዳ አምናዳባ ናኣ ናአሶና፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ይሳኮራ ጹኣራ ናኣ ናታንኤላ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ዛብሎና ሄሎና ናኣ ኤልኣባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ዮሴፎ ናናፐ ኤፍሬማ አምሁዳ ናኣ ኤልሻማአ፥ ምናሰ ፓዳጹራ ናኣ ጋማልኤላ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ቢንያማ ጊድኦና ናኣ አብዳና፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ዳና አምሻዳያ ናኣ አህኤዘራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","አሴራ ኦክራና ናኣ ፓግኤላ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ጋዳ ዳኡኤላ ናኣ ኤልያሳፋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ንፍታሌማ ኤናና ናኣ አህራአ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ሀ አሳቱ ባረንቱ አዎቱዋ ጎልያ አሳቱዋፐ ካለꬃናዉ፥ ዶረቴዳዋንታ፤ ኡንቱንቱ እስራኤልያ ያራቶ ካፓቱዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ሙሴነ አሮን ሱንꬃይ ጼሰቴዳ ሀ አሳቱዋ አፌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ላኤንꬃ አግናን ኮይሮ ጋላስ ኩመንꬃ ማባራ ጼሲደ፥ እትፐ ሺሼድኖ። አሳይ ባረ ያራን ያራንነ ባረ ጎልያን ጎልያን ኦዲደ፥ የለቶደፐ ላታሙ ላይꬃነ ሄዋፐ ቦላና ደእያ አቱማ አሳቱዋ ኡባ ሱንꬃይ ኡባና ጻፈቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","መꬍና ጎዳይ አ አዛዜዳዋዳን፥ ሙሴ ኡንቱንታ ሲና መላ ቢታን ፓይዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","ኦላዉ ባናዉ ዳንዳይያ አቱማ አሳቱ ኡባይ፥ ላታሙ ላይꬃነ ሄዋፐ ቦላና ደእያዋንቱ ፓይደቲደ፥ ሁጲያን ሁጲያን ጻፈቴድኖ። ኡንቱንቱ ባረንቱ ያራን ያራንነ ባረንቱ ጎልያን ጎልያን ሻከቲደ፥ ሀዋፐ ካሊደ ደእያ ፓይዱዋን ማዝጎበቴድኖ። ዛርያ ኦላንቻቱዋ ፓይዱዋ፤ ሮቤላ (እስራኤልያ ናኣ ባይራ) 46,500 ");
INSERT INTO dwrENT_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","ስሞና 59,300፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","ጋዳ 45,650፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","ይሁዳ 74,600፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","ይሳኮራ 54,400፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","ዛብሎና 57,400፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","ዮሴፎ ናኣ ኤፍሬማ 40,500፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","ዮሴፎ ናኣ ምናሳ 32,200፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","ቢንያማ 35,400፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","ዳና 62,700፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","አሴራ 41,500፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","ንፍታሌማ 53,400፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ሙሴ፥ አሮንነ ታማነ ላኡ እስራኤልያ ዛራቱ ካፓቱ ፓይዴዳ አሳይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ኦላዉ ባናዉ ዳንዳይያ አቱማ አሳቱ ኡባይ ላታሙ ላይꬃነ ሄዋፐ ቦላና ደእያዋንቱ ባረንቱ አዉዋ ጎልያን ጎልያን ፓይደቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ሄዋንቱ ኡባና 603,550. ");
INSERT INTO dwrENT_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ሽን ሌዊያ ዛራቱ ሀ ፓይደቴዳ አሳና ፓይደትበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","አያዉ ጎፐ፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ሌዊያ ዛራቱዋ ፓይዶፓ፤ ኡንቱንታ አቴዳ እስራኤላቱዋ ፓይዱዋን የጎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ሌዋቱዋ ጾሳ ዱንካንያ ቦላንነ አ ግዶን ደእያ ሚሻቱዋ ኡባ ቦላን ካፑዋ ኦꬃደ ሱንꬃ። ኡንቱንቱ ሄ ዱንካንያነ አ ግዶን ደእያ ሚሻቱዋ ቶክኖ፤ ኡንቱንቱ አ ግዶን ኦꬅኖነ አ ዩሹዋን ዱንካንኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ጾሳ ዱንካኒ ሾደትያ ዎደ ሌዋቱ ሾድኖ፤ ጾሳ ዱንካኒ ኤቂያ ዎደካ ሌዋቱ ኤስኖ። ኡንቱንቱፐ ሀራይ ኦንነ አኮ ሺቆፐ፥ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","እስራኤልያ አሳቱ ኡባይ ባረንቱ አርማን አርማንነ ባረንቱ ጭታን ጭታን ሻከቲደ፥ ባረንቱ ዱንካንያ ዱንካንኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ሽን ጾሳ ሀንቁ እስራኤልያ ማባራ ቦላ ዎና ማላ፥ ሌዋቱ ጾሳ ማርካተꬃ ዱንካንያ ዩሹዋን ባረንቱ ዱንካንያ ዱንካንኖ፤ ሌዋቱ ጾሳ ዱንካንያን አዎትኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","እስራኤላቱ ሀዋ ኡባ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“እስራኤልያ አሳይ ባረንቱ ባጋ ባጋ ኤርስያ አርማነ ባረንቱ ያራ ያራ ኤርስያ ባንድራ ካሊደ፥ ጾሳ ዱንካንያፐ ጉꬃ ሃኪደ፥ አ ዩሹዋን ዱንካንኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","4","“አዋይ ዶልያ ባጋና ይሁዳ ባጋይ ባረንቱ አርማ ካሊደ ዱንካንኖ። ኡንቱንቱ ዛራቱዋ ሱንꬃይ፥ ዛራቱዋ ካፓቱዋ ሱንꬃይነ ኦላንቻቱዋ ፓይዱ ሀዋፐ ካሌ: ይሁዳ አምናዳባ ናኣ ናአሶና 74,600፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","6","ይሳኮራ ጹኣራ ናኣ ናታንኤላ 54,400፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","8","ዛብሎና ሄሎና ናኣ ኤልኣባ 57,400፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ይሁዳ ባጋፐ ፓይደቴዳ ኦላንቻቱ ኡባና 186,400. ሀራ ሳኣ ብያ ዎደ ኡንቱንቱ ኮይሮ ከስያዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","11","“ቃይ ዱገሃ ባጋና ሮቤላ ባጋይ ባረንቱ አርማ ካሊደ ዱንካንኖ። ኡንቱንቱ ዛራቱ ሱንꬃይ፥ ዛራቱዋ ካፓቱዋ ሱንꬃይነ ኦላንቻቱዋ ፓይዱ ሀዋፐ ካሌ: ሮቤላ ሻደኡራ ናኣ ኤሊጹራ 46,500፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","13","ስሞና ጹሪሻዳያ ናኣ ሻሉምኤላ 59,300፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","15","ጋዳ ረኡኤላ ናኣ ኤልያሳፋ 45,650። ");
INSERT INTO dwrENT_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ሮቤላ ባጋፐ ፓይደቴዳ ኦላንቻቱ ኡባና 151,450 ሀራ ሳኣ ብያ ዎደ ኡንቱንቱ ላኤንꬆ ከስያዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“ሄዋፐ ጉይያን፥ ጾሳ ዱንካኒነ ሌዊያ ዛራቱ ኮይሮ ከሲደ ላኡ ባጋፐነ ጉየፐ ከስያ ላኡ ባጋፐ ግዱዋን ከስኖ፤ ያቲደ ባረንቱ ዱንካኔዳ ማራን ማራንነ ባረንቱ ባንድራ ባንድራ ካሊደ ከስኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","19","“ቃይ አዋይ ዉልያ ባጋና ኤፍሬማ ባጋይ ባረንቱ አርማ ካሊደ ዱንካንኖ። ኡንቱንቱ ዛራቱዋ ሱንꬃይ፥ ዛራቱዋ ካፓቱዋ ሱንꬃይነ ኦላንቻቱዋ ፓይዱ ሀዋፐ ካሌ: ኤፍሬማ አምሁዳ ናኣ ኤልሻማአ 40,500፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","21","ምናሳ ፓዳጹራ ናኣ ጋማልኤላ 32,200፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","23","ቢንያማ ጊድኦና ናኣ አብዳና 35,400፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ኤፍሬማ ባጋፐ ፓይደቴዳ ኦላንቻቱ ኡባና 108,100። ሀራ ሳኣ ብያ ዎደ፥ ኡንቱንቱ ሄዘንꬆ ከስያዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","26","“ቃይካ ሁጲሳ ባጋና ዳና ባጋይ ባረንቱ አርማ ካሊደ ዱንካንኖ። ኡንቱንቱ ዛራቱዋ ሱንꬃይ፥ ዛራቱዋ ካፓቱዋ ሱንꬃይነ ኦላንቻቱዋ ፓይዱ ሀዋፐ ካሌ: ዳና አምሻዳያ ናኣ አህኤዘራ 62,700፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","28","አሴራ ኦክራና ናኣ ፓግኤላ 41,500፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","30","ንፍታሌማ ኤናና ናኣ አህራአ 53,400፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ዳና ባጋፐ ፓይደቴዳ ኦላንቻቱ ኡባና 157,600፤ ሀራ ሳኣ ብያ ዎደ ኡንቱንቱ ዉርሰꬃን ባረ ባንድራን ከስያዋንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ባረ ያራን ያራን ሻከቲደ ፓይደቴዳ እስራኤልያ ኦላንቻቱ ኡባና 603,550. ");
INSERT INTO dwrENT_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ሽን መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ሌዋቱ ሀራ እስራኤላቱዋና ፓይደትበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","እስራኤላቱ መꬍና ጎዳይ ሙሳ አዛዜዳዋ ኡባባ ኦꬄድኖ። ስም ኡንቱንቱ ባረንቱ ባንድራ ካሊደ፥ ሄዋዳን ዱንካኔድኖ፤ ቃይ ባረንቱ ያራ ያራነ ባረንቱ ሶ አሳ አሳ ካሊደ፥ ሄዋዳን ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","መꬍና ጎዳይ ሲና ደርያ ቦላን ሙሴና ሃሳዬዳ ዎደ ደእያ አሮናነ ሙሴ ጎልያ አሳይ ሀዋፐ ካሊደ ጻፈቴዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","አሮና አቱማ ናናቱዋ ሱንꬃይ ባይራይ ናዳባ፥ አቢሀ፥ ኤልኣዛራነ እታማራ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ሄ አሮና አቱማ ናናይ ኡባይ ቄሰ ግዲደ ኦꬃናዉ ኦከቲደ ሱንቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ሽን ኡንቱንቱ ግዶፐ ናዳብነ አብሁ ሲና መላ ቢታን ጾሳይ አዛዝቤና ታማ ያርሺደ፥ መꬍና ጎዳ ስንꬃን ሀይቄድኖ፤ ኡንቱንቶ ናእ ባዋ። ሄዋ ድራዉ፥ ኡንቱንቱ አዉ አሮን ፓጻ ደኤዳ ላይꬃ ኡባን ኤልኣዛራነ እታማራ ጻላላይ ቄሰ ግዲደ ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ሌዋቱዋ ሃ አካ ያደ ቄስያ አሮና ማዳና ማላ፥ ኡንቱንታ አ ስንꬃ ሺሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ኡንቱንቱ አሮናዉነ እስራኤልያ ማባራዉ ኡባዉ ጾሳ ዱንካንያ ስንꬃን ዱማ ዱማ ኦሱዋ ኦꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ኡንቱንቱ ጾሳ ዱንካንያን ደእያ ሚሻ ኡባ አዎተꬃ አክኖ፤ እስራኤልያ አሳ ድራዉ ጾሳ ዱንካንያን ኦሶ ኡባ ኡንቱንቱ ኦꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ኔን ሌዋቱዋ አሮናነ አ አቱማ ናናቱዋ ማዳናዳን ሱንꬃ፤ ኡንቱንቱ እስራኤልያ ግዶፐ ኡባና አሮናዉ እመቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","አሮናነ አ አቱማ ናናቱዋ ቄሰ ኦꬃደ ሱንꬃ። ኡንቱንቱፐ ሀራ አሳይ ኦንነ ጾሳ ዱንካንያኮ ሺቆፐ፥ ሀይቆ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ቃይ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ታን እስራኤላቱዋ ማጫ አሳይ ባይራ የልያ አቱማ ናናቱዋ ኡባ ድራዉ እስራኤላቱዋ ግዶፐ ሌዋቱዋ አካድ። ሌዋቱ ታዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","አያዉ ጎፐ፥ ባይራ የለቴዳ ኡባይ ታዋ። ታን ግብጼ ጋድያን ባይራ የለቴዳዋ ኡባ ዎꬌዳ ጋላሳን፥ እስራኤላቱዋን ባይራ የለቴዳዋ ኡባ፥ አሳ ግድና፥ መህያ ግድና፥ ታዉ ዱማያድ፤ ኡንቱንቱ ታዋ ግዳና። ታን መꬍና ጎዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ቃይካ መꬍና ጎዳይ ሙሳ ሲና መላ ቢታን፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ኔን ሌዋቱዋ ኡንቱንቱ ሶ አሳን አሳንነ ኡንቱንቱ ያራን ያራን ፓይዳ፤ የለቶደፐ እት አግናነ ሄዋፐ ቦላና ደእያ አቱማዋንታ ኡባ ፓይዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","መꬍና ጎዳይ አዛዜዳዋዳን፥ ሙሴ ኡንቱንታ ፓይዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ሌዊያ አቱማ ናናይ ገርሾና፥ ቃሃታነ ማራራ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ገርሾና አቱማ ናናይ ሊብናነ ሽምአ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ቃሃታ አቱማ ናናይ አምራማ፥ ይጽሃራ፥ ከብሮናነ ኡዝኤላ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ማራራ አቱማ ናናይ ቃይ ማህላነ ሙሻ። ሌዋቱዋ ማይዛ አዎቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ሊብና ያራቱነ ሽምአ ያራቱ ገርሾና ዛራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ኡንቱንቱፐ ፓይድና፥ የለቶደፐ እት አግናነ ሄዋፐ ቦላና ደእያ አቱማዋንቱ ኡባና 7,500. ");
INSERT INTO dwrENT_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ገርሾና ያራቱ ጾሳ ዱንካንያፐ ጉየ አዋይ ዉልያ ባጋና ዱንካኒኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ገርሾና ያራቱዋ ሶ አሳ ካፑ ላኤላ ናኣ ኤልያሳፋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ገርሾና ያራቱ ጾሳ ዱንካንያ፥ ዱንካንያ ካምያዋንታ ገልያሳ ጋርዱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ዳባባ ጋርዳቱዋ፥ ጾሳ ዱንካንያነ ያርሽያ ሳኣ ዩሹዋን ደእያ ዳባባ ገልያሳን ጋርዱዋ፥ ዎዶሮቱዋነ ኡንቱንቱ ጎኣና ጋከትያባቱዋ ኡባባ አዎተꬃ አኪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","አምራማ ያራቱ፥ ይጽሃራ ያራቱ፥ ከብሮና ያራቱነ ኡዝኤላ ያራቱ ቃሃታ ዛራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","የለቶደፐ እት አግናነ ሄዋፐ ቦላና ደእያ አቱማዋንቱ ኡባና 8,600. ቃሃታ ያራቱ ጾሳ ዱንካንያ አዎተꬃ አኪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ቃሃታ ያራቱ ጾሳ ዱንካንያፐ ገድሳ ባጋና ዱንካኒኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ቃሃታ ያራቱዋ ሶ አሳ ካፑ ኡዝኤላ ናኣ ኤልጻፋና። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ኡንቱንቱ ታቦታ፥ ጻራጴዛ፥ ጾምፕያ ዎꬅያ ባላ፥ ያርሽያ ሳኣ፥ ኦꬅያ ዎደ ጎኤትያ ጾሳ ዱንካንያ ሚሻቱዋ፥ ጋርዱዋነ ኡንቱንቱ ጎኣና ጋከትያባቱዋ ኡባባ አዎተꬃ አኪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ሌዋቱዋ ካፓቱዋ ካፑ ቄስያ አሮና ናኣ ኤልኣዛራ፤ ጌሻ ሳኣ አዎትያዋንቱ ቦላ እ ሱንቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ማህላ ያራቱነ ሙሻ ያራቱ ማራራ ዛራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ኡንቱንቱፐ ፓይድና፥ የለቶደፐ እት አግናነ ሄዋፐ ቦላና ደእያ አቱማዋንቱ ኡባና 6,200. ");
INSERT INTO dwrENT_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ማራራ ያራቱዋ ሶ አሳ ካፑ አብሀይላ ናኣ ጹሪኤላ። ማራራ ያራቱ ጾሳ ዱንካንያፐ ሁጲሳ ባጋና ዱንካኒኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ማራራ ያራቱ ዱንካንያ ጻጋገቱዋ፥ ኩልቦቱዋ፥ ቱሳቱዋ፥ ገደቱዋ፥ ሄ ኦሶ ኮሽያ ሚሻቱዋ ኡባነ ኡንቱንቱ ጎኣና ጋከትያባቱዋ ኡባ አዎተꬃ አኪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ሄዋ ቦላካ ጉጂደ፥ ዩሹዋን ደእያ ዳባባ ቱሳቱዋነ ኡንቱንቱ ገደቱዋ፥ ሽካልያነ ዎዶሮቱዋ አዎተꬃ አኪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ቃይ ጾሳ ዱንካንያፐ ስንꬃ አዋይ ዶልያ ባጋና ሙሴ፥ አሮንነ አ አቱማ ናናይ ዱንካኒኖ። ኡንቱንቱ እስራኤላቱዋ ድራዉ ጾሳ ዱንካነ ግዶን ኦꬅያ ኦሱዋ አዎተꬃ አኪኖ። ሀራ አሳይ ጾሳ ዱንካንያኮ ሺቆፐ፥ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","መꬍና ጎዳይ አዛዝና፥ ሙሴነ አሮን ፓይዴዳ አቱማ ሌዋቱ፥ የለቶደፐ እት አግናነ ሄዋፐ ቦላና ደእያ አቱማዋንቱ ኡባና 22,000. ");
INSERT INTO dwrENT_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","መꬍና ጎዳይ ሙሳ፥ “እስራኤላቱዋ ባይራ አቱማ ናናቱዋ፥ የለቶደፐ እት አግናነ ሄዋፐ ቦላና ደእያዋንታ ኡባ ፓይዳደ ኡንቱንቱ ሱንꬃ ጻፋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","እስራኤላቱዋን ባይራ የለቴዳ ኡባ ኮታዉ ሌዋቱዋ ታዉ አካ፤ ቃይ እስራኤላቱዋ መህያን ባይራ የለቴዳ ኡባ ኮታዉ ሌዋቱዋ መህያ ታዉ አካ። ታን መꬍና ጎዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ሙሴ መꬍና ጎዳይ አ አዛዜዳዋዳን፥ እስራኤላቱዋን ባይራ የለቴዳ ኡባ ፓይዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","የለቶደፐ እት አግናነ ሄዋፐ ቦላና ደእያ ባይራ የለቴዳ አቱማዋንቱ፥ ሱንꬃይካ ጻፈቴዳዋንቱ ኡባና 22,273. ");
INSERT INTO dwrENT_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","መꬍና ጎዳይ ሙሳ ቃይካ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ሌዋቱዋ እስራኤልያ አቱማዋንቱ ኡባ ኮታዉ አካ፤ ሌዋቱዋ መሄቱዋ እስራኤላቱዋ መህያ ኮታዉ አካ፤ ሌዋቱ ታዋ ግዳናዋንታ። ታን መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ሌዋቱዋ ፓይዱዋፐ ዳርያ 273 ባይራ ግዲደ የለቴዳ እስራኤልያ አቱማ ናናቱዋ ዎዛናዉ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","እቶ እቶ እቼሹ ጻጋራ ብራ ጾሳ ዱንካንያን ኤረቲያ ሚዛንያ ልክያን አካ፤ እት ጻጋራ ብራይ ላታሙ ጌራ ኬሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ፓላሄዳ እስራኤላቱዋ ዎዝያ ሄ ሚሻ አሮናዉነ አ አቱማ ናናዉ እማ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ሙሴ፥ ሌዋቱዋን ዎዘቴዳዋንቱፐ ፓላሄዳዋንታ ዎዝያ ሚሻ ሺሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ባይራ የለቴዳ እስራኤላቱዋፐ 1,365 ጻጋራ ብራ ጾሳ ዱንካንያን ኤረቲያ ሚዛንያ ልክያን እ ሺሼዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","መꬍና ጎዳይ አዛዜዳ አዛዙዋዳን፥ ሙሴ ዎዝያ ሚሻ አሮናዉነ አ አቱማ ናናዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ሌዊያ ዛራቱዋን ቃሃታ ያራቱዋ ኡንቱንቱ ዳቡዋን ዳቡዋንነ ኡንቱንቱ ሶ አሳን አሳን ሻካደ ፓይዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","የለቶደፐ ላይꬃይ ሀታሙዋፐ ቢደ እሻታሙዋ ጋኬዳ አቱማ አሳ ኡባ፥ ጾሳ ዱንካንያ ግዶን ኦꬃናዉ ይያዋንታ ፓይዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ቃሃታ ያራቱ ጾሳ ዱንካንያ ግዶን ኦꬃና ኦሱ ሀዋ: ኡንቱንቱ ኡባፐ አꬌዳ ጌሻ ሚሻቱዋን አዎቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“አሳይ ዱንካኔዳ ሳፐ ባናዉ ሀንያ ዎደ፥ አሮንነ አ አቱማ ናናይ ጾሳ ዱንካንያ ግዶ ገሊደ፥ ታቦታ ስንꬃ ጋርዱዋ ካቁዋፐ ዎꬅኖ፤ ሄ ጫቁዋ ታቦታ አን ካምኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ሄ ካሜዳዋ ቦላካ ዎꬍያ እርባንያ ካምኖ፤ ሄዋ ቦላካ ቃይ ጉጂደ፥ ሳሉዋ ማላትያ ጫርቂያ ካምኖ፤ ቶክያ ካሶቱዋ ኡንቱንቱ ሳጋየቱዋን አꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“ጾሳ ስንꬃ ሺሽያ ኡክꬃ ዎꬅያ ጻራጴዛ ቦላን ሳሉዋ ማላትያ ጫርቂያ ሂጽኖ፤ አ ቦላ ሳነቱዋ፥ ጭልፓቱዋ፥ ጹአቱዋነ ኡሻ ያርሾ ጎኤትያ ኦቶቱዋ ዎꬅኖ፤ ቃይ ኡክꬃይ ኡባ ዎደካ አ ቦላፐ ꬋዮፖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ሄዋ ቦላን ዞኦ ጫርቂያ ሂጺደ፥ እርባንያ ቃይ አ ቦላ ካምኖ፤ ቶክያ ካሶቱዋ ሳጋየቱዋን አꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“ኡንቱንቱ ሳሉዋ ማላትያ ጫርቂያ አኪደ፥ ጾምፕያ ዎꬅያ ባላቱዋ ጾምፐቱዋና፥ ቶይስያ ቃጰቱዋና፥ ኡንቱንታ ዎꬅያባቱዋናነ ዛይትያ ትግያ ጻሮቱዋናካ ኡባ ካምኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ያቲደ አካ ሚሻቱዋ ኡባካ እርባንያን ካሚደ፥ ቶክያ ሻንቻማ ቦላን ዎꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“እጻና ጩውስያ ዎርቃ ሳጽንያ ቦላን ሳሉዋ ማላትያ ጫርቂያ ሂጼዳዋ ቃይ እርባንያን ካምኖ፤ ቶክያ ካሶቱዋ ኡንቱንቱ ሳጋየቱዋን አꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ሄዋዳንካ፥ ቃይ ጾሳ ዱንካንያ ግዶን ጎኤትያ ሚሻቱዋ ኡባ አኪደ፥ ሳሉዋ ማላትያ ጫርቂያን ጻጽኖ፤ እርባንያን ካሚደ፥ ቶክያ ሻንቻማ ቦላን ዎꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“ያቲደ ናሃስያፐ ኦꬄዳ ያርሽያ ሳኣ ቦላ ደእያ ብድንꬃ ድጊደ አ ቦላ ኦቻ ቴራ ማላትያ ጫርቂያ ሂጽኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","አ ቦላ ያርሽያሳን ጎኤትያ ሚሻቱዋ ኡባ፥ ታማ ጮጨቱዋ፥ አሹዋ ቃጲያ ቃጰቱዋ፥ አካፋቱዋነ ካሽያ ኩይጻሮቱዋ ዎꬅኖ። እርባንያን ካምኖ፤ ቶክያ ካሶቱዋ ኡንቱንቱ ሳጋየቱዋን አꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“አሮንነ አ አቱማ ናናይ፥ ጌሻባቱዋነ ጌሻ ሚሻቱዋ ኡባ ካሚደ ማኮፐነ ዱንካኔዳ ሳኣፐ ደንድያ ዎዲ ጋኮፐ፥ ሄዋ ኡባ ቶካናዉ ቃሃታ ያራቱ ዪኖ። ሽን ጌሻ ሚሻቱዋ ኡንቱንቱ ቦቾፐ ሀይቂኖ። ጾሳ ዱንካንያ ግዶን ደእያ ሄ ሚሻ ቃሃታ ያራቱ ቶክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“ቄስያ አሮና ናአይ ኤልኣዛር ጾምፕያ ዛይትያዉ፥ ሳዊያ እጻናዉ፥ ሀች ሀች ያርሽያ ካꬃ ያርሹዋነ ኦክያ ዛይትያዉ፥ ቃይ ጾሳ ዱንካንያ ሙልያነ አ ግዶን ደእያ ዱማ ጌሻ ሚሻቱዋ ኡባ ቦላ አዋቶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ቃይ መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ቃሃታ ያራቱ ሌዊያ ዛራቱዋፐ ሀይቂደ ꬋየና ማላ ጼልተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ኡባፐ አꬌዳ ጌሻ ሚሻ ማታ ሺቅያ ዎደ፥ ኡንቱንቱ ሀይቀናን ፓጻ አቲደ ደአና ማላ፥ ኡንቱንቶ ሀዋዳን ኦꬅተ: አሮንነ አ አቱማ ናናይ ጾሳ ዱንካንያ ግዶ ገሊደ ቃሃታ ያራቱ ኡባይ ሁጲያን ሁጲያን ኦꬃና ኦሱዋነ ቶካና ቶኩዋ ሻክ ሻኪደ ግሽኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ቃሃታ ያራቱ ሀይቀናዳን፥ ኡባፐ አꬍያ ጌሻቱዋ ቄሳቱ ጻጽሽን በአናዉ ግዱዋ ገሎፕኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“ገርሾና ያራቱዋካ ኡንቱንቱ ዳቡዋን ዳቡዋንነ ኡንቱንቱ ሶ አሳን አሳን ሻካደ ፓይዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","የለቶደፐ ላይꬃይ ሀታሙዋፐ ቢደ እሻታሙዋ ጋኬዳ አቱማ አሳ ኡባ፥ ጾሳ ዱንካንያ ግዶን ኦꬃናዉ ይያዋንታ ፓይዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“ገርሾና ያራቱ ኦꬅያ ኦሱነ ቶክያ ቶኩ ሀዋ: ");
INSERT INTO dwrENT_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ኡንቱንቱ ጾሳ ዱንካንያ ጋርዳቱዋ፥ ጾሳ ዱንካንያ፥ አ ካምያባቱዋነ ቦላና ካምያ እርባንያ፥ ጾሳ ዱንካንያ ገልያሳን ሶትያ ጋርዱዋ ቶክኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ቃይ ጾሳ ዱንካንያነ ያርሽያ ሳኣ ዩይ አꬌዳ ዳባባ ጋርዳቱዋ፥ ዳባባ ገልያሳ ጋርዱዋ፥ ዎዶሮቱዋነ ኡንቱንቶ ጎእያ ሚሻቱዋ ኡባ ቶክኖ። ገርሾና ያራቱ ሀ ሚሻቱዋን ኦꬃናዉ በስያ ኦሱዋ ኡባ ኦꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ቶክያዋ ግድና፥ ሀራ ኦሱዋ ግድናካ ኡንቱንቱ ኦꬅያ ኦሱዋ ኡባይ አሮንነ አ አቱማ ናናይ ኡንቱንታ አዛዝና ኦሰትኖ። ኔን ኡንቱንቱ ቶካናዉ በስያባቱዋ ኡባ ኡንቱንቱ አዎተꬃ አዎተꬃዳን ኡንቱንቶ ግሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ጾሳ ዱንካንያ ግዶን ገርሾና ያራቱ ኦꬃና ኦሱ ኡባይ ሀዋ። ኡንቱንቱ ኦꬃና ኦሱዋ ኡባይ ቄስያ አሮና ናኣ እታማራ አዎተꬃ ጋርሳና ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“ማራራ ያራቱዋ ኡንቱንቱ ዳቡዋን ዳቡዋንነ ኡንቱንቱ ሶ አሳን አሳን ሻካደ ፓይዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","የለቶደፐ ላይꬃይ ሀታሙዋፐ ቢደ እሻታሙዋ ጋኬዳ አቱማ አሳ ኡባ፥ ጾሳ ዱንካንያ ግዶን ኦꬃናዉ ይያዋንታ ፓይዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","“ኡንቱንቱ ጾሳ ዱንካንያ ግዶን ኦꬃና ኦሶቱ ሀዋንታ: ኡንቱንታ ዱንካንያ ጻጋገቱዋ፥ ኩልቦቱዋ፥ ቱሳቱዋነ ገደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ቃይካ ዳባባ ዩሹዋን ኤቂያ ቱሳቱዋ፥ ሄ ቱሳቱ ገደቱዋ፥ ቶልያ ጻጋገቱዋ፥ ዎዶሮቱዋ፥ ሄዋንቶ ኮሽያ ሚሻቱዋ ኡባነ ሄ ሚሻቱዋና ጋከትያባቱዋ ኡባ ቶክኖ። እት እት ኡራዉ እ ቶካናዋ ሻካደ ግሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ጾሳ ዱንካንያ ግዶን ማራራ ያራቱ ኦꬃና ኦሱ ኡባና ሀዋ። ኡንቱንቱ ኦꬃና ኦሶ ኡባይ ቄስያ አሮና ናኣ እታማራ አዎተꬃ ጋርሳና ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ሙሴ አሮንነ ማባራ ካፓቱ ቃሃታ ያራቱዋ አቱማ አሳ ኡንቱንቱ ዳቡዋን ዳቡዋንነ ኡንቱንቱ ሶ አሳን አሳን ሻኪደ ፓይዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","የለቶደፐ ላይꬃይ ሀታሙዋፐ ቢደ እሻታሙዋ ጋኬዳ አቱማ አሳቱ ኡባቱ፥ ጾሳ ዱንካንያ ግዶን ኦꬃናዉ ይያዋንቱ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ኡንቱንቱ ሶ አሳን አሳን ፓይድና ኡባና 2,750. ");
INSERT INTO dwrENT_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ቃሃታ ያራቱዋን ጾሳ ዱንካንያ ግዶን ኦꬄዳ አሳ ፓይዱ ሀዋ። መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳዋዳን፥ ሙሴነ አሮን ኡንቱንታ ፓይዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ገርሾና ያራቱካ ባረንቱ ዳቡዋን ዳቡዋንነ ባረንቱ ሶ አሳን አሳን ሻከቲደ ፓይደቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","የለቶደፐ ላይꬃይ ሀታሙዋፐ ቢደ እሻታሙዋ ጋኬዳ አቱማ አሳቱ ኡባቱ፥ ጾሳ ዱንካንያ ግዶን ኦꬃናዉ ይያዋንቱ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ኡንቱንቱ ሶ አሳን አሳን ፓይድና ኡባይ 2,630. ");
INSERT INTO dwrENT_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ገርሾና ያራቱዋን ጾሳ ዱንካንያ ግዶን ኦꬄዳ አሳ ፓይድና ሀዋ። መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳዋዳን፥ ሙሴነ አሮን ኡንቱንታ ፓይዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ማራራ ያራቱካ ቃይ ዳቡዋን ዳቡዋንነ ባረንቱ ሶ አሳን አሳን ሻከቲደ ፓይደቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","የለቶደፐ ላይꬃይ ሀታሙዋፐ ቢደ እሻታሙዋ ጋኬዳ አቱማ አሳቱ ኡባቱ፥ ጾሳ ዱንካንያ ግዶን ኦꬃናዉ ይያዋንቱ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ኡንቱንቱ ሶ አሳን አሳን ፓይድና ኡባይ 3,200. ");
INSERT INTO dwrENT_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ማራራ ያራቱዋ ፓይዱ ሀዋ። መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳዋዳን፥ ሙሴነ አሮን ኡንቱንታ ፓይዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ሄዋ ኦꬂደ ሙሴ፥ አሮንነ እስራኤልያ ካፓቱ ሌዋቱዋ ኡባ፥ ኡንቱንቱ ያራን ያራንነ ኡንቱንቱ ሶ አሳን አሳን ሻኪደ ፓይዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","የለቶደፐ ላይꬃይ ሀታሙዋፐ ቢደ እሻታሙዋ ጋኬዳ አቱማ አሳቱ ኡባቱ፥ ጾሳ ዱንካንያ ግዶን ኦሱዋ ኦꬃናዉነ አዉ ጎእያ ሚሻቱዋ ኡባ ቶካናዉ ዬዳዋንቱ ");
INSERT INTO dwrENT_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ኡባይ 8,580. ");
INSERT INTO dwrENT_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳዋዳን፥ ኡንቱንቱ ሁጲያን ሁጲያን ኦꬃና ኦሱ ዎይ ቶካና ቶኩካ ኡንቱንቶ ኦደቴዳ። መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ኡንቱንቱ ኡባይካ ፓይደቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፦ ");
INSERT INTO dwrENT_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ኔን እስራኤላቱዋ፥ ‘ህንተ ግዶን ዎልቃማ ጋልባ ሀርጊ ኦይቄዳ ኡራ፥ ዎይ ቦላፐ አያይኔካ ጎግያ ኡራ፥ ዎይ አሃ ኦይቂደ ቱኔዳ ኡራ ኦናካ ህንተ ዱንካኔዳ ሳኣፐ ከስ ድግተ’ ያጋደ አዛዛ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ሄዌ ማጫዋ አቱማዋ ግድናካ ከስኖ። ታን ኡንቱንቱ ግዱዋን ደእያ ኡንቱንቱ ዱንካኔዳሳ ሄዋንቱ ቱንሰና ማላ፥ ኡንቱንቱ ዱንካኔዳ ሳኣፐ ከሳ የዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ እስራኤላቱ ኡንቱንቱ ኡባ ዱንካኔዳ ሳኣፐ ከሲደ የዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ኔን እስራኤላቱዋ ሀዋዳን ያጋ፤ ‘እት አቱማ አሳይ ዎይ እት ማጫ አሳይ አይ ኦግያንነ ሀራ አሳ ናቆፐነ ሄዋን መꬍና ጎዳዉ አማነተናን እጾፐ፥ ሄ ኡራይ ባይዛንቻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ሄዋ ድራዉ፥ እ ባረ ኦꬄዳ ናጋራ ፓጾ፤ ባረ ባይዜዳዋ ኩመንꬃ ዛሪደ ጭጎ፤ ሄዋ ቦላካ እቼሸንꬆ ኩሽያ ጉጂደ፥ ባረ ናቄዳ ኡራዉ አጮ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ሽን ሄ ናቀቴዳ ኡራይ ሀይቄዳዋ ግዶፐነ፥ አጫ አካናዉ አዉ ማታ ዳቡ ꬋዮፐ፥ ሄ አጫይ መꬍና ጎዳሳ። ሄ አጭያ አጫይ ናቄዳ ኡራይ ማረታናዉ ያርሾ እምያ ዶርሳ ኦርግያና እትፐ ቄስያዉ እመቶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ቃይ እስራኤላቱ ቄስያዉ እምያ ጌሻ እሙዋ ኡባይ ሄ ቄስያሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","እት እት አሳይ እምያ እሞታይ ሄ እሜዳ ኡራባ፤ ሽን ቄስያዉ እ እምያ እሞታይ ሄ ቄስያሳ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ኔን እስራኤላቶ ሀዋዳን ያጋደ ኦዳ፤ ‘እት ኡራ ማቻታ ካረ ሀመታደ፥ አዉ አማነተናን እጻደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ሀራ አቱማ አሳና ግሶፐ፥ ቃይ ሄዋ እዛ ባረ አስናፐ ቆሶፐ፥ ማርካይ ባይናዋ ግዶፐነ፥ እዛ ሻርሙጻደ ኦይቀተናን አቶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","እዛ ቱኔዳ ድራዉ፥ እ ጎልያዉ እዞ ስꬍያዋ ግዳናዉ ዳንዳዬ፤ ዎይ እዛ ቱነናን ደእሽን፥ እ ባረ ማቻቶ ስꬍያዋ ግዳናዉ ዳንዳዬ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ያቶፐ፥ ሄ ብታኒ ባረ ማቻቶ ቄስያኮ አፎ፤ ቃይ እዝ ድራዉ ያርሻናዉ እት ኪሎ ግራመ ባንጋ ꬊልያ አፎ። ሽን ꬊልያ ቦላ ዛይትያ ትጎፖ፥ ዎይ እጻና አ ቦላ ዎꬆፖ፤ አያዉ ጎፐ፥ ሄ ꬊሊ እ ባረ ማቻቶ ስꬌዳ ድራዉ ያርሽያ ካꬃ ያርሾ፤ ቃይ ሄዌ ባይዙዋ ቆንጭስያ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘ሄዋፐ ጉይያን፥ ቄሲ ሄ ምሽራቶ ሺሺደ፥ መꬍና ጎዳ ስንꬃን ኤሶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","አንጀቴዳ ሃꬃ ኩይጻሩዋን አኮ። ሄዋፐ ጉይያን፥ ጾሳ ዱንካንያ ዉይግያን ደእያ ባና አኪደ፥ ሄ ሃꬃን ጉጆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ሄ ምሽራቶ መꬍና ጎዳ ስንꬃን ኤሶ፤ ሄዋፐ ጉይያን፥ ሄ ምሽራት ሁጲያ ብሎ፤ ስꬌዳ ድራዉ ያርሽያ እዝ ባይዙዋ ቆንጭስያ ካꬃ ያርሹዋ እዝ ኩሽያን ዎꬆ፤ ቃይ ሄ ቄሲ ባረ ኩሽያን ሸቃ አህያ ጫሞ ሃꬃ ኩይጻሩዋና ኦይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ምሽራቶ ሀዋዳን ያጊደ ጫቀꬆ፤ “ኔን ሀራ አቱማ አሳና ግሳቤናዋ ግዶፐነ፥ ነ አስና አጋደ ካረ ሀመታደ ቱናቤናዋ ግዶፐ፥ ሸቃ አህያ ሀ ጫሞ ሃꬃይ ነዉ ጎመቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ሽን ኔን ነ አስና አጋደ ካረ ሀመታደ ቱኔዳዋ ግዶፐነ፥ ሀራ አቱማ አሳና ግሴዳዋ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","መꬍና ጎዳይ ነ የሉዋ ጎልያ ጉንድስያዋንነ ነ ኡሉዋካ ጋፍስያዋን፥ ነ አሳን ኔና ሸቅሶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ሀ ሸቃ አህያ ሃꬃይ ነ ኡሎ ግዶ ገሊደ ነ ኡሉዋ ጋፍሶ፤ ነ የሉዋ ኬꬃካ ጉንድሶ” ያጊደ ጫቀꬆ። “ ‘ምሽራታካ፥ “አመንእ፤ አመንእ” ያጉ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘ሄዋፐ ጉይያን፥ ቄሲ ሀ ሸቃቱዋ ጻጸቴዳ ማጻፋን ጻፎ፤ ሸቃቱዋ ጫሞ ሃꬃ ግዶ ሜጮ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ያቲደ ሸቃ አህያ ሄ ጫሞ ሃꬃ ምሽራቶ ኡሾ፤ ሸቃ አህያ ሃꬃይ ምሽራት ኡሉዋን ገሊደ፥ እዞ ጫሞ ሳኩዋ ሳካና። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ቄሲ ምሽራት ኩሽያፐ ስꬌዳ ድራዉ ያርሽያ ካꬃ ያርሹዋ አኪደ፥ ሄ ያርሹዋ መꬍና ጎዳ ስንꬃን ቃꬂደ፥ ያርሽያ ሳኣ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ቄሲ ካꬃ ያርሹዋፐ ኮጵያዋ አኪደ ባይዛንቻ ግደከንቶ ቆንጭስያ ያርሹዋ ኦꬂደ፥ ያርሽያሳን ጹጎ። ሄዋፐ ጉይያን፥ ምሽራቶ ሄ ሃꬃ ኡሾ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ሃꬃ እዞ ኡሼዳዋፐ ጉይያን፥ ሀዋዳን ሀናና: እዛ ባረ አስናዉ አማነታና ꬋያደ ቱኔዳዋ ግዶፐ፥ ሸቃ አህያ ሃꬃይ እ ኡሉዋን ገሊደ፥ እዞ ጫሞ ሳኩዋ ሳካና፤ እዝ ኡሉካ ጋፋና፤ እዝ የሉዋ ጎሊካ ጉንዳና። እዛ ባረ አሳን ሸቀቴዳኖ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ሽን እዛ ቱናቤና ጽሎ ማጫ አሳ ግዶፐ፥ አ ሳሮ አታደ ናናቱዋ የላና። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","“ ‘እት አሳይ ባረ ማቻቶ ስꬍያ ዎደ ኦꬃና ዎጋይ ሀዋ። እዛ ካረ ሀመታደ ቱኖፐ፥ ዎይ እት አሳይ ባረ ማቻቶ ስꬎፐ፥ መꬍና ጎዳ ስንꬃን እዞ ኤሲደ ቄሲ ሀ ዎጋ ኡባ እዝ ቦላ ፖሎ። ");
INSERT INTO dwrENT_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","አስናይ ባይዙዋ ኡባፐ ሳሮ አታና፤ ሽን ማጫውኖ ባረ ናጋራ ጋሱዋን ይያዋ ቶካና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ኔን እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘አቱማ አሳይ ዎይ ማጫ አሳይ ናዝራዌ ግዲደ፥ ባረና መꬍና ጎዳዉ ዱማያናዉ ገፖፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ዎይንያ ኤሳነ ሀራ ማꬆይያ ኡሻ ኡሾፖ፤ ዎይንያ አይፍያፐ አገትያ ጫላባነ ማꬆይያባ ኡሾፖ፤ ዎይንያ ቴራ ጉምኤዳዋ ኡሾፖ። ዎይ ዎይንያ ቴራ ሹጉዋ ግድና፥ መላ ግድናካ ሞፖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","እ ባረና ዱማዬዳ ዎድያን ኡባን፥ ዎይንያ ቱራፐ ቤትያዋ ኡባ፥ ዎይንያ ዘረꬃ ግድና፥ ዎይ ዎይንያ ፖቁዋ ግድናካ ሞፖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘እ ባረና መꬍና ጎዳዉ ዱማያናዉ ገፔዳ ዎድያን ኡባን፥ አ ሁጲ ሜደቶፖ ዎይ ቃንጸቶፖ። እ ባረ ሁጲያ ብናናካ አዱሲደ ድቾ። እ ባረና መꬍና ጎዳዉ ዱማዬዳ ዎዲ ፖለታና ጋካናዉ፥ ጌሻ ግዳናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘እ ባረና መꬍና ጎዳዉ ዱማዬዳ ዎድያን ኡባን አሃኮ ሺቆፖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ሀራይ አትና አ አዉ፥ ዎይ አ ዳያ፥ ዎይ አ እሻይ፥ ዎይ አ ምቻታ ሀይቆፐካ፥ እ ባረና ቱንሶፖ። አያዉ ጎፐ፥ እ ባረና ጾሳዉ ዱማዬዳዋ ኤርስያዌ ባረ ሁጲያና። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","እ ባረና ጾሳዉ ዱማዬዳ ዎድያን ኡባን እ መꬍና ጎዳዉ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘አሳይ አ ማታን አኬከናን ሀይቂና፥ ጾሳዉ ዱማዬዳ አ ሁጲ ቱኖፐ፥ ላፑን ጋላሳ ጋምኢደ፥ ባረ ጌይያ ሄ ላፑንꬃ ጋላስ ባረ ሁጲያ ሜደቶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ሆስፑንꬃ ጋላሳን ላኡ ሀራጰቱዋ ዎይ ላኡ ማራ ሀራጰቱዋ ጾሳ ዱንካንያ ፐንገ ቄስያዉ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ቄሲ ሀራጰቱዋፐ እቱዋ ናጋራ ያርሾ፥ እቱዋ ቃይ ጹግያ ያርሾ ያርሾ። አያዉ ጎፐ፥ አሃይ አ ማታ ሺቄዳ ባይዙዋ ድራዉ፥ አዉ አቶ ጊሳናሳ። ሄ ጋላስ እ ባረ ሁጲያ ዎጋዳን ጌሾ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","እ ባረና ካሰ ገፔዳ ዎድያ ኬና ባረና ጾሳዉ ዱማያናዉ ኮሼ። ያቲደ የለቶደፐ እት ላይꬃ ግድያ አቱማ ዶርሳ ናቆ እምያ ያርሹዋ ኦꬂደ ያርሾ። ሽን ሄዋፐ ካሰ እ ባረና ጾሳዉ ዱማዬዳ ጋላሳቱ ፓይደትክኖ፤ አያዉ ጎፐ፥ እ ባረና ዱማዬዳ ሄ ዎደቱዋ ግዶን ባረና ቱንስ ድጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘ባረ ገፋ ዎድያ ዉርሴዳ ዎደ ባረና ጾሳዉ ዱማዬዳ ናዝራዊያ ዎጋይ ሀዋ: ጾሳ ዱንካንያ ፐንገ እ ሺቆ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","መꬍና ጎዳዉ ትላ ቦላና ደእያ እት ላይꬃ አቱማ ዶርሳ ጹግያ ያርሾ፥ ትላ ቦላና ደእያ እት ላይꬃ ዶርሳቶ ናጋራ ያርሾነ ትላ ቦላና ደእያ ዶርሳ ኦርግያ እትፐተꬃ ያርሾ ሄ ሳኣ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ቃይ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ኡንቱንቱና እትፐ ያርሻናዉ አሆ፤ ሄ ካꬃ ያርሹ እርሹ ገልቤናዋ ግዶ፤ ቃይ ዛይትያን ሙናቄዳ ሊቆ ꬊልያ ኮምፖቱዋነ ዛይትያ ኦከቴዳ ሌኦ ኡክꬃቱዋ ማሶፍያን አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘ቄሲ ሄዋ ኡባ ሺሺደ፥ ናጋራ ያርሹዋነ ጹግያ ያርሾ ኦꬂደ፥ መꬍና ጎዳዉ አ ድራዉ ያርሾ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ቄሲ ዶርሳ ኦርግያ፥ እርሹ ገልቤና ኮምፖቱዋነ ኡክꬃቱዋ እትፐተꬃ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳዉ ያርሾ። ቃይ ሄዋና እትፐ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ያርሾ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ሄዋፐ ጉይያን፥ ናዝራዊ ጾሳዉ ዱማዬዳ ባረ ሁጲያ ጾሳ ዱንካንያ ፐንግያን ሜደቶ፤ ሜደቴዳ ብናና አፊደ፥ እትፐተꬃ ያርሹዋፐ ጋርሳ ባጋና ደእያ ታማን የጎ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘ባረና ጾሳዉ ዱማዬዳ ናዝራዊ ባረ ሁጲያ ሜደቴዳዋፐ ጉይያን፥ ቄሲ ዶይሰቴዳ ዶርሳ ኦርግያ ምሳ፥ እርሹ ገልቤና እት ኮምፑዋነ እት ሌኦ ኡክꬃ አኪደ፥ ሀ ናዝራውያ ኩሽያን ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ቄሲ ኡንቱንታ ቃꬅያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳ ስንꬃን ቃꬆ። ያቶፐ ሄዋንቱ ዉጻኬዳ አንጎሱዋናነ ያርሼዳ ገድያና ጌሻነ ቄስያሳ። ሄዋፐ ጉይያን፥ መꬍና ጎዳዉ ባረና ዱማዬዳ ናዝራዊ ዎይንያ ኤሳ ኡሻና ጎፐ ኡሾ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘ስም ጾሳዉ ባረና ዱማያናዉ ገፔዳ ናዝራውያዉ ዎꬆ ዎጋይ ሀዋ: ባረና መꬍና ጎዳዉ ያርሻናዉ ኮሽያ ያርሾቱዋፐ አꬍያዋ እማናዉ ገፔዳዋ ግዶፐ፥ እ ባረ ገፔዳ ገፋ ኬና ጋꬃናዉ ኮሼ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“አሮናዉነ አ አቱማ ናናቶ ሀዋ ኦዳ፤ ‘እስራኤልያ አሳ ህንተ ሀዋዳን ያጊደ አንጅተ፦ ");
INSERT INTO dwrENT_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“መꬍና ጎዳይ ህንተና አንጆነ ህንተና ናጎ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","መꬍና ጎዳይ ህንተንቶ ባረ ሶምኡዋ ፖእሶነ ህንተንቶ ቃረቶ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","መꬍና ጎዳይ ህንተና ባረ ኬካ አይፍያን ጼሎነ ህንተንቶ ሳሮተꬃ እሞ” ያጊደ አንጅተ’ ያጋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“ሀዋዳን ኡንቱንቱ እስራኤልያ አሳ ቦላ ታ ሱንꬃ ዎꬃና፥ ታን ኡንቱንታ አንጃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ሙሴ ጾሳ ዱንካንያ ቶሊደ ማኬዳ ዎደ፥ ሄ ዱንካንያነ አ ሚሻ ኡባ ኦኪደ ጌሼዳ፤ ቃይ ያርሽያ ሳነ አ ሚሻ ኡባካ ኦኪደ ጌሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ሄዋፐ ጉይያን፥ እስራኤልያ አሳ ካለꬄዳዋንቱ፥ ሄዋንቱነ ዛራቱዋ ፓይዴዳ ሶ አሳ ካፖቱ እሞታ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","መꬍና ጎዳዉ እሞታ ሺሼድኖ፤ ሄዋንቱካ ካመቴዳ ኡሱፑን ጋረቱዋ፥ ታማነ ላኡ ቦራቱዋ፥ ካፑዋን ካፑዋን እት እት ቦራነ ላኡ ላኡ ካፖቱ እት እት ጋርያ ጾሳ ዱንካንያ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ጾሳ ዱንካንያ ኦሶ ጎአና ማላ፥ ኔን ሄዋንታ ኡንቱንቱፐ አካደ፥ ሌዋቶ ኡንቱንቱ ኦሶ ኦሶ ኮሽያዋዳን ሻካደ እማ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ሙሴ ጋረቱዋነ ቦራቱዋ አኪደ፥ ሌዋቶ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ገርሾና ያራቶ ኡንቱንቱ ኦሶ ኮሽያዋዳን ሻኪደ፥ ላኡ ጋረቱዋነ ኦይዱ ቦራቱዋ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ቃይ ማራራ ያራቶ ኡንቱንቱ ኦሶ ኮሽያዋዳን ሻኪደ፥ ኦይዱ ጋረቱዋነ ሆስፑን ቦራቱዋ እሜዳ። ኡንቱንቱ ኡባይካ ቄስያ አሮና ናኣ እታማራ አዎተꬃ ጋርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ሽን ሙሴ ቃሃታ ያራቶ ሄዋፐ አያነ እምቤና፤ አያዉ ጎፐ፥ ኡንቱንቱ አዎተꬃን ደእያ ጌሻ ሚሻቱ ባረንቱ ሀሽያን ቶካናዉ ኮሽያዋንታ ግድያ ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ያርሽያ ሳ ሙሴ ኦኪደ ጌሼዳ ጋላሳን፥ ካፖቱ ያርሽያ ሳኣ አንጅሳናዉ ባረንቱ እሙዋ አኪደ፥ ሄ ያርሹዋ ሳኣ ስንꬃ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","መꬍና ጎዳይ ሙሳ ካሰ፥ “እት እት ጋላስ እት ካፑ ያርሽያ ሳኣ አንጃናዉ ባረ እሙዋ ጾሳዉ እሞ” ያግ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ኮይሮ ጋላስ ባረ እሙዋ አሄዳዌ ይሁዳ ዛርያፐ አምናዳባ ናኣ ናአሶና። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ናአሶን አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ፥ እጻናይ ኩሜዳ ሻታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ጹግያ ያርሾ፥ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ናጋራ ያርሾ እት ዴሻ ኦርግያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። አምናዳባ ናአይ ናአሶን አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ላኤንꬃ ጋላስ ይሳኮራ ዛራቱ ካፑ፥ ጹኣራ ናአይ ናታንኤል ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ናታንኤል አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ፥ እጻናይ ኩሜዳ ሻታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ናጋራ ያርሾ እት ዴሻ ኦርግያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። ጹኣራ ናአይ ናታንኤል አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ሄዘንꬃ ጋላስ ዛብሎና ዛራቱ ካፑ፥ ሄሎና ናአይ ኤልኣብ ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ኤልኣብ አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ ዛይትያን ሙናቀቴዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ፥ እጻናይ ኩሜዳ ሻታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ናጋራ ያርሾ እት ዴሻ ኦርግያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። ሄሎና ናአይ ኤልኣብ አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ኦይደንꬆ ጋላስ ሮቤላ ዛራቱ ካፑ ሻደኡራ ናአይ ኤሊጹር ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ኤሊጹር አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ፥ እጻናይ ኩሜዳ ሻታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ናጋራ ያርሾ እት ዴሻ ኦርግያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። ሻደኡራ ናአይ ኤሊጹር አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","እቼሻንꬃ ጋላስ ስሞና ዛራቱ ካፑ፥ ጹሪሻዳያ ናአይ ሻሉምኤል ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ሻሉምኤል አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ እጻናይ ኩሜዳ ሻታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ፥ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ናጋራ ያርሾ እት ዴሻ ኦርግያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። ጹሪሻዳያ ናአይ ሻሉምኤል አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ኡሱፑንꬃ ጋላስ ጋዳ ዛራቱ ካፑ፥ ረኡኤላ ናአይ ኤልያሳፍ ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ኤልያሳፍ አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ እጻናይ ኩሜዳ ሻታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ናጋራ ያርሾ እት ዴሻ ኦርግያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። ረኡኤላ ናአይ ኤልያሳፍ አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ላፑንꬃ ጋላስ ኤፍሬማ ዛራቱዋ ካፑ አምሁዳ ናአይ ኤልሻማእ ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ኤልሻማእ አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ እጻናይ ኩሜዳ ሻታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ፥ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ናጋራ ያርሾ እት ዴሻ ኦርግያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። አምሁዳ ናኣ ኤልሻማአ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ሆስፑንꬃ ጋላስ ምናሰ ዛራቱ ካፑ ፓዳጹራ ናአይ ጋማልኤል ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ጋማልኤል አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ልቆ ꬊሊ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ እጻናይ ኩሜዳ ሻታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ፥ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ናጋራ ያርሾ እት ዴሻ ኦርግያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። ፓዳጹራ ናአይ ጋማልኤል አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ኡዱፑንꬃ ጋላስ ቢንያማ ዛራቱ ካፑ ጊድኦና ናአይ አብዳን ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","አብዳን አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ፥ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ፥ እጻናይ ኩሜዳ ሻታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ጹግያ ያርሾ እት ኮሩማ እት ዶርሳ ኦርግያነ፥ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ናጋራ ያርሾ እት ዴሻ ኦርግያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ፥ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። ጊድኦና ናአይ አብዳን አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ታማንꬃ ጋላስ ዳና ዛራቱ ካፑ አምሻዳያ ናአይ አህኤዘር ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","አህኤዘር አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ፥ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ፥ እጻናይ ኩሜዳ ሻታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ፥ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ናጋራ ያርሾ እት ዴሻ ኦርግያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። አምሻዳያ ናአይ አህኤዘር አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ታማነ እተንꬃ ጋላስ አሴራ ዛራቱ ካፑ ኦክራና ናአይ ፓግኤል ባረ ያርሹዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ፓግኤል አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሾ ያርሻናዉ ሊቆ ꬊሊ፥ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ ሻታ፥ እጻናይ ኩሜዳዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ናጋራ ያርሾ እት ዴሻ ኦርግያ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። ኦክራና ናአይ ፓግኤል አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ታማነ ላኤንꬆ ጋላስ ንፍታሌማ ዛራቱ ካፑ ኤናና ናአይ አህራእ ባረ እሙዋ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","አህራእ አሄዳ እሙ ኤረቴዳ ሚዛናን ዎꬅና፥ እት ኪሎ ግራመነ ባጋ ዴጽያ ብራፐ መꬌዳ እት ከርያነ ሆስፑን ጼቱ ግራመ ዴጽያ ብራፐ መꬌዳ እት ኩይጻሩዋ፥ ላኡካ ካꬃ ያርሹዋ ያርሻናዉ ሊቆ ꬊሊ፥ ዛይትያን ሙናቄዳዌ ኩሜዳዋንታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ቃይ እት ጼታነ ታሙ ግራመ ዴጽያ ዎርቃፐ መꬌዳ እት ሻታ፥ እጻናይ ኩሜዳዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃይ ኩሜዳ አቱማ ዶርሳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ናጋራ ያርሾ እት ዴሻ ኦርግያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","እትፐተꬃ ያርሾ ላኡ ኮሩማቱዋ፥ እቼሹ ዶርሳ ኦርገቱዋ፥ እቼሹ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ እቼሹ አቱማ ዶርሳቱዋ። ኤናና ናአይ አህራእ አሄዳ እሙ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ያርሽያ ሳአይ ኦከቴዳ ዎደ፥ እስራኤላቱዋ ካፓቱ ያርሽያ ሳኣ አንጃናዉ አሄዳ እሞታይ ኡባና ሀዋንታ: ብራፐ መꬌዳ ታማነ ላኡ ከረቱዋ፥ ብራፐ መꬌዳ ታማነ ላኡ ኩይጻሮቱዋነ ዎርቃፐ መꬌዳ ታማነ ላኡ ሻተቱዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ብራፐ መꬌዳ እት እት ከሪ እት ኪሎ ግራመነ ባጋ ዴጼ፤ ብራፐ መꬌዳ እት እት ኩይጻሩ ሆስፑን ጼቱ ግራመ ዴጼ፤ ብራፐ መቴዳ ከርያነ ኩይጻሩ ኤረቴዳ ሚዛናን ዎꬅና፥ ኡባና ላታማነ ሆስፑን ኪሎ ግራመ ኬና ዴጺኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ታማነ ላኡ ዎርቃ ሻታቱ ኤረቴዳ ሚዛናን ዎꬅና እቱ እቱ እት ጼታነ ታሙ ግራመ፥ ኡባና እት ክሎነ ሄዙ ጼቱ ግራመ ዴጺኖ። ኡንቱንቱን እጻናይ ኩም ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ካꬃ ያርሹዋና እትፐ ጹግያ ያርሾ አሄዳ መሂ ኡባና ታማነ ላኡ ኮሩማቱዋ፥ ታማነ ላኡ ዶርሳ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ ታማነ ላኡ አቱማ ዶርሳቱዋ። ኡንቱንቱ ናጋራ ያርሾ አሄዳ ዴሻ ኦርገቱ ኡባና ታማነ ላአ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ኡንቱንቱ እትፐተꬃ ያርሾ አሄዳ መሂ ኡባና ላታማነ ኦይዱ ኮሩማቱዋ፥ ኡሱፑን ታሙ ዶርሳ ኦርገቱዋ፥ ኡሱፑን ታሙ ጋኬዳ ዴሻ ኦርገቱዋነ እት ላይꬃይ ኩሜዳ ኡሱፑን ታሙ አቱማ ዶርሳቱዋ። ያርሽያ ሳአይ ኦከቴዳዋፐ ጉይያን፥ አንጆ አሄዳ እሞታይ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ሙሴ መꬍና ጎዳና ሃሳያናዉ ጾሳ ዱንካንያ ገልያ ዎደ፥ ማርካተꬃ ታቦታ ቦላን ደእያ አቶ ግያ ሳኣ ቁምኡዋ ቦላን፥ ላኡ ክሩበቱዋፐ ግዱዋና መꬍና ጎዳይ ሃሳይያ ኮሻ ስሴዳ፤ እካ አናና ሃሳዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“ኔን አሮናዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ኔን ላፑን ጾምፐቱዋ ዎꬅያ ዎደ ጾምፐቱ ጾምፕያ ዎꬅያ ባላቱዋፐ ስንꬃ ባጋና ደእያ ሄራቱዋ ፖኢኖ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","እ ጌዳዋዳን አሮን ኦꬄዳ። መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ አሮን ጾምፐቱዋ ዎꬅያ ባላቱዋፐ ስንꬃ ባጋና ደእያ ሄራቱዋ ፖእሳናዳን ኦꬂደ፥ ባላቱዋን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ጾምፕያ ዎꬅያዌ ጋርሳ ገድያፐ ቦላ ጪሻና አሌቀቴዳ ባላቱዋ ጼራ ጋካናዉ ቆጸቴዳ ዎርቃፐ መቴዳ። ጾምፕያ ዎꬅያ ባላይ መꬍና ጎዳይ ሙሳ በሴዳ ሌምሱዋዳን ኦሰቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ቃይ መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ሀራ እስራኤልያ አሳ ግዱዋፐ ሌዋቱዋ አካደ፥ ኡንቱንታ ዎጋዳን ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ኔን ኡንቱንታ ጌሻናዉ ሀዋዳን ኦꬃ: ጌሽያ ሃꬃ አካደ ኡንቱንታ ፑሻካ፤ ኡንቱንቱ ባረንቱ ቦላ ኡባ ሜደትኖ፤ ባረንቱ ማዩዋካ ሜጭኖ፤ ያቲደ ኡንቱንቱ ዎጋዳን ጌሻ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ሄዋፐ ጉይያን፥ ኡንቱንቱ ኮሩማ እቱዋነ ሊቆ ꬊልያ ዛይትያን ሙናቄዳዋ ካꬃ ያርሾ አክኖ፤ ኔን ቃይ ላኤንꬆ ኮሩማ ናጋራ ያርሾ አካ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ያታደ ሌዋቱዋ ጾሳ ዱንካንያ ስንꬃ አያ፤ እስራኤልያ አሳ ማባራ ኡባ ሺሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ኔን ሌዋቱዋ መꬍና ጎዳ ስንꬃ፥ አህና እስራኤልያ አሳይ ኡንቱንቱ ቦላ ባረንቱ ኩሽያ ዎꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ሌዋቱ መꬍና ጎዳ ኦሱዋ ኦꬃናዉ ጊጋና ማላ፥ አሮን እስራኤልያ አሳፐ ሌዋቱዋ ቃꬅያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳ ስንꬃ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“ሌዋቱ ባረንቱ ኩሽያ ኮሩማቱ ሁጲያን ዎꬅኖ፤ እቱዋ ናጋራ ያርሹዋ ኦꬃደ፥ እቱዋ ቃይ ሌዋቱ አቶ ጌተታና ማላ፥ ጹግያ ያርሹዋ ኦꬃደ መꬍና ጎዳዉ ያርሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ሌዋቱዋ አሮናነ አ አቱማ ናናቱ አዎተꬃ ጋርሳን ዎꬃ፤ ያታደ ኡንቱንታ ቃꬅያ ያርሹዋ ኦꬃደ፥ መꬍና ጎዳ ስንꬃ ሺሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ሄዋዳን ኦꬃደ ሌዋቱዋ ሀራ እስራኤልያ አሳፐ ዱማያ፤ ዱማዮፐ ሌዋቱ ታዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“ኔን ሌዋቱዋ ጌሼዳዋፐነ ቃꬅያ ያርሹዋ ኦꬃደ ሺሼዳዋፐ ጉይያን፥ ጾሳ ዱንካንያን ባረንቱ ኦሱዋ ኦꬃናዉ ዪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","እስራኤልያ አሳ ግዱዋፐ ኡንቱንቱ ታዉ ኡባና እመቴድኖ፤ እስራኤልያ ማጫ አሳፐ የለቴዳ ባይራ አቱማዋንቱ ኡባ ድራዉ ታን ሌዋቱዋ ታዉ አካድ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","እስራኤልያ አሳ ግዱዋን ባይራ የለቴዳዌ አሳ ግድና፥ መህያ ግድናካ ኡባይ ታዋ። ታን ግብጼ ጋድያን ባይራ ኡባ ዎꬌዳ ጋላሳን፥ ኡንቱንታ ታዉ ዱማያድ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","እስራኤልያ ባይራ አቱማዋንቱ ኡባ ድራዉ ታን ሌዋቱዋ አካድ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","እስራኤልያ አሳ ኡባ ግዱዋፐ ታን ሌዋቱዋ አሮናዉነ አሮና አቱማ ናናዉ እሙዋ ኦꬃደ እማድ። እስራኤልያ አሳይ ጋከትያ ዱንካንያ ሺቅያ ዎደ፥ ቦሻይ ኡንቱንታ ቦቼና ማላ፥ ሌዋቱ እስራኤልያ አሳ ግሻ ጋከትያ ዱንካንያን ባረንቱ ኦሱዋ ኦꬅኖነ ኡንቱንቱ ድራዉ አቶ ጌተትኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","መꬍና ጎዳይ ሙሳ ሌዋቱዋ ዱማያናዉ አዛዜዳዋዳን ሙሴ፥ አሮንነ እስራኤልያ አሳ ማባራይ ኡባይ ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ሌዋቱ ባረና ጌሼድኖ፤ ባረንቱ ማዩዋካ ሜጬድኖ። አሮን ኡንቱንቱ ቃꬅያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳ ስንꬃ ሺሼዳ፤ ኡንቱንታ ጌሻናዉ ኡንቱንታ አቶ ጊሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ሄዋፐ ጉይያን፥ ሌዋቱ አሮናነ አሮና አቱማ ናናቱ አዎተꬃ ጋርሳን፥ ጋከትያ ዱንካንያ ግዶን ባረንቱ ኦሱዋ ኦꬃናዉ ዬድኖ። መꬍና ጎዳይ ሙሳ ሌዋቱዋ ዱማያናዉ አዛዜዳዋዳን ኡንቱንቱ ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ቃይካ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ሀዌ ሌዋቱዋ ጼልያ ዎጋ: ላይꬃይ ላታማነ እቼሻነ ሄዋፐ ቦላና ደእያ አቱማዋንቱ ኦሱዋ ኦꬃናዉ ጋከትያ ዱንካንያ ዪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ሽን ኡንቱንቱ ላይꬃይ እሻታሙዋ ግድያ ዎደ ኡንቱንቱ ባረንቱ ኦሱዋፐ ጹራታ ከስኖ፤ ስሚደ ላኤንꬆ ኦꬆፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ኡንቱንቱ ጋከትያ ዱንካንያን ኦꬅያ ባረንቱ እሻቱዋ ኦꬅ ማዳና ጎፐ ማድኖፐ አትና፥ ኡንቱንቱ ባረካ አይ ኦሶነ ኦꬆፕኖ። ስም ኔን ሌዋቱዋ ኦሱዋ ሀዋዳን ኦስሳሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","እስራኤልያ አሳይ ግብጼፐ ከሴዳ ላኤንꬆ ላይꬃን ኮይሮ አግናን ሲና መላ ቢታን መꬍና ጎዳይ ሙሴዉ ሀዋዳን ያጊደ ሃሳዬዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“እስራኤልያ አሳይ ፓስጋ ባላ ኬሬዳ ጋላሳን ቦንቾ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ሀ አግናን ታማነ ኦይደንꬆ ጋላሳን፥ አ ኬሬዳ ዎደ፥ አዋይ ዉላና ሀንያ ዎደ፥ አ ዎጋ ኡባዳንነ አ አዛዞ ኡባዳን ቦንቾ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ሙሴ እስራኤልያ አሳይ ፓስጋ ባላ ቦንቻና ማላ፥ ኡንቱንቶ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ኮይሮ አግናዉ ታማነ ኦይደንꬆ ጋላስ፥ አዋይ ዉላና ሀንያ ዎደ ሲና መላ ቢታን ኡንቱንቱ ፓስጋ ባላ ቦንቼድኖ። እስራኤልያ አሳይ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ኡባባ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ሽን ኡንቱንቱፐ አማሬዳዋንቱ ሀይቄዳ አሳ አሃ ቦቺደ ቱኔዳ ድራዉ፥ ሄ ጋላስ ፓስጋ ባላ ቦንቻናዉ ዳንዳይበይክኖ። ሄዋ ድራዉ፥ ኡንቱንቱ ሙሴኮነ አሮናኮ ሄ ጋላስ ዪደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ሙሳ፥ “ኑን ሀይቄዳ አሳ አሃ ቦቼዳ ድራዉ ቱኔዶ፤ ሽን ኬሬዳ ዎድያን ሀራ እስራኤልያ አሳና መꬍና ጎዳዉ ያርሹዋ ሺሽያዋ ኑን አያዉ ድገቴቶ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ሙሴ ኡንቱንታ፥ “መꬍና ጎዳይ ህንተዋ ታዉ አዛዝያዋ ታን ስሳና ጋካናዉ ህንተ ታክሽተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ኔን እስራኤልያ አሳ ሀዋዳን ያጋ፤ ‘ህንተፐ ዎይ ህንተ ዛራቱዋፐ ኦንነ አሃ ቦቺደ ቱኖፐ፥ ዎይ ማንዳሬዳዋ ግዶፐ፥ እ መꬍና ጎዳዉ ፓስጋ ባላ ቦንቾ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ላኤንꬆ አግናን ታማነ ኦይደንꬆ ጋላስ አዋይ ዉላና ሀንያ ዎደ ፓስጋ ባላ ቦንቾ። ፓስጋ ዶርሳ እርሹ ገልቤና ኡክꬃናነ ጫሞ ቦንጭያና ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ሳአይ ዎንታናዉ ሄ ዶርሳፐ አያነ አሾፖ፤ ቃይ አ መቀꬃፐካ እቱዋነ መንꬆፖ። ፓስጋ ባላዉ አ ዎጋ ኡባ ኦꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ሽን ማንዳርቤና ጌሻ አሳይ ፓስጋ ቦንቼናን እጾፐ፥ ሄዋፐ ስንꬃዉ እ ታ አሳ ግዶፐ ቦሄቶ። አያዉ ጎፐ፥ መꬍና ጎዳ ያርሹዋ ኬሬዳ ዎድያን እ ሺሽቤና። ሄ አሳይ ባረ ናጋራይ አሄዳ መቱዋ አካናዉ በሰ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘ህንተ ግዱዋን ደእያ በተ አሳይ ፓስጋ ባላ መꬍና ጎዳዉ ቦንቻና ኮዮፐ፥ ፓስጋ ዎጋዳን ቦንቾ። በትያዉካ ጋደ አሳዉካ እት ማላ ዎጋይ ደኦ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ዱንካኒ ቶለቴዳ ጋላስ ሻሪ ማርካተꬃ ዱንካንያ ማዬዳ፤ ኦማርሳፐ ዶሚደ፥ ዎንታና ጋካናዉ ዱንካንያፐ ቦላና ደእያ ሻሪ ታማ ማላቴ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ሄዋዳን ኡባ ዎደ ጋላስ ጋላስ ሻሪ ማዬ፤ ቃማ ቃማ ሄ ሻሪ ታማዳን ፖኤ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ሄ ሻሪ ዱንካንያ ቦላፐ ደንድያ ዎደ አዉደነ እስራኤላቱ ባረንቱ ዱንካኔዳ ሳኣፐ ደንዲኖ፤ ቃይ ሄ ሻሪ ዎꬍያ አይ ሳኣንነ እስራኤላቱ ዱንካኒኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","እስራኤላቱ መꬍና ጎዳ አዛዙዋን ደንድኖ፤ ሄዋዳንካ፥ መꬍና ጎዳ አዛዙዋን ዱንካኒኖ። ሻሪ ዱንካንያ ቦላን ጋምእያ ዎደ ኡባን ባረንቱ ዱንካኔዳሳን ጋምእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ሻሪ ዱንካንያ ቦላን ዳሮ ጋላሳ ጋምኦፐ፥ እስራኤላቱ መꬍና ጎዳ አዛዙዋ ናጊኖፐ አትና፥ ሀቃነ ቢክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","እት እት ገደ ሻሪ ዱንካንያ ቦላን አማሬዳ ጋላሳ ጋምኤ። መꬍና ጎዳ አዛዙዋን ኡንቱንቱ ዱንካኒኖ፤ ቃይ ሄዋዳንካ፥ ጾሳ አዛዙዋን ኡንቱንቱ ደንድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","እት እት ገደ ሻሪ ኦማርሳፐ ዎንታና ጋካናዉ ጻላላ ጋምኤ፤ ዎንትና ሻሪ ደንድያ ዎደ ኡንቱንቱካ ደንድኖ። ጋላሳ ግድና፥ ቃማ ግድና፥ ሻሪ ደንድያ ዎደ ኡንቱንቱካ ደንድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ሻሪ ዱንካንያ ቦላን ላኡ ጋላሳ ጋምእና፥ ዎይ እት አግና፥ ዎይ እት ላይꬃ ጋምእና፥ እስራኤላቱ ባረንቱ ዱንካኔዳሳን ጋምኢኖፐ አትና ቢክኖ። ሽን ሻሪ ደንድያ ዎደ ኡንቱንቱካ ደንድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ኡንቱንቱ መꬍና ጎዳ አዛዙዋን ዱንካኒኖነ ቃይ መꬍና ጎዳ አዛዙዋን ደንድኖ፤ መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳዋዳን፥ ኡንቱንቱ መꬍና ጎዳ አዛዙዋ ናጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“ላኡ ጹሩምባቱዋ ብራፐ ቆጻደ ኦꬃ፤ ያታደ አሳ ሺቆ ጼጋናዉነ ቃይ ዱንካኔዳ ሳፐ ደንዳናዉ ደንꬃናዳን ፑና። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ሀ ላኡ ጹሩምባቱ ፑነትያ ዎደ፥ አሳይ ኡባይ ጋከትያ ዱንካንያ ፐንጊ ኔኮ ሺቆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ሽን እት ጹሩምባ ጻላላይ ፑነቶፐ፥ እስራኤልያ ዛራቱዋ ካፓቱ ነ ስንꬃ ሺቅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ኔን ጹሩምባ ꬎቁ ኦꬃደ ፑንያ ዎደ፥ አዋይ ዶልያ ባጋና ዱንካኔዳ ዛራቱ ደንድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ጹሩምባ ላኤንꬆ ꬎቁ ኦꬃደ ፑንያ ዎደ፥ ገድሳ ባጋና ዱንካኔዳ ዛራቱ ደንድኖ። ጹሩምባይ ꬎቁ ግ ፑነትያዌ ደንዳናዉ ማላ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ያአዉ አሳ ሺሻናዉ ጹሩምባ ፑና፤ ሽን ኮሻ ꬎቁ ኦꬃደ ፑኖፓ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","አሮና ናናይ ቄሳቱ ጹሩምባ ፑንኖ። ሀዌ ነዉነ ይያ የለታ ኡባዉ መꬍና ዎጋ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“ህንተ ጋድያን መቱዋ ደንꬅያ ህንተ ሞርክያና ህንተ ኦለታናዉ ከስያ ዎደ፥ ሄ ጹሩምባቱዋ ꬎቁ ኦꬂደ ፑንተ። ሄዋን መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ሄ ዎደ ሀሳዪደ፥ ህንተ ሞርክያፐ ህንተና አሻና። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ሄዋዳንካ፥ ቃይ ህንተ ናሸትያ ጋላስ፥ ባላ ቦንቻናዉ ህንተ ኬሬዳ ጋላስነ አግናይ ጼርያ ባላን፥ ህንተ ጹግያ ያርሹዋ ያርሽያ ዎደነ ህንተ እትፐተꬃ ያርሹዋ ያርሽያ ዎደ ሄ ጹሩምባቱዋ ፑንተ፤ ሄዌ ጾሳ ስንꬃን ህንተና ሀሳይስያዋ ግዳና። ታን መꬍና ጎዳ፥ ህንተ ጾሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ላኤንꬃ ላይꬃን ላኤንꬆ አግናን ላታማንꬃ ጋላስ፥ ሻሪ ማርካተꬃ ዱንካንያ ቦላፐ ደንዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ሄዋፐ ጉይያን፥ እስራኤልያ አሳይ ሲና መላ ቢታፐ ደንዴዳ፤ ሻሪ ፓራና ግያ መላ ቢታ ጋኪደ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ኡንቱንቱ ሀ ኮይሮ ቡሳዉ መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳዋዳን ደንዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ይሁዳ ዛራቱዋና ዱንካኔዳ ባጋይ ባረንቱ አርማ ኦይቂደ ኮይሮ ደንዴድኖ። ይሁዳ ዛራቱ ካፑ አምናዳባ ናኣ ናአሶና፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ይሳኮራ ዛራቱ ካፑ ጹኣራ ናኣ ናታንኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ዛብሎና ዛራቱ ካፑ ሄሎና ናኣ ኤልኣባ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ሄዋፐ ጉይያን፥ ዱንካንያ ሾድና፥ ገርሾና ያራቱነ ማራራ ያራቱ ቶኪደ ደንዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ካሊደ ሮቤላ ዛራቱዋና ዱንካኔዳ ባጋይ ባረንቱ አርማ ኦይቂደ ደንዴዳ። ሮቤላ ዛራቱ ካፑ ሻደኡራ ናኣ ኤሊጹራ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ስሞና ዛራቱ ካፑ ጹሪሻዳያ ናኣ ሻሉምኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ጋዳ ዛራቱ ካፑ ረኡኤላ ናኣ ኤልያሳፋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ሄዋፐ ጉይያን፥ ቃሃታ ያራቱ ጌሻ ሚሻቱዋ ቶኪደ ደንዴድኖ። ኡንቱንቱ ጋካናፐ ካሰቲደ፥ ዱንካኒ ቶለት ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ካሊደ ኤፍሬማ ዛራቱዋና ዱንካኔዳ ባጋይ ባረ አርማ ኦይቂደ ደንዴዳ። ኤፍሬማ ዛራቱ ካፑ አምሁዳ ናኣ ኤልሻማአ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ምናሰ ዛራቱ ካፑ ፓዳጹራ ናኣ ጋማልኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ቢንያማ ዛራቱ ካፑ ጊድኦና ናኣ አብዳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ዉርሰꬃን፥ ሀ ጩጉዋ ኡባዉ ጉየ ባጋን ናግያ ዳና ዛራቱዋና ዱንካኔዳ ባጋይ ባረ አርማ ኦይቂደ ደንዴዳ። ዳና ዛራቱ ካፑ አምሻዳያ ናኣ አህኤዘራ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","አሴራ ዛራቱ ካፑ ኦክራና ናኣ ፓግኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ንፍታሌማ ዛራቱ ካፑ ኤናና ናኣ አህራአ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","እስራኤልያ አሳይ ባረ ባጋን ባጋን ደንዲደ ብያ ማራይ ሀዋዳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ሙሴ ምድያማ አሳ ግድያ ባረ ቦሉዋ ረኡኤላ ናኣ ሆባባ፥ “ኑን መꬍና ጎዳይ፥ ‘ታን ህንተንቶ እማና’ ጌዳ ሳኣ ቤቶ፤ መꬍና ጎዳይ እስራኤልያዉ ሎኦባ ኦꬃና ጌዳ ድራዉ፥ ኔን ኑናና ደንዳ። ኑን ነዉ ሎኦባ ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ሆባብ፥ “ቱይት፥ ታን ቢከ፤ ታን ታ ቢታ ታ አሳኮ ባና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ሙሴ አ፥ “ሀያና፥ ኑና የጋደ ቦፓርኪ! መላ ቢታን ኑን ዱንካናናዉ በስያሳ ኔን ኤራሳ፤ ኔን ኑ ብያ ኦግያ ኑና ካለꬃናዉካ ዳንዳያሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ኔን ኑናና ቦፐ፥ መꬍና ጎዳይ ኑዉ እምያ አንጁዋ ኡባ ኑን ኔናና ሻካና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ያትና ኡንቱንቱ መꬍና ጎዳ ደርያፐ ደንዲደ፥ ሄዙ ጋላሳ ኬሻ ኦግያ ቤድኖ። መꬍና ጎዳ ጫቁዋ ታቦታይ ኡንቱንቱ ሸምፕያ ሳኣ ደማናዉ ሄ ሄዙ ጋላሳን ኡንቱንቱፐ ስንꬃዉ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ኡንቱንቱ ዱንካኔዳ ሳኣፐ ደንድያ ዎደ ኡባን፥ መꬍና ጎዳ ሻሪ ጋላስ ጋላስ ኡንቱንቱፐ ቦላና ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ታቦታይ ደንድያ ዎደ ኡባን ሙሴ፥ “አቤት መꬍና ጎዳዉ፥ ደንዳ! ነ ሞርከቱ ላለትኖ፤ ኔና እጽያዋንቱካ ነ ስንꬃፐ ባቃትኖ” ያጌ። ");
INSERT INTO dwrENT_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ታቦታይ ሸምፕያ ዎደ ኡባን ሙሴ፥ “አቤት መꬍና ጎዳዉ፥ ሀ ዳሮ ሻአን ፓይደትያ እስራኤልያ አሳኮ ኔን ስማ” ያጌ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","አሳይ ባረ መቶ መꬍና ጎዳ ቦላ ዙዙሜዳ፤ ኡንቱንቱ ዙዙሚና ጾሳይ ስሲደ፥ ሀንቁዋ ኤጽ ከሴዳ። ያትና መꬍና ጎዳ ታማይ ኡንቱንቱ ግዱዋን ኤጺደ፥ ኡንቱንቱ ዱንካኔዳ ሳአዉ እት እት ጋጻ ባጋ ሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ያትና አሳይ ሙሴዉ ዋስና፥ ሙሴ መꬍና ጎዳ ዎሴዳ። ታማይ ቶኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","መꬍና ጎዳ ታማይ ኡንቱንቱ ግዱዋን ኤጼዳ ድራዉ፥ ሄ ሳአይ ታብኤራ ጌተት ጼሰቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","እስራኤላቱዋና ደእያ ዱማ ዱማ ጋደ አሳይ ሀራ ቁማ ሎይꬅ አሞቴዳ። እስራኤልያ አሳይካ ቃይ ሀዋዳን ያጊደ ዬኩዋ ዶሜዳ፤ “ላ ኑን አሹዋ ሀቃፐ ደማኔ? ");
INSERT INTO dwrENT_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ኑን ግብጼ ጋድያን ሚሻ ጭገናን ጮ ምያ ሞልያ ሀሳዬቶ፤ ቃይ ቃይያ ምያ ፓራንጅያ ሌክያ፥ ዞልዶ ሌኪያ ማላትያ ማልእያ ሃꬃይ ኩሜዳ ሜሎንያ፥ አዱሳ ፓራንጅያ ሱንቁሩትያነ ቱሙዋ ሀሳዬቶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ሽን ሀእ ኑ ቆꬊ ጎርደቴዳ፤ ኑ አይፊካ ሀ ማናፐ አትና፥ ሀራባ አይነ በኤና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ማናይ ዴቡዋ አይፍያ ማላቴ፤ አ ማላይ ቦጽያ ምꬃ ጮሻ ማላቴ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","አሳይ ዩይ ዩይ አ ቆሬ፤ ዎጻን ጋጬ፥ ዎይ ኡዱላን ጫዴ፤ ኡንቱንቱ አ ኦቱዋን ፐንትሲደ፥ ባሽያን ኮምፒኖ። እ ዛይትያን ሙናቂደ ኡኬዳ ኡክꬃዳን ማልኤ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ቃማ ዱንካኔዳሳን ጻሳይ ዎꬍያ ዎደ፥ ማናይ አናና ዎꬌ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","አሳይ ባረ ዱንካንያ ፐንግያን ፐንግያን ዬክሽን፥ ሙሴ ስሴዳ። መꬍና ጎዳ ሀንቁ ኤጽ ከሴዳ ድራዉ፥ ሙሴ ኡንኤቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ሄዋ ድራዉ፥ ሙሴ መꬍና ጎዳ ሀዋዳን ያጊደ ኦቼዳ፤ “ኔን ታ ቦላ ነ ቆማ ቦላ አያዉ ሀ መቱዋ አሃዲ? ኔን ታናን አያዉ ናሸታበይኪ? ኔን ሀ አሳ ኡባ ቶኩዋ ታ ቦላ አያዉ ዎꬃዲ? ");
INSERT INTO dwrENT_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ሀ አሳ ኡባ ታን ሻሃራድታየ? ዎይ ኡንቱንታ ታን የላድታ? ‘ኔን ኡንቱንቱ ማይዛ አዋቶ፥ “ታን ህንተንቶ እማና” ጋደ ጫቄዳ ቢታ ጋꬃናዉ፥ ናናቱዋ ድችያና ꬋንꬅያ ናኣ ባረ ክዉዋን እድምያዋዳን፥ ኔን ኡንቱንታ ነ ክዉዋን እድማ’ ያጋደ ታዉ አያዉ ኦዳይ? ");
INSERT INTO dwrENT_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ሀ አሳዉ ኡባዉ ታን አሹዋ ሀቃፐ ደማኔ? ኡንቱንቱ ታና፥ ‘ምያ አሹዋ ኑዉ እማ’ ያጊደ ዬኪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ታን ሀ አሳ ኡባ ታረካ ቶካና ዳንዳይከ፤ ቶኩ ታዉ ሎይꬅ ዴጼ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ስም ኔን ታና ሀዋዳን መቶታናዳን ኦꬃናዋፐ ታዉ ቃረታደ ታና ሀእ ዎꬋ ባሻ፤ ያቶፐ፥ ታን መቱዋፐ ሸምፓና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","መꬍና ጎዳይ ሙሳ፥ “እስራኤልያ ጭማቱዋፐ ካለꬅያዋንታነ ካፓቱዋ ግድያ፥ ኔን ኤርያ ላፑን ታሙ ጭማቱዋ ታዉ ሺሻ፤ ኡንቱንቱ ኔናና ያን ኤቃና ማላ፥ ጾሳ ዱንካንያኮ፥ ኡንቱንታ ኔን አያ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ታን ዱገ ዎꬋደ ኔናና ያን ሃሳያና፤ ታን ኔናን ደእያ አያናፐ አካደ፥ ሄ አያና ኡንቱንቱ ቦላ ዎꬃና። ኔን ኔረካ ቶከና ማላ፥ ኡንቱንቱ አሳ ቶኩዋ ቶኪደ፥ ኔና ማዳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“ኔን አሳዉ ሀዋዳን ጋደ ኦዳ፥ ‘ዎንትዉ ህንተና ጌሽተ፤ ያቲደ ህንተ አሹዋ ማና። ህንተ፥ “ላ ኑን አሹዋ ሀቃፐ ደማኔ? ኑዉ ግብጼ ጋድያን ሳአይ ሎአ ሽን!” ያጊደ ዬኬዳዋ መꬍና ጎዳይ ስሴዳ። መꬍና ጎዳይ አሹዋ ሀእ ህንተንቶ እማና፤ እምና ህንተ ማና። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","20","ህንተ ግዱዋን ደእያ መꬍና ጎዳ ህንተ ካꬌዳ ድራዉነ ህንተ፥ “ኑን ግብጼ ጋድያፐ አያዉ ከሴዶ?” ያጊደ አ ስንꬃን ዬኬዳ ድራዉ፥ ህንተ እት ጋላሳ፥ ዎይ ላኡ ጋላሳ፥ ዎይ እቼሹ ጋላሳ፥ ዎይ ታሙ ጋላሳ፥ ዎይ ላታሙ ጋላሳ ጻላላ አሹዋ ሚክታ፤ ሽን ህንተንቶ ሲꬍያና ከሳና ጋካናዉ፥ ህንተና ሳለꬃና ጋካናዉ፥ እት አግና ኩመንꬃ ህንተ አሹዋ ማና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ሽን ሙሴ ጾሳ፥ “በአ፥ ታን ኡሱፑን ጼቱ ሻአ ግድያ አሳ ግዱዋን ደአይ፤ ኔን፥ ‘እት አግና ኩመንꬃ ኡንቱንቱ ማናዉ ኡንቱንቶ ታን አሹዋ እማና’ ጋዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ሚዛ ዉድያነ ዶርሳ ዉድያ ኡንቱንቶ ሹክና ካልሳኔ? አባን ደእያ ሞልያ ኡባ ሺሽያዋ ግድንቶነ፥ ኡንቱንቶ ግዳኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","መꬍና ጎዳይ ሙሳ፥ “መꬍና ጎዳ ኩሺ ቃንꬄየ? ታን ነዉ ግያባይ ቱመንቶነ ዎርደንቶ ኔን ሀእ በአና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ሙሴ ካረ ከሲደ፥ መꬍና ጎዳይ ጌዳዋ አሳዉ ኦዴዳ። እ እስራኤልያ ጭማቱዋፐ ላፑን ታሙ አሳ ሺሺደ፥ ዱንካንያ ዩሹዋን ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","መꬍና ጎዳይ ሻሪያን ዱገ ዎꬊደ፥ አናና ሃሳዬዳ፤ ያቲደ አ ቦላን ደእያ አያናፐ አኪደ፥ ሄ ላፑን ታሙ ጭማቱዋ ቦላ ዎꬄዳ። አያናይ ኡንቱንቱ ቦላን ሸምፔዳ ዎደ፥ ኡንቱንቱ ትምቢትያ ኦዴድኖ። ሽን ሄዋፐ ጉይያን፥ ዛረꬂደ ትምቢትያ ኦድበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ሄ ላፑን ታሙ ጭማቱዋና ማዝጎብያን ጻፈቴዳ አሳቱ ኤልዳዳነ መዳዳ ግያ ላአቱ ዱንካኔዳሳን አቴድኖ፤ ዱንካንያኮ ይበይክኖ፤ ሽን ኡንቱንቱ ቦላካ አያናይ ዎꬍና፥ ዱንካኔዳሳን ትምቢትያ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","እት ዎዳላይ ዎጽ ዪደ፥ ሙሳ፥ “ኤልዳድነ መዳድ ዱንካኔዳሳን ትምቢትያ ኦዲኖ” ያጊደ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ባረ ያላጋተꬃፐ ዶሚደ፥ ሙሳ ማድያ ኔዌ ናአይ ኢያሱ ሙሳ፥ “ታ ጎዳዉ ሙሴ፥ ኔን ኡንቱንታ ተአ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ሽን ሙሴ አ፥ “ታ ግሻታ ነ ምሸታይ? መꬍና ጎዳ አሳይ ኡባይ ትምቢትያ ኦድያዋነ መꬍና ጎዳይ ባረ አያና ኡንቱንቱ ቦላ ዎꬅያዋ ግዴረኔሻ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ሄዋፐ ጉይያን፥ ሙሴነ እስራኤልያ ጭማቱ ዱንካኔዳሳ ስሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ጫርኩዋ ደንꬅና፥ አባ ባጋፐ አካ አሳይ ዱንካኔዳሳ ኡባ ዩሹዋኮ ጫርኩ አሄዳ፤ ሄ ካፎቱ ሳኣ ዶናና ጋድያፐ ፑደ ላኡ ዋꬋ ኬሻን ፓሌድኖ። ዪደ ኡንቱንቱ ዱንካኔዳሳ ኡባፐ ጋጻና፥ እት ጋላሳ ኦገ ኬና ሳኣን ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ሄ ጋላሳ ኡባን፥ ሄ ቃማ ኡባንነ ዎንተꬃ ጋላሳ ኡባን አሳይ ካረ ከሲደ፥ ሀ አካቱዋ ኦይቂደ ሺሼዳ፤ ኡንቱንቱፐ ኦንነ እት ሻአ ኪሎ ግራመፐ ጉꬃ ሺሽቤና። ኡንቱንቱ ሄዋፐ ጉይያን፥ ዱንካኔዳሳ ዩሹዋ ኡባን መልሳናዉ ምጬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ሽን አሹ ብሮ ኡንቱንቱ ማታን ደእሽን፥ ኡንቱንቱ ጮሚደ ምተናን ደእሽን፥ መꬍና ጎዳ ሀንቁ አሳ ቦላ ኤጽ ከሴዳ፤ ያትና መꬍና ጎዳይ አሳ ዎልቃማ ቦሻን ሾጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ያትና ሄ ሳአይ ክብሮት ሀታባ (አሙዋ ዱፉዋ) ጌተት ሱንቴዳ፤ አያዉ ጎፐ፥ አሹዋ አሞቴዳ አሳ ኡንቱንቱ ሄ ሳኣን ሞጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","አሳይ ሄዋፐ ደንዲደ ሀጸሮታ ግያሳ ቢደ፥ ያን ዱንካኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ሙሴ ቶጵያ ቢታ ምሽራቶ አኬዳ። እ አኬዳ ቶጵያ ማጫን ድራዉ፥ ሚርያማነ አሮን ሙሳ ቦሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ኡንቱንቱ፥ “መꬍና ጎዳይ ሙሴ ባጋ ጻላላና ሃሳዬደየ? ቃይ እ ኑ ባጋና ሃሳይቤኔየ?” ያጌድኖ። መꬍና ጎዳይ ሄዋ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ሙሴ ጋድያን ሳኣን ኡባን ደእያ አሳ ኡባፐ አꬍያ አሽከ አሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","መꬍና ጎዳይ ኤለካ ሙሴዉ፥ አሮናዉነ ሚርያምዉ፥ “ህንተ ሄዙካ ጋከትያ ዱንካንያኮ ከስተ” ያጌዳ፤ ኡንቱንቱ ሄዙካ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ጾሳይ ሻርያ ቱሳን ዱገ ዎꬌዳ፤ ዱንካንያ ፐንግያን ኤቂደ፥ አሮናነ ሚርያሞ ጼሴዳ። ኡንቱንቱ ላኡካ አ ስንꬃ ሺቅና፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","እ ኡንቱንታ፥ “ታ ኦድያዋ ስስተ: ህንተ ግዱዋን ትምቢትያ ኦድያዌ ደኦፐ፥ ታን መꬍና ጎዳይ ታና አዉ ሳጻን ቆንጭሳይ፤ ታን አዉ አኩሙዋን ኦዳይ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ሽን ታ ቆማ ሙሴና ሄዋዳን ግደና፤ እ ታ ጎልያ ኡባን አማነቴዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ታን ሙሴና ስንꬃ ስንꬃን ሃሳያይፐ አትና፥ ሌምሱዋን ሃሳይከ። እ መꬍና ጎዳ ማላ በኤ። ያትና ታ ቆማ ሙሳ ቦራናዉ ህንተ አያዉ ያይበይክቴ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","መꬍና ጎዳ ሀንቁ ኡንቱንቱ ቦላ ኤጽ ከሴዳ፤ መꬍና ጎዳይ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ሻሪ ዱንካንያ ቦላፐ ደንዴዳ ዎደ፥ ሚርያማ ዎልቃማ ጋልባ ሀርግያን ምልጽ ጋደ ቦጻዱ። አሮን ኢኮ ስሚደ ጼልያ ዎደ፥ ዎልቃማ ጋልባ ሀርግያን ኦይቀቴዳኖ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ያትና እ ሙሳ፥ “ሀይ ታ ጎዳዉ፥ ኑን ኤያተꬃን ኦꬄዳ ናጋራዉ ኑና ሙሮፓ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ባረ ዳይ ኡሉዋፐ ከስያ ዎደ፥ አ አሹዋፐ ባጋይ ሜተት ክችና፥ ሀይቂ ክቺደ የለቴዳ ጋጭኖ ናኣ ማላ ግዶፓረኬ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ሙሴ፥ “ሀይ ጾሳዉ፥ እዞ ፓꬃርኪ!” ያጊደ መꬍና ጎዳዉ ዋሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","መꬍና ጎዳይ ሙሳ፥ “እ አዉ እ ሶምእያን ጩቻ ጩቼዳዋ ግድንቶነ፥ ላፑን ጋላሳ እዛ ዬላ ማያደ ኡታና ግደኬየ? ሄዋ ድራዉ፥ ኔን እዞ ላፑን ጋላሳ ዱንካኔዳ ሳኣፐ ጋጻ ባጋና ዱማ ሳኣን ኡትሳ፤ ሄዋፐ ጉይያን፥ ስማደ ዩ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ያትና ሚርያማ አሳይ ዱንካኔዳ ሳኣፐ ጋጻ ከሳደ ላፑን ጋላሳ ኡታዱ። አ ስማና ጋካናዉ አሳይ ባናዉ ደንድቤና። ");
INSERT INTO dwrENT_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ሄዋፐ ጉይያን፥ አሳይ ሀጸሮታ ግያ ሳፐ ደንዲደ፥ ፓራና መላ ቢታ ዱንካኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","መꬍና ጎዳይ፥ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ታን እስራኤላቶ እምያ ካናነ ቢታ ዎቻና ማላ፥ አማሬዳ አሳ ኪታ፤ ኡንቱንቱ ዛረ ኡባፐ እት እት ካፑዋ ኪታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ሙሴ መꬍና ጎዳ አዛዙዋን ፓራና መላ ቢታፐ ኡንቱንታ ኪቴዳ። ኡንቱንቱ ኡባይካ እስራኤልያ አሳ ካፓቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ኡንቱንቱ ሱንꬃይ ሀዋፐ ካሊደ ጻፈቴዳዋ: ዛርያ ካፑዋ ሮቤላ ዛኩራ ናኣ ሻሙአ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ስሞና ሆራ ናኣ ሻፋጻ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ይሁዳ ይፉነ ናኣ ካሌባ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ይሳኮራ ዮሴፎ ናኣ ይግኣላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ኤፍሬማ ኔዌ ናኣ ሆሼአ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ቢንያማ ራፉ ናኣ ፓልጻ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ዛብሎና ሶዳ ናኣ ጋድኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ዮሴፎ ናኣ ምናሳ ሱሳ ናኣ ጋዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ዳና ጋማላ ናኣ አምኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","አሴራ ምካኤላ ናኣ ሳቱራ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ንፍታሌማ ዋፍሳ ናኣ ናህባ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ጋዳ ማካ ናኣ ገኡኤላ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ሄ ቢታ ዎቻና ማላ፥ ሙሴ ኪቴዳ አሳቱ ሱንꬃይ ሀዋፐ ቆሞና ደእያዋ። ሙሴ ኔዌ ናኣ ሆሼአ ሱንꬃ ኢያሳ ያጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ኡንቱንቱ ካናነ ቢታ ዎቻና ማላ፥ ሙሴ ኡንቱንታ ኪትያ ዎደ ሀዋዳን ያጌዳ፤ “ሀዋፐ ኔጌባ መላ ቢታ ፑደ ከሲደ፥ ያፐ ሁጲሳ ባጋን ደእያ ገዘ ቢታ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ቢታይ አይ ማላ ቢተንቶነ በእተ፤ ሄ ጋድያን ደእያ አሳይ ምነንቶነ ላፈንቶ፥ ጉꬄንቶነ ዳረንቶ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ኡንቱንቱ ደእያ ቢታይ ሎኤንቶነ ኢተንቶ፥ ኡንቱንቱ ደእያ ካታማይነ አይ ማላ ካታመንቶ፥ ግምቢያን ድረት ኡቴደንቶ ድረትቤነንቶ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ቢታይ አይ ማላ ቱኤንቶነ ላደንቶ፥ ሄ ጋድያን ምꬃይ ደእንቶነ ባዌንቶ በእተ። ምንተ! ሄ ጋድያን ሞኬዳዋ አይፍያፐ አከናን ዮፕተ” ያጌዳ። ሄ ዎዲ ዎይንያ ቱራይ ኮይሮ አይፍያ አይፍያ ዎደ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ኡንቱንቱ ፑደ ከሲደ፥ ጺና ግያ መላ ቢታፐ ዶሚደ፥ ቢደ ሀማታ ፕኑዋ ማታን ደእያ ራሆባ ጋካናዉ ሄ ቢታ ዎቼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ኔጌባ ፑደ ከሲደ፥ ከብሮና ጋኬድኖ፤ ሄዋን አህማና፥ ሸሻያነ ታልማያ ጌተትያ አናቀ ዛራቱ ደኢኖ። ከብሮን ግብጼን ደእያ ጾኣነ ካታማፐ ላፑን ላይꬃ ካሰት ኬጸቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ሄዋና አꬊደ፥ ኡንቱንቱ ኤሽኮላ ግያ ዛንጋራ ቢደ ጋኬዳ ዎደ፥ ዎይንያ ቱራ እቱዋፐ እት ዉርጩዋና ደእያ እት ታሽያ ቃንጼድኖ፤ ኡንቱንቱፐ ላኡ ካሱዋ ግዱዋን ገልስ ቶኬድኖ። ሄዋና ሮማንያነ ባላስያ ግያ ምꬃቱዋ አይፍያ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","እስራኤልያ አሳቱ ሄዋፐ ቃንጼዳ ዎይንያ ቱራ ዉርጩዋ ድራዉ፥ ሄ ሳኣ ኤሽኮላ ዛንጋራ ጊደ ጼሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ኡንቱንቱ ሄ ቢታ ዎቺደ፥ ኦይታሙ ጋላሳፐ ጉይያን ስሜድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ፓራና መላ ቢታን ቃዴሳ ግያ ሳን ደእያ ሙሴኮ፥ አሮነኮነ እስራኤልያ አሳ ማባራ ኡባኮ ዬድኖ። ባረንቱ በኤዳዋ ኡንቱንቶዉነ አሳ ኡባዉ ኦዴድኖ፤ ሄ ጋድያን አይፍያ አይፍያካ ኡንቱንታ በሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ኡንቱንቱ ሙሴዉ ሀዋዳን ያጊደ ኦዴድኖ፤ “ኔን ኑና ኪቴዳ ቢታ ኑን ቤዶ፤ ሄ ጋድያን ማꬃይነ ኤሳይ ጎጌ። አን አይፍያ አይፍያካ ሀዋ በአ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ሽን ሄ ጋድያን ደእያ አሳይ ዎልቃማ፤ ኡንቱንቱ ካታማይካ ግምቢያ ድርሳን ድረት ኡቴዳዋነ ዎልቃማ። ኑን ቃይ አናቀ ዛራቱዋ ያን በኤዶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ኔጌባ አማሌቃ አሳቱ ደኢኖ፤ ገዝያን ሂተቱ፥ ያቡሳቱነ አሞራቱ ደኢኖ፤ ቃይ ካናነቱ ሜድተራነ አባ ዶናንነ ዮርዳኖሳ ሻፋ ጋጻን ደኢኖ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ካሌብ አሳ ሙሴ ስንꬃን ጮኡ ጊሲደ፥ “ኑን ቱሙ ጾናናዉ ዳንዳይያ ድራዉ፥ ፑደ ሀእ ከሲደ፥ ሄ ቢታ ኦሊደ አነ ኦይቆይተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ሽን ካሌበና ፑደ ቤዳ አሳቱ፥ “ሄ ቢታ አሳይ ኑፐ ምንያ ድራዉ፥ ኑን ኡንቱንታ ጾናናዉ ዳንዳዮኮ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ኡንቱንቱ ዩይ ዎቼዳ ቢታ እስራኤልያ አሳዉ ሀዋዳን ጊደ፥ ኢታ ኦዱዋ ኦዴድኖ፥ “ኑን ዎቼዳ ቢታይ ባረናን ደእያ አሳካ ምያዋ፤ አሳይ ኡባይካ ሎይꬅ አዱሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ኑን ዎጋ አዱሳ አሳቱ ያራ ግድያ አናቀ ዛራቱዋ ያን በኤዶ፤ ኑን ኑ አይፍያን ኑና ጼልያ ዎደ ቡምቡረꬃ ማላቴቶ፤ ቃይ ኑን ኡንቱንቱ አይፍያን ሄዋካ ማላ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ሄ ጋላሳ ቃማ ማባራይ ኡባይ ባረንቱ ቃላ ꬎቂሲደ ዬኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","እስራኤልያ አሳይ ኡባይ ሙሴ ቦላነ አሮና ቦላ ዙዙሜድኖ። ማባራይ ኩመንꬃይ ኡንቱንታ፥ “ኑን ግብጼ ጋድያን ደኢደ ሀይቄዳዋ ግዴሮኮ! ዎይ ኑን ሀ መላ ቢታን ሀይቄዳዋ ግዴሮኮ! ");
INSERT INTO dwrENT_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ማሻን ኑና ዎꬍ ዉርሳናዉ መꬍና ጎዳይ ሀ ቢታ ኑና አያዉ አሂ? ኑ ማቼቱነ ኑ ናናይ ኦሞደታና። ሄዋፐ ጉየ ግብጼ ቢታ ስምያዌ ኑዉ ኬከኔየ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ቃይ ኡንቱንቱ እቱ እቱዋ፥ “ኑን ካለꬅያዋ ዶሪደ፥ ጉየ ግብጼ ስሜቶ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ሙሴነ አሮን ሄዋን ሺቄዳ እስራኤልያ አሳ ማባራ ኡባ ስንꬃን ሶምኡዋ ሳኣን ጋꬂደ ጉፋኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ሄ ቢታ ዎቼዳ አሳቱ ግዶፐ ኔዌ ናአይ ኢያሱነ ይፉነ ናአይ ካሌብ ባረንቱ ማዩዋ ፔꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","እስራኤልያ አሳ ማባራ ኡባዉ፥ “ኑን ካንꬅ ከሲደ ዎቼዳ ቢታይ ሎይꬅ ዳሮ ሎአ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","መꬍና ጎዳይ ኑናን ናሸትያዋ ግዶፐ፥ ማꬃይነ ኤሳይ ጎግያ ሄ ቢታዉ ኑና እ ገልሳና፤ ሄ ቢታ ኑዉ እ እማና። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ሄዋ ድራዉ፥ መꬍና ጎዳ ቦላ ማካላ ማካሎፕተ። ሄ ቢታ አሳዉ ያዮፕተ፤ ኡንቱንቱ ኑዉ ሃꬃ ኡሻካ ጋክክኖ። ኡንቱንቶ አምቦምያዌ ባዋ፤ ሽን መꬍና ጎዳይ ኑናና ደኤ። ህንተ ኡንቱንቶ ያዮፕተ!” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ማባራይ ኡባይ ኡንቱንታ ሹቻን ጫዳናዉ ሃሳዬድኖ። ሄ ዎደ መꬍና ጎዳ ቦንቹ ጋከትያ ዱንካንያን እስራኤልያ አሳ ኡባዉ ቆንጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","መꬍና ጎዳይ ሙሳ፥ “ሀ አሳይ አዉደ ጋካናዉ ታና ካꬋኔ? ታን ኡንቱንቱ ግዱዋን ኦꬄዳ ማላታ ኡባ በኢደ፥ አዉደ ጋካናዉ ኡንቱንቱ ታናን አማነናን እጻኔ? ");
INSERT INTO dwrENT_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ታን ኡንቱንታ ኢታ ሀርግያን ሾጫደ ꬋይሳና፤ ያታደ ታን ኔና ኡንቱንቱፐ ዳርያነ ምንያ ካዉተꬃዉ አዉዋ ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ሙሴ መꬍና ጎዳ ሀዋዳን ያጊደ ዎሴዳ፤ “ኔን ነ ዎልቃን ሀ አሳ ግብጼፐ ፑደ ከሴዳዋ ኤርያ ግብጼቱ ሀዋ ስሶፐ፥ ኡንቱንቱ ዋጋኔ? ");
INSERT INTO dwrENT_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ኡንቱንቱ ሀ ጋድያን ደእያዋንቶካ ሄዋ ኦዳና። አቤት መꬍና ጎዳዉ፥ ኔን ሀ አሳ ግዱዋን ደእያዋ ኡንቱንቱ ስሴድኖ። አቤት መꬍና ጎዳዉ፥ ኑን ኔና በኤዳዋ ኡንቱንቱ ኤሬድኖ፤ ነ ሻሪ ኡንቱንቱፐ ቦላና ታክያዋነ ጋላስ ሻርያ ቱሳን፥ ቃማ ታማ ቱሳን ኔን ኡንቱንቱ ስንꬃን ብያዋ በኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ሀእ ኔን ሀ አሳ ኡባ እት ኩꬃን ዎꬍያዋ ግዶፐ፥ ነ ካሰ ኦꬄዳዋ ስሴዳ ካዉተꬃቱ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","መꬍና ጎዳይ ሀ አሳ፥ ‘ህንተዉ እማና ጊደ ጫቄዳ ቢታ ኡንቱንታ አፋናዉ ዳንዳይቤና ድራዉ፥ መላ ቢታን ኡንቱንታ ዎꬌዳ’ ያጊደ ሃሳያና። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","18","“ሄዋ ድራዉ፥ ጎዳዉ፥ ኔን ነ ዎልቃ ኑና በሳ፤ ኔን ጋደ፥ ‘መꬍና ጎዳይ ዳንዳያንቻነ አገና ሲቁዋን ኩሜዳዋ፤ ናጋራነ ማካላ አቶ ግያዋ፤ ግዶፐነ፥ ባይዛንቻ ሙረናን አገናዋ፤ አዎቱዋ ናጋራ ድራዉ ናናቱዋ ሄዘንꬃነ ኦይደንꬆ የለታ ጋካናዉ ሙርያዋ’ ጋደ ኦዳ ዎꬄዳዋ ፖላ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ሀ አሳይ ግብጼፐ ከሶደፐ ዶማደ ሀች ጋካናዉ ኔን አቶ ጌዳዋዳን፥ ነ አገና ሲቁዋ ዳሩዋን ሀ አሳ ናጋራ አቶ ጋርኪ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","መꬍና ጎዳይ ሙሳ፥ “ኔን ኦቼዳዋዳን ታን ኡንቱንቶ አቶ ጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ሽን ታ ደኡዋን ጫቃይ፤ መꬍና ጎዳ ቦንቹ ሳኣ ኡባ ኩምያዋዳን፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","ሀ አሳፐ እቱነ ሄ ቢታ በኤና። ታ ቦንቹዋነ ግብጼ ቢታንነ መላ ቢታ ታን ኦꬄዳ ማላታ ሀ አሳቱ በኤድኖ፤ ሽን ኡንቱንቱ ታሙ ገደ ታና ፓጬድኖነ ታ ቃላ ስሰናን እጼድኖ። ሄዋ ድራዉ፥ ታን ኡንቱንቱ ማይዛ አዋቶ እማና ጋደ ጫቄዳ ቢታ ታና ካꬌዳዋንቱፐ እቱነ ሙለካ በኤና። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ሽን ታ ቆማይ ካሌብ ኡንቱንቱፐ ዱማትያ ድራዉነ እ ታና ፖሎ ዎዛናፐ ካሌዳ ድራዉ፥ ታን እ ካሰ ቤዳ ቢታ አ ጋꬃና፤ አ ዘረꬃይ ሄ ቢታ ላታና። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ሽን ሀእ አማሌቃቱነ ካናነቱ ዛንጋራን ደእያ ድራዉ፥ ዎንት ጉየ ስሚደ፥ ዞኦ አባኮ አፍያ ኦግያ ኦይቂደ መላ ቢታ ቢተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ቃይ መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ሀ ኢታ አሳይ ታ ቦላ አዉደ ጋካናዉ ዙዙማኔ? ታን እስራኤልያ አሳ ዙዙንꬃ ኡባ ስሳድ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ሄዋ ድራዉ፥ ኔን ኡንቱንቶ ሀዋዳን ያጋደ ኦዳ፤ ‘ታ ደኡዋን ጫቃይ፤ ታን ህንተ ሃሳይሽን ታ ሀይꬃን ስሴዳዋ ህንተንቶ ኦꬃና። ታን መꬍና ጎዳይ ሄዋ ኦዳይ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ህንተ አሃይ ሀ መላ ቢታን ኩንዳና፤ አያዉ ጎፐ፥ አሳ ፓይድያ ዎደ ፓይደቴዳ ላታሙ ላይꬃነ ሄዋፐ ቦላና ደእያ አሳይ ኡባይ ታ ቦላ ዙዙሜድታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ይፉነ ናኣ ካሌባፐነ ኔዌ ናኣ ኢያሱፐ አትና፥ ህንተፐ ኦንነ ታን ህንተና ዎꬃናዉ ጫቄዳ ሄ ቢታ ገለና። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ህንተ፥ “ኑ ናናይ ኦሞደታና” ጌዳ ህንተ ጉꬃ ናናቱዋ ሄ ህንተ ካꬌዳ ቢታ ገልሳና፤ ቢታይካ ኡንቱንቱሳ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ሽን ህንተና ግዶፐ፥ ህንተ አሃይ ሀ መላ ቢታን ኩንዳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ህንተ አማነትቤና ድራዉ፥ ህንተ ዉርሰꬃ አሃይ ሀ መላ ቢታ ዉላና ጋካናዉ፥ ህንተ ናናይ ዋየቲደ፥ ሀ መላ ቢታ ኦይታሙ ላይꬃ ሄንꬃንቻ ግዲደ ዩያና። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ህንተ ሄ ቢታ ዎቼዳ ሄ ኦይታሙ ጋላሳ ፓይዱዋን፥ እት ጋላሳዉ እት ላይꬃ፥ ሄዌነ፥ ኦይታሙ ላይꬃዉ ህንተ ናጋራ ድራዉ ህንተ ዋየታና፤ ታን ህንተ ቦላ ደንድያዋ ህንተ ኤራና’ ያጋ ኦዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ታን መꬍና ጎዳይ ሀዋ ኦዳይ። ታ ቦላ ሺቅ ኡቴዳ ሀ ኢታ ማባራ ቦላ ሀዋዳን ቱሙ ኦꬃና: ኡንቱንቱ ሀ መላ ቢታን ዉራና፤ ሀዋን ኡንቱንቱ ሀይቃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ሄ ቢታ ዎቻና ማላ፥ ሙሴ ኡንቱንታ ኪትና ቢደ ስሜዳ አሳቱ፥ ሄ ቢታ ኢታ ኦዱዋ ኦዲደ፥ ሙሴ ቦላ አሳይ ኡባይ ዙዙማና ማላ ኦꬄዳዋንቱ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ሄ ኢታ ኦዱዋ ኦዴዳ አሳቱ፥ መꬍና ጎዳ ስንꬃ ቦሻን ሀይቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ሄ ቢታ ዎቻናዉ ቤዳ አሳቱዋፐ ይፉነ ናአይ ካሌብነ ኔዌ ናአይ ኢያሱ ጻላላይ ፓጻ አቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ሙሴ ሀዋ እስራኤልያ አሳዉ ኡባዉ ኦዴዳ ዎደ፥ አሳይ ሎይꬅ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ዎንተꬃ ጋላስ ዎንታ ጉራን ኡንቱንቱ ደንዲደ፥ ፑደ ገዘ ቢታ ከሲደ፥ “ኑን ናጋራ ኦꬄዶ፤ ሽን ሀእ ጾሳይ ኑዉ እማና ጌዳ ሳኣ ፑደ ከሳና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ሽን ሙሴ ኡንቱንታ፥ “መꬍና ጎዳ አዛዙዋ ህንተ አያዉ መንꬂቴ? ህንተዉ ሀነና። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","መꬍና ጎዳይ ህንተናና ደኤና ድራዉ፥ ፑደ ከሶፕተ፤ ህንተ ሞርከቱ ህንተና ጾናና። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","አማሌቃ አሳቱዋናነ ካናነ አሳቱዋና ህንተ ኦለታና፤ ህንተ ማሻን ሀይቃና። መꬍና ጎዳፐ ህንተ ዎራ ስሜዳ ድራዉ፥ መꬍና ጎዳይ ህንተናና ደኤና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ሽን ኡንቱንቱ መꬍና ጎዳ ጫቁዋ ታቦታይነ ሙሴነ ዱንካኔዳ ሳኣፐ ደንዳና ꬋዮፐካ፥ ገዘ ቢታ ከሳናዉ ጻሊደ ደንዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ገዘ ጋድያን ደእያ አማሌቃ አሳቱነ ካናነ አሳቱ ዎꬊደ ኡንቱንቱ ኦላይ ጾኒደ፥ ሆርማ ጋካናዉ ኡንቱንታ የደርሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“እስራኤልያ አሳዉ ሀዋዳን ያጋ፤ ‘ህንተ ደአና ማላ፥ ታን ህንተንቶ እምያ ቢታ ገልያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","መህያፐ ዎይ ዶርሳፐ፥ ጹግያ ያርሹዋ ግድና፥ ዎይ ሺቆዋ ጋꬃናዉ ያርሽያ ያርሹዋ ግድና፥ ዎይ መꬍና ጎዳይ ኬሬዳ ባላ ጋላሳቱዋን ህንተ ዶሱዋን ጮ እምያ ያርሹዋ ግድና፥ መꬍና ጎዳዉ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሾቱዋ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ያርሹዋ ሺሽያ ኡራይ ካꬃ ያርሾ እት ኪሎ ግራመ ꬊልያ እት ሊትሮ ዎጋራ ዛይትያን ሙናቄዳዋካ መꬍና ጎዳዉ አሆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ቃይ ጹግያ ያርሾ፥ ዎይ ሀራ ያርሾ አህያ እት እት ዶርሳና እት ሊትሮ ዎይንያ ኤሳ ኡሻ ያርሹዋ ኦꬂደ ጊግስተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘ዶርሳ ኦርግያ ያርሻናዉ ሺሽያ ዎደ፥ ካꬃ ያርሾ ላኡ ኪሎ ግራመ ꬊልያ እት ሊትሮነ ባጋ ዎጋራ ዛይትያን ሙናቄዳዋነ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","እት ሊትሮነ ባጋ ዎይንያ ኤሳ ኡሻ ያርሾ አህተ። መꬍና ጎዳዉ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘እት ኮሩማ ጹግያ ያርሹዋ፥ ዎይ ሺቁዋ ጋꬅያ ያርሹዋ፥ ዎይ እትፐተꬃ ያርሹዋ ኦꬂደ ያርሻናዉ መꬍና ጎዳዉ አህያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ኮሩማና እትፐ ካꬃ ያርሾ ሄዙ ኪሎ ግራመ ꬊልያ ላኡ ሊትሮ ዎጋራ ዛይትያን ሙናቄዳዋነ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ኡሻ ያርሾ ላኡ ሊትሮ ዎይንያ ኤሳካ አህተ። መꬍና ጎዳዉ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ታማን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“ ‘እት እት ኮሩማ ቦራ፥ ዎይ እት እት ዶርሳ ኦርግያ፥ ዎይ ያላጋ ዴሻ ኦርግያ፥ ዎይ አቱማ ዶርሳ ማራ ያርሻናዉ ሺሽያ ዎደ፥ ካꬃ ያርሹነ ኡሻ ያርሹ ሀዋዳን እትፐ ሺቄ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","እት መህያፐ ዳሩ ሺቅያ ዎደ፥ ካꬃ ያርሹነ ኡሻ ያርሹ ሄዋዳን ዳሪደ ሺቄ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","እስራኤልያ አሳ ግድያ ኦንነ ታማን ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ መꬍና ጎዳዉ ሺሽያ ዎደ ኡባን፥ ሀዋዳን ኦꬃናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ስንꬃፐ ያና የለታን ህንተ ግዶን ደእያ በቲ ዎይ ሀራ አሳይ ኦንነ ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ መꬍና ጎዳዉ ሺሻናዉ ኮዮፐ፥ እካ ህንተ ኦꬅያዋዳን ኦꬃናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ህንተዉካ ህንተ ግዶን ደእያ በተቶካ ሀ ዎጋይ እቱዋ፤ ሀዌ ስንꬃፐ ያና የለታዉካ ኤቂደ ደእያ ዎጋ። ህንተካ በተቱካ መꬍና ጎዳ ስንꬃን እቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ህንተዉካ ህንተ ግዶን ደእያ በተ አሳቶካ ህጊነ ዎጋይ እቱዋ ግዳና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ታን ህንተና አፍያ ቢታ ህንተ ገሊደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ሄ ጋድያን ሞክያ ካꬃ ምያ ዎደ፥ ሄ ካꬃፐ ጼራ ከሲደ፥ ህንተ መꬍና ጎዳዉ ያርሹዋ ኦꬂደ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ሄዌካ፥ ባይራ ካኤዳ ካꬃፐ ኡኬዳ ኮይሮ ኮምፑዋ፥ ካꬃ ቡክያ ኡዱማፐ እምያ ያርሹዋ ኦꬂደ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ያና የለታ ኡባን ህንተ ህንተ ጋድያን ሞኬዳ ካꬃፐ ጼራ ከሴዳ ኮምፑዋ፥ መꬍና ጎዳዉ ያርሹዋ ኦꬂደ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘መꬍና ጎዳይ ኦዴዳ ሀ አዛዞቱዋ ኡባ ህንተ ኤራና ꬋዪደ፥ ናገናን አጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","መꬍና ጎዳይ አ ባጋና ህንተና አዛዜዳ አዛዞቱዋ ኡባ፥ መꬍና ጎዳይ እሜዳ ጋላሳፐ ዶሚደ፥ ያና የለታ ጋካናዉ፥ ፓጨናን ናገናን አጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ቃይ ሄዋ ማባራይ ኤረናን ኦꬄዳዋ ግዶፐ፥ ማባራይ ኡባይ መꬍና ጎዳዉ እት ኮሩማ ጹግያ፥ ሳዉዋ ቶሹኩ ግያ ያርሹዋ ኦꬂደ፥ አዉ ዎጋይ አዛዝያዋዳን፥ ካꬃ ያርሹዋናነ ኡሻ ያርሹዋና ሺሾ፤ ቃይ ናጋራ ያርሹዋ ኦꬂደ፥ እት ዴሻ ኦርግያ ሺሾ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ያቶፐ ቄሲ ኩመንꬃ እስራኤልያ ማባራ ናጋራ አቶ ጊስያ ዎጋ ፖሎ፤ ኡንቱንቱ ናጋራይ አቶ ጌተታና። አያዉ ጎፐ፥ ኡንቱንቱ ኤሪደ ኦꬅበይክኖ፤ ቃይ ኡንቱንቱ ባረንቱ ባይዙዋ ድራዉ፥ መꬍና ጎዳዉ ታማን ጹግያ ያርሹዋነ ባረንቱ ናጋራ ያርሹዋ ሺሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","አሳይ ኡባይ ኤረናን ሄ ባይዙዋን ሀምባላቼቴዳ ድራዉ፥ ኩመንꬃ እስራኤልያ ማባራዉካ ኡንቱንቱ ግዶን ደእያ በተ አሳዉካ አቶ ጌተታና። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘እት አሳይ ባረካ ኤራና ꬋዪደ ናጋራ ኦꬆፐ፥ የለቶደፐ እት ላይꬃ ግድያ እት ዴሻቶ ናጋራ ያርሹዋ ኦꬂደ ሺሾ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ኤረናን ደኢደ ናጋራ ኦꬄዳ ኡራዉ ቄሲ መꬍና ጎዳ ስንꬃን ናጋራ አቶ ጊስያ ዎጋ ፖሎ፤ አ ናጋራይ አቶ ጌተታና። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ኤረናን ደኢደ ናጋራ ኦꬅያ አሳ ኡባዉ፥ የለታን እስራኤልያ አሳ ግድናካ በተ አሳ ግድናካ ሀ ህጊ እቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘ሽን የለታን እስራኤልያ አሳ ግድናካ በተ አሳ ግድናካ ኤሪደ ኦቶሩዋን ናጋራ ኦꬅያ ኡራይ መꬍና ጎዳ ቦሬ። ሄ ኡራይ ባረ አሳ ግዶፐ ቦሄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ሄ አዉ መꬍና ጎዳ ቃላ ካꬌዳ ድራዉነ አ አዛዙዋ መንꬄዳ ድራዉ፥ እ ቱሙዋፐ አሳ ግዶፐ ቦሄታናዉ በሰ፤ አ ባይዙ አና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","እት ጋላስ እስራኤልያ አሳይ መላ ቢታ ደእሽን፥ እት ብታኒ ሳምባታን ምꬃ ምጺደ ቤቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ምꬃ እ ምጽሽን ደሜዳ አሳቱ ሙሴኮ፥ አሮነኮነ ኩመንꬃ ሽቁዋኮ አ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ኡንቱንቱ አ ኦꬃናዋ ኤርቤና ድራዉ፥ ቃሹዋን ታክሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ “ሀ ብታኒ ሀይቃናዉ በሰ፤ ኩመንꬃ ያአይ ባረንቱ ዱንካኔዳ ሳኣፐ ጋጻ ከሲደ፥ ሹቻን ጫዲደ አ ዎꬎ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ኩመንꬃ ያአይ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ዱንካኔዳ ሳኣፐ ጋጻ ከሲደ፥ ሹቻን ጫዲደ አ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“እስራኤልያ አሳዉ ሀዋዳን ያጋደ ኦዳ፤ ‘ህንተካ ስንꬃፐ ያና የለታይካ ህንተ ማዩዋ ጋጻ ጼራን ጼራን ማጫራ ከስተ፤ ሄ ማጫራ ቦላ ሳሉዋ ማላትያ ቃጭና ስክተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ሄ ማጫራ ህንተ በእያ ዎደ ኡባን መꬍና ጎዳ አዛዞቱዋ ሀሳዪደ ፖልተ፤ ያቶፐ፥ ህንተ ህንተ አይፍያነ ህንተ ዎዛና አሙዋ ካሊደ፥ ታፐ ዎራ ስምክታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ሄ ማጫራ በእያዋን ህንተ ታ አዛዞቱዋ ኡባ ሀሳዪደ ፖላናነ ህንተ ህንተ ጾሳዉ ጌሻ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ታን መꬍና ጎዳ፥ ህንተ ጾሳቴ፤ ታን ህንተ ጾሳ ግዳናዉ፥ ህንተና ግብጼፐ ከሳድ። ታን መꬍና ጎዳ፥ ህንተ ጾሳ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ሌዊያ ዛርያፐ ቃሃታ ያራ ግድያ ይጽሃራ ናአይ ቆራህ፥ ሮቤላ ዛርያፐ ኤልኣባ ናናይ ዳታንነ አቢራምነ ቃይ ፐሌታ ናአይ ኦንስ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ሙሴ ቦላ ደንዴድኖ። ኡንቱንቱና ላኡ ጼታነ እሻታሙ እስራኤልያ አሳቱ ደኢኖ፤ ኡንቱንቱ ኤረቴዳ አሳነ ማባራን ዶረቴዳ ካለꬅያዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ኡንቱንቱ ሙሴነ አሮና ስንꬃ ሺቂደ፥ ሀዋዳን ያጌድኖ፤ “ህንተ ዳርሴድታ! ማባራይ ኡባይ ሁጲያን ሁጲያን ጌሻ፤ መꬍና ጎዳይካ ኡንቱንቱ ግዱዋን ደኤ፤ ያትና መꬍና ጎዳ ማባራ ቦላ ህንተና አያዉ ꬎቁ ꬎቁ ኦꬂቴ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ሙሴ ሀዋ ስሴዳ ዎደ ጾሳ ስንꬃን ሳኣን ጉፋኔዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ቆራሀነ አ ጭታ ኡባ፥ “ዎንት ዎንታ መꬍና ጎዳይ ኦን ናጋራንቼንቶነ ኦን ጌሸንቶ በሳና፤ እ ሄ ዶርያ አሳ ባረኮ ሺሻና። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ቆራሀ፥ ኔንነ ነ ጭታይ ኡባይ ሀዋ ኦꬅተ: ዎንት እጻና ጩዋይያዋንታ አኪደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ቦንቁዋ አን ዎꬂደ፥ መꬍና ጎዳ ስንꬃን እጻና ጩዋይተ። መꬍና ጎዳይ ዶርያ አሳይ፥ እ ጌሻ ግዳናዋ። ሌዊያ ዛረቶ፥ ህንተ ዳርሴድታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ሙሴ ቃይካ ቆራሀ፥ “ህንተኖ ሌዊያ ዛረቶ፥ ስስተ! ");
INSERT INTO dwrENT_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","እስራኤልያ መꬍና ጎዳይ ህንተና እስራኤልያ ማባራፐ ዱማዪደ፥ መꬍና ጎዳ ዱንካንያ ኦሱዋ ኦꬃና ማላነ አሳ ስንꬃን ሄ ኦሱዋ ኦꬃናዉ ህንተ ኤቃና ማላ፥ ባረኮ ሺሼዳዌ ህንተንቶ ጉጼዴ? ");
INSERT INTO dwrENT_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","እ ህንተናነ ህንተ እሻቱዋ ሌዋቱዋ ኡባ ባረኮ ሺሼዳ፤ ቃይ ሀእ ህንተ ቄሰተꬃካ ካጄሊታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ኔንነ ነ ጭታይ ኡባይ አሮና ቦላ ዙዙምያዌ፥ እ ኦኔ? ህንተንቱ መꬍና ጎዳ ቦላ ማካሊታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ሄዋፐ ጉይያን፥ ሙሴ ኪቲደ ኤልኣባ ናናቱዋ፥ ዳታናነ አቢራማ ጼስሴዳ፤ ሽን ኡንቱንቱ አ፥ “ኑን ቦኮ! ");
INSERT INTO dwrENT_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ኔን መላ ቢታን ኑና ዎꬋናዉ ማꬃይነ ኤሳይ ጎግያ ጋድያፐ ከሴዳዌ ጉጼዴ? ቃይ ሀእ ኔን ኑ ቦላ ካፑዋ ግዳናዉ ኮያይ? ");
INSERT INTO dwrENT_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ሄዋ ቦላካ ቃይ ማꬃይነ ኤሳይ ጎግያ ቢታ ኔን ኑና ገልሳባካ፥ ዎይ ኔን ኑዉ ላታ ኦꬃደ ጋድያነ ዎይንያ ቱራ እማባካ፤ ኔን ሀ አሳ ጭማሳ። ኑን ቦኮ!” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ሙሴ ሎይꬅ ሀንቀቲደ መꬍና ጎዳ፥ “ኡንቱንቱ ያርሽያ ያርሹዋ አኮፓ፤ ታን ኡንቱንቱፐ ሀርያ እቱዋነ አካበይከ፥ ዎይ ታን ኡንቱንቱፐ እት አሳነ ናቃበይከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ቃይ ሙሴ ቆራሀ፥ “ዎንት ኔን፥ ነ ጭታይ ኡባይነ አሮን መꬍና ጎዳ ስንꬃን ግድተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","እት እት አሳይ ባረ እጻና ጩዋይያዋ ኡባና ላኡ ጼታነ እሻታሙዋ አኪደ፥ እጻና አን ዎꬂደ፥ መꬍና ጎዳ ስንꬃ ሽሾ። ቃይ ኔንነ አሮን ህንተ እጻና ጩዋይያዋንታ አህተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","አሳይ ኡባይካ ባረ እጻና ጩዋይያዋ አኪደ፥ ቦንቁዋነ እጻና አን ዎꬄዳ፤ ጋከትያ ዱንካንያ ፐንግያን ሙሴናነ አሮናና ኤቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ቆራህ ኩመንꬃ ማባራ ጋከትያ ዱንካንያ ፐንግያን ሺሼዳ። ሄ ዎደ መꬍና ጎዳ ቦንቹ ኩመንꬃ ማባራዉ ቆንጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","መꬍና ጎዳይ ሙሳነ አሮና፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ታን እት ኩꬃን ሀ ማባራ ꬋይሳና ሀንያ ድራዉ፥ ኡንቱንቱፐ ሻከትተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ሽን ሙሴነ አሮን ሳኣን ጉፋኒደ፥ “አቤት ጾሳዉ፥ አሹዋ ማዬዳ አሳ ኡባ መꬌዳ ጾሳዉ፥ እት ኡራይ ናጋራ ኦꬆፐ፥ ኔን ኩመንꬃ ማባራ ሀንቀታይ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ያትና መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ኔን ማባራ፥ ‘ቆራሀ፥ ዳታናነ አቢራማ ዱንካነቱዋፐ ክችተ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ሙሴ ደንዲደ፥ ዳታነኮነ አቢራመኮ ቢና፥ እስራኤልያ ጭማቱ አ ካሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ማባራ እ፥ “ሀ ኢታ አሳቱ ዱንካነቱዋፐ ክችተ፤ ኡንቱንቱዋ ግዴዳዋ አያነ ቦቾፕተ። ሄንኮደ ኡንቱንቱ ናጋራ ኡባ ጋሱዋን ህንተካ ፕተት ꬋያና” ያጊደ ምንሲደ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ኡንቱንቱ ቆራሀ፥ ዳታናነ አቢራማ ዱንካነቱዋፐ ክቼድኖ። ዳታንነ አቢራም ካረ ከሲደ፥ ባረንቱ ማቼቱዋና፥ ባረንቱ ናናቱዋና ባረንቱ ጉꬃ ናናቱዋና ባረንቱ ዱንካነቱዋ ፐንግያን ኤቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ሙሴ አሳ፥ “ታን ሀ ኦሶ ኡባ ኦꬃና ማላ፥ መꬍና ጎዳይ ታና ኪቴዳዋነ ታን ታ ሸንያን ኦናዋ ህንተ ሀዋን ኤራና። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ሀ አሳቱ አሳይ ሀይቂያዋዳን ሀይቆፐ፥ ዎይ አሳ ቦላ ጋክያዋ ጻላላይ ኡንቱንቱ ቦላ ጋኮፐ፥ መꬍና ጎዳይ ታና ኪትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ሽን መꬍና ጎዳይ ኡባና ኦራꬃባ ኦꬅና፥ ቢታይ ዶየቲደ ኡንቱንታነ ኡንቱንቶ ደእያዋ ኡባ ምት አጎፐ፥ ኡንቱንቱ ፓጻ ደኢደ ስኦልያ ዱገ ዎꬎፐ፥ ሄ ዎደ ሀ አሳቱ መꬍና ጎዳ ካꬌዳዋ ህንተ ኤራና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","እ ያጊደ ዉርሴዳ ዎደ፥ ኡንቱንቱ ኤቄዳ ቢታይ ጳልቀት ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ቢታይ ዶየቲደ፥ ኡንቱንታነ ኡንቱንቱ ሶ አሳ፥ ቆራሀ ጭታ ኡባ ኡንቱንቶ ደእያዋ ኡባና ምት አጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ያትና ኡንቱንቱ ባረዉ ደእያዋ ኡባና ፓጻ ደኢደ፥ ስኦልያ ዱገ ዎꬌድኖ። ቢታይካ ኡንቱንቱ ቦላ ጎርደት አጌዳ፤ ኡንቱንቱ ማባራ ግዶፐ ትፕ ጊደ ꬋይ አጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ኡንቱንቱ ዋሱዋን ኡንቱንቱ ማታን ደእያ እስራኤላቱ ኡባይ፥ “ቢታይ ኑናካ ቃይ ምታና ሀኔ!” ያጊድ ባቃቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ቃይ ታማይካ መꬍና ጎዳ ማታፐ ዪደ፥ እጻና ጩዋይያ ላኡ ጼታነ እሻታሙ አሳ ም አጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“ኔን ቄስያ አሮና ናኣ ኤልኣዛራዉ ያጋደ ኦዳ፥ ‘እጻና ጩዋይያባቱዋ ታማን ጹገቴዳ አሳ ግዶፐ አካ፤ ቦንቁዋ ጩዋይያባቱዋፐ ሃሳደ ላላ። ሄ እጻና ጩዋይያባቱ ጌሻ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ባረ ናጋራ ድራዉ ሀይቄዳ ሀ አሳቱ እጻና ጩዋይያባቱዋ ሌእሳደ ቆጻደ፥ ያርሹዋ ሳጽንያ ካማ። ኡንቱንቱ ሄዋንታ መꬍና ጎዳ ስንꬃን ሺሼዳ ድራዉ፥ ሄዋንቱ ጌሻ፤ ሄዋንቱ እስራኤላቱዋ ሀሳይስያ ማላታ ግዳና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ቄሲ ኤልኣዛር ጹገቴዳ አሳቱ ሺሼዳ ናሃሰ ብራታፐ ኦሰቴዳ እጻና ጩዋይያባቱዋ አኪደ፥ ያርሹዋ ሳጽንያ ካማናዉ ሌእሲደ ቆጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","አሮና ዛረ ግደና ኦንነ መꬍና ጎዳ ስንꬃን እጻና ጩዋያናዉ ሺቀና ማላ፥ ቆራሀነ አ ጭታ ጋኬዳዌ አ ጋከና ማላ፥ እስራኤላቱዋ ሀሳይሳናዉ ሀዋንታ ኦꬄዳ። መꬍና ጎዳይ ሙሴ ባጋና ኤልኣዛራ አዛዜዳዋዳን ሀዌ ሀኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ዎንተꬃ ጋላስ እስራኤልያ ማባራይ ኡባይ፥ “መꬍና ጎዳ አሳ ህንተ ዎꬌድታ” ያጊደ፥ ሙሴ ቦላነ አሮና ቦላ ዙዙሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ማባራይ ሙሴነ አሮና ቦላ ደንዳናዉ ሺቂደ፥ ጋከትያ ዱንካንያኮ ስም ጼልያ ዎደ፥ ሻሪ ጋከትያ ዱንካንያ ካምና፥ መꬍና ጎዳ ቦንቹ ቆንጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ሄዋፐ ጉይያን፥ ሙሴነ አሮን ጋከትያ ዱንካንያ ስንꬃዉ ዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ሀ አሳ ግዱዋፐ ክችተ፤ ታን ኡንቱንታ እት ኩꬃን ꬋይሳ ባሻና” ያጌዳ። ኡንቱንቱ ሳኣን ጉፋኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ሙሴ አሮና፥ “ነ እጻና ጩዋይያዋ አካደ፥ ቦንቁዋ ያርሽያ ሳኣፐ አካደ፥ እጻና አን ዎꬃ፤ ኡንቱንቶ አቶ ጊሳናዉ ኤለካ ማባራኮ አፋ። አያዉ ጎፐ፥ መꬍና ጎዳ ሀንቁ አ ማታፐ ከስ ክቼዳ፤ ቦሻይካ ዶም ክቼዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ሙሴ ጌዳዋዳን አሮን ባረ እጻና ጩዋይያዋ አኪደ፥ ማባራ ግዶ ዎጼዳ። ቦሻይ አሳ ግዱዋን ዶም ደእሽን፥ አሮን እጻና ጩዋዪደ፥ አሳዉ አቶ ጊሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ያቲደ እ ሀይቄዳዋንቱፐነ ፓጻ ደእያዋንቱፐ ግዱዋን ኤቂና፥ ቦሻይ አግ አጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ቆራሀ ጋሱዋን ሀይቄዳ አሳይ ፓይደተናን፥ ሀ ቦሻን ሀይቄዳዋንቱ 14,700. ");
INSERT INTO dwrENT_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ቦሻይ ኤቄዳዋፐ ጉይያን፥ አሮን ጋከትያ ዱንካንያ ፐንግያን ደእያ ሙሴኮ ስሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ኔን፥ ‘ህንተ ዛርያን ዛርያን ህንተ ካፓቱዋፐ ሁጲያን ሁጲያን እት እት ጻምኣ ኡባና ታማነ ላኡ ጻምኣ ታዉ እምተ’ ያጋደ እስራኤላቱዋፐ አካ። እት እት አሳ ሱንꬃ ጻምኣ ቦላን ጻፋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","እት እት ዛርያ ካፖ እት ጻምኣ ግድያ ድራዉ፥ ሌዊያ ጻምአን አሮና ሱንꬃ ጻፋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ጋከትያ ዱንካንያ ግዶን ታን ኔናና ጋከትያ ማርካተꬃ ታቦታ ስንꬃን ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ታን ዶርያ አሳ ጻምአይ አጫና፤ ሀዋዳን ኦꬃደ ህንተ ቦላን እስራኤላቱ ዙዙምያ ዙዙንꬃ ታን ሙለ ꬋይሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ሙሴ እስራኤልያ አሳዉ ኦድና፥ ኡንቱንቱ ካፓቱ ታማነ ላኡ ጻምአቱዋ፥ እት እት ዛርያ ካፓቱ እት እት ጻምኣ አዉ እሜድኖ። ሄ ጻምአቱዋ ግዱዋን አሮና ጻምአይካ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ሙሴ ሄ ጻምኣ ኡባ ማርካተꬃ ዱንካንያ ግዶን መꬍና ጎዳ ስንꬃን ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ዎንተꬃ ጋላስ ማርካተꬃ ዱንካንያ ግዶ ሙሴ ገሌዳ ዎደ፥ ሌዊያ ዛረ ግድያ አሮና ጻምአይ አጬዳዋ፥ ጉምቤዳዋ፥ ጪሼዳዋነ ጪሺደ ላዉዝያ ግያ ምꬃ አይፍያ አይፌዳዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ሄዋፐ ጉይያን፥ ሙሴ ጻምኣ ኡባ መꬍና ጎዳ ስንꬃፐ እስራኤልያ አሳ ኡባኮ አሄዳ። አሳይ ኡንቱንታ በኤዳዋፐ ጉይያን፥ ካፓቱ ባረንቱ ጻምኣ ጻምኣ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","መꬍና ጎዳይ ሙሳ፥ “አሮና ጻምኣ ታቦታ ስንꬃን ዛራ ዎꬃ። ሄዋ ማካሌዳዋንቱ ታ ቦላ ላኤንꬆ ዙዙሚደ ሀይቀናዳን፥ ኡንቱንቶ ማላታ ኦꬃደ ናጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","መꬍና ጎዳይ አዛዜዳዋዳን ሙሴ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","እስራኤልያ አሳይ ሙሳ፥ “ኑን ሀይቃና፤ ꬋያና፤ ኑን ኡባይካ ꬋያና! ");
INSERT INTO dwrENT_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","መꬍና ጎዳ ዱንካንያኮ፥ ሀራይ አቶ ማታ ሺቅያ ኡራይ ኦንነ ሀይቃና። ስም ኑን ኡባይካ ሀይቄቶ?” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","መꬍና ጎዳይ አሮና፥ “ኔን፥ ነ አቱማ ናናቱነ ሌዋቱ ጌሻ ሳኣ ኦሱዋን ፖለትያ ናጋራ ቶካና፤ ኔንነ ነ አቱማ ናናቱ ጻላላይ ህንተ ቄሰተꬃ ኦሱዋን ፖለትያ ናጋራ ቶካና። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ኔንነ ነ አቱማ ናናይ ማርካተꬃ ዱንካንያ ስንꬃን ኦꬅያ ዎደ፥ ኔናና ግዲደ ማዳና ማላ፥ ሌዊያ ዛረ ግድያ ነ ዳቦቱዋ አሀ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ኡንቱንቱ ህንተፐ ጋርሳና ዱንካንያ ኦሶ ኡባ ኦꬅኖ፤ ሽን ኡንቱንቱካ ህንተካ እትፐ ሀይቀናዳን፥ ኡንቱንቱ ጌሻ ሳኣ ሚሻኮነ ያርሽያ ሳኮ ሺቆፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ኡንቱንቱ ህንተናና እትፐ ግድኖ፤ ጋከትያ ዱንካንያን ደእያ ኦሶ ኡባ ኦꬅኖ። ሌዋቱዋፐ አትና፥ ሀራ ኡራይ ኦንነ ህንተኮ ሺቆፖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ላኤንꬁዋ እስራኤላቱዋ ቦላ ሀንቁ ዎና ማላ፥ ጌሻ ሳኣነ ያርሽያ ሳኣ ኦሱዋ ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ሌዋቱዋ ህንተ ዳቦቱዋ እስራኤላቱዋ ግዶፐ ታን ታ ሁጲያዉ ዶራድ። ኡንቱንቱ ጋከትያ ዱንካንያ ኦሱዋ ኦꬃናዉ ህንተንቶ እሙዋዳን እማደ፥ መꬍና ጎዳዉ ዱማያድ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ሽን ኔንነ ነ አቱማ ናናቱ ጻላላይ ያርሽያ ሳኣ ኦሱዋ ኡባነ ጋርዱዋ ግዶን ደእያ ቄሰተꬃ ኦሶ ኡባ ኦꬅተ። ቄሰተꬃ ኦሱዋ ታን ህንተንቶ እሙዋዳን ኦꬃደ እማይ፤ ሀራ ኡራይ ኦንነ ጌሻ ሳኣኮ ሺቅያዌ ሀይቆ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ሄዋፐ ጉይያን መꬍና ጎዳይ አሮና፥ “እስራኤላቱ ታዉ እምያ ጌሻ እሞታ ኡባ ታን ነዉ እማድ። ታን ነዉ ነ ድራውነ ነ አቱማ ናናዉ ኡንቱንቱ ድራዉ መꬍናዉ ግሻ ኦꬃደ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ታዉ እምያ አꬌዳ ጌሻ እሙዋፐ ታማን ጹገተና ባጋይ ህንተሳ ግዳናዋ: ኡንቱንቱ ታዉ እምያ ጌሻ እሙዋ ኡባፐ ካꬃ ያርሹ፥ ዎይ ናጋራ ድራዉ ያርሽያ ያርሹ፥ ዎይ ናቁዋ ድራዉ ያርሽያ ያርሹ ኔሳነ ነ አቱማ ናናቱዋሳ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ህንተ ሄዋ ጌሻ ሳኣን ሚተ፤ አቱማዌ ኡባይ ሄዋ ሞ፤ ሄዌ ህንተዉ ጌሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ሀዌ ቃይ ኔሳ። እስራኤላቱዋ ቃꬆ ያርሹዋ ኡባ ነዉ፥ ነ አቱማ ናናቶነ ነ ማጫ ናናዉ መꬍናዉ ግሻ ኦꬃደ እማይ፤ ህንተ ጎልያ አሳ ግዶን ዎጋዳን ጌሻ ግድያ ኡባይ ሄዋ ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“ኡንቱንቱ ታዉ እምያ ኮይሮ አይፍያፐ ሎኦ ዎጋራ ዛይትያ ኡባ፥ ያላጋ ዎይንያ ኤሳ ኡባነ ሙሩታ ካꬃ ኡባ መꬍና ጎዳዉ እማይ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ኡንቱንቱ መꬍና ጎዳዉ አህያ ኡንቱንቱ ጋድያን ደእያ ኮይሮ ጋኬዳ አይፊ ህንተሳ፤ ህንተ ጎልያ አሳ ግዶን ዎጋዳን ጌሻ ግድያ ኡባይ ሄዋ ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“እስራኤልያን መꬍና ጎዳዉ ዱማቴዳባይ ኡባይ ህንተሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ባይራ የለቴዳ አሳይ ዎይ መሂ፥ እስራኤላቱ መꬍና ጎዳዉ እሜዳዌ ህንተሳ። ሽን ባይራ የለቴዳ አሳነ ባይራ የለቴዳ ጌሻ ግደና መህያ ህንተ ዎዛናዉ በሰ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","እት አግና ናናቱዋ ዎዛናዉ ዱንካንያን ኤርቲያ ሚዛንያ (20 ጌራ) ልክያን እቼሹ ጻጋራ ብራ ዎዞ ጋትያ ቃንጽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","ሽን ሚዛ ባይራ፥ ዎይ ዶርሳ ባይራ፥ ዎይ ዴሻ ባይራ ህንተ ዎዛናዉ ኮሸና፤ ኡንቱንቱ ጌሻ። ኔን ኡንቱንቱ ሱꬃ ያርሽያ ሳኣ ቦላን ጫጫፋ፤ መꬍና ጎዳ ቶሹኩ ጊደ ሳዋና ማላ፥ ኡንቱንቱ ሞꬉዋ ታማን ጹጋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ኡንቱንቱፐ ቤትያ አሹ ዉጻኬዳ አንጎሱዋዳንነ ኡሸቻ ገድያዳን ህንተሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","እስራኤላቱ መꬍና ጎዳዉ እምያ ጌሻ ያርሹዋ ኡባ ነዉ፥ ነ አቱማ ናናቶነ ነ ማጫ ናናቶ መꬍናዉ ግሻ ኦꬃደ እማይ። ሀዌካ መꬍና ጎዳይ ኔናናነ ነ ዘረꬃቱዋና ጫቀትያ ማጽንያ ጫቁዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ቃይካ መꬍና ጎዳይ አሮና፥ “ኡንቱንቱ ጋድያን ኔን አይነ ላታካ፤ ኡንቱንቱ ግዶን ኔና ጋክያ ሻኩ አያይካ ባዋ፤ እስራኤላቱዋ ግዶን ነ ላታይነ ኔና ጋክያ ሻኩ ታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ጾሳይ፥ “ሌዋቱ ጋከትያ ዱንካንያን ኦꬅያ ኦሱዋ ድራዉ፥ እስራኤላቱዋ አስራታ ኡባ ኡንቱንቶ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ሀቼፐ ዶሚደ፥ እስራኤልያ አሳቱ ባረንቱ ናጋራን ሀይቀና ማላ፥ ጋከትያ ዱንካንያኮ ሺቆፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ጋከትያ ዱንካንያ ኦሱዋ ኦꬅያዋንቱነ ሄዋን ፖለትያ ናጋራ ቶክያዋንቱ ሌዋቱዋ። ሀዌ የለታ ኡባዉ መꬍና ዎጋ። ሌዋቱ እስራኤልያ አሳ ግዱዋን አይነ ላትክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ሄዋ ድራዉ፥ እስራኤላቱ መꬍና ጎዳዉ እሙዋዳን እምያ አስራታ፥ ታን ሌዋቶ ኡንቱንታ ላታዳን እማድ። ታን ኡንቱንቱባ፥ ‘ኡንቱንቱ እስራኤልያ አሳ ግዱዋን አይነ ላትክኖ’ ያጌዳዌ ሄዋሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ቃይ መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ኔን ሌዋቱዋ ሀዋዳን ያጋ፤ ‘ታን ህንተንቶ ላታዳን እሜዳ አስራታ ህንተ እስራኤልያ አሳፐ አክያ ዎደ፥ ህንተ ሄ አስራታፐ አስራታ መꬍና ጎዳዉ እምተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ህንተ እሙ ህንተንቶ ካꬃ ቡክያ ኡዱማ ካꬃዳንነ ጉምእያ ዎይንያ አይፍያዳን ፓይደቴ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ቃይ ሀዋዳን እስራኤልያ አሳፐ ህንተ አክያ አስራታ ኡባፐ እሙዋ መꬍና ጎዳዉ እምተ፤ ሀ አስራታፐ መꬍና ጎዳ ድራዉ ቄስያ አሮናዉ ህንተ እማናዉ በሰ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ህንተ አክያ እሞታ ኡባፐ፥ ሎእያዋነ ጌሻ መꬍና ጎዳዉ ግሹዋ ኦꬂደ፥ ህንተ እማናዉ በሴ’ ያጋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“ቃይ ኔን ሌዋቱዋ፥ ‘ኡባፐ ሎኦ እሙዋ ህንተ እሜዳዋፐ ጉይያን፥ አቴዳዌ ህንተንቶ ካꬃ ቡክያ ኡዱማ ካꬃዳንነ ጉምእያ ዎይንያ አይፍያዳን ፓይደታና። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ህንተነ ህንተ ጎልያ አሳይ ሄዋፐ አቴዳዋ ሀቃንነ ሚተ፤ አያዉ ጎፐ፥ ሄዌ ጋከትያ ዱንካንያን ህንተ ኦꬅያ ኦሶ ህንተ ድርጉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ሎኦ ባጋ ጾሳዉ እም ድጌዳዋፐ ጉይያን ህንተ ምያ ዎደ፥ ባይዛንቻ ግድክታ። ሽን ሎኦ ባጋ ሄ እሞታፐ ከሰናን ደኢደ፥ ህንተ እስራኤልያ አሳ እሞታ ቱንሰናዳን ናገትተ። ሄዋዳን ኦꬃና ꬋዮፐ፥ ህንተ ሀይቃና’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","መꬍና ጎዳይ ሙሳነ አሮና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“መꬍና ጎዳይ ህግያን አዛዜዳ ዎጋይ ሀዋ: ትላ ቦላና ደእያ ዎይ ቦርስያባይ ባይና፥ እ ሞርግያን ሞርገ ምꬃይ ዎꬍቤና ዞኦ ኡሳቶ ነዉ አሀና ማላ፥ እስራኤልያ አሳዉ ኦድተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ቄስያ ኤልኣዛራዉ እዞ እምተ፤ እ እዞ ዱንካኔዳ ሳኣፐ ጋጻ አፍና፥ እት አሳይ እዞ አ ስንꬃን ሹኮ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ቄስያ ኤልኣዛር እ ሱꬃፐ አማሬዳዋ ባረ ብራꬍያን አኪደ፥ ጋከትያ ዱንካንያዉ ስንꬃ ባጋና ላፑን ገደ ጫጫፎ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","እ ጼልሽን ኡሳታ ጹገቱ፤ እ ጋልባይ፥ አሹ፥ ሱꬃይነ ቶጪ ጹገቶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ቄሲ ዝጋ፥ ሂሶጵያ ታሽያነ ዞኦ ቁንጩትያ አኪደ፥ ኡሳቶ ጹግያ ታማን ኦሎ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ሄዋፐ ጉይያን፥ ቄሲ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሃꬃን ሜጨቶ፤ ያትደ ዱንካኔዳሳ ገሎ፤ ሽን ኦማርሳ ጋካናዉ እ ዎጋዳን ቱና ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ሄ ኡሳቶ ጹጌዳዌ ቃይ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሃꬃን ሜጨቶ፤ እካ ቃይ ኦማርሳ ጋካናዉ ዎጋዳን ቱና ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ሄዋፐ ጉይያን፥ ጌሻ አሳይ ኡሳታ ጹገቴዳ ብድንꬃ ሺሺደ፥ ዱንካኔዳ ሳኣፐ ጋጻና ጌሻ ሳኣን ዎꬆ። እስራኤልያ አሳይ ቱናተꬃፐ ጌይያ ሃꬃን ጎኤታናዉ ሄዋ ናግ ዎꬃና፤ ሄዌ ናጋራፐ ጌሻናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ቃይ ኡሳት ብድንꬃ ሺሼዳ አሳይ ባረ ማዩዋ ሜጮ፤ ኦማርስ ጋካናዉ እ ዎጋዳን ቱና ግዳናዋ። ሀ ዎጋይ እስራኤልያ አሳዉነ ኡንቱንቱ ግዱዋን ደእያ ሀራ ጋደ አሳዉ ላኦካ መꬍና ዎጋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ሀይቄዳ አሳ አሃ ቦችያ ኦንነ ላፑን ጋላሳ ዎጋዳን ቱናና። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ሄ ቱናተꬃፐ ጌይያ ሃꬃን ሄዛንꬃ ጋላስነ ላፑንꬃ ጋላስ፥ እ ባረና ጌሾ፤ ሄዋፐ ጉይያን፥ እ ዎጋዳን ጌሻ ግዳናዋ፤ ሽን ሄዛንꬃ ጋላሳንነ ላፑንꬃ ጋላሳን ባረና ጌሻና ꬋዮፐ፥ እ ጌሻ ግደና። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ሀይቄዳ ኡራ አሃ ቦችያ ኦንነ ባረና ጌሸናን አጎፐ፥ መꬍና ጎዳ ዱንካንያ እ ቱንሴ፤ ሄ ኡራይ እስራኤልያ አሳ ግዶፐ ቦሄቶ። ቱናተꬃፐ ጌይያ ሃꬃይ አ ቦላን ጫጫፈትቤና ድራዉ፥ እ ቱና፤ አ ቱናተꬃይ አ ቦላን ጋምኤ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“እት ኡራይ ዱንካንያ ግዶን ሀይቆፐ ደእያ ዎጋይ ሀዋ: ዱንካንያ ግዶ ገልያ ኦንነ፥ ቃይ ዱንካንያ ግዶን ደእያ ኡባይካ ላፑን ጋላሳ ቱና ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ሄዋዳንካ፥ ቁምኤተናን ዶያ ደእያ ሚሻ ኡባይ ቱና ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ቃይ ደምባን ማሻን ሀይቄዳ አሳ፥ ዎይ ጮ ሀይቄዳ አሃ፥ ዎይ አሳ መቀꬃ፥ ዎይ ዱፉዋ ቦችያ ኦንነ ላፑን ጋላሳ ቱና ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ቱናተꬃፐ ጌሻናዉ ጹጌዳ ኡሳት ብድንꬃፐ አማሬዳዋ አካደ፥ ኦቱዋን ዎꬃደ፥ ፑልቶ ሃꬃ አን ትጋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ጌሻ አሳይ ሂሶጵያ ቦንጭያ አኪደ፥ ሃꬃን ቱሽ ከሲደ፥ ዱንካንያ፥ ዱንካንያን ደእያ ሚሻ ኡባንነ ሄዋን ደእያ አሳ ኡባ ቦላን ጫጫፎ። ቃይ አሳ መቀꬃ፥ ዎይ ዱፉዋ፥ ዎይ ዎꬌዳ ኡራ፥ ዎይ ሀይቄዳ ኡራ ቦቼዳ አሳ ቦላ እ ጫጫፎ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ጌሻ አሳይ ሄዘንꬃነ ላፑንꬃ ጋላሳን ቱኔዳ ኡራ ቦላን ጫጫፎ። እ ላፑንꬃ ጋላሳን ሄ ኡራ ቱናተꬃፐ ጌሾ፤ ሄ ጌዬዳ ብታኒ ባረ ማዩዋ ሜጮ፤ ባረ ቦላካ ሃꬃን ሜጨቶ፤ ሄ ጋላሳ ኦማርስ እ ጌሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“ሽን ቱና ኡራይ ባረና ጌሸናዋ ግዶፐ፥ ሄ ኡራይ መꬍና ጎዳ ጌሻ ሳኣ ቱንሴዳ ድራዉ፥ እስራኤልያ አሳ ግዶፐ ቦሄቶ፤ ቱናተꬃፐ ጌይያ ሃꬃይ አ ቦላን ጫጫፈትቤና ድራዉ፥ እ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ሀዌ ህንተንቶ መꬍና ዎጋ ግዳናዋ። ቃይ ቱናተꬃፐ ጌይያ ሃꬃ ጫጫፍያ አሳይ ባረ ማዩዋ ሜጮ፤ ቱናተꬃፐ ጌይያ ሃꬃ ቦችያ ኦንነካ ኦማርስ ጋካናዉ ቱና ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ቱና ኡራይ ቦችያ አያይነ ቱኔ። ቃይ ሄዋ ቦችያ ኦንነ ኦማርሳ ጋካናዉ ቱና ግዴ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ኮይሮ አግናን እስራኤላቱ ኡባይ ጺና ግያ መላ ቢታ ጋኪደ፥ ቃዴሳ ግያ ሳን ዱንካኔድኖ። ሄዋን ሚርያማ ሀይቃደ ሞገታዱ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ሄዋን አሳዉ ሃꬃይ ꬋይና፥ አሳይ ሺቂደ፥ ሙሴ ቦላነ አሮና ቦላ ደንዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ኡንቱንቱ፥ “ኑ እሻቱ መꬍና ጎዳ ስንꬃን ሀይቄዳ ዎደ፥ ኑንካ ሀይቄዳዋ ግዴሮኮሻ! ");
INSERT INTO dwrENT_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ኑንነ ኑ መሂ ሀ መላ ቢታን ሀይቃናዳን፥ መꬍና ጎዳ አሳ ሀዋ ህንተ አያዉ አሄድቴ? ");
INSERT INTO dwrENT_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ሀ ዎልቃማ ሳኣ ኑና ግብጼፐ ፑደ አያዉ አሄድቴ? ሀዋን ካꬃ አይፊ፥ ዎይ ባላስያ፥ ዎይ ዎይንያ አይፊ፥ ዎይ ሮማኒ ባዋ፤ ቃይ ኡሽያ ሃꬃይካ ሀዋን ባዋ” ያጊደ ሙሴና ዋላቀቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ያትና ሙሴነ አሮን አሳ ማታፐ ጋከትያ ዱንካንያ ፐንገ ቢደ ጉፋኔድኖ፤ መꬍና ጎዳ ቦንቹ ኡንቱንቶ ቆንጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ነ ጋትማ አካ፤ ኔንነ ነ እሻ አሮን ሺቁዋ ሺሽተ፤ ኡንቱንቱ ስንꬃን ዛላይ ሃꬃ ጎጋና ማላ ኦዳ። ዛላፐ ሃꬃ ህንተ ከሲደ፥ ሽቁዋነ ኡንቱንቱ መህያ ኡሻና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","መꬍና ጎዳይ አዛዜዳዋዳን፥ ሙሴ መꬍና ጎዳ ስንꬃፐ ጋትማ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","እነ አሮን ሺቁዋ ዛላ ስንꬃን ሺሼድኖ፤ ሙሴ ኡንቱንታ፥ “ህንተኖ ማካላንቻቶ፥ ስስተ፤ ሀ ዛላፐ ሃꬃ ህንተንቶ ኑን ቱሙ ከሳኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ሙሴ ባረ ኩሽያ ꬎቁ ኦꬂደ፥ ባረ ጋትማን ላኡ ገደ ዛላ ሾጭና፥ ሃꬃይ ꬉቂደ ከስና ያአይነ ኡንቱንቱ መሂ ኡሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ሽን መꬍና ጎዳይ ሙሳነ አሮና፥ “እስራኤልያ አሳ ስንꬃን ህንተ ታ ጌሻተꬃ በሳናዉ አማነትቤና ድራዉ፥ ታን ኡንቱንቶ እምያ ቢታ ሀ አሳ ህንተ ገልስክታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","እስራኤልያ አሳይ መꬍና ጎዳና ዋላቀቶዌ እ ባረ ጌሻተꬃ ኡንቱንቱ ግዶን ቆንጭሴዳሳይ ሀ ማሪባ ሃꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ሙሴ ቃዴሳፐ ኤዶማ ቢታ ካትያኮ፥ ባረ ኪተትያዋንታ ሀዋዳን ያጊደ ኪቴዳ፤ “ነ ዳቦ ግድያ እስራኤልያ አሳይ ሀዋዳን ያጌ፤ ‘ኑና ጋኬዳ መቱዋ ኡባ ኔን ኤራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ኑ ማይዛ አዎቱ ዱገ ግብጼ ዎꬌድኖ፤ ያን ኑን ዳሮ ላይꬃ ደኤዶ። ግብጼቱ ኑናነ ኑ አዎቱዋ ኡቅኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ኑን መꬍና ጎዳዉ ዋስና፥ ኑ ዋሱዋ ስሲደ፥ ኪታንቻ ኪቲደ፥ ኑና ግብጼፐ ከሴዳ። ሀእ ኑን ነ ቢታ ጋጻን ደእያ ቃዴሳ ካታማን ደኤቶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ሀያና፥ ኑና ነ ቢታና አꬃርኪ! ኑን አይ ጋደ ግዶፐካ ዎይ ዎይንያ ቱራ ግዶፐካ ቦቾኮ! ቃይ ኑን አይ ሃꬃ ኦላፐነ ሃꬃ ኡሾኮ። ኑን ካትያ ኦግያ ኦይቂደ ባና፤ ኑን ነ ቢታና አꬋና ጋካናዉ፥ ሀድርሳ ዎይ ኡሸቻ ጎኮ’ ያጌ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ሽን ኤዶማ ካቲ፥ “ኑ ቢታና አꬅከ፤ ህንተ ሀዋና መንꬃና ካጄሎፐ፥ ኑን ደንዲደ ህንተና ማሻን ኦላና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","እስራኤላቱ አ፥ “ኑን ካትያ ኦግያና ባና፤ ኑን ዎይ ኑ መሂ ህንተ ሃꬃ ኡሾፐ፥ ኑን ሄዎ ጋትያ ጭጋና። ኑን ገድያን አꬃ ጻላላ ኮዬቶ፤ ሀራባ አያነ ኮዮኮ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ኤዶማ ካቲ ዛረꬂደ፥ “ህንተና አꬅከ” ያጌዳ። ሄዋፐ ጉይያን፥ ዳሮነ ዎልቃማ ኦላንቻቱዋ አኪደ፥ እስራኤልያ አሳና ኦላ ጋከታናዉ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ኤዶማቱ ባረንቱ ቢታና እስራኤልያ አሳይ አꬋናዉ ድጌዳ ድራዉ፥ እስራኤልያ አሳይ ስሚደ ሀራ ኦግያ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","እስራኤልያ አሳይ ኡባይ ቃዴሳፐ ደንዲደ፥ ሆራ ግያ ደርያ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ኤዶማ ዛዋ ማታን ደእያ ሆራ ደርያን፥ መꬍና ጎዳይ ሙሳነ አሮና፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“አሮን ሀይቂደ ባረ ማይዛን ጋከትያ ዎዲ ጋኬዳ። ማሪባ ሃꬃ ማታን ህንተ ላኡካ ታ አዛዙዋ ቦላ ማካሌዳ ድራዉ፥ እስራኤልያ አሳዉ ታን እምያ ቢታ እ ገለና። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","አሮናነ አ ናኣ ኤልኣዛራ አካደ፥ ሆራ ደርያ አሀ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","አሮና ማዩዋ ቃራደ፥ አ ናኣ ኤልኣዛራ ማይዛ። አሮን ባረ ማይዛን ጋከታና፤ እ ያን ሀይቃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","መꬍና ጎዳይ አዛዜዳዋዳን ሙሴ ኦꬄዳ፤ አሳይ ኡባይ ጼልሽን፥ ኡንቱንቱ ሆራ ደርያ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ሙሴ አሮና ማዩዋ ቃሪደ፥ አ ናኣ ኤልኣዛራ ማይዜዳ። አሮን ሄ ደርያ ሁጲያን ሀይቄዳ። ሄዋፐ ጉይያን፥ ሙሴነ ኤልኣዛር ደርያፐ ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","አሮን ሀይቄዳዋ አሳይ ኡባይ ኤሬዳ ዎደ፥ እስራኤልያ አሳይ ኡባይ አሮናዉ ሀታሙ ጋላሳ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ኔጌባ መላ ቢታ፥ ካናነ ጋድያን ደእያ አራዳ ካቲ እስራኤልያ አሳይ አታርማ አፍያ ኦግያ ባጋና ይያዋ ስሴዳ ዎደ፥ እ እስራኤላቱዋና ኦላ ጋከቲደ፥ ኡንቱንቱፐ አማሬዳዋንታ ኦሞዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ሄ ዎደ እስራኤልያ አሳይ፥ “ኔን ሀ አሳ ኑ ኩሽያን አꬃደ እሞፐ፥ ኑን ኡንቱንቱ ካታማቱዋ ኡባና ꬋይሳና” ያጊደ መꬍና ጎዳው ሺቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","መꬍና ጎዳይ እስራኤልያ ቃላ ስሲደ፥ ሄ ካናነቱዋ ኡንቱንቶ አꬅ እሜዳ፤ ኡንቱንቱ ሄ ካናነቱዋነ ኡንቱንቱ ካታማቱዋ ኡባና ꬋይሴድኖ። ሄዋ ድራዉ፥ ሄ ሳአይ ሆርማ ጌተት ሱንቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","እስራኤልያ አሳይ ሆራ ደርያፐ ደንዲደ፥ ኤዶማ ቢታ ዩሹዋ ባናዉ ዞኦ አባ አፍያ ኦግያና ቤድኖ፤ ሽን ኦግያ ቦላን አሳዉ ዳንዳያይ ዉሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","አሳይ፥ “ኑን መላ ቢታን ሀይቃናዉ ግብጼፐ ፑደ ኑና አያዉ አሄድቴ? ቁም ባዋ፤ ሃꬃይ ባዋ፤ ሀ ኢታ ቁማይ ኑና ሸነዬዳ” ያጊደ ጾሳ ቦላነ ሙሴ ቦላ ዙዙሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","መꬍና ጎዳይ አሳ ግዱዋን ማርዝያና ደእያ ሾሻቱዋ የዴዳ፤ ኡንቱንቱ ዱክና፥ ዳሮ እስራኤላቱ ሀይቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ኡንቱንቱ ሙሴኮ ዪደ አ፥ “ኑን መꬍና ጎዳ ቦላነ ነ ቦላ ዙዙሚደ፥ ናጋራ ኦꬄዶ። ኑፐ ሀ ሾሻ ሃሳና ማላ፥ ኔን መꬍና ጎዳ ዎሳ” ያጌድኖ። ሙሴ አሳ ድራዉ ዎሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ሄዋፐ ጉይያን መꬍና ጎዳይ ሙሳ፥ “ኔን ሾሻ መꬋደ፥ ኡንቱንቱ ስንꬃን ምꬃ ቦላን ካቃ፤ ዱከቴዳ ኦንነ አ ጼሎፐ ፓጻና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ሙሴ ናሃሰ ብራታፐ ሾሻ መꬊደ፥ ምꬃ ቦላን ካቄዳ። ሄዋፐ ጉይያን፥ ሾሻይ ዱኬዳ አሳይ ኡባይ ናሃስያ ሾሻ ጼሊደ ፓጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","እስራኤልያ አሳይ ደንዲደ፥ ኦቦታ ግያ ሳን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ኦቦታፐ ደንዲደ፥ ሞኣባፐ ስንꬃና ደእያ ባዙዋን፥ አዋይ ዶልያ ባጋና፥ ላለቴዳ እየ አባርማ ካታማን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ሄዋፐ ደንዲደ፥ ዘሬዳ ዛንጋራን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ሄዋፐ ደንዲደ፥ አሞረቱ ቢታ ጋጻ ጋካናዉ ብያ መላ ቢታ ግዶን አርኖና ሻፋፐ ሄፍንꬃን ዱንካኔድኖ። አርኖና ሻፋይ ሞኣባ ቢታፐነ አሞረቱ ጋድያፐ ግዱዋን ደእያ ዛዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ሄዋ ድራዉ፥ ጾሳ ኦላ ማጻፋን፥ “ሱፋ ሄራን ደእያ ዋሄባ ካታማነ አርኖና ሻፋ ዛንጋራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ኤራ ካታማ ጋካናዉነ ሞኣባ ዛዋ ጋካናዉ ደእያ ዛንጋራ ዱገꬃ” ያገት ጻፈቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ኡንቱንቱ ሄዋፐ ደንዲደ፥ ቤራ ግያሳ ቤድኖ፤ ሄዌ ጾሳይ ሙሳ፥ “አሳ ሺሻ፤ ታን ኡንቱንቶ ሃꬃ እማና” ያጊደ ኦዴዳ ሃꬃ ኦላ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ሄዋን እስራኤልያ አሳይ ሀ ማዝሙርያ የጼዳ። “ሃꬃ ኦላዉ፥ ፑልታ! ");
INSERT INTO dwrENT_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ካፓቱ ቦኬዳ ሃꬃ ኦላዉ፥ አሳ ካለꬅያዋንቱ ኦላዉ፥ ካተቱዋ ጻምኣንነ ኡንቱንቱ ካዛራን ቦኬዳ ሃꬃ ኦላዉ አነ የጼቶ” ያጌዳ። ኡንቱንቱ ሄ ባዙዋፐ ማታና ግያሳ ቤድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ማታናፐ ናህልኤላ፥ ናህልኤላፐ ባሞታ ግያሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ባሞታፐ ደንዲደ፥ ሞኣበን ደእያ ዛንጋራ ቤድኖ፤ ሀ ዛንጋራይ ፕስጋ ደርያፐ ጋርሳን ባዙዋ ማታን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ሄዋፐ ጉይያን፥ እስራኤልያ አሳይ አሞረ ቢታ ካትያ ስሆናኮ ኪተትያዋንታ ሀዋዳን ያጊደ ኪቴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ኑና ነ ቢታና አꬃርኪ! ኑን ነ ጋድያ ግዱዋ ዎይ ዎይንያ ቱራ ግዱዋ ገሎኮ፤ ቃይ ሃꬃ ኦላ ሀቃዋፐነ ኡሾኮ። ኑን ነ ቢታና አꬋና ጋካናዉ፥ ካትያ ኦግያና ባና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ሽን ስሆን ባረ ቢታና እስራኤልያ አሳ አናን ድጌዳ፤ እ ባረ ኦላንቻቱዋ ኡባ ሺሺደ፥ እስራኤልያ አሳ ኦላናዉ መላ ቢታ ቤዳ፤ ያሃጻ ግያሳ ብ ጋኪደ፥ እስራኤልያ አሳና ኦለቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ሽን እስራኤልያ አሳይ ኦላን አሞረቱዋፐ ዳሩዋ ዎꬊደ፥ ኡንቱንታ ቢታ አርኖና ሻፋፐ ዶሚደ፥ አሞናቱዋ ዛዋን ደእያ ያቦቃ ሻፋ ጋካናዉ ኦይቄዳ። አሞና አሳቱ ቢታ ዛዋይ ግምበት ኡቴዳ ድራዉ፥ ኡንቱንቱ ያ ገልበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ያትና እስራኤላቱ አሞረቱ ካታማቱዋ ኡባ ጾኒደ አኬድኖ። ቃይ ሀሰቦናነ አ ዩሹዋን ደእያ ቄር ካታማቱዋካ ኡባ ኦይቂደ፥ ያን ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ሀሰቦና ካታማይ አሞረቱ ካትያ ስሆና ካታማ። ስሆን ሞኣባ ቢታ ካትያ ካሰዋ ኦሊደ፥ አርኖና ሻፋ ጋካናዉ አ ቢታ ኡባ አፐ አኬዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ሄዋ ድራዉ፥ ሌምሱዋን ሀዋዳን ያጌድኖ፤ “ሀሰቦና ሃይተ፤ ሄ ካታማይ ዛረꬅ ኬጸቶ፤ ስሆና ዎልቃማ ካታማይ ዎꬍ ኤቂደ ኬጸቶ! ");
INSERT INTO dwrENT_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","አያዉ ጎፐ፥ ታማይ ሀሰቦናፐ፥ ላጩ ስሆና ካታማፐ ከሴዳ፤ ሞኣበን ደእያ ኤራነ አርኖና ሻፋ ሄራን ገዝያን ደእያ ካፓቱዋ ሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ሞኣባ፥ ነዉ አየ አና! ካሞሻዉ ጎይንያዋንቶ፥ ህንተ ꬋዬድታ። ህንተ ጾሳይ፥ ካሞሽ፥ ህንተ አቱማ ናናቱዋ ባቃታናዉ፥ ህንተ ማጫ ናናቱዋ ኦሞዶ፥ አሞረቱ ካትያ ስሆናዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ህንተ ዘረꬃቱ ሀሰቦናፐ ዶሚደ፥ ድቦና ጋካናዉ ኡባና ꬋዬድኖ። መዳባ ማታን ደእያ ኖፋሀ ጋካናዉ ዉርሲደ ባይዜድኖ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ሄዋዳን ሀኒደ፥ እስራኤላቱ አሞረቱ ጋድያን ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ቃይ ሙሴ ዎችያዋንታ ያእዜራ ግያ ካታማ የድና፥ እስራኤላቱ ሄ ካታማነ አ ሄራን ደእያ ቄር ካታማቱዋ ኦይቂደ፥ ሄዋን ደእያ አሞረቱዋ ከሲደ የደርሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ሄዋፐ ጉይያን፥ እስራኤላቱ ስሚደ፥ ባሳነ አፍያ ኦግያና ከሴድኖ። ባሳነ ካቲ ኦግ ባረ ኦላንቻቱዋ ኡባና ኤድራአ ግያ ካታማ ኡንቱንቱና ኦለታናዉ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ሽን መꬍና ጎዳይ ሙሳ፥ “አዉ ያዮፓ! አያዉ ጎፐ፥ ታን ካትያ ኦጋ አ አሳ ኡባናነ አ ቢታና ነ ኩሽያን አꬃደ እማድ። ሀሰቦናን ኡቲደ ሞዴዳ አሞረቱ ካትያ ስሆና ቦላ ኦꬄዳዋዳን፥ ኔን አ ቦላካ ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","እስራኤላቱ ኦጋ፥ አ አቱማ ናናቱዋነ አ አሳ ኡባ እቱዋነ ፓጻ አሸናን ዎꬌድኖ። ኡንቱንቱ አ ቢታ ላቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ሄዋፐ ጉይያን እስራኤልያ አሳይ ደንዲደ፥ እያርኮ ልክያን ዮርዳኖሳ ሄፍንꬃን ደእያ ሞኣባ ደምባን ዱንካኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","እስራኤልያ አሳይ አሞረቱ ቦላ ኦꬄዳዋ ኡባ ጽፖራ ናአይ ባላቅ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","እስራኤልያ አሳይ ሎይꬅ ዳሮ ግዴዳ ድራዉ፥ ሞኣባቱ ሎይꬅ ዳጋሚደ ያዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ሞኣባቱ ምድያማ ጭማቱዋ፥ “ቦራይ ማታ ም ꬋይስያዋዳን ሀ ዉደ አሳይ ኑ ዩሹዋን ደእያ ኡባ ም ꬋይሳና” ያጌድኖ። ሄ ዎደ ሞኣባ ካቲ፥ ጽፖራ ናአይ ባላቅ ");
INSERT INTO dwrENT_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","አማዋ ጋድያን ኤፍራጺሳ ሻፋ ማታን ፓቶራ ካታማን ደእያ ብኦራ ናኣ ባላማኮ አሳ ኪቴዳ። ባላቅ፥ “በአ፥ ግብጼፐ ዳሮ አሳይ ከሴዳ፤ ኡንቱንቱ ቢታ ኡባ ማዪደ፥ ታፐ ያ ባጋን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ኡንቱንቱ ታዉ ሎይꬅ ዎልቃምያ ድራዉ፥ ሀያና ሀእ ያደ፥ ኡንቱንታ ታዉ ሸቃርኪ! ኦን ኤሪ፥ ታን ኡንቱንታ ጾናናዉነ ጋድያፐ ከሳናዉ ዳንዳያነንቶነ። አያዉ ጎፐ፥ ኔን አንጄዳዌ አንጀቴዳዋነ ኔን ሸቄዳዌ ሸቀቴዳዋ ግድያዋ ታን ኤራይ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ሞኣባ ጭማቱነ ምድያማ ጭማቱ ሸቂስያ ጋትያ አኪደ፥ ባላማኮ ቤድኖ። ባላቅ ጌዳዋ አዉ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ባላም ኡንቱንታ፥ “ሀቼ ቃማ ሀዋን አቅተ፤ መꬍና ጎዳይ ታዉ ኦድያዋ ታን ህንተንቶ ኦዳና” ያጌዳ። ሞኣባ ካፓቱ ባላማዋን ታኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ጾሳይ ባላማኮ ዪደ፥ “ሀዋንቱ ኔናና ደእያ አሳቱ ኦኔ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ባላም ጾሳ፥ “ሞኣባ ካቲ፥ ጽፖራ ናአይ ባላቅ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘ግብጼፐ ዳሮ አሳይ ከሴዳ፤ ኡንቱንቱ ቢታ ኡባ ማዬድኖ። ሀእ ኔን ያደ፥ ኡንቱንታ ታዉ ሸቃርኪ! ኦን ኤሪ፥ ታን ኡንቱንታ ጾናናዉነ ጋድያፐ ከሳናዉ ዳንዳያነንቶነ’ ያጊደ ኡንቱንታ ታኮ ኪቴዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ጾሳይ ባላማ፥ “ኔን ኡንቱንቱና ቦፓ። እስራኤላቱ አንጀቴዳዋንታ ግድያ ድራዉ፥ ኔን ሄ አሳ ሸቆፓ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ዎንተꬃ ጋላስ ዎንታ ባላም ደንዲደ፥ ባላቃ ካፓቱዋ፥ “ታን ህንተናና ቤናዳን መꬍና ጎዳይ ድጌዳ ድራዉ፥ ህንተ ቢታ ስምተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ሞኣባ ካፓቱ ያፐ ደንዲደ፥ ባላቃኮ ስሚደ አ፥ “ባላም ኑናና ዬናን እጼዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ዛሪደካ ባላቅ ካሰዋንቱፐ አꬍ ቦንቼቴዳነ ፓይዱዋንካ ጮራቴዳ ሀራ ካፓቱዋ አኮ ኪቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ኡንቱንቱ ባላማኮ ዪደ፥ “ጽፖራ ናአይ ባላቅ ኔና፥ ‘ኔን ታኮ ያናዋ ኔና አያይነ ተኦፖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","አያዉ ጎፐ፥ ታን ነዉ ዳሮ ዎይቱዋ እማና፤ ኔን ግያዋ ኡባ አያነ ታን ኦꬃና። ያደ ሀ አሳ ታዉ ሸቃርኪ’ ” ያጊደ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ሽን ባላም ኡንቱንቶ፥ “ባላቅ ሀራይ አቶ ብራይነ ዎርቃይ ኩሜዳ ባረ ካትያ ጎልያ ታዉ እሜዳዋ ግድንቶነ፥ መꬍና ጎዳ ታ ጾሳ አዛዙዋፐ አꬋደ፥ ታን አያነ ፓጭሳናዉ ዎይ ጉጃናዉ ዳንዳይከ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","መꬍና ጎዳይ ታዉ ኦድያ ሀራባይ ደኦፐ ታን ኤራናዳን፥ ህንተካ ሀች ቃማ ሀዋን አቅተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ሄ ጋላሳ ቃማ ጾሳይ ባላማኮ ዪደ፥ “ሀ አሳይ ኔና ጼሳናዉ ዬዳ ድራዉ፥ ኔን ኡንቱንቱና ባ። ሽን ታን ነዉ ኦድያዋ ጻላላ ኦꬃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ዎንተꬃ ጋላስ ባላም ባረ ሀራቶ ኮሪደ፥ ሞኣባ ካፓቱዋና ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ሽን እ ብያ ዎደ ጾሳ ሀንቁ ኤጽ ከሴዳ፤ ያትና መꬍና ጎዳ ኪታንቻይ አ ተአናዉ ኦግያን ኤቄዳ። ሄ ዎደ ባላም ባረ ሀራቶ ቶጎዋን፥ አ ላኡ ቆማቱ አናና ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","መꬍና ጎዳ ኪታንቻይ ማሻ ዛረꬅ ኦይቂደ፥ ኦግያን ኤቄዳዋ ሀራታ በአኔ፥ ኦግያ አጋደ፥ ጎሻ ግዶ ገላዱ። ባላም ኦግያ ዛራናዉ ሀራቶ ሾጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ያትና መꬍና ጎዳ ኪታንቻይ ላኡ ዎይንያ ቱራ ሳአቱዋፐ ግዱዋን፥ ያ ባጋናነ ሀ ባጋና ግምቢያን ድረት ኡቴዳ ኡንኦ ኦግያን ኤቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ሀራታ መꬍና ጎዳ ኪታንቻ በኤዳ ዎደ፥ ግምቢያ ድርሳኮ ሺቃደ፥ ባላማ ገድያ ግምቢያ ድርሳና ዳራጻዱ፤ እ ሀራቶ ላኤንꬁዋካ ሾጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ሄዋፐ ጉይያን፥ መꬍና ጎዳ ኪታንቻይ ስንꬃዉኮ አꬊደ፥ ሀድርሳ ባጋናካ ኡሸቻ ባጋና አꬍያ ሳአይ ባይና ኡንኦ ሳኣን ኤቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ሀራታ መꬍና ጎዳ ኪታንቻ በኣደ፥ ባላም ቶጎዋን ግሳዱ። ባላም ሎይꬅ ሀንቀቲደ፥ ባረ ጻምአን ሀራቶ ቡኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ሀራት ዶና ዶይና፥ ሀራታ ባላማ፥ “ታን ነዉ አይ ኦꬅኔ ኔን ታና ሀ ሄዙ ገደ ቡኬዳዌ?” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ባላም ሀራቶ፥ “ኔን ታና ኤየꬄዳ ድራሳ። ታ ኩሽያን ማሻይ ደኤዳዋ ግድንቶነ፥ ታን ኔና ሀእ ዎꬋና ሽን!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ሀራታ ባላማ፥ “ታን ነ ደኦ ኡባን ሀች ጋካናዉ ቶግያ ነ ሀራቶ ግድክታ? ታን ነዉ ሀዋዳን ሀና ኤራይታ?” ያጋዱ። ባላም፥ “ሀና ኤራካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ባላማ አይፍያ ዶይና፥ መꬍና ጎዳ ኪታንቻይ ሾኩዋፐ ሾዴዳ ማሻ ኦይቂደ፥ ኦግያን ኤቄዳዋ በኤዳ። እ ልጭ ጊደ፥ ሶምኡዋ ሳኣ ጋꬂደ ጉፋኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","መꬍና ጎዳ ኪታንቻይ አ፥ “ነ ሀራቶ ሀ ሄዙ ገደ አያዉ ቡካዲ? ነ ኦጊ ታ ስንꬃን ጌላ ግድያ ድራዉ፥ ታን ኔና ተአናዉ ሀዋ ያድ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ሀራታ ታና በኣደ፥ ታ ስንꬃፐ ሄዙ ገደ ዎራ ስማዱ። ሀራታ ዎራ ስማቤናዋ ግድንቶነ፥ ታን ኔና ሀኖደ ቱሙ ዎꬋ ድጋደ፥ ሀራቶ አሻና ሽን” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ባላም መꬍና ጎዳ ኪታንቻ ዛሪደ፥ “ታን ናጋራ ኦꬃድ። ኔን ታና ተአናዉ ኦግያ ቦላን ኤቄዳዋ ታን ኤራበይከ። ኔን ዶሳቤናባ ግዶፐ፥ ታን ሀእ ጉየ ስማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","መꬍና ጎዳ ኪታንቻይ ባላማ፥ “ኔን ሀ አሳቱዋና ባ፤ ሽን ታን ነዉ ኦድያዋ ጻላላ ሃሳያ” ያጌዳ። ባላም ባላቃ ቢታ ካፓቱዋና ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ባላም ይያዋ ባላቅ ስሴዳ ዎደ፥ አርኖና ሻፋ ዛዋን ባረ ቢታ ጋጻን ደእያ ሞኣባቱዋ ካታማን አናና ጋከታናዉ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ባላቅ ባላማ፥ “ኔን ኤለካ ያናዳን ታን ኪታበይክታ? ኔን አያዉ ታኮ ኤለካ ያበይኪ? ታን ነዉ ዎይታናዉ ቱሙ ዳንዳይክታ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ባላም ባላቃ፥ “በአ፥ ሀእ ታን ኔኮ ያድ፤ ሽን ታን አያነ ጋናዉ ቱሙ ዳንዳይከ። ጾሳይ ታና ሃሳይስያዋ ጻላላ ታን ሃሳያና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ሄዋፐ ጉይያን፥ ባላም ባላቃና ቅርያት-ሁጾታ ግያ ካታማ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ባላቅ ሚዛነ ዶርሳ ያርሺደ፥ አሹዋፐ አማሬዳዋ ባላማዉነ አናና ደእያ ካፓቶ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ዎንተꬃ ጋላስ ዎንታ ባላቅ ባላማ አኪደ፥ ባሞት-ባኣል ግያሳ ፑደ ከሴዳ፤ ሄዋን ኤቂደ፥ ባላም እስራኤልያ አሳፐ ባጋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ባላም ባላቃ፥ “ሀዋን ኔን ታዉ ላፑን ያርሽያ ሳኣ ግምባ፤ ቃይ ላፑን ኮሩማ ቦራነ ላፑን ዶርሳ ኦርገቱዋ ኔን ታዉ ጊግሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ባላም ጌዳዋዳን ባላቅ ኦꬄዳ፤ ኡንቱንቱ ላኡካ እት እት ያርሽያ ሳኣን እት ኮሩማ ቦራነ እት ዶርሳ ኦርግያ ያርሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ሄዋፐ ጉይያን፥ ባላም ባላቃ፥ “ኔን ነ ጹግያ ያርሹዋ ማታን ሀዋን ኤቃሻ፤ ታን ገደኮ ባይ። መꬍና ጎዳይ ታናና ጋከታናዉ ሀቀት ዬናን አገና። እ ታዉ ቆንጭስያዋ አያነ ታን ነዉ ኦዳና” ያጌዳ። ꬎቃ ዞዘትያ መላ ሳኣ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ሄዋን ጾሳይ ባላማና ጋከትና ባላም፥ “ታን ላፑን ያርሽያ ሳኣ ጊግሳድ፤ እት እት ያርሽያ ሳኣን እት ኮሩማ ቦራነ እት ዶርሳ ኦርግያ ያርሻድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ባላም ጋናባ መꬍና ጎዳይ አዉ ኦዲደ፥ “ኔን ባላቃኮ ስማደ፥ አዉ ሀ ትምቢትያ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","እ ባላቃኮ ስምያ ዎደ፥ ባላቅ ሞኣባ ካፓቱ ኡባና ባረ ጹግያ ያርሹዋ ማታን ኤቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ሄዋፐ ጉይያን፥ ባላም ባረ ትምቢትያ ሀዋዳን ያጊደ ኦዴዳ፤ “ሞኣባ ካቲ አዋይ ዶልያ ባጋ ደረቱዋፐ፥ ሶርያ ጋድያፐ ታና ሀዋዳን ያጊደ አሄዳ፤ ‘ሃያ፤ ያቆባ ታዉ ሸቃ! እስራኤልያ አሳ፥ “ዉርተ!” ያጋ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ጾሳይ ሸቂቤናዋንታ ታን ዋታ ሸቆ? መꬍና ጎዳይ፥ ‘ዉርተ!’ ያግቤናዋንታ፥ ታን ዋታደ፥ ‘ዉርተ!’ ያጎ? ");
INSERT INTO dwrENT_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ታን ꬎቃ ዛላ ሁጲያን ኤቃደ ኡንቱንታ ጼላይ፤ ዞዝያን ኤቃደ ታን ኡንቱንታ በአይ። ኡንቱንቱ ባረካ ደእያ አሳ፤ ኡንቱንቱ ባረና ካዉተꬃቱዋፐ እቱዋዳን ፓይድክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ባናዳን ጮራቴዳ ያቆባ ዘረꬃ ኦን ፓይዳናዉ ዳንዳዪ? ሀራይ አቶ እስራኤልያ አሳዉ ኦይደንꬆ ኩሽያ ኦን ፓይዳናዉ ዳንዳዪ? ታ ሀይቁ ጽሎቱዋ ሀይቁዋ ማላ ግዶ፤ ታ ደኡዋ ዉርሰꬃይካ ኡንቱንቱዋዳን ሀኖ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ባላቅ ባላማ፥ “ኔን ታ ቦላ ኦꬅያባይ አዬ? ታን ኔና ታ ሞርከቱዋ ሸቃናዳን አሃድ፤ ሽን ኔን ኡንቱንታ አንጃዳፐ አትና፥ ሀራባ አይነ ኦꬃባካ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ባላም ዛሪደ፥ “ታን መꬍና ጎዳይ ታና ሃሳይስያዋፐ ሀራ ሃሳዮየ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ሄዋፐ ጉይያን፥ ባላቅ አ፥ “ኡንቱንቱ ኔን በአናዉ ዳንዳይያ ሀራሳ ታናና ደንዳ። ኔን ኡንቱንቱፐ አማሬዳዋ በአናፐ አትና፥ ኡንቱንታ ኡባ በአካ። ኔን ሄዋን ታዉ ኡንቱንታ ሸቃርኪ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ፕስጋ ግያ ደርያ ሁጲያን ደእያ ጾፊማ ደምባ አኪደ አፌዳ። ሄዋን ላፑን ያርሽያ ሳኣ ግምቤዳ፤ እት እት ያርሽያ ሳኣን እት ኮሩማ ቦራነ እት ዶርሳ ኦርግያ ያርሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ባላም ባላቃ፥ “ታን ህንና ጾሳና ጋከትያ ዎደ፥ ኔን ሀዋን ነ ጹግያ ያርሹዋ ማታን ኤቃሻ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","መꬍና ጎዳይ ባላማና ጋከቲደ ኪቲደ፥ “ኔን ባላቃኮ ስማደ፥ አዉ ሀ ትምቢትያ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","እ አኮ ስሚደ፥ ባረ ጹግያ ያርሹዋ ማታን ሞኣባ ቢታ ካፓቱና ኤቄዳዋ ደሜዳ። ባላቅ አ፥ “መꬍና ጎዳይ ኦድያባይ አዬ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ባላም ባረ ትምቢትያ ሀዋዳን ያጊደ ኦዴዳ፤ “ጽፖራ ናኣ ባላቃ ደንዳ ስሳ፤ ታን ኦድያዋ ስሳ! ");
INSERT INTO dwrENT_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ጾሳይ ዎርዶታናዉ አሳ ግደና፤ ባረ ቆፋ ላማናዉ እ አሳ ናኣ ግደና። እ ኦዲደ፥ ባረ ኦዴዳዋ ኦኔ? ዎይ እ ባረ ጌዳዋ ፖለኔ? ");
INSERT INTO dwrENT_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ታን አንጃናዉ አዛዙዋ አካድ። እ አንጅ ክቼዳ፤ ታን ሄዋ ላማናዉ ዳንዳይከ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ያቆባ ዛርያዉ ኢታባይ ያናባይ፥ እስራኤልያ አሳዉ መቱ ጋካናባይ ታዉ ቤትቤና። መꬍና ጎዳይ ኡንቱንቱ ጾሳይ ኡንቱንቱና ደኤ፤ እ ኡንቱንቶ ካትያ ግድያዋ አዋዪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ጾሳይ ኡንቱንታ ግብጼፐ ከሴዳ፤ እ ምኖ መንꬃዳን ኡንቱንቶ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ያቆባ ቦላ ጋካና ብታይ ባዋ፤ እስራኤልያ አሳ ቆሀና ሙሩኑካ ባዋ። አሳይ ሀእ፥ ‘ያቆባዉነ እስራኤላዉ ጾሳይ ኦꬄዳዋ በእተ’ ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ሀ አሳይ ማጫ ጋማትዳን ደንዴዳ። ባረ ኦይቄዳዋ ማና ጋካናዉነ፥ ባረ ዎꬌዳዋ ሱꬃ ኡሻና ጋካናዉ፥ ሸምፐና ጋሙዋዳን ኡንቱንቱ ኤቂ ደንድኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ሄዋፐ ጉይያን፥ ባላቅ ባላማ፥ “ኔን ኡንቱንታ ሙለካ ሸቆፓነ ሙለካ አንጆፓ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ባላም ዛሪደ፥ “መꬍና ጎዳይ ግያዋ ኡባ ኦꬃና ጋደ ታን ነዉ ኦዳበይክታ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ሄዋፐ ጉይያን፥ ባላቅ ባላማ፥ “ሃያ፤ ታን ኔና ሀራሳ አፋና። ኦን ኤሪ፥ ኔና ያ አፍና ጾሳይ ናሸቲደ፥ ኔና ኡንቱንታ ታዉ ሸቅሳነንቶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ባላቅ ባላማ መላ ቢታ ቦላና ዱገ ጼልያ ፓኦራ ደርያ ሁጲያ አፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ባላም፥ “ኔን ሀዋን ታዉ ላፑን ያርሽያ ሳኣ ግምባ፤ ቃይ ላፑን ኮሩማ ቦራቱዋነ ላፑን ዶርሳ ኦርገቱዋ ታዉ ጊግሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ባላም ጌዳዋዳን ባላቅ ኦꬄዳ፤ እት እት ያርሽያ ሳኣን እት ኮሩማ ቦራነ እት ዶርሳ ኦርግያ ያርሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","እስራኤልያ አንጅያዌ መꬍና ጎዳ ናሸቼዳዋ ባላም በኤዳ ዎደ፥ ካሰ እ ኦꬄዳዋዳን ሙሩናናዉ ኮይቤና፤ ሽን ባረ ሶምኡዋ መላ ቢታኮ ዛሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ያቲዴ ꬎቁ ጊ ጼሊደ፥ እስራኤልያ አሳይ ባረ ዛርያን ዛርያን ዱንካን ኡቴዳዋ በኤዳ፤ ጾሳ አያናይ አ ቦላ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","እ ባረ ትምቢትያ ሀዋዳን ያጊደ ኦዴዳ፤ “ብኦራ ናኣ ባላማ ትምቢቲ፥ አ አይፊ ትሽ ኦꬅ ጼልያዋ ትምቢቲ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ጾሳይ ግያዋ ስስያዋ ትምቢቲ፥ ልጭ ጊደ ጉፋንና፥ አ አይፊ ዶየቴዳዋነ ኡባ ዳንዳይያ ጾሳ ሳፃ በእያዋ ትምቢቲ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ያቆባ ዛረቶ፥ ህንተ ዱንካነቱ፥ እስራኤልያ አሳዉ፥ ህንተ ደእያ ሳአቱካ፥ ዎት ሎኤ! ");
INSERT INTO dwrENT_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ኡንቱንቱ ምጨቴዳ ዎምባዳን፥ ሻፋ ዶናን ደእያ አታክልትያ ሳኣዳን፥ መꬍና ጎዳይ ቶኬዳ ጎዳረ ኡꬃዳንነ ሃꬃ ዶናን ደእያ ዝጋዳን ሀኒኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ኡንቱንቶ ዳሮ ሃꬃይ ፑልታና፤ ኡንቱንቱ ዛረቶ ግድያ ሃꬃይ ደአና። ኡንቱንቱ ካቲ ካትያ አጋጋፐ ግታታና፤ ኡንቱንቱ ካዉተꬃይካ ቦንቼታና። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ጾሳይ ኡንቱንታ ግብጼፐ ከሴዳ፤ እ ምኖ መንꬃዳን ኡንቱንቶ ደኤ። ኡንቱንቱ ሞርከ ካዉተꬃ ምታና፤ ኡንቱንቱ መቀꬃካ ሊቅሳና፤ ኡንቱንቱ ባረንቱ ዎንዳፍያ ዙቢያን ኡንቱንታ ጫዳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","እስራኤልያ አሳይ ጋሙዋዳን ግሴ። ማጫ ጋማትዳን ኡንቱንታ ደንꬃናዉ ኦን ጻላኔ? ህንተና አንጅያ ኡባይ አንጀቴዳዋ ግዳናዋ፤ ህንተና ሸቂያ ኡባይ ሸቀቴዳዋ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ሄዋፐ ጉይያን፥ ባላቅ ባላማ ቦላ ሀንቁዋ ኤጽ ከሴዳ። ባላቅ ባረ ኩሽያ ዱኪደ ባላማ፥ “ታ ሞርከቱዋ ቃንጋናዳን ታን ኔና ጼሳድ፤ ሽን ኔን ሀ ሄዙ ገደካ ኡንቱንታ አንጃዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ስም ሀእ ኔን ነ ጎለ ባቃታ፤ ‘ታን ነዉ ዳሮባ ዎይታና’ ጋድ፤ ሽን ኔን ዎይቱዋ አከናዳን መꬍና ጎዳይ ኔና ድጌዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ባላም ባላቃ ዛሪደ፥ “ኔን ታኮ ኪቴዳዋንቱነ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ባላቅ ሀራይ አቶ ባረ ብራይነ ዎርቃይ ኩሜዳ ባረ ካትያ ጎልያ ታዉ እሜዳዋ ግድንቶነ፥ መꬍና ጎዳይ ኦዴዳዋ አꬋደ፥ ሎኡዋ ዎይ ኢታ ታ ሸንያን ኦꬃናዉ ዳንዳይከ። ታን መꬍና ጎዳይ ግያዋ ጻላላ ጋና’ ያጋደ ነዉ ኦዳበይክታየ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ያጊደ፥ “ታን ሀእ ታ አሳኮ ባይ፤ ሽን ኔን ሃያ፤ ሀ አሳይ ዉርሰꬃ ዎድያን ነ አሳ ኦꬃናዋ ታን ነዉ ኦዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","እ ባረ ትምቢትያ ሀዋዳን ያጊደ ኦዴዳ፤ “ብኦራ ናኣ ባላማ ትምቢቲ፥ አ አይፊ ትሽ ኦꬂደ ጼልያዋ ትምቢቲ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ጾሳይ ግያዋ ስስያዋነ፥ ኡባፐ ꬎቂያ ጾሳፐ ግዴዳ ኤራተꬃይ ደእያዋ ትምቢቲ፥ ልጵ ጊደ ጉፋንና፥ አ አይፊ ዶየቴዳዋነ ኡባ ዳንዳይያ ጾሳ ሳፃ በእያዋ ትምቢቲ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ታን አ በአይ፤ ሽን ዎዲ ሀአ ግደና፤ ታን አ ጼላይ፤ ሽን ማታን ግደና። ያቆባ ዛርያፐ ጾልንቲ ከሳና። እስራኤልያፐ ካተቱዋ ጻምአይ ከሳና። ሞኣባ አሳ ሶምኡዋ እ ጋጭ ቆላና። ሴተ አሳ ኡባ ሁጲያ እ ክንቻና። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ኤዶም ጾነታና፤ አ ሞርኪ ሰኢርካ ጾነታና፤ ሽን እስራኤሊ ምን ምኒደ ባና። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ያቆባፐ ሞድያዌ ከሳና፤ ኡንቱንቱ ካታማን ፓጻ አቴዳዋንታ ꬋይሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ሄዋፐ ጉይያን፥ ባላም አማሌቃ አሳቱዋ በኢደ፥ ባረ ትምቢትያ ሀዋዳን ያጊደ ኦዴዳ፤ “ካዉተꬃቱዋ ግዶን አማሌቅ ኮይሮ፤ ሽን ኡንቱንቱ ዉርሰꬃይ ꬋዮ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ቃይ ባላም ቄና አሳቱዋ በኢደ፥ ባረ ትምቢትያ ሀዋዳን ያጊደ ኦዴዳ፤ “ህንተ ደእያ ሳአይ ሳሮ ሳ ግዴ፤ ህንተ ጎሊ ዛላ ቦላን ኬጸቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ሽን አሶረቱ ህንተና ኦሞድያ ዎደ፥ ህንተ ቄና አሳቱ ꬋያና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ሄዋፐ ጉይያን፥ ባላም ባረ ትምቢትያ ሀዋዳን ያጊደ ኦዴዳ፤ “አየ አና! ጾሳይ ሀዋ ኦꬅያ ዎደ፥ ኦን ደአና ዳንዳዪ? ");
INSERT INTO dwrENT_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ማርካባቱ ክቲማ ሀሩሩዋፐ ያና፤ ኡንቱንቱ አሶረቱዋነ ኤቤራቱዋ ኡቁናና፤ ሽን ቃይ ኡንቱንቱካ ꬋያና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ሄዋፐ ጉይያን፥ ባላም ደንዲደ፥ ባረ ጎለ ስሜዳ፤ ባላቅካ ባረ ኦግያ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","እስራኤላቱ ሺጽማ ግያ ሳን ዱንካኔዳ ዎደ፥ አሳይ ሞኣባ ቢታ ማቼቱዋና ሻርሙጹዋ ዶሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ሄ ማጫ አሳቱ ባረንቱ ጾሳቱዋ ያርሹዋ ማናዉ ኡንቱንታ ሾቤድኖ፤ ኡንቱንቱ ሚደ፥ ኡንቱንቱ ጾሳቶ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","እስራኤላቱ ፓኦራ ባኣላ ግያ ኤቃ ካሌዳ ድራዉ፥ መꬍና ጎዳ ሀንቁ ኡንቱንቱ ቦላን ኤጽ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ያትና መꬍና ጎዳይ ሙሳ፥ “መꬍና ጎዳ ሀንቁ እስራኤልያፐ ዎራ ስማና ማላ፥ ሀ አሳ ካለꬅያዋንታ ኡባ አፋደ፥ ሴታ ጋላስ መꬍና ጎዳ ስንꬃን ካቃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ሙሴ እስራኤልያ ዳናቱዋ፥ “ፓኦራ ባኣላ ግያ ኤቃዉ ጎይኔዳ ህንተ አሳ ኡባ ህንተ ሁጲያን ሁጲያን ዎꬍተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ሙሴነ እስራኤልያ ማባራይ ኡባይ ጋከትያ ዱንካንያ ፐንግያን ዬክሽን፥ እስራኤላቱዋፐ እቱ ምድያማ ቢታ ምሽራቶ ኡንቱንቱ ስንꬃና አꬂደ፥ ባረ ጎልያ አሳኮ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ቄስያ አሮና ናኣ ኤልኣዛራ ናአይ ፒንሃስ ሄዋ በኤዳ ዎደ፥ ማባራ ግዶፐ ደንዲደ፥ ቶራ ባረ ኩሽያን ኦይቂደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ሄ እስራኤልያ ብታንያ ካሊደ፥ ዱንካንያ ግዶ ገሌዳ። እስራኤልያ ብታንያነ ምሽራቶነ ላኡዋካ ቶራን ጫዲደ፥ ካንꬅ ከሴዳ። ሄዋዳን ሀንና፥ ቦሻይ እስራኤላቱዋፐ ቃረቴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ሽን ሄ ቦሻን ሀይቄዳ አሳይ ላታማነ ኦይዱ ሻአ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ቄስያ አሮና ናኣ ኤልኣዛራ ናአይ ፒንሃስ እስራኤልያ አሳ ግዶን ታን ታ ቦንቾ ምሸትያዋዳን ምሸቴዳ ድራዉ፥ ኡንቱንቱ ቦላ ታን ሀንቀቴዳ ሀንቁ ዶቼዳ፤ ታንካ ኡንቱንታ ታ ሀንቁዋን ꬋይሳበይከ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ሄዋ ድራዉ፥ ታን ታ ሳሮተꬃ ጫቁዋ አናና ጫቀትያዋ ፒንሃሳዉ ኔን ኦዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","እ ባረ ጾሳ ቦንቾ ምሸቴዳ ግሻዉነ እስራኤልያ አሳዉ አቶ ጊሴዳ ድራዉ፥ እነ አ ዘረꬃቱ መꬍናዉ ቄሰ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ምድያማ ቢታ ምሽራትና ዎꬌዳ እስራኤልያ ብታንያ ሱንꬃይ ሳሉ ናኣ ዝምራ፤ ሳሉ ስሞና ዛራቱዋን እት ያራ ካፑዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ሀይቄዳ ምድያማ ቢታ ምሽራት ሱንꬃይ ኮዝቦ፤ እ አዉ ጹር ምድያማቱ ያራ ካፑዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ምድያማ ቢታ አሳቱዋ ሞርክተ፤ ኡንቱንታ ዎꬍተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","አያዉ ጎፐ፥ ኡንቱንቱ ህንተና ፓኦራን ጭሚደ፥ ህንተዉ ሞርከ ግዴድኖ፤ ቃይ ቦሻ ጋላስ ፓኦራን ዎꬌዳ ምሽራት፥ ምድያማቱ ያራ ካፑዋ ናት ኮዝብ ጋሱዋን ኡንቱንቱ ህንተና ሞርኬድኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ቦሻፐ ጉይያን፥ መꬍና ጎዳይ ሙሳነ ቄስያ አሮና ናኣ ኤልኣዛራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“የለቶደፐ ላታሙ ላይꬃነ ሄዋፐ ቦላና ደእያ እስራኤላቱዋ፥ ኦላዉ ባናዉ ዳንዳይያዋንታ ኡባቱዋ፥ ኡንቱንቱ ጎልያን ጎልያን ፓይድተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ሙሴነ ቄሲ ኤልኣዛር ዮርዳኖሳ ሻፋፐ ሄፍንꬃ ባጋና፥ እያርኮ ማታን፥ ሞኣባ ደምባን ኡንቱንቱና ሃሳዪደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ የለቶደፐ ላታሙ ላይꬃነ ሄዋፐ ቦላና ደእያ አሳ ፓይድተ” ያጌድኖ። ግብጼፐ ከሴዳ እስራኤላቱ ሀዋንታ፦ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","እስራኤልያ ባይራ ናኣ ሮቤላ ዛራቱ: ሀኖካ ያራቱዋ፥ ፓሉ ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ሄጽሮና ያራቱዋነ ካርማ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ሀዋንቱ ሮቤላ ዛራቱዋ፤ ኡንቱንቱ ኡባና 43,730። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ፓሉ ናአይ ኤልኣባ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ኤልኣባ አቱማ ናናይ ነሙኤላ፥ ዳታናነ አቢራማ፤ ሀ ዳታንነ አቢራም ማባራይ ዶሬዳዋንታ። ኡንቱንቱ ቆራሀነ አ ካልያዋንቱና ዙፐቲደ፥ ሙሴ ቦላ፥ አሮና ቦላነ መꬍና ጎዳ ቦላ ማካሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ቢታይ ዶየቲደ፥ ኡንቱንታ ቆራሃና እትፐ ምቴዳ፤ ኡንቱንታ ካልያ ላኡ ጼታነ እሻታሙ አሳ ታማይ ሚና ሀይቄድኖ። ያትና ኡንቱንቱ አሳይ በኢደ ዱጽያ ማላታ ግዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ሽን ቆራሀ አቱማ ናናይ ሄ ጋላስ ሀይቂበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ስሞና ዛራቱ ባረንቱ ያራን ያራን: ነሙኤላ ያራቱዋ፥ ያሚና ያራቱዋ፥ ያኪና ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ዛራሀ ያራቱዋነ ሻኡላ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ሀዋንቱ ስሞና ዛራቱዋ፤ ኡንቱንቱ ኡባና 22,200። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ጋዳ ዛራቱ ባረንቱ ያራን ያራን: ጻፎና ያራቱዋ፥ ሀጋ ያራቱዋ፥ ሹና ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ኦዝና ያራቱዋ፥ ኤራ ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","አሮዳ ያራቱዋነ አርኤላ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ሀዋንቱ ጋዳ ዛራቱዋ፤ ኡንቱንቱ ኡባና 40,500። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ይሁዳ አቱማ ናናይ ኤራነ ኦናና፤ ሽን ኡንቱንቱ ካናነ ጋድያን ሀይቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ይሁዳ ዛራቱ ባረንቱ ያራን ያራን: ሼላ ያራቱዋ፥ ፓሬሳ ያራቱዋነ ዛራሀ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ፓሬሳ ዛራቱ ሄጽሮና ያራቱዋነ ሀሙላ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ሀዋንቱ ይሁዳ ዛራቱዋ፤ ኡንቱንቱ ኡባና 76,500። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ይሳኮራ ዛራቱ ባረንቱ ያራን ያራን: ቶላአ ያራቱዋ፥ ፑዋ ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ያሹባ ያራቱዋነ ሽምሮና ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ሀዋንቱ ይሳኮራ ዛራቱዋ፤ ኡንቱንቱ ኡባና 64,300። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ዛብሎና ዛራቱ ባረንቱ ያራን ያራን: ሰሬዳ ያራቱዋ፥ ኤሎና ያራቱዋነ ያህላኤላ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ሀዋንቱ ዛብሎና ዛራቱዋ፤ ኡንቱንቱ ኡባና 60,500። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ምናሰነ ኤፍሬማ አዉዋ ዮሴፎ ዛራቱ ሀዋፐ ካሊደ ጻፈቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ምናሰ ዛራቱ ምናሰ ናኣ ማኪራ ያራቱዋ፥ ማኪር ናኣ ጋላኣደ ያራቱዋነ ጋላኣደ ናናቱ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ጋላኣደ ዛራቱ እኤዘራ ያራቱዋ፥ ሄሌቃ ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","አስርኤላ ያራቱዋ፥ ሸኬማ ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ሻምዳአ ያራቱዋነ ሄፌራ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ሄፌራ ናአይ ጻሎፍሃድ ማጫ ናናቱ ጻላላ የሌዳ፤ አዉ አቱማ ናእ ባዋ። ጻሎፍሃዳ ማጫ ናናቱ ሱንꬃይ ማህሎ፥ ኖኦ፥ ሆግሎ፥ ምልኮነ ትርጾ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ሀዋንቱ ምናሰ ዛራቱዋ፤ ኡንቱንቱ ኡባና 52,700። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ኤፍሬማ ዛራቱ ባረንቱ ያራን ያራን: ሹተላሀ ያራቱዋ፥ በኬራ ያራቱዋ፥ ታሃና ያራቱዋነ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ሹተላሀ ናኣ ኤራና ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ሀዋንቱ ኤፍሬማ ዛራቱዋ፤ ኡንቱንቱ ኡባና 32,500። ዮሴፎ ዛራቱ ባረንቱ ያራን ያራን ሄዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ቢንያማ ዛራቱ ባረንቱ ያራን ያራን: በላአ ያራቱዋ፥ አሽቤላ ያራቱዋ፥ አህራማ ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ሻፉፋማ ያራቱዋ፥ ሁፋማ ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","በላአ ናኣ አራዳ ያራቱዋነ በላአ ናኣ ናእማና ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ሀዋንቱ ቢንያማ ዛራቱዋ፤ ኡንቱንቱ ኡባና 45,600። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ዳና ዛራቱ ሹሃማ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ሹሃማ ያራቱ ኡባና 64,400። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","አሴራ ዛራቱ ባረንቱ ያራን ያራን: ይምና ያራቱዋ፥ ይሽዋሀ ያራቱዋ፥ ባሪአ ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ባሪአ ናኣ ሄቤራ ያራቱዋነ ባሪአ ናኣ ማልክኤላ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","አሴራዉ ሰራሆ ግያ ማጫ ናታ ደአዉ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ሀዋንቱ አሴራ ዛራቱዋ፤ ኡንቱንቱ ኡባና 53,400። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ንፍታሌማ ዛራቱ ባረንቱ ያራን ያራን: ያእዝኤላ ያራቱዋ፥ ጉና ያራቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","የጼራ ያራቱዋነ ሽሌማ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ሀዋንቱ ንፍታሌማ ዛራቱዋ፤ ኡንቱንቱ ኡባና 45,400። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ፓይደቴዳ እስራኤልያ አቱማ አሳይ ኡባና 601,730። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ቃይካ መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ሀ ዛረቶ ኡንቱንቱ ሱንꬃ ሱንꬃ ፓይዱዋዳን ቢታይ ሻከቲደ፥ ላታ ግዲደ ኡንቱንቶ እመቶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ፓይዱዋን ጮራቶ ኡንቱንቱ ጮራተꬃ ኬና፥ ፓይዱዋን ጉꬃቶ ኡንቱንቱ ጉꬃተꬃ ኬና ሻካደ እማ። ኡባይካ ጻፈቴዳ ባረንቱ ፓይዱዋ ኬና ኬና አክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ሽን ቢታይ ሳማን ሻከቶ፤ እት እት ዛሪ ላትያ ቢታይ ኡንቱንቱ አዉዋ ዛርያ ሱንꬃዳን ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ላታ ኡባይ ፓይዱዋን ጮራቱዋፐነ ፓይዱዋን ጉꬃቱዋፐ ግዱዋን ኤጻን ሻከቶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ባረ ያራን ያራን ፓይደቴዳ ሌዋቱ ሀዋንታ: ገርሾና ያራቱዋ፥ ቃሃታ ያራቱዋነ ማራራ ያራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ሀዋንቱካ ቃይ ሌዋቱዋ ያራቱዋ: ሊብና ያራቱዋ፥ ከብሮና ያራቱዋ፥ ማህላ ያራቱዋ፥ ሙሻ ያራቱዋነ ቆራሀ ያራቱዋ። ቃሃት አምራማ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","አምራማ ማቻት ሱንꬃይ ዮከቤዶ፤ አ ግብጼን ሌዊያዉ የለቴዳ ናቶ። እዛ አምራማዉ አሮና፥ ሙሳነ ኡንቱንቱ ምቻቶ ሚርያሞ የላዱ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","አሮን ናዳባ፥ አቢሀ፥ ኤልኣዛራነ እታማራ የሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ሽን መꬍና ጎዳይ አዛዝቤና ታማ አ ስንꬃን ያርሼዳ ዎደ፥ ናዳብነ አብሁ ሀይቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","የለቶደፐ እት አግናነ ሄዋፐ ቦላና ደእያ ፓይደቴዳ አቱማ ሌዋቱ ኡባና ላታማነ ሄዙ ሻአ። እስራኤላቱዋ ግዱዋን ኡንቱንቶ ላትያ ቢታይ እመትቤና ድራዉ፥ ኡንቱንቱ እስራኤላቱዋና ፓይደትበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ዮርዳኖሳ ሻፋፐ ሄፍንꬃ ባጋና፥ እያርኮ ማታን፥ ሞኣባ ደምባን ሙሴነ ቄሲ ኤልኣዛር እስራኤላቱዋ ፓይዴዳ ዎደ፥ ፓይደቴዳ አሳይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ሙሴነ ቄሲ አሮን ካሰ ሲና መላ ቢታን እስራኤላቱዋ ፓይዴዳ ዎደ፥ ፓይደቴዳ አሳፐ ሀራይ አቶ መጽ እት አሳይነ አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","አያዉ ጎፐ፥ መꬍና ጎዳይ ሄ እስራኤላቱዋ ኦዲደ፥ “ኡንቱንቱ መላ ቢታን ቱሙ ሀይቃና” ያግ ዎꬄዳ። ይፉነ ናኣ ካሌባፐነ ኔዌ ናኣ ኢያሱፐ አትና፥ ሀራይ እት አሳይነ አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ጻሎፍሃዳ ማጫ ናናይ ማህሎ፥ ኖኦ፥ ሆግሎ፥ ምልኮነ ትርጾ። ጻሎፍሃድ ሄፌራ ናኣ፤ ሄፌር ጋላኣደ ናኣ፤ ጋላኣደ ማክራ ናኣ፤ ማክር ምናሰ ናኣ፤ ምናሰ ዮሴፎ ናኣ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ሀ ማጫ ናናይ ጋከትያ ዱንካንያ ፐንግያን ሙሴ ስንꬃን፥ ቄስያ ኤልኣዛራ ስንꬃን፥ ካፓቱ ስንꬃንነ ማባራ ኡባ ስንꬃን ኤቂደ፥ ሀዋዳን ያጌድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“ኑ አዉ ባዙዋን ሀይቄዳ፤ እ ባረ ናጋራን ሀይቄዳፐ አትና፥ መꬍና ጎዳ ቦላ ደንዴዳ ቆራሀ ካልያዋንቱ ግዶን ደኤና። አዉ አቱማ ናእ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","አቱማ ናእ አዉ ባይናዋ ግዶፐነ፥ ኑ አዉዋ ሱንꬃይ አ ዳቦቱዋ ግዱዋፐ አያዉ ꬋዪ? ኑ አዉዋ እሻንቱ ግዶን ኑዉ ላትያ ቢታ እማ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ሙሴ ኡንቱንቱ ኦሻ መꬍና ጎዳ ስንꬃ ሺሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ጻሎፍሃዳ ማጫ ናናይ ኦቼዳዌ ልከ፤ ኡንቱንቱ አዉዋ እሻንቱ ግዶን ኔን ኡንቱንቶ ላትያ ቢታ እማ፤ አ ላታይ ኡንቱንታ ጋኮ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ቃይ ኔን እስራኤላቱዋ ሀዋዳን ያጋ፤ ‘እት አሳይ አቱማ ናእ ባይናን ሀይቂያዋ ግዶፐ፥ አ ቢታ አ ማጫ ናእ ላቶ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ማጫ ናእካ አዉ ባይናዋ ግዶፐ፥ አ ቢታ አ እሻቱ ላትኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","አዉ እሻቱ ባይናዋ ግዶፐ፥ አ አዉዋ እሻቱ ላትኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","አ አዉዋ እሻቱካ ባይናዋ ግዶፐ፥ አ ዛርያፐ ኡባፐ ማታትያ ዳቡዋ ላትሳ። ታን መꬍና ጎዳይ ኔና ሙሳ አዛዜዳዋዳን፥ ሀዌ እስራኤላቶ ህገ ግዶ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ሙሳ፥ “ፑደ አባርማ ደረቱዋ ከሳደ፥ ታን እስራኤልያ አሳዉ እሜዳ ቢታ በአ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","በኤዳዋፐ ጉይያን፥ ነ እሻ አሮነዳን ኔንካ ሀይቃደ፥ ነ ማይዛን ጋከታና። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","አያዉ ጎፐ፥ ጺና ባዙዋን ደእያ ሃꬃን አሳይ ኡባይ ማካሌዳ ዎደ፥ ህንተ ላኡካ ኡንቱንቱ ስንꬃን ታና ጌሻዳን ቦንቻናዉ ታዉ አዛዘትበይክታ” ያጌዳ። ሄዌ ሃꬃይ ጺና መላ ቢታን፥ ቃዴሳን ደእያ ማሪባ ሃꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ሙሴ መꬍና ጎዳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","“አቤት መꬍና ጎዳዉ፥ አሳ ኡባዉ ደኡዋ እምያ ጾሳዉ፥ ነ አሳይ፥ ጾሳ አሳይ ሄንꬃንቻይ ባይና ዉድያ ማላ ግደናዳን፥ ሀ አሳ ስንꬃን ከስያነ ገልያ፥ ኡንቱንቱካ ካለꬂደ ከስያነ ገልስያ፥ እት አሳ ሀ ማባራ ቦላ ሱንꬃርኪ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","መꬍና ጎዳይ ሙሳ፥ “አያናይ አን ደእያ ኔዌ ናኣ ኢያሳ አካደ፥ ነ ኩሽያ አ ቦላ ዎꬃ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ያታደ ቄስያ ኤልኣዛራ ስንꬃንነ ማባራ ኡባ ስንꬃን ኤሳደ፥ ኡንቱንቱ በእሽን ሱንꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","እስራኤላቱዋ ማባራ ኡባይ አዉ አዛዘታናዳን፥ ነ ማታፐ አዉ ሻካደ እማ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ቄስያ ኤልኣዛራ ስንꬃን እ ኤቆ፤ ኤልኣዛር ኡሪምያን አዉ መꬍና ጎዳ ሸንያ ኦቾ። ኢያሱነ እስራኤልያ ማባራይ ኡባይ ኤልኣዛራ አዛዙዋን ከስኖነ አ አዛዙዋን ገልኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","መꬍና ጎዳይ አዛዜዳዋዳን ሙሴ ኦꬄዳ፤ ኢያሳ አፊደ፥ ቄስያ ኤልኣዛራ ስንꬃንነ ማባራ ኡባ ስንꬃን ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","መꬍና ጎዳይ ጾሳይ አዛዜዳዋዳን፥ ሙሴ ባረ ኩሽያ አ ቦላ ዎꬂደ፥ አ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“እስራኤላቱዋ ሀዋዳን ያጋደ አዛዛ፤ ‘ታ ቁማ፥ ታና ቶሹኩ ጊደ ሳዋና ማላ፥ ታማን ያርሽያ ታ ያርሹዋ ኬሬዳ ዎድያን ዎድያን ታዉ ናጊደ እምተ’ ያጋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ቃይ ኔን ኡንቱንታ፥ ‘መꬍና ጎዳዉ ታማን ያርሽያ ያርሹ ሀዋ: ትላ ቦላና ደእያ፥ እት ላይꬃ ግዴዳ ላኡ ዶርሳ ኦርገቱዋ ሀች ሀች ጹግያ ያርሾ ያርሽተ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ዶርሳ ኦርገቱዋፐ እቱዋ ዎንታ፥ ላኤንꬁዋ ኦማርስ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ቃይ ሄዋና እት ሊትሮ ግድያ ዛይትያን ሙናቀቴዳ እት ኪሎ ግራመ ሙሩታ ዛርጋ ꬊልያ ካꬃ ያርሾ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ሀዌ መꬍና ጎዳ ቶሹኩ ጊደ ሳዋና ማላ፥ ሲና ደርያ ቦላን አዛዘቴዳ፥ ሀች ሀች ታማን ጹግያ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ሄዋና ያርሽያ ኡሻ ያርሹ እት ዶርሳ ኦርግያዉ እት ሊትሮ ግድያ ዎይንያ ኤሳ። ኡሻ ያርሹዋ ጌሻ ሳኣን መꬍና ጎዳዉ ጉስተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ኦማርስ ላኤንꬆ ዶርሳ ኦርግያ፥ ዎንታዋ ኦꬄዳዋዳን ኦꬂደ፥ ካꬃ ያርሹዋናነ ኡሻ ያርሹዋና መꬍና ጎዳ ቶሹኩ ጊደ ሳዋና ማላ፥ ታማን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘ሳምባታ ጋላሳን፥ ትላ ቦላና ደእያ እት ላይꬃ ግዴዳ ላኡ ዶርሳነ ዛይትያን ሙናቀቴዳ ላኡ ኪሎ ግራመ ግድያ ሙሩታ ꬊልያ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ኦꬂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ሀቼ ሀች ጹግያ ያርሹዋነ አ ኡሻ ያርሹዋ ቦላ፥ ሳምባታ ጋላሳ ኡባን ህንተ ያርሽያ ጹግያ ያርሹ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘አግናይ ጼርያ ጋላሳ ኡባን፥ ላኡ ኮሩማቱዋ፥ እት ዶርሳ ኦርግያነ እት ላይꬃ ግዴዳ ላፑን ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ጹግያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳዉ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","እት እት ኮሩማና ዛይትያን ሙናቀቴዳ ሄዙ ኪሎ ግራመ ግድያ ሙሩታ ዛርጋ ꬊልያ፥ እት ዶርሳ ኦርግያና ዛይትያን ሙናቀቴዳ ላኡ ኪሎ ግራመ ግድያ ሙሩታ ዛርጋ ꬊልያነ ");
INSERT INTO dwrENT_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ላፑን ዶርሳ ማራቱዋፐ እት እት ዶርሳ ማራና ዛይትያን ሙናቀቴዳ እት ኪሎ ግራመ ግድያ ሙሩታ ዛርጋ ꬊልያ ካꬃ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳ ቶሹኩ ጊደ ሳዋና ማላ፥ ታማን ያርሽያ ያርሹዋ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ቃይ ኡሻ ያርሾ እት እት ኮሩማና ላኡ ሊትሮ ግድያ ዎይንያ ኤሳ፥ እት ዶርሳ ኦርግያና እት ሊትሮነ ባጋ ዎይንያ ኤሳነ እት እት ዶርሳ ማራና እት ሊትሮ ግድያ ዎይንያ ኤሳ ሺሽተ። ሀዌ ላይꬃ ግዶን አግናይ ጼርያ ጋላሳ ኡባን ያርሽያ ጹግያ ያርሹዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ሀቼ ሀች ጹግያ ያርሹዋነ አ ኡሻ ያርሹዋ ቦላ፥ እት ዴሻ ኦርግያ ናጋራ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳዉ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘ኮይሮ አግናን ታማነ ኦይደንꬆ ጋላሳይ መꬍና ጎዳ ፓስጋ ቦንችያ ጋላሳ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ቃይ ሄ አግናንካ ታማነ እቼሸንꬆ ጋላሳን ዶሚደ፥ ኡክꬃ ባላይ ቦንቼቴ፤ ሄዋ ድራዉ፥ ላፑን ጋላሳቱዋን እርሹ ገልቤና ኡክꬃ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ሄ ጋላሳቱዋፐ ኮይሮ ጋላሳን ጌሻ ሺቁዋ ሺቅተ፤ ዳቡርስያ ኦሶ አያነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ላኡ ኮሩማቱዋ፥ እት ዶርሳ ኦርግያነ እት ላይꬃ ግዴዳ ላፑን ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ታማን ያርሽያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳዉ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ካꬃ ያርሾ እት ኮሩማና ዛይትያን ሙናቀቴዳ ሄዙ ኪሎ ግራመ ግድያ ሙሩታ ዛርጋ ꬊልያ፥ እት ዶርሳ ኦርግያና ላኡ ኪሎ ግራመ ግድያ ꬊልያነ ");
INSERT INTO dwrENT_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ላፑን ዶርሳ ማራቱዋፐ እት እት ማራና እት ኪሎ ግራመ ꬊልያ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ቃይ እት ዴሻ ኦርግያ ናጋራ ያርሾ፥ ህንተ ናጋራ አቶ ጊሳናዉ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","24","ሀቼ ሀች ዎንታ ጹግያ ያርሹዋነ አ ካꬃ ያርሹዋ ቦላ፥ ሳዉዋ ቶሹኩ ግያ ቁማ ታማን ያርሽያ ያርሹዋ ጉጂደ፥ መꬍና ጎዳዉ ያርሽተ። ላፑን ጋላሳዉ ሄዋዳን ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ላፑንꬃ ጋላሳን ቃይ ጌሻ ሺቁዋ ሺቅተ፤ ዳቡርስያ ኦሶ አያነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘ሳምንታቱ ባላ ጋላሳን ህንተ መꬍና ጎዳዉ ኦራꬃ ካꬃ ሺሽያ ዎደ፥ ጌሻ ሺቁዋ ሺቅተ፤ ዳቡርስያ ኦሶ አያነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ላኡ ኮሩማቱዋ፥ እት ዶርሳ ኦርግያነ እት ላይꬃ ግዴዳ ላፑን ዶርሳ ኦርገቱዋ ሳዉዋ ቶሹኩ ግያ ጹግያ ያርሹዋ ኦꬂደ፥ መꬍና ጎዳዉ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","እት እት ኮሩማና ዛይትያን ሙናቀቴዳ ሄዙ ኪሎ ግራመ ግድያ ሙሩታ ዛርጋ ꬊልያ፥ እት ዶርሳ ኦርግያና ላኡ ኪሎ ግራመ ꬊልያነ ");
INSERT INTO dwrENT_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ላፑን ዶርሳ ማራቱዋፐ እት እት ማራና እት ኪሎ ግራመ ꬊልያ ካꬃ ያርሾ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ቃይ እት ዴሻ ኦርግያ ናጋራ አቶ ጊስያ ያርሹዋ ኦꬂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ሀቼ ሀች ጹግያ ያርሹዋነ አ ኡሻ ያርሹዋ ቦላ፥ ሀዋንታ ኡንቱንቱ ካꬃ ያርሹዋና ያርሽተ። መሄቱ ትላ ቦላና ደእያዋንታ ግድያዋ ጌሺደ ኤርተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘ላፑንꬃ አግናዉ ኮይሮ ጋላሳን፥ ጌሻ ሺቁዋ ሺቅተ። ዳቡርስያ ኦሶ አያነ ኦꬆፕተ። ሄ ጋላሳይ ጹሩምባይ ፑነትያ ጋላሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","መꬍና ጎዳዉ ሳዉዋ ቶሹኩ ጋና ማላ፥ ጹግያ ያርሾ፥ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃ ግዴዳ ላፑን ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ካꬃ ያርሾ እት ኮሩማና ዛይትያን ሙናቀቴዳ ሄዙ ኪሎ ግራመ ግድያ ሙሩታ ዛርጋ ꬊልያ፥ እት ዶርሳ ኦርግያና ላኡ ኪሎ ግራመ ꬊልያነ ");
INSERT INTO dwrENT_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ላፑን ዶርሳ ማራቱዋፐ እት እት ማራና እት ኪሎ ግራመ ꬊልያ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ቃይ እት ዴሻ ኦርግያ ናጋራ ያርሾ፥ ህንተ ናጋራ አቶ ጊሳናዉ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ሄዋንታ አግናይ ጼርያ ጋላሳን ጹግያ ያርሹዋ ቦላነ አ ካꬃ ያርሹዋ ቦላ፥ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ አ ካꬃ ያርሹዋ ቦላነ አ ኡሻ ያርሹዋ ቦላ ጉጂደ፥ ዎጋዳን ያርሽተ፤ ሀዋንቱ መꬍና ጎዳዉ ሳዉዋ ቶሹኩ ግያ፥ ታማን ያርሽያ ያርሾቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘ሀ ላፑንꬃ አግናዉ ታማንꬃ ጋላሳን ጌሻ ሺቁዋ ሺቅተ፤ ህንተ ሁጲያ ካዉሽተ፤ አያ ኦሱዋካ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ያቲደ መꬍና ጎዳ ቶሹኩ ጊደ ሳዋና ማላ፥ ጹግያ ያርሾ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃ ግዴዳ ላፑን ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ካꬃ ያርሾ እት ኮሩማና ዛይትያን ሙናቀቴዳ ሄዙ ኪሎ ግራመ ግድያ ሙሩታ ዛርጋ ꬊልያ፥ እት ዶርሳ ኦርግያና ላኡ ኪሎ ግራመ ꬊልያነ ");
INSERT INTO dwrENT_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ላፑን ዶርሳ ማራቱዋፐ እት እት ማራና እት ኪሎ ግራመ ꬊልያ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ቃይ ናጋራ ያርሾ እት ዴሻ ኦርግያ ያርሽተ። ሄዋንታ ናጋራ አቶ ጊስያ ያርሹዋ ቦላ፥ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ ኡንቱንቱ ካꬃ ያርሹዋ ቦላነ ኡንቱንቱ ኡሻ ያርሹዋ ቦላ ጉጂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘ላፑንꬃ አግናን ታማነ እቼሸንꬆ ጋላሳን፥ ጌሻ ሺቁዋ ሺቅተ፤ ዳቡርስያ ኦሶ አያነ ኦꬆፕተ። መꬍና ጎዳዉ ዳስያ ባላ ላፑን ጋላሳ ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","መꬍና ጎዳ ቶሹኩ ጊደ ሳዋና ማላ፥ ታማን ያርሽያ ታማነ ሄዙ ኮሩማቱዋ፥ ላኡ ዶርሳ ኦርገቱዋነ እት ላይꬃ ግዴዳ ታማነ ኦይዱ ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ካꬃ ያርሾ ታማነ ሄዙ ኮሩማቱዋፐ እት እት ኮሩማና ዛይትያን ሙናቀቴዳ ሄዙ ኪሎ ግራመ ግድያ ሙሩታ ዛርጋ ꬊልያ፥ ላኡ ዶርሳ ኦርገቱዋፐ እት እት ኦርግያና ላኡ ኪሎ ግራመ ꬊልያነ ");
INSERT INTO dwrENT_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ታማነ ኦይዱ ዶርሳ ማራቱዋፐ እት እት ማራና እት ኪሎ ግራመ ꬊልያ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ቃይ ናጋራ ያርሾ እት ዴሻ ኦርግያ ያርሽተ። ሄዋንታ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ አ ካꬃ ያርሹዋ ቦላነ አ ኡሻ ያርሹዋ ቦላ ጉጂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘ላኤንꬃ ጋላሳን ታማነ ላኡ ኮሩማቱዋ፥ ላኡ ዶርሳ ኦርገቱዋነ እት ላይꬃ ግዴዳ ታማነ ኦይዱ ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ኮሩማቱዋና፥ ዶርሳ ኦርገቱዋናነ ዶርሳ ማራቱዋና፥ ኡንቱንቱ ካꬃ ያርሹዋነ ኡንቱንቱ ኡሻ ያርሹዋ ዎጋይ አዛዝያ ፓይዱዋዳን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ቃይ ናጋራ ያርሾ እት ዴሻ ኦርግያ ያርሽተ። ሄዋንታ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ አ ካꬃ ያርሹዋ ቦላነ አ ኡሻ ያርሹዋ ቦላ ጉጂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘ሄዘንꬃ ጋላሳን፥ ታማነ እት ኮሩማቱዋ፥ ላኡ ዶርሳ ኦርገቱዋነ እት ላይꬃ ግዴዳ ታማነ ኦይዱ ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ኮሩማቱዋና፥ ዶርሳ ኦርገቱዋናነ ዶርሳ ማራቱዋና፥ ኡንቱንቱ ካꬃ ያርሹዋነ ኡንቱንቱ ኡሻ ያርሹዋ ዎጋይ አዛዝያ ፓይዱዋዳን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ቃይ ናጋራ ያርሾ እት ዴሻ ኦርግያ ያርሽተ። ሄዋንታ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ አ ካꬃ ያርሹዋ ቦላነ አ ኡሻ ያርሹዋ ቦላ ጉጂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘ኦይደንꬆ ጋላሳን፥ ታሙ ኮሩማቱዋ፥ ላኡ ዶርሳ ኦርገቱዋነ እት ላይꬃ ግዴዳ ታማነ ኦይዱ ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ኮሩማቱዋና፥ ዶርሳ ኦርገቱዋናነ ዶርሳ ማራቱዋና፥ ኡንቱንቱ ካꬃ ያርሹዋነ ኡንቱንቱ ኡሻ ያርሹዋ ዎጋይ አዛዝያ ፓይዱዋዳን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ቃይ ናጋራ ያርሾ እት ዴሻ ኦርግያ ያርሽተ። ሄዋንታ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ አ ካꬃ ያርሹዋ ቦላነ እዛ ኡሻ ያርሹዋ ቦላ ጉጂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘እቼሸንꬃ ጋላሳን፥ ኡዱፑን ኮሩማቱዋ፥ ላኡ ዶርሳ ኦርገቱዋነ፥ እት ላይꬃ ግዴዳ ታማነ ኦይዱ ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ኮሩማቱዋና፥ ዶርሳ ኦርገቱዋናነ ዶርሳ ማራቱዋና ኡንቱንቱ ካꬃ ያርሹዋነ ኡንቱንቱ ኡሻ ያርሹዋ ዎጋይ አዛዝያ ፓይዱዋዳን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ቃይ ናጋራ ያርሾ እት ዴሻ ኦርግያ ያርሽተ። ሄዋንታ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ አ ካꬃ ያርሹዋ ቦላነ አ ኡሻ ያርሹዋ ቦላ ጉጂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘ኡሱፑንꬃ ጋላሳን፥ ሆስፑን ኮሩማቱዋ፥ ላኡ ዶርሳ ኦርገቱዋነ እት ላይꬃ ግዴዳ ታማነ ኦይዱ ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ኮሩማቱዋና፥ ዶርሳ ኦርገቱዋናነ ዶርሳ ማራቱዋና ኡንቱንቱ ካꬃ ያርሹዋነ ኡንቱንቱ ኡሻ ያርሹዋ ዎጋይ አዛዝያ ፓይዱዋዳን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ቃይ ናጋራ ያርሾ እት ዴሻ ኦርግያ ያርሽተ። ሄዋንታ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ አ ካꬃ ያርሹዋ ቦላነ አ ኡሻ ያርሹዋ ቦላ ጉጂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘ላፑንꬃ ጋላሳን፥ ላፑን ኮሩማቱዋ፥ ላኡ ዶርሳ ኦርገቱዋነ እት ላይꬃ ግዴዳ ታማነ ኦይዱ ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ኮሩማቱዋና፥ ዶርሳ ኦርገቱዋናነ ዶርሳ ማራቱዋና ኡንቱንቱ ካꬃ ያርሹዋነ ኡንቱንቱ ኡሻ ያርሹዋ ዎጋይ አዛዝያ ፓይዱዋዳን ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ቃይ ናጋራ ያርሾ እት ዴሻ ኦርግያ ያርሽተ። ሄዋንታ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ አ ካꬃ ያርሹዋ ቦላነ አ ኡሻ ያርሹዋ ቦላ ጉጂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘ሆስፑንꬃ ጋላሳን ጌሻ ሺቁዋ ሺቅተ፤ ዳቡርስያ ኦሶ አያነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ታማን ያርሽያ ያርሹ መꬍና ጎዳ ቶሹኩ ጊደ ሳዋና ማላ፥ እት ኮሩማ፥ እት ዶርሳ ኦርግያነ እት ላይꬃ ግዴዳ ላፑን ዶርሳ ኦርገቱዋ፥ ኡባይካ ትላ ቦላና ደእያዋንታ፥ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ኮሩማና፥ ዶርሳ ኦርግያናነ ዶርሳ ማራቱዋና ኡንቱንቱ ካꬃ ያርሹዋነ ኡንቱንቱ ኡሻ ያርሹዋ ዎጋይ አዛዝያ ፓይዱዋዳን ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ቃይ ናጋራ ያርሾ እት ዴሻ ኦርግያ ያርሽተ። ሄዋንታ ሀች ሀች ጹግያ ያርሹዋ ቦላ፥ አ ካꬃ ያርሹዋ ቦላነ አ ኡሻ ያርሹዋ ቦላ ጉጂደ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘ህንተ ሺቆዋ ጋꬃናዉ ያርሽያ ያርሾቱ ቦላነ ህንተ ህንተ ዶሱዋን ጮ እምያ ያርሾቱ ቦላ፥ ጹግያ ያርሹዋ፥ ካꬃ ያርሹዋ፥ ኡሻ ያርሹዋነ እትፐተꬃ ያርሹዋ፥ ሀዋንታ መꬍና ጎዳ ባላ ህንተ ቦንቻናዉ ኬሬዳ ዎድያን ዎድያን ያርሽተ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ሙሴ ባረና መꬍና ጎዳይ አዛዜዳዋ ኡባ እስራኤላቶ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ሙሴ እስራኤልያ ዛራቱ ካፓቱዋ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳይ አዛዝያዌ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","እት አሳይ መꬍና ጎዳዉ እትባ ኦꬃናዉ ገፖፐ፥ ዎይ እትባ አጋናዉ ጫቆፐ፥ ባረ ዶናፐ ከሴዳዋ ኡባ ፖሎፐ አትና፥ ባረ ቃላ ብሎፖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“ባረ አዉዋ ሶን ደእያ ዎዶሮ ናታ፥ መꬍና ጎዳዉ እትባ ኦꬃናዉ ገፖፐ፥ ዎይ እትባ አጋናዉ ጫቆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","እ አዉ እ ገፋ ዎይ እ ጫቁዋባ ስሲደ፥ እዞ አይነ ጌናን አጎፐ፥ አ ኦꬃናዉ ገፔዳዋ ኡባነ አጋናዉ ጫቄዳዋ ኡባ ፖሉ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ሽን እ አዉ ሄዋ ስሲደ ጳልቆፐ፥ አ ገፔዳ ገፋይነ አጋናዉ ጫቄዳ ጫቁ ፖለተናን አቴ። እ አዉ እዞ ድጌዳ ድራዉ፥ መꬍና ጎዳይ እዝዉ አቶ ጋና። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ገላቤና ማጫውና ገፓ ኡታደ፥ ዎይ እትባ አጋናዉ ኤለካ ባረ ዶናፐ ጫቃ ኡታደ አስና ገሎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","እ አስናይ ሄዋ ስሲደ፥ እዞ አይነ ጌናን አጎፐ፥ አ ኦꬃናዉ ገፔዳ ገፋነ እትባ አጋናዉ ጫቄዳ ጫቁዋ ፖሉ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ሽን እ አስናይ ሄዋ ስሲደ ጳልቆፐ፥ አ ገፔዳ ገፋይ ዎይ እትባ አጋናዉ ኤለካ ጫቄዳ ጫቁ ፖለተናን አቴ። ሄዋ ድራዉ፥ መꬍና ጎዳይ እዝዉ አቶ ጋና። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“ሽን አምአታ ዎይ አስናይ የዴዳ ማጫውኖ ኦꬃናዉ ገፔዳዋ ዎይ እትባ አጋናዉ ጫቄዳዋ ፖሉ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ማቻታ ባረ አስና ሶን ደኣደ ገፖፐ፥ ዎይ እትባ አጋናዉ ጫቁዋ ጫቆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","እ አስናይ ሄዋ ስሲደ እዞ አይነ ጌናን አጎፐ፥ አ ገፔዳ ገፋነ እትባ አጋናዉ ጫቄዳ ጫቁዋ ኡባ ፖሉ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ሽን እ አስናይ ሄዋ ስሲደ ጳልቆፐ፥ እ ገፋይ ዎይ አ አጋናዉ ጫቄዳ ጫቁ አያይነ ፖለቶፖ። እ አስናይ ድጌዳ ድራዉ፥ መꬍና ጎዳይ እዝዉ አቶ ጋና። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","እ አስናይ አ ገፕያ ገፋ ኡባ ዎይ አ ባረና ዝቂ ኦꬃናዉ ጫቄዳዋ ኡባ ጳልቃናዉ ዎይ ኤኖ ጋናው ዳንዳዬ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ሽን እ አስናይ ሄ ጋላስ ዎይ ዎንተꬃ ጋላስ ሄዋ አይነ ጌናን አጎፐ፥ እ ገፋ ኡባ ዎይ እ ጫቁዋ ኡባ ማዬ። እ ሄዋ ስሴዳ ጋላስ ጮኡ ጌዳዋዳን እ ገፋ ኡባ ዎይ እ ጫቁዋ ኡባ ማይ ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ሽን እ ሄዋ ስሴዳ አማሬዳ ዎድያፐ ጉይያን ጳልቆፐ፥ እ ጎሚ አ ጋኬ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","አስና ገላቤና፥ ባረ አዉዋ ሶን ደእያ ዎዶሮ ናታነ እ አዉዋ ግዱዋን ዎይ ማቻትነ አስና ግዱዋን ደአና ማላ፥ መꬍና ጎዳይ ሙሳ አዛዜዳ ገፋ ዎጋይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","መꬍና ጎዳይ ሙሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“እስራኤልያ አሳ ድራዉ፥ ኔን ምድያማ አሳ ቦላ ጾሳ ሀሉዋ ከሳ፤ ሄዋፐ ጉይያን፥ ኔን ሀይቃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ሄዋ ድራዉ፥ ሙሴ አሳ፥ “ምድያማ አሳ ቦላ መꬍና ጎዳ ሀሉዋ ከሳና ማላ ኦላ ባናዉ፥ ህንተ አሳ ኦላ ሚሻ ዳንጭስተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","እት እት እስራኤልያ ዛራቱዋፐ እት ሻአ አቱማ አሳ ኦላዉ የድተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","እስራኤልያፐ ታማነ ላኡ ሻአ አቱማ አሳይ፥ እት እት ዛርያፐ እት ሻአ አሳይ፥ ኦላዉ ጊጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","እት እት ዛርያፐ እት ሻአ አሳ ሙሴ ቄስያ ኤልኣዛራ ናኣ ፒንሃሳና ኦላዉ የዴዳ፤ ፒንሃስ ጌሻ ሚሻቱዋነ ማላታዉ ፑንያ ጹሩምባ ባረናና አኪደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ኡንቱንቱ ምድያማ አሳና ኦለቲደ፥ አቱማ አሳ ኡባ ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ቃይ ምድያማ ካተቱዋ እቼሻቱዋ፥ ኤዋ፥ ረቄማ፥ ጹራ፥ ሁራነ ረባአ ግያዋንታ ዎꬌድኖ። ኡንቱንቱ ቃይ ብኦራ ናኣ ባላማካ ማሻን ሲፌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","እስራኤላቱ ምድያማ ማጫ አሳቱዋነ ናናቱዋ ኦሞዲደ፥ ኡንቱንቱ ሚዛ፥ ኡንቱንቱ ዶርሳ ዉድያነ ኡንቱንቱ ሚሻ ኡባ ቦንቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ምድያማ አሳቱ ደኤዳ ካታማቱዋ ኡባነ ኡንቱንቱ ሞꬃቱዋ ኡባ ታማን ጹጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ኡንቱንቱ አሳ፥ መህያነ ኦሞዴዳዋ ኡባ አክ አፌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ኡንቱንቱ ኦሞዴዳ አሳቱዋነ ቦንቄዳባቱዋ ሙሴኮ፥ ቄስያ ኤልኣዛራኮነ እስራኤልያ ማባራኮ፥ ያርኮፐ ሄፍንꬃን፥ ዮርዳኖሳ ሻፋ ማታን ደእያ ሞኣባ ደምባን ኡንቱንቱ ዱንካኔዳሳ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ሙሴ፥ ቄሲ ኤልኣዛርነ ማባራ ካፓቱ ኡባይ ዱንካኔዳ ሳኣፐ ጋጻ ኡንቱንቱና ጋከታናዉ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ኦላፐ ስሜዳ ጋዳዋቱ ቦላ፥ ሻላቃቱ ቦላነ ጼቱዋ ካፓቱ ቦላ ሙሴ ሀንቀቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ሙሴ ኡንቱንታ ሀዋዳን ያጌዳ፤ “ማጫ አሳ ኡባ ህንተ አያዉ አሼድቴ? ");
INSERT INTO dwrENT_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ኡንቱንቱ ባላማ ዞርያን፥ ፓኦራ ግያ ሳን እስራኤልያ አሳይ መꬍና ጎዳ ናቂደ፥ ኤቃዉ ጎይናናዳን ኦꬄዳዋንታ፤ መꬍና ጎዳ አሳ ቦላ ቦሻይ ዬዳዌ ሄዋሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ሄዋ ድራዉ፥ ሀእ አቱማ ናናቱዋ ኡባ ዎꬍተ፤ ቃይ አቱማ አሳና ግሴዳ ማጫ አሳ ኡባ ዎꬍተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ሽን አቱማ አሳና ግሳቤና ማጫ ናናቱዋ ኡባ ህንተንቶ አሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","ህንተ ግዶፐ አሳ ዎꬌዳ ኡራይ ዎይ አሃ ቦቼዳ ኡራይ ኦንነ ዱንካኔዳ ሳኣፐ ጋጻን ላፑን ጋላሳ ኡቶ፤ ሄዛንꬃ ጋላስነ ላፑንꬃ ጋላስ ህንተናነ ህንተ ኦሞዴዳዋንታ ጌሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ቃይ ማዮ ኡባነ ጋልባፐ፥ ዴሻ እክሰፐነ ምꬃፐ ኦሰቴዳዋንታ ኡባ ጌሽተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ቄሲ ኤልኣዛር ኦላፐ ስሜዳ ኦላንቻቱዋ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳይ ሙሴዉ እሜዳ ህግያ ማራይ ሀዋ: ");
INSERT INTO dwrENT_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ዎርቃ፥ ብራ፥ ናሃስያ፥ ብራታ፥ ቆርቆሩዋነ እርሳስያ ግያ ብራታ ");
INSERT INTO dwrENT_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ታማን ሜተተናባቱዋ ኡባ ታማ ግዶና አꬅና፥ ሄዌ ጌያና። ሽን ሄዌ ቃይ ቱናተꬃፐ ጌይያ ሃꬃን ጌያናዉ ኮሼ። ቃይ ታማን ሜተትያባቱዋ ኡባ ቱናተꬃፐ ጌይያ ሃꬃን ጌሻናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ላፑንꬃ ጋላስ ህንተ ማዩዋ ሜጭተ፤ ህንተካ ጌይተ። ሄዋፐ ጉይያን፥ ዱንካኔዳሳ ገልተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“ኔን፥ ቄሲ ኤልኣዛርነ ማባራ ካፓቱ ኦሞደቴዳ አሳነ መህያ ኡባ ፓይድተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ኦላን ኦለቴዳ ኦላንቻቶነ አቴዳ ማባራዉ ላኡ ከሲደ ሻክተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ኦለቴዳ ኦላንቻቱዋ ጋኬዳ ሻኩዋፐ፥ አሳ ግድና፥ ሚዛ ግድና፥ ሀረቱዋ፥ ዶርሳቱዋ ዎይ ዴሻቱዋ ግድና፥ እቼሹ ጼቱዋፐ እቱዋ መꬍና ጎዳዉ እሞታዳን እምተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ኡንቱንታ ጋኬዳ ባጋፐ አኬዳ ጊራ መꬍና ጎዳ ግሻዳን ቄስያ ኤልኣዛራዉ እምተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ህንኮ እስራኤላቱዋ ጋኬዳ ሻኩዋፐ፥ አሳ ግድና፥ ሚዛ ግድና፥ ሀረቱዋ፥ ዶርሳቱዋ፥ ዎይ ዴሻቱዋ ግድና፥ መህያ ኡባፐ እሻታሙዋፐ እቱዋ አኪደ ሄዋ መꬍና ጎዳ ዱንካንያዉ አዎትያ ሌዋቶ እምተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ሙሴነ ቄሲ ኤልኣዛር መꬍና ጎዳይ አዛዜዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","ኦላንቻቱ ባረንቶ አክና፥ አቴዳ ኦሞዱ 675,000 ዶርሳቱዋ፥ 72,000 ሚዛቱዋ፥ 61,000 ሀረቱዋነ አቱማ አሳና ግሳቤና 32,000 ማጫ ናናቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ኦላን ኦለቴዳዋንታ ጋኬዳ ባጋ ሻኩ 337,500 ዶርሳቱዋ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ኡንቱንቱፐ መꬍና ጎዳዉ እሞታ ከሴዳዋንቱ 675. ");
INSERT INTO dwrENT_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ሚዛቱ 36,000፤ ኡንቱንቱፐ መꬍና ጎዳዉ እሞታ ከሴዳዋንቱ 72. ");
INSERT INTO dwrENT_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ሀረቱ 30,500 ኡንቱንቱፐ መꬍና ጎዳዉ እሞታ ከሴዳዋንቱ 61. ");
INSERT INTO dwrENT_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ማጫ አሳቱ 16,000 ኡንቱንቱፐ መꬍና ጎዳዉ እሞታ ከሴዳዋንቱ፥ 32. ");
INSERT INTO dwrENT_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ መꬍና ጎዳ ጋክያ እሞታ ሙሴ ቄስያ ኤልኣዛራዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","ኦላንቻቱ አሄዳ ኦሞዱዋ ሙሴ ላኡ ከሲደ ሻክና፥ እስራኤልያ ማባራ ጋኬዳ ሻኩ 337,500 ዶርሳቱዋ፥ 36,000 ሚዛቱዋ፥ 30,500 ሀረቱዋነ 16,000 ማጫ አሳቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","እስራኤልያ ማባራ ጋኬዳ ሻኩዋፐ እሻታሙ እሻታሙ አሳፐ እቱዋነ እሻታሙ እሻታሙ መህያፐ እቱዋ ሙሴ አኪደ፥ መꬍና ጎዳይ ባረና አዛዜዳዋዳን፥ መꬍና ጎዳ ዱንካንያዉ አዎትያ ሌዋቶ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ሄዋፐ ጉይያን፥ ኦላ ጋዳዋቱ፥ ሻላቃቱነ ጼቱዋ ካፓቱ ሙሴኮ ዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ኡንቱንቱ ሙሳ፥ “ኑን ነ ቆማቱ ኑ አዛዙዋ ጋርሳን ደእያ ኦላንቻቱዋ ፓይድና፥ እቱነ ፓጭቤና። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","መꬍና ጎዳይ ኑ ሸምፑዋ አሼዳ ድራዉ፥ ኑን ሁጲያን ሁጲያን አኬዳ ዎርቃ አሌቆቱዋ፥ ኩሽያ ሳጋየቱዋ፥ ገድያ አልቦቱዋ፥ ምግዶቱዋ፥ ሀይꬃ ሎታቱዋነ ቆꬍያን አꬅያ አሌቁዋ መꬍና ጎዳዉ እሙዋ አሄዶ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ሙሴነ ቄሲ ኤልኣዛር ዎርቃ አሌቆቱዋ ኡባ ኡንቱንቱፐ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ሻኣ ካፓቱነ ጼቱዋ ካፓቱ አሂደ መꬍና ጎዳዉ እሜዳ ዎርቃይ ኡባይ ላኡ ጼቱ ኪሎ ግራመ ግድያዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ሽን እት እት ኦላንቻቱ ኡባይ ባረንቱ ኦሞዱዋ ኦሞዱዋ ባረዉ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ሙሴነ ቄሲ ኤልኣዛር ሻኣ ካፓቱዋፐነ ጼቱዋ ካፓቱዋፐ አኬዳ ዎርቃ መꬍና ጎዳ ስንꬃን እስራኤልያ አሳ ሀሳይሳና ማላ፥ መꬍና ጎዳ ዱንካንያ ግዱዋ ገልሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ሮቤላ ዛረቶነ ጋዳ ዛረቶ ሎይꬅ ዳሮ መሂ ደኤ። ኡንቱንቱ ያእዜራ ቢታይነ ጋላኣደ ቢታይ መህያዉ እንጀ ግድያዋ በኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ኡንቱንቱ ሙሴኮ፥ ቄስያ ኤልኣዛራኮነ ማባራ ካፓቱዋኮ ዪደ፥ ኡንቱንታ ሀዋዳን ያጌድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“መꬍና ጎዳይ እስራኤልያ አሳን ጾንሴዳ ቢታቱ፥ አጻሮት፥ ድቦን፥ ያእዜር፥ ኒምር፥ ሀሰቦና፥ ኤልኣል፥ ሴብም፥ ናቦነ ባኦን መህያዉ እንጀ ቢታ፤ ኑዉ ህንተ ቆማቶ መሂ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ኑን ህንተና ናሸቼዳዋ ግዶፐ፥ ሀ ቢታቱ ኑ ህንተ ቆማቶ ላታ ጋደ ግዲደ እመትኖ። ኑና ዮርዳኖሳ ሻፋ ሄፍንꬃ ፕንꬆፕተ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ሙሴ ጋዳ ዛራቱዋነ ሮቤላ ዛራቱዋ ሀዋዳን ያጌዳ፤ “ሀራ እስራኤልያ አሳይ ኦላ ብያ ዎደ፥ ህንተ ሀዋን ኡቲቴ? ");
INSERT INTO dwrENT_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","መꬍና ጎዳይ ኡንቱንቶ እሜዳ ቢታ እስራኤላቱ ፕነናዳን፥ ህንተ አያዉ ኡንቱንቱ ዎዛና ሹግሲቴ? ");
INSERT INTO dwrENT_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ቃዴሳ-ባርነፐ ሄ ቢታ ዎች ጼላናዉ ህንተ አዎቱዋ ታን የዴዳ ዎደ፥ ኡንቱንቱካ ሀዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ዋኒደ ጎፐ፥ ኡንቱንቱ ኤሽኮላ ዛንጋራ ከሲደ፥ ሄ ቢታ ጼሌዳ ዎደ፥ እስራኤላቱ መꬍና ጎዳይ ኡንቱንቶ እሜዳ ቢታ ገለና ማላ፥ ኡንቱንቱ እስራኤላቱዋ ዎዛና ሹግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","መꬍና ጎዳይ ሄ ጋላስ ሀንቁዋ ኤጽ ከሲደ፥ ሀዋዳን ያጊደ ጫቄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","12","‘መꬍና ጎዳ ባረንቱ ኩመንꬃ ዎዛናፐ ካሌዳ ቀኒዝያ ይፉነ ናኣ ካሌባፐነ ኔዌ ናኣ ኢያሱፐ አትና፥ የለቶደፐ ላታሙ ላይꬃነ ሄዋፐ ቦላና ደእያ አቱማ አሳን ግብጼ ጋድያፐ ከሴዳዋንቱፐ እቱነ፥ ታን አብራሃማዉ፥ ይሳቃዉነ ያቆባዉ እማናዉ ጫቄዳ ቢታ በኤና። አያዉ ጎፐ፥ ኡንቱንቱ ታና ባረንቱ ኩመንꬃ ዎዛናፐ ካልበይክኖ’ ያጊደ ጫቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","መꬍና ጎዳ ሀንቁ እስራኤልያ ቦላ ኤጽ ከሴዳ፤ ያትና ጾሳ ስንꬃን ኢታ ኦꬄዳ ሄ የለታ ኡባይ ዉር ꬋያና ጋካናዉ፥ መላ ቢታን ኦይታሙ ላይꬃ እ ኡንቱንታ ቶይላዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ህንተኖ፥ ናጋራንቻ የለታቶ፥ መꬍና ጎዳይ እስራኤልያ ቦላ ጉጅ ሀንቁዋ ኤጽ ከሳናዳን፥ ህንተ ህንተ አዎቱዋ ሳኣን ሀእ ኤቄድታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ህንተ መꬍና ጎዳ ካልያዋ አጊደ ዎራ ስሞፐ፥ እ ቃይካ ባረ አሳ መላ ቢታን አግ ባሻና። ያቲደ ህንተ ሀ አሳ ኡባ ꬋይሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ኡንቱንቱ ሙሴ ማታ ዪደ፥ አ ሀዋዳን ያጌድኖ፤ “ኑን ሀዋን ኑ መሄቶ ድርሳ፥ ኑ ናናዉ ካታማቱዋ ኬጻና። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ሽን ኑን ኦላ ሚሻ ዳንጪደ፥ እስራኤልያ አሳ ኡንቱንቱ ሳኣ ጋꬃና ጋካናዉ ኦለታናዉ ባና። ሄዋ ኬሻን፥ ሀ ጋድያን ደእያ አሳቱዋፐ ናገታናዉ፥ ኑ ናናይነ ማጫ አሳይ ግምበቲደ ኡቴዳ ካታማቱዋን ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","እስራኤላቱ ኡባይ ባረንቱ ላታ ላታ አካና ጋካናዉ፥ ኑን ኑ ጎለ ስሞኮ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ኑን ኑ ላታ ዮርዳኖሳ ሻፋፐ ሀፍንꬃ አዋይ ዶልያ ባጋና ላቴዳ ድራዉ፥ ኑን ዮርዳኖሳፐ ሄፍንꬃ ባጋና፥ ያን ኡንቱንቱና ላታ ላቶኮ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ሙሴ ኡንቱንቱ፥ “ህንተ ሀዋ ኦꬆፐ፥ ህንተ መꬍና ጎዳ ስንꬃን ኦላ ባናዉ ጊጎፐነ ");
INSERT INTO dwrENT_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ህንተ ኦላንቻቱ ኡባይ ኦላ ሚሻ ዳንጪደ፥ መꬍና ጎዳይ ባረ ሞርከቱዋ ባረ ስንꬃፐ የደርሳና ጋካናዉ፥ ዮርዳኖሳ ሻፋ ጾሳ ስንꬃን ፕኖፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","መꬍና ጎዳይ ሄ ቢታ ጾኔዳዋፐ ጉይያን፥ ህንተ ስማናዉ ዳንዳዪታ። ያቶፐ፥ ህንተ ኦለታናዉ በስያ ኦላ መꬍና ጎዳዉነ እስራኤልያ አሳዉ ኦለቲደ ፖሌድታ ግያዋ። ቃይ ሄ ቢታይ መꬍና ጎዳ ስንꬃን ህንተንቶ ላታ ቢታ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“ሽን ህንተ ሄዋዳን ኦናን እጾፐ፥ መꬍና ጎዳ ቦላ ናጋራ ኦꬂታ፤ ስም ህንተና ህንተ ናጋራይ ጋክያዋ ቱሙ ኤርተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ህንተ ህንተ ናናዉነ ማጫ አሳዉ ካታማቱዋ ኬጽተ፤ ህንተ ዶርሳ ዉድያዉካ ባሉዋ ጊግስተ፤ ሽን ህንተ ጌዳዋ አገናን ኦꬅተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ጋዳ ዛራቱነ ሮቤላ ዛራቱ ሙሳ፥ “ኑን ነ ቆማቱ ኔን ኑ ጎዳይ አዛዜዳዋዳን ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ኑ ናናቱነ ኑ ማጫ አሳቱ፥ ኑ ዶርሳቱነ ኑ ሚዛቱ ሀዋን ጋላኣደ ካታማቱዋን ደእሽኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ሽን ኑን ነ ቆማቱ፥ ኦላዉ ዳንጬዳ ኦላንቻቱ ኡባይ፥ ኔን ኑ ጎዳይ ግያዋዳን፥ ኦለታናዉ መꬍና ጎዳ ስንꬃን ዮርዳኖሳ ሻፋ ፕናና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ሄዋ ድራዉ፥ ሙሴ ቄስያ ኤልኣዛራ፥ ኔዌ ናኣ ኢያሳነ እስራኤልያ ዛራቱ ካፓቱዋ ኡንቱንቱዋ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ሙሴ ኡንቱንታ ሀዋዳን ያጌዳ፤ “ጋዳ ዛራቱነ ሮቤላ ዛራቱ ኡባይ ኦላ ሚሻ ዳንጪደ፥ መꬍና ጎዳ ስንꬃን ህንተናና ዮርዳኖሳ ሻፋ ፕኖፐነ ህንተ ሄ ቢታ ጾኖፐ፥ ሄዋፐ ጉይያን፥ ጋላኣደ ቢታ ህንተ ኡንቱንታ ላትስተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ሽን ኡንቱንቱ ኦላ ሚሻ ዳንጪደ፥ ህንተናና ፕነናን እጾፐ፥ ኡንቱንቱ ካናነ ቢታ ህንተናና ላትኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ጋዳ ዛራቱነ ሮቤላ ዛራቱ ዛሪደ፥ “ኑን ነ ቆማቱ መꬍና ጎዳይ ጌዳዋ ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ኦላ ሚሻ ዳንጪደ፥ መꬍና ጎዳ ስንꬃን ኑን ካናነ ቢታ ገላናዉ ፕናና፤ ሽን ኑን ላትያ ላታይ ዮርዳኖሳፐ ሀፍንꬃ ባጋና ግዳናዋ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ሄዋ ድራዉ፥ ሙሴ ጋዳ ዛረቶ፥ ሮቤላ ዛረቶነ ዮሴፎ ናኣ ምናሰ ዛራቱዋፐ ባጋዉ አሞረቱ ካትያ ስሆና ካዉተꬃነ ባሳነ ካትያ ኦጋ ካዉተꬃ፥ ኡንቱንቱ ዩሹዋን ደእያ ካታማቱዋና እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ጋዳ ዛራቱ ድቦና፥ አጻሮታ፥ አሮኤራ ");
INSERT INTO dwrENT_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","አጽሮት-ሾፋና፥ ያእዜራ፥ ዮግባሀ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ቤት-ኒምራነ ቤት-ሃራና ጌተትያ ግምቢያን ድረቴዳ ካታማቱዋ ዛረꬂደ ኬጼድኖ። ባረ ዶርሳቶካ ኡንቱንቱ ባሉዋ ጊግሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ሮቤላ ዛራቱካ ሀሰቦና፥ ኤልኣላ፥ ቅርያታይማነ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ናባ፥ ባኣል-ማኦናነ (ሄ ካታማቱዋፐ እቱ እቱ ሱንꬃ ላሜድኖ) ሲብማ ጌተትያ ካታማቱዋ ዛረꬅ ኬጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ምናሰ ናኣ ማክራ ያራቱ ጋላኣደ ቢደ፥ ኦላይ ኦይቂደ፥ ያን ደእያ አሞረቱዋ የደርሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ሄዋ ድራዉ፥ ምናሰ ናኣ ማክራ ያራቶ ሙሴ ጋላኣደ ቢታ እምና፥ ኡንቱንቱ ያን ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ምናሰ ዛረ ግድያ ያኢር ቢደ፥ ኡንቱንቱ ኦላይ ኦይቂደ፥ ሀቦት-ያኢራ ካታማቱዋ ያጊደ ሱንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ኖባህ ቢደ፥ ቃናታ ካታማነ አ ዩሹዋን ደእያ ሄራቱዋ ኦላን ኦይቂደ፥ ባረ ሱንꬃን ኖባሀ ጊደ ጼሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","እስራኤላቱ ሙሴነ አሮን ካለꬅና፥ ባረንቱ ጩጉዋን ጩጉዋን ግብጼፐ ከሴዳ ዎደ፥ ያቲደ ሀመቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","መꬍና ጎዳይ አዛዝና፥ ኡንቱንቱ ባና ቡሳ ዶሜዳ ሳኣ ሙሴ ጻፌዳ፤ ኡንቱንቱ ቡሳ ማራይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ኮይሮ አግናዉ ታማነ እቼሸንꬆ ጋላስ፥ ፓስጋ ቦንችያ ጋላሳፐ ካልያ ጋላስ ደንዲደ፥ ግብጼ አሳይ ኡባይ ጼልሽን፥ ያየናን ራምሳፐ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ሄ ዎደ ግብጼ አሳይ መꬍና ጎዳይ ዎꬌዳ ባረንቱ ባይራ ናናቱዋ ሞጊኖ። ሀዋዳን ኦꬂደ፥ መꬍና ጎዳይ ኡንቱንቱ ጾሳቱዋ ቦላ ፕርዳ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","እስራኤላቱ ራምሳፐ ደንዲደ፥ ሱኮታ ግያ ሳኣን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ሱኮታፐ ደንዲደ፥ መላ ቢታ ጼራን ደእያ ኤታማን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ኤታማፐ ደንዲደ፥ ባኣል-ጻፎናፐ አዋይ ዶልያ ባጋና ደእያ ፕሃህሮታ ስሚደ፥ ምግዶላ ማታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ፕሃህሮታፐ ደንዲደ፥ ዞኦ አባ ፕኒደ፥ መላ ቢታ ቤድኖ። ኤታማ መላ ቢታን ሄዙ ጋላሳ ኦግያ ሀመቲደ፥ ማራን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ማራፐ ደንዲደ፥ ታማነ ላኡ ፑልቶቱነ ላፑን ታሙ ዛምባቱ ደእያ ኤሊማ ቢደ፥ ያን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ኤሊማፐ ደንዲደ፥ ዞኦ አባ ማታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ዞኦ አባ ላንቂያፐ ደንዲደ፥ ሲና መላ ቢታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ሲና መላ ቢታፐ ደንዲደ፥ ዶፍቃን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ዶፍቃፐ ደንዲደ፥ አሉሻን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","አሉሻፐ ደንዲደ፥ ራፊድማን ዱንካኔድኖ። ያን አሳዉ ኡሻናዉ ሃꬃይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ራፊድማፐ ደንዲደ፥ ሲና መላ ቢታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ሲና መላ ቢታፐ ደንዲደ፥ ክብሮት-ሀታባር (አሙዋ ዱፉዋ ግያ ሳን ዱንካኔድኖ)። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ክብሮት-ሀታባር (አሙዋ ዱፉዋ) ግያ ሳፐ ደንዲደ፥ ሀጸሮታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ሀጸሮታፐ ደንዲደ፥ ሪትማን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ሪትማፐ ደንዲደ፥ ርሞን-ፐሬዛን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ርሞን-ፐሬዛፐ ደንዲደ፥ ሊብናን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ሊብናፐ ደንዲደ፥ ሪሳን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ሪሳፐ ደንዲደ፥ ቃሄላታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ቃሄላታፐ ደንዲደ፥ ሸፋራ ደርያን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ሸፋራ ደርያፐ ደንዲደ፥ ሀራዳን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ሀራዳፐ ደንዲደ፥ ማቅሄሎታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ማቅሄሎታፐ ደንዲደ፥ ታሃታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ታሃታፐ ደንዲደ፥ ታራን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ታራፐ ደንዲደ፥ ሚትቃን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ሚትቃፐ ደንዲደ፥ ሀሽሞናን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ሀሽሞናፐ ደንዲደ፥ ሞሰሮታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ሞሰሮታፐ ደንዲደ፥ በነ-ያእቃናን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","በነ-ያእቃናፐ ደንዲደ፥ ሆር-ሀግድጋዳን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ሆር-ሀግድጋዳፐ ደንዲደ፥ ዮጽባታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ዮጽባታፐ ደንዲደ፥ አብሮናን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","አብሮናፐ ደንዲደ፥ ኤጽዮን-ጋብራን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ኤጽዮን-ጋብራፐ ደንዲደ፥ ጺና መላ ቢታን ደእያ ቃዴሳን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ቃዴሳፐ ደንዲደ፥ ኤዶማ ቢታ ዛዋን ደእያ ሆራ ደርያን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ቄሲ አሮን መꬍና ጎዳይ አዛዝና፥ ሆራ ደርያ ሁጲያ ከሴዳ፤ እስራኤላቱ ግብጼ ጋድያፐ ከሴዳ ኦይታሙንꬃ ላይꬃን፥ እቼሸንꬆ አግናን፥ አግናዉ ኮይሮ ጋላሳን ያን ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","አሮን ሆራ ደርያ ሁጲያን ሀይቂያ ዎደ፥ አ ላይꬃይ ጼታነ ላታማነ ሄዛ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ኔጌባ መላ ቢታን፥ ካናነን ደእያ አራዳ ግያሳ ካቲ እስራኤልያ አሳ ዩሳ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","እስራኤላቱ ሆራ ደርያፐ ደንዲደ፥ ጻልሞናን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ጻልሞናፐ ደንዲደ፥ ፑኖናን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ፑኖናፐ ደንዲደ፥ ኦቦታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ኦቦታፐ ደንዲደ፥ ሞኣባ ቢታ ዛዋን ደእያ እየ አባርማን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","እየ አባርማፐ ደንዲደ፥ ድቦና-ጋዳን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ድቦና-ጋዳፐ ደንዲደ፥ አልሞና-ድብላታይማን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","አልሞና-ድብላታይማፐ ደንዲደ፥ ናቦ ደርያ ማታን አባርማ ደረቱዋን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","አባርማ ደረቱዋፐ ደንዲደ፥ ያርኮፐ ሄፍንꬃና፥ ዮርዳኖሳ ሻፋ ማታን ደእያ ሞኣባ ደምባን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ዮርዳኖሳ ሻፋ ማታን ደእያ ሞኣባ ደምባን፥ ቤት-ያሽሞታፐነ አቤል-ሺጽማ ግዱዋን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","እያርኮ ሄፍንꬃና፥ ዮርዳኖሳ ሻፋ ማታን ደእያ ሞኣባ ደምባን መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“እስራኤላቱዋ ኔን ያጋ፤ ‘ዮርዳኖሳ ሻፋ ፕኒደ፥ ካናነ ቢታ ህንተ ገልያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ሄ ጋድያን ደእያ አሳ ኡባ ህንተ ስንꬃፐ የደርስተ፤ ሹቻፐ ማሰቴዳ ኡንቱንቱ ምስለቱዋ ኡባነ ሲልሲደ መꬌዳ ኤቃቱዋ ኡባ ꬋይስተ። ኡንቱንቱ ጎይንያ ꬎቃ ሳኣ ኡባካ ላልተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ታን ህንተንቶ ሄ ቢታ ላታዉ እሜዳ ድራዉ፥ ሄ ቢታ ላቲደ፥ አን ደእተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ህንተ ዛርያን ዛርያን ሳማ ከሲደ፥ ቢታ ሻክተ። ፓይዱዋን ጮራትያ ዛረቶ ዳሮ ላታ እምተ፤ ፓይዱዋን ጉጽያ ዛረቶ ጉꬃ ላታ እምተ። ሳማን ኡንቱንታ ጋኬዳ ሀቃዌነ ኡንቱንቱዋ ግዳናዋ። ቢታ ህንተ ማይዛ አዎቱዋ ዛርያን ዛርያን ግሽ አኪታ። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘ሽን ሄ ጋድያን ደእያ አሳ ህንተ የደርሰናን አጎፐ፥ ህንተ አሼዳዋንቱ ህንተንቶ ህንተ አይፍያዉ ፕንጮ፥ ህንተ ምይያዉ አጉንꬃ ግዳና፤ ህንተ ደአና ጋድያን ኡንቱንቱ ህንተና ዋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ህንተ ኡንቱንታ የደርሰናን አጎፐ፥ ኡንቱንቱ ቦላ ታን ኦꬃናዉ ቆፔዳዋ ህንተ ቦላ ኦꬃና’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ኔን እስራኤላቱዋ ሀዋዳን ያጋደ አዛዛ፤ ‘ላታዳን ህንተና ጋክያ ካናነ ቢታ ዛዋይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ገድሳ ባጋና ህንተ ዛዋይ ጺና መላ ቢታነ ኤዶማ ዛዋ ግዳናዋ። አዋይ ዶልያ ባጋና ህንተ ገድሳ ዛዋይ ማጽንያ አባ ገድሳፐ ዶሜ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","አቅራቢማ ፑደꬃና ገድሳ ባጋና ስሚደ፥ ጺና መላ ቢታ አꬊደ፥ ቃዴሳ-ባርነ ገድሳ ጋኬ፤ ሄዋፐ ሀዳር-አዳራ አꬊደ፥ አጽሞና ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","አጽሞናፐ ግብጼ ሻፋኮ ስሚደ፥ ሜድተራነ አባ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“ ‘አዋይ ዉልያ ባጋና ህንተ ዛዋይ ሜድተራነ አባ ጋጻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“ ‘ሁጲሳ ባጋና ህንተ ዛዋይ ሜድተራነ አባፐ ሆራ ደርያ ስት ኦꬅ ቢደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ሆራ ደርያፐ ሌቦ-ሀማታ ፕኑዋ ጋካናሳ፤ ሄዋፐ ጻዳዳን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ቃይ ዝፍሮነፐ ቢደ፥ ሀጻር-ኤናና ጋኬ። ሁጲሳ ባጋና ህንተ ዛዋይ ሀዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“ ‘አዋይ ዶልያ ባጋና ህንተ ዛዋይ ሀጻር-ኤናናፐ ሻፋማ ጋካናዉ ስት ኦꬅ ቢደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ሻፋማፐ ቢደ፥ አይናፐ አዋይ ዶልያ ባጋና ደእያ ርብላ ዎꬊደ፥ ጋሊላ አባፐ አዋይ ዶልያ ባጋና ደእያ ደርያ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ሄዋፐ ዱገ ዮርዳኖሳ ሻፋ ዎꬍ ዛዋቲደ፥ ማጽንያ አባ ጋኬ። ህንተ ቢታ ዛዋይ ኡባ ባጋናካ ሀዋ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ሙሴ እስራኤላቱዋ ሀዋዳን ያጊደ አዛዜዳ፤ “ኤጻ የጊደ፥ ህንተ ላታና ማላ፥ ኡዱፑን ዛረቶነ ባጋ ዛረቶ ሄ ቢታይ እመታናዳን መꬍና ጎዳይ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","15","አያዉ ጎፐ፥ ሮቤላ ዛራቱ ጋዳ ዛራቱነ፥ ምናሰ ዛራቱዋፐ ባጋይ ባረንቱ ላታ እያርኮ ሄፍንꬃን ዮርዳኖሳ ሻፋፐ አዋይ ዶልያ ባጋና አኬድኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ሄ ቢታ ህንተንቶ ላታ ኦꬂደ፥ ሻክ እማና አሳቱ ሱንꬃይ ሀዋ፤ ቄስያ ኤልኣዛራነ ኔዌ ናኣ ኢያሳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ቃይ ቢታ ሻካናዉ ማዳና ማላ፥ ዛረ ኡባፐ እት እት ካፑዋ ሱንꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ኡንቱንቱ ሱንꬃይ ሀዋፐ ካሊደ ደእያዋ። ዛርያ ካፑዋ ይሁዳ ይፉነ ናኣ ካሌባ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ስሞና አምሁዳ ናኣ ሻሉምኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ቢንያማ ክስሎና ናኣ ኤልዳዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ዳና ዮግላ ናኣ ቡቃ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ዮሴፎ ናኣ ምናሰ ኤፎዳ ናኣ ሀንኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ዮሴፎ ናኣ ኤፍሬማ ሽፍጻና ናኣ ቃሙኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ዛብሎና ፓርናካ ናኣ ኤልጻፋና፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ይሳኮራ አዛና ናኣ ፓልጽኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","አሴራ ሻሎማ ናኣ አህሁዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ንፍታሌማ አምሁዳ ናኣ ፓዳህኤላ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ካናነ ጋድያን እስራኤላቶ ላታ ሻክ እማና ማላ፥ መꬍና ጎዳይ አዛዜዳ አሳቱ ሀዋንታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","እያርኮ ሄፍንꬃና፥ ዮርዳኖሳ ሻፋ ማታን ደእያ ሞኣባ ደምባን፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“እስራኤላቱ ባረንቱ ላታፐ ሌዋቱዋ ደአና ካታማቱዋነ ኡንቱንቱ ዩሹዋን ደእያ ሄንꬃ ጋደቱዋ እማና ማላ፥ ኔን ኡንቱንታ አዛዛ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ሄ ካታማቱዋን ኡንቱንቱ ደእኖ፤ ሄንꬃ ጋደቱ ኡንቱንቱ ሚዛሳ፥ ኡንቱንቱ ዶርሳሳነ ኡንቱንቱ ሀራ መህያ ኡባሳ ግድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ህንተ ሌዋቶ እማና ካታማ ዩሹዋን ደእያ ሄንꬃ ጋደቱ ካታማ ግምቢያ ድርሳፐ ካረኮ እት ሻአ ዋꬋ ግድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ካታማፐ ካረና፥ አዋይ ዶልያ ባጋና ላኡ ሻአ ዋꬋ፥ ገድሳ ባጋና ላኡ ሻአ ዋꬋ፥ አዋይ ዉልያ ባጋና ላኡ ሻአ ዋꬋነ ሁጲሳ ባጋና ላኡ ሻአ ዋꬋ ልክተ፤ ያቶፐ ካታማይ ግዶ ልክያን ደአና። ሌዋቱ ሄ ሄራ ባረንቱ ካታማዉ ሄንꬃ ጋደ ኦꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“ሌዋቶ ህንተ እማና ካታማቱ፥ አሳ ዎꬌዳ ኡራይ ባቃቲደ አትያ ኡሱፑን ካታማቱዋ፤ ሄዋንቱ ቦላ ጉጂደ፥ ኦይታማነ ላኡ ሀራ ካታማቱዋ ኡንቱንቶ እምተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ሌዋቶ ህንተ ኡባና ኦይታማነ ሆስፑን ካታማቱዋ ኡንቱንቱ ሄንꬃ ጋደቱዋና እትፐ እምተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","እስራኤላቱዋ ላታፐ ሌዋቶ ህንተ እማና ካታማቱ እት እት ዛሪ ላቴዳዋ ኬሻ ግዳናዉ ኮሼ፤ ጮራ አሳይ ደእያ ዛርያፐ ጮራ ካታማቱዋ አኪተ፤ ሽን ፓይዱዋን ጉꬃ አሳይ ደእያ ዛርያፐ ጉꬃ ካታማቱዋ አኪተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ኔን እስራኤልያ አሳ ሀዋዳን ያጋ፤ ‘ዮርዳኖሳ ሻፋ ፕኒደ፥ ካናነ ቢታ ህንተ ገልያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ኤረናን አሳ ዎꬌዳ ኡራይ ባቃት ቢደ አታና ማላ፥ ካታማቱዋ ህንተንቶ ዶርተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ኤረናን አሳ ዎꬌዳዌ ሺቁዋ ስንꬃ ሙራናዉ ኤቃና ጋካናዉ፥ ሱꬃ አችያዌ አ ዎና ማላ፥ ሄ ካታማቱ ባቃት አትያሳ ግድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ሀ ህንተ እምያ ኡሱፑን ካታማቱ ህንተንቶ ባቃት አትያ ካታማቱዋ ግድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ዮርዳኖሳ ሻፋፐ ሀፍንꬃ ባጋና ሄዙ ካታማነ ካናነ ጋድያን ሄዙ ካታማቱዋ ህንተ ባቃት አታናዉ እምተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ሀ ኡሱፑን ካታማቱ ኤረናን አሳ ዎꬌዳ እስራኤላቱ፥ ሀራ ጋደ አሳቱነ ኡንቱንቱ ግዶን ደእያ በተቱ ባቃቲደ አትያሳ ግድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘እት አሳይ እት አሳ ብራታ ሚሻን ሾጭና፥ ሄ ኡራይ ሀይቆፐ፥ ሄዌ ሸምፑዋ ዎꬌዳዋ፤ ሸምፑዋ ዎꬌዳዌ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ቃይ ዎꬋና ዳንዳይያ ሹቻ ባረ ኩሽያን ኦይቄዳ አሳይ እት አሳ ሄ ሹቻን ጫድና፥ ሄ ኡራይ ሀይቆፐ፥ ሄዌ ሸምፑዋ ዎꬌዳዋ፤ ሸምፑዋ ዎꬌዳዌ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","ቃይካ ዎꬋና ዳንዳይያ ምꬃ ባረ ኩሽያን ኦይቄዳ አሳይ እት አሳ ሄ ምꬃን ሾጭና፥ ሄ ኡራይ ሀይቆፐ፥ ሄዌ ሸምፑዋ ዎꬌዳዋ፤ ሸምፑዋ ዎꬌዳዌ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ሱꬃ አችያዌ ሄ ሸምፑዋ ዎꬌዳዋ ደሞፐ ዎꬎ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“ ‘እት አሳይ እት አሳ ሞርኪደ ጫድና፥ ዎይ ዙጊድ እትባ አ ቦላ ኦልና፥ ሄ ኡራይ ሀይቆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ዎይ ሞርኪደ ባረ ኩሽያን ቦክስና፥ ሄ ኡራይ ሀይቆፐ፥ እ ሸምፑዋ ዎꬌዳዋ፤ ሸምፑዋ ዎꬌዳዌ ሀይቆ። ሱꬃ አችያዌ ሸምፑዋ ዎꬌዳዋ ደሞፐ ዎꬎ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘ሽን ሞርከተꬃይ ባይናን፥ እት አሳይ እት አሳ አኬከናን ሱጎፐ፥ ዎይ ዙጊድ ናገናን እትባ አ ቦላ ኦሎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ዎይ አ ዎꬋና ዳንዳይያ ሹቻ እ በኤናን አ ቦላ የጎፐነ ሄ ኡራይ ሀይቆፐ፥ ሄዌ አ ሞርከ ግደና ድራዉነ አ ቆሀናዉ ሀልችቤና ድራዉ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ያአይ ኤረናን ዎꬌዳዋፐነ ሱꬃ አችያዋፐ ግዱዋን ሀ ዎጋቱዋዳን ፕርዶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ኤረናን ዎꬌዳዋ ሱꬃ አችያዋ ኩሽያፐ ያአይ አሺደ፥ እ ባቃቲደ አትያ ካታማ ዛሮ። ጌሻ ዛይትያን ኦከቲደ፥ ቄሲ ኡባቱ ካፑ ሀይቃና ጋካናዉ፥ እ ያን ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘ሽን ኤረናን ዎꬌዳዌ ባቃቲደ አትያ ካታማ ዛዋፐ ካረ ከስያዋ ግዶፐነ፥ ");
INSERT INTO dwrENT_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ባቃት አትያ ካታማፐ ካረና ሱꬃ አችያዌ አ ደሚደ ዎꬎፐ፥ እ ዎꬌዳዎ ኦሸተና። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","አያዉ ጎፐ፥ ቄሲ ኡባቱ ካፑ ሀይቃና ጋካናዉ፥ ሄ ኤረናን ዎꬌዳዌ ባረ ባቃቴዳ ካታማን ኡታናዋሽን አጌዳ። ሽን ቄሰ ኡባቱ ካፑ ሀይቄዳዋፐ ጉይያን፥ ኤረናን ዎꬌዳዌ ባረ ላታ ጋደ ስማናዉ ዳንዳዬ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘ህንተዉነ ብሮ የለታና የለታዉ፥ ህንተ ደኢያሳ ኡባን ሀዌ ህገ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘አሳ ዎꬌዳ ኦንነ ሸምፑዋ እ ዎꬌዳዋዳን ማርካቱ ማርካትና ሀይቆ፤ ሽን እት አሳ ጻላላይ ማርካትና፥ አይ አሳይነ ሀይቆፖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ሸምፑዋ ዎꬌዳ ድራዉ ሀይቃናዉ በስያ አሳ ፓጻ አሻናዉ አጫ አኮፕተ፤ እ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","አትያ ካታማ ባቃቴዳ ኦፐነ ቄሰ ኡባቱ ካፑ ሀይቃናፐ ካሰ፥ እ ጉየ ስሚደ፥ ባረ ጋድያን ደአናዳን ኦꬃናዉ አጫ አኮፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘ሄዋዳን ኦꬂደ፥ ህንተ ደእያ ቢታ ቱንሶፕተ። አያዉ ጎፐ፥ ሱꬃ ጉስያዌ ቢታ ቱንሴ፤ ሱꬃ ጉሴዳዋ ሱꬃናፐ አትና፥ ቢታ አቶ ጊሳናዉ ሀራ ኦግያን ዳንዳየተና ");
INSERT INTO dwrENT_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ታን፥ መꬍና ጎዳይ፥ እስራኤልያ አሳ ግዱዋን ደእያ ድራዉ፥ ህንተ ደእያ ቢታ፥ ታንካ ደእያ ቢታ ቱንሶፕተ’ ያጋደ ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ዮሴፎ ዛራቱዋፐ፥ ምናሰ ናኣ ማኪራ ናኣ ጋላኣደ ያራቱዋ ካፓቱ ሙሴኮነ እስራኤላቱዋ ያራቱዋ ካፓቱዋኮ ዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","ኡንቱንቱ ዪደ፥ “ኑ ጎዳዉ፥ እስራኤልያ አሳዉ ቢታ ኤጻን ሻካደ እማና ማላ፥ መꬍና ጎዳይ ኔና አዛዜዳ፤ ቃይ ጾሳይ ኑ እሻ ጻሎፍሃዳ ላታ አ ማጫ ናናዉ ኔን እማና ማላ፥ ኔና አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ሌምሶ ኡንቱንቱ ሀራ ዛረ ግድያ እስራኤልያ አሳ ገሎፐ፥ ኡንቱንቱ ላታይ ኑ አዎቱዋ ላታፐ አከቲደ፥ ኡንቱንቱ ገልያ ዛርያዉ ጉጀቴ። ሄዋ ድራዉ፥ ኑዉ ኤጻን እመቴዳ ላታይ ፓጫና። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ቃይ እስራኤላቶ እሻታማንꬆ ላይꬃ ባላይ ጋክያ ዎደ፥ ኡንቱንቱ ላታይ ኡንቱንቱ ገልያ አሳ ዛርያዉ ጉጀቴ፤ ኡንቱንቱ ላታይ ኑ አዎቱዋ ዛርያ ላታፐ ፓጫና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ሄዋፐ ጉይያን፥ መꬍና ጎዳ ቃላዳን፥ ሙሴ እስራኤላቱዋ ሀዋዳን ያጊደ አዛዜዳ፤ “ዮሴፎ ዛራቱ ግያዌ ልከ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","መꬍና ጎዳይ ጻሎፍሃዳ ማጫ ናናቱዋባ አዛዜዳዌ ሀዋ፤ ኡንቱንቱ ባረንቱ ዶሴዳ አስና ገላናዉ ዳንዳዪኖ፤ ሽን ባረንቱ አዉዋ ዛርያፐ ግዳናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","እስራኤላቱዋ ላታይ እት ዛርያፐ ሀራ ዛርያዉ አꬎፖ፤ እስራኤልያ ኡባይ ባረ ማይዛ አዎቱዋ ዛሪ ላቴዳ ቢታ ምንሲደ ኦይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","እስራኤልያ አሳ ግዶን አይ ዛረፐ ግድናካ፥ ቢታ ላትያ ማጫ ናእ ኡባይ፥ እስራኤሊ ኡባይ ባረ ማይዛ አዎቱዋ ላታ ላታና ማላ፥ አ ባረ አዉዋ ዛረ ግድያ አሳ ገሉ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ሄዋዳን ሀኒደ፥ ላታይ እት ዛርያፐ ሀራ ዛርያዉ ሙለካ አናን ደአና። ሄዋ ድራዉ፥ እስራኤልያ ኡባይ ባረ ማይዛ አዎቱዋ ዛሪ ላቴዳ ቢታ ምንሲደ ኦይቆ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ጻሎፍሃዳ ማጫ ናናይ መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን ኦꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ጻሎፍሃዳ ማጫ ናናይ፥ ማህሎ፥ ትርጾ፥ ሆግሎ፥ ምልኮነ ኖኦ ጌተትያዋንቱ፥ ባረንቱ አዉዋ እሻንቱ ናናቱዋ ገሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ኡንቱንቱ ዮሴፎ ናኣ ምናሰ ናናቱ ዛርያ ግዶን አስና ገሌድኖ፤ ኡንቱንቱ ላታይ ኡንቱንቱ አዉዋ ዛርያዉነ ያራዉ አቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ያርኮፐ ሄፍንꬃና፥ ዮርዳኖሳ ሻፋ ማታን ደእያ ሞኣባ ደምባን ሙሴ ባጋና መꬍና ጎዳይ እስራኤልያ አሳ አዛዜዳ ህገቱነ ዎጋቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ሀ ማጻፋን ጻፈቴዳ ቃላ ኡባይ ዮርዳኖሳ ሻፋፐ ሄፍንꬃ አዋይ ዶልያ ባጋና ደእያ መላ ቢታን ኡንቱንቱ ደእሽን፥ ሙሴ እስራኤልያ አሳዉ ኦዴዳ ቃላ። ሙሴ ሀ ቃላ ኡንቱንቶ ኦድያ ዎደ፥ ኡንቱንቱ ሱፋ ጌተትያ ሳኣን ስንꬃ ባጋና፥ ፓራና ካታማዉ እት ባጋናነ ሄዋዳንካ ቃይ ቶፌላ፥ ላባና፥ ሀጸሮታነ ዲዛሃባ ጌተትያ ካታማቱዋ ግዱዋን ደእያ ዮርዳኖሳ ዛንጋራን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ኤዶማ ደርያ ኦግያና ቦፐ፥ ሲና ደርያፐ ቃዴሳ-ባርነ ጋካናዉ ገድያን ታማነ እት ጋላሳ ኦገ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ግብጼፐ ኡንቱንቱ ከሴዳ ኦይታማንꬃ ላይꬃን፥ ታማነ እተንꬃ አግናን፥ አግናዉ ኮይሮ ጋላሳን፥ ሙሴ መꬍና ጎዳይ ኡንቱንቱዋ አ አዛዜዳዋ ኡባ እስራኤላቶ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ሄዌ ሀሰቦና ካታማን ኡቲደ ካተቴዳ አሞረቱ ካዉዋ ስሆናነ፥ አስታሮታንነ ኤድራአን ኡቲደ ካተቴዳ ባሳነ ካትያ ኦጋ፥ ሙሴ ጾኔዳዋፐ ጉይያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","አሳይ ዮርዳኖሳፐ አዋይ ዶልያ ባጋና ሞኣበን ደእሽን፥ ሙሴ ሀ ህግያ ሀዋዳን ያጊደ ቆንጭስያዋ ዶሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“ኑን ሲና ደርያን ደእሽን፥ መꬍና ጎዳይ ኑ ጾሳይ ኑና ሀዋዳን ያጌዳ፤ ‘ህንተ ሀ ደርያ ቦላን ሎይꬅ ጋምኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ዱንካንያ ኮሊደ ደንድተ፤ ደረትያ አሞረቱ ቢታነ አራባን ደእያ ኡንቱንቱ ሾሮ ቢታ ኡባ ቢተ፤ ሄዌካ ዮርዳኖሳ ዛንጋራ፥ ደረትያሳነ ባርጎትያ ቢታቱዋኮ፥ ገድሳ ባጋዉነ ሜድተራነ አባ ጋጻዉ አꬍተ። ካናነ ጋድያኮ ቢተ፤ ሊባኖሳ ደረቱዋ አꬊደ፥ ኤፍራጺሳ ሻፋ ጋካናዉ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","በእተ፥ ታን ህንተንቶ ሀ ቢታ እማድ። ቢደ ህንተ አዋቶ፥ አብራሃማዉ፥ ይሳቃዉ፥ ያቆባዉነ፥ ኡንቱንቱፐ ጉይያን፥ ኡንቱንቱ ዛርያዉ እማናዉ መꬍና ጎዳይ ጫቄዳ ቢታ ላትተ’ ያጌዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ቃይካ ሙሴ አሳዉ ሀዋዳን ያጌዳ፤ “ሄ ዎደ ታን ህንተንቶ ሀዋዳን ያጋደ ኦዳድ፤ ‘ታን ታረካ ህንተና ቶካናዉ ዳንዳይከ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ፓይዱዋ ሳሉዋ ጾልንትያዳን ዳርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","መꬍና ጎዳይ ህንተ አዎቱዋ ጾሳይ፥ ህንተና ሀዋፐ ሻአ ገደ ጉጂደ ዳርሶነ እ ጌዳዋዳን ህንተና አንጆ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ሽን ህንተ መቱዋ፥ ህንተ ፓሉማነ ህንተ ኦሻ ኡባ ታን ታረካ ቶካናዉ ዋና ዳንዳያይታ? ");
INSERT INTO dwrENT_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ህንተ ዛርያፐ ዛርያፐ አꬌዳ ኤራንቻ፥ አኬካንቻነ ኦሱዋ ሜዚ ደእያ አሳቱዋ ዶርተ፤ ታን ህንተ ቦላ ኡንቱንቱ ካፑዋ ሱንꬃና’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","“ህንተካ ታና፥ ‘ኑን ኦꬃናዳን ኔን ጌዳዌ ሎአ’ ያጌድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ሄዋ ድራዉ፥ ታን ህንተ ዛርያፐ ዛርያፐ አꬌዳ ኤራንቻነ ኦሱዋ ሜዚ ደእያ አሳቱዋ አካድ፤ ሻላቃ፥ ጼቱዋ ካፑዋ፥ እሻታሙዋ ካፑዋ፥ ታሙዋ ካፑዋነ ሞድያዋንታ ኦꬃደ ህንተ ዛርያን ዛርያን ህንተ ቦላን ሱንꬃድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“ያታደ ታን ኡንቱንታ፥ ‘ህንተ እሻንቱ ግዱዋን ደእያ ሞቱዋ ስስተ፤ ሄ ሞቱ እት እስራኤልያ አሳፐነ አ እሻፐ ግዱዋን ዎይ እስራኤልያ አሳፐነ ሀራ ጋደ አሳፐ ግዱዋን ደእያዋ ግዶፐካ፥ ስሲደ ጽሉዋ ፕርድተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ህንተ ፕርዳን እት ባጋ ማዶፕተ፤ ዎልቃማዋ ስስያዋዳንካ፥ ጉꬃዋካ ሄዋዳን ስስተ፤ አሳ ሶምኦ ያዮፕተ፤ አያዉ ጎፐ፥ ፕርዳይ ጾሳዋ። ቃይ ህንተንቶ ዳሮ ዴጾ ግዴዳ ሞቱዋ ታኮ አህተ፤ ሄዋ ታን ፕርዳና’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ቃይ ህንተካ ኦꬃናዋ ኡባ ታን ሄ ዎደ ህንተና አዛዛድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“ሄዋፐ ጉይያን፥ ኑን ሲና ደርያፐ ደንዴዶ፤ መꬍና ጎዳይ ኑ ጾሳይ ኑና አዛዜዳዋዳን፥ ደረትያ አሞረቱ ቢታ ብያ ኦግያን ደእያ ሄ ህንተ በኤዳ ግታነ ያሽያ መላ ቢታ አꬊደ፥ ቃዴሳ-ባርነ ጋኬዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ሄ ዎደ ታን ህንተንቶ ሀዋዳን ያጋድ፤ ‘መꬍና ጎዳ ኑ ጾሳይ ኑና ላትስያ ደረትያ አሞረቱ ቢታ ሄኮ ሀእ ጋኬድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","በእተ፥ መꬍና ጎዳይ ህንተ ጾሳይ ሀ ቢታ ህንተንቶ እሜዳ። መꬍና ጎዳይ ህንተ አዎቱዋ ጾሳይ ህንተንቶ ኦዴዳዋዳን ከሲደ፥ ሀ ቢታ ላትተ፤ ያዮፕተ፤ ህዶታ አጎፕተ’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“ህንተ ኡባይ ታኮ ዪደ ታና፥ ‘ሄ ቢታ ዎቺደ፥ ኑን ባናዉ በስያ ኦግያባነ፥ ኑን ገላና ካታማቱዋ ኦዱዋ ኑዉ አህያ አሳቱዋ ኑፐ ስንꬃዉ የዶይተ’ ያጌድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“ሄ ቆፋይ ታዉ ሎአ ማላቴዳ፤ ያትና፥ ህንተፐ ታማነ ላኡ አሳ፥ ዛርያፐ ዛርያፐ እት አሳ ዶራድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ኡንቱንቱ ቤድኖ፤ ሄ ደረትያ ቢታ ፑደ ከሴድኖ፤ ቃይ ኤሽኮላ ዛንጋራኮካ ቢደ፥ ቢታ ዎቼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ሄ ጋድያን ሞክያባፐ አማሬዳ አይፍያ ባረንቱ ኩሽያን ኦይቂደ፥ ኑኮ አክ ዬድኖ፤ ቃይ፥ ‘መꬍና ጎዳ ኑ ጾሳይ ኑዉ እምያ ቢታይ ሎአ’ ያግያ ኦዱዋካ አሂደ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“ሽን ህንተ መꬍና ጎዳ ህንተ ጾሳ አዛዞ ማካሊደ፥ ከሰናን እጼድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ህንተ ዱንካንያ ግዶን እቱ እቱዋና፥ ሀዋዳን ያጊደ ዙዙሜድታ፤ ‘መꬍና ጎዳይ ኑና እጼዳ ድራዉ፥ ꬋይሳናዉ አሞረ ቢታ አሳቱ ኩሽያን አꬂ እማናዉ፥ ግብጼ ጋድያፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ኑን ሀቃ ከሴቶ? ኑ እሻቱ “ሄ ጋድያን ደእያ አሳይ ኑፐ ዳሪኖነ አዱቂኖ። ካታማቱካ ግታነ ሳሉዋ ጋካናዉ ግምበቴዳዋንታ። ሄዋ ቦላካ ቃይ አናቀቱዋ ጌተትያ ዳሮ አዱሳ አሳቱዋ ያን በኤዶ” ያጊደ፥ ኑ ዎዛና እርጽሴድኖ ያጌድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“ ‘ሄዋፐ ጉይያን፥ ታን ሀዋዳን ያጋድ፤ ኡንቱንቶ ያዮፕተ ዎይ ሻባረቶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ህንተፐ ስንꬃና ብያ መꬍና ጎዳይ ህንተ ጾሳይ ካሰ ግብጼን ህንተ አይፍያ ስንꬃን እ ህንተንቶ ኦꬄዳዋዳን፥ ሀእካ ህንተንቶ እ ኦለታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ቃይ መላ ቢታን፥ ህንተ ሀ ሳኣ ጋካናዉ ዬዳ ኦገ ኡባን፥ አሳይ ባረ ናኣ ቶክያዋዳን፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ቶኬዳዋ በኤድታ’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","“ሀ ኡባ ታ ኦድንካ፥ ህንተ ዱንካናና ሳኣ በሳናዉነ ህንተ ባና ኦግያ በሳናዉ ቃማ ታማ ቱሳን፥ ጋላስ ሻርያ ቱሳን ህንተና ካለꬄዳ መꬍና ጎዳ፥ ህንተ ጾሳን፥ አማንበይክታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“መꬍና ጎዳይ ህንተ ሃሳያ ስሲደ ሀንቀቴዳ፤ ሀዋዳን ያጊደ ጫቄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘ታን ህንተ ማይዛ አዋቶ እማና ጋደ ጫቄዳ ሀ ሎኦ ቢታ፥ ሀ ኢታ የለታፐ እቱነ በኤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ሄ ቢታ በአናዌ ይፉነ ናኣ ካሌባ ጻላላ። እ የꬌዳ ቢታ አዉነ አ ዛርያዉ ታን እማና፤ አያዉ ጎፐ፥ እ ባረ ኩመንꬃ ዎዛናፐ መꬍና ጎዳ ካሌዳ’ ያጊደ ጫቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“ህንተ ጋሱዋን መꬍና ጎዳይ ታ ቦላካ ሀንቀቲደ፥ ሀዋዳን ያጌዳ፤ ሙሴ፥ ሀራይ አቶ ኔንካ ሄ ቢታ ገላካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ሽን ኔና ማድያዌ፥ ኔዌ ናአይ ኢያሱ ሄ ቢታ ገላና። እ እስራኤልያ አሳ ሄ ቢታ ላትሳናዉ ደእያ ድራዉ፥ ኔን አ ምንꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ቃይ ህንተ፥ ‘ኑ ናናይ ኦሞደታና’ ጌዳ ጉꬃቱነ ኢታ ሎይꬅ ሻክ ኤርቤና ህንተ ናናይ ሄ ቢታ ገላና። ታን ሄ ቢታ ኡንቱንቶ እማና፤ ኡንቱንቱካ አ ላታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ሽን ህንተና ግዶፐ፥ ህንተ ጉየ ስሚደ፥ ዞኦ አባ አፍያ ኦግያ ኦይቂደ፥ መላ ቢታ ቢተ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“ህንተ ዛሪደ ታዉ ሀዋዳን ያጌድታ፤ ‘ኑን መꬍና ጎዳ ቦላ ናጋራ ኦꬄዶ፤ ሀእ ኑን መꬍና ጎዳይ ኑ ጾሳይ አዛዜዳዋዳን፥ ከሲደ ኦለታና’ ያጌድታ። ህንተ ኡባይ ኦላ ሚሻ ግጼድታ፤ ቃይ ገዘ ቢታ ከሲደ ኦለታናዋካ ላፋባዳን ቆፔድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“ሽን መꬍና ጎዳይ ታና፥ ‘ታን ኡንቱንቱና ደኤና ድራዉ፥ ኡንቱንቱ ከሲደ ኦለተናዳን ኦዳ፤ ሄዌ ꬋዮፐ ኡንቱንቱ ሞርከቱ ኡንቱንታ ጾናና’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ታን ህንተንቶ ኦዳድ፤ ሽን ህንተ መꬍና ጎዳ አዛዞ ማካሌድታፐ አትና፥ ታን ኦዴዳዋ ስስበይክታ፤ ያቲደ ህንተ ኦቶሩዋን ገዘ ቢታ ከሴድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ያትና፥ ሄ ገዘ ጋድያን ደእያ አሞራቱ ህንተናና ኦላ ጋከቲደ፥ ህንተና ማꬃይ የደርስያዋዳን የደርሲደ፥ ሄ ኤዶማ ጋድያን ቢደ ሆርማ ጋካናዉ ሾጬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ህንተካ ጉየ ስሚደ፥ መꬍና ጎዳ ስንꬃን ዬኬድታ፤ ሽን ጾሳይ ህንተ ዬኩዋ ስስቤና ዎይ ሀይዝቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ያትን ቃዴሳን ሄ ህንተ ጋምኦ ኬሻ ጋላሳ ጋምኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“ሄዋፐ ጉይያን ኑን፥ መꬍና ጎዳይ ታና አዛዜዳዋዳን፥ ዞኦ አባ አፍያ ኦግያ ኦይቂደ፥ ጉየ ስሚደ፥ መላ ቢታ ቤዶ፤ ሄዋን መቶቲደ፥ ደረትያ ኤዶማ ጋድያን ዳሮ ጋላሳ ዩዬዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","“ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ታና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘ሀ ደረትያ ቢታ ዩሻይ ህንተንቶ ግዳናዋ፤ ጉየ ስሚደ፥ ሁጲሳ ባጋ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","አሳ ኔን ሀዋዳን ያጋደ አዛዛ፤ “ኤዶማን ደእያ ህንተ እሻቱዋ ግድያ ኤሳ ናናቱ ቢታና ህንተ አꬊታ። ኡንቱንቱ ህንተንቶ ያያና፤ ሽን ህንተ ሎይꬅ ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ታን ኡንቱንቱ ጋድያፐ ገዲ የꬍያ ሳ ኬሻነ ህንተንቶ እመና ድራዉ፥ ኡንቱንቱና ዋለቀቶፕተ፤ አያዉ ጎፐ፥ ታን ደረትያ ኤዶማ ቢታ ላታ ኦꬃደ ኤሳዉ እማ ድጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ህንተ ምያ ቁማነ ኡሽያ ሃꬃ፥ ኡንቱንቱፐ ሻሉዋን ሻምተ ያጋደ አዛዛ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","“ ‘መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ኦꬄዳዋ ኡባ አንጄዳ፤ ህንተ ሀ ዎልቃማ መላ ቢታን ሀመትያ ዎደ፥ ህንተና ናጌዳ። ሀ ኦይታሙ ላይꬃ ኡባን መꬍና ጎዳይ ህንተ ጾሳይ ህንተናና ደኤዳ። አያነ ህንተንቶ ፓጭስቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“ ‘ሄዋ ድራዉ፥ ኑን ኑ እሻቱዋ ግድያ ኤሳ ናናይ ደእያ ኤዶማ ቢታና አꬊደ ቤዶ። ቃይ ኤላታነ ኤጽዮን-ጋብራ ግያ ካታማቱዋፐ ደንዲደ፥ አራባኮ ጋꬅያ ኦግያ አጊደ፥ ሞኣባ መላ ቢታ አꬌዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","“ ‘መꬍና ጎዳይ ታና ሀዋዳን ያጌዳ፤ “ታን ኡንቱንቱ ጋድያፐ አያነ ህንተንቶ እመና ድራዉ፥ ሞኣባ አሳና ዋለቀቶፕተ ዎይ ኡንቱንታ ኦሎፕተ፤ አያዉ ጎፐ፥ ኤራ ካታማ ታን ላታ ኦꬃደ ሎጸ ዛረቶ እማ ድጋድ” ያጌዳ’ ያጌዳ።” ");
INSERT INTO dwrENT_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(ሄ ጋድያን ካሰ ምኖነ ጮራ ግዴዳ፥ ቃይ አናቀ ዛራቱዋዳን አዱሳ ግዴዳ ኤመታ ጌተትያ አሳቱ ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ኡንቱንቱ አናቀቱዋዳንካ ራፋየቱዋ ጌተቲኖ። ሽን ሞኣባ አሳይ ኡንቱንታ ኤመታ ጊደ ጼሴ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ሆራ ቢታ አሳይ ቃይ ካሰ ኤዶማን ደኤዳ፤ ሽን እስራኤላቱ ላታናዳን መꬍና ጎዳይ ኡንቱንቶ እሜዳ ጋድያን ኡንቱንቱ ኦꬄዳዋዳን፥ ኤሳ ዛራቱ ሆራታ ኡንቱንቱ ጋድያፐ ሾዴድኖ፤ ቃይ ባረንቱ ስንꬃፐ ኡንቱንታ ꬋይሲደ፥ ኡንቱንቱ ሳኣን ኡቴድኖ።) ");
INSERT INTO dwrENT_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","ሙሴ፥ “መꬍና ጎዳይ ኑና፥ ‘ሀእ ደንድተ፤ ዘሬዳ ሻፋ ፕንተ’ ያግና፥ ኑን ዘሬዳ ሻፋ ፕኔዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ኑን ቃዴሳ-ባርነፐ ደንዲደ፥ ዘሬዳ ሻፋ ፕናና ጋካናዉ ደእያ ዎዲ ሀታማነ ሆስፑን ላይꬃ፤ ሄ ዎደ መꬍና ጎዳይ ኡንቱንቶ ጫቄዳዋዳን፥ ኦላዉ ጋኬዳ ሄ የለታ አቱማዋንቱ ኡባይ ዉሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ዱንካኔዳ ሳፐ ኡንቱንቱ ኡባና ድምእ ጊደ ꬋያና ጋካናዉ፥ መꬍና ጎዳ ኩሺ ኡንቱንቱ ቦላ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“ኦላዉ ጋኬዳ አቱማ አሳይ ኡባይ ኡባና ꬋዬዳዋፐነ አሳ ግዶፐ ሀይቂዴ ዉሬዳዋፐ ጉይያን፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","መꬍና ጎዳይ ታና ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘ኤራ ኦግያና ሀች ህንተ ሞኣባ ቢታ አꬊታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ህንተ አሞና አሳቱ ቢታ ጋክያ ዎደ፥ ኡንቱንታ ቃሰረꬆፕተ ዎይ ኡንቱንቱና ዋላቀቶፕተ። አያዉ ጎፐ፥ አሞና አሳቱ ጋድያፐ አያነ ታን ህንተንቶ ላታ ኦꬃደ እምከ። ታን ሄ ቢታ ሎጸ ዛርያዉ ላታ ኦꬃደ እማ ድጋድ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","“(ሄ ቢታይ ካሰ ያን ደእያ አሳይ ጼሰትያ ሱንꬃን ራፋየቱዋ ቢታ ጌተቲደ ጼሰቴ። ቃይ አሞናቱ ኡንቱንታ ዛምዙሚም ጊደ ጼሲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ኡንቱንቱካ አናቀቱዋዳን አዱሳ፥ ምኖነ ጮራ ጋደ፤ ሽን መꬍና ጎዳይ ኡንቱንታ ꬋይስና፥ አሞናቱ ኡንቱንቱ ቢታ ላቲደ ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","መꬍና ጎዳይ ኤዶማን ደእያ ኤሳ ዛረቶ ኦꬄዳዋዳን፥ ኡንቱንቶካ ኦꬄዳ፤ ሄዌካ እ ሄ ጋድያን ደእያ ሆራታ ꬋይስና፥ ኤሳ ዛራቱ ኡንቱንቱ ቢታ ላቲደ ሀቼ ጋካናዉ ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ጋዛ ጋካናዉ ደእያ ሄራቱዋን ደእያ አዎቱዋ ግዶፐ፥ ካፍቶራ ግያ ጋድያፐ ዬዳ ካፍቶረቱ ኡንቱንታ ꬋይሲደ፥ ኡንቱንቱ ሳኣን ኡቴድኖ።) ");
INSERT INTO dwrENT_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“ቃይካ ጾሳይ ኑና ሀዋዳን ያጌዳ፤ ‘ደንድተ፤ አርኖና ሻፋ ፕንተ። በእተ፥ አሞረ ቢታ አሳ ግድያ ሀሰቦና ካትያ ስሆናነ አ ቢታ ታን ህንተ ኩሽያን አꬃደ እማድ፤ አ ኦሊደ አ ቢታ ላትያዋዳን ዶምተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ሀቼፐ ዶሚደ ሳሉዋፐ ጋርሳና ደእያ አሳይ ኡባይ ህንተንቶ ያያናዳን ታን ኦꬃና፤ ኡንቱንቱ ህንተዋ ስስያ ዎደ ኡባን፥ ያሻን ኮኮራና’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“ሄዋፐ ጉይያን፥ ቅደሞታ መላ ቢታፐ ሀሰቦና ካትያ ስሆናዉ ሳሮ ቃላ ኪተትያዋንቱ ቦላ ሀዋዳን ያጋደ ኪታድ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘ኑና ነ ቢታና አꬃርኪ! ኑን ዎጋ ኦገ ጻላ ኦይቂደ ባና፤ አፐ ኡሸቻ ዎይ ሀድርሳ ስሞኮ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ኑን ምያ ቁማዉነ ኡሽያ ሃꬃው ሚሻ ቃንጻና። ኑ ኮይያዌ ነ ቢታና አꬋናዋ ጻላላ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ኤዶማን ደእያ ኤሳ ዛራቱነ፥ ኤራን ደእያ ሞኣባ ዛራቱ ኑና አꬆዋዳን፥ መꬍና ጎዳይ ኑ ጾሳይ፥ ኑዉ እምያ ቢታዉ ዮርዳኖሳ ሻፋ ኑን ፕናና ጋካናዉ፥ ኦገ ጻላላና ኑና አꬃ’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“ሽን ሀሰቦና ካቲ ስሆን ኑና አናን ድጌዳ። አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ሀች ህንተ በእያዋዳን፥ አ ህንተ ኩሽያን አꬂደ እማናዉ አ ዎዛና ምንሲደ፥ አ ሞርግያ ዞዱ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","“ሄዋፐ ጉይያን መꬍና ጎዳይ ታና፥ ‘በአ፥ ስሆናነ አ ቢታ ታን ነዉ እሙሳ ዶማድ፤ ሀእ ጾናደ፥ አ ቢታ ላታ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“ያትና፥ ስሆን ባረ አሳ ኡባ አኪደ፥ ያሃጻ ግያ ሳን ኑናና ኦለታናዉ ደንዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ሽን መꬍና ጎዳይ ኑ ጾሳይ ኑዉ አ አꬅ እሜዳ፤ አ፥ አ አቱማ ናናቱዋነ አ አሳ ኡባ ኑን ዎꬌዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ሄ ዎደ ኑን አ ካታማቱዋ ኡባ ኦሞዲደ፥ ሙለ ካታማቱዋካ፥ አን ደእያ አቱማ አሳና፥ ማጫ አሳናነ ናናቱዋና ꬋይሴዳ፤ አያነ አሽበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ኡንቱንቱ መህያነ ኑን ኦይቄዳ ካታማቱዋፐ ኦሞዴዳባቱዋ ጻላላ ኑዉ አኬዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","“አርኖና ዛንጋራ ጋጻን ደእያ አሮኤራፐነ ሄ ዛንጋራ ግዶን ደእያ ካታማፐ ዶሚደ ቢደ ጋላኣደ ቢታ ጋካናዉ፥ ኑዉ ምኔዳ እት ካታምነ ደእቤና። መꬍና ጎዳይ ኑ ጾሳይ ኡንቱንታ ኡባ ኑ ኩሽያን አꬅ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ሽን ኑን አሞና ዛራቱዋ ጋድያኮ፥ ሄዌካ ያቦቃ ሻፋ ዶና ኡባኮ፥ ደረትያ ቢታ ካታማቱዋኮነ መꬍና ጎዳይ ኑ ጾሳይ ኑን ባናዳን አዛዝቤና ሳ ኡባኮ ሺቅበይኮ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“ሄዋፐ ጉይያን ኑን ስሚደ፥ ባሳነ አፍያ ኦግያና ከሲደ፤ ያትና፥ ባሳነ ቢታ ካቲ ኦግ ባረ ኦላንቻቱዋ ኡባና ኤድራአ ግያ ካታማን ኑናና ኦለታናዉ ከሴዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ሽን መꬍና ጎዳይ ታና፤ ‘አዉ ያዮፓ! አያዉ ጎፐ፥ ታን አ፥ አ ኦላንቻቱዋ ኡባናነ አ ቢታና ነ ኩሽያን አꬃደ እማድ። ሀሰቦናን ኡቲደ ካተቴዳ አሞረቱ ካትያ ስሆና ቦላ ኦꬄዳዋዳን፥ ኔን አ ቦላካ ኦꬃና’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“ሄዋ ድራዉ፥ መꬍና ጎዳይ ኑ ጾሳይ ባሳነ ቢታ ካትያ ኦጋነ አ አሳ ኡባ ኑ ኩሽያን አꬂደ እሜዳ፤ ኑን ኡንቱንቱፐ እቱዋነ አሸናን ዉርስ ዎꬌዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ሄ ዎደ ኑን አ ካታማቱዋ ኡባ ኦይቄዶ፤ ኑን ኦይቂቤና እት ካታማይካ ባዋ፤ ሄዋንቱካ ባሳነ ካትያ ኦግ አርጎባ ጋድያን አይስያ ኡሱፑን ታሙ ካታማቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ሀ ካታማቱ ኡባይካ አዱሳ ግምቢያን ድረቴዳዋንታነ ፐንግያናነ ጎርድያ ምꬃና ደእያዋንታ። ቃይ ግምቢያ ድርሳይ ባይና ሎይꬅ ዳሮ ሞꬃቱካ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ሀሰቦና ቢታ ካትያ ስሆና ቦላ ኦꬄዳዋዳን፥ ኑን ኡንቱንታ ኡባና ꬋይሴዶ። ኡንቱንቱ ካታማቱዋ ኡባ፥ ኡንቱንቱን ደእያ አቱማዋና ማጫዋነ ናናቱዋናካ ሙለ ꬋይሴዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ሽን መህያ ኡባነ ካታማቱዋፐ ቦንቄዳ ኦሞዱዋ ኦꬂደ፥ ኑዉ አኬዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“ሄ ዎደ ኑን አርኖና ሻፋፐ ቢደ ሄርሞነ ደርያ ጋካናዉ ደእያ ቢታ ዮርዳኖሳ ሻፋፐ አዋይ ዶልያ ባጋና ደእያዋ ሄ ላኡ አሞረ ቢታ ካተቱዋፐ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(ሲዶና ቢታ አሳይ ሄርሞነ ደርያ ስርዮነ ደርያ ጊደ ጼጊኖ፤ አሞረ ቢታ አሳይ ቃይ ሳኒራ ጊደ ጼጊኖ።) ");
INSERT INTO dwrENT_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ኑን ደምባ ጋድያን ደእያ ካታማቱዋ ኡባ፥ ጋላኣደ ቢታ ኡባ፥ ባሳነ ቢታ ኡባነ ባሳነ ጋድያን ኦግ ሞድያ ሳላካነ ኤድራአ ካታማቱዋ ጋካናዉ ደእያ ሳኣ ኦይቄዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(ራፋየቱዋፐ አቴዳዌ ባሳነ ቢታ ካትያ ኦጋ ጻላላ። አ አርሳይ ብራታ አርሳ፤ ሄ አርሳይ ሀቼ ጋካናዉካ ራባ ጌተትያ አሞናቱዋ ካታማን ደኤ፤ አዉ ጌሳይ ኡዱፑን ዋꬋ፤ ጎምፓይካ ኦይዱ ዋꬋ።) ");
INSERT INTO dwrENT_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“ሄ ቢታ ኑን ላቴዳዋፐ ጉይያን፥ አርኖና ሻፋ ዶናን ደእያ አሮኤራ ካታማፐ ዶሚደ ደእያ ሳኣነ፥ ደረትያ ጋላኣደ ጋድያፐ ባጋ አ ካታማቱዋናካ ሮቤላ ዛረቶነ ጋዳ ዛረቶ ታን እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ጋላኣደፐ አቴዳዋነ ኦግ ሞድያ ባሳነ ቢታ ኡባ፥ ሄዌካ አርጎባ ካዉተꬃ ቃይ ምናሰ ዛርያፐ ባጋቶ እማድ። (ሄ ባሳነ ቢታይ ኡባይ ራፋየቱዋ ቢታ ጌተት ጼሰቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ምናሰ ዛርያፐ ያኢር፥ ኩመንꬃ አርጎባ ቢታ ላቴዶ፤ ሄዌካ ጋሹራቱነ ማእካቱ ቢታ ጋጻ ጋካናዉ ደእያ ባሳነ ቢታ። እ ቄር ካታማቱዋ ባረ ሱንꬃን ጼሰታናዳን ኦꬄዳ፤ ሄዋ ድራዉ፥ ኡንቱንቱ ሀቼ ጋካናዉ፥ ሀቦት-ያኢራ ካታማቱዋ ጌተት ጼሰቲኖ።) ");
INSERT INTO dwrENT_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","“ቃይ ጋላኣደ ቢታካ ምናሰ ዛረ ግድያ ማኪራሳዉ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ሮቤላነ ጋዳ ዛርያዉ ጋላኣደፐ ቢደ አርኖና ሻፋ ማታ ጋካናዉ ደእያ ቢታ እማድ። ገድሳ ባጋና ኡንቱንቶ አርኖና ሻፋዉ ባጋይ ዛዋ፤ ቃይ ሁጲሳ ባጋና አሞናቱዋ ቢታ ጋጻ ግድያ ያቦቃ ሻፋይ ዛዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","አዋይ ዉልያ ባጋና፥ ኡንቱንቱ ዛዋይ አራባን ደእያ ዮርዳኖሳ ሻፋ ጋኬ፤ ሄዌካ ጋሊላ አባፐ ዶሚደ ፕስጋ ደርያ ጻጱዋን ደእያ ሀይቁዋ አባ፥ ሄዌነ ማጽንያ አባ ጋካናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“ሄ ዎደ ታን ህንተና ሀዋዳን ያጋደ አዛዛድ፤ ‘መꬍና ጎዳ ህንተ ጾሳይ ሀ ቢታ ህንተ ላታናዳን ህንተንቶ እሜዳ። ስም ህንተንቶ ደእያ ቶራንቻ አሳ ኡባ ኦላ ሚሻ ግጽሲደ፥ ህንተ እሻቱዋ ግድያ እስራኤልያ አሳፐ ስንꬃና ኦለታናዉ አꬍተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","ህንተዉ ዳሮ መሂ ደእያዋ ታን ኤራይ፤ ሄዋ ድራዉ፥ ህንተ ማቼቱ፥ ህንተ ጉꬃ ናናይነ ህንተ መሂ ታን ህንተንቶ እሜዳ ካታማቱዋን ደእሽኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ሄዌነ፥ መꬍና ጎዳይ ህንተና ሸምፕሴዳዋዳን፥ ህንተ እሻቱዋካ ሸምፕሳና ጋካናዉነ፥ ቃይ ዮርዳኖሳ ሻፋ ሄፍንꬃን፥ መꬍና ጎዳይ ህንተ ጾሳይ ኡንቱንቶ እምያ ቢታ ኡንቱንቱ አካና ጋካናሳ። ሄዋፐ ጉይያን፥ ህንተ ሁጲያን ሁጲያን፥ ታን ህንተንቶ እሜዳ ቢታ ስሚታ’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","“ታን ሄ ዎደ ያሳ ሀዋዳን ያጋደ አዛዛድ፤ ‘መꬍና ጎዳይ፥ ህንተ ጾሳይ፥ ሀ ላኡ ካተቱ ቦላ ኦꬄዳዋ ኡባ ኔን ነ አይፍያን በኣዳ፤ ህንተ ኦይቃናዉ ብያ ካዉተꬃቱዋ ኡባ ቦላካ መꬍና ጎዳይ ሄዋዳን ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ህንተ ድራዉ ኦለትያዌ፥ መꬍና ጎዳ ህንተ ጾሳ ግድያ ድራዉ፥ ኡንቱንቶ ያዮፕተ’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“ሄ ዎደ ታን ሀዋዳን ያጋደ መꬍና ጎዳ ሎይꬃደ ዎሳድ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘ኡባ ሞድያ መꬍና ጎዳዉ፥ ነ ግታተꬃነ ነ ምኖ ኩሽያ ታና፥ ነ ቆማ በሳናዉ ዶማዳ፤ አያዉ ጎፐ፥ ነዋዳን ሀዋ ማላ ኦሶቱዋነ ዎልቃማባ ኦꬃናዉ ዳንዳይያዌ ሳሉዋን ግድና ሳኣን አይ ጾሳይ ደኢ? ");
INSERT INTO dwrENT_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","ጾሳዉ! ታን ባደ ዮርዳኖሳ ሻፋፐ፥ ሄፍንꬃን ደእያ ሄ ሎኦ ደረትያ ቢታነ ሊባኖሳ በአናዳን ታና የዳርኪ!’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","“ሽን መꬍና ጎዳይ ህንተ ጋሱዋን ታና ሀንቀቲደ፥ ታዉ ስሰናን እጼዳ፤ መꬍና ጎዳይ ታና ሀዋዳን ያጌዳ፤ ‘ስም ነዉ ግዳናዋ፤ ሀ የዉዋ ደንꬃደ ላኤንꬆ ታዉ ሃሳዮፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","ሄዋ አጋደ ደንዳ፥ ፕስጋ ደርያ ሁጲያ ከሳ፤ ሄዋን ኤቃደ ቢታዉ አዋይ ዶልያ ባጋ፥ ሁጲሳ፥ ገድሳነ አዋይ ዉልያ ባጋ ነ አይፍያ ደንꬃደ ጼላ። አያዉ ጎፐ፥ ኔን ሀ ዮርዳኖሳ ሻፋ ሙለካ ፕናካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","ማታ ኔን ኢያሱዉ አዛዙዋ እማ፤ አ ጻልሳነ ምንꬃ፤ አያዉ ጎፐ፥ እ ሀ አሳ ካለꬂደ ፕንꬃናነ ሀ ኔን በእያ ቢታ እ ኡንቱንታ ላትሳናዋ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","“ሄዋ ድራዉ፥ ኑን ቤት-ፓኦራ ካታማ ስንꬃን ደእያ ዛንጋራን ጋምኤዶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ሄዋፐ ጉይያን፥ ሙሴ አሳ ሀዋዳን ያጌዳ፤ “ሀእካ እስራኤልያ አሳዉ፥ ህንተ ደኡዋን ደአናዳንነ መꬍና ጎዳይ፥ ህንተ ማይዛ አዎቱዋ ጾሳይ፥ ህንተንቶ እምያ ቢታ ህንተ ላታናዳን፥ ታን ህንተና ታማርስያ አዋዩዋነ ህግያ ስስተነ ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ታን ህንተና አዛዝያ መꬍና ጎዳ ህንተ ጾሳ አዛዙዋ ናግተፐ አትና፥ አ ቦላ አይነ ጉጆፕተ፤ ቃይ አፐ አይነ ፓጭሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","ባኣል-ፓኦራ ደርያ ቦላን መꬍና ጎዳይ ኦꬄዳዋ ህንተ ህንተ አይፍያን በኤድታ፤ መꬍና ጎዳይ ህንተ ጾሳይ ባኣል-ፓኦራን ደእያ ባኣላዉ ጎይኔዳዋንታ ኡባ ህንተ ግዶፐ ꬋይሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ሽን ህንተ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ አማነቴዳ ድራዉ፥ ሀች ጋካናዉ ኡባይካ ደኡዋን ደኢታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“በእተ፥ ህንተ ላታናዉ ገልያ ጋድያን ኦꬃና ማላ፥ መꬍና ጎዳይ፥ ታ ጾሳይ ታና አዛዜዳዋዳን፥ አዋዩዋነ ህግያ ታን ህንተና ታማርሳድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ህንተ ኡንቱንታ ናግተነ ኦꬅተ፤ ሄዋ ህንተ ኦꬆፐ፥ ህንተ አይ ኬሻ አꬌዳ ኤራንቼንቶነ ሀራ አሳይ ህንተና በአና። ኡንቱንቱ ሀ አዋዩዋባ ስስያ ዎደ፥ ‘ቱሙካ ሀ ዎልቃማ ካተተꬃይ አꬌዳ ኤራንቻነ አኬካንቻ ካዉተꬃ’ ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","“ኑን አ ጼስያ ዎደ አዉደነ፥ መꬍና ጎዳይ ኑ ጾሳይ ኑዉ ማታ ግድያዋዳን፥ ማታ ጾስ አዉ ደእያ አይ ዎልቃማ ካዉተꬃይ ደኢ? ");
INSERT INTO dwrENT_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ታን ሀች ህንተ ስንꬃን ዎꬅያ ሀ ህገ ኡባዳን ጽሎ ግዴዳ አዋዩነ ህጊ ደእያ ሀራ አይ ዎልቃማ ካዉተꬃይ ደኢ? ");
INSERT INTO dwrENT_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“ስም ህንተ ደእያ ላይꬃ ኡባን ሀ ህንተ በኤዳዋ ኡባ ዶገናዳንነ ህንተ ሁጲያፐ ꬋይሰናዳን ናገትተ፤ ህንተ ናናቱዋነ ህንተ ናናቱ ናናቱዋ ታማርስተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ሲና ደርያ ቦላን መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ህንተ ኤቄዳ ዎደ፥ ጾሳይ ታና፥ ‘ሀ ሳኣን ደኤዳ ዎደ ኡባን፥ ኡንቱንቱ ታዉ ያይያዋ ታማራናዳንነ ባረንቱ ናናቱዋካ ሄዋ ታማርሳናዳን፥ ታን ታ ቃላ ኡንቱንታ ስሳና ማላ፥ አሳ ታኮ ሺሻ’ ጌዳዋ ሀሳይተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","“ሄ ዎደ ህንተ ሺቂደ ደርያ ጻጱዋን ኤቄድታ፤ ሳሎ ግዱዋ ጋካናዉ፥ ሄ ደርያ ቦላን ታማይ ኤጼ፤ ሄ ደርያ ጻጱ ሳካና ꬉማንነ ሻራን ጎዘት ኡቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","መꬍና ጎዳይካ ታማ ግዶፐ ህንተንቶ ሃሳዬዳ፤ ህንተ አ ኮሻ ስሴድታፐ አትና፥ አ በእበይክታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ህንተ ኦꬃናዳን እ ህንተና አዛዜዳ ባረ ጫቁዋ ህንተንቶ ኦዴዳ፤ ሄዋንቱካ ታሙ አዛዞቱዋ። እ ኡንቱንቱ ላኡ ማሰቴዳ ሹቻቱ ቦላ ጻፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ህንተ ላታናዉ ብያ ጋድያን ኦꬃናዳን፥ አዋዩዋነ ህግያ ህንተና ታማርሳና ማላ፥ መꬍና ጎዳይ ታና ሄ ዎደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“መꬍና ጎዳይ ሲና ደርያ ቦላን ታማ ግዶፐ ህንተንቶ ሃሳዬዳ ጋላስ፥ ህንተ አ በእቤና ድራዉ፥ ሎይꬅ ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","አቱማ ዎይ ማጫ ማላን ኦሰቴዳዋ ግድና ");
INSERT INTO dwrENT_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ሳኣን ደእያ ዶኣ ኡባ ሌምሱዋ ግድና፥ ሳሉዋ ጉፋንꬁዋን ፓልያ ካፉዋ ኡባ ሌምሱዋ ግድና፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ሳኣ ቦላን ቃጽያባቱ ሌምሱዋ ግድና፥ ቢታፐካ ጋርሳና ሃꬃ ግዶን ደእያ ሞልያ ሌምሱዋ ግድናካ፥ ህንተ ቱነናዳን ማሰቴዳዋ ህንተንቶ ጾሳ ኦꬂደ ጎይኖፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ቃይ ሳሉዋ ፑደ ጼሊደ፥ መꬍና ጎዳይ ህንተ ጾሳይ ሳሉዋፐ ጋርሳና ደእያ ካዉተꬃቶ ኡባዉ እሜዳ አዋ፥ አግና፥ ጾልንተቱዋነ ሳሉዋ መታቱዋ ኡባ በኢደ፥ ህንተ ኡንቱንቶ ጎይኒደ፥ ባለናዳን ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","ሽን መꬍና ጎዳይ ህንተና ሀች ህንተ ግድያዋዳን፥ ባረዉ ዱማቴዳ አሳ ኦꬃናዉ ብራታ ጮጭያ ማላ ግድያ ግብጼፐ ከሲደ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“ቃይ ህንተ ጋሱዋን መꬍና ጎዳይ ታና ሀንቀቲደ፤ ታን ዮርዳኖሳ ፕነናዳንነ፥ መꬍና ጎዳይ፥ ህንተ ጾሳይ፥ ላታ ኦꬂደ ህንተንቶ እምያ ሎኦ ቢታ ታን ገለናዳን ጫቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","ሄዋ ድራዉ፥ ታን ዮርዳኖሳ ሻፋ ፕነናን ሀ ጋድያን ሀይቃና፤ ሽን ህንተ ፕኒደ፥ ሄ ሎኦ ቢታ ላቲታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","ሄዋ ድራዉ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተናና ጫቀቴዳ ጫቁዋ ዶጎፕተ። ቃይ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ኦꬆፕተ ጌዳ አይ ማላን ማሰቴዳ ምስልያ ግዶፐነ ህንተንቶ ኤቃ ኦናዳን ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ምያ ታማነ ቃናትያ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“ህንተ ናናቱዋነ፥ ናናቱ ናናቱዋ የሊደ ሄ ጋድያን አዱሳ ዎድያ ደእያ ዎደ፥ አይ ማላን ግዶፐነ ማሰቴዳ ምስልያዉ ጎይኒደ ቱኖፐ፥ ቃይ መꬍና ጎዳ ህንተ ጾሳ ሀንቀꬃናዉ አ ስንꬃን ኢታባ ኦꬆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","ህንተ ዮርዳኖሳ ሻፋ ፕኒደ ላታናዉ ብያ ጋድያፐ እቱነ አተናን፥ ኤለ ꬋያናዉ፥ ታን ህንተ ቦላን ሀች ሳሉዋነ ሳኣ ማርካያይ። ህንተ ኡባናካ ꬋያናፐ አትና፥ ሄ ጋድያን አዱሳ ዎድያ ደእክታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","መꬍና ጎዳይ ህንተና ሀራ አሳ ግዶን ላላና፤ ሄ ህንተና መꬍና ጎዳይ ላልያ ካዉተꬃቱዋ ግዶን ህንተ ፓይዱ ጉꬃ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ሄዋን ህንተ ምꬃፐነ ሹቻፐ አሳ ኩሽያን ጊጌዳ በኤና፥ ስሰና፥ ሜናነ ስንገና ጾሳቶ ጎይናና። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ሽን ሄዋን ደኢደ፥ ህንተ መꬍና ጎዳ፥ ህንተ ጾሳ ኮያና፤ ህንተ አ ህንተ ኩመንꬃ ዎዛናፐነ ህንተ ኩመንꬃ ሸምፑዋፐ ኮዮፐ ደማና። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","ሀ ኡባ መቱዋ ግዶን ህንተ ኡንኤቲደ ደኢደ፥ ዎድያ ዉርሰꬃን መꬍና ጎዳኮ፥ ህንተ ጾሳኮ፥ ህንተ ስማናነ አ ቃላዉካ አዛዘታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","መꬍና ጎዳይ ህንተ ጾሳይ ማሮተꬃን ኩሜዳ ጾሳ ግድያ ድራዉ፥ እ ህንተና አገና፤ ዎይ ꬋይሰና፤ ህንተ አዋቶ እ ጫቄዳ ጫቁዋካ ዶገና። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“ጾሳይ ጋድያን አሳ መꬌዳ ጋላሳፐ ዶሚደ፥ ህንተፐ ካሰ አꬌዳ ዎድያ አነ ፓይድተ፤ ሀዋ ማላ ግታባይ ሙለካ ሀን ኤርንቶ ዎይ ስሰት ኤርንቶ፥ ሳሎ ሀ ጋጻፐ ያ ጋጻ ጋካናዉ አነ ኦችተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ታማ ላጩዋ ግዶና ጾሳይ ስሲደ፥ ህንተ ꬋየናን ደኡዋን ደኤዳዋዳን፥ ጾሳይ ስሲደ፥ ደኡዋን ደኤዳ ሀራ አሳይ ደኢ? ");
INSERT INTO dwrENT_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","ዎይ መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ጼልሽን፥ ግብጼ ጋድያን ህንተንቶ ኦꬄዳዋዳን፥ ፓጭያን፥ ማላታን፥ ማላልስያዋን፥ ኦላን ዎልቃማ ኩሽያንነ ምጨቴዳ ቀስያን፥ ቃይ ዎልቃማ ያሻን ሀራ ካዉተꬃ ግዶ ገሊደ፥ እት ካዉተꬃ ባረዉ አካናዉ ባጸቴዳ ሀራ ጾስ ደኢ? ");
INSERT INTO dwrENT_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","መꬍና ጎዳይ ጾሳ ግድያዋ ህንተ ኤራና ማላ፥ ሄዋ እ ህንተና በሴዳ፤ አፐ አትና ሀራይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","እ ህንተና ታማርሳናዉ ኮዬዳ ድራዉ፥ ባረ ኮሻ ሳሉዋፐ ህንተና ስሴዳ። ቃይ ሀ ሳኣን ባረ ዎልቃማ ታማ ህንተና በሴዳ፤ ሄ ታማ ግዶፐ ህንተ አ ቃላ ስሴድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","እ ሄዋ ኦꬄዳዌ ህንተ አዎቱዋ ሲቄዳዋፐ ደንዴዳዋን፥ ኡንቱንቱፐ ጉይያን የለትያ ኡንቱንቱ ዛራቱዋ ዶሬዳ ግሻሳ። ቃይ ህንተናካ ግብጼፐ ባረ ዎልቃማ ዎልቃን ከሴዳ ግሻሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ሀቼ ህንተ በእያዋዳን፥ ህንተና ገልሳናዉነ ኡንቱንቱ ቢታ ህንተንቶ ላታ ኦꬂደ እማናዉ፥ ህንተፐ ዳርያነ ዎልቃምያ ካዉተꬃቱዋ ህንተ ስንꬃፐ የደርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","“ስም ሄዋ ግዶፐ፥ ቦላ ሳሉዋን ግድና፥ ጋርሳ ሳኣን ግድና፥ መꬍና ጎዳይ ጾሳ ግድያዋ ኤርተ፤ ህንተ ዎዛናንካ ዎꬅተ፤ ሀራ ጾሳይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","ሄዋ ድራዉ፥ ህንተንቱነ ህንተፐ ጉይያን ህንተ ናናዉ ኡባባይ ሎኦ ግዳናዳን፥ ቃይ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ መꬍናዉ እምያ ጋድያን ህንተ ህንተረ አዱቃናዳን፥ ታን ሀች ህንተና አዛዝያ አዋዩዋነ ህግያ ናግተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ሄዋፐ ጉይያን፥ ሙሴ ዮርዳኖሳ ሄፍንꬃን አዋይ ዶልያ ባጋና ሄዙ ካታማቱዋ ዱማዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ሄዋ እ ዱማዬዳዌ ካሰ ሞርከተꬃይ ባይናን ደእሽን፥ ኤረናን፥ ባረ ሾሩዋ ዎꬌዳ አሳይ ያ ባቃታናሳ። ሄ ካታማቱዋፐ እቶ ባቃቲደ፥ ሄ ብታኒ ባረ ሸምፑዋ አሻናዉ ዳንዳዬ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ሄዋ ድራዉ፥ ሮቤላ ዛርያዉ መላ ቢታን ꬎቃሳን ደእያ ቤጸራ ካታማ፥ ጋዳ ዛርያዉ ጋላኣደን ደእያ ራሞታነ ምናሰ ዛርያዉ ባሳነን ደእያ ጎላና ካታማቱዋ ዱማዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ሙሴ እስራኤልያ አሳዉ እሜዳ ጾሳ ህጊ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","46","ሀ ዎጋ፥ አዋዩዋነ ህግያ ኡንቱንቱ ግብጼፐ ከሲደ፥ ቤት-ፓኦራ ካታማ ስንꬃን ደእያ፥ ዮርዳኖሳፐ አዋይ ዶልያ ባጋና ደእያ ዛንጋራን ደእሽን፥ ኡንቱንቶ እሜዳ። ሄ ሳአይ ሀሰቦናን ኡቲደ አሞረ ሞድያ ካትያ ስሆና ቢታ ግዶና። ሙሴነ እስራኤልያ አሳይ ግብጼፐ ከሴዳ ዎደ፥ ስሆና ኦሊደ ጾኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","ሄ ዎደ ኡንቱንቱ አ ቢታነ ባሳነ ካትያ ኦጋ ቢታ፥ ሄዌካ ቃይ ዮርዳኖሳፐ አዋይ ዶልያ ባጋና ደእያ ላኡ አሞረ ካተቱ ቢታ ላቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ሄ ቢታይ አርኖና ሻፋ ዶናን ደእያ አሮኤራ ካታማፐ ቢደ፥ ስርዮነ ደርያ ጋኬ፤ ሄ ስርዮነ ጌተት ጼሰትያ ደሪ ሄርሞነ ግያ ደርያ። ");
INSERT INTO dwrENT_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ቃይካ ሄ ቢታይ ዮርዳኖሳፐ አዋይ ዶልያ ባጋና ደእያ አራባ ቢታ ኡባ አኪደ ቢደ፥ ፕስጋ ደርያ ጻጱዋን ደእያ ሀይቁዋ አባ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","ሙሴ እስራኤልያ አሳ ኡባ እትፐ ጼሲደ፥ ሀዋዳን ያጌዳ፤ “ህንተኖ እስራኤልያ አሳዉ፥ ታን ሀች ህንተንቶ ኦድያ አዋዩዋነ ህግያ ስስተ፤ ህንተ ኡንቱንታ ታማርተነ ምንሲደ ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","መꬍና ጎዳይ ኑ ጾሳይ ሲና ደርያ ቦላን ኑናና ጫቁዋ ጫቀቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","መꬍና ጎዳይ ሀ ጫቁዋ ጫቀቴዳዌ ኑ አዎቱዋ ጻላላና ግደና፤ ሀች ደኡዋን ደእያ ኑ ኡባናካ ጫቀቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ሄ ደርያ ቦላን ኤጽያ ታማ ግዶን ግዲደ፥ መꬍና ጎዳይ ህንተ ስንꬃን ኤቂደ ህንተናና ሃሳዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","ታንካ ሄ ዎደ መꬍና ጎዳይ ግያዋ ህንተንቶ ኦዳናዉ፥ ጾሳፐነ ህንተፐ ግዱዋን ኤቃድ፤ አያዉ ጎፐ፥ ህንተ ታማዉ ያዪደ፥ ደርያ ፑደ ከስበይክታ። ጾሳይካ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“ግብጼ ጋድያፐ አይለተꬃ ጎልያፐ ኔና ዎዜዳዌ ታን መꬍና ጎዳ ነ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“ታፐ አትና፥ ሀራ ጾሳቱ ነዉ ደኦፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“ቦላ ሳሉዋን ደእያዋ ግድና፥ ዎይ ጋርሳ ሳኣን ደእያዋ ግድና፥ ዎይ ሳኣፐ ጋርሳና ደእያ ሃꬃ ግዶን ደእያዋ ግድናካ፥ አያ ምስልያነ ነዉ ኤቃ ኦꬆፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","ኔን ኡንቱንቶ ሆኮፓ፤ ዎይ ኡንቱንቶ ጎይኖፓ፤ አያዉ ጎፐ፥ ታን ታና እጽያዋንታ አዎቱዋ ናጋራ ድራዉ፥ ናናቱዋ ሄዘንꬃነ ኦይደንꬃ የለታ ጋካናዉ ሙርያዋ፤ ታን፥ መꬍና ጎዳይ ነ ጾሳይ ቃናትያ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ሽን ታን ታና ሲቅያዋንታነ ታ አዛዙዋ ናግያዋንታ ሻአ የለታ ጋካናዉ ታ አገና ሲቁዋ በሳይ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“መꬍና ጎዳ ነ ጾሳ ሱንꬃ ጮ ጼሶፓ፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ባረ ሱንꬃ ጮ ጼስያዋ ሙረናን አገና። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“መꬍና ጎዳይ ነ ጾሳይ ኔና አዛዜዳዋዳን፥ ጌሻ ኦꬃደ ሳምባታ ጋላሳ ናጋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ኔን ኦꬅያ ኦሶ ኡባ ኡሱፑን ጋላሳን ኦꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ሽን ላፑንꬃ ጋላሳይ መꬍና ጎዳዉ፥ ነ ጾሳዉ ሳምባታ። ሄ ጋላስ አይ ኦሶነ ኦꬆፓ፤ ኔን ዎይ ነ አቱማ ናአይ፥ ዎይ ነ ማጫ ናታ፥ ዎይ ነ ቆማይ፥ ዎይ ነ ቦራይ፥ ዎይ ነ ሀሪ፥ ዎይ ነ ሀራ መሄቱ፥ ዎይ ነ ካታማን ደእያ በቲ፥ ሄ ጋላስ አያ ኦሶነ ኦꬆፕተ። ኔን ሸምፕያዋዳን ነ አቱማነ ማጫ ቆማቱካ ሸምፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","ኔን ግብጼ ጋድያን አይልያ ግዳደ ደኤዳዋ ዶጎፓ፤ ቃይ መꬍና ጎዳይ ነ ጾሳይ ባረ ዎልቃማ ኩሽያንነ ባረ ምጨቴዳ ቀስያን ያፐ ኔና ከሴዳዋ ዶጎፓ። መꬍና ጎዳይ ነ ጾሳይ ሳምባታ ጋላሳ ኔን ናጋናዳን፥ ኔና አዛዜዳዌካ ሄዋ ግሻሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“መꬍና ጎዳይ ነ ጾሳይ ነዉ እምያ ጋድያን ነ ኔረካ አዱቃና ማላነ ነዉ ሎአና ማላ፥ መꬍና ጎዳይ ነ ጾሳይ ኔና አዛዜዳዋዳን፥ ነ አዉዋነ ነ ዳዮ ቦንቻ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“አሳ ዎꬎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“ሻርሙጾፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“ዉኦፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“ነ ሾሩዋ ቦላን ዎርዱዋ ማርካቶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“ነ ሾሩዋ ማቻቶ አሞቶፓ፤ አ ጎልያ፥ አ ሾይቃ፥ አ አቱማ ቆማ፥ ዎይ አ ማጫ ቆማቶ፥ ዎይ አ ቦራ፥ ዎይ አ ሀርያ፥ ዎይ አዉ ደእያዋ አያነ አሞቶፓ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“ደርያ ቦላን ታማ ግዶፐ፥ ሻርያ ግዶፐነ ጎርዴዳ ꬉማ ግዶፐ መꬍና ጎዳይ ꬎቁ ጌዳ ኮሻን ሺቁዋ ኡባዉ ኦዴዳ ቃላቱ ሀዋንታ፤ እ ኡንቱንቱ ቦላን አያነ ጉጅቤና። ቃይ ኡንቱንታ እ ላኡ ማሰቴዳ ሹቻቱ ቦላ ጻፊደ፥ ታዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","“ደሪ ታማን ጹገትሽን፥ ꬉማ ግዶፐ ኮሻ ህንተ ስሴዳ ዎደ፥ ህንተ ዛርያ ካፓቱነ ህንተ ጭማቱ ታኮ ዪደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","ሀዋዳን ያጌድታ፤ ‘በአ፥ ኑን መꬍና ጎዳ ኑ ጾሳ ኮሻ ታማ ግዶፐ ስሴዳ ዎደ፥ መꬍና ጎዳይ ኑ ጾሳይ ባረ ቦንቹዋነ ባረ አንጋ ኑና በሴዳ። ቃይ ኑን ጾሳይ አናና ሃሳዪደ አሳይ ደኡዋን ደአናዉ ዳንዳይያዋ ሀቼ በኤዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","ሽን ሀ ዎልቃማ ታማይ ኑና ꬋይሳናዉ ዳንዳዬ፤ ያትና፥ ኑን አያዉ ሀይቄቶ? መꬍና ጎዳ ኑ ጾሳ ቃላ ኑን ላኤንꬆ ስሶፐ፥ ኑን ሀይቄቶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","አያዉ ጎፐ፥ አሹዋ ማዬዳዋን፥ ኑን ስሴዳዋዳን ታማ ግዶን ግዲደ ሃሳይሽን፥ ደኦ ጾሳ ቃላ ስሲደ፥ ፓጻ ደኤዳ አሳይ ኦኔ? ");
INSERT INTO dwrENT_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","ሄዋ ድራዉ፥ ሙሴ! ኔን ሺቃደ፥ መꬍና ጎዳይ ኑ ጾሳይ ግያዋ ኡባ ስሳ፤ መꬍና ጎዳይ ኑ ጾሳይ ነዉ ኦድያዋ ኡባ ኔን ኑዉ ኦዳ፤ ኑንካ ስሲደ ኦꬃና’ ያጌድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“ህንተ ታዉ ሃሳይሽን፥ መꬍና ጎዳይ ህንተ ግያዋ ስሲደ፥ መꬍና ጎዳይ ታና ሀዋዳን ያጌዳ፤ ‘ሀ አሳይ ነዉ ኦዴዳዋ ኡባ ስሳድ፤ ኡንቱንቱ ጌዳዋ ኡባ ልከ ጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","ኡንቱንቱዉነ ኡንቱንቱ ናናዉ መꬍናዉ ኡባባይ ሎአ ግዳናዳን፥ ታዉ ያያናዉነ ታ አዛዞቱዋ ናጋናዉ ኡንቱንቶ ኡባቶካ ሀዋ ማላ ዎዛናይ ደእ ኤረኔሻ! ");
INSERT INTO dwrENT_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","ሀእ ኔን ባደ፥ ኡንቱንቱ ባረንቱ ዱንካንያዉ ስማናዳን ኦዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","ሽን ኔን ሀዋን ታ ማታን ኤቃሻ፤ ኡንቱንቱ ላታናዳን ታን ኡንቱንቶ እምያ ጋድያን ኡንቱንቱ ኦꬃና ማላ፥ ኔን ኡንቱንታ ታማርሳና ታ አዛዙዋ፥ ታ አዋዩዋነ ታ ህግያ ኡባ ታን ነዉ ኦዳና’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","“ህንተኖ እስራኤልያ አሳዉ፥ ሄዋ ግዶፐ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አዛዜዳዋ ኡባ ኦꬃናዉ ናገትተ፤ አፐ ኡሸቻ ዎይ ሀድርሳ ጎፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ህንተ ደኡዋን ደአና ማላ፥ ኡባባይ ህንተንቶ እንጀታና ማላ፥ ቃይ ህንተ ላትያ ቢታንካ ህንተ አዱቂደ ደአና ማላ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አዛዜዳ ኦገ ኡባን ሄመትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“ህንተ ላታናዉ ብያ ጋድያን ህንተ ኦꬃናዳን ታን ህንተና ታማርሳና ማላ፥ መꬍና ጎዳይ ህንተ ጾሳይ ታና አዛዜዳ አዛዞቱ አዋዮቱነ ህገቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ህንተ ላይꬃይ አዱሳ ግዳና ማላ፥ ህንተ፥ ህንተ ናናቱነ ህንተ ናናቱ ናናይካ ታን ሀች ህንተና አዛዝያ ጾሳ አዋዩዋነ ህግያ ናግያዋን ህንተ ላይꬃን ኡባን መꬍና ጎዳዉ፥ ህንተ ጾሳዉ ያይተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ህንተኖ እስራኤልያ አሳዉ፥ ኡባባይ ህንተንቶ ሎአ ግዳናዳንነ መꬍና ጎዳይ፥ ህንተ አዎቱዋ ጾሳይ፥ ህንተንቶ ጌዳዋዳን፥ ማꬃነ ኤሳ ጎግያ ጋድያን ህንተ ሎይꬅ ጮራታናዳን፥ ሀ ህገቱዋ ስስተነ ምንሲደ ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“ኔኖ እስራኤልያዉ፥ ስሳ፤ መꬍና ጎዳይ ኑ ጾሳይ እት መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","ኔን መꬍና ጎዳ ነ ጾሳ ነ ኩመንꬃ ዎዛናፐ፥ ነ ኩመንꬃ ሸምፑዋፐነ ነ ኩመንꬃ ዎልቃፐ ሲቃ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","ሀቼ ታን ኔና አዛዝያ ሀ አዛዞቱዋ ነ ዎዛናን ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ሀ አዛዛቱዋ ኔን ነ ናናቱዋ ታማርሳ፤ ኔን ነ ሶን ኡትያ ዎደ፥ ኦግያን ሀመትያ ዎደ፥ ግስያ ዎደነ ደንድያ ዎደካ ኡንቱንታ ሃሳያ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","ማላታ ኦꬃደ ነ ኩሽያን ኡንቱንታ ቃቻ፤ ቃይ ነ ሶምእያንካ ማላታዳን ዎꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","ነ ፐንግያ ማቃንያ ቦላንነ ነ ድርሳ ፐንግያ ቦላን ኔን ኡንቱንታ ጻፋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","11","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እማና ጊደ ህንተ አዋቶ፥ አብራሃማዉ፥ ይሳቃዉነ ያቆባዉ ጫቄዳ፥ ህንተ ኬጽቤና ግታነ ሎኦ ካታማቱ ኩሜዳ ቢታ እማና። ህንተ ኩንꬅቤና ዱረታይ ኩሜዳ ጎለቱዋ፥ ህንተ ቦክቤና ኦላቱዋ፥ ህንተ ቶክቤና ዎይነቱዋነ ዛይትያ ዎጋራቱዋ ህንተንቶ እምያ ዎደ፥ ህንተካ ሚደ ካሌዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ህንተና ግብጼፐ፥ አይለተꬃ ጋድያፐ ከሴዳ መꬍና ጎዳ ዶገናዳን ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ያይተ፤ አ ጻላላዉ ጎይንተ፤ አ ሱንꬃንካ ጫቂተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","ህንተ ዩሹዋን ደእያ አሳይ ጎይንያ ሀራ ጾሳቶ ጎይኖፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","አያዉ ጎፐ፥ ህንተ ግዶን ደእያ መꬍና ጎዳይ ህንተ ጾሳይ ቃናትያ ጾሳ፤ አ ሀንቁ ህንተ ቦላን ኤጽ ከሳና፤ እ ህንተና ቢታ ቦላፐካ ፕቲደ ꬋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“ማሳሀን ህንተ አ ፓጬዳዋዳን፥ መꬍና ጎዳ ህንተ ጾሳ ፓጮፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አዛዜዳ አ አዛዞቱዋ፥ አ ዎጋቱዋነ አ አዋዮቱዋ ምንሲደ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","ህንተዉ ኡባባይ ሎአ ግዳና ማላ፥ መꬍና ጎዳ ስንꬃን ህንተ ልከባነ ሎኦባ ኦꬅተ። ያቶፐ፥ ህንተንቶ እማናዉ መꬍና ጎዳይ ህንተ አዋቶ ጫቄዳ፥ ሄ ሎኦ ቢታ ህንተ ላታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","መꬍና ጎዳይ ባረ ጌዳዋዳን ህንተ ሞርከቱዋ ኡባ ህንተ ስንꬃፐ የደርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“ስንꬃፐ ህንተ ናናይ፥ መꬍና ጎዳይ ኑ ጾሳይ ህንተና አዛዜዳ ሀ ዎጋ፥ አዋዩዋነ ህግያ ብለꬃይ አዬ? ያጊደ ህንተና ኦችያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ህንተ ኡንቱንቶ ሀዋዳን ያጊደ ዛርተ፤ ‘ኑን ግብጼ ጋድያን ግብጼ ካትያ አይለቱዋ፤ ሽን መꬍና ጎዳይ ባረ ምኖ ኩሽያን ኑና ግብጼፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ቃይ መꬍና ጎዳይ ኑ ጼልሽን፥ ግብጼ ቢታ ቦላን፥ ግብጼ ካትያ ቦላንነ አ ሱንꬃቱዋ ኡባ ቦላን ግታነ ያሽያ ማላታቱዋነ ማላልስያባቱዋ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ሽን እ ኑ ማይዛ አዋቶ እማና ጊደ ጫቄዳ ቢታ ኑና ገልሲደ፥ ኑዉ እማናዉ ኑና ግብጼፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","ያቲደ ሀች በእያዋዳን፥ ኑዉ ኡባ ዎደካ ሎአ ግዳና ማላነ ኑን ደኡዋን ደአና ማላ፥ መꬍና ጎዳይ ኑና ሀ አዋዮቱዋ ኡባ ናጋናዳንነ መꬍና ጎዳዉ፥ ኑ ጾሳዉ፥ ያያናዳን አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","እ ኑና አዛዜዳዋዳን፥ መꬍና ጎዳ፥ ኑ ጾሳ፥ ስንꬃን ሀ አዛዞቱዋ ኡባ ምንሲደ ናጎፐ፥ ሄዌ ኑዉ ጽሎተꬃ ግዳና’ ያግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ላታናዉ ብያ ቢታ ህንተና ገልስያ ዎደነ፥ ቃይ ህንተፐ ዎልቃምያነ ምንያ ላፑን ካዉተꬃቱዋ፥ ሄዋንቱካ ሂተቱዋ፥ ገርጌሰቱዋ፥ አሞረቱዋ፥ ካናነቱዋ፥ ፓርዘቱዋ፥ ሂዌቱዋነ ያቡሳቱዋ ህንተ ስንꬃፐ ꬎቆልያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ኡንቱንቱካ መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ኩሽያን አꬅ እምና፥ ህንተ ኡንቱንታ ጾንያ ዎደ፥ ኡንቱንታ ኡባና ሱፑ ኦꬂደ ꬋይስተ። ኡንቱንቱና አያ ጫቁዋነ ጫቀቶፕተ። ኡንቱንቶ አይነ ቃረቶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ህንተ ኡንቱንቱና አከቶፕተነ ገለቶፕተ። ህንተ ማጫ ናናቱዋ ኡንቱንቱ አቱማ ናናዉ እሞፕተ። ዎይ ኡንቱንቱ ማጫ ናናቱዋካ ህንተ አቱማ ናናዉ አኮፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","አያዉ ጎፐ፥ ኡንቱንቱ ህንተ ናናቱዋ ታና ካልያዋፐ ሀራ ኤቃቱዋ ጎይናናዳን፥ ዎራ ዛራና። ሄ ዎደ መꬍና ጎዳ ሀንቁ ህንተ ቦላ ኤጽ ከሳና፤ ህንተናካ ኤለካ ꬋይስ ባሻና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","ሄዋ ድራዉ፥ ኡንቱንቱ ያርሽያ ሳኣ ኮልተ። ኡንቱንቱ ጎይንያ ሹቻቱዋ መንሬꬅተ። አሼሮ ግያ ማጫ ጾሳት ምስልያ ክንቼሬꬅተ፤ ኡንቱንቱ ማሰቴዳ ምስለቱዋካ ታማን ጹግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","አያዉ ጎፐ፥ ህንተ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ጌሻ አሳ። መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ባረዉ ዱማ አልኦ ሚሻ ግድያ አሳ ኦꬂደ፥ ቢታ ቦላን ደእያ አሳ ኡባፐ ዶሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“መꬍና ጎዳይ ህንተና ሲቄዳዌነ ዶሬዳዌ ህንተ ሀራ አሳፐ ፓይዱዋን ዳሬዳ ግሻሳ ግደና። ህንተ ሀራ አሳ ኡባፐካ ፓይዱዋን ጉጽያዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","ሽን መꬍና ጎዳይ ህንተና ሲቄዳ ግሻዉነ ህንተ ማይዛ አዋቶ ጫቄዳ ጫቁዋ ናጌዳ ድራዉ፥ እ ህንተና አይለተꬃ ጋድያፐ፥ ግብጼ ካትያ ኩሽያፐ፥ ባረ ዎልቃማ ኩሽያን ከሴዳነ ዎዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","ሄዋ ድራዉ፥ መꬍና ጎዳይ ህንተ ጾሳይ ጾሳ ግድያዋ ኤርተ። እ ባረና ሲቅያዋንቶነ ባረ አዛዙዋ ናግያዋንቶ ሻአ የለታ ጋካናዉ፥ ባረ አገና ሲቁዋ ጫቁዋ ናግያ፥ አማነትያ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ሽን እ ባረና እጽያዋንቶ ኡንቱንቱ ታልእያ ዛሬ፤ እ ኡንቱንቱ ታልእያ ዛራናዉ ጋምኤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","ሄዋ ድራዉ፥ ታን ሀች ህንተንቶ እምያ አዛዞቱዋ፥ አዋዮቱዋነ ህገቱዋ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“ህንተ ሀ አዛዞቱዋ ስሲደ፥ ኡንቱንታ ምንስ ናጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ማይዛ አዋቶ ጫቄዳዋዳን፥ ባረ አገና ሲቁዋ ጫቁዋ ህንተንቶ ናጋና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","እ ህንተና ሲቃና፤ ህንተና አንጃና፤ ህንተ ፓይዱዋ ዳርሳና። ቃይ እ ህንተንቶ እማናዉ ህንተ ማይዛ አዋቶ ጫቄዳ ጋድያን ህንተ ኡሉዋ አይፍያ፥ ህንተ ቢታ አይፍያ፥ ካꬃ፥ ዎይንያ፥ ዛይትያ፥ ህንተ መህያ ማራቱዋነ ህንተ ዶርሳ ማራቱዋ ጮርሲደ አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ህንተ ሀራ አይ አሳፐነ አꬊደ አንጀቴዳዋንታ ግዳና። እቱነ አቱማ ግድና፥ ማጫ ግድና ማይነና። ህንተ መሂካ ማይነና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","መꬍና ጎዳይ ሀርገ ኡባፐ ህንተና ናጋና። ህንተ ኤርያ ግብጼ ቢታ ኢታ ሀርግያ ህንተ ቦላ አሄና፤ ሽን እ ህንተና እጽያ ኡባ ቦላን ሄ ሀርግያ አሀና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ አꬅ እምያ አሳ ኡባ ꬋይስተ፤ ኡንቱንቶ አይነ ቃረቶፕተ። ኡንቱንቱ ጾሳቱዋዉካ ጎይኖፕተ። አያዉ ጎፐ፥ ሄዌ ህንተንቶ ጲረ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“ህንተ ህንተ ዎዛናን፥ ‘ሀ ካዉተꬃቱ ኑፐ ምኒኖ፤ ያትና፥ ኑን ኡንቱንታ ዋቲደ የደርስ ከሳኔ?’ ጋናዉ ዳንዳዪታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","ሽን ኡንቱንቶ ያዮፕተ። መꬍና ጎዳይ፥ ህንተ ጾሳይ፥ ግብጼ ካትያ ቦላነ ግብጼ ቢታ ኡባ ቦላ ኦꬄዳዋ ሀሳይተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ግብጼፐ ከስያ ዎደ ኦꬄዳ ዎልቃማ ቦሻቱዋ፥ ማላታቱዋ፥ ማላልስያባቱዋ፥ አ ዎልቃማ ኩሽያነ አ ምጨቴዳ ቀስያ ህንተ ህንተ አይፍያን በኤድታ። ሀእ ህንተ ያይያ አሳ ኡባ ቦላንካ መꬍና ጎዳይ፥ ህንተ ጾሳይ ሄዋዳን ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","ቃይ ኡንቱንቱፐ አꬂደ ባቃቲደ፥ ህንተፐ ቆሰቴዳዋንቱካ ꬋያና ጋካናዉ፥ መꬍና ጎዳይ ህንተ ጾሳይ ኡንቱንቱ ግዶን ሻብረꬃ የዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","“ሄዋ ድራዉ፥ ህንተ ኡንቱንቶ ያዮፕተ፤ አያዉ ጎፐ፥ ህንተናና ደእያ መꬍና ጎዳይ፥ ህንተ ጾሳይ፥ ግታነ ያሽያ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","መꬍና ጎዳይ ህንተ ጾሳይ ሄ ካዉተꬃቱዋ ጉꬃ ጉꬃ ꬎቆሊደ፥ ህንተ ስንꬃፐ ꬋይሳና። ህንተ ኡንቱንታ ኡባ እት ኩꬃን ꬋይስክታ፤ ሄዋ ህንተ ኦꬆፐ፥ ጋድያን ደእያ ዶአቱ ዳሪደ፥ ህንተና ዋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","ሽን መꬍና ጎዳይ ህንተ ጾሳይ ኡንቱንታ ህንተ ኩሽያን አꬅ እማና፤ ኡንቱንቱ ꬋያና ጋካናዉ፥ እ ኡንቱንታ ሻቢራና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ቃይ ኡንቱንቱ ካተቱዋካ እ ህንተ ኩሽያን አꬅ እማና። ህንተካ ኡንቱንቱ ሱንꬃ ሳሉዋፐ ጋርሳ ባጋፐ ፕቲደ ꬋይሳና። ኦንነ ህንተናና ኤቀት ዳንዳየና፤ ህንተ ኡንቱንታ ꬋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","“ማሰቴዳ ኡንቱንቱ ጾሳቱዋ ምስለቱዋ ታማን ጹግተ። ሄ ምስለቱዋ ቦላን ደእያ ብራ ዎይ ዎርቃ አሞቶፕተ። ሄዌ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ቱና ግድያ ድራዉ፥ ህንተ አ ጲርያን ኦይቀተናዳን፥ አ ህንተንቶ አኮፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","ህንተ ሄ ቱና ኤቃቱዋ ህንተ ጎለ ገልሲደ፥ ኡንቱንቱዳን ሸቀቴዳዋንታ ግዶፕተ። ህንተ ኡንቱንታ ኡባናካ እጽተነ ሻተትተ፤ አያዉ ጎፐ፥ ኡንቱንቱ ባረንቱ ሁጲያዉ ሸቀቴዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“ህንተ ደኡዋን ደአና ማላ፥ ህንተ ፓይዱካ ዳራና ማላነ መꬍና ጎዳይ ካሰ ህንተ ማይዛ አዋቶ እማና ጊደ ጫቄዳ ቢታ ገሊደ፥ ህንተ ላታና ማላ፥ ሀች ታን ህንተና አዛዝያ አዛዙዋ ኡባ ምንሲደ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","መꬍና ጎዳይ ነ ጾሳይ ነዉ እሜዳ አዛዙዋ ነ ናግንቶ ናገነንቶ፥ ነ ዎዛና ቆፋ ኤራናዉ፥ ኔና ፓጫናዉነ ኔና ዝቂ ኦꬃናዉ፥ ኦይታሙ ላይꬃ ኩመንꬃ እ ኔና ባዙዋን ካለꬄዳ ኦገ ኡባ ሀሳያ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","እ ኔና ዝቂ ኦꬄዳነ ኮሻይሴዳ፤ ሄዋፐ ስሚደ ኔና ግድና፥ ዎይ ነ ማይዛ አዎቱዋ ግድናካ፥ ኤረና ማና ኔና ምዜዳ። ሄዋ እ ኦꬄዳዌ አሳይ መꬍና ጎዳይ ሃሳይያ ቃላ ኡባናፐ አትና፥ ኡክꬃ ጻላላን ደኤናዋ ኔና ታማርሳናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","ሀ ኦይታሙ ላይꬃቱዋ ግዶን ኔን ማዬዳ ማዩ ዉርቤና፤ ነ ገዲካ ጋፍቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","ያቶፐ፥ አሳይ ባረ ናኣ ሴርያዋዳን፥ መꬍና ጎዳይ ነ ጾሳይካ ኔና ሴርያዋ ነ ዎዛናን አኬካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","“አ ኦግያን ሀመትያዋንነ አ ቦንችያዋን መꬍና ጎዳ ነ ጾሳ አዛዞቱዋ ናጋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","አያዉ ጎፐ፥ መꬍና ጎዳይ ነ ጾሳይ ኔና ዛንጋራፐነ ደርያፐ ፑልትያ ቄር ሻፋቱነ ጎግያ ፑልቶቱ ደእያ ሎኦ ቢታ ገልሳናዉ አሄ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ሄ ቢታይ ዛርጋይነ ባንጋይ፥ ዎይኒ፥ ባላሲነ ሮማኒ፥ ዎጋራ ዛይቲነ ኤሳይ ኩሜዳ ቢታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","ቃይካ ሄ ቢታይ ኡክꬃይ ፓጨናን ኔን ምያ ቢታ፤ አያይነ ነዉ ፓጨና ቢታ። ሄ ቢታይ ሹቻይ ብራታ ግዴዳ ቢታ። ደርያፐካ ማዳብያ ግያ ብራታ ቦኪደ አክያ ቢታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","ኔን ሄዋን ማደ ካላና፤ ያታደ፥ እ ነዉ እሜዳ ሎኦ ቢታ ድራዉ፥ መꬍና ጎዳ ነ ጾሳ ጋላታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“ታን ሀች ኔና አዛዝያ አ አዛዞቱዋ፥ አ ህገቱዋነ አ አዋዮቱዋ ናገናን አጋደ፥ መꬍና ጎዳ ነ ጾሳ ዶገናዳን፥ ናገታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","ኔን ማደ ካልያ ዎደ፥ ሎኦ ጎልያ ኬጻደ አን ኡትያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ነ መህያነ ዶርሳ ዉዲ ዳርያ ዎደ፥ ነዉ ብራይነ ዎርቃይ ዳጋትያ ዎደ፥ ቃይ ነዉ ደኤዳባይ ኡባይ ዳርያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ሄ ዎደ ነ ዎዛናይ ኦቶረተናዳን፥ ኔንካ ግብጼ ጋድያፐ፥ አይለተꬃ ጎልያፐ ኔና ዎዜዳ መꬍና ጎዳ ነ ጾሳ ዶገናዳን ናገታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","እ ኔና ማርዝያና ደእያ ሾሻይነ ማስማሱ ኩሜዳ፥ ሃꬃይ ባይና፥ ሄ ግታነ ያሽያ መላ ቢታና ካለꬄዳ፤ እ ነዉ መላ ባዙዋን ዛላፐ ሃꬃ ꬉሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ነ ማይዛ አዎቱ ኤረና ማና መላ ቢታን ኔና ምዜዳዌ፥ ኔና ዝቂ ኡዳናሳነ ኔና ፓጫናሳ፤ እ ሄዋ ኦꬄዳዌ ዉርሰꬃን ነዉ ኡባባይ ሎኦ ግዳናዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","ኔን፥ ‘ታ ዎልቃይነ ታ ኩሽያ ምኖተꬃይ ሀ ዱረተꬃ ታዉ አሄዳ’ ጌናዳን ናገታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","ሽን ኔን መꬍና ጎዳ ነ ጾሳ ሀሳያ፤ አያዉ ጎፐ፥ ሀች ኔን በእያዋዳን፥ ነ ማይዛ አዎቱዋና ጫቀቴዳ ጫቁዋ ምንꬃናዉ፥ ኔን ዱረታ ደማናዳን ነዉ ዎልቃ እሜዳዌ አቴ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","“ኔን መꬍና ጎዳ ነ ጾሳ ዶጎፐ፥ ሀራ ጾሳቱዋ ካሎፐ፥ ቃይ ኡንቱንቶ ኦꬆፐነ ጎይኖፐ፥ ኔን ቱሙ ꬋያናዋ ታን ሀች ማርካታይ። ");
INSERT INTO dwrENT_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ ኔን አዛዘተናን እጼዳ ድራዉ፥ መꬍና ጎዳይ ነ ስንꬃፐ ꬋይሴዳ ካዉተꬃቱዋዳን ኔንካ ꬋያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“ህንተኖ እስራኤልያ አሳዉ ስስተ፤ ህንተ ህንተፐ ግታትያነ ዎልቃምያ ካዉተꬃቱዋ፥ ቃይ ዩሹዋ ግምቢ ሳሉዋ ጋኬዳ ዎልቃማ ካታማቱዋካ ላታናዉ ሀች ዮርዳኖሳ ፕኒታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","ሄ ጋድያን ደእያ አሳይ ምኖነ አዱሳ፤ ኡንቱንቱ፥ ‘ኦንነ ኡንቱንቱና ኤቀታናዉ ዳንዳየና አናቀ ዛራቱዋ’ ጊሽና፥ ህንተ ስሴድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","ሽን ምያ ታማዳን ህንተፐ ስንꬃና ብያዌ መꬍና ጎዳ ህንተ ጾሳ ግድያዋ ሀች ኤርተ። እ ኡንቱንታ ꬋይሳናነ ህንተ ስንꬃን ኡንቱንታ ካዉሻና። መꬍና ጎዳይ ህንተንቶ ጌዳዋዳን ህንተ ኡንቱንታ የደርሲደ ከሳናነ ባሱዋናካ ꬋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“መꬍና ጎዳይ ህንተ ጾሳይ ኡንቱንታ ህንተ ስንꬃፐ የደርሴዳዋፐ ጉይያን፥ ህንተ ህንተ ዎዛናን፥ ‘ኑን ጽሎ ግድያ ድራዉ፥ ሀ ቢታ ኑን ላታና ማላ፥ መꬍና ጎዳይ ኑና ገልሴዳ’ ያጎፕተ። መꬍና ጎዳይ ኡንቱንታ ህንተ ስንꬃፐ የደርሲደ ከስያዌ፥ ኡንቱንቱ ኢታ ግድያ ግሻሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","ህንተ ኡንቱንቱ ቢታ ላታናዉ ገልያዌ ህንተ ጽሎነ ሱረ ግድያ ድራሳ ግደና፤ ሽን ጾሳይ ህንተ ጾሳይ ኡንቱንታ ህንተ ስንꬃፐ የደርስያዌ ሀ ካዉተꬃቱ ኢታ ግድያ ድራሳነ በን ህንተ ማይዛ አዋቶ፥ አብራሃማዉ፥ ይሳቃዉነ ያቆባዉ ጫቄዳ ቃላ ናጋናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","ስም ሄዋ ግዶፐ ህንተ ሀዋ አኬክተ፤ መꬍና ጎዳይ ህንተ ጾሳይ ሀ ሎኦ ቢታ ህንተና ላትስያዌ ህንተ ጽሎተꬃ ግሻሳ ግደና፤ አያዉ ጎፐ፥ ህንተ ሞርግያ ዞዱ ጌዳ አሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“ህንተ መꬍና ጎዳ ህንተ ጾሳ መላ ቢታን ዎት ሀንቀꬄድተንቶ ዶጎፕተ፤ ህንተ ግብጼ ጋድያፐ ከሴዳ ጋላሳፐ ዶሚደ፥ ሀች ሀ ሳኣ ጋኬዳ ጋላሳይ ጋካናዉ፥ መꬍና ጎዳ ቦላ ማካሌድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","ሲና ደርያ ቦላካ መꬍና ጎዳይ ህንተና ꬋይሳናዉ ደንዳና ጋካናዉ፥ ህንተ መꬍና ጎዳ ሀንቀꬄድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","መꬍና ጎዳይ ህንተናና ጫቀቴዳ ጫቁ ጻፈቴዳ ማሰቴዳ ሹቻቱዋ አካናዉ ታን ደርያ ሁጲያ ከሴዳ ዎደ፥ ሄዋን ካꬃ ሜናንነ ሃꬃ ኡሸናን፥ ኦይታሙ ጋላሳነ ኦይታሙ ቃማ ጋምኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","ሄዋፐ ጉይያን፥ ጾሳ ብራꬍያን ጻፈቴዳ ላኡ ማሰቴዳ ሹቻቱዋ መꬍና ጎዳይ ታዉ እሜዳ። ሄ ማሰቴዳ ሹቻቱ ቦላ ህንተ ሺቁዋ ኦꬄዳ ጋላስ ደርያ ቦላን ታማ ግዶን ግዲደ፥ መꬍና ጎዳይ ህንተንቶ ሃሳዬዳ ቃላቱ ኡባይ ጻፈት ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","ሄ ኦይታሙ ጋላሳፐነ ኦይታሙ ቃማፐ ጉይያን፥ መꬍና ጎዳይ ባረ ጫቁ ጻፈቴዳ ላኡ ማሰቴዳ ሹቻቱዋ ታዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","“ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ታና ሀዋዳን ያጌዳ፤ ‘ሀዋፐ ኤለካ ዎꬋ፤ አያዉ ጎፐ፥ ኔን ግብጼፐ ከሴዳ ነ አሳይ ቱን ክቼዳ፤ ታን ኡንቱንታ አዛዜዳ አዛዙዋፐ ኤለካ ዎራ ስሚደ፥ ሲልሲደ መꬌዳ ኤቃ ባረንቶ ጎይናናዉ ጊግሴድኖ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","“መꬍና ጎዳይ ቃይካ ታና፥ ‘ታን ሀ አሳ በኣድ፤ ኡንቱንቱ ቱሙካ ሞርግያ ዞዛ አሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","ያቶፐ፥ ታን ኡንቱንታ ꬋይሳናዋነ ኡንቱንቱ ሱንꬃካ ሳሉዋፐ ጋርሳ ባጋፐ ቁጫናዋ ታና ድጎፓ። ያታደ ኔና ኡንቱንቱፐ ምንያነ ጮራትያ ካዉተꬃ ከሳና’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","“ታን ጫቁዋ ቃላይ ጻፈቴዳ ላኡ ማሰቴዳ ሹቻቱዋ ላኡ ኩሽያን ቶካደ ደርያፐ ዎꬋአድ፤ ሄ ዎደ ደርያ ቦላ ታማ ላጩ ቤቴ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","ታ ጼልያ ዎደ፥ ህንተ መꬍና ጎዳ ህንተ ጾሳ ቦላ ናጋራ ኦꬄዳዋ በኣድ፤ ህንተ ሲልሲደ መꬌዳ ኮሩማ ምስልያ ህንተንቶ ኤቃ ኦꬂደ ጊግሴድታ። ህንተ መꬍና ጎዳይ ህንተና አዛዜዳ ኦግያፐ ኤለካ ዎራ ስሜድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","ያትና፥ ታን ታ ላኡ ኩሽያን ኦይቄዳ ላኡ ማሰቴዳ ሹቻቱዋ ኦላደ፥ ህንተ ጼልሽን መንꬃድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","“ሄዋፐ ጉይያን፥ ታን ህንተ ኦꬄዳ ናጋራ ኡባ ድራዉ፥ ሄዌነ መꬍና ጎዳ ሀንቀꬃናዉ ህንተ አ ስንꬃን ኢታባ ኦꬄዳ ድራዉ፥ ካሰዋዳንካ ኦይታሙ ጋላሳነ ኦይታሙ ቃማ መꬍና ጎዳ ስንꬃን ጉፋናደ ጋምኣድ፤ ሄ ዎደ ታን ቁማ ማበይከ፤ ሃꬃካ ኡሻበይከ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","መꬍና ጎዳይ ህንተ ቦላን ሀንቀቴዳ አ ኤጽያ ሀንቆ ታን ያያድ፤ አያዉ ጎፐ፥ እ ህንተና ꬋይሳናዉ ጊጌዳ፤ ሽን መꬍና ጎዳይ ዛረꬂደካ ታዉ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","ቃይ መꬍና ጎዳይ አሮናካ ꬋይሳናዉ ሎይꬅ ሀንቀቴዳ፤ ያትና፥ ሄ ዎደ ታን አሮናዉካ ዎሳድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","ታን ህንተ መꬌዳ ሄ ናጋራን ኩሜዳ ኮሩማ ምስልያ አካደ፥ ታማን ጹጋድ፤ ያታደ አ ክንቼሬꬃደ እ ባናዳን ሊቃና ጋካናዉ ጋጫድ፤ ሄ ባና ደርያፐ ጎግያ ሃꬃን ኦላድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“ህንተ ቃይካ ታብኤራን፥ ማሳሃንነ ቅብሮተ-ሀታዋን (አሙዋ ዱፉዋን) መꬍና ጎዳ ሀንቀꬄድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","መꬍና ጎዳይ ህንተና፥ ‘ቢተ፥ ታን ህንተንቶ እሜዳ ቢታ ላትተ’ ያጊደ፥ ቃዴሳ-ባርነፐ የዴዳ ዎደካ፥ ህንተ መꬍና ጎዳ ህንተ ጾሳ አዛዙዋ እጺደ ማካሌድታ፤ አን አማነትበይክታ ዎይ አ ቃላዉካ አዛዘትበይክታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","ታን ህንተና ኤሮደፐካ ዶሚደ፥ ህንተ መꬍና ጎዳ ቦላን ማካላንቻ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","“መꬍና ጎዳይ ህንተና ꬋይሳና ጌዳ ድራዉ፥ ታን ሄ ኦይታሙ ጋላሳነ ኦይታሙ ቃማ መꬍና ጎዳ ስንꬃን ጉፋናደ ጋምኣድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","ታን መꬍና ጎዳ ሀዋዳን ያጋደ ዎሳድ፤ ‘አቤት ኡባ ሞድያ መꬍና ጎዳዉ፥ ኔን ነ ዎልቃማ ዎልቃን ዎዜዳነ ነ ምኖ ኩሽያን ግብጼፐ ከሴዳ፥ ነዉ ላታ ግድያ ነ አሳ ꬋይሶፓርኪ! ");
INSERT INTO dwrENT_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","ነ ቆማቱዋ፥ አብራሃማ ይሳቃነ ያቆባ ቆፓ፤ ሀ አሳ ሞርግያ ዞዱ ኦꬅያዋ፥ ኡንቱንቱ ኢታተꬃነ ኡንቱንቱ ናጋራ ፓይዶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","ሄዌ ꬋዮፐ፥ ኔን ኑና ያፐ ከሴዳ ግብጼ ቢታ አሳይ፥ “መꬍና ጎዳይ ኡንቱንታ ገልሳና ጌዳ ቢታ ገልሳናዉ ዳንዳይቤና ድራዉነ ኡንቱንታ እጼዳ ድራዉ፥ መላ ቢታን ዎꬋና ጊደ ከሴዳ” ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","ግዶ ሽን፥ ሀ አሳይ ኔን ነ ዎልቃማ ዎልቃንነ ነ ምጨቴዳ ቀስያን ግብጼፐ ከሴዳ ነ ላታ ግድያ ነ አሳቴ’ ያጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","“ሄ ዎደ መꬍና ጎዳይ ታና ሀዋዳን ያጌዳ፤ ‘ኮይሮዋንቱ ማላ ላኡ ማሰቴዳ ሹቻቱዋ ጊግሳ። ያታደ ታኮ ደርያ ሃ ፑደ ከሳ፤ ቃይ ምꬃ ታቦታካ መꬋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","ካሰ ኔን መንꬄዳ ማሰቴዳ ሹቻቱ ቦላ ደእያ ቃላቱዋ ሀ ማሰቴዳ ሹቻቱ ቦላ ታን ጻፋና፤ ኔንካ ኡንቱንታ ታቦታ ግዶን ዎꬃሳ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","“ታን ኦዶሩዋፐ ታቦታ መꬋድ። ካሰዋንቱ ማላ ላኡ ማሰቴዳ ሹቻቱዋካ ጊግሳድ፤ ያታደ ሄ ላኡ ማሰቴዳ ሹቻቱዋ ታ ኩሽያን ኦይቃደ፥ ደርያ ፑደ ከሳድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","ህንተ ሺቁዋ ኦꬄዳ ጋላስ፥ ደርያ ቦላን ታማ ግዶፐ መꬍና ጎዳይ ህንተንቶ ኦዴዳ ቃላቱዋ፥ ሄዋንቱካ ታሙ አዛዞቱዋ፥ ካሰ ጻፌዳዋዳንካ ሀ ማሰቴዳ ሹቻቱ ቦላ መꬍና ጎዳይ ጻፌዳ፤ ያቲደ እ ኡንቱንታ ታዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","ሄዋፐ ጉይያን፥ ታን ደርያፐ ዱገ ዎꬋደ፥ መꬍና ጎዳይ ታና አዛዜዳዋዳን፥ ሄ ማሰቴዳ ሹቻቱዋ ታን መꬌዳ ታቦታ ግዶን ዎꬃድ፤ ሀእካ ኡንቱንቱ ያን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","“እስራኤልያ አሳይ ያእቃና አሳቱ ሃꬃ ኦላይ ደኢያሳፐ ደንዲደ፥ ሞሰር ቤድኖ። አሮን ያን ሀይቂደ ሞገቴዳ፤ አ ናአይ ኤልኣዛር አ ላቲደ፥ አ ሳኣን ቄስያ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","ኡንቱንቱ ሄዋፐ ጉድጎዳ ግያሳ ቤድኖ፤ ያፐ ቃይ ጎግያ ሃꬃቱ ደእያ ቢታ ዮጽባታ ግያሳ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","ሄ ዎደ፥ መꬍና ጎዳ ጫቁዋ ታቦታ ቶካና ማላ፥ መꬍና ጎዳዉ ኦꬃና ማላ፥ አ ስንꬃን ኤቃና ማላነ፥ ሀች ጋካናዉካ ኡንቱንቱ ኦꬅያዋዳን መꬍና ጎዳ ሱንꬃን አንጃና ማላ፥ ሌዊያ ዛራቱዋ መꬍና ጎዳይ ባረዉ ዱማዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","ሄዋ ድራዉ፥ ኡንቱንቱ እሻቱዋና ሻክና፥ ኡንቱንታ ጋክያባይ ዎይ ላታይ ሌዊያ ዛረቶ ባዋ፤ መꬍና ጎዳይ ህንተ ጾሳይ ኡንቱንቶ ኦዴዳዋዳንካ፥ ኡንቱንቱ ላታይ መꬍና ጎዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","“ታን ካሰዋዳንካ ኦይታሙ ጋላሳነ ኦይታሙ ቃማ ደርያ ቦላን ጋምኣድ፤ መꬍና ጎዳይ ሀእካ ታ ዎሳ ስሲደ፥ ህንተና ꬋይሳናዉ ኮይቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","መꬍና ጎዳይ ታና፥ ‘ታን እማና ጋደ ኡንቱንቱ አዋቶ ጫቃ ዎꬄዳ ቢታ ኡንቱንቱ ገላናዳንነ ላታናዳን፥ ሀ አሳፐ ስንꬃና ኡንቱንታ ካለꬃ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“እስራኤልያ አሳዉ፥ መꬍና ጎዳ ህንተ ጾሳይ ህንተፐ ኮይያዌ ሀዋ: መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ያይተ፤ አ ኦግያን ኡባን ሀመትተ፤ አ ሲቅተ፤ ህንተ ኩመንꬃ ዎዛናፐነ ኩመንꬃ ሸምፑዋፐ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","ህንተዉ ሎአናዳን፥ ታን ሀች ህንተንቶ እምያ መꬍና ጎዳ አዛዞቱዋነ አዋዮቱዋ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","“ሳሉነ ሳሉዋፐ ቦላና ደእያ ሳሎቱ፥ ቃይ ሳአይነ ሳኣን ደእያ ኡባባቱ ጾሳ ህንተ መꬍና ጎዳባቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","ግዶፐነ መꬍና ጎዳይ ህንተ ማይዛ አዎቱዋን ናሸቲደ፥ ኡንቱንታ ሲቄዳ፤ ቃይ ሀች ህንተ በእያዋዳን፥ ኡንቱንቱፐ ጉይያን ኡንቱንቱ ዘረꬃቱዋ ግድያ ህንተና ካዉተꬃቱዋ ኡባፐ ዶሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","ሄዋ ድራዉ፥ ህንተ ዎዛና ሾኩዋ ቃጻርተ፤ ቃይ ሀዋፐ ስንꬃናዉ ሞርግያ ዞዛ ግዶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ጾሳቱዋ ጾሳነ ጎዳቱዋ ጎዳ። እ ዎልቃማ ጾሳ፤ እ ዎልቃማነ ያሽያ ጾሳ። እ ዴሙዋ ጼል ፕርደናዋነ ማጋንጻ አከናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","እ አዉ ባይና ናናቶነ አምኤቶ ኡንቱንቱ ፕርዳ ከሴ፤ በትያካ ሲቂደ፥ ቁማነ ማዩዋ አዉ እሜ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","ህንተካ በተቱዋ ሲቅተ፤ አያዉ ጎፐ፥ ህንተ ህንተ ሁጲያዉካ በተ ግዲደ ግብጼን ደኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ያይተ፤ አዉ ኦꬅተ፤ አናና ኦይቀትተ፤ አ ሱንꬃንካ ጫቂተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","ህንተ ህንተ አይፍያን በኤዳ ሄ ግታነ ያሽያ ማላልስያባቱዋ፥ ህንተንቶ ኦꬄዳዌ እ ህንተ ጋላታቴ፤ ቃይ ህንተ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","ግብጼ ቢታ ዎꬌዳ ህንተ ማይዛ አዎቱ ኡባና ላፑን ታማ፤ ሀእ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ሳሉዋ ጾልንተቱዋዳን ጮራዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","“ስም መꬍና ጎዳ ህንተ ጾሳ ሲቅተ፤ እ ህንተፐ ኮይያ አ አዋዮቱዋ፥ አ ህገቱዋነ አ አዛዞቱዋ፥ ኡባ ዎደ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","መꬍና ጎዳ ሴራ ህንተ ኤሬዳዋ ኬና አባ ህንተ ታማሬዳዋ ኡባ ሀች ሀሳይተ፤ ሄዋ ኤርያዋንቱ ህንተናፐ አትና፥ ህንተ ናናቱዋ ግድክኖ፤ መꬍና ጎዳ አንጋ፥ አ ዎልቃማ ኩሽያነ አ ምጨቴዳ ቀስያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","እ ኦꬄዳ ማላታቱዋነ እ ግብጼ ካትያ ቦላነ አ ቢታ ኡባ ቦላ ኦꬄዳዋ በኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","ቃይ ኡንቱንቱ ህንተና ካሊደ የደርሴዳ ዎደ፥ መꬍና ጎዳይ ግብጼ ቢታ ኦላንቻቱዋ፥ ኡንቱንቱ ፓራቱዋነ ፓራ ጋረቱዋ ዞኦ አባን ምትሲደ፥ ሀች ጋካናዉ፥ ኡንቱንታ ኡባና ꬋይሴዳዋ በኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","ህንተ ሀ ሳኣ ጋካናዉ፥ መላ ቢታን ጾሳይ ህንተንቶ ኦꬄዳዋ ህንተ ኤሪታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ቃይ ሮቤላ ዛርያፐ ኤልኣባ ናናቱዋ ግድያ ዳታና ቦላነ አቢራማ ቦላ ጾሳይ ኦꬄዳዋ ሀሳይተ። እስራኤልያ አሳይ ኡባይ ጼልሽን፥ ቢታይ ዶየቲደ፥ ኡንቱንታ፥ ኡንቱንቱ ሶ አሳ፥ ኡንቱንቱ ዱንካንያነ ኡንቱንቶ ደእያ ሸምፑዋና ደእያዋ ኡባ ምቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","ኤ! መꬍና ጎዳይ ኦꬄዳ ሀ ዎልቃማ ኦሶ ኡባ ህንተ አይፍያን በኤዳዋንቱ ህንተና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","“ሄዋ ድራዉ፥ ህንተ ምኖ ግዳናዳንነ ዮርዳኖሳ ፕኒደ ህንተ አካናዉ ብያ ቢታ ህንተ ላታናዳን፥ ታን ሀች ህንተና አዛዝያ አዛዙዋ ኡባ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","ያቶፐ፥ መꬍና ጎዳይ ህንተ ማይዛ አዋቶነ ኡንቱንቱ ዛረቶ እማና ጊደ ጫቄዳ፥ ማꬃይነ ኤሳይ ጎግያ ጋድያን ህንተ አዱሳ ላይꬃ ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","ህንተ ላታናዉ ገልያ ቢታይ ህንተ ከሲደ ዬዳ ግብጼ ቢታ ማላ ግደና፤ ግብጼን ህንተ ካꬃ ዘሪደ፥ ሾይቃ ኡባ አታክልትያ ሳኣዳን ገድያን ሃꬃ ኡሺታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","ሽን ዮርዳኖሳ ፕኒደ ህንተ ላታናዉ ብያ፥ ቢታይ ዞዘቱነ ዛንጋራቱ ደእያ፥ ሳሉዋ እራን አልያ ቢታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","ሄ ቢታይ መꬍና ጎዳይ ህንተ ጾሳይ ጾሞስያ ቢታ፤ ላይꬃ ዶመꬃፐ ቢደ ላይꬃ ዉርሰꬃ ጋካናዉ፥ መꬍና ጎዳ ህንተ ጾሳ አይፊ አ ቦላን ደእያ ቢታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“ሄዋ ድራዉ፥ ህንተ መꬍና ጎዳ ህንተ ጾሳ ሲቃናዳንነ ህንተ ህንተ ኩመንꬃ ዎዛናፐነ ህንተ ኩመንꬃ ሸምፑዋፐ አዉ ኦꬃናዳን፥ ታን ህንተንቶ ሀች እምያ አዛዞቱዋ ህንተ ፖሎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ህንተ ካꬃ፥ ዎይንያነ ዛይትያ ፓጨናን ሺሻና ማላ፥ ኦፍንꬃ እራነ ባልጉዋ እራ፥ አ ዎድያን ዎድያን ጾሳይ ህንተ ጋድያን ቡክሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","ጾሳይ ህንተ መህያዉ ደምባን ማታ ዳርሳና። ቃይ ህንተካ ማናነ ካላና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","“ህንተ ዎዛናይ ባልና ዎራ ስሚደ፥ ህንተ ሀራ ጾሳቶ ኦናዳንነ ኡንቱንቶ ጎይነናዳን ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","ሄዌ ꬋዮፐ፥ መꬍና ጎዳ ሀንቁ ህንተ ቦላ ኤጽ ከሳና፤ እራይ ቡከናዳንነ ቢታይካ ሞከናዳን እ ሳሉዋ ጎርዳና፤ ህንተካ መꬍና ጎዳይ ህንተንቶ እምያ ሎኦ ጋድያፐ ኤለካ ꬋያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","“ስም፥ ሀ አዛዞቱዋ ታዋንታ፥ ህንተ ዎዛናንነ ህንተ ቆፋን ዎꬅተ። ማላታዳን ኡንቱንታ ህንተ ኩሽያን ቃችተ፤ ቃይ ማላታዳን ህንተ ሶምእያንካ ዎꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","ሄዋንታ ህንተ ናናቱዋካ ታማርስተ። ህንተ ሶን ደእያ ዎደ፥ ኦግያን ሀመትያ ዎደ፥ ግስያ ዎደነ ደንድያ ዎደካ፥ ኡንቱንቶ ኦድተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","ህንተ ፐንግያ ቆስለꬃቱዋ ቦላንነ ህንተ ድርሳ ፐንግያ ቦላን ህንተ ኡንቱንታ ጻፍተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ያቶፐ፥ መꬍና ጎዳይ ህንተ ማይዛ አዋቶ እማና ጊደ ጫቄዳ ጋድያን ህንተ ላይꬃይነ ህንተ ናናቱ ላይꬃይ ሳኣፐ ቦላና ደእያ ሳሉ ደእያዋ ኬሻ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","“ህንተ መꬍና ጎዳ ህንተ ጾሳ ሲቃናዳን፥ አ ኦገ ኡባን ሀመታናዳንነ አዉ አማነታናዳን፥ ታን ሀች ህንተንቶ እምያ አዛዞቱዋ ህንተ ምንሲደ ናጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","መꬍና ጎዳይ ሀ ካዉተꬃቱዋ ኡባ ህንተ ስንꬃፐ የደርሲደ ከሳና፤ ህንተካ ህንተፐ ግታትያነ ዎልቃምያ ካዉተꬃቱዋ ቢታ ዎꬅ አካና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","ህንተ ገድያን ህንተ የꬌዳ ቢታ ኡባይ ህንተሳ ግዳናዋ። ህንተ ዛዋይ መላ ቢታፐ ቢደ ሊባኖሳ ጋካናዉነ ኤፍራጺሳ ሻፋፐ ቢደ አዋይ ዉልያ ባጋ ሜድተራነ አባ ጋካናሳ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","ህንተናና አይ አሳይነ ኤቀታናዉ ዳንዳየና፤ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ ጌዳዋዳን፥ ህንተ ብያሳን ኡባን አሳይ ህንተና በኢደ ዳጋማናዳንነ ህንተዉ ያያናዳን ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“በእተ፥ ሀች ታን ህንተ ስንꬃን አንጁዋነ ሸቃ ዎꬃይ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","ታን ሀች ህንተና አዛዝያ መꬍና ጎዳ ህንተ ጾሳ አዛዞቱዋ ናጎፐ፥ ህንተ አንጀታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","ሽን ታን ህንተና ሀች አዛዝያ መꬍና ጎዳ ህንተ ጾሳ አዛዞቱዋ ናገናን እጺደ፥ ህንተ ኤርቤና ሀራ ጾሳቶ ጎይናናዉ አ ኦግያፐ ዎራ ስሞፐ፥ ህንተ ሸቀታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ላታናዉ ብያ ቢታ ህንተና ገልስያ ዎደ፥ ጋሪዛማ ደርያን አንጁዋ ኤባላ ደርያ ቦላን ሸቃ አዋያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","ሀ ላኡ ደረቱ ዮርዳኖሳ ሻፋፐ ሄፍንꬃና ኦግያፐ አዋይ ዉልያ ባጋን፥ አራባን ደእያ ካናነቱዋ ጋድያን ደኢኖ፤ ኡንቱንቱ ቃይ ገልጋላ ካታማ ስንꬃን ደእያ ሞረ ምꬃዉካ ማታን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","ህንተ ሀእ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ቢታ ላታናዉ ዮርዳኖሳ ሻፋ ፕናና ሀኒታ። ህንተ ሄ ቢታ አኪደ ያን ደእያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","ታን ሀች ህንተንቶ እምያ አዋዮቱዋነ ህገቱዋ ኡባ ምንሲደ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“ህንተ ላታናዳን፥ መꬍና ጎዳይ ህንተ አዎቱዋ ጾሳይ ህንተንቶ እሜዳ ጋድያን ህንተ ደኤዳ ኬሻን ኡባን ህንተ ባለናን ኦꬃና አዋዮቱነ ህገቱ፥ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","ህንተ ላትያ ካዉተꬃቱ ደርያ ቦላን፥ ዞዚያ ቦላንነ ምꬃቱዋ ጻጱዋን ባረንቱ ጾሳቶ ጎይንያ ሳኣ ኡባ ኡባና ꬋይስተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","ኡንቱንቱ ያርሽያ ሳኣ ኮልተ፤ ኡንቱንቱ ጎይንያ ሹቻቱዋካ መንሬꬅተ፤ አሼሮ ግያ ኡንቱንቱ ጾሳት ምስልያ ታማን ጹግተ፤ ማሰቴዳ ኡንቱንቱ ጾሳቱዋ ምስለቱዋ ꬋይስተ፤ ኡንቱንቱ ሱንꬃቱዋካ ሄ ሳአቱዋፐ ቁጭ ድግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","“መꬍና ጎዳ ህንተ ጾሳዉ ኡንቱንቱ ባረንቱ ጾሳዉ ጎይንያዋዳን ጎይኖፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","መꬍና ጎዳይ ህንተ ጾሳይ ዛረ ኡባይ ደኢያሳፐ ባረ ሱንꬃይ ሄዋን ጼሰታናዳን ዶሬዳ ሳኣ ኮይተ። ሄ ሳኣ ህንተ ባናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","ህንተ ህንተ ጹግያ ያርሹዋ፥ ሀራ ያርሹዋ፥ ህንተ አስራታ፥ ህንተ እሙዋ፥ ህንተ ሺቁዋ፥ ህንተ ዶሲደ እምያ እሙዋ፥ ህንተ መህያነ ዶርሳፐ ባይራ ሄ ሳኣ አህተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","ሄዋን መꬍና ጎዳይ ህንተ ጾሳይ ደእያ ሳን ህንተነ ህንተ ሶ አሳይ ማና፤ ቃይ ህንተ ኩሺ ኦꬄዳባን ኡባንነ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አንጄዳባን ህንተ ናሸታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","“ሀእ ሀዋን ህንተ ኦꬅያዋዳን፥ ሄ ዎደ ህንተ አይፍያን ሎአ ማላትያባ ኦꬅክታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ሸምፖ ቢታ ብሮን ጋክበይክታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","ሽን ህንተ ዮርዳኖሳ ፕኒደ፥ መꬍና ጎዳይ ህንተ ጾሳይ እምያ ሄ ቢታ ላቲደ፥ ህንተ ያን ኡታና። ህንተና ዶዴዳ ሞርከቱዋፐ ህንተና እ ሸምፕስያ ድራዉ፥ ህንተ ዎፑ ጊደ ሄዋን ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","ሄ ዎደ መꬍና ጎዳይ ህንተ ጾሳይ ባረ ሱንꬃይ ሄዋን ጼገታናዉ ዶሬዳ ሄ ሳኣ፥ ታን ህንተና አዛዝያዋ ኡባ፥ ጹግያ ያርሹዋ፥ ሀራ ያርሹዋ፥ ህንተ አስራታ፥ ህንተ እሙዋነ ህንተ መꬍና ጎዳዉ ሺቄዳዋ ኡባ ሄዎ አሂታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","ህንተ፥ ህንተ አቱማነ ማጫ ናናይ፥ አቱማነ ማጫ ቆማቱነ ህንተናና ላታ አክቤና ህንተ ካታማን ደእያ ሌዋቱዋናካ እትፐ ሄዋን መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ናሸትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","ህንተ ጹግያ ያርሹዋ ህንተ ኮዬዳ ሀቃንነ ጮ ያርሸናዳን ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","ህንተ ህንተ ዛራቱ ደኢያሳ ኡባፐ እቱዋን፥ መꬍና ጎዳይ ዶሬዳ ሳኣን ህንተ ጹግያ ያርሾ ያርሽተ፤ ታን ህንተና አዛዝያዋ ኡባካ ሄዋን ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","“ሽን ህንተ ደእያ ሳን ሀቃንነ ህንተ መህያፐ መꬍና ጎዳይ ህንተና አንጄዳዋዳን ሹኪደ ሚተ፤ ዎጋን ጌሻ አሳ ግድና ዎይ ጌየና አሳ ግድናካ ኡባይካ ጋራ አሹዋነ ገንእያ አሹዋ ምያዋዳን ህንተ መህያፐ ሹኪደ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","ሽን ሱꬃ ሃꬃዳን ሳኣን ጉስተፐ አትና ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","“ህንተ ህንተ ካꬃፐ፥ ዎይንያፐነ ዛይትያፐ እምያ አስራታ፥ ህንተ መህያፐነ ዶርሳ ዉድያፐ ባይራ፥ ጾሳዉ እማናዉ ሺቄዳዋ ኡባነ ህንተ ህንተ ዶሱዋን ጮ እምያ እሙዋ ኡባ ህንተ ደእያ ሄራን ሙለካ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","ሽን ህንተ፥ ህንተ አቱማነ ማጫ ናናይ፥ ህንተ አቱማነ ማጫ ቆማቱነ ህንተ ካታማቱዋን ደእያ ሌዋቱዋናካ እትፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ዶሬዳ ሳኣን መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ሀ ያርሹዋ ኡባቱዋ ሚተ፤ ሄዋን ህንተ ዳቡራን ሺሼዳዋን መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ናሸትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","ህንተ ህንተ ጋድያን ደእያ ላይꬃ ኡባን ሌዋቱዋ ሸነኮ ጌናዳን ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“እ ህንተንቶ ገሌዳ ቃላዳን መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ዛዋ አስያ ዎደ፥ ህንተና አሹዋ ማናዉ ኮሽያ ዎደ፥ ህንተ ኮዬዳ ኬና ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","ሽን መꬍና ጎዳይ ህንተ ጾሳይ ባረ ሱንꬃይ ሄዋን ጼሰታናዳን ዶሬዳ ሄ እት ሳአይ ህንተንቶ ሃኮፐ፥ መꬍና ጎዳይ ህንተንቶ እሜዳ ህንተ መህያ ዎይ ዶርሳ ዉድያፐ ሀቃዋ ግድናካ፥ ታ ህንተና አዛዜዳዋዳን፥ ህንተ ኮዬዳ ኬና ህንተ ካታማን ሹኪደ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","ዎጋን ጌሻ አሳ ግድና፥ ዎይ ጌየናዋ ግድናካ፥ አይ አስካ ጋራ ግድና፥ ገንእያ አሹዋ ካሰ ምያዋዳን ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","ሽን ሱꬃይ ደእያ አሹዋ ሜናዳን ናገትተ፤ አያዉ ጎፐ፥ ሸምፑ ሱꬃን ደኤ፤ ሄዋ ድራዉ፥ ደኡዋ አሹዋና ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","ሱꬃ ሃꬃዳን ጋድያን ጉስተፐ አትና ኡሾፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","ህንተ መꬍና ጎዳ ስንꬃን ህንተ ሎኦባ ኦꬅያዌ ህንተዉ፥ ህንተፐ ጉይያን፥ ህንተ ናናቶካ ሎኦ ግዳና ማላ፥ ሱꬃ ኡሾፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","“ሽን ህንተ ዱማዬዳዋነ ሺቄዳዋ አኪደ፥ መꬍና ጎዳይ ዶሬዳ ሳአዉ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","ቢደ ህንተ ጹግያ ያርሹዋ፥ አሹዋነ ሱꬃ፥ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ያርሽያሳን ሺሽተ፤ ህንተ ያርሹዋ ሱꬃ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ያርሽያ ሳኣ ማታን ጉስተ፤ አሹዋ ህንተ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","ታን ህንተና አዛዝያ ዎጋ ምንሲደ ናግተ፤ ሄዋ ኦꬆፐ፥ ህንተንቶነ ህንተ ናናዉ ሎአ ግዳናዋ፤ አያዉ ጎፐ፥ ህንተ ልከባነ መꬍና ጎዳ ህንተ ጾሳ ናሸችያ ሎኦባ ኦꬂታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","“ህንተ ላታናዉ ብያ ካዉተꬃ መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ስንꬃፐ ꬋይስያ ዎደነ ህንተካ ኡንቱንቱ ቢታ ላቲደ ደእያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","ኡንቱንቱ ህንተ ስንꬃፐ ꬋይክችና ህንተ ኡንቱንታ ካላናዉ፥ ኡንቱንታ ጲርያን ኦይቀተናዳን ናገትተ፤ ‘ኑንካ ኡንቱንቱዳን ጎይናናዉ፥ ሀ ካዉተꬃቱ ባረንቱ ጾሳቶ ዎት ጎይኒኖ’ ያጊደ፥ ካል ኦቼናዳን ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","ኡንቱንቱ ባረንቱ ጾሳቶ ጎይንያ ዎደ፥ መꬍና ጎዳይ እጽያ ቱናባ ኡባ ኦꬅያ ድራዉ፥ ህንተ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ሄዋዳን ጎይናናዉ በሰና። አያዉ ጎፐ፥ ኡንቱንቱ ሀራይ አቶ ባረንቱ የሌዳ አቱማነ ማጫ ናናቱዋ ባረንቱ ጾሳቶ ያርሺደ፥ ታማን ጹጊኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","“ስም ህንተ ታ ህንተና አዛዜዳዋ ኡባ ኦꬅተ፤ አ ቦላ አያነ ጉጆፕተ፤ አፐ አያነ ፓጭሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","“ህንተ ግዶን ትምቢትያ ኦድያዌ ዎይ አኩሙዋ ብልያ አሳይ ደንዲደ፥ ማላታነ ማላልስያባ ኦꬆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","እ ኦዴዳ ማላታይ ዎይ ማላልስያባይ ቱሙ ግዲደ ፖለትና፥ እ ህንተና፥ ‘አነ ካሰ ህንተ ኤረና ሀራ ጾሳቶ ጎይኖይተ’ ያጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ህንተ አ ሙለካ ስሶፕተ። ህንተ አ ኩመንꬃ ዎዛናፐነ ኩመንꬃ ሸምፑዋፐ መꬍና ጎዳ ህንተ ጾሳ ዶስንቶነ ጊደ፥ ህንተና እ ፓጫናዉ ሄዋ ኦꬄ። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","መꬍና ጎዳ ህንተ ጾሳ ካልተ፤ አዉ ያይተ፤ አ አዛዙዋ ናግተ፤ አ ቃላካ ስስተ፤ አዉ ጎይንተ፤ አፐ ዱጾፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","ህንተና ግብጼፐ ከሲደ፥ አይለተꬃፐ ህንተና ዎዜዳ መꬍና ጎዳ ህንተ ጾሳ ቦላ ህንተ ማካላናዳን ታማርስያ ትምቢትያ ኦድያዋ፥ ዎይ አኩሙዋ ብልያዋ ዎꬍተ፤ ሄዋ ማላ አሳይ ህንተና መꬍና ጎዳ ህንተ ጾሳ አዛዙዋፐ ዎራ ባናዳን ኦꬅያ ድራዉ፥ ሄዋ ማላ ዎꬊደ፥ ኢታ ህንተ ግዶፐ ድግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","“ሀራይ አቶ ነ ዳይ ናአይ ነ እሻይ፥ ነ አቱማነ ማጫ ናእ፥ ነ ሲቅያ ነ ማቻታ፥ ዎይ ነ ሲቆ ላጊ ኔና፥ ‘ደንዳ፥ ካሰ ኔንነ ነ ማይዛ አዎቱ ጎይን ኤረና ጾሳዉ ጎይናና’ ጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","ቢታዉ ሀ ጋጻፐ ያ ጋጻ ጋካናዉ ደእያ፥ ነ ዩሹዋ ኡባን ማታንነ ሃኩዋን ደእያ አሳይ ኡባይ ጎይንያ ጾሳቶ፥ ‘ደንዳ ቢደ ኡንቱንቶ ጎይናና’ ጊደ ባለꬆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","አዉ ኤኖ ጎፓ፤ እ ግያዋካ ስሶፓ። አዉ ቃረታደ አ ጉየ አሾፓ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","አ ዎꬋናዉ ኮሼ። አ ዎꬋናዉ ኮይሮ ነ ዶማ፤ ሄዋፐ ጉይያን፥ አሳይ ኡባይ ባረ ኩሽያ አ ቦላ ዎꬂደ ዎꬎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","እ ሀይቃና ጋካናዉ፥ ሹቻን ጫድተ፤ አያዉ ጎፐ፥ እ ህንተና ግብጼ ጋድያፐ፥ አይለተꬃ ጎልያፐ ከሴዳ መꬍና ጎዳፐ፥ ህንተ ጾሳፐ፥ ህንተና ሻካናዉ ኮዬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","እስራኤልያ አሳይ ኡባይ ሄዋ ስሲደ ያያና፤ ቃይ ሄዋ ማላ ኢታባካ ላኤንꬆ ህንተ ግዶን ኦንነ ኦና። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ደአናዳን እምያ ካታማፐ እቱዋን ህንተ ደእያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","ህንተ አሳ ግዶን ኢታቱ ደንዲደ፥ አሳ፥ ‘ደንድተ! ቢደ ህንተ ኤረና ጾሳቶ ጎይኔቶ’ ያጊደ ባለꬅያዋ ስሶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","ሄ የዉዋባ ኦችተ፤ ምንሲደ ፓይድተ። ቆርና ሄ ህንተ ግዶን ቱናባይ ኦሰቴዳዌ ቱማ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","ሄ ካታማን ደእያ አሳ ኡባ ማሻ ቃራን ዉርስተ፤ ሄ ካታማነ አን ደእያ መህያናካ አሸናን ꬋይስተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","ሄ ካታማፐ ህንተ አኬዳ ኦሞዱዋ ኡባ ካታማ ዳባባ ሺሽተ። ሄ ካታማነ አ ኦሞዱዋ ኡባ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ጹግያ ያርሹዋ ኦꬂደ ዉርስ ጹግተ። እ መꬍናዉካ ላኤንꬆ ኬጸተና፤ ላለቴዳ ሳ ግዲደ፥ ሄ ሳአይ አታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","ቱና ጌተቴዳ ሚሻፐ አያይነ ህንተ ኩሽያን ቤቶፖ። ያቶፐ፥ መꬍና ጎዳይ ባረ ዎልቃማ ሀንቁዋፐ ስሚደ፥ ህንተና ማራና፤ እ ህንተንቶ ቃረታና። ካሰ ህንተ ማይዛ አዋቶ ጫቄዳ ጫቁዋዳን፥ ህንተ ፓይዱዋ ዳርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","አያዉ ጎፐ፥ ታን ሀች ህንተና አዛዝያ አዛዞ ኡባ ህንተ ናግያዋን መꬍና ጎዳዉ፥ ህንተ ጾሳዉ አዛዘቶፐ፥ ቃይ መꬍና ጎዳ ህንተ ጾሳ ስንꬃንካ ልከ ግድያባ ኦꬆፐ፥ ሄ ጌዳዌ ህንተንቶ ቱሙ ፖለታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","“ህንተ መꬍና ጎዳ ህንተ ጾሳ ናናቱዋ፤ ህንተ ሀይቄዳ አሳዉ ህንተና ጎምኦሮፕተነ ስንꬃ ባጋ ሁጲያ ሜዶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","አያዉ ጎፐ፥ ህንተ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ጌሻ አሳ፤ መꬍና ጎዳይ ህንተና ባረዉ አልኦ ሚሻ ግዳናዳን፥ ጋድያን ደእያ አሳ ኡባፐ ዶሪደ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","“ህንተ ቱናባ አያነ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","ህንተ ማና መሄቱነ ዶአቱ ሀዋንታ፤ ቦራ፥ ዶርሳ፥ ዴሻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","ገንእያ፥ ዶግያ፥ ዋሻ፥ ዎራ ዴሻ፥ ጮጎሹዋ፥ ጋራነ ደርያ ዶርሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","ጹጉንꬃይ ዉር ጳልቀቴዳዋንታ፥ ዋሞትያ መሄቱዋነ ዶአቱዋ ኡባ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","ሽን ዋሞትያዋንታ ግዲደ፥ ጹጉንꬃይ ጳልቀትቤናዋንታ ሞፕተ፤ ሄዋንቱካ ጋሉዋ፥ ሀርባይንያነ ጉፓልያ። ሀዋንቱ ዋሞቲኖ፤ ሽን ኡንቱንቱ ጹጉንꬃይ ጳልቀትቤና ድራዉ፥ ኡንቱንቱ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","ጉዱንꬃይካ ጹጉንꬃይ ጳልቀꬃ ግዶፐነ ዋሞተና ድራዉ፥ እ ህንተንቶ ቱና። አ አሹዋ ሞፕተ፤ አ ባኩታካ ቦቾፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","“ሃꬃ ግዶን ደእያ መታቱዋ ኡባፐ ህንተ ማናዋንቱ ሀዋንታ፤ ሞልያ ማላ ቀፊነ ፖቁ ደእያ ኡባ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","ሽን ሞልያዋ ማላ ቀፊነ ፖቁ ባይና ሀቃዋነ ሞፕተ። ሄዋንቱ ህንተንቶ ቱና። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","“ጌሻ ግዴዳ ካፉዋ ኡባ ሚተ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","ሽን ካፎቱዋፐ ህንተ ሜናዋንቱ ሀዋንታ: አርጋንꬃ፥ ባዙዋ አንኩዋ፥ ካረꬃ አንኩዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ጎሉዋ፥ ጽንግልያ ዛረ ኡባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","ቁሩዋ ዛረ ኡባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","ያንቻ፥ ጫንጭያ ጉቱዋ፥ ሃꬃ ካፉዋ፥ ጋጭያ ዛርያ ኡባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","ቄር ጉቱዋ፥ ዎጋ ጉቱዋ፥ ሃꬃ ኩቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","ባዙዋ ጉቱዋ፥ ይንዱዋ፥ ጋንጋኑዋ፥ አዱሳ ቆꬊ ደእያ ሃꬃ ካፉዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ሳቢሳ ግያ ካፉዋ ዛረ ኡባ፥ ጅንጅላትያነ ሻልያ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","ቀፍያና ደእያ ቄር መታቱ ኡባይ ህንተንቶ ቱና፤ ኡንቱንታ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","ሽን ሄ ቀፍያና ደእያባቱዋፐ ጌሻ ግድያዋንታ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","“ህንተ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ጌሻ አሳ ግድያ ድራዉ፥ ባኩቴዳዋ ኡባ አያነ ሞፕተ። ሄዋ ህንተ ካታማን ደእያ በተቱ ማናዳን ኡንቱንቶ እማናዉ ዳንዳዪታ፤ ዎይ ሀራ ቢታ አሳዉ ዛልአናዉ ዳንዳዪታ። “ዴሻ ማራ አ ዳይ ማꬃን ዶይሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","“ህንተ ህንተ ጋደፐ ላይꬃን ላይꬃን ጋክያ ካꬃ አይፍያ ኡባፐ አስራታ ከስተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","ህንተ ኡባ ዎደ፥ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ያይያዋ ታማራና ማላ፥ እ ባረ ሱንꬃይ ጼሰታና ማላ ዶሬዳ ሳኣን፥ መꬍና ጎዳ ህንተ ጾሳ ስንꬃን፥ ህንተ ካꬃ፥ ዎይንያ ኤሳነ ዛይትያ አስራታ፥ ህንተ ዶርሳፐነ መህያፐ ባይራ የለቴዳዋ ሄዋን ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","መꬍና ጎዳይ ህንተ ጾሳይ ባረ ሱንꬃይ ጼሰታና ማላ ዶሬዳ ሳአይ፥ ህንተ ደኢያሳፐ ሎይꬅ ሃኮ ግዶፐ፥ መꬍና ጎዳይ ህንተና አንጃና ማላ፥ ህንተ ህንተ አስራታ ያ ቶካናዉ ዳንዳየናን እጾፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","ዛልእተ፤ ሄ ሚሻ ኩሽያን ኦይቂደ፥ መꬍና ጎዳይ ህንተ ጾሳይ ዶሬዳ ሳኣ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","ቢደ ሄ ሻሉዋን ህንተ ኮዬዳዋ ሀቃዋነ፥ ሚዛ ግድና፥ ዶርሳ ግድና፥ ዎይንያ ኤሳ ግዶ፥ ዎይ ሀራ ምኖ ኡሻ፥ ዎይ ሀራ ህንተ ኮይያዋ አያነ ሻሚደ፥ ህንተነ ህንተ ሶ አሳይ ኡባይ መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ሄዋ ሚተነ ናሸትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","“ሄዋ ህንተ ኦꬅያ ዎደ፥ ህንተ ካታማን ደእያ ሌዋቱዋ ዶጎፕተ፤ አያዉ ጎፐ፥ ኡንቱንቱ ህንተናና ግሽ አኬዳ ሀራ ላታይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","ሄዘንꬃ ላይꬃን ላይꬃን ኡባ ዎደ፥ ህንተ ካꬃ አስራታ አሂደ፥ ህንተ ካታማን ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","ሄዋ ህንተ ካታማን ደእያ ህንተናና ግሽ አኬዳ፥ ሀራ ላታይ ባይና ሌዋቱ፥ በተቱ፥ አዉ ባይና ናናቱነ አምኤ ማጫ አሳቱ ዪደ ሚኖ፤ ሚድካ ካልኖ። ያቶፐ፥ ህንተ ኦꬅያ ህንተ ኩሽያ ኦሶ ኡባን መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","“ላፑንꬃ ላይꬃ ላይꬃ ዉርሰꬃን ህንተፐ ታልኤዳዋንቶ ኡንቱንቱ አጩዋ ማርተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","ህንተ አጩዋ ማራና ዎጋይ ሀዋ: ባረ ላገ እስራኤልያዉ ታልኤዳ አይ አሳይነ ሄ አጩዋ ማሮ። መꬍና ጎዳ ማሮተꬃይ አዋየቴዳ ድራዉ፥ ታልኤዳዌ ባረ ላገ እስራኤላዉ ዎይ ባረ እሻዉ ታልኤዳባ ኦቾፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","ሀራ ቢታ አሳዉ ህንተ ታልኤዳ አጩዋ አካናዉ ዳንዳዪታ፤ ሽን ህንተ ህንተ ዛረቶ ታልኤዳባ ኡባ ማርተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","5","“ህንተ መꬍና ጎዳ ህንተ ጾሳ ቃላዉ አዛዘቶፐ፥ ታን ሀች ህንተና አዛዝያ አዛዞ ኡባ ባለናን ኦꬆፐ፥ ህንተ ግዶን እት አሳይነ ህዬሰና። አያዉ ጎፐ፥ ህንተ ላታናዳን መꬍና ጎዳይ ህንተ ጾሳይ ህንተዉ አቆ ኦꬂደ እምያ ጋድያን መꬍና ጎዳይ ህንተና አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ ጌዳዋዳን፥ እ ህንተና አንጃና፤ ዳሮ ካዉተꬃይ ህንተፐ ታልአና፤ ሽን ህንተ እቱዋፐነ ታልእክታ። ቃይ ህንተ ካዉተꬃቱዋ ሞዳና፥ ሽን እቱነ ህንተና ሞደና። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ጋድያን ደእያ ቄር ካታማቱዋፐ ሀቃዋንነ ደእያ ህንተ ላገ እስራኤላቱዋ ግዶን እት አሳይ ህዬሶፐ፥ አዉ መቀꬃ ኢቶፕተ፤ ቃይ ህንተ ኩሽያካ ሺሽ አኮፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","ህንተ ኩሽያ አዉ ብርሽተ፤ አ ኮሽያዋ አያነ አዉ ታልእተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","‘አጩዋ ማርያ ላፑንꬃ ላይꬃይ ማቴዳ’ ጋደ፥ ህዬሳ እስራኤልያዉ ኢታ አይፍያን ጼላደ፥ አዉ አያነ ታልእያዋ ድጋናዉ ኢታ ቆፋይ ነ ዎዛናን ገለናዳን ናገታ። ሄዌ ꬋዮፐ፥ እ ኔፐ መꬍና ጎዳዉ ዋሳና፤ ሄዌ ነዉ ናጋራ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","ኔን አዉ ጮ እማ፤ ኔን አዉ እምያ ዎደ፥ ነ ዎዛናን አያዉ እማይታ ጎፓ፤ ያቶፐ፥ ህንተ ኦሶ ኡባን፥ ህንተ ኦይቄዳዋን የꬌዳባን ኡባን መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","ሄ ጋድያን ኡባ ዎደካ ህዬስ ꬋየና ድራዉ፥ ታን ኔና እስራኤላቶ፥ ነ ጋድያን ደእያ ህዬሳቶነ መቶታንቻቶ ኬካ ግዳናዳን አዛዛይ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","“ኔን አቱማ ግድና ማጫ ግድና፥ ነ ዳቦ እስራኤልያ አሳ አይልያ ኦꬃደ ሻሞፐ፥ እ ነዉ ኡሱፑን ላይꬃ ኦꬆ፤ ላፑንꬃ ላይꬃን አይለተꬃፐ ከሳ የዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","ኔን አይለተꬃፐ አ ከሳ የድያ ዎደ፥ መላ ኩሸ የዶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","ኔን ነ ዉድያፐ፥ ነ ኡዱማፐነ ነ ዎይንያ ጉምኢያሳፐ አዉ ኬካተꬃን እማ፤ መꬍና ጎዳይ ነ ጾሳይ ኔና አንጄዳዋ ኬና አዉ እማ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","ህንተካ ግብጼ ጋድያን ካሰ አይልያ ግዴዳዋነ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ያፐ ዎዜዳዋ ዶጎፕተ። ታን ህንተና ሀች አዛዝያዌ ሄዋሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","“ሽን ሄ አይልያ ኔናነ ነ ጎልያ አሳ ዶሴዳ ድራዉነ ኔናና አዉ ደኡ ሎኦ ግድያ ድራዉ፥ ‘ታን ነ ጎለፐ ከሳደ ቢከ’ ያጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","ፐንገ አ አፋደ፥ ጎꬃ አካደ፥ አ ሀይꬃ ሉካ። ያቶፐ እ ነዉ መꬍናዉካ አይልያ ግዳናዋ። ቃይ አይልያ ግድያ ማጫንዉካ ሄዋዳን ኦꬃ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","አ ኔን አይለተꬃፐ ከሳ የድያ ዎደ፥ ኔን ቆሄቴዳዋዳን ቆፖፓ፤ አያዉ ጎፐ፥ እ ሀ ኡሱፑን ላይꬃ ግዶን ከራዉ ኦꬅያባይ ኦꬅያዎ ዳኩዋ ዳሩዋ ነዉ ኦꬄዳ። ሄዋ ድራዉ፥ ኔን ኦꬅያባን ኡባን መꬍና ጎዳይ ነ ጾሳይ ኔና አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","“ኔን ነ መህያፐነ ነ ዶርሳ ዉድያፐ ባይራ የለቴዳ አቱማዋ ኡባ መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ ዱማያ። ነ ዱማዬዳ መህያፐ ባይራ የለቴዳዋ አያነ ጎኤቶፓ፤ ነ ዶርሳ ዉድያፐ ባይራ የለቴዳዋ እክስያካ ሜዶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","ኔንነ ነ ሶ አሳይ ጾሳይ ዶርያ ሳኣን መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ሄዋንታ ላይꬃን ላይꬃን ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","ሽን ነ ያርሽያ መህያ ቦላይ ትላና ꬋዮፐ፥ እ ስሌዳዋ ዎይ ቆቀ ግዶፐ፥ ዎይ ቃይ ሀራ ኢታ ፖኮባይ አ ቦላን ደኦፐ፥ ሄዋ መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ ያርሾፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","ሄዋ ህንተ ደእያ ህንተ ካታማን ሚተ፤ ዎጋን ጌሻ አሳ ግድና፥ ዎይ ቱና አሳ ግድናካ ገንእያነ ጋራ አሹዋዳን ሞ። ");
INSERT INTO dwrENT_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","ሽን ህንተ አ ሱꬃ ሃꬃዳን ሳኣን ጉስተፐ አትና፥ ሞፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","“አቢባ አግናን መꬍና ጎዳ ህንተ ጾሳ ፓስጋ ባላ ቦንችተ፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አቢባ አግናን ቃማ ግብጼፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","ህንተ ዶርሳ ዉድያፐነ መህያ ዉድያፐ መꬍና ጎዳይ ባረ ሱንꬃይ ጼሰታናዳን ዶርያ ሳኣን፥ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ፓስጋዉ ያርሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","ሄ ያርሹዋ ህንተ ምያ ዎደ፥ እርሹዋ የግ ኡኬዳ ኡክꬃና ሞፕተ፤ ሽን ላፑን ጋላሳ ኩመንꬃ እርሹዋ የግቤና ኡክꬃና ሚተ። ህንተ ግብጼፐ ኤለካ ከሴዳ ድራዉነ ህንተ ደእያ ላይꬃ ኡባን ህንተ ግብጼፐ ከሴዳ ጋላሳ ሀሳያናዳን፥ ሄ መቱዋ ኡክꬃ ሚተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","ህንተ ጋድያን ኡባን ላፑን ጋላሳዉ አያ እርሹነ ቤቶፖ። ቃይ ህንተ ኮይሮ ጋላሳ ኦማርስ ያርሼዳ አሹዋፐ ዎንታዉ አያይነ አቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","“ህንተ ፓስጋ ያርሹዋ መꬍና ጎዳይ ህንተ ጾሳ ህንተንቶ እምያ አይ ካታማንነ ጮ ሹኮፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","መꬍና ጎዳይ ህንተ ጾሳይ ባረ ሱንꬃይ ጼሰታናዳን ዶርያ ሳኣን ህንተ ፓስጋ ያርሹዋ ሹክተ፤ ቃይ አዋይ ዉልያ ዎደ ህንተ ግብጼፐ ከሴዳ ድራዉ፥ ሄ ሳትያን ሹክተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","መꬍና ጎዳይ ህንተ ጾሳይ ዶርያ ሳኣን፥ ሄዋን ካꬂደ ሚተ፤ ያቲደ ሳአይ ዎንትያ ዎደ፥ ህንተ ዱንካንያ ዱንካንያ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","ኡሱፑን ጋላሳ ኩመንꬃ እርሹዋ የግቤና ኡክꬃ ሚተ፤ ላፑንꬃ ጋላሳን መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ጎይናናዉ ጌሻ ሺቁዋ ሺቅተ፤ ሄ ጋላስ አያ ኦሶነ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","“ህንተ ካꬃ ጫካናዉ ኮይሮ ዶሜዳ ዎድያፐ ዶሚደ፥ ላፑን ሳምንታ ኩመንꬃ ፓይድተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","ያቲደ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አንጄዳዋ ኬና ህንተ ህንተ ዶሱዋን ጮ እምያ እሙዋ አሂደ፥ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ቆይቻ ባላ ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","ሄዋን ህንተ፥ ህንተ አቱማ ናናይ፥ ህንተ ማጫ ናናይ፥ ህንተ አቱማ ቆማቱነ ህንተ ማጫ ቆማቱ፥ ህንተ ካታማቱዋን ደእያ ሌዋቱ፥ በተቱ፥ አዉ ባይና ናናቱነ ህንተ ግዶን ደእያ አምኤቱ ኡባይ መꬍና ጎዳይ ህንተ ጾሳይ ባረ ሱንꬃይ ጼሰታናዳን ዶርያ ሳኣን፥ ናሸትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","ህንተ ግብጼ ጋድያን አይልያ ግዴዳዋ ሀሳዪደ፥ ሀ ዎጋ ባለናን ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","“ህንተ ኡዱማፐ ህንተ ካꬃ፥ ቃይ ዎይንያ የꬍያሳፐካ ህንተ ዎይንያ ሺሼዳዋፐ ጉይያን፥ ላፑን ጋላሳ ዳስያ ባላ ቦንችተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","ህንተ፥ ህንተ አቱማ ናናቱነ ማጫ ናናይ፥ ህንተ አቱማ ቆማቱነ ማጫ ቆማቱ፥ ህንተ ካታማቱዋን ደእያ ሌዋቱ፥ በተቱ፥ አዉ ባይና ናናቱነ አምኤቱ ኡባይ ሀ ባላን ሎይꬅ ናሸትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","መꬍና ጎዳይ ዶርያ ሳኣን ላፑን ጋላሳ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ባላ ቦንችተ፤ አያዉ ጎፐ፥ ህንተ ኡባይካ እትፐ ናሸታና ማላ፥ ህንተ አይፍሴዳባን ኡባንነ ህንተ ኩሺ ኦꬅያባን ኡባን መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","“ህንተ ጋድያን አቱማ አሳ ግዴዳ ኡባይ ላይꬃን ሄዙ ገደ፥ ማጋገ ኡክꬃ ባላ ዎደ፥ ሳምንታቱዋ ባላ ዎደነ ዳስያ ባላ ዎደ፥ መꬍና ጎዳ ህንተ ጾሳ ስንꬃን እ ዶርያ ሳኣን ቤቶ። ኡንቱንቱ መꬍና ጎዳ ስንꬃ ዪደ፥ መላ ኩሸ ዮፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","መꬍና ጎዳይ ህንተ ጾሳይ አንጄዳዋ ኬና ኡባይካ ባረ ዳንዳይያዋ ኬና እሞ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","“ህንተ ዛራቱ ኡባዉ መꬍና ጎዳይ ህንተ ጾሳይ እምያ ካታማቱዋን ኡባን ህንተ ዳናቱዋነ ካፓቱዋ ሱንꬅተ፤ ኡንቱንቱካ አሳዉ ጽሎ ፕርዳ ፕርድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","ጽሎ ፕርዳ ጌላዮፕተ፤ ሶምኡዋ ጼሊደ ማዶፕተ። ማጋንጻ አኮፕተ፤ አያዉ ጎፐ፥ ማጋንጻይ አꬌዳ ኤራንቻቱዋ አይፍያካ ቆቅሲደ፥ ጽሎቱዋ ቃላካ ጌላዬ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","ህንተ ደኡዋን ደአና ማላነ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ቢታ ህንተ ላታና ማላ፥ ጽሎ ፕርዳ ፕርድተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","“ህንተ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ኬጽያ ያርሽያ ሳኣ ማታን አሼሮ ግያ ጾሳትዉ ምꬃፐ መቴዳ ምስልያ ማላ አያነ ኤሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","ህንተ መꬍና ጎዳይ ህንተ ጾሳይ እጽያ ጎይንያ ሹቻ ህንተንቶ ኤሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","“መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ትላ ቦላና ደኤና መህያ፥ ዎይ ህንተ ዶርሳ ያርሹዋ ኦꬂደ ሺሾፕተ፤ ሄዌ አ ስንꬃን ሸነይያባ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ካታማቱዋፐ ሀቃዋንካ አቱማዋ ግድና ማጫዋ ግድና አ ጫቁዋ ኮሊደ፥ መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ኢታ ኦꬄዳ አሳይ ህንተ ግዶን ቤቶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","ቃይ ታ አዛዙዋ መንꬂደ፥ ሀራ ጾሳቶ ጎይኔዳ ኡራይ፥ አዋዉ፥ ዎይ አግናዉ፥ ዎይ ሳሉዋ ጾልንተቶ ጎይኔዳ ኡራይ ደኦፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","ሄዋ ማላባ ህንተ ስሶፐ፥ ሄ የዉዋ ምንሲደ ፓይድተ። ህንተ ቆርና፥ ሄዋ ማላ ቱናባይ እስራኤልያ ግዶን ኦሰቴዳዌ ቱማነ ጌሻ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","ሄ ኢታ ኦꬄዳ ብታንያ ዎይ ምሽራቶ ህንተ ካታማፐ ጋጻ ከሲደ፥ ሹቻን ጫዲደ ዎꬍተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","ሄ ዎꬍያ አሳይ ሀይቃናዉ በስያዌ ላኡ ዎይ ሄዙ ማርካይ ማርካትና ግዶ፤ እት አሳ ማርካ ቃላን አይ አሳይነ ሀይቆፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","አ ዎꬋናዉ ማርካቱ ኮይሮ ሹቻን አ ጫድኖ፤ ኡንቱንታ ካሊደ አሳይ ኡባይ አ ጫዶ። ሄዋዳን ኦꬂደ፥ ኢታ ህንተ ግዶፐ ድግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","“ህንተ ህንተ ካታማቱዋን ፕርዳናዉ ሎይꬅ ዴጽያ ሸምፑዋ ሞቱዋ ግድና፥ ሾቻ ማዱꬃ ሞቱዋ፥ ዎይ ቃይ ታዉ በሰ ግያ አቆ ሞቱዋ ግድናካ ደንዶፐ፥ ሄ ዎደ ህንተ መꬍና ጎዳይ ህንተ ጾሳይ ዶሬዳ ሳኣ አህተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","ሄዋን ሌዋቱዋፐ ቄሰ ግድያዋኮነ ሄ ዎድያን ዳና ግዲደ ፕርድያዋኮ ሺሽተ፤ ሄ የዉዋ ኡንቱንቱ ፕርዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","መꬍና ጎዳይ ዶሬዳ ሳኣን ኡንቱንቱ ፕርዴዳዋዳን ኦꬅተ፤ ኡንቱንቱ ፕርዴዳዋፐ አሸናዳን ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","ኡንቱንቱ ህንተና ታማርሴዳ ህግያዳንነ ኡንቱንቱ ኦዴዳ ፕርዳዳን ኦꬅተ፤ ኡንቱንቱ ፕርዴዳ ፕርዳፐ ኡሸቻነ ሀድርሳ አይነ ሸርእ ጎፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","ሄዋን መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ኦꬅያ ዳናዉ፥ ዎይ ቄስያዉ አዛዘተናን እጺደ፥ ኦቶረትያ አሳይ ደኦፐ፥ ሄ አሳይ ሀይቆ፤ ሄዋዳን ኦꬂደ፥ ኢታ እስራኤልያ ግዶፐ ድግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","ሄዋፐ ጉይያን ሄዋ ስሲደ፥ አሳይ ኡባይ ያያና፤ ላኤንꬆ ኦቶረተና። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ቢታ ላቲደ፥ ያን ደኡዋ ዶምያ ዎደ፥ ህንተ ዩሹዋን ደእያ ካዉተꬃቱዋዳን፥ ህንተካ፥ ‘አነ ኑንካ ኑ ቦላን ካትያ ካተዬቶ’ ያጊደ ቆፖፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","ህንተ ካተያናዌ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ ዶሬዳዋ ግድያዋ ኤርተ። ሄዌካ ህንተ አሳ ግዶፐ ዶረቴዳዋ ግዶፐ አትና፥ ሀራ ቢታ አሳ ህንተ ቦላ ካተዮፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","ሄ ካቲ ፓራ ዳሩዋ ሺሻናዉ በሰና፤ ቃይ አሳይካ ፓራ ጮራያናዉ ላኤንꬆ ግብጼ ስማናዳን ኦꬆፖ። አያዉ ጎፐ፥ መꬍና ጎዳይ፥ ‘ሄ ኦግያና ላኤንꬆ ሙለካ ስሞፕተ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","አ ዎዛና ባለናዳን፥ ካቲ ጮራ ማጫ አሳ አኮፖ። ዎርቃካ ብራካ ዳሪ ሺሾፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","“እ ባረ ካዉተꬃ አራታን ኡትያ ዎደ፥ ሌዊያ ዛረ ግድያ ቄሳቱ ናግያ ማጻፋፐ ሀ ህግያ ዱቂደ ባረዉ አኮ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","እ ሀ ህግያ ቃላነ ዎጋ ናግያዋንነ ኡንቱንታ ኦꬅያዋን መꬍና ጎዳዉ፥ ባረ ጾሳዉ፥ ያይያዋ ታማራና ማላ፥ ሀ ማጻፋይ አናና ደኦ፤ እካ ሀ ማጻፋ ባረ ደኦ ላይꬃን ኡባን ናባቦ። ");
INSERT INTO dwrENT_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","ያቶፐ፥ እ ባረ ዎዛናን፥ ‘ታን ታ ላገቱዋፐ አꬋይ’ ጊደ ባረ እሻቱዋ ቦላ ኦቶረተና። እካ ጾሳ ህግያፐ ሀድርሳነ ኡሸቻ ጌና። እ ባረ ካዉተꬃን አዱቂደ ደአና፤ አ ናናይካ እስራኤልያ ጋድያን ካትያ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","“ቄሰተꬃን ኦꬅያ ኩመንꬃ ሌዊያ ዛረቶ እስራኤልያ ግዶን ቢታ ላታይ ባዋ። ኡንቱንቱ አሳይ መꬍና ጎዳዉ ሺሽያ ታማን ጹግያ ያርሹዋፐ ሚደ ደእያዌ ኡንቱንቶ ላታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","ኡንቱንቶ ኡንቱንቱ እሻንቱ ግዶን ላታይ ደኤና፤ መꬍና ጎዳይ ኡንቱንቶ ገፔዳዋዳንካ እ ኡንቱንቱ ላታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","“ኮሩማ ዎይ ዶርሳ አሳይ ያርሾ ሺሼዳዋፐ ቄሳቶ በስያዌ ሀዋ: ምሳ፥ ላኡ ባጋ ጎጎንጩዋነ ኡሉዋ ግዶ አሹዋ ኡንቱንቶ እምኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","ህንተ ካꬃፐ፥ ዎይንያፐነ ዛይትያፐ ኮይሮ ጋኬዳ አይፍያነ ህንተ ዶርሳ እክስያፐ ባይራቱዋ ቄሳቶ እሚታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","አያዉ ጎፐ፥ ኡንቱንቱነ ኡንቱንቱ ናናይ መꬍና ጎዳ ሱንꬃን ኤቂደ፥ መꬍናዉ ቄሴ ግዲደ ኦꬃና ማላ፥ ህንተ ዛርያ ኡባ ግዶፐ መꬍና ጎዳይ ህንተ ጾሳይ ኡንቱንታ ዶሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","“ሌዊያ ዛረ ግድያ እት አሳይ እስራኤልያ ጋድያን አይ ካታማፐነ ደንዲደ፥ መꬍና ጎዳይ ዶርያ ሳአዉ ዮፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","እ ብያሳን ደእያ ሌዋቱ መꬍና ጎዳ ስንꬃን ኤቂደ ኦꬅያዋዳን፥ እካ መꬍና ጎዳ ባረ ጾሳ ስንꬃን ኤቂደ ኦꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","ቃይ ባረ አዉዋ አቁዋ ባይዝና፥ ባረና ጋክያዋ አኬዳዋ ግዶፐካ፥ ሌዋቱ ጎኤትያዋ ኡባ ኡንቱንቱና ልከ ሻኪደ አኮ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እሜዳ ቢታ ገልያ ዎደ፥ ሄ ጋድያን ደእያ አሳይ ኦꬅያ ቱና ኦሱዋ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","ባረ አቱማ ናኣ ዎይ ማጫ ናቶ ያርሾ ጊደ፥ ታማን ጹግያ አይ አሳይነ ህንተ ግዶን ቤቶፖ። ብትያዌ፥ ማራጭያ ጼልያዌ፥ ሙሩንያዌነ ካጫ ኦድያዌ ቃይ ህንተ ግዶን ደኦፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","አያንቲያዌ፥ አያናቱዋ ጼግያዌ፥ ሻሬችያዌነ ሀይቄዳ አሳ አያና ጼግያዌ ህንተ ግዶን ደኦፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","ሄዋ ማላባ ኦꬅያ አይ አሳይነ መꬍና ጎዳ ማታን እጸቴዳ አሳ። ኡንቱንቱ ሄዋ ማላ ቱና ኦꬅያ ድራዉ፥ መꬍና ጎዳይ ህንተ ጾሳይ ሄ ካዉተꬃ ህንተ ስንꬃፐ የደርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","ሽን ህንተ መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ኩመንꬃ ፖኮባይ ባይናዋንታ ግድተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","“ሀ ህንተ ላታናዉ ብያ ጋድያን ደእያ ካዉተꬃቱ ሙሩንያዋንቱነ ማራጭያ ጼልያዋንቱ ኦድያዋ ስስያዋንታ። ሽን ህንተ ሄዋ ኦናዳን መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ተኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","መꬍና ጎዳይ ህንተ ጾሳይ፥ ህንተ ዛርያ ግዶፐ፥ ታ ማላ ትምቢትያ ኦድያዋ ህንተንቶ ደንꬃና። ህንተ እ ግያዋ ስስተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","ህንተ ሲና ደርያ ቦላን ሺቄዳ ዎደ፥ መꬍና ጎዳ ህንተ ጾሳ ሀዋዳን ያጊደ ኦቼድታ፤ ‘ኑን ሀይቀናዳን፥ መꬍና ጎዳ ኑ ጾሳ ኮሻ ዛር ስሶኮ፤ ቃይ ሀ ዎልቃማ ታማካ ላኤንꬆ በኦኮ’ ያጌድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","“መꬍና ጎዳይ ታዉ ሀዋዳን ያጌዳ፤ ‘ኡንቱንቱ ጌዳዋ ኡባ ልከ ጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","ታን ኡንቱንቱ ዛራቱ ግዶፐ፥ ነ ማላ ትምቢትያ ኦድያዋ ኡንቱንቶ ደንꬃና፤ ታ ቃላ አ ዶናን ዎꬃና፤ እካ ታን አ አዛዝያ ኡባ ኡንቱንቶ ኦዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","እ ታ ሱንꬃን ኦድያ ታ ቃላ ስሰና ኦስነ ሀሉዋ ታን ከሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","ሽን ታ አዛዛቤናዋ ጻሊደ ታ ሱንꬃን ኦድያዌ ዎይ ሀራ ጾሳቱዋ ሱንꬃን ኦድያ ሄ ትምቢትያ ኦድያዌ ሀይቆ’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","“ህንተ፥ ‘ትምቢትያ ኦድያዌ ኦድያ ቃላይ መꬍና ጎዳፐ ግደናዋ አያን ሻክ ኤራኔ?’ ያጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","ሄ ትምቢትያ ኦድያዌ መꬍና ጎዳ ሱንꬃን፥ እ ኦዴዳ ቃላይ ፖለተናን እጾፐ፥ ሄዌ መꬍና ጎዳይ ኦድቤና ቃላ ግድያዋ ኤሪታ። ሄ ትምቢትያ ኦድያዌ ዎርዱዋን ኦዴዳ ድራዉ፥ አዉ ያዮፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ጋድያን ደእያ ካዉተꬃ ꬋይስያ ዎደ፥ ቃይ ህንተካ ኡንቱንታ የደርሲደ፥ ኡንቱንቱ ካታማቱዋንነ ኡንቱንቱ ጎለቱዋን ደኡዋ ዶምያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","መꬍና ጎዳይ ህንተ ጾሳይ ላታ ኦꬂደ እምያ ጋድያን ደእያ ካታማቱዋፐ ሄዙ ካታማቱዋ ህንተንቶ ዱማይተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ ላታ ኦꬂደ እምያ ቢታ ሄዙ ከሲደ ሻክተ። ያቲደ አሳ ዎꬌዳ ኦንነ ሄ ካታማቱዋኮ ባቃታናዳን ኦግያ ጊግስተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","“እት አሳይ ካሰ ሞርከተꬃይ ባይናን ደእሽን፥ ኤረናን ባረ ሾሩዋ ዎꬎፐ፥ እ ሄ ካታማቱዋፐ እቶ ባቃቲደ፥ ባረ ሸምፑዋ አሾ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","ላኡ አሳይ ምꬃ ቃንጻናዉ ዎራ ቢና፥ እቱ ምꬃ ቃንጽሽን፥ ቱትያፐ አይፊ ኮለት ዎꬊደ ህንኩዋ ዎꬎፐ፥ ሄ ዎꬌዳዌ ሀ ሄዙ ካታማቱዋፐ እቱዋ ባቃቲደ፥ ባረ ሸምፑዋ አሾ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","ቆሰት አትያ ካታማይ እቱዋ ጻላላ ግዶፐ፥ ዎጺደ ኤለካ ጋካናዉ ኦጊ አዱቄዳ ጋሱዋን ሱꬃ አችያዌ ሱልያ ሀንቁዋን ደንዲደ፥ የደርስ ጋኪደ፥ ሀይቃናዉ በሰናዋ ዎꬋናዉ ዳንዳዬ፤ አያዉ ጎፐ፥ እ ባረ ሾሩዋ ዎꬌዳዌ ካሰ ሞርከተꬃይ ደእያ ድራሳ ግደና። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","ህንተ ሄዙ ካታማቱዋ ዱማይ ዎꬃናዳን፥ ታን ህንተና አዛዜዳዌ ሄዋሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","“መꬍና ጎዳይ ህንተ ጾሳይ ካሰ ህንተ ማይዛ አዋቶ ጫቄዳዋዳን ህንተ ዛዋ አሶፐ፥ ቃይ ህንተ ማይዛ አዋቶ እማና ጌዳ ቢታ ኡባ ህንተንቶ እሞፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","ሀ ሄዙ ካታማቱዋፐ ሀራ ሄዙ ካታማቱዋ ጉጂታ። ሀቼ ታን ህንተና አዛዝያዋ ኡባ ህንተ ፖሎፐ፥ መꬍና ጎዳ ህንተ ጾሳ ዶሶፐነ እ ህንተና ታማርሴዳ ኦግያን ምኒደ ደኦፐ፥ ሀ ቢታይ ህንተንቶ እመታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","ሄዋ ኦꬆፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ላታ ኦꬂደ ህንተንቶ እምያ ጋድያን ጌሻ አሳ ሱꬃይ ጉከና፤ ቃይ ህንተካ ሱꬃ ጉስያ ናጋራፐ አቲታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","“ሽን እት አሳይ ባረ ሾሩዋ እጺደ፥ ዙግ ናጊደ አ ዎꬊደ፥ ሀ ካታማቱዋፐ እቶ ባቃቶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","አ ካታማ ጭማቱ እ ባቃቴዳ ካታማፐ ኪት አሂሲደ፥ ሀሉዋ ከሳናዉ አ ኮይያዎ አꬅ እምኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","አዉ አይነ ቃረቶፕተ፤ ህንተንቶ ኡባባይ ሎአ ግዳና ማላ፥ ጌሻ ሱꬃ ጉስያዋ እስራኤልያ ግዶፐ ꬋይስተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ላታናዳን እምያ ጋድያን፥ በን አሳይ ኤሴዳ ነ ሾሩዋ ቢታ ዛዋ ሾዶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","“እት አሳ ባይዛንቻ ጋናዉ እት ማርካ ጻላላይ ግደና። ላኡ ዎይ ሄዙ ማርካይ ማርካትና፥ ሄ ሞቱ ፕርደታናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","“እት አሳይ ሀራ ዎርዱዋን ሞታናዉ ደንዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","ሄ ሞትያዌነ ሞተትያዌ ላኡካ መꬍና ጎዳ ስንꬃን፥ ቄሳቱ ዋ ስንꬃንነ ሄ ዎደ ፕርድያ ዳናቱዋ ስንꬃን ኤቂኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","ያቶፐ ዳናቱ ሄ የዉዋ ምንሲደ ብድኖ፤ ሄ ሞትያዌ ባረ እሻ ዎርዱዋን ሞቴዳዋ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","እ ሄ ሞቱዋን ባረ እሻ ሙርሳናዉ ቆፔዳ ሙራ ባረዉ ሙረቶ፤ ሄዋዳን ኦꬂደ፥ ሄዋ ማላ ኢታ ህንተ ግዶፐ ድግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","ያቶፐ፥ ሀራ አሳይ ሄዋ ስሲደ ያያና፤ ሄዋ ማላ ኢታ ኦሱዋ ላኤንꬆ ኦና። ");
INSERT INTO dwrENT_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","ሄዋ ማላ ኢታ ኦꬄዳዎ አይነ ቃረቶፕተ፤ ሸምፑዋ ዎꬌዳዌ ሀይቆ፤ አይፍያ ድራዉ አይፍያ፤ አቻ ድራዉ አቻ፤ ኩሽያ ድራዉ ኩሽያ፤ ገድያ ድራውካ ገድያ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","“ህንተ ሞርክያና ኦለታናዉ ብያ ዎደ፥ ኡንቱንቱ ፓራቱ፥ ፓራ ጋረቱነ ኡንቱንቱ ኦላንቻቱ ህንተፐ ዳርና በኢደ፥ ኡንቱንቶ ያዮፕተ፤ አያዉ ጎፐ፥ ህንተና ግብጼፐ ከሴዳ መꬍና ጎዳይ ህንተ ጾሳይ ህንተናና ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","ህንተ ኦላ ዶማናፐ ካሰቲደ፥ ቄሲ ስንꬃዉ አꬊደ ሀዋዳን ያጎ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","‘ህንተኖ እስራኤልያ አሳቶ፥ ስስተ፤ ህንተ ሀች ህንተ ሞርክያና ኦለታናዉ ሀኒታ። ስም ህንተ ዎዛናይ ዳጋሞፖ፤ ያዮፕተ፤ ኡንቱንቱ ስንꬃን ኮኮሮፕተነ ሻባረቶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተናና ብያ ድራዉ፥ ህንተ ሞርክያ ኦሊደ፥ ህንተንቶ ጾኑዋ እማና’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","“ኦላ ጋዳዋቱ ኡንቱንታ ሀዋዳን ያግኖ፤ ‘ኦራꬃ ጎልያ ኬጺደ ገልቤና አሳይ ደኦፐ፥ እ ሀ ኦላን ሀይቂና፥ ሀራ አሳይ አ ጎልያ ገለናዳን፥ እ ጎለ ስሞ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","ዎይ ዎይንያ ቶኪደ፥ አ አይፍያን ናሸትቤና ኡራይ ደኦፐ፥ እ ሀ ኦላን ሀይቂና፥ ሀራ አሳይ አ ዎይንያ አይፍያን ናሸተናዳን፥ እ ባረ ጎለ ስሞ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","ማጫ አሳ ጊግሲደ አክቤና አሳይ ደኦፐ፥ እ ሀ ኦላን ሀይቂና፥ ሀራ አሳይ እዞ ማችያ አከናዳን፥ እ ባረ ጎለ ስሞ’ ያግኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","“ጋዳዋቱ ጉጂድካ አሳዉ ሀዋዳን ያግኖ፤ ‘ሀ አሳ ግዶን ያይያ አሳይነ ህርግያ አሳይ ኦንነ ደኦፐ፥ እ ባረ ላገቱዋ ዎዛናካ ያሻን ሴርሰናዳን እ ባረ ጎለ ስሞ’ ያግኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","ጋዳዋቱ ሀዋ አሳዉ ኦድ ዉርስያ ዎደ፥ ጭታዉ ጭታዉ ኦላ ጋዳዋቱዋ ዶርኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","“እት ካታማ ኦላናዉ ቢደ ህንተ አኮ ማትያ ዎደ፥ ኮይሮቲደ ሳሩዋን ኡንቱንቱ ኩሽያ እማናዳን ኦችተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","ኡንቱንቱ ሳሩዋን ባረንቱ ኩሽያ እሚደ፥ ባረንቱ ግምቢያ ፐንግያ ዶዪደ ህንተና ገልሶፐ፥ ሄ ካታማን ደእያ አሳይ ኡባይ ህንተንቶ ሀጋዝኖነ ዴጾ ኦሱዋ ህንተንቶ ኦꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","ሽን ሄ ካታማ አሳይ ህንተንቶ ሳሩዋን ኩሽያ እመናን እጺደ፥ ህንተናና ኦላዉ ጊጎፐ፥ ህንተ ሄ ካታማ ዩሹዋ ዶድተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","መꬍና ጎዳይ ህንተ ጾሳይ ኡንቱንታ ህንተንቶ አꬅ እምያ ዎደ፥ ሄ ካታማን ደእያ አቱማ አሳ ኡባ ማሻን ዉርስተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","ሽን ማጫ አሳ፥ ናናቱዋ፥ መህያነ ካታማ ግዶን ደእያ ኡባባ ኦሞዱዋ ኦꬂደ ህንተንቶ አኪተ። ቃይ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ህንተ ሞርከቱዋ ኦሞዱዋን ጎኤትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","ህንተ ደኢያሳፐ ሃኪደ ደእያ ካታማቱዋካ ኦይቂያ ዎደ፥ ሄዋዳን ኦꬂታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","“ሽን መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ ላታ ኦꬂደ እምያ ጋድያን ሸምፑዋና ደእያዋ እትባነ አሸናን ዎꬍተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","መꬍና ጎዳይ ህንተ ጾሳይ አዛዜዳዋዳን፥ ሂተቱዋ፥ አሞረቱዋ፥ ካናነቱዋ፥ ፓርዘቱዋ፥ ሂዌቱዋነ ያቡሳቱዋ ዉርሲደ ዎꬍተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","ሄዌ ꬋዮፐ፥ ኡንቱንቱ ባረንቱ ጾሳቶ ጎይንያ ቱና ኦሱዋ ህንተ ኦꬃናዳን ህንተና ታማርሳና፤ ሄዋን ህንተ መꬍና ጎዳ ህንተ ጾሳ ቦላ ናጋራ ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","“ካታማ ኦይቃናዉ ዩሹዋ ዶድ፥ ዳሮ ጋላሳ ኦለቲደ ጋምእያ ዎደ፥ አን ደእያ አይፍያ እምያ ምꬃ ካልታን ቃንጾፕተ፤ ኡንቱንቱ አይፍያ ሚተፐ አትና፥ ኡንቱንታ ቃንጾፕተ። አያዉ ጎፐ፥ ህንተ ዩሹዋን ዶዲደ ኦልያዌ አሳፐ አትና፥ ደምባን ደእያ ምꬃ ግደና። ");
INSERT INTO dwrENT_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","ሽን ህንተ ኤርያ አይፍያ እመና ሀራ ምꬃቱዋ ቃንጺደ፥ ህንተናና ኦለትያ ካታማይ ኩንዳና ጋካናዉ፥ ሄዋን ዶድያ ጌሱዋ ኬጽተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","“ህንተ ላታናዳን መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ጋድያን፥ ኦን ዎꬌደንቶ ኤረና አሃይ ኩንዲደ ቤቶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","ህንተ ዳናቱነ ህንተ ጭማቱ ቢደ፥ ሄዋ ዩሹዋን ደእያ ካታማቱዋፐነ ሄ አሃፐ ግዱዋን ደእያ ሃኮተꬃ ልክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","ሄዋፐ ጉይያን፥ አሃይ ኩንዴዳሳ ማታትያ ካታማ ጭማቱ፥ ኦሶ ጋካቤና፥ እ ሞርግያን ቃምባራይ ዎꬍቤና ኡሳቶ አክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","ጎግያ ሃꬃይ ደእያ ጎሸትቤና ሳነ ዘረትቤና ዛንጋራ አፊደ፥ ሄ ኡሳት ሞርጊያ ምርቂደ መንꬅኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","ያቶፐ ሌዊያ ናናይ፥ ቄሳቱ ሄ ሳኣ እትፐ ቢኖ፤ አያዉ ጎፐ፥ ሀዋ ማላ ኢታ ሀይቁዋነ ሞቱዋ ሻኪደ ፕርዳናዉ፥ መꬍና ጎዳይ ህንተ ጾሳይ ባረ ስንꬃን ኦꬃናዉ፥ መꬍና ጎዳ ሱንꬃንካ አንጃናዉ ኡንቱንታ ዶሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","ሄዋፐ ጉይያን፥ ሄ አሃይ ኩንዴዳሳ ማታትያ ካታማ ጭማቱ ኡባይ፥ ዛንጋራን ሞርጊያ ምርቂደ ዎꬌዳ ኡሳት ቦላ ባረንቱ ኩሽያ ሜጨቲደ፥ ሀዋዳን ያግኖ፦ ");
INSERT INTO dwrENT_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","‘ኑ ኩሺ ሀ ሱꬃ ጉስቤና፤ ኑ አይፊካ ሀዋ ኦꬄዳዋ በእቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","አቤት መꬍና ጎዳዉ፥ ኔን ዎዜዳ ነ አሳ፥ እስራኤልያ ማራ፤ ሀ ጌሻ ሱꬃ ነ አሳ ቦላ ናቁዋ ኦꬃደ ፓይዶፓ ያግኖ’። ሄ ሱꬃ ድራዉ፥ ኡንቱንቶ አቶ ጌተታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","ህንተ መꬍና ጎዳ አይፍያ ስንꬃን ሄዋዳን ኦꬂደ፥ ጌሻ ሱꬃይ ጉኬዳ ናጋራ ህንተ ግዶፐ ድግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","“ህንተ ሞርክያና ህንተ ኦለታናዉ ከስና፥ መꬍና ጎዳይ፥ ህንተ ጾሳይ፥ ኡንቱንታ ህንተ ኩሽያን አꬅ እምና፥ ኡንቱንታ ኦሞድያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","ኦሞደቴዳ አሳ ግዶን እት ማላንቻ ምሽራቶ በኣደ፥ እዞ አሞታደ፥ ማቼ ኡዳናዉ ኮዮፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","ነ ጎለ አያ፤ እ ሁጲያ ሜዳ፤ እ ጹጉንꬃካ ጭጋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","ኦሞደትያ ዎደ ደእያ ማዩዋ ቃራ ድጋደ፥ ነ ሶን ኡታደ፥ ባረ አዎነ ባረ ዳይዉ እት አግና ኩመንꬃ ካዮቱ። ሄዋፐ ጉይያን፥ እዞ አካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","ያታ ስምና፥ እዝና ደእያዌ ኔና ናሸቼናን ꬋዮፐ፥ አ ባረ ኮዮሳ ባናዳን የዳ አጋ። ኔን እዞ ማቼ ኦꬃደ እትፐ አቄዳ ድራዉ፥ እዞ ሻሉዋን ዛልአናዉ ዎይ ካዉሻናዉ በሰና። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","“እት አሳዉ እ ዶስያነ እጽያ ላኡ ማጫ አሳቱ ደኦፐ፥ ቃይ ሀ ላአቱካ አዉ አቱማ ናናቱዋ የሌዳዋንታ ግድሽን፥ ባይራ የለቴዳዌ ሀ እጽያ ማጫ ምሽራትፐ የለቴዳዋ ግዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","ባረ ናናዉ ባረ አቁዋ እ ላትስያ ዎደ፥ እ እጽያንፐ የለቴዳ ባይራይ ደእሽን፥ እ ዶስያንፐ የለቴዳ ቴፋ ባይራያናዉ በሰና። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","ሀራ ናናዉ እምያዋፐ ላኡ ኩሽያ አꬂ እምያዋን ሀ እጽያን ናአይ ባይራ ግድያዋ ኤርሳናዉ በሰ። አያዉ ጎፐ፥ ሄ ናአይ አዉ ኩሽያ ገድያ ጳልቄዳ ባይራ ግድያ ድራዉ፥ ባይራቱዋ እ አካናዉ በሰ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","“አዎነ አትዉ አዛዘተናን እጼዳ፥ ኡንቱንቱ ሴርናካ ስመና ሞርግያ ዞዳነ ማካላንቻ ግዲደ ስመና ናእ ደኦፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","አዉነ አታ ሄ ካታማ ፐንግያን ደእያ ጭማቱዋኮ አ ኦይቂ አክ አህኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","ጭማቶ ሀዋዳን ያግኖ፤ ‘ሀዌ ኑ ናአይ ሞርግያ ዞዳነ ማካላንቻ፤ እ ኑዉ ሙለካ አዛዘተና፤ ሚሻ ላል ካእያዋነ ኡሻንቻ’ ያጊደ ኦድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","ሄዋፐ ጉይያን፥ ሄ ካታማን ደእያ አቱማ አሳይ ኡባይ እ ሀይቃና ጋካናዉ፥ ሹቻን ጫዲደ አ ዎꬍኖ። ሄዋዳን ኦꬅያዋን ህንተ ግዶፐ ኢታ ꬋይስተ። ያቶፐ እስራኤልያ ኡባይ ሄዋ ስሲደ ያያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","“እት አሳይ ሀይቁዋ ፕርድስያ ዳባ ኦꬅና፥ ህንተ አ ምꬃን ካቂ ዎꬎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","ሄ ካቀቴዳ ምꬃን አ አሃይ አቆፖ፤ አ ሄ ጋላስ ሞግተ። አያዉ ጎፐ፥ ምꬃ ቦላን ካቀት ሀይቂያ ኦንነ ጾሳን ሸቀቴዳዋ። መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ ላታ ኦꬂደ እምያ ህንተ ቢታ ህንተ ቱንሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","“እስራኤልያ አሳ ቦራይ ዎይ ዶርሳይ ባዪደ ዎራ ቢሺና በኦፐ፥ ሸነኮ ጋደ አጋ አጎፓ፤ አ ጎዳዉ ላጋ አሃደ እማ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","ሄ መህያ ጎዳይ ነ ሄራ ግዳና ꬋዮፐ፥ ዎይ አ ጎዳይ ኦነንቶ ኔን ኤራና ꬋዮፐ፥ አ ጎዳይ ኮዪደ ያና ጋካናዉ፥ ነ ጎለ አካደ አፋ፤ እ ዪደ፥ ደምያ ዎደ፥ አዉ እማ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","ሄዋዳን ሀርያ ግድና፥ ማዩዋ ዎይ አያነ ባዬዳዋ ደሞፐ፥ አ ጎዳዉ ዛራፐ አትና፥ ሸነኮ ጎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","“እስራኤልያ አሳ ሀሪ ዎይ ቦራይ ኦግያን ኩንዴዳዋ በኦፐ፥ ማዳደ ደንꬃፐ አትና፥ ሸነኮ ጋደ አጋ አጎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","“ማጫ አሳይ አቱማ አሳ ማዩዋ ማዮፕኖ፤ አቱማ አሳይካ ማጫ አሳ ማዩዋ ማዮፕኖ። አያዉ ጎፐ፥ ሄዋ ማላባ ኦꬅያ ኦናነ መꬍና ጎዳይ ህንተ ጾሳይ ሻቴ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","“ኦግያን ነ ቢሺና፥ ምꬃን ግድና፥ ሳኣን ባረ ማራ ዎይ ቁቁልያ ሀጳ ኡቴዳ ካፋቶ ደሞፐ፥ እዞ እ ማራና ጋꬃ ኦይቃደ ነ ጎለ አፎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","ማራቱዋ አካ አፋናዉ ዳንዳያሳ፤ ሽን ዳዮ ባናዳን የዳ አጋ። ሄዋዳን ኦꬆፐ፥ ኔን ዱረታደ አዱሳ ላይꬃ ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","“ኦራꬃ ጎልያ ኬጽያ ዎደ፥ ꬎቃ ካራፐ አሳይ ኩንድ ሀይቂና ነ ኦሸተናዳን፥ ዘምፒደ አትያዋ ጊግሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","“ነ ዎይንያ ሾይቃን ላኡ ቆሞ ካꬃ ዘሮፓ፤ ሄዋዳን ኦꬆፐ፥ ነ ዘሬዳ ካꬃይነ ዎይኒ ላኡካ ባያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","“ቦራነ ሀርያ እትፐ ዋጻደ ጎሾፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","“ሱፍያፐነ ሊኑዋፐ ዋላካን ዳደቴዳ ማዩዋ ማዮፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","“ነ ማዬዳ ማዮ ኦይዱ ባጋናካ ማጫራይ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","“እት አሳይ ማቻቶ አኪደ፥ እዝና አቅ ስሚደ፥ እዞ ዶሳና ꬋዮፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","‘ሀኖ ታ አካደ እዝና አቅያ ዎደ፥ ህጊ እዝዉ ባዋ’ ያጊደ እዞ ባይዚደ ሃሳዮፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","ሄ ናት አዉነ ዳያ እ ህግያ ማላታ አክ አፊደ፥ ካታማ ፐንግያን ደእያ ጭማቱዋ በስኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","ናት አዉ ጭማቶ ሀዋዳን ያጊደ ኦዶ፥ ‘ታን ታ ናቶ ሀዎ ማቼ ኦꬃደ እማድ፤ ሽን እ እዞ እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","እ፥ “ነ ናትን ህጊ ባዋ” ያጊደ እዞ ባይዚደ ሃሳየ፤ ሽን ታ ናት ህግያ ማላታ ሀዋ በእተ’ ያጊደ፥ እዝ ህግያ ኤርስያ ጫርቂያ በሶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","ያትና ሄ ካታማ ጭማቱ አ ሙርኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","እ እስራኤልያ ዎዶራት ሱንꬃ ባይዜዳ ድራዉ፥ ጭማቱ አ ጼቱ ጻጋራ ብራ ሙሪደ፥ ሄዋ ናት አዎ እምኖ። ናታካ አዉ ማቼ ግዳደ ደኡ፤ ባረ ደኦ ላይꬃ ኡባን እ እዞ የዳናዉ በሰና። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","“አ ሞቱ ቱማ ግዲደ፥ ናትን ዎዶሮተꬃይ ꬋዮፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","ናቶ እዝ አዉዋ ካረ አሂደ፥ ሄ ካታማ አቱማ አሳይ እዞ ሹቻን ጫዲደ ዎꬎ። አያዉ ጎፐ፥ አ ባረ አዉዋ ሶን ደኣደ ሻርሙጻ ግዳደ፥ እስራኤልያ ግዶን ሀ ፖኮባ ኦꬃዱ፤ ሄዋዳን ኦꬂደ ህንተ ግዶፐ ኢታ ድግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","“አይ አሳይነ ሀራ አሳ ማጫ አሳና ሻርሙጺደ ኦይቀቶፐ፥ እካ አናና ሻርሙጼዳ ማጫ ምሽራታካ ሀይቂኖ። ሄዋዳን ኦꬂደ፥ ህንተ ግዶፐ ኢታ ድግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","“አይ አሳይነ ሀራዉ ጊጌዳ ዎዶራቶ ካታማ ግዶን ደሚደ እዝና ሻርሙጾፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","ኡንቱንታ ላኡዋካ ካታማፐ ጋጻ ከሲደ፥ ሹቻን ጫዲደ ዎꬍተ። አያዉ ጎፐ፥ ናታ ካታማን ደኣደ፥ አሳይ አሻናዳን ዋሳበይኩ። እ ሀይቂያዌ ቃይ ሀራ አሳዉ ጊጋ ኡቴዳ ዎዶራቶ ባይዜዳ ግሻሳ። ሄዋዳን ኦꬅያዋን ህንተ ግዶፐ ኢታ ድግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","“እት አሳይ አሳዉ ጊጌዳ ዎዶራቶ አሳይ ባይና ሳኣን ዎልቃን ኦይቂደ፥ እዝና ግሶፐ፥ አ ጻላላይ ሀይቆ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","ናቶ አይነ ኦꬆፕተ፤ እዞ ዎꬋናዉ በስያ ናጋራ ኦꬃበይኩ። ሀዌ እት አሳይ ጮ ባረ ሾሩዋ ቦላ ደንዲደ፥ ዎꬍያ አሳ ፕርዳ ማላ ፕርዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","አያዉ ጎፐ፥ እ እዞ አሳይ ባይና ሳኣን ደሚደ ኦይቂና፥ ሄ ዎዶሮ ናታ ዋሳዱ፤ ሽን እዞ አሽያ አሳይ ደእቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","“አይ አሳይነ አሳዉ ጊጋቤና ዎዶራቶ ኦይቂደ፥ እ ህግያ አክ ድጊደ ኦይቀቶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","ናት አዎ እሻታሙ ጻጋራ ብራ ጭጎ። ያቲደ ናቶ ባረዉ ማቼ ኦꬆ። ባረ ደኦ ላይꬃ ኡባን እዞ የዶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","“አይ አሳይነ ባረ አዉዋ ማቻቶ አኪደ፥ ባረ አዉዋ ካዉሾፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","“ሳንግሰቴዳ ዎይ ቃራተቴዳ አቱማ አሳይ፥ መꬍና ጎዳ ሺቁዋ ግዶን ቤቶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","“ሻርሙጻን የለቴዳ አሳይ መꬍና ጎዳ አሳ ማባራ ገሎፖ፤ ሀራይ አቶ ቢደ ታማንꬃ የለታ ጋካናዉካ፥ አ ዛርያፐ ኦንነ መꬍና ጎዳ አሳ ማባራ ግዶ ገሎፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","“አሞና አሳ ግድና፥ ዎይ ሞኣባ አሳ ግድናካ፥ መꬍና ጎዳ አሳ ማባራ ገሎፖ፤ ሀራይ አቶ ቢደ ታማንꬃ የለታ ጋካናዉካ፥ ኡንቱንቱ አሳ ግዴዳ ኦንነ መꬍናዉካ መꬍና ጎዳ አሳ ማባራ ገሎፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","አያዉ ጎፐ፥ ህንተ ግብጼፐ ከሲደ ሄመትሽን፥ ኡንቱንቱ ህንተና ካꬃናነ ሃꬃና ሞክበይክኖ። ሄዋዳንካ፥ ማስጰጾምያን ፓቶራ ግያ ካታማን ደእያ ብኦራ ናኣ ባላም ህንተና ሸቃና ማላ ቃጻሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","መꬍና ጎዳይ፥ ህንተ ጾሳይ፥ ባላም ግያዋ ስሳናዉ ኮይቤና፤ አ ሸቃ ህንተንቶ አንጆ ላሜዳ። አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ሲቄ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","ህንተ ደኦ ላይꬃ ኡባን መꬍናዉካ ኡንቱንቱ ሳሮ ደአናዳንነ ኡንቱንቱ ዱረታናዳን አሞቶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","“ህንተዉ ኡንቱንቱ ዳቦ ግድያ ድራዉ፥ ኤዶማቱዋ ካꬊደ እጾፕተ፤ ቃይ ግብጼቱዋካ እጾፕተ። አያዉ ጎፐ፥ ህንተ ኡንቱንቱ ጋድያን በተ ግዲደ ደኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","ኡንቱንቶ ሄዘንꬆ የለታ ናናይ መꬍና ጎዳ አሳ ማባራ ገላናዉ ዳንዳዪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","“ህንተ ህንተ ሞርክያ ኦላናዉ ከሲደ እትሳን ካምቡዋ መꬎ ዎደ፥ ህንተና ቱንስያዋፐ ኡባፐ ሻከትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","ቃማ አኩሙዋን ማጫ አሳና ጋከቴዳዋ ኤርስያ እርጻባይ አን ደእያ አይ አሳይነ ደኦፐ፥ ዱንካኔዳ ሳኣፐ ጋጻ ከሲደ ያን ጋምኦ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","ሳአይ ኦማርስያ ዎደ፥ ባረ ቦላ ሜጨቲደ፥ ለለምእያ ዎደ ዱንካኔዳሳ ስሞ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","“ህንተ ሼሻዉ ኡትያሳ ዱንካኔዳ ሳኣፐ ካረና ጊግስተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","ሼሻዉ ኡትያሳ ቦካናዉ ዞሩዋ ህንተ ኦላ ሚሻና ጋꬅ ኦይቂተ፤ ሼሻዉ ኡት ስሚደ፥ ኦላን ቢታ ዛርተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ናጋናዉነ ህንተ ሞርከቱዋ ህንተ ኩሽያን አꬅ እማናዉ፥ ህንተ ሄራን ያነ ሃነ ሀመቴ። ሄዋን እ ሸነይያባ አያነ በኢደ፥ ህንተፐ ዎራ ስመናዳን፥ ህንተ ሄራን ጌሻ ግዳናዉ ኮሼ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","“ባረ ጎዳፐ ባቃቲደ፥ ኔኮ ዬዳ አይልያ ዛራደ አ ጎዳዉ እሞፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","እ ህንተ ካታማቱዋፐ ባረ ኮዬዳዋን ደኦ፤ አ ኡቁኖፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","“እስራኤልያ አሳፐ ኦንነ አቱማ ግድና፥ ማጫ ግድናካ፥ አላጋ ጾሳዉ ጎይንያዋንቱ ኦꬅያዋዳን፥ ሻርሙጽያዋ ግዶፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","ሄዋዳንካ፥ አቱማዋ ግድና፥ ማጫውኖ ግድና፥ ሻርሙጻን ደሜዳ ሚሻ ሺቁዋ ጋꬃናዉ መꬍና ጎዳ ህንተ ጾሳ ጎልያ አሆፕኖ። አያዉ ጎፐ፥ ኡንቱንቱ ላኡዋካ መꬍና ጎዳይ ህንተ ጾሳይ ሻቴ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","“ነ ዛረ ግድያ እስራኤልያ አሳዉ ሚሻ፥ ካꬃ ግድና ሀራባ ታልአደ ድቻ አኮፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","ሀራ ቢታ አሳፐ ድቻ ኦቻናዉ ዳንዳያሳ፤ ሽን ኔን ላታናዉ ገልያ ጋድያን ኔን ኦꬅያባን ኡባን መꬍና ጎዳይ ነ ጾሳይ ኔና አንጃና ማላ፥ ነ ዛረ ግድያ እስራኤልያ አሳዉ ድቻዉ ታልኦፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","“መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ እማናዉ ገፔዳዋ እማናዉ ጋምኦፓ። መꬍና ጎዳይ ነ ጾሳይ ኔን ገፔዳዋ ኩመንꬃን ኔፐ ኮይያ ድራዉ፥ ፖላና ꬋዮፐ፥ ነዉ ናጋራ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","ሽን ኔን ገፓና ꬋዮፐ፥ ሄዋን ነዉ ናጋራይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ እማና ጋደ ኔን ዶናን ሃሳዬዳዋ ነ ዶሱዋን እማና ጌዳ ድራዉ፥ ነ እንጻርሳን ሃሳዬዳዋ ፖላ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","“ነ ሾሩዋ ዎይንያ ግዱዋና አꬍያ ዎደ፥ ዎይንያፐ ነ ኮዬዳ ኬና ማፐ አትና፥ አፐ አያነ ነ ኦይቄዳ ሚሻን የጎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","ነ ሾሩዋ ሾይቃና ካንꬅያ ዎደ፥ ሄ ሾይቃን ደእያ ትሻፐ ዱꬃደ ማፐ አትና፥ ነ ሾሩዋ ካꬃ ባጫን ጫካደ ጎለ አፎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","“እት አሳይ ማቼ አክ ስሚደ፥ እት ኢታባ እ ቦላ ደሚደ እዞ እጾፐ፥ እዝዉ ፓራማ ጻፍ እሚደ፥ ባረ ጎለፐ ከሲደ የዶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","እዛ አ ጎለፐ ከሳደ፥ ሀራ አስና ገሎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","ሄ ላኤንꬆ አስናይካ እዞ ዶሰናን እጺደ፥ ፓራማ እዝዉ ጻፍ እሚደ፥ ባረ ጎለፐ እዞ ከሲደ የዶፐ፥ ዎይ እዞ አኬዳ ሄ ላኤንꬆ አስናይ ሀይቆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","አ ቱኔዳ ድራዉ፥ ኮይሮ ፓራሜዳ አስናይ ላኤንꬆ እዞ ዛሪደ አኮፖ። ሄዌ መꬍና ጎዳ ማታን እጸቴዳዋ፤ ቃይ ህንተካ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ጋድያን ሀዋ ማላ ናጋራ ኦꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","“ኦራꬃ ማቼ አኬዳ አሳይ ኦላዉ ቦፖ፤ ሀራ ዴጾ ኦሱዋካ አዉ እሞፕተ። እት ላይꬃይ አꬋና ጋካናዉ፥ ሀቃነ ቤናን ባረ አኬዳ ማቻቶ ናሸቾ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","“አይ አሳይነ አጮ ዎጻ ዎይ ማይድያ ኦይቆፓ፤ አያዉ ጎፐ፥ ሄዌ ጎልያ አሳይ ጋጭያባ ꬋዪደ፥ ሀይቂኖ ግያዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","“ባረ እሻ ግድያ እስራኤልያ አሳ ዉእ አፊደ፥ አይልያ ከስያ አሳይ ዎይ ሀራዉ ዛልእያ አይ አሳይነ ሀይቆ። ሄዋዳን ኦꬅያዋን ህንተ ግዶፐ ኢታ ድጊታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","“ዎልቃማ ጋልባ ሀርግያን ሳከትያ አሳዉ ሌዊያ ዛረ ግድያ ቄሳቱ ህንተና ታማርሴዳዋዳን ኡባባ ፖልተ፤ ታ ኡንቱንታ አዛዜዳዋ ሄዋዳን ኦꬃናዉ ናገትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","ህንተ ግብጼፐ ከሲደ ኦግያን ደእሽን፥ መꬍና ጎዳይ ህንተ ጾሳይ ሚርያም ቦላ ኦꬄዳዋ ሀሳይተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","“ኔን ነ ሾሮ እትባ ታልኣደ፥ እ ኦይꬅያዋ ኦቻናዉ አ ጎለ ገሎፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","ኔን ካረን ኤቃ ደእሽን፥ ነ ታልኤዳ ብታኒ ኦይꬅያዋ ባረ ጎለፐ ከሲደ ነዉ እሞ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","እ ህዬሳ ግዶፐ፥ ነ አጮ ኦይቄዳ አ ማዩዋ ነ ሶን አይሶፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","እ ማዪደ አቃናዳን፥ ኦማርስ ዎደ አዉ ጉየ ዛራ፤ እ ሄዋን ኔና ጋላታና። ሄዌ መꬍና ጎዳ ነ ጾሳ ማታንካ ነዉ ጌሻተꬃ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","“ነ እሻ ግድያ እስራኤልያ አሳ ግድና፥ ዎይ ነ ቢታ ካታማፐ እቱዋን ደእያ ካረ ቢታ አሳ ህዬሳ ቃጻራደ ናቆፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","እ ሀች ኦꬄዳዋ ሀች አካናዉ ምንሲደ ኮይያ ድራዉ፥ አዋይ ዉለናን ሀች ጭጋ። ሄዌ ꬋዮፐ፥ መቶታንቻይ ኔፐ መꬍና ጎዳዉ ዋስና፥ ነዉ ናጋራ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","“ናናይ ኦꬄዳ ናጋራ ድራዉ፥ አዎቱዋ ዎꬋናዉ በሰና፤ ቃይ አዎቱ ኦꬄዳ ናጋራ ድራዉካ፥ ናናቱዋ ዎꬋናዉ በሰና። አሳይ ኡባይ ባረ ኦꬄዳ ናጋራን ናጋራን ሀይቃናዉ በሰ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","“ካረ ቢታ አሳቱ ፕርዳነ አዉ አታ ባይናዋንቱ ፕርዳ ደሽሶፓ፤ አምአት ማዩዋ አ ታልኤዳዎ ጋደ ኦይቆፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","ህንተካ ግብጼ ጋድያን አይልያ ግዴዳዋነ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ያፐ ዎዚደ ከሴዳዋ ሀሳይተ። ታን ሀዋ ህንተና አዛዝያዌ ሄዋ ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","“ነ ሾይቃፐ ካꬃ ጫክያ ዎደ፥ ነ ዶጌዳ ምርቂያ ቆራናዉ ጉየ ቦፓ። መꬍና ጎዳይ ነ ጾሳይ ነ ኩሽያ ኦሶ ኡባን ኔና አንጃና ማላ፥ ሄዋ በትያዉ፥ አታ አዉ ባይና ናናቶነ አምኤቶ አጋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","ነ ዎጋራ አይፍያ ማጽያ ዎደ፥ እቱነ አተናን ዉርሳደ ማጻናዉ ላኤንꬁዋ ጉየ ስሞፓ፤ አቴዳዋ በትያዉ፥ አታ አዉ ባይና ናናቶነ አምኤቶ አጋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","ነ ዎይንያ አይፍያ ማጽያ ዎደ፥ አቴዳዋ ቃርማናዉ ላኤንꬁዋ ጉየ ቦፓ፤ ሄዋ በትያዉ፥ አታ አዉ ባይና ናናቶነ አምኤቶ አጋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","ህንተካ ግብጼ ጋድያን አይልያ ግዲደ ደኤዳዋ ዶጎፕተ። ታን ሀዋ ህንተና አዛዝያዌ ሄዋ ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","“ላኡ አሳቱ ዋላቀቲደ ፕርዳ ጎልያ ዮፐ፥ ዳናቱ ጌሻ ነ ልከ ጊደ፥ ናቄዳዋ ነ ባይዛንቻ ጊደ ፕርድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","ባይዛንቻይ ዋꬉ በስያዋ ግዶፐ፥ ትራን ግስሲደ ዞክያ ሾጫናዉ ዳናይ አዛዞ፤ ያቶፐ ባይዛንቻይ ዳና ስንꬃን ባረ ባይዙዋ ኬና ሾጨቶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","እ ኦይታሙዋ ጋካናዉ ሾጨቶፐ አትና፥ ሄዋፐ ዳሩዋ ሾጨቶፖ። ሄዋፐ ዳሩዋ አ ሾጮፐ፥ ነ እሻይ ነ ስንꬃን ካዉሻና። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“ኡዱማን ካꬃ የꬍያ ቦራ ዶና ቃቾፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","“እትፐ ደእያ እሻቱዋፐ እቱ ናኣ የለናን ሀይቆፐ፥ አ ማቻታ ሀራ ባደ ገሉፑ፤ እዝ አስና እሻይ እዞ አኮ፤ እዝዉ ኮሽያዋ ፖሎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","ያቶፐ ሀ ሀይቄዳዋ ሱንꬃይ እስራኤልያፐ ፕተት ꬋየናዳን፥ አ ኮይሮ የልያ አቱማ ናአይ ሀ ሀይቄዳዋ ሱንꬃን ጼገቶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","“ግዶ ሽን፥ እ ባረ እሻ ማቻቶ አካናዉ ኮያና ꬋዮፐ፥ እዛ ካታማ ፐንግያን ኡቴዳ ጭማቱዋኮ ባደ፥ ‘ታ አስና እሻይ ባረ እሻ ሱንꬃይ እስራኤልያን ደአናዉ ኮይቤና፤ ታና አኪደ፥ ታዉ ኮሽያዋ ኩንናን እጼዳ’ ያጋደ ማጋኑ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","ካታማ ጭማቱ አ ጼጊደ ኦችኖ፤ ሀእካ፥ ‘ታን እዞ አክከ’ ጊደ እጾፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","ሄ ሀይቄዳዋ ማቻቶ ጭማቱዋ ስንꬃን አኮ ሺቃደ፥ አ ገድያ ጫማፐ እቱዋ ከሳደ፥ አ ሶምኡዋን ጩቻ ጩቻደ ሀዋዳን ያጉ፤ ‘ባረ እሻዉ ዘረꬃይ ደአናዉ ኮየና አሳ ቦላ፥ ሀዋ ማላ ካዉሻይ ጋካናዉ በሴ’ ያጉ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","አ ዛሪ እስራኤልያን፥ ‘ጫማ ከሴዳዋንቱ ሶያ’ ጌተት ጼገቲደ ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","“ላኡ አሳቱ ዋትሽን፥ እቱዋ ማቻታ ያደ፥ ባረ አስና ሾጭያዋ ኩሽያፐ አሻናዉ፥ ባረ ኩሽያ የዳደ ህንኩዋ አቱማተꬃ ኦይቆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","እዝዉ አይነ ቃረተናን እ ኩሽያ ቃንጽተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","“ነ ኬሻ ግዶን ዴጾነ ካዉሻ ግዴዳ ላኡ ሚዛናቱ ደኦፕኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","ነ ሶን ዳርሲደነ ጉꬂደ ልክያ ላኡ ማክያባይ ደኦፖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","መꬍና ጎዳይ ነ ጾሳይ ነዉ እምያ ጋድያን አዱሳ ላይꬃ ነ ደአናዳን ኩመንꬃነ ልከ ሚዛናይነ ማክያባይ ነዉ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","አያዉ ጎፐ፥ መꬍና ጎዳይ ነ ጾሳይ ሄዋ ማላባ ኦꬂደ፥ ባለꬅያ አሳ ኡባ ሻቴ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","“ህንተ ግብጼፐ ከሲደ ቢደ ደእሽን፥ አማሌቃቱ ህንተ ቦላ ኦꬄዳዋ ሀሳይተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","ኡንቱንቱ ጾሳዉ ያየና አሳ፤ ህንተ ኦግያን ህንተናና ኤቀቴድኖ። ህንተ ሄመትሽን፥ ዳቡሪደ ጉየ አቴዳ አሳ ኡባ ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","ሄዋ ድራዉ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ሄ ቢታ ላትሲደ፥ ህንተ ዩሹዋን ደእያ ሞርከቱዋ ኡባፐ ህንተና ሸምፕስያ ዎደ፥ ሀ ጋድያን ኡንቱንታ ሀሳይያ አሳይ ꬋያና ጋካናዉ፥ አማሌቃቱዋ ኡባ ሳሉዋ ጉፋንꬃፐ ꬋይስተ፤ ሄዋ ኦꬃናዋ ሙለካ ዶጎፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ላትስያ ቢታ ገሊደ ኡትያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ጋድያን ሞኬዳ ካꬃ ኡባፐ ባይራትያዋ ቁንኣና መꬍና ጎዳይ ህንተ ጾሳይ ባረ ሱንꬃይ ሄዋን ጼሰታናዳን ዶሬዳ ሳአዉ አኪደ ቢተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","ያቲደ ሄ ዎድያን አዎትያ ቄስያኮ ቢደ፥ ሀዋዳን ያግተ፤ ‘መꬍና ጎዳይ ኑ እማና ጊደ ካሰ ኑ ማይዛ አዋቶ ጫቄዳ ሳኣ ታና ገልሴዳ መꬍና ጎዳዉ፥ ኑ ጾሳዉ፥ ሀች ታን ማርካታይ’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","“ያቶፐ ቄሲ ካꬃይ ኩሜዳ ቁንኣ ነ ኩሽያፐ አኪደ፥ መꬍና ጎዳዉ፥ ነ ጾሳዉ ያርሽያ ሳኣ ስንꬃን ዎꬆ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","ሄዋፐ ጉይያን፥ መꬍና ጎዳ ነ ጾሳ ስንꬃን ሀዋዳን ያጋደ ሃሳያ፤ ‘ታ ማይዛ አዉ ደኢያሳ ꬋዪደ መቶቴዳ ሶርያ ቢታ አሳ፤ እ መቶቲደ፥ ፓይዱዋን ጉꬃ አሳቱዋና ግብጼ ዎꬊደ ያን ደኤዳ። ሄዋን ደኢደ እ ዎልቃማ ዎልቃማነ ፓይዱዋን ጮራ ጋደ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","ሄዋ በኢደ፥ ግብጼቱ ኑዉ መቀꬃ ኢቴድኖ፤ ኑና ኡንኤꬄድኖ። ኑ ኦꬃናዳን ዴጾ ኦሱዋ ኑ ቦላ ጫኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","ያትና፥ ኑን መꬍና ጎዳዉ፥ ኑ አዎቱዋ ጾሳዉ፥ ዋሴዶ። መꬍና ጎዳይ ኑ ዋሱዋ ስሴዳ፤ ኑ ኡንኡዋ፥ ኑ ዳቡራነ ኑ ኡቁና በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","መꬍና ጎዳይ ባረ ዎልቃማ ኩሽያንነ ባረ ምጨቴዳ ቀስያን፥ ዎልቃማ ዳጋማን፥ ማላታንነ ማላልስያ ኦራꬃባ ኦꬅያዋን፥ ኑና ግብጼፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","ሀ ሳኣ ኑና አሂደ፥ ማꬃነ ኤሳ ጎግያ ሀ ቢታ ኑዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","ሄኮ ታን መꬍና ጎዳይ እሜዳ ቢታ አይፍያፐ ኮይሩዋ አሃድ’ ያጋደ፥ ቁንኣ መꬍና ጎዳ ነ ጾሳ ስንꬃን ዎꬃደ፥ አ ስንꬃን ጎይና። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","ነዉነ ነ ሶ አሳዉ መꬍና ጎዳይ ነ ጾሳይ እሜዳዋን ናሸቲደ፥ ጋላትተ፤ ሌዋቱነ ህንተ ግዶን ደእያ በተቱ ኡባይካ ህንተናና ናሸትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“አስራታ ከስያ ሄዛንꬃ ላይꬃን ላይꬃን ሞኬዳዋ ኡባፐ አስራታ ከሳደ ፖልያ ዎደ፥ ነ ካታማን ደእያ ሌዋቶ፥ በተቶ፥ አታ አዉ ባይናዋንቶነ አምኤቶ እማ፤ ያቶፐ ኡንቱንቱ ህንተ ካታማን ባረዉ ኮሽያ ካꬃ ማናነ ካላና። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","ሄዋፐ ጉይያን መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ ሀዋዳን ያጋ፤ ‘ታን ታ ጎለፐ ጾሳዉ ዱማቴዳ ካꬃ ከሳደ፥ ኔን ታና አዛዜዳ ነ አዛዙዋዳን ሌዋቶ፥ በተቶ፥ አታ አዉ ባይና ናናቶነ አምኤቶ እማድ። ታን ነ አዛዙዋፐ እቱዋነ መንꬃበይከ፤ ቃይ እቱዋነ ዶጋ አጋበይከ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","ታ ካዩዋ ዎደካ፥ ሄ አስራታፐ አይነ ማበይከ፤ ታን ዎጋን ጌሻ ግደና ዎደካ፥ አፐ ካረ ከሴዳዌካ ባዋ፤ ሀይቄዳ አሳዉካ አጫ ሄዋፐ ዎꬃበይከ። ታን መꬍና ጎዳዉ፥ ታ ጾሳዉ፥ አዛዘታድ፤ ቃይ ኔን ታና አዛዜዳዋ ኡባ ፖላድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","ኔን ደእያ ጌሻ ሳኣፐ፥ ሳሉዋፐ ሃ ዱገ ጼላ፤ ነ ደርያ እስራኤላነ ካሰ ኑ ማይዛ አዋቶ ነ እማና ጋደ ጫቄዳዋዳን ኑዉ እሜዳ ሀ ማꬃይነ ኤሳይ ጎግያ ቢታ አንጃ’ ያጋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","“ኔን ሀ አዋዮቱዋነ ዎጋቱዋ ናጋናዳን፥ መꬍና ጎዳይ ነ ጾሳይ ኔና ሀች አዛዜዳ፤ ሄዋ ድራዉ፥ ኔን ኡንቱንታ ነ ኩመንꬃ ዎዛናፐነ ኩመንꬃ ሸምፑዋፐ ናጋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","መꬍና ጎዳይ ነዉ ጾሳ ግዴዳዋ፥ ነ አ ኦግያን ሀመትያዋ፥ አ ዎጋ፥ አ አዛዙዋነ አ ህግያ ኔን ፖልያዋ ሀች ኤርሳዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","ቃይ መꬍና ጎዳይካ ባረ ገሌዳ ቃላዳን ኔን አ አሳ ግድያዋ፥ አዉ ቡዞ ሚሻ ግድያዋነ ኔን አ አዛዞ ኡባ ናጋናዋ ኤርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","ሄዋ ኔን ኦꬆፐ፥ እ መꬌዳ አሳ ኡባፐ ኔና ጋላታን፥ ሱንꬃንነ ቦንቹዋን ዎልቃማ ጋደ ኦꬃና መꬍና ጎዳይ ገሌዳ ቃላዳን ኔንካ አዉ ጌሻ ጋደ ግዳናዋ ሀች ኤርሴዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","ሄዋፐ ጉይያን፥ ሙሴ እስራኤልያ ጭማቱዋና ግዲደ፥ አሳ ሀዋዳን ያጌዳ፤ “ታን ሀች ህንተና አዛዝያ አዛዙዋ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","ዮርዳኖሳ ሻፋ ፕኒደ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ቢታ ገልያ ዎደ፥ ዎልቃማ ሹቻቱዋ ኤሲደ፥ ቦሹንቻን ኦክተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","መꬍና ጎዳይ ህንተ አዎቱዋ ጾሳይ ህንተንቶ እማና ጌዳዋዳን፥ ኤሳይነ ማꬃይ ጎግያ ቢታ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተንቶ እምያ ቢታ ህንተ ፕንያ ዎደ፥ ሀ ህግያ ቃላቱዋ ኡባ ሄ ሹቻቱ ቦላ ጻፍተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","ህንተ ዮርዳኖሳ ፕኔዳ ዎደ፥ ታን ህንተና ሀች አዛዜዳዋዳን፥ ሀ ሹቻቱዋ ኤባላ ደርያ ቦላን ኤሲደ፥ ኡንቱንታ ቦሹንቻን ኦክተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","ሄ ሳኣን መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ብራታ ሚሻይ ቦችቤና ሹቻፐ ያርሽያ ሳኣ ኦꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","ሄ ህንተ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ያርሽያ ሳኣ ማሰትቤና ሹቻፐ ኦꬅተ፤ ያቲደ ሄዋ ቦላን መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ጹግያ ያርሹዋ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","እትፐተꬃ ያርሹዋካ፥ ሄዋን ሚደ፥ መꬍና ጎዳ ህንተ ጾሳ ስንꬃን ናሸትተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","ሀ ህግያ ቃላቱዋ ኡባ ቆንጭያን ቤትያዋዳን ኦꬂደ፥ ሀ ህንተ ኤሴዳ ሹቻቱ ቦላ ጻፍተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","ሙሴ ቃይካ ሌዊያ ግድያ ቄሳቱ ዋና እትፐ ግዲደ፥ እስራኤልያ አሳ ኡባዉ ሀዋዳን ያጌዳ፤ “ህንተኖ እስራኤልያ አሳዉ፥ ጮኡ ጊደ ስስተ! ሄኮ ሀች ህንተ መꬍና ጎዳ ህንተ ጾሳ አሳ ግዴድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","ሄዋ ድራዉ፥ ሀች ታን ህንተንቶ እምያ አዛዙዋነ አዋዩዋ ናግያዋን፥ መꬍና ጎዳ ህንተ ጾሳ ቃላዉ አዛዘትተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","ሄ ጋላስካ ሙሴ አሳ ሀዋዳን ያጊደ አዛዜዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","“ህንተ ዮርዳኖሳ ፕኔዳ ዎደ፥ ጋሪዛማ ደርያ ቦላ ኤቂደ አሳ አንጃናዋንታ: ስሞና፥ ሌዊያ፥ ይሁዳ፥ ይሳኮራ፥ ዮሴፎነ ቢንያማ ዛራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","ቃይ አሳ ሸቃናዉ ኤባላ ደርያ ቦላ ኤቃናዋንቱ: ሮቤላ፥ ጋዳ፥ አሴራ፥ ዛብሎና፥ ዳናነ ንፍታሌማ ዛራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","ሌዋቱ ባረንቱ ቃላ ꬎቁ ኦꬂደ፥ እስራኤልያ አሳዉ ሀዋዳን ያግኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","“ ‘መꬍና ጎዳ ስንꬃን ቱና ግዴዳዋ፥ ኩሽያ ሂላንቻይ ማሲደ ከሴዳ ምꬃ ግድና፥ ዎይ ብራታ ትጊደ መꬌዳ ኤቃ ግድና፥ አዉ ጌማን ጎይንያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“ ‘ባረ አዉዋ ዎይ ባረ ዳዮ ካዉሽያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“ ‘ባረ ሾሩዋ ዛዋ ሱግያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“ ‘ቆቃይ ባናዉ በስያ ኦግያፐ ባላሳ ዛርያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“ ‘በትያ፥ አታ አዉ ባይና ናናቱዋ ፕርዳነ አምአት ፕርዳ ገላየዳ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“ ‘ባረ አዉዋ ማቻትና ግሲደ፥ ባረ አዉዋ ቦንቹዋ ካዉሽያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“ ‘አይ መህያናካ ግስያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“ ‘ባረ ምቻቶ ግድያ፥ አዉዋ ናትና ግድና፥ ባረ ዳይ ናትና ግስያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“ ‘ባረ ቦሎታትና ግስያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“ ‘ባረ ሾሩዋ ጌማን ዎꬍያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“ ‘ሻሉዋን ሻመቲደ፥ ጽሎ አሳ ዎꬍያ አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ አሳይ ኡባይ፥ ‘አመንእ!’ ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“ ‘ሀ ህግያ ቃላቱዋ ፖሊደ ምንሰና አሳይ ሸቀቴዳዋ ግዶ’ ያግና፥ “አሳይ ኡባይ ‘አመንእ!’ ” ያጎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","“መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ ፖሎ አዛዘቶፐ፥ ሀች ታን ነዉ እምያ አዛዙዋ ኡባ ሎይꬃደ ካሎፐ፥ መꬍና ጎዳይ ነ ጾሳይ ጋድያን ደእያ ካዉተꬃቱዋ ኡባፐ ኔና ꬎቁ ꬎቁ ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ ኔን አዛዘቶፐ፥ ሀዋፐ ካሊደ ደእያ አንጁ ኡባይ ነዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","“ኔን ካታማን አንጀቴዳዋ ግዳናዋ፤ ጋጻርያንካ አንጀቴዳዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","ነ ኡሉዋ አይፊ፥ ነ ሾይቃ አይፊ፥ ነ መህያ ማራቱነ ነ ዶርሳነ ነ ዴሻ ዉድያ ማራቱ፥ ጮራቲደ አንጀቴዳዋንታ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","ነ ካꬃ ቁንአይነ ነ ሙናቃ ከሪ አንጀቴዳዋንታ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","ኔን ገላደካ ከሳደካ አንጀቴዳዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","“ነ ቦላን ደንድያ ነ ሞርከቱዋ መꬍና ጎዳይ ነ ስንꬃን ጾነቴዳዋንታ ኦꬃና። ኡንቱንቱ ነ ቦላ እት ኦግያና ያና፤ ሽን ላፑን ኦግያና ነ ስንꬃፐ ባቃቲደ ꬋያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","“መꬍና ጎዳይ ነ ኩሺ ኦይቄዳዋ ኡባነ ነ ድይያ አንጃና፤ መꬍና ጎዳይ ነ ጾሳይ ነዉ እ እምያ ጋድያን ኔና አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","“ኔን መꬍና ጎዳ ነ ጾሳ አዛዙዋ ናጎፐነ አ ኦግያን ሀመቶፐ፥ እ ነዉ ካሰ ጫቄዳዋዳን፥ መꬍና ጎዳይ ኔና ባረዉ ዱማቴዳ ጌሻ ጋደ ኦꬂደ ኤሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","ሄዋፐ ጉይያን፥ ጋድያን ደእያ አሳይ ኡባይ መꬍና ጎዳ ሱንꬃይ ኔናን ጼገቴዳዋ በኢደ ያያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","መꬍና ጎዳይ ነዉ እማናዉ ካሰ ነ ማይዛ አዋቶ ጫቄዳ ሄ ጋድያን፥ ነ ኡሉዋ አይፍያ፥ ነ መህያ አይፍያነ፥ ነ ሾይቃ አይፍያ ዳርሲደ ኔና አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","“ነ ኩሽያ ኦሱዋ ኡባ አንጃናዉነ፥ መꬍና ጎዳይ ነ ቢታዉ እራ ዎድያን ቡክሳናዉ ባረ ምንጃ ጎልያ፥ ሳሉዋ ፐንግያ ነዉ ዶያና፤ ቃይ ኔን ዳሮ ካዉተꬃቶ ታልአናፐ አትና፥ ኦፐነ ሃ ታልአካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","መꬍና ጎዳይ ኔና ሁጰ ከሳናፐ አትና፥ ጉየ ዱፈ ከሰና። ሀቼ ታን ነዉ እምያ፥ መꬍና ጎዳ ነ ጾሳ አዛዙዋ ስሳደ፥ ሄዋ ሎይꬃደ ካሎፐ፥ ኔን ቦላ ግዳናፐ አትና፥ ጋርሳ ግዳካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","ታን ነዉ ሀች እሜዳ አዛዙዋፐ ሀድርሳነ ኡሸቻ ጋደ፥ ሀራ ጾሳቱዋ ካሎፓነ ኡንቱንቶ ኦꬆፓ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","“ሽን ኔን መꬍና ጎዳ ነ ጾሳ ቃላዉ አዛዘተናን እጻደ፥ ሀች ታን ኔና አዛዝያ ዎጋነ አዛዙዋ ኡባ ናገናን አጎፐ፥ ሀዋፐ ካሊደ ደእያ ሸቃቱ ኡባይ ነ ቦላ ያናነ ኔና ኡንቱንቱ ደማና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","“ኔን ካታማን ሸቀቴዳዋ ግዳና፤ ጋጻርያንካ ኔን ሸቀቴዳዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","“ነ ካꬃ ቁንአይነ ነ ሙናቃ ከሪ ሸቀቴዳዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","“ነ ኡሉዋ አይፊ፥ ነ ሾይቃ አይፊ፥ ነ መህያ ዉዲ፥ ነ ዶርሳነ ዴሻ ዉዲ ሸቀቴዳዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","“ኔን ገላደካ ከሳደካ ሸቀቴዳዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","“ኔን ነ ኢታ ኦሱዋን ታና አጌዳ ድራዉ፥ ኤለካ ኔን ꬋያና ጋካናዉ፥ ነ ኦꬅያ ኦሶ ኡባን መꬍና ጎዳይ ሸቃ፥ ሻቢርሳነ ሴራ የዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","ኔን ላታናዉ ብያ ጋድያፐ ꬋያና ጋካናዉ፥ መꬍና ጎዳይ ኢታ ሀርጊ ኔፐ ዱጸናዳን ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","መꬍና ጎዳይ ኔና ግልቃተꬃን፥ ምሹዋንነ ማዱꬃን፥ ጹግያ ሀርጊያንነ ኮሻን፥ ጫርኩዋንነ ዱማ ዱማ ካꬃ ሀርግያን ኔን ꬋያና ጋካናዉ ሾጫና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","ኔፐ ቦላና ነ ልክያን ደእያ ሳሉ ናሃሰ ብራታ ግዳናዋ፤ ነ ቢታይካ ብራታ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","መꬍና ጎዳይ ነ ጋድያን ቡክያ እራ ꬊልያነ ባና ከሳና፤ ኔን ጋድያፐ ꬋያና ጋካናዉ፥ ባናይ ሳሉዋፐ ዱገ ቡካና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","“መꬍና ጎዳይ ኔና ነ ሞርከቱዋን ጾንሳና፤ ኔን ኡንቱንታ ኦላናዉ እት ኦግያና ከሳና፤ ሽን ላፑን ኦግያና ነ ኡንቱንቱ ስንꬃፐ ባቃታና። ቢታን ደእያ ካዉተꬃ ኡባይ ነ ቦላ ጋኬዳዋ በኢደ፥ ያሻን ሻቢረታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","ነ አሃይ ሳሉዋ ካፉዋ ኡባዉነ ባዙዋ ዶአዉ ቁማ ግዳና፤ ኡንቱንታ የደርስያባይካ ደኤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","“መꬍና ጎዳይ ኔና ꬋሊ ባይና ግብጼ ማዱꬃን፥ ክጻን፥ እላሁዋንነ ፑሱዋን ኔና ሀርግሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","መꬍና ጎዳይ ኔና ጎሻን፥ ቆቀተꬃንነ ዳጋማን ሾጫና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","ጋላሳ ሴታን ኔን ቆቂ ꬉማን ታታፍያዋዳን ታታፋና፤ ነ ኦꬅያባይ ኡባይ ነዉ ጊገናን እጻና። ነ ደኦ ላይꬃ ኡባን ኡቁነታደነ ቦንቀታደ ደአና። ኔና ማድያ አሳካ ደማካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","“ኔን ማጫ ናቶ ጊግሳና ሽን፥ ሀራይ እዞ ቦንቂደ አፋና። ጎልያ ኔን ኬጻና፤ ሽን አን ደአካ። ዎይንያ ነ ቶካና፤ ሽን አ አይፍያ ማካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","ነ ቦራይ ነ ስንꬃን ሹከታና፤ ሽን አ አሹዋ ማካ። ነ ሀሪ ኔፐ ላገቲደ አከታና፤ ሽን ነዉ ጉየ ስመና። ነ ዶርሳይ ነ ሞርክያዉ እመታና፤ ሄዋ አሻናዉ ኔና ማድያዌ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","ነ አይፍያ ስንꬃን ነ አቱማ ናናቱነ ማጫ ናናይ ሀራ ካዉተꬃዉ እመታና፤ ኡንቱንቱ ስምና በአና ጋደ ጼልሽን፥ ነ አይፊ ጋልጃና፤ ሄዋ ድጋናዉ ነዉ አይ ዎልቃይነ ደኤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","ነ ቢታ አይፍያነ ነ ዳቡሬዳዋ ኡባ ነ ኤረና አሳይ ማና፤ ነ ደኦ ኡባን ኡቁነቴዳዋነ ናቀቴዳዋ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","ነ በእያ ኢታይ ኔና ጎሻና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","መꬍና ጎዳይ ꬋሊ ባይና ኢታ ማዱꬃን ነ ጉልባታነ ነ ዎድርያ ሀርግሳና፤ የꬍያ ገድያፐ ሁጲያ ጋካናዉ፥ ኔና ሄ ማዱꬃን ሾጫና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","“መꬍና ጎዳይ ኔናነ ነ ካትያ፥ ኔና ግድና፥ ነ ማይዛ አዎቱዋ ግድናካ ኤርቤና አሳ ጋደ አፋና። ሄዋን ኔን ምꬃፐነ ሹቻፐ መቴዳ ሀራ ጾሳቶ ጎይናና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","መꬍና ጎዳይ ኔና ላልያ ሀራ ካዉተꬃቱዋ ኡባ ግዶን ፖራ ሀዋንቱዋ ጊደ፥ ቅሊጭያዋነ ካእያዋ ግዳናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","“ኔን ዳሮ ካꬃ ነ ሾይቃን ዘራና፤ ሽን ቦሊ ም ድግና፥ ጉꬃ ካꬃ ሺሻና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","ዎይንያ ቶካደ፥ አ ኦꬃና፤ ሽን ጉጹኒ አ ም ድግና፥ አፐ አይነ ማጻካ፤ አጋደካ አፐ ኡሻካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","ነ ቢታ ኡባን ዛይትያ ዎጋራይ ሞካና፤ ሽን አይፊ ቆቆፈት ክችና፥ ዎጋራ ዛይትያ ደማካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","አቱማነ ማጫ ናናቱዋ ነ የላና፤ ሽን ኦላይ ኦሞድ አፍ ድግና፥ ኡንቱንቱ ኔናና ደእክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","ነ ምꬃ ኡባነ ነ ቢታ አይፍያ ቦሊ ዉርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","“ነ ግዶን ደእያ በቲ ነ ቦላ ꬎቁ ꬎቁ ጋና፤ ሽን ኔን ጉየ ያደ ዝቂ ዝቂ ጋና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","እ ነዉ ታልአናፐ አትና፥ ኔን አዉ ታልአካ፤ እ ሁጰ ግዳናዋ፤ ኔን ዱፈ ግዳናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","“መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ አዛዘተናን እጼዳ ድራዉነ እ አዛዜዳ አዛዙዋነ ዎጋ ናገናን እጼዳ ድራዉ፥ ኔን ꬋያና ጋካናዉ፥ ሀ ሸቃቱ ኡባይ ነ ቦላ ዎꬋና፤ ኔና ኡንቱንቱ የደርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","ሀ ሸቃቱ ነ ቦላንነ ነ ዛራቱ ቦላን መꬍናዉ ማላታነ ማላልስያዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","ነዉ ሳአይ እንጀቴዳ ዎደ፥ መꬍና ጎዳዉ፥ ነ ጾሳዉ፥ ናሸቻንነ ጋላታን ጎይናባካ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","ሄዋ ድራዉ፥ ኔና ኮሻን፥ ሳሙዋን፥ ካሉዋንነ መቱዋን ኡባባ ꬋያደ፥ መꬍና ጎዳይ ነ ቦላ የድያ ነ ሞርከቶ ሞደታና፤ መꬍና ጎዳይ ኔና ꬋይሳና ጋካናዉ፥ ነ ሞርግያን ብራታ ሞርገ ምꬃ ዋጻና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","“መꬍና ጎዳይ ኔን ኡንቱንቱ ቃላ ኤረና ካዉተꬃ አንኩ ፓልያዋዳን ኤሌልሲደ፥ ቢታ ጋጻፐ፥ ሃኩዋፐ ነ ቦላ አሀና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","ኡንቱንቱ ሀንቁዋ ሶምኡዋና ደእያዋንታ፤ ጭማ ቦንቼናዋንታ፤ ጉꬃቶካ ቃረተናዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","ኔን ꬋያና ጋካናዉ፥ ነ መህያ ማራነ፥ ነ ቢታ አይፍያ ማና። ኡንቱንቱ ኔን ꬋያና ጋካናዉ፥ ነ ካꬃ፥ ነ ዎይንያ ኤሳ፥ ነ ዛይትያ፥ ነ ሚዛነ ነ ዶርሳ ዉድያ ዉርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","ነ ጋድያን ደእያ ኔን አማነትያ፥ አዱሳ፥ ምኖ ድርሳቱ ሙለሳና ኮለታና ጋካናዉ፥ ነ ካታማ ዩሹዋን ዶዲደ፥ ኔና ኡንኤꬃና። መꬍና ጎዳይ ነ ጾሳይ ነዉ እሜዳ ቢታ ኡባ ዩሹዋን ዶዲደ ኔና ኡንኤꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","“ነ ሞርከቱ ካታማ ዶዲደ ኔና ኡንኤꬅያ ዎደ፥ ምያዋ ꬋያደ፥ መꬍና ጎዳይ ነ ጾሳይ ነዉ እሜዳ፥ ነ ኡሉዋ አይፍያ ግድያ፥ ነ አቱማ ናናቱነ ነ ማጫ ናናቱ አሹዋ ኔን ማና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","ነ ግዶን ሀራይ አቶ ካሰ ሱረተꬃንነ አሽከተꬃን ደኤዳ ግያ አስካ ባረ እሻዉ፥ ባረ ሲቅያ ማቻትዉነ ባረ የሌዳ ናናቶ ቃረተና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","ሞርከቱ ካታማ ዶዲደ ኡንኤꬄዳዋፐ ደንዴዳዋን፥ ሀራባይ ማናዉ ባይና ድራዉ፥ ባረ ምያ ባረ ናናቱ አሹዋፐ ሀራዉ ኦስነ እመና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","ነ ግዶን ካሰ ሱረተꬃንነ አሽከተꬃን ደኣዱ ግያ፥ ባረ ዱረተꬃፐ ደንዴዳዋን ሳኣ የꬋናዉ ሻተትያ ማጫ ምሽራታካ፥ ባረ ሲቅያ አስናዉ ባረ አቱማነ ማጫ ናናቶ ቃረተናን፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","አ ባረ የሌዳ ናኣና ዬዳ ጉየባ ባረ ሲቅያ አስናካ ባረ የሌዳ ናናቱዋካ ጋናን፥ ኡዘታደ ጌማን ባረካ ማድጋና። አያዉ ጎፐ፥ ሞርኪ አ ደእያ ካታማ ዶዲደ እዞ ኡንኤꬄዳነ ቱጋዬዳ ድራዉ፥ እዝዉ ምያባይ ሀራባይ አያይነ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","“ሀ ማጻፋን ጻፈቴዳ ህግያ ቃላቱዋ ኡባ ኔን ናጋና ꬋዮፐ፥ መꬍና ጎዳይ ነ ጾሳይ ማላልስያነ ያሽያ ሱንꬃ ቦንቼናን አጎፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","ነ ቦላነ ነ ዛርያ ኡባ ቦላ መꬍና ጎዳይ ያሽያ ቦሻ፥ ስመና ባሻነ ꬋሊ ባይና ኢታ ሀርግያ ነ ቦላ የዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","“ካሰ ግብጼ አሳ ቦላ በኣደ፥ ኔን ያዬዳ ግብጼ ሀርግያ ኡባ ዛሪደ፥ ነ ቦላ አሀና፤ ሄ ሀርጊ ኔና የደና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","ቃይ ሀ ህግያ ማጻፋን ጻፈትቤና ሀርገ ኡባነ ቦሻ ኡባ ነ ꬋያና ጋካናዉ፥ መꬍና ጎዳይ ነ ቦላ አሀና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","መꬍና ጎዳ ህንተ ጾሳ ቃላ ስሰናን እጼዳ ድራዉ፥ ሳሉዋ ጾልንትያዳን ጮራቴዳ ህንተፐ ጉꬃይ አታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","መꬍና ጎዳይ ህንተንቶ ሎኦባ ኦꬅያ ዎደነ ህንተ ፓይዱዋ ጮራይያ ዎደ ዶሴዳዋዳን፥ ሀእ ህንተ ቦላን ባሻ አህያ ዎደካ ህንተና ላልያ ዎደካ ናሸታና፤ ህንተ ላታናዉ ብያ ቢታፐካ ሾደቲደ ꬋያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","“መꬍና ጎዳይ ህንተና ቢታዉ ሀ ጋጻፐ ያ ጋጻ ጋካናዉ፥ ቢታ ኡባን ላላና። ሄዋን ህንተና ግድና፥ ዎይ ህንተ ማይዛ አዎቱ ኤርቤና፥ ሀራ ምꬃነ ሹቻ ጾሳቶ ጎይናና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","ሄ ካዉተꬃቱዋ ግዶን ህንተ ዎፓ ደምክታ፤ ህንተ ገድያ ጫማይ የꬍያ ሳኣ ኬሻ ጋዲካ ህንተንቶ ደኤና። ሄዋን መꬍና ጎዳይ ህንተንቶ መቶባ ቆፋ ጻላላን ኩሜዳ ሁጲያ፥ አሞ ጻላላን ዳቡሬዳ አይፍያነ ህዶታ ቃንጹዋን ኩሜዳ ዎዛና እማና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","ህንተ ደኡ ኡባይ ህርጋና ግዳናዋ፤ ጋላስነ ቃማ ሻቢርሳንነ ሀይቁዋ ያሻን ኡንኤቲደ ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","ህንተ ዎዛናን ኩሜዳ ያሻፐነ ህንተ አይፊ በእያ ፓላፐ ደንዴዳዋን፥ ህንተ ዎንትያ ዎደ፥ ‘አዉደ ቃማንዴሻ’ ቃይ ቃምያ ዎደ፥ ‘አዉደ ዎንታንዴሻ’ ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","ታን ህንተና፥ ‘ላኤንꬆ ሀ ኦግያ ቢክታ’ ጌዳ ኦግያና መꬍና ጎዳይ ህንተና ዛሪደ ማርካብያን ጉየ ግብጼ የዳና። ሄዋን ህንተ አይልያ ግዳናዉ፥ ህንተ ሞርከቶ ህንተና ዛልአናዉ ኮያና፤ ሽን ህንተና አይለያናዉካ ሻምያዋ ደምክታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","መꬍና ጎዳይ ሲና ደርያን እስራኤላቱዋና ጫቀቴዳ ጫቁዋ ቃላ ቦላ ሀራ ሞኣበን ኡንቱንቱና ጫቀታናዉ ሙሳ አዛዜዳ ጫቁዋ ቃላቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","ሙሴ እስራኤልያ አሳ ኡባ ጼስ ሺሺደ፥ ኡንቱንቶ ኦድያባይ ሀዋ፦ “መꬍና ጎዳይ ህንተ ስንꬃን ግብጼ ካትያ ቦላ፥ አ ኦላንቻቱዋ ኡባ ቦላነ አ ቢታ ኡባ ቦላ ኦꬄዳዋነ ጋꬄዳዋ ህንተ አይፍያን በኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","ሄ ኢታ መቶቱዋ፥ ዎልቃማ ማላልስያዋንታነ ኦራꬃባቱዋ ህንተ አይፍያን በኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","ሽን ሀች ጋካናዉ፥ መꬍና ጎዳይ ህንተንቶ አኬክያ ዎዛና፥ ጼልያ አይፍያነ ስስያ ሀይꬃ እምቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","ጾሳይ ኦይታሙ ላይꬃ ኩመንꬃ ህንተና ቢታ ባዙዋን ካለꬅያ ዎደ፥ ህንተ ማዩ ህንተ ቦላፐ ዉርቤና፥ ህንተ ጫማይካ ህንተ ገድያፐ ዉርቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","ህንተ ምያ ኡክꬃይ፥ ኡሽያ ዎይንያ ኤሳይ፥ ዎይ ሀራ ማꬆይያ ኡሻይ ባዋ፤ ꬋዮፐካ መꬍና ጎዳይ ህንተንቶ ጾሳ ግድያዋ ኤርሳድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","“ኑን ሀ ሳኣ ጋኬዳ ዎደ፥ ሀሰቦና ካቲ ስሆንነ ባሳነ ካቲ ኦግ ኑናና ኦለታናዉ ዬድኖ፤ ሽን ኑን ኡንቱንታ ጾኔዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","ኡንቱንቱ ቢታ አኪደ፥ ሮቤላነ ጋዳ ዛራቱ ቃይ ምናሰ ዛርያፐ ባጋዉ ላታ ኦꬂደ እሜዶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","“ህንተ ኦይቆባይነ የꬎባይ ህንተንቶ አንጀታና ማላ፥ ሀ ጫቁዋ ቃላቱዋ አማነቲደ ፖልተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","ሀቼ ህንተ ኡባይ፥ ዛርያ ካፓቱ፥ ጭማቱ፥ ሱንꬃቱነ እስራኤልያ አሳይ ኡባይ ሀዋን መꬍና ጎዳ ስንꬃን፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","ህንተ ናናቱዋና፥ ህንተ ማጫ አሳና ህንተ ግዶን ደእያ ካረ ቢታ አሳናነ ህንተ ሶን ምꬃ ቆርያነ ሃꬃ ትክያ ኦሳንቻቱዋና እትፐ፥ ሀዋን ኤቄድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","መꬍና ጎዳና፥ ህንተ ጾሳና፥ ቃላ ጫቁዋ ገላናዉ፥ መꬍና ጎዳና ጫቁዋን ማዬዳዋ ፖላናዉ ጊጊደ ሺቄድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","መꬍና ጎዳይ ህንተና ባረ አሳ ኦꬂደ ምንሳና፤ ህንተንቶነ በን ህንተ ማይዛ አዋቶ፥ አብራሃማዉ፥ ይሳቃዉነ ያቆባዉ ገሌዳ ጫቁዋ ቃላዳን፥ እ ህንተንቶ ጾሳ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","ታን ሀ ጫቁዋ ሚኖ ቃላ ጫቁዋ ኡዳ ዎꬅያዌ ህንተ ጻላላና ግዲደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","ሀቼ ሀዋን ኑናና መꬍና ጎዳ ኑ ጾሳ ስንꬃን ኤቄዳ ኑ ኡባናነ ስንꬃናዉ ያና ኑ የለታ ኡባና ዎꬃይ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","“ኑን ግብጼን ዋን ደኤደንቶነ ቃይ ሀዋ ጋካናዉ፥ ኦግያን ደእያ ካዉተꬃቱዋ ግዱዋና ዋን አꬊደ ዬደንቶ ኤሪታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","ኡንቱንቱ ግዶን ደእያ ቱና ኤቃ፥ ማሴዳ ምꬃ፥ ሹቻ፥ ብራነ ዎርቃ ኤቃ ምስለቱዋ በኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","ሀ ህንተፐ ኦንነ አቱማዋ ግድና ማጫዋ ግድና፥ እት ጎልያ አሳ ግድና ዛረ ግድና፥ መꬍና ጎዳፐ፥ ኑ ጾሳፐ፥ ሸርእ ጊደ፥ ሀራ ካዉተꬃቱዋ ጾሳቶ ጎይነናዳን ናገትተ። ሄዋ ኦꬅያ አሳይ ጫምያነ ዎꬍያ አይፍያ አይፍያ ምꬃ ጻጱዋ ግዳናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","“ሀ ጫቁዋ ቃላ ስሲደ፥ ባረ ዎዛናን፥ ‘ታ ሸንያን ታን ቦፐካ፥ አያ መቱነ ባዋ’ ያጊደ ባረና ጭሞፐ፥ ሄዋ ማላ አሳይ ሎኦቱዋ ቦላነ ኢታቱዋ ቦላ ባሻ አሀና። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","መꬍና ጎዳ ሀንቁነ ቃናቲ ሄዋ ማላ አሳ ቦላ ኤጽ ከሳናፐ አትና፥ መꬍና ጎዳይ አ ማረና። ሀ ማጻፋን ጻፈቴዳ ሸቃ ኡባይ አ ቦላ ያና፤ ሳሉዋፐ ጋርሳ ባጋፐ አ ሱንꬃ መꬍና ጎዳይ ꬋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","መꬍና ጎዳይ ሀ ህግያ ማጻፋን ጻፈቴዳ ሸቃ ጫቁዋዳን ሄ አሳ እስራኤልያ አሳፐ ሻኪደ ꬋይሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","“ስንꬃፐ ይያ የለታይ፥ ህንተ ዛሪነ ሃኮ ደርያፐ ይያ ሀራ ቢታ አሳይ መꬍና ጎዳይ ህንተ ቦላ አሄዳ ቦሻነ ሀርግያ በአና። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","ቢታ ኡባይ ዲንያንነ ማጽንያን ካመቲደ፥ አያ ጎአነ እመናዋ ግዳናዋ፤ አያነ ዘራናዉነ ሞክሳናዉ ዳንዳየተና፤ እን ማታይ ምꬃይ ድጨና። መꬍና ጎዳይ ባረ ሀንቁዋን ꬋይሴዳ ሶዶማዳንነ ጋሞራዳን፥ አዳማዳንነ ጻቦይማ ካታማቱዋዳን ሀናና። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","ካዉተꬃ ኡባይ ሀዋዳን ያጋና፤ ‘መꬍና ጎዳይ ሀ ጋድያን ሀዋ ማላባ አያዉ ኦꬄዴ? ሀ ዎልቃማ ሀንቁዎ ጋሶ ግዴዳባይ አዬ?’ ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","“አሳይ ዛሪደ፥ ‘ኡንቱንቱ መꬍና ጎዳይ፥ ኡንቱንቱ አዎቱዋ ጾሳይ፥ ኡንቱንታ ግብጼፐ ከስያ ዎደ፥ ኡንቱንቱና ገሌዳ ጫቁዋ ቃላ መንꬄዳ ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","ቃይ ኡንቱንቱ ቢደ፥ ኤረና ጾሳቶነ እ ኡንቱንታ ጎይኖፕተ ጌዳ ጾሳቶ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","ሄዋ ድራዉ፥ መꬍና ጎዳይ ሀንቀቲደ፥ ሀ ማጻፋን ጻፈቴዳ ሸቃ ኡባ ኡንቱንቱ ቦላ አሄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","መꬍና ጎዳይ ዎልቃማ ሀንቁዋ ሀንቀቲደ፥ ኡንቱንቱ ጋድያፐ ኡንቱንታ ሾዲደ፥ ሀዋዳን ሀራ ቢታ የደርሴዳ’ ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","“ጹራ የዎቱ መꬍና ጎዳ ኑ ጾሳሳ፤ ሽን ኑን ሀ ህግያ ቃላ ኦꬃናዳን፥ ቆንጬዳ የዎቱ መꬍናዉ ኑሳነ ኑ ናናቱዋሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","“ሀ ታ ህንተ ስንꬃን ዎꬄዳ አንጁነ ሸቃይ ህንተ ቦላን ጋክያ ዎደ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ላልያ ሀራ ካዉተꬃቱዋ ግዶን ደኢደ፥ ሀዋ ህንተ ሀሳያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ሄ ዎደ ህንተነ ህንተ ናናይ መꬍና ጎዳኮ፥ ህንተ ጾሳኮ፥ ስሚደ፥ ህንተ ኩመንꬃ ዎዛናፐነ ህንተ ኩመንꬃ ሸምፑዋፐ ታን ሀች ህንተና አዛዜዳ ቃላዉ አዛዘቶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","ሄዋን መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ኦሞዱዋ ዛራና፤ እ ህንተንቶ ቃረታና። መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ላሌዳ ካዉተꬃቱዋ ኡባ ግዶፐካ ዛሪደ ሺሻና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","ቢታ ጋጻ ጋካናዉ ላለቶፐካ፥ ሄዋፐ መꬍና ጎዳይ ህንተ ጾሳይ ህንተና ዛሪደ ሺሻና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","ህንተ አዎቱ ካሰ ላቴዳ ቢታ ህንተካ ላታናዳን ጾሳይ ህንተ ጾሳይ ህንተና ሄ ቢታዉ አሀና። ያን ህንተና ህንተ አዎቱዋፐ አꬂደ ዱረያናነ ህንተ ፓይዱዋ ዳርሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","“ህንተ ደኡዋን ደአና ማላነ መꬍና ጎዳ ህንተ ጾሳ ህንተ ኩመንꬃ ዎዛናፐነ ህንተ ኩመንꬃ ሸምፑዋፐ ሲቃናዳን፥ እ ህንተንቶነ ህንተ ናናዉ አዛዘትያ ዎዛና እማና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","መꬍና ጎዳይ ህንተ ጾሳይ ሀ ሸቃ ኡባ ህንተ ሞርከቱነ ህንተና የደርስያዋንቱ ቦላ አሀና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","ህንተካ ዛሪደ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ አዛዘታና፤ ታን ሀች ህንተና አዛዝያ አ አዛዙዋካ ናጋና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","10","ህንተ ሀ ህግያ ማጻፋን ጻፈቴዳ መꬍና ጎዳ ህንተ ጾሳ አዛዞቱዋነ አ ዎጋቱዋ ናጋናዉ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ አዛዘቶፐ፥ ቃይ ህንተ ህንተ ኩመንꬃ ዎዛናፐነ ህንተ ኩመንꬃ ሸምፑዋፐ መꬍና ጎዳኮ፥ ህንተ ጾሳኮ፥ ስሞፐ፥ እ ህንተና ህንተ ኩሽያ ኦሶ ኡባን፥ ህንተ ኡሉዋ አይፍያን፥ ህንተ መህያ አይፍያንነ ህንተ ቢታ አይፍያን ዳርሲደ አንጃና። አያዉ ጎፐ፥ ካሰ ህንተ አዎቱዋ አንጅያዋን ናሸቴዳዋዳን፥ መꬍና ጎዳይ ሀእ ህንተና አንጅያዋንካ ናሸታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","“ታን ሀች ህንተና አዛዝያ ሀ አዛዙ ሄዋ ኬሻ ዴጾ ግደና፤ ህንተፐ ሃኮካ ግደና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","ህንተ፥ ‘ኑን ስሲደ አዛዘታናዳን፥ ሳሉዋ ከሲደ ኑዉ ዎꬃናዌ ኦኔ?’ ጌናዳን ሳሉዋን ደኤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","‘ኑን ስሲደ አዛዘታናዳን፥ ኑዉ አባ ፕኒደ አሀናዌ ኦኔ?’ ጌናዳን አባ ሄፍንꬃን ደኤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","ቃላይ ህንተንቶ ሎይꬅ ማታን ደኤ፤ ህንተ ኦꬃናዳን፥ ቃላይ ህንተ ዎዛናንነ ህንተ ዶናን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“በእተ፥ ታን ሀች ህንተ ስንꬃን ደኡዋነ ሎኦተꬃ፥ ሀይቁዋነ ባሻ ዎꬃድ። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","ህንተ መꬍና ጎዳ ህንተ ጾሳ ሲቅያዋን አ ኦግያን ሀመትያዋንነ አ አዛዙዋ፥ አ አዋዩዋነ አ ዎጋ ናግያዋን፥ ታን ሀች ህንተና አዛዝያ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ አዛዘቶፐ፥ ህንተ ደኡዋን ደአናነ ጮራታና፤ ቃይ ህንተ ላታናዉ ገልያ ጋድያን መꬍና ጎዳይ ህንተ ጾሳይ ህንተና አንጃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","“ሽን ህንተ ዎዛናይ ዎራ ስምና፥ ህንተ አዛዘተናን እጾፐ፥ ሀራ ጾሳቶ ጎይኖፐ፥ ቃይ ኡንቱንቶ ኦꬆፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","ህንተ ዉር ꬋያናዋ ታን ሀች ህንተንቶ ኦዳይ። ዮርዳኖሳ ፕኒደ፥ ህንተ ላታናዉ ብያ ጋድያን ህንተ ላይꬃይ አዱቀና። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","“ታን ህንተ ስንꬃን ደኡዋነ ሀይቁዋ፥ አንጁዋነ ሸቃ ዎꬄዳዎ ሀች ሳሉዋነ ሳኣ ህንተ ቦላ ማርካያና፤ ስም ህንተነ ህንተ ዛሪ ደኡዋን ደአና ማላ፥ ደኡዋ ዶርተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","መꬍና ጎዳ ህንተ ጾሳ ሲቅተ፤ አ ቃላ ስስተ፥ አዉ አዛዘትተ፤ አናና ኦይቀትተ። ሄዋዳን ሀኖፐ፥ መꬍና ጎዳይ ህንተዉ ደኡዋ። ካሰ ህንተ ማይዛ አዋቶ፥ አብራሃማዉ፥ ይሳቃዉነ ያቆባዉ እማናዉ ጫቄዳ ጋድያን ህንተነ ህንተ ናናይ አዱሳ ላይꬃ ደአና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","ሙሴ ጉጂድካ እስራኤልያ አሳዉ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“ሀእ ታዉ ጼታነ ላታሙ ላይꬃ ግዴዳ ድራዉ፥ ሀዋፐ ስንꬃናዉ ህንተና ካለꬃናዉ ዳንዳይከ፤ ሄዋ ቦላካ መꬍና ጎዳይ ታና፥ ‘ኔን ዮርዳኖሳ ሄፍንꬃ ፕናካ’ ያጊደ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","መꬍና ጎዳይ ህንተ ጾሳይ ህንተ ስንꬃን ሀመቲደ ህንተና ካለꬃና። ሄዋን ደእያ ካዉተꬃቱዋ እ ዉርስያ ድራዉ፥ ኡንቱንቱ ቢታ ህንተ ላታና። ቃይ መꬍና ጎዳይ ጌዳዋዳን ኢያሱ ህንተና ካለꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","መꬍና ጎዳይ አሞረ ካተቱዋ ስሆናነ ኦጋ ጾኒደ፥ ኡንቱንቱ ቢታ ꬋይሴዳዋዳን፥ ህንተ ሞርከቱዋካ ሄዋዳን ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","መꬍና ጎዳይ ኡንቱንታ ህንተንቶ አꬅ እማና፤ ህንተ ኡንቱንቱ ቦላ ታን ህንተና አዛዜዳዋዳን ኦꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","ምንተ፤ አይነ ባዋ፤ ያዮፕተ። ኡንቱንታ በኢደ ዳጋሞፕተ። አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተ ጾሳይ ህንተናና ግዳናዋ። እ ህንተና የገና ዎይ አገና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","ሄዋፐ ጉይያን፥ ሙሴ ኢያሳ ጼሲደ፥ እስራኤልያ አሳ ኡባ ስንꬃን ሃዋዳን ያጌዳ፥ “ምና፤ ገንጫ። አያዉ ጎፐ፥ ኔን ሀ አሳና እትፐ መꬍና ጎዳይ ኡንቱንቱ ማይዛ አዋቶ እማና ጊደ ጫቄዳ ቢታ ገልሳሳ፤ ሄ ቢታካ ኡንቱንታ ላትሳሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","እ መꬍና ጎዳይ ባረ ሁጲያዉ ኔናና ግዲደ ኔና ካለꬃና። እ ኔና ኦለና፤ አይነካ ኔና አገና። ሄዋ ድራዉ፥ ያዮፓ፤ ነ ዎዛናን ዳጋሞፓ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","ሙሴ ሀ ህግያ ጻፊደ፥ መꬍና ጎዳ ጫቁዋ ታቦታ ቶክያ ቄሰ ግድያ ሌዊያ ናናቶነ እስራኤልያ ጭማቶ ኡባዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","ሙሴ ኡንቱንታ ሀዋዳን ያጊደ አዛዜዳ፤ “አጩ ኡባይ አቶ ጌተትያ ላፑንꬃ ላይꬃ ዉርሰꬃን፥ ቦንቼትያ ዳስያ ባላ ጋላሳን፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","መꬍና ጎዳ ህንተ ጾሳ ስንꬃ እ ዶሬዳ ሳኣ አዉ ጎይናናዉ እስራኤልያ አሳይ ኡባይ ሺቅያ ዎደ፥ ኡንቱንቱ ስስያዋዳን ናባብተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","ኡንቱንቱ ኡባይካ ስሲደ፥ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ያይያዋ ታማራና ማላ፥ ሀ ህግያ ቃላ ኡባ አማነቲደ ፖላና ማላ፥ አሳ፥ አቱማነ ማጫ፥ ናናቱዋነ ህንተ ጋድያን ደእያ ካረ ቢታ አሳ እትፐ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","ሀ ህግያ ቃላ ኤረና ኡንቱንቱ ናናይካ ዮርዳኖሳ ፕኒደ፥ ህንተ ላታናዉ ብያ ጋድያን ህንተ ደእያ ላይꬃ ኡባን ሀ ህግያ ስስኖ፤ መꬍና ጎዳዉ፥ ህንተ ጾሳዉ፥ ያይያዋ ታማርኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ “በአ፥ ኔን ሀይቂያ ጋላሳይ ማቴዳ። እ ካለሰትያ አዛዙዋ አዉ ታን እማና ማላ፥ ኢያሳ ጼሳደ፥ ኔን አናና እትፐ ዱንካንያ ግዶ ገልተ” ያግና፥ ሙሴነ ኢያሱ ዱንካንያኮ ሺቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","መꬍና ጎዳይ ሄ ዱንካንያን ሻርያ ቱሳን ኡንቱንቶ ቆንጬዳ፤ ሄ ሻርያ ቱሳይካ ዱንካንያ ፐንግያን ኤቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ “ኔን ማታን ሀይቃደ ነ አዎቱዋን ጋከታሳ። ኔፐ ጉይያን፥ ሀ አሳይ ታዉ አማነተናዋ ግዳና፤ ታን ኡንቱንቱና ዎꬄዳ ጫቁዋ መንꬃና። ኡንቱንቱ ታና አጊደ፥ ሻርሙጻቱዋዳን፥ ባረንቱ ላትያ ጋድያን ደእያ ኤቃቱዋ ካላና። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","ሄዌ ሀንያ ዎደ፥ ታ ሀንቁ ኡንቱንቱ ቦላ ኤጽ ከሳና። ታንካ ኡንቱንታ አጋ አጋና፤ ታ ሶምኡዋ ኡንቱንቱፐ ዎራ ዛራና። ያትና፥ ኡንቱንቱ ꬋያና፤ ጮራ መቱነ ባሻይ ኡንቱንቱ ቦላ ያና። ሄ ዎድያን ኡንቱንቱ፥ ‘ቱሙ ሀ መቱ ጋኬዳዌ ኑ ጾሳይ ኑ ግዶን ባይናዋ ግሻሳ ግደኔ?’ ያጊደ ኦቻና። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","ሀራ ጾሳቶ ጎይኒደ፥ ኡንቱንቱ ሀኔዳ ኢታባ ድራዉ፥ ታን ሄ ጋላስ ታ ሶምኡዋ ሙለካ ኡንቱንቱፐ ዎራ ዛራና። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","“ሄዋ ድራዉ፥ ሀእ ሀ ማዝሙርያ ጻፋደ፥ እስራኤልያ አሳ ኡባ ታማርሳ። ሀ ማዝሙሪ ታዉ እስራኤልያ አሳ ቦላ ማርካ ግዳና ማላ፥ ኡንቱንታ የጽሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","ኡንቱንቱ ማይዛ አዋቶ ገሌዳ ቃላዳን፥ ማꬃይነ ኤሳይ ጎግያ ቢታ ታን ኡንቱንታ ገልሴዳዋፐ ጉይያንነ ኡንቱንቱ ም ካሊደ፥ ዎዛናይ ሙሜዳዋፐ ጉይያን፥ ሀራ ጾሳቶ ጎይኒደ፥ ታና ካꬋና፤ ታ ጫቁዋካ መንꬃና። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","ዳሮ መቱነ ባሻይ ኡንቱንቱ ቦላ ጋኬዳ ዎደ፥ ሀ ማዝሙሪ ኡንቱንቱ ናናቱ ዶናፐ ድገተና ድራዉ፥ ኡንቱንቱ ቦላ ማርካ ግዳናዋ። አያዉ ጎፐ፥ ታን ጫቄዳ ቢታ ኡንቱንታ ብሮ ገልሰናን ደእሽን፥ ሃናናካ ኡንቱንቱ ቆፕያ ቆፋ ኤራክቻድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","ሙሴ ሄ ጋላስ ሄ ማዝሙርያ ጻፊደ፥ እስራኤልያ አሳ ታማርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","ሄዋፐ ጉይያን፥ መꬍና ጎዳይ ኔዌ ናኣ ኢያሳ ሀዋዳን ያጊደ አዛዜዳ፤ “ምና፥ ገንጫ፤ ታን ኡንቱንቶ እማናዉ ቃላ ገሌዳ ቢታ እስራኤልያ አሳ አፋደ ገልሳሳ። ታንካ ኔናና እትፐ ግዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","ሙሴ ሀ ህግያ ቃላቱዋ ኮይሮፐ ዉርሰꬃ ጋካናዉ፥ ጻፊደ ዉርሴዳዋፐ ጉይያን፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","መꬍና ጎዳ ጫቁዋ ታቦታ ቶክያ ሌዋቱዋ ሀዋዳን ያጊደ አዛዜዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“ህጊ ጻፈቴዳ ሀ ማጻፋ አፍተ፤ መꬍና ጎዳ ህንተ ጾሳ ጫቁዋ ታቦታ ማታን ዎꬅተ። ሄዋን እ ህንተ ቦላ ማርካ ግዳና ማላ ያን ዎꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","ህንተ ዎይሳ ማካላንቼንቶነ ዎይሳ ሞርግያ ꬉሌፈንቶ ታን ኤራይ። በእተ፥ ታ ህንተናና ደኤዳ ላይꬃ ኡባን ህንተ መꬍና ጎዳዉ ኢታ ማካላ፤ ሽን ታን ሀይቃ ክችና፥ ኡባ ዎይሳ ማካላንቴ? ");
INSERT INTO dwrENT_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","ሄዋ ድራዉ፥ ሀዋ ኡባ ታ ኡንቱንቶ ኦዳናዉ፥ ሳሉዋነ ሳኣ ታ ኡንቱንቱ ቦላ ማርካያናዉ፥ ህንተ ዛርያ ካፓቱዋ ኡባነ ደርያ ካለꬅያ አሳ ኡባ ታዉ ሺሽተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","ታ ሀይቄዳዋፐ ጉይያን፥ ህንተ ሙለ ኢታ አሳ ግዳናዋነ ታን ህንተና ታማርሴዳ አዛዙዋፐ ዎራ ስማናዋ ታን ኤራይ። እ ኦꬆፕተ ጌዳ ኢታባ ህንተ ኩሽያን ኦꬂደ፥ መꬍና ጎዳ ሀንቀꬅያ ድራዉ፥ ስንꬃፐ ይያ ዎድያን ህንተ ቦላ ኢታ ቦሻ አሀና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","ሄዋፐ ጉይያን፥ ሙሴ ሀ ማዝሙርያ ቃላቱ ዉራና ጋካናዉ፥ ሺቄዳ እስራኤልያ ሺቁዋ ኡባ ስሲደ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","ህንተኖ፥ ሳሎቶ፥ ታን ኦድያዋ ስስተ፤ ቢታይካ ታ ዶና ቃላ ስሶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","ታ ትምርቲ እራዳን ቡኮ፤ ታ ቃላቱካ ከተርሳዳን፥ ጾኩ ማታ ቦላን ዎꬍያ ፑሰ እራዳንነ ጫርሻ ቦላን ዎꬍያ ፑስያዳን ዎꬎ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","ታን መꬍና ጎዳ ሱንꬃ አዋያና፤ ግታተꬃ ኑ ጾሳዉ እምተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","እ ኑ ዛላቴ፥ አ ኦሱዋን ፖኩ ባዋ፤ አ ኦገ ኡባይካ ሱረ። ኑ ጾሳይ አማነትያዋነ ኢታተꬃይ ባይናዋ፤ እ ቱማንቻነ ሱረ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","ህንተ አማነተናነ አያዉነ ፓና፥ ናጋራንቻነ ባለꬅያ የለታ ግድያ ድራዉ፥ አ አሳ ግዳናዉ ህንተ በስክታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","ህንተኖ ኤያነ አኬክ ባይና አሳዉ፥ ህንተ መꬍና ጎዳዉ እምያ ዛሩ ሀዌ? እ ህንተና መꬌዳ ህንተ አዉዋ ግደኔ? እ ህንተና መꬊደ፥ ምንስ ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","ካሰ ዎድያ ቆፕተ፤ ዳሮ የለታቱ ላይꬃካ አኬክተ። ህንተ አዎቱዋ ኦችተ፤ ኡንቱንቱ ህንተና በሳና። ህንተ ጭማቱዋካ ኦችተ፤ ኡንቱንቱ ህንተንቶ ኦዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","ኡባፐ ዎልቃማይ ካዉተꬃቶ ኡንቱንቱ ደኢያሳ ላትሴዳ ዎደ፥ አሳ ናናቱዋ ኡንቱንቱ ዛርያን ዛርያን ሻኬዳ ዎደ፥ እስራኤልያ አሳ ፓይዱዋዳን፥ ኡንቱንቱ ዛዋ ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","አያዉ ጎፐ፥ ሻኩዋን መꬍና ጎዳ ጋኬዳዌ እስራኤልያ፤ ያቆብካ አ ጋኬዳ ላታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","ቢታ መላ ቢታን ኡንቱንቱ ሳሙዋን ደእሽን፥ ጫርኩዋ ጻላላይ ሱራግያሳን ብቻርሽን፥ ኡንቱንታ ደሜዳ። ያቲደ ባረ አይፍያ ቡሉዋዳን፥ ኡንቱንቶ ጎንዳለ ግዲደ፥ ኡንቱንታ ምንሲደ ናጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","አርጋንꬃይ ባረ ማራ ፓሉዋ ታማርስያዋዳን፥ ባረ ምጬዳ ቀፍያን ጋክ ኦይቂደ አሽያዋዳን፥ ሄዋዳን ጾሳይ ባረ ቀፍያን ሀጲደ ኡንቱንታ አሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","ሀራ አላጋ ጾስ ባይናን፥ መꬍና ጎዳ ጻላላይ ባረ አሳ ካለꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","እ ቢታዉ ꬎቃ ሳኣ ኡንቱንታ ከሴዳ። ሾይቃን ሞኬዳ አይፍያ ኡንቱንታ ምዜዳ። ዛላ ጳልቀꬃፐ ኡንቱንታ ኤሳ ምዜዳ፤ ሹቻ ጋድያፐ ዛይትያ ምዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","ኡንቱንቱ መህያ ዉድያፐ መኤዳ ማꬃነ ዴሻ ዉድያፐካ ማꬃ፥ ዶርሳ አንቃራነ ጋልሳ ሜድኖ፤ ቃይ ባሳነ ዶርሳ ዉድያነ ዴሻ፥ ሎኦ ዛርጋ ሜድኖ፤ ሱꬃ ማላትያ ዎይንያ ኤሳካ ኡሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","ያኒደ ይሽሩን ኦርዴዳ፤ ማካሌዳ፤ ም ሚደ፥ ቦቦርጬዳ። ባረና መꬌዳ ጾሳ አጌዳ፤ ባረ አቶተꬃ ዛላ ካꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","ኡንቱንቱ አላጋ ጾሳቶ ጎይንያዋን አ ምሽሴድኖ፤ ባረንቱ ቱና ኤቃቱዋን አ ሀንቀꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","ጾሳ ግደና ጻላሄቶ፥ ካሰ ኡንቱንቱ ኤርቤና ጾሳቶ፥ ዝኖ ከሴዳዋንቶ፥ ኡንቱንቱ አዎቱ ያይቤና ጾሳቶ ያርሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","ኡንቱንቱ ደኡዋ እሜዳ ዛላ ቆፕበይክኖ፤ ቃይ የል ድቼዳ ጾሳ ዶጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","መꬍና ጎዳይ ሄዋ በኢደ፥ ኡንቱንቱ ቦላ ሀንቀቴዳ። አ አቱማነ ማጫ ናናቱዋ እጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","ያቲደ ሀዋዳን ያጌዳ፤ “ታን ታ ሶምኡዋ ኡንቱንቱፐ ገንꬃና፤ ኡንቱንቱ ጌላነ አማነተና አሳ ግድያ ድራዉ፥ ኡንቱንቱ ኦማርሳ ጮኡ ጋደ ጼላና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","ጾሳ ግደናዋን ታና ምሽሴድኖ፤ ባረንቱ ኤቃቱዋን ታና ሀንቀꬄድኖ። ታንካ ኡንቱንቱ ዛረ ግደናዋንቱን ምሽሳና፤ ኤያ አሳ ዛራቱዋን ታን ኡንቱንታ ሀንቀትሳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","ታ ሀንቁ ታማዳን ኤጺደ፥ ጋድያን ደእያዋ ኡባ ጹጋና። ሄ ታማይ ስኦልያን ደእያዋናካ ጋꬂደ ጹጋና፤ ደርያ ባሱዋ ጋካናዉ፥ ሄ ታማይ ማና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","“ታን ኡንቱንቶ መቱዋ መቱዋ ቦላ ዶራና፤ ታ ዎንዳፍያን ኡንቱንታ ዱካና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","ኡንቱንቱ ኮሻን፥ ጹግያ ምሹዋንነ ኢታ ሀርግያን ዉራና። ኡንቱንቱ ቦላ መቶ ጋꬅያ ባዙዋ ዶአቱዋነ ኡንቱንታ ዱክያ አላጋ ሾሻቱዋ ኡንቱንቱ ቦላ የዳና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","ቶራይ ኦገ ኡባን ኡንቱንቱ ናናቱዋ ዉርሳና። ጎልያ ኡባን ሻቢርሳይነ ዳጋማይ ካተታና። ያላጋ አቱማዋንቱነ ማጫዋንቱ ዉራና፤ ጉꬃ ናናይካ ጭማቱካ አትክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","ኡንቱንታ ታን ሃኮ ሳአ ላላና፤ ሄዋፐ ጉይያን፥ ኡንቱንታ ሀሳይያባይ ꬋያና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","ሽን ኡንቱንቱ ሞርከቱ፥ ‘ኑ ዎልቃይ ኡንቱንታ ጾኔዳ፤ ሀዋ ኡባ መꬍና ጎዳይ ኦꬅቤና’ ያጊደ ኦቶሩዋን ጬቀተናን አግክኖ ያጋደ ቆፓድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","እስራኤልያ አሳይ ዞረት ባይና አሳ፤ አኬክ ኡንቱንቶ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","ኡንቱንቱ ጾነቴዳዌ አያነንቶ በአናዉ ኡንቱንቶ እጸቴዳ፤ ባረንቱ ዉርሰꬃይካ አየንቶካ ኤርክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","እት ሻአ አሳይ እት አሳን፥ ታሙ ሻአ አሳይ ላኡ አሳን፥ ዋን ጾነቴዴ? ኡንቱንቱ ዛላይ ኡንቱንታ ዛልኤዳ ግሻሳነ መꬍና ጎዳይ ኡንቱንታ አꬅ እሜዳ ድራሳ ግደኔ! ");
INSERT INTO dwrENT_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","ኡንቱንቱ ሞርከቱ ባረንቱ ጾሳይ ላፋ ግድያዋነ እስራኤልያ ጾሳዳን ዎልቃማ ግደናዋ ኤሪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","ኡንቱንቱ ዎይኒ ሶዶማ ዎይንያፐነ፥ ጋሞራ ሾይቃፐ ዬዳዋ። ኡንቱንቱ ቴራይ ማርዘ፤ ኡንቱንቱ ዉርጩካ ጫምያዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","ኡንቱንቱ ዎይንያ ኤሳይ ሾሻ ማርዘ፤ ዎꬍያ ማርዚ ደእያ ሀሱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","ጾሳይ፥ ሀዋ ታን ናጋደ ታ ማዝጎብያን አታማበይክታ? ");
INSERT INTO dwrENT_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","ኡንቱንቱ ባሻ ጋላሳይ ማታቴዳ፤ ኡንቱንቱ ቦላ ጋካናባይ ኤሌሌ። ሄ ዎደ ኡንቱንቱ ገዲ ꬉበታና። ታን ኡንቱንቶ ሀሉዋ ከሳናነ ኩሽያ ዛራና ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","ኡንቱንቱ ዎልቃይ ዳቡሬዳዋነ ኡንቱንታካ ማድያዌ ባይናዋ በኤዳ ዎደ፥ መꬍና ጎዳይ ባረ አሳዉ ፕርዳና፤ ባረ ቆማቶካ ቃረታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","እ ኡንቱንታ ሀዋዳን ያጋና፤ ኡንቱንቱ አማነትያ ኡንቱንቱ ጾሳቱ ሀቃነ? ኡንቱንቱ ባቃቲደ አ ግዶን ቆሰትያ ኡንቱንቱ ዛላይ ሀቃነ? ");
INSERT INTO dwrENT_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","ኡንቱንቱ ያርሹዋ ሞꬉዋ ሜዳዋንቱ፥ ኡንቱንቱ ኡሻ ያርሹዋ ዎይንያ ኤሳ ኡሼዳዋንቱ ሀእ ደንዲደ፥ አነ ኡንቱንታ ማድኖ፤ አነ ኡንቱንታ አሽኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","ጾሳይ ታናቴ። ታ ጻላላይ ጾሳ። ታፐ አትና፥ ሀራ ጾስ ባዋ። ዎꬍያዌ፥ ደኡዋካ እምያዌ ታና፤ ታን ማዱጽሳደ፥ ታን ፓꬃና፤ ታ ኩሽያፐ ኦንነ አሸና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","ታ ኩሽያ ፑደ ደንꬃደ ሀዋዳን ያጋና፤ “ታን መꬍናዉካ ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","ጶሉጶሉ ግያ ታ ማሻ ሌፋደ፥ ፕርዳናዉ ታ ኩሽያን ኦይቂያ ዎደ፥ ታ ሞርከቱዋ ቦላ ታ ሀሉዋ ከሳና፤ ታና እጽያዋንቶ ኡንቱንቱ ኩሽያ ዛራና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","ታ ዎንዳፈቱ ኡንቱንቱ ሱꬃን ማꬆታና፤ ታ ማሻይካ ኡንቱንቱ አሹዋ ማና። ታና እጽያ ኡባካ ማርከ። ሀራይ አቶ ማዱጼዳዋንቱነ ኦሞደቴዳዋንቱካ ሀይቃና” ያጋና ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","ህንተኖ ካዉተꬃቶ፥ ጾሳ አሳና ናሸትተ። እ ባረ ቆማቱ ሱꬃ አቻና፤ ባረ ሞርከቱዋ ቦላንካ ሀሉዋ ከሳና። ቢታን ደእያ ባረ አሳ ናጋራካ አቶ ጋና ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","ሙሴነ ኔዌ ናአይ ኢያሱ እስራኤልያ አሳ ስሲደ፥ ሀ ማዝሙርያ ቃላ ኡባ ሃሳዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","ሙሴ ሀ ቃላ ኡባ እስራኤልያ አሳ ኡባዉ ኦድ ዉርሴዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","ኡንቱንታ ሀዋዳን ያጌዳ፤ “ሀ ህግያ ቃላ ኡባ ኡንቱንቱ ናጋናዳንነ ኦꬃናዳን ህንተ ናናቱዋ አዛዛና ማላ፥ ሀች ታ ህንተንቶ ማርካትያ ቃላ ኡባ ህንተ ዎዛናን ዎꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","ሀ ቃላይ ህንተንቶ ደኦፐ አትና፥ ጮ መላ ቃላ ግደና። ሀ ቃላ ናጎፐ፥ ህንተ ዮርዳኖሳ ፕኒደ ላታና ቢታንካ አዱሳ ላይꬃ ደአና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","ሄ ጋላሳንካ መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“ሞኣበን እያርኮ ካታማፐ ስንꬃ ባጋና ደእያ አባርማ ደረቱዋፐ እቱዋ፥ ህን ናቦ ደርያ ከሳ፤ ሄዋን እስራኤልያ አሳ ታ ላትሳና ካናነ ቢታ ሄፍንꬃ ጼላ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","ነ እሻ አሮን ሆራ ደርያን ሀይቂደ፥ ባረ ማይዛ አዎቱዋን ጋከቴዳዋዳን፥ ኔንካ ሀ ከሴዳ ደርያን ሀይቃደ፥ ነ ማይዛ አዎቱዋን ጋከታና። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","አያዉ ጎፐ፥ ህንተ ላኡካ እስራኤልያ አሳ ስንꬃን ታዉ አማነትበይክታ፤ ጺና መላ ቢታን፥ ቃዴሳ ካታማ ማታን ደእያ ማሪባ ሃꬃ ማታን፥ ታ ጌሻተꬃ እስራኤልያ አሳ በስበይክታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","ሄዋ ድራዉ፥ ቢታ ሃኩዋን ሄፍንꬃ ጼላናፐ አትና፥ ታን እስራኤልያ አሳ ላትሳና ቢታ ገላካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","ጾሳ አሳ ግድያ ሙሴ ሀይቃናፐ ካሰቲደ፥ እስራኤልያ አሳ አንጄዳ አንጁዋ ቃላይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","እ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳይ ሲና ደርያፐ ዬዳ፤ ኤዶማፐ ኑ ቦላን ሃ ፖኤዳ፤ ፓራና ደርያፐ ባረ አሳዉ ፖኤዳ። ሻአን ፓይደትያ ኪታንቻቱ አናና ደኢኖ። አ ኡሸቻ ባጋና ታማ ላጩ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","ጾሳዉ ኔን ነ አሳ ሲቃዳ። ጌሻቱ ኡባይ ነ ኩሽያን ደኢኖ፤ ነ ገድያ ጻጱዋን ጉልባቲደ ጎይኒኖ፤ ያቲደ ኔፐ አዛዙዋ አኪኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","ሙሴ እሜዳ ህጊ ያቆባ አሳዉ ላታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","እስራኤልያ ዛራቱ ኡባይነ ይሹሩና ዛርያ ካፓቱ ሺቄዳ ዎደ፥ ጾሳይ ባረ አሳ፥ እስራኤልያ ቦላ ካተቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","“ሮቤል ሀይቆፖ፤ እ ፓጻ ደኦ። አ አሳይካ ፓይዱዋን ጮራቶ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","ሙሴ ይሁዳ ዛርያባ ሀዋዳን ያጌዳ፤ “አቤት መꬍና ጎዳዉ፥ ይሁዳ ዋሱዋ ስሳ፤ ሀራ ባረ ዳቦቱዋና ኡንቱንቱ ጋከታናዳን ኦꬃ። ኡንቱንቱ ኩሽያ ምንꬃ፤ ኡንቱንቱ ባረንቱ ሞርክያና ኦለትያ ዎደ፥ ኔን ኡንቱንታ ማዳ!” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","ሙሴ ሌዊያ ዛርያባ ሀዋዳን ያጌዳ፤ “ነ ቱሚምነ ኡሪሚ ነ ዶሴዳ አሳሳ። ኔን ማሳሀን ፓጬዳ፥ ማሪባ ሃꬃን ፓሉመቴዳ አሳሳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","ባረና የሌዳዋንቱፐ፥ ባረ እሻቱዋፐነ ባረንቱ ናናቱዋፐ አꬂደ፥ ኡንቱንቱ ነዉ አማነቴዳዌ አꬌ፤ ነ ጫቁዋ ቃላዉ ኡንቱንቱ አማነቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","ኡንቱንቱ ነ ዎጋ ያቆባ፥ ነ ህግያካ እስራኤልያ ታማርሲኖ። ነ ስንꬃን እጻና ጩዋዪኖ፤ ነዉ ያርሽያሳን ኡባና ጹግያ ያርሹዋ ያርሺኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","አቤት መꬍና ጎዳዉ ኡንቱንቱ ኩሺ ኦꬄዳዋ አንጃ፤ ኡንቱንቱ ኦꬅያ ኡባባን ነ ናሸትያዋ ኡንቱንቶ ቆንጭሳ። ኡንቱንቱ ቦላ ደንድያዋ መንሬꬃ ኦላ፤ ኡንቱንቱ ሞርከቱዋ ላኤንꬆ ደንꬆፓ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","ቢንያማ ዛርያባ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳይ ሲቄዳ አሳይ አን አማነቲደ ደኤ። ጋላሳ ኩመንꬃን ኡንቱንታ መꬍና ጎዳይ ናጌ፤ ባረ ሀሽያን ቶኪደ ሸምፕሴ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","ዮሴፎ ዛርያባ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳይ እራ እምያዋን፥ ጋድያፐ ሃꬃ ፑልትስያዋን፥ ኡንቱንቱ ቢታ አንጆ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","አዋይ ካꬅያ ዶረቴዳ አይፍያንነ ዎድያን ዎድያን ካእያ አይፍያን አንጀቶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","በንፐ ደእያ ኡንቱንቱ ደረቱነ ዞዜቱ ሎኦ አይፍያን አንጀትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","ኡንቱንቱ ቢታይ ሎኦባ ጻላላ ኩሜዳዋ ግዶ፤ ቡራን ኤጽያ ታማ ግዶን ሃሳዬዳ፥ ጾሳፐ ቤትያ አንጆ ጻላላን ኩሜዳዋ ግዶ። ሀ አንጆቱ ኡባይ ዮሴፎ ዛርያ ጋክኖ፤ አያዉ ጎፐ፥ እ ባረ እሻንቱ ግዶን ካፑዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","ዮሴፎ ኮይሮ የለቴዳ ኮሩማዳን ምኖ፤ አ ካጨቱ መንꬃ ካጭያዳን ምኖ። አ ካጨቱ ሻአን ፓይደትያ ምናሰ ዛራቱዋ፤ ታሙ ሻአን ፓይደትያ ኤፍሬማ ዛራቱዋ። ሄ ካጨቱዋን እ ካዉተꬃቱዋ ቃይጫና፤ ቢታ ጋጻ ጋካናዉ ኡንቱንታ እ ሱጋና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","ዛብሎና ዛርያባ ሀዋዳን ያጌዳ፤ “ኔኖ ዛብሎና፥ ኔን ነ ከሳን ናሸታ፤ ይሳኮራ፥ ኔንካ ነ ዱንካንያን ናሸታ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","ኡንቱንቱ ካረ ጋደ አሳ ባረንቱ ደርያኮ ጼሳና፤ ሄዋን ኡንቱንቱ ጌሻተꬃ ያርሹዋ ያርሻና። ባረ አቁዋነ ባረንቱ ዱረተꬃ፥ አባፐነ አባ ማታ ሻፍያፐ ደማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","ጋዳ ዛርያባ ሀዋዳን ያጌዳ፤ “ኡንቱንቱ ቢታ አሴዳ ጾሳይ ጋላተቶ፤ ጋድ ሞርክያ ሶምኡዋ መንꬃናዉ፥ ጋሙዋዳን ሻንካቴ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","ካፓቶ ጌዳ ሎኦ ቢታ ኡንቱንቱ አኬድኖ፤ እስራኤልያ ካፓቱ ሺቄዳ ዎደ፥ ኡንቱንቱ መꬍና ጎዳ ሸንያን ጌሻ ፕርዳ ፕርዴድኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","ዳነ ዛርያባ ሀዋዳን ያጌዳ፤ “ዳን ዎዳላ ጋሙዋ ማላ፤ እ ባሳነፐ ጉፒደ ከሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","ንፍታሌማ ዛርያባ ሀዋዳን ያጌዳ፤ “ንፍታሌም መꬍና ጎዳ አꬎ ኬካተꬃንነ አንጁዋን ዱረቴዳ፤ ኡንቱንቱ ቢታይ ጋሊላ አባፐ ቢደ ገድሳ ባጋ ጋኬ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","አሴራ ዛርያባ ሀዋዳን ያጌዳ፤ “አሴር ሀራ ዛራቱ ኡባፐ አꬊደ አንጀቴዳዋ። ባረ እሻቱዋንካ ዶሰቴዳዋ ግዶ። አ ቢታይ ዛይትያን ዱረቶ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","ኡንቱንቱ ካታማቱካ ብራታ ካርያን ጎርደቲደ ናገትኖ፤ ባረ ላይꬃ ኡባን እ ዎልቃማ ግድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“ኔኖ ይሽሩና፥ ሳሉዋፐ ህንተና ማዳናዉ፥ ባረ ግታተꬃን ሻራን ሀመትያ ህንተ ጾሳ ማላ ጾስ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","መꬍና ጾሳይ ህንተንቶ ደኡዋ፤ አ መꬍና ኩሸቱ ህንተፐ ጋርሳና ደኢኖ። እ ህንተ ስንꬃፐ ህንተ ሞርከቱዋ የደርሴዳ፤ ህንተ ኡንቱንታ ዉርስ ꬋይሳናዳን ህንተንቶ ኦዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","ሄዋ ድራዉ፥ እስራኤልያ አሳይ፥ ቦችያዌ ባይናን ሳሮተꬃን ደአና፤ ያቆባ ፑልቱ ቁማይነ ዎይንያ ኤሳይ ኩሜዳ ጋድያን ደአና፥ ሳሉዋ እራይ ቡክያሳን ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","ህንተኖ እስራኤልያ አሳዉ! ህንተ ዎት አንጀቴድቴ! መꬍና ጎዳይ አሼዳ ህንተ ማላይ ኦኔ? እ ህንተንቶ ጎንዳለነ ህንተና ማድያዋ፤ አን ህንተ ጾንያ ማሻ። ህንተ ሞርከቱ ህንተ ስንꬃን ጉፋናና፤ ህንተካ ኡንቱንቱ ጌሱዋ ላላና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","ሙሴ ሞኣባ ደምባፐ ደንዲደ፥ ናቦ ደርያ ሁጲያ፥ ቃይ ያርኮፐ አዋይ ዶልያ ባጋና ደእያ ፕስጋ ደርያ ሁጲያ ጋኬዳ። ሄዋን መꬍና ጎዳይ ዳና ጋካናዉ ደእያ ጋላኣደ ቢታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ንፍታሌማ ቢታ ኡባ፥ ኤፍሬማነ ምናሰ ቢታ፥ አዋይ ዉልያ ባጋና ቢደ ሜድተራነ አባ ጋካናዉ ደእያ ይሁዳ ቢታነ ");
INSERT INTO dwrENT_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","ገድሳ ባጋና ጾኣራፐ ደንዲደ፥ ዛምባይ ደእያ እያርኮ ካታማ፥ ዛንጋራን ደእያ ደምባ ኡባ በሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","መꬍና ጎዳይ ሙሳ ሀዋዳን ያጌዳ፤ “አብራሃመዉ ይሳቃዉነ ያቆባዉ፥ ‘ታን ህንተ ዛርያዉ እማና’ ያጋደ ጫቄዳ ቢታይ ሀዋ። ሀእ ኔን ነ አይፍያን በአናዳን ታን ኦꬃድ፤ ሽን ኔን ያ ፕናካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","መꬍና ጎዳ ቆማ ሙሴ መꬍና ጎዳይ ጌዳዋዳን፥ ሄዋን ሞኣባ ጋድያን ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","መꬍና ጎዳይ ቤት-ፓኦራ ካታማፐ ስንꬃ ባጋን ሞኣባ ዛንጋራን አ ሞጌዳ፤ ሽን ሀች ጋካናዉ፥ እ ሞገቴዳ ሳኣ ኤርያ አሳይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","ሙሴ ሀይቂያ ዎደ፥ አ ላይꬃይ ጼታነ ላታማ፤ ሽን አዉ አይፊ እጽቤና፤ አ ዎልቃይካ እጽቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","እስራኤልያ አሳይ ሞኣባ ደምባን ሀታሙ ጋላሳ ሙሴዉ ዬኬድኖ። ሄዋፐ ጉይያን፥ ሙሴዉ ዬክያነ ካዮትያ ዎዲ ዉሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","ኔዌ ናአይ ኢያሱ አꬌዳ ኤራተꬃ አያናን ኩሜዳ፤ አያዉ ጎፐ፥ ሙሴ ባረ ኮታን እ ኦꬃናዳን፥ አ ቦላ ባረ ኩሽያ ዎꬄዳ። እስራኤልያ አሳይ ኢያሱዉ አዛዘቴዳ፤ መꬍና ጎዳይ ሙሴ ባጋና እሜዳ አዛዙዋካ ናጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","መꬍና ጎዳይ ሶምኡዋን ዱማዪደ ኤሬዳ ሙሴ ማላ ትምቢትያ ኦድያ አሳይ እስራኤልያን ሙለካ ደንድቤና። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","መꬍና ጎዳይ ሙሳ ግብጼ ካትያኮ፥ አናና ኦꬅያ ካፓቱዋኮነ ኩመንꬃ አሳኮ የዲደ፥ አ ባጋና ኦራꬃባነ ማላልስያባ ኡባ ኦꬄዳ፥ ሙሴ ማላ ትምቢትያ ኦድያ ሀራ አሳይ ኦንነ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","እስራኤልያ ኡባ ስንꬃን ዎልቃማ ዎልቃን ማላልስያባ ኦꬄዳ ሙሴ ማላ አሳይ ኦንነ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","ጾሳ ቆማይ ሙሴ ሀይቄዳዋፐ ጉይያን፥ ጾሳይ ሙሳ ማድያ ነዌ ናኣ ኢያሳ፥ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“ታ ቆማይ ሙሴ ሀይቄዳ። ሄዋ ድራዉ ኔንነ ሀ አሳይ ኡባይ ደንዲደ ታን እስራኤልያ አሳዉ እምያ ጋድያ ገላናዉ ሀዋ ዮርዳኖሳ ሻፋ ፕንተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","ታን ሙሴዉ ኦዴዳዋዳን፥ ህንተንቱ ገዲ የꬍያ ሳኣ ኡባ ታን ህንተንቶ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","ህንተንቱ ዛዋይ ኔጌባ ባዙዋፐ ደንዲደ፥ ሊባኖሳ ደርያ ጋካናሳ፤ ኤፍራጺሳ ጌተትያ ዎጋ ሻፋፐ ደንዲደ፥ ሂተቱዋ ጋድያ ኡባና ጉጂደ፥ አዋይ ዉልያ ባጋና ደእያ ሜድትራነ አባ ጋካናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","ኔን ደኤዳ ላይꬃ ኡባን አይ አሳይነ ኔና ኦለቲደ ተኤና። ታን ሙሴና ግዴዳዋዳን፥ ኔናናካ ግዳና፤ ታን ኔና ኡባካ የግከነ አግከ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","ምና፤ ጻላ! አያዉ ጎፐ፥ ታን ኡንቱንቱ ማይዛ አዋቶ እማና ጋደ ጫቄዳ ጋድያ ኔን ሀ አሳ ላትሳናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","ምና፤ ሎይꬃ ጻላ! ታ ቆማይ ሙሴ ኔና አዛዜዳ ዎጋ ኡባ ምንሳደ ናጋ። ኔን ብያሳኣ ኡባን ነዉ ሱራና ማላ፥ አፐ ኡሸቻ ዎይ ሀድርሳ ቦፓ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","ሀ ዎጋ ማጻፋይ ነ ዶናፐ ሻከቶፖ፤ አን ጻፈቴዳዋ ኡባ ምንሳደ ናጋናዉ፥ ጋላስነ ቃማ አ ቆፓ። ያቶፐ፥ ነዉ ኡባባይካ እንጀታናነ ጊጋና። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","ምና፤ ጻላ! ነ ብያሳኣ ኡባን ታን ጎዳይ ነ ጾሳይ ኔናና ደእያ ድራዉ፥ ያዮፓ! ህርጎፓ! ጋደ ታን ኔና አዛዛድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","ሄዋፐ ጉየ ኢያሱ አሳ ካፓቱዋ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“ቢተ፤ አሳይ ዱንካኖ ሳና አꬍ ቢደ፥ አሳ፥ ‘ህንተ ሽንቃ ጊግስተ፤ ሄዙ ጋላሳ ግዶን፥ ጾሳይ ህንተንቱ ጾሳይ ህንተንቶ እምያ ጋድያ ላታናዉ ዮርዳኖሳ ሻፋ ፕኒታ’ ያጊደ ኦድተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","ኢያሱ፥ ሮቤላ ዘረꬃ፥ ጋደ ዛራቱዋነ ምናሰ ዛራቱዋፐ ባጋቱዋ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“ጾሳ ቆማይ ሙሴ ህንተንታ አዛዜዳዋ ሀሳይተ። እ ህንተንታ፥ ‘ጾሳይ ህንተንቱ ጎዳይ ህንተንታ ሸምፕሳና፤ ሀ ቢታካ ህንተንቶ እማና’ ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","15","ህንተንቱ ማቻቱ፥ ህንተንቱ ናናይነ ህንተንቱ መሂ ዮርዳኖሳ ሻፋፐ ሀፍንꬃና ሙሴ ህንተንቶ እሜዳ ጋድያን ደእሽኖ። ሽን ህንተንቱ ኦላንቻቱ ባረንቱ ኦላ ሚሻ ኦይቂደ፥ ህንተንቱ ዳባቱዋፐ ስንꬃ ጼራን ኦለታናዉ ዮርዳኖሳ ሻፋ ፕንኖ። ጾሳይ ህንተንታ ሸምፕሴዳዋዳን፥ ኡንቱንታካ ሸምፕሳና ጋካናስነ ጾሳይ ህንተንቱ ጾሳይ ኡንቱንቱዉካ እምያ ጋድያ ኡንቱንቱ ላታና ጋካናዉ፥ ኡንቱንታ ማድተ። ሄዋፐ ጉይያን ስም ቢደ፥ ጾሳ ቆማይ ሙሴ ዮርዳኖሳ ሻፋፐ ሀፍንꬃን አዋይ ዶልያ ባጋና እሜዳ ህንተንቱ ጋድያን ደእተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","ሄዋፐ ኡንቱንቱ ኢያሳ፥ “ኔን ኑና አዛዜዳዋ ኡባ ኑን ኦꬃና፤ ኔን ኪትያ ሳኣ ሀቃነ ባና። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","ሙሴዉ ኡባባን አዛዘቴዳዋዳን፥ ነዉካ አዛዘታና። ጾሳይ ነ ጾሳይ ሙሴና እትፐ ግዴዳዋዳን፥ ኔናናካ እትፐ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","ነ አዛዞ ማካልያዌነ ነ አዛዜዳዋ አያነ አዛዘተናን እጽያዌ ሀይቆ። ኔን ምና፤ ጻላ!” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","ነዌ ናአይ ኢያሱ ጋድያ ጌድያ ላኡ አሳቱዋ ሺጽማ ጌተትያ ሳኣፐ ቆሱዋን ኪቲደ ኡንቱንታ፥ “ቢተ፤ ጋድያ ጌድተ፤ ያርኮ ካታማ ቃይ ዱማ ጌድተ” ያጌዳ። ሄዋፐ ኡንቱንቱ ቢደ፥ ራኣቦ ጌተትያ ሻርሙጻት ሶ አቃናዉ ገሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","ያርኮ ካቲ፥ “እስራኤልያ አሳፐ ኪተቴዳዋንቱ ሀ ጋድያ ጌዳናዉ ቃማ ዬድኖ” ግያ ኦዱዋ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","ያርኮ ካቲ ራኣብዉ ሀዋዳን ያጊደ ኪቴዳ፤ “ነ ሶ ዪደ ገሌዳ አሳቱዋ ከሳደ እማ። አያዉ ጎፐ፥ ኡንቱንቱ ጋድያ ኡባ ጌዳናዉ ዬድኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","ሽን ምሽራታ ሄ ላኡ አሳቱዋ ቆሳ ድጋደ፥ ሀዋዳን ያጋዱ፤ “ኤ አሳቱ ታኮ ዬድኖ፤ ሽን ኡንቱንቱ ሀቃፐ ዬደንቶነ ታን ኤራበይከ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","ኦማርስ ካታማ ፐንግያ ጎርዳና ሀንያ ዎደ፥ ኡንቱንቱ ከሲደ ቤድኖ፤ ኡንቱንቱ ሀቃ ቤድኖንቶ ታን ኤርከ። ኤሌል ካልያዋ ግዶፐ፥ ህንተንቱ ኡንቱንታ ኦይቃንታ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","ሽን ራኣባ አሳቱዋ ጎልያ ቦላን ደምባዪደ ኦꬄዳ ሳኣ ከሳደ፥ ሱፍያ ጌተትያ ማዩዋ ከስያ ታልባ ዳላ ዶርያ ግዶን ኡንቱንታ ቆሳ ዎꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","ያትና፥ አሳቱ ጌድያዋንታ ኮያናዉ ከሲደ፥ ዮርዳኖሳ ሻፋ ፕኑዋ አፍያ ኦግያ ኦይቂደ ቤድኖ። ኮይያዋንቱ ካታማፐ ከሶንን፥ ካታማ ፐንጊ ጎርደቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","ጌድያዋንቱ ገምእሻናፐ ካሰታደ፥ አ ኡንቱንቱኮ ፑደ ከሳደ፥ ኡንቱንታ ሀዋዳን ያጋዱ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","“ጾሳይ ሀ ጋድያ ህንተንቶ እሜዳዌ፥ ህንተንቱ ኑና ዎልቃማ ያሻ ያሽያዋነ ሀ ጋድያን ደእያ አሳይ ኡባይ ህንተንቶ ህርጋ ሀይቂያዋ ታን ኤራይ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","አያዉ ጎፐ፥ ግብጼ ጋድያፐ ህንተንቱ ከሴዳ ዎደ፥ ህንተንቱ ስንꬃን ዞኦ አባ ጾሳይ ዎት መልሴደንቶነ ኑን ስሴዶ። ቃይ ዮርዳኖሳ ሻፋፐ አዋይ ዶልያ ባጋና ደእያ አሞረ ጋድያ ካተቱዋ ላአቱዋ፥ ስሆናነ ኦጋነ ህንተንቱ ዎት ኡባና ꬋይሴደንቶነ ስሴዶ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","ኑን ሄዋ ስሴዳ ዎደ፥ ኑ ዎዛናይ ኮልዴዳ፤ አሳይ ኡባይ ህንተንቶ ጻልያዋ አግ ባሼዳ። አያዉ ጎፐ፥ ጾሳይ ህንተንቱ ጾሳይ ቦላ ሳሉዋንካ ጋርሳ ሳኣንካ ጾሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","ሄዋ ድራዉ፥ ታን ህንተንቶ ኬኬዳዋዳን፥ ህንተንቱካ ታ አዉዋ ጎልያ አሳዉ ኬካናዳን ታዉ ጾሳን ሄዋዉካ አማንꬅያ ማላታ እምተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ታ አዉዋነ ታ ዳዮ፥ ታ እሻቱዋነ ታ ምቼቱዋ ኡንቱንቱሳ ግዴዳዋ ኡባ ፓጻ አግተ፤ ኑና ሀይቁዋፐ አሽተ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","ሄ አሳቱ፥ “ኑን ኦꬄዳዋ ኔን ኦደናን አግና፥ ኑን ነዉ ጫቄዳ ጫቁዋ ፖላና ꬋዮፐ፥ ጾሳይ ኑና ዎꬎ! ጾሳይ ሀ ጋድያ ኑዉ እምያ ዎደ፥ ኑን ነዉ አማነታናነ ኬካና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","ራኣባ ደእያ ኬꬃይ ካታማ ድርሳና ኦይቀቲደ ኬጸት ኡቴዳ ድራዉ፥ ማስኮትያና ዎዶሩዋ ዱገ የዳደ፥ አን ዱገ ዎꬃዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","ራኣባ ኡንቱንታ፥ “ህንተና ኮይያዋንቱ ደመና ማላ፥ ደርያ ቢደ ኡንቱንቱ ስማና ጋካናዉ፥ ያን ሄዙ ጋላሳ ቆሰትሽተ። ሄዋፐ ጉይያን ህንተንቱ ብያሳኣ ቢተ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","አሳቱ እዞ፥ “ኑን ነ ጋድያ ገልያ ዎደ፥ ሀ ዞኦ ዎዶሩዋ ኔን ኑና ከሴዳ ማስኮትያን ቃቻና ꬋዮፐነ ነ አዉዋ፥ ነ ዳዮ፥ ነ እሻቱዋነ ነ ሶ አሳ ኡባ ኔኮ ሶ አሀና ꬋዮፐ፥ ኔን ኑና ጫቂሴዳ ጫቁ ኑዉ ጎመተና። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","ኦንነ ነ ሶፐ ካረ ኦግያ ከሲደ ሀይቂንቶ፥ ሄዌ አ ጎመ፤ ኑን ሄዋን ኦሸቶኮ። ኔናና ሶን እትፐ ደእያዌ ኩሽያን ቦሸቶፐ፥ አ ሱꬃ ጎሚ ኑና ጋኮ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","ሽን ኑን ኦꬄዳዋ ኔን ኦዶፐ፥ ኔን ኑና ጫቀꬄዳ ጫቁ ኑዉ ጎመተና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","ሄዋፐ ጉየ እዛ፥ “ህንተንቱ ጌዳዋዳን ሀኖ” ጋደ፥ ኡንቱንታ ሞይዛዱ። ኡንቱንቱ ቤዳዋፐ ጉይያን፥ ሄ ዞኦ ዎዶሩዋ ማስኮትያን ቃቻዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","ኡንቱንቱ ፑደ ገዝያ ቢደ፥ ያን ቆሰቴድኖ፤ የደርስያዋንቱ ያርኮ ስማና ጋካናዉ፥ ኡንቱንቱ ያን ሄዙ ጋላሳ ጋምኤድኖ። የደርስያዋንቱ ኦግያ ኡባን ኮዬድኖ፤ ሽን ኡንቱንታ ደምቤይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","ሄዋፐ ጉይያን ሄ ላኡ አሳቱ ደርያፐ ዎꬊደ፥ ዮርዳኖሳ ሻፋካ ፕኒደ፥ ነዌ ናኣ ኢያሱኮ ስሚደ ዬድኖ። ባረና ጋኬዳዋ ኡባ አዉ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","ኡንቱንቱ ኢያሳ፥ “ጾሳይ ቱሙ ቢታ ኡባ ኑዉ አꬅ እሜዳ። ቃይ ጋድያን ደእያ አሳይ ኡባይ ኑዉ ያሻ ኮልዴዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","ኢያሱነ እስራኤልያ አሳይ ዎንታ ጉራን ደንዴድኖ። ኡንቱንቱ ሺጽማ ጌተትያ ሳኣፐ ደንዲደ፥ ዮርዳኖሳ ሻፋኮ ቢደ ፕነናን ያን ጋምኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","ሄዙ ጋላሳፐ ጉይያን፥ ካፓቱ ኡንቱንቱ ዱንካኔዳ ሳኣን ስመረቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","አሳ ሀዋዳን ያጊደ አዛዜድኖ፤ “ጾሳ ህንተንቱ ጾሳ ቃላ ጫቁዋ ታቦታነ አ ቶኬዳ ሌዊያ ዛረ ቄሳቱ ዋ በእያ ዎደ፥ ህንተንቱ ዱንካኔዳ ሳኣፐ ደንዲደ፥ ኡንቱንታ ካልተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","ህንተንቱ ካሰ ሀ ኦግያና ብ ኤረና ድራዉ፥ ህንተንቱ ባና ኦግያ ኡንቱንቱ ህንተንታ በሳና። ሽን ቃላ ጫቁዋ ታቦታኮ ሺቆፕተ፤ ቃላ ጫቁዋ ታቦታፐ ላኡ ሻአ ዋꬋ ግድያዋ ኬሻ ሃኩዋን ኤቂተ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","ኢያሱ አሳ፥ “ህንተንቱ ሁጲያዉ ጌይተ፤ አያዉ ጎፐ፥ ጾሳይ ዎንት ህንተንቱ ግዶን ማላልስያባ ኦꬃናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","ቃይ ኢያሱ ቄሳቱ ዋ፥ “ቃላ ጫቁዋ ታቦታ ቶኪደ፥ አሳፐ ስንꬃዉ አꬍተ” ያጊደ ኦዴዳ። ቃላ ጫቁዋ ታቦታ ቶኪደ፥ አሳፐ ስንꬃዉ አꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","ጾሳይ ኢያሳ፥ “ታን ሙሴና ግዴዳዋዳን፥ ኔናና ግዳናዋ እስራኤልያ አሳይ ኡባይ ኤራና ማላ፥ ሀቼ ኡንቱንቱ ስንꬃን ታን ኔና ꬎቁ ꬎቁ ኦꬃናዉ ዶማና። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","ኔን ቃላ ጫቁዋ ታቦታ ቶክያ ቄሳቱ ዋ፥ ‘ዮርዳኖሳ ሻፋ ዶናዉ ጋክያ ዎደ፥ ሃꬃን ገሊደ ኤቂተ’ ያጋደ አዛዛ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","ኢያሱ እስራኤልያ አሳ፥ “ሃ ዪተ፤ ጾሳ ህንተንቱ ጾሳ ቃላ ስስተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","ደኡዋ ጾሳይ ህንተንቱ ግዶን ደእያዋነ እ ቱሙፐ ካናነቱዋ፥ ሂተቱዋ፥ ሂዌቱዋ፥ ፓርዘቱዋ፥ ገርጌሰቱዋ፥ አሞረቱዋነ ያቡሳቱዋ ህንተንቱ ስንꬃፐ ከሳናዋ ህንተንቱ ኤራናዌ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","ሳኣ ኡባ ጎዳ ቃላ ጫቁዋ ታቦታይ ህንተፐ ስንꬃቲደ፥ ዮርዳኖሳ ሻፋ ፕንያ ዎድያና። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","ሀእ እስራኤልያ ዛራቱዋፐ ታማነ ላኡ አሳቱዋ ዶርተ፤ እት እት ዛርያፐ እት እት አሳ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","ሳኣ ኡባ ጎዳ፥ ጾሳ ቃላ ጫቁዋ ታቦታ ቶኬዳ ቄሳቱዋ ገዲ ዮርዳኖሳ ሃꬃ ቦችያ ዎደ፥ ቆሞፐ ዱገ ጎግያ ዮርዳኖሳ ሃꬃይ ኤቃና፤ እት ሳኣ ሺቂደ ዶረታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","አሳይ ዮርዳኖሳ ሻፋ ፕናናዉ ባረንቱ ዱንካንያፐ ከሴዳ ዎደ፥ ቃላ ጫቁዋ ታቦታ ቶኬዳ ቄሳቱ አሳፐ ስንꬃን ሀመቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","ካꬃ ጫክያ ዎድያን ኡባን ዮርዳኖሳ ሻፋይ ኩንꬄዳ። ግዶፐነ፥ ቃላ ጫቁዋ ታቦታ ቶኬዳ ቄሳቱ ዮርዳኖሳ ሻፋ ጋክና፥ ኡንቱንቱ ገዲ ሃꬃ ጋጻ የꬌዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ቆሞፐ ዱገ ጎግያ ሃꬃይ ኤቂ አጌዳ፤ ህን ዳርስ ሃኮ ሳን፥ ጻርታና ግያ ሳን ደእያ አዳማ ጌተትያ ካታማን እት ሳኣ ሺቂደ ዶረቴዳ። ዱገ አራባ ጋꬋን ደእያ ማጽነ አባዉ ጎግያ ሃꬃይ ቃይ ኡባይ ዱጺደ አት ባሼዳ። ያትና፥ አሳይ ያርኮ ካታማ ሄፍንꬃ ፕኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","እስራኤልያ አሳይ መላ ጋድያ የꬊደ ፕንያ ዎደ፥ አሳይ ኡባይ ፕኒደ ዉራና ጋካናዉ ጾሳ ቃላ ጫቁዋ ታቦታ ቶኬዳ ቄሳቱ ዮርዳኖሳ ሻፋ ግዶን መላ ቢታን ኤቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","አሳይ ኡባይ ዮርዳኖሳ ሻፋ ፕኒደ ዉሬዳ ዎደ፥ ጾሳይ ኢያሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“እስራኤልያ አሳፐ ታማነ ላኡ አሳቱዋ ዶራ፤ እት እት ዛርያፐ እት እት አሳ ግዶ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ያታደ ኡንቱንቱ፥ ‘ዮርዳኖሳ ሻፋ ግዶን ቄሳቱዋ ገዲ ኤቄዳ ሳኣፐ ታማነ ላኡ ሹቻቱዋ አክተ፤ ሄ ሹቻቱዋ ቶክ አፊደ፥ ሀቼ ቃማ ህንተንቱ አቅያ ሳኣን ዎꬅተ’ ያጋደ አዛዛ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","ኢያሱ እስራኤልያ ዛርያፐ እቱዋ እቱዋ አኪደ፥ ታማነ ላኡ አሳ ዶሬዳዋንታ ጼሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","ኡንቱንታ፥ “ጾሳ ህንተንቱ ጾሳ ቃላ ጫቁዋ ታቦታይ ደእያ ሳኣ ጉየ ዮርዳኖሳ ሻፋ ገሊደ እስራኤልያ ዛራቱዋ ፓይዱዋን፥ ኡባይካ እት እት ሹቻ ህንተንቱ ሀሽያን ቶክተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","ሀ ሹቻቱ ጾሳይ ሀቼ ኦꬄዳዋ ህንተንታ ሀሳይስያ ማላታ ግድኖ። ዎደፐ ህንተንቱ ናናይ ህንተንታ፥ ‘ሀ ሹቻቱ አይባቤ?’ ያጊደ ኦችያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","ህንተንቱ፥ ጾሳ ቃላ ጫቁዋ ታቦታ ስንꬃን ዮርዳኖሳ ሻፋይ ጎገꬃ አጊደ ኤቄዳዋ እስራኤልያ አሳ መꬍናዉ ሀሳይሲኖ። ቃላ ጫቁዋ ታቦታይ ፕንሽን፥ ዮርዳኖሳ ሃꬃይ ሻከቴዳ ያጊደ ኡንቱንቶ ኦድተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","እስራኤላቱ ኢያሱ አዛዜዳዋዳን ኦꬄድኖ። ጾሳይ ኢያሶ ኦዴዳዋዳን፥ እስራኤልያ ዛራቱዋ ፓይዱዋን አሳቱ ታማነ ላኡ ሹቻቱዋ ዮርዳኖሳ ሻፋ ግዶፐ አኬድኖ፤ ቶክ አሂደ፥ ባረንቱ አቅያ ሳኣን ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","ኢያሱ ቃላ ጫቁዋ ታቦታ ቶኬዳ ቄሳቱዋ ገዲ ዮርዳኖሳ ሻፋ ግዶን ኤቄዳ ሳኣን፥ ሀራ ታማነ ላኡ ሹቻቱዋ ኤሴዳ፤ ሄ ሹቻቱ ሀቼ ጋካናዉ ያን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","ጾሳይ ኢያሳ አዛዜዳዋ ኡባ አሳይ ፖላና ጋካናዉ፥ ቃላ ጫቁዋ ታቦታ ቶኬዳ ቄሳቱ ዮርዳኖሳ ሻፋ ግዶን ኤቂደ ጋምኤድኖ፤ ሙሴ ኢያሳ አዛዜዳ አዛዙካ ሄዋ። አሳይ ኤሌሊደ ሻፋ ፕኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","አሳይ ኡባይ ፕኔዳዋፐ ጉይያን፥ ጾሳ ቃላ ጫቁዋ ታቦታይነ ቄሳቱ አሳይ ጼልሽን ፕኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","ሙሴ አዛዜዳዋዳን፥ ሮቤላ ዛራቱ፥ ጋደ ዛራቱነ ምናሰ ዛራቱዋፐ ባጋይ ኦላ ሚሻ ኦይቂደ፥ እስራኤልያ አሳ ስንꬃና ፕን ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","ኡንቱንቱ ፓይዱ ኦይታሙ ሻአ ግድያዋ። ኡንቱንቱ ጾሳ ስንꬃን፥ ያርኮ ማታን ደእያ ደምባን ኦላዉ ሳልፔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","ሄ ጋላስ ጾሳይ ኢያሳ እስራኤልያ አሳ ኡባ ስንꬃን ꬎቁ ꬎቁ ኦꬄዳ። ሄዋ ድራዉ ሙሳ ቦንቼዳዋዳን ኢያሳካ አ ደኡዋ ላይꬃ ኡባን ቦንቼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","ጾሳይ ካሰ ኢያሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“ቃላ ጫቁዋ ታቦታ ቶኬዳ ቄሳቱ ዮርዳኖሳ ሻፋፐ ከሳናዳን አዛዛ” ያጊደ ኦድና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","ኢያሱ ቄሳቱዋ፥ “ዮርዳኖሳ ሻፋፐ ከስተ” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","ጾሳ ቃላ ጫቁዋ ታቦታ ቶኬዳ ቄሳቱ ዮርዳኖሳ ሻፋ ግዶፐ ከሲደ መላ ቢታ ኡንቱንቱ የꬌዳዋን፥ ኤለካ ዮርዳኖሳ ሃꬃይ ባረ ሳኣ ስሚደ ካሰ ጎግያዋዳን ጋጻ ጋካናዉ ኩሚደ፥ ጎገꬃ ዶሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","አሳይ ኮይሮ አግናን ሄ አግናዉ ታማንꬃ ጋላሳን ዮርዳኖሳ ሻፋ ፕኒደ፥ ያርኮና አዋይ ዶልያ ባጋን ዛዋትያ ገልጋላን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","ኢያሱ ዮርዳኖሳ ሻፋፐ አየቴዳ ታማነ ላኡ ሹቻቱዋ ገልጋላን ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","እስራኤልያ አሳ ሀዋዳን ያጌዳ፤ “ዎደፐ ህንተንቱ ዛራቱ ባረንቱ አዎቱዋ፥ ‘ሀ ሹቻቱ አይባቤ?’ ያጊደ ኦችያ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","‘እስራኤልያ አሳይ ዮርዳኖሳ ሻፋ መላ ቢታ የꬊደ ፕኔዳዋ ሀሳይስያዋንታ’ ያጊደ ኦድተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","ኑን ፕናና ጋካናዉ፥ ጾሳይ ኑ ጾሳይ ዞኦ አባ ካሰ ኑ ስንꬃን መልሴዳዋዳን፥ ህንተንቱካ ፕናና ጋካናዉ፥ ጾሳይ ህንተንቱ ጾሳይ ዮርዳኖሳ ሻፋ ህንተንቱ ስንꬃን መልሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","ሄዋ እ ኦꬄዳዌ ሳኣን ደእያ አሳይ ኡባይ ጾሳ ዎልቃይ አይ ኬሻ ግተንቶ ኤራናዳንነ ህንተንቱካ ጾሳዉ፥ ህንተንቱ ጾሳዉ፥ መꬍናዉ ያያናዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","ዮርዳኖሳ ሻፋፐ አዋይ ዉልያ ባጋና ደእያ አሞራዋናቱዋ ካተቱነ ሜድትራነ አባ ላንቂያ ላንቂያ ኦይቂደ ደእያ ካናነቱ ካተቱ ኡባይ፥ እስራኤልያ አሳይ ፕናና ጋካናዉ ጾሳይ ዮርዳኖሳ ሻፋ ሃꬃ መልሴዳዋ ስሴዳ ዎደ፥ ኡንቱንቱ ዎዛናይ ኮልዴዳ። ኡንቱንቱ እስራኤልያ አሳና ጋከታናዉ ጻልበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","ሄ ዎደ ጾሳይ ኢያሳ፥ “ሳልያ ጌተትያ ሹቻፐ ቃራ ማቅላ ጊግሳደ፥ እስራኤልያ አቱማ አሳ በንዋንቱዋዳን ሀእካ ቃጻራ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","ኢያሱ ሳልያ ጌተትያ ሹቻፐ ቃራ ማቅላ ጊግሲደ፥ ቃጻራ ደርያ ጌተትያ ሳኣን እስራኤልያ አሳ ቃጻሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","እ ሄዋ ኦꬄዳ ጋሱ: ግብጼፐ ከሴዳ አሳን ላይꬃይ ኦላዉ ጋኬዳ አቱማ አሳይ ኡባይ ግብጼፐ ቢደ ዎራን ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","ግብጼፐ ከሴዳ አቱማ አሳይ ኡባይ ቃጻረቴዳ፤ ሽን ዎራን ዩይያ ዎደ የለቴዳ አቱማ ናናይ እቱነ ቃጻረትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","እስራኤልያ አሳይ ጾሳዉ አዛዘተናን እጼዳ ድራዉ፥ ግብጼፐ ከስያ ዎደ ላይꬃይ ኦላዉ ጋኬዳ አቱማ አሳይ ኡባይ ሀይቂደ ዉራና ጋካናዉ ዎራን ኦይታሙ ላይꬃ ዩዬዳ። ሄዌነ፥ ጾሳይ ኡንቱንታ፥ “ኤሳይነ ማꬃይ ጎግያ አራዳ ጋድያ፥ ታን ካሰ ህንተንቱ ማይዛ አዋቶ እማና ጌዳ ሄ ጋድያ ህንተንቱ በእክታ” ጌዳ ቃላይ ፖለታናዳና። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","ሄዋ ድራዉ ጾሳይ ኡንቱንቱ ናና ኡንቱንቱ ሳኣን ደንꬄዳ፤ ኢያሱ ቃጻሬዳዋንቱካ ሄዋንታ። ኡንቱንቱ ቃጻረተናን ደእያዌ ኦግያን ቢደ ኡንቱንቱ ቃጻረትቤና ድራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","አሳይ ኡባይ ቃጻረቴዳዋፐ ጉይያን፥ ኡንቱንቱ ማይꬃይ ፓጻና ጋካናዉ ባረንቱ ዱንካኔዳ ሳኣን ጋምኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","ጾሳይ ኢያሳ፥ “ሀቼ ታን ግብጼቱዋ ቦርያ ህንተፐ ድጋድ” ያጌዳ። ሄ ሳኣ ሱንꬃይ ሀቼ ጋካናዉ ገልጋላ ጌተቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","እስራኤልያ አሳይ ያርኮ ደምባን ገልጋላ ግያ ሳን ዱንካኒደ፥ አግናዉ ታማነ ኦይደንꬆ ጋላስ ኦማርሴዳዋን ፓስጋ ባላ ቦንቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","ፓስጋፐ ጉይያን ዎንተꬃ ጋላስ፥ ቢታን ዶልያ ካꬃ አይፍያ እርሹ ገልቤና ኡክꬃነ ጺጸቴዳ ትሻ ሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","ሄ ቢታን ዶልያ ካꬃ ሜዳ ዎንተꬃ ጋላስ ማናይ ቡክያዋ አግ ባሼዳ። ሄዋፐ ጉይያን እስራኤልያ አሳይ ማና ደምቤና። ሄ ዎድያፐ ዶሚደ ኡንቱንቱ ካናነን ዶልያ ካꬃ ሚደ ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","ኢያሱ ያርኮ ማታን ደእያ ዎደ፥ ꬎቁ ጊደ ጼሊደ፥ እት ብታኒ ማሻ ሾድ ኦይቂደ፥ ባረ ስንꬃን ኤቄዳዋ በኤዳ። ኢያሱ አኮ ሺቂደ፥ “ኔን ኑ ባጋ አሴየ ኑ ሞርከቱዋ ባጋ አሴ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","ብታኒ፥ “ታን ኦ ባጋካ ግድከ። ሽን ታን ጾሳ ኦላንቻቱ ጋዳዋ ግዳደ ሀእ ያድ” ያጌዳ። ኢያሱ ሳኣን ኩንድ ጎይኒደ፥ “ታ ጎዳይ ባረ ቆማዉ ኦድያባይ አዬ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","ጾሳ ኦላንቻቱዋ ጋዳዋይ፥ “ኔን ኤቄዳ ሳአይ ጌሻ ግዴዳ ድራዉ፥ ነ ገድያፐ ጫማ ከሳ” ያጌዳ። ኢያሱ እ ጌዳዋዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","እስራኤልያ አሳዉ ያዬዳ ጋሱዋን ያርኮ ካታማ ድርሳ ፐንገቱ ጎርደቲደ ናገቲኖ፤ ካታማ ገላናዉነ ካታማፐ ከሳናዉ ዳንዳይያ ኦንነ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","መꬍና ጎዳይ ኢያሳ፥ “ጼላ፥ ታን ያርኮ ካታማ አ ካትያና አ ምኖ ኦላንቻቱዋካ ነ ኩሽያን አꬃደ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","ኔንነ ነ ኦላንቻቱ ሳልፒደ፥ ኡሱፑን ጋላሳይ ጋካናዉ ሀቼ ሀቼ ካታማ ድርሳ እት ገደ ዩይ አꬍተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","ቃይ ላፑን ቄሳቱ ዶርሳቱዋ ካጭያፐ ከሴዳ ላፑን ማላካታቱዋ ኦይቂደ፥ ጾሳ ቃላ ጫቁዋ ታቦታ ስንꬃና ሀመትኖ። ላፑንꬃ ጋላስ ቄሳቱ ማላካታቱዋ ፑንሽን፥ ኦላንቻቱ ሳልፒደ፥ እትፐ ካታማ ላፑ ገደ ዩይ አꬍተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","ሄዋፐ ጉይያን ማልካታቱዋ ፑኑዋ ጎቺደ ፑንያዋ ስስያ ዎደ፥ ኤለካ አሳይ ኡባይ ባረ ቃላ ꬎቁ ኦꬂደ ዋሶ። ያቶፐ ካታማ ድርሳ ግምቢ ኩንድና አሳይ ኡባይ ስንꬃዉ ላዉሁ ጊደ ገላና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","ነዌ ናአይ ኢያሱ ቄሳቱ ዋ ጼጊደ፥ “መꬍና ጎዳ ቃላ ጫቁዋ ታቦታ ቶክተ፤ ህንተፐ ላፑን ቄሳቱ ላፑን ማላካታቱዋ ኦይቂደ፥ ቃላ ጫቁዋ ታቦታፐ ስንꬃዉ አꬊደ ሀመትኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","አሳ፥ “ስንꬃዉ ቢተ፤ ካታማ ዩይ አꬍተ፤ ኦላዉ ጊጌዳዋንቱካ መꬍና ጎዳ ቃላ ጫቁዋ ታቦታ ስንꬃን ሀመትኖ” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","ኢያሱ አሳዉ ሃሳዬዳዋዳን፥ ላፑን ቄሳቱ ላፑን ማላካታቱዋ መꬍና ጎዳ ስንꬃን ኦይቂደ፥ ፑኒደ ሀመቴድኖ፤ ቃይ መꬍና ጎዳ ቃላ ጫቁዋ ታቦታይ ኡንቱንታ ካሌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","ኦላዉ ጊጌዳዋንቱ ማላካታቱዋ ፑንያ ቄሳቱዋ ስንꬃን ብያ ዎደ፥ ጉየና ናግያ ኦላንቻቱ ቃላ ጫቁዋ ታቦታ ጉየና ካሌድኖ። ሄ ዎድያ ኡባን ማላካታቱ ፑነቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","ሽን ኢያሱ አሳ፥ “ታን ህንተንታ፥ ‘ዋስተ!’ ጋና ጋላሳይ ጋካናዉ፥ ኦላ ዋሱዋ ዋሶፕተ፤ ህንተንቱ ቃላይ ስሰቶፖ፤ እት ቃላካ ቃቶፕተ። ግድን ሄ ዎደ ዋስተ!” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","ያቲደ መꬍና ጎዳ ቃላ ጫቁዋ ታቦታይ ቶከቲደ፥ ሄ ካታማ እት ገደ ዩይ አꬋናዳን ኦꬄዳ። ሄዋፐ ጉይያን አሳይ ባረ ዱንካኔዳ ሳኣ ስሚደ፥ ቃማ ያን አቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","ዎንተꬃ ጋላስ ኢያሱ ጉሪደ ደንዴዳ፤ ቄሳቱካ መꬍና ጎዳ ቃላ ጫቁዋ ታቦታ ቶኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","ላፑን ማላካታቱዋ ኦይቂደ ላፑን ቄሳቱ ስንꬃዉ አꬊደ፥ ማላካታቱዋ ፑኒደ መꬍና ጎዳ ቃላ ጫቁዋ ታቦታ ስንꬃን ሀመቴድኖ። ኦላዉ ጊጌዳዋንቱ ህንቱቱፐ ስንꬃና ሀመቴድኖ፤ ጉየና ናግያ ኦላንቻቱካ መꬍና ጎዳ ቃላ ጫቁዋ ታቦታ ጉየና ካሌድኖ። ሄ ዎድያ ኡባን ማላካታቱ ፑነቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","ላኤንꬆ ጋላስ ካታማ እት ገደ ዩይ አꬊደ፥ ባረንቱ ዱንካኔዳ ሳኣ ስሜድኖ። ኡሱፑን ጋላሳ ጋካናዉ ሄዋዳን ሀኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","ላፑንꬃ ጋላስ ጻልቂ ዶልያ ዎደ ደንዲደ፥ ካሰዋዳን ካታማ ላፑ ገደ ዩይ ዩይ አꬌድኖ። ካታማ ኡንቱንቱ ላፑ ገደ ዩይ ዩይ አꬌዳዌ ሄ ጋላስ ጻላላና። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","ላፑንꬃ ዩሻን፥ ቄሳቱ ማላካታቱዋ ፑንያ ዎደ፥ ኢያሱ አሳ፥ “መꬍና ጎዳይ ካታማ ህንተንቶ አꬂደ እሜዳ ድራዉ፥ ዋስተ! ");
INSERT INTO dwrENT_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","ካታማይነ ካታማ ግዶን ደእያባይ ኡባይ መꬍና ጎዳዉ ሸቀቶዋ ግዲደ፥ ꬋያናዉ በሰ። ኑን ጋድያ ጌዳናዉ ኪቴዳ አሳቱዋ ቆሳደ አሼዳ ድራዉ፥ ሻርሙጽያ ራኣባነ እ ሶን እዝና እትፐ ደእያ አሳ ጻላላይ አታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","ሽን ህንተንቱ ሸቃ ግዴዳባፐ አያነ አከናዳን ህንተንቱ ሁጲያዉ ናገትተ። ሸቃ ግዴዳባፐ ህንተንቱ አኮፐ፥ እስራኤላቱ ዱንካኔዳ ሳኣ ባይያ ሳኣ ኦꬃንታ፤ ያቲደ ሄ ሳአዉ መቱዋ አሀንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","ብራይነ ዎርቃይ ኡባይ፥ ቃይ ናሃስያፐነ ብራታፐ መቴዳ ሚሻቱ ኡባይ መꬍና ጎዳዉ ጌዬዳዋ ግድኖ። ኡንቱንቱ መꬍና ጎዳ ሚሻ ምንጅያ ሳኣን ደእኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","ሄዋ ድራዉ ማላካታቱ ፑነትና አሳይ ዋሴዳ። ማላካታቱ ፑኑዋን አሳይ ባረ ቃላ ꬎቁ ኦꬂደ ዋሴዳ፤ ኤለካ ካታማ ድርሳ ግምቢ ኩንድ አጌዳ! ሄዋፐ ጉይያን አሳይ ኡባይ ስንꬃዉ ላዉሁ ግ ገልነ ካታማ ኦይቂ አጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","ካታማን ሸምፑዋና ፓጻ ደኤዳዋ ኡባ፥ ማጫዋ አቱማዋ፥ ናናቱዋ ጭማ፥ ሚዛ፥ ዶርሳነ ሀርያ ኡባ ቃራ ማሻን ዉርስ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","ኢያሱ ቢታ ጌዳናዉ ኪተቴዳ ላኡ አሳቱዋ፥ “ሻርሙጻት ራኣብ ሶ ቢደ ካሰ ህንተንቱ እዝዉ ጫቄዳዋዳን፥ እዞነ እዝዉ ደእያዋ ኡባ ጋጻ ከስተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","ቢታ ጌዴዳ ዎዳላቱ ቢደ፥ ራኣቦ፥ እ አዉዋ፥ እ ዳዮ፥ እ እሻቱዋነ እዝዉ ደእያዋ ኡባ ጋጻ ከሴድኖ። እስራኤልያ አሳይ ዱንካኔዳ ሳኣፐ ጋጻና ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","ሄዋፐ ጉይያን ካታማነ አ ግዶን ደእያዋ ኡባ ታማን ጹጌድኖ፤ ሽን ብራነ ዎርቃ ቃይ ናሃስያፐነ ብራታፐ መቴዳ ሚሻቱዋ መꬍና ጎዳ ሚሻ ምንጅያ ሳኣን ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","ሽን ኢያሱ ሻርሙጻቶ ራኣቦ እ አዉዋ ሶ አሳናነ እዝዉ ደእያ ኡባባና ሀይቁዋፐ አሼዳ። አያዉ ጎፐ፥ ኢያሱ ያርኮ ካታማ ጌዳናዉ ኪቴዳ አሳቱዋ እዛ ካሰ ቆሳደ አሻዱ። እዝ ዛራቱ ሀቼ ጋካናዉ እስራኤልያ ቢታን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","ሄ ዎደ ኢያሱ፦ “ደንዲደ ሀ ያርኮ ካታማ ዛረꬅ ኬጽያ ኡራይ፥ መꬍና ጎዳ ስንꬃን፥ ሸቀቴዳዋ ግዶ። ብሮ ባሱዋ ባስያ ዎደ፥ አ ባይራ ናአይ ሀይቆ። ፐንግያ ኤስያ ዎደ፥ አ ዉርሰꬃ ቴፋ ናአይ ሀይቆ” ያጊደ ሸቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","መꬍና ጎዳይ ኢያሱና ግዴዳ፤ ኢያሱ ዋሪ ቢታ ኡባ ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","እስራኤልያ አሳይ ጾሳዉ አማነተናን እጺደ፥ ጺነ ግ ዎꬄዳባፐ አኬዳ። ሄዋ አኬዳዌ አካና፤ አካን ካርማ ናኣ፤ ካርም ዝምራ ናኣ፤ ዝምር ይሁዳ ዛርያ ግዴዳ ዛራሀ ናኣ። ያትና፥ ጾሳ ሀንቁ እስራኤልያ አሳ ቦላ ኤጼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","ኢያሱ ያርኮን ደኢደ ቤቴለ ካታማፐ አዋይ ዶልያ ባጋና ቤት-አዌና ግያሳ ማታን ደእያ አይ ጌተትያ ካታማ አሳ ኪቲደ፥ “ቢተ፤ ሄ ቢታ ጌድተ” ያጌዳ። አሳቱ ቢደ፥ አይ ካታማ ጌዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","ጌዴዳ አሳቱ ኢያሱኮ ስም ዪደ፥ “ኡባ አሳይ አይ ካታማ ኦላናዉ ባና ኮሸና፤ ላኡ ዎይ ሄዙ ሻአ አሳ የዳ። ያን አማሬዳ አሳይ ደእያ ድራዉ፥ አሳይ ኡባይ ዳቡሮፖ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","ያትና፥ ሄዙ ሻአ ግድያ አሳቱ ኦለታናዉ አይ ካታማ ቤድኖ። ሽን ኡንቱንቱ አይ ካታማ አሳ ስንꬃፐ ባቃቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","አይ ካታማ ድርሳ ፐንግያፐ ዶሚደ፥ ሹቻ ቆእያ ሳኣ ጋካናዉ እስራኤልያ አሳ የደርሴድኖ፤ ደርያ ዱገꬃን ሀታማነ ኡሱፑን ግድያ አሳ ዎꬌድኖ። ሄዋን አሳ ዎዛናይ ኮልዲደ፥ ሃꬃ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","ሄዋፐ ጉይያን ኢያሱ ካዮቲደ፥ ባረ ማዩዋ ፔꬊደ ጾሳ ታቦታ ስንꬃን ኦማርስ ጋካናዉ ጉፋኔዳ። እስራኤልያ ጭማቱካ አዋዳን ሀኔድኖ፤ ባረንቱ ሁጲያንካ ባና ቆሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","ሄዋፐ፥ ኢያሱ ሀዋዳን ያጌዳ፤ “ሀይ ፖራ! ኡባ ሞድያ ጾሳዉ፥ ኑና አሞረ አሳዉ አꬃ እማደ ዉርስሳናዉ አያዉ ዮርዳኖሳ ሻፋ ፕንꬃ አሃድ? ኑን ዮርዳኖሳ ሻፋፐ ሄፍንꬃ ባጋን አቴዶ ግዴሮኮ! ");
INSERT INTO dwrENT_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","አቤት ጎዳዉ፥ እስራኤልያ አሳይ ጾነቲደ፥ ባረ ሞርከቱዋ ስንꬃፐ ባቃቶፐ፥ ታን ዋጎ? ");
INSERT INTO dwrENT_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","ካናነቱነ ሀ ቢታን ደእያ አሳይ ኡባይ ሀ የዉዋ ስሲደ፥ ኑና ዶዳናዋንታ፤ ጋድያፐካ ꬋይሳናዋንታ። ስም፥ ነ ዎልቃማ ሱንꬃዉ ኔን ኦꬅያባይ አዬ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","ጾሳይ ኢያሳ፥ “ደንዳ ኤአ! ሀዋዳን አያዉ ጉፋናድ? ");
INSERT INTO dwrENT_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","እስራኤልያ አሳይ ናጋራ ኦꬄዳ፤ ታን ኡንቱንቱና ጫቀቴዳ ታ ጫቁዋ አꬌድኖ። ኡንቱንቱ ማጋራ ጌተቴዳ ሚሻቱዋፐ አኬድኖ፤ ዉኤድኖ፤ ዎርዶቴድኖ። ቃይ ሄ ሚሻ ኡንቱንቱ ባረንቱ ሚሻና ጋꬅ ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ሄዋ ድራዉ፥ እስራኤላቱ ባረንቱ ሞርከቱዋ ስንꬃን ኤቃናዉ ዳንዳይክኖ። ኡንቱንቱ ꬋያናዉ በስያ ድራዉ፥ ባረንቱ ሞርከቱዋ ስንꬃፐ ባቃቴድኖ። ማጋራ ጌተቴዳ ሚሻ ህንተንቱ ማታን ደእያዋ ህንተንቱ ꬋይሳና ꬋዮፐ፥ ሀዋፐ ስንꬃዉ ታን ህንተንቱና ግድከ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“ደንዳ፤ አሳ ጌሻ። ኡንቱንቶ ሀዋዳን ያጋደ ኦዳ፤ ‘ዎንትዉ ህንተንቱ ሁጲያዉ ጌይተ። ጾሳይ እስራኤልያ ጾሳይ ህንተንታ፤ “እስራኤላቶ፥ ማጋራ ጌተቴዳ ሚሻይ ህንተንቱ ማታን ደኤ። ህንተንቱ ሄ ሚሻ ህንተንቱ ማታፐ ድጋና ጋካናዉ፥ ህንተንቱ ሞርከቱዋ ስንꬃን ኤቃናዉ ዳንዳይክታ” ያጌ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","ዎንታ ጉራ፥ ህንተንቱ ዛርያን ዛርያን ሺቅና ጾሳይ፥ “ሀዋ” ጌተትያ ዛሪ፥ ባረ ያራን ያራን ሺቃና፤ ቃይ ጾሳይ፥ “ሀዋ” ግያ ያራይ ባረ ሶ አሳን አሳን ሺቃና፤ ቃይ ጾሳይ፥ “ሀዋ” ግያ ሶ አሳይ እት እት አሳይ ታራን ታራን ሺቃና። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","ሄዋፐ ጉይያን ማጋራ ጌተቴዳዋና ኦይቀቴዳ አሳይ፥ ባረዋ ኡባና ታማን ጹገታና። አያዉ ጎፐ፥ ጾሳ ቃላ ጫቁዋ እ አꬊደ፥ እስራኤልያ አሳ ግዶን ካዉሻባ ኦꬄዳ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","ኢያሱ ዎንተꬃ ጋላስ ጉራን ደንዲደ፥ እስራኤልያ አሳ ዛርያን ዛርያን ሺሽና ይሁዳ ዛሪ አከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","ይሁዳ ዛሪ ሺቅና፥ ዛራሀ ያራይ አከቴዳ፤ ዛራሀ ያራይ ሺቅና፥ ዝምራ ሶ አሳይ አከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","ዝምራ ሶ አሳይ ሺቅና፥ ዉርሰꬃን ዝምራ ናኣ ናአይ፥ ካርማ ናአይ አካን አከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","ሄዋፐ፥ ኢያሱ አካና፥ “ታ ናአዉ፥ ጾሳ እስራኤልያ ጾሳ ቦንቻ፤ አ ጋላታ። አነ ኔን ኦꬄዳዋ ታዉ ቆሰናን ኦዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","ሄዋፐ ጉየ አካን ኢያሳ፥ “ኤ ቱማ! ታን ጾሳ እስራኤልያ ጾሳ ናቃድ። ታን ኦꬄዳዌ ሀዋ: ");
INSERT INTO dwrENT_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","ኑን ኦሞዴዳ ሚሻ ግዶን ታን እት ሎእያ ባብሎነ ጋድያ ካባ፥ ላኡ ጼቱ ጻጋራ ብራነ ባጋ ኪሎ ግድያ ዎርቃ በኣድ፤ አካናዉ አሞቴዳ ድራዉ አካድ። ያታደ ታ ዱንካንያ ግዶን ቢታ ጋርሳን ቆሳድ፤ ብራይካ ኡባፐ ጋርሳና ደኤ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","ኢያሱ አሳ ኪትና፥ ኡንቱንቱ ዱንካንያ ዎጺደ ገልያ ዎደ፥ ዱንካንያ ግዶን ሚሻ ቆስ ዎꬄዳዋ ደሜድኖ፤ ብራይካ ሚሻቱዋፐ ጋርሳና ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","ኪተቲደ ቤዳ አሳቱ ሚሻ ዱንካንያ ግዶፐ አኪደ፥ ኢያሱኮነ እስራኤልያ አሳ ኡባኮ አሄድኖ፤ ጾሳ ስንꬃን ዎꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","ሄዋፐ ጉይያን ኢያሱነ እስራኤልያ አሳይ ኡባይ አካና ብራ፥ ካባ፥ ዎርቃ፥ አ አቱማ ናናነ ማጫ ናና፥ አ ሚዛ፥ ሀረቱዋነ ዶርሳቱዋ፥ አ ዱንካንያነ አዉ ደእያዋ ኡባ አኪደ፥ መቱዋ ዎምባ ግያሳ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","ኢያሱ አካና፥ “ሀ መቱዋ ኑ ቦላ አያዉ አሃድ? ጾሳይ ሀቼ ነ ቦላካ መቱዋ አሀና” ያጌዳ። እስራኤልያ አሳይ ኡባይ አካናነ አ ሶ አሳ ሹቻን ጫድ ዎꬊደ፥ አዉ ደእያዋ ኡባ ታማን ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","ኡንቱንቱ አካና ቦላን ሀቼ ጋካናዉ ደእያ ዳሮ ሹቻ ኬሌድኖ። ያትና፥ ጾሳይ ባረ ኤጽያ ሀንቁዋ ዛሬዳ። ሀቼ ጋካናዉ ሄ ሳአይ መቱዋ ዎምባ ጌተቴዳዌ ሀዋሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","ጾሳይ ኢያሳ፥ “ያዮፓ፤ ህርጎፓ! ኦላንቻቱዋ ኡባ ኔናና አካደ፥ አይ ካታማ ኦላናዉ ከሳ። አይ ካታማ ካትያ፥ አ አሳ፥ አ ካታማነ አ ቢታ ታን ነ ኩሽያን አꬃደ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","ኔን እያርኮ ካታማነ አ ካትያ ꬋይሴዳዋዳን፥ ሄዋዳንካ አይ ካታማነ አ ካትያ ꬋይሳ። ሽን፥ ቦንቄዳ ኦሞዱዋነ ድኤዳ መህያ ህንተንቶ አክተ። ካታማፐ ጉየ ባጋና ሙጊደ ናግያ ኦላንቻቱዋ ዎꬃ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","ኢያሱነ ኦላንቻቱ ኡባይ አይ ካታማ ኦላናዉ ደንዴድኖ። ኢያሱ ባረ ኦላንቻቱዋ ግዶፐ ሀታሙ ሻአ ግድያ ምኖ ኦላንቻቱዋ ዶሪደ፥ ቃማን የዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","ኡንቱንታ ሀዋዳን ያጊደ አዛዜዳ፤ “ስስተ፥ ካታማፐ ጉየ ባጋና ሙጊደ ናግተ። ካታማፐ ሃኪደ ቦፕተ፤ ኡባይካ ጊጊደ ናግተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","ታንነ ታናና ደእያ አሳይ ኡባይ ካታማኮ ሺቃና። ሄ ዎደ አይ ካታማ አሳይ ካሰዋዳንካ ኑና ኦላና ጊደ ከሳና፤ ኑን ኡንቱንቱፐ ባቃታና። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","ካታማፐ ኡንቱንቱ ዉር ከሳና ጋካናዉ፥ ኑን ኡንቱንቶ ዎጻና፤ ያቶፐ ኡንቱንቱ፥ ‘ካሰዋዳንካ እስራኤላቱ ኑ ስንꬃፐ ባቃቲኖ’ ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ሄ ዎደ ህንተንቱ ሙጌዳ ሳኣፐ ከስነ፥ ካታማ ኦይቂ አጋና፤ ጾሳይ ህንተንቱ ጾሳይ ካታማ ህንተንቱ ኩሽያን አꬅ እማና። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","ካታማ ኦይቄዳዋፐ ጉይያን፥ ጾሳይ አዛዜዳዋዳን ታማን ጹግተ። ስም ታን ህንተንቶ ኦዳድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","ኢያሱ ኦላንቻቱዋ የድና ኡንቱንቱ ሙግያ ሳኣ ቢደ አይ ካታማፐ አዋይ ዉልያ ባጋና ደእያ ቤቴለፐነ አይፐነ ግዱዋን ሙጊደ ናጌድኖ። ሽን ኢያሱ ሄ ጋላስ ቃማ አሳና እትፐ አቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","ዎንተꬃ ጋላስ ጉራን ኢያሱ ደንዲደ፥ ኦላንቻቱዋ ሳልፕሴዳ፤ ያቲደ እነ እስራኤልያ ጭማቱነ ኦላንቻቱዋ ካለꬂደ አይ ካታማ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","አናና ደእያ ኦላንቻቱ ኡባይ ቢደ፥ አይ ካታማ ማቲደ ካታማፐ ሁጲሳ ባጋና ዱንካኔድኖ፤ ኡንቱንቱፐነ አይ ካታማፐነ ግዱዋን ዎምባይ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","ኢያሱ እቼሹ ሻአ ኦላንቻቱዋ አፊደ፥ ካታማፐ አዋይ ዉልያ ባጋና፥ ቤቴለፐነ አይፐ ግዱዋን ሙጋናዳ ዎꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","ካታማፐ ሁጲሳ ባጋና ደእያ ኦላንቻቱዋነ ካታማፐ አዋይ ዉልያ ባጋና ሙግ ኡቴዳ ኦላንቻቱዋ ኡባ ሳኣ ኦይꬄዳ። ሄ ጋላስ ቃማ ኢያሱ ሄ ዎምባን አቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","አይ ካታማ ካቲ ሄዋ በኤዳ ዎደ፥ እነ አ ኦላንቻቱነ ኡባይ ጉራን ኤሌል ደንዲደ፥ አራብያ ዱገ አፍያ ኦግያ ኦይቂደ፥ እስራኤልያ አሳና ኦላ ጋከታናዉ ዬድኖ፤ ሽን ካቲ ካታማፐ ጉየ ባጋና ሙግ ኡቴዳ ኦላንቻቱ ደእያዋ ኤርቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","ኢያሱነ እስራኤልያ ኡባይነ ጾነቴዳዋ ማላቲደ፥ ኡንቱንቱ ስንꬃፐ ባዙዋ ስሚደ ባቃቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","አይ ካታማን ደእያ አሳይ ኡባይ ኡንቱንታ የደርሳናዉ ጼገቲደ ኢያሳ የደርሲደ ካታማፐ ሃኪደ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","አይንነ ቤቴለን ደእያ አሳይ ኡባይ እስራኤልያ አሳ የደርሳናዉ ዉር ከስ ድግና፥ ካታማይ ናግያዌ ባይናን ጮ ዶያ አቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","ሄዋፐ ጉይያን መꬍና ጎዳይ ኢያሳ፥ “ነ ኩሽያን ደእያ ቶራ አይ ካታማኮ ዛራደ ደንꬃ። አያዉ ጎፐ፥ ታን አይ ካታማ ነ ኩሽያን አꬃደ እማና” ያጌዳ። ኢያሱ ባረ ቶራ ካታማኮ ዛሪደ ደንꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","ኢያሱ ቶራ ያ ዛሪደ ደንꬄዳ ዎደ፥ ሙግ ደእያ ኦላንቻቱ ባረንቱ ሙጌዳ ሳኣፐ ኤሌል ደንዲደ፥ ካታማ ገል አጌድኖ። ኦይቂደ፤ ኤለካ ካታማ ታማን ኦይꬅ አጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","አይ ካታማ አሳይ ጉየ ስሚደ ጼልያ ዎደ፥ ካታማ ጩዋይ ሳሉዋ ከሴዳዋ በኤድኖ፤ ሽን ያነ ሃነ ባቃታናዉ ዳንዳይበይክኖ። አያዉ ጎፐ፥ ባዙዋ ባቃቴዳ እስራኤልያ አሳይ ባረና የደርሴዳ ኡንቱንቱ ቦላ ጉየ ስሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","ኢያሱነ እስራኤልያ አሳይ ኡባይ ሙግ ኡቴዳ ኦላንቻቱ ካታማ ኦይቄዳዋነ ጩዋይ ሳሉዋ ከሴዳዋ በኤዳ ዎደ ጉየ ስሚደ፥ አይ ካታማ አሳ ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","ሙግ ኡቴዳ ኦላንቻቱካ ካታማፐ ኡንቱንቱ ቦላ ከሴድኖ። ያትና፥ አይ ኦላንቻቱ እስራኤልያ ኦላንቻቱዋን ላኡ ባጋና ድረቴድኖ። እት አሳይነ ፓጻ አተናን ዎይ ከስ አከናን ኡባ ዎꬍ ዉርሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","ሽን አይ ካታማ ካትያ ፓጻ ኦይቂደ፥ ኢያሱኮ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","እስራኤልያ አሳይ አይ ካታማ አሳይ ኡንቱንታ የደርሴዳ ደምባን ቃራ ማሻን ሙሸሬꬅ ዉርሴዳዋፐ ጉይያን፥ ኡባይካ ጉየ አይ ካታማ ስሚደ፥ ካታማን አቴዳ አሳ ኡባ ቃራ ማሻን ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","ሄ ጋላስ አይ ካታማ አሳይ አቱማዌነ ማጫዌ ኡባይ ዉር ሀይቄዳ፤ ሀይቄዳ አሳይ ኡባይ ታማነ ላኡ ሻአ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","ኢያሱ አይ ካታማን ደእያዋ ኡባ ሙለ ዉርሳና ጋካናዉ፥ ካታማኮ ማል ዎꬄዳ ቶራ ዱገ ዎꬅቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","ሽን መꬍና ጎዳይ ኢያሳ አዛዜዳዋዳን፥ እስራኤልያ አሳይ ሄ ካታማ መህያነ ደእያባ ባረንቶ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","ኢያሱ አይ ካታማ ጹግና ሀቼ ጋካናዉ ሹቻ ኬላ ግዲደ አት አጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","አይ ካታማ ካትያ ኦማርስ ጋካናዉ ምꬃ ቦላን ካቄዳ። አዋይ ዉልያ ዎደ፥ ኢያሱ አዛዝና፥ አ አሃ ካቄዳ ምꬃፐ ዎꬂደ ካታማ ገልያ ፐንግያን ኦሌድኖ፤ አ ቦላን ዳሮ ሹቻ ኬሌድኖ። ሹቻይ ሀቼ ጋካናዉ ሄ ሳኣን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","ሄዋፐ ጉይያን ኢያሱ ኤባላ ግያ ደርያ ቦላን መꬍና ጎዳዉ እስራኤልያ መꬍና ጎዳዉ ያርሹዋ ያርሽያ ሳኣ ግምቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","መꬍና ጎዳ ቆማይ ሙሴ እስራኤልያ አሳ አዛዜዳዋዳንነ ሙሴ ህግያ ማጻፋን ጎዳዉ፥ ያርሽያ ሳአይ ማሰትቤናነ ብራታይ ቦችቤና ሹቻፐ ግምበቴዳ። አን መꬍና ጎዳዉ ጹግያ ያርሹዋነ እትፐተꬃ ያርሹዋ ያርሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","ሄ ሳኣን እስራኤልያ አሳይ ጼልሽን፥ ኢያሱ ሙሴ ህግያ ዱቆዋ ሹቻ ቦላን ጻፌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","ሄ ዎደ፥ እስራኤልያ አሳይ ኡባይ፥ እስራኤልያ ዛራቱ፥ አላጋቱ፥ ጭማቱ፥ ጋዳዋቱነ ዳናቱ ኡባይ መꬍና ጎዳ ቃላ ጫቁዋ ታቦታ ቶኬዳ ሌዊያ ዛርያ ግድያ ቄሳቱዋ ስንꬃን ቃላ ጫቁዋ ታቦታፐ ኡሸቻ ባጋናነ ሀድርሳ ባጋና ኤቄድኖ። ኡንቱንቱፐ ባጋ አሳይ ባረንቱ ዞኪያ ጋሪዛማ ግያ ደርያኮ ዛርና፥ ባጋ አሳይ ኤባላ ግያ ደርያኮ ዛሪደ ኤቄድኖ። ኡንቱንቱ መꬍና ጎዳ ቆማይ ሙሴ ካሰ አዛዜዳዋዳን፥ እስራኤልያ አሳ አንጃናዉ ሄዋዳን ሀኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","ሄዋፐ ጉይያን ህግያ ማጻፋን ጻፈቶዋዳን፥ ኢያሱ ህግያ ቃላ ኡባ፥ አንጁዋካ ሸቃካ ናባቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","ሙሴ አዛዜዳዋ ኡባፐ ኢያሱ ናባበናን አጌዳ እት ቃላይካ ባዋ። ኩመንꬃ እስራኤልያ ሺቆ፥ ማጫ አሳዉ፥ ናናቶ፥ ኡንቱንቱ ግዶን ደእያ አላጋቱዋናካ ኡባዉ ናባቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","ዮርዳኖሳ ሻፋፐ አዋይ ዉልያ ባጋና ደእያ ካተቱ ኡባይ፥ ገዝያን ደእያዋንቱ፥ ጋꬋን ደእያዋንቱ፥ ሜድትራነ አባ ባዙዋ ኦይቂ ቢደ ሊባኖሳ ጋካናዉ ደእያዋንቱ፥ ሂተቱዋ፥ አሞራዋናቱዋ፥ ካናነቱዋ፥ ፓርዛዋናቱዋ፥ ሂዌቱዋነ ያቡሳዋናቱዋ ካተቱ ኡባይ እስራኤልያ አሳይ ጾኔዳዋ ስሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","ኢያሳነ እስራኤልያ አሳ ኦላናዉ ባናዉ እትፐ ሺቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","ጋባኦና ካታማን ደእያ ሂዌቱ ኢያሱ ያርኮ ካታማንነ አይ ካታማን ኦꬄዳዋ ስሴዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","ጭማናዉ ኮዬድኖ። ኡንቱንቱ ሽንቃ ቃቺደ ጩርቃ ዶንያቱዋ ዳሳ ዎꬅ ስኬዳ ኤሳ ኦጎሮቱዋ ሀርያን ጫኒደ፥ ኢያሱኮ ኪተቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","ኪተቴዳ አሳቱ ዉሬዳ ኤጫ ማዩዋ ማዪደ፥ ዎꬅ ስኬዳ ጫማ ባረንቱ ገድያን ዎꬄድኖ፤ ኡንቱንቱ ሽንቃዉ ጊደ ኦይቄዳ ቁማይ ኡባይ መሌዳዋነ ፑሉሜዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","ሄዋፐ ጉይያን ኡንቱንቱ ኢያሱ ዱንካኔዳ ሳኣ ገልጋላ ቢደ፥ አውነ እስራኤልያ አሳዉ፥ “ኑን ሃኮ ጋድያፐ ዬዶ። ሀይ ኑናና ሳሮ ደአና ማላ ቃላ ጫቁዋ ጫቃ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","እስራኤልያ አሳይ ሂዌቱዋ፥ “ህንተንቱ ኑ ጋድያን ደእያ አሰንቶነ፥ አያን ኤሪደ ህንተናና ጫቀታኔ?” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","ሄዋፐ ጉየ ኡንቱንቱ ኢያሳ፥ “ኑን ነ ቆማቱዋ” ያጌድኖ። ኢያሱ፥ “ህንተንቱ ኦኔ? ሀቃፐ ዬድቴ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","ሽን ኡንቱንቱ፥ “ኑን ነ ቆማቱ መꬍና ጎዳ ነ ጾሳ ዋርያ ስሲደ፥ ዳሮ ሃኮ ጋድያፐ ዬዶ። እ ግብጼ ጋድያን ኦꬄዳዋ ኡባ ኑን ስሴዶ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","ቃይ ዮርዳኖሳ ሻፋፐ ሄፍንꬃ አዋይ ዶልያ ባጋና ደእያ አሞራዋናቱዋ ካተቱዋ ላኡዋ፥ ሀሰቦና ካትያ ስሆናነ አስታሮታ ካታማን ደእያ ባሳነ ካትያ ኦጋ እ ኦꬄዳዋካ ስሴዶ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","ኑ ጋደ ጭማቱነ ኑ ቢታን ደእያ አሳይ ኡባይ ኑና፥ ‘ህንተ ባና ኦግያዉ ሽንቃ ኦይቂደ፥ ቢደ ኡንቱንቱና ጋከቲደ ኡንቱንታ፥ “ኑን ህንተንቱ ቆማቱዋ፤ ህንተንቱ ኑናና ሳሮ ደአና ማላ ጫቁዋ ጫቄርክተ” ያግተ’ ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","“ኑን ህንተንቱኮ ያናዉ ኑ ሶፐ ሽንቃ አክያ ጋላስ፥ ሀ ኡክꬃይ ሆኡዋ፤ ሽን ሀእ መሌዳዋነ ፑሉሜዳዋ በእተ! ");
INSERT INTO dwrENT_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","ሀዋንቱ ኤሳ ኦጎሮቱ ኑን ኩንꬅያ ዎደ ኦራꬃ፤ ሽን ሀእ ዳከቴዳዋ በእተ! ኦጊ ሃኮ ግዴዳዋ ጋሱዋን፥ ኑ ማዩነ ኑ ጫማይ ዉሬዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","መꬍና ጎዳ ኦቼናን፥ እስራኤልያ አሳይ ኡንቱንቱ ሽንቃፐ አማሬዳዋ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","ያትና፥ ኢያሱ ኡንቱንቱ ፓጻ አቲደ ባረናና ሳሮ ደአና ማላ ጫቁዋ ኡንቱንቱና ጫቀቴዳ፤ ማባራ ካለꬅያዋንቱካ ሄ ጫቁዋ ቃላ አናዳን ጫቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","ኡንቱንቱና ጫቁዋ ጫቀቴዳ ሄዘንꬆ ጋላሳፐ ጉይያን፥ ሀ አሳቱ ኡንቱንቱ ጋድያን ደእያ ሾሮ ግድያዋ እስራኤልያ አሳይ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","እስራኤልያ አሳይ ሄዙ ጋላሳ ሀመቲደ፥ አሳቱ ደእያ ካታማቱዋ ጋኬድኖ። ኡንቱንቱ ካታማቱ ጋባኦና፥ ካፊራ፥ ባኤሮታነ ቅርያት-ይኣሪማ ጌተትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","ሽን ማባራ ሱንꬃቱ ኡንቱንቶ መꬍና ጎዳ እስራኤልያ ጾሳ ሱንꬃን ጫቄዳ ድራዉ፥ ኡንቱንታ ዎꬍበይክኖ። ያትና፥ ኩመንꬃ ማባራይ ሱንꬃቱዋ ቦላን ዙዙሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","ሽን ካፓቱ ኡባይ ሀዋዳን ያጌድኖ፤ “ኑን ኡንቱንቶ መꬍና ጎዳ እስራኤልያ ጾሳ ሱንꬃን ጫቄዳ ድራዉ፥ ሀእ ስም ኡንቱንታ ቦቻናዉ ዳንዳዮኮ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","ሽን ኑን ኡንቱንታ ሀዋዳን ኦꬃና፤ ኑን ኡንቱንቶ ጫቄዳ ጫቁዋ ካድና ጾሳ ሀንቁ ኑ ቦላን ዎናዳን፥ ኡንቱንቱ ፓጻ ደእኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","ሽን ደኢደ ማባራዉ ኡባዉ ምꬃ ቃንጽያዋንታነ ሃꬃ ትክያዋንታ ግድኖ” ያጌድኖ። ሄዋ ድራዉ ጋባኦናቱዋ ሱንꬃቱ ጌዳዋዳን ሀኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","ኢያሱ ጋባኦና አሳቱዋ ጼጊደ፥ “ኑ ጋድያን ደኢደ፥ ‘ኑን ዳሮ ሃኮ ጋድያፐ ዬዶ’ ጊደ፥ አያዉ ኑና ጭሜድቴ? ");
INSERT INTO dwrENT_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","ህንተንቱ ሄዋ ሀኔዳ ድራዉ ሸቀቴድታ፤ ህንተንቱ መꬍናዉ ታ ጾሳ ጎለን ምꬃ ቃንጽያነ ሃꬃ ትክያ አይልያ ግዳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","ኡንቱንቱ ኢያሱዉ ዛሪደ ሀዋዳን ያጌድኖ፤ “ኑን ነ ቆማቱ መꬍና ጎዳይ ሀ ጋድያ ኡባ ህንተንቶ እማናዳንነ አን ደእያ አሳ ኡባ ህንተንቱ ስንꬃፐ ꬋይሳናዳን ባረ ቆማ ሙሳ አዛዜዳዋ ጌሺደ ስሴዶ። ሄዋ ድራዉ ህንተፐ ኑ ሸምፖ ዳሮ ያዪደ ሀዋ ኦꬄዶ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","ሀእ ስም ኑን ነ ኩሽያን ደኤቶ። ኑና ነዉ ሎአነ ሱረ ማላት ቤቴዳዋዳን ኦꬃ” ያጊደ ዛሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","ያትና፥ ኢያሱ ኡንቱንታ እስራኤልያ አሳይ ዎናዳን አሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","ሄ ጋላስ ኢያሱ ጋባኦና አሳቱዋ እስራኤልያ ማባራዉነ መꬍና ጎዳዉ ያርሽያ ሳአዉ ምꬃ ቃንጻናዳንነ ሃꬃ ትካናዳን ኦꬅና ኡንቱንቱ ሀቼ ጋካናዉ ጾሳይ አሳይ ባረዉ ጎይናናዳን ዶሬዳዌ ሳኣን ሀቃንነ ሄዋዳን ኦꬂደ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","ኢያሱ ካሰ ያርኮ ካታማ ኦለቲደ ባይዜዳዋዳንነ ኡንቱንቱ ካትያ ዎꬌዳዋዳን፥ አይ ካታማ ኦለቲደ ኡባ ባይዜዳዋነ ኡንቱንቱ ካትያካ ዎꬌዳዋ የሩሳላመ ካትያ አዶንጸደቅ ስሴዳ። ቃይ ጋባኦና አሳይ እስራኤልያ አሳና ሳሮ ደአናዉ ጫቀቴዳዋነ ሀእ ኡንቱንቱና እትፐ ደእያዋ ስሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","አ አሳይካ ሎይꬅ ያዬዳ። አያዉ ጎፐ፥ ጋባኦና ካታማይ ካተቱዋ ካታማቱዋፐ እቱዋ ማላ ዎልቃማ ካታማ፤ ቃይ ሄ ካታማይ አይ ካታማፐ ዳሬ፤ አን ደእያ አቱማ አሳይካ ምና። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","ያትና፥ የሩሳላመ ካትያ አዶንጸደቅ፥ ከብሮነ ካትያ ሆሃማዉ፥ ያርሙታ ካትያ ፒራማዉ፥ ላክሻ ካትያ ያፍአዉነ፥ ኤግሎና ካትያ ዳቢራዉ ሀዋዳን ያጊደ ኪቴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“ጋባኦና ካታማ አሳይ ኢያሱናነ እስራኤልያ አሳና ሳሮ ደአናዉ ጫቀቴዳ ድራዉ፥ ኡንቱንቱና ኦለታናዉ ዪደ ታና ማዴርክቴ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","ሄዋፐ ጉይያን አሞራዋናቱዋ ካተቱ እቼሻቱ የሩሳላመ ካቲ፥ ከብሮነ ካቲ፥ ያርሙታ ካቲ፥ ላክሻ ካቲነ ኤግሎና ካቲ ባረንቱ ኦላንቻቱዋ እትፐ ጋꬄድኖ። ባረንቱ ኦላንቻቱዋ ኡባ አኪደ ፑደ ቢደ፥ ጋባኦና ካታማ ዶዲደ ኦሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","ጋባኦና አሳይ ገልጋላን ዱንካኒደ ኢያሱኮ ኪቲደ፥ “ኑና ነ ቆማቱዋ አጎፓ፤ ኤለካ ኑኮ ያደ ኑና አሻ። ገዝያን ደእያ አሞራዋናቱዋ ካተቱ ኡባይ ኑና ኦላናዉ ባረንቱ ኦላንቻቱዋ እቱዋ ኦꬄዳ ድራዉ፥ ኔን ኑና ማዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","ሄዋፐ ጉየ ኢያሱ፥ አናና ደእያ ኦላንቻቱ ኡባይነ ምኖ አሳቱ ኡባይ ገልጋላፐ ደንዲደ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","መꬍና ጎዳይ ኢያሳ፥ “ኡንቱንቶ ያዮፓ! ታን ኡንቱንታ ነ ኩሽያን አꬃደ እማድ። ኡንቱንቱፐ እቱነ ኔናና ኤቀታናዉ ዳንዳየና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","ሄዋፐ ጉይያን ኢያሱ ገልጋላፐ ቃማ ኡባን ሀመቲደ አቂደ፥ ኡንቱንቱ አኬከናን ደእሽን ኡንቱንቱ ቦላ ዎራጄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","መꬍና ጎዳይ እስራኤልያ አሳ ስንꬃን ህንቱቶ ዎዛና ካሃ ባይዜዳ፤ ያትና፥ እስራኤልያ አሳይ ኡንቱንቱፐ ዳሮ አሳ ጋባኦናን ዎꬌዳ። እስራኤላቱ ኡንቱንታ ቤት-ሆሮና አፍያ ኦግያ ኦይꬂደ ጎዲደ፥ አዜቃነ ማቄዳ ጋካናዉ ቡꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","ቤት-ሆሮናፐ ዱገ አዜቃ አፍያ ኦግያ ኦይቂደ ኡንቱንቱ እስራኤልያ አሳ ስንꬃፐ ባቃትሽን፥ መꬍና ጎዳይ ዎልቃማ ሻቻ ሳሉዋፐ ኡንቱንቱ ቦላን ቡክሴዳ። እስራኤልያ አሳይ ማሻን ዎꬌዳ አሳፐ፥ ሻቻይ ዎꬌዳ አሳይ ፓይዱዋን ዳሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","መꬍና ጎዳይ አሞረቱዋ፥ እስራኤልያ አሳዉ አꬅ እሜዳ ጋላስ፥ እስራኤልያ አሳ ስንꬃን ኢያሱ መꬍና ጎዳ፥ “አዋ አይፊ ጋባኦና ቦላን፥ ዉለናን ጋምኦ። አግናይካ አያሎና ዛንጋራ ቦላን ኤቆ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","ሄዋፐ ጉየ እስራኤልያ አሳይ ባረንቱ ሞርከቱዋ ጾናና ጋካናዉ፥ አዋይ ዉለናን ጋምኤዳ። አግናይካ ባረ ደእያ ሳኣፐ ቃጽቤና። ሄዌ ያሻራ ማጻፋን ጻፈት ኡቴዳ። አዋይ ሳሎ ግዶ ባጋን ቃጸናን ኤቄዳ፤ እት ጋላሳ ኡባ አዋይ ዉለናን ታኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","መꬍና ጎዳይ አሳይ ኦዴዳዋ ስሴዳ ሄ ጋላሳ ማላ ጋላሳይ ሄዋፐ ካሰ ግድናካ፥ ሄዋፐ ሃ ዶምና ኡባካ ሀንቤና። ቱሙካ መꬍና ጎዳይ እስራኤልያ አሳዉ ኦለቴዳ! ");
INSERT INTO dwrENT_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","ሄዋፐ ጉይያን ኢያሱነ እስራኤልያ ኦላንቻቱ ኡባይ ባረንቱ ዱንካኔዳ ሳኣ ገልጋላ ስሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","ሄ አሞራዋናቱዋ ካተቱ እቼሻቱ ባቃቲደ፥ ማቄዳ ካታማ ማታን ደእያ ጎንጎሉዋ ግዶን ቆሰቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","እያሶ፥ “እቼሹ ካተቱ፥ ማቄዳ ካታማ ማታን ደእያ ጎንጎሉዋ ግዶን ቆሰቴዳዋንታ ደሜዶ” ያጊደ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","ኢያሱ፥ “ዎልቃማ ሹቻቱዋ ጎንዶርሲደ፥ ጎንጎሉዋ ፐንግያ ጎርዲደ ኡንቱንታ ናጋና ማላ፥ አሳ ያን ዎꬅተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","ሽን ህንተንቱ ያን ጋምኦፕተ፤ ህንተንቱ ሞርከቱዋ የደርሲደ፥ ጉየና ኡንቱንታ ኦልተ፥ ኡንቱንታ ኡንቱንቱ ካታማ ገልሶፕተ። መꬍና ጎዳይ ህንተንቱ ጾሳይ ኡንቱንታ ህንተንቱ ኩሽያን አꬂደ እሜዳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","ባረንቱ ግምበቴዳ ካታማቱዋ ባቃቲደ ገሌዳ ላፋ አሳቱ አትና፥ ህንኮ አሳ ኡባ ኢያሱነ እስራኤልያ አሳይ ዉርስ ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","ሄዋፐ ጉይያን፥ አሳይ ኡባይ ሳሩዋን ስሚደ፥ ኢያሱ ዱንካኒደ ደእያ ማቄዳ ግያሳ ዬዳ። ሄደፐ ዶምና እስራኤልያ አሳ ቦላን እት ቃላነ ቃቴዳ አሳይ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","ሄዋፐ ኢያሱ፥ “ጎንጎሉዋ ፐንግያ ዶዪደ፥ ሄ እቼሹ ካተቱዋ ከሲደ፥ ታዉ ሃ አኪደ ዪተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","ሄዋፐ ጉየ ጎንጎሉዋ ግዶፐ የሩሳላመ ካትያ፥ ከብሮነ ካትያ፥ ያርሙታ ካትያ፥ ላክሻ ካትያነ ኤግሎና ካትያ ከሲደ አኮ አሄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","ኡንቱንቱ ሄ ካተቱዋ ኢያሱኮ አሄዳ ዎደ፥ ኢያሱ እስራኤልያ አሳ ኡባ ባረኮ ጼሲደ ባረናና ቤዳ ኦላ ጋዳዋቱዋ፥ “ሃ ዪደ ህንተንቱ ገድያን ሀ ካተቱዋ ቆꬍያ የꬍተ” ያጌዳ። ሄዋፐ ዪደ ባረንቱ ገድያን ኡንቱንቱ ቆꬍያ የꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","ኢያሱ ኡንቱንታ፥ “ያዮፕተ፤ ህርጎፕተ፤ ምንተነ ጻልተ። ህንተንቱ ኦለትያ ህንተንቱ ሞርከቱዋ ኡባ መꬍና ጎዳይ ሀዋዳን ኦꬃና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","ሄዋፐ ጉይያን ኢያሱ እቼሹ ካተቱዋ ዎꬊደ እቼሹ ምꬃ ቦላን ካቄዳ፤ ኡንቱንቱ ኦማርስ ጋካናዉ ካቁዋን ፔሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","አዋይ ዉልያ ዎደ፥ ኢያሱ አዛዝና ኡንቱንታ ምꬃፐ ዎꬄድኖ፤ ኡንቱንቱ ካሰ ቆሰቲደ ደኤዳ ጎንጎሉዋ ግዶ ኦሌድኖ። ያቲደ ጎንጎሉዋ ፐንግያ ዎልቃማ ዎልቃማ ሹቻቱዋ ጎንዶርሲደ ጎርዴድኖ። ሄ ሹቻቱ ሀቼ ጋካናስካ ያን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","ሄ ጋላስ ኢያሱ ማቄዳ ካታማ ኦይቂደ ካታማ ኡባ ꬋይሴዳ፤ ካታማን ደእያ አሳ ኡባ እቱዋነ አሸናን ዉርስ ዎꬌዳ። እያርኮ ካታማ ካትያ ካሰ ዎꬌዳዋዳን፥ ማቄዳ ካታማ ካትያካ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","ሄዋፐ ጉይያን ኢያሱነ አናና ደእያ አሳይ እስራኤልያ አሳይ ኡባይ ማቄዳ ካታማፐ ሊብና ግያ ካታማ ቢደ ኦሌድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","መꬍና ጎዳይ ሄ ካታማካ ካታማ ካትያካ እስራኤልያ አሳ ኩሽያን አꬂደ እሜዳ። ኢያሱ እቱዋነ አሸናን፥ ካታማን ደእያ አሳ ኡባ ቃራ ማሻን ቡሳኬዳ። ያርኮ ካታማ ካትያ ካሰ ዎꬌዳዋዳን፥ ሊብና ካታማ ካትያካ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","ሄዋፐ ጉይያን ኢያሱነ አናና ደእያ እስራኤልያ አሳይ ኡባይ ሊብና ካታማፐ ላክሻ ካታማ ቢደ ሄ ካታማ ዶዲደ ኦሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","መꬍና ጎዳይ ላክሻ ካታማ እስራኤልያ አሳ ኩሽያን አꬂደ እምና ኢያሱ ሄ ካታማ ላኤንꬆ ጋላሳን ኦይቄዳ። ሊብና ካታማ ኦꬄዳዋዳን ላክሻ ካታማካ ኦꬄዳ፤ ሄ ካታማን ደእያ አሳ ኡባ ቃራ ማሻን ቡሳኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","ሄ ዎደ፥ ገዜራ ካታማ ካትያ ሆራም፥ ላክሻ ካታማ ካትያ ማዳናዉ ዬዳ፤ ሽን ኢያሱ አካ አ አሳካ ጾኔዳ፤ ኡንቱንቱፐ እት አሳይነ ፓጻ አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","ሄዋፐ ስሚደ፥ ኢያሱነ አናና ደእያ እስራኤልያ አሳይ ኡባይ ላክሻ ካታማፐ ኤግሎና ካታማ ቢደ ሄ ካታማ ዶዲደ ኦሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","ሄ ጋላስ ኤግሎና ካታማ ኦይቂደ ቃራ ማሻን ቡሳኬድኖ። ላክሻ ካታማ ኦꬄዳዋዳን፥ ኤግሎና ካታማን ደእያ አሳ ኡባ ዉርስ ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","ሄዋፐ ጉይያን ኢያሱነ አናና ደእያ እስራኤልያ አሳይ ኡባይ ኤግሎናፐ ከብሮና ቢደ ከብሮና ኦሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","ሄ ካታማ፥ ኡንቱንቱ ካትያነ ሄ ካታማ ዩሹዋን ደእያ ቄር ካታማቱዋ ኦይቄድኖ። ኡንቱንቱን ደእያ አሳ ኡባካ ቃራ ማሻን ቡሳኬድኖ። እት አሳካ አሽበይክኖ። ኢያሱ ኤግሎና ኦꬄዳዋዳን ሄ ካታማካ ኦꬄዳ፤ ኡንቱንቱን ደእያ አሳካ ዉርስ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","ሄዋፐ ጉይያን ኢያሱነ አናና ደእያ እስራኤልያ አሳይ ኡባይ ዳቢራ ካታማ ስሚደ ኦሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","ኡንቱንቱ ሄ ካታማካ፥ ካትያካ፥ ካታማ ዩሹዋን ደእያ ቄር ካታማቱዋካ ኡባ ኦይቂደ ኡንቱንቱን ደእያ አሳ ኡባ እቱዋነ አሸናን ዉርስ ዎꬌድኖ። ኢያሱ ከብሮና ካታማነ ሊብና ካታማነ አ ካትያ ኦꬄዳዋዳን፥ ዳቢራ ካታማነ አ ካትያ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","ኢያሱ ቢታ ኡባ፥ ገዝያ፥ ኔጌባ ባዙዋ፥ ጋꬋ ጋድያነ ኡንቱንቱ ካተቱዋናካ ኦይቄዳ። መꬍና ጎዳይ እስራኤልያ ጾሳይ አዛዜዳዋዳን፥ ጋድያ ቦላን ፓጻ ሸምፑዋና ደእያ አሳ ኡባ እቱዋነ አሸናን ዉርስ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","ኢያሱ ኡንቱንታ ቃዴሳ-ባርነፐ ዶሚደ ቢደ ጋዛ ጋካናዉ፥ ቃይ ጎሸና ቢታ ኡባፐ ዶሚደ ቢደ ጋባኦና ጋካናዉ ኡባ ጾኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","መꬍና ጎዳይ እስራኤልያ ጾሳይ እስራኤልያ አሳዉ ኦለቴዳ ጋሱዋን፥ ኢያሱ ሄ ካተቱዋ ኡባ ኡንቱንቱ ቢታናካ እት ገደ ኦላን ጾኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","ሄዋፐ ጉይያን ኢያሱነ እስራኤልያ አሳይ ኡባይ ባረንቱ ዱንካኔዳ ሳኣ ገልጋላ ስሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","ሀጾራ ካታማ ካትያ ያብን እስራኤልያ አሳይ ጾኔዳዋ ስሴዳ ዎደ፥ ማዶና ካታማ ካትያ ዮባባዉ፥ ሽምሮና ካታማ ካትያዉ፥ አክሻፋ ካታማ ካትያዉ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","ሁጲሳ ባጋና ገዝያን ደእያ ካተቶ፥ ጋሊላ አባፐ ገድሳ ዮርዳኖሳ ዎምባን ደእያ ካተቶ፥ አዋይ ዉልያ ባጋና ጋꬋን ደእያ ካተቶነ አዋይ ዉልያ ባጋና ደእያ ዶራ ካትያዉ አሳ ኪቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","ቃይ አዋይ ዶልያ ባጋናነ አዋይ ዉልያ ባጋና ደእያ ካናነቶ፥ አሞረቶ፥ ሂተቶ፥ ፓርዘቶ፥ ገዝያን ደእያ ያቡሳቶነ ምጽጳ ቢታን ሄርሞነ ደርያፐ ጋርሳና ደእያ ሂዌቶ ኪቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","ኡንቱንቱ ኡባይ ባረንቱ ኦላንቻቱዋ ደንꬂደ፥ እስራኤልያ ኦላናዉ እትፐ ጋከቴድኖ። ሄ ኦላንቻቱ ፓራቱዋናነ ፓራ ጋረቱዋና ጋከቲደ፥ ፓይድና ዉረና አባ ዶና ሻፍያዳን ጮራቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","ሄ ካተቱ ኡባይ ባረንቱ ዎልቃ እትፐ ጋꬂደ፥ እስራኤልያ አሳ ኦላናዉ መሮማ ግያ ሃꬃ ማታን ዱንካኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","መꬍና ጎዳይ ኢያሳ፥ “ኔን ኡንቱንቶ ያዮፓ! ታን ዎንት ሀኖደ ኡንቱንታ ኡባቱዋካ ዎꬋደ፥ እስራኤልያ አሳዉ አꬃደ እማና። ኔን ኡንቱንቱ ፓራቱዋ ኡባ ግልዳያና፤ ኡንቱንቱ ፓራቱዋ ጋረቱዋካ ታማን ጹጋና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","ኢያሱነ አ ኦላንቻቱ ኡባይ ኡንቱንቱ አኬከናን ደእሽን መሮማ ሃꬃ ማታን ኡንቱንቱ ቦላ ፑቱ ጊደ፥ ኡንቱንታ ኦሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","መꬍና ጎዳይ ኡንቱንታ እስራኤላቱ ኩሽያን አꬂደ እሜዳ። ኡንቱንታ ጾኒደ፥ ዎልቃማ ሲዶና ግያ ጋድያ፥ ምስራፎታ-ማይማነ አዋይ ዶልያ ባጋና ደእያ ምጽጳ ዎምባ ጋካናዉ የደርሴድኖ። ኡንቱንቱፐ እት አሳነ አሸናን ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","ኢያሱ መꬍና ጎዳይ አ አዛዜዳዋ ኡባ ኡንቱንቱ ቦላን ፖሌዳ፤ ኡንቱንቱ ፓራቱዋካ ግልዳዬዳ፤ ፓራ ጋረቱዋካ ታማን ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","ሄዋፐ ጉይያን ኢያሱ ጉየ ስሚደ፥ ሀጾራ ግያ ካታማ ጾኒደ ኦይቂደ ሄ ካታማ ካትያ ማሻን ዎꬌዳ። ሄ ዎደ ሀጾራ ካታማይ ሄ ካዉተꬃ ኡባዉ ሁጰ ካታማ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","እስራኤልያ አሳይ ሄ ካታማን ደእያ አሳ ኡባ ቃራ ማሻን ዎꬌዳ። ሸምፑ ፓጻ ደእያዋ ኡባ እቱዋነ አሸናን ዉርስ ዎꬌድኖ። ኢያሱ ሀጾራ ካታማካ ታማን ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","መꬍና ጎዳ ቆማይ ሙሴ አዛዜዳዋዳን፥ ኢያሱ ሄ ካተቱዋ ካታማቱዋነ ኡንቱንቱ ካተቱዋ ኡባ ኦሞዲደ አሳ ኡባ ቃራ ማሻን ዉርስ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","ግዶፐነ፥ ኢያሱ ጹጌዳ ሀጾራ ካታማፐ አትና፥ እስራኤልያ አሳይ ዞዝያ ቦላን ኬጸቴዳ ካታማቱዋ ኡባ ጹግበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","እስራኤልያ አሳይ ሄ ካታማቱዋፐ ቦንቄዳ ሚሻ ኡባነ መህያ ኡባ ባረንቶ አኬድኖ። ሽን አሳ ኡባ ꬋይሳና ጋካናዉ ቃራ ማሻን ዎꬌድኖ፤ ፓጻ ደእያዋ አያካ አሽበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","መꬍና ጎዳይ ባረ ቆማ ሙሳ አዛዜዳዋዳን፥ ሙሴካ ኢያሳ አዛዜዳ። ኢያሱካ አዛዙዋ ፖሌዳ፤ መꬍና ጎዳይ ሙሴዉ አዛዜዳዋ ኡባፐ እ ኦናን አጌዳባይ አያይነ ባዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","ሄዋዳን ኦꬂደ ኢያሱ ሄ ጋድያ ኡባ፥ እስራኤልያ ዞዛቱዋ፥ ኔጌባ ባዙዋ ኡባ፥ ጎሸና ግያ ጋድያ ኡባ፥ አዋይ ዉልያ ባጋና ደእያ ዛንጋራነ አራብያ ጋꬋ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","ሄ ቢታይ ኤዶም ደእያ ሀላቃ ግያ ደርያፐ ዶም ቢደ፥ ሄርሞነ ደርያፐ ጋርሳ ባጋና ደእያ ሊባኖሳ ዎምባን ደእያ ባኣል-ጋዳ ጋካናዉ ደእያ ሳኣ ጋኬ። ኡንቱንቱ ካተቱዋ ኡባ ኢያሱ ኦሞዲደ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","ኢያሱ ዳሮ ዎድያ ሄ ካተቱዋ ኡባና ኦለቲደ ጋምኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","ጋባኦናን ደእያ ሂዌቱዋፐ አትና፥ ሀራ ካታማይ እቱነ እስራኤላቱዋና ሳሮ ደአና ጫቁዋ ጫቀትቤና፤ እስራኤላቱ ሄ ካታማቱዋ ኡባ ኦላን ጾኒደ ኦይቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ኢያሱ ኡንቱንታ ቃረት ባይናን እቱዋነ አሸናን ዉርስ ዎꬌዳ። አያዉ ጎፐ፥ ኡንቱንቱ እስራኤላቱዋና ኦለታናዳን መꬍና ጎዳይ ባረ ሁጲያዉ ኡንቱንቱ ዎዛና ሙምሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","ሄ ዎደ ኢያሱ ቢደ ገዝያን፥ ከብሮና ካታማን፥ ዳቢራ ካታማን፥ አናባ ካታማን፥ ይሁዳ ገዝያን ኡባንነ እስራኤልያ ገዝያን ኡባን ደእያ አናቀ ዘረꬃ አዱሳቱዋ ዎꬍ ዉርሴዳ። ኢያሱ ኡንቱንታነ ኡንቱንቱ ካታማ ኡባና ꬋይሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","አናቀ ዛራቱዋፐ እስራኤልያ ጋድያን ኦንነ አትቤና፤ ሽን አማሬዳዋንቱ ጋዛ፥ ጋተነ አሽዶዳ ካታማቱዋ ጻላላን አቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ ኢያሱ ጋድያ ኡባ ኦይቂደ እስራኤልያ አሳዉ ኡንቱንቱ ዛርያን ዛርያን ሻክ እሜዳ። ሄዋፐ ጉይያን ቢታይ ኦላፐ ሸምፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","እስራኤልያ አሳይ ዮርዳኖሳ ሻፋፐ አዋይ ዶልያ ባጋና ደእያ አርኖና ዛንጋራፐ ቢደ ሄርሞነ ደርያ ጋካናዉ፥ ቃይ አዋይ ዶልያ ባጋና አራብያ ጋꬋ ጋካናዉ ደእያ ጋድያ ካተቱዋ ኡባ ጾኒደ ዎꬅ አኬዳ። ሄ ጾነቴዳ ካተቱ ሀዋፐ ካሊደ ጻፈቴዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","ኡንቱንቱፐ እቱ፥ ሀሰቦና ካታማን ኡቴዳ አሞራዋናቱዋ ካትያ ስሆና። እ ሞዴዳ ሳአይ አርኖና ዛንጋራ ጋጻን ደእያ አሮኤራ ካታማፐ ደንዲደ፥ አሞናቱዋ ዛዋ ጋካናዉ ደእያ ያቦቃ ሻፋ ጋኬ፤ ሄ ሳአይ ጋላኣደ ግያ ቢታዉ ዛዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","እ ቃይ አዋይ ዶልያ ባጋና አራብያ ጋꬋፐ ባጋ አኪደ፥ ጋሊላ አባፐ ቢደ፥ ቤት-ያሽሞታ ካታማና አꬊደ፥ ፕስጋ ግያ ደርያፐ ጋርሳ ባጋና ደእያ ማጽነ አባ ጋካናዉ፥ ቢታቱዋ ሞዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","ሄዋዳንካ፥ ራፋየቱዋ ዛርያፐ ዉርሰꬃን አቴዳ ባሳነ ጋድያ ካትያ ኦጋ ጾኔዳ። ኦግ አስታሮታ ካታማንነ ኤድራአ ካታማን ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","እ ሞዴዳ ሳአይ ሄርሞነ ደርያ፥ ሳላካ ግያ ሳኣ፥ ባሳነ ጋድያ ኡባ ቢደ ጋሹራነ ማእካ አሳቱዋ ዛዋ ጋኬ፤ ቃይ ጋላኣደ ጋድያፐ ባጋ አኪደ፥ ቢደ ሀሰቦና ካትያ ስሆና ዛዋ ጋካናዉ ደእያ ጋድያ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","መꬍና ጎዳ ቆማይ ሙሴነ እስራኤልያ አሳይ ሀ ካተቱዋ ጾኔድኖ። መꬍና ጎዳ ቆማይ ሙሴ ኡንቱንቱ ቢታቱዋ ሮቤላ ዛረቶ፥ ጋደ ዛረቶነ ምናሰ ዛራቱዋፐ ባጋዉ ሻክ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","ኢያሱነ እስራኤልያ አሳይ ዮርዳኖሳ ሻፋፐ አዋይ ዉልያ ባጋ ጋድያን ደእያ ካተቱዋ ኡባ ጾኔድኖ። ሄ ቢታቱ ሊባኖሳ ዎምባን ደእያ ባኣል-ጋዳፐ ዶሚደ፥ ገድሳ ባጋና ኤዶማ ማታን ደእያ ሀላቃ ደርያ ጋኪኖ። ኢያሱ ሄ ቢታቱዋ ሻክ፥ እስራኤልያ ዛረቶ ላታ ጋደ ኦꬂደ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","ሄ ቢታቱ፥ ገዝያ፥ አዋይ ዉልያ ባጋና ደእያ ኦላትያ፥ ዮርዳኖሳ ጋꬋ፥ ይሁዳ ባዙዋነ ኔጌባ ባዙዋ። ሄ ቢታቱ ካሰ ሂተቱ፥ አሞራዋናቱ፥ ካናነቱ፥ ፓርዛዋናቱ፥ ሂዌቱነ ያቡሳዋናቱ ደኤዳ ሳኣ። ");
INSERT INTO dwrENT_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","እስራኤልያ አሳይ ጾኔዳ ካተቱ ሀዋንታ፤ ያርኮ ካትያ፥ ቤቴለ ማታን ደእያ አይ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","የሩሳላመ ካትያ፥ ከብሮና ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ያርሙታ ካትያ፥ ላክሻ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ኤግሎና ካትያ፥ ገዜራ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ዳቢራ ካትያ፥ ገዴራ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ሆርማ ካትያ፥ አራዳ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ሊብና ካትያ፥ አዱላማ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ማቄዳ ካትያ፥ ቤቴለ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ታፑሀ ካትያ፥ ሄፌራ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","አፌቃ ካትያ፥ ላሻሮና ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ማዶና ካትያ፥ ሀጾራ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ሽምሮን-ማሮና ካትያ፥ አክሻፋ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ታእናካ ካትያ፥ ማግዶ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ቃዴሳ ካትያ፥ ቃርመሎሳን ደእያ ዮቅናኣማ ካትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ዶራ ገዝያን ደእያ ዶራ ካትያ፥ ገልጋላን ደእያ ጎይማ ካትያነ ");
INSERT INTO dwrENT_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","ትርጻ ካትያ። ኡንቱንቱ ኡባይ ሀታማነ እት ካተቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","ኢያሱ ጭሚደ፥ ላይꬃ ሎይꬅ ሱጌዳ ዎደ፥ መꬍና ጎዳይ አዉ፥ “ኔን ጭማዳ፤ ላይꬃካ ሎይꬃ ሱጋዳ። ሽን ኦይቀተናን አቴዳ ዳሮ ቢታይ ብሮ ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","ኦይቀትቤና ቢታቱ ሀዋንታ: ፕልስጼማቱዋ ጋድያነ ጋሹራቱዋ ጋድያ ኡባ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","ግብጼፐ አዋይ ዶልያ ባጋና ደእያ ሽሆራ ሻፋፐ ዶሚደ፥ ሁጲሳ ባጋና ደእያ ኤቅሮና ጋድያ ጋካናዉ ደእያ ቢታቱ ኡባይ ካናነ ጋድያን ፓይደቲኖ። እቼሹ ፕልስጼማ ካተቱ ሞድያ ካታማቱ ጋዛ፥ አሽዶዳ፥ አስቃሎና፥ ጋታነ ኤቅሮና ጌተትያ። አዎቱዋ ቢታይካ ብሮ ኦይቀትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","ገድሳ ባጋና ካናነቱ ቢታይ ኡባይ፥ ሲዶናቶ ደእያ ማኣራ ግያ ሳፐ ደንዲደ ቢደ፥ አሞራዋናቱዋ ጋድያን ደእያ አፌቃ ካታማ ጋካናስካ ኦይቀትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","ገባላቱ ቢታይ አዋይ ዶልያ ባጋና ሊባኖሳ ቢታይ ኡባይ፥ ሄርሞነ ደርያፐ ጋርሳ ባጋና ደእያ ባኣል-ጋዳ ካታማፐ ቢደ፥ ሀማታ ፕኑዋ ጋካናዉ ብሮ ኦይቀትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","ሊባኖሳፐ ቢደ ምስራፎታ-ማይማ ጋካናዉ ደእያ ገዝያን ደእያ ሲዶናቱዋ ቢታይካ ኦይቀትቤና። ታን ታ ሁጲያዉ እስራኤልያ አሳ ስንꬃፐ ኡንቱንታ ላጋደ ከሳና። ታን ኔና አዛዜዳዋዳን፥ ኔን ሀ ቢታቱዋ እስራኤልያ አሳዉ ጋደ ኦꬃደ ሻካ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","ሀእ ኔን ሀ ጋድያ ኡዱፑን ዛረቶነ ምናሰ ዛራቱዋፐ ባጋዉ ሻካ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","ምናሰ ዛራቱዋፐ ባጋቱ፥ ሮቤላ ዛራቱነ ጋደ ዛራቱ መꬍና ጎዳ ቆማይ ሙሴ ዮርዳኖሳ ሻፋፐ ሄፍንꬃ አዋይ ዶልያ ባጋና ኡንቱንቶ ግሽ ዎꬄዳ ጋድያ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","ኡንቱንቱ ቢታይ አርኖና ዛንጋራ ጋርሳን ደእያ አሮኤራ ካታማፐ ደንዲደ፥ ሄ ዛንጋራ ግዶን ደእያ ካታማ ኦይቂደ፥ መዳባ ግያ ገዝያ አꬍ ቢደ፥ ድቦና ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","ቃይ ሀሰቦናን ኡቲደ ሞድያ አሞራዋናቱዋ ካትያ ስሆና ካታማቱዋ ኡባ ኦይቂ ቢደ፥ አሞናቱዋ ዛዋ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","ሄዋዳንካ፥ ቃይ ጋላኣደ ጋድያ፥ ጋሹራቱዋ ጋድያ፥ ማእካቱዋ ጋድያ፥ ሄርሞነ ደርያ ኡባነ ሳላካ ጋካናዉ ደእያ ባሳነ ጋድያ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","አስታሮታ ካታማንነ ኤድራአ ካታማን ደኢደ ሞድያ፥ ራፋየቱዋ ዛርያፐ ዉርሰꬃን አቴዳ ባሳነ ካትያ ኦጋ ጋድያ ኡባ ኦይቄዳ። ሙሴ ሄ አሳ ኡባ ጾኒደ፥ ኡንቱንቱ ጋድያፐ ላጊደ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","ሽን እስራኤልያ አሳይ ጋሹራ አሳነ ማእካ አሳ ጋድያፐ ከስበይክኖ፤ ሄዋ ድራዉ ኡንቱንቱ ሀቼ ጋካናዉ እስራኤልያ አሳ ግዶን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","ሙሴ ሌዊያ ዛራቱዋ ጻላላዉ ላትያ ጋድያ እምቤና። መꬍና ጎዳይ ሙሴዉ ጌዳዋዳን፥ መꬍና ጎዳይ እስራኤልያ ጾሳዉ ታማን ጹግያ ያርሹዋ ያርሽያዌ ኡንቱንቶ ላታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","ሙሴ ሮቤላ ዛረቶ ኡንቱንቱ ያራን ያራን ጋድያ ሻክ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","ኡንቱንቱ ቢታይ አርኖና ዛንጋራ ጋጻን ደእያ አሮኤራ ካታማፐ ደንዲደ፥ ሄ ዛንጋራ ግዶን ደእያ ካታማ ኦይቂደ፥ መዳባ ገዝያ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","ቃይ ሀሰቦና፥ ገዝያን ደእያ ካታማቱዋ፥ ድቦና፥ ባሞት-ባኣላ፥ ቤትባኣል-መኦና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ያሃጻ፥ ቅደሞታ፥ መፋኣታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","ቅርያታይማ፥ ሲብማ፥ ዛንጋራ ግዶን ደእያ ደርያ ቦላ ደእያ ጼረታ-ሻሀራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","ቤት-ፓኦራ፥ ፕስጋ ደርያፐ ጋርሳና ደእያ ጋድያነ ቤት-ያሽሞታ ጌተትያ ካታማቱዋ ኡባ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","ሄዋዳንካ፥ ቃይ ገዝያን ደእያ ካታማቱዋነ ሀሰቦና ካታማ ሞዴዳ አሞራዋናቱዋ ካትያ ስሆና ጋድያ ኡባ ጋኬ። ሙሴ ካትያ ስሆናነ ምድያማቱዋ ካፓቱዋ ኤዋ፥ ረቄማ፥ ጹራ፥ ሁራነ ረባአ ጾኔዳ፤ ሀዋንቱ ስሆናፐ ጋርሳና ሄ ጋድያ ሞድያዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","እስራኤልያ አሳይ ኦላን ዎꬌዳ አሳፐ ሀራ፥ ሻሬቹዋ፥ ባኦራ ናኣ ባላኣማካ ማሻን ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","ሮቤላ ዛራቱዋ ዛዋይ ዮርዳኖሳ ሻፋ። ሀ ካታማቱነ ኡንቱንቱ ሄራን ደእያ ሞꬃቱ፤ ሮቤላ ዘረꬃ ኡንቱንቱ ያራን ያራን ጋኬዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","ሙሴ ጋደ ዛረቶ ኡንቱንቱ ያራን ያራን ጋድያ ሻክ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","ኡንቱንቱ ጋዲ ያእዜራ፥ ጋላኣደን ደእያ ካታማቱዋ ኡባነ አሞናቱዋ ጋድያፐ ባጋ አኪደ፥ ራባፐ አዋይ ዶልያ ባጋና ደእያ አሮኤራ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","ሄዋዳንካ፥ ሀሰቦናፐ ደንዲደ፥ ራሞታ-ምጽጳነ በጾኒማ ጋኬ፤ ቃይ ማህናይማፐ ደንድ ቢደ፥ ሎዳባራ ዛዋ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","ዮርዳኖሳ ዎምባዉ ግዱዋን ሀሰቦና ካትያ ስሆና ካዉተꬃፐ አቴዳዉንታ፥ ቤት-ሀራማ፥ ቤት-ኒምራ፥ ሱኮታነ ጻፎና ጌተትያ ካታማቱዋ አኬዳ። አዋይ ዶልያ ባጋና ኡንቱንቱ ዛዋይ ዮርዳኖሳ ሻፋ ግዲደ ቢደ፥ ጋሊላ አባ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","ሄ ካታማቱነ ኡንቱንቱ ሄራን ደእያ ሞꬃቱ ጋደ ዛረቶ ኡንቱንቱ ያራን ያራን ጋኬዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","ሙሴ ምናሰ ዛራቱዋፐ ባካዉ ኡንቱንቱ ያራን ያራን ጋድያ ሻክ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","ኡንቱንቱ ቢታይ ማህናይማነ ባሳነ ጋድያ ኡባ ጻጽ ዋጼ፤ ባሳነ ካትያ ኦጋ ካዉተꬃ ኡባነ ባሳነን ደእያ ኡሱፑን ታሙ ያኢራ ካታማቱዋ ኦይቄ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","ቃይ ጋላኣደፐ ባካነ ባሳነን ኦጋ ካዉተꬃይ ሁጰ ግዴዳ አስታሮታነ ኤድራአ ጌተትያ ካታማቱዋ ጋኬ። ሄ ኡባይ ምናሰ ናኣ ማኪና ዛራቱዋፐ ባጋቶ፥ ኡንቱንቱ ያራን ያራን ጋኬዳዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","ዮርዳኖሳፐ ሄፍንꬃና፥ ያርኮፐ አዋይ ዶልያ ባጋና ደእያ ሞኣበ ደምባን ደኢደ ሙሴ ሻክ እሜዳ ጋዲ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","ሽን ሙሴ ሌዊያ ዛረቶ ላትያ ጋድያ እምቤና፤ ካሰ መꬍና ጎዳይ ኡንቱንቶ ጌዳዋዳን፥ መꬍና ጎዳይ እስራኤልያ ጾሳይ ኡንቱንቱ ላታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","ቄስያ ኤልኣዛረ፥ ነዌ ናአይ ኢያሱነ እስራኤልያ ዛራቱዋ ካፓቱ፥ ካናነ ጋድያ ኡንቱንታ ያራን ያራን ሻክና፥ ኡንቱንቱ ጋኬዳ ሄራቱ ሀዋፐ ካሊደ ጻፈቴዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳዋዳን፥ ኡንቱንቱ ላታ ጋዲ ኡዱፑናነ ባጋ ግድያ ዛረቶ ሳማን ሻከቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","አያዉ ጎፐ፥ ሙሴ ላአነ ባጋ ግድያ ዛረቶ ዮርዳኖሳ ሻፋፐ ሄፍንꬃ አዋይ ዶልያ ባጋና ካሰ ጋድያ እም ዎꬄዳ፤ ሽን ሌዊያ ዛረቶ ኡንቱንቱ ግዱዋን ላታ ጋድያ እምቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","ዮሴፎ ናናይ ምናሳነ ኤፍሬማ ጌተቲደ ላኡ ዛረ ግዴድኖ። ሙሴ ሌዊያ ዛረቶ ላታ ጋድያ እምቤና፤ ሽን ሄዋ ግሻዉ ኡንቱንቶ ደእያ ካታማቱዋነ ኡንቱንቱ ባረንቱ መህያ ዉድያነ ዶርሳ ዉድያ ሄምያ ሄንꬃ ጋደቱዋ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","መꬍና ጎዳይ ሙሳ አዛዜዳዋዳን፥ እስራኤልያ አሳይ ጋድያ ሻክ አኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","እት ጋላስ ይሁዳ አሳይ ኢያሱኮ ገልጋል ሺቄድኖ። ኡንቱንቱፐ እቱ፥ ቀኒዝያ ይፉነ ናአይ ካሌብ ኢያሳ ሀዋዳን ያጌዳ፤ “ኑን ቃዴሳ-ባርነን ደእያ ዎደ፥ መꬍና ጎዳይ፥ ጾሳ አሳ ግድያ ሙሴዉ ነባነ ታባ ኦዴዳዋ ኤራሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","መꬍና ጎዳ ቆማይ ሙሴ ጋድያ ዎቻደ ያናዳን፥ ቃዴሳ-ባርነፐ ታና ኪትያ ዎደ፥ ታዉ ላይꬃይ ኦይታማ። ሄ ዎደ ታን አዉ አማነትያ ኦዱዋ አሃደ ኦዳድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","ታን መꬍና ጎዳ ታ ጾሳ ፖሎ ካላድ፤ ሽን ታናና ቤዳ አሳቱ አሳ ዎዛና ያሻን ኮልድሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","ሄ ጋላስ ሙሴ፥ ‘ኔን መꬍና ጎዳ ታ ጾሳ ፖሎ ካሌዳ ድራዉ፥ ነ ገዲ የꬌዳ ቢታይ መꬍናዉ ነዉነ ነ ዛርያዉ ላትያ ጋድያ ግዳናዋ’ ጊደ ጫቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","“አነ አኬካ፤ መꬍና ጎዳይ ሀ የዉዋ ሙሴዉ ሃሳዮደፐ፥ ኦይታማነ እቼሹ ላይꬃ ግዴዳ። ሄ ዎደፐ እስራኤልያ አሳይ ዎራን ስመረትሽን፥ ሀቼ ጋካናዉ ጾሳይ ታና ፓጻ ዎꬄዳ። በአ፥ ሀእ ታ ላይꬃይ ሆስፑን ታማነ እቼሻ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","ግድናካ ሀእ ታዉ ደእያ ምኖተꬃይ በን ሙሴ ታና ኪትያ ዎደ ደእያ ምኖተꬃካ ማላ። ታን ሀእካ ኦለታናዉነ አያ ግዶፐነ ኦꬃናዉ በን ሄ ዎደዋዳን ዎልቃማ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","ሄዋ ድራዉ፥ መꬍና ጎዳይ ታዉ እማና ጌዳ ሀ ገዘ ጋድያ ሀእ ታዉ እማ። ሄ ዎደ፥ አናቀቱ ሄ ጋድያን ደእያዋነ ኡንቱንቱ ካታማቱካ ግታነ ግምበቴዳዋንታ ግድያዋ ኑን ሃሳይሽን ኔን ነ ሁጲያዉ ስሳዳ። ሽን መꬍና ጎዳይ ታናና ግዶፐ፥ እ ጌዳዋዳን፥ ታን ኡንቱንታ ሄ ጋድያፐ የደርሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","ሄዋፐ ጉየ ኢያሱ ይፉነ ናኣ ካሌባ አንጂደ፥ ከብሮና አዉ ላታ ኦꬂደ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","መꬍና ጎዳ እስራኤልያ ጾሳ ፖሎ ካሌዳ ድራዉ፥ ከብሮና ጋዲ ሄ ዎድያፐ ሀቼ ጋካናዉ፥ ቀኒዝያ ይፉነ ናኣ ካሌባዉ ላታ ቢታ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","ካሰ ከብሮና ሱንꬃይ ቅርያት-አርባአ ጌተቴ፤ አርባአ ግያ ብታኒ አናቀቱዋ ኡባፐ አꬌዳ አሳ። ሄዋፐ ጉይያን፥ ሄ ጋዲ ኦላፐ ሸምፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","ይሁዳ ዛረቶ ኡንቱንቱ ያራን ያራን ሻክና ጋኬዳ ጋዲ ቢደ ኤዶማ ጋድያን ዛዋቲደ፥ ገድሳ ባጋ ጋጻን ደእያ ጺና ግያ ባዙዋ ዉርሰꬃ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","ገድሳ ባጋና ኡንቱንቱ ዛዋይ ማጽነ አባፐ ገድሳ ባጋ ዉርሰꬃፐ ዶሚደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","አክራቢማ ፕኑዋ አꬊደ፥ ጽና ባዙዋና ቢደ፥ ቃዴሳ-ባርነ ገድሳ ጋኬ። ቃይ ሄዋፐ ሻክ ቢደ፥ ሄጽሮናና አꬊደ፥ ፑደ አዳራ ጋኪደ፥ ቃርቃኮ ስሜ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","ሄዋፐ ቃይ አጽሞና አꬊደ፥ ግብጼ ሻፋን ጋከት ቢደ፥ ሜድትራነ አባን ዛዋቴ። ገድሳ ባጋና ደእያ ይሁዳ ዛዋይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","አዋይ ዶልያ ባጋ ዛዋይ ማጽነ አባ ግዲደ፥ ዮርዳኖሳ ሻፋይ አን ገልያ ሳኣ ጋኬ። ሁጲሳ ዛዋይ ቃይ ዮርዳኖሳ ሻፋ ማጽነ አባን ገልያ ሳፐ ዶሚደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","ፑደ ቤት-ሆግላ ከሲደ፥ ቤት-አራብያ ዛንጋራፐ ሁጲሳና አꬊደ፥ ሮቤላ ናኣ ቦሃና ሹቻን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","ያቲደ ዛዋይ አሁረ (መቱዋ) ዎምባፐ ዳቢራ ካታማ ፑደ ከሲደ፥ ዎምባፐ ገድሳ ባጋና ደእያ አዱሚማ ፕኑዋ ስንꬃ ባዙዋን ደእያ ገልጋላኮ ሁጲያዉ ምርቀቴ። ሄዋፐ ቃይ ኤንሸሜሻ ግያ ፑልትያ አꬊደ፥ ኤንሮጌላ ግያ ሳን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","ሄዋፐ ህኖማ ዛንጋራ አꬊደ፥ ያቡሳዋናቱዋ ካታማይ የሩሳላመ ደእያ ደርያፐ ገድሳ ባጋና አꬊደ፥ ደርያ ሁጲያ ከሴዳ፤ ሄ ደሪ ህኖማ ዛንጋራፐ አዋይ ዉልያ ባጋናነ ራፋይማ ዎምባፐ ሁጲሳ ባጋና ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","ሄ ደርያ ሁጲያፐ ስንꬃዉ ቢደ፥ ነፍቶሀ ሃꬃ ፑልትያ አꬊደ፥ ኤፍሮና ደርያን ደእያ ካታማቱዋኮ ከሴዳ። ሄዋፐ ቃይ ዱገ ባኣላ ዎይ ቅርያት-ይኣሪማ ጌተትያ ካታማኮ ስሜ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","ባኣላፐ ቃይ አዋይ ዉልያ ባጋና ደእያ ሰኢራ ደርያኮ ምርቀቴ። ሄዋፐ ቃይ ሁጲሳ ባጋ ይኣሪማ ዎይ ክሳሎና ጌተትያ ደርያ ጋኪደ፥ አፐ ዱገ ቤት-ሸመሻ ዎꬊደ፥ ትምና አꬊደ ቤ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","ሄ ዛዋይ ኤቅሮና ሁጲሳ ባጋና ደእያ ፑደꬃን ዛዋቲደ፥ ሽካሮናኮ ምርቀቴ፤ ሄዋፐ ባኣላ ደርያና አꬊደ፥ ያብንኤላን ዛዋቴ። ሄ ሁጲሳ ባጋ ዛዋይ ሜድትራነ አባን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","አዋይ ዉልያ ባጋና ደእያ ዛዋይ ሜድትራንያ አባዉ ጋጻን ዛዋቴ። ይሁዳ ዛራቱ ባረንቱ ያራን ያራን አኪደ ደኤዳዌ ሀ ዛዋቱ ዛርና ደእያ ሳአቱዋና። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","መꬍና ጎዳይ አ አዛዜዳዋዳን፥ ኢያሱ ይፉነ ናኣ ካሌባ ጋክያ ግሹዋ ይሁዳ ጋድያፐ ቅርያት-አርባአ ጌተትያ ከብሮና እሜዳ። አርባእ አናቀ አዉዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","ካሌብ አናቀ ዘረꬃ፥ ሸሻያ፥ አህማናነ ታልማያ ጌተትያ ሄዙ ያራቱዋ ከብሮናፐ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","ሄዋፐ ደንዲደ፥ ዳቢራ ግያ ካታማን ደእያ አሳ ኦላናዉ ቤዳ፤ ዳቢራ ካታማይ ካሰ ቅርያት-ሰፈራ ጌተቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","ካሌብ፥ “ቅርያት-ሰፈራ ኦለቲደ ኦይቂያ ኡራዉ ታን ታ ናቶ አክሶ እማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","ካሌባ እሻ ቃናዛ ናአይ ኦትንኤል ሄ ካታማ ኦለቲደ ኦይቂና ካሌብ ባረ ናቶ አክሶ አዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","አክሳ ኦትንኤላ ገልያ ዎደ፥ እዝ አቡ እዝዉ ጋድያ እማናዳን ዎሳና ማላ ኦትንኤል እዞ ዞሬዳ። እዛ ባቁሉዋፐ ዎꬋዱ፤ ካሌብ እዞ፥ “አያ ኮያይ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","እዛ፥ “ታዉ ዎይቱዋ እማ። ኔን ካሰ ታዉ ነጌበን እሜዳ ቢታይ ግዴዳ ድራዉ፥ ሃꬃ ፑልቶቱዋ ታዉ እማርኪ” ያጋዱ። ካሌብ እዝዉ ክል ፑልቱዋካ ህርክ ፑልቱዋካ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","ይሁዳ ዛራቱ ባረንቱ ያራን ያራን ላቴዳ ላታቱ ሀዋፐ ካሊደ ጻፈቴዳዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","ገድሳ ባጋ ጋጻን ኤዶማ ዛዋ ማታን ደእያ ይሁዳ አሳ ካታማቱ ቃብጽኤላ፥ ኤዴራ፥ ያጉራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","ቂና፥ ድሞና፥ አድኣዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","ቀዴሻ፥ ሀጾራ፥ ይትናና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","ዚፋ፥ ጸለማ፥ ባኣሎታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","ሀጾር-ሀዳታ፥ ቅርዮት-ሄጽሮና ዎይ ሀጾራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","አማማ፥ ሻማአ፥ ሞላዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","ሀጻር-ጋዳ፥ ሄሽሞና፥ ቤት-ጳሌጻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","ሀጻር-ሹኣላ፥ በርሳቤሀ፥ ቢዝዮትያ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","ባኣላ፥ ኢዩማ፥ ኤጼማ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","ኤልቶላዳ፥ ካሲላ፥ ሆርማ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","ጽቅላጋ፥ ማድማና፥ ሳንሳና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ለባዎታ፥ ሽልሂማ፥ አይናነ ርሞና። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ላታማነ ኡዱፑና። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","ጋꬋን ደእያ ካታማቱ ኤሽታኦላ፥ ጾርአ፥ አሺና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","ዛኖሀ፥ ኤንጋኒማ፥ ታፑሀ፥ ኤናማ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","ያርሙታ፥ አዱላማ፥ ሶኮ፥ አዜቃ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ሻእራይማ፥ አድታይማ፥ ጋዴራነ ጋደሮታይማ። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ታማነ ኦይዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","ቃይ ይሁዳ ካታማቱ ጽናና፥ ሀዳሻ፥ ምግዳላ-ጋዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","ዲልኣና፥ ምስጳ፥ ዮቅትኤላ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","ላክሻ፥ ቦጽቃታ፥ ኤግሎና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","ካቦና፥ ላህማሳ፥ ክትሊሻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","ጋደሮታ፥ ቤት-ዳጎና፥ ናእማናነ ማቄዳ። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ታማነ ኡሱፑና። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","ቃይካ ሊብና፥ ኤቴራ፥ አሻና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ይፍታሀ፥ አሺና፥ ናጺባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","ቃኢላ፥ አክዚባነ ማሬሻ። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ኡዱፑና። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","ሄዋዳንካ፥ ቃይ ኤቅሮና ካታማ ባረ ሄራን ደእያ ቄር ካታማቱዋነ ሞꬃቱዋ ኡባ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","አሽዶዳ ኤለካ ኤቅሮናፐ ቢደ፥ ሜድትራንያ አባ ጋካናዉ ደእያ ካታማቱዋነ ኡንቱንቱ ሞꬃቱዋ ኡባ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","ቃይ አሽዶዳ ካታማነ አ ሞꬃቱዋ፥ ጋዛ ካታማነ አ ሞꬃቱዋ፥ ቢደ ግብጼ ሻፋነ ሜድትራንያ አባ ላንቂያ ጋካናዉ ደእያ ሳኣ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","ገዝያን ደእያ ካታማቱካ ሻሚራ፥ ያትራ፥ ሶኮ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","ዳና፥ ቅርያት-ሳና ዎይ ዳቢራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","አናባ፥ ኤሽታሞአ፥ አኒማ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","ጎሸና፥ ሆሎናነ ጊሎ። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ታማነ እታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","ቃይ አራባ ካታማ፥ ዱማ፥ ኤሽኣና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","ያኒማ፥ ቤት-ታፑሀ፥ አፌቃ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","ሁምጻ፥ ከብሮና ዎይ ቅርያት-አርባአነ ጽኦራ። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ኡዱፑና። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","ቃይካ ማኦና፥ ቃርመሎሳ፥ ዚፋ፥ ዩጻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","እዝራኤላ፥ ዮቅድኣማ፥ ዛኖሀ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","ቃይና፥ ግብአነ ትምና። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ታማ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","ቃይ ሀልሁላ፥ ቤትጹራ፥ ጋዶራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","ማእራታ፥ ቤት-አኖታነ ኤልትቆና። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ኡሱፑና። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","ሄዋዳንካ ቃይ ቅርያት-ባኣላ ዎይ ቅርያት-ይኣሪማነ ራባ። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ላአ። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","ዎራን ቃይ ቤት-አራባ፥ ምዲና፥ ሰካካ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","ንብሻና፥ ማጽነ ካታማነ ኤንጋዳ። ሀ ካታማቱ ባረንቱ ሞꬃቱዋና እትፐ ኡሱፑና። ");
INSERT INTO dwrENT_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","ግዶፐነ፥ ይሁዳ አሳይ የሩሳላመን ደእያ ያቡሳቱዋ ከሳናዉ ዳንዳይበይክኖ። ሄዋ ድራዉ ያቡሳዋናቱ ሀቼ ጋካናስካ ይሁዳ አሳና እትፐ የሩሳላመን ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","ዮሴፎ ዘረꬃቱዋ ጋኬዳ ቢታይ ገድሳ ባጋና ያርኮ ካታማ ማታን ደእያ ዮርዳኖሳ ሻፋን ዶሜ፤ ያርኮ ፑልቶቱዋፐ አዋይ ዶልያ ባጋ ጋጻፐ ደንድ ቢደ፥ ባዙዋ አꬊደ፥ ገዝያ ፑደ ከሲደ፥ ቢደ ቤቴለ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","ቤቴለፐ ደንዲደ፥ አርከቱዋ ጋድያን ደእያ አጻሮታ ካታማ አꬊደ፥ ሎዛ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","ሄዋፐ አዋይ ዉልያ ባጋ ያፍሌጻቱ ጋድያ ዱገ ዎꬊደ፥ ህርክ ቤት-ሆሮና ግያ ሳና አꬊደ፥ ሄዋፐ ገዜራና ቢደ፥ ሜድትራነ አባን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","ዮሴፎ ዘረꬃ ግድያ ምናሰ ዛራቱነ ኤፍሬማ ዛራቱ ባረና ጋክያ ጋድያ ላቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","ኤፍሬማ ዘረꬃ ኡንቱንቱ ያራን ያራን ጋኬዳ ቢታይ ሀዋ፤ ኡንቱንታ ጋኬዳ ጋድያ ዛዋይ አዋይ ዶልያ ባጋና ደእያ አጻሮት-አዳራፐ ደንዲደ፥ ቆሙዋ ቤት-ሆሮና አꬌ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","ሄዋፐ ስሚደ ሜድትራንያ አባን ዛዋቴ። ቃይ ሁጲሳ ባጋና ደእያ ዛዋይ ምክማታታፐ አዋይ ዶልያ ባጋ ታአናት-ሺሎኮ ስሚደ፥ አዋይ ዶልያ ባጋና ደእያ ያኖሀ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","ያኖሀፐ ዱገ አጻሮታነ ናአራታ ዎꬊደ፥ ያርኮ ጋኬ፤ ዉርሰꬃይ ዮርዳኖሳ ሻፋን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","ጋጻ ዛዋይ ታፑሀፐ ዶሚደ ቢደ፥ አዋይ ዉልያ ባጋና ደእያ ቃና ሻፋ ባዙዋ ኦይቂደ ቢደ፥ ሜድትራንያ አባን ዛዋቴ። ኤፍሬማ ዛራቱ ባረንቱ ያራን ያራን ላቴዳ ቢታይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","ሄዌ ምናሰ ዛራቱዋ ጋድያፐ ኤፍሬማ ዛረቶ እሜዳ ካታማቱዋነ ኡንቱንቱ ሞꬃቱዋ ኡባ ጉጀናን ደእሺና። ");
INSERT INTO dwrENT_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","ሽን ኤፍሬማ ዛራቱ ገዜራ ካታማን ደእያ ካናነ አሳቱዋ ከስበይክኖ። ያትና፥ ካናነ አሳቱ ሀቼ ጋካናዉ ኤፍሬማ ዛራቱዋ ግዶን ደኢኖ። ሽን ኤፍሬማ ዛራቱ ኡንቱንቱ አይለዪደ ኦስሲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","ዮሴፎ ባይራ ናኣ ምናሰ ዛረቶ እመቴዳ ቢታይ ሀዋ። ጋላኣደ አዉ ማኪር ምናሰዉ ባይራ ናኣ፤ ማኪና ያራቱ ምኖ ኦላንቻ ግዴዳ ድራዉ፥ ጋላኣደነ ባሳነ ቢታቱዋ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","ዮርዳኖሳ ሻፋፐ አዋይ ዉልያ ባጋና ደእያ ቢታይ የንኩዋ አቴዳ ምናሰ አሳዉ እመቴዳ፤ ሄ ያራቱካ አብኤዘራ፥ ሄሌቃ፥ አስርኤላ፥ ሸኬማ፥ ሄፌራነ ሻምዳአ። ዮሴፎ ናኣ ምናሰ ያራ ግድያ አቱማዋንቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","ጻሎፍሃድ ሄፌራ ናኣ፤ ሄፌር ጋላኣደ ናኣ፤ ጋላኣደ ማኪና ናኣ፤ ማኪር ምናሰ ናኣ። ጻሎፍሃዳዉ ማጫ ናናቱዋፐ አትና፥ አቱማ ናናይ ባዋ፤ አ ማጫ ናናይ ማህሎ፥ ኖኦ፥ ሆግሎ፥ ምልኮነ ትርጾ ጌተትኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","ኡንቱንቱ ቄስያ ኤልኣዛራኮ፥ ነዌ ናኣ ኢያሱኮነ ካፓቱዋኮ ሺቂደ፥ “ኑ ዳባቱ ግዶን ኑዉካ ጋድያ ግሹዋን እማና ማላ መꬍና ጎዳይ ሙሳ አዛዝ ዎꬄዳተነ” ያጌድኖ። ሄዋፐ ጉየ መꬍና ጎዳይ አዛዜዳዋዳን፥ ኡንቱንቱ አዉዋ እሻቱዋ ግዶን ኡንቱንቶካ ጋድያ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","ምናሰ ያራቱ ዮርዳኖሳ ሻፋፐ አዋይ ዶልያ ባጋና ደእያ ጋላኣደነ ባሳነ ቦላ ጉጂደ፥ ታሙ ሳማ ጋድያ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","አያዉ ጎፐ፥ ምናሰ ዛራቱዋፐ ማጫ ናናይካ አቱማ ናናቱዋና እትፐ ሻክ አኬድኖ። ጋላኣደ ጋዲ አቴዳ ምናሰ ያራቱዋሳ ግዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","ምናሰ ያራቱ ጋድያ ዛዋይ አሴራ ጋድያፐ ዶሚደ፥ ሰኬማፐ አዋይ ዶልያ ባጋና ደእያ ምክማታታ ጋኬ። ሄ ዛዋይ ሄዋፐ ደንድ ቢደ፥ ገድሳ ባጋና ደእያ ታፑሀ አሳይ ደኢያሳ ጻጽ ዋጼ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","ታፑሀ ቢታይ ምናሰሳ፤ ሽን ምናሰ ዛዋን ደእያ ታፑሀ ካታማይ ባረ ሁጲያዉ ኤፍሬማ ዛራቱዋሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","ቃይ ሄ ዛዋይ ሄዋፐ ደንድ ቢደ፥ ቃና ሻፋን ዛዋቴ። ምናሰ ካታማቱዋ ግዱዋን ኤፍሬማሳ ግድያ ካታማቱካ ደኢኖ፤ ሽን ምናሰ ዛዋይ ቃና ሻፋፐ ሁጲሳ ባጋ ግዲደ፥ ቢደ ሜድትራንያ አባን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","ሻፋፐ ገድሳ ባጋና ደእያ ቢታይ ኤፍሬማሳ፤ ሁጲሳ ባጋና ደእያ ቢታይ ቃይ ምናሰሳ። ምናሰ ቢታዉ አዋይ ዉልያ ባጋ ዛዋይ ሜድትራነ አባ። ቃይ ሁጲሳ ባጋና አሴራ ጋድያ፥ አዋይ ዶልያ ባጋና ይሳኮራ ጋድያ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","ይሳኮራነ አሴራ ቢታቱዋ ግዱዋን ቤትሻና፥ ይብላኣማ፥ ዶራ፥ ኤንዶረ፥ ታእናካነ ማግዶ ጌተትያ ካታማቱ ባረንቱ ዩሹዋን ደእያ ሞꬃቱካ ምናሰሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","ሽን ምናሰ ዛራቱ ሄ ካታማቱዋን ደእያ አሳቱዋ ከሳናዉነ ካታማቱዋ ኦይቃናዉ ዳንዳይበይክኖ። ሄዋ ድራዉ ካናነ አሳቱ ያን ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","እስራኤልያ አሳይ ምኔዳ ዎደ፥ ካናነ አሳቱዋ ዎልቃን ሀጋዝስያዋፐ አትና፥ ኡንቱንቱ ጋድያፐ ኡባይ ከስበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","ዮሴፎ ዛራቱ ቢደ ኢያሳ፥ “ቢታ ላታ ግሹዋን ኑዉ አያዉ እት ሳማ ጻላላ እማድ? ኑን ፓይዱዋን ጮራ፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ኑና አንጄዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","ኢያሱ ኡንቱንታ፦ “ህንተንቱ ጮራ ግዶፐነ፥ ኤፍሬማ ገዚ ህንተንቶ ጉጾፐ፥ ፓርዘቱነ ራፋየቱ ደእያ ጋድያ ቢደ፥ ዎራ ህንተንቶ ቡꬅተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","ዮሴፎ ዛራቱ፥ “ሀ ገዚ ኑ ግደና፤ ሄዋ ቦላካ ቃይ ቤትሻና ካታማን፥ አ ዩሹዋን ደእያ ሞꬃቱዋንነ እዝራኤላ ዎምባን ደእያ ካናነቶ ፓራቱ ጎችያ ብራታ ጋረቱ ደኢኖ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","ኢያሱ ዮሴፎ ናና ኤፍሬማነ ምናሰ ዛረቶ፥ ሀዋዳን ያጌዳ፤ “ህንተንቱ ጮራነ ዳሮ ዎልቃማ፤ ህንተንቶ እት ሳማ ጻላላይ ግደና። ");
INSERT INTO dwrENT_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","ሄዋ ድራዉ ገዘ ቢታካ ህንተንቱ አካና። ሄ ገዘ ዎራ ግዶፐነ ቡꬂደ ዉርሰꬃ ጋጻ ጋካናዉካ ህንተሳ ኦꬅተ። ካናነቶ ፓራቱ ጎችያ ብራታ ጋረቱ ደኦፐካ፥ ኡንቱንቱ ምኖ ግዶፐነ፥ ህንተንቱ ኡንቱንታ ከሳናዉ ዳንዳዪታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","ቢታ ጾኒደ ኦይቄዳዋፐ ጉይያን፥ እስራኤልያ ማባራ ኡባይ ሴሎን ሺቂደ ጾሳዉ ጎይንያ ዱንካንያ ያን ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","ሽን እስራኤልያ አሳፐ ጋድያ ሻክ አክቤና ላፑን ዛራቱ አቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","ኢያሱ እስራኤልያ አሳ፥ “መꬍና ጎዳይ ህንተንቱ አዎቱዋ ጾሳይ ህንተንቶ እሜዳ ጋድያ ላተናን አዉደ ጋካናዉ ጋምአንቴ? ");
INSERT INTO dwrENT_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","እት እት ዛርያፐ ሄዙ ሄዙ አሳቱዋ ዶርተ። እት እት ዛሪ ላታና ጋድያ ሀኖታ ኤራናዳን፥ ታን ኡንቱንታ ኪታና። ኡንቱንቱ ጋድያ ኡባ ቢደ ጌዲደ ሄ ቢታባ ጻፍ አኪደ፥ ታኮ ስም ያናዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","ኡንቱንቱ ሄ ጋድያ ላፑኑዋ ከሲደ ሻካና። ሽን ይሁዳ ዛራቱ ገድሳ ባጋና ደእያ ባረንቱ ጋድያን፥ ዮሴፎ ዛራቱካ ሁጲሳ ባጋና ደእያ ባረንቱ ጋድያን ደአና። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","ሀ ላፑኑዋ ከስ ሻከቴዳ ጋድያ ሀኖታ ጻፌዳዋፐ ጉይያን፥ ታኮ አኪደ ዪና ታን መꬍና ጎዳ ኑ ጾሳ ስንꬃን ህንተንቶ ሳማ የጋና። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","ግዶፐነ፥ ሌዊያ ዛራቱ ህንተናና ሳማን ላትክኖ፤ አያዉ ጎፐ፥ ኡንቱንቱ ቄሳቱዋ ግዲደ መꬍና ጎዳዉ ኦꬅያ ኪታይ ኡንቱንቱ ላታ። ጋደ ዛራቱ ሮቤላ ዛራቱነ ምናሰ ዛራቱዋፐ ባጋይ ዮርዳኖሳ ሻፋፐ አዋይ ዶልያ ባጋና፥ መꬍና ጎዳ ቆማይ ሙሴ ኡንቱንቶ እሜዳ ጋድያ ካሰት ላቴድኖ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","አሳቱ ጋድያ ሀኖታ ጻፋናዉ ባናፐ ካሰቲደ፥ ኢያሱ ኡንቱንታ፥ “ቢተ፤ ዩይ በኤዳዋ ጻፍተ። ያቲደ ታኮ ስም ዪተ። ሀዋን ሴሎን መꬍና ጎዳ ስንꬃን ታን ህንተንቶ ሳማ የጋና” ያጊደ አዛዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","አሳቱ ቢደ፥ ቢታ ኡባ ዩዬድኖ። ካታማቱዋ ኡባ ጻፊደ፥ ጋድያ ዋቲደ ላፑኑዋ ከስ ሻካነንቶ ኤርሴድኖ። ያቲደ ኢያሱ ዱንካኔዳ ሳኣ ሴሎ ስሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","ሄዋፐ ጉይያን ኢያሱ መꬍና ጎዳ ስንꬃን ሴሎን ኡንቱንቶ ሳማ የጌዳ፤ ያን ኢያሱ እስራኤልያ አሳዉ ጋድያ ኡንቱንቱ ዛርያ ግሹዋዳን ሻክ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","ኮይሮ ሳማይ ቢንያማ ዘረꬃ ኡንቱንቱ ያራን ያራን ጋኬዳ። ኡንቱንታ ጋኬዳ ቢታይ ይሁዳ ዛራቱዋ ቢታፐነ ዮሴፎ ዛራቱዋ ጋድያፐ ግዱዋን ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","ሁጲሳ ባጋና ኡንቱንቱ ዛዋይ ዮርዳኖሳ ሻፋፐ ዶሚደ፥ ያርኮፐ ሁጲሳ ባጋና ደእያ ፑደꬃን ዛዋቴ፤ ሄዋፐ አዋይ ዉልያ ባጋና ገዝያ አꬊደ፥ ቤት-አዌና ዎራን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","ሄዋፐ ገድሳ ባጋ ስሚደ፥ ካሰ ሎዛ ጌተትያ ቤቴለ ፑደꬃ አꬊደ፥ አጻሮት-አዳራ ዱገꬃ አꬊደ፥ ህርክ ቤት-ሆሮናፐ ገድሳ ባጋን ደእያ ደርያን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","ሄ ዛዋይ ገድሳ ባጋና ቤት-ሆሮና ስንꬃን ደእያ ደርያፐ አዋይ ዉልያ ባጋ ምርቀቲደ፥ ቅርያት-ባኣላ ዎይ ቅርያት-ይኣሪማ ጌተትያ ይሁዳ ዛራቱዋ ካታማን ዛዋቴ። አዋይ ዉልያ ባጋና ደእያ ዛዋይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","ገድሳ ባጋ ዛዋይ ቅርያት-ይኣሪማፐ ደንዲደ፥ ነፍቶሀ ሃꬃ ፑልታቱዋን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","ሄዋፐ ዛዋይ ዱገ ቢደ ራፋይማ ዛንጋራፐ ሁጲሳ ባጋን ደእያ ህኖማ ዛንጋራፐ ስንꬃ ባጋ ደርያ ገድሳና ዛዋቴ። ሄዋፐ ህኖማ ዛንጋራ አꬊደ ቢደ፥ ያቡሳዋናቱዋ ካታማ የሩሳላመዉነ ኤንሮጌላ ካታማ ገድሳ ባጋ ፑደꬃን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","ሄዋፐ ቃይ ሁጲሳ ባጋ ኤንሸሜሻኮ ምርቀቲደ፥ አዱሚማ ፑደꬃፐ ስንꬃ ባጋና ደእያ ጋልሎታን ዛዋቴ፤ ሄዋፐ ቃይ ሮቤላ ናኣ ቦሃና ሹቻዉ ዱገ ዎꬌ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","ሄዋፐ ቃይ ቤት-አራባ ሁጲሳ ባጋ ፑደꬃና አꬊደ፥ ዱገ አራብያ ዛንጋራ ዎꬌ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","ቤት-ሆግላ ፑደꬃፐ ሁጲሳ ባጋና አꬊደ፥ ዮርዳኖሳ ሻፋይ ጎጊደ ገልያሳ፥ ማጽንያ አባፐ ሁጲሳ ባጋ ጋጻ ጋኬ። ሄዌ ገድሳ ባጋ ዛዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","አዋይ ዶልያ ባጋና ደእያ ዛዋይ ዮርዳኖሳ ሻፋ። ቢንያማ ዛራቱ ላቴዳ ቢታይ ኡባ ሳናካ ዛዋቴዳ ዛዋቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","ቢንያማ ዛራቱ ባረንቱ ያራን ያራን አኬዳ ካታማቱ ያርኮ፥ ቤት-ሆግላ፥ ኤመቅ-ቃጺጻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","ቤት-አራባ፥ ጻማራይማ፥ ቤቴለ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","አዊማ፥ ፓራ፥ ኦፍራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","ካፋር-አሞና፥ ኦፍናነ ገባአ። ኡንቱንቱ ኡባና ታማነ ላአ፤ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱካ ኡንቱንቱን ጉጀቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","ቃይ ጋባኦና፥ ራማ፥ ባኤሮታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","ምጽጳ፥ ካፊራ፥ ሞጻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","ረቄማ፥ ይርጳኤላ፥ ታራላ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","ጸላአ፥ ኤሌፋ፥ የሩሳላመ ጌተትያ ያቡሳዋናቱዋ ካታማ፥ ግብአነ ቅርያት-ይኣሪማ። ኡንቱንቱ ኡባና ታማነ ኦይዳ፤ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱካ ኡንቱንቱን ጉጀቲኖ። ቢንያማ ዛራቱ ባረንቱ ያራን ያራን ላቴዳ ቢታይ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","ላኤንꬆ ሳማይ ስሞና ዘረꬃ ኡንቱንቱ ያራን ያራን ጋኬዳ። ኡንቱንታ ጋኬዳ ቢታይ ይሁዳ ዛራቱ ላቴዳ ጋድያ ግዱዋን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","ኡንቱንቱ ላቴዳ ካታማቱ በርሳበሀ ዎይ ሸባአ፥ ሞላዳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","ሀጻር-ሹኣላ፥ ባላ፥ ኤጼማ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ኤልቶላዳ፥ ባቱላ፥ ሆርማ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","ጽቅላጋ፥ ቤት-ማርካቦታ፥ ሀጻር-ሱሳ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","ቤት-ላባኦታነ ሻሩሄና። ኡንቱንቱ ኡባና ታማነ ሄዛ፤ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱ ኡንቱንቱን ጉጀቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","ቃይ አይና፥ ርሞና፥ ኤቴራነ አሻና። ኡንቱንቱ ኡባና ኦይዱ ካታማቱዋ፤ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱካ ኡንቱንቱን ጉጀቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","ኔጌባ ዎራን ደእያ ባእላት-ባኤራ ዎይ ራማ ጋካናዉ፥ ሀ ካታማቱዋ ዩሹዋን ደእያ ሞꬃቱዋ ኡባ ላቴድኖ። ስሞና ዛራቱ ባረንቱ ያራን ያራን ላቴዳ ጋዲ ሀዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","ይሁዳ ዘረꬃ ጋኬዳ ቢታይ ኡንቱንቶ አኩዋ ዳሬዳ ድራዉ፥ አፐ ሻክና ስሞና ዛረቶ እመቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","ሄዘንꬆ ሳማይ ዛብሎና ዘረꬃ ኡንቱንቱ ያራን ያራን ጋኬዳ። ኡንቱንቱ ላቴዳ ጋዲ ሳሪዳ ግያ ካታማ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","ሄዋፐ ቃይ አዋይ ዉልያ ባጋ ቢደ ማርእላ አꬍ፥ ቢደ ዳባሼታ ቦቺደ ቢደ፥ ዮቅናኣማፐ አዋይ ዶልያ ባጋን ደእያ ሻፋ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","ሀራ ባጋና ቃይ ሳሪዳ ካታማፐ አዋይ ዶልያ ባጋ ስሚደ፥ ክስሎት-ታቦራ ጋኪደ፥ ዳብራታንነ ያፍአን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","ሄዋፐ ቃይ አዋይ ዶልያ ባጋና ጋተ-ሄፌራ፥ ኢት-ቃጺናነ ርሞና ጋኪደ፥ ኔአኮ ምርቀቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","ሁጲሳ ባጋና ዛዋይ ሀናቶና ስሚደ፥ ይፍታህኤላ ዛንጋራን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","ያን ቃጻታ፥ ናህላላ፥ ሽምሮና፥ ይዳላነ ቤተሌመ ጌተትያ ካታማቱካ ደኢኖ። ኡንቱንቱ ኡባና ታማነ ላአ፤ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱካ ኡንቱንቱን ጉጀቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","ዛብሎና ዛራቱ ባረንቱ ያራን ያራን ላቴዳ ጋድያ ግዶን ደእያ ካታማቱነ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","ኦይደንꬆ ሳማይ ይሳኮራ ዘረꬃ ኡንቱንቱ ያራን ያራን ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","ኡንቱንቱ ጋድያ ካታማቱ እዝራኤላ፥ ካሱሎታ፥ ሹኔማ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","ሀፋራይማ፥ ሽኦና፥ አናሀራታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","ራቢታ፥ ቅሽዮና፥ አቤጻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","ረሜታ፥ ኤንጋኒማ፥ ኤንሃዳነ ቤት-ጳጼጻ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","ሄ ጋድያ ዛዋይ ታቦራ፥ ሻሀጹማነ ቤት-ሸመሻ ቦቺደ ቢደ፥ ዮርዳኖሳ ሻፋን ዛዋቴ። ኡንቱንቱ ኡባና ታማነ ኡሱፑና፤ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱካ ኡንቱንቱን ጉጀቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","ይሳኮራ ዛራቱ ባረንቱ ያራን ያራን ላቴዳ ጋድያ ግዶን ደእያ ካታማቱነ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","እቼሸንꬆ ሳማይ አሴራ ዘረꬃ ኡንቱንቱ ያራን ያራን ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","ኡንቱንቱ ጋድያ ካታማቱ ሄልቃታ፥ ሀላ፥ በጼና፥ አክሻፋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","አላመለካ፥ አምኣዳነ ምሽኣላ። አዋይ ዉልያ ባጋና ቃርመሎሳንነ ሽሆር-ልብናታን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","ቃይ አዋይ ዶልያ ባጋ ስም ቤት-ዳጎናኮ ምርቀቲደ፥ ዛብሎና ጋድያነ ይፍታህኤላ ዛንጋራ ቦች ቢደ፥ ቤት-ኤሜቃነ ናእኤላ ጋኬ። ቃይ ሁጲሳ ባጋና ካቡላ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","ሄዋፐ ቃይ ኤብሮና፥ ራሆባ፥ ሀሞናነ ቃና አꬊደ፥ ሲዶናን ዛዋቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","ሄዋፐ ቃይ ጋድያ ዛዋይ ራማ ስሚደ፥ ግምበቴዳ ጺሮሳ ካታማ ጋኬ። ሄዋፐ ቃይ ሆሳኮ ምርቀቲደ፥ ሜድትራነ አባን ዛዋቴ። ቃይ ማሀላባ፥ አክዚባ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ኡማ፥ አፌቃነ ራሆባ ጌተትያ ካታማቱካ ያን ደኢኖ። ኡንቱንቱ ኡባና ላታማነ ላኡዋ፤ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱካ ኡንቱንቱን ጉጀቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","አሴራ ዛራቱ ባረንቱ ያራን ያራን ላቴዳ ጋድያን ደእያ ካታማቱነ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","ኡሱፑንꬃ ሳማይ ንፍታሌማ ዘረꬃ ኡንቱንቱ ያራን ያራን ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","ኡንቱንቱ ዛዋይ ሄሌፋፐነ ዳእናኒማ ዎላፐ ዶሚደ፥ አዳም-ነቄባ፥ ያብንኤላነ ላቁማ አꬊደ ቢደ፥ ዉርሰꬃይ ዮርዳኖሳ ሻፋ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","ሄዋፐ ቃይ ዛዋይ አዋይ ዉልያ ባጋ አዝኖት-ታቦራኮ ምርቀቴ፤ ሄዋፐ ቃይ ሁቆቃ ስሚደ፥ ገድሳ ባጋና ዛብሎና ቢታንነ አዋይ ዉልያ ባጋና አሴራ ጋድያን ዛዋቲደ፥ አዋይ ዶልያ ባጋና ዮርዳኖሳ ሻፋ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","ግምበቴዳ ካታማቱ ጽዲማ፥ ጼራ፥ ሃማታ፥ ራቃታ፥ ክናሬታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","አዳማ፥ ራማ፥ ሀጾራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","ቀዴሻ፥ ኤድራአ፥ ኤንሀጾራ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ይርኦና፥ ምግዳልኤላ፥ ሆሬማ፥ ቤት-አናታነ ቤት-ሸመሻ። ኡንቱንቱ ኡባና ታማነ ኡዱፑና፤ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱካ ኡንቱንቱን ጉጀቲኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","ንፍታሌማ ዛራቱ ባረንቱ ያራን ያራን ላቴዳ ጋድያን ደእያ ካታማቱነ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","ላፑንꬃ ሳማይ ዳና ዘረꬃ ኡንቱንቱ ያራን ያራን ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","ኡንቱንቱ ላቴዳ ጋድያ ካታማቱ ጾርአ፥ ኤሽታኦላ፥ እርሸሜሻ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ሻአልቢማ፥ አያሎና፥ ይታላ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ኤሎና፥ ትምና፥ ኤቅሮና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ኤልታቀ፥ ግባቶና፥ ባእላታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","ይሁዳ፥ ባነባራቃ፥ ጋተ-ርሞና፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","መያርቆና፥ ራቆናነ ቃይ ዮጰ ካታማ ዩሹዋን ደእያ ሄራቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","ዳና ዛራቱ ጋድያ ላታናዉ እንጀተናዋ በኤዳ ዎደ፥ ቢደ ላይሻ ካታማ ኦለቲደ ጾኔድኖ፤ ጾኒደ ሄ ካታማን ደእያ አሳ ቃራ ማሻን ዎꬍ ዉርሲደ፥ ካታማ ባረንቱ አኪደ ያን ደኤድኖ። ሄ ካታማ ሱንꬃካ ላሚደ፥ ባረንቱ አዉዋ ዳና ሱንꬃን ዳና ጊደ ሱንꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","ዳና ዛራቱ ባረንቱ ያራን ያራን ላቴዳ ጋድያን ደእያ ካታማቱነ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱ ሀዋንታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","እስራኤልያ አሳይ ጋድያ ሻክ ዉርሴዳ ዎደ፥ ነዌ ናኣ ኢያሱ ላትያ ጋድያ ባረንቱ ግዶን እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","መꬍና ጎዳይ አዛዜዳዋዳን፥ ኢያሱ ኦችና፥ ኤፍሬማ ገዝያን ደእያ ትምናት-ሰራሀ ጌተትያ ካታማ አዉ እምና ካታማ ዎꬅ የግ ኬጺደ፥ ያን ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","ቄስያ ኤልኣዛረ፥ ነዌ ናአይ ኢያሱነ እስራኤልያ አሳ ዛረቶ ያራቱ ካፓቱ መꬍና ጎዳ ስንꬃን ሴሎን፥ መꬍና ጎዳ ዱንካንያ ፐንግያን ሳማ የጊደ፥ ግሼዳ ላታ ጋዲ ሀዋ። ኡንቱንቱ ጋድያ ያት ሻክ ፖሌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","ሄዋፐ ጉይያን መꬍና ጎዳይ ኢያሳ ሀዋዳን ያጌዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“እስራኤልያ አሳዉ ሀዋዳን ያጋ፤ ‘ታን ሙሴ ባጋና ህንተንታ አዛዜዳዋዳን፥ አሳይ ባቃት ቢደ አትያ ካታማቱዋ ዶርተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","አይ አሳይነ አኬከናንነ ኤረናን አሳ ዎꬎፐ፥ ያ ባቃት ቢደ፥ ሱꬃ አችያዋፐ አታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","አሳ ዎꬌዳዌ ሄ ካታማቱዋፐ እቱዋኮ ባቃት ቢደ፥ ካታማ ገልያ ፐንግያን ኤቂደ፥ ሀኔዳባ ሄ ካታማ ጭማቶ ኦዶ። ኡንቱንቱ ባረንቱ ካታማ አፊደ፥ እ ደአና ሳኣ እምና፥ እ ኡንቱንቱና ያን ደኦ። ");
INSERT INTO dwrENT_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","ሱꬃ አችያዌ አ ካሊደ ዮፐ፥ ሄ ካታማ ጭማቱ አ አꬂደ እሞፕኖ። አያዉ ጎፐ፥ ባረ ሾሩዋ እ ቆፒደ፥ ባረ ካሰ ሞርከተꬃ ድራዉ ዎꬍቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","ሽቁዋ ስንꬃን ፕርዳዉ እ ኤቃና ጋካናሽ ሄ ዎድያን ደእያ ቄሳቱዋ ኡባቱዋ ካፑ ሀይቃና ጋካናዉ፥ ሄ ካታማን ደኦ። ሄዋፐ ጉይያን፥ ባቃቲደ ከሴዳ ካታማ ጉየ ዛሪደ፥ ባረ ሶ ገሎ’ ያጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","ሄዋፐ ጉየ እስራኤልያ አሳይ ንፍታሌማ ገዝያን፥ ጋሊላን ደእያ ቀዴሻነ አ ሄንꬃ ጋደቱዋ፥ ኤፍሬማ ገዝያን ደእያ ሰኬማነ አ ሄንꬃ ጋደቱዋነ ይሁዳ ገዝያን ደእያ ቅርያት-አርባአ ዎይ ከብሮነ ዱማዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","ዮርዳኖሳ ሻፋፐ ሄፍንꬃን፥ ያርኮፐ አዋይ ዶልያ ባጋ ዎራን፥ ꬎቃሳን ደእያ ሮቤላ ዛራቱዋ ጋድያፐ ቤጸራ፥ ጋደ ዛራቱዋ ጋድያፐ ጋላኣደን ደእያ ራሞታነ ምናሰ ዛራቱዋ ጋድያፐ ባሳነን ደእያ ጎላና ዱማዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","እስራኤልያ አሳ ኡባዉነ ኡንቱንቱ ግዶን ደእያ በተቶ ዱማዬዳ ካታማቱ ሀዋንታ፤ ኤረናን ደኢደ አሳ ዎꬌዳ አይ አሳይነ፥ ሽቁዋ ስንꬃን ኤቃና ጋካናዉ፥ ሱꬃ አችያዋ ኩሽያን ሀይቀናዳን፥ ሄ ካታማቱዋፐ እቱዋኮ ባቃታናዉ ዳንዳዬ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","ሄዋፐ ጉይያን ሌዊያ ዛራቱዋ ያራቱ ካፓቱ ቄስያ ኤልኣዛራኮ፥ ነዌ ናኣ ኢያሱኮነ እስራኤልያ አሳ ዛረቶ ያራቱ ካፓቱዋኮ ሺቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","ሄዋን ካናነ ጋድያን ደእያ ሴሎን ኡንቱንቱ ሀዋዳን ያጌድኖ፤ “ኑን ደአና ካታማቱዋነ ኑ መህያዉ ሄንꬃ ጋደቱዋ ኔን ኑ እማና ማላ መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","ሄዋፐ ጉየ መꬍና ጎዳይ አዛዜዳዋዳን፥ እስራኤልያ አሳይ ሌዊያ ዛረቶ ሀ ካታማቱዋነ ሄንꬃ ጋደቱዋ ባረንቱ ጋድያፐ ግሺደ ኡንቱንቶ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","ኮይሮ ሳማይ ቃሃታ ያራቶ ከሴዳ። ቄስያ አሮና ዛርያ ሌዋቱ ይሁዳ ዛራቱዋፐ፥ ስሞና ዛራቱዋፐነ ቢንያማ ዛራቱዋፐ ታማነ ሄዙ ካታማቱዋ ሳማን አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","አቴዳ ቃሃቱዋ ያራቱ ኤፍሬማ ዛራቱዋፐ፥ ዳና ዛራቱዋፐነ ምናሰ ዛራቱዋ ባጋፐ ታሙ ካታማቱዋ ሳማን አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","ገርሾና ያራቱ ይሳኮራ ዛራቱዋፐ፥ አሴራ ዛራቱዋፐ፥ ንፍታሌማ ዛራቱዋፐነ ባሳነን ደእያ ምናሰ ዛራቱዋ ባጋፐ ታማነ ሄዙ ካታማቱዋ ሳማን አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","ማራራ ያራቱ ሮቤላ ዛራቱዋፐ፥ ጋደ ዛራቱዋፐነ ዛብሎና ዛራቱዋፐ ታማነ ላኡ ካታማቱዋ አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","መꬍና ጎዳይ ሙሴ ባጋና አዛዜዳዋዳን፥ እስራኤልያ አሳይ ሀ ካታማቱዋነ ኡንቱንቱ ሄንꬃ ጋደቱዋ ሌዋቶ ሳማን ሻክ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","ይሁዳ ዛራቱዋፐነ ስሞና ዛራቱዋፐ እስራኤልያ አሳይ አኪደ እሜዳ ካታማቱዋ ሱንꬃይ ሀዋፐ ካሊደ ጻፈቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","ኮይሮ ሳማይ ሌዊያ ዛራቱዋፐ የለቲደ፥ ቃሃታ ያራ ግዴዳ አሮና ዛረቶ ከስና፥ ኡንቱንቶ እሜዳ ካታማቱ ሀዋንታ: ");
INSERT INTO dwrENT_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","እስራኤልያ አሳይ ይሁዳ ገዝያን ደእያ ቅርያት-አርባአ ዎይ ከብሮናነ አ ዩሹዋን ደእያ ሄንꬃ ጋደቱዋ ኡንቱንቶ እሜድኖ። (አርባእ አናቀ አዉዋ።) ");
INSERT INTO dwrENT_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","ሽን ሄ ካታማ ዩሹዋን ደእያ ጋደቱዋነ ሞꬃቱዋ ይፉነ ናኣ ካሌባዉ ላታ ኦꬂደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","ቄስያ አሮና ዛረቶ አሳ ዎꬌዳ አሳይ ባቃት ቢደ አትያ ከብሮነ ካታማነ አ ሄንꬃ ጋደቱዋ፥ ሊብናነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","ያትራነ አ ሄንꬃ ጋደቱዋ፥ ኤሽታሞአነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","ሆሎናነ አ ሄንꬃ ጋደቱዋ፥ ዳቢራነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","አይናነ አ ሄንꬃ ጋደቱዋ፥ ዩጻነ አ ሄንꬃ ጋደቱዋነ ቤት-ሸመሻነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኡዱፑን ካታማቱዋ ይሁዳ ዛራቱዋፐነ ስሞና ዛራቱዋፐ አኪደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","ቢንያማ ዛራቱዋፐ ጋባኦናነ አ ሄንꬃ ጋደቱዋ፥ ገባአነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","አናቶታነ አ ሄንꬃ ጋደቱዋነ አልሞናነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኦይዱ ካታማቱዋ አኪደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","አሮና ዛርያ ቄሳቱዋ ካታማቱነ ኡንቱንቱ ሄንꬃ ጋደቱ ኡባና ታማነ ሄዛ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","አቴዳ ቃሃታ ያራቱ፥ ሌዊያ ዛረ ግድያዋንቱ ኤፍሬማ ዛራቱዋ ካታማቱዋፐ ሻክና አኬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","ኡንቱንቶ ኤፍሬማ ገዝያን ደእያ፥ አሳ ዎꬌዳ አሳይ ባቃት ቢደ አትያ ሰኬማነ አ ሄንꬃ ጋደቱዋ፥ ገዜራነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","ቅብጻይማነ አ ሄንꬃ ጋደቱዋነ ቤት-ሆሮናነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኦይዱ ካታማቱዋ አኪደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","ዳና ዛራቱዋፐ ኤልታቀነ አ ሄንꬃ ጋደቱዋ፥ ግባቶናነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","አያሎናነ አ ሄንꬃ ጋደቱዋነ ጋተ-ርሞናነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኦይዱ ካታማቱዋ አኪደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","ምናሰ ዛራቱዋ ባጋቱዋፐ ታእናካነ አ ሄንꬃ ጋደቱዋነ ጋተ-ርሞናነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ላኡ ካታማቱዋ አኪደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","አቴዳ ቃሃታ ያራቱ ካታማቱነ ኡንቱንቱ ሄንꬃ ጋደቱ ኡባና ታማ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","ምናሰ ዛራቱዋ ባጋቱዋፐ አሳ ዎꬌዳ አሳይ ባቃት ቢደ አትያ፥ ባሳነን ደእያ ጎላና ካታማነ አ ሄንꬃ ጋደቱዋነ ባኤሽታራነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ላኡ ካታማቱዋ አኪደ፥ ገርሾና ያራ ግድያ ሀራ ሌዋቶ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","ይሳኮራ ዛራቱዋፐ ቅሽዮናነ አ ሄንꬃ ጋደቱዋ፥ ዳብራታነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","ያርሙታነ አ ሄንꬃ ጋደቱዋነ ኤንጋኒማነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኦይዱ ካታማቱዋ አኪደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","አሴራ ዛራቱዋፐ ምሽኣላነ አ ሄንꬃ ጋደቱዋ፥ አብዶናነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","ሄልቃታነ አ ሄንꬃ ጋደቱዋነ ራሆባነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኦይዱ ካታማቱዋ አኪደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","ሄዋዳንካ ንፍታሌማ ዛራቱዋፐ አሳ ዎꬌዳ አሳይ ባቃት ቢደ አትያ ጋሊላን ደእያ ቀዴሻነ አ ሄንꬃ ጋደቱዋ፥ ሀሞታነ አ ሄንꬃ ጋደቱዋ፥ ዶራነ አ ሄንꬃ ጋደቱዋነ ቃርታናነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኦይዱ ካታማቱዋ አኪደ፥ ኡንቱንቶ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","ገርሾና ያራቱ ካታማቱነ ኡንቱንቱ አ ሄንꬃ ጋደቱ ኡባና ታማነ ሄዛ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","35","አቴዳ ማራራ ያራ ግድያ ሌዋቶ ዛብሎና ዛራቱዋፐ አሳ ዎꬌዳ አሳይ ባቃት ቢደ አትያ ዮቅናኣማነ አ ሄንꬃ ጋደቱዋ፥ ቃርታነ አ ሄንꬃ ጋደቱዋ፥ ዲምናነ አ ሄንꬃ ጋደቱዋነ ናህላላነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኦይዱ ካታማቱዋ አኪደ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","ሮቤላ ዛራቱዋፐ ቤጸራነ አ ሄንꬃ ጋደቱዋ፥ ያሃጻነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","ቅደሞታነ አ ሄንꬃ ጋደቱዋነ መፋኣታነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኦይዱ ካታማቱዋ አኪደ፥ ኡንቱንቶ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","ቃይ ጋደ ዛራቱዋፐ አሳ ዎꬌዳ አሳይ ባቃት ቢደ አትያ፥ ጋላኣደን ደእያ ራሞታነ አ ሄንꬃ ጋደቱዋ፥ ማህናይማነ አ ሄንꬃ ጋደቱዋ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","ሀሰቦናነ አ ሄንꬃ ጋደቱዋነ ያእዜራነ አ ሄንꬃ ጋደቱዋ፥ ኡባና ኦይዱ ካታማቱዋ አኪደ፥ ኡንቱንቶ እሜድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","ማራራ ያራ ግድያ ሀራ ሌዋቶ ሻክና ጋኬዳ ካታማቱ ኡባና ታማነ ላአ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","እስራኤልያ አሳይ ላቴዳ ጋድያን ደእያ ሌዋቶ ኡባና ኦይታማነ ሆስፑን ካታማቱ ኡንቱንቱ ሄንꬃ ጋደቱዋና ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","ሄ ካታማቱዋ ኡባ ዩሹዋን ሄንꬃ ጋደቱ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","ሄዋዳን ኦꬂደ፥ መꬍና ጎዳይ ኡንቱንቱ አዋቶ እማናዉ ጫቄዳ ጋድያ ኡባ እስራኤልያ አሳዉ እምና ኡንቱንቱ ላቲደ፥ ያን ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","መꬍና ጎዳይ ኡንቱንቱ አዋቶ ጫቄዳዋዳን፥ ኡንቱንቱ ኡባ ባጋናካ ሸምፕሴዳ። መꬍና ጎዳይ ኡንቱንቱ ሞርከቱዋ ኡባ ኡንቱንቶ አꬅ እሜዳ ድራዉ፥ ኡንቱንቱ ሞርከቱዋፐ እቱነ ኡንቱንቱና ኤቀታናዉ ዳንዳይቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","መꬍና ጎዳይ እስራኤልያ አሳዉ እማና ጌዳ ሎኦ ቃላ ኡባ ፖሌዳፐ አትን እቱነ ሳኣን አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","ሄዋፐ ጉይያን ኢያሱ ሮቤላ ዘረꬃ፥ ጋደ ዛራቱዋነ ምናሰ ዛራቱዋፐ ባጋቱዋ ጼጊደ: ");
INSERT INTO dwrENT_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","“መꬍና ጎዳ ቆማይ ሙሴ ህንተንታ አዛዜዳ ኡባ ፖሌድታ፤ ቃይ ታዉካ ኡባባን አዛዘቴድታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","ዳሮ ዎድያፐ ሀቼ ጋካናዉ፥ ህንተንቱ ህንተንቱ እሻቱዋ ባሽበይክታ፤ መꬍና ጎዳይ ህንተንቱ ጾሳይ ህንተዉ እሜዳ ሀዳራ ፖሌድታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","ስም መꬍና ጎዳይ ህንተንቱ ጾሳይ ኡንቱንቶ ጌዳ ቃላዳን፥ ህንተንቱ እሻቱዋ ሸምፕሴዳ። ሄዋ ድራዉ፥ መꬍና ጎዳ ቆማይ ሙሴ ህንተንቶ ዮርዳኖሳ ሻፋፐ ሄፍንꬃ ባጋና እሜዳ ላታ ጋድያን ደእያ ህንተንቱ ሶ ሶ ስምተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","መꬍና ጎዳ ቆማይ ሙሴ ህንተንታ አዛዜዳ አዛዙዋነ ዎጋ ሎይꬅ ናግተ። መꬍና ጎዳ ህንተንቱ ጾሳ ሲቅተ፤ አ ኦግያ ኡባን ሀመትተ፤ አ አዛዙዋ አዛዘትተ፤ አናና ምን ኦይቀትተ፤ ህንተንቱ ኩመንꬃ ዎዛናፐነ ኩመንꬃ ሸምፑዋፐ አዉ ኦꬅተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","8","ኢያሱ ኡንቱንታ አንጅ የዲደ፤ “በእተ፥ ህንተንቱ ሀእ ዳሮ መህያ፥ ብራ፥ ዎርቃ፥ ናሃስያ፥ ብራታነ ዳሮ ማዩዋ አኪደ ዱረቲደ፥ ህንተንቱ ጋድያ ስማና ሀኒታ። ሄዋ ድራዉ ህንተንቱ ሞርከቱዋፐ ኦሞዴዳዋ፥ ህንተንቱ እሻቱዋና ግሽ አክተ” ያጌዳ። ሄዋፐ ጉይያን ኡንቱንቱ ባረንቱ ሶ ሶ ቤድኖ። ሙሴ ምናሰ ዛራቱዋፐ ባጋቶ ባሳነን ጋድያ እም ዎꬄዳ፤ ሽን አቴዳ ምናሰ ዛራቱዋ ባጋቶ ኢያሱ ዮርዳኖሳ ሻፋፐ አዋይ ዉልያ ባጋን ሀራ ዛራቱዋና እትፐ ላትያ ቢታ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","ሮቤላ ዛራቱ፥ ጋደ ዛራቱነ ምናሰ ዛራቱዋ ባጋቱ ባረንቱ ላታ ጋድያ ስሚደ ቤድኖ። ጾሳይ ሙሴ ባጋና አዛዝና ላቴዳ ጋላኣደ ጋድያ ባናዉ፥ ካናነ ጋድያን ሴሎን ደእያ እስራኤልያ አሳፐ ሻከቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","ሮቤላ ዛራቱ፥ ጋደ ዛራቱነ ምናሰ ዛራቱዋፐ ባጋቱ ዮርዳኖሳ ሻፋ ማታን ካናነ ጋድያን ደእያ ጋልሎታ ዬዳ ዎደ፥ ሻፋ ማታን ያርሹዋ ያርሽያ ዎልቃማ ሳኣ ");
INSERT INTO dwrENT_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","ግምቢና፥ “ሮቤላ ዛራቱ፥ ጋደ ዛራቱነ ምናሰ ዛራቱዋፐ ባጋቱ ዮርዳኖሳ ማታን፥ ጋልሎታን፥ ካናነ ዛዋን፥ እስራኤላቱ ባጋና ያርሹዋ ሳኣ ግምቤድኖ” ግያዋ እስራኤላቱ ስሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","ኩመንꬃ እስራኤልያ አሳ ያአይ ኡንቱንቱ ኦላናዉ ባናዉ ሴሎ ግያ ሳን እትፐ ሺቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","እስራኤልያ አሳይ ቄስያ ኤልኣዛራ ናኣ ፒንሃሳ፥ ጋላኣደ ጋድያን ደእያ ሮቤላ ዛራቱዋኮ፥ ጋደ ዛራቱዋኮነ ምናሰ ዛራቱዋፐ ባጋቱዋኮ ኪቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","እት እት ዛሪ ባረ ያራቱ ካፓቱዋፐ እት እት አሳ ዶሪደ፥ ታሙ አሳ ፒንሃሳና የዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","ኡንቱንቱ ሮቤላ ዛራቱ፥ ጋደ ዛራቱነ ምናሰ ዛራቱዋፐ ባጋቱ ደእያ ጋላኣደ ጋድያ ቢደ ኡንቱንታ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“መꬍና ጎዳ አሳይ ኩመንꬃ ያአይ ህንተንታ ሀዋዳን ያጌ፤ ‘እስራኤልያ ጾሳ ቦላ አያዉ ሀዋ ማላ ኢታባ ኦꬄድቴ? ዋኒደ ጎፐ፥ ህንተንቱ ሀራ ያርሹዋ ሳኣ ህንተንቶ ግምቢደ፥ መꬍና ጎዳ ቦላ ማካሌድታ! አ ካልያዋካ አጌዲታ! ");
INSERT INTO dwrENT_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","ፓኦራን ኑን ኦꬄዳ ናጋራይ ኑዉ ግደኔ? እስራኤልያ ሽቁዋ ቦላ ቦሻይ ዎꬌዳዋ ግዶፐነ፥ ሀቼ ጋካናዉካ ኑን ሄ ናጋራፐ ጌይቦኮ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","መꬍና ጎዳ ካልያዋፐ ሀችካ ዎራ ስማነየ? “ ‘ህንተ ሀቼ መꬍና ጎዳ ቦላ ማካሎፐ፥ መꬍና ጎዳይ ዎንት ኩመንꬃ እስራኤልያ ሽቁዋ ሀንቀታናዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","ህንተንቱ ደእያ ጋዲ ቱኔዳዋ ግዶፐ፥ መꬍና ጎዳ ዱንካኒ ኤቄዳ ጋድያ ሃ ዪደ፥ ኑናና ጋድያ ሻክተ። ሽን ካሰፐ ደእያ መꬍና ጎዳ ኑ ጾሳ ያርሹዋ ሳአፐ ሀራ ያርሹዋ ሳኣ ግምቢደ፥ መꬍና ጎዳ ቦላ ማካሎፕተ፤ ዎይ ኑናካ ማካላንቻ ከሶፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","ዛራሀ ዛረ አካን ናጋራ ግዶዋፐ አኪደ፥ ናጋራ ኦꬄዳ ድራዉ፥ ኩመንꬃ እስራኤልያ ሽቁዋ ቦላ ጾሳ ሀንቁ ዎꬍቤኔ? ባረ ናጋራ ጋሱዋን ሀይቄዳዌ አ ጻላላ ግደና’ ያጌ” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","ሄዋፐ ጉየ ሮቤላ ዛራቱ፥ ጋደ ዛራቱነ ምናሰ ዛራቱዋፐ ባጋቱ እስራኤልያ ያራቱ ካፓቶ ሀዋዳን ያጊደ ዛሬድኖ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“ዎልቃማይ መꬍና ጎዳ ጾሳ! ዎልቃማይ መꬍና ጎዳ ጾሳ! ኑን ሀዋ አያዉ ኦꬄደንቶ እ ኤሬዳ! ኑን አያዉ ኦꬄደንቶ ህንተንቱካ ኤራናዳን ኮዬቶ። ኑን መꬍና ጎዳ ቦላን ማካሌዳዋነ አዛዘተናን እጼዳዋ ግዶፐ፥ ሀቼ ኑና ፓጻ ዎꬆፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","ኑን መꬍና ጎዳ ካልያዋ አጊደ፥ ጹግያ ያርሹዋ፥ ካꬃ ያርሹዋነ እትፐተꬃ ያርሹዋ ያርሻናዉነ ያርሽያ ሳኣ ግምቤዳዋ ግዶፐ፥ መꬍና ጎዳይ ኑና ሄ ኦሶ ኦቾ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","ኑን ሄዎ ግምቢቦኮ፤ ኑን ያርሹዋ ሳኣ ግምቤዳዌ፥ ስንꬃፐ ያና ላይꬃን ህንተንቱ ናናይ ኑ ናና፥ ‘ህንተና መꬍና ጎዳን እስራኤልያ ጾሳን አዬ ጋꬅያዌ? ");
INSERT INTO dwrENT_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","ህንተንቶ፥ ሮቤላነ ጋደ ዛረቶ፥ መꬍና ጎዳይ ኑ ግዶንነ ህንተንቱ ግዶን ዮርዳኖሳ ሻፋ ዛዋዬዳ። መꬍና ጎዳን ህንተንታ ጋꬅያዌ ባዋ’ ያጋነንቶነ ጊደ ህርጌዳ ድራሳ። ሄዋዳን ኦꬂደ፥ ህንተንቱ ዛራቱ ኑ ዘረꬃ መꬍና ጎዳዉ ጎይነናዳን ተኤናን አግክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“ሄዋ ድራዉ ኑን ኑ ግዶን ያርሹዋ ሳኣ አነ ግምቦይተ ገዳ፤ ሽን ጹግያ ያርሹዋ ሳኣ ዎይ ሀራ ያርሹዋ ሳኣ ግደና። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","ኑን ያርሹዋ ሳኣ ግምቤዳዌ ጹግያ ያርሹዋ፥ እትፐተꬃ ያርሹዋነ ሀራ ያርሹዋ ያርሺደ፥ መꬍና ጎዳዉ አ ዱንካንያን ጎይናና ማላ፥ ሀዌ ኑ ግዱዋንነ ህንተንቱ ግዱዋን፥ ቃይ ኑ ካልያ የለታ ግዱዋን ማርካ ግዳናሳ። ዎደፐ ህንተንቱ ዛራቱ ኑ ዘረꬃ፥ ‘ህንተና መꬍና ጎዳን ጋꬅያዌ አያይነ ባዋ’ ጋናዉ ዳንዳይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","ኡንቱንቱ ጌላዳን ኑና ዎይ ኑ የለታ ዎድያፐ ሄዋዳን ጎፐ፥ ኑን ኡንቱንቶ ዛሪደ፥ ‘ጾሳዉ ያርሽያ ሳኣ ሌምሱዋ ሀዋ በእተ። ሀዋ ኑ አዎቱ ጹግያ ያርሹዋነ ሀራ ያርሹዋ ያርሻናሳ ግደናን፥ ህንተፐነ ኑፐነ ግዱዋን ማርካ ግዳና ማላ ግምቤድኖ’ ያጋና። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","መꬍና ጎዳ ቦላ ማካላናዌ ኑፐ ሃኮ! መꬍና ጎዳ ኑ ጾሳ ዱንካንያ ስንꬃን ኤቄዳ ያርሹዋ ሳፐ ሀራ፥ ጹግያ ያርሹዋ፥ ካꬃ ያርሹዋነ ሀራ ያርሹዋ ያርሽያ ሳኣ ግምቢደ፥ ሀቼ ዎራ ስምበይኮ” ያጊደ ዛሬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","ቄስያ ፒንሃስነ አናና ደእያ እስራኤልያ ያራቱ ካፓቱ፥ ሮቤላ፥ ጋዳነ ምናሰ ዛራቱ ኦዴዳዋ ስሲደ፥ ሎይꬅ ናሸቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","ቄስያ ኤልኣዛራ ናአይ ፒንሃስ ሮቤላ፥ ጋዳነ ምናሰ ዛረቶ፥ “መꬍና ጎዳይ ኑ ግዶን ደእያዋ ኑን ሀቼ ኤሬዶ፤ አያዉ ጎፐ፥ ሀ የዉዋ ህንተንቱ መꬍና ጎዳ ቦላ ማካላናዉ ኦꬅበይክታ። ህንተንቱ ሀእ መꬍና ጎዳ ሙራፐ እስራኤልያ አሳ አሼድታ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","ሄዋፐ ጉይያን ቄስያ ኤልኣዛራ ናአይ ፒንሃስነ ካፓቱ ጋላኣደን ደእያ ሮቤላነ ጋደ ዛራቱዋ ማታፐ ካናነን ደእያ እስራኤልያ አሳኮ ስሚደ ሀኔዳባ ኡንቱንቶ ኦዴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","እስራኤልያ አሳይ ናሸቻን፥ ጾሳ ጋላቴድኖ። ቃይ ሮቤላ አሳቱነ ጋደ አሳቱ ደእያ ጋድያ ኦለቲደ ባይዛናዉ ባናዉ ሃሳይያዋካ አጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","ሮቤላነ ጋደ ዛራቱ፥ “ሀ ያርሹዋ ሳአይ ጾሳ ጻላላይ ጾሳ ግድያዎ ኑ ኡባፐ ግዱዋን ማርካ ግዳናዋ” ያጌድኖ፤ ሄ ያርሹዋ ሳኣ ማርካ ሱንꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","ዳሮ ዎድያፐ ጉይያን፥ መꬍና ጎዳይ እስራኤልያ አሳ ኡንቱንቱ ዩሹዋን ደእያ ሞርከቱዋ ኡባፐ ሸምፕሴዳ። ሄ ዎደ ኢያሱ ጭሚደ፥ ዎድያ ሎይꬅ ሱጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","ያቴዳዌ እስራኤልያ አሳ ኡባ፥ ጭማቱዋ፥ ካፓቱዋ፥ ዳናቱዋነ ኦላ ጋዳዋቱዋ እትፐ ጼሲደ፥ ሀዋዳን ያጌዳ፤ “ታን ጭማደ፥ ዎድያ ሎይꬃ ሱጋድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","መꬍና ጎዳይ ህንተንቱ ጾሳይ ህንተንቱ ድራዉ ሀ ካዉተꬃቱዋ ኡባ ኦꬄዳዋ ህንተንቱ ህንተንቱ ሁጲያዉ በኤድታ። ህንተንቶ ኦለቴዳዌ መꬍና ጎዳ ህንተንቱ ጾሳተነ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","በእተ፥ ዮርዳኖሳ ሻፋፐ ዶሚደ አዋይ ዉልያ ባጋና ደእያ ሜድትራነ አባ ጋካናዉ ደእያ፥ አቴዳ ካዉተꬃቱዋ ቢታ ኡባ፥ ታን ꬋይሴዳ ካዉተꬃቱ ቢታናካ ላታ ጋደ ኦꬃደ፥ ህንተንቱ ዛረቶ ሻካደ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","መꬍና ጎዳይ ህንተንቱ ጾሳይ ኡንቱንታ ሱጋናነ ህንተንቱ ስንꬃፐ ላግና መꬍና ጎዳይ ህንተንቱ ጾሳይ ጌዳዋዳን፥ ህንተንቱ ኡንቱንቱ ጋድያ ላታና። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“ሄዋ ድራዉ፥ ሙሴ ህግያ ማጻፋን ጻፈቴዳ ኡባ ናጋናዉነ ኦꬃናዉ ሎይꬅ ምንተ፤ አፐ ኡሸቻ ሀድርሳ ጎፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","ሄዋን ህንተንቱ ግዶን አቴዳ ሀ ካዉተꬃቱዋና ዋላከቶፕተ። ኡንቱንቱ ጾሳቱዋ ሱንꬃ ደንꬆፕተ ዎይ ኡንቱንቱ ሱንꬃን ጫቆፕተ። ኡንቱንቶ ኦꬆፕተ ዎይ ኡንቱንቶ ጎይኖፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","ሽን ሀቼ ጋካናዉ ህንተንቱ ኦꬄዳዋዳን፥ ጾሳ ህንተንቱ መꬍና ጎዳ ሎይꬅ ኦይክተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“አያዉ ጎፐ፥ መꬍና ጎዳይ ግታነ ምኖ ካዉተꬃቱዋ ህንተንቱ ስንꬃፐ ከሴዳ። ህንተና ግዶፐ፥ ሀቼ ጋካናዉ ኦንነ ህንተናና ኤቀታናዉ ዳንዳይቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","መꬍና ጎዳይ ህንተንቱ ጾሳይ ህንተንቶ ጌዳዋዳን፥ እ ባረ ሁጲያዉ ህንተንቶ ኦለትያ ድራዉ፥ ህንተፐ እት አሳይ ሻአ አሳ የደርሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","መꬍና ጎዳ ህንተንቱ ጾሳ ኡባ ገደ ሲቃናዋ ዶጎፕተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","ህንተንቱ ጉየ ስሚደ፥ ካዉተꬃቱዋፐ ሀዋን ህንተንቱ ግዱዋን አቴዳ አሳና እቱዋ ግዶፐ፥ ኡንቱንቱ ማቻቱዋ ህንተንቶ፥ ህንተንቱ ማቻቱዋ ኡንቱንቶ እም ዋላከቶፐ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","መꬍና ጎዳይ ህንተንቱ ጾሳይ ሀ ካዉተꬃቱዋ ህንተንቱ ስንꬃፐ የደርስያዋ አግ ባሻናዋ ጌሺደ ኤርተ። ሽን መꬍና ጎዳይ ህንተንቱ ጾሳይ እሜዳ ሀ ሎኦ ጋድያፐ ህንተንቱ ꬋያና ጋካናዉ፥ ኡንቱንቱ ህንተንቶ ጲረነ ግተ ግዳና፤ ህንተንቱ ዞክያዉ ልሶ፥ ህንተንቱ አይፍያዉካ አጉንꬃ ግዳና። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“ሀእ ስም ታን ሀይቃና ማታድ። መꬍና ጎዳይ ህንተንቱ ጾሳይ ህንተንቶ እማና ጌዳ ሎኦ ኡባፐ እትባይነ አትቤናዋ ህንተንቱ ኡባይ ህንተንቱ ዎዛናንነ ሸምፑዋን ኤሪታ። እ ህንተንቶ እማና ጌዳዋፐ እትባይነ አተናን፥ ኡባይ ፖለቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","መꬍና ጎዳይ ህንተንቱ ጾሳይ ህንተንቶ እማና ጌዳ ሎኦባይ ኡባይ አተናን ፖለቴዳዋዳን፥ መꬍና ጎዳይ ህንተንቱ ጾሳይ ህንተንቶ እሜዳ ሀ ሎኦ ጋድያፐ ህንተንታ ꬋይሳና ጋካናዉ፥ ኢታ ሙሩዋ ኡባካ ህንተንቱ ቦላን ሄዋዳን አሀና። ");
INSERT INTO dwrENT_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","መꬍና ጎዳይ ህንተንቱ ጾሳይ ህንተናና ጫቀቴዳ ቃላ ጫቁዋ ህንተንቱ መንꬆፐ፥ ቢደ ሀራ ጾሳቶ ኦꬆፐነ ጎይኖፐ፥ መꬍና ጎዳ ሀንቁ ህንተንቱ ቦላ ኤጽ ከሳና፤ እ ህንተንቶ እሜዳ ሎኦ ቢታፐካ ህንተንቱ ኤለካ ꬋያና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","ሄዋፐ ጉይያን ኢያሱ እስራኤልያ ዛራቱዋ ኡባ ሰኬማ ጌተትያ ካታማን ሺሼዳ። ጭማቱዋ፥ ካፓቱዋ፥ ዳናቱዋነ ኦላ ጋዳዋቱዋ ኡባ ጼስና ኡንቱንቱ ጾሳ ስንꬃን ሺቄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","ኢያሱ አሳዉ ኡባዉ ሀዋዳን ያጌዳ፤ “መꬍና ጎዳይ እስራኤልያ ጾሳይ ሀዋዳን ያጌ፤ ‘በን ህንተንቱ አዎቱ ኤፍራጺሳ ሻፋፐ ሄፍንꬃን ደኤድኖ፤ ኡንቱንቱ ሀራ ጾሳቶ ኦꬄድኖ። ኡንቱንቱፐ እቱ አብራሃማነ ናኮራ አዉዋ ታራ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","ሄዋፐ ጉይያን ህንተንቱ አዉዋ አብራሃማ፥ ሄ ሻፋፐ ሄፍንꬃን ደእያ ጋድያፐ ጼሳደ፥ ካናነ ቢታ ኡባን ካለꬃድ። አ ዛርያካ ጮራያድ፤ ይሳቃካ አዉ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","ይሳቃዉካ ያቆባነ ኤሳ እማድ። ኤሳዉ ኤዶማ ገዝያ ላታናዳን እማድ፤ ሽን ያቆብነ አ ናናይ ዱገ ግብጼ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“ ‘ጉየፐ ሙሳነ አሮና ኪታደ ታን ያን ኦꬄዳዋን ግብጼ ጋድያ አሳ ቦሻን ሾጫድ፤ ሄዋፐ ጉይያን ህንተንታ ከሳድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","ታን ህንተንቱ አዎቱዋ ግብጼፐ ከስና፥ ዞኦ አባኮ ዬድታ፤ ግብጼቱ ህንተንቱ አዎቱዋ ፓራቱ ጎችያ ጋረቱዋንነ ፓራዋቱዋን የደርሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","ኡንቱንቱ መꬍና ጎዳዉ ዋሴዳ ዎደ፥ ኡንቱንቱፐነ ግብጼቱዋፐ ግዱዋን ꬉማ የጋድ፤ ያታደ፥ አባይ ኡንቱንቱ ቦላ ስማናዳንነ ኡንቱንቱ ሙካናዳን ኦꬃድ። ታን ግብጼቱዋ ቦላ ኦꬄዳዋ ህንተንቱ ህንተንቱ አይፍያን በኤድታ። ህንተካ ዎራን ዳሮ ዎድያ ደኤድታ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","“ ‘ሄዋፐ ጉይያን ዮርዳኖሳ ሻፋፐ አዋይ ዶልያ ባጋና ደእያ አሞራዋናቱዋ ጋድያ ታን ህንተንታ አሃድ። ኡንቱንቱ ህንተናና ኦለትና፥ ታን ኡንቱንታ ህንተንቱ ኩሽያን አꬃደ እማድ፤ ህንተንቱ ጋድያ ላቴድታ። ቃይ ታን ኡንቱንታ ህንተንቱ ስንꬃፐ ꬋይሳድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","ሄዋፐ ጉይያን ጽፖራ ናአይ ባላቅ፥ ሞኣበ ጋድያ ካቲ ደንዲደ፥ እስራኤላቱዋና ኦለቴዳ። ባኦራ ናአይ ባላም ህንተንታ ሸቃናዳን፥ ኪቲደ ጼስሴዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","ሽን ታን ባላመባ ስሳበይከ። ሄዋ ድራዉ እ ህንተንታ አንጄዳ፤ ያትና፥ ታን ህንተንታ ባላቃ ኩሽያፐ አሻድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“ ‘ዮርዳኖሳ ሻፋ ፕኒደ፥ ያርኮ ዬድታ፤ ያርኮ አሳይነ አሞራዋናቱ፥ ፓርዛዋናቱ፥ ካናነቱ፥ ሂተቱ፥ ገርጌሰቱ፥ ሂዌቱነ ያቡሳዋናቱ ህንተናና ኦለትና፥ ታን ኡንቱንታ ህንተንቱ ኩሽያን አꬃደ እማድ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","ካጅያ ህንተፐ ስንꬃዉ ኪታደ፥ አሞራዋናቱዋ ካተቱዋ ላአቱዋ ህንተንቱ ስንꬃፐ ከሳድ። ሀዌ ኡባይ ሀናናዉ ዳንዳዬዳዌ፥ ህንተንቱ ማሻንነ ህንተንቱ ዎንዳፍያን ግደና። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","ህንተንቱ ጎሺደ ከስቤና ጋድያነ ህንተንቱ ኬጽቤና ካታማቱዋ ታን ህንተንቶ እምና፥ አን ደኢታ። ሀእ ህንተንቱ ቶክቤና ዎይንያ ቱራ አይፍያነ ዎጋራ አይፍያ ሚታ’ ያጌ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“ሄዋ ድራዉ ሀእካ መꬍና ጎዳዉ ያይተ፤ ቱሙ ዎዛናፐ አማነቲደ አዉ ጎይንተ። ህንተንቱ ማይዛ አዎቱ ኤፍራጺሳ ሻፋፐ ሄፍንꬃንነ ግብጼን ጎይኔዳ አላጋ ጾሳቱዋ ዎራ ኦሊደ፥ መꬍና ጎዳዉ ጎይንተ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","መꬍና ጎዳዉ ጎይንያዌ ህንተንታ ኢቶፐ፥ ህንተንቱ አዎቱ ሻፋፐ ሄፍንꬃን ደኢደ ጎይኔዳ ጾሳቱዋ ግድና፥ ዎይ ሀእ ህንተንቱ ደእያ አሞረ ጋድያ አሳ ጾሳቱዋ ግድና፥ ህንተንቱ ጎይንያዋ ሀቼ ዶርተ። ሽን ታናነ ታ ጎልያ አሳ ግዶፐ፥ ኑን መꬍና ጎዳዉ ጎይናና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","አሳይ ዛሪደ፥ “መꬍና ጎዳ አግ ባሺደ፥ ሀራ ጾሳቶ ጎይናናዌ ኑፐ ሃኮ! ");
INSERT INTO dwrENT_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","ግብጼ ጋድያፐ፥ አይለተꬃ ጎልያፐ፥ ኑናነ ኑ አዎቱዋ ከሲደ አሄዳዌ፥ ሄ ዎልቃማ ማላታቱዋ ኑ ጼልሽን ኦꬄዳዌ፥ ኑን ቤዳ ኦግያ ኡባንነ አꬌዳ ቢታቱዋ ኡባ ግዱዋን ኑና ናጌዳዌ፥ መꬍና ጎዳ ኑ ጾሳተነ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","ቃይ መꬍና ጎዳይ አሳ ኡባ፥ ሄ ጋድያን ደእያ አሞረ አሳቱዋናካ ኑ ስንꬃፐ ላጊደ ከሴዳ። ሄዋ ድራዉ ኑንካ መꬍና ጎዳዉ ጎይናና፤ አያዉ ጎፐ፥ እ ኑ ጾሳ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","ሽን ኢያሱ አሳ ሀዋዳን ያጌዳ፤ “ህንተንቱ መꬍና ጎዳዉ ጎይናናዉ ዳንዳይክታ። አያዉ ጎፐ፥ እ ጌሻ ጾሳ፤ እ ቃናትያ ጾሳ፤ እ ህንተንቱ ናቁዋ ዎይ ህንተንቱ ናጋራ አቶ ጌና። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","ህንተንቱ መꬍና ጎዳ አጊደ፥ አላጋ ጾሳቶ ጎይኖፐ፥ እ ህንተንቶ ሎኦባ ኦꬄዳዋፐ ጉይያን፥ ስሚደ ህንተንታ ቆሀናነ ꬋይሳና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","አሳይ ኢያሳ፥ “ቱይት፥ ግደና! ኑን መꬍና ጎዳዉ ጎይናና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","ኢያሱ አሳ፥ “ህንተንቱ መꬍና ጎዳዉ ጎይንያዋ ዶሬዳዎ ህንተንቱ ሁጲያዉ ህንተንቱ ማርካ” ያጌዳ። ኡንቱንቱ፥ “ኤ ኑን ማርካ!” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","ኢያሱ፥ “ያቶፐ፥ ህንተንቱ ግዱዋን ደእያ አላጋ ጾሳቱዋ ድግተ፤ ህንተንቱ ዎዛና መꬍና ጎዳኮ፥ እስራኤልያ ጾሳኮ ዛርተ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","ኡንቱንቱ፥ “ኑን መꬍና ጎዳዉ፥ ኑ ጾሳዉ፥ ጎይናና፤ አ አዛዙዋካ ፖላና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","ሄ ጋላስ ኢያሱ አሳና ቃላ ጫቁዋ ጫቀቴዳ፤ ሰኬማን ህግያነ ዎጋ ኡንቱንቶ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","ኢያሱ ሄ ቃላቱዋ ጾሳ ህግያ ማጻፋን ጻፌዳ። ሄዋፐ ጉይያን፥ እት ዎልቃማ ሹቻ አኪደ፥ መꬍና ጎዳ ዱንካንያ ማታን ደእያ ዎላ ጋርሳን ኤሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","ኢያሱ አሳዉ ኡባዉ፥ “በእተ፥ መꬍና ጎዳይ ኑዉ ሃሳዬዳ ቃላ ኡባ ሀ ሹቻይ ስሴዳ ድራዉ፥ እ ኑ ቦላ ማርካ ግዳናዋ። ህንተንቱ ጾሳ ቦላን ማካሎፐ፥ ሀ ሹቻይ ህንተንቱ ቦላ ማርካ ግዳናዋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","ሄዋፐ ጉይያን፥ ኢያሱ አሳ ኡባ የድና፥ ኡባይካ ባረ ላታ ጋድያ ጋድያ ስሚደ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","ሄዋፐ ጉይያን መꬍና ጎዳ ቆማይ፥ ነዌ ናአ ኢያሱ፥ ላይꬃይ ጼታነ ታሙዋ ግድና ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","አሳይ ጋኣሻ ደርያፐ ሁጲሳ ባጋን፥ ኤፍሬማ ገዝያን ደእያ አ ላታ ጋድያን፥ ትምናት-ሴራን ሞጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","ኢያሱ ፓጻ ደኤዳ ዎደ ኡባንነ ኢያሱፐ ስምና ደኢደ፥ መꬍና ጎዳይ እስራኤላቶ ኦꬄዳ ኦሱዋ ኡባ ኤሬዳ ጭማቱዋ ዎደ ኡባን እስራኤላቱ መꬍና ጎዳዉ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","እስራኤልያ አሳይ ግብጼ ጋድያፐ አሄዳ ዮሴፎ መቀꬃ ሰኬማን ሞጌድኖ። ሄ ሳኣ ያቆብ ሸኬማ አዉዋ ሀሞራ ናናቱዋፐ ጼቱ ጻጋራ ብራን ሻሜዳ፤ ጉየፐ ዮሴፎ ዛራቱ ላቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","አሮና ናአይ ኤልኣዛረ ሀይቄዳ፤ አ ናኣ ፒንሃሳዉ እመቴዳ ኤፍሬማ ገዝያን ደእያ ግብኣ ጌተትያ ካታማን ሞጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","ኢያሱ ሀይቄዳዋፐ ጉይያን፥ እስራኤልያ አሳይ፥ “ካናነ ጋድያ አሳ ኦላናዉ ኑ ዛራቱዋፐ ኮይሮቲደ ከሳናዌ ኦኔ?” ያጊደ መꬍና ጎዳ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","መꬍና ጎዳይ፥ “ይሁዳ ዛራቱ ኮይሮቲደ ከስኖ። ታን ጋድያ ኡንቱንቱ ኩሽያን አꬃደ እማድ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","ይሁዳ አሳይ ባረንቱ ዳቦቱዋ፥ ስሞና ዘረꬃ፥ “ኑን ካናነቱዋና ኦለታና ማላ፥ ኑና ሻክና ጋኬዳ ሳኣ ኑናና ደንድተ። ሄዋፐ ጉይያን፥ ህንተንታ ሻክና ጋኬዳ ሳኣ ህንተናና እትፐ ባና” ያጌዳ። ስሞና ዛራቱነ ይሁዳ ዛራቱ ኦላዉ እትፐ ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","መꬍና ጎዳይ ካናነቱዋነ ፓርዘቱዋ ኡንቱንቱ ኩሽያን አꬂደ እሜዳ፤ በዜቃ ጌተትያ ካታማን ታሙ ሻአ አሳ ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","በዜቃ ካታማን አዶን-ቤዘቃ ደሚደ፥ አናና ኦለቴድኖ፤ ካናነቱዋነ ፓርዘቱዋ ጾኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","አዶን-ቤዘቅ ባቃቴዳዋ የደርስ ኦይቂደ፥ አ ኩሽያ ዎጋ ብራቱዋነ አ ገድያ ዎጋ ብራቱዋ ቃንጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","አዶን-ቤዘቅ፥ “ኩሽያ ዎጋ ብራቱዋነ ገድያ ዎጋ ብራቱዋ ታን ጭጌዳ ላፑን ታሙ ካተቱ ታ ማሶፍያፐ ላለቴዳ ሱፓ ማጺደ ሚኖ። ታን ኡንቱንቱ ኦꬄዳዋዳን፥ ጾሳይ ታና ኦꬄዳ” ያጌዳ። አ የሩሳላመ አህና፥ ያን ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","ይሁዳ አሳይ የሩሳላመ ኦለቲደ ኦይቄዳ፤ አሳ ቃራ ማሻን ዎꬊደ፥ ካታማ ታማን ጹጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","ሄዋፐ ጉይያን፥ ይሁዳ አሳይ ገዝያን፥ ኔጌባ መላ ቢታንነ ጋꬋን ደእያ ካናነቱዋ ኦላናዉ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","ካሰ ቅርያት-አርባአ ጌተትያ ከብሮነ ካታማን ደእያ ካናነቱዋ ኦሌድኖ፤ ሸሻያ፥ አህማናነ ታልማያ ጌተትያ ያራቱዋ ጾኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","ሄዋፐ ደንዲደ ይሁዳ አሳይ ዳቢራ ጌተትያ ካታማን ደእያ አሳ ኦላናዉ ቤዳ። ዳቢራ ካታማይ ካሰ ቅርያት-ሰፈራ ጌተቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","ካሌብ፥ “ቅርያት-ሰፈራ ኦለቲደ ኦይቂያ ኡራዉ ታን ታ ናቶ አክሶ እማና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","ካሌባ እሻ ቴፋ ቃናዛ ናአይ ኦትንኤል ሄ ካታማ ኦለቲደ ኦይቄዳ፤ ካሌብ ባረ ናቶ አክሶ አዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","አክሳ ኦትንኤላ ገልያ ዎደ፥ እ አዉ እዝዉ ጋድያ እማናዳን ዎሳና ማላ፥ ኦትንኤል እዞ ዞሬዳ። እዛ ባቁሉዋፐ ዎꬋዱ፤ ካሌብ እዞ፥ “አያ ኮያይ?” ያጊደ ኦቼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","እዛ፥ “ታዉ ዎይቱዋ እማ። ኔን ካሰ ታዉ እሜዳ ጋዲ ዳሪ መላ ቢታ ግዴዳ ድራዉ፥ ሃꬃ ፑልቶቱዋ ታዉ እማርኪ” ያጋዱ። ካሌብ ክል ፑልቱዋካ ህርክ ፑልቱዋካ እዝዉ እሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","ሙሴ ቦሉዋ ዛራቱ ቄናት ይሁዳ አሳና ዛምባ ካታማ ጌተትያ ያርኮ ካታማፐ ደንዴድኖ፤ አራዳ ጌተትያ ካታማፐ ገድሳ ባጋና፥ ኔጌባን ደእያ ይሁዳ መላ ቢታ ቤድኖ፤ ያን አማሌቃቱዋና ኡቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","ይሁዳ አሳይ ስሞና አሳና እትፐ ቢደ፥ ጻፋታ ጌተትያ ካታማን ደእያ ካናነቱዋ ጾኔዳ፤ ካታማ ኡባ ꬋይሴዳ። ሄዋ ድራዉ ሆርማ ያጊደ ሱንꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","ይሁዳ አሳይ ጉጂደካ ጋዛ፥ አስቃሎናነ ኤቅሮና ካታማቱዋ ኡንቱንቱ ዩሹዋን ደእያ ቢታቱዋናካ ኦይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","መꬍና ጎዳይ ይሁዳ አሳና ደእያ ድራዉ፥ ገዘ ጋድያ ኡንቱንቱ ላቴድኖ፤ ሽን ደምባ ጋድያ አሳቶ ብራታፐ ኦሰቴዳ ኦላ ፓራ ጋረቱ ደእያ ድራዉ፥ ይሁዳ አሳይ ኡንቱንታ የደርሳናዉ ዳንዳይቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","ሙሴ ጌዳዋዳን፥ ከብሮነ ካታማ ካሌባዉ እሜድኖ፤ ካሌብ አናቀ ዛርያ ግድያ ሄዙ ያራቱዋ የደርሲደ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","ሽን ቢንያማ ዛራቱ የሩሳላመን ደእያ ያቡሳቱዋ የደርስበይክኖ፤ ያትና፥ ያቡሳዋናቱ ቢንያማ ዛራቱዋና ሀቼ ጋካናዉ የሩሳላመን እትፐ ደኢኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","23","ዮሴፎ ናናቱዋ፥ ኤፍሬማነ ምናሰ ዛራቱ ቃይ ቤቴለ ካታማ ቦላን ዎራጄድኖ። ካሰ ሄ ካታማይ ሎዛ ጌተቴ። ዎራጅያ ዎደ መꬍና ጎዳይ ኡንቱንቱና ደኤ። ዮሴፎ ዛራቱ ቤቴለ ካታማ ጾሞስያ አሳቱዋ ኪቴድኖ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","ኡንቱንቱ ካታማፐ ከስያ እት ብታንያ ደሚደ፥ “ካታማ ግዶ ዋን ገላናዉ ዳንዳየትንቶ ኑና በሶፐ፥ ኑን ነዉ ኬካና” ያጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","እ ኡንቱንታ በሴዳ፤ ካታማን ደእያ አሳ ቃራ ማሻን ሙሸሬꬄድኖ፤ ሽን ሄ ብታንያነ አ ሶ አሳ ኡባ አሸድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","ጉየፐ ሄ ብታኒ ሂተቱዋ ጋድያ ቢደ፥ ያን ካታማ ኬጼዳ፤ ሎዛ ያጊደ ሱንꬄዳ፤ ሀቼ ጋካናዉ ሄ ካታማይ ሄ ሱንꬃን ጼሰቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","ምናሰ ዛራቱ ቤትሻና፥ ታእናካ፥ ዶራ፥ ይብላኣማነ ማግዶ ካታማቱዋንነ ኡንቱንቱ ዩሹዋን ደእያ ሞꬃቱዋን ደእያ አሳቱዋ ከሲደ የደርሳናዉ ዳንዳይበይክኖ። ያትና፥ ካናነቱ ያን ደኡዋ ምንሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","እስራኤልያ አሳይ ምኔዳ ዎደ፥ ካናነቱዋ ባረንቱ ዎልቃን ኦስሴድኖ፤ ሽን ኡንቱንታ ኡባና ጋድያፐ ከሲደ የደርስበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","ኤፍሬማ ዛራቱካ ገዜራ ጌተትያ ካታማን ደእያ ካናነቱዋ ከሲደ የደርስበይክኖ፤ ያትና፥ ካናነ አሳቱ ያን ኡንቱንቱና እትፐ ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","ዛብሎና ዛራቱ ቅትሮና ካታማንነ ናህላላ ካታማን ደእያ አሳቱዋ ከሲደ የደርስበይክኖ፤ ያትና፥ ካናነቱ ያን ኡንቱንቱና እትፐ ደኤድኖ። ሽን ዛብሎና ዛራቱ ኡንቱንቱ ባረንቱ ዎልቃን ኦስሰድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","አሴራ ዛራቱካ አኮን፥ ሲዶናን፥ አህላባን፥ አክዚባን፥ ሄልባን፥ አፌቃንነ ራሆባን ደእያ አሳቱዋ ከሲደ የደርስበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","ካናነቱ ከሰናን አጌዳ ድራዉ፥ አሴራ ዛራቱ ኡንቱንቱና ያን እትፐ ደኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","ንፍታሌማ ዛራቱካ ቤት-ሸመሻ ካታማንነ ቤት-አናታ ካታማን ደእያ አሳቱዋ ከሲደ የደርስበይክኖ፤ ሽን ካናነቱዋና ያን እትፐ ደኤድኖ። ቤት-ሸመሻነ ቤት-አናታ ካታማ አሳቱዋ ባረንቶ ዎልቃን ኦስሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","አሞራዋናቱ ዳና ዘረꬃ ፑደ ገዝያዉ የደርሴድኖ፤ ኡንቱንቱ ዱገ ደምባ ጋድያ ዎናዳን ተኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","አሞራዋናቱ ሄሬሳ ደርያንነ አያሎናነ ሻአልቢማ ጌተትያ ካታማቱዋን ደኡዋ ምንሴድኖ፤ ሽን ኤፍሬማነ ምናሰ ዛራቱ ምን ምኒደ ቢደ፥ ባረንቶ ዎልቃን ኦስሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","አሞራዋናቱዋ ጋድያ ዛዋይ ሰላአ ማታን ደእያ አክራቢማ ጌተትያ ፑደꬃፐ ዶሚደ፥ ሁጲሳ ባጋ ፕኑዋ ጋኬ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","መꬍና ጎዳ ኪታንቻይ ገልገላፐ ቦክማ ቢደ፥ እስራኤልያ አሳ ሀዋዳን ያጌዳ፤ “ታን ህንተንታ ግብጼፐ ከሳድ፤ በን ህንተንቱ ማይዛ አዋቶ እማና ጋደ ጫቄዳ ጋድያ ህንተንታ ገልሳድ። ህንተንታ ሀዋዳን ያጋድ፤ ‘ታን ህንተናና ጫቀቴዳ ጫቁዋ ኡባካ መንꬅከ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","ህንተንቱ ሀ ጋድያን ደእያ አሳቱዋና ቃላ ጫቁዋ ገሎፕተ፤ ኡንቱንቱ ያርሽያ ሳኣ ኮልተ’ ያጋድ፤ ሽን ህንተንቱ ታዉ አዛዘትበይክታ። አያዉ ሄዋዳን ሀኔድቴ? ");
INSERT INTO dwrENT_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","ሄዋ ድራዉ፥ ታን ኡንቱንታ፥ ህንተንቱ ስንꬃፐ የደርስከ፤ ኡንቱንቱ ህንተንቶ ሞርከ ግዳና፤ ኡንቱንቱ ጾሳቱካ ህንተንቶ ጲረ ግዳና ያጋይ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","መꬍና ጎዳ ኪታንቻይ ሄዋ እስራኤልያ አሳዉ ኡባዉ ሃሳዬዳ ዎደ፥ አሳይ ባረ ቃላ ꬎቁ ኦꬂደ ዬኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","ያቲደ ሄ ሳኣ ቦክማ ያጊደ ሱንꬄዳ፤ ሄዋን መꬍና ጎዳዉ ያርሹዋ ያርሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","ኢያሱ እስራኤልያ አሳ የዴዳዋፐ ጉይያን፥ አሳይ እቱ እቱ ባረና ሻክና ጋክያ ጋድያ አካናዉ ቤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","ኢያሱ ደኡዋን ደኤዳ ላይꬃ ኡባን አሳይ መꬍና ጎዳዉ ኦꬄዳ፤ እ ሀይቄዳዋፐ ጉይያን፥ መꬍና ጎዳይ እስራኤልያ አሳዉ ኦꬄዳ ዎልቃማ ኦሱዋ ኡባ በኤዳ ጭማቱዋ ዎደ ኡባን መꬍና ጎዳዉ ኦꬅያዋ አግቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","መꬍና ጎዳ ቆማይ፥ ነዌ ናኣ ኢያሱ፥ ላይꬃይ ጼታነ ታሙዋ ግድና ሀይቄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","ጋኣሻ ደርያፐ ሁጲሳ ባጋን፥ ኤፍሬማ ገዝያን፥ ትምናት-ሰራሀ ግያ ሳን ደእያ አ ላታ ጋድያን ሞጌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","ሄ የለታ ኡባይ ሀይቂ ባረ ማይዛን ጋከቴዳዋፐ ጉይያን፥ መꬍና ጎዳ ዎይ እስራኤልያ አሳዉ እ ኦꬄዳዋ ኡባ ኤረና ሀራ የለታይ ደንዴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","ሄዋፐ ጉይያን፥ እስራኤልያ አሳይ መꬍና ጎዳ ስንꬃን ኢታባ ኦꬄዳ፤ ባኣላ ጌተትያ ኤቃቶ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","ግብጼ ጋድያፐ ኡንቱንታ ከሴዳ መꬍና ጎዳ፥ ባረንቱ ማይዛ አዎቱዋ ጾሳ አግ ባሼድኖ፤ ባረንቱ ዩሹዋን ደእያ አሳቱዋ ኤቃቱዋኮ ስሚደ፥ ኡንቱንቶ ጎይኔድኖ፤ ሄዋን መꬍና ጎዳ ሀንቀꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","ቃይ አ አግ ባሺደ፥ ባኣላዉነ አስታሮታዉ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","ያትና፥ መꬍና ጎዳ ሀንቁ እስራኤልያ አሳ ቦላ ኤጽ ከሴዳ፤ ቦንቂያዋንቱ ቦንቃናዳን ኡንቱንታ በስ ባሼዳ፤ ኡንቱንቱ ዩሹዋን ደእያ ሞርከቶ ኡንቱንታ አꬂደ እሜዳ። ያትና፥ ኡንቱንቱ ባረንቱ ሞርከቱዋና ኤቀታናዉ ዳንዳይበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","ኡንቱንቱ ኦለታናዉ ከሴዳ ዎደ ኡባን፥ መꬍና ጎዳይ ካሰ ኡንቱንቶ ጫቄዳዋዳን ኡንቱንቱ ጾነታና ማላ፥ እ ኡንቱንቱ ቦላ ደንዴዳ። ያትና፥ ኡንቱንቱ ሎይꬅ ዋየꬄድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","ያትና፥ መꬍና ጎዳይ ዳናቱዋ ኡንቱንቶ ደንꬄዳ፤ ኡንቱንቱ እስራኤልያ አሳ ቦንቄዳዋንቱ ኩሽያፐ አሼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","ሽን እስራኤልያ አሳይ ፕርድያ ዳናቶ አዛዘትቤና፤ ኡንቱንቱ መꬍና ጎዳዉ አማነተናን እጼድኖ፤ ሀራ ጾሳቱዋኮ ስሚደ፥ ኡንቱንቶ ጎይኔድኖ። ኡንቱንቱ አዎቱ ሀመቴዳ ኦግያፐ ኤለካ ጉየ ስሜድኖ፤ ኡንቱንቱ ማይዛ አዎቱ ጾሳዉ አዛዘቴዳዋዳን፥ ኡንቱንቱ አዛዘትበይክኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","መꬍና ጎዳይ ኡንቱንቶ ፕርድያ ዳናቱዋ ደንꬄዳ ዎደ አዉደነ እ ሄ ፕርድያ ዳናቱዋና እትፐ ግዴዳ፤ ሄ ዳናይ ደኡዋን ደኤዳ ላይꬃ ኡባን ኡንቱንቱ ሞርከቱዋ ኩሽያፐ ኡንቱንታ አሼዳ። አያዉ ጎፐ፥ ኡቁናይነ ቱጋይ ዳርና፥ ኡንቱንቱ ዋስያዋ ስሲደ፥ መꬍና ጎዳይ ኡንቱንቶ ቃረቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","ሽን ፕርድያ ዳናይ ሀይቄዳዋፐ ጉይያን፥ አሳይ ጉየ ስሚደ፥ ካሰ ኡንቱንቱ አዎቱ ኦꬄዳ ኢታፐ አꬌዳ ኢታ ኦꬄድኖ፤ ኡንቱንቱ ሀራ ጾሳቱዋኮ ስሚደ፥ ኡንቱንቶ ጎይኔድኖ፤ ባረንቱ ኢታ ኦሱዋነ ደሻ ኦግያ አገናን እጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","መꬍና ጎዳ ሀንቁ እስራኤልያ አሳ ቦላ ኤጽ ከሴዳ፤ ያትና፥ መꬍና ጎዳይ ሀዋዳን ያጌዳ፤ “ሀ አሳይ ታን ኡንቱንቱ ማይዛ አዋቶ ገሌዳ ጫቁዋ መንꬄዳ ድራዉነ ታዉ አዛዘተናን እጼዳ ድራዉ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","ሀቼፐ ዶምና፥ ኢያሱ ሀይቄዳ ዎደ ቢታ ቦላን አቴዳ ጋደ አሳቱዋፐ እቱዋነ ታን ኡንቱንቱ ስንꬃፐ የደርሳደ ከስከ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","ሀ እስራኤልያ አሳይ ካሰ ባረንቱ ማይዛ አዎቱዋዳን ታ ኦግያ ካልንቶ፥ ዎይ ካለነንቶ ፓጫናዉ፥ መꬍና ጎዳይ ሄ አቴዳ ጋደ አሳቱዋን ጎኤታና” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","ሄዋ ድራዉ፥ መꬍና ጎዳይ ሄ ጋደ አሳቱ ከሰናን ጋምአናዳን ኦꬄዳ። እ ኡንቱንታ ኤለካ የደርሲደ ከስቤና፤ ኢያሱዉካ ኡንቱንታ አꬂደ እምቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","ካሰ ካናነን አይ ኦላነ ኦለቲደ ሜዘትቤና እስራኤልያ አሳ ፓጫና ማላ፥ መꬍና ጎዳይ ሀ አሳቱዋ አሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","እ ሄዋ ኦꬄዳዌ፥ ሀዋፐ ካሰ ኦላ ኦለቲደ ሜዘትቤና እስራኤልያ የለታ ኦለትያ ሂላ ታማርሳናሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","ሄ አሳቱ ኦና ኦኔ ጎፐ፥ እቼሹ ፕልስጼማ ካታማቱዋ ሞድያ አሳቱዋ፥ ካናነቱዋ ኡባ፥ ሲዶና ካታማ አሳቱዋነ ባኣል-ሄርሞነ ጌተትያ ደርያፐ ዶሚደ፥ ሀማታ ፕኑዋ ጋካናዉ ልባኖሳ ደርያን ደእያ ሂዌቱዋ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","መꬍና ጎዳይ ሙሴ ባጋና ካሰ እስራኤልያ ማይዛ አሳ አዋቶ እሜዳ አዛዙዋ ኡንቱንቱ አዛዘትንቶ አዛዘተነንቶ ፓጭሳናዉ ኡንቱንታ አሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","ያትና፥ እስራኤልያ አሳይ ካናነቱዋና፥ ሂዌቱዋና፥ አሞረቱዋና፥ ፓርዘቱዋና፥ ሂተቱዋናነ ያቡሳቱዋና እትፐ ደኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","ኡንቱንቱ ማጫ ናና ባረንቶ አኬድኖ፤ ባረንቱ ማጫ ናናካ ኡንቱንቱ አቱማ ናናቶ እሜድኖ። ያቲደ ኡንቱንቱ ጾሳቶ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","እስራኤልያ አሳይ መꬍና ጎዳ ስንꬃን ኢታባ ኦꬄዳ። ኡንቱንቱ መꬍና ጎዳ ባረንቱ ጾሳ ዶጊደ፥ ባኣላነ አሼሮ ጌተትያ ጾሳቶ ጎይኔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","ሄዋ ድራዉ፥ መꬍና ጎዳ ሀንቁ እስራኤልያ አሳ ቦላ ኤጽ ከሴዳ፤ ያትና፥ መꬍና ጎዳይ ማስጰጾምያ ጋድያ ካትያ ኩሻን-ርሽአታይማ ኩሽያን ኡንቱንታ አꬂደ እሜዳ፤ ኡንቱንቱ አዉ ሆስፑን ላይꬃ ሞደቴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","ሽን እስራኤልያ አሳይ መꬍና ጎዳዉ ዋሴዳ ዎደ፥ ኡንቱንታ አሽያ ኡራ ኪቴዳ፤ እካ ካሌባ ቴፋ እሻ ቃናዛ ናኣ ኦትንኤላ ጌተቴ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","መꬍና ጎዳ አያናይ አ ቦላ ዎꬍና፥ እ እስራኤልያ ቦላ ፕርድያ ዳና ግዴዳ። ኦላ ኦለታናዉ ቤዳ፤ መꬍና ጎዳይ ማስጰጾምያ ጋድያ ካትያ ኩሻን-ርሽአታይማ አዉ አꬂደ እሜዳ፤ ኩሻን-ርሽአታይማ ጾኔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","ያትና፥ ጋዲ ኦይታሙ ላይꬃ ዎፓ ደሜዳ። ሄዋፐ ጉይያን፥ ቃናዛ ናአይ ኦትንኤል ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","እስራኤልያ አሳይ ዛረꬂደካ መꬍና ጎዳ ስንꬃን ኢታባ ኦꬄዳ። መꬍና ጎዳ ስንꬃን ኡንቱንቱ ኢታባ ኦꬄዳ ድራዉ፥ መꬍና ጎዳይ ሞኣበ ካትያ ኤግሎን እስራኤልያ ቦላን ዎልቃማናዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","ኤግሎን አሞናቱዋነ አማሌቃቱዋ ባረኮ ሺሽ ቢደ፥ እስራኤልያ አሳ ኦለቲደ ጾኔዳ፤ ዛምባ ካታማ ጌተትያ እያርኮ ካታማ ኦይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","ያትና፥ እስራኤልያ አሳይ ሞኣበ ካትያ ኤግሎናዉ ታማነ ሆስፑን ላይꬃ ሞደቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","ሽን እስራኤልያ አሳይ መꬍና ጎዳዉ ዋሴዳ ዎደ፥ ኡንቱንታ አሽያ ኡራ ኪቴዳ፤ እካ ቢንያማ ዛርያፐ ጌራ ናኣ ኤሁዳ ጌተቴ፤ እ ሀድርሳ ኩሽያን ኦꬅያ አሳ። እስራኤልያ አሳይ ኤሁዳ ሞኣበ ካትያ ኤግሎናኮ ጊራና ኪቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","ኤሁድ ላኡ ባጋና ቃራቴዳ እት ዋꬋ ግዴዳ ማሻ ባረዉ ጊግሴዳ፤ ኡሸቻ ምይያ ባጋና ባረ ማዩዋ ግዶን ዳንጬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","ሄዋፐ ጉይያን፥ ሞኣበ ካትያ ኤግሎናዉ ጊራ አክ አፊደ እሜዳ። ኤግሎን ሎይꬅ ኦርዶ አሳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","ኤሁድ ጊራ ካትያዉ እሜዳዋፐ ጉይያን፥ ጊራ ቶኪደ ቤዳ አሳቱዋ ሞይዜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","ሽን ኤሁድ ገልጋላ ማታን ደእያ ማሰቴዳ ሹቻቱዋ ማታፐ ኤግሎናኮ ጉየ ስም ቢደ፥ “ካትያዉ፥ ታን ነዉ ጹርያባይ ደኤ” ያጌዳ። ካቲ፥ “ጮኡ ጋ!” ያጌዳ፤ ሄዋፐ ጉይያን አ ናግያዋንቱ ኡባይ ካረ ከሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","ሄ ዎደ ካቲ ፖቅያን ደእያ እት ክፍልያን ባረካ ኡት ደእሽን፥ ኤሁድ አኮ ሺቂደ፥ “ጾሳይ ነዉ ኪቴዳባይ ደኤ” ያጌዳ። ካቲ ባረ ኡቴዳ ሳኣፐ ኤቄዳ፤ ");
INSERT INTO dwrENT_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","ኤሁድ ባረ ሀድርሳ ኩሽያ የዲደ፥ ኡሸቻ ባጋ ምይያፐ ማሻ ሾዲደ፥ ካትያዉ ኡሉዋን ድርግንꬅ አጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","ያትና፥ ማሻዉ ቱቲ አተናን ኡሎ ግዶ ገልና፥ ሀንዳይ ካሜዳ። ኤሁድ ማሻ ካትያ ኡሉዋፐ ሾድቤና ድራዉ፥ ዞክያና ካንꬅ ከሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","ሄዋፐ ጉይያን ኤሁድ ካረ ከሲደ፥ ፖቅያን ደእያ ክፍልያ ፐንግያ ጎርዲደ፥ አ ቦላ ቁልፔዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","እ ብድጎዋፐ ጉይያን፥ ቆማቱ ዪደ፥ ፐንጊ ጎርደቴዳዋ በኤድኖ፤ ግዶ ክፍልያን ኡርቃ ሼሻዉ ኡተናን አገና ያጊደ ቆፔድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","ኡንቱንቱ ናጉ ፖካና ጋካናዉ ሎይꬅ ናጌድኖ። ሽን ካቲ ፐንግያ ዶየናን እጽና፥ ቁልፕያ አኪደ ፐንግያ ዶዬድኖ፤ ባረንቱ ጎዳይ ሀይቂደ፥ ዉይግያን ኩንዴዳዋ በኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","ኡንቱንቱ ናጊደ ጋምእ ደእሽን፥ ኤሁድ ከስ አኪደ፥ ማሰቴዳ ሹቻቱዋ አꬊደ፥ ሳኢራ ግያ ሳኣ ባቃቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","ኤፍሬማ ገዝያ ጋኬዳ ዎደ፥ እስራኤልያ አሳይ ኦላዉ ሺቃናዳን ማላካታ ፑኔዳ፤ አሳይ አ ካሊደ፥ ያፐ ዱገ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","ኡንቱንታ፥ “ታና ካልተ፤ አያዉ ጎፐ፥ መꬍና ጎዳይ ህንተንቱ ሞርከቱዋ፥ ሞኣባቱዋ ህንተንቱ ኩሽያን አꬂደ እሜዳ” ያጌዳ። አ ካሊደ ዎꬊደ፥ ዮርዳኖሳ ሻፋ ፕንያ ሳአቱዋ ኦይቄድኖ፤ ሞኣበ አሳፐ እት ኡራይነ ሄዋና አናዳን ተኤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","ሄ ዎደ ሞኣበ አሳፐ ታሙ ሻአ ግድያ ዶረቴዳ ምኖ ኦላንቻቱዋ ዎꬌድኖ፤ እት አሳይነ ከስ አክ አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","ሄ ጋላስ ሞኣበ አሳይ እስራኤልያ አሳዉ ሞደቴዳ፤ ያትና ቢታይ ሆስፑን ታሙ ላይꬃ ዎፓ ደሜዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","ኤሁዳፐ ጉይያን፥ አናታ ናአይ ሻምጋር ደንዴዳ፤ ፕልስጼማ አሳፐ ኡሱፑን ጼቱዋ ቦራ ላግያ ዶቁዋን ዎꬊደ፥ እስራኤልያ አሳ አሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","ኤሁድ ሀይቄዳዋፐ ጉይያን፥ እስራኤልያ አሳይ መꬍና ጎዳ ስንꬃን ዛረꬂደካ ኢታባ ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","ሄዋ ድራዉ፥ መꬍና ጎዳይ ሀጾራ ጌተትያ ካታማን ካተቴዳ ካናነ ካትያ ያብናያዉ ኡንቱንታ አꬂደ እሜዳ፤ አ ኦላንቻቱዋ ጋዳዉ ስሳር ደርያ-ሀሮሼታ-ሀጎዪማ ጌተትያ ካታማን ደኤ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","ያብናያ ብራታፐ ኦሰቴዳ ኡዱፑን ጼቱ ፓራ ጋረቱ ደእያ ድራዉነ እ እስራኤልያ አሳ ቃረት ባይናን ላታሙ ላይꬃ ኡቁኔዳ ድራዉ፥ ኡንቱንቱ ማዱዋ ደማናዉ መꬍና ጎዳኮ ዋሴድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","ሄ ዎደ ላፕዶታ ማቻታ ድቦራ፥ ትምቢትያ ኦድያና እስራኤልያ ቢታን ፕርድያ ዳናቶ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","ድቦራ ኤፍሬማ ገዝያን፥ ራማ ካታማፐነ ቤቴለ ካታማፐ ግዱዋን ደእያ ድቦር ዛምባ ጋርሳን ኡታደ ፕርዳዉ፤ እስራኤልያ አሳይ ባረ የዉዋ ፕርድሳናዉ ኢኮ ዬ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","እት ጋላስ ደቦራ አብኖኣማ ናኣ ባራቃ ንፍታሌማ ጋድያን ደእያ ቀዴሻ ካታማፐ ኪታደ ጼስሳዱ፤ “መꬍና ጎዳይ እስራኤልያ ጾሳይ ኔና ሀዋዳን ያጊደ አዛዜ፤ ‘ንፍታሌማ ዛርያፐነ ዛብሎና ዛርያፐ ታሙ ሻአ አሳ አካደ፥ ታቦራ ደርያ ባ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","ታን ያብና ኦላንቻቱዋ ጋዳዋይ ስሳር ፓራ ጋረቱዋነ ኦላንቻቱዋ አኪደ፥ ቂሾና ሻፋን ኔናና ኦላ ጋከታናዉ ያናዳን ኦꬃና፤ ታን ነዉ አ አꬃደ እማና’ ያጌ” ያጋዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","ያትና፥ ባራቅ፥ “ኔን ታናና ቦፐ፥ ታን ባና፤ ሽን ኔን ታናና ባና ꬋዮፐ፥ ታንካ ቢከ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","አ፥ “ኤኖ፥ ታን ኔናና ባና፤ ሽን መꬍና ጎዳይ ስሳራ ማጫ አሳ ኩሽያን አꬂደ እምያ ድራዉ፥ ሄ ቡሳይ ነዉ ቦንቾ ግደና” ያጋዱ። ደቦራ ደንዳደ፥ ባራቃና ቀዴሻ ባዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","ባራቅ ንፍታሌማነ ዛብሎና ዘረꬃ ቀዴሻ ጼስና፥ ታሙ ሻአ አሳይ አ ካሊደ ከሴዳ፤ ድቦራካ አናና ባዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","ሄ ዎደ ሄቤራ ጌተትያ እት ብታኒ ደኤ፤ እ ቄና አሳ፤ እ ሙሴ ቦሉዋ ሆባባ ያራ። እ ሀራ ቄናቱዋፐ ሻከቲደ፥ ቀዴሻኮ ሺቂደ፥ ዛእናኒማን ደእያ ዎላ ማታን ባረ ዱንካንያ ꬎጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","አብኖኣማ ናአይ ባራቅ ታቦራ ደርያ ቤዳዋ ስሳር ስሴዳ ዎደ፥ ");
INSERT INTO dwrENT_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","ብራታፐ ኦሰቴዳ ባረ ኡዱፑን ጼቱ ፓራ ጋረቱዋነ ባረናና ደእያ አሳ ኡባ ጼስሲደ፥ ሀሮሼታ-ሀጎዪማፐ ቂሾና ሻፋ ሺሼዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","ያትና፥ ድቦራ ባራቃ፥ “ደንዳ! ሀቼ መꬍና ጎዳይ ነ ኩሽያን ስሳራ አꬂደ እምያ ጋላሳ። በአ፥ መꬍና ጎዳይ ኔፐ ስንꬃቲደ ቤዳ” ያጋዱ። ሄዋፐ ጉየ ባራቅ ታሙ ሻአ አሳ ካለꬂደ፥ ታቦራ ደርያፐ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","መꬍና ጎዳይ ስሳራ፥ አ ፓራ ጋረቱዋ ኡባነ አ ኦላንቻቱዋ ኡባ ቃራ ማሻን ባራቃ ስንꬃፐ ባቃትሴዳ። ያትና፥ ስሳር ባረ ፓራ ጋርያፐ ዎꬊደ፥ ገድያን ባቃቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","ባራቅ ሄ ፓራ ጋረቱዋነ ኦላንቻቱዋ ሀሮሼታ-ሀጎዪማ ጋካናዉ የደርሴዳ። ስሳራ ኦላንቻቱ ኡባይ ቃራ ማሻን ሀይቄድኖ፤ እት አሳይነ አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","ሄ ዎደ ሀጾራ ካትያ ያብን ቄና ሄቤራ ጎለ አሳና ሳሮ ደኤ። ሄዋ ድራዉ፥ ስሳር ገድያን ባቃቲደ፥ ቄና ሄቤራ ማቻት ያኤል ዱንካንያ ጋኬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","ያኤላ ስሳራ ሞካናዉ ከሳደ፥ “ታ ጎዳዉ፥ ገላ፤ ሃ ገላ፤ ያዮፓ” ያጋዱ። ዱንካንያ ኢኮ ገልና፥ አ ባረ ቡሉኩዋን ካማዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","ስሳር፥ “ታና ሳሜ፤ ኡሽያ ጉꬃ ሃꬃ እማርኪ” ያጌዳ። ማꬃ ትግያ ሚሻ ፖካደ ኡሻዱ፤ ያታደ ዛራደ ካማዱ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","ሄዋፐ ጉይያን እ እዞ፥ “ዱንካንያ ፐንግያን ኤአ። አይ አሳይ ዪደ፥ ‘ሀዋን አሳይ ደኢ?’ ያጊደ ኦቾፐ፥ ‘ባዋ’ ጋ” ያጌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","ስሳር ሎይꬅ ዳቡሬዳ ድራዉ፥ ገምእሹዋ ፓኑሬዳ። ሄቤራ ማቻታ ያኤላ ማዶሻነ ዱንካንያ ꬎግያ ሽካሊያ አካደ፥ ሎዳን አኮ ሺቃዱ፤ ሺቃደ ꬎግያ ሽካልያ ሀይꬃ ካርያን ኤሳደ፥ ማርቴሉዋን ꬍሻደ፥ ቢታና ስክና፥ ስሳር ሀይቄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","ባራቅ ስሳራ ኮዪደ ዪና፥ ያኤላ አ ሞካናዉ ካረ ከሳደ፥ “ሃያ፤ ኔን ኮይያ ብታንያ ታን ኔና በሳና” ያጋዱ። እዝና ዱንካንያ ግዶ ገሊደ፥ ስሳራ ሀይꬃ ካርያን ꬎጉ ገልና፥ አ አሃይ ሳኣን ግሴዳዋ በኤዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","ሄ ጋላስ ጾሳይ እስራኤልያ አሳይ ካናነ ካትያ ያብና ጾናናዳን ኦꬄዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","እስራኤልያ አሳይ ካናነ ካትያ ያብና ቦላ ምን ምኒደ ቢደ፥ ዉርሰꬃን አ ꬋይሴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","ሄ ጋላስ ድቦራነ አብኖኣማ ናአይ ባራቅ ሀ የꬃ የጼድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“እስራኤልያ አሳ ካለꬅያዋንቱ ካለꬄዳ ድራዉ፥ አሳይካ ዶሲደ፥ ባረ ሁጲያ አꬂደ እሜዳ ድራዉ፥ መꬍና ጎዳ ጋላትተ! ");
INSERT INTO dwrENT_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","“ህንተንቶ ካተቶ፥ ሀዋ ስስተ! ህንተንቶ ደርያ ሞድያዋንቶ፥ ሀይዝተ! ታን መꬍና ጎዳዉ የጻና። መꬍና ጎዳዉ እስራኤልያ ጾሳዉ ጋላታ የꬃ የጻና። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","አቤት መꬍና ጎዳዉ፥ ኔን ሰኢራ ደርያፐ ደንዴዳ ዎደ፥ ኔን ኤዶማ ቢታፐ ከሴዳ ዎደ፥ ቢታይ ቃጼዳ። ሳሉዋፐ እራይ ቡኬዳ፤ ኤ፥ ሃꬃይ ሻረቱዋፐ ዱገ ሶሶቴዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","መꬍና ጎዳ ስንꬃን ደረቱ ቃጼድኖ፤ ሀራይ አትና፥ ሲና ደሪካ መꬍና ጎዳ እስራኤልያ ጾሳ ስንꬃን ኮኮሬዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","“አናታ ናኣ ሻምጋና ዎደነ፥ ያኤላ ዎደ ጫና መህያ ላግያ፥ ዛልአንቻቱ ሄ ቢታና አꬍበይክኖ። ኦግያና ብያዋንቱካ ኦግያ አጊደ፥ ሎሱዋና ቤድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","እስራኤልያ ካታማቱ አሳይ ደኤና ሳኣ ግዴድኖ። ታን ድቦራ፥ ታን እስራኤልያ አሳዉ፥ አቶ ግዳደ ደንዳና ጋካናዉ ኦንነ አትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","እስራኤልያ አሳይ አላጋ ጾሳቱዋ ዶሬዳ ዎደ፥ ጋድያን ኦላይ ደንዴዳ። ኦይታሙ ሻአ እስራኤልያ ኦላንቻቱዋ ግዱዋን እት ጎንዳሊ ዎይ እት ቶር ቤትቤና። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","ታ ዎዛናይ እስራኤልያ ኦላ ጋዳዋቱዋና ደኤ። አሳ ግዶን ዶሲደ ባረንታ አꬂደ እሜዳዋንቱና ደኤ። መꬍና ጎዳ ጋላትተ! ");
INSERT INTO dwrENT_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","ህንተንቶ፥ ቦꬃ ሀረቱዋ ቶግያዋንቶ፥ ህንተንቶ፥ ግላስያ ቦላን ኡቴዳዋንቶ፥ ኦግያና ሀመትያዋንቶ፥ ሀዋ ስስተ! ");
INSERT INTO dwrENT_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","ሃꬃ ኦላቱዋ ማታን ሺቄዳ የꬃንቻቱዋ የꬃ ስስተ። ኡንቱንቱ መꬍና ጎዳይ ጽሎተꬃ ኦሱዋባ የጺኖ፤ ቃይ እስራኤልያ ኦላንቻቱዋ ጽሎተꬃ ኦሱዋባ የጺኖ። “ሄዋፐ ጉይያን፥ መꬍና ጎዳ አሳይ ካታማ ገልያ ፐንገቱዋኮ ዱገ ዎꬌዳ። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","ድቦሬ! ቤጎታ! ቤጎታ! ቤጎታ! ቤጎታደ ማዝሙርያ የጻ። ባራቃ፥ ደንዳ! ኔኖ፥ አብኖኣማ ናአዉ፥ ነ ኦሞዱዋ አካደ ያ። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","“ሄዋፐ ጉይያን፥ አቴዳ አሳቱ ካፓቱዋኮ ዱገ ዎꬌድኖ። መꬍና ጎዳ አሳቱ ኦለታናዉ ጊጊደ ድቦርኮ ዬድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","አማሌቃ ዛራቱ በን ደኤዳ ሳኣን ደእያ፥ ኤፍሬማ አሳቱ ዬድኖ። ቃይ ቢንያማ አሳቱ ኡንቱንታ ካሌድኖ። ካፓቱ ማክራ ዛራቱዋፐነ፥ ኦላ ጋዳዋቱ ዛብሎና ዛራቱዋፐ ዱገ ዎꬌድኖ። ");
INSERT INTO dwrENT_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","ይሳኮ