﻿USE sofia;
DROP TABLE IF EXISTS sofia.duo_vpl;
CREATE TABLE duo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES duo_vpl WRITE;
INSERT INTO duo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ide dan i lista na minappo ni Jesu-Cristu, a naggipu ha kaputotan na a ni Hari Dabid, a naggipu paman ha kaputotan na a ni Abraham. ");
INSERT INTO duo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Idagende i kaputotan a naggipu ha ni Abraham hanggan ha ni Hari Dabid. Atoy ni Abraham a hama ni Isak. Sa ni Isak i hama ni Jakob. Sa ni Jakob i hama ni Juda ken wawaddi na. ");
INSERT INTO duo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ni Juda i hama di Pares ken Sara. (Ni Tamar i hena di.) Sa ni Pares i hama ni Esrom, a hama ni Aram. ");
INSERT INTO duo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Sa ni Aram i hama ni Aminadab, a hama ni Naason, a hama ni Salmon. ");
INSERT INTO duo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sa ni Salmon i hama ni Boas (ni Rahab i hena na). Ni Boas i hama ni Obed (ni Rut i hena na). Ket ni Obed i hama ni Jesse, ");
INSERT INTO duo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","a hama ni Dabid a nagbalin a hari. Niyaen, Ni Dabid i hama ni Solomon. (I hena ni Solomon i kabanga ni Urias idi.) ");
INSERT INTO duo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Ni Solomon i hama ni Roboam. Ket inumunod ni Abiyas a hama ni Asa a hama ni Josapat a hama ni Joram a hama ni Osiyas a hama ni Joatam a hama ni Akas a hama ni Esekiyas a hama ni Manases a hama ni Amon a hama ni Josiyas. Ni Josiyas i hama ni Jekoniyas ken wawaddi na a neenak idi tiyempo a naabak i Judyo a hidi, a nadakap ken nebalud hidi, a neyangay hidi ha bayan a Babiloniya. ");
INSERT INTO duo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Niyaen, idagende i kaputotan idi kobosan na pinakeyangay na Judyo a hidi ha bayan a Babiloniya, hanggan ha pinakeenak ni Jesus. Atoy di Jekoniyas, Salatiyel, Sorobabel, Abiyud, Eliyakim, Asor, Sadok, Akim, Eliyud, Eleyasar, Matan, Jakob, ken Jose a kabanga ni Maria, a hena ni Jesus, a managenan ha Cristu, a pinaangay na Dios penu isalakan na kitam. ");
INSERT INTO duo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Isu, atoy i esapulo ket uppat a kaputotan, naggipu ha ni Abraham hanggan ha ni Dabid. Ket atoy pala i esapulo ket uppat a kaputotan, a naggipu ha ni Dabid hanggan ha pinakeyangay na Judyo a hidi ha bayan a Babiloniya. Ket atoy manon i esapulo ket uppat a kaputotan, naggipu ha pinakeyangay na Judjudyo ha Babiloniya hanggan ha pinakeenak ni Cristu. ");
INSERT INTO duo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Niyaen, kona ihe i pinakeenak ni Jesu-Cristu. Nesakad dan ni Maria a hena na a makikabanga ha ni Jose. Ngem idi awan pala hidi nagkabanga, nakatandiyan ni Maria a naginaw dan i baggi na gipu ha kaddat na Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ket gipu ta mappiya i kinatolay ni Jose, madiyan na a pasanikiyan ni Maria. Isu, awan na pinaliwat, ngem kayat na la a isina a sililimed, a awan mina ha makatandi. ");
INSERT INTO duo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ket idi nanakaman na pala ide, nagpaenta ha nikuna i esa a anghel na Dios ha tagenap na. Kinagi na anghel, “Jose a apo ni Dabid, awan ka mina maburibur a mangiboda ha ni Maria. Ta awan ha nagpainaw ha nikuna, nu awan i Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ket nokkan, mageenak ni Maria ha esa a lallaki. Ket panagenan mo hikuna ha ‘Jesus’, ta hikuna i mangisalakan ha sakop na a totolay ha liwaliwat di,” kon na anghel. ");
INSERT INTO duo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Niyaen, nagimet ito ngamin ha ni Maria, penu matungpal i kinagi na Dios gipu ha ni Isayas, a esa a minahagpugto. ");
INSERT INTO duo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Kinagi na, “Maginaw i esa a madiket, maski awan hikuna pabikanan ha lallaki. Ket mageenak hikuna ha esa a lallaki a mapanagenan ha ‘Emanuel.’” (Kayat na a kagiyan, “Atoy ha nikitam i Apo Dios.”) ");
INSERT INTO duo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Idi inumikat ni Jose, tinungpal na i inpeta na anghel, a neboda na ni Maria. ");
INSERT INTO duo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngem awan hidi nagduhog hanggan neenak dan i annak na. Ket pinanagenan ni Jose i annak aye ha “Jesus.” ");
INSERT INTO duo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Niyaen, neenak ni Jesus ha ili a Betlehem, ha probinsiya a Judeya, idi tiyempo ni Hari Herodes. Ket idi tiyempo hito, idi awan naalay kobosan na pinakeenak na, ket atoy i kappal a malaing a lallaki a taga-daya, a inumangay ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Idi kaddemat di ha Jerusalem, sinalodsod di, “Hadya i henan na neenak a hari na Judjudyo? Ta naenta mi dan i pusiyan na a nagpaenta ha daya. Ket gipu ha ide a tiplad, nakatandiyan mi a neenak dan hikuna. Ket inumangay kami a magdeyaw ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Idi nabaheta ni Hari Herodes i kinagi di, nanteng hikuna unay. Ta kagin na a masulitan hikuna a maghari. Ket kona bila hito ha ngamin a agagum na ha Jerusalem, a nagburibur hidi nu anya i magimet. ");
INSERT INTO duo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Isu, pinaayagan na i ngamin a matangkay a papadi ken mamaestro na Linteg. Ket sinalodsod na nu hadya kan i pakaenakan na Cristu a inkari na Dios a paangayan na. ");
INSERT INTO duo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ket inpeta di ha nikuna, “Ha ili a Betlehem, ha Judeya. Ta atoy i nesurat na minahagpugto, nikuna a naalay dan, ");
INSERT INTO duo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ha Betlehem, ha probinsiya a Judeya, ito i madeyawan a lugar ha ngamin a Judeya. Ta Betlehem i pakaenakan nokkan na esa a magturay ken magdapon ha sakop ko a Israel,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Idi nateman na ito ni Herodes, inayagan na idagenday a sangaili a taga-daya, ket inuhon na hidi a nalimed. Sinalodsod na nu hanggan a nagpaenta ha nidi iday a pusiyan a pagtiplad. ");
INSERT INTO duo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Idi nakatandiyan ni Herodes, pinaangay na hidi ha Betlehem. Ket inbon na ha nidi, “Hen kam a mageriyok ha annak heya. Ket nokkan, nu naeriyokan moy, sumoli kam ihe, ket ipeta moy ha nikan, penu makaangayak bila a magdeyaw ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Niyaen, pakateman di ha bon aye na hari, ket linumapos idagenday a taga-daya. Ket idi linumakad hidi ha dilan, naenta di manon iday a pusiyan a nagpaenta ha nidi ha daya. Ket natalak hidi unay, gipu ha pusiyan aye. Ket ingiya na hidi na pusiyan, hanggan ginumimak hikuna ha batug na henan na annak. ");
INSERT INTO duo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kaddemat di, ket sinumadap hidi ha bilay, ket naenta di i annak ken ni Maria a hena na. Ket nagparentumeng hidi a nagdeyaw ha nikuna. Kobosan na, inlapos di idagende a sagsagut di, a balitok, ken pangpasahob a insenso, ken pangpuhet a mirra. Ket inyatad di idagende ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kobosan na ito, pinagtagenap na hidi na Dios, a iniwadan na hidi a awan mina hidi magsoli ha ni Herodes. Isu, naglakad hidi ha sabali a dilan, a nagsoli ha bayan di. ");
INSERT INTO duo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Idi naglakad i malaing a hidi a taga-daya, nagtagenap manon ni Jose. Ket nagpaenta i esa a anghel na Dios ha tagenap na. Kinagi na, “Umikat ka dan, ket itugan mo a dagus ide a annak ken hena na ha Egipto. Maghen kam mina ha Egipto hanggan ipeta ko a makasoli kam. Ta paeriyok ni Herodes i annak aye, penu papapatay na.” ");
INSERT INTO duo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Isu, inumikat ni Jose, ket ha iday a kallap, intugan na hidi a patena, a inumangay hidi ha Egipto. ");
INSERT INTO duo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Naghen hidi ha Egipto hanggan natay ni Hari Herodes. Nagimet i ngamin a dagento, penu matungpal i kinagi na Apo Dios gipu ha ni Hoseya a esa a minahagpugto. Nesurat na ha Libro na Dios, a “Ayagan ko i Anak ko, a lumapos ha Egipto,” kon na Dios. ");
INSERT INTO duo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Idi nakatandiyan ni Herodes a linoko na hikuna na malaing a hidi a lallaki, nagingal hikuna unay. Ket pinaangay na i sundalu na a hidi, a patayan di i ngamin a annak a lallaki ha ili a Betlehem, ken ha ngamin a lugar ha palebut na. Isu a pinatay di i ngamin a bigu a neenak, hanggan duwa a tawen i idad di. Ta duwa a tawen i nakalipas dan, nangrugi idi pinakaenta na malaing a hidi a lallaki ha iday a pusiyan. ");
INSERT INTO duo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ket gipu ta kona hito, natongpal i kinagi na minahagpugto a ni Jeremiyas, ");
INSERT INTO duo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Makpal i magngongoy-ngoy ha ili a Rama. Magsangisanget i apapo ni Rakel, gipu ta natay dan i annak di. Awan hidi maliwliwa, ta awan dan i annak a hidi.” ");
INSERT INTO duo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kobosan na pinakatay ni Herodes, nagpaenta manon i esa a anghel na Dios ha ni Jose, ha Egipto, ha tagenap na. ");
INSERT INTO duo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kinagi na anghel, “Umikat ka dan, a sumoli kam a pattama ha bayan moy a Israel. Ta minatay dan i hari a nagpanggep a mangpapatay ha ide a annak.” ");
INSERT INTO duo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Isu, inumikat ni Jose, ket inalap na i patena, a nagsoli hidi ha Israel. ");
INSERT INTO duo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ngem nanteng ni Jose idi nabaheta na a ni Arkelao i maghari ha Judeya, ta hikuna i kasulet na hama na a Herod. Ket gipu ha tagenap na, naiwadan manon ni Jose, a intugan na i patena ha probinsiya a Galileya. ");
INSERT INTO duo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ket naghen hidi hito, ha ili a Nasaret. Ket gipu ta kona hito, natongpal i kinagi na minahagpugto a hidi, a “Mepeta nokkan a taga-Nasaret i paangayan na Dios a maghari.” ");
INSERT INTO duo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Idi kobosan na makpal a tawen, inumangay ni Juan a Mahagbinyag ha amugod, ha probinsiya a Judeya, ket nagitoldu hikuna ha totolay. ");
INSERT INTO duo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kinagi na, “Sumina kam ha liwaliwat moy, ta dandani dan a dumemat i paghariyan na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ni Juan i pinagkagiyan ni Propeta Isayas, idi inpugto na, a “Atoy ha amugod i mahagayag. Ket iyayag na, a ‘Dandani a dumemat i Hapo tam. Matalak kamon ha pagdemat na! Papiyaan moy dan i paglakadan na!’ kon na.” Ket kona he i pinagayag ni Juan. ");
INSERT INTO duo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Niyaen, napobre unay ni Juan. I tennon na i nagimet ha buk na hayup a kameliyo. Ket gaddang na hayup i sinturon na. Ket kanan na i haksa a hidi ken habu na pitukan. ");
INSERT INTO duo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ha iday a tiyempo, makpal i inumangay ha henan na, penu magteman ha pagitoldu na. Makpal hidi a naggipu ha Jerusalem, ken ngamin a probinsiya a Judeya, ken ngamin a lugar ha palebut na Karayan Jordan. ");
INSERT INTO duo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nagoni hidi a kelliwat hidi, ket nagbabawi hidi ha liwaliwat di heya. Ket bininyagan na hidi ni Juan ha Karayan Jordan. ");
INSERT INTO duo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ngem atoy bila i makpal a Pariseyo ken Saduseyo a inumangay a magpabinyag mina ha nikuna. Ket kinagi na ha nidi, “Kona kam ha ulag, ta madukas i nakam moy! Apay kam umangay ihe? Siguro kagin moy a makalisi kam ha parusa na Dios. ");
INSERT INTO duo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ngem ipeta ko ha nikam a masapul moy a ipaenta a nagbabawi kamon gipu ha mappiya a gimet moy ken magbabawi kamon a tahod. ");
INSERT INTO duo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ket awan moy ipeta ha baggi moy, a ‘Maski, ta hama mi ni Abraham.’ Ta ipeta ko ha nikam a maski ha dagende a pogedu, kabaelan na Dios a pagbalinan na hidi ha annak ni Abraham. Tahod! ");
INSERT INTO duo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ket niyaen, nakaman moy mina ide, a kona ha wasay i parusa na Dios. Ket kona ha nehektat dan i wasay aye na Dios, penu katolan na i kakayo hanggan ha ramot di. Ket mekalan kam ha dagenday a kakayo a awan magbunga ha mappiya. Ket katolan na nokkan, a itogbak na ha gangatan.” ");
INSERT INTO duo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ket intulos ni Juan, a kinagi na ha nagteman a hidi, “Dinom la i pangbinyag ko ha nikam. Ket pagtiplad ito a nadalusan kamon ha liwaliwat moy. Ngem atoy pala i esa a dandani a dumemat. Ket nu mekalanak ha nikuna, awanak ha balle, ta mannakabalin unay hikuna. Halimbawa: Nu atoy mina i esa a tagabu a magegkam mina ha sapatos na, awanak mehusto gipu ha liwaliwat ko. Hikuna man i magbinyag ha nikam nokkan ha Espiritu na Dios ken gangatan. ");
INSERT INTO duo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nu dumemat hikuna nokkan, pasinaan na i ngamin a totolay. Ket kona ha esa a mannalon a magtap. Ta alapan na i ngamin a tolay, ket kona ha magbigao hikuna a mangitap ha totolay. Ta itap na nokkan i mappiya ken madukas. I mappiya a totolay i kona ha baggat, ngem kona ha lupas i madukas a hidi. Ket alapan na nokkan idagende a mappiya a baggat, ket daponan na hidi ha paghenan na. Ngem awan ha balle idagenday a lupas. Ket itutod na hidi ha gangatan a awan maaddap.” Ide dan i pagitoldu ni Juan. ");
INSERT INTO duo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Idi nakangbinyag ni Juan ha Karayan Jordan, inumangay ni Jesus a naggipu ha Galileya, penu magpabinyag ha ni Juan. ");
INSERT INTO duo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngem pinadas ni Juan a sawayan. Kinagi na ha ni Jesus, “Masanikiyak ha nikaw a magbinyag. Hikan mina i magpabinyag ha nikaw!” ");
INSERT INTO duo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngem kinagi ni Jesus, “Pabiyanan mo iday ha yenan. Ta mappiya malla nu matungpal ta i nalinteg a pagayatan na Dios.” Idi kinagi na ito ni Jesus, nagoni ni Juan, a bininyagan na ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Idi kobosan na pinnakabinyag ni Jesus, ket inumawas hikuna ha dinom, naglukat i langit ha nikuna. Ket naenta na i Espiritu na Dios a inumogsad a kona ha esa a kalapati. Ket nagdissu hikuna ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ket niyaen, atoy i timek a nagkagi ha langit. Kinagi na, “Ide i ayayatan ko a Annak. Matalakak unay ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Idi nobos i pinagbinyag ni Jesus, inturong na hikuna na Espiritu na Dios ha amamugod, penu sulisogan ni Satanas ha ngamin a kaya na. ");
INSERT INTO duo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pulos, awan nagkan ni Jesus ha uppat a pulo a pamalak. Ket nobos ide a tiyempo, nagiyalap unay hikuna. ");
INSERT INTO duo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Binumikan ni Satanas ha ni Jesus, ket kinagi na, “Nu hikaw i Annak na Dios, bonan mo idagende a pogedu a magbalin mina a kanan.” ");
INSERT INTO duo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ngem tinabbeg ni Jesus, “Nesurat ha Libro na Dios, a ‘Bakkan la a kanan i ikabiyag na tolay, nu awan i pagitoldu na Dios i ikabiyag na tolay a tahod,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Niyaen, inyangay ni Satanas ni Jesus ha Jerusalem, ha bubungan na Templo. ");
INSERT INTO duo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ket kinagi na ha ni Jesus, “Nu tahod a hikaw i Annak na Dios, lumakbong ka dan. Ta nesurat ha Libro na Dios, a ‘Bonan na Dios i anghel a hidi a daponan di ka. Ket egkaman na ka na anghel a hidi, penu awan ka mesapdul, maski ha gihagihay mo.’” ");
INSERT INTO duo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ngem tinabbeg ni Jesus, “Nesurat bila ha Libro na Dios, a ‘Awan mo pilitan i Happo moy a Dios.’” ");
INSERT INTO duo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Niyaen, atoy manon i nangiyangayan ni Satanas ha ni Jesus, ket ha ontok na parabin. Ket inpaenta na ha nikuna i ngamin a kahariyan ha ngamin a lugar, ken ngamin a kinainamakan di. ");
INSERT INTO duo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ket kinagi ni Satanas, “Iyatad ko ha nikaw i ngamin a dagende. Basta magparentumeng ka, a magdeyaw ka ha nikan.” ");
INSERT INTO duo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ngem tinabbeg ni Jesus, “Umadiyo ka dan, Satanas. Ta nesurat ha Libro na Dios, a ‘Deyawan mo i Happo mo a Dios, ket hikuna la i pagserbeyan mo.’” ");
INSERT INTO duo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ket sininaan hikuna ni Satanas. Sa, dinumemat i anghel a hidi, a dinaggapan di ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Idi nabaheta ni Jesus a nebalud ni Juan, nagsoli hikuna ha Galileya. ");
INSERT INTO duo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ngem awan hikuna naghen ha Nasaret. Imbes na, inumangay hikuna ha Kapernaum, a esa a ili ha nibik na Diget na Galileya, ha pagbaitan na lugar a Sabulon ken Neptali. ");
INSERT INTO duo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nagimet ito penu matungpal i kinagi ni Propeta Isayas a minahagpugto, ");
INSERT INTO duo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Atoy esa a kona ha silaw ha Galileya, ha lugar a Sabulon ken Neptali, ha paghenan na totolay a nadihaman ha nakam di. Ito i paghenan na bakkan a hidi a Judyo, ha dibelew na Jordan, ha nibik na diget. Ket maski nu kona ha natay dan hidi, gipu ha madiham a nakam di, magbiyag pala hidi. Ta kona ha magpaenta nokkan i esa a mannakabalin a silaw, a magdisyag ken magitoldu ha nidi, penu makatandiyan di i Dios.” ");
INSERT INTO duo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ket natongpal ito a inpugto ni Isayas. Ta nangrugi ni Jesus a magitoldu ha iday a tiyempo. Ket kinagi na, “Magbabawi kamon ken sumina kam ha liwaliwat moy, ta dandani dan a dumemat i Paghariyan na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Idi naglakad ni Jesus ha baybay na Galileya, naenta na i duwa a lallaki a mangisawat ha sigay di. Patakka hidi a ni Simon ken ni Andres. (I sangay ni Simon, ni Pedro.) Mahagpadut hidi. ");
INSERT INTO duo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ket kinagi ni Jesus ha nidi, “Umuseg kam ha nikan a magbalin a tolduwan ko. Ket awan kam mahagalap ha padut, nu awan a mahagpapisan kam ha totolay, penu masakop ko hidi ha Paghariyan na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ket dagus a inwarak di i sigay di, ket inumuseg hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tinumulos di Jesus a maglakad, ket naenta na i sabali a patakka, a di Santiyago ken Juan. Nagagum hidi ha ni Sebedeyo a hama di, a naglugan ha abang, ken nagtaremaan ha sigay di. Niyaen, inayagan na hidi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ket dagus a linakadan di i hama ken abang di, a inumuseg bila hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Niyaen, inumangay ni Jesus ha ngamin a paset na Galileya, a nagitoldu ha kapikapilya na Judyo a hidi. Ket nagpakatandi hikuna ha Mappiya a Baheta megipu ha Paghariyan na Dios. Ket pinahusay na i totolay ha ngamin a sakisaket di. ");
INSERT INTO duo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ket gipu ta kona hito, newaras ha ngamin a probinsiya a Siriya i baheta megipu ha ni Jesus. Ket inyangay na totolay i ngamin a nagsaket: a kona ha nahayop na dimonyo, ken nagkiskissiw, ken napilay a hidi. Ket pinahusay na hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Isu, tinattagubetan hikuna na kakpalan a tolay a naggipu ha Galileya, ken Dekapolis, Jerusalem, Judeya, ken luglugar ha dibelew na Jordan. ");
INSERT INTO duo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Idi naenta ni Jesus i makpal a dumadulog, tinumagdak hikuna ha pukal. Nagetnod hikuna, ket binumikan ha nikuna i tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ket tinolduwan na hidi. Kinagi na, ");
INSERT INTO duo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mahusay i mapadibbi a hidi a makatandi a awan hidi ha kinappiya ha saguppang na Dios nu awan iday a nagipu ha Dios. Ta hidi man i masakopan na ha paghariyan na. ");
INSERT INTO duo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mahusay i maski nu heya a magsanget gipu ha liwaliwat na, ken mayat a magbabawi. Ta paragsakan hikuna na Dios nokkan. ");
INSERT INTO duo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mahusay i napadibbi a hidi, ta atdinan na hidi na Dios nokkan ha ngamin a inkari na. ");
INSERT INTO duo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mahusay i maski nu heya a pumilit a magtungpal ha pagayatan na Dios. Ta aguman na hikuna na Dios. ");
INSERT INTO duo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mahusay i magkagbi a hidi ha kakalan di a tolay, ta makagbiyan bila hidi na Dios nokkan. ");
INSERT INTO duo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mahusay i magnakanakam a hidi ha pagayatan na Dios, ta maenta di nokkan i Dios. ");
INSERT INTO duo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mahusay i makipagtalna a hidi. Ta melasin a hidi i tahod a annak na Dios. ");
INSERT INTO duo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mahusay i malokowan a hidi gipu ha pinangtongpal di ha pagayatan na Dios, ta masakop na hidi na Dios ha paghariyan na. ");
INSERT INTO duo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mahusay kam nu ulewan na kam na totolay, ken nu lolokwan di kam, onu pasanikiyan di kam, onu ipeta di a madukas kam, ta umuseg kam ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Magragsak kam mina nu kona he i magimet ha nikam. Ta dakkal i gungguna moy nokkan ha langit. Ta kona bila hito i pinagloko di ha minahagpugto a hidi, idi nikuna a naalay dan. Ket magragsak kam bas a magattam ha rigrigat moy.” ");
INSERT INTO duo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Intulos ni Jesus i pagitoldu na ha tolduwan na a hidi, a kinagi na, “Mappiya i asin, ta mappiya i ennam na. Ket niyaen, hikam man i kona ha asin. Ta magitoldu kam ha mappiya a ugali ha madukas a totolay. Ngem nu lompas dan i ennam na asin, awan a mabalin a pasoliyan i ennam na manon. Ket awan dod ha serserbe na, nu awan la a mebanghat a paglakadan na totolay.” ");
INSERT INTO duo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ket kinagi pala ni Jesus, “Hikam i kona bila ha silaw a magdisyag ha ngamin a lutak. Ket kona ha ili a maghen ha kurot na amugod. Ta awan ito a metago. ");
INSERT INTO duo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Awan ha tolay a mangpagangat ha pagsilawan na, sana kallaban ha salup. Ta meyontok mina i pagsilawan na, penu madisyagan i ngamin a maghen ha bilay na. ");
INSERT INTO duo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Niyaen, kona bila hito ha pinaguseg moy ha Dios. Masapul a awan metago i mappiya a gimetan moy penu makatandiyan mina na totolay i ugali moy. Ket gipu ha ide, deyawan di mina i Hama moy ha langit.” ");
INSERT INTO duo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Awan moy mina kagin a inumangayak penu mangadya ha Linteg ni Moyses ken pagitoldu na minahagpugto a hidi. Ta awanak inumangay penu mangadya ha dento, nu awan penu mepakatandi ko ken tungpalan ko ito. ");
INSERT INTO duo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tahod a tahod ide a ipeta ko ha nikam: pulos a awan maadya i maski esa a linteg ha Libro na Dios, hanggan matungpal hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ket ide i gipu na a maski nu heya a magpabiyan ha maski esa a linteg na Dios, ken mangitoldu ha sabasabali a pabiyanan di bila, mebilang hikuna nokkan a kadibbiyan ha Paghariyan na Dios. Ngem ha magtungpal ha Linteg na Dios ken mangitoldu ha sabasabali penu magtungpal bila hidi, mebilang hikuna a katangkayan ha Paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Isu, ipeta ko ha nikam a awan kam makasaddap ha Paghariyan na Dios, nu awan a dakdakkal i pinaguseg moy ha pagayatan na Dios, ngem ha pinagtongpal na dagende a Pariseyo ken mamaestro na Linteg.” ");
INSERT INTO duo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kinagi ni Jesus, “Katandi moy dan ide a linteg ni Moyses, a ‘Awan ka mamapatay. Ha maski nu heya a makapatay, masapul a mahukom hikuna,’ kon na. ");
INSERT INTO duo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngem niyaen, ipeta ko ha nikam a maski nu heya a makaingal ha kakalan na a tolay, mahukom mina hikuna. Ket maski nu heya a mangipeta ha kakalan na a tolay, ‘Awan ha serserbe mo,’ mahukom mina hikuna ha Sanhedrin. Ket ha maski nu heya a mangipeta ha kakalan na a tolay, ‘Matay ka, a kadukasan a tolay,’ mepaangay hikuna ha gangatan na impyerno. ");
INSERT INTO duo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Isu, nu atoy idatton mo ha Dios, ha pagdattonan ha Templo, ket manakam mo a kelliwat ka a pakaliwatan mo, ");
INSERT INTO duo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","itirak mo mina iday a datton mo, ket umangay ka ha palungo a makitalna ha kakalan mo a tolay. Samo, metulos i datton mo ha Dios, ha Templo.” ");
INSERT INTO duo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Magsigida kam mina a makitalna ha mangidarum ha nikam, maski ha palungo a makaabot kam ha paghukoman. Ta nu awan moy mapagtalna i mangidarum, igiwat na kam ha hukom. Ket igiwat na kam na hukom ha polis, a mangiyasak ha nikam ha pagbaludan. ");
INSERT INTO duo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ket nakaman moy ide a ipeta ko ha nikam, a awan kam makalapos hanggan awan moy mabayadan i ngamin a liwaliwat moy.” ");
INSERT INTO duo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kinagi ni Jesus, “Katandi moy dan ide a linteg ni Moyses, a ‘Awan ka mangibabbey.’ ");
INSERT INTO duo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngem niyaen, ipeta ko ha nikam a maski nu heya a mangaamata ha esa a babbey, ket madukas i nakam na, mebilang na Dios a nakaliwat dan hikuna, a nangibabbey dan i nakam na. ");
INSERT INTO duo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Isu a adyan moy mina i maski nu anya a pakaliwatan moy, maski nu mangina ide ha nikam. Kona he i pangaregan ko ha nikam, a nu atoy a kona ha makanawan a mata mo i pakegipuwan na pinagliwat mo, mas mappiya nu suatan mo ito, ket ibanghat mo. Ta mas mappiya nu lompas i esa a paset na baggi mo, ngem i ngamin a baggi mo a metogbak ha impyerno. ");
INSERT INTO duo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Onu maski nu atoy i kona ha makanawan a kamat mo i pakegipuwan na pinagliwat mo, mas mappiya nu katolan mo, ket ibanghat mo. Ta mas mappiya nu maadya i esa a paset na baggi mo, ngem i ngamin a baggi mo a marigrigatan ha impyerno.” ");
INSERT INTO duo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nesurat bila ha Linteg ni Moyses, a ‘Maski nu heya a lallaki a mangisina ha kabanga na, masapul a maatdinan hikuna ha kasuratan na pinagsina di.’ ");
INSERT INTO duo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngem niyaen, ipeta ko ha nikam, a makaliwat i maski nu heya a lallaki a mangisina ha kabanga na. Ta kona nu mapaliwat na i kabanga na, a kona nu mangilallaki i kabanga na nu magkabanga manon ha sabali a lallaki. Ngem nu tahod a nangilallaki dan i kabanga na aye, mabalin na a isina, ket awan ha liwat na lallaki. Ngem makaliwat paman i maski nu heya a lallaki a magkabanga ha nesina a babbey, a kona ha nangibabbey dan hikuna.” ");
INSERT INTO duo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Katandi moy dan ide a linteg ni Moyses, a ‘Awan mo pabiyanan i kari mo. Ta nu atoy i inkari mo, ket nagenan mo i Apo Dios, a magsistigu ha kari mo, masapul a tungpalan mo,’ kon na. ");
INSERT INTO duo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ngem niyaen, ipeta ko ha nikam, a awan kam mina magnagen ha maski nu anya ha pinagkari moy. Awan mos pagsistigu i langit ha kari mo, ta iday bila i henan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ket awan mos pagsistigu i lutak, ta iday bila i henan na Apo Dios. Maski iday a ili a Jerusalem, awan mo iday pagsistigu ha kari mo, ta iday bila i henan na Dios a Kadaklan a Hari. Ket i ngamin a dagento i kona ha sangay na. ");
INSERT INTO duo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ket awan mos ipeta, a ‘Maski nu matayak,’ ha pinagkari mo. Ta bakkan a hikaw i Apo Dios, ket awan ka ha turay ha bukod mo a biyag. Maski awan ka ha kabaelan a pagsulet ha buk mo, a magbalin a maponset onu mangiset. ");
INSERT INTO duo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Isu, ha pinagkari mo, ipeta mo, ‘Oni, gimetan ko iday,’ kommo. Onu madiyan mo a gimetan, ipeta mo, ‘Madiyan ko,’ kommo ah. Ket madukas i maski nu anya a inayon mo, ta maggipu ito ha madukas a kinatolay mo.” ");
INSERT INTO duo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Niyaen,” kagi ni Jesus, “katandi moy dan ide a linteg ni Moyses, a ‘Nu atoy i mangbulsak ha mata na tolay, ibilas moy mina, a bulsakan moy hikuna. Onu atoy i mangdanog ha ngipan na tolay, ibilas moy mina, a danogan moy i ngipan na a.’ ");
INSERT INTO duo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngem niyaen, sabali i ipeta ko ha nikam, a awan moy bilasan i maggimet ha madukas. Halimbawa: Nu atoy i mangdanog ha padingel mo, padanog mo bila i kalipat na. ");
INSERT INTO duo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Onu atoy i mangidarum ha nikaw, penu maalap na i badu mo, pabiyanan mo a alapan na bila i kagay mo. ");
INSERT INTO duo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ket maski nu heya a mangipapilit a kumuyog ka ha esa a kilometro, kuyogan mo pala hikuna ha mekaduwa. ");
INSERT INTO duo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mangatad ka ha maski nu heya a umaged ha nikaw. Ket nu atoy i saluwan di ha nikaw, ipasallu mo.” ");
INSERT INTO duo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Katandi moy dan i pagitoldu na mamaestro a hidi na Linteg, a ‘Ayatan moy mina i agagum moy, ket sentiyan moy mina i kasenti moy a hidi,’ konan di. ");
INSERT INTO duo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngem niyaen, sabali i ipeta ko ha nikam. Kagbiyan moy i kasenti moy a hidi. Ket ikararagan moy i magloko a hidi. ");
INSERT INTO duo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ta nu kona hito a magaheg kam ha pinagkagbi na Dios, mepaenta moy a hikam i tahod a annak na Dios. Ta kona ha ide i pinagkagbi na Dios, a awan na padisyagan i singgit ha mappiya la a totolay, nu awan pati ha madukas a hidi. Ket magkalan i pinagatad na ha uden, ha madukas onu mappiya a hidi. ");
INSERT INTO duo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Awan moy mina kagin a gunggunaan na kam na Dios nu kagbiyan moy i magkagbi ha nikam. Awan agay. Ta maski i mahagdadaya a hidi, kagbiyan di bila i magkagbi ha nidi. ");
INSERT INTO duo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nu aguman moy la i ilailay moy, magkalan kam ha totolay a awan a manahod. Ta kona bila hito i ugali na totolay a awan makidios. ");
INSERT INTO duo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Isu, hikam man i magaheg mina ha Dios, a awan ha pagkurangan na. Ket nu gimetan moy ito, awan kam bila ha pagkurangan ha kinappiya ken kinaayat.” ");
INSERT INTO duo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ha pinaggimet moy ha mappiya, magingat kam ha nakam moy, penu awan kam mapangas. Magingat kam ha panggep moy. Ket awan moy gimetan i mappiya ha saguppang na tolay penu deyawan di kam. Ta nu kona hito i gimetan moy, awan na kam gunggunaan Nama moy a Dios. ");
INSERT INTO duo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Isu, nu manglimos ka, awan mos ipeta ha sabali a hidi. Ta kona hay i ugali na aginpappiya a hidi, nu umangay hidi ha kapilya, onu maski ha pagpasyal di ha kalsada. Kanayon hidi a magibaheta ha bukod di a pinanglimos, penu ideydeyaw hidi na totolay. Niyaen, nanakaman moy i ipeta ko ha nikam, a iday la i gungguna di. I deydeyaw na totolay i gungguna di. Awan hidi ha gungguna a maggipu nokkan ha Dios. ");
INSERT INTO duo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngem bakkan mina ha nikam. Nu manglimos ka, awan mos ipeta ha maski nu heya a agum mo, ");
INSERT INTO duo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","penu malimed mina i paglimos mo. Ket metan na kam na Apo Dios a makaenta ha ngamin a gimetan moy a nalimed. Ket hikuna man i mangiyatad ha gungguna moy nokkan.” ");
INSERT INTO duo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nu magkararag kam, awan moy mina ahegan i aginpappiya a hidi. Ta ugali di a tumaknag ha kapilya, onu maski ha karsada, a magkararag hidi, penu maenta na hidi na totolay. Ket nakaman moy ide a ipeta ko ha nikam, a nobos dan i gungguna di, ta nagiwat di dan i deydeyaw na totolay. Ket iday la i gungguna di. ");
INSERT INTO duo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ngem bakkan mina ha nikam. Nu magkararag ka, sumadap ka ha bilay moy, ket iseradu mo i ridaw. Ket magkararag ka a isesa ha Apo Dios. Ket hikuna i makaenta ha nikaw a magkararag a nalimed. Ket gunggunaan na ka nokkan. ");
INSERT INTO duo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nu magkararag kam, awan moy mina usaran i makpal a kakkagi a awan serserbe na. Kona hay i ugali na awan a hidi makidios. Ket kagin di a sanegan na hidi na Dios gipu ha atakdug a kararag di. ");
INSERT INTO duo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Awan moy hidi ahegan, ta katandi Nama moy a Dios i kasapulan moy, maski ha palungo a pagaged moy. ");
INSERT INTO duo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Isu, kona mina he ikararag moy, ‘Amang Dios a magturay ha ngamin, deydeyawan mina na ngamin a tolay i nagen mo, a magisesa ka a Dios. ");
INSERT INTO duo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Hikaw mina i maghari ha ngamin a tolay. Ket matungpal mina i pagayatan mo ha ide a lutak, a kona bi ha langit. ");
INSERT INTO duo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Atdinan mo kami bi ha kanan mi ha yenan, ken kadapamalak. ");
INSERT INTO duo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ket pakawanan mo bi i liwaliwat mi, gipu ta pinakawan mi dan i nakaliwat ha nikami. ");
INSERT INTO duo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sawayan mo kami ha nakaro a pakasurubaran, ket isalakan mo kami bi ha kinadukas.’ ");
INSERT INTO duo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kona mina hito i kararag moy,” kon ni Jesus, “ta nu pakawanan moy i nakaliwat ha nikam, pakawanan na kam bila Nama moy a Dios. ");
INSERT INTO duo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngem nu awan moy pakawanan i nakaliwat ha nikam, awan na kam pakawanan Nama moy ha liwaliwat moy.” ");
INSERT INTO duo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nu magkabeng kam a magkan, penu perpermi a magkararag, awan moy ahegan i aginpappiya a hidi. Ta kayat di a mepaenta i pinaggimet di. Isu, nu pabiyanan di a magkan, penu magkararag, awan hidi maguges ha rupa di, onu surodan i buk di. Ket maginlaladingit hidi, penu makatandiyan na totolay i gimetan di, a kona ha pagserbe di ha Dios. Ket deydeyawan na hidi na sabasabali. Ngem nakaman moy ide a ipeta ko ha nikam, a iday la i gungguna di. Awan na hidi gunggunaan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngem bakkan mina ha nikam. Nu pabiyanan moy i kakanan, penu perpermi a magkararag, ugesan mo mina i rupa mo, ket urnosan mo i buk mo. ");
INSERT INTO duo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ket nu kona hito, awan ha makatandi ha pinagserbe mo aye ha Apo Dios, a pinabiyan mo a magkan penu magkararag. Ket maenta na ka na Apo Dios a sililimed. Ket hikuna man i mangiyatad ha gungguna mo, ta maenta na i ngamin a gimet mo a nalimed.” ");
INSERT INTO duo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Awan moy mina urnongan i kinabaknang moy ha ide a lutak. Ta sigida la a lompas, a makutem na uhad, onu ubosan na simang, onu natakaw na madukas a tolay. ");
INSERT INTO duo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Imbes na, tungpalan moy mina i pagayatan na Dios. Ket nu kona hito, naurnong dan i kinabaknang moy ha langit. Ket awan hay ha magubos onu magtakaw ha kinabaknang moy. ");
INSERT INTO duo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Isu, magnakanakam kam mina ha paghariyan na Dios. Ta maski nu anya i nanakaman moy, iday bila i paggustowan moy a tahod ken ibilang moy a kinabaknang moy.” ");
INSERT INTO duo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kinagi pala ni Jesus, “I mata mo i kona ha sulu na baggi mo. Nu mappiya i pagenta mo, siyempre, mapsag bila i nakam mo. ");
INSERT INTO duo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ngem nu madiham i pagenta mo, siyempre, madi bila i ngamin a nakaman ken gimetan mo. Nu madiham i nakam na tolay, kagbi dalla agay, ta madukas unay iday a tolay, a awan na katandi i mappiya.” ");
INSERT INTO duo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Awan tam kaya a magserbe ha duwa a happo. Ta nu atoy i magpadas ha ide, ayatan na i esa, ngem sentiyan na i mekaduwa; onu usegan na i esa, ket sinaan na i mekaduwa. Niyaen, kona bila hito ha nikam. Nu korinat i korsunada moy, ket kona ha korinat i happo moy a ayayatan moy, awan kam makauseg ha Dios. ");
INSERT INTO duo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ide i nangpetaan ko ha nikam a awan moy pakadanagan i pagbiyag moy, nu anya i kanan moy onu tennon moy. Ta ayayatan na kam unay na Apo Dios. Mangina kam unay ha nikuna. Ket awan moy mina kagin a awan na kam atdinan ha kanan moy onu tennon moy. ");
INSERT INTO duo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Entan moy i manok a hidi. Awan hidi magmula, ket awan hidi maganni. Awan ha kamalig di. Pakanan hidi na Dios. Ket hikam paman i mas mangina ha Dios ngem manok a hidi. ");
INSERT INTO duo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nakaman moy bas ide, a awan ha serserbe na buribur moy. Nu dumemat nokkan i tiyempo na katay moy, awan kam makapaalay ha biyag moy gipu ha buribur moy. ");
INSERT INTO duo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Awan kam mina magburibur ha badu moy. Entan moy i budak a hidi. Awan hidi magtarabaho, ket awan hidi maggimet ha badu. Ngem nabaduwan dan hidi. ");
INSERT INTO duo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ket mas inaamakan i badu na esa a budak aye ngem ha ngamin a badu ni Hari Solomon, i kabaknangan a Hari na Israel. ");
INSERT INTO duo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Isu, nu baduwan na Dios i budak a hidi ha inamakan, maski nu awan maalay ket matutod hidi, anya dod ha nikam? Pabaduwan na kam wade? Sigurado ah! Apay wade a ballik la i panahod moy? ");
INSERT INTO duo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Isu,” kagi ni Jesus, “awan kamon magburibur! Awan kam magburibur nu anya i kanan moy, onu inuman moy, onu pagtennon moy. ");
INSERT INTO duo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kona hay i buriburan na awan a hidi a manahod ha Dios. Ngem awan moy hidi ahegan. Ta nakatandiyan na Dios i ngamin a kasapulan moy. ");
INSERT INTO duo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Imbes na, nananakaman moy ha palungo megipu ha pinaguseg moy ha Dios. Sana, iyatad pala i ngamin a kasapulan moy. ");
INSERT INTO duo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Isu i nangpetaan ko a awan kamon magburibur ha rigrigat a awan pala nagimet. Ta kona ha pakakpalan mo i rigrigat mo, nu buriburan mo i rigrigat a awan pala nagimet. Isu, kuston i rigrigat moy. Awan moy mina pakakpalan.” ");
INSERT INTO duo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ket tinumulos ni Jesus, “Awan mos hukoman i kakalan mo a tolay, penu awan na ka hukoman na Dios. ");
INSERT INTO duo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ta hukoman na kam na Dios gipu ha pinanghukom moy ha kakalan moy a tolay. I gimetan moy ha sabali a tolay, kona bila iday i gimetan na Dios ha nikam nokkan.” ");
INSERT INTO duo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ide paman i pangaregan ni Jesus megipu ha paghukom na tolay ha kakalan na a tolay, a kinagi na, “Kona nu atoy i ballik a as-as ha mata na kabsat mo, ngem atoy i dakkal a kayo ha mata mo. ");
INSERT INTO duo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Samo, ipeta ha nikuna, ‘Abeng, maadyan ko bi i as-as ha mata mo ah,’ kom mo. Ngem panyan mo agay? Ta awan ka makaenta! Ta dakkal i kayo ha mata mo. Dadi pala agay! ");
INSERT INTO duo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Aginpippiya ka dalla, nu kona hito! Imbes na, hikaw mina i magpalungo a magadya ha dakkal a kayo ha mata mo, penu makaenta ka ha madinnang. Sa mo, maadya i as-as ha mata na agum mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kinagi ni Jesus, “Awan moy iyatad ha asu a hidi i maski nu anya a mangina, amangan nu dangpihan di kam ken kagitan di kam. Ket kona bila hito nu atoy i pilitan moy a magteman ha kagi na Dios. Ta kona ha asu a hidi. Maski nu mangina unay i iyatad mo ha nidi, magingal dalla hidi, ket dangpihan di kam. Ket kona paman ha babboy a hidi. Nu itagmak mo i mangina a manek ha saguppang di, gidtanan di dalla, a awan di katandi i mangina. Isu, awan moy mina tolduwan i totolay a magmadi a magteman ha kagi na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kinagi ni Jesus, “Tumulos kam a makiaged ha Dios, ket iyatad na ha nikam. Tumulos kam a mageriyok, ket paketan na kam. Tumulos kam a magtuktuk ha ruwangan na Dios, ket lakwaban na kam. ");
INSERT INTO duo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta maski nu heya a makiaged-aged ha Dios, makagiwat hikuna. Ket nu magerieriyok hikuna, paketan na Dios. Ket nu tumulos hikuna a magtuktuk, lakwaban na Dios. ");
INSERT INTO duo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ket kona bila hito ha nikam a atoy annak na. Nu agedan na annak mo i tinapay, anya, iyatad mo i pogedu ha nikuna? Awan agay! ");
INSERT INTO duo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Onu agedan na i padut, iyatad mo i ulag ha nikuna? Awan man! ");
INSERT INTO duo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Entan moy; hikam man i magkalan ha ngamin a kakalan moy a tolay a kelliwat. Ngem maski nu kona hito a magliwat kam, kayat moy pala a makiyatad ha mappiya ha annak moy. Ket Dios paman i pasig la a mappiya. Isu, mas mapigsa i pagkayat na Hama moy a Dios a mangiyatad ha mappiya ha totolay a makiaged ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Niyaen, gimetan mo ha kakalan mo a tolay i kayat mo a gimetan di ha nikaw. Ide dan i kona ha panungpalan na ngamin a pagitoldu ha Linteg ni Moyses ken sursurat na minahagpugto a hidi.” ");
INSERT INTO duo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Marigat i biyag moy nu sumadap kam ha paghariyan na Dios. Ket pangaregan na i kona nu sumadap kam ha nasupit a ruwangan. Ket ballik la i agagum moy a makaeriyok ha ide a ruwangan a magturong ha Dios. Ngem dakkal unay i ruwangan a magturong ha biyag a pakadadailan. Ket malaka la a maeriyokan ha biyag a mahagliwat. Ket makpal i tolay a tumulos a makaliwat a kona hito. Isu i gipu na a ipeta ko ha nikam, a sumadap kam mina ha ide a masupit a ruwangan a magturong ha Dios.” ");
INSERT INTO duo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Magingat kam ha masileng a hidi a mahagpugto. Ta umangay hidi ha nikam, ket kona ha maanus. Ngem awan hidi maanus, nu awan a maingal. Ket lolokwan di kam. ");
INSERT INTO duo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","17","Melasin moy hidi gipu ha paggimet di. I pangaregan ko i kona ha bunga na kayo. Ta maski nu anya a nemula, katandi moy nu inaamakan, onu awan ha balle na, gipu ha bunga na. Halimbawa: Awan moy maputi i kona ha mangga ha madukas a kayo a maseset. Ket awan moy maalap i masinggat a bunga ha madukas a kayo. ");
INSERT INTO duo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nu atoy i mappiya a kayo, awan hikuna magbunga ha madukas. Onu atoy i kayo a madukas, awan hikuna magbunga ha mappiya. ");
INSERT INTO duo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ha kada kayo a awan magbunga ha mappiya, makatol ket metogbak hikuna ha gangatan. ");
INSERT INTO duo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ide dan i pangaregan ko ha nikam, penu melasin moy i masileng a hidi a mahagpugto, gipu ha paggimet di. ");
INSERT INTO duo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Atoy i magayag ha nikan, ha ‘Happo ko! Happo ko!’ Ngem bakkan a hidi i makasaddap ha paghariyan na Dios, nu awan la i totolay a umusoseg ha pagayatan na Hama ko a Dios. ");
INSERT INTO duo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nokkan, ha pamalak a panghukom na Dios ha totolay, atoy bi i makpal a magkagi ha nikan, a ‘Happo, sakopan mo kami bila, ta nagitoldu kami gipu ha nikaw. Ket inusar mi i nagen mo, a pinalakad mi i dimonyo a hidi. Ket nakaddatan i ginimigimet mi gipu ha nikaw.’ ");
INSERT INTO duo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngem ipeta ko ha nikam,” kon ni Jesus, “a itabbeg ko nokkan ha nidi, a ‘Awan! Awan takam katandi! Umadiyo kam dan, hikam a mahagliwat!’ kon ko nokkan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Malaing i maski nu heya a umuseg ha nikan, a magteman ken magtongpal ha kagi ko. Ket ipakatandi ko ha nikam i pangaregan na. Ta kona ha esa a lallaki a nagpataknag ha malagda a bilay. Ket nagkotkot hikuna ha madisalad, penu itolnak na i adigi a hidi. ");
INSERT INTO duo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Idi dinumemat i bagyo, ket dinuminum i karayan, naabot na karayan i bilay na. Ngem awan narakrak i bilay, ta inamakan i pinagbilay na lallaki. ");
INSERT INTO duo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ngem ha maski nu heya a makateman ha kagi ko, ngem awan umuseg, hikuna i kona ha lallaki a awan magtolnak ha adigi ha madisalad. ");
INSERT INTO duo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ket nu magbagyo, duminom i karayan. Ket mapigsa i pahas. Ket malaka la i pakarakrak na bilay na. Ket mebulod i ngamin a bilay na.” ");
INSERT INTO duo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Idi nobos ni Jesus a magitoldu ha dagende, tahod a kayat na tolay a hidi i pagitoldu na. ");
INSERT INTO duo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ta idi nagitoldu ni Jesus, nepaenta na a mannakabalin i turay na a magitoldu, ket awan a kona ha maestro a hidi na Linteg a nagitoldu gipu ha sabali a makinturay. ");
INSERT INTO duo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Idi binumugsok ni Jesus ha parabin, sinalodsod bila i makpal a tolay. ");
INSERT INTO duo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ket atoy bila i esa a lakay a magkattal. Inumangay hikuna a nagparentumeng ha saguppang ni Jesus. Ket kinagi na, “Apo, nu kayat mo, mapahusay mo i baggi ko!” ");
INSERT INTO duo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ket kinagi ni Jesus, “Kayat ko.” Ket intupo na i kamat na, ket inpeta na, “Mahusay ka dan!” Ket bigu la a naawan dan i kattal na. ");
INSERT INTO duo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sana, inbon ha nikuna, “Awan mo ipepeta ha maski nu heya. Imbes na, magdiretso ka ha padi, penu bilengan na ka. Ket iyatad mo ha nikuna i pangiwagah mo, penu matongpal i bon ni Moyses. Nu gimetan mo ide, mapanahod mo hidi a pinahusay na ka na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Idi kassaddap ni Jesus ha ili a Kapernaum, inumangay ha nikuna i kapitan na esa a gasut a sundalu a taga Roma. Ket inaged na, ");
INSERT INTO duo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Apo, masaket i tagabu ko ha bilay mi. Awan hikuna makalembok ha baggi na, ket marigatan unay.” ");
INSERT INTO duo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ket kinagi ni Jesus ha nikuna, “Umangayak a pahusayan ko hikuna.” ");
INSERT INTO duo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngem tinabbeg na kapitan aye, “Masanikiyak ha nikaw, nu umangay ka ha bilay mi, ta mas matangkay ka ngem hikan. Maski nu ipeta mo la, ket sigurado a humusay i tagabu ko. ");
INSERT INTO duo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Katandiyan ko dan i turay mo, ta kona bila ha turay ko. Ta atoy i happo ko a mangituray ha nikan, ket atoy i sunsundalu a meturayan ko. Nu ipeta ko ha esa a ‘Umangay ka dan,’ siyempre, umangay hikuna. Nu ipeta ko ha sabali a ‘Uyoy ka he,’ siyempre, umangay hikuna ha nikan. Nu ipeta ko, a ‘Gimetan mo ide,’ maggimet hikuna ha iday. Isu, katandi ko dan a nu atoy i ipeta ni Jesus, siguradowak a magimet iday.” ");
INSERT INTO duo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Niyaen, nalaktat ni Jesus ha nateman na a kinagi na Kapitan. Ket sinumoleg hikuna, a inpeta na ha kakpalan a inumunod, “Tahod ide a ipeta ko ha nikam, ket hanggan ha yenan, awan ko naenta i panahod a kona he. Ta maski ha Judyo a hidi, awan ha manahod ha nikan a kona ha ide a kapitan. ");
INSERT INTO duo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niyaen, ipeta ko ha nikam a atoy nokkan i makpal a maggipu ha ngamin a lugar ha lutak aye, a amyanan, ken abagatan, ken laod, ken daya. Maski idagendo a tolay a bakkan a Judyo. Ket makipagetnod hidi ha Paghariyan na Dios. Ket makipagkan hidi ha ni Abraham, ken ni Isak, ken ni Jakob ha piyesta na Dios. ");
INSERT INTO duo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ngem atoy ha nikam a Judyo i metogbak ha madihaman a lugar, ha lapos na Paghariyan na Dios. Ihay man i pagsangisangetan di ken pagrangsirangsitan di, gipu ha nakaro a rigrigat di.” ");
INSERT INTO duo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sana, kinagi ni Jesus ha iday a kapitan, “Ilay ko, sumoli ka dan. Matungpal i inaged mo, gipu ha panahod mo.” Ket dagus a nakahusay i tagabu na kapitan, idi oras heya a nagkakagi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Idi inumangay ni Jesus ha bilay di Simon, naenta na a nagsaket i manugang ni Simon, ta nagladu. ");
INSERT INTO duo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kinamhet ni Jesus i kamat na, ket dagus a hinumusay hikuna. Ket inumikat hikuna, ket nagserbe, a nagpakan hikuna ha di Jesus. ");
INSERT INTO duo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Niyaen, atoy bila hay i makpal a magsaket. Ket idi kinumaltob i senggit, neyangay ha ni Jesus i makpal a naawag na didimonyo. Ket pinalakad na i dimonyo a hidi gipu ha pinagibon na ha nidi. Ket pinahusay na i ngamin a masaket. ");
INSERT INTO duo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Gipu ha dagende a ginimet ni Jesus, natongpal na i nagkagiyan ni Isayas a esa a minahagpugto. Ta insurat ni Isayas, “I Cristu a mismo i mangadya ha ngamin a kinakapoy tam, a adyan na i sakisaket tam.” ");
INSERT INTO duo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Idi esa a pamalak, ket naenta ni Jesus i makpal a tolay a dumadulog ha nikuna. Ket inbon na ha tolduwan na a hidi a maggayak hidi a umahabes ha dibelew. ");
INSERT INTO duo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngem idi paggayak di, binumikan ha ni Jesus i esa a maestro na Linteg. Kinagi na, “Maestro, umunodak ha nikaw, maski nu hadya i angayan mo.” ");
INSERT INTO duo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ngem iniwadan ni Jesus hikuna, “Maski i hayup a hidi ha talon, a kona ha madipa a hidi, atoy i paghenan di ha abot. Maski ha manok a hidi, atoy i paghenan di ha rabon di. Ngem awan ha paghenan i Annak na Dios a Nagbalin a Tolay. Awan la ha pagemmangan ko.” ");
INSERT INTO duo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ket atoy bila i sabali a tolduwan ni Jesus, a kinagi na, “Apo, kayat ko a umusoseg ha nikaw, ngem palobusanak mo bi ha ballik la. Ta magurayak mina hanggan ha pakelabbang nama ko. Sa ak, umunod ha nikaw.” ");
INSERT INTO duo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngem tinabbeg ni Jesus, “Kabeng mon iday. Atoy i sabali a hidi a magtallekod ha nikan. Ket kaykayat di a umusoseg ha ugali na minatay a hidi. Isu, pabiyanan mo a hidi mina i mangilabbang ha totolay a minatay. Ngem bakkan mina ha nikaw, ta umusoseg ka mina ha nikan.” ");
INSERT INTO duo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sa, sinumakay ni Jesus ha abang, ket inumunod i tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Idi pagsakay di, kinumillap ni Jesus. Ket bigu la a maparas dan ha mapigsa. Ket naraknaban i abang di, a dandani a inumlad. ");
INSERT INTO duo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Isu a linukag di ni Jesus, a kinagi di, “Happo, Happo! Isalakan mo kami! Umlad kitam dan!” ");
INSERT INTO duo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ket kinagi ni Jesus, “Apay a manteng kam? Ballik dod i panahod moy ha nikan.” Sa hikuna, tinumaknag, a binon na i paras ken raknab. Ket tinumaran i paras, ken linuminnak i diget. ");
INSERT INTO duo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ket nalaktat i tolduwan na a hidi, a kinagi di, “Anya wade i lallaki aye? Ta mabon na i paras ken raknab, ket magtongpal hidi ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tinumulos di Jesus a naglugan ha abang hanggan ha dibelew, ha lugar a Gadareno. Idi kahhapog ni Jesus, sinumalpak i duwa a lallaki a hinayup, a naggipu hidi ha kampo-santo. Maingal hidi unay. Isu i gipu na a awan ha maketured a lumakad ha iday a lugar. ");
INSERT INTO duo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Idi naenta di ni Jesus, nagayag i hinayup a hidi, a kinagi di, “Annak na Dios, anya i kayat mo a gimetan ha nikami? Anya, inumangay ka he penu parusaan mo kami? Awan kas, ta awan pala tiyempo a nebital na Dios a paghukom na.” ");
INSERT INTO duo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Niyaen, atoy bila hito i makpal a babboy, a magsabbok ha mabikan a henan di. ");
INSERT INTO duo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ket inaged na dimonyo a hidi, “Nu palakadan mo kami, palobusan mo kami bi a sumadap ha dagendo a babboy.” ");
INSERT INTO duo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ket kinagi ni Jesus, “Nay, ikad moy dan!” Isu, linumapos hidi, a sinumadap hidi ha babboy. Ket bigu la a ginumutap i babboy a hidi ha dinom. Ket inumlad hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Niyaen, idi nangenta i mahagdapon ha babboy a hidi, binumuyot hidi ha ili. Ket inbaheta di i ngamin a nagimet, pati i nagimet ha denday a duwa a hinayup. ");
INSERT INTO duo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Isu, inumangay i makpal a tolay a mangenta ha ni Jesus. Ket idi naenta di hikuna, inaged di a lakadan na i lugar di. Ta nanteng hidi. ");
INSERT INTO duo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Isu, linumugan manon di Jesus, a nagsoli ha dibelew. Ket dinumemat hidi ha ili na, a Kapernaum. ");
INSERT INTO duo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Idi kaddemat na, ket neyangay ha nikuna i esa a napilay ha duwa a tikad na. Idi naenta ni Jesus a manahod hidi a nagkona hito, inpeta na ha pilay, “Ilay ko, awan kas manteng. Napakawan dan i liwaliwat mo.” ");
INSERT INTO duo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ngem idi nateman na ito na maestro na Linteg, naginuhon hidi, a kinagi di, “Tadi! Ikalan na i baggi na ha Apo Dios!” ");
INSERT INTO duo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ngem katandi ni Jesus i nakam di, ket kinagi na, “Apay a magnakam kam a kona hay a madukas? ");
INSERT INTO duo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Makatandiyan moy mina i pagturay na Annak na Dios a Nagbalin a Tolay. Ta bakkan ito ha pagturay na ngamin a sabali a tolay. “Niyaen, amatan moy ide a napilay. Ta awan ha tolay a makepeta ha, ‘Mapakawan dan i liwaliwat mo!’ Ket awan ha tolay a makepeta ha, ‘Umikat ka! Makalakad ka dan!’ Ngem bakkan ha nikan, ta makapaenta ak ha nikam a atoy i pagturay ko a mangpakawan ha liwat na tolay.” Sana, inpeta ha iday a pilay, “Ilay ko, umikat ka. Alapan mo i ulas mo, ket sumoli ka dan ha bilay moy.” ");
INSERT INTO duo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ket inumikat i napilay, a nagsoli hikuna ha bilay na. ");
INSERT INTO duo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Idi naenta na ito na kakpalan a tolay, nasbew hidi ha kabaelan ni Jesus. Ket dineydeyaw di i Dios, a nangiyatad ha tolay ha kona he a pinnakabalin. ");
INSERT INTO duo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Linakadan ni Jesus, ket idi paglakad na, naenta na i esa a mahagpabuwis a nagetnod ha pahagsingeran na. Mateo i nagen na. Ket inpeta ni Jesus ha nikuna, “Umuseg ka dan ha nikan, penu matolduwan taka.” Ket tinumaknag ni Mateo, a inumuseg ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Niyaen, nangan di Jesus ha bilay di Mateo. Ket dinumemat i makpal a mahagpabuwis, ken sabasabali a mahagsalungasing ha Linteg na Judyo, a makipagkan ha ni Jesus ken tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ket idi naenta na ito na Pariseyo a hidi, kinagi di ha toltolduwan na, “Apay a makipagkan i maestro moy ha mahagpabuwis ken madukas a hidi?” ");
INSERT INTO duo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ngem nateman na ito ni Jesus, ket hikuna man i tinumabbeg, a kinagi na, “Nu mahusay i baggi na tolay, awan na masapul i doktor. I magsaket la i makasapul ha doktor. ");
INSERT INTO duo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ket kona bila hito ha nikan ken pagbabawiyan ko a hidi. Ket kona ak ha doktor. Ta awanak inumangay penu pagbabawiyan ko i mappiya a hidi a awan ha rigrigat di. Imbes na, inumangayak penu pagbabawiyan ko i madukas a hidi, a marigatan gipu ha liwat di. “Niyaen, nakaman moy mina i kayat a kagiyan na ide a nesurat ha Libro na Dios, a ‘Madiyan ko dan i pagidaton moy a pangtongpal moy mina ha Linteg. Ta kaykayat ko i pinagkagbi moy ha kakalan moy a tolay,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Idi esa a pamalak, dinumemat i kappal a totolduwan ni Juan a Mahagbinyag. Ket sinalodsod di, “Apay a pabiyanan mi a magkan ha pinagkararag mi. Ket kona bila hito ha totolduwan na Pariseyo a hidi. Ngem bakkan ha totolduwan mo. Ta magkan ken uminom hidi ha kada pamalak.” ");
INSERT INTO duo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ket tinabbeg ni Jesus, “Oni, ket kona ha ide i pangaregan ko ha nikam, a nu atoy i pagbodaan, ken atoy i nobyo ken agum na a hidi, anya, magkan hidi, onu awan? Siyempre a magragsak hidi! Ngem dumemat i sabali a tiyempo, ket madakap ide a nobyo, ket mepaadiyo hikuna. Ket iday i tiyempo a pabiyanan di i magkan. Ta maladinget dan hidi.” ");
INSERT INTO duo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ket nepeta ni Jesus i sabali a pangaregan, penu makatandiyan di a awan a mabalin nu melaok i bigu a pagitoldu na ken alegid a pagitoldu na Judyo. Kinagi na, “Nu atoy i mayat a magitakop ha badu a alegid, awan na meusar i bigu a hamet a pangapol na ha alegid a badu. Ta nu padasan na ito, bumallik i bigu a hamet a intakop na, ket dumakkal manon i pisad na badu. ");
INSERT INTO duo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ket kona bila ha ide. Awan ha mangiyasak ha bigu a basi ha alegid a gaddang a pagsupot na. Ta mapisad na bigu a basi iday a nesupotan na. Ket magabuyos i bigu a basi. Ket napisad dan i supot. Imbes na, mappiya malla nu meyasak i bigu a basi ha bigu bila a gaddang a pagsupot na. Ket magkalan ide a supot ken basi a magmaalay.” ");
INSERT INTO duo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Niyaen, nagkagi pala ni Jesus, ket bigu la a dinumemat i esa a mangituray ha kapilya na Judyo. Nagparentumeng hikuna ha saguppang ni Jesus, a kinagi na, “Minatay dan i annak ko a gumitek. Ngem basta umangay ka, a itupu mo i kamat mo ha nikuna, ket sigurado a magbiyag hikuna manon,” kon na lakay. ");
INSERT INTO duo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Isu, inumuseg ni Jesus ha nikuna, pati i tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Niyaen, atoy bila i esa a babbey a masaket. Nagdigidigi ide a babbey ha esa pulo ket duwa a tawen. Ket niyaen, tinumagubet hikuna ha ni Jesus, a kinamhet na i nibik na kagay na. ");
INSERT INTO duo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ta kinagi na ha nakam na, “Maski makamhit ko la i tennon na, ket humusay i baggi ko,” kon na babbey. ");
INSERT INTO duo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Niyaen, sinumoleg ni Jesus, ket naenta na i babbey aye. Ket inpeta ni Jesus ha nikuna, “Manay, awan kas manteng. Mahusay ka dan gipu ha panahod mo ha nikan.” Sa, bigu la a hinumusay i babbey. ");
INSERT INTO duo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Niyaen, tinumulos di Jesus hanggan pagdemat di ha bilay na mangituray a Judyo. Ket naenta ni Jesus i mahagtokar ken magngoyngoy a hidi. ");
INSERT INTO duo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ket kinagi na ha nidi, “Lumakad kamon. Awan natay i gumitek aye. Kinumillap dalla hikuna.” Ngem nagulewan di ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sana, pinalakad hidi. Ket sinumadap hikuna ha bilay. Ket inegkaman na i kamat na gumitek. Sa, inumikat i gumitek a minagbiyag manon. ");
INSERT INTO duo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ket newaras ha ngamin a palebut na ili i baheta megipu ha ide a ginimet ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Idi linumakad manon ni Jesus, tinumagubet i duwa a lallaki a nabulsak. Ket nagayag hidi, ha “Apo ni Dabid, kagbiyan mo kami bi!” ");
INSERT INTO duo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Idi kassaddap ni Jesus ha bilay, sinumadap bila idende a duwa a nabulsak. Ket sinalodsod ni Jesus ha nidi, “Manahod kam a mapahusay takam?” Ket kinagi di, “Oni, Apo.” ");
INSERT INTO duo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Sa, intupo ni Jesus i kamat na ha mata di. Ket kinagi na, “Mahusay kam, gipu ha panahod moy.” ");
INSERT INTO duo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ket minumotyah hidi, a nakaenta manon hidi. Ket inbon ni Jesus ha napigsa, a awan di ibaheta ha agagum di i ginimet na aye. ");
INSERT INTO duo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ngem idi paglakad di, inwaras di ha ngamin i baheta megipu ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Idi paglakad di, neyangay ha ni Jesus i esa a bulol a hinayup. ");
INSERT INTO duo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Idi pinalakad ni Jesus i dimonyo, ket bigu la a nakakagi manon ide a bulol. Ket nalaktat i kakpalan a tolay a nangenta, a kinagi di, “Ha yenan la i netan mi i kona he a kekkaddat, ha bayan tam aye a Israel.” ");
INSERT INTO duo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngem kinagi na Pariseyo a hidi, “Ni Satanas, a kapitan na didimonyo, i nangatad ha nikuna ha kabaelan na, a makapalakad ha dimonyo.” ");
INSERT INTO duo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Niyaen, linumakad ni Jesus ha ngamin a il-ili ken barbaryo, a nangitoldu hikuna ha kapilya na Judyo a hidi. Inpakatandi na i Mappiya a Baheta megipu ha paghariyan na Dios, ket pinahusay na i totolay ha ngamin a sakisaket di. ");
INSERT INTO duo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Idi pakaenta na ha kakpalan a totolay, kinagbiyan na hidi. Ta marigat i biyag di, a awan ha mangdaggap ha nidi. Ket kona ha karkarnero ha taltalon, a awan hidi nadaponan. ");
INSERT INTO duo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Isu, kinagi ni Jesus ha tolduwan na a hidi, a “Atoy dan i makpal a manahod mina ha nikan, ket kona hidi ha paganiyan na Dios. Ngem ballik la i umaangay a kona ha magani ha nidi. ");
INSERT INTO duo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Agidan moy dod ha Apo Dios a makinkukuwa ha maani, penu paangayan na i makpal pala a magani ha manahod a hidi.” ");
INSERT INTO duo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Niyaen, inayagan ni Jesus i esa pulo ket duwa a tolduwan na. Ket inatdinan na hidi ha kabaelan di a magpalakad ha madukas a espiritu, ken magpahusay ha ngamin a kalase na saket. ");
INSERT INTO duo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ide i nagen na esa pulo ket duwa a apostol a tinolduwan ni Jesus: ha palungo ni Simon, a ni Pedro i sangay na. Ni Andres, a wadi ni Pedro. Di Santiyago ken Juan a annak ni Sebedeyo. ");
INSERT INTO duo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ni Pelipe ken ni Bartolome. Ni Tomas ken ni Mateo a minahagpabuwis. Ni Santiyago a annak ni Alpeyo, ken ni Tadeo. ");
INSERT INTO duo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ken ni Simon a matured, ken ni Judas Iskaryote a nangliput ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pinaangay ni Jesus idagende a esa pulo ket duwa a tolduwan na. Ket inbon na ha nidi, “Umangay kam, ngem awan kam umangay ha bayan na Samaritano a hidi. Awan kam umangay ha bakkan a hidi a Judyo, ");
INSERT INTO duo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","nu awan ha kakalan tam a Judyo, a kona ha karkarnero a netawtaw. ");
INSERT INTO duo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ket ha paglakad moy, ipakatandi moy ha nidi a dandani a dumemat i paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pahusayan moy i masaket a hidi. Pagbiyagan moy i minatay a hidi. Pahusayan moy i mahagkattal a hidi. Palakadan moy i didimonyo. Ket nakaman moy a awan ha inbayad moy ha giniwat moy ha Dios. Isu, awan moy pabayadan i pagserbe moy ha kakalan moy a tolay. ");
INSERT INTO duo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ket awan kam magbilon ha korinat. ");
INSERT INTO duo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Awan moy bilonan i aruwatan moy, a maski supot, onu duwa a badu, onu duwa a sapatos, onu duwa a sahukod. Ta daggapan na kam mina na totolduwan moy. ");
INSERT INTO duo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ha maski nu anya a ili onu baryo a saddapan moy, eriyokan moy i mappiya a tolay a mayat a magrespitar ha nikam. Ket tumulos kam ha bilay di hanggan lumakad kam manon. ");
INSERT INTO duo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu sumadap kam ha esa a bilay, ipeta moy, ‘Dios i kumuyog ha nikam.’ ");
INSERT INTO duo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ket nu mappiya hidi, a kayat di kam a respitaran, aguman na hidi na Dios a tahod. Ngem nu madiyan di kam, pabiyanan na hidi na Dios, a magagum hikuna ha nikam, imbes ha nidi. ");
INSERT INTO duo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ha maski nu heya a magtallekod ha nikam, lakadan moy mina iday a bilay na, onu ili di. Ket nu lumapos kam, tipladan moy hidi a kona ha ide, a pagpagen moy i tapok ha tikad moy, penu makatandiyan di a nagliwat hidi, a nagtallekod hidi ha kakkagi na Dios. ");
INSERT INTO duo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tahod ide a ipeta ko ha nikam, a nu dumemat i pamalak a paghukom na Dios, nakaro i parusa na Dios ha nagtallekod a hidi ngem parusa na ha taga-Sodoma ken Gomora a hidi, maski perpermi i liwaliwat na taga-Sodoma ken Gomora, idi tinutod na Dios i ili di. ");
INSERT INTO duo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nakaman moy ide! Paangayan takam ha madukas a totolay. Ket magingat kam mina. Ta maanus kam, a kona ha karkarnero. Ngem maingal i totolay a angayan moy, a kona ha maingal a asasu. Isu, magingat kam, ket gimigimetan moy la i pasig a mappiya. ");
INSERT INTO duo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Magingat kam. Ta ipadakap na kam na totolay, a iyangay di kam ha gobyerno. Ket sabbadan di kam ha kapilya di. ");
INSERT INTO duo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gipu ha panahod moy ha nikan, isaguppang di kam ha gobernador ken hari a hidi. Ide i gundaway moy a magpatahod ha nidi, ken bakkan a hidi a Judyo, megipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nokkan, nu dakapan di kam, ken idarum di kam, awan kam mina magburibur nu anya i tabbeg moy. Ta Apo Dios i makatandi ha iday. Basta ipeta moy i mepanakam na ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ta bakkan a hikam i paggipuwan na itabbeg moy, nu awan i Espiritu na Hama moy a Dios i magpakagi ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nu dumemat ide a tiyempo, atoy bila i makpal a mangliput. Atoy i kappal a patakka a magpapatay ha kakabsat di. Ket atoy i magenak a mangidarum ha annak di, a papapatay di. Ket kona bila hito i gimetan na annak ha daddakkal di. Ta kona hito i madukas nokkan a tiyempo. ");
INSERT INTO duo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ket sentiyan na kam na kakpalan a tolay, gipu ta manahod kam ha nikan. Ngem maski nu kona hito, mesalakan paman i maski nu heya a makatured hanggan ha panungpalan. ");
INSERT INTO duo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nu lolokwan di kam ha esa a ili, bumuyot kamon ha sabali a ili. Ta tahod ide a ipeta ko, a awan moy malpas i tarabaho moy ha ngamin a ili na Judyo, hanggan sumoli manon i Cristu a maggipu ha langit. ");
INSERT INTO duo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Awan a mas matangkay i magad-adal ngem ha maestro na. Ket awan a naturturay i tagabu ngem happo na. ");
INSERT INTO duo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mappiya nu magbalin i magad-adal a kona ha maestro na. Ket mappiya nu magbalin i tagabu a kona ha happo na. Niyaen, katandiyan moy mina a magkalan i magimet ha maestro moy ken magimet ha tolduwan na. Ket nu anya i magimet ha happo, iday bila i magimet ha tagabu na. Isu, nu nagenan diyak ha ‘Satanas’ niyaen, kumaro paman i pagloko di ha nikam nokkan. ");
INSERT INTO duo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ngem awan kam mina manteng ha nidi. Ta maski nu anya a magimet a netago, iday paman i mepalapos nokkan. Ket maski nu anya a nalimed ha yenan, iday paman i mepakatandi nokkan ha ngamin. ");
INSERT INTO duo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Isu, i paguhonan tam ha kallap, a awan mateman na sabali a tolay, ide paman i mebaheta moy nokkan ha saguppang na ngamin a tolay. Ket maski nu iyanasas tam ha yenan, mebaheta moy nokkan ha saguppang na ngamin. ");
INSERT INTO duo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Awan kam manteng ha totolay. Ta baggi moy la i mapapatay di, ngem awan di maanya i kaliduwa. Imbes na, manteng kam mina ha Dios. Ta hikuna la i makaparusa ha baggi ken nakam na tolay ha impyerno. ");
INSERT INTO duo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Awan moy mina buriburan a pabiyanan na kam na Dios. Ta tahod a kagbiyan na kam. Halimbawa: ha totolay, malaka la i piyak a manok. Ngem uray nu melako i duwa a piyak ha esa la a sentabo, manakam na hidi na Dios. Ket hikuna i makatandi ha kada esa. Awan matay i maski esa, nu awan a makatandiyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Ket hikam man i mas mangina unay ngem ha piyak a manok. Isu, katandi na Dios i maski nu anya a magimet ha nikam. Maski nu lompas la i esa a buk moy, katandi na Dios iday, ta binilang na dan.” ");
INSERT INTO duo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Intulos ni Jesus, a kinagi na, “Maski nu heya a magoni ha kakkagi ko ha saguppang na totolay, hikuna bila i pagoniyan ko nokkan, ha saguppang na Hama ko a Dios. ");
INSERT INTO duo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ngem maski nu heya a magmadi ha nikan ha saguppang na totolay, madiyan ko bila hikuna nokkan, ha saguppang na Hama ko a Dios. ");
INSERT INTO duo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Awan moy kagin a inumangayak penu magadya ha ngamin a rigrigat. Awan agay! Awan a makapatalna i pagdemat ko nu awan a gipu ha nikan, masinasina i totolay ha lutak aye. ");
INSERT INTO duo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ta mangrugi dan ha yenan, gipu ha nikan, masinasina i makpal a tolay. Halimbawa: Magsina i pattama, ket magsina i pattena, ket magsina i magmanugang a hidi. ");
INSERT INTO duo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta atoy nokkan i kasenti na manahod a hidi ha bukod di a pamilya. ");
INSERT INTO duo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“I maski nu heya a magayat ha hama na onu hena na ha dakdakkal ngem ha nikan, awan hikuna makapasakop ha nikan. Ket maski nu heya a magayat ha annak na ha dakdakkal ngem ha nikan, awan hikuna makapasakop ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ket maski nu heya a awan umuseg ha nikan ken mangpabiyan ha bukod na a pagayatan, awan hikuna makapasakop ha nikan. Ta masapul a umunod hikuna ha nikan, maski nu mapapatay hikuna. ");
INSERT INTO duo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ha maski nu heya a magmadi a matay gipu ha nikan, marigrigatan hikuna ha awan kahad ha katay na. Ngem ha maski nu heya a matay, a mangpabiyan ha bukod na a pagayatan gipu ha nikan, mesalakan hikuna a tahod, a maghen hikuna ha Dios ha awan kahad.” ");
INSERT INTO duo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ha maski nu heya a magrespitar ha nikam, ibilang na Dios a respitaran na ak bila. Ket nu respitaran na ak, mebilang a respitaran na i Dios a nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ket maski nu heya a magrespitar ha magitoldu, gipu ta itoldu na megipu ha Dios, magunggunaan bila hikuna a magkalan ha magitoldu heya. Ket maski nu heya a magrespitar ha mappiya a tolay a makidios, gipu ha pakidios na, gunggunaan na hikuna na Dios a magkalan ha makidios heya. ");
INSERT INTO duo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ket nu atoy i mangiyatad ha maski dinom la ha esa a madibbi a tolay, gipu ta madibbi heya i tolduwan ko, tahod a gunggunaan na Dios i nangiyatad.” ");
INSERT INTO duo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Idi nobos ni Jesus a nangibon ha dende a esa pulo ket duwa a tolduwan na, linumakad hidi. Ket tinumulos ni Jesus a nagitoldu ha il-ili a palebut na. ");
INSERT INTO duo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Niyaen, atoy pala ni Juan a Mahagbinyag ha pagbaludan. Ket nabaheta na i gimigimetan ni Cristu. Isu, pinaangay ni Juan i tolduwan na a hidi ha ni Jesus, ");
INSERT INTO duo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","a sinalodsod di, “Tahod wade a hikaw i lallaki a paangayan na Dios a maghari, onu urayan mi mina i sabali?” ");
INSERT INTO duo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ket kinagi ni Jesus, “Sumoli kam ha ni Juan. Ket ibaheta moy i nateman ken naenta moy. ");
INSERT INTO duo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ta makaenta manon i nabulsak a hidi. Ket makalakad manon i napilay a hidi. Ket mepabigu i gaddang na magkattal. Ket makateman manon i nagbangag a hidi. Ket mapabiyag manon i minatay a hidi. Ket mabahetaan i napobre a hidi ha mappiya a baheta. ");
INSERT INTO duo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ket mahusay i awan magduwaduwa ha nikan.” Ide i inpeta ni Jesus, penu ibaheta di ha ni Juan. ");
INSERT INTO duo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Idi linumakad i agagum ni Juan, nagkagi ni Jesus ha tolay a hidi hay megipu ha ni Juan. Kinagi na, “Idi inumangay kam ha ni Juan ha amugod, anya i kayat moy maenta? Kagin moy wade a malupoy hikuna, a kanayon a magduwaduwa? Ngem bakkan a kona hito ha ni Juan. ");
INSERT INTO duo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Onu kayat moy maenta i magtennon ha inaamakan? Madi paman. I magtennon ha inaamakan i maghen ha bilay na hari. Hidi la i mahagtennon ha inaamakan. Ngem awan man ha ni Juan. ");
INSERT INTO duo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Apay dod a inumangay kam ha ni Juan? Penu maenta moy i mahagpugto na Dios? Oni! Iday i kayat moy maenta, ket mahagpugto ni Juan a tahod. Ngem atoy pala i naenta moy. ");
INSERT INTO duo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta ni Juan i nagkagiyan na Libro na Dios, a ‘Ipalungo ko i esa ha nikaw,’ kon na Dios ha Anak na a Cristu. ‘Ket magibaheta hikuna megipu ha nikaw. Ket pagayakan na i totolay ha pagdemat mo,’ kon na Dios ha Cristu. ");
INSERT INTO duo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ni Juan dod i lallaki aye a nagpalungo. Ket ipeta ko ha nikam,” kagi ni Jesus, “mas matangkay ni Juan ngem ha ngamin a tolay ha lutak aye! Ngem ha paghariyan na Dios, maski i madibbi a tolay i mas matangkay ngem ha ni Juan. ");
INSERT INTO duo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Niyaen, nangrugi idi tiyempo na pagitoldu ni Juan, hanggan ha yenan, dumudulog i tolay a hidi, a pumipilit hidi a magpasakop ha paghariyan na Dios. Maski i madukas a totolay, kayat di bila a pilitan a sumadap. ");
INSERT INTO duo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ta naalay dan a nepugto i pagdemat na paghariyan na Dios. Maski ha ngamin a sursurat na minahagpugto a hidi ken ngamin a sursurat na Linteg, nangipugto hidi megipu ha paghariyan na Dios. Ket niyaen, dinumemat dan ni Juan. ");
INSERT INTO duo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ket nu tahodan moy i kagi di, tahodan moy bila ni Juan. Ta hikuna i mangtongpal ha nepugto megipu ha ni Eliyas. Nepugto di a dumemat hikuna, ket niyaen, dinumemat dan. ");
INSERT INTO duo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Niyaen, ipeta ko ha nikam, a ha maski nu heya a makasaneg ha kagi ko, temanan na mina, ken nanakaman na bila.” ");
INSERT INTO duo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Intulos ni Jesus a kinagi na, “Anya i pangikalanan ko ha dagende a tolay a masegkat a manahod. Ikalan ko hidi ha annak a umetnod ha sentro, a magreklamo ha kagayam di, ");
INSERT INTO duo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Itukaran mi kam, ngem awan kam umuseg a magsala! Ket magimaton kami, ngem awan kam umuseg a magsanget!’ kon di. Ket kona bila hito ha dagende a totolay. ");
INSERT INTO duo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ta idi dinumemat ni Juan, pinabiyan na a magkan. Ket madiyan na a makiinum, gipu ha pakidios na. Ngem awan na hikuna tinahod na dagende a totolay. Ket awan hidi umuseg. Kinagi di, a ‘Nahayop dan hikuna!’ ");
INSERT INTO duo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ket dinumematak bila, a Annak na Dios a Nagbalin a Tolay. Ket makipagkanak ken makipaginomak. Ngem naglimad idagende a totolay. Ket awan hidi umuseg. Kinagi di, a ‘Entan moy! Madammot hikuna, ken mammartek. Ket makiilay hikuna ha madukas a hidi, maski i mahagpabuwis a hidi,’ kon di. Niyaen, nu magkagi hidi ha kona hay, pabiyanan ko la hidi. Ta awan a mabalin a tahodan na ak na totolay a kona hay. Ngem ha sabali a hidi, mabalin pala a melasin di i kinalaing na Dios. Basta maenta di i mappiya a paggimet ko ken pinaggimet ni Juan, ket makatandiyan di a atoy i sirib na Dios ha pagitoldu mi.” ");
INSERT INTO duo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Niyaen, nangbahang ni Jesus ha totolay a maghen ha il-ili a nakagimetan na ha makpal a milagro. Binahang na hidi, ta awan hidi nagbabawi ha liwaliwat di, maski naenta di dan i makpal a milagro. ");
INSERT INTO duo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","22","Kinagi na, “Sayang i taga-Korasin a hidi! Sayang ha totolay a taga-Betsayda! Ta dakdakkal i parusa na Dios ha nidi ngem ha madukas a hidi a taga-Tiro onu Sidon. Ta ginimet ko dan i makpal a milagro ha saguppang di, ngem awan hidi nagbabawi. Nu kona hay i ginimet ko mina ha saguppang na taga-Tiro ken taga-Sidon a hidi, sigurado a nagbabawi dan hidi. Inumetnod mina hidi ha abu, ket intennon di mina i kostal, a pagpaenta di ha pagladingit di ha liwaliwat di. Ket sinumina mina hidi a tahod ha madukas a ugali di. ");
INSERT INTO duo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sayang agay i taga-Kapernaum a hidi! Kasor di a magdeydeyaw ha baggi di. Ngem mebanghat nokkan hidi ha impyerno! Nu ginimet ko mina idagende a milagro ha ili a Sodoma, sigurado a nagbabawi hidi, ket awan mina hidi natutodan gipu ha parusa na Dios. ");
INSERT INTO duo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngem nokkan, ha pamalak a paghukom na Dios, tahod a dakdakkal i kagbi na ha taga-Sodoma a hidi ngem ha nidi a taga-Kapernaum. Ta awan nagbabawi i taga-Kapernaum a hidi, maski naenta di i milamilagro ko.” ");
INSERT INTO duo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Niyaen, ha iday a tiyempo, nagkararag ni Jesus, a kinagi na, “Hama ko, hikaw i Happo a makinlanget ken makinlutak. Ket magyamanak ha nikaw. Ta inpakatandi mo i kinatahod ha dagende a madibbi a ilay ko. Ngem sinalenan mo i pakakatandi na masirib kan a totolay, ken awan mo inpakatandi ha mapangas a hidi. ");
INSERT INTO duo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oni, Amang! Ta kona hito i pagayatan mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sana, kinagi ha tolduwan na a hidi, “Inyatad na Hama ko i ngamin a bagbagay ha nikan. Niyaen, awan ha tolay a makatandi ha Annak na Dios. I Hama ko la i makatandi ha Annak na. Ket awan ha tolay a makatandi ha Dios, nu awan la i Annak na, ken totolay a piliyan ko a makatandi mina ha Dios.” ");
INSERT INTO duo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ket kinagi paman ni Jesus, “Umangay kam ha nikan, hikam ngamin a makapoy ken marigatan. Ket pagemmangan takam. ");
INSERT INTO duo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magadal kam ha nikan, a tongpalan moy i pagitoldu ko. Ta maanusak ken napakumbaba, ket makaemmang kam ha pakiuseg moy ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mahusay i makauseg ha nikan. Ta awan ko parigatan i biyag moy, nu awan a aguman takam. Awan madaggi i pagimet ko ha nikam.” ");
INSERT INTO duo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Idi awan naalay, idi esa a Sabado, naglakalakad di Jesus ha talon. Atoy bila i tolduwan a hidi ni Jesus, ket nagiyalap hidi. Isu, nagaphok ken nagkasel hidi, a magkan ha dawa. ");
INSERT INTO duo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ngem atoy bila i Pariseyo a hidi, ket kinagi di ha ni Jesus, “Apay? Maggimet i toltolduwan mo ha maneg ha Linteg tam ha Sabado. Ta maneg kan a magtarabaho ha Sabado!” ");
INSERT INTO duo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Ngem kinagi ni Jesus, “Awan! Ta maski ha ni minappo tam a Dabid, awan moy dod nabasa i ginimet na, ken agagum na? Ta idi nagiyalap di Dabid, sinumadap hidi ha bilay na Dios. Ket inakot ni Dabid i tinapay a pangidatton na padi ha Dios. Ket nagkan hikuna ha denday. Ket ingiwat na bila ha agagum na, maski nu papadi la i mapalobusan a magkan ha iday a kalase na tinapay. ");
INSERT INTO duo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Anya ha papadi a hidi? Ta magtarabaho hidi, maski ha Sabado, penu isagana di i pangidatton di ha Dios. Anya, magliwat dod hidi, ta magtarabaho hidi ha Sabado? Awan man! Maski nu nesurat ha Linteg a umemmang kitam mina ha Sabado, awan ha liwat ha padi a hidi ha tarabaho di. Ta magserbe hidi ha Templo na Dios. ");
INSERT INTO duo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ket niyaen, ipeta ko ha nikam. Atoy pala ihe, ha saguppang moy, i mas mangina ken matmatangkay ngem ha Templo na Dios. ");
INSERT INTO duo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ket atoy bi a nesurat ha Libro na Dios, a makatandiyan moy mina. Kinagi na Dios, a ‘Kaykayat ko i pinagkagbi moy ha tolay ngem pangidatton moy,’ kon na Dios. Nu makatandiyan moy mina ide,” kagi ni Jesus, “awan moy paliwatan i tolay a awan ha liwat. ");
INSERT INTO duo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ta maturayak a mangipeta nu anya mina i gimetan tam ha Sabado. Hikan man i Annak na Dios a Nagbalin a Tolay.” ");
INSERT INTO duo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Niyaen, tinumulos ni Jesus a maglakad. Ket sinumadap hikuna ha esa a kapilya di a Judyo. ");
INSERT INTO duo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Atoy bila hay i esa a lakay a napilay ha kamat na. Ket kayat na Pariseyo a hidi a ipaliwat ha ni Jesus. Isu i gipu na a sinalodsod di, “Anya i palobus na Linteg ha Sabado? Palobusan na a magpahusay ha sakisaket a hidi, onu awan?” ");
INSERT INTO duo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ngem nakatandiyan ni Jesus i nakam di. Ket kinagi na, “Anya ha nikam? Nu matakneg ha abot i esa a karnero moy, awan moy dod guyodan a isalakan hikuna, maski nu Sabado? ");
INSERT INTO duo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Niyaen, mas mangina unay i tolay ngem ha karnero. Isu, ipalobus na Linteg i paggimet ha mappiya, maski ha Sabado.” ");
INSERT INTO duo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sa na, kinagi ni Jesus ha napilay, “Iyuyad mo dan i kamat mo.” Ket inyuyad na i kamat na, ket hinumusay, a kakalan na kamat na a esa. ");
INSERT INTO duo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ngem nagingal unay i Pariseyo a hidi. Ket linumapos hidi, a nakipaguhon nu panya mina i pangpatay di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Niyaen, katandi ni Jesus a kayat di Pariseyo a mangpatay ha nikuna. Isu, linumakad hikuna. Ket makpal i tinumagubet ha nikuna. Ket pinahusay na hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ket binon na hidi, a awan di mina ibaheta megipu ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Isu, gipu ta kona hito, natongpal i kinagi na Dios ken nesurat ni Isayas, a minahagpugto, ");
INSERT INTO duo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Atoy ide a tagabu ko a pinili ko. Hikuna i ayayatan ko ken pakatalakan ko unay. Iyatad ko ha nikuna i Espiritu ko. Ket ipakatandi na ha ngamin a tolay i malinteg a paghukom na Dios. ");
INSERT INTO duo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Maanus hikuna, a awan magingal ha pakipagtabbegan na. Ket awan hikuna magrangsit onu magdulaw ha mapigsa ha totolay. ");
INSERT INTO duo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Awan na parigatan i linumulupoy ha panahod di, nu awan na hidi a papigsaan. Ket daggapan na hidi, maski nu dandani a nobos i namnama di. Ta kagbiyan na hidi. Ket tumulos hikuna hanggan abakan na i ngamin a madukas ha lutak. ");
INSERT INTO duo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ket hikuna i namnamaan na ngamin a tolay, a pakesalakanan di.” Ide dan i kinagi na Dios megipu ha tagabu na a ni Jesu-Cristu. ");
INSERT INTO duo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Niyaen, neyangay ha ni Jesus i esa a lallaki a nabulsak ken bulol gipu ta hinayup na dimonyo. Ket pinalakad ni Jesus i dimonyo. Ket isu a makaenta ken magkagi manon ide a lallaki. ");
INSERT INTO duo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ket nasbew i ngamin a nakaenta. Kinagi di, “Hikuna wade i apo ni Dabid a tahokan tam ha naalay?” ");
INSERT INTO duo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ngem idi nateman na ito na Pariseyo a hidi, kinagi di, a “Inyatad ni Satanas i kaddat na ha ni Jesus, penu makapalakad hikuna ha dimonyo a hidi. Ta ni Satanas i kapitan na dimonyo a hidi,” kon di. ");
INSERT INTO duo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ngem katandi ni Jesus i nakam di. Isu a kinagi na, “Nu atoy i esa a bayan, ket makisina i kakaili na a hidi, a magnginayaw hidi, mabikan dan i pakarakrak na iday a bayan. Onu atoy i esa a pamilya, ket magleput i hama ha annak na, ket magleput bila i annak ha hena di, awan maalay i biyag na pamilya a kona ha iday. ");
INSERT INTO duo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Isu, nu masinasina dan i paghariyan ni Satanas, ket makipagngayaw i dimonyo a hidi ha sabali a dimonyo, panyan di a makatulos i paghariyan na? Awan a mabalin iday! ");
INSERT INTO duo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ngem kinagi moy a palakadan ko i dimonyo a hidi gipu ha kaddat ni Satanas. Niyaen, nu tahod a naggipu i kaddat ko ha ni Satanas, hadya naggipuwan na kaddat na agagum moy? Ta makapalakad bila hidi ha dimonyo! Hadya naggipuwan na kaddat di, nu awan bila a naggipu ha Dios. Isu, hidi man i magpatahod a madi i pagkagi moy ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","I kinatahod na, a gipu ha Espiritu na Dios i pangpalakad ko ha dimonyo. Ket ito i mangpaenta ha nikam a nakaabot dan ha nikam i paghari na Dios ha totolay.” ");
INSERT INTO duo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ket nagpangaregan ni Jesus, penu makatandiyan di a maski nu mapigsa ni Satanas, abakan na hikuna ni Jesus. Kinagi na, “Nu atoy i mapigsa a lallaki a magdapon ha bilay na, awan ha makasaddap ha bilay na, a magtakaw ha kukuwa na. Ngem basta naabak dan ide a mapigsa, ket negakad dan hikuna, mabalin bi a sumadap ha bilay na, ken mangalap ha ngamin a kukuwa na. Niyaen, kona bila hito ha nikan ken ni Satanas. ");
INSERT INTO duo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nu magpabiyan kam ha nikan, maabak kam bila. Masapul a umuseg kam ha nikan. Ta maski nu heya a awan umuseg ha nikan, mebilang a magsenti hikuna. Ket maski nu heya a awan dumaggap a magpapisan ha totolay, ibilang ko hikuna a mangpaadiyo ha totolay ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Isu i gipu na a ipeta ko ha nikam, a mapakawan i maski nu heya a makaliwat ken magkagi ha madukas. Ngem awan a mapakawan i magkagi ha mesenti ha Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ket maski nu atoy i magkagi ha mesenti ha nikan, a Annak na Dios a Nagbalin a Tolay, mapakawan hikuna. Ngem nu atoy i magsenti ha Espiritu na Dios ha pagkagi na, awan a mapakawan hikuna. Ta magnanayon a kelliwat i tolay a kona ha iday.” ");
INSERT INTO duo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ha mappiya a kayo, mappiya bila i bunga na. Ket ha madukas a kayo, madukas bila i bunga na. Ket melasin moy i kayo, nu mappiya hikuna onu madukas, gipu ha bunga na. ");
INSERT INTO duo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ket kona bila hito ha nikam, hikam a magkadukas a tolay! Panyan moy a magkagi ha mappiya, nu madukas paman i nakam moy? Ta nakam moy i paggipuwan na pagkagi moy. Ket i pagkagi na tolay i magpaenta nu anya i nakam na a tahod. ");
INSERT INTO duo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Isu, ha magnakanakam ha mappiya, mappiya bila i pagkagi na. Ngem ha magnakanakam ha madukas, madukas bi i pagkagi na. ");
INSERT INTO duo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Niyaen, ipeta ko ha nikam, a nokkan, ha pamalak a paghukom na Dios ha totolay, masapul na kada esa a magtabbeg gipu ha ngamin a madukas a kakkagi na. ");
INSERT INTO duo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ta gipu ha pagkagi moy, mepaenta nu mesalakan kam, onu maparusaan kam mina.” ");
INSERT INTO duo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Niyaen, atoy i kappal a Pariseyo ken mamaestro na Linteg a nagkagi ha ni Jesus, ha “Maestro, ipaenta mo bi i kaddat mo, penu makasigurado kami a pinaangay na ka na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngem tinabbeg ni Jesus, “Magkadukas ide a kalase na totolay. Ket kayat di kan maenta i kaddat na Dios, ngem talekodan di i pagitoldu na. Awan ha ipaenta ko ha nidi nu awan a kona ha nagimet ha minahagpugto a ni Jonas. ");
INSERT INTO duo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kona idi naghen hikuna ha tiyan na dakkal a padut, ha tallu a pamalak, kona bila ha iday i magimet ha nikan nokkan. Ta tallu a pamalak a melabbang ha disalad na lutak i Annak na Dios a Nagbalin a Tolay. ");
INSERT INTO duo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Ha pamalak a paghukom na Dios, tumaknag i taga-Ninibe a hidi, a mangpaliwat hidi ha nikam. Ta nagbabawi hidi ha liwaliwat di, idi nateman di i pagitoldu ni Jonas. Ngem niyaen, atoy dan ha saguppang moy i magitoldu ha nikam, ket mas matangkay ngem ha ni Jonas. Ngem awan moy temanan. ");
INSERT INTO duo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ket nokkan, ha pamalak a paghukom na Dios, tumaknag i Reyna a taga-Seba, a mangpaliwat ha nikam. Ta linumakad hikuna hanggan madiyo, penu magteman ha pagitoldu ni Hari Solomon. Ket niyaen, ipeta ko ha nikam, a atoy ha saguppang moy i mas matangkay ngem ha ni Hari Solomon. Ngem awan moy usegan i pagitoldu ko.” ");
INSERT INTO duo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ket tinumulos ni Jesus, “Maski nu lumapos i dimonyo ha baggi na tolay, lumakalakad hikuna ha namadi a lugar, a mageriyok ha pagemmangan na. Ngem awan na maeriyokan ha pagemmangan. ");
INSERT INTO duo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Isu, ipeta na ha baggi na, ‘Sumoliyak mina ha lallaki a naghenan ko idi,’ kon na dimonyo. Pagdemat na ha lallaki a naghenan na, ket maenta na a maurnos i biyag na lallaki ken malinis. Ngem awan ha asak na nakam na. ");
INSERT INTO duo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Isu, umangay manon i dimonyo aye, ket alapan na i pitu a dimonyo a mas madukas ngem ha nikuna. Ket sumadap hidi ngamin. Ket maghen hidi ha ide a lallaki. Isu a magbalin ha mas madukas ngem idi pinagsaket na esa la a dimonyo. “Niyaen,” kon ni Jesus, “ide dan i pangaregan ko ha nikam. Ta kona bila hito i magimet ha ide a kalase na tolay a awan mangiyasak ha nakam di ha pagitoldu na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Idi nagitoldu pala ni Jesus, dinumitang i hena ken lallaki a wawaddi na. Naghen hidi ha lapos, ta kayat di a makiuhon ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ket kinagi na esa a tolay ha ni Jesus, “Atoy i hena ken wawaddi mo ha lapos. Kayat di ka maenta.” ");
INSERT INTO duo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ngem kinagi ni Jesus, “Heya i hena ko? Heya i kakabsat ko?” ");
INSERT INTO duo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sana, intoldu i tolduwan na a hidi. Kinagi na, a “Entan moy hidi. Ta idagende i hena ko ken kakabsat ko. ");
INSERT INTO duo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ta maski nu heya a magtongpal ha pagayatan na Dios, hidi man i hena ken kakabsat ko a tahod.” ");
INSERT INTO duo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Idi pamalak hito, linumapos ni Jesus ha bilay, ket inumangay hikuna a nagetnod ha baybay. ");
INSERT INTO duo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ket makpal i dinumulog ha nikuna. Isu, linumugan hikuna ha abang, a pagetnodan na. Ket nagtaknag idagende a totolay ha baybay a magteman. ");
INSERT INTO duo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ket makpal i inestoriya ni Jesus a pangpakatandi na ha nidi. Kinagi na, “Nikuna, atoy i esa a mannalon a magmula ha bin-i. ");
INSERT INTO duo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Idi nagmula hikuna, netakneg i kappal a bin-i ha dilan. Ket tinumagmak i manok a hidi, a kinan di idenday a bin-i. ");
INSERT INTO duo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Atoy bila i kappal a bin-i a netakneg ha kabituwan a ballik la i lutak na. Ket gipu ta madibbew iday a lutak na, nasigida a nagtubo idagenday a bin-i. ");
INSERT INTO duo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ngem idi hinumangkat i senggit, nalannas hidi ken napohpoh, ta awan hidi unay nakapagramot. ");
INSERT INTO duo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ket atoy bila i kappal a bin-i a netakneg ha kasesetan. Idi dinumakkal idagende a tinumubu, dinumakkal bila i seset a hidi. Ket nasalenan i tinumubu a hidi. ");
INSERT INTO duo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ngem atoy i kappal a bin-i a netakneg ha mappiya a lutak. Ket idi dinumakkal hidi, nagdawa hidi ngamin. Atoy kappal a nagdawa ha esa gasut a bukal ha kada esa a bin-i a netakneg. Ket atoy bi i nagdawa ha annam a pulo. Ket atoy paman i nagdawa ha tallu a pulo. ");
INSERT INTO duo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Nu makasaneg kam ha kakkagi ko, makatandiyan moy mina ito,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nagsalodsod i agagum ni Jesus, “Apay a usaran mo idagende a pangareg ha pagitoldu mo?” ");
INSERT INTO duo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ket kinagi ni Jesus, “Ipakatandi ko ha nikam i palimed na Paghariyan na Dios. Ngem ha sabali a tolay a awan makiuseg ha nikan, awan ko hidi pakatandiyan. ");
INSERT INTO duo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gipu ta maski nu heya a umuseg ha kagi na Dios, inayon na Dios i pagkatandi na hanggan makpal i makatandiyan na. Ngem ha maski nu heya a awan umuseg ha kagi na Dios, adyan na Dios i pagkatandi na. ");
INSERT INTO duo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Niyaen, ide i gipu na a usaran ko i pangareg ha pagitoldu ko. Ta maski nu maenta diyak, awan diyak katandi. Ket maski nu makangteman hidi ha estoriya ko, awan di makatandiyan. ");
INSERT INTO duo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Natongpal dod i pinapugto na Dios ha ni Isayas. Ta insurat na, ‘Tahod a magteman hidi, ngem awan di makatandiyan. Ket tahod a magenta hidi, ngem awan di melasin, ");
INSERT INTO duo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","gipu ta malupoy dan i nakam na dagende a totolay. Ket marigat a makateman i talinga di. Ket ikillap di i mata di. Ta madiyan di a makalasin ken makasaneg. Madiyan di a makatandiyan. Madiyan di a magsoli ha nikan, penu pahusayan ko mina hidi,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ket tinumulos ni Jesus, a kinagi na ha agagum na, “Ngem bakkan ha nikam. Ket mahusay kam, ta makalasin ken makasaneg kam ha kinatahod megipu ha palimed na Paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta ipeta ko ha nikam a atoy idi i makpal a mahagpugto ken mappiya a tolay a kayat di a maenta i netan moy, ngem awan di naenta. Kayat di a mateman i temanan moy, ngem awan di nateman. ");
INSERT INTO duo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Niyaen, ide dan i kayat ko a kagiyan ha estoriya ko megipu ha pagmula. ");
INSERT INTO duo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Magkalan i bin-i ha kagi na Dios. Ket i dilan a nataknegan na bin-i, iday i magkalan ha makateman a hidi ha kagi na Dios, ngem awan di nakatandiyan. Ta dumemat ni Satanas, ket magadya hikuna ha kagi na Dios ha nakam di. ");
INSERT INTO duo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ket i kabitubituwan a nataknegan na bin-i, iday i magkalan ha magteman a hidi ha kagi na Dios, ket magragsak hidi a makateman. ");
INSERT INTO duo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngem awan meyasak i kagi na Dios ha nakam di. Isu, manahod hidi ha ballik la. Ket nokkan, nu marigatan hidi gipu ha panahod di, magsigida hidi a sumoli ha ugali di a madukas. ");
INSERT INTO duo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","I kasesetan a nataknegan na bin-i, iday i magkalan ha magteman a hidi ha kagi na Dios, ngem makaburibur hidi megipu ha korinat ken pagragsakan di. Isu, mesalen i pagnakam di ha makpal a buribur na. Ket awan di manakam i kagi na Dios. Ket awan magbunga i kagi na Dios ha nakam di gipu ha salen heya. ");
INSERT INTO duo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Niyaen, i mappiya a lutak a nataknegan na bin-i, iday i magkalan ha magteman a hidi ha kagi na Dios, ket makatandiyan di ken iyasak di ha nakam di. Ket ha totolay a kona he, umusoseg hidi hanggan mebunga di i mappiya a paggimi-gimet. Ha kappal, makpal unay i mappiya a gimigimetan di. Ket ha kappal, makpal bila i mappiya a gimetan di. Ket ha kappal, ballik i mappiya a gimetan di.” ");
INSERT INTO duo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Atoy pala i sabali a pangareg a inestoriya ni Jesus. Kinagi na, “Mekalan i Paghariyan na Dios ha esa a tolay a nagmula ha mappiya a bin-i ha talon na. ");
INSERT INTO duo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngem idi esa a kallap, idi nakakillap hidi, inumangay i kasenti na a nagmula ha madukas a root, a melaok ha nagmulaan na makintalon. Sa hikuna, linumakad. ");
INSERT INTO duo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Isu, idi dinumakkal idagende a nemula, ket nagdawa hidi, atoy bila i madukas a root a hidi. ");
INSERT INTO duo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ket inumangay i tagatagabu na makintalon aye, ket kinagi di, ‘Apo, mappiya i bin-i a inmula mo ha talon mo. Ngem niyaen, apay a narootan a kona he ha madukas?’ ");
INSERT INTO duo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kinagi na makintalon, ‘Atoy i kasenti ko a naggimet ha ide.’ Ket sinalodsod na tagabu na a hidi, ‘Kayat mo a parutan mi idagende a madukas a root?’ ");
INSERT INTO duo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngem tinabbeg na makintalon, ‘Awan. Ta baka maparut i mappiya a tubo, nu parutan moy i madukas a root. ");
INSERT INTO duo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabiyanan moy hidi a dumakkal hanggan tiyempo na pagani. Ket nokkan ha pinagani, ipeta ko ha magani a hidi a parutan di idagende a root. Ket badbadan di, penu ipatutod ko. Ket kobosan na, aniyan di mina i mappiya a pahay. Ket iponpon di ha kamalig ko.’” ");
INSERT INTO duo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Atoy pala i sabali a pangareg a inestoriya ni Jesus. Kinagi na, “Mekalan i Paghariyan na Dios ha esa a bukal na mustasa a inmula na lallaki ha lutak na. ");
INSERT INTO duo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Niyaen, ide a bukal i kaballikan na ngamin a bukal. Ngem nu magtubu dan, magbalin ito ha kadakkalan a mula. Ket kona ha kayo i kinadakkal na, a magrabo-rabon i manok a hidi ha tingitingi na. Ket kona bila hito i pagtubu na paghariyan na Dios ha kakpalan a tolay.” ");
INSERT INTO duo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Atoy pala i sabali a pangareg a inestoriya ni Jesus. Kinagi na, “Mekalan i Paghariyan na Dios ha lebadura a iyasak na esa a babbey ha makpal a kasukat na arina na. Ket gipu ha ide a ballik a lebadura, umalis ito hanggan bumigalbigal i ngamin a neramas a arina. Ket kona bila hito i pagiyalis na Paghariyan na Dios ha totolay.” ");
INSERT INTO duo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ha ngamin a pagitoldu ni Jesus, inestoriya na idagende a pangareg. Awan ha intoldu na a awan na inestoriya i pangareg. ");
INSERT INTO duo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Isu a nangtongpal ha esa a nesurat na minahagpugto, nikuna a naalay dan, ket megipu ha Cristu a paangayan na Dios. Insurat na, “Iboyboy ko i pangareg ha pagitoldu ko. Ket ipakatandi ko i bagbagay a awan makatandiyan na totolay, nangrugi idi pinarsuwa na Dios ide a lutak hanggan ha niyaen,” kon na Cristu. ");
INSERT INTO duo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Idi kobosan na pinagitoldu ni Jesus, linakadan na i kakpalan a hidi a tolay. Ket sinumadap hikuna ha bilay. Ket binumikan i tolduwan na a hidi, a inaged di, “Ipakatandi mo bi ha nikami i pangareg mo, megipu ha madukas a root ha kapahayan.” ");
INSERT INTO duo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kinagi ni Jesus, “Ha iday a pangareg ko, hikan a Annak na Dios a Nagbalin a Tolay i nagmula ha mappiya a bin-i. ");
INSERT INTO duo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","I kakalan na talon, i lutak aye a henan na totolay. I mappiya a bin-i i annak na Dios a masakopan na ha Paghariyan na. I madukas a root, i annak na kasenti ko a nasakopan na. ");
INSERT INTO duo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","I kasenti ko a nagmula ha madukas a hidi, hikuna ni Satanas. I tiyempo a pinagani, i tiyempo a paghukom na Dios ha ngamin a tolay. I magani a hidi, i anghel a hidi na Dios. ");
INSERT INTO duo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ket kona bila ha pangareg ko, a nabadbad i root a hidi, ket natutod hidi; kona bila hito ha tiyempo a paghukom na Dios. ");
INSERT INTO duo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ta hikan a Annak na Dios a Nagbalin a Tolay i magpaangay ha anghel a hidi, a puhonan di i ngamin a mahagsulisog ken ngamin a mahagliwat. ");
INSERT INTO duo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ket itogbak di hidi ha gangatan a awan maaddap. Ito i henan na magsangisanget a hidi ken magrangsirangsit gipu ha parusa di. ");
INSERT INTO duo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngem ha annak na Dios, mapuhon hidi ha henan na. Ket magdisyag hidi, a kona ha senggit ha Paghariyan Nama di a Dios. “Niyaen, nu makasaneg kam ha kagi ko, nanakaman moy mina a perpermi.” ");
INSERT INTO duo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mekalan i Paghariyan na Dios ha kanginaan a kukuwa a nekali ha talon. Ket atoy i esa a nakaeriyok ha ide. Ket gipu ha talak na, itago na manon. Ket umangay hikuna a iyatad i ngamin a sanikuwa na, penu magatang na iday a talon ken kanginaan na. ");
INSERT INTO duo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Mekalan bila i Paghariyan na Dios ha esa a mahagilako a magerieriyok ha inaamakan a perlas. ");
INSERT INTO duo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Naeriyokan na i esa a kainamakanan a perlas, ket umangay hikuna a iyatad na i ngamin a sanikuwa na, a panggatang na ha iday a perlas.” ");
INSERT INTO duo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Mekalan bila i Paghariyan na Dios ha esa a sigay a nesawat ha diget, ket maalap na i ngamin a kalase na padut. ");
INSERT INTO duo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nu naputat dan, iyakdet di, ket magetnod hidi, penu piliyan di idagende a padut. Ha mappiya a padut, iyasak di hidi ha pagdattonan di. Ngem mebanghat i madukas a hidi. ");
INSERT INTO duo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ket kona bila hito ha tiyempo a paghukom na Dios. Dumemat i anghel a hidi, a piliyan di i mappiya a totolay ha madukas a hidi. ");
INSERT INTO duo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ket ibanghat di i madukas a totolay ha gangatan a awan maaddap. Ito i henan na magsangisanget ken magrangsirangsit gipu ha parusa na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sinalodsod ni Jesus ha tolduwan na a hidi, “Makatandiyan moy i ngamin a inestoriya ko ha nikam?” “Oni, makatandiyan mi ito,” kon di. ");
INSERT INTO duo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ket kinagi na ha nidi, “Isu, niyaen, ha maski nu heya a tolduwan ko, magserbe mina hikuna ha Paghariyan na Dios. Ket hikuna a mismo i mangitoldu paman ha totolay. Ket malaing mina hikuna ha alegid a Pagitoldu na Dios ken ha ide a Bigu a Pagitoldu na Dios, a kanayon mina a makagayak ha nakam na, penu mangitoldu, gipu ha kasasaad na tolduwan na a hidi.” ");
INSERT INTO duo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Idi nobos a inestoriya ni Jesus idagende a pangareg, linakadan na iday a lugar. ");
INSERT INTO duo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Inumangay hikuna ha Nasaret, ha ili a dinakkalan na. Ket nagitoldu hikuna ha paggimmongan di. Ket nalaktat i Judyo a hidi a nagteman ha nikuna. Kinagi di, “Hadya i nangalapan na ha kon na he a sirib ken kaddat na a maggimigimet ha milagro?” kon di. ");
INSERT INTO duo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Hikuna i annak ni Karpentero Jose. Ket ni Maria i hena na. Ket katandi tam i wawaddi na, a di Santiyago, Jose, Simon ken Judas. ");
INSERT INTO duo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ket atoy bila a kaili tam i wawaddi na a babbey. Apay dod a sabali hikuna, a malaing dan a magitoldu?” kon di. ");
INSERT INTO duo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ket ide i gipu na a madiyan di a manahod ha ni Jesus. Ket kinagi ni Jesus megipu ha ide, “Ha mahagpugto a naggipu ha Dios, mapadayawan hikuna ha ngamin a lugar, malaksid ha ili na ken pamiliya na a mismo.” ");
INSERT INTO duo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Isu, ballik la i nakadatan a ginimet ni Jesus ha ili na, gipu ta awan di hikuna tinahod. ");
INSERT INTO duo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Idi tiyempo hito, naghari pala ni Herod ha Galileya. Ket nabaheta na megipu ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Isu, kinagi ni Herod ha tagabu na a hidi, “Hikuna wade ni Juan a Minahagbinyag, a magbiyag manon a naggipu ha katay. Isu i gipu na a kekkaddat hikuna.” ");
INSERT INTO duo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Niyaen, pinatay na dan ni Herod ni Juan, idi pinadakap na hikuna ken pinebalud na. Ta kona he i kayat ni Herodiyas, a ipag ni Herod. (Ni Herodiyas i kabanga ni Pelip a wadi ni Herod.) ");
INSERT INTO duo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ta indarum ni Juan ide a kinagi na, a “Nagliwat kam, ta kinabanga mo dan i ipag mo,” kon na. ");
INSERT INTO duo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Niyaen, ha kona he i pakatayan ni Juan. Naalay dan a kayat ni Herod a papapatay ni Juan. Ngem nanteng hikuna ha tolay a hidi, gipu ta inbilang di ni Juan a esa a Mahagpugto na Dios. ");
INSERT INTO duo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Niyaen, idi pagselebral na pinakeenak ni Herod, atoy i inkari ni Herod ha esa a madiket, a annak ni Herodiyas. Idi nagsala ide a madiket ha saguppang na bisita na a hidi, nagragsak ni Herod, a kinagi na, “Isapata ko a iyatad ha nikaw i maski nu anya a agedan mo,” kon ni Herod. ");
INSERT INTO duo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ket gipu ha kayat nena na, kinagi na madiket, a “Iyatad mo bi i buntok ni Juan a Mahagbinyag, a pesaguppang mo bi ihe a nebandehado,” kon na madiket. ");
INSERT INTO duo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Niyaen, nagladingit unay ni Hari Herod. Ngem gipu ha inkari na ha saguppang na sangaili na a hidi, inbon na a matungpal ide a inaged na madiket. ");
INSERT INTO duo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ket pinaputolan na ni Juan ha pagbaludan. ");
INSERT INTO duo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sa, neyangay i buntok na a nebandehado, ket neyatad ito ha madiket, ken inyatad na paman ha nena na. ");
INSERT INTO duo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Idi nabaheta na toltolduwan ni Juan, inumangay hidi, a inalap di i bangkay na. Ket inlabbang di. Sa hidi, inumangay a inbaheta di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Idi nabaheta ni Jesus i katay ni Juan, linakadan na iday a lugar, a naglugan hikuna ha abang, a inumangay ha esa a lugar a awan ha tolay. Ngem idi pakabaheta na totolay, tinumagubet hidi, a namaybay hidi a naggipu ha palebut na. ");
INSERT INTO duo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Idi kappundu di Jesus ha baybay, naenta na i kakpalan a tolay. Ket kinagbiyan na hidi. Ket pinahusay na i magsaket a hidi. ");
INSERT INTO duo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Idi apon dan, binumikan i tolduwan na a hidi, a kinagi di, a “Apo, dandani dan a kallap, ket awan ha bilay ha ide a lugar. Palakadan mo bi idagende a tolay, penu umangay hidi ha baryo, a gatangan di mina i kakanan di.” ");
INSERT INTO duo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ngem kinagi ni Jesus, “Awan a masapul a lumakad hidi. Hikam mina i magpakan ha nidi.” ");
INSERT INTO duo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ket tinabbeg na tolduwan na a hidi, “Panyan tam mina? Ta lima la a tinapay ken duwa a padut a pindang i bilon tam.” ");
INSERT INTO duo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kinagi ni Jesus, “Ikunna moy he.” ");
INSERT INTO duo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sana, pinagetnod idagende a totolay ha karootan. Ket inalap na i lima a tinapay ken duwa a pindang. Ket tinumangad hikuna ha langit. Ket nagyaman hikuna ha Dios. Sa na, pinilakpilak, ket inyatad na ha tolduwan na a hidi, a inwaras di. ");
INSERT INTO duo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ket nagkan hidi ngamin. Ket idi nabbiyag hidi ngamin, pinuhon di i sobra. Ket naputat di i esa pulo ket duwa a basket ha buhay di. ");
INSERT INTO duo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","I nagkan a hidi i manga lima a ribu a lallaki. Ket atoy bila i kabanga di ken annak di a awan a nebilang. ");
INSERT INTO duo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Idi pinagsoli ni Jesus i kakpalan a tolay ha bilay di, pinalugan na i tolduwan na a hidi ha abang, a pinapalungo na hidi a umarabes ha dibelew na diget. ");
INSERT INTO duo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kobosan a pinaglakad na hidi, nagisesa ni Jesus a tinanobuk ha amugod, penu magkararag. Idi kallap dan, naghen hikuna hito a isesa. ");
INSERT INTO duo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ket ha iday a oras, nakaadiyo i tolduwan na a hidi, a nasalpak di i napigsa a pahas ken raknab. ");
INSERT INTO duo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Idi kaldiwan, inumangay ni Jesus ha nidi, a naglakad hikuna ha dibbew na diget. ");
INSERT INTO duo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ngem nanteng i tolduwan na a hidi, idi naenta di hikuna a maglakad ha dibbew na diget. Ket nagrangsit hidi gipu ha kanteng di. “Inay! Anito iday!” kon di. ");
INSERT INTO duo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngem dagus a kinagi ni Jesus, “Awan kam manteng. Hikan ni Jesus.” ");
INSERT INTO duo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Niyaen, kinagi ni Pedro, a “Apo, nu tahod a hikaw ni Jesus, ayaganak mo bi a umangay ha nikaw, a maglakad ha diget.” ");
INSERT INTO duo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ket kinagi ni Jesus, “Uyoy ka he.” Isu, inumogsad ni Pedro ha abang, a naglakad ha dibbew na diget, a inumangay ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngem idi naenta na i kinapigsa na pahas, nanteng manon hikuna. Isu a inumlad hikuna, ket indulaw na, “Apo, isalakanak mo bi!” ");
INSERT INTO duo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ket dagus a inegkaman ni Jesus i kamat ni Pedro, ket ginuyod na. Sana, kinagi, “Nagballik dalla i panahod mo. Apay a nagduwaduwa ka?” ");
INSERT INTO duo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Niyaen, idi linumugan hidi a duwa ha abang, ginumimak i pahas. ");
INSERT INTO duo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ket ha tolduwan na a hidi, dineydeyaw di ni Jesus, a kinagi di, “Tahod a hikaw i Annak na Dios!” ");
INSERT INTO duo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Niyaen, idi kaahabes di, pinumundu hidi ha Genesaret. ");
INSERT INTO duo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ket nelassin na tolay a hidi ni Jesus. Ket pinaayagan di i ngamin a masaksaket ha ngamin a barbaryo ha palebut na. Ket neyangay hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ket nagaged hidi a nu mabalin kan, palobusan na mina i masaket a hidi a magkamhit ha nibik na kagay na. Ket ha ngamin a nangkamhit ha kagay na, naghusay hidi ngamin. Kona hito i kinapigsa na panahod di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Niyaen, inumangay ha ni Jesus i Pariseyo a hidi ken mamaestro na Linteg a naggipu ha Jerusalem. Ket sinalodsod di, ");
INSERT INTO duo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Apay a awan umuseg i tolduwan mo a hidi ha pinagitoldu na minappo tam a Judyo? Ta awan di ugisan i kamat di, a magkan. Isu, kelliwat pala i kamat di, ket maneg ito ha nikitam a Judyo.” ");
INSERT INTO duo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ket tinabbeg ni Jesus, “Apay a liwatan moy i bobon na Dios, penu makauseg kam ha pinagitoldu na minappo moy? ");
INSERT INTO duo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Halimbawa: nesurat ni Moyses ide a bon na Dios, a ‘Deyawan mo i hama ken hena mo,’ ken ‘Maski nu heya a magulew ha hama na onu hena na, masapul a mapapatay hikuna,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ngem ha nikam, bakkan i pagitoldu moy. Ta itoldu moy a mabalin a mekemot i korinat a pangdaggap mina ha hama moy ken hena moy. Basta ipeta moy ha nidi, a ‘Neyatad dan ide ha Dios’. Ito i pagpambar moy, penu ikemot moy i korinat. ");
INSERT INTO duo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Isu, pinagbalin moy a awan serserbe i kagi na Dios gipu ha bukod moy a pagitoldu. ");
INSERT INTO duo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ay! Hikam a aginpappiya! Tahod i kagi na Dios megipu ha nikam. Ta pinasurat na Dios ha ni Isayas nikuna, a nepugto na, ");
INSERT INTO duo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Magdeydeyaw ha nikan idagende a tolay gipu ha kagi di,’ kon na Dios. ‘Ngem madiyo pala i nakam di ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Awan ha serbe na pinagdeyaw di ha nikan. Ta ipeta di a Dios i paggipuwan na pagitoldu di. Ngem bakkan a Hikan nu awan a tolay i paggipuwan na pagitoldu di,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ket ayagan ni Jesus i totolay, a pinapisan na hidi. Kinagi na, “Magsaneg kam mina ha kagi ko aye, ket makatandiyan moy mina. ");
INSERT INTO duo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bakkan a metemlok i makapadukas ha baggi na tolay, nu awan a dumukas i baggi na gipu ha bukod na a nakam ken kasorhan na, ken paggimi-gimet na a gipu ha kasorhan na heya. Ito i tahod a makapadukas ha tolay.” ");
INSERT INTO duo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kobosan na ito, inumangay i tolduwan na a hidi, a sinalodsod di, “Makatandiyan mo a napasakitan i Pariseyo a hidi gipu ha kinagi mo?” ");
INSERT INTO duo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ket tinabbeg ni Jesus, “Pabiyanan moy hidi. Ha maski nu anya a tumubo a awan nemula Nama ko a Dios, potpotan na hidi. ");
INSERT INTO duo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Isu, kabeng moy hidi. Ta kona hidi ha mabulsak a mangidilan ha kakalan di a nabulsak. Ket nu idilan na esa a bulsak i agum na a bulsak, tumakneg hidi a duwa ha abot.” ");
INSERT INTO duo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ket kinagi ni Pedro, “Ipakatandi mo bi iday a pangaregan mo nakoya.” ");
INSERT INTO duo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ket kinagi ni Jesus, “Maski ha nikam, awan moy pala makatandiyan? ");
INSERT INTO duo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Katandi moy mina a awan makapadukas i measak ha labi na tolay. Ta awan ito sumadap ha nakam na, nu awan la ha tiyan na. Sa na, iyattay, ket nelapos manon. ");
INSERT INTO duo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngem bakkan i lumalapos ha labi na tolay. Ta ito i maggipu ha nakam na. Ket nu madukas i pagkagi na, ito i makapadukas ha ngamin a biyag na tolay. Ito i mangpatahod a madukas i nakam na. ");
INSERT INTO duo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","I nakam na totolay i paggipuwan na kinadukas na totolay, a kona ha madukas a panggep di ken pagbuno di, ken paggundaway di ha sabali a kabanga, ken pangibabbey onu pangilallaki di, ken pagtakaw di, ken pagsileng di ken paglimad di, ket atoy paman i sabasabali a kona hito. ");
INSERT INTO duo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Idagento i makapadukas ha totolay. Ngem awan ha liwat i magkan a awan maguges ha kamat na.” ");
INSERT INTO duo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Niyaen, linumakad manon ni Jesus hanggan ha luglugar a Tiro ken Sidon. ");
INSERT INTO duo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ket inumangay ha nikuna i esa a babbey a taga-Kanaan, ket bakkan hikuna a Judyo. Indulaw na a mapigsa ha ni Jesus, “Apo, Annak ni Hari Dabid! Kagbiyanak mo bi! Narigatan unay i annak ko a babbey, a nahayop dan na dimonyo!” kon na babbey. ");
INSERT INTO duo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngem awan ha kinagi ni Jesus. Ket inaged na tolduwan na a hidi, “Palakadan mo bi ide a babbey. Ta awan gumimak i pagidulaw na!” ");
INSERT INTO duo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kinagi ni Jesus, “Napaangayak la ha totolay a nasakop ha Israel a kona ha netawtaw a karkarnero.” ");
INSERT INTO duo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngem nagparintumeng i babbey ha saguppang ni Jesus, a kinagi na, “Apo, daggapanak mo bi!” ");
INSERT INTO duo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ket kinagi ni Jesus, “Madi nu alapan ko i kanan na annak, a itogbak ko ha asasu.” ");
INSERT INTO duo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ket nakatandiyan na babbey i kinagi na, a masapul a daggapan ni Jesus i Judyo a hidi ha palungo na bakkan a Judyo. Isu, kinagi na, “Tahod i kagi mo, Apo. Isu, mabalin bi a magkan i asu a hidi ha regreg a maggipu ha Happo di.” ");
INSERT INTO duo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ket kinagi ni Jesus, “Tahod, Manay! Dakkal i panahod mo! Matongpal dod i agedan mo.” Ket dagus a hinumusay i annak na. ");
INSERT INTO duo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Niyaen, linumakad manon ni Jesus a namaybay ha Diget na Galileya. Sa, nanohobuk ha esa a pukal, ket nagetnod. ");
INSERT INTO duo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ket dinumulog ha nikuna i makpal a tolay. Ket intugan di i makpal a pilay, ken lugpi, ken bulsak, ken bulol, ken makpal pala a kona hito. Insaguppang di hidi ha ni Jesus, ket pinahusay na hidi. ");
INSERT INTO duo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ket nalaktat ide a kakpalan a tolay. Ta naenta di a makakagi manon i bulol a hidi, ket nakahusay i lugpi a hidi, ket makalakad manon i pilay a hidi, ket makaenta manon i bulsak a hidi. Ket indeydeyaw di i Dios a magtongpal ha kari na ha Israel. ");
INSERT INTO duo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Niyaen, inayagan ni Jesus i tolduwan na a hidi. Ket kinagi na, “Kagbiyan ko idagende a totolay. Ta tallu dan a pamalak a naghen hidi ha nikan. Ket niyaen, awan dan ha kanan di. Ket madiyan ko hidi a palakadan, amangan nu makapoy hidi ha dilan, ta magiyalap hidi.” ");
INSERT INTO duo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ket tinabbeg na tolduwan na a hidi, “Hadya i pangalapan tam ha kanan a mekusto ha ide a kakpal. Awan man ha kanan ha lugar aye.” ");
INSERT INTO duo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ket sinalodsod ni Jesus, “Atoy hangan a tinapay moy?” Ket kinagi di, “Pitu, ken kappal a baballik a padut.” ");
INSERT INTO duo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Niyaen, pinagetnod ni Jesus i kakpalan a hidi. ");
INSERT INTO duo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sana, inalap i pitu a tinapay ken padut a hidi. Idi pinagyaman na ha Dios, tinaptappeng na ito, a inyatad na ha toltolduwan na, a inwaras di ha dagenday a kakpalan. ");
INSERT INTO duo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ket nagkan hidi ngamin hanggan nabbiyag hidi. Kobosan na, naurnong i buhay a kanan. Ket naputat i pitu a basket ha nabuhay. ");
INSERT INTO duo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Manga uppat a ribu i lallallaki a nagkan. Ket nagkan bila i babbabbey ken annak a hidi a awan nebilang. ");
INSERT INTO duo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kobosan na, pinaglakad ni Jesus i kakpalan a hidi. Ket naglugan di Jesus ha abang, a inumangay hidi ha lugar a Magadan. ");
INSERT INTO duo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Niyaen, inumangay ha ni Jesus i kappal a Pariseyo ken Saduseyo. Ket kayat di a magsurbar ha nikuna. Isu, inaged di i milagro a pangpatahod na mina a pinaangay na hikuna na Dios. ");
INSERT INTO duo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Ngem kinagi ni Jesus, “Malaing kam ha pagkatandi moy ha tiyempo a paguden onu pagsenggit. Ta nu apon dan, ket nu maenta moy a madideg i langit, ipeta moy a mappiya a tiyempo, ta magsenggit nu ugma. Onu agsapa, ket nu maenta moy a madideg ken mangiset i ulap a hidi, ipeta moy a maguden nokkan. Niyaen, malaing kam bas ha tiplad na pagdemat na Annak na Dios. Ta atoy dan i makpal a tiplad a pangpakatandi ha tiyempo na Annak na Dios aye. Ngem awan moy hidi makatandiyan. ");
INSERT INTO duo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Madukas unay ide a kalase na totolay. Ta awan di nakaman i Apo Dios a tahod. Kayat di kan a maenta i milagro a pangpatahod, kon na kan, ngem pulos, a awan ha pangpatahod a mepaenta ha nidi, nu awan i pangpatahod ni Jonas. Ta kona ha natay hikuna ha tallu a pamalak, sa, minagbiyag manon.” Kinagi na ito ni Jesus. Sa na, linakadan hidi. Ket naglugan manon ha abang a umarabes ha diget. ");
INSERT INTO duo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Niyaen, idi pagdemat di Jesus ha dibelew, awan ha kanan di. Ta naleptanan na tolduwan na a hidi a magbilon ha tinapay. ");
INSERT INTO duo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ket iniwadan ni Jesus ha nidi, a kinagi na, a “Magingat kam ha lebadura na Pariseyo ken Saduseyo a hidi.” ");
INSERT INTO duo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ket awan di nakatandiyan i kinagi na. Nagkinagi hidi a, “Awan kitam ha tinapay. Isu i gipu na a kinagi na iday,” kon di. ");
INSERT INTO duo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ngem katandiyan ni Jesus i pagguhonan di. Ket kinagi na, “Apay a pagguhonan moy a awan kam ha tinapay? Ballik wade i panahod moy? ");
INSERT INTO duo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Anya? Awan moy makatandiyan? Nanakaman moy mina i lima a tinapay a inpakan tam ha lima a ribu a lallaki, ken ngamin a basket a nabuhay a inurnong moy. ");
INSERT INTO duo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ket nanakaman moy mina i pitu a tinapay a inpakan tam ha uppat a ribu a lallaki, ken ngamin a nabuhay a naurnong moy. ");
INSERT INTO duo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Niyaen, makatandiyan moy mina a bakkan a tinapay i nagkagiyan ko, nu awan i pagitoldu na Pariseyo ken Saduseyo a hidi. Ta umaales i kinadukas di, a kona ha lebadura ha tinapay.” ");
INSERT INTO duo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sadi, nakatandiyan a awan na nagkagiyan i tinapay, nu awan i pagitoldu na Pariseyo ken Saduseyo a hidi, a magingat mina hidi ha kinadukas di. ");
INSERT INTO duo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Niyaen, inumangay di Jesus ha bariobario a Sesareya-Pilipo. Idi paglakad di, sinalodsod ni Jesus ha tolduwan na a hidi, “Anya i nakam na totolay megipu ha nikan? Heya ak wade ha pagkagi di?” ");
INSERT INTO duo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ket tinabbeg di, “Kinagi na kappal a hikaw kan ni Juan a Minagbinyag, ket minabiyag manon. Ket kinagi na kappal a hikaw kan ni Eliyas, a nagsoli a nagipu ha langit. Ket kinagi na kappal a hikaw kan ni Jeremiyas, onu esa a minahagpugto a minabiyag manon, kon na kan.” ");
INSERT INTO duo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sinalodsod ni Jesus, “Hikam bi, anya ha nakam moy? Heya ak wade ha nikam?” ");
INSERT INTO duo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tinabbeg ni Pedro, “Hikaw i Cristu, i Annak na Tahod a Dios. Ket pinaangay na ka, penu maghari ha ngamin a tolay.” ");
INSERT INTO duo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kinagi ni Jesus, “Mahusay ka, Simon a annak ni Jonas. Ta bakkan a tolay, nu awan a ni Amang ko a Dios i nangipakatandi ha ide ha nikaw. ");
INSERT INTO duo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ket niyaen, panagenan taka ha ‘Pedro.’ (Ha kagi na Judyo, i kayat na kagiyan na ‘Pedro’ i ‘pogedu.’) Ta gipu ha kinagi mo aye, nagbalin ka dan a kona ha esa a pogedu na Dios. Ket i pogedu a kona hito i pagpataknagan ko i kapilya ko. I kapilya ko aye i ngamin a nasakop ko a tolay. Ket basta kona hito i panahod di, mapigsa hidi, a awan ha mangabak ha nidi, maski ni patay. ");
INSERT INTO duo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iyatad ko ha nikaw i turay mo, a kona ha magegkam ka ha tulbek a panglukat ha Paghariyan na Dios. Ket gipu ha turay aye a naggipu ha Dios, nu atoy ikemot mo ha kapilya ko, kona bi ha Dios i mangikemot. Ket nu atoy i palobusan mo, kona bi ha Dios i mangpalobus.” ");
INSERT INTO duo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kobosan na, inbon ni Jesus a awan di pala ipeta ha maski nu heya a hikuna i Cristu. ");
INSERT INTO duo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Niyaen, nangrugi ha ide a tiyempo, nagitoldu ni Jesus ha tolduwan na a hidi megipu ha baggi na. Ket inpakatandi na masapul a umangay hikuna ha Jerusalem, ket atoy i makpal a rigrigat a attaman na. Kinagi na, “Nokkan, umadi hidi ha nikan, hidi a matangkay a papadi, hidi a mangituray ha kapilya, ken hidi a maestro na linteg. Ket ipapatay di ak. Ket nu malpas i tallu a pamalak, magbiyagak manon.” ");
INSERT INTO duo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Idi nateman ito ni Pedro, inyadiyo na ni Jesus ha ballik, a makitabbegan mina hidi. Kinagi na, “Awan mina, Apo! Ikemot na ka mina na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ngem sinumaggupang ni Jesus ha ni Pedro, ket kinagi na, “Umadiyo ka dan! I kinagi mo aye i kagi ni Satanas! Magsalen ka ha nikan! Ta bakkan a Dios i paggipuwan na nakam mo, nu awan a tolay i paggipuwan na.” ");
INSERT INTO duo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kobosan na, kinagi ni Jesus ha tolduwan na a hidi, “Ha maski nu heya a mayat a magpasakop ha nikan, masapul a ibilang na i baggi na a kona ha natay dan. Ta masapul a bakkan a bukod na a pagayatan i gimetan na, nu awan i pagayatan ko i gimetan na mina. Ket nu kona hito, maattam na i rigrigat, penu umunod ha nikan. Ket kona ha baklayan na bila i kudos na ha pinaguseg na ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ta maski nu heya a magnakam la ha biyag na a mismo, hikuna i matay nokkan a tahod. Ngem maski nu heya a umusoseg ha nikan, maski nu matay hikuna gipu ha nikan, isalakan na hikuna na Dios a tahod. ");
INSERT INTO duo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Ta kona paman ha ide,” kagi ni Jesus, “nu atoy i tolay a makaalap ha ngamin a kinabaknang na lutak aye, awan ha serbe na iday, nu lompas i biyag na, a awan na mapadas i biyag na Dios a magnanayon. Ta awan ha pangsulet na tolay ha Dios, penu makabiyag mina hikuna ha Dios ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Magsoli ak nokkan, ket kaagumanak na anghel a hidi. Ket ha kasoli na Annak na Dios a Nagbalin a Tolay, mepaenta i kainamakan Nama ko. Ket hukoman ko i ngamin a tolay, a bilasan ko hidi gipu ha ginimet di. ");
INSERT INTO duo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Niyaen, ipeta ko ha nikam, a atoy dan ha saguppang tam aye i kappal a awan matay hanggan makaenta hidi ha ide a Annak na Dios a Nagbalin a Tolay, a magturayak ha Paghariyan ko.” ");
INSERT INTO duo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kobosan na annam a pamalak, insina ni Jesus ni Pedro, ken ni Santiyago, ken wadi na a ni Juan, a tinumagdak ha matangkay a parabin. ");
INSERT INTO duo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pagsangpit di, ket nagbigu i itsura ni Jesus ha saguppang di. Nagranyag i rupa na a kona ha senggit. Ket nagbalin maponset i tennon na, a nagpahiyamhiyam hidi. ");
INSERT INTO duo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ket nagpaenta ni Moyses ken ni Eliyas, a nakiuhon hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ket kinagi ni Pedro ha ni Jesus, “Apo, mappiya, ta atoy kami ihe. Nu kayat mo, magtoklongak ha tallu. Ket esa para ha nikaw, esa para ha ni Moyses, ken esa para ha ni Eliyas,” kon na. ");
INSERT INTO duo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pagkagi pala ni Pedro, ket bigu la a naulapan hidi ha esa a madisyag a ulap. Ket nagkagi i esa a timek a naggipu ha ulap, a kinagi na, a “Ide i Annak ko a ayayatan ko unay. Temanan moy hikuna!” kon na timek. ");
INSERT INTO duo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Niyaen, ha dende a tallu a tolduwan ni Jesus, idi nateman di ito, hinumakab hidi, a nanteng hidi unay. ");
INSERT INTO duo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ngem binumikan ni Jesus, ket kinamhet na hidi, a kinagi na, “Tumaknag kam. Awan kamon manteng.” ");
INSERT INTO duo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Idi tinumangad hidi, awan ha naenta di, nu awan la ni Jesus a esesa. ");
INSERT INTO duo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Niyaen, idi pagbugsok di ha parabin, binonan na hidi, a kinagi na, “Awan moy pala ipeta ha maski nu heya a tolay i naenta moy aye. Imbes na, urayan moy hanggan nokkan, ha kobosan na pagbiyag ko manon, a naggipu ha natay.” ");
INSERT INTO duo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ket kinagi di ha ni Jesus, “Inpeta mo dan a matay ka ket magbiyag manon nokkan. Ngem ha pagitoldu na mamaestro na Linteg, ipeta di a masapul a sumoli ni Elias, a magpalungo mina ha pagdemat na Cristu.” ");
INSERT INTO duo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tinabbeg ni Jesus, “Tahod i kinagi na maestro a hidi na Linteg. Ta palungo, umangay ni Elias, penu paggayakan na i ngamin. ");
INSERT INTO duo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ket niyaen, ipeta ko ha nikam, a inumangay dan ni Elias. Ngem awan di hikuna nelassin. Linoko di hikuna. Ket ginimet di ha nikuna i ngamin a kinaykayat di. Ket pinatay di. Ket kona bila hito i gimetan di nokkan ha nikan. Ta parigatan di bila i Annak na Dios a Nagbalin a Tolay.” ");
INSERT INTO duo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Idi kinagi na ito ni Jesus, nakatandiyan di a ni Juan a Minahagbinyag i pagkagiyan na. Hikuna man i kakalan ni Eliyas. ");
INSERT INTO duo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Niyaen, nagsoli di Jesus ken tallu a kinakuyog na. Pagdemat di, ket naenta di i kakpalan a tolay. Ket atoy i esa a lallaki a inumangay ha ni Jesus a nagparentumeng, ket kinagi na, ");
INSERT INTO duo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apo, kagbiyan mo bi i annak ko. Ta atoy i magpayagyag ha baggi na ken magpahabhab ha labi na. Ket permi i rigrigat na. Kanayon a matakneg hikuna ha gangatan, onu ha dinom. ");
INSERT INTO duo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niyaen, intugan ko dan ha toltolduwan mo, a pahusayan di mina. Ngem awan di kaya,” kon na lallaki. ");
INSERT INTO duo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ket kinagi ni Jesus, “Makillu i totolay a awan ha panahod. Apay a awan kam manahod? Kahangan kaalay i paganus ko ha malupoy a panahod moy? Kahangan kaalay i paghen ko ha nikam, penu manahod kam talaga?” Ket intulos ni Jesus, “Iyangay mo he i annak mo.” ");
INSERT INTO duo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ket binon ni Jesus i dimonyo, sa, linakadan na dimonyo i annak. Ket dagus a nakahusay ide a annak. ");
INSERT INTO duo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kobosan na, inumangay a nalimed i tolduwan na a hidi. Ket sinalodsod di, “Apay a awan ha kabaelan mi a magpalakad ha dimonyo?” ");
INSERT INTO duo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kinagi ni Jesus, “Gipu ta kulang i panahod moy. Nu atoy mina i maski ballik a panahod moy, a kona ha kadakkal na bukal na mustasa, makaadya kam ha maski anya a rigrigat. Maski ipeta moy ha ide a amugod, ‘Umalis ka, ket hen ka dan ha ho,’ ket umalis hikuna. ");
INSERT INTO duo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngem ha kona he a dimonyo, awan moy maadya nu awan a permi i pagkararag moy a pabiyanan moy a magkan.” ");
INSERT INTO duo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Niyaen, idi naghen hidi ha Galileya, kinagi ni Jesus ha tolduwan na a hidi, “Mabikan dan i tiyempo a pagdakap di ha Annak na Dios a Nagbalin a Tolay. Ket igiwat di ak ha kasenti ko a hidi. ");
INSERT INTO duo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ket patayan di ak. Ngem ha mekatallu a pamalak, magbiyagak manon a maggipu ha katay.” Idi natiman di ito, nagladingit unay i tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Niyaen, inumangay di Jesus ha Kapernaum. Pagdemat di, ket binumikan ha ni Pedro i esa a mahagpabuwis, para ha Templo na Dios. Kinagi na ha ni Pedro, “Anya, magbubuwis i maestro mo para ha Templo, onu awan?” ");
INSERT INTO duo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ket tinabbeg ni Pedro, “Oni ah.” Kalpasan na ito, pagdemat ni Pedro ha bilay, ket nagpalungo ni Jesus a magkagi. “Simon,” kon ni Jesus, “Anya i nakam mo? Anya i ugali na hari a hidi ha ide a lutak? Magpabuwis i hari ha annak na, onu sabali i pagalapan na ha korinat na?” ");
INSERT INTO duo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tinabbeg ni Pedro, “I sabali a hidi i pagalapan na ha buwis.” Ket kinagi ni Jesus, “Isu, awan a masapul a magbuwis i annak na a hidi. Ket kona bila hito ha nikan ken Hama ko a Dios. ");
INSERT INTO duo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngem maski nu kona hito, malaka la a magbuwis kita, penu awan hidi magingal ha nikitam. Isu, umangay ka dan ha diget, a magbanwit ka. Ket ha palungo a padut a maalap mo, pagangakan mo i labi na, ket maeriyokan mo tihay i korinat a pagbuwis ta. Alapan mo iday, ket hen mo a bayadan i buwis ta.” ");
INSERT INTO duo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Idi tiyempo hito, inumangay ha ni Jesus i toltolduwan na, a sinalodsod di, “Ha Paghariyan na Dios, heya ha nikami i katangkayan?” ");
INSERT INTO duo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Inayagan ni Jesus i esa a annak, a pinataknag na ha saguppang di. ");
INSERT INTO duo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Sana, kinagi ha nidi, “Entan moy i annak aye. Awan hikuna magnakam nu panyan na a magpatangkay ha baggi na. Isu, nanakaman moy mina ide a ipeta ko ha nikam, a nu awan kam magbabawi ha kinapangas moy, a magbalin a kona ha ide a annak, awan kam makasaddap ha Paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ha maski nu heya a magpadibbi ha baggi na, a magbalin a kona ha annak aye, hikuna i katangkayan a tolay ha Paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ket maski nu heya a magrespitar ha mapadibbi a tolduwan ko, a kona ha annak aye, mebilang a respitaran na ak bila. ");
INSERT INTO duo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ngem maski nu heya a magpasina ha madibbi a tolduwan ko ha pagitoldu na Dios, maparusaan hikuna. Mas mappiya ha nikuna nu megakad i dakkal a pogedu ha tangad na, ket metogbak hikuna ha diget. Ta marigat unay i parusa na Dios ha tolay a kona hay. ");
INSERT INTO duo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Sayang agay ha totolay ha lutak aye. Ta makpal i pakasulisogan di, ket awan di malisiyan. Ngem dakdakkal i parusa ha maski nu heya a magsolisog ha kakalan na a tolay. ");
INSERT INTO duo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Niyaen, nu atoy i maski kona ha kamat onu tikad mo i mangiturong ha nikaw ha liwaliwat, katolan mo mina. Ta mas mappiya nu lompas la i kamat onu tikad mo, basta maghen ka ha Dios ha magnanayon. Basta awan ka sumadap ha impyerno, a kekkamat ka ken kettikad ka a duwa ken marigatan ka hay ha gangatan a awan umaddap. ");
INSERT INTO duo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ket kona bila hito ha mata mo. Nu atoy mina i kona ha mata mo, ket iturong na ka ha liwaliwat, suatan mo dan. Ta mas mappiya a bulding ka a maghen ha Dios ha magnanayon, ngem atoy i duwa a mata mo, ket metogbak ka ha impyerno.” ");
INSERT INTO duo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Niyaen, ha dagende a madibbi a tolduwan ko, a kona ha annak, magingat kam mina a awan moy hidi pasanikiyan. Ta ipeta ko ha nikam a madaponan hidi gipu ha anganghel na Dios a kanayon a makasaguppang ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pati hikan a Annak na Dios a Nagbalin a Tolay. Ta inumangayak he penu isalakan ko i totolay a sinumina dan ha Dios. ");
INSERT INTO duo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Anya ha nakam moy? Maganya i esa a tolay, nu atoy i esa gasut a karnero, ket lompas i esa ha nidi? Itirak na idagenday a siyam a pulo ket siyam ha pahagdaponan na ha nidi, ket umangay hikuna a mageriyok ha esa a linompas. ");
INSERT INTO duo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ket ipeta ko ha nikam, a nu maeriyokan na, magragsak hikuna. Ket dakdakkal i ragsak na ha iday a esa a naeriyokan na, ngem ha ngamin a karnero na a awan linompas. ");
INSERT INTO duo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ket kona bila hito ha Nama moy a Dios. Madiyan na a mapukaw i maski esa ha dagende a madibbi a tolay, a awan mina ha sumina ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nu makaliwat ha nikaw i kabsat mo, umangay ka mina ha nikuna, a makiuhon kam a duduwa. Ket ipakatandi mo ha nikuna i liwat na. Nu temanan na i kakkagi mo, napasoli manon i pagkakabsat moy. ");
INSERT INTO duo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngem nu madiyan naka temanan, alapan mo i esa onu duwa a makiuseg ha nikaw, ket sumoli kamon. Ta sistiguwan di mina i ngamin a pakiuhon moy. ");
INSERT INTO duo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ket nu madiyan na hidi temanan, ipakatandi mo ha kakabsat moy ha kapilya. Nu madiyan na a temanan i kakabsat moy ha kapilya, ibilang mo dan hikuna a kona ha esa a bakkan a manahod, a sinumina dan ha Dios. ");
INSERT INTO duo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ket tahod ide a ipeta ko ha nikam, a gipu ha pakiusegan moy ha Dios, mabalin moy a ikemot ha kapilya moy, ket kona bi ha Dios i mangikemot. Onu atoy i palobusan moy ha kapilya, ket kona bi ha Dios i mangpalobus. Kona hito i turay moy a maggipu ha Dios. ");
INSERT INTO duo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ket ipeta ko manon ha nikam, a atoy i turay moy a maggipu ha Dios. Ket basta magisesa kam ha pagkararag moy, tungpalan Nama ko a Dios i agedan moy, maski nu duwa kam la a magkararag. ");
INSERT INTO duo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gipu ta maski nu duwa onu tallu i makipisan gipu ha panahod di ha nikan, ket atoyak bila ha nidi.” ");
INSERT INTO duo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Niyaen, binumikan ni Pedro ha ni Jesus, ket sinalodsod na, “Apo, maminhangan a masapul a pakawanan ko i agum ko a makangliwat ha nikan? Maski mamimpitu?” ");
INSERT INTO duo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ket kinagi ni Jesus, “Awan la a mamimpitu. Basta pakawanan mo hikuna. Ket kabeng mon nu hangan a beses. Maski hanggan awan. ");
INSERT INTO duo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Isu i pangareg ko aye, ket mekalan i paghariyan na Dios ha esa a hari a kayat na i makikuwenta ha tagabu na a hidi. ");
INSERT INTO duo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Idi pakikuwenta na, neyangay ha nikuna i esa a tagabu a nakagahut ha balle na rinibribu a pisos. ");
INSERT INTO duo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngem awan ha umanay a pagbayad na. Isu, inbon na hari a melako ide a tagabu na, pati i kabanga na, annak na ken ngamin a kukuwa na, penu makabayad hikuna ha gahut na. ");
INSERT INTO duo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Niyaen, nagparentumeng i tagabu ha saguppang na happo na, ket nagpakagbi. ‘Apo, pasensiyaanak mo bi ha ballik la a tiyempo, ket bayadan ko i ngamin a gahut ko ha nikaw,’ kon na tagabu. ");
INSERT INTO duo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ket kinagbiyan hikuna na happo na a hari. Ket pinakawan na i gahut na, sana, pinalakad ide a tagabu. ");
INSERT INTO duo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ngem niyaen, linumapos ide a tagabu. Ket naenta na i esa a agum na a nakagahut ha nikuna ha esa gasut a pisos. Ket dakapan na hikuna, ket binikkal na, a kinagi na, ‘Nay ka, magbayad ka dan ha gahut mo ha nikan.’ ");
INSERT INTO duo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ket nagparentumeng i nakagahut, ket nagpakagbi. ‘Pasensiyaanak mo bi ha ballik a tiyempo, ket bayadan taka,’ kon na nakagahut. ");
INSERT INTO duo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngem madiyan na temanan i agum na. Imbes na, intugan na hikuna, a pinebalud na, hanggan ha mabayadan na mina i gahut na. ");
INSERT INTO duo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Niyaen, naenta na ito na kakalan na a hidi a tagabu. Ket nagsaket i nakam di, gipu ta awan ha kagbi ni tagabu ha agum na. Isu, inumangay hidi ha hari, ket inpakatandi di i ngamin a nagimet. ");
INSERT INTO duo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ket pinaayagan ni hari ni tagabu, a inpeta na, ‘Madukas ka a tagabu! Maski pinakawan ko dan i ngamin a gahut mo, gipu ta nagpakagbi ka ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngem niyaen, awan ka ha kagbi ha agum mo! Kagbiyan mo mina hikuna a kon na ha pinagkagbi ko ha nikaw!’ kon na hari. ");
INSERT INTO duo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ket gipu ha pagingal na hari, pinebalud na ni tagabu, penu maparusa, hanggan a mabayadan na i ngamin a gahut na.” ");
INSERT INTO duo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Niyaen,” kagi ni Jesus, “kona bila hito i gimetan Nama ko a Dios, nu awan moy pakawanan i kabsat moy a tahod.” ");
INSERT INTO duo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Niyaen, idi kobos ni Jesus a magitoldu, linakadan na i probinsiya a Galileya, ket inumangay ha Judeya, ha dibelew na Karayan Jordan. ");
INSERT INTO duo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ket atoy bila i makpal a tolay a tinumagubet ha nikuna. Ket pinahusay na hidi. ");
INSERT INTO duo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Niyaen, inumangay ha nikuna i kappal a Pariseyo, penu silowan di mina gipu ha salodsod di. Isu a sinalodsod di, “Anya? Ipalobus wade na Linteg a isina na lallaki i kabanga na, maski nu anya i gipu na?” ");
INSERT INTO duo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tinabbeg ni Jesus, “Awan moy dod nabasa ide a paset na Libro na Dios? ‘Idi pinarsuwa na Dios i lutak, ginimet na i lallaki ken babbey, a magkabanga mina hidi.’ ");
INSERT INTO duo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ket kinagi na Dios, ‘Ide i gipu na a lakadan na lallaki i daddakkal na, penu makiagum ha kabanga na, ket magbalin hidi a esesa’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Isu,” kagi ni Jesus, “awan hidi a duwa, nu awan a esa dan hidi. Niyaen, gipu ta pinagesa na hidi na Dios, madi nu pagsinaan na hidi na tolay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ngem sinalodsod paman na Pariseyo a hidi, “Oni, ngem apay a inbon ni Moyses a meyatad na lallaki ha kabanga i kasuratan na pinagsina di, sana, mapalakad i kabanga na?” ");
INSERT INTO duo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ket kinagi ni Jesus ha nidi, “Gipu ha kinaigat na buntok moy. Gipu ta madiyan moy a magteman. Isu i gipu na a inpalobus ni Moyses a isina moy i kabanga moy. Ngem awan a kona hito idi naparsuwa i lutak. ");
INSERT INTO duo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Niyaen, nanakaman moy mina ide, a ha maski nu heya a lallaki a mangisina ha kabanga na, sa, mangabanga ha sabali, maski awan nangilallaki i kabanga na heya, makaliwat hikuna ha saguppang na Dios. Ket kona nu nangibabbey dan hikuna.” ");
INSERT INTO duo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kinagi na tolduwan na a hidi, “Nu kona hay i kasasaad na magkabanga, mas mappiya a awan ha mangabanga.” ");
INSERT INTO duo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ngem tinabbeg ni Jesus, “Awan ha makatongpal ha ide nu awan la hidi a pagbalinan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ha kappal a lallaki, awan hidi makakabanga, gipu ta kurang la i kinalallaki di idi neenak hidi. Ha kappal, awan hidi makakabanga, gipu ta nakapon hidi. Ngem ha kappal, madiyan di a magkabanga, penu makatulos hidi ha pinagserbe di ha Dios, a awan mina ha magtappag ha pinagserbe di. “Niyaen, ha maski nu heya a mannakabalin a magserbi ha Dios ha kona ihe, magserbi mina hikuna.” ");
INSERT INTO duo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Idi esa a pamalak, atoy i kappal a nangiyangay ha annak di ha ni Jesus, penu itupu na i kamat na ken ikararagan na hidi. Ngem idi netan na agagum ni Jesus, binahang di hidi a nangiyangay ha annak. ");
INSERT INTO duo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngem kinagi ni Jesus, “Palobusan moy a umangay i annak a hidi ha nikan. Awan moy hidi salenan. Ta kona ha dende a annak i magpasakop a hidi ha Dios a paghariyan na.” ");
INSERT INTO duo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ket intupo na i kamat na ha nidi, sa linumakad. ");
INSERT INTO duo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Niyaen, atoy esa a lallaki a inumangay ha ni Jesus, a kinagi na, “Maestro, anya mina i mappiya a gimetan ko, penu maghenak ha Dios ha magnanayon?” ");
INSERT INTO duo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ket kinagi ni Jesus, “Apay wade a hikan i salodsodan mo megipu ha mappiya a paggimet? Atoy la isesa a mappiya. Awan ha mappiya nu awan la i Dios. Niyaen, nu kayat mo a maghen ha Dios ha magnanayon, tongpalan mo i Linteg na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ket sinalodsod na lallaki, “Anya a linteg?” Ket kinagi ni Jesus, “Awan ka magbuno, awan ka mangibabbey, awan ka magtakaw, awan ka magsileng onu magswitik. ");
INSERT INTO duo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ket deyawan mo i hama ken hena mo. Ket ayatan mo i kakalan mo a tolay a kona ha pinagayat mo ha baggi mo. Idagende i bon na Dios ha nikaw,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ket kinagi na lallaki, “Maestro, tinongpal ko dan i ngamin a dagenday. Isu, anya pala i masapul ko?” kon na. ");
INSERT INTO duo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ket kinagi ni Jesus, “Nu kayat mo a awan ha pagkurangan mo, hen mo ilako i ngamin a aruwatan mo. Ket iyatad mo ha napobre a hidi i naglakwan mo. Ket umusoseg ka dan ha nikan. Nu gimetan mo ide, atoy i kinabaknang mo ha Dios, a alapan mo nokkan.” ");
INSERT INTO duo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ngem idi nateman na ito na lallaki, naladingit hikuna, ket linumakad a silaladingit. Ta nabaknang hikuna unay. ");
INSERT INTO duo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ket kinagi ni Jesus ha tolduwan na a hidi, “Ipeta ko ha nikam, a marigat a sumadap i mabaknang ha paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ipeta ko paman ha nikam, a mas malaka a meturok i makadakklan ha abot na dagum, ngem makasaddap i mabaknang ha paghariyan na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nalaktat unay i tolduwan na a hidi, idi nateman di ito. Isu, sinalodsod di, “Nu kon na hito, heya i mesalakan nokkan? Pulos wade a awan ha mehusto a maghen ha Dios ha magnanayon!” kon di. ");
INSERT INTO duo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ket inaamatan na hidi ni Jesus, a kinagi na, “Tamos. Awan a makesalakan i tolay ha baggi na. Ngem maski nu anya a awan a mabalin ha tolay, mabalin paman ha Dios. Ta magimet na Dios i maski nu anya.” ");
INSERT INTO duo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ket kinagi ni Pedro, “Apo, atoy kami ihe, ket intirak mi i ngamin a kukwa mi, penu umuseg kami ha nikaw. Anya wade i gungguna mi?” ");
INSERT INTO duo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kinagi ni Jesus ha nidi, “Tahod ide a ipeta ko ha nikam, a pabiguwan na Dios nokkan ide a lutak. Ket nokkan, magetnodak ha inaamakan a pagetnodan ha Paghariyan ko. Maski hikam a umusoseg ha nikan, makipagetnod kam bila, a mangituray kam ha ngamin a Judyo a apapo na esapulo ket duwa a annak ni Israel. ");
INSERT INTO duo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ket ha maski nu heya a magayat ha nikan ha dakdakkal ngem ha ngamin a kukwa na, magbiyag hikuna ha Dios ha magnanayon. Ket nu intirak na i bilay na, i patakka onu hama ken hena na, onu annak na, onu lutak na, penu umusoseg ha nikan, tahod a atdinan hikuna na Dios ha makpal a gungguna, a nasursurok. Ket magbiyag hikuna ha Dios ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngem ha makpal a matangkay niyaen, mapadibbi hidi nokkan. Ket ha makpal a madibbi niyaen, hidi man i patangkayan na Dios nokkan.” Ito i inkari ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Niyaen, kinagi ni Jesus, “Ta mearig i paghariyan na Dios ha esa a makintalon a magpatarabaho ha tarabahador a hidi. Idi nasapa, linumapos hikuna a mageriyok ha tangdanan na a magtarabaho ha talon na. ");
INSERT INTO duo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nakitulag hikuna ha tangdanan na a hidi, ket mamisu i tangdan di ha magmalmalem. Sana, pinaangay hidi ha talon na. ");
INSERT INTO duo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Idi alas nuwebe, inumangay hikuna ha tiyendaan, ket naenta na i kappal a atoy hay, ta awan hidi ha tarabaho. ");
INSERT INTO duo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kinagi na, ‘Magtarabaho kam bila ha talon ko, ket tangdanan takam nokkan ha mekusto a tangdan moy.’ Ket inumangay hidi a nagtarabaho. ");
INSERT INTO duo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Nagkalan i ginimet na idi alas dose ken alas tres. Linumapos hikuna a nagpatarabaho. ");
INSERT INTO duo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Idi dandani dan a alas singko, linumapos hikuna manon, ket naenta na i kappal a awan ha tarabaho. Ket kinagi na ha nidi, ‘Apay a dadailan moy i tiyempo moy a magmalmalem?’ ");
INSERT INTO duo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kinagi di, ‘Awan kami ha tarabaho.’ Isu, kinagi na makintalon, ‘Hen kam bila a magtarabaho ha talon ko,’ kon na. ");
INSERT INTO duo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Niyaen, idi apon dan, kinagi na makintalon ha porman, ‘Nay, ayagan mo i tarabahador a hidi, ket tangdanan mo hidi. Ket irugi mo ha nagdilokod a sumadap.’ ");
INSERT INTO duo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Isu, natangdanan i tarabahador a hidi, nangrugi ha nidi a sinumadap idi alas singko. Ket natangdanan hidi ha mamisu. ");
INSERT INTO duo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ket dinumemat i tarabahador a hidi a nagpalungo, ket kagin di a tangdanan na hidi ha dakdakkal, ta dakdakkal i tarabaho di. Ngem mamisu bila i tangdan di. ");
INSERT INTO duo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Idi ginumiwat hidi ha tangdan di, nagreklamo hidi ha makintalon. ");
INSERT INTO duo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kinagi di, ‘Esa la a oras i pinagtarabaho na dagende a nagdilokod. Ngem anya ha nikami? Nagattam kami ha pasi na singgit a nagmalmalem. Apay a magkalan la i tangdan mi?’ ");
INSERT INTO duo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ket kinagi na makintalon ha esa ha nidi, ‘Ilay ko, awan taka dinaya. Nagtulag kitam a mamisu i magmalmalem. ");
INSERT INTO duo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Isu, alapan mo dan i tangdan mo, ket lumakad ka. Kayat ko a ikalan i tangdan mo ha intangdan ko ha nagdilokod a hidi. ");
INSERT INTO duo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ta ide i kalintegan ko, a manggasto ha kuwarto ko gipu ha pagayatan ko a mismo. Anya? Umapal ka wade gipu ta sibubuslon i pagiyatad ko?’ kon na makintalon. ");
INSERT INTO duo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Isu,” intulos ni Jesus, “mearig ito ha paghariyan na Dios. Ta magkalan man i panggungguna na Dios ha totolay a nasakop na. Ket maski ha madibbi a hidi a sumadap ha dilokod, magkalan i gungguna di a kona ha nagpalungo. Ket ha nidi a nagpalungo, ket magpatangkay ha baggi di, mapadibbiyan hidi, ta magkalan man i gungguna di.” ");
INSERT INTO duo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Niyaen, idi paglakad di Jesus ha Jerusalem, inyadiyo na i esa pulo ket duwa a tolduwan na, ket kinagi na ha nidi, ");
INSERT INTO duo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Temananak moy bi. Umangay kitam niyaen ha Jerusalem. Ket nu dumitang kitam, megiwat i Annak na Dios a Nagbalin a Tolay ha matangkay a hidi a padi ken maestro a hidi na linteg. Ket hukoman di ak a mapapatay. ");
INSERT INTO duo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sadi ak, igiwat ha gangannaet a hidi abakan a Judyo. Ket kayagan di ak, ken sabdan di ak, ken pelansa di ak ha kudos. Ket kobosan na tallu a pamalak, magbiyagak manon.” ");
INSERT INTO duo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Idi kinagi na ito ni Jesus, binumikan i kabanga ni Sebedeyo, ket intugan na i annak na a duwa. Nagparentumeng hikuna ha saguppang na a magaged ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kinagi ni Jesus, “Anya i kayat mo?” Ket kinagi na bakas, “Apo, nokkan nu maghari ka, ket magetnod ka ha kahariyan mo, ipalobus mo bi a makipaghari ha nikaw idagende a duwa a annak ko. Maski umetnod i esa ha kanawan mo ken esa ha kanigid mo.” ");
INSERT INTO duo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ngem tinabbeg ni Jesus, “Awan moy makatandiyan i agedan moy. Anya, kaya moy a attaman i rigrigat a attaman ko nokkan?” Ket tinabbeg di Santiyago, “Oni. Kaya mi dan.” ");
INSERT INTO duo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ket kinagi ni Jesus, “Tahod a marigatan kam nokkan, a kona ha nikan. Ngem bakkan a hikan i mangpili ha agum ko a maghari onu makikaetnod ha nikan. Ta Hama ko la i makatandi ha iday. Hikuna i naggayak ha pagtuturay ha paghariyan ko.” ");
INSERT INTO duo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Niyaen, idi nabaheta na sangapulo a agagum di, nakaingal hidi ha magkabsat aye, gipu ha inaged di. ");
INSERT INTO duo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Isu, inayagan ni Jesus idagende a sangapulo ket duwa. Ket kinagi na, “Katandiyan moy i ugali na magtuturay ha ide a lutak. Ket madaggi i pangibonan di ha totolay, a turayan di. ");
INSERT INTO duo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngem masapul a awan a kona hito ha nikam. Ta maski nu heya a magturay mina ha nikam, masapul a magpadibbi hikuna ha baggi na, a magserbe ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Oni ah. Ta maski nu heya a maging matangkay mina ha nikam, masapul na a padibbiyan i baggi na a magbalin a kona ha tagabu moy a magdaggap ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ta kona bila hito ha nikan a Annak na Dios a Nagbalin a Tolay. Awanak inumangay penu padaggapanak ha totolay, nu awan penu daggapan ko hidi. Ket ide i gipu na a iyatad ko i biyag ko a pangsaka ha makpal a tolay.” ");
INSERT INTO duo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Idi linumapos di Jesus ha ili a Jeriko, tinumagubet i kakpalan a tolay. ");
INSERT INTO duo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Niyaen, atoy bila i duwa a bulsak a nakaetnod ha hikeg na karsada. Idi nabaheta di a tumataleb ni Jesus, nagayag hidi, “Apo ni Dabid, kagbiyan mo kami!” ");
INSERT INTO duo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ngem binahang na hidi na kakpalan, ket sinaway di hidi a awan mina hidi magkagi. Ngem impigsa di bulsak i pagayag di, “Happo, apo ni Dabid, kagbiyan mo kami!” ");
INSERT INTO duo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ket tinumaran ni Jesus, a nagayag ha nidi, a sinalodsod na, “Anya i kayat mo a gimetan ko ha nikam?” ");
INSERT INTO duo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ket kinagi di bulsak, “Apo, kayat mi manon a makaenta.” ");
INSERT INTO duo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kinagbiyan hidi ni Jesus, ket kinamhet na i mata di. Ket dagus a nakahusay hidi a makaenta manon. Ket inumunod hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Idi bumibikan di Jesus ha ili a Jerusalem, dinumemat hidi ha Betpeg, a mabikan ha amugod na Olibet. Ket pinaangay ni Jesus i duwa a tolduwan na, ");
INSERT INTO duo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a kinagi na ha nidi, “Umangay kam ha baryo ha kalipat aye. Ket atoy ha ruwangan na i kabayo ken urbon na. Lakbisan moy bi hidi, a iyangay moy ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu atoy i magsalodsod, ipeta mos, a ‘Kasor ni Apo ide, ket ipasoli na a dagus,’ kon moy ah.” ");
INSERT INTO duo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Niyaen, nagimet ito penu matungpal i kinagi na minahagpugto idi, ");
INSERT INTO duo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","a “Ipeta mo ha totolay ha Jerusalem,” kagi na Dios, “Entan moy. Dumemat ha nikam i hari moy. Maanus hikuna ken masaniki. Nagpadibbi hikuna ha baggi na a magsakay ha urbon na kabayo,” kon na Dios. ");
INSERT INTO duo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Isu, inumangay i tolduwan ni Jesus a ginimet di i nebon na. ");
INSERT INTO duo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ket linaged di i kabayo ken urbon na. Ket pinalayat di i tennon di. Ket nagsakay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ket makpal a tolay i nangiyabak ha tennon di ha dilan. Ket atoy i kappal a nagkatol ha tengi-tengi na kayo, ket indatton di ha dilan. (Ta kona ihe i pangdeyaw di penu mepaenta di a matulok hidi ha hari.) ");
INSERT INTO duo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ket nagdeydeyaw i kakpalan a nagpalungo ha ni Jesus ken hidi a inumunod, a kinagi di, “Deyawan tam i apo ni Dabid! Deyawan tam i Hari a pinaangay na Dios! Deyawan tam i Dios a katangkayan!” ");
INSERT INTO duo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Niyaen, kassaddap ni Jesus ha Jerusalem. Ket nariribuk i ngamin a tolay. “Heya wade hikuna?” sinalodsod di. ");
INSERT INTO duo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ket makpal i nagtabbeg a, “Hikuna ni Jesus, i mahagpugto a taga-Nasaret, Galileya.” ");
INSERT INTO duo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Niyaen, sinumadap ni Jesus ha Templo. Ket binugew na i mahaglako a hidi ken naggatang a hidi ha disalad na Templo. Ket binaliktad na idagenday a lamesaan na mahagsulet ha korinat. Ket kona bila hito ha dagenday a pagetnodan na maglaklako ha kalapati a hidi. ");
INSERT INTO duo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kinagi na ha nidi, “Ide i nesurat ha Libro na Dios, ‘I bilay ko aye i bilay a pagkararagan,’ kon na Dios. Ngem pinagbalin moy dan a paghenan na mahagtakaw,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Niyaen, inumangay i bulsak ken pilay a hidi ha ni Jesus ha Templo. Ket pinahusay na hidi. ");
INSERT INTO duo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngem nakaingal i matangkay a hidi a padi ken maestro a hidi na Linteg idi naenta di i nakaddatan a gimigimet na. Ket naenta di i annak a hidi ha Templo a nagdeydeyaw ha, “Madeydeyaw i apo ni Hari Dabid,” kagi di. ");
INSERT INTO duo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Isu, nagreklamo i papadi ken maestro a hidi na Linteg, a kinagi di ha ni Jesus, “Sanegan mo i kakkagi na dagende a annak! Nakaliwat dan hidi!” Ket kinagi ni Jesus, “Masaneg ko hidi. Apay? Awan moy dod nabasa i nesurat ha Libro na Dios? Ta nesurat dan, a ‘Tinolduwan na Dios i annak a hidi, penu deyawan di ha inaamakan.’” ");
INSERT INTO duo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kinagi ito ni Jesus, sana, linakadan hidi, a inumangay hikuna ha ili a Betaniya, a pagkilapan na. ");
INSERT INTO duo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Idi kaugman na, nagsoli di Jesus ha Jerusalem. Ket magiyalap hikuna. ");
INSERT INTO duo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ket naenta na i esa a kayo a igos ha hikeg na dilan. Ket inumangay hikuna a mangenta nu atoy bunga na, ta magbunga mina i igos, basta atoy dan i dodon na. Ngem idi pagsangpit na, pasig la dodon i naeriyokan na. Ket kinagi na, “Nangrugi ha yenan, awan ka manon magbunga!” Ket dagus a nalannas iday a kayo. ");
INSERT INTO duo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Idi naenta na tolduwan na a hidi, nalaktat hidi, a sinalodsod di, “Panyan na? Minalannas a dagus iday a kayo!” ");
INSERT INTO duo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ket kinagi ni Jesus, “Nanakaman moy ide a ipeta ko ha nikam. Basta manahod kam ha Dios, ken awan magduwaduwa i nakam moy, ket magimet moy bila i ginimet ko ha ide a kayo. Ket awan la ide nu awan a maadya moy i maski nu anya a rigrigat a magsalen ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ket maski nu anya a agedan moy ha Dios, magiwat moy, basta manahod kam ha nikan.” ");
INSERT INTO duo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Niyaen, sumadap manon ni Jesus ha Templo. Ket idi nagitoldu manon hikuna, inumangay i matangkay a papadi ken panglakayan a hidi na Judyo. Kinagi di, “Anya i kalintegan mo a manggimet ha dagende a bagbagay? Heya i nangiyatad ha nikaw ha turay a kona he?” ");
INSERT INTO duo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ket tinabbeg ni Jesus, “Ha palungo, palobusanak moy bi a magsalodsod ha nikam. Nu matabbeganak moy, ipeta ko bila ha nikam nu heya i nangiyatad ha turay ko a maggimet ha dagende. ");
INSERT INTO duo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Niyaen, ipeta moy bi nu hadya i nagipuwan na turay ni Juan a minahagbinyag. Anya ha nakam moy? Nagipu ha Dios, onu nagipu ha sabali la a tolay?” kon ni Jesus. Ket naginuhon hidi nu anya mina i tabbeg di. “Nu ipeta tam a nagipu ha Dios i turay ni Juan, metabbeg ni Jesus, ‘Apay dod, awan kam nanahod ha ni Juan?’ ");
INSERT INTO duo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ngem delikadu nu ipeta tam a nagipu ha sabali la a tolay, ta manahod i kakpalan a hidi ha ni Juan. Tahodan di a hikuna i mahagpugto a naggipu ha Apo Dios.” ");
INSERT INTO duo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Isu a tinabbeg di ha ni Jesus, “Awan mi katandi.” Ket kinagi ni Jesus, “Gipu ta awanak moy tinabbegan, awan takam bila tabbegan nu anya i turay ko a maggimet ha dagende a bagay.” ");
INSERT INTO duo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ket kinagi ni Jesus ha Judyo a hidi, “Anya i nakam moy ha ide? Atoy esa a lakay ken duwa a annak na a lallaki. Ket inumangay i lakay ha palungo a annak na, ket kinagi na, ‘Annak ko, hen ka dan a magtarabaho ha talon ko.’ ");
INSERT INTO duo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tinabbeg na annak na, ‘Madiyan ko.’ Ngem kobosan na, nagbabawi hikuna, ket inumangay a nagtarabaho. ");
INSERT INTO duo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Niyaen, inumangay i lakay ha boridik, ket binonan na a kona ha inbon na ha hekka na. Intabbeg na boridik, a ‘Oni, Apo. Hikan i umangay!’ Ngem awan hikuna inumangay. ");
INSERT INTO duo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Niyaen,” kagi ni Jesus, “magsalodsodak ha nikam. Ha dende a duwa, heya i nangtongpal ha pagayatan nama di?” Ket tinabbeg na Judyo a hidi, “I palungo a annak.” Ket kinagi ni Jesus ha nidi, “Tamos. Ket niyaen, ipeta ko a awan kam mabikan ha paghariyan na Dios. Ket awan kam makasaddap ha paghariyan na. Imbes na, mas mabikan i madibbi a totolay, a kona ha mahagpabuwis a hidi, onu pampam a hidi. ");
INSERT INTO duo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ta inumangay ha nikam ni Juan a nangitoldu ha nalinteg a ugali. Ngem awan moy hikuna tinahodan, maski nanahod dan idagende a mahagpabuwis ken pampam a hidi. Ket naenta moy i pinagbabawi di. Ngem awan kam nanahod ha pinagitoldu ni Juan. Ket awan kam nagbabawi.” ");
INSERT INTO duo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ket tinumulos ni Jesus a magestoriya ha nidi. “Temanan moy i esa pala a pangareg,” kagi na. “Nikuna, atoy i esa a lakay, ket minulaan na i lutak na ha unas. Sana, inaladan i kaunasan na, ket ginimet na i pagpespesan ha unas. Ket pinataknag na i torre a paghenan na guwardya a hidi. Kobosan na, inpaabang na i kaunasan ha makitalon a hidi. Sa hikuna, linumakad ha sabali a bayan. ");
INSERT INTO duo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Niyaen, pagdemat na tiyempo na pagkatol ha unas, ket pinaangay na i kappal a tagabu na a mangalap mina ha bunong na. ");
INSERT INTO duo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngem ha makitalon a hidi, dinakap di i tagtagabu na. Ket dinanog di i esa, ket binuno di i mekaduwa, ket binisag di i mekatallu. ");
INSERT INTO duo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ha ni Lakay, pinaangay na manon i sabali a tagtagabu na a makpal paman ngem idi palungo. Ngem kona bila hito i ginimet na makitalon a hidi ha tagtagabu na. ");
INSERT INTO duo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kobosan na ngamin, pinaangay ni Lakay i bukod na a annak. Kinagi na ha nakam na, ‘Siguradowak a respitaran di i annak ko!’ ");
INSERT INTO duo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngem idi naenta na makitalon a hidi, naginuhon hidi, ‘Ide dan i magtawid ha lutak ni Lakay! Patayan tam mina hikuna, penu hikitam mina i magtawid ha lutak na aye,’ ");
INSERT INTO duo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ket dinakap di, ket inlapos di hikuna ha kaunasan, sadi, pinatay. ");
INSERT INTO duo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Niyaen,” kagi ni Jesus, “anya ha nakam moy? Nu dumemat i lakay a makinlutak, anya i gimetan na ha makitalon a hidi?” ");
INSERT INTO duo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ket tinabbeg na Judyo a hidi, “Siyempre! Patayan na i makitalon a hidi. Naranggas hidi! Ket ipaabang na i kaunasan na ha sabali a makitaltalon a mangiyatad ha nikuna ha bunong na.” ");
INSERT INTO duo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ket kinagi ni Jesus, “Tahod i kinagi moy. Ngem awan moy wade nabasa ide a nesurat ha Libro na Dios? ‘Nagayak i esa a inaamakan a pugedu, para ha bilay. Ngem madiyan na a usaran na tarabahador a hidi. Ngem maski nu kona hito, medatton paman ide a pugedu ha suli na bilay a pangadigi ha ngamin a bilay. Ide i ginimet na Dios, ket mappiya unay ide ha nikitam.’ ");
INSERT INTO duo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Niyaen,” intulos ni Jesus, “isu a ipeta ko a palakadan na kam na Dios ha paghariyan na, ket sakopan na i sabali a hidi a umusoseg ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ket ha maski nu heya a magsenti ha ide a pogedu, matangpod hidi nokkan. Ket ha nidi a magpabiyan ha ide a pogedu, hidi i hamsitan na pogedu aye, ket meyappah hidi nokkan ha pahas.” Ide i pangikalan ni Jesus ha maski nu heya a awan a manahod ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Idi nasaneg ito na matangkay a papadi ken Pariseyo a hidi, nakatandiyan di a hidi man i nagkagiyan ni Jesus ha dagende a pangaregan na. ");
INSERT INTO duo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ngem idi padasan di hikuna padakapan, nanteng hidi ha kakpalan hay a tolay. Ta inbilang na totolay ni Jesus a tahod a mahagpugto a naggipu ha Dios. ");
INSERT INTO duo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nagestoriya manon ni Jesus ha esa a pangareg. Kinagi na, ");
INSERT INTO duo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mearig i Paghariyan na Dios ha esa a hari a nagpasilebra gipu ha pinagkasar na annak na a lallaki. ");
INSERT INTO duo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ket pinaangay na i tagtagabu na a mangayag ha nidi a naawis na. Ngem madiyan di a umangay. ");
INSERT INTO duo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Isu a pinaangay na i sabali a tagtagabu na. Ket kinagi na, ‘Ipeta moy ha nidi a naawis a nesagana dan i pagsilebra ko. Naparti dan idende a makadakklan ken idende a urbon a napatabi. Ket nesagana i ngamin a kasapulan. Isu, umangay kam ha yenan ha pagbodaan aye.’ ");
INSERT INTO duo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngem awan nanahod i naawis a hidi. Imbes na, tinumulos hidi ha paggimi-gimet di. Inumangay i esa ha talon na. Ket inumangay i sabali ha negosio na. ");
INSERT INTO duo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ket ha kappal a hidi, dinakap di i tagtagabu na hari, a pinarparigat di hidi, sadi pinatay. ");
INSERT INTO duo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Niyaen, nagingal ni Hari. Ket pinaangay na i sundalu na a hidi. Ket pinatay di i nangpapatay a hidi, sadi pinatutod i ili di. ");
INSERT INTO duo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kobosan na, inayagan ni Hari i tagtagabu na, ket kinagi na, ‘Nesagana dan i pagsilebra, ngem awan a mekari idenday a inawis ko. ");
INSERT INTO duo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Isu, niyaen, umangay kam ha kalkalsada, ket awisan moy i ngamin a maenta moy, a makipagsilebra mina hidi ha pagbodaan aye.’ ");
INSERT INTO duo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Ket inumangay i tagtagabu na hari. Ket inawis di i ngamin a naeriyokan di, maski nu madukas hidi onu mappiya. Ket gipu ta kona hito, pinutat di i pagbodaan ha makisilebra a hidi. ");
INSERT INTO duo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Niyaen, pagsaddap ni Hari penu maenta na i makisilebra a hidi. Ket naenta na i esa a lallaki a awan ha badu a pakipagboda. ");
INSERT INTO duo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ket kinagi ni Hari ha nikuna, ‘Agay! Iyatad ko i badu a pakipagboda ha ngamin a makisilebra. Apay a sinumadap ka he a awan ka ha badu a pakipagboda?’ kon na hari. Ngem nagulimek la i lallaki. ");
INSERT INTO duo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sa, kinagi na Hari ha tagtagabu na, ‘Gakadan moy i kamat na ken tikad na, ket itogbak moy ha kadihaman ha lapos. Ha kadihaman ihay i pagsangetan ken pagrarangsitan na totolay gipu ha rigrigat di,’ kon na Hari.” ");
INSERT INTO duo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ket kinagi ni Jesus, “Niyaen, makatandiyan moy mina a makpal i totolay a maawisan ha Paghariyan na Dios, ngem ballik la i totolay a piliyan na.” ");
INSERT INTO duo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kobosan na, inumangay i Pariseyo a hidi, ket nagtutulag hidi nu panyan di a mapaliwat ha ni Jesus ha kagi na. ");
INSERT INTO duo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ket pinaangay di ha nikuna i toltolduwan di ken toltolduwan ni Herod, a nagkagi ha ni Jesus ha, “Maestro, katandiyan mi a tahod i pagitoldu mo. Ket katandi mi a magitoldu ka ha tahod megipu ha pagayatan na Dios. Ket katandi mi bila a awan ha idumduma mo a tolay, maski matangkay onu madibbi. ");
INSERT INTO duo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Isu, ipeta mo bi nu anya ha nakam mo. Anya, makaliwat kitam ha Linteg tam, onu awan, nu magpaga kitam ha buwis ha Hari na Roma?” ");
INSERT INTO duo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngem katandi ni Jesus a madukas i pangsurbar di. Isu, kinagi na, “Hikam a aginsisingpet. Apay a kayat moyak a surubaran? ");
INSERT INTO duo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipaenta moy ha nikan i korinat a pagbuwis.” Ket inyangay di ha nikuna i kuwarto. ");
INSERT INTO duo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ket kinagi ni Jesus ha nidi, “Ipeta moy nu heya i makinladawan ha ide a korinat, ken heya i nagen a nesurat ha he?” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Iday i Hari na Roma,” kon di. Ket kinagi ni Jesus, “Isu, iyatad tam mina ha Hari na Roma idagende a kukuwa na, idagende a atoy ha rupa na ken nagen na. Ket iyatad tam mina ha Dios idagenday a kukuwa na Dios, idagenday a atoy i karuprupa na Dios, a kona ha ayat tam, ken nakam tam, ken pigsa tam,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Niyaen, idi nasaneg di i tabbeg ni Jesus, nalaktat unay i Pariseyo a hidi. Ket linakadan di hikuna. ");
INSERT INTO duo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Niyaen, ha ide a pamalak, inumangay ha ni Jesus i kappal a Saduseyo. Ket kayat di bila a paliwatan ni Jesus ha kagi na. (Idagende a Saduseyo i esa a kalase na Judyo a awan manahod a magbiyag manon i tolay a natay dan.) ");
INSERT INTO duo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Sinalodsod di, “Maestro, insurat ni Moyses ide a linteg, a ‘Nu matay i lallaki a atoy kabanga na, ket awan pala ha annak, masapul na wadi na a magkabanga ha ipag na a nabilu, penu magenak hikuna. Ket ibilang di mina i annak na aye ha annak na hekka na a minatay’, kon ni Moyses. ");
INSERT INTO duo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Niyaen, Maestro, atoy i pitu a lallaki idi a nagkakabsat ha lugar mi. Ket nangabanga i hekka, ngem minatay hikuna a awan ha annak. Isu, kinabanga na wadi na i ipag na a nabilu. ");
INSERT INTO duo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ket minatay bila hikuna a awan ha annak. Ket kona bila hito ha nekatallu. Ket kona bila hito hanggan ha nekapitu. Minatay hidi ngamin a awan ha annak. ");
INSERT INTO duo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ket ha dilokod, natay bila i babbey. ");
INSERT INTO duo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Niyaen, netoldu mo a makabiyag manon i tolay a natay, kon na kan. Isu, ide i salodsod mi ha nikaw. Nokkan, ha tiyempo na pinagbiyag manon na totolay, heya i makinkabanga ha ide a babbey? Ta nagkabanga hidi ngamin ha nikuna?” ");
INSERT INTO duo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ngem tinabbeg ni Jesus, “Madi i nakam moy! Ta awan moy katandi i Libro na Dios, ket awan moy katandi i pinnakabalin na Dios. ");
INSERT INTO duo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ta nokkan, nu magbiyag manon i natay a hidi, awan hidi mangabanga. Ta maghen hidi ha Dios ha magnanayon, a kona ha anghel a hidi, a awan hidi mangabanga. ");
INSERT INTO duo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Apay a kagin moy a awan magbiyag manon i totolay? Nagpatahod dan ni Moyses a magbiyag manon i tolay. Ket nanakaman moy mina i pinasurat na Dios ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ta kinagi na Dios ha ni Moyses, ‘Hikan i deyawan ni Abraham, ken ni Isak, ken ni Hakob,’ kon na Dios. Ket gipu ha ide, makatandiyan tam a magbiyag manon hidi. Ta magdeydeyaw pala hidi, maski nu minatay dan. Ket awan ha magdeyaw ha Dios nu awan hidi a magbiyag. Isu, madi i nakam moy.” ");
INSERT INTO duo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ket nalaktat i kakpalan a hidi, idi nateman di i pagitoldu ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ngem ha Pariseyo a hidi, inumangay bila hidi ha ni Jesus, idi nabaheta di a nangabak ni Jesus ha Saduseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ket atoy ha nidi i esa a maestro na Linteg, a kayat na a mangsurubar ha ni Jesus. Isu, sinalodsod na, ");
INSERT INTO duo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maestro, anya wade i kanginaan a linteg ha Libro na Dios?” ");
INSERT INTO duo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ket kinagi ni Jesus, “Ide i kanginaan a linteg, a ‘Masapul a ayatan mo i Happo mo a Dios ha ngamin a biyag mo, ken ngamin a paggimet mo, ken ngamin a nakam mo.’ ");
INSERT INTO duo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ide i kanginaan a linteg. ");
INSERT INTO duo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ket i nekaduwa a linteg i kakalan na. ‘Ayatan mo dan i agagum mo, a kona ha pinagayat mo ha baggi mo a mismo,’ kon na linteg. ");
INSERT INTO duo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Niyaen, awan ha linteg a mas mangina ngem ha dende a duwa. Nu umusoseg kam ha dende, natongpal moy i ngamin a linteg ni Moyses ken ngamin a pagitoldu na minahagpugto a hidi.” ");
INSERT INTO duo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Niyaen, idi atoy pala di Pariseyo ha lebut na, nagsalodsod ni Jesus ha nidi, ");
INSERT INTO duo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","a kinagi na, “Anya i mepeta moy megipu ha Cristu a inkari na Dios a paangayan na, a mangisalakan ha totolay? Ha nakam moy, heya i minappo na?” Ket tinabbeg na Pariseyo a hidi, “Maggipu hikuna ha kaputotan ni Hari Dabid.” ");
INSERT INTO duo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sa, kinagi ni Jesus, “Nu tahod i kinagi moy, panyan na a pinanagenan ni Dabid i Cristu ha ‘Happo’ na. Ta nagpasurat i Espiritu na Dios ha ni Dabid ha ");
INSERT INTO duo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kinagi na Apo Dios ha Happo ko, ‘Magetnod ka ha henan ko, a maghari kita hanggan pagparentumengan ko i kasenti mo a hidi ha saguppang mo,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Isu, gipu ta ninagenan ni Dabid i Cristu ha ‘Happo’ na, madinnang dod a awan la a apo ni Dabid i Cristu nu awan bila a Happo na.” ");
INSERT INTO duo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ito i kinagi ni Jesus ha Pariseyo a hidi. Ngem awan a pulos a netabbeg di ha ni Jesus. Ket mangrugi idi pamalak a hito, awan ha maketured a magsalodsod ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Niyaen, iniwadan ni Jesus ha kakpalan a napagpisan ken tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kinagi na, “Atoy i kalintegan na mamaestro na Linteg ken Pariseyo a hidi a mangitoldu ha Linteg ni Moyses. ");
INSERT INTO duo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Isu i gipu na a usigan moy mina i ngamin a pagitoldu di. Ngem awan moy mina ahegan i paggimet di, ta awan di gimetan i itoldu di. ");
INSERT INTO duo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Inaynayon di i marigat a bobon ha linteg, ngem awan di hidi tulongan. Kona nu ibuwat di i dakkal a tawed ha sabali a tolay, ngem madiyan di hidi tulongan a magtawid. ");
INSERT INTO duo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nu gimetan di i mappiya, gimetan di ha saguppang na totolay, penu deyawan di hidi. Isu, padakkalan di i papeles a nagsuratan di ha kagi na Dios, ket ibadu di ha baggi di ken ibadbad di ito ha kidap di ken labunogen di. Ket itennon di i atakdug a tennon a pangpaenta ha kinappiya di. ");
INSERT INTO duo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Magustowan di i katangkayan a pagetnodan ha piyesta ken paggimmongan di. ");
INSERT INTO duo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Magustowan di a masalpakan hidi ha sentro na ili ken managenan ha ‘Maestro.’ ");
INSERT INTO duo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ngem bakkan mina ha nikam. Awan kam mina paayagan ha ‘Katangkayan a Maestro,’ gipu ta isesa la i Katangkayan a Maestro moy. Ket magkakabsat kam ngamin ha kakalan moy a manahod. ");
INSERT INTO duo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ket awan moy nagenan ha ‘Katangkayan a Hama’ i maski nu heya a tolay. Ta isesa i Katangkayan a Hama moy, a hikuna i Apo Dios. ");
INSERT INTO duo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ket awan kam panagenan ha ‘Matangkay a Happo.’ Ta isesa i Happo moy, a hikan a pinaangay na Dios, ket managenan ha ‘Cristu.’ ");
INSERT INTO duo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","I katangkayan ha nikam, masapul a hikuna i magpatagabu ha baggi na a magdaggap ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","I maski nu heya a magpatangkay ha baggi na ha yenan, mapasanikiyan hikuna nokkan. Ket i maski nu heya a magpadibbi ha baggi na, mapatangkay hikuna nokkan.” ");
INSERT INTO duo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Intulos ni Jesus, a kinagi na, “Kagbi kam, hikam a mamaestro na Linteg ken hikam a Pariseyo. Maginsi-singpet kam! Pakilluwan moy i kakkagi na Dios gipu ha pagitoldu moy ken paggimet moy. Ta madiyan moy a manahod, ket salenan moy i sabali a hidi a mayat a magpasakop ha paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kagbi kam! Hikam a mamaestro na Linteg ken hikam a Pariseyo. Maginsi-singpet kam! Agewan moy i kukuwa na nabilu a hidi. Sakam, magkararag ha maalay, penu nakaman na tolay a mappiya kam. Ngem isu i gipu na a mas marigat i parusa moy nokkan. ");
INSERT INTO duo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kagbi kam! Hikam a mamaestro ha Linteg ken hikam a Pariseyo. Maginsisingpit kam! Arabesan moy i diget, ket abotan moy i madiyo a lugar, penu makaawis kam ha maski esa a tolduwan moy. Ngem maski nu atoy i matoldu moy, pagbalinan moy hikuna a mas madukas ngem ha baggi moy. Ket dakdakkal i parusa na ha impyerno, ta pinasakop na ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kagbi kam, hikam a bulsak a mangidilan ha totolay. Ta itoldu moy a nu pagsapata na esa a tolay i Templo, awan kan a masapul a tungpalan na i kari na. Ngem nu pagsapata na i balitok ha Templo, masapul kan a tungpalan na i kari na. ");
INSERT INTO duo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Madi kam, hikam a bulsak a awan ha nakam moy! Anya i mas mangina? I balitok onu i Templo a mamagbalin ha balitok a nadiosan? ");
INSERT INTO duo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ket itoldu moy a nu magsapata i esa a tolay ha pagdattonan, awan kan a masapul a tungpalan na i kari na. Ngem nu pagsapata na i datton ha pagdattonan, masapul kan a tungpalan na i kari na. ");
INSERT INTO duo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Anyan a kinabulsak moy! Anya i mas mangina? I datton onu i pagdattonan a mamagbalin ha datton a nadiosan? ");
INSERT INTO duo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Isu, nu magsapata i tolay ha pagdattonan ha Dios, isapata na i pagdattonan, pati ngamin a datton ha ontok na. ");
INSERT INTO duo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ket nu magsapata i esa a tolay ha Templo, magsapata hikuna ha Templo ken ha Dios a maghen ha Templo. ");
INSERT INTO duo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ket nu magsapata i esa a tolay ha langit, a paghenan na Apo Dios, magsapata hikuna ha Dios a mismo a maghari ha langit. ");
INSERT INTO duo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kagbi kam, hikam a mamaestro na Linteg ken hikam a Pariseyo! Maginsi-singpet kam! Ta iyatad moy ha Dios i mekasangapulo na aruwatan moy, maski i rekrekado a mula moy. Ngem pabiyanan moy i mas mangina a bobon na Linteg, a kona ha paggimet ha malinteg, ken kagbi ken tahod. Tahod a iyatad moy mina i mekasangapulo ha Dios, ngem awan moy mina pabiyanan i mas mangina a bobon. ");
INSERT INTO duo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tahod a nabulsak kam a mangidilan ha totolay! Ta tungpalan moy i balballik a bobon, ngem pabiyanan moy i mangina a bobon na Dios. Kona nu sagatan moy i lamok ha inoman moy, ngem itemlok moy i makadakklan! ");
INSERT INTO duo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kagbi kam! Hikam a mamaestro na Linteg ken hikam a Pariseyo. Ta maguges kam ha lapos na baso ken pinggan. Ket kona bila hito ha baggi moy, a mappiya i itsura na, ngem madukas i disalad na, gipu ta dayaan moy ken agewan moy i kakalan moy a tolay. ");
INSERT INTO duo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bulsak kam a Pariseyo! Dalusan moy mina ha palungo i disalad na nakam moy, penu nadalus bila i itsura moy. ");
INSERT INTO duo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kagbi kam! Hikam a mamaestro na Linteg ken hikam a Pariseyo! Maginsi-singpet kam! Ta mekalan kam ha lablabbang a napapuraw, a inaamakan i lapos di. Ngem ha disalad, naputat hidi ha buyok ken tulang na natay. ");
INSERT INTO duo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kona bila hito ha nikam! Ta maski nu mappiya i itsura moy, magpadukas kam ha pagnakam moy. ");
INSERT INTO duo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kagbi kam! Hikam a mamaestro na Linteg ken hikam a Pariseyo. Maginsi-singpet kam! Ta igimetan moy i minahagpugto a hidi ha inaamakan a lablabbang. Ket ipainamakan moy i lablabbang na nalinteg a hidi a tolay. ");
INSERT INTO duo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ket kagi moy, a ‘Basta atoy kami mina idi tiyempo na minappo mi, ket awan kami inumuseg ha pinagpapatay di ha minahagpugto a hidi.’ ");
INSERT INTO duo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iday i kagi moy. Ngem gipu ha madukas a nakam moy, mepaenta moy a hikam i appo na nagbuno a hidi, a nagpatay ha minahagpugto a hidi. ");
INSERT INTO duo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Isu, nay kam. Ikabus moy i inrugi na minappo moy idi. ");
INSERT INTO duo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Hikam a magkadukas a tolay! Kagin moy a makalisi kam ha parusaan na Dios ha impyerno. Ngem awan moy malisiyan. ");
INSERT INTO duo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Isu i gipu na a paangayan ko ha nikam i mahagpugto, ken mahagibaheta, ken magitoldu. Ket ha kappal, bunowan moy hidi, a ipalansa moy ha kudos. Ket ha kappal, sabbadan moy hidi ha kapikapilya moy. Ket ha kappal, tagubetan moy hidi penu lolokwan moy hidi ha maski nu hadya a angayan di. ");
INSERT INTO duo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ket gipu ta kona hito, maparusaan kam gipu ha ngamin a pinagbuno na minappo moy ha nalinteg a hidi a tolay. Ta inoniyan moy i ginimet di. Maski idi nabuno ni Abel, hanggan ha ni Sakariyas, a annak ni Barakiyas, a nabuno ha disalad na Templo, ha ballog na pagdattonan ken pagetnodan na Dios. ");
INSERT INTO duo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Oni man! Parusaan na Dios i totolay aye, gipu ha dagende a liwaliwat.” ");
INSERT INTO duo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ket kinagi ni Jesus, “Hikam a totolay a taga-Jerusalem, kagbi kam! Kanayon kam a magpatay ha mahagpugto a hidi! Kanayon moy hidi a bisagan a paangayan na Dios ha nikam! Niyaen, maminmakpal a beses a kayat takam daponan, a kona ha manok a maglakap ha piyak na a hidi. Ngem madiyanak moy. ");
INSERT INTO duo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Isu, niyaen, hikam man i makatandi, ta pabiyanan na kam na Dios. ");
INSERT INTO duo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ket ipeta ko ha nikam, a awanak moy manon maenta hanggan magsoli ak, ket ipeta moy, a ‘Deyawan tam hikuna a pinaangay na Dios!’” ");
INSERT INTO duo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Niyaen, linumapos ni Jesus ha Templo, ket linaklakadan na idi binumikan i tolduwan na a hidi, penu ipaenta di ha nikuna iday a Templo, a inaamakan. ");
INSERT INTO duo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ngem kinagi ni Jesus ha nidi, “Oni ah. Entan moy i ngamin a dagende. Ipeta ko ha nikam a dumemat nokkan i tiyempo a marakrak hidi ngamin. Marakrak nokkan i kada esa a bitu ha padding aye,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Niyaen, idi inumetnod ni Jesus ha parabin na Olibo, binumikan ha nikuna i tolduwan na a hidi. Ket sinalodsod di a sililimed, “Ipeta mo bi, Maestro, hangan dumemat i kinagi mo? Anya i tiplad, a pakatandiyan mi a dumemat i tiyempo na pagsoli mo ken panungpalan na ide a lutak?” ");
INSERT INTO duo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ket kinagi ni Jesus, “Magingat kam, a awan ha mangallilaw ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ta makpal nokkan i umangay, ket kakkagi di a hidi man i Cristu a paangayan na Dios a maghari. Ket makpal i allilawan di nokkan. ");
INSERT INTO duo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Ket mateman moy nokkan i tanog na gubat ha luglugar moy ken baheta megipu ha gubat ha madiyo a luglugar. Ngem awan kam mina manteng. Ta masapul a magimet idagento ha palungo. Ngem maski nu kona hito, awan pala ha tiplad na tiyempo a pakabos na totolay ha lutak aye. ");
INSERT INTO duo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ta maglabanlaban i bayan a hidi. Ket dumemat i makpal a alap ken ginggined ha sabasabali a lugar. ");
INSERT INTO duo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ngem maski nu kona hito, pangrugiyan la ide na tiyempo a pagrigrigat, ket kona ha paggasokan na babbey a magenak. ");
INSERT INTO duo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ha ide a tiyempo, atoy ha nikam i ipadakap na totolay. Ket lokowan di kam, gipu ha panahod moy ha nikan. Ipapatay di kam. Ket englan na kam na ngamin a tolay, gipu ha panahod moy ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ket ha tiyempo a ito, atoy i makpal a mangtallekod ha panahod di ha nikan. Ket maglinniput hidi ken magginnura hidi. ");
INSERT INTO duo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ket dumemat i makpal a masileng a mahagpugto, ket paliwaliwatan di i makpal a tolay. ");
INSERT INTO duo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ket gipu ta kumaro i kinadukas na totolay, bumallik i pagayat di ha kakalan di a tolay hanggan awan dan. ");
INSERT INTO duo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngem ha maski nu heya a makatured a manahod ha nikan hanggan ha panungpalan, mesalakan hikuna. ");
INSERT INTO duo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ket mebaheta ha ngamin a lutak ide a Mappiya a Baheta megipu ha Paghariyan na Dios, penu mabaheta na ngamin a tolay. Ket kobosan na ito, dumemat i panungpalan.” ");
INSERT INTO duo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Intulos ni Jesus, “Dumemat nokkan i oras, ket maenta moy ha Templo i pagsenti ha Dios, a kona ha inpugto ni Danyel a minahagpugto. (Makatandiyan mina na magbasa ha Surat ni Danyel.) Isu, nu tinumaknag ide ha Templo na Dios, ");
INSERT INTO duo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","masapul a kumamang ha amugod i ngamin a maghen ha Judeya. ");
INSERT INTO duo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Masapul a dagus a bumuyot i maski nu heya. Nu hen hidi ha lapos na bilay di, awan mina hidi sumadap a mangalap ha aruwatan di. ");
INSERT INTO duo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ket nu hen hidi ha talon, awan mina hidi sumoli penu mangalap ha badu di. ");
INSERT INTO duo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kakakagbi i mabuktet a hidi ken magpasuso a hidi ha iday a tiyempo. ");
INSERT INTO duo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ikarkararag moy ha Dios a awan ito magimet ha tiyempo na ahided onu ha maneg a pamalak a pagemmang moy. ");
INSERT INTO duo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gipu ha ide a tiyempo, atoy i rigrigat a awan pala a napadas na totolay, maski idi pinakaparsuwa na Dios ide a lutak, hanggan ha yenan. Ket awan mapinduwa manon idagende a rigrigat, hanggan awan dan ha kahad. ");
INSERT INTO duo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngem maski nu kona hito i rigrigat, nebital dan na Dios i dagop a pamalak na rigrigat. Ta nu awan na paballikan i tiyempo hito, awan ha totolay a mesalakan. Ngem gipu ha totolay a pinili na, paballikan na nokkan ide a tiyempo a pagrigrigat.” ");
INSERT INTO duo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ket intulos ni Jesus, “Awan moy mina tahodan, nu mepeta ha nikam, a ‘Entan moy ihe! Ta atoy dan i Cristu!’ onu ipeta di, ‘Entan moy hay. Atoy hay i Cristu!’ kon na di. Madi iday, ket awan moy iday tahodan. ");
INSERT INTO duo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta atoy nokkan i mangallilaw a hidi a magkagi a hidi kan i Cristu a maghari mina, onu hidi kan i mahagpugto a nagipu ha Dios. Ket magipaenta hidi ha kaddat di ken makpal a pagpasabbew, penu allilawan di mina i totolay na Dios a pinili na. Ngem awan a mabalin a maallilaw di i pinili a hidi na Dios. ");
INSERT INTO duo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Magingat kam! Ta inpakatandi ko dan i ngamin a dagende, penu makasagana kam ha palungo na rigrigat aye. ");
INSERT INTO duo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Isu, nu ipeta di ha nikam, a ‘Entan moy. Atoy dan ni Cristu ha katalonan,’ kon di, awan kam mina umangay. Onu ipeta di, a ‘Entan moy he, atoy dan ni Cristu, a maghen ha disalad na bilay a sililimed,’ kon di, awan moy hidi tahodan. ");
INSERT INTO duo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta nokkan nu sumoli ak ha lutak aye, kona ha ide i pagsoli ko, a kona ha killat a maggangat ha ngamin a langit. Ket madinnang hito, a maenta na ngamin a tolay. ");
INSERT INTO duo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Madinnang i pagsoliyan ko. Ikaspangarigan, nu maenta moy i kakpalan a silay, katandi moy a atoy i bangkay a awan nelabbang. Ket kona bila hito nokkan ha pagsoli ko. Ta maenta na ngamin a tolay. ");
INSERT INTO duo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ket nokkan, nu kobosan na tiyempo a pagrigrigat, dumiham i silaw na senggit, ket awan magdisyag i bulan. Ket matakneg i pusiyan a hidi. Ket mapasina i senggit ha paglakadan na. Ket kona bila hito ha bulan. ");
INSERT INTO duo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kobosan na ito, magpaenta ha ngamin a tolay i Annak na Dios a Nagbalin a Tolay, a bumugsokak ha ulap. Ket maenta di i kainamakan ko, ken kinapigsa ko. Ket ha ngamin a awan a nagpasakop ha nikan, magsangisanget hidi. ");
INSERT INTO duo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ket magtanog ha mapigsa i trumpeta. Sako, paangayan i anghel a hidi ha ngamin a paset na lutak, a mangpuhon hidi ha ngamin a sakop ko a tolay.” ");
INSERT INTO duo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ket tinulos ni Jesus, a kinagi na, “Nanakaman moy i kayo a igos. Ta nu magbudak i tingitingi na, katandi moy a dandani dan a kasinag. ");
INSERT INTO duo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ket kona bila hito ha dagende a magimet nokkan. Nu maenta moy idagende a nepugto ko, makatandiyan moy a dandani dan i tiyempo na pagsoli ko. ");
INSERT INTO duo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Magsiguradowak ha nikam, a makatulos pala ide a kalase na totolay, hanggan matungpal idagento. Sa, awan dan hidi, ta matay hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ket maski nu maawan i ngamin a langit ken ngamin a lutak, ipeta ko ha nikam a makatulos pala i kakkagi ko. Ta awan a mabalin a maawan i kagi ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ket intulos na, “Awan ha makatandi nu hangan iday a pamalak onu anya a oras. Maski i anghel a hidi, awan di katandi. Maski hikan a Annak na Dios, awan ko bi katandi. I Hama ko la i makatandi ha iday. ");
INSERT INTO duo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","I magimet nokkan ha tiyempo na pagsoli ko i kona bila ha nagimet idi tiyempo ni Noe, nikuna naalay dan. ");
INSERT INTO duo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Idi tiyempo di Noe, idi awan pala duminom, awan ha nagnakam ha Dios. Ta nagnakam la hidi ha pinagragsak di. Ket nakipagkan hidi, nakipaginum hidi, nakipagboda hidi. Kona hito i ginimet di, hanggan bigu la a sinumadap di Noe ha dakkal a barko. ");
INSERT INTO duo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ket awan di katandi i magimigimet hanggan idi dinumemat i layus a nangibulod ha nidi ngamin. Ket kona bila hito i magimet nokkan ha pagsoli ko. ");
INSERT INTO duo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ha tiyempo ito, atoy duwa a lallaki a magtarabaho ha talon. Ket bigu la a alapan ko i esa a umuseg ha nikan. Ngem matirak la i agum na. ");
INSERT INTO duo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ket kona bila ha ide, a nu atoy duwa a babbey a magbiyu, bigu la a alapan ko i esa a makauseg ha nikan. Ngem i agum na, awan makauseg. ");
INSERT INTO duo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Isu, magingat kam. Ta awan moy katandi i pamalak a pagsoli na Happo moy. ");
INSERT INTO duo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Nanakaman moy ide,” kagi ni Jesus. “Nu atoy i makinbilay, ket katandiyan na nu hangan i pangsaddap na magtakaw, awan kumilap i makinbilay, penu awan makasaddap i magtakaw. ");
INSERT INTO duo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ket kona bila hito ha nikam. Masapul a kankanayon kam a sisasagana ha pagdemat na Annak na Dios a Nagbalin a Tolay, penu awan kam magliwat. Ta sumoli ak ha tiyempo a awan moy nanakaman.” ");
INSERT INTO duo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Iestoriya ko ide,” kagi ni Jesus, “para ha maski nu heya a malaing a tagabu, a umusoseg perpermi ha happo na. Hikuna i tagabu a meturayan na happo na ha bilay na. Ket i tagabu aye i magpakan ha ngamin a sabali a tagabu ha mekari a tiyempo. ");
INSERT INTO duo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mahusay i tagabu aye ha pagsoli na happo na, ket maenta na a nagtongpal i tagabu ha ngamin a nebon ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Oni! Ipeta ko ha nikam, a meturayan na happo i tagabu na aye ha ngamin a aruwatan na. ");
INSERT INTO duo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ngem kagbi hikuna nu sabali i nakam na; nu kagin na a maalay pala, a awan pala dumemat i happo na. ");
INSERT INTO duo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ket nu magbaot hikuna ha sabali a tagabu a hidi, a lokowan na hidi. Ket makipagkan hikuna ken makiinum hikuna ha mammartek a hidi. Kakagbi hikuna a tahod. ");
INSERT INTO duo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ta sumoli i happo na ha oras a awan na mapugto. Ta awan na katandi i oras na pagdemat na happo na. ");
INSERT INTO duo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ket nu dumemat i happo, parusaan na i madukas a tagabu na aye. Ket iagum na hikuna ha maginsisingpit a hidi, a maghen ha lugar a pagparusaan. Ha ihe i pagsasangitan na totolay, a magngaretnget hidi gipu ha rigat di.” ");
INSERT INTO duo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kinagi ni Jesus, “Kona ha ide i totolay a sisasagana ha pagsoli ko ken totolay a awan a nakasagana. Kona ha esa pulo a madiket. Ket magkalan hidi, a kessilaw hidi ngamin, ket umangay hidi ngamin a magsalpak ha nobyo. ");
INSERT INTO duo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ngem madagel i lima, ket malaing i agagum di a lima. ");
INSERT INTO duo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ta inalap di madagel i pagsilawan di, ngem awan ha reserba di a langis. ");
INSERT INTO duo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ngem ha malaing a hidi, idi inalap di i pagsilawan di, inalap di bila i pagkargaan di a naputat ha langis. ");
INSERT INTO duo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Niyaen, gipu ta naalay i pagsangpit na nobyo, nagtongka i madiket a hidi, a kinumillap hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Niyaen, idi lubuk na kallap, atoy i nagdulaw, a ‘Dumemat dan ni Nobyo! Nay! Hen moy dan a salpakan!’ ");
INSERT INTO duo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ket inumikat a dagus i esa pulo a madiket, ket insagana di i pagsilawan di. ");
INSERT INTO duo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ket kinagi na madagel a hidi ha nidi a malaing, ‘Atdinan moy kami ha langis moy, ta magaddap-addap dan i silaw mi aye.’ ");
INSERT INTO duo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ngem tinabbeg na malaing a hidi, ‘Madi! Amangan nu awan ha umanay a para nikitam ngamin. Hen kam mina a gumatang ha masapul moy.’ ");
INSERT INTO duo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Isu, inumangay i lima a hidi a madiket a gumatang ha langis. Ngem idi kallakad di, dinumemat ni Nobyo. Ket inumuseg ha nikuna i nakasagana a hidi a madiket, a sinumdap hidi ha pagbodaan, ket nasalenan i ridaw. ");
INSERT INTO duo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Idi awan naalay, dinumemat i lima a madiket a awan nakasagana. Ket kinagi di, ‘Apo, Apo, ilukat moy bi.’ ");
INSERT INTO duo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngem tinabbeg ni Nobyo, ‘Awan a mabalin, ta awan takam katandi!’ ");
INSERT INTO duo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Isu,” kinagi ni Jesus ha tolduwan na a hidi, “masapul a magsagana kam, ta awan moy katandi i pamalak onu oras na pagsoli ko.” ");
INSERT INTO duo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Intulos ni Jesus, a kinagi na, “Mearig i Paghariyan na Dios ha esa a nabaknang a nagbiyahe ha madiyo. Ha palungo na paglakad na, inayagan na i tagabu na a hidi. Ket intalak na ha nidi i kukuwa na. ");
INSERT INTO duo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Inatdinan na ha kuwarto i kada esa a tagabu, ayun ha kabaelan na kada esa a pagnegosio. Inatdinan na i esa ha lima a ribu a piso, ket i mekaduwa ha duwa a ribu, ket i mekatallu ha esa a ribu. Kobosan na, nagbiyahe ni Nabaknang. ");
INSERT INTO duo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Niyaen, i tagabu a ginumiwat ha lima a ribu a pisos, pinagnegosyo na a dagus i giniwat na. Ket nakaganansiya hikuna ha lima pala a ribu. ");
INSERT INTO duo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ket kona bila hito i ginimet na nekaduwa a tagabu a ginumiwat ha duwa a ribu a pisos. Nakaganansiya pala hikuna ha duwa a ribu. ");
INSERT INTO duo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngem i tagabu a ginumiwat ha esa a ribu a pisos, nagkotkot hikuna ha lutak, ta intago na i kuwarto na happo na. ");
INSERT INTO duo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kobosan na naalay a tiyempo, sinumoli ni Nabaknang, a happo na dagende a tallu a tagabu. Ket nakikuwenta hikuna ha dagende a tallu a tagabu na. ");
INSERT INTO duo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Idi sinumaggupang i ginumiwat ha lima a ribu a pisos, inyatad na i esa pulo a ribu ha happo na. Ket kinagi na, ‘Happo, inatdinanak mo ha lima a ribu a pisos. Niyaen, atoy pala i lima a ribu a naganansiyaan ko.’ ");
INSERT INTO duo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ket kinagi na happo na, ‘Mappiya ka dan! Gipu ta napagtalkan ka ha ballik a aruwatan ko, pagturayan taka ha makpal a aruwatan ko. Niyaen, sumadap ka he a makipagragsak ha nikan.’ ");
INSERT INTO duo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ket idi sinumaggupang i nakagiwat ha duwa a ribu a pisos, kinagi na ha ni Nabaknang, ‘Happo, inatdinanak mo ha duwa a ribu. Niyaen, atoy paman i duwa a ribu a naganansiyaan ko.’ ");
INSERT INTO duo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ket kinagi na happo na ha nikuna, ‘Mappiya ka bila. Gipu ta mapagtalkan ka ha ballik a aruwatan ko, pagturayan taka ha makpal a aruwatan ko. Niyaen, sumadap ka he, a makipagragsak ha nikan.’ ");
INSERT INTO duo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","“Kobosan na, sinumaggupang bila i tagabu a nakagiwat ha esa a ribu a pisos. Ket kinagi na ha ni Nabaknang, ‘Happo, ide i neyatad mo ha nikan. Nedulin ko ide ha hamet, ket intago ko, gipu ta nantengak. Ta katandi ko a hikaw i mahagpaalap. Ket kona ha ide i ugali mo, a alapan mo i nagmulaan na tagabu mo a hidi. Ket puhonan mo i awan mo nagbannogan. Isu, isoli ko ha nikaw i kukuwa mo a korinat.’ ");
INSERT INTO duo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ket kinagi na happo na ha nikuna, ‘Hikaw i madukas ken masegkat a tagabu! Katandiyan mo dod a mahagpaalapak, ta alapan ko kan i nagmulaan na sabali? Ket puhonan ko kan i awan ko nagbannogan? ");
INSERT INTO duo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Isu, nu kona hito i nakam mo, insadap mo mina i korinat ko ha bangko, penu maalap ko mina i naganansiya ko.’ ");
INSERT INTO duo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Sa na, kinagi ni Nabaknang ha sabali a hidi, ‘Alapan moy i korinat ha nikuna, ket iyatad moy ha nekaesa a nanggiwat ha esa pulo a ribu. ");
INSERT INTO duo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ipeta ko ha nikam. Ha maski nu heya a mapagtalkan ko, atdinan ko hikuna ha mas makpal ken magsobsobraan hikuna. Ngem ha maski nu heya a awan ko mapagtalkan, adyan ko i neyatad ha nikuna, maski nu ballik la i kukuwa na. ");
INSERT INTO duo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ket niyaen, i tagabu ko aye a awan serserbe na, itogbak moy hikuna ha kadihaman, ha lapos. Ihay i pagsangisangetan ken pagngaretngetan na totolay gipu ha parusa di.’” ");
INSERT INTO duo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Intulos ni Jesus a kinagi na, “Nokkan, nu magsoli ak ken mapigsa i kainamakan ko ken agumanak na ngamin a anghel a hidi, magetnodak a maghari ha katangkayan a pagetnodan. ");
INSERT INTO duo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ha tiyempo ito, matipon-tipon ha saguppang ko i ngamin a tolay. Ket pabukodan ko i mappiya a hidi, a kona ha gimet na mahagdapon ha karnero ken kalding. ");
INSERT INTO duo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Idatton ko i mappiya a hidi ha makanawan ko. Ket idatton ko i madukas a hidi ha makanigid ko. ");
INSERT INTO duo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Sako, ipeta ha nidi ha makanawan ko, ‘Hen kamon ihe, hikam a kinagbiyan Nama ko. Sumdap kam, a maghen kam ha kahariyan a nesagana ha nikam idi pinnakaparsuwa na lutak aye. ");
INSERT INTO duo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ta idi nangiyalapak, ket pinakanak moy. Idi nauwawak, ket pinainumak moy. Dinumematak ha nikam a kona ha ganggannaet, ket pinadagusak moy. ");
INSERT INTO duo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Idi awanak ha badu, ket pinabaduwanak moy. Idi nagsaketak, ket inagumanak moy. Idi nebaludak ha pagbaludan, ket pinasyarak moy,’ kon ko ha mappiya a hidi. ");
INSERT INTO duo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ket ipeta na mappiya a hidi ha nikan, ‘Apo, hangan a netan mi ka a magiyalap ka, ket pinakan mi ka, onu mauwaw ka ket pinainum mi ka? ");
INSERT INTO duo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hangan i pinakaenta mi ha nikaw a ganggannaet ket pinadagus mi ka, onu awan ka ha badu ket binaduwan mi ka? ");
INSERT INTO duo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hangan i pinakaenta mi ha nikaw a masaket onu nebalud, ket inaguman mi ka?’ ");
INSERT INTO duo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Sako, ipeta ha nidi, ‘Nanakaman moy ide. Ha ngamin a pinagagum moy ha kadibbiyan a totolay a manahod ha nikan, nebilang a hikan i dinaggapan moy.’ ");
INSERT INTO duo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Sako, ipeta ha madukas a hidi a nedatton ha makannigid ko, ‘Umadiyo kam ha nikan, hikam a inlunod na Dios! Meyangay kam ha gangatan a awan maaddap, a nesagana ha ni Satanas ken anghel na a hidi a tinumalekod ha Dios. ");
INSERT INTO duo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ta nagiyalapak idi, ngem awanak moy pinakan. Ket nauwawak, ngem awanak moy pinainum. ");
INSERT INTO duo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nagbisita ak ha nikam, ngem awanak moy pinadagus. Ket awanak ha badu, ngem inkemot moy i tennon ha nikan. Nagsaket ak, ket nebaludak idi, ngem awanak moy inaguman.’ ");
INSERT INTO duo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ket itabbeg na madukas a hidi, ‘Apo, hangan i pinakaenta mi ha nikaw a nagiyalap onu mauwaw, a ganggannaet ken awan ha badu, onu nasaket ken nebalud, ket awan mi ka dinaggapan?’ ");
INSERT INTO duo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Sako, ipeta ha nidi, ‘Nanakaman moy ide, a idi minadiyan moy a daggapan idagende a kadibbiyan a manmanahod ha nikan, nebilang a minadiyanak moy bila.’ ");
INSERT INTO duo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Isu,” kagi ni Jesus, “idagende a madukas a tolay ha makannigid ko, hidi man i maparusaan ha magnanayon. Ngem ha mappiya a hidi ha makannawan ko, hidi man i makipaghen ha Apo Dios ha magnanayon.” ");
INSERT INTO duo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Niyaen, idi kobosan na ngamin a pinagitoldu aye ni Jesus, kinagi na ha tolduwan na a hidi, ");
INSERT INTO duo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Katandi moy dan a duwa pala a pamalak, ket dumemat i Piyesta na Pinagtaleban na Anghel a Magpatay. Ket ha iday a pamalak, megiwat i Annak na Dios a Nagbalin a Tolay ha magturay a hidi, a ipelansa di ak ha kudos.” ");
INSERT INTO duo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Niyaen, nagmiting i kapkapitan na padi ken panglakayan a hidi ha bilay ni Kaipas, a Katangkayan a Padi. ");
INSERT INTO duo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ket nakipaggammong hidi nu panyan di a padakapan ni Jesus ha nalimed, sadi, papatay hikuna. ");
INSERT INTO duo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Ngem awan ha yenan a piyesta,” kinagi di, “amangan nu magriribuk i kakpalan a tolay.” ");
INSERT INTO duo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Idi atoy di Jesus ha ili a Betaniya, hen hidi ha bilay ni Simon a nakahusay ha kattal na. ");
INSERT INTO duo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Idi nangan pala hidi, dinumemat i esa a babbey a nakaegkam ha esa a botelya. Ket naputat ito ha mangina a pagbangbanglo. Ket inbulak na ha buntok ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ngem nakaingal i toltolduwan ni Jesus, idi naenta di i ginimet na babbey. Ket nagkinagi hidi ha, “Apay a ginastuwan na babbey i bangbanglo aye? ");
INSERT INTO duo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nelako mina ito ha korinat. Ta nangina mina i pakelakowan na, sa meyatad i kuwarto ha napobre a hidi.” ");
INSERT INTO duo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngem katandi ni Jesus i kinagi di. Isu, kinagi na, “Apay a pagkagiyan moy i babbey aye? Ta mappiya unay i ginimet na ha nikan. ");
INSERT INTO duo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ta kankanayon a atoy i napobre a hidi ha henan moy. Ket madaggapan moy hidi ha maski nu anya a oras. Ngem bakkan ha nikan. Ta awan maalay i paghen ko ha nikam. ");
INSERT INTO duo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ket ha ide a babbey, nagserbe hikuna ha nikan gipu ha pinagbulak na aye. Ta inbulak na i pangpuhet ha natay. Isu, nesagana na i baggi ko, a dandani dan a melabbang. ");
INSERT INTO duo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ket nanakaman moy mina ide a ipeta ko ha nikam, a ha maski nu hadya ha ngamin a lutak a pagtolduwan di ha Mappiya a Baheta na Dios, mepakatandi bila i ginimet na babbey aye. Ket pagpanakam bi ito ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kobosan na ito, inumangay ni Judas Iskaryote, a esa a lallaki ha esa pulo ket duwa a tolduwan ni Jesus. Inumangay hikuna ha kapkapitan a hidi na padi. ");
INSERT INTO duo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ket kinagi na ha nidi, “Hangan i iyatad moy ha nikan, nu igiwat ko ni Jesus ha nikam?” Ket inatdinan di hikuna ha tallu a pulo a kuwarto a pirak. ");
INSERT INTO duo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Isu, nangrugi ni Judas a magnakam, nu panyan na a liputan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dinumemat i nekaesa a pamalak na Piyesta. Ide i pamalak a magkan hidi ha malapis a tinapay, a awan ha lebadura na. Ket nagenan di ito ha “Pangapon na Pinagtaleban.” Niyaen, inumangay ha ni Jesus i toltolduwan na, a sinalodsod di, “Hadya i kayat mo a pangisaganaan mi ha Pangapon na Pinagtaleban?” ");
INSERT INTO duo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ket kinagi na, “Umangay kam ha ili, ha iday a lallaki a atoy hay. Ket ipeta moy ha nikuna, ‘Kinagi ni Maestro a dinumemat kan i oras na. Ket ha bilay moy kan i paghenan mi a magkan ha Pangapon na Pinagtaleban. Atoy hikuna ken hikami a toltolduwan na,’ kon moy ah.” ");
INSERT INTO duo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Isu inumangay i toltolduwan na, a tinungpal di i inpeta ni Jesus, a insagana di i Pangapon na Pinagtaleban. ");
INSERT INTO duo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Idi kallap dan, nangan ni Jesus ken esa pulo ket duwa a tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Idi mangan pala hidi, kinagi ni Jesus, “Tahod ide a ipeta ko ha nikam, a atoy ha nikam i mangliput ha nikan.” ");
INSERT INTO duo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ket nagladingit i tolduwan na a hidi. Ket esesa a nagsolodsod hidi ha ni Jesus, “Sabali a hikan i konan mo, anya?” ");
INSERT INTO duo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ket kinagi ni Jesus, “Awan ha sabali, nu awan i makisawsaw ha nikan ha tinapay ha digu aye. ");
INSERT INTO duo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Hikan i Annak na Dios a Nagbalin a Tolay. Ket masapul a matayak nokkan a kona ha nesurat ha Libro na Dios. Ngem marigat unay i parusa ha mangliput ha nikan. Sayang agay ha nikuna. Mas mappiya nu awan hikuna neenak.” ");
INSERT INTO duo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Niyaen, kinagi ni Judas, “Maestro, hikan i konan mo?” Ket tinabbeg ni Jesus, “Awan ha sabali nu awan a hikaw.” ");
INSERT INTO duo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Idi nangan pala hidi, nangalap ni Jesus ha tinapay. Ket nagyaman hikuna ha Dios. Ket pinilakpilak na i tinapay. Sana, inyatad ha nidi. Ket inpeta na, “Alapan moy ide, ket kanan moy. Ide i baggi ko.” ");
INSERT INTO duo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ket inalap na bila i baso na basi. Ket idi nagyaman hikuna ha Dios, ingiwat na ha nidi, a kinagi na, “Uminom kam ngamin ha ide,” kon na, ");
INSERT INTO duo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“ta ide i digi ko a pangtongpal ko ha kari na Dios. Ibulak ko i digi ko para ha makpal a tolay, penu mapakawan i liwaliwat di. ");
INSERT INTO duo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ket tahod ide a ipeta ko ha nikam, a awanak manon uminom ha basi na ubas, a kona ihe, hanggan ha pamalak nu makipaginom kitam manon ha Paghariyan Nama ko.” ");
INSERT INTO duo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Idi nagkansiyon hidi ha pagdeyaw di ha Dios, inumangay hidi ha amugod na Olibo. ");
INSERT INTO duo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kinagi ni Jesus ha nidi, “Ha yenan a kallap, buyotanak moy ngamin. Ta nesurat ha Libro na Dios, a ‘Patayan ko i mahagdapon ha karnero,’ kon na Dios, ‘ket mawarawara i karnero na a hidi,’ kon na. ");
INSERT INTO duo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngem nokkan nu magbiyagak manon,” intulos ni Jesus, “magpalungo ak ha nikam a umangay ha Galileya. Ket urayan takam ihay.” ");
INSERT INTO duo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kinagi ni Pedro, “Maski nu bumuyot hidi ngamin a tolduwan mo, awanak sumina ha nikaw.” ");
INSERT INTO duo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ngem kinagi ni Jesus, “Tahod ide a ipeta ko ha nikaw, ha yenan a kallap, ha palungo a magtaraok i kawitan, ket namintallu dan a inlibak mo ak.” ");
INSERT INTO duo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ngem tinabbeg ni Pedro, “Maski nu matayak gipu ha nikaw, pulos, a awan taka ilibak.” Ket kona bila hito i kinagi na ngamin a tolduwan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Niyaen, inumangay di Jesus ha kakayowan, ha Getsemani. Ket kinagi na ha tolduwan na a hidi, “Magetnod kam ha he, a maguray. Ta umangayak pala ho a magkararag.” ");
INSERT INTO duo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ket inkuyog na ni Pedro, ken i magkabsat, a duwa a annak ni Sebedeyo. Niyaen, madaggi unay i nakam ni Jesus. Ket nagriribuk i nakam na, gipu ha dandani a magimet ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ket kinagi ni Jesus ha nidi, “Matayak dan gipu ha nakaro a ladinget ko. Magwarak kam ihe, ket makipagpuyat kam ha nikan.” ");
INSERT INTO duo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Inumadiyo ha ballik ni Jesus, sa, hinumakab ha lutak. Ket inkararag na, “Amang,” kagi na, “nu mabalin mina, awanak mo bi adiyowan ha magnanayon ha katay ko. Ngem maski nu kona hito a mahukomanak, bakkan mina a pagayatan ko i gimetan mo, nu awan i pagayatan mo. Ket usegan ko i kayat mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Idi nagsoli ni Jesus, nadanon na a kumakelap idagende a tallu a tolduwan na. Ket kinagi na ha ni Pedro, “Simon, nakakillap ka dan? Awan ka dod makapagpuyat ha maski esa a oras, ket magagum ha nikan? ");
INSERT INTO duo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpuyat kam ken magkararag kam, penu awan kam magliwat nu solisog na kam ni Satanas. Katandi ko a sisasagana kam a maggimet ha mappiya, ngem malupoy i baggi moy.” ");
INSERT INTO duo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ket inumangay manon ni Jesus a magkararag. Ket inpenduwa na i inaged na ha Dios. “Amang,” kagi na, “nu awan ko malisiyan i paghukom mo ha nikan, kayat ko pala a umuseg ha pagayatan mo.” ");
INSERT INTO duo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sa, nagsoli manon ha henan na tolduwan na a hidi, ket nadanonan na hidi a kinumillap. Ta nakakillap hidi unay. ");
INSERT INTO duo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ket napentallu a inumangay hikuna a magkararag. Ket inpentallu na i kararag na. ");
INSERT INTO duo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Idi kasoli na, kinagi na ha nidi, “Anya, kumilap kam pala? Nobos dan ito. Dinumemat dan i oras a megiwatak ha madukas a hidi. ");
INSERT INTO duo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Umikat kam. Entamon! Entan moy a atoy dan i mangliput ha nikan.” ");
INSERT INTO duo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Idi nagkagi pala ni Jesus, dinumemat ni Judas. Hikuna i esa ha dagenday esa pulo ket duwa a nagkeagum ha ni Jesus. Ket nakikuyog bila ha ni Judas i makpal a nagtagisondang ken nagtagigahoti. Naggipu hidi ha matangkay a papadi, ken mamaestro na linteg, ken panglakayan a hidi na Judyo. ");
INSERT INTO duo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Idi palungo a dumemat hidi ha ni Jesus, inpeta ni Judas ha agagum na, “Besongan ko nokkan i lallaki a eriyokan moy. Hikuna mina i dakapan moy.” ");
INSERT INTO duo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Isu, binumikan a dagus ni Judas ha ni Jesus. Ket kinagi na, “Maestro!” Sana, Bibesongan. ");
INSERT INTO duo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kinagi ni Jesus, “Agay! Ide i gipu na a atoy ka he?” Idi pinagkagi na ito, dinakap di ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngem ha agagum ni Jesus, atoy i esa a nagsakrot ha sondang na. Ket kinatol na i tagabu na katangkayan a padi. Ket nesina na i talinga na. ");
INSERT INTO duo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kinagi ni Jesus ha nikuna, “Idulin mo dan i sondang mo! Ha mangusar ha sondang, hikuna bila i matay gipu ha sondang. ");
INSERT INTO duo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Awan moy katandiyan a makaagedak ha Nama ko, ket paangayan na a dagus i rinibribu a anghel. ");
INSERT INTO duo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ngem nu kona hay i gimetan ko, awan a matungpal i nesurat ha Libro na Dios megipu ha pagrigat ko.” ");
INSERT INTO duo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sana, kinagi ni Jesus ha kakpalan a hidi, “Mahagtakawak dod? Apay a usaran moy i sondang ken gahote a pangdakap moy ha nikan? Nikuna kadapamalak, nangitolduwak ha saguppang moy ha Templo. Ket awanak moy dinakap. ");
INSERT INTO duo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngem niyaen, nagimet i ngamin a ide penu matungpal i nesurat na minahagpugto a hidi ha Libro na Dios.” Idi pinagkagi ito ni Jesus, binumuyot i tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kobosan na pinangdakap di ha ni Jesus, inyangay di hikuna ha bilay na katangkayan a padi. Ket atoy bila hay i ngamin a panglakayan na Judyo, ken maestro a hidi na Linteg, a pinumisan dan hidi. ");
INSERT INTO duo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Niyaen, tinumagubet ni Pedro, ha madiyo ballik, hanggan ha paraangan na bilay na Katangkayan a Padi. Ket sinumadap hikuna a nakikaetnod ha guwardya a hidi, penu maenta na nu anya i magimet. ");
INSERT INTO duo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ha iday a oras, ha Katangkayan a Padi ken ngamin a agagum na, magerieriyok hidi ha sistigu a mangpaliwat mina ha ni Jesus, penu mapapatay di hikuna. ");
INSERT INTO duo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ngem awan ha sistigu a naeriyokan di. Maski makpal i nangpaliwat ha ni Jesus, ngem silisileng la i inpeta di. Ha dilokod na, atoy i duwa a sinumaggupang, ");
INSERT INTO duo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a kinagi di, “Kinagi na lallaki aye a kabaelan na a rakrakan i Templo na Dios, ket pataknagan na manon ha tallu a pamalak,” kon di. ");
INSERT INTO duo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Niyaen, tinumaknag i Katangkayan a Padi. Ket kinagi na ha ni Jesus, “Madiyan mo a magtabbeg? Anya ipeta mo megipu ha ngamin a pagpaliwat di ha nikaw?” ");
INSERT INTO duo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngem nagulimek la ni Jesus. Ket kinagi na Katangkayan a Padi, “Isapata mo dan ha nagen na sibibiyag a Dios, ket ipeta mo nu hikaw i Cristu a Annak na Dios.” ");
INSERT INTO duo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ket kinagi ni Jesus, “Oni. Tahod i kinagi mo. Ket ipeta ko ha nikam ngamin, kobosan na ide a tiyempo mangenta kam ha nikan, a Annak na Dios a Nagbalin a Tolay. Ket magetnodak ha henan na Dios. Ket metan moy i pagsoli ko ha ulaulap.” ");
INSERT INTO duo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Idi nateman na ito na Katangkayan a Padi, pinisad na i kagay na, a kinagi na, “Awan tam masapul a magteman ha sistigu a hidi. Ta nateman tam i kinagi na a magsenti ha Apo Dios. Madukas iday, a kona nu baggi na a mismo i Apo Dios. ");
INSERT INTO duo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Isu, niyaen, anya i nakaman moy?” kon na Katangkayan a Padi. Ket intabbeg di ngamin, “Nakaliwat hikuna. Masapul a matay.” ");
INSERT INTO duo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sadi, linoktaloktaban i rupa na. Ket dinanogdanog di hikuna. Ket linappag na kappal, ");
INSERT INTO duo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","a kinagi di, “Nay! Hikaw kan i Cristu! Isu, pugtowan mo nu heya i nanglappag ha nikaw,” kon di. ");
INSERT INTO duo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Niyaen, ha ni Pedro, nagetnod pala hikuna ha paraangan na bilay. Ket binumikan i esa a babbey, a tagabu na Katangkayan a Padi. Ket kinagi na, “Nagagum ka bila ha ni Jesus a taga-Nasaret.” ");
INSERT INTO duo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngem naglibak ni Pedro ha saguppang na ngamin a atoy hay, a kinagi na, “Awan ko makatandiyan i kagiyan mo.” ");
INSERT INTO duo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ket linumapos ni Pedro a nagturong ha ruwangan. Ket naenta na hikuna na sabali a tagabu a babbey. Kinagi na ha totolay a atoy hay, “Nakiuseg ide a lallaki ha ni Jesus a taga-Nasaret!” ");
INSERT INTO duo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ngem naglibak manon ni Pedro, a kinagi na, “Isapata ko a awan ko katandi iday a lallaki.” ");
INSERT INTO duo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Idi awan maalay, ket binumikan i totolay a atoy hay, a kinagi di, “Sigurado a hikaw i esa a nagagum ha ni Jesus, ta taga-Galileya i kakkagi mo.” ");
INSERT INTO duo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ngem insapata ni Pedro, “Maski nu parusaan na ak na Dios nu magsilengak! Tahod a awan ko katandi iday a lallaki a kakagiyan moy!” Ket dagus a nagtaraok i kawitan. ");
INSERT INTO duo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ket nanakam ni Pedro i kinagi ni Jesus, a “Ha palungo a magtaraok i kawitan, ilibakak mo ha mamintallu.” Idi nanakam ito ni Pedro, minagsaket unay i nakam na, a linumapos hikuna a nagsangisanget. ");
INSERT INTO duo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Idi nagsapa, nakipagpisan manon i matangkay a papadi, ken panglakayan a hidi. Ket nagtutulag hidi a papatayan di ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ket kinawaran di hikuna. Sadi, inyangay ha ni Pilato a gobernador. ");
INSERT INTO duo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Niyaen, ha ni Judas a nangliput ha ni Jesus, idi naenta na a papatayan di ni Jesus, nagbabawi hikuna. Ket insoli na i tallu a pulo a pirak ha matangkay a papadi ken panglakayan a hidi. ");
INSERT INTO duo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kinagi na, “Nagliwatak dan! Ta ingiwat ko a mapapatay i lallaki a awan ha liwat na.” Ket kinagi di ha ni Judas, “Awan ha biyang mi ha iday. Hikaw la i makatandi ha problema mo.” ");
INSERT INTO duo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Inwahagit ni Judas i kuwarto ha lubuk na Templo. Ket linumapos hikuna a nangibitay ha baggi na. ");
INSERT INTO duo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Inakot na matangkay a papadi i kuwarto, ket kinagi di, “Paganya tam ide a kuwarto? Ta bayad ide na biyag na esa a tolay. Isu, maneg ha Linteg tam a medatton iday ha Templo,” kon di. ");
INSERT INTO duo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Isu, kobosan na pinagtutulag di, ingatang di i kuwarto ha “Lutak ni Magdamdamili.” Ket inusar di ide a lutak para ha kamposanto na ganggannaet a hidi. ");
INSERT INTO duo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Isu i gipu na a napanagenan ito ha “Lutak na Digi” a hanggan niyaen. ");
INSERT INTO duo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ket natongpal i kinagi ni Jeremiyas a minahagpugto. Ta inpugto na idi, a “Inalap di i tallu a pulo a pirak, i presyo a nagtutulagan na Judio a hidi, a nagbayad di ha biyag na. ");
INSERT INTO duo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ket ingatang di ha Lutak ni Magdamdamili, a kona ha nepeta na Apo Dios ha nikan.” ");
INSERT INTO duo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Niyaen, idi nesaguppang di ni Jesus ha ni Gobernador Pilato, sinalodsod ni Pilato, “Anya? Hikaw i hari na Judyo a hidi?” Ket intabbeg ni Jesus, “Tahod i kinagi mo,” kon na. ");
INSERT INTO duo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngem idi inpaliwat na kapkapitan na padi ken panglakayan a hidi, awan tinumabbeg ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Isu, kinagi ni Pilato ha nikuna, “Awan ka ha tabbeg? Temanan mo i makpal a ipaliwat di ha nikaw!” ");
INSERT INTO duo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngem pulos a awan tinumabbeg ni Jesus. Ket nalaktat unay ni Pilato a awan inkalentigan ni Jesus i baggi na. ");
INSERT INTO duo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Niyaen, atoy i ugali ni Gobernador, a magpalakad ha esa a balud ha kada tawen, ha Piyesta na Pinagtaleban. Ket palobusan ni Pilato i tolay a hidi a magpili nu heya mina i palakadan na. ");
INSERT INTO duo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Niyaen, atoy i esa a balud a katandi na ngamin a tolay gipu ha ginigimet na. Ni Barrabas i nagen na. ");
INSERT INTO duo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Isu, idi nagpisan i kakpalan a tolay, kinagi ni Pilato ha nidi, “Heya i kayat moy a palakadan ko? Kayat moy ni Barrabas onu ni Jesus, a managenan ha ‘Cristu?’” ");
INSERT INTO duo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kona hito i salodsod ni Pilato gipu ta nakatandiyan na a ingiwat di ni Jesus ha nikuna gipu ha apal di ha pinaggimet ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ket esa pala, a idi nagetnod ni Pilato ha panghukoman na, a nagururay ha tabbeg na Judyo a hidi, pinaipeta na kabanga na, a “Awan mo pakibiyangan iday a nalinteg a lallaki. Ta nagtagenapak ha madukas ha kallap he. Ket narigatanak gipu ha tagenap ko aye.” ");
INSERT INTO duo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Niyaen, ha matangkay a papadi ken panglakayan a hidi, dinurogan di i tolay a hidi, penu agedan di ha ni Pilato a palakadan na ni Barrabas, ket papapatay na ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ket kinagi manon ni Pilato, “Heya ha dende a duwa i kayat moy a palakadan ko?” Ket intabbeg di, “Ni Barrabas!” ");
INSERT INTO duo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ket kinagi ni Pilato, “Anya dod i gimetan ko ha ni Jesus a managenan ha ‘Cristu?’” Ket intabbeg di ngamin, “Pelansa mo hikuna ha kudos!” ");
INSERT INTO duo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ket kinagi ni Pilato, “Apay? Anya i liwat na?” Ngem inpigsa di pala i rangsit di, “Pelansa mo hikuna ha kudos!” ");
INSERT INTO duo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Niyaen, gipu ta pakanakam ni Pilato a awan ha magimet na, ket gipu ta dandani dan a magriribuk idagende a kakpalan a tolay, nagpaalap hikuna ha dinom, ket inugisan na i kamat na ha saguppang di. Kinagi na, “Ide i pangtiplad ko ha nikam a awan ha biyang ko ha katay na lallaki aye. Hikam man i makatandi ha katay na.” ");
INSERT INTO duo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ket tinabbeg na tolay a hidi, “Pabiyanan mo iday! Ta hikami i makatandi ha katay na! Hikami ken kaputotan mi!” kon di. ");
INSERT INTO duo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kobosan na, pinalakad ni Pilato ni Barrabas. Ket pinasabbad na ni Jesus. Sana, ingiwat hikuna ha sundalu a hidi, penu ilansa di ha kudos. ");
INSERT INTO duo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Niyaen, ha dagende a sundalu, insadap di ni Jesus ha panghukoman na happo di a ni Gobernador Pilato. Ket insaguppang di i ngamin a agagum di a sundalu ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sadi, inadya i kagay na. Ket kinagayan di ni Jesus ha madideg a lupot. ");
INSERT INTO duo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ket kinawekaw di i maseset a ginimet di ha korona, a indatton di ha buntok na. Ket pinaegkam di hikuna ha tikkal ha makannawan a kamat na. Ket nagparentumeng hidi ha saguppang na, a nagindedeyaw hidi ha, “Madeydeyaw i Hari na Judyo!” kon di. ");
INSERT INTO duo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ket linoktaban di hikuna. Sadi, inalap i tikkal, a pinapakolpakol di i buntok na. ");
INSERT INTO duo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Idi nobosan di a nagulew-ulewan, inadya di i madideg a kagay na. Ket pinatennonan di ha bukod na a tennon. Sadi, inlapos hikuna, penu ilansa di ha kudos. ");
INSERT INTO duo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Idi paglakad di, natagbu di i esa a lallaki a taga-Sirene. Ni Simon i nagen na. Ket pinilit di hikuna a mangbaklay ha kudos ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kaddemat di ha lugar a managenan ha “Golgota”. Kayat na a kagiyan, “Henan na Karbot.” ");
INSERT INTO duo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ket inatdinan di ni Jesus ha arak a nalaokan ha apdu a pangpaadya mina ha saket. Ngem idi naennaman na ito, minadiyan na. ");
INSERT INTO duo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sadi, inlansa ni Jesus ha kudos. Kobosan na, binunong di i tennon na, a nagbibinunotan di nu anya i maalap na kada esa. ");
INSERT INTO duo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kobosan na, nagetnod hidi a mangbantay ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Niyaen, indatton di i surat ha kudos, ha buntokan na, a pangpaliwatan di ha nikuna. Ket nesurat, a “IDE NI JESUS, A HARI NA JUDIO.” ");
INSERT INTO duo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ket atoy bila i duwa a tulisan a inlansa di ha hikeg na. Inlansa di i esa ha makannawan na, ken esa ha makannigid na. ");
INSERT INTO duo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ket nagulew i tinumataleb a hidi ha kudos na. Ket winingwingiwingan di, ");
INSERT INTO duo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a kinagi di, “Nay ka dan! Kinagi mo a rakrakan mo i Templo, ket mapataknag mo manon ha tallu a pamalak! Nay kan! Isalakan mo i baggi mo, nu tahod a hikaw i Annak na Dios! Umogsad ka dan ha kudos aye!” ");
INSERT INTO duo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ket kona bila hito i pinagulew na kapkapitan na padi, ken mamaestro na linteg, ken panglakayan a hidi. ");
INSERT INTO duo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kinagi di, “Insalakan na kan i sabali a totolay, ngem niyaen, awan na mesalakan i baggi na. Hikuna kan i Cristu a Hari na Judyo! Nu umogsad hikuna ha kudos niyaen, manahod kitam dan ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nu tahod a magtalak hikuna ha Dios, ken nu hikuna i Annak na Dios, a kon na ha kinagi na, apay a awan isalakan na Dios?” kon di. ");
INSERT INTO duo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ket maski ha duwa a tulisan a kasabay na a nelansa, inulew di bila ni Jesus a kona hito. ");
INSERT INTO duo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Idi lubuk na pamalak, nagdiham i ngamin a lutak hanggan alas tres. ");
INSERT INTO duo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Idi manga alas tres, indulaw ni Jesus, “Eloy, Eloy, lama sabaktani?” I kayat na a kagiyan, “Dios ko, Dios ko, apay a binaybayanak mo?” ");
INSERT INTO duo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nateman na ito na kappal a nakataknag ihay, ket inulew di, a kinagi di, “Ayagan na i minahagpugto a ni Elias!” ");
INSERT INTO duo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ket nagbuyot i esa a nangalap ha hamet, ket insawsaw na ito ha makak a arak. Sana, indatton ha ontok na kayo, ket inpasapsap na ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngem kinagi na sabali a hidi, “Entan tam nu umangay ni Elias a isalakan na hikuna!” ");
INSERT INTO duo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Niyaen, indulaw manon ni Jesus ha napigsa. Kobosan na, linumakad dan i angas na. ");
INSERT INTO duo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sa, bigu la a napisad i nabigal a kurtina ha Templo. Ito i pangsallen ha totolay ha kuwarto a nadiosan, ha disalad na Templo. Ket napisad ito a naggudwa, naggipu ha ontok hanggan ha sidung. Ket nagginggined. Ket napilapilak i dadangli a hidi. ");
INSERT INTO duo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ket nalukatan i makpal a labbang, ket nagbiyag manon i makpal a tolay a nasakop na Dios. ");
INSERT INTO duo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Idi minagbiyag manon ni Jesus, linumapos hidi ha labbang di, a sinumadap hidi ha Jerusalem, a nakaenta ha nidi i makpal a tolay. ");
INSERT INTO duo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Niyaen, ha kapitan ken sunsundalu a hidi a nangbantay ha ni Jesus, idi nabati di i ginggined ken naenta di i ngamin a nagimet, nanteng hidi. Ket kinagi di, “Tahod a Annak na Dios ide a lallaki.” ");
INSERT INTO duo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ket atoy bila hay i makpal a babbey a nagtataknag ha madiyo ballik, a nangaamata hidi. Hidi man i inumunod ha ni Jesus a naggipu ha Galileya, a nagserserbe hidi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Atoy ha nidi ni Maria Magdalena, ken ni Maria a hena di Jose ken Santiyago, ken i hena na annak ni Sebedeyo. ");
INSERT INTO duo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Niyaen, idi apon dan, dinumemat i esa a baknang a magnagen ha Jose a taga-Arimateya. Hikuna i esa a tolduwan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Inumangay hikuna ha ni Pilato, ket inaged na i bangkay ni Jesus. Ket inbon ni Pilato a meyatad i bangkay ni Jesus ha ni Jose. ");
INSERT INTO duo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Inalap ni Jose i bangkay. Ket binadbad na ha bigu a maponset a hamet. ");
INSERT INTO duo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ket intagmak na ito ha bukod na a paglabbangan, a awan naalay a pinakotkot na ha dilenas. Kobosan na, insalen na i dakkal a pogedu a pangkallab ha labbang. Sa hikuna, linumakad. ");
INSERT INTO duo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ket atoy bila hay di Maria Magdalena ken agum na a Maria, a nakaetnod hidi ha saguppang na labbang. ");
INSERT INTO duo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kaugman na, idi Sabado dan, ket inumangay ha ni Pilato i kapkapitan na padi ken Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kinagi di, “Apo, manakam mi i kinagi na iday a mangallilaw a lallaki. Idi sibibiyag pala hikuna, kinagi na a magbiyag manon hikuna nu malpas i tallu a pamalak. ");
INSERT INTO duo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Isu, nu mabalin, ipabantay mo bi i labbang na hanggan ha mekatallu a pamalak. Amangan nu umangay i tolduwan na a hidi, a takawan di i bangkay na, ket ipeta di a magbiyag manon ni Jesus. Ket nu magkona hito hidi, mas madukas i dilokod a pangallilaw na ngem ha palungo.” ");
INSERT INTO duo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ket kinagi ni Pilato ha nidi, “Oni. Mangalap kam ha sundalu, ket pabantayan moy perpermi iday a labbang.” ");
INSERT INTO duo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Isu, inumangay i kapkapitan na padi ken panglakayan a hidi, ket dinattonan di ha marka i kalab a pogedu, penu masigurado di a awan ha mangialis ha pogedu aye. Ket inwarak di i sunsundalu a mangguwardya ha labbang. ");
INSERT INTO duo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Idi nobos i pamalak a maneg, idi maledum na Dominggo, inumangay ha labbang di Maria Magdalena, ken i sabali a Maria. ");
INSERT INTO duo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ket bigu la a nagginggined ha napigsa. Ta binumugsok i esa a anghel na Apo Dios a naggipu ha langit. Ket tinulid na i pogedu a nekalab ha labbang, sana, nagetnodan. ");
INSERT INTO duo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Makasili i rupa na a kona ha kidlat, ket naponset unay i kagay na a nagpahiyamhiyam. ");
INSERT INTO duo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ket gipu ha kanteng di, nagyagyag i sundalu a hidi hanggan natakneg hidi a kona ha natay. ");
INSERT INTO duo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ngem kinagi na anghel ha babbey a hidi, “Awan kamon manteng! Katandi ko a eriyokan moy ni Jesus a nelansa ha kudos. ");
INSERT INTO duo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ngem awan man hikuna ha he! Ta minagbiyag manon hikuna, a kona ha inpugto na! Hen moy he, entan i nangitagmakan di ha bangkay na. ");
INSERT INTO duo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ket magsigida kam, a ibaheta moy ha toltolduwan na, a magbiyag manon ni Jesus! Ket magpalungo hikuna ha nikam ha Galileya. Metan moy hikuna ha hay! Nay, inpeta ko dan ha nikam.” ");
INSERT INTO duo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Isu, dagus a linumapos idende a babbey. Ket binumuyot hidi penu mebaheta ha totolduwan ni Jesus. Ket maski nu nanteng hidi, inragsak di unay. ");
INSERT INTO duo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Niyaen, idi pagbuyot di, tinagbo na hidi ni Jesus, a sinalpak na hidi. Ket binumikan hidi ha ni Jesus, a hinumakab hidi ha saguppang na, ket inegkaman di i tikad na, a nagdeydeyaw hidi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ket kinagi ni Jesus ha nidi, “Awan kamon manteng. Hen moy ibaheta ha kakabsat ko, a umangay hidi ha Galileya. Ket metan di ak nokkan ha hay.” ");
INSERT INTO duo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Idi paglakad pala na babbey a hidi, inumangay ha ili i kappal a guwardya. Ket inbaheta di ha matangkay a papadi i ngamin a nagimet. ");
INSERT INTO duo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ket nakipagmiting i matangkay a papadi ken panglakayan a hidi. Inuhon di nu anya mina i gimetan di. Sadi, inatdinan i sundalu a hidi ha kuwarto. ");
INSERT INTO duo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kinagi di, “Basta ipeta moy a inumangay i totolduwan na ha kallap, ket tinakaw di i bangkay ni Jesus, idi nakakillap kam. ");
INSERT INTO duo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ket nu nabaheta na ito ni Gobernador, patalnaan mi hikuna, penu awan kam maparusaan.” ");
INSERT INTO duo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Isu, inalap na guwardya a hidi i korinat, ket ginimet di i nebon ha nidi. Ket ide i estoriya a newaras ha Judyo a hidi hanggan ha yenan a tiyempo. ");
INSERT INTO duo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Niyaen, inumangay ha Galileya i esa pulo ket esa a tolduwan na, hanggan ha parabin a inpeta ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Idi metan di ni Jesus, nagdeydeyaw hidi ha nikuna. Ngem ha kappal ha nidi, nagduwaduwa hidi. ");
INSERT INTO duo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ket binumikan ni Jesus a kinagi na ha nidi, “Neyatad dan ha nikan i ngamin a turay ha langit ken ha lutak. ");
INSERT INTO duo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Isu, ibon ko ha nikam a gipu ta umaangay kam ha ngamin a tolay ha lutak, pagbalinan moy hidi a tolduwan ko. Binyagan moy hidi ha nagen Nama ko, ken hikan a annak na, ken ha Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tolduwan moy hidi a magtungpal ha ngamin a inbon ko ha nikam. Ket nanakaman moy ide, a hikan i agum moy a kanayon, hanggan awan ha kahad.”");
INSERT INTO duo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ide a surat i Mappiya a Baheta megipu ha ni Jesu-Cristu, a Annak na Dios. ");
INSERT INTO duo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Idi palungo, ket kona ha nesurat ni Isayas a minahagpugto. Nesurat na i inpeta na Dios ha Annak na, a “Atoy i pagpalungowan ko ha nikaw a mangibaheta megipu ha nikaw. Ket paggayakan na i totolay ha pagdemat mo. ");
INSERT INTO duo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mahagayag hikuna ha amamugod. Ket iyayag na, a ‘Dandani a dumemat i Apo Cristu. Isu, maggayak kamon ha pagdemat na. Ket pappiyaan moy dan i paglakadan na.’” Iday i inpeta na Dios ha Annak na. Ket nesurat ito ni Isayas a minahagpugto, idi nikuna a palungo. ");
INSERT INTO duo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Niyaen, natongpal ito gipu ta naghen ni Juan a Mahagbinyag ha luglugar a awan ha bilabilay. Ket nakangbinyag ken nagitoldu hikuna ha totolay a hidi. Ket inpakatandi na a magpabinyag mina hidi penu mepaenta di a nagbabawi dan hidi ha liwaliwat di ken pinakawan na hidi na Dios ha liwaliwat di. ");
INSERT INTO duo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ket makpal i inumangay a nagteman ha nikuna. Naggipu hidi ha ili a Jerusalem ken entero a probinsiya na a Judeya. Ket nagbabawi hidi, a nagoni hidi a madukas i ginimigimet di. Ket bininyagan na hidi ni Juan ha karayan Jordan. ");
INSERT INTO duo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Niyaen, i ugali ni Juan i magtennon ha tennon na napobre a hidi ken magkan ha kakanan na napobre. Ta naladi i tennon na ha buk na hayup, ken gaddang na hayup i pagsinturon na. I pagkanan na i haksa ken habu na pitukan. ");
INSERT INTO duo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ket ha pinagitoldu na, nakangpakatandi hikuna, a “Atoy nokkan i esa a umuunod ha nikan. Ket mas maturay hikuna ngem hikan. Ta nu ikalanak moy ha nikuna, awanak mekari a mangadya ha sapatos na a kona mina ha tagabu na. Ta hikuna i mas maturay. ");
INSERT INTO duo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ha nikan, dinom la i pangbinyag ko ha nikam. Ngem ha nikuna, i Espiritu na Dios i pangbinyag na,” a kayat na kagiyan a peturayan na hidi ha Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Idi awan naalay ket dinumemat ni Jesus a naggipu ha ili a Nasaret, ha probinsiya a Galileya. Ket bininyagan na hikuna ni Juan ha karayan Jordan. ");
INSERT INTO duo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kaawas ni Jesus ha dinom, ket naenta na i langit a linumukat ken i Espiritu na Dios a inumugsad ha nikuna a kona ha kalapati. ");
INSERT INTO duo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ket atoy i esa a timek a naggipu ha langit, “Hikaw i annak ko a ayayatan ko. Matalakak unay ha nikaw,” kon na Dios. ");
INSERT INTO duo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ket sigud a inturong na Espiritu na Dios ni Jesus ha luglugar a awan ha tolay na. ");
INSERT INTO duo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ket naghen hikuna hito ha uppat a pulo a pamalak. Ket ha ide a tiyempo, sinulsolisog ni Satanas. Ket atoy bila hay i maingal a hidi a hayup. Ngem atoy bila i anghel a hidi a nagagum ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Idi nebalud ni Juan a Mahagbinyag, inumangay ni Jesus ha probinsiya a Galileya. Ket intotoldu na i Mappiya a Baheta a naggipu ha Dios. ");
INSERT INTO duo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ket inbabaheta na, a “Dinumemat dan i oras a paghari na Dios. Magbabawi kamon ha ngamin a liwaliwat moy, ket manahod kam ha ide a Mappiya a Baheta,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Niyaen, idi naglakalakad ni Jesus ha baybay na Galileya, naenta na i duwa a patakka a mahagpadut, a ni Simon ken ni Andres. Ket nangisawat hidi ha sigay di. ");
INSERT INTO duo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ket kinagi ni Jesus ha nidi, “Umuseg kam ha nikan a magbalin a tolduwan ko. Ket awan kam mahagalap ha padut nu awan a mahagitoldu kam ha totolay, penu masakop ko hidi ha paghariyan na Dios,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ket sigud a inwarak di i sigay di ket inumuseg hidi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ket namaybay di Jesus ha ballik pala, ket naenta na di Santiyago ken Juan a patakka, a annak hidi ni Sebedeyo. Ket nagetnod hidi ha abang di a naggayak ha sigay di. ");
INSERT INTO duo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ket dagus a inayagan na bila hidi. Sa di, inwarak i hama di ken natangdanan a hidi a agagum dima di ha abang, ket inumuseg hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Dinumitang hidi ha ili a Kapernaum. Idi Sabado a pamalak a panganeg, nagitoldu ni Jesus ha kapilya na Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ket nalaktat hidi a nagteman, gipu ta manakabalin i pagitoldu na, ket bakkan a kona ha maestro a hidi na Linteg. ");
INSERT INTO duo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Idi nagitoldu pala ni Jesus, sinumadap ha kapilya i esa a lakay a naawag na dimonyo. ");
INSERT INTO duo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Inrangsit na, “Hikaw! Jesus a taga Nasaret! Katandi ko dan a hikaw i esa a pinaangay na Dios! Awan ka ha pakibiyang ha nikami! Awan mo dadailan i gimigimetan mi,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngem inbon ni Jesus ha ide a dimonyo, “Awan kas magkagi! Lumapos ka dan. Ket itirak mo i baggi na!” ");
INSERT INTO duo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sa, pinayagyag na dimonyo i baggi na lakay, ket inrangsit na ha mapigsa. Sa hikuna, linumapos ha baggi na lakay heya. ");
INSERT INTO duo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ket nalaktat unay i Judyo a hidi, ket nagsinalodsod hidi ha, “Anya wade? Ta sabali i pagitoldu ni Jesus! Ket makaturay hikuna a magbon ha didimonyo. Ket magtungpal hidi ha nikuna,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ket sigida a newaras i baheta megipu ha ni Jesus ha ngamin a Galileya. ");
INSERT INTO duo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Idi linumapos di Jesus ha kapilya, dinumiretso hidi ha bilay di Simon a patakka, a kaagum di bila ni Santiyago ken ni Juan. ");
INSERT INTO duo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Niyaen, nagsaket i manugang ni Simon, ta nagladu. Ket inpeta di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ket inumangay ni Jesus a kinabitan na, ket dinaggapan na a inumikat. Ket hinumusay i ladu na. Ket sinerbiyan na hidi. ");
INSERT INTO duo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Idi kinumaltob dan i senggit, ket nagpipisan i umili a hidi ha saguppang na bilay a naghenan di Jesus. Ket intugan di ha nikuna i ngamin a nasaksaket onu naawag na didimonyo. ");
INSERT INTO duo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ket pinahusay ni Jesus i nagsaket a hidi, ket pinalakad na i makpal a dimonyo. Ket awan na pinalobusan i didimonyo a magkagi, ta katandi di a hikuna i Annak na Dios. ");
INSERT INTO duo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Idi kaugman na, ket awan pala mademlag, inumikat ni Jesus, ket inumangay ha lugar a awan ha tolay, a nagkararag. ");
INSERT INTO duo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ngem linumapos bila ni Simon ken agagum na a mageriyok ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Idi naeriyokan di, kinagi di, “Maestro, eriyokan na ka na ngamin a kakaili mi aye.” ");
INSERT INTO duo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngem kinagi ni Jesus, “Entamon agay. Tumulos kitam mina ha sabasabali a ili. Ta masapul a magitolduwak ha dendo a lugar. Ide i nangangayan ko ha ihe,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Isu, linumakad di Jesus ha ngamin a Galileya. Ket nagitoldu hikuna ha kapikapilya na Judyo a hidi ken pinalakad na i madukas a hidi a espiritu. ");
INSERT INTO duo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Niyaen, atoy i esa a lakay a magkattal a inumangay ha ni Jesus. Ket nagparentumeng a nagpakagbi ha nikuna. “Apo, nu kayat mo, mapahusay mo i baggi ko!” kon na. ");
INSERT INTO duo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ket kinagbiyan ni Jesus a intupo na i kamat na, ket inpeta na, “Kayat ko,” kon na. “Humusay ka dan!” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ket bigu la, naadya i kattal na. Ket nahusay i baggi na. ");
INSERT INTO duo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ket pinaglakad hikuna ni Jesus a binon na a perpermi. ");
INSERT INTO duo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kinagi na, “Awan kas magkagi ha maski nu heya. Imbes na, magdiretso ka ha padi, penu bilengan na ka. Ket iyatad mo ha nikuna i pangiwagah mo, penu matongpal i bon ni Moyses. Ket nu kona ihay i gimetan mo, mapanahod mo hidi a pinahusay na ka na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngem idi nakalakad i lakay, inbahebaheta na megipu ha nagimet ha baggi na. Ket newaras paman ide a baheta. Ket ide i gipu na a nasalenan ni Jesus, a awan nakasaddap ha maski nu anya a ili. Naghen dalla hikuna ha lapos na il-ili. Ket kanayon a dumulug ha nikuna i makpal a tolay. ");
INSERT INTO duo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Idi kobosan na kappal a pamalak, ket nagsoli ni Jesus ha ili a Kapernaum. Ket nabaheta na tolay a hidi a nagsoli dan hikuna. ");
INSERT INTO duo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","3","Ket dinumulog i makpal hanggan awan hidi ha lugar, maski ha lebut na ridaw. Idi nagitoldu pala ni Jesus, ket dinumemat i uppat a lallaki a nangisew ha esa a napilay. ");
INSERT INTO duo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ngem gipu ha kakpal na tolay, awan di neyabot ha ni Jesus iday a napilay. Isu, inabotan di i atap ha batug ni Jesus, sa di, intostos i dayon a nagabbagan na pilay. ");
INSERT INTO duo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Idi nakatandiyan ni Jesus a dakkal i panahod di, a nagkona hito, inpeta na ha pilay, “Ilay ko, napakawan dan i liwaliwat mo.” ");
INSERT INTO duo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Niyaen, atoy bila hay i kappal a maestro na Linteg. Ket idi nateman di ito, kinagi di ha nakam di, ");
INSERT INTO duo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Apay! Heya i lallaki aye a agindidios? Heya i makapakawan ha liwat na tolay, nu awan la i Dios! Ta awan ha sabali,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ngem nakatandiyan ni Jesus i nakam di, ket kinagi na, “Apay a kona hay i nakam moy? ");
INSERT INTO duo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Makatandiyan moy mina i pagturay na Annak na Dios a Nagbalin a Tolay. Isu, niyaen, entan moy i pilay aye. Ta awan ha turay ha totolay a makepeta ha, ‘Mapakawan dan i liwaliwat mo!’ Ket awan ha tolay a makepeta ha, ‘Umikat ka! Makalakad ka dan!’ Tamos. Ngem ha nikan, makapaenta ak ha nikam a atoyak ha turay a mangpakawan ha liwat na tolay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ket inpeta na ha iday a pilay, “Ibon ko ha nikaw, a umikat ka, ket alapan mo i ulas mo, ket magsoli ka dan ha bilay mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ket dagus a inumikat i napilay. Ket inalap na i ulas na, ket nagsoli hikuna ha saguppang di ngamin. Ket nasbew hidi ngamin, ket indeydeyaw di i Dios. Kinagi di, “Niyaen la a naenta tam i kon na he!” kon di. ");
INSERT INTO duo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nagsoli manon ni Jesus ha baybay na Galileya. Ket dinumulog ha nikuna i makpal a tolay. Ket nagitoldu hikuna ha nidi. ");
INSERT INTO duo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Idi tinumulos manon hikuna a maglakad, naenta na i esa a mahagpabuwis a magetnod ha pahagsingeran na. Ni Lebi i nagen na, a annak ni Alpeyo. Ket inpeta ni Jesus ha ni Lebi, “Umuseg ka ha nikan,” kon na. Ket tinumaknag ni Lebi, a inumuseg ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sa, idi nakipagkan di Jesus ha bilay ni Lebi, atoy bila ha ni Jesus ken tolduwan na a hidi i makpal a mahagpabuwis, ken sabasabali a mahagsalungasing ha Linteg. Ta atoy i makpal a inumunod ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ket atoy bila i kappal a Pariseyo a mahagitoldu ha Linteg. Ket idi naenta di a makipagkan ni Jesus ha madukas a totolay, kinagi di ha totolduwan ni Jesus, “Apay a makipagkan hikuna ha mahagpabuwis ken madukas a hidi?” kon di. ");
INSERT INTO duo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ngem nateman ito ni Jesus, ket hikuna i tinumabbeg. Kinagi na, “Nu mahusay i baggi na tolay, awan na masapul i doktor. I magsaket la i makasapul ha doktor. Ket hikan bi i kona ha doktor. Awanak inumangay penu pagbabawiyan ko i mappiya a hidi a awan ha liwat di, nu awan i madukas a hidi a nagliwat dan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Idi esa a pamalak, nagpabiyan a magkan i totolduwan ni Juan a Mahagbinyag ken Pariseyo a hidi. Ta kayat di a magtungpal ha pagitoldu na Judyo. Ket inumangay i kappal ha ni Jesus, ket sinalodsod di, “Apay a magpabiyan a magkan i tolduwan a hidi ni Juan a Mahagbinyag, pati hidi a tolduwan na Pariseyo a hidi. Ngem awan a kona hito ha totolduwan mo. Apay a awan kam umuseg ha pagitoldu di?” kinagi di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ket tinabbeg ni Jesus, “Oni, ket kona ha ide i pangaregan ko ha nikam, a nu atoy i pagbodaan, ken atoy i nobyo ken agagum na, anya wade, magkan hidi, onu awan? Siyempre agay! Makipagragsak hidi ken magkan! Awan a mabalin a awan hidi magkan, basta atoy pala i nobyo ha henan di! ");
INSERT INTO duo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngem dumemat nokkan i sabali a tiyempo, ket madakap ide a nobyo, ket mepaadiyo hikuna. Ket iday i tiyempo a pangpabiyan di a magkan, ta maladinget dan hidi,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ket intulos ni Jesus i pangaregan na, penu makatandiyan di a awan a mabalin nu melaok i bigu a pagitoldu na, ken alegid a pagitoldu na Judyo. Kinagi na, “Nu atoy i mayat a magitakop ha badu a alegid, awan na meusar i bigu a hamet a pangapol na ha alegid a badu. Ta nu padasan na ito, bumallik i bigu a hamet a intakop na, ket dumakkal manon i pisad na badu. ");
INSERT INTO duo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ket kona bila ha ide. Awan ha mangiyasak ha bigu a basi ha alegid a gaddang a pagsupot na. Ta mapadtak na bigu a basi iday a nesupotan na. Ket magabuyos i bigu a basi. Ket napisad dan i supot. Imbes na, mappiya malla nu meyasak i bigu a basi ha bigu bila a gaddang a pagsupot na.” ");
INSERT INTO duo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Idi esa a pamalak a maneg na Judyo, naglakalakad di Jesus ha talon. Ket atoy i tolduwan ni Jesus, a nangrugi hidi a magaphok ken magkasel ken magkan ha dawa. ");
INSERT INTO duo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ngem atoy bila i Pariseyo a hidi. Ket kinagi di, “Apay? Sabado dan niyaen, ket maggimet kam ha maneg ha Linteg na Judyo,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ket tinabbeg ni Jesus, “Awan moy dod manakam i nabasa moy megipu ha ni Dabid ken agagum na, idi nagiyalap ken narigrigatan hidi? ");
INSERT INTO duo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nagimet ito idi nagturay di Abiyatar a Katangkayan a Padi. Idi nagiyalap di Dabid, sinumadap hidi ha bilay na Dios, ket inakot ni Dabid i tinapay a pangidatton na padi ha Dios. Ket nagkan hikuna ha denday, ket ingiwat na bila ha agagum na. Maski nu papadi la i mabalin a magkan ha tinapay a kona hay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sa na, kinagi ha nidi, “Bakkan a pinarsuwa na Dios i tolay penu mapilit hidi, gipu ha Pamalak a Maneg, nu awan a ginimet na ide a Pamalak a Maneg para ha pinagemmang na totolay. ");
INSERT INTO duo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Niyaen, ha nikan, anya dod i turay ko? Ipeta ko ha nikam a makaturay i Annak na Dios a Nagbalin a Tolay. Ket mepeta ko i gimetan na tolay ha Pamalak a Maneg,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Idi sabali pala a Sabado, sinumadap ni Jesus ha esa a kapilya na Judyo. Ket atoy bila hay i esa a lakay a napilay ha kamat na. ");
INSERT INTO duo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ket atoy bila i kappal a nagsiim ha ni Jesus nu baka atoy i pahusayan na, maski nu Sabado a maneg a pamalak. Ta kayat di a paliwatan hikuna. ");
INSERT INTO duo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Niyaen, kinagi ni Jesus ha iday a napilay, “Abeng, tumaknag ka bi ket umangay ha saguppang aye.” ");
INSERT INTO duo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sa na, kinagi ha dagenday a tolay, “Anya wade i nakam moy megipu ha Pamalak a Maneg? Anya i bagbagay a ipalobus na Linteg a gimetan tam? Mepalobus na i mappiya onu madukas? Magsalakan kitam mina ha totolay, onu kabengan tam mina hidi, maski nu matay?” kon ni Jesus. Ngem awan ha tinumabbeg ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ket naingal ni Jesus a nangaamata ha nidi. Ket nagsaket i nakam na, ta naigat unay i nakam di. Kinagi na ha iday a napilay, “Iyuyad mo bi i kamat mo,” kon na. Ket idi inyuyad na i kamat na, hinumusay hikuna. ");
INSERT INTO duo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ket linumapos ha kapilya idagenday a Pariseyo. Ket nakipaguhon hidi ha kappal a sakop ni Hari Herod, nu panyan di patayan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Linumakad di Jesus ken totolduwan na, ket inumangay hidi ha baybay. Inumunod bila i kakpalan a tolay. Naggipu hidi ha probinsiya a Galileya, ken Judeya, ken ili a Jerusalem, ken probinsiya a Idumeya, ken lugar ha dibelew na karayan Jordan, ken luglugar a Tiro ken Sidon. Ta nabaheta di i ginimet na. Isu, tinumagubet hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ket inpeta na ha tolduwan na a hidi, a igayak di mina i esa a abang a pagetnodan na. Ta makpal unay i totolay ha hay, ket baka masalditan di hikuna. ");
INSERT INTO duo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ta pinahusay dan ni Jesus i makpal a tolay. Ket gipu ta kona hito, pumipilit a bumikan ha nikuna i ngamin a kessaket, penu makamhit di hikuna. ");
INSERT INTO duo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ket ha maski nu heya a naawag na dimonyo, idi netan di ni Jesus, hinumakab hidi ha saguppang na, ket indulaw di, a “Hikaw i Annak na Dios!” kon di. ");
INSERT INTO duo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngem napigsa i pinagibon ni Jesus ha nidi a awan di mina ibaheta megipu ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tinumagdak ni Jesus ha amugod, ket inayagan na i kappal a tolduwan na. Ket inumangay hidi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ket pinili na i esa pulo ket duwa a pinanagenan na ha “Apostol.” I panggep na ha dagende a apostol, a maghen hidi ha nikuna, a paangayan na hidi nokkan a magibaheta ha Mappiya a Baheta. ");
INSERT INTO duo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ket inatdinan na hidi ha pinnakabalin di a magpalakad ha madukas a espiritu. ");
INSERT INTO duo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I nagen na apostol a hidi ni Simon, a insangay na ha “Pedro.” ");
INSERT INTO duo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ken di Santiyago ken Juan, a annak ni Sebedeyo. (Ket insangay na hidi ha “Boanerges”. Ket kayat na kagiyan, “Annak na Kaddur” onu, “Tolay a Sigisigida.”) ");
INSERT INTO duo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ken ni Andres, ken ni Pelipe ken ni Bartolome, ni Mateo ken ni Tomas, ken ni Santiyago a annak ni Alpeyo, ken ni Tadeo, ken ni Simon a matured, ");
INSERT INTO duo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ken ni Judas Iskaryote a nangliput ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Niyaen, nagsoli di Jesus ha bilay di. Ket dinumulog manon i makpal a tolay. Ket makpal unay hidi hanggan awan ha oras di Jesus a magkan, gipu ta matappag hidi. ");
INSERT INTO duo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ket idi nabaheta na ito na kabagiyan na, inumangay hidi penu alapan di hikuna. Ta atoy bi i kappal a nagkagi a, “Magmaoyung dan hikuna.” ");
INSERT INTO duo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ket atoy i kappal a maestro na Linteg a naggipu ha Jerusalem. Ket kinagi di, “Pinagawag dan hikuna ni Satanas. Ket mapalakad na i dimonyo a hidi, gipu ta ni Satanas i nangatad ha nikuna. Ta ni Satanas i happo na ngamin a dimonyo,” kon na maestro a hidi. ");
INSERT INTO duo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Isu, inayagan ni Jesus idagenday a tolay, ket inpeta na ha nidi ide a pangarig na. “Mabalin wade a palakadan ni Satanas i baggi na?” kon na. ");
INSERT INTO duo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ket intulos na, “Nu atoy i esa a bayan, ket makasina i kakaili na, a magnginayaw hidi, awan a mabalin a tumulos iday a bayan, ta nadadail dan. ");
INSERT INTO duo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ket kona bila hito ha maski nu anya a pamilya. Nu maglinaban i kamkameng na pamilya, nadadail iday a pamilya. ");
INSERT INTO duo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Isu, nu nasinasina i paghariyan ni Satanas, ket maglinaban i totolay na, awan hidi makatulos, ket nobos i paghariyan na. ");
INSERT INTO duo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ket niyaen, ipeta ko ha nikam,” kon ni Jesus, “Naabak ko dan ni Satanas. Ket ide i gipu na a mapalakad ko i dimonyo a hidi. Ta awan ha makasaddap ha bilay na napigsa ken magagew ha kukuwa na, nu awan a palungo a abakan na iday a napigsa. Sa hikuna, nawayawaya a magagew ha kukuwa na. ");
INSERT INTO duo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ket niyaen, sigurado ide a ipeta ko ha nikam. Mabalin a mapakawan i ngamin a liwat na totolay, ken ngamin a madukas a kakkagi di a paglimad di ha maski nu heya. ");
INSERT INTO duo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngem awan a mabalin a mapakawan i maglimad ha Espiritu ha Dios. Ta magnanayon a kelliwat iday a tolay, nu kona hay i kagi na megipu ha Espiritu na Dios.” ");
INSERT INTO duo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Inpeta ni Jesus ito, gipu ta atoy i kappal a nagkagi, a “Bakkan a Espiritu na Dios i naggipuwan na pinnakabalin ni Jesus, nu awan a ni Satanas,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Dinumemat i hena ken wawaddi a hidi ni Jesus. Ket naguray hidi ha lapos na bilay, ket pinaayag di hikuna. ");
INSERT INTO duo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ket atoy bila i makpal a nakaetnod ha lebut na. Ket kinagi di ha nikuna, “Atoy ha lapos i hena mo ken wadi mo a hidi. Ket paayagan di ka.” ");
INSERT INTO duo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ngem kinagi ni Jesus, “Oni, tahod. Ipeta moy a hidi i kabagiyan ko. Ngem ipeta ko ha nikam a atoy bila ha he i hena ken wawaddi ko.” ");
INSERT INTO duo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ket nangaamata hikuna ha nidi a nakaetnod ha lebut na. Ket kinagi na, “Entan moy ihe! Ta idagende i hena ken wawaddi ko. ");
INSERT INTO duo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ta maski nu heya a maggimet ha pagayatan na Dios, hidi i wawaddi ko ken hena ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Idi esa manon a pamalak, ket nagitoldu ni Jesus ha baybay na Galileya. Ket gipu ta makpal unay i tolay a dinumulog ha nikuna, inumangay hikuna a nagetnod ha esa a abang. Naghen ide a abang ha diget. Ket naghen i dinumulog a hidi ha baybay. ");
INSERT INTO duo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ket pangarig i inusar ni Jesus a magitoldu megipu ha makpal a bagay. Ket kinagi na ha nidi, a ");
INSERT INTO duo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Temanan moy bi! Ta atoy i esa a mannalon. Ket inumangay hikuna ha sikaw na a magmula. ");
INSERT INTO duo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Idi nagmula hikuna, netakneg i kappal a bin-i ha dilan. Ket tinumagmak i manok a hidi a kinan di idenday a bin-i. ");
INSERT INTO duo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Atoy bila i kappal a bin-i a netakneg ha kabituwan a ballik la i lutak na. Ket gipu ta madibbew iday a lutak na, nasigida a nagtubo idagenday a bin-i. ");
INSERT INTO duo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ngem idi nakahangkat i senggit, nalannas hidi ken napohpoh, ta awan hidi unay nakapagramot. ");
INSERT INTO duo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ket atoy bila i kappal a bin-i a netakneg ha kasesetan. Ket dinumakkal ken nagsalen i seset heya ha nagtubo a hidi. Isu, awan nakapagdawa idagenday a mula. ");
INSERT INTO duo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ngem atoy i kappal a bin-i a netakneg ha mappiya a lutak, ket nagtubo, ken dinumakkal ken nagdawa hidi. Ket ha kappal, nagdawa hidi ha tagtatallu a pulu. Ket ha kappal, nagdawa hidi ha tagannam a pulu. Ket ha kappal, nagdawa hidi ha tagesa a gasut a bukal ha kada esa a bin-i a nemula.” ");
INSERT INTO duo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ket inkabos ni Jesus i pangarig na a kinagi na, “Ha maski nu heya a makateman ha kakkagi ko, nanakaman na mina ito,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Niyaen, idi nagisesa ni Jesus, binumikan i kappal a nagteman, pati i esapulo ket duwa a tolduwan na. Ket nagsalodsod hidi megipu ha dagenday a pangarig na. ");
INSERT INTO duo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ket kinagi ni Jesus ha nidi, “Ipakatandi ko ha nikam idagende a inpamen na Dios megipu ha paghariyan na. Ngem ha sabali a tolay a madi a maguseg ha nikan, tatemanan di la i pangarig ko, ngem awan di makatandiyan. ");
INSERT INTO duo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ket gipu ta kona hito, matungpal dod i pinapugto na Dios ha ni Isayas. Ta insurat ni Isayas, ‘Maski nu makangenta hidi, awan di melasin. Ket maski nu makangteman hidi, awan di makatandiyan, amangan nu magbabawi hidi ha liwat di aye, ket pakawanan na hidi na Dios,’ kon na surat he.” ");
INSERT INTO duo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ket intulos ni Jesus, “Awan moy makatandiyan ide a pangarigan ko? Nu awan, panya dod i pakatandi moy ha sabasabali a pangarigan ko? ");
INSERT INTO duo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kona ha ide i kayat na kagiyan na pangarigan ko aye. I kakalan na bin-i i kagi na Dios. ");
INSERT INTO duo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ket i kakalan na dilan a nagdissuwan na bin-i, iday i totolay a nakateman ha kagi na Dios. Ngem sigida ni Satanas a tumagmak ken mangadya ha kakkagi a nateman di. ");
INSERT INTO duo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Ket ha sabali a hidi, magkalan hidi ha iday a kabituwan a lugar. Sigida hidi a magragsak a manggiwat ha kagi na Dios. ");
INSERT INTO duo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ngem awan a dumisalad i kagi na Dios ha nakam di. Ket awan hidi makaattam. Ta nu dumemat i rigrigat onu pagloloko gipu ha pinagteman di, ket masigida hidi a maupay. ");
INSERT INTO duo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ket atoy pala i kappal a tolay a kona ha kasesetan a lugar. Ket makateman hidi ha kagi na Dios, ");
INSERT INTO duo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ngem magburibur hidi megipu ha korinat ken pagragsakan di. Ket masalenan i kagi na Dios ha nakam di gipu ha ngamin a buribur di ken korsunada di, ken pinagseni di. Ket awan ha mappiya a gimetan di. ");
INSERT INTO duo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngem idenday a mappiya a lutak, iday i kakalan na magteman a hidi ha kagi na Dios, ket iyasak di ha nakam di, ket mappiya i keangayan na. Ket ha kappal, maggimet hidi ha ballik a mappiya. Ket ha kappal, maggimet hidi ha makpal a mappiya. Ket atoy bila i kappal a maggimet ha makpal unay a mappiya.” ");
INSERT INTO duo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ket intulos ni Jesus a kinagi na ha nidi, “Anya ha ugali tam? Pagangatan tam i silaw penu kalaban tam ha basket, ket penu itagmak tam ha sidung na katre? Awan agay. Ta pagangatan tam i silaw, penu metagmak ha lamesaan, penu masuluwan na i paghenan tam. ");
INSERT INTO duo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Niyaen, makatandiyan moy mina ide. Ta awan ha intago na Dios nu awan a panggep na a ipalapos na nokkan. Ket awan na salenan i pagkatandi na tolay nu awan penu lukatan na nokkan. ");
INSERT INTO duo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Isu, magteman mina perpermi i maski nu heya a makateman ha kakkagi ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ket kinagi na bila, a “Nanakaman moy mina i nateman moy. Ta nu tungpalan moy i kagi na Dios, gunggunaan na kam na Dios. Ket nayonan na pala i pagkatandi moy. ");
INSERT INTO duo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ta maski nu heya a manggiwat ha kagi na Dios, nayonan pala na Dios i pagkatandi na. Ngem ha maski nu heya a magpabiyan ha kagi na Dios, adyan na Dios ha nikuna i ballik a nakatandiyan na.” Ito i inpeta ni Jesus ha tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nagitoldu manon ni Jesus ha makpal a tolay. Ket kinagi na, “I paghariyan na Dios i kona ha esa a tolay a magmula ha bin-i ha talon na. ");
INSERT INTO duo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sa hikuna, kumilap ha kada kallap, ket umikat ha kada maledum. Ket ha bin-i a hidi, tumutubo pala hidi a dumadakkal hidi, maski nu awan na makatandiyan na tolay nu panyan na a dumakkal na mula a hidi. ");
INSERT INTO duo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Basta i lutak malla i mangpadakkal ken mangpabunga ha denday a mula. Ha palungo, tumubo iday a mula, sa magdon, sa magbunga dan. ");
INSERT INTO duo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ket nu matangkenan dan idenday a dawa, aniyan na nagmula, ta dinumemat dan i tiyempo na pinagapit na.” Ket kona bila hito ha paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ket kinagi ni Jesus, “Anya pala i kekalanan tam ha paghariyan na Dios? Ket anya mina i pangaregan ko ha kinadakkal na? ");
INSERT INTO duo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ikalan ko ito ha esa a bin-i a mustasa a kaballikan a bin-i ha ngamin a mulmula. ");
INSERT INTO duo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nu nemula ito, dumadakkal-dakkal hanggan dakkal unay, ket magbalin a kadakkalan ha ngamin a natnateng. Maski magtingi ha dakkal a tingi na hanggan magrabon i manok a hidi ha lendum na.” Kona hito i pangarigan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ket makpal pala i pangarigan ni Jesus, idi nagitoldu hikuna ha makpal a tolay. Ket inusar na idagende a pangarigan ayun ha kabaelan di a makatandiyan. ");
INSERT INTO duo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ket awan hikuna nagitoldu nu awan a gipu ha dagende a pangarigan. Ngem idi naghen hikuna ha bukod na a totolduwan, inpakatandi na i ngamin ha nidi. ");
INSERT INTO duo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Niyaen, idi apon dan ha iday a pamalak, kinagi ni Jesus ha agagum na, “Umahabes kitam dan ha dibelew,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Isu, linakadan di i kakpalan hay a tolay, ket linumugan hidi ha iday a abang a henan ni Jesus. Ket inumarabes hidi. Ket atoy bila i sabasabali a abang a nakikuyog. ");
INSERT INTO duo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ket bigu la a nagtaribunada ha mapigsa. Ket hinumoto i dadakkal a raknab a nangsabbulay ha abang di. ");
INSERT INTO duo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ngem kumakelap dalla ni Jesus a nagpungan ha dipos na abang. Ket linukag di hikuna, a kinagi di, “Maestro, awan mo kami pabiyanan! Umlad kitam dan!” kon di. ");
INSERT INTO duo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ket inumikat ni Jesus, ket binon na i paras. Ket nagkagiyan na i raknab a hidi, “Magtalna ka dan!” kon na. Ket tinumaran i paras, ket linuminnak i diget. ");
INSERT INTO duo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sa na, kinagi ni Jesus ha agum na a hidi, “Apay a manteng kam? Awan kam manahod ha nikan?” kon na. ");
INSERT INTO duo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ket naskal dalla hidi, ket nanteng ken nagsasinalodsod hidi, “Anya wade i lallaki aye? Ta maski i paras ken raknab, bonan na hidi. Ket magtongpal hidi ha nikuna,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tinumulos di Jesus a naglugan ha abang hanggan ha lugar a Gadareno, ha dibelew na Galileya. ");
INSERT INTO duo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Idi kahhapog di Jesus, sinumalpak i esa a lallaki a naggipu ha alingabngab a pahaglabbangan. Ket naawag dan ide a lallaki. ");
INSERT INTO duo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Awan hikuna maghen ha bilay na. Ta kanayon a maghen ha libalbang. Ket awan ha makakawar ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Naminmakpal a inkemot na totolay, ket ingakad di i kamat ken tikad na ha kawar. Ngem binagso-bagsot na i kawar heya. Ta mabinag hikuna unay, ket awan ha nakapataran ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ket kanayon hikuna a nagkalles ha naghenan na a libalbang ken amugod. Ket kanayon na a talingowan i baggi na ha pogedu. ");
INSERT INTO duo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Niyaen, ha ide a lallaki, idi naenta na ni Jesus ha madiyo, nagbuyot hikuna ket nagparentumeng ha saguppang na. ");
INSERT INTO duo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ket kinagi ni Jesus ha dimonyo a nagawag ha lallaki aye, “Nay, hikaw a dimonyo, lakadan mo ide a lallaki,” kon na. Ngem indulaw na dimonyo aye, “Jesus a Annak na Dios a Katurayan, anya i kayat mo ha nikan? Gipu ha kagbi na Apo Dios, awanak mo bi parigatan!” kon na dimonyo. ");
INSERT INTO duo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ket sinalodsod ni Jesus, “Heya i nagen mo?” Ket tinabbeg na, “Ni Kakpalan i nagen ko, gipu ta makpal kami,” kon na dimonyo aye. ");
INSERT INTO duo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ket nagpakagbi unay i dimonyo a hidi, a awan na hidi palakadan ha iday a lugar. ");
INSERT INTO duo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Niyaen, atoy bila hay i kakpalan a babboy, a magsabbok ha mabikan a kalebkeb. ");
INSERT INTO duo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ket inaged na dimonyo a hidi, “Palobusan mo kami a sumadap ha dagendo a babboy.” ");
INSERT INTO duo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Isu a pinalobusan na hidi ni Jesus. Ket linumapos hidi, ket sinumadap hidi ha duwa a ribu a babboy. Ket binumuyot idagende a babboy, a binumugsok, ket ginumutap hidi ha diget. Ket inumlad hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Idi naenta na mahagdapon ha babboy a hidi, binumuyot hidi ha ili ken taltalon, penu ibaheta di. Ket dinumemat i makpal a tolay, penu maenta di i nagimet. ");
INSERT INTO duo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Idi dinumemat hidi ha ni Jesus, naenta di i lallaki aye a linaposan na dimonyo a hidi. Ket inumetnod hikuna ha saguppang ni Jesus. Ket mappiya malla i nakam na. Ket natenonan hikuna. Ket gipu ha ide, naskal hidi. ");
INSERT INTO duo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ket inpakatandi na nakaenta a hidi nu panya a napahusay i lallaki aye, ken nu anya i nagimet ha babboy a hidi. ");
INSERT INTO duo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ket gipu ta kona hito, nagaged idagenday a tolay a umadiyo mina ni Jesus ha lugar di. ");
INSERT INTO duo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Niyaen, idi sinumadap di Jesus ha abang, perpermi i pinakiaged na lallaki a linakadan na dimonyo a hidi. Ket kayat na a umuseg ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngem awan a inpalobus ni Jesus. Kinagi na, “Sumoli ka ha bilay moy. Ket ipeta mo ha kabagiyan mo a hidi i mappiya a ginimet na Dios ha nikaw gipu ha kagbi na.” ");
INSERT INTO duo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ket linumakad dod ide a lallaki. Ket inbaheta na ha ngamin a lugar a Dekapolis i ginimet ni Jesus ha nikuna. Ket nalaktat hidi ngamin a nakabaheta. ");
INSERT INTO duo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Naglugan manon di Jesus a sinumoli ha dibelew. Ket dinulogan na hikuna na kakpalan a tolay ha baybay. ");
INSERT INTO duo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ket atoy i esa a lakay a nagen na, ni Hayro. Hikuna i mangituray ha esa a kapilya na Judyo a hidi. Idi naenta na ni Jesus, hinumakab hikuna ha saguppang na, ");
INSERT INTO duo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a nagaged ha nikuna. “Dandani a matay i gumitek a annak ko,” kon na. “Umuseg ka bi a itupu mo i kamat mo, penu humusay hikuna,” kon na lakay. ");
INSERT INTO duo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ket inumuseg ni Jesus. Ngem idi naglakad di Jesus, nakiuseg bila i kakpalan, ket dinumulog hidi ha palebut na. ");
INSERT INTO duo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Niyaen, atoy bila hay i esa a babbey a magsaket. Nagdigidigi dan i babbey aye ha esa pulo ket duwa a tawen. ");
INSERT INTO duo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ket maski nu makpal dan i nangagas ha nikuna, awan hikuna humusay, maski nu nobos i ngamin a pagbiyag na ha doktor a hidi. Awan hinumusay i baggi na, nu awan la a kinumaro i saket na. ");
INSERT INTO duo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Niyaen, nabaheta na megipu ha ni Jesus. Isu, nakitagubet hikuna ha dagenday a kakpalan, hanggan nakabikan hidi ha adag ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ta nagkagi hikuna ha nakam na, a “Maski nu tennon na la i makamhit ko, ket humusayak,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Isu, kinamhet na i kagay ni Jesus, ket dagus a tinumaran i pinagbolus na digi na. Ket nabati na a hinumusay dan i baggi na. ");
INSERT INTO duo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ket dagus a nabati ni Jesus i kaddat na a linumapos ha baggi na. Isu, sinoleg na i totolay ket sinalodsod na, “Heya i nangkamhit ha tennon ko?” ");
INSERT INTO duo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ket tinabbeg na tolduwan na a hidi, “Entan mo he, Apo. Ta masaldisaldit na kitam na kakpalan aye! Ket makpal hidi a mangsabeh ha nikaw! Apay dod a kona hay i salodsod mo,” kon ni Pedro. ");
INSERT INTO duo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ngem inbatabatad pala ni Jesus nu heya i nangkamhit ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Niyaen, idi nakatandiyan na babbey i nagimet ha baggi na, inumangay hikuna, ket hinumakab ha saguppang ni Jesus. Ket nagyagyag i baggi na, gipu ha kanteng na. Ket inpeta na i ngamin a tahod a nagimet ha baggi na. ");
INSERT INTO duo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ket kinagi ni Jesus ha nikuna, “Manay, mahusay ka gipu ta manahod ka ha nikan. Niyaen, makalakad ka a sitatalna. Awan magsoli ide a saket mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Niyaen, atoy pala hay ni Hayro, i lakay a mangituray ha kapilya. Ket idi nagkagi pala ni Jesus ha babbey aye, atoy i dinumemat a nagipu ha bilay di Hayro. Ket inpeta na ha nikuna, “Sumoli kitam mina ha bilay. Awan tam mina tappagan ni Maestro,” kon na. Ket nakatandi ni Hayro a natay dan i annak na. ");
INSERT INTO duo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngem nateman bila ni Jesus, ket inpeta na ha ni Hayro, “Awan kas magburibur. Manahod ka dalla ha nikan,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sa na, inpalobus ni Pedro ken ni Santiyago ken kabsat na a ni Juan a makikuyog hidi. Ket inkemot na i ngamin a sabali. ");
INSERT INTO duo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Idi kaddemat di ha bilay di Hayro, naenta ni Jesus i pinagsanget ken pinagngoyngoy na totolay ha disalad. ");
INSERT INTO duo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ngem idi sinumadap ni Jesus ha disalad, inpeta na ha nidi, “Apay a magsanget kam ken magngoyngoy? Awan a natay i gumitek aye. Nakakillap dalla hikuna,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ha nagngongoyngoy a hidi, nagkayagkayag hidi ha ni Jesus. Ta sigurado hidi a natay dan i annak. Ngem ha ni Jesus, pinalapos na hidi. Sa na, inayagan i nagenak a hidi ken tolduwan na a hidi, ket sinumadap hidi ha kuwarto a henan na gumitek. ");
INSERT INTO duo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ket inegkam na i kamat na annak. Ket kinagi na, “Talita kum!” (Kayat na a kagiyan, “Nening, umikat ka dan!”) ");
INSERT INTO duo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ket dagus a inumikat hikuna ket naglakalakad. (Ta sangapulo ket duwa i tawen na.) Ket nasbew hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ngem inbon ni Jesus a awan di ibaheta ha maski nu heya. Ket kinagi na bila, “Pakanan moy i gumitek aye,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Linumapos di Jesus ha iday a lugar. Ket nagsoli hidi ha ili na. ");
INSERT INTO duo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Idi esa a Sabado, inumangay manon hikuna a nangitoldu ha kapilya na Judyo a hidi. Ket atoy hay i makpal a tolay. Ket nalaktat hidi, idi nagteman hidi ha pagitoldu na. Ket nagsinalodsod hidi, “Hadya i nangalapan na ha kona he a sirib ken kaddat na a maggimigimet ha milagro? ");
INSERT INTO duo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Anya wade? Ta karpentero malla hikuna, a annak ni Maria ken kabsat di Santiyago, Jose, Judas ken Simon. Ket kaili tam bila i kakabsat na a babbey,” kon di. Ket gipu ta kona hito, awan hidi nanahod ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ket kinagi ni Jesus ha nidi, “Mapadeyawan i mahagpugto ha maski nu hadya a lugar, malaksid ha ili na a mismo, ken kabagiyan na ken pamilya na.” ");
INSERT INTO duo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ket awan a pulos ha nagimet na a milagro ha ili na aye, malaksid i pinangpahusay na ha kappal a nagsaket. Ta atoy la i kappal a nanahod ha nikuna, ket intupo na i kamat na ha nidi a pinahusay na hidi. ");
INSERT INTO duo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ket nalaktat unay hikuna, ta awan nanahod i kaili na a hidi. Niyaen, linakad ni Jesus i bariyo a hidi, a nagitoldu hikuna ha totolay. ");
INSERT INTO duo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Idi esa a pamalak, inayagan na i esa pulo ket duwa a tolduwan na. Ket pinalakad na hidi a tagduduwa idi neyatad na i kaddat ken turay di a pagpalakad di ha maski nu anya a kalase na espiritu. ");
INSERT INTO duo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ket inbon na ha nidi, “Awan moy bilonan i aruwatan moy, maski nu supot, onu kanan, onu korinat. Sarukod la i ikuyog moy. ");
INSERT INTO duo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ket magsapatos kam, ngem awan moy bilonan i kagay a pagsuletan moy. ");
INSERT INTO duo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Ha maski nu hadya a pagrespitaran di ha nikam, magtulos kam ha iday a bilay hanggan lumakad kam manon. ");
INSERT INTO duo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ket ha maski nu hadya a awan hidi magrespitar ha nikam, a awan hidi magteman ha nikam, lumapos kam ha iday a lugar. Ket nu lumapos kam, tipladan moy hidi. Ket kona ha ide, a papagpagan moy i tikad moy ha tapok, penu makatandiyan di a nagliwat hidi, ta madiyan di i kakkagi na Dios.” Ide i inbon ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Isu, inumangay i tolduwan na a hidi. Ket nagibaheta hidi a masapul a magbabawi i totolay ha liwaliwat di. ");
INSERT INTO duo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ket pinalakad di i makpal a dimonyo. Ket pinuhetan di ha langis i makpal a nagsaket, ket pinahusay di hidi. ");
INSERT INTO duo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Niyaen, nabahetaan ni Hari Herod, ta nebaheta i nagen ni Jesus ha ngamin a lugar. Ket kinagi na kappal a minabiyag manon ni Juan a Mahagbinyag. Ket hikuna kan ni Jesus. Ket iday kan i gipu na a atoy ha nikuna i pinnakabalin na. ");
INSERT INTO duo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ket kinagi na kappal, a nagsoli ni Eliyas a nagipu ha langit. Ta hikuna i esa a minahagpugto, idi nikuna a naalay dan. Ket atoy i kappal, ket kinagi di a ni Jesus i tahod a mahagpugto, a kona ha minahagpugto a hidi nikuna a naalay dan. ");
INSERT INTO duo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngem idi nabahetaan ni Herod i ginimigimet ni Jesus, kinagi na, “Minabiyag manon ni Juan a pinaputol ko.” ");
INSERT INTO duo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kona hito i kinagi ni Herod, ta hikuna i nangpadakkap ken nangpabalud ha ni Juan a Mahagbinyag. Ket ginimet na ito idi nagkagiyan ni Juan ni Herod a, “Nagliwat ka, ta nagkabanga ka dan ha ipag mo!” Ket kinagi ni Juan ito, ta nakikabanga di Herod ken Herodiyas, i kabanga ni Pelipe. Ket ni Pelipe i wadi ni Herod. Isu, pinarusa ni Herod ni Juan, gipu ha ni Herodiyas. ");
INSERT INTO duo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ta nagsaket unay i nakam ni Herodiyas ha ni Juan, ket kinayat na a mapapatay, ngem awan na kaya. ");
INSERT INTO duo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ta kantengan ni Hari Herod ni Juan. Ta katandi na i kinalinteg ken kinappiya na. Isu, inkemot ni Herod ni Juan ha ni Herodiyas. Ket kayat ni Herod a magteman ha ni Juan. Maski nu nariribuk i nakam na megipu ha nateman na, kayat na pala a magteman ha ni Juan. ");
INSERT INTO duo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Niyaen, dinumemat i gundaway ni Herodiyas idi nagsilebra di Herod ha pinakeenak na. Ket sinangaili ni Herod i magtuturay a hidi ha gobyerno. Inawis na i opisiyales ken sundalu a hidi ken matangkay a totolay na Galileya. ");
INSERT INTO duo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Niyaen, atoy bi i madiket a annak ni Herodiyas. Ket hikuna i sinumadap a nagsala ha saguppang di. Ket naayagan ni Herod ken sangaili na a hidi. Ket ide i gipu na a kinagi ni Hari Herod ha madiket aye, “Agedan mo i maski nu anya a kayat mo, ket iyatad ko ha nikaw!” ");
INSERT INTO duo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ket inkari na bila, “Iyatad ko i maski nu anya a agedan mo, maski nu kagudwa na paghariyan ko,” kon ni Hari Herod. ");
INSERT INTO duo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ket linumapos i madiket, ket sinalodsod na ha nena na, “Anya i agedan ko?” Ket kinagi nena na, “Agedan mo i buntok ni Juan a Mahagbinyag!” ");
INSERT INTO duo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ket nagsigida i madiket a nagsoli ha ni Hari Herod, ket nagaged, a kinagi na, “Iyatad mo ha yenan i buntok ni Juan a Mahagbinyag, ket nedatton ha bandehado,” kon na madiket. ");
INSERT INTO duo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Niyaen, naladingit unay ni Hari Herod. Ngem awan a mabalin a magbabawi, ta inkari na ha saguppang na ngamin a sangaili na, ket masaniki hikuna. ");
INSERT INTO duo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Isu, binon na a dagus i esa a sundalu a umangay a mangalap ha buntok ni Juan. Inumangay dod i sundalu ha pagbaludan, ket pinutolan na ni Juan. ");
INSERT INTO duo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sa na, inyangay i buntok na a nedatton ha bandehado, ket ingiwat na ha madiket a nangigiwat bila ha nena na. ");
INSERT INTO duo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Idi nabaheta na tolduwan a hidi ni Juan, inumangay hidi, ket nangalap ha bangkay na, ket inlabbang di. ");
INSERT INTO duo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Niyaen, ha dagenday a apostol a pinaangay ni Jesus, nagsoli dan hidi. Ket inbaheta di ha nikuna i ngamin a ginimet ken intoldu di ha totolay. ");
INSERT INTO duo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Niyaen, atoy i makpal a tolay a umaangay ha di Jesus ha kada pamalak, ket atoy bi i makpal a lumalakad ha kada pamalak. Ket gipu ta kona hito, awan ha waya di Jesus, maski nu kayat di a magkan. Isu, kinagi ni Jesus ha apostol na a hidi, “Sumina kitam a magisesa ha madiyo a lugar, penu makaemmang kam.” ");
INSERT INTO duo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ket nagisesa hidi a naglugan ha abang hanggan ha lugar a awan ha tolay. ");
INSERT INTO duo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ngem makpal i nakaenta ken nakatandi ha pinaglakad di. Ket nagtagidilan hidi a nagpalungo a naggipu ha ngamin a il-ili ha lebut na. ");
INSERT INTO duo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Isu, idi kappundu ni Jesus ha baybay, naenta na i kakpalan a tolay. Ket kinagbiyan na hidi, ta kasasaad di a kona ha karkarnero a awan ha mangdapon ha nidi. Isu, nagitoldu hikuna ha nidi, ket makpal i intoldu na. ");
INSERT INTO duo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Idi dandani a lumiksup i senggit, binumikan i tolduwan na a hidi, ket kinagi di, “Maestro, apon dan. Ket ide a lugar a awan ha bilabilay. ");
INSERT INTO duo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Palakadan mo bi idagende a tolay. Umangay mina hidi ha barbaryo, a gatangan di mina i kanan di.” ");
INSERT INTO duo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngem kinagi ni Jesus, “Hikam mina i mangiyatad ha kanan di.” Sa di, sinalodsod, “Panyan mina? Maggastos i suweldo ha walo a bulan. Kayat mo dud a lumakad kami, a maggatang ha kanan a ipakan mi ha nidi?” ");
INSERT INTO duo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ket kinagi ni Jesus, “Atoy i hangan a tinapay moy? Entan moy bi.” Inumangay hidi a nangenta. Ket tinabbeg di, “Atoy lima a tinapay ken duwa a pindang,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Sa na, pinagetnod i ngamin a tolay ha karuotan. Ket pinagpisan na hidi ha sagsangagasut ken ha taglima a pulo. ");
INSERT INTO duo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sa, inalap ni Jesus idagenday a lima a tinapay ken duwa a pindang. Ket tinumangad hikuna ha langit a nagyaman ha Dios. Ket pinilakpilak na i tinapay, sa na, inyatad ha apostol a hidi, a iwaras di. Ket kona bila hito ha pindang heya. ");
INSERT INTO duo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ket nagkan hidi ngamin. Ket nabbiyag hidi. ");
INSERT INTO duo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Idi nabbiyag dan hidi ngamin, pinuhon di i sobra. Ket pinutat di i esa pulo ket duwa a basket ha tinapay ken pindang a buhay di. ");
INSERT INTO duo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Niyaen, atoy manga lima a ribu a lallaki a nagkan ha dagenday a kanan. (Ket atoy bila i kabanga di ken annak di.) ");
INSERT INTO duo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Idi pinangpalakad ni Jesus ha dagende a tolay, pinalugan na i tolduwan na a hidi ha esa a abang. Ket pinapalungo na hidi a humapog ha diget a umangay ha ili a Betsayda. ");
INSERT INTO duo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sa, idi nagpakada hikuna ha dagenday a tolay, tinumagdak ni Jesus ha amugod, penu magkararag. ");
INSERT INTO duo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Niyaen, idi kallap dan, atoy pala i tolduwan na a hidi ha abang, ha lubuk na diget. Ket nagesesa pala ni Jesus ha disat. ");
INSERT INTO duo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ket naenta na a marigatan hidi a maggaud, ta napigsa i paras. Idi awan pala pumasag, tinumagubet ni Jesus a naglakad ha dibbew na diget penu kamakaman na hidi. ");
INSERT INTO duo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ngem idi naenta di i naglakad ha dibbew na diget, nanteng hidi ngamin, ket nagdulaw hidi. Ta kagin di a hikuna i esa a anito. Ngem dagus a kinagi ni Jesus, “Awan kam manteng. Hikan ni Jesus.” ");
INSERT INTO duo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ket nakilugan ni Jesus ha nidi. Sa, naggimet i paras. Ket nasbew hidi unay. ");
INSERT INTO duo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ta awan di nakatandiyan i pinnakabalin ni Jesus, maski nu naenta di i pinangpakan na ha lima a ribu a lallaki ha lima la a tinapay. Ket nadiham pala i nakam di. ");
INSERT INTO duo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Idi kaahabes di, pinumundu hidi ha lugar a Genesaret. ");
INSERT INTO duo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Idi kaawas di, atoy i totolay, ket dagus di nelassin ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Isu, nagbuyot hidi ha ngamin a lugar di, ha ngamin a bilay a paghenan na saket a hidi. Ket nagissew hidi a intugan di i nagsaket a hidi ha maski nu hadya a nabaheta di a henan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Maski nu hadya a nagangayan na, maski ha purok a hidi, onu baryo a hidi, o maski ha taltalon, intugan na totolay i nagsaket a hidi ha nagpisanan na totolay. Ket permi i pinakiaged di ha ni Jesus, a palobusan na mina i magsaket a hidi a mangkamhit ha maski nibik na kagay na. Ket tahod a nahusay hidi ngamin a nangkamhit ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Niyaen, atoy manon i Pariseyo a hidi ken mamaestro na Linteg a naggipu ha Jerusalem. Ket pinumisan manon hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ket naenta di i tolduwan a hidi ni Jesus, a awan di inugisan i kamat di ha palungo na pagkan di. Ket maneg ito ha panahod na Pariseyo a hidi ken kakpalan na Judyo. ");
INSERT INTO duo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ta umusoseg hidi ha ugali a inpatawid na minappo di. Ket awan hidi magkan nu awan a palungo a maguges hidi ha kamat di. ");
INSERT INTO duo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ta manahod hidi a maneg i maski nu anya a nekagi na sabali a tolay a kelliwat. Ket nealis i liwat na, kon na kan. Isu, awan hidi magkan ha maski nu anya a naggipu ha tiyendaan, nu awan a palungo a ugesan di, pati i baggi di, penu maadya i liwaliwat na. Ket makpal pala i ugali a inpatawid na minappo di, a kona ha pinanguges ha tasa, banga, ken aruwatan di, penu maadya i liwaliwat a naghen kan ha lapos na. ");
INSERT INTO duo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Isu, gipu ta kona hito, sinalodsod na Pariseyo a hidi ken maestro a hidi na Linteg, “Apay a awan tungpalan na toltolduwan mo i pagitoldu a inpatawid na minappo tam? Ta awan hidi maguges a magkan. Ket kelliwat dod hidi.” ");
INSERT INTO duo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ngem kinagi ni Jesus, “Tahod i kagi na Dios megipu ha nikam a aginpappiya. Ta pinasurat na Dios ni Isayas nikuna, a nepugto na, a ‘Deydeyawan na ak na totolay aye, kon di. Ngem madiyo pala i nakam di ha nikan. ");
INSERT INTO duo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Awan ha serbe na pinagdeydeyaw di ha nikan, maski nu ipeta di a Dios i paggipuwan na pagitoldu di. Ngem bakkan a Hikan nu awan la a totolay i paggipuwan na pagitoldu di,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ket intulos ni Jesus, “Apay a umusoseg kam ha pinagitoldu na minappo moy, ngem talekodan moy i bobon na Dios? ");
INSERT INTO duo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Apay a malaing kam a magtalekod ha bobon na Dios? Tahod a talekodan moy ito penu makatongpal kam ha bukod moy a pagitoldu. ");
INSERT INTO duo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Halimbawa: nesurat ni Moyses ide a bon na Dios, a ‘Deyawan mo i hama ken hena mo,’ ken ‘Maski nu heya a magkagi ha madukas ha hama na onu hena na, masapul a mapapatay hikuna,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngem ha nikam, bakkan i pagitoldu moy. Ta itoldu moy a mabalin a mekemot i korinat a pangdaggap moy mina ha hama ken hena moy. Ipeta moy, a ‘Korban ide a korinat,’ (ket kayat na kagiyan, ‘Neyatad dan ha Dios.’) ");
INSERT INTO duo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sa, hikam a Pariseyo i magsalen ha mangiyatad a hidi ha daddakkal di. ");
INSERT INTO duo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Isu, tumatalekod kam ha kagi na Dios gipu ha bukod moy a pagitoldu. Ket ipatawid moy i pagitoldu moy aye ha tolduwan moy a hidi. Ket makpal pala a gimetan moy a kona hito,” kon ni Jesus ha Pariseyo ken maestro a hidi na Linteg. ");
INSERT INTO duo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ket ayagan manon ni Jesus i totolay, a pinapisan na manon hidi. Ket kinagi na ha nidi, “Magteman kam ngamin ha kakkagi ko aye, ket makatandiyan moy mina. ");
INSERT INTO duo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bakkan a metelmok i makapadukas ha baggi na tolay, nu awan a dumukas i baggi na gipu ha pagkagi na a lumalapos ha labi na, ken madukas a nakam na. ");
INSERT INTO duo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ha nikam a makateman, temanan moy mina.” ");
INSERT INTO duo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Idi nagpakada ni Jesus ha dagenday a kakpalan, ket sinumadap dan hikuna ha disalad na bilay, sinalodsod na tolduwan na a hidi megipu ha kinagi na. ");
INSERT INTO duo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ket tinabbeg ni Jesus, “Maski ha nikam, awan moy makatandiyan? Katandi moy mina a awan makapadukas i measak ha labi na tolay. ");
INSERT INTO duo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ta awan ito sumadap ha nakam na, nu awan la ha tiyan na. Sa, lumapos manon,” kon ni Jesus. Ket gipu ha ide a pinagitoldu ni Jesus, inpakatandi na a awan ha kanan a maneg. Ket mappiya i ngamin a kalase na kanan. ");
INSERT INTO duo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ket intoldu na pala, “I tahod a magpadukas ha baggi na tolay i madukas a pagkagi na a lumalapos ha labi na, ken madukas a nakam na. ");
INSERT INTO duo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gipu ha nakam na tolay i paggipuwan na kinadukas na tolay. Kona ha pangibabbey di, onu pangilallaki, ken pagtakaw di ken pagbuno di, i paggundaway di ha sabali a kabanga, ");
INSERT INTO duo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","i pangimon di, ken ngamin a kalase na kinadukas. Maski kona ha pagsileng di onu pagloko di ha kakalan di a tolay. Maski pagseni di onu pagulew di onu pagpangas di ken kinadagel di. ");
INSERT INTO duo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Maggipu ha nakam na tolay i ngamin a dagento a madukas. Ket idagento i magpadukas ha baggi na totolay,” kon ni Jesus ha pagitoldu na. ");
INSERT INTO duo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Niyaen, linumakad manon ni Jesus ha iday a lugar, ket inumangay hikuna ha lugar a Tiro. Hinumuyot hikuna ha esa a bilay ha nalimid, penu awan mina ha makatandi ha pagemmangan na. Ngem awan a mabalin a netago hikuna, ta nelassin na hikuna na tolay a hidi. ");
INSERT INTO duo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Niyaen, atoy i esa a babbey a bakkan a Judyo. Griega hikuna, a neenakan ha Penisiya, ha probinsiya a Siriya. Ket keannak hikuna ha babbey. Ket naawag dan na madukas a espiritu i annak na aye. Idi nabaheta na i pagsangpit ni Jesus, inumangay hikuna a nagparentumeng ha tikad ni Jesus. Ket nagpakagbi ha ni Jesus a palakadan na mina i dimonyo a nangpaawag ha annak na. ");
INSERT INTO duo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ngem kinagi ni Jesus, “Ha palungo, magkan mina i annak a hidi hanggan mabbyag dan. Ta madi nu alapan ko i kanan na annak, a itogbak ko ha asasu.” ");
INSERT INTO duo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ket nakatandiyan na babbey i kinagi na, a masapul a daggapan ni Jesus i Judyo a hidi ha palungo na bakkan a Judyo. Isu, kinagi na, “Tahod i kagi mo, Apo. Isu, mabalin bi a magkan i asu a hidi ha regreg na annak,” kon na babbey. ");
INSERT INTO duo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ket kinagi ni Jesus, “Mappiya i tabbeg mo. Ket gipu ha ide a tabbeg mo, makasoli ka dan ha bilay moy a matalna. Ta linumakad dan i dimonyo ha annak mo!” ");
INSERT INTO duo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ket sinumoli ide a babbey, ket naabot na i annak na a kumakelap ha katre. Ta tahod a linumakad dan i dimonyo. ");
INSERT INTO duo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Niyaen, linumakad manon ni Jesus ha lugar a Tiro, ket tinumulos ha Sidon ken Dekapolis, hanggan dinumemat hikuna ha Diget na Galileya. ");
INSERT INTO duo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ket atoy hay i esa a lallaki a nagbangag ken nahamel, ket netugan na hikuna na agagum na ha ni Jesus. Inaged di a itupu na i kamat na ha ide a nagbangag, penu humusay mina. ");
INSERT INTO duo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ket inyadiyo ni Jesus ide a lallaki ha kakpalan a hidi. Ket intolnak na i toldu na ha talinga na lallaki aye. Sa na, inloktab, ket inpuhet na i loktab na aye ha dila na lallaki. ");
INSERT INTO duo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sa, tinangad ni Jesus i langit, ket nagsennaay hikuna. Ket kinagi na ha kakkagi na lallaki aye, “Eppata!”. Ket kayat na a kagiyan, “Maglukat i talinga mo!”. ");
INSERT INTO duo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ket dagus a nakateman ken nakakagi i lallaki aye. Ket nagbalikas hikuna. ");
INSERT INTO duo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sa, inbon ni Jesus ha ngamin a dagenday a tolay a awan di mina ibaheta ha maski nu heya i nagimet aye. Ngem maski nu nakaro i pinagibon na ha nidi, kumaro paman i pinagibaheta di. ");
INSERT INTO duo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ket nalaktat unay i ngamin a nakabaheta ha ide a nagimet, a kinagi di, “Mappiya i ngamin a gimigimet na. Maski pakateman na manon i magbangag a hidi ken pagbalikasan na i nahamel a hidi.” ");
INSERT INTO duo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Idi tiyempo ito, atoy manon i kakpalan a tolay a dinumulog ha ni Jesus. Idi nobos i pagkanan di, inayagan ni Jesus i tolduwan na a hidi. Ket kinagi na ha nidi, ");
INSERT INTO duo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Makagbiyak ha dagende a tolay. Ta naghen hidi ha tallu a pamalak ha henan tam aye. Ket niyaen, awan ha kanan di. ");
INSERT INTO duo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nu palakadan ko hidi, ket magiyalap pala, makapoy unay hidi ha dilan. Ket atoy bi i kappal a naggipu ha madiyo.” ");
INSERT INTO duo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ket tinabbeg na tolduwan na a hidi, “Hadya i pangalapan tam ha ipakan tam ha nidi, ta awan ha bilabilay ha lugar aye?” ");
INSERT INTO duo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ket sinalodsod ni Jesus, “Atoy hangan a tinapay moy?” Ket kinagi di, “Pitu.” ");
INSERT INTO duo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Niyaen, inbon ni Jesus ha dagende a tolay a umetnod hidi ha lutak. Ket inalap na iday a pitu a tinapay, ket nagyaman hikuna ha Dios. Kobosan na, tinaptappeng na i tinapay, ket inyatad na ha tolduwan na a hidi, penu ibunong di ha dagende a kakpalan a tolay. Ket tinongpal di ito. ");
INSERT INTO duo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ket atoy bila i kappal a baballik a padut. Ket nagyaman ni Jesus ha Dios gipu ha dagende. Sa na, inyatad bila ha tolduwan na a hidi penu ibunong di ha dagende a kakpalan. ");
INSERT INTO duo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ket nagkan hidi ngamin hanggan nabbiyag hidi. Manga uppat a ribu hidi a nagkan. Kobosan na, naurnong i nabuhay a kanan. Ket naputat i pitu a basket ha nabuhay. ");
INSERT INTO duo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Niyaen, pinaglakad ni Jesus idagende a kakpalan a tolay. Ket dagus a linumugan ni Jesus ken tolduwan na a hidi ha abang. Ket inumangay hidi ha lugar a Dalmanuta. ");
INSERT INTO duo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Niyaen, inumangay ha ni Jesus i kappal a Pariseyo, ket nakipagtabbeg hidi ha nikuna. Ta kayat di a magsurbar ha nikuna. Isu, inpeta di a usaran na mina i kaddat na a pangpaenta na a tahod a pinaangay na hikuna na Dios. ");
INSERT INTO duo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ket nagsennaay ni Jesus, gipu ha madaggi a nakam na. Ket kinagi na, “Apay? Apay a magpilit kam a ipaenta ko mina i kaddat ko a pangpatahod. Ipeta ko a pulos a awan ha pangpatahod a mepaenta ha nikam,” kon ni Jesus ha Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sa na, linakadan hidi. Ket naglugan manon di Jesus ha abang a umarabes ha diget. ");
INSERT INTO duo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Niyaen, naleptanan na tolduwan na a hidi i bilon di. Atoy la i esa a momon na tinapay ha abang di. ");
INSERT INTO duo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ket iniwadan ni Jesus ha nidi, a kinagi na, “Magingat kam ha lebadura na Pariseyo a hidi ken lebadura ni Herod,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ket nakipaguhon hidi nu anya i kayat na kagiyan. Ket nagkinagi hidi a, “Awan kitam ha tinapay. Isu i gipu na a kinagi na iday,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ket katandi ni Jesus i pinaguhon di. Isu a kinagi na, “Apay a paguhonan moy a awan kam ha tinapay? Awan moy dod makatandiyan? Maigat wade i nakam moy? ");
INSERT INTO duo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Atoy kam ha mata, ngem awan moy wade melassin i pagkagiyan ko. Atoy kam ha talinga, ngem awan moy wade makateman ha kayat ko ipeta. Awan moy dod manakam ");
INSERT INTO duo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","idi tinaptappeng ko i lima a tinapay, ket kinan na lima a ribu a lallaki? Ket hangan a basket i nabuhay a naurnong moy?” Ket intabbeg na tolduwan na a hidi, “Esa a pulo ket duwa.” ");
INSERT INTO duo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ket sinalodsod ni Jesus, “Idi tinaptappeng ko i pitu a tinapay a kinan na uppat a ribu a lallaki, hangan a basket i nabuhay a naurnong moy?” Ket intabbeg na tolduwan a hidi, “Pitu.” ");
INSERT INTO duo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ket kinagi ni Jesus, “Niyaen, makatandiyan moy mina a bakkan a tinapay i nagkagiyan ko, nu awan i pinagitoldu na Pariseyo a hidi. Ket umaales i kinadukas di ha totolay a kona bila ha lebadura a umaales a magpabigal ha tinapay.” ");
INSERT INTO duo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Niyaen, dinumemat hidi ha ili a Betsayda. Ket atoy i neyangay ha ni Jesus a nabulsak a lallaki. Ket inaged di ha ni Jesus a itupu na i kamat na ha nabulsak aye. ");
INSERT INTO duo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ket kinabitan ni Jesus i nabulsak aye, ket inturong na ha lapos na baryo. Sa na, linoktaban i mata na, ket kinamhet na. Ket kinagi na, “Anya? Atoy i maenta mo?” ");
INSERT INTO duo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ket inwaras na lallaki i pinagenta na. Sa na, kinagi, “Oni, makaenta ak ha totolay, ngem madiham pala, a kona ha kaykayo a maglakad,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ket kinamhet manon ni Jesus i mata na lallaki. Ket nagbulag i lallaki, ket nahusay i mata na a hidi, a madinnang i pinagenta na. ");
INSERT INTO duo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ket pinasoli hikuna ni Jesus ha bilay na, a inbon ni Jesus, “Magdiretso ka dan ha bilay moy. Awan ka magsoli ha ide a baryo a magibaheta.” ");
INSERT INTO duo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Niyaen, inumangay di Jesus ha bariobario na Sesareya-Pilipo. Idi pinaglakad di, sinalodsod ni Jesus ha tolduwan na a hidi, “Anya i nakam na tolay megipu ha nikan? Heya ak wade ha pagkagi di?” ");
INSERT INTO duo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ket tinabbeg di, “Kinagi na kappal a hikaw kan ni Juan a Minahagbinyag, ket minagbiyag manon. Ket kinagi na kappal a hikaw kan ni Eliyas, a nagsoli a nagipu ha langit. Ket kinagi na kappal a hikaw i esa a minahagpugto a minagbiyag manon, kon di kan.” ");
INSERT INTO duo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ket sinalodsod ni Jesus, “Hikam bi, anya ha nakam moy? Heya ak wade ha nakam moy?” Ket tinabbeg ni Pedro, “Hikaw i Cristu, i lallaki a pinaangay na Dios a maghari ha ngamin a tolay.” ");
INSERT INTO duo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ket inbon ni Jesus a awan di mina ipeta ha maski nu heya a tolay a hikuna i Cristu. ");
INSERT INTO duo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nangrugi ni Jesus ha pinagitoldu na megipu ha baggi na ha toltolduwan na. Ket inpakatandi na a atoy nokkan, ha kasaguppangan, i makpal a rigrigat a masapul na a attaman. Kinagi na, “Nokkan, umadi hidi ha nikan, hidi a mangituray ha kapilya, ken matangkay a papadi, ken hidi a maestro na linteg. Ket papatayan di ak nokkan. Ket nu malpas i tallu a pamalak, magbiyagak manon.” Ito i nepugto ni Jesus megipu ha baggi na. ");
INSERT INTO duo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ket madinnang i pinagpakatandi na ha nidi. Ket ha ni Pedro, inyadiyo na ha ballik ni Jesus, a kayat na a tabbegan. Ket inbalakad na ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngem sinolegan ni Jesus i tolduwan na a hidi. Ket inenglan na ni Pedro a kinagi na, “Umadiyo ka ha nikan. Ta magkagi ka ha kagi ni Satanas. Awan mo nakaman i pagayatan na Dios, nu awan la i pagayatan na tolay,” kon ni Jesus ha ni Pedro. ");
INSERT INTO duo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sa na, inayagan i kakpalan a tolay ken tolduwan na a hidi. Ket kinagi na, “Ha maski nu heya a mayat a magpasakop ha nikan, masapul a ibilang na i baggi na a kona ha natay, penu bakkan mina i pagayatan na i gimetan na nu awan i pagayatan ko. Ket nu kona hito, attaman na i rigrigat, penu umunod ha nikan. Ket kona nu baklayan na i kudos na ha pinaguseg na ha nikan. ");
INSERT INTO duo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta maski nu heya a mayat a mangisalakan ha baggi na, hikuna i matay nokkan talaga. Ngem maski nu heya a mangiyatad ha biyag na ha Dios, gipu ha nikan ken Baheta na Dios, maski nu matay i baggi na, isalakan na Dios i biyag na. Ket awan hikuna matay manon. ");
INSERT INTO duo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ta kona paman ha ide,” kagi ni Jesus, “nu atoy i makaalap ha ngamin a baknang na lutak aye, awan ha balle na iday nu lompas i biyag na, ket awan na mapadasan i biyag na Dios a magnanayon. ");
INSERT INTO duo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ta awan ha baknang a pangsaka na tolay ha bukod na a biyag. ");
INSERT INTO duo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ket ha maski nu heya a masaniki a manahod ha nikan, ket masaniki a magtongpal ha pagitoldu ko, ket nu pabiyanan na ak niyaen, a usogan na i madukas a hidi a tumatalekod ha Dios, pabiyanan ko bila hikuna nokkan, ha kasoli ko a magipu ha langit. Ket ha kasoli ko nokkan, mepaenta i kainamakan ko ken kainamakan na Dios, i hama ko, ken kainamakan na anghel a hidi,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ket kinagi ni Jesus, “Niyaen, ipeta ko ha nikam, a atoy ha nikitam ihe i kappal a awan matay, hanggan awan di maenta i kinapigsa na Dios ha pinaghari na.” ");
INSERT INTO duo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kobosan na annam a pamalak, inkuyog ni Jesus ni Pedro, ni Juan, ken ni Santiyago ket tinumagdak hidi ha matangkay a parabin. Pagsangpit di, ket nagbigu i itsura ni Jesus ha saguppang di. ");
INSERT INTO duo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Naging maponset i tennon na, a naghiyamhiyam ken nagranyag. Awan ha ide a lutak i kinaponset a kona hay. ");
INSERT INTO duo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Niyaen, nagpaenta ni Moyses ken ni Eliyas, a nakiuhon hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ket kinagi ni Pedro ha ni Jesus, “Maestro, mappiya, ta atoy kami ihe. Magtoklong kami mina ha tallu. Esa para ha nikaw, esa para ha ni Moyses, ken esa para ha ni Eliyas,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Maliwaliwat i nakam di Pedro. Ket awan na nakatandiyan i kinagi na, ta nanteng hidi unay.) ");
INSERT INTO duo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sa, nagpaenta i esa a ulap a nanglendum ha nidi. Ket atoy i esa a timek a naggipu ha ulap aye. Kinagi na, “Ide i Annak ko a ayayatan ko unay. Temanan moy hikuna!” kon na. ");
INSERT INTO duo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ket bigu la a nangenta hidi ha lebut di, ngem awan ha naenta di nu awan la ni Jesus a esesa. ");
INSERT INTO duo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Idi bumubugsok hidi ha parabin aye, binon ni Jesus di Pedro, Juan ken Santiyago. Kinagi na, “Awan moy pala ipeta ha maski nu heya i naenta moy aye. Imbes na, ipeta moy nokkan nu kobosan na pinagbiyag ko manon a maggipu ha natay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Isu a awan ha inpeta di, maski nagsinalodsod hidi nu anya i kayat a kagiyan ni Jesus, a magbiyag manon hikuna a maggipu ha natay. ");
INSERT INTO duo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ket kinagi di ha ni Jesus, “Inpeta mo a matay ka ket magbiyag manon nokkan. Ngem ha pagitoldu na maestro a hidi na Linteg, ipeta di a masapul a sumoli ni Elias a magpalungo ha pagdemat na Cristu.” ");
INSERT INTO duo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ket tinabbeg ni Jesus, “Tahod i kinagi na maestro a hidi na Linteg. Ta palungo, umangay ni Elias, penu pagayakan na i ngamin. Ket niyaen, isalodsod ko bi ha nikam: Apay a nesurat ha Libro na Dios a masapul a magattamak ha makpal a rigrigat, ket talekodan na ak na totolay? ");
INSERT INTO duo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngem maski, ta ipeta ko ha nikam a inumangay dan ni Elias. Ket linoko di hikuna, a ginimet di ha nikuna i ngamin a kinaykayat di. Ket pinatay di a kona ha nepugto ha Libro na Dios.” (Kinagi ni Jesus ito megipu ha ni Juan a Minahagbinyag.) ");
INSERT INTO duo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Niyaen, pagsoli di Jesus ken tallu a kinakuyog na. Dinumemat hidi ha henan na nawarak a tolduwan na a hidi. Ket naenta di a atoy i kakpalan a tolay a naglelebut. Ket atoy bi i kappal a maestro na Linteg a nakipagtabbegan ha toltolduwan na heya. ");
INSERT INTO duo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Idi naenta na totolay ni Jesus, nalaktat unay hidi. Sa hidi, nagbuyot a makisalpak ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ket sinalodsod ni Jesus, “Anya i pakitabbegan moy?” ");
INSERT INTO duo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ket nagkagi i esa a lallaki, “Maestro, intugan ko i annak ko ha nikaw. Ta atoy i dimonyo a magpabulol ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ket nu paawagan na i annak ko aye, ipatakneg na i annak ko, a magyagyag hanggan maghabhab i labi na. Ket pagngaretngaretan na i ngipan na ken paigatan na i ngamin a baggi na. Niyaen, inaged ko ha agagum mo a palakadan di mina, ngem awan di kaya,” kon na lallaki. ");
INSERT INTO duo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ket kinagi ni Jesus, “Ay, idagende a tolay a awan ha panahod. Naalayak dan ha nikam, ket naalay dan i pinaganus ko ha nikam, ngem madiyan moy la a manahod ha nikan!” Ket intulos na, “Iyangay mo he i annak mo.” ");
INSERT INTO duo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Inyangay di dod i annak. Ket idi naenta na dimonyo ni Jesus, pinakissew na i annak. Ket natakneg i annak, a nagkubag-kubag, ket naghabhab i labi na. ");
INSERT INTO duo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nagsalodsod ni Jesus ha hama na annak, “Hangan kaalay i pinagawag na dimonyo ha annak mo a kona he?” Ket tinabbeg nama na, “Nangrugi idi annak pala,” kon na hama. ");
INSERT INTO duo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Ket makpal a beses i pinagpataknag na dimonyo ha gangatan onu ha dinom, ta kayat na hikuna a patayan. Ngem niyaen, Apo, kagbiyan mo kami. Ket daggapan mo kami, nu kabaelan mo.” ");
INSERT INTO duo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ket kinagi ni Jesus, “Apay a kagi mo, ‘Nu kabaelan mo,’ kommo. Ipeta ko ha nikaw a magimet na Dios i maski nu anya para ha manahod a hidi ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ket dagus a indulaw na hama, a kinagi na, “Apo, manahodak dan! Ngem nayonan mo bi i pagkurangan na panahod ko!” ");
INSERT INTO duo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Idi naenta ni Jesus a dumulug ha henan na i kakpalan a tolay, binon na i dimonyo, a kinagi na, “Hikaw a dimonyo a magpabangag ken magpabulol, lumakad ka ha baggi na annak aye. Ket awan ka sumoli ha nikuna!” ");
INSERT INTO duo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ket nagkales i dimonyo. Ket pinagkissew na i annak. Sa na, linakadan i baggi na aye. Ket kona ha bangkay i itsura na. Isu a kinagi na tolay a hidi a minatay dan hikuna. ");
INSERT INTO duo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngem inegkaman ni Jesus i kamat na a pinaikat na hikuna. Ket tinumaknag i annak heya. ");
INSERT INTO duo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Niyaen, idi atoy la di Jesus a sinumadap ha bilay, sinalodsod na tolduwan na a hidi, “Apay a awan ha kabaelan mi a magpalakad ha iday a dimonyo?” ");
INSERT INTO duo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ket tinabbeg ni Jesus, “Ha kasasaad a kona he, awan kam ha kabaelan nu awan kam magkararag ha Dios.” ");
INSERT INTO duo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Linakadan di Jesus iday a lugar, ket linumakad hidi ha nalimed ha Galileya. Madiyan ni Jesus nu makatandiyan na totolay i henan na, ");
INSERT INTO duo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","gipu ta panggep na a mangitoldu ha tolduwan na a hidi. Inpeta na ha nidi, “Ha nikan a Annak na Dios a Nagbalin a Tolay, dandaniyak dan a madakap. Ket igiwat di ak ha kasenti ko a hidi. Ket patayan di ak. Ngem magbiyagak manon ha mekatallu a pamalak,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ngem awan na ito nakatandiyan na tolduwan na a hidi. Ket masaniki hidi a magsalodsod nu anya i kayat na a kagiyan. ");
INSERT INTO duo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dinumemat hidi ha ili a Kapernaum. Ket idi sinumadap hidi ha bilay, sinalodsod ni Jesus nu anya i nagtabbegan di ha dilan. ");
INSERT INTO duo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngem masaniki hidi a magkagi, ta nagtabbegan di nu heya ha nidi i mas matangkay. ");
INSERT INTO duo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Isu, inumetnod ni Jesus. Ket inayagan na idagende a esa pulo ket duwa a tolduwan na. Sana, kinagi ha nidi, “Ha maski nu heya a mayat a magpatangkay ha baggi na ha agagum na, masapul a magpadibbi ha baggi na a magserbe ha kakalan na a tolay.” ");
INSERT INTO duo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sana, inalap ni Jesus i esa a annak, ket pinataknag na hikuna ha saguppang di. Ket ginakos na. ");
INSERT INTO duo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Kinagi na, “Kona ha ide i tolay a manahod ha nikan. Ta maanus ken masaniki. Ket ipeta ko ha nikam, a maski nu heya a magrespitar gipu ha panahod na ha nikan, a kona nu respitaran na i annak aye, mebilang a respitaran na ak bila. Ket nu respitaran na ak, respitaran na i Dios bila a nagpaangay ha nikan. Ket kona ihe mina i pinagpadibbi moy ha baggi moy,” kon ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ket kinagi ni Juan, “Maestro, naenta mi i esa a lallaki a nangpalakad ha dimonyo a hidi. Ta nanahod dan hikuna, kon na kan. Ket atoy kan ha nikuna i turay ken kaddat ni Jesus, kon na kan. Ket inusar na i nagen mo. Ngem awan pala hikuna nagpasakop ha grupo tam aye. Isu, pinagimak mi hikuna,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngem tinabbeg ni Jesus ha di Juan, “Awan moy mina pagimakan i tolay a kona hay. Ta maski nu heya a magusar ha nagen ko, a maggimet ha nakaddatan, awan hikuna makasenti ha nikan ha sigida. ");
INSERT INTO duo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ket maski nu heya a awan magsenti ha nikitam, magdaggap hikuna ha nikitam,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Ket nakaman moy ide,” intulos na, “a maski nu heya a mangiyatad ha nikam ha maski esa a baso a dinom, gipu ta sakop kam ni Cristu, gunggunaan na hikuna na Dios.” ");
INSERT INTO duo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Intulos ni Jesus, “Ngem nu atoy i magpasina ha maski madibbi a hidi ha bon na Dios, parusaan na hikuna na Dios. Ket mas marigat i parusa na Dios ha nikuna ngem nu megakad mina i dakkal a pogedu ha tangad na, ket metogbak mina hikuna ha diget. Ta marigat unay i parusa na Dios ha tolay a kona hay. ");
INSERT INTO duo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ket ipeta ko ha nikam, nu atoy i pakegipuwan na pinagliwat moy, adiyowan moy dan, a kona ha katolan moy. Halimbawa, nu atoy i kona ha kamat moy a pakegipuwan na pinagliwat moy, adiyowan moy dan. Ta mas mappiya nu makasaddap kam ha paghenan na Apo Dios, maski kona ha mapikot kam, basta awan kam sumadap ha impyerno ket mapigsa pala, a kona ha kekkamat kam a duwa. Ket marigatan kam hay ha gangatan a awan maaddap. ");
INSERT INTO duo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ket nu atoy i kona ha tikad moy a pakegipuwan na pinagliwat moy, adiyowan moy mina. Ta mas mappiya nu makasaddap kam ha paghenan na Apo Dios, maski kona ha pilay kam, basta awan kam metogbak ha impyerno, a pagparusaan na baggi moy ken duwa a tikad moy. ");
INSERT INTO duo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ket kona bila hito ha pinagaamata moy. Nu atoy i kona ha mata moy a pakegipuwan na pinagliwat moy, kona ha suatan moy mina. Ta mas mappiya nu makasaddap kam ha Paghariyan na Dios, maski kona ha bulding kam, basta awan kam metogbak ha impyerno ket malaing pala a magaamata. ");
INSERT INTO duo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ta paghenan na iday na uhad a hidi a awan matay. Ket awan maaddap i gangatan ihay. ");
INSERT INTO duo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tahod a marigat ide a kinagi ko. Ta maski nu heya a mayat a magpasakop ha Dios, masapul a magattam hikuna ha rigrigat a kona ha nedatton ha Dios. Ket ha ngamin a medatton ha Dios, mapaasen ken matenneb hidi ha gangatan. ");
INSERT INTO duo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Niyaen, mappiya i gimetan na Dios a kona ha pangpaasen na ha nikam penu masinggat i panahod moy. Ngem nu lompas ide a kinaasen moy, awan kam ha serserbe. Isu, tumulos kam mina a kona ha maasenan, a kona ha masinggat i gimetan moy. Awan kam makipagtabbegan nu heya i mas matangkay ha nikam, nu awan a makipagkappiya kam.” ");
INSERT INTO duo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Linumakad manon di Jesus, a tinumulos hidi ha Judeya ken dibelew na Karayan Jordan. Ket dinumulog manon i kakpalan a tolay. Ket gipu ha ugali na, tinolduwan na hidi. ");
INSERT INTO duo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ket atoy bila i Pariseyo a hidi a inumangay penu surubaran di ni Jesus. Sinalodsod di, “Ipeta mo bi: Ipalobus na Linteg a isina na lallaki i kabanga na?” ");
INSERT INTO duo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ket sinalodsod bila ni Jesus, “Anya i inbon ni Moyses megipu ha iday?” ");
INSERT INTO duo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kinagi na Pariseyo a hidi, “Inpalubos ni Moyses. Ngem masapul na kan na lallaki a mangisurat ha pangpaenta ha pinagsina di, sana, mapalakad i kabanga na.” ");
INSERT INTO duo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ket kinagi ni Jesus ha nidi, “Inpalubos ni Moyses iday gipu ha kinaigat na nakam moy. Ket para ha nikam la iday. ");
INSERT INTO duo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ngem idi palungo, idi pinarsuwa na Dios i lutak aye, pinarsuwa na Dios i tolay a lallaki ken babbey. ");
INSERT INTO duo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ket kinagi na Dios, a ‘Gipu ta kona hito, lakadan mina na lallaki i nagenanak ha nikuna, ket makiagum hikuna ha kabanga na. ");
INSERT INTO duo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ket magbalin hidi a esesa,’ kon na Dios. Isu, awan hidi a duwa, nu awan a esesa dalla hidi. ");
INSERT INTO duo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Niyaen, awan mina a pasinaan na tolay i pinagagum na Dios. Ito i kayat ko ipeta ha nikam,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Idi kasoli di Jesus ha bilay di, inpenduwa na tolduwan na a hidi ide a salodsod megipu ha pinagsina na magkabanga. ");
INSERT INTO duo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ket kinagi ni Jesus ha nidi, “I lallaki a mangisina ha kabanga na, sa, mangabanga ha sabali, makaliwat hikuna ha pinangibabbey na. Ket liniwatan na i palungo a kabanga na. ");
INSERT INTO duo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ket kona bila hito ha babbey a mangisina ha kabanga na, sa mangabanga manon ha sabali a lallaki. Ta madi bila i pinangilallaki na, a liniwatan na i palungo a kabanga na.” ");
INSERT INTO duo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Idi esa a pamalak, atoy i kappal a nangiyangay ha annak di ha ni Jesus, penu itupu na i kamat na, a kagbiyan na mina hidi na Dios. Ngem binahang na totolduwan ni Jesus i nangiyangay a hidi ha annak di. ");
INSERT INTO duo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ket idi netan ni Jesus, nagingal hikuna, a kinagi na ha dagenday a agagum na, “Palobusan moy a umangay i annak a hidi ha nikan. Awan moy hidi salenan. Ta magkalan hidi ha totolay a sumasaddap ha paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Inaamakan man i pinagtalak di. Ket kona bila hito i kayat na Dios ha totolay a sakopan na. Tamos. Ket ipeta ko ha nikam, a maski nu heya a bakkan i panahod di, awan hidi makasaddap ha paghariyan na Dios,” kon ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sana, inalap i annak a hidi, a kinalkal na hidi. Ket intupo na i kamat na ha nidi, a kagbiyan na mina hidi na Dios. ");
INSERT INTO duo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Idi nagrubrubuwat ni Jesus a lumakad ha iday a lugar, binumuyot i esa a lallaki a nagparentumeng ha saguppang na. Sinalodsod na, “Mappiya a Maestro, mappiya i gimetan mo. Isu, ipeta mo nu anya mina i gimetan ko, penu maghenak ha Dios ha magnanayon?” ");
INSERT INTO duo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ket sinalodsod ni Jesus, “Apay a managenanak mo ha ‘Mappiya?’ Dios la i ‘Mappiya’. Awan ha ‘Mappiya’ nu awan la i Dios. Ket anya mina i gimetan mo, penu maghen ka ha Dios ha magnanayon? Iday i kayat mo a makatandiyan? ");
INSERT INTO duo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Katandiyan mo dan i bon na Dios a insurat ni Moyses, a awan ka magbuno, awan ka mangibabbey, awan ka magtakaw, awan ka magsileng, awan ka magswitik. Ket deyawan mo i hama ken hena mo. Idagende i bon na Dios ha nikaw,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ket kinagi na lallaki aye, “Maestro, tinungtungpal ko dan i ngamin a dagenday, nangrugi idi kaballik ko,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ket idi inaamatan na hikuna ni Jesus, inayat na. Ket kinagi ni Jesus, “Kulang ka pala ha esa a gimetan mo. Ilako mos i ngamin a aruwatan mo. Ket iyatad mo i korinat ha napobre a hidi. Ket nu gimetan mo ide, mabaknang ka nokkan ha langit. Ket esa pala, a umunod ka dan ha nikan.” kon ni Jesus ha lallaki aye. ");
INSERT INTO duo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngem idi nateman na ito na lallaki, nagladingit hikuna unay. Ket linumakad hikuna a silaladingit. Ta mabaknang hikuna gamen. ");
INSERT INTO duo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ket sinumoleg ni Jesus ha lebut na, a kinagi na ha tolduwan na a hidi, “Magrigat a sumadap ha paghariyan na Dios idagenday a nabaknang,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ket naglaktat i agagum ni Jesus ha kinagi na aye. Ngem intulos ni Jesus a nagkagi manon, “Wadwaddi ko, marigat gamen ha maski nu heya a sumadap ha Paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas malaka a meturok i makadakklan ha abot na dagum, ngem makasaddap i mabaknang ha paghariyan na Dios.” ");
INSERT INTO duo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ket nalaktat hidi, a naliwaliwat i nakam di. Isu a kinagi di, “Apo, nu kona hito, heya dod i mesalakan nokkan? Pulos wade a awan a maghen ha Dios ha magnanayon!” kon di. ");
INSERT INTO duo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ket inaamatan na hidi ni Jesus, a kinagi na, “Tamos. Awan ha makesalakan ha baggi na. Ngem maski nu anya a awan a mabalin ha tolay, mabalin iday ha Dios. Ta magimet na Dios i maski nu anya.” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ket kinagi ni Pedro, “Apo, katandiyan mo a intirak mi i ngamin a kukwa mi, penu umunod kami ha nikaw,” kon na. ");
INSERT INTO duo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ket kinagi ni Jesus, “Tahod ide a ipeta ko ha nikam, a maski nu heya a magayat ha Dios ha dakdakkal ngem ha ngamin a kukwa na, maghen hikuna ha Dios ha magnanayon. Ket nu matirak na i bilay na ken lutak na, i patakka na onu hama na ken hena na, onu annak na, penu magserbe ha paghariyan na Dios, tahod a atdinan na hikuna na Dios ha mas makpal ha niyaen a tiyempo. Maski iyatad na Dios ha nikuna i nasursurok. Ket gumiwat hikuna ha mas makpal a bilay ken patakka ken nagenanak ken annak ken lutak. Ngem katandiyan moy mina ide: a mapadas na bila i pinagloloko na totolay, gipu ha panahod na ha nikan. Ngem nokkan paman, ha tiyempo a dumemat, ket maghen hikuna ha Dios ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ngem atoy i makpal a matangkay, ket mapadibbi hidi nokkan. Ket ha makpal a madibbi a hidi, hidi man i matangkay nokkan.” Ito i inkari ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Niyaen, magpajerusalem di Jesus, ket nagpalopalungo ni Jesus ha tolduwan na a hidi. Nasbew idagende a tolduwan na, ket nanteng i ngamin a agagum di a umunonud. Ta makpal i kasenti ni Jesus ha Jerusalem. Niyaen, inyadiyo manon ni Jesus i tolduwan na a hidi. Ket inpakatandi na i magimet nokkan ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kinagi na, “Katandiyan moy mina ide. Umangay kitam ha Jerusalem. Ket nu dumitang kitam nokkan, megiwat i Annak na Dios a Nagbalin a Tolay ha matangkay a hidi a padi ken maestro a hidi na linteg. Ket hukoman di ak, a ipapatay di ak, a igiwat di ak ha dagenday a bakkan a Judyo. ");
INSERT INTO duo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ket ha dagenday a bakkan a Judyo, kayagan di ak, ken loktaban di ak, ken sabdan di, sa di ak patayan. Ket kobosan na tallu a pamalak, magbiyagak manon.” ");
INSERT INTO duo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Niyaen, ha di Santiyago ken Juan a annak ni Sebedeyo, inumangay hidi ha ni Jesus. Ket kinagi di, “Maestro, atoy i kayat mi a agedan ha nikaw.” ");
INSERT INTO duo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ket kinagi ni Jesus, “Anya i kayat moy?” ");
INSERT INTO duo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ket kinagi di, “Apo, ipalobus mo a nokkan nu maghari ka, ket hikami bila i makipagturay ha nikaw. Ket esa a makikaetnod ha kanawan mo, ken esa ha kannigid mo,” inaged di Santiyago. ");
INSERT INTO duo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngem tinabbeg ni Jesus, “Awan moy makatandiyan i agedan moy. Kaya moy dod a attaman i rigrigat a attaman ko nokkan? Mabinyaganak nokkan ha pagbinyag na rigrigat. Kaya moy dod a magtongpal ha pagayatan na Dios ken magattam ha rigrigat, maski hanggan matay kam, a kona nikan?” ");
INSERT INTO duo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ket tinabbeg di Santiyago, “Oni. Kaya mi dan.” Ket kinagi ni Jesus, “Tahod a marigatan kam bila nokkan, a kona ha nikan. Ket matay kam bila gipu ha panahod moy ha nikan. ");
INSERT INTO duo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngem bakkan a hikan i mangpili ha agum ko a maghari onu umetnod ha kanawan ken kanigid ko. I Hama ko la i makatandi ha denday. Ta hikuna i naggayak ha pagtuturay ha paghariyan ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Idi nabaheta na sangapulo a agagum di, nakaingal hidi ha ni Santiyago ken ni Juan gipu ha inaged di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Isu, inayagan ni Jesus idagende a sangapulo ket duwa. Ket kinagi na, “Katandiyan moy i ugali na magtuturay ha lutak aye. Ket madaggi i pinangibon di ha totolay, a kona ha taraken di. ");
INSERT INTO duo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngem bakkan ha nikam, a awan mina a kona hito. Ta maski nu heya a magturay ha nikam, masapul a magpadibbi hikuna ha baggi na, a magserbe ha agagum na. ");
INSERT INTO duo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Oni ah. Ta maski nu heya a maging matangkay ha nikam, masapul na a padibbiyan i baggi na a magdaggap ha nikam ngamin. ");
INSERT INTO duo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ta kona bila hito ha nikan a Annak na Dios a Nagbalin a Tolay. Awanak inumangay penu daggapan na ak na totolay, nu awan penu daggapan ko hidi. Ket ide i gipu na a iyatad ko i biyag ko a pangsaka ha makpal a totolay.” ");
INSERT INTO duo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pagdemat di ha ili a Jeriko. Ket idi linakadan di manon, inumuseg bila i kakpalan a tolay. Ket atoy bila i esa a bulsak a nakaetnod ha hikeg na karsada. Nagpapalimos hikuna. Bartimeyo i nagen na, a annak ni Timeyo. ");
INSERT INTO duo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ket idi nabaheta na a tumataleb ihay ni Jesus a taga Nasaret, nagayag hikuna, a kinagi na, “Jesus, apo ni Dabid, kagbiyanak mo bi!” kon na. ");
INSERT INTO duo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ket nagbahang ha nikuna i makpal, a inbon di a awan mina hikuna magkagi. Ngem impigsa na i pagayag na. “Jesus, apo ni Dabid, kagbiyanak mo bi!” kon na. ");
INSERT INTO duo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ket tinumaran ni Jesus, a kinagi na, “Ayagan moy hikuna.” Inayagan di dod i nabulsek aye, a kinagi di, “Nay, magragsak ka mina, ta paayagan na ka.” ");
INSERT INTO duo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ket nagsigida hikuna a inumikat, ket inadya na i ulas na, a inumangay hikuna ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ket sinalodsod ni Jesus, “Anya i kayat mo a gimetan ko ha nikaw?” Ket kinagi na nabulsak, “Apo, kayat ko a makaenta manon.” ");
INSERT INTO duo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ket kinagi ni Jesus, “Oni! Lumakad ka dan. Nakahusay ka gipu ha panahod mo ha nikan.” Ket dagus a nakahusay i nabulsak aye. Ket inumunod hikuna ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Idi binumikan hidi ha ili a Betpeg ken Betani, ha amugod a Olibet, nakabikan dan hidi ha Jerusalem. Ket inbon na i duwa a agum na, a ");
INSERT INTO duo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Umangay kam ha baryo ha kalipat. Atoy ha ho i kabayo a urbon a awan pala nasaksakayan. Nu dumitang kam ha baryo ayo, lakbisan moy iday a kabayo, ket lagedan moy, a iyangay ha he. ");
INSERT INTO duo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nu atoy i magsalodsod ha nikam nu apay a lakbisan moy ide a urbon, ipeta moy, ‘Masapul ni Apo ide, ket pasoliyan na a dagus,’ kon moy.” ");
INSERT INTO duo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Isu, inumangay ide a duwa a agagum ni Jesus. Ket tahod a naenta di i urbon ha kalsada, a negakad ha ruwangan na esa a bilay. Ket linakbes di dod ito. ");
INSERT INTO duo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ket atoy bila hay i nakataknag a hidi a nagsalodsod ha, “Apay a lakbisan moy iday a urbon?” ");
INSERT INTO duo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ket inpeta na agagum ni Jesus i kinagi na. Isu, pinalobusan na hidi na totolay aye. ");
INSERT INTO duo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ket intugan di i urbon ha ni Jesus. Sa di, pinalayat i tennon di ha adag na, ket nagsakay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ket makpal i nangiyabak ha tennon di ha dilan. Ket atoy paman i kappal a nagkatol ha dodon ha taltalon, ket indatton di ha dilan. (Ta kona ihe i pangdeyaw di ha hari.) ");
INSERT INTO duo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ket magkalan i nagpalungo a hidi ha ni Jesus ken hidi a inumunod, a induludulaw di, a “Madeydeyaw i Dios! Deyawan tam i pinaangay na Dios a maghari! ");
INSERT INTO duo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Papigsaan na Dios i paghariyan na, a kasulet ni minappo tam a Hari Dabid! Deyawan tam i Dios a katangkayan!” kon di. ");
INSERT INTO duo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ket dinumemat ni Jesus ha Jerusalem. Ket sinumadap hikuna ha Templo. Ket idi inamatan na i ngamin hay, linumapos hikuna, a nagsoli hidi ha Betaniya, ta apon dan. Ket kaagum na i esapulo ket duwa a tolduwan na. ");
INSERT INTO duo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Idi kaugman na, nagsoli di Jesus ha Jerusalem a naggipu ha Betaniya. Ket magiyalap ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ket naenta na ha madiyo i esa a kayo a igos. Ket makpal unay i dodon na. Isu, inumangay ni Jesus a mangenta nu atoy i bunga na, ta magbunga mina i igos, basta atoy i dodon na. Ngem idi pagsangpit na, pasig la dodon i naeriyokan na, ta awan pala a tiyempo na pinagbubunga na igos. ");
INSERT INTO duo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ket kinagi ni Jesus, “Gipu ha yenan, awan ka manon magbunga!” Ket nateman na tolduwan na a hidi i kinagi na aye. ");
INSERT INTO duo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Niyaen, kaddemat di ha Jerusalem, ket sinumadap manon ni Jesus ha Templo. Ket binugaw na i mahaglako a hidi ken naggatang a hidi ha paraangan na Templo. Ket binaliktad na idagenday a lamesaan na mahagsulet ha korinat. Ket kona bila hito ha dagenday a pagetnodan na maglaklako ha kalapati a hidi. ");
INSERT INTO duo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ket sinalenan na i maski nu heya a kekkarga a lumakad ha paraangan na Templo. ");
INSERT INTO duo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sana, intoldu, a kinagi na, “Ide i nesurat ha libro na Dios: ‘I bilay ko aye i bilay a pagkararagan, ket para ha maski nu heya ha ngamin a lutak,’ kon na Dios. Ngem insulet moy dan ha paghenan na mahagtakaw,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Niyaen, nabaheta na matangkay a papadi ken maestro a hidi na Linteg. Ket sinumeni hidi ha nikuna, gipu ta minalaktat i kakpalan a tolay ha turay na a magitoldu. Ket atoy i makpal a nanahod ha nikuna. Isu a nageriyok hidi ha gundaway di a magpapatay ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Idi kallap, linumapos di Jesus ha ili. ");
INSERT INTO duo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kaugman na, ket maglakad manon di Jesus ha dilan. Ket naenta di i kayo a igos. Ngem niyaen, nalannas ito hanggan ha ramot na. ");
INSERT INTO duo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nanakam ni Pedro i kinagi ni Jesus ha ide a kayo. Ket kinagi na, “Maestro, entan mo ihay. Minalanas dan iday a kayo a inlunod mo nakapon!” ");
INSERT INTO duo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Ket kinagi ni Jesus, “Nakaman moy ide a ipeta ko ha nikam. Ta basta nu Dios i tahodan moy, ken awan ha duwaduwa ha nakam moy, ket mabalin moy a bonan i maski nu anya a magsalen ha nikam, ket mealis iday a salen. Basta manahod kam a gimetan na Dios i inpeta mo, ket tahod a gimetan na Dios para ha nikam. ");
INSERT INTO duo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Isu, ipeta ko ha nikam, a maski nu anya a agedan moy ha Dios, tahodan moy a ingiwat na dan, ket maalap moy iday a inaged moy. ");
INSERT INTO duo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ket ha pagkararag moy, masapul moy a pakawanan i maski nu heya a nakaliwat ha nikam, penu pakawanan na kam bila Nama moy ha langit. ");
INSERT INTO duo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ta nu awan moy pakawanan i kakalan moy a tolay, awan na kam bila pakawanan na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Niyaen, sumadap manon di Jesus ha Jerusalem. Ket idi paglakad ni Jesus ha paraangan na Templo, inumangay ha nikuna i matangkay a papadi, ken mamaestro na linteg, ken panglakayan a hidi na Judyo. ");
INSERT INTO duo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ket kinagi di ha nikuna, “Anya i kalintegan mo a manggimet ha dagende a bagay? Heya i nangiyatad ha nikaw ha turay a manggimet ha kona he?” kon di. ");
INSERT INTO duo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ket kinagi ni Jesus, “Ha palungo, palobusanak moy bi a magsalodsod ha nikam. Nu matabbeganak moy, ipeta ko bila ha nikam nu heya i nangiyatad ha turay ko a maggimet ha dagende. ");
INSERT INTO duo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Niyaen, ipeta moy bi nu hadya i nagipuwan na turay ni Juan a magbinyag. Anya ha nakam moy? Nagipu ha Dios, onu nagipu la ha sabali a tolay?” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ket naginuhon hidi nu anya mina i tabbeg di. “Nu ipeta tam a nagipu ha Dios i turay ni Juan, metabbeg ni Jesus, a ‘Apay dod, awan kam nanahod ha ni Juan?’ ");
INSERT INTO duo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngem delikadu nu ipeta tam a nagipu ha sabali la a tolay.” Kinagi di ito, ta nanteng hidi ha kakpalan ihay a tolay. Ta manahod i kakpalan a hidi a minahagpugto talaga ni Juan. ");
INSERT INTO duo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Isu, tinabbeg di ni Jesus, “Awan mi makatandiyan nu hadya i nagipuwan na turay ni Juan a magbinyag.” Ket tinabbeg ni Jesus, “Gipu ta awanak moy tinabbegan, awan ta kam bila tabbegan nu anya i turay ko a maggimet ha dagende a bagay.” ");
INSERT INTO duo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ket tinumulos ni Jesus a nagestoriya ha nidi. “Nikuna, atoy i esa a lakay, ket minulaan na i lutak na ha unas. Sana, inaladan i kaunasan na aye, ket ginimet na i pagpespesan ha unas, ket pinataknag na i torre a paghenan na guwardya a hidi. Kobosan na, inpaabang na i kaunasan ha makitalon a hidi. Sa hikuna, linumakad ha sabali a bayan. ");
INSERT INTO duo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Idi dinumemat i tiyempo na pinagkatol ha unas, pinaangay na i esa a tagabu a mangalap mina ha bunong na. ");
INSERT INTO duo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngem i makitalon a hidi, nagdanog hidi ha tagabu aye. Ket pinalakad di hikuna, a awan nakaalap. ");
INSERT INTO duo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ket pinaangay na manon i sabali a tagabu na. Ngem tinalingo di i buntok na. Sadi, pinasanikiyan. ");
INSERT INTO duo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ket pinaangay na lakay i nekatallu a tagabu. Ngem pinatay di hikuna. Ket kona bila hito ha makpal a tagabu na lakay. Ha kappal, dinanog di hidi, ken kappal a pinatay di. ");
INSERT INTO duo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Niyaen, ha dilokod na, atoy la i esa a annak na a lallaki. Ket hikuna i ayayatan na unay. Isu, kobosan na ngamin, pinaangay na lakay i bukod na a annak. Ket kinagi na ha nakam na, ‘Siguradowak a respitaran di i annak ko!’ kon ni Lakay. ");
INSERT INTO duo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ngem idi naenta na makitalon a hidi, naginuhon hidi, ‘Ide dan i mangalap ha lutak ni Lakay! Patayan tam mina hikuna, penu hikitam mina i magalap ha lutak na aye,’ kon di. ");
INSERT INTO duo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ket dinakap di dod, ket pinatay di, ket intogbak di i bangkay na ha lapos na kaunasan aye. ");
INSERT INTO duo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Niyaen,” intulos ni Jesus, “anya i nakam moy? Anya wade i gimetan na lakay a makinlutak? Siyempre, ah? Dumemat hikuna nokkan, ket patayan na i makitalon a hidi. Sa na, iyatad iday a lutak ha sabali a totolay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Niyaen, anya dod i kayat ko kagiyan ha pangaregan ko aye? Sigurado a nabasa moy ide a paset na Libro na Dios. Ket makatandiyan moy mina ide, a ‘Nagayak dan i esa a inaamakan a pugedu, para ha bilay. Ngem madiyan di a usaran na tarabahador a hidi. Ngem maski nu kona hito, medatton paman ide a pugedu ha suli na bilay a pangadigi ha ngamin a bilay. ");
INSERT INTO duo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ket Apo Dios i nanggimet ha ide, ket mappiya unay ide ha nikitam.’” ");
INSERT INTO duo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Niyaen, kayat na matangkay a hidi a Judyo a padakap di ni Jesus. Ta nakatandiyan di a hidi man i nagmadi ha Annak na Dios a kona ha inaamakan a pogedu heya, a ginayak na Dios para ha bilay na. Ngem nanteng hidi ha kakpalan hay a tolay. Isu a pinabiyan di ni Jesus, a linumakad dalla hidi. ");
INSERT INTO duo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kobosan na ito, pinaangay na dagende a Judyo i kappal a Pariseyo ken kappal a ilay ni Hari Herod. Ket kayat di a masiluwan ni Jesus ha salodsod di. ");
INSERT INTO duo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Isu, inumangay hidi, ket kinagi di, “Maestro, katandiyan mi a tahod i pagitoldu mo. Ket katandiyan mi a magitoldu ka ha tahod megipu ha pagayatan na Dios. Ket katandiyan mi bila a awan ha idumduma mo, maski matangkay onu madibbi. Niyaen, ide i salodsod mi ha nikaw: Anya, makaliwat kitam ha Linteg tam a Judyo, onu awan, nu magpaga kitam ha buwis ha Hari na Roma?” ");
INSERT INTO duo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngem nakatandiyan ni Jesus a maginsisingpit hidi. Isu, kinagi na, “Apay a kayat moyak a surubaran? Iyangay moy he i korinat a kakkagiyan moy, penu entan ko.” ");
INSERT INTO duo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ket inyangay di dod, ket kinagi ni Jesus ha nidi, “Ipeta moy nu heya i ladawan ha ide a korinat, ken heya i nagen a nesurat ha ihe?” kon ni Jesus. “Iday i Hari na Roma,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ket tinumulos ni Jesus, “Isu, iyatad moy ha Hari na Roma idagenday a kukuwa na, idagenday a bagay a atoy i rupa ken nagen na. Ket iyatad moy mina ha Dios idagenday a kukuwa na Dios, idagenday a bagay a atoy i karuprupa na Dios, a kona ha ayat, ken nakam, ken pigsa moy,” kon ni Jesus. Ket nalaktat i Pariseyo ken ilay a hidi ni Herod ha tabbeg ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ket inumangay ha ni Jesus i kappal a Saduseyo. (Idagenday a Saduseyo i esa a kalase na Judyo a awan manahod a magbiyag manon i tolay a minatay dan.) ");
INSERT INTO duo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ket sinalodsod di, “Maestro, insurat ni Moyses ide a linteg, a ‘Nu matay i lallaki a atoy kabanga na, ket awan pala ha annak, masapul na wadi na a magkabanga ha ipag na a nabilu, penu magenak hikuna. Ket ibilang di mina i annak na ha annak na hekka na a minatay,’ kon ni Moyses. ");
INSERT INTO duo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Niyaen, Maestro, atoy i pitu a magkakabsat a lallaki. Ket nangabanga i hekka, ngem minatay hikuna a awan ha annak na. ");
INSERT INTO duo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ket kinabanga na wadi na i ipag na a nabilu. Ket minatay bila hikuna a awan ha annak na. Ket kona bila hito ha nekatallu. ");
INSERT INTO duo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ket kona bila hito hanggan ha nekapitu. Minatay hidi ngamin a awan ha annak di. Ket ha dilokod, natay bila i babbey. ");
INSERT INTO duo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Niyaen, Maestro, ipakatandi mo bi ha nikami. Ta netoldu mo a makabiyag manon i tolay a natay, kon na kan. Nu tahod i kinagi mo, heya dod i kabanga na babbey nokkan, nu magbiyag manon hidi, ta nagkabanga dan idagende a pitu ha nikuna?” kon na Saduseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ket tinabbeg ni Jesus, “Ide i gipu na a maliwaliwat i nakam moy. Ta awan moy katandiyan i Libro na Dios, ket awan moy katandi i pinnakabalin na Dios. ");
INSERT INTO duo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ta nokkan, nu magbiyag manon i natay a hidi, awan hidi mangabanga. Makabiyag hidi ha Dios ha magnanayon, a kona ha anghel a hidi a awan di masapul a mangabanga. ");
INSERT INTO duo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Niyaen,” intulos ni Jesus, “ha nikam a Saduseyo, apay a nakaman moy a awan magbiyag manon i tolay? Nagpatahod dan ni Moyses a magbiyag manon i totolay. Ket nanakaman moy mina i surat na a megipu ha ni Abraham, ken ni Isak, ken ni Jakob. Ta idi nagpaenta i Dios ha kayo a maggangat, kinagi na ha ni Moyses, ‘Hikan i deyawan ni Abraham, ni Isak, ken ni Jakob,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ket gipu ha ide, makatandiyan tam a magbiyag manon hidi. Ta magdeydeyaw pala hidi, maski nu natay dan. Ket awan ha magdeyaw ha Dios nu awan a makabiyag. Isu, madi i nakam moy.” ");
INSERT INTO duo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ket idi kinagi ni Jesus ito ha Saduseyo a hidi, atoy bila i esa a maestro na Linteg a nangaamata ha pinakitabbegan di. Ket naenta na a mappiya i tabbeg ni Jesus. Isu, sinalodsod na, “Anya i kanginaan a linteg ha Libro na Dios?” ");
INSERT INTO duo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ket kinagi ni Jesus, “Ide i kanginaan a linteg, a ‘Temanan moy, hikam a totolay na Israel. I Apo tam a Dios, hikuna la i Dios, a awan ha sabali. ");
INSERT INTO duo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ket masapul moy a ayatan i Apo moy a Dios ha ngamin a pigsa moy, ngamin a biyag moy, ngamin a nakam moy, ngamin a puso moy, ken ngamin a paggimet moy.’ Ide i kanginaan a linteg.” ");
INSERT INTO duo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Intulos ni Jesus, “Ide paman i nekaduwa a linteg, a ‘Masapul moy a ayatan i agagum moy, ket kona ha pinagayat moy ha bukod moy a baggi,’ kon na linteg. Niyaen, awan ha linteg a mas mangina ngem ha dagento a duwa,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ket kinagi na maestro na Linteg, “Tamos i kinagi mo, Maestro. Tahod a esesa la i Apo tam a Dios. Ket awan ha sabali a Dios, nu awan la i Apo tam a Dios. ");
INSERT INTO duo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tahod a ayatan tam mina i Dios ha ngamin a puso tam, ngamin a nakam tam, ken ngamin a pigsa tam. Ket tahod bila a ayatan tam mina i kakalan tam a tolay a kona ha pinagayat tam ha baggi tam. Ket mas mangina a tungpalan tam i duwa a linteg a ide, ngem ha ngamin a hayup a pangiwagah tam ha Dios, ken ngamin a sabali a pangidatton ha nikuna,” kon na maestro. ");
INSERT INTO duo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Idi nasaneg ni Jesus a mappiya i tabbeg na maestro aye, kinagi na ha nikuna, “Mabikan ka dan a mepasakop ha Paghariyan na Dios.” Idi kalpasan na ide, awan manon ha nakatured a magsalodsod ha ni Jesus. Ta mappiya i ngamin a tabbeg na. ");
INSERT INTO duo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Idi tinumulos ni Jesus a magitoldu ha Templo, kinagi na, “Apay a metoldu na mamaestro na Linteg a ni Hari Dabid i minappo na Cristu? ");
INSERT INTO duo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ta idi nagturayan na hikuna na Espiritu na Dios, nesurat ni Dabid ha Libro na Kansiyon, a ‘Kinagi na Apo Dios ha Hapo ko, “Magetnod ka ha henan ko, a maghari kita hanggan pagparentumengan ko i kasenti mo a hidi ha saguppang mo,” kon na Dios.’ ");
INSERT INTO duo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Isu, insurat ni Dabid i Happo na i Cristu a tahokan na totolay ha kasaguppangan. Ket pinanagenan ni Dabid ha Cristu i ‘Happo’ na. Isu, mabalin dod nu minappo bila ni Dabid na Cristu?” Ito i insalodsod ni Jesus ha maestro a hidi. Ket siraragsak i totolay a magteman ha pagitoldu ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Idi nagitoldu ni Jesus, kinagi na, “Magingat kam ha dagende a mamaestro na Linteg. Ta kayat di a magtennon ha mangina a badu, penu maenta na tolay a matangkay hidi. Ket kayat di i inaamakan a salpak ha sentro. ");
INSERT INTO duo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ket kayat di a umetnod ha pagetnodan na matangkay ha piyesta ken ha kapilya. ");
INSERT INTO duo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ngem agewan di i kukuwa na nabilu a hidi, sa hidi, magkararag ha maalay, penu kagin na tolay a mappiya hidi. Isu, hidi man i parusaan na Dios ha mas marigat nokkan.” Ito i iniwad ni Jesus ha tolay a hidi. ");
INSERT INTO duo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Niyaen, atoy pala ni Jesus ha Templo. Ket inumetnod hikuna ha bikan na kahon a pagatdinan ha korinat. Ket inaamatan na i kakpalan a tolay a nangiyatad ha korinat di. Ket atoy bila i makpal a mabaknang a nangiyatad ha makpal a korinat. ");
INSERT INTO duo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ket binumikan bila i esa a bilu a babbey a napobre, ket nangiyatad ha duwa la a sentimos. ");
INSERT INTO duo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ket pinabikan ni Jesus i tolduwan na a hidi. “Ipeta ko ha nikam,” kon na, “ha nakam na Dios, nangiyatad ide a bilu ha mas makpal ngem ha ngamin a mangiyatad a hidi. ");
INSERT INTO duo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta inyatad di i sobra na baknang di. Ngem maski nu napobre i bilu aye, inyatad na i ngamin a korinat na, i ngamin a pagbiyag na.” ");
INSERT INTO duo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Idi linumapos di Jesus ha Templo, kinagi na esa a tolduwan na, “Entan mo, Maestro, ta dadakkal a pogedu ha padding na Templo aye, ket inaamakan i napataknag aye.” ");
INSERT INTO duo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ket kinagi ni Jesus, “Oni ah. Entan moy i ngamin a dagende. Ta dumemat nokkan i tiyempo a marakrak hidi ngamin. Marakrak nokkan i kada esa a bitu-bitu ha padding aye. Ket matakneg hidi ngamin,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Idi linumapos hidi ha Jerusalem, inumangay di Jesus ha parabin a Olibo. Ket nagetnod hidi ha dibelew na Templo. Sa, binumikan ha nikuna ni Pedro, ni Santiyago, ni Juan ken ni Andres. Ket sinalodsod di a sililimed, ");
INSERT INTO duo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ipeta mo bi, Maestro, hangan dumemat i kinagi mo? Anya wade i tiplad, penu makatandiyan mi a dumemat iday a tiyempo a matungpal i kinagi mo?” ");
INSERT INTO duo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ket kinagi ni Jesus, “Magingat kam. Awan moy ipalobus a atoy i mangallilaw ha nikam. ");
INSERT INTO duo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ta atoy nokkan i makpal a umangay, ket magkagi a hidi man i Cristu a pinaangay na Dios penu maghari. Ket makpal i allilawan di nokkan. ");
INSERT INTO duo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ket maski nu mabaheta moy megipu ha gubat ken riribuk, awan kam mina magburibur. Ta masapul a magimet idagento ha palungo. Ngem maski nu kona hito, awan pala ha tiplad na tiyempo a pakobos na totolay ha lutak. ");
INSERT INTO duo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ta maggubat pala i makpal a bayan. Ket atoy bila i makpal a ginggined a dakkal, ken makpal a alap, ken saket ha maski nu hadya a lugar. Ngem maski nu kona hito, pangrugiyan la ide na tiyempo a pagrigrigat, ket kona ha paggasokan na babbey a magenak. ");
INSERT INTO duo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Pati hikam,” intulos ni Jesus. “Magingat kam. Ta ipadakap na kam na totolay, a iyangay di kam ha gobyerno. Ket sabbadan di kam ha kapilya di. Ket isaguppang di kam ha gobernador a hidi, ken ha hari a hidi, gipu ha panahod moy ha nikan. Iday i gundaway moy a magpatahod megipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ta masapul a mebaheta ide a Mappiya a Baheta ha ngamin a tolay ha lutak. Sa, atoy dan i tiyempo a pakobos na totolay ha lutak. ");
INSERT INTO duo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Isu, nokkan, nu dakapan di kam ken idarum di kam, awan kam mina magburibur nu anya mina i tabbeg moy. Ta Apo Dios i makatandi ha iday. Basta ipeta moy la i maski nu anya a ipanakam na ha nikam. Ta bakkan a hikam i magkagi, nu awan i Espiritu na Dios i magpakagi ha nikam. ");
INSERT INTO duo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ngem katandiyan moy mina a atoy i kappal a magpapatay. Maski atoy i kappal a patakka a magpapatay ha kakabsat di. Onu maski ha hama a hidi, mangidarum hidi ha annak di a papatayan di. Ket kona bila hito i gimetan na annak ha daddakkal di. Ta kona hito i madukas a tiyempo nokkan. ");
INSERT INTO duo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ket sentiyan na kam na kakpalan a tolay gipu ha panahod moy ha nikan. Ngem mesalakan nokkan i maski nu heya a makatured hanggan ha panungpalan.” ");
INSERT INTO duo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ket intulos ni Jesus, “Dumemat nokkan i oras, ket maenta moy ha Templo i pagsenti ha Dios. (Masapul a malaing unay i magbasa ha ide, penu makatandiyan na mina.) Ket nokkan, nu napataknag hikuna ha lugar a awan ha kalentigan na a tumaknag, kumamang mina ha amugod i ngamin a maggipu ha Judeya. ");
INSERT INTO duo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Masapul a dagus a bumuyot i maski nu heya. Nu hen hidi ha lapos na bilay, awan mina hidi sumadap penu mangalap ha aruwatan di. ");
INSERT INTO duo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ket nu hen hidi ha talon, awan mina hidi sumoli penu mangalap ha badu di. ");
INSERT INTO duo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kakakagbi i mabuktet a hidi ken magpasuso a hidi ha tiyempo hito. ");
INSERT INTO duo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ikarkararag moy ha Dios a awan ito magimet ha tiyempo na ahided. ");
INSERT INTO duo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Gipu ta ha ide a tiyempo, atoy i rigrigat a awan pala a napadas na totolay, maski idi pinakaparsuwa na ide a lutak, hanggan ha yenan. Ket awan mapinduwa idagende a rigrigat, hanggan awan ha kahad. ");
INSERT INTO duo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ngem maski nu kona hito i rigrigat, nebital na Dios i dagop a pamalak na rigrigat aye. Ta nu awan na paballikan i tiyempo hito, awan ha totolay a mesalakan. Ngem gipu ha totolay a pinili na, a inbukod na, paballikan na nokkan ide a tiyempo a pagrigrigat.” ");
INSERT INTO duo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ket ha tiyempo hito, “Awan moy mina tahodan, nu mepeta ha nikam, a ‘Entan moy ihe! Ta atoy dan ihe i Cristu!’ onu ipeta di, ‘Entan moy ihay. Atoy ihay i Cristu!’ konan di. Madi iday, ket awan moy iday tahodan. ");
INSERT INTO duo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta atoy nokkan i mangallilaw a hidi a magkagi a hidi kan i Cristu a maghari mina, onu hidi kan i mahagpugto a nagipu ha Dios. Ket magipaenta hidi ha kaddat di ken makpal a pagpasabbew, penu allilawan di mina i totolay na Dios a inbukod na. Ngem awan ito a mabalin ha nidi. ");
INSERT INTO duo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ngem ha nikam, magingat kam! Inpakatandi ko dan i ngamin a dagende, penu makasagana kam ha palungo a magimet idagento a rigrigat.” ");
INSERT INTO duo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ket nokkan, nu kobosan na tiyempo a pagrigrigat, dumiham i silaw na senggit, ket awan magdisyag i bulan. ");
INSERT INTO duo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ket matakneg i pusiyan a hidi. Ket mapasina i senggit ha paglakadan na. Ket kona bila hito ha bulan. ");
INSERT INTO duo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Sana, maenta na ngamin a tolay i Annak na Dios a Nagbalin a Tolay, a bumugsokak ha ulap. Ket maenta di i kainamakan ko, ken kinapigsa ko. ");
INSERT INTO duo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sako, paangayan i anghel a hidi ha ngamin a paset na lutak, a mangpuhon hidi ha ngamin a sakop ko a tolay a pinili na Dios a ibukod na.” ");
INSERT INTO duo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ket intulos ni Jesus, a kinagi na, “Nanakaman moy i kayo a igos. Ta nu magbudak i tingitingi na, katandiyan moy a dandani dan a kasinag. ");
INSERT INTO duo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ket kona bila hito ha dagenday a magimet nokkan. Nu maenta moy idagenday a nepugto ko, makatandiyan moy a dandani dan i tiyempo na pagsoli ko. ");
INSERT INTO duo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Magsiguradowak ha nikam, a makatulos pala ide a kalase na totolay, hanggan matungpal idagento. Sa, awan dan hidi, ta matay hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ket maski nu maawan bila i ngamin a langit ken ngamin a lutak nokkan, ipeta ko ha nikam a makatulos pala i kakkagi ko. Ta awan a mabalin a maawan i kagi ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ket intulos na, “Awan ha makatandi nu hangan a matongpal i nepugto ko he. Maski i anghel a hidi, a awan di katandiyan. Maski hikan a Annak na Dios, a awan ko bila katandi. I Hama ko la i makatandi ha iday. ");
INSERT INTO duo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Isu, magingat kam, ket magsagana kam. Ta awan moy katandiyan nu hangan i pagdemat na tiyempo aye. ");
INSERT INTO duo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“I pangikalanan na ito i esa a lallaki a maglakad ha madiyo a lugar. Ket ha pagpakada na, italak na i bilay na ha tagabu na a hidi. Ket bonan na i kada esa ha tarabaho na. Ket bonan na bila i mahagdapon ha ruwangan, a tahokan di mina i pagsoli na, ket awan mina hidi kumakelap. ");
INSERT INTO duo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Isu, niyaen, kona bila hito, i ipeta ko ha nikam, a magsagana kam mina. Ta awan moy katandi nu hangan i pagsoli na makinbilay aye. Baka magsoli ak ha kallap, o maski nu lubuk na kallap, onu parbangon, onu agsapa. ");
INSERT INTO duo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Oni ay. Magsagana kam. Amangan nu bigu la a magsoli ak, ket madanon takam a kumakelap. ");
INSERT INTO duo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Isu, ibon ko ha nikam a kona ha ibon ko ha ngamin a totolay ko, a magsagana kam, a tahokan moy i pagsoli ko.” ");
INSERT INTO duo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Niyaen, duwa pala a pamalak, ket dumemat i tiyempo na piyesta, nu magkan hidi ha tinapay a awan ha lebadura na. Ket nanagenan ito ha Piyesta na Pinagtaleban na Anghel a Magpatay. Niyaen, nakipaggammong i matangkay a papadi ken maestro a hidi na Linteg, nu panyan di a padakapan ni Jesus ha nalimed, a papatay di mina hikuna. ");
INSERT INTO duo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Ngem awan ha yenan a piyesta,” kinagi di, “amangan nu magriribuk i kakpalan a tolay.” ");
INSERT INTO duo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ket atoy idi ni Jesus ha ili a Betaniya, ha bilay ni Simon a nakahusay ha kattal na. Idi nangan pala hidi, dinumemat i esa a babbey a nakaegkam ha esa a botelya. Ket naputat ito ha mangina a pagbangbanglo. Ket tinappeng na i tangad na botelya aye, penu mebulak i pagbanglo. Sana, inbulak ide a ngamin a pagbanglo ha buntok ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ngem atoy hay i kappal a nakaingal. Ket nagkinagi hidi, “Apay a ginastuwan na babbey i bangbanglo? ");
INSERT INTO duo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nelako mina ito ha korinat. Ta balle na ito i makatawen a suweldo na tarabahador. Ket inyatad na mina ha napobre a hidi.” Kona he i pagulew di ha babbey aye. ");
INSERT INTO duo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngem kinagi ni Jesus, “Pabiyanan moy hikuna! Apay a ulewan moy? Mappiya unay i ginimet na ha nikan. ");
INSERT INTO duo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ta kankanayon a atoy i napobre a hidi ha henan moy, ket madaggapan moy hidi ha maski nu anya a oras. Ngem bakkan ha nikan. Ta awan maalay i oras ko ha nikam. ");
INSERT INTO duo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Niyaen, ha ide a babbey, nagserbe dan hikuna ha nikan, ayun ha kabaelan na. Ket inbulak na i pagpuhet ha natay. Isu, nesagana na dan i baggi ko, gipu ta dandaniyak dan a matay ken melabbang. ");
INSERT INTO duo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ket tahod ide a ipeta ko ha nikam: Ha maski nu hadya ha ngamin a lutak a pagtolduwan di ha Mappiya a Baheta na Dios, mepakatandi bila i ginimet na babbey aye. Ket pagpanakam bi ito ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kobosan na ito, inumangay ni Judas Iskaryote, i esa a lallaki ha esa pulo ket duwa a tolduwan ni Jesus. Inumangay hikuna ha matangkay a papadi, a makitulag a maglipot ha ni Jesus ha nidi. ");
INSERT INTO duo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ket naragsak hidi, idi nagteman hidi ha nikuna. Ket inkari di a atdinan di hikuna ha korinat. Isu, nangrugi ni Judas a magnakam, nu panyan na a liputan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dinumemat i nekaesa a pamalak na Piyesta. Ide i pamalak a partiyan di, ket iwagah di ha Dios i urbon a karnero. Ken magkan hidi ha malapis a tinapay, a awan ha lebadura na. Ket nagenan di ito ha “Pangapon na Pinagtaleban na Anghel a Magpatay.” Ket sinalodsod na tolduwan a hidi ni Jesus, “Hadya i kayat mo a pangisaganaan mi ha Pangapon na Pinagtaleban?” ");
INSERT INTO duo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ket pinaangay na i duwa a tolduwan na, a inpeta na, “Umangay kam ha ili. Ket magtagbu ha nikam i esa a lallaki a sinumagab. Umunod kam ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ket ha maski nu anya a bilay a saddapan na, ipeta moy ha makinbilay a, ‘Pasalodsod ni Maestro nu hadya i paghenan mi, a magkan ha Pangapon na Pinagtaleban?’ kon moy. ");
INSERT INTO duo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nu ipeta moy ito ha nikuna, ipaenta na ha nikam i dakkal a kuwarto ha ontok, a atoy i ngamin a aruwatan na para ha Pangapon tam. Ket hito i pangisaganaan moy ha Pangapon tam na Pinagtaleban,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ket inumangay hidi a duwa, ket sinumadap hidi ha ili, ket naeriyokan di i ngamin a inpeta ni Jesus, a kona ha nepeta na. Ket nagsagana hidi ha Pangapon na Pinagtaleban na Anghel a Magpatay. ");
INSERT INTO duo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Idi kallap dan, dinumemat ni Jesus, a kaagum na i esa pulo ket duwa a tolduwan na. ");
INSERT INTO duo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Idi nangan pala hidi, kinagi ni Jesus, “Tahod ide a ipeta ko ha nikam, a atoy ha he ha agagum tam a makipagkan i mangliput nokkan ha nikan.” ");
INSERT INTO duo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ket nagladingit i tolduwan na a hidi. Ket esesa a nagsalodsod hidi ha ni Jesus, “Sabali a hikan i konan mo, anya?” ");
INSERT INTO duo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ket kinagi ni Jesus, “Awan ha sabali, nu awan i esa ha nikam a esa pulo ket duwa, ket makisawsaw bila ha nikan ha tinapay ha digu aye. ");
INSERT INTO duo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hikan i Annak na Dios a Nagbalin a Tolay. Ket masapul a matayak nokkan kona ha nesurat ha Libro na Dios. Ngem marigat unay i parusa ha mangliput ha nikan. Sayang agay ha nikuna. Mas mappiya nu awan mina hikuna neenak,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Idi nangan pala hidi, nangalap ni Jesus ha tinapay. Ket nagyaman hikuna ha Dios. Ket pinilakpilak na i tinapay aye. Ket inyatad na ha nidi. Inpeta na, “Alapan moy ide a kanan moy. Ide i baggi ko.” ");
INSERT INTO duo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ket inalap na bila i baso na basi. Ket idi nagyaman hikuna ha Dios, ingiwat na ha nidi. Ket ininom di ngamin. ");
INSERT INTO duo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kinagi na, “I basi aye i digi ko a pangtongpal ha kari na Dios. Magabuyos i digi ko para ha makpal a tolay. ");
INSERT INTO duo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ket tahod ide a ipeta ko ha nikam, a awanak manon uminom ha basi na ubas, a kona he, hanggan iday a pamalak nu makipaginom kitam manon ha paghariyan na Dios.” ");
INSERT INTO duo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Idi nagkansiyon hidi ha padeyaw di ha Dios, inumangay hidi ha amugod a Olibo. ");
INSERT INTO duo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kinagi ni Jesus ha nidi, “Buyotanak moy nokkan. Hikam ngamin. Ta kona ha ide i nesurat ha Libro na Dios, a ‘Patayan ko i mahagdapon ha karnero,’ kon na Dios, ‘ket mawarawara i karnero na a hidi,’ kon na. ");
INSERT INTO duo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngem nokkan nu magbiyagak manon,” intulos ni Jesus, “magpalungo ak ha nikam a umangay ha Galileya. Ket urayan takam ihay.” ");
INSERT INTO duo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Niyaen, kinagi ni Pedro, “Maski nu buyotan naka na ngamin a agagum ko, awanak sumina ha nikaw.” ");
INSERT INTO duo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngem kinagi ni Jesus, “Tahod ide a ipeta ko ha nikaw: ha yenan a kallap, ha palungo na mekaduwa a pinagtaraok na kawitan, ket namintallu dan a inlibak mo ak.” ");
INSERT INTO duo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ngem tinabbeg ni Pedro ha napigsa, “Maski nu matayak gipu ha nikaw, pulos, a awan taka ilibak.” Ket kona bila hito i kinagi na ngamin a tolduwan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Niyaen, inumangay di Jesus ha esa a lugar a managenan ha Getsemani. Ket kinagi ni Jesus ha tolduwan na a hidi, “Magetnod kam ha he, a maguray. Umangayak pala iho a magkararag.” ");
INSERT INTO duo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ket inkuyog na di Pedro, Santiyago ken Juan. Niyaen, madaggi unay i nakam ni Jesus. Ket nagriribuk i nakam na, gipu ha dandani a magimet ha nikuna. ");
INSERT INTO duo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ket kinagi ni Jesus ha nidi, “Matayak dan gipu ha nakaro a ladinget ko. Magwarak kam pala ihe a magpuyat kam.” ");
INSERT INTO duo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Inumadiyo ha ballik ni Jesus, sa, hinumakab ha lutak. Ket inkararag na a nu mabalin mina, ket mesalakan hikuna ha katay na. ");
INSERT INTO duo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Hama ko,” kinagi na, “magimet mo i maski nu anya. Isu, awanak mo bi adiyowan ha magnanayon ha katay ko. Ngem maski nu kona hito a mahukomanak, bakkan mina a pagayatan ko i gimetan mo, nu awan i pagayatan mo. Ket usegan ko dod i kayat mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Idi nagsoli ni Jesus, nadanon na a kumakelap idagenday a tallu a tolduwan na. Ket kinagi na ha ni Pedro, “Simon, nakakillap ka dan? Awan ka dod makapagpuyat a maski esa a oras, ket magagum ha nikan? ");
INSERT INTO duo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magpuyat ken magkararag kam, penu awan kam magliwat nu masolisog na kam ni Satanas. Katandiyan ko a kayat na nakam moy a maggimet ha mappiya, ngem malupoy malla i baggi moy.” ");
INSERT INTO duo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ket inumangay manon ni Jesus a magkararag. Ket inpenduwa na i inaged na ha Dios. ");
INSERT INTO duo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sa, nagsoli manon ha henan na tolduwan na a hidi, ket nadanon na hidi a kinumillap, ta nakakellap hidi unay. Ket awan hidi ha kagi ha nikuna, ta masaniki hidi. ");
INSERT INTO duo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ket napentallu a inumangay hikuna a magkararag. Idi kasoli na, kinagi na ha nidi, “Anya, kumilap kam pala? Kuston ito. Dinumemat dan i oras! Megiwatak dan ha madukas a hidi. ");
INSERT INTO duo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Umikat kamon. Entamon. Atoy dan i mangliput ha nikan.” ");
INSERT INTO duo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Idi nagkagi pala ni Jesus, dinumemat ni Judas. Hikuna i esa ha dagenday esa pulo ket duwa a nakiagum ha ni Jesus. Ket atoy bila ha ni Judas i makpal a nagtagisondang ken nagtagigahoti. Naggipu hidi ha matangkay a papadi, ken mamaestro na linteg, ken panglakayan a hidi na Judyo. ");
INSERT INTO duo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Niyaen, idi palungo ha pagdemat di ha henan di Jesus, inpeta ni Judas ha agagum na, “Ammosan ko nokkan i lallaki a eriyokan moy. Hikuna i dakapan moy, a iyangay moy ha happo moy. Ket ingatan moy mina a daponan moy hikuna perpermi.” ");
INSERT INTO duo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Niyaen, idi pagdemat di Judas, binumikan hikuna a dagus ha ni Jesus, ket kinagi na, “Maestro!” Sana, inammosan. ");
INSERT INTO duo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ket dinakap di ni Jesus, a inegkam di perpermi. ");
INSERT INTO duo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngem ha agagum ni Jesus, atoy i esa a nagsakrot ha sondang na. Ket kinatol na i tagabu na katangkayan a padi. Ket nesina na i kanawan a talinga na. ");
INSERT INTO duo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kinagi ni Jesus ha nidi, “Mahagtakawak dod? Apay a usaran moy i sondang ken gahote a pangdakap moy ha nikan? ");
INSERT INTO duo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nikuna kadapamalak, nangitolduwak ha saguppang moy ha Templo. Ket awanak moy dinakap. Ngem niyaen, mapalobusan kam, penu matungpal i nesurat na minahagpugto ha Libro na Dios.” ");
INSERT INTO duo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Idi kinagi na iday ni Jesus, binuyotan na hikuna na ngamin a agagum na. ");
INSERT INTO duo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Niyaen, ha pinangiyangay di ni Jesus ha ili, atoy i esa a lallaki a inumunod ha nidi. Nakakagay la hikuna ha ulas. Ket dinakap di. ");
INSERT INTO duo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ngem nakalapsut hikuna ha ulas na, ket binumuyot hikuna a naubi. ");
INSERT INTO duo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Niyaen, intugan di ni Jesus ha bilay na katangkayan a padi. Ket atoy bila hay i ngamin a matangkay a padi, ken panglakayan na Judyo, ken maestro a hidi na linteg, a pinumisan dan hidi. ");
INSERT INTO duo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tinumagubet dan ni Pedro, ngem awan hikuna binumikan. Ket tinumulos, a sinumadap hikuna ha paraangan na bilay na Katangkayan a Padi. Ket inumetnod hikuna a nakipagendu ha guwardya a hidi. ");
INSERT INTO duo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ha iday a oras, ha Katangkayan a Padi ken ngamin a agagum na, mageriyok hidi ha sistigu a mangpaliwat mina ha ni Jesus. Ta kayat di a mapapatay. Ngem awan ha sistigu a naeriyokan di. ");
INSERT INTO duo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ta maski nu makpal i nangpaliwat ha ni Jesus, awan a nagtutunos i kinagi di, ta silisileng la i inpeta di. ");
INSERT INTO duo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sa, atoy bila i kappal a tinumaknag a mangpaliwat. Ket nagsileng bila hidi. Kinagi di, ");
INSERT INTO duo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nateman mi ide a kinagi na, a ‘Rakrakan ko nokkan ide a Templo a pinataknag na totolay. Ket ha tallu a pamalak, pataknagan ko i sabali a awan a ginimet na tolay,’ kon na idi.” Ide i inpaliwat di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngem maski nu kona hito i kakkagi di, awan a nagtutunos i pinagpaliwat di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Niyaen, tinumaknag i Katangkayan a Padi ha saguppang di. Ket sinalodsod na ha ni Jesus, “Madiyan mo dod a magtabbeg? Anya ipeta mo megipu ha ngamin a pagpaliwat di ha nikaw?” ");
INSERT INTO duo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngem nagulimek la ni Jesus, a awan hikuna nagkagi. Ket sinalodsod na manon na Katangkayan a Padi, “Anya ipeta mo? Hikaw i Cristu a Annak na Dios a pinaangay na penu maghari?” ");
INSERT INTO duo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ket kinagi ni Jesus, “Oni. Hikan dan. Ket nokkan, metanak moy a magetnod ha henan na Dios a maghari. Ket metan moy bila i pagsoli ko ha ulap, penu maghukom ha totolay.” ");
INSERT INTO duo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Idi nateman na ito na Katangkayan a Padi, pinisad na i kagay na. Ket kinagi na, “Awan tam masapul i sistigu a hidi. ");
INSERT INTO duo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nateman tam i kakkagi na a agindidios. Ta nateman tam i kinagi na, a hikuna i Annak na Dios. Isu, niyaen, anya i nakaman moy?” kon na Katangkayan a Padi. Ket ninakam di ngamin a mapapatay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sa, atoy i kappal a nagloktab ha nikuna. Ket binadbad di i mata na. Sadi, dinanogdanog hikuna, a kinagi di, “Pugtuwan mo nu heya i nangdanog ha nikaw,” kon di. Kalpasan na, inalap na guardiya a hidi, a dinanog di bila ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Idi nagetnod pala ni Pedro ha paraangan na bilay, binumikan i esa a babbey a tagabu na Katangkayan a Padi. ");
INSERT INTO duo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ket naenta na ni Pedro a magendu. Sana, inaamatan hikuna. Ket kinagi na, “Nagagum ka bila ha ide a taga-Nasaret, a ni Jesus!” ");
INSERT INTO duo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngem inlibak ni Pedro, a kinagi na, “Bakkan a hikan! Awan ko makatandiyan i kagiyan mo.” Ket linumapos ni Pedro a nagturong ha ruwangan. Ket nagtaraok i kawitan. ");
INSERT INTO duo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sa na, naenta manon hikuna na babbey aye. Ket kinagi na manon ha totolay a atoy hay, “Hikuna i agum di Jesus!” ");
INSERT INTO duo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngem naglibak manon ni Pedro. Sa, idi awan ha maalay, ket kinagi na totolay a atoy hay, “Sigurado a hikaw i esa a nagagum ha di Jesus, ta taga-Galileya i kakkagi mo,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ngem kinagi ni Pedro, “Parusaan na ak na Dios nu magsilengak! Tahod a awan ko katandi iday a lallaki a kakagiyan moy!” ");
INSERT INTO duo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ket dagus a nagtaraok manon i kawitan. Ket nanakam ni Pedro i kinagi ni Jesus, “Ha palungo na mekaduwa a pinagtaraok na kawitan, ilibak mo ak ha mamintallu.” Idi nanakam ito ni Pedro, minagsaket unay i nakam na, a nagsangisanget. ");
INSERT INTO duo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Niyaen, idi agsapa, nakipagpisan manon i kapkapitan na padi, ken panglakayan, ken mamaestro na Linteg, ken ngamin a kamkameng na Sanhedrin. Ket tinulag di nu anya i gimetan di. Ket kinawaran di ni Jesus. Sadi, intugan hikuna ha ni Gubernador Pilato. ");
INSERT INTO duo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sinalodsod ni Pilato ha ni Jesus, “Hikaw dod i hari na Judyo a hidi?” Ket intabbeg ni Jesus, “Tahod i kinagi mo.” ");
INSERT INTO duo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ket makpal i inpaliwat na matangkay a padi a hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ket sinalodsod manon ni Pilato, “Anya? Awan ka ha tabbeg? Temanan mo i makpal a ipaliwat di ha nikaw!” ");
INSERT INTO duo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngem awan la a tinumabbeg ni Jesus. Ket nalaktat ni Pilato a awan na inkalentigan ni Jesus i baggi na. ");
INSERT INTO duo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Niyaen, atoy i ugali ni Pilato, a magpalakad hikuna ha esa a balud ha kada tawen, ha Piyesta na Pinagtaleban na Anghel a Magpatay. Ket palobusan ni Pilato i totolay a hidi a magpili nu heya i palakadan na. ");
INSERT INTO duo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ket atoy i esa a balud, a ni Barrabas i nagen na. Kaagum hikuna na nakabuno a hidi, idi nagriribuk hidi ha gobyerno. Ket nakabuno hikuna, idi pinagriribuk di. ");
INSERT INTO duo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Niyaen, dinumulog i makpal a tolay ha ni Pilato. Ket inaged di a palakadan na i esa a balud. ");
INSERT INTO duo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ket sinalodsod ni Pilato, “Kayat moy a palakadan ko i hari na Judyo?” ");
INSERT INTO duo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kinagi na ito ni Pilato gipu ta katandiyan na a sumeni i kapkapitan na padi ha ni Jesus. Ket iday i gipu na a inpabalud di hikuna. ");
INSERT INTO duo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ngem dinurogan na dagende a padi i tolay a hidi, penu agedan di ha ni Pilato a palakadan na ni Barrabas, ket awan man ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ket sinalodsod manon ni Pilato, “Anya dod i gimetan ko ha ide a nagenan moy a Hari na Judyo?” ");
INSERT INTO duo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ket inrangsit di, “Pelansa mo hikuna ha kudos!” ");
INSERT INTO duo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ket kinagi ni Pilato, “Apay? Anya i liwat na?” Ngem inpigsa di i rangsit di, “Pelansa mo hikuna ha kudos!” ");
INSERT INTO duo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Isu, gipu ta kayat ni Pilato a pagustowan i tolay a hidi, pinalakad na ni Barrabas. Ket pinasabbad na ni Jesus. Sana, inbon ha sundalu a hidi a ilansa di ha kudos. ");
INSERT INTO duo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Insadap na sundalu a hidi ni Jesus ha panghukoman, ha disalad na bilay na Gobernador. Ket inayagan di i ngamin a agagum di. ");
INSERT INTO duo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sadi, kinagayan ni Jesus ha madideg a lupot. Ket naggimet hidi ha korona a seset, ket indatton di ha buntok na. ");
INSERT INTO duo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sa hidi, nagindedeyaw a nangsalpak ha ni Jesus, ha “Madeydeyaw i Hari na Judyo!” kon di. ");
INSERT INTO duo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ket pinakol di i buntok na ha tikkal. Ket linoktaban di hikuna. Ket nagparentumeng hidi ha saguppang na a nagngidi-ngiditan di hikuna. ");
INSERT INTO duo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Idi nobosan di a nagulew-ulewan, inadya di i madideg a kagay na, ket intennon di i bukod na a tennon. Sadi, inlapos hikuna, penu ilansa di ha kudos. ");
INSERT INTO duo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Idi paglakad di, natagbu di i esa a lallaki a sumasaddap ha ili. Taga-Sirene hikuna. Ni Simon i nagen na. Hikuna i hama ni Alehandro ken ni Rupus. Idi netan di hikuna, pinilit na sundalu a hidi a mangbaklay ni Simon ha kudos ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ket inyangay di ni Jesus ha lugar a nagenan di a “Golgota”. Kayat na a kagiyan, “Henan na Karbot.” ");
INSERT INTO duo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Idi kaddemat di hito, inatdinan di ni Jesus ha arak a nalaokan ha mirra, a kalase na agas a pangpaadya ha saket. Ngem minadiyan ito ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sadi, inlansa ni Jesus ha kudos. Kobosan na, binunong di i tennon na, a nagbibinunotan di nu anya i maalap na kada esa. ");
INSERT INTO duo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Inlansa di ni Jesus idi alas nuwebe na maledum. ");
INSERT INTO duo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ket atoy i surat ha kudos a pangpaliwatan di ha nikuna. Ket nesurat, “I HARI NA JUDYO.” ");
INSERT INTO duo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ket atoy bila i duwa a mahagtakaw a inlansa di ha ide a lugar. Inlansa di i esa ha makannawan ni Jesus, ket i sabali ha makannigid na. ");
INSERT INTO duo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ket gipu ta kona hito, natungpal i nesurat ha Libro na Dios, a “Nebilang i Cristu ha madukas a hidi.” ");
INSERT INTO duo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ket atoy ihay i makpal a tinumataleb ha kudos na. Ket winingwingiwingan di ken nagulewan, a kinagi di, a “Nay kan! Kinagi mo a rakrakan mo i Templo, sa mo, pataknagan manon ha tallu a pamalak! ");
INSERT INTO duo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nay ka dan! Isalakan mo dod i baggi mo, ket umogsad ka ha kudos aye!” ");
INSERT INTO duo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ket kona bila hito ha pinagulew na kapkapitan na padi a hidi, ken mamaestro na linteg. Nagkinagi hidi, a “Insalakan na kan i makpal a tolay, ngem niyaen, awan na mesalakan i baggi na,” kon di. ");
INSERT INTO duo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Nu tahod a hikuna i Cristu a Hari na Judyo, umogsad mina hikuna, penu maenta tam ken tahodan tam hikuna,” konan di. Ket kona bila hito, maski ha nidi a duwa a kasabay na a nelansa, a inulew di bila ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Idi lubuk na pamalak, nagdiham i ngamin a lutak hanggan alas tres. ");
INSERT INTO duo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Idi alas tres dan, inrangsit ni Jesus, “Eloi, Eloi, lama sabaktani?” a kayat na a kagiyan, “Dios ko, Dios ko, apay a pinabiyanak mo?” ");
INSERT INTO duo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nateman na ito na kappal a nakataknag hay, ket inulew di, a kinagi di, “Ayagan na i minahagpugto a ni Elias!” ");
INSERT INTO duo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ket nagbuyot i esa a nangalap ha hamet, ket insawsaw na ito ha makkak a arak. Sana, indatton ha ontok na kayo, ket inpasapsap na ha ni Jesus. Kinagi na, “Entan tam nu umangay ni Elias a mangiogsad ha nikuna ha kudos!” ");
INSERT INTO duo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Niyaen, inrangsit manon ni Jesus ha napigsa. Kobosan na, linumakad i angas na. ");
INSERT INTO duo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ket bigu la a napisad i nabigal a kurtina ha Templo. Ito i pangsallen ha totolay ha iday a kuwarto a nadiosan, ha disalad na Templo. Ket napisad ito a naggudwa, naggipu ha ontok hanggan ha sidung. ");
INSERT INTO duo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ha saguppang na kudos, atoy i kapitan na sunsundalu a nagtataknag hay. Idi naenta na nu panyan a minatay ni Jesus, kinagi na, “Tahod a Annak na Dios ide a lallaki.” ");
INSERT INTO duo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ket atoy bila ihay i kappal a babbey a nagtataknag ha madiyo ballik. Ket nangaamata hidi ha ngamin a nagimet ihay. Atoy ha nidi di Maria Magdalena, Salome, ken Maria a hena di Jose ken Santiyago. ");
INSERT INTO duo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Idagende a babbey i inumuseg ha ni Jesus idi naghen hikuna ha Galileya, ket nagserserbe hidi ha nikuna. Ket atoy bila hay i makpal a sabali a babbey a inumuseg ha ni Jesus ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Niyaen, dandani dan a kallap. Ket Biyernes iday a pamalak a pagdespiras di ha Sabado. Ket maneg, kon na kan, nu magtarabaho i Judyo a hidi ha Sabado. ");
INSERT INTO duo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Isu, inumangay ni Jose a taga-Arimateya. Hikuna i esa a madedeyaw a sakop na Sanhedrin. Ket tahotahokan na i pagdemat na paghariyan na Dios. Ket niyaen, pinatured na i baggi na a umangay ha ni Pilato, a magaged ha bangkay ni Jesus. Ta dandani dan a kallap. ");
INSERT INTO duo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Idi nabaheta ni Pilato a natay dan ni Jesus, nalaktat hikuna. Ket inayagan na i kapitan na sunsundalu, ket sinalodsod na nu tahod a natay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Idi inbaheta na kapitan a tahod a natay ni Jesus, inpalobus ni Pilato a alapan di Jose i bangkay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Inpeyogsad di Jose i bangkay ha kudos. Ket binadbad di ha maponset a hamet a kaggatang na. Ket intagmak di ito ha labbang a nakotkotan ha dilenas. Kobosan na, indatton di i dakkal a pogedu a pangkallab di ha labbang. ");
INSERT INTO duo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nangaamata di Maria Magdalena ken Maria a hena ni Jose. Ket naenta di i nakelabbangan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Idi nobos i Sabado a pagemmangan di, inumangay di Maria Magdalena, Salome ken Maria a hena ni Santiyago. Ket ginatang di i bangbanglo a pagpuhet di mina ha bangkay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ket idi maledum na Dominggo, idi humangkat i senggit, inumangay hidi ha labbang ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ha paglakad di, nagsinalodsod hidi nu heya i mangadya ha pogedu a nekalab ha labbang. Ta madaggi unay iday a pogedu. Ngem idi kaddemat di, naenta di a naadya dan iday a pogedu. ");
INSERT INTO duo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Isu a sinumadap hidi ha labbang. Ket atoy i naenta di a esa a lallaki. Nagetnod hikuna ha makannawan. Ket pasig la maponset i tennon na. Ket nalaktat idagende a babbey. ");
INSERT INTO duo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ngem kinagi na, “Awan kam manteng. Katandi ko dan a eriyokan moy ni Jesus a taga-Nasaret, a nelansa ha kudos. Ngem awan dan hikuna ihe, ta minagbiyag manon! Entan moy ihe a nangitagmakan di ha bangkay na. ");
INSERT INTO duo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Niyaen, umangay kam, a ibaheta moy ha tolduwan na a hidi, nangruna ha ni Pedro: ket ‘Magpalungo kan ni Jesus ha nikam ha Galileya. Ket metan moy hikuna ha hay, a kona ha inpeta na ha nikam idi,’ kon moy a.” ");
INSERT INTO duo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ket dagus a linumapos idagende a babbey, a binumuyot hidi. Ta nanteng hidi. Ket nagyagyag i baggi di gipu ha laktat di. Awan di kaya i magkagi ha maski nu heya a natagbu di, ta nanteng hidi unay. ");
INSERT INTO duo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Niyaen, kona ha ide i pinagpaenta ni Jesus ha totolay. Idi minagbiyag manon ni Jesus, idi maledum na Dominggo, nagpaenta hikuna ha palungo ha ni Maria Magdalena. Hikuna i babbey a nangpalakadan na ha pitu a dimonyo. ");
INSERT INTO duo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ket inumangay ni Maria ha toltolduwan ni Jesus, idi nagladingit ken nagsangisanget pala hidi. Ket inbaheta na ha nidi a naenta na ni Jesus. ");
INSERT INTO duo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngem idi nateman di i kinagi na, a minagbiyag manon ni Jesus ken nagpaenta ha nikuna, awan di hikuna tinahod. ");
INSERT INTO duo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kobosan na ito, pinumenta manon ni Jesus ha duwa a tolduwan na, idi naglakad hidi ha lapos na ili. Ket sabali manon i itsura na. ");
INSERT INTO duo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ket nagsoli idende a duwa, a inbaheta di ha agagum di, ngem awan di hidi tinahod. ");
INSERT INTO duo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kobosan na ito, pinumenta ni Jesus ha dagenday a esapulo ket esa a tolduwan na, idi magkan pala hidi. Ket binahang na hidi gipu ha maigat a nakam di, a awan hidi nanahod ha nikuna. Ta awan hidi nanahod, maski idi nebaheta ha nidi na dagenday a nakaenta ha ni Jesus, a minagbiyag manon. ");
INSERT INTO duo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sana, inbon ha nidi, a “Umangay kam ha ngamin a paset na lutak aye, ket ibaheta moy ha ngamin a totolay ide a Mappiya a Baheta. ");
INSERT INTO duo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ha maski nu heya a manahod ha nikan ken mabinyagan, mesalakan hikuna nokkan ha paghukom na Dios. Ngem ha maski nu heya a awan a manahod, hukoman na hikuna na Dios. ");
INSERT INTO duo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ket meyatad ha manahod a hidi idagende a pinnakabalin, penu mepaenta di a nagpasakop dan hidi ha Dios. Gipu ha turay na nagen ko a igiwat ko ha nidi, makapalakad hidi ha didimonyo, ket makakagi hidi ha sabasabali a pagkakagi a awan na makatandiyan na totolay. ");
INSERT INTO duo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ket maski nu magegkam hidi ha ulag, onu uminom hidi ha sabidong, awan hidi maanya. Ket itupu di i kamat di ha magsaket a hidi, ket humusay hidi.” ");
INSERT INTO duo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kobosan na pinagkagi ni Jesus ha tolduwan na a hidi, pinaontok na hikuna na Dios ha langit, a magagum ha Dios a maghari. ");
INSERT INTO duo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ket inumangay i tolduwan na a hidi ha maski nu anya a lugar, a nagpakatandi hidi ha ide a Mappiya a Baheta. Ket dinaggapan na hidi ni Apo Jesus, a nagpatahod hikuna ha totolay a tahod i inbaheta di. Ta inatdinan na i tolduwan na a hidi ha pinnakabalin di a kona ha pagtiplad na a atoy hikuna ha nidi.");
INSERT INTO duo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ide i surat ko ha ni Teyopilo: Atoy dan i makpal a nangisurat megipu ha pinaggimet ni Jesu-Cristu, idi naghen hikuna ha ide a lutak. ");
INSERT INTO duo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","I nesurat di i kinagi na agagum ni Jesus a nakaenta ha dagenday a bagbagay, idi karugi na. Ket nagitoldu hidi ha kagi na. ");
INSERT INTO duo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Niyaen, perpermi i pinagadal ko ha dagenday, nangrugi idi naalay dan. Isu, ilay ko a Teyopilo, gipu ta kona hito, ninakam ko a isurat ko bila ha maurnos i kakkagi di. ");
INSERT INTO duo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Insurat ko idagende penu makatandiyan moy i ngamin a katahodan megipu ha ngamin a nebaheta ha nikam. ");
INSERT INTO duo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nikuna magbiyag ni Herod, i esa a Hari na Judeya, atoy bila i esa a padi a nagen na ni Sakariyas. Ket sakop hikuna ha papadi a minappo di, ni Abiyas. Ket Elisabet i nagen na kabanga na. Ket hikuna bila i sakop na papadi. I minappo di, ni Aron. ");
INSERT INTO duo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ket mappiya i ugali di duwa, ni Sakariyas ken ni Elisabet. Ta kanayon hidi a umusoseg ken magtongpal ha bon na Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngem i problema di a awan hidi nagenak, ta kalopas dan ni Elisabet. Nagkalan hidi a duwa, ta kalopas bi hidi. Ta babakat dan ni Elisabet ken malupoy dan ni Sakariyas. ");
INSERT INTO duo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Niyaen, idi esa a pamalak, atoy i nagimet ha ni Sakariyas. Idi pamalak heya, naghen hikuna ha Templo, ta kasulet hikuna na kagurupo na a papadi a magserbe ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ket atoy i ugali na papadi a magbibinunotan hidi, penu makatandiyan di nu heya mina i sumadap ha Templo, nu heya mina i mangitutod ha pangpasarob ha lamesaan a pangatdinan di ha Dios. Isu, nagbibinunotan hidi, ket nangabak ni Sakariyas. Ket sinumadap ni Sakariyas ha Templo. ");
INSERT INTO duo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Niyaen, idi tinutod na i pangpasarob, atoy bila i nagkararag a makpal ha lapos na Templo. ");
INSERT INTO duo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ket idi hen ni Sakariyas ha disalad na Templo, nagpaenta i esa a anghel na Dios ha nikuna. Tinumaknag i anghel aye ha hikeg na makanawan na pangatdinan di ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Idi nakaenta ni Sakariyas ha anghel, nalaktat hikuna ken nanteng. ");
INSERT INTO duo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ngem inpeta na anghel ha nikuna, “Sakariyas, awan kas manteng! Ta tiniman na Dios i kararag mo. Isu, magenak nokkan i kabanga mo ha annak a lallaki. Ket panagenan moy hikuna ha ‘Juan’. ");
INSERT INTO duo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Magragsak kam, ket makpal pala i magragsak nokkan nu meenak ide a ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ta pagbalinan hikuna na Dios a matangkay. Awan na inuman i arak, maski nu anya a kalase na arak. Ket mangrugi a meenak hikuna, atoy i Espiritu na Dios a maghen ha baggi na. ");
INSERT INTO duo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ket nokkan, pagbabawiyan na i makpal ha liwaliwat di, ket pasoliyan na i makpal a Judyo ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Magkalan man ni Juan ken ni Eliyas, a esa a minahagpugto, a pinabinag ken pinnakabalin na Espiritu na Dios. Magkalan bila ni Juan, a annak moy. Ket magpalungo hikuna nokkan ha ni Cristu, penu pagkagbiyan na i lakay a hidi ha annak a hidi. Ket pagahegan na bila na masegkat a hidi ha nidi a masirib ken mappiya. Ket nu kona hito, makasagana hidi nokkan ha pagdemat ni Apo Cristu. Ito i gimetan na annak moy nokkan,” kon na anghel ha ni Sakariyas. ");
INSERT INTO duo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ngem nagsalodsod ni Sakariyas ha anghel aye, “Panyan ko a makatandiyan nu magimet i nepeta mo onu awan, ta malupoyak dan, ket babakat dan i kabanga ko?” kon ni Sakariyas. ");
INSERT INTO duo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ket tinabbeg na anghel, “Hikan ni Gabriel. Nagipuwak ha Dios. Ta pinaangay na ak, penu ipeta ko ha nikaw ide a mappiya a baheta. ");
INSERT INTO duo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ngem awan ka manahod ha nepeta ko, a magenak ni Elisabet nokkan, ha tiyempo a kayat na Dios. Isu, hanggan ha tiyempo a magimet iday, awan ka makakagi. Ta awan ka nanahod ha inpeta ko.” Ide i kinagi na anghel ha ni Sakariyas. ");
INSERT INTO duo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Niyaen, idi nakiuhon pala hidi, nagururay pala i tolay a hidi ha lapos na Templo. Ket nanakaman di nu apay a naalay ni Sakariyas ha disalad na Templo. ");
INSERT INTO duo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Niyaen, idi linumapos ni Sakariyas, awan hikuna nakakagi ha nidi. Nagsenyas la hikuna ha nidi. Isu, gipu ta kona hito, nakatandiyan di a atoy i inpaenta na Dios ha nikuna ha disalad na Templo. ");
INSERT INTO duo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ket idi nobos i tarabaho ni Sakariyas ha Templo, sinumoli hikuna ha bilay di. ");
INSERT INTO duo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Niyaen, idi maalay ballik, naginaw ni Elisabet. Ket minadiyan na a magpaenta ha baggi na ha lima a bulan. ");
INSERT INTO duo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kinagi na, “Kinagbiyan na ak na Dios, ta inadya na i ikasaniki ko. Oni ay, nabuktetak dan.” ");
INSERT INTO duo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Idi nekaannam a bulan a nabuktet ni Elisabet, pinaangay na Dios ni Gabriel, a esa a anghel na, ha ili a Nasaret, ha probinsiya a Galileya. ");
INSERT INTO duo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pinaangay na hikuna ha esa a madiket, a nagen na, ni Maria. Ide a madiket, awan pala hikuna pinabikanan ha lallaki. Maski nesakad hikuna ha esa a lallaki a nagen na, ni Jose, a esa a apo ni Hari Dabid. ");
INSERT INTO duo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Niyaen, idi dinumemat i anghel ha ni Maria, inpeta na ha nikuna, “Maria, kagbiyan na ka na Dios, a hikaw i pinili na. Isu, atoy ha nikaw i kagbi na Dios.” ");
INSERT INTO duo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ngem nasbew ni Maria, gipu ta awan na nakatandiyan i kinagi na anghel. Nanakaman na la ide, nu anya i kayat na kagiyan na. ");
INSERT INTO duo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ket gipu ta kona hito, inpeta na anghel ha nikuna, “Awan kas manteng, Maria, ta kinagbiyan na ka na Dios unay. ");
INSERT INTO duo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ket paginawan na ka nokkan, ket magenak ka ha esa a lallaki. Panagenan mo hikuna ha ‘Jesus.’ ");
INSERT INTO duo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ta magbalin hikuna a matangkay, ket managenan nokkan ha ‘Annak na Dios a Katangkayan’. Ket nokkan pala, pagbalinan na hikuna na Dios a hari, a magtawid ni Jesus ha pinaghari na minappo na a ni Hari Dabid. ");
INSERT INTO duo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ket maghari hikuna ha nikam a Judyo ha magnanayon, hanggan awan ha kahad. Ket awan mobosan i paghariyan na,” kon na anghel. ");
INSERT INTO duo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Niyaen, nagsalodsod ni Maria ha anghel, “Panyan na magimet ide? Ta awanak pala nangabanga.” ");
INSERT INTO duo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ket tinabbeg na anghel, “I Espiritu na Dios i dumemat nokkan ha nikaw, ket i kaddat na i magpainaw ha nikaw. Isu, mapanagenan i annak mo ha ‘Pasig la Mappiya’, ken ‘Annak na Dios’. ");
INSERT INTO duo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nanakaman mo ni Elisabet a manay mo. Ta kalopas kan hikuna, ngem niyaen, nekaannam dan i buktet na, maski nu babakat dan unay. ");
INSERT INTO duo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta makagimet i Dios ha maski nu anya,” kon na anghel. ");
INSERT INTO duo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“Hikan i tagabu na Dios,” kinagi ni Maria, “magimet mina ha nikan i kona ha nepeta mo,” kon na. Sa, linumakad iday a anghel. ");
INSERT INTO duo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Idi maalay ballik, nagsigida ni Maria a tinumagdak ha esa a ili ha amugod ha Judeya. ");
INSERT INTO duo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sinumadap hikuna ha bilay di Sakariyas, ket sinalpak na ni Elisabet. ");
INSERT INTO duo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Idi nateman ni Elisabet i salpak na, bigu la a linumembuk i annak ha tiyan na. Ket tulos a sinumadap i Espiritu na Dios ha ni Elisabet. ");
INSERT INTO duo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Isu, napigsa unay i salpak ni Elisabet. Kinagi na, “Mas mappiya i kasasaad mo ngem ha ngamin a babbey. Ket mappiya bila i kasasaad na annak a ienak mo nokkan. ");
INSERT INTO duo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Daddi, i pakadeyawan ko aye, a bisitaan na ak nena na Dios ko, maski madibbi ak la. ");
INSERT INTO duo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Agay, idi nateman ko i salpak mo, linumembuk i annak ha tiyan ko gipu ha ragsak na. ");
INSERT INTO duo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Oni! mappiya i kasasaad mo, ta tinahod mo a gimetan na Dios i ngamin a inkari na ha nikaw,” kon ni Elisabet ha ni Maria. ");
INSERT INTO duo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sa na, kinagi ni Maria, “Dakkal i pagdeyaw ko ha Apo Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ket maragsakak unay. Ta Dios i mangisalakan ha nikan. ");
INSERT INTO duo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Hikan i madibbi a tagabu na Dios, ngem nanakaman na ak. Ta mangrugi ha niyaen, deyawan na ak na ngamin a tolay, a mappiya i kasasaad ko, kon di. ");
INSERT INTO duo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ta dakkal idagende a ginimet na Dios ha nikan. Ket mannakabalin gamen i Dios, a pasig la mappiya. ");
INSERT INTO duo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kagbiyan na i magdeyaw ha nikuna, maski hidi a nagdeydeyaw idi a minappo tam ken hidi a magdeydeyaw nokkan a kaputotan tam. ");
INSERT INTO duo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Inpaenta na i pigsa na ha ngamin a tolay, a pagbuyotan na i mapangas a hidi, ket abakan na i ngamin a panggep di. ");
INSERT INTO duo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ha napigsa a hidi ha pinaghari di, inabak na hidi na Dios. Ket ha nidi a madibbi, patangkayan na hidi. ");
INSERT INTO duo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ha nidi a nagiyalap, pinapha na hidi ha mappiya a bagbagay. Ket ha nidi a nabaknang, pinalakad na hidi a bagbaggi di la. ");
INSERT INTO duo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Niyaen, awan naleptanan na Dios i kari na ha ni Abraham ken annak na, a ni Israel. Ket makagbiyan na hidi ken ngamin a kaputotan di hanggan awan ha kahad! Isu, niyaen, aguman na kitam a tagabu na, gipu ta ide a kari na nikuna.” Nobos dan i pinagdeyaw ni Maria ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Naghen ni Maria ha bilay di Elisabet ha tallu a bulan. Sa hikuna, sinumoli manon ha ili a Nasaret. ");
INSERT INTO duo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Idi nagenak ni Elisabet, inyenak na i lallaki. ");
INSERT INTO duo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ket nabaheta na kabiyan na a hidi, ken karugaran na a hidi, a kinagbiyan na Dios hikuna. Isu, nagragsak hidi ngamin megipu ha ni Elisabet. ");
INSERT INTO duo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ket idi nekawalo a pamalak a nenak na, atoy i dinumemat a magkugit ha annak aye, ket nagenan di mina hikuna. Ta kayat di a umuseg ha linteg na Judyo. Ket pinanggep di a nagenan ha “Sakariyas”, ta iday i nagen na hama na. ");
INSERT INTO duo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ngem inpeta ni Elisabet, “Awan mina! Juan i nagen na.” ");
INSERT INTO duo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ket tinabbeg di, “Oni ah, ngem awan ha kabiyan mo a magnagen ha kona hay,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ket sinenyasan di ni Sakariyas, penu katandiyan di nu anya i kayat na a ipanagen ha annak na. ");
INSERT INTO duo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Isu, inaged ni Sakariyas i pagsuratan na. Ket insurat na, a “Juan i nagen na.” Ket permi i laktat di ngamin. ");
INSERT INTO duo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sa, bigu la, a nakakagi manon ni Sakariyas, ket dineyaw na i Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Isu, nasbew hidi ngamin a karugaran di. Ket nangibaheta hidi hanggan ngamin a amugod na Judeya. ");
INSERT INTO duo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ket i nakateman a hidi ha baheta aye, nanakanakam di pala nu maganya i Dios ha annak aye. Gipu ta nakatandiyan di a atoy ha nikuna i kagbi na Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Idi pinagdeyaw ni Sakariyas, i hama na annak aye, sinumadap i Espiritu na Dios ha nikuna. Ket kinagi ni Sakariyas i kagi na Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kinagi na, “Deyawan tam i Apo Dios, a panahodan tam a taga-Israel! Ta dinumitang hikuna ha nikitam a pinili na, penu sakaan na kitam. Ket pagaan na i gahut tam ha Dios. Ta keggahut kitam ha Dios gipu ha liwaliwat tam. ");
INSERT INTO duo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ket pinaangay na i mapigsa a Mahagsalakan ha nikitam. I Mahagsalakan aye i apo ni Hari Dabid, i tagabu na Dios nikuna a naalay dan. ");
INSERT INTO duo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Ket idi nikuna a naalay dan, inpapugto na Dios ha nidi a minahagpugto, a isalakan na kitam ha kasenti tam a hidi, ket daponan na kitam ha maingal a hidi. ");
INSERT INTO duo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ket inpeta na a kagbiyan na i minappo tam, ket manakam na i kari na ha nidi, idi a naalay dan. ");
INSERT INTO duo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Inkari na Dios ha ni Abraham, i minappo tam, a sawayan na kitam ha kasenti tam a hidi penu awan kitam manteng a magserbe ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Isu, masunosunong mina i pagserbe tam ha Dios. Ket pasig la mappiya mina i pagnakanakam tam. Ket makiuseg kitam mina ha kanayon ha Apo tam a Dios. ");
INSERT INTO duo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ket hikaw, Juan, annak ko, managenan ka nokkan ha ‘Mahagpugto na Dios a Katangkayan.’ Ket hikaw i magpalungo ha ni Cristu nokkan, penu pagayakan mo i tolay a hidi ha pagdemat na. ");
INSERT INTO duo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Hikaw dod i magibaheta ha totolay a mesalakan na hidi na Dios, ket mapakawan na Dios i liwaliwat di. ");
INSERT INTO duo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","“Maanus talaga i Dios a magkagbi ha nikitam. Ta kona ha ide i pinagsalakan na, a kona nu magsenggit i langit nu sinumikatsikat, gipu ta nobos i madiham a kallap. Ket kona bila hito i pinagsalakan na Dios ha nikitam. ");
INSERT INTO duo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","I keangayan na pagdukas tam i kona ha madiham a lugar a kakantengan unay. Ket kona nu dandani kitam a matay gipu ha liwaliwat tam. Ngem niyaen, nu dumemat i Cristu, idisyag na i sulu na a magipu ha langit, penu ipaenta na i dilan a umangay ha Dios.” Nobos dan i pinagpugto ni Sakariyas. Awan dan. ");
INSERT INTO duo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Isu, idi nokkan, dinumakkal ni Juan, ket pinumigsa hikuna ha espiritu na. Ket naghen la hikuna ha luglugar a awan ha sabali a totolay hanggan nagpaenta hikuna ha totolay na Israel, penu magitoldu. ");
INSERT INTO duo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Idi pinakenak ni Juan, naghari ni Hari Agusto. Ket nagpapuhon hikuna ha ngamin a tolay na paghariyan na Roma. Ta inbon ni Hari Agusto a ilista di mina i ngamin a nagen di, penu pagaan di ha korinat i buwis di. ");
INSERT INTO duo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","3","Isu, gipu ta kona hito, nagsoli hidi ngamin ha ili na minappo di, penu magpalista hidi. Iday i nekaesa a pinaglista di, idi naggubernador ni Kirinyo ha Siriya. ");
INSERT INTO duo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ket gipu ta kona hito, linumapos ni Jose, a nesakad ha ni Maria. Ket linakadan na i ili na a Nasaret, ha probinsiya a Galileya. Ket inumangay hidi ha probinsiya a Judeya. Inumangay di Jose ha Betlehem, Judeya, gipu ta iday i ili a nakenakan ni Dabid, i minappo ni Jose. ");
INSERT INTO duo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ket nakiuseg bila a magpalista ni Maria, a nesakad ha nikuna. Ket nabuktet dan ni Maria. ");
INSERT INTO duo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Niyaen, idi naghen hidi ha Betlehem, dinumemat i tiyempo na paggasokan ni Maria. ");
INSERT INTO duo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ket neenak na i panganay a annak na a lallaki. Ket linampenan di hikuna ha tennon. Ket intagmak di hikuna ha pagkanan na kabayo, a nagkilapan na, gipu ta atoy i makpal a tolay ha Betlehem, ket awan ha paghenan di ha pagdagusan a bilay. ");
INSERT INTO duo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Idi kallap heya, ha talon a mabikan ha Betlehem, atoy i magdapon a hidi ha karnero di. ");
INSERT INTO duo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ket bigu la a nagpaenta i esa a anghel. Ket nademlag i kallap, ta nagpaenta bila i demlag na Dios. Ket kinumanteng unay i magdapon a hidi. ");
INSERT INTO duo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ngem inpeta na anghel, “Awan kam manteng. Dinumematak he, penu ipeta ko ha nikam i mappiya a baheta. Ta nokkan, maragsak unay i makpal gipu ha ide a ipeta ko ha nikam. ");
INSERT INTO duo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ta nakoya la, ha niyaen a kallap, ha Betlehem, neenak ni Apo Cristu. Hikuna i paangayan na Dios penu maghari. Ket hikuna nokkan i pakesalakanan moy. ");
INSERT INTO duo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","En moy mina entan. Ket ide i pagilasinan moy, a nu dumitang kam nokkan, maenta moy i annak a nalampenan ken kumakilap ha pagkanan na kabayo,” kon na anghel. ");
INSERT INTO duo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ket bigu la a pumeta i kakpalan a anghel. Nakiagum hidi ha iday a nekaesa. Ket nagkansiyon hidi ha pagdeyaw di ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ide i kinansyon di, a “Deydeyawan tam i Dios hanggan ha kaontokan. Ket matalna mina i totolay ha lutak a kakagbiyan na Dios,” kon na kansiyon he. ");
INSERT INTO duo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sa hidi, sinumoli ha langit. Ket nagkinagi i magdapon a hidi, a “Entamon ha Betlehem penu maenta tam i inpakatandi na Dios ha nikitam.” ");
INSERT INTO duo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Isu, nagsigida hidi, ket naeriyokan di ni Maria, ken ni Jose, ken i annak heya, a umaabbag ha pagkanan na kabayo. ");
INSERT INTO duo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Idi naenta di i annak, inbaheta di i kinagi na anghel megipu ha nikuna. ");
INSERT INTO duo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ket nalaktat i ngamin a nakateman ha baheta di. ");
INSERT INTO duo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ket nanakam ni Maria i ngamin a ito a nagimet. Nanakaman na unay. ");
INSERT INTO duo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ket sinumoli i magdapon a hidi, a dineydeyaw di i Dios gipu ha ngamin a nateman ken naenta di, a tahod a kona ha kinagi na anghel. ");
INSERT INTO duo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Niyaen, idi nekawalo a pamalak na pinangenak na, pinakugit di i annak. Ket pinanagenan di hikuna ha “Jesus”. Ta iday i intoldu na anghel, idi palungo na pinaginaw ni Maria. ");
INSERT INTO duo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Niyaen, dinumemat i pamalak a pagtongpal di Maria ha linteg ni Moyses megipu ha babbey a keenak dan. Ket inyangay di ni Jesus ha Jerusalem, a insaguppang di hikuna ha Templo, a kona ha iyatad di ha Dios i biyag na. ");
INSERT INTO duo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ta nesurat ha Linteg, a meatad mina ha Dios i palungo a annak a lallaki, a pagserbe mina ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ket ide bila i tinongpal di, a “Maski nu heya a babbey a nagenak, masapul na a ipewagah i duwa a alimokan onu duwa a kalapati, ket idatton na ha Dios,” kon na linteg na Dios. ");
INSERT INTO duo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Niyaen, idi inyangay di Maria ni Jesus ha Templo, atoy i esa a lakay a nagen na ni Simyon. Naghen ni Simyon ha Jerusalem, ket inayat na i Dios. Mappiya i nakam na ta kanayon hikuna a nagdeyaw ha Dios. Ket inumusoseg hikuna ha linteg na Dios. Tinahokan na i pakesalakan na Israel ha rigrigat. Ket nagagum ha nikuna i Espiritu na Dios. Inpakatandi na Espiritu a awan hikuna matay hanggan maenta na i Cristu, a paangayan na Dios ha lutak, penu maghari ha ngamin a tolay. ");
INSERT INTO duo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Idi pagdemat di Maria ha Templo, pinanakam na Espiritu na Dios ni Simyon a sumadap bila ha Templo. Ket idi inyangay di Maria ni Jesus ha Templo, penu tongpalan di i linteg na Dios, ket atoy dan ni Simyon. ");
INSERT INTO duo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Inalap na ni Jesus, a kinalkal na. Ket nagdeyaw hikuna ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Ide i kinagi ni Simyon ha Dios, a “Yenan dan, Apo ko, ket tinongpal mo dan i nepakatandi mo ha nikan. Ta naenta ko he i nagipu ha nikaw a mangisalakan ha totolay ha liwat di. Niyaen, masinggat nu matayak, ta naenta ko dan i pangisalakan mo ha totolay. Ket mappiya i katay ko nokkan. ");
INSERT INTO duo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Hikuna i insagana mo penu maenta na ngamin a tolay. ");
INSERT INTO duo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kona ha madisyag a silaw hikuna, a disiyagan na i ngamin a tolay. Ket gipu ha nikuna, madeyawan i totolay a pinili mo, a hikami a nesakop mo ha Israel.” Ide i indeyaw ni Simyon ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Niyaen, nalaktat i hama ken hena ni Jesus ha kinagi aye ni Simyon. ");
INSERT INTO duo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sa na, inkararagan hidi. Ket inpeta na ha ni Maria, “Pinili na Dios i annak mo a mangisalakan ha makpal ha Israel. Ngem atoy bila nokkan i makpal ha Israel a magmadi ha nikuna. Isu a hikuna i pakaparusaan di nokkan. Ket hikuna i kona ha esa a tiplad na Dios. Ngem madiyan na kappal a mangenta ha ide a tiplad, ket sentiyan di hikuna nokkan. ");
INSERT INTO duo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ket gipu ta kona ha ide i pagsenti di, mepaenta na Dios i nakam na totolay, maski i inlimid di. Ket marigatan ka bila nokkan, Maria, ta magladingit ka gipu ha gimetan di ha annak mo. Ket kona ha pangalan di i puso mo nokkan.” Ito i pinagpugto ni Lakay Simyon. Nobos dan. ");
INSERT INTO duo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Kobosan na ide, atoy bila i esa a babbey a mahagpugto. Nabilu hikuna ken babakat dan. Ni Ana i nagen na, a annak ni Panuwel, ken sakop hikuna ha kaputotan ni Aser, a minappo di. Nasurok ha walu a pulo a tawen i idad na. Naalay dan hikuna a nabilu, a pitu la a tawen i pinakiagum na ha kabanga na, sa, natay i kabanga na. Ket niyaen, kanayon a naghen ni Ana ha Templo, a nagdeydeyaw ha Dios, maski nu kallap onu pamalak. Ket nu kappal, nagkabeng hikuna a magkan, penu tumulos a magkararag. ");
INSERT INTO duo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Niyaen, idi nagkagi pala ni Simyon ha di Maria, dinumemat ni Ana. Ket nagyaman hikuna ha Dios. Tulos, a inbaheta na megipu ha annak ha ngamin ha Jerusalem a nagtahotahok ha pakesalakan di. ");
INSERT INTO duo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Niyaen, idi tinongpal di Maria i bobon na Dios megipu ha annak ken babbey a nagenak, nagsoli hidi ha Galileya, ha ili a Nasaret. ");
INSERT INTO duo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ket dinumakkal ni Jesus, ket pinumigsa. Ket linumaing hikuna unay, ket atoy ha nikuna i kagbi na Dios. ");
INSERT INTO duo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ide i ugali na daddakkal ni Jesus, a kadakasinag, inumangay hidi ha Jerusalem, ha Piyesta na Pinagtaleban na Anghel a Magpatay. ");
INSERT INTO duo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Niyaen, idi esa pulo ket duwa i tawen ni Jesus, nakiuseg hikuna ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Idi kobosan na piyesta, nagrubwat hidi a sumoli, ngem nagwarak ni Jesus ha Jerusalem. Ket awan di ito katandi. ");
INSERT INTO duo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kagin di a nakiuseg hikuna ha kakpalan di. Ket linumakad hidi hanggan kallap dan. Sa di, inerieriyok hikuna ha agagum di ken ilailay di. ");
INSERT INTO duo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ngem awan di naeriyokan. Isu nagsoli hidi ha Jerusalem, a erieriyokan di pala. ");
INSERT INTO duo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Idi nekatallu a pamalak na pinageriyok di, netan di hikuna ha Templo, a nakipagetnod ha mamaestro na Judyo. Nagteman hikuna ha nidi, ket atoy bila i insalodsod na ken inpakatandi na ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ket nalaktat hidi ngamin, gipu ta malaing i pagkatandi ni Jesus ken tabbeg na. ");
INSERT INTO duo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ket nalaktat bila di Maria idi naenta di. Sinalodsod na, “Annak ko, apay a ginimet mo ide a nangkakagbi ha nikami? Naalay dan a eriyokan mi ka.” ");
INSERT INTO duo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ket tinabbeg ni Jesus, “Apay a masapulak moy a eriyokan? Awan moy katandiyan a kayat ko a maghen ha bilay na hama ko?” ");
INSERT INTO duo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ngem awan di nakatandiyan i tabbeg na. ");
INSERT INTO duo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sa hikuna, nakiuseg manon a sumoli ha Nasaret, ket natulotulok hikuna ha bobon di. Ngem awan na naleptanan nena na i ngamin a nagimet, a nanakaman na perpermi. ");
INSERT INTO duo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ket dinumadakkal ni Jesus, ket nagbalin hikuna a malaing unay. Ket inayat na Dios hikuna, ket inayat na bila na tolay a hidi. ");
INSERT INTO duo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Idi nekaesa a pulo ket lima a tawen na pinaghari ni Hari Tiberiyo ha Roma, inbon na Dios ni Juan a magitoldu hikuna. Ha ide a Juan, a annak ni Sakariyas, naghen hikuna ha luglugar a awan ha tolay. Tiyempo ito idi naggubernador ni Ponsiyo Piloto ha Judeya. Ket idi nagmayor ni Herod ha Galileya. Ket nagmayor bila i wadi na, a ni Pelipe, ha lugar a Itureya ken Trakonite. Ket nagmayor bila ni Lisanis ha Abiliniya. Ket i katangkayan a padi idi, ni Anas ken ni Kaipas. ");
INSERT INTO duo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Isu, inumangay ni Juan ha ngamin a lugar ha Jordan a nagitoldu. Intoldu na, “Sumina kam ha liwaliwat moy,” kon na, “ket magpabinyag kam ha baggi moy a pangpaenta a napakawan na kam na Dios,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","I ginimet aye ni Juan i kona ha kinagi ni Isayas, a esa a minahagpugto, a “Atoy i mahagibaheta ha luglugar a awan ha bilabilay, ket ide i idulaw na, a ‘Dandani dan a dumemat i Apo Cristu,’ kon na. ‘Maggayak kamon ha pagdemat na, a pasunongan moy dan i paglakadan na. ");
INSERT INTO duo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","6","Matakbuwnan mina i ngamin a alogalog ket mapiesa i ngamin a amugod. Mapasunong mina i nakillu a dilan, ket mapalinnis i magihasgihas, ket katandiyan mina na ngamin a tolay a paangayan na Dios i Mahagsalakan ha nikitam!’” Ide i nepugto ni Isayas, ket ni Juan paman i nangibaheta. ");
INSERT INTO duo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Niyaen, inumangay i kakpalan a hidi ha ni Juan ha karayan, penu magpabinyag hidi. Ket kinagi na ha nidi, “Kona ha ugali na ulag i ugali moy! Makalimot man! Apay kam umangay ha he? Baka kagin moy a makalapsut kam ha parusa na Dios. ");
INSERT INTO duo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ngem ipeta ko ha nikam a masapul a ipaenta moy a nagbabawi kamon gipu ha mappiya a gimet. Ken magbabawi kamon talaga. Ket awan moy ipeta ha baggi moy, ‘Maski, ta kaputotan mi ni Abraham.’ Ta ipeta ko ha nikam a maski ha pogepogedu aye, ay, kaya na Dios a pagbalinan na hidi ha annak ni Abraham. Tahod! ");
INSERT INTO duo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nakaman moy ide, a kona ha wasay i parusa na Dios. Ket kona ha nehektat i wasay na Dios, penu katolan na i kakayo ha ramot di. Ket magkalan kam ha dagento a kakayo. Ha kadakayo a awan magbunga ha mappiya, katolan na nokkan, ket itogbak na ha gangatan,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ket sinalodsod na tolay a hidi, “Isu, nu kona hito, anya mina i gimetan mi?” ");
INSERT INTO duo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ket tinabbeg ni Juan, “Nu atoy i duwa a badu mo, iyatad moy dan i esa ha tolay a awan ha badu na. Nu atoy i kanan mo, ibunong moy dan ha tolay a awan ha kanan na,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ket atoy bila i mahagpabuwis a hidi a kayat di a magpabinyag ha baggi di. Ket sinalodsod di, “Maestro, anya mina i gimetan mi?” ");
INSERT INTO duo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ket tinabbeg ni Juan, “Awan kam magsili-sileng ha ipabuwisan moy. Ket alapan moy la i buwis a nebon na Hari ha Roma,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Atoy bila i sundalu a hidi. Ket sinalodsod di, “Hikami bila. Anya mina i gimetan mi?” Ket tinabbeg ni Juan, “Awan moy pilitan a alapan i korinat na totolay. Ket awan moy hidi pakapakantengan, penu maalap moy i korinat di. Ket esa pala, a awan kam magreklamo ha suweldo moy,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ket gipu ta ide a pinagitoldu ni Juan, nagtahok i tolay a hidi, a ninakam di a mabikan dan i pagdemat ni Cristu. Ket naganakanakam pala hidi nu ni Juan i Cristu a mangisalakan ha nidi ken maghari. ");
INSERT INTO duo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Isu, gipu ha kona hito, intoldu ni Juan ha nidi, “Bakkan a hikan i Cristu. Nu ikalanak moy ha nikuna, awanak ha balle. Ta mas matangkay i Cristu ngem hikan. Maski nu atoy i esa a tagabu a mangadya mina ha sapatos na, awanak kusto gipu ha liwaliwat ko. Ket ide pala, a dinom la i pangbinyag ko ha totolay. Ngem ha Cristu, i Espiritu na Dios ken gangatan i pangbinyag na. ");
INSERT INTO duo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Ta magpasina i Cristu nokkan ha ngamin a tolay. Kona ha esa a mannalon a magtap. Kona bila hito i gimetan na Cristu nokkan. Ta alapan na nokkan i ngamin a tolay, ket kona ha tapan na hidi,” kon ni Juan. “Ket kona ha bigao i pangisina na a mangisap ha totolay. Ta isap na nokkan i mappiya ken madukas. Ket i mappiya a hidi i kona ha baggat. Ngem kona ha lupas i madukas a hidi. I baggat a mappiya, alapan na ket daponan na ha kahenan na. Ngem awan ha balle i lupas heya. Itutod na la ha gangatan a awan maaddap. Ket kona ha iday i Espiritu na Dios ken gangatan a pangbinyag na Cristu nokkan,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kona hito, ket makpal pala i pinagitoldu ni Juan ha totolay. Intoldu na i Mappiya a Baheta megipu ha pakesalakan na tolay, ket intoldu na a isulet di mina i madukas a ugali di ha mappiya a ugali. ");
INSERT INTO duo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ngem ha ni Mayor Herod, hikuna i binahang ni Juan, gipu ta nagkabanga ni Herod ha ni Herodiyas, a kabanga na wadi na. Ket makpal pala i kinadukas na. ");
INSERT INTO duo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ket i dakdakkal a liwat ni Herod i pinagpabalud na ha ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ngem idi palungo a nepabalud ni Juan, atoy i ginimet na. Ta inumangay ha nikuna ni Jesus a magpabinyag ha baggi na. Isu, idi nobos ni Juan a nagbinyag ha makpal a tolay, bininyagan na bila ni Jesus. Sa, nagkararag ni Jesus. Ket idi nagkararag hikuna, kona ha ginumangak i langit, ket inumugsad i Espiritu na Dios, a atoy baggi na a kona ha baggi na kalapati. Ket nagdissu i Espiritu na Dios ha ni Jesus. Ket nagkagi i Dios ha langit, “Hikaw i annak ko a ayayatan ko unay. Matalakak unay ha nikaw,” kon na Dios. ");
INSERT INTO duo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Idi nangrugi i pinagitoldu ni Jesus, manga tallu a pulo a tawen i idad na. Ket ha kagi na totolay, hikuna i annak ni Jose, kona kan. Niyaen, ni Jose i annak ni Eli ");
INSERT INTO duo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","a annak ni Matat. Ket ni Matat i annak ni Lebi, a annak ni Melki. Ket ni Melki i annak ni Jane, a annak ni Jose. ");
INSERT INTO duo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ni Jose i annak ni Matatiyas, a annak ni Amos. Ket ni Amos i annak ni Nahum, a annak ni Esli. Ni Esli i annak ni Nage, ");
INSERT INTO duo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","a annak ni Maat, a annak ni Matatiyas. Ni Matatiyas i annak ni Semey, a annak ni Jose. Ni Jose i annak ni Juda, ");
INSERT INTO duo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","a annak ni Joana. Ket ni Joana i annak ni Resa, a annak ni Sorobabel, a annak ni Salatiel, a annak ni Neri. ");
INSERT INTO duo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ket ni Neri i annak ni Melki, a annak ni Adi. Ni Adi i annak ni Kosam, a annak ni Elmodam, a annak ni Eri. ");
INSERT INTO duo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ni Eri i annak ni Joswe, a annak ni Elieser, a annak ni Jorim, a annak ni Matat. Ni Matat i annak ni Lebi, ");
INSERT INTO duo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a annak ni Simyon, a annak ni Judas. Ket ni Judas i annak ni Jose. Ni Jose i annak ni Jonan, a annak ni Eliyakim, ");
INSERT INTO duo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","a annak ni Meleya. Ni Meleya i annak ni Mena, a annak ni Matata, a annak ni Natan, a annak ni Dabid. ");
INSERT INTO duo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ni Dabid i annak ni Jesse, a annak ni Obed a annak ni Boos. Boos i annak ni Salmon, a annak ni Nason, ");
INSERT INTO duo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","a annak ni Aminadab, a annak ni Aram. Ni Aram i annak ni Arni, a annak ni Esrom, a annak ni Pares. Ni Pares i annak ni Juda, ");
INSERT INTO duo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","a annak ni Jakob. Ni Jakob i annak ni Isak, a annak ni Abraham. Ni Abraham i annak ni Tare, a annak ni Nakor, ");
INSERT INTO duo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","a annak ni Serug, a annak ni Ragaw, a annak ni Peleg. Ni Peleg i annak ni Heber, a annak ni Selah, ");
INSERT INTO duo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","a annak ni Kainan, a annak ni Arpasad, a annak ni Sem. Ni Sem i annak ni Noe, a annak ni Lamek, ");
INSERT INTO duo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a annak ni Matusalem, a annak ni Enok. Ni Enok i annak ni Jared, a annak ni Mahalalel, a annak ni Kainan. ");
INSERT INTO duo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ni Kainan i annak ni Enos, a annak ni Set, a annak ni Adan. Ket ni Adan i annak na Dios, a pinarsuwa na hikuna na Dios. ");
INSERT INTO duo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Kobosan na pinagbinyag ni Jesus, nagsoli hikuna a nagipu ha Jordan. Ket atoy a naghen ha ni Jesus i Espiritu na Dios. I Espiritu na Dios aye i nagpanakam ha ni Jesus a umangay ha luglugar a awan ha tolay hanggan uppat a pulo a pamalak. Ngem atoy bila ni Satanas a nagsolisolisog ha ni Jesus. Ket pulos, awan nagkan ni Jesus ha uppat a pulo a pamalak. Ket kobosan na, nagiyalap unay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sa na, inpeta ni Satanas ha ni Jesus, “Nu tahod a hikaw i annak na Dios, bonan mo mina i pogedu aye a magbalin ha kanan.” ");
INSERT INTO duo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ngem tinabbeg ni Jesus, “Nesurat ha libro na Dios, a ‘Bakkan a kanan la i ikabiyag na tolay,’” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sa na, inyangay ni Satanas ni Jesus ha ontok na parabin. Ket inpaenta na ha sigida i ngamin a kahariyan na ngamin a lutak. ");
INSERT INTO duo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ket kinagi ni Satanas, “Entan mos. Hikaw i atdinan ko ha ngamin a dagende a pagturayan mo ken ikabaknang mo. Ta neyatad dan hidi ha nikan, ket mabalin ko a iyatad ha maski nu heya a kayat ko a pangatadan. ");
INSERT INTO duo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Isu, nu deyawanak mo, hikaw i makinkukuwa ha ngamin a dagende,” kon ni Satanas. ");
INSERT INTO duo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ngem tinabbeg ni Jesus, “Nesurat ha Libro na Dios, a ‘Magdeyaw ka ha Happo mo a Dios la, ket hikuna la i pagserbeyan mo.’” ");
INSERT INTO duo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sa na, inyangay ni Satanas ni Jesus ha Jerusalem, ha bubungan na Templo a managenan ha “Bilay na Dios”. Ket kinagi na ha ni Jesus, “Nu tahod a hikaw i annak na Dios, lumakbong kas. ");
INSERT INTO duo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Awan ka matalingo, ta nesurat ha Libro na Dios, a ‘Ibon na Dios i anghel a hidi a daponan di ka.’ ");
INSERT INTO duo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ket ide bila i nesurat, a ‘Egkaman na ka na anghel a hidi, penu awan ka mesapdul maski ha gihagihay mo.’” ");
INSERT INTO duo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ngem tinabbeg ni Jesus, “Nesurat ha Libro na Dios, a ‘Awan mo pilitan i Apo moy a Dios.’” ");
INSERT INTO duo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Niyaen, idi inubos ni Satanas i ngamin a kalase na solisog na ha ni Jesus, sinumina hikuna hanggan ha sabali a gundaway. ");
INSERT INTO duo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sinumoli ni Jesus ha probinsiya a Galileya, ket atoy ha nikuna i kaddat na Espiritu na Dios. Ket nagwaras i baheta megipu ha ni Jesus ha ngamin a lugar ha Galileya. ");
INSERT INTO duo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ket nagitoldu hikuna ha kapkapilya. Ket dineyaw na hikuna na ngamin a tolay. ");
INSERT INTO duo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Niyaen, inumangay ni Jesus ha Nasaret, a dinakkalan na. Ket idi Sabado, nakikapilya hikuna, a kona ha ugali na. Ket tinumaknag hikuna ha kapilya, penu basaan na i Libro na Dios. ");
INSERT INTO duo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Niyaen, ingiwat di i libro a insurat ni Isayas, a esa a minahagpugto. Ket linakwab na i libro, ket naeriyokan na i nesurat, a ");
INSERT INTO duo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Maghen i Espiritu na Dios ha nikan, ta pinili na ak a magibaheta ha mappiya a baheta ha napobre a hidi. Ket pinaangay na ak ha kona a mebalud a hidi ha kaliduwa di, gipu ha liwaliwat di, penu ipeta ko a malakbes hidi. Ket pinaangay na ak ha kona a mabulsak hidi, penu ipeta ko a maadya i pinagbulsak di. Ket pinaangay na ak ha magkarigat a hidi, penu paadya ko i rigrigat di. ");
INSERT INTO duo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ket pinaangay na ak penu ibaheta ko a dinumemat i tiyempo a panangisalakan na Apo Dios ha totolay na.” ");
INSERT INTO duo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Idi nobos ni Jesus a magbasa, intiklup na i libro. Sa na, ingiwat ha kadaggap na kapilya. Ket inumetnod hikuna a magitoldu. Ket naamatan na ngamin a Judyo a hidi, ta kinayat di a mateman i pagitoldu na. ");
INSERT INTO duo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ket inpeta ni Jesus, “Ha yenan a pamalak, ha saguppang moy, natongpal dan ide a kari na Dios.” ");
INSERT INTO duo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Niyaen, idi nateman di ito, mappiya i nakam di ngamin, ket kinagi di a malaing ni Jesus a magitoldu, ta kayat di i kakkagi na. Ngem nalaktat bila hidi, ta malaing ni Jesus, ngem katandi di hikuna, idi annak pala. Ket kinagi di, “Ni Jose malla i hama na. Apay wade a malaing hikuna?” kon di. ");
INSERT INTO duo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","24","Ket kinagi ni Jesus, “Siguradowak a ipeta moy ide a pagkakagi, ‘Nu tahod a hikaw i doktor, pahusayan mo dan i baggi mo,’ kon moy. Ket ide bila i kakkagi moy, a ‘Ginimet mo kan i makpal a milagro ha Kapernaum, kon na kan. Isu, magimet mo mina i makpal a milagro ha ili mo he a dinakkalan mo,’ kon moy. Ngem ipeta ko ha nikam i sabali a pagkakagi, a ‘Awan hidi magteman ha mahagpugto nu hikuna i kaili di,’ kon na kan. ");
INSERT INTO duo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Tamos. Nakaman moy ni Eliyas, a esa a minahagpugto. Ta idi tiyempo ni Eliyas, awan a naguden ha tallu ket gudwa a tawen. Ket awan ha nakemula. Isu, nesungot hidi. Ket nagiyalap hidi unay. Ket atoy idi i makpal a babbey a nabilu ha bayan tam a Israel. ");
INSERT INTO duo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ngem uray nu kona hito, awan pinaangay na Dios ni Eliyas ha maski esa a nabilu a Judyo a taga-Israel. Imbes na, pinaangay na Dios ni Eliyas ha madiyo, ha sabali a bayan, ha esa a nabilu ha lugar a Sidon, ha ili a Sarepta, maski nu bakkan hikuna a Judyo. ");
INSERT INTO duo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Ket kona bila hito ha tiyempo ni Elisiyo. Hikuna bila i esa a minahagpugto idi. Ket atoy idi i makpal a Judyo a mahagkattal ha bayan tam a Israel, ngem pulos, a awan hidi napahusay. Atoy la i esa a napahusay, ket hikuna i bakkan a Judyo. Ni Naaman i nagen na, a taga Siriya,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Niyaen, idi nateman na ito na Judyo a hidi, nakaingal hidi. ");
INSERT INTO duo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ket dinakap di ni Jesus, a linaged di ha disat, ha hikeg na ontok na ili di. Ta kinayat di a itogbak hikuna ha pagangpang. ");
INSERT INTO duo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngem ha ni Jesus, linumakad la hikuna ha lubuk na kakpalan di, ket natirak la hidi. ");
INSERT INTO duo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Niyaen, inumangay ni Jesus ha probinsiya a Galileya, ha ili a Kapernaum. Ket idi Sabado, nagitoldu ni Jesus ha kapilya na Judjudyo. ");
INSERT INTO duo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ket nalaktat hidi, gipu ta manakabalin i pagitoldu na. ");
INSERT INTO duo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Niyaen, idi nagitoldu pala ni Jesus, atoy i lakay a inawag na dimonyo, ket nangrangsit. ");
INSERT INTO duo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A-e!” kon na. “Katandiyan taka, a hikaw ni Jesus a taga Nasaret. Hikaw i pinaangay na Dios, a maghari! Anya i kayat mo ha nikami? Bunowan mo kami waden a dimonyo,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ngem inbon ni Jesus ha iday a dimonyo, “Awan ka magkagi! Lumapos ka dan. Itirak mo i baggi na!” Ket idi nateman na dimonyo, inwahagit na i baggi na lakay ha saguppang na Judyo a hidi, ket linumapos. Ngem awan na natalingowan i lakay. ");
INSERT INTO duo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ket nalaktat unay i Judyo a hidi. Ket naginuhon hidi ha, “Anya i pagturay ni Jesus aye? Mapigsa i kaddat na,” kon di. “Ta magbon ni Jesus ha didimonyo, ket lumapos hidi,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Isu a nagwaras i baheta a megipu ha ni Jesus ha ngamin a Galileya. ");
INSERT INTO duo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Idi linumapos ni Jesus ha kapilya, inumangay hikuna ha bilay di Simon. Ket nagsaket i manugang ni Simon, a nagladu. Ket inpeta di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Isu a tinumaknag ni Jesus ha hikeg na abak na. Ket inbon na a lumakad i ladu na. Ket linumakad i ladu na aye. Ket inumikat hikuna a dagus, a inlutowan na hidi. ");
INSERT INTO duo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Niyaen, atoy bila i makpal a nagsaket ha iday a lugar. Ket idi kinumaltob i senggit, inyangay na kakpalan i ngamin a ilailay di a nagsaket ha ni Jesus. Ket intupo na i kamat na ha kada esa, ket pinahusay na hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ket pinalakad na bila i dimonyo a hidi ha makpal a tolay. Ket idi linumakad i dimonyo a hidi, inrangsit di, “Hikaw i Annak na Dios!” Ngem binon ni Jesus, a awan na hidi pinalobusan a magkagi, gipu ta katandi di a hikuna i Cristu a pinili na Dios a maghari. ");
INSERT INTO duo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Idi kaugman na, idi maledum, linumakad manon ni Jesus ha lugar a awan ha bilabilay. Ngem inerieriyok na tolay a hidi. Ket idi naeriyokan di, napigsa i pagaged di a maghen ni Jesus ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ngem inpeta na, “Kasor ko a magitoldu ha sabasabali a ili ha Mappiya a Baheta, megipu ha pagdemat na Paghariyan na Dios. Ta ide i kayat na Dios a gimetan ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Isu, nagitoldu ni Jesus ha makpal a kapilya na Judyo, ha ngamin a lugar a Judeya. ");
INSERT INTO duo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Idi esa a pamalak, nagitoldu ni Jesus ha baybay, ha diget na Genesaret. Ket atoy bila hay i makpal a tolay. Ket nagtatinoglad hidi, ta kayat di a makateman ha kagi na Dios. ");
INSERT INTO duo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Niyaen, naenta ni Jesus a atoy hay i duwa a abang. Ket atoy bila di Simon a mahagpadut, a nagugeuges ha sigay di. ");
INSERT INTO duo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sinumadap dod ni Jesus ha abang ni Simon, ket inaged na a ipalubuk di ha ballik la. Ket inumetnod ni Jesus, a nagitoldu. ");
INSERT INTO duo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Idi kobosan na pinagitoldu na, inpeta na ha ni Simon, “Ipalubuk moy pala ket magdaklis kamon ha kabtongan, ta makaalap kam ha makpal ihay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Maestro,” kinagi ni Simon, “nagdaklis kami a nakallapan, hanggan ha maledum, ngem buwisit kami la. Ngem nu ipeta mo, magdaklis kami manon,” kon ni Simon. ");
INSERT INTO duo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Isu a nagdaklis manon hidi. Ket nakaalap hidi ha makpal, hanggan dandani dan a mapisad i sigay di. ");
INSERT INTO duo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ket pinayapayan di i agagum di, ha sabali a abang, a aguman di mina hidi. Ket idi dinumitang hidi, pinutat di i dagenday a abang ha padut, hanggan dandani dan a umlad i abaabang di. ");
INSERT INTO duo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9-10","Ay, nalaktat di Simon, gipu ta makpal i padut a naalap di. Niyaen, idi naenta ni Simon Pedro i naalap di, nagparentumeng hikuna ha saguppang ni Jesus, a kinagi na, “Apo, umadiyo kas ha nikan, ta makpal i liwat ko,” kon na. Ket Nalaktat bila i agagum ni Simon, a ni Santiyago ken i hekka na, a ni Juan. Hidi i annak ni Sebedeyo. Ngem inpeta ni Jesus ha nidi, “Awan kam manteng. Ta hanggan yenan, ket hikam i mahagalap ha padut. Ngem ha niyaen a pamalak, sulitan ko i tarabaho moy. Niyaen, hikam i mahagpuhon ha tolay a sibibiyag ha Paghariyan na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ket dinumong hidi ha abang di, ket intirak di i ngamin, ket inumuseg hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Idi sabali a pamalak, naghen ni Jesus ha sabali a ili. Ket atoy i esa a lakay a mahagkattal. Idi naenta na ni Jesus, hinumakab hikuna ha saguppang na, a inaged na, “Apo, nu kayat mo, mapahusay mo i baggi ko!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ket kinagi ni Jesus, “Kayat ko.” Ket intupo na i kamat na, a inpeta na, “Mahusay ka dan!” Ket bigu la a naawan dan i kattal na. ");
INSERT INTO duo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ket inbon ni Jesus ha nikuna, “Awan ka dan magkagi ha maski nu heya. Imbes na, magdiretso ka ha padi, penu bilengan na ka. Ket iyatad mo ha nikuna i pangiyatad mo, penu matongpal i bon ni Moyses a nesurat ha Libro na Dios. Ket nu gimetan mo ide, mapanahod mo hidi ngamin a pinahusay na ka na Dios,” kon ni Jesus ha nagkattal. ");
INSERT INTO duo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ngem maski nu kona hito, mapigsa pala i pagkewaras na baheta megipu ha ni Jesus hanggan makpal a lugar. Ket dinumitangditang i kakpalan a tolay, penu magteman ha pagitoldu ni Jesus, ken magpahusay mina ha saket di. ");
INSERT INTO duo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ngem i kagangay ni Jesus a umadiyo ha sabali a lugar a kasaw, penu makakararag hikuna a esesa. ");
INSERT INTO duo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Idi esa a pamalak, a nakangtoldu ni Jesus, ket atoy bila i kappal a Pariseyo ken maestro a hidi na Linteg. Inumetnod hidi ha saguppang na, a nagteman ha kakkagi na. Nagipu hidi ha il-ili ha probinsiya a Galileya, ken probinsiya a Judeya, ket atoy bila i kappal a nagipu ha Jerusalem. Ket atoy ha ni Jesus i kaddat a pangpahusay ha masaket a hidi. ");
INSERT INTO duo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Niyaen, idi nagitoldu pala ni Jesus, dinumitang i kappal a lallaki a nangisew ha esa a napilay i duwa a tikad na. Ket pinadas di a sumadap ha bilay, penu itagmak di i pilay aye ha saguppang ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ngem awan hidi nakasaddap ha bilay, gipu ta naputat i bilay ha makpal a tolay. Inyontok di dod ha atap na bilay, ket binotbot di, sa di, intostos i pilay aye ha saguppang ni Jesus, ha lubuk na kakpalan. ");
INSERT INTO duo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ket idi nakatandiyan ni Jesus a dakkal i panahod di, a nagkona hito, inpeta na ha pilay, “Abeng, napakawan dan i liwaliwat mo.” ");
INSERT INTO duo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Niyaen, idi nateman na ito na mamaestro na Linteg ken Pariseyo a hidi, nagkinagi hidi ha, “Anya dod! Heya i lallaki aye a sinangdidios? Heya i makapakawan ha liwat na tolay, nu awan la i Dios! Awan ha sabali,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ngem nakatandiyan ni Jesus i nakam di, ket kinagi na, “Apay a kona hay i nakam moy? ");
INSERT INTO duo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Makatandiyan moy mina i turay na Annak na Dios a Nagbalin a Tolay. Isu, niyaen, aamatan moy ide a pilay. Ta awan ha turay ha maski nu heya a tolay a makepeta ha ide a pilay, ‘Mapakawan dan i liwaliwat mo!’ Ket awan ha turay ha tolay a makepeta ha, ‘Umikat ka! Makalakad ka dan!’ Tamos. Ngem ha nikan, makapaenta ak a atoy i turay ko a mangpakawan ha liwat na tolay,” kon ni Jesus. Ket inpeta na ha iday a pilay, “Ilay ko, umikat ka, alapan mo i ulas mo, ket magsoli ka dan ha bilay moy,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ket inumikat a dagus i napilay. Ket inalap na i ulas na, ket nagsoli hikuna ha saguppang di. Ket dakkal i pinagdeyaw na ha Dios! ");
INSERT INTO duo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Isu, nasbew hidi ngamin, ket dineyaw di bila i Dios. Kinagi di, “Ide i dakkal a milagro a naenta tam ha yenan a pamalak,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kobosan na ide, linumakad manon ni Jesus. Ket naenta na i esa a mahagsinger ha buwis a magetnod ha pahagsingeran na. Lebi i nagen na. Ket inpeta ni Jesus ha ni Lebi, “Umuseg ka dan ha nikan, penu matolduwan taka,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ket tinumaknag ni Lebi, a intirak na i ngamin, ket inumuseg hikuna ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Niyaen, insagana ni Lebi i dakkal a pangapon para ha di Jesus. Ket atoy bila ha ni Lebi i makpal a mahagpabuwis, ken makpal a sabali a totolay. ");
INSERT INTO duo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ket atoy bila hay i Pariseyo a hidi ken mamaestro na Linteg, a nangaamata ha totolay a inawis ni Lebi ha pangapon na. Ket nagadimalmal hidi ha agagum ni Jesus a tolduwan na. “Apay a makipagkan kam ha nidi a mahagpabuwis para ha Roma, ken ha madukas a agagum di?” kon di. ");
INSERT INTO duo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ngem nateman na ito ni Jesus, a hikuna i tinumabbeg ha nagadimalmal a hidi. Kinagi na, “Nu mahusay i baggi na tolay, awan na masapul i doktor. I magsaket la i makasapul ha doktor. ");
INSERT INTO duo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ket kona bila hito ha nikan a magpababawi. Ta awanak inumangay ha he penu pagbabawiyan ko i mappiya a tolay a awan ha liwat. Imbes na, inumangayak ha he penu pagbabawiyan ko i madukas a totolay a makatandi a kelliwat hidi,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Idi esa a pamalak, atoy i kappal a nangipeta ha ni Jesus, “Ha toltolduwan ni Juan, magkekabeng hidi a magkan, a pangdeyaw di ha Dios ken ha pagkararag di, ket magkalan bila ha toltolduwan na Pariseyo a hidi. Ngem sabali ha toltolduwan mo. Ta magkan ken uminom hidi ha kada pamalak!” kinagi di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ket tinabbeg ni Jesus, “Oni, ta kona ha ide a ipeta ko ha nikam. Nu atoy i pagbodaan, ken atoy i nobyo ken agagum na, anya wade, magkan hidi, onu awan? Siyempre agay! Makiragsak hidi! ");
INSERT INTO duo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ngem dumemat nokkan i sabali a tiyempo, ket madakap i nobyo, ket mepaadiyo hikuna. Agay, ide i tiyempo a magkabeng hidi a magkan, ta mematon hidi,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ket intulos ni Jesus i pagitoldu na, penu makatandiyan di i kasabaliyan na bigu a pagitoldu na, ken alegid a pagitoldu na Pariseyo a hidi. Kinagi na, “Nu atoy i mayat a magpisad ha badu na, awan hikuna magpisad ha bigu a badu, penu metakop na ha badu a alegid. Gipu ta, nu padasan na ito, pinisad na dan i bigu a badu na, ket awan mekusto i bigu a pegkat ha badu a alegid. ");
INSERT INTO duo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ket kona bila ha ide. Awan a mabalin nu mangiyasak ka ha bigu a basi ha alegid a supot a gaddang, ta mapadtak na bigu a basi iday a supot, ket magabuyos i bigu a basi, ket napisad dan i supot. ");
INSERT INTO duo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mappiya malla nu mangiyasak ka ha bigu a basi ha bigu bila a supot a gaddang. ");
INSERT INTO duo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ket kona pala ha ide. Nu atoy i esa a tolay a kanayon uminom ha basi a alegid, awan kan masinggat i bigu a basi, kon na kan. ‘Mas masinggat i alegid a basi,’ kon na.” Ide i kinagi ni Jesus megipu ha kasabaliyan na bigu a pagitoldu na ken alegid a pagitoldu na Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Idi esa a Sabado, naglakalakad di Jesus ha talon. Ket atoy i toltolduwan ni Jesus, a nangrugi hidi a magaphok ken magkasel ken magkan ha dawa. ");
INSERT INTO duo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ngem atoy bila i Pariseyo a hidi, ket kinagi di, “Apay? Maggimet kam ha maneg ha Linteg tam megipu ha Sabado,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Ket tinabbeg ni Jesus, “Awan agay! Apay? Ta maski ha ni apo Dabid, awan moy nabasa i ginimet na, ken agagum na? Ta idi nagiyalap di Dabid, sinumadap hidi ha bilay na Dios, ket inakot ni Dabid i tinapay a pangatdinan na papadi ha Dios. Ket nagkan hikuna ha denday, ket ingiwat na bila ha agagum na, maski nu papadi la i mapalobusan a magkan ha iday a kalase na tinapay. Ta kona hito i turay ni Dabid,” kon ni Jesus. Ket kinagi na pala, ");
INSERT INTO duo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“Anya dod ha turay ko? I Annak na Dios a Nagbalin a Tolay i magkagi mina nu anya i tahod a gimetan ha Sabado,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Idi nokkan, ha sabali a Sabado, sinumadap ni Jesus ha esa a kapilya, a nagitoldu. Atoy bila hay i lakay a napilay ha kanawan a kamat na. ");
INSERT INTO duo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ket siniiman na ni Jesus na mamaestro na Linteg ken Pariseyo a hidi, gipu ta kayat di a paliwatan ni Jesus. Isu a inaamatan di a perpermi, penu maenta di nu magpahusay ni Jesus, uray ha Sabado. ");
INSERT INTO duo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","9","Ngem nakatandiyan ni Jesus i nakam di, ket inpeta na ha napilay, “Katalakay, tumaknag ka, ket umangay ka bi ha he, ha saguppang,” kon na. Niyaen, idi inumikat i napilay, ket inumangay ha ni Jesus, kinagi ni Jesus ha Pariseyo a hidi ken mamaestro na Linteg, “Anya i nakam moy megipu ha Sabado? Anya i bagbagay a ipalobus na Linteg a gimetan tam ha Sabado? Anya wade, mepalobus na i mappiya, onu madukas? Anya, magsalakan kitam mina ha totolay, onu kabengan tam hidi a maski matay?” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa na, inaamatan ni Jesus hidi ngamin, ket inpeta na ha napilay aye, “Iyuyad mo dan i kamat mo,” kon na. Ket idi inyuyad na i kamat na, napahusay dan. ");
INSERT INTO duo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ngem naingal unay i Pariseyo a hidi ken mamaestro na Linteg, ket nakipaggammong hidi nu anya mina i gimetan di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Idi tiyempo hito, tinumagdak ni Jesus ha amugod, a nagkararag ha Dios. Ket naghen hikuna ha disat, a nagkararag ha Dios hanggan maledum. ");
INSERT INTO duo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Idi maledum, inayagan na i tolduwan na a hidi. Ket pinili na i esa pulo ket duwa a pinanagenan na ha “Apostol.” ");
INSERT INTO duo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","I nagen di ni Simon, a insangay na ha “Pedro.” Ken ni Andres, i wadi na, ken ni Santiyago ken ni Juan, ni Pelipe ken ni Bartolome, ");
INSERT INTO duo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ni Mateo ken ni Tomas, ken ni Santiyago a annak ni Alpeyo, ken ni Simon a matured, ");
INSERT INTO duo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ken ni Judas a annak ni Santiyago, ken ni Judas Iskaryote a nagbalin a maglipot. ");
INSERT INTO duo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Idi binumugsok ni Jesus ken apostol a hidi ha ditaw, atoy dan i kakpalan a tolduwan na a nagururay. Ket atoy bila i makpal a tolay a naggipu ha Judeya, sa Jerusalem, sa ha il-ili a Tiro ken Sidon ha baybay na diget. ");
INSERT INTO duo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Inumangay hidi penu magteman ha ni Jesus, ket magpahusay mina ha sakisaket di. Ket inumangay bila i makpal a pinaawag na dimonyo. Ket napahusay bila hidi. ");
INSERT INTO duo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ket mayat na kada esa a umegkam ha ni Jesus, ta atoy i magipu ha nikuna a kaddat, a mangpahusay ha nidi ngamin. ");
INSERT INTO duo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Idi nangenta ni Jesus ha toltolduwan na, kinagi na, “Mappiya i kasasaad moy nokkan, hikam a mapadibi niyaen, Ta hikam man i ayayatan na Dios. Ket sakopan na kam ha paghariyan na. ");
INSERT INTO duo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ket hikam i kona ha magiyalap ha kakkagi na Dios. Ket mappiya i kasasaad moy, ta kona ha mapha kam nokkan. Ket ha nikam a magsanget gipu ha liwaliwat moy, mappiya i kasasaad moy, ta paragsakan na kam nokkan na Dios. ");
INSERT INTO duo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mappiya i kasasaad moy nu englan na kam na totolay, nu madiyan di kam, nu pasanikiyan di kam, onu ikagi di a madukas kam ta makiuseg kam ha Annak na Dios a Nagbalin a Tolay. ");
INSERT INTO duo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nu magimet i kona ha ide ha nikam niyaen, magragsak kam mina. Gipu ta dakkal i gungguna moy nokkan ha langit. Ta kona bila hito i pinagloko di ha minahagpugto a hidi ha nikuna a naalay dan. ");
INSERT INTO duo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngem ha nikam a sabali, a mabaknang niyaen, kagbi kam agay. Ta lompas nokkan i malaka a biyag moy! ");
INSERT INTO duo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ket ha nikam a kanayon mapha, kagbi kam. Ta mesungot kam nokkan! Ket ha nikam a kanayon a magragsak, kagbi kam. Ta maladinget kam nokkan ket magsangisanget! ");
INSERT INTO duo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kagbi kam nu mappiya i kagi na kakpalan a tolay megipu ha nikam niyaen. Ta kona bila hito i nagimet nikuna, idi kinagkagi na kakpalan a mappiya i ngamin a masileng a minahagpugto a hidi. ");
INSERT INTO duo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ide i kayat ko ipeta ha nikam ngamin a magteman,” kon ni Jesus. “Kagbiyan moy i kasenti moy a hidi. Ket paggimet moy i mappiya ha nidi a maingal ha nikam. ");
INSERT INTO duo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ket nu pagkagiyan di kam, ikagi moy i pangpahusay ha nidi. Ket ikararagan moy hidi a magloko ha nikam. ");
INSERT INTO duo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nu atoy i magdanog ha padingel mo, palobusan mo hikuna a magdanog ha kalipat na. Onu atoy i mangalap ha kagay mo, kabeng mon nu mangalap bila ha badu mo. ");
INSERT INTO duo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iyatad mo ha maski nu heya a umaged ha nikaw. Ket nu atoy i alapan di ha nikaw, awan mo pesoli. ");
INSERT INTO duo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ket gimetan mo ha kakalan mo a tolay i kayat mo a magimet ha nikaw. ");
INSERT INTO duo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Awan moy kagin a gunggunaan na kam na Dios nu kagbiyan moy i tolay a magkagbi bila ha nikam. Awan agay. Ta maski i mahagliwat a hidi, kagbiyan di bila i tolay a magkagbi ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","O kona bila nu aguman moy i tolay a magagum bila ha nikam, awan na kam magunggunaan na Dios gipu ha iday. Iday i kona bila ha ugali na mahagliwat a hidi. ");
INSERT INTO duo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","O kona bila nu ipasallu moy ha nidi a makesoli. Agay, awan na kam magunggunaan na Dios. Ta iday i kona ha ugali na mahagliwat a hidi. Ta ipasallu di ha kakalan di a tolay, nu sigurado a mesoli i gahut di nokkan. ");
INSERT INTO duo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Niyaen, ipeta ko ha nikam. Bakkan mina i ugali moy. Kagbiyan moy i kasenti moy a hidi, ket daggapan moy hidi. Ipasallu moy ha nidi, ket awan moy nakaman a sulitan di nokkan. Nu kona ide i gimetan moy, atoy ha nikam nokkan i dakkal a gungguna. Ket mepaenta moy ha ngamin a tolay a nagbalin kam a annak na katangkayan a Dios. Ta Dios bila i magdaggap ha maski nu heya, maski ha madukas a hidi ken makemot a hidi. ");
INSERT INTO duo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Isu, niyaen, ahegan moy i ugali na Hama moy. Ket mamagkagbi kam a kona ha pagkagbi na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ket tinumulos ni Jesus, “Nu awan moy itoldu i liwat na kakalan moy a tolay, ket awan itoldu na Dios i liwaliwat moy. Awan moy irarumen i kakalan moy a tolay, ket awan na kam bi a irarumen na Dios. Magpakawan kam ha kakalan moy a tolay, ket pakawanan na kam na Dios. ");
INSERT INTO duo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Atdinan moy i kakalan moy a tolay, ket atdinan na kam bi na Dios. Nu kona ha ide i ugali moy, atdinan na kam na Dios ha makpal, agay, sobra ha kaya moy a tawedan. Gipu ta, i bagbagay a gimetan moy ha sabali a tolay, iday bila i gimetan na Dios ha nikam nokkan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ket ide bila i nepakatandi ni Jesus ha nidi. Kinagi na, “Awan a mabalin nu kabitan na bulsak i kakalan na a bulsak. Nu padasan na, matakneg hidi a duwa ha abot. ");
INSERT INTO duo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Onu kona bila ide. Awan a mas malaing i estudyante ngem ha maestro na. Ngem ha maski nu heya a magbalin a estudyante, ha kobosan na pinagadal na, maaheg na i maestro na, ken kinalaing na. ");
INSERT INTO duo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ket kona bila hito ha nikam. Awan mo ulewan i agum mo gipu ha ballik a liwat na, nu dakdakkal i liwat na baggi mo. Iday i kona nu atoy i ballik a as-as ha mata na, ket atoy i dakkal a kayo ha mata mo. ");
INSERT INTO duo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ket ipeta mo ha nikuna, ‘Abeng, maadyan ko bi i as-as ha mata mo ah,’ kom mo. Ngem awan ka pala makaenta, ta dakkal i kayo ha mata mo. Agay! Aginpappiya ka nu kona hito! Imbes na, hikaw mina i magpalungo a magadya ha dakkal a kayo ha mata mo, penu makaenta ka ha madinnang. Sa mo, maadya i as-as ha mata na agum mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ket ide pala,” kon ni Jesus, “nu atoy i mappiya a kayo, awan hikuna magbunga ha madukas. Onu atoy i kayo a masaket, awan hikuna magbunga ha inaamakan. ");
INSERT INTO duo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ha maski nu anya a nemula, katandiyan moy nu inaamakan, onu awan ha balle na, nu maenta moy i bunga na. Ta awan moy maputi i mangga ha madukas a kayo a maseset. Ket awan moy maalap i masinggat a bunga ha madukas a kayo. ");
INSERT INTO duo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ket kona bila hito ha totolay. Nu mappiya i nakam na tolay, mappiya bila i gimetan na, ket mappiya i pagkagi na. Ngem nu madukas i nakam na tolay, madukas bila i gimetan na, ket madukas i pagkagi na. Ket kona hito i nakam na totolay. Ta maski nu anya i dakdakkal ha nakam na tolay, iday bila i gimetan na nokkan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ket tinumulos ni Jesus, “Apay a nagenanak moy ha Happo moy, ngem awan moy tongpalan i bon ko? ");
INSERT INTO duo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Malaing i maski nu heya a umuseg ha nikan penu magteman ken magtongpal ha kagi ko. Ket ipakatandi ko ha nikam i kakalan na. ");
INSERT INTO duo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ta mekalan hikuna ha esa a lallaki a nagpataknag ha malagda a bilay. Ket ha palungo, nagkotkot hikuna ha madisalad, penu itolnak na i adigi a hidi. Ket nokkan idi dinumemat i bagyo, ket dinuminum i karayan, maski nu naabot na karayan i bilay na, awan narakrak i bilay, ta inamakan i pinagbilay na lallaki aye. ");
INSERT INTO duo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Ngem ha sabali a tolay a makateman ha kakkagi ko, ngem awan umuseg, hikuna i kona ha lallaki a awan nagtolnak ha adigi na ha madisalad. Ket idi dinuminum i karayan, malaka la i pinakarakrak na iday a bilay. Ket nebulod i ngamin,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kobosan na pinagitoldu ni Jesus, inumangay hikuna ha Kapernaum. ");
INSERT INTO duo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Atoy hito i kapitan na esa a gasut a sundalu a taga Roma. Ket atoy bila ha nikuna i tagabu na a kakasokasoran na. Ngem nagsaket i tagabu na aye. Ket dandani a matay. ");
INSERT INTO duo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Isu, idi nabaheta na kapitan ni Jesus, pinaangay na i ilailay na a umaged ha ni Jesus, a umangay mina a magpahusay ha tagabu na aye. Ket i ilay na a hidi i panglakayan na Judyo. ");
INSERT INTO duo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Idi dinumemat hidi ha ni Jesus, inaged di unay, a “Dagapan mo bas ni kapitan,” kagi di. “Ta maski bakkan hikuna a Judyo, kagbiyan na kitam a Judyo, ket hikuna i nagpataknag ha kapilya mi,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Niyaen, nakiuseg ni Jesus ha nidi. Ket idi nabikan di Jesus ha bilay di Kapitan, pinaangay na Kapitan i ilailay na ha ni Jesus, penu petan di hikuna, a “Apo, i kayat na Kapitan a awan ka tumulos ha bilay na, ta masaniki kan hikuna ha nikaw. Ta mas matangkay ka ngem hikuna. ");
INSERT INTO duo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ket gipu ta kona hito, Apo, awan hikuna inumangay ha nikaw, ta masaniki. ‘Manakabalin ni Jesus,’ kon na. ‘Uray nu ipeta na a mahusay dan i tagabu ko, magimet iday a kona ha ipeta na,’ kon na. ");
INSERT INTO duo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","‘Katandiyan ko ito gipu ta kona bila hito ha nikan,’ kon na. ‘Ta atoy bila i happo ko a mangituray ha nikan, ket atoy i sunsundalu a magtarabaho ha nikan, ket meturayan ko hidi,’ kon na. ‘Nu ipeta ko ha esa a umangay ka,’ siyempre, umangay hikuna. Nu ipeta ko ha sabali a ‘uyoy ka he,’ siyempre, dumemat hikuna ha nikan. Nu ipeta ko ha tagabu a ‘gimetan mo ide,’ maggimet hikuna ha iday. Isu, katandiyan ko a nu atoy a ipeta ni Jesus, ‘siguradowak a magimet iday,’ kon ni Kapitan.” Ket ide i inbaheta di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ket nalaktat ni Jesus, idi nateman na i kinagi na Kapitan. Sinumoleg hikuna, ket inpeta na ha kakpalan a hidi a inumunod, “Tahod a ipeta ko ha nikam, a hanggan niyaen, awan ko naenta i panahod a mas mapigsa ngem ha ide. Ha maski nu heya a Judyo, awan hidi manahod ha nikan a kona ha ide a kapitan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sa, sinumoli i ilailay na Kapitan, ket idi dinumemat hidi ha bilay na, naenta di a nahusay dan i tagabu na. ");
INSERT INTO duo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Idi kobosan na hito, inumangay di Jesus ha ili a Nain. Ket inumuseg bila i tolduwan na a hidi ken kakpal pala. ");
INSERT INTO duo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Idi dinumemat hidi ha saddap na ili, natagbu di i kakpalan a linumalapos. Nangiyangay i kakpalan aye ha esa a natay, a ilabbang di. Ket ito a minatay i esa a lallaki a kaili di, ken annak na esa a nabilu. Hikuna i esesa la a annak na. ");
INSERT INTO duo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Idi naenta ni Apo Jesus iday a nabilu, kinagbiyan na unay. Ket inpeta na ha nikuna, “Manay, awan kas magsanget,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ket binumikan ni Jesus ha longon, a kinamhet na. Ket tinumaran i lallaki a hidi a nangisew. Ket inpeta ni Jesus ha lallaki a minatay, “Wadi ko! Umikat ka dan!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ket inumetnod i lallaki a minatay, ket nangrugi hikuna a magkagi. Sa na, inyatad hikuna ni Jesus ha nena na. ");
INSERT INTO duo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nasbew hidi ngamin, ket dineyaw di i Dios. “Dinumemat ha nikitam i manakabalin a mahagpugto,” kon di. Ket, “Dinumemat i Dios ha nikitam, penu isalakan na kitam a pinili na,” kon di man. ");
INSERT INTO duo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ket nagwaras i baheta megipu ha ni Jesus ha ngamin a lugar ayo, ha probinsiya a Judeya, ken ngamin a lugar ha kalipat na. ");
INSERT INTO duo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Niyaen, maski ha ni Juan a mahagbinyag, nakabaheta bila hikuna, maski naghen hikuna ha pagbaludan. Ta inbaheta na agagum na i ngamin a ginimigimet ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ket pinaangay ni Juan i duwa a agum na a magsalodsod ha ni Jesus, nu tahod a hikuna i lallaki a pinaangay na Dios a maghari, onu maguray mina hidi ha sabali. ");
INSERT INTO duo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ket idi inumangay i agagum ni Juan ha ni Jesus, kinagi di, “Pinaangay na kami ni Juan a Mahagbinyag, penu magsalodsod nu hikaw i lallaki a pinaangay na Dios a maghari, onu urayan mi pala mina?” kon di. ");
INSERT INTO duo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ket ha iday a pamalak, pinahusay ni Jesus i makpal a tolay a nagsaket, a naawag, ken hidi a nabulsak. ");
INSERT INTO duo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ket tinabbeg ni Jesus i agagum ni Juan, “Sumoli kam ha ni Juan, ket ipeta moy i naenta ken nateman moy. Ta makaenta i nabulsak a hidi. Ket makalakad manon i napilay a hidi. Ket mepabigu i gaddang na magkattal. Ket makateman i nagbangag a hidi. Ket napabiyag manon i minatay a hidi. Ket metoldu i mappiya a baheta ha nidi a napobre. ");
INSERT INTO duo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ket mappiya i kasasaad na maski nu heya a awan mangadya ha panahod na ha nikan.” Ide i inpeta ni Jesus, penu ibaheta di ha ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Niyaen, idi linumakad i agagum ni Juan, nagkagi ni Jesus megipu ha ni Juan ha nidi a kakpalan. Kinagi na, “Idi inumangay kam ha ni Juan ha kasaw a lugar, anya i kayat moy maenta? Anya i nakam moy megipu ha ni Juan aye? Kayat moy wade maenta i esa a malupoy, a magtokham ha pigsa na sabali? ");
INSERT INTO duo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Onu kayat moy maenta i lallaki a magtennon ha inaamakan? I mabaknang a hidi a maghen ha bilay na hari, hidi la i mahagtennon ha inaamakan. Ta hidi la i malaka a biyag. Awan man ha ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Apay wade a inumangay kam ha ni Juan? Penu maenta moy i mahagpugto na Dios? Oni! Iday i kayat moy maenta, ket tahod a ni Juan i esa a mahagpugto. Ngem atoy pala i naenta moy. ");
INSERT INTO duo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","28","Ta ni Juan i paketolduwan na Libro na Dios, a idi inpeta na Dios ha Cristu a, ‘Ipalungo ko i esa ha nikaw a mangibaheta megipu ha nikaw, ket magayakan na i totolay ha pagdemat mo,’ kon na Dios ha Cristu. Ket ni Juan i lallaki aye a nagpalungo. Ket ipeta ko ha nikam,” kagi ni Jesus, “a mas matangkay ni Juan ngem ha ngamin a tolay ha lutak! Ngem ha paghariyan na Dios, uray i madibbi a tolay i mas matangkay ngem ha ni Juan.” ");
INSERT INTO duo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ket intulos ni Jesus a kinagi na, “I tolay a hidi a nagteman ha ni Juan, pati i mahagsinger ha buwis a hidi, nagoni hidi ha Dios, ket nagpabinyag hidi a kona ha pagtiplad na pinagbabawi di ha liwaliwat. ");
INSERT INTO duo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ngem i Pariseyo a hidi ken mamaestro na linteg, inumadi hidi ha pagayatan na Dios ha biyag di. Ket nagmadi hidi a magpabinyag ken magbabawi ha liwat di. Ta madiyan di i pinagitoldu ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Niyaen,” intulos ni Jesus, “anya dod i pangikalanan ko ha dagende a tolay? ");
INSERT INTO duo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mekalan ko hidi ha annak a umetnod ha sentro. Ket idulaw na kappal ha kagayam di, ‘Intukaran mi kam, ngem awan kam nagsala!’ kon di. Ket idulaw di pala, ‘Nagimaton kami, ngem awan kam inumuseg ha pinagsanget mi!’ kon di. Ket kona bila hito ha dagende a tolay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Ta idi dinumemat ni Juan, nagkekabeng hikuna a magkan. Ket awan hikuna naginum ha arak. Isu, i pinagkagikagiyan na kappal a, ‘Nahayop dan hikuna!’ kon di. ");
INSERT INTO duo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ngem idi dinumematak bila, i Annak na Dios a Nagbalin a Tolay, ket nakipaganak, ken nu kappal, naginumak ha arak. Ket pinagkagikagiyan na kappal, ‘Entan moy! Maddamot unay hikuna, ket makanginum ha arak. Ket makiilay hikuna ha madukas a hidi, pati i mahagsinger a hidi ha buwis,’ kon di. ");
INSERT INTO duo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ngem uray nu atoy i kappal a magmadi ha ni Juan ken ha nikan, kabeng moy iday,” kagi ni Jesus. “Ta Apo Dios i nagpaangay ha nikami. Ket ha totolay a umunod ha nikami, hidi i magpatahod a masirib i Dios, ta maggimet hidi ha mappiya,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","38","Niyaen, atoy i esa a Pariseyo a nagen na ni Simon. Ket nagawis hikuna ha ni Jesus a makipagkan ha bilay di. Ket atoy bila ha iday a ili i esa a babbey a madukas, kon na kan. Idi nakabaheta hikuna a magkan ni Jesus ha bilay di Simon, inalap na babbey i esa a praskita na langis a pangpasarob. Ket inumangay hikuna ha bilay di Simon a Pariseyo. Idi dinumemat ni Jesus, ken inumetnod a magkan, inumangay bila i babbey ha adag na, ha hikeg na tikad na. Ket nagsangisanget unay i babbey aye. Ket binisabisa na i tikad ni Jesus ha luwaluwa na. Sa na, pinunasan ha buk na, ket inammosan na i tikad ni Jesus. Ket inbulak na i langis a pangpasarob ha tikad ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Idi naenta na ito na Pariseyo, ninakam na, a “Nu tahod a mahagpugto ni Jesus, makatandiyan na mina a madukas ide a babbey. Ket ikemot na mina a magegkam ha baggi na,” kon ni Simon ha nakam na. ");
INSERT INTO duo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ket kinagi ni Jesus ha nikuna, “Simon,” kon na, “atoy i kayat ko a ipeta ha nikaw.” “Oni ah,” kinagi ni Simon, “Ipeta mos, Maestro,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ket inestoriya ni Jesus, “Idi kwan, atoy i esa a lakay a nangipasalu ha korinat ha duwa a lallaki. Ket ginahut na i esa ha lima a gasut. Ket ginahut na i sabali ha lima a pulo. Ta nagaged hikuna ha lima a pulo la. ");
INSERT INTO duo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ket idi nokkan, nagkalan hidi duwa, a awan hidi nakapagga ha gahut di. Ngem pinakawan na lakay i gahut di. Lima a gasut ha esa, ken lima a pulo ha iday a sabali. Niyaen, anya ha nakam mo? Heya i magayat ha lakay aye ha dakdakkal?” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ket tinabbeg ni Simon, “I lallaki a nakagahut ha dakdakkal, gipu ta dakdakkal i napakawan na lakay ha nikuna,” kon ni Simon. “Tamos,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ket nangisoleg ni Jesus ha babbey, ket kinagi na ha ni Simon, “Entan mo bi i babbey aye, ta ide i kayat ko a kagiyan. Nakoya, idi dinumematak ha bilay moy, awan mo neyatad i dinom a panguges ha tikad ko. Ngem inugisan na ha luluwa na, ken pinunasan na ha buk na. ");
INSERT INTO duo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ket idi sinumadapak ha bilay moy, awanak mo pinasalpakan ha ammos mo. Ngem nagammosammos hikuna ha tikad ko, nangrugi idi inumetnodak. Ket awan pala tinumaran a nagammos. ");
INSERT INTO duo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ha nikaw, awan mo sapuwan ha maski ha malaka la a langis ha buk ko. Ngem nagsapusapu hikuna ha tikad ko ha langis a pangpasarob, ken mangina. ");
INSERT INTO duo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Isu, niyaen, ipeta ko ha nikaw, a nepaenta na a napakawan na Dios i makpal a liwat na, gipu ha dakkal a pagayat na. Ngem ha maski nu heya a magkagi a ballik la i napakawan na Dios, siyempre, ballik bila i pagayat na ha Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sa na, inpeta ni Jesus ha babbey, “Napakawan dan i liwaliwat mo,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ngem ha sabali a hidi a nakipagkan bila ha bilay di Simon, naginuhon hidi ha, “Anya wade i lallaki aye? Apay a kagin na a makapakawan hikuna ha liwaliwat na tolay?” kon di. ");
INSERT INTO duo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ket kinagi pala ni Jesus ha iday a babbey, “Mesalakan ka dan gipu ha panahod mo ha nikan. Lumakad ka dan. Lumakad kamon a sitatalna,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Idi awan maalay, tinumulos di Jesus ha paglakad di ha il-ili ayo a dakkal ken maski barbaryo a ballik. Ket maski nu hadya a inangayan di, nepakatandi ni Jesus i Mappiya a Baheta a megipu ha paghariyan na Dios. Ket nakikuyog ha nikuna i apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ket nakikuyog bila i kappal a babbey a napahusay ha sakisaket di ken ha didimonyo di. Ni Maria Magdalena i esa a babbey. Pinalakad ni Jesus i pitu a dimonyo ha baggi na. ");
INSERT INTO duo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ket atoy bila ni Juana a kabanga ni Kuso, a tarabahador ni Hari Herod. Ket atoy bila ni Susana ken makpal pala a babbey a nagusar ha aruwatan di ken baknang di, a paggatang di ha kanan, ken aruwatan, para ha di Jesus. ");
INSERT INTO duo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Idi tiyempo hito, nakangangay i totolay ha ni Jesus. Naggipu hidi ha ngamin a ili. Ket idi dinumakkal i kakpalan hito, inestoriya ni Jesus i pangpakatandi na ha nidi. Kinagi na, ");
INSERT INTO duo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nikuna, atoy i esa a mannalon a inumangay ha sikaw na a magmula. Idi nagmula hikuna, netakneg i kappal a bin-i ha dilan. Ket nagidtanan idenday a bin-i. Ket tinumagmak i manok a hidi a nagkakan. ");
INSERT INTO duo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ket netakneg i kappal ha kabitubituwan. Isu, idi nagtubo idagenday a bin-i, napohpoh hidi, ta awan ha dinom ha kabitubituwan. ");
INSERT INTO duo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ket netakneg i kappal ha kasesetan. Ket idi dinumakkal idagenday a bin-i, dinumakkal bila i seset a hidi, ket nasalenan i tumubo a hidi. ");
INSERT INTO duo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ngem atoy i kappal a netakneg ha mappiya a lutak. Ket idi dinumakkal idagenday a bin-i, nebunga na kada esa ha esa gasut a bukal ha kada esa a bin-i a netakneg.” Ide i inestoriya ni Jesus. Sa na, kinagi pala, “Nu makasaneg kam ha kakkagi ko, makatandiyan moy mina ito,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ket nagsalodsod i agagum ni Jesus nu anya i kayat na kagiyan na iday a estoriya a pangikalanan na. ");
INSERT INTO duo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ket tinabbeg na, “Ipakatandi ko ha nikam idagende a inlimid na Dios megipu ha paghariyan na. Ngem ha sabali a tolay a awan a maguseg ha nikan, tatemanan di la i estoriya ko, ket awan di makatandiyan. Isu a makatongpal ha pinapugto na Dios ni Isayas a nangisurat ha, ‘Maski nu makangenta hidi, awan di melasin. Ket maski nu makangteman hidi, awan di makatandiyan,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ket tinulos ni Jesus, “Ide i kayat ko a kagiyan ha estoriya ko. Magkalan i bin-i ha kagi na Dios. ");
INSERT INTO duo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ket i dilan a nataknegan na bin-i, iday i magkalan ha tolay a magteman ha kagi na Dios. Ngem dumemat ni Satanas, ket magadya hikuna ha kagi na Dios ha nakam di, penu awan hidi manahod ken mesalakan. ");
INSERT INTO duo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ket i kabitubituwan a nataknegan na bin-i, iday i magkalan ha tolay a magteman ha kagi na Dios, ket magragsak hidi. Ngem awan meyoltak i kagi na Dios ha disalad na nakam di. Manahod hidi ha ballik la. Ket nu dumemat manon i rigrigat, magsigida hidi a sumoli ha ugali di a madukas. ");
INSERT INTO duo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“I kasesetan a nataknegan na bin-i, iday i magkalan ha magteman a hidi ha kagi na Dios, ngem makaburibur hidi megipu ha korinat ken pagragsakan di. Isu, mesalen i pagnakam di ha makpal a buribur di. Ket awan di nakaman i kagi na Dios. Ket awan hidi magbunga, ta awan hidi magayat ha Dios ha tahod. ");
INSERT INTO duo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Niyaen, i mappiya a lutak a nataknegan na bin-i, iday i magkalan ha totolay a magteman ha kagi na Dios, ken makatandi. Ket iasak di i kagi na ha madisalad ha nakam di. Ket magdagdag hidi a malagda, hanggan mebunga di i mappiya a bunga. ");
INSERT INTO duo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ket kona bila hito ha nikam. Hikam i makatandi ha kagi na Dios. Ket kona ha pagsuluan i pagkatandi moy aye. Isu, kona ha magdisyag mina i pagkatandi moy ha tolay a hidi. I kayat ko a kagiyan a magibaheta kam mina ha kagi na Dios. Ta siyempre, ha maski nu heya a magsulu, awan na kallaban, onu itagmak i sulu na ha sidung na katre. Awan agay! Iyontok na mina i sulu na, penu masuluwan na i sumadap a hidi. ");
INSERT INTO duo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Katandiyan moy mina ide. Ha maski nu anya a inlimid na Dios, iday i kayat na a ipalapos moy nokkan. Ket maski nu anya i pagitoldu ko a awan nakatandiyan na totolay niyaen, ipakatandi moy mina nokkan. ");
INSERT INTO duo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Isu, magteman kam perpermi ha kagi ko. Gipu ta maski nu heya a umuseg ha kagi na Dios, inayon pala na Dios ha pagkatandi na. Ngem ha maski nu heya a awan umuseg ha kagi na Dios, adyan na Dios iday a kagin na a nakatandiyan na.” Ito i inpeta ni Jesus ha tolduwan na a hidi. ");
INSERT INTO duo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dinumitang i hena ken lallallaki a wawaddi ni Jesus, ngem awan di naabot ni Jesus gipu ha kakpal a tolay. ");
INSERT INTO duo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ket napetan ni Jesus, “Atoy i hena ken wawaddi mo ha lapos. Ket kayat di ka maenta.” ");
INSERT INTO duo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ngem kinagi ni Jesus ha kakpalan a hidi, “I magteman a hidi ha kagi na Dios ken magtongpal, hidi i tahod a hena ken wawaddi ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Idi esa a pamalak, sinumakay di Jesus ha abang. Ket kinagi na ha agagum na, “Umahabes kitam dan ha dibelew,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Idi kalakad di, kinumillap ni Jesus. Ket bigu la a naparas dan ha napigsa. Ket nangrugi a mesagab i abang. Ket delikadu i kasasaad di. ");
INSERT INTO duo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Isu a linukag di ni Jesus, a kinagi di, “Apo, Apo! Umlad kitam dan!” Ket inumikat ni Jesus, a binon na i paras ken raknab a hidi. Ket tinumaran i pahas, ken linuminnak i diget. ");
INSERT INTO duo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sa na, kinagi ni Jesus ha agagum na, “Apay a manteng kam? Awan kam manahod ha nikan?” kon ni Jesus. Ngem naskal pala hidi, ket nakanteng, ket nagsasinalodsod hidi, “Anya wade i lallaki aye? Mebon na i paras ken raknab, ket magtongpal hidi ha nikuna,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tinumulos di Jesus a naglugan ha abang hanggan ha lugar na Gadareno, ha dibelew na Galileya. ");
INSERT INTO duo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Idi kahhapog di Jesus, sinumalpak i esa a lallaki a taga ili, a hinayup. Naalay dan a sitatalobag, ket awan hikuna naghen ha bilay na. Ta kanayon a naghen ha libalbang. ");
INSERT INTO duo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Naminmakpal a inawag na hikuna na dimonyo. Uray nu inkemot na tolay, ket ingakad di i kamat ken tikad na ha kawar. Nu inawag na hikuna na dimonyo, binagsot na i kawar, ket pinalakad na hikuna na dimonyo ha lugar a awan ha bilabilay. Idi naenta na ni Jesus, nagkalles i hinayup aye, ket inwahagit na i baggi na ha saguppang ni Jesus, a inayag na, “Jesus, anya i kayat mo ha nikan? Hikaw i annak na Dios a Katangkayan! Magpakagbiyak ha nikaw, awanak mo parigatan!” Ito i kinagi na hinayup, gipu ta inbobon ni Jesus a lumapos i dimonyo ha baggi na. ");
INSERT INTO duo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ket sinalodsod ni Jesus, “Heya i nagen mo?” Ket tinabbeg na, “Ni Kakpalan i nagen ko,” gipu ta makpal i dimonyo a sinumadap ha baggi na. ");
INSERT INTO duo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ket nagpakagbi unay i dimonyo a hidi ha ni Jesus, a awan na hidi itogbak ha abot a awan ha kahad. ");
INSERT INTO duo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ket atoy bila hito i kakpalan na babboy, a magsabbok ha mabikan a kalebkeb. Ket inaged di ha ni Jesus, a palobusan na hidi a sumadap ha dagendo a babboy. Ket pinalobusan na hidi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Niyaen, idi linumapos hidi, sinumadap hidi ha babboy, ket ginumutap i babboy a hidi ha dinom. Ket inumlad hidi. ");
INSERT INTO duo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Idi nangenta i mahagdapon a hidi ha babboy, binumuyot hidi ha ili ken taltalon, penu ibaheta di. ");
INSERT INTO duo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Isu, dinumemat i tolay a hidi, ta kayat di a maenta i nagimet. Idi dinumemat hidi ha ni Jesus, naenta di i lallaki a linaposan na didimonyo a inumetnod ha saguppang ni Jesus. Ket mappiya i nakam na. Ket nagtennon hikuna. Ngem nanteng i nangenta a hidi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ket inpakatandi na mahagdapon a hidi nu panyan na a napahusay ide a lallaki. ");
INSERT INTO duo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ket nagaged i ngamin a naggipu ha Gadareno a umadiyo ni Jesus, gipu ta nanteng hidi unay. Isu a sinumadap ni Jesus ha abang penu sumoli. ");
INSERT INTO duo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ket inaged na lallaki a nahusay a kumuyog mina ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ngem kinagi ni Jesus, “Sumoli ka dan ha bilay moy, ket ipeta mo ha nidi i mappiya a ginimet na Dios ha nikaw,” kon na. Isu a sinumoli i lallaki, ket inbaheta na ha ngamin ha ili i ginimet ni Jesus ha nikuna. ");
INSERT INTO duo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Idi sinumoli ni Jesus ha dibelew, atoy pala i kakpalan a nagsalpak. Ta nagururay hidi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ket atoy bila i esa a lallaki a nagen na, ni Hayro. Hikuna i mangituray ha esa a kapilya na Judyo a hidi. Ket inhakab na i baggi na ha saguppang ni Jesus, a inaged na a umangay ni Jesus ha bilay na. Ta dandani dan a matay i esesa a annak na a gumitek. ");
INSERT INTO duo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ngem idi naglakad di Jesus ha bilay di Hayro, dinumulog i kakpalan a hidi, hanggan masupit i paglakadan di. ");
INSERT INTO duo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ket inumunod bila i esa a babbey a magsaket. Nagdigidigi dan i babbey aye ha esa pulo ket duwa a tawen. Ket inubos na i ngamin a pagbiyag na ha doktor a hidi. Ngem awan di napahusay i baggi na. ");
INSERT INTO duo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Niyaen, binumikan hikuna ha adag ni Jesus. Ket kinamhet na i nibik na badu na. Sa, bigu la a tinumaran i digi na. ");
INSERT INTO duo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ket kinagi ni Jesus, “Heya i nangkamhit ha nikan?” Ket tinabbeg na ngamin a kakpalan, “Awan hikan i nangkamhit!”. Ket kinagi ni Pedro, “Apay, Apo? Atoy ha he i kakpalan! Masaldisaldit na kitam na kakpalan aye! Ket makpal i mangsabeh ha nikaw!” kon ni Pedro. ");
INSERT INTO duo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngem kinagi ni Jesus, “Awan, agay. Atoy i esa a nangkamhit ha nikan. Ta nabati ko a linumapos i kaddat ha baggi ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Idi naenta na babbey a nakatandiyan ni Jesus i nagimet, inumangay hikuna a hinumakab ha saguppang na. Ket nagyagyag i baggi na, gipu ha saniki na. Ket ha hay, ha saguppang na ngamin a tolay, inpakatandi na nu panyan na a kinamhet i badu ni Jesus, ket panya a dagus a napahusay i baggi na. ");
INSERT INTO duo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sa, inpeta ni Jesus ha nikuna, “Manay, mahusay ka dan, gipu ta manahod ka ha nikan. Niyaen, kad mo dan a sitatalna,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Niyaen, atoy pala ni Hayro, i lakay a mangituray ha kapilya. Ket idi nagkagi pala ni Jesus ha babbey, atoy i dinumemat a nagipu ha bilay di Hayro. Inpeta na ha ni Hayro, “Magsoli ka bi ha bilay, ta paayag di ka,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ngem nateman bila ni Jesus, ket inpeta na ha ni Hayro, “Awan kas manteng. Manahod ka dan ha nikan, ket mahusay i annak mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Niyaen, kaddemat di ha bilay di Hayro, ket sinaway ni Jesus i sabasabali a sumadap ha bilay. Hidi la ni Pedro, ni Juan ken ni Santiyago, ket hama ken hena na annak i nakikuyog ha ni Jesus ha disalad. ");
INSERT INTO duo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Idi kasadap di, nagsangisanget ken nagngongoyngoy i tolay a hidi ha disalad. Ta natay i annak heya. Ngem inpeta ni Jesus, “Awan kam magsanget. Awan natay i annak aye. Kinumillap dalla hikuna,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ngem inulew di ni Jesus ha ngidingidet di. Ta sigurado hidi a natay i annak. ");
INSERT INTO duo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ngem inegkam ni Jesus i kamat na annak. Ket inayag na, “Nening, umikat ka dan!” ");
INSERT INTO duo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ket sinumoli i angas na, ket dagus a inumikat hikuna. Ket inbon ni Jesus a pakanan di hikuna. ");
INSERT INTO duo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ket nalaktat unay i hena ken hama na. Ngem inbon ni Jesus a awan di ibaheta ha maski nu heya. ");
INSERT INTO duo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Idi esa a pamalak, pinapisan ni Jesus i esa pulo ket duwa a tolduwan na. Ket inyatad na i kaddat ken pagturayan di, penu mapalakad di i maski nu anya a kalase na dimonyo ken penu mapahusay di i tolay a masaket. ");
INSERT INTO duo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Sa na, pinaangay hidi a magitoldu megipu ha paghariyan na Dios ken magpahusay ha tolay a masaket. ");
INSERT INTO duo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ket inbon na ha nidi, “Awan kam magbilon ha aruwatan moy, maski nu sahukod, onu supot, onu kanan, onu korinat, o maski nu badu a pagsuletan moy. Awan moy bilonan. ");
INSERT INTO duo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ha maski nu hadya a bilay a mappiya i pangsalpak di ha nikam, magtulos kam ha iday a bilay hanggan lumakad kam manon. ");
INSERT INTO duo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ket ha maski nu hadya a lugar a awan hidi magsalpak ha nikam, lumapos kam ha iday a lugar. Ket nu lumapos kam, tipladan moy hidi a kona ha ide, a pagpagen moy i tikad moy ha tapok, penu makatandiyan di a nagliwat hidi, a minadiyan di i kakkagi na Dios.” Ide i inbon ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Isu, linumakad hidi a esa pulo ket duwa, ket naglakadlakad hidi ha ngamin a ido a baryo. Ket nagitoldutoldu hidi ha Mappiya a Baheta megipu ha paghariyan na Dios, ket nagpahusay hidi ha masaket ha kadabaryo. ");
INSERT INTO duo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ha ni Mayor Herod, idi nakabaheta hikuna ha makpal a gimet ni Jesus, nakaliwat hikuna ha nakam na. Ta kinagi na kappal, a minabiyag manon ni Juan a Magbinyag, kon di. Maski nu pinatay dan ni Herod. ");
INSERT INTO duo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ket kinagi na kappal, a nagsoli ni Eliyas a nagipu ha langit. Hikuna i esa a minahagpugto, idi nikuna a naalay dan. Ket kagin di a ni Jesus iday a minahagpugto. Ket atoy i kappal, a kagin di a ni Jesus i sabali a minahagpugto, a minabiyag manon. ");
INSERT INTO duo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ket kinagi ni Herod, “Pinaputol ko dan ni Juan. Ngem heya ide a lallaki a inbaheta di ha nikan?” kon na. Ket nagpadpadas ni Herod a mangenta ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Idi sinumoli i esa pulo ket duwa a apostol, inbaheta di ha ni Jesus i ngamin a ginimet di. Ket intugan na hidi ha esa a lugar a awan ha tolay, ha bikan na ili a Betsayda. ");
INSERT INTO duo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ngem idi pakabaheta na kakpalan i inangayan di, inumunod bila hidi. Ket idi nakaabot hidi ha di Jesus, sinalpak na hidi. Ket intoldu na i megipu ha paghariyan na Dios. Ket pinahusay na i masaket a hidi. ");
INSERT INTO duo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Idi dandani a linumiksup i senggit, kinagi na apostol a hidi, “Apo, paglakadan mo bi idagende a tolay, penu umangay hidi ha barbaryo ayo, ket ha taltalon ha kalipat. Ta masapul di a mageriyok ha kanan di ken pagtidugan di. Ta makasaw i lugar ha he,” kon na apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngem kinagi ni Jesus, “Hikam mina i magpakan ha nidi.” Ket tinabbeg na apostol a hidi, “Panyan mina? Ta duwa a padut a pindang ken lima a tinapay la i bilon mi. Kayat mo dod a lumakad kami, a maggatang ha kanan para ha ngamin a kakpalan aye?” kon di. ");
INSERT INTO duo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Atoy manga lima a ribu a lallaki. Ket atoy bila i kabanga di ken annak di.) Ket kinagi ni Jesus ha apostol a hidi, “Ipaetnod moy hidi a pumisan ha taglilima a pulo,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Idi nobos ito a ginimet di, ");
INSERT INTO duo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","inalap ni Jesus i duwa a pindang ken lima a tinapay a bilon di. Ket tinumangad hikuna ha langit. Ket nagyaman hikuna ha Dios. Sa na, pinilakpilak, ket inyatad na ha apostol a hidi, a iwaras di. ");
INSERT INTO duo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ket nagkan hidi ngamin. Ket idi nabbiyag dan hidi ngamin, pinuhon di i sobra. Ket naputat na apostol a hidi i esa pulo ket duwa a basket ha tinapay ken pindang a buhay di. ");
INSERT INTO duo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Idi esa a pamalak, nagisesa ni Jesus a magkararag. Ket idi dinumemat i apostol a hidi, sinalodsod ni Jesus ha nidi, “Anya i nakam na totolay megipu ha nikan? Heya ak wade ha pagkagi di?” kon na. ");
INSERT INTO duo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ket tinabbeg di, “Kinagi na kappal a hikaw kan ni Juan a Nagbinyag, ket minabiyag manon. Ket kinagi na kappal a hikaw kan ni Eliyas, a nagsoli a nagipu ha langit. Ket kinagi na kappal a hikaw i esa a minahagpugto a minabiyag manon, kon di kan.” ");
INSERT INTO duo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ket sinalodsod ni Jesus, “Hikam bi, anya ha nakam moy? Heya ak wade ha nakam moy?” kon na. Ket tinabbeg ni Pedro, “Hikaw i Kristu, i lalaki a pinaangay na Dios a maghari ha ngamin a tolay,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ngem inbon ni Jesus a awan di ipeta ha maski nu heya a hikuna i Cristu. ");
INSERT INTO duo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ket inpeta na, a “Ha Annak na Dios a Nagbalin a Tolay, masapul a attaman na i makpal a rigrigat, ta nokkan ket umadi hidi ha nikan, hidi a matangkay a papadi, hidi a mangituray ha kapilya, ken hidi a maestro na linteg. Ket ipapatay di ak. Ket nu malpas i tallu a pamalak, magbiyagak manon.” Ito i nepugto ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ket kinagi na pala, “Maski nu heya a mayat a umuseg ha nikan, masapul a kabengan na i baggi na, a baklayan na i kudos na ha kadapamalak ken umusoseg ha nikan. ");
INSERT INTO duo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta maski nu heya a mayat a mangisalakan ha baggi na, hikuna i tahod a matay nokkan. Ngem maski nu heya a mangiyatad ha biyag na ha Dios, gipu ha nikan, uray nu matay i baggi na, isoli na Dios i biyag na nokkan. Ket awan hikuna matay manon.” ");
INSERT INTO duo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Gipu ta kona bila ha ide,” kagi ni Jesus, “nu atoy i tolay a makaalap ha ngamin a baknang na lutak, awan ha balle na iday nu lompas i biyag na, a awan na mapadasan i biyag a magnanayon. ");
INSERT INTO duo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ha tolay a kona ha iday, masaniki hikuna a manahod ha nikan. Ket masaniki a magtongpal ha pagitoldu ko. Ket nu pabiyanan na ak niyaen, pabiyanan ko bila hikuna nokkan, ha pagsoli ko a magipu ha langit. Ket ha kasoli ko nokkan, mepaenta i kainamakan ko ken kainamakan na Dios, i hama ko, ken i kainamakan na anghel a hidi. Ket pabiyanan ko nokkan i tolay a kona ha iday, ta masanikiyak nu sumadap hikuna ha paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ket niyaen, magsiguradowak ha nikam, a atoy he, ha agagum tam i awan a matay hanggan maenta di i kainamakan na Dios ken paghariyan na,” kon ni Jesus ha apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Niyaen, idi nobos ha manga makadominggo, inkuyog ni Jesus ni Pedro, ni Juan, ken ni Santiyago a tinumagdak ha parabin, penu magkararag. ");
INSERT INTO duo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Idi nagkararag ni Jesus, nagbigu i rupa na. Ket nagbalin a maponset i tennon na, a nagpahiyamhiyam i tennon na aye gipu ha kinaponset na. ");
INSERT INTO duo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ket bigu la a nagpaenta i duwa a lallaki, a ni Moyses ken ni Eliyas. ");
INSERT INTO duo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nagpaenta hidi ha kainamakan na langit ha baggi di. Ket nakiuhon hidi ha ni Jesus megipu ha katay ni Jesus nokkan, ha Jerusalem, penu matongpal na i panggep na Dios. ");
INSERT INTO duo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Niyaen, ha di Pedro, kinumillap dalla hidi. Ngem minumutag hidi, ket naenta di i kainamakan ni Jesus ken duwa a lallaki a agagum na. ");
INSERT INTO duo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ket idi dandani a lumakad i duwa a hidi, kinagi ni Pedro ha ni Jesus, “Apo, mappiya, ta atoy kami ha he. Magtoklong kami mina ha tallu. Esa para ha nikaw, esa para ha ni Moyses, ken esa para ha ni Eliyas,” kon na. (Ngem tahod a maliwaliwat i nakam ni Pedro, ket awan na nakatandiyan i kinagi na.) ");
INSERT INTO duo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Niyaen, idi magkagi pala ni Pedro, nalenduman na hidi na ulap, ket nanteng di Pedro. ");
INSERT INTO duo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ket atoy i timek a nagkagi ha ulap aye ha, “Ide i annak ko. Pinaangay ko hikuna a maghari. Temanan moy hikuna!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Idi tinumaran i timek, naenta di Pedro ni Jesus a esesa. Ket idi tiyempo hito, nagmallay hidi a awan di ibaheta megipu ha naenta di aye. ");
INSERT INTO duo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kaugman na, binumugsok hidi ni Jesus ha ditaw. Ket nasalpak na hidi na kakpalan. ");
INSERT INTO duo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ket atoy i esa a lallaki a nagayag ha, “Maestro, umagedak ha nikaw, a entan mo bi i annak ko aye, i annak ko a lallaki a esesa! ");
INSERT INTO duo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ta atoy i dimonyo a magiawag ha nikuna, ket bigu la a magparangsirangsit. Ket itulos na a magpayagyag hanggan maghabhab i labi na. Kanayon na hikuna a pasaketan, ket awan na pabiyanan! ");
INSERT INTO duo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nagagedak ha agagum mo a palakadan di mina, ngem awan di kaya,” kon na lallaki. ");
INSERT INTO duo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ket kinagi ni Jesus, “Ay, idagende a tolay a maliwaliwat pala! Apay wade a awan kam manahod ha Dios ha mehusto? Kahangan kaalay i paganus ko ha malupoy a panahod moy? Kahangan kaalay i paghen ko ha nikam, penu manahod kam a tahod?” Sa na, kinagi ni Jesus, “Iyangay mo he i annak mo.” ");
INSERT INTO duo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Niyaen, idi inyangay di pala i annak, inwahagit na hikuna na dimonyo. Ket pinakissew na. Ngem pinalakad ni Jesus i dimonyo aye. Ket pinahusay na i annak. Ket insoli na ha hama na. ");
INSERT INTO duo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ket ha nidi a kakpalan a nangenta ha ide, nalaktat hidi, gipu ta manakabalin gamen i kaddat na Dios. Niyaen, idi masbew pala i kakpalan aye megipu ha ngamin a gimet ni Jesus, kinagi na ha agagum na, ");
INSERT INTO duo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Awan moy lipatan i ipeta ko ha nikam, a maski nu deyawan di ak niyaen, dumemat pala i tiyempo nu igiwat di ha kasenti ko i Annak na Dios a Nagbalin a Tolay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ngem awan na ito nakatandiyan na agagum na. Ta napalimid na Dios i kayat na kagiyan ni Jesus, penu awan di makatandiyan. Ket nanteng hidi. Isu, awan hidi nagsalodsod nu anya i kayat na a kagiyan. ");
INSERT INTO duo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Idi sabali a pamalak, nakipagtabbegan i agagum ni Jesus. Ket nagtinabbeg hidi nu heya i mas matangkay ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ngem nakatandiyan ni Jesus i nakam di. Isu, inalap na i esa a annak, ket pinataknag na hikuna ha hikeg na. ");
INSERT INTO duo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ket kinagi na ha nidi, “Kona ide i tolay a manahod ha nikan ha tahod. Ta maanus ken mapadibbi. Ket ipeta ko ha nikam, a maski nu heya a magrespitar ha tolay a manahod ha nikan a kona ha annak aye, respitaran na ak bila. Ket nu respitaran na ak, respitaran na i Dios a nagpaangay ha nikan. Ket maski nu heya ha nikam a magpadibbi ha baggi na, a kona ha annak aye, hikuna i mas matangkay talaga,” kon ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ket kinagi ni Juan, “Apo, naenta mi i esa a lallaki a nangpalakad ha dimonyo a hidi. Ta nanahod hikuna ha nikaw, kon na kan. Ket atoy kan ha nikuna i pinagturay ken kaddat ni Jesus, kon na kan. Ket inusar na i nagen mo. Ngem awan pala hikuna nagpasakop ha grupo tam aye. Isu, pinadas mi a pagimakan hikuna,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngem tinabbeg ni Jesus ha di Juan, “Awan moy mina pagimakan i totolay a kona ha iday. Ta awan hidi magsenti ha nikitam. Nu awan hidi magsenti, magdaggap dalla hidi,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Idi dandani a pagsoli ni Jesus ha langit, ninakam na a umangay ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Isu, pinapalungo na i agagum na, a maggayak ha paglakadan na ha probinsiya a Samariya. ");
INSERT INTO duo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ngem ha Samariya, awan nepalobus a sumadap di Jesus. Ta nakatandiyan na Samaritano a hidi a lumalakad pala di Jesus ha Jerusalem. (Ket magkasenti i Samaritano ken Judyo a hidi, gipu ta sabali i pakidiosan di.) ");
INSERT INTO duo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Idi nabaheta di Santiyago ken Juan a awan hidi makasaddap ha barbaryo na Samaritano, kinagi di ha ni Jesus, “Apo, kayat mo a ibon mi i apoy na langit a tumakneg, ken tutudan na hidi ngamin?” kon di. ");
INSERT INTO duo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ngem sinumoleg ni Jesus, ket minadiyan na i kinagi di, “Awan moy katandiyan i kalase na espiritu a mangikagi ha baggi moy,” kon na. “Madukas i kinagi moy! ");
INSERT INTO duo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ta awan dinumemat i Annak na Dios a Nagbalin a Tolay penu magpapatay, nu awan penu mangisalakan,” kon ni Jesus. Sa hidi, tinumulos ha sabali a baryo. ");
INSERT INTO duo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Idi maglakalakad pala hidi, atoy i lallaki a nangikagi ha ni Jesus, “Umunodak ha nikaw, maski nu hadya i angayan mo,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ngem iniwadan ni Jesus hikuna, “Maski ha hayhayup ha taltalon, a kona ha madipa, atoy i paghenan di ha abot na pogedu. Onu maski ha manok a hidi, atoy i paghenan di ha rabon di. Ngem awan ha paghenan na Annak na Dios a Nagbalin a Tolay, a pogedu ha maski nu hadya,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ket atoy bila i sabali a lallaki, a kinagi ni Jesus ha nikuna, “Umunod ka dan ha nikan.” Ngem tinabbeg na lalaki aye, “Apo, pabiyananak mo bi hanggan ha ballik, ta kakkatay dala nama ko. Ket ha palungo, en ko mina a ilabbang i hama ko. Sa ak, umunod ha nikaw,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ngem tinabbeg ni Jesus, “Kabeng mon iday. Ta atoy bila i sabali a hidi a makangmadi ha nikan, ket kona ha natay dan hidi. Isu, kabeng mon, ta idagenday a natay, hidi mina i mangilabbang ha minatay a hidi. Ngem ha nikaw, magibaheta ka mina megipu ha paghariyan na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ket atoy bila i sabali a lallaki a nagkagi ha, “Apo, kayat ko a umunod ha nikaw. Ngem ha palungo, palobusanak mo bi a magpakada ha pamilya ko,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ngem tinabbeg ni Jesus, “Nu magarado ka, ket kanayon ka a sumulegsuleg, awan mappiya i pagarado mo. Ket kona bila hito ha maski nu heya a kayat a umunod ha nikan. Masunong mina i paguseg moy ha nikan, o nu awan ka ha serbe ha paghariyan na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kobosan na ito, pinili ni Jesus i pitu a pulo ket duwa a lallaki a magpalungo, a maggayak ha kadaangayan na a barbaryo. Ket pinaglakad na hidi ha tagduduwa. ");
INSERT INTO duo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kinagi na ha nidi, “Kona ha maggapas i tarabaho moy. Ta atoy i makpal a mayat a mangalap ha biyag na Dios a magnanayon. Agay, kinumakpal dan hidi! Ket kona hidi ha pagay a naluto dan. Ket malawa i kona ha kapahayan aye. Ngem ballik la i tarabahador a maggapas. Isu, magkararag kam mina ha Dios, a paangayan na mina i mas makpal a tarabahador ha paggapasan na aye. ");
INSERT INTO duo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Niyaen, lumakad kam dan. Ngem magingat kam. Ta maanus kam a kona ha malogyaw a karnero. Ngem maingal i totolay a angayan moy, a kona ha maingal a asasu. ");
INSERT INTO duo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Awan kam mina magbilon ha korinat, onu kanan, onu sinelas a pagsuletan moy. Ket awan kam tumaran ha paglakad moy, a awan kam magmalay a magkagi ha maski nu heya ha dilan. ");
INSERT INTO duo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nu atoy i bilay a saddapan moy, ipeta moy ha makingbilay, ");
INSERT INTO duo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","‘Kagbiyan na kam na Dios.’ Ket nu mappiya hidi, ket nu mappiya i pagsalpak di ha nikam, kagbiyan na hidi na Dios a tahod. Ngem nu awan a mappiya i pagsalpak di, awan tumulos i Dios a magkagbi ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nu atoy i bilay a pagdagasan moy, awan kam umagton ha sabasabali a bilay. Tumulos kam ha esesa a bilay. Ket awan kam masaniki a magkan, ta aguman na kam mina na toltolduwan moy. ");
INSERT INTO duo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nu atoy i ili a saddapan moy, ket magsalpak hidi ha nikam, magkan kam ha maski nu anya a iyatad di ha nikam. Awan kam masaniki. ");
INSERT INTO duo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sa moy, pahusayan i masaket a hidi. Ket itoldu moy a binumikan dan i paghariyan na Dios ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngem nu atoy i ili a saddapan moy, ket awan hidi magsalpak ha nikam, tipladan moy hidi ha kona ha ide, a hen kam ha kalsada ken ipeta moy, ");
INSERT INTO duo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Pagpagen mi i tapok na ili moy ha tikad mi, penu makatandiyan moy a binumikan dan i paghariyan na Dios, ngem minadiyan moy dan!’ Iday mina i ipeta moy ha nidi a umadi ha nikam,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Ipeta ko ha nikam,” kinagi ni Jesus, “sayang agay ha totolay a kona ha dagenday! Ta nu dumemat nokkan i parusa na Dios, dakdakkal i parusa na ha totolay a kona ha iday, ngem ha madukas a kakaili ha Sodoma, a natutodan idi. ");
INSERT INTO duo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Adanay! Sayang, ha Judjudyo a taga Korasin! Ket kagbi i Judjudyo a taga Betsayda! Ginimet ko dan i makpal a milagro ha saguppang di, ngem awan hidi magbabawi. Nu kona hay i ginimet ko mina ha saguppang na totolay a taga-Tiro ken taga-Sidon, nagbabawi mina hidi a tahod. Maski nu bakkan hidi a Judyo. Ket inumetnod mina hidi ha abu. Ket intennon di mina i kostal, penu mepaenta di a ladingetan di i liwaliwat di. Ket inadiyo di a tahod i madukas a ugali di. ");
INSERT INTO duo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Isu, niyaen, parusaan na Dios i taga-Korasin ken Betsayda ha dakdakkal, ngem ha nidi a taga-Tiro ken Sidon. ");
INSERT INTO duo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ket kagbi bila i taga-Kapernaum a hidi! Kayat di a magdeydeyaw ha baggi di. Ngem mebanghat hidi nokkan ha impyerno!” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sa na, kinagi ni Jesus ha agagum na a dandani na a palakadan, “Ha maski nu heya a umuseg ha pagitoldu moy, mebilang a usigan na ak bila. Ket maski nu heya a magkabeng ha nikam, mebilang a kabengan na ak bila. Ket maski nu heya a magkabeng ha nikan, mebilang a kabengan na bila i Dios a nagpaangay ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Niyaen, kobosan na pinaglakad di, idi sinumoli i pitu a pulo ket duwa a hidi, naragsak hidi unay. Kinagi di ha ni Jesus, “Apo, maski i dimonyo a hidi, magtongpal hidi ha nikami, nu bonan mi hidi ha nagen mo!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ket kinagi ni Jesus, “Naenta ko dan i pinangabak moy ha ni Satanas, a kapitan na didimonyo. Naenta ko a nagtaknag hikuna ha sigida, a kona ha killat a natakneg ha sigida. ");
INSERT INTO duo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Niyaen, katandiyan moy a inatdinan takam ha pagturay moy, penu mangabak kam ha kaddat ni Satanas. Maski nu magidtanan moy i ulag, onu karamay, o maski nu anya a pangipasenti ni Satanas ha nikam, awan na kam maabak. ");
INSERT INTO duo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ngem maski nu kona hito, a maski nu mangabak kam ha dimonyo a hidi, awan kam mina magragsak gipu ha iday. Imbes na, magragsak kam gipu ta inlista na Dios i nagen moy ha langit,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ket pinaragsak na Espiritu na Dios ni Jesus, a kinagi na ha Apo Dios, “Hama ko, hikaw i Happo a makinglangit ken makinglutak. Magyamanak, ta inpaenta mo i katahodan mo ha ilailay ko aye a madibbi, maski nu inlimid mo ha masirib kan a hidi ken ha nidi a malaing kan ha pagkatandi di. Oni ay! Ta kona hito i nagayatan mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ket kinagi ni Jesus ha kakpalan a hidi, “Inatdinanak Nama ko ha ngamin. Awan ha makatandi ha Annak na Dios na awan la i Hama ko. Ket awan ha makatandi ha Dios nu awan i Annak na, ken totolay a kayat ko a pangipakatandiyan ha Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sa hikuna, sinumoleg, a kinagi na ha toltolduwan na ha sililimed, “Mappiya i kasasaad moy a makaenta kam ha ginimigimet ko! ");
INSERT INTO duo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ta atoy idi i makpal a minahagpugto ken hari na Judjudyo, a kayat di mina a maenta i bagbagay a maenta moy. Ket kayat di mina a magteman ha kakkagi a nateman moy, ngem awan a mabalin ha nidi, idi tiyempo di,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Atoy i esa a maestro na linteg a dinumemat a magsurbar ha ni Jesus, a baka magliwat ni Jesus ha kagi na. Isu a nagsalodsod hikuna ha ni Jesus, “Maestro, anya mina i gimetan ko penu makibiyagak ha Dios ha magnanayon?” kon na. ");
INSERT INTO duo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ket sinalodsod ni Jesus, “Anya i nesurat ha Libro na Dios? Anya i makatandiyan mo megipu ha bobon na Dios?” ");
INSERT INTO duo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ket tinabbeg na maestro na linteg, “Nesurat a masapul a ayatan tam i Happo tam a Dios ha ngamin a pigsa tam, ken ngamin a biyag tam, ken ngamin a nakam tam, ken ngamin a puso tam, ken ngamin a paggimet tam. Ket nesurat bila a masapul a kagbiyan tam i agagum tam, a kona ha pagkagbi tam ha baggi tam,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Tamos,” kinagi ni Jesus, “nu gimetan mo iday, makabiyag ka ha Dios ha magnanayon,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngem kayat na maestro na linteg a ikalintegan i baggi na. Isu a sinalodsod na pala, “Anya i kayat mo a kagiyan ha ‘agum tam’? Heya i agum ko?” kon na. ");
INSERT INTO duo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ket inestoriya ni Jesus ide a pangipakatandi na. “Nikuna,” kon ni Jesus, “idi esa a pamalak, atoy i Judyo a lallaki a nagisesa. Naglakadlakad hikuna hanggan ha ili a Jeriko, a nagipu ha Jerusalem. Ngem inlakap na hikuna na mahagliput a hidi. Ket ninagnag di hikuna, ket inadya di i ngamin a tennon na. Ket intirak di hikuna a dandani dan a matay. ");
INSERT INTO duo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Atoy bila i esa a padi na Judyo a naglakad bila ha iday a karsada. Ngem idi naenta na i Judyo a natalingo, linekawan na ha kalipat. ");
INSERT INTO duo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ket atoy bila i sabali a Judyo a naglakad. Ket hikuna i apo ni Lebi, ket nagtarabaho hikuna ha Templo, ha papadi na Judyo a hidi. Idi naabotan na, inaamatan na i Judyo a natalingo, ngem linekawan na bila ha kalipat. ");
INSERT INTO duo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ngem atoy i sabali a lallaki a taga-Samariya. Ket idi naenta na i lallaki a natalingo, kinagbiyan na hikuna, ket dinaggapan na. (Maski nu itoldu na mamaestro na linteg a mamagsenti mina i Judjudyo ken Samaritano a hidi.) ");
INSERT INTO duo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ngem binumikan i Samaritano ha Judyo aye a natalingo. Ket inagasan na ha langis ken alak, ket binadbadan na. Sa na, insakay ha kabayo. Ket inyangay na ha bilay a pagdagusan na. Ket dinapon na hikuna. ");
INSERT INTO duo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Idi kaugman na, nagpagga i Samaritano ha makingbilay. Ket inpeta na, ‘Daponan mo bi hikuna. Ket nu sumoliyak nokkan, pagaan ko i gahut na ha nikaw,’” kon na. ");
INSERT INTO duo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Isu,” kinagi ni Jesus, “anya i nakam mo? Heya wade i tahod a agum na Judyo aye? Hidi duwa a kabayan na a Judyo, onu iday a Samaritano?” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ket tinumabbeg i maestro na linteg, “Iday a Samaritano, gipu ta kinagbiyan na i Judyo heya,” kon na. “Tamos,” kinagi ni Jesus. “Ket hikaw bi. Ahegan mo mina i kona he.” ");
INSERT INTO duo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tinumulos hidi ni Jesus ha paglakad di. Ket dinumemat hidi ha esa a baryo. Ket atoy hito i esa a babbey a nagpahuyot ha nidi. Ni Marta i nagen na. ");
INSERT INTO duo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ket atoy bila i wadi na, a nagen na ni Maria. Niyaen, mayat ni Maria a umetnod ha saguppang ni Jesus, a magteman ha pagitoldu na. ");
INSERT INTO duo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ngem nagisesa ni Marta ha kosina, ta makpal i lutowan di. Isu, binumikan ni Marta ha ni Jesus, ket inaged na, “Apo, entan mo bi i wadi ko aye. Ta pabiyanan na ak a magisesa ha ngamin a tarabaho mi. Bonan mo hikuna a mangagum ha nikan,” kon ni Marta. ");
INSERT INTO duo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngem tinumabbeg ni Jesus, “Marta, Marta, apay a magburibur ken magsaket i nakam mo. ");
INSERT INTO duo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Atoy la i esa a bagay a masapul mo a tahod. Ket iday i pinili ni Maria. Ket awan a mabalin a maadya ha nikuna,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Idi esa a pamalak, a nagkarkararag ni Jesus, idi nobos na, inaged na tolduwan na, “Apo, tolduwan mo kami bi a magkararag a kona ha pinagitoldu ni Juan ha agagum na,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isu, intoldu ni Jesus, “Kona ha ide i pagkararag moy, ‘Hama, madeydeyaw i nagen mo. Ket hikaw mina i maghari ha ngamin a tolay. ");
INSERT INTO duo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Iyatad mo bi i kanan mi ha yenan, ken kadapamalak. ");
INSERT INTO duo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pakawanan mo bi i liwaliwat mi, gipu ta pinakawan mi i nagliwat a hidi ha nikami. Apo, awan mo bi palobusan a masulisog kami,’ kom moy. Kona mina hito i kararag moy” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ket intoldu pala ni Jesus ha agagum na megipu ha kararag a pagaged. Kinagi na, “Nu dumemat i ilay mo ha lubuk na kallap, ket awan ka ha kanan, maganya ka? Anya nu umangay ka ha bilay na ibay mo, ket dulawan mo hikuna, ‘Apo, ibay ko, pasaluwanak mo bi ha kanan, ");
INSERT INTO duo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ta kaddemat dalla na ilay ko a nagipu ha madiyo. Ket awan ha ipakan ko ha nikuna,’ kom mo. ");
INSERT INTO duo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Niyaen, anya nu tumabbeg i ibay mo ha disalad, ‘Agay, kallap dan! Awan taka maatdinan, ta makakilap kami a pattena. Madiyan ko a umikat. Neserado dan i ruwangan mi,’ kon na. ");
INSERT INTO duo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Entan moy,” kon ni Jesus. “Uray nu hikaw i ibay na, madiyan na a umikat a mangiyatad ha kanan ha nikaw. Ngem nu perpermi i pakiyaged mo, siyempre, umikat hikuna, ket iyatad na ha nikaw i ngamin a kasapulan mo, gipu ta awan ka masaniki a magaged. ");
INSERT INTO duo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Isu, ipeta ko ha nikam. Tumulos kam a makiaged ha Dios. Ket maatdinan na kam. Tumulos kam a mageriyok, ket paketan na kam. Tumulos kam a kona ha magtuktuk ha ruwangan na Dios, ket kona ha lakwaban na kam penu sumadap kam. ");
INSERT INTO duo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta maski nu heya a makiaged-aged ha Dios, makaalap hikuna. Ket nu magerieriyok hikuna, paketan na Dios. Ket nu tumulos hikuna a kona ha magtuktuk ha ruwangan, lakwaban na Dios penu sumadap hikuna. ");
INSERT INTO duo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ket kona bila hito ha nikam a keannak. Nu agedan na annak mo i padut, awan mo iyatad i ulag. Awan agay! ");
INSERT INTO duo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Onu makiaged hikuna ha bunay, awan mo iyatad i karamay. ");
INSERT INTO duo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tamos. Maski nu magkalan kam ha ngamin a kakalan moy a tolay a kelliwat, kayat moy paman a makiyatad ha mappiya ha annak moy. Ket pasig la a mappiya i Hama tam a nelangitan. Ket mas mapigsa paman i pinagkayat na a iyatad i Espiritu na ha totolay a makiaged ha nikuna,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Idi sabali a pamalak, pinalakad ni Jesus i dimonyo ha baggi na lallaki a bulol. Ket idi linumapos i dimonyo, nangrugi i lallaki a magkagi. Ket nasbew i kakpalan hay a nakaenta. ");
INSERT INTO duo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ngem atoy bila i kappal a Pariseyo a nagkagi ha, “Inyatad na Satanas i kaddat na ha ni Jesus, ket makapalakad dan hikuna ha dimonyo. Ta Satanas i kapitan na dimonyo a hidi,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ket atoy bila i kappal a maestro na linteg, ket kayat di a magsurbar ha ni Jesus. Isu, inageagedan di ha mapigsa a ipaenta mina ni Jesus i milagro ha nidi, ta kayat di kan maenta nu tahod a pinaangay na Dios ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngem nakatandiyan ni Jesus i nakam di. Ket kinagi na, “Nu atoy i esa a bayan, ket mesina dan i kakaili na, a magnginayaw hidi, mabikan dan i pagrakrak na iday a bayan. Onu atoy i esa a pamilya, ket magleput i hama ha annak na, ket magleput bila i annak ha hena di, agay, awan maalay i biyag na pamilya a kona ha iday. ");
INSERT INTO duo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Isu, nu masinasina dan i paghariyan na Satanas, ket magnginayaw i dimonyo a hidi ha sabasabali a dimonyo, panya a makatulos i paghariyan na? Awan a mabalin agay! Ngem kinagi moy a palakadan ko i dimonyo a hidi gipu ha kaddat na Satanas a inyatad na mina ha nikan. ");
INSERT INTO duo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nu naggipu i kaddat ko ha Satanas, hadya i nagipuwan na kaddat na agagum moy a makapalakad ha didimonyo? Hidi i magpatahod a madi i pinagkagi moy megipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta naggipu la ha Dios i kaddat ko a pagpalakad ha didimonyo. Ket gipu ta kona hito, inpaenta na ha nikam a maghari dan hikuna ha ihe a saguppang moy,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ket inpakatandi ni Jesus a mas mapigsa hikuna ngem ha Satanas, a kinagi na, “Nu atoy i mapigsa a lallaki a magdapon ha bilay na, ken kearmas bila, siyempre, matalna dalla i aruwatan na. ");
INSERT INTO duo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ngem nu atoy i mas mapigsa a lallaki, a mangdangper, ken mangabak, siyempre, samsaman na i ngamin a armas a nagtalkan na makingbilay. Ket naawan dan i araruwatan na makingbilay aye, a nebunong hidi ha agagum na nangabak. Ket kona bila hito ha nikan. Hikan i mangabak ha ni Satanas,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ket kona bila ha ide ha nikam. Nu pabiyananak moy, maabak kam bila. Masapul a umusoseg kam ha nikan. Ta maski nu heya a awan a umuseg ha nikan, hikuna i magsenti ha nikan. Ket ha maski nu heya a awan magdaggap ha nikan a magpuhon ha totolay a pagserbe ha Dios, ibilang ko hikuna a mangpaadiyo ha tolay ha paghariyan na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ket tinumulos ni Jesus, “Maski nu lumakad i dimonyo ha baggi na tolay, lumakalakad pala hikuna ha namadi a lugar, a mageriyok ha pagemmangan na. Ket nu awan hikuna makaeriyok ha pagemmangan na, ikagi na ha baggi na, ‘Sumoliyak mina ha lallaki a naghenan ko idi,’ kon na. ");
INSERT INTO duo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sa hikuna, sumoli, ket maenta na a maurnos i biyag na iday a lallaki ken malinis. Ngem awan ha asak na nakam na. ");
INSERT INTO duo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Isu, umangay manon i dimonyo aye, a alapan na i pitu a dimonyo a mas madukas ngem ha nikuna. Ket sumadap hidi ngamin a maghen ha iday a lallaki. Ket mas madukas i kasasaad na lallaki niyaen ngem idi palungo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Niyaen, idi nagkagi pala ni Jesus, indulaw na esa a babbey ha kakpalan, “Mappiya i kasasaad na babbey a nangenak nikaw ken nagsusowan mo!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ngem tinabbeg ni Jesus, “Imbes na, mas mappiya i kasasaad na magteman a hidi ha kagi na Dios ken magtongpal!” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Niyaen, idi kumakpal pala i kakpalan a hidi ha lebut ni Jesus, tinumulos hikuna a magitoldu. Kinagi na, “Madukas i totolay ha ide a tiyempo, ta kayat di kan a maenta i milagro, penu mapatahodan mina ha nidi a pinaangay na ak na Dios. Ngem atoy la i kona ha milagro ni Jonas. ");
INSERT INTO duo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kona idi netemlok na dakkal a padut ni Jonas, ket naghen hikuna ha tiyan na padut ha tallu a pamalak, sa, neyota ha lutak, a kona ha minagbiyag manon. Ket pangtiplad ito ha kakaili na Ninibe a pinaangay na hikuna na Dios. Ket kona bila ha iday i magimet ha nikan a Annak na Dios a Nagbalin a Tolay, penu makatandiyan na totolay a pinaangay na ak na Dios. ");
INSERT INTO duo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Nokkan, magsina i Dios ha mappiya ken madukas a totolay. Ket atoy hito i tumaknag ha saguppang na Dios, ken magpaliwat ha nikam. I babbey a naghari idi, ha kahariyan na Seba, hikuna i magpaliwat ha nikam nokkan. Ta idi, linumakad hikuna hanggan madiyo, penu magteman ha sirib ni Hari Solomon. Ket ipeta ko ha nikam, a atoy ha he, ha saguppang moy, i mas matangkay ngem ha ni Hari Solomon. ");
INSERT INTO duo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nokkan, ha pamalak a pangisina na Dios i mappiya ken madukas, atoy i magpaliwat ha nikam. Ta nokkan, tumaknag i totolay a taga-Ninibe ha saguppang na Dios, ket magpaliwat hidi ha nikam. Ta idi nateman di i pinagitoldu ni Jonas, nagbabawi hidi ha madukas a ugali di. Ket niyaen, atoy ha saguppang moy i mas matangkay ngem ha ni Jonas, ngem awan moy temanan i pagitoldu ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ket intulos ni Jesus, “Awan ha mangpagangat ha sulu na, sana, itago ha sidung, onu kallaban na ha salop. Imbes na, iyontok na mina a pagsuluan na totolay a sumadap. ");
INSERT INTO duo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ket kona bila hito, i mata moy i kona ha sulu na baggi moy. Nu pasig la mappiya i pagenta moy, siyempre, mapsag bila i nakam moy. Ngem nu madiham i pagenta moy, siyempre, madi bila i gimetan na baggi moy. ");
INSERT INTO duo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Isu, magingat kam. Ingatan moy i pagentan moy ken nakaman moy, penu awan magbalin a madiham i nasuluwan a pagkatandi moy. ");
INSERT INTO duo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nu mappiya i pakakatandi mo, kona ha nasuluwan i puso mo, ken nakam mo, ken angas mo, ket kona ha nasuluwan i ngamin a pinagbiyag mo, a kona ha pagsentakan na ka na sulu,” kon ni Jesus ha ide a kakpalan a tolay. ");
INSERT INTO duo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Idi nobos i pagitoldu ni Jesus, atoy i esa a Pariseyo a nagawis a magkan. Ket nakikuyog ni Jesus a sumadap, ket inumetnod ta magkan. Ngem awan inumunod ni Jesus ha ugali na Pariseyo ha paguges di. ");
INSERT INTO duo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ket naskal unay i Pariseyo. ");
INSERT INTO duo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ngem kinagi ni Apo Jesus, “Ha nikam a Pariseyo, maguges kam ha lapos na baso ken pinggan. Ket kona bila hito ha baggi moy. Ta mappiya i itsura na, ngem madukas i disalad, gipu ha pinagagew moy ken kinadukas moy ha kakalan moy a tolay. ");
INSERT INTO duo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Dagel kam ha Dios! Katandi moy a ginimet na Dios i lapos na baggi moy, a ugisan moy. Ngem awan moy wade makatandiyan a ginimet na bila i disalad na baggi, a kona ha nakam moy, ken puso moy ken angas moy. Iday bas i pappiyaan moy. ");
INSERT INTO duo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nu kayat moy a ibilang na Dios a mappiya i gimetan moy, usaran moy mina i nakam moy ken puso moy ken angas moy a pangdaggap moy ha napobre a hidi, ket ibilang na Dios a mappiya i gimetan moy!” kagi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kagbi kam, hikam a Pariseyo! Tahod a iyatad moy ha Dios i mekasangapulo na aruwatan moy, maski i nateng moy, a kona ha sili moy ken lasuna moy. Idatton moy idento ha Dios, ngem switikan moy i napobre a hidi. Ket pabiyanan moy bila i pagayat moy ha Dios! Oni! Tahod a idatton moy mina i mekasangapulo ha Dios, ngem awan moy mina pabiyanan i pagayat moy ha Dios ken pagkagbi moy ha napobre a hidi. ");
INSERT INTO duo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kagbi kam, hikam a Pariseyo! Kayat moy a magetnod ha pagetnodan na matangkay a hidi ha kapilya moy. Ket kayat moy i deydeyaw a pangsalpak na totolay ha sentro na ili. ");
INSERT INTO duo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kagbi kam, ta mearig kam ha labbang a awan natipladan. Ket nu awan maenta na tolay, magidtanan na, ket kompal i buyok ha tikad na. Ta maski nu mappiya i itsura moy, magpadukas kam ha pagitoldu moy,” kon ni Jesus. Ito i pinagiwadan ni Jesus ha Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Atoy bila ha makipagkan a hidi i esa a maestro na linteg. Ket kinagi na ha ni Jesus, “Maestro, nu magkagi ka ha kona hay, nebahang mo dan ha nikami bila!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ket tinabbeg ni Jesus, “Oni ah! Hikam a maestro na linteg, kagbi kam bila! Inaynayon moy i marigat a bobon ha linteg, ket pagtongpalan moy i tolay a hidi. Ngem awan moy hidi daggapan. Kona nu ibuwat moy i dakkal a tawed ha sabali a tolay, ngem madiyan moy hidi daggapan a magtawid. ");
INSERT INTO duo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kagbi kam! Ipaamakan moy i lablabbang na minahagpugto a hidi, maski nu minappo moy i totolay a nagbuno ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Isu, inoniyan moy i ginimet na minappo moy. Magkalan i nakam moy ha nakam di, ta binuno di i minahagpugto, ket ipaamakan moy i lablabbang di. ");
INSERT INTO duo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ket ito i kona ha inpapugto na Dios nikuna a naalay dan. Kinagi na Dios, ‘Paangayan ko ha nidi i kappal a mahagpugto, ken kappal a mahagibaheta ken magitoldu. Ha kappal, bunowan di hidi, ket ha kappal, lokwan di,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Isu, ipeta ko ha nikam,” kagi ni Jesus, “kagbi kam, hikam ha he, niyaen. Parusaan na kam na Dios gipu ha pinagbuno na minappo moy ha ngamin a minahagpugto, maski idi pinarsuwa na Dios i lutak hanggan niyaen. ");
INSERT INTO duo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Maski idi nabuno ni Abel, hanggan ha ni Sakariyas, a nabuno ha disalad na Templo, ha ballog na pangatdinan di ha Dios ken pagetnodan na Dios. Oni! Parusaan na Dios i totolay aye, gipu ha liwaliwat na minappo moy,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ket kagbi kam, hikam a maestro na linteg! Ikemot moy i kakkagi na Dios, a kona ha tulbek mina a pangpakatandi na ha totolay. Madiyan moy a tahodan i kakkagi na Dios, ket salenan moy hidi a mayat a makatandi!” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Niyaen, idi linumapos ni Jesus ha bilay na Pariseyo, talaga a ginapakgapakan di, ket mas mapigsa i pinagsalodsod di, a bareng nu maliwaliwat ni Jesus, ket makekagi hikuna ha madi. ");
INSERT INTO duo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ket sinurbar di hikuna, penu mapagliwat di mina ni Jesus ha Hari di. ");
INSERT INTO duo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Idi nakipagtabbeg pala hidi, nagpipisan i rinibribu a totolay hanggan a namagdirkat hidi. Niyaen, inaamatan ni Jesus i toltolduwan na, ket kinagi na, “Magingat kam ha lebadura na Pariseyo a hidi. I kayat ko kagiyan, i ugali di a aginpappiya ken agintatalak. Lisian moy mina i ugali di, a awan moy hidi ahegan. ");
INSERT INTO duo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta maski nu anya a paggimet na totolay a netago, iday i mepalapos nokkan. Ket maski nu anya a napalimid na totolay niyaen, iday i makatandiyan na kakpalan nokkan. ");
INSERT INTO duo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Isu, ha bagbagay a paguhonan tam ha kallap, a awan mateman na tolay a hidi, iday mina i mebaheta moy nokkan ha saguppang na ngamin a tolay, maski ha pamalak. Ket maski nu iyanasas tam niyaen, masapul moy nokkan a ibaheta ha saguppang na ngamin a tolay. ");
INSERT INTO duo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Hikam i ilay ko. Ket ipeta ko ha nikam a awan kam mina manteng ha totolay. Mapatay di i baggi moy, ngem awan di maanya i espiritu moy. ");
INSERT INTO duo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Iwadan takam nu heya mina i kantengan moy. Manteng kam mina ha Dios, ta hikuna la i makapatay ha totolay ken makapebanghat bila ha espiritu di ha impyerno. Hikuna mina i kantengan moy,” kagi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ngem awan kam mina magburibur a pabiyanan na kam na Dios. Ta kona ha ide i kagbi na Dios. Ikaspangarigan, ha nikitam, malaka la i piyak a manok. Ngem uray nu melako i lima a piyak ha duwa a sentabos la, nakaman na hidi na Dios. Ket awan na lipatan i maski esa. ");
INSERT INTO duo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ngem ha nakam na Dios, mas mangina kam unay ngem ha piyak a hidi. Ket katandiyan na i maski nu anya a magimet ha nikam, uray nu lompas i esa la a buk ha buntok mo, katandiyan na Dios, ta binilang na dan. Isu, awan kam mina magburibur. Ta hikam i mas mangina ha Dios ngem ha makpal a piyak a manok. ");
INSERT INTO duo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nakaman moy ide a megipu ha nikan, a Annak na Dios a Nagbalin a Tolay. Ha maski nu heya a mangipeta ha totolay a hikuna i tagabu ko, ipeta ko bila ha anganghel na Dios a hikuna i agum ko. ");
INSERT INTO duo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ket maski nu heya a magmadi ha nikan ha saguppang na totolay, madiyan ko bila hikuna ha saguppang na anganghel na Dios,” kagi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ha maski nu heya a magkagi ha pangsenti ha Annak na Dios a Nagbalin a Tolay, mabalin a mapakawan na hikuna na Dios. Ngem ha maski nu heya a magkagi ha pangsenti ha Espiritu na Dios, awan hikuna mapakawan. ");
INSERT INTO duo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nokkan, meyangay kam ha saguppang na kapikapilya na Judyo a hidi, ken ha gobernador a hidi, ken ha hari a hidi. Ngem nokkan, nu paliwatan di kam, gipu ha panahod moy ha nikan, awan kam mina magburibur nu anya i rason moy ha nidi, onu panyan moy a makitabbeg ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gipu ta, ha iday a tiyempo, atoy i Espiritu na Dios a mangitoldu ha nikam nu anya mina i kagi moy,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Niyaen, atoy i esa a lallaki ha lubuk na kakpalan aye, ket kinagi na, “Maestro, ibon mo bi i hekka ko, penu bunongan na ak ha gihagihak na minama mi.” ");
INSERT INTO duo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ngem tinabbeg ni Jesus, “Agay, bakkanak a hukom a magpabunong mina ha gihagihak moy!” ");
INSERT INTO duo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ket kinagi ni Jesus ha nidi ngamin, “Magingat kam a awan moy seniyan i maski nu anya a kalase na bagbagay. Ta bakkan a babaknang i paggipuwan na mappiya a pagbiyag na tolay, maski nu mabaknang unay. Awan a makapappiya i babaknang ha biyag na tolay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ket inestoriya ni Jesus ide a pangipakatandi na, “Idi kan, atoy i esa a mabaknang a lallaki, ket mappiya i pinaggapas na. ");
INSERT INTO duo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Isu, kagin na, a ‘Kulang i paghenan na irik ko! Anya mina i gimetan ko?’ kon na kan. ");
INSERT INTO duo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘Ay, katandi ko dan! Rakrakan ko mina i kamalig ko a alegid, ket pataknagan ko i dakdakkal a kamalig a pagdattonan ha irik ko, ken ngamin a aruwatan ko,’ kon na kan. ");
INSERT INTO duo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sa na, kinagi na lallaki ha baggi na, ‘Masuwerteyak agay! Kusto dan i ginayak ko. Malaka la i biyag ko hanggan ha maski nu hangan a tawen. Isu a magkanak la, ken maginumak la, ken magragsakak la,’ kon na kan na Mabaknang. ");
INSERT INTO duo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ngem inpeta na Dios ha nikuna, ‘Madagel ka, ta yenan a kallap ket matay ka. Ket heya dod i makingbagay ha dagende a inkemot mo?’ kon na Dios ha lallaki a mabaknang. ");
INSERT INTO duo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Isu,” kinagi ni Jesus, “kona bila hito i magimet ha maski nu heya a magpuhon ha babaknang para ha baggi na, ngem magpabiyan ha nebilang na Dios a kinabaknang ha biyag a magnanayon,” kon ni Jesus ha kakpalan aye. ");
INSERT INTO duo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ket kinagi ni Jesus ha toltolduwan na, “Gipu ta kona hito, ipeta ko ha nikam, a awan kam mina magburibur ha pagbiyag moy, onu kasapulan moy. ");
INSERT INTO duo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ta nu atdinan na kam na Dios ha biyag moy, awan moy mina kagin a awan na kam atdinan ha kasapulan moy. Malaka la iday ha Dios. Ta mas mangina i biyag moy ngem kanan onu badu. ");
INSERT INTO duo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Entan moy i manok a hidi. Awan hidi magmula, ket awan hidi maganni. Ket awan ha kamalig di. Pakanan na hidi na Dios. Ket hikam i mas mangina ha Dios ngem manok a hidi. ");
INSERT INTO duo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ket tahod bila a awan ha pagserbe ha buribur. Nu dumemat i tiyempo na katay mo, awan ka makapaalay ha biyag mo gipu ha buribur mo. ");
INSERT INTO duo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Isu, nu awan kam makapaalay ha biyag moy, maski ha ballik la, apay a buriburan moy i maski nu anya a aruwatan moy? ");
INSERT INTO duo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Hikam i mas mangina ngem ha budbudak. Ngem entan moy i budak a hidi. Awan hidi magtarabaho, awan hidi maggimet ha badu. Ngem nabaduwan dan hidi. Ket mas inaamakan i badu na esa a budak ngem ha ngamin a badu ni Hari Solomon, i mamabaknang a Hari ha Israel. ");
INSERT INTO duo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Isu, nu baduwan na Dios i budak a hidi ha inamakan, maski nu matutod hidi nokkan, anya dod ha nikam? Sigurado a pabaduwan na kam bila. Apay wade a ballik la i panahod moy? ");
INSERT INTO duo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Awan kam mina magburibur! Awan kam umangburibur nu anya i pangikan moy onu pangiinum moy. ");
INSERT INTO duo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kona hay i ugali na ngamin a tolay a awan a manahod ha Dios. Ngem ha nikam, awan kam mina magaheg ha nidi. Ta nakatandiyan na Dios a masapul moy idagende a bagbagay. ");
INSERT INTO duo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Imbes na, nakaman moy mina i pinagtongpal moy ha Dios, ket atdinan na kam ha ngamin a kasapulan moy. ");
INSERT INTO duo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Hikam a agagum ko, awan kam mina manteng. Maski nu awan kam makpal, kayat na Hama moy a sakopan na kam ha paghariyan na. ");
INSERT INTO duo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Isu, ilako moy dan i aruwatan moy, ket iyatad moy i korinat ha napobre a hidi. Nu kona hito i gimetan moy, maalap moy nokkan i sabali a baknang ha langit. Bakkan i babaknang ha langit, ta awan hidi mobosan. Bakan hidi ha kinabaknang moy a matakneg, onu makutem na uhad. ");
INSERT INTO duo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Isu, nanakaman moy mina i paghariyan na Dios. Ta maski nu anya i nanakaman moy, iday i kaskasorhan moy ken ibilang moy a kinabaknang,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Magayak kam mina ha maski nu anya a magimet. Maggayak kam mina a kona ha mappiya a tagtagabu a maguray ha happo di. Maski nu awan di katandi i pagsoli na happo di a maggipu ha esa a pagbodaan, awan di adapan i sulu di, ket matennonan pala hidi, penu malakwab di i ruwangan ha sigida, nu magdulaw i happo di. ");
INSERT INTO duo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mappiya i kasasaad di nu sigagayak hidi, a awan hidi makakilap ha pagsoli na happo di. Ta ha ide a happo di, hikuna i magitennon ha tennon na tagabu. Ket hikuna i magpaetnod ha nidi, ken magserbe ha nidi. Ket hikuna i mangpakan ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Isu, mappiya i kasasaad na sigagayak a hidi, uray nu sumoli i happo di ha maski nu anya a oras. Maski nu pagsigram dan, o maski nu lubuk na kallap. ");
INSERT INTO duo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ket kona bila hito ha nikitam,” kinagi ni Jesus, “Halimbawa: nu atoy i makingbilay a makatandi nu hangan i pangsaddap na mahagtakaw ha bilay na, siyempre, madiyan na a palobusan a sumadap i mahagtakaw. ");
INSERT INTO duo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ket kona hito nokkan i pagdemat na Annak na Dios a Nagbalin a Tolay. Ta kona ha mahagtakawak a dumemat ha sigida. Isu, magayak kam mina, a kona ha tagabu a hidi, penu makipagsalpak kitam. Ta sumoliyak nokkan ha tiyempo a awan moy mapugtowan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sinalodsod ni Pedro, “Apo, inestoriya mo ide para ha nikami la a agum mo, onu para ha ngamin a totolay?” ");
INSERT INTO duo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ket tinabbeg ni Jesus, “Inestoriya ko ide para ha maski nu heya a malaing a tagabu, a makaunod perpermi ha happo na. Hikuna i tagabu a meturayan na happo na ha bilay na. Ket i tagabu hito i magpakan ha ngamin a sabali a tagabu ha kanan di a husto. ");
INSERT INTO duo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ket mappiya i kasasaad na ide a tagabu nu sumoli i happo na, ket maenta na a nagtongpal i tagabu na ha ngamin a nebon ha nikuna. ");
INSERT INTO duo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta ipeta ko ha nikam, a meturayan na happo i tagabu na heya ha ngamin a aruwatan na. ");
INSERT INTO duo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Ngem kagbi hikuna nu sabali i nakam na. Ket nu nakaman na a maalay pala, a awan pala dumemat i happo na. Ket nu mangrugi hikuna a magbaot ha sabali a tagtagabu, a maski lallallaki, onu babbey a hidi. Ket nu magkan la hikuna, onu maginum la hikuna, ken maging mabartek hikuna. Agay, kagbi hikuna. ");
INSERT INTO duo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ta sumoli i happo na ha tiyempo a awan na mapugto. Ta awan na katandi i tiyempo na pagdemat na happo na. Ket nu dumemat i happo na, siyempre, isina na i tagabu aye, a ipaagum na hikuna ha nagsalungasing a hidi. ");
INSERT INTO duo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Dakdakkal i parusa ha tagabu a makatandi ha panggep na happo na, ngem awan na pagayakan i baggi na a magtongpal. ");
INSERT INTO duo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ket balballik i parusa ha tagabu a awan makatandi ha panggep na happo na, maski nu gimetan na i madukas a pakaparusaan na mina. Ket kona bila ha ide, a ipeta ko ha nikam. Nu makpal i neyatad ha esa a tolay, siyempre, makpal mina i mesulet na nokkan. Onu makpal unay i neyatad ha esa a tolay, siyempre, makpal bas i mesulet na,” kinagi ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“I pagdemat ko ha lutak i kona ha esa a lallaki a umangay a magtutod ha sikaw na. Ket i kona ha gangatan ko i pangpadalus ko ha totolay a manahod. Ket kona ha pangpasina i gangatan ko ha totolay a magmadi a manahod. Ket kayat ko gamen a mangrugi dan ide a gangatan! ");
INSERT INTO duo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngem ha palungo a makapagangatak ha ide a gangatan, masapul a magattamak ha makpal a rigrigat. Ket matagegak hanggan mobos idenday a rigrigat. ");
INSERT INTO duo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Baka kagin moy a inumangayak ha he penu maadya ko i ngamin a rigrigat. Awan agay! Awan a makapatalna i pinagdidinaggap ko, nu awan a mapasina na pagditang ko aye. ");
INSERT INTO duo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ta mangrugi ha niyaen, gipu ta hikan, masinasina i totolay. Kona nu atoy i lima a tolay ha esa a pamilya, ket magsina hidi. Ta magkasenti i tallu ha duwa, ket magkasenti bila i duwa ha denday a tallu. ");
INSERT INTO duo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Magsina i pattama, ket magsina i pattena, ket magsina bila i magmanugang a hidi,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tinumulos ni Jesus ha pagitoldu na, ha kakpalan a hidi, “Nu maenta moy i madiklam a ulap ha daya, ikagi moy a dagus a maguden nokkan. Ket nokkan, maguden man. ");
INSERT INTO duo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ket nu mabati moy i pahas a magipu ha abagat, ikagi moy a maging mapassi nokkan. Ket nokkan, naging mapassi dan. ");
INSERT INTO duo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ngem aginmalmalaing kam agay! Ta malaing kam, nu pugtowan moy i uden, onu passi. Ngem madiyan moy a makatandiyan i tiplad a pangpakatandi ha tiyempo aye. ");
INSERT INTO duo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Apay a madiyan moy a makatandiyan i paggimet a mappiya? Nokkan, nu matay kam, madusa kam, gipu ta madukas i paggimet moy. ");
INSERT INTO duo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","59","“Kona ha ide i tiyempo aye. Kona nu atoy i mayat a mangidarum ha nikaw ha saguppang na hukom. Ket ha palungo a isaguppang na ka ha hukom, siyempre, padasan mo a ikabos i gahut mo. Nu awan mo mekabos ha nikuna, sigurado a isaguppang na ka ha hukom. Ket iyatad na ka na hukom ha pulis. Ket ipabalud di ka. Ket ipeta ko ha nikaw, iday a pagbaludan i paghenan mo hanggan mobos i ngamin a gahut mo. Isu, makatandiyan moy mina i mappiya a tiplad na tiyempo aye, penu awan kam mapaliwatan ha saguppang na hukom nokkan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Niyaen, atoy bila ha kakpalan aye, i nangibaheta ha ni Jesus megipu ha ginimet ni Gobernador Pilato. Ta pinatay ni Pilato i kappal a Judyo a taga-Galileya, idi nangiwagah hidi ha Dios ha Templo. ");
INSERT INTO duo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ket kinagi ni Jesus, “Anya ha nakam moy? Kagin moy wade a inpalobus na Dios i pinagpatay ni Pilato gipu ta mas madukas idagende a Judyo ngem ha ngamin a sabali a Judyo a taga-Galileya? ");
INSERT INTO duo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Awan agay! Mekalan hidi ha nikam ngamin. Ket ipeta ko ha nikam, a nu awan kam sumina ha liwat moy, matay kam bila a kona ha nidi. Matay kam ngamin. ");
INSERT INTO duo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Anya i nakam moy megipu ha dagendo a esa pulo ket walu a taga-Siloam, idi natakneg i torre ha nidi? Natay dawan hidi ta mas madukas i liwat di ngem ha sabali a tolay ha Jerusalem? ");
INSERT INTO duo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Awan agay! Ta maski hikam, nu awan kam sumina ha liwat moy, kona dalla ha denday i magimet ha nikam nokkan. Matay kam ngamin ha rigrigat,” kon ni Jesus ha kakpalan aye. ");
INSERT INTO duo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ket inestoriya ni Jesus ha nidi a kakpalan. “Nikuna, atoy i esa a lallaki a makinglutak. Ket atoy bila ha lutak na i kayo a managenan ha ‘igos’ i bunga na. Inerieriyok na makinglutak i igos ha iday a kayo, ngem awan na naeriyokan. ");
INSERT INTO duo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Isu, inpeta na ha esa a mahagdapon ha lutak na, ‘Pukanan mo iday a kayo, ta inerieriyok ko dan ha tallu a tawen, ngem awan ko pala naeriyokan uray esa la a igos ha iday a kayo. Adyan mo mina, penu awan na mekabos i tabbi na lutak,’ kon na makinglutak. ");
INSERT INTO duo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ngem kinagi na mahagdapon, ‘Apo, kabengan mo bi ha esa la a tawen. Ket lamonan ko mina, ket dattonan ko ha pagpatabbi ha lebut na. ");
INSERT INTO duo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sa, nu magbunga, mappiya. Ket nu awan magbunga ha esa a tawen, papukan mo dan,’ kon na mahagdapon.” Ide i inestoriya ni Jesus megipu ha pagbabawi. ");
INSERT INTO duo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nagitoldu manon ni Jesus ha esa a Sabado ha kapilya na Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ket atoy bila i babbey a pinagsaket na dimonyo ha esapulo ket walu a tawen. Kinammol dan hikuna, a awan na kaya isunong i baggi na. ");
INSERT INTO duo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Idi naenta ni Jesus hikuna, inayagan na. Ket kinagi na, “Manay, awan dan i saket mo!” ");
INSERT INTO duo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ket tinumulos ni Jesus a intupo na i kamat na ha nikuna, ket dagus a tinumaknag ide a babbey, ta nasunong dan i baggi na. Ket nagdeyaw hikuna ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ngem nagingal i kapitan na kapilya na Judyo a hidi. Ta nagpahusay ni Jesus ha saket, maski ha Sabado. Isu a kinagi na kapitan ha kakpalan a hidi ha kapilya, “Atoy i annam a pamalak a pangtarabaho, ket umangay kam mina ha dagenday a pamalak, penu magpahusay ha baggi moy. Ngem madukas man nu magpahusay kam ha Sabado,” kon na kapitan. ");
INSERT INTO duo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ket tinabbeg ni Jesus, “Hikam i aginpappiya! Ipeta moy a awan kam magtarabaho ha Sabado, ngem heya ha nikam a awan na lakbisan i baka, onu kabayo na, ket guyodan na ha dinom, maski nu Sabado? ");
INSERT INTO duo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Niyaen, atoy he i apo ni Abraham, ket kona ha nagakadan na hikuna ni Satanas ha esa pulo ket duwa a tawen, ngem madiyan moy a malakbisan hikuna ha pamalak a pagpaemmang. Agay!” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ket idi nateman di i tabbeg ni Jesus, nasanikiyan dan i kakasenti ni Jesus. Ngem nagragsak i ngamin a sabali a tolay, gipu ta mappiya man i ginimigimet ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ket kinagi ni Jesus, “Anya wade i kekalanan ko ha paghariyan na Dios? Kona ha anya wade i kadakkal na? ");
INSERT INTO duo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ikalan ko ito ha esa a bukal na mustasa a inmula na lallaki ha lutak na. Ket tinumubu ide a bukal a hanggan dinumakkal dan unay, ket nagraborabon i manok a hidi ha tingitingi na. Ket kona bila hito i pagtubu na paghariyan na Dios ha kakpalan a tolay.” ");
INSERT INTO duo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ket tinumulos pala ni Jesus, “Panyan ko a mepakatandi ha paghariyan na Dios ha totolay? ");
INSERT INTO duo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kona bila ha ide, a kona ha lebadura. Ta nu atoy i babbey a magluto ha tinapay na, alapan na i ballik la a lebadura. Ket ilaok na ha dakkal a basket na arena, hanggan maalisan na i ngamin a arena. Ket bumigal ide a arena. Ket kona bila hito i pagiyalis na paghariyan na Dios ha totolay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ket tinumulos di Jesus ha paglakad di ha Jerusalem. Ket idi paglakad di, hinumuyot hidi ha kada baryo ken kada ili, penu magitoldu. ");
INSERT INTO duo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ket atoy i esa a tolay a nagsalodsod ha, “Apo, anya wade? Ballik la wade i totolay a isalakan na Dios nokkan?” Ket tinabbeg ni Jesus, ");
INSERT INTO duo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kona ha masupit a ruwangan i biyag a magnanayon a awan ha kahad. Padasan mo dod a sumadap ha ruwangan aye niyaen, ta padasan na bila na kakpalan nokkan. Ngem awan di kaya sumadap nokkan. ");
INSERT INTO duo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Ikaspangaregan, nu dumemat iday a tiyempo nokkan, i kona nu atoy i esa a makingbilay a umikat ket seradowan na i ruwangan na. Ket kona nu hen kam pala ha lapos, ket magtoktok kam ha ruwangan, ket kona nu ipeta moy, ‘Apo, pakilakwab mo bi i ruwangan ha nikami!’ Agay, tabbegan na kam, a ‘Awan takam katandi, onu taga hadya kam!’ ");
INSERT INTO duo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ket nu tumabbeg kam ha, ‘Awan Apo, katandiyan mo kami, ta nakipagkan kitam ket nakipaginum kitam nikuna. Tinolduwan mo kami ha ili mi!’ kon moy a. ");
INSERT INTO duo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ngem ipeta manon na makingbilay, ‘Awan takam katandi onu taga hadya kam! Umadiyo kam dan, hikam a maggimet ha madukas!’ Ito i kagiyan na makingbilay.” ");
INSERT INTO duo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ket intulos ni Jesus, “Nokkan nu dumemat iday a tiyempo, maenta moy i minappo moy a hidi a ni Abraham, ni Isak, ni Jakob, ken ngamin a minahagpugto a hidi. Maghen hidi ha paghariyan na Dios. Ngem hikam i metogbak dan. Ket magsangisanget ken magdigidiging kam ha rigrigat moy. ");
INSERT INTO duo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nokkan, nu dumemat iday a tiyempo, dumemat i tolay a maggipu ha ngamin a lugar ha lutak: ha amiyanan, ha abagatan, ha laod, ken ha daya. Maski hidi a bakkan a Judyo. Ket umetnod hidi ha paghariyan na Dios. Ket magkan hidi ha piyesta na Dios. ");
INSERT INTO duo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ket baka kagin moy a awan mina hidi makasaddap ha paghariyan na Dios, ta bakkan hidi a Judyo. Ngem ipeta ko ha nikam, a hidi man i primero a sakopan na Dios ha paghariyan na. Ket ha nidi a kagin moy a magpalungo mina a sumadap, agay, awan hidi makasaddap,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ha iday a oras, dinumemat i kappal a Pariseyo, penu iwadan di ni Jesus. “Umadiyo kam dan,” kon di. “Bumuyot kam mina ha sabali a lugar, ta kayat ni Herod a patayan na ka,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ket tinabbeg ni Jesus, “Umangay kam ha iday a mahagsikap, ket ipeta moy a awanak pala lumapos. Ta magtulosak a magpalakad ha dimonyo a hidi ket magpahusay ha masaket a hidi. Ide i gimetan ko ha yenan a pamalak ken esa ugma, ket hanggan matongpal ko i panggep na Dios. ");
INSERT INTO duo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ta kasor ko a tulosan i paglakad ko ha yenan a pamalak, ken esa ugma, ket hanggan dumematak ha Jerusalem. Ta Jerusalem i kinatayan na bila na minahagpugto a hidi. ");
INSERT INTO duo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Hikam a totolay na Jerusalem,” kon ni Jesus. “Kagbi kam! Kanayon kam a magbuno ha nidi a mahagpugto! Kanayon moy a bisagan i paangayan na Dios ha nikam! Maminmakpal a beses a kinayat takam daponan, a kona ha manok a lakopan na i piyak na a hidi, ngem awanak moy palobusan. ");
INSERT INTO duo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Isu, niyaen, pabiyanan na kam na Dios, ket pabiyanan na bila i Templo a pinataknag moy. Ket ipeta ko ha nikam, awanak moy maenta manon hanggan magsoliyak, ket ipeta moy, ‘Deyawan tam hikuna a pinaangay na Dios!’,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Idi esa a Sabado, nakipagkan manon ni Jesus ha bilay na esa a kapitan na Pariseyo. Ket siniiman di ni Jesus, penu maenta di nu makaliwat ni Jesus ha Linteg na Judyo. ");
INSERT INTO duo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Niyaen, idi naghen ni Jesus ha bilay na Pariseyo, atoy i esa a lakay a dinumemat ha ni Jesus. Bitiniya unay i tikad ken labunogen na. ");
INSERT INTO duo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ket sinalodsod ni Jesus ha Pariseyo a hidi ken mamaestro na linteg, “Anya i nakam moy ha Linteg tam? Anya, mapalobusan na i pagpahusay ha Sabado, onu ikemot na? Ta iday kan i liwat ha linteg tam,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ngem madiyan di a tumabbeg. Isu, sinalpak ni Jesus iday a lakay a bumigi, ket pinahusay na. Sa na, pinalakad hikuna. ");
INSERT INTO duo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ket sinalodsod ni Jesus ha nidi a inumetnod ha bilay, “Tahod a awan kam magtarabaho ha Sabado? Anya nu atoy i annak mo a natakneg ha abot a madisalad, o uray nu kabayo mo la i natakneg, anya, awan kam dod magtarabaho, penu guyodan mo hikuna ha lapos, maski nu Sabado?” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ngem awan hidi tinumabbeg, ta naabak dan hidi. ");
INSERT INTO duo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Niyaen, atoy bila i naawis a hidi ha pangapon na Pariseyo aye. Ket idi inumetnod hidi a magkan, siniiman ni Jesus nu heya i magpili ha inamakan a pagetnodan, a para ha tolay a matangkay. ");
INSERT INTO duo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ket kinagi ni Jesus ha nidi ngamin, “Kona hito, ipeta ko ha nikam. Nu meawis ka ha pagbodaan, awan kas umetnod ha inamakan a etnodan a para ha matangkay. Ta baka dumemat pala i mas matangkay ngem ha nikaw. ");
INSERT INTO duo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ket baka ipeta na lallaki a magpaboda, ‘Agay, awan kas umetnod ha he, ta ide i pagetnodan para ha sabali!’ kon na. Ket masanikiyan ka dan, ta paetnodan na ka ha lamessa ha sidung. ");
INSERT INTO duo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Imbes na hito, mappiya pala, nu meawis ka ha pagbodaan, umangay ka mina ha sidung, ket umetnod ka hay. Ket nu maenta na ka na lallaki a magpaboda, ipeta na ha nikaw, ‘Agay, umunek kas. Makipagkan kitam ha ontok,’ kon na. Ket awan ka masanikiyan, ket mappiya malla i nakam na ngamin ha nikaw. ");
INSERT INTO duo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gipu ta kona ide pala: ha nidi a magpatangkay ha baggi di niyaen, mapasanikiyan hidi nokkan. Ngem ha nidi a magpadibbi ha baggi di niyaen, mapatangkay hidi nokkan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ket kinagi ni Jesus ha kapitan na Pariseyo a nagawis ha pangapon aye, “Nu magiyawis ka ha esa a pangaldew onu esa a pangapon, awan kas magiyawis ha ilailay mo la, onu kakabiyan mo la, onu kakaili mo a mabaknang. Gipu ta, awisan di ka bila nokkan, ket iday la i gungguna mo. ");
INSERT INTO duo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bakan mina i ugali moy! Mappiya pala nu awisan mo i napobre a hidi, i mapikot a hidi, i napilay a hidi, ken i nabulsak a hidi. Kona hito. ");
INSERT INTO duo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ket atoy i gungguna mo nokkan a maggipu ha Dios. Gipu ta kinagbiyan mo hidi a awan makasulet ha ginimet mo. Ket dumemat nokkan i tiyempo nu pabiyagan manon na Dios i mappiya a totolay. Ket iday i tiyempo a pagsulet na Dios ha nikaw,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ha pangapon na Pariseyo aye, atoy bila i esa a nakikan ha ni Jesus. Ket idi nateman na ito a kinagi ni Jesus, kinagi na ha nikuna, “Mappiya i kasasaad na makipagkan a hidi ha paghariyan na Dios!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ket inestoriya ni Jesus ide a pangipakatandi na, “Atoy idi i pinagsilebra na mabaknang. Ket inawis na i makpal a tolay. ");
INSERT INTO duo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Idi nasagana dan i pagsilebra na, pinaangay na i esa a tagabu na a mangipeta ha nidi a naawis dan, ‘Uyoy kam, ta nesagana dan ngamin,’ kon na kan na tagabu na. ");
INSERT INTO duo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ngem nagkalan hidi ngamin, a nagpambar hidi. Kinagi na esa, ‘Kaggatang ko ha talon. Isu, masapul a umangayak a mangenta. Pasensiyaanak mo bi,’ kon na kan na esa. ");
INSERT INTO duo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ket kinagi na sabali, ‘Kaggatang ko ha esa pulo a nuwang. Masapul a umangayak a padasan ko hidi. Pasensiyaanak mo bi,’ kon na kan bi. ");
INSERT INTO duo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ket kinagi na sabali, ‘Kakabkabanga ko dalla. Awanak dod makaangay,’ kon na kan bi. ");
INSERT INTO duo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sa, nagsoli i tagabu ha mabaknang, ket inbaheta na i megipu ha ngamin a kinagi di a inawis na. Dadi, agay! Nakaingal i mabaknang aye. Kinagi na, ‘Sagidan mo. Umangay ka dan ha karkarsada ken dilan na ili. Ket alapan mo i tolay a hidi ho. Maski hidi a mapobre, ken mapikot, ken mabulsak, ken mapilay a hidi,’ kon na kan ni Mabaknang. Ket nagsigida dod i tagabu aye. ");
INSERT INTO duo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Niyaen, idi nagsoli hikuna, inpeta na, ‘Apo, ginimet ko i ngamin a inbon mo, ngem makpal pala i paghenan ha bilay mo,’ kon na kan na tagabu. ");
INSERT INTO duo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ket kinagi na mabaknang ha tagabu na aye, ‘Umangay kas ha diladilan ha talon. Ket pasaddapan mo i tolay a hidi, penu maputat i bilay ko. ");
INSERT INTO duo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ket ha ngamin a hidi a inumadi ha awis ko, pulos, awan hidi makapadas ha pagsilebra ko. Ide dan i ipeta ko ha nikam,’ kon na kan ni Mabaknang.” Ket ito i estoriya ni Jesus megipu ha paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Idi naglakad ni Jesus, inumuseg bila i kakpalan a tolay. Ket sinumoleg hikuna, a inpeta na ha nidi, ");
INSERT INTO duo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ha maski nu heya a kayat a umuseg ha nikan, penu tolduwan ko, masapul a ayayatanak na ha mas dakkal. Nu awan dakdakkal i pinagayat na ha nikan ngem ha sabali, awan a mabalin a maging esa a agum ko. Maski nu hama na onu hena na, onu kabanga na ken annak na a hidi, onu hekka na ken wadi na a hidi, o maski nu baggi na a mismo. Masapul a ayayatanak na ha dakdakkal ngem ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ta awan a mabalin a maging esa a agum ko, nu awan na ak usegan, ken kabengan na i baggi na, maski nu matay,” kon ni Jesus ha kakpalan a hidi. ");
INSERT INTO duo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ket intulos na, “Ta kona ha ide a ibilang moy mina i gastos na paggimet moy. Nu atoy i tolay a kayat na a magpataknag ha mangina a bilay, siyempre, ha palungo a paggatang na ha aruwatan, masapul a ibilang na i gastos na aruwatan. Ta baka kulang i korinat na. ");
INSERT INTO duo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nu awan hikuna magbilang, baka metolnak na la i adigi, ket awan metulos. Isu a pagngidingiditan di nokkan na makaenta ha pinagbilay na. ");
INSERT INTO duo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Agay, nangrugi i lallaki aye ha bilay na, ngem awan na kaya a ubosan,’ kon di man. ");
INSERT INTO duo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ket kona bila hito i ugali na hari a hidi. Nu atoy i esa a hari, a maglaban mina ha sabali a hari, siyempre, ibilang na i sundalu na a hidi. Ket nu atoy ha nikuna i esa pulo a ribu a sundalu, ngem atoy i duwa a pulo a ribu i sundalu na kasenti na, nakaman na mina nu panyan na abakan i kasenti na. ");
INSERT INTO duo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ket nu nakatandiyan na a awan na maabak i kasenti na, paangayan na mina i tagabu na a mangsalpak ha kasenti na aye, penu makiuhon hidi a awan makilaban. ");
INSERT INTO duo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Niyaen, hikam mina i magnakam ha kona ha magbilang aye. Ta awan kam makauseg ha nikan nu madiyan moy a ibilang i ngamin a gastos na paguseg moy, ket nu madiyan moy a itirak ngamin. ");
INSERT INTO duo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ket kona pala ha ide,” kon ni Jesus, “kona bila ha asen i tolay a mayat a umuseg ha nikan. Mappiya i asen, ta masinggat i ennam na. Ngem nu lompas dan i ennam na, awan a mabalin a mapasoli i ennam na manon. ");
INSERT INTO duo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Isu, awan ha balle na. Ibanghat moy la. Awan a mabalin a usaran moy ito a pangpatabbi ha mula moy. Ket awan ha balle na, maski nu pangkallab moy ha attay. Ket kona bila hito ha nikam. Ta hikam i kona ha asen a masinggat. Isu, ipeta ko ha nikam, a magteman kam perpermi, nu masaneg moy i kagi ko. Ket nanakaman moy, penu pumigsa pala i panahod moy.” ");
INSERT INTO duo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","2","Idi esa a pamalak, dinumuhapduhap hidi a mahagliwat, a kona ha mahagsinger ha buwis a hidi ken hidi a masegkat ha Linteg na Judyo. Ket kayat di a magteman ha ni Jesus. Ngem atoy bila i Pariseyo a hidi ken mamaestro na linteg. Ket pinagkagikagiyan di ni Jesus, ta nakiilay ni Jesus ha totolay a madukas, kon di kan. Kinagi di, “Kakuyog ni Jesus i mahagliwat a hidi. Ket dadi pala agay, a makipagkan bila hidi!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ket gipu ta kona hito, inestoriya ni Jesus i pangikalan na ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Kinagi na, “Nu atoy i esa a gasut na karnero ha nikaw, ket mapukaw i esa, siyempre, itirak mo i siyam a pulo ket siyam ha talon, ket tanubukan mo i esa hanggan maeriyokan mo. ");
INSERT INTO duo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nu naeriyokan mo dan i esa, magragsak ka, a baklayan mo iday a karnero, ket isoli mo ha bilay moy. ");
INSERT INTO duo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nu nagsoli ka dan ha bilay moy, ayagan mo i agagum mo, a ipeta mo, ‘Magragsak kitam bas, ta naeriyokan ko dan i napukaw a karnero,’ kommo. Ket mas maragsak ka megipu ha esa a naeriyokan mo, ngem ha siyam a pulo ket siyam a awan napukaw. ");
INSERT INTO duo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ket ipeta ko ha nikam a kona ha ide i kayat ko a kagiyan. Nu atoy i esa a tolay a magbabawi ken sumina ha ugali na a madukas, maragsak hidi unay ha langit. Mas maragsak hidi ha langit megipu ha esa a magbabawi, ngem ha siyam a pulo ket siyam a tolay a awan makasapul ha pagbabawi. ");
INSERT INTO duo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ket kona bila ha ide,” kon ni Jesus, “nu atoy i esa a babbey, ket atoy ha nikuna i sampu a pilak, ngem napukaw i esa, maganya hikuna? Siempre, magpagangat hikuna ha sulu di, ket sagadan na perpermi i ngamin a bilay di. Ket dagdagan na i pageriyok na hanggan a maeriyokan na dan i pilak na aye. ");
INSERT INTO duo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nu naeriyokan na iday a pilak, magayag hikuna ha agagum na. ‘Magragsak kitam, ta naeriyokan ko i pilak ko,’ kon na. ");
INSERT INTO duo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kona dalla hito, ipeta ko ha nikam, magragsak unay i anghel a hidi na Dios nu maenta di i maski esa a magbabawi ken sumina ha ugali na a madukas.” Ide i nepeta ni Jesus ha Pariseyo a hidi ken mamaestro na linteg, ta kagin di a awan di masapul a magbabawi. ");
INSERT INTO duo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","“Ket kona pala ha ide,” tinumulos ni Jesus, “Atoy idi i esa a lakay ken duwa a annak na a lallaki. ");
INSERT INTO duo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Inpeta na boridik ha hama na, ‘Hama ko, iyatad mo bi i bunong ko ha gihagihak tam,’ kon na. Isu a binunong na lakay i gihagihak di ha nidi duwa. ");
INSERT INTO duo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Idi awan maalay, inlako na boridik i bunong na, ket linumakad hikuna ha lugar a madiyo. Idi pagdemat na, inubos na i ngamin a korinat na ha nagastador a ugali na. ");
INSERT INTO duo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Niyaen, idi nobos i ngamin a korinat na, dinumemat i nakaro a alap ha ide a lugar, ket nagrigat unay i boridik heya. ");
INSERT INTO duo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Isu a nagpatagabu hikuna ha esa a mannannalon. Ket pinaangay na i boridik ha talon na, penu pakanan na i babboy a hidi. ");
INSERT INTO duo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tahod a kayat na a magkan, maski ha kanan na babboy a hidi, maski nu lupas la. Ta awan hikuna naatdinan ha kanan. ");
INSERT INTO duo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Niyaen, idi sinumoli i pakanakam na, inpeta na ha baggi na, ‘Atoy i makpal a tagabu ha nama ko, ket makpal i kanan di ngamin. Ngem dandaniyak a matay, ta awan ha kanan ko. Mesungotak agay! ");
INSERT INTO duo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Umangayak dod ha nama ko. Ket ipeta kos ha nikuna, “Hama ko, nagliwatak ha Dios ken ha nikaw. ");
INSERT INTO duo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Awanak mo ibilang a annak mo, nu awan mina a tagabu mo.” Kona hito i nakam na boridik.’ ");
INSERT INTO duo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Isu a sinumoli hikuna ha nama na. Ket idi linumakad pala hikuna, inbatabatad nama na, ket naenta na i boridik ha madiyo. Ket kinagbiyan na a nagbuyot hikuna, ket ginakusan na i boridik aye. Ket inammosan na hikuna. ");
INSERT INTO duo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ket inpeta na boridik, ‘Hama ko, nagliwatak ha Dios ken ha nikaw. Awanak mo mina ibilang a annak mo.’ ");
INSERT INTO duo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ngem nagayag i lakay ha tagabu a hidi, ‘Sigida kam, alapan moy i kaaamakan a tennon, ket itennon moy ha nikuna. Isangkalang moy bila ha kamat na. Isapatos moy bila ha tikad na. ");
INSERT INTO duo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Alapan moy bila i malogyaw a baka a matabbi, ket partiyan moy. Magsilebra kitam bas, a magragsak kitam. ");
INSERT INTO duo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ta sinumoli i annak ko aye. Idi pinaglapos na, kona ha natay dan hikuna. Ngem niyaen, kebbiyag pala. Idi, kona ha netawtaw hikuna. Ngem niyaen, naeriyokan ko dan.’ Ide i kinagi na hama na. Ket nagragsak dod hidi. ");
INSERT INTO duo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Niyaen, idi nagragsak pala hidi, sinumoli i hekka na a nagipu ha talon. Ket idi binumikan hikuna ha bilay di, nateman na i musika ken salsala di. ");
INSERT INTO duo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nagsalodsod dod hikuna ha esa a tagabu, ‘Maganya hidi?’ kon na hekka. ");
INSERT INTO duo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ket tinabbeg na tagabu, ‘Sinumoli i wadi mo. Ket pinarti nama mo i malogyaw a baka a matabbi, penu magragsak hidi. Maragsak man ni Lakay, ta nahusay i wadi mo,’ kon na tagabu. ");
INSERT INTO duo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ngem gipu ta kona hito, nagingal i hekka. ket madiyan na a sumadap ha bilay. Isu, linumapos i hama na, ket inpeta na a sumadap mina ha bilay. ");
INSERT INTO duo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngem kinagi na hekka ha nama na, ‘Hama ko, hanggan idi ballikak pala, nagtarabahowak ha nikaw a kona ha tagabu. Awanak nagtalakag ha nebon mo. Ngem hanggan niyaen, awan mo pala inyatad, penu makipagragsakak ha agagum ko, maski nu ballik la a kambing. ");
INSERT INTO duo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ket niyaen, nu sumoli i boridik mo aye, pinarti mo i malogyaw a baka a matabbi! Maski nu inubos na i gihagihak mo ha pampam a hidi!’ kon na hekka. ");
INSERT INTO duo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ngem kinagi nama na, ‘Annak ko, kanayon taka kakuyog. Maski nu anya i aruwatan ko, iday bila i aruwatan mo. ");
INSERT INTO duo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mappiya dod nu magragsak kitam. Ta idi, kona ha natay i wadi mo. Ngem niyaen, magbiyag a tahod. Idi, kona ha netawtaw hikuna. Ngem niyaen, naeriyokan tam manon,’ kon na hama.” Ide i estoriya ni Jesus ha Pariseyo a hidi ken mamaestro na linteg, penu makatandiyan di i pagkagbi na Dios ha totolay a mahagliwat. ");
INSERT INTO duo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ket inestoriya ni Jesus ha agagum a tolduwan na. “Nikuna, atoy i esa a mabaknang ken tagabu na. I tagabu na i mahagdapon ha ngamin a aruwatan na mabaknang. Ket maski nu anya i pangilako na mabaknang, ide a tagabu i tahod a mahagilako. Onu atoy i kayat na mabaknang, magpagatang hikuna ha tagabu aye. Ngem idi esa a pamalak, nabaheta na mabaknang a busbusan na tagabu i korinat na. ");
INSERT INTO duo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Isu, pinasaguppang na mabaknang i tagabu na, ket sinalodsod na, ‘Apay? Inbaheta di a nagliwat ka ha tarabaho mo. Igiwat mo ha nikan i ngamin a inlista mo, penu makatandiyan ko i liwaliwat mo. Sa ka, awan magdapon ha aruwatan ko nokkan,’ kon na mabaknang. ");
INSERT INTO duo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ket linumapos i tagabu aye, ket kinagi na ha nakam na, ‘Anya mina i gimetan ko?’ kon na. ‘Nu awan i tarabaho ko ha mabaknang, awan ha binag ko ha tarabaho a madaggi. Ket masanikiyak a makilimos,’ kon na. ");
INSERT INTO duo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‘Oni ah! Katandi ko dan!’ kon na. ‘Ide mina i gimetan ko, penu magbalinak a ilay di, ket respitaran di ak ha bilabilay di nokkan. Ket maski nu awan ha tarabaho ko, maregaluwan ko hidi,’ kon na tagabu. ");
INSERT INTO duo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ket inpaayag na tagabu i ngamin a nagahut ha ni mabaknang. Ket pinaballik na i gahut di. Isu, naregaluwan na hidi. Idi dinumemat i nekaesa, inpeta na tagabu, ‘Hangan i gahut mo ha ni mabaknang?’ ");
INSERT INTO duo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ket tinabbeg na, ‘Esa a gasut a karamba na langis,’ kon na. Ket inpeta na tagabu, ‘Agay, lima a pulo la mina! Umetnod kas. Ket atoy ha he i papeles a inlista ko ha gahut mo. Sulitan mos ha lima a pulo la,’ kon na tagabu. ");
INSERT INTO duo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Sa na, sinalodsod na tagabu i sabali a nagahut, ‘Hangan i gahut mo ha ni mabaknang?’ kon na. Ket tinabbeg na, ‘Esa a gasut a kaban na pahay.’ Ket inpeta na tagabu, ‘Agay, walu a pulo la mina! Atoy ha he i papeles a inlista ko ha gahut mo. Sulitan mo bi. Isurat mos a walu a pulo la i gahut mo,’ kon na tagabu. ");
INSERT INTO duo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ket idi nateman na mabaknang i pinaggimet na tagabu aye, kinagi na, ‘Dadi pala, malaing iday a tagabu. Ta nakaregalu hikuna para nokkan nu awan hikuna ha tarabaho,’ kon ni mabaknang. “Isu, entan moy,” kinagi ni Jesus. “Dinaydayaw na mabaknang i kinalaing na tagabu he, maski nagsuwitik. Ta kona hito i ugali na tolay a awan a umunod ha nikan. Tahod a mas malaing hidi ha pagsulet di ngem ha tolay a nasakop na Dios. ");
INSERT INTO duo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ket ipeta ko dod ha nikam, a usaran moy mina i aruwatan moy para ha sabali a totolay, penu manahod hidi ken mesalakan. Ket nokkan, ha katay moy, ken awan moy mausar i araruwatan moy, atoy pala i ilailay moy ha henan moy. Ket inaamakan i pagsalpak di ha nikam ha paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Nu mapagtalakan i magdapon ha ballik a aruwatan, mapagtalakan bila hikuna nokkan ha makpal a aruwatan. Onu nagsileng i tolay megipu ha ballik la a bagbagay, mahagsileng hikuna nokkan megipu ha dakkal a bagbagay. ");
INSERT INTO duo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ket kona pala ha ide, nu awan ka mapagtalakan ha baknang ha lutak aye, awan ka mapagtalakan ha sabali a baknang a malagda, ha Paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nu awan a mabalin a metalak ha nikaw i aruwatan na sabali, heya dod i mangiyatad ha nikaw ha bagbagay a magingkuwa mo nokkan? ");
INSERT INTO duo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ta kona pala ha ide, ipeta ko ha nikam. Nu atoy i esa a lallaki, awan a mabalin a magtarabaho hikuna ha duwa a happo na. Nu padasan na, kasoran na i esa, ngem maenglan na i mekaduwa. Ket maguseg hikuna ha esa, ngem sumina hikuna ha mekaduwa. Ket kona bila hito ha nikam. Nu korinat i tahod a korsunada moy, ket nu kona ha korinat i happo moy, awan kam makauseg ha Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Idi nateman di Pariseyo ito a kinagi ni Jesus, inulew di hikuna, gipu ta korinat i korsunada di. ");
INSERT INTO duo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Isu, kinagi ni Jesus ha nidi, “Hikam i magpaenta ha baggi moy ha saguppang na totolay. Ket kona ha maguseg kam ha Dios. Ngem katandiyan na Dios i nakam moy a madukas. Ta i eriyokan moy la i pagdeyaw na totolay. Ngem i tolay a magpadeyaw ha baggi na, iday i tolay a magpaingal ha Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ket tinumulos ni Jesus a nepeta na, “I kakkagi na Dios a insurat di Moyses ken minahagpugto a hidi, idagende i pangitoldu mina ha nikam. Ket awan pala hidi lompas. Idagende i nagitoldu ha nikam hanggan ha pinagdemat ni Juan a Minahagbinyag. Nangrugi hikuna a magitoldu ha mappiya a baheta, a dandani dan i pagdemat na Hari a paangayan na Dios, kon na. Ket ide bila i pagibaheta ko ha ngamin a tolay. Ket niyaen, kayat di ngamin a pumilit a sumadap ha Paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngem nanakaman moy ide, a maski nu umawan nokkan i langit ken ngamin a lutak, awan umawan i maski balballik a bobon na Dios ha Linteg ni Moyses, ken sursurat na minahagpugto a hidi. ");
INSERT INTO duo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Isu,” kon ni Jesus, “hikam i magliwat. Ta nu atoy i esa a lallaki a sumina ha kabanga na, ket mangabanga manon ha sabali, ibilang na Dios a hikuna i mangibabbey. Ket nu atoy i lallaki a makikabanga ha babbey a sinumina ha kabanga na, hikuna bila i mangibabbey ha saguppang na Dios.” Hito i kinagi ni Jesus ha Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sa na, kinagi ni Jesus ide a pangikalanan na: “Nikuna, atoy i esa a mabaknang. Ket nagtennon hikuna ha kanginaan a tennon, ket nagkan ha kanginaan a kalase na kanan. ");
INSERT INTO duo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Ket atoy bila i esa a napobre a nagen na, ni Lasaro. Nagsaket hikuna, ta napeklapeklat i baggi na, hanggan nagdeldel i asu a hidi ha limoto na. Ket kada pamalak, inumabag hikuna ha saguppang na bilay ni Mabaknang. Ket kinasor na a magkan, maski nu murkat la a natakneg ha lamessa na mabaknang. Ngem pulos, awan man. ");
INSERT INTO duo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Niyaen, idi minatay ni Lasaro, neyangay na anghel a hidi ha ni Abraham, ha langit. Ket minatay bila i mabaknang aye, ket nelabbang hikuna. ");
INSERT INTO duo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sa, i paghenan na, i impyerno, a nadusadusa unay ni Mabaknang. Ket tinumangad hikuna, ket naenta na hidi ha langit, ni Abraham ken ni Lasaro. Naenta na a kinakagbiyan ni Abraham ni Lasaro. ");
INSERT INTO duo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ket inayagan na mabaknang, ‘Lakay Abraham, kagbiyanak mo bi. Paangayan mo bi ni Lasaro a maski nu karkolowan na la i dinom, ta madusaak ha gangatan aye. Maski nu itabbung na la i gihagihay na, ket ipatagdu na i dinom ha dila ko,’ kon na mabaknang. ");
INSERT INTO duo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ngem inpeta ni Abraham ha mabaknang, ‘Annak ko, nakaman mo a nikuna, idi nagbiyag ka pala, mabaknang ka, ket malaka la i biyag mo, ta makpal i aruwatan mo. Ket idi tiyempo hito, napobre ni Lasaro, ket awan mo kinagbiyan. Isu, niyaen, kagbiyan ko hikuna, ket hikaw man i madusa ha impyerno ayo. ");
INSERT INTO duo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ket maski nu atoy i esa a mayat a humapog ha nikaw, awan a mabalin. Ta atoy i bangaw ha lubuk hay, penu awan makaangay ha lugar moy a magipu ha lugar mi aye. Ket awan bila makahapog hanggan ha lugar mi ha he i magipu ha lugar moy ayo,’ kon ni Abraham ha ni mabaknang. ");
INSERT INTO duo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Sa na, inaged ni mabaknang ha ni Abraham, ‘Isu, nu kona hito, umagedak ha nikaw, Lakay Abraham. Paangayan mo bi ni Lasaro ha bilay dima ko. ");
INSERT INTO duo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ta atoy pala i lima a pattaka ko. Iwadan na mina hidi, penu awan hidi sumadap ha lugar a pagdusaan aye,’ kon ni mabaknang. ");
INSERT INTO duo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ngem inpeta ni Abraham, ‘Awan agay. Atoy dan i mangiwad ha nidi. I pinesursurat na Dios ha ni Moyses ken ha minahagpugto a hidi, ito mina i mangiwad ha nidi. Magteman mina hidi ha kakkagi na dagenday a surat,’ kon ni Abraham. ");
INSERT INTO duo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ngem kinagi ni mabaknang, ‘Awan, Lakay Abraham. Basta nu umangay ha nidi i esa a tolay, a nagipu ha lugar na natay, ket siguradowak a magbabawi hidi, a sulitan di i madukas a ugali di ha mappiya a ugali,’ kon ni mabaknang. ");
INSERT INTO duo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ngem inpeta ni Abraham ha ni mabaknang, ‘Nu awan hidi magteman ha kakkagi na surat di Moyses ken minahagpugto a hidi, awan hidi mapatahodan. Maski nu magbiyag manon i tolay a minatay,’ kon ni Abraham.” Ito i pangipakatandi ni Jesus ha dagende a Pariseyo. ");
INSERT INTO duo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kinagi ni Jesus ha agagum na a tolduwan na, “Magingat kam, ta atoy i makpal a tolay a magsolisog ken magpaliwat. Ket awan moy hidi melisiyan. Isu, magingat kam, ta atoy nokkan i dakkal a parusa. Ket dakdakkal i parusa ha tolay a magsolisog ken magpasina ha totolay ha nebon na Dios. ");
INSERT INTO duo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kona ha ide, a ipeta ko ha nikam. Marigat nu megakad i pogedu ha tangad na tolay, ket metogbak hikuna ha diget. Oni ah. Ngem atoy i mas marigat a parusa ha magpasina ha esa a madibbi a tolay ha bon na Dios. ");
INSERT INTO duo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Isu, magingat kam a awan kam makapasina ha agagum moy ha Dios. Magingat kam. Nu makaliwat i agum mo, iwadan mo hikuna. Ket nu magbabawi hikuna, pakawanan mo. ");
INSERT INTO duo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maski nu liwatan na ka ha maminpitu ha esa a pamalak, ken sumoli hikuna ha maminpitu, a ipeta na a, ‘Magbabawiyak dan.’, masapul a pakawanan mo hikuna.” Ide i inpeta ni Jesus ha agagum na, a megipu ha pagpakawan di ha kakalan di a tolay. ");
INSERT INTO duo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ket inaged na esa pulo ket duwa a apostol a pinili ni Jesus, “Ipigsa mo bi i panahod mi,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ket inpeta ni Jesus, “Nu atoy ha nikam i panahod a kona ha kadakkal na bin-i na mustasa, mabalin moy a mepeta ha dakkal a kayo aye a, ‘Mabaghot ka dan, ket memula ka dan ha diget!’ ket magimet iday a inbon mo.” Ide i nepeta ni Jesus ha agagum na a megipu ha panahod a mapigsa. ");
INSERT INTO duo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Intulos na, “Ket kona pala ha ide, a ipeta ko ha nikam. Nu atoy ha nikam i tagabu a sumoli a nagipu ha pagaradowan na, onu pagdaponan na ha karnero, awan mo ipeta, ‘Hen ka dan, a magkan.’ ");
INSERT INTO duo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ta kagangay moy a magkagi ha, ‘Magdegus ka dan, ket sulitan mo i tennon mo, ket lutowan mo i kanan. Sa, nu naubosak a magkan, magkan ka bila.’ Kona ide i ugali moy. ");
INSERT INTO duo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ket awan kam magyaman ha tagabu aye, ta iday i tarabaho na. ");
INSERT INTO duo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ket kona bila hito ha nikam. Nokkan nu tinongpal moy i ngamin a nebon ha nikam, magipeta kam mina a, ‘Masaniki kami la, ta tinongpal mi la i nebon ha nikami,’ kon moy mina.” Ide i inpeta ni Jesus ha agagum na megipu ha pagserbe di ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Idi pinaglakad di Jesus ha Jerusalem, linumakad hidi ha nagbaitan na Samariya ken Galileya. ");
INSERT INTO duo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ket idi binumikan hidi ha esa a baryo, natagbuwan di i esa pulo a magkattal. Awan hidi binumikan ha di Jesus, ta maneg ha linteg na Judyo nu bumikan i magkattal ha tolay a makaradkad. ");
INSERT INTO duo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Imbes na, nakataknag hidi ha madiyo ket nagayag ha, “Jesus, Apo, kagbiyan mo kami!” kon di mahagkattal. ");
INSERT INTO duo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Niyaen, idi naenta na hidi ni Jesus, inpeta na, “Lumakad kam dan ha padi a hidi. Ket ipabileng moy i baggi moy ha nidi, ta nahusay dan,” kon ni Jesus. Sa, idi lumakad pala hidi, agay, hinumusay hidi! ");
INSERT INTO duo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ket idi nakatandiyan na esa a hinumusay i baggi na, sinumoli hikuna ha di Jesus. Sakay! Agay, dineydeyaw na unay i Dios. ");
INSERT INTO duo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ket hinumakab hikuna ha saguppang ni Jesus, penu magyaman. Ngem temanan moy mina agay. Ta taga-Samariya i nahusay aye, ket nakaingal kan mina i Judyo a hidi ken hidi a taga-Samariya, kon na kan. ");
INSERT INTO duo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Isu, gipu ha kona hito, kinagi ni Jesus ha agagum na, “Entan moy. Pinahusay ko i esa pulo a nagkattal. Ngem awan hidi ngamin sinumoli. I esa la a taga-Samariya i nagsoli, penu magdeyaw ha Dios. Hadya wade i siyam a Judyo?” kon na. ");
INSERT INTO duo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sa na, inpeta ni Jesus ha nikuna, “Ilay ko, umikat ka. Tumulos ka dan. Nahusay ka, gipu ta tinahodak mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Idi esa a pamalak, nagsalodsod i Pariseyo a hidi nu hangan i pagdemat na paghariyan na Dios. Ket tinumabbeg ni Jesus, “Awan maenta na tolay i pagdemat na paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Awan hidi makepeta a, ‘Entan mo, ha he dan i paghariyan na Dios’ onu ‘Iho la, ha ho, i paghariyan na Dios!’ Katandiyan moy mina ide, a kayat na Dios a maghari ha nakam na tolay, ha disalad na totolay. Iday i tahod a paghariyan na Dios,” kon ni Jesus ha Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kobosan na ide, inpeta bila ni Jesus ha agagum na, “Dumemat i tiyempo nokkan nu kayat moy a maenta i pagsoli na Annak na Dios a Nagbalin a Tolay, maski esa la a pamalak i paghari ko. Ngem awan moy maenta. ");
INSERT INTO duo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ha iday a tiyempo, atoy i kappal a magkagi ha, ‘Atoy ni Cristu ha ho!’ onu ‘Atoy ha he ni Cristu!’ kon di. Ngem awan moy hidi usegan, ket awan moy hidi tahodan. ");
INSERT INTO duo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ta nokkan nu sumoliyak ha lutak, kona ide i pagsoli ko, a kona ha killat a maggangat ha ngamin a langit. Ket madinnang hito, ket maenta na ngamin a tolay. Kona iday bila i pagsoli ko ha kasaguppangan. ");
INSERT INTO duo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngem masapul pala a magattamak ha makpal a rigrigat. Ket masapul a madiyan na ak na kababayan tam. ");
INSERT INTO duo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ha kasaguppangan, ha tiyempo na pagsoli ko, magkalan i ugali na totolay ken ugali na tiyempo ni Noe, nikuna naalay dan. ");
INSERT INTO duo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Idi tiyempo di Noe, awan hidi nagnakam ha Dios. Ta nagnakam la hidi ha pinagragsak di. Ket nakipagkan hidi, nakipaginuman hidi, nakipagboda hidi. Kona dalla ito i ginimigimet di, hanggan bigu la a nagsaddap di Noe ha dakkal a barko. Sa, dinumemat i kadakalan a layus. Ket nebulod hidi ngamin a awan nagnakam ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ket kona bila ide i kekalan na tolay nokkan. Ta kona bi idi tiyempo di Lot, ket nakipagkan hidi, nakipaginuman hidi, nakanggatang hidi, naglako hidi, nagmula hidi, nakangsogkab hidi. ");
INSERT INTO duo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ngem awan hidi nagnakam ha Dios. Ket tinumulos la hidi hanggan bigu a pinalapos na Dios di Lot, ha lapos na ili di a Sodoma. Ket bigu la, a pinataknag na Dios i gangatan a nagipu ha langit, hanggan natay hidi ngamin a nagkabeng ha Dios. Isu, bigu la i pinangrakrak na Dios ha nidi ha Sodoma. Ket sigida la i pinangisalakan na ha di Lot, ta linumapos hidi. ");
INSERT INTO duo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ket kona bila hito i tiyempo nokkan, nu ipaenta na Dios i Annak na Dios a Nagbalin a Tolay. Ta makaenta i ngamin a tolay. Ta madinnang ito. ");
INSERT INTO duo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ket nokkan, nu dumitang iday a pamalak, kabeng mon i aruwatan moy a matirak ha bilay moy. Ket nu hen kam ha lapos, awan kam sumoli ha bilay penu alapan i aruwatan moy. Onu lumakad kam ha talon, awan kam sumoli ha bilay. ");
INSERT INTO duo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Manakam moy i kabanga ni Lot, a napatay na Dios ta kayat na a sumoli. ");
INSERT INTO duo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Maski nu heya a magikemot ha biyag na ha Dios, penu makatulos ha pagbiyag na, matay hikuna nokkan. Ket maski nu heya a mangpabiyan ha baggi na a maski matay gipu ha nikan, makabiyag manon hikuna ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ket ipeta ko ha nikam, a kona bila ha ide nokkan, ha tiyempo a pagsoli ko. Nu magsoliyak ha kallap, ket atoy i duwa a lallaki a magduhog, ngem esa la i manahod ha nikan, bigu la a alapan ko i esa a umuseg ha nikan. Ngem matirak la i agum na. ");
INSERT INTO duo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Onu kona bila ha ide, nu atoy i duwa a babbey a magbiyu, ngem esa la i manahod ha nikan, bigu la a alapan ko i esa a makauseg ha nikan. Ngem i agum na, awan makauseg,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ket sinalodsod na agagum na, “Apo, hadya a magimet ide?” Ket tinabbeg ni Jesus, “Madinnang nokkan i pagsoliyan ko. Ikaspangarigan, nu maenta moy i kakpalan a wakwak, makatandiyan moy a atoy i bangkay a awan nelabbang. Ket kona bila hito nokkan ha pagsoli ko, ta maenta na ngamin a tolay.” ");
INSERT INTO duo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ket nagiestoriya ni Jesus ha agagum na, penu katandiyan di a kanayon mina hidi a magkararag, ket awan maging malupoy, onu maggimak ha pagkararag di. ");
INSERT INTO duo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Isu, inestoriya na, “Atoy idi i esa a hukom ha ili. Awan hikuna manteng ha Dios, onu magrespitar ha maski nu heya a tolay. ");
INSERT INTO duo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ket atoy bila, ha iday a ili, i esa a babbey a nabilu. Ket kanayon hikuna inumangay ha ni hukom penu umaged. ‘Daponanak mo bi ha kasenti ko,’ kon ni Bilu. ");
INSERT INTO duo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ket naalay a nagmadi ni hukom. Ngem idi nobos i naalay a tiyempo, ninakam na, a ‘Awanak manteng ha Dios, onu magdeyaw ha maski nu heya a tolay. ");
INSERT INTO duo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ngem gipu ta kanayon na tappagan i tarabaho ko, daggapan ko mina hikuna. Nu awan ko hikuna daggapan, paungan na ak na bilu aye,’ kon ni hukom.” ");
INSERT INTO duo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Intulos ni Jesus, “Temanan moy i kinagi na madukas a hukom aye. Ta maski awan hikuna ha kagbi, inaguman na i bilu, ta dagdagan na a magaged. ");
INSERT INTO duo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Isu, magsiguradowak ha nikam, a aguman na Dios i tolay a hidi a pinili na. Ta hidi i magpakagbi ha nikuna ha kanayon a pamalak ken kallap. Ket awan na pemasan i daggap na. ");
INSERT INTO duo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Masigida malla i pagagum na Dios. Ngem maski nu kona hito i daggap na Dios, nu magsoliyak nokkan ha lutak aye, ballik la wade i totolay a manahod ken magkararag, onu makpal wade hidi?” kon ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Inestoriya manon ni Jesus ha totolay a nagkagin a mappiya i baggi di, a awan ha liwat di, ken magulew ha sabali a totolay. ");
INSERT INTO duo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Inestoriya ni Jesus, “Inumangay i duwa a lallaki ha Templo, penu magkararag. Pariseyo i esa, ket mahagsinger ha buwis i sabali. Sa hidi, nagkararag a duwa. ");
INSERT INTO duo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kona ha ide i kararag na Pariseyo, a tinumaknag hikuna a esesa ket nagkararag ha nakam na a, ‘Dios, magyamanak ha nikaw, ta awanak nagliwat a kona ha sabali a tolay. Awanak magtakaw, awanak magsileng, awanak magibabbey, onu maski kona ha iday a mahagsinger ha buwis. Magyamanak ha nikaw, ta awanak nagliwat a kona ha nikuna. ");
INSERT INTO duo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ket magpesungotak ha baggi ko, ha mamenduwa a pamalak ha esa a dominggo, penu mappiya i pagkararag ko. Ket iyatad ko ha nikaw i pagkasangapulo na ngamin a alapan ko,’ kon ni Pariseyo. ");
INSERT INTO duo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ngem bakkan i mahagsinger ha buwis, ta masaniki hikuna. Tinumaknag la hikuna ha madiyo, ket tinumokham la, ta masaniki hikuna. Awan hikuna tinumangad ha langit. Imbes na, nagsanget dalla, ta hikuna i nagbabawi a tahod. Inpeta na, ‘Ananay, Apo Dios, kagbiyanak mo bi, ta nagliwaliwatak unay,’ kon na mahagsinger ha buwis. ");
INSERT INTO duo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ipeta ko ha nikam,” kon ni Jesus, “idi sinumoli hidi ha bilay di, napakawan dan i mahagsinger ha buwis. Ngem awan napakawan i Pariseyo. Gipu ta maski nu heya a magpadeyaw ha baggi na niyaen, hikuna i mapasanikiyan nokkan. Ngem maski nu heya a magpadibbi ha baggi na niyaen, hikuna i madeyawan nokkan,” kon ni Jesus. Ito i netoldu ni Jesus ha nidi a nagulew ha sabali a totolay. ");
INSERT INTO duo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Idi esa a pamalak, atoy i kappal a tolay a nangiyangay ha annak di ha ni Jesus, penu itupu na i kamat na, ket bendisyonan na hidi. Ngem idi netan na agagum ni Jesus, binahang di hidi a nangiyangay ha annak. ");
INSERT INTO duo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Ngem inayagan ni Jesus i annak a hidi, “Uyoy kam he,” kon na. Ket inpeta na ha agagum na, “Palobusan moy a umangay i annak a hidi ha nikan. Awan moy hidi salenan, ta magkalan hidi ha totolay a sumasaddap ha paghariyan na Dios. Inaamakan man i panahod di. Ket kona bila hito i kayat na Dios ha totolay a masakop na. Tamos. Ipeta ko ha nikam, nu awan a kona ha annak i panahod moy, awan kam makasaddap ha paghariyan na Dios,” kon ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ket nagsalodsod i esa a Judyo a matangkay, “Mappiya a Maestro, mappiya i gimetan mo. Isu, ipeta mo bi. Anya mina i gimetan ko, penu mapadas ko i biyag ha Dios ha magnanayon?” kon na. ");
INSERT INTO duo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ket tinabbeg ni Jesus, “Apay wade a ipeta mo a ‘Mappiya’ i gimetan ko? Ta Dios la i ‘Mappiya’. Awan ha ‘Mappiya’ nu awan i Dios la. Ket anya mina i gimetan mo, penu mapadas mo i biyag ha Dios ha magnanayon? Iday dod i kayat mo a makatandiyan? ");
INSERT INTO duo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Katandi mo dan i bobon na Dios a insurat ni Moyses, a awan ka mangibabbey, awan ka magbuno, awan ka magtakaw, awan ka magsileng. Ket deyawan mo i hama ken hena mo. Idagende i bobon na Dios ha nikaw,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ket tinabbeg na matangkay a Judyo, “Ginimet ko dan i kona hay, idi kaballik ko,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ket idi nateman ni Jesus i tabbeg na, kinagi ni Jesus, “Kulang ka pala ha esa a gimetan mo. Ilako mo dan i ngamin a aruwatan mo. Ket iyatad mo i korinat ha napobre a hidi. Ket nu gimetan mo ide, makabaknang ka nokkan ha langit. Ket ide bila, umunod ka dan ha nikan.” kon ni Jesus ha Judyo aye a matangkay. ");
INSERT INTO duo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngem idi nateman na ito na mabaknang, naladingit hikuna unay. Ta mabaknang hikuna gamen. ");
INSERT INTO duo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","25","Ket idi naenta ni Jesus i pagladingit na, kinagi na, “Tahod a marigat ha mabaknang a hidi, nu kayat di a sumadap ha paghariyan na Dios. Mas malaka a meturok i makadakklan ha abot na dagum, ngem makasaddap i mabaknang ha paghariyan na Dios,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ket kinagi na nakateman a hidi, “Isu, nu kona hito, heya dod i mesalakan nokkan? Pulos a awan a mabalin a makabiyag ha magnanayon!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ket kinagi ni Jesus, “Tamos. Awan a makesalakan i tolay ha baggi na. Ngem maski nu anya a awan a mabalin ha tolay, mabalin man iday ha Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ket kinagi ni Pedro, “Apo, katandi mo a intirak mi i ngamin a kukwa mi, penu umunod kami ha nikaw,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Ket kinagi ni Jesus, “Oni man, ket ipeta ko ha nikam, a maski nu heya a magayat ha Dios ha dakdakkal ngem ha ngamin a kukwa na, makabiyag hikuna ha magnanayon. Kona nu matirak na i bilay na, i kabanga na, i patakka onu hama ken hena na, onu annak na, penu magserbe ha paghariyan na Dios. Agay, hikuna i atdinan na Dios ha mas makpal ha niyaen a tiyempo. Ket nokkan, ha tiyempo a dumemat, makibiyag hikuna ha Dios ha magnanayon.” Ito i inkari ni Jesus ha agagum na. ");
INSERT INTO duo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sa na, inyadiyo ha ballik ni Jesus i esa pulo ket duwa a pinili na. Ket inpeta na ha nidi, “Katandiyan moy mina ide. Umangay kitam ha Jerusalem. Ket nu dumitang kitam nokkan, matongpal i ngamin a nesurat na minahagpugto a hidi megipu ha Annak na Dios a Nagbalin a Tolay. ");
INSERT INTO duo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ket madakapak nokkan, ket meyangayak ha bakkan a hidi a Judyo. Ket makayagan diyak, a pasanikiyan di ak, ken loktaban di ak. ");
INSERT INTO duo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sa di ak, sabdan, ket patayan di ak. Ngem nokkan pala, ha mekatallu a pamalak, magbiyagak manon.” Ito i inpugto ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ngem awan di nakatandiyan, ta kona ha inpalimid na Dios i kayat na kagiyan aye. Isu, awan di nakatandiyan i kinagi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Idi binumikan hidi ha ili a Jeriko, atoy i esa a bulsak a inumetnod ha hikeg na karsada. Nagpalimos hikuna. ");
INSERT INTO duo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ket idi nateman na i kakpalan a tumataleb, nagsalodsod hikuna nu anya i magimet ha hay. ");
INSERT INTO duo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ket nepeta ha nikuna, “Tumataleb di Jesus a taga-Nasaret,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Isu a inayagan na, “Jesus, apo ni Dabid, kagbiyanak mo bi!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ket nagpadas i nagpalungo a hidi a pataranan di hikuna a magayag. Ngem impigsa na pala i pagayag na. “Apo ni Dabid, kagbiyanak mo bi!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Hinumuyot dod ni Jesus, ket inbon na a alapan di hikuna. Ket idi nakabikan dan hikuna ha ni Jesus, sinalodsod ni Jesus, “Anya i kayat mo a gimetan ko ha nikaw?” kon na. Ket tinabbeg na, “Apo, kayat ko a makaenta,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ket kinagi ni Jesus, “Alan, makaenta ka! Makaenta ka dan, ta manahod ka ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ket dagus a nakaenta hikuna. Ket inumunod hikuna ha ni Jesus. Nagdeydeyaw hikuna ha Dios unay. Ket idi naenta na ngamin a tolay, nagdeydeyaw bila hidi ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kobosan na, tinumulos di Jesus a tumaleb ha Jeriko. ");
INSERT INTO duo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ket atoy ha karsada i esa a lakay a taga-Jeriko. I nagen na ni Sakiyo. Hikuna i kapitan na mahagsinger a hidi ha buwis, ket mabaknang hikuna. ");
INSERT INTO duo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Niyaen, kinayat na a maenta ni Jesus, ngem awan nakaenta, ta apapugkal la hikuna. Ket makpal i tolay ha saguppang na. ");
INSERT INTO duo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Isu, binumuyot hikuna ha palungo. Ket inumunek ha kayo a sikamoro, penu maenta na ni Jesus, a tumaleb. ");
INSERT INTO duo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ket idi dinumitang ni Jesus ha iday a kayo, tinumangad ni Jesus. Ket kinagi na ha ni Sakiyo, “Sigida kas, a umugsad ka dan. Ta dumagus kami ha bilay moy,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ket sigida dod a inumugsad ni Sakiyo. Ket neyangay na di Jesus ha bilay na. Dadi pala, a naragsak ni Sakiyo. ");
INSERT INTO duo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ngem nagnabinabi i tolay a hidi, “Hinumuyot di Jesus ha bilay na madukas a tolay,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ket ha bilay di Sakiyo, tinumaknag na, a inpeta na ha ni Jesus, “Apo, entan mo bi. Ta iyatad ko i gudwa na aruwatan ko ha napobre a hidi. Ta kayat ko a magbabawi. Ket nu nakasuwitikak ha maski nu heya, sobra pala isoli ko ha nidi. Isoli ko i mamenuppat ha maski nu heya a sinuwitik ko,” kon ni Sakiyo. ");
INSERT INTO duo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ket inpeta ni Jesus, “Ha yenan a pamalak, inadya na Dios i liwaliwat mo, ket awan kam madusa nokkan. Ta dinumitang dan i pagsalakan moy ha nikaw, ken kabanga mo, ken annak moy, gipu ta ginimet mo dan ha yenan a pamalak a kona ha minappo moy, a ni Abraham. Ha yenan a pamalak, tinahod mo bila i Dios. ");
INSERT INTO duo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Hikan i Annak na Dios a Nagbalin a Tolay. Ket i panggep ko a eriyokan ko i totolay a nasalenan ha Dios gipu ha liwaliwat di, ket isalakan ko hidi,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tinumulos ni Jesus a magitoldu ha nidi, gipu ta binumikan dan hidi ha Jerusalem, ket kagin di a dandani dan i pagdemat na paghariyan na Dios ken magbalin a hari ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Isu, inestoriya ni Jesus i pangpatoldu na, a “Atoy idi i matangkay a lallaki a inumangay ha lugar a madiyo, a mangalap ha pagturay na a maghari. Sa hikuna, magsoli pala nokkan, kon na kan. ");
INSERT INTO duo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Niyaen, idi palungo a paglakad na, inayagan na i esa pulo a tagabu na, ket inyatad na i korinat ha nidi. Inyatad na i mekalan a balle na balitok ha kada tagabu. Ket inpeta na ha nidi, ‘Idagende mina i pangsulet moy hanggan magsoliyak,’ kon na kan na matangkay. ");
INSERT INTO duo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Niyaen, atoy bila i kaili na a hidi. Ket madiyan di kan ide a matangkay a lallaki. Pinaangay di dod i kappal a tolay ha hari a pangipetan di a, ‘Madiyan mi ide a lallaki a magturay ha nikami,’ kon di kan. ");
INSERT INTO duo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Niyaen, idi inalap na i pagturay na a maghari, nagsoli i matangkay. Ket idi kaddemat na ha ili, kayat na a katandi nu hangan i nenayon di ha baknang na. Isu, inbon na a sumaguppang i tagabu a hidi, a mangipeta. ");
INSERT INTO duo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ket idi sinumaggupang i esa, inpeta na, ‘Apo, inyatad mo i esa a balitok ha nikan. Niyaen, mesoli ko ha nikaw i esa pulo a balitok,’ kon na. ");
INSERT INTO duo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ket kinagi ni matangkay, ‘Mappiya ka dan! Gipu ta mapagtalakan ka ha ballik a korinat ko, paggubernadoran taka ha esa pulo a ili,’ kon ni matangkay. ");
INSERT INTO duo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Idi sinumaggupang i mekaduwa, inpeta na ha ni matangkay, ‘Apo, inyatad mo ha nikan i esa a balitok. Niyaen, mesoli ko ha nikaw i lima a balitok,’ kon na tagabu. ");
INSERT INTO duo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ket kinagi ni matangkay, ‘Mappiya ka bila. Paggubernadoran taka ha lima a ili,’ kon ni matangkay. ");
INSERT INTO duo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Niyaen, atoy pala i esa a tagabu a sinumaggupang, ket inpeta na ha ni matangkay, ‘Apo, ide dan i neyatad mo ha nikan. Nedulin ko ide ha hamet, ket intago ko, gipu ta mantengak ha nikaw. Ta katandiyan ko a hikaw i mahagpaalap, a ide i ugali mo, a alapan mo kan i bunga, a maski awan mo nemula. Ket akutan mo i maski awan mo a kukuwa,’ kon na tagabu. ");
INSERT INTO duo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Ay tod,’ kinagi ni mabaknang ha nikuna, ‘Hikaw i madukas a tagabu! Iday a kinagi mo, i mangpaliwat ha nikaw! Katandiyan mo dod a mahagpaalapak, ta alapan ko kan i bunga a maski awan ko nemula? Ket akutan ko i maski awan ko a kukuwa? ");
INSERT INTO duo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Isu, nu kona hito i nakam mo, apay awan mo isadap i balitok ko ha bangko, penu maalap ko mina i tutubu ko?’ kon ni matangkay. ");
INSERT INTO duo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Sa na, kinagi ni matangkay ha sabali a hidi, ‘Alapan moy i balitok ha nikuna, ket iyatad moy ha nekaesa a nagalap ha esa pulo a balitok.’ ");
INSERT INTO duo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ket kinagi di ha ni matangkay, ‘Apo, atoy dan ha nikuna i esa pulo a balitok!’ ");
INSERT INTO duo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ngem tinabbeg ni matangkay, ‘Ipeta ko ha nikam. Ha nikuna a mapagtalakan ko, atdinan ko pala ha mas makpal. Ngem ha nikuna a awan ko mapagtalakan, maski i ballik la a intalak ko ha nikuna, iday i adyan ko ha nikuna. ");
INSERT INTO duo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“‘Ket niyaen, ha kasenti ko a hidi a madiyan di ak a maghari, alapan moy hidi, ket patayan moy hidi ha saguppang ko,’ kon ni matangkay.” Ide i nepangpakatandi ni Jesus megipu ha pagdemat na paghariyan na nokkan. ");
INSERT INTO duo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kinagi ni Jesus ito ha kakpalan a hidi. Sa, nagpalungo di Jesus a umangay ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Idi binumikan hikuna ha il-ili a Betpeg ken Betani, ha amugod na Olibet, inbon na ha duwa a agum na, ");
INSERT INTO duo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Umangay kam ha ili ha kalipat. Atoy ha ho i kabayo a urbon pala. Nu dumitang kam ha ili ayo, lakbisan moy i urbon heya, ket lagedan moy a iyangay ha he. ");
INSERT INTO duo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nu atoy i magsalodsod ha, ‘Apay a lakbisan moy ide a urbon?’, ipeta mos, ‘Kasor ni Apo ide.’” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Isu, inumangay i agagum ni Jesus, ket naenta di i urbon a kona ha nepeta ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ket idi linakbes di i urbon aye, atoy i makingkabayo a nagsalodsod ha, “Apay a lakbisan moy iday a urbon?” ");
INSERT INTO duo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ket tinabbeg di, “Kasor ni Apo ide.” ");
INSERT INTO duo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Isu a linaged di i urbon a kabayo ha ni Jesus. Sa di, pinalayat i tennon ha adag na, a pagetnodan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ket idi nagsakay hikuna ha kabayo, inyabak na kakpalan i tennon di ha dilan. ");
INSERT INTO duo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dadi agay. Nakabikan dan hikuna ha Jerusalem, ha bugsok na amugod na Olibet. Ket maragsak i pinagdeyaw di ha Dios, gipu ha ngamin a milagro a naenta di. Napigsa agay i pinagdeyaw na agagum ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kinagi di, “Deyawan tam i Hari a pinaangay na Dios. Patalnaan na i kasasaad tam ha Apo Dios! Deyawan tam i Dios a kaontokan!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ngem atoy bila i Pariseyo a hidi. Ket kinagi di ha ni Jesus, “Maestro, pagimakan mo i agum mo a hidi.” ");
INSERT INTO duo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ngem tinabbeg ni Jesus, “Ipeta ko ha nikam, maski nu awan magdeyaw idagende a tolay, magdeyaw paman i bitu-bitu,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Niyaen, idi binumikan ni Jesus ha Jerusalem, ket naenta na iday a ili, agay, nagsanget hikuna, gipu ta kinagbiyan na hidi a kaili na. ");
INSERT INTO duo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ket kinagi na, “Hikam a taga Jerusalem, katandiyan moy mina i pangpatalna ha kasasaad moy. Ngem awan moy pala makatandiyan. ");
INSERT INTO duo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dumitang nokkan i madukas a tiyempo, nu maglebut ha nikam i kakasenti moy. Ket awan kam makalapos. ");
INSERT INTO duo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dadailan di kam nokkan, ken ngamin a tolay ha disalad na Jerusalem aye. Ket rakrakan di i ngamin a bilay moy. Maski i bitu-bitu ha padding na bilay moy, awan metupo nokkan. Pasig la a marakrak. Ta awan moy makatandiyan i tiyempo nu dinumitang i Apo Dios a magsalakan mina ha nikam,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sa, sinumadap ni Jesus ha Templo. Ket binugew na i mahaglako a hidi. ");
INSERT INTO duo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kinagi na, “Nesurat ide ha libro na Dios, ‘I bilay ko i bilay mina a pagkararagan,’ kon na Dios. Ngem insulet moy dan ito ha paghenan na mahagtakaw,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ket nagitoldu ni Jesus ha kada pamalak ha Templo. Ket kinayat a bunowan na matangkay a papadi ken mamaestro na linteg ken panglakayan a hidi na Judyo. ");
INSERT INTO duo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ngem awan di nakatandiyan nu panyan di a mabuno, ta kanayon a nagteman i kakpalan ha pagitoldu ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Idi esa a pamalak, hen ni Jesus ha Templo a magitoldu ken magibaheta ha mappiya a gimigimet na Dios. Ket atoy bila i dinumemat i kakasenti ni Jesus, hidi a matangkay a papadi, ken mamaestro na linteg, ken panglakayan a hidi na Judyo. ");
INSERT INTO duo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ket sinalodsod di ha nikuna, “Ipakatandi mo bi i kalintegan mo a manggimet ha dagende a bagay. Heya i nangiyatad ha nikaw ha turay a kona he?” kon di. ");
INSERT INTO duo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ket tinabbeg ni Jesus, “Ha palungo, palobusanak mo bi a magsalodsod ha nikam. ");
INSERT INTO duo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ipeta moy bi nu hadya i nagipuwan na turay ni Juan a magbinyag? Nagipu ha Dios, onu nagipu la ha sabali a tolay?” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sa hidi, naginuhon nu anya mina i tabbeg di. “Nu ipeta tam a nagipu ha Dios i turay ni Juan, metabbeg ni Jesus, a ‘Apay dod, awan kam nanahod ha ni Juan?’ ");
INSERT INTO duo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ngem nu ipeta tam a nagipu la ha sabali a tolay, ket bisagan na kitam na kakpalan aye. Ta tahodan di a tahod a mahagpugto ni Juan.” ");
INSERT INTO duo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Isu, tinabbeg di, “Awan mi makatandiyan nu hadya i nagipuwan na turay ni Juan a magbinyag.” ");
INSERT INTO duo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ket tinabbeg ni Jesus, “Isu, ta awanak moy tinabbegan, awan ta kam bila tabbegan nu anya i turay ko a manggimet ha dagende a bagay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ket inestoriya ni Jesus ide a pangpakatandi na ha kakpalan a hidi. “Atoy idi i esa a lakay, ket minulaan na i lutak na ha ubas. Ket inpaabang na ha makitalon a hidi. Sa hikuna, linumakad ha maalay. ");
INSERT INTO duo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Idi dinumemat i tiyempo na pagbunga na ubas, pinaangay na i esa a tagabu a mangalap mina ha bunong na. Ngem ha makitalon a hidi, nagdanog hidi ha tagabu aye. Ket pinalakad di hikuna, a awan nakaalap. ");
INSERT INTO duo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Isu, pinaangay na lakay i sabali a tagabu na. Ngem dinanog di bila hikuna. Ket pinasanikiyan di. Ket pinalakad di bila. Ket awan manon nakaalap. ");
INSERT INTO duo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Sa na, pinaangay na lakay i mekatallu a tagabu na. Ngem pinasaketan di bila hikuna, ket binugew di. ");
INSERT INTO duo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Sa na, kinagi na lakay a makinlutak, ‘Anya mina i gimetan ko? Ay, ide dan. Paangayan ko i annak ko a esesa a ayatan ko. Ta siguradowak a deyawan di hikuna!’ kon ni Lakay. ");
INSERT INTO duo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ngem idi naenta na makitalon a hidi, naginuhon hidi, ‘Ide i magtawid ha lutak ni Lakay! Patayan tam mina hikuna, penu hikitam mina i magtawid ha lutak na aye,’ kon di. ");
INSERT INTO duo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ket dinakap di dod, ket inyangay di ha lapos na lutak, ket binuno di hikuna. “Niyaen,” tinulos ni Jesus, “anya i nakam moy? Anya wade i gimetan na lakay a makinlutak? ");
INSERT INTO duo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Siyempre, ah? Dumemat hikuna ken patayan na hidi a makitalon. Sa na, iyatad iday a lutak ha sabali a totolay,” kon ni Jesus. Ket idi nakatandiyan na kakpalan a hidi a magistoriya ni Jesus megipu ha Israel, kinagi di, “Adanay, awan mina a kona hito!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ngem inaamatan na hidi ni Jesus, a kinagi na, “Anya dod i nakatandiyan moy megipu ha Cristu, ken hidi a magmadi ha Cristu. Ta pinapugto na Dios ket Inpesurat na, a ‘Ginayak ko dan i esa a inaamakan a pogedu, para ha bilay ko. Ngem madiyan na a usaran na tarabahador a hidi. Ngem maski nu kona hito, idatton ko ide a pogedu ha suli na bilay a pangadigi ha ngamin a bilay ko,’ kon na Dios. Ket ipeta ko pala ha nikam,” kinagi ni Jesus, ");
INSERT INTO duo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Maski nu heya a mangsenti ha ide a pogedu, matangpod hikuna nokkan. Ket ha nikuna a magkabeng ha ide a pogedu, hikuna i hamsitan na pogedu aye, ket meyappah hikuna nokkan ha pahas.” Ide i pangikalan ni Jesus ha totolay a awan a manahod. ");
INSERT INTO duo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ket ha mamaestro na linteg ken matangkay a papadi, kinayat di a dakapan ni Jesus a dagus, ta nakatandi hidi a neestoriya ni Jesus ito a pangsenti na ha nidi. Ngem kinumanteng hidi ha kakpalan a tolay. ");
INSERT INTO duo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Isu, naguray hidi ha gundaway di. Ket nagpagga hidi ha kappal a lallaki a aginpappiya, penu masiluwan di mina ni Jesus ha salodsod di. Bareng kan, nu atoy i kagi ni Jesus a mesenti ha Linteg na Roma, ket dakapan di, ket meyangay di hikuna ha gobernador. ");
INSERT INTO duo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Isu, inumangay hidi a aginpappiya, ket sinalodsod di, “Maestro, katandi mi a tahod i pagitoldu mo. Ket katandi mi a magitoldu ka ha tahod megipu ha kagbi na Dios ha totolay. Ket katandi mi bila a awan ha idumduma mo, maski matangkay onu madibbi. ");
INSERT INTO duo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Isu a salodsod mi ha nikaw. Makaliwat kitam ha Linteg tam a Judyo, onu awan, nu magpaga kitam ha buwis ha Hari na Roma?” kon na aginpappiya a hidi. ");
INSERT INTO duo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngem nakatandiyan ni Jesus a surbaran di hikuna. Isu, kinagi na, ");
INSERT INTO duo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ipaenta moy ha nikan i korinat. Ket ipeta moy bi, nu heya i retrato aye, ken heya i nagen a nepasurat ha he?” kon ni Jesus. “Iday i Hari na Roma,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ket kinagi ni Jesus, “Isu, iyatad tam mina ha Hari na Roma i kukuwa na a hidi, idagende a bagbagay a atoy ha rupa na ken nagen na. Ket iyatad tam mina ha Dios i kukuwa na Dios, idagenday a bagbagay a atoy i karuprupa na Dios, a kona ha ayat tam, ken nakam tam, ken pigsa tam,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Agay, naskal la hidi ha tabbeg na. Ket awan hidi nakakagi. Ket awan di hikuna nasiluwan ha saguppang na kakpalan. ");
INSERT INTO duo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Niyaen, inumangay ha ni Jesus i kappal a Saduseyo. (Hidi i Judyo a awan a manahod a magbiyag manon i totolay a minatay dan.) ");
INSERT INTO duo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ket sinalodsod di, “Maestro, insurat ni Moyses ide a linteg, a ‘Nu matay i lallaki a atoy kabanga na, ket awan pala ha annak, masapul na wadi na a magkabanga ha ipag na a nabilu, penu magenak hikuna. Ket ibilang di mina i annak na a annak na hekka na a minatay,’ kon ni Moyses. ");
INSERT INTO duo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Niyaen, Maestro, atoy idi i pitu a kabsat a lallallaki. Ket nangabanga i hekka, ngem minatay hikuna a awan ha annak na. ");
INSERT INTO duo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ket kinabanga na wadi na i ipag na heya a nabilu. Ket minatay bila hikuna a awan ha annak na. ");
INSERT INTO duo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ket kona bila hito ha nekatallu. Ket kona bila hito hanggan ha nekapitu. Minatay hidi ngamin a awan ha annak di. ");
INSERT INTO duo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","“Sa, minatay i babbey ha dilokod. ");
INSERT INTO duo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Isu, Maestro,” kinagi na Saduseyo a hidi, “ide i kayat mi a makatandiyan. Ta netoldu mo a makabiyag huhuway i tolay a natay dan. Niyaen, heya wade i kabanga na babbey nokkan, nu magbiyag manon hidi, gipu ta nagkabanga hidi ngamin ha nikuna?” kon na Saduseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ket tinabbeg ni Jesus, “Awan agay, ta ide i ugali na lugar tam aye, ha tiyempo niyaen. I ugali na totolay ha he i pagkabanga. ");
INSERT INTO duo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ngem nokkan ha totolay a ibilang na Dios a mappiya, husto hidi a magbiyag ha huway ha magnanayon, ket awan hidi mangabanga. ");
INSERT INTO duo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Maghen hidi ha langit a kona ha anghel a hidi, ket awan hidi matay manon. Annak hidi na Dios, ta magbiyag manon hidi a naggipu ha natay. ");
INSERT INTO duo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Hikam a Saduseyo,” kinagi ni Jesus, “apay a kagin moy a awan magbiyag manon i totolay? Nagpatahod ni Moyses a magbiyag manon i totolay. Nakaman moy mina i pinagsurat na a megipu ha ni Abraham, ken ni Isak, ken ni Hakob. Ta idi nagpaenta i Dios ha kayo a maggangat, kinagi na ha ni Moyses, ‘Hikan i deyawan ni Abraham, ni Isak, ken ni Hakob,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ket nu kona hito, makatandiyan tam a minagbiyag manon hidi. Ta awan ha magdeyaw ha Dios nu awan a magbiyag. Ket minagbiyag ha Dios i ngamin a minatay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Niyaen, idi kinagi na ito ha Saduseyo a hidi, atoy bila i maestro a hidi na linteg. Ket kinagi di, “Mappiya i tabbeg mo, Maestro!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ket i Saduseyo a hidi, nasaniki hidi a magsalodsod ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ket kinagi ni Jesus ha nidi, “Apay a metoldu na kappal a tolay a ni Hari Dabid i minappo na Cristu? ");
INSERT INTO duo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ta nesurat ni Dabid ha libro na kansiyon, ‘Kinagi na Apo Dios ha Happo ko, “Magetnod ka ha henan ko a maghari kita hanggan pagparentumengan ko i kasenti mo a hidi ha saguppang mo,” kon na Dios. ");
INSERT INTO duo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Isu, insurat ni Dabid i Happo na i Hari a urayan na totolay. Ket pinanagenan ni Dabid ha Cristu i “Happo” na. Isu, mabalin dod nu minappo dan ni Dabid na Cristu?’” Ito i insalodsod ni Jesus ha maestro a hidi. ");
INSERT INTO duo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Niyaen, idi nagteman pala i kakpalan, iniwadan ni Jesus i agagum na a toltolduwan na, ");
INSERT INTO duo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Magingat kam ha nidi a maestro na Linteg. Ta kayat di a magtennon ha mangina a badu, penu maenta na tolay a matangkay hidi. Ket kayat di i inaamakan a salpak ha sentro. Ket kayat di bila a umetnod ha pagetnodan na matangkay ha piyesta ken ha kapilya. ");
INSERT INTO duo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ngem agewan di i kukuwa na nabilu a hidi, sa hidi, magkararag ha maalay, penu kagin na totolay a mappiya hidi. Isu, hidi i parusaan na Dios ha mas marigat nokkan,” kon ni Jesus. Ito i iniwadan ni Jesus ha agagum na megipu ha maestro a hidi. ");
INSERT INTO duo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Idi atoy pala ni Jesus ha Templo, sinasiiman na i mabaknang a hidi a nagitaknag ha korinat di ha kahon a pagatdinan ha Templo. ");
INSERT INTO duo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ket naenta na bila i esa a bilu a napobre a nangitakneg ha duwa la a sentimos. ");
INSERT INTO duo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ket kinagi ni Jesus, “Ipeta ko ha nikam, ha nakam na Dios, nangiyatad iday a bilu ha mas makpal ngem ha ngamin a mabaknang a hidi. ");
INSERT INTO duo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ta neyatad na mabaknang a hidi i sobra na baknang di. Ngem maski nu napobre ide a bilu, neyatad na i ngamin a korinat na, a ngamin a pagbiyag na,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Niyaen, atoy i kappal a agum ni Jesus a nakipaguhon megipu ha Templo, ken dadakkal a pogedu ha padding na, ken inaamakan a pangdekorasiyon a hidi a neyatad na totolay. ");
INSERT INTO duo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ket kinagi ni Jesus ha nidi, “Entan moy i ngamin a dagende. Ta dumemat nokkan i tiyempo a marakrak hidi ngamin. Marakrak nokkan i kada esa a bitu-bitu ha padding aye. Ket matakneg hidi ngamin,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Maestro,” sinalodsod di, “hangan dumemat i kinagi mo? Anya wade i tiplad, penu makatandiyan mi a dumemat iday a tiyempo a madukas?” kon di. ");
INSERT INTO duo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ket kinagi ni Jesus, “Magingat kam, penu awan na kam paliwatan na tolay. Ta atoy nokkan i makpal a umangay ha he, ket magkagi hidi a hidi i Cristu a pinaangay na Dios a maghari. Ket ibaheta di bila a dumemat dan i tiyempo a pagparusa na Dios ha tolay. Ngem awan kam mina manahod ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ket maski nu mabaheta moy megipu ha gubat ken riribuk, awan kam mina manteng. Ta masapul a magimet idagento ha palungo. Ngem maski nu kona hito, awan pala i tiplad na tiyempo a pakobos na totolay ha lutak,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ket tinumulos ni Jesus, “Makipaglaban pala hidi ha makpal a bayan. ");
INSERT INTO duo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ket atoy nokkan i makpal a ginggined a dakkal, ken makpal a alap, ken saket ha maski nu hadya a lugar. Atoy pala nokkan i makpal a balsit a magpaenta ha langit, ket pakantengan di. ");
INSERT INTO duo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ngem ha palungo a dumemat idagende a rigrigat, ipadakap na kam na tolay. Ket lokowan di kam. Ket isaguppang di kam ha kapikapilya na Judyo a hidi. Ket ipabalud di kam. Ket isaguppang di kam ha gobernador a hidi, ken ha hari a hidi, gipu ha panahod moy ha nikan. ");
INSERT INTO duo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ket iday i tiyempo a pangibaheta moy ha mappiya a baheta megipu ha ginimet na Dios. ");
INSERT INTO duo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ket imula moy dan ha nakam moy, a awan kam magburibur nu anya i tabbeg moy ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ta giwatan ta kam nokkan ha mappiya a kakkagi, ket palaingan ko i nakam moy, penu awan makatabbeg i kasenti moy a hidi. Ket awan hidi makepeta a magsileng kam. ");
INSERT INTO duo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ngem katandiyan moy mina a maski i daddakkal moy, ken hekka onu wadi moy, onu kasingsing ken ilailay moy a hidi, ay, maski hidi i mangipadakap ha nikam. Ket atadan di kam ha kasenti moy. Ket atoy i kappal ha nikam a patayan di. ");
INSERT INTO duo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ket maski nu hadya a lugar a angayan moy, maingalan di kam. Ta manahod kam ha nikan. ");
INSERT INTO duo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ngem maski nu mabuno di i baggi moy, awan di mapasaketan i kaliduwa moy, ta daponan na Dios. Ket daponan na Dios i ngamin a biyag moy, maski esa a buk ha buntok moy. ");
INSERT INTO duo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Isu, nu pasibatan moy i baggi moy a magattam, mesalakan kam nokkan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ket tinumulos ni Jesus, “Nu maenta moy nokkan i sundalu a hidi a maglebut ha Jerusalem, makatandiyan moy a dandani dan a marakrak i Jerusalem. ");
INSERT INTO duo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ket nu dumemat iday a tiyempo, bumuyot mina i tolay a hidi a magipu ha Judeya hanggan ha amugod. Ket lumapos mina i maghen ha Jerusalem. Ket awan mina a sumadap ha ili, nu hen hidi ha talon. ");
INSERT INTO duo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gipu ta ide a tiyempo i pagparusa na Dios ha totolay a nagmadi ha paghariyan na. Ket magimet ito penu matongpal i ngamin a nepugto na minahagpugto a hidi ha Libro na Dios. ");
INSERT INTO duo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Kagbi hidi a mabuktet ken hidi a magpasuso ha iday a tiyempo! Ta makpal i rigat nokkan ha lutak aye. Ta parusaan na Dios idagende a tolay. ");
INSERT INTO duo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ha kappal, matay hidi ha laban. Ha kappal, madakap hidi, ket mepaangay hidi ha pagbaludan ha sabasabali a lugar ha madiyo. Ket magrakrak pala ha Jerusalem i totolay a bakkan a Judyo, hanggan nobos dan i tiyempo di. ");
INSERT INTO duo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ket nokkan, atoy i magimet ha senggit, ken bulan, ken pusiyan a pangibalsit ha ngamin a tolay. Ket mamasbew nokkan i ngamin a tolay ha ngamin a bayan. Ket manteng hidi ha tanog na diget, ken ha dakkal a talogut a hidi. ");
INSERT INTO duo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ket nokkan, atoy i makpal a lallaki a maulaw, gipu ha kanteng di. Ket magsapduh hidi ha dandani dan a magimet. Ta mapasina nokkan i senggit ha paglakadan na. Ket kona bila hito i bulan ken pusiyan. ");
INSERT INTO duo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sa, magpaenta i Annak na Dios a Nagbalin a Tolay ha ulap a bumubugsok ha lutak. Ket maenta na ngamin a tolay i kaamakan ko, ken mapigsa a kaddat ko. ");
INSERT INTO duo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Isu, nu maenta moy nokkan a mangrugi idagende a bagay, magragsak kam. Tumaknag kam, ket tumangad a magtahok ha pakesalakan moy,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sa na, kinagi ni Jesus ide a pangipakatandi na. “Nakaman moy i kayo a igos, pati ngamin a kayo a agum na. ");
INSERT INTO duo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nu magbudak hidi, katandi moy a dandani dan a kasinag. ");
INSERT INTO duo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ket kona bila hito ha dagende a magimet nokkan. Nu maenta moy idagende a nepugto ko, makatandiyan moy a dandani dan i tiyempo na Dios a maghari ha lutak. ");
INSERT INTO duo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Magsiguradowak ha nikam a makatulos pala ide a kalase na tolay hanggan magimet idagento. Sa, awan dan. ");
INSERT INTO duo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ket maski nu maawan bila i ngamin a langit ken ngamin a lutak nokkan, ipeta ko ha nikam a makatulos pala i kakkagi ko. Ta awan a mabalin a maawan i kakkagi ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ket tinulos na, “Magingat kam ha baggi moy, a awan kam mabuhong a maginum ha arak ken magpiyesta. Ket awan kam mina mabuhong a magburibur ha pagbiyag moy. Baka bigu a dumemat i pamalak a pagparusa na Dios, ket awan kam makagayak. Ket madakap na kam, a kona ha tungkeris a bigu la a masiluwan dan. ");
INSERT INTO duo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ket kona hito i pagdemat na pamalak heya. Ta sigida la i pagabot na ha ngamin a tolay ha lutak, ha maski nu hadya i henan di. ");
INSERT INTO duo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Daponan moy dod i baggi moy. Ket magkararag kam a kanayon ha Dios, a palagdaen na i nakam moy, penu malagda kam ha dagenday a rigrigat. Ket nu mapalagda kam, makabikan kam nokkan ha saguppang na Annak na Dios a Nagbalin a Tolay, ket awan kam masaniki,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ket tinumulos ni Jesus a nagitoldu ha kada pamalak ha Templo. Ket kinumillap hikuna ha Amugod na Olibo ha kada kallap. ");
INSERT INTO duo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ket kada maledum, inumangay i kakpalan a hidi ha Templo, penu temanan di ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Idi tiyempo hito, binumikan dan i tiyempo na piyesta, nu magkan hidi ha tinapay a awan ha lebadura na. Ket nanagenan ito ha Piyesta na Pinagtaleban na Anghel a Magpatay. ");
INSERT INTO duo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ket nakipaggammong i matangkay a papadi ken maestro a hidi na Linteg nu panyan di a bunowan ni Jesus. Ngem manteng hidi ha totolay, ta kinasoran na kakpalan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Niyaen, sinumadap ni Satanas ha ni Judas Iskaryote, a esa a lallaki ha esa pulo ket duwa a tolduwan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ket inumangay dod ni Judas a makipaggammong ha matangkay a papadi ken sunsundalu na Templo. Ket inpeta na a daggapan na hidi a mangdakap ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ket maragsak hidi, a inyatad di i korinat ha ni Judas. ");
INSERT INTO duo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nagoni ni Judas, ket nangrugi hikuna a magnakam nu panyan na a megiwat ni Jesus a awan maenta na sabali a tolay. ");
INSERT INTO duo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Niyaen, dinumemat i pamalak na Piyesta nu partiyan di, ket idatton di ha Dios i malogyaw a karnero. Iday i pamalak nu magkan hidi ha manipis a tinapay, a awan ha lebadura na. Ket nagenan di ito ha “Pangapon na Pinagtaleban.” ");
INSERT INTO duo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pinaangay ni Jesus di Pedro ken Juan ha palungo. Ket inpeta na, “Umangay kam a magisagana ha pangapon tam.” ");
INSERT INTO duo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ket sinalodsod di, “Hadya i kayat mo a pangisaganaan mi?” ");
INSERT INTO duo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ket tinabbeg ni Jesus, “Nu sumadap kam nokkan ha Jerusalem, tagabuwan na kam na esa a lakay a sumagab. Umunod kam ha nikuna ha bilay a saddapan na. ");
INSERT INTO duo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ket nu sumadap kam ha bilay aye, ipeta moy ha makinbilay a, ‘Pasalodsod ni Maestro nu hadya i paghenan mi a magkan ha Pangapon na Pinagtaleban?’ kon moy. ");
INSERT INTO duo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ket nu ipeta moy ito ha nikuna, ipaenta na ha nikam i dakkal a kuwarto a atoy bila i ngamin a aruwatan para ha Pangapon tam. Ket hito i pangisaganaan moy ha Pangapon tam na Pinagtaleban,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Isu a inumangay hidi, ket naeriyokan di i ngamin a inpeta ni Jesus, a kona ha nepeta na. Ket nagsagana hidi ha Pangapon na Pinagtaleban. ");
INSERT INTO duo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Idi nesagana i Pangapon na Pinagtaleban, ket nakipagkan di Jesus ken apostol na a hidi, ");
INSERT INTO duo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","kinagi ni Jesus ha nidi, “Tahod a kayat ko unay a makipagkan ha nikam ha Pangapon aye, ha palungo na katay ko! ");
INSERT INTO duo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta ipeta ko ha nikam, a awanak manon magkan ha dende hanggan matongpal ito ha paghariyan na Dios ken magsilebra kitam manon ha pakesalakan na totolay a manahod,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sa na, inalap ni Jesus i baso na basi. Ket nagyaman hikuna ha Dios. Ket inpeta na ha nidi, “Bunongan moy ide a basi. ");
INSERT INTO duo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ipeta ko ha nikam a awanak maginum manon ha basi na ubas hanggan dumemat i paghariyan na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sa na, inalap ni Jesus i tinapay. Ket nagyaman hikuna ha Dios. Ket pinilakpilak na i tinapay, a inyatad na ha nidi. Ket inpeta na, “Ide i baggi ko a meyataatad ha Dios para ha nikam. Nokkan, itulos moy mina a maggimet ha kona he a pangnakam moy ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ket kona bila hito i ginimet ni Jesus ha baso na basi, idi nobos di a nagkan. Kinagi na, “I basi aye i digi ko a pangtongpal ha bigu a kari na Dios. Ket ibulbulak ko i digi ko para ha nikam. ");
INSERT INTO duo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ngem, makatandiyan moy mina a atoy ha agagum tam he i mangpadakap ha nikan ha kasenti ko a hidi. ");
INSERT INTO duo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hikan i Annak na Dios a Nagbalin a Annak na Tolay, ket matayak nokkan gipu ha panggep na Dios. Ngem marigat i parusa na lallaki a mangpadakap ha nikan. Sayang agay ha nikuna,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ket idi nateman di i kakkagi na, nangrugi hidi a magsinolodsod nu heya i manggimet ha ide, nu heya i mangpadakap ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ket nangrugi bila hidi a makitabbegan nu heya i mas matangkay nokkan ha paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Isu a kinagi ni Jesus ha nidi, “Kona ha ide i ugali na ngamin a hari ha lutak, a kanayon la hidi mangibon ha totolay ha bayan di. Ngem kayat di bila a panagenan i baggi di ha, ‘Mahagkagbi ha Totolay’. ");
INSERT INTO duo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ngem ha nikam, bakkan mina a kona hito. Imbes na, makipagagum ken makipagdaggap kam mina. Nu matangkay ka dan, masapul a padibbiyan mo i baggi mo a magserbe a kona ha kadibbi na olitaw. Ket nu hikaw i katangkayan, hikaw i magserbe mina ha agagum mo. ");
INSERT INTO duo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ta kona hito i ginimet ko ha nikam,” kon ni Jesus. “Ket heya mina i mas matangkay, i tolay a umetnod ken magkan, onu tolay a magserbe ha nikuna? Siyempre! Mas matangkay i tolay a umetnod la ken magkan, kon na kan. Ngem ha nikan, bakkan i ugali ko. Ta inumangayak ha nikam penu magserbe. ");
INSERT INTO duo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Niyaen, hikam i nagagum ha nikan a magattam ha rigrigat ko. ");
INSERT INTO duo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ket inpeta ko a pinaangay na ak na hama ko a maghari. Isu a atdinan takam bila ha turay ko. ");
INSERT INTO duo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ket nokkan, nu maghariyak, makipagkan kitam, ket makipaginom kitam ha paghariyan ko. Ket hikitam man i maghari ha kaputotan na esa pulo ket duwa a tribu na Israel,” kon ni Jesus ha apostol na a hidi. ");
INSERT INTO duo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sa na, kinagi ni Jesus ha ni Simon Pedro, “Simon! Temanan mo. Ta napalobusan ni Satanas a mangsurubar ha nikam. Ket i pagsurubar na i kona ha tolay a mangtar-ap ha baggat na. Ket mepaenta na nu pasig la mappiya i panahod moy, a kona ha baggat a pasig la maponset, onu tahod a awan ha panahod moy, a kona ha lupas la a awan pagserbe na. ");
INSERT INTO duo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ngem inkararagan taka, Simon, penu awan gumimak i panahod mo ha nikan. Ket nokkan nu magbabawi ka, ket sumoli ka manon ha nikan, ipasibat mo i panahod na agagum mo, penu awan mapagimak ni Satanas i panahod di,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngem kinagi ni Simon Pedro ha ni Jesus, “Maski nu ipabalud di ka, awanak sumina ha nikaw. Maski nu patayan di ka, patayan di ak bila,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Pedro,” kinagi ni Jesus, “ipeta ko ha nikaw a ha yenan a kallap, ha palungo a magtaraok i kawitan, ket magkagi ka ha mamintallu a awanak mo katandi,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ket nagsalodsod ni Jesus ha apostol na a hidi, “Nikuna, idi pinaangay takam a mangitoldu, ket nepeta ko ha nikam, ‘Awan moy bilonan i korinat moy, onu supot moy, onu sapatos moy,’ kon ko, anya wade, nagkulang kam ha maski nu anya, onu awan?” Ket tinabbeg di, “Awan kami nagkulang ha maski nu anya.” ");
INSERT INTO duo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Oni,” kinagi ni Jesus, “ta idi, naanus pala i nakam na totolay ha nikan. Ngem niyaen, bakkan i pinagnakam di. Isu, ipeta ko ha nikam a nu atoy i korinat moy ken supot moy, bilonan moy mina. Ket nu awan ha sundang moy, ilako moy i tennon moy a paggatang moy ha sundang. ");
INSERT INTO duo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta kona ha ide i kasasaad tam, a masapul a matongpal i ngamin a nesurat megipu ha nikan ha Libro na Dios. Maski ide a nesurat ni Isayas, a ‘Mebilang nokkan i Cristu ha mahagliwat a hidi,’ kon na. Ta masapul a matongpal i ngamin a nesurat megipu ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ket kinagi di, “Entan mo, Apo! Atoy he i duwa a sundang!” Ket kinagi ni Jesus, “Kuston.” ");
INSERT INTO duo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sa hidi, linumapos di Jesus ha Jerusalem. Ket inumangay hidi ha Amugod na Olibo. Ta hito i katidugan di. ");
INSERT INTO duo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Idi dinumemat hidi ha Olibo, kinagi ni Jesus, “Magkararag kam, penu awan na kam maabak na solisog ni Satanas,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sa na, intirak hidi, ket tinumagdak hikuna ha madiyo ballik, ha disat. Ket nagparentumeng, a nagkararag ha Dios. ");
INSERT INTO duo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Hama ko,” kinagi na, “nu kayat mo, awanak mo bi adiyowan ha magnanayon ha katay ko. Ngem maski nu kona hito a mahukomanak, bakkan mina a pagayatan ko i gimetan mo nu awan i pagayatan mo. Ket usegan ko i kayat mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Idi nagkararag hikuna, nagpaenta i anghel a nagipu ha langit. Ket nagpabinyag ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sa, narigatan unay i baggi na. Ket mas mapigsa i kararag na. Ket naglengit hikuna ha dakkal a tagdu na digi, gipu ta narigatan i baggi na. ");
INSERT INTO duo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Idi nobos i kararag na, sinumoli hikuna ha agagum na. Ngem kinumillap hidi, ta nagkakapoy hidi ha pagladingit di. ");
INSERT INTO duo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ket kinagi ni Jesus, “Apay a kinumillap kam? Umikat kam, ket magkararag, penu awan kam magliwat nu masolisog na kam ni Satanas,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Idi nagkagi pala ni Jesus, dinumemat i kakpalan a hidi. Ket nagpalungo ni Judas. Hikuna i esa ha dagenday esa pulo ket duwa a nagkeagum ha ni Jesus. Ket binumikan ni Judas ha ni Jesus a ammosan na. ");
INSERT INTO duo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ngem kinagi ni Jesus, “Judas, ide a ammos mo, ide i panggimet mo penu maglipot ka ha Annak na Dios a Nagbalin a Tolay?” kon na. ");
INSERT INTO duo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Idi naenta na agagum ni Jesus i magimet aye, kinagi di, “Apo, usaran tam mina i sundang tam aye?” kon di. ");
INSERT INTO duo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ket kinatol na esa i tagabu na matangkay a padi, ket nesina na i kanawan a talinga na. ");
INSERT INTO duo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngem kinagi ni Jesus, “Awan kas!” Sa na, inegkaman ni Jesus i talinga na tagabu heya, ket pinahusay na. ");
INSERT INTO duo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ket ha nidi a dinumemat a magdakap ha ni Jesus, hidi a matangkay a papadi, ken kapitan na sundalu a hidi a nagipu ha Templo, ken panglakayan a hidi na Judyo, sinalodsod ni Jesus ha nidi, “Mahagtakawak dod? Apay a usaran moy i sundang ken gahote a pangdakap moy ha nikan? ");
INSERT INTO duo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ta nikuna kadapamalak, nangitolduwak ha saguppang moy ha Templo. Ket awanak moy dinakap. Ngem niyaen a kallap, ket ide i tiyempo a pagturay moy, ken pagturay na Satanas,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sa di, dinakap ni Jesus ket inyangay di ha bilay na matangkay a padi. Ket tinagubet na hidi ni Pedro. ");
INSERT INTO duo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Idi dinumemat hidi ha bilay na padi, atoy i gangatan ha saguppang na bilay. Ket atoy i kappal a nagendu. Ket binumikan ni Pedro a magendu bila. ");
INSERT INTO duo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ket naenta na hikuna na esa a babbey a tagabu. Ket inaamatan na hikuna, a kinagi na, “Agum na ide ni Jesus!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ngem kinagi ni Pedro, “Adding, awan ko hikuna katandi!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Idi awan maalay, ket naenta na esa a lallaki ni Pedro. Ket kinagi na, “Hikaw bila i esa a agum ni Jesus!” Ngem tinabbeg ni Pedro, “Manong, tahod, awan na ak agum ni Jesus!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Idi manga esa a oras, ket kinagi na esa a lallaki, “Siguradowak a nakiagum ide a lallaki ha ni Jesus, ta taga-Galileya i kagi na,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngem kinagi ni Pedro, “Awan dalla agay! Awan man! Awan ko makatandiyan i kinagi mo!” Ket bigu la, idi nagkagi pala ni Pedro, nagtaraok i esa a kawitan. ");
INSERT INTO duo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ket sinumoleg ni Apo Jesus, a inaamatan na ni Pedro. Ket nanakam ni Pedro i nepeta ni Jesus a, “Nokkan, ha yenan a kallap, nu palungo a magtaraok i kawitan, ipeta mo a awanak mo katandi ha mamintallu.” ");
INSERT INTO duo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Isu, linumapos ni Pedro, ket nakasanget unay hikuna. ");
INSERT INTO duo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ket ha nidi a nagdakap ha ni Jesus, nagulew ken nagdanog hidi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Binadbadan di i mata na, sa di, kinayag, “Pugtowan mo nu heya i nangdanog ha nikaw,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ket makpal pala i kinagi di a pangpasaniki ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Idi masapa a maledum, nagpisan i lakay a hidi, ken matangkay a papadi, ken maestro a hidi na linteg. Napanagenan ha “Sanhedrin” i pagpisan na ngamin a dagende a lakay. Ket pinasaguppang di ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ipeta mo dan,” kinagi di, “hikaw dod i Cristu, i tolay a paangayan na Dios a maghari?” Ket tinabbeg ni Jesus, “Nu ipeta ko ha nikam, awanak moy tahodan. ");
INSERT INTO duo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ket nu padasan ko a ipakatandi ha nikam, awan moy temanan. Ket nu magsalodsodak ha nikam, awan kam tumabbeg. ");
INSERT INTO duo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ngem maski nu kona hito, ipeta ko ha nikam a mangrugi ha niyaen, magetnod ha henan na Dios ken maghari i Annak na Dios a Nagbalin a Tolay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ket kinagi di ngamin, “Isu, hikaw dod i Annak na Dios?” Ket tinabbeg ni Jesus, “Tahod i kinagi moy.” ");
INSERT INTO duo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ket kinagi di, “Kuston! Awan tam masapul a magteman ha mangipaliwat a hidi. Ta nateman tam i madukas a kagi na!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sa di, inyangay na Sanhedrin a hidi ni Jesus ha ni Gobernador Pilato. ");
INSERT INTO duo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ket pinaliwat di ha saguppang. Kinagi di, “Gobernador, naeriyokan mi ide a lallaki a nagitoldu ha silisileng na ha kababayan mi a Judyo. Intoldu na a awan kami mina magpaga ha buwis ha hari mo ha Roma. Ket intoldu na a hikuna i Cristu, i tolay a paangayan na Dios a maghari ha ngamin a tolay!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ket sinalodsod ni Pilato ni Jesus, “Anya, hikaw i Cristu a maghari mina ha Judyo a hidi?” Ket tinabbeg ni Jesus, “Oni, kona ha kinagi mo.” ");
INSERT INTO duo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ket kinagi ni Pilato ha matangkay a papadi ken kakpalan a hidi, “Awan ko makatandiyan i liwat na lallaki aye. Isu, awan ko hikuna maparusaan,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ngem dinagdag di ha mas mapigsa, “Ipasenti na kami ha Hari mo ha Roma gipu ha pagitoldu na. Ket nagitoldu hikuna ha ngamin a lugar na Judyo, a naggipu ha Galileya hanggan ha Judeya, hanggan Jerusalem aye, a magsenti mina kami ha Hari mo ha Roma,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Idi nateman ito ni Pilato, sinalodsod na, “Taga-Galileya ide a lallaki?” kon na. “Oni,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ket idi nakatandiyan ni Pilato a taga-Galileya ni Jesus, pinaangay na hikuna ha ni Herod. Ta ni Herod i esa a Judyo a gobernador ha Galileya. Ket kaddemat la hikuna ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Niyaen, naragsak ni Herod idi naenta na ni Jesus. Ta naalay dan a nabaheta na megipu ha ni Jesus. Ket kayat na a maenta i milagro a ginimigimet ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Isu a nasurok i pinagsalodsod na ha ni Jesus. Ngem pulos, awan tinabbeg ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sa hidi, binumikan i matangkay a papadi, ken maestro a hidi na linteg, penu magpaliwat ha ni Jesus ha saguppang ni Herod. Ket maingal i pinangpaliwat di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ket nagkayag ni Herod ken sundalu na a hidi ha ni Jesus. Ket inulew di. Sa di, tinennonan ni Jesus ha tennon na hari, a kona nu aginhahari hikuna, ket pinasoli di ha ni Pilato. ");
INSERT INTO duo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Niyaen, idi palungo na iday a pamalak, nakiingal ni Pilato a taga-Roma, ken ni Herod a esa a Judyo. Ngem nangrugi ha iday a pamalak, nagilay hidi, gipu ha ginimet di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ket nagpapisan ni Pilato ha matangkay a papadi, ken kapkapitan na Judyo, ken kakpalan a tolay a hidi. ");
INSERT INTO duo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ket kinagi na, “Inyangay moy ide a lallaki ha nikan, ket inpeta moy a nakangsileng hikuna ha totolay na Judeya. Ket inembestigar ko hikuna ha saguppang moy. Ngem awan ko naeriyokan i liwat na, a pangpaliwat moy ha nikuna. ");
INSERT INTO duo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ket kona bila hito ha ni Herod, i Gobernador moy a Judyo. Ta awan hikuna nakaeriyok ha liwat na. Ket pinasoli na ni Jesus ha nikan. Niyaen, awan ha ginimet na ide a lallaki a pakatayan na mina. ");
INSERT INTO duo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Isu, pabaot ko hikuna, ket palobusan ko,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kinagi na ito ni Pilato gipu ha ugali na Judyo a hidi. Ha kada Piyesta na Pinagtaleban, agedan di ha nikuna a palobusan na i esa a balud. ");
INSERT INTO duo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngem inrangsit na kakpalan a hidi, “Patayan mo hikuna! Palobusan mo ni Barabas!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Niyaen, napabalud ni Barabas gipu ha pinangpulas na ha totolay ha Jerusalem a makilaban ha gobyerno, ken gipu ha pinagbuno na ha esa a tolay. ");
INSERT INTO duo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ngem kayat ni Pilato a palobusan ni Jesus. Isu, ipenduwa na i kinagi na. ");
INSERT INTO duo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ngem inrangsit di, “Pelansa mo hikuna ha kudos! Pelansa mo hikuna ha kudos!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ket inpentallu ni Pilato, “Apay? Anya i liwat na? Awan ko makatandiyan i liwat na, a patayan ko mina hikuna! Pabaot ko dod, ket palobusan,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngem intulos di a nagrangsit, a pelansa di mina ni Jesus ha kudos. Ket tinumulos hidi hanggan naabak di ni Pilato. ");
INSERT INTO duo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Isu, inayunan na hidi ha kayat di. ");
INSERT INTO duo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ket pinalobusan na ni Barabas, a inaged di. Hikuna i lallaki a nepabalud gipu ha pinagpulas na ha gobyerno, ken pinagbuno na. Ket ha ni Jesus, inbon ni Pilato a pelansa mina hikuna ha kudos, a kona ha kayat na Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Idi inyangay di ni Jesus ha lapos na Jerusalem, natagbu di i esa a lallaki a sumasaddap ha ili. Taga-Sirene hikuna, ket ni Simon i nagen na. Dinakap di hikuna, ket inpabaklay di ha nikuna i kudos a umunod ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ket inumunod bila i kakpalan a hidi. Atoy bila i babbey a hidi a nangsangisanget ken nagngongoyngoy gipu ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ket sinumoleg ni Jesus, a kinagi na ha nidi, “Hikam a babbey na Jerusalem, bakkan a hikan mina i pagsangetan moy, nu awan ha magimet ha baggi moy ken annak moy nokkan. ");
INSERT INTO duo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta dumemat i marigat a tiyempo nu magkagi hidi ha, ‘Mas mappiya i kasasaad na babbey a awan nagenak. Mas mappiya i kasasaad na babbey a awan magpasuso!’ kon di. ");
INSERT INTO duo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iday i tiyempo nu ipeta di ha amamugod, ‘Dageyan mo kami bi! Ilabbang mo kami bi!’ Ta marigat iday a tiyempo. Ket kayat na totolay i matay. ");
INSERT INTO duo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Oni ay,” kinagi ni Jesus. “Ta nu kona hito i gimetan di ha nikan a awan ha liwat, mas marigat gamen i magimet nokkan ha totolay a kelliwat,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Niyaen, idi neyangay di ni Jesus ha pahagpatayan di, neyangay di bila i duwa a mahagtakaw. ");
INSERT INTO duo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ket pagdemat di ha lugar a managenan ha “Karbot”, inlansa na sunsundalu ni Jesus ha kudos. Ket pinatolnak di ito ha lutak. Ket inlansa di bila i duwa a mahagtakaw. Ket pinatolnak di i esa ha kanigid ni Jesus, ken esa ha kanawan na. ");
INSERT INTO duo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ket kinagi ni Jesus, “Hama ko, pakawanan mo bi i sundalu a hidi ha gimetan di aye! Ta awan di makatandiyan i gimetan di,” kon na. Ket tinumulos i sundalu a hidi, a pinilak di i tennon ni Jesus. Ket nagbabinnunotan hidi nu heya i makaalap ha iday a tennon. ");
INSERT INTO duo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ket ha nidi a kakpalan, nagamata hidi. Ngem nagloloko i kapitan a hidi. Kinagi di, “Entan moy, ta nakasalakan kan hikuna ha sabali a totolay, kon na kan. Isu, nu tahod a hikuna i Cristu a paangayan na Dios a maghari, mesalakan na mina i baggi na niyaen!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ket inulew na bila na sundalu a hidi. Binumikan hidi, a inyatad di i maapsut a basi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ket kinagi di, “Alan, isalakan mo dan i baggi mo, nu tahod a hikaw i Hari na Judyo!” kon di. ");
INSERT INTO duo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ta atoy ha ontok na kudos i nagsuratan a, “Ide i Hari na Judyo.” ");
INSERT INTO duo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ket nagulew bila i esa a mahagtakaw a nelansa, “Nu tahod a hikaw i Cristu, isalakan mo dan i baggi mo. Ket isalakan mo kami bila!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ngem binahang na sabali a mahagtakaw i agum na, “Awan ka masaniki ha Dios? Magkalan ngamin i parusa tam. ");
INSERT INTO duo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ket tamos a hikita mina i maparusaan, ta madukas i ginimet ta. Ngem ha nikuna, pulos, awan ha liwat na,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sa na, inaged ha ni Jesus, “Jesus, nokkan nu maghari ka, nanakamanak mo bi!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ket kinagi ni Jesus ha nikuna, “Tahod. Ipeta ko ha nikaw, a nokkan la, ha yenan a pamalak, kaaguman taka ha paraiso, ha langit,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Idi lubuk na pamalak heya, ket bigu la a nadiklam i ngamin a lutak, ta nagdiklam i senggit hanggan alas tres. ");
INSERT INTO duo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sa iho, ha Templo, napisad i kurtina a pangsallen ha totolay ha kuwarto a nadiosan. ");
INSERT INTO duo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ket indulaw ni Jesus a napigsa, “Hama! Igiwat ko ha nikaw i espiritu ko aye.” Ito i kinagi ni Jesus. Sa, natay dan. ");
INSERT INTO duo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Idi naenta na kapitan na sundalu, dineyaw na, a “Tahod a awan ha liwat ha ide a lallaki!” kon na. ");
INSERT INTO duo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Idi naenta na bila na totolay a nangaamata, sinumoli hidi ngamin. Ket nagngoyngoy hidi, idi linumakad, gipu ha pagladingit di. ");
INSERT INTO duo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ket ha nidi a ilay ni Jesus, pati i babbey a hidi a inumunod a nagipu ha Galileya, tinumaknag hidi ha madiyo, a nangaamata pala. ");
INSERT INTO duo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Niyaen, atoy i esa a lakay, a nagen na ni Jose. Taga-Arimateya hikuna, ha Judeya. Ket mappiya i ugali na. Ket nagtahotahod hikuna ha pagdemat na paghariyan na Dios. Ket maski nu hikuna i esa a panglakayan na Judyo, ken sakop na Sanhedrin, awan hikuna naguseg ha ginimet di ha ni Jesus. Ta awan hikuna inumoni ha kayat di a gimetan ha ni Jesus. Ket inumadi hikuna ha pinagbuno di ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Niyaen, hikuna i inumangay ha ni Pilato, ket inaged na i bangkay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sa na, inpeyogsad i bangkay ni Jesus, ket binadbadan na ha naponset a hamet. Ket intagmak na ito ha disalad na kuweba, a nakotkotan ha dilenas. Bigu pala ide a kuweba, a awan pala ha nelabbang hito. ");
INSERT INTO duo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Biyernes iday a pamalak a pagsagana di mina ha Sabado a pagemmang di, a kona ha nebon na Dios. Ta maneg man nu magtarabaho hidi ha Sabado. ");
INSERT INTO duo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Isu a nakiuseg ha ni Jose i babbey a hidi a nagagum idi ha ni Jesus a nagipu ha Galileya. Ket naenta di i paglabbangan na, ken nu panyan na a itagmak i bangkay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sa hidi, sinumoli. Ket insagana di i mabanglo a pangpasahob a ipuhet di mina na bangkay ni Jesus nokkan. Ket idi Sabado dan, inumemmang la hidi. Ta umuseg hidi ha Linteg na Dios. ");
INSERT INTO duo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Idi mamaledum na Dominggo, tinawed na babbey a hidi i pangpasahob ha kuweba. ");
INSERT INTO duo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Idi pagdemat di ha kuweba, naenta di a naadya dan i pogedu a pangkallab na sundalu ha abot na. ");
INSERT INTO duo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Isu, sinumadap hidi, ngem awan di naeriyokan i bangkay ni Apo Jesus! ");
INSERT INTO duo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Idi nakiuhon hidi nu anya i nagimet, ket bigu la a nagpaenta i duwa a lallaki. Nagtennon hidi ha magihapgihap a tennon. ");
INSERT INTO duo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ket tinumokham i babbey a hidi, gipu ta nanteng hidi. Ngem kinagi na lallaki a hidi, “Apay a eriyokan moy i sibibiyag ha kahenan na natay? ");
INSERT INTO duo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Nakaman moy mina i nepeta na ha Galileya, a ‘Masapul a madakapak gipu ha madukas a totolay,’ kon na. ‘Ket pelansa di ak ha kudos. Ngem nokkan, nu mobos i tallu a pamalak, magbiyagak manon,’ kon ni Jesus. Ito i nepeta na ha nikam idi. Ket niyaen, awan ni Jesus ha he. Ta minagbiyag manon hikuna,” kon na lallaki a hidi. ");
INSERT INTO duo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ket nanakam na babbey a hidi ide a kinagi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ket sinumoli hidi, a mangibaheta ha esa a pulo ket esa a apostol ni Jesus. Ket inbaheta di bila ha ngamin a agagum di. ");
INSERT INTO duo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Niyaen, idagende i babbey a nagibaheta, a ni Maria Magdalena, ni Juana, ken ni Maria a hena ni Santiyago. Hidi, ken atoy bila i sabasabali a babbey a nakiagum a nangibaheta ha apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ngem awan nanahod i apostol a hidi. Ta kagin di a nagsalawasaw la i babbey a hidi. ");
INSERT INTO duo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngem binumuyot ni Pedro ha kuweba, ket sinumadap. Ket naenta na i maponset a hamet a pinangbadbad di idi. Ngem iday la i naenta na. Ket naskal bila hikuna ha nagimet ayo. Ket sinumoli ha bilay. ");
INSERT INTO duo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ha iday pala a pamalak, atoy i duwa a tolduwan ni Jesus a linumakadlakad ha ili a Emaus, a esa pulo ket esa a kilometro a magipu ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nakiuhon hidi megipu ha ngamin a nagimet ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Idi nakiuhon hidi, binumikan ni Jesus, a kinumuyog. ");
INSERT INTO duo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Naenta di hikuna, ngem kona ha sinalenan na Dios i nakam di, penu awan di melasin. ");
INSERT INTO duo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ket nagsalodsod ni Jesus, “Anya i paguhonan moy?” Ket tinumaran hidi. Ket naladingit unay i rupa di. ");
INSERT INTO duo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kinagi na esa, a ni Kleopas i nagen na, “Anya, nagipu ka ha Jerusalem, ngem awan mo nabaheta i nagimet ha ho?” kon na. ");
INSERT INTO duo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Anya i nagimet ho?” kinagi ni Jesus. Ket tinabbeg di, “Agay, i ginimet di ha ni Jesus a taga-Nasaret. Hikuna i minahagpugto, ket inayat na hikuna na Dios. Ket inayat na bila na makpal a tolay, gipu ta mannakabalin i pinagitoldu na ken pinaggimet na. Ta ginimet na i makpal a milagro. ");
INSERT INTO duo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ngem pinadakap na hikuna na kapkapitan mi ken matangkay a hidi a papadi. Ket inpaangay di ha gobernador, penu patayan di hikuna. Ket inlansa di ha kudos. ");
INSERT INTO duo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Ninamnama mi a hikuna i Cristu na Israel, a pinaangay na Dios, a mangisalakan mina ha nikitam. Ngem niyaen dan i mekatallu a pamalak a natay dan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ket nenayon pala ha dagende, a pinalaktat na kami na babbey a hidi. Ta inumangay hidi ha labbang na nakoya a maledum. ");
INSERT INTO duo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ngem awan di naeriyokan i bangkay na. Ket idi sinumoli hidi, kinagi di a nagpaenta i duwa a anghel, a nangibaheta a minagbiyag manon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Isu a binumuyot i sabali a agagum mi ha ido a kuweba, penu maenta di. Ket naenta di kan i kona ha kinagi na babbey a hidi. Ngem awan di naenta ni Jesus,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ket kinagi ni Jesus, “Agay! Awan moy pala makatandiyan! Ito i nepugto na minahagpugto a hidi, idi nikuna a naalay dan. Apay a marigat ha nikam a manahod ha ngamin a nepugto di? ");
INSERT INTO duo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ta awan a mabalin a sumadap i Cristu ha kaamakan na ha langit, nu awan a palungo a magattam hikuna ha rigrigat na,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ket inpakatandi ni Jesus i ngamin a nesurat megipu ha baggi na ha Libro na Dios. Nangrugi hikuna ha liblibro ni Moyses hanggan ha ngamin a surat na minahagpugto a hidi. ");
INSERT INTO duo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Niyaen, idi binumikan hidi ha ili a angayan di, nagintutulos ni Jesus ha paglakad na. ");
INSERT INTO duo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ngem kinagi di, “Awan kas! Kallap dan! Makidagus ka dan ha nikami!” Isu a nakidagus ni Jesus ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ket idi inumetnod hidi a magkan, inalap ni Jesus i tinapay, ket nagkararag. Sa na, pinilak i tinapay, ket inyatad na ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ket nakalasin hidi ha ni Jesus. Ngem bigu la, linompas dan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ket nakiuhon hidi, “Nakoya la, idi linumakad kita ha karsada, kona ha gangatan ha disalad na baggi ta. Ket nakaendu! Ket naragsak kita ha kakkagi na, idi nepakatandi na i Libro na Dios,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Isu a nagsigida hidi a nagsoli ha Jerusalem. Ket naeriyokan di i esa pulo ket esa, a nakipagpisan, ken atoy bila i agagum di, ");
INSERT INTO duo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","a nakiuhon hidi megipu ha ni Jesus. Kinagi di, “Tahod agay a minagbiyag manon ni Jesus, ta nagpaenta hikuna ha ni Simon,” kon di. ");
INSERT INTO duo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ket inbaheta na duwa i ngamin a nagimet ha karsada ha Emaus, ken nu panyan di a nelassin ni Jesus, idi nagpilak hikuna ha tinapay. ");
INSERT INTO duo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Idi nagibaheta pala hidi duwa, bigu la, ket nagpaenta ni Jesus ha nidi ngamin. Tinumaknag hikuna ha lubuk di, ket kinagi na ha nidi, “Tumalna kam mina,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngem kinumanteng unay hidi, gipu ta kagin di a naenta di i esa a mangilen. ");
INSERT INTO duo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ket kinagi dod ni Jesus, “Apay manteng kam? Apay a magduwaduwa kam ha nakam moy? ");
INSERT INTO duo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Entan moy i kamat ko ken tikad ko aye. Ta makaenta kam a ide i baggi ko. Ket egkamanak moy, penu katandiyan moy. Ta awan ha gaddang, onu pilas, onu tulang ha esa a mangilen. Ngem makaenta kam a atoy i gaddang, ken pilas, ken tulang ha nikan,” kon na. ");
INSERT INTO duo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Idi kinagi ni Jesus ito, pinaenta na i kamat na ken tikad na ha nidi. ");
INSERT INTO duo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ngem maski nu naragsak unay hidi, awan pala hidi sigurado. Ket nanakaman di pala, nu manahod mina hidi onu awan. Isu a kinagi ni Jesus, “Atoy i mepakan moy ha nikan?” kon na. ");
INSERT INTO duo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ket inyatad di ha nikuna i padut a neyapoy. ");
INSERT INTO duo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ket inalap ni Jesus ide a padut, ket kinan na ha saguppang di, penu maenta di. ");
INSERT INTO duo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sa na, kinagi ni Jesus, “Ipenduwa ko i netoldu ko ha nikam idi ha palungo, a ‘Masapul a matongpal i ngamin a nesurat megipu ha nikan ha Linteg ni Moyses, ken ha sursurat na minahagpugto a hidi, ken ha libro na Kansiyon a hidi,’ kon ko idi. Ket idi palungo, inpeta ko ha nikam a magimet idagento ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sa na, pinakatandi hidi ha sursurat na Dios. ");
INSERT INTO duo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kinagi na, “Ide i nesurat di, ‘I Cristu a paangayan na Dios a maghari, hikuna i magattam ha rigrigat, sa matay, sa magbiyag manon ha mekatallu a pamalak,’ kon di. ");
INSERT INTO duo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ket ide bila i nesurat di,” kon ni Jesus. “ ‘Paangayan na Cristu i totolay na ha ngamin a lugar. Mangrugi hidi ha Jerusalem, hanggan ha ngamin a lutak, penu ibaheta di megipu ha ni Cristu. Ta gipu ha Cristu heya, mapakawan na Dios i liwaliwat na maski nu heya a magbabawi ken sumina ha liwaliwat na. Ket makiuseg hidi ha pagitoldu na Cristu.’ Ito i nepesurat na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Ket niyaen, hikam i magpatahod ha ngamin a tolay. Ta naenta moy i ngamin a dagende a nagimet. ");
INSERT INTO duo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ngem ha palungo a paglakadan moy, maguray kam ha Jerusalem. Ta atoy pala i gimetan ko ha nikam. Ta paangayan ko nokkan i Espiritu na Dios. Ket hikuna i mangiyatad ha nikam ha pinnakabalin a maggipu ha Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sa na, inyangay hidi ha lapos na ili. Ket idi nakademat hidi ha Betaniya, inyontok na i kamat na, ket inkararagan na hidi. ");
INSERT INTO duo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Idi inkararagan na hidi, inumadiyo hikuna, a neyunek hikuna ha langit. ");
INSERT INTO duo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ket nagparentumeng hidi a dineydeyaw di hikuna. Ket idi sinumoli hidi ha Jerusalem, dakkal i ragsak di. ");
INSERT INTO duo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ket naghen hidi ha Templo ha kada pamalak, a deydeyawan di i Dios.");
INSERT INTO duo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Idi palungo a naparsuwa i lutak, atoy dan i esa a managenan ha “Kagi na Dios.” Ket nagisesa hikuna ha Apo Dios, ket hikuna man bi i Apo Dios. ");
INSERT INTO duo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Oni ay, nagisesa hikuna ha Apo Dios, idi palungo a naparsuwa i ngamin. ");
INSERT INTO duo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ket pinagparsuwa na hikuna na Dios ha ngamin. Awan ha naparsuwa, nu awan a hikuna i nangparsuwa. ");
INSERT INTO duo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Niyaen, hikuna man bi i ikabiyag tam a totolay, ket makaalap kitam ha tahod a biyag gipu ha nikuna. Ta hikuna man bi i esa a Silaw a magpaenta ha totolay, a idilan na hidi, penu makatandiyan di i Apo Dios. ");
INSERT INTO duo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Niyaen, dinisyagan na Silaw aye i diham, ket awan maabak na diham ide a Silaw na Dios. ");
INSERT INTO duo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Niyaen, atoy bila i esa a tolay a pinaangay na Dios. Ket Juan i nagen na. ");
INSERT INTO duo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hikuna i pinaangay na Dios, penu mepakatandi na megipu ha ide a Silaw, a managenan ha Kagi na Dios, ket penu makatiman ken manahod i maski nu heya gipu ha pinagitoldu na. ");
INSERT INTO duo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bakkan a ni Juan i Silaw aye, ngem dinumemat hikuna, penu mepakatandi na megipu ha ide a Silaw na Dios. ");
INSERT INTO duo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Niyaen, idi tiyempo a ito, dinumemat ide a Silaw na Dios, a magdisyag ha nakam na ngamin a tolay ha lutak. ");
INSERT INTO duo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Isu, atoy dod hikuna ha lutak aye, ket gipu ha nikuna, naparsuwa i ngamin ha lutak, ngem awan na hikuna katandi na totolay. ");
INSERT INTO duo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ket inumangay hikuna ha sadili na a totolay, ngem minadiyan di hikuna. ");
INSERT INTO duo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngem ha maski nu heya a nagteman ken nanahod ha nikuna, inkalentigan na hidi a magbalin a annak na Dios. ");
INSERT INTO duo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bakkan ito a kona ha pakeenak tam a magbalin a annak na tolay. Ta awan ha magbalin a annak na Dios gipu ha pakeenak na, onu bukod na a pinaggimet, onu bukod na a pagayatan, nu awan gipu ha pagayatan na Dios. Gipu ta i Apo Dios a mismo i magpabalin ha totolay a annak na. ");
INSERT INTO duo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Niyaen, ha ide a “Kagi na Dios,” nagbalin hikuna a tolay, ket nakipaghen hikuna ha nikitam a totolay. Ket naenta mi a mahagkagbi hikuna ken mahagipeta hikuna ha tahod. Ket naenta mi bila i kainamakan na, a kainamakan a naggipu ha Apo Dios. Ta ito i inyatad na Hama na ha isesa a annak na. ");
INSERT INTO duo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ket idagento i inbaheta ni Juan, idi indulaw na, “Ide a lallaki i nagkagiyan ko. Ta kinagi ko idi a atoy nokkan i dumemat a magdilokod ha nikan. Ngem mas matangkay hikuna ngem ha nikan. Ta maski idi awanak pala neenak, atoy dan hikuna,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Niyaen, gipu ta ayayatan na kitam a tahod, nakagbiyan kitam. Ket kanayon na kitam kagbiyan ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Inyatad na Dios i Linteg na gipu ha ni Moyses. Ngem niyaen, inyatad na ha nikitam i kagbi na gipu ha ni Jesu-Cristu. Ket hikuna man bi i nangipakatandi ha kinatahod a megipu ha Apo Dios. ");
INSERT INTO duo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Awan ha nakaenta ha Apo Dios. Ngem i Annak na Dios a isesa, a maghen ha Nama na, hikuna a mismo i Dios, ket hikuna i nangipakatandi ha Dios ha totolay. ");
INSERT INTO duo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ide i kinagi ni Juan megipu ha ni Jesus. Ta atoy i kappal a pinaangay na Judyo a hidi ha ni Juan, penu magsalodsod hidi. Ket inumangay i kappal a papadi ken agagum di a napanagenan ha Lebito. Naggipu hidi ha Jerusalem. Ket sinalodsod di ni Juan nu heya hikuna. ");
INSERT INTO duo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ket tahod i intabbeg ni Juan. Awan hikuna nagpamen. Ta kinagi na, “Bakkan a hikan i Cristu.” ");
INSERT INTO duo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sa di, sinalodsod, “Heya ka dod? Hikaw dod ni Elias, a minagbiyag manon?” Ket tinabbeg ni Juan, “Awan.” Sa di, kinagi, “Hikaw dod iday a mahagpugto a tahokan na ngamin a Judyo?” kon di. Ket kinagi na, “Bakkan bila.” ");
INSERT INTO duo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Isu, kinagi di ha nikuna, “Heya ka dod? Tabbegan mo kami bi, penu atoy bila i tabbeg mi ha Happo mi. Anya i mepeta mo megipu ha baggi mo?” ");
INSERT INTO duo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ket kinagi ni Juan, “Nakaman moy mina i inpugto ni Isayas a mahagpugto idi. Ta inpugto na idi a atoy nokkan i magitoldu ha luglugar a awan ha bilabilay. Ket idulaw na kan, ‘Dandani a dumemat i Apo. Isu, magsagana kamon ha pagdemat na, a dalusan moy i nakam moy, penu makauseg kam ha nikuna,’ kon na. Ket niyaen, hikan dan iday a magitoldu,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Niyaen, atoy bila hay i kappal a Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ket sinalodsod di, “Isu, nu bakkan a hikaw i Cristu, onu Eliyas, onu iday a mahagpugto a tahokan mi, apay dod a magbinyag ka?” ");
INSERT INTO duo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ket tinabbeg ni Juan, “Oni, maminyagak. Ket dinom la i pagbinyag ko. Ngem atoy pala i esa ha nikitam, ket awan moy hikuna katandi. ");
INSERT INTO duo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ta magdilokod pala hikuna ha nikan, maski mas matangkay hikuna. Ket nu ikalanak moy ha nikuna, awanak ha pagserbe, maski nu tagabu na la,” kon ni Juan ha Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nagimet ito ha ili a Betaniya, ha dibelew na karayan Jordan a pagbinyagan ni Juan. ");
INSERT INTO duo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Niyaen, idi kaugman na, naenta ni Juan a umangay ni Jesus ha henan na. Ket kinagi ni Juan, “Atoy dan i kona ha Kordero a pangiwagah ha Dios, a pangadya ha liwaliwat na totolay. ");
INSERT INTO duo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hikuna i kinagi ko idi, a ‘Atoy nokkan i magdilokod ha nikan, ket mas matangkay hikuna ngem hikan. Ta idi awanak pala neenak, atoy dan hikuna,’ kon ko. ");
INSERT INTO duo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ket maski ha nikan idi, awan ko nakatandiyan nu heya i mangisalakan ha totolay. Maski nu iday i gipu na a inumangayak ha ihe, ket naminyagak ha dinom, penu mepakatandi ko hikuna ha totolay na Dios,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ket tinulos ni Juan ha pinagpakatandi na, a kinagi na, “Idi palungo, awan ko hikuna katandi. Ta awan ko hikuna nalasin, hanggan idi naenta ko i Espiritu na Dios a binumugsok, a kona ha kalapati a naggipu ha langit. Ket nagdissu ide a Espiritu a naghen hikuna ha ni Jesus. Ta atoy i inpeta na Dios ha nikan, idi pinaangay na ak a magbinyag ha dinom. Inpeta na, ‘Maenta mo nokkan i Espiritu ko a bumugsok ken magdisso ha esa a lallaki. Ket magtulos a maghen i Espiritu ko ha iday a lallaki. I lallaki aye i mahagbinyag ha Espiritu ko,’ kon na Dios ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ket niyaen, ide i kayat ko ipeta ha nikam. Ta naenta ko dan, ket masigurado ak a ide a lallaki i isesa a Annak na Dios,” kon ni Juan. ");
INSERT INTO duo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ket kona bila hito idi kaugman na. Ta atoy manon ni Juan ken hikami a duwa a tinolduwan na. ");
INSERT INTO duo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Naenta ni Juan ni Jesus a manglakalakad. Ket kinagi na manon, “Atoy dan i Kordero a pangiwagah ha Dios, a pangpaadya ha liwaliwat na totolay.” ");
INSERT INTO duo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Idi nateman mi ide, inumunod kami ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ket nagsoleg ni Jesus, ket naenta na a umuunod kami. Ket kinagi na, “Atoy i kayat moy ipeta?” Ket kinagi mi, “Rabbi, hadya i paghenan mo?” kom mi. (Ha kagi na Judyo, “Maestro,” i kayat na kagiyan na “Rabbi.”) ");
INSERT INTO duo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ket kinagi na, “Umuseg kam, ket metan moy,” kon na. Isu, inumuseg kami. Ket naenta mi i paghenan na. Ket gipu ta apon dan, nakidagus kami ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","I nagen na agum ko, idi nateman mi i kinagi ni Juan, ken inumunod kami ha ni Jesus, hikuna ni Andres a wadi ni Simon Pedro. ");
INSERT INTO duo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ket dagus a nageriyok ni Andres ha hekka na, a inpeta na, “Naenta mi dan i paangayan na Dios a maghari, hikuna a nagenan tam ha ‘Mesiyas.’” (Ket ha kagi na Griego, “Cristu.”) ");
INSERT INTO duo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sana, intugan ni Andres ni Simon ha ni Jesus. Ket inaamatan ni Jesus ni Simon. Sana, kinagi, “Hikaw ni Simon a annak ni Juan. Ngem niyaen, isangay taka ha ‘Kepas.’” (I kayat na kagiyan na, “pogedu a awan mapalembok.”) ");
INSERT INTO duo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Idi kaugman na, ninakam ni Jesus a umangay ha probinsiya a Galileya. Idi paglakad na, naenta na ni Pelipe. Ket kinagi na ha nikuna, “Umuseg ka ha nikan.” ");
INSERT INTO duo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Niyaen, ha ide a Pelipe, hikuna i esa a kaili ni Andres ken ni Pedro, ta taga-Betsayda hidi ngamin, ha probinsiya a Galileya. ");
INSERT INTO duo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ket dagus a ineriyok ni Pelipe ni Natanael, ket kinagi na, “Agay, naenta mi i lallaki a sinurat ni Moyses ha libro na Linteg ken sinurat bila na minahagpugto a hidi. Hikuna ni Jesus, a taga-Nasaret, a annak ni Jose,” kon ni Pelipe. ");
INSERT INTO duo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ngem kinagi ni Natanael, “Agay, awan ha mappiya ha madukas a lugar a Nasaret!” Ngem tinabbeg ni Pelipe, “Entamon agay, a entan ta.” ");
INSERT INTO duo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Niyaen, idi naenta ni Jesus a umangay ni Natanael ha henan na, kinagi na, “Atoy dan i tahod a Judyo. Ta awan hikuna magpamen ha kakkagi na.” ");
INSERT INTO duo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ket kinagi ni Natanael, “Panya a katandi ak mo?” Ket tinabbeg ni Jesus, “Idi atoy ka ha lendum na kayo a igos, idi palungo a inayagan na ka ni Pelipe, naenta taka.” ");
INSERT INTO duo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ket kinagi ni Natanael, “Maestro, hikaw i isesa a Annak na Dios! Hikaw i Hari na Israel!” ");
INSERT INTO duo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ket kinagi ni Jesus, “Manahod ka dod gipu ta kinagi ko, a naenta taka ha lendum na kayo a igos? Agay, maenta mo nokkan i dakdakkal a milagro ngem ide.” ");
INSERT INTO duo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ket tinulos ni Jesus, “Tahod ide a ipeta ko ha nikam. Maenta moy nokkan i langit a melukat. Ket maenta moy i anghel a hidi na Dios, a umontok ken bumugsok ha nikan, i Lallaki a Naggipu ha Langit.” ");
INSERT INTO duo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Idi kobosan na duwa a pamalak, atoy i esa a pagbodaan ha ili a Kana, ha probinsiya a Galileya. Ket atoy bila hay i hena ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ket naawis bila ni Jesus ken hikami a tinolduwan na. ");
INSERT INTO duo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Niyaen, idi nobos i arak, kinagi nena na ha ni Jesus, “Inubos di dan i arak di.” ");
INSERT INTO duo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ngem kinagi ni Jesus ha hena na, “Babbey, awan a masapul a ipeta mo ha nikan. Awan ha biyang mo ha ide. Ta awan pala ha oras a ipaenta ko mina i pinnakabalin ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ket kinagi nena na ha tagabu a hidi, “Gimetan moy i maski nu anya a ipeta na ha nikam.” ");
INSERT INTO duo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Niyaen, gipu ha linteg na Judyo a paguges, atoy hay i annam a burnay. Ket maglaon i kada esa ha nasurok a esa gasut a litro. ");
INSERT INTO duo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ket kinagi ni Jesus ha tagabu a hidi, “Putatan moy hidi ha dinom.” Ket pinutat di idagenday a burnay. ");
INSERT INTO duo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sana, kinagi, “Sumalduk kam ha ballik, a itugan moy ha mangituray ha pagbodaan aye.” Ket intugan di ito. ");
INSERT INTO duo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Niyaen, idi naennaman na mangituray i dinom aye a nagbalin a arak, inayagan na i nobyo. Ta awan na nakatandiyan nu hadya i nagipuwan na arak aye. (Maski nakatandiyan na tagabu a hidi. Ta hidi man i sinumalduk ha dinom.) ");
INSERT INTO duo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ket kinagi na mangituray ha nobyo, “Dadi pala agay! I ugali na totolay, a iyatad di i masinggat a arak ha palungo. Ket nu makpal i nainum na bisita di, iyatad di bila i makkak a arak a magdilokod. Ngem bakkan i ginimet mo ha ihe. Ta ide i masmasingget a arak,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ginimet ni Jesus ide a nekaesa a milagro, a pangtiplad na, ha ili a Kana, ha probinsiya a Galileya. Ket ide i pinangpaenta na ha kaddat na a kinadios ha totolay a hidi ken ha nikami a tinolduwan na. Ket gipu ta kona hito, pinumigsa i panahod mi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Idi kobosan na ide, inumangay ni Jesus ha ili a Kapernaum. Ket inumuseg bila i hena ken wadwadi na, ken hikami a tinolduwan na. Ket naghen kami hito ha maalay ballik. ");
INSERT INTO duo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Niyaen, mabikan dan i piyesta na Judyo a nagenan di ha, “Piyesta na Pinagtaleban na Anghel a Magpatay.” Ket inumangay ni Jesus ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Idi kaddemat na, inumangay hikuna ha Templo, ket atoy hay i naenta na a mahaglako ha baka, ken karnero, ken kalapati. Ket atoy bila hidi a mahagsulet ha korinat. Ket atoy bila hay i lalamesaan di a pagnegosiyoan di. ");
INSERT INTO duo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Idi naenta na ito ni Jesus, naglubid hikuna ha pagbaot na, sana, pinalapos hidi ngamin, pati i baka ken karnero a hidi. Ket pinahakab na i lamesaan na negosiyante a hidi a mahagsulet ha korinat. Ket inwarak na i korinat di. ");
INSERT INTO duo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ket binon na hidi a mahaglako ha kalapati, “Adyan moy idagenday. Awan moy pagbalinan a tiyendaan i bilay Nama ko,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ket ha nikami a tinolduwan na, idi nateman mi ito, nanakam mi i nesurat ha Libro na Dios, a “Dakkal unay i pinagayat ko ha Bilay mo, Apo Dios. Isu i gipu na a masaket unay i nakam ko, gipu ta awan di deyawan i Bilay mo.” ");
INSERT INTO duo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ket gipu ha ide a ginimet ni Jesus ha Templo, kinagi na Judyo a hidi ha nikuna, “Ipaenta mo ha nikami i nakaddatan a pangpatahod mina a magturay ka ha ide a Templo na Dios.” ");
INSERT INTO duo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tinabbeg ni Jesus, “Nu dadailan moy ide a templo, pataknagan ko manon ha tallu a pamalak.” ");
INSERT INTO duo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ket kinagi na Judyo a hidi, “Anya wadis! Uppat a pulo ket annam a tawen i pinangpataknag di ha ide a Templo. Ket kaya mo a magpataknag manon ha tallu la a pamalak? Panyan mo agay,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngem i templo a pagkagiyan ni Jesus, i templo a bukod na a baggi. ");
INSERT INTO duo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ket ha nikami a tinolduwan na, nanakam mi ito, idi minabiyag manon ni Jesus ha nekatallu a pamalak. Ket napatahodan kami ha sursurat na Dios ken kagi ni Jesus megipu ha baggi na. ");
INSERT INTO duo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Niyaen, idi hen pala ni Jesus ha Jerusalem ha Piyesta na Pinagtaleban, makpal i nanahod ha nikuna. Ta naenta di i nakaddatan a ginimigimet na. ");
INSERT INTO duo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ngem awan na intalak ha nidi i baggi na. ");
INSERT INTO duo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ta nakatandiyan ni Jesus i nakanakam na tolay, ken ugali di, ken kinalupoy na panahod di. Awan na masapul i mangipakatandi ha nikuna megipu ha totolay. Ta hikuna a mismo i makatandi ha disalad na nakam di. ");
INSERT INTO duo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Atoy idi i esa a Pariseyo, a nagen na ni Nikodemo. Hikuna i esa a pangulo na Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Idi esa a kallap, inumangay ni Nikodemo ha ni Jesus. Ket kinagi na, “Maestro, katandiyan mi a hikaw i esa a maestro a naggipu ha Dios. Ta awan ha makagimet ha nakaddatan a ginimigimet mo, nu awan a atoy ha nikuna i Dios,” kon ni Nikodemo. ");
INSERT INTO duo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ket kinagi ni Jesus, “Tahod ide a ipeta ko ha nikaw. Awan ha makapasakop ha Paghariyan na Dios, nu awan a neenak manon hikuna.” ");
INSERT INTO duo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ket kinagi ni Nikodemo, “Panya agay a meenak manon i esa a lallaki? Makasadap dod hikuna ha tiyan nena na, penu meenak manon?” ");
INSERT INTO duo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ket tinabbeg ni Jesus, “Ipeta ko a tahod a awan ha makapasakop ha paghariyan na Dios, nu awan a neenak hikuna ha dinom, ken ha Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Halimbawa: Nu mageenak i esa a tolay, tolay bila i annak na. Ngem nu mageenak i Espiritu na Dios, espiritu bila i annak na. Ket kebbiyag ito a ikabiyag na tolay, a kona nu meenak manon i tolay heya, ket magbalin hikuna a annak na Dios. ");
INSERT INTO duo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Niyaen, awan ka mina malaktat nu ipeta ko ha nikaw, a ‘Masapul a meenak ka manon.’ ");
INSERT INTO duo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ta maski nu awan mo pala makatandiyan, magimet paman ito. Halimbawa: Kona bila ha paras. Atoy i makpal a lakadan na paras, ket masaneg tam i tanog na. Ngem awan tam maenta nu hadya i naggipuwan na, onu hadya i angayan na. Ket kona bila hito ha maski nu heya a meenak na Espiritu na Dios. Awan ha makatandi ha pakeenak manon na esa a tolay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ket kinagi ni Nikodemo, “Ngem panyan na iday?” ");
INSERT INTO duo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","“Agay,” kon ni Jesus, “hikaw i mahagitoldu ha kakalan ta a Judyo, ngem awan mo makatandiyan i kinagi ko? ");
INSERT INTO duo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tahod ide a ipeta ko ha nikaw. I pagkagiyan ko aye i naenta ken katandi ko, ngem awan moy tahodan. ");
INSERT INTO duo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Niyaen, nu nepakatandi ko megipu ha bagbagay na lutak, ngem awan moy tinahod, panya moy tahodan nu ipakatandi ko megipu ha bagbagay ha langit? ");
INSERT INTO duo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Awan ha makaontok ha langit ken sumoli ha lutak a mangipeta megipu ha bagbagay a nelangitan, nu awan la a hikan, i Lallaki a Naggipu ha Langit. Ta iday i paghenan ko. ");
INSERT INTO duo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Niyaen, masapul a melansa ide a Lallaki a Naggipu ha Langit, ket mebayog ak nokkan ha matangkay, ha esa a kayo, a kona ha pinangibayog ni Moyses ha sinanulag ha naglakadan di a amamugod. ");
INSERT INTO duo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Magimet ito, penu mapadasan na maski nu heya a manahod ha nikan i biyag na Dios a magnanayon,” kon ni Jesus ha ni Nikodemo. ");
INSERT INTO duo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dakkal unay i pinagayat na Dios ha totolay. Isu i gipu na a inyatad na i isesa a Annak na a pangadya ha liwat na totolay, penu awan hidi maparusaan nu awan a mesalakan i maski nu heya a manahod ha nikuna, ken penu makipagbiyag hidi ha Dios ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ta awan pinaangay na Dios ide a Annak na penu hukoman na i totolay, nu awan penu isalakan na hidi. ");
INSERT INTO duo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Awan a mahukom i maski nu heya a manahod ha Annak na Dios. Ngem nahukom dan i maski nu heya a awan a manahod. Ta tinumallekod dan hikuna ha isesa a Annak na Dios. ");
INSERT INTO duo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ide i gipu na a mahukom nokkan i totolay: Ta dinumemat dan i Silaw na Dios ha lutak aye. Ngem kaykayat di i diham. Ta madukas i paggimi-gimet di. ");
INSERT INTO duo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ket madiyan di i Silaw aye. Ta magmadi ha Silaw i maski nu heya a maggimet ha madukas. Ket madiyan di a bumikan ha Silaw. Ta kanteng di a baka disiyagan na i liwaliwat di. ");
INSERT INTO duo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ngem ha maggimet a hidi ha mappiya, bumikan hidi ha Silaw aye, penu mepaenta di a Apo Dios i nagdaggap ha pinaggimet di. ");
INSERT INTO duo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kobosan na iday, inumangay ni Jesus ha probinsiya a Judeya, pati hikami a tinolduwan na. Ket naghen kami hito. Ket nagbinyag kami ha tolay a hidi. ");
INSERT INTO duo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ket atoy bila hay ni Juan, a nagbinyag ha lugar a Enon, a mabikan ha ili a Salim, ta atoy hay i makpal a dinom. Ket inumangay i tolay a hidi, a nagpabinyag hidi. ");
INSERT INTO duo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Idi tiyempo hito, awan pala nebalud ni Juan.) ");
INSERT INTO duo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Niyaen, nakipagtabbegan i kappal a tinolduwan ni Juan ha esa a Judyo, megipu ha ugali di a pinakauges di ha liwat. ");
INSERT INTO duo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ket inumangay hidi ha ni Juan. Kinagi di, “Maestro, atoy ni Jesus ha dibelew, hikuna esa a nagagum ha nikaw idi, ha Karayan Jordan. Hikuna i inpeta mo ha nikami idi. Ket niyaen, magbinyag hikuna, ket umaangay kan i ngamin a tolay ha nikuna,” kon na tinolduwan a hidi ni Juan. ");
INSERT INTO duo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ket tinabbeg ni Juan, “Tahod i gimetan ni Jesus. Ta Apo Dios i makatandi ha gimetan na. Ket Dios i mangipeta nu anya i gimetan na tolay. ");
INSERT INTO duo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hikam a mismo i nagteman ha kinagi ko idi, a ‘Bakkan a hikan i Cristu,’ kon ko. ‘Ngem napaangayak a paggayakan ko i tolay a hidi ha pagdemat na,’ kon ko. ");
INSERT INTO duo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Halimbawa: ha esa a pagbodaan, atoy i nobyo, ken atoy i nobya na, ken atoy i ilay na nobyo. Niyaen, iday a nobyo i makinkukuwa ha nobya. Ket iday a ilay na i maguray, a tahokan na i nobyo heya. Nu mateman na i timek na, magragsak hikuna unay. Niyaen, ni Jesus i kakalan na nobyo. Ket i totolay a sakop na i kakalan na nobya. Ket hikan i kona ha ilay na nobyo. Ket ide i gipu na a magragsakak unay, gipu ta makpal i umaangay ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Niyaen, masapul a tumatangkay hikuna, ket dumidibbi ak dan. ");
INSERT INTO duo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Hikuna man i naggipu ha langit. Ket mas matangkay hikuna ngem ha ngamin a sabali. Ha nikitam a taga-lutak, metoldu tam la i bagbagay a atoy ha lutak. Ngem ha nikuna a naggipu ha langit, magturay hikuna ha ngamin. ");
INSERT INTO duo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ket metoldu na i bagbagay ha langit, ta idagenday i naenta ken nateman na. Ngem maski nu kona hito, makpal hidi unay a magmadi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ngem ha ngamin a manahod ha ni Jesus, umoni hidi a tahod i kakkagi na Apo Dios. ");
INSERT INTO duo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ta ito malla i kakkagi ni Jesus a pinaangay na Dios. I kakkagi ni Jesus aye i kakkagi na Dios. Ta inatdinan na hikuna na Dios ha ngamin a Espiritu na, ket awan hikuna makurangan ha Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ayayatan na Dios i Annak na aye. Ket intalak na i ngamin ha nikuna, a pagturayan na hikuna ha ngamin. ");
INSERT INTO duo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Niyaen, ha maski nu heya a manahod ha Annak na Dios, magpasakop hikuna ha Apo Dios. Ket makibiyag hikuna ha Dios ha magnanayon. Ngem ha maski nu heya a awan a umuseg ha Annak na Dios, awan hikuna makipagbiyag ha Dios nu awan a parusaan na hikuna ha magnanayon.” ");
INSERT INTO duo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Niyaen, nabahetaan na Pariseyo a hidi a mas makpal i tolduwan a masakop ni Jesus. Ket mas makpal kan i binbinyagan na ngem ni Juan. (Maski bakkan a ni Jesus i nagbinyag, nu awan a hikami a tinolduwan na.) Ket idi nateman ni Jesus a kona hito i nabaheta na Pariseyo a hidi, linakadan na i probinsiya a Judeya. Ket sinumoli hikuna ha probinsiya a Galileya. ");
INSERT INTO duo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Masapul a lumakad hikuna ha probinsiya a Samariya. ");
INSERT INTO duo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Isu, dinumitang hikuna ha ili a Sikar, ha Samariya. Mabikan ito ha esa a talon a inyatad ni Jakob ha annak na a ni Jose, nikuna a naalay dan. ");
INSERT INTO duo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ket atoy bila hay i esa a bobon a kinotkot ni Jakob, nikuna a naalay dan. Niyaen, inumetnod ni Jesus ha nibik na bubun aye, ta nalupoy hikuna a naglakad. Ket dandani dan a lubuk na pamalak. ");
INSERT INTO duo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Idi awan naalay, dinumemat i esa a babbey a Samaritana a sumagab. Ket nagaged ni Jesus ha dinom. ");
INSERT INTO duo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Iday a babbey i nangagedan na, ta inumangay kami a tinolduwan na ha ili, a maggatang ha pagkanan mi. ");
INSERT INTO duo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ket kinagi na babbey, “Anya, hikaw i esa a Judyo. Hikan i esa a Samaritana, ket makienom ka ha nikan?” (Nalaktat iday a babbey. Ta ugali na Judyo i maglimad ha maski nu heya a Samaritano. Ket nakaman di a pasig la madukas i Samaritano a hidi.) ");
INSERT INTO duo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ngem kinagi ni Jesus, “Nu katandi mo mina i makienom aye ha nikaw, ken nu anya i iyatad na Dios ha totolay, magaged kas ha nikan. Ket atdinan taka ha mas masinggat a dinom a ikabiyag mo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ket kinagi na babbey, “Apo, madisalad unay ide a bobon, ket awan ka ha pagsagab. Hadya i pagalapan mo ha iday a dinom a ikabiyag ko? ");
INSERT INTO duo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","I apo tam a ni Jakob i nangiyatad ha nikami ha ide a bobon. Ket ide i nagsagaban na, ken apapo na, ken taraken di, hanggan niyaen. Anya, dod? Hikaw i dakdakkal ngem ni Jakob?” kon na babbey. ");
INSERT INTO duo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ngem kinagi ni Jesus, “Ha maski nu heya a uminom ha ide a dinom, mauwaw hikuna manon. ");
INSERT INTO duo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ngem ha maski nu heya a uminom ha iyatad ko, awan manon hikuna mauwaw. Ta ide a dinom a iyatad ko i magbalin a kona ha habwayan a awan massap. Ket ikabiyag na ito ha biyag na Dios a magnanayon,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ket kinagi na babbey, “Apo, iyatad mo bi ha nikan i dinom a kona hay, penu awanak manon mauwaw. Ket awan ko masapul a sumagab ha bobon aye,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ket kinagi ni Jesus, “Hen mo, a ayagan i kabanga mo. Ket sumoli kam ha ihe.” ");
INSERT INTO duo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ngem kinagi na babbey, “Awanak ha kabanga.” Ket kinagi ni Jesus, “Oni ah, tahod i kakkagi mo a awan ka ha kabanga. ");
INSERT INTO duo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ta naminlima ka dan a nangabanga. Ket niyaen, bakkan mo a kabanga i lallaki a kabbilay mo. Tahod iday a inpeta mo ha nikan.” ");
INSERT INTO duo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ket kinagi na babbey, “Apo, mannakabalin ka a magpugto! ");
INSERT INTO duo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Isu, masalodsod ko bi ha nikaw. Ta ide kan a parabin i nagdeyawan na minappo mi ha Dios. Ngem ha nikam a Judyo, ipeta moy a Jerusalem mina i tahod a pagdeyawan na totolay ha Dios,” kon na babbey. ");
INSERT INTO duo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ket kinagi ni Jesus, “Wadi ko, temananak mo bi. Ta ipeta ko a dandani dan i tiyempo, ket bakkan a parabin aye, onu Jerusalem i pagdeyawan na totolay ha Amang ko a Dios. ");
INSERT INTO duo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","24","I tahod a pagdeyawan na totolay ha Dios, i espiritu a maghen ha baggi di. Ta Apo Dios i Espiritu. Ket ha maski nu heya a magdeyaw ha nikuna, masapul a pagdeyaw na i Espiritu na Dios ken i pagitoldu na Espiritu na Dios a tahod. Ta kona hito i kayat na Dios ha totolay a magdeyaw ha nikuna, a deyawan di mina hikuna ha nakanakam di a tahod ken ha espiritu di a kebbiyag. Ta dumemat i tiyempo, ket maski niyaen a dinumemat dan, ket pangdeyaw na totolay ha Apo Dios i kona hito. Ta niyaen, ha nikami a Judyo, katandi mi dan i deyawan mi. Ta Judyo man bi i lallaki a paangayan na Dios a makesalakan ha totolay. Ngem ha nikam a Samaritano, awan moy katandi i deyawan moy,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ket kinagi na babbey, “I makatandiyan ko a dumemat nokkan i Mesiyas a managenan di ha Cristu. Ket nu dumemat hikuna, mepakatandi na ha nikitam ngamin i ngamin a bagbagay.” ");
INSERT INTO duo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ket kinagi ni Jesus, “Hikan i Cristu heya, a makiuhon ha nikaw.” ");
INSERT INTO duo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Niyaen, idi nakiuhon pala ni Jesus ken babbey aye a Samaritana, dinumitang kami a tinolduwan na. Ket nasbew kami, ta nakiuhon ni Jesus ken esa a babbey. Ngem awan ha nikami a nagsalodsod nu anya i masapul na, onu anya i naguhonan di. ");
INSERT INTO duo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ket inwarak na babbey i karamba na, ket nagsoli hikuna ha ili. Ket inbaheta na ha kaili na a hidi ho. ");
INSERT INTO duo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Entamon,” kon na. “Mepaenta ko ha nikam i esa a lallaki a naenta ko. Makatandiyan na i ngamin a ginimigimet ko. Entan tam nu hikuna wade i Cristu,” kon na babbey aye. ");
INSERT INTO duo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ket linumapos hidi ha ili, a inumangay ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kagiddan na, kayat mi hikuna pilitan a magkan. “Maestro, magkan kitam dan,” kon mi a tinolduwan na. ");
INSERT INTO duo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngem kinagi na, “Awan agay. Atoy bila kanan ko a awan moy makatandiyan.” ");
INSERT INTO duo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Isu a nagsisinalodsod kami, “Atoy wade i nangiyatad ha kanan na?” ");
INSERT INTO duo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ngem kinagi ni Jesus, “I kanan a ikabiyag ko i pinangtongpal ko ha pagayatan na Dios a nangpaangay ha nikan. Ket ubosan ko mina i patarabaho na ha nikan. Ta ide i kona ha kanan ko, a ikabiyag ko.” ");
INSERT INTO duo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ket intulos ni Jesus. “Kona ha ide i pagkakagi moy, a ‘Pagmula tam niyaen. Ket uppat a bulan i paguray tam. Sa kitam, magani dan,’ kom moy. Ngem niyaen, ipeta ko ha nikam. Entan moy idagendo a totolay a umaangay ha nikan. Ta kona a hidi man i paganiyan tam. Naluto dan hidi, ta dandani diyak tahodan. ");
INSERT INTO duo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ket maski nu awan moy hidi nemula, atoy pala i mappiya a tangdan moy a magani. Ta nu kona hito i paggani moy, urnongan moy i totolay a kona ha bunga na tarabaho moy. Ket makipaghen hidi ha Apo Dios ha magnanayon. Isu i gipu na a makipagragsak i magani a hidi ken Dios a nangimula. ");
INSERT INTO duo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Tahod ide a pagkakagi tam, a ‘Atoy i esa a magmula ken sabali i magani,’ kon tam. ");
INSERT INTO duo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ket niyaen, paangayan takam a magani ha awan moy nagtarabahowan. Ngem maski nu sabali i nagtarabaho ha paganiyan moy aye, hikam paman i makitangdan ha bunga na tarabaho na,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Niyaen, atoy i makpal a Samaritano a nanahod ha ni Jesus gipu ha kinagi na kaili di a babbey, a “Nakatandiyan na i ngamin a ginimigimet ko,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ket gipu ta kona hito, inumangay hidi ha ni Jesus, ket napigsa i pinagaged di a makipaghen hikuna ha nidi. Isu a naghen ni Jesus ha nidi ha duwa a pamalak. ");
INSERT INTO duo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ket kumakpal manon i nanahod ha nikuna gipu ha kakkagi na. ");
INSERT INTO duo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Inpeta di ha iday a babbey, “Manahod kami ha nikuna. Ket niyaen, awan la a gipu ha kakkagi mo, nu awan gipu ta hikami a mismo i nakateman ha pagitoldu na. Ket katandiyan mi a hikuna i mangisalakan ha totolay,” kon na Samaritano a hidi. ");
INSERT INTO duo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kobosan na duwa a pamalak ha nidi, linumapos kami ken ni Jesus, ket tinumulos kami hanggan ha probinsiya a Galileya. ");
INSERT INTO duo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Niyaen, ni Jesus a mismo i nagkagi idi ha, “Awan a mapadeyawan i esa a mahagpugto ha mismo a bayan na.” ");
INSERT INTO duo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ngem idi kaddemat ni Jesus ha probinsiya a Galileya, nagrespitar i umili a hidi ha nikuna. Ta idi nakipagpiyesta hidi ha Jerusalem, naenta di i ngamin a ginimet na ha piyesta. ");
INSERT INTO duo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Niyaen, inumangay hikuna manon ha ili a Kana, ha probinsiya a Galileya. Ide a lugar i pinagbalin na a arak i dinom. Niyaen, atoy hito i esa a opisiyal na gobyerno, ket nagsaket i annak na a lallaki. I naghenan na i ili a Kapernaum, ha madiyo. ");
INSERT INTO duo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Idi nabaheta na opisiyal a linumpos ni Jesus ha probinsiya a Judeya, a lumalakad hikuna ha probinsiya a Galileya, linumakad bila hikuna a umangay ha ni Jesus. Ket inaged na a umuseg mina ni Jesus a sumoli ha Kapernaum, penu pahusayan na i annak a dandani a matay. ");
INSERT INTO duo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ngem kinagi ni Jesus ha nikuna, “Apay a awanak moy tahodan nu awan moy metan i nakaddatan?” ");
INSERT INTO duo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ngem inagiaged unay na opisiyal. “Kagbiyan mo kami bi Apo. Umangay kitam dan, amangan nu matay i annak ko,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ket kinagi ni Jesus, “Nay. Sumoli ka dan. Magbiyag i annak mo,” kon na. Ket nanahod i opisiyal ha kinagi ni Jesus, ket sinumoli hikuna. ");
INSERT INTO duo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Niyaen, idi paglakad na a sumoli, sinalpak na kappal a tagabu na, a inbaheta di a hinumusay dan i annak na. ");
INSERT INTO duo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ket sinalodsod na nu anya i oras, idi nangrugi i kahusay na. Ket kinagi di, “Nakapon, ha ala una, idi ginumimak i ladu na.” ");
INSERT INTO duo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ket nanakam na opisiyal a iday i oras na pinangipeta ni Jesus, a “Magbiyag i annak mo.” Ket gipu ta kona hito, nanahod hikuna ha ni Jesus, pati ngamin a naghen ha bilay na. ");
INSERT INTO duo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iday i nekaduwa a nakaddatan a ginimet ni Jesus, idi nagsoli dan hikuna ha Galileya, a nagipu ha Judeya. ");
INSERT INTO duo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Idi kobosan na iday, atoy manon i esa a piyesta na Judyo a hidi, ket inumangay ni Jesus ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Niyaen, atoy ha Jerusalem i esa a ruwangan a paglakadan na karnero a hidi. Mabikan ito ha Templo na Dios. Ket atoy bila hay i esa a pagdegosan, a nagenan na Judjudyo ha “Betsata.” Ket atoy ha nibik na i lima a paglenduman. ");
INSERT INTO duo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Niyaen, ha lendum aye, inumabag i makpal a magsaket a kona ha mabulsak, ken napilay, ken hidi a awan a makalembok ha baggi di. Ket ururayan di i pinaglembok na dinom. ");
INSERT INTO duo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ta nu kappal, ket atoy i esa a anghel a umogsad a lumadap ha ide a pagdegosan, ket kimburan na i dinom. Ket humusay i magpalungo a gumutap ha dinom aye kobosan na pinnakakimbur na. Ket maagasan hikuna ha maski nu anya a saket na. ");
INSERT INTO duo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Niyaen, atoy bila hay i esa a lakay a nagsaket ha tallu pulo ket walu a tawen. ");
INSERT INTO duo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Idi naenta ni Jesus iday a lallaki, nakatandiyan na a naalay dan a nagsaket hikuna. Ket kinagi ni Jesus, “Botay, kayat mo a humusay?” ");
INSERT INTO duo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ket kinagi na magsaket, “Apo, awan ha agum ko a mangitugan ha nikan ha dinom, nu makimbur. Ket nu padasan ko a gumutap, magpalungo i sabali a hidi.” ");
INSERT INTO duo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ket kinagi ni Jesus, “Nay ka. Umikat ka. Alapan mo i abak mo, ket lumakad ka dan.” ");
INSERT INTO duo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ket dagus a nahusayan i lakay aye. Ket inalap na i abak na, ket linumakad hikuna. Niyaen, nagimet ito ha Sabado, i maneg a pamalak ha Judio a hidi. ");
INSERT INTO duo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ket idi naenta na hikuna na panglakayan a hidi na Judyo, kinagi di ha nikuna, “Sabado dan. Isu, maneg i pagtawed mo ha abak mo.” ");
INSERT INTO duo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ngem tinabbeg na lakay, “Inpeta na lallaki a nangpahusay ha nikan, a alapan ko mina i abak ko, ket lumakad,” kon na lakay. ");
INSERT INTO duo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ket sinalodsod di, “Heya i nangipeta a maglakad ka ken tawedan mo i abak mo aye?” ");
INSERT INTO duo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngem awan katandi na lakay nu heya i nangpahusay ha baggi na, ta linumakad ni Jesus. Ket makpal i totolay ha iday a lugar. ");
INSERT INTO duo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Niyaen, idi awan naalay, ket naenta ni Jesus i lakay aye ha disalad na Templo. Ket kinagi ni Jesus, “Entan mo agay. Nahusay ka dan. Niyaen, awan ka dan magliwat, ta mas marigat i magimet ha nikaw nokkan, nu tumulos ka a magliwat.” ");
INSERT INTO duo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sa, inumangay i lakay ha panglakayan a hidi na Judyo. Ket inpeta na a ni Jesus i nangpahusay ha baggi na. ");
INSERT INTO duo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ket ide i gipu na a sentiyan na panglakayan a hidi ni Jesus. Gipu ta nagpahusay ni Jesus, maski ha Sabado a maneg a pamalak. ");
INSERT INTO duo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ngem tinabbeg ni Jesus nidi, “Awan gumimak i Hama ko a maggimet ha mappiya, maski nu Sabado. Ket kona bila hito ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ide i gipu na a panggep di a patayan ni Jesus. Ta awan la a sinenti na i linteg na Sabado, nu awan bila a inpeta na a Dios a mismo i Hama na. Ket gipu ha ide, inkalan na i baggi na ha Dios. ");
INSERT INTO duo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ide i gipu na a tinabbeg ni Jesus i pinangpaliwat di. Kinagi na, “Tahod ide a ipeta ko ha nikam. Temanan moy bi. Awan ha magimet ko ha bukod ko a nakam, nu awan i maenta ko a gimigimetan Nama ko. Ta maski nu anya i gimetan na Amang Dios, iday bila i gimetan ko a Annak na. ");
INSERT INTO duo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ta Hama ko aye i magayat ha nikan a Annak na. Ket ipaenta na ha nikan i ngamin a gimigimetan na. Ket dakdakkal a milagro ngem dagende i ipaenta na ha nikan nokkan, penu masbew kam. ");
INSERT INTO duo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ta pabiyagan ko manon i minatay a hidi, ket ipapatay ko i biyag a magnanayon ha maski nu heya a kayat ko. Ta kakalan bila ito ha gimetan Nama ko. ");
INSERT INTO duo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Awan a manghukom i Amang Dios, nu awan a inatdinanak na ha turay a mangipeta nu heya i makibiyag ha nikuna ha magnanayon, ken heya i maparusaan ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kona hito a inatdinanak na ha turay na, penu mapadeyawan i Annak na Dios a kona ha pinangpadeyaw di ha Amang Dios a mismo. Ha totolay a awan mapadeyawan ha Annak na Dios, awan di bila padeyawan i Hama a nagpaangay ha Annak na. ");
INSERT INTO duo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tahod ide a ipeta ko ha nikam. Temanan moy. Ha maski nu heya a umuseg ha kakkagi ko, ken manahod ha Dios a nagpaangay ha nikan, mapadasan na i biyag a magnanayon. Ket awan hikuna maparusaan nokkan. Ta nalisiyan na i paghukom na Dios, ket naalap na i biyag na Dios a magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Ket tahod bila ide a ipeta ko ha nikam. Dumemat pala i tiyempo, ket maski niyaen, dinumemat dan, ket mateman na totolay i pagayag na Annak na Dios. Ket maski nu kona ha natay dan hidi, a nakasina dan hidi ha Dios, makabiyag manon hidi. Basta temananak di. ");
INSERT INTO duo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ta hikan bila i pakabiyagan na totolay, a kona ha Amang Dios a pakabiyagan na totolay. Ta kona hito i pinagbalin na Hama i Annak na. ");
INSERT INTO duo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ket inyatad na ha nikan i turay a manghukom, gipu ta hikan i Annak na Dios a Nagbalin a Tolay. ");
INSERT INTO duo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Awan moy mina pagsabbewan ide a kakkagi ko. Ta dumemat pala i tiyempo, ket makatiman ha pagayag ko i ngamin a minatay a hidi. ");
INSERT INTO duo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ket lumapos hidi ha labbang di. Ket ha nidi a naggimet ha mappiya, magbiyag manon hidi, a hen pala hidi ha Dios ha magnanayon. Ket ha nidi a naggimet ha madukas, magbiyag manon hidi a parusaan na hidi na Dios ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ipeta ko ha nikam, awan ha magimet ko a bukod ko a nakam. Ta manghukomak la a kona ha ipeta na Dios ha nikan. Ket isu i gipu na a nalinteg i pinanghukom ko. Ta bakkan a bukod ko a pagayatan i gimetan ko, nu awan i pagayatan Nama ko a nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Niyaen, siguro ipeta moy a mangikalinteganak ha baggi ko. Ket nu hikan la i mangikalintegan ha baggi ko, awan kam manahod. ");
INSERT INTO duo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngem atoy bila i sabali a mangpatahod megipu ha nikan. Ket hikuna i Hama ko a Dios. Ket katandi ko a mapagtalkan i pangpatahod na megipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ket atoy bila ni Juan a Mahagbinyag, a inangayan na nagsalodsod a hidi a binon moy. Ket mapagtalkan bila i kakkagi na megipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngem maski nu awan ko masapul i kakkagi na tolay, ipanakam ko ni Juan ha nikam, penu manahod kam ha nikan ken mesalakan kam mina. ");
INSERT INTO duo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ta mekalan ko ni Juan ha esa a silaw a naggangat ken nagdisyag ha nakam moy. Ket maski nu awan naalay, kinasor moy bila i pinagitoldu na ha nikam idi. ");
INSERT INTO duo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ngem atoy paman i dakdakkal a pangpatahod megipu ha nikan ngem ha kinagi ni Juan. Ta atoy man bi i milamilagro a ipagimet Nama ko ha nikan. Ket hidi man i mangpatahod megipu ha nikan, a mangipaenta a pinaangay na ak na Amang Dios. ");
INSERT INTO duo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pati Hama ko a nagpaangay ha nikan, hikuna a mismo i mangpatahod megipu ha nikan. Ngem awan moy mateman i timek na, ken awan moy maenta i rupa na. ");
INSERT INTO duo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Awan moy temanan i kakkagi na, ta awan moyak tahodan a pinaangay na. ");
INSERT INTO duo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Perpermi i pinagadal moy ha Libro na Dios, ta kagin moy a makapagsakop kam ha Dios ken makabiyag kam ha magnanayon, gipu ha pagadal moy aye. Ngem ide a Libro na Dios i magpatahod bila megipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ngem maski nu kona hito, madiyan moy a magpasakop ha nikan, a pakapadasan moy mina ha biyag na Dios a magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Bakkan a pagdeyaw na totolay i kayat ko. ");
INSERT INTO duo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngem bakkan ha nikam. Ket katandi takam a awan kam ha ayat a tahod ha Dios. ");
INSERT INTO duo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Pinaangay na ak Nama ko, a magitoldu ha nikam megipu ha nikuna. Ngem awanak moy tahodan. Nu atoy i sabali a umangay gipu ha bukod na a nakam, hikuna i tahodan moy. ");
INSERT INTO duo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kayat moy i pammadeyaw na agagum moy, ngem awan moy kayat i pammadeyaw a maggipu ha Dios a isesa. Isu i gipu na a awanak moy tahodan. ");
INSERT INTO duo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Niyaen, kagin moy wade a hikan i mangpaliwat ha nikam ha Amang Dios. Ngem bakkan a hikan i mangpaliwat, nu awan i sursurat ni Moyses a namnamaan moy a pakesalakanan moy mina. ");
INSERT INTO duo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ta nu tahod a umuseg kam ha insurat ni Moyses, tinahodak moy mina. Ta nagsurat ni Moyses megipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngem katandi ko a nu awan moy tinahod i insurat na, sigurado a awan moy bila tahodan i kakkagi ko,” kon ni Jesus. Ide i inpeta ni Jesus ha panglakayan a hidi na Judyo. ");
INSERT INTO duo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Idi kobosan na ide, inumarabes ni Jesus ha Diget a Galileya (onu “Diget na Tiberiyas” i sangay na). ");
INSERT INTO duo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ket atoy bila i makpal a tinumagubet ha nikuna, gipu ta naenta di i milamilagro na, idi pinahusay na i nagsaket a hidi. ");
INSERT INTO duo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ket tinumagsat ni Jesus ha esa a pukal. Ket nagetnod hikuna, pati hikami a tinolduwan na. ");
INSERT INTO duo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Idi tiyempo a ito, mabikan dan i Piyesta na Judjudyo a nagenan di ha “Pinagtaleban na Anghel a Magpatay.” ");
INSERT INTO duo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ket inbatad ni Jesus, ket naenta na i makpal a tumatagubet ha nikuna. Ket kinagi na ha ni Pelipe, “Hadya wade i pagalapan tam ha kanan a ipakan tam ha dagenday?” ");
INSERT INTO duo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Kinagi ni Jesus iday a pangpadas na ha ni Pelipe, nu anya i nakam na. Ta ninakam dan ni Jesus i gimetan na.) ");
INSERT INTO duo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ket tinabbeg ni Pelipe, “Agay! Maski nu hangan a gasut a paggatang tam ha kanan, awan mekusto. Maski nu balballik la i maalap na kada esa,” kon ni Pelipe. ");
INSERT INTO duo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ket atoy bila hay ni Andres, a wadi ni Simon Pedro. ");
INSERT INTO duo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Ket kinagi na, “Atoy ha ihe i esa a olitaw a kekkanan. Ngem ballik la, ta lima a pidaso i tinapay na ken duwa la i pindang na. Agay, panya a pakanan tam i kakpal na tolay ha kanan a kona he,” kon ni Andres. ");
INSERT INTO duo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ket inpeta ni Jesus ha nikami, “Pagetnodan moy hidi.” Ta malawa i karuotan ha iday a lugar. Isu, nagetnod i ngamin a tolay. Ket naglima a ribu i lallaki a hidi (maski awan nebilang i babbey ken annak a hidi). ");
INSERT INTO duo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ket inalap ni Jesus i tinapay na olitaw heya. Ket nagyaman hikuna ha Dios. Sa na, inpebunong i tinapay ha ngamin a nakaetnod. Ket kona bila hito i ginimet na ha pindang. Ket nagkan hidi hanggan nabbiyag hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Idi nabbiyag hidi ngamin, kinagi ni Jesus ha nikami a tinolduwan na, “Puhonan moy i ngamin a kanan a buhay tam, penu awan tam itogbak.” ");
INSERT INTO duo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ket pinuhon mi i ngamin a buhay mi. Ket naputat i esa pulo ket duwa a basket ha iday a buhay mi, a naggipu ha lima a tinapay a awan mi nekabbus. ");
INSERT INTO duo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Idi naenta na kakpalan i milagro aye a ginimet ni Jesus, kinagi di, “Awan ha duwaduwa a hikuna i esa a pinaangay na Dios a inpugto ni Moyses. Ket hikuna i mangisalakan ha nikitam.” ");
INSERT INTO duo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ngem ha ni Jesus, idi nakatandiyan na a kayat di hikuna pilitan a maghari, linakadan na hidi. Ket inumangay hikuna a isesa ha parabin. ");
INSERT INTO duo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Niyaen, idi apon dan, dinumitaw kami a tinolduwan na ha baybay. ");
INSERT INTO duo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ket sinumakay kami ha abang, a umahabes ha ili a Kapernaum. Kallap dan, ket awan pala dumemat ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Naglugan kami pala, ket dinumakkal i diget, ta napigsa i paras. ");
INSERT INTO duo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Idi nakapaggaud kami ha lima onu annam a kilometro, agay, naenta mi ni Jesus a maglakad ha dibbew na diget. Idi bumabikan hikuna, ket nanteng kami unay! ");
INSERT INTO duo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ngem kinagi ni Jesus, “Awan kam manteng. Atoyak dan.” ");
INSERT INTO duo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ket siayayat kami a nangilugan ha nikuna ha abang. Ket sigida kami a nakaabot ha pagpunduwan mi a lugar. ");
INSERT INTO duo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Idi kaugman na, atoy pala i makpal a nagwarak ha dibelew, ha iday a lugar a nangpakanan ni Jesus ha nidi. Ket niyaen, nagururay pala hidi ha ni Jesus. Ta katandi di a isiisesa la i abang a nakapundu ha ihay. Ket katandi di bila a awan nakilugan ni Jesus ha nikami a tinolduwan na ha abang heya. Ta hikami la i nagsakay ha iday a abang. Ngem atoy bila i sabasabali a abang a dinumemat, a naggipu ha Tiberiyas. Ket pinumundu hidi ha bikan na dagenday a totolay. ");
INSERT INTO duo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Isu, idi nakatandiyan di a awan ni Jesus, ket awan kami bila a tinolduwan na, nagsakay bila hidi, a umahabes ha Kapernaum, penu mageriyok hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Idi naeriyokan di ni Jesus ha dibelew, kinagi di, “Maestro, hangan kaddemat mo ha ihe?” ");
INSERT INTO duo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kinagi ni Jesus, “Tahod ide a ipeta ko ha nikam. Temanan moy bi. Mageriyok kam ha nikan gipu ha iday a kanan a inpakan ko ha nikam, ket nabbiyag kam. Ngem ipeta ko ha nikam a ");
INSERT INTO duo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","bakkan mina a kanan a malungsot i eriyokan moy, nu awan a kanan a ikabiyag moy ha magnanayon i eriyokan moy mina. Niyaen, hikan i mangiyatad ha kanan a kona he, gipu ta hikan i Annak na Dios a Nagbalin a Tolay. Ket meyatad ko i biyag a magnanayon, ta inatdinan na ak Nama ko ha turay ko.” ");
INSERT INTO duo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Isu, sinalodsod di ha nikuna, “Anya mina i gimetan mi, penu matalak i Dios ha nikami?” ");
INSERT INTO duo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ket kinagi ni Jesus, “Ide i kayat na Dios a gimetan moy, ket manahod kamon ha nikan, ta pinaangay na ak ha nikam.” ");
INSERT INTO duo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Isu a sinalodsod di, “Anya i tiplad a gimetan mo a pangpatahod mo ha nikami? Ipaenta mo i kaddat mo, penu manahod kami ha nikaw. ");
INSERT INTO duo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ha ni Moyses, nagpakan hikuna ha minappo tam ha iday a mana a kakkanan di, idi naghen hidi ha kasaw a lugar. Ta nesurat ha Libro na Dios, ‘Inyatad na ha nidi i kanan a naggipu ha langit a kanan di.’” ");
INSERT INTO duo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ket kinagi ni Jesus, “Tahod ide a ipeta ko. Temanan moy bi. Bakkan a ni Moyses, nu awan i Hama ko i nangiyatad ha minappo moy ha kanan a nagipu ha langit. Ket niyaen, mangiyatad paman hikuna ha esa a Kanan a tahod a ikabiyag na totolay. ");
INSERT INTO duo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ta ide i kanan a iyatad na Dios, ket naggipu ito ha langit penu iyatad ko ha totolay i biyag na Dios a magnanayon.” ");
INSERT INTO duo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ket kinagi di, “Apo, atdinan mo kami bi ha ide a kanan ha kanayon, penu makabiyag kami.” ");
INSERT INTO duo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ket kinagi ni Jesus, “Hikan i Kanan a ikabiyag na totolay ha magnanayon. Ket ha maski nu heya a magpasakop ha nikan, awan manon hikuna magiyalap. Ket basta manahod hikuna ha nikan, awan hikuna mauwaw. ");
INSERT INTO duo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngem niyaen, ipenduwa ko ha nikam i kinagi ko, a maski nu netanak moy, awan kam manahod ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ngem atoy paman i totolay a italak na Dios ha nikan. Ket ha maski nu heya a italak na Hama ko ha nikan, magpasakop hikuna ha nikan. Ket maski nu heya a magpasakop ha nikan, awan ko tallekodan. ");
INSERT INTO duo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ta bakkan a bukod ko a nakam i gimetan ko, nu awan i pagayatan na Dios a nagpaangay ha nikan. Ket ide i gipu na a dinumematak a nagipu ha langit. ");
INSERT INTO duo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Niyaen, ide i pagayatan na Dios, a awan ko mapukaw i maski esa a intalak na ha nikan, nu awan ko hidi pabiyagan manon, ha dilokod a pamalak. ");
INSERT INTO duo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ta ide i pagayatan Nama ko, a magbiyag ha magnanayon i ngamin a makatandi ken manahod ha Annak na. Ket pabiyagan ko hidi nokkan, ha dilokod a pamalak,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Niyaen, idi nateman na ito na Judyo a hidi, naglimalimad hidi ha ni Jesus. Gipu ta kinagi na a hikuna i Kanan a nagipu ha langit. ");
INSERT INTO duo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ket kinagi di, “Agay, ide dan ni Jesus, i annak ni Jose. Ket katandi tam i hama ken hena na. Isu, apay a kagi na a naggipu hikuna ha langit?” ");
INSERT INTO duo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ket tinabbeg ni Jesus, “Awan kam mina maglimalimad. ");
INSERT INTO duo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ta ipeta ko ha nikam a awan ha makapasakop ha nikan, nu awan na hikuna iturong na Hama ko. Ket ha maski nu heya a makapasakop, pabiyagan ko hikuna ha dilokod a pamalak. ");
INSERT INTO duo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ta kona hito i nesurat na mahagpugto a hidi. Insurat di, ‘Tolduwan na Dios i ngamin a tolay na.’ Niyaen, ha maski nu heya a makatandi ken umusoseg ha pagitoldu Nama ko a Dios, manahod hikuna ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","(Bakkan a kayat ko kagiyan a atoy i makaenta ha Nama ko. Awan. Ta hikan la i naggipu ha Amang Dios ken nakaenta ha nikuna.) ");
INSERT INTO duo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Tahod ide a ipeta ko ha nikam. Temanan moy bi. Ha maski nu heya a manahod ha nikan, atoy ha nikuna i biyag na Dios a magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Oni! Hikan i Kanan a ikabiyag na totolay ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ket sabali ito ha iday a mana a kinan na minappo moy, idi naglakalakad hidi ha amamugod. Ta maski kinan di iday, natay dalla hidi. ");
INSERT INTO duo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngem awan a matay i maski nu heya a magkan ha Kanan a Naggipu ha Langit. ");
INSERT INTO duo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Niyaen, hikan i sibibiyag a Kanan a Naggipu ha Langit. Isu, ha maski nu heya a magkan ha ide a Kanan, makabiyag hikuna ha Dios ha magnanayon. I Kanan a iyatad ko, i baggi ko a mismo. Ket iyatad ko ito, penu makabiyag i ngamin a tolay.” ");
INSERT INTO duo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Idi nateman na ito na Judyo a hidi, nagtinabbeg hidi. “Panyan na agay! Meyatad na dod i pilas na a kanan tam?” kon di. ");
INSERT INTO duo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Isu, kinagi ni Jesus, “Tahod ide a ipeta ko ha nikam. Temanan moy bi. Nu awan moy kanan i pilas, ken inoman i digi na Annak na Dios a Nagbalin a Tolay, awan ha biyag ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngem ha maski nu heya a magkan ha pilas ko, ken uminom ha digi ko, atoy ha nikuna i biyag na Dios a magnanayon. Ket pabiyagan ko hikuna nokkan, ha dilokod a pamalak. ");
INSERT INTO duo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","I pilas ko aye i tahod a kanan a ikabiyag na totolay. Ket i digi ko i tahod a inoman a ikabiyag na totolay. ");
INSERT INTO duo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ket maski nu heya a magkan ha pilas ko ken uminom ha digi ko, maghen hikuna ha nikan. Ket maghenak bila ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","I Hama ko a nagpaangay ha nikan, hikuna i ikabiyag ko ha biyag a magnanayon. Ket kona bila ha nikuna, hikan i ikabiyag na totolay ha biyag a magnanayon. Isu, ha maski nu heya a magkan ha baggi ko, iyatad ko ha nikuna i biyag na Dios a magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ta hikan i Kanan a Naggipu ha Langit, ket bakkan a kona ha kanan a kinan na minappo moy idi. Ta natay dalla hidi. Ngem ha maski nu heya a magkan ha baggi ko, magbiyag hikuna ha Dios ha magnanayon.” ");
INSERT INTO duo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ide i pinagitoldu ni Jesus idi, ha kapilya na Judyo a hidi, ha ili a Kapernaum. ");
INSERT INTO duo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Idi nateman di ito, atoy i makpal a tinolduwan na a nagmadi ha kakkagi na. Kinagi di, “Marigat i kakkagi na aye. Awan ha makatandi ha pagitoldu na a kona hay.” ");
INSERT INTO duo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ngem katandi ni Jesus a linimad di i pinagitoldu na. Isu, kinagi na ha nidi, “Anya? Maupay kam wade ha pagitoldu ko? ");
INSERT INTO duo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Anya dod nu maenta moyak a umontok, a sumoli ak ha langit a naghenan ko ha palungo? ");
INSERT INTO duo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Makatandiyan moy mina ide, a bakkan i pinnakabalin na tolay i ikabiyag na, nu awan i Espiritu na Dios. Ket idagende a kakkagi ko i kakkagi na Espiritu na Dios, ken ikabiyag na totolay ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ngem atoy ha nikam i kappal a awan a manahod,” kon ni Jesus. (Ta maski idi palungo, ket katandi ni Jesus nu heya i manahod ken nu heya i mangliput ha nikuna.) ");
INSERT INTO duo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ket kinagi na pala, “Ide i gipu na a inpeta ko ha nikam a awan ha makapasakop ha nikan, nu awan a pagbalinan na hikuna Nama ko.” ");
INSERT INTO duo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ket gipu ha ide, linakadan na hikuna na makpal a tinolduwan na. Ket awan hidi inumuseg ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ket gipu ta kona hito, kinagi na ha nikami a esa pulo ket duwa a tinolduwan na, “Ay, hikam. Kayat moy bila a sumina?” ");
INSERT INTO duo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ket tinabbeg ni Simon Pedro, “Apo, hadya mina i angayan mi? Awan ha sabali a maketoldu megipu ha biyag a magnanayon, nu awan la a hikaw. ");
INSERT INTO duo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ket niyaen, manahod kami ha nikaw. Ta katandi mi dan a hikaw la i isesa a Annak na Dios a pinaangay na penu maghari.” ");
INSERT INTO duo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ket kinagi ni Jesus, “Oni. Ket hikan i nangpili ha nikam a esa pulo ket duwa. Ngem katandi ko bila a atoy ha nikam i esa a keddemonyo,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ni Judas a annak ni Simon Iskaryote i kinagi ni Jesus idi. Ta hikuna i nangliput ha ni Jesus, maski nesakop hikuna ha nikami a esa pulo ket duwa. ");
INSERT INTO duo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kobosan na ide, naglakalakad ni Jesus ha probinsiya a Galileya. Madiyan na a lumakad ha probinsiya a Judeya, ta gayakan di a papatayan hikuna na Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Niyaen, dandani dan i piyesta ha Jerusalem a nagenan di ha “Piyesta na Tolda.” ");
INSERT INTO duo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ket kinagi na wadi na a hidi, “Nay ka dan. Lumapos ka mina, a lumakad ka ha Judeya, penu maenta na tolduwan mo a hidi i nakaddatan a gimigimetan mo. ");
INSERT INTO duo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Siyempre, nu kayat mo a mangipakatandi ha baggi mo, awan ka mina magpamen ha gimigimetan mo he. Nu tahod a kekkaddat ka, ipaenta mo mina i paggimi-gimet mo ha ngamin a tolay,” kon na wadi a hidi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ta maski ha wadi na a hidi, awan hidi nanahod ha nikuna. Isu a kinagi di i kona he. ");
INSERT INTO duo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ngem kinagi ni Jesus ha nidi, “Awan pala dumemat i tiyempo ko. Ngem bakkan ha nikam. Ta kusto dan ha nikam i maski nu anya a tiyempo. ");
INSERT INTO duo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Awan man ha magingal ha nikam. Ngem englan diyak perpermi, gipu ta inpeta ko a madukas i gimigimet di. ");
INSERT INTO duo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Isu, hikam mina i makipagpiyesta. Awanak pala a umangay a makipiyesta, ta awan pala i oras a pagpakatandi ha baggi ko.” ");
INSERT INTO duo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ide i nepeta ni Jesus ha wadi na a hidi. Ket nagwarak pala hikuna ha Galileya. ");
INSERT INTO duo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Niyaen, idi nakalakad dan i wadi na a hidi a makipiyesta, inumangay bila ni Jesus. Ngem awan hikuna inumuseg ha kakpalan a hidi. Ta kayat na a ipamen i baggi na. ");
INSERT INTO duo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ket ha iday a piyesta, nagerieriyok ha nikuna i panglakayan a hidi na Judyo. Ket nagsalosalodsod hidi, “Hadya dawan hikuna?” ");
INSERT INTO duo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ket makpal bila i kinakagi na tolay a hidi megipu ha ni Jesus. Ta atoy i kappal a nagkagi, “Mappiya hikuna.” Ket atoy bila i kappal a nagkagi, “Awan hikuna mappiya, ta allilawan na i kakalan tam a tolay,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ngem awan ha nangikalintegan ha ni Jesus ha saguppang na kaili di, gipu ta nanteng hidi ha panglakayan a hidi na Judyo. ");
INSERT INTO duo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Niyaen, idi lubuk na piyesta, inumangay ni Jesus ha Templo, ket nagitoldu hikuna. ");
INSERT INTO duo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ket nalaktat i Judyo a hidi. Ket kinagi di, “Panya a malaing ide a lallaki, maski awan hikuna nagadal a pulos?” ");
INSERT INTO duo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ket tinabbeg ni Jesus, “Bakkan a bukbukod ko a nakam i nagipuwan na pagitoldu ko, nu awan i Dios. Ta hikuna i nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ket ha maski nu heya a masor a makagimet ha pagayatan na Dios, mabalin a makatandiyan na nu Dios i nagipuwan na pagitoldu ko, onu magitolduwak ha bukod ko a turay. ");
INSERT INTO duo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ta nu atoy i magitoldu ha bukod na a turay, kayat na la i pakedeyawan na baggi na. Ngem nu atoy i magitoldu penu mapadeyawan i Dios a nagpaangay ha nikuna, mapagtalkan i pagitoldu na, ket awan hikuna magsileng. ");
INSERT INTO duo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Niyaen, atoy ha nikam i linteg ni Moyses. Ket maski nu awan kam makatongpal ha ide a linteg, kayat moy a magpaliwat ha nikan gipu ha linteg na aye. Ket niyaen, kayat moyak bila a papatayan.” ");
INSERT INTO duo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tinabbeg na tolay a hidi, “Nagawag ka, nu kona hay i nakam mo. Heya i masor a magpatay ha nikaw?” ");
INSERT INTO duo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ket kinagi ni Jesus, “Atoy i ginimet ko idi esa a Sabado, ket pinahusay ko i esa a nagsaket. Ket nalaktat kam. ");
INSERT INTO duo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ngem maski ha nikam, atoy bila i gimetan moy ha Sabado, ket maneg a pamalak. Ta atoy i inbon ni Moyses, ket pakakugit moy i annak a hidi, maski nu Sabado. (Maski bakkan a ni Moyses i nangrugi ha ide a ugali tam, nu awan i minappo tam a hidi.) ");
INSERT INTO duo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Isu, ipalobus moy a mapakugit i ballik a butu na annak, maski nu Sabado, penu awan maliwatan i linteg ni Moyses. Ngem magingal kam ha nikan gipu ta pinahusay ko i entero a baggi na lallaki ha Sabado. ");
INSERT INTO duo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Awan kam mina mangpaliwat gipu la ha maenta moy, nu awan a nakaman moy i malinteg ken tahod,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ket kinagi na kappal a Judyo a taga-Jerusalem, “Ide wade i lallaki a kayat di a patayan. ");
INSERT INTO duo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ngem niyaen, atoy hikuna, ket magkagi ha saguppang di. Ket awan ha mepeta di a pagsenti ha nikuna. Anya wade i nakaman na panglakayan tam a hidi? Nakaman di wade a ni Jesus i Cristu a maghari mina ha ngamin a tolay? ");
INSERT INTO duo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ngem awan ito a mabalin, ta katandiyan tam i naggipuwan na. Ket nu dumemat i tahod a Cristu, awan kan ha makatandi nu hadya i paggipuwan na, kon na kan.” Ide i kinagi na Judyo a hidi a taga-Jerusalem. ");
INSERT INTO duo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Isu, gipu ha kinagi di aye, indulaw ni Jesus ha napigsa idi nagitoldu hikuna ha Templo, “Kagin moy a katandiyanak moy, ken hadya i naggipuwan ko, kon moy. Ngem awan moy makatandiyan. Ta awanak inumangay gipu ha bukod ko a nakam, nu awan gipu ha Dios a nagpaangay ha nikan. Ket hikuna i tahod a nagipuwan ko. Ngem awan moy hikuna katandi. ");
INSERT INTO duo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Hikan i makatandi ha nikuna, ta naggipuwak ha nikuna, ket hikuna i nagpaangay ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Niyaen, gipu ha ide a kinagi ni Jesus, kayat di hikuna a dakapan. Ngem awan ha nakadakap ha nikuna, ta awan pala dinumemat i tiyempo na. ");
INSERT INTO duo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ket makpal i nanahod a hidi ha nikuna. Kinagi di, “Hikuna wade i tahod a Cristu. Ta awan ha sabali a makagimet ha nakaddatan a ginemigimetan na, nu awan la i Cristu,” kon na manahod a hidi. ");
INSERT INTO duo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Niyaen, atoy bila hay i Pariseyo a hidi. Idi nateman di i kakpalan a nagkagi ha kona hito, nagisesa hidi ken matangkay a papadi. Ket binon di i guwardya a hidi na Templo a mangdakap ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Isu i gipu na a kinagi ni Jesus ha denday a kakpalan, “Maghenak pala ha nikam ha ballik a tiyempo. Kobosan na, magsoliyak ha nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ha tiyempo a ito, mageriyok kam ha nikan, ngem awanak moy maeriyokan. Ta awan kam makaangay ha angayan ko.” ");
INSERT INTO duo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nagkinagi dod i panglakayan a hidi na Judyo, “Hadya wade i angayan na, a awan tam hikuna maeriyokan? Siguro umangay hikuna ha kahenan na Judjudyo, ha madiyo a ili na Griego, penu tolduwan na i bakkan a hidi a Judyo. ");
INSERT INTO duo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Anya i kayat na a kagiyan a eriyokan tam hikuna, ngem awan tam hikuna maeriyokan, kon na kan? Ket awan kitam makaangay ha angayan na, kon na kan.” Ide i nanakaman na panglakayan a hidi na Judyo. ");
INSERT INTO duo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Niyaen, ha dilokod a pamalak na piyesta, iday i kadakkalan a pamalak na. Ket tinumaknag ni Jesus, ket indulaw na ha napigsa, “I maski nu heya a mauwaw, umangay mina hikuna ha nikan, penu uminom. ");
INSERT INTO duo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta ide i nesurat ha Libro na Dios megipu ha manahod ha nikan, a ‘Atoy ha disalad na baggi na i dadakkal a habhabwayan a ikabiyag na,’ kon na Libro na Dios.” ");
INSERT INTO duo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Niyaen, kinagi na ito ni Jesus megipu ha Espiritu na Dios a umasak ha manahod a hidi ha nikuna. Ngem idi tiyempo a kinagi na ito, awan pala umasak i Espiritu na Dios, ta awan pala sinumoli ni Jesus ha kainamakanan a pagturayan na ha langit.) ");
INSERT INTO duo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Niyaen, idi nateman na kakpalan i kinagi aye ni Jesus, atoy i kappal a nagkagi ha, “Tahod a hikuna i napugtowan idi, ken tahokan tam,” kon na kappal. ");
INSERT INTO duo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ket atoy bila i kappal a nagkagi ha, “Hikuna i Cristu a maghari mina ha ngamin a tolay.” Ngem atoy pala i kappal a nagkagi, “Bakkan kan a Galileya i paggipuwan na Cristu! ");
INSERT INTO duo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ta nesurat ha Libro na Dios a magipu i Cristu ha pamilya ni Dabid. Ket meenak kan i Cristu ha ili a Betlehem. Ta iday i ili ni Dabid, kon na kan ha Libro na Dios.” ");
INSERT INTO duo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ket gipu ta kona hito i kinagi na tolay a hidi, sabasabali malla i pagnakanakam di. ");
INSERT INTO duo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ket kayat na kappal a magpadakap ha ni Jesus, ngem awan ha maski esa a nakadakap ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Niyaen, sinumoli i guwardya a hidi na Templo. Ket sinalodsod na matangkay a papadi ken Pariseyo a hidi, “Apay awan moy hikuna dinakap?” ");
INSERT INTO duo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ket tinabbeg na guwardya a hidi, “Masaniki kami. Ta awan ha maketoldu a kona ha iday a lallaki.” ");
INSERT INTO duo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tinabbeg dod na Pariseyo a hidi, “Agay, maski hikam! Naallilaw kam bila! ");
INSERT INTO duo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ngem entan moy kami a Pariseyo ken panglakayan moy a hidi. Awan kami manahod ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ngem ha denday a madagel a kakpalan, merurumen hidi nokkan ha impyerno, ta awan di makatandiyan i Linteg ni Moyses,” kon na Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ngem atoy bila hay ni Nikodemo, i esa a agum di a Pariseyo. Hikuna i inumangay a nakiuhon ha ni Jesus, idi esa a kallap. ");
INSERT INTO duo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ket kinagi na, “Ayun ha linteg tam, awan tam mabalin a hukoman i esa a tolay, nu awan a palungo a mangikalintegan hikuna ha baggi na. Ta masapul kan a makatandiyan tam i liwat na,” kon ni Nikodemo. ");
INSERT INTO duo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ket tinabbeg na Pariseyo a hidi, “Anya wade? Hikaw dod i agum na a taga-Galileya? Nay ka dan. Eriyokan mo ha Libro na Dios, ket maenta mo a awan ha maski esa a mahagpugto a maggipu ha Galileya. Pulos!” kon na Pariseyo a hidi ha ni Nikodemo. ");
INSERT INTO duo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ket sinumoli hidi ha bilabilay di. ");
INSERT INTO duo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Sinumoli ni Jesus ha Amugod a Olibo, a nagkilapan na. ");
INSERT INTO duo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kaugman na, idi nasapa, inumangay manon hikuna ha Templo. Ket pinumisan i makpal ha nikuna. Ket nagetnod ni Jesus a nagitoldu ha nidi. ");
INSERT INTO duo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Idi magitoldu hikuna, dinumemat i maestro na Linteg ken Pariseyo a hidi. Ket inyangay di i esa a babbey a nadakap di a nangilallaki. Ket insaguppang di hikuna. ");
INSERT INTO duo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kinagi di ha ni Jesus, “Maestro, nadakap ide a babbey a nangilallaki. ");
INSERT INTO duo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Niyaen, ha Linteg tam, inbon ni Moyses a mapapatay mina i kona he, a mabisag mina ha pogedu, hanggan matay. Anya ha nikaw? Anya i mepeta mo megipu ha babbey aye?” ");
INSERT INTO duo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ide i salodsod di ha ni Jesus a pangsurubar di, a baka makaliwat hikuna ha tabbeg na. Ta kayat di i pangpaliwat ha nikuna. Ngem awan nagkagi ni Jesus. Imbes na, nagplintukad hikuna, a nagsurat ha tapok ha gihay na. ");
INSERT INTO duo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Idi pinilit di hikuna ha salodsod di, tinumaknag hikuna, ket kinagi na, “I maski nu heya ha nikam a awan ha liwat, hikuna mina i magpalungo a magbisag ha ide a babbey.” ");
INSERT INTO duo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ket nagpalintukad manon ni Jesus, a nagsurat manon ha tapok ha gihay na. ");
INSERT INTO duo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Idi nateman di i tabbeg na aye, linumakad hidi. Nasenot hidi a linumakad. I kalakayan di i nagpalungo a lumakad, hanggan linumakad hidi ngamin. I nagwarak la ni Jesus ken iday a babbey a tumataknag ha saguppang na. ");
INSERT INTO duo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ket tinumaknag ni Jesus, ket sinalodsod na, “Wadi ko, hadya hidi niyaen? Awan ha nawarak a manghukom ha nikaw?” ");
INSERT INTO duo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ket tinabbeg na babbey, “Awan, Apo.” Ket kinagi ni Jesus, “Maski hikan. Awan taka parusaan. Lumakad ka dan. Ket awan ka manon magliwat.” ");
INSERT INTO duo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Niyaen, nagitoldu manon ni Jesus ha makpal a tolay. Ket kinagi na, “Hikan i Silaw a magdisyag ha nakam na ngamin a tolay. Ket maski nu heya a umunod ha nikan, awan hikuna madihaman, ta atoy ha nikuna i Silaw a ikabiyag na ha magnanayon.” ");
INSERT INTO duo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ket kinagi na Pariseyo a hidi, “Awan mapagtalkan i kakkagi mo, ta magisesa ka la a magpatahod ha mismo a baggi mo.” ");
INSERT INTO duo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ket tinabbeg ni Jesus, “Maski nu hikan i mangpatahod ha baggi ko, tahod pala i ipeta ko. Ta katandi ko i naggipuwan ko, ken angayan ko nokkan. Ngem bakkan ha nikam, ta awan moy katandi i naggipuwan ko ken angayan ko. ");
INSERT INTO duo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Hikam i manghukom gipu ha pagnakanakam na tolay. Ngem bakkan ha nikan, ta awan ha hukoman ko a kona hay. ");
INSERT INTO duo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ngem maski nu manghukomak, tahod i panghukom ko. Ta bakkan a hikan la i manghukom, nu awan ko agum i Hama ko a nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Maski ha linteg moy, nesurat dan a nu atoy i duwa a magpatahod, ket nagisesa i kinagi di, mebilang a tahod i kagi di. ");
INSERT INTO duo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ket niyaen, atoy i duwa a magpatahod ha nikan. Ta hikan i esa a magpatahod, ket Hama ko bila i magpatahod,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ket kinagi na Pariseyo a hidi, “Hadya i hama mo?” Ket tinabbeg ni Jesus, “Awanak moy katandi. Ket awan moy bila katandi i Hama ko. Ta nu katandi ak moy mina, katandi moy bila i Hama ko.” ");
INSERT INTO duo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ide i kinagi ni Jesus, idi nagitoldu hikuna ha mabikan na pagdattonan ha limos, ha paraangan na Templo. Ngem maski nu makpal i nakateman a hidi, awan ha nangdakap ha nikuna. Ta awan pala dumemat i oras a katay na. ");
INSERT INTO duo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Idi nagitoldu manon ni Jesus, kinagi na manon, “Dandani dan i oras a lakadan ta kam. Ket eriyokanak moy nokkan, ngem awanak moy maeriyokan. Ta matay kam, ket awan pala napakawan i liwaliwat moy. Isu i gipu na a awan kam makauseg ha angayan ko.” ");
INSERT INTO duo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Niyaen, gipu ta kona hito i kinagi ni Jesus, nagsinalodsod i Happo a hidi na Judyo, “Anya wade? Magmunas wade hikuna? Ta kinagi na a awan kitam makaangay ha angayan na.” ");
INSERT INTO duo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ket kinagi ni Jesus, “Hikam i taga-lutak. Ket i biyag moy aye, ha lutak aye, i katandiyan moy. Ngem bakkan ha nikan. Ta hikan i taga-langit. Ket sabali i katandi ko. ");
INSERT INTO duo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Isu i gipu na a inpeta ko a matay kam, ket awan pala napakawan i liwaliwat moy. Oni, maparusaan kam nokkan, nu awan moy tahodan a hikan i pinaangay na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ket kinagi di, “Apay? Heya ka dod ha kakkagi mo?” Ket tinabbeg ni Jesus, “Inpakatandi ko dan ha nikam, maski idi karugi na pagitoldu ko hanggan niyaen. ");
INSERT INTO duo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ket niyaen, makpal bila i mepeta ko megipu ha nikam. Ket atoy i makpal a panghukoman ko ha nikam. Ngem ha ngamin a pagitoldu ko, ipakatandi ko la i kakkagi na nagpaangay ha nikan. Ket tahod i kakkagi na aye,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ngem awan di nakatandiyan a megipu ha Hama na a Dios i kinagi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Isu, inpeta ni Jesus ha nidi, “Nokkan nu mebayogak ha kayo, ha matangkay, makatandiyan moy a hikan i pinaangay na Dios. Ket makatandiyan moy a awan ha gimetan ko gipu ha bukod ko a nakam, nu awan a ipakatandi ko i pagitoldu na Hama ko ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ket maghen pala ha nikan i Hama ko aye a nagpaangay ha nikan. Awan na ak pabiyanan. Ta kanayon a gimetan ko i pagayatan na,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Idi nagitoldu ni Jesus a kona hito, atoy i makpal a nanahod ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Isu, kinagi ni Jesus ha Judyo a hidi a nanahod ha nikuna, “Nu makatulos kam a umuseg ha kakkagi ko, tahod a hikam i tinolduwan ko. ");
INSERT INTO duo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ket makatandiyan moy i tahod, ket wayawayaan na kam na tahod aye ha pakatagabuwan moy.” ");
INSERT INTO duo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kinagi na Judyo a hidi, “Apapo kami ni Abraham, ket pulos, awan kami patagabu ha maski nu heya a tolay. Anya dod i kayat mo kagiyan a mawayawayaan kami nokkan?” ");
INSERT INTO duo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tinabbeg ni Jesus, “Tahod ide a ipeta ko ha nikam. Temanan moy bi. Ha maski nu heya a magliwat, hikuna i tagabu na liwat. ");
INSERT INTO duo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","I pangarigan ko i esa a tagabu ken happo na. Niyaen, awan mebilang i tagabu ha pamilya na happo na. Isu, awan hikuna makatulos a makipaghen ha bilay na happo na ha kanayon. Ngem bakkan ha annak na makinbilay. Ta kekkalintegan hikuna a makipaghen ha hama na ha kanayon. ");
INSERT INTO duo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Niyaen, gipu ta kona hito i kalintegan na Annak na Happo moy a Dios, mabalin bi a pawayawayaan na kam ha pakatagabuwan moy. Ket mebilang kam bila ha pamilya na Apo Dios. Isu, basta i Annak na Apo i magpawayawaya ha nikam, awan kam matagabu ha liwaliwat moy. ");
INSERT INTO duo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Niyaen, katandi ko a hikam i apapo ni Abraham. Ngem maski nu ni Abraham i minappo moy, kayat moyak a patayan, ta madiyan moy i pagitoldu ko. ");
INSERT INTO duo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ta mangipeta ak megipu ha bagbagay a naenta ko ha Hama ko. Ngem bakkan i gimetan moy. Ta gimetan moy i bagbagay a nateman moy ha hama moy.” ");
INSERT INTO duo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ket tinabbeg na Judyo a hidi, “Ni Abraham i hama mi.” Ngem kinagi ni Jesus, “Nu tahod a annak na kam ni Abraham, nagaheg kam mina ha mappiya, a kona ha ginimet ni Abraham. ");
INSERT INTO duo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngem imbes na, kayat moyak a papatayan, maski nu hikan i nangipakatandi ha nikam ha tahod, a intoldu na Dios ha nikan. Bakkan i gimigimetan moy ken ginimet ni Abraham. ");
INSERT INTO duo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Awan a ni Abraham i ahegan moy, nu awan i sabali a hama moy,” kon ni Jesus. Ket nagingal i Judyo a hidi. Isu a tinabbeg di, “Bakkan a hikami i mungaw! Isesa la i hama mi. I Dios a mismo!” ");
INSERT INTO duo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ngem kinagi ni Jesus, “Nu tahod a Hama moy i Dios, ayayatanak moy mina. Ta hikan i naggipu ha Dios. Ket isu i gipu na a atoyak he. Awanak inumangay a naknakam ko, nu awan a pinaangay na ak na Dios. ");
INSERT INTO duo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“Apay a awan moy makatandiyan i kakkagi ko? Oni ah. Gipu ta madiyan moy temanan i pagitoldu ko. ");
INSERT INTO duo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Hikam i annak ni Satanas a hama moy. Ket kayat moy a tungpalan i pagayatan na. Ta namapatay hikuna, maski idi karugi na. Ket awan ha mepeta na a tahod, ta awan ha tahod ha nikuna. Mahagsileng hikuna, ket hikuna man bi i paggipuwan na ngamin a silisileng. ");
INSERT INTO duo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ket iday i gipu na a awan kam manahod ha nikan. Gipu ta ipeta ko ha nikam i tahod. ");
INSERT INTO duo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Heya ha nikam i makapatahod a kelliwatak? Pulos, awan. Ket nu ipeta ko ha nikam i tahod, apay a awan kam manahod ha nikan? ");
INSERT INTO duo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ha totolay a tahod a annak na Dios, temanan di i kakkagi na Dios. Ngem awan kam a annak na Dios. Ket ide i gipu na a awan moy temanan i kakkagi na,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ket tinabbeg na Judyo a hidi, “Tahod i kinagi mi a hikaw i esa a Samaritano. Ta magsenti ka ha nikami a Judyo. Keddimonyo ka,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ket kinagi ni Jesus, “Awanak ha dimonyo. Padeyawan ko la i Hama ko. Ngem niyaen, bahanganak moy dan. ");
INSERT INTO duo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ngem maski nu kona hito, awan ko padasan a padeyaw i baggi ko. Ta atoy pala i esa a makatandi ha deyaw ko. Hikuna i Dios a mangikalentigan ha nikan ken manghukom ha maglimad a hidi ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tahod ide a ipeta ko ha nikam. Ha maski nu heya a mangtongpal ha kagi ko, awan matay hikuna, nu awan a magbiyag ha magnanayon,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ket kinagi na Judyo a hidi, “Agay, sigurado dan a pinagawag na ka na dimonyo! Ta maski ni Abraham, natay hikuna. Pati ngamin a mahagpugto a hidi. Natay hidi ngamin. Ket niyaen, ipeta mo a awan masapul a matay i maski nu heya a mangtongpal ha kagi mo. ");
INSERT INTO duo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Dakdakkal ka dod ngem ni Abraham ken mahagpugto a hidi a natay? Nakaman mo dod a hikaw i katangkayan a tolay ha ngamin a lutak?” ");
INSERT INTO duo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ket tinabbeg ni Jesus, “Nu hikan la i magpadeyaw ha baggi ko, awan ha serbe na. Ngem imbes na, i mangdeyaw ha nikan i Hama ko. Ket hikuna i kagiyan moy a Dios moy. ");
INSERT INTO duo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ngem awan moy hikuna katandi. Ha nikan, katandi ko dan hikuna. Ket nu ipeta ko a awan ko hikuna katandi, magsilengak la, a kona ha nikam. Ngem tahod a katandi ko hikuna. Ket tungpalan ko i kakkagi na. ");
INSERT INTO duo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Niyaen, ide i mepeta ko ha nikam megipu ha ni Abraham a minappo moy. Ta ninamnama na i pagdemat ko ha lutak aye. Ket permi i ragsak na, idi nakatandiyan na i pagdemat ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ket kinagi na Judyo a hidi, “Panyan mo naenta ni Abraham? Awan pala ha lima a pulo i idad mo!” ");
INSERT INTO duo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ket kinagi ni Jesus, “Tahod ide a ipeta ko ha nikam. Temanan moy. Maski idi awan pala neenak ni Abraham, ket atoyak dan.” ");
INSERT INTO duo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Isu a nangalap hidi ha pogepogedu a pangbisag di mina ha ni Jesus, a patayan di mina hikuna. Ta inkalan na manon ha Dios i baggi na. Ngem linumimot ni Jesus, a linumapos hikuna ha Templo. ");
INSERT INTO duo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Idi naglakad ni Jesus, naenta na i esa a lallaki a nabulsak a neenak. ");
INSERT INTO duo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ket sinalodsod na hikuna na tinolduwan na a hidi, “Maestro, heya i makangliwat a nabulsak hikuna a neenak? Hikuna wade, onu nageenak a hidi?” ");
INSERT INTO duo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ket tinabbeg ni Jesus, “Bakkan a liwat i nagipuwan na ide, nu awan penu mepaenta i pinnakabalin na Dios a mangpahusay ha bulsak aye. ");
INSERT INTO duo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","“Niyaen, masapul a tongpalan tam i patarabaho na Dios a nagpaangay ha nikan, ta keoras kitam pala. Ngem dandani dan a dumemat i tiyempo a kona ha kallap, ket awan ha makatarabaho. ");
INSERT INTO duo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ngem basta henak pala ha lutak aye, ket hikan pala i silaw na lutak,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Idi kinagi na ito, linoktaban na i tapok, a ginimet na a luket. Ket inpuhet na ito ha mata na bulsak. ");
INSERT INTO duo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ket inpeta na ha bulsak, “Hen mo a ugisan ha pagdegosan a Siloe.” (I kayat na kagiyan na “Siloe” i “Napaangay.”) Ket inumangay dod i bulsak, a naguges ha mata na. Idi nagsoli, nakaenta dan hikuna. ");
INSERT INTO duo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Niyaen, naenta na hikuna na karuba na a hidi, ken nakatandi a hidi idi nakilimlimos hikuna. Ket kinagi di, “Anya? Hikuna wade i makilimos heya, a kanayon a magetnod ha ihe?” ");
INSERT INTO duo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ket kinagi na kappal, “Oni agay, hikuna iday!” Ngem kinagi na sabasabali, “Awan agay, karupa na la hikuna.” Ket kinagi na lallaki heya, “Oni, tahod a hikan i nakilimos ha ihe idi.” ");
INSERT INTO duo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Isu, kinagi di, “Ngem apay a makaenta ka niyaen? Panya i pinnakapahusay mo?” ");
INSERT INTO duo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ket tinabbeg na, “Iday a lallaki a nagenan di ha ‘Jesus.’ Hikuna i naggimet ha luket, ket inpuhet na ha mata ko. Ket inbon na a umangayak ha Siloe a pagugesan ko. Isu, inumangayak, ket inugesan ko i mata ko. Ket niyaen, makaenta ak dan.” ");
INSERT INTO duo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ket kinagi di ha nikuna, “Hadya i lallaki heya a nagpahusay ha nikaw?” Ket kinagi na, “Awan ko katandi.” ");
INSERT INTO duo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Niyaen, intugan di iday a nahusay a bulsak ha Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ket Sabado iday a pamalak idi ginimet ni Jesus i luket, ket pinahusay na i bulsak heya. ");
INSERT INTO duo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Isu, sinalodsod bila na Pariseyo a hidi nu panya a napahusay i mata na. Ket inpeta na ha nidi, “Inpuhet na i luket ha mata ko. Ket inugesan ko. Ket niyaen, makaenta ak dan.” ");
INSERT INTO duo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ket nagkagiyan na kappal a Pariseyo ni Jesus, a “Awan a naggipu ha Dios iday a lallaki. Ta awan na usegan i paglintegan na maneg a pamalak.” Ngem kinagi na sabasabali, “Panyan na pinnakabalin na a makagimet ha nakaddatan a kona hito, nu kelliwat hikuna?” Ket gipu ta kona hito i pinagtabbeg di, awan nagisesa i pagnakam na Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Isu, sinalodsod di manon i nahusay a bulsak, “Inpeta mo dan a hikuna i nangpahusay ha mata mo. Anya paman i mepeta mo megipu ha nikuna?” Ket kinagi na lallaki, “Hikuna i esa a mahagpugto, a naggipu hikuna ha Dios.” ");
INSERT INTO duo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ngem niyaen, madiyan na Judyo a hidi a manahod a nabulsak ken napahusay i lallaki aye. Isu, inayagan di ha dina na. ");
INSERT INTO duo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ket sinalodsod di hidi, “Ide i annak moy? Ket tahod a nabulsak hikuna a neenak? Panya wade a makaenta hikuna niyaen?” kon na Pariseyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ket tinabbeg dina na, “Oni. Ide i annak mi. Ket katandi mi a nabulsak hikuna a neenak. ");
INSERT INTO duo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ngem awan mi makatandiyan nu apay a makaenta hikuna niyaen. Ket awan mi makatandiyan nu heya i nangpahusay ha nikuna. Hikuna mina i pagsalodsodan moy, ta lakay dan hikuna. Ket makatandi na a tumabbeg,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","(Kinagi di a kona hito, ta nanteng hidi ha panglakayan a hidi. Ta ninakam na panglakayan a hidi a palakadan di ha sakop di a Judyo i maski nu heya a mangipeta a ni Jesus i Cristu na Dios. ");
INSERT INTO duo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ket ide i gipu na a kinagi dina na a annak di aye i makatandi a tumabbeg ha Pariseyo a hidi.) ");
INSERT INTO duo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Isu, inayagan di manon i lallaki a nabulsak idi. Ket kinagi di ha nikuna, “I pagsapata mo i Apo Dios a tahod i kinagi mo ha nikami. Ta katandi mi a kelliwat iday a lallaki a ni Jesus.” ");
INSERT INTO duo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ngem kinagi na napahusay, “Awan ko katandi nu kelliwat hikuna, onu awan. I katandi ko a nabulsakak idi. Ngem niyaen, makaenta ak dan.” ");
INSERT INTO duo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ket kinagi di, “Anya i tahod a ginimet na ha nikaw? Panya i pinangpahusay na ha mata mo?” ");
INSERT INTO duo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ket tinabbeg na, “Inpeta ko dan ha nikam, ngem away moy temanan. Apay a pilitanak moy a mangipenduwa? Siguro kayat moy bila a magbalin a tolduwan na,” kon na napahusay. ");
INSERT INTO duo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ket inenglan di i lallaki aye, a kinagi di, “Hikaw dalla i tinolduwan na. Ket hikami i tinolduwan ni Moyses. ");
INSERT INTO duo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ta katandi mi a nagkagi i Dios ha ni Moyses. Ngem ha iday a lallaki a ni Jesus, awan mi katandi nu hadya i naggipuwan na.” ");
INSERT INTO duo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ket tinabbeg na lallaki, “Agay, malaktatak ha nikam! Ipeta moy a awan moy katandi nu hadya i naggipuwan na, ngem naenta moy dan a hikuna i nangpahusay ha mata ko aye! ");
INSERT INTO duo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Niyaen, katandi tam a awan temanan na Dios i mahagliwat, nu awan i makidios ken maggimet ha pagayatan na. ");
INSERT INTO duo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Maski idi pinakaparsuwa na lutak aye, hanggan niyaen, awan ha nakapahusay ha neenak a bulsak. ");
INSERT INTO duo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nu awan a naggipu ha Dios iday a lallaki, awan hikuna makagimet ha kona he a nakaddatan,” kon na nahusay. ");
INSERT INTO duo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ket tinabbeg na Pariseyo a hidi, “Isu, hikaw dod i magitoldu ha nikami? Ay, hikaw dalla i makangliwat, maski idi neenak ka,” kon di. Ket pinalapos di hikuna ha sakop di a Judyo. ");
INSERT INTO duo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Niyaen, ha ni Jesus, idi nabaheta na a napalakad ha sakop na Judyo i nahusay aye, hen na ineriyok hikuna. Ket idi naeriyokan na, sinalodsod ni Jesus, “Manahod ka dan ha Lallaki a Naggipu ha Langit?” ");
INSERT INTO duo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ket tinabbeg na nahusay, “Heya hikuna, Apo? Ipeta mo bi, penu manahodak ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ket kinagi ni Jesus, “Naenta mo dan hikuna, ta hikan a magkagi ha nikaw, hikan i Lallaki heya a Naggipu ha Langit.” ");
INSERT INTO duo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ket kinagi na nahusay, “Apo, manahodak dan ha nikaw.” Sa hikuna, nagparentumeng, a nagdeydeyaw ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Niyaen, kinagi ni Jesus, “Inumangayak ha lutak aye, a pasinaan ko i manahod a hidi ha awan a hidi a manahod. Ta kona ha nabulsak i ngamin a tolay. Ket atoy i kappal a makatandi a nabulsak hidi. Ket hidi i pahusayan ko, penu mahusay i pagkatandi di ha Dios. Ngem atoy i kappal, ket kagin di a malaing i bukod di a pagkatandi ha Dios. Ket hidi i bulsakan ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ket atoy bila hay i kappal a Pariseyo a nakateman ha nikuna. Ket sinalodsod di, “Anya? I kayat mo kagiyan a mabulsak kami bila?” ");
INSERT INTO duo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ket kinagi ni Jesus ha nidi, “Oni ah. Ta awan kam mina ha liwat nu tahod a mabulsak kam, a awan kam makatandi ha Dios. Ngem niyaen, gipu ta ipeta moy a malaing i bukod moy a pagkatandi ha Dios, tumulos kam a magliwat.” ");
INSERT INTO duo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ide i pangaregan ni Jesus ha kappal. Kinagi na, “Ipeta ko i tahod ha nikam. Temanan moy bi. Ha magtakaw a hidi ha karnero, bakkan a ruwangan i saddapan di, nu awan a umunek hidi ha allad na, ket sabali i pagsaddappan di a magtakaw. ");
INSERT INTO duo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ngem ha tahod a makingkarnero, hikuna i sumadap ha ruwangan. ");
INSERT INTO duo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Hikuna i ilukatan na guwardiya ha ruwangan. Ket makasaneg i karnero a hidi ha timek na. Ta ayagan na i nagnagen di, a ilapos na i bukod na a karnero a hidi. ");
INSERT INTO duo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ket nu nelapos na hidi, magpalungo hikuna a mangidilan. Ket umunod i karnero na a hidi, ta masaneg di i timek na. ");
INSERT INTO duo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Awan hidi umunod ha sabali a tolay, nu awan a buyotan di. Gipu ta awan di katandiyan i timek na sabali.” ");
INSERT INTO duo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ide i pangaregan ni Jesus ha tolay a hidi, ngem awan di ito nakatandiyan. ");
INSERT INTO duo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Isu, kinagi manon ni Jesus, “Tahod ide a ipeta ko ha nikam. Temanan moy bi. Hikan i kona ha ruwangan a saddapan na karnero a hidi. ");
INSERT INTO duo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ket mahagtakaw i ngamin a nagpalungo ha nikan, a nagkagi a hidi i magturay ha kukuwa na Dios. Ngem awan magteman ha nidi i totolay a kona ha karnero ko. ");
INSERT INTO duo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ta hikan i magdapon ha nidi. Ket hikan i kona ha ruwangan di. Ha maski nu heya a sumadap a medilan ha nikan, mesalakan hikuna. Ket mawayawaya i maski nu heya a nasakop ko, ket iyatad ko ha nikuna i kasapulan na. ");
INSERT INTO duo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Awan ha panggep na tulisan, nu awan a magtakaw, ken magpapatay ken magdadael. Ngem hikan i inumangay penu pabiyagan ko i totolay ha Apo Dios ha magnanayon, ket penu awan ha kurang di ha biyag di aye. ");
INSERT INTO duo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Hikan i tahod a makingkarnero, ta ipusta ko i biyag ko, maski matayak, gipu ha nidi a daponan ko. ");
INSERT INTO duo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ngem bakkan a kona hito i gimetan na makitangdan. Ta nu maenta na i maingal a asu a dumangper, bumuyot la hikuna, a lakadan na i karnero a hidi. Ta bakkan a hikuna i tahod a mahagdapon, ket awan na hidi kukuwa. Isu, kagitan na asu i karnero a hidi. Ket bumuyot hidi a masinasina. ");
INSERT INTO duo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ket buyotan na makitangdan, ta awan ha ayat na ha karnero a hidi. ");
INSERT INTO duo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ngem hikan i tahod a mahagdapon. Ket katandi ko i karnero ko a hidi, ket katandi di ak bila. ");
INSERT INTO duo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ket maski kona ha nikan ken Hama ko. Ta katandi na ak, ket katandi ko bila hikuna. Ket iyatad ko i biyag ko, penu makabiyag hidi a kukuwa ko. ");
INSERT INTO duo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Niyaen, atoy bila i sabali a karnero ko, a bakkan hidi a Judyo. Ket masapul a itugan ko bila hidi. Ta magteman bila hidi ha nikan. Isu a makipagisesa hidi a sakop ko. Ket atoy la i esa a mahagdapon ha nidi. ");
INSERT INTO duo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ayayatan na ak na Hama ko, gipu ta palobusan ko a matay i baggi ko, penu magbiyagak manon. ");
INSERT INTO duo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Awan ha makapatay ha baggi ko. Iyatad ko ito gipu ha bukod ko a pagayatan. Ta kona hito i turay ko a palakadan i angas ko, a matay i baggi ko, ken mangpabiyag manon ha baggi ko aye. Kona he i kalintegan ko, gipu ha inbon Nama ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Niyaen, gipu ha ide a kinagi ni Jesus, nakipagtabbegan manon i Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ta atoy i kappal a nagkagi, “Naawag dan hikuna, a magmauyong dan! Awan kam mina magteman ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ngem kinagi na sabali a hidi, “Bakkan a kona hito i kakkagi na tolay a naawag na dimonyo. Ket awan na kaya na dimonyo a magpahusay ha mabulsak,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Niyaen, ahided dan, ket tiyempo na Piyesta na Pinagidatton di ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Naglakalakad ni Jesus ha Paglenduman ni Solomon, ha Templo. ");
INSERT INTO duo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ket dinumuhap i Judyo a hidi ha nikuna, a kinagi di, “Hangan kaalay a masapul mi maguray hanggan ipeta mo i tahod? Nu hikaw i Cristu, ipeta mo mina niyaen!” ");
INSERT INTO duo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ket tinabbeg ni Jesus, “Inpeta ko dan ha nikam, ngem awanak moy tinahod. Atoy bila i nakaddatan a gimigimetan ko gipu ha turay Nama ko. Ket hidi i mangpatahod megipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ngem awan kam manahod, ta awan kam nesakop ha karnero a hidi a kukuwa ko. ");
INSERT INTO duo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","I karnero ko a hidi, masaneg di i timek ko. Ket katandi ko hidi. Ket umunod hidi ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ket iyatad ko ha nidi i biyag na Dios a magnanayon. Ket pulos, a awan hidi maparusaan ha katay. Ket awan ha makaagew ha nidi ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ta Hama ko i nangiyatad ha nidi ha nikan. Ket hikuna i mas mapigsa ngem ha ngamin. Ket awan ha makaagew ha nidi ha Nama ko. ");
INSERT INTO duo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Isesa la kami ni Amang,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Niyaen, idi nateman na ito na Judyo a hidi, inalap di manon i pogepogedu a pangbisag di mina ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ngem kinagi ni Jesus, “Makpal i nakaddatan a inpaenta ko ha nikam, ket mappiya i inpagimet ha nikan Nama ko. Anya i pangbisagan moy ha nikan?” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ket tinabbeg na Judyo a hidi, “Awan taka a bisagan gipu ha kinappiya na ginimet mo, nu awan gipu ta agindidios ka. Hikaw i esa la a tolay. Ngem kayat mo a pagbalinan i baggi mo a Dios!” kon na Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Ket tinabbeg ni Jesus, “Nesurat ha Libro na Dios a ninagenan na ha ‘Dios’ i totolay a inatdinan na ha kakkagi na, a pinagturay na hidi a maghukom ha kakalan di a tolay. Ket niyaen, katandi tam a tahod ha magnanayon i kagi na Libro na Dios. Isu, nu ninagenan na Dios a didios i hukom a hidi a pinagturay na, ");
INSERT INTO duo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","anya dod ha nikan, a inbukod na ken pinaangay na ha lutak aye, penu makatandiyan na totolay i Dios. Ta inpeta ko dan a hikan i Annak na Dios. Ngem kinagi moy a pagbalinan ko i baggi ko a Dios. ");
INSERT INTO duo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Niyaen, nu awan ko gimetan i nakaddatan a pagimet Nama ko, awanak moy mina tahodan. ");
INSERT INTO duo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngem nu tahod a gimetan ko idagenday a nakaddatan, tahodan moy mina i gimetan ko, maski nu awan moy tahodan i pagitoldu ko. Ta nu tahodan moy i gimetan ko, makatandiyan moy talaga a atoy dan i Hama ha nikan, ket atoyak bila ha nikuna a isesa,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ket pinanggep di manon a dakapan ni Jesus. Ngem nakalapsut hikuna ha nidi. ");
INSERT INTO duo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ket inumangay manon ni Jesus ha dibelew na karayan Jordan, ha lugar a nagbinyagan idi ni Juan. Ket naghen hikuna hito. ");
INSERT INTO duo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ket makpal i inumangay ha nikuna. Nagginuhon hidi, “Awan ha nakaddatan a ginimet ni Juan. Ngem tahod i ngamin a inpeta na megipu ha ide a lallaki,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ket makpal hidi ha iday a lugar a nanahod ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Niyaen, atoy i esa a lallaki a nagsaket. Lasaro i nagen na, a taga-Betaniya. Ket naghen bila ha Betaniya i duwa a kabsat na a ni Maria ken ni Marta. ");
INSERT INTO duo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Ide a ni Maria i nangibulak ha bangbanglo ha tikad ni Apo Jesus, idi mabikan dan i oras a katay na. Sa na, pinunasan ha buk na. Ket niyaen, i kabsat na a ni Lasaro i nagsaket.) ");
INSERT INTO duo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Isu, pinaangay di i mangipeta ha ni Jesus ha, “Apo, magsaket i katalakay mo,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Idi nateman na ito ni Jesus, kinagi na, “Awan ipatay ni Lasaro i saket na. Ta magimet ide penu medeydeyaw i Dios. Ket madedeyaw bila i Annak na Dios gipu ha ide a saket,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Niyaen, inayat ni Jesus hidi a magkakabsat a Marta, Maria ken Lasaro. ");
INSERT INTO duo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ngem maski nu dakkal i pagayat na, ken nabaheta na a masaket ni Lasaro, naguray ni Jesus ha duwa pala a pamalak. ");
INSERT INTO duo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kobosan na, kinagi ni Jesus ha nikami a tinolduwan na, “Magsoli kitam ha Judeya.” ");
INSERT INTO duo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ngem kinagi mi, “Awan mina Maestro. Ta awan naalay, ket kayat di ka a bisagan na Judyo a hidi. Awan ka mina sumoli ha iho,” kon mi. ");
INSERT INTO duo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ngem inpangaregan ni Jesus, penu makatandiyan di a awan pala i oras na katay na. Kinagi na, “Pamalak pala niyaen, ket keoras kitam pala. Ngem dumemat nokkan i tiyempo, ket awan a mabalin a maglakad. Ngem basta kessilaw kitam pala, awan kitam mekarpes, ta madisyagan na singgit i lutak aye. ");
INSERT INTO duo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ngem delikadu nokkan i tiyempo nu awan ha silaw ha lutak. Ket mekarpes i maski nu heya a lumakad, nu awan ha nikuna i silaw,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kona hito i pangaregan ni Jesus ha nikami a tinolduwan na. Sana, kinagi, “Kimillap dan ni ilay tam a Lasaro. Entamon. Ta lukagan ko hikuna.” ");
INSERT INTO duo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ngem kinagi mi, “Apo, mappiya nu kimillap hikuna, ta humusay dan,” kon mi. ");
INSERT INTO duo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ta awan mi nakatandiyan i kayat na kagiyan ni Jesus, a natay dan ni Lasaro. Ta kagin mi a umemmang la ni Lasaro nu kumakelap hikuna. ");
INSERT INTO duo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Isu, inpakatandi ni Jesus, “Natay dan ni Lasaro. ");
INSERT INTO duo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ket mappiya, ta awanak ha henan na ayo, penu maenta moy i gimetan ko, ket pumigsa i panahod moy ha nikan. Nay kitam dan agay,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ket ha ni Tomas, a ni Kambal i sangay na, kinagi na ha nikami, “Nay, umuseg kitam dan ha nikuna, maski nu matay kitam ngamin,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Niyaen, idi kaddemat ni Jesus ha Betaniya, nabaheta na a uppat dan a pamalak a nelabbang dan ni Lasaro. ");
INSERT INTO duo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Niyaen, mabikan i ili na Betaniya ha Jerusalem. Tallu la a kilometro i kaadiyo na. ");
INSERT INTO duo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ket makpal i Judyo a hidi a inumangay ha ni Marta ken ni Maria, penu mangliwliwa ha nidi, gipu ha kabsat di a minatay. ");
INSERT INTO duo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Idi nabaheta ni Marta a dinumemat ni Jesus, linumapos hikuna a mangsalpak. Ngem newarak ni Maria ha disalad na bilay. ");
INSERT INTO duo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ket kinagi ni Marta ha ni Jesus, “Apo, nu atoy ka idi, awan mina a natay i kabsat ko. ");
INSERT INTO duo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ngem maski niyaen, katandi ko a makaaged ka ha maski nu anya ha Dios, ket atdinan na ka.” ");
INSERT INTO duo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ket kinagi ni Jesus, “Magbiyag manon i kabsat mo.” ");
INSERT INTO duo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ket kinagi ni Marta, “Katandi ko a magbiyag hikuna manon nokkan ha dilokod a pamalak, nu pabiyagan na Dios i ngamin a minatay a hidi.” ");
INSERT INTO duo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ket kinagi ni Jesus, “Hikan i magpabiyag ha totolay. Ket hikan i paggipuwan na biyag na totolay. Ket maski nu heya a manahod ha nikan, maski nu matay hikuna, magbiyag hikuna manon a maghen ha Apo Dios. ");
INSERT INTO duo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ta nu manahod hikuna ha nikan, atoy dan ha nikuna i biyag na Dios a magnanayon a awan a matay. Niyaen, Marta, manahod ka ha ide?” ");
INSERT INTO duo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ket kinagi ni Marta, “Oni Apo, manahodak a hikaw i Cristu, a Annak na Dios. Ket pinaangay na ka a maghari ha ngamin a totolay.” ");
INSERT INTO duo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Niyaen, idi kinagi na ito ni Marta, inumangay hikuna a magayag ha ni Maria a kabsat na. Ket inyanassas na, “Atoy ni Maestro. Paayagan na ka,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ket idi nateman na, inumikat ni Maria a dagus, ket inumangay a mangsalpak ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Niyaen, awan pala dinumemat ni Jesus ha ili di. Ta atoy pala hikuna ha lugar a nangsalpakan ni Marta. ");
INSERT INTO duo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Idi tinumaknag ken linumapos ni Maria, inumunod i mangliwliwa a hidi a agagum na. Ta kagin di a umangay ni Maria a magsanget ha labbang ni Lasaro. ");
INSERT INTO duo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Idi kaddemat ni Maria ha henan di Jesus, ket naenta na hikuna, hinumakab ni Maria ha saguppang na, a kinagi na, “Apo, nu atoy ka idi, awan mina a natay i kabsat ko.” ");
INSERT INTO duo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ket idi naenta ni Jesus a nagsangisanget ni Maria ken Judyo a hidi a agagum na, nagsaket bila i nakam na a tahod. ");
INSERT INTO duo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ket kinagi na, “Hadya i nangilabangan moy ha nikuna?” Ket tinabbeg di, “Apo, umangay kitam, a ipaenta mi ha nikaw.” ");
INSERT INTO duo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ket nagsanget bila ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ket ide i gipu na a nagginuhon i Judyo a hidi, “Entan moy, talaga a inayat na ni Lasaro,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ngem atoy i kappal a nagginuhon, “Apay wade a awan na pinahusay ni Lasaro? Kaya na mina, nu tahod a pinahusay na iday a bulsak idi.” ");
INSERT INTO duo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ket nagsaket unay manon i nakam ni Jesus, idi binumikan hikuna ha labbang. I paglabbangan di i kuweba a atoy kallab na a pogedu. ");
INSERT INTO duo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ket inbon ni Jesus, “Adyan moy iday a pogedu!” Ngem kinagi ni Marta a kabsat na natay, “Awan mina Apo, ta nabuyok dan. Uppat dan a pamalak a nelabbang dan hikuna,” kon ni Marta. ");
INSERT INTO duo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ngem kinagi ni Jesus, “Inpeta ko dan ha nikaw, a basta manahod ka, ket maenta mo i kainamakan na kapigsa na Dios!” ");
INSERT INTO duo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Niyaen, inadya di i pogedu. Ket tinumangad ni Jesus. Ket kinagi na, “Hama, magyamanak ha nikaw, ta tinemanak mo dan. ");
INSERT INTO duo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Katandi ko a temananak mo a kanayon. Ngem niyaen, ikagi ko a mapigsa a kona hito, gipu ha tolay aye a hidi, penu manahod hidi a hikaw i nagpaangay ha nikan.” ");
INSERT INTO duo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Idi nekagi na ide, indulaw na a mapigsa, “Lasaro, lumapos ka.” ");
INSERT INTO duo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ket linumapos i natay heya, a nabadbaden pala ha hamet i kamat ken tikad na. Pati i buntok na a nabadbaden bila. Ket kinagi ni Jesus, “Lakbesan moy hikuna. Palobusan moy hikuna a maglakad.” ");
INSERT INTO duo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Niyaen, makpal i Judyo a hidi a agagum di Maria a nanahod ha ni Jesus, gipu ta naenta di i ginimet na. ");
INSERT INTO duo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ngem atoy i kappal a dinumiretso ha Pariseyo a hidi, a inbaheta di i ginimet ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Isu, pinapisan na Pariseyo ken matangkay a hidi a papadi i gurupo a managenan ha Sanhedrin, a naguhonan di ni Jesus. Kinagi di, “Maganya kitam mina? Ta makpal a milagro i ginimigimet na lallaki aye. ");
INSERT INTO duo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu pabiyanan tam hikuna, magpasakop hidi ngamin ha nikuna. Ket nu mabaheta na hari ha Roma a sabali i maghari ha nikitam, agay, paangayan na i sundalu na a hidi. Ket mangdadael hidi ha Templo tam, ken patayan di i ngamin a Judyo.” ");
INSERT INTO duo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Niyaen, ha iday a tawen, ni Kaipas i Katangkayan a Padi. Ket hikuna i nagkagi, “Pulos, awan ha katandi moy! ");
INSERT INTO duo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Awan moy makatandiyan a mas mappiya nu matay i esa gipu ha ngamin a tolay, penu awan matay i ngamin gipu ha esa.” ");
INSERT INTO duo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Niyaen, awan na kinagi ide a naknakam na. Ngem gipu ta hikuna i Katangkayan a Padi ha iday a tawen, nepugto na i katay ni Jesus a para ha ngamin a Judyo. ");
INSERT INTO duo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ket awan la a para ha Judyo a hidi, nu awan penu pagisesaan na i ngamin a annak na Dios a maghen ha maski nu hadya a lugar ha lutak.) ");
INSERT INTO duo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Isu, nangrugi ha iday a pamalak, nagpanggep hidi nu panyan di a patayan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ket ide i gipu na a awan linumakad ni Jesus ha saguppang di, ha probinsiya a Judeya. Imbes na, linumpos hikuna, a naghen ha nibik na amamugod, ha ili a Epraim. Ket hito bila i naghenan mi a tinolduwan na. ");
INSERT INTO duo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Niyaen, dandani dan a dumemat i Piyesta na Judyo a nagenan di ha, “Pinagtaleban na Anghel a Magpatay.” Ket makpal hidi a inumangay ha Jerusalem, penu tongpalan di i linteg ni Moyses megipu ha pinakadegos di, ha palungo na Piyesta aye. ");
INSERT INTO duo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ket nagerieriyok hidi ha ni Jesus. Ket naginuhon hidi, idi nagpisan hidi ha Templo, “Anya ha nakam mo? Umangay hikuna a makipiyesta, onu awan?” kon di. ");
INSERT INTO duo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Niyaen, inbon na matangkay a hidi a papadi ken Pariseyo a hidi a nu atoy i makatandi ha henan ni Jesus, ipakatandi na mina ha nidi, penu madakap di hikuna. ");
INSERT INTO duo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Niyaen, idi annam a pamalak idi palungo na Piyesta na Pinagtaleban na Anghel a Magpatay, inumangay ni Jesus ha Betaniya, a naghenan ni Lasaro. Ide a ni Lasaro i pinabiyag na idi. ");
INSERT INTO duo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ket niyaen, insaganaan di ni Jesus ha pangapon na. Nagserbe ni Marta ha nagkanan di. Ket atoy bila hay ni Lasaro, a esa a nakipagkan ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ket ha ni Maria, nangalap hikuna ha esa a bote a kanginaan a bangbanglo, ket inbulak na ito ha tikad ni Jesus. Sa na, pinunasan ha buk na. Ket inumales i ahob na ha ngamin a bilay. ");
INSERT INTO duo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ngem atoy i kinagi na esa a tinolduwan ni Jesus, a ni Judas Iskaryote. (Hikuna i nangliput ha ni Jesus.) ");
INSERT INTO duo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Kinagi na, “Madi iday, ta nagastuwan i korinat na. Nelako mina iday a bangbanglo, ta makatawen a suweldo i balle na iday. Sayang, a awan neyatad i korinat na ha napobre a hidi.” ");
INSERT INTO duo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kona hito i kinagi ni Judas. Ngem awan gipu ha kagbi na ha napobre a hidi, nu awan penu makaalap mina hikuna ha korinat heya. Ta nahagtakaw hikuna. Ket i biyang na idi, ha gurupo mi a tinolduwan ni Jesus, i magdapon ha korinat mi. Ket nu kappal, inalap na ito. ");
INSERT INTO duo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ngem kinagi ni Jesus, “Palobusan moy ide a babbey! Pabiyanan moy hikuna, ta inusar na ide a bangbanglo a pangpasahob na ha baggi ko, a kona ha natayak dan, ket melabbangak mina. ");
INSERT INTO duo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ha napobre a hidi, maatdinan moy hidi ha maski nu anya a oras. Ngem bakkan ha nikan, ta dandani ak dan a lumakad,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Niyaen, ha makpal a Judyo a mamiyesta ha Jerusalem, idi nabaheta di a atoy ni Jesus ha Betaniya, inumangay bila hidi. Ket awan la a gipu ta kayat di maenta ni Jesus, nu awan penu maenta di bila ni Lasaro, a pinabiyag na manon. ");
INSERT INTO duo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ket ide i gipu na a nagpanggep i matangkay a hidi a papadi a patayan di bila ni Lasaro. ");
INSERT INTO duo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ta gipu ha ni Lasaro, makpal i Judyo a sinumina ha panglakayan di, ket nanahod hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Idi kaugman na, nakaabot ha Jerusalem i baheta a dandani dan a dumemat ni Jesus. Idi nabaheta na makpal a hidi a nakipiyesta, ");
INSERT INTO duo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","inalap di i dodon na niyog a pangsalpak di ha ni Jesus a kona ha hari. Ket linumapos hidi a indulaw di, “Madaydayaw i Dios! Madaydayaw i hari tam a Israel! Pagasatan na Dios i hari a pinaangay na ha ihe!” ");
INSERT INTO duo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Niyaen, naenta ni Jesus i esa a urbon na kabayo. Ket nagsakayan na ito. Ket gipu ha ide, natongpal na i esa a pugto a nesurat ha Libro na Dios, a kinagi na Dios, ");
INSERT INTO duo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Awan kam mina manteng, hikam a taga-Jerusalem. Ta entan moy, a kaddemat na hari moy a magsakay ha urbon na kabayo,” kon na pugto. ");
INSERT INTO duo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Idi tiyempo a ito, awan mi nakatandiyan i ginimet na aye. Ngem idi neyontok ni Jesus ha langit, nanakam mi a nesurat ito megipu ha nikuna, ket kona bila hito i salpak di ha nikuna ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Niyaen, atoy bila hay i makpal a nakaenta ha ni Jesus, idi inayagan na ni Lasaro ha labbang na, ket pinabiyag na manon. Ket hidi i nangpatahod megipu ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iday i gipu na a nangsalpak i makpal a hidi ha ni Jesus. Gipu ta nabaheta di megipu ha nakaddatan a ginimet ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ha Pariseyo a hidi, idi naenta di a magdulug i makpal a tolay, naginuhon hidi, “Maenta moy iday! Naabak na kitam dan. Ta umaunod hidi ngamin ha nikuna,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Niyaen, atoy bila ha Jerusalem i kappal a Griego a makipagdeyaw ha Dios ha ide a Piyesta. ");
INSERT INTO duo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ket niyaen, inumangay hidi ha ni Pelipe, ta taga-Betsayda hikuna, ha probinsiya a Galileya. Ket inaged di ha ni nikuna, “Apo, nu mabalin, kayat mi a makiuhon ha ni Jesus.” ");
INSERT INTO duo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Isu, inumangay ni Pelipe, ket inpeta na ha ni Andres. Ket inumangay hidi a duwa, a nangipeta ha ni Jesus ha pagaged na Griego a hidi. ");
INSERT INTO duo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ket ide i tabbeg ni Jesus ha ngamin a hidi a nagteman. Kinagi na, “Dinumemat i oras a pangpaenta na Dios ha kinatangkay ko ha ngamin a totolay. ");
INSERT INTO duo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","“Tahod ide a ipeta ko ha nikam. Temanan moy bi. Awan kumakpal i esa a bin-i, nu awan hikuna memula ha lutak, a kona matay. Ngem nu matay hikuna, magbunga hikuna ha makpal. Ket kona bila hito ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ket kona bila ha ide ha totolay a umunod ha nikan. Ta maski nu heya a masor ha bukod na a pagayatan, dadailan na i biyag na. Ngem maski nu heya a magpabiyan ha mismo a pagayatan na, gipu ha pagtulok na ha nikan, ket maghen hikuna ha Dios ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ha maski nu heya a magserbe ha nikan, masapul a hikan i ahegan na, a maski nu anya i pagpadas ko, padasan na bila iday. Ket nu kona hito i paguseg na ha nikan, maghen bila hikuna ha henan ko nokkan. Ket padeyawan na Hama ko i maski nu heya a magserbe ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ket intulos na, “Niyaen, magsaket i nakam ko. Ket anya i ipeta ko ha Hama? Ta madiyan ko a ipeta, ‘Hama, isalakanak mo bi ha rigrigat aye a dandani dan a dumemat.’ Agay, awan ko ito ipeta, ta ide i gipu na a inumangayak ha oras aye, penu attaman ko ide a rigrigat. ");
INSERT INTO duo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Niyaen, ipeta ko, ‘Hama, ipaenta mo bi i kainamakan mo,’” kon ni Jesus. Sa, nagkagi i esa a timek a naggipu ha langit, “Inpaenta ko dan gipu ha nikaw i kainamakan ko. Ket gipu ha nikaw, ipaenta ko paman ito ha totolay,” kon na timek heya. ");
INSERT INTO duo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Niyaen, ha denday a kakpalan a nagtiteman, idi nateman di ide a timek, kinagi di a atoy i nagkadur ha langit. Ngem atoy bila i kappal a nagkagi, “Bakkan a kadur! Iday i kagi na anghel ha nikuna,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ngem kinagi ni Jesus, “Awan nagkagi iday a timek para ha nikan, nu awan para ha nikam, penu manahod kam. ");
INSERT INTO duo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ta dandani dan i tiyempo a paghukom na Dios ha totolay, Ket dandani dan i tiyempo a maabak ni Satanas, a nagturay ha totolay hanggan niyaen. ");
INSERT INTO duo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Gipu ha nikan, nu mebayogak ha kudos, ken meunekak ha ontok, masakop ko i ngamin a totolay, a iturayan ko hidi,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Kinagi na ito penu ipakantadi na nu panyan na kakatay na.) ");
INSERT INTO duo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ngem tinabbeg na makpal, “Kon na Libro na Dios a magbiyag a magnanayon i Cristu a paangayan na Dios a maghari. Apay a ipeta mo a masapul a matay ha kudos i Annak na Dios a Nagbalin a Tolay? Heya dod i Annak na Dios a Nagbalin a Tolay, nu awan i Cristu na Dios?” kon di. ");
INSERT INTO duo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ket tinabbeg ni Jesus, “Dandani ak dan a lumakad. Isu, ballik la i tiyempo a magdisyag ha nikam i silaw ko. Niyaen, umunod kam mina ha silaw aye, penu awan na kam malenduman na diham. Ta maski nu heya a maglakad ha diham, awan na makatandiyan nu hadya i angayan na. ");
INSERT INTO duo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Niyaen, gipu ta atoy pala ha nikam i silaw aye, manahod kam mina ha ide a silaw, penu magbalin kam a totolay a kessilaw bila.” Idi kinagi na ito ni Jesus, linakadan na hidi, ket awan manon nagpaenta ha nidi. ");
INSERT INTO duo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ket maski nu makpal i nakaddatan a ginimet ni Jesus ha saguppang di, awan a nanahod i Judyo a hidi ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ta kona hito i nepugto ni Isayas a minahagpugto nikuna a naalay dan. Ket niyaen, natongpal dan. Ta kinagi na, “Apo, awan ha manahod ha nebaheta mi. Maski nu nepaenta ha nidi i kaddat na Dios. Awan hidi manahod,” kon ni Isayas. ");
INSERT INTO duo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ket ide paman i gipu na a awan a mabalin a manahod hidi. Ta inpugto ni Isayas, ");
INSERT INTO duo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Sinalenan na Dios i mata di, penu awan di maenta. Ket pinaigat na i nakam di, penu awan di makatandiyan, a awan hidi magbabawi ken magaged ha nikan a pahusayan ko hidi.” ");
INSERT INTO duo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nepugto na ito ni Isayas megipu ha ni Jesus. Ta maski idi tiyempo ni Isayas, inpaenta na Dios ha nikuna i kinainamakan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ngem maski nu kona hito, makpal hidi, maski hidi a panglakayan na Judyo, a nanahod ha ni Jesus. Ngem gipu ha kanteng di ha Pariseyo a hidi, awan di inpeta i panahod di ha saguppang na totolay. Ta kantengan di, a baka palakadan di hidi na Parpariseyo a hidi ha sakop a Judyo. ");
INSERT INTO duo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Isu, awan di inpeta a manahod hidi ha ni Jesus. Ta kinaykayat di i pangpadeyaw na totolay ngem ha deyaw na Dios. ");
INSERT INTO duo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ide i pagitoldu ni Jesus, a inpakatandi na ha saguppang na totolay. Kinagi na, “Ha maski nu heya a manahod ha nikan, awan la hikan i panahodan na, nu awan i Dios a nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ket ha maski nu heya a makaenta ha nikan, maenta na bila i Dios a nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Hikan i dinumemat ha lutak aye a kona ha esa a silaw, penu awan madihaman i maski nu heya a manahod ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ket ha maski nu heya a makateman ha pagitoldu ko, ngem awan na usigan, bakkan a hikan i manghukom ha nikuna. Ta awanak inumangay a maghukom ha totolay, nu awan penu isalakan ko hidi. ");
INSERT INTO duo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ha maski nu heya a magmadi ha nikan ken ha pagitoldu ko, mahukoman hikuna nokkan ha dilokod a pamalak. I magpahukom ha nikuna i pagitoldu ko. ");
INSERT INTO duo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Oni, ta awanak magkagi ha bukod ko a nakam, nu awan a inbon na Hama ko, a nagpaangay ha nikan. Ta hikuna i nangibon nu anya i kagiyan ko, ken panyan ko mepeta. ");
INSERT INTO duo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ket katandi ko a makedilan ha biyag a magnanayon i pagitoldu aye na Dios. Isu, nu anya i kakkagi ko, ikagi ko a kona ha inbon ha nikan Nama ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Niyaen, idi palungo na Piyesta na Pinagtaleban na Anghel a Magpatay, ket katandi ni Jesus a dinumemat i oras a kalakad na ha ide a lutak, ken sumoli ha Nama na ha langit. Inayayat na i tinolduwan na a hidi, maski idi karugi na. Ket niyaen, kayat na a mepaenta ha nidi i kinadakkal na pagayat na ha nidi. ");
INSERT INTO duo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Idi pangapon di, pinagnakam na dan ni Satanas ni Judas (a annak ni Simon Iskaryote), a liputan na ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ngem ha ni Jesus, nakatandiyan na a intalak na Hama na i ngamin a turay na. Ket katandi na bila a naggipu hikuna ha Dios, ket sumoli bila ha Dios. ");
INSERT INTO duo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ket gipu ta kona hito i pagkatandi na, tinumaknag hikuna ha pangapon di, ket inadya na i badu na, ket inalap na i esa a tuwaliya a ingakad na ha sappang na. ");
INSERT INTO duo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sa na, inasakan i esa a palanggana ha dinom, ket inrugi na a ugesan i tikatikad na tolduwan na a hidi. Ket pinunasan na hidi ha towaliya a ingakad na. ");
INSERT INTO duo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ngem idi nakaabot hikuna ha ni Simon Pedro, kinagi ni Pedro, “Apo, masanikiyak! Awan mos ugesan i tikad ko!” ");
INSERT INTO duo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ket kinagi ni Jesus, “Awan mo katandi i gimetan ko niyaen. Ngem makatandiyan mo nokkan.” ");
INSERT INTO duo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ket kinagi ni Pedro, “Madiyan ko! Hanggan awan ha kahad, awan a hikaw i maguges ha tikad ko.” Ngem tinabbeg ni Jesus, “Nu awan taka ugesan, awan ka a mebilang a tolduwan ko.” ");
INSERT INTO duo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Isu, kinagi ni Simon Pedro, “Apo, nu kona hito, awan la i tikatikad ko, nu awan pati ngamin a kamat ken buntok ko aye.” ");
INSERT INTO duo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ket kinagi ni Jesus, “Ha tolay a nakadegos, awan na a masapul a ugesan i ngamin a baggi na, nu awan i tikad na la. Niyaen, nadalus kam. Ngem atoy i esa ha nikam a awan nadalus,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ta nakatandiyan na nu heya i mangliput ha nikuna. Ide i gipu na a kinagi na, “Nadalus kam. Ngem atoy i esa ha nikam a awan nadalus,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Idi naugisan ni Jesus i tikatikad di, nagbadu hikuna manon, ket sinumoli ha lugar na ha panganan di. Sa na, sinalodsod, “Makatandiyan moy i ginimet ko ha nikam? ");
INSERT INTO duo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nagenanak moy ha maestro ken Happo moy. Ket tahod ito, ta hikan i maestro ken Happo moy. ");
INSERT INTO duo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Niyaen, nu hikan talaga i maestro ken happo moy, ket inugesan ko i tikad moy, aheganak moy mina a maginuges kam ha tikatikad moy. ");
INSERT INTO duo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ta inpaenta ko ha nikam i pangaregan moy, penu gimetan moy i kona ha ginimet ko ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ket tahod ide a ipeta ko ha nikam. Temanan moy bi. Awan a mas maturay i tagabu ngem ha happo na. Ket awan a mas maturay i pinaangay ngem ha nagpaangay. Isu, aheganak moy mina. ");
INSERT INTO duo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Niyaen, gipu ta makatandiyan moy dan ide a pagitoldu ko ha nikam, maragsak kam, basta tungpalan moy ito. ");
INSERT INTO duo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ngem awanak magkagi megipu ha nikam ngamin,” kon ni Jesus. “Ta katandi ko i nakam na ngamin a pinili ko. Ket katandi ko i esa a mangliput ha nikan nokkan. Ta masapul a matungpal i nesurat ha Libro na Dios, a ‘Liputan na ak na agum ko a nakipagkan ha nikan,’ kon na. ");
INSERT INTO duo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ket ipeta ko ide ha nikam niyaen, ha palungo a magimet, penu nokkan, nu nagimet dan ito, tumulos kam a manahod a hikan i Cristu a pinaangay na Dios. ");
INSERT INTO duo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Tahod ide a ipeta ko ha nikam. Temanan moy bi. Ta maski nu heya a manahod ha paangayan ko a hidi, tahodan na ak bila. Ket ha maski nu heya a manahod ha nikan, tahodan na bila i Dios a nagpaangay ha nikan.” ");
INSERT INTO duo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Idi inubos ni Jesus i kinagi na aye, nariribuk hikuna ha nakam na. Ket inpakatandi na ha nikami, “Tahod ide a ipeta ko ha nikam. Atoy i esa ha nikam a mangliput ha nikan nokkan.” ");
INSERT INTO duo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ket naginamata kami a tinolduwan na, ta awan mi katandiyan nu heya i pagkagiyan na. ");
INSERT INTO duo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Niyaen, atoyak bila hay a esa a inayat na ken esa a agum di. Ket naghenak ha hikeg na ha lamesaan. ");
INSERT INTO duo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Isu, sinenyasan na ak ni Simon Pedro, a magsalodsodak mina nu heya i pagkagiyan na. ");
INSERT INTO duo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ket gipu ta kona hito a nakabikanak ha ni Jesus, inyanassas ko, “Apo, heya i pagkagiyan mo?” kon ko. ");
INSERT INTO duo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ket tinabbeg na, a inyanassas na bila, “Entan mo. Ta isawsaw ko ide a tinapay ha ide a digu, ket iyatad ko ha nikuna,” kon ni Jesus. Isu, idi insawsaw na i tinapay, inyatad na ha ni Judas a annak ni Simon Iskaryote. ");
INSERT INTO duo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ket idi kinan ni Judas i tinapay heya, pinaawag na hikuna ni Satanas. Ket kinagi ni Jesus ha nikuna, “Sigida kas a manggimet ha panggep mo,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ha nikami ha lamesaan, awan ha nikami ha nakatandi nu apay a kona hito i inpeta ni Jesus ha ni Judas. ");
INSERT INTO duo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ta kagin na kappal a inpeta ni Jesus a umangay mina ni Judas a gumatang ha kasapulan mi ha piyesta, onu mangiyatad ha korinat ha napobre a hidi. Gipu ta ni Judas i mahagdapon ha korinat mi. ");
INSERT INTO duo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Isu, idi kinan ni Judas i tinapay heya, linumapos hikuna a dagus. Ket kallap dan idi. ");
INSERT INTO duo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Idi nakalakad dan ni Judas, kinagi ni Jesus, “Niyaen dan a tiyempo i pagpaenta ha kainamakan ko a Annak na Dios a Nagbalin a Tolay. Ket gipu ha nikan, mepaenta bila i kinainamakan na Dios. ");
INSERT INTO duo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ket ha pagpaenta ko ha kinainamakan na Dios, ipaenta na bila na Dios i kainamakan ko a magisesa kami. Ket niyaen, dandani dan ito a magimet. ");
INSERT INTO duo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ay, hikam a agagum ko a ayayatan ko unay. Ballik dan i tiyempo a maghenak pala ha nikam. Nokkan paman, ket eriyokanak moy. Ngem ipeta ko ha nikam, a kona ha nepeta ko ha Judyo a hidi idi, a awan kam makaangay ha angayan ko. ");
INSERT INTO duo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Niyaen, bigu manon ide a ibon ko ha nikam, a maginayat kam a kona ha pinagayat ko ha nikam. Kona bila hito mina i paginayat moy. ");
INSERT INTO duo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ket nu maginayat kam a tahod, makatandiyan na ngamin a tolay a hikam i tahod a tinolduwan ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kinagi ni Simon Pedro, “Apo, hadya i angayan mo?” Ket kinagi ni Jesus, “Awan kam makauseg ha angayan ko niyaen. Ngem nokkan pala a umunod kam ha nikan.” ");
INSERT INTO duo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ket kinagi ni Pedro, “Apo, apay a awanak makauseg niyaen? Maski nu matayak gipu ha nikaw, kayat ko a umuseg.” ");
INSERT INTO duo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ket tinabbeg ni Jesus, “Ipeta mo a kayat mo a matay gipu ha nikan. Ngem ipeta ko i tahod ha nikaw, Pedro, ha palungo a magtaraok i kawitan ha yenan a kallap, ket ipamenak mo ha mamintallu a beses.” ");
INSERT INTO duo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kinagi ni Jesus ha nikami a tinolduwan na, “Awan kamon magburibur. Manahod kamon ha Dios, ket manahod kam bila ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ha bilay Nama ko, atoy i makpal a paghenan. Niyaen, umangayak a mangisagana ha paghenan moy. Awan ko ito ipeta nu awan a tahod. ");
INSERT INTO duo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ket nokkan, nu kobosan na pinangisagana ko ha paghenan moy, magsoli ak a alapan takam, penu atoy kam bila ha henan ko. ");
INSERT INTO duo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Maski niyaen, katandi moy i dilan a makaangay ha angayan ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ket kinagi ni Tomas, “Apo, awan mi makatandiyan i angayan mo! Panyan mi a katandi i dilan heya?” ");
INSERT INTO duo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ket kinagi ni Jesus, “Hikan i dilan a umangay ha Dios. Hikan la i mapagtalkan a panahodan ken pakabiyagan na totolay. Ta awan ha makaangay ha Hama, nu awan gipu ha nikan i angayan na. ");
INSERT INTO duo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nu katandi ak moy, katandi moy bila i Hama ko. Ket mangrugi ha niyaen a tiyempo, katandi moy hikuna. Ta naenta moy hikuna,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ket kinagi ni Pelipe, “Apo, ipaenta mo bi i Hama mo, penu matalak i nakam mi.” ");
INSERT INTO duo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ket kinagi ni Jesus, “Naalayak dan a nakiagum ha nikam. Ngem niyaen, Pelipe, awan mo pala makatandiyan megipu ha nikan? Ta maski nu heya a nakaenta ha nikan, naenta na bila i Hama. Isu, panyan mo a mepeta a ipaenta ko mina ha nikam i Hama? ");
INSERT INTO duo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Awan mo dod tahodan a atoyak ha Hama, ket atoy bila i Hama ha nikan a magisesa kami? Maski i kakkagi ko aye a ipeta ko ha nikam, awan ko mepeta idagende ha naknakam ko, nu awan i Hama ko heya, a maghen ha baggi ko. Hikuna i maggimet ha nakaddatan a ginemigimetan ko. ");
INSERT INTO duo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Isu, manahod kamon a atoyak ha Hama, ket atoy bila i Hama ha nikan. Nu awan moy tahodan i kakkagi ko, tahodan moy mina i nakaddatan heya. ");
INSERT INTO duo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Tahod ide a ipeta ko ha nikam. Ha maski nu heya a manahod ha nikan, maaheg na bila i gimetan ko a nakaddatan. Oni! Ket mas makpal i gimetan na nokkan. Ta sumoli ak nokkan ha Nama ko, penu daggapan takam. ");
INSERT INTO duo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ket maski nu anya i agedan moy ha Dios gipu ha nikan, igimetan takam, penu madedeyaw i Hama gipu ha gimetan ko a Annak na. ");
INSERT INTO duo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Oni, igimetan takam ha maski nu anya a agedan moy gipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Niyaen, nu ayayatanak moy, tungpalan moy i bon ko ha nikam.” ");
INSERT INTO duo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Intulos ni Jesus i kagi na ha nikami a tinolduwan na. Kinagi na, “Ide pala i gimetan ko para ha nikam. Ket magkararagak ha Nama ko, a atdinan na kam ha kasulet ko. Hikuna i magagum ha nikam, ket awan na kam lakadan. ");
INSERT INTO duo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hikuna i Espiritu na Dios, a magpakatandi ha tahod ha nikam a manahod. Ngem ha sabali a hidi a awan a manahod, awan di hikuna mapadas, ta awan di makatandiyan megipu ha nikuna. Ngem ha nikam, katandi moy dan hikuna. Ta atoy dan hikuna ha nikam. Ket nokkan paman, sumadap hikuna a maghen ha nakam moy ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ikari ko ha nikam,” kon ni Jesus, “awan takam pabiyanan. Ta magsoli ak ha nikam nokkan. ");
INSERT INTO duo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Niyaen, awan maalay, ket awan na ak maenta na totolay ha ide a lutak. Ngem ha nikam, maenta ak moy nokkan. Ket gipu ta magbiyagak manon nokkan, makabiyag kam bila. ");
INSERT INTO duo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ket nokkan, ha iday a pamalak, makatandiyan moy talaga a magisesa kami Nama ko. Ket ha nikam, atoy kam bila ha nikan, ket atoyak bila ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ha maski nu heya a magteman ken mangtongpal ha inbon ko, hikuna i tahod a magayat ha nikan. Ket ha nikuna a magayat ha nikan, ayayatan na hikuna Nama ko, ket ayayatan ko bila hikuna. Ket ipakatandi ko ha nikuna megipu ha baggi ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ket kinagi ni Judas (bakkan a ni Judas Iskaryote), “Apo, apay wade a ipakatandi mo ha nikami megipu ha baggi mo, ngem awan mo ipakatandi ha ngamin a sabali a hidi?” ");
INSERT INTO duo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ket tinabbeg ni Jesus, “Hikam i pangipakatandiyan ko ha baggi ko, gipu ta ha maski nu heya a magayat ha nikan, hikuna i magtungpal ha pagitoldu ko. Ket ayayatan na hikuna Nama ko. Ket hikami a patama i umangay ha nikuna, a makihen kami ha nikuna ha magnanayon. ");
INSERT INTO duo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ngem ha sabali a hidi a awan a magayat ha nikan, awan hidi magtungpal ha pagitoldu ko. Ket nakaman moy mina, a awan a naknakam ko i nagipuwan na pagitoldu ko aye, nu awan a naggipu ha Nama ko a nagpaangay ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ket intulos ni Jesus, “Ipeta ko idento ha nikam hanggan atoyak pala ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ngem maski nu dandani ak dan a lumakad, atoy pala i esa a paangayan Nama ko. Ket hikuna i kasulet ko, a magagum ha nikam. Hikuna i Espiritu na Dios. Ket itoldu na ha nikam i ngamin a kasapulan moy. Ket ipanakam na bila i ngamin a inpeta ko ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Isu i gipu na a awan kam mina magburibur. Ta maski nu lumakadak, iwarak ko i pangpatalna ha nakam moy. Bakkan ito a kinatalna na totolay ha lutak aye. Ta patalnaan ko i nakam moy ha bukod ko a kinatalna a makatured. Isu, awan kam mina magburibur. Ket awan kam mina manteng. ");
INSERT INTO duo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ta nateman moy i inpeta ko ha nikam, a lumakadak nokkan. Ket magsoli ak paman ha nikam. Niyaen, nu tahod a ayayatanak moy, magragsak kam mina. Ta umangayak ha Nama ko. Ket mas maturay hikuna ha langit ngem ha nikan ha lutak aye. Isu, nu makihenak ha nikuna ha iho, mas maturayak bila a aguman ko hikuna. ");
INSERT INTO duo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Niyaen, inpeta ko ito ha palungo a magimet, penu nokkan, nu nagimet dan ito, tumulos kam a manahod. ");
INSERT INTO duo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Niyaen, ballik dan i tiyempo a pamaguhon tam. Ta dandani a dumemat ni Satanas, i happo na awan a hidi a manahod. Awan na ak iturayan, ngem palobusan ko hikuna. ");
INSERT INTO duo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ta kona hito i panggep Nama ko. Ket kayat ko a makatandiyan na ngamin a tolay a ayayatan ko i Hama ko. Ide i gipu na a tongpalan ko i ngamin a ibon na Hama ha nikan,” kon ni Jesus. Sa na, kinagi, “Nay, umikat kam. Entamon.” ");
INSERT INTO duo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Niyaen, intulos ni Jesus i pagitoldu na ha nikami a tinolduwan na. Kinagi na, “Kona ha ide i pangaregan ko ha nikam. Kona a hikan i pon na kayo. Ket i Hama ko i mahagdapon ha ide a kayo. ");
INSERT INTO duo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ha tingi ko a awan magbunga, katolan Nama ko. Ket ha tingi ko a magbunga, dalusan na pala, penu mas makpal i mebunga na. ");
INSERT INTO duo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Niyaen, hikam i kona ha tingitingi a nadalus dan gipu ha kinagi ko ha nikam a tahodan moy. ");
INSERT INTO duo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Isu, tumulos kamon a manahod ha nikan. Ket maghenak dod ha nikam, a magisesa kitam. Ta kona hito ha tingitingi a hidi. Nu awan tumulos i tingi a maghen ha pon na, siyempre, awan hikuna magbunga. Ket kona bila hito ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ta hikan i kona ha pon na kayo. Ket hikam i kona ha tingitingi ko. Ha maski nu heya a tumulos a manahod ha nikan, ket maghenak ha nikuna, hikuna i magbunga ha makpal. Ta awan kam makagimet ha maski nu anya, nu makisina kam ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ket ha makisina ha nikan, hikuna i kona ha tingi a nakatol ken nalannas dan. Ket nokkan, nu mapuhon hidi a nalannas, metogbak hidi ngamin ha gangatan. Ket matutod hidi. ");
INSERT INTO duo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ngem bakkan ha nikam. Ta nu tumulos kam a manahod ha nikan, ket magtungpal kam ha pagitoldu ko, mabalin a agedan moy i maski nu anya a kayat moy. Ket meyatad ito ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Gipu ha ide i pakedeyawan Nama ko, nu magbunga kam ha makpal. Ta ide i mangpatahod a umusoseg kam ha nikan a tahod. ");
INSERT INTO duo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Niyaen, ayayatan takam a kona ha pinagayat Nama ko ha nikan. Isu, tumulos kam a manahod ha pinagayat ko ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu tungpalan moy i inbon ko, makatulos kam a makapadas ha pagayat ko ha nikam, a kona ha nikami a Patama. Ta tinungpal ko dan i inbon Nama ko, ket kanayonak a makapadas ha pinagayat na ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Inpeta ko idagento, penu makipagragsak kam ha nikan, ken penu tumulos kam a makapagragsak ha tahod a ragsak,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ket intulos na, “Ide dan i bon ko ha nikam. Maginayat kamon a kona ha pinagayat ko ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Awan ha dakdakkal a pagayat ngem ha ide, a iyatad na esa a tolay i biyag na gipu ha ilay na a hidi, penu makabiyag hidi. ");
INSERT INTO duo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ket niyaen, hikam man i ilay ko, nu tungpalan moy i bon ko ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Awan takam nagenan a tagabu ko. Gipu ha tagabu a hidi, awan di makitandiyan nu anya i panggep na Happo di. Ngem bakkan ha nikam. Ket nagenan takam ha ilay ko. Ta inpakatandi ko dan i ngamin a inpeta Nama ko ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Ngem maski nu kona hito, awan a hikam i nangpili ha nikan a ilay moy, nu awan a hikan i nangpili ha nikam. Ket pinili takam, penu atdinan takam ha tarabaho moy, ket penu tumulos kam a magbunga, ket manayon mina i bunga moy heya. Ket atdinan takam ha tarabaho moy, penu makaaged kam ha maski nu anya ha Hama ko, gipu ha nikan, ket atdinan na kam,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ket intulos na, “Ide dan i bon ko ha nikam, a maginayat kamon. ");
INSERT INTO duo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ta siyempre, sentiyan na kam na awan a hidi a manahod. Ket katandi moy a hikan i sentiyan di ha palungo. ");
INSERT INTO duo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nu ahegan moy mina hidi, a awanak moy tahodan, ket ayayatan di kam mina. Ta kakalan moy mina hidi. Ngem niyaen, bakkan i nesakopan moy. Ta pinili takam, a sinina takam ha nidi. Isu i gipu na a sentiyan di kam. ");
INSERT INTO duo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Nakaman moy i nepeta ko ha nikam idi, a ‘Awan a mas maturay i tagabu ngem ha Happo na,’ kon ko. Isu, nu linoko di ak, lolokowan di kam bila. Nu tinongpal di mina i pagitoldu ko, tungpalan di bila i pagitoldu moy. ");
INSERT INTO duo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngem awan di tinongpal i pinagitoldu ko. Isu, makatandiyan tam a lolokowan di kam gipu ha nikan, ken gipu ta awan di katandi i Hama ko a nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Nu awanak inumangay ha lutak aye, ken nagpakatandi megipu ha Dios, awan mina ha pakaliwatan di. Ngem niyaen, gipu ta inpakatandi ko ha nidi, awan ha pagpambar di ha liwaliwat di. ");
INSERT INTO duo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ha maski nu heya a magsenti ha nikan, sentiyan na bila i Hama ko. ");
INSERT INTO duo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Awan mina ha pakaliwatan di nu awan di naenta i nakaddatan a ginimet ko, a awan ha sabali a makagimet. Ngem niyaen, naenta di dan. Ket sentiyan di ak paman ken Hama ko. ");
INSERT INTO duo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ket gipu ta kona hito, natongpal i nepugto ken nesurat ha Libro na Dios. Ta kinagi na Dios idi, ‘Sentiyan di ak a awan ha gipu na.’” ");
INSERT INTO duo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ket kinagi manon ni Jesus, “Umangay ha nikam nokkan i agum moy a Espiritu na Dios. Hikuna i magpakatandi ha kinatahod. Ta paangayan ko hikuna a maggipu ha Hama. Ket ipakatandi na megipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ket hikam bila i magpakatandi megipu ha nikan. Ta nakiuseg kam ha nikan, maski idi karugi ko a mangitoldu, hanggan niyaen,” kon ni Jesus ha nikami a tinolduwan na. ");
INSERT INTO duo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Intulos ni Jesus, “Inpakatandi ko dan idento, penu makatandiyan moy i magimet ha nikam nokkan. Ta masapul a paigatan moy i panahod moy ha nikan, a awan kam gumimak a manahod. ");
INSERT INTO duo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Palakadan di kam nokkan ha sakop moy a Judyo. Oni paman, ket dumemat i tiyempo, ket atoy i kappal ha nikam a patayan di. Ket kagin di ito a pagserbe di ha Apo Dios. ");
INSERT INTO duo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ngem ide i gipu na a gimetan di ito, ta awan di kami katandi a patama. ");
INSERT INTO duo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","“Niyaen, inpeta ko ito megipu ha pagloko di, penu nokkan, nu magimet ito, manakam moy i kakkagi ko aye, ket awan maabak i panahod moy. Idi nangrugi kam a makiuseg ha nikan, awan ko kinagi i kona hito. Ta atoyak pala ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ngem niyaen, dandani dan i pagsoli ko ha Nama ko a nagpaangay ha nikan. Ket awan ha nikam a magsalodsod nu hadya i angayan ko. ");
INSERT INTO duo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Imbes na, maladinget kam dalla, gipu ha kinagi ko aye. ");
INSERT INTO duo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ngem maski nu maladinget kam niyaen, ipeta ko pala a mas mappiya i kasasaad moy nu lumakadak. Ta nu awanak lumakad, awan umangay i Espiritu na Dios a magagum ha nikam. Ngem nu lumakadak, paangayan ko hikuna ha nikam. ");
INSERT INTO duo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ket nu dumemat hikuna nokkan, ipakatandi na ha totolay megipu ha liwaliwat di. Ket ipakatandi na bila i kinalinteg megipu ha baggi ko. Ket ipakatandi na bila megipu ha paghukom na Dios ha totolay. ");
INSERT INTO duo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ipakatandi na a kelliwat hidi, gipu ta awan hidi manahod ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ket ipakatandi na bila i kinalinteg megipu ha nikan, ta magsoli ak ha Nama ko, a awanak moy manon maenta. ");
INSERT INTO duo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ket ipakatandi na paman a mahukoman mina hidi. Ta madi i kasakop di a ni Satanas, a hinukom na dan na Dios,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ket intulos na, “Atoy pala i makpal a kayat ko ipeta ha nikam, ngem awan moy pala makatandiyan. ");
INSERT INTO duo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ngem nokkan nu dumemat i Espiritu na Dios, idilan na kam ha ngamin a kinatahod. Awan hikuna magkagi a bukod na a nakam, nu awan a ipeta na i nateman na ha Nama ko. Ket ipakatandi na i magimet nokkan. ");
INSERT INTO duo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ket i kainamakan ko bila i mepaenta na nokkan ha nikam. Ta temanan na i ipeta ko ha nikuna, ket ipakatandi na ha nikam i ngamin a kayat ko kagiyan. ");
INSERT INTO duo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ha ngamin a nakam Nama ko, iday bila i nakam ko. Isu i gipu na a kinagi ko a ipakatandi na ha nikam i ngamin a kayat ko ipeta.” ");
INSERT INTO duo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ket intulos na, “Mabikan dan i pamalak a awanak moy maenta. Ket mabikan bila i pamalak a maenta ak moy manon,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Niyaen, atoy i kappal ha nikami a tinolduwan na a naginuhon hidi, “Anya i kayat na kagiyan, a mabikan dan i pamalak a awan tam hikuna maenta, kon na. Ket mabikan bila i pamalak a maenta tam manon, kon na kan. Ket gipu ta umangay kan hikuna ha Nama na, kon na. ");
INSERT INTO duo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Anya i kayat na kagiyan a ‘mabikan dan’? Panyan tam ito a makatandiyan a kinagi na,” kon di. ");
INSERT INTO duo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Niyaen, katandi ni Jesus a kayat di hikuna pagsalodsodan. Isu, kinagi na ha nidi, “Magsisinalodsod kam gipu ha kinagi ko a, ‘Mabikan dan i pamalak a awanak moy maenta. Ket mabikan bila i pamalak a maenta ak moy manon,’ kon ko. ");
INSERT INTO duo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tahod ide a ipeta ko ha nikam. Temanan moy bi. Magsanget ken magngongoyngoy kam nokkan, ngem magragsak i awan a hidi a manahod ha nikan. Niyaen, maski nu magladingit kam nokkan, magbalin a ragsak i ladinget moy. ");
INSERT INTO duo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","I pangaregan ko ha dento i esa a babbey a mageenak. Ta magladingit hikuna ha tiyempo na a paggasokan. Ngem nu neenak dan i annak na, maleptanan na babbey i rigat na, gipu ha ragsak ha annak na. ");
INSERT INTO duo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ket kona bila hito ha nikam. Ta niyaen, magladingit kam. Ngem nokkan nu mamagenta kitam manon, magragsak kam talaga. Ket perpermi i ragsak moy heya, a awan ha makapagimak ha ragsak moy heya. ");
INSERT INTO duo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ket ha iday a tiyempo, bakkan a hikan i pagagedan moy. Ta tahod a Hama ko i mangiyatad ha nikam ha maski nu anya a agedan moy, gipu ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hanggan niyaen, awan kam magaged ha Nama ko gipu ha nikan. Ngem niyaen, magaged kam mina, gipu ha panahod moy ha nikan. Ket atdinan na kam, penu perpermi i ragsak moy,” kon ni Jesus ha nikami a tinolduwan na. ");
INSERT INTO duo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ket intulos na, “Hanggan niyaen, inusar ko ha nikam i pangareg. Ngem niyaen, dandani dan i tiyempo a awan ko usaran i pangareg, nu awan madibbew i pagpakatandi ko ha nikam megipu ha Nama ko. ");
INSERT INTO duo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ket nokkan, ha tiyempo hito, hikam i magaged ha Nama ko, gipu ha panahod moy ha nikan. Ket awan a masapul a iyagedan takam ha Nama ko. ");
INSERT INTO duo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ta ayayatan na kam a mismo Nama ko. Oni, ayayatan na kam, gipu ta ayayatanak moy bila, ken tahodan moy a naggipuwak ha Nama ko. ");
INSERT INTO duo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tahod a naggipuwak ha Nama ko idi, a inumangayak ha lutak aye. Ket niyaen, lakadan ko dan ide a lutak, ta sumoli ak ha Nama ko,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ket kinagi mi a tinolduwan na, “Oni agay! Madibbew dan i kagi mo aye, ta awan mo inusar i pangareg. ");
INSERT INTO duo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Niyaen, katandiyan mi a makatandiyan mo i ngamin ha disalad na nakam mi. Ta maski nu awan taka salodsodan, katandi mo dan i nakam mi, ken anya i kayat mi a salodsodan. Ket gipu ta kona hito i pinnakabalin mo, tahodan mi i nagipuwan mo a Apo Dios,” kon mi. ");
INSERT INTO duo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ket kinagi ni Jesus, “Oni, manahod kam niyaen. ");
INSERT INTO duo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ngem dandani dan i oras a masinasina kam ngamin, ket pabiyananak moy a magisesa. Ket lumakad kam ngamin a sumoli kam ha bilabilay moy. Ngem ha kinatahod na, awanak magisesa, gipu ta atoy ha nikan i Hama ko. ");
INSERT INTO duo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Niyaen, inpeta ko ito, penu matalna i nakam moy, gipu ha panahod moy ha nikan. Ta maski nu lolokowan na kam na awan a hidi a manahod, papigsaan moy mina i nakam moy. Ta hikan i mangabak ha ngamin a kinadukas ha ide a lutak,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Idi nobos ide a pagitoldu ni Jesus, tinumangad hikuna ha langit. Ket kinagi na, “Hama, dinumemat i oras a katay ko. Niyaen, ipaenta mo bi i kainamakan na Annak mo, penu mepaenta ko bila i kainamakan mo. ");
INSERT INTO duo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ta inatdinanak mo ha pagturay ko ha ngamin a tolay, penu meyatad ko i biyag mo a magnanayon ha ngamin a tolay a panahodan mo ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ket ide i pakabiyagan di a magnanayon, basta katandi di ka, a tahod a Dios a isesa, ken katandi di ak a pinaangay mo. ");
INSERT INTO duo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Niyaen, Amang, nepaenta ko dan i kainamakan mo ha ide a lutak. Ta ginimet ko dan i ngamin a kayat mo. ");
INSERT INTO duo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Niyaen, Amang, gipu ha pagsoli ko ha nikaw, ipaenta mo bi i kainamakan ko ha langit, ha saguppang mo. Ta kona hito i kainamakan ko, idi palungo a naparsuwa i lutak, idi naghenak ha nikaw ha langit. ");
INSERT INTO duo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Niyaen, ha dagende a lallallaki a intalak mo ha nikan, inpakatandi taka ha nidi. Ta hidi i kukuwa mo, a pinasina mo hidi ha awan a hidi a manahod. Ket intalak mo hidi ha nikan. Ket niyaen, inumuseg hidi ha pagitoldu mo. ");
INSERT INTO duo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Niyaen, katandi di dan a nagipu ha nikaw i ngamin a pinagimet mo ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ta netoldu ko ha nidi i kakkagi a inpeta mo ha nikan. Ket manahod hidi ha kagi mo. Ket katandi di a tahod a nagipuwak ha nikaw. Ta tinahod di a hikaw i nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Amang, ikararagan ko hidi. Awan ko a ikararagan i ngamin a tolay ha lutak, nu awan idagende a intalak mo ha nikan. Ta hidi i kukuwa mo. ");
INSERT INTO duo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Maski nu anya a kukuwa ko, iday bila i kukuwa mo. Ket maski nu anya a kukuwa mo, kukuwa ko bila iday. Ket niyaen, gipu ha nidi, madaydeyewak dan. ");
INSERT INTO duo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Niyaen, Amang, lumakadak dan ha ide a lutak, a sumoli ak ha nikaw, ha langit. Ngem mawarak pala hidi. Mannakabalin a Hama, daponan mo bi hidi gipu ha pinnakabalin mo, penu magisesa hidi a kona ha nikita a magisesa. ");
INSERT INTO duo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta idi pakipaghen ko ha nidi, dinapon ko hidi gipu ha pinnakabalin mo a inyatad mo ha nikan. Oni ah, dinapon ko hidi. Ket niyaen, awan ha maski esa ha nidi a napukaw, malaksid ha iday a maglipot a maparusaan nokkan ha impyerno. Ta kona hito i nepapugto mo, ken nesurat ito ha Libro mo. Ket niyaen, natongpal dan ito. ");
INSERT INTO duo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Niyaen, Amang, dandani dan i pagsoli ko ha nikaw. Isu i gipu na a magkagi ak ha kona he, penu temanan na agagum ko aye, penu makipagragsak hidi ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Amang, inyatad ko ha nidi i kakkagi mo. Ket niyaen, sentiyan na hidi na awan a hidi a manahod. Ta sabali i sakop na tinolduwan ko a hidi ken sakop na awan a hidi a manahod. Ket kona bila ha nikan, a awanak umuseg ha sakop di a awan a manahod. Ket sentiyan diyak dod. ");
INSERT INTO duo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Amang, awan ko agedan a ilapos mo hidi ha ide a lutak, nu awan a daponan mo hidi ha ni Satanas. ");
INSERT INTO duo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ta awan hidi nagpasakop ha awan a hidi a manahod. Ket kona bila ha nikan, a awanak nagpasakop ha awan a hidi a manahod. ");
INSERT INTO duo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Isu, Amang, paigatan mo bi i nakam di a umunod ha nikaw. Ide a kakkagi mo a kinatahod, ito mina i pangpaigat mo ha nakam di, penu mebukod hidi ha nikaw. ");
INSERT INTO duo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Niyaen, paangayan ko hidi ha totolay a awan a manahod, a kona ha pinagpaangay mo ha nikan ha totolay a awan a manahod. ");
INSERT INTO duo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Amang, gipu ha nidi, iyatad ko ha nikaw i biyag ko, penu mebukod hidi ha pagserbe di ha nikaw,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ket intulos na, “Amang, awan la hidi i ikararagan ko, nu awan ko bila ikararagan i ngamin a manahod nokkan gipu ha pagibaheta di. ");
INSERT INTO duo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ket iyagedan ko hidi, Amang, a maging isesa mina hidi ngamin, a kona ha nikita. Ta atoy ka ha nikan, ket atoyak bila ha nikaw. Ket kona mina hito a magisesa mina hidi ha nikita, penu manahod i sabasabali a hidi a hikaw i nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Niyaen, Amang, inyatad ko ha nidi i pinnakabalin ko, a kona ha inyatad mo ha nikan i pinnakabalin mo bila, penu magisesa hidi, a kona ha pagisesa ta. ");
INSERT INTO duo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ta atoy ka ha nikan, ket atoyak ha nidi. Isu i gipu na a magisesa mina hidi, penu makatandiyan na ngamin a tolay a hikaw i nagpaangay ha nikan, ket penu makatandiyan di bila a ayayatan mo hidi a kona ha pinagayat mo ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amang, gipu ha pagayat mo ha nikan, pinadeyawak mo ha saguppang mo, idi palungo a naparsuwa i lutak. Niyaen, inyatad mo ha nikan idagende a manmanahod. Ket kayat ko a makipaghen hidi ha nikan ha paghenan ko, penu maenta di i pakedeyawan ko a atoy ha nikan idi. ");
INSERT INTO duo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nalinteg a Amang, awan na ka katandi na totolay na lutak aye. Ngem katandi taka. Ket niyaen, makatandiyan na tinolduwan ko a hidi. Ket katandiyan di a hikaw i nagpaangay ha nikan. ");
INSERT INTO duo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ta inpakatandi taka ha nidi. Ket awanak gumimak a mangipakatandi, penu magayat hidi a kona ha pinagayat mo ha nikan, ket penu atoyak pala ha nidi,” kon ni Jesus ha kararag na. ");
INSERT INTO duo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Niyaen, kobosan na pinagkagi ni Jesus ha ide, linumapos hikuna. Ket inumuseg kami a tinolduwan na. Inumahabes kami ha sapa ha Kidron, a inumangay kami ha esa a lugar a pagmulaan ha kaykayo. Hito i inangayan mi. ");
INSERT INTO duo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Niyaen, ha ni Judas a nagliput ha ni Jesus, hikuna bila i esa a makatandi ha ide a lugar. Ta makpal a beses a namagtagbo hito ni Jesus ken hikami a tinolduwan na. ");
INSERT INTO duo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Isu, niyaen, inumangay ni Judas ha ide a pagmulaan. Ket inkuyog na i kappal a sundalu ken guwardya na Templo a pinaangay na matangkay a papadi ken Pariseyo a hidi. Ket atoy silaw di, ken armas di. ");
INSERT INTO duo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ket gipu ta katandi ni Jesus i ngamin a magimet ha nikuna, sinalpak na hidi, a kinagi na, “Heya i eriyokan moy?” ");
INSERT INTO duo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ket tinabbeg di, “Ni Jesus a taga-Nasaret.” Ket kinagi ni Jesus, “Atoyak dan.” (Ket atoy bila hay ni Judas a nangliput ha ni Jesus, a nagagum hikuna ha sundalu a hidi.) ");
INSERT INTO duo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Idi kinagi ni Jesus, “Atoyak dan,” inumisol i sundalu a hidi gipu ha kanteng di, ket natumba hidi. ");
INSERT INTO duo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ket sinalodsod manon ni Jesus, “Heya i eriyokan moy?” Ket kinagi di, “Ni Jesus a taga-Nasaret.” ");
INSERT INTO duo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ket kinagi ni Jesus, “Inpeta ko a atoyak dan. Isu, nu hikan i eriyokan moy, palobusan moy a lumakad idagende a agagum ko.” ");
INSERT INTO duo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Kinagi ni Jesus ito, penu matungpal iday a inkararag na ha Nama na, a awan ha maski esa a napukaw ha intalak na Dios ha nikuna.) ");
INSERT INTO duo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Niyaen, ha ni Simon Pedro, keppalataw hikuna. Ket sinakrot na ito, ket kinatol na i tagabu na Katangkayan a Padi. Kinatol na i makinkanawan a talinga na. (Malko i nagen na iday a tagabu.) ");
INSERT INTO duo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ket kinagi ni Jesus ha ni Pedro, “Isarongan mo i palataw mo ah! Anya? Kagin mo a awan ko maattaman i rigrigat a pinanggep Nama ko?” ");
INSERT INTO duo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sa di, dinakap ni Jesus na sundalu ken kapitan di ken guwardya a hidi na Templo. Ket ginakadan di hikuna. ");
INSERT INTO duo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ket inyangay di hikuna ha ni Anas ha palungo. Ta ni Anas i manugang ni Padi Kaipas. Ket ni Kaipas i Katangkayan a Padi, ha iday a tawen. ");
INSERT INTO duo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Ni Kaipas i nangibalakad ha Judyo a hidi, a mas mappiya, kan, nu matay i esa a tolay, penu awan matay hidi ngamin. Iday i kinagi na idi.) ");
INSERT INTO duo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Niyaen, tinumagubet kami duwa a ni Simon Pedro. Ket gipu ta katandi na ak di Anas, pinalobusan diyak a makiuseg ha ni Jesus a sumadap ha paraangan na bilay na Katangkayan a Padi. ");
INSERT INTO duo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ngem nagwarak ni Pedro ha lapos, ha bikan na ruwangan. Isu, linumaposak manon a magaged ha babbey a nagdapon ha ruwangan. Ket pinalobusan na ni Pedro a sumadap. ");
INSERT INTO duo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Idi kassaddap ni Pedro, kinagi na babbey, “Hikaw wade i esa a tinolduwan na lallaki a dinakap di?” Ngem kinagi ni Pedro, “Awan.” ");
INSERT INTO duo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Niyaen, gipu ta madagmen idi, nagdukot hidi ha uging i tagabu ken guwardya a hidi. Ket nagtaknag hidi a nagendu. Ket binumikan ni Pedro a nakiendu bila. ");
INSERT INTO duo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Niyaen, ha Katangkayan a Padi, ha disalad na bilay, sinalodsod na ni Jesus megipu ha pagitoldu na ken tolay a hidi a tinolduwan na. ");
INSERT INTO duo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ket tinabbeg ni Jesus, “Awan a nepamen i pagitoldu ko. Nagitolduwak ha saguppang na ngamin, ha saguppang na kapilya moy ken ha Templo a pagpisanan na ngamin a Judyo. ");
INSERT INTO duo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Isu, apay a pilitanak mo a mangsistigu ha baggi ko? Pagsistiguan mo mina hidi a nagteman ha pagitoldu ko. Ket salodsodan mo mina hidi nu anya i nepeta ko. Siyempre, katandi di dan i kinagi ko.” ");
INSERT INTO duo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Idi kinagi na ito ni Jesus, dinapang na hikuna na esa a guwardya, a nagkagi ha, “Apay a kona hay i pinagtabbeg mo ha Katangkayan a Padi?” ");
INSERT INTO duo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ket kinagi ni Jesus ha ni Anas, “Nu nagliwatak ha kinagi ko, ipatahod mo i liwat ko, ayun ha linteg tam. Ngem nu tahod i inpeta ko, apay a pinadapangak mo?” ");
INSERT INTO duo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Isu, gipu ta awan nakatulos ni Anas ha pinagsalodsod na, pinaangay na ni Jesus, a nagakadan pala, ha ni Kaipas a Katangkayan a Padi. ");
INSERT INTO duo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Niyaen, atoy pala ni Simon Pedro a nagendu pala. Ket atoy i kappal a nagsalodsod, “Anya, hikaw wade i tinolduwan na iday a lallaki?” Ngem nagpamen ni Pedro. “Awan,” kinagi na. ");
INSERT INTO duo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ngem atoy bila hay i esa a tagabu na Katangkayan a Padi. Ket kabagiyan hikuna na lallaki a kinatol ni Pedro i talinga na. Kinagi na, “Netan taka a nagagum ha dinakap mi, ha pagmulaan ha kaykayo.” ");
INSERT INTO duo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ket nagpamen manon ni Pedro. Ket dagus a nagtaraok i esa a kawitan. ");
INSERT INTO duo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Idi nasapa pala, inlapos di ni Jesus ha bilay ni Kaipas. Ket inyangay di hikuna ha bilay ni Gobernador Pilato. Ngem madiyan di a sumadap ha bilay na. Ta ayun ha ugali na Judyo, nu sumadap i esa a Judyo ha bilay na bakkan a Judyo, mebilang hikuna a maromsa. Ket awan hikuna mapalobusan a magkan ha Piyesta na Pinagtaleban na Anghel a Magpatay. Kona hito i ugali na Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Isu, linumapos ni Pilato. Ket kinagi na, “Anya i pangpaliwatan moy ha ide a lallaki?” ");
INSERT INTO duo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ket tinabbeg di, “Nagliwat dan hikuna! Nu awan hikuna nagliwat, awan mi hikuna intugan ha nikaw.” ");
INSERT INTO duo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ket kinagi ni Pilato, “Nay kamon. Hikam i makatandi ha iday. Atoy i linteg moy a mismo. Hikam mina i manghukom ha nikuna.” Ngem tinabbeg na Judyo a hidi, “Awan a mabalin. Ta nu masapul a mapatay i esa a tolay, awan na kami palobusan na linteg moy a Romano,” kon na Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Nagimet ito penu matongpal i kinagi ni Jesus, idi inpugto na a matay hikuna a mepelansa ha kudos.) ");
INSERT INTO duo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Isu, nagsoli ni Pilato ha bilay na. Ket inayagan na ni Jesus, a kinagi na, “Anya, hikaw i hari na Judyo a hidi?” ");
INSERT INTO duo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ket sinalodsod ni Jesus, “Iday i bukod mo a nakam, onu kakkagi na Judyo a hidi megipu ha nikan?” ");
INSERT INTO duo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ket kinagi ni Pilato, “Bakkanak a Judyo. Ngem kayat ko a makatandiyan i liwat mo. Pinaliwat na ka na kailiyan mo a hidi ken matangkay a hidi a papadi. Anya dod i ginimet mo?” ");
INSERT INTO duo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ket kinagi ni Jesus, “Bakkan a ide a lutak i paggipuwan na pagturay ko a maghari. Nu naggipu i pagturay ko ha totolay, makilaban mina i nasakopan ko a hidi, penu awan na ak madakap na Judyo a hidi. Ngem bakkan a ide a lutak i paggipuwan na paghari ko.” ");
INSERT INTO duo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ket kinagi ni Pilato, “Isu, tahod ka a hari?” Ket tinabbeg ni Jesus, “Hikaw i magkagi ha ‘hari.’ Ngem ide i gipu na a inumangayak ha ide a lutak, a neenakak penu mepakatandi ko i tahod. Niyaen, ha maski nu heya a magserbe ha kinatahod, magteman hikuna ha nikan,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ket kinagi ni Pilato, “Kinatahodak! Awan ha makatandi ha kinatahod!” Ket linumapos hikuna manon ha Judyo a hidi, a kinagi na ha nidi, “Awan ha liwat na a pakaparusaan na mina. ");
INSERT INTO duo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ngem maski nu kona hito, hikam mina i magpili. Ta atoy i ugali moy a Judyo, ket palaposan ko i esa a balod ha kada Piyesta na Pinagtaleban na Anghal a Magpatay. Niyaen, heya i piliyan moy? Palaposan ko mina ide a Hari na Judyo?” kon ni Pilato. ");
INSERT INTO duo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ngem indulaw na Judyo a hidi, “Awan! Bakkan a hikuna! Ni Barrabas i kayat mi!” kon di. (Ni Barrabas aye i esa a tulisan.) ");
INSERT INTO duo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Sa na, pinabaot ni Pilato ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ket inalap na sundalu a hidi i kappal a seset. Kinawekaw di ito a ginimet di a kona ha korona. Ket indatton di ha buntok ni Jesus. Kinagayan di hikuna ha asul, ta iday i kolor na kagay na hari. ");
INSERT INTO duo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sa di, inulew hikuna, a indulaw di, “Magbiyag i hari na Judyo!” kon di. Ket dinapang di hikuna. ");
INSERT INTO duo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ket linumapos manon ni Pilato, a kinagi na ha Judyo a hidi, “Temananak moy bi. Ilapos ko hikuna ha nikam, penu makatandiyan moy a awan ko maenta i liwat na, ket awan dod ha pakaparusaan na,” kon ni Pilato. ");
INSERT INTO duo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sa di, inlapos ni Jesus, a nagkorona ha seset, ken nagtennon ha asul a kagay. Ket kinagi ni Pilato ha Judyo a hidi, “Entan moy ide a lallaki.” ");
INSERT INTO duo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ngem idi naenta na matangkay a hidi a papadi ken guwardya a hidi, indulaw di, “Pelansa moy ha kudos! Pelansa moy ha kudos.” Ket kinagi ni Pilato, “Hikam i makatandi ha iday! Hikam mina i mangilansa ha nikuna ha kudos. Ngem ha nikan, awan ko makatandiyan i pakaparusaan na.” ");
INSERT INTO duo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ket tinabbeg na Judyo a hidi, “Ha linteg mi, masapul a mapatay hikuna. Gipu ta inbilang na i baggi na a Annak na Dios.” ");
INSERT INTO duo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Niyaen, idi nateman ni Pilato i kinagi di, kinumaro i kanteng na. ");
INSERT INTO duo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sinumoli hikuna ha bilay. Ket kinagi na ha ni Jesus, “Taga-hadya ka, talaga?” Ngem awan tinumabbeg ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ket kinagi ni Pilato, “Apay a awan ka tumabbeg? Awan mo katandiyan a atoy i turay ko a mangpalakad ken mangpelansa ha kudos?” ");
INSERT INTO duo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ket tinabbeg ni Jesus, “Awan ka ha turay nu awan a inyatad na Dios ha nikaw. Isu a dakdakkal i liwat di Kaipas a nangigiwat ha nikan ha nikaw. Ta awan hidi ha turay a nagipu ha Dios.” ");
INSERT INTO duo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Idi nateman na ito ni Pilato, kaykayat na a mangpalakad ha ni Jesus. Ket pinapadas na. Ngem pinilit na Judyo a hidi, a indulaw di, “Nu palobusan mo iday a ni Jesus, magsenti ka ha hari tam ha Roma. Kasenti na hari tam i maski nu heya a maginhahari ha baggi na, a kona ha iday a lallaki.” ");
INSERT INTO duo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Idi nateman ni Pilato i kakkagi di aye, inlapos na ni Jesus. Sa hikuna, nagetnod ha pagetnodan na hukom, ha lugar a nagenan di ha, “Masimpa a Pogedu.” (Ha kagi na Judyo, “Gabata.”) ");
INSERT INTO duo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Niyaen, dandani a lubuk na pamalak, ket disperas dan na Piyesta na Pinagtaleban na Anghel a Magpatay. Ket kinagi ni Pilato ha Judyo a hidi, “Entan moy, i hari moy aye!” ");
INSERT INTO duo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ngem indulaw di, “Patayan mo! Patayan mo! Pelansa mo ha kudos!” kon di. Ket kinagi ni Pilato, “Ngem ide i hari moy! Kayat moy a pelansa ko ha kudos i hari moy aye?” Ket tinabbeg na katangkayan a padi a hidi, “Awan ha sabali a hari mi, nu awan la i hari tam ha Roma!” kon di. ");
INSERT INTO duo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ket gipu ta kona hito, inyatad ni Pilato ni Jesus ha nidi, penu melansa hikuna ha kudos. ");
INSERT INTO duo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Isu, inlapos di ni Jesus ha ili, a binaklay na i kudos a pangilansaan di. Ket inyangay di hikuna ha lugar a nagenan di ha, “Karbot.” (Ha kagi na Judyo, “Golgota.”) ");
INSERT INTO duo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hito i nangilansaan di ha nikuna ha kuros. Ket inlansa di bila i duwa a lallaki ha hikeg na. Intolnak di i kudos na esa ha kanigid ni Jesus. Ket intolnak di i kudos na nekaduwa ha makanawan na. ");
INSERT INTO duo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ket atoy bila i insurat ni Pilato a pangpakatandi ha totolay. Ket pinedatton na ha kudos. Insurat na, “Jesus, a Taga-Nasaret, i Hari na Judyo,” kon na. ");
INSERT INTO duo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ket makpal i Judyo a hidi a nagbasa ha iday a surat. Ta mabikan ha ili i lugar aye a nakelansaan ni Jesus. Ket nesurat ito ha kagi na Judyo, ken Romano, ken Griego. ");
INSERT INTO duo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ngem kinagi na katangkayan a padi a hidi, “Awan mos isurat, ‘I hari na Judyo.’ Imbes na, isurat mos, ‘Kinagi na lallaki aye a hikuna i hari na Judyo.’” ");
INSERT INTO duo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ngem kinagi ni Pilato, “Nu nesurat ko iday, nesurat dan! Awan a mabalin a pasulitan moy.” ");
INSERT INTO duo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ket ha sundalu a hidi, idi nelansa di ni Jesus, inalap di i tennon na. Ket binunong di a nagkapat. Ket inalap di bila i badu na a atakdug. Ngem awan ha saip na entero a badu na aye a atakdug. ");
INSERT INTO duo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Isu, nagkinagi hidi, “Awan tam mina pisadan ide a tennon na. Imbes na, magbibinunotan kitam, nu heya mina i mangalap,” kon di. Ket gipu ta kona hito, natongpal i pugto a nesurat ha Libro na Dios, a “Binunong di i tennon ko, ket nagbinnunotan di i badu ko,” kon na. Ket iday i ginimet na sundalu a hidi. ");
INSERT INTO duo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Niyaen, atoy bila hay, ha bikan na kudos ni Jesus, i hena na ken kabsat nena na, ken ni Maria a kabanga ni Kleopas, ken ni Maria Magdalena. ");
INSERT INTO duo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Idi naenta ni Jesus i hena na, ket naenta na ak a nakataknag ha hikeg na, kinagi na, “Entan mo, Inang. Mangrugi niyaen, mebilang a hikuna i annak mo.” ");
INSERT INTO duo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sa na, kinagi ha nikan, “Niyaen, ibilang mo a hikuna i hena mo.” Isu, mangrugi ha iday a pamalak, rinespitar mi ni Maria ha bilay mi. ");
INSERT INTO duo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Niyaen, nakatandiyan ni Jesus a nobos i ngamin a tarabaho na. Isu a kinagi na, “Mauwawak dan.” (Kinagi na ito, penu matongpal pala i esa a nesurat ha Libro na Dios.) ");
INSERT INTO duo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ket atoy hay i esa a burnay na makkak a arak. Ket nangalap hidi ha hamet, ket insawsaw di ito ha iday a arak. Sa di, indatton iday a hamet ha ontok na kayo a hisopo, ket ingiwat di ha labi na. ");
INSERT INTO duo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Idi sinapsap ni Jesus iday a arak, kinagi na, “Natongpal dan i ngamin.” Sa hikuna, tinumokam ha buntok na, ket pinalobusan na i angas na, a natay hikuna. ");
INSERT INTO duo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Niyaen, disperas dan na piyesta, ket maneg a pamalak i kaugman na. Ket maneg, nu magwarak ha kudos i bangkay na natay a hidi. Nangruna ta Piyesta na Pinegtaleban na Anghel a Magpatay, a mangina a pamalak ito. Isu, inaged di Judyo ha ni Pilato a palobusan na hidi a mangtangpod ha tikad na lallallaki a nelansa ha kudos, penu matay hidi ha sigida. Ket meyogsad hidi a melabbang mina. ");
INSERT INTO duo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Isu, dinumemat i sundalu a hidi, ket tinangpod di i tikad na duwa a tulisan heya, a kaagum ni Jesus a nelansa. ");
INSERT INTO duo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ngem idi dinumitang hidi ha ni Jesus, naenta di a natay dan hikuna. Isu, awan di tinangpod i tikad na. ");
INSERT INTO duo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ngem ginidsal na esa a sundalu i tagkang ni Jesus. Ket dagus a binumulos ha tagkang na i digi ken dinom. ");
INSERT INTO duo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Ket ha ngamin a dagento a nagimet ha ni Jesus, hikan i nakaenta. Niyaen, mesurat ko ito, penu manahod kam bila. Ta sigurado ak a tahod ito ngamin. Naenta ko i ngamin.) ");
INSERT INTO duo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ket nagimet bila idento, penu matongpal i nesurat ha Libro na Dios, a “Awan matangpod i maski esa a tulang na.” ");
INSERT INTO duo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ket nesurat bila, “Aamatan di hikuna a ginidsal di,” kon na Libro na Dios. ");
INSERT INTO duo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Niyaen, kobosan na iday, inumangay ni Jose a Taga-Arimatea ha ni Pilato. Ket inaged na i bangkay ni Jesus. Ha ni Jose aye, nanahod hikuna ha ni Jesus a nalimid, ta nanteng hikuna ha Judyo a hidi. Niyaen, inpalobus na hikuna ni Pilato. Isu, inumangay ni Jose, ket inalap na i bangkay ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ket inumuseg ni Nikodemo a inyangay na i manga tallu a pulo a kilo na bangbanglo a mirra ken aloe. (Ide a Nikodemo i inumangay ha ni Jesus idi ha kallap.) ");
INSERT INTO duo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ket inalap di i bangkay ni Jesus, ket binadbadan di ha maponset a hamet, pati i bangbanglo heya. Ta kona hito i ugali na Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Niyaen, ha iday a lugar a nakelansaan ni Jesus, atoy bila i pagmulaan ha kakkayo. Ket atoy hito i bigu a kuweba a paglabbangan a awan pala ha nelabbang. ");
INSERT INTO duo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Isu, gipu ta disperas dan, ken gipu ta mabikan iday a kuweba, intagmak di i bangkay ni Jesus ha ihay. ");
INSERT INTO duo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Niyaen, idi Dominggo dan, ket madiham pala, inumangay di Maria Magdalena ha labbang. Ket naenta di a nelukat i labbang, a naadya dan i pogedu a nangkallab di ha kuweba. ");
INSERT INTO duo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Isu, nagbuyot hidi a inumangay ha nikan ken ni Simon Pedro. Ket kinagi ni Maria, “Inalap di dan i bangkay na Happo tam! Awan mi makatandiyan nu hadya i nangiangayan di!” ");
INSERT INTO duo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Isu, nagsigida kami a mangenta ha labbang. ");
INSERT INTO duo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Parehas kami a nagbuyot, ngem mabaksagak ngem ni Pedro, a nakaabot ha labbang a palungo. ");
INSERT INTO duo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ket sinumedippak ha kuweba aye, ket naenta ko iday a maponset a hamet. Ngem awanak sinumdap. ");
INSERT INTO duo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sa, nakaabot ni Simon Pedro. Ket sinumadap hikuna ha labbang. Ket inaamatan na iday a maponset a hamet, ");
INSERT INTO duo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ken iday a nebadbad idi ha buntok ni Jesus. Ngem awan a nelaok ito ha henan na maponset a hamet, nu awan a nebadbad pala a nebukod ha henan na. ");
INSERT INTO duo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sa ak, sinumadap bila. Ket idi naenta ko idento a hamet, nanahodak a minagbiyag manon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ta idi tiyempo a ito, awan mi nakatandiyan i nesurat ha Libro na Dios, a masapul a magbiyag manon i Cristu.) ");
INSERT INTO duo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sa kami, sinumoli ha bilay mi. ");
INSERT INTO duo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ngem nagwarak ni Maria Magdalena ha lapos na labbang, a nakangngoyngoy hikuna. Ket nagsedip hikuna a nangenta ha disalad na. ");
INSERT INTO duo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ket naenta na i duwa a anghel a nakapuraw, a nakaetnod ha henan na bangkay ni Jesus idi. Inumetnod i esa ha buntokan na, ket esa ha uyadan na. ");
INSERT INTO duo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ket kinagi di ha ni Maria Magdalena, “Wadi ko, apay a magngongoyngoy ka?” Ket tinabbeg na, “Oni, ta inalap di i bangkay na Happo ko, ket awan ko katandi nu hadya i nangiangayan di.” ");
INSERT INTO duo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Idi nakagi na ito ni Maria Magdalena, sinumoleg hikuna, ket naenta na ni Jesus a nakataknag hay. Ngem awan na hikuna nelassin. ");
INSERT INTO duo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ket kinagi ni Jesus, “Wadi ko, apay a magngongoyngoy ka? Heya i eriyokan mo?” Ket gipu ta kagin na a hikuna i mahagdapon ha pagmulaan aye, kinagi ni Maria Magdalena, “Apo, nu hikaw i nangalap ha bangkay na, ipeta mo bi nu hadya i nangiangayan mo, penu alapan ko.” ");
INSERT INTO duo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sa, kinagi ni Jesus, “Maria.” Ket sinumaggupang ni Maria, a kinagi na ha kagi na Judyo, “Rabboni!” (Kayat na kagiyan ito, “Maestro.”) ");
INSERT INTO duo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ket kinagi ni Jesus, “Awanak mo egkaman, ta awanak pala inumontok ha Nama ko. Niyaen, sumoli ka dan, a ibaheta mo ha agagum tam a umontokak ha Dios a Hama ko. Ket niyaen, hikuna i Hama moy bila ken Dios moy bila,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Isu, simmoli ni Maria Magdalena ha nikami a tinolduwan ni Jesus. Ket kinagi na, “Naenta ko dan i Happo tam.” Ket inbaheta na i kakkagi ni Jesus ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Idi kallap na iday a pamalak a Dominggo, napisan kami a tinolduwan ni Jesus. Neserado i ruwangan a hidi, gipu ta nanteng kami ha happo na Judyo a hidi. Ket bigu la a nagpaenta ni Jesus, a nakataknag ha lubuk mi. Ket kinagi na, “I talna na Dios i kumuyog.” ");
INSERT INTO duo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ket idi kinagi na ito, inpaenta na i kamat ken tagkang na. Ket nagragsak kami unay ha pinakaenta mi ha Happo mi aye. ");
INSERT INTO duo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ket kinagi manon ni Jesus, “I talna na Dios i kumuyog ha nikam. Niyaen, paangayan takam a kona ha pinagpaangay nikan Nama ko.” ");
INSERT INTO duo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Idi kinagi na ito, iniyopan na kami. Ket kinagi na, “Alapan moy i Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Niyaen, nu atoy i pakawanan moy i liwat na, mapakawan dan hikuna. Ket nu atoy i awan moy pakawanan, awan hikuna mapakawan,” kon ni Jesus ha nikami a paangayan na. ");
INSERT INTO duo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ngem idi nagpaenta ni Jesus ha nikami, awan ni Tomas, a nagenan mi ha “Kambal”. Maski nebilang hikuna ha nikami a esapulo ket duwa a tinolduwan ni Jesus, awan man hikuna idi. ");
INSERT INTO duo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Isu, inbaheta mi ha nikuna, “Agay, naenta mi i Happo tam.” Ngem kinagi na, “Awanak manahod, nu awan ko maenta ken makahap i peklat na lansa ha kamat na, onu makahap ko i talingo ha tagkang na,” kon ni Tomas. ");
INSERT INTO duo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Idi nobos i makadominggo, napisan kami manon ha disalad na bilay, pati ni Tomas. Ket neserado i ruwangan a hidi. Ngem maski nu neserado hito, dinumemat manon ni Jesus a tinumaknag ha lubuk mi. Ket kinagi na, “I talna na Dios i kumuyog.” ");
INSERT INTO duo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sa na, kinagi ha ni Tomas, “Nay. Egkaman mo i kamat ko he, ket kahapan mo i tagkang ko. Awan kas magduwaduwa, nu awan ka a manahod.” ");
INSERT INTO duo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ket tinabbeg ni Tomas, “Agay, hikaw i Happo ko ken Dios ko!” ");
INSERT INTO duo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ket kinagi ni Jesus, “Manahod ka niyaen gipu ta neta ak mo. Ngem ipeta ko a maragsak i manahod a hidi, maski nu awan di ak meta.” ");
INSERT INTO duo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Niyaen, makpal pala i nakaddatan a pangtiplad na, a ginimet ni Jesus ha saguppang mi a tinolduwan na. Ngem awan ko hidi nesurat ha ide a libro. ");
INSERT INTO duo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ngem insurat ko dan idagende, penu manahod kam ha ni Jesus, a hikuna i Cristu, a Annak na Dios, ket penu makabiyag kam ha magnanayon gipu ha panahod moy ha nikuna. ");
INSERT INTO duo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Idi kobosan na ide, magpaenta manon ni Jesus ha nikami, ha Diget a Tiberiyas. Kona ha ide i pinagpaenta na. ");
INSERT INTO duo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Atoy kami ni Simon Pedro, ken ni Tomas a managenan ha “Kambal,” ken ni Natanael a taga-Kana, ha Galileya, ken hikami a magkabsat, a annak ni Sebedeyo, ken duwa pala a tinolduwan ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ket kinagi ni Simon Pedro ha nikami, “Umangayak a magsigay.” Ket kinagi mi, “Umuseg kami bila.” Ket nagsakay kami ha abang mi. Ngem pulos, a awan ha naalap mi a kinabgawan. ");
INSERT INTO duo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Idi hinumangkat i senggit, nagtaknag ni Jesus ha baybay. Ngem awan mi hikuna nelassin. ");
INSERT INTO duo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ket indulaw ni Jesus, “Nakaalap kam?” Ket tinabbeg mi, “Pulos, awan.” ");
INSERT INTO duo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ket kinagi na, “Ipakat moy i sigay ha makanawan na abang moy, ket atoy hay i maalap moy.” Isu, inpakat mi i sigay mi, ket makpal i naalap mi, hanggan awan mi kaya a inyakdet, gipu ha kakpal na padut heya. ");
INSERT INTO duo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ket kinagi ko ha ni Pedro, “Agay! Iday i Happo tam!” kon ko. Idi nateman ni Simon Pedro a atoy ni Jesus ha baybay, nagbadu hikuna (ta nageklas hikuna a nagsigay). Ket ginumutap hikuna a tinumagsat. ");
INSERT INTO duo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ngem nagwarak kami ha abang, a nangiyakdet ha sigay a naputat ha padut. Ta awan kami madiyo ha baybay. Manga esa gasut a metro la. ");
INSERT INTO duo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Idi kaawas mi ha baybay, naenta mi i gangatan na uging, ken padut a meapoy pala, ken tinapay. ");
INSERT INTO duo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ket kinagi ni Jesus, “Iyangay moy he i kappal a padut a naalap moy.” ");
INSERT INTO duo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Isu, inumangay ni Simon Pedro ha abang. Ket intagsat na i sigay a naputat ha dadakkal a padut. Esa gasut, limapulo ket tallu hidi. Ket uray makpal unay hidi, awan a napisad i sigay mi. ");
INSERT INTO duo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ket kinagi ni Jesus, “Nay. Magkan kitamon,” kon na. Niyaen, ha nikami a tinolduwan na, awan ha nagsalodsod nu heya hikuna. Ta masaniki kami. Ket katandi mi a hikuna i Happo mi. ");
INSERT INTO duo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Isu, binumikan ni Jesus, ket inalap na i tinapay ken padut. Sa na, inyatad ha nikami. ");
INSERT INTO duo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iday i nekatallu a pinagpaenta ni Jesus ha nikami, idi nobos i pinagbiyag na manon. ");
INSERT INTO duo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Idi nobos kami a magkan, sinalodsod ni Jesus ni Simon Pedro, “Simon a annak ni Juan, dakdakkal i pinagayat mo ha nikan ngem pinagayat di?” Ket tinabbeg ni Pedro, “Oni, Apo. Katandi mo a hikan i ilay mo.” Ket kinagi ni Jesus, “Daponan mo bi hidi a manahod ha nikan. Ta kukuwa ko hidi. Ket kona hidi ha urbon na karnero.” ");
INSERT INTO duo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ket inpinduwa manon ni Jesus, a sinalodsod na, “Simon a annak ni Juan, ayayatanak mo?” Ket tinabbeg ni Pedro, “Oni, Apo, katandi mo a hikan i ilay mo.” Ket kinagi ni Jesus, “Daponan mo bi i karnero ko a hidi.” ");
INSERT INTO duo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sa, ha nekatallu a salodsod ni Jesus, kinagi na, “Simon a annak ni Juan, hikaw i ilay ko?” Niyaen, nagladingit ni Pedro, gipu ta nekatallu dan a salodsod ni Jesus, a “Hikaw i ilay ko?” Ket tinabbeg ni Pedro, “Apo, katandi mo i ngamin a bagay. Ket niyaen, naenta mo a hikan i ilay mo.” Ket kinagi ni Jesus, “Daponan mo bi i karnero ko a hidi. ");
INSERT INTO duo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tahod ide a ipeta ko ha nikaw. Temanan mo bi. Idi annak ka pala, hikaw i nagtennon ha baggi mo. Ket inumangay ka ha maski nu hadya a kayat mo. Ngem nokkan, nu lakay ka dan, mangiyuyad ka ha labunogen mo a hidi. Ket atoy i mangbadbad ha baggi mo. Ket iyangay di ka ha awan mo kayat a angayan.” ");
INSERT INTO duo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Kinagi na ito ni Jesus, a pangpakatandi na nu panyan na katay ni Pedro ken pakedeyawan na Dios.) Sa, kinagi ni Jesus ha ni Pedro, “Umunod ka ha nikan.” ");
INSERT INTO duo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ket sinumoleg ni Pedro, ket naenta na ak a inumunod ha nikuna ken ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Idi naenta na ak, kinagi ni Pedro, “Apo, anya ha ide a lallaki? Maanya wade nikuna?” ");
INSERT INTO duo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ket kinagi ni Jesus, “Nu kayat ko a magbiyag hikuna hanggan ha kasoli ko, awan ka ha pakatandiyan. Basta umunod ka ha nikan.” ");
INSERT INTO duo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ket gipu ha ide a kinagi ni Jesus, nagboyboyan na manahod a hidi a awanak matay, kon di. Ngem awan kinagi ni Jesus a awanak matay, nu awan i kinagi na, a “Nu kayat ko a magbiyag hikuna hanggan ha kasoli ko, awan ha pakibiyang mo,” kon na. Iday man i kinagi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Niyaen, hikan i nangsistigu ken nangisurat ha dagento a bagbagay. Ket katandi mi a tahod i ngamin a insurat ko aye. ");
INSERT INTO duo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ket makpal pala i ginimet ni Jesus, a awan ko insurat. Ta nu mesurat hidi ngamin, baka maputat i lutak aye ha ngamin a liblibro a pakesuratan di.");
INSERT INTO duo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ide i surat ko para ha ni Teopilo a ilay ko. Nesurat ko ha libro ko a nekaesa i ngamin a ginimet ni Jesus, ken netoldu na, hanggan ha pamalak a pinangiyunek na Dios nikuna ha langit. ");
INSERT INTO duo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Idi kobosan na katay na, ken pinagbiyag na manon, idi awan pala hikuna nepaunek ha langit, nagpaenta ni Jesus ha toltolduwan na. Ket makpal i pinangpatahod na a minagbiyag manon i baggi na. Ta nakangpaenta hikuna ha lubuk na uppat a pulo a pamalak. Ket naenta di ni Jesus, ket gipu ha Espiritu na Dios, atoy i inyatad na ha apostol a hidi a pinili na, inatadan na hidi ha tarabaho di. Ket intoldu na ha nidi megipu ha paghariyan na Dios. ");
INSERT INTO duo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Niyaen, idi esa a pamalak, idi nakipagpisan hidi, inbon ni Jesus ha nidi, “Awan kam pa lumapos ha Jerusalem,” kinagi na. “Urayan moy pa ta inkari na Hama ko a pagatad na ha nikam ha Espiritu na Dios. Ide i nepakatandi ko ha nikam nikuna. ");
INSERT INTO duo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nikuna, i pinangbinyag ni Juan i dinom. Ngem niyaen, dandani dan a mabinyagan kam ha Espiritu na Dios. Ket tulos, maghen hikuna ha baggi moy,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Niyaen, idi esa a pamalak, nagsalodsod hidi a nakipagpisan, “Apo, tiyempo dan niyaen a pangadya mo ha Romano a hidi ha bayan tam? Anya, mesoli i pagturay tam a Judyo ha Israel?” kon di. ");
INSERT INTO duo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ngem kinagi ni Jesus, “Kabeng mon iday agay. I Hama ko i makatandi ha tiyempo a pagtongpal na i ngamin a panggep na. Ket awan na kam palobusan a makatandi ha tiyempo na. ");
INSERT INTO duo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ngem katandi moy mina ide, a nokkan, nu sumadap i Espiritu na Dios ha baggi moy, atoy ha nikam i kaddat na Dios. Ket gipu ha ide, hikam i mangpatahod ken magibaheta megipu ha nikan ha Jerusalem, ken ha Judeya, ken ha Samariya, a hanggan ha ngamin a lugar ha lutak,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Idi kinagi ni Jesus ito, nepaunek hikuna ha langit. Ket tinattangad di pala hikuna hanggan natakbunan hikuna ha ulap. ");
INSERT INTO duo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Idi tattangadan di pala, bigu la a nakataknag ha bikan di i duwa a nagtennon ha pasig la maponset. ");
INSERT INTO duo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kinagi di, “Hikam a taga-Galileya, apay a tumattangad kam pala ha langit? Ha ide a ni Jesus a nepaunek ha langit, magsoli hikuna nokkan. Kasoli na bila a kona ha naenta moy a nepaunek,” kon na nagtennon a hidi ha maponset. ");
INSERT INTO duo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sa hidi, sinumoli i apostol a hidi ha Jerusalem a naggipu ha ide a parabin na Olibo. I kaadiyo na Jerusalem ha Olibo, manga esa a kilometro. ");
INSERT INTO duo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ket tinumulos hidi a umunek ha kuwarto ha bilay a paghenan di, hidi ni Pedro, ni Juan, ni Santiyago ken ni Andres, ni Pelipe ken ni Tomas, ni Bartolome ken ni Mateo, ni Santiyago a annak ni Alpeyo, ni Simon Tured, ken ni Judas a annak ni Santiyago. ");
INSERT INTO duo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ket kada pamalak, nagesesa hidi a magkararag, pati i babbey a hidi ken ni Maria a hena ni Jesus, ken dagenday a lallaki a wadi ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Idi kobos na kappal a pamalak, nakipaggimmong i manmanahod a hidi, a manga esa gasut ket duwa a pulo hidi. Ket tinumaknag ni Pedro, a kinagi na, ");
INSERT INTO duo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kakabsat ko, awan a mabalin a awan matongpal i kakkagi na Dios a nesurat. Ta nikuna, pinapugtowan na Espiritu na Dios ni Hari Dabid megipu ha ni Judas, a nangigiya ha nidi a nangdakap ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Idi palungo, nebilang ni Judas ha nikami a esa pulo ket duwa, a pinili na bila hikuna ni Jesus a magagum mina ha pagserbe mi. ");
INSERT INTO duo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Ngem madukas i ginimet ni Judas a nagliput ha ni Jesus. Ket nagmunas hikuna. Ket idi natakneg i baggi na, pinumduk i tiyan na, ket newalagenak i sirat na. Ket gipu ha kinatay ni Judas a kona hito, inalap di iday a korinat a pinangbayad di ha nikuna para ha pinagliput na, ket ginatang di i talon a nakatayan na. ");
INSERT INTO duo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Idi nabahetaan na kakaili na ha Jerusalem, pinanagenan di i talon aye ha Akeldama. Ha kagi di, i kayat na kagiyan a ‘Talon na Digi’.” ");
INSERT INTO duo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ket tinumulos ni Pedro, “Iday i pinapugto na Dios nikuna, ket nesurat ha Libro na Kakansiyon. Nesurat a, ‘Pabiyanan mina i naghenan na, a awan mina ha maghen hito. Ket nesurat bila, a Sumulet mina i sabali, a magubos ha biyang na,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Isu,” kon ni Pedro, “magpili kitam mina ha esa a kasulet ni Judas a magagum ha nikami a esa pulo ket esa. Aguman na kami mina a magpatahod a minagbiyag manon ni Apo Jesus. Ket ha ide a kasulet ni Judas, masapul hikuna a nakanguseg ha ni Apo Jesus, maski idi pinakangbunyag ni Juan, hanggan nepaunek ni Jesus ha langit,” kon ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ket atoy duwa a lallaki a pinasaguppang di. I esa, a ni Jose. I sangay na, a ni Barsabas Husto. Ket i nekaduwa a ni Matiyas. ");
INSERT INTO duo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ket nagkararag hidi ha, “Apo, katandiyan mo i nakam na ngamin a tolay. Isu, itoldu mo bi ha nikami nu heya i piliyan mo, ");
INSERT INTO duo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a sumulet ha biyang na kinaapostol. Ta nagtallekod ni Judas, ket inumangay hikuna ha impyerno,” kon di. ");
INSERT INTO duo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Idi nobos i kararag di, nagbabinnunot hidi nu heya mina i piliyan di. Ket ni Matiyas i napili. Ket hikuna dod i nenayon ha esa pulo ket esa a apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kobosan na esa a pulo a pamalak hanggan inumunek ni Jesus ha langit, ket dinumemat i Piyesta na Pentekostes. Ket nagpisan i ngamin a manahod ha ni Jesus ha esa a bilay. ");
INSERT INTO duo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ket bigu la a nateman di i tanog a naggipu ha langit, a kona ha tanog na pahas a mapigsa. Ket matnog unay ha lubuk na bilay a naghenan di. ");
INSERT INTO duo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sa di, naenta i bagbagay a kona ha gangatan a tinumupo ha kada esa ha nidi. ");
INSERT INTO duo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ket sinumadap i Espiritu na Dios ha baggi di ngamin. Tulos, nagkagi hidi ha sabasabali a kakkagi, ayun ha pinnakabalin na Espiritu na Dios ha nidi. ");
INSERT INTO duo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Niyaen, ha iday a pamalak, atoy i makpal a Judyo a makidios a nagpasyal ha Jerusalem a nagipu ha sabasabali a bayan. ");
INSERT INTO duo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Idi nateman di i tanog aye, binumikanan hidi. Ket nasbew hidi ngamin, ta nateman na kada esa i bukod na a kagi a kinagi na manahod a hidi. ");
INSERT INTO duo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ket nalaktat hidi a binumikanan, a nagsina hidi ha, “Apay a kona hito i kakkagi di? Taga-Galileya hidi! ");
INSERT INTO duo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Panyan di a makakagi ha bukod tam a kagi, a taga sabasabali a bayan? ");
INSERT INTO duo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ha nikitam aye, atoy i kappal a taga-Partiya, ken kappal a taga-Medo, ken rugrugar na Elam, ken Mesopatamiya, Judeya, Kapadosiya, Ponto, Asia, ");
INSERT INTO duo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirgiya, Pampiliya, Egipto, ken Libya a mabikan ha Sirena. Ket atoy bila i kappal a taga-Roma, ");
INSERT INTO duo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","maski Judyo ken maski agagum di a bakkan a Judyo, a nagpasakop ha relihiyon na Judyo. Ket atoy bila i kappal a taga-Kreta, ken Arabiya. Ngem uray nu kona hito a sabasabali i kakkagi tam, mateman tam a makakagi hidi ha bukod tam a kagi. Ket mebaheta di a megipu ha ginimet na Dios.” Ide i kinagi na kakpalan aye. ");
INSERT INTO duo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nalaktat ken nasbew hidi, a tinumulos hidi a magsalodsod ha, “Apay a kona hito a katandiyan di i ngamin a kakkagi a taga sabasabali a bayan?” kon di. ");
INSERT INTO duo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ngem atoy bila i sabali a totolay, ket nagulew hidi ha nidi a manahod. Kinagi di, “Nabartek dalla hidi!” ");
INSERT INTO duo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sa, sinumaggupang i esa pulo ket duwa a apostol a hidi. Ket nagkagi ni Pedro ha mapigsa a timek na, “Hikam a kakalan ko a Judyo, ken hikam a maghen ha Jerusalem aye, atoy i kayat ko ipeta ha nikam. Temanan moy bi, ta mepakatandi ko ha nikam i nagimet aye. ");
INSERT INTO duo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kagin moy a nabartek i agagum ko aye. Ngem awan man! Alas nuwebe pala na maledum! ");
INSERT INTO duo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Imbes na, ide i inpapugto na Dios gipu ha ni Joel, a minahagpugto nikuna a naalay dan. Kinagi na, ");
INSERT INTO duo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nokkan ha dilokod a tiyempo,’ kon na Dios, ‘iyasak ko i Espiritu ko ha ngamin a kalase a tolay. Ket mangipugto hidi. Maski nu babbey a hidi, onu lallaki a hidi. Mangipugto hidi a magkagi ha kakkagi ko. Ket maski nu lakay hidi, onu olitaw pala. Atoy i ipaenta ko ha olitaw a hidi, ha disalad na nakam di. Ket pagtagenapan ko i laklakay, penu katandiyan di i gimetan ko. ");
INSERT INTO duo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Oni! Iyasak ko i Espiritu ko ha maski nu heya a magserbe ha nikan, maski nu madibbi a babbey onu lallaki, ket papugtowan ko hidi a magkagi ha kakkagi ko. ");
INSERT INTO duo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ket gimetan ko bila ide, a atoy nokkan ha langit ken ha lutak i pangpasabbew a ipaenta ko ha totolay. Ha lutak aye, atoy nokkan i makpal a digi ken gangatan ken asok. ");
INSERT INTO duo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ket ha langit, dumiklam i senggit, ket magbalin i bulan a madideg, a kona ha digi. Ket nu kona hito nokkan, dandani dan a dumemat i pamalak a pangparusa ko ha ngamin a tolay a magliwat. ");
INSERT INTO duo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ngem maski nu heya a makiaged ha nikan ha, Apo, isalakanak mo bi, mesalakan hikuna.’” Ito i inpapugto na Dios. ");
INSERT INTO duo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tinumulos ni Pedro a kinagi na, “Hikam a kababayan ko a Judyo, temanan moy i kakkagi ko a megipu ha ni Jesus a taga-Nasaret. Pinaangay na hikuna na Dios. Makatandiyan tam a naggipu hikuna ha Dios, ta inpaenta na Dios i ginimet na gipu ha ni Jesus. I ginimet na i makpal a milagro ken tiplad a nangpasabbew. Ket naenta moy idagende, ta nagimet na hidi ha saguppang moy. ");
INSERT INTO duo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Niyaen, kona ha negiwat na Dios ni Jesus ha pagturayan moy, gipu ha pinanggep na. Ket kona a hikam man i nagpatay ha ni Jesus, ta hikam i nagpelansa ha nikuna ha kudos, idi inlansa na gangannaet a hidi a taga-Roma. ");
INSERT INTO duo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ngem uray nu kona hito ha ni Jesus, pinabiyag na manon na Apo Dios. Ket kona ha inokkasan na ni Jesus a naggipu ha natay. Ta awan ha turay na katay ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ta ide bila i nepugto ni Hari Dabid nikuna. Nepugto na i kakkagi ni Cristu, a ‘Kanayon a maenta ko a magagum i Apo Dios ha nikan. Awan hikuna umadiyo ha nikan. Isu a awanak manteng. ");
INSERT INTO duo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Maragsak i nakam ko, ket magragsakak ha kakkagi ko. Ta katandi ko a maski nu matayak, atoy pala i Apo Dios, ");
INSERT INTO duo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ket mapabiyag na manon i baggi ko. Katandi ko a awan na ak pabiyanan ha lugar na natay a hidi. Awan na palobusan a mahunot i baggi ko ha labbang. ");
INSERT INTO duo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ta inpakatandi na ha nikan a magbiyagak ha magnanayon. Ket paragsakan na ak, ta hikuna i agum ko.’” ");
INSERT INTO duo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tinumulos ni Pedro, “Kakabsat ko, palobusanak moy a mangipeta megipu ha ni Hari Dabid, i matangkay a apo tam. Makakatandi kitam a maski ni Apo Dabid, natay bila hikuna, ket nelabbang i baggi na. Ta atoy i nelabbangan na ha he, ha Jerusalem, hanggan niyaen. ");
INSERT INTO duo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Niyaen, gipu ta hikuna i esa a minahagpugto, nakatandiyan na perpermi i nepeta na Dios ha nikuna. Ket inkari na Dios ha nikuna a atoy nokkan i apo na a magtawid ha paghariyan na, ket maghari a kona ha ni Dabid. ");
INSERT INTO duo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Niyaen, inpugto ni Dabid i pinagbiyag manon ni Cristu a nagipu ha natay, a kinagi na, ‘Awan hikuna mapabiyanan ha lugar na natay a hidi. Ket awan mahunot i baggi na ha labbang.’” ");
INSERT INTO duo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Niyaen,” kagi ni Pedro, “ni Jesus a mismo i pinabiyag manon na Dios. Ket naenta mi dan a minagbiyag manon hikuna. ");
INSERT INTO duo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Isu, napaontok hikuna ha henan na Dios a magturay. Ket atoy pala i inyatad na Dios ha nikuna. Ta inkari na Dios a gipu ha ni Jesus, paangayan na i Espiritu na Dios ha totolay. Ket ide a naenta ken nateman moy, a tanog na pahas ken gangatan ken pagibaheta mi ha bukod moy a kagi, idagento i paggimi-gimet na Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Maski ha ni Hari Dabid, awan hikuna napaunek a magturay ha langit. Ngem nepugto pala ni Dabid, a ‘Atoy i kinagi na Apo Dios ha Hapo ko, a “Umetnod ka ha henan ko, ");
INSERT INTO duo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hanggan pagparentumengan ko i kasenti mo a hidi ha saguppang mo he.”’” ");
INSERT INTO duo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Niyaen,” kagi ni Pedro, “masiguradowan mina i ngamin a tolay ha Israel a ide a ni Jesus, hikuna i Cristu a pinaghari na Dios ha ngamin a totolay. Ngem hikuna man bi i binuno moy, a pinabiyan moy hikuna a matay ha kudos,” kon ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Niyaen, idi nateman na kakpalan i kinagi ni Pedro, nariribuk i nakam di, a nagbabawi hidi, ket sinalodsod di ha di Pedro ken agagum na a apostol, “Kakabsat, anya mina i gimetan mi?” ");
INSERT INTO duo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ket kinagi ni Pedro, “Magbabawi kam ha liwaliwat moy. Ket magpabinyag kam a kona ha pangtiplad moy a masakop kam ha ni Jesu-Cristu. Ket nu kona hito i pagbinyag ken pagbabawi moy, mapakawan i liwaliwat moy. Ket iyasak na ha nikam i Espiritu na Dios, a iyatad na Dios ha nikam. ");
INSERT INTO duo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ta ide i inkari na Dios ha nikitam, ken ha annak tam a hidi, ken maski ha nidi a maghen ha sabali a lugar a madiyo. Iyatad na Dios i Espiritu na ha maski nu heya a ayagan na a makiuseg ha nikuna.” ");
INSERT INTO duo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ito i kinagi ni Pedro. Ket makpal pala i kinagi na, penu manahod mina hidi ha ni Jesu-Cristu. Ket iniwadan na bila hidi. Kinagi na, “Isalakan moy mina i baggi moy, penu awan kam maparusaan nokkan. Ta atoy i parusa a dumemat ha dagende a tolay a makillu, ta makpal i liwaliwat di. Ket magmadi hidi ha kinatahod,” kon ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Sa, makpal hidi a nanahod ha kakkagi na, ket nagpabinyag hidi. Atoy manga tallu a ribu a tolay a nenayon ha nidi a manahod ha iday a pamalak. ");
INSERT INTO duo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tulos, a naguseg hidi ha kada pamalak ha pagitoldu na apostol a hidi, ket nakipagagum hidi perpermi. Ket nagpisan hidi ha kada pamalak a makipagkan ken magkararag. ");
INSERT INTO duo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Atoy idi i makpal a milagro a ginimet na apostol a hidi. Makpal i pinangpatahod di. Ket nalaktat i ngamin a tolay ha dagenday a nagimigimet. ");
INSERT INTO duo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ket ha nidi a manahod, namagpisan hidi perpermi, ket nagbunong hidi ha ngamin a aruwatan di. ");
INSERT INTO duo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ket nu atoy i agagum di a napobre, inlako di i lutak di, onu aruwatan di, penu meyatad di i korinat ha agagum di a napobre, ayun ha masapul na kada esa. ");
INSERT INTO duo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ket ha kada pamalak, nagesesa hidi a nagpisan ha Templo. Ket binunong di i kanan di, ket nakipagkan hidi ha bilabilay di a maragsak. ");
INSERT INTO duo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ket intulos di a nagdeydeyaw ha Apo Dios. Ket maski i sabali a totolay a nagmadi a manahod, mappiya i nakam di ha nidi a manahod. Ket idi kada pamalak, atoy pala i totolay a kayat a manahod. Ket nenayon na hidi na Dios ha nidi a insalakan na. ");
INSERT INTO duo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Idi esa a pamalak, idi alas tres, inumangay ni Pedro ken ni Juan ha Templo, ta iday i oras a pangkararag. ");
INSERT INTO duo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ket atoy hay i esa a lallaki a pinilay. Pinilay hikuna ha pinakenak na. Ket idi kada pamalak, intugan na hikuna na agagum na, a intagmak di ha lugar a managenan ha “Inaamakan a Ruwangan”. Ket i kagay na i makilaban ha maski nu heya a sumadap ha ide a ruwangan na Templo. ");
INSERT INTO duo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Idi naenta na ni Pedro ken ni Juan a sumasaddap, nakilimos hikuna ha nidi. ");
INSERT INTO duo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nangamata hidi ha ni pilay, sa na, kinagi ni Pedro, “Agay, entan mo kami!” ");
INSERT INTO duo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Isu a nangenta hikuna ha nidi, a tinumahok a limosan di. ");
INSERT INTO duo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ket kinagi ni Pedro, “Awan ha korinat ko, ngem atoyak ha sabali a iyatad ko ha nikaw. Gipu ha ni Jesu-Cristu, ipeta ko ha nikaw a tumaknag ka ken maglakad!” ");
INSERT INTO duo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sa na, inegkaman ni Pedro i kanawan a kamat na, ket inagkat na. Ket bigu la a nakasibat i tikad na a duwa. ");
INSERT INTO duo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tulos, linumakbong hikuna a tumaknag, ket naglakad. Ket sinumdap hidi a tallu ha Templo. Naglakalakad ken naglakbonglakbong hikuna, ket nagdeyaw hikuna ha Dios. ");
INSERT INTO duo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Niyaen, ha disalad na Templo, naenta na ngamin a kakpalan a makalakad hikuna ken magdeydeyaw ha Dios. ");
INSERT INTO duo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ket nelassin di a hikuna i mahaglimos a nakangetnod ha Inaamakan a Ruwangan. Ket nalaktat hidi, ta nahusayan hikuna. ");
INSERT INTO duo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Niyaen, idi linumapos hidi, tinumahan hidi ha esa a lugar, ket inegkaman ni pilay di Pedro ken Juan. Ket dinumuhap i ngamin a kakpalan ha ide a lugar a managenan ha Paglenduman ni Hari Solomon. Ket nalaktat unay i kakpalan aye. ");
INSERT INTO duo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Idi naenta ni Pedro i kakpalan aye, kinagi na ha nidi, “Hikam a kababayan ko, apay a malaktat kam ha ide? Apay a magbulagbulag kam ha nikami? Awan mi hikuna napalakad gipu ha kaddat mi, onu gipu ta awan ha liwat ha baggi mi. ");
INSERT INTO duo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bakkan! Ta Dios dalla i nagpahusay ha pilay aye! Dios man i dineyawan na minappo tam a hidi, hidi ni Abraham, ken ni Isak, ken ni Jakob. Ket hikuna man bi i nagpadeydeyaw ha ni Jesus a annak na ha langit. Niyaen, ha ide a ni Jesus, hikuna a mismo i negiwat moy ha panglakayan tam a hidi a mahagturay. Sa moy, minadiyan ide a ni Jesus ha saguppang ni Gobernador Pilato, maski ninakam na a palobusan na mina ni Jesus ha pagbaludan na. ");
INSERT INTO duo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ni Jesus man i mappiya, a awan ha liwat na. Ngem minadiyan moy hikuna. Imbes na, inaged moy ha ni Pilato a palobusan na i esa a mahagbuno ha pagbaludan na. ");
INSERT INTO duo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Isu, kona ha hikam i nagpatay ha ni Jesus, maski nu hikuna i mahagiyatad ha biyag na Dios ha totolay. Ngem maski nu pinatay moy hikuna, pinabiyag na manon na Dios. Ket magpatahod kami ha ide, ta naenta mi a minagbiyag manon hikuna. ");
INSERT INTO duo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Niyaen, maenta tam ide a napilay, ket katandiyan tam a idi palungo, awan hikuna makalakad. Ngem niyaen, makalakad hikuna gipu ha ni Jesus. Ket i pinangpahusay na, i panahod mi ha ni Jesus. Ket hinumusay hikuna ha saguppang moy gipu ha panahod mi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Niyaen, kakabsat,” kon ni Pedro, “katandi ko dan a awan moy nakatandiyan i ginimet moy. Ta awan moy nakatandiyan ni Jesus, a hikuna i annak na Dios. Ket magkalan bila i panglakayan moy a hidi, a awan di nakatandiyan. ");
INSERT INTO duo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Awan a mabalin a awan naparigatan i Cristu. Ta ide i nepapugto na Dios ha minahagpugto a hidi, nikuna a naalayan. Ket gipu ha ginimet moy ha ni Jesus, pinatongpal na Dios i pugto di. ");
INSERT INTO duo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Isu, niyaen, pakipeta ko ha nikam a magbabawi kamon, ket umuseg kam ha Dios, penu mapakawan na i liwaliwat moy. ");
INSERT INTO duo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nu kona hito i gimetan moy, atoy nokkan i tiyetiyempo a pangpalagen na Dios ha nakam moy. Ket nokkan, ipasoli na ni Jesus, a Cristu a naggipu ha Dios, penu maghari. ");
INSERT INTO duo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ha niyaen a tiyempo, masapul a maguray pala ni Jesus ha langit, hanggan dumemat i tiyempo a pangpabigu na Dios ha ngamin a lutak, ken ngamin a langit. Magimet ito nokkan, a kona ha nepapugto na Dios ha minahagpugto a hidi, nikuna a naalayan. ");
INSERT INTO duo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Inpakatandi na bila ide ni Moyses, a esa a minahagpugto. Ta kinagi na, ‘Paangayan na Apo Dios i esa a kababayan moy a Judio. Ket magpugto bila hikuna, a kona ha nikan a nakangpugto ha kakkagi na Dios. Ket masapul a usigan moy i ngamin a bon na. ");
INSERT INTO duo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ta maski nu heya a awan umuseg ha kakkagi na, awan na hidi masakopan na Dios, ket maparusaan hidi hanggan awan ha kahad na,’ kon ni Moyses.” ");
INSERT INTO duo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tinulos ni Pedro, “Nangipugto bila i ngamin a minahagpugto, sapul ha ni Samwel, hanggan ha ngamin a hidi a inumunod ha ni Samwel. Ket nepugto di ngamin i paggimi-gimet na Dios ha niyaen a tiyempo. ");
INSERT INTO duo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ket nepakatandi di bila i inkari na Dios. Ket meraman kitam bila ha inkari na ha minappo tam. Inkari na ha ni Abraham a bendisyonan na i ngamin a kalase na totolay ha lutak gipu ha apapo ni Abraham. ");
INSERT INTO duo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Isu a pinaangay na Dios i Annak na ha nikitam ha palungo. Ta kayat na Dios a bendisyonan na kitam, a pagbabawiyan na kitam, ken pasinaan na kitam ha madukas a ugali tam.” Ito i kinagi ni Pedro ha kakpalan a Judyo ha Templo. ");
INSERT INTO duo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Niyaen, idi magkagi pala ni Pedro ken ni Juan ha kakpalan a Judyo, dinumemat i padi a hidi, ken esa a kapitan na guwardiya ha Templo, ken kappal a Saduseyo. ");
INSERT INTO duo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ket nagingal hidi. Ta netoldu di Pedro a makabiyag manon i maski nu heya a tolay, gipu ta minagbiyag manon ni Jesus. (Ngem ha panahod di Saduseyo awan makabiyag manon i tolay a natayan.) ");
INSERT INTO duo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Isu, dinakap di ni Pedro ken ni Juan. Ket gipu ta kallapan, pinasaddap di ha pagbaludan hanggan ha ugma. ");
INSERT INTO duo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ngem maski nu kona hito, atoy i makpal a nagteman ha pinagitoldu di Pedro, ket nanahod hidi ha ni Jesus. Manga lima a ribu i bilang na lallaki a hidi a nanahod. ");
INSERT INTO duo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Idi kaugman na, nagmiting ha Jerusalem i Judyo a mahagturay ken maestro a hidi na linteg. ");
INSERT INTO duo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ket atoy bila ha pagmitingan di ni Anas a katangkayan a padi, ken ni Kaipas, ken ni Juan, ni Alejandro, ken ngamin a pamilya na katangkayan a padi. ");
INSERT INTO duo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pinasaguppang di di Pedro a pagsalodsodan di. Kinagi di, “Panya moy a napahusay i pilay? Anya i kaddat moy? Heya nagipuwan na kaddat moy aye?” ");
INSERT INTO duo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ket ha ni Pedro, atoy ha nikuna i Espiritu na Dios. Ket tinabbeg na, “Happo a magtuturay, ken panglakayan mi, temanan moy bi i kakkagi ko. ");
INSERT INTO duo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ta nu kayat moy kami embestigaran gipu ta ide a pinappiya mi ha esa a napilay, ken panya a napahusay hikuna, itabbeg mi mina ha nikam. ");
INSERT INTO duo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ta makatandi kam mina, ket makatandi mina i ngamin a tolay na Israel a makataknag i pilay aye a nahusay gipu ha kaddat ni Jesu-Cristu a taga Nasaret. Hikuna i inlansa moy ha kudos. Ngem pinabiyag na manon na Dios. ");
INSERT INTO duo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ni Jesus i pinugtowan di idi nesurat di ha Libro na Dios, ‘I pugedu a minadiyan na tarabahador a hidi, hikuna i pangadigi ha ngamin a bilay ko,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Niyaen, ni Jesus i kona ha pogedu a pangadigi ha bilay na Apo Dios. Ket hikuna la i makesalakan ha totolay. Awan ha makesalakan, nu awan la a ni Jesus. Ta hikuna la i neyatad na Dios ha totolay a pangisalakan ha nikitam.” Ito i nepeta ni Pedro ha matangkay a Judyo a hidi a Sanhedrin. ");
INSERT INTO duo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ket nalaktat unay i Sanhedrin a hidi, ta natured ni Pedro ken ni Juan. Nalaktat hidi, ta nakatandiyan di a madibbi la di Pedro, a awan hidi nagadal. Sa, nanakam na Sanhedrin a hidi a nakiagum di Pedro ken Juan ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kayat di a paliwatan di Pedro, ngem puros, awan di hidi napaliwatan. Ta magtaknag pala i pilay heya ha saguppang di. Ket nahusay dan i baggi na. ");
INSERT INTO duo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Isu, inlapos di ni Pedro ken ni Juan a maguray ha lapos na pagmitingan di, ket nakipaggammong pala hidi a Sanhedrin. ");
INSERT INTO duo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kinagi di, “Anya mina i gimetan tam ha dagende a lallaki? Ta nakatandiyan na ngamin a tolay ha Jerusalem a ginimet di i dakkal a milagro. Ket awan tam ito masaway. ");
INSERT INTO duo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Isu, ibon tam mina ha nidi a awan hidi magkagi ha maski nu heya megipu ha ni Jesus. Ket pagimakan tam ide a baheta, penu awan magwaras,” kon na Sanhedrin a hidi. ");
INSERT INTO duo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Sa di, pinasaddap manon di Pedro, ket inbon hidi na Sanhedrin a awan mina hidi mangipeta onu mangitoldu ha maski nu heya megipu ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ngem tinabbeg ni Pedro ken ni Juan, “Maganya kami mina? Magtongpal kami mina ha nikam onu Apo Dios? Sabali i nepeta moy ngem ha nepeta na Apo Dios. ");
INSERT INTO duo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Isu, awan a mabalin a gumimak i kagi mi megipu ha pinaggimet ni Jesus a naenta mi, onu megipu ha pinagitoldu na ha nikami idi,” kon di Pedro. ");
INSERT INTO duo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ket inpinduwa na Sanhedrin a hidi i kagi a pangpakanteng di ha di Pedro. Sa di, pinalakad hidi. Ket nakatandiyan na Sanhedrin a hidi a awan di kaya a magparusa na nidi. Ta dineydeyaw na kakpalan a tolay i Dios, gipu ha iday a nagimet. ");
INSERT INTO duo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Agay, ha iday a lallaki a napahusay, sobra ha uppat a pulo a tawen i idad na. ");
INSERT INTO duo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Niyaen, idi linumapos di Pedro ken Juan, sinumoli hidi ha agagum di. Ket inbaheta di i kinagi na matangkay a Judjudyo ha Sanhedrin. ");
INSERT INTO duo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Idi nabahetaan di ito, nakipagkararag hidi ngamin. “Apo Dios,” kagi di, “hikaw i nanggimet ha langit, ken diget, ken lutak, ken ngamin a maghen ha lutak. ");
INSERT INTO duo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ket i Espiritu mo i nagpapugto ha minappo mi a ni Dabid, a tagabu mo. Ta nepugto na, ‘Maingal hidi nokkan, maski hidi a bakkan a Judyo. Ket makipaggayak hidi ha madukas. Ngem awan di maanya. ");
INSERT INTO duo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Makipagtulag i magturay ken maghari a hidi, penu maggayak hidi a mangsenti ha Apo Dios ken Cristu a paangayan na,’ kon ni Dabid. ");
INSERT INTO duo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ket niyaen, natongpal ito. Ta atoy ha Jerusalem ni Hari Herod, ken ni Gobernador Pilato, a nakipagtulag ha nidi a Judyo ken ha nidi a bakkan a Judyo. Ket makipagsenti hidi ha ni Jesus a annak mo, a pinaangay mo ha ide a lutak. ");
INSERT INTO duo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ket magimigimet ito gipu ta ide i panggep mo a magimet. ");
INSERT INTO duo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Niyaen, Apo Dios,” kagi di, “nateman mo i pangpakanteng di ha nikami. Isu, Apo, pasibatan mo bi i nakam mi, a magibaheta pala ha kakkagi mo. ");
INSERT INTO duo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Apo, iyatad mo bi i kaddat mo a magpahusay ha masaket a hidi. Ket pagimet mo bi i milamilagro ken pangpatahod gipu ha annak mo a ni Jesus.” Ide i kararag na manahod a hidi. ");
INSERT INTO duo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Idi nobos i kararag di, nayagyag i bilay a paghenan di. Ket inumasak ha nidi i Espiritu na Dios. Ket tulos a natured hidi a magibaheta ha kakkagi na Dios. ");
INSERT INTO duo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ha nidi a manahod, nagiesa hidi ha nakam ken pinaggimet di. Awan ha nidi i mekemot. Ket nakangbunong hidi ha maski nu anya a aruwatan di. ");
INSERT INTO duo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ket dakkal i kaddat na Dios ha apostol a hidi a pinatahodan di megipu ha ni Jesus a minagbiyag manon. Ket dakkal i kagbi na Dios ha nidi ngamin a manahod. ");
INSERT INTO duo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Awan man ha grupo di a nagkurangan. Ha maski nu heya a nakingtalon onu nakingbilay, nelako di i kukuwa di, sa di, inyatad i naglakowan di ha apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ket nebunong na apostol a hidi i korinat ha kada esa a manahod, ayun ha masapul na. ");
INSERT INTO duo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kona bila hito i ginimet na esa a lallaki a taga Sipro. Ni Jose i nagen na. Ni Libay i minappo na. Ket insangay di apostol ha nikuna ha “Bernabe”. (Ha kagi di, “Mahagdaggap” i kayat na kagiyan ha “Bernabe”.) ");
INSERT INTO duo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ket inlako ni Bernabe i talon na, ket inyatad na i korinat ha apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ket atoy bila i esa a lallaki a nagen na ni Ananiyas. I kabanga na, ni Sapira. Ket inlako di bila i talon di. ");
INSERT INTO duo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ngem ninakam di a ikemot di i kappal a korinat ket aginaatad hidi ha ngamin ha apostol a hidi. Niyaen, idi pinangiyatad ni Ananiyas, ");
INSERT INTO duo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","kinagi ni Pedro ha nikuna, “Apay Ananiyas, pinagawag na ka ni Satanas? Ta nagsileng ka ha Espiritu na Dios, a intago mo i korinat a naglakowan mo. ");
INSERT INTO duo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Idi awan moy pala nelako i talon moy, hikam pala i makingtalon, ket makagimet kam ha maski nu anya a kayat moy. Onu maski kobosan na pinaglako moy, hikam pala i makingkorinat. Ket makagimet kam ha maski nu anya ha korinat aye. Niyaen, apay ninakam mo a gimetan ito? Bakkan a hikami i sinilengan mo, nu awan i Dios!” kon ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Niyaen, idi nateman ni Ananiyas i kagi ni Pedro, natakneg hikuna a natay. Sa, binadbad na lallaki a hidi i bangkay na ha hamet, ket inlapos di ket inlabbang di. Ket ha ngamin a nakabaheta ha dento, kinumanteng hidi gamen. ");
INSERT INTO duo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sa, manga tallu a oras, ket dinumemat i kabanga na a awan na katandiyan i nagimet heya. ");
INSERT INTO duo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ket insalodsod ni Pedro ha nikuna, “Anya, Sapira, ipeta mo bi megipu ha ide a korinat. Ide dan i dagop na naglakowan moy ha talon?” kon na. “Oni ah,” kagi ni Sapira. “Iday i naglakowan mi.” ");
INSERT INTO duo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ket kinagi ni Pedro, “Nagaanya ka dan! Nakinakam kam a magsurbar ha Espiritu na Apo Dios. Ket niyaen, natay i kabanga mo, ket kaddemat na lallaki a hidi a naglabbang ha bangkay na. Niyaen, hikaw man i umunod a ilabbang di!” ");
INSERT INTO duo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sa hikuna, bigu la a natakneg bila ha saguppang di Pedro, ket natay. Ket sinumadap i lallaki a hidi, ket naenta di a natay dan ni Sapira. Isu, inlapos di bila i bangkay na, ket inlabbang di ha hikeg na kabanga na. ");
INSERT INTO duo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ket kinumanteng unay hidi a manahod ken maski nu heya a nakabaheta ha ide. ");
INSERT INTO duo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Idi tiyempo hito, naggigimmongan na apostol a hidi ha Paglenduman ni Solomon ha Templo, ket nagesesa i pagnakam di. Makpal i milagro ken pangpatahod a ginimigimet di apostol ha saguppang na tolay a hidi. ");
INSERT INTO duo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ngem maski nu inaamakan i kakkagi na sabasabali a tolay megipu ha apostol a hidi, awan hidi nakikuyog, ta kinumanteng hidi. ");
INSERT INTO duo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ngem nenayon pala i totolay a manahod ha sakop ni Apo Jesus. Kakpalan hidi a lallaki ken hidi a babbey. ");
INSERT INTO duo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ket gipu ta kona hito i ginimigimet na apostol a hidi, inyangay na totolay i agagum di a nasaket ha karkarsada a kettidugan di ha kama di, onu abak di. Ta nanakaman di nu lumakad ni Pedro ha karkarsada heya, maski nu alino na la i tumupo ha baggi di, mapahusay hidi. ");
INSERT INTO duo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ket dinumemat bila i kakpalan a tolay a naggipu ha il-ili a nakalebut ha Jerusalem. Inyangay di i nasaket a hidi, onu hidi a inumawag dan, ket napahusay hidi ngamin. ");
INSERT INTO duo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ngem ha katangkayan a padi ken agagum na a Saduseyo, nakaseni hidi unay ha apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ket pinadakap di i apostol a hidi, a inpabalud di. ");
INSERT INTO duo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ngem idi kallap heya, inumangay ha nidi i esa a anghel na Apo Dios. Tulos, linukatan na i ruwangan na pagbaludan, ket inlapos na i apostol a hidi. Ket inpeta na ha nidi, ");
INSERT INTO duo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Umangay kam ha Templo, a tumaknag kam a magitoldu ha tolay a hidi megipu ha biyag na Dios a magnanayon a iyatad na ha totolay,” kon na anghel. ");
INSERT INTO duo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ket nagtongpal di apostol. Idi maledum, sinumadap hidi ha Templo, ket nagitoldu ha tolay a hidi. Idi magitoldu di apostol ha Templo, nagpisan di katangkayan a padi, ket inpaayag di bila i ngamin a kapitan na Judio ha pagmitingan na Sanhedrin. Sa di, inpaangay i sundalo a hidi ha pagbaludan a pagalapan di ha apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ngem idi dinumemat i sunsundalu, awan man i apostol a hidi ha pagbaludan! Isu a sinumoli di sundalu ha nidi a Sanhedrin, ket inbaheta di, ");
INSERT INTO duo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nakoya, dinumemat kami ha pagbaludan, ket naenta mi a nakandaduwan a mapigsa i ruwangan na, ket nagdapon pala i guwardiya a hidi. Ngem idi linukatan mi i ruwangan, awan dan ha tolay,” kon di sundalu. ");
INSERT INTO duo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ket ha nidi a kapitan na sundalu ken matangkay a papadi, idi nabahetaan di ito, nasbew hidi nu anya i nagimet ha apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Niyaen, idi magnakanakam pala hidi, dinumemat i esa a lallaki a inbaheta na, “Magitoldu ha Templo i lallaki a hidi a pinebalud moy,” kon na. ");
INSERT INTO duo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Isu a inumangay i kapkapitan ken sundalu a hidi ha Templo, ket inalap di i apostol a hidi ket insoli di. Ngem awan di hidi pinilit, ta makanteng hidi a baka bisagan na hidi na kakpalan a tolay. ");
INSERT INTO duo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Idi sinumoli hidi, pinasaguppangan di i apostol a hidi ha Sanhedrin, ket sinalodsod na katangkayan a padi. ");
INSERT INTO duo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kinagi na, “Binon ta kam a awan kam magitoldu megipu ha ni Jesus. Ngem nagaanya kam? Newaras moy i pagitoldu moy ha ngamin ha Jerusalem! Ket kayat moy a ipaliwat ha nikami i kinakatay na,” kon na padi. ");
INSERT INTO duo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Intabbeg di Pedro, “Masapul a tongpalan tam i inbon na Apo Dios ngem ha bon na totolay. ");
INSERT INTO duo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gipu ta Dios a panahodan na minappo tam, hikuna i nagpabiyag manon ha ni Jesus a binuno moy ha kudos. ");
INSERT INTO duo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ket Jesus paman i inpaunek na ha langit, penu mahagturay ken mahagsalakan. Ginimet na Dios ito penu meyatad na ha nikitam a Judyo i gundaway tam a pagbabawi, penu mapakawan na i liwaliwat tam. ");
INSERT INTO duo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ket niyaen, hikami i mangpatahod ha dagende a gimigimet na Dios, hikami ken i Espiritu na Dios a iyatad na ha maski nu heya a umuseg ha pagayatan na.” Ito i tabbeg di Pedro. ");
INSERT INTO duo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Idi nateman di Sanhedrin ito, nagingal hidi gamen, ket kinayat di a ipapatay hidi a apostol. ");
INSERT INTO duo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ngem atoy i esa a agum di a Pariseyo. Ni Gamaliyel i nagen na. Ket maestro hikuna ha linteg na Judyo. Ket matangkay hikuna ha nakam na ngamin a tolay. Tinumaknag hikuna ha saguppang di Sanhedrin, ket inbon na a ilapos di hidi a apostol. ");
INSERT INTO duo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Sa na, iniwadan hidi a Sanhedrin. “Kababayan ko,” kagi na, “magingat kitam mina nu anya i gimetan tam ha dagende a lallaki. ");
INSERT INTO duo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nakaman tam mina ni Teudas. Ta idi agindadakkal hikuna, atoy manga uppat a gasut a lallaki a nakiagum ha nikuna. Ngem idi napatay dalla ni Teudas, nasinasina dalla i agagum na, ket awan ha nagimet di. ");
INSERT INTO duo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ket kobosan na ide, atoy bila i sabali a lallaki a taga-Galileya. Ni Judas i nagen na. Dinumemat hikuna idi tiyempo na pinangsensus na gobernador. Ket kinayat na a maglaban ha gobyerno. Makpal bila i tolay a inumunod ha nikuna, ngem idi napatay dan hikuna, nasinasina dalla i agagum na. ");
INSERT INTO duo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Niyaen, ide i ipeta ko ha nikam, a kabeng tam mina idagende a lallaki. Ket palobusan tam mina hidi. Nu maggipu la ha totolay i gimetan di, awan di maanya. Ket makasinasina hidi nokkan. ");
INSERT INTO duo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ngem nu maggipu ito ha Dios, awan ha kaya tam a mangabak ha nidi. Baka kalaban tam i Dios a mismo!” Ide i nepeta ni Gamaliyel ha nidi a Sanhedrin. Ket tineman di hikuna. ");
INSERT INTO duo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Isu, pinasaddap di manon i apostol a hidi. Ket pinasabbadan di hidi. Ket inbon di a awan hidi magitoldu megipu ha ni Jesus. Sa di, pinalakad hidi. ");
INSERT INTO duo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Niyaen, ha apostol a hidi, linumapos hidi ha pagmitingan aye. Ket nagragsak hidi a hidi i pinili na Dios a marigrigatan ken mapasanikiyan gipu ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ket tinumulos hidi a nagibaheta ken nagitoldu megipu ha ni Jesus ha Templo ken ha bilabilay na totolay. Ket inbaheta di i Mappiya a Baheta a ni Jesus i Cristu a magturay. ");
INSERT INTO duo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Idi tiyempo hito, ket awan ha naalay, dinumakaldakkal unay i kasakop di a manahod. Ngem atoy i kappal a nakireklamo ha sakop na manahod a hidi. Ta atoy i kappal a Judyo a taga sabasabali a bayan. Ket atoy bila i kappal a taga-Jerusalem. Niyaen, idi kada pamalak, atoy i kanan a inwaraswaras di taga-Jerusalem ha maski nu heya a babbey a nabilu. Ngem nagreklamo i dayuwan a hidi. Ta kinagi di a pabiyanan na taga-Jerusalem i nabilu a hidi a dayuwan. Ket madi kan nu awan hidi makaalap ha kanan di. ");
INSERT INTO duo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","Isu, inayagan di apostol i ngamin a manahod a makipaggimong hidi. Ket inpeta di, “Kakabsat, mas mappiya nu piliyan moy ha agagum moy i pitu a lallaki a magturay ha pakewaras ha kanan tam. Ta awan mappiya nu pabiyanan mi i pagitoldu mi ha kagi na Dios, penu magiwaras ha kakanan. Isu, hikam mina i magpili ha pitu a lallaki a pagtalakan tam. Basta sigurado kam a malaing hidi, ket atoy ha nidi i Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ket ha nikami, tumulos kami ha pinagkararag mi ken pinagibaheta mi ken pinagitoldu mi ha kakkagi na Dios,” kon na apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ket naragsakan i ngamin ha kinagi na apostol a hidi. Ket pinili di i pitu a lallaki. Pinili di ni Esteban, ta napigsa i panahod na ken napigsa i Espiritu na Dios ha baggi na. Ket pinili di ni Pelipe, ni Prokoro, ni Nikanor, ni Timon, ni Parmenas, ken ni Nikolas a taga-Antiokiya. Bakan a Judyo ni Nikolas aye, ngem hikuna bila i esa a umusoseg ha linteg ni Moyses. ");
INSERT INTO duo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Idagende a lallaki i nesaguppang ha nidi a apostol. Sa di, intupu i kamat di ken inkararagan di hidi. ");
INSERT INTO duo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Isu a tulos, gipu ha kona hito, newaraswaras pala ha makpal a tolay i kakkagi na Dios. Ket kinumakpal hidi a manahod a naghen ha Jerusalem. Ket atoy i makpal a padi a nagpasakop bila ha ni Jesus, a nanahod bila hidi. ");
INSERT INTO duo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Niyaen, ha ni Esteban, hikuna i esa a lallaki a inaguman na Dios, a inyatad na ha nikuna i kaddat na a panggimet ha makpal a milagro ken pangpatahod ha saguppang na tolay a hidi. ");
INSERT INTO duo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ngem atoy i sabasabali a Judyo a inumangay ha ni Esteban penu mangsenti. Kasakop hidi ha kapilya na Libertines, a taga-Sirene, ken Alejandriya. Ket kinaagum di bila di Judyo a taga-Silisiya, ken Asia, penu makitabbeg ha ni Esteban. ");
INSERT INTO duo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ngem awan di kaya a metabbeg ha kinalaing na Espiritu na Dios. Ta nagitoldu ito ha ni Esteban nu anya mina i kakkagi na. Ket naabak la hidi. ");
INSERT INTO duo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Isu, gipu ta kona hito, inyatad di i korinat ha kappal a lallaki a mangipeta mina ha sileng. Ket kinagi na lallallaki heya, “Nateman mi i kagi ni Esteban a mangsenti ha Linteg ni Moyses ken Apo Dios,” kon di. ");
INSERT INTO duo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ket gipu ha dende a nagsileng, nagpaingal hidi ha sabasabali a Judyo, ken panglakayan na kapilya di, ken mamaestro na linteg. Ket dinakap di ni Esteban, ket insaguppang di hikuna ha nidi a Sanhedrin. ");
INSERT INTO duo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Sa di, insaguppang bila i lallaki a hidi a nagsileng penu paliwatan di ni Esteban. Ket kinagi di, “Kanayon a magsenti ni Esteban ha madedeyaw a bilay na Dios, ken ha Linteg ni Moyses. ");
INSERT INTO duo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ta nateman mi i kagi na a megipu ha ni Jesus a taga-Nasaret, a mangrakrak kan nokkan ha Templo aye, ket pasulitan na kan i ngamin a ugali a netoldu ni Moyses ha nikitam,” kon na magsileng a hidi. Ito i inpaliwat di ha ni Esteban. ");
INSERT INTO duo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ket ha ngamin a hidi a Sanhedrin, inaamatan di ni Esteban. Ket naenta di a karupa na i kona ha rupa na esa a anghel a keddisiyag. ");
INSERT INTO duo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ket nagsalodsod i katangkayan a padi ha ni Esteban, “Anya, tahod i inpaliwat di ha nikaw? Kinagi mo iday?” kon na. ");
INSERT INTO duo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ket tinabbeg ni Esteban, “Hikam a panglakayan ken hikam a kakabsat ko a Judyo. Temanan moy bi i kakkagi ko aye. Katandi tam a ni Abraham i minappo tam ngamin. Ket nikuna a naalay dan, idi naghen di Abraham ha Mesopatamiya, idi palungo a nangialis hidi ha bayan a Haran, nagpaenta i Apo Dios ha nikuna. Ket keddisiyag i Happo tam a Dios. ");
INSERT INTO duo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Inpeta na Dios, ‘Lakadan mo dan i kabagis mo a hidi ken lutak mo aye. Ket umangay ka ha lugar a ipaenta ko ha nikaw nokkan,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Isu, linakadan ni Abraham i lutak na, ha lugar a Kaldeyo, ket naghen hikuna ha Haran. Ket idi nobos a natay i hama na ha lugar a Haran, pinaalis na Dios ni Abraham hanggan ha lutak ha he, a kahenan tam niyaen. ");
INSERT INTO duo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ngem idi tiyempo hito, pulos, awan ha lutak a inyatad na Dios, maski nu ballik la a lutak ha ni Abraham. Ngem inkari na Dios ha nikuna a nokkan kan, iyatad na kan i lutak aye ha ni Abraham, ken ha kaputotan na. Ngem idi tiyempo a pinangkari na Dios, awan pala ha annak ni Abraham. ");
INSERT INTO duo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Ket inpakatandi na Dios ha ni Abraham, ‘Nokkan, maghen i apapo mo a kona ha ganggannaet ha sabali a bayan. Ket matagabu hidi. Ket marigatan hidi ha lubuk na uppat a gasut a tawen. ");
INSERT INTO duo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ngem parusaan ko nokkan i kasenti di a mangtagabu ha apapo mo. Sa hidi, makalapos ha ido a bayan. Ket maghektat hidi hanggan ha lugar aye, a pangdeyawan di ha nikan,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Ket inbon na Dios i tulag tam a pinagkugit. Ket ide a tulag i kona ha tiplad a masakopan kitam ha karkari na Dios. Isu, idi nenak ni Isak, i annak ni Abraham, kinugit na hikuna ha nekugit a pamalak. Ket idi lakay dan ni Isak, kinugit na bila ni Jakob, a annak na. Ket idi lakay dan ni Jakob, kinugit na i esa pulo ket duwa a annak na a lallallaki a minappo tam. ");
INSERT INTO duo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Niyaen, ha annak a hidi ni Jakob, sinumeni hidi ha wadi di a ni Jose. Ket inlako di hikuna ha totolay a taga-Egipto. Ket nagbalin ni Jose a tagabu. Ngem atoy pala ha nikuna i Dios a nagagum ha nikuna ha ngamin a pinagrigat na. ");
INSERT INTO duo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ket insalakan na Dios ni Jose. Inatdinan na hikuna ha kagbi na ken ha kinalaing na, penu mapatalak ni Jose ni Paraon, a Hari na Egipto. Niyaen, idi nakatandiyan ni Hari Paraon ni Jose, pinagubernador na ni Jose a magturay ha ngamin a bayan a Egipto, pati i bukod na a bilay ni Hari Paraon. ");
INSERT INTO duo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ket idi tiyempo heya, dinumemat i dakkal a alap ha ngamin a bayan a Egipto ken Kanaan. Ket dakkal i rigat di, ta awan ha kanan a maeriyokan na minappo tam. ");
INSERT INTO duo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Niyaen, idi nabahetaan ni Lakay Jakob a atoy i kanan ha Egipto, pinaangay na i annak na a hidi a minappo tam. Iday i nekaesa a pagpasiyal di ha Egipto. ");
INSERT INTO duo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ket idi nekaduwa a pinagangay di ha Egipto, inpakatandi ni Jose i baggi na ha hekka na a hidi. Ket idi tiyempo hito, nakatandi bila ni Hari Paraon ha pamilya ni Jose. ");
INSERT INTO duo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ket pinaayagan ni Jose di Jakob a dima na, ken ngamin a kakabaggiyan na. Pitu a pulo ket lima i kakabaggiyan na a hidi. ");
INSERT INTO duo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Ket inumangay dod di Jakob ha Egipto, ket naghen hidi ho. Ket ido i nakatayan na minappo tam. ");
INSERT INTO duo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ngem awan di inwarak i bangkay a hidi na minappo tam ha Egipto. Imbes na, insoli na annak di ha lugar a Sikem, ha bayan tam aye. Ket inlabbang di i bangkay a hidi na minappo tam ha lutak a ginatang ni Abraham ha annak ni Jamor idi. ");
INSERT INTO duo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Niyaen, idi tiyempo a dandani dan a tongpalan na Dios i kari na ha ni Abraham, kinumakpal unay i minappo tam ayo. Ta naalay dan a naghen hidi ho, ha Egipto. ");
INSERT INTO duo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ket atoy hito i sabali a Hari Paraon a hari na Egipto. Ket awan na nakatandiyan i minappo tam a ni Jose. ");
INSERT INTO duo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nagdaya hikuna ha ngamin a Judyo, ket pinilit na i minappo tam a mangiwarak ha annak di ha kasaw a lugar, penu matay hidi. ");
INSERT INTO duo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Idi tiyempo hito, neenak ni Moyses, ket dinaponan dima na ha bilay di, a pagtagowan na ha tallu a bulan. Ket kainamakanan kan i annak a ni Moyses. ");
INSERT INTO duo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Niyaen, idi napilitan hidi a mangilapos ha ni Moyses, a inwarak di a magisesa, inalap na hikuna na babbey a annak ni Hari Paraon. Ket ide a babbey i nagpadakkal ha ni Moyses a kona ha annak na baggi na. ");
INSERT INTO duo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ket tinolduwan di ni Moyses ha ngamin a kinalaing na Egipto. Agay, nagbalin hikuna a malaing ha pagbalikas na, ken ha maski nu anya a ginimet na. ");
INSERT INTO duo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Niyaen, idi uppat a pulo a tawen i idad ni Moyses, ninakam na a magpasiyal ken magdaggap ha kakalan na a Judyo, a apapo ni Israel. ");
INSERT INTO duo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ket naenta na i esa a Egipto a nagloko ha esa a Judyo. Ket nagsaway ni Moyses a aguman na mina i Judyo heya. Ket binuno na iday a Egipto. ");
INSERT INTO duo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ta kagin ni Moyses a makatandiyan na kababayan na, a hikuna i usaran na Dios a mangisalakan ha nidi ha rigrigat di. Ngem awan di nakatandiyan. ");
INSERT INTO duo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Sa, idi kaugman na, naenta na i duwa a Judyo a naginingal. Ket pinadas na a pagpiyaan hidi. Kinagi na, ‘Agay! Apay a magpangongosngos kam? Magkalan kam a Judyo!’ kon ni Moyses. ");
INSERT INTO duo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ngem i lallaki a nagngosngos ha agum na, nagwaklet hikuna ha ni Moyses, a kinagi na, ‘Heya i pagturayan mo a manghukom ka ha nikami? ");
INSERT INTO duo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kayatak mo a bunowan, a kona ha Egipto a binuno mo nakapon?’ kon na. ");
INSERT INTO duo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Idi nateman na ito ni Moyses, binumuyot hikuna ha bayan a Midiyan. Idi naghen hikuna hito, nagkabanga, ket nagenak ha duwa a lallaki. ");
INSERT INTO duo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Idi nakalipas i uppat a pulo a tawen, nagpaenta i anghel na Dios ha ni Moyses ha kasaw a lugar, ha parabin na Sinay. Naenta ni Moyses i esa a kayo a nagsiklasiklab ha gangatan, ngem awan natutod, ta atoy i anghel na Dios ha disalad na. ");
INSERT INTO duo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ket nasbew ni Moyses. Binumikan hikuna penu maenta na, ket nateman na i timek na Apo Dios. ");
INSERT INTO duo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Kinagi na, ‘Hikan i Dios a dineyaw na minappo mo a hidi, a ni Abraham, ni Isak, ken ni Jakob,’ kon na Dios. Ket ha ni Moyses, idi nateman na i timek heya, nagyagyag i baggi na, ta kinumanteng. Ket awan na netured a mangaamata. ");
INSERT INTO duo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kinagi na Dios, ‘Moyses, adyan mo dan i sinelas mo ah. Ta atoy ka dan ha saguppang na Happo mo a Dios. Ket madalus ide a lutak a tataknagan mo. ");
INSERT INTO duo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Inumangayak he, ta paangayan taka ha totolay ko ha Egipto, a mangisalakan ha nidi. Ta inenta ko i rigrigat di. Ket tineman ko i sangisanget di. Isu, magteman ka dan ha nikan,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Niyaen, intulos ni Esteban i tabbeg na ha nidi a Sanhedrin, a kinagi na, “Kakabsat ko a Judyo, katandiyan tam mina a ide ni Moyses, hikuna i minadiyan na dan na Judyo a hidi. Ta inpeta di dan ha nikuna, ‘Heya i pagturayan mo a manghukom ka ha nikami?’ kon di. Ngem ide paman ni Moyses, hikuna i nagpaentaan na anghel ha kayo a nagsiklasiklab. Ket hikuna i inaguman na anghel, idi inpasoli na Dios ha Egipto, penu mangisalakan ken mangituray hikuna ha minappo tam. ");
INSERT INTO duo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ket idi inlapos ni Moyses i minappo tam a naggipu ha Egipto, nagimet na i makpal a milagro ken pinangpatahod na ha Egipto, hanggan ha lugar a Madideg a Diget, hanggan ha kasaw a rugrugar a naglakadan di ha lubuk na uppat a pulo a tawen. ");
INSERT INTO duo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ket ni Moyses paman i nangipeta ha minappo tam ha, ‘Atoy nokkan i paangayan na Dios ha Judjudyo na Israel. Ta paangayan na i esa a kona ha nikan. Ta hikuna bila i esa a Judyo a mangiyatad ha kagi na Dios ha nikam,’ kon ni Moyses. ");
INSERT INTO duo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Ket ide paman,” kinagi ni Esteban. “Idi nagpisan i kakpalan a minappo tam ha kasaw a lugar, ha parabin na Sinay, ni Moyses malla i pagrangtayan na anghel ken minappo tam heya. Ket nagiwat na i kakkagi na Dios a ikabiyag tam, penu megiwat na paman ha nikitam. ");
INSERT INTO duo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ngem ha minappo tam a hidi,” kinagi ni Esteban, “tinumalekod hidi ha ni Moyses. Ket kinayat di a magwaklet manon ha nikuna a magsoli mina ha Egipto. Ta nematon hidi ha Egipto. ");
INSERT INTO duo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ket kinagi di ha ni Padi Aron, ‘Igimetan mos kitam ha didiosen a mangidilan ha nikitam ha kakasaw aye. Ta ide a ni Moyses a nagpaalis ha nikitam ha Egipto, awan tam makatandiyan nu naanya dalla ha nikuna,’ kon di man. ");
INSERT INTO duo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Tulos,” kinagi ni Esteban, “ginimet di i didiosen di a sinanurbon na baka. Ket inatdinan di ha wagah. Sa hidi, nakipagpiyesta a nangsilebra hidi ha bukod di a ginimet. ");
INSERT INTO duo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Isu, tinumalekod i Dios ha nidi. Ket pinabiyan na hidi. Maski nagwagah hidi ha pangdeyaw di ha pusiyan a hidi ken bulan ha langit. Nagimet hito a kona ha nepasurat na Dios ha minahagpugto a hidi. Ta nesurat di, a ‘Hikam a Judio,’ kagi na Dios, ‘bakan a hikan i inatdinan moy, idi inwagah moy i hayhayop ha kasaw a lugar, idi lubuk na uppat a pulo a tawen. Ket sabali i dinaydayaw moy! ");
INSERT INTO duo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ta dineyaw moy ni Molok, a esa a didiosen moy, ket tinawed moy i tolda na a pagdeyawan moy ha nikuna. Ket atoy bila i ladawan na pusiyan a Rempan a didiosen moy bila. Ginimet moy idagende a ladawan a pagdeyawan moy. Isu, paadiyowan takam nokkan ha madiyo, ha manilod na bayan a Babiloniya,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ket tinumulos ni Esteban ha tabbeg na, “Idi naghen i minappo tam ha kasaw a lugar, atoy ha nidi i paghenan na Dios a dakkal a tolda. Ket ide i tiplad ha nidi a atoy i Dios ha lubuk di. Ta ginimet ni Moyses i tolda aye ayun ha pinagpaenta na Dios ha nikuna. Ket neaheg ni Moyses ha naenta na a pangpaahunot na Dios ha nikuna. ");
INSERT INTO duo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ket ide paman a tolda i inyangay di Joswe ken minappo tam, idi pinagalap di i lutak ha bayan tam. Maski a atoy dan i sabasabali a tolay ha lutak aye, ngem pinabuyot na hidi na Dios. Isu a atoy i tolda na Dios ha bayan tam a Israel, maski idi pinangalap di ha bayan tam, hanggan ha tiyempo ni Hari Dabid. ");
INSERT INTO duo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Ket ha ni Hari Dabid, natalak i Dios ha nikuna. Ket i panggep ni Dabid a pataknagan na i dakkal a bilay a pagdeyawan, para ha ngamin a Judyo a kaputotan ni Jakob. Ta pagdeyawan di mina ha Apo Dios. Ket inaged ni Dabid ha Dios a mepataknag na i bilay hito a malagda, a paghenan mina na Apo tam a Dios. ");
INSERT INTO duo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ngem bakkan a ni Hari Dabid i napalobusan a magpataknag ha bilay na Dios, nu awan i annak na, a ni Hari Solomon.” ");
INSERT INTO duo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ket tinumulos ni Esteban ha tabbeg na, “Ide mina i makatandiyan tam, a maski naalay dan a atoy i bilay na Dios ha bayan tam aye, awan a maghen i Katangkayan a Dios ha bilay a magimet na totolay. Awan man! Ta ide i nesurat ni Isayas a minahagpugto, a insurat na, ");
INSERT INTO duo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Langit i pagetnodan ko, ket lutak i tupuwan na tikad ko,’ kon na Apo Dios. ‘Awan a makagimet i totolay ha bilay a mekusto ha nikan. Ket awan moy magimet i bilay a pagemmangan ko. ");
INSERT INTO duo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ta awan a naggimet ha ngamin ha langit ken lutak nu awan la a hikan,’ kon na Apo Dios.” ");
INSERT INTO duo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ket tinumulos ni Esteban ha tabbeg na, “Ito i kinagi na Apo Dios, ngem madiyan moy a temanan. Madiyan moy a umuseg ha kagi na Dios. Ta hikam a kona ha totolay a bakkan a Judyo, ken kona bila ha minappo moy. Ta inumadiadi kam bila ha Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","I minappo moy a hidi i nagloko ha kada esa a minahagpugto. Ket binuno di hidi a pinaangay na Dios a nangibaheta megipu ha pagdemat na annak na Dios. Ket niyaen, liniputan moy ken binuno moy i annak na heya. ");
INSERT INTO duo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","“Hikam a panglakayan ken hikam a kakabsat ko a Judyo, tamos i kinagi moy a hikam i nanahod ha linteg na Dios a inyatad na anghel a hidi. Ngem awan kam a umuseg.” Ito i tabbeg ni Esteban ha Sanhedrin a hidi. ");
INSERT INTO duo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sa, idi nateman di Sanhedrin i kinagi ni Esteban, nakaingal hidi unay. Ket nagngaretnget hidi gipu ha ingal di. ");
INSERT INTO duo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ngem ha ni Esteban, atoy ha nikuna i Espiritu na Dios. Ket tinumangad hikuna ha langit. Ket naenta na i demlag na Dios ken ni Jesus a magtaknag ha henan na Dios. ");
INSERT INTO duo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ket kinagi na, “Maenta ko a lumukat dan i langit, ket atoy i Annak na Dios a Nagbalin a Tolay a tumataknag ha henan na Dios,” kon ni Esteban. ");
INSERT INTO duo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ngem ha nidi a Sanhedrin, nagrangsit hidi. Ket tinaklaban di i talinga di, penu awan di mateman i kakkagi na. Ket dinakap di hikuna. ");
INSERT INTO duo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ket ginuyod di ni Esteban ha lapos na ili, ket binisag di. Ket atoy bila ho, ha pagbisagan di, i esa a lallaki a nagen na ni Saulo. Ket ni Saulo i nagdapon ha kagay na lallallaki a nangpaliwat ha ni Esteban. ");
INSERT INTO duo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Niyaen, idi binisagbisag di ni Esteban, nagkararag hikuna ha, “Apo Jesus,” kagi na, “alapan mo bi i kaliduwa ko.” ");
INSERT INTO duo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Sa hikuna, nagparintumeng ket indulaw na, “Apo ko, pakawanan mo bi ide a liwat di,” kon ni Esteban. Sa, natay dan. ");
INSERT INTO duo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ket inumoni ni Saulo ha pinagbuno di ha ni Esteban. Ngem bakkan i nakam na sabasabali a tolay a makidios. Ket nagsangisanget ken nagngongoyngoy hidi. Ket inlabbang di ni Esteban. Ket nangrugi ha iday a pamalak, nalokowan unay i totolay a manahod a naghen ha Jerusalem. Napabuyot hidi ngamin ha sabasabali a probinsiya a Judeya ken Samariya. I nagwarak la ha Jerusalem i apostol a hidi. ");
INSERT INTO duo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ket ha ni Saulo, hikuna i mahagloko ha nidi a manahod. Nakangsaddap hikuna ha bilabilay di a padakap na hidi ken pabalud na hidi, maski babbey a hidi onu lallallaki. ");
INSERT INTO duo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Isu, napasinasina hidi a manahod. Ket idi inumangay-angay hidi ha maski nu hadya a lugar, intoltoldu di i kakkagi na Dios. ");
INSERT INTO duo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ket atoy bila i esa, a nagen na ni Pelipe, a inumangay ha dakkal a ili ha probinsiya a Samariya. Ket inpakatandi na megipu ha ni Jesus a Cristu na Dios. ");
INSERT INTO duo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ket ha totolay ayo, idi naenta di i makpal a milagro a ginimet ni Pelipe, ken nateman di i baheta na, nagteman hidi perpermi ha kagi na. Ket nagteman i kada esa ha kakpalan ho. ");
INSERT INTO duo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ta naenta di a napahusay i makpal a tolay a neawag. Ket nagrangsit i dimonyo a hidi, idi linumapos hidi. Ket atoy bila hay i makpal a napilay ken napikot, ket napahusay bila hidi. ");
INSERT INTO duo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Isu, atoy i makpal a tolay a naragsak ha Samariya ayo. ");
INSERT INTO duo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Niyaen, atoy bila hay i esa a lallaki a salamangkero. I nagen na ni Simon. Ha pinagbiyag na a nagpasabbew ha Samaritano a hidi ha pinagsalamangka na. Ket inpeta na a madedeyaw kan i baggi na. ");
INSERT INTO duo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ket nanahod hidi ngamin ha nikuna, maski hidi a matangkay ken hidi a napobre. Kinagi di, “Ni Simon i Dios a managenan ha ‘Dakkal a Kaddat’,” kon di. ");
INSERT INTO duo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Isu a tineman di hikuna, ta naalay a tiyempo a pinagsabbew na hidi ha salamangka na. ");
INSERT INTO duo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ngem idi inpakatandi ni Pelipe i Mappiya a Baheta megipu ha ni Jesu-Cristu ken Paghariyan na Dios, nanahod hidi ha ni Jesus. Ket nagpabinyag hidi, hidi a babbey ken hidi a lallaki. ");
INSERT INTO duo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Maski ha ide a ni Simon, nanahod bila hikuna. Ket idi napabinyag dan, nakiuseg hikuna ha ni Pelipe. Ket nasbew bila hikuna, idi naenta na i makpal a milagro a pangpatahod a ginimigimet ni Pelipe. ");
INSERT INTO duo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ket idi nabahetaan na apostol a hidi ha Jerusalem a nanahod i totolay ha Samariya ha kagi na Dios, pinaangay di ni Pedro ken ni Juan. ");
INSERT INTO duo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Idi dinumemat di Pedro ha Samariya, inkararagan di hidi a Samaritano, penu isadap na Dios i Espiritu na ha nidi. ");
INSERT INTO duo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ta awan pala insadap na Dios i Espiritu na ha nidi. Napabinyag dalla hidi a magpasakop ha ni Apo Jesus. ");
INSERT INTO duo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Isu, nagtupo di Pedro ken Juan ha kamat di ha nidi ket sinumadap i Espiritu na Dios ha baggi di. ");
INSERT INTO duo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Niyaen, idi naenta ni Simon a sinumadap i Espiritu na Apo Dios ha totolay gipu ha pinangitupo di Pedro, kinagi na ha nidi, ");
INSERT INTO duo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Atdinan ta kam ha korinat, ket iyatad moy bi ide a kaddat ha nikan, penu metupo ko bi i kamat ko ha maski nu heya a tolay, ket sumadap bila ha nidi i Espiritu na Dios,” kon ni Simon. ");
INSERT INTO duo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ngem kinagi ni Pedro, “Simon, melunod kas, pati i korinat mo! Ta kagin mo a makagatang ka ha Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Awan ha biyang mo ha tarabaho mi, ta madi i nakam mo. Madukas i nakam mo ha Dios. ");
INSERT INTO duo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Isu, magbabawi ka mina ha panggep mo aye, ket magkararag ka dan ha Apo, a pakawanan na ka mina. ");
INSERT INTO duo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ta katandi ko a sumeni ka unay, ket kona ha negakad ka gipu ha liwaliwat mo,” kon ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ket inaged ni Simon ha ni Pedro ken ni Juan, “Anaanay! Makagbi kam bi, a ikararaganak moy bi, penu awan a magimet ha nikan a kona ha kinagi mo,” kon na. ");
INSERT INTO duo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Niyaen, kobosan na pinagitoldu ni Pedro ken ni Juan ha kagi ni Apo Jesus ken ha ngamin a pinangpatahod di, sinumoli hidi ha Jerusalem. Ket ha paglakad di, hinumuyot hidi ha makpal a baryo ha Samariya, a inpakatandi di i Mappiya a Baheta megipu ha ni Jesus ha Samaritano a hidi ho. ");
INSERT INTO duo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Niyaen, ha ni Pelipe, idi naghen pala hikuna ha Jerusalem, atoy i esa a anghel na Dios a nangipeta ha nikuna, “En ka dan. Lumakad ka ha abagatan, ha karsada a magturong ha ili a Gasa,” kon na. (Alegid iday a karsada, a awan ha maglakad iho.) ");
INSERT INTO duo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Isu a naggayak ni Pelipe, a naglakad. Ket atoy ha karsada ayo i esa a tolay a naenta ni Pelipe. I tolay aye i esa a lallaki a taga-Egipto. Ket inumangay dan hikuna ha Jerusalem a nagdeydeyaw ha Dios. Ket niyaen, magsoli dan a maglugan ha kalesa. Hikuna i tagabu ni Reyna Kandase, ha Etiyopiya. Ket matangkay hikuna, ta meturayan na i ngamin a korinat na Reyna. Niyaen, ha paglugan na ha kalesa, magbasa hikuna ha libro ni Isayas a minahagpugto. ");
INSERT INTO duo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ket inpeta na Espiritu na Dios ha ni Pelipe, “Nay kan. Bumikan ka dan ha nikuna,” kon na. ");
INSERT INTO duo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Isu a nagsigida ni Pelipe a binumuyot ha kalesa. Ket nateman na a magbasa hikuna ha libro ni Isayas. Ket sinalodsod ni Pelipe, “Botay, makatandiyan mo iday a basaan mo?” ");
INSERT INTO duo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ket tinabbeg na lallaki, “Panya ko a makatandiyan nu awan ha mangipakatandi ha nikan?” Ket inawis na ni Pelipe a makilugan. ");
INSERT INTO duo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Niyaen, ide i kagi na Dios a binasa na, “Maanus la hikuna, a kona ha karnero a iyangay di ha pagpartiyan, a awan magkagi. Ket kona ha urbon na karnero a awan magtanog, maski nu pukisan di. ");
INSERT INTO duo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mapasanikiyan hikuna. Ket madi i paghukom di ha nikuna. Ngem awan ha makebilang ha ngamin a isalakan na, gipu ha katay na,” kon na Dios. Iday i pinasurat na Dios ha ni Isayas. ");
INSERT INTO duo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ket kinagi na taga-Egipto ha ni Pelipe, “Ipakatandi mo bi nu heya i nagkagiyan na minahagpugto, megipu ha baggi na, onu megipu ha sabali?” ");
INSERT INTO duo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ket inpakatandi ni Pelipe ide a surat ha libro na Dios, ket tulos a inpakatandi na i Mappiya a Baheta a megipu ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Niyaen, idi naglugan hidi, dinumemat hidi ha esa a lugar a keddinom. Ket kinagi na lallaki, “Atoy ha he i dinom. Mabalin bi a bunyaganak mo?” ");
INSERT INTO duo_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ket kinagi ni Pelipe, “Mabalin. Basta tahod dan i panahod mo.” Ket kinagi na lallaki, “Manahodak a ni Jesu-Cristu i annak na Dios.” ");
INSERT INTO duo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ket pinataran na lallaki i kalesa na. Ket binumugsok hidi a duwa ha dinom. Ket binunyagan na hikuna ni Pelipe. ");
INSERT INTO duo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sa, idi kaawas di ha dinom, bigu la a inalap na Espiritu na Dios ni Pelipe, a awan na manon naenta na taga-Egipto. Ket nagtulos i lallaki ha Etiyopiya a maragsak unay. ");
INSERT INTO duo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ket ha ni Pelipe, bigu la a atoy hikuna ha ili a Asoto. Ket nagtulos hikuna a maglakad, ket nagitoldu ha Mappiya a Baheta ha ngamin a ili hanggan ha Sesareya. ");
INSERT INTO duo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Niyaen, nagtulos pala ni Saulo a magpakanteng ha manahod a hidi ha ni Jesu-Cristu. Ta kayat na a magbuno ha nidi. Isu i gipu na a inumangay hikuna ha Katangkayan a Padi, ");
INSERT INTO duo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a nagaged ha surat a pangpakatandi ha baggi na ha magturay a hidi ha kapilya na Judyo, ha ili a Damasko. Ide a surat i pangpalobus ni Saulo a padakap na i maski nu heya a umuseg ha kagi ni Jesu-Cristu, ken mepabalud na i nagpasakop a hidi ha ni Jesus, maski babbey o maski nu lallaki, ken mepaangay na hidi ha pagbaludan, ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Niyaen, idi naglakad ni Saulo, idi binumikan hikuna ha Damasko, bigu la a atoy i silaw na langit a sinumiklab ha lebut ni Saulo. ");
INSERT INTO duo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ket natakneg ni Saulo ha lutak, ket nateman na i timek a nagkagi ha, “Saulo, Saulo, apay a lokowanak mo?” kagi na. ");
INSERT INTO duo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ket sinalodsod ni Saulo, “Heya ka, Apo?” Ket kinagi na timek, “Hikan ni Jesus i huhumen mo. ");
INSERT INTO duo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","En ka dan ha ili. Atoy hay i magpakagbi ha nikaw ha gimetan mos,” kon ni Jesus ha ni Saulo. ");
INSERT INTO duo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Niyaen, ha agagum ni Saulo, tinumaran hidi, ket awan hidi nagkagi. Nanteng hidi, ta nateman di i timek aye, ngem awan di naenta i nagkagi. ");
INSERT INTO duo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sa, inumikat ni Saulo a maglakad. Ngem idi inmotyah na i mata na, nabulsak hikuna! Isu a kinabitan di hikuna, a intugan di ha Damasko. ");
INSERT INTO duo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ha tallu a pamalak, awan hikuna nakaenta, ket awan bila nangan onu inuminum. ");
INSERT INTO duo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Niyaen, atoy ha Damasko i esa a lallaki a nanahod ha ni Jesus. Ni Ananiyas i nagen na. Ket nagpaenta ni Jesus ha nakam na. Kinagi ni Jesus, “Ananiyas!” Ket kinagi ni Ananiyas, “Anya, Apo?” ");
INSERT INTO duo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Umangay ka ha karsada a managenan ha ‘Nalinteg’,” kon ni Jesus. “Hen ka a magsalodsod ha bilay ni Judas. Ta atoy hito i esa a lallaki a taga-Tarso. Ni Saulo i nagen na. Ket magkararag hikuna. ");
INSERT INTO duo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Atoy a nepaenta ko ha nakam na. Ta inpaenta ko i esa a lallaki a magnagen ha Ananiyas a sinumadap, ket intupu na i kamat na ha nikuna, penu makaenta manon. Niyaen, Ananiyas, hikaw i lallaki a paangayan ko a mangikararag ha nikuna,” kon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ngem kinagi ni Ananiyas, “Apo, makpal i nabaheta ko megipu ha iday a lallaki, a madukas kan i ginimet na ha totolay mo ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ket niyaen, dinumemat hikuna ha Damasko, ta atoy kan i surat a nagipu ha Katangkayan a Papadi a pangpalobus na a mangdakap ha maski nu heya a manahod ha nikaw,” kon ni Ananiyas. ");
INSERT INTO duo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ket kinagi ni Jesus ha nikuna, “Umangay ka dan, ta hikuna i pinili ko a magserbe ha nikan. Ta ipakatandi na nokkan ha ngamin a kalase a tolay megipu ha nikan. Ipakatandi na ha nidi a bakkan a Judyo, ken maski ha nidi a maghari, ken ha nidi a kakabsat mo a Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ket hikan i mangipaenta ha nikuna i makpal a rigrigat a masapul a attaman na, penu mepakatandi na megipu ha nikan,” kon ni Apo Jesus. ");
INSERT INTO duo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Isu, inumangay ni Ananiyas, ket sinumadap ha iday a bilay. Ket intupo na i kamat na ha ni Saulo, a inpeta na, “Saulo a hekka ko, pinaangay na ak ni Apo Jesus. Hikuna i nagpaenta ha nikaw ha karsada. Ket niyaen, pinaangay na ak ha he, penu makaenta ka manon, ken penu makasaddap i Espiritu na Dios ha baggi mo,” kon ni Ananiyas. ");
INSERT INTO duo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ket bigu la, natakneg i kakallab, a kona ha keskes a nagipu ha mata ni Saulo, ket nakaenta manon hikuna. Sa hikuna, tinumaknag ket nagpabinyag. ");
INSERT INTO duo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ket nagkan hikuna, ket pinumigsa manon i baggi na. Idi kappal a pamalak, naghen ni Saulo ha Damasko a nakiagum ha totolay a manahod. ");
INSERT INTO duo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ket inumangay hikuna a nagitoldu megipu ha ni Jesus ha kapkapilya na Judyo a hidi. Kinagi na, “Ni Jesus, hikuna i annak na Apo Dios.” ");
INSERT INTO duo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ket nasbew hidi ngamin a nagteman ha ni Saulo. Kinagi di, “Agay, anya wade? Ide kan i lallaki a nangpaparigat ha totolay ha Jerusalem a manahod ha ni Jesus. Ket hikuna kan i dinumemat ha Damasko penu mapadakap na hidi, ket meyangay na kan hidi ha Katangkayan a Papadi,” kon na kakpalan a hidi ha Damasko. ");
INSERT INTO duo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ngem ha ni Saulo, pinumigsa i pinagitoldu na megipu ha ni Jesus. Ket awan natabbegan na Judyo a hidi ha Damasko. Ta nagpatahod ni Saulo a ni Jesus i Cristu a makesalakan ha totolay. ");
INSERT INTO duo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Niyaen, kobosan na makpal a pamalak, nakipaggayak i Judyo a hidi a bunowan di ni Saulo. ");
INSERT INTO duo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","25","Ket daponan di i ruwangan na ili ha kada pamalak ken kada kallap, penu patayan di hikuna nu lumapos. Ngem nabahetaan di Saulo megipu ha panggep di. Ket idi esa a kallap, indatton na hikuna na agagum na ha dakkal a basket. Ket inbugsok di ito ha abot na padding na ili. ");
INSERT INTO duo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Inumangay ni Saulo ha Jerusalem, a pinadas na a makiagum ha nidi a manahod ha ni Jesus, ngem nanteng hidi ha nikuna. Ta awan hidi nanahod a nagpasakop ni Saulo ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ket gipu ta kona hito, inumangay ni Bernabe a nagagum ha ni Saulo. Ket inyangay na ha apostol a hidi, a inpakatandi na nu panya i pinakaenta ni Saulo ha Apo Jesus ha karsada, ken panya i pinakikagi ni Apo ha nikuna, ken panya a natured ni Saulo a nagitoldu megipu ha ni Jesus ha Damasko. ");
INSERT INTO duo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Isu, naghen ni Saulo ha apostol a hidi. Ket naglakalakad hikuna a matured ha maski nu hadya ha Jerusalem, ket nangitoldu megipu ha ni Apo Jesus. ");
INSERT INTO duo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ket nakiuhon bila hikuna ha Judyo a hidi a nagkagi ha Griego, ket nakipagtabbegan hidi. Ngem naggayak bila hidi a magbuno ha ni Saulo. ");
INSERT INTO duo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ket idi nabahetaan na agagum ni Saulo, intugan di ha ili a Sesareya. Tulos, inpalugan di ha ili a Tarso. ");
INSERT INTO duo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Idi kobosan na hito, awan ha mangloko ha manahod a hidi a naghen ha probinsiya a Judeya, ken Galileya, ken Samariya. Pinumigsa hidi ha panahod di. Ket gipu ha daggap na Espiritu na Dios, kinumakpal hidi, ken perpermi i pinagdeydeyaw di. ");
INSERT INTO duo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ket niyaen, ha ni Pedro, atoy bila i nagimet ha nikuna. Idi naglakadlakad hikuna ha manahod a hidi, ha kada ili, pinasiyal na bila hidi ha ili a Lida. ");
INSERT INTO duo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ket atoy ha Lida i naenta na a esa a lallaki a pinilay. Ni Eneyas i nagen na. Napikot dan hikuna ha walu a tawen. Awan hikuna nakapalembok ha baggi na. ");
INSERT INTO duo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ket inpeta ni Pedro ha nikuna, “Eneyas, pahusayan na ka ni Jesu-Cristu. Umikat ka dan, ket lukutan mo i abak mo,” kon na. Ket ha ni Eneyas, bigu la a tinumaknag hikuna! ");
INSERT INTO duo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ket naenta na ngamin a tolay a taga-Lida ken Sarona, ket nanahod bila hidi ha ni Apo Jesus. ");
INSERT INTO duo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Niyaen, atoy bila ha ili a Joppe i esa a babbey a nanahod ha ni Jesus. I nagen na, ni Tabita. (Ha kagi na Griego, “Dorkas,” a kayat na kagiyan a “Kodmilan”.) Naanus hikuna, ken nahagkagbi ha totolay a napobre. ");
INSERT INTO duo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Niyaen, idi pinagpasyal ni Pedro ha ili a Lida, nagsaket ni Dorkas, ket natay. Ket kobosan na pinangdegus di ha bangkay na, intagmak di ha kuwarto ha ontok na bilay. ");
INSERT INTO duo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Niyaen, mabikan la i ili a Joppe ken ili a Lida. Isu, idi nabahetaan na manahod a hidi a atoy ni Pedro ha Lida, pinaangay di i duwa a lallaki a makeged ha ni Pedro, ha “Umangay ka bi ha Joppe ha sigida,” kon di. ");
INSERT INTO duo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Isu, naggayak ni Pedro, ket nakikuyog ha nidi. Idi pinagdemat ni Pedro, inyangay di hikuna ha kuwarto ha ontok na bilay. Ket atoy ho i makpal a babbey a nabilu, ket nagsangisanget hidi. Dinumulog hidi ha ni Pedro a paenta di i tetennon ken babadu a ginimet ni Dorkas para ha nidi, idi nagbiyag pala. ");
INSERT INTO duo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ngem pinalapos na hidi ni Pedro, ket nagparentumeng hikuna a nagkararag. Sa hikuna, sinumuleg ha bangkay, ket kinagi na, “Tabita, umikat ka dan.” Ket ha ni Dorkas aye, minumotyah hikuna. Ket idi naenta na ni Pedro, inumetnod. ");
INSERT INTO duo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Sa na, kinabitan ni Pedro i kamat na, ket pinataknag na. Ket inayagan na hidi a nabilu ken manahod a hidi, ket inpaenta na ni Dorkas a kebbiyag. ");
INSERT INTO duo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ket newaraswaras ide a nagimet ha ngamin a Joppe. Ket makpal hidi a nanahod ha ni Apo Jesus. ");
INSERT INTO duo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ket nakidagus ni Pedro ha naalay ha bilay ni Simon, a esa a mahagisagana na gaddang na hayup, ha iday a ili a Joppe. ");
INSERT INTO duo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Atoy idi, ha ili a Sesareya, i esa a lallaki a bakkan a Judyo. Ni Korneliyo i nagen na. Hikuna i kapitan na esa a gasut a sundalu, a Italiyano, a taga-Roma. ");
INSERT INTO duo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nakidios hikuna a nakangdeyaw ha Dios. Ket kona bila hito i pamilya na. Maski nu bakkan hidi a Judyo, nangatatad hidi ha Judyo a hidi a napobre. Ket nakangkararag hidi ha Dios. ");
INSERT INTO duo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Niyaen, idi esa a apon, atoy i naenta ni Korneliyo ha nakam na. Naenta na i anghel a naggipu ha Dios a binumikan ha nikuna. Ket kinagi na anghel, “Korneliyo”. ");
INSERT INTO duo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nagbulag ni Korneliyo, ta nanteng hikuna. Ket kinagi na, “Anya, Apo?” Ket kinagi na anghel, “Tineman na Dios i karkararag mo. Ket katandi na i pinagkagbi mo ha napobre a hidi. ");
INSERT INTO duo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","Isu, paangayan mo dan ha ili a Joppe a mangalap ha esa a lallaki a nagen na ni Simon Pedro. Hen hikuna ha baybay ayo, ha bilay di Simon a mahagisagana na gaddang na hayup,” kon na anghel. ");
INSERT INTO duo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Idi linumapos i anghel, inayagan ni Korneliyo i duwa a tagabu na, ken esa a sundalu a makidios bila. ");
INSERT INTO duo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ket inpeta na i kinagi na anghel. Ket pinaangay na hidi ha ili a Joppe. ");
INSERT INTO duo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Idi kaugman na, ha lubuk na pamalak, naglakad pala hidi, ket binumikan dan ha Joppe. Niyaen, ha iday a oras, inumunek ni Pedro ha atap na bilay di Simon penu magkararag. ");
INSERT INTO duo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nagiyalap ni Pedro, ket kayat na a magkan. Ngem idi magluto pala hidi ha kanan na, atoy i inpaenta na Dios ha nakam na, a kona ha pinagtagenap na hikuna na Dios. ");
INSERT INTO duo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Naenta ni Pedro a linumukat i langit, ket atoy a bumubugsok a kona ha dakkal a ulas, a nebaten ha uppat a suli na. ");
INSERT INTO duo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ket ha disalad na, atoy i ngamin a kalase na hayup, maski hidi a maglakad, ken hidi a manaktak, ken hidi a umebbar. ");
INSERT INTO duo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ket nateman ni Pedro i timek a nagkagi ha, “En ka dan Pedro. Alapan mo ken partiyan mo para kanan mo.” ");
INSERT INTO duo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ngem kinagi ni Pedro, “Awan mina, Apo. Maneg idagende a hidaan na Judyo. Awanak magkan ha kanan a kona hay, a maneg ha Judyo,” kon na. ");
INSERT INTO duo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ngem kinagi manon na timek, “Awan mo itulos a mangibilang ha madukas, ta pinappiya na dan na Dios,” kon na timek. ");
INSERT INTO duo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ket namintallu a beses a nagimet ito. Sa, nepaunek ha langit ide a ulas. ");
INSERT INTO duo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Niyaen, idi nanakaman pala ni Pedro megipu ha naenta na, dinumemat hidi a pinaangay ni Korneliyo. Nagsalodsod hidi nu hadya i bilay ni Simon a mahagkombang. Ket niyaen, nakataknag hidi a tallu ha ruwangan na bilay na. ");
INSERT INTO duo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ket sinalodsod di nu atoy ni Simon Pedro a nagdagus ha bilay aye. ");
INSERT INTO duo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ket nagnakanakam pala ni Pedro ha atap na bilay megipu ha naenta na. Ket kinagi na Espiritu na Dios ha nikuna, “Entan mo, Pedro, atoy i tallu a lallaki ha sidung a mageriyok ha nikaw. ");
INSERT INTO duo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Umugsad ka dan. Ket awan ka umadi a umuseg ha nidi, maski nu bakkan hidi a Judyo. Ta hikan i nagpaangay ha nidi ha nikaw,” kon na Espiritu na Dios. ");
INSERT INTO duo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Isu, inumugsad ni Pedro, ket inpeta na ha nidi, “Hikan ni Simon Pedro. Anya i kayat moy ipeta?” ");
INSERT INTO duo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ket kinagi di, “Pinaangay na kami ni Kapitan Korneliyo, penu iyangay mi ka ha bilay na. Mappiya ni Korneliyo ken makidios. Ket deyawan na hikuna na ngamin a Judyo. Niyaen, idi esa nakkapon, atoy i anghel na Dios a nangipeta ha nikuna a paawis na ka mina, ta atoy i metoldu mo ha nikami,” kon na lallaki a hidi. ");
INSERT INTO duo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Sa na, inawis ni Pedro a makidagus hidi ha bilay. Kaugman na, naggayak ni Pedro, ket inumuseg ha nidi. Inumuseg bila i kappal a manmanahod a taga-Jope. ");
INSERT INTO duo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Dinumemat hidi ha Sesareya ha umunod a pamalak. Nagtahok dan ni Korneliyo ha nidi, ket inawis na i ngamin a kabagis na ken ilailay na. ");
INSERT INTO duo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Idi sinumadap ni Pedro, sinalpak ni Korneliyo, a nagparentumeng ha saguppang na. Ta kayat na a magdeyaw ha ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ngem pinataknag na hikuna ni Pedro, a kinagi na, “Awan kas magdeyaw ha nikan! Tumaknag ka dan, ta magkalan kita. Hikan bi i tolay, a kona bila ha nikaw,” kon ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ket nakiuhon pala ni Pedro ken ni Korneliyo idi sumdap hidi ha bilay. Ket ha disalad na bilay, atoy i kakpalan a bakkan a Judyo, a nagpisan. ");
INSERT INTO duo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ket kinagi ni Pedro ha nidi, “Katandi moy dan i linteg mi a Judyo a makaliwat kan nu magpasiyal, onu makiagum i esa a Judyo ha maski nu heya a bakkan a Judyo. Ngem inpakatandi na Dios ha nikan a awan ko mina ibilang ha madukas i maski nu anya a kalase na tolay. ");
INSERT INTO duo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Isu, idi pinaayagan diyak, awanak inumadi. Niyaen, ipeta moy bi nu apay a inayaganak moy,” kon ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ket kinagi ni Korneliyo, “Idi nekkauppat a pamalak, idi alas tres ha apon, nagkararagak ha bilay mi aye. Ket bigu la a atoy a tinumaknag ha saguppang ko, i esa a lallaki a nagsiklab i tennon na. ");
INSERT INTO duo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ket kinagi na, ‘Korneliyo, tineman na Dios i karkararag mo, ket katandi na i kagbi mo ha napobre a hidi. ");
INSERT INTO duo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Isu, paangayan mo i tagabu mo a hidi ha Joppe, a mangayag ha esa a lallaki a nagen na ni Simon Pedro. Hen hikuna ha baybay, ha bilay di Simon a mahagkombang,’ kon na lallaki a masiklab. ");
INSERT INTO duo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Isu,” kinagi ni Korneliyo, “pinaayagan ta ka ha sigida. Ket maanus ka, ta dinumemat kam he. Niyaen, atoy kami ngamin, penu magteman ha maski nu anya a inpeta na Dios ha nikaw, a ipakatandi mo mina ha nikami. Ket atoy bila i Dios a magenta ha nikitam. Isu, magitoldu ka bi ha nikami,” kon ni Korneliyo. ");
INSERT INTO duo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ket kinagi ni Pedro, “Niyaen, makatandiyan ko a magkalan i kagbi na Dios ha maski nu heya a tolay, maski nu Judyo o maski nu bakkan a Judyo. ");
INSERT INTO duo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ta maski nu heya ha maski nu hadya a lugar, basta nu magdeyaw hidi ha Dios, ken maggimet hidi ha mappiya, alapan na hidi na Dios ha sakop na. ");
INSERT INTO duo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Inpakatandi na Dios i kakkagi na ha nikami a Judyo. Ket inpakatandi na ha nikami i Mappiya a Baheta megipu ha pakesalakan tam, a patalnaan ni Jesu-Cristu i kasasaad tam ha Dios. Hikuna i magturay ha ngamin, maski nu Judyo onu bakkan a Judyo. ");
INSERT INTO duo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","“Ket niyaen, newaraswaras ide a baheta ha ngamin a probinsiya a Judeya. Siguro nateman moy bila. Nangrugi ide a baheta ha probinsiya a Galileya, idi nagitoldu pala ni Juan a Minahagbinyag. ");
INSERT INTO duo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Sa, insadap na Dios i Espiritu na ha ni Jesus a taga-Nasaret, ket inyatad na ha nikuna i kaddat na. Ket gipu ta kona ha ide i pinagagum na Dios ha ni Jesus, linumakadlakad hikuna a nagpahusay ha totolay a pinaawag ni Satanas. Ket makpal pala i ginimet ni Jesus a pasig la mappiya. ");
INSERT INTO duo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ket niyaen, hikami i mangpatahod. Ta naenta mi dan i ngamin a ginimigimet na ha lugar na Judyo a hidi ken ha Jerusalem. Jerusalem i nangpatayan di, idi inlansa di hikuna ha kudos. ");
INSERT INTO duo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Ngem pinabiyag na manon na Dios ha nekatallu a pamalak. Tulos, inpaenta na hikuna ha nikami a pinili na a mangpatahod mina. Ket nakipagkan kami ken ni Jesus, idi minagbiyag manon hikuna. Awan pinasaguppang na Dios ni Jesus ha ngamin a tolay nu awan la a hikami. ");
INSERT INTO duo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ket binon na kami a magitoldu, ken mangpatahod, a hikuna i pinili na Dios a maghukom ha ngamin a tolay, maski ha nidi a minatay dan ken ha nidi a kebbiyag pala. ");
INSERT INTO duo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","“Ni Jesu-Cristu i inbaheta na ngamin a minahagpugto. Ket nagitoldu hidi a maski nu heya a manahod ha nikuna, mapakawan na Dios i liwaliwat na gipu ha ni Jesus.” Ito i intoldu ni Pedro ha nidi a bakkan a Judyo. ");
INSERT INTO duo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Idi magkagi pala ni Pedro, sinumadap i Espiritu na Dios ha ngamin a nagteman. ");
INSERT INTO duo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ket nalaktat i Judyo a hidi a agagum ni Pedro. Ta inyatad na bila na Dios i Espiritu na ha sabasabali a tolay, maski ha nidi a bakkan a Judyo. ");
INSERT INTO duo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ket nakatandiyan di Judyo hito, ta nateman di a nagkakagi hidi ha kagi na Espiritu, a awan di nakatandiyan. Ket nagdeydeyaw hidi ha Dios. Sa na, kinagi ni Pedro ha agagum na heya, ");
INSERT INTO duo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Inyatad na Dios i Espiritu na ha nidi a bakkan a Judyo, a kona idi inyatad na ha nikitam. Isu, awan ha makekemot a magpabinyag hidi, a magpasakop hidi ha ni Jesus.” ");
INSERT INTO duo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Sa na, inbon ni Pedro a mabinyagan hidi ha sakop ni Jesu-Cristu. Ket idi nabinyagan dan hidi, inaged di a makipaghen di Pedro ha Sesareya ha kappal pala a pamalak. ");
INSERT INTO duo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Niyaen, ha probinsiya a Judeya, nabaheta na apostol ken manmanahod a hidi a nanahod bila ha kagi na Dios i kappal a tolay a bakkan a Judyo. ");
INSERT INTO duo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ket idi sinumoli ni Pedro ha Jerusalem, atoy i kappal ha nidi a nagbahang ha nikuna. Ta kayat di a magpajudyo ha maski nu heya a masakop ni Jesu-Cristu. ");
INSERT INTO duo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Apay?” kinagi di ha ni Pedro, “Sinumadap ka ha bilay na tolay a bakkan a Judyo, ket nakipagkan, maski awan hidi magtongpal ha linteg ni Moyses. Nagliwat ka ha linteg tam,” kon di. ");
INSERT INTO duo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Isu, binon ni Pedro i ngamin a nagimet, maski idi karugi na. ");
INSERT INTO duo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Kinagi na, “Idi nagkakararagak, idi naghenak ha ili a Joppe, ket pinagtagenap na ak na Dios. Ket naenta ko i dakkal a ulas a nepabugsok ha uppat a suli na a nagipu ha langit. Ket nagdissu ito ha hikeg ko. ");
INSERT INTO duo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Inaamatan ko ha disalad na, ket naenta ko i makpal a kalase a hayup, maski hidi a mangkatandi, ken hidi a maingal, hidi a manaktak, ken idagende a mailam a manok. ");
INSERT INTO duo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Sa ko, nateman i timek a nagkagi ha nikan, ‘Alan, Pedro, alapan mo dan. Partiyan mo para kanan mo.’ ");
INSERT INTO duo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ngem kinagi ko, ‘Awan, Apo. Awanak magkan ha kanan a madukas, ta maneg idagenday ha linteg na Judyo.’ ");
INSERT INTO duo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ngem kinagi manon na timek ha langit, ‘Awan mos ibilang ha madukas i maski nu anya a ibilang na Dios ha mappiya,’ kon na. ");
INSERT INTO duo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ket nagimet ito ha namintallu. Sa, neyunek i ngamin ha langit. ");
INSERT INTO duo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Niyaen, ha iday a mismo a oras, dinumemat ha bilay a nagdagusan ko i tallu a lallaki. Nepaangay kan hidi a mangitugan ha nikan ha ili a Sesareya. ");
INSERT INTO duo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ket inpeta na Espiritu na Dios a awanak mina umadi a umuseg ha nidi, maski nu bakkan hidi a Judyo. Isu, inumusegak ha bilay na esa a lakay a bakkan a Judyo. Ni Korneliyo i nagen na. Ket kinumuyog ha nikan idagende a annam a agum ko. Taga-Jope hidi, ket manahod bila hidi ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ket ha ni Korneliyo, binoyboy na a nagpaenta kan i esa a anghel ha disalad na bilay na. Ket kinagi na kan na anghel, ‘Paangayan mo ha ili a Joppe i tagabu mo a mangalap ha esa a lallaki a nagen na ni Simon Pedro. ");
INSERT INTO duo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mangitoldu hikuna nu panya a mesalakan kam ken ngamin a maghen ha bilay mo,’ kon na kan na anghel. ");
INSERT INTO duo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Niyaen, idi karrugi ko a mangitoldu, sinumadap ha nidi i Espiritu na Dios, a kona bila ha pinagsaddap na ha nikitam, idi palungo. ");
INSERT INTO duo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Sa ko, nanakam i kinagi ni Apo Jesus, a ‘Dinom i pinangbinyag ni Juan ha totolay. Ngem bakkan ha nikan. I Espiritu na Apo Dios i pangbinyag ko ha nikam nokkan,’ kon na. ");
INSERT INTO duo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","“Niyaen,” kon ni Pedro, “maganyaak dod? Sigurado a inyatad na Dios ha nidi a kona ha inyatad na ha nikitam, idi nagpasakop kitam ha ni Apo Jesu-Cristu. Isu, awan ko kaya a mangikemot ha nidi, ta kayat na Dios a mangiyatad.” Ide i binoyboy ni Pedro ha ilailay na a Judyo. ");
INSERT INTO duo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ket idi nateman di i pinagboyboy ni Pedro, awan hidi nagbahang, ket nagdeyaw hidi ha Dios. Kinagi di, “Isu, pinagbabawi na hidi na Dios, penu pumadas bila hidi ha biyag a magnanayon, maski nu bakkan hidi a Judyo,” kon di. ");
INSERT INTO duo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Niyaen, idi pinagbuno di Judyo ha ni Esteban, nalokowan bila i manahod a hidi. Ket gipu ta kona hito, nagsinasina hidi. Ket inumangay i kappal hanggan ha lugar a Penisiya, ken kappal ha ili a Sipre, ken kappal ha ili a Antiokiya. Ket intoldu di i baheta a megipu ha ni Jesus. Ngem i Judjudyo la i nangibahetaan di. ");
INSERT INTO duo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ngem atoy i kappal a manahod a taga-Sipre ken taga-Sirene. Ket idi dinumemat hidi ha Antiokiya, intoldu di ha Griego a hidi megipu ha pagturay ni Apo Jesus. ");
INSERT INTO duo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ket atoy ha nidi i kaddat na Dios. Isu, makpal i nanahod ken nagpasakop ha ni Apo Jesus. Nanahod hidi, maski nu bakkan hidi a Judyo. ");
INSERT INTO duo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Niyaen, idi nabahetaan na manahod a hidi ha Jerusalem, pinaangay di i esa a lallaki ha Antiokiya a mangenta. I nagen na, ni Bernabe. ");
INSERT INTO duo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Idi pinagdemat na, naragsakan hikuna a makaenta ha kagbi na Dios ha nidi a manahod. Ta mappiya ni Bernabe, ket kanayon hikuna a peturayan ha Espiritu na Dios. Ket napigsa i panahod na. Ket napapigsa na hidi ha kakkagi na, a umusoseg mina hidi ha ni Apo Jesus, ket magserbe mina hidi ha ni Apo Jesus ha ngamin a baggi di. Kona hito i kakkagi ni Bernabe ha nidi. Ket nenayon paman i makpal a tolay ha sakop ni Apo Jesus. ");
INSERT INTO duo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ket inumangay ni Bernabe ha ili a Tarso, penu mageriyok ha ni Saulo. ");
INSERT INTO duo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Idi naeriyokan na, inyangay na hikuna ha Antiokiya. Ket naghen hidi ho ha esa a tawen a nakipagpisan ken nagitoldu ha makpal a tolay. Ket ha nidi a taga-Antiokiya a nanahod ha ni Jesus, hidi i nekaesa a nanagenan ha Cristiyano. ");
INSERT INTO duo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Niyaen, idi tiyempo hito, dinumemat ha Antiokiya i kappal a mahagpugto a naggipu ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ni Agabo i nagen na esa, ket tinumaknag hikuna ha pagmitingan di, ket gipu ha kaddat na Espiritu na Dios, inpugto na a atoy i dakkal a alap a dandani dan dumemat ha ngamin a lutak. (Ket nagimet ito idi tiyempo ni Hari Klaudiyo.) ");
INSERT INTO duo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Isu, ninakam na manahod a hidi a mangipatawed ha korinat ha kakalan di a manahod a naghen ha Judeya. Ket inyatad na kada esa ayun ha kaya na. ");
INSERT INTO duo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Sa di, inpatawed i korinat aye ha panglakayan a hidi ha kapilya ha Jerusalem. Ni Bernabe ken ni Saulo i pinangitugan di. ");
INSERT INTO duo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Idi tiyempo hito, atoy i kappal a manahod a linoko ni Hari Herod. ");
INSERT INTO duo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ket pinaputolan na ni Santiyago a hekka ni Juan. ");
INSERT INTO duo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Idi naenta ni Herod a naragsakan i Judyo a hidi, pinadakap na bila ni Pedro. (Nagimet ito idi Piyesta na Tinapay a awan ha Lebadura na.) ");
INSERT INTO duo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Idi pinadakap na ni Pedro, inpabalud na hikuna. Sa na, pinadappon hikuna ha esa pulo ket annam a sundalu. (Uppat a gurupo hidi. Taguppat a sundalu ha kada gurupo.) Ket pinanggep ni Herod a ilapos na ni Pedro nu kobosan na piyesta, penu ipasaguppang na ha Judyo a hidi, ket mapatay di mina ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Isu, nebalud ni Pedro ha pagbaludan. Ngem ha nidi a manahod, nakangkararag hidi. ");
INSERT INTO duo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Idi esa a kallap, kinumillap ni Pedro ha ballog na duwa a sundalu. Ket nagakadan hikuna ha duwa a kawar. Atoy bila i sundalu a nagdapon ha ruwangan na pagbaludan. Ket nokkan kaugman na, bital dan a pamalak a ilapos na mina ni Hari Herod, penu papappatay na mina ha Judyo a hidi. ");
INSERT INTO duo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ket bigu la a dinumemlag i kuwarto a pagkilapan ni Pedro, ta atoy i esa a anghel na Apo Dios a tinumaknag he. Ket yinagyag na anghel i abigi ni Pedro a kinakagi na, “Sigida kas, Pedro, umikat ka dan.” Ket bigu la a natakneg i kawar ha kamat ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Sa, kinagi na anghel, “Alan, magbadu ka dan, ket magsapatos ka.” Ket nagtongpal ni Pedro. Ket kinagi manon na anghel, “Alan agay, magkagay ka, ket umuseg ha nikan.” ");
INSERT INTO duo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ket inumuseg ni Pedro ha anghel a linumapos ha pagbaludan, ngem awan na nakatandiyan nu tahod i gimetan na anghel. Ta kagin na a tagenap la. ");
INSERT INTO duo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Naglakad hidi, ket sinalenan di i nekaesa a gurupo a sundalu a nagdapon, sa, nekaduwa a gurupo a sundalu a nagdapon. Sa hidi, dinumemat ha ruwangan a utang a pagsaddappan ha ili. Ket naglukat i ruwangan, ket linumapos hidi. Ket naglakad hidi ha karsada, ket bigu la a inumawan dan i anghel. ");
INSERT INTO duo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Sa na, nakatandiyan ni Pedro a awan hikuna nagtagenap. Kinagi na ha nakam na, “Agay, tahod a pinaangay na Dios i anghel na, a mangisalakan ha nikan ha turay ni Herod ken ngamin a panggep na Judyo a hidi,” kon na. ");
INSERT INTO duo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Idi nakatandiyan ni Pedro, nagtulos hikuna ha bilay di Maria a hena ni Juan Markos. Ta atoy ayo i makpal a tolay a nagpisan a magkararag. ");
INSERT INTO duo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nagtuktuk ni Pedro ha ruwangan na bilay di, ket sinalpak na esa a tagabu a madiket. Ni Roda i nagen na. ");
INSERT INTO duo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nelassin na i timek ni Pedro, ngem awan na linukatan gipu ha ragsak na. Binumuyot la hikuna a mangibaheta a atoy ni Pedro ha ruwangan. ");
INSERT INTO duo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ket kinagi di, “Magmaoyung ka wade!” Ngem inpapilit na a atoy hikuna a tahod. Ket kinagi di a baka atoy i anghel na Dios a mahagdapon ha ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Niyaen, nagtutuktuk pala ni Pedro. Idi kallukat di, ket naenta di a atoy hikuna a tahod, nasbew hidi. ");
INSERT INTO duo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ngem winahiyan na hidi a awan mina magkagi. Ket binoyboy na nu panya a napalapos na hikuna na Dios ha pagbaludan. Sa na, inpeta a ibaheta di mina ito ha di Santiyago ken agagum di. Sa hikuna, linumakad ha sabali a lugar. ");
INSERT INTO duo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Idi kaugman na, naliwaliwat unay i sundalu a hidi, nu hadya ni Pedro. ");
INSERT INTO duo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pinaeriyok ni Herod ni Pedro, ngem awan di naeriyokan. Isu, pinasalodsod na ha sundalu a hidi a nagdapon. Ket inbon na a mapatay hidi. Kobosan na, linumapos ni Herod ha probinsiya a Judeya, ket naghen hikuna ha ili a Sesareya. ");
INSERT INTO duo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Niyaen, idi naghen ni Herod ha ili a Sesareya, atoy a inumangay ha nikuna i esa a gurupo na tolay a taga-Tiro ken Sidon. Niyaen, nakaingal ni Herod ha totolay a taga-Tiro ken Sidon. Ket nagburibur dod hidi. Ta pagiyalapan di ha kakkanan di i paghariyan ni Herod. Isu, pinakiilay di dan ni Blasto, a tagabu ni Herod a nagturay ha kukuwa na. Ket kinayat di a makipagtalna ha ni Herod. ");
INSERT INTO duo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Isu, idi pamalak a pangsalpak di ha ni Herod, nagtennon ni Herod ha mangina a tennon. Ket inumetnod hikuna ha saguppang di ha matangkay a pagetnodan na. Ket idi pinagbalikas na, ");
INSERT INTO duo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","dineydeyaw na tolay a hidi, a “Bakkan a tolay la hikuna,” kon di, “ta kona ha Dios i kakkagi na!” ");
INSERT INTO duo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ket bigu la a pinasaketan na hikuna na anghel na Dios, ta awan na pinadeyawan i Dios. Ket inuhad hikuna hanggan a natay dan. ");
INSERT INTO duo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ket idi tiyempo hito, nagtutulos i kagi na Dios a newaraswaras, ket kinumakpal i nanahod a hidi. ");
INSERT INTO duo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ket ha ni Bernabe ken ni Saulo, idi natongpal di i tinawed di ha Jerusalem, nagsoli hidi. Ket inkuyog di ni Juan Markos ha ili a Antiokiya. ");
INSERT INTO duo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Niyaen, ha kapilya na manahod a hidi, ha ili a Antiokiya, atoy i kappal a mahagpugto ken kappal a mahagidatton ha gurupo di. I nagen di, ni Bernabe, ken ni Simyon Mangiset, ken ni Lusiyo a taga-Sirene, ken ni Saulo, ken ni Manaen i katalupog ni Gobernador Herodes. ");
INSERT INTO duo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Idi esa a pamalak, nagpisan hidi a nagdeydeyaw ha Dios. Ket pinabiyan di a magkan, penu makangkararag hidi. Ket inpeta ha nidi na Espiritu na Dios, “Piliyan moy ni Bernabe ken ni Saulo, a ibukod moy hidi, penu gimetan di i tarabaho a ingayak ko dan ha nidi,” kon na. ");
INSERT INTO duo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sa hidi, inumadi pala a magkan, ket nagtulos hidi a magkararag. Ket intupo di i kamat di ha ni Bernabe ken ni Saulo, ket inkararagan di hidi. Sa di, pinalakad hidi. ");
INSERT INTO duo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Pinaangay na dod na Espiritu na Dios ni Bernabe ken ni Saulo. Ket inumangay hidi ha ili a Selusiya, ket naglugan hidi ha abang hanggan ha puro a Sipre. ");
INSERT INTO duo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Idi kaddemat di ha ili a Salamina, intoldu di i kagi na Dios ha kapkapilya na Judyo a hidi. Ket inumuseg bila ni Juan Markos a nagdaggap ha nidi. ");
INSERT INTO duo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Niyaen, naglakadlakad hidi ha puro a Sipre hanggan ha ili a Papus. Ket ha Papus, kinettagbuwan di i esa a Judyo a salamangkero ken aginmahagpugto. Ni Barjesus i nagen na. ");
INSERT INTO duo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hikuna i ilay na gobernador na ide a puro, a ni Sergiyo Paulo, a esa a malaing a lallaki. Ket nagpaayag i Gobernador aye ha ni Bernabe ken ni Saulo, ta kayat na a magteman ha kagi na Dios. ");
INSERT INTO duo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ngem pinadas na salamangkero a mangikemot ha nidi. (Elimas i nagen na salamangkero he, ha kagi na Griego.) Ket pinadas na unay a mangsalen ha kagi di megipu ha ni Jesus, penu awan manahod i Gobernador. ");
INSERT INTO duo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ngem ha ni Saulo, (onu Pablo i sangay na), nagturay manon i Espiritu na Dios ha baggi na. Ket inaamatan ni Pablo ni Elimas, ");
INSERT INTO duo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","a kinagi na, “Hikaw i kaaheg ni Satanas! Makangsenti ka ha maski nu anya a mappiya! Pasig la a madukas i gimetan mo. Ket kanayon a pakilluwan mo i kinatahod na Apo Dios. ");
INSERT INTO duo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Niyaen, dissowan na ka na kamat na Dios. Ket magbulsak ka, a awan mo maenta ha maalay a tiyempo,” kon ni Pablo. Ket bigu la a dinumiklam i pagimata ni Elimas. Sa hikuna, nagkapotkapot ha mangkabit mina ha nikuna. ");
INSERT INTO duo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ket idi naenta ni Gobernador i nagimet aye, nanahod hikuna ha ni Jesus. Ket nasbew hikuna ha pagitoldu di megipu ha Apo Dios. ");
INSERT INTO duo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Sa hidi, linumapos di Pablo ha ili a Papus, a naglugan hidi ha bapor hanggan ha ili a Perga, ha probinsiya a Pampiliya. Ngem idi kaddemat di ho, sinumina ni Juan Markos, a nagsoli ha Jerusalem. ");
INSERT INTO duo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ket tinumulos di Pablo ha ili a Antiokiya, ha probinsiya a Pisidiya. Ket idi Sabado dan, sinumdap hidi ha kapilya na Judyo a makipaggimong. ");
INSERT INTO duo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ket kobosan na pinagbasa di ha Linteg ni Moyses ken sursurat na minahagpugto a hidi, pinaayag na panglakayan a hidi ha di Pablo, a mangitoldu mina, nu atoy i kayat di a itoldu. ");
INSERT INTO duo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Isu, tinumaknag ni Pablo, ket inwahi na a kayat na a magkagi. Kinagi na, “Kakabsat a taga-Israel, ken ilailay ko a taga-Pisidiya a makidios, atoy i kayat ko a ipeta ha nikam. ");
INSERT INTO duo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","I Dios a panahodan na totolay na Israel, hikuna i nangpili ha minappo tam nikuna. Ket pinakakpal na hidi, idi naghen hidi a kona ha ganggannaet ha bayan a Egipto. Ket pinalapos na hidi na Dios gipu ha dakkal a kaddat na. ");
INSERT INTO duo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ket ha lubuk na uppat a pulo a tawen, inanusan na hidi ha kakasaw a lugar, a kona ha maanus a hama a magaben ha annak na. ");
INSERT INTO duo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ket inabak na i pitu a bayan ha lugar a Kanaan, ket inyatad na iday a lutak ha minappo tam. ");
INSERT INTO duo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ket uppat a gasut ket lima a pulo a tawen i tiyempo ito, idi nangrugi hidi a inumangay ha bayan a Egipto, hanggan inalap di i bayan a Kanaan. “Ket pinili na Dios i hukom a hidi a nagturay ha minappo tam hanggan ha tiyempo ni Samwel a minahagpugto. ");
INSERT INTO duo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ket inaged na minappo tam a hari mina i magturay ha nidi, kon di. Ket pinili na Dios i esa a lallaki a naggipu ha kaputotan ni Benjamin. Ni Saulo i nagen na, a annak ni Kis. Hikuna i hari na Israel ha lubuk na uppat a pulo a tawen. ");
INSERT INTO duo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ket inadya na Dios ni Saulo, ket pinili na ni Dabid a maghari ha Israel. Ket ide i kinagi na Dios megipu ha ni Dabid, ‘Matalakak ha ni Dabid, a annak ni Jesse. Ta hikuna i magtongpal ha ngamin a pagayatan ko,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Intulos ni Pablo, “Niyaen, gipu ha kaputotan ni Dabid, tinongpal na Dios i kari na, ta atoy i mahagsalakan ha totolay na Israel. Ket Jesus i nagen na, a apo ni Dabid. ");
INSERT INTO duo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Idi palungo na pagdemat ni Jesus, atoy ni Juan a minahagbinyag ha totolay na Israel. Ket gipu ha pinagitoldu na, pinaggayak na hidi ha pagdemat ni Jesus. Nagitoldu ni Juan a magbabawi kitam mina ha liwaliwat tam, ket magpabinyag kitam a sumina ha madukas a ugali tam. ");
INSERT INTO duo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ket idi dandani a mobos ni Juan i tarabaho na, kinagi na, ‘Kagin moy a hikan i Cristu a inkari na Dios a magturay ha nikam, ngem awan man. Ta dumemat pala nokkan i Cristu, ket mas matangkay hikuna ngem ha nikan. Nu ikalanak moy ha nikuna, awanak ha balle, ta hikuna i tahod a mangisalakan ha nikitam,’ kon ni Juan.” ");
INSERT INTO duo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ket intulos ni Pablo, “Kakabsat a appo ni Abraham, ken hikam a makidios, maski nu bakkan kam a Judyo. Timon moy bi! Ta pinaangay na Dios ha nikitam ngamin ide a baheta megipu ha pakesalakanan tam. ");
INSERT INTO duo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ket niyaen, mepakatandi ko ha nikam. Ta idi napatay ni Jesus ha Jerusalem, awan nakatandiyan na Judyo a hidi i ginimet di. Maski i panglakayan a hidi, awan di nakatandiyan a ni Jesus i pakesalakanan tam. Ket awan di nakatandiyan i kagi na minahagpugto a hidi, maski nu basaan di ha kada Sabado. Ket gipu ta kona hito, natongpal malla idagenday a pugto, idi pinanghukom di ni Jesus, gipu ta awan di nakatandiyan. Awan di nakatandiyan a nakatongpal hidi ha pupugto heya. ");
INSERT INTO duo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ket maski nu awan ha rason di, inaged di ha ni Pilato a ipapatay na ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ket idi natongpal i ngamin a pugto a nesurat ha Libro na Dios megipu ha ni Jesus, neogsad i bangkay na ha kudos, ket nelabbang. ");
INSERT INTO duo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ngem pinabiyag na hikuna na Dios. ");
INSERT INTO duo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ket ha makpal a pamalak a nagpapaenta hikuna ha agagum na a inumuseg ha nikuna, idi naggipu hidi ha Galileya hanggan ha Jerusalem. Ket niyaen, hidi i mangpatahod ha totolay na Israel a minagbiyag manon ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Niyaen, inumangay kami ha lugar moy, penu ibaheta mi ide a Mappiya a Baheta a inkari na Dios ha minappo tam. ");
INSERT INTO duo_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ket niyaen, tinongpal na ha nikitam a appo di, ta pinaangay na ni Jesus a mangisalakan ken magturay ha nikitam. Ta kona ide a nepugto ha nekaduwa a Kansiyon na Dios. Nesurat, a ‘Hikaw i anak ko,’ kagi na Dios, ‘ket ha yenan a pamalak, ipaenta ko a hikan i hama mo,’ kon na Dios. ");
INSERT INTO duo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","35","“Ket ide paman i inkari na Dios megipu ha Cristu, ken nesurat ha Kakansiyon na Dios. Inkari na a pabiyagan manon na Dios ni Cristu, ket awan hikuna matay manon. Ta nepugto ni Dabid ha Kakansiyon, ‘Awan mo palobusan a mahunot ha labbang i bangkay na Kristu,’ kon na. Ket nesurat bila ha Kansiyon na Dios, ‘Gimetan ko ha nikaw i ngamin a inkari ko ha ni Dabid,’ kon na Dios.” ");
INSERT INTO duo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ket intulos ni Pablo, “Kakabsat ko ken ilailay ko, makatandiyan tam a awan megipu ha ni Dabid idagende a kakkagi. Ta natay ni Dabid, idi natongpal na i biyang na ha Dios ha iday a tiyempo. Ket nelabbang i bangkay na ha paglabbangan na minappo na a hidi. Ket sigurado a nahunot i bangkay na. ");
INSERT INTO duo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ngem ha ni Jesus a pinabiyag manon na Dios, awan mahunot i baggi na. Ta ni Jesus i Cristu a inkari na Dios. ");
INSERT INTO duo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Isu, kakabsat ko ken ilailay ko, ipakatandi ko ha nikam a mapakawan na Dios i liwaliwat tam gipu ha ni Jesus. ");
INSERT INTO duo_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Maski ha Linteg ni Moyses, awan na kay